/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.Environment;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonProcessingException;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.JsonNode;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineageEnvParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenLineageEnvParser.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String PREFIX = "OPENLINEAGE__";

    public static String parseAllOpenLineageEnvVars() throws JsonProcessingException {
        ObjectNode root = objectMapper.createObjectNode();
        Map<String, String> env = Environment.getAllEnvironmentVariables();
        env.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(PREFIX)).sorted(Map.Entry.comparingByKey(Comparator.reverseOrder())).map(entry -> {
            String envKey = (String)entry.getKey();
            String envValue = (String)entry.getValue();
            try {
                return OpenLineageEnvParser.parseEnvToNestedJson(envKey, envValue);
            }
            catch (Exception e) {
                log.warn("Failed to parse environment variable: {}", (Object)envKey);
                return null;
            }
        }).filter(Objects::nonNull).forEach(parsedJson -> OpenLineageEnvParser.merge(root, parsedJson));
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(root);
    }

    private static ObjectNode parseEnvToNestedJson(String envKey, String envValue) throws Exception {
        ObjectNode root;
        JsonNode valueNode;
        String strippedKey = envKey.substring(PREFIX.length());
        List keyParts = Stream.of(strippedKey.split("__")).map(String::toLowerCase).map(OpenLineageEnvParser::convertSnakeCaseToCamelCase).collect(Collectors.toList());
        try {
            valueNode = objectMapper.readTree(envValue);
        }
        catch (JsonProcessingException e) {
            valueNode = objectMapper.convertValue((Object)envValue, JsonNode.class);
        }
        ObjectNode currentNode = root = objectMapper.createObjectNode();
        for (int i = 0; i < keyParts.size() - 1; ++i) {
            ObjectNode nextNode = objectMapper.createObjectNode();
            currentNode.set((String)keyParts.get(i), nextNode);
            currentNode = nextNode;
        }
        currentNode.set((String)keyParts.get(keyParts.size() - 1), valueNode);
        return root;
    }

    private static String convertSnakeCaseToCamelCase(String value) {
        if (value.indexOf(95) == -1) {
            return value;
        }
        String initialPart = value.substring(0, value.indexOf(95));
        String secondPart = Arrays.stream(value.substring(value.indexOf(95) + 1).split("_")).map(s2 -> Character.toUpperCase(s2.charAt(0)) + s2.substring(1)).collect(Collectors.joining());
        return initialPart + secondPart;
    }

    private static void merge(ObjectNode mainNode, ObjectNode updateNode) {
        updateNode.fields().forEachRemaining(entry -> {
            String fieldName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (!mainNode.has(fieldName)) {
                mainNode.set(fieldName, value);
                return;
            }
            JsonNode existingValue = mainNode.get(fieldName);
            if (existingValue.isObject() && value.isObject()) {
                OpenLineageEnvParser.merge((ObjectNode)existingValue, (ObjectNode)value);
                return;
            }
            mainNode.set(fieldName, value);
        });
    }

    public static boolean OpenLineageEnvVarsExist() {
        return Environment.getAllEnvironmentVariables().entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).startsWith(PREFIX));
    }
}

