/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryErrorCode;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.StatusException;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.StatusRuntimeException;

public class BigQueryConnectorException
extends RuntimeException {
    final BigQueryErrorCode errorCode;

    public BigQueryConnectorException(String message) {
        this(BigQueryErrorCode.UNKNOWN, message);
    }

    public BigQueryConnectorException(String message, StatusException cause) {
        this(message, new SerializableStatusException(cause));
    }

    public BigQueryConnectorException(String message, StatusRuntimeException cause) {
        this(message, new SerializableStatusException(cause));
    }

    public BigQueryConnectorException(String message, Throwable cause) {
        this(BigQueryErrorCode.UNKNOWN, message, cause);
    }

    public BigQueryConnectorException(BigQueryErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public BigQueryConnectorException(BigQueryErrorCode errorCode, String message, StatusException cause) {
        this(errorCode, message, new SerializableStatusException(cause));
    }

    public BigQueryConnectorException(BigQueryErrorCode errorCode, String message, StatusRuntimeException cause) {
        this(errorCode, message, new SerializableStatusException(cause));
    }

    public BigQueryConnectorException(BigQueryErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public BigQueryErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static class SerializableStatusException
    extends RuntimeException {
        private final String wrappedExceptionClassName;
        private final String message;
        private final StackTraceElement[] stackTrace;

        SerializableStatusException(StatusException wrapped) {
            this.wrappedExceptionClassName = wrapped.getClass().getName();
            this.message = wrapped.getMessage();
            this.stackTrace = (StackTraceElement[])wrapped.getStackTrace().clone();
        }

        SerializableStatusException(StatusRuntimeException wrapped) {
            this.wrappedExceptionClassName = wrapped.getClass().getName();
            this.message = wrapped.getMessage();
            this.stackTrace = (StackTraceElement[])wrapped.getStackTrace().clone();
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String toString() {
            return this.wrappedExceptionClassName + ": " + this.message;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }
    }

    public static class InvalidSchemaException
    extends BigQueryConnectorException {
        public InvalidSchemaException(String message) {
            super(BigQueryErrorCode.BIGQUERY_INVALID_SCHEMA, message);
        }

        public InvalidSchemaException(String message, Throwable t2) {
            super(BigQueryErrorCode.BIGQUERY_INVALID_SCHEMA, message, t2);
        }
    }
}

