/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.ArrowBuf;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.ReusableBuffer;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.ArrowBufPointer;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.ByteFunctionHelpers;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.CommonUtil;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.LargeMemoryUtil;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BaseValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BitVectorHelper;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BufferBacked;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.FieldVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.VariableWidthFieldVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compare.VectorVisitor;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.Field;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.CallBack;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.DataSizeRoundingUtil;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.OversizedAllocationException;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.TransferPair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseVariableWidthViewVector
extends BaseValueVector
implements VariableWidthFieldVector {
    public static final int ELEMENT_SIZE = 16;
    public static final int INITIAL_VIEW_VALUE_ALLOCATION = 4096;
    private static final int INITIAL_BYTE_COUNT = 65536;
    private static final int MAX_BUFFER_SIZE = (int)Math.min(MAX_ALLOCATION_SIZE, Integer.MAX_VALUE);
    private int lastValueCapacity;
    private long lastValueAllocationSizeInBytes;
    public static final int INLINE_SIZE = 12;
    public static final int LENGTH_WIDTH = 4;
    public static final int PREFIX_WIDTH = 4;
    public static final int BUF_INDEX_WIDTH = 4;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected ArrowBuf validityBuffer;
    protected ArrowBuf viewBuffer;
    protected List<ArrowBuf> dataBuffers;
    protected int initialDataBufferSize;
    protected int valueCount;
    protected int lastSet;
    protected final Field field;

    public BaseVariableWidthViewVector(Field field, BufferAllocator allocator) {
        super(allocator);
        this.field = field;
        this.lastValueAllocationSizeInBytes = 65536L;
        this.lastValueCapacity = 4096;
        this.valueCount = 0;
        this.lastSet = -1;
        this.validityBuffer = allocator.getEmpty();
        this.viewBuffer = allocator.getEmpty();
        this.dataBuffers = new ArrayList<ArrowBuf>();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        return this.viewBuffer;
    }

    public List<ArrowBuf> getDataBuffers() {
        return this.dataBuffers;
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException("Offset buffer is not supported in BaseVariableWidthViewVector");
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException("Offset buffer is not supported in BaseVariableWidthViewVector");
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        return this.viewBuffer.memoryAddress();
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 16L;
        this.checkDataBufferSize(size);
        this.lastValueAllocationSizeInBytes = (int)size;
        this.lastValueCapacity = valueCount;
    }

    @Override
    public void setInitialCapacity(int valueCount, double density) {
        long size = (long)valueCount * 16L;
        this.initialDataBufferSize = (int)((double)valueCount * density);
        this.checkDataBufferSize(size);
        this.lastValueAllocationSizeInBytes = (int)size;
        this.lastValueCapacity = valueCount;
    }

    public double getDensity() {
        if (this.valueCount == 0) {
            return 0.0;
        }
        double totalListSize = this.getTotalValueLengthUpToIndex(this.valueCount);
        return totalListSize / (double)this.valueCount;
    }

    @Override
    public int getValueCapacity() {
        int validityCapacity = this.getValidityBufferValueCapacity();
        int valueBufferCapacity = Math.max(LargeMemoryUtil.capAtMaxInt(this.viewBuffer.capacity() / 16L), 0);
        return Math.min(valueBufferCapacity, validityCapacity);
    }

    private int getValidityBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.validityBuffer.capacity() * 8L);
    }

    public void zeroVector() {
        this.initValidityBuffer();
        this.viewBuffer.setZero(0L, this.viewBuffer.capacity());
        this.clearDataBuffers();
    }

    private void initValidityBuffer() {
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    @Override
    public void reset() {
        this.zeroVector();
        this.lastSet = -1;
        this.valueCount = 0;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.viewBuffer = this.releaseBuffer(this.viewBuffer);
        this.clearDataBuffers();
        this.lastSet = -1;
        this.valueCount = 0;
    }

    public void clearDataBuffers() {
        for (ArrowBuf buffer : this.dataBuffers) {
            this.releaseBuffer(buffer);
        }
        this.dataBuffers.clear();
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("primitive type vector cannot have children");
        }
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.emptyList();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        ArrowBuf bitBuf = ownBuffers.get(0);
        ArrowBuf viewBuf = ownBuffers.get(1);
        List<ArrowBuf> dataBufs = ownBuffers.subList(2, ownBuffers.size());
        this.clear();
        this.viewBuffer = viewBuf.getReferenceManager().retain(viewBuf, this.allocator);
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuf, this.allocator);
        for (ArrowBuf dataBuf : dataBufs) {
            this.dataBuffers.add(dataBuf.getReferenceManager().retain(dataBuf, this.allocator));
        }
        this.lastSet = fieldNode.getLength() - 1;
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(2 + this.dataBuffers.size());
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.viewBuffer);
        result.addAll(this.dataBuffers);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0L);
        this.viewBuffer.readerIndex(0L);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0L);
            this.viewBuffer.writerIndex(0L);
        } else {
            this.validityBuffer.writerIndex(BaseVariableWidthViewVector.getValidityBufferSizeFromCount(this.valueCount));
            this.viewBuffer.writerIndex(this.valueCount * 16);
        }
    }

    @Override
    public void allocateNew() {
        this.allocateNew(this.lastValueAllocationSizeInBytes, this.lastValueCapacity);
    }

    @Override
    public boolean allocateNewSafe() {
        try {
            this.allocateNew(this.lastValueAllocationSizeInBytes, this.lastValueCapacity);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void allocateNew(long totalBytes, int valueCount) {
        assert (totalBytes >= 0L);
        this.checkDataBufferSize(totalBytes);
        this.clear();
        try {
            this.allocateBytes(totalBytes, valueCount);
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateNew(this.lastValueAllocationSizeInBytes, valueCount);
    }

    private void checkDataBufferSize(long size) {
        if (size > (long)MAX_BUFFER_SIZE || size < 0L) {
            throw new OversizedAllocationException("Memory required for vector is (" + size + "), which is overflow or more than max allowed (" + MAX_BUFFER_SIZE + "). You could consider using LargeVarCharVector/LargeVarBinaryVector for large strings/large bytes types");
        }
    }

    private void allocateBytes(long valueBufferSize, int valueCount) {
        this.viewBuffer = this.allocator.buffer(valueBufferSize);
        this.viewBuffer.readerIndex(0L);
        this.validityBuffer = this.allocator.buffer((valueCount + 7) / 8);
        this.initValidityBuffer();
        this.lastValueCapacity = this.getValueCapacity();
        this.lastValueAllocationSizeInBytes = LargeMemoryUtil.capAtMaxInt(this.viewBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.reallocViewBuffer();
        this.reallocViewDataBuffer();
        this.reallocValidityBuffer();
    }

    public void reallocViewBuffer() {
        long currentViewBufferCapacity = this.viewBuffer.capacity();
        long newAllocationSize = currentViewBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.lastValueAllocationSizeInBytes > 0L ? this.lastValueAllocationSizeInBytes : 131072L;
        }
        this.reallocViewBuffer(newAllocationSize);
    }

    public void reallocViewDataBuffer() {
        long newAllocationSize;
        long currentDataBufferCapacity = 0L;
        if (!this.dataBuffers.isEmpty()) {
            currentDataBufferCapacity = this.dataBuffers.get(this.dataBuffers.size() - 1).capacity();
        }
        if ((newAllocationSize = currentDataBufferCapacity * 2L) == 0L) {
            newAllocationSize = this.lastValueAllocationSizeInBytes > 0L ? this.lastValueAllocationSizeInBytes : 131072L;
        }
        this.reallocViewDataBuffer(newAllocationSize);
    }

    public void reallocViewBuffer(long desiredAllocSize) {
        if (desiredAllocSize == 0L) {
            return;
        }
        long newAllocationSize = CommonUtil.nextPowerOfTwo(desiredAllocSize);
        assert (newAllocationSize >= 1L);
        this.checkDataBufferSize(newAllocationSize);
        newAllocationSize = DataSizeRoundingUtil.roundUpToMultipleOf16(newAllocationSize);
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.viewBuffer, 0L, this.viewBuffer.capacity());
        this.viewBuffer.getReferenceManager().release();
        this.viewBuffer = newBuf;
        this.lastValueAllocationSizeInBytes = this.viewBuffer.capacity();
    }

    public void reallocViewDataBuffer(long desiredAllocSize) {
        if (desiredAllocSize == 0L) {
            return;
        }
        if (this.dataBuffers.isEmpty()) {
            return;
        }
        ArrowBuf currentBuf = this.dataBuffers.get(this.dataBuffers.size() - 1);
        if (currentBuf.capacity() - currentBuf.writerIndex() >= desiredAllocSize) {
            return;
        }
        long newAllocationSize = CommonUtil.nextPowerOfTwo(desiredAllocSize);
        assert (newAllocationSize >= 1L);
        this.checkDataBufferSize(newAllocationSize);
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        this.dataBuffers.add(newBuf);
    }

    public void reallocValidityBuffer() {
        int targetValidityCount = LargeMemoryUtil.capAtMaxInt(this.validityBuffer.capacity() * 8L * 2L);
        if (targetValidityCount == 0) {
            targetValidityCount = this.lastValueCapacity > 0 ? this.lastValueCapacity : 7940;
        }
        long validityBufferSize = this.computeValidityBufferSize(targetValidityCount);
        ArrowBuf newValidityBuffer = this.allocator.buffer(validityBufferSize);
        newValidityBuffer.setBytes(0L, this.validityBuffer, 0L, this.validityBuffer.capacity());
        newValidityBuffer.setZero(this.validityBuffer.capacity(), newValidityBuffer.capacity() - this.validityBuffer.capacity());
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = newValidityBuffer;
        this.lastValueCapacity = this.getValueCapacity();
    }

    private long computeValidityBufferSize(int valueCount) {
        return (valueCount + 7) / 8;
    }

    @Override
    public int getByteCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.viewBuffer.capacity());
    }

    @Override
    public int sizeOfValueBuffer() {
        throw new UnsupportedOperationException("sizeOfValueBuffer is not supported for BaseVariableWidthViewVector");
    }

    public int sizeOfViewBufferElements() {
        if (this.valueCount == 0) {
            return 0;
        }
        int totalSize = 0;
        for (int i = 0; i < this.valueCount; ++i) {
            totalSize += this.getValueLength(i);
        }
        return totalSize;
    }

    @Override
    public int getBufferSize() {
        return this.getBufferSizeFor(this.valueCount);
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int validityBufferSize = BaseVariableWidthViewVector.getValidityBufferSizeFromCount(valueCount);
        int viewBufferSize = valueCount * 16;
        int dataBufferSize = this.getDataBufferSize();
        return validityBufferSize + viewBufferSize + dataBufferSize;
    }

    private int getDataBufferSize() {
        int dataBufferSize = 0;
        for (ArrowBuf buf : this.dataBuffers) {
            dataBufferSize += (int)buf.writerIndex();
        }
        return dataBufferSize;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            int dataBufferSize = this.dataBuffers.size();
            int fixedBufferSize = 2;
            buffers = new ArrowBuf[2 + dataBufferSize];
            buffers[0] = this.validityBuffer;
            buffers[1] = this.viewBuffer;
            for (int i = 2; i < 2 + dataBufferSize; ++i) {
                buffers[i] = this.dataBuffers.get(i - 2);
            }
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain();
            }
            this.clear();
        }
        return buffers;
    }

    public void validateScalars() {
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(field, allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.getName(), allocator);
    }

    @Override
    public abstract TransferPair getTransferPair(String var1, BufferAllocator var2);

    @Override
    public abstract TransferPair getTransferPair(Field var1, BufferAllocator var2);

    public void transferTo(BaseVariableWidthViewVector target) {
        this.compareTypes(target, "transferTo");
        target.clear();
        target.validityBuffer = BaseVariableWidthViewVector.transferBuffer(this.validityBuffer, target.allocator);
        target.viewBuffer = BaseVariableWidthViewVector.transferBuffer(this.viewBuffer, target.allocator);
        target.dataBuffers = new ArrayList<ArrowBuf>(this.dataBuffers.size());
        for (int i = 0; i < this.dataBuffers.size(); ++i) {
            target.dataBuffers.add(BaseVariableWidthViewVector.transferBuffer(this.dataBuffers.get(i), target.allocator));
        }
        target.setLastSet(this.lastSet);
        if (this.valueCount > 0) {
            target.setValueCount(this.valueCount);
        }
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BaseVariableWidthViewVector target) {
        Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)this.valueCount);
        this.compareTypes(target, "splitAndTransferTo");
        target.clear();
        if (length > 0) {
            this.splitAndTransferValidityBuffer(startIndex, length, target);
            this.splitAndTransferViewBufferAndDataBuffer(startIndex, length, target);
            target.setLastSet(length - 1);
            target.setValueCount(length);
        }
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0L);
        this.initValidityBuffer();
    }

    private void splitAndTransferValidityBuffer(int startIndex, int length, BaseVariableWidthViewVector target) {
        byte b1;
        if (length <= 0) {
            return;
        }
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BaseVariableWidthViewVector.getValidityBufferSizeFromCount(length);
        int offset = startIndex % 8;
        if (offset == 0) {
            if (target.validityBuffer != null) {
                target.validityBuffer.getReferenceManager().release();
            }
            ArrowBuf slicedValidityBuffer = this.validityBuffer.slice(firstByteSource, byteSizeTarget);
            target.validityBuffer = BaseVariableWidthViewVector.transferBuffer(slicedValidityBuffer, target.allocator);
            return;
        }
        target.allocateValidityBuffer(byteSizeTarget);
        for (int i = 0; i < byteSizeTarget - 1; ++i) {
            byte b12 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + i, offset);
            byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + i + 1, offset);
            target.validityBuffer.setByte((long)i, b12 + b2);
        }
        if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
            b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
            byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + byteSizeTarget, offset);
            target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
        } else {
            b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
            target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1);
        }
    }

    private void splitAndTransferViewBufferAndDataBuffer(int startIndex, int length, BaseVariableWidthViewVector target) {
        if (length == 0) {
            return;
        }
        if (target.viewBuffer != null) {
            target.viewBuffer.getReferenceManager().release();
        }
        target.viewBuffer = target.allocator.buffer(length * 16);
        for (int i = startIndex; i < startIndex + length; ++i) {
            int stringLength = this.getValueLength(i);
            int writePosition = (i - startIndex) * 16;
            int readPosition = i * 16;
            target.viewBuffer.setInt(writePosition, stringLength);
            if (stringLength <= 12) {
                target.viewBuffer.setBytes((long)(writePosition += 4), this.viewBuffer, (long)(readPosition += 4), (long)stringLength);
                continue;
            }
            int readBufIndex = this.viewBuffer.getInt((long)i * 16L + 4L + 4L);
            int readBufOffset = this.viewBuffer.getInt((long)i * 16L + 4L + 4L + 4L);
            ArrowBuf dataBuf = this.dataBuffers.get(readBufIndex);
            ArrowBuf currentDataBuf = target.allocateOrGetLastDataBuffer(stringLength);
            long currentOffSet = currentDataBuf.writerIndex();
            target.viewBuffer.setBytes((long)(writePosition += 4), this.viewBuffer, (long)(readPosition += 4), 4L);
            target.viewBuffer.setInt(writePosition += 4, target.dataBuffers.size() - 1);
            target.viewBuffer.setInt(writePosition += 4, (int)currentOffSet);
            currentDataBuf.setBytes(currentOffSet, dataBuf, (long)readBufOffset, (long)stringLength);
            currentDataBuf.writerIndex(currentOffSet + (long)stringLength);
        }
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    public boolean isSafe(int index) {
        return index < this.getValueCapacity();
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        assert (valueCount >= 0);
        this.valueCount = valueCount;
        while (valueCount > this.getValueCapacity()) {
            this.reallocViewBuffer();
            this.reallocValidityBuffer();
        }
        this.lastSet = valueCount - 1;
        this.setReaderAndWriterIndex();
    }

    @Override
    public void fillEmpties(int index) {
        this.handleSafe(index, EMPTY_BYTE_ARRAY.length);
        this.lastSet = index - 1;
    }

    @Override
    public void setLastSet(int value) {
        this.lastSet = value;
    }

    @Override
    public int getLastSet() {
        return this.lastSet;
    }

    @Override
    public void setIndexDefined(int index) {
        while (index >= this.getValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
    }

    @Override
    public void setValueLengthSafe(int index, int length) {
        assert (index >= 0);
        this.handleSafe(index, length);
        this.lastSet = index;
    }

    @Override
    public int getValueLength(int index) {
        assert (index >= 0);
        if (index < 0 || (long)index >= this.viewBuffer.capacity() / 16L) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        if (this.isSet(index) == 0) {
            return 0;
        }
        return this.viewBuffer.getInt((long)index * 16L);
    }

    @Override
    public void set(int index, byte[] value) {
        assert (index >= 0);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, 0, value.length);
        this.lastSet = index;
    }

    @Override
    public void setSafe(int index, byte[] value) {
        assert (index >= 0);
        this.handleSafe(index, value.length);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, 0, value.length);
        this.lastSet = index;
    }

    @Override
    public void set(int index, byte[] value, int start, int length) {
        assert (index >= 0);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, start, length);
        this.lastSet = index;
    }

    @Override
    public void setSafe(int index, byte[] value, int start, int length) {
        assert (index >= 0);
        this.handleSafe(index, length);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, start, length);
        this.lastSet = index;
    }

    @Override
    public void set(int index, ByteBuffer value, int start, int length) {
        assert (index >= 0);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value.array(), start, length);
        this.lastSet = index;
    }

    @Override
    public void setSafe(int index, ByteBuffer value, int start, int length) {
        assert (index >= 0);
        this.handleSafe(index, length);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value.array(), start, length);
        this.lastSet = index;
    }

    @Override
    public void setNull(int index) {
        while (index >= this.getValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.unsetBit(this.validityBuffer, index);
    }

    public void set(int index, int isSet, int start, int end, ArrowBuf buffer) {
        assert (index >= 0);
        int dataLength = end - start;
        BitVectorHelper.setValidityBit(this.validityBuffer, index, isSet);
        this.setBytes(index, buffer, start, dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, int isSet, int start, int end, ArrowBuf buffer) {
        assert (index >= 0);
        int dataLength = end - start;
        this.handleSafe(index, dataLength);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, isSet);
        this.setBytes(index, buffer, start, dataLength);
        this.lastSet = index;
    }

    public void set(int index, int start, int length, ArrowBuf buffer) {
        assert (index >= 0);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, buffer, start, length);
        this.lastSet = index;
    }

    public void setSafe(int index, int start, int length, ArrowBuf buffer) {
        assert (index >= 0);
        this.handleSafe(index, length);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, buffer, start, length);
        this.lastSet = index;
    }

    protected ArrowBuf allocateOrGetLastDataBuffer(int length) {
        long dataBufferSize = this.initialDataBufferSize > 0 ? (long)Math.max(this.initialDataBufferSize, length) : Math.max(this.lastValueAllocationSizeInBytes, (long)length);
        if (this.dataBuffers.isEmpty() || this.dataBuffers.get(this.dataBuffers.size() - 1).capacity() - this.dataBuffers.get(this.dataBuffers.size() - 1).writerIndex() < (long)length) {
            ArrowBuf newBuf = this.allocator.buffer(dataBufferSize);
            this.dataBuffers.add(newBuf);
        }
        return this.dataBuffers.get(this.dataBuffers.size() - 1);
    }

    protected final void setBytes(int index, byte[] value, int start, int length) {
        int writePosition = index * 16;
        this.viewBuffer.setZero(writePosition, 16L);
        if (length <= 12) {
            this.viewBuffer.setInt(writePosition, length);
            this.viewBuffer.setBytes((long)(writePosition += 4), value, start, (long)length);
        } else {
            ArrowBuf currentBuf = this.allocateOrGetLastDataBuffer(length);
            this.viewBuffer.setInt(writePosition, length);
            this.viewBuffer.setBytes((long)(writePosition += 4), value, start, 4L);
            this.viewBuffer.setInt(writePosition += 4, this.dataBuffers.size() - 1);
            this.viewBuffer.setInt(writePosition += 4, (int)currentBuf.writerIndex());
            currentBuf.setBytes(currentBuf.writerIndex(), value, start, (long)length);
            currentBuf.writerIndex(currentBuf.writerIndex() + (long)length);
        }
    }

    protected final void setBytes(int index, ArrowBuf valueBuf, int start, int length) {
        int writePosition = index * 16;
        this.viewBuffer.setZero(writePosition, 16L);
        if (length <= 12) {
            this.viewBuffer.setInt(writePosition, length);
            this.viewBuffer.setBytes((long)(writePosition += 4), valueBuf, (long)start, (long)length);
        } else {
            ArrowBuf currentBuf = this.allocateOrGetLastDataBuffer(length);
            this.viewBuffer.setInt(writePosition, length);
            this.viewBuffer.setBytes((long)(writePosition += 4), valueBuf, (long)start, 4L);
            this.viewBuffer.setInt(writePosition += 4, this.dataBuffers.size() - 1);
            this.viewBuffer.setInt(writePosition += 4, (int)currentBuf.writerIndex());
            currentBuf.setBytes(currentBuf.writerIndex(), valueBuf, (long)start, (long)length);
            currentBuf.writerIndex(currentBuf.writerIndex() + (long)length);
        }
    }

    public final int getTotalValueLengthUpToIndex(int index) {
        int totalLength = 0;
        for (int i = 0; i < index - 1; ++i) {
            totalLength += this.getValueLength(i);
        }
        return totalLength;
    }

    protected final void handleSafe(int index, int dataLength) {
        long lastSetCapacity = this.lastSet < 0 ? 0L : (long)index * 16L;
        long targetCapacity = DataSizeRoundingUtil.roundUpToMultipleOf16(lastSetCapacity + (long)dataLength);
        long writePosition = (long)index * 16L;
        if (this.viewBuffer.capacity() <= writePosition || this.viewBuffer.capacity() < targetCapacity) {
            this.reallocViewBuffer(Math.max(writePosition, targetCapacity));
        }
        while (index >= this.getValueCapacity()) {
            this.reallocValidityBuffer();
        }
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        if (from.isNull(fromIndex)) {
            BitVectorHelper.unsetBit(this.validityBuffer, thisIndex);
        } else {
            int viewLength = from.getDataBuffer().getInt((long)fromIndex * 16L);
            BitVectorHelper.setBit(this.validityBuffer, thisIndex);
            int start = thisIndex * 16;
            int copyStart = fromIndex * 16;
            from.getDataBuffer().getBytes((long)start, this.viewBuffer, (long)copyStart, 16);
            if (viewLength > 12) {
                int bufIndex = from.getDataBuffer().getInt((long)fromIndex * 16L + 4L + 4L);
                int dataOffset = from.getDataBuffer().getInt((long)fromIndex * 16L + 4L + 4L + 4L);
                ArrowBuf dataBuf = ((BaseVariableWidthViewVector)from).dataBuffers.get(bufIndex);
                ArrowBuf thisDataBuf = this.allocateOrGetLastDataBuffer(viewLength);
                thisDataBuf.setBytes(thisDataBuf.writerIndex(), dataBuf, (long)dataOffset, (long)viewLength);
                thisDataBuf.writerIndex(thisDataBuf.writerIndex() + (long)viewLength);
            }
        }
        this.lastSet = thisIndex;
    }

    @Override
    public void copyFromSafe(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        if (from.isNull(fromIndex)) {
            this.handleSafe(thisIndex, 0);
            BitVectorHelper.unsetBit(this.validityBuffer, thisIndex);
        } else {
            int viewLength = from.getDataBuffer().getInt((long)fromIndex * 16L);
            this.handleSafe(thisIndex, viewLength);
            BitVectorHelper.setBit(this.validityBuffer, thisIndex);
            int start = thisIndex * 16;
            int copyStart = fromIndex * 16;
            from.getDataBuffer().getBytes((long)start, this.viewBuffer, (long)copyStart, 16);
            if (viewLength > 12) {
                int bufIndex = from.getDataBuffer().getInt((long)fromIndex * 16L + 4L + 4L);
                int dataOffset = from.getDataBuffer().getInt((long)fromIndex * 16L + 4L + 4L + 4L);
                ArrowBuf dataBuf = ((BaseVariableWidthViewVector)from).dataBuffers.get(bufIndex);
                ArrowBuf thisDataBuf = this.allocateOrGetLastDataBuffer(viewLength);
                thisDataBuf.setBytes(thisDataBuf.writerIndex(), dataBuf, (long)dataOffset, (long)viewLength);
                thisDataBuf.writerIndex(thisDataBuf.writerIndex() + (long)viewLength);
            }
        }
        this.lastSet = thisIndex;
    }

    @Override
    public ArrowBufPointer getDataPointer(int index) {
        return this.getDataPointer(index, new ArrowBufPointer());
    }

    @Override
    public ArrowBufPointer getDataPointer(int index, ArrowBufPointer reuse) {
        if (this.isNull(index)) {
            reuse.set(null, 0L, 0L);
        } else {
            int length = this.getValueLength(index);
            if (length < 12) {
                int start = index * 16 + 4;
                reuse.set(this.viewBuffer, start, length);
            } else {
                int bufIndex = this.viewBuffer.getInt((long)index * 16L + 4L + 4L);
                ArrowBuf dataBuf = this.dataBuffers.get(bufIndex);
                reuse.set(dataBuf, 0L, length);
            }
        }
        return reuse;
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        if (this.isNull(index)) {
            return 0;
        }
        int length = this.getValueLength(index);
        if (length < 12) {
            int start = index * 16 + 4;
            return ByteFunctionHelpers.hash(hasher, this.getDataBuffer(), start, start + length);
        }
        int bufIndex = this.viewBuffer.getInt((long)index * 16L + 4L + 4L);
        int dataOffset = this.viewBuffer.getInt((long)index * 16L + 4L + 4L + 4L);
        ArrowBuf dataBuf = this.dataBuffers.get(bufIndex);
        return ByteFunctionHelpers.hash(hasher, dataBuf, dataOffset, dataOffset + length);
    }

    protected byte[] getData(int index) {
        int dataLength = this.getValueLength(index);
        byte[] result = new byte[dataLength];
        if (dataLength > 12) {
            int bufferIndex = this.viewBuffer.getInt((long)index * 16L + 4L + 4L);
            int dataOffset = this.viewBuffer.getInt((long)index * 16L + 4L + 4L + 4L);
            this.dataBuffers.get(bufferIndex).getBytes((long)dataOffset, result, 0, dataLength);
        } else {
            this.viewBuffer.getBytes((long)index * 16L + 4L, result, 0, dataLength);
        }
        return result;
    }

    protected void getData(int index, ReusableBuffer<?> buffer) {
        int dataLength = this.getValueLength(index);
        if (dataLength > 12) {
            int bufferIndex = this.viewBuffer.getInt((long)index * 16L + 4L + 4L);
            int dataOffset = this.viewBuffer.getInt((long)index * 16L + 4L + 4L + 4L);
            ArrowBuf dataBuf = this.dataBuffers.get(bufferIndex);
            buffer.set(dataBuf, (long)dataOffset, (long)dataLength);
        } else {
            buffer.set(this.viewBuffer, (long)index * 16L + 4L, (long)dataLength);
        }
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public int getExportedCDataBufferCount() {
        return 3 + this.dataBuffers.size();
    }

    @Override
    public void exportCDataBuffers(List<ArrowBuf> buffers, ArrowBuf buffersPtr, long nullValue) {
        this.exportBuffer(this.validityBuffer, buffers, buffersPtr, nullValue, true);
        this.exportBuffer(this.viewBuffer, buffers, buffersPtr, nullValue, true);
        ArrowBuf variadicSizeBuffer = this.allocator.buffer(8L * (long)this.dataBuffers.size());
        for (int i = 0; i < this.dataBuffers.size(); ++i) {
            ArrowBuf dataBuf = this.dataBuffers.get(i);
            variadicSizeBuffer.setLong((long)i * 8L, dataBuf.capacity());
            this.exportBuffer(dataBuf, buffers, buffersPtr, nullValue, true);
        }
        this.exportBuffer(variadicSizeBuffer, buffers, buffersPtr, nullValue, false);
    }
}

