(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     33828,        996]*)
(*NotebookOutlinePosition[     36370,       1071]*)
(*  CellTagsIndexPosition[     36207,       1063]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["", "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  AspectRatioFixed->True,
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell["Contents", "Title",
  CellMargins->{{Inherited, Inherited}, {72, Inherited}},
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  AspectRatioFixed->True,
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[TextData[StyleBox[ButtonBox["Read Me First",
  ButtonData:>{"ReadMeFirst.nb", None},
  ButtonStyle->"Hyperlink"],
  FontSize->12]], "Text",
  PageBreakBelow->False,
  CellTags->{
  "space-time translation", "symmetry principle", "laws of nature"}],

Cell[CellGroupData[{

Cell["StartUp", "Subsubsection",
  PageBreakBelow->False],

Cell[TextData[{
  "\nAdjust the path names in the following lines in such a way that the \
package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is loaded correctly. The following lines contain the names of a  standard \
installation."
}], "Text",
  PageBreakBelow->False],

Cell[BoxData[{
    \(Off[General::spell]\), "\n", 
    \(Off[General::spell1]\)}], "Input",
  PageBreakBelow->False,
  InitializationCell->True],

Cell[TextData[{
  "Here follows the path where you have installed ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " on your computer."
}], "Text",
  PageBreakBelow->False],

Cell[BoxData[
    \(\(If[$MachineType == "\<PC\>", $MathLiePath = $TopDirectory <> \
"\</AddOns/Applications/MathLie/\>"; 
        AppendTo[$Path, $MathLiePath], $MathLiePath = 
          StringJoin[$HomeDirectory, "\</Mma/Buch/Symm/Mma3.0/MathLie\>", \
"\</\>"]; AppendTo[$Path, $MathLiePath]];\)\)], "Input",
  PageBreakBelow->False,
  InitializationCell->True],

Cell["The next line loads the package.", "Text",
  PageBreakBelow->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< MathLie.m\)], "Input",
  PageBreakBelow->False,
  InitializationCell->True],

Cell[BoxData[
    \("Loading MathLie for DOS/Windows . . . "\)], "Print"],

Cell[BoxData[
    \(". . . . . . . . . . . . . . . . . . . "\)], "Print"],

Cell[BoxData[
    \(" "\)], "Print"],

Cell[BoxData[
    \("================================================="\)], "Print"],

Cell[BoxData[
    \("MathLie\[Trademark] 3.0 (Dos/Windows\[RegisteredTrademark])"\)], \
"Print"],

Cell[BoxData[
    \("\[Copyright] 1992-2000 Dr. Gerd Baumann"\)], "Print"],

Cell[BoxData[
    \("Runs with Mathematica\[RegisteredTrademark] Version 3.0 or later"\)], \
"Print"],

Cell[BoxData[
    \("Licensed to one machine only, copying prohibited"\)], "Print"],

Cell[BoxData[
    \("================================================="\)], "Print"],

Cell[BoxData[
    \("Program loaded."\)], "Print"],

Cell[BoxData[
    \("================================================="\)], "Print"]
}, Open  ]],

Cell["\<\
Set the working directory to that directory where the book is \
located.\
\>", "Text",
  PageBreakBelow->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetDirectory", "[", 
        RowBox[{"If", "[", 
          RowBox[{\($MachineType == "\<PC\>"\), ",", 
            RowBox[{"StringJoin", "[", 
              RowBox[{
                StyleBox["$HomeDirectory",
                  "MR"], ",", "\"\<Mma/Buch/Symm/Mma3.0\>\""}], "]"}], ",", 
            RowBox[{"StringJoin", "[", 
              RowBox[{
                StyleBox["$HomeDirectory",
                  "MR"], ",", "\"\</Mma/Buch/Symm/Mma3.0\>\""}], "]"}]}], 
          "]"}], "]"}], ";"}]], "Input",
  PageBreakBelow->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Subsubsection"],

Cell[TextData[StyleBox[ButtonBox["TitlePage",
  ButtonData:>{"Title.nb", None},
  ButtonStyle->"Hyperlink"],
  FontSize->12]], "Text",
  PageBreakBelow->False],

Cell[TextData[StyleBox[ButtonBox["Dedication",
  ButtonData:>{"Dedication.nb", None},
  ButtonStyle->"Hyperlink"],
  FontSize->12]], "Text",
  PageBreakBelow->False],

Cell[TextData[StyleBox[ButtonBox["Preface",
  ButtonData:>{"Preface.nb", None},
  ButtonStyle->"Hyperlink"],
  FontSize->14]], "Text",
  PageBreakBelow->False],

Cell[TextData[{
  StyleBox["Chapter 1",
    FontFamily->"Times",
    FontSize->18],
  StyleBox["  ",
    FontSize->18],
  StyleBox[ButtonBox["Introduction",
    ButtonData:>{"introduc.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[" \t",
    FontSize->14,
    FontWeight->"Bold"]
}], "Text",
  PageBreakBelow->False],

Cell[TextData[{
  StyleBox["Chapter 2",
    FontFamily->"Times",
    FontSize->18],
  StyleBox["   ",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Elements of Symmetry Analysis",
    ButtonData:>{"Group.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["       ",
    FontSize->14,
    FontWeight->"Bold"],
  "      \t\n\t2.1\t",
  ButtonBox["Groups and Lie Groups",
    ButtonData:>{"Group.nb", None},
    ButtonStyle->"Hyperlink"],
  "                           \t\t\t\t\t\n\t\t2.1.1  \t",
  ButtonBox["Groups",
    ButtonData:>{"Group.nb", "Groups"},
    ButtonStyle->"Hyperlink"],
  "                                                       \t\t  \t\t\n\t\t\
2.1.2\t",
  ButtonBox["Isomorphism",
    ButtonData:>{"Group.nb", "Isomorphism"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t2.1.3  \t",
  ButtonBox["Lie Groups",
    ButtonData:>{"Group.nb", "Lie Groups"},
    ButtonStyle->"Hyperlink"],
  "                                                \t\t \n\t2.2    \t",
  ButtonBox["Lie Algebras",
    ButtonData:>{"Algebra.nb", None},
    ButtonStyle->"Hyperlink"],
  "         \n\t\t2.2.1\t",
  ButtonBox["Representation of a Lie Algebra",
    ButtonData:>{"Algebra.nb", "Representation of a Lie Algebra"},
    ButtonStyle->"Hyperlink"],
  "            \n\t\t2.2.2\t",
  ButtonBox["Properties of Lie Algebras",
    ButtonData:>{"Algebra.nb", "Properties of Lie Algebras"},
    ButtonStyle->"Hyperlink"],
  "                           \t\t"
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 3",
    FontFamily->"Times",
    FontSize->18],
  StyleBox["   ",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Derivatives",
    ButtonData:>{"derivat.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["     ",
    FontSize->14,
    FontWeight->"Bold"],
  "                                                        \t\n\t3.1.\t",
  ButtonBox["Ordinary and Partial Derivatives",
    ButtonData:>{"derivat.nb", "Ordinary and partial derivatives"},
    ButtonStyle->"Hyperlink"],
  "                              \t\n\t3.2   \t",
  ButtonBox["Tangent Vector ",
    ButtonData:>{"derivat.nb", "Tangent vector"},
    ButtonStyle->"Hyperlink"],
  "                                                      \t\t\t\n\t3.3      \t\
",
  ButtonBox["The Total Derivative",
    ButtonData:>{"derivat.nb", "The complete derivative"},
    ButtonStyle->"Hyperlink"],
  "                              \t        \t\n\t3.4      \t",
  ButtonBox["Prolongations",
    ButtonData:>{"derivat.nb", "Prolongations"},
    ButtonStyle->"Hyperlink"],
  "                                         \t\t\t\t\n\t3.5 \t",
  ButtonBox["The Fr\[EAcute]chet Derivative ",
    ButtonData:>{"derivat.nb", "The Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  "    \t                                         \t\n\t3.6    \t",
  ButtonBox["The Euler Derivative",
    ButtonData:>{"derivat1.nb", None},
    ButtonStyle->"Hyperlink"],
  "                                                  \t\n\t\t3.6.1   \t",
  ButtonBox["The Problem of Variations",
    ButtonData:>{"derivat1.nb", "The Problem of Variations"},
    ButtonStyle->"Hyperlink"],
  "                                    \t\n\t\t3.6.2    ",
  ButtonBox["Euler's Equation",
    ButtonData:>{"derivat1.nb", "Euler's Equation"},
    ButtonStyle->"Hyperlink"],
  "                                                         \t\n\t\t3.6.3   \t\
",
  ButtonBox["Euler Operator",
    ButtonData:>{"derivat1.nb", "Euler operator"},
    ButtonStyle->"Hyperlink"],
  "                                                          \t\n\t\t3.6.4   \
\t",
  ButtonBox["Algorithm used in the Calculus of Variations",
    ButtonData:>{"derivat1.nb", 
      "Algorithm used in the Calculus of Variations"},
    ButtonStyle->"Hyperlink"],
  "           \n\t\t3.6.5  \t",
  ButtonBox["Euler Operator for q Dependent Variables",
    ButtonData:>{"derivat1.nb", "Euler operator for q-dependent variables"},
    ButtonStyle->"Hyperlink"],
  "              \t\n\t\t3.6.6 \t",
  ButtonBox["Euler Operator for q+p-Dimensions",
    ButtonData:>{"derivat1.nb", "Euler operator for (q-p)-dimensions"},
    ButtonStyle->"Hyperlink"],
  "                     \t\n\t3.7    \t",
  ButtonBox["Prolongation of Vector Fields ",
    ButtonData:>{"derivat1.nb", "Prolongation of vector fields"},
    ButtonStyle->"Hyperlink"],
  " \t"
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 4",
    FontFamily->"Times",
    FontSize->18],
  StyleBox["\t",
    FontSize->14,
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[ButtonBox["Symmetries of Ordinary Differential Equations",
    ButtonData:>{"symmet1.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[" \n\t",
    FontWeight->"Bold"],
  "4.1\t",
  ButtonBox["Introduction",
    ButtonData:>{"symmet1.nb", "Introduction"},
    ButtonStyle->"Hyperlink"],
  " \n\t 4.2\t",
  ButtonBox["Symmetry Transformations of Functions",
    ButtonData:>{"symmet1.nb", "Symmetry Transformations of Functions"},
    ButtonStyle->"Hyperlink"],
  " \t\n\t\t4.2.1 \t",
  ButtonBox["Symmetries ",
    ButtonData:>{"symmet1.nb", "Symmetries"},
    ButtonStyle->"Hyperlink"],
  " \t\t\t\t\t\t\t\t\n\t\t4.2.2\t",
  ButtonBox["Infinitesimal Transformations \t",
    ButtonData:>{"symmet1.nb", "Infinitesimal transformations"},
    ButtonStyle->"Hyperlink"],
  "\t\t\t\t\n\t\t4.2.3 \t",
  ButtonBox["Group Invariants ",
    ButtonData:>{"symmet1.nb", "Group invariants"},
    ButtonStyle->"Hyperlink"],
  " \t\t\t\t\t\t\t\n\t\t4.2.4 \t",
  ButtonBox["Tangent Vector",
    ButtonData:>{"symmet1.nb", "Tangent Vector"},
    ButtonStyle->"Hyperlink"],
  "  \t\t\t\t\t\t\t\n\t\t4.2.5  \t",
  ButtonBox["Prolongation of Transformations",
    ButtonData:>{"symmet1.nb", "Prolongation of Transformations"},
    ButtonStyle->"Hyperlink"],
  "  \t\t\t\t\n\t 4.3\t",
  ButtonBox["Symmetry Transformations of Differential Equations\n\t\t",
    ButtonData:>{"symmet11.nb", 
      "Symmetry Transformations of Differential Equations"},
    ButtonStyle->"Hyperlink"],
  "4.3.1 \t",
  ButtonBox["Definition of a Symmetry Group",
    ButtonData:>{"symmet11.nb", "Definition of a symmetry group"},
    ButtonStyle->"Hyperlink"],
  "  \t\t\t\t\t\n\t\t4.3.2 \t",
  ButtonBox["Main Properties of Symmetry Groups",
    ButtonData:>{"symmet11.nb", "Main properties of symmetry groups"},
    ButtonStyle->"Hyperlink"],
  "  \t\t\t\t\n\t\t4.3.3\t",
  ButtonBox["Calculation of the Infinitesimal Symmetries",
    ButtonData:>{"symmet11.nb", 
      "Calculation of the infinitesimal symmetries"},
    ButtonStyle->"Hyperlink"],
  "  \t\t\t\t\n\t\t4.3.4 \t",
  ButtonBox["Canonical Variables",
    ButtonData:>{"symmet11.nb", "Canonical variables"},
    ButtonStyle->"Hyperlink"],
  "   \n\t4.4   \t",
  ButtonBox["Analysis of Ordinary Differential Equations",
    ButtonData:>{"symmet2.nb", "Analysis of Ordinary Differential Equations"},
    
    ButtonStyle->"Hyperlink"],
  "  \n\t\t4.4.1 \t",
  ButtonBox["First-Order Equations",
    ButtonData:>{"symmet2.nb", "First order equations"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t\t4.4.1.1 ",
  ButtonBox["The Skeleton of an Ordinary Differential Equation\n\t\t\t",
    ButtonData:>{"symmet2.nb", 
      "The skeleton of an ordinary differential equation"},
    ButtonStyle->"Hyperlink"],
  "4.4.1.2\t",
  ButtonBox["Integrating Factor\n\t\t\t",
    ButtonData:>{"symmet2.nb", "Integrating factor"},
    ButtonStyle->"Hyperlink"],
  "4.4.1.3\t",
  ButtonBox["Infinitesimals of First-Order Ordinary Differential Equations",
    ButtonData:>{"symmet2.nb", 
      "Infinitesimals of first order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  " \n\t\t4.4.2 \t",
  ButtonBox["Second-Order Ordinary Differential Equations",
    ButtonData:>{"symmet3.nb", 
      "Second order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t\t4.4.2.1\t",
  ButtonBox["Integration by Group Classification \n\t\t\t",
    ButtonData:>{"symmet3.nb", "Algorithm of Integration"},
    ButtonStyle->"Hyperlink"],
  "4.4.2.2\t",
  ButtonBox["The Integrating Factor Method\n\t\t\t",
    ButtonData:>{"symmet3.nb", "Method of integrating factor"},
    ButtonStyle->"Hyperlink"],
  "4.4.2.2\t",
  ButtonBox["Method of Canonical Variables",
    ButtonData:>{"symmet3.nb", "Method of canonical variables"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t4.4.3 \t",
  ButtonBox["Higher-Order Ordinary Differential Equations ",
    ButtonData:>{"symmet4.nb", 
      "Higher order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  "\n  \t\t\t4.4.3.1\t",
  ButtonBox["Integrating Factor Method",
    ButtonData:>{"symmet4.nb", "Integrating factor method"},
    ButtonStyle->"Hyperlink"],
  "\t"
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 5",
    FontFamily->"Times",
    FontSize->18],
  StyleBox["\t",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Point Symmetries of Partial Differential Equations",
    ButtonData:>{"symmet5.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["     ",
    FontSize->14,
    FontWeight->"Bold"],
  "   \n\t5.1\t",
  ButtonBox["Introduction",
    ButtonData:>{"symmet5.nb", "Introduction"},
    ButtonStyle->"Hyperlink"],
  "  \n\t5.2 \t",
  ButtonBox["Lie's Theory Used in MathLie",
    ButtonData:>{"symmet5.nb", "Lie's theory used in MathLie"},
    ButtonStyle->"Hyperlink"],
  "   \n\t5.3\t",
  ButtonBox["Invariance Based on Fr\[EAcute]chet Derivatives",
    ButtonData:>{"symmet5.nb", "Invariance Based on Frechet Derivatives"},
    ButtonStyle->"Hyperlink"],
  "\n\t5.4  \t",
  ButtonBox["Application of the Theory",
    ButtonData:>{"symmet5.nb", "Application of the theory"},
    ButtonStyle->"Hyperlink"],
  " \n\t\t5.4.1 \t",
  ButtonBox["Calculation of Prolongations\n\t\t",
    ButtonData:>{"symmet5.nb", "Calculation of prolongations"},
    ButtonStyle->"Hyperlink"],
  "5.4.2 \t",
  ButtonBox["Derivation of Determining Equations \n\t\t",
    ButtonData:>{"symmet5.nb", "Derivation of the determining equations"},
    ButtonStyle->"Hyperlink"],
  "5.4.3 \t",
  ButtonBox["Interactive Solution of Determining Equations",
    ButtonData:>{"symmet5.nb", "Solution of the determining equations"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t5.4.4 \t",
  ButtonBox["Data Basis of Symmetries",
    ButtonData:>{"symmet5.nb", "Data basis of symmetries"},
    ButtonStyle->"Hyperlink"],
  "  \n\t5.5 \t",
  ButtonBox["Similarity Reduction of Partial Differential Equations",
    ButtonData:>{"Reductio.nb", 
      "Reduction of partial differential equations"},
    ButtonStyle->"Hyperlink"],
  " \n\t5.6 \t",
  ButtonBox["Working Examples\n\t\t",
    ButtonData:>{"symmet51.nb", "Working examples"},
    ButtonStyle->"Hyperlink"],
  "5.6.1 \t",
  ButtonBox["The Diffusion Equation\n\t\t",
    ButtonData:>{"symmet51.nb", "The diffusion equation"},
    ButtonStyle->"Hyperlink"],
  "5.6.2 \t",
  ButtonBox["The Earthworm's New Year Problem",
    ButtonData:>{"symmet51.nb", "The earthworm's New Year problem"},
    ButtonStyle->"Hyperlink"],
  " \n\t\t5.6.3 \t",
  ButtonBox["Single Flux Line in Superconductors",
    ButtonData:>{"symmet51.nb", "Single Flux Line in Superconductors"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t5.6.4\t",
  ButtonBox["The Korteweg-de Vries equation and its Generalizations",
    ButtonData:>{"KdVEquation.nb", 
      "The Korteweg-de Vries equation and some Generalizations"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t5.6.5\t",
  ButtonBox["Stokes' Solution of the Creeping Flow",
    ButtonData:>{"symmet52.nb", "Stokes' Solution of the Creeping Flow"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t5.6.6 \t",
  ButtonBox["Two-Dimensional Boundary-Layer Flows: Group Classification",
    ButtonData:>{"Layer.nb", "Two-Dimensional Boundary-Layer Flows"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t\t5.6.6.1\t",
  ButtonBox["The Blasius Solution",
    ButtonData:>{"Layer.nb", "The Blasius Solution"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t\t5.6.6.2\t",
  ButtonBox["Falkner Skan Solution",
    ButtonData:>{"Layer.nb", "Falkner Skan Solution"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t\t5.6.6.3\t",
  ButtonBox["Exponential Mainstream Velocity",
    ButtonData:>{"Layer.nb", "Exponential mainstream velocity"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t\t5.6.6.4 ",
  ButtonBox["Group Classification\n\t\t",
    ButtonData:>{"Layer.nb", "Group classification"},
    ButtonStyle->"Hyperlink"],
  "5.6.7 \t",
  ButtonBox["The Plane Jet",
    ButtonData:>{"Jet.nb", "The plane jet"},
    ButtonStyle->"Hyperlink"],
  " \n\t\t5.6.8\t",
  ButtonBox["Drop Formation",
    ButtonData:>{"DropFormation.nb", "Drop formation"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t5.6.9\t",
  ButtonBox["The Rayleigh Particle",
    ButtonData:>{"RayleighParticle.nb", "The Rayleigh particle"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t5.6.10\t",
  ButtonBox["Molecular Beam Epitaxy",
    ButtonData:>{"MolecularBeamEpitaxy.nb", "Molecular Beam Epitaxy"},
    ButtonStyle->"Hyperlink"],
  "\t\n\t\t\t5.6.10.1 ",
  ButtonBox["Surface Diffusion with Nonlinearity",
    ButtonData:>{"MolecularBeamEpitaxy.nb", 
      "Surface Diffusion with Nonlinearity"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t\t5.6.10.2 ",
  ButtonBox["Desorption with Nonlinearity",
    ButtonData:>{"MolecularBeamEpitaxy.nb", "Desorption with Nonlinearity"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t5.6.11\t",
  ButtonBox["The First Atomic Explosion",
    ButtonData:>{"Atomic.nb", "The first atomic explosion"},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 6  ",
    FontFamily->"Times",
    FontSize->18],
  StyleBox[ButtonBox["Non-Classical Symmetries of Partial Differential \
Equations",
    ButtonData:>{"symmet6.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  " \n\t6.1\t",
  ButtonBox["Introduction",
    ButtonData:>{"symmet6.nb", "Introduction"},
    ButtonStyle->"Hyperlink"],
  "\n            6.2 \t",
  ButtonBox["Mathematical Background of the Non-Classical Method",
    ButtonData:>{"symmet6.nb", 
      "Mathematical background of the non-classical method"},
    ButtonStyle->"Hyperlink"],
  " \n \t6.3 \t",
  ButtonBox["Applications of the Non-Classical Method\n\t\t",
    ButtonData:>{"symmet6.nb", "Applications of the non-classical method"},
    ButtonStyle->"Hyperlink"],
  "6.3.1\t",
  ButtonBox["The Heat Equation\n\t\t",
    ButtonData:>{"symmet6.nb", "The heat equation"},
    ButtonStyle->"Hyperlink"],
  "6.3.2\t",
  ButtonBox["The Boussinesq Equation\n\t\t",
    ButtonData:>{"symmet6.nb", "The Boussinesq equation"},
    ButtonStyle->"Hyperlink"],
  "6.3.3\t",
  ButtonBox["The Fokker-Planck Equation",
    ButtonData:>{"symmet6.nb", "The Fokker-Planck equation"},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 7",
    FontFamily->"Times",
    FontSize->18],
  StyleBox["   ",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Potential Symmetries of Partial Differential Equations",
    
    ButtonData:>{"symmet65.nb", 
      "Potential Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  "\n            7.1  \t",
  ButtonBox["Introduction",
    ButtonData:>{"symmet65.nb", "Introduction"},
    ButtonStyle->"Hyperlink"],
  "\n            7.2\t",
  ButtonBox["Basics of Potential Symmetries",
    ButtonData:>{"symmet65.nb", "Basics of Potential Symmetries"},
    ButtonStyle->"Hyperlink"],
  "\n            7.3\t",
  ButtonBox["Calculation of Potential Symmetries",
    ButtonData:>{"symmet65.nb", "Calculation of Potential Symmetries"},
    ButtonStyle->"Hyperlink"],
  "\n     \t7.4\t",
  ButtonBox["Applications of Potential Symmetries",
    ButtonData:>{"symmet65.nb", "Applications for Potential Symmetries"},
    ButtonStyle->"Hyperlink"],
  "\n            \t\t7.4.1\t",
  ButtonBox["A Nonlinear Reaction Diffusion Equation",
    ButtonData:>{"symmet65.nb", "The Diffusion Equation"},
    ButtonStyle->"Hyperlink"],
  "\n            \t\t7.4.2\t",
  ButtonBox["Cylindrical Korteweg-de Vries Equation",
    ButtonData:>{"symmet65.nb", "Cylindrical Korteweg-de Vries Equation"},
    ButtonStyle->"Hyperlink"],
  "\n            \t\t7.4.3\t",
  ButtonBox["The Burgers Equation",
    ButtonData:>{"symmet65.nb", "The Burgers Equation"},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 8",
    FontFamily->"Times",
    FontSize->18],
  " ",
  "  ",
  StyleBox[ButtonBox["Approximate Symmetries of Partial Differential \
Equations",
    ButtonData:>{"symmet7.nb", 
      "Approximate Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  "\n         \t8.1\t",
  ButtonBox["Introduction",
    ButtonData:>{"symmet7.nb", "Introduction"},
    ButtonStyle->"Hyperlink"],
  "\t\n          \t8.2\t",
  ButtonBox["Approximations",
    ButtonData:>{"symmet7.nb", "Approximations"},
    ButtonStyle->"Hyperlink"],
  " \n        \t8.3 \t",
  ButtonBox["One-Parameter Approximation Group",
    ButtonData:>{"symmet7.nb", "One-Parameter Approximation Group"},
    ButtonStyle->"Hyperlink"],
  "\n        \t8.4\t",
  ButtonBox["Approximate Group Generator",
    ButtonData:>{"symmet7.nb", "Approximate group generator"},
    ButtonStyle->"Hyperlink"],
  "\n\t8.5\t",
  ButtonBox["The Determining Equations and an Algorithm of Calculation",
    ButtonData:>{"symmet7.nb", 
      "The Determining Equations and an Algorithm of Calculation"},
    ButtonStyle->"Hyperlink"],
  "\n\t8.6\t",
  ButtonBox["Examples",
    ButtonData:>{"symmet7.nb", "Examples"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t8.6.1 \t",
  ButtonBox["Isentropic Liquid",
    ButtonData:>{"symmet7.nb", "Isentropic Liquid"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t8.6.2\t",
  ButtonBox["Perturbed Korteweg de Vies Equation",
    ButtonData:>{"symmet7.nb", "Disturbed Korteweg de Vries Equation"},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 9",
    FontFamily->"Times",
    FontSize->18],
  "   ",
  StyleBox[ButtonBox["Generalized Symmetries of Partial Differential \
Equations",
    ButtonData:>{"Symmet75.nb", 
      "Generalized Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
    FontFamily->"Times New Roman",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["\t\n         ",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["9.1\t",
    FontFamily->"Times New Roman"],
  StyleBox[ButtonBox["Introduction",
    ButtonData:>{"Symmet75.nb", "Introduction"},
    ButtonStyle->"Hyperlink"],
    FontFamily->"Times New Roman"],
  "\n\t9.2\t",
  ButtonBox["Elements of Generalized Symmetries",
    ButtonData:>{"Symmet75.nb", "Elements of Generalized Symmetries"},
    ButtonStyle->"Hyperlink"],
  "  \n\t9.3\t",
  ButtonBox["Algorithm for Calculation of Generalized Symmetries",
    ButtonData:>{"Symmet75.nb", 
      "Algorithm for the Calculation of Generalized Symmetries"},
    ButtonStyle->"Hyperlink"],
  "\n\t9.4\t",
  ButtonBox["Examples",
    ButtonData:>{"Symmet75.nb", "Examples"},
    ButtonStyle->"Hyperlink"],
  "  \n\t\t9.4.1\t",
  ButtonBox["Diffusion Equation",
    ButtonData:>{"Symmet75.nb", "Diffusion equation"},
    ButtonStyle->"Hyperlink"],
  "\t\n\t\t9.4.2\t",
  ButtonBox["Potential Burgers Equation",
    ButtonData:>{"Symmet75.nb", "Potential Burgers Equation"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t9.4.3\t",
  ButtonBox["Generalized Korteweg de Vries Equations",
    ButtonData:>{"Symmet75.nb", "Korteweg de Vries Equations"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t9.4.4 \t",
  ButtonBox["Coupled System of Wave Equations",
    ButtonData:>{"Symmet75.nb", "Coupled System of Wave Equations"},
    ButtonStyle->"Hyperlink"],
  "\n\t9.5\t",
  ButtonBox["Second-Order ODEs and the Euler-Lagrange Equation",
    ButtonData:>{"Symmet75.nb", 
      "Second-Order ODEs and the Euler-Lagrange equation"},
    ButtonStyle->"Hyperlink"],
  " \n\t\t9.5.1\t",
  ButtonBox["Generalized Symmetries and Second-Order ODEs",
    ButtonData:>{"Symmet75.nb", "Calculation of Generalized Symmetries"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t9.5.2\t",
  ButtonBox["Conservation laws",
    ButtonData:>{"Symmet75.nb", "Conservation laws"},
    ButtonStyle->"Hyperlink"],
  "\n\t9.6\t",
  ButtonBox["Algorithm for Conservation Laws of Second-Order ODEs",
    ButtonData:>{"Symmet75.nb", 
      "Algorithm for conservation laws of second-order ODEs"},
    ButtonStyle->"Hyperlink"],
  " \n\t9.7\t",
  ButtonBox["Examples for Second-Order ODEs",
    ButtonData:>{"Symmet75.nb", "Examples for second-order ODEs"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t9.7.1\t",
  ButtonBox["The H\[EAcute]non-Heiles Model",
    ButtonData:>{"Symmet75.nb", "The Henon-Heiles model"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t9.7.2\t",
  ButtonBox["Two-Dimensional Quartic Oscillators",
    ButtonData:>{"Symmet75.nb", "Two-Dimensional Quartic Oszillators"},
    ButtonStyle->"Hyperlink"],
  "\n\t\t9.7.3\t",
  ButtonBox["Two Ions in a Trap",
    ButtonData:>{"Symmet75.nb", "Two Ions in a Trap"},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 10",
    FontFamily->"Times",
    FontSize->18],
  StyleBox[" ",
    FontFamily->"Arial",
    FontSize->18,
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[" ",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Solution of Coupled Linear Partial Differential \
Equations",
    ButtonData:>{"symmet8.nb", 
      "Solution of Coupled Linear Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  "\n\t10.1 \t",
  ButtonBox["Introduction",
    ButtonData:>{"symmet8.nb", "Introduction"},
    ButtonStyle->"Hyperlink"],
  "\n\t10.2 \t",
  ButtonBox["General Canonical Form of PDEs ",
    ButtonData:>{"symmet8.nb", "General Canonical Form of PDEs"},
    ButtonStyle->"Hyperlink"],
  "\n  \t\t10.2.1\t",
  ButtonBox["Application of the General Canonical Form Algorithm",
    ButtonData:>{"symmet8.nb", "Application of the General Form Algorithm"},
    ButtonStyle->"Hyperlink"],
  "\n       \t10.3 \t",
  ButtonBox["Solution of Linear PDEs",
    ButtonData:>{"symmet8.nb", "Solution of Linear PDEs"},
    ButtonStyle->"Hyperlink"],
  "\n           \t\t10.3.1 ",
  ButtonBox["Integration of Monomials",
    ButtonData:>{"symmet8.nb", "Integration of Monomials"},
    ButtonStyle->"Hyperlink"],
  "\n           \t\t10.3.2 ",
  ButtonBox["Integrating ODEs and Pseudo-ODEs",
    ButtonData:>{"symmet8.nb", "Integrating ODEs and Pseudo-ODEs"},
    ButtonStyle->"Hyperlink"],
  "\n           \t\t10.3.3 ",
  ButtonBox["Integrating Exact PDEs",
    ButtonData:>{"symmet8.nb", "Integrating Exact PDEs"},
    ButtonStyle->"Hyperlink"],
  "\n           \t\t10.3.4 ",
  ButtonBox["Potential Representation\t",
    ButtonData:>{"symmet8.nb", "Potential Representation"},
    ButtonStyle->"Hyperlink"],
  "\n           \t10.4 \t",
  ButtonBox["Simplification of Equations",
    ButtonData:>{"symmet8.nb", "Simplification of Equations"},
    ButtonStyle->"Hyperlink"],
  "\n                  \t10.4.1 ",
  ButtonBox["Direct Separation",
    ButtonData:>{"symmet8.nb", "Direct Separation"},
    ButtonStyle->"Hyperlink"],
  " \n                  \t10.4.2 ",
  ButtonBox["Indirect Separation",
    ButtonData:>{"symmet8.nb", "Indirect Separation"},
    ButtonStyle->"Hyperlink"],
  "\n                  \t10.4.3 ",
  ButtonBox["Reducing the Number of Dependent Variables",
    ButtonData:>{"symmet8.nb", "Reducing the Number of Dependent Variables"},
    ButtonStyle->"Hyperlink"],
  "\n       \t10.5\t",
  ButtonBox["Example",
    ButtonData:>{"symmet8.nb", "Examples"},
    ButtonStyle->"Hyperlink"],
  "\n             \t10.5.1 ",
  ButtonBox["Liouville Type Equation of Quantum Gravity Theory",
    ButtonData:>{"symmet8.nb", 
      "Liouville Type Equation of Quantum Gravity Theory"},
    ButtonStyle->"Hyperlink"],
  " \n\t        "
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox["Chapter 11",
    FontFamily->"Times",
    FontSize->18],
  StyleBox["  ",
    FontSize->18,
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["Appendix\n\t",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["A",
    FontWeight->"Bold"],
  StyleBox["    ",
    FontSize->14,
    FontWeight->"Bold"],
  ButtonBox["Marius Sophus Lie: A Mathematician's Life\n\t    ",
    ButtonData:>{"MSLie.nb", "Marius Sophus Lie: a mathematicians life"},
    ButtonStyle->"Hyperlink"],
  StyleBox["B     ",
    FontWeight->"Bold"],
  ButtonBox["List of Key Symbols Used in Mathematica",
    ButtonData:>{"KeySymbols.nb", "List of Key Symbols Used in Mathematica"},
    ButtonStyle->"Hyperlink"],
  "\t\n\t    ",
  StyleBox["C",
    FontWeight->"Bold"],
  "     ",
  ButtonBox["Installing MathLie",
    ButtonData:>{"ReadMeFirst.nb", None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox[ButtonBox["References",
    ButtonData:>{"Literat.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSize->14,
    FontWeight->"Bold"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[{
  StyleBox[ButtonBox["Hyperlink Subject Index\n",
    ButtonData:>{"HyperlinkIndex.nb", None},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Index for ",
    ButtonData:>{"FunctionIndex.nb", 
      "Index for MathLie and Mathematica Functions"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["MathLie",
    ButtonData:>{"FunctionIndex.nb", 
      "Index for MathLie and Mathematica Functions"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[ButtonBox[" and ",
    ButtonData:>{"FunctionIndex.nb", 
      "Index for MathLie and Mathematica Functions"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"FunctionIndex.nb", 
      "Index for MathLie and Mathematica Functions"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[ButtonBox[" Functions",
    ButtonData:>{"FunctionIndex.nb", 
      "Index for MathLie and Mathematica Functions"},
    ButtonStyle->"Hyperlink"],
    FontSize->14,
    FontWeight->"Bold"]
}], "Text",
  PageBreakBelow->False,
  TextJustification->0],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"introduc.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
AutoGeneratedPackage->Automatic,
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{734, 668},
WindowMargins->{{14, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Introduction", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Introduction", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"SectionReferences"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1,
CounterBoxOptions->{CounterFunction:>Identity},
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "space-time translation"->{
    Cell[2501, 68, 252, 6, 27, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]},
  "symmetry principle"->{
    Cell[2501, 68, 252, 6, 27, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]},
  "laws of nature"->{
    Cell[2501, 68, 252, 6, 27, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"space-time translation", 35651, 1044},
  {"symmetry principle", 35838, 1049},
  {"laws of nature", 36021, 1054}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 348, 6, 94, "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2090, 59, 408, 7, 131, "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2501, 68, 252, 6, 27, "Text",
  PageBreakBelow->False,
  CellTags->{
  "space-time translation", "symmetry principle", "laws of nature"}],

Cell[CellGroupData[{
Cell[2778, 78, 57, 1, 31, "Subsubsection",
  PageBreakBelow->False],
Cell[2838, 81, 281, 8, 61, "Text",
  PageBreakBelow->False],
Cell[3122, 91, 144, 4, 39, "Input",
  PageBreakBelow->False,
  InitializationCell->True],
Cell[3269, 97, 176, 6, 27, "Text",
  PageBreakBelow->False],
Cell[3448, 105, 363, 7, 71, "Input",
  PageBreakBelow->False,
  InitializationCell->True],
Cell[3814, 114, 73, 1, 27, "Text",
  PageBreakBelow->False],

Cell[CellGroupData[{
Cell[3912, 119, 98, 3, 23, "Input",
  PageBreakBelow->False,
  InitializationCell->True],
Cell[4013, 124, 73, 1, 22, "Print"],
Cell[4089, 127, 73, 1, 22, "Print"],
Cell[4165, 130, 36, 1, 22, "Print"],
Cell[4204, 133, 84, 1, 22, "Print"],
Cell[4291, 136, 96, 2, 22, "Print"],
Cell[4390, 140, 74, 1, 22, "Print"],
Cell[4467, 143, 101, 2, 22, "Print"],
Cell[4571, 147, 83, 1, 22, "Print"],
Cell[4657, 150, 84, 1, 22, "Print"],
Cell[4744, 153, 50, 1, 22, "Print"],
Cell[4797, 156, 84, 1, 22, "Print"]
}, Open  ]],
Cell[4896, 160, 121, 4, 27, "Text",
  PageBreakBelow->False],
Cell[5020, 166, 602, 15, 39, "Input",
  PageBreakBelow->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5659, 186, 25, 0, 21, "Subsubsection"],
Cell[5687, 188, 159, 4, 27, "Text",
  PageBreakBelow->False],
Cell[5849, 194, 165, 4, 27, "Text",
  PageBreakBelow->False],
Cell[6017, 200, 159, 4, 28, "Text",
  PageBreakBelow->False],
Cell[6179, 206, 366, 15, 32, "Text",
  PageBreakBelow->False],
Cell[6548, 223, 1567, 47, 151, "Text",
  PageBreakBelow->False],
Cell[8118, 272, 2973, 74, 253, "Text",
  PageBreakBelow->False],
Cell[11094, 348, 4424, 116, 423, "Text",
  PageBreakBelow->False],
Cell[15521, 466, 4885, 128, 491, "Text",
  PageBreakBelow->False],
Cell[20409, 596, 1302, 37, 134, "Text",
  PageBreakBelow->False],
Cell[21714, 635, 1642, 44, 151, "Text",
  PageBreakBelow->False],
Cell[23359, 681, 1660, 48, 168, "Text",
  PageBreakBelow->False],
Cell[25022, 731, 3218, 87, 306, "Text",
  PageBreakBelow->False],
Cell[28243, 820, 2882, 78, 288, "Text",
  PageBreakBelow->False],
Cell[31128, 900, 942, 32, 85, "Text",
  PageBreakBelow->False],
Cell[32073, 934, 281, 11, 29, "Text",
  PageBreakBelow->False],
Cell[32357, 947, 1292, 40, 49, "Text",
  PageBreakBelow->False],
Cell[33652, 989, 148, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

