(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    397680,       7577]*)
(*NotebookOutlinePosition[    418826,       8154]*)
(*  CellTagsIndexPosition[    416038,       8072]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["2", "ChapterLine",
  CellTags->"1.1"],

Cell["Elements of Symmetry Analysis", "Title",
  CellTags->"1.1"],

Cell[TextData[{
  "At the beginning we will introduce some basic concepts which will be \
important throughout the whole book. First, we define the general properties \
of a group. These group properties are extended to Lie groups in the next \
step. The related Lie algebra connected with the Lie group is then \
introduced. We also introduce the notion of a vector field which is closely \
related to Lie algebras. We present all these highly abstract terms in \
connection with ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Different examples serve to vitalize the mathematical expressions. This \
chapter serves also to describe the first steps in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and introduce its notation. The elementary representation of mathematical \
expressions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides the connection between mathematics and computer algebra."
}], "Text",
  Evaluatable->False,
  CellTags->{"general properties of a group", "computer algebra"}],

Cell[CellGroupData[{

Cell[TextData[{
  "2.",
  CounterBox["Section"],
  ".",
  " Groups and Lie Groups"
}], "Section",
  Evaluatable->False,
  CellTags->"Groups and Lie Groups"],

Cell["\<\
It is the purpose of this section to record, for later reference, \
some of the results from group theory which will be needed in the text. The \
notation of a group is introduced in this chapter and the most important \
properties of group elements are deduced. Illustrations are given from a few \
very simple groups. Proofs will be minimal or omitted.\
\>", "Text",
  Evaluatable->False,
  CellTags->"group theory"],

Cell[CellGroupData[{

Cell[TextData[{
  "2.1.",
  CounterBox["Subsection"],
  " ",
  "Groups"
}], "Subsection",
  Evaluatable->False,
  CellTags->"Groups"],

Cell["\<\
Although we shall soon come to some illustrative examples, it is \
worth beginning with the abstract definition of a group which is very simple \
and yet leads to many important consequences.\
\>", "Text",
  Evaluatable->False],

Cell["Definition: Group", "Definition",
  CellTags->"Definition: Group"],

Cell[TextData[{
  "A set \[GothicCapitalG] of elements ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\({G\_1\),
                "TraditionalForm"], ",", \(G\_2\)}],
            "TraditionalForm"], ",", \(G\_3\)}], TraditionalForm]]],
  ",\[Ellipsis]} is said to form a group if a rule of composition is defined \
for the elements satisfying certain conditions. The result of a  \
multiplication involving two elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_k\)]],
  " is called the product or composition of the two elements and is written ",
  
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_k\)]],
  ". The conditions which such a product has to satisfy are as follows:"
}], "Text",
  Evaluatable->False,
  CellTags->{"composition", "group multiplication", "group"}],

Cell["(i) Closure relation: ", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times",
  CellTags->{"closure relation", "group properties"}],

Cell[TextData[{
  "The product ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_k\)]],
  " of any two elements is itself an element in the set, i.e.,"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubscriptBox["G", 
                StyleBox["i",
                  FontFamily->"Times"]],
              FontFamily->"Times"], " ", "\[CirclePlus]", " ", 
            StyleBox[\(G\_k\),
              FontFamily->"Times"]}], " ", "=", " ", 
          StyleBox[\(G\_j\),
            FontFamily->"Times"]}],
        "TraditionalForm"], "  ", "with", "  ", 
      FormBox[
        RowBox[{
          StyleBox[\(G\_j\),
            FontFamily->"Times"], " ", "\[Element]", " ", 
          "\[GothicCapitalG]"}],
        "TraditionalForm"]}]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell["(ii) Associativity:", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times",
  CellTags->"associativity"],

Cell[TextData[{
  "If three elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i, G\_k\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_j\)]],
  " are multiplied, it does not matter which product is carried out first, \
i.e.,"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "\t\t",
  Cell[BoxData[
      \(TraditionalForm
      \`G\_i\ \[CirclePlus]\ \((G\_k\ \[CirclePlus]\ G\_j)\)\  = \ 
        \(\((G\_i\ \[CirclePlus]\ G\_k)\)\ \[CirclePlus]\ G\_j\  = \ 
          G\_i\ \[CirclePlus]\ G\_k\ \[CirclePlus]\ \(G\_j . \)\)\)]]
}], "DisplayFormula",
  Evaluatable->False],

Cell["\<\
This equality shows that the use of brackets is not necessary.\
\>",
   "Text",
  Evaluatable->False],

Cell["(iii) Identity element:", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times",
  CellTags->"identity element"],

Cell[TextData[{
  "One element of the set \[GothicCapitalG], denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`E\)]],
  " and called the identity element, must have the properties"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`E\ \[CirclePlus]\ G\_i\  = \ G\_i\)]],
  "  and   ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ E\  = \ G\_i\)]]
}], "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "for all ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\  \[Element] \ \[GothicCapitalG]\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell["(iv) Inverse:", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times"],

Cell[TextData[{
  "To each element ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " in the set \[GothicCapitalG], there corresponds another element in the \
set, denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\%\(-1\)\)]],
  " and called the inverse, which has the properties"
}], "Text",
  Evaluatable->False,
  CellTags->"inverse element"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`G\_i\ \[CirclePlus]\ G\_i\%\(-1\)\  = \ 
        \(E\  = \ G\_i\%\(-1\)\ \[CirclePlus]\ G\_i\)\)]],
  ".\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "In general, it is not permissible to change the order of multiplication of \
group elements; i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`\(G\_i\ \[CirclePlus]\ G\_j\ \ \)\)]],
  "is not, in general, the same element as ",
  Cell[BoxData[
      \(TraditionalForm\`G\_j\ \[CirclePlus]\ G\_i\)]],
  ". A group which satisfies this exception, ",
  Cell[BoxData[
      \(TraditionalForm
      \`G\_i\ \[CirclePlus]\ G\_j\  = \ G\_j\ \[CirclePlus]\ G\_i\)]],
  ", is called an Abelian group. Its elements are said to commute. The axioms \
(i)\[Dash](iv) stated above are the main ingredients of group theory. \
However, these properties are abstract entities which need a practical \
realization. A convenient method of recording the multiplication, ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_j\  = \ G\_k\)]],
  ", of elements of a particular group \[GothicCapitalG] is to build the \
multiplication table in which the rows and columns are labeled by the group \
elements and the result ",
  Cell[BoxData[
      \(TraditionalForm\`G\_k\)]],
  " of the multiplication is entered at the intersection of the row ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["G", 
          StyleBox["i",
            FontSlant->"Italic"]], TraditionalForm]]],
  " and the column ",
  Cell[BoxData[
      \(TraditionalForm\`G\_j\)]],
  ". The definition of a group implies that every group element must appear \
once and only once in each row and in each column."
}], "Text",
  Evaluatable->False,
  CellTags->{"Abelian group", "multiplication table"}],

Cell[TextData[{
  "Deliberately, we did not specify the number of elements in the group. In \
fact, the number may be finite or it may be infinite. Correspondingly, the \
group is called a finite or an infinite group. In this book, we shall \
encounter both groups since they both are of importance in symmetry analysis. \
If we find a finite group order, we will denote the number of elements ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " as the order of the group."
}], "Text",
  Evaluatable->False,
  CellTags->{"finite group", "infinite group"}],

Cell["\<\
The simplest examples of group elements are natural numbers with \
ordinary multiplication. We will discuss two examples.\
\>", "Text",
  Evaluatable->False],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Let us assume we only know the two numbers 1 and \[Dash]1 and the ordinary \
multiplication as group operation. The identity of this group is clearly 1. \
The inverse of the identity is again the identity. The inverse of \[Dash]1 is \
\[Dash]1 itself. The properties of this group are contained in the group  \
multiplication table ",
  StyleBox["tab1 ",
    FontSlant->"Italic"],
  "below. We can create the group table in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by defining the group \[GothicCapitalG] as  the set"
}], "Text",
  Evaluatable->False,
  CellTags->{"multiplication", "multiplication table"}],

Cell[BoxData[
    \(\(G = {\(-1\), 1}; \)\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Using all combinations of the elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " in the group table, we get"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab1 = 
      MatrixForm[
        Table[G\[LeftDoubleBracket]i\[RightDoubleBracket]\ 
            G\[LeftDoubleBracket]j\[RightDoubleBracket], {i, 1, 2}, {j, 1, 
            2}]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-1\)},
            {\(-1\), "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"representing the core of the multiplication table.\[ThickSpace]\[ThickSpace]\
\[ThickSpace]\[EmptySquare]"], "Text",
  Evaluatable->False,
  CellTags->"multiplication table"],

Cell["Example 2", "Example"],

Cell["\<\
A slightly larger group of the same kind is the set of numbers\
\>",
   "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(G2 = {\(-1\), 1, \(-I\), I}; \)\)], "Input",
  PageWidth->Infinity],

Cell["which possesses the multiplication table ", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab2 = 
      MatrixForm[
        Table[G2\[LeftDoubleBracket]i\[RightDoubleBracket]\ 
            G2\[LeftDoubleBracket]j\[RightDoubleBracket], {i, 1, 4}, \n
          \t\t\t{j, 1, 4}]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-1\), "I", \(-I\)},
            {\(-1\), "1", \(-I\), "I"},
            {"I", \(-I\), \(-1\), "1"},
            {\(-I\), "I", "1", \(-1\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Because ordinary multiplication is used in both examples, these groups \
must be Abelian since it does not matter in which order the elements of the \
sets are used. To demonstrate this, let us exchange the ",
  StyleBox["j",
    FontSlant->"Italic"],
  "th element by the ",
  StyleBox["i",
    FontSlant->"Italic"],
  "th element in the table above."
}], "Text",
  Evaluatable->False,
  CellTags->"Abelian group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      Table[G2\[LeftDoubleBracket]j\[RightDoubleBracket]\ 
          G2\[LeftDoubleBracket]i\[RightDoubleBracket], {i, 1, 4}, {j, 1, 4}]]
      \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-1\), "I", \(-I\)},
            {\(-1\), "1", \(-I\), "I"},
            {"I", \(-I\), \(-1\), "1"},
            {\(-I\), "I", "1", \(-1\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing both group tables of ",
  StyleBox["G2",
    FontSlant->"Italic"],
  " demonstrates that the order of the group elements in the multiplication \
does not matter.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->"group element"],

Cell[TextData[{
  "For physical systems, rotations are of considerable importance. It is well \
known that various sets of rotations form groups. The rotations were one of \
the favorite groups used by Lie to demonstrate the action of his \
examinations. In reminiscence of this historical note, let us examine a few \
examples related to that topic. The law of multiplication in this case is \
defined by transition from one location to another\[LongDash]if a rotation ",
  Cell[BoxData[
      \(TraditionalForm\`R\_1\)]],
  " carries a system from position A to position B and if ",
  Cell[BoxData[
      \(TraditionalForm\`R\_2\)]],
  " carries it from B to C, then the product ",
  Cell[BoxData[
      \(TraditionalForm\`R\_1\ \[CirclePlus]\ R\_2\)]],
  " carries it from A to C. It is obvious that this definition of \
multiplication can, in general, not create an Abelian group. Of course, \
rotations about a common axis are Abelian. However, rotations in \
higher-dimensional spaces in general do not commute. Let us demonstrate these \
two statements by simple examples."
}], "Text",
  Evaluatable->False,
  CellTags->{"rotations", "Abelian group"}],

Cell["Example 3", "Example"],

Cell[TextData[{
  "To illustrate the commutative and non-commutative properties of rotations, \
let us define a function which carries out a two- and a three-dimensional \
rotation of an object. The function ",
  StyleBox["Rotation[]", "MmaText"],
  " uses the standard package ",
  StyleBox["Geometry`Rotation`", "MmaText"],
  " to represent the rotation matrices in two and three dimensions. The \
function ",
  StyleBox["Rotation[]", "MmaText"],
  " will take a polygon and an angle as input parameters. This function \
generates the geometrical shape of the object and carries out a rotation.  \
First, let us define the geometrical object by a polygon"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],

Cell[BoxData[
    \(\(hexagon = 
      Polygon[Table[{Cos[i], Sin[i]}, \n
          \t\t\t{i, 0, 2\ \[Pi], \(2\ \[Pi]\)\/6}]]; \)\)], "Input",
  PageWidth->Infinity],

Cell["\<\
Our favorite object is a hexagon which can be graphically displayed \
by the following lines:\
\>", "Text",
  Evaluatable->False,
  CellTags->"display"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{RGBColor[1, 0, 0], \n\t\t\thexagon}], 
      AspectRatio \[Rule] Automatic]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .86603 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.433013 0.47619 [
[ 0 0 0 0 ]
[ 1 .86603 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .86603 L
0 .86603 L
closepath
clip
newpath
1 0 0 r
.97619 .43301 m
.7381 .84541 L
.2619 .84541 L
.02381 .43301 L
.2619 .02062 L
.7381 .02062 L
.97619 .43301 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{120.5, 108},
  ImageMargins->{{92, 0}, {0, 0}},
  ImageRegion->{{-0.427984, 1.42387}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001h0000K1000`40O003h00ON7oo001hOol007Qo
o`00N7oo000MOollO00OOol001eoocal01moo`0077oo?W`07Woo000LOolnO00NOol001]ood1l01eo
o`006Woo@W`077oo000JOom2O00LOol001UoodAl01]oo`006GooA7`06goo000HOom6O00JOol001Qo
odIl01Yoo`005gooB7`06Goo000FOom:O00HOol001IoodYl01Qoo`005GooC7`05goo000EOom<O00G
Ool001Aoodil01Ioo`004gooD7`05Goo000COom@O00EOol0019ooe9l01Aoo`004WooDW`057oo000A
OomDO00COol0011ooeIl019oo`0047ooEW`04Woo000?OomHO00AOol000mooeQl015oo`003WooFW`0
47oo000>OomJO00@Ool000eooeal00moo`0037ooGW`03Woo000<OomNO00>Ool000]oof1l00eoo`00
2gooH7`03Goo000:OomRO00<Ool000UoofAl00]oo`002GooI7`02goo0008OomVO00:Ool000QoofIl
00Yoo`001gooJ7`02Goo0006OomZO008Ool000IoofYl00Qoo`001GooK7`01goo0005Oom/O007Ool0
00Aoofil00Ioo`0017ooKW`01Woo0003Oom`O005Ool0009oog9l00Aoo`000WooLW`017oo00000goo
O01l001bO003Ool00003Ooml07`0079l00=oo`00MW`00Woo00000gooO01l001bO003Ool00003Ooml
07`0079l00=oo`000WooLW`017oo0002OombO004Ool000=oog1l00Eoo`0017ooKW`01Woo0004Oom^
O006Ool000Eoofal00Moo`001GooK7`01goo0006OomZO008Ool000IoofYl00Qoo`001gooJ7`02Goo
0008OomVO00:Ool000QoofIl00Yoo`002GooI7`02goo0009OomTO00;Ool000Yoof9l00aoo`002goo
H7`03Goo000;OomPO00=Ool000aooeil00ioo`0037ooGW`03Woo000=OomLO00?Ool000iooeYl011o
o`003WooFW`047oo000?OomHO00AOol000mooeQl015oo`0047ooEW`04Woo000@OomFO00BOol0015o
oeAl01=oo`004WooDW`057oo000BOomBO00DOol001=ooe1l01Eoo`004gooD7`05Goo000DOom>O00F
Ool001Eoodal01Moo`005GooC7`05goo000FOom:O00HOol001IoodYl01Qoo`005gooB7`06Goo000H
Oom6O00JOol001QoodIl01Yoo`006GooA7`06goo000IOom4O00KOol001Yood9l01aoo`006Woo@W`0
77oo000KOom0O00MOol001aoocil01ioo`0077oo?W`07Woo000MOollO00OOol001eoocal01moo`00
7Woo>W`087oo001hOol007Qoo`00\
\>"],
  ImageRangeCache->{{{-51.5625, 170.563}, {107, 0}} -> {-1.01132, -0.909337, \
0.016997, 0.016997}}]
}, Open  ]],

Cell[TextData[{
  "This object will be rotated by our function ",
  StyleBox["Rotation[]", "MmaText"],
  ". In a two-dimensional space, the function is defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " terms by  "
}], "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],

Cell[BoxData[
    \(<< "\<Geometry`Rotations`\>"\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[{
    \(\(Clear[Rotation]; \)\), 
    \(Rotation[polygon_Polygon, angle_] := \n\t
      Block[{points}, \n\t\tpoints = polygon /. Polygon[x___] \[Rule] x; \n
        \t\tPolygon[\((Rotate2D[#1, angle]&)\)/@points]]\)}], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The function ",
  StyleBox["Rotation[]", "MmaText"],
  " needs a polygon and the angle of rotation as input quantities. It returns \
a clockwise-rotated polygon. The application of the function ",
  StyleBox["Rotation[]", "MmaText"],
  " on our hexagon gives us"
}], "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{RGBColor[0.000, 0.000, 1.000], \n\t\t\t
          Rotation[hexagon, \[Pi]\/5]}], AspectRatio \[Rule] Automatic]\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08864 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.521255 0.54432 0.521255 [
[ 0 0 0 0 ]
[ 1 1.08864 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08864 L
0 1.08864 L
closepath
clip
newpath
0 0 1 r
.9217 .23793 m
.97619 .75633 L
.55449 1.06272 L
.0783 .85071 L
.02381 .33231 L
.44551 .02592 L
.9217 .23793 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{109.813, 128.188},
  ImageMargins->{{86, 0}, {0, 0}},
  ImageRegion->{{-0.679842, 1.6917}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001]0000P1000`40O003h00OKGoo001]Ool006eo
o`00KGoo000_Ool301lkOol002eoo`L07cUoo`00;7oo2P0O=goo000[Ool=01leOol002Uooa807c9o
o`00:7oo5@0O<7oo000WOolH01l^Ool002Eooa`07baoo`0097oo800O:Goo000SOolS01lWOol0025o
obL07bEoo`0087oo:P0O8goo000NOol_01lPOol001eooc807aioo`0077oo=@0O77oo000JOoli01lJ
Ool001Uooc`07aQoo`0067oo@00O5Goo000FOom401lCOol001EoodL07a5oo`0057ooBP0O3goo000B
Oom?01l<Ool0015ooe807`Yoo`0047ooE@0O27oo000>OomJ01l5Ool000eooe/07`Eoo`002gooG@0O
1Goo000:OomN01l5Ool000Uooel07`Eoo`001gooH@0O1Goo0006OomS01l4Ool000Eoof@07`Aoo`00
0gooIP0O17oo0002OomW01l4Ool00003Ool07`0O06H07`Aoo`00J@0O17oo001Y01l4Ool006T07`Ao
o`00J@0O17oo001Y01l4Ool006X07`=oo`00JP0O0goo001Z01l3Ool006X07`=oo`00JP0O0goo001Z
01l3Ool006X07`=oo`00JP0O0goo001Z01l3Ool006X07`=oo`00J`0O0Woo00000goo01l07`1X01l2
Ool00003Ool07`0O06P07`9oo`0000=oo`0O01l0J00O0Woo00000goo01l07`1X01l2Ool00003Ool0
7`0O06P07`9oo`0000=oo`0O01l0J00O0Woo00000goo01l07`1X01l2Ool00003Ool07`0O06P07`9o
o`0000=oo`0O01l0J00O0Woo00000goo01l07`1Y01l1Ool0009oofX07`5oo`000WooJP0O0Goo0002
OomZ01l1Ool0009oofX07`5oo`000WooJP0O0Goo0002OomZ01l1Ool0009oofX07`5oo`000WooJP0O
0Goo0002OomZ01l1Ool0009oof/07`000gooJP0O0003OomZ01l000=oofX07`000gooJP0O0003OomZ
01l000=oofX07`000gooJP0O0003OomZ01l000=oofX07`000gooJP0O0004OomY01l000AoofT07`00
17ooJ@0O0004OomY01l000AoofT07`0017ooJ@0O0004OomW01l2Ool000AoofH07`=oo`0017ooI@0O
17oo0004OomS01l6Ool000Eoof407`Moo`001GooG`0O2Goo0005OomN01l:Ool000Eooed07`]oo`00
1GooF`0O3Goo0005OomJ01l>Ool000MooeH07a1oo`002GooD`0O4Goo000;Oom@01lBOol000iood/0
7aAoo`0047ooB00O5Goo000BOom401lGOol001Eood007aQoo`005goo?@0O6Goo000IOoli01lKOol0
01aoocD07aaoo`007Woo<@0O7Woo000POol^01lOOol002=oobX07b1oo`009Goo9P0O8Woo000WOolS
01lSOol002Yooah07bEoo`00;7oo6`0O9Woo000^OolH01lWOol0035ooa<07bUoo`00<goo400O:Woo
000eOol<01l/Ool003Qoo`P07beoo`00>Woo1@0O;Woo001]Ool006eoo`00KGoo001]Ool00001\
\>"],
  ImageRangeCache->{{{-74.625, 184.75}, {127.188, 0}} -> {-0.90417, -1.04426, \
0.0164208, 0.0164208}}]
}, Open  ]],

Cell[TextData[{
  "The result shows that the original hexagon is rotated by an angle of \
\[Pi]/5. Having the function ",
  StyleBox["Rotation[]", "MmaText"],
  " available, we are able to check the group properties of a group. Let us \
start by testing if the two rotations commute. If we assume that the first \
rotation ",
  Cell[BoxData[
      \(TraditionalForm\`R\_1\)]],
  " rotates the hexagon through an angle \[Dash]\[Pi]/3 and the second ",
  Cell[BoxData[
      \(TraditionalForm\`R\_2\)]],
  " through an angle \[Dash]\[Pi]/4, we can combine the rotations either by ",
  
  Cell[BoxData[
      \(TraditionalForm\`\(R\_1\ \[CirclePlus]\ R\_2\ \)\)]],
  "or ",
  Cell[BoxData[
      \(TraditionalForm\`R\_2\ \[CirclePlus]\ R\_1\)]],
  ". These two mathematical relations are realized in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by the following lines. The result of the two different sequences of \
rotations is shown in the following:"
}], "Text",
  Evaluatable->False,
  CellTags->"hexagon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\n
        \t\t{Graphics[{RGBColor[0, 0, 1], \n\t\t\t\t\t
              Rotation[Rotation[hexagon, \[Pi]\/3], \(-\(\[Pi]\/4\)\)]}, \n
            \t\t\t\tAspectRatio \[Rule] Automatic], \n\t\t\t
          Graphics[{RGBColor[1, 0, 0], \n\t\t\t\t\t
              Rotation[Rotation[hexagon, \(-\(\[Pi]\/4\)\)], \[Pi]\/3]}, \n
            \t\t\t\tAspectRatio \[Rule] Automatic]}]]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.492989 0.5 0.492989 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.97619 .37241 m
.8486 .8486 L
.37241 .97619 L
.02381 .62759 L
.1514 .1514 L
.62759 .02381 L
.97619 .37241 L
F
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.492989 0.5 0.492989 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.97619 .37241 m
.8486 .8486 L
.37241 .97619 L
.02381 .62759 L
.1514 .1514 L
.62759 .02381 L
.97619 .37241 L
F
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{207, 108},
  ImageMargins->{{56.5, 0}, {0, 0}},
  ImageRegion->{{-0.030588, 1.02823}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003?0000K1000`40O003h00Ocgoo003?Ool00<mo
o`00cgoo003?Ool00<moo`00cgoo003?Ool003Yoo`<07fYoo`=l02Eoo`00=Woo200OIGoo27`097oo
000bOol=01mPOol=O00SOol002mooa407eaooa5l029oo`00:goo5P0OEgoo5W`08Goo000XOolJ01mC
OolJO00POol002Aooal07diooaml01moo`0087oo900OBGoo97`07Woo000MOolX01m5OolXO00MOol0
01Uoobd07d1oobel01aoo`005Woo<@0O?7oo<G`06goo000BOolf01lgOolfO00JOol000eooc`07c5o
ocal01Uoo`003Goo?@0O<7oo?G`067oo000<Oolo01l^OoloO00GOol000aood007beood1l01Ioo`00
37oo@@0O;7oo@G`05Goo000<Oom301lZOom3O00COol000]oodD07bQoodEl019oo`002gooAP0O9goo
AW`04Goo000;Oom701lVOom7O00@Ool000]oodP07bEoodQl00moo`002WooBP0O8gooBW`03Woo000:
Oom;01lROom;O00=Ool000Yood`07b5oodal00aoo`002WooC@0O87ooCG`02goo0009Oom?01lNOom?
O00:Ool000Uooe007aeooe1l00Uoo`002GooD@0O77ooDG`027oo0009OomB01lKOomBO007Ool000Qo
oe@07aUooeAl00Ioo`0027ooE@0O67ooEG`01Goo0008OomF01lGOomFO004Ool000QooeL07aIooeMl
00=oo`001gooF00O5GooF7`00goo0007OomG01lFOomGO004Ool000MooeL07aIooeMl00Aoo`001goo
E`0O5WooEg`017oo0006OomH01lEOomHO004Ool000IooeL07aIooeMl00Eoo`001WooE`0O5WooEg`0
1Goo0006OomG01lFOomGO005Ool000EooeP07aEooeQl00Eoo`001GooE`0O5WooEg`01Woo0005OomG
01lFOomGO006Ool000EooeL07aIooeMl00Ioo`0017ooE`0O5WooEg`01goo0004OomG01lFOomGO007
Ool000AooeL07aIooeMl00Moo`0017ooE`0O5WooEg`01goo0003OomG01lFOomGO008Ool000=ooeL0
7aIooeMl00Qoo`000gooE`0O5WooEg`027oo0003OomF01lGOomFO009Ool0009ooeL07aIooeMl00Uo
o`000WooE`0O5WooEg`02Goo0002OomG01lFOomGO009Ool0009ooeH07aMooeIl00Yoo`0000=oo`0O
01l0E@0O5WooEg`02Woo00000goo01l07`1E01lFOomGO00:Ool0009ooeH07aMooeIl00Yoo`000goo
E00O6GooE7`02goo0004OomC01lJOomCO00;Ool000Eooe807a]ooe9l00]oo`001WooD00O7GooD7`0
37oo0007Oom?01lNOom?O00<Ool000Qoodh07amoodil00aoo`002GooC@0O87ooCG`037oo000:Oom;
01lROom;O00=Ool000]oodX07b=oodYl00eoo`0037ooB@0O97ooBG`03Goo000=Oom701lVOom7O00>
Ool000ioodH07bMoodIl00ioo`003gooA@0O:7ooAG`03Woo000@Oom401lYOom4O00>Ool0015ood80
7b]ood9l00moo`004Woo@@0O;7oo@G`03goo000COom001l]Oom0O00?Ool001Aoocl07bioocml00mo
o`005Goo?@0O<7oo?G`047oo000FOoll01laOollO00@Ool001MoocT07cAoocUl019oo`0067oo=00O
>Goo=7`05Woo000IOol_01lnOol_O00JOol001Yoob/07d9oob]l01eoo`006goo9P0OAgoo9W`08Goo
000LOolR01m;OolRO00TOol001eooad07e1ooael02Qoo`007Woo600OEGoo67`0;7oo000OOolD01mI
OolDO00_Ool0021oo`l07eioo`ml03=oo`008Goo2`0OHWoo2g`0=Woo000ROol601mWOol6O00jOol0
0<moo`00cgoo003?Ool00<moo`00cgoo003?Ool00<moo`00\
\>"],
  ImageRangeCache->{{{-6.3125, 211.813}, {107, 0}} -> {0.0107638, -0.0388869, \
0.00962761, 0.00962761}, {{-1.0625, 97.75}, {102.938, 4}} -> {-0.99242, \
-1.09891, 0.0205284, 0.0205284}, {{107.688, 206.563}, {102.938, 4}} -> \
{-3.22349, -1.09822, 0.0205154, 0.0205154}}]
}, Open  ]],

Cell[TextData[{
  "The result of the two sequences of rotations is the same. Thus, we \
conclude  from this graphical experiment that these two rotations in the \
plane commute. The net effect of the two rotations is a total rotation \
through an angle of \[Pi]/12. To illustrate the non-commutative property of \
rotations in higher dimensions, let us examine rotations in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". For example, let ",
  Cell[BoxData[
      \(TraditionalForm\`R\_Z\)]],
  " be a rotation through an angle \[Pi]/5 about the ",
  StyleBox["z",
    FontSlant->"Italic"],
  "-axis and ",
  Cell[BoxData[
      \(TraditionalForm\`R\_X\)]],
  " a rotation through \[Pi]/7 about the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axis. The geometrical object we will rotate is again a hexagon located in \
the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  "-plane. The polygon in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is represented in three dimensions by"
}], "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],

Cell[BoxData[
    \(\(hexagon = 
      Polygon[Table[{Cos[i], Sin[i], 0}, \n
          \t\t\t{i, 0, 2\ \[Pi], \(2\ \[Pi]\)\/6}]]; \)\)], "Input"],

Cell[TextData[{
  "with its ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " coordinate set equal to zero. The hexagon is displayed in three \
dimensions by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics3D[{RGBColor[1.000, 0.000, 0.000], \n\t\t\thexagon}], 
      AspectRatio \[Rule] Automatic]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08923 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0587749 1.1548 0 1.1548 [
[ 0 0 0 0 ]
[ 1 1.08923 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.086 .2508 m
0 .83357 L
s
0 .83357 m
.36329 1.08923 L
s
.36329 1.08923 m
.38526 .55596 L
s
.38526 .55596 m
.086 .2508 L
s
.69385 0 m
.92501 .37666 L
s
.92501 .37666 m
1 .94081 L
s
1 .94081 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.086 .2508 m
0 .83357 L
s
0 .83357 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.69385 0 m
.086 .2508 L
s
.38526 .55596 m
.92501 .37666 L
s
.92501 .37666 m
1 .94081 L
s
1 .94081 m
.36329 1.08923 L
s
.36329 1.08923 m
.38526 .55596 L
s
0 0 m
1 0 L
1 1.08923 L
0 1.08923 L
closepath
clip
newpath
.5 Mabswid
.51042 .75567 m .23836 .66713 L p .83093 .47741 L .656 .751 .92 r
F P
0 g
s
.83093 .47741 m .78886 .6755 L .51042 .75567 L p .656 .751 .92 r
F P
0 g
s
.23836 .66713 m .21425 .46691 L p .83093 .47741 L .656 .751 .92 r
F P
0 g
s
.21425 .46691 m .52892 .35349 L .83093 .47741 L p .656 .751 .92 r
F P
0 g
s
.25 Mabswid
.69385 0 m
.92501 .37666 L
s
.92501 .37666 m
1 .94081 L
s
1 .94081 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.086 .2508 m
0 .83357 L
s
0 .83357 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.69385 0 m
.086 .2508 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{300, 143},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000Sa000`40O003h00O[Goo0P00OGoo002[
Ool200000goo0000001lOol00:Uoo`8000=oo`8007aoo`00YWoo0`001Goo00<007oo0000Ngoo002T
Ool20008Ool00`00Ool0001kOol00:5oo`<000Yoo`04001oogoo001jOol009moo`8000eoo`05001o
ogooOol0001iOol009eoo`8000moo`05001oogooOol0001iOol009Yoo`<0015oo`03001oogoo009o
o`03001oogoo07Ioo`00V7oo0P005Goo00D007ooOomoo`0007Qoo`00UGoo0`005goo00<007ooOol0
0Woo00<007ooOol0MGoo002COol2000JOol00`00Oomoo`03Ool00`00Oomoo`1dOol0095oo`8001ao
o`03001oogoo00=oo`03001oogoo07Aoo`00SWoo0`007Woo00<007ooOol017oo00<007ooOol0Lgoo
002<Ool2000QOol00`00Oomoo`04Ool00`00Oomoo`1cOol008Uoo`<002=oo`03001oogoo00Eoo`03
001oogoo079oo`00Qgoo0P009Woo00<007ooOol01Woo00<007ooOol0LGoo0025Ool2000XOol00`00
Oomoo`06Ool00`00Oomoo`1aOol0089oo`<002Yoo`03001oogoo00Moo`03001oogoo071oo`00P7oo
0P00;Goo00<007ooOol01goo00<007ooOol0L7oo001mOol3000_Ool00`00Oomoo`08Ool00`00Oomo
o`1_Ool007]oo`80039oo`03001oogoo00Uoo`03001oogoo06ioo`00NGoo0P00=7oo00<007ooOol0
2Goo00<007ooOol0KWoo001fOol3000fOol00`00Oomoo`0:Ool00`00Oomoo`1]Ool007Aoo`8003Uo
o`03001oogoo00Yoo`03001oogoo06eoo`00LGoo0`00?7oo00<007ooOol02Woo00<007ooOol0K7oo
001_Ool2000oOol00`00Oomoo`0;Ool00`00Oomoo`1[Ool006eoo`80045oo`03001oogoo00]oo`03
001oogoo06]oo`00JWoo0`00@goo00<007ooOol037oo00<007ooOol0JWoo001XOol20016Ool00`00
Oomoo`0<Ool00`00Oomoo`1ZOol006Eoo`<004Qoo`03001oogoo00eoo`03001oogoo06Uoo`00Hgoo
0P00Bgoo00<007ooOol03Woo00<007ooOol0J7oo001QOol2001=Ool00`00Oomoo`0>Ool00`00Oomo
o`1XOol005moo`8004moo`03001oogoo00moo`03001oogoo06Moo`00Ggoo0P00Cgoo00<007ooOol0
3goo00<007ooOol0Igoo001OOol00`00Ool0001>Ool00`00Oomoo`0@Ool00`00Oomoo`1VOol005mo
o`04001oogoo001=Ool00`00Oomoo`0AOol00`00Oomoo`1UOol005ioo`03001oogoo009oo`03001o
ogoo04Yoo`03001oogoo015oo`03001oogoo06Eoo`00GWoo00<007ooOol00goo00<007ooOol0BGoo
00<007ooOol04Woo00<007ooOol0I7oo001NOol00`00Oomoo`04Ool00`00Oomoo`18Ool00`00Oomo
o`0BOol00`00Oomoo`1TOol005ioo`03001oogoo00Eoo`03001oogoo04Moo`03001oogoo01=oo`03
001oogoo06=oo`00GWoo00<007ooOol01Woo00<007ooOol0Agoo00<007ooOol04goo00<007ooOol0
HWoo001NOol00`00Oomoo`07Ool00`00Oomoo`16Ool00`00Oomoo`0COol00`00Oomoo`1ROol005io
o`03001oogoo00Qoo`03001oogoo04Eoo`03001oogoo01Aoo`03001oogoo065oo`00GGoo00<007oo
Ool02Woo00<007ooOol0A7oo00<007ooOol057oo00<007ooOol0HGoo001MOol00`00Oomoo`0;Ool0
0`00Oomoo`13Ool00`00Oomoo`0EOol00`00Oomoo`1POol005eoo`03001oogoo00aoo`03001oogoo
049oo`03001oogoo01Ioo`03001oogoo05moo`00GGoo00<007ooOol03Goo00<007ooOol0:7oo0`00
5Woo00<007ooOol05Woo00<007ooOol0Ggoo001MOol00`00Oomoo`0>Ool00`00Oomoo`0TOol30000
0e;mC_aBo@02000DOol00`00Oomoo`0GOol00`00Oomoo`1NOol005eoo`03001oogoo00moo`03001o
ogoo021oo`<00005D_eBo5;lD_aBo@03D_`3000AOol00`00Oomoo`0GOol00`00Oomoo`1NOol005eo
o`03001oogoo011oo`03001oogoo01aoo`<0000>D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o080
00moo`03001oogoo01Moo`8005moo`00G7oo00<007ooOol04Woo00<007ooOol067oo0`0000EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mD_aBo002000=Ool00`00Oomoo`0DOol300000goo
001oo`1NOol005aoo`03001oogoo01=oo`03001oogoo01Aoo`<0000HD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l0`002Woo00<007ooOol04Goo0`0017oo00<007oo
Ool0GGoo001LOol00`00Oomoo`0COol00`00Oomoo`0AOol300001E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01U;mD_aBo5;lD_eBo08000Qoo`03001oogoo00ioo`<0
00Moo`03001oogoo05eoo`00G7oo00<007ooOol057oo00<007ooOol03Woo0P0002=BoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
00<000Eoo`03001oogoo00]oo`<000]oo`03001oogoo05aoo`00G7oo00<007ooOol05Goo00<007oo
Ool02Woo0`000e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@020003Ool00`00Oomoo`08Ool3000>Ool00`00Oomo
o`1LOol005aoo`03001oogoo01Ioo`03001oogoo00Ioo`<0000]C_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;mD_aBoDkl00@000Moo`<0015oo`03001oogoo05aoo`00G7oo00<007ooOol05goo00<007ooOol0
0Woo0`000e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l0P000goo0`0057oo00<0
07ooOol0G7oo001KOol00`00Oomoo`0IOol40000=dklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;mD_aBoDklD_eBo5;mC_aBoE;l00@001Moo`03001oogoo05aoo`00Fgoo00<007ooOol05goo0`00
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009Bo004001B
oE;lD_`2000EOol00`00Oomoo`1LOol005]oo`03001oogoo01Aoo`<00013C_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_`005;lD_e>o5;mD_`0
0P004goo00<007ooOol0G7oo001KOol00`00Oomoo`0BOol20003D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00IBoE;lD_aBo5;m0002D_`01E;mD_aBo5;l
D_d00`004Goo00<007ooOol0Fgoo001KOol00`00Oomoo`0BOol0C@00D_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo000C_aBoE;l
D_e>o5;mD_aBoDklD_d00P003goo00<007ooOol0Fgoo001KOol00`00Oomoo`0BOol01000D_aBo5;m
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;l001Bo@03D_`01E;mD_aBo5;lD_d00e;l0P003Goo00<007ooOol0Fgoo001KOol00`00Oomoo`0B
Ool0D@00C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o000D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_`0000=Ool00`00Oomoo`1K
Ool005Yoo`03001oogoo01=oo`03001BoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01U;mD_aBo5;lD_d0009Bo005D_eBo5;lD_aBo@03D_`015;m
D_aBo0003Goo00<007ooOol0Fgoo001JOol00`00Oomoo`0DOol0C`00D_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_`004klD_eBo5;m
C_aBoE;lD_e>o5;mD_aBo@0000ioo`03001oogoo05]oo`00FWoo00<007ooOol057oo00<005;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;l001Bo@03D_`01E;mD_aBo5;lD_d00e;l00<007ooOol037oo00<007ooOol0Fgoo001JOol00`00
Oomoo`0DOol0C`00D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_`005;lD_e>o5;mD_aBoDklD_eBo5;mC_aBo@0000ioo`03001oogoo
05]oo`00FWoo00<007ooOol057oo00D005;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m001Bo5;lD_d00e;l00MBoE;lD_aBo5;mD_`0
000?Ool00`00Oomoo`1JOol005Yoo`03001oogoo01Aoo`1?001BoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo000C_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;m00003goo00<007ooOol0FWoo001IOol00`00Oomoo`0EOol00`00D_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_`0
05;m00=Bo005D_eBo5;lD_aBo@02D_`00`00Oomoo`0>Ool00`00Oomoo`1JOol005Uoo`03001oogoo
01Eoo`1>001BoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o000D_aBoDklD_eBo5;mC_aBoE;lD_e>o00047oo00<007ooOol0FWoo001I
Ool00`00Oomoo`0EOol01@00D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo000D_aBo@03D_`01U;mD_aBo5;lD_d0011oo`03001o
ogoo05Yoo`00FGoo00<007ooOol05Goo04h005;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_d005;mD_aBoDklD_eBo5;mC_aBoE;l
000@Ool00`00Oomoo`1JOol005Uoo`03001oogoo01Ioo`03001BoE;l009Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l00000e;l00EBoE;l
D_aBo5;m009Bo003001oogoo00ioo`03001oogoo05Yoo`00FGoo00<007ooOol05Woo04`005;lD_e>
o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;m001BoDklD_eBo5;mC_aBoE;lD_d0019oo`03001oogoo05Uoo`00FGoo00<007ooOol05Woo00@0
05;lD_aBo@=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_`005;lD_d00e;l00EBoE;lD_aBo000019oo`03001oogoo05Uoo`00F7oo00<007ooOol0
5goo04`004klD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;mD_aBoDklD_eBo5;m001BoE;lD_e>o5;mD_aBoDklD_d0019oo`03001oogoo05Uoo`00F7oo00<0
07ooOol05goo00<005;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_`00003D_`01e;mD_aBo5;lD_eBo000019oo`03001oogoo05Uo
o`00F7oo00<007ooOol05goo040005;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o080000:D_e>o5;mD_aBoDklD_eBo5;m000BOol00`00
Oomoo`1IOol005Qoo`03001oogoo01Moo`04001Bo5;lD_d3D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01U;mD_aBo5;lD_eBo0<0009Bo003001BoE;l009Bo005D_eBo5;lD_`0000B
Ool00`00Oomoo`1IOol005Qoo`03001oogoo01Moo`0i001>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m00@0000>C_aBoE;lD_e>o5;m001BoDklD_eBo5;mC_`0
01=oo`03001oogoo05Uoo`00F7oo00<007ooOol067oo00D005;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00<00005D_eBo5;lD_aBo@03D_`01E;mD_`005;lD_d00e;l00=B
o@00Ool04goo00<007ooOol0F7oo001HOol00`00Oomoo`0HOol0<P00D_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_d300005E;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_`005;lD_e>
o5;mD_`0000DOol00`00Oomoo`1HOol005Moo`03001oogoo01Uoo`03001Bo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l100000EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_`005;lD_d0
0U;l00<007ooOol04Woo00<007ooOol0F7oo001GOol00`00Oomoo`0IOol0:`00D_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;l00<0000LD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o000D_aBoDkl000DOol00`00Oomoo`1HOol005Moo`03001oogoo01Uoo`80009Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`015;m
D_aBo5;l0`0000=Bo5;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`02E;mD_aB
o5;lD_eBo000D_`0000EOol00`00Oomoo`1HOol005Moo`03001oogoo01]oo`<0000PD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo0<0000O
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_`00P005Goo00<007ooOol0F7oo001GOol00`00Oomoo`0NOol30002D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@02D_`400000e;lD_eBo002D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00P005Goo00<007oo
Ool0F7oo001GOol00`00Oomoo`0QOol300004e;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;m00<0000RD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_`400000goo001oo`0DOol00`00Oomoo`1HOol005Moo`03001oogoo
02Aoo`<0009Bo005D_eBo5;lD_aBo@03D_`00e;mD_aBo0030002D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00U;l10001Woo00<007ooOol0
4goo00<007ooOol0Egoo001FOol00`00Oomoo`0XOol300001e;mC_aBoE;lD_e>o5;m00<0000QD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;m00<000]oo`03001oogoo019oo`03001oogoo05Moo`00EWoo00<007ooOol0:goo0P0000=Bo000
00000P000U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00IB
oE;lD_aBo5;mD_`4000?Ool00`00Oomoo`0AOol00`00Oomoo`1GOol005Ioo`03001oogoo02]oo`D0
000ND_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;m10004goo00<007ooOol04Goo00<007ooOol0Egoo001FOol00`00Oomoo`0XOol300000goo001o
o`02Ool30003D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo004D_eBo5;lD_`4000HOol0
0`00Oomoo`0@Ool00`00Oomoo`1GOol005Ioo`03001oogoo02Aoo`@000Aoo`03001oogoo00Aoo`<0
000AD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo003000MOol00`00Oomoo`0?Ool00`00
Oomoo`1GOol005Ioo`03001oogoo025oo`<000Qoo`03001oogoo00Moo`<000=Bo005D_eBo5;lD_aB
o@02D_`4000QOol00`00Oomoo`0>Ool00`00Oomoo`1GOol005Ioo`03001oogoo01ioo`<000]oo`03
001oogoo00Yoo`<00003D_aBoDkl00@002Ioo`03001oogoo00ioo`03001oogoo05Ioo`00EGoo00<0
07ooOol077oo0`003Woo00<007ooOol03Goo0`00:Woo00<007ooOol03Woo00<007ooOol0EWoo001E
Ool00`00Oomoo`0HOol4000AOol00`00Oomoo`0kOol00`00Oomoo`0=Ool00`00Oomoo`1FOol005Eo
o`03001oogoo01Eoo`<001Eoo`03001oogoo03aoo`03001oogoo00aoo`03001oogoo05Ioo`00EGoo
00<007ooOol04Woo0`0067oo00<007ooOol0?Goo00<007ooOol02goo00<007ooOol0EWoo001EOol0
0`00Oomoo`0?Ool3000KOol00`00Oomoo`0nOol00`00Oomoo`0:Ool00`00Oomoo`1FOol005Eoo`03
001oogoo00]oo`@001ioo`03001oogoo03moo`03001oogoo00Uoo`03001oogoo05Ioo`00EGoo00<0
07ooOol027oo0`008Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol0EGoo001DOol00`00
Oomoo`06Ool3000UOol00`00Oomoo`10Ool00`00Oomoo`09Ool00`00Oomoo`1EOol005Aoo`03001o
ogoo009oo`@002Qoo`03001oogoo045oo`03001oogoo00Qoo`03001oogoo05Eoo`00E7oo00<007oo
00000P00:goo00<007ooOol0@goo00<007ooOol01goo00<007ooOol0EGoo001DOol2000^Ool00`00
Oomoo`14Ool00`00Oomoo`06Ool00`00Oomoo`1EOol005Eoo`8002eoo`03001oogoo04Aoo`03001o
ogoo00Ioo`03001oogoo05Eoo`00Egoo00<007ooOol0:Woo00<007ooOol0AGoo00<007ooOol01Goo
00<007ooOol0EGoo001HOol00`00Oomoo`0YOol00`00Oomoo`16Ool00`00Oomoo`04Ool00`00Oomo
o`1EOol005Uoo`8002Uoo`03001oogoo04Moo`03001oogoo00Aoo`03001oogoo05Aoo`00Fgoo00<0
07ooOol09Woo00<007ooOol0B7oo00<007ooOol00goo00<007ooOol0E7oo001LOol2000VOol00`00
Oomoo`18Ool00`00Oomoo`03Ool00`00Oomoo`1DOol005ioo`03001oogoo02=oo`03001oogoo04Uo
o`03001oogoo009oo`03001oogoo05Aoo`00Ggoo0P008goo00<007ooOol0BWoo00D007ooOomoo`00
05Ioo`00HGoo00<007ooOol087oo00<007ooOol0Bgoo00@007ooOol005Ioo`00HWoo00<007ooOol0
7goo00<007ooOol0C7oo00<007oo0000EWoo001SOol2000OOol00`00Oomoo`1=Ool00`00Ool0001E
Ool006Eoo`03001oogoo01aoo`03001oogoo04eoo`03001oo`0005Eoo`00IWoo0P0077oo00<007oo
Ool0CWoo0P00EGoo001XOol00`00Oomoo`0IOol00`00Oomoo`1=Ool3001EOol006Uoo`8001Uoo`03
001oogoo04Uoo`@005Qoo`00Jgoo00<007ooOol05Woo00<007ooOol0AGoo1000G7oo001/Ool00`00
Oomoo`0EOol00`00Oomoo`10Ool5001POol006eoo`8001Eoo`03001oogoo03aoo`@006Eoo`00Kgoo
00<007ooOol04Woo00<007ooOol0=goo1@00JGoo001`Ool2000BOol00`00Oomoo`0cOol4001^Ool0
079oo`03001oogoo00moo`03001oogoo02moo`@0079oo`00Lgoo0P003Woo00<007ooOol0:goo1@00
MWoo001eOol00`00Oomoo`0;Ool00`00Oomoo`0WOol4001kOol007Ioo`03001oogoo00Yoo`03001o
ogoo02=oo`@007moo`00Mgoo0P002Woo00<007ooOol07Woo1@00Pgoo001iOol00`00Oomoo`07Ool0
0`00Oomoo`0JOol40028Ool007Yoo`8000Moo`03001oogoo01Ioo`@008aoo`00O7oo00<007ooOol0
17oo00<007ooOol04Goo1@00T7oo001mOol20004Ool00`00Oomoo`0=Ool4002EOol007moo`05001o
ogooOol0000:Ool5002IOol0081oo`04001oogoo0006Ool4002NOol0085oo`<0009oo`@00:9oo`00
Pgoo0`00YWoo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {142, 0}} -> {-0.509176, -4.71615*^-06, \
0.00664246, 0.00664246}}]
}, Open  ]],

Cell[TextData[{
  "To carry out the rotations about the three coordinate axes, we define \
three functions, ",
  StyleBox["RotationX[]", "MmaText"],
  ", ",
  StyleBox["RotationY[]", "MmaText"],
  ", and ",
  StyleBox["RotationZ[], ", "MmaText"],
  "in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The arguments are again the geometrical object and the angle of rotation \
with respect to the denoted axis."
}], "Text",
  Evaluatable->False,
  CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}],

Cell[BoxData[{
    \(\(Clear[RotationX, RotationY, RotationZ]; \)\), 
    \(RotationZ[polygon_Polygon, angle_] := \n\t
      Block[{points, mat1, mat2}, \n\t\t
        points = polygon /. Polygon[x___] \[Rule] x; \n\t\t
        mat1 = RotationMatrix2D[angle]; \n\t\tmat2 = IdentityMatrix[3]; \n\t\t
        mat2\[LeftDoubleBracket]1, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]2, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]1, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 2\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]2, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 2\[RightDoubleBracket]; \n\t\t
        Polygon[\((mat2 . #1&)\)/@points]]; \n\n
    RotationX[polygon_Polygon, angle_] := \n\t
      Block[{points, mat1, mat2}, \n\t\t
        points = polygon /. Polygon[x___] \[Rule] x; \n\t\t
        mat1 = RotationMatrix2D[angle]; \n\t\tmat2 = IdentityMatrix[3]; \n\t\t
        mat2\[LeftDoubleBracket]2, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]2, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 2\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 2\[RightDoubleBracket]; \n\t\t
        Polygon[\((mat2 . #1&)\)/@points]]; \n\n
    RotationY[polygon_Polygon, angle_] := \n\t
      Block[{points, mat1, mat2}, \n\t\t
        points = polygon /. Polygon[x___] \[Rule] x; \n\t\t
        mat1 = RotationMatrix2D[angle]; \n\t\tmat2 = IdentityMatrix[3]; \n\t\t
        mat2\[LeftDoubleBracket]1, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]1, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 2\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 2\[RightDoubleBracket]; \n\t\t
        Polygon[\((mat2 . #1&)\)/@points]]\)}], "Input"],

Cell[TextData[{
  "The two rotations about the ",
  StyleBox["z",
    FontSlant->"Italic"],
  "- and ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axes mentioned above are graphically represented by the following lines:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\n
        \t\t{Graphics3D[\n\t\t\t\t
            RotationX[RotationZ[hexagon, \[Pi]\/5], \[Pi]\/7], \n\t\t\t\t
            AspectRatio \[Rule] Automatic, \n\t\t\t\t
            ViewPoint \[Rule] {1.300, \(-2.400\), 2.000}], \n\t\t\t
          Graphics3D[\n\t\t\t\t
            RotationZ[RotationX[hexagon, \[Pi]\/7], \[Pi]\/5], \n\t\t\t\t
            AspectRatio \[Rule] Automatic, \n\t\t\t\t
            ViewPoint \[Rule] {1.300, \(-2.400\), 2.000}]}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .4022 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00957617 0.47619 [
[ 0 0 0 0 ]
[ 1 .4022 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .4022 L
0 .4022 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00957617 0.477324 0.392623 MathSubStart
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.04801 -0.0517306 1.04801 [
[ 0 0 0 0 ]
[ 1 .84462 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04344 .25483 m
0 .53173 L
s
0 .53173 m
.3931 .84462 L
s
.3931 .84462 m
.40209 .59363 L
s
.40209 .59363 m
.04344 .25483 L
s
.69004 0 m
.96388 .42236 L
s
.96388 .42236 m
1 .68765 L
s
1 .68765 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.04344 .25483 m
0 .53173 L
s
0 .53173 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.69004 0 m
.04344 .25483 L
s
.40209 .59363 m
.96388 .42236 L
s
.96388 .42236 m
1 .68765 L
s
1 .68765 m
.3931 .84462 L
s
.3931 .84462 m
.40209 .59363 L
s
0 0 m
1 0 L
1 .84462 L
0 .84462 L
closepath
clip
newpath
.5 Mabswid
.69383 .50115 m .3734 .56977 L p .7192 .3459 L .553 .897 .98 r
F P
0 g
s
.7192 .3459 m .88536 .39501 L .69383 .50115 L p .553 .897 .98 r
F P
0 g
s
.3734 .56977 m .16117 .54985 L p .7192 .3459 L .553 .897 .98 r
F P
0 g
s
.16117 .54985 m .30298 .43469 L .7192 .3459 L p .553 .897 .98 r
F P
0 g
s
.25 Mabswid
.69004 0 m
.96388 .42236 L
s
.96388 .42236 m
1 .68765 L
s
1 .68765 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.04344 .25483 m
0 .53173 L
s
0 .53173 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.69004 0 m
.04344 .25483 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00957617 0.97619 0.392623 MathSubStart
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.05375 -0.0578748 1.05375 [
[ 0 0 0 0 ]
[ 1 .83578 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.038 .24855 m
0 .49767 L
s
0 .49767 m
.41317 .83578 L
s
.41317 .83578 m
.41993 .61033 L
s
.41993 .61033 m
.038 .24855 L
s
.67226 0 m
.96913 .44493 L
s
.96913 .44493 m
1 .68234 L
s
1 .68234 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.038 .24855 m
0 .49767 L
s
0 .49767 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.67226 0 m
.038 .24855 L
s
.41993 .61033 m
.96913 .44493 L
s
.96913 .44493 m
1 .68234 L
s
1 .68234 m
.41317 .83578 L
s
.41317 .83578 m
.41993 .61033 L
s
0 0 m
1 0 L
1 .83578 L
0 .83578 L
closepath
clip
newpath
.5 Mabswid
.69176 .52387 m .37858 .65228 L p .71208 .24009 L .749 .916 .948 r
F P
0 g
s
.71208 .24009 m .87117 .33019 L .69176 .52387 L p .749 .916 .948 r
F P
0 g
s
.37858 .65228 m .16871 .61339 L p .71208 .24009 L .749 .916 .948 r
F P
0 g
s
.16871 .61339 m .31253 .39767 L .71208 .24009 L p .749 .916 .948 r
F P
0 g
s
.25 Mabswid
.67226 0 m
.96913 .44493 L
s
.96913 .44493 m
1 .68234 L
s
1 .68234 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.038 .24855 m
0 .49767 L
s
0 .49767 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.67226 0 m
.038 .24855 L
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{300, 143},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000Sa000`40O003h00Oogoo;Goo003oOol]
Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00
ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003oOol]Ool006=oo`800<Moo`00HGoo0P0000=o
o`000000T7oo0P00=7oo001NOol30003Ool2002>Ool200000goo0000000cOol005aoo`8000Ioo`03
001oo`0008Yoo`<000=oo`8003=oo`00FGoo0`0027oo00@007ooOol008Moo`8000Ioo`03001oo`00
039oo`00Egoo0P002goo00@007ooOol008Aoo`<000Qoo`04001oogoo000aOol005Aoo`<000eoo`05
001oogooOol00021Ool2000;Ool01000Oomoo`00<Goo001BOol2000@Ool01@00Oomoogoo0000OWoo
0`003Goo00D007ooOomoo`00031oo`00Cgoo0`004Woo00<007ooOol00Woo00<007ooOol0NGoo0P00
47oo00<007ooOol00Woo00<007ooOol0;Goo001=Ool2000EOol00`00Oomoo`03Ool00`00Oomoo`1e
Ool3000BOol00`00Oomoo`02Ool00`00Oomoo`0]Ool004Yoo`<001Moo`03001oogoo00=oo`03001o
ogoo079oo`<001Ioo`03001oogoo009oo`03001oogoo02aoo`00B7oo0P006goo00<007ooOol00goo
00<007ooOol0Kgoo0P006Goo00<007ooOol00goo00<007ooOol0:goo0015Ool3000MOol00`00Oomo
o`04Ool00`00Oomoo`1[Ool3000KOol00`00Oomoo`03Ool00`00Oomoo`0[Ool004=oo`80021oo`03
001oogoo00Aoo`03001oogoo06Uoo`8001ioo`03001oogoo00Aoo`03001oogoo02Yoo`00@7oo0`00
8Woo00<007ooOol01Goo00<007ooOol0IGoo0`0087oo00<007ooOol01Goo00<007ooOol0:Goo000n
Ool2000UOol00`00Oomoo`06Ool00`00Oomoo`1ROol2000SOol00`00Oomoo`05Ool00`00Oomoo`0Y
Ool003]oo`<002Moo`03001oogoo00Ioo`03001oogoo05moo`<002Eoo`03001oogoo00Ioo`03001o
ogoo02Qoo`00>Goo0P00:Woo00<007ooOol01goo00<007ooOol0G7oo0P00:7oo00<007ooOol01goo
00<007ooOol09goo000fOol3000/Ool00`00Oomoo`07Ool00`00Oomoo`1IOol3000ZOol00`00Oomo
o`07Ool00`00Oomoo`0WOol003=oo`<002moo`03001oogoo00Qoo`03001oogoo05Ioo`8002eoo`03
001oogoo00Qoo`03001oogoo02Ioo`00<Goo0P00<Woo00<007ooOol02Goo00<007ooOol0DWoo0`00
;goo00<007ooOol02Goo00<007ooOol09Goo000^Ool3000dOol00`00Oomoo`09Ool00`00Oomoo`1@
Ool2000bOol00`00Oomoo`09Ool00`00Oomoo`0UOol002aoo`8003Moo`03001oogoo00Yoo`03001o
ogoo04aoo`<003Aoo`03001oogoo00Yoo`03001oogoo02Aoo`00:Goo0`00>Goo00<007ooOol02goo
00<007ooOol0BGoo0P00=goo00<007ooOol02goo00<007ooOol08goo000WOol2000lOol00`00Oomo
o`0;Ool00`00Oomoo`16Ool3000iOol00`00Oomoo`0;Ool00`00Oomoo`0SOol002Aoo`<003ioo`03
001oogoo00aoo`03001oogoo04=oo`8003aoo`03001oogoo00aoo`03001oogoo029oo`008Woo0P00
@Goo00<007ooOol03Goo00<007ooOol0?goo0`00?Woo00<007ooOol03Goo00<007ooOol08Goo000O
Ool30013Ool00`00Oomoo`0=Ool00`00Oomoo`0lOol30011Ool00`00Oomoo`0=Ool00`00Oomoo`0Q
Ool001eoo`8004Ioo`03001oogoo00ioo`03001oogoo03Uoo`8004Eoo`03001oogoo00eoo`03001o
ogoo021oo`006Woo0`00B7oo00<007ooOol03goo00<007ooOol0=Goo0`00Agoo00<007ooOol03Woo
00<007ooOol07goo000HOol2001;Ool00`00Oomoo`0?Ool00`00Oomoo`0cOol2001:Ool00`00Oomo
o`0>Ool00`00Oomoo`0OOol001Eoo`<004ioo`03001oogoo00moo`03001oogoo02moo`<004aoo`03
001oogoo00moo`03001oogoo01ioo`004goo0P00DGoo00<007ooOol03goo00<007ooOol0;Goo0P00
Cgoo00<007ooOol047oo00<007ooOol07Goo000@Ool3001COol00`00Oomoo`0@Ool00`00Oomoo`0Y
Ool3001AOol01000Ool000003goo00<007ooOol07Goo000>Ool2001FOol00`00Oomoo`0AOol00`00
Oomoo`0VOol2001DOol2000015nMGkh000003Woo00<007ooOol077oo000<Ool2001HOol00`00Oomo
o`0AOol00`00Oomoo`0TOol2001COol40005Gid2000=Ool00`00Oomoo`0KOol000aoo`8005Qoo`03
001oogoo019oo`03001oogoo02=oo`80055oo`80000<GkiKW@00001O_U^MGkiOWEnnFieO_P0037oo
00<007ooOol06goo000<Ool00`00Ool0001GOol00`00Oomoo`0COol00`00Oomoo`0ROol00`00Ool0
001=Ool3000015nM000000000UnM00<005nMGid01EnM0P002goo00<007ooOol06Woo000<Ool01000
Oomoo`00EWoo00<007ooOol04goo00<007ooOol08Woo00@007ooOol004Yoo`80000CFid00000001K
WEnnGieO_U^M001OWEnnFieO_UnMGkiKWEnnGid00P002Woo00<007ooOol06Goo000;Ool00`00Oomo
o`02Ool00`00Oomoo`1COol00`00Oomoo`0DOol00`00Oomoo`0POol00`00Oomoo`02Ool00`00Oomo
o`15Ool50009Gid00`00GieOW@08Gid00`00Oomoo`07Ool00`00Oomoo`0IOol000]oo`03001oogoo
00=oo`03001oogoo055oo`8001Moo`03001oogoo01moo`03001oogoo00=oo`03001oogoo045oo`D0
000HFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFid005nMGkiKWEnnGieO_U^MGkiOWEnn0P0027oo00<0
07ooOol067oo000;Ool00`00Oomoo`04Ool00`00Oomoo`1=Ool30002Ool00`00Oomoo`0DOol00`00
Oomoo`0OOol00`00Oomoo`04Ool00`00Oomoo`0nOol4000AGid00`00GieOW@09Gid20007Ool00`00
Oomoo`0GOol000]oo`03001oogoo00Eoo`03001oogoo04Uoo`<000Eoo`03001oogoo01Eoo`03001o
ogoo01ioo`03001oogoo00Eoo`03001oogoo03Yoo`D0000QGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkh005nnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn008000Eoo`03001oogoo01Mo
o`002goo00<007ooOol01Woo0P00AWoo0`002Goo00<007ooOol057oo00<007ooOol07Woo00<007oo
Ool01Woo0P00>7oo10005enM00<005nMGid035nM00<007ooOol00goo00<007ooOol05Woo000;Ool0
0`00Oomoo`08Ool00`00Oomoo`10Ool3000=Ool00`00Oomoo`0DOol00`00Oomoo`0MOol00`00Oomo
o`08Ool00`00Oomoo`0bOol40000:UnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnn
FieO_UnMGkiKWEnnGieO_P00GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOW@8000Aoo`03001oogoo
01Eoo`002goo00<007ooOol02Goo00<007ooOol0?7oo0`004Goo00<007ooOol057oo00<007ooOol0
6goo00<007ooOol02Woo00<007ooOol0;goo0`007enM00<005nMGid03EnM0P000Woo00<007ooOol0
5Goo000;Ool00`00Oomoo`0:Ool00`00Oomoo`0hOol3000DOol00`00Oomoo`0DOol00`00Oomoo`0K
Ool00`00Oomoo`0;Ool00`00Oomoo`0[Ool30000=EnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM001KWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^M00000Woo00<007ooOol057oo000:Ool00`00Oomoo`0<Ool00`00Oomoo`0d
Ool3000COol400000goo001oo`0EOol00`00Oomoo`0JOol00`00Oomoo`0<Ool00`00Oomoo`0WOol3
000VGid00`00GieOW@0=Gid00`00Oomoo`02Ool00`00Oomoo`0COol000Yoo`03001oogoo00eoo`03
001oogoo031oo`<0015oo`D00004Aim3OTNO@gh3000FOol00`00Oomoo`0IOol00`00Oomoo`0=Ool0
0`00Oomoo`0SOol40000>5nMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnn
FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid005^MGkiOWEnnFieO_UnMGkiKWEnn
GieO_U^M0005Ool00`00Oomoo`0COol000Yoo`03001oogoo00ioo`03001oogoo02aoo`<0011oo`@0
00=7WP05@gi7WTNNAii3OP03Aih00d=n00000002000BOol00`00Oomoo`0IOol00`00Oomoo`0>Ool0
0`00Oomoo`0OOol4000]Gid00`00GieOW@09Gid00`00Oomoo`05Ool00`00Oomoo`0BOol000Yoo`03
001oogoo00moo`03001oogoo02Qoo`<000ioo`D0000D@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAil004NO@gi7W`<0011oo`03001oogoo01Qoo`03001oogoo00moo`03001oogoo01]oo`D0000k
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_P00GkiKWEnnGieO_U^MGkiOWEnnFid00009
Ool00`00Oomoo`0AOol000Yoo`03001oogoo011oo`03001oogoo02Aoo`<000aoo`D00097WP05@gi7
WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WP0000=7WP03@gi7WP00008000ioo`03
001oogoo01Moo`03001oogoo011oo`03001oogoo01Moo`H0039OW@03001OWEnM00IOW@03001oogoo
00Qoo`03001oogoo015oo`002Woo00<007ooOol04Goo00<007ooOol087oo0`002goo100002A3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7W`00Aim3OTNO
@gi7Wd=nAil4000:Ool00`00Oomoo`0FOol00`00Oomoo`0BOol00`00Oomoo`0DOol20000@Goo0000
05^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_P00GkiKWEnnGieO
_U^M000037oo00<007ooOol047oo000:Ool00`00Oomoo`0BOol00`00Oomoo`0LOol30009Ool50000
0dNN@gi7WP02Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih0
1D=nAii7WTNN00000dNN00E3OTNNAii7WT=n0097WP<000Qoo`03001oogoo01Eoo`03001oogoo01=o
o`03001oogoo011oo`H003UOW@03001OWEnM00=OW@03001oogoo00]oo`03001oogoo00moo`002Goo
00<007ooOol057oo00<007ooOol067oo0`001goo1@0003A7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n0013OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OP8000Ioo`03001oogoo01Eoo`03001oogoo01Aoo`03001oogoo00ao
o`<00015Ool00000GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^M001OWEnnFieO_P0000ioo`03001oogoo00moo`002Goo00<007ooOol05Goo00<0
07ooOol057oo0`001Woo100000=7WT=nAih00TNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03
Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP02Aih00`00@gi7WP02
Aih01D=nAii7WTNN@gh00TNN0P0027oo00<007ooOol057oo00<007ooOol05Goo00<007ooOol027oo
0`000Woo0P00?enM00@005nMGid0011oo`03001oogoo00ioo`002Goo00<007ooOol05Woo00<007oo
Ool04Goo0P0017oo1@0003Y3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OP00@gi7
Wd=nAim3OTNO@gi7W`8000]oo`03001oogoo01=oo`03001oogoo01Ioo`03001oogoo00Aoo`<000Ao
o`13001O_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFid00P004Woo00<007ooOol03Goo0009Ool00`00Oomoo`0GOol00`00Oomo
o`0=Ool300000goo0000000300001D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNN
Aii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=n
Aii7WTNN@gh00TNN00<004=nAih00TNN00=3OP0000003Goo00<007ooOol04goo00<007ooOol05goo
00<007ooOol00`001goo00<005nMGid0@5nM00<007ooOol04Goo00<007ooOol03Goo0009Ool00`00
Oomoo`0HOol2000:Ool70000@4=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7W`00Aim3OTNO0P003goo0P0057oo00<007ooOol05goo0`002Goo04H0
05^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_P00Ool001=oo`03001oogoo00aoo`002Goo00<007ooOol06Woo00<007ooOol0
17oo1P000dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3
OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7
WP06@gi7WTNNAii3OTNN0`003Woo0`0000=oo`00Ool04Woo00<007ooOol05Goo0`000Woo0P001goo
00<005nMGid0@5nM00D007ooOomoo`0001=oo`03001oogoo00]oo`002Goo00<007ooOol06goo00<0
07ooOol00`000Woo04@004NO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO0`002goo100017oo00<007ooOol04Goo00<007oo
Ool04Woo0`001goo00<007ooOol017oo04<005nnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkh00005Ool00`00Oomoo`0@Ool00`00
Oomoo`0;Ool000Qoo`03001oogoo01aoo`<000=oo`800003Aii3OTNN0097WP05@gi7WTNNAii3OP03
Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN
@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01d=nAii7WTNN@gi7WP0000=oo`03
001oogoo00Eoo`<000Qoo`03001oogoo015oo`03001oogoo00moo`<000]oo`03001oogoo009oo`03
001OWEnM03mOW@03001oogoo00Aoo`03001oogoo011oo`8000aoo`0027oo00<007ooOol06Goo0`00
0Woo04L007ooOol004=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n008000Aoo`03001oogoo009oo`<000aoo`03001oogoo
011oo`03001oogoo00aoo`<000moo`16001oogoo001O_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn0008Ool00`00Oomoo`0<Ool3
00000goo001oo`0;Ool000Qoo`03001oogoo01Ioo`<000Ioo`800097WP05@gi7WTNNAii3OP03Aih0
1D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh0
0dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN0P001goo1000
3goo00<007ooOol047oo00<007ooOol02Woo0P004goo00<007oo0000@5nM00<007ooOol027oo00<0
07ooOol01goo100017oo00<007ooOol02Woo0008Ool00`00Oomoo`0COol30009Ool0@P00@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OP8000Ioo`<00003Ool007oo011oo`03001oogoo011oo`03001oogoo00Moo`<001Ioo`12001O
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_P0037oo00<007ooOol00goo0`0027oo00<007ooOol02Woo0008Ool00`00Oomoo`0@Ool3
000:Ool20002Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih0
1D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh0
0dNN00I3OTNNAii7WT=nAih20005Ool30005Ool00`00Oomoo`0>Ool00`00Oomoo`0?Ool00`00Oomo
o`05Ool3000HOol00`00GieOW@0nGid00`00Oomoo`0;Ool00`00Oomoo`03000<Ool00`00Oomoo`09
Ool000Qoo`03001oogoo00eoo`<000aoo`110017Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OP020003Ool40008Ool00`00Oomoo`0>
Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool3000KOol0@P00GkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid000eoo`<000moo`03001o
ogoo00Uoo`0027oo00<007ooOol02Woo0`003Woo00D004NNAii7WT=n00=7WP05@gi7WTNNAii3OP03
Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN
@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih20002Ool3000=Ool00`00Oomoo`0=
Ool00`00Oomoo`0?Ool00`00Ool00002000MOol00`00GieOW@0nGid00`00Oomoo`09Ool30002Ool0
0`00Oomoo`0=Ool00`00Oomoo`09Ool000Qoo`03001oogoo00Moo`<0011oo`0n0017Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7W`<00004Ool0
0000000AOol00`00Oomoo`0<Ool00`00Oomoo`0?Ool2000OOol0@P00GkiKWEnnGieO_U^MGkiOWEnn
FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn
GieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid000Qoo`@000Io
o`03001oogoo00aoo`03001oogoo00Uoo`001goo00<007ooOol01Goo0`004Goo0P000dNN00E3OTNN
Aii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05
@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n0097WPP001Aoo`03001oogoo
00eoo`03001oogoo00moo`03001oogoo01eoo`03001OWEnM03eOW@03001oogoo00Aoo`<000Yoo`03
001oogoo00aoo`03001oogoo00Uoo`001goo00<007ooOol00Woo0`004goo03T004=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAil0100000Aoo`00000001Uoo`03
001oogoo00aoo`03001oogoo011oo`8001aoo`11001KWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn
GieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnn
FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid00004Ool3000>Ool00`00Oomoo`0;
Ool00`00Oomoo`09Ool000Moo`03001oo`00008001Eoo`030013OTNN0097WP05@gi7WTNNAii3OP03
Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN
@gh00dNN00E3OTNNAii7WT=n00=7WPD0009oo`<001eoo`03001oogoo00]oo`03001oogoo019oo`03
001oogoo01Uoo`03001OWEnM03aOW@03001oogoo00<0019oo`03001oogoo00Yoo`03001oogoo00Uo
o`001goo0P005goo038004=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n100017oo
0`008Goo00<007ooOol02Woo00<007ooOol04goo00<007ooOol05goo03h005nnGieO_U^MGkiOWEnn
FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn
GieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn1@005Woo00<007oo
Ool02Goo00<007ooOol02Goo0008Ool00`00Oomoo`0COol200001D=nAii7WTNN@gh00dNN00E3OTNN
Aii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05
@gi7WTNNAii3OP050004Ool4000TOol00`00Oomoo`0:Ool00`00Oomoo`0DOol00`00Oomoo`0EOol0
0`00GieOW@0jGid3000JOol00`00Oomoo`0:Ool00`00Oomoo`08Ool000Uoo`80019oo`0/0017Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7W`@000Ioo`<002Uoo`03001oogoo00Uoo`03001oogoo01Eoo`03
001oogoo01Aoo`0j001OWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGid3000NOol00`00Oomoo`09Ool00`00Oomoo`08Ool000]oo`03001oogoo00ioo`D00003
Aii3OTNN0097WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05
@gi7WTNNAii3OP02Aih40007Ool3000]Ool00`00Oomoo`08Ool00`00Oomoo`0FOol2000COol00`00
GieOW@0fGid2000ROol00`00Oomoo`08Ool00`00Oomoo`08Ool000aoo`03001oogoo019oo`X0000E
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n00D000Moo`@0035oo`03001o
ogoo00Qoo`03001oogoo01Moo`03001oogoo00moo`0g001OWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkh00`0097oo00<007ooOol027oo00<007ooOol027oo000=Ool0
0`00Oomoo`0KOol:0003Aih014=nAii7WTNN10002Goo0`00=Goo00<007ooOol027oo00<007ooOol0
67oo00<007ooOol03Woo00<005nMGid0<UnM0P00:7oo00<007ooOol01goo00<007ooOol027oo000>
Ool2000UOol7000:Ool3000iOol00`00Oomoo`07Ool00`00Oomoo`0IOol00`00Oomoo`0<Ool0<`00
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKW@03000[Ool00`00Oomoo`06Ool0
0`00Oomoo`08Ool0011oo`03001oogoo02Qoo`03001oogoo00Aoo`@003eoo`03001oogoo00Ioo`03
001oogoo01Yoo`03001oogoo00Yoo`03001OWEnM02mOW@8002moo`03001oogoo00Eoo`03001oogoo
00Qoo`004Goo00<007ooOol0:7oo00<007ooOol00`00@Woo00<007ooOol01Goo00<007ooOol06goo
0P002Woo02l005^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn00<0035oo`03001oogoo00Eo
o`03001oogoo00Qoo`004Woo00<007ooOol0:7oo0P00AGoo00<007ooOol01Goo00<007ooOol07Goo
00<007ooOol01Woo00<005nMGid0:UnM0`00=Goo00<007ooOol01Goo00<007ooOol01goo000COol0
0`00Oomoo`0WOol00`00Oomoo`15Ool00`00Oomoo`04Ool00`00Oomoo`0NOol00`00Oomoo`04Ool0
;000FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid2000iOol00`00Oomoo`04Ool00`00Oomoo`07Ool0
01Aoo`8002Moo`03001oogoo04Ioo`03001oogoo00=oo`03001oogoo01moo`03001oogoo00=oo`03
001OWEnM02IOW@<003aoo`03001oogoo00=oo`03001oogoo00Moo`005Woo00<007ooOol097oo00<0
07ooOol0Agoo00<007ooOol00goo00<007ooOol07goo0P000Woo0`0002EO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_P02
000oOol00`00Oomoo`03Ool00`00Oomoo`07Ool001Moo`03001oogoo02=oo`03001oogoo04Moo`03
001oogoo00=oo`03001oogoo025oo`03001oogoo009oo`H001aOW@<0049oo`03001oogoo009oo`03
001oogoo00Moo`0067oo00<007ooOol08Woo00<007ooOol0B7oo00<007ooOol00Woo00<007ooOol0
8Woo00<007ooOol01goo1P0001AO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
0P00AWoo00D007ooOomoo`0000Uoo`006Goo0P008Woo00<007ooOol0BGoo00D007ooOomoo`0002Eo
o`03001oogoo00aoo`D000aOW@<004Uoo`04001oogoo0009Ool001]oo`03001oogoo01moo`03001o
ogoo04Yoo`04001oogoo000VOol00`00Oomoo`0@Ool6000015nMGkiKWEnn0P000Woo00<007ooOol0
Agoo00@007ooOol000Uoo`0077oo00<007ooOol07Woo00<007ooOol0BWoo00@007ooOol002Moo`80
01Ioo`@000Aoo`03001oogoo04Qoo`04001oogoo0008Ool001eoo`03001oogoo01eoo`03001oogoo
04]oo`03001oo`0002Uoo`03001oogoo01]oo`03001oogoo04Uoo`03001oo`0000Qoo`007Woo0P00
7Goo00<007ooOol0C7oo00<007oo0000:Goo00<007ooOol06Woo00<007ooOol0BWoo0P0027oo000P
Ool00`00Oomoo`0JOol00`00Oomoo`1=Ool2000ZOol00`00Oomoo`0IOol00`00Oomoo`1:Ool20008
Ool0025oo`03001oogoo01Uoo`03001oogoo04eoo`8002]oo`8001Uoo`03001oogoo04Yoo`8000Qo
o`008Woo00<007ooOol067oo00<007ooOol0CGoo0P00;Goo00<007ooOol05Woo00<007ooOol0AWoo
10002Woo000SOol00`00Oomoo`0GOol00`00Oomoo`19Ool4000`Ool00`00Oomoo`0EOol00`00Oomo
o`12Ool4000>Ool002Aoo`8001Moo`03001oogoo04Eoo`@003Eoo`03001oogoo01Aoo`03001oogoo
03ioo`@0019oo`009Woo00<007ooOol057oo00<007ooOol0@Goo1000>Woo00<007ooOol04goo00<0
07ooOol0>goo0`005Woo000WOol00`00Oomoo`0COol00`00Oomoo`0mOol4000oOol2000COol00`00
Oomoo`0gOol4000IOol002Qoo`03001oogoo015oo`03001oogoo03Yoo`@004Eoo`03001oogoo011o
o`03001oogoo03=oo`@001eoo`00:Goo0P004Goo00<007ooOol0=Woo1000BWoo00<007ooOol03Woo
00<007ooOol0<7oo10008Goo000[Ool00`00Oomoo`0>Ool00`00Oomoo`0bOol4001?Ool00`00Oomo
o`0=Ool00`00Oomoo`0]Ool3000UOol002aoo`03001oogoo00eoo`03001oogoo02ioo`@005Aoo`03
001oogoo00aoo`03001oogoo02Uoo`@002Qoo`00;Goo00<007ooOol037oo00<007ooOol0:Woo1000
FGoo0P0037oo00<007ooOol09Goo1000;7oo000^Ool2000<Ool00`00Oomoo`0WOol3001OOol00`00
Oomoo`09Ool00`00Oomoo`0QOol4000`Ool0031oo`03001oogoo00Uoo`03001oogoo02=oo`@006=o
o`03001oogoo00Qoo`03001oogoo01eoo`@003Aoo`00<Goo00<007ooOol027oo00<007ooOol07goo
1000J7oo00<007ooOol01goo00<007ooOol06Woo0`00>7oo000bOol00`00Oomoo`07Ool00`00Oomo
o`0KOol4001]Ool20007Ool00`00Oomoo`0FOol4000kOol003=oo`03001oogoo00Ioo`03001oogoo
01Moo`@007=oo`03001oogoo00Aoo`03001oogoo019oo`@003moo`00=7oo0P001Woo00<007ooOol0
4goo1000N7oo00<007ooOol00goo00<007ooOol03Woo1000@goo000fOol00`00Oomoo`03Ool00`00
Oomoo`0?Ool4001mOol00`00Oomoo`02Ool00`00Oomoo`0;Ool30017Ool003Moo`03001oogoo009o
o`03001oogoo00]oo`@0089oo`05001oogooOol00009Ool4001:Ool003Qoo`05001oogooOol00009
Ool40027Ool200000goo001oo`04Ool4001>Ool003Uoo`800003Ool007oo00Aoo`@008eoo`800003
Ool000000080059oo`00>goo0P0000=oo`0000000P00TWoo0P00EWoo000lOol2003^Ool00?moobeo
o`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003o
Ool]Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00\
\>"],
  ImageRangeCache->{{{0, 299}, {142, 0}} -> {-0.0500105, -0.0964672, \
0.00702349, 0.00702349}, {{7.0625, 142.688}, {128.25, 13.6875}} -> \
{-0.0496935, -0.0474207, 0.00703557, 0.00703557}, {{156.25, 291.875}, \
{128.25, 13.6875}} -> {-1.09332, -0.0455261, 0.00699724, 0.00699724}}]
}, Open  ]],

Cell[TextData[
"The graphic shows that the two rotations applied to the same object in a \
different order results in two different states of the hexagon. Thus, by a \
simple example, we graphically verified that two rotations in a \
three-dimensional space are non-commutative. The reader may check this result \
by different rotations about different axes using different angles of \
rotation.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"], "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],

Cell["\<\
Another important term in group theory governing the relations \
between two groups is the notion of isomorphism.\
\>", "Text",
  CellTags->"isomorphism"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.2 Isomorphism", "Subsection",
  Evaluatable->False,
  CellTags->"Isomorphism"],

Cell["\<\
The given definition of a group is very abstract, yet general. With \
respect to this generality, it sometimes happens that two groups whose \
elements are defined in very different ways may nevertheless be related so \
closely that they may be regarded as the same group. This fact is expressed \
in the following definition.\
\>", "Text",
  Evaluatable->False],

Cell["Definition: Isomorphic groups", "Definition",
  CellTags->"Definition: Isomorphic groups"],

Cell[TextData[{
  "We say that two groups \[GothicCapitalG] and \[GothicCapitalH] are \
isomorphic if a one-to-one correspondence ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\  \[LeftRightArrow] \ H\_i\)]],
  " may be set up between the elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " of the group \[GothicCapitalG] and the elements ",
  Cell[BoxData[
      \(TraditionalForm\`H\_i\)]],
  " of \[GothicCapitalH], in such a way that if ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_k\  = \ G\_j\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`H\_i\ \[CirclePlus]\ H\_k\  = \ H\_j\)]],
  ".\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "Text"],

Cell["\<\
Closely related to the term isomorphism is the subject of \
homomorphism. The word homomorphism is used for such a relationship if the \
one-to-one correspondence is absent. Due to the definition of isomorphism, \
two isomorphic groups have the same group multiplication table with possible \
re-ordering of the group elements. Thus, the knowledge of the isomorphism of \
two groups helps to avoid repetitions and to draw useful analogies between \
the groups.\
\>", "Text",
  Evaluatable->False,
  CellTags->{"homomorphism", "isomorphic group"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.1.",
  CounterBox["Subsection"],
  " Lie Groups"
}], "Subsection",
  CellTags->"Lie Groups"],

Cell[TextData[{
  "Lie groups are special groups which have an additional property apart from \
the group properties. In addition to the basic group properties, a Lie group \
carries the structure of a manifold, where a manifold is a topological space \
which resembles Euclidean space locally. A differentiable manifold is a \
manifold for which this resemblance is sharp enough to allow partial \
differentiation and, consequently, all the features of differential calculus \
on the manifold. In studying Lie groups, we may, therefore, combine calculus, \
algebra, and topology. The present section aims at showing the sense in which \
the global study of a Lie group may be reduced to its local study. In the \
next section, we shall go even further, showing that the study of the local \
structure can be reduced to the study of the infinitesimal structure. Lie \
groups are extremely useful in the theory of transformation and in the \
examination of differential equations. The notion of a Lie group was \
introduced by ",
  ButtonBox["Weyl [1928]",
    ButtonData:>{"Literat.nb", "Weyl-28"},
    ButtonStyle->"Hyperlink"],
  " at the beginning of this century. Weyl used the following definition to \
distinguish Lie groups from classical groups."
}], "Text",
  CellTags->{
  "manifold", "calculus", "partial differentiation", "algebra", "topology", 
    "Lie group"}],

Cell["Definition: Lie group", "Definition",
  CellTags->"Definition: Lie group"],

Cell[TextData[{
  "A Lie group is a group which, in addition to the group properties, carries \
the structure of a differentiable manifold. More precisely, we require that a \
Lie group \[GothicCapitalG] be ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\[Infinity]\)]],
  " manifold endowed with a group structure in which multiplication and the  \
inversion are ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\[Infinity]\)]],
  " operations.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "Text",
  CellTags->"manifold"],

Cell[TextData[{
  "The essential feature of a Lie group is that it satisfies the properties \
(i)\[Dash](iv) and carries the structure of a smooth manifold. This means \
that the group elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " can be continuously varied. Thus, a Lie group is a group \
\[GothicCapitalG] which also carries the structure of a manifold in such a \
way that both the group operation \[GothicCapitalG] \[CirclePlus] \
\[GothicCapitalG] \[Rule] \[GothicCapitalG] and the inversion are smooth maps \
between manifolds. In the following, we will demonstrate these descriptions \
by a few examples."
}], "Text",
  Evaluatable->False],

Cell["Example 1", "Example"],

Cell[TextData[{
  "The first simple example of a Lie group is the real line ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " with ordinary addition as the group multiplication. Let us denote this  \
group by \[DoubleStruckCapitalA]. If we add two real numbers, we get a real \
number as a result. We all know that we can add three real numbers in any \
order to get the same result. The identity element of this group in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " is zero and the inverse are all the negative real numbers. Thus, we can \
map ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalR]\^1\[Times]\ \[DoubleStruckCapitalR]\^1 
        \[Rule] \ \[DoubleStruckCapitalR]\^1\)]],
  ", and the inversion as a smooth map also exists. These properties of \
addition for the real numbers are actually implemented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and are accessible by the function ",
  StyleBox["N[]", "MmaText"],
  " converting rational numbers to real numbers. The + sign represents the \
multiplication of the group \[DoubleStruckCapitalA]. The manifold on which \
all these operations are possible are the set of real numbers ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  ". \[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"addition", "inverse", "N[]", "rational numbers"}],

Cell["Example 2", "Example"],

Cell[TextData[{
  "A more sophisticated example for a Lie group is given by continuous matrix \
groups, or, more generally, continuous groups of linear transformations of a \
vector space, called linear Lie groups. The set of all non-singular ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Times]\ n\)]],
  " matrices form the group known as general linear group ",
  StyleBox["GL(n,\[DoubleStruckCapitalR])",
    FontSlant->"Italic"],
  ". A subset of all ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Times]\ n\)]],
  " matrices with determinant 1 form a group called the unimodular group \
which is denoted by ",
  StyleBox["SL(n,\[DoubleStruckCapitalR])",
    FontSlant->"Italic"],
  ". The orthogonal group ",
  StyleBox["O(n)",
    FontSlant->"Italic"],
  " is the group of ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Times]\ n\)]],
  " matrices that satisfy ",
  Cell[BoxData[
      \(TraditionalForm\`M\ \[CirclePlus]\ M\^T\  = \ 1\)]],
  ". A special orthogonal group ",
  StyleBox["SO",
    FontSlant->"Italic"],
  "(3) is connected with rotations."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "special orthogonal group", "SO(3)", "GL(n", "\\[DoubleStruckCapitalR])", 
    "SL(n", "continuous matrix group", "unimodular group", "linear group", 
    "vector space", "\[DoubleStruckCapitalR])"}],

Cell["\<\
Studying the properties of continuous matrix groups, we start with \
the two-dimensional matrices\
\>", "Text",
  Evaluatable->False,
  CellTags->"matrix group"],

Cell[BoxData[
    FormBox[
      RowBox[{\(M\_a\), " ", "=", " ", 
        RowBox[{
          RowBox[{"(", GridBox[{
                {"1", "a"},
                {"0", "1"}
                }], ")"}], "."}]}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "This representation of a linear group S",
  StyleBox["L(",
    FontSlant->"Italic"],
  StyleBox["2,",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\[DoubleStruckCapitalR])",
    FontSlant->"Italic"],
  " immediately shows  the property"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm\`\(M\_a\ \[CirclePlus]\ M\_b\  = \ M\_\(a + b\), \)\)], 
  "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "from which we can conclude that the group of two-dimensional matrices is \
isomorphic to the group \[DoubleStruckCapitalA] of our first example. To \
support this conclusion, let us examine the properties of the two-dimensional \
matrix group by using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". First, let us define a function allowing us the representation of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  ". Afterward, we use this function to check the group axioms (i)\[Dash](iv) \
for this representation of a group. Since ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " depends on one continuous parameter ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", we define the matrix ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " by"
}], "Text",
  Evaluatable->False,
  CellTags->{"representation", "group axioms"}],

Cell[BoxData[
    \(M[a_] := {{1, a}, {0, 1}}\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The matrix function ",
  StyleBox["M[]", "MmaText"],
  " uses two nested lists to represent the two-dimensional matrices needed. \
We check the axioms by using the matrix product for the group multiplication. \
This type of product is denoted by a lower dot in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In the sequel, we use the function ",
  StyleBox["MatrixForm[]", "MmaText"],
  " to represent the resulting matrices in a two-dimensional table. \
Multiplying two different matrices ",
  StyleBox["M[a]", "MmaText"],
  " and ",
  StyleBox["M[b]", "MmaText"],
  ", we find"
}], "Text",
  Evaluatable->False,
  CellTags->{"group multiplication", "MatrixForm[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[M[a] . M[b]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(a + b\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
We immediately verified that axiom (i) is satisfied. The property \
of associativity is checked by interchanging the multiplication order\
\>", 
  "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[\((M[a] . M[b])\) . M[c]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(a + b + c\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[M[a] . \((M[c] . M[b])\)]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(a + b + c\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The inverse element of the group corresponds to the inversion of the \
matrix. Matrices are inverted in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with the help of the function ",
  StyleBox["Inverse[]", "MmaText"],
  ". ",
  StyleBox["Inverse[]", "MmaText"],
  " returns the inverse of a square matrix. The application of this function \
shows us"
}], "Text",
  Evaluatable->False,
  CellTags->{"Inverse[]", "inverse element"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(mi = Inverse[M[a]]; mi // MatrixForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-a\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is the inverse of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " stored in the variable ",
  StyleBox["mi",
    FontSlant->"Italic"],
  ". Next, we can check axiom (iv) by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ident = mi . M[a]; \ ident\  // MatrixForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "0"},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, we find the identity element of the two-dimensional matrices ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " as the identity matrix in two dimensions. It is obvious from the \
calculations that the set ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[GothicCapitalM]\  = {\ 
          M\_a | \ \ a \[Element] \ \[DoubleStruckCapitalR]}\)]],
  " is a representation of addition in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  ", thus the two Lie groups \[DoubleStruckCapitalA] and \[GothicCapitalM] \
are isomorphic.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"identity element", "isomorphic"}],

Cell[TextData[{
  "Generally speaking, a representation of a group \[GothicCapitalG] on a \
vector space ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is a homomorphism from the group \[GothicCapitalG] into an invertible  \
linear transformation of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ". These ",
  "representations",
  " must not be matrix representations but can be defined on the infinite \
dimensional vector space ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^\[Infinity]\)(\[DoubleStruckCapitalR])\)]],
  ", which represents the space of infinitely differentiable functions in one \
dimension."
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{
  "vector space", "homomorphism", "invertible linear transformation", 
    "representation", "infinite dimensional vector space"}],

Cell[TextData[StyleBox["Example 3",
  FontVariations->{"CompatibilityType"->0}]], "Example"],

Cell[TextData[{
  "The addition in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " can also be represented by a translation in the space of  ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^\[Infinity]\)(\[DoubleStruckCapitalR])\)]],
  " functions. Let us assume that we can define an operator ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  ", which acts on a function defined on ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " in the following way:"
}], "Text",
  Evaluatable->False,
  CellTags->"translation"],

Cell[BoxData[
    \(TraditionalForm\`\(\(T\_a\) \(f(x)\)\  = \ \(f(x + a) . \)\ \)\)], 
  "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "The shift ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " translates the argument of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " by a step ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " to the left. The definition of a shift operator ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks like"
}], "Text",
  Evaluatable->False,
  CellTags->"shift operator"],

Cell[BoxData[
    \(T\_a_[f_] := f /. x \[Rule] x + a\)], "Input"],

Cell[TextData[{
  "This simple definition assumes that the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " depends exclusively on ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The sequence of instructions on the right-hand side of the definition \
sign ( :=) means that the argument ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ", if any, is replaced by ",
  Cell[BoxData[
      \(TraditionalForm\`x + a\)]],
  ". The properties of the group are now checked by applying the operator ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " on functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  "). The identity element of the Lie group is given by ",
  Cell[BoxData[
      \(TraditionalForm\`a = 0\)]],
  ","
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_0[f[x]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The inverse element is represented by a negative shift ",
  Cell[BoxData[
      \(TraditionalForm\`\(-a\)\)]],
  ". We check the inverse behavior of the transformation by applying the \
inverse element to a regular element of the group. The expected result is the \
identity"
}], "Text",
  Evaluatable->False,
  CellTags->"inverse element"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_\(-a\)[T\_a[f[x]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The property of associativity is expressed by the iterated application of \
the translation operator",
  StyleBox[" ", "MmaText"],
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)], "MmaText"],
  StyleBox["[]", "MmaText"],
  " for different translations ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c",
    FontSlant->"Italic"],
  " and the interchange of two parameters"
}], "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_c[T\_b[T\_a[f[x]]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[a + b + c + x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_b[T\_c[T\_a[f[x]]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[a + b + c + x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, we observe that the Lie group of translations in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " is isomorphic to the group of addition \[DoubleStruckCapitalA]. In \
conclusion, we can say that the same Lie group can be represented by \
different tools like addition of real numbers, matrix multiplication, and \
translations of functions. These different tools for representing the \
behavior are known as representations of the group. The idea of a \
representation of a Lie group helps to clarify the subtle distinction between \
an abstract group and a  variety of its realizations. Thus, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalA]", " ", "=", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^1\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", the set of matrices ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  ", and the translations ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " are all distinct but isomorphic representations of the same abstract \
group.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "group representation", "isomorphic", "representation of a Lie group"}],

Cell[TextData[
"Apart from an isomorphism which is invertible, the term homomorphism is an \
important quantity in group theory. A Lie group homomorphism is a smooth map \
\[CapitalPhi] : \[GothicCapitalG] \[Rule] \[GothicCapitalH] between two Lie \
groups respecting the group operations. If \[CapitalPhi] has a smooth \
inverse, it determines an isomorphism between \[GothicCapitalG] and \
\[GothicCapitalH], otherwise it is a homomorphism. "], "Text",
  Evaluatable->False,
  CellTags->{"isomorphism", "homomorphism"}],

Cell["\<\
Understanding the action of the group clearly, we discuss the \
example of a translation a second time. This kind of symmetry is a symmetry \
frequently recognized in the analysis of differential equations. To \
illustrate the action of such a group, we will realize it by a graphical \
representation.\
\>", "Text",
  Evaluatable->False,
  CellTags->"translation"],

Cell["Example 4", "Example"],

Cell[TextData[{
  "For example, let us study the group properties of a parabola ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x)\), "=", 
          FormBox[\(x\^2\),
            "TraditionalForm"]}], TraditionalForm]]],
  " under the action of our function ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  ". Applying ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  ", we mathematically get the expression ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(x\^2\), "+", 
          RowBox[{"2", 
            StyleBox["ax",
              FontSlant->"Italic"]}], " ", "+", " ", \(a\^2\)}], 
        TraditionalForm]]],
  ". The expanded result represents the translation ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " in a more or less mixed form containing products of ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". However, the action of the group is much simpler to grasp if we present \
it graphically. The shift ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " along the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis is clearly shown in the figure below."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[\n\tEvaluate[{x\^2, T\_\(-2\)[x\^2]}], {x, \(-2\), 4}, \n\t
      PlotStyle 
        \[Rule] {RGBColor[1.000, 0.000, 0.000], \n\t\t\t
          RGBColor[0.000, 0.000, 1.000]}, 
      AxesLabel \[Rule] {"\<x\>", "\<f\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.15873 0.0147151 0.0595487 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.18254 .00222 -6 -9 ]
[.18254 .00222 6 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.65873 .00222 -3 -9 ]
[.65873 .00222 3 0 ]
[.81746 .00222 -3 -9 ]
[.81746 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.4375 ]
[1.025 .01472 10 6.4375 ]
[.32877 .13381 -6 -4.5 ]
[.32877 .13381 0 4.5 ]
[.32877 .25291 -6 -4.5 ]
[.32877 .25291 0 4.5 ]
[.32877 .37201 -6 -4.5 ]
[.32877 .37201 0 4.5 ]
[.32877 .4911 -6 -4.5 ]
[.32877 .4911 0 4.5 ]
[.32877 .6102 -12 -4.5 ]
[.32877 .6102 0 4.5 ]
[.34127 .64303 -5 0 ]
[.34127 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .01472 m
.02381 .02097 L
s
[(-2)] .02381 .00222 0 1 Mshowa
.18254 .01472 m
.18254 .02097 L
s
[(-1)] .18254 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(2)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(3)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(4)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.34127 .13381 m
.34752 .13381 L
s
[(2)] .32877 .13381 1 0 Mshowa
.34127 .25291 m
.34752 .25291 L
s
[(4)] .32877 .25291 1 0 Mshowa
.34127 .37201 m
.34752 .37201 L
s
[(6)] .32877 .37201 1 0 Mshowa
.34127 .4911 m
.34752 .4911 L
s
[(8)] .32877 .4911 1 0 Mshowa
.34127 .6102 m
.34752 .6102 L
s
[(10)] .32877 .6102 1 0 Mshowa
.125 Mabswid
.34127 .04449 m
.34502 .04449 L
s
.34127 .07426 m
.34502 .07426 L
s
.34127 .10404 m
.34502 .10404 L
s
.34127 .16359 m
.34502 .16359 L
s
.34127 .19336 m
.34502 .19336 L
s
.34127 .22314 m
.34502 .22314 L
s
.34127 .28268 m
.34502 .28268 L
s
.34127 .31246 m
.34502 .31246 L
s
.34127 .34223 m
.34502 .34223 L
s
.34127 .40178 m
.34502 .40178 L
s
.34127 .43156 m
.34502 .43156 L
s
.34127 .46133 m
.34502 .46133 L
s
.34127 .52088 m
.34502 .52088 L
s
.34127 .55065 m
.34502 .55065 L
s
.34127 .58043 m
.34502 .58043 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.34127 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .25291 m
.06244 .19846 L
.10458 .14712 L
.14415 .10655 L
.18221 .07451 L
.22272 .04793 L
.24141 .03828 L
.26171 .02968 L
.27279 .0258 L
.28302 .02274 L
.29341 .02013 L
.30316 .01815 L
.31218 .01672 L
.31682 .01613 L
.32188 .0156 L
.32474 .01536 L
.3274 .01517 L
.33016 .01501 L
.33265 .01489 L
.33383 .01485 L
.33511 .0148 L
.33621 .01478 L
.33742 .01475 L
.33871 .01473 L
.33941 .01472 L
.34007 .01472 L
.34125 .01472 L
.34251 .01472 L
.34372 .01473 L
.34442 .01474 L
.34507 .01475 L
.34638 .01478 L
.34779 .01482 L
.35034 .01491 L
.35268 .01502 L
.35807 .01538 L
.36375 .01591 L
.37336 .01715 L
.38387 .019 L
.40348 .02386 L
.42443 .03106 L
.44577 .04053 L
.46593 .05144 L
.50439 .0776 L
.54531 .11311 L
.58471 .15479 L
.6226 .20178 L
.66294 .25927 L
.70177 .32187 L
.74304 .39623 L
Mistroke
.7828 .47548 L
.82105 .55876 L
Mfstroke
.82105 .55876 m
.84612 .61803 L
s
0 0 1 r
.15376 .61803 m
.18221 .5514 L
.22272 .46403 L
.26171 .38726 L
.30316 .31354 L
.34309 .25019 L
.3815 .19637 L
.42237 .14676 L
.46172 .10645 L
.49955 .0746 L
.53984 .04812 L
.55838 .03852 L
.57861 .02989 L
.58957 .02602 L
.59975 .02294 L
.6094 .02047 L
.61984 .01829 L
.62534 .01735 L
.6304 .01661 L
.63515 .01603 L
.64036 .01551 L
.64504 .01516 L
.64941 .01492 L
.65182 .01483 L
.65402 .01477 L
.65524 .01474 L
.65592 .01473 L
.65656 .01473 L
.65773 .01472 L
.65897 .01472 L
.6601 .01472 L
.66135 .01473 L
.66265 .01475 L
.66385 .01478 L
.66602 .01484 L
.66834 .01493 L
.67106 .01507 L
.67363 .01524 L
.67844 .01563 L
.68721 .01663 L
.69672 .01813 L
.70618 .02004 L
.71659 .02263 L
.73763 .02943 L
.75708 .03758 L
.77797 .04832 L
.81925 .07561 L
.85901 .10952 L
.89726 .14919 L
.93795 .19899 L
Mistroke
.97619 .25291 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 143},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000Sa000`40O003h00Oogoo;Goo000fOol4
000JOol5000cOol5000IOol4000KOol2000MOol30011Ool003Ioo`03001oogoo01eoo`03001oogoo
03Eoo`03001oogoo01Uoo`03001oogoo01]oo`04001oogoo000MOol00`00Oomoo`10Ool003Moo`03
001oogoo01aoo`03001oogoo03Eoo`03001oogoo01Yoo`03001oogoo01aoo`03001oogoo01Uoo`D0
045oo`00<7oo100017oo00<007ooOol04goo100017oo00<007ooOol0=Goo00<007ooOol06goo00<0
07ooOol077oo00<007ooOol067oo00@007ooOol0049oo`00=Woo00@007ooOol001aoo`03001oogoo
03Eoo`03001oogoo01Uoo`04001oogoo000JOol01000Oomoo`006goo00<007oo0000@Woo000gOol2
000LOol2000fOol2000LOol2000LOol2000MOol20012Ool00?moobeoo`00ogoo;Goo001aOol00`00
Oomoo`2hOol0075oo`03001oogoo07moo`800003Ool0000003Aoo`00LGoo00<007ooOol0P7oo00<0
07oo0000=Goo000aOolh000?O00^000>01li0008Ool00`00Oomoo`0dOol003Eoo`03001oogoo00=o
o`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=o
o`03001oogoo00=oo`03001oogoo00=oo`Al009oo`03001oogoo00=oo`03001oogoo00=oo`04001l
07`0O002Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool601l00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Ool07`0301l0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`08Ool200000goo0000000d
Ool006=oo`9l00aoo`03001oogoo00Moo`=l021oo`807aQoo`807g9oo`00H7oo0g`03Woo00<007oo
Ool02Woo0g`06Woo0`0O77oo0`0OKgoo001MOol3O00AOol00`00Oomoo`0=Ool2O00FOol201lROol3
01m/Ool005]oo`9l01Aoo`03001oogoo00moo`9l019oo`807bMoo`807fYoo`00FWoo00=l07ooOol0
57oo00<007ooOol04Goo0W`03goo00<07gooOol0:Goo0P0OJ7oo001HOol2O00GOol00`00Oomoo`0C
Ool2O00;Ool201l^Ool201mVOol005Moo`03O01oogoo01Moo`03001oogoo01Eoo`9l00Moo`807c9o
o`0301moogoo06=oo`00EWoo00=l07ooOol067oo00<007ooOol05goo00=l07ooOol00goo00<07goo
Ool0<goo00<07gooOol0HWoo001DOol2O00KOol00`00Oomoo`0HOol00g`0Oomoo`0201lgOol201mR
Ool005=oo`03O01oogoo01]oo`03001oogoo01Uoo`03O0007goo03Yoo`0301moogoo05moo`00DWoo
00=l07ooOol077oo00<007ooOol06Goo00<07gooO000>goo00<07gooOol0GWoo001AOol00g`0Oomo
o`0MOol00`00Oomoo`0HOol01@0OOomoogooO000>goo00<07gooOol0GGoo001?Ool2O00POol00`00
Oomoo`0FOol201l5Ool2O00jOol00`0OOomoo`1LOol004ioo`03O01oogoo021oo`03001oogoo01Eo
o`0301moogoo00Moo`03O01oogoo03Qoo`807eaoo`00CGoo00=l07ooOol08Goo00<007ooOol057oo
00<07gooOol02Goo00=l07ooOol0>Goo00<07gooOol0FGoo001<Ool00g`0Oomoo`0ROol00`00Oomo
o`0COol00`0OOomoo`0;Ool2O00jOol00`0OOomoo`1HOol004]oo`03O01oogoo02=oo`03001oogoo
019oo`0301moogoo00ioo`03O01oogoo03Qoo`0301moogoo05Moo`00BWoo00=l07ooOol097oo00<0
07ooOol04Goo00<07gooOol047oo00=l07ooOol0>7oo00<07gooOol0EWoo0019Ool00g`0Oomoo`0M
Ool40004Ool00`00Oomoo`0@Ool00`0OOomoo`0BOol00g`0Oomoo`0hOol00`0OOomoo`1EOol004Qo
o`03O01oogoo01ioo`03001oogoo00Eoo`03001oogoo011oo`0301moogoo01=oo`03O01oogoo03Qo
o`0301moogoo05Aoo`00Agoo00=l07ooOol087oo00<007ooOol017oo0P0047oo00<07gooOol05Goo
00=l07ooOol0>7oo00<07gooOol0Dgoo0016Ool00g`0Oomoo`0ROol00`00Oomoo`03Ool00`00Oomo
o`0>Ool00`0OOomoo`0FOol00g`0Oomoo`0iOol00`0OOomoo`1BOol004Eoo`03O01oogoo025oo`04
001oogoo0004Ool00`00Oomoo`0=Ool00`0OOomoo`0HOol00g`0Oomoo`0iOol00`0OOomoo`1AOol0
04Aoo`03O01oogoo02=oo`8000Eoo`03001oogoo00aoo`0301moogoo01Yoo`03O01oogoo03Uoo`03
01moogoo051oo`00@goo00=l07ooOol0:goo00<007ooOol02goo00<07gooOol077oo00=l07ooOol0
>Goo00<07gooOol0Cgoo0012Ool00g`0Oomoo`0/Ool00`00Oomoo`0:Ool00`0OOomoo`0NOol00g`0
Oomoo`0iOol00`0OOomoo`1>Ool0045oo`03O01oogoo02eoo`03001oogoo00Uoo`0301moogoo021o
o`03O01oogoo03Uoo`0301moogoo04eoo`00@7oo00=l07ooOol0;Woo00<007ooOol027oo00<07goo
Ool08Goo00=l07ooOol0>Woo00<07gooOol0C7oo0010Ool00g`0Oomoo`0^Ool00`00Oomoo`08Ool0
0`0OOomoo`0ROol00g`0Oomoo`0iOol00`0OOomoo`1<Ool003moo`03O01oogoo02moo`03001oogoo
00Moo`0301moogoo02Aoo`03O01oogoo03Uoo`0301moogoo04]oo`00?Woo00=l07ooOol0<7oo00<0
07ooOol01Woo00<07gooOol09Woo00=l07ooOol0>Goo00<07gooOol0BWoo000mOol00g`0Oomoo`0a
Ool00`00Oomoo`05Ool00`0OOomoo`0WOol00g`0Oomoo`0jOol00`0OOomoo`19Ool003aoo`03O01o
ogoo039oo`03001oogoo00Aoo`0301moogoo02Uoo`03O01oogoo03Yoo`0301moogoo04Qoo`00>goo
00=l07ooOol0<goo00<007ooOol00goo00<07gooOol0:goo00=l07ooOol0>Woo00<07gooOol0Agoo
000kOol00g`0Oomoo`0cOol00`00Oomoo`03Ool00`0OOomoo`0/Ool00g`0Oomoo`0iOol00`0OOomo
o`17Ool003Yoo`03O01oogoo03Aoo`03001oogoo009oo`0301moogoo02eoo`03O01oogoo03Yoo`03
01moogoo04Ioo`00>Goo00=l07ooOol0=Goo00D007ooOomoo`0O035oo`03O01oogoo03Yoo`0301mo
ogoo04Eoo`00>Goo00=l07ooOol0=Goo00D007ooOomoo`0O039oo`03O01oogoo03Yoo`0301moogoo
04Aoo`00>7oo00=l07ooOol0=Woo00@007ooOol07cAoo`03O01oogoo03Uoo`0301moogoo04Aoo`00
=goo00=l07ooOol0=goo00<007oo01l0=Goo00=l07ooOol0>Woo00<07gooOol0@goo000fOol00g`0
Oomoo`0bOol30003Ool00`0001moo`0fOol00g`0Oomoo`0jOol00`0OOomoo`12Ool003Ioo`03O01o
ogoo03=oo`03001oogoo009oo`0300007goo03Moo`03O01oogoo03Uoo`0301moogoo049oo`00=Goo
00=l07ooOol0<Goo1@000goo00<07`00Ool0>7oo00=l07ooOol0>Goo00<07gooOol0@Goo001YOol0
1000Oomoo`000goo00<07`00Ool0>Goo00=l07ooOol0OGoo001ZOol00`00Ool00003Ool00`0O001o
o`0jOol00g`0Oomoo`1lOol006]oo`80009oo`0301moo`0003aoo`03O01oogoo07]oo`00Kgoo00<0
7goo0000?7oo00=l07ooOol0Ngoo001^Ool0100OOomoo`00?Goo00=l07ooOol0NWoo001^Ool0100O
Oomoo`00?Woo00=l07ooOol0NGoo001]Ool01@0OOomoogoo0000?Woo00=l07ooOol0NGoo001/Ool0
0`0OOomoo`02Ool00`00Oomoo`0mOol00g`0Oomoo`1hOol006aoo`0301moogoo009oo`03001oogoo
03eoo`03O01oogoo07Qoo`00Jgoo00<07gooOol00goo00<007ooOol0?Woo00=l07ooOol0Mgoo001[
Ool00`0OOomoo`03Ool00`00Oomoo`0oOol00g`0Oomoo`1fOol006Yoo`0301moogoo00Aoo`03001o
ogoo03moo`03O01oogoo07Ioo`00JGoo00<07gooOol01Goo00<007ooOol0@7oo00=l07ooOol0MGoo
001YOol00`0OOomoo`05Ool00`00Oomoo`11Ool00g`0Oomoo`1dOol006Qoo`0301moogoo00Ioo`03
001oogoo045oo`03O01oogoo07Aoo`00J7oo00<07gooOol01Woo00<007ooOol0@Woo00=l07ooOol0
Lgoo001WOol00`0OOomoo`07Ool00`00Oomoo`12Ool00g`0Oomoo`1cOol006Moo`0301moogoo00Mo
o`03001oogoo04=oo`03O01oogoo079oo`00IWoo00<07gooOol027oo00<007ooOol0@goo00=l07oo
Ool0LWoo001UOol00`0OOomoo`09Ool00`00Oomoo`14Ool00g`0Oomoo`1aOol006Eoo`0401moogoo
Ool30005Ool00`00Oomoo`15Ool00g`0Oomoo`1`Ool006Aoo`0301moogoo009oo`04001oogoo0004
Ool00`00Oomoo`15Ool00g`0Oomoo`1`Ool006Aoo`0301moogoo009oo`04001oogoo0004Ool20017
Ool00g`0Oomoo`1_Ool006=oo`0301moogoo00=oo`<000Eoo`03001oogoo04Ioo`03O01oogoo06mo
o`00Hgoo00<07gooOol017oo00<007ooOol017oo00<007ooOol0Agoo00=l07ooOol0KWoo001ROol0
0`0OOomoo`05Ool30004Ool00`00Oomoo`17Ool00g`0Oomoo`1^Ool0065oo`0301moogoo00eoo`03
001oogoo04Qoo`03O01oogoo06eoo`00HGoo00<07gooOol03Goo00<007ooOol0B7oo00=l07ooOol0
KGoo001POol00`0OOomoo`0>Ool00`00Oomoo`19Ool00g`0Oomoo`1/Ool0061oo`0301moogoo00io
o`03001oogoo04Uoo`03O01oogoo06aoo`00Ggoo00<07gooOol03goo00<007ooOol0BWoo00=l07oo
Ool0Jgoo001OOol00`0OOomoo`0?Ool00`00Oomoo`1:Ool00g`0Oomoo`1[Ool005ioo`0301moogoo
011oo`03001oogoo04]oo`03O01oogoo06Yoo`00GGoo00<07gooOol04Goo00<007ooOol0Bgoo00=l
07ooOol0JWoo001MOol00`0OOomoo`0AOol00`00Oomoo`1<Ool00g`0Oomoo`1YOol005aoo`0301mo
ogoo019oo`03001oogoo04aoo`03O01oogoo06Uoo`00G7oo00<07gooOol04Woo00<007ooOol0CGoo
00=l07ooOol0J7oo001KOol00`0OOomoo`0COol00`00Oomoo`1=Ool00g`0Oomoo`1XOol005]oo`03
01moogoo01=oo`03001oogoo04ioo`03O01oogoo06Moo`00FWoo00<07gooOol057oo00<007ooOol0
CWoo00=l07ooOol0Igoo001JOol00`0OOomoo`0DOol00`00Oomoo`1?Ool00g`0Oomoo`1VOol005Uo
o`0301moogoo01Eoo`03001oogoo04moo`03O01oogoo06Ioo`00FGoo00<07gooOol03Woo0P001Goo
00<007ooOol0D7oo00=l07ooOol0IGoo001HOol00`0OOomoo`0>Ool01000Oomoo`0017oo00<007oo
Ool0D7oo00=l07ooOol0IGoo001HOol00`0OOomoo`0>Ool01000Oomoo`0017oo0P00DWoo00=l07oo
Ool0I7oo001GOol00`0OOomoo`0@Ool20005Ool00`00Oomoo`1AOol00g`0Oomoo`1TOol005Moo`03
01moogoo00moo`04001oogoo0004Ool00`00Oomoo`1BOol00g`0Oomoo`1SOol005Moo`0301moogoo
011oo`8000Eoo`03001oogoo059oo`03O01oogoo06=oo`00EWoo00<07gooOol067oo00<007ooOol0
Dgoo00=l07ooOol0HWoo001FOol00`0OOomoo`0HOol00`00Oomoo`1COol00g`0Oomoo`1ROol005Eo
o`0301moogoo01Uoo`03001oogoo05Aoo`03O01oogoo065oo`00EGoo00<07gooOol06Goo00<007oo
Ool0E7oo00=l07ooOol0HGoo001DOol00`0OOomoo`0JOol00`00Oomoo`1EOol00g`0Oomoo`1POol0
05Aoo`0301moogoo01Yoo`03001oogoo05Eoo`03O01oogoo061oo`00Dgoo00<07gooOol06goo00<0
07ooOol0EWoo00=l07ooOol0Ggoo001COol00`0OOomoo`0KOol00`00Oomoo`1FOol00g`0Oomoo`1O
Ool005=oo`0301moogoo01]oo`03001oogoo05Moo`03O01oogoo05ioo`00DWoo00<07gooOol077oo
00<007ooOol0Egoo00=l07ooOol0GWoo001BOol00`0OOomoo`0LOol00`00Oomoo`1GOol00g`0Oomo
o`1NOol0055oo`0301moogoo01eoo`03001oogoo05Qoo`03O01oogoo05eoo`00DGoo00<07gooOol0
7Goo00<007ooOol0F7oo00=l07ooOol0GGoo001AOol00`0OOomoo`0MOol00`00Oomoo`1HOol00g`0
Oomoo`1MOol0051oo`0301moogoo01ioo`03001oogoo05Uoo`03O01oogoo05aoo`00D7oo00<07goo
Ool07Woo00<007ooOol0FGoo00=l07ooOol0G7oo001@Ool00`0OOomoo`0@Ool50002Ool20005Ool0
0`00Oomoo`1JOol00g`0Oomoo`1KOol004moo`0301moogoo01=oo`05001oogooOol00002Ool00`00
Oomoo`02Ool00`00Oomoo`1JOol00g`0Oomoo`1KOol004moo`0301moogoo01=oo`05001oogooOol0
0002Ool00`00Oomoo`02Ool2001KOol00g`0Oomoo`1KOol004ioo`0301moogoo01Aoo`05001oogoo
Ool00002Ool00`00Oomoo`02Ool00`00Oomoo`1KOol00g`0Oomoo`1JOol004ioo`0301moogoo01Ao
o`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1KOol00g`0Oomoo`1JOol006Aoo`80
00Aoo`800<1oo`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00
ogoo;Goo001_Ool4002iOol0071oo`03001oogoo0;Uoo`00L7oo00<007ooOol0^Goo001_Ool4002i
Ool0071oo`03001oogoo0;Uoo`00LGoo0P00^Goo003oOol]Ool00?moobeoo`00ogoo;Goo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {142, 0}} -> {-3.80341, -1.01614, 0.0336079, \
0.0895835}}]
}, Open  ]],

Cell[TextData[{
  "The command ",
  StyleBox["Evaluate[] ", "MmaText"],
  "used in the function ",
  StyleBox["Plot[] ", "MmaText"],
  "forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to do the calculations first and then display the results. The shift of \
translation in the example is set to ",
  Cell[BoxData[
      \(TraditionalForm\`a = \(-2\)\)]],
  ". We clearly observe that the parabola is translated to the right by the \
length ",
  StyleBox["a",
    FontSlant->"Italic"],
  ". \[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  CellTags->"Plot[]"],

Cell["Example 5", "Example"],

Cell[TextData[{
  "Another example frequently encountered in symmetry analysis of \
differential equations is the scaling group. A scaling transformation reduces \
or enlarges an object depending on the amount of the scaling factor. A \
scaling of a geometrical object is carried out practically by multiplying the \
coordinates of the object by the scaling factor. A function allowing this \
operation can be defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  by"
}], "Text",
  Evaluatable->False,
  CellTags->{"coordinates", "scaling group"}],

Cell[BoxData[{
    \(\(Clear[Scaling]; \)\), 
    \(Scaling[object_Polygon, factor_] := \n\t\t
      \(points = object /. Polygon[X___] \[Rule] Polygon[factor\ X]\)\)}], 
  "Input"],

Cell["\<\
This definition assumes that the geometric object is given by a \
polygon. Applying this function to an object, for example, a pentagon, we can \
reduce or enlarge the figure depending on the second argument of the \
function. Choosing the factor greater than 1, we stretch the object; taking a \
factor smaller than 1, we shrink it. The pentagon is generated by\
\>", "Text",\

  Evaluatable->False,
  CellTags->{"polygon", "pentagon"}],

Cell[BoxData[
    \(\(pentagon = 
      Polygon[Table[{Cos[i], Sin[i]}, \n
          \t\t\t{i, 0, 2\ \[Pi], \(2\ \[Pi]\)\/5}]]; \)\)], "Input"],

Cell[TextData[{
  "Let us now examine how the shape of the pentagon changes when the scaling \
factor is changed. An animation of this change of scaling factors helps us to \
recognize the meaning of scaling. The following ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code contains a ",
  StyleBox["Do[]", "MmaText"],
  " loop which allows the decrease of the scaling factor. For the animation, \
we choose the scaling factor in the range from 1 to 0.1 in steps of 0.05. The \
action of the scaling is boosted by changing the color of the pentagon."
}], "Text",
  Evaluatable->False,
  CellTags->{"Do[]", "scaling factor"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[\n\t
      Show[Graphics[{Hue[i], Scaling[pentagon, i]}, \n\t\t\t
          AspectRatio \[Rule] Automatic], \n\t\t
        PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {i, 1,  .1, \(- .05\)}]
      \)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
1 .5 m
.65451 .97553 L
.09549 .79389 L
.09549 .20611 L
.65451 .02447 L
1 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Center,
  TextJustification->0,
  ImageSize->{144.313, 144.313},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002@0000T1000`40O003h00OT7oo002@Ool0091o
o`00T7oo002@Ool005]oo`=l039oo`00F7oo1W`0<Woo001EOol:O00aOol0059oo`il031oo`00Cgoo
4W`0;goo001<OolEO00_Ool004QooaYl02ioo`00AGoo7W`0;Goo0012OolRO00/Ool003moobEl02ao
o`00?7oo:G`0:goo000iOol]O00ZOol003Iooc5l02Uoo`00<goo=7`0:Goo000`OolhO00XOol002eo
ocal02Moo`00:Woo@7`09Woo000WOom3O00VOol002AoodMl02Eoo`0087ooC7`097oo000MOom?O00T
Ool001Yooe=l02=oo`005gooEg`08Woo000DOomKO00QOol0015ooeil025oo`003GooHg`087oo000=
OomTO00OOol000eoofEl01ioo`003GooIG`07Woo000=OomVO00MOol000eoofMl01aoo`003GooJ7`0
6goo000=OomXO00KOol000eoofUl01Yoo`003GooJW`06Goo000=OomZO00IOol000eoof]l01Qoo`00
3GooK7`05goo000=Oom]O00FOol000eoofel01Ioo`003GooKW`05Goo000=Oom_O00DOol000eoog1l
01=oo`003GooL7`04goo000=OomaO00BOol000eoog9l015oo`003GooLg`047oo000=OomcO00@Ool0
00eoogAl00moo`003GooMG`03Woo000=OomfO00=Ool000eoogIl00eoo`003GooMg`037oo000=Oomh
O00;Ool000eoogQl00]oo`003GooNG`02Woo000=OomjO009Ool000eoog]l00Qoo`003GooNg`027oo
000=OomlO007Ool000eoogel00Ioo`003GooOW`01Goo000=OomnO005Ool000eoogml00Aoo`003Goo
P7`00goo000=Oon1O002Ool000eooh5l009oo`003GooPW`00Goo000=Oon1O002Ool000eooh5l009o
o`003GooP7`00goo000=OomoO004Ool000eoogil00Eoo`003GooOW`01Goo000=OommO006Ool000eo
ogal00Moo`003GooNg`027oo000=OomkO008Ool000eoogYl00Uoo`003GooNG`02Woo000=OomhO00;
Ool000eoogQl00]oo`003GooMg`037oo000=OomfO00=Ool000eoogIl00eoo`003GooMG`03Woo000=
OomdO00?Ool000eoog=l011oo`003GooLg`047oo000=OombO00AOol000eoog5l019oo`003GooL7`0
4goo000=Oom`O00COol000eoofml01Aoo`003GooKW`05Goo000=Oom]O00FOol000eoofel01Ioo`00
3GooK7`05goo000=Oom[O00HOol000eoofYl01Uoo`003GooJW`06Goo000=OomYO00JOol000eoofQl
01]oo`003GooJ7`06goo000=OomWO00LOol000eoofIl01eoo`003GooIG`07Woo000=OomUO00NOol0
00eoofAl01moo`003GooHg`087oo000?OomPO00QOol0019ooeel025oo`005GooFG`08Woo000HOomE
O00SOol001]ooe5l02Aoo`007WooCW`097oo000ROom9O00UOol002EoodEl02Ioo`00:7oo@W`09Woo
000[OolnO00WOol002ioocYl02Qoo`00<Goo=W`0:Goo000dOolcO00YOol003Moobml02Yoo`00>Woo
:g`0:goo000mOolWO00/Ool0041oobAl02aoo`00@goo87`0;Goo0016OolLO00^Ool004YooaMl02mo
o`00CGoo57`0;goo001@Ool@O00`Ool005=oo`al035oo`00EWoo27`0<Woo001IOol5O00bOol0091o
o`00T7oo002@Ool0091oo`00\
\>"],
  ImageRangeCache->{{{0, 143.313}, {143.313, 0}} -> {-1.00001, -1.00001, \
0.0139557, 0.0139557}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 .3 r
.975 .5 m
.64678 .95175 L
.11572 .7792 L
.11572 .2208 L
.64678 .04825 L
.975 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00LGoo00=l2G`8O0T0?goo001^Ool01W`9O0Ql
2G`8O0Ul23moo`00Jgoo00Yl2G`8O0Ul27`9O0Ql2G`8O0Ul23ioo`00J7oo00il2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8?Goo001UOol04W`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
23aoo`00HWoo01El2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T0?7oo001O
Ool06G`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`903]oo`00
G7oo01el2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`903Yoo`00F7oo029l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CUoo`00EGoo02El27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200iOol0059oo`0YO0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul200hOol004moo`0]O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
03Moo`00C7oo031l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TgOol004Uoo`0dO0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TfOol004Ioo`0hO0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CEoo`00@goo03al27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TdOol0041o
o`0oO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`803Aoo`00?Goo04=l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200cOol003Yoo`17O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul200bOol003Moo`1;O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8035oo`00=7oo04il
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TaOol0035oo`1BO0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T`Ool002ioo`1FO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2Bmoo`00:Woo05Yl2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P_Ool002Moo`1NO0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P^
Ool002Aoo`1RO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul22eoo`008Goo06Il2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P/
Ool001ioo`1YO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`902aoo`006goo06el2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0[Ool001Qoo`1aO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0ZOol001Aoo`1fO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TYOol001Aoo`1fO0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PYOol001Aoo`1gO0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200XOol001Aoo`1hO0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`89goo
000DOol0N7`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2BMoo`0057oo07Ul2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2@0VOol001Aoo`1jO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2BEoo`0057oo07]l2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T097oo000DOol0
Ng`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul200TOol001Aoo`1lO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PSOol001Aoo`1mO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200ROol001Aoo`1nO0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`88Goo000DOol0OW`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2B5oo`0057oo07ml2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0POol0
01Aoo`20O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2Amoo`0057oo085l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T07Woo000DOol0
PG`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul200NOol001Aoo`22O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PMOol001Aoo`23
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200LOol001Aoo`23O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0LOol0
01Aoo`24O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`96goo000DOol0QG`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`901Yoo`0057oo08Il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`96Goo000DOol0QW`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PIOol001Aoo`27O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`801Qoo`0057oo08Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul21Moo`0057oo08Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`801Ioo`0057oo08Ul2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`901Ioo`0057oo08Yl27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0TEOol001Aoo`2;O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T057oo000DOol0
Rg`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`801Aoo`0057oo08al2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`84goo000DOol0SG`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200BOol001Aoo`2>O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0PAOol001Aoo`2>O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0TAOol001Aoo`2?O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2@0@Ool001Aoo`2@O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`93goo000DOol0TG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`900ioo`0057oo095l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul200>Ool001Aoo`2BO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul20eoo`0057oo09=l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0P037oo000DOol0Tg`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2@0<Ool001Aoo`2DO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T;Ool001Aoo`2EO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0:Ool001Aoo`2FO0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`92Goo000DOol0UW`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20Uoo`00
57oo09Ml27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul2008Ool001Aoo`2HO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20Moo`0057oo09Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P01Woo000DOol0VG`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@06Ool0
01Aoo`2JO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0T5Ool001Aoo`2IO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900Ioo`0057oo09Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P01Woo000DOol0V7`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0P7Ool001Aoo`2GO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0P027oo000DOol0UW`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20Uoo`0057oo09Il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T9Ool001Aoo`2EO0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0:Ool001Aoo`2DO0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T;Ool001Aoo`2C
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900aoo`00
57oo09=l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P0
37oo000DOol0TW`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0P=Ool001Aoo`2AO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0P03Woo000DOol0TG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`900ioo`0057oo091l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0T?Ool001Aoo`2?O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0@
Ool001Aoo`2>O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TAOol001Ao
o`2>O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PAOol001Aoo`2=O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8019oo`0057oo08al2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`84goo000DOol0Rg`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`801Aoo`0057oo08]l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2@0DOol001Aoo`2:O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`95Goo000D
Ool0RG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T05Woo000DOol0RG`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P05Woo000DOol0R7`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`85goo000DOol0Qg`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200HOol001Aoo`26O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul21Uoo`0057oo08Il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`96Goo000DOol0QG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`901Yoo`0057oo08Al27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0TKOol001Aoo`23O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0LOol001Aoo`23O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul200LOol001Aoo`22O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PMOol001Aoo`21
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`801ioo`0057oo085l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T07Woo000DOol0P7`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0TOOol001Aoo`1oO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T087oo000DOol0OW`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2B5oo`0057oo07il2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PQOol001Aoo`1mO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200ROol001Aoo`1lO0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0PSOol001Aoo`1kO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`802Aoo`0057oo07]l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T097oo000DOol0NW`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TUOol001Aoo`1i
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0T09Woo000DOol0N7`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2BMoo`0057oo07Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PWOol001Aoo`1gO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200XOol001Aoo`1fO0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PYOol001Aoo`1fO0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TYOol001Ioo`1cO0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T0:Woo000IOol0Kg`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0[Ool001aoo`1[O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0/Ool001moo`1XO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
22aoo`008Woo06Al2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul22eoo`009Goo061l2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P^Ool002Qo
o`1LO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul22moo`00:goo05Ul2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`902moo`00;goo05Al27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0T`Ool0039oo`1@O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2C5oo`00=Goo04el27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8035oo`00>7oo04Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200bOol003]oo`15O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`803=oo`00
?Woo045l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`803Aoo`00@Goo03il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9=7oo0014Ool0>W`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9=Goo0017Ool0=W`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CIoo`00BWoo039l27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9=goo001=Ool0;g`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0P0=goo001@Ool0:g`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`803Qoo`00Dgoo02Ml27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0P0>Goo001FOol097`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CUoo`00FGoo021l27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9>Woo001MOol0
6g`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0kOol0
061oo`0GO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0lOol006=o
o`0DO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul23aoo`00IWoo011l2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul23eoo`00JGoo00al2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Pn
Ool006aoo`08O0Ul27`9O0Ql2G`8O0Ul23moo`00Kgoo00El2G`8O0Ul27`903moo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 .6 r
.95 .5 m
.63906 .92798 L
.13594 .7645 L
.13594 .2355 L
.63906 .07202 L
.95 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0071o
o`03O1=l4W`B041oo`00KGoo1W`B@7oo001ZOol01G`CO19l4W`BO1<00g`B00=l4g`BOol0?Woo001W
Ool>O18nOol006Aoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`BOol0?7oo001P
OolFO18mOol005eoo`03O19l4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C03aoo`00FWoo7W`B>goo001GOol00g`BO1=l4P02O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0>Woo001DOolUO18jOol0055o
o`03O19l4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O18017`CO19l4W`B>Goo001>Ool]O18hOol004]oo`03O19l4g`B009l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00=l4g`BO180>7oo0018OoldO18gOol004Aoo`9l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`02O18fOol0045oocel4SEoo`00?Woo
0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P06O1=l
4W`BO19l4g`B=Goo000kOom4O18dOol003Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO18cOol003Eo
od]l4S=oo`00<Woo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C039oo`00;goo
Dg`B<Goo000/Ool2O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C031oo`00:GooFW`B<7oo000UOol3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P04O1=l4W`BO18_Ool0029oof=l4Rioo`007goo0g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00Al4g`BO19l4Reoo`0077ooJW`B;Goo000HOol01G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C009l4Raoo`0067ooL7`B:goo000HOol2O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00Il4g`BO19l4W`CO18[Ool001Qoog5l4RYoo`0067oo00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19oo`0XOol001Qoog=l4RQoo`0067oo0W`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`COomoo`0VOol001Qo
ogAl4RMoo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<09Woo000HOomfO18UOol001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00Al4g`BO19l4REoo`0067ooMg`B97oo000HOol01G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18SOol001QoogQl4R=oo`00
67oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00W`B8Woo000HOomjO18QOol001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P03O1=l4W`B021oo`0067ooNg`B87oo000HOol2O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`C
O19oo`0NOol001Qoogel4Qioo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C01ioo`0067ooOW`B7Goo000HOol2O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<077oo000HOon0O18KOol001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18KOol001Qooh5l4QYo
o`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4QUoo`0067ooPg`B67oo000HOol01G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00=l4g`BO18067oo000HOon4O18GOol001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P0FOol0
01QoohEl4QIoo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P06O1=l4W`BO19l4g`B5Goo000HOon7O18DOol0
01Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801W`CO19l4W`BO1=l4Q=oo`0067ooR7`B4goo000HOol01G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P03O1=oogoo011oo`0067ooRW`B4Goo000HOol2O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4Q5oo`0067ooRg`B47oo000HOol01G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P04O1=l4W`BO18?Ool001Qoohel4Pioo`0067oo0W`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P0>Ool001Qoohil4Peoo`0067oo00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00W`B37oo000HOon@O18;Ool001Qo
o`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO18;Ool001Qooi5l
4PYoo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B2goo
000HOon@O18;Ool001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00aoo`0067ooSW`B3Goo000HOol01G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`0>Ool001Qoohel4Pioo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1800g`CO19oo`0>Ool001Qooh]l4Q1oo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1800g`CO19l4P0@Ool001QoohYl4Q5oo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`02O18BOol001QoohQl4Q=oo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18COol0
01QoohMl4QAoo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P04O1=l4W`BO18EOol001QoohIl4QEoo`00
67oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`0FOol001QoohAl4QMoo`0067oo0W`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P03O1=oogoo01Ioo`0067ooPg`B67oo000HOol01G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`B
Ool067oo000HOon1O18JOol001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`02O18JOol001Qooh1l4Q]oo`0067oo
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C009l4Qaoo`0067ooOW`B7Goo000HOol2O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18017`CO19l4W`B7Goo000HOommO18N
Ool001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P04O1=l4W`BO18OOol001Qoogal4Qmoo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4gooOol07Woo000HOomjO18Q
Ool001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P03O1=oogoo021oo`0067ooNG`B8Woo000HOol2O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P06O1=l4W`BO19l4g`B8goo000HOomgO18TOol001Qoo`05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C009l4RAoo`00
67ooMW`B9Goo000HOol2O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P03O1=l4W`B02Ioo`0067ooM7`B9goo000HOol01G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P04O1=l4W`BO18WOol001Qoog=l4RQoo`0067oo0W`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18YOol001Qoog9l4RUoo`0067oo00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`COomoo`0XOol001Qoog1l4R]oo`0067oo
0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`0/Ool001Yoofel4Raoo`00
7Goo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO18]Ool0021oofEl4Rioo`008goo0g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00W`B;Woo000VOomNO18_Ool002Uoo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00W`B<7oo000/OomFO18aOol002moo`=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O18aOol0039oodml4S9oo`00=Goo0g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B<goo000hOom8O18cOol003]oo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4gooOol0<Woo000nOom0
O18eOol0045oo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1800g`COomoo`0dOol004AoocUl4SIoo`00Agoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00=l4g`BOol0=Woo001:OolaO18hOol004eoo`=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00=l4g`BO180>7oo001@OolZO18iOol005=oo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P0jOol005Ioob9l4S]o
o`00FGoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Al
4g`BO19l4S]oo`00G7oo6g`B?7oo001OOol3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P04O1=l4W`BO18mOol0069ooaAl4Seoo`00IGoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`0nOol006Qoo`al4Smoo`00Jgoo0g`B00El4g`BO19l4W`C041oo`00KWoo1G`B@7oo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00001
\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 .9 r
.925 .5 m
.63133 .9042 L
.15617 .74981 L
.15617 .25019 L
.63133 .0958 L
.925 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00KWoo00=l77`KO1`0@Woo001[Ool6O1a2Ool006Qoo`0:O1al6g`LO1]l
77`KO1al6g`LO1]1Ool006Eoo`il741oo`00HWoo019l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1/oOol005mooaEl73moo`00G7oo01Ul77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l700nOol005Uooael73eoo`00EWoo025l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`0?7oo001COolTO1`l
Ool0051oo`0XO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/kOol004eoobal73Yoo`00BWoo031l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/iOol004Mooc=l73Uoo`00@goo03Ql6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L>7oo0010OollO1`gOol003eoo`10
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1`fOol003Yood=l73Ioo`00=goo04Ml6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K03Eoo`00=7oo
Bg`L=7oo000aOol0CW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l73Aoo`00;WooDW`L
<goo000[Ool0EW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1`bOol002QooeYl735oo`009Goo05el6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/0<Goo000ROomQO1``Ool001moo`1UO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6`0_Ool001]oofYl72ioo`006goo06Yl6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l72ioo`006gooJg`L;Goo000KOol0K7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l72aoo`006gooKG`L:goo000KOol0KG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`K02]oo`006gooKW`L:Woo000KOol0Kg`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6`0YOol001]oog1l72Qoo`006goo071l6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l72Qoo`006gooLG`L9goo000KOol0LW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l72Ioo`006gooLW`L9Woo000KOol0Lg`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02Eoo`006gooM7`L97oo000KOol0MG`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0SOol001]oogEl
72=oo`006goo07Il6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l729oo`006gooMg`L8Goo000KOol0N7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l721oo`006gooN7`L87oo000KOol0NG`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K01moo`006goo
NW`L7Woo000KOol0Ng`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6`0MOol001]oog]l71eoo`006goo07al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l71aoo`006gooOG`L
6goo000KOol0OG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1/06goo000KOomnO1`JOol001]oo`1oO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/06Goo
000KOon0O1`HOol001]oo`20O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l71Qoo`006gooPG`L5goo000KOol0PW`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`L5Woo000KOon3O1`EOol001]oo`23O1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0E
Ool001]oohAl71Aoo`006goo08El6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0COol001]oohIl719o
o`006goo08Il6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L4Woo000KOon7O1`AOol001]oo`28O1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`@Ool001]oohUl70moo`006goo08Ul6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`K00moo`006gooRW`L3Woo000KOol0RG`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1/03goo000KOon9O1`?Ool001]oo`28O1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1`@Ool001]oohMl715oo`006goo08Il6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`L4Woo000KOon6O1`BOol001]oo`25O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/04goo000KOon4
O1`DOol001]oo`23O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0EOol001]ooh=l71Eoo`006goo089l6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l71Ioo`006gooPG`L5goo000KOol0P7`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`HOol001]o
oh1l71Qoo`006goo07ml6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0IOol001]oogil71Yoo`006goo07el6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
01]oo`006gooOG`L6goo000KOol0O7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L77oo000KOomkO1`MOol001]oo`1kO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K01eo
o`006gooNW`L7Woo000KOol0NG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`K01moo`006gooN7`L87oo000KOol0N7`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l721oo`006gooMg`L8Goo000K
Ool0MW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
8Woo000KOomeO1`SOol001]oo`1eO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`K02=oo`006gooM7`L97oo000KOol0Lg`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02Eoo`006gooLW`L9Woo000KOol0LW`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l72Ioo`006gooLG`L9goo000KOol0L7`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L:7oo000KOom`O1`XOol001]o
o`1_O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02Uoo`006gooKW`L:Woo
000KOol0KG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02]oo`006gooKG`L:goo
000KOol0K7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l72aoo`006gooJg`L;Goo000K
Ool0JW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L;Woo000KOomZO1`^Ool001]oo`1YO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02moo`007GooIW`L<7oo000POol0HW`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1/aOol002=ooeml735oo`009goo05Yl6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`bOol002YooeIl73=oo`00;Goo059l6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l73Aoo`00<7ooCg`L=7oo000cOol0Bg`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6`0eOol003IoodMl73Ioo`00>Goo04Al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
=Woo000mOoloO1`gOol0041oo`0kO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l700hOol004=oocMl73Uoo`00AWoo03Al77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6cUoo`00BGoo<7`L>Woo001<Ool0;7`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1/kOol004moobQl73aoo`00Dgoo02Al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`lOol005Ioob1l73eo
o`00FGoo01al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l73ioo`00G7oo67`L?goo001OOol05G`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6`0oOol0069ooa5l741oo`00IGoo00el6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`11Ool0
06Uoo`Ql749oo`00K7oo00El77`KO1al6g`L049oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 0 1 r
.9 .5 m
.62361 .88042 L
.17639 .73511 L
.17639 .26489 L
.62361 .11958 L
.9 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo001]Ool00f0OI1mP7`13Ool006Yoo`06
H1mT7f0OI1mP7f@O@goo001WOol02V0OI1mP7f@OH1mT7f0OI1mP7f@O@Woo001TOol03V0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1m1Ool0065oo`0BH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@O@7oo001NOol05F0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`10
Ool005Yoo`0JI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7cmoo`00Egoo01iT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1lnOol005Aoo`0QI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O03ioo`00DGoo02ET7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0mOol004io
o`0YI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0lOol004]oo`0]I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@O03]oo`00B7oo031T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lkOol004Eo
o`0dI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1ljOol0049oo`0hI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7cUoo`00?goo03aT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lh
Ool003aoo`0oI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@O03Qoo`00>Goo04=T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0gOol003Ioo`17I1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7`0fOol0039oo`1;H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03Ioo`00
;goo04mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0eOol002aoo`1CH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0dOol002Uoo`1GH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03=oo`009Woo05YP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lcOol0
02=oo`1NH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1lbOol001moo`1SI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O035oo`007goo06=P7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l0<Goo000OOol0I6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O<7oo000OOol0IF0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1l0;goo000OOol0IV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7bioo`007goo06IP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l^Ool001moo`1WI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0
;Goo000OOol0J60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l/Ool001moo`1YI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@O02]oo`007goo06UP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0
:goo000OOol0JV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O:Woo000OOol0Jf0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0:Goo000OOol0Jf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1l0:Goo000OOol0K60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7bQo
o`007goo06eT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0WOol001moo`1^H1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7bIoo`007goo06iT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O9Woo000OOol0Kf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7`0UOol001moo`1`I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1lTOol001moo`1`H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1lTOol001moo`1aI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7`0SOol001moo`1bH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@O8Woo000OOol0Lf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@O025oo`007goo07=P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`0QOol001moo`1dI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7b1oo`007goo07EP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l07goo000OOol0MF@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7`0OOol001moo`1fH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lNOol001moo`1gI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0MOol001moo`1hH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O77oo000OOol0N6@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7aaoo`007goo
07UP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`0KOol001moo`1jI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7aYoo`007goo07]P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l06Goo000OOol0Nf@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0IOol001mo
o`1lH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1lHOol001moo`1mI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0GOol001moo`1mH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0GOol001mo
o`1nI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0O5Woo000OOol0Of0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O01Eoo`007goo081T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0O57oo000OOol0P60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lDOol001moo`21I1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
01=oo`007goo081P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O57oo000OOol0P6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lDOol001mo
o`1oH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1l05Goo000OOol0OV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7aIoo`007goo07eP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
01Moo`007goo07eT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O01Moo`007goo07aP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7aQoo`007goo07]T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l06Goo
000OOol0Nf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`0IOol001moo`1jI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7aYoo`007goo07UP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0KOol001moo`1hI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O77oo000OOol0
N60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7aaoo`007goo07MT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O01eoo`007goo07IP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7aioo`007goo07ET7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l07goo000OOol0MF0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0OOol001moo`1dI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7b1oo`007goo07=P7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0QOol001moo`1cI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l08Goo000OOol0LV0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7b9oo`007goo075T7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O02=oo`007goo071P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7bAoo`007goo071T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7bAoo`007goo06mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1l09Goo000OOol0KV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lVOol0
01moo`1^H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7bIoo`007goo06eT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0WOol001moo`1/H1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O:7oo000OOol0Jf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1l0:Goo000OOol0Jf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0:Goo000OOol0
JV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O:Woo000OOol0JF0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`0[Ool001moo`1YI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O02]oo`00
7goo06QP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O;7oo000OOol0If@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O02eoo`007goo06IP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l^Ool001moo`1VI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O;Woo000OOol0IF0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0;goo000OOol0
I6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0O<7oo000OOol0Hf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0aOol001moo`1S
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@O035oo`008Goo061P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lbOol002Aoo`1LH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7c=oo`00
9goo05UP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0O03=oo`00:Woo05EP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`0dOol002eoo`1AH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03Eo
o`00<7oo04eP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03Ioo`00=7oo04UT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`0fOol003Moo`15I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O03Moo`00>Woo045T
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O03Qoo`00?Goo03iT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O>7oo0010Ool0>V@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O>Goo0013Ool0=V@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7cYoo`00AWoo039T7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O>goo0019Ool0;f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1l0>goo001<Ool0:f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O03aoo`00Cgoo02MT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1l0?Goo001BOol08f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0?Woo001EOol086@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lnOol005Qoo`0LI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1loOol005aoo`0G
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`10Ool005moo`0DH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7d1oo`00HWoo011P7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7d5oo`00IGoo00aP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1m2Ool006Qo
o`08H1mT7f0OI1mP7f@OH1mT7d=oo`00Jgoo00EP7f@OH1mT7f0O04=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo0000\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 0 1 r
.875 .5 m
.61588 .85665 L
.19662 .72042 L
.19662 .27958 L
.61588 .14335 L
.875 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol006ao
o`<l7dAoo`00JGoo1S`OA7oo001VOol3?1l01CPO?1ll7c`O>1l00S`O@goo001SOol>?1m2Ool0061o
o`<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00S`O@Goo001MOolE?1m1Ool005Yoo`<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Hh7c`O?1ll7cPO?1m0Ool005Mooadl7cmoo`00
E7oo0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO03moo`00DGoo93`O?Woo001>Ool3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO03eoo`00Bgoo;3`O?7oo
0018Ool3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`04>1ll7c`O?1llOol004Eooc<l7c]oo`00@Woo0c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00@h7c`O?1ll7cYoo`00?goo>c`O>Goo
000lOol3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00<h7c`O?1l0>Goo000iOom2?1lhOol003Ioo`<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7c`O?1l0=goo000cOom9?1lg
Ool0031oo`<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`03>1ll7goo03Eoo`00;GooDC`O=Goo000Z
Ool3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7c`OOol0<goo000W
OomH?1ldOol002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO03=oo`008gooGS`O<Woo000SOol2?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`04>1ll7c`O?1lbOol002=ooell
7c5oo`008goo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O<7oo000SOomQ?1l_Ool002=oo`8l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO008l7bmoo`00
8gooHS`O;Woo000SOol01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l00cPO?1ll7`0]Ool002=oof<l7beoo`008goo0S`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00<h7c`OOol0:goo000SOomU?1l[Ool002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`06>1ll7c`O?1lh
7c`O:Woo000SOomV?1lZOol002=oo`8l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`0YOol002=oofPl
7bQoo`008goo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7bQoo`008gooJC`O9goo000SOol2?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O9Woo000SOom[?1lUOol002=oo`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l00cPO?1ll7`0UOol002=oof`l7bAoo`008goo0S`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`03>1ll7c`O02=oo`008gooKS`O8Woo000SOol01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Hh7c`O?1ll7cPO?1lROol002=oofll7b5oo`008goo0S`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`06>1ll7c`O?1lh7c`O87oo000SOom`?1lPOol002=oo`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7gooOol07Goo000SOomb?1lNOol002=oo`8l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7gooOol06goo000S
Oomc?1lMOol002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00@h
7c`O?1ll7aaoo`008gooMC`O6goo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`03>1ll7c`O01]oo`008gooMS`O6Woo000SOol01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`02?1lIOol002=oogPl7aQoo`008goo
0S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01SPO?1ll7c`O>1ll
7aQoo`008gooNC`O5goo000SOol01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1lHOol002=oogPl7aQoo`008goo0S`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l06Goo000SOomf?1lJOol002=oo`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO01]oo`00
8gooMC`O6goo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`03>1ll7goo01]oo`008gooLc`O7Goo000SOol01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`03>1ll7c`O01eoo`008gooLS`O7Woo000SOol2?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO008l7amoo`008gooL3`O87oo000SOol01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7b1oo`008gooKc`O8Goo000SOol2?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00@h7c`O?1ll7b9oo`008gooKS`O8Woo000SOol01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO02=oo`008gooK3`O97oo000SOol2?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00<h7gooOol08goo000SOom[?1lUOol002=oo`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l00cPO?1moo`0UOol002=oofTl7bMoo`008goo0S`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Hh7c`O?1ll7cPO?1lXOol002=oofPl7bQoo`008goo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO008l
7bUoo`008gooIS`O:Woo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l013PO?1ll7c`O:Woo000SOomU?1l[Ool0
02=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`04>1ll7c`O?1l/Ool002=oof<l7beoo`008goo0S`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00<h7gooOol0:goo000SOomR?1l^Ool002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`03>1moogoo02eoo`008gooHC`O
;goo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`06>1ll7c`O?1lh7c`O<7oo000SOomO?1laOol002=oo`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Hh7c`O?1ll7cPO?1lbOol002=ooehl
7c9oo`008goo0S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l00cPO?1ll7`0cOol002=ooe`l7cAoo`009Goo0S`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1ldOol002QooeHl7cEoo`00:goo0S`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7cIoo`00;WooCS`O=goo000bOol00c`O
>1ll7`02?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`0gOol003EoodHl7cQoo`00>7oo00<l7cPO?1l00S`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`0iOol003]oocll7cUoo`00?Woo00<l7cPO?1l00S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Hh7c`O?1ll7cPO?1ljOol0045oocLl7c]oo`00A7oo00<l7cPO?1l00S`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01SPO?1ll7c`O>1ll7caoo`00Agoo<3`O?7oo001;Ool01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`03>1ll7c`O03eoo`00CWoo9c`O?Woo001AOol01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7c`O?1l0?goo001DOolP
?1loOol005Moo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`04
>1ll7c`O?1m0Ool005YooaPl7d5oo`00GGoo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l0@Goo001POolA?1m2Ool006Aoo`<l7`05>1ll7c`O?1lh7`03?1l00cPOOomoo`11
Ool006Moo`Pl7dAoo`00JWoo0c`O00<h7c`OOol0@goo002cOol00;=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.2 0 1 r
.85 .5 m
.60816 .83287 L
.21684 .70572 L
.21684 .29428 L
.60816 .16713 L
.85 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo001[Ool00a@O61lD7`16Ool006Qoo`<D7`0361lD7a@O04Ioo`00
IGoo00XD7aPO51lH7a@O61lD7aPO51lH7dEoo`00HWoo0a@O00DH7a@O51lD7aPO00<D7`0361lD7a@O
04Aoo`00Ggoo018D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61m3Ool005aoo`<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@OOol0@Woo001HOol06QPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51m2Ool005Eoo`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O@Goo001BOol0
8APO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7`11Ool004moo`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0@7oo001<Ool0:APO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61l0?goo0019Ool01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0nOol004Ioo`0`61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O?Woo0013Ool01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l011PO51lD7a@O?Goo0010Ool0>1PO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51llOol003eoo`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51lD7`0lOol003Yoo`0o61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO03]oo`00
=Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0251ljOol003=oo`1851lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO>Goo
000`Ool00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O>Goo000]Ool0Ca@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O03Qoo`00:Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00HH7a@O51lD7aPO51lgOol002Ioo`1G61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO03Moo`009Woo0a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0fOol002Ioo`1I61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0eOol002Ioo`0351lH7a@O
008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0=7oo
000VOol0FQPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7cAoo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351lcOol002Ioo`1L61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7c9oo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351laOol002Ioo`1M61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
035oo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l00aPO51lD7`0`Ool002Ioo`1O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0_Ool002Ioo`0351lH7a@O008D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O
Ool0;Woo000VOol0H1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7bioo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7beoo`009Woo068H7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O;7oo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0/Ool002Ioo`1S61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO02]oo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7gooOol0:7oo000VOol0I1PO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O:Woo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351lYOol002Ioo`1V61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O:7oo000VOol351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7a@O9goo000VOol0
IaPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO02Moo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00<H7a@O51l09Woo000VOol0JAPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0UOol002Ioo`<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O9Goo000VOol0JQPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O97oo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7b=oo`00
9Woo06`H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lROol002Ioo`<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l00aPOOomoo`0POol002Ioo`1]61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61l08Goo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00<H7gooOol07Woo000VOol0KQPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lPOol002Ioo`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7a@O7goo000V
Ool0L1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O7Woo000VOol00a@O
61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7aeoo`009Woo074H7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO01eoo`009Woo0a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251lLOol002Ioo`1a61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0MOol002Ioo`0351lH7a@O008D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7a@O7Goo000VOol0L1PO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O7Woo000VOol351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00@H7a@O51lD7amoo`009Woo06hH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O87oo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7goo
Ool07Woo000VOol0KAPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO025oo`009Woo
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361moogoo021oo`009Woo06/H7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO02=oo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH
7a@O51lD7aPO51lSOol002Ioo`1Z61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lTOol002Io
o`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O9Goo000VOol0JAPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7`0UOol002Ioo`0351lH7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7a@O02Ioo`009Woo
06LH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0WOol002Ioo`<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7a@O
02Qoo`009Woo06HH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lXOol002Ioo`0351lH7a@O008D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7bUoo`009Woo06@H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7bYoo`009Woo0a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
:goo000VOol0HaPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0[Ool002Ioo`0351lH7a@O008D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO02ao
o`009Woo064H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7`0]Ool002Ioo`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l]Ool002Ioo`1P61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O;Woo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7goo02ioo`009Woo05hH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7c1oo`009Woo0a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO
51lD7`0`Ool002Ioo`1M61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO035oo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251lbOol002Ioo`1K61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0<goo000VOol3
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7c=o
o`009Woo05XH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51ldOol002Ioo`0351lH7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l011PO51lD7a@O=Goo000VOol0F1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O=Woo000VOol351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO03Ioo`009Woo05LH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0=goo000XOol351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00<H7gooOol0=Woo000[Ool0DA@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`0hOol002moo`8D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0361lD7goo03Qoo`00<Woo04PH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51ljOol003Eoo`8D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00<H7a@OOol0>Woo000hOol0@APO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0>goo000kOol251l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O51l0?7oo000oOol0>1@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lmOol0049oo`0351lH
7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7cioo`00AGoo034D7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`0nOol004Qoo`0351lH7a@O008D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O?goo001<Ool0:1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O@7oo001?Ool01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO041oo`00DWoo024H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61l0@Goo001EOol01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0@Woo001IOol061@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7d=oo`00G7oo0a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l00aPO51moo`12Ool005moo`0A51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7`14Ool0069oo`<D7`0561lD7a@O51lH7`0351l00aPO51moo`14Ool006Eoo`0951lH7a@O
61lD7aPO51lH7a@O04Ioo`00JGoo0Q@O00<H7a@O51l0AWoo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00001\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .1 1 r
.825 .5 m
.60043 .80909 L
.23707 .69103 L
.23707 .30897 L
.60043 .19091 L
.825 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol006Uoo`<0GdQoo`00IWoo1P1O
B7oo001SOol305l01@1o05l0G`1O07l00P1OAgoo001POol>05m6Ool005eoo`<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00P1OAGoo001IOolF05m5Ool005Ioo`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0Ggoo04=oo`00Dgoo7P1O@goo001@Ool01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00<0O`1OOol0@Goo001=OolU05m2Ool004Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0OgooOol0?goo
0017Ool]05m0Ool004Aoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307moogoo
03eoo`00@Goo=01O?goo000nOol01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O?Woo000kOoll05lmOol003Moo`0305l0O`1O0080G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l00`1o05l0G`0mOol003Aood@0Gcaoo`00
<Goo00<0G`1o05l00P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l00`1o05l0G`0kOol002iood`0GcYoo`00:Woo0P1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00H0O`1O05l0G`1o05ljOol002Yooe40GcUoo`00:Woo00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0Ggoo03Moo`00:WooD`1O=goo000ZOol2
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0OgooOol0=Goo000ZOomD
05lfOol002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l0=Goo000ZOomF05ldOol002Yoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l0101o05l0G`1O=7oo000ZOomG05lcOol002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O<Woo000ZOomH05lbOol002Yoo`80G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O<Goo000ZOomJ05l`
Ool002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00<0O`1O05l0;goo000ZOomK05l_Ool002Yoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0O`1OOol0;Goo000ZOomM05l]Ool002Yoo`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00H0O`1O
05l0G`1o05l/Ool002Yooeh0Gbaoo`00:Woo0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0:goo000ZOomP05lZOol002Yoo`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0GbYoo`00:WooH@1O:Goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305lXOol002Yoof<0GbMoo`00
:Woo00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00<0O`1O05l09goo000ZOomT05lVOol002Yoo`80G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`03
07l0G`1O02Eoo`00:WooIP1O97oo000ZOol01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01P1o05l0G`1O07l0GbAoo`00:Woo
I`1O8goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01P1o05l0G`1O07l0Gb9oo`00:WooJ@1O8Goo000ZOol0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0OgooOol07goo000ZOomZ05lPOol002Yoo`80G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0205lQOol002YoofT0Gb5oo`00:Woo00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0Gb9oo`00:WooI`1O8goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0101o05l0G`1O97oo
000ZOomV05lTOol002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0UOol002Yoof@0GbIoo`00:Woo
0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00<0OgooOol09Goo000ZOomS05lWOol002Yoo`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0
Ggoo02Moo`00:WooH@1O:Goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0607l0G`1O05l0O`1O:Woo000ZOomP05lZOol002Yoo`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o0080Gb]oo`00:WooGP1O;7oo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O02eoo`00:WooG@1O;Goo000ZOol01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0407l0G`1O05l^
Ool002Yooe/0Gbmoo`00:Woo0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l`Ool002YooeX0Gc1oo`00:Woo00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l00`1oOomoo`0_Ool002YooeP0Gc9oo`00:Woo
0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0cOol0
02YooeL0Gc=oo`00:Woo00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0607l0
G`1O05l0O`1O=7oo000ZOomE05leOol002Yoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l00`1o05moo`0eOol002Yooe@0GcIoo`00:Woo00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O03Moo`00:WooDP1O>7oo000ZOol205l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O>Goo000ZOomA05liOol002aoo`80G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0407l0G`1O05ljOol002moodX0Gc]oo`00<Woo0P1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0101o
05l0G`1O?7oo000eOom305llOol003Qoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0?Goo000lOolj05lnOol003moo`0305l0O`1O
0080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307moogoo03eoo`00@Woo<`1O
?goo0015Ool00`1O07l0G`0205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0Ggoo03moo`00B7oo:`1O
@Goo001;Ool00`1O07l0G`0205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00<0O`1OOol0@Goo001>OolT05m2Ool0055oo`0305l0O`1O
0080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O
04=oo`00E7oo701OA7oo001GOol00`1O07l0G`0205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0307l0G`1O04Eoo`00FWoo5@1OAGoo001NOol01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0GdIoo`00HGoo301OAgoo001TOol01@1o05l0G`1O07l00`1OB7oo001WOol505m8Ool00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .4 1 r
.8 .5 m
.59271 .78532 L
.25729 .67634 L
.25729 .32366 L
.59271 .21468 L
.8 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo001XOol30Im9Ool006Eoo`060Gl1W`5o0Il1O`6OBGoo001ROol:0Im8Ool005ioo`0?0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O04Moo`00Fgoo4`6OAWoo001HOol05P6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5oAWoo001EOolJ0Im5Ool0059oo`0N0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5oA7oo001?
OolR0Im3Ool004]oo`0V0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1Wd=oo`00B7oo:P6O@Woo0015Ool0;P5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O@Goo0012Oola0Im1Ool003moo`0e0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`10Ool003aoocT1Wcmoo`00>Goo03d1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0nOol0
03Eood41Wcioo`00<Woo04D1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0?Goo000^Oom:0IllOol002ioo`1;0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O03]oo`00;WooB`6O>goo000^Ool0C06O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o>Woo000^Oom=0IliOol002ioo`1=0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`0iOol002ioodh1WcQoo`00;Woo04l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`0gOol002iooe01WcIoo`00;Woo0501W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o=Woo000^OomA0IleOol002ioo`1B0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0GldOol002iooe81WcAoo`00;Woo05<1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O03=oo`00;WooE06O<Woo000^Ool0E@6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O035oo`00;WooE@6O<Goo000^
Ool0EP6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl`Ool0
02iooeL1Wbmoo`00;Woo05P1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1Obioo`00;WooF06O;Woo000^Ool0F@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0;Goo000^OomJ0Il/Ool002ioo`1J0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o;7oo000^
OomK0Il[Ool002ioo`1L0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1ObYoo`00;WooG@6O:Goo000^Ool0G@6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0YOol002iooeh1WbQo
o`00;Woo05l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O02Moo`00;WooH06O9Woo000^Ool0H06O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1ObIoo`00;Woo
H@6O9Goo000^Ool0H06O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1ObIoo`00;WooH06O9Woo000^Ool0G`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il09goo
000^OomN0IlXOol002ioo`1M0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O02Uoo`00;WooG@6O:Goo000^Ool0G06O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0GlZOol002iooe/1
Wb]oo`00;Woo05X1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl/Ool002iooeX1Wbaoo`00;Woo05T1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O02eoo`00;WooF06O;Woo000^Ool0F06O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o;Woo000^OomG0Il_
Ool002ioo`1F0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
Oc1oo`00;WooE@6O<Goo000^Ool0E@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O035oo`00;WooE06O<Woo000^Ool0D`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0<goo000^OomB0IldOol002ioo`1B0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0GldOol002iooe41WcEoo`00;Woo0501W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o=Woo000^Oom@0IlfOol002ioo`1?0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0=goo000^Oom>0IlhOol002ioo`1=0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0iOol002ioodd1WcUoo`00;Woo04`1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1OcYoo`00;WooB`6O>goo000^Ool0B`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`0kOol0031oodP1Wcaoo`00<goo04@1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O?Goo000fOom00IlnOol0
03Uoo`0m0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl0?Woo000lOoli0IloOol003moo`0e0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`10Ool0049ooc41Wd5oo`00AGoo02h1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1Wd5oo`00B7oo:P6O@Woo001;Ool09P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Im3Ool004ioob<1Wd=o
o`00DGoo01l1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`14Ool005Aooa/1WdEoo`00Egoo01L1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o04Ioo`00FWoo506OAWoo001MOol0405o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6OAgoo001POol<0Im8Ool006=oo`080Gl1W`5o0Il1O`6O0Gl1WdUoo`00IWoo1@6O
BGoo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .7 1 r
.775 .5 m
.58498 .76154 L
.27752 .66164 L
.27752 .33836 L
.58498 .23846 L
.775 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo001VOol00`:o0]l2_`1:Ool006=oo`060[l2g`:o0]l2_`;OBWoo
001POol00`:o0]l2_`020[l01@;O0[l2_`:o0]l0BGoo001MOol03P:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]m8Ool005Yoo`030[l2g`:o0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0Agoo
001GOol05@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`17Ool005Aoo`03
0[l2g`:o0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2_dIoo`00DGoo
01d2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
04Eoo`00CWoo00<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00@2g`:o0[l2_dAoo`00BWoo02D2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`14Ool004Moo`82_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00P:o@goo0014Ool0;@;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`12Ool0
045oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O0[m2Ool003ioo`0d0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[m1Ool003]oo`82_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o@7oo000hOol0?0;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_cmoo`00=Goo0P:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`0oOol0035oo`140[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gcioo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0?Goo
000aOol0A@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0mOol0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2_caoo`00
<Goo04L2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o03]oo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
>Woo000aOol0B0:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gcYoo`00<Goo0P:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00P:o>Goo000aOol0BP:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]lhOol0035oo`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`030]l2_`:o03Moo`00<Goo04/2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l0=goo000aOol20[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`0eOol0035o
o`1=0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0eOol0035oo`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`0eOol0035oo`1>0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O=7oo000aOol20[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0<goo
000aOol0D0:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]lbOol0035oo`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[lbOol0035oo`1A0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o035oo`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_c1oo`00<Goo0582_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2gc1oo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`030]l2_`:o02moo`00<Goo05@2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l^Ool0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
0`;O0[l2_`0]Ool0035oo`1E0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l0;Goo000aOol01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2
g`:o0[l2_`;O0[l/Ool0035oo`1G0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o02]oo`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`060]l2_`:o0[l2g`:o:Woo000aOol0F0:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O:Woo000aOol01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]moogoo02Moo`00<Goo05P2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gbYoo`00<Goo0P:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o:Woo000aOol0
E`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0[Ool0
035oo`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01P;O0[l2_`:o0]l2_bao
o`00<Goo05D2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0]
Ool0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[l2_`0]
Ool0035oo`1D0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O;Woo
000aOol01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`:o0[l0;goo000a
Ool0DP:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O<7oo000aOol20[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o<7oo000aOol0D@:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0aOol0035oo`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[lbOol0035oo`1@0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2gc9oo`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O03=o
o`00<Goo04h2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]ldOol0035oo`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`0eOol0035oo`1=0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`0eOol0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]l2_goo03Eo
o`00<Goo04/2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0=goo000aOol01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l00`;O0[l2_`0gOol0035oo`1:0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gcQo
o`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00P:o>Goo000aOol0B0:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2gcYoo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o>Woo000aOol0A`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l0>goo000aOol20[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`:o0[llOol0035oo`150[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o03eoo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0?Goo000aOol0A0:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]lnOol003=oo`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00<2ggooOol0?Goo000fOol0?P;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[loOol003Uoo`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`0oOol003ao
o`0f0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o@Goo000oOol0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`11Ool0049oo`0_0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`12Ool004Eoo`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2
g`:o0[l0@goo0018Ool09`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`14Ool004]oo`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`:oA7oo
001?Ool07`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o04Eoo`00DWoo0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:oAWoo001EOol05`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l0Agoo001HOol30[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]moogoo04Eo
o`00Fgoo0102_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gdQoo`00GWoo0`:o00D2g`:o0[l2
_`;O00<2_`030]moogoo04Moo`00HGoo00P2_`;O0[l2g`:o0]l2_`;OBWoo001TOol30[l00`;O0[mo
o`19Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 1 r
.75 .5 m
.57725 .73776 L
.29775 .64695 L
.29775 .35305 L
.57725 .26224 L
.75 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00IGoo0`?oC7oo001R
Ool60om<Ool005moo`X3od]oo`00G7oo3P?oBWoo001HOolC0om9Ool005EooaH3odUoo`00DWoo6P?o
B7oo001?OolN0om7Ool004aoob43odMoo`00BGoo9@?oAWoo0016OolY0om5Ool004=oobd3odAoo`00
?goo<@?oA7oo000lOole0om3Ool003UoocT3od9oo`00=Goo?P?o@Goo000eOoln0om1Ool003Eoocl3
od1oo`00=Goo@0?o?goo000eOom00oloOol003Eood43ocioo`00=Goo@P?o?Goo000eOom30ollOol0
03Eood<3ocaoo`00=GooA0?o>goo000eOom50oljOol003EoodD3ocYoo`00=GooAP?o>Goo000eOom7
0olhOol003EoodP3ocMoo`00=GooB0?o=goo000eOom90olfOol003EoodX3ocEoo`00=GooB`?o=7oo
000eOom;0oldOol003Eood`3oc=oo`00=GooC@?o<Woo000eOom=0olbOol003Eoodh3oc5oo`00=Goo
C`?o<7oo000eOom@0ol_Ool003Eooe03obmoo`00=GooD@?o;Woo000eOom@0ol_Ool003Eooe03obmo
o`00=GooC`?o<7oo000eOom>0olaOol003Eoodd3oc9oo`00=GooC@?o<Woo000eOom<0olcOol003Eo
od/3ocAoo`00=GooBP?o=Goo000eOom:0oleOol003EoodT3ocIoo`00=GooB0?o=goo000eOom70olh
Ool003EoodL3ocQoo`00=GooAP?o>Goo000eOom50oljOol003Eood@3oc]oo`00=GooA0?o>goo000e
Oom30ollOol003Eood83oceoo`00=Goo@P?o?Goo000eOom10olnOol003Eood03ocmoo`00=Goo?`?o
@7oo000eOolo0om0Ool003Eooch3od5oo`00=goo>`?o@Woo000jOolg0om3Ool003eooc@3od=oo`00
@7oo<0?oA7oo0014Ool[0om5Ool004MoobL3odIoo`00BWoo90?oAWoo001=OolP0om7Ool0051ooa`3
odQoo`00Dgoo60?oBGoo001FOolE0om9Ool005Uooa43odYoo`00GGoo30?oBgoo001POol80om<Ool0
06=oo`D3odaoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .7 r
.725 .5 m
.56953 .71399 L
.31797 .63225 L
.31797 .36775 L
.56953 .28601 L
.725 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo001TOol30oE=Ool0065oo`060oD3mP?e0oH3m@?fCGoo001NOol30oD01@?f0oD3m@?e0oH0
0P?eC7oo001KOol03P?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oI;Ool005Qoo`<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00P?eBWoo001EOol05@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@1:Ool0059oo`<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00H3mP?e0oD3m@?f0oE9Ool004moo`0M0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@18Ool004aoo`<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP18Ool004Uoo`0T0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?fAgoo
0016Ool30oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f04Ioo`00@goo02`3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?fAGoo0010Ool30oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3m@?e0oE5Ool003eoo`0c0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e04Aoo`00>Goo00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3mD=oo`00>Goo03P3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f@goo000iOol20oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00P?e@Woo000iOol0>P?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f@Goo000iOol01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?e0oD0@7oo
000iOol0>`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD0@7oo000iOol20oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00<3mP?eOol0?Woo000iOol0?@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e03ioo`00>Goo00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@060oH3m@?e0oD3mP?e?Goo000iOol0?P?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oHm
Ool003Uoo`83m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH0?7oo000iOol0@0?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f>goo000iOol01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3mC]oo`00>Goo0443
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e03Yoo`00>Goo0P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oDiOol003Uoo`130oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0>7oo000i
Ool01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@030oH3m@?e03Qoo`00>Goo04@3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f=goo000iOol20oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@030oH3m@?e03Ioo`00>Goo04D3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0=Woo000iOol01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@06
0oH3m@?e0oD3mP?e=Goo000iOol0A`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0=7oo000iOol20oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@060oH3m@?e0oD3mP?e<goo000iOol0B0?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mS=oo`00>Goo
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mWooOol0<7oo000iOol0B0?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mS=oo`00>Goo0P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3mC=oo`00>Goo04L3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e03Aoo`00>Goo00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3mCEoo`00>Goo04D3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD0=Woo000iOol20oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3m@?e03Ioo`00>Goo04@3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f=goo000iOol01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3m@?e03Qoo`00>Goo0483m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oHiOol003Uo
o`83m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e>Goo000iOol0@@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0>Woo000iOol01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3mC]oo`00>Goo03l3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD0?7oo000iOol20oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f03aoo`00>Goo03h3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f?Goo000iOol01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f03ioo`00>Goo03`3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oHo
Ool003Uoo`83m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD00`?f0oEoo`0nOol003Uoo`0k0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@10Ool003Uoo`050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD00`?f0oEoo`10Ool003Uoo`0j0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oI1Ool003Uoo`83m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP020oE2Ool003Uoo`0h0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mT=oo`00>goo0P?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?e0oD0A7oo000nOol0<P?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oE4Ool0045oo`83m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00@3
mP?e0oD3mDEoo`00A7oo02X3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oE6Ool004Moo`83m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD010?f
0oD3m@?eAgoo001:Ool08`?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH0Agoo001=Ool20oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0B7oo001@Ool06`?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP19Ool005=oo`83m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f04Yoo`00EWoo01@3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?eBWoo001IOol20oD01@?f0oD3m@?e0oH00`?e00H3
mP?e0oD3m@?f0oE;Ool005aoo`0<0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?eC7oo001OOol20oD01P?f
0oD3m@?e0oH3mDeoo`00HWoo00D3mP?e0oH3m@?f04eoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .4 r
.7 .5 m
.5618 .69021 L
.3382 .61756 L
.3382 .38244 L
.5618 .30979 L
.7 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00HWoo00<3k0?[0n`0Cgoo001OOol60na?Ool0
05aoo`0:0n`3j`?/0n/3k0?[0n`3j`?/0n]>Ool005Uoo`h3k4eoo`00EWoo0183k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n]<Ool005=ooaD3k4aoo`00Cgoo01X3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/Bgoo001<OolN0na:Ool004Uoo`0R0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0na9Ool004IoobD3k4Uoo`00@goo02T3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[04Qoo`00@7oo;@?/
Agoo000lOol0<P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n]6Ool003aooc83
k4Ioo`00?7oo03<3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0AGoo000l
Oold0na4Ool003aoo`0e0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k013Ool003aoocD3k4=oo`00?7oo03H3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n]2Ool003aoocL3k45oo`00?7oo03L3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k011Ool003aoocP3k41oo`00?7oo03T3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0?goo000lOolj0n`nOol003aoo`0j
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/nOol0
03aooc/3k3eoo`00?7oo03`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/lOol003aoocd3k3]oo`00?7oo03d3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00kOol003aooch3k3Yoo`00?7oo
03l3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`0>Goo000lOom00n`hOol003aoo`100n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/hOol003aood43k3Moo`00?7oo0403
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3jcQoo`00?7oo@0?/>7oo000lOol0?`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00iOol003aooch3k3Yoo`00?7oo03d3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00k
Ool003aoocd3k3]oo`00?7oo03`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/lOol003aooc/3k3eoo`00?7oo03X3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3jcioo`00?7oo>P?/?Woo000lOol0>@?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00oOol003ao
ocP3k41oo`00?7oo03L3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k011Ool003aoocL3k45oo`00?7oo03H3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n]2Ool003aoocD3k4=oo`00?7oo03D3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/04=oo`00?7oo=0?/A7oo000lOol0<`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k015Ool003aooc83k4Ioo`00?7oo0383k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[AWoo000nOol_0na7Ool0045oo`0[0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/0B7oo0014OolW0na9Ool004Moo`0T0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/BGoo001:OolP0na:
Ool004eoo`0L0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0na;Ool0055ooaL3k4aoo`00E7oo01@3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[C7oo001GOol@0na=Ool005Yoo`0<0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[CWoo001MOol8
0na?Ool0061oo`050n`3j`?/0n/3k01?Ool00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .1 r
.675 .5 m
.55408 .66643 L
.35842 .60286 L
.35842 .39714 L
.55408 .33357 L
.675 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00HGoo00<3hP?S0n80
Cgoo001NOol60n9?Ool005]oo`030n83h`?R0083hP050n<3hP?R0n83h`1>Ool005Qoo`h3hTeoo`00
EGoo00<3hP?S0n800P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`1<Ool0059ooaD3hTaoo`00
D7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?RBgoo001=OolL
0n9:Ool004Yoo`050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`020n9:Ool004Moob<3hTUoo`00A7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`020n98Ool0041o
ob/3hTQoo`00@7oo0P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n9oo`16Ool0041oobd3hTIoo`00
@7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801P?S0n83hP?R0n<3hTEoo`00@7oo;P?RAGoo0010Ool20n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`14Ool0041ooc03hT=oo`00@7oo00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R@goo0010Oola0n92Ool0041oo`83hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hT5oo`00@7oo<P?R@Goo0010Ool01@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n800`?S0n83hP10Ool0041ooc@3hSmoo`00@7oo0P?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?R0n80?Woo0010Oole0n8nOol0041oo`050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP060n<3hP?R0n83h`?R?Goo0010Oolg0n8lOol0
041oo`83hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`0lOol0
041oocP3hS]oo`00@7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S0083hSaoo`00@7oo=`?R?7oo0010Ool20n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n8010?S0n83hP?R?Goo0010Oole0n8nOol0041oo`050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`0nOol0041ooc@3hSmoo`00@7oo0P?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00<3hgooOol0?Woo0010Oolb0n91Ool0041oo`050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP030n<3hWoo041oo`00@7oo<@?R@Woo0010Ool20n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP060n<3hP?R0n83h`?R@goo0010Ool`0n93Ool0041oo`050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S0083hTAoo`00@7oo;P?RAGoo0010Ool20n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP040n<3hP?R0n95Ool0041oobd3hTIoo`00@7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n8010?S
0n83hP?RAgoo0010Ool[0n98Ool0041oo`83hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3hgooOol0AWoo
0012OolX0n99Ool004Eoo`<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n800`?SOomoo`18Ool004Qoob43hTYoo`00C7oo0P?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?ROol0BWoo001?OolH
0n9<Ool0059oo`83hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?R0n80C7oo001E
OolA0n9=Ool005Qoo`83hP050n<3hP?R0n83h`030n800`?S0n83hP1>Ool005aoo`P3hTmoo`00Ggoo
00<3hP?S0n800P?RCgoo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo0000\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.2 1 0 r
.65 .5 m
.54635 .64266 L
.37865 .58817 L
.37865 .41183 L
.54635 .35734 L
.65 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol005moo`8Gh0036n1oogoo04moo`00Fgoo00PGh1_P5n0Kh1OP6n0Gh1_PD7oo001H
Ool35n001A_P5n0Gh1OP6n000aOPD7oo001EOol03aOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h01?Ool0055oo`056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh4ioo`00CWoo
01PKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n1=Ool004]oo`05
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP04eoo`00
Agoo020Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_PC7oo0013Ool25n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh1OP5n00Bgoo0013Ool09QOP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n1:
Ool004=oo`056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001Q_P5n0Gh1OP6n0Gh4Yoo`00@goo02LGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n00BGoo0013
Ool25n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00HKh1OP5n0Gh1_P5n18Ool004=oo`0Y5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh017Ool0
04=oo`056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh7ooOol0AGoo0013Ool0:QOP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh4Ioo`00@goo0QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000a_POomoo`13Ool004=oo`0/5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Aoo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n0011_P5n0G
h1OPA7oo0013Ool0;AOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh013Ool004=oo`8Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh49oo`00@goo02lGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP045oo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000QOP@Goo0013
Ool0<1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh41oo`00@goo0QOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000QOP?goo0013Ool0<1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh41oo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP@7oo
0013Ool0;aOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n00@Goo0013Ool25n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DK
h1OP5n0Gh1_P00<Gh0046n0Gh1OP5n12Ool004=oo`0]5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP04=oo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00@goo0013Ool0;1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n14Ool004=oo`8Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh7oo
Ool0@goo0013Ool0:QOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Ioo`00@goo00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n000a_P5n1oo`15Ool004=oo`0Y5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh017Ool004=oo`8Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001Q_P5n0Gh1OP6n0Gh4Qoo`00@goo02PGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Qoo`00@goo00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0025n19Ool004=oo`0V5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Yoo`00@goo0QOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0G
h1OP04]oo`00AGoo02<Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP04]oo`00B7oo0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh4aoo`00Bgoo01/Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n00CGoo001>Ool35n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh1OP5n1>Ool0055oo`0D5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4ioo`00E7oo0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h01?Ool005Moo`0<5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_PD7oo001JOol35n001A_P5n0Gh1OP6n00
DGoo001MOol01AOP6n0Gh1_P5n00DGoo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00001\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 1 0 r
.625 .5 m
.53863 .61888 L
.39887 .57347 L
.39887 .42653 L
.53863 .38112 L
.625 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00GWoo0coPDgoo001KOol6?n1COol005Uoo`8o
h005>n0oh3oP?n0kh002?n1BOol005Ioo`doh55oo`00Dgoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0o
h3oP?n0kh002?n1@Ool0051ooa@oh51oo`00CGoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h003?n001S_P?n0oh3oP>n0oh4moo`00Bgoo6coPCWoo0017Ool2?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001S_P?n0oh3oP>n0oh4eoo`00Agoo83oPCGoo0017
Ool01C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP
>n000coP00<kh7ooOol0BWoo0017OolR?n1;Ool004Moo`8oh005>n0oh3oP?n0kh003?n001C_P?n0o
h3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n1;Ool004Moob<oh4Yoo`00Agoo
00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P
00<oh004>n0oh3oP?n19Ool004MoobDoh4Qoo`00Agoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP
?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh003>n0oh3oP04Qoo`00Agoo9SoP
Agoo0017Ool01C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P008oh4Ioo`00Agoo:3oPAGoo0017Ool2?n001C_P?n0oh3oP
>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Hkh3oP
?n0oh3_P?n15Ool004MoobToh4Aoo`00Agoo00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n00
1C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n15Ool004MoobLoh4Io
o`00Agoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh016Ool004MoobHoh4Moo`00Agoo00Dkh3oP?n0oh3_P00<o
h005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h018Ool004Moob@oh4Uoo`00Agoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh003>n0oh7oo04Qoo`00Agoo8coPBWoo0017Ool01C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP
00<kh3oPOol0BWoo0017OolQ?n1<Ool004Moo`8oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n00
0coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh002?n1<Ool004Moob0oh4eoo`00Agoo00Dkh3oP
?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P008oh4io
o`00BGoo73oPCgoo001<Ool00coP>n0oh002?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<o
h004>n0oh3oP?n1?Ool004mooaDoh51oo`00DWoo00<oh3_P?n000SoP00Dkh3oP?n0oh3_P00<oh004
>n0oh3oP?n1AOol005Ioo``oh59oo`00FGoo00Dkh3oP?n0oh3_P00<oh003>n1oogoo051oo`00G7oo
1CoPDgoo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 1 0 r
.6 .5 m
.5309 .59511 L
.4191 .55878 L
.4191 .44122 L
.5309 .40489 L
.6 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo001LOol00f?P
In1Sh01DOol005Uoo`07Hn1Wh6?PIn1Sh6OPHn00Dgoo001FOol02V?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Dgoo001COol03V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1BOol0055oo`0AIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh01AOol004ioo`0EIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OP051oo`00BWoo01USh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh01@Ool004Yoo`0JIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh4moo`00BWoo01]Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00CWoo001:Ool076OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PCGoo001:Ool076?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPCGoo001:Ool07FOPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00C7oo001:Ool07V?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh4]oo`00
BWoo01mWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh01:Ool004Yoo`0OHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn00BWoo001:Ool086OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn19Ool004Yoo`0QHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P04Qoo`00BWoo
021Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PBGoo001:Ool07f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?P04Yoo`00BWoo01mWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh01:Ool004Yoo`0NHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPBgoo001:Ool07FOPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00C7oo001:Ool0
76?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPCGoo
001:Ool076OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PCGoo001:Ool06f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh01>Ool004Yoo`0JIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh4moo`00BWoo01USh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh01@Ool004Yoo`0IIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn00D7oo001<Ool05V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPDGoo001@Ool04FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00DWoo001COol0
3FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP05=oo`00EWoo00YWh6?PIn1Sh6OPHn1Wh6?PIn1Sh5=o
o`00FWoo00ESh6OPHn1Wh6?P05Aoo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo0000\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 .9 0 r
.575 .5 m
.52318 .57133 L
.43932 .54408 L
.43932 .45592 L
.52318 .42867 L
.575 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00Fgoo0gn0EWoo001HOol01gn0Of1oP7mPOh1oH7n005Eoo`00EGoo2Wn0
EGoo001BOol03Wn0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1DOol004iooa=oP5=oo`00CWoo01Ao
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPDWoo001>OolDOh1BOol004ioo`0E
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0055oo`00CWoo5Wn0D7oo001>
Ool05gn0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh00Cgoo001>OolG
Oh1?Ool004ioo`0HOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
CWoo001>OolIOh1=Ool004ioo`0HOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPCWoo001>OolGOh1?Ool004ioo`0GOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP01?Ool004iooaIoP51oo`00CWoo01EoP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh00DGoo001>OolDOh1BOol004ioo`0DOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH59oo`00CWoo4gn0Dgoo001@Ool047n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPE7oo001COol<Oh1EOol005Ioo`09Oh1oH7n0Of1oP7mPOh1oH7n005Eoo`00
FGoo1Gn0EWoo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 .6 0 r
.55 .5 m
.51545 .54755 L
.45955 .52939 L
.45955 .47061 L
.51545 .45245 L
.55 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo001JOol3OT1GOol005Ioo`9n@005OV1n
@7i0OT1nH01GOol0059oo`an@5Ioo`00DWoo00EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH01EOol0
059oo`en@5Eoo`00DWoo0Wi000EnH7i0OT1n@7iP00=n@004OV1n@7i0OT1DOol0059oo`mn@5=oo`00
DWoo00EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH002OT1COol0059ooa1n@59oo`00DWoo0Wi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH01COol0059oo`mn@5=oo`00DWoo00EnH7i0OT1n@7iP00=n
@006OV1n@7i0OT1nH7i0E7oo001BOol=OT1EOol0059oo`9n@005OV1n@7i0OT1nH003OT000giPOT1o
o`1EOol005Aoo`Yn@5Ioo`00F7oo0Wi000=nH7i0OT00Egoo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00001\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "The animation of the scaling transformation shows us the action of the \
group. Every time we reduce the scaling factor, the pentagon is reduced but \
keeps its shape, meaning that we create self-similar objects of the same \
type. This kind of symmetry transformation satisfies all the properties \
stated in properties ",
  ButtonBox["(i)",
    ButtonData:>"group properties",
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[Dash]",
    ButtonData:>"group properties",
    ButtonStyle->"Hyperlink"],
  ButtonBox["(iv)",
    ButtonData:>"group properties",
    ButtonStyle->"Hyperlink"],
  " of a group. The reader may verify this easily.\[ThickSpace]\[ThickSpace]\
\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->"self-similar objects"],

Cell["\<\
So far we discussed the essentials of group theory including Lie \
groups. The discussed topics are all relevant for the examination of \
differential equations. In the following section, we will discuss a related \
term, the so-called Lie algebra, representing the algebraic properties of a \
Lie group.\
\>", "Text",
  Evaluatable->False],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Algebra.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{695, 668},
WindowMargins->{{17, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->6,
PrintingPageRange->{9, 9},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Elements of Symmetry Analysis", FontSlant -> "Italic"]}],
         "Header"], Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Groups and Lie Groups"}, #]&)], FontSlant -> "Italic"], 
          "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Text"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1,
CounterBoxOptions->{CounterFunction:>Identity,
CounterData:>2},
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "1.1"->{
    Cell[1739, 51, 43, 1, 94, "ChapterLine",
      CellTags->"1.1"],
    Cell[1785, 54, 65, 1, 155, "Title",
      CellTags->"1.1"]},
  "general properties of a group"->{
    Cell[1853, 57, 1042, 21, 129, "Text",
      Evaluatable->False,
      CellTags->{"general properties of a group", "computer algebra"}]},
  "computer algebra"->{
    Cell[1853, 57, 1042, 21, 129, "Text",
      Evaluatable->False,
      CellTags->{"general properties of a group", "computer algebra"}]},
  "Groups and Lie Groups"->{
    Cell[2920, 82, 156, 7, 43, "Section",
      Evaluatable->False,
      CellTags->"Groups and Lie Groups"]},
  "group theory"->{
    Cell[3079, 91, 428, 8, 61, "Text",
      Evaluatable->False,
      CellTags->"group theory"]},
  "Groups"->{
    Cell[3532, 103, 133, 7, 41, "Subsection",
      Evaluatable->False,
      CellTags->"Groups"]},
  "Definition: Group"->{
    Cell[3908, 119, 72, 1, 33, "Definition",
      CellTags->"Definition: Group"]},
  "composition"->{
    Cell[3983, 122, 923, 25, 78, "Text",
      Evaluatable->False,
      CellTags->{"composition", "group multiplication", "group"}]},
  "group multiplication"->{
    Cell[3983, 122, 923, 25, 78, "Text",
      Evaluatable->False,
      CellTags->{"composition", "group multiplication", "group"}],
    Cell[87289, 2196, 699, 18, 84, "Text",
      Evaluatable->False,
      CellTags->{"group multiplication", "MatrixForm[]"}]},
  "group"->{
    Cell[3983, 122, 923, 25, 78, "Text",
      Evaluatable->False,
      CellTags->{"composition", "group multiplication", "group"}]},
  "closure relation"->{
    Cell[4909, 149, 198, 5, 20, "ListItem",
      Evaluatable->False,
      CellTags->{"closure relation", "group properties"}]},
  "group properties"->{
    Cell[4909, 149, 198, 5, 20, "ListItem",
      Evaluatable->False,
      CellTags->{"closure relation", "group properties"}]},
  "associativity"->{
    Cell[6032, 188, 170, 5, 20, "ListItem",
      Evaluatable->False,
      CellTags->"associativity"],
    Cell[88277, 2231, 215, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"associativity"],
    Cell[94874, 2481, 526, 19, 46, "Text",
      Evaluatable->False,
      CellTags->"associativity"]},
  "identity element"->{
    Cell[6919, 223, 177, 5, 20, "ListItem",
      Evaluatable->False,
      CellTags->"identity element"],
    Cell[90407, 2325, 723, 17, 61, "Text",
      Evaluatable->False,
      CellTags->{"identity element", "isomorphic"}]},
  "inverse element"->{
    Cell[7850, 261, 362, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"inverse element"],
    Cell[89101, 2269, 463, 13, 63, "Text",
      Evaluatable->False,
      CellTags->{"Inverse[]", "inverse element"}],
    Cell[94357, 2460, 359, 9, 44, "Text",
      Evaluatable->False,
      CellTags->"inverse element"]},
  "Abelian group"->{
    Cell[8484, 283, 1585, 36, 150, "Text",
      Evaluatable->False,
      CellTags->{"Abelian group", "multiplication table"}],
    Cell[13249, 431, 434, 12, 61, "Text",
      Evaluatable->False,
      CellTags->"Abelian group"],
    Cell[14521, 475, 1158, 22, 146, "Text",
      Evaluatable->False,
      CellTags->{"rotations", "Abelian group"}]},
  "multiplication table"->{
    Cell[8484, 283, 1585, 36, 150, "Text",
      Evaluatable->False,
      CellTags->{"Abelian group", "multiplication table"}],
    Cell[10834, 342, 644, 14, 78, "Text",
      Evaluatable->False,
      CellTags->{"multiplication", "multiplication table"}],
    Cell[12182, 389, 190, 4, 27, "Text",
      Evaluatable->False,
      CellTags->"multiplication table"]},
  "finite group"->{
    Cell[10072, 321, 558, 11, 78, "Text",
      Evaluatable->False,
      CellTags->{"finite group", "infinite group"}]},
  "infinite group"->{
    Cell[10072, 321, 558, 11, 78, "Text",
      Evaluatable->False,
      CellTags->{"finite group", "infinite group"}]},
  "multiplication"->{
    Cell[10834, 342, 644, 14, 78, "Text",
      Evaluatable->False,
      CellTags->{"multiplication", "multiplication table"}]},
  "group element"->{
    Cell[14211, 465, 307, 8, 44, "Text",
      Evaluatable->False,
      CellTags->"group element"]},
  "rotations"->{
    Cell[14521, 475, 1158, 22, 146, "Text",
      Evaluatable->False,
      CellTags->{"rotations", "Abelian group"}]},
  "non-commutative"->{
    Cell[15713, 501, 774, 16, 99, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
    Cell[29466, 919, 1109, 30, 112, "Text",
      Evaluatable->False,
      CellTags->"non-commutative"],
    Cell[77211, 1928, 512, 8, 78, "Text",
      Evaluatable->False,
      CellTags->"non-commutative"]},
  "Rotation[]"->{
    Cell[15713, 501, 774, 16, 99, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
    Cell[19640, 616, 293, 9, 46, "Text",
      Evaluatable->False,
      CellTags->"Rotation[]"],
    Cell[20290, 638, 341, 9, 48, "Text",
      Evaluatable->False,
      CellTags->"Rotation[]"]},
  "Geometry`Rotation`"->{
    Cell[15713, 501, 774, 16, 99, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}]},
  "polygon"->{
    Cell[15713, 501, 774, 16, 99, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
    Cell[117641, 3232, 447, 9, 61, "Text",
      Evaluatable->False,
      CellTags->{"polygon", "pentagon"}]},
  "display"->{
    Cell[16658, 525, 162, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"display"]},
  "hexagon"->{
    Cell[23673, 735, 1021, 26, 97, "Text",
      Evaluatable->False,
      CellTags->"hexagon"]},
  "RotationX[]"->{
    Cell[48920, 1307, 515, 15, 65, "Text",
      Evaluatable->False,
      CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}]},
  "RotationY[]"->{
    Cell[48920, 1307, 515, 15, 65, "Text",
      Evaluatable->False,
      CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}]},
  "RotationZ[]"->{
    Cell[48920, 1307, 515, 15, 65, "Text",
      Evaluatable->False,
      CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}]},
  "isomorphism"->{
    Cell[77726, 1938, 164, 4, 27, "Text",
      CellTags->"isomorphism"],
    Cell[97006, 2551, 521, 8, 61, "Text",
      Evaluatable->False,
      CellTags->{"isomorphism", "homomorphism"}]},
  "Isomorphism"->{
    Cell[77927, 1947, 88, 2, 41, "Subsection",
      Evaluatable->False,
      CellTags->"Isomorphism"]},
  "Definition: Isomorphic groups"->{
    Cell[78393, 1960, 96, 1, 33, "Definition",
      CellTags->"Definition: Isomorphic groups"]},
  "homomorphism"->{
    Cell[79205, 1983, 556, 10, 78, "Text",
      Evaluatable->False,
      CellTags->{"homomorphism", "isomorphic group"}],
    Cell[91133, 2344, 833, 22, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}],
    Cell[97006, 2551, 521, 8, 61, "Text",
      Evaluatable->False,
      CellTags->{"isomorphism", "homomorphism"}]},
  "isomorphic group"->{
    Cell[79205, 1983, 556, 10, 78, "Text",
      Evaluatable->False,
      CellTags->{"homomorphism", "isomorphic group"}]},
  "Lie Groups"->{
    Cell[79798, 1998, 113, 5, 41, "Subsection",
      CellTags->"Lie Groups"]},
  "manifold"->{
    Cell[79914, 2005, 1375, 23, 180, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}],
    Cell[81375, 2033, 533, 12, 61, "Text",
      CellTags->"manifold"]},
  "calculus"->{
    Cell[79914, 2005, 1375, 23, 180, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "partial differentiation"->{
    Cell[79914, 2005, 1375, 23, 180, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "algebra"->{
    Cell[79914, 2005, 1375, 23, 180, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "topology"->{
    Cell[79914, 2005, 1375, 23, 180, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "Lie group"->{
    Cell[79914, 2005, 1375, 23, 180, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "Definition: Lie group"->{
    Cell[81292, 2030, 80, 1, 33, "Definition",
      CellTags->"Definition: Lie group"]},
  "addition"->{
    Cell[82612, 2064, 1483, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "inverse"->{
    Cell[82612, 2064, 1483, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "N[]"->{
    Cell[82612, 2064, 1483, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "rational numbers"->{
    Cell[82612, 2064, 1483, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "special orthogonal group"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "SO(3)"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "GL(n"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "\\[DoubleStruckCapitalR])"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "SL(n"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "continuous matrix group"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "unimodular group"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "linear group"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "vector space"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}],
    Cell[91133, 2344, 833, 22, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "\[DoubleStruckCapitalR])"->{
    Cell[84129, 2098, 1319, 34, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "matrix group"->{
    Cell[85451, 2134, 171, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"matrix group"]},
  "representation"->{
    Cell[86315, 2167, 887, 23, 95, "Text",
      Evaluatable->False,
      CellTags->{"representation", "group axioms"}],
    Cell[91133, 2344, 833, 22, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "group axioms"->{
    Cell[86315, 2167, 887, 23, 95, "Text",
      Evaluatable->False,
      CellTags->{"representation", "group axioms"}]},
  "MatrixForm[]"->{
    Cell[87289, 2196, 699, 18, 84, "Text",
      Evaluatable->False,
      CellTags->{"group multiplication", "MatrixForm[]"}]},
  "Inverse[]"->{
    Cell[89101, 2269, 463, 13, 63, "Text",
      Evaluatable->False,
      CellTags->{"Inverse[]", "inverse element"}]},
  "isomorphic"->{
    Cell[90407, 2325, 723, 17, 61, "Text",
      Evaluatable->False,
      CellTags->{"identity element", "isomorphic"}],
    Cell[95739, 2522, 1264, 27, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "group representation", "isomorphic", 
        "representation of a Lie group"}]},
  "invertible linear transformation"->{
    Cell[91133, 2344, 833, 22, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "infinite dimensional vector space"->{
    Cell[91133, 2344, 833, 22, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "translation"->{
    Cell[92064, 2371, 584, 16, 44, "Text",
      Evaluatable->False,
      CellTags->"translation"],
    Cell[97530, 2561, 375, 8, 61, "Text",
      Evaluatable->False,
      CellTags->"translation"]},
  "shift operator"->{
    Cell[92783, 2394, 487, 19, 44, "Text",
      Evaluatable->False,
      CellTags->"shift operator"]},
  "group representation"->{
    Cell[95739, 2522, 1264, 27, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "group representation", "isomorphic", 
        "representation of a Lie group"}]},
  "representation of a Lie group"->{
    Cell[95739, 2522, 1264, 27, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "group representation", "isomorphic", 
        "representation of a Lie group"}]},
  "Plot[]"->{
    Cell[116260, 3190, 596, 18, 63, "Text",
      CellTags->"Plot[]"]},
  "coordinates"->{
    Cell[116890, 3212, 564, 12, 78, "Text",
      Evaluatable->False,
      CellTags->{"coordinates", "scaling group"}]},
  "scaling group"->{
    Cell[116890, 3212, 564, 12, 78, "Text",
      Evaluatable->False,
      CellTags->{"coordinates", "scaling group"}]},
  "pentagon"->{
    Cell[117641, 3232, 447, 9, 61, "Text",
      Evaluatable->False,
      CellTags->{"polygon", "pentagon"}]},
  "Do[]"->{
    Cell[118237, 3248, 637, 13, 80, "Text",
      Evaluatable->False,
      CellTags->{"Do[]", "scaling factor"}]},
  "scaling factor"->{
    Cell[118237, 3248, 637, 13, 80, "Text",
      Evaluatable->False,
      CellTags->{"Do[]", "scaling factor"}]},
  "self-similar objects"->{
    Cell[396355, 7539, 782, 19, 78, "Text",
      Evaluatable->False,
      CellTags->"self-similar objects"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"1.1", 399639, 7631},
  {"general properties of a group", 399810, 7636},
  {"computer algebra", 399975, 7640},
  {"Groups and Lie Groups", 400145, 7644},
  {"group theory", 400276, 7648},
  {"Groups", 400389, 7652},
  {"Definition: Group", 400514, 7656},
  {"composition", 400617, 7659},
  {"group multiplication", 400780, 7663},
  {"group", 401056, 7670},
  {"closure relation", 401215, 7674},
  {"group properties", 401369, 7678},
  {"associativity", 401520, 7682},
  {"identity element", 401854, 7692},
  {"inverse element", 402107, 7699},
  {"Abelian group", 402456, 7709},
  {"multiplication table", 402835, 7719},
  {"finite group", 403222, 7729},
  {"infinite group", 403366, 7733},
  {"multiplication", 403510, 7737},
  {"group element", 403661, 7741},
  {"rotations", 403780, 7745},
  {"non-commutative", 403923, 7749},
  {"Rotation[]", 404312, 7760},
  {"Geometry`Rotation`", 404695, 7771},
  {"polygon", 404871, 7776},
  {"display", 405158, 7784},
  {"hexagon", 405269, 7788},
  {"RotationX[]", 405386, 7792},
  {"RotationY[]", 405539, 7796},
  {"RotationZ[]", 405692, 7800},
  {"isomorphism", 405845, 7804},
  {"Isomorphism", 406057, 7810},
  {"Definition: Isomorphic groups", 406200, 7814},
  {"homomorphism", 406318, 7817},
  {"isomorphic group", 406812, 7829},
  {"Lie Groups", 406955, 7833},
  {"manifold", 407051, 7836},
  {"calculus", 407307, 7843},
  {"partial differentiation", 407506, 7848},
  {"algebra", 407689, 7853},
  {"topology", 407873, 7858},
  {"Lie group", 408058, 7863},
  {"Definition: Lie group", 408255, 7868},
  {"addition", 408361, 7871},
  {"inverse", 408517, 7875},
  {"N[]", 408669, 7879},
  {"rational numbers", 408834, 7883},
  {"special orthogonal group", 409007, 7887},
  {"SO(3)", 409333, 7895},
  {"GL(n", 409658, 7903},
  {"\\[DoubleStruckCapitalR])", 410004, 7911},
  {"SL(n", 410329, 7919},
  {"continuous matrix group", 410673, 7927},
  {"unimodular group", 411010, 7935},
  {"linear group", 411343, 7943},
  {"vector space", 411676, 7951},
  {"\[DoubleStruckCapitalR])", 412248, 7964},
  {"matrix group", 412581, 7972},
  {"representation", 412705, 7976},
  {"group axioms", 413075, 7985},
  {"MatrixForm[]", 413218, 7989},
  {"Inverse[]", 413364, 7993},
  {"isomorphic", 413503, 7997},
  {"invertible linear transformation", 413843, 8006},
  {"infinite dimensional vector space", 414112, 8012},
  {"translation", 414359, 8018},
  {"shift operator", 414583, 8025},
  {"group representation", 414716, 8029},
  {"representation of a Lie group", 414931, 8035},
  {"Plot[]", 415123, 8041},
  {"coordinates", 415214, 8044},
  {"scaling group", 415357, 8048},
  {"pentagon", 415495, 8052},
  {"Do[]", 415619, 8056},
  {"scaling factor", 415757, 8060},
  {"self-similar objects", 415901, 8064}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 43, 1, 94, "ChapterLine",
  CellTags->"1.1"],
Cell[1785, 54, 65, 1, 155, "Title",
  CellTags->"1.1"],
Cell[1853, 57, 1042, 21, 129, "Text",
  Evaluatable->False,
  CellTags->{"general properties of a group", "computer algebra"}],

Cell[CellGroupData[{
Cell[2920, 82, 156, 7, 43, "Section",
  Evaluatable->False,
  CellTags->"Groups and Lie Groups"],
Cell[3079, 91, 428, 8, 61, "Text",
  Evaluatable->False,
  CellTags->"group theory"],

Cell[CellGroupData[{
Cell[3532, 103, 133, 7, 41, "Subsection",
  Evaluatable->False,
  CellTags->"Groups"],
Cell[3668, 112, 237, 5, 44, "Text",
  Evaluatable->False],
Cell[3908, 119, 72, 1, 33, "Definition",
  CellTags->"Definition: Group"],
Cell[3983, 122, 923, 25, 78, "Text",
  Evaluatable->False,
  CellTags->{"composition", "group multiplication", "group"}],
Cell[4909, 149, 198, 5, 20, "ListItem",
  Evaluatable->False,
  CellTags->{"closure relation", "group properties"}],
Cell[5110, 156, 203, 6, 27, "Text",
  Evaluatable->False],
Cell[5316, 164, 713, 22, 24, "DisplayFormula",
  Evaluatable->False],
Cell[6032, 188, 170, 5, 20, "ListItem",
  Evaluatable->False,
  CellTags->"associativity"],
Cell[6205, 195, 277, 10, 28, "Text",
  Evaluatable->False],
Cell[6485, 207, 317, 8, 23, "DisplayFormula",
  Evaluatable->False],
Cell[6805, 217, 111, 4, 27, "Text",
  Evaluatable->False],
Cell[6919, 223, 177, 5, 20, "ListItem",
  Evaluatable->False,
  CellTags->"identity element"],
Cell[7099, 230, 219, 6, 27, "Text",
  Evaluatable->False],
Cell[7321, 238, 232, 7, 22, "DisplayFormula",
  Evaluatable->False],
Cell[7556, 247, 153, 6, 27, "Text",
  Evaluatable->False],
Cell[7712, 255, 135, 4, 20, "ListItem",
  Evaluatable->False],
Cell[7850, 261, 362, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"inverse element"],
Cell[8215, 274, 266, 7, 22, "DisplayFormula",
  Evaluatable->False],
Cell[8484, 283, 1585, 36, 150, "Text",
  Evaluatable->False,
  CellTags->{"Abelian group", "multiplication table"}],
Cell[10072, 321, 558, 11, 78, "Text",
  Evaluatable->False,
  CellTags->{"finite group", "infinite group"}],
Cell[10633, 334, 167, 4, 44, "Text",
  Evaluatable->False],
Cell[10803, 340, 28, 0, 29, "Example"],
Cell[10834, 342, 644, 14, 78, "Text",
  Evaluatable->False,
  CellTags->{"multiplication", "multiplication table"}],
Cell[11481, 358, 77, 2, 22, "Input"],
Cell[11561, 362, 177, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11763, 372, 234, 6, 22, "Input"],
Cell[12000, 380, 167, 6, 32, "Output"]
}, Open  ]],
Cell[12182, 389, 190, 4, 27, "Text",
  Evaluatable->False,
  CellTags->"multiplication table"],
Cell[12375, 395, 28, 0, 29, "Example"],
Cell[12406, 397, 111, 4, 27, "Text",
  Evaluatable->False],
Cell[12520, 403, 89, 2, 22, "Input"],
Cell[12612, 407, 79, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12716, 412, 242, 6, 37, "Input"],
Cell[12961, 420, 273, 8, 56, "Output"]
}, Open  ]],
Cell[13249, 431, 434, 12, 61, "Text",
  Evaluatable->False,
  CellTags->"Abelian group"],

Cell[CellGroupData[{
Cell[13708, 447, 212, 5, 22, "Input"],
Cell[13923, 454, 273, 8, 56, "Output"]
}, Open  ]],
Cell[14211, 465, 307, 8, 44, "Text",
  Evaluatable->False,
  CellTags->"group element"],
Cell[14521, 475, 1158, 22, 146, "Text",
  Evaluatable->False,
  CellTags->{"rotations", "Abelian group"}],
Cell[15682, 499, 28, 0, 29, "Example"],
Cell[15713, 501, 774, 16, 99, "Text",
  Evaluatable->False,
  CellTags->{
  "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
Cell[16490, 519, 165, 4, 53, "Input"],
Cell[16658, 525, 162, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"display"],

Cell[CellGroupData[{
Cell[16845, 534, 146, 3, 37, "Input"],
Cell[16994, 539, 2631, 74, 116, 652, 43, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[19640, 616, 293, 9, 46, "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],
Cell[19936, 627, 84, 2, 22, "Input"],
Cell[20023, 631, 264, 5, 82, "Input"],
Cell[20290, 638, 341, 9, 48, "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],

Cell[CellGroupData[{
Cell[20656, 651, 169, 4, 52, "Input"],
Cell[20828, 657, 2830, 75, 137, 659, 43, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[23673, 735, 1021, 26, 97, "Text",
  Evaluatable->False,
  CellTags->"hexagon"],

Cell[CellGroupData[{
Cell[24719, 765, 458, 9, 158, "Input"],
Cell[25180, 776, 4271, 140, 116, 1479, 100, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[29466, 919, 1109, 30, 112, "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],
Cell[30578, 951, 145, 3, 53, "Input"],
Cell[30726, 956, 175, 6, 27, "Text"],

Cell[CellGroupData[{
Cell[30926, 966, 137, 2, 37, "Input"],
Cell[31066, 970, 17839, 334, 151, 1580, 127, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[48920, 1307, 515, 15, 65, "Text",
  Evaluatable->False,
  CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}],
Cell[49438, 1324, 2455, 40, 502, "Input"],
Cell[51896, 1366, 257, 9, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[52178, 1379, 513, 10, 188, "Input"],
Cell[52694, 1391, 24502, 534, 151, 3406, 268, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[77211, 1928, 512, 8, 78, "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],
Cell[77726, 1938, 164, 4, 27, "Text",
  CellTags->"isomorphism"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77927, 1947, 88, 2, 41, "Subsection",
  Evaluatable->False,
  CellTags->"Isomorphism"],
Cell[78018, 1951, 372, 7, 61, "Text",
  Evaluatable->False],
Cell[78393, 1960, 96, 1, 33, "Definition",
  CellTags->"Definition: Isomorphic groups"],
Cell[78492, 1963, 710, 18, 45, "Text"],
Cell[79205, 1983, 556, 10, 78, "Text",
  Evaluatable->False,
  CellTags->{"homomorphism", "isomorphic group"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[79798, 1998, 113, 5, 41, "Subsection",
  CellTags->"Lie Groups"],
Cell[79914, 2005, 1375, 23, 180, "Text",
  CellTags->{
  "manifold", "calculus", "partial differentiation", "algebra", "topology", 
    "Lie group"}],
Cell[81292, 2030, 80, 1, 33, "Definition",
  CellTags->"Definition: Lie group"],
Cell[81375, 2033, 533, 12, 61, "Text",
  CellTags->"manifold"],
Cell[81911, 2047, 667, 13, 78, "Text",
  Evaluatable->False],
Cell[82581, 2062, 28, 0, 29, "Example"],
Cell[82612, 2064, 1483, 30, 131, "Text",
  Evaluatable->False,
  CellTags->{"addition", "inverse", "N[]", "rational numbers"}],
Cell[84098, 2096, 28, 0, 29, "Example"],
Cell[84129, 2098, 1319, 34, 95, "Text",
  Evaluatable->False,
  CellTags->{
  "special orthogonal group", "SO(3)", "GL(n", "\\[DoubleStruckCapitalR])", 
    "SL(n", "continuous matrix group", "unimodular group", "linear group", 
    "vector space", "\[DoubleStruckCapitalR])"}],
Cell[85451, 2134, 171, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"matrix group"],
Cell[85625, 2141, 244, 7, 33, "DisplayFormula"],
Cell[85872, 2150, 303, 10, 27, "Text",
  Evaluatable->False],
Cell[86178, 2162, 134, 3, 23, "DisplayFormula",
  Evaluatable->False],
Cell[86315, 2167, 887, 23, 95, "Text",
  Evaluatable->False,
  CellTags->{"representation", "group axioms"}],
Cell[87205, 2192, 81, 2, 22, "Input"],
Cell[87289, 2196, 699, 18, 84, "Text",
  Evaluatable->False,
  CellTags->{"group multiplication", "MatrixForm[]"}],

Cell[CellGroupData[{
Cell[88013, 2218, 79, 2, 22, "Input"],
Cell[88095, 2222, 167, 6, 32, "Output"]
}, Open  ]],
Cell[88277, 2231, 215, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{
Cell[88517, 2241, 92, 2, 22, "Input"],
Cell[88612, 2245, 171, 6, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88820, 2256, 92, 2, 22, "Input"],
Cell[88915, 2260, 171, 6, 32, "Output"]
}, Open  ]],
Cell[89101, 2269, 463, 13, 63, "Text",
  Evaluatable->False,
  CellTags->{"Inverse[]", "inverse element"}],

Cell[CellGroupData[{
Cell[89589, 2286, 92, 2, 22, "Input"],
Cell[89684, 2290, 164, 6, 32, "Output"]
}, Open  ]],
Cell[89863, 2299, 242, 9, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[90130, 2312, 98, 2, 22, "Input"],
Cell[90231, 2316, 161, 6, 32, "Output"]
}, Open  ]],
Cell[90407, 2325, 723, 17, 61, "Text",
  Evaluatable->False,
  CellTags->{"identity element", "isomorphic"}],
Cell[91133, 2344, 833, 22, 78, "Text",
  Evaluatable->False,
  CellTags->{
  "vector space", "homomorphism", "invertible linear transformation", 
    "representation", "infinite dimensional vector space"}],
Cell[91969, 2368, 92, 1, 29, "Example"],
Cell[92064, 2371, 584, 16, 44, "Text",
  Evaluatable->False,
  CellTags->"translation"],
Cell[92651, 2389, 129, 3, 22, "DisplayFormula",
  Evaluatable->False],
Cell[92783, 2394, 487, 19, 44, "Text",
  Evaluatable->False,
  CellTags->"shift operator"],
Cell[93273, 2415, 66, 1, 23, "Input"],
Cell[93342, 2418, 868, 30, 78, "Text"],

Cell[CellGroupData[{
Cell[94235, 2452, 66, 2, 22, "Input"],
Cell[94304, 2456, 38, 1, 23, "Output"]
}, Open  ]],
Cell[94357, 2460, 359, 9, 44, "Text",
  Evaluatable->False,
  CellTags->"inverse element"],

Cell[CellGroupData[{
Cell[94741, 2473, 77, 2, 22, "Input"],
Cell[94821, 2477, 38, 1, 23, "Output"]
}, Open  ]],
Cell[94874, 2481, 526, 19, 46, "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{
Cell[95425, 2504, 78, 2, 22, "Input"],
Cell[95506, 2508, 50, 1, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[95593, 2514, 78, 2, 22, "Input"],
Cell[95674, 2518, 50, 1, 23, "Output"]
}, Open  ]],
Cell[95739, 2522, 1264, 27, 112, "Text",
  Evaluatable->False,
  CellTags->{
  "group representation", "isomorphic", "representation of a Lie group"}],
Cell[97006, 2551, 521, 8, 61, "Text",
  Evaluatable->False,
  CellTags->{"isomorphism", "homomorphism"}],
Cell[97530, 2561, 375, 8, 61, "Text",
  Evaluatable->False,
  CellTags->"translation"],
Cell[97908, 2571, 28, 0, 29, "Example"],
Cell[97939, 2573, 1275, 42, 78, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[99239, 2619, 258, 5, 67, "Input"],
Cell[99500, 2626, 16745, 561, 151, 7445, 442, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[116260, 3190, 596, 18, 63, "Text",
  CellTags->"Plot[]"],
Cell[116859, 3210, 28, 0, 29, "Example"],
Cell[116890, 3212, 564, 12, 78, "Text",
  Evaluatable->False,
  CellTags->{"coordinates", "scaling group"}],
Cell[117457, 3226, 181, 4, 52, "Input"],
Cell[117641, 3232, 447, 9, 61, "Text",
  Evaluatable->False,
  CellTags->{"polygon", "pentagon"}],
Cell[118091, 3243, 143, 3, 53, "Input"],
Cell[118237, 3248, 637, 13, 80, "Text",
  Evaluatable->False,
  CellTags->{"Do[]", "scaling factor"}],

Cell[CellGroupData[{
Cell[118899, 3265, 236, 5, 67, "Input"],

Cell[CellGroupData[{
Cell[119160, 3274, 3173, 83, 153, 644, 44, "GraphicsData", "PostScript", \
"Graphics"],
Cell[122336, 3359, 49967, 659, 152, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[172306, 4020, 24078, 340, 152, 647, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[196387, 4362, 21897, 313, 151, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[218287, 4677, 36033, 487, 151, 647, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[254323, 5166, 17662, 260, 151, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[271988, 5428, 28555, 395, 152, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[300546, 5825, 14106, 216, 152, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[314655, 6043, 12280, 194, 152, 647, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[326938, 6239, 18549, 271, 151, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[345490, 6512, 2954, 79, 152, 648, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[348447, 6593, 13223, 205, 152, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[361673, 6800, 6914, 128, 152, 643, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[368590, 6930, 5881, 115, 151, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[374474, 7047, 7296, 132, 152, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[381773, 7181, 4228, 94, 152, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[386004, 7277, 4593, 99, 152, 643, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[390600, 7378, 3070, 80, 152, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[393673, 7460, 2655, 75, 152, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False]
}, Closed]]
}, Open  ]],
Cell[396355, 7539, 782, 19, 78, "Text",
  Evaluatable->False,
  CellTags->"self-similar objects"],
Cell[397140, 7560, 350, 7, 61, "Text",
  Evaluatable->False],
Cell[397493, 7569, 147, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

