(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    390054,      14615]*)
(*NotebookOutlinePosition[    395953,      14788]*)
(*  CellTagsIndexPosition[    395128,      14763]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.7 The Plane Jet", "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"The plane jet"],

Cell[TextData[{
  "The plane jet is an example for ",
  ButtonBox["Prandtl's boundary layer equations.",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  " We consider the steady two-dimensional motion of an incompressible \
viscous fluid due to a jet issuing from a long narrow orifice. We use \
Cartesian coordinates in the plane of motion. The origin of our coordinate \
system is located in the orifice and the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis lies in the plane of symmetry of the jet. The velocities in the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " directions are denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ", respectively. If we assume that the Prandtl boundary layer equations \
give a sufficiently good approximation and that the pressure is a constant, \
then the equations of the stationary problem read "
}], "Text",
  Evaluatable->False,
  CellTags->{
  "plane jet", "Prandtl's boundary-layer equations", 
    "incompressible viscous fluid"}],

Cell[BoxData[
    \(TraditionalForm\`\(u\_x + v\_y = 0, \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\ u\_x\  + \ v\ u\_y\  = \ \[Eta]\ \(u\_\(y, y\) . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notation, we find"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(jet = {
        u[x, y]\ \[PartialD]\_x u[x, y] + v[x, y]\ \[PartialD]\_y u[x, y] == 
          \[Eta]\ \[PartialD]\_{y, 2}u[x, y], 
        \[PartialD]\_x u[x, y] + \[PartialD]\_y v[x, y] == 0}; 
    jet // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\ u\_x + v\ u\_y - \[Eta]\ u\_\(y, y\) == 0\)},
          {\(u\_x + v\_y == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[Eta] is the kinematic viscosity. The equations of motion are \
accompanied with the boundary conditions"], "Text",
  Evaluatable->False,
  CellTags->"kinematic viscosity"],

Cell[CellGroupData[{

Cell[BoxData[
    \(bound = {\[PartialD]\_y u[x, y] == 0, v[x, y] == 0} /. y \[Rule] 0\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, 0\), "]"}], "==", "0"}], 
        ",", \(v[x, 0] == 0\)}], "}"}]], "Output"]
}, Open  ]],

Cell["and the asymptotic behavior", "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],

Cell["asympt = {u[x,y]->0 /; y->Infinity}", "Input",
  PageWidth->Infinity,
  Evaluatable->False],

Cell[TextData[{
  "An additional relation for the total ",
  StyleBox["x-",
    FontSlant->"Italic"],
  "component of the fluid momentum must be satisfied"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(M = 
      2\ \[Rho]\ 
          \(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\( u[x, y]\^2\) 
              \[DifferentialD]y\) == constant; \)\)], "Input"],

Cell[TextData[{
  "This sort of model was first discussed by ",
  ButtonBox["Schlichting",
    ButtonData:>{"Literat.nb", "Schl-33"},
    ButtonStyle->"Hyperlink"],
  " in 1933. We will use this model to discuss the analytic solution by means \
of a symmetry analysis. First, we transform ",
  ButtonBox["Prandtl",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[CloseCurlyQuote]",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["s boundary layer equations",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  " to a single equation by introducing the stream function representation:"
}], "Text",
  Evaluatable->False,
  CellTags->{"Schlichting", "stream function"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(stream = {
        u \[Rule] Function[{x, y}, \[PartialD]\_y \[CapitalPsi][x, y]], 
        v \[Rule] Function[{x, y}, \(-\[PartialD]\_x \[CapitalPsi][x, y]\)]}
        \)], "Input"],

Cell[BoxData[
    \({u \[Rule] Function[{x, y}, \[PartialD]\_y \[CapitalPsi][x, y]], 
      v \[Rule] Function[{x, y}, \(-\[PartialD]\_x \[CapitalPsi][x, y]\)]}
      \)], "Output"]
}, Open  ]],

Cell["Applying this transformation to the jet equations, we find", "Text",
  Evaluatable->False,
  CellTags->"jet equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sjet = jet /. stream; sjet // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\[CapitalPsi]\_y\ \[CapitalPsi]\_\(x, y\) - 
                \[CapitalPsi]\_x\ \[CapitalPsi]\_\(y, y\) - 
                \[Eta]\ \[CapitalPsi]\_\(y, y, y\) == 0\)},
          {\(True == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"The original two equations reduce to a single equation for the stream \
function \[CapitalPsi] which is a non-linear partial differential equation of \
third order:"], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(jet = sjet\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{
              SuperscriptBox["\[CapitalPsi]", 
                TagBox[\((0, 2)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, y\), "]"}]}], " ", 
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}], "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((1, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}]}], "==", 
      RowBox[{"\[Eta]", " ", 
        RowBox[{
          SuperscriptBox["\[CapitalPsi]", 
            TagBox[\((0, 3)\),
              Derivative],
            MultilineFunction->None], "[", \(x, y\), "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We determine the symmetries of this equation by applying the function ",
  StyleBox["Infinitesimals[]", "MmaText"]
}], "Text",
  Evaluatable->False,
  CellTags->"Infinitesimals[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(symm = Infinitesimals[jet, \[CapitalPsi], {x, y}, {\[Eta]}]; 
    symm // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1 + k2\ \[CapitalPsi]\)},
          {\(\[Xi]\_1 == k3 + k4\ x\)},
          {\(\[Xi]\_2 == \((\(-k2\) + k4)\)\ y + \[ScriptCapitalF]\_1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k1, 
            Times[ k2, \[CapitalPsi]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k3, 
            Times[ k4, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Plus[ 
                Times[ -1, k2], k4], y], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a four-parameter group allowing translations and scalings as \
symmetries. Let us first discuss the translation symmetries and afterward use \
the scaling symmetry in our calculations. The related reduction of the \
original PDE follows by selecting the subgroups with ",
  StyleBox["k3=1", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["free[1][x]=c", "MmaText",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k1=1", "MmaText",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, y, \[CapitalPsi]], \(xi[2]\)[x, y, \[CapitalPsi]]}, {
              \(phi[1]\)[x, y, \[CapitalPsi]]}} /. symm\) /. {k1 \[Rule] 1, 
          k2 \[Rule] 0, k3 \[Rule] 1, k4 \[Rule] 0, \(free[1]\)[x] \[Rule] c}
          \)], "Input"],

Cell[BoxData[
    \({{1, c}, {1}}\)], "Output"]
}, Open  ]],

Cell["The reduction follows by", "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1 = 
      LieReduction[jet, {\[CapitalPsi]}, {x, y}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-c\)\ x + y - \[Zeta]\_1 == 0\)},
          {\(\(-x\) + \[CapitalPsi] - F\_1 == 0\)},
          {
            \(\(-F1\_\(\[Zeta]\_1, \[Zeta]\_1\)\) - 
                \[Eta]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The solution of the reduced equation follows by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ssol = 
      DSolve[red1\[LeftDoubleBracket]3\[RightDoubleBracket], F1, zeta1]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(-\(#1\/\[Eta]\)\)\ \[Eta]\^2\ C[1] + C[2] + C[3]\ #1&)\)}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where #1 represents the variable ",
  StyleBox["zeta",
    FontSlant->"Italic"],
  "1. The similarity solution in the original variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is "
}], "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      Flatten[Solve[
          Flatten[red1\[LeftDoubleBracket]2\[RightDoubleBracket] /. ssol], 
          \[CapitalPsi]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\[CapitalPsi] \[Rule] 
        x + E\^\(-\(\(\(-c\)\ x + y\)\/\[Eta]\)\)\ \[Eta]\^2\ C[1] + C[2] + 
          \((\(-c\)\ x + y)\)\ C[3]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This solution contains three constants of integration ",
  StyleBox["C[i]",
    FontSlant->"Italic"],
  ", ",
  StyleBox["i ",
    FontSlant->"Italic"],
  "= 1, 2, 3. The constants must be chosen in such a way that the boundary \
conditions are satisfied. The first boundary condition requires"
}], "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
        \[PartialD]\_{y, 2}\((\[CapitalPsi] /. sol)\) /. y \[Rule] 0] == 0
      \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(E\^\(\(c\ x\)\/\[Eta]\)\ C[1] == 0\)], "Output"]
}, Open  ]],

Cell["which can only be satisfied by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule = {C[1] \[Rule] 0}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({C[1] \[Rule] 0}\)], "Output"]
}, Open  ]],

Cell["The second boundary condition requires", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
          \[PartialD]\_{x, 1}\((\[CapitalPsi] /. sol)\) /. y \[Rule] 0] == 
        0 /. rule\)], "Input"],

Cell[BoxData[
    \(1 - c\ C[3] == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which allows a special choice ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[3]=1/",
  StyleBox["c",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[rule, C[3] \[Rule] 1\/c]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({C[1] \[Rule] 0, C[3] \[Rule] 1\/c}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Using the asymptotic behavior of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " results in "
}], "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\[PartialD]\_{y, 1}\((\[CapitalPsi] /. sol)\) /. rule]\)], 
  "Input"],

Cell[BoxData[
    \(1\/c\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the requirement that ",
  Cell[BoxData[
      \(TraditionalForm\`u \[Rule] 0\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`y \[Rule] \[Infinity]\)]],
  " can only be satisfied if we set ",
  Cell[BoxData[
      \(TraditionalForm\`c \[Rule] \[Infinity]\)]],
  ". In conclusion, the symmetry of translation is not compatible with the \
boundary conditions."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The second type of symmetry under which the third-order PDE is invariant \
is given by a scaling. The related subgroup is extracted by setting ",
  StyleBox["k2=c",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k4=1",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, y, \[CapitalPsi]], \(xi[2]\)[x, y, \[CapitalPsi]]}, {
              \(phi[1]\)[x, y, \[CapitalPsi]]}} /. symm\) /. {k1 \[Rule] 0, 
          k2 \[Rule] c, k3 \[Rule] 0, k4 \[Rule] 1, \(free[1]\)[x] \[Rule] 0}
          \)], "Input"],

Cell[BoxData[
    \({{x, \((1 - c)\)\ y}, {c\ \[CapitalPsi]}}\)], "Output"]
}, Open  ]],

Cell["The similarity reduction for the scaling group follows by", "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red2 = 
      LieReduction[jet, {\[CapitalPsi]}, {x, y}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red2]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x\^\(\(-1\) + c\)\ y - \[Zeta]\_1 == 0\)},
          {\(x\^\(-c\)\ \[CapitalPsi] - F\_1 == 0\)},
          {
            \(y\^\(-\(\(4\ c\)\/\(\(-1\) + c\)\)\)\ 
                \[Zeta]\_1\%\(\(4\ c\)\/\(\(-1\) + c\)\)\ 
                \((\(-\((F\_1)\)\_\[Zeta]\_1\%2\) + 
                    2\ c\ \((F\_1)\)\_\[Zeta]\_1\%2 - 
                    c\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                    \[Eta]\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, 
                        \[Zeta]\_1\))\)\n\t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The left-hand side of the equation is without any common \
coefficients\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq2\  = \ 
      red2\[LeftDoubleBracket]3, 1, 1\[RightDoubleBracket]/
        \((y\^\(-\(\(4\ c\)\/\(\(-1\) + c\)\)\)\ 
            zeta1\^\(\(4\ c\)\/\(\(-1\) + c\)\))\); 
    LTF[eq2] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\((F\_1)\)\_\[Zeta]\_1\%2\) + 
                2\ c\ \((F\_1)\)\_\[Zeta]\_1\%2 - 
                c\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                \[Eta]\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 
              0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This third-order ODE is not solved by ",
  StyleBox["DSolve[]", "MmaText"],
  ". However, a first integration with respect to ",
  StyleBox["zeta1",
    FontSlant->"Italic"],
  " shows us that the equation is integrable if we choose a special value for \
",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ". If we set ",
  Cell[BoxData[
      \(TraditionalForm\`c \[Rule] 1/3\)]],
  ", we get a second-order ODE which is equal to a first constant of \
integration:"
}], "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((eq2 /. c \[Rule] 1\/3)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-\(1\/3\)\), " ", 
        SuperscriptBox[
          RowBox[{
            SuperscriptBox["F1", "\[Prime]",
              MultilineFunction->None], "[", "zeta1", "]"}], "2"]}], "-", 
      RowBox[{\(1\/3\), " ", \(F1[zeta1]\), " ", 
        RowBox[{
          SuperscriptBox["F1", "\[DoublePrime]",
            MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
      RowBox[{"\[Eta]", " ", 
        RowBox[{
          SuperscriptBox["F1", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "zeta1", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(int1 = 
      \[Integral]\((eq2 /. c \[Rule] 1\/3)\) \[DifferentialD]zeta1 == K1\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(-\(1\/3\)\), " ", \(F1[zeta1]\), " ", 
          RowBox[{
            SuperscriptBox["F1", "\[Prime]",
              MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
        RowBox[{"\[Eta]", " ", 
          RowBox[{
            SuperscriptBox["F1", "\[DoublePrime]",
              MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
      "K1"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Taking the boundary conditions into account, we realize that ",
  StyleBox["K",
    FontSlant->"Italic"],
  "1 = 0. This follows since ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["F",
                    FontSlant->"Italic"], "1"}]], "'"}], \((0)\)}], "=", 
          "0"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["F",
                      FontSlant->"Italic"], "1"}]], "'"}], "'"}], \((0)\)}], 
          "=", "0"}], TraditionalForm]]],
  ". Thus, the result simplifies and we can integrate the relation a second \
time:"
}], "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(int2 = 
      \[Integral]int1\[LeftDoubleBracket]1\[RightDoubleBracket] 
            \[DifferentialD]zeta1 == \(-K2\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\(-\(1\/6\)\)\ F1[zeta1]\^2\), "-", 
        RowBox[{"\[Eta]", " ", 
          RowBox[{
            SuperscriptBox["F1", "\[Prime]",
              MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
      \(-K2\)}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Now using ",
  StyleBox["DSolve[]", "MmaText"],
  " to integrate the first-order ordinary differential equation, we get the \
solution"
}], "Text",
  Evaluatable->False,
  CellTags->"jet solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sols = Flatten[DSolve[int2, F1, zeta1]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({F1 \[Rule] 
        \((\@6\ \@K2\ 
              Tanh[1\/6\ 
                  \((\(\@6\ \@K2\ #1\)\/\[Eta] - 6\ \@6\ \@K2\ C[1])\)]&)\)}
      \)], "Output"]
}, Open  ]],

Cell["The corresponding similarity representation follows by", "Text",
  Evaluatable->False,
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ssol = 
      Solve[\(red2\[LeftDoubleBracket]2\[RightDoubleBracket] /. sols\) /. 
          c \[Rule] 1\/3, \[CapitalPsi]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{\[CapitalPsi] \[Rule] 
          \@6\ \@K2\ x\^\(1/3\)\ 
            Tanh[1\/6\ 
                \((\(\@6\ \@K2\ y\)\/\(x\^\(2/3\)\ \[Eta]\) - 
                    6\ \@6\ \@K2\ C[1])\)]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This solution contains three parameters \[Eta], ",
  StyleBox["K",
    FontSlant->"Italic"],
  "2, and ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  ". \[Eta] is the kinematic viscosity which we set to unity in the \
following. The integration constant ",
  StyleBox["K",
    FontSlant->"Italic"],
  "2 changes the amplitude as well as the argument of the ",
  StyleBox["Tanh[]", "MmaText"],
  " function. ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  " determines the location of the orifice which we set to the origin. The \
following contour plot of the stream function gives us a representation of \
the stream lines in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  "-plane:"
}], "Text",
  Evaluatable->False,
  CellTags->{"Tanh[]", "contour plot"}],

Cell[BoxData[
    \(\(so1 = 
      \((\(\[CapitalPsi] /. ssol\) /. {K2 \[Rule] 1, \[Eta] \[Rule] 1, 
              C[1] \[Rule] 0})\)\[LeftDoubleBracket]1\[RightDoubleBracket]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[so1, {x,  .01, 3}, {y, \(-3\), 3}, PlotPoints \[Rule] 50, 
      Contours \[Rule] 20, ColorFunction \[Rule] Hue, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0160149 0.321585 0.5 0.160256 [
[.01601 -0.0125 -3 -9 ]
[.01601 -0.0125 3 0 ]
[.17681 -0.0125 -9 -9 ]
[.17681 -0.0125 9 0 ]
[.3376 -0.0125 -3 -9 ]
[.3376 -0.0125 3 0 ]
[.49839 -0.0125 -9 -9 ]
[.49839 -0.0125 9 0 ]
[.65918 -0.0125 -3 -9 ]
[.65918 -0.0125 3 0 ]
[.81998 -0.0125 -9 -9 ]
[.81998 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .17949 -12 -4.5 ]
[-0.0125 .17949 0 4.5 ]
[-0.0125 .33974 -12 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .66026 -6 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .82051 -6 -4.5 ]
[-0.0125 .82051 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01601 0 m
.01601 .00625 L
s
[(0)] .01601 -0.0125 0 1 Mshowa
.17681 0 m
.17681 .00625 L
s
[(0.5)] .17681 -0.0125 0 1 Mshowa
.3376 0 m
.3376 .00625 L
s
[(1)] .3376 -0.0125 0 1 Mshowa
.49839 0 m
.49839 .00625 L
s
[(1.5)] .49839 -0.0125 0 1 Mshowa
.65918 0 m
.65918 .00625 L
s
[(2)] .65918 -0.0125 0 1 Mshowa
.81998 0 m
.81998 .00625 L
s
[(2.5)] .81998 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(3)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.04817 0 m
.04817 .00375 L
s
.08033 0 m
.08033 .00375 L
s
.11249 0 m
.11249 .00375 L
s
.14465 0 m
.14465 .00375 L
s
.20897 0 m
.20897 .00375 L
s
.24112 0 m
.24112 .00375 L
s
.27328 0 m
.27328 .00375 L
s
.30544 0 m
.30544 .00375 L
s
.36976 0 m
.36976 .00375 L
s
.40192 0 m
.40192 .00375 L
s
.43408 0 m
.43408 .00375 L
s
.46623 0 m
.46623 .00375 L
s
.53055 0 m
.53055 .00375 L
s
.56271 0 m
.56271 .00375 L
s
.59487 0 m
.59487 .00375 L
s
.62703 0 m
.62703 .00375 L
s
.69134 0 m
.69134 .00375 L
s
.7235 0 m
.7235 .00375 L
s
.75566 0 m
.75566 .00375 L
s
.78782 0 m
.78782 .00375 L
s
.85214 0 m
.85214 .00375 L
s
.88429 0 m
.88429 .00375 L
s
.91645 0 m
.91645 .00375 L
s
.94861 0 m
.94861 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-3)] -0.0125 .01923 1 0 Mshowa
0 .17949 m
.00625 .17949 L
s
[(-2)] -0.0125 .17949 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(-1)] -0.0125 .33974 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(1)] -0.0125 .66026 1 0 Mshowa
0 .82051 m
.00625 .82051 L
s
[(2)] -0.0125 .82051 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(3)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05128 m
.00375 .05128 L
s
0 .08333 m
.00375 .08333 L
s
0 .11538 m
.00375 .11538 L
s
0 .14744 m
.00375 .14744 L
s
0 .21154 m
.00375 .21154 L
s
0 .24359 m
.00375 .24359 L
s
0 .27564 m
.00375 .27564 L
s
0 .30769 m
.00375 .30769 L
s
0 .37179 m
.00375 .37179 L
s
0 .40385 m
.00375 .40385 L
s
0 .4359 m
.00375 .4359 L
s
0 .46795 m
.00375 .46795 L
s
0 .53205 m
.00375 .53205 L
s
0 .5641 m
.00375 .5641 L
s
0 .59615 m
.00375 .59615 L
s
0 .62821 m
.00375 .62821 L
s
0 .69231 m
.00375 .69231 L
s
0 .72436 m
.00375 .72436 L
s
0 .75641 m
.00375 .75641 L
s
0 .78846 m
.00375 .78846 L
s
0 .85256 m
.00375 .85256 L
s
0 .88462 m
.00375 .88462 L
s
0 .91667 m
.00375 .91667 L
s
0 .94872 m
.00375 .94872 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01601 .99375 m
.01601 1 L
s
.17681 .99375 m
.17681 1 L
s
.3376 .99375 m
.3376 1 L
s
.49839 .99375 m
.49839 1 L
s
.65918 .99375 m
.65918 1 L
s
.81998 .99375 m
.81998 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.04817 .99625 m
.04817 1 L
s
.08033 .99625 m
.08033 1 L
s
.11249 .99625 m
.11249 1 L
s
.14465 .99625 m
.14465 1 L
s
.20897 .99625 m
.20897 1 L
s
.24112 .99625 m
.24112 1 L
s
.27328 .99625 m
.27328 1 L
s
.30544 .99625 m
.30544 1 L
s
.36976 .99625 m
.36976 1 L
s
.40192 .99625 m
.40192 1 L
s
.43408 .99625 m
.43408 1 L
s
.46623 .99625 m
.46623 1 L
s
.53055 .99625 m
.53055 1 L
s
.56271 .99625 m
.56271 1 L
s
.59487 .99625 m
.59487 1 L
s
.62703 .99625 m
.62703 1 L
s
.69134 .99625 m
.69134 1 L
s
.7235 .99625 m
.7235 1 L
s
.75566 .99625 m
.75566 1 L
s
.78782 .99625 m
.78782 1 L
s
.85214 .99625 m
.85214 1 L
s
.88429 .99625 m
.88429 1 L
s
.91645 .99625 m
.91645 1 L
s
.94861 .99625 m
.94861 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .17949 m
1 .17949 L
s
.99375 .33974 m
1 .33974 L
s
.99375 .5 m
1 .5 L
s
.99375 .66026 m
1 .66026 L
s
.99375 .82051 m
1 .82051 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05128 m
1 .05128 L
s
.99625 .08333 m
1 .08333 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .14744 m
1 .14744 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .24359 m
1 .24359 L
s
.99625 .27564 m
1 .27564 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .37179 m
1 .37179 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .4359 m
1 .4359 L
s
.99625 .46795 m
1 .46795 L
s
.99625 .53205 m
1 .53205 L
s
.99625 .5641 m
1 .5641 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .62821 m
1 .62821 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .72436 m
1 .72436 L
s
.99625 .75641 m
1 .75641 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .85256 m
1 .85256 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .91667 m
1 .91667 L
s
.99625 .94872 m
1 .94872 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .4 r
.01923 .46197 m
.03885 .4623 L
.05848 .45511 L
.07337 .45094 L
.0781 .44978 L
.09772 .44542 L
.11735 .44168 L
.13697 .43837 L
.15659 .43539 L
.17622 .43267 L
.18655 .43132 L
.19584 .43015 L
.21546 .42781 L
.23509 .42561 L
.25471 .42354 L
.27433 .42158 L
.29396 .41971 L
.31358 .41793 L
.3332 .41622 L
.35283 .41458 L
.37245 .413 L
.38915 .4117 L
.39207 .41147 L
.4117 .41 L
.43132 .40857 L
.45094 .40719 L
.47057 .40585 L
.49019 .40455 L
.50981 .40328 L
.52943 .40204 L
.54906 .40084 L
.56868 .39966 L
.5883 .39851 L
.60793 .39739 L
.62755 .39629 L
.64717 .39522 L
.6668 .39416 L
.68642 .39313 L
.70604 .39212 L
.70689 .39207 L
.72567 .39112 L
.74529 .39014 L
.76491 .38918 L
.78454 .38824 L
.80416 .38731 L
.82378 .3864 L
.84341 .3855 L
.86303 .38462 L
.88265 .38375 L
.90228 .38289 L
.9219 .38205 L
.94152 .38122 L
.96115 .38039 L
.98077 .37958 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .46197 m
.03885 .4623 L
.05848 .45511 L
.07337 .45094 L
.0781 .44978 L
.09772 .44542 L
.11735 .44168 L
.13697 .43837 L
.15659 .43539 L
.17622 .43267 L
.18655 .43132 L
.19584 .43015 L
.21546 .42781 L
.23509 .42561 L
.25471 .42354 L
.27433 .42158 L
.29396 .41971 L
.31358 .41793 L
.3332 .41622 L
.35283 .41458 L
.37245 .413 L
.38915 .4117 L
.39207 .41147 L
.4117 .41 L
.43132 .40857 L
.45094 .40719 L
.47057 .40585 L
.49019 .40455 L
.50981 .40328 L
.52943 .40204 L
.54906 .40084 L
.56868 .39966 L
.5883 .39851 L
.60793 .39739 L
.62755 .39629 L
.64717 .39522 L
.6668 .39416 L
.68642 .39313 L
.70604 .39212 L
.70689 .39207 L
.72567 .39112 L
.74529 .39014 L
.76491 .38918 L
.78454 .38824 L
.80416 .38731 L
.82378 .3864 L
.84341 .3855 L
.86303 .38462 L
.88265 .38375 L
.90228 .38289 L
Mistroke
.9219 .38205 L
.94152 .38122 L
.96115 .38039 L
.98077 .37958 L
Mfstroke
0 1 .7 r
.01923 .48722 m
.03885 .4788 L
.05848 .47414 L
.0781 .47078 L
.07952 .47057 L
.09772 .46807 L
.11735 .46576 L
.13697 .46373 L
.15659 .4619 L
.17622 .46023 L
.19584 .4587 L
.21546 .45727 L
.23509 .45593 L
.25471 .45467 L
.27433 .45348 L
.29396 .45234 L
.31358 .45126 L
.31951 .45094 L
.3332 .45022 L
.35283 .44923 L
.37245 .44827 L
.39207 .44735 L
.4117 .44646 L
.43132 .44559 L
.45094 .44476 L
.47057 .44395 L
.49019 .44316 L
.50981 .44239 L
.52943 .44164 L
.54906 .44091 L
.56868 .4402 L
.5883 .43951 L
.60793 .43883 L
.62755 .43817 L
.64717 .43752 L
.6668 .43688 L
.68642 .43626 L
.70604 .43564 L
.72567 .43504 L
.74529 .43445 L
.76491 .43388 L
.78454 .43331 L
.80416 .43275 L
.82378 .4322 L
.84341 .43165 L
.85575 .43132 L
.86303 .43112 L
.88265 .4306 L
.90228 .43008 L
.9219 .42957 L
.94152 .42907 L
.96115 .42857 L
.98077 .42808 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .48722 m
.03885 .4788 L
.05848 .47414 L
.0781 .47078 L
.07952 .47057 L
.09772 .46807 L
.11735 .46576 L
.13697 .46373 L
.15659 .4619 L
.17622 .46023 L
.19584 .4587 L
.21546 .45727 L
.23509 .45593 L
.25471 .45467 L
.27433 .45348 L
.29396 .45234 L
.31358 .45126 L
.31951 .45094 L
.3332 .45022 L
.35283 .44923 L
.37245 .44827 L
.39207 .44735 L
.4117 .44646 L
.43132 .44559 L
.45094 .44476 L
.47057 .44395 L
.49019 .44316 L
.50981 .44239 L
.52943 .44164 L
.54906 .44091 L
.56868 .4402 L
.5883 .43951 L
.60793 .43883 L
.62755 .43817 L
.64717 .43752 L
.6668 .43688 L
.68642 .43626 L
.70604 .43564 L
.72567 .43504 L
.74529 .43445 L
.76491 .43388 L
.78454 .43331 L
.80416 .43275 L
.82378 .4322 L
.84341 .43165 L
.85575 .43132 L
.86303 .43112 L
.88265 .4306 L
.90228 .43008 L
.9219 .42957 L
Mistroke
.94152 .42907 L
.96115 .42857 L
.98077 .42808 L
Mfstroke
0 1 1 r
.01923 .49687 m
.03885 .49311 L
.05848 .49154 L
.0781 .4904 L
.08231 .49019 L
.09772 .48948 L
.11735 .4887 L
.13697 .48802 L
.15659 .48741 L
.17622 .48685 L
.19584 .48633 L
.21546 .48585 L
.23509 .4854 L
.25471 .48498 L
.27433 .48458 L
.29396 .4842 L
.31358 .48384 L
.3332 .48349 L
.35283 .48315 L
.37245 .48283 L
.39207 .48252 L
.4117 .48223 L
.43132 .48194 L
.45094 .48166 L
.47057 .48139 L
.49019 .48112 L
.50981 .48087 L
.52943 .48062 L
.54906 .48037 L
.56868 .48013 L
.5883 .4799 L
.60793 .47967 L
.62755 .47945 L
.64717 .47924 L
.6668 .47902 L
.68642 .47881 L
.70604 .47861 L
.72567 .47841 L
.74529 .47821 L
.76491 .47802 L
.78454 .47783 L
.80416 .47764 L
.82378 .47746 L
.84341 .47728 L
.86303 .4771 L
.88265 .47692 L
.90228 .47675 L
.9219 .47658 L
.94152 .47641 L
.96115 .47625 L
.98077 .47608 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49687 m
.03885 .49311 L
.05848 .49154 L
.0781 .4904 L
.08231 .49019 L
.09772 .48948 L
.11735 .4887 L
.13697 .48802 L
.15659 .48741 L
.17622 .48685 L
.19584 .48633 L
.21546 .48585 L
.23509 .4854 L
.25471 .48498 L
.27433 .48458 L
.29396 .4842 L
.31358 .48384 L
.3332 .48349 L
.35283 .48315 L
.37245 .48283 L
.39207 .48252 L
.4117 .48223 L
.43132 .48194 L
.45094 .48166 L
.47057 .48139 L
.49019 .48112 L
.50981 .48087 L
.52943 .48062 L
.54906 .48037 L
.56868 .48013 L
.5883 .4799 L
.60793 .47967 L
.62755 .47945 L
.64717 .47924 L
.6668 .47902 L
.68642 .47881 L
.70604 .47861 L
.72567 .47841 L
.74529 .47821 L
.76491 .47802 L
.78454 .47783 L
.80416 .47764 L
.82378 .47746 L
.84341 .47728 L
.86303 .4771 L
.88265 .47692 L
.90228 .47675 L
.9219 .47658 L
.94152 .47641 L
.96115 .47625 L
Mistroke
.98077 .47608 L
Mfstroke
0 .7 1 r
.01923 .50313 m
.03885 .50689 L
.05848 .50846 L
.0781 .5096 L
.08231 .50981 L
.09772 .51052 L
.11735 .5113 L
.13697 .51198 L
.15659 .51259 L
.17622 .51315 L
.19584 .51367 L
.21546 .51415 L
.23509 .5146 L
.25471 .51502 L
.27433 .51542 L
.29396 .5158 L
.31358 .51616 L
.3332 .51651 L
.35283 .51685 L
.37245 .51717 L
.39207 .51748 L
.4117 .51777 L
.43132 .51806 L
.45094 .51834 L
.47057 .51861 L
.49019 .51888 L
.50981 .51913 L
.52943 .51938 L
.54906 .51963 L
.56868 .51987 L
.5883 .5201 L
.60793 .52033 L
.62755 .52055 L
.64717 .52076 L
.6668 .52098 L
.68642 .52119 L
.70604 .52139 L
.72567 .52159 L
.74529 .52179 L
.76491 .52198 L
.78454 .52217 L
.80416 .52236 L
.82378 .52254 L
.84341 .52272 L
.86303 .5229 L
.88265 .52308 L
.90228 .52325 L
.9219 .52342 L
.94152 .52359 L
.96115 .52375 L
.98077 .52392 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .50313 m
.03885 .50689 L
.05848 .50846 L
.0781 .5096 L
.08231 .50981 L
.09772 .51052 L
.11735 .5113 L
.13697 .51198 L
.15659 .51259 L
.17622 .51315 L
.19584 .51367 L
.21546 .51415 L
.23509 .5146 L
.25471 .51502 L
.27433 .51542 L
.29396 .5158 L
.31358 .51616 L
.3332 .51651 L
.35283 .51685 L
.37245 .51717 L
.39207 .51748 L
.4117 .51777 L
.43132 .51806 L
.45094 .51834 L
.47057 .51861 L
.49019 .51888 L
.50981 .51913 L
.52943 .51938 L
.54906 .51963 L
.56868 .51987 L
.5883 .5201 L
.60793 .52033 L
.62755 .52055 L
.64717 .52076 L
.6668 .52098 L
.68642 .52119 L
.70604 .52139 L
.72567 .52159 L
.74529 .52179 L
.76491 .52198 L
.78454 .52217 L
.80416 .52236 L
.82378 .52254 L
.84341 .52272 L
.86303 .5229 L
.88265 .52308 L
.90228 .52325 L
.9219 .52342 L
.94152 .52359 L
.96115 .52375 L
Mistroke
.98077 .52392 L
Mfstroke
0 .4 1 r
.01923 .51278 m
.03885 .5212 L
.05848 .52586 L
.0781 .52922 L
.07952 .52943 L
.09772 .53193 L
.11735 .53424 L
.13697 .53627 L
.15659 .5381 L
.17622 .53977 L
.19584 .5413 L
.21546 .54273 L
.23509 .54407 L
.25471 .54533 L
.27433 .54652 L
.29396 .54766 L
.31358 .54874 L
.31951 .54906 L
.3332 .54978 L
.35283 .55077 L
.37245 .55173 L
.39207 .55265 L
.4117 .55354 L
.43132 .55441 L
.45094 .55524 L
.47057 .55605 L
.49019 .55684 L
.50981 .55761 L
.52943 .55836 L
.54906 .55909 L
.56868 .5598 L
.5883 .56049 L
.60793 .56117 L
.62755 .56183 L
.64717 .56248 L
.6668 .56312 L
.68642 .56374 L
.70604 .56436 L
.72567 .56496 L
.74529 .56555 L
.76491 .56612 L
.78454 .56669 L
.80416 .56725 L
.82378 .5678 L
.84341 .56835 L
.85575 .56868 L
.86303 .56888 L
.88265 .5694 L
.90228 .56992 L
.9219 .57043 L
.94152 .57093 L
.96115 .57143 L
.98077 .57192 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .51278 m
.03885 .5212 L
.05848 .52586 L
.0781 .52922 L
.07952 .52943 L
.09772 .53193 L
.11735 .53424 L
.13697 .53627 L
.15659 .5381 L
.17622 .53977 L
.19584 .5413 L
.21546 .54273 L
.23509 .54407 L
.25471 .54533 L
.27433 .54652 L
.29396 .54766 L
.31358 .54874 L
.31951 .54906 L
.3332 .54978 L
.35283 .55077 L
.37245 .55173 L
.39207 .55265 L
.4117 .55354 L
.43132 .55441 L
.45094 .55524 L
.47057 .55605 L
.49019 .55684 L
.50981 .55761 L
.52943 .55836 L
.54906 .55909 L
.56868 .5598 L
.5883 .56049 L
.60793 .56117 L
.62755 .56183 L
.64717 .56248 L
.6668 .56312 L
.68642 .56374 L
.70604 .56436 L
.72567 .56496 L
.74529 .56555 L
.76491 .56612 L
.78454 .56669 L
.80416 .56725 L
.82378 .5678 L
.84341 .56835 L
.85575 .56868 L
.86303 .56888 L
.88265 .5694 L
.90228 .56992 L
.9219 .57043 L
Mistroke
.94152 .57093 L
.96115 .57143 L
.98077 .57192 L
Mfstroke
0 .1 1 r
.01923 .53803 m
.03885 .5377 L
.05848 .54489 L
.07337 .54906 L
.0781 .55022 L
.09772 .55458 L
.11735 .55832 L
.13697 .56163 L
.15659 .56461 L
.17622 .56733 L
.18655 .56868 L
.19584 .56985 L
.21546 .57219 L
.23509 .57439 L
.25471 .57646 L
.27433 .57842 L
.29396 .58029 L
.31358 .58207 L
.3332 .58378 L
.35283 .58542 L
.37245 .587 L
.38915 .5883 L
.39207 .58853 L
.4117 .59 L
.43132 .59143 L
.45094 .59281 L
.47057 .59415 L
.49019 .59545 L
.50981 .59672 L
.52943 .59796 L
.54906 .59916 L
.56868 .60034 L
.5883 .60149 L
.60793 .60261 L
.62755 .60371 L
.64717 .60478 L
.6668 .60584 L
.68642 .60687 L
.70604 .60788 L
.70689 .60793 L
.72567 .60888 L
.74529 .60986 L
.76491 .61082 L
.78454 .61176 L
.80416 .61269 L
.82378 .6136 L
.84341 .6145 L
.86303 .61538 L
.88265 .61625 L
.90228 .61711 L
.9219 .61795 L
.94152 .61878 L
.96115 .61961 L
.98077 .62042 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .53803 m
.03885 .5377 L
.05848 .54489 L
.07337 .54906 L
.0781 .55022 L
.09772 .55458 L
.11735 .55832 L
.13697 .56163 L
.15659 .56461 L
.17622 .56733 L
.18655 .56868 L
.19584 .56985 L
.21546 .57219 L
.23509 .57439 L
.25471 .57646 L
.27433 .57842 L
.29396 .58029 L
.31358 .58207 L
.3332 .58378 L
.35283 .58542 L
.37245 .587 L
.38915 .5883 L
.39207 .58853 L
.4117 .59 L
.43132 .59143 L
.45094 .59281 L
.47057 .59415 L
.49019 .59545 L
.50981 .59672 L
.52943 .59796 L
.54906 .59916 L
.56868 .60034 L
.5883 .60149 L
.60793 .60261 L
.62755 .60371 L
.64717 .60478 L
.6668 .60584 L
.68642 .60687 L
.70604 .60788 L
.70689 .60793 L
.72567 .60888 L
.74529 .60986 L
.76491 .61082 L
.78454 .61176 L
.80416 .61269 L
.82378 .6136 L
.84341 .6145 L
.86303 .61538 L
.88265 .61625 L
.90228 .61711 L
Mistroke
.9219 .61795 L
.94152 .61878 L
.96115 .61961 L
.98077 .62042 L
Mfstroke
.2 0 1 r
.98077 .66977 m
.96115 .66865 L
.94152 .66751 L
.92942 .6668 L
.9219 .66635 L
.90228 .66518 L
.88265 .66399 L
.86303 .66278 L
.84341 .66155 L
.82378 .66031 L
.80416 .65904 L
.78454 .65776 L
.76491 .65645 L
.74529 .65512 L
.72567 .65376 L
.70604 .65239 L
.68642 .65098 L
.6668 .64955 L
.64717 .64809 L
.63507 .64717 L
.62755 .6466 L
.60793 .64508 L
.5883 .64352 L
.56868 .64193 L
.54906 .64031 L
.52943 .63864 L
.50981 .63693 L
.49019 .63518 L
.47057 .63338 L
.45094 .63153 L
.43132 .62962 L
.4117 .62766 L
.41063 .62755 L
.39207 .62563 L
.37245 .62353 L
.35283 .62136 L
.3332 .6191 L
.31358 .61676 L
.29396 .61431 L
.27433 .61175 L
.25471 .60906 L
.2467 .60793 L
.23509 .60623 L
.21546 .60324 L
.19584 .60006 L
.17622 .59665 L
.15659 .59298 L
.13697 .58899 L
.13379 .5883 L
.11735 .58458 L
.09772 .57966 L
.0781 .57403 L
.06192 .56868 L
.05848 .56751 L
.03885 .55999 L
.03024 .56868 L
.02679 .5883 L
.02585 .60793 L
.02553 .62755 L
.02544 .64717 L
.02543 .6668 L
.02546 .68642 L
.03221 .70604 L
.02917 .72567 L
.02753 .74529 L
.02655 .76491 L
.02592 .78454 L
.0255 .80416 L
.0252 .82378 L
.02498 .84341 L
.02482 .86303 L
.0247 .88265 L
.02461 .90228 L
.02454 .9219 L
.02449 .94152 L
.02445 .96115 L
.02442 .98077 L
.98077 .98077 L
F
0 g
.98077 .66977 m
.96115 .66865 L
.94152 .66751 L
.92942 .6668 L
.9219 .66635 L
.90228 .66518 L
.88265 .66399 L
.86303 .66278 L
.84341 .66155 L
.82378 .66031 L
.80416 .65904 L
.78454 .65776 L
.76491 .65645 L
.74529 .65512 L
.72567 .65376 L
.70604 .65239 L
.68642 .65098 L
.6668 .64955 L
.64717 .64809 L
.63507 .64717 L
.62755 .6466 L
.60793 .64508 L
.5883 .64352 L
.56868 .64193 L
.54906 .64031 L
.52943 .63864 L
.50981 .63693 L
.49019 .63518 L
.47057 .63338 L
.45094 .63153 L
.43132 .62962 L
.4117 .62766 L
.41063 .62755 L
.39207 .62563 L
.37245 .62353 L
.35283 .62136 L
.3332 .6191 L
.31358 .61676 L
.29396 .61431 L
.27433 .61175 L
.25471 .60906 L
.2467 .60793 L
.23509 .60623 L
.21546 .60324 L
.19584 .60006 L
.17622 .59665 L
.15659 .59298 L
.13697 .58899 L
.13379 .5883 L
.11735 .58458 L
Mistroke
.09772 .57966 L
.0781 .57403 L
.06192 .56868 L
.05848 .56751 L
.03885 .55999 L
.03024 .56868 L
.02679 .5883 L
.02585 .60793 L
.02553 .62755 L
.02544 .64717 L
.02543 .6668 L
.02546 .68642 L
.03221 .70604 L
.02917 .72567 L
.02753 .74529 L
.02655 .76491 L
.02592 .78454 L
.0255 .80416 L
.0252 .82378 L
.02498 .84341 L
.02482 .86303 L
.0247 .88265 L
.02461 .90228 L
.02454 .9219 L
.02449 .94152 L
.02445 .96115 L
.02442 .98077 L
Mfstroke
.2 1 0 r
.98077 .33023 m
.96115 .33135 L
.94152 .33249 L
.92942 .3332 L
.9219 .33365 L
.90228 .33482 L
.88265 .33601 L
.86303 .33722 L
.84341 .33845 L
.82378 .33969 L
.80416 .34096 L
.78454 .34224 L
.76491 .34355 L
.74529 .34488 L
.72567 .34624 L
.70604 .34761 L
.68642 .34902 L
.6668 .35045 L
.64717 .35191 L
.63507 .35283 L
.62755 .3534 L
.60793 .35492 L
.5883 .35648 L
.56868 .35807 L
.54906 .35969 L
.52943 .36136 L
.50981 .36307 L
.49019 .36482 L
.47057 .36662 L
.45094 .36847 L
.43132 .37038 L
.4117 .37234 L
.41063 .37245 L
.39207 .37437 L
.37245 .37647 L
.35283 .37864 L
.3332 .3809 L
.31358 .38324 L
.29396 .38569 L
.27433 .38825 L
.25471 .39094 L
.2467 .39207 L
.23509 .39377 L
.21546 .39676 L
.19584 .39994 L
.17622 .40335 L
.15659 .40702 L
.13697 .41101 L
.13379 .4117 L
.11735 .41542 L
.09772 .42034 L
.0781 .42597 L
.06192 .43132 L
.05848 .43249 L
.03885 .44001 L
.03024 .43132 L
.02679 .4117 L
.02585 .39207 L
.02553 .37245 L
.02544 .35283 L
.02543 .3332 L
.02546 .31358 L
.03221 .29396 L
.02917 .27433 L
.02753 .25471 L
.02655 .23509 L
.02592 .21546 L
.0255 .19584 L
.0252 .17622 L
.02498 .15659 L
.02482 .13697 L
.0247 .11735 L
.02461 .09772 L
.02454 .0781 L
.02449 .05848 L
.02445 .03885 L
.02442 .01923 L
.98077 .01923 L
F
0 g
.98077 .33023 m
.96115 .33135 L
.94152 .33249 L
.92942 .3332 L
.9219 .33365 L
.90228 .33482 L
.88265 .33601 L
.86303 .33722 L
.84341 .33845 L
.82378 .33969 L
.80416 .34096 L
.78454 .34224 L
.76491 .34355 L
.74529 .34488 L
.72567 .34624 L
.70604 .34761 L
.68642 .34902 L
.6668 .35045 L
.64717 .35191 L
.63507 .35283 L
.62755 .3534 L
.60793 .35492 L
.5883 .35648 L
.56868 .35807 L
.54906 .35969 L
.52943 .36136 L
.50981 .36307 L
.49019 .36482 L
.47057 .36662 L
.45094 .36847 L
.43132 .37038 L
.4117 .37234 L
.41063 .37245 L
.39207 .37437 L
.37245 .37647 L
.35283 .37864 L
.3332 .3809 L
.31358 .38324 L
.29396 .38569 L
.27433 .38825 L
.25471 .39094 L
.2467 .39207 L
.23509 .39377 L
.21546 .39676 L
.19584 .39994 L
.17622 .40335 L
.15659 .40702 L
.13697 .41101 L
.13379 .4117 L
.11735 .41542 L
Mistroke
.09772 .42034 L
.0781 .42597 L
.06192 .43132 L
.05848 .43249 L
.03885 .44001 L
.03024 .43132 L
.02679 .4117 L
.02585 .39207 L
.02553 .37245 L
.02544 .35283 L
.02543 .3332 L
.02546 .31358 L
.03221 .29396 L
.02917 .27433 L
.02753 .25471 L
.02655 .23509 L
.02592 .21546 L
.0255 .19584 L
.0252 .17622 L
.02498 .15659 L
.02482 .13697 L
.0247 .11735 L
.02461 .09772 L
.02454 .0781 L
.02449 .05848 L
.02445 .03885 L
.02442 .01923 L
Mfstroke
.5 0 1 r
.98077 .72039 m
.96115 .71896 L
.94152 .71751 L
.9219 .71604 L
.90228 .71455 L
.88265 .71304 L
.86303 .71151 L
.84341 .70995 L
.82378 .70837 L
.80416 .70676 L
.79547 .70604 L
.78454 .70513 L
.76491 .70347 L
.74529 .70179 L
.72567 .70007 L
.70604 .69832 L
.68642 .69655 L
.6668 .69473 L
.64717 .69289 L
.62755 .691 L
.60793 .68908 L
.5883 .68712 L
.58147 .68642 L
.56868 .68511 L
.54906 .68306 L
.52943 .68095 L
.50981 .6788 L
.49019 .67659 L
.47057 .67433 L
.45094 .672 L
.43132 .66961 L
.4117 .66714 L
.40899 .6668 L
.39207 .6646 L
.37245 .66198 L
.35283 .65926 L
.3332 .65644 L
.31358 .65352 L
.29396 .65048 L
.27433 .64731 L
.27352 .64717 L
.25471 .64399 L
.23509 .64051 L
.21546 .63684 L
.19584 .63296 L
.17622 .62884 L
.17031 .62755 L
.15659 .62445 L
.13697 .61973 L
.11735 .61464 L
.09772 .60918 L
.09386 .60793 L
.0781 .60339 L
.05848 .59812 L
.03885 .60593 L
.03838 .60793 L
.03583 .62755 L
.03493 .64717 L
.03455 .6668 L
.03439 .68642 L
.03603 .70604 L
.03516 .72567 L
.03467 .74529 L
.03437 .76491 L
.03418 .78454 L
.03405 .80416 L
.03396 .82378 L
.03389 .84341 L
.03384 .86303 L
.0338 .88265 L
.03377 .90228 L
.03375 .9219 L
.03373 .94152 L
.03372 .96115 L
.03371 .98077 L
.98077 .98077 L
F
0 g
.98077 .72039 m
.96115 .71896 L
.94152 .71751 L
.9219 .71604 L
.90228 .71455 L
.88265 .71304 L
.86303 .71151 L
.84341 .70995 L
.82378 .70837 L
.80416 .70676 L
.79547 .70604 L
.78454 .70513 L
.76491 .70347 L
.74529 .70179 L
.72567 .70007 L
.70604 .69832 L
.68642 .69655 L
.6668 .69473 L
.64717 .69289 L
.62755 .691 L
.60793 .68908 L
.5883 .68712 L
.58147 .68642 L
.56868 .68511 L
.54906 .68306 L
.52943 .68095 L
.50981 .6788 L
.49019 .67659 L
.47057 .67433 L
.45094 .672 L
.43132 .66961 L
.4117 .66714 L
.40899 .6668 L
.39207 .6646 L
.37245 .66198 L
.35283 .65926 L
.3332 .65644 L
.31358 .65352 L
.29396 .65048 L
.27433 .64731 L
.27352 .64717 L
.25471 .64399 L
.23509 .64051 L
.21546 .63684 L
.19584 .63296 L
.17622 .62884 L
.17031 .62755 L
.15659 .62445 L
.13697 .61973 L
.11735 .61464 L
Mistroke
.09772 .60918 L
.09386 .60793 L
.0781 .60339 L
.05848 .59812 L
.03885 .60593 L
.03838 .60793 L
.03583 .62755 L
.03493 .64717 L
.03455 .6668 L
.03439 .68642 L
.03603 .70604 L
.03516 .72567 L
.03467 .74529 L
.03437 .76491 L
.03418 .78454 L
.03405 .80416 L
.03396 .82378 L
.03389 .84341 L
.03384 .86303 L
.0338 .88265 L
.03377 .90228 L
.03375 .9219 L
.03373 .94152 L
.03372 .96115 L
.03371 .98077 L
Mfstroke
.5 1 0 r
.98077 .27961 m
.96115 .28104 L
.94152 .28249 L
.9219 .28396 L
.90228 .28545 L
.88265 .28696 L
.86303 .28849 L
.84341 .29005 L
.82378 .29163 L
.80416 .29324 L
.79547 .29396 L
.78454 .29487 L
.76491 .29653 L
.74529 .29821 L
.72567 .29993 L
.70604 .30168 L
.68642 .30345 L
.6668 .30527 L
.64717 .30711 L
.62755 .309 L
.60793 .31092 L
.5883 .31288 L
.58147 .31358 L
.56868 .31489 L
.54906 .31694 L
.52943 .31905 L
.50981 .3212 L
.49019 .32341 L
.47057 .32567 L
.45094 .328 L
.43132 .33039 L
.4117 .33286 L
.40899 .3332 L
.39207 .3354 L
.37245 .33802 L
.35283 .34074 L
.3332 .34356 L
.31358 .34648 L
.29396 .34952 L
.27433 .35269 L
.27352 .35283 L
.25471 .35601 L
.23509 .35949 L
.21546 .36316 L
.19584 .36704 L
.17622 .37116 L
.17031 .37245 L
.15659 .37555 L
.13697 .38027 L
.11735 .38536 L
.09772 .39082 L
.09386 .39207 L
.0781 .39661 L
.05848 .40188 L
.03885 .39407 L
.03838 .39207 L
.03583 .37245 L
.03493 .35283 L
.03455 .3332 L
.03439 .31358 L
.03603 .29396 L
.03516 .27433 L
.03467 .25471 L
.03437 .23509 L
.03418 .21546 L
.03405 .19584 L
.03396 .17622 L
.03389 .15659 L
.03384 .13697 L
.0338 .11735 L
.03377 .09772 L
.03375 .0781 L
.03373 .05848 L
.03372 .03885 L
.03371 .01923 L
.98077 .01923 L
F
0 g
.98077 .27961 m
.96115 .28104 L
.94152 .28249 L
.9219 .28396 L
.90228 .28545 L
.88265 .28696 L
.86303 .28849 L
.84341 .29005 L
.82378 .29163 L
.80416 .29324 L
.79547 .29396 L
.78454 .29487 L
.76491 .29653 L
.74529 .29821 L
.72567 .29993 L
.70604 .30168 L
.68642 .30345 L
.6668 .30527 L
.64717 .30711 L
.62755 .309 L
.60793 .31092 L
.5883 .31288 L
.58147 .31358 L
.56868 .31489 L
.54906 .31694 L
.52943 .31905 L
.50981 .3212 L
.49019 .32341 L
.47057 .32567 L
.45094 .328 L
.43132 .33039 L
.4117 .33286 L
.40899 .3332 L
.39207 .3354 L
.37245 .33802 L
.35283 .34074 L
.3332 .34356 L
.31358 .34648 L
.29396 .34952 L
.27433 .35269 L
.27352 .35283 L
.25471 .35601 L
.23509 .35949 L
.21546 .36316 L
.19584 .36704 L
.17622 .37116 L
.17031 .37245 L
.15659 .37555 L
.13697 .38027 L
.11735 .38536 L
Mistroke
.09772 .39082 L
.09386 .39207 L
.0781 .39661 L
.05848 .40188 L
.03885 .39407 L
.03838 .39207 L
.03583 .37245 L
.03493 .35283 L
.03455 .3332 L
.03439 .31358 L
.03603 .29396 L
.03516 .27433 L
.03467 .25471 L
.03437 .23509 L
.03418 .21546 L
.03405 .19584 L
.03396 .17622 L
.03389 .15659 L
.03384 .13697 L
.0338 .11735 L
.03377 .09772 L
.03375 .0781 L
.03373 .05848 L
.03372 .03885 L
.03371 .01923 L
Mfstroke
.8 0 1 r
.98077 .77272 m
.96115 .771 L
.94152 .76926 L
.9219 .76749 L
.90228 .7657 L
.89374 .76491 L
.88265 .76389 L
.86303 .76204 L
.84341 .76018 L
.82378 .75828 L
.80416 .75636 L
.78454 .7544 L
.76491 .75241 L
.74529 .7504 L
.72567 .74834 L
.70604 .74625 L
.6971 .74529 L
.68642 .74413 L
.6668 .74196 L
.64717 .73976 L
.62755 .73751 L
.60793 .73522 L
.5883 .73288 L
.56868 .73049 L
.54906 .72806 L
.53026 .72567 L
.52943 .72556 L
.50981 .72301 L
.49019 .7204 L
.47057 .71772 L
.45094 .71497 L
.43132 .71215 L
.4117 .70925 L
.39207 .70627 L
.39062 .70604 L
.37245 .70319 L
.35283 .70002 L
.3332 .69675 L
.31358 .69336 L
.29396 .68985 L
.27542 .68642 L
.27433 .68622 L
.25471 .68243 L
.23509 .6785 L
.21546 .67439 L
.19584 .67012 L
.18112 .6668 L
.17622 .66567 L
.15659 .66105 L
.13697 .65631 L
.11735 .65161 L
.09772 .64742 L
.09645 .64717 L
.0781 .64544 L
.06768 .64717 L
.05848 .65673 L
.05404 .6668 L
.05075 .68642 L
.04908 .70604 L
.04863 .72567 L
.0484 .74529 L
.04828 .76491 L
.04823 .78454 L
.0482 .80416 L
.04819 .82378 L
.04819 .84341 L
.0482 .86303 L
.0482 .88265 L
.04821 .90228 L
.04822 .9219 L
.04823 .94152 L
.04823 .96115 L
.04824 .98077 L
.98077 .98077 L
F
0 g
.98077 .77272 m
.96115 .771 L
.94152 .76926 L
.9219 .76749 L
.90228 .7657 L
.89374 .76491 L
.88265 .76389 L
.86303 .76204 L
.84341 .76018 L
.82378 .75828 L
.80416 .75636 L
.78454 .7544 L
.76491 .75241 L
.74529 .7504 L
.72567 .74834 L
.70604 .74625 L
.6971 .74529 L
.68642 .74413 L
.6668 .74196 L
.64717 .73976 L
.62755 .73751 L
.60793 .73522 L
.5883 .73288 L
.56868 .73049 L
.54906 .72806 L
.53026 .72567 L
.52943 .72556 L
.50981 .72301 L
.49019 .7204 L
.47057 .71772 L
.45094 .71497 L
.43132 .71215 L
.4117 .70925 L
.39207 .70627 L
.39062 .70604 L
.37245 .70319 L
.35283 .70002 L
.3332 .69675 L
.31358 .69336 L
.29396 .68985 L
.27542 .68642 L
.27433 .68622 L
.25471 .68243 L
.23509 .6785 L
.21546 .67439 L
.19584 .67012 L
.18112 .6668 L
.17622 .66567 L
.15659 .66105 L
.13697 .65631 L
Mistroke
.11735 .65161 L
.09772 .64742 L
.09645 .64717 L
.0781 .64544 L
.06768 .64717 L
.05848 .65673 L
.05404 .6668 L
.05075 .68642 L
.04908 .70604 L
.04863 .72567 L
.0484 .74529 L
.04828 .76491 L
.04823 .78454 L
.0482 .80416 L
.04819 .82378 L
.04819 .84341 L
.0482 .86303 L
.0482 .88265 L
.04821 .90228 L
.04822 .9219 L
.04823 .94152 L
.04823 .96115 L
.04824 .98077 L
Mfstroke
.8 1 0 r
.98077 .22728 m
.96115 .229 L
.94152 .23074 L
.9219 .23251 L
.90228 .2343 L
.89374 .23509 L
.88265 .23611 L
.86303 .23796 L
.84341 .23982 L
.82378 .24172 L
.80416 .24364 L
.78454 .2456 L
.76491 .24759 L
.74529 .2496 L
.72567 .25166 L
.70604 .25375 L
.6971 .25471 L
.68642 .25587 L
.6668 .25804 L
.64717 .26024 L
.62755 .26249 L
.60793 .26478 L
.5883 .26712 L
.56868 .26951 L
.54906 .27194 L
.53026 .27433 L
.52943 .27444 L
.50981 .27699 L
.49019 .2796 L
.47057 .28228 L
.45094 .28503 L
.43132 .28785 L
.4117 .29075 L
.39207 .29373 L
.39062 .29396 L
.37245 .29681 L
.35283 .29998 L
.3332 .30325 L
.31358 .30664 L
.29396 .31015 L
.27542 .31358 L
.27433 .31378 L
.25471 .31757 L
.23509 .3215 L
.21546 .32561 L
.19584 .32988 L
.18112 .3332 L
.17622 .33433 L
.15659 .33895 L
.13697 .34369 L
.11735 .34839 L
.09772 .35258 L
.09645 .35283 L
.0781 .35456 L
.06768 .35283 L
.05848 .34327 L
.05404 .3332 L
.05075 .31358 L
.04908 .29396 L
.04863 .27433 L
.0484 .25471 L
.04828 .23509 L
.04823 .21546 L
.0482 .19584 L
.04819 .17622 L
.04819 .15659 L
.0482 .13697 L
.0482 .11735 L
.04821 .09772 L
.04822 .0781 L
.04823 .05848 L
.04823 .03885 L
.04824 .01923 L
.98077 .01923 L
F
0 g
.98077 .22728 m
.96115 .229 L
.94152 .23074 L
.9219 .23251 L
.90228 .2343 L
.89374 .23509 L
.88265 .23611 L
.86303 .23796 L
.84341 .23982 L
.82378 .24172 L
.80416 .24364 L
.78454 .2456 L
.76491 .24759 L
.74529 .2496 L
.72567 .25166 L
.70604 .25375 L
.6971 .25471 L
.68642 .25587 L
.6668 .25804 L
.64717 .26024 L
.62755 .26249 L
.60793 .26478 L
.5883 .26712 L
.56868 .26951 L
.54906 .27194 L
.53026 .27433 L
.52943 .27444 L
.50981 .27699 L
.49019 .2796 L
.47057 .28228 L
.45094 .28503 L
.43132 .28785 L
.4117 .29075 L
.39207 .29373 L
.39062 .29396 L
.37245 .29681 L
.35283 .29998 L
.3332 .30325 L
.31358 .30664 L
.29396 .31015 L
.27542 .31358 L
.27433 .31378 L
.25471 .31757 L
.23509 .3215 L
.21546 .32561 L
.19584 .32988 L
.18112 .3332 L
.17622 .33433 L
.15659 .33895 L
.13697 .34369 L
Mistroke
.11735 .34839 L
.09772 .35258 L
.09645 .35283 L
.0781 .35456 L
.06768 .35283 L
.05848 .34327 L
.05404 .3332 L
.05075 .31358 L
.04908 .29396 L
.04863 .27433 L
.0484 .25471 L
.04828 .23509 L
.04823 .21546 L
.0482 .19584 L
.04819 .17622 L
.04819 .15659 L
.0482 .13697 L
.0482 .11735 L
.04821 .09772 L
.04822 .0781 L
.04823 .05848 L
.04823 .03885 L
.04824 .01923 L
Mfstroke
1 0 .9 r
.98077 .8273 m
.96115 .82532 L
.94617 .82378 L
.94152 .8233 L
.9219 .82127 L
.90228 .8192 L
.88265 .81711 L
.86303 .81499 L
.84341 .81284 L
.82378 .81066 L
.80416 .80845 L
.78454 .8062 L
.76695 .80416 L
.76491 .80392 L
.74529 .80161 L
.72567 .79925 L
.70604 .79686 L
.68642 .79443 L
.6668 .79196 L
.64717 .78945 L
.62755 .78689 L
.60985 .78454 L
.60793 .78428 L
.5883 .78162 L
.56868 .77892 L
.54906 .77615 L
.52943 .77334 L
.50981 .77046 L
.49019 .76752 L
.47313 .76491 L
.47057 .76452 L
.45094 .76144 L
.43132 .7583 L
.4117 .75508 L
.39207 .75179 L
.37245 .74841 L
.35477 .74529 L
.35283 .74494 L
.3332 .74139 L
.31358 .73775 L
.29396 .73401 L
.27433 .73019 L
.25471 .72628 L
.25166 .72567 L
.23509 .7223 L
.21546 .71828 L
.19584 .71428 L
.17622 .71039 L
.15659 .70683 L
.15181 .70604 L
.13697 .70405 L
.11735 .70318 L
.10166 .70604 L
.09772 .70788 L
.0815 .72567 L
.0781 .74006 L
.07691 .74529 L
.07394 .76491 L
.07228 .78454 L
.07127 .80416 L
.07062 .82378 L
.07019 .84341 L
.06989 .86303 L
.06969 .88265 L
.06955 .90228 L
.06945 .9219 L
.06939 .94152 L
.06934 .96115 L
.0693 .98077 L
.98077 .98077 L
F
0 g
.98077 .8273 m
.96115 .82532 L
.94617 .82378 L
.94152 .8233 L
.9219 .82127 L
.90228 .8192 L
.88265 .81711 L
.86303 .81499 L
.84341 .81284 L
.82378 .81066 L
.80416 .80845 L
.78454 .8062 L
.76695 .80416 L
.76491 .80392 L
.74529 .80161 L
.72567 .79925 L
.70604 .79686 L
.68642 .79443 L
.6668 .79196 L
.64717 .78945 L
.62755 .78689 L
.60985 .78454 L
.60793 .78428 L
.5883 .78162 L
.56868 .77892 L
.54906 .77615 L
.52943 .77334 L
.50981 .77046 L
.49019 .76752 L
.47313 .76491 L
.47057 .76452 L
.45094 .76144 L
.43132 .7583 L
.4117 .75508 L
.39207 .75179 L
.37245 .74841 L
.35477 .74529 L
.35283 .74494 L
.3332 .74139 L
.31358 .73775 L
.29396 .73401 L
.27433 .73019 L
.25471 .72628 L
.25166 .72567 L
.23509 .7223 L
.21546 .71828 L
.19584 .71428 L
.17622 .71039 L
.15659 .70683 L
.15181 .70604 L
Mistroke
.13697 .70405 L
.11735 .70318 L
.10166 .70604 L
.09772 .70788 L
.0815 .72567 L
.0781 .74006 L
.07691 .74529 L
.07394 .76491 L
.07228 .78454 L
.07127 .80416 L
.07062 .82378 L
.07019 .84341 L
.06989 .86303 L
.06969 .88265 L
.06955 .90228 L
.06945 .9219 L
.06939 .94152 L
.06934 .96115 L
.0693 .98077 L
Mfstroke
1 .9 0 r
.98077 .1727 m
.96115 .17468 L
.94617 .17622 L
.94152 .1767 L
.9219 .17873 L
.90228 .1808 L
.88265 .18289 L
.86303 .18501 L
.84341 .18716 L
.82378 .18934 L
.80416 .19155 L
.78454 .1938 L
.76695 .19584 L
.76491 .19608 L
.74529 .19839 L
.72567 .20075 L
.70604 .20314 L
.68642 .20557 L
.6668 .20804 L
.64717 .21055 L
.62755 .21311 L
.60985 .21546 L
.60793 .21572 L
.5883 .21838 L
.56868 .22108 L
.54906 .22385 L
.52943 .22666 L
.50981 .22954 L
.49019 .23248 L
.47313 .23509 L
.47057 .23548 L
.45094 .23856 L
.43132 .2417 L
.4117 .24492 L
.39207 .24821 L
.37245 .25159 L
.35477 .25471 L
.35283 .25506 L
.3332 .25861 L
.31358 .26225 L
.29396 .26599 L
.27433 .26981 L
.25471 .27372 L
.25166 .27433 L
.23509 .2777 L
.21546 .28172 L
.19584 .28572 L
.17622 .28961 L
.15659 .29317 L
.15181 .29396 L
.13697 .29595 L
.11735 .29682 L
.10166 .29396 L
.09772 .29212 L
.0815 .27433 L
.0781 .25994 L
.07691 .25471 L
.07394 .23509 L
.07228 .21546 L
.07127 .19584 L
.07062 .17622 L
.07019 .15659 L
.06989 .13697 L
.06969 .11735 L
.06955 .09772 L
.06945 .0781 L
.06939 .05848 L
.06934 .03885 L
.0693 .01923 L
.98077 .01923 L
F
0 g
.98077 .1727 m
.96115 .17468 L
.94617 .17622 L
.94152 .1767 L
.9219 .17873 L
.90228 .1808 L
.88265 .18289 L
.86303 .18501 L
.84341 .18716 L
.82378 .18934 L
.80416 .19155 L
.78454 .1938 L
.76695 .19584 L
.76491 .19608 L
.74529 .19839 L
.72567 .20075 L
.70604 .20314 L
.68642 .20557 L
.6668 .20804 L
.64717 .21055 L
.62755 .21311 L
.60985 .21546 L
.60793 .21572 L
.5883 .21838 L
.56868 .22108 L
.54906 .22385 L
.52943 .22666 L
.50981 .22954 L
.49019 .23248 L
.47313 .23509 L
.47057 .23548 L
.45094 .23856 L
.43132 .2417 L
.4117 .24492 L
.39207 .24821 L
.37245 .25159 L
.35477 .25471 L
.35283 .25506 L
.3332 .25861 L
.31358 .26225 L
.29396 .26599 L
.27433 .26981 L
.25471 .27372 L
.25166 .27433 L
.23509 .2777 L
.21546 .28172 L
.19584 .28572 L
.17622 .28961 L
.15659 .29317 L
.15181 .29396 L
Mistroke
.13697 .29595 L
.11735 .29682 L
.10166 .29396 L
.09772 .29212 L
.0815 .27433 L
.0781 .25994 L
.07691 .25471 L
.07394 .23509 L
.07228 .21546 L
.07127 .19584 L
.07062 .17622 L
.07019 .15659 L
.06989 .13697 L
.06969 .11735 L
.06955 .09772 L
.06945 .0781 L
.06939 .05848 L
.06934 .03885 L
.0693 .01923 L
Mfstroke
1 0 .6 r
.98077 .88482 m
.96162 .88265 L
.96115 .8826 L
.94152 .88035 L
.9219 .87808 L
.90228 .87578 L
.88265 .87346 L
.86303 .8711 L
.84341 .86871 L
.82378 .86629 L
.80416 .86384 L
.79775 .86303 L
.78454 .86135 L
.76491 .85883 L
.74529 .85628 L
.72567 .85369 L
.70604 .85106 L
.68642 .84839 L
.6668 .84568 L
.65055 .84341 L
.64717 .84293 L
.62755 .84014 L
.60793 .8373 L
.5883 .83442 L
.56868 .83149 L
.54906 .82851 L
.52943 .82549 L
.51851 .82378 L
.50981 .82241 L
.49019 .81929 L
.47057 .81611 L
.45094 .81288 L
.43132 .8096 L
.4117 .80627 L
.39941 .80416 L
.39207 .80289 L
.37245 .79947 L
.35283 .79602 L
.3332 .79254 L
.31358 .78905 L
.29396 .78558 L
.28799 .78454 L
.27433 .78217 L
.25471 .77889 L
.23509 .77582 L
.21546 .77314 L
.19584 .77115 L
.17622 .7704 L
.15659 .77209 L
.13697 .77923 L
.12946 .78454 L
.11735 .80271 L
.11668 .80416 L
.11019 .82378 L
.10645 .84341 L
.10404 .86303 L
.10239 .88265 L
.10123 .90228 L
.10038 .9219 L
.09975 .94152 L
.09929 .96115 L
.09893 .98077 L
.98077 .98077 L
F
0 g
.98077 .88482 m
.96162 .88265 L
.96115 .8826 L
.94152 .88035 L
.9219 .87808 L
.90228 .87578 L
.88265 .87346 L
.86303 .8711 L
.84341 .86871 L
.82378 .86629 L
.80416 .86384 L
.79775 .86303 L
.78454 .86135 L
.76491 .85883 L
.74529 .85628 L
.72567 .85369 L
.70604 .85106 L
.68642 .84839 L
.6668 .84568 L
.65055 .84341 L
.64717 .84293 L
.62755 .84014 L
.60793 .8373 L
.5883 .83442 L
.56868 .83149 L
.54906 .82851 L
.52943 .82549 L
.51851 .82378 L
.50981 .82241 L
.49019 .81929 L
.47057 .81611 L
.45094 .81288 L
.43132 .8096 L
.4117 .80627 L
.39941 .80416 L
.39207 .80289 L
.37245 .79947 L
.35283 .79602 L
.3332 .79254 L
.31358 .78905 L
.29396 .78558 L
.28799 .78454 L
.27433 .78217 L
.25471 .77889 L
.23509 .77582 L
.21546 .77314 L
.19584 .77115 L
.17622 .7704 L
.15659 .77209 L
.13697 .77923 L
Mistroke
.12946 .78454 L
.11735 .80271 L
.11668 .80416 L
.11019 .82378 L
.10645 .84341 L
.10404 .86303 L
.10239 .88265 L
.10123 .90228 L
.10038 .9219 L
.09975 .94152 L
.09929 .96115 L
.09893 .98077 L
Mfstroke
1 .6 0 r
.98077 .11518 m
.96162 .11735 L
.96115 .1174 L
.94152 .11965 L
.9219 .12192 L
.90228 .12422 L
.88265 .12654 L
.86303 .1289 L
.84341 .13129 L
.82378 .13371 L
.80416 .13616 L
.79775 .13697 L
.78454 .13865 L
.76491 .14117 L
.74529 .14372 L
.72567 .14631 L
.70604 .14894 L
.68642 .15161 L
.6668 .15432 L
.65055 .15659 L
.64717 .15707 L
.62755 .15986 L
.60793 .1627 L
.5883 .16558 L
.56868 .16851 L
.54906 .17149 L
.52943 .17451 L
.51851 .17622 L
.50981 .17759 L
.49019 .18071 L
.47057 .18389 L
.45094 .18712 L
.43132 .1904 L
.4117 .19373 L
.39941 .19584 L
.39207 .19711 L
.37245 .20053 L
.35283 .20398 L
.3332 .20746 L
.31358 .21095 L
.29396 .21442 L
.28799 .21546 L
.27433 .21783 L
.25471 .22111 L
.23509 .22418 L
.21546 .22686 L
.19584 .22885 L
.17622 .2296 L
.15659 .22791 L
.13697 .22077 L
.12946 .21546 L
.11735 .19729 L
.11668 .19584 L
.11019 .17622 L
.10645 .15659 L
.10404 .13697 L
.10239 .11735 L
.10123 .09772 L
.10038 .0781 L
.09975 .05848 L
.09929 .03885 L
.09893 .01923 L
.98077 .01923 L
F
0 g
.98077 .11518 m
.96162 .11735 L
.96115 .1174 L
.94152 .11965 L
.9219 .12192 L
.90228 .12422 L
.88265 .12654 L
.86303 .1289 L
.84341 .13129 L
.82378 .13371 L
.80416 .13616 L
.79775 .13697 L
.78454 .13865 L
.76491 .14117 L
.74529 .14372 L
.72567 .14631 L
.70604 .14894 L
.68642 .15161 L
.6668 .15432 L
.65055 .15659 L
.64717 .15707 L
.62755 .15986 L
.60793 .1627 L
.5883 .16558 L
.56868 .16851 L
.54906 .17149 L
.52943 .17451 L
.51851 .17622 L
.50981 .17759 L
.49019 .18071 L
.47057 .18389 L
.45094 .18712 L
.43132 .1904 L
.4117 .19373 L
.39941 .19584 L
.39207 .19711 L
.37245 .20053 L
.35283 .20398 L
.3332 .20746 L
.31358 .21095 L
.29396 .21442 L
.28799 .21546 L
.27433 .21783 L
.25471 .22111 L
.23509 .22418 L
.21546 .22686 L
.19584 .22885 L
.17622 .2296 L
.15659 .22791 L
.13697 .22077 L
Mistroke
.12946 .21546 L
.11735 .19729 L
.11668 .19584 L
.11019 .17622 L
.10645 .15659 L
.10404 .13697 L
.10239 .11735 L
.10123 .09772 L
.10038 .0781 L
.09975 .05848 L
.09929 .03885 L
.09893 .01923 L
Mfstroke
1 0 .3 r
.98077 .94613 m
.96115 .94374 L
.94322 .94152 L
.94152 .94131 L
.9219 .93886 L
.90228 .93639 L
.88265 .93389 L
.86303 .93136 L
.84341 .9288 L
.82378 .92621 L
.80416 .9236 L
.79153 .9219 L
.78454 .92095 L
.76491 .91828 L
.74529 .91558 L
.72567 .91284 L
.70604 .91007 L
.68642 .90728 L
.6668 .90445 L
.65188 .90228 L
.64717 .90159 L
.62755 .8987 L
.60793 .89578 L
.5883 .89283 L
.56868 .88985 L
.54906 .88684 L
.52943 .88381 L
.52196 .88265 L
.50981 .88076 L
.49019 .8777 L
.47057 .87462 L
.45094 .87155 L
.43132 .86848 L
.4117 .86544 L
.39596 .86303 L
.39207 .86244 L
.37245 .85952 L
.35283 .8567 L
.3332 .85405 L
.31358 .85164 L
.29396 .84959 L
.27433 .84806 L
.25471 .84733 L
.23509 .84786 L
.21546 .85046 L
.19584 .85678 L
.18485 .86303 L
.17622 .87074 L
.16693 .88265 L
.15763 .90228 L
.15659 .90522 L
.15173 .9219 L
.14772 .94152 L
.14486 .96115 L
.14274 .98077 L
.98077 .98077 L
F
0 g
.98077 .94613 m
.96115 .94374 L
.94322 .94152 L
.94152 .94131 L
.9219 .93886 L
.90228 .93639 L
.88265 .93389 L
.86303 .93136 L
.84341 .9288 L
.82378 .92621 L
.80416 .9236 L
.79153 .9219 L
.78454 .92095 L
.76491 .91828 L
.74529 .91558 L
.72567 .91284 L
.70604 .91007 L
.68642 .90728 L
.6668 .90445 L
.65188 .90228 L
.64717 .90159 L
.62755 .8987 L
.60793 .89578 L
.5883 .89283 L
.56868 .88985 L
.54906 .88684 L
.52943 .88381 L
.52196 .88265 L
.50981 .88076 L
.49019 .8777 L
.47057 .87462 L
.45094 .87155 L
.43132 .86848 L
.4117 .86544 L
.39596 .86303 L
.39207 .86244 L
.37245 .85952 L
.35283 .8567 L
.3332 .85405 L
.31358 .85164 L
.29396 .84959 L
.27433 .84806 L
.25471 .84733 L
.23509 .84786 L
.21546 .85046 L
.19584 .85678 L
.18485 .86303 L
.17622 .87074 L
.16693 .88265 L
.15763 .90228 L
Mistroke
.15659 .90522 L
.15173 .9219 L
.14772 .94152 L
.14486 .96115 L
.14274 .98077 L
Mfstroke
1 .3 0 r
.98077 .05387 m
.96115 .05626 L
.94322 .05848 L
.94152 .05869 L
.9219 .06114 L
.90228 .06361 L
.88265 .06611 L
.86303 .06864 L
.84341 .0712 L
.82378 .07379 L
.80416 .0764 L
.79153 .0781 L
.78454 .07905 L
.76491 .08172 L
.74529 .08442 L
.72567 .08716 L
.70604 .08993 L
.68642 .09272 L
.6668 .09555 L
.65188 .09772 L
.64717 .09841 L
.62755 .1013 L
.60793 .10422 L
.5883 .10717 L
.56868 .11015 L
.54906 .11316 L
.52943 .11619 L
.52196 .11735 L
.50981 .11924 L
.49019 .1223 L
.47057 .12538 L
.45094 .12845 L
.43132 .13152 L
.4117 .13456 L
.39596 .13697 L
.39207 .13756 L
.37245 .14048 L
.35283 .1433 L
.3332 .14595 L
.31358 .14836 L
.29396 .15041 L
.27433 .15194 L
.25471 .15267 L
.23509 .15214 L
.21546 .14954 L
.19584 .14322 L
.18485 .13697 L
.17622 .12926 L
.16693 .11735 L
.15763 .09772 L
.15659 .09478 L
.15173 .0781 L
.14772 .05848 L
.14486 .03885 L
.14274 .01923 L
.98077 .01923 L
F
0 g
.98077 .05387 m
.96115 .05626 L
.94322 .05848 L
.94152 .05869 L
.9219 .06114 L
.90228 .06361 L
.88265 .06611 L
.86303 .06864 L
.84341 .0712 L
.82378 .07379 L
.80416 .0764 L
.79153 .0781 L
.78454 .07905 L
.76491 .08172 L
.74529 .08442 L
.72567 .08716 L
.70604 .08993 L
.68642 .09272 L
.6668 .09555 L
.65188 .09772 L
.64717 .09841 L
.62755 .1013 L
.60793 .10422 L
.5883 .10717 L
.56868 .11015 L
.54906 .11316 L
.52943 .11619 L
.52196 .11735 L
.50981 .11924 L
.49019 .1223 L
.47057 .12538 L
.45094 .12845 L
.43132 .13152 L
.4117 .13456 L
.39596 .13697 L
.39207 .13756 L
.37245 .14048 L
.35283 .1433 L
.3332 .14595 L
.31358 .14836 L
.29396 .15041 L
.27433 .15194 L
.25471 .15267 L
.23509 .15214 L
.21546 .14954 L
.19584 .14322 L
.18485 .13697 L
.17622 .12926 L
.16693 .11735 L
.15763 .09772 L
Mistroke
.15659 .09478 L
.15173 .0781 L
.14772 .05848 L
.14486 .03885 L
.14274 .01923 L
Mfstroke
1 0 0 r
.74244 .98077 m
.72567 .97845 L
.70604 .97571 L
.68642 .97297 L
.6668 .97023 L
.64717 .96747 L
.62755 .96472 L
.60793 .96197 L
.60201 .96115 L
.5883 .95924 L
.56868 .95652 L
.54906 .95383 L
.52943 .95118 L
.50981 .94859 L
.49019 .94607 L
.47057 .94365 L
.45241 .94152 L
.45094 .94136 L
.43132 .93924 L
.4117 .93735 L
.39207 .93575 L
.37245 .93456 L
.35283 .93391 L
.3332 .93401 L
.31358 .93516 L
.29396 .93787 L
.27854 .94152 L
.27433 .94293 L
.25471 .95185 L
.24179 .96115 L
.23509 .96773 L
.22494 .98077 L
F
0 g
.74244 .98077 m
.72567 .97845 L
.70604 .97571 L
.68642 .97297 L
.6668 .97023 L
.64717 .96747 L
.62755 .96472 L
.60793 .96197 L
.60201 .96115 L
.5883 .95924 L
.56868 .95652 L
.54906 .95383 L
.52943 .95118 L
.50981 .94859 L
.49019 .94607 L
.47057 .94365 L
.45241 .94152 L
.45094 .94136 L
.43132 .93924 L
.4117 .93735 L
.39207 .93575 L
.37245 .93456 L
.35283 .93391 L
.3332 .93401 L
.31358 .93516 L
.29396 .93787 L
.27854 .94152 L
.27433 .94293 L
.25471 .95185 L
.24179 .96115 L
.23509 .96773 L
.22494 .98077 L
s
1 0 0 r
.74244 .01923 m
.72567 .02155 L
.70604 .02429 L
.68642 .02703 L
.6668 .02977 L
.64717 .03253 L
.62755 .03528 L
.60793 .03803 L
.60201 .03885 L
.5883 .04076 L
.56868 .04348 L
.54906 .04617 L
.52943 .04882 L
.50981 .05141 L
.49019 .05393 L
.47057 .05635 L
.45241 .05848 L
.45094 .05864 L
.43132 .06076 L
.4117 .06265 L
.39207 .06425 L
.37245 .06544 L
.35283 .06609 L
.3332 .06599 L
.31358 .06484 L
.29396 .06213 L
.27854 .05848 L
.27433 .05707 L
.25471 .04815 L
.24179 .03885 L
.23509 .03227 L
.22494 .01923 L
F
0 g
.74244 .01923 m
.72567 .02155 L
.70604 .02429 L
.68642 .02703 L
.6668 .02977 L
.64717 .03253 L
.62755 .03528 L
.60793 .03803 L
.60201 .03885 L
.5883 .04076 L
.56868 .04348 L
.54906 .04617 L
.52943 .04882 L
.50981 .05141 L
.49019 .05393 L
.47057 .05635 L
.45241 .05848 L
.45094 .05864 L
.43132 .06076 L
.4117 .06265 L
.39207 .06425 L
.37245 .06544 L
.35283 .06609 L
.3332 .06599 L
.31358 .06484 L
.29396 .06213 L
.27854 .05848 L
.27433 .05707 L
.25471 .04815 L
.24179 .03885 L
.23509 .03227 L
.22494 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{218, 218},
  ImageMargins->{{68.625, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003J0000fQ000`40O003h00OfWoo000AOol2000F
Ool20004Ool20004Ool2000EOol5000COol50002Ool20004Ool2000DOol4000DOol40003Ool20004
Ool2000FOol2000DOol0011oo`04001oogoo000DOol01000Oomoo`0027oo00@007ooOol001Ioo`03
001oogoo01Eoo`03001oogoo00Moo`04001oogoo000COol00`00Oomoo`0EOol00`00Oomoo`09Ool0
1000Oomoo`0057oo00@007ooOol001=oo`0047oo00@007ooOol001Aoo`04001oogoo000;Ool00`00
Oomoo`0DOol00`00Oomoo`0EOol00`00Oomoo`0:Ool00`00Oomoo`0BOol00`00Oomoo`0EOol00`00
Oomoo`0;Ool00`00Oomoo`0DOol00`00Oomoo`0BOol0011oo`04001oogoo000DOol01000Oomoo`00
2Goo0P005goo00<007ooOol05Goo00<007ooOol027oo0P005Woo00<007ooOol05Goo00<007ooOol0
27oo0P0067oo00<007ooOol04Goo000@Ool01000Oomoo`0057oo00@007ooOol000Uoo`03001oogoo
01Ioo`03001oogoo01Eoo`03001oogoo00Qoo`03001oogoo01=oo`04001oogoo000DOol01000Oomo
o`002Goo00<007ooOol057oo00@007ooOol001=oo`004Goo0P005Woo0P002Woo0`005Goo0P005Woo
0P002Woo0`0057oo0P005Woo0P002Woo0`005Goo0P0057oo003JOol00=Yoo`00fWoo003@Ool20000
0goo00000005Ool00=5oo`03001oo`0000Ioo`003goo^`0027oo00<007ooOol01Goo0009Ool20004
Ool01000Oomoo`001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00D007ooOomoo`0000Ioo`800003Ool0000000Eoo`0027oo00@007ooOol000=oo`03001oogoo
0;Moo`03001oogoo00ioo`002Woo00<007ooOol00Woo0P000Woo00<007oo00000Woo00D007ooOomo
o`0000Aoo`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo05aoo`8002ioo`80011oo`000Woo
10001Goo00D007ooOomoo`00009oo`040n8001OP0002?n001@00In1Sh6OP000017n000<007i0OT00
1Gi0018007d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP001FO0070000;Gd0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m0004Ool00`00Oomoo`0>Ool000Qoo`04001oogoo0003Ool04`00Oomo
o`?R000Kh000?n0kh000Hn1Wh6?P001oH7n0Of1oP000009n@00GOV1n@7i0OT1nH000OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@00001?O0070000=7d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dP17oo00<007ooOol03Woo0009Ool20004Ool01`00Oomoo`?R000Gh000
008oh005001Wh6?PIn000004Oh000`00OT1n@006OT004P00OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@0004Ml00L0000kO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m0004Ool00`00Oomoo`0>Ool000moo`07001oogoo0n<001_P00000SoP00/0
06?PIn1Sh000Of1oP7mPOh0007iP00=n@00GOV1n@7i0OT0007d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@00000nO0080000@Wd0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m80Aoo`03001oogoo00ioo`003goo00L007oo
Ool3hP005n000002?n001@00In1Sh6OP000017n000<007i0OT001Wi001@007dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m0000=W`01`0004Ym87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
17oo00<007ooOol03Woo000?Ool200004Goo0n8001_P000oh3_P001Sh6OPHn0007mPOh1oH7n00000
0Wi001YnH7i0OT1n@7iPOT0007d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d00`00
;7`01`00055m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB000goo0P0047oo
000?Ool01`00Oomoo`?R000Gh000008oh005001Wh6?PIn000004Oh000`00OT1n@006OT005`00OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@000P008W`0200005Am87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@050003Ool00`00Oomoo`0>Ool0
00moo`07001oogoo0n<001_P00000SoP00/006?PIn1Sh000Of1oP7mPOh0007iP00=n@00MOV1n@7i0
OT0007d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m8005000BO00;
0000E7d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m80P00004OT1n
H7i0OT04Ool00`00Oomoo`0>Ool000moo`07001oogoo0n8001OP00000SoP00D006OPHn1Wh00000Ao
P003001n@7i000In@00N001m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dP4P0005Qm07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m80L000an@0Aoo`03001oogoo00ioo`003goo01H007ooOol3hP006n0003oP
>n0006?PIn1Sh000Of1oP7mPOh1oH000OT1nH0=n@023OV1n@7i0001m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m80070002
OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@003OV1oogoo009oo`03001oogoo00ioo`00
3goo00L007ooOol3hP005n000002?n001@00In1Sh6OP00001Gn000<007i0OT001Wi007L007d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP00T001Yn@0Ao
o`03001oogoo00ioo`003goo0P0000Eoo`?S000Kh000008oh00;001Sh6OPHn0007mPOh1oH7n0Of00
0003OT00MWiPOT1n@7i0OV0007dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d01P0000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0
OT1n@7iP00=n@003OV1n@7i000=oo`80011oo`003goo00L007ooOol3hP005n000002?n001@00In1S
h6OP00001Gn000<007i0OT001gi006T007dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@001`00:Gi0
17oo00<007ooOol03Woo000?Ool05P00Oomoo`?R000Kh000?n0kh000Hn1Wh6?P001oH7n0Of1oP7mP
001n@7iP0gi006InH7i0OT1n@000O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@070003OT001GiPOT1n@7i0OV000gi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n
@005OV1n@7i0OT1nH004Ool00`00Oomoo`0>Ool000moo`07001oogoo0n8001OP00000SoP00D006OP
Hn1Wh00000EoP003001n@7i000Mn@01J001m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dP2000=gi017oo00<007ooOol03Woo000?Ool01`00Oomoo`?S
000Kh000008oh00;001Sh6OPHn0007mPOh1oH7n0Of000003OT00FGiPOT1n@7i0OV1n@000O@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB001`0000EnH7i0OT1n@7iP00=n@005
OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003
OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH002OT04Ool00`00Oomo
o`0>Ool000moo`07001oogoo0n8001OP00000SoP00D006OPHn1Wh00000EoP003001n@7i000Qn@01;
001m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP00L004In@0Aoo`03001oogoo00ioo`003goo0P00
01Aoo`?R000Kh000?n0kh000Hn1Wh6?P001oH7n0Of1oP7mP001n@7iP0gi004UnH7i0OT1n@7iP001m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m800700001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1n
H003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n
@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT0017iPOT1n@7i00P000Woo0P00
47oo000?Ool01`00Oomoo`?R000Gh000008oh005001Wh6?PIn000005Oh000`00OT1n@009OT00?`00
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m0004001<OT0700000gn0Oomoo`02Ool00`00Oomoo`0>Ool000moo`07001oogoo0n<001_P0000
0SoP00/006?PIn1Sh000Of1oP7mPOh1oH00000=n@005OV1n@7i0OT1nH003OT00=giP001m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP00P00003OT1nH7i0009n@005OV1n
@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT00
1GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV00
0gi02`0000QoH7n0Of1oP7mPOh1oH7n017oo00<007ooOol03Woo000?Ool01`00Oomoo`?R000Gh000
008oh005001Wh6?PIn000005Oh000`00OT1n@00;OT00;P00OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dP1`00AWi01`004gn017oo00<007ooOol03Woo000?Ool05P00Oomoo`?R000Kh000?n0kh000
Hn1Wh6?P001oH7n0Of1oP7mP001n@7iP0gi000EnH7i0OT1n@7iP00=n@00WOV000000O@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dP00L0009n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005
OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003
OT001GiPOT1n@7i0OV000gi000=nH7i0OT00200001YoH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n017oo00<007ooOol03Woo000?Ool01`00Oomoo`?R000Gh000
008oh005001Wh6?PIn000005Oh000`00OT1n@00>OT0200006WdPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@080015OT07000ROh04Ool00`00Oomoo`0>Ool000mo
o`800005Ool3h`006n000002?n002`00Hn1Wh6?P001oH7n0Of1oP7mP00000gi000EnH7i0OT1n@7iP
00=n@005OV1n@7i0OT1nH002OT0200004Gd0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@00
1`000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0
OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005
OV1n@7i0OT1nH003OT000giPOT1n@0070000:Gn0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh000goo0P0047oo
000?Ool01`00Oomoo`?R000Gh000008oh005001Wh6?PIn000006Oh000`00OT1n@00AOT0A0016OT07
000`Oh04Ool00`00Oomoo`0>Ool000moo`0F001oogoo0n8001_P000oh3_P001Sh6OPHn0007mPOh1o
H7n0Of1oP000OV03OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003
OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0
OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0
OT1n@7iP00=n@006OV1n@7i0OT1nH7i0200003MoP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP004Ool00`00Oomoo`0>Ool000moo`07001oogoo0n8001OP00000SoP
00D006OPHn1Wh00000IoP003001n@7i005Un@0L003moP0Aoo`03001oogoo00ioo`0027oo10000goo
00L007ooOol3h`006n000002?n003000Hn1Wh6?P001oH7n0Of1oP7mPOh00009n@005OV1n@7i0OT1n
H003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n
@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT000giPOT0000060000AWmPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n017oo00<007ooOol03Woo0008Ool00`00Oomoo`04Ool00`00Oomoo`020n820002?n001@00In1S
h6OP00001Wn000<007i0OT00Bgi01`00BGn01@000goo00<007ooOol03Woo0009Ool00`00Oomoo`03
Ool200000goo0n83hP0200003coP>n0006?PIn1Sh000Of1oP7mPOh1oH7n0001nH003OT001GiPOT1n
@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n
@003OV00000000H00015Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP00/00004Hn1Wh6?PIn03Ool2000@Ool0009o
o`@000Aoo`03001oogoo009oo`03001oogoo0083hP80008oh005001Wh6?PIn000007Oh000`00OT1n
@00nOT040015Oh0800003f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh004Ool00`00Oomoo`0>
Ool000Qoo`04001oogoo0003Ool01@00Oomoo`?S0n800P000SoP00l006?PIn1Sh000Of1oP7mPOh1o
H7n0Of0007i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000AnH7i0OT1n
@0L0000nOf1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP0/0000GIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h004Ool00`00Oomoo`0>Ool000Uoo`8000Aoo`03001oogoo0083hP80008oh005001Wh6?PIn000008
Oh000`00OT1n@00_OT07000nOh0700008VOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P17oo00<007ooOol03Woo000?Ool00`00Oomo
o`020n82000043oP>n0006?PIn1Sh000Of1oP7mPOh1oH7n0Of1oP0000Wi000EnH7i0OT1n@7iP00=n
@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1n
H003OT000giPOT1n@0040000?WmPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh070000:FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0017oo00<007oo
Ool03Woo000?Ool00`00Oomoo`020n820002?n001@00In1Sh6OP00002Gn000<007i0OT008gi01`00
>gn01`00031Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn04Ool00`00Oomoo`0>Ool0
00moo`800003Ool3h`?R0080008oh00?001Sh6OPHn0007mPOh1oH7n0Of1oP7mPOh1oH00000=n@005
OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@006OV1n@7i0OT1nH7i0
100003MoP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP00;0000
=fOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00=oo`80011o
o`003goo00<007ooOol00P?R0P000SoP00D006OPHn1Wh00000YoP003001n@7i001Mn@0L003=oP0P0
0012In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?P17oo00<007ooOol03Woo000?Ool00`00Oomoo`020n8200004SoP>n0006?P
In1Sh000Of1oP7mPOh1oH7n0Of1oP7mPOh1oH0<00003OT1nH7i0009n@005OV1n@7i0OT1nH003OT00
1GiPOT1n@7i0OV00100003=oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of00
1`0004YSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP17oo00<007ooOol03Woo000?Ool00`00Oomo
o`020n820002?n001@00In1Sh6OP00003Wn010000gi02`00<gn0100004eSh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?P00D000=oo`03001oogoo00ioo`003goo00D007ooOol3h`?R0080008o
h00G001Sh6OPHn1Wh000Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP0030000=gn0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n000L00017In1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh00:000013_P?n0oh3oP17oo00<007ooOol03Woo000?Ool00`00Oomoo`020n82
0002?n001P00In1Sh6OPHn0004AoP0L00012In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P30003SoP17oo00<007ooOol03Woo
000?Ool200000goo0n83hP020000A3oP>n0006?PIn1Sh6OP001oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of080000@FOPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00200000Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00<kh3oPOol00Woo0P00
47oo000?Ool00`00Oomoo`020n820002?n001P00In1Sh6OPHn0003UoP0<0000nHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0/0028oh0Ao
o`03001oogoo00ioo`003goo00D007ooOol3h`?R0080008oh00g001Sh6OPHn1Wh000Oh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh00200003MSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00:00000coP>n0oh002?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<o
h0Aoo`03001oogoo00ioo`003goo00<007ooOol00P?R0P000SoP00H006OPHn1Wh6?P000^Oh030000
=fOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00P003Loh0Ao
o`03001oogoo00ioo`003goo00<007ooOol00P?R0P0002loh3_P001Sh6OPHn1Wh000Oh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n000L0000cIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00L0
0003?n0kh3oP008oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<o
h005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h003?n000c_P?n1oo`03Ool00`00Oomoo`0>Ool000moo`03001oogoo0083hP80008oh007001Wh6?P
In1Sh6OP00008Wn0100002mWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00/004Hoh0Ao
o`03001oogoo00ioo`003goo0P0000=oo`?S0n800P000SoP028006?PIn1Sh6OPHn0007mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH0L0000/Hn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh0L00003?n0kh3oP008oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP
>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP
?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh004
>n0oh3oP?n03Ool2000@Ool000moo`03001oogoo0083hP80008oh008001Wh6?PIn1Sh6OPHn0001Io
P0@0000[Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn002000D3oP2@000goo00<007ooOol03Woo000?
Ool00`00Oomoo`020n82000073oP>n0006?PIn1Sh6OPHn1Wh6?P001oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mP100002QWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0L0008oh005>n0oh3oP?n0kh003
?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP
>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP
?n0oh3_P008oh0l000085n0Kh1OP6n0Gh1_P5n0Kh0Aoo`03001oogoo00ioo`003goo00<007ooOol0
0`?R0P0000/oh000In1Sh6OPHn1Wh6?PIn1Sh00000YoP0H0000VHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0H004Ho
h0X000035n0Kh1OP008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh1OPOol00goo
00<007ooOol03Woo000?Ool01000Oomoo`?S0P?R0P0000/oh000Hn1Wh6?PIn1Sh6OPHn1Wh6?P00X0
000WIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00D00003?n0kh3oP008oh005>n0oh3oP?n0kh003?n001C_P?n0o
h3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n000c_P?n0oh00<00008A_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh004Ool00`00Oomo
o`0>Ool000moo`03001oogoo00<3hP80000e?n0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh007000k?n0:00000aOP6n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0Aoo`03
001oogoo00ioo`003goo0P0000=oo`?R0n800P00038oh3_P001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?P10000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP
>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00@kh3oP
?n0oh0/0000g6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n00
0goo0P0047oo000?Ool00`00Oomoo`020n820002?n00:@00In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn001`00
<3oP2`0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n000a_P5n1oo`03Ool00`00Oomoo`0>Ool000moo`05001oogoo0n<3hP020002
?n009@00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OP00@00005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP
?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P008oh0P0
001=6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh004Ool00`00Oomoo`0>Ool000moo`03
001oogoo0083hP80008oh00N001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OP1`00:3oP2`0000<Gh1_P5n000QOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0Aoo`03001oogoo00ioo`0027oo1@000Woo00<007ooOol00P?R0P00
01doh3_P?n0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
00<00003?n0kh3oP008oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P
00<oh005>n0oh3oP?n0kh003?n000c_P?n0oh0070000G1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n050003Ool00`00Oomoo`0>Ool000Yo
o`03001oogoo009oo`03001oogoo0083hP8000<oh00F001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn04000T?n0700000aOP6n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000QOP3`0010?R17oo00<007ooOol03Woo000:Ool00`00Oomoo`02Ool20000
0goo0n<3hP020003?n004P00In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0@0008oh005
>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh006>n0oh3oP?n0kh3oP
200004TGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh00B00001@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP030n<3hP?R00=oo`80011oo`000Woo100017oo00<007ooOol00Woo00<007ooOol00P?R
0P0013oP00d006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh004000M?n0700025n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0l002D3
hPAoo`03001oogoo00ioo`002Woo00<007ooOol00Woo00<007ooOol00P?R0P0000<oh3_P?n000SoP
0P0000=Sh6OPHn001`0000Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n00
0coP00<kh3oP00001P0003dKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh00<00030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n800`?SOomoo`02Ool00`00Oomoo`0>Ool000Uoo`8000Aoo`03001oogoo0083hP8000Loh0<001do
h0@0008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh00=0010
0n84Ool00`00Oomoo`0>Ool000moo`05001oogoo0n<3hP020003?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n001`00030Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0;00020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n83
hP04Ool00`00Oomoo`0>Ool000moo`03001oogoo0083hP8001`oh0@000<Gh0056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00<Kh00000002@00F0?R17oo00<007ooOol03Woo000?Ool200000goo0n83hP0200000coP
>n0oh002?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh003>n0oh3oP00@0000U6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n002`000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00@3hgooOomoo`80011oo`003goo00<007ooOol00P?R
0P005CoP0`0000<Gh1_P5n000QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00@Kh1OP5n0Gh0P006d3hP8000=oo`03001oogoo00ioo`003goo00D007ooOol3h`?R
008000<oh005>n0oh3oP?n0kh003?n001S_P?n0oh3oP>n0oh0@0000M5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh00700030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP040n<3hP?R0n8F00000`?/
Oomoo`02Ool00`00Oomoo`0>Ool000moo`03001oogoo0083hP03000Kh00000doh0<0008Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0L00503hQH001L3k0Aoo`03
001oogoo00ioo`003goo00<007ooOol00P?R00@001OP000000<oh004>n0oh3oP?n0500005Q_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP1`000`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n80
000A0000;@?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k004Ool00`00Oomoo`0>Ool000moo`03
001oogoo0083hP04000Gh1OP6n020002?n0300001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<G
h0036n0Gh1OP00P003T3hQ<003l3k0Aoo`03001oogoo00ioo`003goo0P0000Uoo`?S0n8001OP6n0G
h1_P5n000P0001<Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh00300001@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n83hP0>0000DP?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0goo0P0047oo000?Ool00`00Oomoo`020n800`006n0G
h0025n001A_P5n0Gh1OP6n000aOP00HKh1OP5n0Gh1_P5n08000W0n8?001P0n`4Ool00`00Oomoo`0>
Ool000moo`03001oogoo0083hP0@000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0300000`?R
0n<3hP020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00P?R2`0006l3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0
17oo00<007ooOol03Woo000?Ool00`00Oomoo`020n8010005n0Gh1_P0aOP00DKh1OP5n0Gh1_P00@0
01`3hP/007X3k0Aoo`03001oogoo00ioo`003goo00d007ooOol3h`?R000Gh1_P5n0Kh1OP6n0Gh004
00020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP030n<3hP?R00/000240n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0P000goo00<007ooOol03Woo000?Ool00`00Oomoo`020n800`006n0Gh002
5n000a_P0000000B0n87001Z0n`U00000`?eOomoo`02Ool00`00Oomoo`0>Ool000moo`800007Ool3
hP?R0n<001_P5n000P000P?R00D3h`?R0n83hP?S00<3hP030n<3hP?R00L0001@0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3jb40000V0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP=oo`80011oo`00
3goo00<007ooOol010?R0P002`?R1000?P?/6@0000<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD00`?f0oEoo`03
Ool00`00Oomoo`0>Ool000moo`04001oogoo0n<30n801@?S0n83hP?R0n<00P?R1P0002`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/5P000603m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH4Ool00`00Oomoo`0>Ool000moo`03
001oogoo00L3hP@00203k1800083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00@3mP?e0oD3m@Aoo`03001oogoo00ioo`003goo00<007ooOol00P?R00<3h`?R0n800P00
01D3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/03`0008P3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mPAoo`03001oogoo00ioo`003goo00<007ooOol01@0030?/2`00
00<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00<3mP?eOol00goo00<007ooOol03Woo000?Ool200002goo0n`3j`?/0n/3k0?[0n`3j`?/0n/01`00
0:83m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3Ool2000@Ool000moo`03001oogoo00H3k0@000030oD3
mP?e0083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD=0003Ool00`00Oomoo`0>Ool000moo`05001oogoo0n`3j`040000A@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP1L000<0ol4Ool00`00Oomoo`0>Ool000moo`03001oogoo008000<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?e0oD0<`00J0?o17oo00<007ooOol03Woo0009Ool2
0004Ool02@00Oomoo`?f0oD3mP?e0oH3m@0B002K0ol4Ool00`00Oomoo`0>Ool000Qoo`04001oogoo
0003Ool00`00Oomoo`06002]0ol4Ool00`00Oomoo`0>Ool000Qoo`04001oogoo0003Ool200000goo
0000002a0ol3Ool2000@Ool000Qoo`04001oogoo0003Ool01@00Oomoo`:o0]l02000Z@?o17oo00<0
07ooOol03Woo0008Ool01000Oomoo`000goo00d007ooOol000:o0]l2_`;O0[l2g`:o0]l2_`0M002<
0ol4Ool00`00Oomoo`0>Ool000Uoo`8000Aoo`04001oogoo0Il200001@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2_ch004h3
o`Aoo`03001oogoo00ioo`003goo00H007ooOol1W`5o0Il30000G`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l0C`000goo00<0
07ooOol03Woo000?Ool00`00Oomoo`060Il800030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]l2_goo
00=oo`03001oogoo00ioo`003goo0P0000moo`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl01`00
09h2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0goo0P0047oo000?Ool00`00Oomoo`06000?0Il;00030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l4Ool00`00Oomoo`0>Ool000mo
o`03001oogoo0080G`0407l0G`1O05l300005`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl04P000842g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l017oo00<007ooOol03Woo000?Ool0
0`00Oomoo`0905l4000U0IlB00000`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00<2g`:oOol00goo00<007ooOol03Woo000?Ool01000Oomoo`1o0`1O00D0O`1O05l0G`1o00<0G`03
07l000000080000c0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o01H0001I
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`04
Ool00`00Oomoo`0>Ool000moo`03001oogoo00@0G`<000X0G`L00481Wad000050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`:o17oo00<007ooOol0
3Woo000?Ool2000027oo05l0G`1o000H7a@O61l200000`1O07l0G`0205l01@1o05l0G`1O07l00`1O
00<0O`1O00001P0005P1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1Wb40000K0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O00=oo`80011oo`003goo00<007ooOol00P1O00@001@O51lH7`8D7`8001D0G`P00741
Wa`000=oo`03001oogoo00ioo`003goo00d007ooOol0O`1O000D7aPO51lH7a@O61lD7`04000205l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0205l;0000P@6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`04Ool00`00Oomoo`0>Ool000moo`03001oogoo0080G`03000H7a@O008D7`0561lD
7a@O51lH7`0251l4000P05l;001f0Il4Ool00`00Oomoo`0>Ool000moo`03001oogoo0080G`0@000D
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l700000`1O07l0G`0205l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O2`0006/1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo00ioo`003goo00<007ooOol00P1O
00@001@O51lH7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O1000:`1O3P00G@6O17oo
00<007ooOol03Woo000?Ool200002Goo07l0G`0051lH7a@O61lD7`0200004aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO00L0000507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0307l0G`0000h0001>0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0goo0P00
47oo000?Ool00`00Oomoo`0205l0100061lD7a@O0P000S`O0`000Q@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l01000?@1O4P00?06O17oo00<007ooOol03Woo000?Ool0
0`00Oomoo`0205l0100051l000000c`O00@h7c`O?1ll7`D0000F61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51l7000305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0F00009P5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il4Ool00`00Oomoo`0>Ool000moo`03001oogoo0080G`03000D7`0000dl7`<00005
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7`0000H005L0
GaH00101W`Aoo`03001oogoo00ioo`003goo00D007ooOol0O`1O008000<l7`05>1ll7c`O?1lh7`03
?1l01SPO?1ll7c`O>1ll7`@0000M51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7`0;000305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0205lA0003Ool00`00Oomoo`0>Ool000mo
o`03001oogoo0080G`8001Dl7`<000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51l00006001[05l4Ool00`00Oomoo`0>Ool0
00moo`800003Ool0G`1O00800003?1lh7c`O008l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00<h7c`O?1l0100002PH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`/000<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00=oo`80011o
o`003goo00<007ooOol00P1O0P0073`O200000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O2`00
E@1O17oo00<007ooOol03Woo000?Ool01@00Oomoo`1o05l00P000c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`0g>1l00000000D7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l02`000`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00P1O17oo00<007ooOol03Woo000?Ool00`00Oomoo`0205l20005?1l9000I?1l800001APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7`l003/0G`Aoo`03001o
ogoo00ioo`0027oo1@000Woo00<007ooOol00P1O0P0000hl7cPO?1ll7`00H1mT7f0OI1mP7f@OH1mT
7f0O0`0000Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Hh7c`O
?1ll7cPO?1l70000?QPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51l>00001@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`04Ool00`00
Oomoo`0>Ool000Yoo`03001oogoo009oo`03001oogoo0080G`8000@l7`0=001T7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l010008C`O1`0000DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l03`007P1O17oo00<007ooOol0
3Woo000:Ool00`00Oomoo`02Ool200000goo07l0G`020003?1l04P00I1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7`@0008l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l00cPO?1l000060000CAPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61l03`0000D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0205l3Ool2000@Ool0
00Yoo`03001oogoo009oo`03001oogoo0080G`8000<l7`0F001P7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1l7000T?1l8000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00<H7`0000003P000goo00<007ooOol03Woo000:Ool00`00Oomoo`02Ool00`00
Oomoo`0205l2000083`O>1ll7`00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1l400000c`O>1ll7`02?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7c`O?1l01`0005`D7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO17oo00<0
07ooOol03Woo0009Ool20004Ool00`00Oomoo`0205l20002?1l08P00I1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0`00;3`O2`000a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l4Ool00`00Oomoo`0>Ool000moo`05
001oogoo07l0G`020002?1l09@00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O00H0008l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO008l7`L0001:51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`Aoo`03001oogoo
00ioo`003goo00<007ooOol00P1O0P000S`O02X006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l6000c?1l;
000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H
7a@O51lD7`Aoo`03001oogoo00ioo`003goo0P0000=oo`1O05l00P00038l7cPO001P7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O1`0000Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO008l7`/0000d51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61l3Ool2000@Ool000moo`03001oogoo00<0G`80000h?1l006@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`@003hl7`/000<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD
7`Aoo`03001oogoo00ioo`003goo00@007ooOol0O`80G`80000;?1l0060OI1mP7f@OH1mT7f0OI1mP
7`0=0000960OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`L000<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00S`O2`0001hD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l4Ool00`00Oomoo`0>Ool000moo`03
001oogoo00<0G`80000;?1l006@OH1mT7f0OI1mP7f@OH1l0000=O1`30000:60OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@O2000AC`O3`000a@O00DH7a@O51lD7aPO00<D7`0461lD7a@O51l4Ool00`00Oomoo`0>Ool0
00moo`03001oogoo0080G`80000L?1lh7`00H1mT7f0OI1mP7f@OH1l007`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1/80000:6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O1`000S`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00<h7c`O?1l02`0000@D7aPO51lH7`Aoo`03001oogoo00ioo`003goo00<007oo
Ool00P1O0P000S`O00P006@OH1mT7f0OI1mP7`006W`L0`0002aT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0O1`00DC`O1@000goo00<007ooOol03Woo000?Ool200000goo07l0G`020002?1l09@00H1mT
7f0OI1mP7`00O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`L00@0000_H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0800000c`O>1ll
7`02?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l3Ool2000@Ool000moo`03001oogoo0080G`80008l
7`06001T7f0OI1mP7`008g`L1`00031P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l7
0016?1l4Ool00`00Oomoo`0>Ool000moo`03001oogoo0080G`80000b?1lh7`00H1mT7f0OI1l007`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6`@0000cI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O00/00003?1lh7c`O008l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`06>1ll7c`O?1lh7c`O17oo00<007ooOol03Woo000?Ool00`00Oomoo`0205l20002?1l01P00I1mP
7f@OH1l002il70L0000gI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1l02000<c`O17oo00<007ooOol03Woo000?Ool01@00Oomoo`1o05l00P000S`O03/0060OI1mP
7f@O001l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L00@0000kH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0:0000
0c`O>1ll7`02?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00@h7c`O?1ll7`Aoo`03001oogoo00ioo`003goo00<007ooOol00P1O0P00
0S`O00H006@OH1mT7f0O000iO1`70000?V0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l7000R?1l4Ool00`00Oomoo`0>Ool000moo`800003
Ool0G`1O00800018?1lh7`00H1mT7f0OI1l007`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K1`0003iP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O2`0000<l7cPO?1l00S`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l00cPO?1moo`02Ool2000@Ool000moo`03001o
ogoo0080G`80008l7`06001T7f0OI1mP7`00Ag`L100004ET7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l02`0033`O
17oo00<007ooOol03Woo000?Ool01@00Oomoo`1o05l00P000S`O01@0060OI1mP7f@O001l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`K2P0003=l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1`01`0004UT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0;00000c`OOomoo`02Ool00`00
Oomoo`0>Ool000moo`03001oogoo0080G`80008l7`05001T7f0OI1l0000=O1`2000:O187000cO1`8
0000C60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0P000goo00<007ooOol03Woo000?Ool0
0`00Oomoo`0205l200004S`O>1l0060OI1mP7`00O1]l77`KO1al6g`LO1]l77`KO1al6`80009l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4`0000001@0003Al77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`L00016H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l4Ool00`00
Oomoo`0>Ool000moo`800003Ool0G`1O0080008l7`05001T7f0OI1l0000:O1`00`00O19l4P0JO184
000gO1`70000?f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7`03Ool2000@Ool000moo`05001oogoo07l0G`020002?1l03`00H1mT7f0O
001l6g`LO1]l77`KO1al6g`LO1/00003O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801W`CO19l4W`BO1=l4PL0000gO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1/0200003MT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`04Ool00`00Oomoo`0>Ool000moo`03001oogoo0080G`80008l7`05
001T7f0OI1l00009O1`00`00O19l4P0VO184000kO1`70000<6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`Aoo`03001oogoo00ioo`003goo00<007ooOol00P1O0P00010l7cPO001P7f@O
H1l007`KO1al6g`LO1]l77`KO1`0009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`BO180200003Yl
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l70/0000U
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1l017oo00<007ooOol03Woo0008Ool40003Ool00`00Oomoo`0205l20002?1l0
1@00I1mP7f@O00001g`L00<007`BO180=7`B1`00?W`L1`0001iT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l4Ool00`00Oomoo`0>Ool000Qoo`03
001oogoo00Aoo`05001oogoo07l0G`020002?1l03`00H1mT7f0O001l6g`LO1]l77`KO1al6`00O19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B0`00
049l6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1`;00004f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O00Ao
o`03001oogoo00ioo`002Goo00<007ooOol00goo0P0000=oo`1O05l00P000S`O00D006@OH1mT7`00
00Il7003001l4W`B03ml4PP004El70L0000<I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0goo0P0047oo
000:Ool00`00Oomoo`02Ool00`00Oomoo`0205l200003c`O>1l0060OI1mP7`00O1]l77`KO1al6g`L
001l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`070000AG`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l700;00000f@O
Oomoo`02Ool00`00Oomoo`0>Ool000Qoo`04001oogoo0003Ool00`00Oomoo`0205l20002?1l01@00
I1mP7f@O00001W`L00<007`BO180CW`B1`00BG`L0P000goo00<007ooOol03Woo0009Ool20004Ool0
1`00Oomoo`1o000H7`00008l7`0<001P7f@OH1l007`KO1al6g`LO1]l70000W`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`040000AW`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`L17oo00<007ooOol03Woo000?Ool01`00Oomoo`1O000D7`00008l7`05001T7f0OI1l00006
O1`00`00O19l4P1IO187000oO1`4Ool00`00Oomoo`0>Ool000moo`0F001oogoo05l001PO000l7cPO
001P7f@OH1l007`KO1al6g`LO1]l7000O1<3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`040003O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P03O1=l4P0000L0000gO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`017oo00<007ooOol03Woo000?Ool200001Goo
05l001@O00000S`O00D006@OH1mT7`0000Il7003001l4W`B011l4PL00004O0Ul27`9O0P;0012O187
000`O1`3Ool2000@Ool000moo`07001oogoo07l001PO00000S`O00/0060OI1mP7`00O1]l77`KO1al
6`0000=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00`0001Il2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20L000=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00W`B1`0002Ul77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`L00Aoo`03001oogoo00ioo`003goo00L007ooOol0G`0051l00002?1l01@00I1mP7f@O0000
1G`L00<007`BO18037`B0P00021l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`81`00@W`B20008G`L17oo00<007ooOol03Woo000?Ool05P00
Oomoo`1O000H7`00?1lh7`00H1mT7f0O001l6g`LO1]l77`K001l4W`C0g`B00El4g`BO19l4W`C00=l
4P0Z001l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`820000W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18:00005g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`017oo00<007ooOol03Woo000?Ool01`00Oomo
o`1O000D7`00008l7`05001T7f0OI1l00005O1`00`00O19l4P0;O180<P00O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T30019O188000?O1`4Ool00`00Oomoo`0>Ool000moo`07001o
ogoo07l001PO00000S`O00/0060OI1mP7`00O1]l77`KO1al6`0000=l4P05O1=l4W`BO19l4`03O180
=g`C001l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900P00003O19l
4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00Al4g`BO19l4PL00008O1]l77`KO1al6g`LO1]l70Aoo`03001oogoo00io
o`003goo0P0000Eoo`1O000D7`00008l7`05001T7f0OI1l00005O1`00`00O19l4P09O180?`00O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
20070019O1890002Ool2000@Ool000moo`0F001oogoo05l001PO000l7cPO001P7f@OH1l007`KO1al
6g`LO1/007`BO1<3O180C7`CO19l4W`BO1<007`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`81`0000=l4W`CO180
0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<017oo00<007ooOol03Woo000?Ool01`00Oomoo`1O000D7`00
008l7`05001T7f0OI1l00005O1`00`00O19l4P08O180CP00O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul20P0049l4PAoo`03001oogoo00ioo`003goo00L007ooOol0O`0061l00002?1l02`00
H1mT7f0O001l6g`LO1]l77`K00000g`B05el4g`BO19l4W`CO18007`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T00`0000El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`02O184Ool00`00Oomoo`0>Ool0
00moo`07001oogoo05l001@O00000S`O00D006@OH1mT7`0000El7003001l4W`B00Ml4P1J001l2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`92000=g`B
17oo00<007ooOol03Woo000?Ool05P00Oomoo`1O000H7`00?1lh7`00H1mT7f0O001l6g`LO1]l77`K
001l4W`C0g`B06Il4g`BO19l4P00O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P70003O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`04Ool00`00Oomoo`0>Ool000moo`800005Ool0G`0051l00002?1l01@00I1mP
7f@O00001G`L00<007`BO1801W`B06X007`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20L002Ul
4P=oo`80011oo`003goo00L007ooOol0O`0061l00002?1l02`00H1mT7f0O001l6g`LO1]l77`K0000
0g`B07Il4g`BO19l4W`C001l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
20P0009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`02O184Ool00`00Oomoo`0>Ool000moo`07001oogoo05l001@O00000S`O00D006@OH1mT
7`0000El7003001l4W`B00Il4P1i001l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T01`006W`B17oo00<007ooOol03Woo000?Ool04`00Oomoo`1O
000H7`00?1lh7`00H1mT7f0O001l6g`LO1]l7000009l4P27O1=l4W`BO19l4g`B001l27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`900L0009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4gooOol00Woo00<0
07ooOol03Woo000?Ool01`00Oomoo`1O000D7`00008l7`05001T7f0OI1l00004O1`00`00O19l4P06
O1806`00O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200I
0000E7`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@/000Ql4PAo
o`03001oogoo00ioo`003goo00L007ooOol0O`0061l00002?1l02`00H1mT7f0O001l6g`LO1]l7000
O1<00g`B01al4g`BO19l4P00O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul20<001Ul00/0001DO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`91`0000=l4WooOol00Woo00<007ooOol03Woo000?Ool200001Goo05l001@O00000S`O00D006@O
H1mT7`0000Al7003001l4W`B00Il4P0F001l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0T2000WO0070000E7`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2@80009oo`80011oo`003goo01<007ooOol0G`0061l003`O>1l0060OI1mP7`00O1]l77`K
O1`00002O1806W`CO19l4W`BO1=l4P00O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0P2000`O0080000CG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T017oo00<007ooOol0
3Woo000?Ool01`00Oomoo`1O000D7`00008l7`05001T7f0OI1l00004O1`00`00O19l4P06O1805000
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8000jO0060000Ag`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0P017oo00<007ooOol03Woo000?Ool01`00Oomoo`1o000H7`00008l7`0;001P7f@OH1l0
07`KO1al6g`L001l4`03O1805g`CO19l4W`B001l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`80000@G`0200003ml2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0T017oo00<007ooOol03Woo0009Ool20004Ool01`00Oomoo`1O000D
7`00008l7`05001T7f0OI1l00004O1`00`00O19l4P06O1804P00O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0P004Yl00P0000gO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0P017oo00<007ooOol03Woo0008Ool01000Oomoo`000goo01<007ooOol0G`0061l0
03`O>1l0060OI1mP7`00O1]l77`KO1`00002O1805g`CO19l4W`BO1<007`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`80000Dg`01`00031l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0T4Ool00`00Oomoo`0>Ool000Yoo`03001oogoo009oo`800005Ool0G`0051l00002?1l01@00I1mP
7f@O000017`L00<007`BO1801G`B014007`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200005]l
00D0000[O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P00goo0P0047oo000;Ool01@00Oomoogoo0000
^Goo00<007ooOol03Woo0008Ool01000Oomoo`000goo00<007ooOol0]goo00<007ooOol03Woo0009
Ool20004Ool01000Oomoo`001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00D007ooOomoo`00011oo`003goo^`0047oo003JOol00=Yoo`00fWoo003JOol00=Yo
o`00fWoo003JOol000eoo`800<]oo`003Woo00<007ooOol0bGoo000?Ool00`00Oomoo`38Ool000io
o`03001oo`000<Uoo`003Goo00@007ooOol00<Uoo`0037oo0`0000=oo`000000b7oo003JOol00=Yo
o`00fWoo003JOol00=Yoo`00fWoo0000\
\>"],
  ImageRangeCache->{{{0, 217}, {217, 0}} -> {-0.305997, -3.49994, 0.0167163, \
0.0335445}}]
}, Open  ]],

Cell[TextData[{
  "The representation of the stream lines shows that the jet fans out and \
that the velocity decreases for larger values of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". This behavior is obvious in a graphical representation of the velocity \
for the two components"
}], "Text",
  Evaluatable->False,
  CellTags->"stream lines"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u = \[PartialD]\_y so1\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Sech[y\/\(\@6\ x\^\(2/3\)\)]\^2\/x\^\(1/3\)\)], "Output"]
}, Open  ]],

Cell["and", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(v = \(-\[PartialD]\_x so1\)\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(2\ y\ Sech[y\/\(\@6\ x\^\(2/3\)\)]\^2\)\/\(3\ x\^\(4/3\)\) - 
      \(\@\(2\/3\)\ Tanh[y\/\(\@6\ x\^\(2/3\)\)]\)\/x\^\(2/3\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which both follow as derivatives from the stream function. We represent \
the two solutions by a contour plot. The velocity in the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " direction is"
}], "Text",
  Evaluatable->False,
  CellTags->"stream function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[u, {x,  .01, 3}, {y, \(-3\), 3}, PlotPoints \[Rule] 50, 
      Contours \[Rule] 20, ColorFunction \[Rule] Hue, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0160149 0.321585 0.5 0.160256 [
[.01601 -0.0125 -3 -9 ]
[.01601 -0.0125 3 0 ]
[.17681 -0.0125 -9 -9 ]
[.17681 -0.0125 9 0 ]
[.3376 -0.0125 -3 -9 ]
[.3376 -0.0125 3 0 ]
[.49839 -0.0125 -9 -9 ]
[.49839 -0.0125 9 0 ]
[.65918 -0.0125 -3 -9 ]
[.65918 -0.0125 3 0 ]
[.81998 -0.0125 -9 -9 ]
[.81998 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .17949 -12 -4.5 ]
[-0.0125 .17949 0 4.5 ]
[-0.0125 .33974 -12 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .66026 -6 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .82051 -6 -4.5 ]
[-0.0125 .82051 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01601 0 m
.01601 .00625 L
s
[(0)] .01601 -0.0125 0 1 Mshowa
.17681 0 m
.17681 .00625 L
s
[(0.5)] .17681 -0.0125 0 1 Mshowa
.3376 0 m
.3376 .00625 L
s
[(1)] .3376 -0.0125 0 1 Mshowa
.49839 0 m
.49839 .00625 L
s
[(1.5)] .49839 -0.0125 0 1 Mshowa
.65918 0 m
.65918 .00625 L
s
[(2)] .65918 -0.0125 0 1 Mshowa
.81998 0 m
.81998 .00625 L
s
[(2.5)] .81998 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(3)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.04817 0 m
.04817 .00375 L
s
.08033 0 m
.08033 .00375 L
s
.11249 0 m
.11249 .00375 L
s
.14465 0 m
.14465 .00375 L
s
.20897 0 m
.20897 .00375 L
s
.24112 0 m
.24112 .00375 L
s
.27328 0 m
.27328 .00375 L
s
.30544 0 m
.30544 .00375 L
s
.36976 0 m
.36976 .00375 L
s
.40192 0 m
.40192 .00375 L
s
.43408 0 m
.43408 .00375 L
s
.46623 0 m
.46623 .00375 L
s
.53055 0 m
.53055 .00375 L
s
.56271 0 m
.56271 .00375 L
s
.59487 0 m
.59487 .00375 L
s
.62703 0 m
.62703 .00375 L
s
.69134 0 m
.69134 .00375 L
s
.7235 0 m
.7235 .00375 L
s
.75566 0 m
.75566 .00375 L
s
.78782 0 m
.78782 .00375 L
s
.85214 0 m
.85214 .00375 L
s
.88429 0 m
.88429 .00375 L
s
.91645 0 m
.91645 .00375 L
s
.94861 0 m
.94861 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-3)] -0.0125 .01923 1 0 Mshowa
0 .17949 m
.00625 .17949 L
s
[(-2)] -0.0125 .17949 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(-1)] -0.0125 .33974 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(1)] -0.0125 .66026 1 0 Mshowa
0 .82051 m
.00625 .82051 L
s
[(2)] -0.0125 .82051 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(3)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05128 m
.00375 .05128 L
s
0 .08333 m
.00375 .08333 L
s
0 .11538 m
.00375 .11538 L
s
0 .14744 m
.00375 .14744 L
s
0 .21154 m
.00375 .21154 L
s
0 .24359 m
.00375 .24359 L
s
0 .27564 m
.00375 .27564 L
s
0 .30769 m
.00375 .30769 L
s
0 .37179 m
.00375 .37179 L
s
0 .40385 m
.00375 .40385 L
s
0 .4359 m
.00375 .4359 L
s
0 .46795 m
.00375 .46795 L
s
0 .53205 m
.00375 .53205 L
s
0 .5641 m
.00375 .5641 L
s
0 .59615 m
.00375 .59615 L
s
0 .62821 m
.00375 .62821 L
s
0 .69231 m
.00375 .69231 L
s
0 .72436 m
.00375 .72436 L
s
0 .75641 m
.00375 .75641 L
s
0 .78846 m
.00375 .78846 L
s
0 .85256 m
.00375 .85256 L
s
0 .88462 m
.00375 .88462 L
s
0 .91667 m
.00375 .91667 L
s
0 .94872 m
.00375 .94872 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01601 .99375 m
.01601 1 L
s
.17681 .99375 m
.17681 1 L
s
.3376 .99375 m
.3376 1 L
s
.49839 .99375 m
.49839 1 L
s
.65918 .99375 m
.65918 1 L
s
.81998 .99375 m
.81998 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.04817 .99625 m
.04817 1 L
s
.08033 .99625 m
.08033 1 L
s
.11249 .99625 m
.11249 1 L
s
.14465 .99625 m
.14465 1 L
s
.20897 .99625 m
.20897 1 L
s
.24112 .99625 m
.24112 1 L
s
.27328 .99625 m
.27328 1 L
s
.30544 .99625 m
.30544 1 L
s
.36976 .99625 m
.36976 1 L
s
.40192 .99625 m
.40192 1 L
s
.43408 .99625 m
.43408 1 L
s
.46623 .99625 m
.46623 1 L
s
.53055 .99625 m
.53055 1 L
s
.56271 .99625 m
.56271 1 L
s
.59487 .99625 m
.59487 1 L
s
.62703 .99625 m
.62703 1 L
s
.69134 .99625 m
.69134 1 L
s
.7235 .99625 m
.7235 1 L
s
.75566 .99625 m
.75566 1 L
s
.78782 .99625 m
.78782 1 L
s
.85214 .99625 m
.85214 1 L
s
.88429 .99625 m
.88429 1 L
s
.91645 .99625 m
.91645 1 L
s
.94861 .99625 m
.94861 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .17949 m
1 .17949 L
s
.99375 .33974 m
1 .33974 L
s
.99375 .5 m
1 .5 L
s
.99375 .66026 m
1 .66026 L
s
.99375 .82051 m
1 .82051 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05128 m
1 .05128 L
s
.99625 .08333 m
1 .08333 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .14744 m
1 .14744 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .24359 m
1 .24359 L
s
.99625 .27564 m
1 .27564 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .37179 m
1 .37179 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .4359 m
1 .4359 L
s
.99625 .46795 m
1 .46795 L
s
.99625 .53205 m
1 .53205 L
s
.99625 .5641 m
1 .5641 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .62821 m
1 .62821 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .72436 m
1 .72436 L
s
.99625 .75641 m
1 .75641 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .85256 m
1 .85256 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .91667 m
1 .91667 L
s
.99625 .94872 m
1 .94872 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .4 r
.01923 .46835 m
.02324 .45094 L
.02755 .43132 L
.03851 .4117 L
.03885 .40673 L
.04549 .39207 L
.0574 .37245 L
.05848 .37068 L
.07051 .35283 L
.0781 .34324 L
.08615 .3332 L
.09772 .32047 L
.10419 .31358 L
.11735 .30084 L
.12479 .29396 L
.13697 .28351 L
.14825 .27433 L
.15659 .26796 L
.17494 .25471 L
.17622 .25384 L
.19584 .24092 L
.20524 .23509 L
.21546 .22902 L
.23509 .21799 L
.23979 .21546 L
.25471 .20774 L
.27433 .19817 L
.27932 .19584 L
.29396 .18922 L
.31358 .18083 L
.3249 .17622 L
.3332 .17295 L
.35283 .16553 L
.37245 .15854 L
.37813 .15659 L
.39207 .15196 L
.4117 .14574 L
.43132 .13988 L
.44149 .13697 L
.45094 .13435 L
.47057 .12912 L
.49019 .12419 L
.50981 .11954 L
.51948 .11735 L
.52943 .11516 L
.54906 .11102 L
.56868 .10714 L
.5883 .10348 L
.60793 .10005 L
.62198 .09772 L
.62755 .09683 L
.64717 .09383 L
.6668 .09102 L
.68642 .08841 L
.70604 .08598 L
.72567 .08375 L
.74529 .08169 L
.76491 .0798 L
.78435 .0781 L
.78454 .07808 L
.80416 .07654 L
.82378 .07515 L
.84341 .07392 L
.86303 .07285 L
.88265 .07194 L
.90228 .07117 L
.9219 .07056 L
.94152 .07009 L
.96115 .06977 L
.98077 .06959 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .46835 m
.02324 .45094 L
.02755 .43132 L
.03851 .4117 L
.03885 .40673 L
.04549 .39207 L
.0574 .37245 L
.05848 .37068 L
.07051 .35283 L
.0781 .34324 L
.08615 .3332 L
.09772 .32047 L
.10419 .31358 L
.11735 .30084 L
.12479 .29396 L
.13697 .28351 L
.14825 .27433 L
.15659 .26796 L
.17494 .25471 L
.17622 .25384 L
.19584 .24092 L
.20524 .23509 L
.21546 .22902 L
.23509 .21799 L
.23979 .21546 L
.25471 .20774 L
.27433 .19817 L
.27932 .19584 L
.29396 .18922 L
.31358 .18083 L
.3249 .17622 L
.3332 .17295 L
.35283 .16553 L
.37245 .15854 L
.37813 .15659 L
.39207 .15196 L
.4117 .14574 L
.43132 .13988 L
.44149 .13697 L
.45094 .13435 L
.47057 .12912 L
.49019 .12419 L
.50981 .11954 L
.51948 .11735 L
.52943 .11516 L
.54906 .11102 L
.56868 .10714 L
.5883 .10348 L
.60793 .10005 L
.62198 .09772 L
Mistroke
.62755 .09683 L
.64717 .09383 L
.6668 .09102 L
.68642 .08841 L
.70604 .08598 L
.72567 .08375 L
.74529 .08169 L
.76491 .0798 L
.78435 .0781 L
.78454 .07808 L
.80416 .07654 L
.82378 .07515 L
.84341 .07392 L
.86303 .07285 L
.88265 .07194 L
.90228 .07117 L
.9219 .07056 L
.94152 .07009 L
.96115 .06977 L
.98077 .06959 L
Mfstroke
0 1 .7 r
.01923 .46947 m
.02397 .45094 L
.02896 .43132 L
.03881 .4117 L
.03885 .41129 L
.04886 .39207 L
.05848 .37825 L
.06214 .37245 L
.0781 .35321 L
.07841 .35283 L
.09725 .3332 L
.09772 .33276 L
.11735 .31534 L
.11944 .31358 L
.13697 .30016 L
.14564 .29396 L
.15659 .2867 L
.17622 .27464 L
.17674 .27433 L
.19584 .26376 L
.21371 .25471 L
.21546 .25387 L
.23509 .24486 L
.25471 .2366 L
.25849 .23509 L
.27433 .22904 L
.29396 .22209 L
.31358 .2157 L
.31433 .21546 L
.3332 .20982 L
.35283 .20443 L
.37245 .19947 L
.38798 .19584 L
.39207 .19493 L
.4117 .19077 L
.43132 .18699 L
.45094 .18355 L
.47057 .18044 L
.49019 .17765 L
.50116 .17622 L
.50981 .17516 L
.52943 .17296 L
.54906 .17105 L
.56868 .1694 L
.5883 .16802 L
.60793 .1669 L
.62755 .16603 L
.64717 .16541 L
.6668 .16502 L
.68642 .16487 L
.70604 .16496 L
.72567 .16528 L
.74529 .16582 L
.76491 .16659 L
.78454 .16759 L
.80416 .16881 L
.82378 .17026 L
.84341 .17193 L
.86303 .17383 L
.88265 .17595 L
.88494 .17622 L
.90228 .17831 L
.9219 .1809 L
.94152 .18373 L
.96115 .18679 L
.98077 .19011 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .46947 m
.02397 .45094 L
.02896 .43132 L
.03881 .4117 L
.03885 .41129 L
.04886 .39207 L
.05848 .37825 L
.06214 .37245 L
.0781 .35321 L
.07841 .35283 L
.09725 .3332 L
.09772 .33276 L
.11735 .31534 L
.11944 .31358 L
.13697 .30016 L
.14564 .29396 L
.15659 .2867 L
.17622 .27464 L
.17674 .27433 L
.19584 .26376 L
.21371 .25471 L
.21546 .25387 L
.23509 .24486 L
.25471 .2366 L
.25849 .23509 L
.27433 .22904 L
.29396 .22209 L
.31358 .2157 L
.31433 .21546 L
.3332 .20982 L
.35283 .20443 L
.37245 .19947 L
.38798 .19584 L
.39207 .19493 L
.4117 .19077 L
.43132 .18699 L
.45094 .18355 L
.47057 .18044 L
.49019 .17765 L
.50116 .17622 L
.50981 .17516 L
.52943 .17296 L
.54906 .17105 L
.56868 .1694 L
.5883 .16802 L
.60793 .1669 L
.62755 .16603 L
.64717 .16541 L
.6668 .16502 L
.68642 .16487 L
Mistroke
.70604 .16496 L
.72567 .16528 L
.74529 .16582 L
.76491 .16659 L
.78454 .16759 L
.80416 .16881 L
.82378 .17026 L
.84341 .17193 L
.86303 .17383 L
.88265 .17595 L
.88494 .17622 L
.90228 .17831 L
.9219 .1809 L
.94152 .18373 L
.96115 .18679 L
.98077 .19011 L
Mfstroke
0 1 1 r
.01923 .47049 m
.02472 .45094 L
.03046 .43132 L
.03885 .41575 L
.03957 .4117 L
.05293 .39207 L
.05848 .38515 L
.06822 .37245 L
.0781 .36241 L
.08755 .35283 L
.09772 .34411 L
.11119 .3332 L
.11735 .32878 L
.13697 .31563 L
.14022 .31358 L
.15659 .3042 L
.17622 .29415 L
.17661 .29396 L
.19584 .28526 L
.21546 .27738 L
.22364 .27433 L
.23509 .27037 L
.25471 .26414 L
.27433 .2586 L
.2897 .25471 L
.29396 .25371 L
.31358 .2494 L
.3332 .24563 L
.35283 .24237 L
.37245 .23959 L
.39207 .23726 L
.4117 .23536 L
.41471 .23509 L
.43132 .23387 L
.45094 .23278 L
.47057 .23207 L
.49019 .23174 L
.50981 .23178 L
.52943 .23217 L
.54906 .23292 L
.56868 .23403 L
.58345 .23509 L
.5883 .23548 L
.60793 .23729 L
.62755 .23944 L
.64717 .24196 L
.6668 .24484 L
.68642 .24809 L
.70604 .25172 L
.72083 .25471 L
.72567 .25574 L
.74529 .26016 L
.76491 .26502 L
.78454 .27032 L
.79832 .27433 L
.80416 .2761 L
.82378 .28239 L
.84341 .28923 L
.85605 .29396 L
.86303 .29667 L
.88265 .30478 L
.90213 .31358 L
.90228 .31365 L
.9219 .32336 L
.93998 .3332 L
.94152 .33408 L
.96115 .346 L
.9714 .35283 L
.98077 .35944 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .47049 m
.02472 .45094 L
.03046 .43132 L
.03885 .41575 L
.03957 .4117 L
.05293 .39207 L
.05848 .38515 L
.06822 .37245 L
.0781 .36241 L
.08755 .35283 L
.09772 .34411 L
.11119 .3332 L
.11735 .32878 L
.13697 .31563 L
.14022 .31358 L
.15659 .3042 L
.17622 .29415 L
.17661 .29396 L
.19584 .28526 L
.21546 .27738 L
.22364 .27433 L
.23509 .27037 L
.25471 .26414 L
.27433 .2586 L
.2897 .25471 L
.29396 .25371 L
.31358 .2494 L
.3332 .24563 L
.35283 .24237 L
.37245 .23959 L
.39207 .23726 L
.4117 .23536 L
.41471 .23509 L
.43132 .23387 L
.45094 .23278 L
.47057 .23207 L
.49019 .23174 L
.50981 .23178 L
.52943 .23217 L
.54906 .23292 L
.56868 .23403 L
.58345 .23509 L
.5883 .23548 L
.60793 .23729 L
.62755 .23944 L
.64717 .24196 L
.6668 .24484 L
.68642 .24809 L
.70604 .25172 L
.72083 .25471 L
Mistroke
.72567 .25574 L
.74529 .26016 L
.76491 .26502 L
.78454 .27032 L
.79832 .27433 L
.80416 .2761 L
.82378 .28239 L
.84341 .28923 L
.85605 .29396 L
.86303 .29667 L
.88265 .30478 L
.90213 .31358 L
.90228 .31365 L
.9219 .32336 L
.93998 .3332 L
.94152 .33408 L
.96115 .346 L
.9714 .35283 L
.98077 .35944 L
Mfstroke
0 1 .7 r
.01923 .52951 m
.02472 .54906 L
.03046 .56868 L
.03885 .58425 L
.03957 .5883 L
.05293 .60793 L
.05848 .61485 L
.06822 .62755 L
.0781 .63759 L
.08755 .64717 L
.09772 .65589 L
.11119 .6668 L
.11735 .67122 L
.13697 .68437 L
.14022 .68642 L
.15659 .6958 L
.17622 .70585 L
.17661 .70604 L
.19584 .71474 L
.21546 .72262 L
.22364 .72567 L
.23509 .72963 L
.25471 .73586 L
.27433 .7414 L
.2897 .74529 L
.29396 .74629 L
.31358 .7506 L
.3332 .75437 L
.35283 .75763 L
.37245 .76041 L
.39207 .76274 L
.4117 .76464 L
.41471 .76491 L
.43132 .76613 L
.45094 .76722 L
.47057 .76793 L
.49019 .76826 L
.50981 .76822 L
.52943 .76783 L
.54906 .76708 L
.56868 .76597 L
.58345 .76491 L
.5883 .76452 L
.60793 .76271 L
.62755 .76056 L
.64717 .75804 L
.6668 .75516 L
.68642 .75191 L
.70604 .74828 L
.72083 .74529 L
.72567 .74426 L
.74529 .73984 L
.76491 .73498 L
.78454 .72968 L
.79832 .72567 L
.80416 .7239 L
.82378 .71761 L
.84341 .71077 L
.85605 .70604 L
.86303 .70333 L
.88265 .69522 L
.90213 .68642 L
.90228 .68635 L
.9219 .67664 L
.93998 .6668 L
.94152 .66592 L
.96115 .654 L
.9714 .64717 L
.98077 .64056 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .52951 m
.02472 .54906 L
.03046 .56868 L
.03885 .58425 L
.03957 .5883 L
.05293 .60793 L
.05848 .61485 L
.06822 .62755 L
.0781 .63759 L
.08755 .64717 L
.09772 .65589 L
.11119 .6668 L
.11735 .67122 L
.13697 .68437 L
.14022 .68642 L
.15659 .6958 L
.17622 .70585 L
.17661 .70604 L
.19584 .71474 L
.21546 .72262 L
.22364 .72567 L
.23509 .72963 L
.25471 .73586 L
.27433 .7414 L
.2897 .74529 L
.29396 .74629 L
.31358 .7506 L
.3332 .75437 L
.35283 .75763 L
.37245 .76041 L
.39207 .76274 L
.4117 .76464 L
.41471 .76491 L
.43132 .76613 L
.45094 .76722 L
.47057 .76793 L
.49019 .76826 L
.50981 .76822 L
.52943 .76783 L
.54906 .76708 L
.56868 .76597 L
.58345 .76491 L
.5883 .76452 L
.60793 .76271 L
.62755 .76056 L
.64717 .75804 L
.6668 .75516 L
.68642 .75191 L
.70604 .74828 L
.72083 .74529 L
Mistroke
.72567 .74426 L
.74529 .73984 L
.76491 .73498 L
.78454 .72968 L
.79832 .72567 L
.80416 .7239 L
.82378 .71761 L
.84341 .71077 L
.85605 .70604 L
.86303 .70333 L
.88265 .69522 L
.90213 .68642 L
.90228 .68635 L
.9219 .67664 L
.93998 .6668 L
.94152 .66592 L
.96115 .654 L
.9714 .64717 L
.98077 .64056 L
Mfstroke
0 1 .4 r
.01923 .53053 m
.02397 .54906 L
.02896 .56868 L
.03881 .5883 L
.03885 .58871 L
.04886 .60793 L
.05848 .62175 L
.06214 .62755 L
.0781 .64679 L
.07841 .64717 L
.09725 .6668 L
.09772 .66724 L
.11735 .68466 L
.11944 .68642 L
.13697 .69984 L
.14564 .70604 L
.15659 .7133 L
.17622 .72536 L
.17674 .72567 L
.19584 .73624 L
.21371 .74529 L
.21546 .74613 L
.23509 .75514 L
.25471 .7634 L
.25849 .76491 L
.27433 .77096 L
.29396 .77791 L
.31358 .7843 L
.31433 .78454 L
.3332 .79018 L
.35283 .79557 L
.37245 .80053 L
.38798 .80416 L
.39207 .80507 L
.4117 .80923 L
.43132 .81301 L
.45094 .81645 L
.47057 .81956 L
.49019 .82235 L
.50116 .82378 L
.50981 .82484 L
.52943 .82704 L
.54906 .82895 L
.56868 .8306 L
.5883 .83198 L
.60793 .8331 L
.62755 .83397 L
.64717 .83459 L
.6668 .83498 L
.68642 .83513 L
.70604 .83504 L
.72567 .83472 L
.74529 .83418 L
.76491 .83341 L
.78454 .83241 L
.80416 .83119 L
.82378 .82974 L
.84341 .82807 L
.86303 .82617 L
.88265 .82405 L
.88494 .82378 L
.90228 .82169 L
.9219 .8191 L
.94152 .81627 L
.96115 .81321 L
.98077 .80989 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .53053 m
.02397 .54906 L
.02896 .56868 L
.03881 .5883 L
.03885 .58871 L
.04886 .60793 L
.05848 .62175 L
.06214 .62755 L
.0781 .64679 L
.07841 .64717 L
.09725 .6668 L
.09772 .66724 L
.11735 .68466 L
.11944 .68642 L
.13697 .69984 L
.14564 .70604 L
.15659 .7133 L
.17622 .72536 L
.17674 .72567 L
.19584 .73624 L
.21371 .74529 L
.21546 .74613 L
.23509 .75514 L
.25471 .7634 L
.25849 .76491 L
.27433 .77096 L
.29396 .77791 L
.31358 .7843 L
.31433 .78454 L
.3332 .79018 L
.35283 .79557 L
.37245 .80053 L
.38798 .80416 L
.39207 .80507 L
.4117 .80923 L
.43132 .81301 L
.45094 .81645 L
.47057 .81956 L
.49019 .82235 L
.50116 .82378 L
.50981 .82484 L
.52943 .82704 L
.54906 .82895 L
.56868 .8306 L
.5883 .83198 L
.60793 .8331 L
.62755 .83397 L
.64717 .83459 L
.6668 .83498 L
.68642 .83513 L
Mistroke
.70604 .83504 L
.72567 .83472 L
.74529 .83418 L
.76491 .83341 L
.78454 .83241 L
.80416 .83119 L
.82378 .82974 L
.84341 .82807 L
.86303 .82617 L
.88265 .82405 L
.88494 .82378 L
.90228 .82169 L
.9219 .8191 L
.94152 .81627 L
.96115 .81321 L
.98077 .80989 L
Mfstroke
0 1 .1 r
.01923 .53165 m
.02324 .54906 L
.02755 .56868 L
.03851 .5883 L
.03885 .59327 L
.04549 .60793 L
.0574 .62755 L
.05848 .62932 L
.07051 .64717 L
.0781 .65676 L
.08615 .6668 L
.09772 .67953 L
.10419 .68642 L
.11735 .69916 L
.12479 .70604 L
.13697 .71649 L
.14825 .72567 L
.15659 .73204 L
.17494 .74529 L
.17622 .74616 L
.19584 .75908 L
.20524 .76491 L
.21546 .77098 L
.23509 .78201 L
.23979 .78454 L
.25471 .79226 L
.27433 .80183 L
.27932 .80416 L
.29396 .81078 L
.31358 .81917 L
.3249 .82378 L
.3332 .82705 L
.35283 .83447 L
.37245 .84146 L
.37813 .84341 L
.39207 .84804 L
.4117 .85426 L
.43132 .86012 L
.44149 .86303 L
.45094 .86565 L
.47057 .87088 L
.49019 .87581 L
.50981 .88046 L
.51948 .88265 L
.52943 .88484 L
.54906 .88898 L
.56868 .89286 L
.5883 .89652 L
.60793 .89995 L
.62198 .90228 L
.62755 .90317 L
.64717 .90617 L
.6668 .90898 L
.68642 .91159 L
.70604 .91402 L
.72567 .91625 L
.74529 .91831 L
.76491 .9202 L
.78435 .9219 L
.78454 .92192 L
.80416 .92346 L
.82378 .92485 L
.84341 .92608 L
.86303 .92715 L
.88265 .92806 L
.90228 .92883 L
.9219 .92944 L
.94152 .92991 L
.96115 .93023 L
.98077 .93041 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .53165 m
.02324 .54906 L
.02755 .56868 L
.03851 .5883 L
.03885 .59327 L
.04549 .60793 L
.0574 .62755 L
.05848 .62932 L
.07051 .64717 L
.0781 .65676 L
.08615 .6668 L
.09772 .67953 L
.10419 .68642 L
.11735 .69916 L
.12479 .70604 L
.13697 .71649 L
.14825 .72567 L
.15659 .73204 L
.17494 .74529 L
.17622 .74616 L
.19584 .75908 L
.20524 .76491 L
.21546 .77098 L
.23509 .78201 L
.23979 .78454 L
.25471 .79226 L
.27433 .80183 L
.27932 .80416 L
.29396 .81078 L
.31358 .81917 L
.3249 .82378 L
.3332 .82705 L
.35283 .83447 L
.37245 .84146 L
.37813 .84341 L
.39207 .84804 L
.4117 .85426 L
.43132 .86012 L
.44149 .86303 L
.45094 .86565 L
.47057 .87088 L
.49019 .87581 L
.50981 .88046 L
.51948 .88265 L
.52943 .88484 L
.54906 .88898 L
.56868 .89286 L
.5883 .89652 L
.60793 .89995 L
.62198 .90228 L
Mistroke
.62755 .90317 L
.64717 .90617 L
.6668 .90898 L
.68642 .91159 L
.70604 .91402 L
.72567 .91625 L
.74529 .91831 L
.76491 .9202 L
.78435 .9219 L
.78454 .92192 L
.80416 .92346 L
.82378 .92485 L
.84341 .92608 L
.86303 .92715 L
.88265 .92806 L
.90228 .92883 L
.9219 .92944 L
.94152 .92991 L
.96115 .93023 L
.98077 .93041 L
Mfstroke
0 .7 1 r
.01923 .52894 m
.01973 .52943 L
.02552 .54906 L
.03208 .56868 L
.03885 .58015 L
.04113 .5883 L
.05791 .60793 L
.05848 .60854 L
.07633 .62755 L
.0781 .62907 L
.09772 .64528 L
.10009 .64717 L
.11735 .65858 L
.13133 .6668 L
.13697 .66972 L
.15659 .67916 L
.17411 .68642 L
.17622 .68721 L
.19584 .69407 L
.21546 .69991 L
.23509 .70484 L
.24029 .70604 L
.25471 .70896 L
.27433 .71233 L
.29396 .71501 L
.31358 .71705 L
.3332 .71848 L
.35283 .71933 L
.37245 .71962 L
.39207 .71937 L
.4117 .71858 L
.43132 .71727 L
.45094 .71544 L
.47057 .71307 L
.49019 .71018 L
.50981 .70674 L
.51341 .70604 L
.52943 .70273 L
.54906 .69814 L
.56868 .69292 L
.5883 .68704 L
.59023 .68642 L
.60793 .68044 L
.62755 .67304 L
.64252 .6668 L
.64717 .66475 L
.6668 .65544 L
.68238 .64717 L
.68642 .6449 L
.70604 .63288 L
.71388 .62755 L
.72567 .61893 L
.73901 .60793 L
.74529 .60226 L
.75886 .5883 L
.76491 .58128 L
.77414 .56868 L
.78454 .55069 L
.78528 .54906 L
.79257 .52943 L
.79617 .50981 L
.79617 .49019 L
.79257 .47057 L
.78528 .45094 L
.78454 .44931 L
.77414 .43132 L
.76491 .41872 L
.75886 .4117 L
.74529 .39774 L
.73901 .39207 L
.72567 .38107 L
.71388 .37245 L
.70604 .36712 L
.68642 .3551 L
.68238 .35283 L
.6668 .34456 L
.64717 .33525 L
.64252 .3332 L
.62755 .32696 L
.60793 .31956 L
.59023 .31358 L
.5883 .31296 L
.56868 .30708 L
.54906 .30186 L
.52943 .29727 L
.51341 .29396 L
.50981 .29326 L
.49019 .28982 L
.47057 .28693 L
.45094 .28456 L
.43132 .28273 L
.4117 .28142 L
.39207 .28063 L
.37245 .28038 L
.35283 .28067 L
.3332 .28152 L
.31358 .28295 L
.29396 .28499 L
.27433 .28767 L
.25471 .29104 L
.24029 .29396 L
.23509 .29516 L
.21546 .30009 L
.19584 .30593 L
.17622 .31279 L
.17411 .31358 L
.15659 .32084 L
.13697 .33028 L
.13133 .3332 L
.11735 .34142 L
.10009 .35283 L
.09772 .35472 L
.0781 .37093 L
.07633 .37245 L
.05848 .39146 L
.05791 .39207 L
.04113 .4117 L
.03885 .41985 L
.03208 .43132 L
.02552 .45094 L
.01973 .47057 L
.01923 .47106 L
F
0 g
.01923 .52894 m
.01973 .52943 L
.02552 .54906 L
.03208 .56868 L
.03885 .58015 L
.04113 .5883 L
.05791 .60793 L
.05848 .60854 L
.07633 .62755 L
.0781 .62907 L
.09772 .64528 L
.10009 .64717 L
.11735 .65858 L
.13133 .6668 L
.13697 .66972 L
.15659 .67916 L
.17411 .68642 L
.17622 .68721 L
.19584 .69407 L
.21546 .69991 L
.23509 .70484 L
.24029 .70604 L
.25471 .70896 L
.27433 .71233 L
.29396 .71501 L
.31358 .71705 L
.3332 .71848 L
.35283 .71933 L
.37245 .71962 L
.39207 .71937 L
.4117 .71858 L
.43132 .71727 L
.45094 .71544 L
.47057 .71307 L
.49019 .71018 L
.50981 .70674 L
.51341 .70604 L
.52943 .70273 L
.54906 .69814 L
.56868 .69292 L
.5883 .68704 L
.59023 .68642 L
.60793 .68044 L
.62755 .67304 L
.64252 .6668 L
.64717 .66475 L
.6668 .65544 L
.68238 .64717 L
.68642 .6449 L
.70604 .63288 L
Mistroke
.71388 .62755 L
.72567 .61893 L
.73901 .60793 L
.74529 .60226 L
.75886 .5883 L
.76491 .58128 L
.77414 .56868 L
.78454 .55069 L
.78528 .54906 L
.79257 .52943 L
.79617 .50981 L
.79617 .49019 L
.79257 .47057 L
.78528 .45094 L
.78454 .44931 L
.77414 .43132 L
.76491 .41872 L
.75886 .4117 L
.74529 .39774 L
.73901 .39207 L
.72567 .38107 L
.71388 .37245 L
.70604 .36712 L
.68642 .3551 L
.68238 .35283 L
.6668 .34456 L
.64717 .33525 L
.64252 .3332 L
.62755 .32696 L
.60793 .31956 L
.59023 .31358 L
.5883 .31296 L
.56868 .30708 L
.54906 .30186 L
.52943 .29727 L
.51341 .29396 L
.50981 .29326 L
.49019 .28982 L
.47057 .28693 L
.45094 .28456 L
.43132 .28273 L
.4117 .28142 L
.39207 .28063 L
.37245 .28038 L
.35283 .28067 L
.3332 .28152 L
.31358 .28295 L
.29396 .28499 L
.27433 .28767 L
.25471 .29104 L
Mistroke
.24029 .29396 L
.23509 .29516 L
.21546 .30009 L
.19584 .30593 L
.17622 .31279 L
.17411 .31358 L
.15659 .32084 L
.13697 .33028 L
.13133 .3332 L
.11735 .34142 L
.10009 .35283 L
.09772 .35472 L
.0781 .37093 L
.07633 .37245 L
.05848 .39146 L
.05791 .39207 L
.04113 .4117 L
.03885 .41985 L
.03208 .43132 L
.02552 .45094 L
.01973 .47057 L
.01923 .47106 L
Mfstroke
.2 1 0 r
.01923 .46711 m
.02254 .45094 L
.02624 .43132 L
.03837 .4117 L
.03885 .40137 L
.04258 .39207 L
.05313 .37245 L
.05848 .36231 L
.06395 .35283 L
.0773 .3332 L
.0781 .33211 L
.09213 .31358 L
.09772 .30687 L
.10887 .29396 L
.11735 .28487 L
.12757 .27433 L
.13697 .26525 L
.14835 .25471 L
.15659 .24747 L
.17135 .23509 L
.17622 .23119 L
.19584 .21614 L
.19675 .21546 L
.21546 .20213 L
.22472 .19584 L
.23509 .18904 L
.25471 .17673 L
.25555 .17622 L
.27433 .16512 L
.28948 .15659 L
.29396 .15414 L
.31358 .14373 L
.32688 .13697 L
.3332 .13384 L
.35283 .12442 L
.36818 .11735 L
.37245 .11543 L
.39207 .10684 L
.4117 .09863 L
.41391 .09772 L
.43132 .09076 L
.45094 .08323 L
.46476 .0781 L
.47057 .07599 L
.49019 .06905 L
.50981 .06238 L
.52166 .05848 L
.52943 .05597 L
.54906 .0498 L
.56868 .04387 L
.58588 .03885 L
.5883 .03816 L
.60793 .03267 L
.62755 .02737 L
.64717 .02228 L
.65927 .01923 L
.01923 .01923 L
F
0 g
.01923 .46711 m
.02254 .45094 L
.02624 .43132 L
.03837 .4117 L
.03885 .40137 L
.04258 .39207 L
.05313 .37245 L
.05848 .36231 L
.06395 .35283 L
.0773 .3332 L
.0781 .33211 L
.09213 .31358 L
.09772 .30687 L
.10887 .29396 L
.11735 .28487 L
.12757 .27433 L
.13697 .26525 L
.14835 .25471 L
.15659 .24747 L
.17135 .23509 L
.17622 .23119 L
.19584 .21614 L
.19675 .21546 L
.21546 .20213 L
.22472 .19584 L
.23509 .18904 L
.25471 .17673 L
.25555 .17622 L
.27433 .16512 L
.28948 .15659 L
.29396 .15414 L
.31358 .14373 L
.32688 .13697 L
.3332 .13384 L
.35283 .12442 L
.36818 .11735 L
.37245 .11543 L
.39207 .10684 L
.4117 .09863 L
.41391 .09772 L
.43132 .09076 L
.45094 .08323 L
.46476 .0781 L
.47057 .07599 L
.49019 .06905 L
.50981 .06238 L
.52166 .05848 L
.52943 .05597 L
.54906 .0498 L
.56868 .04387 L
Mistroke
.58588 .03885 L
.5883 .03816 L
.60793 .03267 L
.62755 .02737 L
.64717 .02228 L
.65927 .01923 L
Mfstroke
.2 1 0 r
.01923 .53289 m
.02254 .54906 L
.02624 .56868 L
.03837 .5883 L
.03885 .59863 L
.04258 .60793 L
.05313 .62755 L
.05848 .63769 L
.06395 .64717 L
.0773 .6668 L
.0781 .66789 L
.09213 .68642 L
.09772 .69313 L
.10887 .70604 L
.11735 .71513 L
.12757 .72567 L
.13697 .73475 L
.14835 .74529 L
.15659 .75253 L
.17135 .76491 L
.17622 .76881 L
.19584 .78386 L
.19675 .78454 L
.21546 .79787 L
.22472 .80416 L
.23509 .81096 L
.25471 .82327 L
.25555 .82378 L
.27433 .83488 L
.28948 .84341 L
.29396 .84586 L
.31358 .85627 L
.32688 .86303 L
.3332 .86616 L
.35283 .87558 L
.36818 .88265 L
.37245 .88457 L
.39207 .89316 L
.4117 .90137 L
.41391 .90228 L
.43132 .90924 L
.45094 .91677 L
.46476 .9219 L
.47057 .92401 L
.49019 .93095 L
.50981 .93762 L
.52166 .94152 L
.52943 .94403 L
.54906 .9502 L
.56868 .95613 L
.58588 .96115 L
.5883 .96184 L
.60793 .96733 L
.62755 .97263 L
.64717 .97772 L
.65927 .98077 L
.01923 .98077 L
F
0 g
.01923 .53289 m
.02254 .54906 L
.02624 .56868 L
.03837 .5883 L
.03885 .59863 L
.04258 .60793 L
.05313 .62755 L
.05848 .63769 L
.06395 .64717 L
.0773 .6668 L
.0781 .66789 L
.09213 .68642 L
.09772 .69313 L
.10887 .70604 L
.11735 .71513 L
.12757 .72567 L
.13697 .73475 L
.14835 .74529 L
.15659 .75253 L
.17135 .76491 L
.17622 .76881 L
.19584 .78386 L
.19675 .78454 L
.21546 .79787 L
.22472 .80416 L
.23509 .81096 L
.25471 .82327 L
.25555 .82378 L
.27433 .83488 L
.28948 .84341 L
.29396 .84586 L
.31358 .85627 L
.32688 .86303 L
.3332 .86616 L
.35283 .87558 L
.36818 .88265 L
.37245 .88457 L
.39207 .89316 L
.4117 .90137 L
.41391 .90228 L
.43132 .90924 L
.45094 .91677 L
.46476 .9219 L
.47057 .92401 L
.49019 .93095 L
.50981 .93762 L
.52166 .94152 L
.52943 .94403 L
.54906 .9502 L
.56868 .95613 L
Mistroke
.58588 .96115 L
.5883 .96184 L
.60793 .96733 L
.62755 .97263 L
.64717 .97772 L
.65927 .98077 L
Mfstroke
0 .4 1 r
.01923 .52842 m
.02029 .52943 L
.02636 .54906 L
.03384 .56868 L
.03885 .57642 L
.0438 .5883 L
.05848 .60255 L
.06226 .60793 L
.0781 .62102 L
.0858 .62755 L
.09772 .63521 L
.11735 .64652 L
.11849 .64717 L
.13697 .65565 L
.15659 .66307 L
.168 .6668 L
.17622 .66905 L
.19584 .67381 L
.21546 .67748 L
.23509 .68017 L
.25471 .68196 L
.27433 .6829 L
.29396 .68305 L
.31358 .68242 L
.3332 .68103 L
.35283 .67889 L
.37245 .67599 L
.39207 .67231 L
.4117 .66781 L
.41566 .6668 L
.43132 .66246 L
.45094 .65617 L
.47057 .64883 L
.47462 .64717 L
.49019 .64034 L
.50981 .63043 L
.51497 .62755 L
.52943 .61883 L
.5451 .60793 L
.54906 .60492 L
.56804 .5883 L
.56868 .58768 L
.58529 .56868 L
.5883 .56472 L
.59769 .54906 L
.60573 .52943 L
.60793 .52096 L
.60969 .50981 L
.60969 .49019 L
.60793 .47904 L
.60573 .47057 L
.59769 .45094 L
.5883 .43528 L
.58529 .43132 L
.56868 .41232 L
.56804 .4117 L
.54906 .39508 L
.5451 .39207 L
.52943 .38117 L
.51497 .37245 L
.50981 .36957 L
.49019 .35966 L
.47462 .35283 L
.47057 .35117 L
.45094 .34383 L
.43132 .33754 L
.41566 .3332 L
.4117 .33219 L
.39207 .32769 L
.37245 .32401 L
.35283 .32111 L
.3332 .31897 L
.31358 .31758 L
.29396 .31695 L
.27433 .3171 L
.25471 .31804 L
.23509 .31983 L
.21546 .32252 L
.19584 .32619 L
.17622 .33095 L
.168 .3332 L
.15659 .33693 L
.13697 .34435 L
.11849 .35283 L
.11735 .35348 L
.09772 .36479 L
.0858 .37245 L
.0781 .37898 L
.06226 .39207 L
.05848 .39745 L
.0438 .4117 L
.03885 .42358 L
.03384 .43132 L
.02636 .45094 L
.02029 .47057 L
.01923 .47158 L
F
0 g
.01923 .52842 m
.02029 .52943 L
.02636 .54906 L
.03384 .56868 L
.03885 .57642 L
.0438 .5883 L
.05848 .60255 L
.06226 .60793 L
.0781 .62102 L
.0858 .62755 L
.09772 .63521 L
.11735 .64652 L
.11849 .64717 L
.13697 .65565 L
.15659 .66307 L
.168 .6668 L
.17622 .66905 L
.19584 .67381 L
.21546 .67748 L
.23509 .68017 L
.25471 .68196 L
.27433 .6829 L
.29396 .68305 L
.31358 .68242 L
.3332 .68103 L
.35283 .67889 L
.37245 .67599 L
.39207 .67231 L
.4117 .66781 L
.41566 .6668 L
.43132 .66246 L
.45094 .65617 L
.47057 .64883 L
.47462 .64717 L
.49019 .64034 L
.50981 .63043 L
.51497 .62755 L
.52943 .61883 L
.5451 .60793 L
.54906 .60492 L
.56804 .5883 L
.56868 .58768 L
.58529 .56868 L
.5883 .56472 L
.59769 .54906 L
.60573 .52943 L
.60793 .52096 L
.60969 .50981 L
.60969 .49019 L
.60793 .47904 L
Mistroke
.60573 .47057 L
.59769 .45094 L
.5883 .43528 L
.58529 .43132 L
.56868 .41232 L
.56804 .4117 L
.54906 .39508 L
.5451 .39207 L
.52943 .38117 L
.51497 .37245 L
.50981 .36957 L
.49019 .35966 L
.47462 .35283 L
.47057 .35117 L
.45094 .34383 L
.43132 .33754 L
.41566 .3332 L
.4117 .33219 L
.39207 .32769 L
.37245 .32401 L
.35283 .32111 L
.3332 .31897 L
.31358 .31758 L
.29396 .31695 L
.27433 .3171 L
.25471 .31804 L
.23509 .31983 L
.21546 .32252 L
.19584 .32619 L
.17622 .33095 L
.168 .3332 L
.15659 .33693 L
.13697 .34435 L
.11849 .35283 L
.11735 .35348 L
.09772 .36479 L
.0858 .37245 L
.0781 .37898 L
.06226 .39207 L
.05848 .39745 L
.0438 .4117 L
.03885 .42358 L
.03384 .43132 L
.02636 .45094 L
.02029 .47057 L
.01923 .47158 L
Mfstroke
0 .1 1 r
.01923 .5279 m
.02087 .52943 L
.02725 .54906 L
.03578 .56868 L
.03885 .57299 L
.04791 .5883 L
.05848 .59691 L
.06972 .60793 L
.0781 .61335 L
.09772 .62556 L
.10082 .62755 L
.11735 .63484 L
.13697 .64193 L
.1563 .64717 L
.15659 .64724 L
.17622 .65103 L
.19584 .6535 L
.21546 .65476 L
.23509 .65489 L
.25471 .65395 L
.27433 .65195 L
.29396 .64889 L
.30271 .64717 L
.31358 .64474 L
.3332 .63944 L
.35283 .63288 L
.36628 .62755 L
.37245 .62488 L
.39207 .61521 L
.40459 .60793 L
.4117 .6034 L
.43132 .58859 L
.43165 .5883 L
.45094 .56904 L
.45124 .56868 L
.46502 .54906 L
.47057 .53912 L
.47384 .52943 L
.47815 .50981 L
.47815 .49019 L
.47384 .47057 L
.47057 .46088 L
.46502 .45094 L
.45124 .43132 L
.45094 .43096 L
.43165 .4117 L
.43132 .41141 L
.4117 .3966 L
.40459 .39207 L
.39207 .38479 L
.37245 .37512 L
.36628 .37245 L
.35283 .36712 L
.3332 .36056 L
.31358 .35526 L
.30271 .35283 L
.29396 .35111 L
.27433 .34805 L
.25471 .34605 L
.23509 .34511 L
.21546 .34524 L
.19584 .3465 L
.17622 .34897 L
.15659 .35276 L
.1563 .35283 L
.13697 .35807 L
.11735 .36516 L
.10082 .37245 L
.09772 .37444 L
.0781 .38665 L
.06972 .39207 L
.05848 .40309 L
.04791 .4117 L
.03885 .42701 L
.03578 .43132 L
.02725 .45094 L
.02087 .47057 L
.01923 .4721 L
F
0 g
.01923 .5279 m
.02087 .52943 L
.02725 .54906 L
.03578 .56868 L
.03885 .57299 L
.04791 .5883 L
.05848 .59691 L
.06972 .60793 L
.0781 .61335 L
.09772 .62556 L
.10082 .62755 L
.11735 .63484 L
.13697 .64193 L
.1563 .64717 L
.15659 .64724 L
.17622 .65103 L
.19584 .6535 L
.21546 .65476 L
.23509 .65489 L
.25471 .65395 L
.27433 .65195 L
.29396 .64889 L
.30271 .64717 L
.31358 .64474 L
.3332 .63944 L
.35283 .63288 L
.36628 .62755 L
.37245 .62488 L
.39207 .61521 L
.40459 .60793 L
.4117 .6034 L
.43132 .58859 L
.43165 .5883 L
.45094 .56904 L
.45124 .56868 L
.46502 .54906 L
.47057 .53912 L
.47384 .52943 L
.47815 .50981 L
.47815 .49019 L
.47384 .47057 L
.47057 .46088 L
.46502 .45094 L
.45124 .43132 L
.45094 .43096 L
.43165 .4117 L
.43132 .41141 L
.4117 .3966 L
.40459 .39207 L
.39207 .38479 L
Mistroke
.37245 .37512 L
.36628 .37245 L
.35283 .36712 L
.3332 .36056 L
.31358 .35526 L
.30271 .35283 L
.29396 .35111 L
.27433 .34805 L
.25471 .34605 L
.23509 .34511 L
.21546 .34524 L
.19584 .3465 L
.17622 .34897 L
.15659 .35276 L
.1563 .35283 L
.13697 .35807 L
.11735 .36516 L
.10082 .37245 L
.09772 .37444 L
.0781 .38665 L
.06972 .39207 L
.05848 .40309 L
.04791 .4117 L
.03885 .42701 L
.03578 .43132 L
.02725 .45094 L
.02087 .47057 L
.01923 .4721 L
Mfstroke
.5 1 0 r
.01923 .46571 m
.02187 .45094 L
.02499 .43132 L
.03806 .4117 L
.03885 .39497 L
.03991 .39207 L
.04928 .37245 L
.0584 .35283 L
.05848 .35262 L
.06946 .3332 L
.0781 .31952 L
.08195 .31358 L
.09585 .29396 L
.09772 .29148 L
.11111 .27433 L
.11735 .26686 L
.12785 .25471 L
.13697 .24473 L
.14611 .23509 L
.15659 .22454 L
.16594 .21546 L
.17622 .20589 L
.18741 .19584 L
.19584 .18854 L
.21059 .17622 L
.21546 .17228 L
.23509 .15696 L
.23557 .15659 L
.25471 .14247 L
.26242 .13697 L
.27433 .1287 L
.29127 .11735 L
.29396 .11559 L
.31358 .10307 L
.32222 .09772 L
.3332 .09108 L
.35283 .07957 L
.3554 .0781 L
.37245 .06852 L
.39095 .05848 L
.39207 .05788 L
.4117 .04762 L
.42904 .03885 L
.43132 .03772 L
.45094 .02815 L
.46985 .01923 L
.01923 .01923 L
F
0 g
.01923 .46571 m
.02187 .45094 L
.02499 .43132 L
.03806 .4117 L
.03885 .39497 L
.03991 .39207 L
.04928 .37245 L
.0584 .35283 L
.05848 .35262 L
.06946 .3332 L
.0781 .31952 L
.08195 .31358 L
.09585 .29396 L
.09772 .29148 L
.11111 .27433 L
.11735 .26686 L
.12785 .25471 L
.13697 .24473 L
.14611 .23509 L
.15659 .22454 L
.16594 .21546 L
.17622 .20589 L
.18741 .19584 L
.19584 .18854 L
.21059 .17622 L
.21546 .17228 L
.23509 .15696 L
.23557 .15659 L
.25471 .14247 L
.26242 .13697 L
.27433 .1287 L
.29127 .11735 L
.29396 .11559 L
.31358 .10307 L
.32222 .09772 L
.3332 .09108 L
.35283 .07957 L
.3554 .0781 L
.37245 .06852 L
.39095 .05848 L
.39207 .05788 L
.4117 .04762 L
.42904 .03885 L
.43132 .03772 L
.45094 .02815 L
.46985 .01923 L
s
.5 1 0 r
.01923 .53429 m
.02187 .54906 L
.02499 .56868 L
.03806 .5883 L
.03885 .60503 L
.03991 .60793 L
.04928 .62755 L
.0584 .64717 L
.05848 .64738 L
.06946 .6668 L
.0781 .68048 L
.08195 .68642 L
.09585 .70604 L
.09772 .70852 L
.11111 .72567 L
.11735 .73314 L
.12785 .74529 L
.13697 .75527 L
.14611 .76491 L
.15659 .77546 L
.16594 .78454 L
.17622 .79411 L
.18741 .80416 L
.19584 .81146 L
.21059 .82378 L
.21546 .82772 L
.23509 .84304 L
.23557 .84341 L
.25471 .85753 L
.26242 .86303 L
.27433 .8713 L
.29127 .88265 L
.29396 .88441 L
.31358 .89693 L
.32222 .90228 L
.3332 .90892 L
.35283 .92043 L
.3554 .9219 L
.37245 .93148 L
.39095 .94152 L
.39207 .94212 L
.4117 .95238 L
.42904 .96115 L
.43132 .96228 L
.45094 .97185 L
.46985 .98077 L
.01923 .98077 L
F
0 g
.01923 .53429 m
.02187 .54906 L
.02499 .56868 L
.03806 .5883 L
.03885 .60503 L
.03991 .60793 L
.04928 .62755 L
.0584 .64717 L
.05848 .64738 L
.06946 .6668 L
.0781 .68048 L
.08195 .68642 L
.09585 .70604 L
.09772 .70852 L
.11111 .72567 L
.11735 .73314 L
.12785 .74529 L
.13697 .75527 L
.14611 .76491 L
.15659 .77546 L
.16594 .78454 L
.17622 .79411 L
.18741 .80416 L
.19584 .81146 L
.21059 .82378 L
.21546 .82772 L
.23509 .84304 L
.23557 .84341 L
.25471 .85753 L
.26242 .86303 L
.27433 .8713 L
.29127 .88265 L
.29396 .88441 L
.31358 .89693 L
.32222 .90228 L
.3332 .90892 L
.35283 .92043 L
.3554 .9219 L
.37245 .93148 L
.39095 .94152 L
.39207 .94212 L
.4117 .95238 L
.42904 .96115 L
.43132 .96228 L
.45094 .97185 L
.46985 .98077 L
s
.2 0 1 r
.01923 .5274 m
.02147 .52943 L
.02819 .54906 L
.03796 .56868 L
.03885 .56982 L
.05376 .5883 L
.05848 .59155 L
.0781 .60599 L
.08127 .60793 L
.09772 .61617 L
.11735 .6234 L
.13245 .62755 L
.13697 .62833 L
.15659 .63137 L
.17622 .63274 L
.19584 .63259 L
.21546 .63099 L
.23509 .62795 L
.23713 .62755 L
.25471 .62344 L
.27433 .61734 L
.29396 .60941 L
.29714 .60793 L
.31358 .59936 L
.33055 .5883 L
.3332 .58638 L
.35283 .56896 L
.35308 .56868 L
.36841 .54906 L
.37245 .54316 L
.37805 .52943 L
.38272 .50981 L
.38272 .49019 L
.37805 .47057 L
.37245 .45684 L
.36841 .45094 L
.35308 .43132 L
.35283 .43104 L
.3332 .41362 L
.33055 .4117 L
.31358 .40064 L
.29714 .39207 L
.29396 .39059 L
.27433 .38266 L
.25471 .37656 L
.23713 .37245 L
.23509 .37205 L
.21546 .36901 L
.19584 .36741 L
.17622 .36726 L
.15659 .36863 L
.13697 .37167 L
.13245 .37245 L
.11735 .3766 L
.09772 .38383 L
.08127 .39207 L
.0781 .39401 L
.05848 .40845 L
.05376 .4117 L
.03885 .43018 L
.03796 .43132 L
.02819 .45094 L
.02147 .47057 L
.01923 .4726 L
F
0 g
.01923 .5274 m
.02147 .52943 L
.02819 .54906 L
.03796 .56868 L
.03885 .56982 L
.05376 .5883 L
.05848 .59155 L
.0781 .60599 L
.08127 .60793 L
.09772 .61617 L
.11735 .6234 L
.13245 .62755 L
.13697 .62833 L
.15659 .63137 L
.17622 .63274 L
.19584 .63259 L
.21546 .63099 L
.23509 .62795 L
.23713 .62755 L
.25471 .62344 L
.27433 .61734 L
.29396 .60941 L
.29714 .60793 L
.31358 .59936 L
.33055 .5883 L
.3332 .58638 L
.35283 .56896 L
.35308 .56868 L
.36841 .54906 L
.37245 .54316 L
.37805 .52943 L
.38272 .50981 L
.38272 .49019 L
.37805 .47057 L
.37245 .45684 L
.36841 .45094 L
.35308 .43132 L
.35283 .43104 L
.3332 .41362 L
.33055 .4117 L
.31358 .40064 L
.29714 .39207 L
.29396 .39059 L
.27433 .38266 L
.25471 .37656 L
.23713 .37245 L
.23509 .37205 L
.21546 .36901 L
.19584 .36741 L
.17622 .36726 L
Mistroke
.15659 .36863 L
.13697 .37167 L
.13245 .37245 L
.11735 .3766 L
.09772 .38383 L
.08127 .39207 L
.0781 .39401 L
.05848 .40845 L
.05376 .4117 L
.03885 .43018 L
.03796 .43132 L
.02819 .45094 L
.02147 .47057 L
.01923 .4726 L
Mfstroke
.8 1 0 r
.01923 .46408 m
.02122 .45094 L
.02381 .43132 L
.03727 .4117 L
.03725 .39207 L
.03885 .38787 L
.04549 .37245 L
.05452 .35283 L
.05848 .34144 L
.0625 .3332 L
.07308 .31358 L
.0781 .30479 L
.08455 .29396 L
.09719 .27433 L
.09772 .27354 L
.11086 .25471 L
.11735 .24594 L
.12562 .23509 L
.13697 .22095 L
.14151 .21546 L
.15659 .19801 L
.15853 .19584 L
.17622 .17671 L
.17669 .17622 L
.19584 .15678 L
.19603 .15659 L
.21546 .138 L
.21657 .13697 L
.23509 .12022 L
.23835 .11735 L
.25471 .10331 L
.26139 .09772 L
.27433 .08717 L
.28574 .0781 L
.29396 .07171 L
.31142 .05848 L
.31358 .05687 L
.3332 .0426 L
.33847 .03885 L
.35283 .02883 L
.36693 .01923 L
.01923 .01923 L
F
0 g
.01923 .46408 m
.02122 .45094 L
.02381 .43132 L
.03727 .4117 L
.03725 .39207 L
.03885 .38787 L
.04549 .37245 L
.05452 .35283 L
.05848 .34144 L
.0625 .3332 L
.07308 .31358 L
.0781 .30479 L
.08455 .29396 L
.09719 .27433 L
.09772 .27354 L
.11086 .25471 L
.11735 .24594 L
.12562 .23509 L
.13697 .22095 L
.14151 .21546 L
.15659 .19801 L
.15853 .19584 L
.17622 .17671 L
.17669 .17622 L
.19584 .15678 L
.19603 .15659 L
.21546 .138 L
.21657 .13697 L
.23509 .12022 L
.23835 .11735 L
.25471 .10331 L
.26139 .09772 L
.27433 .08717 L
.28574 .0781 L
.29396 .07171 L
.31142 .05848 L
.31358 .05687 L
.3332 .0426 L
.33847 .03885 L
.35283 .02883 L
.36693 .01923 L
s
.8 1 0 r
.01923 .53592 m
.02122 .54906 L
.02381 .56868 L
.03727 .5883 L
.03725 .60793 L
.03885 .61213 L
.04549 .62755 L
.05452 .64717 L
.05848 .65856 L
.0625 .6668 L
.07308 .68642 L
.0781 .69521 L
.08455 .70604 L
.09719 .72567 L
.09772 .72646 L
.11086 .74529 L
.11735 .75406 L
.12562 .76491 L
.13697 .77905 L
.14151 .78454 L
.15659 .80199 L
.15853 .80416 L
.17622 .82329 L
.17669 .82378 L
.19584 .84322 L
.19603 .84341 L
.21546 .862 L
.21657 .86303 L
.23509 .87978 L
.23835 .88265 L
.25471 .89669 L
.26139 .90228 L
.27433 .91283 L
.28574 .9219 L
.29396 .92829 L
.31142 .94152 L
.31358 .94313 L
.3332 .9574 L
.33847 .96115 L
.35283 .97117 L
.36693 .98077 L
.01923 .98077 L
F
0 g
.01923 .53592 m
.02122 .54906 L
.02381 .56868 L
.03727 .5883 L
.03725 .60793 L
.03885 .61213 L
.04549 .62755 L
.05452 .64717 L
.05848 .65856 L
.0625 .6668 L
.07308 .68642 L
.0781 .69521 L
.08455 .70604 L
.09719 .72567 L
.09772 .72646 L
.11086 .74529 L
.11735 .75406 L
.12562 .76491 L
.13697 .77905 L
.14151 .78454 L
.15659 .80199 L
.15853 .80416 L
.17622 .82329 L
.17669 .82378 L
.19584 .84322 L
.19603 .84341 L
.21546 .862 L
.21657 .86303 L
.23509 .87978 L
.23835 .88265 L
.25471 .89669 L
.26139 .90228 L
.27433 .91283 L
.28574 .9219 L
.29396 .92829 L
.31142 .94152 L
.31358 .94313 L
.3332 .9574 L
.33847 .96115 L
.35283 .97117 L
.36693 .98077 L
s
.5 0 1 r
.01923 .5269 m
.02209 .52943 L
.02919 .54906 L
.03885 .56671 L
.04046 .56868 L
.05848 .5864 L
.06083 .5883 L
.0781 .59881 L
.09772 .60694 L
.10075 .60793 L
.11735 .612 L
.13697 .61462 L
.15659 .61511 L
.17622 .61365 L
.19584 .61027 L
.20536 .60793 L
.21546 .60491 L
.23509 .59734 L
.2525 .5883 L
.25471 .58701 L
.27433 .57298 L
.27911 .56868 L
.29396 .55238 L
.29625 .54906 L
.30677 .52943 L
.31181 .50981 L
.31181 .49019 L
.30677 .47057 L
.29625 .45094 L
.29396 .44762 L
.27911 .43132 L
.27433 .42702 L
.25471 .41299 L
.2525 .4117 L
.23509 .40266 L
.21546 .39509 L
.20536 .39207 L
.19584 .38973 L
.17622 .38635 L
.15659 .38489 L
.13697 .38538 L
.11735 .388 L
.10075 .39207 L
.09772 .39306 L
.0781 .40119 L
.06083 .4117 L
.05848 .4136 L
.04046 .43132 L
.03885 .43329 L
.02919 .45094 L
.02209 .47057 L
.01923 .4731 L
F
0 g
.01923 .5269 m
.02209 .52943 L
.02919 .54906 L
.03885 .56671 L
.04046 .56868 L
.05848 .5864 L
.06083 .5883 L
.0781 .59881 L
.09772 .60694 L
.10075 .60793 L
.11735 .612 L
.13697 .61462 L
.15659 .61511 L
.17622 .61365 L
.19584 .61027 L
.20536 .60793 L
.21546 .60491 L
.23509 .59734 L
.2525 .5883 L
.25471 .58701 L
.27433 .57298 L
.27911 .56868 L
.29396 .55238 L
.29625 .54906 L
.30677 .52943 L
.31181 .50981 L
.31181 .49019 L
.30677 .47057 L
.29625 .45094 L
.29396 .44762 L
.27911 .43132 L
.27433 .42702 L
.25471 .41299 L
.2525 .4117 L
.23509 .40266 L
.21546 .39509 L
.20536 .39207 L
.19584 .38973 L
.17622 .38635 L
.15659 .38489 L
.13697 .38538 L
.11735 .388 L
.10075 .39207 L
.09772 .39306 L
.0781 .40119 L
.06083 .4117 L
.05848 .4136 L
.04046 .43132 L
.03885 .43329 L
.02919 .45094 L
Mistroke
.02209 .47057 L
.01923 .4731 L
Mfstroke
1 .9 0 r
.01923 .4621 m
.0206 .45094 L
.02268 .43132 L
.03566 .4117 L
.03436 .39207 L
.03885 .37884 L
.04139 .37245 L
.05038 .35283 L
.05752 .3332 L
.05848 .32763 L
.0649 .31358 L
.07451 .29396 L
.0781 .28678 L
.08477 .27433 L
.09595 .25471 L
.09772 .25171 L
.10793 .23509 L
.11735 .22052 L
.12071 .21546 L
.13432 .19584 L
.13697 .19215 L
.14873 .17622 L
.15659 .16597 L
.16396 .15659 L
.17622 .14154 L
.18002 .13697 L
.19584 .11856 L
.19691 .11735 L
.21464 .09772 L
.21546 .09683 L
.23321 .0781 L
.23509 .07617 L
.25264 .05848 L
.25471 .05644 L
.27293 .03885 L
.27433 .03753 L
.29396 .01936 L
.2941 .01923 L
.01923 .01923 L
F
0 g
.01923 .4621 m
.0206 .45094 L
.02268 .43132 L
.03566 .4117 L
.03436 .39207 L
.03885 .37884 L
.04139 .37245 L
.05038 .35283 L
.05752 .3332 L
.05848 .32763 L
.0649 .31358 L
.07451 .29396 L
.0781 .28678 L
.08477 .27433 L
.09595 .25471 L
.09772 .25171 L
.10793 .23509 L
.11735 .22052 L
.12071 .21546 L
.13432 .19584 L
.13697 .19215 L
.14873 .17622 L
.15659 .16597 L
.16396 .15659 L
.17622 .14154 L
.18002 .13697 L
.19584 .11856 L
.19691 .11735 L
.21464 .09772 L
.21546 .09683 L
.23321 .0781 L
.23509 .07617 L
.25264 .05848 L
.25471 .05644 L
.27293 .03885 L
.27433 .03753 L
.29396 .01936 L
.2941 .01923 L
s
1 .9 0 r
.01923 .5379 m
.0206 .54906 L
.02268 .56868 L
.03566 .5883 L
.03436 .60793 L
.03885 .62116 L
.04139 .62755 L
.05038 .64717 L
.05752 .6668 L
.05848 .67237 L
.0649 .68642 L
.07451 .70604 L
.0781 .71322 L
.08477 .72567 L
.09595 .74529 L
.09772 .74829 L
.10793 .76491 L
.11735 .77948 L
.12071 .78454 L
.13432 .80416 L
.13697 .80785 L
.14873 .82378 L
.15659 .83403 L
.16396 .84341 L
.17622 .85846 L
.18002 .86303 L
.19584 .88144 L
.19691 .88265 L
.21464 .90228 L
.21546 .90317 L
.23321 .9219 L
.23509 .92383 L
.25264 .94152 L
.25471 .94356 L
.27293 .96115 L
.27433 .96247 L
.29396 .98064 L
.2941 .98077 L
.01923 .98077 L
F
0 g
.01923 .5379 m
.0206 .54906 L
.02268 .56868 L
.03566 .5883 L
.03436 .60793 L
.03885 .62116 L
.04139 .62755 L
.05038 .64717 L
.05752 .6668 L
.05848 .67237 L
.0649 .68642 L
.07451 .70604 L
.0781 .71322 L
.08477 .72567 L
.09595 .74529 L
.09772 .74829 L
.10793 .76491 L
.11735 .77948 L
.12071 .78454 L
.13432 .80416 L
.13697 .80785 L
.14873 .82378 L
.15659 .83403 L
.16396 .84341 L
.17622 .85846 L
.18002 .86303 L
.19584 .88144 L
.19691 .88265 L
.21464 .90228 L
.21546 .90317 L
.23321 .9219 L
.23509 .92383 L
.25264 .94152 L
.25471 .94356 L
.27293 .96115 L
.27433 .96247 L
.29396 .98064 L
.2941 .98077 L
s
.8 0 1 r
.01923 .52641 m
.02275 .52943 L
.03028 .54906 L
.03885 .56367 L
.04344 .56868 L
.05848 .58139 L
.06974 .5883 L
.0781 .59177 L
.09772 .59776 L
.11735 .60049 L
.13697 .60048 L
.15659 .59795 L
.17622 .59286 L
.18837 .5883 L
.19584 .58496 L
.21546 .57346 L
.22175 .56868 L
.23509 .55651 L
.24113 .54906 L
.2526 .52943 L
.25471 .52386 L
.25801 .50981 L
.25801 .49019 L
.25471 .47614 L
.2526 .47057 L
.24113 .45094 L
.23509 .44349 L
.22175 .43132 L
.21546 .42654 L
.19584 .41504 L
.18837 .4117 L
.17622 .40714 L
.15659 .40205 L
.13697 .39952 L
.11735 .39951 L
.09772 .40224 L
.0781 .40823 L
.06974 .4117 L
.05848 .41861 L
.04344 .43132 L
.03885 .43633 L
.03028 .45094 L
.02275 .47057 L
.01923 .47359 L
F
0 g
.01923 .52641 m
.02275 .52943 L
.03028 .54906 L
.03885 .56367 L
.04344 .56868 L
.05848 .58139 L
.06974 .5883 L
.0781 .59177 L
.09772 .59776 L
.11735 .60049 L
.13697 .60048 L
.15659 .59795 L
.17622 .59286 L
.18837 .5883 L
.19584 .58496 L
.21546 .57346 L
.22175 .56868 L
.23509 .55651 L
.24113 .54906 L
.2526 .52943 L
.25471 .52386 L
.25801 .50981 L
.25801 .49019 L
.25471 .47614 L
.2526 .47057 L
.24113 .45094 L
.23509 .44349 L
.22175 .43132 L
.21546 .42654 L
.19584 .41504 L
.18837 .4117 L
.17622 .40714 L
.15659 .40205 L
.13697 .39952 L
.11735 .39951 L
.09772 .40224 L
.0781 .40823 L
.06974 .4117 L
.05848 .41861 L
.04344 .43132 L
.03885 .43633 L
.03028 .45094 L
.02275 .47057 L
.01923 .47359 L
s
1 .6 0 r
.01923 .45945 m
.01999 .45094 L
.0216 .43132 L
.03294 .4117 L
.03103 .39207 L
.03661 .37245 L
.03885 .3671 L
.04497 .35283 L
.05397 .3332 L
.05688 .31358 L
.05848 .30949 L
.06493 .29396 L
.07341 .27433 L
.0781 .26325 L
.0821 .25471 L
.09173 .23509 L
.09772 .22327 L
.10184 .21546 L
.11261 .19584 L
.11735 .18749 L
.12393 .17622 L
.13584 .15659 L
.13697 .15477 L
.14833 .13697 L
.15659 .12446 L
.16139 .11735 L
.17503 .09772 L
.17622 .09606 L
.18924 .0781 L
.19584 .06926 L
.20403 .05848 L
.21546 .0438 L
.21939 .03885 L
.23509 .01951 L
.23532 .01923 L
.01923 .01923 L
F
0 g
.01923 .45945 m
.01999 .45094 L
.0216 .43132 L
.03294 .4117 L
.03103 .39207 L
.03661 .37245 L
.03885 .3671 L
.04497 .35283 L
.05397 .3332 L
.05688 .31358 L
.05848 .30949 L
.06493 .29396 L
.07341 .27433 L
.0781 .26325 L
.0821 .25471 L
.09173 .23509 L
.09772 .22327 L
.10184 .21546 L
.11261 .19584 L
.11735 .18749 L
.12393 .17622 L
.13584 .15659 L
.13697 .15477 L
.14833 .13697 L
.15659 .12446 L
.16139 .11735 L
.17503 .09772 L
.17622 .09606 L
.18924 .0781 L
.19584 .06926 L
.20403 .05848 L
.21546 .0438 L
.21939 .03885 L
.23509 .01951 L
.23532 .01923 L
s
1 .6 0 r
.01923 .54055 m
.01999 .54906 L
.0216 .56868 L
.03294 .5883 L
.03103 .60793 L
.03661 .62755 L
.03885 .6329 L
.04497 .64717 L
.05397 .6668 L
.05688 .68642 L
.05848 .69051 L
.06493 .70604 L
.07341 .72567 L
.0781 .73675 L
.0821 .74529 L
.09173 .76491 L
.09772 .77673 L
.10184 .78454 L
.11261 .80416 L
.11735 .81251 L
.12393 .82378 L
.13584 .84341 L
.13697 .84523 L
.14833 .86303 L
.15659 .87554 L
.16139 .88265 L
.17503 .90228 L
.17622 .90394 L
.18924 .9219 L
.19584 .93074 L
.20403 .94152 L
.21546 .9562 L
.21939 .96115 L
.23509 .98049 L
.23532 .98077 L
.01923 .98077 L
F
0 g
.01923 .54055 m
.01999 .54906 L
.0216 .56868 L
.03294 .5883 L
.03103 .60793 L
.03661 .62755 L
.03885 .6329 L
.04497 .64717 L
.05397 .6668 L
.05688 .68642 L
.05848 .69051 L
.06493 .70604 L
.07341 .72567 L
.0781 .73675 L
.0821 .74529 L
.09173 .76491 L
.09772 .77673 L
.10184 .78454 L
.11261 .80416 L
.11735 .81251 L
.12393 .82378 L
.13584 .84341 L
.13697 .84523 L
.14833 .86303 L
.15659 .87554 L
.16139 .88265 L
.17503 .90228 L
.17622 .90394 L
.18924 .9219 L
.19584 .93074 L
.20403 .94152 L
.21546 .9562 L
.21939 .96115 L
.23509 .98049 L
.23532 .98077 L
s
1 0 .9 r
.01923 .52592 m
.02343 .52943 L
.03146 .54906 L
.03885 .56076 L
.0472 .56868 L
.05848 .57649 L
.0781 .58481 L
.09548 .5883 L
.09772 .58847 L
.11735 .58857 L
.1204 .5883 L
.13697 .58546 L
.15659 .579 L
.17577 .56868 L
.17622 .5684 L
.19584 .55177 L
.19813 .54906 L
.21067 .52943 L
.21546 .51524 L
.21647 .50981 L
.21647 .49019 L
.21546 .48476 L
.21067 .47057 L
.19813 .45094 L
.19584 .44823 L
.17622 .4316 L
.17577 .43132 L
.15659 .421 L
.13697 .41454 L
.1204 .4117 L
.11735 .41143 L
.09772 .41153 L
.09548 .4117 L
.0781 .41519 L
.05848 .42351 L
.0472 .43132 L
.03885 .43924 L
.03146 .45094 L
.02343 .47057 L
.01923 .47408 L
F
0 g
.01923 .52592 m
.02343 .52943 L
.03146 .54906 L
.03885 .56076 L
.0472 .56868 L
.05848 .57649 L
.0781 .58481 L
.09548 .5883 L
.09772 .58847 L
.11735 .58857 L
.1204 .5883 L
.13697 .58546 L
.15659 .579 L
.17577 .56868 L
.17622 .5684 L
.19584 .55177 L
.19813 .54906 L
.21067 .52943 L
.21546 .51524 L
.21647 .50981 L
.21647 .49019 L
.21546 .48476 L
.21067 .47057 L
.19813 .45094 L
.19584 .44823 L
.17622 .4316 L
.17577 .43132 L
.15659 .421 L
.13697 .41454 L
.1204 .4117 L
.11735 .41143 L
.09772 .41153 L
.09548 .4117 L
.0781 .41519 L
.05848 .42351 L
.0472 .43132 L
.03885 .43924 L
.03146 .45094 L
.02343 .47057 L
.01923 .47408 L
s
1 0 .6 r
.01923 .52544 m
.02415 .52943 L
.03276 .54906 L
.03885 .55796 L
.05261 .56868 L
.05848 .57168 L
.0781 .57782 L
.09772 .579 L
.11735 .57601 L
.13697 .56869 L
.13699 .56868 L
.15659 .55616 L
.16392 .54906 L
.17622 .53273 L
.17767 .52943 L
.18387 .50981 L
.18387 .49019 L
.17767 .47057 L
.17622 .46727 L
.16392 .45094 L
.15659 .44384 L
.13699 .43132 L
.13697 .43131 L
.11735 .42399 L
.09772 .421 L
.0781 .42218 L
.05848 .42832 L
.05261 .43132 L
.03885 .44204 L
.03276 .45094 L
.02415 .47057 L
.01923 .47456 L
F
0 g
.01923 .52544 m
.02415 .52943 L
.03276 .54906 L
.03885 .55796 L
.05261 .56868 L
.05848 .57168 L
.0781 .57782 L
.09772 .579 L
.11735 .57601 L
.13697 .56869 L
.13699 .56868 L
.15659 .55616 L
.16392 .54906 L
.17622 .53273 L
.17767 .52943 L
.18387 .50981 L
.18387 .49019 L
.17767 .47057 L
.17622 .46727 L
.16392 .45094 L
.15659 .44384 L
.13699 .43132 L
.13697 .43131 L
.11735 .42399 L
.09772 .421 L
.0781 .42218 L
.05848 .42832 L
.05261 .43132 L
.03885 .44204 L
.03276 .45094 L
.02415 .47057 L
.01923 .47456 L
s
1 .3 0 r
.01923 .45485 m
.01941 .45094 L
.02057 .43132 L
.02877 .4117 L
.02701 .39207 L
.03077 .37245 L
.03727 .35283 L
.03885 .34933 L
.0462 .3332 L
.04864 .31358 L
.05463 .29396 L
.05848 .28255 L
.06147 .27433 L
.06895 .25471 L
.07598 .23509 L
.0781 .22833 L
.08334 .21546 L
.09156 .19584 L
.09772 .18114 L
.09992 .17622 L
.10892 .15659 L
.11735 .13868 L
.11818 .13697 L
.12794 .11735 L
.13697 .0997 L
.138 .09772 L
.14851 .0781 L
.15659 .0634 L
.15935 .05848 L
.1706 .03885 L
.17622 .02925 L
.1822 .01923 L
.01923 .01923 L
F
0 g
.01923 .45485 m
.01941 .45094 L
.02057 .43132 L
.02877 .4117 L
.02701 .39207 L
.03077 .37245 L
.03727 .35283 L
.03885 .34933 L
.0462 .3332 L
.04864 .31358 L
.05463 .29396 L
.05848 .28255 L
.06147 .27433 L
.06895 .25471 L
.07598 .23509 L
.0781 .22833 L
.08334 .21546 L
.09156 .19584 L
.09772 .18114 L
.09992 .17622 L
.10892 .15659 L
.11735 .13868 L
.11818 .13697 L
.12794 .11735 L
.13697 .0997 L
.138 .09772 L
.14851 .0781 L
.15659 .0634 L
.15935 .05848 L
.1706 .03885 L
.17622 .02925 L
.1822 .01923 L
s
1 .3 0 r
.01923 .54515 m
.01941 .54906 L
.02057 .56868 L
.02877 .5883 L
.02701 .60793 L
.03077 .62755 L
.03727 .64717 L
.03885 .65067 L
.0462 .6668 L
.04864 .68642 L
.05463 .70604 L
.05848 .71745 L
.06147 .72567 L
.06895 .74529 L
.07598 .76491 L
.0781 .77167 L
.08334 .78454 L
.09156 .80416 L
.09772 .81886 L
.09992 .82378 L
.10892 .84341 L
.11735 .86132 L
.11818 .86303 L
.12794 .88265 L
.13697 .9003 L
.138 .90228 L
.14851 .9219 L
.15659 .9366 L
.15935 .94152 L
.1706 .96115 L
.17622 .97075 L
.1822 .98077 L
.01923 .98077 L
F
0 g
.01923 .54515 m
.01941 .54906 L
.02057 .56868 L
.02877 .5883 L
.02701 .60793 L
.03077 .62755 L
.03727 .64717 L
.03885 .65067 L
.0462 .6668 L
.04864 .68642 L
.05463 .70604 L
.05848 .71745 L
.06147 .72567 L
.06895 .74529 L
.07598 .76491 L
.0781 .77167 L
.08334 .78454 L
.09156 .80416 L
.09772 .81886 L
.09992 .82378 L
.10892 .84341 L
.11735 .86132 L
.11818 .86303 L
.12794 .88265 L
.13697 .9003 L
.138 .90228 L
.14851 .9219 L
.15659 .9366 L
.15935 .94152 L
.1706 .96115 L
.17622 .97075 L
.1822 .98077 L
s
1 0 .3 r
.01923 .52497 m
.02491 .52943 L
.03423 .54906 L
.03885 .55525 L
.05848 .56693 L
.06303 .56868 L
.0781 .57069 L
.09772 .56896 L
.09929 .56868 L
.11735 .56219 L
.13611 .54906 L
.13697 .54842 L
.15132 .52943 L
.15659 .51603 L
.15794 .50981 L
.15794 .49019 L
.15659 .48397 L
.15132 .47057 L
.13697 .45158 L
.13611 .45094 L
.11735 .43781 L
.09929 .43132 L
.09772 .43104 L
.0781 .42931 L
.06303 .43132 L
.05848 .43307 L
.03885 .44475 L
.03423 .45094 L
.02491 .47057 L
.01923 .47503 L
F
0 g
.01923 .52497 m
.02491 .52943 L
.03423 .54906 L
.03885 .55525 L
.05848 .56693 L
.06303 .56868 L
.0781 .57069 L
.09772 .56896 L
.09929 .56868 L
.11735 .56219 L
.13611 .54906 L
.13697 .54842 L
.15132 .52943 L
.15659 .51603 L
.15794 .50981 L
.15794 .49019 L
.15659 .48397 L
.15132 .47057 L
.13697 .45158 L
.13611 .45094 L
.11735 .43781 L
.09929 .43132 L
.09772 .43104 L
.0781 .42931 L
.06303 .43132 L
.05848 .43307 L
.03885 .44475 L
.03423 .45094 L
.02491 .47057 L
.01923 .47503 L
s
1 0 0 r
.01923 .5245 m
.02571 .52943 L
.03591 .54906 L
.03885 .55262 L
.05848 .56221 L
.0781 .56346 L
.09772 .55832 L
.11296 .54906 L
.11735 .54597 L
.12998 .52943 L
.13697 .51025 L
.13705 .50981 L
.13705 .49019 L
.13697 .48975 L
.12998 .47057 L
.11735 .45403 L
.11296 .45094 L
.09772 .44168 L
.0781 .43654 L
.05848 .43779 L
.03885 .44738 L
.03591 .45094 L
.02571 .47057 L
.01923 .4755 L
F
0 g
.01923 .5245 m
.02571 .52943 L
.03591 .54906 L
.03885 .55262 L
.05848 .56221 L
.0781 .56346 L
.09772 .55832 L
.11296 .54906 L
.11735 .54597 L
.12998 .52943 L
.13697 .51025 L
.13705 .50981 L
.13705 .49019 L
.13697 .48975 L
.12998 .47057 L
.11735 .45403 L
.11296 .45094 L
.09772 .44168 L
.0781 .43654 L
.05848 .43779 L
.03885 .44738 L
.03591 .45094 L
.02571 .47057 L
.01923 .4755 L
s
1 0 0 r
.01923 .44613 m
.01958 .43132 L
.02283 .4117 L
.02209 .39207 L
.02351 .37245 L
.02628 .35283 L
.03083 .3332 L
.03846 .31358 L
.03885 .31172 L
.04222 .29396 L
.04627 .27433 L
.05082 .25471 L
.05588 .23509 L
.05848 .22572 L
.06183 .21546 L
.0686 .19584 L
.0747 .17622 L
.07757 .15659 L
.0781 .15488 L
.08401 .13697 L
.09048 .11735 L
.09639 .09772 L
.09772 .09282 L
.10287 .0781 L
.10981 .05848 L
.11657 .03885 L
.11735 .03655 L
.12385 .01923 L
.01923 .01923 L
F
0 g
.01923 .44613 m
.01958 .43132 L
.02283 .4117 L
.02209 .39207 L
.02351 .37245 L
.02628 .35283 L
.03083 .3332 L
.03846 .31358 L
.03885 .31172 L
.04222 .29396 L
.04627 .27433 L
.05082 .25471 L
.05588 .23509 L
.05848 .22572 L
.06183 .21546 L
.0686 .19584 L
.0747 .17622 L
.07757 .15659 L
.0781 .15488 L
.08401 .13697 L
.09048 .11735 L
.09639 .09772 L
.09772 .09282 L
.10287 .0781 L
.10981 .05848 L
.11657 .03885 L
.11735 .03655 L
.12385 .01923 L
s
1 0 0 r
.01923 .55387 m
.01958 .56868 L
.02283 .5883 L
.02209 .60793 L
.02351 .62755 L
.02628 .64717 L
.03083 .6668 L
.03846 .68642 L
.03885 .68828 L
.04222 .70604 L
.04627 .72567 L
.05082 .74529 L
.05588 .76491 L
.05848 .77428 L
.06183 .78454 L
.0686 .80416 L
.0747 .82378 L
.07757 .84341 L
.0781 .84512 L
.08401 .86303 L
.09048 .88265 L
.09639 .90228 L
.09772 .90718 L
.10287 .9219 L
.10981 .94152 L
.11657 .96115 L
.11735 .96345 L
.12385 .98077 L
.01923 .98077 L
F
0 g
.01923 .55387 m
.01958 .56868 L
.02283 .5883 L
.02209 .60793 L
.02351 .62755 L
.02628 .64717 L
.03083 .6668 L
.03846 .68642 L
.03885 .68828 L
.04222 .70604 L
.04627 .72567 L
.05082 .74529 L
.05588 .76491 L
.05848 .77428 L
.06183 .78454 L
.0686 .80416 L
.0747 .82378 L
.07757 .84341 L
.0781 .84512 L
.08401 .86303 L
.09048 .88265 L
.09639 .90228 L
.09772 .90718 L
.10287 .9219 L
.10981 .94152 L
.11657 .96115 L
.11735 .96345 L
.12385 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{Inherited, Inherited}, {Inherited, 0}},
  ImageSize->{217, 217},
  ImageMargins->{{70, 0}, {0, 8.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003I0000fA000`40O003h00OfGoo000AOol2000F
Ool20004Ool20004Ool2000DOol5000COol50002Ool20004Ool2000EOol4000DOol40003Ool20004
Ool2000EOol2000DOol0011oo`04001oogoo000DOol01000Oomoo`0027oo00@007ooOol001Eoo`03
001oogoo01Eoo`03001oogoo00Moo`04001oogoo000DOol00`00Oomoo`0EOol00`00Oomoo`09Ool0
1000Oomoo`004goo00@007ooOol001=oo`0047oo00@007ooOol001Aoo`04001oogoo000;Ool00`00
Oomoo`0COol00`00Oomoo`0EOol00`00Oomoo`0:Ool00`00Oomoo`0COol00`00Oomoo`0EOol00`00
Oomoo`0;Ool00`00Oomoo`0COol00`00Oomoo`0BOol0011oo`04001oogoo000DOol01000Oomoo`00
2Goo0P005Woo00<007ooOol05Goo00<007ooOol027oo0P005goo00<007ooOol05Goo00<007ooOol0
27oo0P005goo00<007ooOol04Goo000@Ool01000Oomoo`0057oo00@007ooOol000Uoo`03001oogoo
01Eoo`03001oogoo01Eoo`03001oogoo00Qoo`03001oogoo01Aoo`04001oogoo000DOol01000Oomo
o`002Goo00<007ooOol04goo00@007ooOol001=oo`004Goo0P005Woo0P002Woo0`0057oo0P005Woo
0P002Woo0`005Goo0P005Woo0P002Woo0`0057oo0P0057oo003IOol00=Uoo`00fGoo003?Ool20000
0goo00000005Ool00=1oo`03001oo`0000Ioo`003goo^P0027oo00<007ooOol01Goo0009Ool20004
Ool01000Oomoo`001Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
0goo00D007ooOomoo`0000Ioo`800003Ool0000000Eoo`0027oo00@007ooOol000=oo`03001oogoo
0;Ioo`03001oogoo00ioo`002Woo00<007ooOol00Woo0P005Goo00<007ooOol027oo00<007ooOol0
1Woo00<007ooOol027oo00<007ooOol02goo00<007ooOol047oo00<007ooOol087oo00<007ooOol0
>goo0P0047oo0002Ool40005Ool01@00Oomoogoo00000Woo57`000/007d0OB1m07dPO@1m87d0OB1m
000000=n@00MOV1n@7i0OT1nH000Oh1oH7n0Of1oP7mPOh1oH7n0Of0006?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh00200001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh00S>n0000006n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0030003
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R17oo00<0
07ooOol03Woo0008Ool01000Oomoo`000goo00<007ooOol04g`000/007d0OB1m07dPO@1m87d0OB1m
000000Qn@003001oP7n000QoP00>001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00014oh08000<Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP00@003h3
hPAoo`03001oogoo00ioo`002Goo0P0017oo00<007ooOol04g`000X007dPO@1m87d0OB1m07dPO@00
00=n@00LOV1n@7i0OT1nH7i0001oH7n0Of1oP7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OP
Hn0200000coP>n0oh002?n001C_P?n0oh3oP>n000coP00<kh3oP?n000P0001`Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0@000050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?R
Ool00goo00<007ooOol03Woo000?Ool00`00Oomoo`0BO00200002Gd0OB1m07dPO@1m87d0OB000008
OT000`00Oh1oP007Oh0200002fOPHn1Wh6?PIn1Sh6OPHn1Wh6?P000043oP0P0000<Gh1_P5n000QOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n001000AP?R17oo00<007oo
Ool03Woo000?Ool00`00Oomoo`0BO0002P00O@1m87d0OB1m07dPO@1m80000Wi000EnH7i0OT1n@7iP
009n@00F001oP7mPOh1oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P0002?n001C_P?n0o
h3oP>n000coP00Dkh3oP?n0oh3_P0080000I6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n000`000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R17oo00<007ooOol0
3Woo000?Ool200000gooO01l000?O0002`00O@1m87d0OB1m07dPO@1m87d0000027i000<007n0Oh00
1Wn000/006?PIn1Sh6OPHn1Wh6?PIn1Sh6OP008000loh005000Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0@004d3hP=oo`80011oo`003goo00<007ooOol04G`000`007dP
O@1m87d0OB1m07dPO@0007i0OV03OT0067iPOT1n@7i0001oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1S
h6OPHn1Wh6?PIn0000<oh005>n0oh3oP?n0kh003?n0013_P?n0oh3oP0P0001HGh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh08000<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP060n<3hP?R0n83h`?R17oo00<007ooOol03Woo000?Ool00`00Oomoo`0AO0002P00O@1m87d0OB1m
07dPO@1m800027i000<007n0Oh001Wn000/006OPHn1Wh6?PIn1Sh6OPHn1Wh00000doh0<000056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh0@005<3hPAoo`03001oogoo00ioo`00
3goo00<007ooOol04G`000X007dPO@1m87d0OB1m07dPO@0000=n@00FOV1n@7i0OT0007mPOh1oH7n0
Of1oP7mPOh0006OPHn1Wh6?PIn1Sh6OPHn020003?n001C_P?n0oh3oP>n000coP01Pkh000000Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0200030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00@3h`?R0n83hPAoo`03001oogoo00ioo`003goo00<007oo
Ool047`000X007dPO@1m87d0OB1m07dPO@0000Mn@003001oP7n000EoP0800009In1Sh6OPHn1Wh6?P
In1Sh00000`oh08000<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP000003l3
hQ/000=oo`03001oogoo00ioo`003goo00<007ooOol047`000T007d0OB1m07dPO@1m87d000000gi0
01QnH7i0OT1n@000Of1oP7mPOh1oH7n0Of0006?PIn1Sh6OPHn1Wh6?PIn1Sh000>n03?n001C_P?n0o
h3oP>n000coP01<001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh00500000`?R0n<3
hP020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0000000900006P?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/4Ool00`00Oomoo`0>
Ool000moo`800003Ooml07`000il0008001m87d0OB1m07dPO@0000Mn@003001oP7n000EoP00;001S
h6OPHn1Wh6?PIn1Sh6OPHn00000<?n000`006n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00800303hP/002D3k0=oo`80011oo`003goo00<007ooOol03g`000T007dPO@1m87d0OB1m07dP
00000Wi001QnH7i0OT1n@000Of1oP7mPOh1oH7n0Of0006?PIn1Sh6OPHn1Wh6?PIn1Sh000>n03?n00
1C_P?n0oh3oP>n000SoP0P00010Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0800083hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00<3h`0000001@000303k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/4Ool00`00Oomoo`0>Ool000moo`03001oogoo00ml0008001m07dPO@1m87d0OB0000Mn
@003001oP7n000EoP008001Wh6?PIn1Sh6OPHn1Wh08000Xoh08000035n0Kh1OP008Gh0056n0Gh1OP
5n0Kh0035n000a_P5n0Gh002000V0n87000g0n`4Ool00`00Oomoo`0>Ool000moo`03001oogoo00ml
000:001m87d0OB1m07dPO@0007i0OV03OT0057iP001oP7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?P
In0003oP>n03?n001C_P?n0oh3oP>n000P0000lKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n00
0`0000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hPP0000n0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`Aoo`03001oogoo00ioo`003goo00<007ooOol03g`000L007d0OB1m07dP
O@000006OT000`00Oh1oP005Oh002@00In1Sh6OPHn1Wh6?PIn00000:?n001@005n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0800203hP<004H3k0Aoo`03001oogoo00ioo`003goo00<007ooOol03W`0
00T007d0OB1m07dPO@1m8000OV000gi001AnH7i0001oH7n0Of1oP7mPOh0006OPHn1Wh6?PIn1Sh6OP
000oh3_P0coP00@kh3oP?n0oh080000=5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n000`000`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00P?R200004T3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`04Ool00`00Oomoo`0>Ool000moo`800003Ooml07`000al0007001m87d0
OB1m07dP00001Wi000<007n0Oh0017n000T006OPHn1Wh6?PIn1Sh6OP000023oP0P0000DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh002000K0n82001A0n`3Ool2000@Ool000moo`03001oogoo00il0007
001m07dPO@1m87d000000gi0011nH7i0OT0007n0Of1oP7mPOh0006OPHn1Wh6?PIn1Sh0800003?n0k
h3oP008oh00A>n0oh3oP?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh00200020n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP060n<3hP?R0n83h`?R1@0005<3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Aoo`03001oogoo00ioo`003goo00<007ooOol03G`0
00P007d0OB1m07dPO@1m80001Gi000<007n0Oh000gn000P006OPHn1Wh6?PIn1Sh0002CoP0P0000DK
h1OP5n0Gh1_P00<Gh0036n0Gh1OP008001L3hP<005P3k0Aoo`03001oogoo00ioo`003goo00<007oo
Ool03G`000L007dPO@1m87d0OB000002OT004GiPOT1n@000Oh1oH7n0Of1oP000In1Sh6OPHn1Wh6?P
00000SoP00Hkh3oP?n0oh3_P?n0200002aOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n000P0000D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0100005/3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`04Ool00`00Oomoo`0>Ool0
00moo`03001oogoo00al0008001m87d0OB1m07dPO@0000An@003001oP7n000=oP008001Wh6?PIn1S
h6OPHn0000Loh080008Gh0056n0Gh1OP5n0Kh0035n03000C0n84001O0n`4Ool00`00Oomoo`0>Ool0
00moo`03001oogoo00al0009001m07dPO@1m87d0001n@7iP009n@00>001oP7mPOh1oH7n0001Wh6?P
In1Sh6OPHn00008oh00@>n0oh3oP?n0kh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0200030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP<0001S0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Aoo`03001oogoo
00ioo`003goo0P0000=oog`0O0002G`000P007d0OB1m07dPO@1m800017i000<007n0Oh000Wn000P0
06OPHn1Wh6?PIn1Sh0001coP00D001OP5n0Gh1_P00<Gh0046n0Gh000000A0n84001V0n`3Ool2000@
Ool000moo`03001oogoo00]l0008001m87d0OB1m07dP001nH0=n@00=001oH7n0Of1oP7mP001Sh6OP
Hn1Wh6?P00000SoP00@kh3oP?n0oh08000085n0Kh1OP6n0Gh1_P5n0Kh08000030n83h`?R0083hP05
0n<3hP?R0n83h`030n800`?S0n83hP030000JP?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
17oo00<007ooOol03Woo000?Ool00`00Oomoo`0;O0001`00O@1m87d0OB1m000000An@003001oP7n0
009oP007001Sh6OPHn1Wh6?P00001SoP00<001_P5n000QOP00HKh1OP5n0Gh1_P000>0n84001]0n`4
Ool00`00Oomoo`0>Ool000moo`03001oogoo00]l0006001m87d0OB1m00000gi000enH000Oh1oH7n0
Of0006?PIn1Sh6OPHn000002?n003C_P?n0oh3oP000Kh1OP6n0Gh1_P5n0Kh1OP00800083hP050n<3
hP?R0n83h`030n800`?S0n8000020000<`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`0E0000:@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/017oo00<007ooOol03Woo0008Ool40003
Ool00`00Oomoo`0;O0001P00O@1m87d0OB0000An@003001oP7n0009oP006001Wh6?PIn1Sh0001SoP
00<001_P5n000QOP00<Kh1OP5n000P0030?R0P008`?/4`000`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD00`?f0oD0000=000K0n`4Ool00`00Oomoo`0>Ool000Qoo`03001oogoo00Aoo`03
001oogoo00]l0005001m87d0OB000002OT001WiPOT0007mPOh1oH0800005In1Sh6OPHn000002?n00
0c_P?n0oh00200001Q_P5n0Kh1OP6n0Gh08000050n<3hP?R0n83h`030n800`?S0n83hP0300007P?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`L0
000f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f300000l3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/017oo00<007ooOol03Woo0009Ool00`00Oomoo`03Ool2
00000gooO01l0009O0001@00O@1m87d0000017i000X007n0Oh0006?PIn1Sh6OPHn0000Doh003000G
h1_P00<Gh0046n0Gh1OP000:0n82000J0n`700030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@060oH3m@?e0oD3mP?e1P002@?/
0goo0P0047oo0002Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`0:O0001`00O@1m87d0OB0007iP
009n@00:001oP7mPOh0006OPHn1Wh6?P0002?n002c_P?n0oh0005n0Kh1OP6n0Gh1_P5n000P0000D3
h`?R0n83hP?S00<3hP0H0n<000000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[1`0005H3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
200000<3jgooOol00Woo00<007ooOol03Woo0008Ool01000Oomoo`000goo00<007ooOol02W`000D0
07dPO@1m800000An@009001oP7n0001Wh6?PIn1Sh00000Doh003000Gh1_P00<Gh0036n00000000T3
hP8001<3k0@000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3m@000003Ool00`00Oomoo`0>Ool000Uoo`8000Ao
o`03001oogoo00Yl0005001m07dPO@000003OT002@00Of1oP7mP001Sh6OPHn000002?n002C_P?n00
00005n0Kh1OP6n0Gh00200020n801P?S0n83hP?R0n<3hP<0000A0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`040000JP?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e17oo00<007oo
Ool03Woo000?Ool00`00Oomoo`09O0001@00O@1m87d000000gi000T007n0Oh1oP000Hn1Wh6?P0000
13oP00@001OP5n0Kh0<Gh0030003hP?R00H3hP800143k0<000030oD3mP?e0083m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD00`?fOomoo`02Ool00`00Oomoo`0>Ool000moo`03001oogoo00Ul0005
001m87d0OB000002OT002GiP001oP7mP001Sh6OPHn000002?n002S_P?n0001_P5n0Kh1OP6n0Gh000
0`?R00@3h`?R0n83hP80000?0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00@0001a0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@04Ool00`00Oomoo`0>Ool000mo
o`800003Ooml07`000Il0005001m87d0OB000003OT002@00Oh1oP7n0001Wh6?PIn000003?n001000
5n0Gh1_P0QOP0P001P?R0P003@?/10000P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD00`?f0oD3m@03Ool2000@Ool000moo`03001oogoo00Ql000B001m07dPO@0007i0
OV1n@000Of1oP000In1Sh6OP000oh3_P0SoP00L001OP6n0Gh1_P0003h`030n8040?S0n8000000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0`0007T3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@04Ool00`00Oomoo`0>Ool000moo`03001oogoo00Ql
0004001m87d00003OT002000Oh1oP7n0001Sh6OP0003?n0200001AOP6n0Gh1OP00001@?R0P002P?/
10000`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00<3mWooOol00Woo00<007ooOol03Woo000?Ool00`00Oomoo`08O0005P00O@1m8000OV1n
@000Of1oP7mP001Sh6OP000oh3_P?n0001_P5n0Kh1OP0P0000l3h`?R0n83hP?S0003k0?[0n`3j`?/
0n/3k0?[0n`00`000803mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e17oo00<007ooOol03Woo000?Ool00`00Oomoo`07
O0001@00O@1m87d000000Wi000L007n0Oh0006?PIn000003?n001P005n0Gh1_P5n0000D3hP8000P3
k08000050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH00000
028000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00<3mP?e0oD017oo00<007ooOol03Woo000?Ool00`00Oomoo`07O0006000
OB1m07dP001n@000Oh1oH000Hn1Wh000?n0kh3oP000Kh1OP6n0Gh0000n83h`83hP8000080n/3k0?[
0n`3j`?/0n/3k080000D0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mPL002@3
o`L0000o0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e00Aoo`03001oogoo00ioo`003goo0P0000=oog`0O00017`000D007dPO@1m8000
009n@007001oP7n0001Wh6?P00000SoP00H001OP5n0Kh1OP00040n800`000n`3k0050n`300020oD0
1@?f0oD3m@?e0oH00`?e00@3mP?e0oD3m@P00383o`L000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03Ool2000@Ool000moo`03001oogoo00Il000H001m07dP
O@0007i0001oH7n0001Wh6?P000kh3oP000Kh1OP6n0Gh0000n83h`?R0P0000H3k0?[0n`3j`?/0n/2
00003P?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD300110ol70000<@?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e00Aoo`03001oogoo00ioo`003goo00<007ooOol01W`000L007dP
O@1m8000OT000002Oh000`00Hn000002?n0010005n0Gh1_P0P000`?R00<000?/0n`010?/0P0000<3
m@?f0oD00P?e00D3mP?e0oD3m@?f0083m@@004/3o`@00083m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3
mP?e0oD017oo00<007ooOol03Woo000?Ool00`00Oomoo`06O0004P00O@1m8000OV0007n0Of0006?P
000kh3oP000Kh1OP6n000083hP080n<000000n/3k0?[0n`3j`80000;0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP03001C0ol40000:@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD017oo00<007ooOol03Woo000?Ool0
0`00Oomoo`05O0001`00O@1m87d0001n@000009oP003001Wh000008oh004000Gh1_P00030n800`00
0n`3k0040n`01@000oD3m@?e0oH00`?e00<3mP?e00000`00FP?o0`0000<3m@?f0oD00P?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@03
0oIoogoo009oo`03001oogoo00ioo`003goo00<007ooOol01G`000/007dPO@0007i0001oH7n0001W
h000008oh004000Gh1_P00020n801`?S0003k0?[0n`3j`?/008000070oD3mP?e0oH3m@?f0oD00`00
H@?o10000283mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@Aoo`03001oogoo00ioo`003goo0P0000=oog`0O0000g`000H007d0OB00
07i00002Oh002000Hn0003oP000Gh1_P00030n800`000n`3k0020n`200001P?f0oD3m@?e0oH3m@<0
06P3o`@000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@03
0oH3m@?e00=oo`80011oo`003goo00<007ooOol01G`000l007dPO@0007i0001oH000Hn0003oP000G
h1_P00000P?R0P0000<3k0?[0n`00P0000H3m@?f0oD3mP?e0oH2000A0olL00120ol300006`?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@04Ool00`00Oomo
o`0>Ool000moo`03001oogoo00El0009001m0000OT0007n0001Sh000008oh006000Kh1OP0003hP00
10?/00@000?e0oD3mP83m@<000`3o`L000<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`030]l0000000H003d3o`<000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00Aoo`03001oogoo00ioo`003goo00<007ooOol01G`000H007dP
001nH000Oh020002?n002@006n0000000n8000?[0n`3j`0200000`?f0oD3mP0300070ol80000:`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o00@003`3o`80000F0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD4Ool00`00Oomoo`0>Ool000moo`03001oogoo00El0004001m0000
OT030002?n000`006n0000020n800`000n`3k00200030oD200070ol300001@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00P:o0`00>`?o0`0000D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD00`?f0oD3m@04Ool00`00Oomoo`0>Ool000moo`03001oogoo00Al0006
001m0000OT0007mP0P0000loh0006n0Gh0000n8000?[0n`000?f0oD3mP?e00001P?o0`0003d2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`03
000k0ol200004@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD017oo00<007ooOol03Woo
000?Ool200000gooO01l0002O0001000OB0007i00`000SoP00D001OP0003hP000083k0040003mP?e
0oD200050ol200001@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`030]l2_`:o00@003T3o`800083m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00goo0P0047oo000?Ool00`00Oomoo`04O0001@00O@000000Oh000P0000/kh0005n00
00?R0003j`?/0003mP?e008000@3o`<0000@0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l6
0000<`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`04000g0ol200003@?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e00Aoo`03001oogoo00ioo`003goo00<007ooOol017`000<0
07dP00000`0000Hoh0005n0000?R00020n`010000oH3m@0010?o0P000`:o00D2g`:o0[l2_`;O00/0
00H1W`/000<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`00000003H3o`8000050oH3m@?e0oD3mP03
0oD00`?f0oD3m@04Ool00`00Oomoo`0>Ool000moo`03001oogoo00=l0004001m8000OV0400001AOP
0003hP000n/00P0000<3mP?e00000`?o0P0000H2g`:o0]l2_`;O0[l40000706O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o1`0002P2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`@003@3o`8000090oD3mP?e0oH3m@?f0oD3mP?e00Aoo`03001oogoo00ioo`0027oo1@00
0Woo00<007ooOol00g`000@007d0001n@0800008?n0000000n8000?/0003m@<000060ol000000002
_`;O0P:o10009`6O1@0000<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`00000d0ol300000`?e0oH3m@020oD0
0`?fOomoo`02Ool00`00Oomoo`0>Ool000Yoo`03001oogoo009oo`03001oogoo00=l0003001m8000
00D000060n8000?[0003m@000`?o00H000:o0]l2_`;O0[l20000<06O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`<0000W0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`0003D3o`070003mP?e0oH3m@?f0oD0
17oo00<007ooOol03Woo000:Ool00`00Oomoo`02Ool200002GooO01l0000OB0007i0001Wh0040000
10?/0003m@000`?o00D000:o0[l2_`;O008003D1W`800082_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[l2_`02000d0ol20000
10?e0oH3m@?e0goo0P0047oo0002Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`02O0000`00O@00
0006000010?[0003m@000P?o0P0000<2_`;O00000P0000@1W`5o0Il1OaH0000O0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00P0002D2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`02000d0ol200000`?f0oEoo`03Ool00`00Oomoo`0>Ool000Yoo`03001oogoo009o
o`03001oogoo009l0003001m800000L000030oD000?o008000040]l2_`0000040Il3000F05l4000M
0Il400020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00<2g`000000=0?o0P0017oo00<007ooOol03Woo0009Ool20004Ool00`00Oomo
o`02O0000`00O@00000600001P?e0003o`000[l2g`8000030Gl1W`0000<000<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`000080000N0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0P0002@2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o000e0ol01@00Oomoogoo000047oo000?Ool01P00Oomoog`0001m00L000050oD000000002
_`0200020Il2000T05l3000M0Il200001@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o000003<3o`Aoo`03001oogoo00ioo`003goo
00H007ooOoml0000OB0900001@;O0[l0005o0Il00P000`1O00<0O`1O05l03P000`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l00`1o05l000030000@06O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`00<P?o17oo00<007ooOol0
3Woo000?Ool2000017ooO00007d01`0000D3o`000[l0006O008000@0G`@0000561lD7a@O51lH7`03
51l01QPO51lD7a@O61lD7`H001<0G`<001T1W`8000<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`020[l2000`0ol3Ool2000@Ool000moo`06
001oogooO00007dP100000<3j`000ol01@0000<0G`1o05l00`0001PD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l200000`1O07l0G`0205l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o0080G`80000I0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl00P000282g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`8002h3o`Aoo`03001oogoo00ioo`003goo00@007ooOoml
00`0000305l000000080000351lH7a@O00X0000561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
0`004`1O0P006@6O0P0000<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O008002`3o`Aoo`03001oogoo00ioo`003goo00@007oo
Ooml00P000030Gl0001O0080000361l0000000@00005>1ll7c`O?1lh7`03?1l00cPO?1l000040000
3QPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l300000`1O07l0G`0205l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o0080000n0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l002/3o`Aoo`03001oogoo00ioo`003goo00@007ooOoml00T00004
05l001@O61l2000D?1l3000251l01APO51lD7a@O61l00a@O00@H7a@O51lD7`800180G`030001W`6O
01H1W`040002_`:o0]l30[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01`;O0[l2_`:o0]l2_`0002X3o`Aoo`03001oogoo00ioo`003goo00@007ooOoml01/000<l
7`05>1ll7c`O?1lh7`03?1l2000041@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0001o0`1O00D0
O`1O05l0G`1o00<0G`1507l0G`1O05l0O`1O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0002T3o`Aoo`03001oogoo00ioo`003goo0P00
00=oog`00000300000iP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0`002S`O0P0000DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`02000A05l2000G0Il200000`:o0]l2_`020[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01P;O0[l2_`:o0]l002T3o`=oo`80011o
o`003goo00@007ooOoml00P00004>1l0060OI1l800002V0OI1mP7f@OH1mT7f0OI1mP7f@O0P0000Dh
7c`O?1ll7cPO00<l7`0B>1ll7`00000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`000`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0205l0?@000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0002_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`0002P3o`Aoo`03001oogoo00ioo`003goo00@007oo
Ooml00`000Ql70<0000:H1mT7f0OI1mP7f@OH1mT7f0O000;?1l01@0051lD7a@O61l00a@O00LH7a@O
51lD7aPO51l0000B05l00`000Il1W`0F0Il00`000[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01P;O0[l2_`:o0]l002L3o`Aoo`03001oogoo00ioo`00
3goo00<007ooOol0500000Al77`KO1al6`<00007H1mT7f0OI1mP7f@OH1l00P000c`O00Dh7c`O?1ll
7cPO008l7`80000=61lD7aPO51lH7a@O61lD7aPO51lH7a@O00000`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0205l0?@000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0002_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`0002H3o`Aoo`03001oogoo00ioo`003goo00<007ooOol03@001g`B0`00
17`L0P0000MT7f0OI1mP7f@OH1mT7`02000:?1l0100051lD7aPO0a@O00LH7a@O51lD7aPO51l0000A
05l00`000Il1W`0F0Il010000[l2_`;O0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`0002H3o`Aoo`03001oogoo00ioo`003goo0P0000=oo`00
0000200000=l2G`8O0T0100000=l4W`CO1800W`B014007`KO1al6g`LO1]l7000I1mP7f@OH1mT7f0O
I1mP7`00008l7`05>1ll7c`O?1lh7`02?1l03`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51l00003
05l01@1o05l0G`1O07l00`1O01l0O`1O05l0G`1o05l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0200008P:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`009@?o0goo0P0047oo000?Ool00`00Oomo
o`0=000017`9O0Ql2G`80`000g`B0P001G`L00X006@OH1mT7f0OI1mP7f@OH1l000Tl7`05000D7a@O
51lH7`0351l01aPO51lD7a@O61lD7`000140G`030001W`6O01H1W`040002_`:o0]l30[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o000090?o17oo
00<007ooOol03Woo000?Ool00`00Oomoo`080005O00400000g`8O0Ul20020002O1801g`C000007`K
O1al6g`L00800008H1mT7f0OI1mP7f@OH1l0008l7`05>1ll7c`O?1lh7`02?1l03`0051lH7a@O61lD
7aPO51lH7a@O61lD7aPO51l0000305l01@1o05l0G`1O07l00`1O0480O`1O05l0G`1o05l0005o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O000T0ol4Ool0
0`00Oomoo`0>Ool000moo`03001oogoo00H000]l00800004O0Ul27`90004O1800`00O1al7003O1`0
2@00H1mT7f0OI1mP7f@OH1l00009?1l2000251l01APO51lD7a@O61l00a@O00<H7a@O00004@1O00<0
006O0Il05@6O00D000:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`040]l2_`:o000S0ol4Ool00`00Oomoo`0>Ool000moo`03001oogoo00@000ml
0005001l2G`8O0T00002O1804G`CO18007`KO1al6g`LO1/0060OI1mP7f@OH1mT7f0O00000S`O00Dh
7c`O?1ll7cPO00<l7`0>000H7a@O61lD7aPO51lH7a@O61lD7aPO51l000<0G`0507l0G`1O05l0O`03
05l0@@1o05l0G`1O07l0G`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`000[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o00008`?o17oo00<007ooOol03Woo000?Ool00`00Oomoo`03000AO0001@00O0Ul
27`900000g`B00<007`LO1`017`L00T0060OI1mP7f@OH1mT7f0O00002C`O00D001@O51lD7aPO00<D
7`0661lD7a@O51lH7`004@1O00<0006O0Il05@6O00<000;O0[l00P:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00L2g`:o0[l2_`;O0[l0000R0ol4Ool00`00Oomo
o`0>Ool000moo`800004Ool00000000AO0001@00O0Ql2G`800000g`B011l4`00O1al6g`LO1]l7000
I1mP7f@OH1mT7f0OI1l000<l7`05>1ll7c`O?1lh7`02?1l03`0051lH7a@O61lD7aPO51lH7a@O61lD
7aPO0000O`0305l01@1o05l0G`1O07l00`1O0400O`1O05l0G`1o0001W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0002g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l00283o`=oo`80011oo`003goo00<007oo
Ool00`004W`000D007`8O0Ul200000Al4P03001l77`L00=l7009001T7f0OI1mP7f@OH1mT7`0000Tl
7`03000H7a@O008D7`0561lD7a@O51lH7`0351l00`0005l0G`0?05l00`000Il1W`0E0Il00`000[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o00008P?o17oo00<007ooOol03Woo000?Ool00`00Oomoo`02000CO0001P00O0Ul27`9O0P000=l
4P0@001l6g`LO1]l77`K001P7f@OH1mT7f0OI1mP7`00>1l3?1l04cPO?1ll7c`O>1l001@O61lD7aPO
51lH7a@O61lD7aPO51lH7`000080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O03/0006O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`000283o`Ao
o`03001oogoo00ioo`003goo00<007ooOol05W`000D007`9O0Ql2@0000Al4P03001l77`L00=l7008
001P7f@OH1mT7f0OI1l000Xl7`03000D7aPO00<D7`0561lD7a@O51lH7`0251l00`0005l0G`0>05l0
0`000Il1W`0E0Il01@000[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00@2g`:o0[l00243o`Aoo`03001oogoo00ioo`002Goo0P0017oo00<007oo
Ool05W`000L007`8O0Ul2000O19l4`02O1804@00O1al6g`LO1]l7000I1mP7f@OH1mT7f0OI1l003`O
>1l00c`O018h7c`O?1ll7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O000305l01@1o05l0G`1O07l0
0`1O0440O`1O05l0G`1o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`000243o`Aoo`03001oogoo00ioo`0027oo00@007ooOol000=oo`03001oogoo
01Il0005001l2G`8O0T00004O1800`00O1al7003O1`02@00H1mT7f0OI1mP7f@OH1l00009?1l01@00
51lD7a@O61l00a@O00HH7a@O51lD7aPO000@05l00`000Il1W`0F0Il00`000]l2_`020[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01P;O0[l2_`:o0]l00243o`Ao
o`03001oogoo00ioo`0027oo00@007ooOol000=oo`800003Ooml07`001Al0005001l27`9O0P00003
O18047`C001l77`KO1al6g`L001T7f0OI1mP7f@OH1mT7`000c`O01Hh7c`O?1ll7cPO?1l001PO51lH
7a@O61lD7aPO51lH7a@O61lD7`0005l0O`<0G`0507l0G`1O05l0O`0305l0?`1o05l0G`000Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0002_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0000Q0ol3Ool2
000@Ool000Qoo`04001oogoo0003Ool00`00Oomoo`0FO0001@00O0Ul27`9000017`B00<007`LO1`0
0g`L00T0060OI1mP7f@OH1mT7f0O00002C`O00<001@O61l00a@O00DH7a@O51lD7aPO008D7`030000
G`1O00h0G`030001W`6O01H1W`040002_`:o0]l30[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`008@?o17oo00<007ooOol03Woo0008Ool01000Oomo
o`000goo00<007ooOol05W`000L007`8O0Ul2000O19l4`02O1804@00O1al6g`LO1]l7000I1mP7f@O
H1mT7f0OI1l003`O>1l00c`O018h7c`O?1ll7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O000305l0
1@1o05l0G`1O07l00`1O0440O`1O05l0G`1o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`000243o`Aoo`03001oogoo00ioo`002Goo0P0017oo00<0
07ooOol05W`000D007`9O0Ql2@0000Al4P03001l77`L00=l7009001P7f@OH1mT7f0OI1mP7`0000Tl
7`05000D7a@O51lH7`0351l01QPO51lD7a@O61l00100G`030001W`6O01D1W`030002_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`00
8@?o17oo00<007ooOol03Woo000?Ool00`00Oomoo`0EO0001P00O0Ul27`9O0P000=l4P0@001l6g`L
O1]l77`KO1`006@OH1mT7f0OI1mP7`00>1l3?1l04cPO?1ll7c`O>1l001@O61lD7aPO51lH7a@O61lD
7aPO51lH7`000080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O03/0006O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`000283o`Aoo`03001oogoo
00ioo`003goo00@007ooOol001Al0005001l27`9O0P00004O1800`00O1al7003O1`02@00I1mP7f@O
H1mT7f0OI1l00009?1l0100051lD7aPO0a@O00LH7a@O51lD7aPO51l0000A05l00`000Il1W`0E0Il0
1@000[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00<2g`:o00008P?o17oo00<007ooOol03Woo000?Ool2000017oo000000004W`000D007`9O0Ql
2@00009l4P0AO1<00000O1]l77`KO1al6`00H1mT7f0OI1mP7f@OH1l00002?1l01CPO?1ll7c`O>1l0
0S`O00l001@O61lD7aPO51lH7a@O61lD7aPO51lH7`0007l00`1O00D0O`1O05l0G`1o00<0G`1007l0
G`1O05l0O`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O000R0ol3Ool2000@Ool000moo`03001oogoo00<0015l0005001l2G`8O0T00003O1800`00O1al
7004O1`02@00H1mT7f0OI1mP7f@OH1l00009?1l00`0051lH7`0351l01APO51lD7a@O61l00Q@O00<0
001O05l03`1O00<0006O0Il05@6O00@000:o0[l2g`<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l0000R0ol4Ool00`00Oomoo`0>Ool000moo`03
001oogoo00@0011l0004001l27`90002O1804G`CO18007`KO1al6g`LO1/0060OI1mP7f@OH1mT7f0O
00000S`O00Dh7c`O?1ll7cPO00<l7`0>000H7a@O61lD7aPO51lH7a@O61lD7aPO51l000<0G`0507l0
G`1O05l0O`0305l0@@1o05l0G`1O07l0G`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`000[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o00008`?o17oo00<007ooOol03Woo000?Ool00`00Oomoo`04000>
O00200000g`8O0T00004O1800`00O1al7003O1`02@00H1mT7f0OI1mP7f@OH1l0000:?1l00`0061lD
7`0251l01APO51lD7a@O61l00a@O00<0001O05l03`1O00<0006O0Il05@6O00<000:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O000S
0ol4Ool00`00Oomoo`0>Ool000moo`03001oogoo00D000]l00800004O0Ul27`90002O1804G`CO180
07`KO1al6g`LO1]l7000I1mP7f@OH1mT7f0O00000S`O00Dh7c`O?1ll7cPO00<l7`0>000H7a@O61lD
7aPO51lH7a@O61lD7aPO51l000<0G`0507l0G`1O05l0O`0305l0@`1o05l0G`1O07l0G`000Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0002g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0002<3o`Ao
o`03001oogoo00ioo`003goo00<007ooOol01`001g`00P0000El27`9O0Ql2@0000El4P03001l77`L
00=l7009001T7f0OI1mP7f@OH1mT7`0000Tl7`03000H7a@O008D7`0561lD7a@O51lH7`0351l00`00
05l0G`0?05l00`000Il1W`0F0Il00`000]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01`;O0[l2_`:o0]l2_`0002@3o`Aoo`03001oogoo00ioo`003goo
0P0000=oo`000000300000Al2G`8O0Ul2080009l4P08O1=l4P00001l77`KO1al6`80000:I1mP7f@O
H1mT7f0OI1l003`O>1l3?1l04cPO?1ll7c`O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`000080
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O03d0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`000[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l0000T0ol3Ool2000@Ool000moo`03001o
ogoo018000=l4P<000El700:001P7f@OH1mT7f0OI1mP7f@O0009?1l00`0061lD7`0251l01APO51lD
7a@O61l00a@O00<H7`0005l0401O00<0006O0Il05P6O00D000:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`:o000U0ol4Ool00`00Oomo
o`0>Ool000moo`03001oogoo00X0009l4P06O1=l4W`BO19l4g`B0`0000Il6g`LO1]l77`KO1`20000
2f0OI1mP7f@OH1mT7f0OI1l003`O>1l00c`O01<h7c`O?1ll7cPO000D7aPO51lH7a@O61lD7aPO51lH
7a@O61l0000205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o0080G`0m0001W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O00009P?o17oo00<007oo
Ool03Woo000?Ool01000Oomoog`04@001g`L0P0000QT7f0OI1mP7f@OH1mT7f0O0P002C`O0P000a@O
00DH7a@O51lD7aPO00<D7`800140G`030001W`6O01H1W`050002_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`009`?o17oo00<007oo
Ool03Woo000?Ool01000Oomoog`01P0000@D7`00001T7`800008O1]l77`KO1al6g`LO1]l70@00008
H1mT7f0OI1mP7f@OH1mT7`80008l7`05>1ll7c`O?1lh7`02?1l200003APO51lH7a@O61lD7aPO51lH
7a@O61lD7`0000<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O03`0005o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O000X0ol4Ool00`00Oomo
o`0>Ool000moo`04001oogooO00800000c`O0000000900002V@OH1mT7f0OI1mP7f@OH1mT7f0O0P00
2S`O0P0000DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7`004P1O00<0006O0Il05P6O00@000:o0[l2
g`<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l0000X0ol4Ool00`00Oomoo`0>Ool000moo`800003Ooml000000T00003>1ll7`0000<00008H1mT
7f0OI1mP7f@OH1mT7`H00005>1ll7c`O?1lh7`03?1l04CPO0000000051lH7a@O61lD7aPO51lH7a@O
61lD7aPO51l00P000P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0205l20000?05o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l002T3o`=oo`80
011oo`003goo00@007ooOoml00`000@l7`P000dl7`8000<D7`0561lD7a@O51lH7`0351l00aPO51lD
7`02000A05l2000H0Il200020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<000?o0ol0:0?o17oo00<007ooOol03Woo000?Ool01000
Oomoog`0200000<1O`0000001@0000Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l00cPO?1l0
000200003QPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l200001@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`1107l0G`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l0000[0ol4Ool00`00Oomoo`0>Ool000moo`04001oogooO0090000
0`6O0000G`02000251l40007?1l7000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00800180
G`8001P1W`8000<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`020[l2000/0ol4Ool00`00Oomoo`0>Ool000moo`06001oogooO00007dP1P00
00@3o`000Gl00080G`80000451lH7a@O61l700004aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO00<00080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O0P0003h1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`00;P?o
17oo00<007ooOol03Woo000?Ool01P00Oomoog`0001m00T000030Il000000080G`<000<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7`@001<0G`8001T1W`8000050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O
0[l2_`00;`?o17oo00<007ooOol03Woo000?Ool2000017ooO00007dP1`0000D3o`000000006O0080
000305l0O`1O00@0000?61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO00@000<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O01d0O`1O0000006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0080000U0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0000<0?o0goo0P0047oo000?
Ool01P00Oomoog`0001m00P000030ol000;O008000040Il00000000405l?000F05l3000I0Il20002
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00@2g`:o00000343o`Aoo`03001oogoo00ioo`003goo00<007ooOol00W`000<007d00000
1`0000@3o`000002_`8000040Il1O`00000205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0O`0000000P000401O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`8003<3
o`05001oogooOol0000@Ool000moo`03001oogoo009l0003001m800000H000050oH000?o0ol00002
0[l200020Il2000O05l2000M0Il200030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`000ol0<`?o00<007ooOol00Woo00<007oo
Ool03Woo0008Ool50002Ool00`00Oomoo`02O0000`00O@00000700001`?f0003o`000]l2_`;O0080
00030Gl1W`5o00L000<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0200001`1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`<0000T0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0P00=@?o00<007ooOol00Woo00<007ooOol03Woo000:Ool00`00Oomoo`02Ool00`00Oomoo`02
O0001P00OB0007i0001Wh0D000030oH00000008000<2_`8000P1Wa000201W`@00082_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O
0[l2_`02000e0ol200000`?fOomoo`02Ool00`00Oomoo`0>Ool000Yoo`03001oogoo009oo`800006
Ooml07`0O00007dP1P0000L3hP00000000?e0003o`0200000`;O0[l2g`020000<`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0300009`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`02000e
0ol200000`?e0oH3m@03Ool2000@Ool000Yoo`03001oogoo009oo`03001oogoo00=l0004001m0000
OT0200002CoP000000?R0003k0000oD000020ol200000`:o0]l2_`04000[0Il400030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2
g`:o0[l2_`<003D3o`800083m@030oH3m@?e00Aoo`03001oogoo00ioo`002Woo00<007ooOol00Woo
00<007ooOol00g`000@007dP001nH0@000075n0000?R0003j`000oD00P000P?o0P0000D2g`:o0]l2
_`;O0080000U0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0100002T2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O008003H3o`80
00070oD3mP?e0oH3m@?f0oD017oo00<007ooOol03Woo0009Ool20004Ool00`00Oomoo`04O0000`00
OB00000300000coP000Gh00200020n`00`000oD3m@0200020ol300020[l00`;O0[l00007000F0Il7
00000`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O0[l2000f0ol200001@?f0oD3m@?e0oH00`?e00<3
mWooOol00Woo00<007ooOol03Woo000?Ool00`00Oomoo`04O0001@00O@000000Oh000`0000/Kh000
0n8000?/0n/000?e0oH3m@0000@3o`80000:0[l2g`:o0]l2_`;O0[l2g`:o0]lF0000;`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l00`00=P?o0P0000/3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
00Aoo`03001oogoo00ioo`003goo00<007ooOol017`000D007dP000007n000800006?n0001OP0003
hP000P?/00D000?e0oD3m@0000D3o`8000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]l2_`000080
03L3o`800083m@050oH3m@?e0oD3mP030oD00`?f0oD3m@04Ool00`00Oomoo`0>Ool000moo`800003
Ooml07`0009l0006001m0000OT0007mP0P0000Doh0006n0000?R008000050n/000000oH3m@020005
0ol40000@P:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`@003L3o`<0000?0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
00=oo`80011oo`003goo00<007ooOol01G`000@007d0001n@0800006In0003oP000Gh0000P?R00@0
00?/0n`00083m@030oH0000000L3o`@00082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l4000i0ol200000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00Aoo`03001oogoo00ioo`003goo00<007ooOol01G`000H007dP001nH000Oh020002
?n000`006n0000020n800`000n/3k00200000`?e0oH3m@0200090ol40000<@:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o00D003X3o`<0000D0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@Aoo`03001oogoo00ioo`003goo00<007ooOol01G`000/007d0001n@000
Oh0006?P000oh000008Gh0040003hP?R00030n`00`000oD3mP020oD2000;0ol300000`:o0]l2_`02
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00@2g`:o0[l2_`D003d3o`8000050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f0083m@Aoo`03001oogoo00ioo`003goo00<007ooOol01G`000D007dPO@0007i00080
0008In1Sh000?n0001OP6n000083hP0:0003j`?/0n/000?e0oH3m@?f0oD2000<0ol700006P:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l800100ol200006@?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e00Aoo`03001oogoo
00ioo`003goo00<007ooOol01G`000d007d0OB0007i0001oP000In0003oP000Kh0025n0010000n83
hP000`?/0P0000D3mP?e0oD3m@?f00800143oaX004D3o`<00083m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oIoogoo009oo`03001oogoo00ioo`003goo0P00
00=oog`0O0000g`0010007dPO@0007i0001oH7n0001Wh000?n0001_P5n0000<3hP050003j`?/0n/3
k00200001@?e0oH3m@?f0oD00`00J@?o100001h3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3Ool2000@Ool000moo`03001oogoo00El0007001m
07dPO@0007i000000Wn000@006OP000oh08000035n0000?R0083hP8000@3k0800083m@040oH3m@?e
0oD3001S0ol300030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00P?e17oo00<007ooOol03Woo000?Ool00`00Oomoo`06O0004@00O@1m8000
OV0007n0Of0006?P000kh3oP000Kh1OP00000`?R0103h`000n`3j`?/0n/3k0000oH3m@?f0oD3mP?e
0oH3m@@005/3o`@0000U0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD017oo00<007ooOol03Woo000?Ool00`00Oomoo`06
O0001`00OB1m07dP001n@000009oP003001Sh000008oh004000Kh1OP00040n800`000n`3k0030n`2
00000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`00E@?o0`0000D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD00`?f
Oomoo`02Ool00`00Oomoo`0>Ool000moo`03001oogoo00Il000C001m07dPO@0007i0001oH7n0001W
h000?n0kh0005n0Kh1OP00000`?R00P3h`000n`3j`?/0n/3k0?[0P0000/3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f00@004T3o`P0000/0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@Aoo`03001oogoo00io
o`003goo00<007ooOol01W`000D007dPO@1m8000009n@005001oP7n0001Wh00200001CoP000Gh1_P
5n000P000`?R0P001P?/0P000`?e00D3mP?e0oD3m@?f00<3m@030oH3m@0000H003l3o`<000030oD3
mP?e0083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f0083m@Aoo`03001oogoo00ioo`00
3goo0P0000=oog`0O0001G`001@007dPO@1m8000OT0007n0Of0006?PIn1Sh000>n0001OP6n0Gh1_P
0P0000<3hP?S0n800P0000H3k0?[0n`3j`?/0n/200004P?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@@003@3o`L0000g0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD00goo0P0047oo000?Ool00`00Oomoo`07O0001@00O@1m87d000000Wi000L007n0
Oh0006?PIn000002?n0200001A_P5n0Gh1OP000010?R0P001P?/1@000P?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP020oD<000L0ol<00000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mWooOol00Woo00<007ooOol03Woo000?Ool0
0`00Oomoo`08O0005P00O@1m8000OV1n@000Of1oP7mP001Sh6OP000oh3_P?n0001_P5n0Kh0000P?R
00@3h`?R0n83hP8000090n`3j`?/0n/3k0?[0n`3j`?/0080000K0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e01`0001:0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@Aoo`03001oogoo00ioo`003goo00<007ooOol027`000@007dPO@0000=n@007001oP7n0
001Wh6?P000013oP00D001_P5n0Gh00000L3hP030003k0?/00P3k08000050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP020oD4
Ool00`00Oomoo`0>Ool000moo`03001oogoo00Ql000?001m07dPO@0007i0OV0007n0Of1oP000In1S
h000008oh006>n0oh0006n0Gh1_P0P0000<3hP?S0n800P?R00d3h`000n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0020000O@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD017oo00<007ooOol03Woo000?Ool00`00Oomoo`08O0001@00OB1m
07dP00000gi000P007n0Oh0006?PIn1Sh00013oP00<001_P5n000QOP00<000?R0n8010?R0`002P?/
100000D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00<3mWooOol00Woo00<007ooOol03Woo000?Ool200000gooO01l0007O0001@00OB1m07dP0000
0Wi000UnH000Oh1oH000Hn1Wh6?P00000SoP00Lkh3oP000Kh1OP6n0Gh00200001@?S0n83hP?R0n<0
0P?R0P0000`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`30000MP?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0goo0P0047oo000?Ool00`00Oomoo`09O000
1@00O@1m87d000000gi000T007n0Oh1oP000Hn1Wh6?P00000coP00<001OP6n000aOP00<Kh0000000
1`?R0P003@?/10000`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP020oD4
Ool00`00Oomoo`0>Ool000moo`03001oogoo00Yl0005001m07dPO@000003OT002@00Of1oP000In1S
h6OPHn000002?n002S_P000Gh1_P5n0Kh1OP6n0Gh0000`?R00D3h`?R0n83hP?S0080000?0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00@0001^0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@Aoo`03001oogoo00ioo`003goo00<007ooOol02W`000D007dPO@1m800000=n@009
001oP7n0Oh0006OPHn1Wh00000@oh003000Gh1_P00<Gh0036n0000?R00T3hP030003k0?/0103k0<0
0083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD00`?fOomoo`02Ool00`00Oomoo`0>Ool000Qo
o`@000=oo`03001oogoo00Yl0007001m07dPO@1m8000OV000Wi000T007n0Of1oP000In1Sh6OP0000
0coP00Pkh000000Kh1OP6n0Gh1_P0P000`?R00H3h`?R0n83hP?S0n8300004P?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0P0001O0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@050003Ool00`00Oomoo`0>Ool000Qo
o`03001oogoo00Aoo`03001oogoo00]l0005001m07dPO@000004OT002@00Oh1oP000Hn1Wh6?PIn00
0005?n0200035n0011_P5n0000002P?R0`005`?/1`0000<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00<3mP?e0oD0200010?/17oo00<007ooOol03Woo0009Ool00`00Oomoo`03Ool20000
0gooO01l0009O0001@00OB1m07dP00000Wi000]nH7i0001oH7n0Of0006?PIn1Sh6OP0080008oh00:
>n0oh3oP000Gh1_P5n0Kh1OP6n0200000`?R0n<3hP020n801P?S0n83hP?R0n<3hP80000L0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/70000@P?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mPL0000<0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0goo0P0047oo000:Ool00`00Oomoo`02
Ool00`00Oomoo`0;O0001P00O@1m87d0OB0000An@00;001oP7n0Oh0006?PIn1Sh6OPHn000005?n00
1@005n0Gh1OP6n000aOP0P002`?R0P008@?/1`0000<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD00`?f0oD3m@0;000C0n`4Ool00`00Oomoo`0>Ool000Qoo`04001oogoo0003Ool00`00Oomoo`0;
O0001P00OB1m07dPO@0000=n@00=OV0007n0Of1oP7mP001Sh6OPHn1Wh6?P00000SoP00`kh3oP?n00
01OP6n0Gh1_P5n0Kh1OP6n0200030n801@?S0n83hP?R0n<00`?R0`0002D3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`0`
00007P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`Aoo`03001oogoo00ioo`002Goo0P0017oo00<007ooOol02g`000L007d0OB1m07dPO@000004
OT000`00Oh1oP002Oh001P00Hn1Wh6?PIn0000Hoh005000Gh1OP5n0Kh0035n000a_P5n00000=0n82
001a0n`4Ool00`00Oomoo`0>Ool000moo`03001oogoo00]l0008001m87d0OB1m07dP001nH0=n@00<
001oH7n0Of1oP000In1Sh6OPHn1Wh0000coP00dkh3oP?n0001OP6n0Gh1_P5n0Kh1OP6n0Gh0020002
0n801@?S0n83hP?R0n<00`?R00<3h`?R0n800`0006h3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[17oo00<007ooOol03Woo000?Ool00`00Oomoo`0;O0002000O@1m87d0OB1m07dP
0004OT000`00Oh1oP002Oh001`00In1Sh6OPHn1Wh00000Hoh005000Gh1OP5n0Kh0035n000a_P5n0G
h002000>0n83001[0n`4Ool00`00Oomoo`0>Ool000moo`800003Ooml07`000Yl0009001m07dPO@1m
87d0001n@7iP009n@00<001oP7mPOh1oH000Hn1Wh6?PIn1Sh6OP0P000SoP00<kh3oP?n000P0000XK
h1OP6n0Gh1_P5n0Kh1OP6n0Gh08000050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00P?R100006L3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`03Ool2000@Ool000moo`03001oogoo00al0008001m87d0
OB1m07dPO@0000An@003001oP7n0009oP009001Sh6OPHn1Wh6?PIn1Sh00000Hoh004000Gh1OP6n03
5n001Q_P5n0Gh1OP6n000183hP<006@3k0Aoo`03001oogoo00ioo`003goo00<007ooOol037`000P0
07d0OB1m07dPO@1m80000Wi0011nH7i0001oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn0000<oh004>n0o
h3oP?n0200002QOP6n0Gh1_P5n0Kh1OP6n0Gh1_P0P000`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n840000H0?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`Aoo`03001oogoo00ioo`003goo00<007ooOol03G`000L0
07d0OB1m07dPO@000005OT000`00Oh1oP003Oh002000Hn1Wh6?PIn1Sh6OP0008?n0200001A_P5n0G
h1OP6n000aOP00@Kh1OP000001D3hP@005`3k0Aoo`03001oogoo00ioo`003goo00<007ooOol03G`0
00P007dPO@1m87d0OB1m00000gi0011nH7i0001oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn0000<oh006
>n0oh3oP?n0kh3oP0P0000XGh1_P5n0Kh1OP6n0Gh1_P5n0Kh0<000050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00H3h`?R0n83hP?S0n840000F0?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[17oo00<007ooOol03Woo000?Ool00`00Oomoo`0>O000
1`00OB1m07dPO@1m800000In@003001oP7n000=oP007001Sh6OPHn1Wh6?PIn000P002CoP00D001OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh002000H0n84001D0n`4Ool00`00Oomoo`0>Ool000moo`800003
Ooml07`000al0009001m07dPO@1m87d0OB0007iP00=n@00AOV1n@000Of1oP7mPOh1oH000Hn1Wh6?P
In1Sh6OPHn000002?n001C_P?n0oh3oP>n000SoP00h001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
0P000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R1P0004h3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3Ool2000@Ool000moo`03001oogoo00ml
0007001m07dPO@1m87d000001Wi000<007n0Oh0017n000T006?PIn1Sh6OPHn1Wh6?P00002CoP0P00
0QOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP008001h3hP@004X3k0Aoo`03001oogoo00ioo`003goo
00<007ooOol03g`000X007dPO@1m87d0OB1m0000OT1nH0=n@00AOV0007n0Of1oP7mPOh1oH000Hn1W
h6?PIn1Sh6OPHn000002?n001C_P?n0oh3oP>n000coP00l001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n000P0000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hPL000130n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/017oo00<007ooOol03Woo000?Ool00`00Oomo
o`0?O0002000O@1m87d0OB1m07dP0006OT000`00Oh1oP005Oh002@00Hn1Wh6?PIn1Sh6OPHn00000:
?n0010005n0Gh1_P0aOP00DKh1OP5n0Gh1_P00<Gh0046n000000000T0n84000o0n`4Ool00`00Oomo
o`0>Ool000moo`03001oogoo00ml0009001m87d0OB1m07dPO@1m8000009n@00DOV1n@7i0OT0007mP
Oh1oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn1Sh0800003?n0kh3oP008oh004>n0oh3oP?n02000041OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P10000`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP030n<0000000D0000h0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`Aoo`03001oogoo00io
o`003goo0P0000=oog`0O0003W`000P007dPO@1m87d0OB1m00001gi000<007n0Oh001Gn000X006?P
In1Sh6OPHn1Wh6?PIn0000Xoh08000056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh1OP
00000P00:0?R2`00;@?/0goo0P0047oo000?Ool00`00Oomoo`0@O0002@00O@1m87d0OB1m07dPO@00
0003OT005GiPOT1n@7i0001oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OPHn1Wh00200001C_P?n0o
h3oP>n000coP00<kh3oP00000P00018Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n02
00001@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0000000900008P?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
17oo00<007ooOol03Woo000?Ool00`00Oomoo`0@O0002P00OB1m07dPO@1m87d0OB1m00001gi000<0
07n0Oh0017n000`006OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000<?n0200000aOP6n0Gh0025n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P008003X3hPl001<3k0Aoo`03001oogoo00ioo`003goo00<007oo
Ool04G`000X007dPO@1m87d0OB1m07dP001nH0=n@00HOV1n@7i0001oP7mPOh1oH7n0Of1oP000In1S
h6OPHn1Wh6?PIn1Sh6OP000oh3_P0coP00Dkh3oP?n0oh3_P00<oh00E>n0001OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP00@000050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S01@000=oo`03001o
ogoo00ioo`003goo00<007ooOol04G`000X007d0OB1m07dPO@1m87d0OB0000Mn@003001oP7n000Eo
P0800008Hn1Wh6?PIn1Sh6OPHn1Wh08000doh08000056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P008005H3hPAoo`03001oogoo00ioo`003goo00<007ooOol04G`000`007dP
O@1m87d0OB1m07dPO@0007i0OV03OT005WiPOT1n@000Oh1oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1S
h6OPHn1Wh6?P0P000coP00Dkh3oP?n0oh3_P00<oh00I>n0oh0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n000P000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP030n<3hWoo00=oo`03001oogoo00ioo`003goo0P0000=oog`0O0003g`000/007d0
OB1m07dPO@1m87d0OB1m000000Qn@003001oP7n000IoP00<001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh000
3CoP0P000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000a_P5n0Gh003001A0n83Ool2
000@Ool000moo`03001oogoo019l000:001m07dPO@1m87d0OB1m07dP0002OT0077iPOT1n@7i0OV1n
@000Of1oP7mPOh1oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0000coP00Dkh3oP?n0oh3_P
00<oh003>n0oh3oP0080000G6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh00300020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n8010?S0n83hP?R17oo00<007ooOol03Woo
000?Ool00`00Oomoo`0BO0002`00OB1m07dPO@1m87d0OB1m07dP000027i000<007n0Oh001Wn000d0
06OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00000??n0200000aOP6n0Gh0025n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP00@004X3hPAoo`03001oogoo00ioo`003goo00<007ooOol0
4W`00P0000Um87d0OB1m07dPO@1m87d000000gi000mnH7i0OT1n@7iP001oP7mPOh1oH7n0Of1oP7mP
Oh000P0000]Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh00000<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP
>n000P0001XKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
100000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801P?S0n83hP?R0n<3hPAoo`03001oogoo00ioo`002Goo0P0017oo00<007ooOol0
4g`000/007d0OB1m07dPO@1m87d0OB1m000000Qn@003001oP7n000QoP00;001Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh002000@?n0200035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n0011_P00000000@`?R17oo00<007ooOol03Woo0008Ool01000Oomoo`000goo00<007oo
Ool057`000/007d0OB1m07dPO@1m87d0OB1m000000=n@00LOV1n@7i0OT1nH000Oh1oH7n0Of1oP7mP
Oh1oH7n0Of0006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0200000coP>n0oh002?n001C_P?n0oh3oP>n00
0coP00<kh3oP?n000P0001dKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P00@000<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`030n8010?S0n83hP?R17oo00<007ooOol03Woo000:Ool00`00Oomoo`02Ool20000
0gooO01l000BO0003000OB1m07dPO@1m87d0OB1m07dPO@0000Qn@08000UoP00=001Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn000P0043oP0`0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P
5n0Gh1OP6n000aOP00HKh1OP5n0Gh1_P5n05000j0n83Ool2000@Ool000]oo`05001oogooOol0002h
Ool00`00Oomoo`0>Ool000Qoo`04001oogoo0003Ool00`00Oomoo`2fOol00`00Oomoo`0>Ool000Uo
o`8000Aoo`04001oogoo0005Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool01@00Oomoogoo000047oo000?Oonj000@Ool00=Uoo`00fGoo003IOol00=Uoo`00fGoo
003IOol00=Uoo`003Goo0P00bWoo000>Ool00`00Oomoo`38Ool000moo`03001oogoo0<Moo`003Woo
00<007oo0000b7oo000=Ool01000Oomoo`00b7oo000<Ool300000goo00000037Ool00=Uoo`00fGoo
003IOol00=Uoo`00fGoo003IOol00001\
\>"],
  ImageRangeCache->{{{0, 216}, {216, 0}} -> {-0.307129, -3.50151, 0.0168033, \
0.0337192}}]
}, Open  ]],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  "-component of the velocity looks like"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[v, {x,  .01, 3}, {y, \(-3\), 3}, PlotPoints \[Rule] 50, 
      Contours \[Rule] 20, ColorFunction \[Rule] Hue, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0160149 0.321585 0.5 0.160256 [
[.01601 -0.0125 -3 -9 ]
[.01601 -0.0125 3 0 ]
[.17681 -0.0125 -9 -9 ]
[.17681 -0.0125 9 0 ]
[.3376 -0.0125 -3 -9 ]
[.3376 -0.0125 3 0 ]
[.49839 -0.0125 -9 -9 ]
[.49839 -0.0125 9 0 ]
[.65918 -0.0125 -3 -9 ]
[.65918 -0.0125 3 0 ]
[.81998 -0.0125 -9 -9 ]
[.81998 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .17949 -12 -4.5 ]
[-0.0125 .17949 0 4.5 ]
[-0.0125 .33974 -12 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .66026 -6 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .82051 -6 -4.5 ]
[-0.0125 .82051 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01601 0 m
.01601 .00625 L
s
[(0)] .01601 -0.0125 0 1 Mshowa
.17681 0 m
.17681 .00625 L
s
[(0.5)] .17681 -0.0125 0 1 Mshowa
.3376 0 m
.3376 .00625 L
s
[(1)] .3376 -0.0125 0 1 Mshowa
.49839 0 m
.49839 .00625 L
s
[(1.5)] .49839 -0.0125 0 1 Mshowa
.65918 0 m
.65918 .00625 L
s
[(2)] .65918 -0.0125 0 1 Mshowa
.81998 0 m
.81998 .00625 L
s
[(2.5)] .81998 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(3)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.04817 0 m
.04817 .00375 L
s
.08033 0 m
.08033 .00375 L
s
.11249 0 m
.11249 .00375 L
s
.14465 0 m
.14465 .00375 L
s
.20897 0 m
.20897 .00375 L
s
.24112 0 m
.24112 .00375 L
s
.27328 0 m
.27328 .00375 L
s
.30544 0 m
.30544 .00375 L
s
.36976 0 m
.36976 .00375 L
s
.40192 0 m
.40192 .00375 L
s
.43408 0 m
.43408 .00375 L
s
.46623 0 m
.46623 .00375 L
s
.53055 0 m
.53055 .00375 L
s
.56271 0 m
.56271 .00375 L
s
.59487 0 m
.59487 .00375 L
s
.62703 0 m
.62703 .00375 L
s
.69134 0 m
.69134 .00375 L
s
.7235 0 m
.7235 .00375 L
s
.75566 0 m
.75566 .00375 L
s
.78782 0 m
.78782 .00375 L
s
.85214 0 m
.85214 .00375 L
s
.88429 0 m
.88429 .00375 L
s
.91645 0 m
.91645 .00375 L
s
.94861 0 m
.94861 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-3)] -0.0125 .01923 1 0 Mshowa
0 .17949 m
.00625 .17949 L
s
[(-2)] -0.0125 .17949 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(-1)] -0.0125 .33974 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(1)] -0.0125 .66026 1 0 Mshowa
0 .82051 m
.00625 .82051 L
s
[(2)] -0.0125 .82051 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(3)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05128 m
.00375 .05128 L
s
0 .08333 m
.00375 .08333 L
s
0 .11538 m
.00375 .11538 L
s
0 .14744 m
.00375 .14744 L
s
0 .21154 m
.00375 .21154 L
s
0 .24359 m
.00375 .24359 L
s
0 .27564 m
.00375 .27564 L
s
0 .30769 m
.00375 .30769 L
s
0 .37179 m
.00375 .37179 L
s
0 .40385 m
.00375 .40385 L
s
0 .4359 m
.00375 .4359 L
s
0 .46795 m
.00375 .46795 L
s
0 .53205 m
.00375 .53205 L
s
0 .5641 m
.00375 .5641 L
s
0 .59615 m
.00375 .59615 L
s
0 .62821 m
.00375 .62821 L
s
0 .69231 m
.00375 .69231 L
s
0 .72436 m
.00375 .72436 L
s
0 .75641 m
.00375 .75641 L
s
0 .78846 m
.00375 .78846 L
s
0 .85256 m
.00375 .85256 L
s
0 .88462 m
.00375 .88462 L
s
0 .91667 m
.00375 .91667 L
s
0 .94872 m
.00375 .94872 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01601 .99375 m
.01601 1 L
s
.17681 .99375 m
.17681 1 L
s
.3376 .99375 m
.3376 1 L
s
.49839 .99375 m
.49839 1 L
s
.65918 .99375 m
.65918 1 L
s
.81998 .99375 m
.81998 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.04817 .99625 m
.04817 1 L
s
.08033 .99625 m
.08033 1 L
s
.11249 .99625 m
.11249 1 L
s
.14465 .99625 m
.14465 1 L
s
.20897 .99625 m
.20897 1 L
s
.24112 .99625 m
.24112 1 L
s
.27328 .99625 m
.27328 1 L
s
.30544 .99625 m
.30544 1 L
s
.36976 .99625 m
.36976 1 L
s
.40192 .99625 m
.40192 1 L
s
.43408 .99625 m
.43408 1 L
s
.46623 .99625 m
.46623 1 L
s
.53055 .99625 m
.53055 1 L
s
.56271 .99625 m
.56271 1 L
s
.59487 .99625 m
.59487 1 L
s
.62703 .99625 m
.62703 1 L
s
.69134 .99625 m
.69134 1 L
s
.7235 .99625 m
.7235 1 L
s
.75566 .99625 m
.75566 1 L
s
.78782 .99625 m
.78782 1 L
s
.85214 .99625 m
.85214 1 L
s
.88429 .99625 m
.88429 1 L
s
.91645 .99625 m
.91645 1 L
s
.94861 .99625 m
.94861 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .17949 m
1 .17949 L
s
.99375 .33974 m
1 .33974 L
s
.99375 .5 m
1 .5 L
s
.99375 .66026 m
1 .66026 L
s
.99375 .82051 m
1 .82051 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05128 m
1 .05128 L
s
.99625 .08333 m
1 .08333 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .14744 m
1 .14744 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .24359 m
1 .24359 L
s
.99625 .27564 m
1 .27564 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .37179 m
1 .37179 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .4359 m
1 .4359 L
s
.99625 .46795 m
1 .46795 L
s
.99625 .53205 m
1 .53205 L
s
.99625 .5641 m
1 .5641 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .62821 m
1 .62821 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .72436 m
1 .72436 L
s
.99625 .75641 m
1 .75641 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .85256 m
1 .85256 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .91667 m
1 .91667 L
s
.99625 .94872 m
1 .94872 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .4 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .7 r
.01923 .49985 m
.03885 .49857 L
.05848 .49657 L
.0781 .49427 L
.09772 .49171 L
.1085 .49019 L
.11735 .48895 L
.13697 .486 L
.15659 .48285 L
.17622 .47954 L
.19584 .47607 L
.21546 .47246 L
.22548 .47057 L
.23509 .46873 L
.25471 .46486 L
.27433 .46087 L
.29396 .45675 L
.31358 .4525 L
.32066 .45094 L
.3332 .44815 L
.35283 .44369 L
.37245 .4391 L
.39207 .4344 L
.40469 .43132 L
.4117 .42959 L
.43132 .42468 L
.45094 .41965 L
.47057 .4145 L
.4811 .4117 L
.49019 .40925 L
.50981 .40389 L
.52943 .39842 L
.54906 .39282 L
.55166 .39207 L
.56868 .38712 L
.5883 .3813 L
.60793 .37536 L
.6174 .37245 L
.62755 .3693 L
.64717 .36313 L
.6668 .35682 L
.679 .35283 L
.68642 .35038 L
.70604 .34382 L
.72567 .33712 L
.73693 .3332 L
.74529 .33028 L
.76491 .3233 L
.78454 .31616 L
.79152 .31358 L
.80416 .30887 L
.82378 .30143 L
.84302 .29396 L
.84341 .2938 L
.86303 .28602 L
.88265 .27804 L
.89159 .27433 L
.90228 .26987 L
.9219 .26149 L
.93738 .25471 L
.94152 .25288 L
.96115 .24405 L
.98048 .23509 L
.98077 .23495 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49985 m
.03885 .49857 L
.05848 .49657 L
.0781 .49427 L
.09772 .49171 L
.1085 .49019 L
.11735 .48895 L
.13697 .486 L
.15659 .48285 L
.17622 .47954 L
.19584 .47607 L
.21546 .47246 L
.22548 .47057 L
.23509 .46873 L
.25471 .46486 L
.27433 .46087 L
.29396 .45675 L
.31358 .4525 L
.32066 .45094 L
.3332 .44815 L
.35283 .44369 L
.37245 .4391 L
.39207 .4344 L
.40469 .43132 L
.4117 .42959 L
.43132 .42468 L
.45094 .41965 L
.47057 .4145 L
.4811 .4117 L
.49019 .40925 L
.50981 .40389 L
.52943 .39842 L
.54906 .39282 L
.55166 .39207 L
.56868 .38712 L
.5883 .3813 L
.60793 .37536 L
.6174 .37245 L
.62755 .3693 L
.64717 .36313 L
.6668 .35682 L
.679 .35283 L
.68642 .35038 L
.70604 .34382 L
.72567 .33712 L
.73693 .3332 L
.74529 .33028 L
.76491 .3233 L
.78454 .31616 L
.79152 .31358 L
Mistroke
.80416 .30887 L
.82378 .30143 L
.84302 .29396 L
.84341 .2938 L
.86303 .28602 L
.88265 .27804 L
.89159 .27433 L
.90228 .26987 L
.9219 .26149 L
.93738 .25471 L
.94152 .25288 L
.96115 .24405 L
.98048 .23509 L
.98077 .23495 L
Mfstroke
0 1 1 r
.01923 .49995 m
.03885 .49952 L
.05848 .49886 L
.0781 .4981 L
.09772 .49725 L
.11735 .49633 L
.13697 .49536 L
.15659 .49433 L
.17622 .49324 L
.19584 .49212 L
.21546 .49095 L
.22782 .49019 L
.23509 .48974 L
.25471 .48849 L
.27433 .48721 L
.29396 .4859 L
.31358 .48455 L
.3332 .48317 L
.35283 .48176 L
.37245 .48033 L
.39207 .47886 L
.4117 .47737 L
.43132 .47586 L
.45094 .47432 L
.47057 .47275 L
.49019 .47117 L
.49753 .47057 L
.50981 .46955 L
.52943 .46792 L
.54906 .46627 L
.56868 .46459 L
.5883 .46289 L
.60793 .46117 L
.62755 .45943 L
.64717 .45767 L
.6668 .45589 L
.68642 .4541 L
.70604 .45228 L
.72037 .45094 L
.72567 .45045 L
.74529 .44859 L
.76491 .44672 L
.78454 .44483 L
.80416 .44293 L
.82378 .441 L
.84341 .43906 L
.86303 .4371 L
.88265 .43513 L
.90228 .43314 L
.92004 .43132 L
.9219 .43113 L
.94152 .4291 L
.96115 .42707 L
.98077 .42501 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49995 m
.03885 .49952 L
.05848 .49886 L
.0781 .4981 L
.09772 .49725 L
.11735 .49633 L
.13697 .49536 L
.15659 .49433 L
.17622 .49324 L
.19584 .49212 L
.21546 .49095 L
.22782 .49019 L
.23509 .48974 L
.25471 .48849 L
.27433 .48721 L
.29396 .4859 L
.31358 .48455 L
.3332 .48317 L
.35283 .48176 L
.37245 .48033 L
.39207 .47886 L
.4117 .47737 L
.43132 .47586 L
.45094 .47432 L
.47057 .47275 L
.49019 .47117 L
.49753 .47057 L
.50981 .46955 L
.52943 .46792 L
.54906 .46627 L
.56868 .46459 L
.5883 .46289 L
.60793 .46117 L
.62755 .45943 L
.64717 .45767 L
.6668 .45589 L
.68642 .4541 L
.70604 .45228 L
.72037 .45094 L
.72567 .45045 L
.74529 .44859 L
.76491 .44672 L
.78454 .44483 L
.80416 .44293 L
.82378 .441 L
.84341 .43906 L
.86303 .4371 L
.88265 .43513 L
.90228 .43314 L
.92004 .43132 L
Mistroke
.9219 .43113 L
.94152 .4291 L
.96115 .42707 L
.98077 .42501 L
Mfstroke
0 .7 1 r
.01923 .50005 m
.03885 .50048 L
.05848 .50114 L
.0781 .5019 L
.09772 .50275 L
.11735 .50367 L
.13697 .50464 L
.15659 .50567 L
.17622 .50676 L
.19584 .50788 L
.21546 .50905 L
.22782 .50981 L
.23509 .51026 L
.25471 .51151 L
.27433 .51279 L
.29396 .5141 L
.31358 .51545 L
.3332 .51683 L
.35283 .51824 L
.37245 .51967 L
.39207 .52114 L
.4117 .52263 L
.43132 .52414 L
.45094 .52568 L
.47057 .52725 L
.49019 .52883 L
.49753 .52943 L
.50981 .53045 L
.52943 .53208 L
.54906 .53373 L
.56868 .53541 L
.5883 .53711 L
.60793 .53883 L
.62755 .54057 L
.64717 .54233 L
.6668 .54411 L
.68642 .5459 L
.70604 .54772 L
.72037 .54906 L
.72567 .54955 L
.74529 .55141 L
.76491 .55328 L
.78454 .55517 L
.80416 .55707 L
.82378 .559 L
.84341 .56094 L
.86303 .5629 L
.88265 .56487 L
.90228 .56686 L
.92004 .56868 L
.9219 .56887 L
.94152 .5709 L
.96115 .57293 L
.98077 .57499 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .50005 m
.03885 .50048 L
.05848 .50114 L
.0781 .5019 L
.09772 .50275 L
.11735 .50367 L
.13697 .50464 L
.15659 .50567 L
.17622 .50676 L
.19584 .50788 L
.21546 .50905 L
.22782 .50981 L
.23509 .51026 L
.25471 .51151 L
.27433 .51279 L
.29396 .5141 L
.31358 .51545 L
.3332 .51683 L
.35283 .51824 L
.37245 .51967 L
.39207 .52114 L
.4117 .52263 L
.43132 .52414 L
.45094 .52568 L
.47057 .52725 L
.49019 .52883 L
.49753 .52943 L
.50981 .53045 L
.52943 .53208 L
.54906 .53373 L
.56868 .53541 L
.5883 .53711 L
.60793 .53883 L
.62755 .54057 L
.64717 .54233 L
.6668 .54411 L
.68642 .5459 L
.70604 .54772 L
.72037 .54906 L
.72567 .54955 L
.74529 .55141 L
.76491 .55328 L
.78454 .55517 L
.80416 .55707 L
.82378 .559 L
.84341 .56094 L
.86303 .5629 L
.88265 .56487 L
.90228 .56686 L
.92004 .56868 L
Mistroke
.9219 .56887 L
.94152 .5709 L
.96115 .57293 L
.98077 .57499 L
Mfstroke
0 .4 1 r
.01923 .50015 m
.03885 .50143 L
.05848 .50343 L
.0781 .50573 L
.09772 .50829 L
.1085 .50981 L
.11735 .51105 L
.13697 .514 L
.15659 .51715 L
.17622 .52046 L
.19584 .52393 L
.21546 .52754 L
.22548 .52943 L
.23509 .53127 L
.25471 .53514 L
.27433 .53913 L
.29396 .54325 L
.31358 .5475 L
.32066 .54906 L
.3332 .55185 L
.35283 .55631 L
.37245 .5609 L
.39207 .5656 L
.40469 .56868 L
.4117 .57041 L
.43132 .57532 L
.45094 .58035 L
.47057 .5855 L
.4811 .5883 L
.49019 .59075 L
.50981 .59611 L
.52943 .60158 L
.54906 .60718 L
.55166 .60793 L
.56868 .61288 L
.5883 .6187 L
.60793 .62464 L
.6174 .62755 L
.62755 .6307 L
.64717 .63687 L
.6668 .64318 L
.679 .64717 L
.68642 .64962 L
.70604 .65618 L
.72567 .66288 L
.73693 .6668 L
.74529 .66972 L
.76491 .6767 L
.78454 .68384 L
.79152 .68642 L
.80416 .69113 L
.82378 .69857 L
.84302 .70604 L
.84341 .7062 L
.86303 .71398 L
.88265 .72196 L
.89159 .72567 L
.90228 .73013 L
.9219 .73851 L
.93738 .74529 L
.94152 .74712 L
.96115 .75595 L
.98048 .76491 L
.98077 .76505 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .50015 m
.03885 .50143 L
.05848 .50343 L
.0781 .50573 L
.09772 .50829 L
.1085 .50981 L
.11735 .51105 L
.13697 .514 L
.15659 .51715 L
.17622 .52046 L
.19584 .52393 L
.21546 .52754 L
.22548 .52943 L
.23509 .53127 L
.25471 .53514 L
.27433 .53913 L
.29396 .54325 L
.31358 .5475 L
.32066 .54906 L
.3332 .55185 L
.35283 .55631 L
.37245 .5609 L
.39207 .5656 L
.40469 .56868 L
.4117 .57041 L
.43132 .57532 L
.45094 .58035 L
.47057 .5855 L
.4811 .5883 L
.49019 .59075 L
.50981 .59611 L
.52943 .60158 L
.54906 .60718 L
.55166 .60793 L
.56868 .61288 L
.5883 .6187 L
.60793 .62464 L
.6174 .62755 L
.62755 .6307 L
.64717 .63687 L
.6668 .64318 L
.679 .64717 L
.68642 .64962 L
.70604 .65618 L
.72567 .66288 L
.73693 .6668 L
.74529 .66972 L
.76491 .6767 L
.78454 .68384 L
.79152 .68642 L
Mistroke
.80416 .69113 L
.82378 .69857 L
.84302 .70604 L
.84341 .7062 L
.86303 .71398 L
.88265 .72196 L
.89159 .72567 L
.90228 .73013 L
.9219 .73851 L
.93738 .74529 L
.94152 .74712 L
.96115 .75595 L
.98048 .76491 L
.98077 .76505 L
Mfstroke
0 1 .1 r
.01923 .49974 m
.03885 .4976 L
.05848 .49425 L
.0781 .49038 L
.07892 .49019 L
.09772 .48616 L
.11735 .48142 L
.13697 .47631 L
.15659 .47085 L
.1576 .47057 L
.17622 .46515 L
.19584 .45908 L
.21546 .45269 L
.22065 .45094 L
.23509 .44603 L
.25471 .43905 L
.27433 .43172 L
.27537 .43132 L
.29396 .42412 L
.31358 .41614 L
.32414 .4117 L
.3332 .40784 L
.35283 .39916 L
.36815 .39207 L
.37245 .39006 L
.39207 .38057 L
.40804 .37245 L
.4117 .37057 L
.43132 .36009 L
.44423 .35283 L
.45094 .349 L
.47057 .33722 L
.47693 .3332 L
.49019 .32468 L
.50625 .31358 L
.50981 .31109 L
.52943 .29622 L
.53221 .29396 L
.54906 .27968 L
.55471 .27433 L
.56868 .26039 L
.57353 .25471 L
.5883 .23509 L
.5883 .23509 L
.59838 .21546 L
.60261 .19584 L
.59862 .17622 L
.5883 .16071 L
.57983 .15659 L
.56868 .15079 L
.54906 .14484 L
.52943 .14191 L
.50981 .14091 L
.49019 .14138 L
.47057 .14306 L
.45094 .1458 L
.43132 .14947 L
.4117 .15401 L
.40157 .15659 L
.39207 .15934 L
.37245 .16544 L
.35283 .17233 L
.3424 .17622 L
.3332 .17994 L
.31358 .18832 L
.29723 .19584 L
.29396 .19748 L
.27433 .2074 L
.25934 .21546 L
.25471 .21817 L
.23509 .2298 L
.22643 .23509 L
.21546 .24236 L
.19744 .25471 L
.19584 .25595 L
.17622 .27063 L
.17126 .27433 L
.15659 .28656 L
.14743 .29396 L
.13697 .30392 L
.1258 .31358 L
.11735 .32298 L
.10602 .3332 L
.09772 .34412 L
.08978 .35283 L
.0781 .36797 L
.07375 .37245 L
.06038 .39207 L
.05848 .39545 L
.04311 .4117 L
.03885 .42944 L
.03852 .43132 L
.03571 .45094 L
.03285 .47057 L
.01923 .4805 L
F
0 g
.01923 .49974 m
.03885 .4976 L
.05848 .49425 L
.0781 .49038 L
.07892 .49019 L
.09772 .48616 L
.11735 .48142 L
.13697 .47631 L
.15659 .47085 L
.1576 .47057 L
.17622 .46515 L
.19584 .45908 L
.21546 .45269 L
.22065 .45094 L
.23509 .44603 L
.25471 .43905 L
.27433 .43172 L
.27537 .43132 L
.29396 .42412 L
.31358 .41614 L
.32414 .4117 L
.3332 .40784 L
.35283 .39916 L
.36815 .39207 L
.37245 .39006 L
.39207 .38057 L
.40804 .37245 L
.4117 .37057 L
.43132 .36009 L
.44423 .35283 L
.45094 .349 L
.47057 .33722 L
.47693 .3332 L
.49019 .32468 L
.50625 .31358 L
.50981 .31109 L
.52943 .29622 L
.53221 .29396 L
.54906 .27968 L
.55471 .27433 L
.56868 .26039 L
.57353 .25471 L
.5883 .23509 L
.5883 .23509 L
.59838 .21546 L
.60261 .19584 L
.59862 .17622 L
.5883 .16071 L
.57983 .15659 L
.56868 .15079 L
Mistroke
.54906 .14484 L
.52943 .14191 L
.50981 .14091 L
.49019 .14138 L
.47057 .14306 L
.45094 .1458 L
.43132 .14947 L
.4117 .15401 L
.40157 .15659 L
.39207 .15934 L
.37245 .16544 L
.35283 .17233 L
.3424 .17622 L
.3332 .17994 L
.31358 .18832 L
.29723 .19584 L
.29396 .19748 L
.27433 .2074 L
.25934 .21546 L
.25471 .21817 L
.23509 .2298 L
.22643 .23509 L
.21546 .24236 L
.19744 .25471 L
.19584 .25595 L
.17622 .27063 L
.17126 .27433 L
.15659 .28656 L
.14743 .29396 L
.13697 .30392 L
.1258 .31358 L
.11735 .32298 L
.10602 .3332 L
.09772 .34412 L
.08978 .35283 L
.0781 .36797 L
.07375 .37245 L
.06038 .39207 L
.05848 .39545 L
.04311 .4117 L
.03885 .42944 L
.03852 .43132 L
.03571 .45094 L
.03285 .47057 L
.01923 .4805 L
Mfstroke
0 .1 1 r
.01923 .5195 m
.03285 .52943 L
.03571 .54906 L
.03852 .56868 L
.03885 .57056 L
.04311 .5883 L
.05848 .60455 L
.06038 .60793 L
.07375 .62755 L
.0781 .63203 L
.08978 .64717 L
.09772 .65588 L
.10602 .6668 L
.11735 .67702 L
.1258 .68642 L
.13697 .69608 L
.14743 .70604 L
.15659 .71344 L
.17126 .72567 L
.17622 .72937 L
.19584 .74405 L
.19744 .74529 L
.21546 .75764 L
.22643 .76491 L
.23509 .7702 L
.25471 .78183 L
.25934 .78454 L
.27433 .7926 L
.29396 .80252 L
.29723 .80416 L
.31358 .81168 L
.3332 .82006 L
.3424 .82378 L
.35283 .82767 L
.37245 .83456 L
.39207 .84066 L
.40157 .84341 L
.4117 .84599 L
.43132 .85053 L
.45094 .8542 L
.47057 .85694 L
.49019 .85862 L
.50981 .85909 L
.52943 .85809 L
.54906 .85516 L
.56868 .84921 L
.57983 .84341 L
.5883 .83929 L
.59862 .82378 L
.60261 .80416 L
.59838 .78454 L
.5883 .76491 L
.5883 .76491 L
.57353 .74529 L
.56868 .73961 L
.55471 .72567 L
.54906 .72032 L
.53221 .70604 L
.52943 .70378 L
.50981 .68891 L
.50625 .68642 L
.49019 .67532 L
.47693 .6668 L
.47057 .66278 L
.45094 .651 L
.44423 .64717 L
.43132 .63991 L
.4117 .62943 L
.40804 .62755 L
.39207 .61943 L
.37245 .60994 L
.36815 .60793 L
.35283 .60084 L
.3332 .59216 L
.32414 .5883 L
.31358 .58386 L
.29396 .57588 L
.27537 .56868 L
.27433 .56828 L
.25471 .56095 L
.23509 .55397 L
.22065 .54906 L
.21546 .54731 L
.19584 .54092 L
.17622 .53485 L
.1576 .52943 L
.15659 .52915 L
.13697 .52369 L
.11735 .51858 L
.09772 .51384 L
.07892 .50981 L
.0781 .50962 L
.05848 .50575 L
.03885 .5024 L
.01923 .50026 L
F
0 g
.01923 .5195 m
.03285 .52943 L
.03571 .54906 L
.03852 .56868 L
.03885 .57056 L
.04311 .5883 L
.05848 .60455 L
.06038 .60793 L
.07375 .62755 L
.0781 .63203 L
.08978 .64717 L
.09772 .65588 L
.10602 .6668 L
.11735 .67702 L
.1258 .68642 L
.13697 .69608 L
.14743 .70604 L
.15659 .71344 L
.17126 .72567 L
.17622 .72937 L
.19584 .74405 L
.19744 .74529 L
.21546 .75764 L
.22643 .76491 L
.23509 .7702 L
.25471 .78183 L
.25934 .78454 L
.27433 .7926 L
.29396 .80252 L
.29723 .80416 L
.31358 .81168 L
.3332 .82006 L
.3424 .82378 L
.35283 .82767 L
.37245 .83456 L
.39207 .84066 L
.40157 .84341 L
.4117 .84599 L
.43132 .85053 L
.45094 .8542 L
.47057 .85694 L
.49019 .85862 L
.50981 .85909 L
.52943 .85809 L
.54906 .85516 L
.56868 .84921 L
.57983 .84341 L
.5883 .83929 L
.59862 .82378 L
.60261 .80416 L
Mistroke
.59838 .78454 L
.5883 .76491 L
.5883 .76491 L
.57353 .74529 L
.56868 .73961 L
.55471 .72567 L
.54906 .72032 L
.53221 .70604 L
.52943 .70378 L
.50981 .68891 L
.50625 .68642 L
.49019 .67532 L
.47693 .6668 L
.47057 .66278 L
.45094 .651 L
.44423 .64717 L
.43132 .63991 L
.4117 .62943 L
.40804 .62755 L
.39207 .61943 L
.37245 .60994 L
.36815 .60793 L
.35283 .60084 L
.3332 .59216 L
.32414 .5883 L
.31358 .58386 L
.29396 .57588 L
.27537 .56868 L
.27433 .56828 L
.25471 .56095 L
.23509 .55397 L
.22065 .54906 L
.21546 .54731 L
.19584 .54092 L
.17622 .53485 L
.1576 .52943 L
.15659 .52915 L
.13697 .52369 L
.11735 .51858 L
.09772 .51384 L
.07892 .50981 L
.0781 .50962 L
.05848 .50575 L
.03885 .5024 L
.01923 .50026 L
Mfstroke
0 1 .7 r
.01923 .48041 m
.03263 .47057 L
.03555 .45094 L
.03831 .43132 L
.03885 .42828 L
.04276 .4117 L
.05848 .39298 L
.05896 .39207 L
.07073 .37245 L
.0781 .36359 L
.08562 .35283 L
.09772 .33778 L
.10018 .3332 L
.11735 .31447 L
.11793 .31358 L
.13602 .29396 L
.13697 .29302 L
.15525 .27433 L
.15659 .27307 L
.17585 .25471 L
.17622 .25439 L
.19584 .23677 L
.19769 .23509 L
.21546 .22008 L
.22095 .21546 L
.23509 .20422 L
.24575 .19584 L
.25471 .1891 L
.27214 .17622 L
.27433 .17465 L
.29396 .16081 L
.30005 .15659 L
.31358 .14754 L
.32978 .13697 L
.3332 .13479 L
.35283 .12253 L
.36132 .11735 L
.37245 .11073 L
.39207 .09937 L
.39496 .09772 L
.4117 .08842 L
.43086 .0781 L
.43132 .07786 L
.45094 .06767 L
.46927 .05848 L
.47057 .05784 L
.49019 .04835 L
.50981 .03921 L
.51058 .03885 L
.52943 .03039 L
.54906 .02187 L
.55526 .01923 L
.01923 .01923 L
F
0 g
.01923 .48041 m
.03263 .47057 L
.03555 .45094 L
.03831 .43132 L
.03885 .42828 L
.04276 .4117 L
.05848 .39298 L
.05896 .39207 L
.07073 .37245 L
.0781 .36359 L
.08562 .35283 L
.09772 .33778 L
.10018 .3332 L
.11735 .31447 L
.11793 .31358 L
.13602 .29396 L
.13697 .29302 L
.15525 .27433 L
.15659 .27307 L
.17585 .25471 L
.17622 .25439 L
.19584 .23677 L
.19769 .23509 L
.21546 .22008 L
.22095 .21546 L
.23509 .20422 L
.24575 .19584 L
.25471 .1891 L
.27214 .17622 L
.27433 .17465 L
.29396 .16081 L
.30005 .15659 L
.31358 .14754 L
.32978 .13697 L
.3332 .13479 L
.35283 .12253 L
.36132 .11735 L
.37245 .11073 L
.39207 .09937 L
.39496 .09772 L
.4117 .08842 L
.43086 .0781 L
.43132 .07786 L
.45094 .06767 L
.46927 .05848 L
.47057 .05784 L
.49019 .04835 L
.50981 .03921 L
.51058 .03885 L
.52943 .03039 L
Mistroke
.54906 .02187 L
.55526 .01923 L
Mfstroke
0 .7 1 r
.01923 .51959 m
.03263 .52943 L
.03555 .54906 L
.03831 .56868 L
.03885 .57172 L
.04276 .5883 L
.05848 .60702 L
.05896 .60793 L
.07073 .62755 L
.0781 .63641 L
.08562 .64717 L
.09772 .66222 L
.10018 .6668 L
.11735 .68553 L
.11793 .68642 L
.13602 .70604 L
.13697 .70698 L
.15525 .72567 L
.15659 .72693 L
.17585 .74529 L
.17622 .74561 L
.19584 .76323 L
.19769 .76491 L
.21546 .77992 L
.22095 .78454 L
.23509 .79578 L
.24575 .80416 L
.25471 .8109 L
.27214 .82378 L
.27433 .82535 L
.29396 .83919 L
.30005 .84341 L
.31358 .85246 L
.32978 .86303 L
.3332 .86521 L
.35283 .87747 L
.36132 .88265 L
.37245 .88927 L
.39207 .90063 L
.39496 .90228 L
.4117 .91158 L
.43086 .9219 L
.43132 .92214 L
.45094 .93233 L
.46927 .94152 L
.47057 .94216 L
.49019 .95165 L
.50981 .96079 L
.51058 .96115 L
.52943 .96961 L
.54906 .97813 L
.55526 .98077 L
.01923 .98077 L
F
0 g
.01923 .51959 m
.03263 .52943 L
.03555 .54906 L
.03831 .56868 L
.03885 .57172 L
.04276 .5883 L
.05848 .60702 L
.05896 .60793 L
.07073 .62755 L
.0781 .63641 L
.08562 .64717 L
.09772 .66222 L
.10018 .6668 L
.11735 .68553 L
.11793 .68642 L
.13602 .70604 L
.13697 .70698 L
.15525 .72567 L
.15659 .72693 L
.17585 .74529 L
.17622 .74561 L
.19584 .76323 L
.19769 .76491 L
.21546 .77992 L
.22095 .78454 L
.23509 .79578 L
.24575 .80416 L
.25471 .8109 L
.27214 .82378 L
.27433 .82535 L
.29396 .83919 L
.30005 .84341 L
.31358 .85246 L
.32978 .86303 L
.3332 .86521 L
.35283 .87747 L
.36132 .88265 L
.37245 .88927 L
.39207 .90063 L
.39496 .90228 L
.4117 .91158 L
.43086 .9219 L
.43132 .92214 L
.45094 .93233 L
.46927 .94152 L
.47057 .94216 L
.49019 .95165 L
.50981 .96079 L
.51058 .96115 L
.52943 .96961 L
Mistroke
.54906 .97813 L
.55526 .98077 L
Mfstroke
0 1 1 r
.01923 .48031 m
.03241 .47057 L
.03539 .45094 L
.03811 .43132 L
.03885 .42712 L
.04243 .4117 L
.05016 .39207 L
.05848 .39045 L
.06839 .37245 L
.0781 .35931 L
.08229 .35283 L
.09637 .3332 L
.09772 .33162 L
.11088 .31358 L
.11735 .30617 L
.12675 .29396 L
.13697 .28248 L
.14363 .27433 L
.15659 .26016 L
.16133 .25471 L
.17622 .23896 L
.17978 .23509 L
.19584 .21872 L
.19899 .21546 L
.21546 .19929 L
.21896 .19584 L
.23509 .18057 L
.2397 .17622 L
.25471 .16249 L
.2612 .15659 L
.27433 .14497 L
.28346 .13697 L
.29396 .12797 L
.30648 .11735 L
.31358 .11144 L
.33024 .09772 L
.3332 .09533 L
.35283 .07961 L
.35473 .0781 L
.37245 .06426 L
.37995 .05848 L
.39207 .04925 L
.40591 .03885 L
.4117 .03456 L
.43132 .02017 L
.4326 .01923 L
.01923 .01923 L
F
0 g
.01923 .48031 m
.03241 .47057 L
.03539 .45094 L
.03811 .43132 L
.03885 .42712 L
.04243 .4117 L
.05016 .39207 L
.05848 .39045 L
.06839 .37245 L
.0781 .35931 L
.08229 .35283 L
.09637 .3332 L
.09772 .33162 L
.11088 .31358 L
.11735 .30617 L
.12675 .29396 L
.13697 .28248 L
.14363 .27433 L
.15659 .26016 L
.16133 .25471 L
.17622 .23896 L
.17978 .23509 L
.19584 .21872 L
.19899 .21546 L
.21546 .19929 L
.21896 .19584 L
.23509 .18057 L
.2397 .17622 L
.25471 .16249 L
.2612 .15659 L
.27433 .14497 L
.28346 .13697 L
.29396 .12797 L
.30648 .11735 L
.31358 .11144 L
.33024 .09772 L
.3332 .09533 L
.35283 .07961 L
.35473 .0781 L
.37245 .06426 L
.37995 .05848 L
.39207 .04925 L
.40591 .03885 L
.4117 .03456 L
.43132 .02017 L
.4326 .01923 L
s
0 1 1 r
.01923 .51969 m
.03241 .52943 L
.03539 .54906 L
.03811 .56868 L
.03885 .57288 L
.04243 .5883 L
.05016 .60793 L
.05848 .60955 L
.06839 .62755 L
.0781 .64069 L
.08229 .64717 L
.09637 .6668 L
.09772 .66838 L
.11088 .68642 L
.11735 .69383 L
.12675 .70604 L
.13697 .71752 L
.14363 .72567 L
.15659 .73984 L
.16133 .74529 L
.17622 .76104 L
.17978 .76491 L
.19584 .78128 L
.19899 .78454 L
.21546 .80071 L
.21896 .80416 L
.23509 .81943 L
.2397 .82378 L
.25471 .83751 L
.2612 .84341 L
.27433 .85503 L
.28346 .86303 L
.29396 .87203 L
.30648 .88265 L
.31358 .88856 L
.33024 .90228 L
.3332 .90467 L
.35283 .92039 L
.35473 .9219 L
.37245 .93574 L
.37995 .94152 L
.39207 .95075 L
.40591 .96115 L
.4117 .96544 L
.43132 .97983 L
.4326 .98077 L
.01923 .98077 L
F
0 g
.01923 .51969 m
.03241 .52943 L
.03539 .54906 L
.03811 .56868 L
.03885 .57288 L
.04243 .5883 L
.05016 .60793 L
.05848 .60955 L
.06839 .62755 L
.0781 .64069 L
.08229 .64717 L
.09637 .6668 L
.09772 .66838 L
.11088 .68642 L
.11735 .69383 L
.12675 .70604 L
.13697 .71752 L
.14363 .72567 L
.15659 .73984 L
.16133 .74529 L
.17622 .76104 L
.17978 .76491 L
.19584 .78128 L
.19899 .78454 L
.21546 .80071 L
.21896 .80416 L
.23509 .81943 L
.2397 .82378 L
.25471 .83751 L
.2612 .84341 L
.27433 .85503 L
.28346 .86303 L
.29396 .87203 L
.30648 .88265 L
.31358 .88856 L
.33024 .90228 L
.3332 .90467 L
.35283 .92039 L
.35473 .9219 L
.37245 .93574 L
.37995 .94152 L
.39207 .95075 L
.40591 .96115 L
.4117 .96544 L
.43132 .97983 L
.4326 .98077 L
s
0 .7 1 r
.01923 .48022 m
.0322 .47057 L
.03523 .45094 L
.03792 .43132 L
.03885 .42599 L
.04211 .4117 L
.04913 .39207 L
.05848 .38788 L
.06645 .37245 L
.0781 .35512 L
.07948 .35283 L
.09162 .3332 L
.09772 .32551 L
.1052 .31358 L
.11735 .29806 L
.12003 .29396 L
.13523 .27433 L
.13697 .2722 L
.15064 .25471 L
.15659 .24759 L
.16672 .23509 L
.17622 .224 L
.18338 .21546 L
.19584 .20126 L
.20054 .19584 L
.21546 .17924 L
.21817 .17622 L
.23509 .15785 L
.23625 .15659 L
.25471 .13702 L
.25475 .13697 L
.27367 .11735 L
.27433 .11667 L
.29299 .09772 L
.29396 .09676 L
.31271 .0781 L
.31358 .07724 L
.3328 .05848 L
.3332 .05809 L
.35283 .03927 L
.35326 .03885 L
.37245 .02075 L
.37406 .01923 L
.01923 .01923 L
F
0 g
.01923 .48022 m
.0322 .47057 L
.03523 .45094 L
.03792 .43132 L
.03885 .42599 L
.04211 .4117 L
.04913 .39207 L
.05848 .38788 L
.06645 .37245 L
.0781 .35512 L
.07948 .35283 L
.09162 .3332 L
.09772 .32551 L
.1052 .31358 L
.11735 .29806 L
.12003 .29396 L
.13523 .27433 L
.13697 .2722 L
.15064 .25471 L
.15659 .24759 L
.16672 .23509 L
.17622 .224 L
.18338 .21546 L
.19584 .20126 L
.20054 .19584 L
.21546 .17924 L
.21817 .17622 L
.23509 .15785 L
.23625 .15659 L
.25471 .13702 L
.25475 .13697 L
.27367 .11735 L
.27433 .11667 L
.29299 .09772 L
.29396 .09676 L
.31271 .0781 L
.31358 .07724 L
.3328 .05848 L
.3332 .05809 L
.35283 .03927 L
.35326 .03885 L
.37245 .02075 L
.37406 .01923 L
s
0 1 .7 r
.01923 .51978 m
.0322 .52943 L
.03523 .54906 L
.03792 .56868 L
.03885 .57401 L
.04211 .5883 L
.04913 .60793 L
.05848 .61212 L
.06645 .62755 L
.0781 .64488 L
.07948 .64717 L
.09162 .6668 L
.09772 .67449 L
.1052 .68642 L
.11735 .70194 L
.12003 .70604 L
.13523 .72567 L
.13697 .7278 L
.15064 .74529 L
.15659 .75241 L
.16672 .76491 L
.17622 .776 L
.18338 .78454 L
.19584 .79874 L
.20054 .80416 L
.21546 .82076 L
.21817 .82378 L
.23509 .84215 L
.23625 .84341 L
.25471 .86298 L
.25475 .86303 L
.27367 .88265 L
.27433 .88333 L
.29299 .90228 L
.29396 .90324 L
.31271 .9219 L
.31358 .92276 L
.3328 .94152 L
.3332 .94191 L
.35283 .96073 L
.35326 .96115 L
.37245 .97925 L
.37406 .98077 L
.01923 .98077 L
F
0 g
.01923 .51978 m
.0322 .52943 L
.03523 .54906 L
.03792 .56868 L
.03885 .57401 L
.04211 .5883 L
.04913 .60793 L
.05848 .61212 L
.06645 .62755 L
.0781 .64488 L
.07948 .64717 L
.09162 .6668 L
.09772 .67449 L
.1052 .68642 L
.11735 .70194 L
.12003 .70604 L
.13523 .72567 L
.13697 .7278 L
.15064 .74529 L
.15659 .75241 L
.16672 .76491 L
.17622 .776 L
.18338 .78454 L
.19584 .79874 L
.20054 .80416 L
.21546 .82076 L
.21817 .82378 L
.23509 .84215 L
.23625 .84341 L
.25471 .86298 L
.25475 .86303 L
.27367 .88265 L
.27433 .88333 L
.29299 .90228 L
.29396 .90324 L
.31271 .9219 L
.31358 .92276 L
.3328 .94152 L
.3332 .94191 L
.35283 .96073 L
.35326 .96115 L
.37245 .97925 L
.37406 .98077 L
s
.2 0 1 r
.01923 .51941 m
.03308 .52943 L
.03588 .54906 L
.03873 .56868 L
.03885 .56937 L
.04349 .5883 L
.05848 .602 L
.06199 .60793 L
.0781 .62751 L
.07813 .62755 L
.09546 .64717 L
.09772 .64926 L
.11573 .6668 L
.11735 .66803 L
.13697 .68448 L
.1386 .68642 L
.15659 .69896 L
.1664 .70604 L
.17622 .71164 L
.19584 .72276 L
.2006 .72567 L
.21546 .73237 L
.23509 .74051 L
.24806 .74529 L
.25471 .74709 L
.27433 .75219 L
.29396 .7555 L
.31358 .75668 L
.3332 .75498 L
.35283 .74785 L
.3564 .74529 L
.36943 .72567 L
.3684 .70604 L
.35992 .68642 L
.35283 .67359 L
.34603 .6668 L
.3332 .6521 L
.32763 .64717 L
.31358 .63423 L
.30512 .62755 L
.29396 .61874 L
.27863 .60793 L
.27433 .60495 L
.25471 .59225 L
.24804 .5883 L
.23509 .58065 L
.21546 .56996 L
.21296 .56868 L
.19584 .55992 L
.17622 .55067 L
.17257 .54906 L
.15659 .54198 L
.13697 .53392 L
.12497 .52943 L
.11735 .52655 L
.09772 .51962 L
.0781 .51338 L
.06394 .50981 L
.05848 .50811 L
.03885 .50338 L
.01923 .50036 L
F
0 g
.01923 .51941 m
.03308 .52943 L
.03588 .54906 L
.03873 .56868 L
.03885 .56937 L
.04349 .5883 L
.05848 .602 L
.06199 .60793 L
.0781 .62751 L
.07813 .62755 L
.09546 .64717 L
.09772 .64926 L
.11573 .6668 L
.11735 .66803 L
.13697 .68448 L
.1386 .68642 L
.15659 .69896 L
.1664 .70604 L
.17622 .71164 L
.19584 .72276 L
.2006 .72567 L
.21546 .73237 L
.23509 .74051 L
.24806 .74529 L
.25471 .74709 L
.27433 .75219 L
.29396 .7555 L
.31358 .75668 L
.3332 .75498 L
.35283 .74785 L
.3564 .74529 L
.36943 .72567 L
.3684 .70604 L
.35992 .68642 L
.35283 .67359 L
.34603 .6668 L
.3332 .6521 L
.32763 .64717 L
.31358 .63423 L
.30512 .62755 L
.29396 .61874 L
.27863 .60793 L
.27433 .60495 L
.25471 .59225 L
.24804 .5883 L
.23509 .58065 L
.21546 .56996 L
.21296 .56868 L
.19584 .55992 L
.17622 .55067 L
Mistroke
.17257 .54906 L
.15659 .54198 L
.13697 .53392 L
.12497 .52943 L
.11735 .52655 L
.09772 .51962 L
.0781 .51338 L
.06394 .50981 L
.05848 .50811 L
.03885 .50338 L
.01923 .50036 L
Mfstroke
.2 1 0 r
.01923 .49964 m
.03885 .49662 L
.05848 .49189 L
.06394 .49019 L
.0781 .48662 L
.09772 .48038 L
.11735 .47345 L
.12497 .47057 L
.13697 .46608 L
.15659 .45802 L
.17257 .45094 L
.17622 .44933 L
.19584 .44008 L
.21296 .43132 L
.21546 .43004 L
.23509 .41935 L
.24804 .4117 L
.25471 .40775 L
.27433 .39505 L
.27863 .39207 L
.29396 .38126 L
.30512 .37245 L
.31358 .36577 L
.32763 .35283 L
.3332 .3479 L
.34603 .3332 L
.35283 .32641 L
.35992 .31358 L
.3684 .29396 L
.36943 .27433 L
.3564 .25471 L
.35283 .25215 L
.3332 .24502 L
.31358 .24332 L
.29396 .2445 L
.27433 .24781 L
.25471 .25291 L
.24806 .25471 L
.23509 .25949 L
.21546 .26763 L
.2006 .27433 L
.19584 .27724 L
.17622 .28836 L
.1664 .29396 L
.15659 .30104 L
.1386 .31358 L
.13697 .31552 L
.11735 .33197 L
.11573 .3332 L
.09772 .35074 L
.09546 .35283 L
.07813 .37245 L
.0781 .37249 L
.06199 .39207 L
.05848 .398 L
.04349 .4117 L
.03885 .43063 L
.03873 .43132 L
.03588 .45094 L
.03308 .47057 L
.01923 .48059 L
F
0 g
.01923 .49964 m
.03885 .49662 L
.05848 .49189 L
.06394 .49019 L
.0781 .48662 L
.09772 .48038 L
.11735 .47345 L
.12497 .47057 L
.13697 .46608 L
.15659 .45802 L
.17257 .45094 L
.17622 .44933 L
.19584 .44008 L
.21296 .43132 L
.21546 .43004 L
.23509 .41935 L
.24804 .4117 L
.25471 .40775 L
.27433 .39505 L
.27863 .39207 L
.29396 .38126 L
.30512 .37245 L
.31358 .36577 L
.32763 .35283 L
.3332 .3479 L
.34603 .3332 L
.35283 .32641 L
.35992 .31358 L
.3684 .29396 L
.36943 .27433 L
.3564 .25471 L
.35283 .25215 L
.3332 .24502 L
.31358 .24332 L
.29396 .2445 L
.27433 .24781 L
.25471 .25291 L
.24806 .25471 L
.23509 .25949 L
.21546 .26763 L
.2006 .27433 L
.19584 .27724 L
.17622 .28836 L
.1664 .29396 L
.15659 .30104 L
.1386 .31358 L
.13697 .31552 L
.11735 .33197 L
.11573 .3332 L
.09772 .35074 L
Mistroke
.09546 .35283 L
.07813 .37245 L
.0781 .37249 L
.06199 .39207 L
.05848 .398 L
.04349 .4117 L
.03885 .43063 L
.03873 .43132 L
.03588 .45094 L
.03308 .47057 L
.01923 .48059 L
Mfstroke
0 .4 1 r
.01923 .48013 m
.03199 .47057 L
.03508 .45094 L
.03773 .43132 L
.03885 .42486 L
.04181 .4117 L
.0483 .39207 L
.05848 .38534 L
.06478 .37245 L
.07678 .35283 L
.0781 .35095 L
.08768 .3332 L
.09772 .31948 L
.1009 .31358 L
.11448 .29396 L
.11735 .29003 L
.12789 .27433 L
.13697 .26204 L
.14203 .25471 L
.15659 .23519 L
.15667 .23509 L
.17137 .21546 L
.17622 .20924 L
.18649 .19584 L
.19584 .18404 L
.20198 .17622 L
.21546 .15948 L
.21778 .15659 L
.23384 .13697 L
.23509 .13547 L
.25013 .11735 L
.25471 .11192 L
.26668 .09772 L
.27433 .08878 L
.28348 .0781 L
.29396 .06601 L
.3005 .05848 L
.31358 .04357 L
.31772 .03885 L
.3332 .02142 L
.33515 .01923 L
.01923 .01923 L
F
0 g
.01923 .48013 m
.03199 .47057 L
.03508 .45094 L
.03773 .43132 L
.03885 .42486 L
.04181 .4117 L
.0483 .39207 L
.05848 .38534 L
.06478 .37245 L
.07678 .35283 L
.0781 .35095 L
.08768 .3332 L
.09772 .31948 L
.1009 .31358 L
.11448 .29396 L
.11735 .29003 L
.12789 .27433 L
.13697 .26204 L
.14203 .25471 L
.15659 .23519 L
.15667 .23509 L
.17137 .21546 L
.17622 .20924 L
.18649 .19584 L
.19584 .18404 L
.20198 .17622 L
.21546 .15948 L
.21778 .15659 L
.23384 .13697 L
.23509 .13547 L
.25013 .11735 L
.25471 .11192 L
.26668 .09772 L
.27433 .08878 L
.28348 .0781 L
.29396 .06601 L
.3005 .05848 L
.31358 .04357 L
.31772 .03885 L
.3332 .02142 L
.33515 .01923 L
s
0 1 .4 r
.01923 .51987 m
.03199 .52943 L
.03508 .54906 L
.03773 .56868 L
.03885 .57514 L
.04181 .5883 L
.0483 .60793 L
.05848 .61466 L
.06478 .62755 L
.07678 .64717 L
.0781 .64905 L
.08768 .6668 L
.09772 .68052 L
.1009 .68642 L
.11448 .70604 L
.11735 .70997 L
.12789 .72567 L
.13697 .73796 L
.14203 .74529 L
.15659 .76481 L
.15667 .76491 L
.17137 .78454 L
.17622 .79076 L
.18649 .80416 L
.19584 .81596 L
.20198 .82378 L
.21546 .84052 L
.21778 .84341 L
.23384 .86303 L
.23509 .86453 L
.25013 .88265 L
.25471 .88808 L
.26668 .90228 L
.27433 .91122 L
.28348 .9219 L
.29396 .93399 L
.3005 .94152 L
.31358 .95643 L
.31772 .96115 L
.3332 .97858 L
.33515 .98077 L
.01923 .98077 L
F
0 g
.01923 .51987 m
.03199 .52943 L
.03508 .54906 L
.03773 .56868 L
.03885 .57514 L
.04181 .5883 L
.0483 .60793 L
.05848 .61466 L
.06478 .62755 L
.07678 .64717 L
.0781 .64905 L
.08768 .6668 L
.09772 .68052 L
.1009 .68642 L
.11448 .70604 L
.11735 .70997 L
.12789 .72567 L
.13697 .73796 L
.14203 .74529 L
.15659 .76481 L
.15667 .76491 L
.17137 .78454 L
.17622 .79076 L
.18649 .80416 L
.19584 .81596 L
.20198 .82378 L
.21546 .84052 L
.21778 .84341 L
.23384 .86303 L
.23509 .86453 L
.25013 .88265 L
.25471 .88808 L
.26668 .90228 L
.27433 .91122 L
.28348 .9219 L
.29396 .93399 L
.3005 .94152 L
.31358 .95643 L
.31772 .96115 L
.3332 .97858 L
.33515 .98077 L
s
0 .1 1 r
.01923 .48003 m
.03179 .47057 L
.03493 .45094 L
.03754 .43132 L
.03885 .42375 L
.04151 .4117 L
.0476 .39207 L
.05848 .38283 L
.06331 .37245 L
.07421 .35283 L
.0781 .34677 L
.08447 .3332 L
.09766 .31358 L
.09772 .31349 L
.10932 .29396 L
.11735 .28203 L
.12198 .27433 L
.13505 .25471 L
.13697 .25191 L
.14807 .23509 L
.15659 .2228 L
.16152 .21546 L
.17525 .19584 L
.17622 .19448 L
.18906 .17622 L
.19584 .16681 L
.20313 .15659 L
.21546 .13967 L
.21741 .13697 L
.23183 .11735 L
.23509 .11297 L
.2464 .09772 L
.25471 .08665 L
.26112 .0781 L
.27433 .06066 L
.27598 .05848 L
.29095 .03885 L
.29396 .03494 L
.30602 .01923 L
.01923 .01923 L
F
0 g
.01923 .48003 m
.03179 .47057 L
.03493 .45094 L
.03754 .43132 L
.03885 .42375 L
.04151 .4117 L
.0476 .39207 L
.05848 .38283 L
.06331 .37245 L
.07421 .35283 L
.0781 .34677 L
.08447 .3332 L
.09766 .31358 L
.09772 .31349 L
.10932 .29396 L
.11735 .28203 L
.12198 .27433 L
.13505 .25471 L
.13697 .25191 L
.14807 .23509 L
.15659 .2228 L
.16152 .21546 L
.17525 .19584 L
.17622 .19448 L
.18906 .17622 L
.19584 .16681 L
.20313 .15659 L
.21546 .13967 L
.21741 .13697 L
.23183 .11735 L
.23509 .11297 L
.2464 .09772 L
.25471 .08665 L
.26112 .0781 L
.27433 .06066 L
.27598 .05848 L
.29095 .03885 L
.29396 .03494 L
.30602 .01923 L
s
0 1 .1 r
.01923 .51997 m
.03179 .52943 L
.03493 .54906 L
.03754 .56868 L
.03885 .57625 L
.04151 .5883 L
.0476 .60793 L
.05848 .61717 L
.06331 .62755 L
.07421 .64717 L
.0781 .65323 L
.08447 .6668 L
.09766 .68642 L
.09772 .68651 L
.10932 .70604 L
.11735 .71797 L
.12198 .72567 L
.13505 .74529 L
.13697 .74809 L
.14807 .76491 L
.15659 .7772 L
.16152 .78454 L
.17525 .80416 L
.17622 .80552 L
.18906 .82378 L
.19584 .83319 L
.20313 .84341 L
.21546 .86033 L
.21741 .86303 L
.23183 .88265 L
.23509 .88703 L
.2464 .90228 L
.25471 .91335 L
.26112 .9219 L
.27433 .93934 L
.27598 .94152 L
.29095 .96115 L
.29396 .96506 L
.30602 .98077 L
.01923 .98077 L
F
0 g
.01923 .51997 m
.03179 .52943 L
.03493 .54906 L
.03754 .56868 L
.03885 .57625 L
.04151 .5883 L
.0476 .60793 L
.05848 .61717 L
.06331 .62755 L
.07421 .64717 L
.0781 .65323 L
.08447 .6668 L
.09766 .68642 L
.09772 .68651 L
.10932 .70604 L
.11735 .71797 L
.12198 .72567 L
.13505 .74529 L
.13697 .74809 L
.14807 .76491 L
.15659 .7772 L
.16152 .78454 L
.17525 .80416 L
.17622 .80552 L
.18906 .82378 L
.19584 .83319 L
.20313 .84341 L
.21546 .86033 L
.21741 .86303 L
.23183 .88265 L
.23509 .88703 L
.2464 .90228 L
.25471 .91335 L
.26112 .9219 L
.27433 .93934 L
.27598 .94152 L
.29095 .96115 L
.29396 .96506 L
.30602 .98077 L
s
.2 0 1 r
.01923 .47994 m
.03159 .47057 L
.03478 .45094 L
.03736 .43132 L
.03885 .42264 L
.04123 .4117 L
.04698 .39207 L
.05848 .38032 L
.06199 .37245 L
.07202 .35283 L
.0781 .34261 L
.08191 .3332 L
.09387 .31358 L
.09772 .30747 L
.10499 .29396 L
.11714 .27433 L
.11735 .27401 L
.12877 .25471 L
.13697 .24172 L
.14094 .23509 L
.15328 .21546 L
.15659 .21031 L
.16568 .19584 L
.17622 .17956 L
.17834 .17622 L
.19106 .15659 L
.19584 .14932 L
.20389 .13697 L
.21546 .1195 L
.21688 .11735 L
.22991 .09772 L
.23509 .09 L
.24303 .0781 L
.25471 .06076 L
.25624 .05848 L
.2695 .03885 L
.27433 .03173 L
.2828 .01923 L
.01923 .01923 L
F
0 g
.01923 .47994 m
.03159 .47057 L
.03478 .45094 L
.03736 .43132 L
.03885 .42264 L
.04123 .4117 L
.04698 .39207 L
.05848 .38032 L
.06199 .37245 L
.07202 .35283 L
.0781 .34261 L
.08191 .3332 L
.09387 .31358 L
.09772 .30747 L
.10499 .29396 L
.11714 .27433 L
.11735 .27401 L
.12877 .25471 L
.13697 .24172 L
.14094 .23509 L
.15328 .21546 L
.15659 .21031 L
.16568 .19584 L
.17622 .17956 L
.17834 .17622 L
.19106 .15659 L
.19584 .14932 L
.20389 .13697 L
.21546 .1195 L
.21688 .11735 L
.22991 .09772 L
.23509 .09 L
.24303 .0781 L
.25471 .06076 L
.25624 .05848 L
.2695 .03885 L
.27433 .03173 L
.2828 .01923 L
s
.2 1 0 r
.01923 .52006 m
.03159 .52943 L
.03478 .54906 L
.03736 .56868 L
.03885 .57736 L
.04123 .5883 L
.04698 .60793 L
.05848 .61968 L
.06199 .62755 L
.07202 .64717 L
.0781 .65739 L
.08191 .6668 L
.09387 .68642 L
.09772 .69253 L
.10499 .70604 L
.11714 .72567 L
.11735 .72599 L
.12877 .74529 L
.13697 .75828 L
.14094 .76491 L
.15328 .78454 L
.15659 .78969 L
.16568 .80416 L
.17622 .82044 L
.17834 .82378 L
.19106 .84341 L
.19584 .85068 L
.20389 .86303 L
.21546 .8805 L
.21688 .88265 L
.22991 .90228 L
.23509 .91 L
.24303 .9219 L
.25471 .93924 L
.25624 .94152 L
.2695 .96115 L
.27433 .96827 L
.2828 .98077 L
.01923 .98077 L
F
0 g
.01923 .52006 m
.03159 .52943 L
.03478 .54906 L
.03736 .56868 L
.03885 .57736 L
.04123 .5883 L
.04698 .60793 L
.05848 .61968 L
.06199 .62755 L
.07202 .64717 L
.0781 .65739 L
.08191 .6668 L
.09387 .68642 L
.09772 .69253 L
.10499 .70604 L
.11714 .72567 L
.11735 .72599 L
.12877 .74529 L
.13697 .75828 L
.14094 .76491 L
.15328 .78454 L
.15659 .78969 L
.16568 .80416 L
.17622 .82044 L
.17834 .82378 L
.19106 .84341 L
.19584 .85068 L
.20389 .86303 L
.21546 .8805 L
.21688 .88265 L
.22991 .90228 L
.23509 .91 L
.24303 .9219 L
.25471 .93924 L
.25624 .94152 L
.2695 .96115 L
.27433 .96827 L
.2828 .98077 L
s
.5 0 1 r
.01923 .47985 m
.03139 .47057 L
.03463 .45094 L
.03718 .43132 L
.03885 .42155 L
.04096 .4117 L
.04643 .39207 L
.05848 .37782 L
.06078 .37245 L
.07012 .35283 L
.0781 .33844 L
.07992 .3332 L
.09052 .31358 L
.09772 .30143 L
.10136 .29396 L
.11241 .27433 L
.11735 .26592 L
.12342 .25471 L
.1348 .23509 L
.13697 .23141 L
.14605 .21546 L
.15659 .19761 L
.15761 .19584 L
.16911 .17622 L
.17622 .16432 L
.18076 .15659 L
.19248 .13697 L
.19584 .13139 L
.20422 .11735 L
.21546 .09871 L
.21605 .09772 L
.22787 .0781 L
.23509 .0662 L
.23975 .05848 L
.25164 .03885 L
.25471 .0338 L
.26353 .01923 L
.01923 .01923 L
F
0 g
.01923 .47985 m
.03139 .47057 L
.03463 .45094 L
.03718 .43132 L
.03885 .42155 L
.04096 .4117 L
.04643 .39207 L
.05848 .37782 L
.06078 .37245 L
.07012 .35283 L
.0781 .33844 L
.07992 .3332 L
.09052 .31358 L
.09772 .30143 L
.10136 .29396 L
.11241 .27433 L
.11735 .26592 L
.12342 .25471 L
.1348 .23509 L
.13697 .23141 L
.14605 .21546 L
.15659 .19761 L
.15761 .19584 L
.16911 .17622 L
.17622 .16432 L
.18076 .15659 L
.19248 .13697 L
.19584 .13139 L
.20422 .11735 L
.21546 .09871 L
.21605 .09772 L
.22787 .0781 L
.23509 .0662 L
.23975 .05848 L
.25164 .03885 L
.25471 .0338 L
.26353 .01923 L
s
.5 1 0 r
.01923 .52015 m
.03139 .52943 L
.03463 .54906 L
.03718 .56868 L
.03885 .57845 L
.04096 .5883 L
.04643 .60793 L
.05848 .62218 L
.06078 .62755 L
.07012 .64717 L
.0781 .66156 L
.07992 .6668 L
.09052 .68642 L
.09772 .69857 L
.10136 .70604 L
.11241 .72567 L
.11735 .73408 L
.12342 .74529 L
.1348 .76491 L
.13697 .76859 L
.14605 .78454 L
.15659 .80239 L
.15761 .80416 L
.16911 .82378 L
.17622 .83568 L
.18076 .84341 L
.19248 .86303 L
.19584 .86861 L
.20422 .88265 L
.21546 .90129 L
.21605 .90228 L
.22787 .9219 L
.23509 .9338 L
.23975 .94152 L
.25164 .96115 L
.25471 .9662 L
.26353 .98077 L
.01923 .98077 L
F
0 g
.01923 .52015 m
.03139 .52943 L
.03463 .54906 L
.03718 .56868 L
.03885 .57845 L
.04096 .5883 L
.04643 .60793 L
.05848 .62218 L
.06078 .62755 L
.07012 .64717 L
.0781 .66156 L
.07992 .6668 L
.09052 .68642 L
.09772 .69857 L
.10136 .70604 L
.11241 .72567 L
.11735 .73408 L
.12342 .74529 L
.1348 .76491 L
.13697 .76859 L
.14605 .78454 L
.15659 .80239 L
.15761 .80416 L
.16911 .82378 L
.17622 .83568 L
.18076 .84341 L
.19248 .86303 L
.19584 .86861 L
.20422 .88265 L
.21546 .90129 L
.21605 .90228 L
.22787 .9219 L
.23509 .9338 L
.23975 .94152 L
.25164 .96115 L
.25471 .9662 L
.26353 .98077 L
s
.5 0 1 r
.01923 .51931 m
.03331 .52943 L
.03605 .54906 L
.03885 .56819 L
.03895 .56868 L
.04389 .5883 L
.05848 .59935 L
.06391 .60793 L
.0781 .62309 L
.08205 .62755 L
.09772 .64249 L
.10295 .64717 L
.11735 .65859 L
.12892 .6668 L
.13697 .67185 L
.15659 .68271 L
.16475 .68642 L
.17622 .69102 L
.19584 .69695 L
.21546 .69986 L
.23509 .69892 L
.25374 .68642 L
.25471 .68499 L
.2588 .6668 L
.25471 .65104 L
.25299 .64717 L
.24076 .62755 L
.23509 .61959 L
.22348 .60793 L
.21546 .59982 L
.20162 .5883 L
.19584 .58353 L
.17622 .56933 L
.17517 .56868 L
.15659 .55648 L
.14356 .54906 L
.13697 .54526 L
.11735 .53487 L
.10535 .52943 L
.09772 .52581 L
.0781 .51735 L
.05848 .51031 L
.04359 .50981 L
.03885 .50438 L
.01923 .50046 L
F
0 g
.01923 .51931 m
.03331 .52943 L
.03605 .54906 L
.03885 .56819 L
.03895 .56868 L
.04389 .5883 L
.05848 .59935 L
.06391 .60793 L
.0781 .62309 L
.08205 .62755 L
.09772 .64249 L
.10295 .64717 L
.11735 .65859 L
.12892 .6668 L
.13697 .67185 L
.15659 .68271 L
.16475 .68642 L
.17622 .69102 L
.19584 .69695 L
.21546 .69986 L
.23509 .69892 L
.25374 .68642 L
.25471 .68499 L
.2588 .6668 L
.25471 .65104 L
.25299 .64717 L
.24076 .62755 L
.23509 .61959 L
.22348 .60793 L
.21546 .59982 L
.20162 .5883 L
.19584 .58353 L
.17622 .56933 L
.17517 .56868 L
.15659 .55648 L
.14356 .54906 L
.13697 .54526 L
.11735 .53487 L
.10535 .52943 L
.09772 .52581 L
.0781 .51735 L
.05848 .51031 L
.04359 .50981 L
.03885 .50438 L
.01923 .50046 L
s
.5 1 0 r
.01923 .49954 m
.03885 .49562 L
.04359 .49019 L
.05848 .48969 L
.0781 .48265 L
.09772 .47419 L
.10535 .47057 L
.11735 .46513 L
.13697 .45474 L
.14356 .45094 L
.15659 .44352 L
.17517 .43132 L
.17622 .43067 L
.19584 .41647 L
.20162 .4117 L
.21546 .40018 L
.22348 .39207 L
.23509 .38041 L
.24076 .37245 L
.25299 .35283 L
.25471 .34896 L
.2588 .3332 L
.25471 .31501 L
.25374 .31358 L
.23509 .30108 L
.21546 .30014 L
.19584 .30305 L
.17622 .30898 L
.16475 .31358 L
.15659 .31729 L
.13697 .32815 L
.12892 .3332 L
.11735 .34141 L
.10295 .35283 L
.09772 .35751 L
.08205 .37245 L
.0781 .37691 L
.06391 .39207 L
.05848 .40065 L
.04389 .4117 L
.03895 .43132 L
.03885 .43181 L
.03605 .45094 L
.03331 .47057 L
.01923 .48069 L
F
0 g
.01923 .49954 m
.03885 .49562 L
.04359 .49019 L
.05848 .48969 L
.0781 .48265 L
.09772 .47419 L
.10535 .47057 L
.11735 .46513 L
.13697 .45474 L
.14356 .45094 L
.15659 .44352 L
.17517 .43132 L
.17622 .43067 L
.19584 .41647 L
.20162 .4117 L
.21546 .40018 L
.22348 .39207 L
.23509 .38041 L
.24076 .37245 L
.25299 .35283 L
.25471 .34896 L
.2588 .3332 L
.25471 .31501 L
.25374 .31358 L
.23509 .30108 L
.21546 .30014 L
.19584 .30305 L
.17622 .30898 L
.16475 .31358 L
.15659 .31729 L
.13697 .32815 L
.12892 .3332 L
.11735 .34141 L
.10295 .35283 L
.09772 .35751 L
.08205 .37245 L
.0781 .37691 L
.06391 .39207 L
.05848 .40065 L
.04389 .4117 L
.03895 .43132 L
.03885 .43181 L
.03605 .45094 L
.03331 .47057 L
.01923 .48069 L
s
.8 0 1 r
.01923 .47976 m
.0312 .47057 L
.03449 .45094 L
.03701 .43132 L
.03885 .42046 L
.0407 .4117 L
.04592 .39207 L
.05848 .37532 L
.05966 .37245 L
.06844 .35283 L
.0781 .33425 L
.07841 .3332 L
.08758 .31358 L
.09772 .29533 L
.09833 .29396 L
.10825 .27433 L
.11735 .25771 L
.11884 .25471 L
.12919 .23509 L
.13697 .22089 L
.13981 .21546 L
.15041 .19584 L
.15659 .18459 L
.16109 .17622 L
.17181 .15659 L
.17622 .1486 L
.18254 .13697 L
.19332 .11735 L
.19584 .11277 L
.20406 .09772 L
.21486 .0781 L
.21546 .077 L
.2256 .05848 L
.23509 .04118 L
.23636 .03885 L
.24707 .01923 L
.01923 .01923 L
F
0 g
.01923 .47976 m
.0312 .47057 L
.03449 .45094 L
.03701 .43132 L
.03885 .42046 L
.0407 .4117 L
.04592 .39207 L
.05848 .37532 L
.05966 .37245 L
.06844 .35283 L
.0781 .33425 L
.07841 .3332 L
.08758 .31358 L
.09772 .29533 L
.09833 .29396 L
.10825 .27433 L
.11735 .25771 L
.11884 .25471 L
.12919 .23509 L
.13697 .22089 L
.13981 .21546 L
.15041 .19584 L
.15659 .18459 L
.16109 .17622 L
.17181 .15659 L
.17622 .1486 L
.18254 .13697 L
.19332 .11735 L
.19584 .11277 L
.20406 .09772 L
.21486 .0781 L
.21546 .077 L
.2256 .05848 L
.23509 .04118 L
.23636 .03885 L
.24707 .01923 L
s
.8 1 0 r
.01923 .52024 m
.0312 .52943 L
.03449 .54906 L
.03701 .56868 L
.03885 .57954 L
.0407 .5883 L
.04592 .60793 L
.05848 .62468 L
.05966 .62755 L
.06844 .64717 L
.0781 .66575 L
.07841 .6668 L
.08758 .68642 L
.09772 .70467 L
.09833 .70604 L
.10825 .72567 L
.11735 .74229 L
.11884 .74529 L
.12919 .76491 L
.13697 .77911 L
.13981 .78454 L
.15041 .80416 L
.15659 .81541 L
.16109 .82378 L
.17181 .84341 L
.17622 .8514 L
.18254 .86303 L
.19332 .88265 L
.19584 .88723 L
.20406 .90228 L
.21486 .9219 L
.21546 .923 L
.2256 .94152 L
.23509 .95882 L
.23636 .96115 L
.24707 .98077 L
.01923 .98077 L
F
0 g
.01923 .52024 m
.0312 .52943 L
.03449 .54906 L
.03701 .56868 L
.03885 .57954 L
.0407 .5883 L
.04592 .60793 L
.05848 .62468 L
.05966 .62755 L
.06844 .64717 L
.0781 .66575 L
.07841 .6668 L
.08758 .68642 L
.09772 .70467 L
.09833 .70604 L
.10825 .72567 L
.11735 .74229 L
.11884 .74529 L
.12919 .76491 L
.13697 .77911 L
.13981 .78454 L
.15041 .80416 L
.15659 .81541 L
.16109 .82378 L
.17181 .84341 L
.17622 .8514 L
.18254 .86303 L
.19332 .88265 L
.19584 .88723 L
.20406 .90228 L
.21486 .9219 L
.21546 .923 L
.2256 .94152 L
.23509 .95882 L
.23636 .96115 L
.24707 .98077 L
s
1 0 .9 r
.01923 .47967 m
.03101 .47057 L
.03435 .45094 L
.03684 .43132 L
.03885 .41937 L
.04045 .4117 L
.04545 .39207 L
.05848 .37282 L
.05862 .37245 L
.06692 .35283 L
.07636 .3332 L
.0781 .33003 L
.08501 .31358 L
.09521 .29396 L
.09772 .28915 L
.1046 .27433 L
.11458 .25471 L
.11735 .24934 L
.12426 .23509 L
.13422 .21546 L
.13697 .2101 L
.14404 .19584 L
.154 .17622 L
.15659 .17113 L
.16387 .15659 L
.17381 .13697 L
.17622 .13224 L
.18368 .11735 L
.19358 .09772 L
.19584 .09325 L
.20341 .0781 L
.21324 .05848 L
.21546 .05403 L
.223 .03885 L
.23274 .01923 L
.01923 .01923 L
F
0 g
.01923 .47967 m
.03101 .47057 L
.03435 .45094 L
.03684 .43132 L
.03885 .41937 L
.04045 .4117 L
.04545 .39207 L
.05848 .37282 L
.05862 .37245 L
.06692 .35283 L
.07636 .3332 L
.0781 .33003 L
.08501 .31358 L
.09521 .29396 L
.09772 .28915 L
.1046 .27433 L
.11458 .25471 L
.11735 .24934 L
.12426 .23509 L
.13422 .21546 L
.13697 .2101 L
.14404 .19584 L
.154 .17622 L
.15659 .17113 L
.16387 .15659 L
.17381 .13697 L
.17622 .13224 L
.18368 .11735 L
.19358 .09772 L
.19584 .09325 L
.20341 .0781 L
.21324 .05848 L
.21546 .05403 L
.223 .03885 L
.23274 .01923 L
s
1 .9 0 r
.01923 .52033 m
.03101 .52943 L
.03435 .54906 L
.03684 .56868 L
.03885 .58063 L
.04045 .5883 L
.04545 .60793 L
.05848 .62718 L
.05862 .62755 L
.06692 .64717 L
.07636 .6668 L
.0781 .66997 L
.08501 .68642 L
.09521 .70604 L
.09772 .71085 L
.1046 .72567 L
.11458 .74529 L
.11735 .75066 L
.12426 .76491 L
.13422 .78454 L
.13697 .7899 L
.14404 .80416 L
.154 .82378 L
.15659 .82887 L
.16387 .84341 L
.17381 .86303 L
.17622 .86776 L
.18368 .88265 L
.19358 .90228 L
.19584 .90675 L
.20341 .9219 L
.21324 .94152 L
.21546 .94597 L
.223 .96115 L
.23274 .98077 L
.01923 .98077 L
F
0 g
.01923 .52033 m
.03101 .52943 L
.03435 .54906 L
.03684 .56868 L
.03885 .58063 L
.04045 .5883 L
.04545 .60793 L
.05848 .62718 L
.05862 .62755 L
.06692 .64717 L
.07636 .6668 L
.0781 .66997 L
.08501 .68642 L
.09521 .70604 L
.09772 .71085 L
.1046 .72567 L
.11458 .74529 L
.11735 .75066 L
.12426 .76491 L
.13422 .78454 L
.13697 .7899 L
.14404 .80416 L
.154 .82378 L
.15659 .82887 L
.16387 .84341 L
.17381 .86303 L
.17622 .86776 L
.18368 .88265 L
.19358 .90228 L
.19584 .90675 L
.20341 .9219 L
.21324 .94152 L
.21546 .94597 L
.223 .96115 L
.23274 .98077 L
s
1 0 .6 r
.01923 .47958 m
.03083 .47057 L
.03421 .45094 L
.03667 .43132 L
.03885 .41829 L
.0402 .4117 L
.04501 .39207 L
.05353 .37245 L
.05848 .37029 L
.06554 .35283 L
.07418 .3332 L
.0781 .32575 L
.08278 .31358 L
.09223 .29396 L
.09772 .28286 L
.10139 .27433 L
.1106 .25471 L
.11735 .24076 L
.1199 .23509 L
.12908 .21546 L
.13697 .19895 L
.1384 .19584 L
.14756 .17622 L
.15659 .15712 L
.15684 .15659 L
.16596 .13697 L
.17514 .11735 L
.17622 .11504 L
.18421 .09772 L
.19327 .0781 L
.19584 .07252 L
.20225 .05848 L
.21118 .03885 L
.21546 .02939 L
.22003 .01923 L
.01923 .01923 L
F
0 g
.01923 .47958 m
.03083 .47057 L
.03421 .45094 L
.03667 .43132 L
.03885 .41829 L
.0402 .4117 L
.04501 .39207 L
.05353 .37245 L
.05848 .37029 L
.06554 .35283 L
.07418 .3332 L
.0781 .32575 L
.08278 .31358 L
.09223 .29396 L
.09772 .28286 L
.10139 .27433 L
.1106 .25471 L
.11735 .24076 L
.1199 .23509 L
.12908 .21546 L
.13697 .19895 L
.1384 .19584 L
.14756 .17622 L
.15659 .15712 L
.15684 .15659 L
.16596 .13697 L
.17514 .11735 L
.17622 .11504 L
.18421 .09772 L
.19327 .0781 L
.19584 .07252 L
.20225 .05848 L
.21118 .03885 L
.21546 .02939 L
.22003 .01923 L
s
1 .6 0 r
.01923 .52042 m
.03083 .52943 L
.03421 .54906 L
.03667 .56868 L
.03885 .58171 L
.0402 .5883 L
.04501 .60793 L
.05353 .62755 L
.05848 .62971 L
.06554 .64717 L
.07418 .6668 L
.0781 .67425 L
.08278 .68642 L
.09223 .70604 L
.09772 .71714 L
.10139 .72567 L
.1106 .74529 L
.11735 .75924 L
.1199 .76491 L
.12908 .78454 L
.13697 .80105 L
.1384 .80416 L
.14756 .82378 L
.15659 .84288 L
.15684 .84341 L
.16596 .86303 L
.17514 .88265 L
.17622 .88496 L
.18421 .90228 L
.19327 .9219 L
.19584 .92748 L
.20225 .94152 L
.21118 .96115 L
.21546 .97061 L
.22003 .98077 L
.01923 .98077 L
F
0 g
.01923 .52042 m
.03083 .52943 L
.03421 .54906 L
.03667 .56868 L
.03885 .58171 L
.0402 .5883 L
.04501 .60793 L
.05353 .62755 L
.05848 .62971 L
.06554 .64717 L
.07418 .6668 L
.0781 .67425 L
.08278 .68642 L
.09223 .70604 L
.09772 .71714 L
.10139 .72567 L
.1106 .74529 L
.11735 .75924 L
.1199 .76491 L
.12908 .78454 L
.13697 .80105 L
.1384 .80416 L
.14756 .82378 L
.15659 .84288 L
.15684 .84341 L
.16596 .86303 L
.17514 .88265 L
.17622 .88496 L
.18421 .90228 L
.19327 .9219 L
.19584 .92748 L
.20225 .94152 L
.21118 .96115 L
.21546 .97061 L
.22003 .98077 L
s
1 0 .3 r
.01923 .47948 m
.03065 .47057 L
.03407 .45094 L
.0365 .43132 L
.03885 .41721 L
.03997 .4117 L
.0446 .39207 L
.05193 .37245 L
.05848 .36774 L
.06426 .35283 L
.07218 .3332 L
.0781 .32142 L
.08086 .31358 L
.08953 .29396 L
.09772 .27643 L
.09856 .27433 L
.10701 .25471 L
.11591 .23509 L
.11735 .23192 L
.12446 .21546 L
.13319 .19584 L
.13697 .18736 L
.14179 .17622 L
.15037 .15659 L
.15659 .1424 L
.15892 .13697 L
.16737 .11735 L
.17581 .09772 L
.17622 .09677 L
.18412 .0781 L
.19239 .05848 L
.19584 .05024 L
.20056 .03885 L
.20864 .01923 L
.01923 .01923 L
F
0 g
.01923 .47948 m
.03065 .47057 L
.03407 .45094 L
.0365 .43132 L
.03885 .41721 L
.03997 .4117 L
.0446 .39207 L
.05193 .37245 L
.05848 .36774 L
.06426 .35283 L
.07218 .3332 L
.0781 .32142 L
.08086 .31358 L
.08953 .29396 L
.09772 .27643 L
.09856 .27433 L
.10701 .25471 L
.11591 .23509 L
.11735 .23192 L
.12446 .21546 L
.13319 .19584 L
.13697 .18736 L
.14179 .17622 L
.15037 .15659 L
.15659 .1424 L
.15892 .13697 L
.16737 .11735 L
.17581 .09772 L
.17622 .09677 L
.18412 .0781 L
.19239 .05848 L
.19584 .05024 L
.20056 .03885 L
.20864 .01923 L
s
1 .3 0 r
.01923 .52052 m
.03065 .52943 L
.03407 .54906 L
.0365 .56868 L
.03885 .58279 L
.03997 .5883 L
.0446 .60793 L
.05193 .62755 L
.05848 .63226 L
.06426 .64717 L
.07218 .6668 L
.0781 .67858 L
.08086 .68642 L
.08953 .70604 L
.09772 .72357 L
.09856 .72567 L
.10701 .74529 L
.11591 .76491 L
.11735 .76808 L
.12446 .78454 L
.13319 .80416 L
.13697 .81264 L
.14179 .82378 L
.15037 .84341 L
.15659 .8576 L
.15892 .86303 L
.16737 .88265 L
.17581 .90228 L
.17622 .90323 L
.18412 .9219 L
.19239 .94152 L
.19584 .94976 L
.20056 .96115 L
.20864 .98077 L
.01923 .98077 L
F
0 g
.01923 .52052 m
.03065 .52943 L
.03407 .54906 L
.0365 .56868 L
.03885 .58279 L
.03997 .5883 L
.0446 .60793 L
.05193 .62755 L
.05848 .63226 L
.06426 .64717 L
.07218 .6668 L
.0781 .67858 L
.08086 .68642 L
.08953 .70604 L
.09772 .72357 L
.09856 .72567 L
.10701 .74529 L
.11591 .76491 L
.11735 .76808 L
.12446 .78454 L
.13319 .80416 L
.13697 .81264 L
.14179 .82378 L
.15037 .84341 L
.15659 .8576 L
.15892 .86303 L
.16737 .88265 L
.17581 .90228 L
.17622 .90323 L
.18412 .9219 L
.19239 .94152 L
.19584 .94976 L
.20056 .96115 L
.20864 .98077 L
s
1 0 0 r
.01923 .47939 m
.03047 .47057 L
.03393 .45094 L
.03634 .43132 L
.03885 .41613 L
.03974 .4117 L
.04422 .39207 L
.0508 .37245 L
.05848 .36516 L
.06308 .35283 L
.07033 .3332 L
.0781 .31701 L
.07921 .31358 L
.08708 .29396 L
.09575 .27433 L
.09772 .26985 L
.10378 .25471 L
.11209 .23509 L
.11735 .22276 L
.12029 .21546 L
.12839 .19584 L
.13655 .17622 L
.13697 .17521 L
.1445 .15659 L
.15248 .13697 L
.15659 .1268 L
.16034 .11735 L
.16812 .09772 L
.17584 .0781 L
.17622 .07714 L
.18342 .05848 L
.19093 .03885 L
.19584 .0259 L
.19834 .01923 L
.01923 .01923 L
F
0 g
.01923 .47939 m
.03047 .47057 L
.03393 .45094 L
.03634 .43132 L
.03885 .41613 L
.03974 .4117 L
.04422 .39207 L
.0508 .37245 L
.05848 .36516 L
.06308 .35283 L
.07033 .3332 L
.0781 .31701 L
.07921 .31358 L
.08708 .29396 L
.09575 .27433 L
.09772 .26985 L
.10378 .25471 L
.11209 .23509 L
.11735 .22276 L
.12029 .21546 L
.12839 .19584 L
.13655 .17622 L
.13697 .17521 L
.1445 .15659 L
.15248 .13697 L
.15659 .1268 L
.16034 .11735 L
.16812 .09772 L
.17584 .0781 L
.17622 .07714 L
.18342 .05848 L
.19093 .03885 L
.19584 .0259 L
.19834 .01923 L
s
1 0 0 r
.01923 .52061 m
.03047 .52943 L
.03393 .54906 L
.03634 .56868 L
.03885 .58387 L
.03974 .5883 L
.04422 .60793 L
.0508 .62755 L
.05848 .63484 L
.06308 .64717 L
.07033 .6668 L
.0781 .68299 L
.07921 .68642 L
.08708 .70604 L
.09575 .72567 L
.09772 .73015 L
.10378 .74529 L
.11209 .76491 L
.11735 .77724 L
.12029 .78454 L
.12839 .80416 L
.13655 .82378 L
.13697 .82479 L
.1445 .84341 L
.15248 .86303 L
.15659 .8732 L
.16034 .88265 L
.16812 .90228 L
.17584 .9219 L
.17622 .92286 L
.18342 .94152 L
.19093 .96115 L
.19584 .9741 L
.19834 .98077 L
.01923 .98077 L
F
0 g
.01923 .52061 m
.03047 .52943 L
.03393 .54906 L
.03634 .56868 L
.03885 .58387 L
.03974 .5883 L
.04422 .60793 L
.0508 .62755 L
.05848 .63484 L
.06308 .64717 L
.07033 .6668 L
.0781 .68299 L
.07921 .68642 L
.08708 .70604 L
.09575 .72567 L
.09772 .73015 L
.10378 .74529 L
.11209 .76491 L
.11735 .77724 L
.12029 .78454 L
.12839 .80416 L
.13655 .82378 L
.13697 .82479 L
.1445 .84341 L
.15248 .86303 L
.15659 .8732 L
.16034 .88265 L
.16812 .90228 L
.17584 .9219 L
.17622 .92286 L
.18342 .94152 L
.19093 .96115 L
.19584 .9741 L
.19834 .98077 L
s
.8 1 0 r
.01923 .49943 m
.03885 .49459 L
.04231 .49019 L
.05848 .4879 L
.0781 .47836 L
.0921 .47057 L
.09772 .46789 L
.11735 .45559 L
.12386 .45094 L
.13697 .44193 L
.1493 .43132 L
.15659 .42584 L
.16954 .4117 L
.17622 .40713 L
.18469 .39207 L
.194 .37245 L
.19461 .35283 L
.17622 .3378 L
.15659 .33684 L
.13697 .34248 L
.11735 .35209 L
.11593 .35283 L
.09772 .36485 L
.08757 .37245 L
.0781 .38166 L
.06631 .39207 L
.05848 .40343 L
.04431 .4117 L
.03917 .43132 L
.03885 .43297 L
.03622 .45094 L
.03355 .47057 L
.01923 .48078 L
F
0 g
.01923 .49943 m
.03885 .49459 L
.04231 .49019 L
.05848 .4879 L
.0781 .47836 L
.0921 .47057 L
.09772 .46789 L
.11735 .45559 L
.12386 .45094 L
.13697 .44193 L
.1493 .43132 L
.15659 .42584 L
.16954 .4117 L
.17622 .40713 L
.18469 .39207 L
.194 .37245 L
.19461 .35283 L
.17622 .3378 L
.15659 .33684 L
.13697 .34248 L
.11735 .35209 L
.11593 .35283 L
.09772 .36485 L
.08757 .37245 L
.0781 .38166 L
.06631 .39207 L
.05848 .40343 L
.04431 .4117 L
.03917 .43132 L
.03885 .43297 L
.03622 .45094 L
.03355 .47057 L
.01923 .48078 L
s
.8 0 1 r
.01923 .51922 m
.03355 .52943 L
.03622 .54906 L
.03885 .56703 L
.03917 .56868 L
.04431 .5883 L
.05848 .59657 L
.06631 .60793 L
.0781 .61834 L
.08757 .62755 L
.09772 .63515 L
.11593 .64717 L
.11735 .64791 L
.13697 .65752 L
.15659 .66316 L
.17622 .6622 L
.19461 .64717 L
.194 .62755 L
.18469 .60793 L
.17622 .59287 L
.16954 .5883 L
.15659 .57416 L
.1493 .56868 L
.13697 .55807 L
.12386 .54906 L
.11735 .54441 L
.09772 .53211 L
.0921 .52943 L
.0781 .52164 L
.05848 .5121 L
.04231 .50981 L
.03885 .50541 L
.01923 .50057 L
F
0 g
.01923 .51922 m
.03355 .52943 L
.03622 .54906 L
.03885 .56703 L
.03917 .56868 L
.04431 .5883 L
.05848 .59657 L
.06631 .60793 L
.0781 .61834 L
.08757 .62755 L
.09772 .63515 L
.11593 .64717 L
.11735 .64791 L
.13697 .65752 L
.15659 .66316 L
.17622 .6622 L
.19461 .64717 L
.194 .62755 L
.18469 .60793 L
.17622 .59287 L
.16954 .5883 L
.15659 .57416 L
.1493 .56868 L
.13697 .55807 L
.12386 .54906 L
.11735 .54441 L
.09772 .53211 L
.0921 .52943 L
.0781 .52164 L
.05848 .5121 L
.04231 .50981 L
.03885 .50541 L
.01923 .50057 L
s
1 0 .9 r
.01923 .51912 m
.0338 .52943 L
.0364 .54906 L
.03885 .56585 L
.0394 .56868 L
.04478 .5883 L
.05848 .59363 L
.06974 .60793 L
.0781 .61315 L
.09772 .62702 L
.09887 .62755 L
.11735 .63618 L
.13697 .6408 L
.15502 .62755 L
.15456 .60793 L
.14546 .5883 L
.13697 .57651 L
.13021 .56868 L
.11735 .55439 L
.10942 .54906 L
.09772 .53907 L
.08241 .52943 L
.0781 .52638 L
.05848 .51414 L
.04126 .50981 L
.03885 .50647 L
.01923 .50067 L
F
0 g
.01923 .51912 m
.0338 .52943 L
.0364 .54906 L
.03885 .56585 L
.0394 .56868 L
.04478 .5883 L
.05848 .59363 L
.06974 .60793 L
.0781 .61315 L
.09772 .62702 L
.09887 .62755 L
.11735 .63618 L
.13697 .6408 L
.15502 .62755 L
.15456 .60793 L
.14546 .5883 L
.13697 .57651 L
.13021 .56868 L
.11735 .55439 L
.10942 .54906 L
.09772 .53907 L
.08241 .52943 L
.0781 .52638 L
.05848 .51414 L
.04126 .50981 L
.03885 .50647 L
.01923 .50067 L
s
1 .9 0 r
.01923 .49933 m
.03885 .49353 L
.04126 .49019 L
.05848 .48586 L
.0781 .47362 L
.08241 .47057 L
.09772 .46093 L
.10942 .45094 L
.11735 .44561 L
.13021 .43132 L
.13697 .42349 L
.14546 .4117 L
.15456 .39207 L
.15502 .37245 L
.13697 .3592 L
.11735 .36382 L
.09887 .37245 L
.09772 .37298 L
.0781 .38685 L
.06974 .39207 L
.05848 .40637 L
.04478 .4117 L
.0394 .43132 L
.03885 .43415 L
.0364 .45094 L
.0338 .47057 L
.01923 .48088 L
F
0 g
.01923 .49933 m
.03885 .49353 L
.04126 .49019 L
.05848 .48586 L
.0781 .47362 L
.08241 .47057 L
.09772 .46093 L
.10942 .45094 L
.11735 .44561 L
.13021 .43132 L
.13697 .42349 L
.14546 .4117 L
.15456 .39207 L
.15502 .37245 L
.13697 .3592 L
.11735 .36382 L
.09887 .37245 L
.09772 .37298 L
.0781 .38685 L
.06974 .39207 L
.05848 .40637 L
.04478 .4117 L
.0394 .43132 L
.03885 .43415 L
.0364 .45094 L
.0338 .47057 L
.01923 .48088 L
s
1 0 .6 r
.01923 .51903 m
.03405 .52943 L
.03658 .54906 L
.03885 .56465 L
.03964 .56868 L
.04529 .5883 L
.05848 .59051 L
.0781 .60771 L
.07873 .60793 L
.09772 .61882 L
.11735 .61873 L
.12909 .60793 L
.12615 .5883 L
.11735 .57158 L
.11534 .56868 L
.09841 .54906 L
.09772 .54829 L
.0781 .53002 L
.0751 .52943 L
.05848 .5165 L
.04035 .50981 L
.03885 .50757 L
.01923 .50078 L
F
0 g
.01923 .51903 m
.03405 .52943 L
.03658 .54906 L
.03885 .56465 L
.03964 .56868 L
.04529 .5883 L
.05848 .59051 L
.0781 .60771 L
.07873 .60793 L
.09772 .61882 L
.11735 .61873 L
.12909 .60793 L
.12615 .5883 L
.11735 .57158 L
.11534 .56868 L
.09841 .54906 L
.09772 .54829 L
.0781 .53002 L
.0751 .52943 L
.05848 .5165 L
.04035 .50981 L
.03885 .50757 L
.01923 .50078 L
s
1 .6 0 r
.01923 .49922 m
.03885 .49243 L
.04035 .49019 L
.05848 .4835 L
.0751 .47057 L
.0781 .46998 L
.09772 .45171 L
.09841 .45094 L
.11534 .43132 L
.11735 .42842 L
.12615 .4117 L
.12909 .39207 L
.11735 .38127 L
.09772 .38118 L
.07873 .39207 L
.0781 .39229 L
.05848 .40949 L
.04529 .4117 L
.03964 .43132 L
.03885 .43535 L
.03658 .45094 L
.03405 .47057 L
.01923 .48097 L
F
0 g
.01923 .49922 m
.03885 .49243 L
.04035 .49019 L
.05848 .4835 L
.0751 .47057 L
.0781 .46998 L
.09772 .45171 L
.09841 .45094 L
.11534 .43132 L
.11735 .42842 L
.12615 .4117 L
.12909 .39207 L
.11735 .38127 L
.09772 .38118 L
.07873 .39207 L
.0781 .39229 L
.05848 .40949 L
.04529 .4117 L
.03964 .43132 L
.03885 .43535 L
.03658 .45094 L
.03405 .47057 L
.01923 .48097 L
s
1 0 .3 r
.01923 .51893 m
.03431 .52943 L
.03677 .54906 L
.03885 .56343 L
.03989 .56868 L
.05848 .58725 L
.05922 .5883 L
.0781 .60405 L
.09772 .60531 L
.10995 .5883 L
.10317 .56868 L
.09772 .55974 L
.08937 .54906 L
.0781 .53337 L
.06883 .52943 L
.05848 .5193 L
.03953 .50981 L
.03885 .50871 L
.01923 .50088 L
F
0 g
.01923 .51893 m
.03431 .52943 L
.03677 .54906 L
.03885 .56343 L
.03989 .56868 L
.05848 .58725 L
.05922 .5883 L
.0781 .60405 L
.09772 .60531 L
.10995 .5883 L
.10317 .56868 L
.09772 .55974 L
.08937 .54906 L
.0781 .53337 L
.06883 .52943 L
.05848 .5193 L
.03953 .50981 L
.03885 .50871 L
.01923 .50088 L
s
1 .3 0 r
.01923 .49912 m
.03885 .49129 L
.03953 .49019 L
.05848 .4807 L
.06883 .47057 L
.0781 .46663 L
.08937 .45094 L
.09772 .44026 L
.10317 .43132 L
.10995 .4117 L
.09772 .39469 L
.0781 .39595 L
.05922 .4117 L
.05848 .41275 L
.03989 .43132 L
.03885 .43657 L
.03677 .45094 L
.03431 .47057 L
.01923 .48107 L
F
0 g
.01923 .49912 m
.03885 .49129 L
.03953 .49019 L
.05848 .4807 L
.06883 .47057 L
.0781 .46663 L
.08937 .45094 L
.09772 .44026 L
.10317 .43132 L
.10995 .4117 L
.09772 .39469 L
.0781 .39595 L
.05922 .4117 L
.05848 .41275 L
.03989 .43132 L
.03885 .43657 L
.03677 .45094 L
.03431 .47057 L
.01923 .48107 L
s
1 0 0 r
.01923 .51884 m
.03458 .52943 L
.03696 .54906 L
.03885 .56218 L
.04014 .56868 L
.05848 .58392 L
.06202 .5883 L
.0781 .59643 L
.09428 .5883 L
.09306 .56868 L
.08206 .54906 L
.0781 .541 L
.06396 .52943 L
.05848 .52264 L
.03885 .50991 L
.0388 .50981 L
.01923 .50098 L
F
0 g
.01923 .51884 m
.03458 .52943 L
.03696 .54906 L
.03885 .56218 L
.04014 .56868 L
.05848 .58392 L
.06202 .5883 L
.0781 .59643 L
.09428 .5883 L
.09306 .56868 L
.08206 .54906 L
.0781 .541 L
.06396 .52943 L
.05848 .52264 L
.03885 .50991 L
.0388 .50981 L
.01923 .50098 L
s
1 0 0 r
.01923 .49902 m
.0388 .49019 L
.01923 .48116 L
F
0 g
.01923 .49902 m
.0388 .49019 L
.01923 .48116 L
s
1 0 0 r
.0781 .40357 m
.09428 .4117 L
.09306 .43132 L
.08206 .45094 L
.0781 .459 L
.06396 .47057 L
.05848 .47736 L
.03885 .49009 L
.03458 .47057 L
.03696 .45094 L
.03885 .43782 L
.04014 .43132 L
.05848 .41608 L
.06202 .4117 L
F
0 g
.0781 .40357 m
.09428 .4117 L
.09306 .43132 L
.08206 .45094 L
.0781 .459 L
.06396 .47057 L
.05848 .47736 L
.03885 .49009 L
.03458 .47057 L
.03696 .45094 L
.03885 .43782 L
.04014 .43132 L
.05848 .41608 L
.06202 .4117 L
.0781 .40357 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{Inherited, Inherited}, {Inherited, 0}},
  ImageSize->{217, 216.875},
  ImageMargins->{{71.3125, 0}, {0, 7.5}},
  ImageRegion->{{0, 1}, {-0.000798, 1.00798}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003I0000f1000`40O003h00O47oo0P005Woo0P00
17oo0P0017oo0P005Goo1@004goo1@000Woo0P0017oo0P005Goo100057oo10000goo0P0017oo0P00
5Woo0P004goo000?Ool01000Oomoo`0057oo00@007ooOol000Qoo`04001oogoo000FOol00`00Oomo
o`0EOol00`00Oomoo`07Ool01000Oomoo`0057oo00<007ooOol05Goo00<007ooOol02Goo00@007oo
Ool001Aoo`04001oogoo000BOol000moo`04001oogoo000DOol01000Oomoo`002goo00<007ooOol0
57oo00<007ooOol05Goo00<007ooOol02Woo00<007ooOol04goo00<007ooOol05Goo00<007ooOol0
2goo00<007ooOol057oo00<007ooOol04Goo000?Ool01000Oomoo`0057oo00@007ooOol000Uoo`80
01Moo`03001oogoo01Eoo`03001oogoo00Qoo`8001Moo`03001oogoo01Eoo`03001oogoo00Qoo`80
01Qoo`03001oogoo011oo`003goo00@007ooOol001Aoo`04001oogoo0009Ool00`00Oomoo`0FOol0
0`00Oomoo`0EOol00`00Oomoo`08Ool00`00Oomoo`0DOol01000Oomoo`0057oo00@007ooOol000Uo
o`03001oogoo01Aoo`04001oogoo000BOol0011oo`8001Ioo`8000Yoo`<001Eoo`8001Ioo`8000Yo
o`<001Eoo`8001Ioo`8000Yoo`<001Eoo`8001=oo`00fGoo003IOol00=Uoo`00cgoo0P0000=oo`00
00001Goo003@Ool00`00Ool00006Ool000iook`000Moo`03001oogoo00Eoo`0027oo0P0017oo00@0
07ooOol000Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`05
001oogooOol00005Ool200000goo00000005Ool000Moo`04001oogoo0003Ool00`00Oomoo`2hOol0
0`00Oomoo`0=Ool000Uoo`03001oogoo009oo`8002=oo`07001oo`00Ool007oo00000Woo00@007oo
Ool000=oo`05001oogooOol00005Ool00`00Oomoo`04Ool00`00Oomoo`08Ool00`00Oomoo`0DOol0
0`00Oomoo`1?Ool2000?Ool00003Ool00000008000Eoo`05001oogooOol00003OolQO00200001g`B
001l6g`L001T7`0000<l7`0F000H7a@O0000G`1o05l0005o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o
000:0ol05@000oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@020000C`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo00eoo`001goo00@007oo
Ool000=oo`04001oogooOolQO00200001g`B001l7000I1mP7`00008l7`05000H7a@O51l0000305l0
0`000Il1W`020Il01@000[l2_`:o0]l00`:o00<000?o0ol01`?o0P0000D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD00`?f0oD3m@02001A0n`4Ool00`00Oomoo`0=Ool000Qoo`8000Aoo`04001o
ogooOolPO00200001g`B001l77`K001P7`00008l7`06>1l001@O61l0001o0P1O00`0006O0Gl1W`5o
0002_`;O0[l2g`:o0]l200080ol200004`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0080001C0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k004Ool0
0`00Oomoo`0=Ool000ioo`04001oogooOolPO00200001g`B001l77`L001T7`00008l7`04000D7a@O
000305l00`000Il1W`020Il01@000[l2_`:o0]l00P:o00<000?o0ol01`?o00@000?e0oD3mP<3m@05
0oH3m@?e0oD3mP030oD010?f0oD3m@?e0`00E@?/17oo00<007ooOol03Goo000>Ool01000Oomoogoo
7g`0010007`9001l4`00O1`006@OH1l003PO000D7aPO0000O`80G`0=0001W`5o0Il1O`6O0002g`:o
0]l2_`;O000020?o0P000143mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0080001H0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`4Ool00`00
Oomoo`0=Ool000ioo`80009ooaml0004001l20000002O1`00`00H1l00002?1l0100051lD7`000`1O
00<0006O0Il00P6O00@000:o0[l2g`82_`030003o`?o00H3o`050003m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00@3mP?e0oD005X3k0=oo`8000moo`003Woo00@007ooOomooail000?001l2000O180
07`K001P7f@O000l7`0061lD7`0000<0G`0<0001O`6O0Gl1W`000]l2_`;O0[l2g`0020?o018000?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD20000F`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo00eoo`003Woo
00@007ooOomooail0009001l2@00O18007`L001T7`00008l7`04000D7aPO000205l200030Il01000
0[l2_`;O0P:o00<000?o0ol01P?o00D000?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD3001M0n`4
Ool00`00Oomoo`0=Ool000ioo`04001oogooOolNO00200001W`B001l7000I1l0008l7`04000D7aPO
000205l030000Gl1W`5o0Il000;O0[l2g`:o0]l000P3o`0>0003m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@<0001P0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/17oo00<007ooOol03Goo000>Ool01000Oomoogoo7G`000h007`8
001l4P00O1`0060O000l7`0051lH7`000`1O00D0006O0Il1W`000082_`040]l2_`:o00070ol20003
0oD01@?f0oD3m@?e0oH00`?e00<3mP000000H`?/17oo00<007ooOol03Goo000>Ool01000Oomoogoo
7G`00P0000Il4P00O1/0060O0002?1l00`0061l0000205l02P1o0001W`5o0Il000;O0[l2g`:o0P00
1P?o0P0000`3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD20000I@?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0
17oo00<007ooOol03Goo000>Ool20002OolLO0001000O0T000000W`L0P000S`O00@001PO51l00080
G`050001W`6O0Il000020[l00`;O0[l000080ol00`000oH3m@020oD01@?f0oD3m@?e0oH00P?e0P00
I`?/0goo0P003goo000>Ool01000Oomoogoo77`00P0001Ml4`00O1`006@O000l7`0061lD7`0005l0
O`1O0001O`6O0002g`:o0]l2_`0000P3o`1f0003mP?e0oH3m@?f0oD3mP?e0oH3m@?f0003k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolKO0001000
O0P000000W`L0P000S`O00@001@O51l00080G`040001W`6O00020[l010;O0[l2_`001P?o0P0000D3
mP?e0oD3m@?f00<3m@040oH3m@00001Z0n`4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolKO000
6@00O0T00000O1/0060O000h7`0051lH7`0007l0G`000Gl1W`5o0002_`;O0[l2g`0000H3o`0;0003
m@?f0oD3mP?e0oH3m@?f0oD3mP020000K0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0Aoo`03001oogoo00eoo`003Woo00@007ooOomooa]l00800005O1800000H1mT7`02000251l01000
05l0G`000`6O00<000:o0]l00P:o00<000?o0ol010?o00<000?e0oH00`?e00H3mP?e0oD3m@?f001^
0n`4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolJO0003@00O0P00000O1`006@O000l7`0061l0
001o0080G`090001W`5o0Il000;O0[l2g`0000H3o`1k0003m@?f0oD3mP?e0oH3m@?f0oD3mP000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo00eoo`003Woo
0P000Woo6W`00P0000El4P00001T7f0O0080008D7`040000G`1O00030Il01@000]l2_`:o00001P?o
00<000?e0oH00`?e00@3mP?e0oD3m@800703k0=oo`8000moo`003Woo00@007ooOomooaYl00800009
O1<00000H1l003`O000D7`000080G`090001W`5o0Il000;O0[l2g`0000D3o`8000080oD3mP?e0oH3
m@?f0oD3mP80001b0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
17oo00<007ooOol03Goo000>Ool01000Oomoogoo6G`000D007`8000007`L00800004?1l001@O0002
05l01P000Il1W`6O0002g`82_`030003o`?o00<3o`040003m@?e0oH30oD010?f0oD3m@00M0?/17oo
00<007ooOol03Goo000>Ool01000Oomoogoo6G`00P0000Ul4P00001T7`00?1l001PO00000P1O00P0
005o0Il000;O0[l2g`001@?o00T000?f0oD3mP?e0oH3m@?f0oD00P0007D3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol03Goo000>Ool0
1000Oomoogoo67`000<007`90000100000@l7`0061l00080G`050001W`6O0002g`020[l00`000ol3
o`020ol200020oD01@?f0oD3m@?e0oH00P00M`?/17oo00<007ooOol03Goo000>Ool01000Oomoogoo
67`00`0000=l6`00H1l00P0000`H7a@O0000G`000Gl1W`000]l2_`;O00040ol020000oD3mP?e0oH3
m@?f0oD200007@?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`02P000583j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0Ao
o`03001oogoo00eoo`003Woo0P000Woo5g`000<007`800000P0000QP7`00?1l001@O0000G`000P6O
00D000;O0[l2_`0000@3o`050003m@?e0oD3mP030oD00`000n`3k00E0n`8000:0n83001?0n`3Ool2
000?Ool000ioo`04001oogooOolGO00300000g`L001T7`0200002a@O61l0001o0001W`5o0002_`;O
000010?o00L000?e0oH3m@?f0oD3mP0200005@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`0300030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP030n<3hP000080
001<0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`4Ool00`00Oomoo`0=Ool000ioo`04001o
ogooOolGO00300002G`L000003`O000D7`0005l000020Il010000[l2_`0010?o00D000?e0oD3m@?f
0083m@030003k0?/0103k0D001/3hP8004X3k0Aoo`03001oogoo00eoo`003Woo00@007ooOomooaMl
0003001l4`000080000<?1l001PO0000O`000Il1O`000[l2g`0010?o01P000?e0oH3m@?f0oD3mP00
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/300000`?R0n<3hP020n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00P0004P3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`4Ool00`00Oomoo`0=Ool000Moo`@000=oo`04001oogooOolFO0030000
17`L000003`O0P000P1O00<0006O00000P:o00<000?o0ol00P?o00H000?e0oD3m@?f0oD2000>0n`3
000W0n800`000n`3k0150n`4Ool00`00Oomoo`0=Ool000Moo`03001oogoo00Aoo`04001oogooOolF
O0000`00O1800002000033`O000D7`0005l0005o0Il000;O0[l000<3o`050003m@?f0oD3mP020000
3@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00<000030n83h`?R0083hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80C@?S0n83hP?R0n<0
00?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol03Goo0008Ool00`00Oomoo`03Ool20002
OolEO00200001G`B00000000?1l00P0000H0G`000Il1W`000[l200030ol01`000oD3m@?e0oH3m@00
00X3k0@002h3hP030003k0?/04@3k0=oo`8000moo`0000=oo`0000000P0017oo00<007ooOol00Woo
00@007ooOomooaEl00D0000:?1l0000005l0005o0Il000;O00040ol01@000oD3mP?e0oH00P0000T3
j`?/0n/3k0?[0n`3j`?/0n/00P000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
04L000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo00eoo`001goo00@007ooOol000=oo`04
001oogooOolDO0000`00O0T0000200002S`O000H7`0005l0006O0002_`000`?o0P000`?e00<3mP00
0n`020?/0P00=0?R00<000?/0n`0A0?/17oo00<007ooOol03Goo0008Ool20004Ool01000Oomoogoo
57`01P0000PH7`0005l0006O0002g`000`?o00D000?f0oD3mP?e008000070n`3j`?/0n/3k0?[0n`0
0`0000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R04d3h`?R0n83hP?S0n8000?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo00eoo`003Woo00@007ooOomooa=l00800004O1800000
?1l20000101O0001W`000P:o00D000?o0ol000?f00<3m@030003k0?/00L3k0030003hP?R03H3hP03
0003k0?/04@3k0Aoo`03001oogoo00eoo`003Woo00@007ooOomooa=l00H0000851l000000Il1O`00
0[l00083o`0>0003mP?e0oH3m@000n/3k0?[0n`3j`?/0n/3k08000030n83h`?R0083hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP1;0n<3hP?R0n8000?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
00Aoo`03001oogoo00eoo`003Woo0P000Woo4W`00P0000Al4P00000l7`80000605l0006O0002_`00
0P?o00@000?f0oD3m@8000H3k0<003/3hP030003k0?/04@3k0=oo`8000moo`003Woo00@007ooOomo
oa9l00H0000761l000000Gl000:o00000P?o00/000?f0oD3mP000n`3j`?/0n/3k0?[008000050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80C@?S0n83hP?R0n<3
hP000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol03Goo000>Ool01000Oomoogoo4W`00`00
00=T7`0000000P0000@1W`000[l000<3o`040003m@?e00070n`00`000n83hP0l0n800`000n`3k015
0n`4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolBO00600001P1o000000:o0]l00083o`0:0003
m@?f0003k0?[0n`3j`?/0n/200001@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S0083hP180003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/17oo00<0
07ooOol03Goo000>Ool01000Oomoogoo4G`00`0000=P7`000000100000D2g`000ol3o`000083m@03
0003k0?/00<3k0800403hP030003k0?/04H3k0Aoo`03001oogoo00eoo`003Woo00@007ooOomooa5l
00H0000605l000000]l000?o0P0000L3m@?f0003k0?[0n`3j`0200020n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP180003j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0P000goo00<007ooOol03Goo000>Ool20002Ool@O00500002APO0000
00000]l000?o0003mP020oD010000n`3k0?/0P0030?R1`00<0?R00<000?/0n`0@`?/0`0000@3mGoo
Oomoo`8000moo`003Woo00@007ooOomooa1l00H0000805l000000003o`000oH3m@8000050n`3j`00
0003h`030n801P?S0n83hP?R0n<3hP@000076n0Gh1_P5n0Kh1OP6n000`0000D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n80B@?S0n83hP?R0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/008000040oD3mP?e0oH4Ool00`00Oomoo`0=
Ool000ioo`04001oogooOol?O00:00001@?o0003mP?e00000`?/00<000?R0n801P?R100000<Gh1_P
5n000QOP00DKh1OP5n0Gh1_P00<Gh0036n000000008002L3hP030003k0?/0443k0800083m@040oH3
m@?e0oD4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol?O00600003P5o000000?o0003mP?e0003
j`?/0n/3k0000n<30n807@?S0n8000006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0000?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP130003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P0000P3m@?f0oD3mP?e0oH3m@?f
17oo00<007ooOol03Goo000>Ool01000Oomoogoo3W`01`0000L1W`00000000?f0oD000030n`20005
0n8200000aOP6n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh1OP000T
0n800`000n`3k00o0n`200001@?f0oD3m@?e0oH00`?e00<3mP?eOol00goo00<007ooOol03Goo000>
Ool01000Oomoogoo3W`01P0000T1W`000003o`000oD000?[0n`00P0000@3hP?S0n83hP<0000L6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P00020n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
0403h`000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`<0000<0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f17oo00<007ooOol03Goo000>Ool2
0002Ool>O00:00001@?e0003k0?/000010?R0P0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000aOP00LKh1OP5n0Gh1_P5n00000R0n800`000n`3k00k0n`200030oD01@?f
0oD3m@?e0oH00`?e00@3mP?e0oD3m@=oo`8000moo`003Woo00@007ooOomoo`el00P000050ol000?e
0003j`0200020n809@?S0n83hP006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP040n<3hP?R0n820000?0?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`80000A0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP04Ool00`00Oomoo`0=Ool000ioo`04001oogooOol=O0050000106O0003o`?o
0P0000<3k0000n8010?R0P0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0030003hP?R01d3hP030003k0?/03T3k0<000030oD3mP?e0083
m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3m@Aoo`03001oogoo00eoo`003Woo00@007ooOomo
o`al00P000030ol000?f008000<3hP0V0n<000005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n000083hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP0o0n<3hP?R0n8000?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080000F0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol<
O00700001P?o000000000n`00083hP80008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000a_P5n00000M0n800`000n`3k00f0n`30000
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD4Ool00`00Oomoo`0=
Ool000ioo`04001oogooOol<O00600001`?o000000?[0n`000?R008000065n0Kh1OP6n0Gh1_P2000
01XGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP0003hP?S0`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R03L000?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00300006`?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP04Ool00`00Oomoo`0=Ool000ioo`80
009oo`]l00T000030n`00000008000066n0Gh1OP5n0Kh1OP0P0023oP0P000QOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n0011_P5n0Gh0006`?R0P00=0?/0`0000D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00H3mP?e0oD3m@?f0oD3Ool2000?Ool000ioo`04
001oogooOol;O00:00001P?R000Gh1_P5n0Kh0@00005>n0oh3oP?n0kh003?n006S_P?n0oh3oP000K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n<30n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`020n80=@000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/00P000243mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH017oo00<007ooOol03Goo000>Ool01000Oomo
ogoo2g`01P0000<3m@000n800P?R00<001_P5n000P004CoP00@001OP5n0Kh0<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP00006@?R0P00<P?/0`000`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@Aoo`03001oogoo00eoo`003Woo00@0
07ooOomoo`Yl00@000030]l000?f00800083hP05000Kh000000kh003?n001C_P?n0oh3oP>n000coP
00Dkh3oP?n0oh3_P008oh00C000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP00000`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80>0?S0n83hP?R0n<3hP000n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/300009P?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH4Ool00`00Oomoo`0=
Ool000Moo`D0009oo`04001oogooOol:O00800001@?R000001_P00005CoP00<001_P5n000QOP00DK
h1OP5n0Gh1_P00<Gh0066n0Gh1OP5n0Kh0005`?R0P00;`?/0`000`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@060oH3m@?e0oD3mP?e
17oo00<007ooOol03Goo0009Ool00`00Oomoo`02Ool01000Oomoogoo2G`0200000<3hP005n000P00
00<oh3_P?n000SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n004c_P000Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
03D3h`?R0n83hP?S0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080000/0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mPAoo`03001oogoo00eoo`002Goo00<007ooOol00Woo0P000Woo
2G`01`0000@3hP005n0000@oh0H000hoh004000Gh1OP6n035n001A_P5n0Gh1OP6n000aOP00<Kh000
0n805P?R00<000?/0n`0:`?/0`000P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD010?f0oD3m@?e0goo0P00
3goo00000goo000000020004Ool00`00Oomoo`02Ool01000Oomoogoo27`02@0000DGh000?n0oh3_P
00800007In1Sh6OPHn1Wh6?P00000SoP00Dkh3oP?n0oh3_P00<oh00C>n0oh3oP000Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P00000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n8010?S
0n83hP?R0P0002/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0030000<@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f00Aoo`03001oogoo00eoo`002Goo00<007ooOol00Woo00@007oo
Oomoo`Ql00L000035n000000008oh080000:Hn1Wh6?PIn1Sh6OPHn1Wh6?P000<?n000`006n0Gh002
5n001A_P5n0Gh1OP6n000aOP00<Kh0000n8050?R0P00:P?/0`000P?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00<3mP?eOol00goo00<007ooOol03Goo0008Ool20004Ool01000Oomo
ogoo27`020000SoP0P0000eWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000002?n001C_P?n0oh3oP>n00
0coP00l001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P00000P?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n80;0?S0n83hP000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/40000=`?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f00Aoo`03001oogoo00eoo`003Woo00@0
07ooOomoo`Ml00P00006?n000000Hn1Wh6?P0P0000YWh6?PIn1Sh6OPHn1Wh6?PIn0000Toh003000K
h1OP008Gh0056n0Gh1OP5n0Kh0035n000a_P0003hP0C0n82000W0n`200030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e17oo00<007ooOol03Goo000>Ool0
1000Oomoogoo1g`02@0000=Wh00000000P0000eoH7n0000006?PIn1Sh6OPHn1Wh6?P000kh003?n00
4c_P?n0oh3oP>n0001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000083hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R02X3h`000003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/20000?@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f00Aoo`03001oogoo
00eoo`003Woo0P000Woo1G`0300027n000P006?PIn1Sh6OPHn1Wh00023oP00D001OP5n0Gh1_P00<G
h0046n0Gh1OP5n02000A0n83000T0n`500000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?eOol00Woo0P003goo000>Ool01000Oomo
ogoo1G`01`0001AWh000Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh0000coP018kh3oP
?n0oh3_P000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP00030n801@?S0n83hP?R0n<00`?R00H3h`?R0n83
hP?S0n82000090?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`<000140oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mPAoo`03001oogoo00eoo`00
3Woo00@007ooOomoo`Al00T00003Oh00000000<000IoP007001Sh6OPHn1Wh6?P000023oP00@001OP
5n0Kh0<Gh0056n0Gh1OP5n00000A0n800`000n`3k00Q0n`300030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3m@?e0oD4
Ool00`00Oomoo`0=Ool000ioo`04001oogooOol4O00:00004GiPOT1n@7i0OV0007n0Of1oP7mPOh00
06OPHn1Wh6?P00000SoP010kh3oP?n0oh3_P?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh08000<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00P000203j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/100004X3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f17oo00<007ooOol03Goo000>Ool01000Oomoogoo17`0200027i000<007n0Oh000Wn000H0
06?PIn1Sh6OP0007?n0010005n0Gh1_P0aOP00@Kh1OP5n0000l3hP<001h3k0@000050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@060oH3m@?e0oD3mP?e17oo00<007ooOol03Goo000>Ool01000Oomoogoo17`0
1@0000=oH00000000`0000=n@7iPOT000Wi000`007mPOh1oH000Hn1Wh6?PIn1Sh000>n03?n003S_P
?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh0000n<30n801@?S0n83hP?R0n<00`?R0283h`?R000000?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`<0001B
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH4Ool00`00Oomoo`0=Ool0
00ioo`80009oo`=l00T00004O@1m87d00004OT002P00Oh1oP7n0001Wh6?PIn1Sh0001SoP00@001OP
5n0Kh0<Gh0046n0Gh000000=0n82000L0n`400000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e0goo0P003goo000>Ool01000Oomoogoo0g`0200001=l0000001m
87d0001n@7iPOT0007mPOh0006OPHn1Wh6?PIn000003?n003S_P?n0001_P5n0Kh1OP6n0Gh1_P5n00
00?R0n<30n801@?S0n83hP?R0n<00`?R0P0001`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`80001I0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP04Ool00`00Oomoo`0=Ool000ioo`04001oogooOol3
O00300000gi000000005O0001000OB1m00000Wi000T007n0Oh0006?PIn1Sh6OP00001CoP00@001OP
5n0Kh0<Gh0036n00000000d3hP030003k0?/01L3k0D000030oD3mP?e0083m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3m@Aoo`03001oogoo00eoo`003Woo
00@007ooOomoo`=l00800003OT00000000Il0003001m0000009n@007001oP7mP001Sh6OPHn000P00
0coP00Tkh3oP000Kh1OP6n0Gh1_P5n000P000P?R00D3h`?R0n83hP?S00<3hP030n<3hP000080000F
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`40000H0?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mPAoo`03001oogoo00eoo`003Woo00@007ooOomoo`=l00@000Il0004001m07dP0002OT001`00Oh1o
P000In1Sh00000Doh080008Gh0036n0Gh1OP008000X3hP@001H3k0<000050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3
m@?e008000=oo`03001oogoo00eoo`003Woo00@007ooOomoo`=l008000Ql0003001m8000009n@008
001oH000001Wh6?P000kh0<oh08000055n0Kh1OP6n0Gh00200001@?S0n83hP?R0n<00`?R01T3h`00
000000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0050000F`?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f00/00003
0omoogoo009oo`03001oogoo00eoo`003Woo0P000Woo0g`000<007`0O0001W`000<007dP00000Wi0
00L007n0001Sh6OPHn000004?n000`006n0Gh0025n000a_P000000090n82000E0n`300020oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?e0oD02`0030?o0goo0P003goo
000>Ool01000Oomoogoo0W`00P0027`000`007d0001n@000Of1oP000In1Sh000>n02?n0200001Q_P
5n0Kh1OP6n000083hP050n<3hP?R0n83h`020n82000050?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`30000D@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP07000G0ol4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol2O0020007O0001@00O@0007i00000
0Wn000@006OP000000<oh003000Gh1_P00<Gh08000H3hP@000l3k0L00083m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f0083m@/001h3o`Aoo`03001oogoo00eoo`003Woo00@007ooOomoo`9l008000Ml0005001m
8000001oH00200001FOP000oh3_P?n000P0000<Gh1_P00000`000`?R00<3h`?R00000P0000l3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0100004D3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH02`00:@?o17oo
00<007ooOol03Goo000>Ool01000Oomoogoo0W`00P001g`00`0000EoP000Hn1Wh00000<oh003000G
h1OP008000L3hP8000h3k0@000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD00`?f0oD3m@0;000d0ol4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol2
O0000`00O01l0006O00200000gmP001Sh00200001CoP>n0000006n000P000`?R00@3h`?R0n83hP80
000<0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[100003L3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP0;000o0ol4Ool00`00Oomoo`0=Ool000ioo`80009oo`9l0003
001l07`000Al00L0008oh08000035n00000000D3hP@000P3k0H000030oD3mP?e0083m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e3P00BP?o0goo0P003goo000>Ool01000Oomoogoo0W`000<007`0O0000g`01000
00=Wh00000001P0000<3hP?S0n80100000L3k0?[0n`3j`?/0n/3k00500009`?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP0<001H0ol4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol30004O00700025n0200030n83
00040n`700020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00P?e2`00I0?o17oo00<007ooOol03Goo000>Ool01000Oomoogoo0P0000=m8000
O0001`0000DKh000000000?S00@000030n/3k0?[00@0000J0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@h006l3o`Aoo`03001oogoo00eoo`0027oo0P0017oo
00@007ooOomoo`9l01H000<3m@050oH3m@?e0oD3mP030oDC001m0ol4Ool00`00Oomoo`0=Ool000Mo
o`04001oogoo0003Ool01@00OomoogooO0000`0000<Kh1OP00002@0000<3mP0000004000T0?o17oo
00<007ooOol03Goo0007Ool01000Oomoo`000goo0P000Woo4@00XP?o0goo0P003goo0007Ool01000
Oomoo`000goo00D007ooOomoog`001h009@3o`Aoo`03001oogoo00eoo`001goo00@007ooOol000=o
o`04001oogooOol3O00A00030[l01@;O0[l2_`:o0]l00`:o3`00Q@?o17oo00<007ooOol03Goo0008
Ool20004Ool01000Oomoogoo17`0300000@1W`5o0Il1O`L0000C0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l03P00M`?o17oo00<007ooOol03Goo000>Ool01@00Oomoogoo00001G`0
3P001`6O10000P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00<2g`:o0[l03`00J0?o17oo00<007ooOol03Goo000>Ool01P00OomoogooO00000Il00D00003?1l0
01@O00<0000305l00000008000070Il1O`6O0Gl1W`5o0Il01P0002H2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O2`00
G@?o17oo00<007ooOol03Goo000>Ool20002Ool2O0000`00O01l0003O009000251l2000305l3000:
0Il500000`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O0082_`h004l3o`=oo`8000moo`003Woo00@0
07ooOomoo`9l0003001l07`000Al00800003O0P0000000D0000351lH7`0000800080G`0307l00000
0080000;0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`070000<`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`0;00140ol4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol2O0020007
O00300000g`L001P7`0400000aPO51lD7`03000405l4000>0Il400001@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`:o00002P00>@?o17oo00<007ooOol0
3Goo000>Ool01000Oomoogoo0W`00P001g`000X007`9000007`K001P7f@O000l7`<0000361lD7aPO
008000<0G`0307l0G`1O00@0000>0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`@000110[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`0;000^0ol4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol2O0020008O0001@00O0T00000
O1`00P0000=T7`0000000S`O00D001@O51lH7a@O008000P0G`800101W`<000<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2
g`:o0[l2_`;O0[l;000S0ol4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol3O0000`00O01l0006
O0002`00O0P007`B001l6g`L001T7f0O00000S`O00H001PO51lH7a@O61l300001@1o05l0G`1O07l0
0P1O0P000141O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00@0001@0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`P001/3o`Aoo`03001oogoo00eoo`003Woo0P000Woo
0g`000<007`0O0001g`000/007`8001l4P00O1`0060OI1mP7`00008l7`80000351lH7a@O008D7`03
61l0000000L0G`<00181W`L00082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`02
0[l;000@0ol3Ool2000?Ool000ioo`04001oogooOol3O0000`00O01l0007O0003000O0T007`CO180
07`K001P7f@OH1l0008l7`0:>1l0000061lD7aPO51lH7a@O000305l01P1o05l0G`1O07l0G`<0000F
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il40000F0:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O2`001@?o17oo00<007oo
Ool03Goo000>Ool01000Oomoogoo0g`00P0027`000H007`8O0T007`B0002O1`200000f@OH1l00004
?1l00`0061lD7`0251l011PO51l000002P1O0`005`6O100000D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00P:o1P000goo00<007oo
Ool03Goo000>Ool01000Oomoogoo0g`010001g`000d007`8001l4W`C001l77`K001P7f@OH1l00002
?1l02SPO?1l0000051lH7a@O61lD7aPO0P0000<0G`1o05l00P1O00H0O`1O05l0G`1o05l200006@6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00<0001Q0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l017oo00<007ooOol03Goo000>Ool01000Oomoogoo0g`00P000W`B00<007`0O00017`0
00H007`9O0P007`B0003O1`01@00H1mT7f0O00001C`O00D001@O51lD7aPO00<D7`030000G`1O00X0
G`8001X1W`<000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00H2g`:o0[l2_`;O0[l4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol3O0070003O002
00000g`8O0T00002O1802@00O1]l7000I1mP7f@OH1l00002?1l02cPO?1ll7`0051lH7a@O61lD7aPO
51l00`000`1O00D0O`1O05l0G`1o00<0G`<0000J0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`D0001I0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`04Ool00`00Oomoo`0=Ool000ioo`80009oo`=l00H00008
O0T00000001l2G`8O0T000=l4P0:001l77`LO1`006@OH1mT7f0O0005?1l01@0051lD7a@O61l00a@O
00<H7a@O00003@1O0P007@6O0`000P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`040]l2_`:o0[l3Ool2000?Ool000ioo`04001oogooOol4O00700001G`8O0Ul27`900000W`B
00el4g`B001l6g`LO1/0060OI1mP7f@OH1l00002?1l03SPO?1ll7`0051lH7a@O61lD7aPO51lH7a@O
000305l01@1o05l0G`1O07l00`1O00<0O`1O05l00`0001d1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00@0001B0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol4O0020000
1@:o00000000O1`010001G`B00<007`LO1`00W`L00H0060OI1mP7f@O0006?1l2000251l01QPO51lD
7a@O61lD7`8000l0G`8001l1W`@000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o
17oo00<007ooOol03Goo000>Ool01000Oomoogoo17`02P000W`B011l4g`BO18007`LO1]l77`KO1`0
06@OH1mT7f0OI1l000<l7`0>>1ll7c`O?1l001PO51lH7a@O61lD7aPO51lH7`80000305l0O`1O0080
G`0507l0G`1O05l0O`0305l09@1o05l000000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00<0001;0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O00Aoo`03001oogoo00eoo`003Woo00@007ooOomoo`El00P00003O1`0000000<000Il
7007001P7f@OH1mT7f0O00001c`O00D001@O51lD7aPO00<D7`0561lD7a@O51l0000@05l2000R0Il4
00030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`040]l2_`:o0[l4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol5O0090000
57`LO1]l77`KO1al6g`LO1]l77`KO1`006@OH1mT7f0OI1mP7`00>1l3?1l04SPO?1ll7`0051lH7a@O
61lD7aPO51lH7a@O61lD7`0005l0O`<0G`0507l0G`1O05l0O`0305l0101o05l0G`1O0P0002@1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl20000A@;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`04Ool00`00Oomoo`0=Ool000ioo`80009oo`El
00P00003I1l007`L00Ul7008001P7f@OH1mT7f0OI1l000Pl7`05000D7a@O51lH7`0351l01APO51lD
7a@O00004P1O0P00906O0P0000<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o0goo0P003goo000>Ool01000Oomoogoo
1W`02`0000Il6g`LO1]l77`KO1`20000260OI1mP7f@OH1mT7f0O0002?1l01CPO?1ll7c`O>1l00S`O
00`001@O61lD7aPO51lH7a@O61lD7aPO51l200001@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0X07l0G`000001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl30000@0:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O17oo00<007ooOol03Goo000>Ool01000
Oomoogoo1g`01`0000<l7`00H1l01P0000YT7f0OI1mP7f@OH1mT7f0OI1l000Tl7`03000H7a@O008D
7`0561lD7a@O51lH7`0351l00aPO0000G`0B05l2000U0Il400001@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2_`Aoo`03001oogoo00eoo`003Woo
00@007ooOomoo`Ql00L0000C?1l00000I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`00>1l00c`O
01Hh7c`O?1ll7cPO?1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7`0005l0O`<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O02T0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00<0000i0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O00Aoo`03001oogoo00eo
o`001goo1@000Woo00@007ooOomoo`Ql00P0008l7`0?001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7`0000Xl7`80000561lD7a@O51lH7`0351l01APO51lD7a@O00005@1O0P00:@6O10000`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`:oOol00goo00<007ooOol03Goo0009Ool0
0`00Oomoo`02Ool01000Oomoogoo27`02P0000`l7`00001P7f@OH1mT7f0OI1mP7f@OH1l20003?1l0
1CPO?1ll7c`O>1l00c`O018h7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0001O07l305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0^07l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl30000<P:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l4Ool00`00Oomoo`0=
Ool000Uoo`03001oogoo009oo`80009oo`Ul00X0008l7`<00004H1mT7f0OI1l2000>?1l0100051lD
7aPO0a@O00DH7a@O51lD7aPO00<D7`8001D0G`8002d1W`8000050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`=oo`8000moo`002Goo00<007ooOol00Woo00@007ooOomoo`Ul00P0000505l0
0000000h7`02?1l400000c`O>1ll7`02?1l01CPO?1ll7c`O>1l00c`O01Hh7c`O?1l001@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO0000O`<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O0340O`1O0000006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`040000;0:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l4Ool00`00Oomoo`0=Ool000Uoo`03001oogoo009oo`04001oogooOol:
O005000010:o000000000Q@O0P005C`O00<001PO51l00Q@O00DH7a@O51lD7aPO00<D7`0661lD7a@O
51lH7`005`1O0P00;`6O0P0000D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`03Ool00`00Oomoo`0=
Ool000Qoo`8000Aoo`04001oogooOol:O00600001`;O0000000061lD7aPO0080008l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O01Hh7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7`0005l0O`<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O03D0O`1O05l0G`000Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00@0000V0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`Aoo`03
001oogoo00eoo`003Woo00@007ooOomoo`]l00L000080Il00000000D7aPO51l0018l7`04000D7a@O
61l351l01APO51lD7a@O61l00a@O00DH7a@O51lD7`0001T0G`800381W`8000050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`:o
17oo00<007ooOol03Goo000>Ool01000Oomoogoo2g`02@000P1O00@001@O61lD7`800003?1lh7c`O
008l7`05>1ll7c`O?1lh7`03?1l05cPO?1l0000051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO00000P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
03D0O`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0080000R0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l4Ool00`00Oomoo`0=Ool000ioo`80009oo`]l00/0000405l0000061l251l3000:?1l2000251l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0461lD7a@O000K05l00`000Il1W`0b0Il30000
0`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
0`;O0[moo`02Ool2000?Ool000ioo`04001oogooOol<O00600003@?o0000005o0000G`1o000H7a@O
61lD7aPO00X0000H51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`00
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O03P0O`000001
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0`0001`2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`Aoo`03001oogoo00eo
o`003Woo00@007ooOomoo`al00T00081W`050000G`1O000H7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O00007@1O00<0
006O0Il0=@6O0P000P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o17oo00<007ooOol03Goo000>Ool01000Oomoogoo37`01`000303o`000000005o0000G`1o000H
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7`0007l305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l0>`1o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il00P0001P2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l4Ool00`00Oomoo`0=Ool000ioo`04001oogooOol=O005000020?/0003o`000[l0006O000205l2
000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00<0001O05l0701O0P00>@6O0`000`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l00`;O0[moo`03Ool00`00Oomoo`0=Ool000ioo`04001oogooOol=O00800001@?o0002_`00
0Gl00P0002H0O`1O000001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7`000P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O0480O`1O05l0G`1o05l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl200004`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O00Aoo`03001oogoo00eoo`003Woo0P000Woo3W`0200000@3o`000[l00081W`04
0000G`1O05l200000a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l00aPO51l0000Q05l2000k0Il300001@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`=oo`8000moo`003Woo00@007ooOomoo`il00T000080ol000000Il1O`6O0000O`<0G`80000O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0001O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o0080G`0n0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`80000>0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`Aoo`03001oogoo
00eoo`003Woo00@007ooOomoo`il00P000050oD000000]l000030Il00`0005l0G`0305l2000351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251l00`0005l0G`0R05l0
0`000Il1W`0m0Il200020[l01@;O0[l2_`:o0]l00`:o00<2g`:oOol00goo00<007ooOol03Goo000>
Ool01000Oomoogoo3g`02@0000<3o`000]l00P0000@1O`6O000000<0G`0307l0G`000080000H51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0001o0`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1307l0G`00
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il00`0000T2g`:o0]l2_`;O0[l2g`:o0]l017oo00<007ooOol03Goo000>Ool01000Oomo
ogoo3g`02P0000D3o`000]l2_`0000<1W`030000G`1O00D0G`D0000351lH7a@O008D7`0561lD7a@O
51lH7`0351l00aPO51lD7`02000W05l00`000Il1W`100Il300020[l010;O0[l2_`:o17oo00<007oo
Ool03Goo000>Ool01000Oomoogoo47`01P0000`3h`00000000?o0002g`:o0001O`6O0Gl2000205l0
1@1o05l0G`1O07l00`1O0`0000/D7aPO51lH7a@O61lD7aPO51lH7a@O0080000507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O04L0O`1O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O008000040[l2g`:o0]l4Ool00`00Oomoo`0=Ool0
00ioo`80009ooa1l00D0000:6n0000000003mP000ol000;O0[l200030Il00`0005l0G`0:05l;000]
05l00`000Il1W`130Il010000[l2g`:o0goo0P003goo000>Ool01000Oomoogoo4G`01P0000@3hP00
00000083o`090002g`:o0]l0006O0Gl1W`000080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O04P0O`000001O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl200000`;OOomoo`02Ool00`00Oomoo`0=Ool000ioo`04001oogooOolAO00600001@?R0000
00?e00000P?o00@000;O0[l000@1W`030000G`1O0440G`030001W`6O04D1W`8000=oo`03001oogoo
00eoo`003Woo00@007ooOomooa9l00H000050n8000000oD000020ol00`000]l2_`0200000`6O0Gl1
W`0200000`1O07l0G`0205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O04d0O`1O05l0G`1o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo00eo
o`003Woo00@007ooOomooa9l00<00003In000000008000040n`000?e00020ol01@000]l2_`:o0000
106O0P00@01O00<0006O0Il0A@6O17oo00<007ooOol03Goo000>Ool01000Oomoogoo4W`01P0000LK
h0000003j`000oD000020ol02P000]l2_`;O0001W`5o0Il1O`6O0P000`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1;07l0G`1O05l0005o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O00Aoo`03001oogoo00eoo`003Woo0P000Woo4g`01`0000H3hP000n`000?e00020ol0
10000]l2_`:o0P001@6O0P00?@1O00<0006O0Il0A06O0goo0P003goo000>Ool01000Oomoogoo4g`0
1P0000PGh0000n8000?[0003m@000P?o00d000;O0[l2g`:o0001O`6O0Gl1W`5o0Il0000205l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O04T0O`1O0001O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00Oomoo`0=Ool000ioo`04001oogooOolDO007000010?R0003
k0000P?e00D000?o0ol000;O00<2_`030001W`6O00@1W`8003X0G`030001W`6O04@1W`Aoo`03001o
ogoo00eoo`003Woo00@007ooOomooaAl00H000086n0000?S0003k0000oH000<3o`0=0002g`:o0]l2
_`000Gl1W`5o0Il1O`6O0Gl00`000`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
04/0O`1O05l0G`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il017oo00<007ooOol03Goo0007Ool40003Ool0
1000Oomoogoo57`000<007dP0000100000PKh0000n8000?/0003m@000`?o00<000;O0[l00P:o0P00
206O0`00=01O00<0006O0Il0A06O17oo00<007ooOol03Goo0007Ool00`00Oomoo`04Ool01000Oomo
ogoo5G`01@0000Xoh0000003hP000n/3k0000oH000<3o`0A0002g`:o0]l2_`;O0001W`5o0Il1O`6O
0Gl1W`5o0Il1O`0200001@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0B@1o05l0005o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo00eoo`0027oo00<007ooOol00goo0P000Woo5G`0
0P0000=n@00000000P0000@Gh0000n800083k0030003m@0000<3o`030002g`:o0082_`030]l0006O
00X1W`030000G`1O02l0G`030001W`6O04@1W`=oo`8000moo`002Goo00<007ooOol00Woo00@007oo
OomooaEl00800005OT000000000kh002000020?R0003k0?[0003m@?f00030ol04P000]l2_`;O0[l2
g`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`@0000305l0O`1O0080G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
04L0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo00eoo`001goo00@007ooOol000=oo`04
001oogooOolFO00400000f?P000oh00200001@?R000000?/00000P?e00@000?o0ol3o`8000<2_`03
0]l0000000d1W`8002X0G`030001W`6O04D1W`Aoo`03001oogoo00eoo`0027oo0P0017oo00@007oo
OomooaMl0003001n@00000800004?n0001_P00020n82000010?f0oD3mP0010?o00H000:o0]l2_`;O
0[l200003@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00<00080G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0C@1o05l0G`1O07l0006O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il017oo00<007ooOol03Goo000>Ool01000Oomoogoo5g`00`0000Yo
P000000oh0005n0000?R0003k0800083m@030003o`?o0083o`050002_`:o0[l2g`020[l00`000Il1
W`0=0Il4000P05l300180Il4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolGO00200004Gi00000
06OP000oh0006n0000?R0003k0?[0003m@?f000010?o00L000:o0]l2_`;O0[l2g`0200004@5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00`0000<0G`1o05l00P1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`0004/1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il017oo00<007ooOol03Goo000>Ool20002OolHO00300002Gn0000003oP000Gh0000n800003
0n`010000oD3m@0010?o00D000:o0[l2_`;O00<2_`030001W`6O0141W`L000l0G`@004h1W`=oo`80
00moo`003Woo00@007ooOomooaQl0080000BOV000000Hn0003oP000Gh0000n8000?[0n`000?f0oD3
mP0010?o00P000:o0]l2_`;O0[l2g`:o0P0001P1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl?0000DP5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O17oo00<007ooOol03Goo000>Ool01000Oomoogoo67`000<007dP00000P0000IWh000?n00
01_P00020n801@000n`3k0000oH00P?e00<000?o0ol00P?o00D000:o0[l2_`;O00<2_`030]l0006O
07L1W`Aoo`03001oogoo00eoo`003Woo00@007ooOomooaUl0080000COT000000In0003oP000Kh000
0n<3hP000n/3k0000oH3m@?f000010?o084000:o0]l2_`;O0[l2g`:o0]l0006O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il017oo00<007ooOol03Goo
000>Ool01000Oomoogoo6G`000<007d000000P0000ISh000?n0001OP00020n801P000n`3k0?/0003
mP83m@030003o`?o0083o`050002_`:o0[l2g`030[l00`;O0000001e0Il4Ool00`00Oomoo`0=Ool0
00ioo`04001oogooOolJO00200004gi0000006?P000kh0005n0000?R0n<000?/0n/000?e0oH3m@00
00D3o`1o0002_`;O0[l2g`:o0]l2_`;O0[l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il017oo00<007ooOol03Goo000>Ool20002OolJO002000017i00000
06OP0`0000@Gh0000n83hP800083k0050003m@?f0oD000050ol01@000[l2_`:o0]l00`:o00@2g`:o
00000781W`=oo`8000moo`003Woo00@007ooOomooaYl000<001m0000001oP000In0003oP000Kh000
0P?R00T3h`000n`3j`000oD3mP?e00001@?o0P0000T2g`:o0]l2_`;O0[l2g`:o0]l00P000701O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`Aoo`03001oogoo00eoo`003Woo
00@007ooOomooa]l00800005OT000000Hn1Wh00200025n0010000n83hP000`?/00@000?e0oH3m@80
00D3o`8000030[l2g`:o0082_`040]l2_`:o0[l2001^0Il4Ool00`00Oomoo`0=Ool000ioo`04001o
ogooOolKO0003@00OB000000Of0006?P000oh0005n0Kh0000083hP0:0003j`?/0n/000?e0oH3m@?f
00060ol02`000[l2g`:o0]l2_`;O0[l2g`:o0]l00P0006`1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolLO002000027i0001oP000Hn00
03oP00025n0010000n83hP000`?/00<000?e0oH00P?e00<000?o0ol00`?o00@000:o0[l2g`<2_`06
0]l2_`:o0[l2g`:o0P00JP6O17oo00<007ooOol03Goo000>Ool01000Oomoogoo77`000P007d00000
07n0001Wh0000SoP00<001OP00000`?R00X000?[0n`000?f0oD3mP?e0oH000D3o`1h0002g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O17oo00<007oo
Ool03Goo000>Ool20002OolMO00200002gi0001oP000In0003oP000Kh1OP00000`?R00@000?/0n`0
0083m@030oH3m@0000H3o`8000030[l2g`:o0082_`050]l2_`:o0[l2g`020[l2001W0Il3Ool2000?
Ool000ioo`04001oogooOolMO002000037i0001oH000Hn0003_P?n0001_P0003h`83hP090003k0?[
0n`000?f0oD3mP?e008000H3o`0>0002_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`80001U0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00Oomoo`0=Ool000ioo`04001oogooOolMO0002@00O@0007i0
001oP000Hn000002?n000`006n0000030n801@000n`3k0?/00000P?e00@3mP?e0oD000H3o`030002
_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0000001S0Il4Ool00`00Oomoo`0=Ool000ioo`04001o
ogooOolNO00200006WiP001oP000In0003oP>n0001OP6n0000?S0n8000?[0n`3j`?/0003mP?e0oH3
m@?f00060ol20000L@;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0005o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0
17oo00<007ooOol03Goo000>Ool01000Oomoogoo7W`000T007dP001n@000Oh0006OP00000SoP00@0
01OP6n000083hP030003k0?/0083k0060003m@?e0oH3m@0020?o00<000;O0[l00P:o00D2g`:o0[l2
_`;O00<2_`040]l2_`00001P0Il4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolNO0002@00O@00
07i0001oH000Hn000002?n004P006n0Gh0000n83h`?R0003j`?/0n/000?e0oH3m@?f0oD000P3o`0@
0002g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l30000G@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00Oomoo`0=Ool0
00ioo`80009ooaml0004001m00000002Oh000`00Hn000002?n0010005n0Gh0000`?R00@000?/0n`3
k0800083m@030oH3m@0000P3o`8000<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`00FP6O
0goo0P003goo000>Ool01000Oomoogoo7g`000T007dP001n@000Oh0006OP00000SoP00@001OP6n00
0083hP0<0n<000?/0n/3k0?[0n`000?f0oD3mP?e0P0020?o0P000142g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0080001H0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il4Ool00`00Oomoo`0=Ool000ioo`04001oogooOolPO00200001gi0001o
P7n0001Wh000008oh004000Gh1OP00030n800`000n`3k0020n`01@000oD3m@?e0oH00P?e00<000?o
0ol01`?o00@000:o0[l2g`<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0000E`6O17oo00<007oo
Ool03Goo000>Ool01000Oomoogoo87`000X007d0001n@000Of0006?PIn00008oh004000Gh1_P0002
0n803P?S0003k0?[0n`3j`000oD3mP?e0oH3m@?f00090ol04`000]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0080001E0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il017oo00<007ooOol03Goo0008Ool20004Ool01000Oomoogoo8G`00P0000Mn@000
Oh1oP000Hn000002?n0010006n0Gh00010?R00<000?/0n`00P?/00D000?e0oD3m@?f0083m@030003
o`?o00L3o`040002_`:o0]l30[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<00581W`Aoo`03
001oogoo00eoo`001goo00@007ooOol000=oo`04001oogooOolQO0004000OB0007iP001oP000In1S
h000>n0oh0006n0Gh0000`?R00h000?[0n`3j`?/0003mP?e0oH3m@?f0oD3mP002@?o0P0001@2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0P000501O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O17oo00<007ooOol03Goo0009Ool00`00Oomoo`02Ool20002OolQ
O0002P00O@0007i0001oP000Hn1Wh0000SoP00D001OP6n0Gh00000<3hP030003k0?/0083k08000<3
m@040oH3m@?e000:0ol00`000[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`80
04h1W`=oo`8000moo`002Woo00D007ooOomoo`000;Yoo`03001oogoo00eoo`001goo00@007ooOol0
00=oo`04001oogoo000MOol00`00Oomoo`0KOol00`00Oomoo`0KOol00`00Oomoo`0KOol00`00Oomo
o`0KOol00`00Oomoo`0KOol01@00Oomoogoo00003goo0008Ool20004Ool01000Oomoo`001Goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00D007ooOomoo`0000mo
o`003Woo_0003goo003IOol00=Uoo`00fGoo003IOol00=Uoo`00fGoo003IOol000aoo`800<]oo`00
3Goo00<007ooOol0bGoo000>Ool00`00Oomoo`38Ool000eoo`03001oo`000<Uoo`0037oo00@007oo
Ool00<Uoo`002goo0`0000=oo`000000b7oo003IOol00=Uoo`00fGoo003IOol00001\
\>"],
  ImageRangeCache->{{{0, 216}, {216, -1.6875}} -> {-0.291172, -3.55527, \
0.0166569, 0.0334254}}]
}, Open  ]],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"DropFormation.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{721, 668},
WindowMargins->{{5, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->330,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "The plane jet"->{
    Cell[1739, 51, 348, 5, 41, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 64}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"The plane jet"]},
  "plane jet"->{
    Cell[2090, 58, 1185, 30, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "plane jet", "Prandtl's boundary-layer equations", 
        "incompressible viscous fluid"}]},
  "Prandtl's boundary-layer equations"->{
    Cell[2090, 58, 1185, 30, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "plane jet", "Prandtl's boundary-layer equations", 
        "incompressible viscous fluid"}]},
  "incompressible viscous fluid"->{
    Cell[2090, 58, 1185, 30, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "plane jet", "Prandtl's boundary-layer equations", 
        "incompressible viscous fluid"}]},
  "kinematic viscosity"->{
    Cell[4186, 126, 195, 4, 27, "Text",
      Evaluatable->False,
      CellTags->"kinematic viscosity"]},
  "asymptotic behavior"->{
    Cell[4853, 151, 100, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"asymptotic behavior"],
    Cell[14448, 497, 188, 7, 27, "Text",
      Evaluatable->False,
      CellTags->"asymptotic behavior"]},
  "Schlichting"->{
    Cell[5429, 173, 846, 19, 61, "Text",
      Evaluatable->False,
      CellTags->{"Schlichting", "stream function"}]},
  "stream function"->{
    Cell[5429, 173, 846, 19, 61, "Text",
      Evaluatable->False,
      CellTags->{"Schlichting", "stream function"}],
    Cell[138340, 4777, 283, 8, 44, "Text",
      Evaluatable->False,
      CellTags->"stream function"]},
  "jet equations"->{
    Cell[6701, 208, 125, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"jet equations"]},
  "Infinitesimals[]"->{
    Cell[8859, 279, 199, 5, 29, "Text",
      Evaluatable->False,
      CellTags->"Infinitesimals[]"]},
  "reduction"->{
    Cell[10934, 351, 65, 1, 27, "Text",
      CellTags->"reduction"]},
  "similarity solution"->{
    Cell[12140, 395, 343, 13, 27, "Text",
      Evaluatable->False,
      CellTags->"similarity solution"]},
  "boundary conditions"->{
    Cell[12882, 425, 382, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"boundary conditions"],
    Cell[20058, 689, 919, 31, 44, "Text",
      Evaluatable->False,
      CellTags->"boundary conditions"]},
  "similarity reduction"->{
    Cell[15967, 556, 109, 1, 27, "Text",
      CellTags->"similarity reduction"]},
  "DSolve[]"->{
    Cell[18209, 625, 545, 17, 63, "Text",
      Evaluatable->False,
      CellTags->"DSolve[]"]},
  "jet solution"->{
    Cell[21445, 739, 216, 7, 29, "Text",
      Evaluatable->False,
      CellTags->"jet solution"]},
  "similarity representation"->{
    Cell[21978, 762, 133, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"similarity representation"]},
  "Tanh[]"->{
    Cell[22557, 782, 876, 26, 82, "Text",
      Evaluatable->False,
      CellTags->{"Tanh[]", "contour plot"}]},
  "contour plot"->{
    Cell[22557, 782, 876, 26, 82, "Text",
      Evaluatable->False,
      CellTags->{"Tanh[]", "contour plot"}]},
  "stream lines"->{
    Cell[137460, 4742, 355, 9, 44, "Text",
      Evaluatable->False,
      CellTags->"stream lines"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"The plane jet", 391770, 14663},
  {"plane jet", 392107, 14670},
  {"Prandtl's boundary-layer equations", 392335, 14676},
  {"incompressible viscous fluid", 392557, 14682},
  {"kinematic viscosity", 392770, 14688},
  {"asymptotic behavior", 392904, 14692},
  {"Schlichting", 393137, 14699},
  {"stream function", 393281, 14703},
  {"jet equations", 393528, 14710},
  {"Infinitesimals[]", 393653, 14714},
  {"reduction", 393774, 14718},
  {"similarity solution", 393872, 14721},
  {"boundary conditions", 394008, 14725},
  {"similarity reduction", 394253, 14732},
  {"DSolve[]", 394352, 14735},
  {"jet solution", 394470, 14739},
  {"similarity representation", 394604, 14743},
  {"Tanh[]", 394732, 14747},
  {"contour plot", 394866, 14751},
  {"stream lines", 395000, 14755}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 348, 5, 41, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"The plane jet"],
Cell[2090, 58, 1185, 30, 95, "Text",
  Evaluatable->False,
  CellTags->{
  "plane jet", "Prandtl's boundary-layer equations", 
    "incompressible viscous fluid"}],
Cell[3278, 90, 82, 1, 24, "NumberedEquation"],
Cell[3363, 93, 123, 3, 24, "NumberedEquation"],
Cell[3489, 98, 111, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[3625, 107, 246, 5, 23, "Input"],
Cell[3874, 114, 297, 9, 34, "Output"]
}, Open  ]],
Cell[4186, 126, 195, 4, 27, "Text",
  Evaluatable->False,
  CellTags->"kinematic viscosity"],

Cell[CellGroupData[{
Cell[4406, 134, 125, 3, 23, "Input"],
Cell[4534, 139, 304, 9, 23, "Output"]
}, Open  ]],
Cell[4853, 151, 100, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],
Cell[4956, 155, 97, 2, 23, "Input",
  Evaluatable->False],
Cell[5056, 159, 189, 6, 27, "Text",
  Evaluatable->False],
Cell[5248, 167, 178, 4, 34, "Input"],
Cell[5429, 173, 846, 19, 61, "Text",
  Evaluatable->False,
  CellTags->{"Schlichting", "stream function"}],

Cell[CellGroupData[{
Cell[6300, 196, 202, 4, 23, "Input"],
Cell[6505, 202, 181, 3, 23, "Output"]
}, Open  ]],
Cell[6701, 208, 125, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"jet equations"],

Cell[CellGroupData[{
Cell[6851, 214, 89, 2, 23, "Input"],
Cell[6943, 218, 420, 12, 32, "Output"]
}, Open  ]],
Cell[7378, 233, 213, 4, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7616, 241, 108, 2, 23, "Input"],
Cell[7727, 245, 1117, 31, 23, "Output"]
}, Open  ]],
Cell[8859, 279, 199, 5, 29, "Text",
  Evaluatable->False,
  CellTags->"Infinitesimals[]"],

Cell[CellGroupData[{
Cell[9083, 288, 133, 3, 23, "Input"],
Cell[9219, 293, 786, 25, 44, "Output"]
}, Open  ]],
Cell[10020, 321, 540, 15, 63, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10585, 340, 284, 5, 39, "Input"],
Cell[10872, 347, 47, 1, 23, "Output"]
}, Open  ]],
Cell[10934, 351, 65, 1, 27, "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{
Cell[11024, 356, 258, 5, 23, "Input"],
Cell[11285, 363, 443, 12, 44, "Output"]
}, Open  ]],
Cell[11743, 378, 85, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11853, 383, 138, 4, 23, "Input"],
Cell[11994, 389, 131, 3, 29, "Output"]
}, Open  ]],
Cell[12140, 395, 343, 13, 27, "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[12508, 412, 185, 5, 23, "Input"],
Cell[12696, 419, 171, 3, 26, "Output"]
}, Open  ]],
Cell[12882, 425, 382, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{
Cell[13289, 440, 147, 4, 23, "Input"],
Cell[13439, 446, 68, 1, 25, "Output"]
}, Open  ]],
Cell[13522, 450, 68, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13615, 455, 79, 2, 23, "Input"],
Cell[13697, 459, 50, 1, 23, "Output"]
}, Open  ]],
Cell[13762, 463, 76, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13863, 468, 136, 3, 23, "Input"],
Cell[14002, 473, 50, 1, 23, "Output"]
}, Open  ]],
Cell[14067, 477, 180, 8, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14272, 489, 89, 2, 34, "Input"],
Cell[14364, 493, 69, 1, 34, "Output"]
}, Open  ]],
Cell[14448, 497, 188, 7, 27, "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],

Cell[CellGroupData[{
Cell[14661, 508, 99, 2, 23, "Input"],
Cell[14763, 512, 38, 1, 34, "Output"]
}, Open  ]],
Cell[14816, 516, 441, 13, 44, "Text",
  Evaluatable->False],
Cell[15260, 531, 305, 10, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15590, 545, 284, 5, 39, "Input"],
Cell[15877, 552, 75, 1, 23, "Output"]
}, Open  ]],
Cell[15967, 556, 109, 1, 27, "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{
Cell[16101, 561, 258, 5, 23, "Input"],
Cell[16362, 568, 232, 5, 37, "Message"],
Cell[16597, 575, 734, 17, 72, "Output"]
}, Open  ]],
Cell[17346, 595, 95, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[17466, 602, 247, 5, 28, "Input"],
Cell[17716, 609, 478, 13, 25, "Output"]
}, Open  ]],
Cell[18209, 625, 545, 17, 63, "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[18779, 646, 60, 1, 34, "Input"],
Cell[18842, 649, 615, 16, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19494, 670, 116, 3, 34, "Input"],
Cell[19613, 675, 430, 11, 34, "Output"]
}, Open  ]],
Cell[20058, 689, 919, 31, 44, "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{
Cell[21002, 724, 150, 3, 33, "Input"],
Cell[21155, 729, 275, 7, 34, "Output"]
}, Open  ]],
Cell[21445, 739, 216, 7, 29, "Text",
  Evaluatable->False,
  CellTags->"jet solution"],

Cell[CellGroupData[{
Cell[21686, 750, 95, 2, 23, "Input"],
Cell[21784, 754, 179, 5, 43, "Output"]
}, Open  ]],
Cell[21978, 762, 133, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"similarity representation"],

Cell[CellGroupData[{
Cell[22136, 768, 179, 4, 34, "Input"],
Cell[22318, 774, 224, 5, 43, "Output"]
}, Open  ]],
Cell[22557, 782, 876, 26, 82, "Text",
  Evaluatable->False,
  CellTags->{"Tanh[]", "contour plot"}],
Cell[23436, 810, 197, 4, 23, "Input"],

Cell[CellGroupData[{
Cell[23658, 818, 221, 3, 39, "Input"],
Cell[23882, 823, 113563, 3916, 226, 46305, 3081, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[137460, 4742, 355, 9, 44, "Text",
  Evaluatable->False,
  CellTags->"stream lines"],

Cell[CellGroupData[{
Cell[137840, 4755, 78, 2, 23, "Input"],
Cell[137921, 4759, 77, 1, 46, "Output"]
}, Open  ]],
Cell[138013, 4763, 41, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[138079, 4768, 83, 2, 23, "Input"],
Cell[138165, 4772, 160, 2, 47, "Output"]
}, Open  ]],
Cell[138340, 4777, 283, 8, 44, "Text",
  Evaluatable->False,
  CellTags->"stream function"],

Cell[CellGroupData[{
Cell[138648, 4789, 276, 4, 35, "Input"],
Cell[138927, 4795, 121241, 4598, 230, 57247, 3803, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[260183, 9396, 149, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[260357, 9406, 219, 3, 39, "Input"],
Cell[260579, 9411, 129291, 5195, 229, 66044, 4410, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[389885, 14609, 153, 3, 35, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

