(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6943,        192]*)
(*NotebookOutlinePosition[      9457,        266]*)
(*  CellTagsIndexPosition[      9300,        258]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["", "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  AspectRatioFixed->True,
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell["Preface", "Title",
  CellMargins->{{Inherited, Inherited}, {72, Inherited}},
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  AspectRatioFixed->True,
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[TextData[{
  "The purpose of this book is to provide the reader with a comprehensive \
introduction to the applications of symmetry analysis to ordinary and partial \
differential equations. The theoretical background of physics is illustrated \
by modern methods of computer algebra. The presentation of the material in \
the book is based on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4 notebooks. The entire  printed version of this book is available on the \
accompanying CD. The text is presented in such a way that the reader can \
interact with the calculations and experiment with the models and methods. \
Also contained in the CD is a package called ",
  StyleBox["MathLie \[LongDash] ",
    FontSlant->"Italic"],
  "in honor of Sophus Lie \[LongDash] carrying out the",
  StyleBox[" ",
    FontSlant->"Italic"],
  "calculations automatically. The application of symmetry analysis to \
problems from physics, mathematics, and engineering is demonstrated by many \
examples. "
}], "Text",
  PageBreakBelow->False,
  CellTags->{
  "space-time translation", "symmetry principle", "laws of nature"}],

Cell[TextData[{
  "The study of symmetries of differential equations is an old subject. \
Thanks to Sophus Lie we today avail of important information on the behavior \
of differential equations. Symmetries can be used to find exact solutions. \
Symmetries can be applied to verify and to develop numerical schemes. They \
can provide conservation laws for differential equations. The theory \
presented here is based on Lie, containing improvements and generalizations \
made by later mathematicians who rediscovered and used Lie's work. The \
presentation of Lie's theory in connection with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is novel and vitalizes an old theory. The extensive symbolic calculations \
necessary under Lie's theory are supported by ",
  StyleBox["MathLie,",
    FontSlant->"Italic"],
  " a package written in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  PageBreakBelow->False],

Cell[TextData[{
  "Each chapter of the present book includes theoretical considerations and \
practical applications of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " examples range from simple definitions to complete notebooks discussing \
specific problems. The examples  include definitions of general derivatives, \
derivations and solutions of determining equations, drop formations in \
liquids, and the first atomic explosion."
}], "Text",
  PageBreakBelow->False],

Cell[TextData[{
  "The end of a definition and a theorem in the text is indicated by \
\[EmptyCircle]. The end of an example is indicated by \[EmptySquare]. ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " hyperlinks in the text are denoted by a brown text color. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input is given in ",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  " while the output is in ",
  StyleBox["red",
    FontColor->RGBColor[1, 0, 0]],
  "."
}], "Text",
  PageBreakBelow->False],

Cell["\<\
I wish to express my gratitude to Peter Olver, Willy Hereman, and \
Mike  Mezzino for reading the manuscript. My appreciation goes to Gerda G\
\[ODoubleDot]ler and  Joachim Engelmann for proofreading the text. I also \
acknowledge contributions by Gernot Haager, Gerald \
Landh\[ADoubleDot]u\[SZ]er, and Ronald Schmid.\
\>", "Text",
  PageBreakBelow->False],

Cell[TextData[{
  "Any suggestions and comments related to the book or to ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " are most appreciated. Please send your e-mail to \
Gerd.Baumann@physik.uni-ulm.de or visit my home page at ",
  ButtonBox["http://www.physik.uni-ulm.de/math/gbaumann/bau.html",
    ButtonData:>{
      URL[ "http://www.physik.uni-ulm.de/math/gbaumann/bau.html"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  PageBreakBelow->False],

Cell["\<\
Ulm, Germany
January 2000\
\>", "Text",
  PageBreakBelow->False],

Cell["Gerd Baumann", "Text",
  PageBreakBelow->False,
  TextAlignment->Right],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"introduc.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{701, 668},
WindowMargins->{{149, Automatic}, {Automatic, 25}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Introduction", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Introduction", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"SectionReferences"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1,
CounterBoxOptions->{CounterFunction:>Identity},
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "space-time translation"->{
    Cell[2500, 68, 1126, 23, 146, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]},
  "symmetry principle"->{
    Cell[2500, 68, 1126, 23, 146, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]},
  "laws of nature"->{
    Cell[2500, 68, 1126, 23, 146, "Text",
      PageBreakBelow->False,
      CellTags->{
      "space-time translation", "symmetry principle", "laws of nature"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"space-time translation", 8735, 239},
  {"symmetry principle", 8925, 244},
  {"laws of nature", 9111, 249}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 348, 6, 94, "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2090, 59, 407, 7, 131, "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2500, 68, 1126, 23, 146, "Text",
  PageBreakBelow->False,
  CellTags->{
  "space-time translation", "symmetry principle", "laws of nature"}],
Cell[3629, 93, 942, 19, 129, "Text",
  PageBreakBelow->False],
Cell[4574, 114, 606, 16, 78, "Text",
  PageBreakBelow->False],
Cell[5183, 132, 592, 19, 61, "Text",
  PageBreakBelow->False],
Cell[5778, 153, 367, 7, 61, "Text",
  PageBreakBelow->False],
Cell[6148, 162, 471, 12, 44, "Text",
  PageBreakBelow->False],
Cell[6622, 176, 74, 4, 44, "Text",
  PageBreakBelow->False],
Cell[6699, 182, 77, 2, 27, "Text",
  PageBreakBelow->False],
Cell[6779, 186, 148, 3, 35, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

