(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    348300,       7392]*)
(*NotebookOutlinePosition[    355164,       7575]*)
(*  CellTagsIndexPosition[    354269,       7549]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.9 The Rayleigh Particle", "Subsection",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 75}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"The Rayleigh particle"],

Cell[TextData[{
  "The Rayleigh particle is similar to the Brownian particle. The difference \
between the two species is that the Brownian particle has a constant \
velocity, whereas the Rayleigh particle is characterized by the macroscopic \
law for the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " in the form of the damping law"
}], "Text",
  Evaluatable->False,
  CellTags->{"Brownian particle", "Rayleigh particle"}],

Cell[BoxData[
    \(TraditionalForm\`\(V\&\[CenterDot]\)\  = \ \(-\[Gamma]\)\ \(V . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "We assume that ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is not too large. The Fokker-Planck (FP) equation related to the Rayleigh \
particle is discussed by ",
  ButtonBox["Van Kampen [1981]",
    ButtonData:>{"Literat.nb", "Van Kampen-1981"},
    ButtonStyle->"Hyperlink"],
  ". The equation of motion for the probability density ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " reads"
}], "Text",
  Evaluatable->False,
  CellTags->{"Fokker-Planck equation", "FP equation", "probability density"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[P, V]; \n
    rayleigh = 
      \[PartialD]\_t P[V, t] - 
          \[Gamma]\ 
            \((\[PartialD]\_V\((V\ P[V, t])\) + 
                \(k\ T\ \[PartialD]\_{V, 2}P[V, t]\)\/M)\) == 0; 
    rayleigh // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(P\_t\), "-", 
                RowBox[{"\[Gamma]", " ", 
                  RowBox[{"(", 
                    RowBox[{"P", "+", \(V\ P\_V\), "+", 
                      StyleBox[\(\(k\ T\ P\_\(V, V\)\)\/M\),
                        ScriptLevel->0]}], ")"}]}]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This linear equation for the probability density ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " depending on the velocity ",
  StyleBox["V ",
    FontSlant->"Italic"],
  "and time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " describes a damped particle of mass ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  " at a temperature ",
  StyleBox["T",
    FontSlant->"Italic"],
  ". The constants \[Gamma] and ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " are the damping parameter and the Boltzmann constant, respectively. The \
independent variables in the equation can be scaled in such a way that the \
equation is free of any parameters [",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Tau]", " ", "=", " ", 
          StyleBox[
            RowBox[{"\[Gamma]", 
              StyleBox["t",
                FontSlant->"Italic"]}]]}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"v", " ", "=", " ", 
          RowBox[{"V", " ", 
            FormBox[
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"m", "/", 
                    RowBox[{"(", 
                      StyleBox["kT",
                        FontSlant->"Italic"], ")"}]}], ")"}], \(1/2\)],
              "TraditionalForm"]}]}], TraditionalForm]]],
  "]. The scaled equation is given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"damped particle", "temperature", "Boltzmann constant"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rayleigh = 
      \[PartialD]\_\[Tau] P[v, \[Tau]] - 
          \((\[PartialD]\_v\((v\ P[v, \[Tau]])\) + 
              \[PartialD]\_{v, 2}P[v, \[Tau]])\) == 0; rayleigh // \ LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-P\) - v\ P\_v + P\_\[Tau] - P\_\(v, v\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This type of equation was examined by ",
  ButtonBox["Cicogna and Vitali [1990]",
    ButtonData:>{"Literat.nb", "Cicogna-1990"},
    ButtonStyle->"Hyperlink"],
  ". We reproduce their results to demonstrate that the structure of the \
infinitesimals can be quite different from a polynomial and that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is capable of finding these symmetries automatically. The infinitesimals \
read"
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infirayl = Infinitesimals[rayleigh, {P}, {v, \[Tau]}]; 
    infirayl // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\[ScriptCapitalF]\_1 + v\ \((\[ScriptCapitalF]\_1)\)\_v - 
                \((\[ScriptCapitalF]\_1)\)\_\[Tau] + 
                \((\[ScriptCapitalF]\_1)\)\_\(v, v\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(E\^\(-\[Tau]\)\ k1\), "+", \(E\^\[Tau]\ k2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ \[Tau]\)\), " ", 
                  \((k3 + E\^\(4\ \[Tau]\)\ k5)\), " ", "v"}]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{
                RowBox[{
                  RowBox[{"-", 
                    StyleBox[\(1\/2\),
                      ScriptLevel->0]}], " ", \(E\^\(\(-2\)\ \[Tau]\)\), " ", 
                  "k3"}], "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ \[Tau]\)\), " ", "k5"}], 
                "+", "k6"}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", "P", " ", 
                  \((\(-E\^\(\(-2\)\ \[Tau]\)\)\ k3 + 2\ k4 - 
                      2\ E\^\[Tau]\ k2\ v - E\^\(2\ \[Tau]\)\ k5\ v\^2)\)}], 
                "+", \(\[ScriptCapitalF]\_1\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 1], 
            Times[ v, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], v]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Tau]]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], v, v]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ 
              Power[ E, 
                Times[ -1, \[Tau]]], k1], 
            Times[ 
              Power[ E, \[Tau]], k2], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ -2, \[Tau]]], 
              Plus[ k3, 
                Times[ 
                  Power[ E, 
                    Times[ 4, \[Tau]]], k5]], v]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ -2, \[Tau]]], k3], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ 2, \[Tau]]], k5], k6]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Rational[ 1, 2], P, 
              Plus[ 
                Times[ -1, 
                  Power[ E, 
                    Times[ -2, \[Tau]]], k3], 
                Times[ 2, k4], 
                Times[ -2, 
                  Power[ E, \[Tau]], k2, v], 
                Times[ -1, 
                  Power[ E, 
                    Times[ 2, \[Tau]]], k5, 
                  Power[ v, 2]]]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The symmetry group is given by a six-dimensional discrete group and an \
infinite dimensional group determined by the function ",
  StyleBox["free[1]", "MmaText",
    FontSlant->"Italic"],
  " satisfying the original Fokker-Planck equation. The structure of the \
infinitesimals illustrates that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is capable of deriving non-polynomial results."
}], "Text",
  Evaluatable->False,
  CellTags->{"symmetry group", "discrete group", "Fokker-Planck equation"}],

Cell[TextData[{
  "The infinitesimals can be used to derive solutions of the FP equation. A \
simple solution is derived for the subgroup ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k2",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  "; the other constants are set to zero. The infinitesimals for this \
subgroup reduce to"
}], "Text",
  CellTags->{"FP equation", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 1, k2 \[Rule] 1, k3 \[Rule] 0, k4 \[Rule] 0, 
          k5 \[Rule] 0, k6 \[Rule] 0, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{E\^\(-\[Tau]\) + E\^\[Tau], 0}, {\(-E\^\[Tau]\)\ P\ v}}\)], "Output"]
}, Open  ]],

Cell["\<\
The corresponding similarity reduction of the FP equation follows \
from\
\>", "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Tau] - \[Zeta]\_1 == 0\)},
          {
            \(E\^\(\(E\^\(2\ \[Tau]\)\ v\^2\)\/\(2\ 
                          \((1 + E\^\(2\ \[Tau]\))\)\)\)\ P - F\_1 == 0\)},
          {
            \(E\^\(\(E\^\(2\ \[Zeta]\_1\)\ v\^2\)\/\(\(-2\) - 
                        2\ E\^\(2\ \[Zeta]\_1\)\)\)\ 
                \((\(-F\_1\) + \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    E\^\(2\ \[Zeta]\_1\)\ \((F\_1)\)\_\(\[Zeta]\_1\))\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We realize that the similarity variable is given by the temporal variable \
\[Tau]. The resulting first-order ODE containing analytic coefficients is \
solved by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->{"similarity variable", "DSolve[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"solr1", " ", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(-F1[zeta1]\), "+", 
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}], "+", 
              RowBox[{\(E\^\(2\ zeta1\)\), " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
            "0"}], ",", "F1", ",", "zeta1"}], "]"}]}]], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(\(-\(1\/2\)\)\ Log[1 + E\^\(2\ #1\)] + #1\)\ C[1]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
The solution of the FP equation in original coordinates results by \
inverting the similarity representation derived above:\
\>", "Text",
  CellTags->{"solution of the FP equation", "similarity representation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      Solve[red1\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr1, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] 
          \(E\^\(\(E\^\(2\ \[Tau]\)\ v\^2\)\/\(\(-2\) - 
                      2\ E\^\(2\ \[Tau]\)\) + \[Tau]\)\ 
              C[1]\)\/\@\(1 + E\^\(2\ \[Tau]\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "A picture for a fixed value of the constant of integration ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] is shown below. The figure demonstrates that the probability density ",
  
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " has a single maximum in the velocity domain. The amplitude of the \
probability density increases with increasing time."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      \(P /. sol1\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. 
        C[1] \[Rule] 1, {v, \(-3\), 3}, {\[Tau], \(-2\), 2}, 
      AxesLabel \[Rule] {"\<v\>", "\<\[Tau]\>", "\<P\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-16 1.04977 -0.0679587 1.04977 [
[.12586 .2075 -12 -8.99448 ]
[.12586 .2075 0 .00552 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.56094 .0364 -5.16972 -9 ]
[.56094 .0364 .83028 0 ]
[.29165 .07573 -10.2423 -15 ]
[.29165 .07573 .75771 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.0156 .31844 -24 -2.78741 ]
[.0156 .31844 0 6.21259 ]
[.00679 .37365 -18 -2.83425 ]
[.00679 .37365 0 6.16575 ]
[-0.00233 .43085 -24 -2.88295 ]
[-0.00233 .43085 0 6.11705 ]
[-0.01179 .49013 -6 -2.93362 ]
[-0.01179 .49013 0 6.06638 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02787 .31377 m
.034 .31144 L
s
[(0.25)] .0156 .31844 1 -0.38058 Mshowa
.0191 .3691 m
.02525 .36682 L
s
[(0.5)] .00679 .37365 1 -0.37017 Mshowa
.01002 .42641 m
.01619 .42419 L
s
[(0.75)] -0.00233 .43085 1 -0.35934 Mshowa
.0006 .48582 m
.0068 .48366 L
s
[(1)] -0.01179 .49013 1 -0.34808 Mshowa
.125 Mabswid
.03467 .27088 m
.03834 .26945 L
s
.03298 .28149 m
.03666 .28007 L
s
.03129 .29218 m
.03496 .29076 L
s
.02959 .30294 m
.03326 .30153 L
s
.02614 .32468 m
.02982 .32329 L
s
.0244 .33567 m
.02808 .33428 L
s
.02264 .34673 m
.02633 .34535 L
s
.02088 .35788 m
.02457 .3565 L
s
.01731 .3804 m
.021 .37904 L
s
.01551 .39178 m
.0192 .39042 L
s
.01369 .40324 m
.01739 .40189 L
s
.01186 .41478 m
.01556 .41344 L
s
.00816 .43812 m
.01187 .43679 L
s
.00629 .44991 m
.01 .4486 L
s
.00441 .46179 m
.00812 .46048 L
s
.00251 .47376 m
.00623 .47246 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
43.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
43.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(P) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.602 .725 .932 r
.38302 .58567 .40504 .60601 .44171 .60015 .41997 .57972 Metetra
.478 .68 .955 r
.41997 .57972 .44171 .60015 .47889 .60178 .45739 .58137 Metetra
.156 .513 .914 r
.45739 .58137 .47889 .60178 .51684 .61635 .49553 .59592 Metetra
0 .179 .669 r
.49553 .59592 .51684 .61635 .55606 .64688 .53486 .62622 Metetra
.506 .002 0 r
.53486 .62622 .55606 .64688 .59702 .68811 .5759 .66686 Metetra
0 .161 .659 r
.5759 .66686 .59702 .68811 .63961 .7233 .61861 .70127 Metetra
.384 .636 .954 r
.61861 .70127 .63961 .7233 .68272 .73097 .66203 .70838 Metetra
.779 .782 .855 r
.66203 .70838 .68272 .73097 .72478 .70062 .70465 .67794 Metetra
.871 .789 .767 r
.70465 .67794 .72478 .70062 .76508 .64197 .74567 .61943 Metetra
.889 .793 .748 r
.74567 .61943 .76508 .64197 .80429 .57638 .78564 .55379 Metetra
.873 .799 .774 r
.78564 .55379 .80429 .57638 .84375 .52102 .82577 .49802 Metetra
.826 .798 .824 r
.82577 .49802 .84375 .52102 .88446 .48162 .86706 .45796 Metetra
.762 .782 .87 r
.86706 .45796 .88446 .48162 .92673 .45531 .90984 .43099 Metetra
.708 .762 .895 r
.90984 .43099 .92673 .45531 .97036 .43666 .95396 .41176 Metetra
.597 .725 .934 r
.36043 .56492 .38302 .58567 .41997 .57972 .39765 .55899 Metetra
.469 .679 .957 r
.39765 .55899 .41997 .57972 .45739 .58137 .43532 .56078 Metetra
.142 .509 .911 r
.43532 .56078 .45739 .58137 .49553 .59592 .47364 .57539 Metetra
0 .182 .668 r
.47364 .57539 .49553 .59592 .53486 .62622 .51309 .60526 Metetra
0 .016 .51 r
.51309 .60526 .53486 .62622 .5759 .66686 .55419 .6448 Metetra
0 .193 .689 r
.55419 .6448 .5759 .66686 .61861 .70127 .59702 .67779 Metetra
.406 .639 .951 r
.59702 .67779 .61861 .70127 .66203 .70838 .64072 .68405 Metetra
.773 .772 .852 r
.64072 .68405 .66203 .70838 .70465 .67794 .6839 .65378 Metetra
.865 .784 .77 r
.6839 .65378 .70465 .67794 .74567 .61943 .7257 .59601 Metetra
.886 .792 .75 r
.7257 .59601 .74567 .61943 .78564 .55379 .76647 .53081 Metetra
.873 .801 .776 r
.76647 .53081 .78564 .55379 .82577 .49802 .80731 .47481 Metetra
.829 .801 .825 r
.80731 .47481 .82577 .49802 .86706 .45796 .8492 .43403 Metetra
.765 .786 .871 r
.8492 .43403 .86706 .45796 .90984 .43099 .89249 .40622 Metetra
.711 .765 .895 r
.89249 .40622 .90984 .43099 .95396 .41176 .93711 .38627 Metetra
.59 .725 .937 r
.33724 .54382 .36043 .56492 .39765 .55899 .37473 .53812 Metetra
.453 .677 .96 r
.37473 .53812 .39765 .55899 .43532 .56078 .41263 .54029 Metetra
.118 .501 .906 r
.41263 .54029 .43532 .56078 .47364 .57539 .45114 .555 Metetra
0 .188 .669 r
.45114 .555 .47364 .57539 .51309 .60526 .4907 .58409 Metetra
0 .049 .54 r
.4907 .58409 .51309 .60526 .55419 .6448 .53188 .62167 Metetra
0 .247 .737 r
.53188 .62167 .55419 .6448 .59702 .67779 .57481 .65228 Metetra
.438 .641 .943 r
.57481 .65228 .59702 .67779 .64072 .68405 .61879 .65722 Metetra
.763 .757 .847 r
.61879 .65722 .64072 .68405 .6839 .65378 .66252 .62754 Metetra
.855 .776 .773 r
.66252 .62754 .6839 .65378 .7257 .59601 .70513 .57146 Metetra
.881 .789 .755 r
.70513 .57146 .7257 .59601 .76647 .53081 .74677 .50755 Metetra
.872 .803 .779 r
.74677 .50755 .76647 .53081 .80731 .47481 .78838 .45166 Metetra
.832 .807 .827 r
.78838 .45166 .80731 .47481 .8492 .43403 .83088 .41007 Metetra
.77 .793 .872 r
.83088 .41007 .8492 .43403 .89249 .40622 .87469 .38115 Metetra
.715 .771 .896 r
.87469 .38115 .89249 .40622 .93711 .38627 .9198 .36025 Metetra
.577 .725 .943 r
.3134 .52257 .33724 .54382 .37473 .53812 .35114 .51744 Metetra
.425 .672 .965 r
.35114 .51744 .37473 .53812 .41263 .54029 .38926 .52031 Metetra
.083 .491 .897 r
.38926 .52031 .41263 .54029 .45114 .555 .42795 .53513 Metetra
0 .206 .676 r
.42795 .53513 .45114 .555 .4907 .58409 .46767 .56277 Metetra
0 .108 .596 r
.46767 .56277 .4907 .58409 .53188 .62167 .50894 .59707 Metetra
0 .329 .804 r
.50894 .59707 .53188 .62167 .57481 .65228 .55197 .62386 Metetra
.479 .641 .928 r
.55197 .62386 .57481 .65228 .61879 .65722 .5962 .62684 Metetra
.748 .735 .84 r
.5962 .62684 .61879 .65722 .66252 .62754 .64048 .59834 Metetra
.839 .763 .778 r
.64048 .59834 .66252 .62754 .70513 .57146 .68392 .54536 Metetra
.872 .785 .762 r
.68392 .54536 .70513 .57146 .74677 .50755 .7265 .48406 Metetra
.87 .807 .785 r
.7265 .48406 .74677 .50755 .78838 .45166 .76895 .42893 Metetra
.836 .817 .83 r
.76895 .42893 .78838 .45166 .83088 .41007 .81211 .3865 Metetra
.778 .805 .874 r
.81211 .3865 .83088 .41007 .87469 .38115 .85644 .35613 Metetra
.722 .78 .898 r
.85644 .35613 .87469 .38115 .9198 .36025 .90202 .33389 Metetra
.552 .724 .954 r
.28885 .50155 .3134 .52257 .35114 .51744 .32681 .49751 Metetra
.379 .665 .97 r
.32681 .49751 .35114 .51744 .38926 .52031 .36513 .50141 Metetra
.041 .481 .884 r
.36513 .50141 .38926 .52031 .42795 .53513 .40404 .51607 Metetra
0 .247 .701 r
.40404 .51607 .42795 .53513 .46767 .56277 .44395 .54111 Metetra
0 .214 .693 r
.44395 .54111 .46767 .56277 .50894 .59707 .48539 .57025 Metetra
.086 .435 .875 r
.48539 .57025 .50894 .59707 .55197 .62386 .52854 .59142 Metetra
.524 .637 .903 r
.52854 .59142 .55197 .62386 .5962 .62684 .57298 .59165 Metetra
.728 .706 .829 r
.57298 .59165 .5962 .62684 .64048 .59834 .61776 .56505 Metetra
.815 .742 .783 r
.61776 .56505 .64048 .59834 .68392 .54536 .66204 .51695 Metetra
.855 .776 .773 r
.66204 .51695 .68392 .54536 .7265 .48406 .70563 .46014 Metetra
.864 .809 .794 r
.70563 .46014 .7265 .48406 .76895 .42893 .74902 .40694 Metetra
.841 .828 .835 r
.74902 .40694 .76895 .42893 .81211 .3865 .79289 .36393 Metetra
.789 .822 .878 r
.79289 .36393 .81211 .3865 .85644 .35613 .83776 .33172 Metetra
.734 .796 .902 r
.83776 .33172 .85644 .35613 .90202 .33389 .8838 .30758 Metetra
.51 .725 .97 r
.26349 .48155 .28885 .50155 .32681 .49751 .30162 .47913 Metetra
.313 .655 .971 r
.30162 .47913 .32681 .49751 .36513 .50141 .34015 .48409 Metetra
.016 .485 .874 r
.34015 .48409 .36513 .50141 .40404 .51607 .37933 .4977 Metetra
0 .338 .769 r
.37933 .4977 .40404 .51607 .44395 .54111 .41955 .51831 Metetra
0 .377 .827 r
.41955 .51831 .44395 .54111 .48539 .57025 .46124 .54012 Metetra
.287 .534 .913 r
.46124 .54012 .48539 .57025 .52854 .59142 .50456 .55391 Metetra
.565 .627 .873 r
.50456 .55391 .52854 .59142 .57298 .59165 .54918 .55073 Metetra
.704 .672 .816 r
.54918 .55073 .57298 .59165 .61776 .56505 .59438 .52664 Metetra
.781 .713 .788 r
.59438 .52664 .61776 .56505 .66204 .51695 .63945 .48512 Metetra
.828 .759 .786 r
.63945 .48512 .66204 .51695 .70563 .46014 .68409 .43497 Metetra
.85 .806 .807 r
.68409 .43497 .70563 .46014 .74902 .40694 .72851 .38552 Metetra
.841 .839 .844 r
.72851 .38552 .74902 .40694 .79289 .36393 .77322 .34283 Metetra
.802 .843 .882 r
.77322 .34283 .79289 .36393 .83776 .33172 .81869 .30876 Metetra
.751 .821 .907 r
.81869 .30876 .83776 .33172 .8838 .30758 .8652 .28212 Metetra
.444 .726 .986 r
.23714 .46362 .26349 .48155 .30162 .47913 .27544 .46288 Metetra
.253 .651 .964 r
.27544 .46288 .30162 .47913 .34015 .48409 .31425 .46797 Metetra
.066 .537 .897 r
.31425 .46797 .34015 .48409 .37933 .4977 .35382 .47869 Metetra
.041 .492 .885 r
.35382 .47869 .37933 .4977 .41955 .51831 .39449 .49272 Metetra
.223 .543 .928 r
.39449 .49272 .41955 .51831 .46124 .54012 .43656 .50548 Metetra
.45 .592 .902 r
.43656 .50548 .46124 .54012 .50456 .55391 .48011 .51104 Metetra
.594 .616 .843 r
.48011 .51104 .50456 .55391 .54918 .55073 .52489 .5042 Metetra
.681 .642 .804 r
.52489 .5042 .54918 .55073 .59438 .52664 .57041 .48278 Metetra
.742 .68 .791 r
.57041 .48278 .59438 .52664 .63945 .48512 .61614 .44866 Metetra
.789 .731 .798 r
.61614 .44866 .63945 .48512 .68409 .43497 .66177 .40685 Metetra
.821 .789 .822 r
.66177 .40685 .68409 .43497 .72851 .38552 .7073 .36333 Metetra
.828 .838 .855 r
.7073 .36333 .72851 .38552 .77322 .34283 .753 .32283 Metetra
.807 .86 .889 r
.753 .32283 .77322 .34283 .81869 .30876 .79922 .28781 Metetra
.768 .85 .913 r
.79922 .28781 .81869 .30876 .8652 .28212 .84627 .25862 Metetra
.39 .733 .991 r
.20967 .44808 .23714 .46362 .27544 .46288 .24825 .44775 Metetra
.278 .681 .971 r
.24825 .44775 .27544 .46288 .31425 .46797 .2875 .45087 Metetra
.242 .643 .961 r
.2875 .45087 .31425 .46797 .35382 .47869 .32764 .45643 Metetra
.319 .635 .964 r
.32764 .45643 .35382 .47869 .39449 .49272 .3689 .4624 Metetra
.446 .627 .93 r
.3689 .4624 .39449 .49272 .43656 .50548 .41143 .46589 Metetra
.547 .613 .87 r
.41143 .46589 .43656 .50548 .48011 .51104 .45525 .4638 Metetra
.614 .609 .822 r
.45525 .4638 .48011 .51104 .52489 .5042 .50018 .45368 Metetra
.663 .621 .797 r
.50018 .45368 .52489 .5042 .57041 .48278 .54594 .43451 Metetra
.705 .65 .793 r
.54594 .43451 .57041 .48278 .61614 .44866 .59217 .40711 Metetra
.744 .696 .806 r
.59217 .40711 .61614 .44866 .66177 .40685 .63863 .3738 Metetra
.778 .755 .832 r
.63863 .3738 .66177 .40685 .7073 .36333 .68521 .33766 Metetra
.797 .813 .865 r
.68521 .33766 .7073 .36333 .753 .32283 .732 .30163 Metetra
.795 .855 .895 r
.732 .30163 .753 .32283 .79922 .28781 .77917 .26784 Metetra
.774 .867 .918 r
.77917 .26784 .79922 .28781 .84627 .25862 .82697 .23738 Metetra
.427 .756 .995 r
.18118 .43271 .20967 .44808 .24825 .44775 .22027 .43044 Metetra
.418 .735 .991 r
.22027 .43044 .24825 .44775 .2875 .45087 .26015 .42933 Metetra
.454 .712 .978 r
.26015 .42933 .2875 .45087 .32764 .45643 .30098 .42847 Metetra
.509 .679 .942 r
.30098 .42847 .32764 .45643 .3689 .4624 .34287 .42662 Metetra
.559 .645 .891 r
.34287 .42662 .3689 .4624 .41143 .46589 .38588 .42236 Metetra
.596 .619 .845 r
.38588 .42236 .41143 .46589 .45525 .4638 .42999 .41439 Metetra
.626 .609 .813 r
.42999 .41439 .45525 .4638 .50018 .45368 .47509 .40174 Metetra
.652 .613 .798 r
.47509 .40174 .50018 .45368 .54594 .43451 .52103 .38401 Metetra
.677 .633 .798 r
.52103 .38401 .54594 .43451 .59217 .40711 .56761 .3615 Metetra
.704 .667 .811 r
.56761 .3615 .59217 .40711 .63863 .3738 .61469 .33507 Metetra
.731 .713 .834 r
.61469 .33507 .63863 .3738 .68521 .33766 .66215 .30599 Metetra
.752 .766 .864 r
.66215 .30599 .68521 .33766 .732 .30163 .70998 .27566 Metetra
.763 .815 .894 r
.70998 .27566 .732 .30163 .77917 .26784 .75822 .24537 Metetra
.76 .849 .918 r
.75822 .24537 .77917 .26784 .82697 .23738 .807 .21606 Metetra
.534 .765 .982 r
.15209 .41337 .18118 .43271 .22027 .43044 .19184 .4074 Metetra
.551 .739 .964 r
.19184 .4074 .22027 .43044 .26015 .42933 .23244 .40131 Metetra
.573 .707 .933 r
.23244 .40131 .26015 .42933 .30098 .42847 .27395 .39458 Metetra
.592 .674 .897 r
.27395 .39458 .30098 .42847 .34287 .42662 .31642 .38667 Metetra
.608 .645 .862 r
.31642 .38667 .34287 .42662 .38588 .42236 .35986 .37701 Metetra
.621 .626 .834 r
.35986 .37701 .38588 .42236 .42999 .41439 .40426 .36514 Metetra
.634 .617 .815 r
.40426 .36514 .42999 .41439 .47509 .40174 .44955 .35073 Metetra
.647 .618 .807 r
.44955 .35073 .47509 .40174 .52103 .38401 .49568 .33365 Metetra
.661 .63 .807 r
.49568 .33365 .52103 .38401 .56761 .3615 .54254 .31398 Metetra
.677 .651 .817 r
.54254 .31398 .56761 .3615 .61469 .33507 .59007 .29197 Metetra
.694 .681 .834 r
.59007 .29197 .61469 .33507 .66215 .30599 .63819 .26807 Metetra
.71 .718 .856 r
.63819 .26807 .66215 .30599 .70998 .27566 .68687 .2428 Metetra
.722 .759 .882 r
.68687 .2428 .70998 .27566 .75822 .24537 .73611 .2167 Metetra
.729 .796 .905 r
.73611 .2167 .75822 .24537 .807 .21606 .78593 .1903 Metetra
.606 .737 .938 r
.12274 .38764 .15209 .41337 .19184 .4074 .16317 .37791 Metetra
.613 .713 .916 r
.16317 .37791 .19184 .4074 .23244 .40131 .20441 .36766 Metetra
.619 .688 .893 r
.20441 .36766 .23244 .40131 .27395 .39458 .2465 .3567 Metetra
.625 .666 .87 r
.2465 .3567 .27395 .39458 .31642 .38667 .28945 .34482 Metetra
.63 .649 .85 r
.28945 .34482 .31642 .38667 .35986 .37701 .33327 .33183 Metetra
.635 .637 .835 r
.33327 .33183 .35986 .37701 .40426 .36514 .37795 .31759 Metetra
.64 .631 .825 r
.37795 .31759 .40426 .36514 .44955 .35073 .42348 .30199 Metetra
.647 .631 .82 r
.42348 .30199 .44955 .35073 .49568 .33365 .46982 .28498 Metetra
.654 .637 .821 r
.46982 .28498 .49568 .33365 .54254 .31398 .51696 .26657 Metetra
.662 .649 .827 r
.51696 .26657 .54254 .31398 .59007 .29197 .56485 .24684 Metetra
.672 .667 .837 r
.56485 .24684 .59007 .29197 .63819 .26807 .61347 .22591 Metetra
.681 .689 .851 r
.61347 .22591 .63819 .26807 .68687 .2428 .6628 .20393 Metetra
.69 .715 .868 r
.6628 .20393 .68687 .2428 .73611 .2167 .71284 .18108 Metetra
.697 .742 .886 r
.71284 .18108 .73611 .2167 .78593 .1903 .76358 .15758 Metetra
.635 .71 .901 r
.09313 .35645 .12274 .38764 .16317 .37791 .13412 .34389 Metetra
.636 .694 .887 r
.13412 .34389 .16317 .37791 .20441 .36766 .17589 .33083 Metetra
.638 .68 .873 r
.17589 .33083 .20441 .36766 .2465 .3567 .21845 .31721 Metetra
.639 .668 .861 r
.21845 .31721 .2465 .3567 .28945 .34482 .2618 .30295 Metetra
.641 .658 .851 r
.2618 .30295 .28945 .34482 .33327 .33183 .30597 .28799 Metetra
.643 .652 .844 r
.30597 .28799 .33327 .33183 .37795 .31759 .35095 .27229 Metetra
.646 .648 .838 r
.35095 .27229 .37795 .31759 .42348 .30199 .39675 .25581 Metetra
.649 .648 .836 r
.39675 .25581 .42348 .30199 .46982 .28498 .44337 .23853 Metetra
.652 .651 .836 r
.44337 .23853 .46982 .28498 .51696 .26657 .4908 .22045 Metetra
.656 .658 .839 r
.4908 .22045 .51696 .26657 .56485 .24684 .53904 .20158 Metetra
.661 .667 .845 r
.53904 .20158 .56485 .24684 .61347 .22591 .58809 .18194 Metetra
.666 .679 .853 r
.58809 .18194 .61347 .22591 .6628 .20393 .63795 .16157 Metetra
.671 .693 .862 r
.63795 .16157 .6628 .20393 .71284 .18108 .68862 .14052 Metetra
.676 .709 .873 r
.68862 .14052 .71284 .18108 .76358 .15758 .74011 .11884 Metetra
.646 .698 .884 r
.06303 .32212 .09313 .35645 .13412 .34389 .10448 .30772 Metetra
.647 .69 .876 r
.10448 .30772 .13412 .34389 .17589 .33083 .14667 .29291 Metetra
.647 .682 .869 r
.14667 .29291 .17589 .33083 .21845 .31721 .18962 .27767 Metetra
.647 .676 .863 r
.18962 .27767 .21845 .31721 .2618 .30295 .23334 .26197 Metetra
.648 .671 .858 r
.23334 .26197 .2618 .30295 .30597 .28799 .27785 .24578 Metetra
.649 .668 .855 r
.27785 .24578 .30597 .28799 .35095 .27229 .32316 .2291 Metetra
.65 .666 .852 r
.32316 .2291 .35095 .27229 .39675 .25581 .36927 .2119 Metetra
.651 .666 .851 r
.36927 .2119 .39675 .25581 .44337 .23853 .41621 .19417 Metetra
.653 .667 .851 r
.41621 .19417 .44337 .23853 .4908 .22045 .46398 .17591 Metetra
.655 .67 .853 r
.46398 .17591 .4908 .22045 .53904 .20158 .5126 .1571 Metetra
.657 .675 .855 r
.5126 .1571 .53904 .20158 .58809 .18194 .56207 .13776 Metetra
.66 .681 .859 r
.56207 .13776 .58809 .18194 .63795 .16157 .61241 .11788 Metetra
.662 .688 .864 r
.61241 .11788 .63795 .16157 .68862 .14052 .66363 .09746 Metetra
.665 .697 .87 r
.66363 .09746 .68862 .14052 .74011 .11884 .71575 .07653 Metetra
.652 .698 .88 r
.03218 .28654 .06303 .32212 .10448 .30772 .07401 .27095 Metetra
.652 .693 .876 r
.07401 .27095 .10448 .30772 .14667 .29291 .11658 .25501 Metetra
.652 .69 .873 r
.11658 .25501 .14667 .29291 .18962 .27767 .15989 .23872 Metetra
.652 .687 .87 r
.15989 .23872 .18962 .27767 .23334 .26197 .20396 .22204 Metetra
.652 .685 .868 r
.20396 .22204 .23334 .26197 .27785 .24578 .24882 .20499 Metetra
.653 .683 .866 r
.24882 .20499 .27785 .24578 .32316 .2291 .29448 .18753 Metetra
.653 .682 .865 r
.29448 .18753 .32316 .2291 .36927 .2119 .34095 .16968 Metetra
.654 .682 .864 r
.34095 .16968 .36927 .2119 .41621 .19417 .38826 .1514 Metetra
.655 .683 .864 r
.38826 .1514 .41621 .19417 .46398 .17591 .43642 .13271 Metetra
.656 .684 .865 r
.43642 .13271 .46398 .17591 .5126 .1571 .48545 .11358 Metetra
.657 .686 .866 r
.48545 .11358 .5126 .1571 .56207 .13776 .53536 .09401 Metetra
.658 .689 .868 r
.53536 .09401 .56207 .13776 .61241 .11788 .58618 .07399 Metetra
.659 .693 .87 r
.58618 .07399 .61241 .11788 .66363 .09746 .63793 .05352 Metetra
.66 .697 .873 r
.63793 .05352 .66363 .09746 .71575 .07653 .69063 .03259 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{272.125, 204.5},
  ImageMargins->{{Inherited, 0}, {0, 3.3125}},
  ImageRegion->{{0.07, 1}, {0, 0.97}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@0000c1000`40O003h00Oogoo4Goo003oOolA
Ool00?mooa5oo`00ogoo4Goo003oOolAOol00=1oo`@003aoo`00d7oo00<007ooOol0?Goo003AOol0
0`00Oomoo`0lOol00<Yoo`@000Aoo`03001oogoo03]oo`00d7oo00@007ooOol003aoo`00dGoo0P00
?Goo002UOol4000LOol20019Ool00:Eoo`03001oogoo01]oo`800003Ool0000004Qoo`00YWoo00<0
07ooOol05goo0`000goo0P00B7oo002WOol00`00Oomoo`0COol30006Ool00`00Ool00017Ool00:Eo
o`04001oogoo000BOol20009Ool01000Oomoo`00AWoo002VOol2000@Ool3000;Ool01000Oomoo`00
AWoo002fOol200000goo001oo`0;Ool01@00Oomoogoo0000AGoo001WOol2001:Ool3000@Ool20003
Ool00`00Oomoo`12Ool006Moo`8004Qoo`80015oo`800003D]/00000009oo`03001oogoo049oo`00
IWoo00@007ooOol004Aoo`<0015oo`8000=B^`8000=oo`03001oogoo045oo`00IGoo0P000Woo0P00
@7oo0`004Goo0`0000QBfe:kD]]B^U;K001Bf`000goo00<007ooOol0@7oo002YOol200000goo001o
o`0?Ool20008D[/00`00D[/00003Ool00`00Oomoo`10Ool00:Ioo`<000=oo`03001oogoo00]oo`<0
000>D[]Bfe:jD]]B^e;KD[YBfe:kD]/005;KD[/0009oo`80045oo`00Y7oo0P004Goo0`000U:k00<0
05:kD[/025:k00D005:kD[]B^`0000=oo`03001oogoo03ioo`00XGoo0`0047oo0`0001EB^U:kD[YB
fe:j001B^U;KD[]Bfe:jD]]B^e;KD[YBf`00D]]B^U;K00000goo00<007ooOol0?Woo002OOol2000@
Ool30009D[/00`00D[]B^`07D[/00`00D[]B^`02D[/01@00Oomoogoo0000?goo002LOol4000>Ool3
000075:jD[]B^U;KD[YB^e:jD]]B^U:kD[YBf`00D]]B^U;KD[]Bfe:jD]]B^e;K001Bfe:kD]]B^P00
17oo00<007ooOol0?7oo002IOol3000@Ool20002D[/00`00D[]B^`0;D[/00`00D[]B^`06D[/00`00
D[]B^`02D[/20003Ool2000mOol009Moo`80015oo`80000ND[]B^U:kD[X005:jD]]B^U:kD[YBfe:j
D[]B^U;KD[YB^e:jD]/005;KD[YBfe:kD]]B^U;K001Bfe:j0P0000=Ffe:j00000Woo0P00?Goo002D
Ool3000AOol20007D[/00`00D[]B^`0;D[/00`00D[]B^`05D[/30004D[/00`00Oomoo`02Ool00`00
Oomoo`0jOol007=oo`8001eoo`80019oo`80000MD[]B^U:kD[YB^e:jD[]B^U:k001B^e:jD]]B^U:k
D[YBfe:jD[]B^U;KD[YB^e:j001B^e;KD[YBf`03000025KKD[YFfe:jE]]B^UKK0003Ool00`00Oomo
o`0jOol0079oo`04001oogoo000IOol4000@Ool3000<D[/00`00D[]B^`0;D[/00`00D[]B^`020003
D[/00`00D[]B^`04D[/00`00Oomoo`02Ool00`00Oomoo`0iOol0079oo`04001oogoo000FOol3000A
Ool300007E:jD[/005:kD[YB^e:jD[]B^U:kD[YB^e:jD[]B^U:k001B^e:jD]]B^U:kD[YBfe:jD[]B
^U;KD[X00`0000iB^UKKD[YFfe:j001B^UKKD[YFfe:jE]]B^P0017oo00<007ooOol0>7oo001bOol0
1000Oomoo`0057oo0P004Woo0P000U:k00AB^U:kD[/000eB^`03001B^e:k00MB^`<0009B^`03001B
^e:k00=B^`03001B^e:k00EB^`03001oogoo009oo`03001oogoo00]oo`D002Qoo`00LWoo00@007oo
Ool0015oo`<0015oo`<0000LD[]BVU:kD[YB^e:JD[]B^P00D[YB^e:jD[]B^U:kD[YB^e:jD[]B^U:k
D[X005:jD[]B^U;KD[X300005E:jD[]B^UJkD[X005:jE]]B^UKKD[X005:jE]]B^UKKD[YFfe:jE]/0
0004Ool00`00Oomoo`0<Ool00`00Oomoo`0XOol007=oo`80011oo`80015oo`<00003D[]B^U:k009B
^`07D[YB^e:kD[]B^U:k00003E:k00<005:kD[/00`000U:k00EB^U:kD[]B^e:j009B^`03001B^e:k
009B^`03001B^e:k00IB^`03001oogoo009oo`03001oogoo00aoo`03001oogoo02Qoo`00PWoo1000
47oo0P0001aB^djJ001B^U:kDYYB^e:jD[]BVU:kD[YB^e:JD[/005:kD[YB^e:jD[]B^U:kD[YB^e:j
D[]B^P<0000LD[YB^e:jE[]B^U:kD[YF^e:jD[]B^UJk001Ffe:jE]]B^P00D[YFfe:jE]]B^UKKD[YF
fe:j0004Ool00`00Oomoo`03Ool40004Ool00`00Oomoo`0XOol0081oo`80019oo`800005D[YB^e:k
D[/00003D[/01E:jD[]B^e:kD[X00e:k00=B^U:k00002E:k0P0000=B^U:k00000e:k00EB^U:kD[]B
^e:j00=B^`03D[YB^`0000=B^`03001B^e:k00IB^`8000Eoo`03001oogoo00Yoo`03001oogoo02Qo
o`00OGoo0`004Woo0P0001aB^e:jD[]>VU:kD[YB^`00D[]B^U:kDYYB^e:jD[]BVU:kD[YB^e:J001B
^U:kD[YB^e:jD[]B^P80000MD[]BVU:kDYX005:jE[]B^U:kD[YF^e:jD[]B^UJkD[YB^e:j001B^UKK
D[X005:jE]]B^UKKD[YFf`0200000e:kE]/00004Ool2000:Ool2000ZOol007Yoo`<001=oo`80009B
^`05D[YB^e:kD[]B^P02D[/00`00D[YB^`02D[/01E:jD[]B^e:kD[X00e:k00=B^P00D[/00e:k0P00
0e:j00IB^e:jD[YB^P00D[X3D[/01E:jD[]B^e:kD[X00e:k00EB^P00D[]B^`0000AB^`800005E]]B
^eKKE]/00004Ool2000fOol007Qoo`8001=oo`<0000LD[]>VU:kD[YB^djJD[]B^U:kCYYB^e:j001B
VU:kD[YB^e:JD[]B^U:kDYYB^e:jD[/005:kD[X2000075:kDYYB^e:JD[]BVU:kDYYB^`00D[]B^UJk
D[YB^e:jE[]B^U:kD[YF^e:jD[/005KKD[X005:j0`0000QB^UKKD[]Ffe:jE]]B^`001Goo00<007oo
Ool0<goo001eOol300000goo001oo`0?Ool300000e:kD[X00002D[/01E:jD[]B^e:kD[X00e:k00EB
^U:kD[/005:j00=B^`05D[YB^e:kD[]B^P02D[/300000e:jD[]B^P02D[X01E:kD[YB^U:jD[/00U:j
00<005:kD[X00e:k00EB^U:kD[]B^e:j00=B^`05001B^`00001B^`03E]/01E:kE]]FfeKKD[/00UKK
00<007ooOol00Woo00<007ooOol0<goo001cOol2000COol2000075:kCYYB^e:JD[/005:kD[YB^djJ
D[]B^U:kCYYB^e:jD[]>VU:k001B^e:JD[]B^U:kDYYB^e:j0`0001aBVU:k001B^e:JD[]BVU:kDYYB
^e:JD[]BVU:kDYYB^`00D[]B^UJkD[YB^e:jE[]B^U:kD[YF^`@0000=D[]Ffe:jE]]B^eKKD[YFfe:k
E]]B^UKK00001Goo00<007ooOol0<Woo001`Ool3000BOol300001E:jD[]B^e:kD[X00e:k00D005:k
D[]B^e:j00=B^`09D[YB^e:kD[]B^U:k001B^e:j00=B^`800006DYYB^U:JD[YBVP000e:j00EB^e:j
D[YB^U:k00=B^P03D[]B^P00009B^`06D[YB^e:kD[]B^U:k0`0000AB^e:j000000=Ff`05D[]FfeKK
E]]B^`03E]/00e:kE]/00005Ool00`00Oomoo`0aOol006ioo`80019oo`<0000LCYYB^e:JD[]>VU:k
DYYB^djJD[]BVU:k001B^e:jD[]>VU:kD[YB^djJD[]B^U:kCYX005:jD[/3000075:kDYYB^e:JD[]B
VU:kDYX005:JD[]BVU:kDYYB^e:JD[]BVU:kDYYB^e:J001B^U:kD[YF^e:j0P0000EFfe:jE[]B^UKK
0080000>D[YFfe:kE]]B^UKKD[]Ffe:jE]]B^eKKD[X000Eoo`03001oogoo035oo`00Jgoo0`004Goo
0`0000EB^U:k001B^e:j00=B^`05D[YB^e:kD[]B^P02D[/00`00D[YB^`02D[/01E:jD[]B^e:kD[X0
0e:k0`0000eB^U:JD[YBVU:jDYYB^U:JD[YBVU:j001B^`03D[X01E:kD[YB^U:jD[/00e:j00AB^`00
D[]B^`<00008D[YF^e:jD[]B^UJkD[YB^`800005D[]FfeKKE]]B^`03E]/01U:kE]]FfeKKD[/000Eo
o`03001oogoo031oo`00J7oo0`000Woo00<007ooOol03Goo0P0001a>VU:kDYYB^djJ001BVU:kCYYB
^e:JD[]>VU:kDYYB^djJD[]BVP00CYYB^e:jD[]>VU:kD[YB^`<0000LD[]>VP00DYYB^e:JD[]BVU:k
DYYB^e:JD[]BVU:k001B^e:JD[]BVU:kDYYB^e:JD[]BVU:kDYX3000065:jE[]B^UKKD[YF^e:jE]]B
^UJkD[YFf`00E]]B^UKKD[]Ffe:jE]]B^eKKD[YFf`800003E]/007oo00Aoo`03001oogoo02moo`00
IWoo0P004Woo0`000e:k00IB^U:kD[]B^e:j0002D[/01E:jD[]B^e:kD[X00e:k00EB^U:kD[/005:j
00=B^`04D[X00000D[X3DYX04E:j001B^U:JD[YBVU:jDYYB^U:JD[YBVU:jDYYB^P00D[/00e:j00EB
^e:jD[YB^U:k0080009B^P0>001B^e:jE[]B^U:kD[YF^e:jD[]B^UJkD[X0009Ff`05D[]FfeKKE]]B
^`02E]/20003E_/00`00Oomoo`03Ool00`00Oomoo`0_Ool006=oo`<0015oo`<0000LD[]BVU:kCYYB
^e:JD[]>VU:kDYYB^`00D[]BVU:kCYYB^e:JD[]>VU:kDYYB^djJD[/005:kCYX300007DjJD[]BVU:k
CYYB^e:JD[/005:kDYYB^e:JD[]BVU:kDYYB^e:JD[]BVP00DYYB^e:JD[]BVU:kDYX00P00015F^e:J
E[]BVP00D[YFfe:jE[]B^UKKD[YF^e:jE]]B^UJk00800006D[]Ffe:jE]]B^eKK0P0000MFfe[lE]]J
o5KKF_`00005Ool00`00Oomoo`0^Ool0049oo`@001]oo`80015oo`<0009B^`03001B^U:k009B^`05
D[YB^e:kD[]B^P03D[/01@00D[]B^e:kD[X00e:k00EB^U:kD[]B^e:j00<000=BVP05D[YBVU:JDYYB
^P03DYX04@00DYYB^U:JD[YBVU:jDYYB^U:JD[YBVU:jDYX005:jD[/00U:j0P0000EBVU:jD[YB^U:J
009B^P0?001B^U:kD[YF^e:jD[]B^UJkD[YB^e:j001B^P00009Ff`05D[/00000E_]Ff`03E_/01EKK
E_]FneKk000017oo0P00;goo0012Ool00`00Oomoo`0IOol4000@Ool200007E:kDYYB^djJD[/005:k
CYYB^e:JD[]>VU:kDYYB^djJD[]BVU:k001B^e:JD[]>VU:kDYYB^djJD[/00P0001m>VU:k001B^djJ
D[]BVU:kCYYB^e:JD[]>VU:kDYX005:JD[]BVU:kDYYB^e:JD[]BVU:kDYYB^`00D[]BVP0200006EJk
DYYF^e:JE[]BVUJkDYYF^`00E[]B^UKKD[YF^e:jE]]B^UJkD[YFf`00E[/005KK0080000<E]]Jo5KK
F_aFfe[lE]]Jo5KKF_aFf`001Goo00<007ooOol0;Goo0013Ool00`00Oomoo`0EOol3000AOol30002
D[/02E:jD[]B^e:kD[YB^`00D[]B^P03D[/01E:jD[]B^e:kD[X00U:k00<005:jD[/00U:k00=B^U:k
D[/00P0015:J00<005:JD[X00e:J00EB^U:JDYYBVU:j00=BVP0<001BVU:jDYYB^U:JD[YBVU:jDYYB
^U:J0`000U:j00EBVU:jD[YB^U:J00=B^P0?DYYB^P00E[]B^U:kD[YF^e:jD[]B^UJkD[X005:j0080
00=Fn`05E]]FneKkE_]Ff`03E_/015KKE_]Fn`001Goo00<007ooOol0;7oo000lOol40004Ool00`00
Oomoo`0BOol2000AOol300007U:JD[]>VU:kDYYB^djJD[]BVU:kCYX005:JD[]>VU:kDYYB^djJD[]B
VU:kCYYB^e:J001>VU:kDYYB^`80000MDYYB^TjJD[]BVU:jCYX005:JD[]>VU:kDYYB^djJD[]BVU:k
CYYB^`00D[]BVU:kDYYB^e:JD[]BVP0300006U:JD[X005JkDYYF^e:JE[]BVUJkDYYF^e:JE[]BVUJk
001F^e:jE]]B^UJkD[YFfe:jE[/200004EKJE]/005[lE]]Jo5KKF_aFfe[lE]]Jo5KKF_aFfe[l0000
1Woo00<007ooOol0:goo0012Ool01000Oomoo`0047oo0`004Goo0P000U:k00D005:kD[]B^e:j00=B
^`06D[YB^e:kD[]B^P000U:k00EB^U:kD[]B^e:j00=B^`05D[YB^`00D[]B^P020009DYX01000DYYB
VU:j0e:J00EB^U:JDYYBVU:j009BVP06001B^U:JD[YBVU:j0P001E:J00<005:JD[X00U:j00EBVU:j
D[YB^U:J00=B^P09DYX005:jE[]B^U:kD[YF^e:j00<000=Ff`03001FfeKk009Fn`05E]]FneKkE_]F
f`03E_/00eKKE_/00005Ool00`00Oomoo`0IOol3000?Ool004=oo`8000moo`80015oo`<0000ND[]>
VU:kDYYB^`00D[]BVU:kCYYB^e:JD[]>VU:kDYYB^djJ001BVU:kCYYB^e:JD[]>VU:kDYYB^djJ0`00
01a>VU:kDYYB^TjJD[]BVU:jCYYB^e:JD[X005:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VP00DYYB^`<0
000KD[YBVUJjDYYB^U:JE[YBVP00DYYF^e:JE[]BVUJkDYYF^e:JE[]BVUJkDYX005:jE[]B^UKK0080
000CE[YFf`00E]]F^UKKE]X005KKF_aFfe[lE]]Jo5KKF_aFfe[lE]/00P0000=O?000Ool00goo0P00
6Woo00<007ooOol03goo001AOol30002Ool00`00Oomoo`0<Ool200000e:kD[YB^`02D[/01E:jD[]B
^`00D[X00e:k00EB^U:kD[]B^e:j00=B^`05001B^e:kD[]B^P03D[/015:j000000000U:J00<005:J
DYX02U:J00D005:JDYYBVU:j00=BVP05D[YBVU:JDYYB^P03000;DYX00`00D[YBVP03D[X01E:JD[YB
^U:jDYX00e:j00<005:kD[X00P0015KK00<005KKE]/00eKK00<005KKE_/00UKk00AFfeKkE_]Fn`80
0005FaaK?5/LFa`00005Ool00`00Oomoo`0GOol00`00Oomoo`0?Ool004moo`80015oo`<0000NCYYB
^e:JD[]>VU:kDYYB^djJD[]BVP00CYYB^e:JD[]>VU:kDYYB^djJD[]BVU:k001B^e:JD[]>VU:k0P00
01e>VU:kCYYB^TjJ001BVU:jCYYB^e:JD[Y>VU:kDYYB^TjJD[]BVP00CYYB^e:JD[]>VU:kDYYB^djJ
0080000LDYY>V@00DYYB^U:JE[YBVU:jDYYF^U:JD[YBVUJj001F^e:JE[]BVUJkDYYF^e:JE[]BVUJk
DYX300004eKJE]]F^UKKE]YFf`00E]]FfUKKE[YFf`00F_aFfe[lE]]Jo5KK00800008GcaK6ellFaaO
?5/KGc`000Aoo`03001oogoo01Qoo`03001oogoo00ioo`00C7oo0`004Goo0P000U:k00<005:kD[X0
0e:k00EB^U:kD[]B^e:j009B^`03001B^U:k009B^`05D[YB^e:kD[]B^P02D[/00`00D[YB^`030008
DYX00`00DYYBVP0:DYX00`00D[YBVP02DYX00e:jDYYBVP020004DYX00`00DYYBVP0:DYX01000D[YB
^U:J0e:j00ABVU:jD[YB^P80009F^P03001FfeKK00AFf`03001FfeKK00AFf`04001FneKKE_/20003
Fa`01e/lFaaK75/LFcaK700000Eoo`03001oogoo01Eoo`@000moo`00BGoo0`004Goo0`0001eB^djj
D[]>VU:k001B^djJD[]BVU:kCYYB^e:JD[]>VU:kDYX004jJD[]BVU:kCYYB^e:JD[]>VU:k00<0000N
D[]>VU:jCYYB^djJD[Y>VU:kCYYB^P00D[]BVU:jCYYB^e:JD[Y>VU:kDYYB^TjJD[/005:kCYYB^e:J
0P0001aBVU:IDYY>VE:JDYUBVP00E[YBVU:jDYYF^U:JD[YBVUJjDYYB^U:J001BVUJkDYYF^e:JE[]B
VP80000DE[YB^UJkD[X005JjE]]FfUKKE[YFf`00E]]F^UKKE]YFfeJj001Ff`80000=GcaK75llFa]O
?5/LGcaK6ellFaaO?5/K00001Goo00<007ooOol01Goo0P0087oo0017Ool200000goo001oo`0?Ool2
0008D[/01000D[]B^e:j0e:k00UB^U:kD[]B^e:jD[/005:kD[X00e:k00=B^U:k00000P000U:J00<0
05:JDYX02U:J00<005:JDYX02U:J00<005:JD[X00P002E:J00<005:JDYX02U:J00D005:jD[YB^U:J
00<000MF^P03001FfeKK00AFf`03001FfeKK00AFf`03001K75/l00=K7005FcaK75/LFaaK?003Fa`0
0e/lFa`00004Ool00`00Oomoo`04Ool01000Oomoo`007goo0014Ool30004Ool00`00Oomoo`0:Ool3
00006djjD[]>VU:kC[YB^djJD[]>^U:kCYX005:JD[]>VU:kDYYB^djJD[]BVU:kCYYB^`00D[]>VP04
00007e:kCYYB^djJD[/005:jCYYB^djJD[Y>VU:kCYYB^TjJD[]>VU:j001B^e:JD[Y>VU:kDYYB^TjJ
D[]BVU:j00<0000KDYY>VE:JDYUBVTjIDYYBVE:JCYUBVU:I001BVUJjDYYB^U:JE[YBVU:jDYYF^U:J
D[X005Jk0080000FD[YF^e:jE[YB^UJkD[YF^U:jE[/005KKE[YFfeKJE]]F^P00E]YFfeJjE]/20000
3U[k001K75llFa]O?5/LGcaK6ellFaaO?5/KGc`200000emL001oo`03Ool00`00Oomoo`03Ool01000
Oomoo`007goo0012Ool2000BOol20002D[/00`00D[]B^`0:D[/01000D[]B^e:j0e:k00EB^U:kD[]B
^e:j00<000YBVP03001BVU:J00YBVP03001BVU:J00IBVP<0009BVP03001BVU:J00YBVP03001BVU:J
00YBVP8000eF^P03001FfeKK00=Ff`03001FfeKK008000AJn`03001K75/l00=K7004FcaK75/LFa`2
0002Ge`015mMGe`000000goo00<007ooOol00Woo00@007ooOol001moo`00?goo0`004Goo0`0001]B
^djJD[]>^U:k001B^djjD[]>VU:kC[YB^djJD[]>^U:kCYX005:JD[]>VU:kDYYB^djJD[/00P00025>
VU:k001B^djJD[]>VU:kCYYB^djJD[]>VU:k001B^TjJD[]>VU:jCYYB^djJD[Y>VU:kCYX004jJD[]B
VU:jCYX00P0001eBVTiiDYY>NE:J001BVU:IDYY>VE:JDYUBVTjIDYYBVE:JCYUBVP00D[YBVUJjDYYB
^U:JE[YBVU:j0080000EDYT005:jE[]B^UJjD[YF^e:jE[YB^UJkD[YF^U:j001FfUKKE[YFfeKJ00<0
000>F_]K6e[kFaaJne/KF_/005/LGcaK6ellFaaO?0800009GeaSGEmLHgeOG6=MGeaSO@00009oo`03
001oogoo009oo`04001oogoo000OOol003eoo`80019oo`8000QB^`03001B^e:k00YB^`06001B^e:k
D[]B^U:k0`000U:J00=B^U:J000035:J00<005:JDYX02E:J00<005:JDYX00`0025:J00<005:JDYX0
2U:J00<005:JDYX01E:J0P0000AFVU:JEYX000iF^P04001FfeKKE]/20009F_/01@00FaaK75/lFa`0
0P0000EOGEmLGeaOG5mM00=OG004GeeOG5mL0002Ool20003Ool2000POol003Yoo`<0009oo`03001o
ogoo00aoo`<0000KCYYB^djjD[]>VU:kC[YB^djJD[]>^P00CYYB^djjD[]>VU:kC[YB^djJD[]>^U:k
001B^e:J0080000PD[]>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^TjJ
D[]>VU:jCYYB^djJD[Y>VP<0000NCWUBVTiiDYY>NE:JCWUBVTiiDYY>N@00CYUBVU:IDYY>VE:JDYUB
VTjIDYYBVE:JCYT005:JD[YBVUJj0P0001IBVEJjDYUF^U:IE[X005JjD[YF^e:jE[YB^UJkD[YF^U:j
E[]B^UJj001Ff`80000>F_/005[kFa]Jne/LF_]K6e[kFaaJne/K001O?080000;GeaSOEmLHeeOG6=m
GeaSGEmLHgeOG00200000f=m00000002000UOol003Moo`<0015oo`<0009B^`03001B^e:k00YB^`03
001B^e:k00UB^`<00003DYYB^U:J009BVP06D[YBVU:JDYYB^P0035:J00<005:JDYX01U:J0P0000=B
NU:J000035:J00<005:JDYX02U:J00<005:JDYX00P0000YFVU:JEYYBVUJJDYYFVU:JEYX000aF^P80
009Jn`8000]Jn`04001OG5mLGed3Ge`03UmMGeaOG5mLGeeOG000HgaSOF=LHg`007oo000UOol003Eo
o`80011oo`@0000LC[YB^djkD[]>^U:k001B^djJD[]>^U:kCYYB^djjD[]>VU:kC[X004jJD[]>^U:k
CYYB^djjD[/2000084jJD[/005:kCYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYYB
^djJD[]>VP00CYYB^TjJD[/300007U:JCWUBVTii001>NE:JCWUBVTiiDYY>NE:JCWUBVTiiDYY>N@00
CYUBVU:IDYY>VE:JDYUBVTjIDYYBV@<0000FDYUF^U:IE[YBVEJjDYUF^U:IE[YBV@00D[YF^U:jE[]B
^UJjD[YF^e:jE[X200003eKJ00000000F_]K6`00FaaJne/KF_]K75[kFa]Jn`0200002f<l001SOEmL
HeeOG6=mGeaSGEmLHgd00P0000IOG6=mGeaSOEmL0002Ool00`00Oomoo`0ROol003=oo`8000moo`<0
00]B^`03001B^e:k00UB^`03001B^e:k00=B^`<00005D[]>VU:JDYX00003DYX01E:jDYYBVU:JD[X0
0e:J00=B^P00DYX02U:J00<005:JDYX00P000e:J00IBNU:JDYYBVU9j000<DYX00`00DYYBVP06DYX3
000045:IDYX005JJDYYFVU:JEYYBVUJJDYYFVU:JEYYBVP001eJj1@0000=JfP00F_/00U[k00<005[k
F_/01E[k00H005lkGcaO>f<l0002Ge`015mMGeaOG5mL0P000V=l00MSOF=LHgaSO6=mHe`00002Ool0
0`00Oomoo`0QOol003=oo`<000aoo`80000ND[]>^`00C[]B^djjD[]>^e:kC[YB^djkD[]>^U:k001B
^djJD[]>^U:kCYYB^djjD[]>VU:k001B^djJ0P00021B^djJD[]>VU:kCYYB^djJ001>VU:kCYYB^djJ
D[]>VU:kCYYB^djJ001>VU:kCYYB^djJD[]>VU:kCYYB^djJ0`0001i>NE:JCWUBVTiiDYY>NE:JCWUB
VP00DYY>NE:JCWUBVTiiDYY>NE:JCWUBVTiiDYX005:JCYUBVU:IDYX20000659iDYYBNEJJDWT005:I
E[YBVEJjDYUF^U:IE[YBVEJjDYUF^U:I001B^UJjD[YF^`@0000>E]YJfeJjF]]FfP00F_]K75[k001J
ne/LF_]K6`80000IGc]S?5lkHcaO>f<l001SOEmLHeeOG000GeaSOEmLHgeOG6=mGeaSOEmLHgeOG000
Ool00P008Woo000cOol3000:Ool20005D[/00`00D[]B^`09D[/00`00D[]B^`09D[/300001DjJDYYB
VU:kCYX00U:J00EB^djJDYX005:j00=BVP05D[YBVU:JDYYB^P03DYX00`00DYYBVP04DYX40002DYX0
1@00DYYBVU:JDWX00e:J00EBNU:JDYYBVP0000aBVP03001BVU:J00<00005DYYBVE:IDYUBVP03DYT0
3P00DYYFVU:JEYYBVUJJDYYFVU:JEYYBVUJJ0002E[X300000e[JF]]FfP02F]X01E[KE]YJfU[J0000
0e[k00l005[k000006<lGc]O?5lkHcaO>ellGc]S?000Ge`00P0000ESG6=lHgaSOF=L009SO003HgeS
G6=l00800004Ge`007oo000ROol002aoo`8000Eoo`04001oogoo0007Ool2000075;KC[]B^djkD]]>
^e:k001B^djkD[]>^U:kC[]B^djjD[]>^e:kC[X004jjD[]>VU:kC[YB^djJ0`0001e>VU:k001B^djJ
D[]>VU:kCYYB^djJD[]>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VU:k001B^djJ00@0000ODYY>NE:J
CWUBVTii001>NE:JCWUBVTiiDYY>NE:JCWUBVTiiDYX005:JCWUBVTiiDYY>NE:JCWUBVTiiDYX00`00
01UBVU9iEYYBNE:JDWUFVU9iDYYBNEJJ001F^U:IE[YBVEJjDYUF^U:IE[YBVEJjDYUF^P020000<UKJ
F]]F^U[KE]YJfeJjF]]FfU[KE[YJfeKJ001Jne/LF_/005lkHcaO>f<lGc]S?5lkHcaO>f<lGc]S?000
HgeOG6=mGeaSOEmLHgeOG6=mGeaSO@00HgeOG6=LGe`007oo000QOol002]oo`04001oogoo0003Ool3
0002Ool01000Oomoogoo0`002U:k00<005:kD[/02U:k00<005:kD[/0100000U>VU:kD[YB^djJ001B
VU:kCYX00U:J00UB^djJDYYBVU:kCYYBVP00D[X00e:J00IB^U:JDYYBVU:jDYX300001DijDYYBVU:J
CWX00e:J00E>NU:JDYX0059j00=BVP05DWYBVU:JDYYBNP02DYX00`00DYYBVP06DYX300001E:I001B
VE:IDYX00e:I00EBVU:IDYUBVE:J009BV@0:001FVU:JEYYBVUJJDYYFVU:JEYX300001UJj001JfU[J
F]]FfP9JfP09F]]FfU[JF]YJfeKJF]X005[k00<0000:HcaO>ellGc]S?5lkGcaO>f<lGc/200001VML
001SO6=lHgeSG09SO00<HgeSG000001SG5mLHeaOG6=L001oo`008Goo000[Ool01000Oomoo`000goo
00<007ooOol00goo0`0001Y>^e;K001BfdjkD[]>^e;KC[]B^djkD]]>^e:k001B^djkD[]>^U:kC[]B
^djjD[]>^e:k0`0001mB^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[]>VP00
CYYB^djJD[]>VU:kCYYB^`0200008DijDYX005:JCWUBVTiiDYY>NE:JCWUBVTiiDYX005:JCWUBVTii
DYY>NE:JCWUBVTiiDYY>N@00CWUBVTiiDYY>N@0200006E:JCWUBVU9iDYX005JJDWUBVU9iEYYBNE:J
DWUFVU9iDYYBN@00DYUF^U:IE[YBVEJj00@0000ZEYUJ^UJI001F^U[KE]YJfeJjF]]FfU[KE[YJfeKJ
F]]F^U[K001S?5lkHc`006<lGc]S?5lkHcaO>f<lGc/006=KIgaSFfMl001SOEmLHgeOG6=m0P0000]O
G6=mGeaSG5mLHgeOG6=L001oo`00021oo`00:goo00@007ooOol000=oo`H000IB^`03001B^e:k00UB
^`03001B^e:k00IB^`80000BD[]>^`00D[YB^djJD[]B^U:kCYYB^e:jD[]>VP00DYYB^djJ0U:J00UB
^djJDYYBVU:kCYX005:JD[X00U:J0`0000EBVTjJDYY>VP00009BVP05CWYBVU:JDYY>NP03DYX01Dij
DYX005:JDWX00e:J00MBNU:JDYYBVU9jDYX00002DYX30003DWT01E:IDWUBNE9i00000e:I00EBVU:I
DYUBVE:J00=BV@05DYYBV@00DYYFVP050003E[X01EJiE[YF^P00E]X00U[J00IJfeKJF]YJfU[KE]X2
F]X2000045lK001S?5lkGc`006<lGc]O?5lkHcaO>`00HeaWG6=K0V=L014006=LHgaSO6=m001SG5mL
HeaOG6=LGeaSG5mLHeaOG6=L00<001moo`00:goo00@007ooOol000=oo`80000LD]a>^e;KC[]Bg4jk
D]]>^e;LC[]Bf`00D]]>^e:kC[]BfdjkD[]>^e;KC[/004jjD[]>^e:kC[X300007djJD[]>VU:k001B
^djJD[]>VU:kCYYB^djJD[]>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VU:k001B^djJ0080000PDYY>
NU:JCWYBVTijDYY>NP00CWUBVTiiDYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYY>NE:JCWUBVTiiDYY>
N@<0000HCWUBVU9iDYY>NE:JDWUBVTiiDYYBN@00DWUFVU9iDYYBNEJJDWUBVU9iEYYBNE:J0`0002=F
^P00001FVEJjEYUJ^UJIE[YFVEZj001JfeJjF]]FfU[KE[YJfeKJF]]F^P00G_YO6ekjGa/006<lGc]S
?000HcaO>f<l00800009He]WO6=KIgaSFfMlHe/005mL0080000:HeaOG6=mGeaSG5mLHgeOG6=LGe`2
00000emL0000000OOol002aoo`8000Aoo`8000aB^`03001B^e:k00QB^`03001B^e:k00800005C[]B
^e:kD[]>^`03D[/03@00D[]B^U:kCYYB^e:jD[]>VU:kD[YB^`00009BVP06D[]>VU:JDYYB^djJ0U:J
0`0000]>VU:JCYYBVTjJDYY>VU:JCYYBVP0000=BVP05CWYBVU:JDYY>NP03DYX01Dij001BVU:JDWX0
0e:J00QBNU:J000004iiDWT005:I0e9i00EBVE9iDWUBNE:I009BN@03001BVU:I009BV@05DYYBVE:I
DYUBVP0300001U:J00000000E[YF^@=F^P09E[UF^UJjE[YF^EJj001JfeKJ009JfP03F]]FfU[J0080
000=G_YO6ekkGa]NnUlK001S?5lk001O>f<l00000V=L00IWG6=KHeaSG6MLHe/2He`02`00GeaSG5mL
HeaOG6=LGeaSG5mLHe`00P000ell00<007oo00007Woo000bOol06@00Ool004jkD]a>^e;KC[]Bg4jk
D]]>^e;LC[/004jkD]]>^e:kC[]BfdjkD[]>^e;K00<0000ND[]>VU:kCYYB^djJD[]>VU:kCYYB^`00
D[]>VU:kCYYB^djJD[]>VU:kCYYB^`00D[]>VU:kCYYB^djJ0`00021>VU:J001BVTijDYY>NU:JCWYB
VTijDYY>NU:J001BVTiiDYY>NE:JCWUBVTiiDYY>NE:JCWT004iiDYY>NE:J0`0001MBVTiiDWU>N@00
DWUBVTiiDYYBNE:JCWUBVU9iDYY>NE:J001BVU9iEYYBNE:J00<00003DYYBNEJJ0080000CEYUJ^UJI
E[YFVEZjEYUF^UJIF[YFVEJjEYT005KJF]]F^U[KE]X00P0000aO6ekjGa]NnUlKG_YO6ekj001O>f<l
Gc/200007fMlHe]WO6=KIgaSFfMlHe]WO6=K001SF`00GeaSOEmLHeaOG6=mGeaSG000GeaO?5mLGcaO
G5ll001oo`0001eoo`00<Goo00D007ooOomoo`0000]B^`03001B^e:k00AB^`<0009B^`03001>^e:k
009B^`05C[]B^e:kD[]>^`02D[/03`00CYYB^e:jD[]>VU:kD[YB^djJD[]B^P00CYYBVP0400004djJ
DYY>VU:JCYX004jJDYY>VU:JCYYBVTjJDYY>VU:JCYYBVP0000=BVP05CWYBVU:JDYY>NP03DYX00`00
DYYBVP020003DWT024iiDWUBNE9iCWT0059iDYT3DWT02E:IDWUBNE9iDYUBN@00DYUBVP03000015:J
DYUBVE:I0P000UJI00<005JiE[X00UJj00EF^EJjE[YF^UJi00=F^P0CE[T005[JF]]FfP00G_]O6ekj
Ga]NnelKG_YO6ekkGa]NnP00Gc/00`0000=SG6MLHe/00V=L00=WG6=KHe`00P0000=WFfMkIe/00P00
00ASG5mLHeaOG08000QO?0<001aoo`00<Goo0`000Woo00l004jkD]a>^e;KC[]Bg4jkD]]>^e;LC[/0
04jkD]/00`0001eB^djkD[]>^e:kC[/004jJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB
^djJD[]>VU:k00<0000RDY]>VU:JCYYBVdjJDYY>VU:KCYX004ijDYY>NU:JCWYBVTijDYY>NU:JCWX0
04iiDYY>NE:JCWUBVTiiDYY>NE:JCWT300005TiiDWU>NE:JCWUBNDiiDYY>NE9i001BVU9iDYY>NE:J
DWUBVTiiDYYBNE:J0`0000EBVU9iEYYBNE:J0080000DDWUFVE9iEYX005JjEYUJ^UJIE[YFVEZjEYUF
^UJIF[YFVEJj001Jf`80000RG_YO6ekjGa]NnUlKG_YO6ekjGa]NnUlKG_X006=KIg`006MlHe]WO6=K
IgaSFfMl001WO6=KIgaSFfMlHe]WO000Hgd200002UllGeaO?5mLGcaOG5llGeaO?5mL0`0077oo000a
Ool00`00Oomoo`02Ool00`00D[]B^`09D[/30003D[/01DjkD[]B^e:kC[/00U:k00<004jkD[/00U:k
00E>^e:kD[]B^djk009B^`07001>VU:kD[YB^djJD[/00`0001a>VdjJ001>VU:JCYYBVTjJDYY>VU:J
CYYBVP00DYY>VU:JCYYBVTjJDYY>VU:JCYYBVTjJ001>NP=BVP03CWYBVP0000<00003CWT004ii00=B
N@05CWUBNE9iDWU>N@03DWT01000DWUBNE:I0e9i00IBVE9i000005:I0002DYT01U:JDYT00000EYUB
V@=FV@05DYUFV@00E[YF^@03E[X01EJiE[YF^UJjE[T00eJj01D005lKG_]O6ekjGa]NnelKG_YO6ekk
Ga]NnUlKG_/006<j001SG6ML00000V=L00iWG6=KHe`006MlIe]WNfMKIgaWFfMkIe]WO0003Ell00<0
07oo00006goo000aOol00`00Ool00003Ool02000D]]>^e;LC[]BfdjkD]`3000075;LC[/004jkD[]>
^e:kC[]B^djkD[]>^e:kC[/004jJD[]>VU:kCYYB^djJD[]>VU:k001B^djJ1000021B^djJD[]>VU:k
001BVTjJDY]>VU:JCYYBVdjJDYY>VU:K001BVTijDYY>NU:JCWYBVTijDYY>NU:J001BVTii100001QB
VTiiDWY>NE:JCWT004iiDYY>NE9iCWUBVTiiDWU>NE:JCWT004iiDYYBNE:JCWT300001TiiDYYBNE:J
001FVP80000EDWUFVU9iEYUBNEJJDWUFVE9iEYX005JjEYUJ^UJIE[YFVEZjEYUF^UJI0080000=G]X0
05lKG_YO6ekjGa]NnUlKG_YO6ekjGa/00P00025S>VLkHcX006=KIg`006MlHe]WO000IgaSFfMlHe]W
O6=KIgaSFfMl001WF`00GeaO?5mLGcaOG5llGeaO?5mLGc`00P0000=O?00000006goo000aOol20005
Ool00`00D[]B^`040003D[/01DjkD[]B^`00C[/00e:k00U>^e:kD[]B^djkD[/005:kC[/00e:k00E>
^e:kD[]B^djk00<0000QCYY>VdjJD[]>VTjKCYYB^djJCY/005:JCYYBVTjJDYY>VU:JCYYBVTjJDYX0
05:JCYYBVTjJDYY>VU:JCYYBVTjJ00<000=>N@05DWY>NDiiCWUBNP02CWT00`00DWU>N@03DWT01Dii
DWUBNE9iCWT00U9i00<0059i00000P000e9i00=BVE9iDWT00`000eJI00EBVEJIEYUFVE:I00=FV@05
DYT005JjE[YF^@03E[X01EJiE[X00000F]T00U[J01ENfP00Ga]NnelKG_YO6ekkGa]NnUlK001W>f<j
Ic]S>fLkHcX006=LIe`00`0000QWO6MKIg]WFfMlIe]WNfMK0P000VMK00<005llGc`01Ull0P0000AK
75llFaaK708000Ioo`D000moo`006Goo0P0017oo0P000goo10000goo0P0017oo00<007ooOol01Goo
0P0001e>^e;LC[]Bg4jkD]a>^e;LC[]Bg000D[]>^e:kC[]B^djkD[]>^e:kC[]B^`00D[]>VU:kCYYB
^djJ00<0000RCYYB^`00D[]>VU:kCYYB^djJD[]>VU:kCYX004jJDYY>VU:KCYYBVTjJDY]>VU:JCYX0
04ijDYY>NU:JCWYBVTijDYX200006DiiDYX0059jCWUBVTiiDWY>NE:JCWUBNTiiDYX0059iCWUBVTii
DWU>NE:JCWUBNDii00<00007CWUBVU9iDYY>NE:JDWT00P00055FVE9h001BNEJJDWUFVE9iEYYBNEJI
DWUFVU9iEYUBN@00EYUF^UJIF[YFVEJj001NfUZiG]YJ^EkJF[UNfP00Ga]NnUlKG_YO6ekjGa/006Lk
HcYW>f<jIc]S>VLkHcX006=K001SFfMlHe]WO6=KIgaSFfMlHe/006=KIe]S>fMLHe/005llGeaO?5mL
GcaOG000GcaK6ellFa]O?5/KGc`00P001goo00<007ooOol03goo000HOol01000Oomoo`0027oo00<0
07ooOol00goo00@007ooOol000=oo`8000Moo`03001B^djk00=B^`09C[]B^e:kD[]>^e:k001B^djk
00=B^`09C[]B^e:kD[]>^e:k001B^djk00<000=>^`0OD[]>^djk001B^djJCY]>VU:kCYY>VdjJD[]>
VP00CYYBVTjJDYY>VU:JCYYBVTjJDYY>VP00CYYBVTjJDYX00`000Tij00E>VTii001>NE9j00=>N@07
DWY>NDiiCWUBNTii00000U9i00E>NE9iDWUBNDii00<00004CWUBN@00DYT3DWT30004DWT00`00EYUB
V@03EYT01E:IEYUFVEJIDYT00eJI00EBV@00E[YF^UJi00800006G]YJfE[JF]YNfU[I0U[J01h005kj
Ga]NnelKG_YO6`00Ic]S>VLkHc]W>f<jIc]S>fLkHcX006MK001WFfMkIe]WO6MKIg]WF`00He/3Ie/0
16=KIe]WF`000ell0P000U/L00IO?5/LFaaK75llFa`20007Ool00`00Oomoo`0?Ool001Qoo`04001o
ogoo0009Ool00`00Oomoo`05Ool01000Oomoo`002Woo01L005;LC[]Bg4jkD]a>^e;LC[]Bg4jkD]`0
05:kC[]B^djkD[]>^e:kC[]B^djk00<0000SCYYB^djKD[]>VU:kCY]B^djJ001>VU:kCYYB^djJD[]>
VU:kCYYB^djJ001>VU:JCYYBVdjJDYY>VU:KCYYBVP00DYY>NP02000065:JCWUBVTiiDYY>NE:JCWT0
04iiDWY>NE:JCWUBNTiiDYY>NE9jCWT004iiDWU>N@<00008CWUBVTiiDWU>N@00DWUBVP80000HDWQB
NE9hEYUBN59iDWQFV@00EYUBNEJJDWUFVE9iEYYBNEJIDWUFVU9iEYT005Zj0P0000mJ^EkJF[UNfUZi
G]YJ^EkJF[UNfUZi001NnUlKG_X00P0001mW>f<jIc]S>VLkHcYW>f<jIc]S>P00IcX006=K001SFfMl
He]WO6=K001SFfMKHc]WG6=KIe]S>fML001OG00200002e/KGcaK6ellFa]O?5/KGcaK6ellFa/00P00
1Woo00<007ooOol03goo000HOol01000Oomoo`002Woo00<007ooOol00Woo0P000goo0P002Woo00<0
05:kC[/00e:k00U>^e:kD[]B^djkD[/005:kC[/00e:k00A>^`000000009>^`03001B^djk009>^`0L
D[]>^djkC[]B^djk001>VU:kCYY>VdjJD[]>VTjKCYYB^`00DYY>VU:JCYYBVTjJDYY>VU:JCYX30000
0dijCYY>N@02CWX01TjJCWU>NTijCYX0009>N@05DWY>NDiiCWUBNP03CWT00e9j0000000200001Dii
DWUBNE9iCWT00e9i0`002U9i00@005JIEYUBV@=FV@05DYUFVEJIEYUBV@03EYT01@00F]YJfUkJF]T0
0U[J00INfU[IF]YJfUkJF]T2F]X04P00G_X006<kIc]S>VLkHc]W>f<jIc]S>fLkHcX006MJJeYWFP<0
0005Ie]WN`00001SF`03Ie/026=KIe]WFfMKHe]WF`00Gc`3Fa`01EllFaaK75/LGc`00e/L00=O?000
00001Woo00<007ooOol03goo000HOol01000Oomoo`0027oo00@007ooOol000=oo`03001oogoo009o
o`8000]oo`0>001Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C[]B^`@0000SC[]Bg4jkD[a>^`00CY]B^djJ
D[]>Ve:kCYYB^djKD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[/005:KCYYBVTjJDY]>VP0300005dij
CYX005:JCWUBVTiiDYY>NE:JCWUBVTiiDYX005:JCWUBNTiiDYY>NE9jCWT0100000MBVTiiDWU>NE:J
CWUBN@0300006U9iCUP0059hDWUBN5JIDWQBNE9hEYUBN59iDWP0059iEYUBNEJJDWUFVE9iEYYBNEJI
DWT20000<5Zi001NfUZiG]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfUZi001S>VLkHcYW>f<jIc]S>VLkHcYW
>f<j001W>V]KIcY[FfLjJe/006Ml001WG6=KIe]S>fMLHe]WFf<kIeaSF`80000<Ie/005llFa]O?5/K
GcaK6ellFa]O?5/K0P0000=K75[k000017oo0P004Goo000IOol2000:Ool20004Ool30002Ool00`00
Oomoo`0:Ool01000D[]B^djk0e:k00A>^e:kD[]B^`<00005C[a>^djkC[]>_003C[/01DjlC[/004jk
D[/00djk01=B^djkC[]>^e:kC[/004jJD[]>VTjKCYYB^djJCY]>VP00CYYBVP040005CYX01P00CWU>
NTijCYY>N@9>NP05CYY>NDijCWX00003CWT00e9jCWT000020003CWT00`00CWUBN@02DWT01Dii0000
059iCWT00e9i00<0059iDWT02U9i00@005JIEYUBV@=FV@09DYUFV@00001FVEZIEYT005[I009JfP06
G]YJfE[JF]YNfU[I0U[J015NfP00001Rn@00HcYW>f<kIc]S>VLkHc]W>f<j001WFV]J00=WFP06JeYW
FVMJ001WFf=K0fMK00ISFfMKIe]WFf=K0004Hc/00`00GcaK7002Fa`00ellFaaK7002000015/KFaaK
75/L0P005Woo000`Ool2000<Ool01`00C[]Bg4jkD]a>^e;L00<0000RD]a>^`00C[]B_4jkD]a>^e:l
C[]Bg4jkD[a>^`00CY]B^djJD[]>Ve:kCYYB^djKD[/005:kCYYB^djJD[]>VU:kCYX400006E:KCWY>
VTijDY]>NTjJCWYBVdij001>NE:JCWUBVTiiDYY>NE:JCWUBVTii001>NE:J00800009CWUBVTiiDWY>
NE:JCWT004ii00<0000KCUQBNDiHDWU>F59iCUQBN@00EYUBN59iDWQFVE9hDWUBN5JIDWQBN@00EYYB
NEJIDWUFVU9i0080000MF[UFVEZiEYQJ^EJI001J^EkJF[UNfUZiG]YJ^EkJF[UNfP00H_YNnF<JH_T0
06<jIc]S>VLkHcYW>`0200007fLjJe]W>V]KIcY[FfLjJe/006]J001WFf<kIeaSFfMKHc]WG6=K001S
>fMKHc]SFf<k001K6ellFa]O?5/K00800008FaaK6e/LF_]K75/KFa`001Ioo`00<7oo00<007ooOol0
37oo00<005:kD[/00`0000=>g4jlC]`00TkL00A>_000C[]>_0=>^`06C[a>^djkC[]>_0000Tjk00EB
^djkC[]>^e:k00=>^`05D[/004jKCYYB^`040003CY/00`00CYY>VP08CYX00`00CYY>N@02CWX01djJ
CWU>NTijCYY>NDij00<0009>N@06DWY>NDiiCWUBNTii0`0000E>NE9iDWUBNDii00=BN@04CWUBNE9i
000<DWT01000EYUFVEJI0P0000]FVEZIEYUJVEJIFYUFVEZI001NfU[I009JfP0BG]YJfE[JF]YNfP00
H_YRnF;jH_URnV;i001S>VLkHc]W>`000VMJ00E[FVMJIeYWFV]J009WFP03001[FV]J00800003Ie]S
FfMK009WF`8000MS>`03001K75ll0080009K7005Fa]K75/LFaaK6`03Fa`00`00Oomoo`0COol0031o
o`8000ioo`80000PD]a>^e;LC[]Bg4jkD]a>^e;LC[/004jkD[a>^e;LC[]B_4jkD]a>^e:l001B^djK
D[]>VU:kCY]B^djJD[]>V`@0000KC[]:VTjkCYY>^dZJC[/004jJCWYBVdijCYY>NU:KCWY>VTijDY/0
05:JCWUBVTiiDYY>NE:J00<00008DYX0059jCWUBVTiiDWY>N@<0000MCUUBN@00DWU>F59iCUQBNDiH
DWU>F59iCUQBNDiH001BN5JIDWQBNE9hEYUBN59iDWQFVE9h001BN@0200004UZiEYQJ^EJIF[UFV5Zi
EYUJ^EJHF[T005kJF[UNfUZiG]YJ^@80000ZH_YNnF<JH_URnUkiHaX006LkHcYW>`00Je]W>V]KIcY[
FfLjJe]W>V]K001[FV/jJeYW>P00He]WFf<kIe`006=KHc]WFf<kHe]S>fMKHc]SFf<k0P0000aK75[k
FaaK6e/LF_]K75/KFaaJne/LFa/2000DOol002moo`80011oo`04001>g4kLC[`3C]`024jlC]a>g4kL
C[`004jkC[`3C[/01TjlC[]>^djkC[`0009>^`04D[]>^djkC[/300000djkC[`00009CY/00`00CYY>
VP09CYX01000CYY>NDij0`000Tij00E>VTii001>NE9j00@00006CUU>NDiiCWU>F@000U9i00E>NE9i
DWUBNDii00=BN@03CWUBN@0000aBN@0B001FVEZIEYUJVEJIFYUFVEZIEYUJVEJIFYUFV@00F]YNfU[I
0U[J00h006;iH_YRnF;jH_URnV;iH_YRnF;j001W>`000VMJ00E[FVMJIeYWFV]J009WFP03001[FV]J
00A[FP04001WF`000009Hc/200001F<k001K75/LFa/00e/L00IK6e/LFaaK75/KFa`2000DOol002mo
o`03001oogoo011oo`0I001>^e;LC[]Bg4jkD]a>^e;LC[]Bg000D]a>^e:lC[]Bg4jkD[a>^e;LC[/0
04jJD[/0100001]:^djlB[]>_4Zk001:VTjkCYY>^dZJC[]>VTjkBYY>^`00CYY>NU:KCWY>VTijDY]>
NTjJCWX0100000MBVTiiDYY>NE:JCWUBVP0300008E9iCUUBNDiIDWU>FE9iCUUBNDiI001>F59iCUQB
NDiHDWU>F59iCUQBNDiHDWT0059iDWQFVE9hDWUBN5JIDWQBN@020000:E9h001FV5ZiEYUJ^EJHF[UF
VEZiEYQJ^EJIF[UFV000F[UNfUZi001RnF;jG_US6V;iH_YNnF<JH_URnUkiHaX006]KIcY[FfLjJe]W
>V]KIcX00P00029[FV/jJeYW>V]JJcY[FVLj001S>f=KHc]WFf<kHe]S>fMKHc]SF`00Hc]S6f<k001K
75/KFaaJne/LFa]K75[kFaaK6`800003FaaJn`0001=oo`00;goo0`004Goo00@004kLC]a>_0=>g005
C[a>g4kLC]`00002C[/01TjlC[]>^djkC[a>^`@0000;C[a>^djlC[]>_4jkC[a>^djlC[/00009CY/0
0`00CYY>VP06CYX400000dijCYY>N@02CWX01djJ00000000CWY>N@00009>N@05CUU>NDiiCWU>F@03
CWT01@00DWUBNE9iCWT00e9i00I>NE9iDWUBNDii0007DWT200004eIiDWQFN@00FYUFVEZIEYUJVEJI
FYUFVEZIEYUJVEJIFYT005[J0080000@H_URnV;iH_YRnF;jH_URnV;iH_YRnF;j001W6@00JeX3IeX0
0f]JIeX00009JeX30008Hc/00`00Hc]S>`03Hc/01@00FaaK75/LFa/00e/L0P000U/L00AJne/L0000
019oo`007Goo0P0017oo0P0017oo0P0017oo00<007ooOol04Woo00l004jkD]a>^e;LC[]Bg4jkD]a>
^e;L001Bg4jkD[`0100001i:_4kMB[`004ZkC[a:^djlB[]>_4ZkC[a:^djlB[/004ZJC[]>VTjkBYY>
^djJC[]:VP00CWY>VTijDY/300001U:KCWY>VP00DYY>N@@0000SCWY:NDijBWU>NP00DWU>FE9iCUUB
NDiIDWU>FE9iCUUBN@00DWU>F59iCUQBNDiHDWU>F59iCUQBNDiH001BN59iDWQFV@020000>59hEYUB
N5JIDWQFV@00F[UFV5ZiEYUJ^EJHF[UFVEZiEYQJ^EJIF[T006<JH_URnUkiHaYRnF;jG_US6V;iH_YN
nF<J001[6VLIJcX006]KIcY[FfLj001W>V]JJcY[FVLjJeY[>V]JIcX006/iJeX200001F<kHe]S>fMK
Hc/00P0000aS>f<KHc]O6V<kHa]S>`00FaaK6e/LF_/2000025/LE_]K75[kFaaFne/L000BOol001ao
o`04001oogoo0008Ool01000Oomoo`000goo0P0057oo00@004kLC]a>_0=>g003C[a>g00000@0000D
C]a:g4kLB]a>g4[LC]a:g000C[]>_4jkC[a>^djlC[]>_4jkC[`000Y>V`@000E>VP@0009>NP05CWU>
NTijCWY>N@03CWX01@00CWU>NDiiCUT00dii00E>FDiiCWT004ii00=BN@05CWUBNE9iDWU>N@03DWT0
0`00DWUBN@02000095IiEWQFNE9hEWUFN5IiDWP005JIFYUFVEZIEYUJVEJIFYUFVEZIEYUJV@00G[T0
06;jH_URnV;iH_YRnF;jH_URnV;iH_X000AW6@05001WFV]JIeX00009JeX01P00JcU[>V/jJeX000AS
>`03001S>f<k00MS>`03001K6e/L00800005F_]K75/LFaaJn`03Fa`00e[kFa`0000AOol001aoo`04
001oogoo000;Ool01@00Oomoogoo00005Woo00@004jkD]a>^`@0000QC_e:gDkm001>gDZlC]e:_4kM
B[a>gDZlC]e:_000B[]>_4ZkC[a:^djlB[]>_4ZkC[`004jkBYY>^djJC[]:VTjk00<00003DY]>NTjJ
00D0000VCY]:NTjK001>NTYiCWY:NDijBWU>NTYiCWY:N@00CUUBNDiIDWU>FE9iCUUBNDiIDWU>F@00
CUQBNDiHDWU>F59iCUQBNDiHDWU>F0<0000EDWQFVE9hEYUBN5JIDWQFVE9hEYUBN000EYUJ^EJHF[UF
VEZiEYQJ^EJI0080000YG]UJ^000G_US6V;iH_YNnF<JH_URnUkiHaX006/JIaU[>VLIJaYW6@00IcX0
06LjJeY[>V]JIcY[FV/jJeYW>P00JcU[FVLiJeY[>F]J001WF`0200002elJHc]S6f<kGaYS>f<KHc]O
6V<kHa/00P0000aK75[kFaaFne/LF_]K75KkFaaJne/LE_/2000@Ool001aoo`04001oogoo0009Ool2
0003Ool00`00Oomoo`0FOol300007d[MB_e:gDkmB]e:oD[MC_d004kLB]a>g4[LC]a:g4kLB]a>g000
C[a>^djlC[]>_4jkC[a>^djlC[]>_00000A>V`800003CY/0000000<0000:CY]:NTZKBYY>VdYjBY]:
VP00CWT3CWX01DiiCWY>NTijCWT00Tij00<004iICWT00Tii00U>FDiiCWU>NDiICWT0059iCWT00e9i
00=>NE9iDWT00`0001QBF000DWQFNEIhEWUBN5IiEWQFNE9hEWUFN5Ii001JVEJIFYUFVEZIEYUJVEJI
0005G[T02000H_URnV;iH_YRnF;jH_T20008IaT00`00JeY[FP07JeX01P00JcU[>V/jJeY[>@9[>P80
00]S>`800003Ha/005[k00=K7005F_]K75/LFaaJn`03Fa`2000@Ool001aoo`04001oogoo0009Ool0
0`00Oomoo`02Ool2000HOol08P00B]e>oD[MC_e:gDkmB]e>oD[MC_d004kMB[a>gDZlC]e:_4kMB[a>
g@00C[a:^djlB[]>_4ZkC[a:^djlB[/004jJ1P0002]:_4ZKB[`004jKBWY>VdYjCY]:NTjKBWY>VdYj
001:NDijBWU>NTYiCWY:NDijBWU>NP00DWU>FE9iCUUBNDiIDWU>FE9iCUUBN@00DWU>F59iCUQBN@02
0000A4iHDWU>F59iCUP0059hEYUBN5JIDWQFVE9hEYUBN5JIDWQFV@00F[UFVEZiEYQJ^EJI001J^5kI
F[QNfEZhG]UJ^000G_US6V;iH_YNn@00IaU[6VLIJcYW6F/JIaU[>VLI001[6000JcY[FVLjJeY[>V]J
IcX006/iJeYW>F]JJcU[FVLiJeX300005f<kHa]S>elJHc]S6f<kGaYS>`00Hc]O6V<kGa/005KkFaaJ
ne/LE_]K75[kFa`00`0000=K75Kk00003goo000MOol2000:Ool30002Ool00`00Oomoo`0HOol07000
B]e>oD[MB_e:gDkmB]e:oD[M001:g4kLB]a>g4[LC]a:g4kLB]a>g000C[a>^djlC[]>_4jk1`0001E:
VdZlBYa:_4ZKB[a:W000BWY:VdZJCY]:NTZKBYY>VdYjBY/004ijCWT00dij00U>NDijCWY>NTiiCWX0
04iiCUT00dii00I>FDiiCWU>NDiI0002DWT300006e9iDUQBNE9HDWUBF59i001FNE9hEWUFN5IiDWQF
NEIhEWUBN5IiEWP005JIFYUFVEZIEYT00008G[T01P00H_YRnF;jH_T000UW6@05001[>F/iJcT00005
JeX01P00JcU[>V/jJeY[>@9[>P04JeX006/jJcT20006Hc/20002Ha/01V<kGa]S6`00FaaJn`=K7005
F_/00000FaaJn`02F_`00e/L0000000>Ool000=oo`<002Qoo`8001Yoo`0C001:gDkmB]e>oD[MC_e:
gDkmB]d004ZlC]e:_4kMB[a>gDZlC]d02P0002i6_4[MA[`004ZKB[a6VdZlBY]:_4JKB[a:V`00BWY>
VdYjCY]:NTjKBWY>VdYjCY/004ijBWU>NTYiCWY:NDijBWU>NTYi001>FE9iCUUBNDiIDWU>FE9iCUUB
N@<0000KDWU>F59iCUQBNDiHDWU>F59iCUQBN@00EYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9h001FV5Zi
00800011F[QNfEZhG]UJ^5kIF[QNfEZhG]T006;jG_T006LIJaYW6F/jIaU[6VLIJcYW6@00JaQ_>F/H
JcU[6000JcY[FVLj001[>F]JIcU[FV/iJeYW>F]J001[>VLiJeX006/j001S>f<KHc]O6P00Ga]S>elJ
Hc]O6f<kGaYS>`00FaaFn`0300002EKkFaaFne/LE_]K75KkFa`0000>Ool000Aoo`03001oogoo02Mo
o`03001oogoo01Yoo`0>001:gDkmB]e:oD[MC_e:gD[mB]d004[LC]a:g0@00003A_i2gTKn00@0000O
A[e6gDJmA]e6_DKMA[d004ZLB[a:VdZlBYa:_4ZKB[a:W000BWY:VdZJCY]:NTZKBYY>VdYjBY/004ij
CWT00dij00I>NDijCWY>NTii0002CWT014iICWU>NDii0`0001i>NDiI001BF59iDUQBNE9HDWUBF59i
DUQBNE9H001FN5IiDWQFNEIhEWUBN5IiEWQFNE9hEWT005ZI000<G[T00`00H_T00009IaT00`00JcU[
>@05JcT01000JeX006/i0V/j00m[FV/iJcY[>V]J001[>V/iJcY[>F/j001[>P00Hc/00P0000EO6f<K
Ha]S>elK009S6`03Hc]O6f<K00800005F_]Jo5[lFaaJn`02F_`015/LF_]Jo5[l0P003Goo0004Ool3
000WOol00`00Oomoo`0KOol01P00B]e>oD[MC_e:g@L00005@]e6oT;MA_i2g@040000;4[MA[a:gDJl
B]e6_4[MA[a:gDJl001:VdZlAY]:_4ZKB[a6VdZl001>VdYjCY]:NTjKBWY>VdYjCY]:NP00BWU>NTYi
CWY:NDijBWU>NTYiCWX0059iCUT40000L4iiCUU>NDiICWT0059iCUQBNDiHDWU>F59iCUQBNDiHDWU>
F000DWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JI001NfEZhG]UJ^5kIF[QNfEZhG]UJ^5kIF[QNfEZh001W
6F/JIaU[>VLIJaYW6F/jIaT006/HKcU[66/iJaQ_>F/HJcU[6000JcU[FVLiJeY[>F]JIcU[FP00JcYW
>F]JIcU[>VLiJeX006/j001S>elKHc]O6V<kGa]S>elJHc]O6f<k001S>`00FaaFne/LE_]K75KkFaaF
ne/LE_]K75Kk0P001Woo10000Woo0004Ool01000Oomoo`009Woo0P007Goo1@0000=2oT<O@_h00T;n
0P000TKn0`000TKn0292gTKn0016gDJmA]e6_DKMA[e6gDJmA]d004ZlBYa:_4ZKB[a:W4ZlBY]:_000
CY]:NTZKBYY>VdYjBY]:VTjKBWX0009>NP06CWU>NTijCWY>NDij100000=>FDiiCUT00TiI01a>NDiI
CUU>FDii001BNE9HDWUBF59iDUQBNE9HDWUBF59i001FNEIhEWUBN5IiEWQFNE9hEWUFN0800003FYP0
05ji00]N^@03001Rf00000QW6@03001[>F/i00I[>@06001[>000JcY[FV/i0V/j00i[FV/i001[>F/j
JcU[>V/iJcY[>F/j001[>P000V<K00IS>elKHa]S6f<kGa/200001V<KGa/005[lFaaJn`9Jo006FaaJ
ne[lF_aK75[k0`001Woo00<007ooOol00goo0004Ool01000Oomoo`009Goo00<007ooOol07Woo0P00
00Q37d;n@am2oT<O@_i37d;n0`0002Y2gDKn@]e6oT;MA_i2gDKn001:gDJlB]e6_4[MA[a:gDJlB]d0
04ZlBY]:_4JKB[a:VdZlAY]:_000CY]:NTjKBWY>VdYjCY]:NTjK001>NTYiCWX500008dYjBUY:NP00
CWU>FDiiCUU>NDiICWU>FDiiCUT004iHDWU>F59iCUQBNDiHDWU>F59iCUP0059hEYUBN5JIDWQFVE9h
EYT00P0003IFN5ZIEWP005ZhG]UJ^5kIF[QNfEZhG]UJ^5kIF[P006;HH_URf000IaU[6VLIJcYW6F/J
001_>F/HJcU[66liJaQ[>F/H001[>6liJaP006/iJeYW>F]JJcT006LiJeYW>F/jIcU[FVLiJcX20000
66LI001O6V<kGa]S>elJHc]O6`00GaYS>elJHa]O6P00E_]K75KkFaaFne/LE_]K70800004E_]K7000
0006Ool00`00Oomoo`02Ool000=oo`@002Ioo`03001oogoo021oo`8000=2oP<00003@_i37`0000=6
oP0P@]i6oTKnA_i2gTKn0016gDJmA]e6_DKMA[e6gDJmA]d004ZlBYa:_4ZKB[a:W4ZlBY/004ZJCY]:
NTZKBYY>V`L000Q:NP05001>FDiICUU>N@03CUT05TiiCUU>FDiI001BF59iDUQBNE9HDWUBF59iDUQB
NE9H001BN5IiEWQFNE9h0P0000MJVEJHFYQFV5ZIEYP00009G[T01`00H]QRfF;HH_URf00000AW6@03
001[>F/i00I[>@0J001[>6lhKcQ_>F/h001[>V]JJcT006/iJcY[>F/jJcU[>V/iJcX006/jIcT006Li
001O6`9S6`05Hc]O6`00Ga]S6`03Ga/01f<KGa/005[lFaaJne[l00<0009Jo003FaaFne[l008000Io
o`03001oogoo005oo`00;Goo0`008Woo0`0000I2oT<O@_i37d;n@al200003T;MA_i2gDKn@]e6oT;M
A_h004[MA[a:gDJlB]dC0000:dJL@W]6W4IkAY`004YjBUY:NTYJBWY:FTYjBUY:NTYJ001>FDiiCUU>
NDiICWU>FDiiCUU>N@00DWU>F59iCUQBNDiHDWU>F59iCUQBN@00EYUBN5JI00800012EWQJVEIhFYUF
N5ZIEWQJV@00G]UJ^5kIF[QNfEZhG]UJ^000H]QRnF;HI_URf6;i001[>VLIJaX006liJaQ[>F/HKcU[
66/iJaQ_>@00KcU[66liJcQ_>F/H001[>@00IcU[FVLiJcYW>F]JIcU[>P00JcYW6F/jIaT006LI001O
6V<k0P0000]O6V<kGaYS6elJHc]O6V<K001K75Kk00800008FaaFne/LE_]K75KkFaaFn`8000Aoo`04
001oogoo0002Ool001Eoo`8000Aoo`8000Eoo`03001oogoo009oo`8000Aoo`03001oogoo021oo`<0
0003Ool0000001D00006>]hfgS[N=]hjgP000cjm010nWCjm?[dn_CjM0016VdJLAW]6W4JKAYa6NdJL
AY/000Y:NP03001>NDiI009>F@05CWU>FDiICUU>N@02CUT03000DWUBF59iDUQBNE9HDWUBF59iDUQB
N@<0000<FYQFV5ZIEYQJV5JHFYUFV5ZHEYQJV@001Eji0P0000]Rf6;IH]QRnF;HH]URf6;i001W6@00
00U[>@05001_>6lhKcU[>002KcP04VliJcP006/iJcY[>F/jJcU[>V/iJcX006/jIcU[>FLiJcYW>@80
0005Hc/005lKGa]S6`03Ga/01F<KGa]O6elKHa/00P0000=Jo5/LE_/00U[l00IK75KkF_aJo5/LE_/2
0004Ool20003Ool001Aoo`04001oogoo000:Ool01@00Oomoogoo00000Woo00@007ooOomoo`8001io
o`<000Eoo`800007<_hfoc;n=alboSKo<_h00P0004Dfoc;N=_lbgSKo<]hfo`00>]lf_S[O=[hjgcJn
>]lf_S[O0012_SjM@[dnWD:n?Ye2_CjM0016NdJL@W]6W4IkAYa2NdJLAW/004YJBWY:FTYjBUY:NTYJ
BWY:FTYj001>NDiICWU>FDiiCUU>NDiICWU>F@00CUQBNDiHDWU>F59iCUQBNDiHDWT00P0004mFN5ZI
EWQJVEIhFYUFN5ZIEWQJVEIhFYUFN000F[QNfEZhG]T006KiH]QRnF;HI_URf6;iH]QVnF;HH_T006li
JaQ[>F/HKcU[66/iJaQ_>@00KcU[66liJcQ_>F/HKcU[>000JaP006LiJcYW>F]JIcU[>P00JcYW6F/j
IaU[>VLIJcX006/j001S6elJHc]O6V<KGaYS>elJHa]O6P0200003f<K001K75KkFaaFne/LE_]K75Kk
FaaFne/LE_/00009Ool001Aoo`04001oogoo000:Ool00`00Oomoo`04Ool01@00Oomoogoo000077oo
0`002Woo00@003Ko=_lbo`<fo`0E<_lfo`00=_lbgS;o<]lfoc;N<_l003[N=]hjgSKN>]hfgS[N=]hj
gP0000<n_@0??Ydn_Cjm?[d004JLAY]6W4IkAYa6VdJLAW]6W00000Y:NP03001>FDii00=>F@0>CWU>
FDiICUU>NDiI001BF59iDUQBNE9HDWUBF080000ADWUBN000EYQJVEJHFYQFV5ZIEYQJV5JHFYUFV5ZH
EYP00002G[T03`00H_URf6;IH]QRnF;HH]URf6;iH]QRf@00J_P00007JcT01@00KcQ_>6liJcP00Vlh
00=_>F/h00000flh01<006/iJcY[>F/j001[>VLiJcUW>F/jIcU[>FLiJcX006/i001S6`03Ga/01F<K
Ga]O6elK00000elK00H005KkF_aJo5/LE_/2F_`00e/LE_]Jo0030009Ool001Aoo`04001oogoo000;
Ool01000Oomoogoo0P0017oo00<007ooOol05goo0`003Woo0P0000Lfoc;n=alboSKo<_hg7`020000
1S;N=_lbgSKo<]hfo`80000e=[hjgcJn>]lf_S[O=[h003jM@[hnWD:m?Ye2_SjM@[d004JLAW]6W49k
AYa6NdJL@W]6W000BWY:FTYjBUY:NTYJBWY:FTYjBUX004iICWU>FDiiCUU>NDiICWU>FDii001BNDiH
DWU>F0030000D59HEWUBF59i001JVEIhFYUFN5ZIEWQJVEIhFYUFN5ZIEWQJV@00G]T006KiH]QRnF;H
I_URf6;iH]QVnF;HH_T006/II_Q[6000KcU[66/iJaQ_>@00KcU[66liJcQ_>F/HKcU[>000JaQ_>6/H
KcP006]JIcU[>P00JcYW6F/jIaU[>VLIJcYW6F/j001[>P00JcX006<KGaYS>elJHa/200003ElJHa]O
6V<KGaX005KkFaaFne/LE_]K75Kk0080009oo`03001oogoo00Moo`0057oo00@007ooOol000Qoo`04
001oogoo0003Ool00`00Oomoo`02Ool2000FOol3000COol>00003C;N<_lbg`00=]hjgSKN>]hfgS[N
=]h003jM00<n_@0??Ydn_Cjm?[d004JLAY]6W4IkAYa6VdJLAW]6W00000U:NP04001>FDiICWT3CUT0
1diiCUU>FDiICWT0059i0080000TDWQBNE9hDWUBN59iDWQBN@00FYQFV5ZIEYQJV5JHFYUFV5ZHEYQJ
VEJHFYP006;iH]QRfF;HH_URf6;IH]QRnF;HH]T006[h0fKh00=Zn000JcT00V/i00D006lhKcQ_>F/h
009_>004KcU[>6lh0005KcP04000JcX006/jIcU[>FLiJcYW>F/iIcU[>P00JcUW>F/j0P0000IO6f<K
Ga]O6`00Ha/3Ga/01V<KGa]O6elK001Fn`9Jo003Fa`0000000Eoo`03001oogoo00Ioo`005Goo0P00
2Goo10000goo0`000Woo00<007ooOol04Woo0`0067oo0P0000HbobkN<_l^gS;o;]h200000b:n8Yh0
00080000:CJn>]lf_P00?Ye2_SjM@[dnWD:n?Ye2_@00AYa6NdJL@W]6W4IkAYa2N`00BUY:NTYJBWY:
FTYjBUY:NTYJBWX004iiCUU>NDiICWU>FDiiCUT01000059FNE9HDWUBF5IiDUQBNE9HEWUBF000EWQJ
VEIhFYUFN5ZIEWQJVEIhFYUFN5ZI001N^@00H_URf6KiH]QRnF;HI_URf6;i001[6FKhJaQVn6/II_P0
06/HKcU[6000JaQ_>F/hKcU[66liJcQ_>@00KcQ[66lhJaQ_>6/HKcP006/jIaU[>VLIJcYW6F/jIaU[
>P00JcYW6F/jIaT006LI001O6P80000<Ha]O6V<KGaYS6elJHa]O6V<K001K75Kk0P001goo00<007oo
Ool01Woo000/Ool00`00Oomoo`0?Ool3000MOol200000bkO<_l^gP02;]l00c;o000000058[h20000
0ajN7Wh0000800003SjM?[dn_@00AW]6W4JKAYa6NdJLAY]6W4Ik0009BWX01000CUU>FDiI1@0001U:
FDiI001BNE9hDWUBN59iDWQBNE9hDWUBN59iDWP005JHFYQFV5ZIEYQJV5JHFYUFV00200003EjhF[P0
06;HH_URf6;IH]QRnF;HH]T006[h00=Vn00:J_QVn6KhI_P006/i001_>6liJcP2KcP016liJcQ_>000
1flh00T006lh001[>FLiJcYW>F/iIcT00P0000][>FLiJcYW6F/iIcT006LI001O6f<K00=O6`05Ha]O
6elKGa]S6`02Ga/20009Ool00`00Oomoo`06Ool002aoo`8000eoo`<0029oo`h0000<8[h000006WdN
WQYm7YhJO@009WdZWRIm2@0000]2NdJLAW]6W000BWY:FTYjBUY:NTYJ00L0001UBUU>NTYICWY:FDij
BUU>NP00DWUBF5IiDUQBNE9HEWUBF59iDUQFN@00FYUFN5ZIEWQJVEIhFYUFN000FYQN^EZHG[UJV000
H]QRnF;HI_URf6;iH]P006KhJaQVn6/II_Q[66KhJaUVn000JaQ_>F/hKcU[66liJcQ_>@00KcQ[66lh
JaQ_>6/HKcP006lhKaQ_>000JcYW6F/jIaT006LIJcYW6F/jIaU[>VLIJcYW6@00IaT005lJHa]O6V<K
GaYS6elJHa]O6P02000;Ool00`00Oomoo`06Ool002aoo`03001oogoo00Yoo`8002Moo`08000fgcKN
=]lfgSKO=]hfg`80008NWPH000046WhNWQin00079Wh01000=WdfOCIm2`0000M2FdIk@U]6N`00CWU:
F@02CUT06diiBUU>FDiICWU:F@00DWQBNE9hDWUBN59iDWQBNE9hDWUBN59i001JVEJHFYQFV5ZIEYP0
0002G[P035ZhG[QN^5jhF[P006;HH_URf6;IH]P000=Vn00:J_QVn6KhI_QZn6Kh001[6000JcP2KcP0
16liJcQ_>00026lh018006lHKcQ_>000IcU[>FLi001W6F/iIcU[>VLIJcUW>F/jIaT200001F/iIaT0
05lKHa/00elK00=S6`0000003Goo00<007ooOol01Woo000/Ool00`00Oomoo`07Ool3000ZOol20000
3SKN>_lfgSKO=]hjocKN000NOAjN7WdNWQim7Yh40000OaYm000002ZN9WdVWRIm:YhVO@00=W`jOCIl
>WdfO3Ym=W`jO@00AW]2FTIk@UY6Nd9JAW]2FTIk001>NTYICWY:FDijBUU>NTYICWY:F@00DUQBNE9H
EWUBF59iDUQFNE9HDWUBF000EWQJVEIhFYUFN000FYQN^EZHG[UJV5jiFYQN^@00I_URf6;iH]P006Kh
JaQVn6/II_Q[66KhJaUVn000J_M_66[g001[66liJcQ_>@00KcQ[66lhJaQ_>6/HKcQ[6000KaQ_>6/G
KcQ_6000IaT006LIJcYW6F/jIaU[>VLIJcYW6@00IaU[>P00JcX006<KGaYS6elJ008000moo`03001o
ogoo00Ioo`00:goo0P001Woo0`00;goo00P003KN=]lfgSKO=]hfgcKN0P001QjN00<000HK00000`00
1RIn00<003Im=Wd01CIm00h0049KAW]2FdIk@U]6Nd9KAW]2F`00CUU>NDYI0TiI01E>NDYICUU>FDii
001BNE9hDWUBN59iDWQBNE9hDWUBN59iDWP005JHFYT00P000Ujh00EJ^5jhG[QN^5Zh00=N^004001R
fF;H0003I_P01f[hI_QVn6KhJ_QVn000009[6005JaM[66/H001[>002KcP00`00KcQ_>005KcP00`00
KaQ_>002KcP05VlHKcQ_>000IaU[>FLiJcYW6F/iIcU[>VLI001W6F/iIaUW>@00JcT005lK0P004Goo
00<007ooOol01Woo000[Ool00`00Oomoo`02Ool3000cOol>00001QjN7Wd000001S`66`<0001/9WdV
WRIm:Yh003Ym=W`jOCIl>WdfO3Ym=W`0049JAW]2FTIk@UY6Nd9JAW]2FP00BUU>NTYICWY:FDijBUU>
NTYICWX005IiDUQBNE9HEWUBF59iDUQFNE9HDWT005ZI001N^EZHG[UJV5jiFYQN^EZHG[UJV5jiFYP0
06;H001Vn6/HI_Q[6FKhJaQVn6/II_Q[6000KaQZmflHJ_M_66[g001[6000JaQ_>6/HKcQ[66lhJaP0
06lHKcQ[5flhKaQ_>6/G001_5`00IaU[>VLIJcYW6F/j0P0000UW6F/jIaU[>VLIJcX006/j000057oo
00<007ooOol01Goo000[Ool5000gOol00`00?]hngP06?]h200029Yh600021Q`400029Wh00`00=Wdf
O@06=Wd02P00@U]6Nd9KAW]2FdIk@U]6N`000TiI00I>NDYICUU>FDiiBUT2CUT03000DWQBNE9hDWUB
N59iDWQBNE9hDWUBN08000=N^005F[QN^5jhG[QJ^003G[P015ZhG[QN^0000fKh00EZn6KhI_QVn6[h
009Vn003001[66/G00=[6004JaM[66/H0008KcP01@00KcQ_>6lhKaP00flh014006lhKcP006LIJcUW
>F/j001W>FLIJcUW6FLiIaU[>FLI008001Eoo`03001oogoo00Eoo`00:goo0P00>goo00/003kN@_hn
gT;N?]i2oSkN@]hngP00008VWP049WhVWRJN9Yh400000`HK0005f`0400009CYm=W`jOCIl>WdfO3Ym
0016Nd9JAW]2FTIk@UY6Nd9JAW/004ijBUU>NTYICWY:FDijBUU>NP00DWUBF5IiDUQBNE9HEWUBF59i
00800016DWQFV@00G[UJV5jiFYQN^EZHG[UJV5jiFYQN^EZH001R^000I_Q[6FKhJaQVn6/II_Q[6000
KaQZmflHJ_M_66[gKaQZm`00KaL006/HKcQ[66lhJaQ_>000KcQ[5flhKaQ_>6/GKcP006lhJaM_>000
JcYW6F/j001[>VLIJcYW6F/jIaU[>VLIJcX2000EOol00`00Oomoo`05Ool002=oo`D000Aoo`03001o
ogoo03Yoo`8000PngP8000DVWP8000030M/00000008000031O/5f`00008000HfO@0;0016Nd9KAW]2
FdIk@U]6Nd9K001:F@02CUT03TiiBUU>FDiICWU:FDiI001BNE9hDWUBN59iDWP200001UJIEWQFVEIi
001J^0=N^005F[QN^5jhG[QJ^002G[P01@00H]QRf000J_P00fKh00IZn6KhI_P006/HJaL3JaP01F/G
JaQ[66/H00000VlG00<006lhKcP00Vlh00D006lhKcQ_>6lH00=_>00C001_>6lhKcQ_66lh001[>P00
IcUW6F/iIaUW>FLIJcUW6FLi00000Woo00<007ooOol04Woo00<007ooOol01Goo000UOol00`00Oomo
o`05Ool2000lOol01P00@_hngT;N?]i2oPP0008VWP059Wh0007K1O/1fP0200000`Gl1M/5o0040000
73Il>WdfO3Ym0016Nd9JAW]2FTIk@UY6Nd9J001:FDijBUU>NTYICWY:FDijBUT0059HDWUBF5Ii0P00
04UBN5JIDWQFVE9hEYUBN000FYQN^EZHG[UJV5jiFYQN^EZH001R^6;HG[QRf@00JaQVn6/II_Q[6000
KaQZmflHJ_M_66[gKaQZmflH001_66/GKaQ_5`00JaQ_>000KcQ[5flhKaQ_>6/GKcQ_6000JaM_>6lG
KcQ[5flh001[>VLIJcYW6F/jIaU[>VLIJcX00004Ool00`00Oomoo`0AOol00`00Oomoo`05Ool002Eo
o`03001oogoo00Moo`03001oogoo03Yoo`D00006A]i6gDKN@]e6gP000RjN1P0000<5n`7K1O/00P00
00D5f`Gk000J?AXL00D0000;@U]6Nd9KAW]2FdIk@U]6N`00CWU:F@02CUT024iiBUU>FDiICWU:F@00
DWP2000035JIEWUFVEIhEYUFNEJIEWQFV@00G[QJ^0=N^004F[QN^5jh0006H]P01`00J_QVn6Kh001[
66/G00=[6005JaM[66/HJaP00002KaL01flHKaM_5flG001_>000009_>006KaQ_>6lhKcQ_60000Vlh
00e_66lhKcQ_>000KcP006/iIaUW>FLIJcUW6@020005Ool00`00Oomoo`0AOol00`00Oomoo`05Ool0
02Eoo`03001oogoo00Qoo`03001oogoo03Yoo`0A0016oT;MA]i2gDKn@]e6gT;MA_h002jn;Yhb_RjN
;[h^WP0400002`Gk000000001O`001Xm6Q`N?AXL6Sd01P0000Y2FTIk@UY6N`00CWY:FDijBUU>NPH0
001:DWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JI001N^EZHG[UJV5jiFYP006:hH]QN^6;IH[QRf5jhH]T0
06/HI_P006[gKaQZmflHJ_M_66[gKaP006lHJaM_66lGKaQ[5flHKaL006/GKcQ_66lhJaM_>6lH001[
5flhKaM_>6/GKcQ_5`00JaM_>000JcYW6F/jIaT000Qoo`03001oogoo011oo`03001oogoo00Eoo`00
9Goo00<007ooOol02Goo00<007ooOol0>Woo00/004KNA]e6gT;MA]i6gDKN@]e6gP0000L^WP030005
n`0000H0000:6SdJ71XM6QdJ?AXL000fG3YL=U`:00000dYjBUY:NP02BWX03P00EYUFNEJIEWQFVEIi
EYUFN5JIEWUFVEIh0002G[P015ZhG[QN^0002F;H00@006Kh001[5`=[6008JaM[66/HJaQ[5`00KaM_
60=_5`06KaQ_5`00KaL006lH0flh00E_6000KcQ_>6lH00=_>00:KaP006lHKcQ_6000IaU[>FLI000:
Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool002Aoo`8000aoo`8003]oo`80000@@]e6gT;MA_i2gDKN
@]e6oP00;[h^WS:n;Yh^_RjN<[h200001@GK1O`000000CL00P00064J?AXL7SdJ71Xm000jG3IK>U`f
>cYL=U/jG3Hk001:FTYjBUU:NTYJBWY:FDYjBUX0059hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9h001J
V5jiFYP006:hH]QN^6;IH[QRf5jhH]UR^6;HG[P006[gKaQZmflHJ_M_66[gKaQZm`00JaM_66lGKaQ[
5flHKaM_6000LcP006lhJaM_>6lHKcP006lhKaM_>6/GKcQ_5`00JaM_>6lGKcQ[5`00IaT0000;Ool0
0`00Oomoo`0@Ool00`00Oomoo`04Ool003Aoo`03001oogoo03Yoo`060016gDKN@]e6gTKM3P000PGK
0P0000@1F0006SdJ708J7@056Sd003IL=U`jG003=U`00cYL001:NP02BWX01DYJBWY:NTYjBUX00TYj
00h005IhEYUFNEJIEWQFVEIiEYUFN5JIEWUFV@000Ujh00<006;HH]P02F;H00<006KH00000V/H00Q[
5f/HJaQ[66/G001_5flH0flG00A_66lGKaL000=_5`07001_>6lHKcP006lhKaP00flh00Y_66lh001_
>6lHKcQ_66lhKaP000eoo`03001oogoo00moo`03001oogoo00Aoo`00=Goo00<007ooOol0>Woo1@00
00A6gD[MA]e:oP800007<Ydf_S:N=[hbWCJn<Yh00`0000@5f`000001F080000T6Q`N?AXL6Sd003YL
=U/jG3Hk>U`fFcYL001:NTYJBWY:FDYjBUY:NTYIBWX005JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JI
0P00021R^6;HG[QRfF:hH]QN^6;IH[QRf5jh001Vf6Kh001_66[gKaQZmflHJ_M_6000KaQ_5flHJaM_
66lGKaP007<h0flG01=c>000KcP006lhKaM_>6/GKcQ_5flh001_>6lGKcQ[5flhKaL0000?Ool00`00
Oomoo`0>Ool00`00Oomoo`04Ool003Ioo`03001oogoo03Yoo`030016gD[M00=6g@0>B]e6gDKMA]d0
03:N=[hbWSJn<Yhf_S:N0005f`P0008J7@05000fG3IL=U`jG003=U`00`00BUY:NP02BWX054YJBWY:
NTYjBUY:NP00EYUFN5JIEWUFVEIhEYUFNEJIEWQFVEIi000;H]P00`00I]QVn002I_P02000JaQ[66/H
JaM[6000KaP3KaL01FlHKaM_5flG00001FlG00@006lh001_60=_>00;KaQ_>000KcQ_66lhKaQ_>6lH
KcP0000@Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool003Moo`03001oogoo03Yoo`0:0016gD[MA]e:
oTKMB]e6gD[nA]d200002CJn<Yhf_S:M=[hbWP001M/9o00500008@5j000001XL000f>cYL=U/jG3Hk
>U`fF`00BUU:NTYJBWY:FDYjBUY:NTYIBWX005JIDWQFVE9hEYUBN5JIDWQFV@02000085JI001N^6;I
H[QRf5jhH]UR^6;HG[P006KHI_QVf6KhI]QVn000KaQZmflH001_66lGKaQ[5flHKaM_66/G0003KaL0
57<hKaM_5flG001_5flhJaM_>6lGKcP006lhKaM_>6/GKcQ_5flh000AOol00`00Oomoo`0=Ool00`00
Oomoo`04Ool003Qoo`8003]oo`030016gD[M00=6g@03B]e6gDKM00H00005<Yhf_S:N0005f`022O`4
00001@5j0GT00000>U`00cIL00HjG3IL=U`fG000BUX3BWX03DYJBWY:NTYjBUX005IiEYUFN5JIEWUF
VEIh00800004F[UFVEZi0008H]P00`00I]QVn002I_P026KHI_QVn6Kh001[6000KaP3KaL01FlHKaM_
5flG00001flG00<006lG00000Vlh00a_66lhKcP006lHKcQ_66lhKaQ_>6lH000BOol00`00Oomoo`0<
Ool00`00Oomoo`04Ool003Yoo`03001oogoo03Uoo`040016gD[MA]d400001T[mB]e:g@00>[hfW@H0
00032O`5f`Wl00<000030GX1N@5j0080000F=S/jG3IK>U`f>cYL001:NTYIBWY:FTYjBUU:NTYJBWY:
F@00DWQFVE9hEYT200008eJIF[UFVEZiEYUJ^@00H]QN^6;IH[QRf5jhH]T006KhI]QVn6KHI_QVf6Kh
I]P006[g001_5flHJaM_66lGKaQ[5flH00000VlG01Ec>6lGKaM_5g<h001c=flF001_5flhJaL006lG
KcQ[5flhKaM_>6/G000057oo00<007ooOol037oo00<007ooOol00goo000kOol00`00Oomoo`0iOol3
0008B]d01@00=[hf_SZn=Yd00SJn100000<9o00000000P000P5i100000LfG3YL=U`fG000BWY:FP03
BWX01dYJBWY:NTYj001FVEIi0080000:F[UFVEZiEYUJ^EJIF[UFVEZi0005H]P01@00I_QVn6KhI]P0
0fKh00AVf6KhI_P000=_5`06KaQ_5flGKaM_60001flG00D006lGKaM_5`00009_>009001_66lhKaQ_
>6lHKcQ_600001Ioo`03001oogoo00]oo`03001oogoo00=oo`00?7oo00<007ooOol0>Goo00D004[M
B]e6g4[m009:g@0;A]a:oD[MB]d003Zn=Ydj_SJM>[hfW@0200000`gl000000050000105j000R728L
1@0000I:FTYjBUU:NTYJBWX600009EJIF[UFVEZiEYUJ^EJIF[UFVEZiEYT006:hH]QN^6;I001Vn6KH
I_QVf6KhI]QVn6KHI_QVf000I_P006/GKaQ_5flHJaM_6000009_5`0FLcQ_5flGKaMc>000LcM_5W<g
KaMc=`00KcP006lhJaM_>6lGKcQ[5flh000FOol00`00Oomoo`0;Ool00`00Oomoo`03Ool003eoo`80
03Yoo`8000U:g@05000f_SJn>[hfW@02=[h00cZn000=o0023O`500000`5i000R70048Q`70005AW/0
3P00F[UFVEZiEYUJ^EJIF[UFVEZiEYUJ^EJI0002H]P01@00I_QVn6KhI]P00fKh00AVf6KhI_P000=Z
n007001_5flGKaM_66lG00001flG00<006lGKaL016lG00T006lhKaQ_>6lHKcQ_66lh000067oo00<0
07ooOol02Woo00<007ooOol00goo000oOol00`00Oomoo`0iOol01000B]e6g4[m0T[M3P0000<9o0gl
2O/01P000R8L00DV7B8L8Q`R70000096N`05AWY6NdIkAW]6NP02AW/09`00EYUJ^EJIF[UFVEZiEYUJ
^EJIF[UFVEZi001Rf@00I_QVf6KhI]QVn6KHI_QVf6KhI]QVn000JaQVmf/HI_P006/GKaQ_5`00KaMc
>003KaL04W<hKaL006lFLcM_5g<gKaIc=`00LcL006lhKaM_>6/GKcP001Yoo`03001oogoo00Uoo`03
001oogoo00=oo`00@7oo00<007ooOol0>Goo1@001D[M00P003Zn>[dj_SZM>[hj_CZn0`000Pgl0`00
00<0e@0000001B8L00<004IkAW/024Ik00h005JIF[UFVEZiEYUJ^EJIF[UFVEZiEYUJ^@000fKh00EV
f6KhI_QVn6KH00=Vn004001Zn6[hJaP2J_P01000KaQ_5`001flG00<006lGKaL01FlG00T006lGLcL0
06lhKaQ_>6lH00006Woo00<007ooOol02Goo00<007ooOol00goo0011Ool00`00Oomoo`0iOol01000
B]e:g4[m0T[M00i:g4[mB]e:g@00>[hjWCZn>Ydj_SZM>[h0018M0P0000L9n`000000002e0=H00002
8Q`012HM8Q`R70000dIk0156NTIkAW]6NdIjAW/005ZiEYUJ^EJIF[UFVEZiEYUJ^EJI0080000GG]X0
06KhI]QVn6KHI_QVf6KhI]QVn000JaQVmf/HI_Q[66KgJaP006lH001c>003KaL04g<hKaM_5`00LcM_
5g<gKaIc=flG001_5W<gKaMc=`00KcQ_5`0001aoo`03001oogoo00Qoo`03001oogoo00=oo`00@Woo
0P00>Woo00<004[MB]d01d[M00/003Zn>[dj_SZM>[hj_CZn000Ao0gl00D00080e@8000@R70030016
NdIk00M6N`08001J^EJIF[UFVEZiEYUJ^@800005F[UJfUZiF]X00003I_P01FKHI_QVn6Kh00000V[h
00E[66[hJ_QZn6/H009Zn003001_5flG00E_5`03001_5flG00E_5`03001c=flG009_5`04LcL006lh
000MOol00`00Oomoo`07Ool00`00Oomoo`03Ool004Aoo`03001oogoo03Qoo`04001:gD[LB_d2B]d0
44[LB_e:gD[M000j_SZM>[hjWCZn>Ydj_P004Qd=o18L100000<0]@001K/00P0000@V7B8L0016NP=6
N`0WAWY6NdIkAW]6NP00EYUJ^EJIF[UFVEZi001NfUZiG]YJ^EkJF[T006KHI_QVf6KhI]QVn6KH001V
mf/HI_Q[66KgJaQVn6/H001_6000009_5`0DLcQ_5flGKaL006lGLcM_5W<gKaMc=`00LcM_5g<gKaIc
=flGLcL001moo`03001oogoo00Moo`03001oogoo009oo`00AGoo00<007ooOol0>7oo00<004[MB]d0
0d[M3P0000<=o17l3O`01@000PVk0P0000<R7000AW/024Ik00@005JIF[UFV@80000:F]YJ^E[JF[UJ
fUZiF]YJ^@00I]P3I_P016KH001Zn6/H0f[h00Q[66[hJ_P006/HJaM[600016lG00<006lGKaL016lG
00<007<gKaL00VlG00Ac=flGKaL0021oo`03001oogoo00Moo`03001oogoo009oo`00AWoo00<007oo
Ool0>7oo1@0000e>gD[LC_e:g4kM000n_SZM?[hjWCjn>Ydn_P0400000`gl0000000300000`Fk2K/5
VP0200000dIkAWY6N`02AW/01TIjAW]6NdIk001J^@80000OF[UNfUZiG]YJ^EkJF[UNfUZiG]YJ^@00
I]QVn6KH001Vmf/HI_Q[66KgJaQVn6/HI_L006[gKaQZmflH00000VlG014006lGLcM_5W<gKaMc=flF
001_5g<gKaIc=flGLcM_5P00025oo`03001oogoo00Ioo`03001oogoo009oo`00Agoo00<007ooOol0
>7oo00<004[MB]d01d[M0P0000Lj_CZn>[dj_SZm>[h000024O`700042K/;00004e[JF[UJfUZiF]YJ
^E[JF[UJfUZiF]YJ^E[JF[T006KH001Zn6/H00=Zn006JaQZn6[hJ_P006/G0f/H00E[5f/H001_5`00
00I_5`05001_5flGKaMc=`03KaL00`00Oomoo`0QOol00`00Oomoo`05Ool00`00Oomoo`02Ool004Qo
o`8003Uoo`0G001>gD[LC_e:g4kMB]a>oD[LC]e:g000>Ydn_SZM?[hjWCjn000B7A7l4Q`=o0040000
@PVk1K/9^`FJ2K/004:L?W]2W3il@Y`nNd:L?Wa2W000G]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfUZiG]X0
06Kh001[66KhJaQVmf/HI_Q[66Kg001ZmflHJ_M_66[gKaQZmflH001c=flFLcM_5g<gKaIc=`00LcM_
5W<gKaMc=flFLcL002Aoo`03001oogoo00Aoo`03001oogoo009oo`00BWoo00<007ooOol0=goo00<0
04[MB]d01T[M1P0000@j_SZm>[h0008Ao0034Q`Ao17l00<000D9^`030012W49l0092O00E@Ya2O49l
@Wa2W000F]YJ^E[JF[UJfUZiF]YJ^E[JF[UJfUZiF]X006/H00=Zn006JaQZn6[hJ_P006/G0f/H00M[
5f/HJaQ[6000KaP00005KaL01000KaM_5g<g0flG00=c=`00Ool097oo00<007ooOol017oo00<007oo
Ool00Woo001;Ool00`00Oomoo`0gOol01000C]e:g4km10001Woo1P0000@Ao18L3O`B7@@0000I1K/9
^`FJ000nO4:L?W]2W3il@Y`nNd:L?W`005ZiG]YJ^EkJF[UNfUZiG]YJ^EkJF[T00P00029NnP00JaQV
mf/HI_Q[66KgJaP006lHJ_M_66[gKaQZmflH001_66/G001_5g<gKaIc=`00LcM_5W<gKaMc=flFLcL0
02Moo`03001oogoo00=oo`03001oogoo009oo`00C7oo00<007ooOol0=goo0`0047oo0`000Q7l1@00
0PVk00<0049l@Y`00d9l00e2W49l@Wa2O000F[UJfUZiF]YJ^E[JF[UJfP0200001UkJG_YNfUkj001[
60=Zn003JaP006/H009[6006JaM[66/HJaQ[5`000VlH00=[5`00KaL00VlG00<006lGLcL00flG00=c
=flG0000:7oo00<007ooOol00goo00<007ooOol00Goo001=Ool2000gOol00`00Oomoo`0COol60000
>`5I0009^`FJ000nO4:L?W]2W3il@Y`nNd:L?W`005ZiG]YJ^EkJF[UNfP00G_YJfEkjG]YNnU[IG_X0
06/HI_M[6000KaQZmflHJ_M_66[gKaQZm`00JaM_66/GKaQ[5`00KaL006lFLcM_5g<gKaIc=flG0000
:Goo00<007ooOol00goo00<007ooOol00Goo001?Ool00`00Oomoo`0dOol00`00Oomoo`0FOol40000
1`5I000000Vk0012O4:L00=2O008@Ya2O49l@W`005ZiF]YJ^@80000<G_YNfUkjG]YNnUkJG_YNfP00
J_Q[60000f/H00I[5f/HJaQ[66/G0002KaP026/GKaQ_66lH001_5`00LcL3KaL017<gKaM_5`00:Woo
00<007ooOol00Woo00<007ooOol00Goo001@Ool00`00Oomoo`0cOol00`00Oomoo`0HOol01@000;D0
005I0CP00P0000]2W3il@Y`nNd:L?Wa2W3ik@Y`005kJ0080000WG]YNnU[IG_YNfUkjF]UNnUkJG_YJ
f@00I_P006[gKaQZmflHJ_M_66[g001[5flHJaM_66/GKaQ[5flH001c=flGLcM_5W<gKaMc=`0002ao
o`05001oogooOol00003Ool0055oo`03001oogoo039oo`03001oogoo01Uoo`@000030CT1F@0000X0
000?G_YNfUkjG]YNnUkJG_YNfUkjG]YNnUkJG_YNfP00009[6009JaM[66/HJaQ[5f/H001_66/G00=_
6005JaM_6000KaP00002KaL017<gKaM_5`00;Woo00@007ooOol000=oo`00DWoo0P00<Woo00<007oo
Ool06goo0`0001P1>05I000nWCYl?YdjO3jM>W`nWCYl?Yd005kjF]UNnUkJG_YJfEkjG]YNnU[IG_X2
00006Ukj001ZmflHJ_M_66[gKaP006lHJaM_66/GKaQ[5flHJaL006/GKaP007<gKaMc=flF000^Ool0
1000Oomoo`000goo001DOol00`00Oomoo`0_Ool00`00Oomoo`0LOol300005`4i0ET003ZM>WdjWCYl
>YdjOCZM>W`005kJG_YNfUkjG]YNnUkJG_YNfUkj00000Ukj00=RnP00JaP00V/H00E[5f/H001_66/G
00=_6009JaM_66lH001_5flHKaM_6000009_5`03001oogoo02ioo`03001oo`0000=oo`00EGoo00<0
07ooOol0;Woo00<007ooOol07Goo10000301F@00?YdjO3jM>W`nWCYl?YdjO000G]YNnU[IG_YNfUkj
F]UNnP00H_YNnV<JG_YRnP00KaQZmflH001_66/GKaQ[5flHJaM_66/G001[5flHJaM_>6/GKaP007<g
000aOol00`00Ool00002Ool005Ioo`03001oogoo02eoo`03001oogoo01moo`0C0000m`00000jO3ZM
>WdjWCYl>YdjOCZM>W`005kJG_YNfUkjG]X00P000Ukj00IRnUkjG_YNnV;j0002JaP00`00JaM_6002
KaP03F/GKaQ_66lH001_66lGKaQ_5flHKaM_600003=oo`80009oo`00Egoo00<007ooOol0;7oo00<0
07ooOol087oo02l0003g000003Yl?YdjO3jM>W`nWCYl?YdjO000G]YNnU[I001NnV;jG_YS6UkjH_YN
nV<JG_X006[g001[5flHJaM_66/GKaQ[5flH001_66/GKcQ[5flHJaM_>00003Aoo`80009oo`00F7oo
0P00;7oo00<007ooOol08Goo0P0000<0mP0000000`0000HjO3ZM>WdjW@00G_X20003G_X01F;jG_YN
nUkjH_X00ekj00<006/GKaP00VlH00i[5flHKaQ_6000KaQ_5flHKaM_66lGKaQ_5`00=7oo0P000Woo
001JOol00`00Oomoo`0YOol00`00Oomoo`0ROol200001@3f000fOCJN=Wd01P0001mS6UkjH_YNnV<J
G_YRnUkjHaYNnV;jG_X005kj001[5flHJaM_66/GKaP006lHJaM_>6/GKaQ[5flhJaL0000aOol40004
Ool005]oo`03001oogoo02Qoo`03001oogoo02=oo`80000;0?H003Im=YdfOCJM=WdfWCIm=Yd00002
G_X01F;jG_YNnUkjH_X00Ukj0P0000ENnV<JHaX006/G00=_600:JaL006lGKaQ_5flHKaM_66lG000^
Ool40008Ool005aoo`03001oogoo02Moo`03001oogoo02Aoo`80000W0?H003Im=YhfOCJM=WdfWSIm
=Yd006<JG_YRnUkjHaYNnV;j001S6ekjHa]NnV<KG_X006/GKaQ[5`00JaM_>6/GKaQ[5flhJaM_6000
02Yoo`@000aoo`00GGoo0P009goo00<007ooOol09Goo0`0000XfWCIm=YdfOCJM=WdfWCIm=Yd0009N
nP06H_YNnUkj001S6Ukj0f<J00mNnV<J001_66/G001_5flHKaM_66lGKaQ_5flH0000:7oo0`0047oo
001OOol00`00Oomoo`0TOol00`00Oomoo`0VOol3000033JM=WdfWSIm=YdfOCJN=Wd005kjHaYNnP80
000DHa]NnV<KG_YS6ekjHa]NnV<K001_6000KcQ[5flHJaM_>6/GKaP002Eoo`@001=oo`00H7oo00<0
07ooOol08goo00<007ooOol09goo1`0000LfWCIm=YdfO@00G_X00002HaX01EkjHaYS6V<JG_X00f<J
00]NnV<J001_66lGKaQ_5flHKaM_6000029oo`@001Moo`00HGoo00<007ooOol08Woo00<007ooOol0
:7oo0`0000<bWRim<Yh01P0000]NnV<KG_YS6ekjHa]NnV<KG_YS6ekj00800009Ha/006lHJaM_>6/G
KaQ[5`0001ioo`@001]oo`00HWoo0P008Woo00<007ooOol0:Goo0`0000DbWS9m<WdbOC:N00<bO@03
001NnV<J009S6P06G_YS6V<JHaYNnP0016<J00H006lHKaM_66lG000KOol4000OOol006Aoo`03001o
ogoo01moo`03001oogoo02Yoo`<0000K<Yh^OC:N<WdbWRim<Yh006<KG_YS6ekjHa]NnV<KG_X005lJ
Ha]S6V<KGaYS6`00KaQ[5`0001Uoo`<002=oo`00IGoo00<007ooOol07Woo00<007ooOol0:goo00@0
002D000bWP<bO@06<YhbOC9m001S6Ukj0f<J0P0026<J00<006lH00005Goo10009Woo001VOol00`00
Oomoo`0MOol00`00Oomoo`0/Ool00`000;@0000200005S:N<WdbWRim<Yh006<KG_YS6`00Ha]O6V<K
HaYS6elJHa]S6V<KGaYS6`004Woo1000:Woo001WOol2000LOol00`00Oomoo`0^Ool300000bin0000
000200000c9m001S6P02000:HaX2000?Ool4000^Ool006Uoo`03001oogoo01Uoo`03001oogoo031o
o`800004<Yh^OC:N;Wd3000036<JHa]O6V<KHaYS6elJHa]S6V<KGaX000ioo`<0039oo`00JWoo00<0
07ooOol067oo00<007ooOol0<Goo00T002im;Wh^OBin;Wd^ORim00002F<J00<007ooOol02Goo1000
=Goo001[Ool00`00Oomoo`0GOol00`00Oomoo`0bOol03`00;WdbWRim<Yh^OC:N;Wd006<JHa]O6V<K
HaYS6`020008Ool4000iOol006aoo`03001oogoo01Ioo`03001oogoo03=oo`<00006;Wd^ORim;Wh^
O@0016<J00<007ooOol017oo1000?Goo001]Ool2000FOol00`00Oomoo`0fOol500000bim001S6P02
0003Ool40011Ool006moo`03001oogoo01=oo`03001oogoo03]oo`<0009oo`<004Eoo`00L7oo00<0
07ooOol04Woo00<007ooOol0?7oo1000B7oo001aOol00`00Oomoo`0AOol00`00Oomoo`0hOol4001<
Ool0079oo`80015oo`03001oogoo03Aoo`@0051oo`00M7oo00<007ooOol03Woo00<007ooOol0<Goo
0`00E7oo001eOol00`00Oomoo`0=Ool00`00Oomoo`0]Ool4001GOol007Ioo`03001oogoo00aoo`03
001oogoo02Uoo`@005]oo`00Mgoo0P0037oo00<007ooOol09Goo1000Ggoo001iOol00`00Oomoo`09
Ool00`00Oomoo`0QOol4001SOol007Yoo`03001oogoo00Qoo`03001oogoo01ioo`<006Moo`00Ngoo
00<007ooOol01goo00<007ooOol06Woo1000JWoo001lOol00`00Oomoo`06Ool00`00Oomoo`0FOol4
001^Ool007eoo`8000Ioo`03001oogoo019oo`@0079oo`00Ogoo00<007ooOol00goo00<007ooOol0
3goo0`00MWoo0020Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool4001iOol0085oo`05001oogooOol0
0009Ool4001mOol0089oo`800003Ool007oo00Aoo`@0085oo`00Q7oo0P0000=oo`0000000P00QGoo
0025Ool20029Ool00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00ogoo4Goo003oOolAOol0
0?mooa5oo`00ogoo4Goo003oOolAOol00001\
\>"],
  ImageRangeCache->{{{19, 271.125}, {203.5, 6.1875}} -> {-0.183727, \
0.0452766, 0.00422098, 0.00422098}}]
}, Open  ]],

Cell[TextData[{
  "A second solution with similar properties develops from the subgroup ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", 
          RowBox[{
            StyleBox["k2",
              FontSlant->"Italic"], "=", 
            RowBox[{
              StyleBox["k4",
                FontSlant->"Italic"], "=", "1"}]}]}], TraditionalForm]]],
  ". The corresponding infinitesimals are"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 1, k2 \[Rule] 1, k3 \[Rule] 0, k4 \[Rule] 1, 
          k5 \[Rule] 0, k6 \[Rule] 0, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{E\^\(-\[Tau]\) + E\^\[Tau], 0}, {1\/2\ P\ \((2 - 2\ E\^\[Tau]\ v)\)}}
      \)], "Output"]
}, Open  ]],

Cell["The similarity reduction of the FP equation is gained with", "Text",
  CellTags->{
  "similarity reduction", "similarity reduction of the FP equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(red2 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red2]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Tau] - \[Zeta]\_1 == 0\)},
          {
            \(E\^\(\(-\(\(E\^\[Tau]\ v\)\/\(1 + E\^\(2\ \[Tau]\)\)\)\) + 
                      \(E\^\(2\ \[Tau]\)\ v\^2\)\/\(2\ 
                          \((1 + E\^\(2\ \[Tau]\))\)\)\)\ P - F\_1 == 0\)},
          {
            \(\(-F\_1\) - 2\ E\^\(2\ \[Zeta]\_1\)\ F\_1 + 
                \((F\_1)\)\_\(\[Zeta]\_1\) + 
                2\ E\^\(2\ \[Zeta]\_1\)\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                E\^\(4\ \[Zeta]\_1\)\ \((F\_1)\)\_\(\[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again the similarity variable is \[Tau]. The similarity representation of \
the solution combines an unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " with an exponential depending on the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and time \[Tau]. The related first-order ODE which ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " has to satisfy determines the similarity solution:"
}], "Text",
  ShowCellBracket->True,
  CellTags->{"similarity representation", "similarity solution"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solr2\  = 
      DSolve[red2\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]
        \)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(\(-\(\(1 + E\^\(2\ #1\)\)\/\(2\ 
                            \((1 + 2\ E\^\(2\ #1\) + E\^\(4\ #1\))\)\)\)\) - 
                    \(\((1 + E\^\(2\ #1\))\)\^2\ Log[1 + E\^\(2\ #1\)]\)\/\(2
                        \ \((1 + 2\ E\^\(2\ #1\) + E\^\(4\ #1\))\)\) + 
                    \(\((1 + E\^\(2\ #1\))\)\^2\ #1\)\/\(1 + 
                        2\ E\^\(2\ #1\) + E\^\(4\ #1\)\)\)\ C[1]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell["This solution reads, in original variables,", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = 
      Solve[red2\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr2, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] 
          \(E\^\(\(\(-1\) + 2\ E\^\[Tau]\ v - E\^\(2\ \[Tau]\)\ v\^2 + 
                      2\ \((1 + E\^\(2\ \[Tau]\))\)\ \[Tau]\)\/\(2\ 
                      \((1 + E\^\(2\ \[Tau]\))\)\)\)\ 
              C[1]\)\/\@\(1 + E\^\(2\ \[Tau]\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"The plot of the solution shows that, contrary to the previous group, a small \
difference exists. The difference occurs for larger positive velocities and \
negative times \[Tau]. In this region, the probability density has a \
non-vanishing value."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      \(P /. sol2\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. 
        C[1] \[Rule] 1, {v, \(-3\), 5}, {\[Tau], \(-2\), 2}, 
      AxesLabel \[Rule] {"\<v\>", "\<\[Tau]\>", "\<P\>"}, 
      PlotPoints \[Rule] 25]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.04977 -0.0679587 1.04977 [
[.10092 .21731 -12 -8.91782 ]
[.10092 .21731 0 .08218 ]
[.25429 .15697 -5.74307 -9 ]
[.25429 .15697 .25693 0 ]
[.41721 .09289 -5.43033 -9 ]
[.41721 .09289 .56967 0 ]
[.59061 .02474 -5.11759 -9 ]
[.59061 .02474 .88241 0 ]
[.29165 .07573 -10.2423 -15 ]
[.29165 .07573 .75771 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01553 .31893 -24 -2.78782 ]
[.01553 .31893 0 6.21218 ]
[.00663 .37467 -18 -2.83512 ]
[.00663 .37467 0 6.16488 ]
[-0.00258 .43242 -24 -2.8843 ]
[-0.00258 .43242 0 6.1157 ]
[-0.01214 .49231 -6 -2.93549 ]
[-0.01214 .49231 0 6.06451 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02779 .31426 m
.03392 .31193 L
s
[(0.25)] .01553 .31893 1 -0.38048 Mshowa
.01894 .37011 m
.02509 .36784 L
s
[(0.5)] .00663 .37467 1 -0.36997 Mshowa
.00977 .42799 m
.01594 .42577 L
s
[(0.75)] -0.00258 .43242 1 -0.35904 Mshowa
.00026 .488 m
.00645 .48585 L
s
[(1)] -0.01214 .49231 1 -0.34767 Mshowa
.125 Mabswid
.03465 .27097 m
.03832 .26955 L
s
.03295 .28168 m
.03663 .28026 L
s
.03124 .29247 m
.03492 .29105 L
s
.02952 .30333 m
.0332 .30192 L
s
.02604 .32528 m
.02973 .32388 L
s
.02429 .33637 m
.02797 .33498 L
s
.02252 .34754 m
.0262 .34616 L
s
.02073 .35879 m
.02442 .35741 L
s
.01713 .38152 m
.02083 .38017 L
s
.01531 .39302 m
.01901 .39166 L
s
.01348 .40459 m
.01718 .40325 L
s
.01163 .41625 m
.01533 .41491 L
s
.00789 .43982 m
.0116 .4385 L
s
.00601 .45173 m
.00972 .45042 L
s
.0041 .46373 m
.00782 .46243 L
s
.00219 .47582 m
.0059 .47452 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
45.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
45.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(P) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.617 .728 .925 r
.3923 .59331 .40507 .60526 .42639 .60139 .41372 .58925 Metetra
.546 .702 .942 r
.41372 .58925 .42639 .60139 .44785 .60056 .43527 .58812 Metetra
.377 .623 .949 r
.43527 .58812 .44785 .60056 .46946 .60509 .45696 .59219 Metetra
.018 .405 .855 r
.45696 .59219 .46946 .60509 .49131 .61762 .47886 .60409 Metetra
0 .056 .572 r
.47886 .60409 .49131 .61762 .51355 .63995 .50111 .62567 Metetra
.656 .177 0 r
.50111 .62567 .51355 .63995 .53639 .67124 .52392 .6563 Metetra
.704 .235 0 r
.52392 .6563 .53639 .67124 .55996 .70643 .54745 .69127 Metetra
.573 .105 0 r
.54745 .69127 .55996 .70643 .5842 .73633 .57168 .72165 Metetra
0 .364 .833 r
.57168 .72165 .5842 .73633 .60876 .75041 .59632 .73697 Metetra
.657 .741 .912 r
.59632 .73697 .60876 .75041 .63313 .74175 .62088 .72996 Metetra
.855 .795 .791 r
.62088 .72996 .63313 .74175 .65686 .71095 .64489 .70061 Metetra
.909 .799 .727 r
.64489 .70061 .65686 .71095 .67982 .66577 .66817 .65619 Metetra
.923 .802 .709 r
.66817 .65619 .67982 .66577 .70226 .61684 .69092 .60719 Metetra
.919 .809 .723 r
.69092 .60719 .70226 .61684 .7246 .57287 .71351 .56253 Metetra
.896 .815 .761 r
.71351 .56253 .7246 .57287 .74722 .53822 .73633 .52693 Metetra
.851 .813 .812 r
.73633 .52693 .74722 .53822 .77037 .51322 .75963 .50101 Metetra
.793 .798 .857 r
.75963 .50101 .77037 .51322 .79407 .49584 .78348 .48291 Metetra
.737 .777 .885 r
.78348 .48291 .79407 .49584 .81828 .48342 .80783 .46999 Metetra
.699 .76 .899 r
.80783 .46999 .81828 .48342 .8429 .47374 .83258 .45999 Metetra
.678 .749 .905 r
.83258 .45999 .8429 .47374 .86783 .46535 .85767 .45139 Metetra
.669 .744 .907 r
.85767 .45139 .86783 .46535 .89303 .45748 .88302 .44335 Metetra
.665 .742 .908 r
.88302 .44335 .89303 .45748 .91847 .44975 .90862 .43548 Metetra
.664 .742 .908 r
.90862 .43548 .91847 .44975 .94414 .44202 .93445 .42762 Metetra
.664 .741 .908 r
.93445 .42762 .94414 .44202 .97003 .43424 .96052 .41972 Metetra
.619 .728 .924 r
.37934 .58119 .3923 .59331 .41372 .58925 .40087 .57693 Metetra
.553 .704 .941 r
.40087 .57693 .41372 .58925 .43527 .58812 .42251 .57548 Metetra
.395 .632 .949 r
.42251 .57548 .43527 .58812 .45696 .59219 .44428 .57905 Metetra
.058 .43 .871 r
.44428 .57905 .45696 .59219 .47886 .60409 .46623 .59022 Metetra
0 .092 .609 r
.46623 .59022 .47886 .60409 .50111 .62567 .48849 .61092 Metetra
.627 .151 0 r
.48849 .61092 .50111 .62567 .52392 .6563 .51128 .64073 Metetra
.685 .219 0 r
.51128 .64073 .52392 .6563 .54745 .69127 .53476 .6753 Metetra
.562 .101 0 r
.53476 .6753 .54745 .69127 .57168 .72165 .55898 .7061 Metetra
0 .332 .814 r
.55898 .7061 .57168 .72165 .59632 .73697 .58369 .72276 Metetra
.624 .722 .917 r
.58369 .72276 .59632 .73697 .62088 .72996 .60842 .71768 Metetra
.844 .792 .801 r
.60842 .71768 .62088 .72996 .64489 .70061 .63272 .69016 Metetra
.906 .801 .732 r
.63272 .69016 .64489 .70061 .66817 .65619 .65634 .64682 Metetra
.925 .806 .71 r
.65634 .64682 .66817 .65619 .69092 .60719 .6794 .59793 Metetra
.923 .814 .722 r
.6794 .59793 .69092 .60719 .71351 .56253 .70226 .5526 Metetra
.902 .821 .758 r
.70226 .5526 .71351 .56253 .73633 .52693 .72529 .51595 Metetra
.859 .82 .809 r
.72529 .51595 .73633 .52693 .75963 .50101 .74875 .48896 Metetra
.801 .805 .855 r
.74875 .48896 .75963 .50101 .78348 .48291 .77273 .47 Metetra
.743 .782 .884 r
.77273 .47 .78348 .48291 .80783 .46999 .79721 .45647 Metetra
.702 .763 .899 r
.79721 .45647 .80783 .46999 .83258 .45999 .82211 .44608 Metetra
.68 .751 .905 r
.82211 .44608 .83258 .45999 .85767 .45139 .84734 .43722 Metetra
.669 .745 .907 r
.84734 .43722 .85767 .45139 .88302 .44335 .87285 .429 Metetra
.665 .743 .908 r
.87285 .429 .88302 .44335 .90862 .43548 .89861 .42099 Metetra
.664 .742 .908 r
.89861 .42099 .90862 .43548 .93445 .42762 .92461 .413 Metetra
.664 .741 .908 r
.92461 .413 .93445 .42762 .96052 .41972 .95085 .40496 Metetra
.622 .729 .924 r
.36619 .56889 .37934 .58119 .40087 .57693 .38782 .56442 Metetra
.559 .707 .939 r
.38782 .56442 .40087 .57693 .42251 .57548 .40956 .56265 Metetra
.413 .64 .95 r
.40956 .56265 .42251 .57548 .44428 .57905 .43141 .56568 Metetra
.1 .456 .886 r
.43141 .56568 .44428 .57905 .46623 .59022 .45342 .57604 Metetra
0 .134 .649 r
.45342 .57604 .46623 .59022 .48849 .61092 .4757 .59571 Metetra
.591 .118 0 r
.4757 .59571 .48849 .61092 .51128 .64073 .49847 .62448 Metetra
.659 .197 0 r
.49847 .62448 .51128 .64073 .53476 .6753 .5219 .65844 Metetra
0 0 .446 r
.5219 .65844 .53476 .6753 .55898 .7061 .54609 .68952 Metetra
0 .3 .795 r
.54609 .68952 .55898 .7061 .58369 .72276 .57085 .70758 Metetra
.584 .696 .919 r
.57085 .70758 .58369 .72276 .60842 .71768 .59575 .70472 Metetra
.83 .787 .812 r
.59575 .70472 .60842 .71768 .63272 .69016 .62033 .67947 Metetra
.902 .802 .74 r
.62033 .67947 .63272 .69016 .65634 .64682 .64429 .63766 Metetra
.925 .811 .713 r
.64429 .63766 .65634 .64682 .6794 .59793 .66769 .58916 Metetra
.926 .82 .721 r
.66769 .58916 .6794 .59793 .70226 .5526 .69083 .54322 Metetra
.908 .828 .755 r
.69083 .54322 .70226 .5526 .72529 .51595 .71408 .50542 Metetra
.868 .828 .805 r
.71408 .50542 .72529 .51595 .74875 .48896 .7377 .47719 Metetra
.81 .813 .853 r
.7377 .47719 .74875 .48896 .77273 .47 .76183 .45717 Metetra
.751 .789 .884 r
.76183 .45717 .77273 .47 .79721 .45647 .78644 .4429 Metetra
.707 .767 .899 r
.78644 .4429 .79721 .45647 .82211 .44608 .81147 .43202 Metetra
.682 .753 .905 r
.81147 .43202 .82211 .44608 .84734 .43722 .83685 .42286 Metetra
.671 .746 .907 r
.83685 .42286 .84734 .43722 .87285 .429 .86252 .41444 Metetra
.666 .743 .908 r
.86252 .41444 .87285 .429 .89861 .42099 .88844 .40626 Metetra
.664 .742 .908 r
.88844 .40626 .89861 .42099 .92461 .413 .91461 .39813 Metetra
.664 .741 .908 r
.91461 .39813 .92461 .413 .95085 .40496 .94101 .38996 Metetra
.624 .73 .923 r
.35285 .55641 .36619 .56889 .38782 .56442 .37458 .55175 Metetra
.565 .709 .938 r
.37458 .55175 .38782 .56442 .40956 .56265 .39642 .54963 Metetra
.431 .649 .95 r
.39642 .54963 .40956 .56265 .43141 .56568 .41836 .55209 Metetra
.144 .483 .9 r
.41836 .55209 .43141 .56568 .45342 .57604 .44043 .56157 Metetra
0 .18 .691 r
.44043 .56157 .45342 .57604 .4757 .59571 .46274 .58004 Metetra
.545 .077 0 r
.46274 .58004 .4757 .59571 .49847 .62448 .48548 .60754 Metetra
.625 .168 0 r
.48548 .60754 .49847 .62448 .5219 .65844 .50887 .6406 Metetra
0 0 .468 r
.50887 .6406 .5219 .65844 .54609 .68952 .53302 .67175 Metetra
0 .273 .777 r
.53302 .67175 .54609 .68952 .57085 .70758 .5578 .6912 Metetra
.537 .662 .917 r
.5578 .6912 .57085 .70758 .59575 .70472 .58286 .69083 Metetra
.809 .778 .824 r
.58286 .69083 .59575 .70472 .62033 .67947 .60771 .66835 Metetra
.895 .803 .749 r
.60771 .66835 .62033 .67947 .64429 .63766 .63203 .62861 Metetra
.925 .815 .718 r
.63203 .62861 .64429 .63766 .66769 .58916 .65579 .58091 Metetra
.93 .826 .721 r
.65579 .58091 .66769 .58916 .69083 .54322 .67924 .53453 Metetra
.916 .836 .752 r
.67924 .53453 .69083 .54322 .71408 .50542 .70272 .49552 Metetra
.879 .838 .801 r
.70272 .49552 .71408 .50542 .7377 .47719 .72651 .46585 Metetra
.822 .824 .85 r
.72651 .46585 .7377 .47719 .76183 .45717 .75076 .44456 Metetra
.761 .798 .883 r
.75076 .44456 .76183 .45717 .78644 .4429 .7755 .42935 Metetra
.714 .773 .899 r
.7755 .42935 .78644 .4429 .81147 .43202 .80067 .41786 Metetra
.686 .756 .905 r
.80067 .41786 .81147 .43202 .83685 .42286 .82619 .40832 Metetra
.672 .747 .907 r
.82619 .40832 .83685 .42286 .86252 .41444 .85202 .39965 Metetra
.667 .744 .908 r
.85202 .39965 .86252 .41444 .88844 .40626 .8781 .3913 Metetra
.664 .742 .908 r
.8781 .3913 .88844 .40626 .91461 .39813 .90444 .38301 Metetra
.664 .741 .908 r
.90444 .38301 .91461 .39813 .94101 .38996 .93102 .3747 Metetra
.626 .731 .923 r
.3393 .54376 .35285 .55641 .37458 .55175 .36113 .5389 Metetra
.571 .712 .937 r
.36113 .5389 .37458 .55175 .39642 .54963 .38308 .53646 Metetra
.448 .657 .95 r
.38308 .53646 .39642 .54963 .41836 .55209 .4051 .53832 Metetra
.188 .51 .913 r
.4051 .53832 .41836 .55209 .44043 .56157 .42725 .54684 Metetra
0 .231 .735 r
.42725 .54684 .44043 .56157 .46274 .58004 .44959 .56397 Metetra
0 0 .505 r
.44959 .56397 .46274 .58004 .48548 .60754 .47233 .58992 Metetra
.58 .13 0 r
.47233 .58992 .48548 .60754 .50887 .6406 .49568 .62173 Metetra
0 0 .498 r
.49568 .62173 .50887 .6406 .53302 .67175 .51977 .65262 Metetra
0 .251 .764 r
.51977 .65262 .53302 .67175 .5578 .6912 .54457 .67333 Metetra
.485 .621 .909 r
.54457 .67333 .5578 .6912 .58286 .69083 .56974 .67566 Metetra
.78 .762 .837 r
.56974 .67566 .58286 .69083 .60771 .66835 .59486 .65649 Metetra
.884 .8 .762 r
.59486 .65649 .60771 .66835 .63203 .62861 .61954 .61951 Metetra
.923 .818 .725 r
.61954 .61951 .63203 .62861 .65579 .58091 .64368 .57318 Metetra
.933 .833 .722 r
.64368 .57318 .65579 .58091 .67924 .53453 .66746 .52668 Metetra
.923 .846 .749 r
.66746 .52668 .67924 .53453 .70272 .49552 .69119 .48646 Metetra
.891 .85 .796 r
.69119 .48646 .70272 .49552 .72651 .46585 .71516 .45517 Metetra
.837 .837 .846 r
.71516 .45517 .72651 .46585 .75076 .44456 .73955 .43235 Metetra
.774 .81 .881 r
.73955 .43235 .75076 .44456 .7755 .42935 .76441 .41596 Metetra
.723 .782 .899 r
.76441 .41596 .7755 .42935 .80067 .41786 .7897 .40367 Metetra
.691 .761 .905 r
.7897 .40367 .80067 .41786 .82619 .40832 .81537 .39363 Metetra
.675 .75 .907 r
.81537 .39363 .82619 .40832 .85202 .39965 .84134 .38466 Metetra
.668 .745 .908 r
.84134 .38466 .85202 .39965 .8781 .3913 .86759 .3761 Metetra
.665 .742 .908 r
.86759 .3761 .8781 .3913 .90444 .38301 .8941 .36765 Metetra
.664 .742 .908 r
.8941 .36765 .90444 .38301 .93102 .3747 .92086 .35919 Metetra
.627 .731 .922 r
.32554 .53094 .3393 .54376 .36113 .5389 .34748 .5259 Metetra
.577 .714 .936 r
.34748 .5259 .36113 .5389 .38308 .53646 .36953 .52314 Metetra
.464 .666 .95 r
.36953 .52314 .38308 .53646 .4051 .53832 .39165 .52441 Metetra
.231 .537 .924 r
.39165 .52441 .4051 .53832 .42725 .54684 .41387 .53192 Metetra
0 .286 .777 r
.41387 .53192 .42725 .54684 .44959 .56397 .43627 .54754 Metetra
0 .032 .567 r
.43627 .54754 .44959 .56397 .47233 .58992 .45901 .57166 Metetra
0 0 .466 r
.45901 .57166 .47233 .58992 .49568 .62173 .48232 .60181 Metetra
0 0 .536 r
.48232 .60181 .49568 .62173 .51977 .65262 .50636 .63199 Metetra
0 .239 .756 r
.50636 .63199 .51977 .65262 .54457 .67333 .53114 .65369 Metetra
.432 .574 .895 r
.53114 .65369 .54457 .67333 .56974 .67566 .55641 .6588 Metetra
.742 .737 .847 r
.55641 .6588 .56974 .67566 .59486 .65649 .58176 .64346 Metetra
.867 .793 .776 r
.58176 .64346 .59486 .65649 .61954 .61951 .6068 .61002 Metetra
.917 .82 .735 r
.6068 .61002 .61954 .61951 .64368 .57318 .63134 .56586 Metetra
.935 .84 .726 r
.63134 .56586 .64368 .57318 .66746 .52668 .65548 .51975 Metetra
.93 .856 .747 r
.65548 .51975 .66746 .52668 .69119 .48646 .67949 .4785 Metetra
.903 .864 .79 r
.67949 .4785 .69119 .48646 .71516 .45517 .70366 .44545 Metetra
.854 .854 .841 r
.70366 .44545 .71516 .45517 .73955 .43235 .72819 .4208 Metetra
.791 .826 .88 r
.72819 .4208 .73955 .43235 .76441 .41596 .75316 .4029 Metetra
.736 .794 .899 r
.75316 .4029 .76441 .41596 .7897 .40367 .77858 .38957 Metetra
.699 .769 .906 r
.77858 .38957 .7897 .40367 .81537 .39363 .80437 .37887 Metetra
.679 .754 .908 r
.80437 .37887 .81537 .39363 .84134 .38466 .8305 .36949 Metetra
.669 .746 .908 r
.8305 .36949 .84134 .38466 .86759 .3761 .85691 .36068 Metetra
.665 .743 .908 r
.85691 .36068 .86759 .3761 .8941 .36765 .88359 .35204 Metetra
.664 .742 .908 r
.88359 .35204 .8941 .36765 .92086 .35919 .91052 .34342 Metetra
.628 .732 .922 r
.31156 .51796 .32554 .53094 .34748 .5259 .33361 .51276 Metetra
.581 .717 .936 r
.33361 .51276 .34748 .5259 .36953 .52314 .35576 .5097 Metetra
.479 .673 .95 r
.35576 .5097 .36953 .52314 .39165 .52441 .37799 .51041 Metetra
.272 .562 .933 r
.37799 .51041 .39165 .52441 .41387 .53192 .4003 .51687 Metetra
0 .342 .817 r
.4003 .51687 .41387 .53192 .43627 .54754 .42276 .53085 Metetra
0 .102 .633 r
.42276 .53085 .43627 .54754 .45901 .57166 .44553 .55285 Metetra
0 0 .533 r
.44553 .55285 .45901 .57166 .48232 .60181 .46881 .58088 Metetra
0 .023 .583 r
.46881 .58088 .48232 .60181 .50636 .63199 .4928 .60981 Metetra
0 .239 .755 r
.4928 .60981 .50636 .63199 .53114 .65369 .51755 .63202 Metetra
.385 .528 .877 r
.51755 .63202 .53114 .65369 .55641 .6588 .54288 .63979 Metetra
.694 .703 .854 r
.54288 .63979 .55641 .6588 .58176 .64346 .56842 .62867 Metetra
.84 .779 .793 r
.56842 .62867 .58176 .64346 .6068 .61002 .59379 .59963 Metetra
.906 .818 .749 r
.59379 .59963 .6068 .61002 .63134 .56586 .61875 .55863 Metetra
.933 .845 .733 r
.61875 .55863 .63134 .56586 .65548 .51975 .64329 .51371 Metetra
.936 .866 .746 r
.64329 .51371 .65548 .51975 .67949 .4785 .66762 .47182 Metetra
.916 .879 .784 r
.66762 .47182 .67949 .4785 .70366 .44545 .69201 .43701 Metetra
.872 .874 .835 r
.69201 .43701 .70366 .44545 .72819 .4208 .71669 .41026 Metetra
.812 .848 .877 r
.71669 .41026 .72819 .4208 .75316 .4029 .74178 .39049 Metetra
.753 .812 .899 r
.74178 .39049 .75316 .4029 .77858 .38957 .7673 .37576 Metetra
.71 .781 .907 r
.7673 .37576 .77858 .38957 .80437 .37887 .79322 .36414 Metetra
.685 .76 .909 r
.79322 .36414 .80437 .37887 .8305 .36949 .81948 .35421 Metetra
.672 .75 .909 r
.81948 .35421 .8305 .36949 .85691 .36068 .84605 .34505 Metetra
.667 .744 .908 r
.84605 .34505 .85691 .36068 .88359 .35204 .8729 .33619 Metetra
.665 .742 .908 r
.8729 .33619 .88359 .35204 .91052 .34342 .90001 .32739 Metetra
.629 .733 .923 r
.29737 .50482 .31156 .51796 .33361 .51276 .31953 .4995 Metetra
.584 .719 .936 r
.31953 .4995 .33361 .51276 .35576 .5097 .34178 .49619 Metetra
.491 .681 .95 r
.34178 .49619 .35576 .5097 .37799 .51041 .36411 .49636 Metetra
.31 .585 .94 r
.36411 .49636 .37799 .51041 .4003 .51687 .38652 .50177 Metetra
.027 .398 .853 r
.38652 .50177 .4003 .51687 .42276 .53085 .40906 .51402 Metetra
0 .18 .701 r
.40906 .51402 .42276 .53085 .44553 .55285 .43187 .53363 Metetra
0 .058 .607 r
.43187 .53363 .44553 .55285 .46881 .58088 .45515 .55907 Metetra
0 .082 .638 r
.45515 .55907 .46881 .58088 .4928 .60981 .4791 .5861 Metetra
0 .253 .762 r
.4791 .5861 .4928 .60981 .51755 .63202 .5038 .60816 Metetra
.35 .487 .856 r
.5038 .60816 .51755 .63202 .54288 .63979 .52915 .61821 Metetra
.639 .658 .853 r
.52915 .61821 .54288 .63979 .56842 .62867 .55485 .61146 Metetra
.802 .753 .808 r
.55485 .61146 .56842 .62867 .59379 .59963 .58052 .58758 Metetra
.886 .809 .768 r
.58052 .58758 .59379 .59963 .61875 .55863 .60588 .55088 Metetra
.926 .847 .746 r
.60588 .55088 .61875 .55863 .64329 .51371 .63085 .50827 Metetra
.938 .875 .749 r
.63085 .50827 .64329 .51371 .66762 .47182 .65554 .46651 Metetra
.926 .894 .778 r
.65554 .46651 .66762 .47182 .69201 .43701 .6802 .4302 Metetra
.891 .896 .825 r
.6802 .4302 .69201 .43701 .71669 .41026 .70506 .40119 Metetra
.836 .875 .871 r
.70506 .40119 .71669 .41026 .74178 .39049 .73026 .37916 Metetra
.776 .837 .899 r
.73026 .37916 .74178 .39049 .7673 .37576 .75588 .36259 Metetra
.726 .799 .91 r
.75588 .36259 .7673 .37576 .79322 .36414 .78191 .34969 Metetra
.694 .772 .911 r
.78191 .34969 .79322 .36414 .81948 .35421 .8083 .33894 Metetra
.677 .755 .91 r
.8083 .33894 .81948 .35421 .84605 .34505 .83502 .32929 Metetra
.669 .747 .909 r
.83502 .32929 .84605 .34505 .8729 .33619 .86203 .32012 Metetra
.666 .744 .908 r
.86203 .32012 .8729 .33619 .90001 .32739 .88932 .3111 Metetra
.628 .734 .924 r
.28295 .49154 .29737 .50482 .31953 .4995 .30521 .48614 Metetra
.586 .721 .937 r
.30521 .48614 .31953 .4995 .34178 .49619 .32757 .48263 Metetra
.502 .688 .951 r
.32757 .48263 .34178 .49619 .36411 .49636 .35 .48231 Metetra
.344 .607 .947 r
.35 .48231 .36411 .49636 .38652 .50177 .37251 .48669 Metetra
.104 .452 .884 r
.37251 .48669 .38652 .50177 .40906 .51402 .39515 .49714 Metetra
0 .263 .766 r
.39515 .49714 .40906 .51402 .43187 .53363 .41803 .51415 Metetra
0 .146 .684 r
.41803 .51415 .43187 .53363 .45515 .55907 .44134 .53658 Metetra
0 .155 .696 r
.44134 .53658 .45515 .55907 .4791 .5861 .46527 .56104 Metetra
.039 .28 .774 r
.46527 .56104 .4791 .5861 .5038 .60816 .48992 .58214 Metetra
.332 .457 .837 r
.48992 .58214 .5038 .60816 .52915 .61821 .51525 .59377 Metetra
.583 .609 .844 r
.51525 .59377 .52915 .61821 .55485 .61146 .54105 .59117 Metetra
.751 .715 .818 r
.54105 .59117 .55485 .61146 .58052 .58758 .56697 .57294 Metetra
.853 .788 .787 r
.56697 .57294 .58052 .58758 .60588 .55088 .59271 .54166 Metetra
.91 .841 .764 r
.59271 .54166 .60588 .55088 .63085 .50827 .61812 .50274 Metetra
.934 .88 .758 r
.61812 .50274 .63085 .50827 .65554 .46651 .64323 .4623 Metetra
.932 .907 .775 r
.64323 .4623 .65554 .46651 .6802 .4302 .66822 .42518 Metetra
.907 .918 .815 r
.66822 .42518 .6802 .4302 .70506 .40119 .69329 .39405 Metetra
.862 .906 .862 r
.69329 .39405 .70506 .40119 .73026 .37916 .71864 .36947 Metetra
.804 .871 .897 r
.71864 .36947 .73026 .37916 .75588 .36259 .74435 .35058 Metetra
.749 .828 .912 r
.74435 .35058 .75588 .36259 .78191 .34969 .77047 .3359 Metetra
.71 .791 .915 r
.77047 .3359 .78191 .34969 .8083 .33894 .79697 .32394 Metetra
.686 .767 .913 r
.79697 .32394 .8083 .33894 .83502 .32929 .82382 .31353 Metetra
.673 .753 .911 r
.82382 .31353 .83502 .32929 .86203 .32012 .85099 .3039 Metetra
.668 .746 .909 r
.85099 .3039 .86203 .32012 .88932 .3111 .87845 .29459 Metetra
.626 .735 .925 r
.26829 .47815 .28295 .49154 .30521 .48614 .29065 .47271 Metetra
.586 .724 .938 r
.29065 .47271 .30521 .48614 .32757 .48263 .31311 .46907 Metetra
.51 .695 .952 r
.31311 .46907 .32757 .48263 .35 .48231 .33566 .46831 Metetra
.374 .628 .952 r
.33566 .46831 .35 .48231 .37251 .48669 .35828 .47169 Metetra
.177 .502 .909 r
.35828 .47169 .37251 .48669 .39515 .49714 .38103 .48031 Metetra
0 .348 .824 r
.38103 .48031 .39515 .49714 .41803 .51415 .40401 .49459 Metetra
0 .243 .758 r
.40401 .49459 .41803 .51415 .44134 .53658 .42738 .51366 Metetra
0 .236 .753 r
.42738 .51366 .44134 .53658 .46527 .56104 .45131 .53494 Metetra
.11 .318 .791 r
.45131 .53494 .46527 .56104 .48992 .58214 .47592 .55421 Metetra
.333 .443 .823 r
.47592 .55421 .48992 .58214 .51525 .59377 .50122 .56645 Metetra
.536 .564 .831 r
.50122 .56645 .51525 .59377 .54105 .59117 .52705 .56733 Metetra
.693 .667 .82 r
.52705 .56733 .54105 .59117 .56697 .57294 .55316 .55475 Metetra
.805 .751 .803 r
.55316 .55475 .56697 .57294 .59271 .54166 .57923 .52972 Metetra
.879 .821 .787 r
.57923 .52972 .59271 .54166 .61812 .50274 .60508 .49594 Metetra
.92 .876 .776 r
.60508 .49594 .61812 .50274 .64323 .4623 .63064 .45839 Metetra
.93 .914 .78 r
.63064 .45839 .64323 .4623 .66822 .42518 .65602 .42171 Metetra
.916 .936 .806 r
.65602 .42171 .66822 .42518 .69329 .39405 .68138 .38911 Metetra
.882 .936 .849 r
.68138 .38911 .69329 .39405 .71864 .36947 .7069 .36204 Metetra
.833 .912 .89 r
.7069 .36204 .71864 .36947 .74435 .35058 .73273 .34045 Metetra
.779 .868 .914 r
.73273 .34045 .74435 .35058 .77047 .3359 .75893 .32343 Metetra
.733 .823 .92 r
.75893 .32343 .77047 .3359 .79697 .32394 .78552 .3097 Metetra
.701 .788 .918 r
.78552 .3097 .79697 .32394 .82382 .31353 .81248 .2981 Metetra
.682 .765 .914 r
.81248 .2981 .82382 .31353 .85099 .3039 .83978 .28771 Metetra
.672 .753 .911 r
.83978 .28771 .85099 .3039 .87845 .29459 .8674 .27793 Metetra
.623 .736 .928 r
.25339 .46467 .26829 .47815 .29065 .47271 .27585 .45926 Metetra
.585 .726 .941 r
.27585 .45926 .29065 .47271 .31311 .46907 .29841 .45553 Metetra
.516 .701 .954 r
.29841 .45553 .31311 .46907 .33566 .46831 .32106 .45438 Metetra
.402 .646 .956 r
.32106 .45438 .33566 .46831 .35828 .47169 .34381 .45679 Metetra
.247 .549 .929 r
.34381 .45679 .35828 .47169 .38103 .48031 .36669 .46358 Metetra
.097 .429 .872 r
.36669 .46358 .38103 .48031 .40401 .49459 .38979 .47507 Metetra
.024 .341 .821 r
.38979 .47507 .40401 .49459 .42738 .51366 .41326 .49058 Metetra
.062 .321 .803 r
.41326 .49058 .42738 .51366 .45131 .53494 .43723 .50822 Metetra
.188 .365 .809 r
.43723 .50822 .45131 .53494 .47592 .55421 .46182 .52487 Metetra
.35 .443 .816 r
.46182 .52487 .47592 .55421 .50122 .56645 .48708 .53665 Metetra
.504 .53 .817 r
.48708 .53665 .50122 .56645 .52705 .56733 .51291 .53991 Metetra
.636 .617 .814 r
.51291 .53991 .52705 .56733 .55316 .55475 .53911 .53234 Metetra
.745 .701 .81 r
.53911 .53234 .55316 .55475 .57923 .52972 .56544 .51377 Metetra
.831 .782 .806 r
.56544 .51377 .57923 .52972 .60508 .49594 .59168 .48625 Metetra
.89 .854 .8 r
.59168 .48625 .60508 .49594 .63064 .45839 .61771 .45328 Metetra
.917 .909 .798 r
.61771 .45328 .63064 .45839 .65602 .42171 .64354 .41879 Metetra
.915 .944 .807 r
.64354 .41879 .65602 .42171 .68138 .38911 .66927 .38606 Metetra
.892 .958 .834 r
.66927 .38606 .68138 .38911 .7069 .36204 .69505 .35717 Metetra
.856 .949 .875 r
.69505 .35717 .7069 .36204 .73273 .34045 .72104 .33292 Metetra
.811 .917 .909 r
.72104 .33292 .73273 .34045 .75893 .32343 .74734 .31314 Metetra
.765 .87 .925 r
.74734 .31314 .75893 .32343 .78552 .3097 .774 .29704 Metetra
.726 .824 .926 r
.774 .29704 .78552 .3097 .81248 .2981 .80104 .28363 Metetra
.698 .79 .921 r
.80104 .28363 .81248 .2981 .83978 .28771 .82845 .27199 Metetra
.682 .767 .916 r
.82845 .27199 .83978 .28771 .8674 .27793 .8562 .2614 Metetra
.619 .738 .931 r
.23823 .45117 .25339 .46467 .27585 .45926 .26078 .44582 Metetra
.582 .729 .944 r
.26078 .44582 .27585 .45926 .29841 .45553 .28344 .44204 Metetra
.521 .708 .956 r
.28344 .44204 .29841 .45553 .32106 .45438 .3062 .44051 Metetra
.429 .664 .959 r
.3062 .44051 .32106 .45438 .34381 .45679 .32908 .44195 Metetra
.312 .59 .943 r
.32908 .44195 .34381 .45679 .36669 .46358 .35211 .44695 Metetra
.205 .502 .906 r
.35211 .44695 .36669 .46358 .38979 .47507 .37536 .45565 Metetra
.155 .43 .868 r
.37536 .45565 .38979 .47507 .41326 .49058 .39895 .46757 Metetra
.182 .402 .841 r
.39895 .46757 .41326 .49058 .43723 .50822 .423 .48135 Metetra
.268 .416 .825 r
.423 .48135 .43723 .50822 .46182 .52487 .44762 .49479 Metetra
.379 .456 .814 r
.44762 .49479 .46182 .52487 .48708 .53665 .47284 .50508 Metetra
.49 .512 .807 r
.47284 .50508 .48708 .53665 .51291 .53991 .49864 .50941 Metetra
.591 .575 .804 r
.49864 .50941 .51291 .53991 .53911 .53234 .52489 .50565 Metetra
.684 .647 .807 r
.52489 .50565 .53911 .53234 .56544 .51377 .55138 .49295 Metetra
.768 .726 .813 r
.55138 .49295 .56544 .51377 .59168 .48625 .57793 .47204 Metetra
.839 .808 .82 r
.57793 .47204 .59168 .48625 .61771 .45328 .60439 .44497 Metetra
.886 .882 .823 r
.60439 .44497 .61771 .45328 .64354 .41879 .63069 .41455 Metetra
.902 .936 .824 r
.63069 .41455 .64354 .41879 .66927 .38606 .65687 .38358 Metetra
.891 .965 .833 r
.65687 .38358 .66927 .38606 .69505 .35717 .68301 .35433 Metetra
.865 .973 .857 r
.68301 .35433 .69505 .35717 .72104 .33292 .70925 .32823 Metetra
.832 .96 .893 r
.70925 .32823 .72104 .33292 .74734 .31314 .7357 .30582 Metetra
.795 .925 .922 r
.7357 .30582 .74734 .31314 .774 .29704 .76246 .28697 Metetra
.757 .879 .934 r
.76246 .28697 .774 .29704 .80104 .28363 .78957 .27113 Metetra
.724 .833 .933 r
.78957 .27113 .80104 .28363 .82845 .27199 .81706 .25757 Metetra
.7 .798 .926 r
.81706 .25757 .82845 .27199 .8562 .2614 .84491 .24558 Metetra
.614 .74 .935 r
.22279 .43767 .23823 .45117 .26078 .44582 .24544 .43242 Metetra
.58 .732 .947 r
.24544 .43242 .26078 .44582 .28344 .44204 .2682 .42858 Metetra
.528 .715 .958 r
.2682 .42858 .28344 .44204 .3062 .44051 .29108 .42664 Metetra
.456 .68 .961 r
.29108 .42664 .3062 .44051 .32908 .44195 .3141 .42711 Metetra
.374 .626 .951 r
.3141 .42711 .32908 .44195 .35211 .44695 .33729 .43033 Metetra
.303 .562 .928 r
.33729 .43033 .35211 .44695 .37536 .45565 .36071 .43635 Metetra
.272 .506 .897 r
.36071 .43635 .37536 .45565 .39895 .46757 .38446 .4448 Metetra
.289 .473 .867 r
.38446 .4448 .39895 .46757 .423 .48135 .40862 .45473 Metetra
.344 .466 .84 r
.40862 .45473 .423 .48135 .44762 .49479 .43329 .46467 Metetra
.415 .479 .818 r
.43329 .46467 .44762 .49479 .47284 .50508 .45851 .47271 Metetra
.49 .508 .803 r
.45851 .47271 .47284 .50508 .49864 .50941 .48428 .47685 Metetra
.563 .549 .797 r
.48428 .47685 .49864 .50941 .52489 .50565 .51052 .47537 Metetra
.635 .602 .799 r
.51052 .47537 .52489 .50565 .55138 .49295 .5371 .46722 Metetra
.705 .666 .809 r
.5371 .46722 .55138 .49295 .57793 .47204 .56387 .45233 Metetra
.773 .742 .825 r
.56387 .45233 .57793 .47204 .60439 .44497 .59067 .43157 Metetra
.832 .824 .841 r
.59067 .43157 .60439 .44497 .63069 .41455 .61742 .40656 Metetra
.87 .898 .85 r
.61742 .40656 .63069 .41455 .65687 .38358 .64407 .3793 Metetra
.878 .951 .853 r
.64407 .3793 .65687 .38358 .68301 .35433 .67066 .35173 Metetra
.862 .976 .857 r
.67066 .35173 .68301 .35433 .70925 .32823 .69727 .32542 Metetra
.836 .981 .875 r
.69727 .32542 .70925 .32823 .7357 .30582 .72399 .3014 Metetra
.81 .968 .904 r
.72399 .3014 .7357 .30582 .76246 .28697 .75092 .28015 Metetra
.783 .938 .93 r
.75092 .28015 .76246 .28697 .78957 .27113 .77814 .26167 Metetra
.754 .895 .941 r
.77814 .26167 .78957 .27113 .81706 .25757 .80569 .24564 Metetra
.726 .851 .94 r
.80569 .24564 .81706 .25757 .84491 .24558 .83361 .23159 Metetra
.609 .743 .94 r
.20707 .42423 .22279 .43767 .24544 .43242 .22981 .41904 Metetra
.579 .736 .95 r
.22981 .41904 .24544 .43242 .2682 .42858 .25268 .41508 Metetra
.537 .721 .958 r
.25268 .41508 .2682 .42858 .29108 .42664 .27569 .41267 Metetra
.485 .694 .961 r
.27569 .41267 .29108 .42664 .3141 .42711 .29886 .41212 Metetra
.43 .655 .954 r
.29886 .41212 .3141 .42711 .33729 .43033 .32223 .4136 Metetra
.388 .609 .937 r
.32223 .4136 .33729 .43033 .36071 .43635 .34583 .4171 Metetra
.369 .564 .912 r
.34583 .4171 .36071 .43635 .38446 .4448 .36975 .42232 Metetra
.379 .531 .881 r
.36975 .42232 .38446 .4448 .40862 .45473 .39406 .42864 Metetra
.411 .512 .851 r
.39406 .42864 .40862 .45473 .43329 .46467 .41882 .43509 Metetra
.455 .508 .824 r
.41882 .43509 .43329 .46467 .45851 .47271 .44407 .44047 Metetra
.502 .517 .805 r
.44407 .44047 .45851 .47271 .48428 .47685 .46983 .44345 Metetra
.552 .539 .794 r
.46983 .44345 .48428 .47685 .51052 .47537 .49605 .44277 Metetra
.602 .572 .793 r
.49605 .44277 .51052 .47537 .5371 .46722 .52266 .43752 Metetra
.654 .618 .801 r
.52266 .43752 .5371 .46722 .56387 .45233 .54954 .42725 Metetra
.708 .676 .817 r
.54954 .42725 .56387 .45233 .59067 .43157 .57659 .41213 Metetra
.763 .747 .838 r
.57659 .41213 .59067 .43157 .61742 .40656 .6037 .39285 Metetra
.812 .825 .861 r
.6037 .39285 .61742 .40656 .64407 .3793 .6308 .37054 Metetra
.844 .898 .876 r
.6308 .37054 .64407 .3793 .67066 .35173 .65787 .34651 Metetra
.849 .951 .881 r
.65787 .34651 .67066 .35173 .69727 .32542 .68494 .32206 Metetra
.833 .977 .882 r
.68494 .32206 .69727 .32542 .72399 .3014 .71205 .29827 Metetra
.81 .982 .891 r
.71205 .29827 .72399 .3014 .75092 .28015 .73928 .27594 Metetra
.789 .974 .912 r
.73928 .27594 .75092 .28015 .77814 .26167 .76671 .25552 Metetra
.771 .952 .934 r
.76671 .25552 .77814 .26167 .80569 .24564 .7944 .23713 Metetra
.751 .917 .947 r
.7944 .23713 .80569 .24564 .83361 .23159 .8224 .22068 Metetra
.606 .746 .943 r
.19106 .4108 .20707 .42423 .22981 .41904 .2139 .40562 Metetra
.58 .739 .951 r
.2139 .40562 .22981 .41904 .25268 .41508 .23689 .40143 Metetra
.549 .727 .957 r
.23689 .40143 .25268 .41508 .27569 .41267 .26004 .39845 Metetra
.514 .706 .958 r
.26004 .39845 .27569 .41267 .29886 .41212 .28337 .39682 Metetra
.481 .677 .952 r
.28337 .39682 .29886 .41212 .32223 .4136 .30692 .39663 Metetra
.456 .643 .937 r
.30692 .39663 .32223 .4136 .34583 .4171 .33073 .39781 Metetra
.446 .607 .915 r
.33073 .39781 .34583 .4171 .36975 .42232 .35483 .40014 Metetra
.451 .575 .888 r
.35483 .40014 .36975 .42232 .39406 .42864 .3793 .40323 Metetra
.468 .552 .859 r
.3793 .40323 .39406 .42864 .41882 .43509 .40418 .40647 Metetra
.493 .538 .832 r
.40418 .40647 .41882 .43509 .44407 .44047 .42949 .40911 Metetra
.521 .535 .811 r
.42949 .40911 .44407 .44047 .46983 .44345 .45526 .41034 Metetra
.552 .543 .798 r
.45526 .41034 .46983 .44345 .49605 .44277 .48147 .40933 Metetra
.585 .56 .792 r
.48147 .40933 .49605 .44277 .52266 .43752 .50808 .40539 Metetra
.621 .588 .795 r
.50808 .40539 .52266 .43752 .54954 .42725 .53502 .39804 Metetra
.659 .627 .806 r
.53502 .39804 .54954 .42725 .57659 .41213 .56222 .38712 Metetra
.701 .678 .824 r
.56222 .38712 .57659 .41213 .6037 .39285 .58958 .37278 Metetra
.743 .74 .849 r
.58958 .37278 .6037 .39285 .6308 .37054 .61704 .35549 Metetra
.783 .811 .875 r
.61704 .35549 .6308 .37054 .65787 .34651 .64456 .33594 Metetra
.811 .88 .896 r
.64456 .33594 .65787 .34651 .68494 .32206 .6721 .31494 Metetra
.819 .934 .907 r
.6721 .31494 .68494 .32206 .71205 .29827 .69968 .29333 Metetra
.808 .965 .908 r
.69968 .29333 .71205 .29827 .73928 .27594 .72734 .27184 Metetra
.788 .976 .91 r
.72734 .27184 .73928 .27594 .76671 .25552 .75512 .25108 Metetra
.77 .973 .92 r
.75512 .25108 .76671 .25552 .7944 .23713 .78308 .23144 Metetra
.756 .96 .935 r
.78308 .23144 .7944 .23713 .8224 .22068 .81128 .21317 Metetra
.605 .748 .945 r
.17475 .3973 .19106 .4108 .2139 .40562 .1977 .392 Metetra
.586 .742 .95 r
.1977 .392 .2139 .40562 .23689 .40143 .22082 .38746 Metetra
.564 .731 .953 r
.22082 .38746 .23689 .40143 .26004 .39845 .24413 .38379 Metetra
.543 .714 .952 r
.24413 .38379 .26004 .39845 .28337 .39682 .26764 .38107 Metetra
.523 .692 .945 r
.26764 .38107 .28337 .39682 .30692 .39663 .29138 .37929 Metetra
.51 .665 .932 r
.29138 .37929 .30692 .39663 .33073 .39781 .31538 .3784 Metetra
.504 .637 .913 r
.31538 .3784 .33073 .39781 .35483 .40014 .33969 .37824 Metetra
.506 .609 .889 r
.33969 .37824 .35483 .40014 .3793 .40323 .36432 .37855 Metetra
.514 .585 .864 r
.36432 .37855 .3793 .40323 .40418 .40647 .38933 .37897 Metetra
.527 .568 .84 r
.38933 .37897 .40418 .40647 .42949 .40911 .41474 .37907 Metetra
.543 .558 .82 r
.41474 .37907 .42949 .40911 .45526 .41034 .44056 .37835 Metetra
.561 .556 .806 r
.44056 .37835 .45526 .41034 .48147 .40933 .46678 .37631 Metetra
.582 .562 .797 r
.46678 .37631 .48147 .40933 .50808 .40539 .49339 .37249 Metetra
.604 .576 .795 r
.49339 .37249 .50808 .40539 .53502 .39804 .52036 .36652 Metetra
.629 .599 .8 r
.52036 .36652 .53502 .39804 .56222 .38712 .54763 .35815 Metetra
.657 .631 .812 r
.54763 .35815 .56222 .38712 .58958 .37278 .57515 .34731 Metetra
.688 .673 .83 r
.57515 .34731 .58958 .37278 .61704 .35549 .60287 .3341 Metetra
.72 .724 .853 r
.60287 .3341 .61704 .35549 .64456 .33594 .63072 .31878 Metetra
.75 .783 .88 r
.63072 .31878 .64456 .33594 .6721 .31494 .65868 .30174 Metetra
.775 .844 .904 r
.65868 .30174 .6721 .31494 .69968 .29333 .68673 .28344 Metetra
.787 .898 .922 r
.68673 .28344 .69968 .29333 .72734 .27184 .71487 .26438 Metetra
.784 .937 .929 r
.71487 .26438 .72734 .27184 .75512 .25108 .74311 .24506 Metetra
.771 .957 .931 r
.74311 .24506 .75512 .25108 .78308 .23144 .77149 .2259 Metetra
.755 .964 .933 r
.77149 .2259 .78308 .23144 .81128 .21317 .80003 .20724 Metetra
.608 .749 .944 r
.15815 .38358 .17475 .3973 .1977 .392 .18122 .37801 Metetra
.595 .743 .947 r
.18122 .37801 .1977 .392 .22082 .38746 .20449 .37299 Metetra
.581 .733 .947 r
.20449 .37299 .22082 .38746 .24413 .38379 .22797 .36856 Metetra
.569 .719 .944 r
.22797 .36856 .24413 .38379 .26764 .38107 .25166 .36474 Metetra
.558 .701 .936 r
.25166 .36474 .26764 .38107 .29138 .37929 .2756 .36152 Metetra
.551 .68 .924 r
.2756 .36152 .29138 .37929 .31538 .3784 .2998 .35882 Metetra
.547 .657 .908 r
.2998 .35882 .31538 .3784 .33969 .37824 .3243 .35656 Metetra
.547 .634 .889 r
.3243 .35656 .33969 .37824 .36432 .37855 .34911 .35456 Metetra
.55 .613 .868 r
.34911 .35456 .36432 .37855 .38933 .37897 .37427 .35262 Metetra
.556 .595 .848 r
.37427 .35262 .38933 .37897 .41474 .37907 .39978 .35049 Metetra
.564 .583 .83 r
.39978 .35049 .41474 .37907 .44056 .37835 .42567 .34789 Metetra
.574 .575 .816 r
.42567 .34789 .44056 .37835 .46678 .37631 .45194 .34453 Metetra
.586 .574 .806 r
.45194 .34453 .46678 .37631 .49339 .37249 .47858 .34012 Metetra
.6 .579 .801 r
.47858 .34012 .49339 .37249 .52036 .36652 .50557 .33441 Metetra
.615 .59 .801 r
.50557 .33441 .52036 .36652 .54763 .35815 .53289 .3272 Metetra
.633 .607 .807 r
.53289 .3272 .54763 .35815 .57515 .34731 .5605 .31836 Metetra
.652 .632 .817 r
.5605 .31836 .57515 .34731 .60287 .3341 .58837 .30785 Metetra
.674 .664 .833 r
.58837 .30785 .60287 .3341 .63072 .31878 .61646 .2957 Metetra
.697 .704 .853 r
.61646 .2957 .63072 .31878 .65868 .30174 .64474 .28204 Metetra
.719 .75 .876 r
.64474 .28204 .65868 .30174 .68673 .28344 .67317 .26708 Metetra
.739 .8 .901 r
.67317 .26708 .68673 .28344 .71487 .26438 .70175 .25105 Metetra
.753 .849 .922 r
.70175 .25105 .71487 .26438 .74311 .24506 .73046 .23424 Metetra
.759 .89 .937 r
.73046 .23424 .74311 .24506 .77149 .2259 .75932 .21694 Metetra
.755 .921 .945 r
.75932 .21694 .77149 .2259 .80003 .20724 .78832 .19943 Metetra
.614 .748 .941 r
.14127 .36943 .15815 .38358 .18122 .37801 .16449 .36349 Metetra
.606 .742 .941 r
.16449 .36349 .18122 .37801 .20449 .37299 .18792 .35789 Metetra
.598 .733 .939 r
.18792 .35789 .20449 .37299 .22797 .36856 .21156 .35267 Metetra
.591 .721 .934 r
.21156 .35267 .22797 .36856 .25166 .36474 .23545 .34781 Metetra
.585 .706 .927 r
.23545 .34781 .25166 .36474 .2756 .36152 .25958 .34329 Metetra
.581 .69 .916 r
.25958 .34329 .2756 .36152 .2998 .35882 .28398 .33906 Metetra
.578 .671 .903 r
.28398 .33906 .2998 .35882 .3243 .35656 .30866 .33506 Metetra
.577 .653 .888 r
.30866 .33506 .3243 .35656 .34911 .35456 .33365 .33119 Metetra
.578 .635 .871 r
.33365 .33119 .34911 .35456 .37427 .35262 .35895 .32733 Metetra
.58 .619 .855 r
.35895 .32733 .37427 .35262 .39978 .35049 .3846 .32335 Metetra
.584 .606 .841 r
.3846 .32335 .39978 .35049 .42567 .34789 .41058 .31908 Metetra
.589 .597 .828 r
.41058 .31908 .42567 .34789 .45194 .34453 .43692 .31436 Metetra
.595 .592 .818 r
.43692 .31436 .45194 .34453 .47858 .34012 .4636 .30903 Metetra
.603 .591 .812 r
.4636 .30903 .47858 .34012 .50557 .33441 .49063 .30294 Metetra
.612 .594 .809 r
.49063 .30294 .50557 .33441 .53289 .3272 .518 .29593 Metetra
.622 .602 .809 r
.518 .29593 .53289 .3272 .5605 .31836 .54567 .28792 Metetra
.634 .615 .814 r
.54567 .28792 .5605 .31836 .58837 .30785 .57365 .27882 Metetra
.647 .633 .822 r
.57365 .27882 .58837 .30785 .61646 .2957 .60189 .26859 Metetra
.662 .657 .834 r
.60189 .26859 .61646 .2957 .64474 .28204 .63038 .25725 Metetra
.678 .685 .85 r
.63038 .25725 .64474 .28204 .67317 .26708 .6591 .24483 Metetra
.694 .719 .869 r
.6591 .24483 .67317 .26708 .70175 .25105 .68802 .23144 Metetra
.709 .756 .889 r
.68802 .23144 .70175 .25105 .73046 .23424 .71713 .21719 Metetra
.722 .795 .91 r
.71713 .21719 .73046 .23424 .75932 .21694 .74643 .20222 Metetra
.731 .833 .928 r
.74643 .20222 .75932 .21694 .78832 .19943 .7759 .18669 Metetra
.622 .746 .935 r
.12413 .35471 .14127 .36943 .16449 .36349 .14751 .3483 Metetra
.617 .739 .933 r
.14751 .3483 .16449 .36349 .18792 .35789 .1711 .34208 Metetra
.612 .731 .93 r
.1711 .34208 .18792 .35789 .21156 .35267 .19492 .33607 Metetra
.608 .721 .925 r
.19492 .33607 .21156 .35267 .23545 .34781 .21899 .33026 Metetra
.605 .709 .918 r
.21899 .33026 .23545 .34781 .25958 .34329 .24331 .32462 Metetra
.602 .696 .909 r
.24331 .32462 .25958 .34329 .28398 .33906 .26789 .31912 Metetra
.601 .682 .899 r
.26789 .31912 .28398 .33906 .30866 .33506 .29276 .31372 Metetra
.6 .667 .887 r
.29276 .31372 .30866 .33506 .33365 .33119 .31792 .30836 Metetra
.599 .653 .874 r
.31792 .30836 .33365 .33119 .35895 .32733 .34338 .30297 Metetra
.6 .64 .862 r
.34338 .30297 .35895 .32733 .3846 .32335 .36916 .29748 Metetra
.601 .628 .85 r
.36916 .29748 .3846 .32335 .41058 .31908 .39526 .2918 Metetra
.603 .619 .84 r
.39526 .2918 .41058 .31908 .43692 .31436 .42168 .28585 Metetra
.606 .612 .831 r
.42168 .28585 .43692 .31436 .4636 .30903 .44844 .27953 Metetra
.61 .608 .824 r
.44844 .27953 .4636 .30903 .49063 .30294 .47553 .27275 Metetra
.615 .607 .819 r
.47553 .27275 .49063 .30294 .518 .29593 .50295 .26543 Metetra
.62 .609 .817 r
.50295 .26543 .518 .29593 .54567 .28792 .53069 .25749 Metetra
.627 .614 .818 r
.53069 .25749 .54567 .28792 .57365 .27882 .55874 .24887 Metetra
.635 .623 .821 r
.55874 .24887 .57365 .27882 .60189 .26859 .58709 .23953 Metetra
.644 .635 .827 r
.58709 .23953 .60189 .26859 .63038 .25725 .61573 .22943 Metetra
.653 .651 .836 r
.61573 .22943 .63038 .25725 .6591 .24483 .64464 .21857 Metetra
.664 .671 .847 r
.64464 .21857 .6591 .24483 .68802 .23144 .67381 .20697 Metetra
.674 .694 .86 r
.67381 .20697 .68802 .23144 .71713 .21719 .70322 .19465 Metetra
.685 .72 .876 r
.70322 .19465 .71713 .21719 .74643 .20222 .73287 .18166 Metetra
.696 .749 .893 r
.73287 .18166 .74643 .20222 .7759 .18669 .76274 .16806 Metetra
.63 .742 .928 r
.10674 .33931 .12413 .35471 .14751 .3483 .13028 .33239 Metetra
.627 .736 .926 r
.13028 .33239 .14751 .3483 .1711 .34208 .15404 .32556 Metetra
.624 .729 .922 r
.15404 .32556 .1711 .34208 .19492 .33607 .17804 .31882 Metetra
.622 .721 .917 r
.17804 .31882 .19492 .33607 .21899 .33026 .20228 .31216 Metetra
.62 .711 .911 r
.20228 .31216 .21899 .33026 .24331 .32462 .22678 .30557 Metetra
.618 .701 .904 r
.22678 .30557 .24331 .32462 .26789 .31912 .25155 .29903 Metetra
.617 .69 .895 r
.25155 .29903 .26789 .31912 .29276 .31372 .27659 .2925 Metetra
.616 .679 .887 r
.27659 .2925 .29276 .31372 .31792 .30836 .30191 .28596 Metetra
.615 .667 .877 r
.30191 .28596 .31792 .30836 .34338 .30297 .32753 .27937 Metetra
.615 .657 .868 r
.32753 .27937 .34338 .30297 .36916 .29748 .35345 .27268 Metetra
.615 .647 .859 r
.35345 .27268 .36916 .29748 .39526 .2918 .37967 .26585 Metetra
.616 .639 .85 r
.37967 .26585 .39526 .2918 .42168 .28585 .40621 .25884 Metetra
.617 .632 .843 r
.40621 .25884 .42168 .28585 .44844 .27953 .43306 .25159 Metetra
.619 .627 .837 r
.43306 .25159 .44844 .27953 .47553 .27275 .46024 .24405 Metetra
.621 .623 .832 r
.46024 .24405 .47553 .27275 .50295 .26543 .48773 .23617 Metetra
.624 .622 .828 r
.48773 .23617 .50295 .26543 .53069 .25749 .51554 .22791 Metetra
.627 .623 .827 r
.51554 .22791 .53069 .25749 .55874 .24887 .54368 .21923 Metetra
.631 .626 .827 r
.54368 .21923 .55874 .24887 .58709 .23953 .57212 .21008 Metetra
.636 .632 .829 r
.57212 .21008 .58709 .23953 .61573 .22943 .60087 .20045 Metetra
.642 .64 .832 r
.60087 .20045 .61573 .22943 .64464 .21857 .62992 .19031 Metetra
.648 .65 .838 r
.62992 .19031 .64464 .21857 .67381 .20697 .65926 .17965 Metetra
.655 .663 .846 r
.65926 .17965 .67381 .20697 .70322 .19465 .68889 .16846 Metetra
.662 .678 .855 r
.68889 .16846 .70322 .19465 .73287 .18166 .7188 .15675 Metetra
.669 .695 .866 r
.7188 .15675 .73287 .18166 .76274 .16806 .74897 .14454 Metetra
.637 .738 .921 r
.08911 .32321 .10674 .33931 .13028 .33239 .1128 .31577 Metetra
.635 .733 .919 r
.1128 .31577 .13028 .33239 .15404 .32556 .13673 .30836 Metetra
.634 .727 .915 r
.13673 .30836 .15404 .32556 .17804 .31882 .1609 .30097 Metetra
.632 .72 .911 r
.1609 .30097 .17804 .31882 .20228 .31216 .18532 .29359 Metetra
.631 .713 .906 r
.18532 .29359 .20228 .31216 .22678 .30557 .20999 .28621 Metetra
.63 .705 .9 r
.20999 .28621 .22678 .30557 .25155 .29903 .23493 .27881 Metetra
.629 .696 .894 r
.23493 .27881 .25155 .29903 .27659 .2925 .26013 .27139 Metetra
.628 .688 .887 r
.26013 .27139 .27659 .2925 .30191 .28596 .28562 .26392 Metetra
.627 .679 .88 r
.28562 .26392 .30191 .28596 .32753 .27937 .31139 .25637 Metetra
.626 .671 .873 r
.31139 .25637 .32753 .27937 .35345 .27268 .33745 .24874 Metetra
.626 .663 .866 r
.33745 .24874 .35345 .27268 .37967 .26585 .36381 .24099 Metetra
.626 .656 .86 r
.36381 .24099 .37967 .26585 .40621 .25884 .39047 .23309 Metetra
.626 .65 .854 r
.39047 .23309 .40621 .25884 .43306 .25159 .41743 .22502 Metetra
.627 .645 .848 r
.41743 .22502 .43306 .25159 .46024 .24405 .44471 .21676 Metetra
.628 .641 .844 r
.44471 .21676 .46024 .24405 .48773 .23617 .4723 .20827 Metetra
.629 .638 .84 r
.4723 .20827 .48773 .23617 .51554 .22791 .50021 .19952 Metetra
.631 .637 .838 r
.50021 .19952 .51554 .22791 .54368 .21923 .52843 .1905 Metetra
.633 .637 .836 r
.52843 .1905 .54368 .21923 .57212 .21008 .55697 .18118 Metetra
.636 .638 .836 r
.55697 .18118 .57212 .21008 .60087 .20045 .58583 .17153 Metetra
.638 .641 .837 r
.58583 .17153 .60087 .20045 .62992 .19031 .615 .16155 Metetra
.642 .646 .839 r
.615 .16155 .62992 .19031 .65926 .17965 .64448 .15121 Metetra
.646 .652 .842 r
.64448 .15121 .65926 .17965 .68889 .16846 .67427 .1405 Metetra
.65 .66 .847 r
.67427 .1405 .68889 .16846 .7188 .15675 .70437 .12942 Metetra
.654 .67 .853 r
.70437 .12942 .7188 .15675 .74897 .14454 .73477 .11796 Metetra
.643 .735 .915 r
.07122 .30643 .08911 .32321 .1128 .31577 .09507 .29852 Metetra
.642 .73 .913 r
.09507 .29852 .1128 .31577 .13673 .30836 .11916 .29058 Metetra
.641 .725 .91 r
.11916 .29058 .13673 .30836 .1609 .30097 .14349 .28262 Metetra
.64 .72 .906 r
.14349 .28262 .1609 .30097 .18532 .29359 .16807 .27462 Metetra
.639 .714 .902 r
.16807 .27462 .18532 .29359 .20999 .28621 .19291 .26659 Metetra
.638 .708 .898 r
.19291 .26659 .20999 .28621 .23493 .27881 .21801 .2585 Metetra
.637 .702 .893 r
.21801 .2585 .23493 .27881 .26013 .27139 .24338 .25036 Metetra
.636 .696 .888 r
.24338 .25036 .26013 .27139 .28562 .26392 .26903 .24214 Metetra
.636 .689 .883 r
.26903 .24214 .28562 .26392 .31139 .25637 .29495 .23385 Metetra
.635 .683 .878 r
.29495 .23385 .31139 .25637 .33745 .24874 .32115 .22546 Metetra
.635 .677 .873 r
.32115 .22546 .33745 .24874 .36381 .24099 .34765 .21696 Metetra
.635 .671 .868 r
.34765 .21696 .36381 .24099 .39047 .23309 .37444 .20834 Metetra
.634 .666 .863 r
.37444 .20834 .39047 .23309 .41743 .22502 .40154 .19958 Metetra
.635 .662 .859 r
.40154 .19958 .41743 .22502 .44471 .21676 .42893 .19067 Metetra
.635 .658 .855 r
.42893 .19067 .44471 .21676 .4723 .20827 .45664 .18159 Metetra
.635 .655 .852 r
.45664 .18159 .4723 .20827 .50021 .19952 .48466 .17232 Metetra
.636 .652 .849 r
.48466 .17232 .50021 .19952 .52843 .1905 .51299 .16286 Metetra
.637 .651 .847 r
.51299 .16286 .52843 .1905 .55697 .18118 .54164 .15319 Metetra
.638 .65 .846 r
.54164 .15319 .55697 .18118 .58583 .17153 .57061 .14329 Metetra
.639 .65 .845 r
.57061 .14329 .58583 .17153 .615 .16155 .5999 .13315 Metetra
.641 .652 .845 r
.5999 .13315 .615 .16155 .64448 .15121 .62951 .12275 Metetra
.643 .654 .846 r
.62951 .12275 .64448 .15121 .67427 .1405 .65944 .1121 Metetra
.645 .658 .848 r
.65944 .1121 .67427 .1405 .70437 .12942 .6897 .10118 Metetra
.648 .662 .85 r
.6897 .10118 .70437 .12942 .73477 .11796 .72028 .08998 Metetra
.648 .732 .911 r
.05306 .28905 .07122 .30643 .09507 .29852 .07707 .2807 Metetra
.647 .728 .908 r
.07707 .2807 .09507 .29852 .11916 .29058 .10131 .2723 Metetra
.646 .724 .906 r
.10131 .2723 .11916 .29058 .14349 .28262 .1258 .26384 Metetra
.645 .72 .903 r
.1258 .26384 .14349 .28262 .16807 .27462 .15054 .25533 Metetra
.645 .716 .9 r
.15054 .25533 .16807 .27462 .19291 .26659 .17554 .24675 Metetra
.644 .711 .896 r
.17554 .24675 .19291 .26659 .21801 .2585 .2008 .2381 Metetra
.644 .707 .893 r
.2008 .2381 .21801 .2585 .24338 .25036 .22633 .22937 Metetra
.643 .702 .889 r
.22633 .22937 .24338 .25036 .26903 .24214 .25212 .22056 Metetra
.642 .697 .886 r
.25212 .22056 .26903 .24214 .29495 .23385 .2782 .21166 Metetra
.642 .693 .882 r
.2782 .21166 .29495 .23385 .32115 .22546 .30455 .20266 Metetra
.642 .688 .878 r
.30455 .20266 .32115 .22546 .34765 .21696 .33119 .19355 Metetra
.641 .684 .875 r
.33119 .19355 .34765 .21696 .37444 .20834 .35812 .18434 Metetra
.641 .68 .871 r
.35812 .18434 .37444 .20834 .40154 .19958 .38535 .175 Metetra
.641 .676 .868 r
.38535 .175 .40154 .19958 .42893 .19067 .41288 .16553 Metetra
.641 .673 .865 r
.41288 .16553 .42893 .19067 .45664 .18159 .44072 .15592 Metetra
.641 .67 .862 r
.44072 .15592 .45664 .18159 .48466 .17232 .46886 .14616 Metetra
.641 .667 .86 r
.46886 .14616 .48466 .17232 .51299 .16286 .49732 .13624 Metetra
.641 .665 .857 r
.49732 .13624 .51299 .16286 .54164 .15319 .52609 .12616 Metetra
.642 .664 .856 r
.52609 .12616 .54164 .15319 .57061 .14329 .55519 .1159 Metetra
.642 .663 .854 r
.55519 .1159 .57061 .14329 .5999 .13315 .58461 .10546 Metetra
.643 .662 .854 r
.58461 .10546 .5999 .13315 .62951 .12275 .61435 .09482 Metetra
.644 .663 .853 r
.61435 .09482 .62951 .12275 .65944 .1121 .64443 .08399 Metetra
.645 .664 .853 r
.64443 .08399 .65944 .1121 .6897 .10118 .67484 .07295 Metetra
.646 .665 .854 r
.67484 .07295 .6897 .10118 .72028 .08998 .70558 .06169 Metetra
.651 .73 .907 r
.03462 .27114 .05306 .28905 .07707 .2807 .05878 .26241 Metetra
.651 .727 .905 r
.05878 .26241 .07707 .2807 .10131 .2723 .08317 .2536 Metetra
.65 .724 .903 r
.08317 .2536 .10131 .2723 .1258 .26384 .10781 .24472 Metetra
.65 .721 .901 r
.10781 .24472 .1258 .26384 .15054 .25533 .13271 .23576 Metetra
.649 .718 .899 r
.13271 .23576 .15054 .25533 .17554 .24675 .15786 .22672 Metetra
.649 .715 .896 r
.15786 .22672 .17554 .24675 .2008 .2381 .18327 .2176 Metetra
.648 .711 .894 r
.18327 .2176 .2008 .2381 .22633 .22937 .20895 .20839 Metetra
.648 .708 .891 r
.20895 .20839 .22633 .22937 .25212 .22056 .2349 .19909 Metetra
.647 .704 .888 r
.2349 .19909 .25212 .22056 .2782 .21166 .26112 .1897 Metetra
.647 .701 .886 r
.26112 .1897 .2782 .21166 .30455 .20266 .28763 .1802 Metetra
.647 .698 .883 r
.28763 .1802 .30455 .20266 .33119 .19355 .31442 .1706 Metetra
.646 .694 .88 r
.31442 .1706 .33119 .19355 .35812 .18434 .3415 .16088 Metetra
.646 .691 .878 r
.3415 .16088 .35812 .18434 .38535 .175 .36887 .15105 Metetra
.646 .688 .875 r
.36887 .15105 .38535 .175 .41288 .16553 .39654 .1411 Metetra
.646 .685 .873 r
.39654 .1411 .41288 .16553 .44072 .15592 .42452 .13102 Metetra
.646 .683 .871 r
.42452 .13102 .44072 .15592 .46886 .14616 .4528 .12081 Metetra
.646 .68 .869 r
.4528 .12081 .46886 .14616 .49732 .13624 .4814 .11046 Metetra
.646 .678 .867 r
.4814 .11046 .49732 .13624 .52609 .12616 .51031 .09996 Metetra
.646 .677 .865 r
.51031 .09996 .52609 .12616 .55519 .1159 .53954 .08932 Metetra
.646 .675 .864 r
.53954 .08932 .55519 .1159 .58461 .10546 .56911 .07852 Metetra
.646 .674 .863 r
.56911 .07852 .58461 .10546 .61435 .09482 .599 .06756 Metetra
.646 .674 .862 r
.599 .06756 .61435 .09482 .64443 .08399 .62922 .05644 Metetra
.647 .673 .861 r
.62922 .05644 .64443 .08399 .67484 .07295 .65979 .04514 Metetra
.647 .674 .861 r
.65979 .04514 .67484 .07295 .70558 .06169 .69069 .03367 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{306, 233.5},
  ImageMargins->{{0, 0}, {0, 6.3125}},
  ImageRegion->{{0.07, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004b0000jA000`40O003h00Oogoo<goo003oOolc
Ool00?mooc=oo`00ogoo<goo003oOolcOol00?mooc=oo`00ogoo<goo003oOolcOol00?mooc=oo`00
ogoo<goo003YOol40015Ool00>Uoo`03001oogoo04Ioo`00jWoo00<007ooOol0AGoo003SOol40004
Ool00`00Oomoo`14Ool00<Aoo`<0029oo`04001oogoo0015Ool00<Eoo`03001oogoo029oo`8004Io
o`00`Woo1@005Woo0`00DWoo0032Ool01000Oomoo`005Woo0P0000=oo`000000DGoo0033Ool00`00
Ool0000COol30003Ool2001AOol00<Aoo`80011oo`<000Ioo`03001oo`00051oo`00dgoo0`002Goo
00@007ooOol004moo`00dGoo10002Woo00@007ooOol004moo`00cgoo0P003Woo00D007ooOomoo`00
04ioo`00c7oo0`0047oo00H007ooOol007oo001=Ool00<Yoo`80019oo`<000=oo`03001oogoo04]o
o`00agoo0`004Woo0P0000=BVU:k000017oo00<007ooOol0BWoo001bOol2001@Ool30002Ool00`00
Oomoo`0>Ool200001E:kCYYB^djJ00001Goo00<007ooOol0BGoo001bOol2001>Ool2000COol30000
1TjJD[]BVU:kCYYB^`8000Aoo`03001oogoo04Uoo`00LGoo00@007ooOol004Yoo`<001=oo`800009
CYX004jJD[]>VU:kCYYB^djJ008000Eoo`03001oogoo04Qoo`00L7oo0P000Woo0P00AWoo0`004goo
0`0000iB^e:JD[]>VP00DYYB^djJD[]BVU:k001B^`0017oo0P00BGoo002jOol4000AOol300004E:k
CYYB^djJD[]>VU:k001B^djJD[]>VU:kCYX004jJ00001Goo00<007ooOol0Agoo002EOol4000NOol3
000COol200004e:kDYX004jJD[]BVU:kCYYB^e:JD[/005:kDYYB^djJD[/005:k008000Eoo`03001o
ogoo04Ioo`00UGoo00<007ooOol07Goo0P004goo0`0001=>VU:kCYYB^`00D[]>VU:kCYYB^djJD[]>
VP00CYYB^djJD[]>VP0200000e:kCYX00004Ool00`00Oomoo`16Ool009Ioo`03001oogoo01Qoo`@0
019oo`<0000CDYYB^djJD[]BVU:kCYYB^`00D[]>VU:kDYYB^djJD[]BVP00CYX010000e:J00<007oo
Ool00goo00<007ooOol0AGoo002GOol00`00Oomoo`0FOol3000BOol200004djJD[/005:kCYYB^djJ
D[]>VU:kCYX004jJD[]>VU:kCYYB^djJ00<00009CYYB^djJ001>VU:kCYYB^`0000Eoo`03001oogoo
04Aoo`00UGoo00@007ooOol001Aoo`<0019oo`<0000CD[]>VU:kDYX004jJD[]BVU:kCYYB^e:JD[]>
VP00DYYB^djJD[/00P0000U>VU:J001BVTjJDYX005:JCYX00U:J00<007ooOol00goo0P00AGoo002F
Ool2000COol2000BOol3000055:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB^djJD[/005:kCYX2
00003e:kCYYBVdjJ001>VU:kCYX004jJD[]>VU:kCYX00004Ool20015Ool00:Qoo`<0019oo`80000D
D[]>VP00DYYB^djJD[]BVU:kCYYB^`00D[]>VU:kDYYB^djJD[]BVP<0009BVP06CYYBVU:JDYY>VP00
0U:J00L005:JDYYBVTjJDYX00006Ool00`00Oomoo`12Ool00:Eoo`<001=oo`80000DCYYB^djJD[/0
05:kCYYB^djJD[]>VU:kCYYB^`00D[]>VU:kCYYB^`80000ECYX004jJD[]>VU:KCYYB^djJDY/005:k
CYX004jJD[]>VU:kCYYB^`0000Eoo`03001oogoo049oo`00Xgoo0P000Woo00<007ooOol03Woo0`00
01=B^e:KD[]>VU:kDY]B^`00D[]BVU:kCYYB^e:JD[]>VP00DYYB^`0300001U:JCYYBVTjJ001>VP=B
VP09CYYBVU:JDYX005:J001BVTjJ00=BVP8000Ioo`03001oogoo045oo`00X7oo0`004Goo100001=B
^djJ001>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^`0300005U:KCYYB^djJDY]>VU:k001B
VdjJD[]>VU:KCYYB^djJ001>VU:k001B^djJ0P0000=BVTjJ00001Woo00<007ooOol0@7oo002NOol2
000@Ool400005DjJD[]B^e:kCYYB^`00D[]>VU:kDY]B^djJD[]BV`00CYYB^e:JD[]>VP0200003U:J
CYX004jJDYY>VU:JCYYBVTjJDYX005:JCYX3DYX01DjJDYYBVP00CYX00`0000E>VU:JDYYBVP0000Io
o`03001oogoo041oo`00Vgoo0`0047oo0P0001IB^djJ001>VU:kCYYB^djJD[]>VU:k001B^djJD[]>
VU:kCYYB^`00D[]>VP<0000ECYYB^djJDY/005:kCYYBVdjJD[]>VU:KCYX004jJDY]>VU:kCYYBVdjJ
00@00008D[]>VU:JCYYB^djJDYX000Eoo`80045oo`00V7oo0`0000=oo`00Ool03Woo0P0000E>VU:k
D[]B^`0000=B^`0=CYYB^e:kD[]>VU:k001B^djJD[]BVe:kCYX00`00019>VU:JCYYBVTjJDYY>VU:J
001BVTjJDYY>VU:JCYYBVTjJ0002DYX400001DjJDYX00000CYX00e:J00A>VU:JDYX000Moo`03001o
ogoo00Yoo`D002moo`00UWoo0P004Goo0`0001=B^djJD[]>VU:kCYYB^`00D[]>VU:kCYYB^djJD[]>
VP00CYYB^`0400004djJD[/005:KCYYB^djJDY]>VU:kCYX004jJD[]>VU:KCYYB^djJ00@00006DYY>
VU:KCYYBVTjJ0P0000UBVTjJD[]>VU:JCYYB^djJ00001Woo00<007ooOol037oo00<007ooOol0;goo
002COol3000AOol20002D[/00`00CYYB^`02D[/01DjJD[]B^`00CYX00e:k00A>VU:kD[]B^`<0000E
DYY>VU:JCYYBVTjJ001>VU:JCYYBVTjJDYY>VU:JCYX004jJDYY>VU:J00800003CYYBVP0000=BVP06
CYYBVU:JDYY>VP000U:J00M>VU:JDYYBVTjJDYX00007Ool00`00Oomoo`0;Ool00`00Oomoo`0_Ool0
091oo`<0015oo`<0000CCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYX00P0001IB
VdjJ001>VU:KCYYB^djJDY]>VP00CYYBVdjJD[]>VU:KCYYB^`00DY]>VP80000FDYY>NU:JCYX004jJ
DY]>VU:JCYYBVdjJDYX005:kCYYBVTjJD[]>VU:JCYX20007Ool00`00Oomoo`02Ool40004Ool00`00
Oomoo`0_Ool008ioo`@000moo`<0009B^`09C[]B^e:kD[]>^e:k001B^djJ00=B^`05CYYB^`00D[]>
VP0300005DjJDYY>VU:K001BVTjJDYY>VU:JCYYBVP00DYY>VU:JCYYBVTjJDYY>VP0300002DjJDYY>
VU:JCYYBVTjJ001>VP03DYX00djJDYYBVP020003DYX01TjJDYX00000DYX000Moo`03001oogoo00Yo
o`03001oogoo02moo`00Jgoo0P007goo0P003goo100001=>VU:k001B^djJD[]>VU:kCYYB^djJ001>
VU:kCYYB^djJD[]>VP0300005TjJD[]>VU:KCYYB^djJDY/005:kCYYBVdjJD[]>VU:K001B^djJDY]>
VU:k0P00019>NU:J001BVTijDYY>VU:JCWYBVP00DYY>VU:KCYYBVTjJDY/200000djJD[/000020000
1E:kDYYB^djJ00001Woo0P002Woo0P00<Goo001ZOol01000Oomoo`006goo0`003Woo0`000e:k00E>
^e:kD[/004jk00=B^`06C[]B^e:kD[]>^`000U:k01Y>VU:k000004jJDYX005:KCYYBVTjJDY]>VU:J
CYX004jJDYY>VU:JCYYBVTjJ001>VU:J0`00011BVTjJDYY>VP00CYYBVTjJDYY>VU:JCYYBVP00DYY>
VP=BVP03CYX000000080009BVP06D[YBVU:JDYYB^P0027oo00<007ooOol0>Woo001ZOol01000Oomo
o`0067oo0`003goo0P0001IB^djk001>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^`00D[]>
VP80000ED[]>VU:kCYX004jJDY]>VU:kCYYBVdjJD[]>VP00CYYB^djJDY]>VU:k00<0000FDYY>NU:J
CWYBVTijDYY>NP00CYYBVTijDYY>VU:JCWX004jJDYY>VU:KCYX2000035:JCYX004jJD[]BVU:kCYYB
^e:JD[/000Moo`03001oogoo03Yoo`00JWoo00@007ooOol001Ioo`800003Ool007oo00eoo`80009B
^`05C[]B^`00D[]>^`03D[/01DjkD[]B^`00C[/00e:k00=>^e:kD[/00`0001=>VU:KCYYBVTjJDY]>
VP00CYYBVdjJDYY>VU:KCYYBVP00DYY>VP040002CYX05000CYYBVTjJDYY>VU:JCYYBVP00DYY>VU:J
CYYBVTjJDYY>VP00DYX300001U:J001BVU:J001B^P=BVP05D[YBVU:JDYX00008Ool00`00Oomoo`0i
Ool006Yoo`04001oogoo000COol3000?Ool300004e:kCYYB^djkD[]>VU:k001B^djJD[]>VU:kCYYB
^`00D[]>VU:k00@0000CCYYB^`00D[]>VU:kCYYB^djJD[/005:kCYYBVdjJD[]>VU:KCYX00`0001M>
NU:JCWYBVTijDYX005:JCWYBVTijDYY>NU:JCWYBVP00DYY>VU:JCWYBVTjJ00<0000BCYYBVTjJDYX0
05:JCYYBVP00D[]>VU:kDYYB^djJD[]BVP0027oo00<007ooOol0>7oo001[Ool2000BOol2000>Ool4
00000e:kC[/00002D[/01TjkD[]B^e:kC[/0009B^`05C[]B^e:kD[]>^`0400005E:KCYYBVdjJDY]>
VP00CYYBVTjJDY]>VU:JCYYBV`00DYY>VU:KCYYBVP02000014jJ001>VU:J0djJ00mBVTjJCYX005:J
CYYBVTjJDYY>VU:JCYX004jJDYX010000U:J00<005:JDYX00U:J00L005:JDYYBVP00DYYB^P03DYX0
15:jDYX0000027oo00<007ooOol0>7oo001lOol3000=Ool3000054jkD[]>^U:kC[]B^`00D[]>^e:k
CYYB^djkD[]>VP00CYYB^djJD[/200005TjJD[/005:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB
^djJ001>VU:k0`0001EBVTijDYY>NP00CWYBVTijDYY>NU:JCWX004ijDYY>NU:JCWYBVTijDYX00`00
01EBVTijDYY>NE:JCWX004jJDYY>VU:J001BVTjJDYY>VP00DYYB^djJD[/00P0000=B^UKK00001goo
0P00>Goo001iOol4000=Ool20002D[/01@00D[]B^e:kC[/00e:k00D005:kD[]B^djk00=B^`03001B
^e:k0080000EDY]>VU:kCYX004jJDY]>VU:KCYYBVdjJDY]>VP00CYYBVTjJDY]>VU:J00<0009>VP06
DYY>VTjJCYYBVP000TjJ00aBVTjJCYY>VU:JCYX004jJDYY>VU:JCYX2000015:J001BVTjJ0e:J00A>
VU:JDYX000=BVP03001BVU:J009BVP03001BVU:J0080009B^`03E[]B^P0000Uoo`03001oogoo03Io
o`00Mgoo0P003goo0P0001AB^djkD[]>^`00C[YB^djkD[]>^U:kC[]B^`00D[]>^e:kCYYB^djk0`00
01=>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^`00D[]>VP0400005U:JCWX004ijDYY>NU:J
CWYBVTijDYX005:JCWYBVTijDYY>NU:J001BVTij0`0001E>NE:JCWUBVP00DYY>NE:JCWYBVTiiDYX0
05:JCYYBVTjJ001>VU:JCYX00`0000QB^UJkD[YFfe:jE[]B^P0027oo00<007ooOol0=Woo001dOol3
000>Ool300001DjkD[]B^e:kC[/00U:k00<004jkD[/00U:k00I>^e:kD[/004jkD[/400004djKD[/0
05:KCYYB^djJDY]>VU:k001BVdjJDY]>VU:KCYYBVdjJ00<000=>VP05DYY>VTjJ001BVP03CYX01E:J
CYY>VTjJ00000djJ00ABVTjJCYY>VP<00008CYYBVTijDYY>VU:JCWX0009BVP07CYYBVU:JDYY>VU:J
00000e:J00@005:J0000009B^P05001B^e:kE[]B^P02D[/00eJkD[X00008Ool00`00Oomoo`0eOol0
075oo`<000eoo`@0000BC[]Bg000D[]>^e:kC[]B^djkD[/005:kC[YB^djkD[]>^U:k0`0001EB^djJ
D[]>VU:kCYX004jJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[/00P0001Q>NU:K001BVTijDYY>NU:J
CWYBVP00DYY>NU:JCWYBVTijDYX005:JCWYBVTijDYX200005TiiDYX005:JCWUBVTiiDYY>NE:JCWT0
04ijDYY>NE:JCWYBVTii001>VU:J0`0000iB^e:JE[]BVP00D[YFfe:jE[]B^UKKD[YF^`0027oo00<0
07ooOol0=Goo001_Ool4000;Ool300000e:kC[]B^`02D[/01Djk001B^e:kC[/00e:k00E>^e:k001B
^djk009B^`80000ED[]>^`00CYYB^djKD[]>VU:kCY/004jJDY]>VU:kCYYBVdjJ001>VU:K00<000A>
VP03001>VU:J00=>VP05DYY>VP00CYYBVP03CYX01E:JCYY>VP00DYX00`0000iBVTijCYY>NP00CWYB
VTjJDYY>NU:JCYYBVP000e:J00A>VU:JDYYBVP<00003D[X005:j009B^P05DYYB^U:j001B^P02D[/0
15JkD[YB^e:k0P0027oo00<007ooOol0=7oo001/Ool30003Ool00`00Oomoo`07Ool200005E;LC[/0
04jkD[]>^e;LC[]B^djk001>^e:kC[]B^djkD[]>^`00C[]B^`02000054jJD[]>VU:k001B^djJD[]>
VU:kCYYB^djJ001>VU:kCYYB^djJD[/300005e:KCWYBVTijDY]>NU:JCWX004ijDYY>NU:JCWYBVTij
001>NU:JCWYBVTijDYX00`0001IBVTiiDYY>NE:JCWUBVTii001>NE:JCWUBVTiiDYY>N@00CWUBVTij
DYY>N@80000ADYY>VP00DYX005:JE[]BVU:kDYYF^`00E[]B^UKKD[YF^`0200000eKkF_`00007Ool2
000eOol006Yoo`8000ioo`800005C[]B^e:kD[/00003D[/01TjkD[]B^e:kC[/0009B^`04C[]B^e:k
D[/300004U:kCY]B^djkD[]>Ve:k001B^djJD[]>Ve:kCYYB^`00D[]>VP@0009>VP03001>VTjJ00I>
VP04001>VTjJDYX3CYX015:J001>VTjJ100001I>VTij001>NU:JCWY>VTijDYY>NTjJ001BVTijDYY>
VU:JCWYBVTjJ001>VP<000ABVP05001B^P00D[YBVP03D[X015:JD[X005Jk0`0000EFo5KkE_aFn`00
00Qoo`03001oogoo03=oo`00Igoo0`003Goo0`00019Bg4jkD]a>^e;LC[]Bg000D]a>^e:kC[]Bg4jk
D[/005:kC[/400004U:kCYX004jJD[]>VU:kCYYB^djJ001>VU:kCYYB^djJD[]>VP<0000GCWYBVdjJ
DY]>NU:K001BVTijDY]>NU:JCWYBVdijDYX005:JCWYBVTijDYY>NP0300005diiDYY>NE:JCWUBVP00
DYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYY>NE:JCWT00`0000I>VU:jDYYBVTjJD[X2DYX200001e:J
D[]BVUJkDYYB^e:J00800009F_aFfe[lE_]Jo5KKF_aFn`0000Qoo`03001oogoo039oo`00IGoo0P00
00=oo`00Ool02Goo10000U:k00<004jkD[/00U:k00E>^e:kD[]B^`0000=B^`03C[]B^e:k00<0000D
C[]B^djkD[]>^e:k001B^djkD[]>Ve:kC[]B^djK001>Ve:kCYYB^`80009>VP03001>VTjJ00E>VP03
001>VTjJ00I>VP05001>VTjJCYYBVP0200000dijCYX00002CWX04djJCWY>NTijCYX004jJCWYBVTij
CYY>NU:JCWX004jJDYY>NU:J00800003CYYBVP0000QBVP8000=B^P0?DYYB^P00001Ff`00E_]Fo5Kk
E_aFneKlE_]Fo00000Uoo`03001oogoo035oo`00@goo10006goo0`002goo0`00019>^e;LC[]Bg4jk
D]`005;LC[]Bg4jkD]a>^e;LC[/004jkD]`400005DjkD[/005:kCYYB^djJD[]>VU:k001B^djJD[]>
VU:kCYYB^`00D[]>VP02000065:KCYYBVdjJ001>VU:KCWYBVdjJDY]>NP00CWYBVTijDY]>NU:JCWYB
Vdij001>NP80000HDYY>NE:JCWT004iiDYY>NE:JCWUBVTii001>NE:JCWUBVTiiDYY>NE:JCWT004ii
0P0000EBVTiiDYY>N@00009BVP0;CYYB^U:JDYY>VU:jDYX005:JE[]BVP020003E]/02`00F_aFne[l
E]]Jo5KkF_aFfe[l000027oo00<007ooOol0<Goo0013Ool00`00Oomoo`0JOol2000<Ool200001Djk
D]/005;KC[/00U:k00IBfdjkD[/005:kC[/3D[/00djkD[/0000200005U:kC[]B^djkD[]>^`00C[]B
^djkD[]>^e:kC[]B^`00D[]>^e:kCY]B^djk0`001djJ00<004jJCYX01DjJ00<004jJCYX01DjJ0`00
0dij00E>VTijCWY>NP0000=>NP0<CYY>NTijCWX004ijCYY>NU:JCWY>VTij0`000U:J00I>VU:JDYYB
VTjJ0008DYX01000D[X000001UKK00L005KlE_]Fo5KkE_aFn`0200000e]M001oo`07Ool00`00Oomo
o`0`Ool004Aoo`03001oogoo01Ioo`<000aoo`80000BD]a>^e;LC[/004jkD]a>^e;LC[]Bg4jkD]`0
05;LC[]Bg4jk0P0001EB^djk001>VU:kC[]B^djJD[]>^`00CYYB^djJD[]>VU:kCYX004jJD[/01000
01I>VU:K001BVdjJDY]>VU:KCYYBV`00DY]>VU:KCWYBVdjJDY/005:KCWYBVP@0000FCWUBVP00DYY>
NE:JCWUBVTiiDYX005:JCWUBVTiiDYY>NE:J001BVTiiDYX4000034iiDYX005:JCWUBVTiiDYY>NE:J
001B^P9BVP05CYYB^U:JDYY>VP0200000eKKD]]Ff`02E]/025;KE]]FfeKK001Jo5KkF_`2000015/l
GeeK?5mM0P001Woo0P007Goo0`004Goo000mOol40004Ool00`00Oomoo`0BOol300000goo001oo`09
Ool300002e:kD]a>^e;KD[]Bg4jk001B^e;KC[/00U:k00=Bfdjk00000U:k0P0001A>^e:kC[]B^`00
D[]>^e:kC[]B^djkD[]>^`00C[]B^djkD[]>^e:k0`000TjJ00E>VdjJCYY>VP0000Q>VP03001>VTjJ
00A>VP@00009CYY>NTijCWY>VTij001>NTjJ00=>NP05CYY>NTij001>VP03CWX00djJCWX000030000
259jCWUBVTiiDWY>N@00CYX3DYX01DjJDYYBVU:J00001E:J0`0000=F^`00E]/01eKK00H005Kk0000
05mMFc`2Fed01EmMFcaKGE]M00001Woo00<007ooOol06goo00<007ooOol04Goo0013Ool01000Oomo
o`004Goo0P002goo1000019>^e;L001Bg4jkD]a>^e;LC[]Bg4jk001>^e;LC[]Bg4jkD]`300004U:k
C[]B^djkD[]>^e:k001B^djJD[]>^e:kCYYB^`00D[]>VP@0000ED[]>VP00CYYB^djJDY]>VU:kCYX0
04jJDY]>VU:KCYYBVdjJ001>NU:K00@0000HCWY>VP00DYY>NDjJCWUBVTiiCYY>N@00CWUBVTiiDYY>
NE:JCWT004iiDYY>NE:J0P0001I>NE:J001BVTiiDYY>NE:JCWUBVTii001>NE:JCWUBVTiiDYY>N@00
CYYB^P<00005E]]B^P00D[X00002E]/01U;KE]]FfeKKD]]Ff`800008FcaOGE/lGeeK?5mMFcaOG@80
0003Gid0000000Eoo`03001oogoo01Yoo`03001oogoo015oo`00A7oo0P003goo0`002goo0P00011B
g5;KD]a>^e;LD]]Bg000D]]B^e;LC[]Bfe:kD]`0009B^`@0000BD[]>^`00C[]B^djkD[]>^e:kC[]B
^`00D[]>^e:kC[]B^djk0`0000Q>VTjKCYY>VdjJCY/004jK0djJ00E>VdjJCYY>VP0000I>VP<0009>
NP05CYY>NTijCWX00003CWX01TjJCWY>NTijCYX0009>NP08CYY>NTijCWY>VTij001>NP80000@CWY>
NDijCWT004iiDYY>NE9jCWUBVTiiDWX005:JCYX3DYX00djJDYX0000200002EJkD[YF^e:jE[/005Jk
D[X00005E]/20002Fa`01P00FcaKGE]MGeeK?0800005GkeOWEnMGieO_@020004Ool00`00Oomoo`0J
Ool00`00Oomoo`0@Ool005=oo`8000aoo`80000AC[/004jkD]a>^e;LC[]Bg4jk001>^e;LC[]Bg4jk
D]a>^`0300004TjkD[]>^e;LC[]B^`00D[]>^e:kC[]B^djkD[]>^`00C[]B^`@0000ECYYB^`00D[]>
VU:kCYYB^djJD[/005:KCYYB^djJDY]>VU:k001BVdjJ00@0000JCYY>NP00CWUBVTijCYY>NE:JCWX0
04iiDYY>NDjJCWUBVTiiCYX005:JCWUBVTiiDYY>N@<0000ECWUBNTiiDYY>NE9jCWT004iiDYY>NE:J
CWUBVTiiDYX005:JCWUBVTii0080000<E[YBVP00D[YFfe:jE[]B^P00D[YF^`000UKK0`0000QK75/l
FaaK?5/L001K?5mM0P0000EOWF>nGieO_EnM00800004GmeO_0000002Ool00`00Oomoo`0HOol4000A
Ool0051oo`<00003Ool007oo00Uoo`80000?D]a>fe;LD]/004jkD]aBfe;LC[]Bg5;K001>^e;K00@0
000BC[]B^`00D[]>^e:kC[]B^djkD[/005:kC[]B^djkD[]>^e:k0`00015>^djKCY]>VdjkCY/004jJ
CY]>VTjKCYY>VdjJCY/004jK00=>VP03CY]>VP0000800008CWY>VTijCYY>NTjJ001>VP=>NP05CYY>
NTij001>VP03CWX01DjJCWY>NTij00000Tij100001A>NDij001>NTiiCWY>NDijCWU>NP00DWY>NE:J
CWUBNTiiDYY>N@000U:J0P0000iBVU:jDYYBVP00E[]B^UJkD[YF^`00E[]B^UJk0P0000=K75/lFa`0
0U/L00AK?5/LFaaK7080009OW@05GkeOWEnMGid00003Gmd200001EoM001oogoo0000;Woo001=Ool3
000<Ool300003djkD]a>^e;LC[]Bg4jk001>^e;LC[]Bg4jkD]a>^`02000055;LC[]Bg4jkD]a>^e;L
001Bg4jkD[]>^e;LC[]B^`00D[]>^e:kC[/200005E:kCYX004jJD[]>VU:kCYYB^djJ001>VU:kCYYB
^djJD[]>VP00CYYBV`0400006TijCY/004jJCWY>VTijCYY>NTjJ001>VTiiDYY>NTjJCWUBVP00CYY>
NE:JCWU>VTiiDYX300005e9jCWU>NTiiDWY>N@00CWUBVTiiDWY>NE:JCWUBNP00DYY>NE:JCWUBVTii
DYX00`0000eB^U:JE[YBVU:jDYYF^P00E[]B^UKKD[YF^`0300002E[l001K?5/LFcaK75/lFaaK?002
00001Umm001OWF>nGieO_@800008GkaOgEnl001O_EoMGkaSg@800003Ool007oo00Ioo`8002Aoo`00
Bgoo0P002goo1000011Bfe;L001Bg4kKD]aBfe;LC]]Bg000D]a>^e;LD]]Bg080000DC[/004jkD[]>
^e:kC[]B^djkD[/005:kC[]B^djkD[]>^`00C[]B^`800005CY]>^djkC[/00002CY/03DjkCY]>VdjK
C[/004jKCYY>VdjJCY]>VTjK00<00003CYY>NTjJ009>VP0<CWX004ijCYY>NTjJCWY>VTij001>NTjJ
0dij00I>VTij001>NTjJCWX400000dii001>NP03CWT04TijCWU>NDii001>NDijCWU>NTiiCWY>N@00
CWUBNTiiDYY>N@800005DYX005:JDYYB^P03DYX01e:jDYYBVP00E[]B^UJk00800005E_]Jne[kF_`0
0002Fa`01E/lFaaK7000Gid00emm00@005nM000000=Og@800003GkeOgEoM00800004Gid007oo0006
Ool01000Oomoo`008goo0018Ool3000:Ool300004U;LC[]Bg4kKD]a>^e;L001Bg4jkD]a>^e;LC[]B
g000D]a>^`80000CD]a>^e;LC[/004jkD]a>^e;LC[]Bg4jk001>^e;LC[]B^djkD]`00`0001AB^djK
D[]>VU:kCY]B^`00D[]>VU:kCYYB^djJD[/005:kCYYB^djJ0P0001U>Vdij001>NTjJCWY>VdijCYY>
NP00CWY>VTijCYY>NTjJCWX004ijCYY>NE:JCWY>VP0400006DiICWY>NDijCUU>NP00CWY>NE9jCWU>
NTiiDWX0059jCWUBVTiiDWY>NE:JCWT004ii00<0000?CWUBVU9iDYX005JjDYYB^U:JE[YBVU:jDYX0
05:j0080000BFa`005[lE_]K75Kk001K75/lFaaK?000HieOOF>MGgaSWEmm0P00011SgEnl000006?M
GkeOgEnl001OWEnnGieO_P00Ool000Eoo`04001oogoo000SOol004Ioo`8000=oo`03001oogoo00Ao
o`<0009Bg004001Bg5;LD]/3D]`02E;K001Bfe;LC]]Bg5;KD]a>f`0300004TjkD[]>^e;LC[]B^djk
001>^e:kC[]B^djkD[]>^`00C[]B^`<0009>^`03001>Vdjk009>^`04CY]>^djk0003CY/01djkCY]>
VdjK001>VTjK008000A>VP05001>VTjJCYY>NP03CYX02@00CYY>NTjJCWY>VTijCYX00002CWX40000
1DijCWT004iiCWX00dii00E>NTii001>NDij00=>N@0:CWY>NDii001>NTiiCWY>NDijCWT30007DYX0
1@00DYYBVU:JD[X00e:J00YB^U:J001Jne[lE_/005[kF_aFn`9Jn`05001K7000001OW@03Ggd01EnM
000006>mHmd00P000UoM00AO_EoMGmd000IOW@03001oo`0000Aoo`04001oogoo000SOol004=oo`<0
00Uoo`<0000AD]a>^e;LC]]Bg4jk001>fe;LC[]Bg4kKD]a>^`00C[]Bg00400004TjkD]`005;LC[]B
g4jkD]a>^e;L001Bg4jkD]a>^e;LC[]Bg0<0000ED[]>Ve:kCY]B^`00D[]>VU:kCY]B^djJD[]>V`00
CYYB^djJD[]>VU:k00<0000FCY]>NTjKCWY>VdijCY/004jKCWY>VTijCY]>NTjJ001>VTijCYY>NTjJ
CWX300006TiiCWY:FDijCWU>NP00CWY>NDijCUU>NTiiCWY>F@00CWU>NTiiDWY>NDijCWT004iiDWX4
00004TiiDYX005:JCWUBVU9iDYY>NE:JDWT005:JE[YBVU:jDYYF^P80000FE]X005KkF_`005/LE_]J
o5KkFaaFn`00GgaSWEmmHieOO6>M001SgEnlHmd2000015oL000005oM0P0000EOWEnnGieO_UnM0080
0003Ggd0000000Aoo`04001oogoo000SOol0045oo`8000Yoo`80009Bg003001Bg5;L00EBg004001B
g5;LD]/3D]`300004U;LC[]Bg4jkD]a>^e;L001Bg4jkD[]>^e;LC[]B^`00D[]>^`@0009>^`03001>
^djk00A>^`03001>^djK00=>^`05CY]>^`00C[]>V`0400000djKCYX00007CYX00`00CWY>VP02CYX0
1TijCYY>VP00CWY>VP@00003CWU>NP00009>N@06CWY>NDiiCWU>NP000Tii00I>NTiiCWU>NDij0002
CWT01DijCWU>NDiiCWX00`0000MBNTiiDWU>NE9jCWT00008DYX00`00D[YBVP02DYX20003E]/01@00
F_]Jn`00E_/00U[k00EJo000001OG00000=OO@06Gid006?MHkeSg@000V?L00ASgEoLHm`000EOW@80
00AKG@8000Aoo`8002Aoo`00?Woo10002Goo0P00011>fe;LC]]Bg4kK001>fe;LC[]Bg4kKD]a>^`00
C]]Bg0<0000BD]a>^`00C[]Bg4jkD]a>^e;LC[/004jkD]a>^e;LC[]Bg4jk0`0001E>^e:lC[]B_4jk
D[`005:kCY]B^djKD[]>Ve:k001B^djJD[]>Ve:kCYX00`0001I>NTjKCYY>VdijCY/004jKCWY>Vdij
CY]>NTjKCWX004ijCY]>NTjJCWY>V`<0000LCWY:NDijBUU>NTYi001:FDijCWU>NTYICWY>N@00CUU>
NTiiCWY>FDijCWT004iiDWY>NDijCWT200005E9jCUT004iiDYY>NE:JCWUBVTii001BNE:JCWUBVU9i
DYY>NE:J001B^P0200002eKJE]]FfU[KE]YFf`00Fa`005[lE_/00P0000IOGEmLGgeOG000Gg`20000
26?MGkaSg@00HmeOg6?mGm`2000016?M000005nM0P000U]M00MOOE]MFeeKG@00Ool0000YOol003]o
o`<000Yoo`<000MBg003001Bg5;L00EBg0<0000AD]a>fe;LC]aBg4kK001>^e;LC[]Bg4jkD]a>^`00
C[]Bg0040002C[/00`00C[]>^`05C[/00`00C[]>^`04C[/00`00C[]>^`0400002djJCY/004jKCYY>
VdjJCY]>VTjK00001djJ00<004jJCWX010000Tij00T004iiCWY>NDijCWU>NTii00000dii00E>NTii
CWU>N@0000=>N@06CWY>NDiiCWT004ii0`0014ii00T0059iCWUBNTiiDWU>NE9j00001e:J0`0025KK
1@0000MOG5mMGeaOGEmLGeeOG002000016?MHkd000000V?L00ISg@00001S_F?MGkd2Hkd00`00FeeK
G@06Fed3000YOol003Uoo`8000Yoo`<0000>D_a>g000C]]Bg4kKD]a>fe;LC]]Bg000D]a>f`@0000A
D]a>^`00C[]Bg4jkD]a>^e;LC[/004jkD]a>^e;LC[]Bg00300005E;LC[]Bg4jkD]a>^`00C[]B_4jk
D[a>^e:lC[]B_000D[]>Ve:kCY]B^`0300005TjKCYY>^djJCY]>VP00CYY>VdijCY]>VTjKCWY>V`00
CY]>NTjKCWY>Vdij0`0001e:NDijBWU>NTYiCWX004ijBUU>NTYiCWY:FDij001>NTYICWY>NDijBUU>
NP00CWY>FDijCWU>NTiI00<0000ECUUBNTiiDWY>FE9jCWUBNP00DYY>NE:JCWUBVTiiDYX005:JDWUB
VTii00800009E[YBVP00E]YFfeKJF]]FfUKK00H00006GeaOGEmLGgeOG5mM0P0000=S_6>m00000P00
00USgEoL000006?MGkaSgEnmHmd00P0000AOO@00FeeOO@=KG@800004FceG7000000XOol003Moo`80
00Uoo`<000IBg08000IBg0<0009Bg00@C]aBg5;LD]a>g000C]aBg4kKD]a>g5;LC]/004jkD]`30000
1E;LC[/004jkC[`00djk00=>_4jk00001djk00<004jkC[/00`0000=>^djK00000TjK00i>VTjKCY]>
VdjJ001>VTjKCYY>VdjJCY]>VP000TjJ100000=:NTij00001dij00X004ijCWU>NTiiCWY>NDij001>
NP=>N@05CWY>NDii001>NP0400000diICWT00008CWT02@00CWUBNDiiDWY>NE9iCWT00002DYX20000
1U:jE[YF^UJjD[X0009Ff`<00004E]/00000Ga`2000025mMGeaOGEmLGed006>mHk`2Hkd00`00HmaS
g00200001EnmHkeS_F?MGkd00P0000EOWEmmGieOW@00009KG@800005EaaG?ELMFceG7002000WOol0
03Moo`8000Ioo`<0000>D_a>g000C]]Bo4kLD]a>fe;lC]aBg000D]a>f`<0000BC]aBg000D]a>fe;L
C[]Bg4kKD]`005;LC[]Bg4jkD]a>^e;L0`0001EBg4jkD]a>^e;LC[/004jkD]a>^e;LC[]Bg4jk001>
^e:lC[]B_4jkD[`00`0001E>^djJC[]>VdjkCYX004jJCY]>VTjkCYY>VdjJ001>VTjKCWY>VdjJCY/0
0`0001e>NTYiCYY:NTijBWT004YiCWY:NDijBWU>NTYi001:NDijBUU>NTYiCWY:F@00CWU>NTYICWY>
NDij00<0000GCWU>FDijCUU>NDiI001>NE9jCUUBNTiiDWY>FE9jCWT004iiDYY>NE:JCWUBVP030000
1eJkD[YF^U:JE[]B^UJj00<00008E]]FfP00001O?5/KGcaK6`800009GgeOG5mM001S_F>lHkeSW000
00=Sg005001Sg000001Sg@0200001UmmHieOOEnMGgeSW@<00007FceG75/mEaaK?ELLFcd00`009Woo
000gOol00`00Ool00002Ool30006D]`00`00D]aBg006D]`20002D]`01DkLD]aBg5;L00000e;L00M>
g5;LD]aBg000D]a>g00400003E;LC[/004jkD]a>^djlC[]Bg4jk001>^djl00=>^`04C[`004jkC[/4
00001DjkCY/004jKC[/00djK00=>^djK00000TjK00M>VTjKCY]>V`00CY]>VP0400000djJBWX00002
CWX01TYjCWY>NTijBWX000M>NP0:001>NDijCWU>NTiiCWY>N@00CWT400000diiCUT00002CWT01TiI
CWU>NDiiCUT000Q>N@05001BNTiiDWU>N@020002DYX00`00D[YF^P02E[X01U:j000005Jj001Ff`80
0007FaaO?5lLGcaK75llGa`0100000=S_F>lHkd00P000f?L00<006?LHm`00V?L00D005nMGieOWEmm
009OW@80009KG@08001G75LmEaeK?ELLEceG7@<002Ioo`00<7oo0P001Goo1@00011Bo4kL001>fe;l
C]aBo4kKD_a>g000C]]Bo4kLD]a>f`80000@D]`005;LC]aBg4kKD]a>g5;L001Bg4kKD]a>^e;LC]/3
000054jkD]a>^e;LC[]Bg4jk001>^e;LC[]Bg4jkD]a>^`00C[]Bg4jkD]`400005DjKC[]>VdjlCY]>
^djK001>VdjkCYY>^djKC[/004jkCYY>VdjJC[]>VP0300007DYjCYY:NTjKBWY>VP00CYY:NTijBWU>
VTYjCWX004ijBWU>NTYiCWY:NDij001>NTYiCWY:FDijBWT00`0001Y:FDiiBUU>NTYICWT004ijCUU>
NDiICWY>FDii001BNTiiDWY>FE9jCWUBNTiIDWX005:J0P0000MBVE:JDYUFVP00E[YBVP0300003e:J
E[]B^UJj001O?5/KGcaK6ellFa]O?5/KGcaK6`0200001F>mHkaS_@00Io`00V?L0P000f?L0P0000ES
_@00001OOEnM0080000:FcaKGE/lGeeK?000EaaK?ELLFcd2000015;lEad000009Goo000_Ool01000
Oomoo`000goo0P001e;L00<005;LD]`01E;L00<005;LD]`00P0000E>g5;LD]aBg00000=Bg005C]aB
g5;LD]`00002D]`300000dkLD]`00002C]`03E;LC[]>g4kLD]`004jlC[]Bg4jkC[a>^e;L00D0009>
^`03C[`004jk009>^`05CY]>^djkC[/00002CY/01TjkCY]>VdjKC[/0009>V`<00003CYY>V`00009>
NP06CYY:NTijCWY>VP000dij00E:NTijCWY>NP0000M>NP03001>NP0000<00003CUU>N@00009>F@06
CWU>FDiICUU>N@000dii00E>FDiiCWU>N@0000M>N@<00003DYYBVE:J009BVP05DYT00000001B^P03
E[X035:j000005[k001O?5lLGcaK75llGaaO?0800005Hi`00000Hkd00003Hm`00`00HmaSg002Hm`0
0`00HkeS_@03Hkd200000e]MFceKG@02Fed01E/mFed005/mEa`00P0000IG75KlEaaFo5LL000UOol0
02moo`04001oogoo0003Ool200003e;lC]aBo4kLD_a>g5;l001Bo4kKD_a>g5;lC]]Bo00300003U;l
C]aBg4kKD_a>g5;L001Bg4kLD]a>fe;LC]`300004DjkD]a>^e;LC[]Bg000D]a>^e;LC[]Bg4jkD]`0
05;LC[/0100001I>g4jk001>^djlC[]>_4jkC[`004jlCY]>^djKC[a>Vdjk001>^djKC[]>VPD0000L
BWY>VdYjCY]:NP00BWY>VdYjCYY:NTjKBWX004YiCYY:NTijBWU>VTYj001:NDijBWU>NTYiCWX30000
6TijBUU>NDYICWY:F@00BUU>NTYICWU:FDijBUT004iICWY>FDiiCUU>NTiI001>FE9jCWT400001U:J
001FVU:IDYYBV@<00006DYUFVP00E[YBVUJk0P0000mJfe[kF_/005/KGcaK6ellFa]O?000HieSO6NM
Hg`00`000V?L00<006OmHm`00V?L00D006>lHkeS_6>m00800009Gg`005/lFeeK?5mMFcaKGE/l00<0
0007D_aG7E;lEaeBo5LMD_`00P0097oo000_Ool01000Oomoo`000goo00<007oo00001e;L00<005;L
D]`010000U;L00<004kLD]`00U;L00E>g5;LD]aBg000009Bg0<00003C]aBg000009>g006D]a>g4kL
C]aBg0000TkL00ABg4jkC]a>g0<00007C[]>_4jkC[a>^djl00000Tjk00I>_4jkC[]>^`00CY/3C[/0
0djKC[]>^`0500001DZKCY]>VdjK00000TjJ00I>VdYjCYY>VP00BWX2CWX01TjJBWY>NTij001:NP=>
NP05BWY>NTij001>NP04000014iIBUT004YI0TiI00E>NDYICUU>F@0000=>F@06CWU>FDiICUT004iI
0dii00=>FDii00000`000U9i00A>NE9iDWUBN@@00007DYUBVU:JDYYBV@00E[X00P001U[k00@005/L
GcaO70800004HieSW6>MHg`3000016OL000000000V?L0P000f>m0P0015mm00D005]MFeeK?E]M0080
009G7008001G75KlEaaFo5LLE_aG70<002=oo`00;goo00@007ooOol000=oo`800008Ool005;lC]aB
o4kLD_a>g0<0000?C]aBo4kLD_a>g5;lC]`004kKD_a>g5;LC]]Bo4kL00<0000AC]aBg4kKD]a>g5;L
001Bg4jkD]a>^e;LC[]Bg000D]a>^`03000054jkC]`005;LC[]>g4jkD]a>^dkL001>_4jkC[a>^djl
C[/004jKC[`400007DZKC[/004jKBYY>VdZJCY]:VP00BWY>VdYjCY]:NTjK001>VTYjCY]:NTjJBWY>
V`00CWY:NDjJBWX01@0001]:FDijBUU>NTYICWX004iiBUU>NTYICWU:FDij001>NDYICWY:FDiiBUU>
NP00CWU>FDijCUT00P0000QBNDiI001>NE:JCWUBVTii0`0000YBVEJJDYUBVU:IEYYBVE:JDYT0009J
n`08F]]Jne[kF_]Jfe[k001O?0800009HgaSWF=lIieSO000HkaWg6?L00800003IoaWf`0000800004
HkaS_@000002Ggd01emlHieOOEmm001OGE/l0080000:FceG75/mEaaK?@00EaeBo5LMD_`200000eKm
D_`0000SOol0031oo`8000Aoo`05001oogooOol00002D]`300001DkLD]`005;LC]`00e;L00I>g5;L
D]`004kLD]`400000dkLD]`00002C]`01E;LC]a>g4kL00000dkL00ABg4kLC]a>g0<0000?C[a>g4jl
C]a>_000C[]>_4jkC[a>^djlC[]>_000009>^`03C[a>^djk00<000=>V`05BY]>VdjK001:V`03CY/0
1DZKCY]>V`00BWX00TjJ00I>VdYjCYX004jJBWX2CWX00djJBWX0000400003dYICWY:FDYj001>NDYI
CUU:FDiiBUU>F@00CWU:F@02CUT01DiiBUU>F@00CWT00diI00E>NDiICUT004ii0080009>N@05CUU>
N@00DWU>N@0300001DiiDWUBN@00DYT00e:J00IBVE:J000005Jj0008F_/02000HieSO6>MHiaSWF=l
0003Im`2000016OlIm/000000VOL0P0025mm0`0000=G75LMEa`00ULL00EG7ELL001Fo5LL00800006
D_aFo5;lE_aBo0008Woo000fOol20003Ool200001TkLD_e>g5;lC]aBo@800006C]aBo4kLD_a>g5;l
0`00015Bo4kLD]a>g5;lC]aBg000D]a>g5;LC]]Bg4kL001>^e;L00@0000DC[a>g000D]a>^dkLC[]B
g4jk001>^e;LC[]>g4jkD]a>^`00C[]>_0<0000KC[a:V`00BY]>^dZKC[]:VdjkBY/004ZJCY]:VTjK
BYY>VdZJ001:NTjKBWY>VdYj001:NTjJ00@0000PBUU>NP00CWY:FDijBUU>NTYI001:FDijBUU>NTYI
CWY:F@00BUU>NDYICWY:FDiiBUT004YICWU:FDijBUU>N@<00006DWU>FE9iCUUBNDiI0`0000]>NE:J
CWUBVTiiDYX005:JDYUFVU:I00800004F]]F^U[K0003F_/00e[KF_]Jn`0200001F=L000006=lIid0
0P0000IS_6OLHm`006?KIo`200000f>kImaWg00200001FNm001OOEmlHid00Umm0P0000YK?5]M001K
?ELLFceG75/mEaaK?@<00008E_aBo5KmD_aFo5;lE_d0029oo`00=Woo00<007ooOol00goo00<005;l
C]`00U;L00MBo4kLD]aBg000C]aBg00300002e;LC]`004kLD]a>g5;LC]aBg4kL00000dkL00=Bg4kL
C]`00`001dkL00h004kLC[a>g4jlC]a>_000C[]>_4jkC[a>^djl0`000Tjk00I>_4ZKC[/004jKBY/3
CY/01DZKCY/004jKBY/00djK00E:VdjK001>VdYj009>VP@000I:NP0D001:FDijBUU:NTYICWY:F@00
BUU>NDYICUU:FDiiBUT004iICWU:F@9>F@04CWU:F@00CUT40002CUT01@00CWU>NDiICWT00P0000E>
F@00DWUBNDii00=BN@04CWUBN@00DYX200001eJjE]YF^UKJE[YFfP0000=Jn`8000ESG0<0009Wg080
0003Im]Wo6OK0080009Wg006001SW6NmHiaS_@000Umm0P0000=K?E/lFcd00U/m00<005LLEa`01000
00YG75Kl001Bo5KlD_aFo5;lE_aBo080025oo`00=Goo00<007ooOol01Goo0P0000I>g5;mC]aBo4kL
D_d300004E;mC]aBo4kLD_e>g000C]aBo4kLD]a>g5;lC]`004kKD]`00`0001ABgDkL001>^e;LC[a>
g4jkD]a>_000C[]Bg4jkC]a>^e;L001>g4jk100001Q>_4Zk001:VdjlBY]>_4ZKC[`004jkBY]>^dZK
C[]:Vdjk001>VdZJCY]:VTjKBYX50003BWX07P00BUY>NTYICWY:FTijBUT004YICWY:FDijBUU>NP00
CWY:FDijBUU>NTYICWX004ijBUU>NDYICWY:F@<00008CUU>NDYHCWU>FDii001BN@<0000;DWU>FE9i
CUT004iiDYY>NE:JCWUBVP0300002U[KE[YJfeJjF]]F^U[KE[X005[K0P0000YSG5mKHeaOG6=LGe]S
G000IkaWW0<0000>Hm]Wo000001S^`00Im`006>LIkeSW6NmHiaW_@800007FcaOGE/lFeeK?5mMFc`0
0`0000aBo5LLD_aG7E;lEaaBo000D_aFo5;lE_d200000e;LE_`0000POol003Eoo`8000Qoo`03001>
g5;L00<0000AD_a>g000C]aBg4kLD]a>g5;LC]`004kLD]a>g5;LC]aBg0030006C]`00`00C]a>g005
C]`01@00C[a>g4jlC]`0100000E:^djlC[a>_4Zk009>_00:001:VdjkC[]>_4ZKC[/004jKBY/3CY/0
14ZK001>VdjK100000=:NTYk00001DYj00<004YjBWX01DYj018004YjBUU>NTYIBWY:FDij001>FDYI
CWU:FDiIBUU>N@00CUT400000dYICUT00005CUT30003CWT01DiICWU>NDii00000e9i011>N@00001F
VU:I001F^UKJE[YFfUJjE]YF^UKJE[X000QSG005001W_6NlIk`00002Jm/30002Im`200001F>LIkeS
W6>mHi`00P0000AOO@00FceK?0=K?@800003EaaK7@00009Fo008EaaFo5KlE_aG7000E_aBo080009B
o003E_aBo000021oo`00=Goo00<007ooOol027oo0P00015BoDkLD_e>g5;mC]`004kLD_e>g5;lC]aB
oDkL001>g5;l00<00005D_e>g000C]aBg@03C]`02E;MC]`004jkD]a>_4kLC[]Bg00500005dkLB[]>
g000C[a:^djlB[]>_4ZkC[`004jlBY]>_4ZKC[a:V`00BY]>^dZKC[/01@0000M:VdYjCY]:NTZKBWX0
0003BWX05dikBWY:NP00CWY:FTijBUU>NTYJCWX004ijBUU>NTYICWY:F@00BUU>NTYICWX01@0000U>
FDYICUU:F4iIBUT004YHCWT00`0000e>NDiI001>FE9iCUUBNDiIDWU>FE9i001BVP02000035:IE[YB
VEJJ001JfeJjF]]F^U[KE[YJf`800007Ga/005mKHeaOG6=LGe/00P0000YW_6NLJk`006_kIm][o000
Jo]WfP800005IkeSW000HiaW_@0200001emLHgeOG6=m001KGE/l0080000<FaeG75/mEaaK7@00EaeB
o5LLD_aG7E;l0`0000QBg5KlD]aFo5;LE_aBg0007goo000eOol00`00Oomoo`09Ool03`00C]aBo4kL
D_a>g5;lC]`004kLD]a>g5;LC]aBg0030006C]`00`00C]a>g005C]`00`00C]a>g0030002C]`01@00
C[a>_4jlC]`00Tjl00<004jlB[/00djl00E:^djl001>_4ZK009>^`H000A:V`09001:NTZKBWY:NdYj
BY]:NP0000E:NP03001:NTYj00E:NP05001:FDYjBUU>NP070004BUT01`00BUU>FDYICUU:FDiI00<0
00I>F@03001>FDii009>N@03CUU>N@000080000>EYYBVUJJDYUFVU:JEYX005KJE[YFfUJjE]X000AO
6`05001SG6=LHe`00003Ik`20003Jm/01P00Jm][ff_k001[g080000:Hi`00000HgeOO5mmGgaSOEml
Ggd20003Ea`01E/MEaaG75LL00000UKl100000=Bo5Kl00000U;l00EFo5;lD_aBo5Kl008001ioo`00
=Goo0P002goo00/004kLD_e>g5;mC]aBoDkL001>g5;m00<0000:D_e>g000C]aBoDkLD_e>g5;m0002
C]`01E;MC]a>g4kLD]d00`0001A>gDZlC]a:_4kMB[`004ZkC]a:_4kLB[]>g000C[a:^djlB[]>_4Zk
1@0000A:VdZlBY/0009:V`0>BWY>VdZKBY/004jKBWY:VdYjCY]:NTZK001>N`=:NP09CW]:NP00BUU>
NTYJCWY:FDij00D0000?BUU:>DYJBUT004XhCUU:FDiIBSQ>F@00CUU:F4iI00<0000>CUT004iiBUQ>
NDiICWU:F4ii001BNDiIDWU>F@80000ADYY>N@00DYUF^U:IEYYBVEJjDYUFVP00F]]F^U[K001O7002
Ga/01U/KGaaO6`00Ge/0009W_005Ii`006OKJo]Wf`02000026_kImY[n`00JmaW^f_LIk/200001V=m
GeaSOEmLHgeOG0800009Ged005/MEaaK?ELLFaeG75/m00<0000>E_eBo5KlD_aFoE;lE_`005KlD]aF
o5;LE_aBg08001ioo`00=Goo00<007ooOol02Woo00P005;lC]aBo4kLD_a>g5;l0`000TkL00E>oDkL
C]a>g00000I>g003001>g4kL00@0009>g003001>g4kL00A>g003001>g4jl009>_006C]a>_4jl001>
_4Zk0`000TZl00<004ZLBY/00TZK00=:W000BY/01TZK00T004YkBWY:VdYjBW]:NTZK00001DYj00<0
04YjBWX010000TYI00<004YIBUT014YI00<004YIBUT01DYI0`0000I>FDYICUU:FDiI0007CUT01000
CWT00000159i00/005JJDYUFVU:JEYYBVEJJDYX005Jj008000QO6`80009W_005001Wff_KJm/00003
Jm/200000f_LIm][g00200001VNL000005mmGgaSO@800006FcaO?E/lFc`005/M0eLL0P0000]G75Kl
001Bo5KlD_aFo5;lE_aBo000009Bo0@0009Bo003001oogoo01]oo`0077oo0P0017oo0P000goo1000
0goo0P0017oo00<007ooOol037oo00<005;mC]`0100000mBoDkL001>g5;mC]aBoDkLD_e>g000C]aB
oDkLD_d0100001=:g4kMC]a>gD[LC]e>g000B[a>gDZlC]a:_4kM001>g4ZkC]a:_00500003TZKC[a:
VdZlBY/004ZKB[a:VdjlBY]:_000CY/2BY/03TYjCY]:VdZK001>VdYjBY]:NTjKBWX004YjCW/2BWX4
00002TIIBUY6FDYJAUU:FP00BUU:>DYJ0TYI00I:>DYJ001>FDXhCUT400003TYICUU:F4iIBUU>FDYH
001>FDiiBUQ>NDiICWT300004e9iCWUBVTiiDWU>NE:J001FVU:IE[YBVEJJDYUF^U:I001K6elL009O
6`04Fa]O75lKGa/200000fMkIg`00002000046_kIm/006OKJo]WfP00Ik][g6NkJm`006NlHiaW_6NL
100000UOGE/lGeeK?5mMFc`005LLFad00P0000aFo5LLD_aG7EKl001Bo5KmD_aFo5;lE_d300001UKl
D]aFo5;LE_aBg08000Ioo`D0015oo`006goo00@007ooOol000Qoo`03001oogoo00=oo`04001oogoo
0003Ool2000>Ool2000024kLC_a>g5;mC]a>o4kL0003C]`00dkmC]a>g005000014kMC]a>g@001dkL
00<004kLC]`014kL1@0014Zl00<004ZlB[`014Zl00<004ZKBY`00dZK00=:W000BY/01DZK00D004Yj
BW]:NTZK00L00005BWY6FTYJ001:FP03BUT014YJBUU:F@001TYI00@004YI000000A:F@0:001:FDiI
BUU>FDYICUU:F@00CUT400000diiCUT00007DWT01`00DYYFVU:IEYYBVUJJ00800003F]X005lK00EO
6`03001WO6Mk009WO003001[^f^k00<0009[f`06001W^f_LIm][g0001VNL00D005/lFcaK?5lm00=K
?00>Gcd00000001G75KlEaaFo5LLE_aG7000E_aBo0@0009Bo003001Bo5;l00EBo003001oogoo00Io
o`03001oogoo015oo`006goo00@007ooOol000Uoo`03001oogoo00Eoo`05001oogooOol0000@Ool0
3000D_e>g5;mC]aBoDkLD_e>g000C]aBo@<00009C_e>g000B]a>oDkLC_e:g4km00800009B]a>gDkL
C]e:g4kM001>g4Zl00<0000JB[a>g@00C]a:_4kLB[a>g4ZlC]`004ZlBY]>_4ZKB[a:V`00BY]:_4ZK
C[a:V`00BWY>V`9:V`L0000CBW]6FTYkAUX004IIBWY6FTYjAUT004IIBUY6FDYJAUU:FTII00000TYI
00=:>DYJBUT00`0000e:FDiIBSQ>FDYICUT004iIBUU>FDYHCUU:F@0300004diHDWU>F59iCUQBN@00
DYY>NE9iCWUBVTiiDWU>N@00DYUFVU:I00800007F]]JfU[kF]X005/KGa`00UlK00`006NLIg]WO6=k
001[^f_KJk/006_JKm/300002F_LIk/00000IkaSW6NlIiaW_00200001f=L001K?5mMFcaOGE/l0080
000:FceG7000E_aG75;lEaeFo5LLD_`300003E;LE_aBo5KlD]aFo000E_aBg5KlD]aFo5;L00<000Mo
o`03001oogoo015oo`006goo00@007ooOol000Yoo`03001oogoo009oo`8000Aoo`03001oogoo00mo
o`800006C]a>o4kLD_e>g4kl0`0000m>oDkMC_e>g4kmC]d004kLC]e>g4kMC]a>gDkL000014kL1000
00M:_4[LB]a:gDZlB]`00006B[`00`00B[a:_004B[`01@00BY]:VdZLBY/01P0000i:NdIkAW]6N`00
AWY:NTIjBWY6NTYj001:NTIJ0TYJ00E:NTIJ001:FDYJ00=:F@04BUY:F@00BUT30002BUT00`00BUU:
F@05BUT00`00CUT000030002CUT01000CUU>FDii0diI00=>N@00DWT01U9i00@005JJ000000MJfP06
001O6`00001WO6Mk0VMl00/006^kJk][^`00JmY_fV_J001[fVoJ008000EWW08000ASO003001K?5/l
0080000:EaaK75/LFaaG7000E_aG75KlEa`2000015;lE_`005Kl0e;l00EFo5;lD_`005;l00@00004
D]aBo0000006Ool00`00Oomoo`0AOol001]oo`04001oogoo0008Ool01000Oomoo`000goo00<007oo
Ool00goo0P004Woo00<004kLD_d00`00015BoDkL001>g4kmC]a>oDkLC_e>g000B]a>oDkLC_e:g4km
00D0000GC]e:g4kM001>gDZlC]e:_4kMB[`004ZlC]a:_4kLB[a>g4Zl001:VdZlBY]>_00600007dIk
BYa6V`00AWY:VdIjBY]6NTZK001:NdIJBW]6FTYkAUY:N`00BWY6FDYjAUY:NP00BUY6FDYJAUU:FTII
00<0009:F@08BSU:FTYIBUT004iIBUU>F@D0000FCUU:F4iIBSQ>FDYH001>F59iCUQBNDiHDWU>F000
CWUBVTiiDWU>NE:JCWT200007U[kF]YJfe[JF_]JfU[KF]YJne[J001SNfNLIg]WO6=k001[^f_KJk/0
06_JKm][fP00JmY_ff_J001[^`80000:Ik`00000GeaSOF=LHgaOG6=mHe`200002U/mEaaK?ELLFceG
75/m001G7EKl0P0000]G75;lE_aBo5LL001Fo5;LE_aBo5Kl00<00008E_aBg5KlD]aFo5;LE_`000Io
o`03001oogoo015oo`0077oo0P002Woo0P0017oo0`000goo00<007ooOol04Woo0P000dkm00=>g4km
C_d00P0000U>oDkMC_e>g4kmC]d004kLC]d00`0000a>gD[M001:g4[MB]a>gD[LB]d004[MB[`2B]`0
0d[MB[`00004B[`70002AY`01DZl0016VdJKBY`00TJK00<004YkAW/00TIk00i:NdIkAW/004YjAWY:
NTIjBWY6NP00BUY:NTIJ0TYJ00A:NP00BUU:F@<00003BUU:FP0000=:F@L00006BUU:>4YIBST004YH
0diI00A:F4iICUT000=>F@05CWU>FDiICUT00004DWT200000eJIE[X00007F]X200000f<k001WN`02
Ig`02P00Jk][^f^k001[fVoJJmX006_J0VoJ00H006^kJk][^fnk0007Hg`400001ELLFaaK75/LEa`0
0U/L0`000UKl00QBo5KlE_aFo5;l001Bo5Kl0`000U;l00@005;lD_aBg0=Bo003D]`0000000Aoo`80
01=oo`00=7oo00<007ooOol04goo00h004kLD_e>g4kmC]aBoDkLC_d004kmC]a>oDkL1000019>oD[L
C_e:g4kmB]`004[LC]e:g4kMB]a>g@00C]e:_4kMB[`600009TZmA[a:_DJl0016W4ZlAY]:_4JLB[`0
04ZLAY]:W4IkBY`004ZKAWY:VdIjBY]6NTZK001:NdIJBW]6FTYkAUX004IJBWY6FDYjAUX300000dII
BUX0000600007TYIASQ:FDHh001:>4iIBSQ:FDXhCUT004iIBSQ>FDYHCUU:>4iI001BNDiHDWU>F59i
CUQBN@00DWU>N@80000>E[YFVEJjEYUF^P00F_]JfU[KF]YJn`00Hc]S6P9S>`0J001SN`00Jk][ff^k
001[fVoKJmX006_JKm][fP00Jk]_ff^jKm/006^L001SOF=LHgaOG0800003GeaK?5mM00800004EaaK
?ELLFcd200002UKlEa`005LLD_aFo5;lEaaBo5Kl0`0000eFo5;LE_aBg5KlD]`005;LE_aBg5KlD]aF
o003000HOol003=oo`8001Ioo`8000=>o@03C]a>oDkm00D0000@B]e>oDkm001:gDkMB]e>oD[MC]e:
g@00B]a:gD[LC]d600003TZmB]e6_000A[a:_4JlB[a6_4ZlA[`004JLB[`3AY`01@00AY]6VdJKBY`0
0TJK00<004YkAW/00TIk00Y:NdIk0016NTYjAWY:NTIjBWX0009:FPP00005AUU6>DHiAST00006BST0
2`00BUU:>4YIBSU:FDXhBUT004iIBUP00diI00A:F4iI001>N@=>F@03CWU>F@0000800008EYUF^UJI
E[YFVEJjEYT000AJfP03001S>f<k00AS>`80009[^`06001[fVoJJmX006_J0VoJ00I_f`00Jk][^fnk
0002Ji/00f^L001SO0020003Gc`01UmLGcaO?000FaaG70800003EaaFo5LL009G7005001Fo5KlE_aB
o00200000eKlD_`00006D_`00`00D_aBo00400000e;lD]`0000HOol003=oo`03001oogoo01Moo`03
001BoDkL00<0000@C]e>o@00C_e:g4kmB]a>oD[L001:g4kmB]a>oD[LC_d500008d[MA]a:g@00B]e6
_4[MA[a:gDJl0016_4ZmA[a:_DJlB[d004ZlAYa:_4JKB[a6W000AW]:W4JKBYa6N`00AWY:VdIjBY/0
3P0002I6>DIJAST004HiBUU6>DYIASU:F@00BUU6>4YIASQ:FDHhBUT004YIBSQ>FDXhBUU:>000BUQ>
FDXhCUU:F4iIBSP004iHDWU>F59i0P0000eBN000EYUF^UJIE[YFVEJjEYUF^UJI001JfP0200000f<k
HaYS>`02Hc/016<J001[Nf^K0`0001Y_ff_J001[fVoKJmY_n`00Km][^VoK001[W6NKJkaWVf^L001O
GEllGeaK?5mMGcaOG5/l0`0000YFo5/ME_aG75KlFaeFo000D_aG7080000;D]aFo5;lE_`005KlD]aF
o5;LE_aBg003000025;LD_aBg5KlD]aBo5;L000GOol003=oo`03001oogoo01Qoo`8000I>o@05001>
oDkmC_e:g@02C_d00`00B]e>g@030002B]d00`00B]e:g@04B]d03`00B]e6_4[MB[e:gDJl0016_4Zl
A[a:_4JlB[`00002AY`00dZlAY`0000;00001DIk@U]6Nd9K00000TIJ0P0000Y6FP00ASU6FTIIAUY6
>DIJ0016F@=6>@04AUU6>DHi0006BST02@00BSU:FDXhBUU:>DYIBSP00002CUT01dYHCUU>FDiIBUP0
04iI008000ABN@0;001FVEJjEYUF^UJIE[YFVEJjEYT00007Hc/01@00Jg][Vf^K00000Vnj0`000VoJ
00I_f`00Jk][^fnk0002Ji/01V^LIi][V`00Ig`0009O?003GeaO?5ll00800005Fa`00000EaaFo003
Ea`00eKlEa`0000200002EKlD_aFo5;lE_aBo5Kl001Bo0040002D_`01@00D_aBo5;lD]`00e;l0P00
5Woo000cOol2000JOol03@00C_e>gDkmB]a>oDkMC_d004kmB]a>oD[L00@00008C_e:gD[mB]e>oD[M
0016g0=:g@0>A]a:g@00B]e6_4[MA[a:gDJl0016_4ZmA[a:_@H0000@@Ya6W4:L0012NdJL@W]6W49k
0012FTIk@UY6Nd9JAW/30000:4IJ@UY6Fd9J0016>DIJASU6FTHiAUX004YIASU:FDHiBUU6>@00ASQ:
FDHhBUU6>4YIASP004XhBUU:>4iIBSQ:F@00CUU:F4iIBSQ>FDYH0`000U9i00aBN5:IDWUBN@00E[YF
VEJjEYUF^UJIE[X200000e[J001S6P03Hc/200002V]kJi][N`00KkY_ffnj001_fG?J100000m[^VoK
001[W6NKJkaWVf^L001WO6=KIg`005mMGc`00P0000AO?5/LFcaK70800003EaaFo00000<00009EaaF
o000D]aFo5;lE_aBg5Kl00<0000>E_aBg5KlD]aFo5;LE_`005KlD]aBo5;LE_aBg08001Ioo`00<goo
00<007ooOol06Woo00<004kmC_d014km1@0000A:gD[mB_d000=:g@05B_e:gD[MB]d00004B]d=0000
4dJmA[a6_@00AYa2W4JL@Ya6W000AWa2NdIk@W]6O000AW]2FdIk00<00003AW/004IJ00A6FP0:0016
FTHiAUY6FDIJAST004HiAUT3AST00dIIAST00006BST02P00BUU:>DYIBSQ:FDXiBUT004iI100000=>
F000DWT01e9i00T005JjEYUF^UJIE[X005kjG]X00Ukj00H006<kHc/006^KJg/2Ji/03000KkY_^Vnj
001_fG?JKmYcfP00LmY_fP80009[V`06JiaWV`00001WO6=k0fMl0P0000MK75/lFaaK?5/LFcaK7003
0006E_`01@00E_aBo5KlD_`00P000U;l00<005;lD_`01E;l00<005;LD_`010000U;l00<007ooOol0
4goo000cOol2000LOol00`00C_e>g@03000044[mC_d004kmB]e>oD[MC_e:g@00B]e>oD[MB_e:gDkm
1@000TKM01]:gP00A]e2_4KM@[e6gD:l0012W4Jm@Ya6_D:LA[d004JL@Ya6W4:LAY`004JL@W]6W49k
AY`00`0002E6Nd9JAW]2FP00@UY6Fd9JAUY2FTIK0016FTHiAUY6>DIJAST004HiBUU6>DYIASU:F@00
BUU6>4YIASQ:FDHhBUT004iIBSQ:F@0500002E9iCUQ>FDiHDWU>F000DWQBV@02DWT01e9hDYUBN@00
EYUF^UJI0080000KG_]JfUkjF]YNn`00Hc/006^KJg][Vf]k001_^VoKKkX006oILmY_^G?J001cfVni
LmX006nj00800007Ii/006=KIgaSFfMlHe/00P0000MSG000GcaK75/lFaaO?00300002e/L001G75;l
EaaFo5LLD_aG7000E_`00P0000aBg5KlD]aFo5;L001Bg5KlD]aFo5;LE_`300001UKlD]aBo5;LE_aB
g08001Aoo`00<Woo0P007Woo0P000Tkm00E:oDkmC_e>o@00009:o@05C_e:gD[mB_d00002B]d30000
0d[MA]d00006A]d00`00A]e6_@02A[d04DKMA[d004JlA[e2_4JmA[`004:LAYa2W4JL@Ya6W000AW`0
0`0000U6O000AW]2FdIk@U]6Nd9K00001DIJ00P004IIAUY6>DIJAUU6FP000THi00I6FDHiASU6>DII
0003BST7000034YIBSQ:>000CUU>F4iICUQ>FDiHCUT000QBN@<0009NnP09G]YNnUkjG_YNfUkj001[
Vf]k009[V`0>001_^VnjKkY_fP00LmY_fW?J001cfVoJLmX000A_^P04001WO6MlHg/2Ig`00`00HeaS
G002He`00`00FcaK70020003Fa`00`00Fa`00005E_`300001EKlD_aBo5;lE_`00U;l00<005;lD_`0
10000U;l00<005;LD_`00U;l00ABg5;lD_`001Aoo`007goo0P0017oo0P0017oo0P001Goo00<007oo
Ool07Woo00d004kmB_e>oD[MC_e:oDkm001>oD[MC_e:g@0400002D[nA]e:oTKMB_i6g@00A]e:gP03
A]d04`00@[e6gD:lA]e2_DKM@[`004:LA[e2W4Jm@Y`004:LAYa2W4JL00<0000MAYa2NdJL@W/0049J
AW]2FTIk@UY6N`00AUY2FTIK@UY6FT9J0016>DIJASU6FTHiAUX004YIASU:F@0700005dXiAQQ:>@00
CUU:>4iIBSQ>FDXhCUT004iICUQBNDiHCUU>F59i001BNE9hDYT00U9i00iBN000001NnU[JG_]JfUkj
F]YNne[JG_X006MK0P0001E[N`00KkY_ffnjKm/007?JKkUcfP00LmY_^G?J001_^VnJLk]_^P00JgX0
0P0000UWO000001O>f=LGc]SG5lkHe`00P0000IG75/LE_aK75LLFa`200000eKlEa`0000200002UKl
D_`005;LE_aBg5KlD]aFo5;L0`0000eBg5KlD]aFo5;LE_aBg000D]aFo5;LD_aBg003000COol001io
o`04001oogoo0008Ool01000Oomoo`0017oo0P0087oo0P000Tkm00=:oDkm00001@000d[m00T004KM
B]e6gD[mA]e:gDKM00001DKM00<004JmA]d00TJm;@000dHi00X004XiASQ:>DHhBSU6>4Xi001:F@=:
>00;BUU:>000CUQ>FDiHCUU>F4iICUP00004DWT200001EJIE[T005kjG]X00ekj00MNfUkj001WFfLj
Ic]W>P020002KkX02VoJ001cfVoJLmX007?JKmYcfP0016nj00H006^JKi][VVnK0006He`200000ell
001K7002Fa`015LLFaaK75/L0`0000=Fo5;lE_`00UKl00ABo000D_aFo09Bo080009Bo003001Bo5;L
00=Bo005D]aBo000D_aBg00300000e;LD_`0000COol001ioo`04001oogoo000;Ool00`00Oomoo`02
Ool00`00Oomoo`0QOol400002TknB_e>o@00B_i:gD[nB]e:oT[M0P0000A:oTKMB_i6g@`00008@]hn
_D:m?[d003jL@[dnW0<0000o?Wa2WCil?Y`nO000?U/nO3iK@W`nF`00?SY2Fchj@U/n>T9K0012>Shi
@UXn>T8j0016>T8IASU26DHj@QT0048HASU664Hi@QQ6>@00BSU664XiASQ:>DHH001:>4iIBSQ>FDXh
CUU:>000CUQ>FDiHDWU>F4iICUP0059i0080000:F[YFVEZjEYUJ^P00G_YJfUkkF]X200001fMKIcYW
Ff<j001[NVnJ00@0000:KkUcfP00LmY_^G?J001_^VnJLk/200005F]jKi][VVnK001[N`00HeaO>f=L
Gc/005lKGcaO>ell001K75LLFaaFo00300002eKk001Bo5KlD_aG75;lE_`005KlD]`00P0000aFo5;L
E_aBg5Kl001Fo5;LE_aBg5KlD]`300001e;LE_aBg5;lD]aFo000019oo`007Woo00@007ooOol000Uo
o`8000Eoo`03001oogoo029oo`03001:oDkm00=:o@03C_d0000000A:o@H000=6g@070012gD;M@]e6
gT;M00000T:m00Dn_D:m@[e2_Cjm00<000<nW@06000nO3il?W`nW0000SiK00HnO3iK?U/0049K?SX2
?U/00d9K?SX00005@SX01@00@SU2>D8iAST00T8i00<004HiAST014Hi00P004HhBSU6>4XiASQ:>@00
0TXh00a:FDXhBSQ:>4YI001>FDiHCUU>F4iICUP300000eJiF[UFV@02E[T00eZiEYT00002G_X02EkJ
001W>VMKIcYW>fLj001_NP03KiX00`00LkUc^@0300000foJLmX00003KkX01`00Ki][VVnKJiY_V`00
00=[N`04001SG0000005Gc`00`00EaaK700200001UKlEaaFo000E_`0009Fo003D_aFo5Kl00<00003
D_aFo5;l009Bo003E_aBo000009Bo0@00005D]aBo000D_aBg003D_`00e;L0000000AOol001ioo`04
001oogoo0009Ool00`00Oomoo`04Ool00`00Oomoo`0SOol200001DkmB]e>oT[mC_d01@0000Y:oTKM
B_h004KnA]e6oTKMA_i6g@800004A]i2_DKN@[d200000d:m?[d000030000?d:m?Ya2_CjL@[d003jL
?Wa2WCil?Y`0049l?U/nO3iK@W`0049K?SY2Fchj@U/n>P00?SY2>Shi@UXn>P00@QU6>T8IASU26DHj
0016>D8HASU664Hi@QP004HhBSU664XiASQ:>@00CUU:>4iIBSQ>FDXh001>F59iCUQ>F@0200007e9h
DWT005ZjEYUJ^UJIF[YFVEZjEYT005[J001S>VMKIcYWFf<j001[NVnJJgY_V`00LkY_VG>j001g^G>h
00<00007KiYc^`00Ki][NVnKJiX00P0000i[NfMjJg]WFV]k001O?5lKGcaO>ellGa]O?5lk0P0000IK
75KlFaaFne/LE_`200000eLLD_`0000200002U;lE_`005KlD]aFo5;LE_aBg5Kl0`0000eBo5;LE_aB
g5;lD]`005;LD_aBg5KlD]aBo002000AOol001moo`8000Yoo`<000=oo`8002Moo`03001>oD[m0080
009:o@04001:oD[nB]d2B_d01D[n000004KMA_h00dKM00I6oP00@]e2gDKN@]d300001Cjm@[e2_D:m
00001CjM00<003jL?W`00Sil00DnW000?U/nFcil008nF`030012Fchj008nF`03@U/0048j00A2>P03
0016>D8i0092>@03ASU2>@0000I6>@08001:>DHhBSU6>4XiASP000=:>006BUU:>4XhBSP004iH0P00
159i00H005JIE[UF^EZiEYT2E[T02UZiEYT006LjIe]W>VLkIcYWF`000fnJ00D007>iLkUc^@0000=c
^@03001c^G>i00800005Ki][VVnKJiX00005Jg/200000fMK001O?004Gc`200002E/L001Fo5LLE_aG
75KlEaaFo00300001e;lE_aBo5KlD_aFo000009Bo0@0009Bo004001Bo5;lD]`3D_`00e;L001Bo004
00000e;lD]`0000@Ool000Ioo`<002Uoo`03001oogoo02Ioo`800005B]e>oT[mC_e:g@0200002d[n
A]e:oTKMB_i6g@00A]e6oTKMA_h05`000312WCil000nFd9l?U/nO3iK000n>T9K?SY2Fchj@U/0049J
?SY2>Shi@UX004Hi@QU6>T8IASU26@00AQQ6>D8HASU664Hi001:>DHhBSU664Xi001>FDXhCUU:>4iI
BSP300003U9hDWUBN59iDWQBNE9h001FVEZjEYUJ^UJIF[X2000065kI001W>VMKHcYWF`00KiY[NVnK
001c^VnILkX007NiLkQgf@00MkUcV7Ni001c^@800008JiX006MJJg]WNV]kIeX0009WF`05He]WN`00
GcaO6`0200002EllFa]O?5/K001Fne/LE_aK7003000025LL001Fo5;lE_aBg5KlD_`300003E;LE_aB
g5KlD]aFo000E_aBg5;lD]aFo5;L00<00006D]aBo5;LE_aBg5;l0P003goo0007Ool00`00Oomoo`0W
Ool2000YOol00`00B_e:o@05B_d00`00B_i:g@02B_d:000023kN?[i2gSjm?]h003jn>Yd2>[d02Cjn
000jWCIm>YdfOCZM000fO00=0002?U/00`00@SY2>P03@SX00`00@SU6>@03@ST00dHi0016>@05AST0
2@00ASQ:>DHhBSU6>4Xi001:F@040002CUP00`00DWUBN@05DWT00`00F[UFV@02E[T01UZi001NnUkj
H_YNnP800003Ie/006nJ009_VP05KgX007>iLkT00004LkT01000LkUc^@000W>I00=c^G>I00001F]k
00<006MKIe/016MK0P0000UK75lLFaaO?5/LGa`005LLE_`00P000eKl0P0000ABo5KlD_aFo0800003
D_aFo00000MBo003001Bo00000<0009Bo005001Bo5;lD_aBg003D_`00`00Oomoo`0=Ool000Moo`<0
02Moo`03001oogoo02Uoo`800004B]e>oT[mC_d600000dKMB_i6g@03000094;MA_i2gDKn0012gSjm
@]hn_D;N000n_SZM?[hjWCjn000jWCIm>YdfO3ZM000jOCIL>WdfG000=S/jG3Hk>U`f>`00>QXj>`H0
000E?SY2>Shi00126DHi@QU6>T8IAST004HiAQQ6>D8HASU66000AQQ:>DHh00@0000bCUU:>4iIBSQ>
FDXh001BN59iDWQBNE9hDWUBN59i001J^UJIF[X006;jG]URnUkiH_YNfF;j001_VV]jKi][NP00KiUc
^Vni001c^7OILkP007>HMkUc^000LiUc^G>I001_N@800003Jg/00000009WF`03He]WNfMK00800008
Ie`005llFa]O?5/KGcaK6`<00006E_]G75KlEaaFneLL0P0000iBg000001Fo5;LE_aBo5Kl001Fo5;L
E_aBg5Kl0`0000eFo5;LD_aBg5KlD]aBo000E_aBg5;lD]aFo003000>Ool000Moo`04001oogoo000V
Ool00`00Oomoo`0[Ool400001TkmB_e:o@00B_i6g@<0000AA]d00000A]i2gDKN@]e6gP00?]hn_T;N
?[dngP00?[hjW@02>[d02Cjn000jWCIm>YdfO@00=U`fO003=U`01P00=S/f>cHk>U`0008j>P06>S/j
6SXj000n6ShI5@000TXh00A6>000CUQ>F@=>F003CUU>F00000MBN@04001F^@000002G_X01f;jG_YN
nUkjH_X006/j00800003KgX007>i009c^@05001c^G>iLkT00003LkT02P00LiUc^G>I001_VG>JKgUc
V@001VMK00T006<kHe]S>`00FaaO?5/LGa`00P000U/L00<005KlE_`015Kl0`0000QBo5KlD_aFo5;l
E_aBo0000U;l0`000U;l00<005;LD_`00U;l00IBg5;lD_`005;LD_`30002D_`20007Ool40002Ool0
00Moo`04001oogoo000VOol00`00Oomoo`0/Ool01`00B]e>oT[MC_e:gDkn00800004A]e:oTKMB_hG
0000C3ZM=W`003IL>WdfG3Ym000jG3Hk>U`f>cYL000j>cXJ>S/f6SXk000n6SXI?SXj6ChJ00126ChI
@QTn648I0016>D8HASU264Hi@QP004HhBSU664XiASQ:>@00CUU:>4iIBSQ>FDXhCUT0059iDWQBNE9h
DWUBN59iDWP005kiH_YNfF;jG_URnUkIH_X006]JIcU[FVLj0P00029c^Vni001c^7OILkP007>HMkUc
^000LiUc^G>I001_NG>JKgUcVP00KgX006MKHe]WNfMK001S>fMLHc]WFf<k001K6`800008GaaK6e/L
Fa]O7000EaaFn`<0000:D_/00000E_aBg5KlD_aFo5;LE_`300003EKlD]aFo5;LE_aBg000D]aFo5;L
D_aBg5Kl00<00007E_aBg5;lD]aFo5;L00001goo00<007ooOol00goo0006Ool4000WOol00`00Oomo
o`0]Ool00`00B_e:o@0300000d[m0000000300001T[nA]e:o@00@]i2g@=2gP0>000n_SZn?[hj_Sjn
000fWSJM=YhfWCJN000^G@H0008fG003000jG3Hk008f>`0>000j6SXj>SXj>cXJ000n6ChJ?QTn6ShI
000n6@=26@0:?QU26@00ASU264HIAQQ6>D8H0002BSP01DHhBSQ:>4Xh00000TiH00I>FDiHCUQ>F4iI
0005DWT2000015JI001NnV;j0ekj00MRnP00JcYW>V/jIcX00002KgT30003LkT01P00LkUc^@00LiUc
^@9cV@0:001cVVmiLiT006mjKgU_NP00Ie/200000f<kHe]S>`02Hc/00f=K00000007Fa`30005E_`2
00000eKlD_`000030002D_`00`00D_aBo004D_`00`00D_aBg0040002D_`00`00D]aBo002D_`015;L
D_`000001goo00<007ooOol00Woo000aOol00`00Oomoo`0]Ool300004dkn00000000C_e:g@00A]e:
oTKMB_i6gD[n0012gT;MA]i2gD;N0080000A>[dn_SZm?]h003JN<WdfWS:M=Yh0039m;UdbOBiL000Z
?0050000;cHk>U`f>`00=QXj>cXJ>S/f6P00>QTn6SXI?SXj6@00?QQ26ChI@QTn6000@QQ6>D8HASU2
64Hi001:>DHhBSU664XiASP004XhCUU:>4iIBSQ>FDXh001BN59iDWP00P0001EJ^UJIF[UFV@00G_UR
nUkIH_X006]JIcU[FVLj001_NG>JKgT007>HMiT0100001Mc^7Ni001c^G>ILkT007>JKgUcVP00KgY_
NFmjJeU_NP00Ie]S>fMLHc]WFf<k00800007Hc/005lLFa]K75/KGa`00P0000IFne/L001Fo5;kEa`2
E_`04E;k00000000D]aFo5;LE_aBg5Kl001Fo5;LE_aBg5KlD]`00`0000eBg5KlD]aBo5;LE_`005;l
D]aFo5;LD_aBg0030007Ool00`00Oomoo`01Ool0035oo`8002]oo`<0009oo`80009:o@0>C_e:oD[m
B_d004KMB_e6gD[nA]e:o@00@]i2g@92gPD00008>[h003JM=YhfWCJN=Yd000<^G@03<Wd002hl00@^
?0D0000>>S/j6SXj>SXj>`00?QXn6ChJ?QTn6P00@QTn6@=26@09?QT004HHASU264HIAQP004Hh00=:
>004ASQ:>4Xh0003CUP014iICUQ>F4iH0`000UZi00EFVEZiF[UJ^@00009NnP07H_X006/jIcY[>VLj
000016mi00D007>ILiQcV@00009gV0<0009cV@07001cVVmiLiU_V@00KgT00fmj00@006]J001SF`=S
>`03001S>f<k009S>`03001K75/L008000=K7003F_aK700000AFo0800003E_`005Kl00=Bo005E_aB
o5;l001Bo0040002D_`00`00D_aBg003D_`015;LD_`005;l100000=Bg5;l00001Goo00@007ooOol0
009oo`00<7oo0P00:Goo0`001Woo00d004[MC_e:gDkmB]e>oD[M0016gD[nA]e:oP0600001D;M@]hn
_@00=Yd02P0000TbOBiM<Wd002hm:S`^?2Xl00000RhK02T]n`00000003HJ>S/j6P00>QTn>SXI?QXj
6Chj00126ChH@QTn6D8I0016>D8HASU264Hi@QP004HHBSU6>4XiAQQ:>@00CUU:>4iIBSQ>FDXh0080
000PF[UFVEZjEYUJ^EJIF[YFVEZi001RnP00JeYW>F]JIcX006miLiY_NG=j001gVG>HMiUcV000LiQg
V000MiQcU`80000?LiY_NG>JKgT006miKgY[FFmj001_NV]IKgX006MK00800006Gc]S>elKHcaO>f<k
0P0000QFne/LE_]K75KkFaaFn`000UKl0P0000YBo5Kl001Fo000E_aBg5KlD]aFo0<0000=E_aBg5Kl
D]aFo5;LE_`005;lD]aFo5;LD_`00`0000IBo5;LE_aBg5;lD]`20005Ool20003Ool001Moo`8000Ao
o`8000Eoo`03001oogoo009oo`8000Eoo`03001oogoo02Eoo`<000Yoo`80009:o@03C_e:o@0000D0
0006B_e6gD[M0012gT;M0d;N00Q2g@00=[hj_SJn000^OBin0bim1@001Bhl00<002hK;Q/00RhK1000
00Pj>P00?QTn6ShI?QXn6@000T8I00dn6D8I@QU26@00AQU664Hi@QQ66@00BSQ6>003BSP014HhBSP0
04iI100000EBN59i001J^EJI00=J^@0;EYUJ^EZiF[T006/jIcY[>VLjJcX00003KgT01P00LiUcV7>I
LiP000=gV005001gV7NH001gV00200000fnI001_N@03KgX00`00JeY[FP03JeX00`00Hc]S>`04Hc/2
00000elk001K7002Fa`015[lFaaK75/L0`001EKl0P0000=Bo5Kl00000P0000=Fo5;l00001e;l00<0
05;lD_`00`0000=Bo5;L00000U;l00ABg5;lD_aBo08000Yoo`005Woo00@007ooOol000Yoo`05001o
ogooOol00002Ool00`00Oomoo`02Ool2000SOol3000?Ool400002T[LC_e:g@00A]e:oTKMB_i6gD[n
0P0000Tn_D;N@]e2gP00>[hfWCZn=Yd00P0000L^ORYm;Wh^O@008Q`V?@0300001Bhm:S`^?2Xl0000
0RhK00D]n`00<OXb6S7j00D0000F>QTn6SXI000n6D8I?QQ26ChI001264Hi@QQ6>D8H0016>4XiAQQ:
>DHhBST300003U9iCUQBNE9HDWU>F000EYUJ^EJIF[YFVEZiEYT20000=V;j001[FVLjJeX007>JKgUc
NVmi001cV7NILiP007>HMiQcU`00LiMgV7>G001cN7NHLgL006miKgY[FFmj001_NV]IKgY[FVmj001[
FP00Hc]O6f<lGc/005lKHcaO6f<l001K75KkFaaFn`800008FaaFn`00D_aFo5;kE_aBo0@0000=E_aB
g5KlD]aFo5;L001Bg5KlD]aFo5;LE_`00`0000UBo5;LE_aBg5;lD]`005;LD_`00`0000=oo`00Ool0
2Goo000FOol01000Oomoo`002Woo00<007ooOol017oo00<007ooOol00Woo00<007ooOol07goo0`00
4goo00D004kmC_e>oD[M009>o@800004B]e6gD[mA]d?0002;Wd00`009SdR?0029Sd60004;Q/00`00
<OXb6P02<OX00`00>OTen@0700002chI@QU26@00@QQ66DHHASU26000BSP0100000=:>DXh00000U9i
00IBN59iDWUBNE9h0002F[T01EJIF[UJ^@00G]T00V;i00ARnP00JcX000A_N@05001cV7>ILiP00003
MiP02P00MiQgV7NH001cN7NHMgP007=h0P0000=_NP00JeX016]J00H006]JJeY[FP00Hc/2000025lK
Gc]O6elkGa/005[lFa`200001EKlFaaFo5/L00000UKl1@0000AFo000D_aFo0=Bo004E_`005;lD_`4
00000e;lD]`00002D_`015;LD_aBo5;l0`0017oo00<007ooOol027oo000FOol01000Oomoo`002goo
00@007ooOomoo`8000Eoo`03001oogoo01eoo`8001Moo`07001>oD[MC_e:g4kmB]d01@0000i6gD[n
A]d003jm@]hn_D;N000f_S:M=YhbWCJn1@0000PV?B8L9SdR?0007O/R71gk0P00018b72hK;Q/003HK
<OXb6S7j000enCXJ=OTj6SGi>QX003hI?OP;0000BDXhCUU:>4iIBSQ>F@00DWUBF59iCUQBNE9HDWU>
F000EYUJ^EJI001NfF;jG]URnUkIH_X007>JKgUcNVmi001cV7NILiQgV@00MiQcU`00LiMgV7>G001c
N7NHLgMgV000MgQcN7NH001_NV]IKgY[FVmj001[FVLjJeYW>V]J001S?5lKHcaO6f<lGa]S?5lK0080
0007FaaFne/LE_]K75KkFa`00P0000EBo5KlD_]Fo5;l00800006E_aBg5KlD]aFo5;L0`0000UBg5Kl
D]aFo5;LE_`005KlD]`0100027oo00<007ooOol01goo000FOol01000Oomoo`0027oo00@007ooOol0
00=oo`03001oogoo00Aoo`03001oogoo01Yoo`<001Yoo`03001>oDkm00<0000?C]e>o@00B]e6gD[M
A]e:gDKM000n_D;N@]e2gP0000<fWP03<YdfWP00008VG@<000058S`V?@008O`Mn`038O`20002;Q/0
5@00<OXanS8J<OX003Gi>OTenCWi=OT003gi?QTmnChI?OT004HHAQU26002AQP01DHI001:>4XhBST0
0dXh00=:>@00DWT00U9i00IBN59iDWUBN@00F[T2000025kIH_URnF;jG]URn@00JcT20002KgT01@00
LiUcV7>I00000gNH00T007NHMiP007=hMiQgN7NH00000g=h00<007=h00000f]J00<006]JJeX00f]J
00P006Lj001O>elKGc]O6elk0P0000MO6`00E_aK75KlFaaFo00200000e/L001Fo005E_`200000e;l
0000000200000e;lE_`00003D_`00e;LD_aBo003000<Ool00`00Oomoo`07Ool001Moo`8000Uoo`@0
00=oo`<000=oo`8001Uoo`<001ioo`80000LB]a>oD[LC_e:g4km001:oTKMB_e6gD[n0012gSjm@]hn
_D;N000f_S:M=YhbWCJn000VGB8m9Uh500001R7l7O/R71gk000QfP<0000e<OXf6c7j<QX003XJ=OTj
6SGi>QXen@00?OPn6Cgh?QTmn000@QQ66D8HASU26000BSQ>FDXhCUU:>4iIBSP004iHDWUBF59iCUQB
NE9HDWT006;jG]URnUkIH_YNfF;j001[>VLIJcUW6@0200009WNILiQgV@00MiQcUgNh001gV7>GMiP0
07NHLgMgV000MgQcN7NHLgP006mHLgT006mj001[FVLjJeYW>V]J001[FVLjJe/006<lGa/200001elL
Ga]O?5lK001Fne/L0080000:E_]K75KkFa`005KlD_aFo5;kE_`300002UKlD]aFo5;LE_aBg5Kl001F
o5;L0`003goo00<007ooOol01goo000_Ool00`00Oomoo`0EOol3000ROol03000C_e>gDkmC]e>oDkM
C_d004[MA]e:gA00008VG@03000Io1Gl008000078O`Mnb7l8O`0027J8M/00`000S7j00hb6P00>OTe
nCWi=OTin@00?QTmnChI?OTn6@000THH00E66D8HAQQ6600000=:>006BSU:>4XhBSP0059h0e9i00EB
N000001JV@00009Rn@04H_YNfF;i0005JcT01P00KeT00000LiP0009gV00:001gV7NHMiP007NHMgQg
V7=h0003LgP01P00LgQcN7=HLgP000E[FP03001W>VLj00=W>P8000MO6`80009Fo005FaaFo5KlE_`0
0002E_`300000eKl00000003D_`015KlD_aBo5;l0`004Woo00<007ooOol01goo000_Ool00`00Oomo
o`0BOol3000VOol2000014[LC_e:g4km1@0000m:gDKMB_d004;N?[e2gSjm@]h003:N;WdbWRim<Yh0
1@0000<Io1Gk6O`00P0000LMnb8L000Qfb7J9O/QfP0500007SGi>QXenCXJ=OTj6P00?QTmn3hI?OPn
6@00ASU264HI@QQ6>@00CUU:>4iIBSQ>FDXhCUT0059iCUQBN@80000CEYQJ^EJI001NfF;jG]URnP00
JcYW6F/iIaU[>P00LgU_F7=iKeP00P0002Mg^7>H001cUgNH001gV7=gMiQcN000LgQgV7=h001_F7=i
LeQcN@00LgT006]JIcY[FP00JeYW>V]KIcY[FP00Ic/005lLGa]O?5lKGa`00P0000UK6`00E_]K75Kk
FaaFne/LE_/00P0000EFo5;lE_aBfeKl00800003D]aFo00000<001Eoo`03001oogoo00Moo`00;goo
0P0047oo0`00:goo100000A>oDkMC_d000=:g@08A]e:g@00000n_D:n?[e2gP800007<YdbWS9m<Yh0
01hm7Q`00P0000<Io1Gl6O`00`0000HQo0008M/QfR7K0003:MX3000033Wi=OTinCGi000mnChI?OTn
6Cgi001260966005AQU264HH001:>@03BSP00dXiBSQ:>00300002UZIEYUJVEJIFYUFV@00G]URn@00
1V/i00L006mHLeU_F000LgQgN0030002MiP01@00MgQgV7=h000017=h00/007=hLeQcN000LeU_F7=H
001[FP0000EW>P05001W>VLjIcX00003Ga/00`00Ga]O6`02Ga/01@00E_aFo5KlFa`00P0000=Fo000
D_`00eKl00=Bo5Kl00000P006Goo00<007ooOol01goo000_Ool00`00Oomoo`0<Ool3000_Ool03000
C]a>oD[LC_e>g4km001:oDKMB]e6g@/00006;WdbWP007SdJ71hm0P0000@En`004IXA^`8000078MXQ
fb7J9O/002WJ:KT00RWJ1@0001@en@00?OPn6Cgh?QT004HI@QQ6>D8HAQU26000BSQ>FDXhCUU:>4iI
0P0001aFVEZiEYQJ^EJIF[UFV5Zi001RnP00JcYW6F/iIaU[>VLI001_F7=iKeP007=gMgQcM`00LgMg
V0<0000FMiQcN7NH001gV7=hMgP007=iLeQcNFmH001_F7=IKeQcN@00JeYW>V]KIcX200001VLkIcYW
>f<j001O6`800008GaaK6elLFa]O7000FaaFn`800009FaaFne/LE_/005;KE_aBo5Kl008001]oo`03
001oogoo00Moo`00;goo00<007ooOol02Goo0`00<goo00H004kMC_e>g4kmC]d50003B]d02000?[dn
_Cjm?[hn_@00;Wd500000ahL7Sd0000300034K/200000b7K8MX00004:MX00`00<MTaf@02<MT40000
1ShI?OTn6@00AQU260966004AQU26000BSP4000034iICUP005JIFYUFVEZIEYUJVEJIFYT000I[>@07
001_F7=IKeQ_F@00MgP00W=h00@007MgMgL0009gM`<000=cN003001cN7=H009cN007001_F7=HKeQc
F@00KeT00P0000=W>P00IcX01VLj00<005lKGa/01ElK0`001UKl00<005KlD_`00P000Woo00<007oo
Ool06Goo00<007ooOol01Woo000^Ool20009Ool2000gOol00`00C]a>o@02000054kLC_d004[mA]e:
gDKMB_e6g@00?[e2gSjm@[hn_@00;Wd^ORYm;Wh500001`Vk0000016J4K/001FJ0080000>8MX002WJ
:MXY^BWJ000enC7I=OXaf@00>OPn6@`0000SCUQBNDiHDWU>F59i001J^EJIF[UFV5ZiEYUJ^@00H_T0
06/iIaU[>VLI001_F7=iKeQcN@00MgQcMgMh001gV7MgMgP00003MgL06P00MgL00000LgP007=HLgU_
F000KeQcFFmHLgT006mIKcQcFFlh001S>VLkIcYW>f<jIc/200001V<J001K6elLFa]O70800009F_]O
7000FaaFne/LE_]K75Kk00<000Eoo`03001oogoo01Qoo`03001oogoo00Ioo`00;Woo00<007ooOol0
1Goo0`00>Woo0P0000I>oDkLC_e>g4km0006B]d02@00?[dn_Cjm?[hn_@00;Wd^OP02;Wd00`005O`A
o00200001PVk2I/000004K/0008EVP8000@YfP03000afC7I00<af@03000in3gi008mn@0K0016>DHH
ASU664HiAQQ6>@00CUU>F4iICUQ>FDiHCUT005ZIEYUJVEJIFYT006;IG]URf@0000=[>@06001cFFmH
KeT007Mh0g=h00@007MgMgL000AgM`06001gEgMgMgL007=H0W=h00H006mHLeQ_F7=I0003KeT016mH
001_>@000fLj0P000fLj00<005lKGa/00P0000EO6e/KGa]K6`00009Fo0@000Qoo`03001oogoo01Qo
o`03001oogoo00Ioo`00;Woo00<007ooOol00Woo0`00?Woo00`004kLC_e>g4kmC]a>o@00B_e6gD[M
A]d;00001RYm;Wh001Gl4O`Eo08000092IX000004K/001FJ4GXEVP0000<YfP0f:KT0037I=OTafCGj
000n6CWh?QTin3hI0016>DHHASU664HiAQP004iHDWU>F59iCUQBNDiH001FV5ZiEYUJ^@00H_UNfF;I
G]URn@00JcT007=iKeQcN@00MgQcMgMhLgL007MgMgQcM`000WMg00MgEP00MeIgMg=F001cE`020000
3g=i001cFFmHLgU_F000KcQcFFlh001[>6mI001W>`0200001V<JIc]S6VLkHaYW>`800007F_]O75[k
GaaJnelLF_/00P003Goo00<007ooOol05goo00<007ooOol01Woo000^Ool50012Ool01@00C]a>oDkL
C_d01P000d[M00P003jm?[dn_Cjn?[d002YM100000@Eo17l0001F@8000031ET0000000@EVP80008Y
fP03000afC7I008af@04000mnCgi>OP2?OT08@00AQQ6>DHHASU664HiAQP004iHCUU>F4iICUQ>FDiH
001FVEZI001RfEkIH]UNfF;IG]URf@00LeU_F6mIKeP00003LgP01@00MgMgMgMg00000gMg00<007MG
MgL00WMg00X007MGMeMgM`00LeQ_F7=IKeP0009_F@04KeQ_F@00KeT2KcT00`00IcYS>P03IcX02V<j
IcX006Lk001O6e/KGa]K6elK0P0047oo00<007ooOol05Woo00<007ooOol01Woo000UOol50004Ool2
0016Ool400002TkmC]a>o@00B]e6gD[MA]a:gDKM0P0000Tn_Sjm?[hn_@00:UdZORYM:Wh00P0000<A
o0000ET00P0000P5FP5I000ANAFJ4GX001fI0P0002LYfP00=OXafCGi<MT003Wh?QTin3hI>OP004HH
ASU664HiAQQ6>@00DWU>F59iCUQBNDiHDWT005Zi001RnEkIH]UNfF;iG]URf@00JaT00P0000Y_F000
LgMgN7=gMgP007MhLgL0009gM`0<MeIgM`00MgMcEWMg001gMg=FMgL007MG0P0001U_F000KcQcFFlh
KeT006mIJcQ_F@00KeT006LkHaYW>f<JIc/006LkHaYW>`00GaaJn`02000COol00`00Oomoo`0EOol0
0`00Oomoo`06Ool002Moo`03001oogoo00Eoo`03001oogoo04Eoo`07001>g4kmC]a>gDkLC_d00P00
14[M2@0000<ZOBYM:Ud00`000`5I00<000EI1ET00P000QFJ00<001fI8IT00P00137I01D003gi?OTm
nCWh?OT004HiAQQ6>DHHASU664Hi001>FDiHCUU>F4iICUP00P0000eRfEkIH]UNfF;IG]URf@00JaUW
6F/IIaT00003LgP00gMh001gM`02MgL01@00MgMgMgMg00000gMg00X007MGMeMgMgMG001cEgMGLeL0
009_F@04KeQ_F@00KeT2KcT01`00KcU[>F/i001W>V<j00800005Ic]S6V<jHaYW>`02000EOol00`00
Oomoo`0EOol00`00Oomoo`06Ool002Moo`03001oogoo00Ioo`8004Ioo`07001>g4kmC]a>oDkLC_d0
1@0000Q:gDKMB]d003jn>Ydn_SZM1@000149^`gL0001NP5I0EX000EJ0005F@005IX0026j7ITQ^QfI
0080000E=OXaf@00>OPn6CWh?QTin3hI0016>DHHASU664HiAQP004iHDWU>F59i0080000?DWQFV@00
H]UNfF;iG]URf@00JaUW66/IIaP006lh00800008MgQcM`00LgMgV000MgMgEP9gM`0T001cEWMg001g
Mg=FMgMcE`00LeIgEg=G001c=`00KcQ_F@00KeU[>6mI001_FF/iKcU[>000HaX006<JIc]S6VLkHaYW
>`0067oo00<007ooOol057oo00<007ooOol01Woo000WOol00`00Oomoo`08Ool00`00Oomoo`14Ool0
0`00C]a>o@0300000dkmC]`00002B]d01DKMB]e:gD[M00000Sjm00<n_SZm00000RIM0P0000D9^`WK
0000005I008000031ET000Di00<000058IXMVB6I000]f@0200000c7I000in003?OT02cWh001664Hi
AQQ6>DHHASU66000CUP00P000eJI00eFN@00G]URfEkIH]T006/IIaU[6FLIJaT00003KcP30002MgL0
1@00MgMgMgMg00000WMg00]gE`00MeMgMgMG001cEgMGLeMgE`00009cE`03001_F@0000=_>@0>001[
>F/iJcU_>F/i001S6VLkHaYS>V<JIc/001Yoo`03001oogoo01Aoo`03001oogoo00Eoo`009goo00<0
07ooOol02Goo00<007ooOol0A7oo0P0001I>oDkLD_e>g4kmC]`004KMB]e6g4[MA]d003ZM?[hjWCjn
>Yd002Hm9UdR?@8000043M`000000ET400002PEI1CP001fI8KXMVB6j000]fBfi1@0000Lin3hI>OP0
04HHASU66005000065IhEYUBN5JIEWQFVE9h001NfF;I001[6FLHJaUW66/I001_F6lhLeU_>000LcMc
F080000UMeIgMgMg001cEWMgMeH007=FMgMcE`00LeIgEg=GMeL007MGLcMgEg<g001[>6mIJcP006/i
KcU[>6mIJcT006/h001S6VLkHaX00P006goo00<007ooOol057oo00<007ooOol01Goo000VOol2000<
Ool00`00Oomoo`14Ool02000C]a>oDkLC]e>g4km0003B]d00dKM0000000800000bIM9Sd000050002
0?L010001CT5>@Dh0P0000XQVQfI000]^BgI;KT]f@00?QTin@L00005BSQ:>DXi001FN@03EYT03EIi
EYUFVEJI001Rf@00JaUW6F/IIaU[6@0000E_>005001cF7=G001gE`0200001gMg001gMgMG001gEgMg
009gE`06001gEg=GMeMcE`000g=G00D007<g001_>@0000=[>@03KcU[>@0000=[>@03001S6P0001io
o`03001oogoo01=oo`03001oogoo00Eoo`00=Goo0P00AGoo0P0000=>oDkLD_d01P0000U6_4[MA]d0
03ZM?[hjWCjn>Yd01@0003h1NP00000160000?P0e`001CP5F@005GT0026j7IT002fi;MT]^@00>OPn
6CWh?QTin3hI001:FDXhBUU6>4YIBSP0059hEYUFN5JIDWQFVEIhEYT006/IIaQ[6FLHJaUW6000KcQc
FFlhKeP007=HLeMcF000MeMcEWMG0P0001agEWMg001gMg=GMgL007MGLeMgEg=F001c=gMGLcMgE`00
LeMc=`00JcU_>F/hKeU[>@00JcQ_>@9[>@03JcP007oo01moo`03001oogoo019oo`03001oogoo00Eo
o`00=goo00<007ooOol0A7oo0`0000Y>gDkLC_d004[MA]e:gDKMB]e6g@800005>[djWCZn>Yd00002
8Sd200021IX00`000?P000020?L040001CT5>@005GT0026J000]fBfi;MT]^@00?OTn6CWi0Sgi00X0
04XhBSU:>DYIBSQ:>@00EYUFN@=FV@0:EWT00000G]T006/IIaU[6FLI0004KcP02`00LeQcEg=G001g
Eg=GMeL007MGMeH00P0000UgMgMGMeL007MGLeMgEg=G000017=G00X007<gLcL007<g001[>FliJcT0
00E[>@03001oogoo021oo`03001oogoo015oo`03001oogoo00Eoo`00>7oo00<007ooOol0A7oo00H0
04kmC]a>oDkLC_d2000014KMB]e6_4[M1@0000Hn_P008SdN?28m7Q`200001@FK000160000?P00P00
00@5>0005EPEN@<0000a<MT]^BgI000n6CWh?QTin3hI>OP004HhBUU:>4YIASQ:F@00EYUBN5JIEWP0
05ZhG]UJ^EkI001[6FLH001_>7=IKcQ_F000LeQcEg=HLcL007=FMeMcEP00LeIgE`00MeL00P0001Ic
EP00LeMgEg=FMeL007MGLcMgE`00LeMc=g=H001cF6lg001[>@00JcQ_>@9[>@03JcP007oo029oo`03
001oogoo015oo`03001oogoo00Eoo`00>Goo00<007ooOol0A7oo00D004kmC]a>gDkL00H00096g@03
B]d003ZM00@0008R?@037Sd0000000@000030?L00000008000095ETENAEi000]^BgI;KT]f@00008m
n@06?QTinCgi001:FDXh0TXi00=:FDXh00000UJI00AFN@00G[UNf@=N^@04G]T006/I0004KcP01P00
LeMcEg=G001cE`9gE`05001gEWMFMeH00003MeH01P00LeMgEg=GMeL000AcE`04001c=g=G0004LcL0
0`00JcU[>@03JcT00`00Oomoo`0SOol00`00Oomoo`0@Ool00`00Oomoo`05Ool003Yoo`8004Eoo`@0
000>C]a>oDkL0016_D[MA[a:gDJmB]d003Zn=Ydj_PD000040EX1F@0009D300001P3G0?L001Ei5EPE
N@<0000@<MT]^@00>OPn6CWh?QTin3hI001:FDHhBUU:>4YIASP300006UZhG]UJ^EkIF[QNfEZiG]T0
07=IKcQ_F6lh001cEg=HLcMcF000MeMcEWMG001gEg=F0002MeH00g<f001c=P0200004GMGLeL007<g
MeMc=`00LcMcF7<g001_=g=HKcL006lg00000V/i00=[>000Ool09Woo00<007ooOol047oo00<007oo
Ool017oo000lOol00`00Oomoo`13Ool01`00C_e>g4kMC]a>oDkL00800005B]e6gDKMA]d00003>Yd0
13ZN000001XL0P000P5I00<0002e00000P0000P0e`3g000ENAEI5GT002Vi0P0000<]^@00>OT00Sgi
00Hn6CWi001:>DYIBSP2BST20002G[T01EkIG[UN^EjiG]T00Uji00<006Ki00000Vlh00H007=GLeMc
Eg=H0003MeL01@00MeIgEWMG00000gMF00@007MFMeIgEP8000=cE`05001c=g=GLcL00004LcL01P00
LcM_=`00JcT002Uoo`03001oogoo00moo`03001oogoo00Aoo`00?Goo00<007ooOol0@goo00L004km
C]a>oDkLC_e>g00>00001QhM0000005I0000U@8000070?L0e`00000ENAEH00000bVi1@0000Din3hI
>OP004Xh00<0000WCUUBN@00G]UJ^EkIF[QNfEZiG]T006KiH_QVn@00LeT007=HLcMcF7=G001cEWMG
LeH007=FMeL007MFLcIgE`00MeIc=WMFLcH007<f0080000?MeL007=HLcL006lgLeQ_=g=H001c>6lg
LcQ_=`0002Yoo`03001oogoo00moo`03001oogoo00Aoo`00?Woo00<007ooOol0@goo00<004kmC]`0
0`0000=>g4kM000014KM00H003JM=YdfWCJN=Yd:00001`3g0=L000005GTEF@0000@Y^@03000n6ChI
00D0009>N@05CUU>NDiiCWT00002G[T01UkIG[T00000I_UVn0=Vn@06001cEg=GLeQcE`000WMG00Ic
E`00MeIgEgMF0003MeH01`00MeIgEWLfMeH007MF009g=P05001cEg<gLcL00003LcL00`00LcM_=`02
LcL00`00Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`04Ool003moo`8004Aoo`80000;C]a>oDkL
C_e>g4km001:gDJlB]e6_@0200001cZN=YdjWSJM000Eo1HL00L000030?L000eI00<00005;MTY^BVi
:KT00002?QT063gi@QXn6@00CUUBNDiIDWU>FE9iCUT005ZhG]UJ^@00H_QVnF;hI_URn6Ki001_6080
000ULeMcF000MeMcEWMG001gEg=F001c=WMGMeH007<fMeIc=WMF001gEW<fMeH007MF001cE`00LeQ_
=g=HKcL006lgLcQ_=g<h0000;Goo00<007ooOol03Goo00<007ooOol017oo0011Ool00`00Oomoo`12
Ool02000C_e>g4kMC]a>oDkL0004A]d500000cJN000Eo0035O`60000103g000=>0Th0P0012Vi00<0
03hI?QT00chI00<004iICWT00Tii00I>FDiiCWT005ji0002I_T01FKhI_UVnFKi000016/H0P0000Eg
Eg=GMeL007MG009gEP07001gEWMFMeH007MFMcH00WMF00T007LfMcIg=P00LcH007<g00000g<g00<0
06lgLcL00W<g00<007ooOol0;7oo00<007ooOol03Goo00<007ooOol017oo0012Ool00`00Oomoo`12
Ool01@00C_e>g4kmC]`01P0000E6gDJmA]d003JN00@000035O`F71Gl00L000032CP=F@Th00800005
;MTY^BVi00126P02?QT06Sgi@QX0059iCUUBNDiIDWU>FE9iCUT006;hI_URn6KiH_QVnF;h001[66li
JaQ_6000LcP200001W=F001cEWMG001gE`9gEP0G001gEW<fMeIc=P00LcIgEW<f001c=WLfLcH006lg
LeQ_=`00KcMc>6lgLcP0000`Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool004=oo`03001oogoo049o
o`@00004C]a>gDkL0002A]d01DJmA]e6gDKM00000SJM00<fWP0000001`0000H0U@000009>0dh2CP3
0002:KT00`00?QTn6@03?QT00`00CWU>F@03CWT200000eJI001Vn003I_T00fKh001[6004JaP01@00
KcM_>6lg00000gMF00H007MFMeIgEP00McH2MeH01P00McIg=WLfMeH000=g=P<00003LcL007<g009c
=`03KcL007oo031oo`03001oogoo00aoo`03001oogoo00=oo`00A7oo0P00@goo00`004kmB]a>oDkL
C_e:g000A[e6gDJmA]d5000013JN000000gK1P0000P0UP003CT9>0eI000Y^RFi0`0000TmnD8J?QTn
6Cgi001>FE9iCUT00P0001AF^EJIF[YFV@00H_QVnF;h001[66liJaQ_66/H001_=g<hKaL007<g0`00
0WMF01Qc=P00LcIgEW<fMeH007MFLcIgEP00McIc=WMF001g=W<fMcH007<hKcMc>6lg000cOol00`00
Oomoo`0;Ool00`00Oomoo`03Ool004Ioo`03001oogoo045oo`800003C]a>gDkL00H00005A]e6_DKM
000bO@0400000`gL4O`0000400002@2E000000Th3CP002Vi9KTY^@040003?QT30006EYT01000I_UV
n0001F/H00H006lgKcQ_=flh0003LcL01@00MeIgEWMF00000gMF00H007LfMcIgEWLf0002McH01G<f
001c=WLfLcH00P0000=c=flg0000=7oo00<007ooOol02goo00<007ooOol00goo0017Ool00`00Oomo
o`12Ool300003dkLC_e:g000A[e6gD:mA]e6_DKM000fWS9m<YhbO@0200000a7l0000000400002`DG
0009>0009KTY^RFi:MX0048j@ST0100001]J^UJIE[UFVEZjEYUF^EJIF[X006Ki001_>F/HKaQ[6000
KcMc>6lGLcP007<gKcIcE`00McL00`0001IgEW<fMeIc=P00LcIgEW<f001c=WMFLcH007<fMcIc=P00
LaIg=`00LcP003Eoo`03001oogoo00Yoo`03001oogoo00=oo`00B7oo00<007ooOol0@Woo00H004kL
C]e>g4kMC]`200001DKMA[e6gDJm00000c9m00<bWS9m0000200000@560002CP0008Y^@099KTY^@00
@SY2>D8j@SU2>P0000UFV@03001[66/H00=[6006001_>6lgKcQ_=`000g<g00D007<fLcMc=P00009g
EP04McH007LfMeH2McH02P00McIc=WLf001g=W<fMcH007Lf0W<f00<007ooOol0=Goo00<007ooOol0
2Goo00<007ooOol00goo0019Ool00`00Oomoo`12Ool01@00B]a>oDkLC_d02P0000LbOC:N000=g0Vk
0000U@0400005PDH1AL00000:MXU^BVj9KT0048i@SY2>DHj@ST005JIF[YFVEJiEYUJ^UJI0P0001AN
fP00KaQ[66li001c>6lGLcQ_=`00KcIcEg<g001c=WMGLcH007<f0P00019gEP00MeIc=WMF001gEW<f
McH007LfLcIg=P00McMc=WLf000iOol00`00Oomoo`08Ool00`00Oomoo`03Ool004Yoo`8004=oo`@0
000:C]e>g4kM0016gD:mA]e6_@00;Wd4000010WK2K/0002e10000`DH00`002Vi:KTY^BFi0012>D8j
@SU2>T8i0005EYT00`00G]UNf@02G]T02@00JaP006lhKcM_>6lgKcP00003LcL02P00LcMc=W<g001g
=W<fMcH007MF0gLf00T007<fMcIg=P00LcIg=W<f00000g<f00<007ooOol0=goo00<007ooOol027oo
00<007ooOol00goo001<Ool00`00Oomoo`11Ool03000B]a>oD[LC_e:g4km0016gD:mA]e2_@800003
<Yh^OC9n008000032K/0002E00<000031?L560DG00<0000@9KTY^P00ASY2>D8j@SU6>T8i001FVEZj
EYT005jiG]X2G]T02Uji001[6000KaMc>6lgLcP007=G0W<g00X007MGLcIg=`00MeMc=WLf001g=P80
000>LcH007<fMcIc=WMF001g=W<f001c=WLfLaH003]oo`03001oogoo00Qoo`03001oogoo009oo`00
CGoo00<007ooOol0@Goo0P0000=>gDkLC]d02`0000<bO@0000001P000`DH00d002Fj000002Vi0012
>T8i@SY2>D8j001FV@020007G]T01`00KcM_>6lgKcQ_=`0000=c=`0<001c=W<gLcH007<fMcIc=P00
LcIg=W<f0P000gLf00D007LfLcIg=P00009c=P03McH007oo03]oo`03001oogoo00Moo`03001oogoo
009oo`00CWoo00<007ooOol0@Woo0`0000]>oD[LC_d004KM@[e6gT:mA]d002in00<000031K/00000
0080000803<000Cg1AP002WJ9KTYfPT00003G]UN^EkJ009Nf@0:G[UNfUkI001Rn000KcMc>6lG0002
LcL03flf001c=WLgLcH007<fMcIc=P00LcIg=W<eMcIc=P0200002WMFLcH007<fMcIc=P00LaIg=`00
?Goo00<007ooOol01goo00<007ooOol00Woo001?Ool20013Ool02000C]e>g4kMB]a>g@00A]d3@[d0
0dKM000^O@02;Wd200000`Fk0000000300021AP01`00:MXU^RWJ9KX004IJ009:FP04BWY6FTYJ0006
G]T01000I_UVnF;i0P0000=_>000LcL00W<g010007<gLcIc=`00McIc=WLf001g=W<fMcIc=P00LcIg
=P800008LcIg=W<f001c=WLfLcH003ioo`03001oogoo00Ioo`03001oogoo009oo`00DGoo00<007oo
Ool0@Goo00@004kmB]a>o@/00003;Wh0000000P0000<9KTYfRFi:MX004YjAUY:NTIJBWY6FP000UkI
02QN^EkJ000006;hI_URn6KiH_QVn@00LcM_=W=G001g=g<fMeL007LfLcIgE`00McIc=GLfLcIg=P00
McIc=GLf001g=W<fMcH007LgLcH0041oo`03001oogoo00Eoo`03001oogoo009oo`00DWoo00<007oo
Ool0@Goo0`002goo0`0000<5VP0000000P0000/0m`3h000002Fj:MXU^RWJ001:NTIJ009:FP03BWY6
FP00009Nf@05001VnFKiI_URn@03I_T00`00JaP00002LcL04`00LcIc=g<f001c=WLfLcH007<fMcIc
=WLf001g=W<fMcH007Lf00<00004McIc=W<f0011Ool00`00Oomoo`04Ool00`00Oomoo`02Ool005=o
o`03001oogoo041oo`03001oogoo00ioo`8000060IX000000000m`3h0P0001PU^BWJ9KT004IJBWY6
FTYjAUY:NP00G]X006KiH_QVnF;hI_URn6Ki001[6FKhJaT200006G<fMeMc=P00LcIgEg<f001c=GLf
LcIg=W<e001c=GLfLaD007<EMcIc5@00LcIg=P00049oo`03001oogoo00Aoo`03001oogoo009oo`00
E7oo0P00@7oo00<007ooOol047oo00@0006J00000080m`0:0?P00000000YfRFj001:FTYjAUX2BUX2
0003I_T01F;iI_UVnFKi00000V/H01U[6F/HJaP007<gLcIc=`00McIc=WLf001g=W<fMcIc=P00LcIg
=W<f001c=GLfLcIg=P0200000g<f001oo`12Ool00`00Oomoo`03Ool00`00Oomoo`02Ool005Ioo`03
001oogoo03eoo`03001oogoo015oo`D000040?L002WJ;O/300000dYjAUX00002000044jJDY/006Ki
H_QVnF;hI_T006/II_Q[6F/HJaT006lh0`0001EgEg<fMcH007LfLcIg=W<eMcH007LfLaEg=P00McIc
5GLf001g=W<E0000AGoo00<007ooOol00goo00<007ooOol00Goo001GOol00`00Oomoo`0lOol00`00
Oomoo`0COol400001@3g000YfRWj:MX00`0000=>VU:JCYX00TjJ00=BVP00I_T00VKi00@006/HJaQ[
6@9[6003001_>6/H009_600F001c=WLfLcH007<fMcIc=WLf001g=W<fMcH007LfLcIg=W<e001c=WLf
0015Ool00`00Oomoo`03Ool00`00Oomoo`01Ool005Qoo`03001oogoo03]oo`03001oogoo01Aoo`80
000O0=L0003g000YfRgk:MXYn`00DY]>VU:KCYYBVdjJDY/006Ki001[6FKhJaU[66/I001_>6/GKcQ[
5`00KaL00`00015c=WLfLcEg=W<f001c5GLfLcD007<EMcIc5@00LaEg=P0004Moo`03001oogoo009o
o`03001oogoo005oo`00FGoo0P00>goo00<007ooOol05Goo0P0000P0e`00000YnbWJ:OXYfP000djJ
00ABVTjJCYY>VP80009[6006JaU[66/H001_>6/H0VlH01M_>000KcM_5flh001g=W<fMcIc=P00LcIg
=W<f001c=WLfLcEg=P00McIc5@0004Qoo`05001oogooOol00003Ool005]oo`03001oogoo03Qoo`03
001oogoo01Ioo`80000<0=L0n000000YfRgk:MX004jJDY]>VU:K0P00029F^UKK001[6F/HJaUVn000
JaM_>6/GKcP007<hKaMc>000LcL007LfLcIg=P00McIc=GLf001g=W<EMcH007LfLaD004Yoo`04001o
ogoo0003Ool005aoo`03001oogoo03Moo`03001oogoo01Ioo`05000040000=L0m`0500001E:JCYX0
0000E]X00eJj00IFfP00JaQ[6000JaP2KaP01flhJaP006lGKcQ_5`00009c=`<0000<McIc=WLf001g
=W<eMcIc=P00LaEg=P00BWoo00@007ooOol000=oo`00GGoo00<007ooOol0=Woo00<007ooOol05goo
0`0000D0e`00;Q/b6bgk00<0000VE[YJfeJjE]]F^U[KE[X006Kh001[5flhJaM_>6/G001_5g<hKaL0
06lFLcM_5g<gKaH007<eMcIc5@00LaEg=W<E001c5GLfLaD004]oo`03001oo`0000=oo`00GWoo0P00
=Woo00<007ooOol067oo0`0000<0e`00;Q/00bhK00<005KJE[X00UJj00IFfUJjE[YF^P00JaP2KaP0
2VlhJaP006lGKcQ_5flg001c=flG0W<g00<007<F00000P0000Qc=GLfLcIg=P00McIc=P00CGoo00<0
07oo00000Woo001POol00`00Oomoo`0cOol00`00Oomoo`0IOol03`000=L00000<Q/^6c8K;O/b6`00
E]]F^U[KE[YFf`0200007E[J001[5flhJaM_>000LcQ_5g<h001c=flGLcM_5W<g001c=flFLcL007Lf
LaEg=P00McIc5GLf0000CWoo0P000Woo001QOol00`00Oomoo`0bOol00`00Oomoo`0IOol200000`3g
00000004;Q/00`00E[YFfP02E[X03`00G_YJfUkjG]X006/HKaP006lhKaM_=flG001_5`03LcL03P00
LcMc=g<g001c=P00McIc=@00LcIg=W<E001>Ool20002Ool0069oo`03001oogoo031oo`03001oogoo
01]oo`030000n03G00@00004<Q/]n`00E[X200006EkjF]YNnU[JG_YJfP00JaL006lGLcQ_5`00KaMc
=flFLcL007<gKaIc=flF001_5W<g00800004LaEg=W<E001?Ool20002Ool006=oo`80031oo`03001o
ogoo01aoo`8000040?L003Hk=S`400003ekJG_YJfUkjG]YNnU[JG_YNfP00KaM_=flGKcP00003LcL0
3flG001c=g<gLaH007<fLcMc5W<f001g=W<EMcH0001;Ool40004Ool006Eoo`03001oogoo02eoo`03
001oogoo01eoo`80000>0=L0038k=U`b>cIL<S/005[JG_YJfUkjF]YNnP80000DH_T006lGLcP007<g
KaIc=flG001_5W<gKaIc=`00LcMc5W<g001c=`<004Qoo`@000Qoo`00IWoo00<007ooOol0;7oo00<0
07ooOol07Goo00H0003g000003Hl=S/3=S`02000G_YNfUkjF]YNnP00HaX3H_X00`00KaL00002LcL0
2FlGLcL007<gLaIc=`00LcMc5P02LcH01@00LaIc=W<F0000A7oo100037oo001WOol00`00Oomoo`0[
Ool00`00Oomoo`0NOol09`000?L00000=U`b>cIL<S/fG000G_YJfUkj001S6V;iHaYNnF<JH_T006lF
LcM_5g<g001c=flFLcM_5P00LaIc=flF001c5W<gLaH00011Ool4000@Ool006Qoo`8002]oo`03001o
ogoo01moo`030000m`3g00<0008f?005001JfP00001S6P03H_X02V<JH_X006LI001_5g<g001c=g<F
0W<g00X007<FLcIc=W<g001c=W<FLcH003eoo`@001Aoo`00JWoo00<007ooOol0:7oo00<007ooOol0
87oo00D0003g0?P003il00@0000KG_US6V;iHaYNnF<JH_T006;iIaYW6@00KaH006lFLcM_5W<g001c
=flFLcL007<gLaIc=`0003Yoo`@001Qoo`00Jgoo00<007ooOol09goo00<007ooOol08Goo00T0003g
000jO3il>W`nO3Yl00000f;j00=S6P0000001FLI00<007<FLcL00W<g00X007<fLcIc=g<F001c5W<f
LaH003Ioo`@001aoo`00K7oo00<007ooOol09Woo00<007ooOol08Goo100000DjG3il>U`nO3YL0080
000:HaX006LJH_UW6VLIIaYRn@00IaT200002g<gKaH006lFLcMc5P00LaIc=g<F0000=7oo0`0087oo
001]Ool2000VOol00`00Oomoo`0ROol01`000AP003il>W`nO3Yl00@000IW6@05001W6F/IIaU[6@02
00002G<fLcMc5W<f001c=W<FLcH0000`Ool4000SOol006moo`03001oogoo02=oo`03001oogoo02=o
o`H0000I@Ya6_D:L@Yd006LJIaUW6V;i001W6F/IIaQ[>FLI001[6000LaIc=`00LcMc5W<g0000;Goo
10009goo001`Ool00`00Oomoo`0ROol00`00Oomoo`0TOol30007@Y`02P00IaUW6@00IaU[6FLIJaUW
6@000V/I00Q[6000LcH007<FLcIc5P00:Goo1000:goo001aOol00`00Oomoo`0QOol00`00Oomoo`0U
Ool300006DJm@Ya2WD:LA[e2W000H_T006LIJaUW66/iIaT006/HJcU[66/iJaP007<FLcMc5P0002Io
o`@002moo`00LWoo0P008Goo00<007ooOol09Goo100014:L0`0000IW6F/IIaU[6FLI0002JaT02F/H
JaU[6@00JaP007<FLcH0000ROol4000cOol007Aoo`03001oogoo01ioo`03001oogoo02Ioo`800003
0CT000000080000AA[a:gDJl001W66/iIaT006/HJcU[66/iJaP006/HKcU[6002000OOol4000gOol0
07Eoo`03001oogoo01eoo`03001oogoo02Moo`8000060CT004ZlB[a:_DJl0TZl00<006LI00000V/I
00A[66/IJaT000=[6003JcQ[600001]oo`@003]oo`00MWoo00<007ooOol077oo00<007ooOol0:7oo
100000E:gDJlB]e6_4[M0080000<JaQ[>F/HJcU[6000JaQ_>F/HKcU[60006Goo0`00?goo001gOol2
000LOol00`00Oomoo`0YOol01@000CT004JlB[`00`000TkL00<006/HJaT00V/I00H006/HJaQ[>6/H
000FOol40012Ool007Uoo`03001oogoo01Uoo`03001oogoo02Uoo`D0000@C]e>g4kMB]a>gDkL001[
66/i001_>F/HKcU[66li000BOol40016Ool007Yoo`03001oogoo01Qoo`03001oogoo02Yoo`@000I>
g003001[6@00009[6004JcQ[66/H000?Ool4001:Ool007]oo`03001oogoo01Moo`03001oogoo02]o
o`080001NP00001:g4kMC]a>g@<00006KcU[66liJaQ_>@0037oo1000CWoo001lOol00`00Oomoo`0F
Ool00`00Oomoo`0/Ool00`000GX1NP0400001E;lD]aBo000JcP00V/H00<007ooOol01goo1000DWoo
001mOol2000FOol00`00Oomoo`0]Ool20000205I001Bg5;mD]aBo5;LD_d200000f/H001oo`04Ool4
001FOol007moo`03001oogoo01=oo`03001oogoo02moo`040001NP00D]`3D_`015;LD_`000000Woo
1000FWoo0020Ool00`00Oomoo`0BOol00`00Oomoo`0`Ool200000e;lD]`00003000017oo00000000
GWoo0021Ool00`00Oomoo`0AOol00`00Oomoo`0bOol200000goo00000002001QOol0089oo`80015o
o`03001oogoo035oo`@006Eoo`00Q7oo00<007ooOol03Goo00<007ooOol0;Woo1000JGoo0025Ool0
0`00Oomoo`0<Ool00`00Oomoo`0ZOol4001]Ool008Ioo`03001oogoo00]oo`03001oogoo02Ioo`@0
075oo`00Qgoo0P002goo00<007ooOol08Woo1000MGoo0029Ool00`00Oomoo`08Ool00`00Oomoo`0N
Ool4001iOol008Yoo`03001oogoo00Moo`03001oogoo01]oo`<007eoo`00Rgoo00<007ooOol01Woo
00<007ooOol05goo1000P7oo002<Ool20006Ool00`00Oomoo`0COol40024Ool008ioo`03001oogoo
00=oo`03001oogoo00moo`@008Qoo`00Sgoo00<007ooOol00Woo00<007ooOol02goo1000S7oo002@
Ool01@00Oomoogoo00002Goo1000T7oo002AOol200000goo001oo`04Ool4002DOol009=oo`800003
Ool00000008009Qoo`00U7oo0P00W7oo003oOolcOol00?mooc=oo`00ogoo<goo003oOolcOol00?mo
oc=oo`00ogoo<goo003oOolcOol00?mooc=oo`00\
\>"],
  ImageRangeCache->{{{21.375, 305}, {232.5, 0}} -> {-0.170245, 0.00736887, \
0.00369768, 0.00369768}}]
}, Open  ]],

Cell[TextData[{
  "A quite different solution of the FP equation follows if we set ",
  StyleBox["k5",
    FontSlant->"Italic"],
  " = ",
  StyleBox["k6",
    FontSlant->"Italic"],
  " = 1",
  ". The rest of the group parameters are set to zero. The similarity \
variable for this subgroup is a combination of the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and the time \[Tau]. The infinitesimals are"
}], "Text",
  CellTags->"solution of the FP equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 0, 
          k5 \[Rule] 1, k6 \[Rule] 1, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{1\/2\ E\^\(2\ \[Tau]\)\ v, 1 + E\^\(2\ \[Tau]\)\/2}, {
        \(-\(1\/2\)\)\ E\^\(2\ \[Tau]\)\ P\ v\^2}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity reduction of the original equations displays that the \
similarity solution for ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " is given by a function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " which now has to satisfy a second-order equation:"
}], "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red3 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red3]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\@\(2 + E\^\(2\ \[Tau]\)\)\/v\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(E\^\(v\^2\/2\)\ P - F\_1 == 0\)},
          {
            \(\(-\[Zeta]\_1\)\ 
                \((2\ F1\_\(\[Zeta]\_1\) + 
                    2\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1\%2 + 
                    \[Zeta]\_1\%3\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The second-order ODE is identified by ",
  StyleBox["DSolve[]", "MmaText"],
  " as"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solr3\  = 
      DSolve[red3\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]
        \)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((C[2] - 1\/2\ \@\[Pi]\ C[1]\ Erfi[1\/#1]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result contains the special function ",
  StyleBox["Erfi[] ", "MmaText"],
  "which gives the imaginary error function erfi(z). In original variables, \
the result reads"
}], "Text",
  CellTags->"Erfi[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol3 = 
      Solve[red3\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr3, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] 
          1\/2\ E\^\(-\(v\^2\/2\)\)\ 
            \((2\ C[2] - \@\[Pi]\ C[1]\ Erfi[v\/\@\(2 + E\^\(2\ \[Tau]\)\)])
              \)}}\)], "Output"]
}, Open  ]],

Cell["\<\
The plot of this function demonstrates that the probability density \
is localized along a fixed axis parallel to the time axis. However, there are \
small variations in the velocity direction.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      \(P /. sol3\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          C[1] \[Rule] 1, C[2] \[Rule] 1/2}, {v, \(-3\), 5}, {\[Tau], \(-2\), 
        2}, AxesLabel \[Rule] {"\<v\>", "\<\[Tau]\>", "\<P\>"}, 
      PlotPoints \[Rule] 25]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.66533e-16 1.04977 -0.0679587 1.04977 [
[.10092 .21731 -12 -8.91782 ]
[.10092 .21731 0 .08218 ]
[.25429 .15697 -5.74307 -9 ]
[.25429 .15697 .25693 0 ]
[.41721 .09289 -5.43033 -9 ]
[.41721 .09289 .56967 0 ]
[.59061 .02474 -5.11759 -9 ]
[.59061 .02474 .88241 0 ]
[.29165 .07573 -10.2423 -15 ]
[.29165 .07573 .75771 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.01328 .333 -6 -2.79975 ]
[.01328 .333 0 6.20025 ]
[-0.00165 .42658 -18 -2.87931 ]
[-0.00165 .42658 0 6.12069 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.02556 .32837 m
.03169 .32605 L
s
[(0)] .01328 .333 1 -0.37783 Mshowa
.0107 .42213 m
.01687 .41991 L
s
[(0.5)] -0.00165 .42658 1 -0.36015 Mshowa
.125 Mabswid
.02265 .34668 m
.02634 .3453 L
s
.01972 .36521 m
.02341 .36385 L
s
.01674 .38396 m
.02044 .38261 L
s
.01374 .40293 m
.01744 .40159 L
s
.02842 .31026 m
.0321 .30886 L
s
.03126 .29236 m
.03494 .29095 L
s
.03407 .27466 m
.03774 .27324 L
s
.03684 .25717 m
.0405 .25573 L
s
.00762 .44156 m
.01133 .44024 L
s
.0045 .46122 m
.00821 .45991 L
s
.00135 .48112 m
.00507 .47982 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(P) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.605 .736 .937 r
.38987 .65604 .40289 .66751 .4246 .66367 .41167 .65229 Metetra
.538 .716 .955 r
.41167 .65229 .4246 .66367 .44646 .6622 .43362 .65107 Metetra
.403 .665 .966 r
.43362 .65107 .44646 .6622 .4685 .66433 .45574 .65363 Metetra
.175 .552 .93 r
.45574 .65363 .4685 .66433 .49079 .67087 .4781 .66071 Metetra
0 .402 .83 r
.4781 .66071 .49079 .67087 .51342 .68129 .50079 .67163 Metetra
0 .351 .784 r
.50079 .67163 .51342 .68129 .53646 .69309 .52391 .68365 Metetra
.051 .499 .89 r
.52391 .68365 .53646 .69309 .55991 .70194 .54746 .69216 Metetra
.454 .723 .983 r
.54746 .69216 .55991 .70194 .58364 .70316 .5713 .69241 Metetra
.713 .794 .915 r
.5713 .69241 .58364 .70316 .60744 .69401 .59522 .68185 Metetra
.804 .786 .836 r
.59522 .68185 .60744 .69401 .63111 .67521 .61903 .6616 Metetra
.829 .771 .798 r
.61903 .6616 .63111 .67521 .6546 .65061 .64269 .63592 Metetra
.825 .761 .791 r
.64269 .63592 .6546 .65061 .67802 .62514 .66627 .60996 Metetra
.804 .755 .807 r
.66627 .60996 .67802 .62514 .70153 .60263 .68996 .58749 Metetra
.771 .75 .834 r
.68996 .58749 .70153 .60263 .72529 .58474 .71392 .56997 Metetra
.732 .747 .863 r
.71392 .56997 .72529 .58474 .74941 .57123 .73823 .55689 Metetra
.698 .744 .887 r
.73823 .55689 .74941 .57123 .77387 .56085 .76287 .54688 Metetra
.675 .743 .902 r
.76287 .54688 .77387 .56085 .79865 .55228 .78783 .53852 Metetra
.664 .744 .91 r
.78783 .53852 .79865 .55228 .82371 .54456 .81306 .53086 Metetra
.66 .745 .914 r
.81306 .53086 .82371 .54456 .84901 .53712 .83853 .5234 Metetra
.659 .747 .915 r
.83853 .5234 .84901 .53712 .87454 .52972 .86423 .51593 Metetra
.659 .747 .915 r
.86423 .51593 .87454 .52972 .9003 .52229 .89015 .50839 Metetra
.659 .747 .916 r
.89015 .50839 .9003 .52229 .92629 .5148 .91631 .50077 Metetra
.659 .748 .916 r
.91631 .50077 .92629 .5148 .95251 .50723 .9427 .49308 Metetra
.659 .748 .916 r
.9427 .49308 .95251 .50723 .97896 .4996 .96933 .48532 Metetra
.6 .735 .939 r
.37664 .64443 .38987 .65604 .41167 .65229 .39854 .64082 Metetra
.526 .713 .958 r
.39854 .64082 .41167 .65229 .43362 .65107 .42057 .63991 Metetra
.376 .655 .966 r
.42057 .63991 .43362 .65107 .45574 .65363 .44276 .64297 Metetra
.128 .527 .916 r
.44276 .64297 .45574 .65363 .4781 .66071 .46519 .65069 Metetra
0 .369 .801 r
.46519 .65069 .4781 .66071 .50079 .67163 .48795 .6622 Metetra
0 .331 .761 r
.48795 .6622 .50079 .67163 .52391 .68365 .51115 .67445 Metetra
.051 .507 .89 r
.51115 .67445 .52391 .68365 .54746 .69216 .53479 .68256 Metetra
.484 .743 .985 r
.53479 .68256 .54746 .69216 .5713 .69241 .55874 .68169 Metetra
.734 .801 .905 r
.55874 .68169 .5713 .69241 .59522 .68185 .5828 .66949 Metetra
.814 .786 .827 r
.5828 .66949 .59522 .68185 .61903 .6616 .60677 .64758 Metetra
.832 .769 .791 r
.60677 .64758 .61903 .6616 .64269 .63592 .63058 .62067 Metetra
.825 .757 .788 r
.63058 .62067 .64269 .63592 .66627 .60996 .65434 .59415 Metetra
.801 .75 .805 r
.65434 .59415 .66627 .60996 .68996 .58749 .67822 .57175 Metetra
.765 .744 .834 r
.67822 .57175 .68996 .58749 .71392 .56997 .70236 .55466 Metetra
.724 .74 .864 r
.70236 .55466 .71392 .56997 .73823 .55689 .72686 .54212 Metetra
.69 .738 .888 r
.72686 .54212 .73823 .55689 .76287 .54688 .75169 .53254 Metetra
.669 .739 .902 r
.75169 .53254 .76287 .54688 .78783 .53852 .77683 .52445 Metetra
.66 .742 .91 r
.77683 .52445 .78783 .53852 .81306 .53086 .80223 .5169 Metetra
.658 .744 .914 r
.80223 .5169 .81306 .53086 .83853 .5234 .82787 .50944 Metetra
.658 .746 .915 r
.82787 .50944 .83853 .5234 .86423 .51593 .85374 .50189 Metetra
.658 .747 .915 r
.85374 .50189 .86423 .51593 .89015 .50839 .87983 .49425 Metetra
.659 .747 .916 r
.87983 .49425 .89015 .50839 .91631 .50077 .90616 .48652 Metetra
.659 .748 .916 r
.90616 .48652 .91631 .50077 .9427 .49308 .93273 .4787 Metetra
.659 .748 .916 r
.93273 .4787 .9427 .49308 .96933 .48532 .95954 .47081 Metetra
.593 .734 .942 r
.36321 .63268 .37664 .64443 .39854 .64082 .3852 .62926 Metetra
.511 .709 .961 r
.3852 .62926 .39854 .64082 .42057 .63991 .40731 .62874 Metetra
.343 .642 .964 r
.40731 .62874 .42057 .63991 .44276 .64297 .42957 .6324 Metetra
.071 .496 .896 r
.42957 .6324 .44276 .64297 .46519 .65069 .45205 .64086 Metetra
0 .33 .764 r
.45205 .64086 .46519 .65069 .48795 .6622 .47488 .65304 Metetra
0 .307 .733 r
.47488 .65304 .48795 .6622 .51115 .67445 .49815 .66554 Metetra
.054 .517 .892 r
.49815 .66554 .51115 .67445 .53479 .68256 .52189 .67317 Metetra
.518 .764 .986 r
.52189 .67317 .53479 .68256 .55874 .68169 .54598 .671 Metetra
.755 .807 .894 r
.54598 .671 .55874 .68169 .5828 .66949 .57019 .65694 Metetra
.824 .786 .817 r
.57019 .65694 .5828 .66949 .60677 .64758 .59431 .63313 Metetra
.837 .767 .785 r
.59431 .63313 .60677 .64758 .63058 .62067 .61829 .60483 Metetra
.825 .753 .784 r
.61829 .60483 .63058 .62067 .65434 .59415 .64222 .57767 Metetra
.797 .744 .804 r
.64222 .57767 .65434 .59415 .67822 .57175 .66628 .55533 Metetra
.757 .737 .834 r
.66628 .55533 .67822 .57175 .70236 .55466 .69061 .53875 Metetra
.715 .733 .865 r
.69061 .53875 .70236 .55466 .72686 .54212 .7153 .52685 Metetra
.681 .731 .888 r
.7153 .52685 .72686 .54212 .75169 .53254 .74032 .5178 Metetra
.662 .734 .903 r
.74032 .5178 .75169 .53254 .77683 .52445 .76565 .51006 Metetra
.656 .738 .91 r
.76565 .51006 .77683 .52445 .80223 .5169 .79123 .50267 Metetra
.656 .743 .914 r
.79123 .50267 .80223 .5169 .82787 .50944 .81704 .49522 Metetra
.657 .745 .915 r
.81704 .49522 .82787 .50944 .85374 .50189 .84308 .48762 Metetra
.658 .747 .916 r
.84308 .48762 .85374 .50189 .87983 .49425 .86934 .47987 Metetra
.658 .747 .916 r
.86934 .47987 .87983 .49425 .90616 .48652 .89585 .47202 Metetra
.659 .748 .916 r
.89585 .47202 .90616 .48652 .93273 .4787 .92259 .46408 Metetra
.659 .748 .916 r
.92259 .46408 .93273 .4787 .95954 .47081 .94958 .45605 Metetra
.585 .732 .945 r
.34957 .62083 .36321 .63268 .3852 .62926 .37164 .61765 Metetra
.491 .704 .964 r
.37164 .61765 .3852 .62926 .40731 .62874 .39383 .6176 Metetra
.301 .624 .96 r
.39383 .6176 .40731 .62874 .42957 .6324 .41615 .62197 Metetra
.004 .456 .867 r
.41615 .62197 .42957 .6324 .45205 .64086 .43869 .63129 Metetra
0 .285 .718 r
.43869 .63129 .45205 .64086 .47488 .65304 .46157 .64421 Metetra
0 .282 .701 r
.46157 .64421 .47488 .65304 .49815 .66554 .48491 .65696 Metetra
.06 .53 .894 r
.48491 .65696 .49815 .66554 .52189 .67317 .50876 .66402 Metetra
.555 .786 .985 r
.50876 .66402 .52189 .67317 .54598 .671 .53299 .66035 Metetra
.776 .812 .882 r
.53299 .66035 .54598 .671 .57019 .65694 .55736 .64418 Metetra
.834 .786 .806 r
.55736 .64418 .57019 .65694 .59431 .63313 .58166 .61824 Metetra
.841 .764 .777 r
.58166 .61824 .59431 .63313 .61829 .60483 .60581 .58835 Metetra
.826 .749 .78 r
.60581 .58835 .61829 .60483 .64222 .57767 .62991 .56047 Metetra
.793 .739 .802 r
.62991 .56047 .64222 .57767 .66628 .55533 .65415 .5382 Metetra
.749 .73 .834 r
.65415 .5382 .66628 .55533 .69061 .53875 .67867 .52219 Metetra
.704 .724 .865 r
.67867 .52219 .69061 .53875 .7153 .52685 .70355 .51102 Metetra
.671 .723 .889 r
.70355 .51102 .7153 .52685 .74032 .5178 .72876 .50262 Metetra
.654 .728 .903 r
.72876 .50262 .74032 .5178 .76565 .51006 .75427 .49531 Metetra
.651 .735 .911 r
.75427 .49531 .76565 .51006 .79123 .50267 .78003 .48813 Metetra
.653 .74 .914 r
.78003 .48813 .79123 .50267 .81704 .49522 .80602 .48074 Metetra
.656 .744 .915 r
.80602 .48074 .81704 .49522 .84308 .48762 .83223 .47309 Metetra
.657 .746 .916 r
.83223 .47309 .84308 .48762 .86934 .47987 .85868 .46525 Metetra
.658 .747 .916 r
.85868 .46525 .86934 .47987 .89585 .47202 .88536 .45728 Metetra
.659 .747 .916 r
.88536 .45728 .89585 .47202 .92259 .46408 .91228 .4492 Metetra
.659 .748 .916 r
.91228 .4492 .92259 .46408 .94958 .45605 .93945 .44104 Metetra
.574 .73 .948 r
.33571 .60888 .34957 .62083 .37164 .61765 .35786 .60603 Metetra
.466 .697 .968 r
.35786 .60603 .37164 .61765 .39383 .6176 .38012 .60655 Metetra
.248 .6 .952 r
.38012 .60655 .39383 .6176 .41615 .62197 .40249 .61175 Metetra
0 .407 .826 r
.40249 .61175 .41615 .62197 .43869 .63129 .42507 .62203 Metetra
0 .234 .663 r
.42507 .62203 .43869 .63129 .46157 .64421 .448 .63575 Metetra
0 .255 .667 r
.448 .63575 .46157 .64421 .48491 .65696 .47142 .64874 Metetra
.073 .548 .899 r
.47142 .64874 .48491 .65696 .50876 .66402 .49539 .6551 Metetra
.595 .807 .981 r
.49539 .6551 .50876 .66402 .53299 .66035 .51978 .64973 Metetra
.797 .816 .867 r
.51978 .64973 .53299 .66035 .55736 .64418 .54433 .63121 Metetra
.844 .785 .795 r
.54433 .63121 .55736 .64418 .58166 .61824 .56881 .60289 Metetra
.846 .762 .769 r
.56881 .60289 .58166 .61824 .60581 .58835 .59314 .57124 Metetra
.826 .746 .775 r
.59314 .57124 .60581 .58835 .62991 .56047 .61742 .54252 Metetra
.79 .733 .8 r
.61742 .54252 .62991 .56047 .65415 .5382 .64183 .52029 Metetra
.741 .722 .834 r
.64183 .52029 .65415 .5382 .67867 .52219 .66653 .5049 Metetra
.692 .714 .866 r
.66653 .5049 .67867 .52219 .70355 .51102 .69159 .49456 Metetra
.658 .713 .889 r
.69159 .49456 .70355 .51102 .72876 .50262 .717 .48692 Metetra
.644 .72 .903 r
.717 .48692 .72876 .50262 .75427 .49531 .7427 .48014 Metetra
.644 .729 .911 r
.7427 .48014 .75427 .49531 .78003 .48813 .76865 .47326 Metetra
.649 .738 .914 r
.76865 .47326 .78003 .48813 .80602 .48074 .79482 .46597 Metetra
.654 .743 .915 r
.79482 .46597 .80602 .48074 .83223 .47309 .82121 .4583 Metetra
.657 .746 .915 r
.82121 .4583 .83223 .47309 .85868 .46525 .84783 .45037 Metetra
.658 .747 .916 r
.84783 .45037 .85868 .46525 .88536 .45728 .87468 .44228 Metetra
.659 .747 .916 r
.87468 .44228 .88536 .45728 .91228 .4492 .90179 .43407 Metetra
.659 .748 .916 r
.90179 .43407 .91228 .4492 .93945 .44104 .92914 .42578 Metetra
.56 .728 .953 r
.32162 .59688 .33571 .60888 .35786 .60603 .34385 .59444 Metetra
.434 .687 .971 r
.34385 .59444 .35786 .60603 .38012 .60655 .36616 .59565 Metetra
.181 .568 .936 r
.36616 .59565 .38012 .60655 .40249 .61175 .38857 .60181 Metetra
0 .348 .772 r
.38857 .60181 .40249 .61175 .42507 .62203 .41118 .61314 Metetra
0 .181 .602 r
.41118 .61314 .42507 .62203 .448 .63575 .43416 .6277 Metetra
0 .231 .632 r
.43416 .6277 .448 .63575 .47142 .64874 .45767 .64087 Metetra
.095 .572 .907 r
.45767 .64087 .47142 .64874 .49539 .6551 .48176 .6464 Metetra
.637 .826 .973 r
.48176 .6464 .49539 .6551 .51978 .64973 .50632 .63913 Metetra
.816 .819 .852 r
.50632 .63913 .51978 .64973 .54433 .63121 .53108 .61802 Metetra
.854 .784 .783 r
.53108 .61802 .54433 .63121 .56881 .60289 .55576 .58711 Metetra
.851 .76 .761 r
.55576 .58711 .56881 .60289 .59314 .57124 .58029 .55351 Metetra
.828 .743 .77 r
.58029 .55351 .59314 .57124 .61742 .54252 .60474 .52382 Metetra
.786 .727 .798 r
.60474 .52382 .61742 .54252 .64183 .52029 .62932 .50158 Metetra
.732 .713 .833 r
.62932 .50158 .64183 .52029 .66653 .5049 .65419 .48683 Metetra
.678 .703 .865 r
.65419 .48683 .66653 .5049 .69159 .49456 .67944 .4774 Metetra
.644 .702 .889 r
.67944 .4774 .69159 .49456 .717 .48692 .70504 .47062 Metetra
.633 .711 .903 r
.70504 .47062 .717 .48692 .7427 .48014 .73093 .46449 Metetra
.637 .723 .91 r
.73093 .46449 .7427 .48014 .76865 .47326 .75706 .45799 Metetra
.645 .734 .914 r
.75706 .45799 .76865 .47326 .79482 .46597 .78342 .45087 Metetra
.652 .741 .915 r
.78342 .45087 .79482 .46597 .82121 .4583 .80999 .44322 Metetra
.656 .745 .915 r
.80999 .44322 .82121 .4583 .84783 .45037 .83679 .43522 Metetra
.658 .746 .916 r
.83679 .43522 .84783 .45037 .87468 .44228 .86383 .42702 Metetra
.658 .747 .916 r
.86383 .42702 .87468 .44228 .90179 .43407 .89112 .41868 Metetra
.659 .748 .916 r
.89112 .41868 .90179 .43407 .92914 .42578 .91866 .41024 Metetra
.541 .725 .959 r
.30729 .58489 .32162 .59688 .34385 .59444 .32959 .58298 Metetra
.392 .673 .972 r
.32959 .58298 .34385 .59444 .36616 .59565 .35194 .58501 Metetra
.1 .526 .91 r
.35194 .58501 .36616 .59565 .38857 .60181 .37438 .59223 Metetra
0 .282 .706 r
.37438 .59223 .38857 .60181 .41118 .61314 .39702 .60468 Metetra
.435 0 0 r
.39702 .60468 .41118 .61314 .43416 .6277 .42004 .62006 Metetra
.359 0 0 r
.42004 .62006 .43416 .6277 .45767 .64087 .44363 .63331 Metetra
.128 .602 .919 r
.44363 .63331 .45767 .64087 .48176 .6464 .46787 .63785 Metetra
.677 .841 .962 r
.46787 .63785 .48176 .6464 .50632 .63913 .49263 .62849 Metetra
.833 .819 .836 r
.49263 .62849 .50632 .63913 .53108 .61802 .5176 .60461 Metetra
.863 .783 .771 r
.5176 .60461 .53108 .61802 .55576 .58711 .54252 .57094 Metetra
.857 .758 .753 r
.54252 .57094 .55576 .58711 .58029 .55351 .56725 .53523 Metetra
.83 .74 .765 r
.56725 .53523 .58029 .55351 .60474 .52382 .59188 .50443 Metetra
.784 .723 .795 r
.59188 .50443 .60474 .52382 .62932 .50158 .61662 .48207 Metetra
.723 .705 .832 r
.61662 .48207 .62932 .50158 .65419 .48683 .64166 .46792 Metetra
.664 .691 .865 r
.64166 .46792 .65419 .48683 .67944 .4774 .66708 .45944 Metetra
.628 .689 .888 r
.66708 .45944 .67944 .4774 .70504 .47062 .69286 .45363 Metetra
.619 .699 .902 r
.69286 .45363 .70504 .47062 .73093 .46449 .71894 .44826 Metetra
.627 .715 .909 r
.71894 .44826 .73093 .46449 .75706 .45799 .74527 .44226 Metetra
.639 .728 .913 r
.74527 .44226 .75706 .45799 .78342 .45087 .77182 .43539 Metetra
.648 .738 .915 r
.77182 .43539 .78342 .45087 .80999 .44322 .79858 .42781 Metetra
.654 .743 .915 r
.79858 .42781 .80999 .44322 .83679 .43522 .82556 .41978 Metetra
.657 .746 .915 r
.82556 .41978 .83679 .43522 .86383 .42702 .85279 .41148 Metetra
.658 .747 .916 r
.85279 .41148 .86383 .42702 .89112 .41868 .88026 .40302 Metetra
.659 .747 .916 r
.88026 .40302 .89112 .41868 .91866 .41024 .90799 .39444 Metetra
.515 .72 .966 r
.29271 .573 .30729 .58489 .32959 .58298 .31506 .57174 Metetra
.337 .654 .97 r
.31506 .57174 .32959 .58298 .35194 .58501 .33745 .5747 Metetra
.005 .472 .869 r
.33745 .5747 .35194 .58501 .37438 .59223 .35991 .58307 Metetra
0 .213 .631 r
.35991 .58307 .37438 .59223 .39702 .60468 .38257 .59663 Metetra
.485 0 0 r
.38257 .59663 .39702 .60468 .42004 .62006 .40563 .61275 Metetra
.376 0 0 r
.40563 .61275 .42004 .62006 .44363 .63331 .42931 .62595 Metetra
.176 .638 .936 r
.42931 .62595 .44363 .63331 .46787 .63785 .4537 .62934 Metetra
.715 .851 .947 r
.4537 .62934 .46787 .63785 .49263 .62849 .47867 .61775 Metetra
.848 .818 .819 r
.47867 .61775 .49263 .62849 .5176 .60461 .5039 .59098 Metetra
.871 .781 .759 r
.5039 .59098 .5176 .60461 .54252 .57094 .52907 .55443 Metetra
.862 .757 .745 r
.52907 .55443 .54252 .57094 .56725 .53523 .55402 .51649 Metetra
.833 .739 .76 r
.55402 .51649 .56725 .53523 .59188 .50443 .57884 .48443 Metetra
.783 .72 .793 r
.57884 .48443 .59188 .50443 .61662 .48207 .60374 .46181 Metetra
.715 .697 .832 r
.60374 .46181 .61662 .48207 .64166 .46792 .62893 .44818 Metetra
.65 .679 .864 r
.62893 .44818 .64166 .46792 .66708 .45944 .65451 .44063 Metetra
.611 .674 .886 r
.65451 .44063 .66708 .45944 .69286 .45363 .68047 .43584 Metetra
.604 .686 .9 r
.68047 .43584 .69286 .45363 .71894 .44826 .70674 .43135 Metetra
.616 .704 .908 r
.70674 .43135 .71894 .44826 .74527 .44226 .73327 .42597 Metetra
.632 .721 .912 r
.73327 .42597 .74527 .44226 .77182 .43539 .76001 .41946 Metetra
.644 .733 .914 r
.76001 .41946 .77182 .43539 .79858 .42781 .78696 .41204 Metetra
.652 .741 .915 r
.78696 .41204 .79858 .42781 .82556 .41978 .81413 .40402 Metetra
.656 .745 .915 r
.81413 .40402 .82556 .41978 .85279 .41148 .84155 .39565 Metetra
.658 .746 .915 r
.84155 .39565 .85279 .41148 .88026 .40302 .86921 .38706 Metetra
.658 .747 .916 r
.86921 .38706 .88026 .40302 .90799 .39444 .89714 .37835 Metetra
.481 .714 .973 r
.27786 .56132 .29271 .573 .31506 .57174 .30025 .56084 Metetra
.267 .627 .961 r
.30025 .56084 .31506 .57174 .33745 .5747 .32266 .56483 Metetra
0 .408 .812 r
.32266 .56483 .33745 .5747 .35991 .58307 .34513 .57435 Metetra
.416 0 0 r
.34513 .57435 .35991 .58307 .38257 .59663 .3678 .58897 Metetra
.522 0 0 r
.3678 .58897 .38257 .59663 .40563 .61275 .39091 .60568 Metetra
.377 0 0 r
.39091 .60568 .40563 .61275 .42931 .62595 .41469 .61864 Metetra
.238 .679 .957 r
.41469 .61864 .42931 .62595 .4537 .62934 .43925 .6207 Metetra
.748 .855 .929 r
.43925 .6207 .4537 .62934 .47867 .61775 .46446 .60679 Metetra
.86 .815 .804 r
.46446 .60679 .47867 .61775 .5039 .59098 .48997 .57711 Metetra
.878 .78 .749 r
.48997 .57711 .5039 .59098 .52907 .55443 .51541 .53768 Metetra
.868 .757 .738 r
.51541 .53768 .52907 .55443 .55402 .51649 .5406 .49743 Metetra
.838 .739 .755 r
.5406 .49743 .55402 .51649 .57884 .48443 .56562 .46399 Metetra
.784 .718 .791 r
.56562 .46399 .57884 .48443 .60374 .46181 .59068 .44093 Metetra
.71 .692 .831 r
.59068 .44093 .60374 .46181 .62893 .44818 .61602 .42764 Metetra
.637 .668 .863 r
.61602 .42764 .62893 .44818 .65451 .44063 .64174 .42093 Metetra
.594 .659 .883 r
.64174 .42093 .65451 .44063 .68047 .43584 .66787 .41716 Metetra
.588 .67 .897 r
.66787 .41716 .68047 .43584 .70674 .43135 .69432 .41362 Metetra
.602 .691 .905 r
.69432 .41362 .70674 .43135 .73327 .42597 .72103 .40898 Metetra
.622 .711 .91 r
.72103 .40898 .73327 .42597 .76001 .41946 .74797 .40296 Metetra
.638 .727 .912 r
.74797 .40296 .76001 .41946 .78696 .41204 .77512 .3958 Metetra
.648 .737 .914 r
.77512 .3958 .78696 .41204 .81413 .40402 .8025 .38787 Metetra
.654 .742 .915 r
.8025 .38787 .81413 .40402 .84155 .39565 .83011 .37948 Metetra
.657 .745 .915 r
.83011 .37948 .84155 .39565 .86921 .38706 .85797 .3708 Metetra
.658 .747 .915 r
.85797 .3708 .86921 .38706 .89714 .37835 .88609 .36196 Metetra
.436 .705 .979 r
.26271 .54999 .27786 .56132 .30025 .56084 .28513 .55039 Metetra
.183 .591 .941 r
.28513 .55039 .30025 .56084 .32266 .56483 .30756 .55544 Metetra
0 .34 .744 r
.30756 .55544 .32266 .56483 .34513 .57435 .33004 .56605 Metetra
.474 0 0 r
.33004 .56605 .34513 .57435 .3678 .58897 .35272 .58155 Metetra
.543 0 0 r
.35272 .58155 .3678 .58897 .39091 .60568 .37588 .59863 Metetra
.361 0 0 r
.37588 .59863 .39091 .60568 .41469 .61864 .39977 .61114 Metetra
.311 .721 .977 r
.39977 .61114 .41469 .61864 .43925 .6207 .42451 .61177 Metetra
.774 .854 .91 r
.42451 .61177 .43925 .6207 .46446 .60679 .44998 .59553 Metetra
.869 .811 .789 r
.44998 .59553 .46446 .60679 .48997 .57711 .47579 .563 Metetra
.884 .778 .739 r
.47579 .563 .48997 .57711 .51541 .53768 .50154 .52077 Metetra
.874 .757 .731 r
.50154 .52077 .51541 .53768 .5406 .49743 .527 .47824 Metetra
.843 .741 .751 r
.527 .47824 .5406 .49743 .56562 .46399 .55222 .4433 Metetra
.787 .719 .789 r
.55222 .4433 .56562 .46399 .59068 .44093 .57745 .41962 Metetra
.707 .689 .831 r
.57745 .41962 .59068 .44093 .61602 .42764 .60291 .40644 Metetra
.626 .659 .862 r
.60291 .40644 .61602 .42764 .64174 .42093 .62877 .40038 Metetra
.578 .646 .881 r
.62877 .40038 .64174 .42093 .66787 .41716 .65504 .39753 Metetra
.571 .655 .893 r
.65504 .39753 .66787 .41716 .69432 .41362 .68166 .39496 Metetra
.588 .676 .901 r
.68166 .39496 .69432 .41362 .72103 .40898 .70857 .39115 Metetra
.611 .699 .906 r
.70857 .39115 .72103 .40898 .74797 .40296 .73571 .38575 Metetra
.63 .717 .91 r
.73571 .38575 .74797 .40296 .77512 .3958 .76306 .37898 Metetra
.643 .73 .912 r
.76306 .37898 .77512 .3958 .8025 .38787 .79064 .37125 Metetra
.651 .738 .913 r
.79064 .37125 .8025 .38787 .83011 .37948 .81845 .3629 Metetra
.655 .743 .914 r
.81845 .3629 .83011 .37948 .85797 .3708 .84651 .35419 Metetra
.657 .745 .915 r
.84651 .35419 .85797 .3708 .88609 .36196 .87484 .34525 Metetra
.38 .692 .981 r
.24724 .53914 .26271 .54999 .28513 .55039 .26969 .54045 Metetra
.093 .547 .909 r
.26969 .54045 .28513 .55039 .30756 .55544 .29212 .54649 Metetra
0 .28 .678 r
.29212 .54649 .30756 .55544 .33004 .56605 .31461 .55802 Metetra
.51 0 0 r
.31461 .55802 .33004 .56605 .35272 .58155 .33733 .57415 Metetra
.549 0 0 r
.33733 .57415 .35272 .58155 .37588 .59863 .36054 .59134 Metetra
.325 0 0 r
.36054 .59134 .37588 .59863 .39977 .61114 .38454 .60321 Metetra
.387 .756 .992 r
.38454 .60321 .39977 .61114 .42451 .61177 .40949 .60233 Metetra
.795 .848 .891 r
.40949 .60233 .42451 .61177 .44998 .59553 .43524 .58384 Metetra
.876 .806 .777 r
.43524 .58384 .44998 .59553 .47579 .563 .46137 .54865 Metetra
.889 .776 .731 r
.46137 .54865 .47579 .563 .50154 .52077 .48745 .50379 Metetra
.879 .758 .725 r
.48745 .50379 .50154 .52077 .527 .47824 .5132 .45906 Metetra
.849 .743 .747 r
.5132 .45906 .527 .47824 .55222 .4433 .53865 .42259 Metetra
.791 .723 .788 r
.53865 .42259 .55222 .4433 .57745 .41962 .56404 .3981 Metetra
.707 .69 .832 r
.56404 .3981 .57745 .41962 .60291 .40644 .58963 .38478 Metetra
.619 .654 .862 r
.58963 .38478 .60291 .40644 .62877 .40038 .61561 .37912 Metetra
.565 .635 .879 r
.61561 .37912 .62877 .40038 .65504 .39753 .64201 .377 Metetra
.555 .64 .889 r
.64201 .377 .65504 .39753 .68166 .39496 .66878 .3753 Metetra
.573 .661 .897 r
.66878 .3753 .68166 .39496 .70857 .39115 .69586 .37234 Metetra
.598 .685 .902 r
.69586 .37234 .70857 .39115 .73571 .38575 .7232 .36764 Metetra
.62 .705 .906 r
.7232 .36764 .73571 .38575 .76306 .37898 .75076 .36139 Metetra
.636 .721 .909 r
.75076 .36139 .76306 .37898 .79064 .37125 .77855 .35399 Metetra
.646 .732 .911 r
.77855 .35399 .79064 .37125 .81845 .3629 .80657 .34581 Metetra
.652 .739 .913 r
.80657 .34581 .81845 .3629 .84651 .35419 .83484 .33714 Metetra
.655 .743 .914 r
.83484 .33714 .84651 .35419 .87484 .34525 .86337 .32815 Metetra
.317 .673 .976 r
.23143 .5288 .24724 .53914 .26969 .54045 .2539 .53095 Metetra
.012 .502 .87 r
.2539 .53095 .26969 .54045 .29212 .54649 .27636 .53782 Metetra
0 .236 .628 r
.27636 .53782 .29212 .54649 .31461 .55802 .29887 .55002 Metetra
.526 0 0 r
.29887 .55002 .31461 .55802 .33733 .57415 .32161 .5665 Metetra
.538 0 0 r
.32161 .5665 .33733 .57415 .36054 .59134 .34489 .58355 Metetra
0 .301 .671 r
.34489 .58355 .36054 .59134 .38454 .60321 .36902 .59461 Metetra
.458 .781 .998 r
.36902 .59461 .38454 .60321 .40949 .60233 .39418 .59224 Metetra
.81 .84 .873 r
.39418 .59224 .40949 .60233 .43524 .58384 .42022 .57165 Metetra
.881 .801 .766 r
.42022 .57165 .43524 .58384 .46137 .54865 .4467 .53405 Metetra
.893 .775 .724 r
.4467 .53405 .46137 .54865 .48745 .50379 .47313 .48682 Metetra
.884 .76 .72 r
.47313 .48682 .48745 .50379 .5132 .45906 .49919 .44005 Metetra
.855 .747 .743 r
.49919 .44005 .5132 .45906 .53865 .42259 .52489 .40206 Metetra
.798 .728 .787 r
.52489 .40206 .53865 .42259 .56404 .3981 .55045 .37663 Metetra
.71 .694 .833 r
.55045 .37663 .56404 .3981 .58963 .38478 .57618 .36293 Metetra
.615 .653 .864 r
.57618 .36293 .58963 .38478 .61561 .37912 .60226 .35737 Metetra
.555 .628 .879 r
.60226 .35737 .61561 .37912 .64201 .377 .62877 .35572 Metetra
.542 .628 .887 r
.62877 .35572 .64201 .377 .66878 .3753 .65568 .3547 Metetra
.56 .646 .892 r
.65568 .3547 .66878 .3753 .69586 .37234 .68292 .3525 Metetra
.586 .67 .897 r
.68292 .3525 .69586 .37234 .7232 .36764 .71044 .34852 Metetra
.61 .691 .901 r
.71044 .34852 .7232 .36764 .75076 .36139 .7382 .34287 Metetra
.628 .709 .905 r
.7382 .34287 .75076 .36139 .77855 .35399 .7662 .33591 Metetra
.64 .722 .908 r
.7662 .33591 .77855 .35399 .80657 .34581 .79444 .32803 Metetra
.648 .731 .91 r
.79444 .32803 .80657 .34581 .83484 .33714 .82293 .31951 Metetra
.652 .738 .912 r
.82293 .31951 .83484 .33714 .86337 .32815 .85168 .31056 Metetra
.259 .653 .965 r
.21527 .51889 .23143 .5288 .2539 .53095 .23777 .52171 Metetra
0 .467 .837 r
.23777 .52171 .2539 .53095 .27636 .53782 .26026 .52916 Metetra
.357 0 0 r
.26026 .52916 .27636 .53782 .29887 .55002 .2828 .54174 Metetra
.522 0 0 r
.2828 .54174 .29887 .55002 .32161 .5665 .30559 .5583 Metetra
.513 0 0 r
.30559 .5583 .32161 .5665 .34489 .58355 .32894 .57498 Metetra
0 .358 .734 r
.32894 .57498 .34489 .58355 .36902 .59461 .35321 .58517 Metetra
.518 .794 .996 r
.35321 .58517 .36902 .59461 .39418 .59224 .37859 .58137 Metetra
.82 .831 .858 r
.37859 .58137 .39418 .59224 .42022 .57165 .40493 .5589 Metetra
.884 .796 .758 r
.40493 .5589 .42022 .57165 .4467 .53405 .43177 .51919 Metetra
.896 .774 .718 r
.43177 .51919 .4467 .53405 .47313 .48682 .45857 .46988 Metetra
.889 .761 .715 r
.45857 .46988 .47313 .48682 .49919 .44005 .48497 .42128 Metetra
.861 .751 .74 r
.48497 .42128 .49919 .44005 .52489 .40206 .51093 .38185 Metetra
.805 .735 .786 r
.51093 .38185 .52489 .40206 .55045 .37663 .53669 .35542 Metetra
.716 .702 .836 r
.53669 .35542 .55045 .37663 .57618 .36293 .56254 .34116 Metetra
.615 .657 .868 r
.56254 .34116 .57618 .36293 .60226 .35737 .58873 .33544 Metetra
.549 .626 .881 r
.58873 .33544 .60226 .35737 .62877 .35572 .61534 .33396 Metetra
.533 .622 .886 r
.61534 .33396 .62877 .35572 .65568 .3547 .64236 .33336 Metetra
.549 .636 .89 r
.64236 .33336 .65568 .3547 .68292 .3525 .66974 .33172 Metetra
.575 .657 .893 r
.66974 .33172 .68292 .3525 .71044 .34852 .69743 .32836 Metetra
.599 .678 .896 r
.69743 .32836 .71044 .34852 .7382 .34287 .72539 .32329 Metetra
.618 .696 .899 r
.72539 .32329 .7382 .34287 .7662 .33591 .75359 .31684 Metetra
.632 .71 .903 r
.75359 .31684 .7662 .33591 .79444 .32803 .78205 .30934 Metetra
.641 .721 .906 r
.78205 .30934 .79444 .32803 .82293 .31951 .81077 .30109 Metetra
.648 .73 .909 r
.81077 .30109 .82293 .31951 .85168 .31056 .83974 .29231 Metetra
.218 .636 .954 r
.19876 .50917 .21527 .51889 .23777 .52171 .22131 .51244 Metetra
0 .449 .82 r
.22131 .51244 .23777 .52171 .26026 .52916 .24384 .52019 Metetra
.356 0 0 r
.24384 .52019 .26026 .52916 .2828 .54174 .26643 .53288 Metetra
.503 0 0 r
.26643 .53288 .2828 .54174 .30559 .5583 .28928 .54929 Metetra
.475 0 0 r
.28928 .54929 .30559 .5583 .32894 .57498 .31271 .56548 Metetra
0 .414 .795 r
.31271 .56548 .32894 .57498 .35321 .58517 .33712 .57478 Metetra
.563 .798 .987 r
.33712 .57478 .35321 .58517 .37859 .58137 .36271 .56968 Metetra
.826 .823 .845 r
.36271 .56968 .37859 .58137 .40493 .5589 .38936 .54558 Metetra
.886 .792 .751 r
.38936 .54558 .40493 .5589 .43177 .51919 .41657 .50407 Metetra
.899 .773 .713 r
.41657 .50407 .43177 .51919 .45857 .46988 .44376 .45297 Metetra
.892 .763 .712 r
.44376 .45297 .45857 .46988 .48497 .42128 .47051 .40279 Metetra
.867 .756 .738 r
.47051 .40279 .48497 .42128 .51093 .38185 .49676 .36205 Metetra
.813 .742 .786 r
.49676 .36205 .51093 .38185 .53669 .35542 .52273 .33461 Metetra
.723 .711 .839 r
.52273 .33461 .53669 .35542 .56254 .34116 .54873 .31968 Metetra
.618 .665 .873 r
.54873 .31968 .56254 .34116 .58873 .33544 .57501 .31358 Metetra
.547 .629 .885 r
.57501 .31358 .58873 .33544 .61534 .33396 .60172 .31202 Metetra
.527 .62 .888 r
.60172 .31202 .61534 .33396 .64236 .33336 .62884 .31156 Metetra
.541 .631 .889 r
.62884 .31156 .64236 .33336 .66974 .33172 .65635 .31024 Metetra
.566 .648 .891 r
.65635 .31024 .66974 .33172 .69743 .32836 .68419 .3073 Metetra
.59 .667 .892 r
.68419 .3073 .69743 .32836 .72539 .32329 .71232 .30271 Metetra
.61 .683 .894 r
.71232 .30271 .72539 .32329 .75359 .31684 .74072 .29671 Metetra
.624 .697 .897 r
.74072 .29671 .75359 .31684 .78205 .30934 .76939 .28962 Metetra
.634 .709 .901 r
.76939 .28962 .78205 .30934 .81077 .30109 .79833 .28171 Metetra
.642 .719 .904 r
.79833 .28171 .81077 .30109 .83974 .29231 .82753 .27317 Metetra
.202 .628 .949 r
.18192 .49932 .19876 .50917 .22131 .51244 .20453 .50278 Metetra
0 .449 .824 r
.20453 .50278 .22131 .51244 .24384 .52019 .22713 .5106 Metetra
0 .231 .63 r
.22713 .5106 .24384 .52019 .26643 .53288 .24978 .5232 Metetra
.471 0 0 r
.24978 .5232 .26643 .53288 .28928 .54929 .27268 .5393 Metetra
.426 0 0 r
.27268 .5393 .28928 .54929 .31271 .56548 .2962 .55495 Metetra
0 .464 .846 r
.2962 .55495 .31271 .56548 .33712 .57478 .32074 .56342 Metetra
.596 .797 .976 r
.32074 .56342 .33712 .57478 .36271 .56968 .34655 .55718 Metetra
.83 .815 .835 r
.34655 .55718 .36271 .56968 .38936 .54558 .3735 .5317 Metetra
.887 .788 .746 r
.3735 .5317 .38936 .54558 .41657 .50407 .4011 .48867 Metetra
.901 .772 .71 r
.4011 .48867 .41657 .50407 .44376 .45297 .4287 .43608 Metetra
.896 .764 .709 r
.4287 .43608 .44376 .45297 .47051 .40279 .45582 .38453 Metetra
.872 .76 .736 r
.45582 .38453 .47051 .40279 .49676 .36205 .48237 .34263 Metetra
.82 .749 .786 r
.48237 .34263 .49676 .36205 .52273 .33461 .50856 .31426 Metetra
.73 .721 .842 r
.50856 .31426 .52273 .33461 .54873 .31968 .53471 .29862 Metetra
.623 .675 .878 r
.53471 .29862 .54873 .31968 .57501 .31358 .56111 .29203 Metetra
.547 .636 .891 r
.56111 .29203 .57501 .31358 .60172 .31202 .58791 .29018 Metetra
.524 .623 .892 r
.58791 .29018 .60172 .31202 .62884 .31156 .61513 .28963 Metetra
.536 .63 .892 r
.61513 .28963 .62884 .31156 .65635 .31024 .64275 .28838 Metetra
.56 .645 .891 r
.64275 .28838 .65635 .31024 .68419 .3073 .67073 .28563 Metetra
.584 .661 .891 r
.67073 .28563 .68419 .3073 .71232 .30271 .69901 .28131 Metetra
.602 .675 .891 r
.69901 .28131 .71232 .30271 .74072 .29671 .72759 .27564 Metetra
.617 .687 .893 r
.72759 .27564 .74072 .29671 .76939 .28962 .75646 .26889 Metetra
.627 .698 .896 r
.75646 .26889 .76939 .28962 .79833 .28171 .78561 .26129 Metetra
.636 .707 .899 r
.78561 .26129 .79833 .28171 .82753 .27317 .81504 .25302 Metetra
.208 .628 .951 r
.16477 .48902 .18192 .49932 .20453 .50278 .18747 .49248 Metetra
0 .462 .84 r
.18747 .49248 .20453 .50278 .22713 .5106 .21014 .50018 Metetra
0 .257 .667 r
.21014 .50018 .22713 .5106 .24978 .5232 .23285 .51255 Metetra
.43 0 0 r
.23285 .51255 .24978 .5232 .27268 .5393 .25582 .52828 Metetra
0 .18 .604 r
.25582 .52828 .27268 .5393 .2962 .55495 .27941 .54339 Metetra
.035 .502 .883 r
.27941 .54339 .2962 .55495 .32074 .56342 .30408 .55111 Metetra
.619 .793 .965 r
.30408 .55111 .32074 .56342 .34655 .55718 .3301 .54392 Metetra
.833 .808 .827 r
.3301 .54392 .34655 .55718 .3735 .5317 .35737 .51728 Metetra
.888 .785 .742 r
.35737 .51728 .3735 .5317 .4011 .48867 .38535 .473 Metetra
.902 .771 .707 r
.38535 .473 .4011 .48867 .4287 .43608 .41336 .41916 Metetra
.898 .765 .707 r
.41336 .41916 .4287 .43608 .45582 .38453 .44087 .36646 Metetra
.876 .763 .734 r
.44087 .36646 .45582 .38453 .48237 .34263 .46774 .32356 Metetra
.826 .756 .785 r
.46774 .32356 .48237 .34263 .50856 .31426 .49416 .29434 Metetra
.738 .731 .845 r
.49416 .29434 .50856 .31426 .53471 .29862 .52049 .27801 Metetra
.629 .686 .884 r
.52049 .27801 .53471 .29862 .56111 .29203 .54701 .27088 Metetra
.549 .645 .897 r
.54701 .27088 .56111 .29203 .58791 .29018 .57391 .26862 Metetra
.523 .63 .898 r
.57391 .26862 .58791 .29018 .61513 .28963 .60123 .26781 Metetra
.534 .634 .896 r
.60123 .26781 .61513 .28963 .64275 .28838 .62896 .26643 Metetra
.557 .646 .894 r
.62896 .26643 .64275 .28838 .67073 .28563 .65705 .26367 Metetra
.58 .659 .892 r
.65705 .26367 .67073 .28563 .69901 .28131 .68548 .25943 Metetra
.598 .671 .891 r
.68548 .25943 .69901 .28131 .72759 .27564 .71423 .2539 Metetra
.612 .681 .891 r
.71423 .2539 .72759 .27564 .75646 .26889 .74327 .24733 Metetra
.622 .69 .892 r
.74327 .24733 .75646 .26889 .78561 .26129 .77262 .23994 Metetra
.63 .698 .894 r
.77262 .23994 .78561 .26129 .81504 .25302 .80227 .23188 Metetra
.229 .632 .957 r
.14734 .47802 .16477 .48902 .18747 .49248 .17013 .48133 Metetra
0 .48 .862 r
.17013 .48133 .18747 .49248 .21014 .50018 .19288 .48883 Metetra
0 .287 .706 r
.19288 .48883 .21014 .50018 .23285 .51255 .21565 .50089 Metetra
0 .164 .595 r
.21565 .50089 .23285 .51255 .25582 .52828 .23867 .51625 Metetra
0 .217 .652 r
.23867 .51625 .25582 .52828 .27941 .54339 .26234 .53086 Metetra
.093 .53 .908 r
.26234 .53086 .27941 .54339 .30408 .55111 .28713 .53795 Metetra
.635 .788 .955 r
.28713 .53795 .30408 .55111 .3301 .54392 .31336 .52995 Metetra
.834 .803 .821 r
.31336 .52995 .3301 .54392 .35737 .51728 .34093 .50236 Metetra
.888 .783 .739 r
.34093 .50236 .35737 .51728 .38535 .473 .36931 .45704 Metetra
.903 .771 .705 r
.36931 .45704 .38535 .473 .41336 .41916 .39775 .40216 Metetra
.9 .766 .705 r
.39775 .40216 .41336 .41916 .44087 .36646 .42565 .34849 Metetra
.879 .766 .733 r
.42565 .34849 .44087 .36646 .46774 .32356 .45286 .30473 Metetra
.831 .761 .785 r
.45286 .30473 .46774 .32356 .49416 .29434 .47953 .27478 Metetra
.744 .739 .847 r
.47953 .27478 .49416 .29434 .52049 .27801 .50604 .2578 Metetra
.634 .696 .89 r
.50604 .2578 .52049 .27801 .54701 .27088 .53269 .25013 Metetra
.552 .655 .904 r
.53269 .25013 .54701 .27088 .57391 .26862 .5597 .24744 Metetra
.523 .638 .905 r
.5597 .24744 .57391 .26862 .60123 .26781 .58712 .24628 Metetra
.533 .641 .902 r
.58712 .24628 .60123 .26781 .62896 .26643 .61496 .24464 Metetra
.555 .651 .899 r
.61496 .24464 .62896 .26643 .65705 .26367 .64318 .2417 Metetra
.578 .662 .895 r
.64318 .2417 .65705 .26367 .68548 .25943 .67175 .23736 Metetra
.595 .671 .893 r
.67175 .23736 .68548 .25943 .71423 .2539 .70064 .23179 Metetra
.609 .679 .892 r
.70064 .23179 .71423 .2539 .74327 .24733 .72986 .22525 Metetra
.618 .686 .892 r
.72986 .22525 .74327 .24733 .77262 .23994 .75939 .21792 Metetra
.626 .693 .892 r
.75939 .21792 .77262 .23994 .80227 .23188 .78924 .20995 Metetra
.256 .637 .962 r
.12964 .46619 .14734 .47802 .17013 .48133 .15252 .46928 Metetra
.033 .497 .882 r
.15252 .46928 .17013 .48133 .19288 .48883 .17535 .47651 Metetra
0 .314 .741 r
.17535 .47651 .19288 .48883 .21565 .50089 .19818 .48828 Metetra
0 .193 .635 r
.19818 .48828 .21565 .50089 .23867 .51625 .22125 .50328 Metetra
0 .248 .691 r
.22125 .50328 .23867 .51625 .26234 .53086 .24498 .51746 Metetra
.137 .548 .923 r
.24498 .51746 .26234 .53086 .28713 .53795 .26988 .52401 Metetra
.646 .784 .947 r
.26988 .52401 .28713 .53795 .31336 .52995 .29631 .51535 Metetra
.835 .799 .816 r
.29631 .51535 .31336 .52995 .34093 .50236 .3242 .48697 Metetra
.889 .781 .736 r
.3242 .48697 .34093 .50236 .36931 .45704 .35298 .44078 Metetra
.904 .77 .704 r
.35298 .44078 .36931 .45704 .39775 .40216 .38185 .38503 Metetra
.901 .767 .704 r
.38185 .38503 .39775 .40216 .42565 .34849 .41017 .33055 Metetra
.882 .768 .732 r
.41017 .33055 .42565 .34849 .45286 .30473 .43771 .28605 Metetra
.836 .766 .785 r
.43771 .28605 .45286 .30473 .47953 .27478 .46465 .25545 Metetra
.75 .747 .849 r
.46465 .25545 .47953 .27478 .50604 .2578 .49135 .23791 Metetra
.639 .706 .895 r
.49135 .23791 .50604 .2578 .53269 .25013 .51814 .22974 Metetra
.555 .665 .91 r
.51814 .22974 .53269 .25013 .5597 .24744 .54526 .22661 Metetra
.525 .647 .912 r
.54526 .22661 .5597 .24744 .58712 .24628 .5728 .22506 Metetra
.533 .649 .909 r
.5728 .22506 .58712 .24628 .61496 .24464 .60076 .22309 Metetra
.555 .658 .905 r
.60076 .22309 .61496 .24464 .64318 .2417 .6291 .21988 Metetra
.577 .668 .9 r
.6291 .21988 .64318 .2417 .67175 .23736 .6578 .21533 Metetra
.594 .676 .897 r
.6578 .21533 .67175 .23736 .70064 .23179 .68685 .2096 Metetra
.607 .682 .895 r
.68685 .2096 .70064 .23179 .72986 .22525 .71623 .20294 Metetra
.617 .687 .893 r
.71623 .20294 .72986 .22525 .75939 .21792 .74594 .19553 Metetra
.624 .692 .893 r
.74594 .19553 .75939 .21792 .78924 .20995 .77597 .18752 Metetra
.281 .641 .966 r
.11167 .4535 .12964 .46619 .15252 .46928 .13465 .45634 Metetra
.069 .511 .898 r
.13465 .45634 .15252 .46928 .17535 .47651 .15755 .4633 Metetra
0 .337 .769 r
.15755 .4633 .17535 .47651 .19818 .48828 .18043 .47478 Metetra
0 .218 .668 r
.18043 .47478 .19818 .48828 .22125 .50328 .20354 .48946 Metetra
0 .272 .72 r
.20354 .48946 .22125 .50328 .24498 .51746 .22732 .50328 Metetra
.17 .561 .932 r
.22732 .50328 .24498 .51746 .26988 .52401 .25233 .5094 Metetra
.654 .78 .941 r
.25233 .5094 .26988 .52401 .29631 .51535 .27896 .50019 Metetra
.836 .796 .813 r
.27896 .50019 .29631 .51535 .3242 .48697 .30716 .47115 Metetra
.889 .78 .735 r
.30716 .47115 .3242 .48697 .35298 .44078 .33634 .42422 Metetra
.904 .77 .703 r
.33634 .42422 .35298 .44078 .38185 .38503 .36565 .36772 Metetra
.902 .768 .703 r
.36565 .36772 .38185 .38503 .41017 .33055 .39439 .31254 Metetra
.884 .77 .731 r
.39439 .31254 .41017 .33055 .43771 .28605 .4223 .26742 Metetra
.839 .77 .785 r
.4223 .26742 .43771 .28605 .46465 .25545 .44951 .23626 Metetra
.754 .753 .851 r
.44951 .23626 .46465 .25545 .49135 .23791 .4764 .21822 Metetra
.644 .714 .899 r
.4764 .21822 .49135 .23791 .51814 .22974 .50335 .2096 Metetra
.557 .674 .916 r
.50335 .2096 .51814 .22974 .54526 .22661 .5306 .20605 Metetra
.526 .656 .918 r
.5306 .20605 .54526 .22661 .5728 .22506 .55825 .20413 Metetra
.534 .657 .915 r
.55825 .20413 .5728 .22506 .60076 .22309 .58633 .20182 Metetra
.556 .666 .91 r
.58633 .20182 .60076 .22309 .6291 .21988 .6148 .19829 Metetra
.578 .675 .906 r
.6148 .19829 .6291 .21988 .6578 .21533 .64365 .19346 Metetra
.595 .682 .902 r
.64365 .19346 .6578 .21533 .68685 .2096 .67285 .18749 Metetra
.607 .687 .899 r
.67285 .18749 .68685 .2096 .71623 .20294 .70239 .18061 Metetra
.616 .691 .897 r
.70239 .18061 .71623 .20294 .74594 .19553 .73227 .17303 Metetra
.623 .695 .896 r
.73227 .17303 .74594 .19553 .77597 .18752 .76249 .16486 Metetra
.303 .643 .967 r
.09343 .43998 .11167 .4535 .13465 .45634 .11649 .44257 Metetra
.099 .522 .909 r
.11649 .44257 .13465 .45634 .15755 .4633 .13946 .44928 Metetra
0 .354 .79 r
.13946 .44928 .15755 .4633 .18043 .47478 .16239 .46049 Metetra
0 .237 .692 r
.16239 .46049 .18043 .47478 .20354 .48946 .18553 .4749 Metetra
0 .29 .741 r
.18553 .4749 .20354 .48946 .22732 .50328 .20936 .48843 Metetra
.194 .569 .938 r
.20936 .48843 .22732 .50328 .25233 .5094 .23446 .49418 Metetra
.659 .777 .936 r
.23446 .49418 .25233 .5094 .27896 .50019 .26128 .48451 Metetra
.836 .794 .811 r
.26128 .48451 .27896 .50019 .30716 .47115 .28979 .45491 Metetra
.889 .779 .734 r
.28979 .45491 .30716 .47115 .33634 .42422 .31939 .40735 Metetra
.905 .77 .702 r
.31939 .40735 .33634 .42422 .36565 .36772 .34915 .3502 Metetra
.903 .768 .702 r
.34915 .3502 .36565 .36772 .39439 .31254 .37833 .29441 Metetra
.885 .771 .731 r
.37833 .29441 .39439 .31254 .4223 .26742 .4066 .24874 Metetra
.841 .772 .785 r
.4066 .24874 .4223 .26742 .44951 .23626 .43409 .21709 Metetra
.758 .758 .852 r
.43409 .21709 .44951 .23626 .4764 .21822 .46119 .19862 Metetra
.647 .72 .902 r
.46119 .19862 .4764 .21822 .50335 .2096 .4883 .1896 Metetra
.56 .681 .92 r
.4883 .1896 .50335 .2096 .5306 .20605 .51567 .18568 Metetra
.527 .663 .922 r
.51567 .18568 .5306 .20605 .55825 .20413 .54345 .1834 Metetra
.535 .664 .92 r
.54345 .1834 .55825 .20413 .58633 .20182 .57166 .18074 Metetra
.557 .673 .916 r
.57166 .18074 .58633 .20182 .6148 .19829 .60028 .17689 Metetra
.578 .682 .911 r
.60028 .17689 .6148 .19829 .64365 .19346 .62927 .17175 Metetra
.595 .688 .907 r
.62927 .17175 .64365 .19346 .67285 .18749 .65863 .1655 Metetra
.608 .693 .904 r
.65863 .1655 .67285 .18749 .70239 .18061 .68834 .15836 Metetra
.617 .697 .901 r
.68834 .15836 .70239 .18061 .73227 .17303 .71839 .15053 Metetra
.623 .699 .899 r
.71839 .15053 .73227 .17303 .76249 .16486 .74879 .14214 Metetra
.32 .644 .967 r
.07491 .4257 .09343 .43998 .11649 .44257 .09806 .42806 Metetra
.123 .529 .916 r
.09806 .42806 .11649 .44257 .13946 .44928 .12109 .43453 Metetra
0 .367 .805 r
.12109 .43453 .13946 .44928 .16239 .46049 .14405 .44552 Metetra
0 .251 .71 r
.14405 .44552 .16239 .46049 .18553 .4749 .16721 .4597 Metetra
0 .303 .756 r
.16721 .4597 .18553 .4749 .20936 .48843 .19107 .47297 Metetra
.211 .575 .941 r
.19107 .47297 .20936 .48843 .23446 .49418 .21626 .47842 Metetra
.663 .775 .933 r
.21626 .47842 .23446 .49418 .26128 .48451 .24328 .46836 Metetra
.837 .792 .809 r
.24328 .46836 .26128 .48451 .28979 .45491 .2721 .43828 Metetra
.889 .778 .733 r
.2721 .43828 .28979 .45491 .31939 .40735 .30211 .39016 Metetra
.905 .77 .701 r
.30211 .39016 .31939 .40735 .34915 .3502 .33234 .33244 Metetra
.904 .769 .702 r
.33234 .33244 .34915 .3502 .37833 .29441 .36196 .27609 Metetra
.886 .772 .73 r
.36196 .27609 .37833 .29441 .4066 .24874 .39061 .22994 Metetra
.843 .774 .785 r
.39061 .22994 .4066 .24874 .43409 .21709 .41839 .19786 Metetra
.76 .761 .853 r
.41839 .19786 .43409 .21709 .46119 .19862 .44571 .179 Metetra
.65 .725 .904 r
.44571 .179 .46119 .19862 .4883 .1896 .47297 .16963 Metetra
.562 .686 .923 r
.47297 .16963 .4883 .1896 .51567 .18568 .50049 .16536 Metetra
.528 .669 .926 r
.50049 .16536 .51567 .18568 .54345 .1834 .5284 .16276 Metetra
.536 .671 .924 r
.5284 .16276 .54345 .1834 .57166 .18074 .55674 .15978 Metetra
.557 .679 .92 r
.55674 .15978 .57166 .18074 .60028 .17689 .5855 .15562 Metetra
.579 .688 .916 r
.5855 .15562 .60028 .17689 .62927 .17175 .61465 .15017 Metetra
.596 .695 .911 r
.61465 .15017 .62927 .17175 .65863 .1655 .64418 .14362 Metetra
.609 .699 .908 r
.64418 .14362 .65863 .1655 .68834 .15836 .67406 .1362 Metetra
.617 .702 .905 r
.67406 .1362 .68834 .15836 .71839 .15053 .70429 .12809 Metetra
.624 .705 .903 r
.70429 .12809 .71839 .15053 .74879 .14214 .73488 .11943 Metetra
.333 .645 .967 r
.05609 .41074 .07491 .4257 .09806 .42806 .07932 .41289 Metetra
.14 .534 .92 r
.07932 .41289 .09806 .42806 .12109 .43453 .1024 .41914 Metetra
0 .377 .816 r
.1024 .41914 .12109 .43453 .14405 .44552 .1254 .42993 Metetra
0 .262 .723 r
.1254 .42993 .14405 .44552 .16721 .4597 .14857 .44392 Metetra
0 .312 .767 r
.14857 .44392 .16721 .4597 .19107 .47297 .17245 .45698 Metetra
.223 .579 .943 r
.17245 .45698 .19107 .47297 .21626 .47842 .19773 .46217 Metetra
.665 .774 .93 r
.19773 .46217 .21626 .47842 .24328 .46836 .22493 .45178 Metetra
.837 .791 .807 r
.22493 .45178 .24328 .46836 .2721 .43828 .25407 .42126 Metetra
.889 .778 .732 r
.25407 .42126 .2721 .43828 .30211 .39016 .28451 .37264 Metetra
.905 .77 .701 r
.28451 .37264 .30211 .39016 .33234 .33244 .31521 .31439 Metetra
.904 .769 .701 r
.31521 .31439 .33234 .33244 .36196 .27609 .34528 .25755 Metetra
.887 .773 .73 r
.34528 .25755 .36196 .27609 .39061 .22994 .37431 .21095 Metetra
.844 .776 .785 r
.37431 .21095 .39061 .22994 .41839 .19786 .4024 .17849 Metetra
.762 .764 .854 r
.4024 .17849 .41839 .19786 .44571 .179 .42993 .15928 Metetra
.652 .729 .906 r
.42993 .15928 .44571 .179 .47297 .16963 .45737 .14959 Metetra
.563 .691 .926 r
.45737 .14959 .47297 .16963 .50049 .16536 .48502 .14502 Metetra
.529 .674 .929 r
.48502 .14502 .50049 .16536 .5284 .16276 .51307 .14211 Metetra
.536 .676 .928 r
.51307 .14211 .5284 .16276 .55674 .15978 .54156 .13884 Metetra
.558 .685 .924 r
.54156 .13884 .55674 .15978 .5855 .15562 .57047 .13438 Metetra
.58 .693 .919 r
.57047 .13438 .5855 .15562 .61465 .15017 .59978 .12863 Metetra
.597 .7 .915 r
.59978 .12863 .61465 .15017 .64418 .14362 .62947 .12178 Metetra
.61 .705 .912 r
.62947 .12178 .64418 .14362 .67406 .1362 .65953 .11407 Metetra
.618 .708 .909 r
.65953 .11407 .67406 .1362 .70429 .12809 .68995 .10567 Metetra
.625 .71 .907 r
.68995 .10567 .70429 .12809 .73488 .11943 .72074 .09674 Metetra
.343 .645 .966 r
.03697 .39519 .05609 .41074 .07932 .41289 .06026 .39713 Metetra
.153 .538 .923 r
.06026 .39713 .07932 .41289 .1024 .41914 .0834 .40319 Metetra
0 .383 .823 r
.0834 .40319 .1024 .41914 .1254 .42993 .10641 .4138 Metetra
0 .269 .732 r
.10641 .4138 .1254 .42993 .14857 .44392 .12959 .42762 Metetra
0 .319 .775 r
.12959 .42762 .14857 .44392 .17245 .45698 .15349 .44051 Metetra
.232 .581 .944 r
.15349 .44051 .17245 .45698 .19773 .46217 .17884 .44547 Metetra
.667 .772 .928 r
.17884 .44547 .19773 .46217 .22493 .45178 .20623 .43478 Metetra
.837 .79 .807 r
.20623 .43478 .22493 .45178 .25407 .42126 .23569 .40387 Metetra
.889 .777 .732 r
.23569 .40387 .25407 .42126 .28451 .37264 .26656 .35478 Metetra
.905 .77 .701 r
.26656 .35478 .28451 .37264 .31521 .31439 .29775 .29604 Metetra
.905 .769 .701 r
.29775 .29604 .31521 .31439 .34528 .25755 .32829 .23875 Metetra
.888 .774 .73 r
.32829 .23875 .34528 .25755 .37431 .21095 .35771 .19174 Metetra
.845 .777 .785 r
.35771 .19174 .37431 .21095 .4024 .17849 .3861 .15892 Metetra
.764 .766 .854 r
.3861 .15892 .4024 .17849 .42993 .15928 .41386 .13939 Metetra
.653 .732 .907 r
.41386 .13939 .42993 .15928 .45737 .14959 .44147 .1294 Metetra
.564 .694 .928 r
.44147 .1294 .45737 .14959 .48502 .14502 .46927 .12455 Metetra
.53 .677 .932 r
.46927 .12455 .48502 .14502 .51307 .14211 .49746 .12137 Metetra
.537 .679 .93 r
.49746 .12137 .51307 .14211 .54156 .13884 .52609 .11781 Metetra
.559 .689 .926 r
.52609 .11781 .54156 .13884 .57047 .13438 .55516 .11307 Metetra
.581 .698 .922 r
.55516 .11307 .57047 .13438 .59978 .12863 .58464 .10704 Metetra
.598 .705 .918 r
.58464 .10704 .59978 .12863 .62947 .12178 .61451 .0999 Metetra
.61 .71 .915 r
.61451 .0999 .62947 .12178 .65953 .11407 .64475 .0919 Metetra
.619 .713 .913 r
.64475 .0919 .65953 .11407 .68995 .10567 .67537 .08322 Metetra
.626 .715 .911 r
.67537 .08322 .68995 .10567 .72074 .09674 .70635 .07399 Metetra
.35 .645 .965 r
.01752 .37909 .03697 .39519 .06026 .39713 .04088 .38084 Metetra
.163 .54 .925 r
.04088 .38084 .06026 .39713 .0834 .40319 .06405 .38673 Metetra
0 .388 .828 r
.06405 .38673 .0834 .40319 .10641 .4138 .08708 .39718 Metetra
0 .274 .738 r
.08708 .39718 .10641 .4138 .12959 .42762 .11025 .41085 Metetra
0 .324 .78 r
.11025 .41085 .12959 .42762 .15349 .44051 .13416 .42358 Metetra
.238 .583 .945 r
.13416 .42358 .15349 .44051 .17884 .44547 .15959 .42835 Metetra
.668 .772 .927 r
.15959 .42835 .17884 .44547 .20623 .43478 .18717 .41738 Metetra
.837 .789 .806 r
.18717 .41738 .20623 .43478 .23569 .40387 .21695 .3861 Metetra
.889 .777 .731 r
.21695 .3861 .23569 .40387 .26656 .35478 .24826 .33657 Metetra
.905 .77 .7 r
.24826 .33657 .26656 .35478 .29775 .29604 .27995 .27738 Metetra
.905 .769 .701 r
.27995 .27738 .29775 .29604 .32829 .23875 .31097 .21964 Metetra
.888 .774 .73 r
.31097 .21964 .32829 .23875 .35771 .19174 .3408 .17225 Metetra
.846 .778 .785 r
.3408 .17225 .35771 .19174 .3861 .15892 .3695 .13909 Metetra
.765 .767 .855 r
.3695 .13909 .3861 .15892 .41386 .13939 .39749 .11927 Metetra
.654 .734 .908 r
.39749 .11927 .41386 .13939 .44147 .1294 .42526 .10901 Metetra
.565 .697 .929 r
.42526 .10901 .44147 .1294 .46927 .12455 .45321 .10389 Metetra
.531 .68 .933 r
.45321 .10389 .46927 .12455 .49746 .12137 .48154 .10044 Metetra
.538 .682 .932 r
.48154 .10044 .49746 .12137 .52609 .11781 .51033 .09662 Metetra
.56 .692 .929 r
.51033 .09662 .52609 .11781 .55516 .11307 .53956 .09161 Metetra
.582 .701 .924 r
.53956 .09161 .55516 .11307 .58464 .10704 .56921 .08531 Metetra
.599 .708 .921 r
.56921 .08531 .58464 .10704 .61451 .0999 .59926 .07789 Metetra
.611 .713 .918 r
.59926 .07789 .61451 .0999 .64475 .0919 .6297 .06961 Metetra
.62 .717 .915 r
.6297 .06961 .64475 .0919 .67537 .08322 .66051 .06064 Metetra
.626 .719 .913 r
.66051 .06064 .67537 .08322 .70635 .07399 .6917 .05113 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.563},
  ImageMargins->{{Inherited, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jA000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00=Ioo`@004Io
o`00eWoo00<007ooOol0Agoo003GOol00`00Oomoo`16Ool00=1oo`@000Aoo`03001oogoo04Eoo`00
/7oo0`008goo00@007ooOol004Ioo`00/Goo00<007ooOol08goo0P00Agoo002^Ool5000HOol2001C
Ool00:ioo`04001oogoo000GOol5001BOol00:moo`03001oo`0001Aoo`<000=oo`80059oo`00/7oo
0P004Woo0P001Woo00<007oo0000DGoo0031Ool30008Ool01000Oomoo`00D7oo002nOol3000;Ool0
1000Oomoo`00D7oo002lOol2000>Ool01@00Oomoogoo0000Cgoo002iOol3000@Ool00`00Oomoo`03
001>Ool00;Moo`8001Aoo`05001oogooOol0001>Ool00;Aoo`<001Ioo`03001oogoo009oo`03001o
ogoo04]oo`00GWoo0P00DWoo0P0000=oo`00Ool05Woo00<007ooOol00goo00<007ooOol0BWoo001N
Ool2001?Ool30003Ool00`00Oomoo`0EOol00`00Oomoo`03Ool00`00Oomoo`1:Ool005eoo`04001o
ogoo001<Ool2000NOol00`00Oomoo`04Ool00`00Oomoo`19Ool005aoo`80009oo`8004Qoo`<001mo
o`8000Ioo`03001oogoo04Uoo`00Ygoo0`007goo0`0000=>g@0000001Goo0P00BWoo002UOol20002
Ool00`00Oomoo`0JOol30004C]`20007Ool00`00Oomoo`17Ool0081oo`@001ioo`<001ioo`<00005
C]e>g4kLC]a>g@02C]`00`00C]d00006Ool00`00Oomoo`17Ool0081oo`03001oogoo01eoo`8001eo
o`@0009>g003001>g4kL00E>g003001>g00000Moo`03001oogoo04Ioo`00PGoo00<007ooOol06Goo
0`006goo100000M:_4kMB]a>gDZlC]d00002C]`01TkMC]a>g4kLC]d0009>g003001oogoo00Eoo`03
001oogoo04Eoo`00PWoo00<007ooOol05Woo0P0000=oo`00Ool05goo100000=>gD[L000024kL00<0
04kLC]`014kL00@004kL000000Moo`03001oogoo04Eoo`00P7oo00@007ooOol001Aoo`<001Qoo`@0
000AB[a>gDZlC]e:_4kM001>gD[LC]e:_4kMB]a>gDZlC]d00002C]`00dkMC]a>g0020002C]`00`00
Oomoo`04Ool20016Ool0085oo`8001=oo`8001Moo`@0009:g00:001:g4kLB]a>gD[LC]a:g4kM0008
C]`00`00C]a>g0040003C]`00`00Oomoo`06Ool00`00Oomoo`13Ool009=oo`<001Ioo`<0000HB[a>
gDZlB]e:_4kM001>gDZlC]e:_4kMB[a>gDZlC]d004kMB]a>gDZlC]e:g4kM0`0000U>g4jlC]d004kL
C[a>gDkL00001goo00<007ooOol0@goo002AOol3000DOol400001DJlB[d004[MB[`00T[L00e:gDZl
B]`004kMB]a>g4[LC]e:g4kLB]`00003C]`40002C]`01@00C]a>g4kL00001DkL00<007ooOol01Goo
00<007ooOol0@Woo002>Ool3000AOol600005d[MA[a:gDJlB]e6_000B[a:gDZlC]e:_4[MB[a>g@00
C]e:_4kMB[a>gDZlC]d0100000Q:_4kLB[a>gDZlC]`004kM0TkL00M>_000C]a>g4jlC]d00008Ool0
0`00Oomoo`11Ool008]oo`<000aoo`P0000AA[a6_DJmA[d004ZmA[a:gDJlB[e6_4[MA[`004[LB]e:
_002B]`01T[MB[`004[LC]e:g0@00003C]a:g00000Q>g005001>g4kLC]`00004C]`20007Ool00`00
Oomoo`11Ool008Uoo`8000Qoo`L0000M@[e2W4Jm@Y`004:lA]e6_4Jm@[a6gDJlA[d004[MA[a:gDJl
B]e6_4[MA[`004ZlB]e:_4kMB[a:g@0400005TZlC]e:_4kMB[a>g@00C]a:_4kMB[a>g4ZlC]e:_4kL
001>gDkL001>_4kM0P0000=:_4kL00001goo00<007ooOol0@7oo0026Ool30002Ool80004@[d00`00
@[e2_@04@[d00`00A[e6_003A[d03DJlA[e6_@00A[a:_DJlB]e6_4ZmA[a:g@00009:g0@0000<B]e:
_000B]a>g4ZlC]a:g4kLB[a>g00024kL00<004kLC]`00`000dkL00=>_000Ool01Goo00<007oo0000
3Goo1@00;goo0024Ool700008dJlA]e6_4KM0012_CjL@[e2W4:m?Ya2_@00@[e2W4Jm@Ya2_D:LA[d0
04Jm@[a6gDJlA[e2_4KMA[`004JlB]e6_4[MA[`01@0001Q:_4[MB[a>gDZlB]d004kMB[a>gDZlC]e:
_4kMB[a>g@00C]a:_4kMB[a>g4ZlC]d4000024jlC]a:_4kLC[a>g4Zl0007Ool00`00Oomoo`0=Ool0
0`00Oomoo`0_Ool0085oo`D0009Bg0030016_DJl00=6_@03A[a6_@0000M2_@030012_D:m00E2_@03
0016_DJl00=6_@03A[a6_@0000D0000FA[a:_DJlB[d004[LB[a:gDZlB]a:_4[M001>g4[LC]a:_4kL
B]a>g4Zl0003C]`40002C]`20003C]`01TjlC]a>g4kLC[`000Moo`03001oogoo00aoo`03001oogoo
02moo`00Ogoo0P0002=oo`00001Bo5;LD_a>g000A[a6gDJlA]e6_4KMA[`004:L@[dnW4:m@Ya2_CjL
@[d004:m@Ya6_D:L@[e2W000A[a6_D:l00@0000KA[e6_000A[a:gDJlB]e6_4[MA[`004ZlC]e:_4[M
B[a>gDZlB]d004kMB[a>gDZlC]e:_4kM00@0000AB[a>g4ZlC]a:_4kLB[`004ZlC]a>_4kLB[a>g4jl
C]`00008Ool00`00Oomoo`03Ool40004Ool00`00Oomoo`0_Ool007aoo`<00005Ool00000D]aBo003
D]`00e;lD]`00002A[d01TJlA[e6_DJmA[`000M2_@030012_D:m0092_@H0000KA[a6_DJmA[e6_4Jm
001:_DJlB[e6_4ZmA[a:_DJl001:_4[LB[a:gDZlB]a:_000B[a>g4[L00@00003C]a:_000009>g009
C[a>g4kLC]a>_4kL001>g4jl00=>g003C[a>g4kL008000Moo`03001oogoo00]oo`03001oogoo02mo
o`00NWoo0P0001Eoo`00000006<K001Bo5;LD_a>g5;lD]aBo4kL0016_4KMA[a6gDJlA]d03@0001e6
_D:L@[e2W000A[a6_D:lA[e6_4Jm@[a6_@00B]e6_4[MA[a:gDJlB]e6_000B[a>gDZlB]e:_4kM00@0
000?B[a>g4ZlC]e:_4kL001>g4ZlC]a:_4kLB[a>g4Zl00800003C]a:_4kL00@00003C[a>g00000Mo
o`03001oogoo00Uoo`80035oo`00Egoo0P007Woo0`000goo00H005kjGaYNnV<J0002D]`01U;lD]aB
g5;LD_`00096_@@00003A[e6_0000092_@06@Ye2_D:m@[e2W@000T:m00I2WD:m@[e2_D:M0002A[d0
4DJlA[e6_DJmA[a6_@00B[e6_4ZmA[a:_DJlB[d004[MB[`010000TZl00X004ZlC]a:_4kLB[a>g4Zl
C]`000=>g004C[a>g4kLC]`500001dkLC[a>g4jlC]a>_00000Ioo`<003eoo`00EWoo00@007ooOol0
01Yoo`<000Aoo`80000=G_YS6ekjHa]NnP00C]aBo5;LD_a>g5;lD]`00`0002E6_4JmA[a6gDJlA[e6
_000@Ya2_CjL@[e2W4:m?Y`004:L@[e2W4Jm@Ya2_@00A[e6_4Jm@[a6_DJlA[e2_000A[a:gDJlB]e6
_00500005TZlB]e:_4[MB[a:gDZl001:_4kMB[a>g4ZlC]e:_4kL001>g4ZlC]a:_4kL0P0000a:^dkL
001>g4ZkC]a>_4kLB[]>g4jl0007Ool00`00Oomoo`0kOol005Ioo`04001oogoo000GOol30005Ool2
00002F<JG_YO6UkjHaYNnUlJG_X00002D]`400000e;LD_`00003A[d01TJlA[e6_DJmA[`00092_@05
@Ye2_D:m@[d00003@[d01D:M@[e2_D:m00000dJm00=6_4Jm00001`0000I6_4ZmA[a:_000B]`3B[`0
3d[LB[a:_000C]a:_4kLB[a>g4ZlC]a:_000C[a>g00300003djl001>g4Zl001>_4kLC[a>g4jlC]a>
_4kLC[`00007Ool00`00Oomoo`0jOol005Ioo`04001oogoo000EOol40005Ool03000G_YS6ekjHa]N
nV<KG_YS6ekjHa]NnP80000LD_aBg5;lC]aBo5;LD_`004KMA[a6_DJlA]e6_4Jm0012_D:L@[dnW4:m
@Ya2_@00A[e2W4:m@Y`800006dJm@[a6_D:L0016_4ZmA[a:gDJlB[e6_000B[a:gDZlB]e:_4[MB[a:
g@00C]a:_4kMB[a>g00500004TkLB[a>g4Zk001:_4kLB[/004jlC]a:^dkLC[a>g4ZkC]`000Moo`03
001oogoo03Yoo`00EWoo00@007ooOol001=oo`8000Qoo`0;001[6000G_YO6UkjHaYNnUlJG_YS6P02
00000ekj001Bg002D]`01U;lD]aBg5;L0016_0=6_@05A[a6_DJmA[d00003@[d00d:M000000050000
64:L@[e2_D:m0016_DJlA[e6_4JmA[a6_@00B[a6_4ZmA[a:_4JlB[e6_000B[a:g0=:_003B]a:_000
00D00006C[a:_4ZlB[`004Zl0Tjl00i>g000C[a>_4kLB[`004jlC]a>_4kLC[a>g4jl0P001goo00<0
07ooOol0>Goo001GOol2000AOol30009Ool07P00J_Q[66/H001NnV<KG_YS6ekjHa/006<KG_YS6`00
D_a>g5;lD]aBo4kLD_aBg000A[a6gDJlA[e6_0L0000P?Ya2_D:L@[d004Jm@Ya2_D:LA[e2W000@Ya6
_D:lA[e2W4Jm@[a6_@00B]e6_4ZmA[a:gDJlB[d004[MB[a:g@@0000HB[a:g@00C]a:_4kLB[a>g4Zl
C]a:_000B[]>g4Zl001:^dkLB[a>g000C]a>_4kL100000=:^dkL00001goo00<007ooOol0>7oo001W
Ool3000<Ool00`00JaQ[6002JaP03@00G_YO6UkjHaX005lJG_YS6UkjGaX005;l00=Bg003D_aBg5;L
00H0000=A[a6_DJmA[d004:m@Ye2_D:L@[e2WD:m00000d:m01=2W4:m@[d004JlA[e6_4JmA[a6_DJl
A[d004ZlA[a:_DJlB[a6_0040006B[`00`00B[a>_003B[`02TjlB[a:_000C]a:_4jl001>g4Zl0Tjl
10001Tjl00<007ooOol017oo0P00>Woo001UOol4000<Ool01@00JaQ[66/HJ_P00V/H010005kj0000
06<KG_YS6ekjHa]NnV<K001Bo4kLD_aBg080000UD_a>g000A[a6_DJlA[e6_4JmA[a6_@00@[e2W4:m
?Ya2_D:L0012W4Jm@Ya2_D:LA[e2W000@Ya6_D:lA[e2W4Jm@[`004JlB]d0100000A6_4Zm001:g@=:
_00AB]e:_4ZlB[`004ZlC]a:_4kLB[a>g4ZlC]`004kLB[]>g004000034ZkC]`004kLC[]>g4ZkC]a>
^dkLB[/000Moo`03001oogoo03Moo`00Hgoo0P003goo00<006/HJaP01V/H00d005kjGaYNnV<JG_YO
6UkjHaYNnP00D]aBo0020005D]`00`00A[a6_@02A[d03DJlA[e6_@00@Ya2_D:M@[e2W4:m@Yd004:L
00=2_@08@Ya2_@00A[e6_4JmA[a6_@D00007B[a6_4ZlA[a:_4Jl00002DZl00<004ZlC[`00dZl00=>
_4Zl000010000Tjl00A:_4jlC[`000Q>_003001oogoo00Ioo`03001oogoo03Ioo`00H7oo0`0047oo
00D006/HJaQ[66[h00=[600=J_P006[h001NnV<KG_YS6ekjHa]NnV<KG_X00P0001EBo4kKD_a>g5;l
C]]Bo000A[e6_4JmA[a6_DJlA[e6_000?Ya2_D:L@[d03`0000m6_D:LA[e2W000A[a:_DJlB[e6_4Zm
A[`004ZlB]d00dZl00M:gDZlB[`004kLB[a>g00400005DZkC]`004kL001>g4ZkC]a:^dkLB[/004Zk
C]a>^dkLB[]>g4jkC]`00007Ool00`00Oomoo`0fOol005eoo`<001=oo`03001[66/H00E[600;001[
66/H001S6UkjGaYNnV<JG_YO6P0200000ekj001Bg007D]`00`00A[e6_003A[d700003T:m@Ya2WD:M
0012W4:M@Ya2_D:L@Yd004JmAY`2A[`03DJmAYa6_4Jl0016_4ZlA[a:_4JlB[a6_00000M:_0@0000:
C[a:_4ZlB[a>_4Zl001>_000B[`3C[`00dZlC[`00007C[`20008Ool00`00Oomoo`0eOol005]oo`<0
01Aoo`04001[66/HJ_P3JaP06F[h001Zn6/HJ_Q[6000Ha]NnV<KG_YS6`00Ha]NnV<KG_X004kLD_a>
fe;lC]aBo4kK00H0000TA[e2W4JmA[`003jL@[e2W4:m?Ya2_@00@[e2W4Jm@Ya2_D:LA[d004Jm@Ya6
_D:LA[e2W4Jm001:_DJlB[e6_4ZmA[a:_@000TZl00=:g@0000000P000TZl00T004kLB[a>_4ZkC]a:
_4jlB[/00P0000Y>g4ZkC]a:^dkLB[]>g000C]a:^`@00003C]a>^`0000Qoo`03001oogoo03Aoo`00
F7oo0`000goo00<007ooOol047oo00<006/HJaP01F/H00<006/HJaP016/H00H006<JG_YO6P00HaX3
G_X00f<J001Bg004D]`20002D]`02`00A[e6_4JmA[a6_DJlA[e6_000@Y`00T:M00i2_D:L@Yd004:m
@Ya2WD:L@[e2W000A[a6_DJL0TJl00Q6_DJLA[`004ZlA[a:_4Jl1P001TZl00D004ZlB[a:_4jl00=:
_003C[`00000009>_004B[a>_4jlC[`400001djkC[a>_4jlC[]>_00000Moo`8003Ioo`00EWoo0P00
67oo00@006kf001Zn0=[600;J_Q[6000JaQZn6/HJ_Q[66[h001NnP0200002V<KG_YS6ekjHa]NnV<K
001Bo4kL0P00029Bo4kLD]a>f`00A[a6_D:LA[e6_4Jm@Ya6_@00@[dnW4:m@Ya2_CjL@[d004:m@Ya6
_D:L@[e2W000@Ya6_D:LA[e2W0L00005AYa:_4JLB[d00008B[`03000B[]>g4ZlC[a:^dkLB[a>_000
C]a:^`@0000<C[a:^`00C[]>_4ZkC]a>^djlB[]>g00027oo00<007ooOol0<goo001COol3000JOol0
1000KaI_5P0016/H00<006/HJaP01V/H00<005kjHaX00ekj00ES6UkjG_YNnV<J008000MBg00<0016
_4JmA[a6_DJlA[e6_4Jm0012_D:L0T:M00M2_D:L0012W4:m@Ya2W@0800001TJLA[a6W4Jl001:_0=6
_003B[a6_00000U:_005001:_4ZlB[a>_002B[`40002C[`01DZkC[a>_4jl00000djl00M>^djlC[a>
_4jkC[`00008Ool00`00Oomoo`0bOol0055oo`<001]oo`0K001c5fkfLaL006/HJ_Q[6000JaQZn6/H
J_Q[66[hJaQZn000J_P005kjHa]NnV<KG_YS6ekj0080000BHa/005;lC]aBg4kKD_a>g5;LC]/004Jl
A[e2W4JmA[a6_D:L300001E2_D:L@Ye2W000@Ya6_D:LA[e2W4Jm@Y`004JLB[a6W4ZmAYa:_4JL0000
24Zl00<004jlB[/0100001E>_000001:^djlB[]>_4ZkC[a:^djl001>g4jkC[a:^dkLC[]>_4Zk0000
27oo00<007ooOol0<Woo000]Ool4000MOol3000MOol01000KaI_5W<F0VlF00<006/H000026/H00L0
06/HJaQ[6000G_YS6P03G_X00`00G_YNnP02G_X00`00D]aBg005D]`01000A[e6_4Jm10000TJl00X0
04:M@Ya2WD:L@Ye2W000@Ya2W@=2W00=@Yd004JlAYa6_4JLA[a6W4JlAY`004JlB[`00dJl00=:_4Jl
00001dZl0`000dZl00I>_4Zl000004jlB[/3C[`01DZkC[a>_4jl00000djl00A>^djlC[a>_08000Qo
o`03001oogoo035oo`00;Goo00<007ooOol077oo0P0087oo02P006kfLaM^mW<GK_Ic5`00JaQZn6/H
J_Q[66[hJaQZn000J_Q[66[hJaP006<KG_YS6ekj001NnV<KG_YS6ekj001>fe;lC]aBg4kKD_a>g0@0
000VA[e2W4JmAYa6_D:L000nW4:M?Ya2_CjL@YdnW000@Ya2WD:L@[e2W4:M0016_D:LA[e2W4Jm@Ya6
_D:L0016W4ZlAYa:_DJLB[`000=:_0@0000GBY]:_000C[a:VdjlB[]>_000C[`004jlB[]>_4ZkC[a:
^djlB[/004ZkC]a>^`0400000djlB[/00008Ool00`00Oomoo`0`Ool002ioo`03001oogoo01Moo`@0
025oo`03001_5W<F00=_5P04LaH006lF0006JaP00`00JaQ[6004JaP01000G_X000001ekj00<005;L
D]`010000U;L00@004JlA[a6_@=6_00:A[e6_000@Ya2WD:L@Ye2W4:M0002@Y`03T:M@Ya2W4:L@Yd0
04JlAYa6_4JLA[a6W4Jl0002A[`00dZlA[`000050006B[`00`00B[a>_003B[`01P00B[a:_000C[a:
^`=>_003B[]>_00000<00007C[]>_4jkC[a>^djl00001goo0P007Woo0`004Goo000WOol40004Ool0
0`00Oomoo`0EOol3000ROol09000K_Ic5fkfLaM^mW<GK_H006kfLaL006/HJ_Q[66[hJaP006/HJ_Q[
66[hJaQZn6/H001S6ekjHa]NnV<KG_YS6ekjHa]NnP80000TD]a>fe;LC]]Bg4kKD]`004JmAYa6_D:L
A[e6W4Jm@Y`003jL@YdnW4:m?Ya2W@00@[e2W4:M@Ya2_D:L0012W4Jm@Ya6_D:L1`0001U6VdZlAYa:
_000B[a:VdZlBY]:_4ZKB[a:V`00B[]>_4ZKC[`004jlBY/004ZkC[a:^`04000034jlB[/004ZkC]a>
^djlB[]>g4jkC[`000Qoo`03001oogoo01]oo`03001oogoo015oo`00;Goo00@007ooOol001=oo`<0
02Eoo`03001c5VlF009_5P05LaI_5P00KaIc5P02KaH01@00JaQ[66/H00001f/H00<006/H00001ekj
0P0000=NnP00C]`00e;L00A>g5;LD]`000=6_00:A[e6_4JlA[a6_@00@Ye2W4:M@Y`?0004AY`02@00
A[a6W4ZlAYa6_4JLB[`00007B[`02000B[a:_4jlB[`004ZlC[`4000044ZkC[a>^djlB[]>_000C[a>
^djlC[]>_4jkC[a>^`002Goo00<007ooOol06Woo00<007ooOol04Goo000^Ool2000AOol3000WOol0
=@00LaM^mW<GK_Ic5fkfLaL007<GK_Ic5fkfLaL006/H001[66[hJaQZn6/HJ_Q[6000JaQZn6/H001S
6ekjHa]NnV<K001S6ekjHa]NnP00C]]Bg4kKD]a>fe;LC]/004:LA[e6W4Jm@Y`01`0002LnO4:M?Ya2
W@00@Ye2W4:M@Ya2WD:L0012W4Jl@Ya6_4:LA[a2W000AY]:_4JLB[a6VdZlAY`004ZKB[a:VdZlBY]:
_4ZKB[`004jlB[/0100001E>_4ZK001:^djlBY]>_4ZkC[a:Vdjl001>_4ZkC]a>^djlB[]>g4jk0000
27oo00<007ooOol06goo00<007ooOol047oo000nOol3000YOol00`00LaI_5P02KaH01G<FKaI_5P00
LaH00flF00Ac5VlFKaH000M[6003001[66/H009[6003001NnUkj009NnP03001NnUkj00=NnP03001B
g4kL00=Bg003C]aBg00000D00005AYa6_4JLA[`00002@Y`01D:M@Ya2W4:L00001d:L00<004JLAY`0
1DJL00T004JLA[a6W4ZlAYa6_4JL000014Zl1P0000=:_000B[/00TZl019>_000C[a>^djlB[]>_4jk
C[a:^`00C[]>_4jkC[a>^djlC[/20009Ool00`00Oomoo`0HOol4000AOol003aoo`@002Yoo`0P001^
mW<GK_Ic5fkfLaL007<GK_Ic5fkfLaM^mW<G001c5`00JaQZn6/HJ_Q[6000JaQZn6/HI_Q[66[h001N
nP80000:Ha]NnV<KG_YS6ekjHa/005;LC]/400009e;LC[/004:LA[e2W4Jm@Ya6_D:L000nO4:M?Ya2
WCil@YdnW000@Ya2WD:L@Ye2W4:M0016_4:LA[a2W4Jl@Ya6_000B[a6VdZlAYa:_00700006DZlBY]:
_4ZK001:VdjlBY/004ZKC[a:Vdjl001>_4ZkC[a:VdjlB[]>_4ZK001>^djl00@00003C[]>g00000Uo
o`03001oogoo02aoo`00>Woo0P00;Goo00D006lFKaI_5W<F00=_5P05001_5VlFKaIc5P03KaH01000
K_I_5P0016/H00<006/HJaP01F/H00<005kjG_X025kj0P00011>g5;LC]aBg4kLD]a>g000AYa6_4JL
A[a6W4JlAY`000=2W005@Ye2W4:L@Y`00006@Y`00`00AYa6W002AY`800001TZlAYa6W4JL001:V`=:
_009BY]:_000C[a:^dZl001>_4Zk009:_008C[`004jlC[]>_4ZkC[a>^`@00007C[a>^djlC[]>_4jk
000027oo0P0027oo0P0097oo000gOol3000^Ool0:P00L_D006kfLaM^mW<GK_H006kfLaM^mW<GK_Ic
5fkf001^mW<GK_H006[hJaQZn000J_Q[66KhJaQZn6/HI_P006[h001NnV<KG_YS6ekjHa]NnP80000N
H_/005;LC[]Bg4jkD]a>^e;L0016_D:LA[e2W4Jm@Ya6_@00@YdnO4:M?Ya2WCil@Yd004:M@Ya2WD:L
1`000212W4JL@Y]6W000B[a6VdZlAY]:_4JKB[`004ZlBY]:_4ZKB[a:VdZl001>_4ZK001:VdjlBY]>
_4ZK001:Vdjl100000a:^djl001>g4jkC[a>^dkLC[]>_4jk0009Ool00`00Oomoo`04Ool01000Oomo
o`008goo000eOol2000aOol01000LaEbm@000flF00Ec5P00KaI_5W<F00=_5P09001^mVlFKaIc5Vkf
001[600000M[6005001Zn6/HJaP00005G_X00`00G_YNnP02G_X03@00D]a>g5;LC]aBg4kLD]`004Jl
AYa6_4JL00l000A2W0030016W4JL00A6W0030016W4Zl00=6W006B[a6W4JL001:_4ZK0dZl00E:VdZl
001>_000009:_003C[a:^dZl00<0000AC[a>^djlC[]>_4jk001>^djlC[]>_4jkC[a>^djlC[/00008
Ool00`00Oomoo`04Ool01000Oomoo`008goo000bOol300000goo001oo`0_Ool0;000LaI^mG<FL_D0
06kfLaL007<GK_Ic5fkfLaM^mW<G001c5fkfLaM^mW<GK_H006[hJaQVn6/HJ_Q[66Kh001Zn6/HI_Q[
6000Ha]NnV<KG_X005kjH_/3G_X02000C[]Bg4jkD]a>^e;LC[/50000;d:LA[a2W4Jl0012W3il@Ydn
O4:L?Wa2W@00@Ya2O4:L@Wa2W49l0012W4JL@Y]6W4:LAYa2V`00AY]:_4JKB[a6VdZlAY/004ZKB[a:
VdZlBY]:_4ZK001:V`00BY/0100001A>_4ZK001:VdjlB[]>_4ZKC[a:^`00C[]>g4jkC[a>^dkLC[]>
_0002Goo00<007ooOol00goo00@007ooOol002=oo`00<7oo0P00=Goo00/007;eLaIbmG<EL_D006lF
001_5W<F00=_5P06LaH006lFKaIc5Vkf0VlF00<006kf00001F/H00<006[hJaP00V/H00AZn6/H001N
nP8000MNnP03001>g5;L00@00003C[]>g00000I6W0040012W4:L@W`3@Y`00d9l0012W006@Y`00`00
AYa6W005AY`00`00AYa:_003AY`00dZlAY`00002B[`00dZKB[`0000500005dZKB[a:^djlBY]:_000
C[a>^djlC[]>_4jkC[a>^`00C[]>_4jkC[a>^djlC[/00P002Goo00<007ooOol00Woo00@007ooOol0
02=oo`00;Goo0`00=Woo02P006keLaIbmG<FK_Ec5W;e001^mW<GK_Ic5fkfLaL007<GK_Ic5fkfLaM^
mW<G001c5fkf001Zn6/HI_Q[6000JaQVn6/HJ_Q[66KhJaP0009NnP05H_]NnUkjG_YRn`03G_X20000
:U;LC[]Bg4jkD]a>^e;L0016_4:LA[a2W4Jl@Y`003il@Y`nO4:M?Wa2W3il0012O4:L@Wa2W49l@Ya2
O000@Ya6W4:KAYa2W4JL001:_4JKB[a6V`P0000IB[a:VdZlBY/004ZKC[a:VdjlBY]>_4ZKC[`004jl
BY]>_4ZkC[a:Vdjl001>_4jkC]`0100000=>^dkL000027oo00<007ooOol00goo0P0097oo000ZOol3
000iOol02P00LaIbmG<EL_Ec5W;e001bm@000flF00Ic5VlF001_5W<FK_H2KaH00g<F001_5P02KaH0
1@00JaQ[66/H00000f/H00MZn6/HJaQ[6000JaP00007G_X200002Ukj001>_5;LC[]>g4jlD]a>^`00
1dJL00@004:L@Ya2O0=2W0030012W4:L00E2W0030016W4JL0096W0L0000<AY]6W4JLBY`004ZLBY]:
_4ZKBYa:VdZl0P0000m:^djlBY]:_4ZkC[a:V`00C[]>_4jkC[a>^djlC[/0100000M>_4jkC[a>^djl
C[/00007Ool00`00Ool0000ZOol002Qoo`80009oo`03001oogoo03Ioo`0[001c5W;eLaI^mG<FL_Ec
5P00LaIbm@00K_Ic5fkf001^mW<GK_Ic5fkfLaL007<GK_Ic5fkfLaL006/H001[66KhJaQZn6/HI_Q[
6000JaQVn6/H00000Ukj00ERnekjG_X005kk009NnP0EF]X004jkD]a>^e;LC[]Bg4jk0012W4Jl@Ya6
_4:LA[`004:M?Wa2W3il00l0000B@W]6W49kAY`004ZlAY]:W4JKB[a6V`00BY]:_4ZKB[a:VdZl0`00
00]>_4ZKC[a:VdjlBY]>_4ZK001:^djl00@0000<B[]>_000C]a>^e;LC[]>g4jkD]a>^`002Goo00<0
07ooOol09goo000UOol3000mOol04P00L_Ec5G;eLaIbmG<E001c5W;eLaD007<FKaH006lFLaI^mP9_
5P03LaI^mP00009_5P05K_I_5VlFKaH00003JaP01F[hJaQ[66/H00000f/H00=Zn000G_X00ekj00<0
05kjG_X00ekj00P004kLC[aBg4jkC]a>_5;L300000dnO49l@Wa2W000@Ya2O4:L@Wa2W49l@Y`00006
AY`01P00AY]6W4JLBYa6V`96W003001:VdZL00<00008BYa:V`00001:_4ZkC[a:V`H0000@C[a>^djl
C[]>_4jk001>^djlC[]>_4jkC[a>^djl0009Ool00`00Oomoo`0WOol002=oo`8003moo`0^001bmG<F
K_Ec5W;eLaI^m@00L_Ec5VkeLaH007<G001c5fkfLaM^mW<GK_H006kfLaM^mW<GK_Ic5`00LaL006/H
J_Q[66KhJaP006/HI_Q[66KhJaQVn000G_X200001EkkG_YNnU[JG_/00Ukj00<005;LC[/0100002MB
g4jk0012W4JL@W]6W4:LAY`004:L?Wa2W3ik@Y`nO000@W]2W49k@Ya2Nd:L@W/0049kAYa2NdJL@W]6
W49k0016VdZlAY]:W4JKB[`00`0000E:_4ZKB[a:VdZl00H0000EBY]>_4ZKC[`004jlC[]>_4ZkC[a>
^djlB[/004jkC]a>^e;LC[]>g4jk008000Uoo`03001oogoo02Ioo`008Goo0P00@Goo014007<EL_Ec
5W;eLaEbm@00L_Ec5G;eLaIbmG<E001c5Vkf009_5P03LaI^mP00009_5P09K_I_5VlFKaI^mP00KaI_
5`0000=[6005J_P006/HJaQZn003JaP00f[h001NnP09G_X200000djkC[a>^`02C[/00djl0016W002
AY`01D:LAYa6W4JL00000T9l00e2W3il@Wa2O000@Wa2W49l@Ya2O4:L@W`00007AY`00`00AY]6W003
00001DJL001:_4ZKBY`01@0001E:_000C[a:^djlB[]>_4ZkC[`004jlC[]>_4jkC[a>^djl001>_4jk
C[`0100000=>_4kL00002Goo00<007ooOol09Goo000QOol20010Ool0<000LaI^mG<FL_Ec5VkeLaH0
07<FK_Ec5W;eLaH007<F001c5fkfLaM^mW<G001c5fkfLaM^mW<GK_H006kfLaM^mP00I_Q[66[h001V
n6/HI_Q[66KhJaQVn000I_P0009NnP05F]YNnekjG_YJfP0200009ekj001Bg4jkD]a>^e;LC[]Bg000
AYa2W4JL@W]6W4:L000nNd:L?Wa2W3ik@Y`nO000@W]2W49k@Ya2Nd:L0016W49kAYa2NdJL@W]6W003
00000dZlAY/0000500001DjlBY]:_4ZKC[`00P0000m:VdjlBY]>_4ZKC[a:V`00B[]>_4jkC[a:^djl
C[/0100000MBg4jkD]a>^e;LC[/00008Ool2000WOol0025oo`03001oo`0003moo`0H001bmG<FL_Ec
5G;eLaH007<EL_Ec5W;eLaEbm@00L_Ec5@00LaI^mVlF001_5Vkf0flF00E^mVlF001_5fkf009_5P03
001Zn000009[600:J_Q[66/HJaQZn000J_Q[66[h0005G_X01@00G]YNnUkj00000djk00I>_4jkC[]>
^djl0003AY`01D:LAYa6W000?W`00T9l00a2W3il@W`004:L@Wa2W49l@Ya2O4:L0004AY`7000034JK
BYa6VdZL001:_4ZKBYa:VdZlBY]:W080000:B[]>_4ZkC[a:^djlB[/004jkC[`40002C[`02P00C]a>
_4kLC[a>g4jlC]a>_0002Goo00<007ooOol097oo000QOol01000Oomoo`00?Goo03<006keLaIbmG<F
K_Ec5W;e001^mG<FL_Ec5Vke001bmG<FK_D006kfLaL007<GK_Ic5fkfLaM^mW<G001c5fkfLaM^mW<G
K_H006KhJaQVn6/HI_Q[66Kh001Vn6/HI_Q[6000G_/00Ukj01AJfP00F]YNnU[JG_YJfP00C[]Bg4jk
D]a>^e;LC[/0049kAYa2W4JL5P0001=2NdJL@W]6W000BYa6VdZLAY]:W4JKBY`004ZlBY]>_4ZKB[a:
V`0200001djlBY]>_4ZKC[a:Vdjl00<0000@C]a>^dkLC[]>g4jk001>^e;LC[]Bg4jkD]a>^e;L000:
Ool00`00Oomoo`0SOol0021oo`03001oo`00009oo`03001oogoo03Yoo`0G001c5W;eLaEbmG<FL_D0
07;eLaIbmG<EL_Ec5P00LaEbmG<FL_D006lF001^mP03KaH01FkfKaH006lGK_H00VlF00I_5fkf001_
5P00J_P3JaP02V[h001Zn6/HJ_Q[66[hJaP005kj0P0000ENfUkjG_YNnUkJ009NnP05001>^djkC[]>
_002C[/500001TJL@W]6W4:L000nN`=2O005?W]2O000@Wa2N`02@W`300005dJKAYa6NdJLAY]6W4Ik
0016VdZLAY]:W4JKBYa6V`00BY]:_4ZKBYa:VdZlBY/00P0000=>_4Zk00000`0000A>_4jk001>^`=>
_00;C[]>_4jl001>_4kLC[a>g4jlC]a>_0020009Ool00`00Oomoo`0SOol0021oo`8000Aoo`03001o
ogoo03Qoo`11001c5W;eLaI^mG<FL_Ec5P00LaIbmG<FK_Ec5P00LaI^mG<FL_Ec5Vke001^mW<GK_Ic
5fkfLaM^mP00K_Ic5fkfLaM^mW<G001c5fkf001Vn6/HI_Q[6000JaQVn6/HI_Q[66KhJaP005kjF]YN
nU[JG_YJfUkjF]YNnP00D]a>^`0400004U:lC[/0049kAYa2NdJL@W]6W000@W`nNd:L?W]2O3ik0012
N`<0000H@W]2W49k0012NdJL@W]6W49kAYa2N`00AY]:W4JKBYa6VdZLAY/004ZKB[a:Vdjl1P0001A:
VdjlB[]>_4ZKC[`004kLC[]>g4jkC]a>^dkLC[/004jkD]a>^e;L0P0000=>g5;L00002Goo00<007oo
Ool08Woo000POol00`00Oomoo`04Ool2000gOol05P00LaH007<EL_Ec5W;eLaD007<FL_Ec5G;eLaIb
m@00L_Ec5W;eLaEbmG<F0P000VlF00E^mVlFKaH006kf009_5P0FKaM^mVlF001_5fkfKaH006/HJ_Q[
6000JaQZn6/HJ_Q[66[hJaP006[h0003G_X01UkJG_YNnUkjG]YNnP8000I>^`0;0016W49kAYa2W4JL
@W]6W000@W`nN`02@W`30002@W`0549k@Wa2O49l0016W4JKAYa6NdJLAY]6W000BYa6VdZLAY]:W4JK
BY`500000dZlBY]:_00200002djkC[a:^djlC[]>_4ZkC[`004jlC[/00djl00E>^djl001>g4jl0080
0005D]a>g5;LC]`00009Ool2000SOol0021oo`03001oogoo00Ioo`03001oogoo03Aoo`0n001bmG<F
001c5W;eLaI^m@00L_Ec5VkeLaIbm@00K_Ec5W;eLaI^mG<F001c5Vke001^mW<GK_Ic5`00LaM^mW<G
K_Ic5fkf001^mW<GK_Ic5`00JaP006/HI_Q[66KhJaQVn6/H001[66KhJaP005kjF]YNnU[JG_YJfP80
000BG_X004jlCY]B_4jkC[a>Ve:l0016W49kAYa2NdJL@W/003ik0`0001DnNd9l?W/0049k@Ya2Nd:L
@W]2W000AYa2NdJL@W]6W49kAY`004ZLAY/0100001Y:W4JK001:VdjlBY]>_4ZKC[`004jlB[]>_4ZK
C[a:^djlBY/004jkC]a>^dkLC[]>g4jk0`0000Q>fe;LC]aBg4kKD]a>g0002Goo00<007ooOol08Goo
000POol00`00Oomoo`07Ool00`00Oomoo`0bOol06`00L_Ec5G<ELaH007<EL_D007;eLaEbmG<FL_Ec
5@00LaIbmG<EL_Ec5W;e001bmG<FL_D00002KaH01@00KaI_5VlGK_H00VlF01H006kfKaI_5VlGK_I_
5P00JaQZn6/HJ_Q[66[hJaP006[hI_QZn6Kh001NfP=NnP800005F]YNnU[JG]X00006C[/01P00@Ya6
W49kAYa2W0<00092O005?W]2O49l@W`00003@W`00d9k0000000;000064ZKBYa6VdZLBY]:W000B[a:
VdZlBY]:_4ZKB[`004jlC[]>_4ZkC[a>^djlB[/0009>_0@0000;C[a>g000D]a>g5;LC]aBg4kLD]`0
000:Ool00`00Oomoo`0POol0021oo`8000Uoo`03001oogoo035oo`0k001c5VkeLaIbmG<F001c5P00
LaI^mG<FL_Ec5P00LaIbmG<FK_Ec5W;e001^mG<FL_Ec5Vke001^mP00K_Ic5fkfLaM^mP00K_Ic5fkf
LaM^mW<G001c5`00JaQVn6/HI_Q[6000JaQVn6/HI_Q[66Kh001JfP0200003EkjF]YNnU[JG_YJfP00
C[]>_4jKD[a>^djl01@0000K@W]6W49k@W`004JLAW]6W49kAYa6N`00AY]:_4JKBYa6VdZlAY]:W000
C[a:VdjlBY]>_4ZK00800006C[a:^djlBY]>_4Zk100000iBg4jkD]a>^e;LC[/004kLD]a>fe;LC]aB
g4kK0P002Woo00<007ooOol07goo000POol00`00Oomoo`09Ool00`00Oomoo`0_Ool01@00LaEc5G<F
L_D00W<E01Yc5P00LaEbmG<FL_Ec5G;e001bmG<EL_Ec5W;eLaD007<FL_Ec5G;eLaIbm@00KaI_5fkf
0VlF00I_5`00KaI_5VlGK_H2KaH06`00K_I_5P00JaQZn6/HJ_P006KhJ_QVn6[hI_QZn6Kh001JfUkJ
F]YNnU[JG]YJfUkjF]X00002C[/30000<djk00000000AWa2NdIl@W]6O000@Wa2Nd9l@W]2O49k@W`0
049l@W]2O49k@Wa2N`00AW]6W4JKAYa6NdJLAY/004JKBYa:VdZLAY]:W4ZK001:VdZlBY]:_4ZKB[a:
V`00B[]>_0040002C[`01@00C]a>g4kLC[`00dkL00I>_000C]aBg4kLD]`200000dkLD]`00009Ool0
0`00Oomoo`0OOol001moo`03001oogoo00]oo`03001oogoo02ioo`16001^mG<FL_Ec5VkeLaH007<F
001c5W;eLaI^m@00L_Ec5VkeLaIbmG<F001c5W;eLaI^mG<FL_D006ke001^mW<GK_Ic5`00LaM^mW<G
K_Ic5fkf001^mVlGK_H006KhJaQVn000I_Q[66KhJaQVn6/HI_P006Kh001JfUkjF]YNnU[JG_YJfUkj
F]X20000<4jk00000000C[/004JL@W]6W49kAYa2N`00?U]2O3ik@W`nFd9l?W/0049kAYa2Nd9l@W]6
W49k0012NdJLAW]6W49kAY`004ZLAY]:_4JKBYa6VdZlAY/004ZKC[a:V`H0000BC]a>^dkLB[]>g4jk
001>^e;LC[]Bg4jkD]a>^e;L001Bg4kL0P0000EBo4kLD_a>g00000Yoo`03001oogoo01ioo`007goo
00<007ooOol037oo00<007ooOol0;7oo00@007<ELaIbm@9c5@0RLaIbm@00LaEc5P00LaEbmG<F001c
5G;eLaIbmG<EL_D007;eLaEbmG<FL_Ec5@00LaIbm@00KaI_5fkf001_5VlGK_H2KaH04@00K_I_5Vkf
KaM^mP00J_P006KhJ_QVn6[hI_QZn6Kh00000fKh00L005[JG]YJfUkjF]YNfP050000:4jkCY]>^djK
C[/004Il@W]6O49kAWa2N`00@W]2O49k@Wa2Nd9l@W/0049k@Wa2Nd9l@W]2O000AYa6NdJLAY]6W4Ik
AY`004ZLAY]:W4ZK1`0000A:^djlB[]>_0800005C[]>_4jlC[a>^`02C[`00`00C[a>g002C]`00djl
C]a>g0030002D]`01TkLD]aBg5;LC]`000Qoo`80021oo`007goo00<007ooOol03Goo00<007ooOol0
:goo04<007<FL_Ec5VkeLaIbm@00K_Ec5W;e001^mG<F001c5VkeLaIbmG<FK_D007;eLaI^mG<FL_Ec
5P00LaIbmG<F001c5fkf001^mW<GK_Ic5fkfLaL006lGK_Ic5fkfKaM^mP00I_Q[66KhJaQVn6/HI_P0
06KhJ_QVn6/H001NnU[JG_YJfP04000095kJ001>^djKC[]:VdjkCY]>^`00AYa2NdJL@W]6W49k000n
Fd9l?W]2O3iK@W`0049l@W]6W49k@Wa2NdJL0016W49kAYa6N`L0000<BY]:_4JKB[`004jlBY]>_4ZK
C[a:Vdjl0P0000Y:^dkLC[]>g4ZkC]`005;LC[]Bg0@0000;C]aBg000D_a>g5;lC]aBo4kLD_`0000:
Ool00`00Oomoo`0MOol001moo`8000moo`03001oogoo02Uoo`03001c5W;e009c5@06LaIbmG<E001c
5W;e0W<E01X007;e001bmG<FL_Ec5G;eLaH007<EL_Ec5W;eLaEbm@00L_Ec5G;eLaH006lF001_5fkf
0VlF015_5`00KaI^mVlGK_I_5Vkf001^mP00I_QZn6KhJ_QVn00000=Vn005J_QVn6Kh001NnP030005
F]X04`00C[]>VdjkCY]>^djK0012NdIl@W]6O49kAW`0049l@W]2O49k00l0000CAY]6W4IkAY`004ZL
BY]:W4ZKBYa:V`00B[]>_4ZkC[a:^djlB[/00P0000=>_4jkC[`00Tjl00=>^`0000000P0000QBg4kL
D]a>g5;LC]aBg0000e;L00=>g5;LD]`00P002Woo00<007ooOol077oo000OOol00`00Oomoo`0?Ool0
0`00Oomoo`0XOol0?`00L_Ec5VkeLaIbmG<F001c5W;eLaI^mG<FL_D006keLaIbmG<FK_Ec5P00LaI^
mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaH007<GK_Ic5fkfLaM^mP00K_Ic5fkfKaM^mW<G001_5fkf001V
n6/HI_Q[6000J_QVn6/HI_QZn00300003ekJF]UNfU[JG]YJfEkJF]X004ZKC[]>VdjkBY]>^`0<0000
8ciK@W`nFd9l0016O49kAYa2NdIl@W/004IkAYa6NdJLAW]6W4Ik001:VdZlAY]:_4ZKB[a6V`00BY]>
_4ZKC[a:VdjlBY/00P0000=>g00000000P0000i>^e;L001Bg4kKD]a>g5;LC]]Bg4kL001>g5;l1000
00=>g5;l00002Goo00<007ooOol077oo000OOol00`00Oomoo`0@Ool00`00Oomoo`0VOol01P00L_Ec
5G<ELaIbm@9c5@0N001bmG<ELaEc5W;e001c5@00L_Ec5G;eLaIbm@00L_Ec5W;eLaEbmG<F001c5G;e
LaIbmG<E001c5P000VlF019_5fkf001^mVlGK_I_5VkfKaL006lFK_I_5`00J_QVn6[h0002I_P026[h
00000000J_P006Kh0008F]X00`00CY/000030002CY/02@00@W]6Nd9kAW]2NdIk0012O003@W/01D9l
@W/0049k@W`00d9k01M2O000AYa6VdJLAW]6W4JKAYa6N`00BY]:W4ZKBYa:VdZL001>_4ZkC[a:^djl
00D00003C]a>_4kL009>g00:C[`004kLD]a>g5;LC]aBg4kLD]`3000025;lD]aBo5;LD_aBg5;l0009
Ool00`00Oomoo`05Ool5000AOol001ioo`03001oogoo019oo`03001oogoo02Eoo`0k001c5VkeLaIb
mG<FK_D007;eLaI^mG<FL_Ec5P00LaIbm@00K_Ec5W;e001^mG<FL_Ec5VkeLaH007<FK_Ec5W;eLaI^
m@00K_Ec5P00LaM^mP00K_Ic5fkfKaM^mW<G001_5fkfLaM^mVlG001[6000J_QVn00200003V[hI_Q[
6000I_QVf000F]YNfU[IG]YJfUkJF]T30000:dZJC[]:VdjkBYY>^`00AWa2NdJL@W]6O49kAY`0049l
?U]2O3iK@W`nF`00@W]6O49kAYa2NdIl0016W4IkAYa6NdJLAW]6W000B[a:VdZlAY]:_4ZK00H0000B
C]a:^dkLB[/004jlC]a>^e;LC[a>g4jk001>g5;LC]]Bg4kL0P0000]Bo4kL001>g5;mC]aBo4kLD_e>
g00000Qoo`03001oo`0000Qoo`03001oogoo015oo`007Woo00<007oo00004goo00<007ooOol08goo
00D007<ELaEc5W;e009c5@0:001bmG<ELaEc5W;eLaD007<FL_D2LaD09@00L_Ec5@00LaIbmG<EL_Ec
5P00LaEbmG<FL_Ec5G;e001bmG<EL_Ec5P00KaH006lGK_I_5VkfKaM^mP00K_I_5fkfKaI^mVlG00@0
00=Vn003J_P006Kh00=Vn003001JfU[J009JfP80009JfP03001>VdjK00E>V`0:0016Nd9kAW]2NdIk
@W/0049k@W`3@W/01D9l@W/0049k@W`00d9k00]2O000AYa6VdJLAW]6W4JKAY`004ZL00@0009:_003
001>_4jl00E>_080009>g007C[a>g4kLC]`005;LC]`00`0000iBg5;lC]aBg000D_aBg5;lD]aBo5;L
D_aBg0002Goo00<007ooOol01Woo00<007ooOol04Goo000NOol2000EOol2000SOol05000K_Ec5W;e
LaI^mG<F001c5VkeLaIbmG<FK_D007;eLaI^mG<FL_D2000087<FL_Ec5VkeLaIbm@00K_Ec5W;eLaI^
mG<F001c5VkeLaI^mG<F001c5fkfKaM^mW<GK_H006kfLaM^mVlGK_H400002F/HI_QZn6KhJaP006Kh
I]QZn@02I_P00`00G]YJfP0200009ekJF[UJfUZiG]X004jkBYY>^dZKC[]:VTjk0016O49kAYa2NdIl
@W/003iK@W`nFd9l?U]2O000AYa2NdIl@W]6W49k0016NdJLAW]6W00500003djlBY]:_4ZKC[a:V`00
B[]>g4ZkC]a:^dkLB[]>g00200001DjlC]a>^e;LC[`00`00011>g5;lC]aBo4kLD_a>g5;l001Bo4kL
D_e>g5;lC]aBo@8000Uoo`03001oogoo00Eoo`03001oogoo015oo`005goo0P001Goo00<007ooOol0
5Woo00<007ooOol07goo00@007<ELaIbm@9c5@06LaH007<ELaEc5W;e0W<E00H007;eLaEc5G<FL_D2
LaD05000L_Ec5G;eLaIbm@00L_Ec5W;eLaEbmG<F001c5G;eLaIbmG<EL_D2000026lFK_I_5fkfKaH0
06lGK_H300001Fkf001^mVlG00000VKh00=Zn6Kh00001VKh0P001e[J00<004jKCY/01DjK00D0049k
AW]2NdIk01D00006BYa6VdJLAY/004ZK0dZl00A:VdZlB[`000M>_003001>_00000@00003C]aBg000
009Bg00:D_a>g5;LD]aBo4kL001Bg5;lD]`40002D_`00`00Oomoo`07Ool00`00Oomoo`04Ool00`00
Oomoo`0AOol001Ioo`04001oogoo0004Ool00`00Oomoo`0GOol00`00Oomoo`0NOol0<000LaIbmG<F
K_Ec5W;e001^mG<FL_Ec5VkeLaH007<FK_Ec5W;eLaI^m@00L_D006keLaIbmG<F001c5W;eLaI^mG<F
L_D006keLaI^mG<FK_D006keLaH007<GK_I_5`@0000>K_Ic5fkf001^mVlGK_H006KhJaQVn000I]QZ
n@9Vn00BI]QZn@00I_P005kJF[UJfUZiG]YJ^E[JF[T004ZKC[]:VTjk1`0002U6O49kAW]2N`00@W]2
O49K@Wa2Nd9l0016W49kAYa2NdJL@W/004JKBYa6VdZLAY]:W4JK001:VdjlBY]:_4ZKC[a:V`00B[]>
g4ZkC]a:^dkL00<0000?D]a>g5;LC]aBg4kLD]`005;lC]aBo4kLD_a>g5;l00@00008C]aBoE;LD_a>
g5;mD]`000Qoo`8000Aoo`8001=oo`005Woo00@007ooOol000Aoo`03001oogoo01Qoo`03001oogoo
01aoo`03001c5`00009c5@06LaIbm@00LaEc5W;e0W<E00Ic5P00LaEc5G<FL_D2LaD06W<F001c5G<E
001bmG<E001c5W;eLaEbmG<FL_D007;eLaIbmG<EL_Ec5P00LaIbm@00K_H3000026kfKaI^mVlGK_H0
06kfKaL3K_H00`00I_P00006I_P01000I_QVn0002E[J10000djK00U:V`00@W]6Nd9kAW]2NdIk0000
1T9k0180049kAW]2NdIl@W]6N`00BYa6VdJLAY]:W4JKAY`004ZlBY/3B[`00dZKB[`00002C[`40002
C]`20002C]`01U;LC]a>g4kLD]`0009Bg0@00003D_aBg00000QBo003001oogoo00Eoo`<001Uoo`00
5Woo00@007ooOol000Aoo`8001Yoo`03001oogoo01]oo`0/001^mW<G001c5W;eLaH007<FL_Ec5Vke
LaIbm@00K_Ec5W;eLaI^mG<F001c5VkeLaIbm@00K_D007;eLaI^mG<FL_D006keLaI^mG<FK_Ec5P00
LaI^m@<0000BK_H006kfKaM^mW<GK_I_5`00KaM^mVlGK_I_5fkf001Vf6[i0VKh00iVf6[iI_P006KH
I_UVf000F[UNfUZiF]YJ^EkJ0P0002]F^@00BYY>VdZJCY]:VTjK0016O49kAW]2NdIl@W]6N`00@Wa2
Nd9l@U]2O49k0012NdJL@W]6W49kAY`004ZLAY]:W4JKBYa6VdZL001:_4ZKC[a:V`0500001djkC]a>
_4kLC[]>g4jl00800006D]a>g5;LC]aBg4kL0`0000m>g5;lC]aBoDkLD_`005;mD]aBo4kLD_eBg5;l
C]`00P002Goo00<007ooOol05Woo000FOol01000Oomoo`000goo0P0077oo00<007ooOol06Goo00X0
06lFKaI_5P00L_Ec5@00LaIbm@9c5@06LaIbm@00LaEc5W;e0W<E00Ic5W;e001c5G<FL_D2LaD03P00
L_Ec5G;eLaIbmG<E001c5W;eLaEbmG<FL_D3000037;eLaIbm@00K_I_5VkfKaM^mVlF001_5`=^mP05
KaM^mP00K_H00005I_P01000I_QVn6KH0VKh00@005[JF]YJfP80009J^P03F]X004jK009>V`0<BY]>
VdjKCY/004Ik@W]6Nd9kAW]2N`001T9k00d004Il@W]6Nd9kAWa2N`00AY]:W4JKAYa6V`0700001dZl
C[a:_4jl001>g4jl00=>g004C[a>g0000002C]`400000e;LD_`00003D_`01E;LD_aBo5;l00001E;l
0P0000=Bo000Ool027oo00<007ooOol05Woo000GOol20004Ool00`00Oomoo`0LOol00`00Oomoo`0G
Ool0:@00K_Ic5fkfLaM^mP00K_D007;eLaI^mG<FL_Ec5P00LaIbmG<FK_Ec5W;e001^mG<FL_Ec5Vke
001bm@00K_Ec5W;eLaH007<FK_Ec5VkeLaH00P0002A^mG<FK_Ec5Vke001^m@00K_Ic5fkfKaM^mP00
K_I_5fkfKaM^mVlG001_5fkf001Vf6[iI_P006KHI_UVf6KhI]QVn@00F]X2000085ZiF]YF^E[JF[UJ
fP00CY]:VTjKBYY>VdZJ0012NdIl@W]6Nd9kAWa2N`00@U]2O49k@Wa2Fd9l0016W49kAY`800004dJK
B[a6VdZl001>_4ZkC[a:^djlB[]>_000C]a>^dkLC[a>g4jk00@0000AD_e>g5;lC]aBoDkL001>g5;m
C]aBo4kLD_e>g000C]aBo@0300001E;mD]aBoE;L00002Goo00<007ooOol05Goo000MOol00`00Oomo
o`0MOol00`00Oomoo`0FOol01000KaI_5W<G0flF00X007;eLaEc5G<FL_Ec5@00LaIbm@9c5@06LaIb
mG<E001c5W;e0W<E00]c5P00LaEc5@00L_Ec5G;e001bmG<E00<0000?LaD007<FL_Ec5W;eLaH007<F
L_D006kfKaI^mP0000=^mP08KaM^mVkf001^mfkfK_L0009Vn004001Vn6KhI]P3I_P016KHI_P005[J
0eZj00IJfUZjF[YJ^P00BY/3CY/00dZKCY/0000B000024JLAY]6W4Ik001:W4ZlBY/2BY`02dZlBY/0
04ZlC[a:_4jlB[a>_4Zl00000TkL10000TkL0P0000E>g5;LD]aBo4kL009Bg003001Bg5;l009Bo003
D]aBo000008000MBo003001oogoo00Qoo`03001oogoo01Aoo`007Goo00<007ooOol07Woo00<007oo
Ool057oo02<007<GK_Ic5fkfLaM^mP00K_H006keLaIbmG<FK_D007;eLaI^mG<FL_Ec5P00LaIbmG<F
K_Ec5P00LaI^mG<F001c5Vke00@0000dLaI^mG<F001c5VkeLaI^mG<F001c5VkeLaH006lGK_H006kf
KaM^mVlGK_I_5`00KaM^mVlGJ_I_5`00I_P006KiI]QVn6KHI_UVf6Kh001Vn@00F]YF^E[JF[UJfUJi
F]YJ^@00BYX400009djKBYX0049kAWa2NdIk@W]6O000AWa2NdIl@W]6O49k0016NdJL@W]6W4IkAYa2
N`00AY]:_4JKB[a6VdZlAY/004ZkC[a:^djlB[]>_00300004U;LC]aBg4kLD]a>g000C]`004kLD_e>
g5;lC]aBo@00D_a>g0@0000<D_eBg000D]aBoE;LD_eBg5;mD]aBo@0027oo0P005Woo000MOol2000P
Ool00`00Oomoo`0BOol01000KaI_5W<G0flF00Ac5`00KaI_5P80009c5@06001bmG<ELaEc5W;e0W<E
00/007;eLaEc5G<FL_D007<ELaIbmG<E00<0000DLaEbmG<FL_Ec5G;e001bmG<FL_Ec5W;e001bmG<F
L_Ec5P00KaL0009^mP0>KaM^mVkf001^mfkfK_M^mVkgK_I^m`00I_QVf0=Vn008I]QVn000I_QVf6Kh
001JfP=J^P03F]YJ^UZj00800007BYY>VdjKCY]:VTjK00001TIk00<0049k@W`00d9k00Y2O49k0016
VdJLAW]6W4JKAY`0009:W008B[a:VdZLBYa:_000C[a:_0@00003C]a>_00000M>g0800006D_a>g5;L
D]aBo4kL0`001e;l00<005;lD_`015;l0P002Woo00<007ooOol04goo000MOol00`00Oomoo`0POol0
0`00Oomoo`0@Ool08000LaM^mW<GK_Ic5fkfLaL007<GK_Ic5fkfLaL007<F001c5VkeLaIbmG<FK_D0
07;eLaI^mG<FL_D006keLaH30000=W<F001c5VkeLaI^mG<FK_D006keLaI^mG<FK_D006keLaI^mG<F
K_Ec5P00KaM^mVlGK_I_5fkf001^mVlGJ_I_5fkfKaL006lG001Vn6KHI_UVf6Kh001VnF;HI_QRf000
F[UJfUJiF]YJ^@80000TF]X004jKBWY>VdZJCY]:NTjK0016Nd9kAWa2NdIk@W/0049kAWa2NdIl@W]6
O000AYa6NdJL@W]6W4IkAY`004ZlAY]:_4JK1@00019:_4kLB[]>g4ZlC]`005;LC]aBg4kLD]a>g5;L
001Bo@00D_`400003DkLD_d005;lC]aBoE;LD_a>g5;m001BoE;L00@00003D_eBo00000Yoo`03001o
ogoo019oo`007Goo00<007ooOol08Goo00<007ooOol03goo00<006lFLaL00flF00Ec5flF001_5W<G
00=_5P06LaL007<ELaEc5W;e0W<E00Mc5P00LaEc5G<FL_Ec5@030002LaD06G<FL_D00000LaIbmG<E
L_Ec5P00LaIbmG<FL_Ec5P00LaIbmG<FL_Ec5P00L_H006lG00=^mP0;001^mVkgK_I^mfkfK_M^mP00
J_H00002I_P036KHI_P006KhI]QVn6KHI_QVf000F[YJfP80009J^P05E[T004jKCY]:VP03CY/00dZJ
CY/00006AW/00`00@W]2O003@W/01T9l0016W4JKAYa6N`L000A:_009001>g4jlC]a>_4kLC[a>g000
00I>g0@00008D_aBg5;lD]aBo5;LD_`000IBo0<000MBo003001oogoo00Moo`03001oogoo019oo`00
77oo00<007ooOol08goo00<007ooOol03Goo01/006kfLaM^mW<GK_Ic5fkf001^mW<GK_Ic5fkfLaL0
07<G001c5W;eLaI^mG<F001c5VkeLaH00`0003Qc5W;eLaI^mG<FL_D006keLaH007<FK_Ec5P00LaI^
mG<FK_Ec5P00LaI^mG<FK_Ec5Vke001^mG<F001_5fkf001^mVlGJ_I_5fkfKaMZmP00J_I^mf[f001V
f6Kh001VnF;HI_QRf6KiH]QVn6;H0P0001YJ^UJiF]YF^EZjE[T004ZJCY]:NTjKBYY>VdYj0012NdIk
@W]6O49kAW/004Il@W]6O49k1`0001I6VdZlAY]:W000C[a:^dZlBY]>_4Zk001:^dkLB[a>g4ZkC]a:
_000C]aBg0@0000>C]aBo000001>g5;lC]aBoDkLD_a>g000D]aBo0@0000;D]aBo@00D_eBg5;mD_aB
oE;LD_d00009Ool2000COol001aoo`<002Aoo`8000aoo`03001_5W<G00=_5P05LaM_5P00KaIc5`03
KaH01W<GKaH006lFLaL0009c5@03LaIbm@0000<0009c5@0k001bmG<ELaEc5W;eLaD007<FL_Ec5@00
LaIbm@00L_Ec5W;eLaIbm@00L_Ec5W;eLaIbm@00L_Ec5VkeL_H006lG001^mfkfK_M^mVkgK_H006[f
K_M^mVkg001Vn000I_QVf6KhI]QVn6KHI_QVf000H]P00002F[X01UJiF[YJ^UZjE[T0009>V`04BYY>
VdjKCY/<0003AW/00dJL0016W002AY`014JKAYa6W0001dZl00L004jlC]a>_4kLC[a>g00300001e;L
C]aBg4kLD]a>g5;L00800006D]aBo5;LD_aBg5;l0`001e;l00<005;lD_`015;l0P002Woo00<007oo
Ool047oo000LOol200000bjN00000005000OOol00`00Oomoo`09Ool05`00LaM^mW<GK_Ic5fkfLaL0
07<GK_Ic5fkfLaM^mP00K_Ic5flFLaL007<FL_D00P00015c5W;eLaI^m@00L_Ec5VkeLaIbmG<F001c
5W;eLaI^mG<F0080000gK_Ec5VkeLaI^m@00K_Ec5VkeLaI^mG<F001c5VkeLaI^mG<F001_5f[fKaM^
mVlGJ_H006[fK_MZmVlGJ_I^m`00I_URf6KhH]QVnF;HI_QRf000H]QVn000F]YF^EZjE[UJfUJiF[X0
04jKBYX01000029>VdYj0016NdJKAW]6W4IkAY/004JL@W]6W49kAYa2N`00AY]:_4JKBYa6VdZlAY/0
04ZKC[a:^dZlBY]>_000C]a:^`@0000;D]a>g000C]aBoDkLD_a>g5;mC]aBo00200000dkL00000002
00003E;mC]`005;LD_eBg5;mD]aBoE;L001Bo5;m00@00003D]aBo@0000Uoo`03001oogoo011oo`00
77oo00@007oo0000008ZWP04:Wh000004Qd4000LOol00`00Oomoo`07Ool00`00LaM_5P02KaH01G<G
KaI_5P00LaL00flF00Ec5flFKaH007<G00=_5P@00006LaIbmG<ELaEc5P000W<E00Ic5W;eLaEc5@00
L_D2LaD0<W<FL_Ec5@00LaIbmG<FL_Ec5P00LaIbmG<FL_Ec5P00LaI^mG;fL_Ec5P00L_H006kgK_I^
mfkfK_L006kgK_I^mf[fK_L006kg001Vn6KHI_QVf6KhI]P006;HI]QRf6KH0003F[X00eJiF[YJ^P03
00001djJCY]>VTjKCYY>V`0000I6N`050016NdIkAW]6W003AW/00`00AY]6W002AY`00dJKAY`00004
B[`50007C]`02000C]aBg4kLD]a>g5;LC]`30002D_`01U;LD_aBo5;lD]`000IBo0<000MBo003001o
ogoo00Moo`03001oogoo00moo`0077oo00h007ooOomoo`00:WhZWRYm;Yh0018m4Q`F?A8L0P006goo
00<007ooOol01Goo01<006/i001c5fkfLaM^mW<G001c5fkfLaM^mW<GK_Ic5`00LaM_5P030000BVlF
LaL007<FL_Ec5VkeLaH007<FK_Ec5W;eLaI^m@00L_Ec5VkeLaIbmG<F001c5P00LaI^mG<F001c5Vke
LaI^mG<FK_D006keLaI^mG<FK_D006keLaH006lGJ_I_5`00K_MZmVlGJ_I^mf[f001ZmVkg001VnF;H
I_QRf000H]QVn6;HI_URf000E[UJfUJiF[X200007EJiF[X004jKBYY>VdYjCY]:VTjK0016W4IkAY]6
NdJLAW/0049kAYa2NdJL@W]6W000BYa6VdZlAY/01`0000Q:_4kLB[]>g000C]a>_5;L0TkL00I>_5;L
001Bo4kLD_d400003DkLD_`005;mD]aBoDkLD_eBg5;m001BoE;L00@0000;D_eBg000D_aBoE;LD_eB
o5;mD]`00009Ool00`00Oomoo`0?Ool001aoo`03001oogoo009oo`@00006:Yh000004Q`B7A8L0`00
6Woo00<007ooOol00goo00H006/IJaU[6@00LaL3KaH01@00KaI_5VlFLaL00VlF100000M_5W<GKaI_
5P00LaL00002LaD01W<FL_D007<ELaIbm@9c5@06LaH007<ELaEc5W;e0W<E038007;eLaH007<FL_D0
07;eLaIbmG<FL_D006keL_IbmG<FK_D007;fLaI^m@00K_I^m`00K_M^mVkgJ_I^mfkf001ZmVkgJ_L0
06KHI_QVf000H]QVf6;HI]QRf6KHH]P005Ji0P0000eJ^UJiF[YF^@00CYY>VdjJCY]>VTjKCYX00006
AW/00`00AYa6N`02AW/70002B[`02dZLB[`004jlB[a>_4ZlC[a:_4jl00001TkL100000IBo5;LD_a>
g5;lD]`20003D_`00e;LD_aBo0030007D_`00`00D_aBo004D_`20008Ool2000@Ool0009oo`<001Mo
o`03001oogoo00=oo`03000ZORZN00H000034Q`B?@00008001Uoo`0C001oogooOol006/iIaQ[6FLH
JcT007<GK_H006kfLaM^mW<GK_H00`00021_5W<GK_Ic5flFLaM^mP00KaIc5`00LaIbm@00K_Ec5W;e
LaI^mG<F001c5VkeLaIbmG<FK_D007;eLaI^mG<F0P0002Y^mG<FK_Ec5VkeLaH007<FK_Ec5VkeLaH0
07<FK_Ec5Vke001^mP00J_I_5f[fK_MZmVlG001^mf[fK_MZmP00H]P006;HI_QRf6KiH]QVn6;HI_T2
00004eJiF[YF^EZjE[UJ^UJi001:NTjKBYY>VdYjCY]:VP00AW]6W4Ik00L0000DAY]:W4IkBY`004Zl
AY]:_4JKB[a6V`00B[a>g4ZkC]a:_4kLB[/0009>g0@0000;C]aBo@00D_a>g5;mC]aBo4kLD_e>g002
00000e;mD]aBo@0200003E;LD_d005;mD]aBoE;LD_eBg5;m001BoE;l00@00003D_eBg00000Uoo`03
001oogoo00eoo`000goo00<007ooOol05Goo0P001Woo0P0000HZWRYn:YhZWP004Q`400000`5i0000
000HOol00`00Ool00007JaT00`00LaL00002KaH300000flF001_5P02KaH01G<GKaI_5VlF00000flF
00Ic5`00LaD007<FL_D2LaD01W<FL_D007<ELaIbm@9c5@0FLaH007<FLaEc5W;eLaH007<FL_Ec5W;e
LaH007;fL_Ec5VkeL_H007<FK_D2L_H0:7<FK_D006kfK_MZmVkgK_I^m`00K_MZmfkgJ_I^mf[g001R
f6KHH]QVf6;HI]QRf6KH001Rf000F[YF^EZjE[UJ^UJiF[X004jKCYY>VdjJ1`0000a6VdZKAW]6V`00
AYa6VdJLAY]6W4JK0002B[`034ZLB[a:_4ZlBY`004ZlC[a:_4jlB[a>_0<00005D]a>g4kLC]aBg002
C]`02P00D_a>g5;lD]aBo4kLD_`005;l0`0015;l00<005;lD_`01E;l0`001e;l00<007ooOol01Woo
00<007ooOol03Goo0003Ool3000EOol00`00Oomoo`07Ool01@00:YhVOBZN:Wh00P0000<B?A8L4Qd0
1@005goo0P0000QW66/IIaQ[>FLHJaUW66/i100005a^mW<GK_H006lFLaM^mW<GKaIc5fkfLaL007<G
K_Ic5flFLaL007<FL_Ec5VkeLaIbm@00K_Ec5W;eLaI^mG<F001c5VkeLaIbmG<F001c5P00LaI^mG<F
K_D006keLaI^mG<FK_D006keLaI^mG<FK_D006ke001ZmVkgJ_I_5`00K_MZmVkgJ_I^mf[f001ZmP00
H]QVnF;HI_QRf6Ki001Vf6;H001F^EZjE[UJ^UJiF[YF^EZj100001e>VTjKCYY>V`00BY]6NdZLAW]:
VdIk0016VdZLAW]:W4JKBYa6N`00AY]:_4JKB[a6VdZl001>g4Zl00@0000BC]a:_000C]aBo4kLD_e>
g5;lC]`004kLD_a>g5;mC]aBo4kL0`0000a>g5;mD]aBoDkLD_eBg000D]aBoE;LD_d200002e;lD_d0
05;mD_aBoE;LD_eBo5;m00002Goo00<007ooOol037oo0003Ool01000Oomoo`0057oo00<007ooOol0
27oo10000RZN00@0018M4Q`B7@H001Eoo`03001[6F/I00E[6@@00006LaM_5VlFKaIc5`000VlF00Ic
5flFKaI_5W<G0002KaH01W<GKaI_5P00LaL0009c5@06LaIbmG<E001c5W;e0W<E01Ic5W;e001c5G<F
L_Ec5W<E001bmG<F001c5W;e001bmG<FK_EbmW;e001^m@9bmP0BLaI^mG;f001c5Vkf001^mVkgJ_H0
06[gK_MZmVkgJ_M^m`000V[g00H006;HI]QRf6KH0004H]P01P00E[UJ^UJiF[YF^@80000<F[X004jK
CYY>VdjJCY]>VTjK001:VdIk0TJK00Y:VdIk0016VdJLAY]6W4JKAY`000=:_003BY`0000000<000I>
g004001>g4kLD]`3C]`01E;LC]`005;LD_`0100000ABg5;l000000IBo003001Bo5;l008000EBo003
001Bo5;l00ABo08000Uoo`03001oogoo00Eoo`@0009oo`000goo00@007ooOol001Aoo`03001oogoo
00Uoo`03000ZWRIm00D000044Q`B7@000IX200000`3f0000000BOol01`00IaQ[6FLHJcUW66/I00<0
0003JcUW66/i0080001aK_Ic5`00LaM^mW<GKaIc5fkfLaL007<GK_Ic5flFLaM^mP00KaIc5`00LaIb
mG<F001c5W;eLaI^mG<FL_D006keLaIbmG<FK_D007;eLaI^m@00K_Ec5P00LaI^mG<FK_Ec5P00LaI^
mG<FK_Ec5P00LaI^mG<F001_5f[f001ZmVkgJ_I^mf[fK_L006kgJ]I^m`00I_QRf6Ki001Vf6;HI_UR
f6KHH]P005JiF[YF^@00E[UJ^UJi001>VTjKCYY>VdjJCY]>VP00AW]:VdIkBYa6NdZK001:W4JKBYa6
N`07000054ZkC[a:_4jl001>g4jlC]a:_4kLC[a>g000D_e>g5;lC]aBoDkLD_`300001e;mC]aBoDkL
D_e>g5;m00800005C]aBoE;LD_e>g00300002U;LD_eBo5;mD]aBoE;l001Bg5;m100000=Bo5;m0000
1goo0P001goo00<007ooOol00goo0002Ool4000EOol00`00Oomoo`0:Ool2000012In:YhZWRZN1@00
0P5i10003goo0P0016/I0`0000=[6@00JaT01F/I00D006lF001_5W<G00=_5P05LaM_5P00KaIc5`03
KaH01P00KaI_5VlFLaL0009c5@0B001bmG<ELaEc5W;e001c5G<FL_Ec5W<ELaH007<FLaEc5W;e0P00
00Ic5VkeL_IbmG<F0002L_H04W<FK_EbmW;f001^mW;fK_Ic5P00K_L006kgJ_I^mf[gK_L000EZm`03
001Vf00000MRf00F001J^P00001F^EZjE[UJ^UJi001>VTjKCYY>VdjJCY]>VP00AY]:VdIkAY/60000
1DZKBYa:W4Zl00001dZl00<004kLC]`014kL00@004kLC]a>g0@00003D_a>g000009Bo005D]aBo5;l
D_aBg00200000e;l000000020002D_`00`00D_aBo005D_`30007D_`00`00Oomoo`06Ool00`00Oomo
o`05Ool00`00Oomoo`02Ool001]oo`8000eoo`08000VOBZN9WhZWP004Qd>70<000030GT0000000<0
00]oo`800003EaeBo00000<0000QJaUW66/i001[>FLHJcUW66/iIaQ[>FLH001^mW<GKaIc5fkfLaM_
5P00K_Ic5flFLaM^mW<G001c5fkfLaM_5W<G0080001>L_Ec5VkeLaIbmG<F001c5W;eLaI^mG<F001c
5VkeLaIbmG<FK_D006keLaI^mG<FK_D006keLaI^mG<FK_D006keLaI^mG<FK_Ec5P00K_MZmVkgJ_I^
m`00K_MZeVkgJ_I^mf[FK_L006KHH]QVnF;HI]QRf6KiH]QVf000F[YF^EZjE[UJ^UJiF[YF^@00CYY>
VdjJCY]>VTjK1@0001M:W4ZKBY`004ZlAY]:_4JKB[a6VdZl001>_4ZlC[a:^djlB[`004ZlC]a>_4kL
00H0000>C]aBo4kLD_e>g5;lC]`004kLD_e>g5;mC]aBo@<0000<D_eBg5;mD]aBoE;LD_d005;mD]aB
oE;l0P0000]BoE;l001Bg5;mD_aBoE;LD_eBo00000Uoo`03001oogoo00Eoo`03001oogoo005oo`00
6goo00<007ooOol03Goo0`000RZN00@000hL3Q`B7@H000040CP000000005Ool300000e<MEad00003
0005JaT00`00JaU[6@05JaT00`00JaT00003KaH01G<GKaH006lFLaL00flF00Ec5`00KaI_5W<G00=_
5P0NLaL007<ELaEc5W;eLaD007<FL_Ec5W<ELaIbm@00LaEc5W;eLaIc5@00L_D007;eLaI^m@00L_Ic
5Vke0W;f00mc5P00L_I^mW<FK_IbmP00L_H006kgJ_M^mf[f00001V[g00<006[g00001f;H00d006;H
001J^UJiF[YF^EZjE[UJ^P00CY]>VP0400000e:kCYX00006BY/01@00BYa:W4ZlBY/00TZL00<004Zl
B[`014Zl1@0014kL00X004kLD]a>g5;lC]aBg4kLD_`0009Bo0@0009Bo08000IBo003001Bo5;l0080
00EBo003001Bo5;l00ABo08000Qoo`03001oogoo00=oo`04001oogoo0002Ool000Moo`8000Aoo`80
00Aoo`8000Eoo`03001oogoo00moo`03000VO@0000@000033Q`B7@000081N@<000030CP001Xm00D0
0003D_aG7@000080001`EaeBo5LMD_`006LHJcUW6000IaQ[>FLHJcUW66/iIaP006LHJcUW6000K_Ic
5flFLaL007<GKaIc5fkfLaM_5P00K_Ic5flFLaM^mW<G001c5`00LaIbmG<FK_D007;eLaI^mG<FL_D0
06keLaIbmG<FK_Ec5P00LaI^m@00K_Ec5P00LaI^mG<FK_Ec5P00LaI^mG<FK_Ec5Vke001^mP00J_I^
mf[f001ZeVkgJ_I^mf[FK_MZmP00J]H006;HI]QRf6KiH]QVf000I]URf000E[UJ^UJiF[YF^EZjE[T3
000064jJD[]>VU:kCYYB^`00BYa:VdZLBY]:W4ZK0016VdZlAY]:_4JKB[a6V`00B[]>_0<00005C]a:
_000C]aBg@03C]`02U;MC]`004kLD_e>g5;lC]aBoDkL0`0000MBg5;mC]aBoE;LD_e>g00200001E;m
D]aBoE;LD_d00`0000YBoE;LD_eBo5;mD]aBo@00D_eBg0@00003D_eBo00000Moo`8000Eoo`8000=o
o`001Woo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`0@Ool200000bJN9WhVWP050003
0GT500000aiM6UdNG@0300001ULMD_aC7E<MEaeBo09C7@03001[6@0000M[6@03001[6F/I00=[6@05
001_5VlF001c5`03KaH01G<GKaH006lFLaL00flF00Ic5flF001_5W<G0002LaD04P00L_Ec5W<ELaIb
m@00LaEc5W;eLaIc5G<F001c5W<ELaIbm@80000=LaI^mG;fL_Ic5Vke001^mW<FK_IbmVkf00000fkf
00<006[f00001f[g00D006[gJ_MZm`0000=Rf08000ARf005001F^EZjE[UJ^P0200002eZiF[X004jK
CYYB^djJCY]>VU:k00001TZK00D004ZKBYa:W4Zl00D00007C]a>_4kLB[a>g4jl00001dkL00<004kL
D]`0100000=Bg5;l00001e;l0P0000=Bo00000000P000U;l00<005;lD_`01E;l0`001U;l00<007oo
Ool00Woo1@002Woo0006Ool01000Oomoo`002goo00<007ooOol00Woo00<007ooOol04Woo00@002ZN
9WhVWP8000043Q`0000000020GT700002aiM6Sd005;lEaeBo5LMD_aG7E;lEad00P0005iW66/iIaQ[
>FLHJcUW6000IaQ[>FLHJcUW66/iIaP006kf001_5W<GK_Ic5flFLaL007<GKaIc5fkfLaM_5P00K_Ic
5flFLaL007<F001c5VkeLaIbmG<F001c5W;eLaI^mG<FL_D006keLaI^mG<FK_D006keLaI^mG<FK_D0
06keLaI^mG<FK_Ec5P00LaI^mG<F001^m`00K_MZmVkgJ]I^mf[f001ZeVkgJ]MZm`00I_URf000H]QV
f@=Rf004I]T005ZjE[T200004EZjE[UJfUJi001>VU:kCYYB^djJD[]>VP00BY]:W4ZKBY`01`0000a>
_4ZKC[a:^`00B[a>g4ZlC]a:_4kL0002C]`01E;MC]a>g4kLD]d00`0000iBoDkLD_e>g5;mC]aBo@00
D_eBg5;mC]aBoE;L0`0000aBg5;mD]aBoE;LD_d005;mD_aBoE;LD_d200002U;LD_d005;mD]aBoE;l
D_eBg5;m100017oo00<007ooOol027oo0006Ool01000Oomoo`002Goo0P001Goo0P0057oo0`0000<V
WRIn00000PhL300000DJ?@00001G7E;l00@0009C7@03001[6F/I00A[6@03001[6F/I00I[6@05001_
5VlFKaIc5`02KaH00`00LaM_5P02KaH0:W<GKaH006lFLaM_5VlGKaIc5`00LaIc5G<FL_Ec5P00LaIb
mG<FLaEc5W;e001c5G<FL_Ec5W<E001bm@00L_Ic5VkeL_H007<FK_IbmVkfLaH0009^mP04L_I^mVkf
0006J_L00`00J_MZm`04J_L20008H]P200003UJiF[YJ^EZjE[UJ^UZi001>VTjKCYYB^djJCY/50000
1DjkBY]>^dZK00001dZl00P004ZlC]a>_4kLB[a>g0000TkL10000TkL00T004kLD_aBg5;lC]aBo5;L
00000U;l10000U;l0P001U;l00<005;l00000P0015;l00<005;lD_`015;l0P001goo00<007ooOol0
27oo0006Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol057oo00<002JN00001@0000<9
o00000000P0000H15`000CP001iN6Sd500001e;lEaeBo5LMD_aG7E;l0080001IJcUW66/i001[>FLH
JcUW66/iIaQ[>FLH001W6@00K_Ic5flFLaM^mP00KaIc5fkfLaM_5W<G001c5flFLaM^mW<G001c5`00
LaIbmG<FK_D007;eLaI^mG<FL_Ec5P00LaI^mG<FK_Ec5P00LaI^m@00K_Ec5P00LaI^mG<FK_Ec5Vke
001^mG<FK_Ic5P00LaH006kgJ]I^mf[fK_L006kgJ]MZmf[FK_MZe`00H]QVf@03H]P046KIH]QRf000
H]T005ZjE[UJfUJiF[YF^E[J001B^djJ100001IB^djJ001:VdjlBY]>_4ZKC[`004jlBY]>_4ZkC[a:
Vdjl001>g4ZlC]a:_0D0000>C]aBoDkLD_a>g5;mC]`004kLD_e>g5;mC]aBo@<00006D_eBg5;mC]aB
oE;L0P0000EBoE;LD_eBg5;m00<0000:D_eBo5;mD]aBoE;lD_eBg000D_`400000e;mD]`00007Ool0
0`00Oomoo`07Ool000Moo`8000Yoo`<000Aoo`03001oogoo01Eoo`8000039WhVWR9n00H000030GT0
000000@000076SdNGAXm6Ud005<MD_`00e<M00MBo5<MDaeC7@00JaT00008JaT01000JaU[6F/I0P00
0VlF00D006lFKaI_5W<G009_5P0K001c5flFKaM_5W<GKaH006lFLaL007<FLaD007;eLaIc5G<FL_Ec
5P00LaIbmG<FLaEc5P0000=c5P0<L_D007;f001^mW;fK_Ic5Vkf001^mW;f0fkf00@006kfK_H000=Z
m`03001Zmf[g00AZm`03001Zm`0000IRf00<001Rf6;H001J^EZjE[UJ^UZiF[YF^EZj0P0000mBVU:k
D[]B^e:JD[/004jkBY]>^dZKC[]:Vdjk00001TZl1@0014kL00<005;LC]`00TkL00IBg4kLC]`005;l
C]`40002D_`00`00D_aBo005D_`60002D_`00`00D_aBo005D_`30007D_`00`00Oomoo`04Ool00`00
Oomoo`07Ool001Uoo`03001oogoo01Qoo`<000068WdVWP000009o0hL200000dJ?AiM6SdNGP00EaeB
o5LMD_aG7E;lEaeBo0020000FF/iIaQ[>FLHJcUW66/iIaP006LIJcUW66/iIaU[>@00LaL007<GK_Ic
5flFLaL007<GKaIc5fkfLaM_5P00K_Ic5flFLaL007<F001c5VkeLaIbmG<FK_D006keLaI^mG<FK_D0
06keLaI^mG<FK_D006keLaI^mG<FK_Ec5P00LaI^mW<FK_D006kfLaI^mP00J_I^m`00K_MZef[gJ]I^
mf[GJ_L006[gJ]L006;HI]T00V;H00/006;IH]QRfF:h001F^EZjE[UJfUJi0080000CF]X005:kCYYB
^djJD[]>VU:k001>_4ZKC[a:VdjlBY/004ZkC[`0100000E:^dkL001>g4jl00=>g009C[a>g000D_a>
g5;mC]aBo4kL00<0000=C]aBoDkLD_e>g5;m001BoDkLD_eBg5;mC]`0100000UBoE;lD_eBg5;mD_`0
05;LD_d0100000]Bo5;m001BoE;lD_eBg5;mD_aBo@0000Ioo`03001oogoo00Moo`006Goo00<007oo
Ool05Goo0`0000=oo`0000001P0000<:700000000`0000L1>000000001iM6Sd00002Dad015;lDaeC
7E<M0P000U<M00<006/IJaT00f/I0P0026/I00@006lFKaIc5`=_5P0K001_5VlGKaIc5flFKaL007<G
KaI_5flFLaL007<FLaEc5W;eLaIc5@00L_Ec5W<ELaIbm@00009c5P0<L_Ec5W<F001bmP00K_Ic5Vkf
L_H007;f0fkf00=bmP00K_H00fkf00<006[g00001V[g00D006[gJ]MZm`0000=Rf003001Rf6;H00AR
f00<001J^EZjE[T005ZiF[YJ^EZj001B^e:J0e:k00IBVP00BY]>^dZKC[/50007C[`00`00C]a>g004
C]`00`00C]aBg00400001DkLD]`005;lD]`00e;l00ABg5;l001Bo0@0009Bo003001Bo00000EBo0<0
00MBo003001Bo5;l00ABo08000Eoo`03001oogoo00Moo`006Goo0P004goo0`001Goo0P0000@RWQim
8YhROPP000030CP15`0000@00003D_aG7@000080001WEaeBo5LMD_aG7@00JcUW66/i001[>FLIJcUW
66/iIaU[>FLHJcT006/i001c5flFLaM^mP00KaIc5fkfLaM_5W<G001c5flFLaM^mW<G001c5`00LaIb
mG<FK_Ec5P00LaI^mG<FK_Ec5P00LaI^mG<FK_Ec5P00LaI^m@00K_Ec5Vke001^mW<FK_Ec5P00LaI^
mW<FK_Ic5Vkf001Zef[gJ]I^mf[GJ_L006[gJ]MZmfKGJ_L006;H001RfF;HH]UR^6;IH]QRf@00F]X0
0P0000aF^E[JF[UJfUJi001>VU:kCYYB^djJD[/500003DjlC[]>_4jk001:^dkLB[]>g4ZkC]a:^`00
009>g003C[a>g00000@0000=D_a>g5;mC]aBo4kLD_d005;mC]aBoDkLD_d00`0000MBoE;LD_eBg5;m
D]aBo@0200000e;LD_eBo00200003E;mD_`005;LD_eBo5;mD]aBoE;l001Bg5;m00@00003D_aBo@00
00Aoo`03001oogoo00Moo`006Goo00<007ooOol03goo0`002Woo0P0000<ROR:N8Wh00P0000@5o000
0001F0<000040CL001Xm6Ud30009Dad00`00JaT00009JaT01@00JaU[6F/i00000VlF01h006lFKaM_
5W<GKaI_5`00LaM_5VlGKaIc5flF001_5g<G001c5W<ELaH007<FLaEc5W;eLaH007<FL_D3LaH02000
LaIc5W<F001bmVkf0003K_H00g;f001^mP05K_H00`00K_H00005J_L00`00J]MZm`02J_L00f[GJ_L0
0009H]P02P00F[YJ^EZjF[UJ^UZiF[YJ^@000U:k0`0000EB^e:j001>^djl00=>^`03C[a>^`0000I>
_0D0009>g006D]a>g000D]aBo4kL0U;L00=Bo4kL00000U;l0`000U;l00<005;lD_`01E;l00<005;l
00000P001E;l00<005;lD_`015;l0`001e;l00D007ooOomoo`0000Uoo`006Goo00<007ooOol037oo
0`003goo0`0000DROR:N000:70Gk00L0000=6SdJGAXm001Bo5LMD_aG7E;lEaeBo5LMD_`00P0006Q[
>FLIJcUW66/iIaU[>FLHJcT006/iIaQ[>FLIJcT007<G001c5fkfLaM_5W<GK_H006lFLaM^mW<GKaH0
06lFLaM_5W<G001c5W;e001^mG<FK_Ec5Vke001^mG<FK_Ec5Vke001^mG<FK_Ec5P00LaH007<FK_Ec
5Vkf001^mW<FK_Ic5VkfLaH006lFK_H006[GJ_MZeP00J]MZmfKGJ_MZef[g001Zn000H]UR^6;IH]QR
fF:hH]T006;I001JfUZiF]YF^E[JF[UJfUJi0P00011B^e:jE[]B^U:k001>_4jkC[a>^djlC[]>_000
C]a:^`@0000AD]a>^`00C]aBg4kLD_a>g5;LC]`004kLD_a>g5;mC]aBo00300003E;mC]aBoE;LD_e>
g000D]aBoE;LD_eBg5;m00@00009D]aBoE;lD_eBg5;m001BoE;L00@0000;D_eBo000D]aBoE;lD_eB
g5;mD_`00003Ool00`00Oomoo`07Ool001Uoo`03001oogoo00Uoo`<001=oo`03000NOP0000@00003
1O`0000000D000036SdJGAXm008000EC7@80009C7@03001[6F/I00E[6@04001[6F/IJcT3JaT04V/i
001_5flFLaM_5VlGKaH006lFKaM_5W<GKaI_5`00LaM_5P9_5`0:LaL00000LaEc5W;eLaIc5@00L_D3
LaH01G;e001c5W<FL_H00g<F00H006kfK_IbmVkf0006K_H01@00K_I^mVkf00000V[g00<006[GJ_L0
0V[g00IZef[g001Zmf[G0006H]P02P00H]QRf000F[UJ^UZiF[YJ^EZj0P0000EJ^@00D[]B^e:j00=B
^`04001>^djkC[`3C[/30007C]`00`00C]aBg003C]`015;L001Bg5;L100000=Bo5;L00001U;l00<0
05;lD_`010000U;l0P001U;l0`001e;l00<005;lD_`015;l0P000Woo00<007ooOol01goo000IOol0
0`00Oomoo`07Ool2000GOol200000b:N7WdNWP0800002@4G000000006SdNGP00EaeBo0020000GU<M
D_aG7E;lDad006/iIaU[>FLHJcT006/iIaQ[>FLIJcUW66/i001[>@00LaM_5W<GK_Ic5`00LaM^mW<G
KaIc5`00LaM_5W<GKaIc5flFLaL007<FK_Ec5VkeLaH007<FK_Ec5VkeLaH007<FK_Ec5VkeLaH007<F
001c5VkfLaH007<FK_Ic5VkfLaI^mP00K_Ic5fkfKaH006kg001ZmfKGJ_MZef[gI]L006KGJ_MVe`00
H]QRfF:h0P0000QRfF;HH]URf000E[UJfUZi0P0000eNfUZiF]X005JkD[YB^e:jE[]B^P00C[]>_004
00003djkD]`005;LC[aBg4jkD]a>_5;L001Bo4kLD]a>g00500003DkLD_a>g5;mC]aBo4kL001Bg5;m
C]aBoE;L00<00007D]aBoE;LD_eBg5;mD]`00P0000=Bo@0000000P0000eBg5;m001BoE;LD_eBo5;m
D]aBo@00D_eBg00400000e;mD_`00002Ool00`00Oomoo`06Ool001Qoo`8000Ioo`<001]oo`<00004
7Yh000001O/200000`5H0000000200000aXm000000030008Dad01@00JaU[6F/I00000V/I00I[>F/I
JaU[6F/i0002JaT03V/i000006lFLaL006lGKaIc5flFKaL007<GKaH2KaL02W<GKaI_5`00LaL007<F
LaEc5P000g<F00EbmG<F001c5W;f00=c5P07L_H007<FLaH006kf00001Vkf00<006kfK_H016kf00D0
06[gJ_MZmf[G009Zm`03001Zef[g009Zm`04001Rf6;H0003H]P01F;IH]QRf000F[X00P0000MJ^E[J
F[UJfUZiF]X00003D[/00e:jD[/00002000025:kC[]Bg4jkD[]>^e;L0006C]`500003DkLD]a>g5;L
001Bo5;LD_aBg5;lD]aBo000009Bo0<0009Bo003001Bo5;l00EBo0<000MBo003001Bo5;l00ABo0<0
00IBo004001oogoo0008Ool001Qoo`03001oogoo009oo`<001moo`L000031O/0000000D0001Q6UdF
?AYM001C7E;lEaeBo5<MD_aG7E;lDad006/i001[>FLHJcUW6F/iIaQ[>@00JcUW6F/iIaU[>FLI001_
5P00K_Ic5flFLaM^mP00KaIc5flFLaM_5W<GKaH006lFLaL007<FK_D006keLaI^mG<FK_D006keLaI^
mG<FK_D006keLaI^mP00K_D006kfLaI^mW<FK_H006kfLaM^mVlFK_Ic5`00K_L006[gJ]MZmfKG001V
ef[gI]MZn6KGJ_L00P0001ARf6;IH]QRfF;HH]URf6;I001JfUZiG]YJ^E[JF[UNfUZi001B^UJk0`00
00eFfe:j001>^e;LC[]Bg4jkD]a>^`00C[]Bg00400004DkLD]`005;mC]aBo4kLD_e>g5;l001BoDkL
D_a>g5;mC]`00`0000UBg5;mC]aBoE;LD_d005;mD]`0100000eBoE;L000005;mD]aBoE;lD_eBg000
D_aBo@0400003E;LD_d005;mD]aBoE;lD_eBg5;m001oo`0000Qoo`0067oo00<007oo00000P0097oo
0P0000<JOQYm00002@0000<JGAXm6Sd00P001e<M0P000V/I00I[>F/IJaU[6F/i0002JaT03V/iJaU[
6F/IJcU[6@00KaIc5flFKaM_5P00KaH2KaL01W<GKaI_5flG001_5P9_5`03LaL00000009c5P05L_Ec
5W<F001bmP03LaH01G;fLaH007<FKaH00W<F00<006kfK_H016kf00<006kfK_H016kf00@006kf001Z
e`9Zm`03001Zef[g009Zm`04J]MZmf[g0003H]P046;IH]QRf6;HH]T006;H001JfUZiF]YJ^E[JF[UJ
fUZi0P000UJk00]Ffe:jE[]F^`00C[]B^djkD]a>^e:k00<0000AD]a>g5;LC]aBg4kLD]`005;LC]aB
g4kLD]a>g000D]aBo0040002D_`00`00D_aBo004D_`30007D_`00`00D_aBo004D_`30006D_`00`00
D_aBo004D_`200000goo001oo`07Ool001Qoo`8002Uoo`<000037Yh0000000D000090CL00000000J
GAHm001Bo5LM00@0000hD_eC7@00JcUW6F/iIaQ[>FLI001W6F/iIaU[>FLIJcUW6@00IaT006lFLaM^
mW<G001c5flFLaM_5W<GKaH006lFLaM_5W<GKaIc5`00LaI^mG<FK_Ec5P00LaI^mG<FK_Ec5P00LaI^
mW<FK_Ec5P80000/K_Ic5VkfLaH007<GK_I_5VkfLaM^mP00J_I_5fkf001Vef[g001ZmfKGJ_QVef[g
I]L006KG001Rf6;IH]QRfF;HH]T006;IH]P005ZiF]YJ^EkJF[UJfP80000<F[T005:jE]]B^UKKD[YF
fe:j001>^e;L0`0000mBg5:k001>fe;LC]aBg4kKD]a>g000C]aBoDkLD_`01@0000UBoE;LD_a>g5;m
D]`004kLD_d0100000YBg5;m001BoE;lD_eBg5;mD_aBo@800003D_`000000080000<D_eBg000D_aB
oE;LD_eBo5;mD]`005;l100000ABoE;L000000Qoo`006Goo00<007ooOol0:7oo3@0000<F?@000000
0`001e<M0P0000I[6F/iJaT006/IJcT3JaT02V/iJaT006/IJcUW6@00KaIc5`000VlG00Ic5flFKaM_
5`00KaH2KaL01W<GKaI_5`00LaL000=c5P05001c5W<FLaIbmP02LaH00`00KaIc5P02LaH01000LaI_
5P000fkf00<006kfK_H00fkf00<006kfK_L00Vkf00<006[g00000f[g00EZef[gJ_L006KG009Zm`06
001Rf6;HH]QRf@000V;H00IRfF;H001J^E[JF[T200001UkJF]UJfP00E]]B^P9F^`03E]]B^UJk00<0
009Bf`0;D]aBfe;KD]/004kLD]a>g5;LC]aBg00500001U;lD]aBo5;L001Bg0=Bo003D]aBo0000080
00MBo003001Bo5;l00ABo0<000IBo003001Bo5;l00ABo0<000MBo003001oogoo00Ioo`006Woo0P00
:Woo30000QHm06TJGAHm001Bo5<MD_eC7E;lDaeBoE<MD_`006LI001W6F/iIaU[>FLIJcUW6@00IaU[
>FLIJcUW6@00KaH006lFLaM_5W<GKaIc5`00LaM_5W<GKaIc5flF001_5W<G001c5Vke001^mG<FK_Ec
5Vke001^mW<FK_Ec5Vkf001^mW<G001c5Vkf001^mVlFK_Ic5fkfKaH006lGK_I^mf[fKaL006[gI]MZ
n6KGJ_MVef[h001Zn6KGJ_P006;IH]QRf@00H]URf6;iH]QRf@00G]X00P0000]J^EkJF[UNfUZiG]X0
05KKD[YFfe:j0080000<F]]F^P00D[]Bg5:kD]aB^e;L001Bg4kK100000eBo5;L001>g5;mC]aBo4kL
D_e>g000C]aBo@0300003E;mD]`005;LD_eBg5;mD]aBoE;L001Bg5;m00@0000<D_aBo@00D_eBo5;m
D]aBoE;lD_d005;m100000]Bo5;m001BoE;lD_eBg5;mD_aBo@0000Qoo`0077oo00<007ooOol0:Goo
2`0011Hm0P001e<M0P0000=[6F/iJaT00V/I00i[>F/I001[6F/iIaU[>F/IJcUW6@00KaMc5flF0VlG
00Ic5`00KaM_5g<GKaH2KaL01@00KaM_5flGLaL00P000W<F00EbmW<FLaIc5P0000=c5P09KaH006lF
LaI_5W<F001^mP0000E^mP03001^mfkf009^mP06K_L006kg001Zmf[G0f[g00T006[gJ_MZmfKGJ_L0
06;I00000V;H00IRfF;HH]QRf6;I0002F]X02EkJF]UJfU[JG]YJf@00E[]Ff`020002E]/015KJE]/0
05;L0e;K00=Bg5;KD]/00P001e;L00L005;LD_aBg5;lD]aBo0030006D_`00`00D_aBo004D_`30007
D_`00`00D_aBo003D_`30007D_`00`00D_aBo004D_`20007Ool001eoo`03001oogoo02Yoo`800003
6WhFO@0000P0008F?@03001C7E;m00@0001VDae>o@00IaU[>FLIJcUW6@00IaU[>FLIJcUW6F/iIaT0
06LI001_5W<GKaIc5`00LaM_5W<GKaIc5flF001_5W<GKaIc=flFLaL007<FK_Ec5VkeLaH007<FK_Ec
5VkfLaH007<GK_Ic5VkfLaL006lFK_Ic5fkfKaI^mP00K_I^mf[fKaM^mP00J_I_5`00J_MVef[h001Z
n6KGJ_QVef[hI]MZn000H]URf6;iH]QRfF;HH_T006;i001NfUZiG]YJ^EkJF[UNfUZi0P0000aFfeJj
F]]F^UKKE[YJf`00D]aB^e;LD[/2000035Kl001Bo4kKD_aBg5;lC]]Bo000D_a>g0@0000<D_aBg000
C]aBoE;LD_a>g5;m001BoE;L100000YBoE;L001Bg5;mD_aBoE;LD_eBo080000AD_d00000001BoE;l
001Bg5;mD_aBoE;LD_eBo000D]aBo@0400000goo001oo`06Ool001ioo`03001oogoo02]oo`<00003
5Wd0000000@000034Sd0000000<000MC7@0=001[6F/iJaT006/IJcUW6F/iJaU[>FLI00000V/i00EW
6@00KaMc5`00009_5`05LaM_5VlGKaL00003KaL01W<GKaM_5`00KaL000=c5P0?L_H007<FLaI_5W<F
001c5VlFLaI_5W<F001_5P0000A^mP0;001^mVkfK_I^mfkf001^mVkgK_H00002J_L01@00J_MZmf[g
I]L00f[g00@006[g001Rf@=Rf006H]T006;IH]QRf@000U[J00=NfU[IF]X00P0000EJf@00E]]FfeKJ
00=Ff`04E]X005;KD]`200001E;KE]aBfe;K00001U;L0`0000QBg5;lD]aBo5;LD_aBg0001E;l0`00
1e;l00<005;lD_`015;l0`001U;l00<005;lD_`015;l0`001Goo00<007ooOol01Goo000OOol2000/
Ool00`006Yh00008000011Hm4S`F?@000e<M071>oE<MDaeC7Dkm001W6@00IaU[>FLIJcUW6F/iIaT0
06LIJcYW6F/jIaT006lF001_5W<GKaIc5flFLaL007<GKaIc=flFLaM_5P00KaMc=`00LaI^m@00K_Ec
5VkfLaI^m@00K_Ic5VkfLaM^mP00K_Ic5`00KaI^mP00K_I^mf[fKaM^mVkg001_5f[fK_MZmP00I]L0
06KGJ_QVef[hI]MZn000J_QVe`00H]QRfF;HH_T006;iH]QVnF;H001J^EkJF[UNfP00G]YJfEkJF]T0
05JjE]]F^U[KE[YFf`<00009E]aBfeKlD]]Fg5;K001Bg5;l00@0000=D]]Fo000D_a>g5;lD]aBo4kL
D_`005;lC]`00`0000eBg5;m001BoE;LD_eBg5;mD]aBo@00D_eBg004000035;mD_`005;LD_eBo5;m
D]aBo@00D_eBg0@000Qoo`03001oogoo00Eoo`008Goo00<007ooOol0:Woo0P0000<JOAYn6Wd01`00
00<B?AHm00001e<M0P0000Q[6F/iIaU[>F/IJcUW6@000V/i00UW6F/iJcU[>FLI001_5g<GKaH00VlG
00Ec5`00KaM_5g<G00=_5`03001_5flG009_5`05001c5P00LaI_5P02LaH02@00KaIc5VlFLaI_5P00
KaIc5`02KaH00`00K_H00002K_H02fkgK_I^mP00K_M^mVkgK_I^mfkf00000V[g01EVef[gJ_MZm`00
J_MVmf[hI]L006;HH]T006;IH]QRfF;HH]URf000F]T00P0000=NfU[IG]X00UkJ00<005KKE]/01000
00EJfeKJ001BfeKL00=Bf`05E]aBf`00001Bo003D]`02U;lD]aBg000D_aBg5;lD]aBo5;L0`001U;l
00<005;lD_`015;l0`001U;l0P000e;l1@0037oo00<007ooOol01Goo000ROol00`00Oomoo`0[Ool>
0002Dad40000IE<NCad00000JcUW6F/iIaT006LIJcYW6F/jIaU[>VLI001W6@00KaIc5flFLaL007<G
KaIc=flFLaM_5P00KaMc=flGLcM_5g<g001c5VkfLaI^mG<F001c5VkfLaM^mP00K_Ic5fkfLaM^mW<G
001^mf[fKaM^mVkgJ_H006[fK_MZmVlGJ_H006[f001Vef[hI]MZn000J_QVef[hI]MZn000H_T006;i
H]QVnF;HH_URf6KiH]P005[IG]YJfEkJF]UNfU[IG]X00P0000aFfU[KE]YJneKJF]]FfP00D]]Fg5;K
E_`2000035;K001Bg5;lD]]Fo5;LD_aBf`00D]aBo0@0000<D]aBo000D_aBg5;mD]aBo5;L001Bg5;m
100000UBg5;m001BoE;LD_eBo5;mD]`01@004Goo00<007ooOol01Goo000SOol00`00Oomoo`0[Ool2
00047Yh400000`hm3Q`000020002Dad01TlMDaeC7E<MCaeC7@800005IaT006/iJcUW6@03JcT02FLI
001[>F/jIcT006lGLaL00002KaL01W<GKaM_5flGLaL000E_5`03001_=`0000=c5P08001c5VlFLaI_
5W<F001c5`=_5P05LaL006lG001^m`03K_H02P00K_I^mfkfK_M^mVkg001^m`000f[g01EVe`00I_MZ
n6KGJ_MVmf[h001RfF;HH]URf6;IH]QRfF;H001Rf000F]T00ekJ00eJfEkJ001NfP00F]]Ffe[KE]YJ
feKKF]/00002D]/20002E]/01EKlE]/005;LD_`00e;L00IBo000000005;lD]`3D_`00e;L001Bo005
D_`30006D_`00`00D_aBo0040003Ool00`00Oomoo`0@Ool00`00Oomoo`05Ool002Aoo`03001oogoo
02aoo`@000037Wd000000080000=4Sd>718m001C7TlMDai?7E<NCaeC7TlMDah00P0006MW6F/jIaU[
>VLIJcYW6@00IaU[>VLIJcYW6@00KaH006lFLcM_5W<GKaIc=`00LcM_5g<gKaMc=flG001_5g<h001c
5Vkf001^mW<GK_Ic5P00LaM^mW<GK_Ic5fkf001^mW<G001^mf[fKaL006kgJ_I_5f[fK_L006lGJ_I^
m`00J_QVe`00I]MZn6KGJ_QVef[h001Zn000I_URf6;iH]QVnF;H001Rf6Ki001NfU[IG]YJfEkJ001N
nUkI001FfU[kE]YJfeKJF_]FfP0300002E;KE_aBfeKlD]]Fo000E_aBg004000035KlD]/005;LD_aB
g5;lD]aBo5;L001Bg0@00009D_aBg000D_aBoE;LD_eBo5;m00<000Moo`03001oogoo015oo`03001o
ogoo00Aoo`009Goo0P00;Woo00<002JN00001P0000@>718m0000009C7@03CaeC7E<M00800004Cai?
7@00IaT3JcT01FLI001[>F/jIcT00V/i00E[>VLi001_5g<G00=_5`03LaM_5`0000E_5`05001_5flG
KaM_=`0200001VlFLaI_5W<FKaH000=_5P03LaM_5P00009_5`0IKaH006kfK_L006kgK_I^mfkfK_L0
06kgJ_M^mf[g001Ve`00I_MZn6KGJ_MVmf[h00000VKh00D006;HH]URf6;I00800007H]QRnF;HH]T0
05kJF]T00P0000UNfUkIG]YNfP00E]YJfeKKF]/00P0000=Jfe[k00000UKK00EFo5KKE]]FfeKl0080
0003D_aFo5;L009Bo003E_aBg000009Bo003D]aBo5;l00<000MBo003001Bo5;l00<000]oo`03001o
ogoo011oo`03001oogoo00Aoo`009goo00<007ooOol0;7oo0P0000<V_RJN:[l0200006]?7E<N0000
04lMDai?7E<nCad006LIJcYW6@00IaU[>VLIJcYW6F/jIaT006Li001_5W<GKaIc=flF001_5g<gKaMc
=flG001_5g<hKaMc>6lGLcP007<GK_Ic5Vkf001^mW<GK_Ic5fkf001^mW<GKaIc5fkf001^mP00J_I_
5f[fK_L006lGJ_I^mf[fKaMZmP00I]MZn6KGJ_QVef[h001Zn6KGJ_QVe`00H]QVn@00I_URf6KiH]QV
nF;H001Jf@00F]UNnUkIG_YJfEkj001JfeKJ0080000:F_]FfU[kF]YJn`00E_aBfeKlD]/2000035Kl
001Fo5;KE_aBfeKlD]]Fo000D_aBg0<0000:D]aBo000D_eBg5;lD]aBoE;LD_`3000?Ool00`00Oomo
o`0?Ool00`00Oomoo`04Ool002Qoo`03001oogoo02eoo`T0000B2Q`00000001?7TlMCai?7DlNCae?
7TlM001W6@00JcU[>VLi0V/i00I[>VLi001W>V/jIcT200000g<GKaL00005KaL01@00KaM_5flGKcL0
0VlG00H006lh001c5VlF0003KaH01W<GKaI_5P00KaM_5P=_5`0EKaH006kfK_M^mVkgK_H006[gK_MZ
mfkgJ_L006[g001Vef[gI_MZn000009Vn00?J_QVmfKh001Rf@00H]URf6;iH]QRfF;HH_URf000009N
fP06G]UNfUkJG]YNfEkJ0P0000EJfU[KF]]Jne[J009Jf`03001FfeKK00800005E]]FneKKE_`00002
D_`015KlD]aBo5;l0`001U;l00<005;lD_`010004Woo00<007ooOol03goo00<007ooOol017oo000Y
Ool00`00Oomoo`0]Ool01P00;[l^_S;O;[h^_`@0000:1O`004lMDai?7E<nCaeC7TlMDch20000DVLI
JcYW6F/jIaU[>VLI001W>F/jIcU[>VLiJcX007<G001c=flGLcM_5g<g001c>6lGLcQ_5g<h001c>6lG
KcP007<G001c5fkfLaM^mW<G001c5flFLaM^mW<GKaH006kf001ZmVkgJ_H006[fK_MZmVlGJ_I^m`00
KaL006[hI]MZn6KG001Vef[hI]MZn6KGJ_P006KiH]QVnF;HI_URf6Ki0P0000MRf000G]UNnU[IG_YN
f@0200002F;j001JneKJF_]JfU[kE]YJn`0300002EKlE]]Fo5KKE_aFf`00D]]Fo00400002E;KE_`0
05KlD]aBo5;LE_aBg003000GOol00`00Oomoo`0>Ool00`00Oomoo`04Ool002Yoo`8002ioo`8000<^
_P03;[l0000000D00003Cai?7@0000<0009?7P0@001W>F/iJcU[>VLi001W>V/jIcU[>VLjJcYW>F/j
0005KaL01000KaM_5flg0flG00H006lGKcQ_=flh0002KaH01W<GKaI_5VlF001_5P=_5`03KaI_5`00
009_5`0;001^mP00J_M^mf[gK_MZmfkg001^m`02J_L01`00J_QVe`00I_QZn6Kg009Vn00:J_P006Kh
001RnF;HH]URf6;i0002H_T00fKiH]P00002G]X02EkI001NfUkjG]UNnP00F_]JfP02F]/20002F_/0
2000E]]FneKKE_aFfeKkE]/2000025KlD_aFo5;lE_aBo5Kl0002D_`3000KOol00`00Oomoo`0=Ool0
0`00Oomoo`04Ool002aoo`03001oogoo02eoo`T0000i1O/00000001;7DlnBai??T/MCci;7P00IaU[
>VLI001W>F/jIcU[>VLiJcYW>F/j001[FP00LcM_5g<g001c>6lGLcQ_5g<hKaL006lGKcQ_5g<h001_
>000LaM^mW<GK_H006lFLaM^mW<GKaIc5`0000=_5`0V001_5`00K_MZmVlGJ_I^m`00KaMZmflGJ_L0
06KG001Vef[hI]MZn6KGJ_P006[hI]MZn000I_URf6Ki001VnF;HI_URf6Ki001NnP800008G]URnUkI
G_YNf@00F]YJn`80000:F]YJne[JG_]JfP00E]]Fo5KKE_`200002EKK001BfeKlD]]Fo5;KE_aBf`03
000OOol00`00Oomoo`0<Ool00`00Oomoo`04Ool002eoo`03001oogoo02eoo`06000f_SKN=[hfgSJn
100000<5n`0000000dlN015??TlNCai?7P00IcT006LjJcYW>F/jIcY[>VLiJcX006/j009W>P800004
KaL006lGKcL3KaL01`00KaM_>6lgKcQ_5`00009_>005001_5VlF001_5P03KaL00flFKaL00005KaL0
2000K_MZmfkgJ_M^mf[g0003J_L01VkgJ_L006KhJ_QVm`9Vn008J_P006KhI_QZn6Kh001Rf080009R
n@0>I_URf6;iH_UVn@00G_YNfUkjG]UNnUkJG_YNf@800003F_]JfU[k009Jn`05F]YJn`00E_aFf`02
00002EKlE_]FneKk001Bo5KlD_aFo002000ROol00`00Oomoo`0<Ool00`00Oomoo`04Ool002ioo`03
001oogoo02eoo`800004=]lf_SKO<[h8000014lnBai??T/M0`0000MW>F/jIcU[>VLiJcYW>@020000
86]JIcY[FVLjJeYW>P00KaMc>6lGLcQ_5`00KaM_>6lGLcQ_5`00KaM_>6lGKcP007<G001c5fkfLaM_
5W<G0003KaL0;VkfKaL006lH001_5f[fK_MZmP00J_M_5f[gKaMZm`00J_L006KGJ_QVef[hI]L006KG
J_QVef[hI]L006;HI_URf6KiH]QVnF;HI_T006Ki001RnUkIG_YNfF;j0P0000UNf@00F]YJne[JG_]J
fU[kF]X00`0000UFfe[lE]]Jo5KKF_`005KlD]/00P009Goo00<007ooOol037oo00<007ooOol00goo
000_Ool2000_Ool:00000`7J0000000300000d/NBci;7P0200001f/jIcY[>VLi001W>V/j00=W>P05
JcYW>P00IcX00003KaL026lg001_>6lgKcQ_5flh0005KcP01@00KaM_5flGKaH00VlG00<006lGKaL0
0flG00L006lGKaL006kgJ_L00003J_L00fkgJ_L00003J_L01`00I_QZn6Kg001Vn6[h00=Vn006001V
n000H_UVnF;H0V;i00YVn@00I_URnFKi001NnUkJG_X0009NnP03H_YNn@00009Jn`08F]YJn`00001J
nU[k001Fo0=Fn`03E_aFn`00008002Qoo`03001oogoo00]oo`03001oogoo00=oo`00<Goo00<007oo
Ool0;Goo00H003kO>[hngSZn?]l500002@7J001;?d/NBci;7T/oBai;?P0200003FLi001W>V]JIcY[
FVLjJeYW>P00IcY[FfLj0080000ELcP006lhKaMc>6lGKcP006lhKaM_>6lGKcP006lh001c5flFLaM^
mP00009_5`0]K_I_5flG001ZmflHJaM_6000KaL006lGJ_M_5f[gKaL006lHJ_M[66[g001Ve`00I]MZ
n6KGJ_QVe`00I_QZn6KG001Rf6KiH]QVn@00I_URf6KiH]P005kI00800008H_YNfF;jG]URnP00G_]J
fP800008G_]JnUkkF]YNn`00F_aFf`<002]oo`03001oogoo00]oo`03001oogoo00=oo`00<Woo00<0
07ooOol0;Goo0P0000@jgSkN>]hjgPP00004Bai;?T/NBch400000fLjJcYW>P02IcX046/j000006Lj
Ie]W>VMJIcYWF`00KcQ_=flhKaM_>0001Flh00D006lhKcQ_>000009_5`03001_5flG00=_5`03001_
5flG00A_5`04001Zmf[gK_L2J_L00`00J_MZm`04J_L00`00I_QZn003I_P01V[h001Vn6KhJ_P0009R
n@0:I_T006KiH_UVnF;hI_URn@00G_T2G_X01F;jG_UNnUkjH_X00P0000QJnUkkF_YJne[jG_]JnU[k
0P00;goo00<007ooOol02Woo00<007ooOol00goo000cOol00`00Oomoo`0^Ool400001D;N?]i2gP00
:Yh01`0002Q7?dLNAcm77P00IcY[FVLjJeX006MKIcY[FfLjIe]W>V]K001WF`00LcQ_5flhKaL006lG
KcQ_5flhKaL006/HKcU[>6lh001c5`00KaM^mP=_5`0k001_66/GKaQZmflH001_6000KaMZmflG001_
66[gJaQZmflHJ_L006[g001Vef[hI]MZn000J_QVef[hI_QZn000I_T006KiH]QVnF;HI_URf000H_P0
05kIH_YNfF;jG]URnP00H_X005kkF_YNne[JG_]JnP02000bOol00`00Oomoo`09Ool00`00Oomoo`03
Ool003Aoo`8002moo`03000ngT;N00<ngP04@]h00000:Yh300001dLNAcm77TLoAai7?dLN0080000:
JcX006MJIcYWFfLjIeYW>VMK0003Ie/01000KcQ_=`001Flh00<006lhKcP016lh00<006lGKaL00flG
00<006lGKaL00flG00L006lHJaQ_6000J_L00006J_L01000J_M[60000VKh00EZn000I_QVn6[h00=V
n00>J_P006KiH_UVnF;hI_URn@00H_UVn@00H_YNn@9NnP03H_X006;j009RnP04001Jne[jG_/2000e
Ool00`00Oomoo`08Ool00`00Oomoo`03Ool003Ioo`03001oogoo02eoo`800004@]hngD;N?]h80000
14LoAai7?dLN100000IWFfLjJe]W>VMKIcX200000fMKHcYWF`02Ie/04@00LcP006lhKaM_>6lG001[
66liJcQ_>6/HKcT006li00000flG034006lHJaM_66[gKaQ[5`00JaM_66/G001Zm`00J_M[66[gKaQZ
mf/H001[66[gJaP006[h001Zn6KGJ_QVn6[hI]MZn000J_P006KiH]QVnF;H001Rn6KiH]QVn@00H_YN
f@0200001V;jG]URnUki001JfP8003Moo`03001oogoo00Qoo`03001oogoo00=oo`00=goo00<007oo
Ool0;Woo10000T;N00=2g@00;Yh01`0000Xo7d<o?am37`00Ie]W>VMJIcX000QWF`03001_>6lh009_
>003001_>6lh00A_>004001_>F/iKcT200000flG001_5`04KaL01`00JaQ_66/GKaQ[600000IZm`0:
001[66[gJ_QZm`00I_P006KhJ_P3I_P02V[h001Vn6KhJ_P006KiH_T006;i0fKi00ERn@00G_X005ki
00=RnP04G_URnV;j000jOol00`00Oomoo`08Ool00`00Oomoo`02Ool003Qoo`03001oogoo02ioo`07
0016gT;MA_i2gDKN@]d00P0000<b_P0000000P0000Ho7T<o?ai3?clN@cl200001FLj001WFfMKHcX0
0fMK04aS>P00001WG000KcQ_5flh001_>F/hKcQ[66li001_>F/hKcU[>6liJcP006/GKaQZmflHJaL0
06/GKaQ[5flHJaL006/H001ZmflHJ_M[6000JaQZmf/HJ_M[66[g001Vef[hI_QZn6KGJ_P006[hI_QZ
n6Kh001Rf000H_QVnF;HI_URn6KiH]P005kiH_YNfF;jG_URnP8003aoo`03001oogoo00Moo`03001o
ogoo009oo`00>Goo0P00;goo0P0000A2gD;N@]i2gQ0000IWF`800007He]SG6=KIe`006lh00001Flh
00X006liJcU_>F/hKcU[>@00JcT000=_5`0:001[66lHJaM_66/HKaP006/H0003J_L02P00JaQZmf[h
J_M[66[g001Zn0000fKh00EZn000I_QVn6[h00=Vn003001RnFKi009Vn@06H_UVnFKi001Rn@000V;j
00=NnF;j0000?Woo00<007ooOol01goo00<007ooOol00Woo000kOol00`00Oomoo`0^Ool400001DKn
@]e6oP00=[h01@0000Hk7cLO>alfoc/O=al20002Ie/200005FMlHe]WG6=KIgaSFfML001_>F/hKcQ[
66liJcP006/hKcU[>6liJcP00003JcT0<P00JaM_6000KaQ[5flHJaM_6000KaQ[66lH001[66[g001Z
mf/HJ_M[66[g001Vmf/HJ_L006KGJ_P006[hI_QZn6KhJ_QVn000I_P006;HI_URn6KiH]P006;hI_UR
n000G_T20010Ool00`00Oomoo`06Ool00`00Oomoo`02Ool003aoo`03001oogoo02ioo`050016gDKM
A]e6gP02A]d00`00=[hf_P02=[h30002>al00cLO>al0000300001f=KIeaSFf=LHe]WG6=K00800003
He`006lh00=_>007001[>FliJcQ_>F/i000016/i00T006lG001_66/GKaQ[66lH000016/H00/006[g
001Zmf[hJ_M[66[gJ_P006/H009Zn003001Zn000009Vn005J_QVn6KhI_P00003I_P00`00H_UVn@02
00001V;iI_UVnFKiH_T004=oo`03001oogoo00Eoo`03001oogoo009oo`00?Goo00<007ooOol0;Woo
0P0000=6oTKMA_h01@000SJn1P0000lc7bkn<_l^oP00He]WG6=KIgaSF`00GeaSO5mLHg`00P0000Q[
>000JcQ_>F/hKcU[>0000f/i03=_FV/iJcT006lHJaM_66/GKaQ[5`00JaQ_66/HKaQ[6000J_M[66[g
JaQZmf/H001[66[gJaQVmf/H001Zn6KhJ_QVn6[hI_P006KhJ_QVn6/I001Vn@00IaURn6KiH_QW6F;h
0000AGoo00<007ooOol017oo00<007ooOol00Woo000nOol00`00Oomoo`0_Ool30003A]d00`00>[h0
000600001S;o;_h^obko<_l^oP800003Ie`0000000MSG007001[>FliJcQ_>F/i00001V/i00P006/j
001_66/HKaQ[5`001F/H00T006/H001Zmf/HJ_MZn000JaP00f[h00E[6000JaP006[h00=Vn005J_P0
06KhI_QZn002I_P00`00I_URn@03I_T00f;i001oo`15Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0
03moo`80031oo`06001:oTKMB_i6gD[n0P0000<f_C[N>[h0300000MSO5mLHgaOG6=lGeaSO0020000
1U]L000006liJcP000=[>@0cKeY[>F/i001[FVLiJcX006lHJaL006/HKaQ[66lHJaP006/HJaU[6000
J_M[6000JaQZmf/HI_M[6000JaQVn6/H001Zn6KhJ_P006[hI_Q[6FKhJ_P006/I001VnF;hIaURn000
04Qoo`03001oogoo00Aoo`03001oogoo005oo`00@Goo00<007ooOol0;Woo00<004KMA]d00TKM3000
1BKN0P000f=L0P000emM00AOG5mM000000I[>@03001[>VLj00=[>P03001_600000A[6009001[66/H
JaQ[6F/H001Zm`0000=Zn00:JaP006/HJ_Q[66[hJaP006[h0002I_P01F[hI_QVn000J_P00VKh00@0
06KiH_T004Yoo`03001oogoo00=oo`03001oogoo005oo`00@Woo00<007ooOol0;Woo100000U6gD[n
A]d003Zm?]hj_CkN>[d03@0000EOG5mmFeaOOEmL00800005FgiKG@00JcU_FP02JcT0<000JeYW>F/j
IcU[FVLiJcX006lHJaQ_66/HKaP006/IJaQ[6F/HJaU[6000J_M[66KgJaQZm`00I_Q[66KhJaQVn6/H
001Zn6KhJaUVn6[h001[6FKhJaUVn000H_P004aoo`03001oogoo009oo`03001oogoo005oo`00@goo
00<007ooOol0;Woo00D004[MB]e:oDKM009:g@07000j_SkN?[hngSZn00000RIn0`0000DN_QZM7[hJ
_Ajn0080009OG@8000EKG@800004JcT006/jIcX3JcX01FLj000006Lj00000f/H00@006/HJaQ[6@=[
600A001W6@00J_Q[66[h001Zn6/HJ_Q[66[hJaP006/H001Zn003I_P01`00I_QVn6KhJ_QVn00004eo
o`03001oogoo009oo`03001oogoo005oo`00A7oo0P00;goo0P0000=6gD[mA]d02`0000<RG@000000
200000QKGUMMFgiKGE]NEeeKOU]M0P0002m[FVLiJcYW>F]JIcT006LjIe]W>VLk001_6000JaU[66/I
JaQ[6F/H001W66/IIaP006[g001Vn6/HI_Q[66KhJaP006/II_Q[6@00J_QVn000I_Q[6FKhJaUVn000
04moo`05001oogooOol00003Ool004Ioo`03001oogoo02ioo`<000=:g@03000n_SkN008ngP03?[h0
02Yn00H0008FO@035YdBO@0000IKG@80009GGP06001[>V/jJcYW>P001VLj00@006/HJaQ[6@9[6080
000DIaU[6F/IJaUW6@00J_Q[66[hJaQZn6/H001[66KhJaQVn000I_P000=Vn003J_QVn000055oo`04
001oogoo0003Ool004Moo`03001oogoo02ioo`06001:gD[mA]e:oT[M0P0000A2gSjm@]hn_@800003
:YhVOBZN00H000054W`00000FeiGG@0200001eMNDceGGU=MEeh006]J0080000XIcYWFfLjIc]W>VMK
001W>`00JaU[66/I001[>FLHJaUW66/iIaP006LI001Vn6/HI_Q[6000JaUVn6/II_Q[6FKh001Vn6/I
I_Q[6FKh001BOol01000Oomoo`000goo0018Ool00`00Oomoo`0^Ool00`00B]e:o@02B]d;000012ZN
000000Gk1`0000ECGUMNEeiGGU=N009GGP8000MW>P09001W>f<kIc/006/H001[6FLI00=[6@03IaT0
06LI009W6@0?001Zn6/H001[66KhJaQVn6/HI_P006Kh001Vn6[h009Vn003001oogoo055oo`03001o
o`0000=oo`00BGoo0P00;goo100000]>oD[MB_d004;N?[e2gSjm@]h002jN00D000032O`0000000@0
0003DceGGU=M00<00007CciCGP00Ie]W>VLkIcX00P00029W>f<jIc]S>VLk001[>FLHJaUW66/iIaP0
06LIJcYW6F/I001[6000JaUVn6/II_Q[6FKh001Vn6/II_P006KhJaT005Eoo`03001oo`00009oo`00
Bgoo00<007ooOol0;Goo00P004[MB_e:gD[mB]e:o@000d;N00=2gD;N000012jN1P000PXl0`0000=?
?U=NCch00Tln00iCGP00001W>P00HcYW>f<kIc]S>VLk001S>`000f/I00=W6F/I00001FLI00l006/H
I_Q[66KhJaQVn000I_Q[6FLHJaT006Kh0000Egoo0P000Woo001<Ool00`00Oomoo`0]Ool200000d[m
B]e>o@0;0002;Yh00`003O`0000500001`YL000004lnDei??U=O00@0000SHcYW>f<jIc]S>VLk001S
?5lkHc/006/iIaQ[6@00JcYW6F/IIaU[>P00IaX006/II_Q[6FKhJaT006/II_Q[6FKhJaT0001HOol2
0002Ool004eoo`03001oogoo02ioo`<0000;B_e:gD[m0012gT;M@]i2gD;N000bWP0500000`hL0000
00090002Bch01T/oBch006<kIc]S>P8000ES>`03001[6@0000EW6@0?001W6FLIIaX006/HI_Q[6000
JaUW66/II_Q[6@0005Uoo`80009oo`00CWoo0P00;goo00H004kmB]a>oD[MC_d2000014;M@]i2_DKN
0P0000<^WC:n<Yh02@0002T66`00Bai;?d/NBcm;7T/oBah006<j001O6f<lGc]S>elKHcaO>f<k001[
>VLIJaUW6F/j001W6VLIIcYW6FLJ001[6@00JaUVn6/II_Q[6@0005Ioo`@000Aoo`00D7oo00<007oo
Ool0;Goo00D004[mB]e:oD[M00/00004<Yh0018M5Sd9000014/oBci;?T/n0`001f<k0P0000=O?000
IaT00VLI00@006LIIaUW6P=W6@08IaX006/IIaQ[6FKhJaT005=oo`@000Qoo`00DGoo00<007ooOol0
;Goo10002goo1@0000<B700000002@0000=37TLO@ah00P0000=S>elKHc`00P0000eO6f<lGa]O?000
JcX006LJIaUW>VLIIaYW6@0200001VLJ001[6FKhJaT0051oo`@000aoo`00DWoo00<007ooOol0;7oo
00<007ooOol04Goo2`0000A77TLOAai77`D00008GcaO>ellGc]O?5lkGc`0009W6@06IaYW6FLIIaT0
06<J0fLJ00<006/I0000CGoo100047oo001COol2000/Ool00`00Oomoo`0EOol;00002T<O?_i37ckn
001O6f<lGa]O?5lK0P0000iO?000IcYW6FLJIaT006<IIaYS6FLjHaUW6P00BWoo100057oo001EOol0
0`00Oomoo`0YOol00`00Oomoo`0GOol800002D;o?_i37ckn@_lnoP00Gc]O?00200001U/LFcaK?5ll
001W6@800007HaYW6VLJIaYS6VLJ0000B7oo0`0067oo001FOol00`00Oomoo`0XOol00`00Oomoo`0I
Ool400000`Gk1O`00008000045llFaaO?5/KGcaK75ll001W>V<IIaYS6FLjHaUW6P00AGoo10006goo
001GOol00`00Oomoo`0WOol00`00Oomoo`0KOol400002PGl1O/003[n?_ljoS[o>_h005/L0U/l00IO
?5/L000005/l0003IaX00f<J00000012Ool4000OOol005Qoo`03001oogoo02Ioo`03001oogoo01eo
o`H00008>]hnoc[N?_ljgP00Fa]O?0800004EaaK?ELLFcd200000f<I001oo`0oOol4000SOol005Uo
o`8002Ioo`03001oogoo01moo``0009K7005FcaK75/LFaaK?002000mOol4000WOol005]oo`03001o
ogoo02=oo`03001oogoo029oo`@0000:>]lfgS[o=]h005LLFceG75/mEa`2000kOol4000[Ool005ao
o`03001oogoo029oo`03001oogoo02Eoo`@00003>]hfgP00009K708003Yoo`<002moo`00GGoo00<0
07ooOol08Goo00<007ooOol0:Goo1@00>7oo1000<Woo001NOol2000QOol00`00Oomoo`1ROol4000f
Ool0061oo`03001oogoo01ioo`03001oogoo05ioo`@003Yoo`00HGoo00<007ooOol07Goo00<007oo
Ool0FWoo1000?Woo001ROol00`00Oomoo`0LOol00`00Oomoo`1FOol40012Ool006=oo`8001aoo`03
001oogoo05=oo`<004Ioo`00IGoo00<007ooOol06Goo00<007ooOol0Cgoo1000BGoo001VOol00`00
Oomoo`0HOol00`00Oomoo`1;Ool4001=Ool006Moo`03001oogoo01Moo`03001oogoo04Moo`@0055o
o`00J7oo0P005goo00<007ooOol0@goo1000EGoo001ZOol00`00Oomoo`0DOol00`00Oomoo`10Ool3
001IOol006]oo`03001oogoo01=oo`03001oogoo03aoo`@005aoo`00K7oo00<007ooOol04Woo00<0
07ooOol0>7oo1000H7oo001]Ool2000BOol00`00Oomoo`0dOol4001TOol006moo`03001oogoo00mo
o`03001oogoo031oo`@006Qoo`00L7oo00<007ooOol03Goo00<007ooOol0;Goo1000K7oo001aOol0
0`00Oomoo`0<Ool00`00Oomoo`0ZOol3001`Ool0079oo`03001oogoo00]oo`03001oogoo02Ioo`@0
07=oo`00Lgoo0P002goo00<007ooOol08Woo1000Mgoo001eOol00`00Oomoo`08Ool00`00Oomoo`0N
Ool4001kOol007Ioo`03001oogoo00Moo`03001oogoo01Yoo`@007moo`00Mgoo00<007ooOol01Woo
00<007ooOol05Woo1000Pgoo001hOol20006Ool00`00Oomoo`0COol30027Ool007Yoo`03001oogoo
00=oo`03001oogoo00moo`@008Yoo`00Ngoo00<007ooOol00Woo00<007ooOol02goo1000SWoo001l
Ool01@00Oomoogoo00002Goo1000TWoo001mOol200000goo001oo`04Ool4002FOol007moo`800003
Ool00000008009Yoo`00P7oo0P00WWoo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {232.563, 0}} -> {-0.0884213, 0.0137402, \
0.00364336, 0.00364336}}]
}, Open  ]],

Cell[TextData[{
  "Another non-trivial similarity reduction for the FP equation follows from \
the subgroup ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k3",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  ". The infinitesimals for this subgroup read"
}], "Text",
  CellTags->"nontrivial similarity reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1, k4 \[Rule] 0, 
          k5 \[Rule] 0, k6 \[Rule] 0, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{1\/2\ E\^\(\(-2\)\ \[Tau]\)\ v, 
        \(-\(1\/2\)\)\ E\^\(\(-2\)\ \[Tau]\)}, {
        \(-\(1\/2\)\)\ E\^\(\(-2\)\ \[Tau]\)\ P}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The reduced FP equation represents a second-order ODE. The similarity \
variable ",
  StyleBox["zeta1 ",
    FontSlant->"Italic"],
  "combines the time \[Tau] and the logarithm of the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red4 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red4]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Tau] + Log[v] - \[Zeta]\_1 == 0\)},
          {\(P\ v - F\_1 == 0\)},
          {
            \(\(-E\^\(3\ \[Tau]\)\)\ 
                \((2\ F\_1 - 3\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The solution of the second-order ODE is a combination of two \
exponentials\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solr4\  = 
      DSolve[red4\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]
        \)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((E\^#1\ C[1] + E\^\(2\ #1\)\ C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the original coordinates, the solution is linear in ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and increases exponentially in time:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol4 = 
      Solve[red4\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr4, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] E\^\[Tau]\ \((C[1] + E\^\[Tau]\ v\ C[2])\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solutions derived from different subgroups of the FP equation \
demonstrate that it is straightforward to uncover solutions with ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " for a (1\[ThinSpace]+\[ThinSpace]1)-dimensional PDE."
}], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"MolecularBeamEpitaxy.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{662, 668},
WindowMargins->{{22, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->348,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Hyperlinks"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "The Rayleigh particle"->{
    Cell[1739, 51, 386, 6, 41, "Subsection",
      Evaluatable->False,
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 75}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"The Rayleigh particle"]},
  "Brownian particle"->{
    Cell[2128, 59, 441, 10, 61, "Text",
      Evaluatable->False,
      CellTags->{"Brownian particle", "Rayleigh particle"}]},
  "Rayleigh particle"->{
    Cell[2128, 59, 441, 10, 61, "Text",
      Evaluatable->False,
      CellTags->{"Brownian particle", "Rayleigh particle"}]},
  "Fokker-Planck equation"->{
    Cell[2688, 75, 537, 15, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "Fokker-Planck equation", "FP equation", "probability density"}],
    Cell[10000, 306, 527, 12, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry group", "discrete group", "Fokker-Planck equation"}]},
  "FP equation"->{
    Cell[2688, 75, 537, 15, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "Fokker-Planck equation", "FP equation", "probability density"}],
    Cell[10530, 320, 580, 17, 44, "Text",
      CellTags->{"FP equation", "infinitesimals"}]},
  "probability density"->{
    Cell[2688, 75, 537, 15, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "Fokker-Planck equation", "FP equation", "probability density"}]},
  "damped particle"->{
    Cell[4054, 121, 1478, 45, 78, "Text",
      Evaluatable->False,
      CellTags->{"damped particle", "temperature", "Boltzmann constant"}]},
  "temperature"->{
    Cell[4054, 121, 1478, 45, 78, "Text",
      Evaluatable->False,
      CellTags->{"damped particle", "temperature", "Boltzmann constant"}]},
  "Boltzmann constant"->{
    Cell[4054, 121, 1478, 45, 78, "Text",
      Evaluatable->False,
      CellTags->{"damped particle", "temperature", "Boltzmann constant"}]},
  "infinitesimals"->{
    Cell[6055, 188, 519, 13, 61, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[10530, 320, 580, 17, 44, "Text",
      CellTags->{"FP equation", "infinitesimals"}]},
  "symmetry group"->{
    Cell[10000, 306, 527, 12, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry group", "discrete group", "Fokker-Planck equation"}]},
  "discrete group"->{
    Cell[10000, 306, 527, 12, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry group", "discrete group", "Fokker-Planck equation"}]},
  "similarity reduction"->{
    Cell[11593, 353, 132, 4, 27, "Text",
      CellTags->"similarity reduction"],
    Cell[94280, 2053, 158, 2, 27, "Text",
      CellTags->{
      "similarity reduction", "similarity reduction of the FP equation"}]},
  "similarity variable"->{
    Cell[12692, 388, 279, 6, 46, "Text",
      CellTags->{"similarity variable", "DSolve[]"}]},
  "DSolve[]"->{
    Cell[12692, 388, 279, 6, 46, "Text",
      CellTags->{"similarity variable", "DSolve[]"}]},
  "solution of the FP equation"->{
    Cell[13702, 419, 221, 4, 44, "Text",
      CellTags->{"solution of the FP equation", "similarity representation"}],
    
    Cell[219785, 4665, 477, 14, 61, "Text",
      CellTags->"solution of the FP equation"]},
  "similarity representation"->{
    Cell[13702, 419, 221, 4, 44, "Text",
      CellTags->{"solution of the FP equation", "similarity representation"}],
    
    Cell[95458, 2086, 555, 14, 61, "Text",
      CellTags->{"similarity representation", "similarity solution"}]},
  "similarity reduction of the FP equation"->{
    Cell[94280, 2053, 158, 2, 27, "Text",
      CellTags->{
      "similarity reduction", "similarity reduction of the FP equation"}]},
  "similarity solution"->{
    Cell[95458, 2086, 555, 14, 61, "Text",
      CellTags->{"similarity representation", "similarity solution"}],
    Cell[220795, 4696, 345, 10, 44, "Text",
      CellTags->"similarity solution"]},
  "Erfi[]"->{
    Cell[222664, 4761, 226, 6, 46, "Text",
      CellTags->"Erfi[]"]},
  "nontrivial similarity reduction"->{
    Cell[344901, 7275, 356, 10, 44, "Text",
      CellTags->"nontrivial similarity reduction"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"The Rayleigh particle", 350073, 7441},
  {"Brownian particle", 350452, 7449},
  {"Rayleigh particle", 350605, 7453},
  {"Fokker-Planck equation", 350763, 7457},
  {"FP equation", 351095, 7466},
  {"probability density", 351373, 7473},
  {"damped particle", 351553, 7478},
  {"temperature", 351716, 7482},
  {"Boltzmann constant", 351886, 7486},
  {"infinitesimals", 352052, 7490},
  {"symmetry group", 352271, 7496},
  {"discrete group", 352450, 7501},
  {"similarity reduction", 352635, 7506},
  {"similarity variable", 352880, 7512},
  {"DSolve[]", 352992, 7515},
  {"solution of the FP equation", 353123, 7518},
  {"similarity representation", 353374, 7524},
  {"similarity reduction of the FP equation", 353661, 7530},
  {"similarity solution", 353824, 7534},
  {"Erfi[]", 354037, 7539},
  {"nontrivial similarity reduction", 354147, 7542}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 386, 6, 41, "Subsection",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 75}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"The Rayleigh particle"],
Cell[2128, 59, 441, 10, 61, "Text",
  Evaluatable->False,
  CellTags->{"Brownian particle", "Rayleigh particle"}],
Cell[2572, 71, 113, 2, 24, "NumberedEquation"],
Cell[2688, 75, 537, 15, 44, "Text",
  Evaluatable->False,
  CellTags->{
  "Fokker-Planck equation", "FP equation", "probability density"}],

Cell[CellGroupData[{
Cell[3250, 94, 254, 7, 51, "Input"],
Cell[3507, 103, 532, 15, 34, "Output"]
}, Open  ]],
Cell[4054, 121, 1478, 45, 78, "Text",
  Evaluatable->False,
  CellTags->{"damped particle", "temperature", "Boltzmann constant"}],

Cell[CellGroupData[{
Cell[5557, 170, 214, 5, 23, "Input"],
Cell[5774, 177, 266, 8, 23, "Output"]
}, Open  ]],
Cell[6055, 188, 519, 13, 61, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[6599, 205, 108, 2, 23, "Input"],
Cell[6710, 209, 3275, 94, 100, "Output"]
}, Open  ]],
Cell[10000, 306, 527, 12, 63, "Text",
  Evaluatable->False,
  CellTags->{"symmetry group", "discrete group", "Fokker-Planck equation"}],
Cell[10530, 320, 580, 17, 44, "Text",
  CellTags->{"FP equation", "infinitesimals"}],

Cell[CellGroupData[{
Cell[11135, 341, 349, 6, 39, "Input"],
Cell[11487, 349, 91, 1, 23, "Output"]
}, Open  ]],
Cell[11593, 353, 132, 4, 27, "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{
Cell[11750, 361, 254, 5, 23, "Input"],
Cell[12007, 368, 670, 17, 64, "Output"]
}, Open  ]],
Cell[12692, 388, 279, 6, 46, "Text",
  CellTags->{"similarity variable", "DSolve[]"}],

Cell[CellGroupData[{
Cell[12996, 398, 564, 13, 23, "Input"],
Cell[13563, 413, 124, 3, 28, "Output"]
}, Open  ]],
Cell[13702, 419, 221, 4, 44, "Text",
  CellTags->{"solution of the FP equation", "similarity representation"}],

Cell[CellGroupData[{
Cell[13948, 427, 136, 3, 23, "Input"],
Cell[14087, 432, 211, 4, 47, "Output"]
}, Open  ]],
Cell[14313, 439, 389, 10, 61, "Text"],

Cell[CellGroupData[{
Cell[14727, 453, 226, 4, 23, "Input"],
Cell[14956, 459, 78335, 1560, 216, 24403, 890, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[93306, 2022, 470, 14, 44, "Text"],

Cell[CellGroupData[{
Cell[93801, 2040, 349, 6, 39, "Input"],
Cell[94153, 2048, 112, 2, 34, "Output"]
}, Open  ]],
Cell[94280, 2053, 158, 2, 27, "Text",
  CellTags->{
  "similarity reduction", "similarity reduction of the FP equation"}],

Cell[CellGroupData[{
Cell[94463, 2059, 254, 5, 23, "Input"],
Cell[94720, 2066, 723, 17, 56, "Output"]
}, Open  ]],
Cell[95458, 2086, 555, 14, 61, "Text",
  CellTags->{"similarity representation", "similarity solution"}],

Cell[CellGroupData[{
Cell[96038, 2104, 127, 3, 23, "Input"],
Cell[96168, 2109, 462, 8, 43, "Output"]
}, Open  ]],
Cell[96645, 2120, 59, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[96729, 2124, 136, 3, 23, "Input"],
Cell[96868, 2129, 293, 5, 50, "Output"]
}, Open  ]],
Cell[97176, 2137, 275, 4, 44, "Text"],

Cell[CellGroupData[{
Cell[97476, 2145, 256, 5, 39, "Input"],
Cell[97735, 2152, 122035, 2510, 248, 54996, 1678, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[219785, 4665, 477, 14, 61, "Text",
  CellTags->"solution of the FP equation"],

Cell[CellGroupData[{
Cell[220287, 4683, 349, 6, 39, "Input"],
Cell[220639, 4691, 141, 2, 35, "Output"]
}, Open  ]],
Cell[220795, 4696, 345, 10, 44, "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[221165, 4710, 254, 5, 23, "Input"],
Cell[221422, 4717, 180, 3, 37, "Message"],
Cell[221605, 4722, 662, 18, 72, "Output"]
}, Open  ]],
Cell[222282, 4743, 114, 4, 29, "Text"],

Cell[CellGroupData[{
Cell[222421, 4751, 127, 3, 23, "Input"],
Cell[222551, 4756, 98, 2, 35, "Output"]
}, Open  ]],
Cell[222664, 4761, 226, 6, 46, "Text",
  CellTags->"Erfi[]"],

Cell[CellGroupData[{
Cell[222915, 4771, 136, 3, 23, "Input"],
Cell[223054, 4776, 180, 4, 41, "Output"]
}, Open  ]],
Cell[223249, 4783, 217, 4, 44, "Text"],

Cell[CellGroupData[{
Cell[223491, 4791, 280, 5, 39, "Input"],
Cell[223774, 4798, 121112, 2474, 243, 54337, 1645, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[344901, 7275, 356, 10, 44, "Text",
  CellTags->"nontrivial similarity reduction"],

Cell[CellGroupData[{
Cell[345282, 7289, 349, 6, 39, "Input"],
Cell[345634, 7297, 167, 3, 34, "Output"]
}, Open  ]],
Cell[345816, 7303, 280, 9, 44, "Text"],

Cell[CellGroupData[{
Cell[346121, 7316, 254, 5, 23, "Input"],
Cell[346378, 7323, 180, 3, 37, "Message"],
Cell[346561, 7328, 469, 13, 46, "Output"]
}, Open  ]],
Cell[347045, 7344, 99, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[347169, 7351, 127, 3, 23, "Input"],
Cell[347299, 7356, 88, 1, 23, "Output"]
}, Open  ]],
Cell[347402, 7360, 178, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[347605, 7369, 136, 3, 23, "Input"],
Cell[347744, 7374, 90, 1, 23, "Output"]
}, Open  ]],
Cell[347849, 7378, 272, 6, 44, "Text"],
Cell[348124, 7386, 160, 3, 35, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

