(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    370224,      11919]*)
(*NotebookOutlinePosition[    398511,      12671]*)
(*  CellTagsIndexPosition[    394315,      12559]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["3", "ChapterLine",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell["Derivatives", "Title",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[TextData[{
  "The symmetry analysis of differential equations is based on several \
differential operators. Among these operators are the ordinary \
differentiation, the total differential, the Fr\[EAcute]chet derivative, the \
Euler-Lagrange derivative, and the prolongation, to name the main operators. \
The basis of the symmetry analysis is the prolongation of a differential \
equation. Unfortunately, the prolongation as a differential operator is not \
implemented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This chapter will discuss the different types of derivatives used in the \
calculus of symmetry analysis and will demonstrate their application by \
several examples. Another subject of the present chapter is the presentation \
of the theoretical background for the derivatives. One point we will discuss \
is the connection of the theory with the practical implementation of these \
operators in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Application of the defined operators to several examples will \
demonstrate their use. Throughout the text, we use subscripts to denote a \
differentiation. The subscripted representation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is created by the function ",
  StyleBox["LieTraditionalForm[]", "MmaText"],
  ". This ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function converts the standard form of differentials in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to a traditional form frequently used in mathematics."
}], "Text",
  PageBreakBelow->False,
  CellTags->{
  "differential operators", "ordinary differentiation", "total differential", 
    "Frechet derivative", "Euler-Lagrange derivative", "prolongation", 
    "LieTraditionalForm[]", "traditional form"}],

Cell[CellGroupData[{

Cell["3.1 Ordinary and Partial Derivatives", "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>Identity},
  CellTags->"Ordinary and partial derivatives"],

Cell[TextData[{
  "Ordinary and partial derivatives are widely used in calculus. As a matter \
of fact, this kind of calculation is also applied in the symmetry analysis of \
differential equations. Gauss, Leibniz, and Newton introduced the notion of \
derivatives in the 17th",
  StyleBox[" ",
    FontSlant->"Italic"],
  "century in order to have a measure for the slope of a function. Still \
today, we continue to use derivatives to measure the slope of a function at a \
position ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The definition of a differential is one of the fruitful concepts mankind \
invented to describe nature in mathematical terms. Newton and Leibniz \
introduced the calculus of differentials to describe physical and \
mathematical relations by means of differential equations. The main \
ingredients of differential equations are derivatives combined in a linear or \
non-linear way. The definition of a derivative in terms of a limiting process \
is given by the following:"
}], "Text",
  Evaluatable->False,
  CellTags->{"calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}],

Cell["Definition: Ordinary derivative", "Definition",
  CellTags->"Definition: Ordinary derivative"],

Cell[TextData[{
  "Given a smooth function ",
  Cell[BoxData[
      \(TraditionalForm
      \`f : \ \[DoubleStruckCapitalR]\  \[Rule] \ 
        \[DoubleStruckCapitalR]\)]],
  ", the derivative of\[ThinSpace] ",
  StyleBox["f\[ThinSpace] ",
    FontSlant->"Italic"],
  "is defined by the relation"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            StyleBox[\(df\/dx\),
              FontSlant->"Italic"], " ", ":=", " ", 
            \(lim\+\(h \[Rule] 0\)\ \(f(x + h)\  - f(x)\)\/h\)}],
          "TraditionalForm"], ".", "\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
        "\[EmptyCircle]"}], TextForm]], "NumberedEquation",
  TextJustification->1],

Cell[TextData[{
  "This definition is the mathematical expression of how to manage the \
calculation of the slope for a known function",
  StyleBox[" f.",
    FontSlant->"Italic"],
  " The meaning of this formula is that we have to take two neighboring \
points separated by a distance ",
  StyleBox["h",
    FontSlant->"Italic"],
  " in the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " domain and calculate the ratio of the difference of the function at these \
points. If we assume that the distance ",
  StyleBox["h",
    FontSlant->"Italic"],
  " becomes smaller and smaller, we end up with a value describing the slope \
of the function at the point ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". Here we used the representation of the derivative in mathematical terms. \
The definition of the derivative given in (3.1) is not only a symbolic \
formula but also of practical relevance. In ",
  StyleBox["Mathematica, ",
    FontSlant->"Italic"],
  "we can demonstrate the practical use by just applying relation (3.1) to a \
specific function. Let us assume that the function",
  StyleBox[" f",
    FontSlant->"Italic"],
  " is given by the trigonometric function"
}], "Text",
  Evaluatable->False,
  CellTags->"trigonometric function"],

Cell[BoxData[
    \(f[x_] := Sin[x]\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Formula (3.1) in terms of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  reads"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Df = Limit[\(f[x + h] - f[x]\)\/h, h \[Rule] 0]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Cos[x]\)], "Output"]
}, Open  ]],

Cell["\<\
which provides us with the expected result. We certainly know that \
the derivative of the sin is given by a cos. The result can be checked by a \
symbolic calculation using the differentiation\
\>", "Text",
  Evaluatable->False,
  CellTags->"symbolic calculation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x f[x]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Cos[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which gives the same result. We realize that ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "provides the same result by different algorithmic procedures. However, the \
standard way of calculating derivatives of functions ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " is the application of the operator ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x\)], "MmaText"],
  " to ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  ". The pattern ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x f[x]\)]],
  " or ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(D[F[x], x]\),
          "MmaText"], TraditionalForm]]],
  " serves to calculate all the ordinary differentials of a function ",
  StyleBox["f", "",
    FontSlant->"Italic"],
  " with one independent variable. "
}], "Text",
  Evaluatable->False,
  CellTags->{"ordinary differential", "independent variable"}],

Cell[TextData[{
  "Another way of looking on relation (3.1) in the definition above is based \
on a geometrical interpretation. Rewriting the original formula (3.1) helps \
us to understand the geometrical contents. Let us first replace the limit in \
equation (3.1) by another representation. The derivative defined on the \
left-hand side of equation (3.1) can be represented by introducing a \
condition on the right-hand side. Dropping for the moment the ",
  StyleBox["Limit[]", "MmaText"],
  " and introducing a reference point ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " on the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis, we are able to rewrite the right-hand side. We assume that ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " is a distance ",
  StyleBox["h",
    FontSlant->"Italic"],
  " away from",
  StyleBox[" ",
    FontSlant->"Italic"],
  "our point of interest",
  StyleBox[" x",
    FontSlant->"Italic"],
  ". The resulting value on the right-hand side of (3.1) is an approximation \
of the derivative at the point ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we write"
}], "Text",
  Evaluatable->False,
  CellTags->{"geometrical interpretation", "Limit[]"}],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  PageWidth->Infinity],

Cell[CellGroupData[{

Cell[BoxData[
    \(Df = \(f[x + h] - f[x]\)\/h /. h \[Rule] x0 - x\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(\(-f[x]\) + f[x0]\)\/\(\(-x\) + x0\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The left-hand side in equation (3.1) can be represented by the \
differential operator ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[PartialD]\_x\),
          "MmaText"], TraditionalForm]]],
  StyleBox[".",
    FontSlant->"Italic"],
  " The calculation is carried out at the location ",
  Cell[BoxData[
      \(TraditionalForm\`x = x\_0\)]],
  ". This representation of the derivative gives us"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dlf = \[PartialD]\_x f[x] /. x \[Rule] x0\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x0", "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Combining the two expressions, we get an approximate representation of a \
derivative for the function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at the location ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(df = Dlf == Df\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "x0", "]"}], "==", 
      \(\(\(-f[x]\) + f[x0]\)\/\(\(-x\) + x0\)\)}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The geometrical way of reading this equation is to consider ",
  StyleBox["df",
    FontSlant->"Italic"],
  " as a parametric definition of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f[x]\)], "MmaText"],
  ". The parameter ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " denotes a specific location in the domain of the independent variables. \
An explicit representation of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " follows from ",
  Cell[BoxData[
      \(TraditionalForm\`d\[NegativeVeryThinSpace]f\)], "MmaText"],
  " by solving it with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`f[x]\)], "MmaText"],
  ":"
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = Solve[df, f[x]] /. f[x] \[Rule] w\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"w", "\[Rule]", 
          RowBox[{\(f[x0]\), "+", 
            RowBox[{"x", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}], "-", 
            RowBox[{"x0", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}]}]}], "}"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["The replacement of ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]],
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox[" by an auxiliary variable ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["w",
    FontSlant->"Italic"],
  StyleBox[" is necessary to define the function ",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]],
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox[" in a pure function as",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}]
}], "Text",
  Evaluatable->False,
  CellTags->"pure function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fun = f \[Rule] Function[{x, x0}, w] /. Flatten[sol1]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"f", "\[Rule]", 
      RowBox[{"Function", "[", 
        RowBox[{\({x, x0}\), ",", 
          RowBox[{\(f[x0]\), "+", 
            RowBox[{"x", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}], "-", 
            RowBox[{"x0", " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x0", "]"}]}]}]}], "]"}]}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a representation of the function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  " defined at any location ",
  StyleBox["x",
    FontSlant->"Italic"],
  " knowing at the same time the same function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at a point ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". In addition, we also have to know the derivative of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "at this location. The relation appears somewhat strange at the first look. \
However, the geometrical content of this expression is easy to understand if \
we represent it graphically. To perceive the implications of the relation, \
let us examine a plot of ",
  StyleBox["f.",
    FontSlant->"Italic"],
  " Being specific in the plotting, we set the function \[NoBreak]",
  StyleBox["f",
    FontSlant->"Italic"],
  " to the trigonometric function sin"
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->"trigonometric function"],

Cell[BoxData[
    \(f[x_] := Sin[x]\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "In another step, we define a function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(g[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  ", combining our results for ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  ". The new function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(g[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  " allows us to represent ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at any points ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ":"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Clear[g]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(g[x_, x0_] := f[x, x0] /. fun\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "If we plot both functions ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(g[x, x\_0]\),
          "MmaText"], TraditionalForm]]],
  " in a common coordinate frame, we get the following picture:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[\n\tEvaluate[{f[x], g[x, 1]}], {x, 0, \[Pi]\/2}, \n\t
      AxesLabel \[Rule] {"\<x\>", "\<f,g\>"}, \n\t
      PlotStyle \[Rule] {RGBColor[1, 0, 0], \n\t\t\tRGBColor[0, 0, 1]}]\)], 
  "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.0147151 0.511886 [
[.17539 .00222 -12 -9 ]
[.17539 .00222 12 0 ]
[.32696 .00222 -9 -9 ]
[.32696 .00222 9 0 ]
[.47854 .00222 -12 -9 ]
[.47854 .00222 12 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -12 -9 ]
[.78169 .00222 12 0 ]
[.93327 .00222 -9 -9 ]
[.93327 .00222 9 0 ]
[1.025 .01472 0 -9.5 ]
[1.025 .01472 12 9.5 ]
[.01131 .11709 -18 -4.5 ]
[.01131 .11709 0 4.5 ]
[.01131 .21947 -18 -4.5 ]
[.01131 .21947 0 4.5 ]
[.01131 .32185 -18 -4.5 ]
[.01131 .32185 0 4.5 ]
[.01131 .42422 -18 -4.5 ]
[.01131 .42422 0 4.5 ]
[.01131 .5266 -6 -4.5 ]
[.01131 .5266 0 4.5 ]
[.02381 .64303 -14 0 ]
[.02381 .64303 14 19 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .01472 m
.17539 .02097 L
s
[(0.25)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(0.5)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(0.75)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(1)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(1.25)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(1.5)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.02381 .11709 m
.03006 .11709 L
s
[(0.2)] .01131 .11709 1 0 Mshowa
.02381 .21947 m
.03006 .21947 L
s
[(0.4)] .01131 .21947 1 0 Mshowa
.02381 .32185 m
.03006 .32185 L
s
[(0.6)] .01131 .32185 1 0 Mshowa
.02381 .42422 m
.03006 .42422 L
s
[(0.8)] .01131 .42422 1 0 Mshowa
.02381 .5266 m
.03006 .5266 L
s
[(1)] .01131 .5266 1 0 Mshowa
.125 Mabswid
.02381 .04031 m
.02756 .04031 L
s
.02381 .0659 m
.02756 .0659 L
s
.02381 .0915 m
.02756 .0915 L
s
.02381 .14269 m
.02756 .14269 L
s
.02381 .16828 m
.02756 .16828 L
s
.02381 .19388 m
.02756 .19388 L
s
.02381 .24506 m
.02756 .24506 L
s
.02381 .27066 m
.02756 .27066 L
s
.02381 .29625 m
.02756 .29625 L
s
.02381 .34744 m
.02756 .34744 L
s
.02381 .37304 m
.02756 .37304 L
s
.02381 .39863 m
.02756 .39863 L
s
.02381 .44982 m
.02756 .44982 L
s
.02381 .47541 m
.02756 .47541 L
s
.02381 .50101 m
.02756 .50101 L
s
.02381 .5522 m
.02756 .5522 L
s
.02381 .57779 m
.02756 .57779 L
s
.02381 .60338 m
.02756 .60338 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(,) show
79.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
87.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.06244 .04731 L
.10458 .08271 L
.14415 .11565 L
.18221 .14693 L
.22272 .17965 L
.26171 .21045 L
.30316 .2423 L
.34309 .27198 L
.3815 .29949 L
.42237 .32749 L
.46172 .35311 L
.49955 .37641 L
.53984 .39966 L
.57861 .42043 L
.61984 .4407 L
.65954 .45836 L
.69774 .47356 L
.73838 .48773 L
.77751 .49936 L
.81909 .50951 L
.85916 .51709 L
.87754 .51984 L
.89771 .52232 L
.91765 .52422 L
.92854 .52502 L
.93871 .52562 L
.94354 .52586 L
.94878 .52608 L
.95341 .52624 L
.95832 .52638 L
.96273 .52647 L
.96524 .52652 L
.9676 .52655 L
.96976 .52657 L
.97173 .52659 L
.97277 .52659 L
.97391 .5266 L
.97509 .5266 L
.97619 .5266 L
s
0 0 1 r
.02381 .16888 m
.06244 .1865 L
.10458 .20572 L
.14415 .22377 L
.18221 .24113 L
.22272 .25961 L
.26171 .2774 L
.30316 .29631 L
.34309 .31452 L
.3815 .33204 L
.42237 .35069 L
.46172 .36864 L
.49955 .38589 L
.53984 .40427 L
.57861 .42196 L
.61984 .44076 L
.65954 .45888 L
.69774 .4763 L
.73838 .49484 L
.77751 .51269 L
.81909 .53166 L
.85916 .54993 L
.89771 .56752 L
.93871 .58622 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{246, 151.875},
  ImageMargins->{{Inherited, 0}, {0, 1.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004c0000_A000`40O003h00O?7oo10001Goo0P00
17oo1@0017oo10003Goo10001Goo0P001Goo100037oo10001Goo0P001goo00<007ooOol00goo1000
57oo1@0057oo1@0017oo0P0017oo1@0017oo100037oo1@0017oo0P001Goo1000:Goo000kOol00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo
Ool02Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol027oo
00<007ooOol00Woo00<007ooOol00Woo0P001goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool04goo00<007ooOol05Woo00<007ooOol017oo0P0017oo00D007ooOomoo`0000=oo`03001oogoo
009oo`03001oogoo00]oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo02Ioo`00
>goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol027oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1goo00<007ooOol04goo00<007ooOol05Woo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
2goo00<007ooOol03goo00<007ooOol09Woo000kOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0COol00`00Oomoo`0FOol00`00
Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0?Ool00`00Oomoo`0VOol003]o
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00=oo`@000aoo`03001oogoo009oo`03001o
ogoo00Uoo`@000]oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo009oo`@001Ioo`03001o
ogoo01Ioo`03001oogoo00eoo`03001oogoo00=oo`@000ioo`03001oogoo00]oo`@002Uoo`00>goo
00<007ooOol00Woo00<007ooOol037oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol037oo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomoo`00
01Uoo`03001oogoo01Ioo`03001oogoo00ioo`03001oogoo009oo`03001oogoo00moo`03001oogoo
00]oo`03001oogoo02Yoo`00>goo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ao
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00aoo`03001oogoo009o
o`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000GOol3000FOol3000<Ool01@00Oomo
ogoo000017oo00<007ooOol03Goo0`003Goo00<007ooOol0:Woo000lOol4000<Ool30005Ool5000<
Ool4000<Ool5000;Ool4000;Ool60003Ool5000EOol00`00Oomoo`0FOol00`00Oomoo`0;Ool30005
Ool5000=Ool00`00Oomoo`0;Ool5000XOol00?moocAoo`00ogoo=7oo000VOol00`00Oomoo`3aOol2
0002Ool2000COol002Ioo`03001oogoo0?9oo`04001oogoo000DOol002Ioo`03001oogoo0?=oo`80
01Eoo`009Woo00<007ooOol0lgoo0P005Goo000POol600000g`00000003X000:Ool01000Oomoo`00
57oo000VOol00`00O01oo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`08Ool20002Ool2000COol002Io
o`03001oog`00?moo`]oo`009Woo00@007ooOoml0?moo`Yoo`009Woo00@007ooOomoo`9l0?moo`Qo
o`009Woo00<007ooOol00goo00=l07ooOol0ogoo1Goo000VOol20005Ool00g`0Oomoo`3oOol4Ool0
02Ioo`03001oogoo00Eoo`03O01oogoo0?moo`=oo`009Woo00<007ooOol01Woo00=l07ooOol0ogoo
0Woo000VOol00`00Oomoo`07Ool00g`0Oomoo`3oOol1Ool002Ioo`03001oogoo00Qoo`9l0?moo`5o
o`009Woo00<007ooOol02Woo00=l07ooOol0oGoo000VOol2000<Ool00g`0Oomoo`3lOol002Ioo`03
001oogoo00aoo`03O01oogoo0?]oo`009Woo00<007ooOol03Goo0W`0ngoo000VOol00`00Oomoo`0?
Ool00g`0Oomoo`3hOol002Ioo`03001oogoo011oo`03O01oogoo0?Moo`009Woo00<007ooOol04Goo
00=l07ooOol0mWoo000VOol2000COol2O03fOol002Ioo`03001oogoo01Aoo`03O01oogoo0?=oo`00
9Woo00<007ooOol05Goo00=l07ooOol0lWoo000VOol00`00Oomoo`0FOol00g`0Oomoo`3aOol000eo
o`@000Eoo`8000Aoo`D000Eoo`03001oogoo01Moo`9l0?5oo`0037oo00<007ooOol00Woo00<007oo
Ool00Woo0P0017oo00D007ooOomoo`0000Eoo`03001oogoo01Uoo`03O01oogoo0>ioo`0037oo00<0
07ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol06Woo00=l07ooOol0kGoo000<
Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool2000LOol00g`0Oomoo`3/Ool000ao
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Aoo`03001oogoo01aoo`03O01oogoo0>]o
o`0037oo00<007ooOol00Woo00<007ooOol037oo00<007ooOol00goo00<007ooOol07Goo00=l07oo
Ool0jWoo000<Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00001Goo00<007ooOol0
7Woo0W`0jWoo000=Ool4000<Ool30006Ool00`00Oomoo`0POol00g`0Oomoo`3WOol002Ioo`03001o
ogoo025oo`03O01oogoo0>Ioo`009Woo0P008goo00=l07ooOol0iGoo000VOol00`00Oomoo`0SOol0
0g`0Oomoo`3TOol002Ioo`03001oogoo02Aoo`03O01oogoo0>=oo`009Woo00<007ooOol09Goo0W`0
hgoo000VOol00`00Oomoo`0WOol00g`0Oomoo`3POol002Ioo`03001oogoo02Qoo`03O01oogoo0=mo
o`009Woo0P0O:Woo00=l07ooOol0gWoo000VOol01000Ool07`0O:Goo0W`0gWoo000VOol01000Oomo
ogoo0P0O:Goo00=l07ooOol0fgoo000VOol00`00Oomoo`03Ool201lXOol00g`0Oomoo`3JOol002Io
o`03001oogoo00Eoo`807bMoo`03O01oogoo0=Uoo`009Woo00<007ooOol01goo0P0O9Woo0W`0fGoo
000VOol2000:Ool201lVOol00g`0Oomoo`3FOol002Ioo`03001oogoo00]oo`807bEoo`03O01oogoo
0=Eoo`009Woo00<007ooOol03Goo0P0O97oo0W`0eGoo000=Ool40005Ool20007Ool30004Ool00`00
Oomoo`0?Ool301lSOol00g`0Oomoo`3BOol000aoo`03001oogoo009oo`03001oogoo009oo`8000Qo
o`03001oogoo00=oo`03001oogoo019oo`807b9oo`03O01oogoo0=5oo`0037oo00<007ooOol00Woo
00<007ooOol037oo00<007ooOol00goo00<007ooOol057oo0`0O87oo00=l07ooOol0d7oo000<Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool60004Ool2000HOol201lOOol2O03@Ool000aoo`03001oogoo
009oo`03001oogoo00Uoo`04001oogoo0005Ool00`00Oomoo`0IOol301lNOol00g`0Oomoo`3=Ool0
00aoo`03001oogoo009oo`03001oogoo00Uoo`04001oogoo0005Ool00`00Oomoo`0LOol201lMOol0
0g`0Oomoo`3<Ool000aoo`03001oogoo009oo`03001oogoo00Yoo`03001oo`0000Eoo`03001oogoo
01ioo`807aaoo`03O01oogoo0<]oo`003Goo10003Woo0P001Goo00<007ooOol087oo0P0O6goo0W`0
bgoo000VOol00`00Oomoo`0ROol201lKOol00g`0Oomoo`38Ool002Ioo`8002Eoo`807aYoo`03O01o
ogoo0<Moo`009Woo00<007ooOol09Woo0P0O6Goo00=l07ooOol0aWoo000VOol00`00Oomoo`0XOol2
01lHOol2O036Ool002Ioo`03001oogoo02Yoo`807aQoo`03O01oogoo0<=oo`009Woo00<007ooOol0
;7oo0`0O5Woo00=l07ooOol0`Woo000VOol00`00Oomoo`0_Ool201lEOol2O032Ool002Ioo`80039o
o`807aEoo`03O01oogoo0;moo`009Woo00<007ooOol0<goo0P0O57oo00=l07ooOol0_Woo000VOol0
0`00Oomoo`0eOol201lCOol2O02nOol002Ioo`03001oogoo03Moo`807a=oo`9l0;aoo`009Woo00<0
07ooOol0>Goo0P0O4goo00=l07ooOol0^Goo000VOol00`00Oomoo`0kOol201lBOol2O02iOol002Io
o`03001oogoo03eoo`807a9oo`9l0;Moo`009Woo0P00@7oo0`0O4Goo00=l07ooOol0]7oo000VOol0
0`00Oomoo`12Ool201l@Ool2O02dOol002Ioo`03001oogoo04Aoo`807a1oo`03O01oogoo0;5oo`00
3Goo10001Goo0P001Woo0`001Goo00<007ooOol0AWoo0P0O3goo00=l07ooOol0/7oo000<Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20005Ool01@00Oomoogoo000017oo00<007ooOol0B7oo0`0O3Goo
0W`0/7oo000<Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01@00Oomoogoo000017oo00<007ooOol0
Bgoo0P0O3Goo00=l07ooOol0[Goo000<Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01@00Oomoogoo
000017oo0P00CWoo0`0O2goo0W`0[Goo000<Ool00`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool0
0`00Oomoo`1@Ool201l;Ool00g`0Oomoo`2ZOol000aoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Ioo`03001oogoo059oo`807`Yoo`9l0:Yoo`0037oo00<007ooOol00Woo00<007ooOol0
2Woo00<007ooOol01Goo00<007ooOol0E7oo0P0O2Woo00=l07ooOol0Ygoo000=Ool4000>Ool30004
Ool00`00Oomoo`1FOol201l9Ool2O02WOol002Ioo`03001oogoo05Qoo`807`Uoo`03O01oogoo0:Ao
o`009Woo0P00Fgoo0P0O27oo0W`0Y7oo000VOol00`00Oomoo`1LOol301l7Ool00g`0Oomoo`2QOol0
02Ioo`03001oogoo05moo`807`Ioo`9l0:5oo`009Woo00<007ooOol0HGoo0P0O1Woo00=l07ooOol0
WWoo000VOol00`00Oomoo`1SOol201l5Ool2O02NOol002Ioo`03001oogoo06Eoo`<07`Aoo`03O01o
ogoo09]oo`009Woo0P00JGoo0P0O0goo0W`0Vgoo000VOol00`00Oomoo`1ZOol201l3Ool00g`0Oomo
o`2HOol002Ioo`03001oogoo06aoo`807`9oo`9l09Qoo`009Woo00<007ooOol0KWoo0`0O00=oog`0
O000UWoo000VOol00`00Oomoo`1aOol201l00gooO01l002DOol002Ioo`03001oogoo07=oo`<07`9l
099oo`009Woo0P00Mgoo0P0O0W`0T7oo000VOol00`00Oomoo`1hOol201l2O02>Ool002Ioo`03001o
ogoo07Yoo`807`9l08aoo`003Goo10001Goo0P001Goo10001Goo00<007ooOol0O7oo0P0O0W`0RWoo
000<Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`1nOol201l2O028Ool000aoo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009o
o`03001oogoo009oo`03001oogoo081oo`807`03O01oogoo08Eoo`0037oo00<007ooOol00Woo00<0
07ooOol027oo00<007ooOol00Woo00<007ooOol00Woo0P00Pgoo0P0O00=l07ooOol0Pgoo000<Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool40005Ool00`00Oomoo`24Ool201l00g`0Oomoo`21Ool000ao
o`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08Io
o`<07h5oo`0037oo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol00Woo
00<007ooOol0RGoo0P0OOgoo000=Ool4000<Ool40005Ool00`00Oomoo`2;Ool201l00g`0Oomoo`1j
Ool002Ioo`03001oogoo08eoo`807`03O01oogoo07Qoo`009Woo0P00T7oo0P0O00=l07ooOol0MWoo
000VOol00`00Oomoo`2AOol201l00g`0Oomoo`1dOol002Ioo`03001oogoo09=oo`807`9l07=oo`00
9Woo00<007ooOol0UGoo0P0O0W`0LGoo000VOol00`00Oomoo`2GOol201l3O01^Ool002Ioo`03001o
ogoo09Uoo`<07`9l06aoo`009Woo00<007ooOol0W7oo0P0O0g`0JGoo000VOol2002OOol301l3O01V
Ool002Ioo`03001oogoo0:5oo`807`04Ooml07`0O01SOol002Ioo`03001oogoo0:=oo`807`9oo`=l
061oo`009Woo00<007ooOol0YGoo0P0O0goo0g`0GGoo000VOol00`00Oomoo`2WOol301l3Ool4O01I
Ool002Ioo`03001oogoo0:Yoo`807`Eoo`=l05Ioo`009Woo0P00[Goo0`0O1Goo0g`0Dgoo000VOol0
0`00Oomoo`2_Ool201l6Ool4O01?Ool002Ioo`03001oogoo0;5oo`807`Qoo`Al04]oo`007Goo1@00
17oo00<007ooOol0/goo0P0O2Woo17`0Agoo000OOol00`00Oomoo`04Ool00`00Oomoo`2eOol201l<
Ool:O00mOol001moo`03001oogoo00Aoo`03001oogoo0;Moo`807aAoo`Yl03=oo`007goo00<007oo
Ool017oo0P00^Woo0P0O77oo2g`0:7oo000OOol00`00Oomoo`04Ool00`00Oomoo`2kOol301m<Ool0
01moo`03001oogoo00Aoo`03001oogoo0;ioo`807dYoo`007Goo0`001Woo00<007ooOol0`7oo0P0O
B7oo000OOol00`00Oomoo`04Ool00`00Oomoo`32Ool201m6Ool002Ioo`03001oogoo0<Aoo`807dAo
o`009Woo0P00agoo0P0O@Woo000VOol00`00Oomoo`38Ool201m0Ool002Ioo`03001oogoo0<Yoo`80
7cioo`009Woo00<007ooOol0c7oo0P0O?7oo000VOol00`00Oomoo`3>Ool301liOol002Ioo`03001o
ogoo0=5oo`807cMoo`009Woo0P00e7oo0P0O=Goo000VOol00`00Oomoo`3EOol201lcOol002Ioo`03
001oogoo0=Moo`<07c1oo`009Woo00<007ooOol0fWoo0P0O;Woo000VOol00`00Oomoo`3LOol201l/
Ool002Ioo`03001oogoo0=ioo`807bYoo`009Woo0P00hGoo0P0O:7oo000VOol00`00Oomoo`3oOol;
Ool002Ioo`03001oogoo0?moo`]oo`009Woo00<007ooOol0ogoo2goo000VOol00`00Oomoo`3oOol;
Ool00?moocAoo`00ogoo=7oo003oOoldOol00?moocAoo`00ogoo=7oo003oOoldOol00?moocAoo`00
ogoo=7oo003oOoldOol00?moocAoo`00ogoo=7oo000SOol00`00Oomoo`07Ool4003oOol3Ool002=o
o`8000aoo`03001oogoo0?moo`0067oo1P001Woo00<007ooOol01Woo0`0000=oo`00Ool0ogoo0Goo
000JOol00`00Oomoo`07Ool20006Ool01000Oomoogoo0P00ogoo0Woo000JOol00`00Oomoo`0?Ool0
0`00Oomoo`02Ool00`00Oomoo`3oOol001Yoo`03001oogoo00moo`03001oogoo009oo`03001oogoo
0?moo`006Woo00<007ooOol03goo00@007ooOomoo`800?moo`9oo`0067oo1P003goo0`0000=oo`00
0000ogoo0Goo000JOol00`00Oomoo`3oOolGOol001]oo`<00?mooaIoo`00ogoo=7oo003oOoldOol0
0?moocAoo`00ogoo=7oo003oOoldOol00?moocAoo`00ogoo=7oo003oOoldOol00001\
\>"],
  ImageRangeCache->{{{0, 306.5}, {188.813, 0}} -> {-0.263482, -0.115979, \
0.00858936, 0.0101737}}]
}, Open  ]],

Cell[TextData[{
  "From the above figure, we clearly see the geometrical meaning of ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "and ",
  StyleBox["f. ",
    FontSlant->"Italic"],
  "In fact, ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "is the representation of the tangent of the function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "at a certain location ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". In the figure above, we chose ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0 = 1\)]],
  ". The figure allows us to interpret the derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " as a slope. The relation derived in ",
  StyleBox["df",
    FontSlant->"Italic"],
  " clearly displays a linear dependence in the independent variable",
  StyleBox[" x",
    FontSlant->"Italic"],
  ". Examining the slopes of the function",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  " at other points ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ", we get a set of tangents. A graphical representation of this set is \
given below. This sort of plot represents an envelope of the function ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f[x]\),
          "MmaText"], TraditionalForm]]],
  StyleBox[". ",
    FontSlant->"Italic"],
  " The following lines of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are necessary to create the envelope of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{"tangent", "envelope"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[\n\t\tTable[g[x, x0], {x0, 0, \[Pi]\/2, \[Pi]\/20}]], \n
      \t{x, 0, \[Pi]\/2}, AxesLabel \[Rule] {"\<x\>", "\<g\>"}, \n\t
      PlotStyle \[Rule] 
        Table[RGBColor[1, 0, 0], \n\t\t\t{x0, 0, \[Pi]\/2, \[Pi]\/20}]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.0147151 0.374717 [
[.17539 .00222 -12 -9 ]
[.17539 .00222 12 0 ]
[.32696 .00222 -9 -9 ]
[.32696 .00222 9 0 ]
[.47854 .00222 -12 -9 ]
[.47854 .00222 12 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -12 -9 ]
[.78169 .00222 12 0 ]
[.93327 .00222 -9 -9 ]
[.93327 .00222 9 0 ]
[1.025 .01472 0 -9.5 ]
[1.025 .01472 12 9.5 ]
[.01131 .10839 -24 -4.5 ]
[.01131 .10839 0 4.5 ]
[.01131 .20207 -18 -4.5 ]
[.01131 .20207 0 4.5 ]
[.01131 .29575 -24 -4.5 ]
[.01131 .29575 0 4.5 ]
[.01131 .38943 -6 -4.5 ]
[.01131 .38943 0 4.5 ]
[.01131 .48311 -24 -4.5 ]
[.01131 .48311 0 4.5 ]
[.01131 .57679 -18 -4.5 ]
[.01131 .57679 0 4.5 ]
[.02381 .64303 -6 0 ]
[.02381 .64303 6 19 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .01472 m
.17539 .02097 L
s
[(0.25)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(0.5)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(0.75)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(1)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(1.25)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(1.5)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.02381 .10839 m
.03006 .10839 L
s
[(0.25)] .01131 .10839 1 0 Mshowa
.02381 .20207 m
.03006 .20207 L
s
[(0.5)] .01131 .20207 1 0 Mshowa
.02381 .29575 m
.03006 .29575 L
s
[(0.75)] .01131 .29575 1 0 Mshowa
.02381 .38943 m
.03006 .38943 L
s
[(1)] .01131 .38943 1 0 Mshowa
.02381 .48311 m
.03006 .48311 L
s
[(1.25)] .01131 .48311 1 0 Mshowa
.02381 .57679 m
.03006 .57679 L
s
[(1.5)] .01131 .57679 1 0 Mshowa
.125 Mabswid
.02381 .03345 m
.02756 .03345 L
s
.02381 .05219 m
.02756 .05219 L
s
.02381 .07092 m
.02756 .07092 L
s
.02381 .08966 m
.02756 .08966 L
s
.02381 .12713 m
.02756 .12713 L
s
.02381 .14587 m
.02756 .14587 L
s
.02381 .1646 m
.02756 .1646 L
s
.02381 .18334 m
.02756 .18334 L
s
.02381 .22081 m
.02756 .22081 L
s
.02381 .23955 m
.02756 .23955 L
s
.02381 .25828 m
.02756 .25828 L
s
.02381 .27702 m
.02756 .27702 L
s
.02381 .31449 m
.02756 .31449 L
s
.02381 .33322 m
.02756 .33322 L
s
.02381 .35196 m
.02756 .35196 L
s
.02381 .3707 m
.02756 .3707 L
s
.02381 .40817 m
.02756 .40817 L
s
.02381 .4269 m
.02756 .4269 L
s
.02381 .44564 m
.02756 .44564 L
s
.02381 .46438 m
.02756 .46438 L
s
.02381 .50185 m
.02756 .50185 L
s
.02381 .52058 m
.02756 .52058 L
s
.02381 .53932 m
.02756 .53932 L
s
.02381 .55805 m
.02756 .55805 L
s
.02381 .59553 m
.02756 .59553 L
s
.02381 .61426 m
.02756 .61426 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
.02381 .0152 m
.06244 .03878 L
.10458 .0645 L
.14415 .08866 L
.18221 .11189 L
.22272 .13662 L
.26171 .16042 L
.30316 .18572 L
.34309 .21009 L
.3815 .23354 L
.42237 .25849 L
.46172 .28251 L
.49955 .3056 L
.53984 .3302 L
.57861 .35386 L
.61984 .37903 L
.65954 .40327 L
.69774 .42658 L
.73838 .45139 L
.77751 .47528 L
.81909 .50066 L
.85916 .52512 L
.89771 .54865 L
.93871 .57368 L
.97619 .59656 L
s
.02381 .01855 m
.06244 .04126 L
.10458 .06603 L
.14415 .08929 L
.18221 .11165 L
.22272 .13546 L
.26171 .15838 L
.30316 .18275 L
.34309 .20622 L
.3815 .22879 L
.42237 .25282 L
.46172 .27595 L
.49955 .29818 L
.53984 .32186 L
.57861 .34465 L
.61984 .36889 L
.65954 .39223 L
.69774 .41467 L
.73838 .43857 L
.77751 .46157 L
.81909 .48601 L
.85916 .50956 L
.89771 .53222 L
.93871 .55632 L
.97619 .57835 L
s
.02381 .0275 m
.06244 .04877 L
.10458 .07198 L
.14415 .09377 L
.18221 .11472 L
.22272 .13703 L
.26171 .1585 L
.30316 .18133 L
.34309 .20331 L
.3815 .22447 L
.42237 .24697 L
.46172 .26864 L
.49955 .28948 L
.53984 .31166 L
.57861 .33301 L
.61984 .35571 L
.65954 .37758 L
.69774 .39861 L
.73838 .42099 L
.77751 .44254 L
.81909 .46544 L
.85916 .4875 L
.89771 .50873 L
.93871 .53131 L
.97619 .55195 L
s
.02381 .04449 m
.06244 .06381 L
.10458 .08488 L
.14415 .10466 L
.18221 .12369 L
.22272 .14395 L
.26171 .16344 L
.30316 .18416 L
.34309 .20413 L
.3815 .22334 L
.42237 .24377 L
.46172 .26345 L
.49955 .28236 L
.53984 .30251 L
.57861 .32189 L
.61984 .3425 L
.65954 .36236 L
.69774 .38146 L
.73838 .40178 L
.77751 .42134 L
.81909 .44213 L
.85916 .46217 L
.89771 .48144 L
.93871 .50194 L
.97619 .52068 L
s
.02381 .07158 m
.06244 .08846 L
.10458 .10687 L
.14415 .12417 L
.18221 .1408 L
.22272 .1585 L
.26171 .17554 L
.30316 .19366 L
.34309 .21111 L
.3815 .22789 L
.42237 .24575 L
.46172 .26295 L
.49955 .27948 L
.53984 .29709 L
.57861 .31403 L
.61984 .33205 L
.65954 .3494 L
.69774 .36609 L
.73838 .38386 L
.77751 .40096 L
.81909 .41913 L
.85916 .43664 L
.89771 .45349 L
.93871 .47141 L
.97619 .48778 L
s
.02381 .11028 m
.06244 .12432 L
.10458 .13963 L
.14415 .154 L
.18221 .16783 L
.22272 .18254 L
.26171 .19671 L
.30316 .21176 L
.34309 .22627 L
.3815 .24022 L
.42237 .25507 L
.46172 .26936 L
.49955 .28311 L
.53984 .29774 L
.57861 .31183 L
.61984 .3268 L
.65954 .34123 L
.69774 .3551 L
.73838 .36987 L
.77751 .38408 L
.81909 .39919 L
.85916 .41374 L
.89771 .42775 L
.93871 .44264 L
.97619 .45626 L
s
.02381 .16154 m
.06244 .17238 L
.10458 .1842 L
.14415 .1953 L
.18221 .20598 L
.22272 .21735 L
.26171 .22829 L
.30316 .23992 L
.34309 .25112 L
.3815 .2619 L
.42237 .27336 L
.46172 .2844 L
.49955 .29502 L
.53984 .30632 L
.57861 .3172 L
.61984 .32877 L
.65954 .33991 L
.69774 .35063 L
.73838 .36203 L
.77751 .37301 L
.81909 .38468 L
.85916 .39592 L
.89771 .40674 L
.93871 .41824 L
.97619 .42876 L
s
.02381 .22558 m
.06244 .23296 L
.10458 .24101 L
.14415 .24856 L
.18221 .25583 L
.22272 .26357 L
.26171 .27102 L
.30316 .27893 L
.34309 .28656 L
.3815 .29389 L
.42237 .3017 L
.46172 .30921 L
.49955 .31644 L
.53984 .32413 L
.57861 .33154 L
.61984 .33941 L
.65954 .347 L
.69774 .35429 L
.73838 .36205 L
.77751 .36953 L
.81909 .37747 L
.85916 .38512 L
.89771 .39248 L
.93871 .40031 L
.97619 .40747 L
s
.02381 .30195 m
.06244 .30568 L
.10458 .30976 L
.14415 .31358 L
.18221 .31726 L
.22272 .32118 L
.26171 .32495 L
.30316 .32896 L
.34309 .33282 L
.3815 .33653 L
.42237 .34048 L
.46172 .34429 L
.49955 .34794 L
.53984 .35184 L
.57861 .35559 L
.61984 .35957 L
.65954 .36341 L
.69774 .3671 L
.73838 .37103 L
.77751 .37482 L
.81909 .37884 L
.85916 .38271 L
.89771 .38644 L
.93871 .3904 L
.97619 .39403 L
s
.02381 .38943 m
.06244 .38943 L
.10458 .38943 L
.14415 .38943 L
.18221 .38943 L
.22272 .38943 L
.26171 .38943 L
.30316 .38943 L
.34309 .38943 L
.3815 .38943 L
.42237 .38943 L
.46172 .38943 L
.49955 .38943 L
.53984 .38943 L
.57861 .38943 L
.61984 .38943 L
.65954 .38943 L
.69774 .38943 L
.73838 .38943 L
.77751 .38943 L
.81909 .38943 L
.85916 .38943 L
.89771 .38943 L
.93871 .38943 L
.97619 .38943 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{288, 177.875},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OBGoo10001Goo0P00
17oo1@0017oo100057oo10001Goo0P001Goo100057oo10001Goo0P001goo00<007ooOol00goo1000
77oo1@006goo1@0017oo0P0017oo1@0017oo100057oo1@0017oo0P001Goo1000:goo0018Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo
Ool047oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol047oo
00<007ooOol00Woo00<007ooOol00Woo0P001goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool06goo00<007ooOol07Goo00<007ooOol017oo0P0017oo00D007ooOomoo`0000=oo`03001oogoo
009oo`03001oogoo01=oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo02Qoo`00
B7oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol047oo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol047oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1goo00<007ooOol06goo00<007ooOol07Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
4goo00<007ooOol03goo00<007ooOol0:7oo0018Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`0@Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0@Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0KOol00`00Oomoo`0MOol00`00
Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0COol00`00Oomoo`0?Ool00`00Oomoo`0XOol004Qo
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00=oo`@001=oo`03001oogoo009oo`03001o
ogoo00Uoo`@001=oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo009oo`@001ioo`03001o
ogoo01eoo`03001oogoo00eoo`03001oogoo00=oo`@001Ioo`03001oogoo00]oo`@002]oo`00B7oo
00<007ooOol00Woo00<007ooOol037oo00<007ooOol00Woo00<007ooOol057oo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol057oo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomoo`00
025oo`03001oogoo01eoo`03001oogoo00ioo`03001oogoo009oo`03001oogoo01Moo`03001oogoo
00]oo`03001oogoo02aoo`00B7oo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ao
o`03001oogoo01Aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Aoo`03001oogoo009o
o`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000OOol3000MOol3000<Ool01@00Oomo
ogoo000017oo00<007ooOol05Goo0`003Goo00<007ooOol0;7oo0019Ool4000<Ool30005Ool5000C
Ool4000<Ool5000COol4000;Ool60003Ool5000MOol00`00Oomoo`0MOol00`00Oomoo`0;Ool30005
Ool5000EOol00`00Oomoo`0;Ool5000ZOol00?moofUoo`00ogooJGoo003oOomYOol002]oo`03001o
ogoo0?moobAoo`80009oo`80015oo`00:goo00<007ooOol0ogoo9Goo00@007ooOol0019oo`00:goo
00<007ooOol0ogoo9Woo0P004goo000[Ool00`00Oomoo`3oOolVOol2000COol002Aoo`L00003O000
00000?l001/000Yoo`04001oogoo000BOol002]oo`=l00Ioo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Uo
o`80009oo`80015oo`00:goo00@007`0O01l02Qoo`03001oogoo02Uoo`03001oogoo02Uoo`03001o
ogoo02Uoo`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo039oo`00:goo00<007ooOol00g`0
ogoo>7oo000[Ool017`0Oomoogoo17`0ogoo=Woo000[Ool00`00O01l0003Ool3O03oOoleOol002]o
o`800003Ooml07`000=oo`=l0?mooc=oo`00:goo00<007ooOol00Woo0W`00Woo0g`0ogoo<Woo000[
Ool00`00Oomoo`04Ool2O002Ool3O03oOol`Ool002]oo`9l00Moo`9l0004Ooml07`0O03oOol_Ool0
02]oo`04001oog`0O007Ool00g`0Oomoo`03O03oOol]Ool002]oo`80009oo`9l00Ioo`9l009oo`9l
0?moobaoo`00:goo00<007ooOol00goo0W`01Woo0W`000Aoog`0O01l0?moobYoo`00:goo00<007oo
Ool01Goo0W`01Woo00=l07ooOol00W`0ogoo:Goo000[Ool00`00Oomoo`07Ool2O005Ool2O002Ool2
O03oOolWOol002]oo`03001oogoo00Uoo`9l00Eoo`9l009oo`03O01oogoo0?moobAoo`00:goo0P00
37oo0W`01Goo0W`000=oog`0O000ogoo97oo000[Ool2O00>Ool2O005Ool00g`0Oomoo`02O03oOolR
Ool002]oo`04001oog`0O00>Ool2O004Ool2O002Ool00g`0Oomoo`3oOolOOol002]oo`04001oogoo
Ool2O00>Ool2O004Ool2O0000gooO01l003oOolOOol002]oo`03001oogoo00=oo`9l00ioo`9l00Ao
o`9l0003Ooml07`00?mooaeoo`00:goo00<007ooOol01Goo0W`03Woo0W`017oo0W`000=oog`0O000
ogoo6goo000[Ool20008Ool3O00=Ool2O004Ool2O0000gooO01oo`3oOolIOol002]oo`03001oogoo
00Yoo`9l00eoo`9l00Aoo`Al0?mooaQoo`002Goo10001Goo0P0017oo1@0017oo10001Woo00<007oo
Ool037oo0W`03Goo0W`017oo17`0ogoo5Woo0008Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol03Woo0g`037oo
0W`017oo17`0ogoo57oo0008Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`03Ool00`00Oomoo`0AOol2O00<Ool2O004Ool4O03oOolBOol000Qoo`03001oogoo009oo`03
001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00=oo`<001=oo`=l00]oo`9l00Aoo`Al0?mooa1o
o`0027oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol00goo10001Woo0W`05goo0W`02goo
0W`017oo0g`0ogoo3goo0008Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Ooml0002O00FOol2O00;Ool2O004Ool3O03oOol=Ool000Qoo`03001oogoo009o
o`03001oogoo00Qoo`05001oogooOol00004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool2O00FOol3
O00:Ool2O003Ool4O03oOol;Ool000Uoo`@000aoo`<000Eoo`D000Eoo`03001oogoo00Aoo`=l01Io
o`9l00Yoo`9l00=oo`=l0?moo`Yoo`00:goo00<007ooOol01goo0g`05Goo0g`02Goo00=l07ooOol0
0Woo0g`0ogoo27oo000[Ool2000;Ool3O00EOol2O008Ool2O003Ool4O03oOol6Ool002]oo`03001o
ogoo00eoo`=l01Aoo`9l00Qoo`9l00=oo`Al0?moo`Aoo`00:goo00<007ooOol047oo0g`04goo0W`0
27oo0W`00goo0g`0ogoo0goo000[Ool00`00Oomoo`0COol3O00BOol2O008Ool2O003Ool3O03oOol1
Ool002]oo`03001oogoo01Ioo`9l019oo`=l00Moo`9l009oo`=l0?moo`00:goo0P006Goo0W`04goo
0W`01goo0g`000Aoog`0O01l0?eoo`00:goo00<007ooOol06Woo0g`04Woo0W`027oo1W`0ngoo000[
Ool00`00Oomoo`0MOol2O00BOol3O007Ool5O03jOol002]oo`03001oogoo01moo`=l019oo`9l00Mo
o`El0?Qoo`00:goo00<007ooOol08Woo0g`04Goo0g`01Woo17`0mgoo000[Ool2O00VOol2O00BOol2
O006Ool4O03eOol002]oo`8000Al02Aoo`=l015oo`9l00Ioo`Al0?=oo`00:goo00<007ooOol00goo
17`08goo0g`047oo0W`01Woo0g`0lWoo000[Ool00`00Oomoo`07Ool3O00SOol3O00?Ool2O006Ool3
O03`Ool002]oo`03001oogoo00Yoo`Al029oo`=l00ioo`=l00Aoo`Al0>ioo`00:goo00<007ooOol0
3Woo17`08Goo0g`03Woo0W`017oo17`0k7oo000[Ool2000COol4O00POol3O00=Ool2O004Ool3O03[
Ool002]oo`03001oogoo01Ioo`=l021oo`=l00aoo`=l00=oo`=l0>Uoo`00:goo00<007ooOol06Goo
0g`087oo0W`03Goo0W`00Woo17`0igoo000AOol40005Ool20005Ool40006Ool00`00Oomoo`0LOol3
O00OOol3O00<Ool3O0000gooO01l0002O03UOol0011oo`03001oogoo009oo`03001oogoo009oo`80
00Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo01moo`=l01moo`=l00aoo`9l0003Ooml
07`0009l0>=oo`0047oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00goo00<007ooOol0
8Woo17`07Woo0g`02goo1g`0hGoo000@Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`03
Ool3000VOol4O00MOol3O00:Ool7O03OOol0011oo`03001oogoo009oo`03001oogoo00Uoo`@000Io
o`03001oogoo02Yoo`=l01eoo`=l00Yoo`Il0=eoo`0047oo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01goo00<007ooOol0;Goo17`077oo0g`02Goo1W`0fgoo000@Ool00`00Oomoo`02Ool0
0`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`0aOol4O00KOol2O009Ool6O03IOol0015oo`@0
00aoo`D000Eoo`03001oogoo03Eoo`Al01Uoo`9l00Uoo`Il0=Moo`00:goo0P00>Woo17`05goo0g`0
1goo1g`0eGoo000[Ool2O00nOol4O00FOol2O007Ool6O03DOol002]oo`03001oog`000=l03ioo`=l
01Eoo`=l00Ioo`03O01oog`000=l0=9oo`00:goo00<007ooOol00goo17`0?Goo0g`05Goo0g`017oo
0W`000=oog`0O0000W`0d7oo000[Ool00`00Oomoo`07Ool4O00lOol3O00EOol2O004Ool00g`0Oomo
o`04O03>Ool002]oo`8000aoo`Il03Uoo`=l01Aoo`=l009oo`9l009oo`Al0<aoo`00:goo00<007oo
Ool04Goo1W`0=Woo0g`057oo0g`000Aoog`0O01oo`El0<Yoo`00:goo00<007ooOol05goo1W`0<goo
17`04goo17`00Woo1W`0agoo000[Ool00`00Oomoo`0MOol6O00aOol4O00BOol3O002Ool3O0000goo
O01l0035Ool002]oo`03001oogoo02=oo`Il02moo`Al011oo`Al0005Ooml07`0O01oo`02O033Ool0
02]oo`03001oogoo02Uoo`El02ioo`Al00ioo`Ql0003Ooml07`00<5oo`00:goo0P00;goo1W`0;7oo
17`02goo0g`000=oog`0O0000g`000=oog`0O000_goo000[Ool00`00Oomoo`0dOol5O00[Ool3O00:
Ool3O0000gooO01l0003O00017ooO01l07`0_7oo000[Ool00`00Oomoo`0iOol4O00ZOol4O007Ool3
O002Ool5O00017ooO01l07`0^Woo000[Ool00`00Oomoo`0mOol4O00ZOol4O005Ool3O002Ool00g`0
Ooml0002O00017ooO01l07`0^7oo000[Ool00`00Oomoo`11Ool4O00ZOol4O002Ool4O00017ooO01l
07oo1g`0]Woo000[Ool20016Ool6O00XOol7O002Ool00g`0Oomoo`07O02dOol002]oo`03001oogoo
04]oo`Il02Ioo`El0003Ooml07`0009oo`Ql0;5oo`00:goo00<007ooOol0DGoo1W`08goo17`000=o
og`0O0000Woo0W`000=oog`0O0000g`0[goo0009Ool40005Ool20007Ool00`00Oomoo`03Ool40006
Ool00`00Oomoo`1GOol6O00OOol7O002Ool2O0000gooO01l0003O02]Ool000Qoo`03001oogoo009o
o`03001oogoo009oo`8000Moo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001o
ogoo05eoo`Il01Yoo`=l0003Ooml07`0009l009oo`03O01oogoo00Il0:Yoo`0027oo00<007ooOol0
0Woo00<007ooOol02goo00<007ooOol01goo00<007ooOol00goo00<007ooOol0Hgoo17`067oo0g`0
00=oog`0O0000W`000=oog`0O0000Woo0W`000Aoog`0O01l0:Qoo`0027oo00<007ooOol00Woo00<0
07ooOol037oo00<007ooOol01Woo00<007ooOol00goo0`00Igoo17`05Goo17`00Woo0g`000=oog`0
O0000Woo0W`00Woo0g`0YGoo0008Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool4
0006Ool00`00Oomoo`1[Ool4O00COol3O003Ool6O002Ool2O003Ool3O02ROol000Qoo`03001oogoo
009oo`03001oogoo00eoo`05001oogooOol00009Ool6O01/Ool5O00@Ool3O003Ool2O0000gooO01l
0002O00017ooO01l07`00Woo0g`0X7oo0008Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomo
o`02Ool01@00Oomoogoo00002Goo00<007ooOol00goo2g`0IWoo1W`02goo0g`017oo00Al07ooOomo
o`Ml009oo`Al09eoo`002Goo10002goo1P000goo1@001Goo00<007ooOol03Woo37`0H7oo1G`027oo
0g`00goo0W`00goo0W`000=oog`0O0000W`00Woo1G`0VWoo000[Ool2000KOol<O01IOol6O003Ool4
O003Ool2O003Ool2O003Ool9O02HOol002]oo`03001oogoo02Ioo`]l05Aoo`Ql00Aoo`9l00=oo`03
O01oogoo009oo`Ul09Ioo`00:goo00<007ooOol0<Goo37`0CGoo1W`00goo00Al07ooOomoo`9l00Ao
o`9l0003Ooml07`000El09=oo`00:goo00<007ooOol0?Goo2g`0AGoo2G`00goo0W`017oo0W`00goo
1G`0TGoo000[Ool00`00Oomoo`18Ool9O00nOol4O003Ool6O005Ool2O004Ool5O02>Ool002]oo`03
001oogoo055oo`Il03Yoo`=l00=oo`9l00=oo`El009oo`9l00Aoo`Il08]oo`00:goo0P00F7oo2G`0
<goo0g`00goo0W`00goo00=l07ooOol01W`01Goo0W`000Aoog`0O01l08Qoo`00:goo00<007ooOol0
H7oo2g`0:Goo0g`017oo00Al07ooOomoo`9l00Ioo`El009oo`9l009oo`=l08Eoo`00:goo00<007oo
Ool0Jgoo37`07goo0g`00goo0W`00goo0W`01Woo0W`000=oog`0O0001G`00Woo0g`0PWoo000[Ool0
0`00Oomoo`1gOol;O00EOol4O003Ool00g`0Oomoo`02Ool2O006Ool2O003Ool5O003Ool4O01nOol0
02]oo`03001oogoo089oo`]l00aoo`=l00=oo`9l00Aoo`9l00Ioo`9l00Eoo`El009oo`El07Yoo`00
:goo0P00SWoo37`00Woo0g`00goo0W`017oo0W`01Woo0W`01goo2g`0Mgoo000[Ool00`00Oomoo`2I
Ool;O005Ool2O006Ool2O007Ool2O003Ool8O01cOol002]oo`03001oogoo09ioo`=l00=oo`al00=o
o`9l00Moo`9l00Eoo`Ql06moo`00:goo00<007ooOol0Wgoo17`00goo0W`01Goo0W`000=oog`0O000
1g`01Goo0W`01Woo0g`000=oog`0O00017`0JWoo000[Ool00`00Oomoo`2QOol3O004Ool2O005Ool0
0g`0Oomoo`05Ool8O00017ooO01l07`01Woo0g`00goo1g`0I7oo000[Ool00`00Oomoo`2SOol3O004
Ool00g`0Oomoo`03Ool2O007Ool2O004Ool8O005Ool3O004Ool7O01POol002]oo`800:Eoo`Al00=o
o`9l00Eoo`9l00Moo`9l00Qoo`il00Aoo`Ml05aoo`00:goo00<007ooOol0YWoo17`00goo0W`01Goo
0W`01goo0W`027oo0g`027oo47`0F7oo000QOol50005Ool00`00Oomoo`2XOol3O004Ool00g`0Oomo
o`04Ool00g`0Oomoo`06Ool2O009Ool2O008Ool3O006Ool=O01@Ool002=oo`03001oogoo00Eoo`03
001oogoo0:Yoo`=l00=oo`9l00Eoo`9l00Qoo`03O01oogoo00Qoo`=l00Qoo`=l00Ioo`=l00Aoo`ml
04Aoo`008goo00<007ooOol01Goo00<007ooOol0Zgoo17`00goo0W`01Goo0W`01goo0W`02goo0W`0
2Goo0W`01goo0g`01goo1W`00goo2g`0>Goo000SOol00`00Oomoo`05OoooO00GO00WOol002=oo`03
001oogoo00Eoo`03001oogoo0:moo`=l00Aoo`03O01oogoo00Aoo`9l00Moo`9l00]oo`9l00Uoo`=l
00Uoo`Al00]oo`El00moo`Il02Moo`008goo00<007ooOol01Goo00<007ooOol0/7oo17`00goo0W`0
1Woo0W`01goo0W`02goo0W`02Woo0W`02goo17`037oo1W`0=Woo000QOol30007Ool00`00Oomoo`2b
Ool4O003Ool2O006Ool00g`0Oomoo`06Ool2O00;Ool2O00:Ool3O00<Ool4O00>Ool6O00`Ool002=o
o`03001oogoo00Eoo`03001oogoo0;Aoo`=l00Aoo`9l00Eoo`9l00Qoo`=l00Yoo`9l00]oo`=l00eo
o`Al011oo`Il02Yoo`00:goo0P00]goo0g`017oo0W`01Goo0W`02Goo0W`02Woo0W`037oo0g`03Woo
0g`04goo0g`09goo000[Ool00`00Oomoo`2gOol3O005Ool2O005Ool2O009Ool2O00:Ool2O00=Ool3
O00>Ool4O00iOol002]oo`03001oogoo0;Uoo`=l00Eoo`03O01oogoo00Aoo`9l00Uoo`9l00Yoo`9l
00ioo`=l00moo`Al03Eoo`00:goo00<007ooOol0^Woo17`017oo0W`01Woo0W`02Goo0W`02Woo0W`0
3goo0g`047oo17`0<Goo000[Ool00`00Oomoo`2lOol3O005Ool2O006Ool2O009Ool2O00:Ool3O00?
Ool2O00BOol4O00]Ool002]oo`03001oogoo0;ioo`=l00Eoo`03O01oogoo00Eoo`9l00Uoo`9l00]o
o`9l00moo`=l01=oo`Al02Uoo`00:goo0P00`7oo0g`01Goo0W`01goo0W`02Goo0W`02goo0W`047oo
0g`057oo0W`09goo000[Ool00`00Oomoo`31Ool3O005Ool2O007Ool2O009Ool2O00;Ool3O00@Ool3
O00jOol002]oo`03001oogoo0<9oo`Al00Eoo`9l00Moo`9l00Uoo`9l00aoo`9l015oo`=l03Moo`00
:goo00<007ooOol0a7oo0g`01Woo00=l07ooOol01Woo0W`02Goo0W`037oo0g`04Goo0g`0=7oo000[
Ool00`00Oomoo`36Ool3O005Ool2O008Ool00g`0Oomoo`08Ool2O00=Ool2O00BOol3O00aOol002]o
o`800<Qoo`Al00Eoo`03O01oogoo00Ioo`9l00Yoo`9l00eoo`9l01=oo`=l02ioo`00:goo00<007oo
Ool0bGoo17`017oo0W`027oo0W`02Woo0W`03Goo0W`057oo0W`0;7oo000[Ool00`00Oomoo`3;Ool3
O005Ool2O008Ool00g`0Oomoo`09Ool2O00=Ool2O00DOol3O00YOol002]oo`03001oogoo0<eoo`=l
00Eoo`03O01oogoo00Ioo`9l00]oo`9l00eoo`=l01Aoo`9l02Moo`00:goo00<007ooOol0cWoo0g`0
1Goo0W`027oo0W`02goo0W`03Woo0W`0>goo000[Ool00`00Oomoo`3@Ool3O005Ool00g`0Oomoo`07
Ool2O00;Ool2O00>Ool2O00iOol002]oo`800=9oo`04O01oog`0O004Ool2O009Ool00g`0Oomoo`0:
Ool2O00>Ool3O00fOol002]oo`03001oogoo0=9oo`9l0003Ooml07oo00Aoo`9l00Qoo`9l00aoo`9l
00moo`9l03Aoo`002Goo1@0017oo0P0017oo1@0017oo10001Woo00<007ooOol0e7oo00Al07ooO01l
00Eoo`03O01oogoo00Moo`9l00aoo`9l00moo`=l035oo`002goo00<007ooOol017oo0P0017oo00D0
07ooOomoo`0000=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo0=Eoo`04O01oogooO005
Ool2O009Ool00g`0Oomoo`0;Ool2O00@Ool2O00_Ool000]oo`03001oogoo00]oo`03001oogoo00Uo
o`03001oogoo00=oo`03001oogoo0=Ioo`9l0003Ooml07`000Eoo`9l00Qoo`9l00eoo`9l011oo`9l
02eoo`002goo00<007ooOol037oo00<007ooOol027oo00<007ooOol00goo0`00f7oo00=l07ooOol0
0W`01Goo0W`027oo0W`03Goo00=l07ooOol03goo0W`0:goo000;Ool00`00Oomoo`0=Ool00`00Oomo
o`03Ool40006Ool00`00Oomoo`3IOol2O002Ool00g`0Oomoo`04Ool00g`0Oomoo`07Ool2O00<Ool2
O00AOol2O00YOol000]oo`03001oogoo00ioo`03001oogoo009oo`03001oogoo00Moo`03001oogoo
0=]oo`9l0003Ooml07`000Eoo`9l00Uoo`03O01oogoo00]oo`9l015oo`9l02Moo`002Goo0`0037oo
00D007ooOomoo`0000Aoo`03001oogoo00Moo`03001oogoo0=eoo`03O01oogoo009l00Eoo`9l00Qo
o`9l00eoo`9l03Qoo`002goo00<007ooOol02goo0`001Goo1@001Goo00<007ooOol0gWoo0W`00Woo
0W`01Goo00=l07ooOol01goo0W`03Goo0W`0=Woo000[Ool00`00Oomoo`3POol2O002Ool00g`0Oomo
o`03Ool2O009Ool2O00=Ool2O00dOol002]oo`800>=oo`9l0003Ooml07`000Eoo`9l00Uoo`9l00eo
o`=l035oo`00:goo00<007ooOol0i7oo00=l07ooOol00W`01Goo0W`02Goo0W`03Woo0W`0;goo000[
Ool00`00Oomoo`3UOol2O002Ool00g`0Oomoo`04Ool00g`0Oomoo`08Ool00g`0Oomoo`0=Ool2O00]
Ool002]oo`03001oogoo0>Moo`9l0003Ooml07`000Eoo`9l00Uoo`9l00moo`9l02]oo`00:goo00<0
07ooOol0jGoo00=l07ooOol00W`01Goo00=l07ooOol027oo0W`03goo0W`0:Goo000[Ool2003[Ool2
O002Ool2O004Ool2O00:Ool2O00?Ool2O00WOol002]oo`03001oogoo0>aoo`9l009oo`03O01oogoo
00=oo`9l00Yoo`9l03Ioo`00:goo00<007ooOol0kWoo0W`000=oog`0O0001Goo00=l07ooOol02Goo
0W`0=7oo000[Ool00`00Oomoo`3`Ool017`0Oomoog`01Goo0W`02goo0W`0<Woo000[Ool00`00Oomo
o`3aOol2O0000gooO01l0005Ool00g`0Oomoo`0:Ool2O00`Ool002]oo`03001oogoo0?=oo`03O01o
ogoo009l00Aoo`9l00aoo`9l02ioo`00:goo0P00mGoo0W`00Woo00=l07ooOol00goo0W`037oo0W`0
;7oo000[Ool00`00Oomoo`3fOol2O0000gooO01l0005Ool00g`0Oomoo`0;Ool2O00ZOol002]oo`03
001oogoo0?Qoo`04O01oogooO005Ool2O00=Ool2O00XOol002]oo`03001oogoo0?Uoo`9l0003Ooml
07`000Eoo`9l00eoo`03O01oogoo02Eoo`00:goo00<007ooOol0ngoo00Al07ooOoml00Ioo`9l03=o
o`00:goo0P00oGoo0W`000=oog`0O0001Woo00=l07ooOol0<7oo000[Ool00`00Oomoo`3nOol2O000
0gooO01oo`05Ool2O00`Ool0015oo`D000Aoo`8000Eoo`@000Ioo`03001oogoo0?moo`5oo`04O01o
og`0O006Ool2O00^Ool001=oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo0?moo`9oo`9l0003Ooml07oo00Ioo`9l02aoo`004goo00<007ooOol03goo00<007oo
Ool00goo00<007ooOol0ogoo17oo17`01goo0W`0:Woo000COol00`00Oomoo`0?Ool00`00Oomoo`03
Ool3003oOol6Ool3O008Ool2O00XOol001=oo`03001oogoo00]oo`@000Ioo`03001oogoo0?moo`Qo
o`=l00Qoo`03O01oogoo02Eoo`004goo00<007ooOol02goo00<007ooOol01goo00<007ooOol0ogoo
2Goo17`0;Woo000AOol3000=Ool00`00Oomoo`07Ool00`00Oomoo`3oOol;Ool017`0Ooml07`0;7oo
000COol00`00Oomoo`0;Ool50005Ool00`00Oomoo`3oOol<Ool2O0000gooO01l000ZOol002]oo`03
001oogoo0?moo`ioo`9l0003Ooml07`002Qoo`00:goo0P00ogoo4Goo00Al07ooOoml02Moo`00:goo
00<007ooOol0ogoo4Goo0W`0:7oo000[Ool00`00Oomoo`3oOolCOol00g`0Oomoo`0UOol002]oo`03
001oogoo0?mooc]oo`00:goo00<007ooOol0ogoo>goo000[Ool2003oOollOol002]oo`03001oogoo
0?mooc]oo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogoo
JGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo000XOol4003o
OolmOol002aoo`03001oogoo0?moocYoo`00:7oo0`0000=oo`00Ool0ogoo>goo000WOol01000Oomo
ogoo0P00ogoo?7oo000WOol00`00Oomoo`02Ool00`00Oomoo`3oOoljOol002Moo`03001oogoo009o
o`03001oogoo0?moocYoo`009goo00@007ooOomoo`800?moocaoo`00:7oo0`0000=oo`000000ogoo
>goo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol0
0?moofUoo`00ogooJGoo003oOomYOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.313, 0}} -> {-0.24548, -0.136616, \
0.00709105, 0.0114736}}]
}, Open  ]],

Cell[TextData[{
  "The above figure shows that the slope of the function ",
  StyleBox["sin[", "MmaText"],
  StyleBox["x", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " starts with a finite value at ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0 = 0\)]],
  " and ends up with a vanishing value at ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0 = \[Pi]/2\)]],
  ". The following figure, showing the function and the derivative of the \
function, represents another way to examine the behavior of the slope."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[\n\t\t{f[x], \[PartialD]\_x f[x]}], \t{x, 0, \[Pi]\/2}, \n
      \tAxesLabel \[Rule] {"\<x\>", "\<f,f'\>"}, \n\t
      PlotStyle \[Rule] {RGBColor[0, 0, 1], \n\t\t\tRGBColor[1, 0, 0]}]\)], 
  "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.0147151 0.588604 [
[.17539 .00222 -12 -9 ]
[.17539 .00222 12 0 ]
[.32696 .00222 -9 -9 ]
[.32696 .00222 9 0 ]
[.47854 .00222 -12 -9 ]
[.47854 .00222 12 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -12 -9 ]
[.78169 .00222 12 0 ]
[.93327 .00222 -9 -9 ]
[.93327 .00222 9 0 ]
[1.025 .01472 0 -9.5 ]
[1.025 .01472 12 9.5 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -18 0 ]
[.02381 .64303 18 19 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .01472 m
.17539 .02097 L
s
[(0.25)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(0.5)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(0.75)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(1)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(1.25)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(1.5)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -79 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(,) show
79.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
87.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
95.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .01472 m
.06244 .0522 L
.10458 .0929 L
.14415 .13078 L
.18221 .16675 L
.22272 .20437 L
.26171 .23979 L
.30316 .27641 L
.34309 .31054 L
.3815 .34217 L
.42237 .37437 L
.46172 .40383 L
.49955 .43061 L
.53984 .45735 L
.57861 .48124 L
.61984 .50455 L
.65954 .52486 L
.69774 .54233 L
.73838 .55862 L
.77751 .572 L
.81909 .58367 L
.85916 .59239 L
.87754 .59554 L
.89771 .59839 L
.91765 .60058 L
.92854 .6015 L
.93871 .60219 L
.94354 .60247 L
.94878 .60272 L
.95341 .6029 L
.95832 .60306 L
.96273 .60317 L
.96524 .60322 L
.9676 .60326 L
.96976 .60329 L
.97173 .6033 L
.97277 .60331 L
.97391 .60331 L
.97509 .60332 L
.97619 .60332 L
s
1 0 0 r
.02381 .60332 m
.02499 .60332 L
.02605 .60331 L
.02729 .60331 L
.02846 .6033 L
.03053 .60328 L
.03279 .60325 L
.03527 .60321 L
.0379 .60316 L
.04262 .60304 L
.04749 .60287 L
.05205 .60268 L
.06244 .60212 L
.07305 .60138 L
.08274 .60054 L
.10458 .5981 L
.12357 .59537 L
.14429 .59174 L
.18493 .58266 L
.22406 .5715 L
.26565 .55711 L
.30571 .54083 L
.34426 .523 L
.38527 .50178 L
.42475 .47924 L
.46273 .45571 L
.50315 .42875 L
.54206 .40107 L
.58342 .3699 L
.62326 .33831 L
.66159 .30661 L
.70238 .27159 L
.74164 .23678 L
.77939 .20243 L
.8196 .16505 L
.85828 .12846 L
.89942 .08904 L
.93905 .05075 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{288, 177.875},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OAGoo10001Goo0P00
17oo1@0017oo100057oo10001Goo0P001Goo100057oo10001Goo0P001goo00<007ooOol00goo1000
77oo1@006goo1@0017oo0P0017oo1@0017oo100057oo1@0017oo0P001Goo1000;goo0014Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007oo
Ool047oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol047oo
00<007ooOol00Woo00<007ooOol00Woo0P001goo00<007ooOol00Woo00<007ooOol00Woo00<007oo
Ool06goo00<007ooOol07Goo00<007ooOol017oo0P0017oo00D007ooOomoo`0000=oo`03001oogoo
009oo`03001oogoo01=oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo02aoo`00
A7oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol047oo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol047oo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1goo00<007ooOol06goo00<007ooOol07Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
4goo00<007ooOol03goo00<007ooOol0;7oo0014Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`0@Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0@Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0KOol00`00Oomoo`0MOol00`00
Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0COol00`00Oomoo`0?Ool00`00Oomoo`0/Ool004Ao
o`03001oogoo009oo`03001oogoo00]oo`03001oogoo00=oo`@001=oo`03001oogoo009oo`03001o
ogoo00Uoo`@001=oo`03001oogoo009oo`03001oogoo00aoo`03001oogoo009oo`@001ioo`03001o
ogoo01eoo`03001oogoo00eoo`03001oogoo00=oo`@001Ioo`03001oogoo00]oo`@002moo`00A7oo
00<007ooOol00Woo00<007ooOol037oo00<007ooOol00Woo00<007ooOol057oo00<007ooOol00Woo
00<007ooOol02Goo00<007ooOol057oo00<007ooOol00Woo00<007ooOol03Goo00D007ooOomoo`00
025oo`03001oogoo01eoo`03001oogoo00ioo`03001oogoo009oo`03001oogoo01Moo`03001oogoo
00]oo`03001oogoo031oo`00A7oo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Ao
o`03001oogoo01Aoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01Aoo`03001oogoo009o
o`03001oogoo00Qoo`03001oogoo009oo`05001oogooOol0000OOol3000MOol3000<Ool01@00Oomo
ogoo000017oo00<007ooOol05Goo0`003Goo00<007ooOol0<7oo0015Ool4000<Ool30005Ool5000C
Ool4000<Ool5000COol4000;Ool60003Ool5000MOol00`00Oomoo`0MOol00`00Oomoo`0;Ool30005
Ool5000EOol00`00Oomoo`0;Ool5000^Ool00?moofUoo`00ogooJGoo003oOomYOol002Moo`03001o
ogoo0?moobEoo`80009oo`8001Aoo`009goo00<007ooOol0ogoo9Woo00@007ooOol001Eoo`009goo
00<007ooOol0ogoo9goo0P005Woo000WOol00`00Oomoo`3oOolWOol2000FOol0021oo`L0000301l0
00000?l001<00003O000000000D000]oo`04001oogoo000EOol002Moo`0300007goo00Ioo`03001o
ogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`04001o
ogooO005Ool00`00Oomoo`0:Ool20002Ool2000DOol002Moo`03001oo`0O02Uoo`03001oogoo02Uo
o`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo02Uoo`03001oogoo00Qo
o`03O01oogoo02]oo`009goo00@007ooOol07omoo`moo`03O01oogoo02aoo`009goo00D007ooOomo
o`0O0?moo`eoo`03O01oogoo02eoo`009goo00<007ooOol00Woo00<07gooOol0ogoo2Goo00=l07oo
Ool0;Woo000WOol00`00Oomoo`03Ool00`0OOomoo`3oOol7Ool00g`0Oomoo`0_Ool002Moo`03001o
ogoo00Aoo`0301moogoo0?moo`Eoo`03O01oogoo031oo`009goo00<007ooOol01Goo00<07gooOol0
ogoo0goo00=l07ooOol0<Goo000WOol20007Ool00`0OOomoo`3oOol1Ool00g`0Oomoo`0bOol002Mo
o`03001oogoo00Moo`0301moogoo0?ioo`03O01oogoo03=oo`009goo00<007ooOol027oo00<07goo
Ool0o7oo00=l07ooOol0=7oo000WOol00`00Oomoo`09Ool00`0OOomoo`3jOol00g`0Oomoo`0eOol0
02Moo`03001oogoo00Yoo`0301moogoo0?Qoo`03O01oogoo03Ioo`009goo00<007ooOol02goo00<0
7gooOol0mWoo00=l07ooOol0=goo000WOol00`00Oomoo`0<Ool00`0OOomoo`3dOol00g`0Oomoo`0h
Ool002Moo`03001oogoo00eoo`0301moogoo0?9oo`03O01oogoo03Uoo`009goo0P003goo0P0OlGoo
00=l07ooOol0>Woo000WOol00`00Oomoo`0@Ool00`0OOomoo`3]Ool00g`0Oomoo`0kOol002Moo`03
001oogoo015oo`0301moogoo0>]oo`03O01oogoo03aoo`009goo00<007ooOol04Woo00<07gooOol0
jGoo00=l07ooOol0?Goo000WOol00`00Oomoo`0COol00`0OOomoo`3WOol00g`0Oomoo`0nOol002Mo
o`03001oogoo01Aoo`0301moogoo0>Eoo`03O01oogoo03moo`009goo00<007ooOol05Goo00<07goo
Ool0hgoo00=l07ooOol0@7oo000WOol00`00Oomoo`0FOol00`0OOomoo`3QOol00g`0Oomoo`11Ool0
02Moo`03001oogoo01Moo`0301moogoo0=moo`03O01oogoo049oo`009goo0P006Goo00<07gooOol0
gGoo00=l07ooOol0@goo000WOol00`00Oomoo`0IOol00`0OOomoo`3JOol2O016Ool002Moo`03001o
ogoo01Yoo`0301moogoo0=Qoo`03O01oogoo04Ioo`009goo00<007ooOol06goo00<07gooOol0eWoo
00=l07ooOol0Agoo000WOol00`00Oomoo`0LOol00`0OOomoo`3DOol00g`0Oomoo`18Ool000eoo`@0
00Eoo`8000Aoo`D000Ioo`03001oogoo01eoo`0301moogoo0=9oo`03O01oogoo04Uoo`0037oo00<0
07ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOomoo`0000Ioo`03001oogoo01ioo`0301mo
ogoo0=1oo`03O01oogoo04Yoo`0037oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01goo
00<007ooOol07goo00<07gooOol0cWoo00=l07ooOol0Bgoo000<Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Oomoo`06Ool3000POol00`0OOomoo`3<Ool00g`0Oomoo`1<Ool000aoo`03001oogoo
009oo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo025oo`0301moogoo0<Yoo`03O01oogoo
04eoo`0037oo00<007ooOol00Woo00<007ooOol037oo00<007ooOol017oo00<007ooOol08Woo00<0
7gooOol0b7oo00=l07ooOol0CWoo000<Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo
00001Woo00<007ooOol08goo00<07gooOol0aWoo00=l07ooOol0Cgoo000=Ool4000<Ool30007Ool0
0`00Oomoo`0TOol00`0OOomoo`33Ool2O01BOol002Moo`03001oogoo02Eoo`807l9oo`03O01oogoo
059oo`009goo00<007ooOol09goo00<07gooOol0_Woo00=l07ooOol0Dgoo000WOol00`00Oomoo`0X
Ool00`0OOomoo`2lOol00g`0Oomoo`1DOol002Moo`03001oogoo02Uoo`0301moogoo0;Yoo`03O01o
ogoo05Eoo`009goo0P00:goo00<07gooOol0^7oo00=l07ooOol0EWoo000WOol00`00Oomoo`0[Ool0
0`0OOomoo`2fOol00g`0Oomoo`1GOol002Moo`03001oogoo02aoo`0301moogoo0;Aoo`03O01oogoo
05Qoo`009goo00<007ooOol0;Goo00<07gooOol0/Woo00=l07ooOol0FGoo000WOol00`00Oomoo`0^
Ool00`0OOomoo`2`Ool00g`0Oomoo`1JOol002Moo`03001oogoo02moo`0301moogoo0:ioo`03O01o
ogoo05]oo`009goo00<007ooOol0<7oo00<07gooOol0[7oo00=l07ooOol0G7oo000WOol00`00Oomo
o`0aOol201n[Ool00g`0Oomoo`1MOol002Moo`8003Aoo`0301moogoo0:Moo`03O01oogoo05ioo`00
9goo00<007ooOol0=7oo00<07gooOol0YGoo00=l07ooOol0Ggoo000WOol00`00Oomoo`0eOol00`0O
Oomoo`2SOol00g`0Oomoo`1POol002Moo`03001oogoo03Ioo`0301moogoo0:5oo`03O01oogoo065o
o`009goo00<007ooOol0=goo00<07gooOol0Wgoo00=l07ooOol0HWoo000WOol00`00Oomoo`0hOol0
0`0OOomoo`2MOol00g`0Oomoo`1SOol002Moo`03001oogoo03Uoo`0301moogoo09]oo`03O01oogoo
06Aoo`009goo00<007ooOol0>Woo00<07gooOol0VGoo00=l07ooOol0IGoo000WOol00`00Oomoo`0k
Ool00`0OOomoo`2GOol00g`0Oomoo`1VOol002Moo`8003eoo`0301moogoo09Aoo`9l06Uoo`009goo
00<007ooOol0?Goo00<07gooOol0TWoo00=l07ooOol0JGoo000WOol00`00Oomoo`0nOol00`0OOomo
o`2@Ool00g`0Oomoo`1ZOol002Moo`03001oogoo03moo`0301moogoo08ioo`03O01oogoo06]oo`00
9goo00<007ooOol0@7oo00<07gooOol0S7oo00=l07ooOol0K7oo000WOol00`00Oomoo`11Ool00`0O
Oomoo`2:Ool00g`0Oomoo`1]Ool000eoo`@000Eoo`8000Moo`<000Eoo`03001oogoo049oo`0301mo
ogoo08Qoo`03O01oogoo06ioo`0037oo00<007ooOol00Woo00<007ooOol00Woo0P0027oo00<007oo
Ool017oo00<007ooOol0@goo00<07gooOol0QGoo0W`0LGoo000<Ool00`00Oomoo`02Ool00`00Oomo
o`0<Ool00`00Oomoo`04Ool00`00Oomoo`14Ool00`0OOomoo`23Ool00g`0Oomoo`1aOol000aoo`03
001oogoo009oo`03001oogoo00Qoo`H000Eoo`<004Eoo`807h9oo`03O01oogoo079oo`0037oo00<0
07ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo04Moo`0301moogoo07ioo`03
O01oogoo07=oo`0037oo00<007ooOol00Woo00<007ooOol02Goo00@007ooOol000Ioo`03001oogoo
04Qoo`0301moogoo07aoo`03O01oogoo07Aoo`0037oo00<007ooOol00Woo00<007ooOol02Woo00<0
07oo00001Woo00<007ooOol0BGoo00<07gooOol0NGoo0W`0Mgoo000=Ool4000>Ool20006Ool00`00
Oomoo`1:Ool00`0OOomoo`1gOol00g`0Oomoo`1gOol002Moo`03001oogoo04]oo`807gIoo`03O01o
ogoo07Qoo`009goo00<007ooOol0CGoo00<07gooOol0LWoo00=l07ooOol0NGoo000WOol00`00Oomo
o`1>Ool00`0OOomoo`1`Ool00g`0Oomoo`1jOol002Moo`80051oo`0301moogoo06eoo`9l07eoo`00
9goo00<007ooOol0D7oo00<07gooOol0Jgoo00=l07ooOol0OGoo000WOol00`00Oomoo`1AOol201mZ
Ool00g`0Oomoo`1nOol002Moo`03001oogoo05=oo`0301moogoo06Ioo`03O01oogoo07moo`009goo
00<007ooOol0E7oo00<07gooOol0I7oo00=l07ooOol0P7oo000WOol00`00Oomoo`1EOol00`0OOomo
o`1QOol2O023Ool002Moo`03001oogoo05Ioo`0301moogoo05moo`03O01oogoo08=oo`009goo00<0
07ooOol0Egoo0P0OGWoo00=l07ooOol0Q7oo000WOol00`00Oomoo`1IOol00`0OOomoo`1JOol00g`0
Oomoo`25Ool002Moo`8005]oo`0301moogoo05Qoo`03O01oogoo08Ioo`009goo00<007ooOol0Fgoo
00<07gooOol0EGoo0W`0RGoo000WOol00`00Oomoo`1LOol201mDOol00g`0Oomoo`29Ool002Moo`03
001oogoo05ioo`0301moogoo051oo`03O01oogoo08Yoo`009goo00<007ooOol0Ggoo00<07gooOol0
CWoo00=l07ooOol0Rgoo000WOol00`00Oomoo`1POol00`0OOomoo`1<Ool00g`0Oomoo`2<Ool002Mo
o`03001oogoo065oo`0301moogoo04Uoo`9l08moo`009goo00<007ooOol0HWoo0P0OB7oo00=l07oo
Ool0Sgoo000WOol2001UOol00`0OOomoo`14Ool00g`0Oomoo`2@Ool002Moo`03001oogoo06Eoo`03
01moogoo049oo`03O01oogoo095oo`009goo00<007ooOol0IWoo00<07gooOol0?goo0W`0U7oo000W
Ool00`00Oomoo`1WOol00`0OOomoo`0mOol00g`0Oomoo`2DOol002Moo`03001oogoo06Qoo`807cao
o`03O01oogoo09Eoo`009goo00<007ooOol0JWoo00<07gooOol0>7oo00=l07ooOol0UWoo000=Ool4
0005Ool20006Ool30006Ool00`00Oomoo`1[Ool00`0OOomoo`0fOol00g`0Oomoo`2GOol000aoo`03
001oogoo009oo`03001oogoo009oo`8000Eoo`05001oogooOol00005Ool00`00Oomoo`1/Ool00`0O
Oomoo`0cOol2O02JOol000aoo`03001oogoo009oo`03001oogoo00Uoo`05001oogooOol00005Ool0
0`00Oomoo`1]Ool00`0OOomoo`0aOol00g`0Oomoo`2JOol000aoo`03001oogoo009oo`03001oogoo
00Uoo`05001oogooOol00005Ool3001^Ool201l`Ool00g`0Oomoo`2KOol000aoo`03001oogoo009o
o`03001oogoo00Uoo`@000Ioo`03001oogoo071oo`0301moogoo02]oo`9l09ioo`0037oo00<007oo
Ool00Woo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0LGoo00<07gooOol0:Goo00=l07oo
Ool0WWoo000<Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool00`00Oomoo`1bOol2
01lXOol00g`0Oomoo`2OOol000eoo`@000ioo`<000Eoo`03001oogoo07Aoo`0301moogoo02=oo`9l
0:9oo`009goo00<007ooOol0MGoo00<07gooOol08Goo00=l07ooOol0XWoo000WOol00`00Oomoo`1f
Ool201lPOol00g`0Oomoo`2SOol002Moo`03001oogoo07Qoo`0301moogoo01]oo`9l0:Ioo`009goo
0P00NWoo00<07gooOol06Goo00=l07ooOol0YWoo000WOol00`00Oomoo`1jOol201lHOol00g`0Oomo
o`2WOol002Moo`03001oogoo07aoo`0301moogoo01=oo`9l0:Yoo`009goo00<007ooOol0OGoo0P0O
4Woo00=l07ooOol0ZWoo000WOol00`00Oomoo`1oOol00`0OOomoo`0=Ool2O02]Ool002Moo`03001o
ogoo081oo`0301moogoo00]oo`03O01oogoo0:eoo`009goo00<007ooOol0PGoo0P0O2Goo0W`0/7oo
000WOol00`00Oomoo`23Ool00`0OOomoo`05Ool00g`0Oomoo`2`Ool002Moo`03001oogoo08Aoo`03
01moogoo009oo`9l0;=oo`009goo0P00QWoo0P0O00=oog`0Ool0]7oo000WOol00`00Oomoo`26Ool2
O02fOol002Moo`03001oogoo08Eoo`03O01oogoo00807kAoo`009goo00<007ooOol0Q7oo00=l07oo
Ool00goo00<07gooOol0/Goo000WOol00`00Oomoo`22Ool2O007Ool201naOol002Moo`03001oogoo
085oo`03O01oogoo00Uoo`0301moogoo0:ioo`009goo00<007ooOol0P7oo00=l07ooOol02goo0P0O
[Woo000WOol00`00Oomoo`1nOol2O00@Ool00`0OOomoo`2[Ool002Moo`8007ioo`03O01oogoo015o
o`807j]oo`009goo00<007ooOol0Ngoo0W`05Woo00<07gooOol0Z7oo000WOol00`00Oomoo`1jOol0
0g`0Oomoo`0GOol201nXOol002Moo`03001oogoo07Qoo`9l01aoo`0301moogoo0:Eoo`009goo00<0
07ooOol0MWoo0W`07goo0P0OYGoo000WOol00`00Oomoo`1eOol00g`0Oomoo`0QOol201nSOol000eo
o`@000Eoo`8000Eoo`@000Ioo`03001oogoo07=oo`9l02Ioo`0301moogoo0:1oo`0037oo00<007oo
Ool00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0LWoo
00=l07ooOol09goo0P0OX7oo000<Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`1`Ool2O00/Ool00`0OOomoo`2MOol000aoo`03001oogoo009oo`03
001oogoo00Qoo`03001oogoo009oo`03001oogoo00=oo`<006ioo`9l02moo`807ieoo`0037oo00<0
07ooOol00Woo00<007ooOol02Goo10001Woo00<007ooOol0K7oo0W`0<goo0P0OVgoo000<Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`1[Ool00g`0
Oomoo`0eOol201nIOol000aoo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001o
ogoo00=oo`03001oogoo06Uoo`9l03Yoo`807iMoo`003Goo100037oo10001Woo00<007ooOol0Igoo
0W`0?Woo0P0OUGoo000WOol00`00Oomoo`1UOol2O012Ool201nCOol002Moo`03001oogoo06=oo`9l
04Ioo`807i5oo`009goo00<007ooOol0HGoo0W`0BWoo0P0OSgoo000WOol00`00Oomoo`1OOol2O01>
Ool201n=Ool002Moo`8005ioo`9l059oo`807h]oo`009goo00<007ooOol0Fgoo0W`0EWoo0P0ORGoo
000WOol00`00Oomoo`1IOol2O01JOol301n6Ool002Moo`03001oogoo05Moo`9l05moo`807hAoo`00
9goo00<007ooOol0EGoo0W`0Hgoo0P0OPWoo000WOol00`00Oomoo`1COol2O01WOol201n0Ool002Mo
o`03001oogoo055oo`9l06]oo`807gioo`009goo00<007ooOol0CWoo0g`0Kgoo0`0ONgoo000WOol2
001=Ool2O01eOol201miOol002Moo`03001oogoo04Uoo`=l07Uoo`807gMoo`009goo00<007ooOol0
Agoo0W`0OWoo0`0OM7oo000WOol00`00Oomoo`15Ool2O023Ool201mbOol002Moo`03001oogoo049o
o`=l08Moo`<07fmoo`009goo00<007ooOol0?goo0g`0SGoo0`0OK7oo000WOol00`00Oomoo`0lOol3
O02COol201mZOol002Moo`03001oogoo03Uoo`=l09Qoo`<07fMoo`009goo00<007ooOol0=Woo0g`0
WWoo0`0OI7oo000WOol2000cOol4O02TOol401mPOol002Moo`03001oogoo02ioo`Al0:aoo`@07eao
o`009goo00<007ooOol0:Woo17`0]7oo100OF7oo000WOol00`00Oomoo`0VOol4O02lOol401mDOol0
02Moo`03001oogoo029oo`Al0<Aoo`@07e1oo`007Goo1@001Goo00<007ooOol07Goo1G`0c7oo1@0O
Bgoo000OOol00`00Oomoo`05Ool00`00Oomoo`0HOol5O03FOol501m6Ool001moo`03001oogoo00Eo
o`03001oogoo00eoo`]l0>1oo`/07c]oo`007goo00<007ooOol01Goo47`0mWoo400O:goo000OOol0
0`00Oomoo`05Ool00`00Oomoo`3oOoloOol001moo`03001oogoo00Eoo`03001oogoo0?moocmoo`00
7Goo0`001goo00<007ooOol0ogoo?goo000OOol00`00Oomoo`05Ool00`00Oomoo`3oOoloOol00?mo
ofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo
003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`007goo00<007ooOol0ogooAgoo
000OOol2003oOom8Ool001Aoo`H000Ioo`03001oogoo00Eoo`H00?mooc]oo`005Woo00<007ooOol0
1goo0P0027oo00<007ooOol0ogoo?7oo000FOol00`00Oomoo`0AOol00`00Oomoo`3oOollOol001Io
o`03001oogoo015oo`03001oogoo0?moocaoo`005Woo00<007ooOol04Goo00<007ooOol01goo00<0
07ooOol0ogoo<Woo000DOol6000>Ool60006Ool00`00Oomoo`3oOolbOol001Ioo`03001oogoo015o
o`03001oogoo00Moo`03001oogoo0?mooc9oo`005goo0`004Goo0`001Woo00<007ooOol0ogoo<Woo
003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?mo
ofUoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.313, 0}} -> {-0.224207, -0.0869725, \
0.00709105, 0.0073043}}]
}, Open  ]],

Cell[TextData[{
  "The figure shows us the derived behavior of the slope in a more compact \
way. The slope of sin[",
  StyleBox["x",
    FontSlant->"Italic"],
  "] starts with the value 1 at ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  " and finishes with 0 at ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "= \[Pi]/2. "
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "Knowing the geometrical meaning of differentiation, we can ask for \
additional properties of this operation. In the following, we will discuss \
some of these properties. We only state a few of these features known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". One of these properties is the product rule which governs the \
differentiation of a product of functions, ",
  StyleBox["e.g.,\[ThinSpace]",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" f",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". The product rule is implemented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and automatically applied to products of functions:"
}], "Text",
  Evaluatable->False,
  CellTags->"differentiation of a product"],

Cell[BoxData[
    \(Clear[f, g]\)], "Input",
  PageWidth->Infinity],

Cell[CellGroupData[{

Cell[BoxData[
    \(prule = \[PartialD]\_x\((f[x]\ g[x])\) // LieTraditionalForm\)], "Input",\

  PageWidth->Infinity],

Cell[BoxData[
    \(g\ f\_x + f\ g\_x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result represents the expected relation which is known from standard \
texts in calculus. Another feature of derivatives is the rule for rational \
functions. The differentiation of the ratio ",
  StyleBox["f[x]/g[x]",
    FontSlant->"Italic"],
  " gives "
}], "Text",
  CellTags->{"rational function", "differentiation of the ratio"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(qrule = 
      Simplify[\[PartialD]\_x\( f[x]\/g[x]\)] // LieTraditionalForm\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(g\ f\_x - f\ g\_x\)\/g\^2\)], "Output"]
}, Open  ]],

Cell["\<\
which is the standard formula. The chain rule of Leibniz is useful \
in differentiating nested functions \
\>", "Text",
  Evaluatable->False,
  CellTags->"chain rule of Leibniz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(crule = \[PartialD]\_x f[g[x]] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f\_g\ g\_x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which indicates that we first differentiate the function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["g",
    FontSlant->"Italic"],
  " followed by a differentiation of ",
  StyleBox["g",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The properties stated above and more are known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to manage the calculation of differentials."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "In symmetry analysis, we frequently have to deal with functions depending \
on several independent variables. A function of a set of variables can be \
differentiated with respect to one of these variables at a time. The rest of \
the independent variables will stay unchanged in this calculation. The slope \
of a function of several variables is not just a single function, since the \
independent variables may vary in different ways. All the rates of change for \
a function of ",
  StyleBox["m",
    FontSlant->"Italic"],
  " variables are described by ",
  StyleBox["m",
    FontSlant->"Italic"],
  " functions, called its partial derivatives. In the discussion above, we \
introduced the definition of the derivative known as an ordinary derivative \
which is defined for functions depending on a single independent variable. \
The more generic case is that we have functions depending on several \
independent variables. The partial derivatives of a function of several \
variables are its ordinary derivatives with respect to each variable \
separately. We can define this as follows:"
}], "Text",
  Evaluatable->False,
  CellTags->"partial derivativ"],

Cell["Definition: Partial derivative", "Definition",
  CellTags->"Definition: Partial derivative"],

Cell[TextData[{
  "Given a smooth function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^m\  \[Rule] \ 
              \[DoubleStruckCapitalR]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " depending on ",
  StyleBox["m",
    FontSlant->"Italic"],
  " independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_m\)]],
  ", we define the partial derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_q\)]],
  " by"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TextForm
    \`\[PartialD]f\/\[PartialD]x\_q\  = 
      \(\(\ lim\)\+\(h \[Rule] 0\)\) 
        \(\((f \((x\_1, x\_2, \[Ellipsis], \ x\_q + h, \ \[Ellipsis], x\_m)
                      \)\  - f 
                    \((x\_1, x\_2, \[Ellipsis], \ x\_q, \ \[Ellipsis], x\_m)
                      \))\)\/h\) . \[ThickSpace]\[EmptyCircle]\)], 
  "NumberedEquation",
  FontVariations->{"CompatibilityType"->0}],

Cell[TextData[{
  "This formula allows us to calculate the variation of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "with respect to different coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`x\_q\)]],
  ". The partial derivative of a function is an operation known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The partial derivative is accessible under the same pattern ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_\[Placeholder]\ \[Placeholder]\)]],
  ". Although we can access partial derivatives and ordinary derivatives by \
the same symbol ",
  StyleBox["D[]", "MmaText"],
  ", ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "is capable of distinguishing the different operations. Consider, for \
example, a function ",
  Cell[BoxData[
      \(TraditionalForm\`f = f(x\_1, x\_2)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "of two variables.",
  StyleBox[" ",
    FontSlant->"Italic"],
  "If we treat",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  " as a constant, ",
  StyleBox["f",
    FontSlant->"Italic"],
  " may be ",
  "differentiated",
  " with respect to\[NonBreakingSpace]\[NoBreak]",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ". The result is called a partial derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we carry out this by"
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"partial derivative", "D[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_\(x\_1\)f[x\_1, x\_2] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f\_\(x\_1\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting symbol for the representation of a partial derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a superscripted expression of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". The superscripts denote the order of differentiation with respect to the \
independent variables. In our example, we get the first derivative with \
respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ". The derivative with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  " follows in the same way by "
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[
      RowBox[{
        RowBox[{\(\[PartialD]\_\(x\_2\)\), 
          RowBox[{"f", "[", 
            RowBox[{\(x\_1\), ",", 
              StyleBox[\(x\_2\),
                FontColor->GrayLevel[0]]}], "]"}]}], 
        StyleBox[
          RowBox[{
            StyleBox["/",
              FontColor->GrayLevel[0]], "/"}]], "LieTraditionalForm"}],
      FontColor->RGBColor[0, 0, 1]]], "Input"],

Cell[BoxData[
    \(f\_\(x\_2\)\)], "Output"]
}, Open  ]],

Cell["\<\
The combination of both operations allows us to calculate \
higher-order derivatives\
\>", "Text",
  Evaluatable->False,
  CellTags->"higher order derivatives"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{\(\[PartialD]\_\(x\_1, x\_2\)\), 
        RowBox[{"f", "[", 
          RowBox[{
            StyleBox[\(x\_1\),
              FontColor->GrayLevel[0]], ",", 
            StyleBox[\(x\_2\),
              FontColor->GrayLevel[0]]}], "]"}]}], "//", 
      "LieTraditionalForm"}]], "Input"],

Cell[BoxData[
    \(f\_\(x\_1, x\_2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Higher-order derivatives follow by carrying out the differentiation with \
respect to different variables. The calculation of higher derivatives is done \
for functions with only one independent variable in a similar way. Since both \
operations are nearly identical, here we will give only the definition for \
the case with more than one independent variable. The one-dimensional case is \
included in this definition. The ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th-order derivative is defined as follows:"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "Definition: ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th-Order derivative"
}], "Definition",
  CellTags->"Definition: kth order derivative"],

Cell[TextData[{
  "Given a smooth function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^m \[Rule] 
              \[DoubleStruckCapitalR]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " depending on ",
  StyleBox["m",
    FontSlant->"Italic"],
  " independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_q\)]],
  ", we call"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[PartialD]\^k f \((x)\)\)\/\(\[PartialD]x\_\(j\_1\) 
          \[PartialD]x\_\(j\_2\) \[Ellipsis] \[PartialD]x\_\(j\_k\)\) := \ 
      \[PartialD]\_J f \((x)\), \)\)], "NumberedEquation"],

Cell[TextData[{
  "the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th-order partial derivative of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to the ",
  StyleBox["m",
    FontSlant->"Italic"],
  " independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The non-sorted multi-index ",
  StyleBox["J",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\( = \((j\_1\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(, j\)\_2\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(, \[Ellipsis], j\_k\)\)]],
  ") denotes the derivative with respect to one of the ",
  StyleBox["m",
    FontSlant->"Italic"],
  " coordinates. The integers ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] j\_k \[LessEqual] m\)]],
  " of this ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-tuple indicate which derivatives are being taken. The order of \
differentiation ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is equivalent to the sum of all indices ",
  Cell[BoxData[
      \(TraditionalForm\`j\_k\)]],
  ", which we denote by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"|", 
          RowBox[{\(J | \), " ", "=", " ", 
            FormBox[\(\[Sum]\_\(i = 1\)\%k j\_i\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->{"partial derivative", "order of differentiation"}],

Cell[TextData[{
  "Using this definition, we are able to calculate, for example, the \
second-order derivative of the function ",
  StyleBox["f. ",
    FontSlant->"Italic"],
  " The calculation of the partial derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is as simple as the application of the ordinary derivative even for \
higher-order derivatives. For example, the sixth",
  StyleBox["-",
    FontSlant->"Italic"],
  "order derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is derived  by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_\({x1, 2}, {x2, 4}\)f[x1, x2] // LieTraditionalForm\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f\_\(x1, x1, x2, x2, x2, x2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "So far, we discussed simple examples of derivatives already implemented in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The following sections will illustrate how special types of derivatives \
are implemented. We will discuss tangent vectors, vector fields, \
Fr\[EAcute]chet derivatives, prolongations of vector fields, and variational \
derivatives also known as Euler derivatives. The special types of derivatives \
we are going to discuss are useful in examining symmetries of differential \
equations."
}], "Text",
  Evaluatable->False,
  CellTags->{"variational derivative", "Euler derivative"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.2 Tangent Vector", "Section",
  Evaluatable->False,
  CellTags->"tangent vector"],

Cell[TextData[{
  "Sometimes it is important to know how a real-valued function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^n \[Rule] 
              \[DoubleStruckCapitalR]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " varies in different directions. The partial derivative discussed above \
only measures how much\[NonBreakingSpace]\[NoBreak]",
  StyleBox["f",
    FontSlant->"Italic"],
  " changes in a certain direction. However, it is also possible to measure \
the variation of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " in other directions. Measuring the variation of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at a location ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", " ", "\[Element]", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^m\),
            "TraditionalForm"]}], TraditionalForm]]],
  " along a straight line ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = ",
  StyleBox["x",
    FontSlant->"Italic"],
  " + ",
  StyleBox["t",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  ", we need the tangent vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  ". Since we are dealing with differential operators, we define the tangent \
vector as an operator acting in the space of functions. Actually, a tangent \
vector is a vector with a cetrain direction and a finite length. However, in \
view of the application in symmetry analysis, let us define such an \
operator."
}], "Text",
  Evaluatable->False,
  CellTags->{"measure", "tangent vector", "symmetry analysis"}],

Cell["Definition: Tangent vector", "Definition",
  CellTags->"Definition: Tangent vector"],

Cell[TextData[{
  "We assume that",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(f : \[DoubleStruckCapitalR]\^m\),
              "TraditionalForm"], "\[Rule]", "\[DoubleStruckCapitalR]"}], 
          " "}], TraditionalForm]]],
  "is a smooth differentiable function. The tangent vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  " is defined by the relation"
}], "Text",
  Evaluatable->False,
  CellTags->"tangent vector"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(v\&\[RightVector]\_x\),
              "TraditionalForm"], \((f)\)}], " ", "=", " ", 
          FormBox[
            RowBox[{
              FractionBox["d", 
                StyleBox["dt",
                  FontSlant->"Italic"]], 
              \((f(x\&\[RightVector]\  + \ t\ x\&\[RightVector]\_0)
                  \( | \_\(t = 0\)\)\)}],
            "TraditionalForm"]}], ","}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False,
  FontVariations->{"CompatibilityType"->0},
  CellTags->"eq-4"],

Cell[TextData[{
  "where",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(x\_0\),
              "TraditionalForm"], " ", "\[Element]", "  ", 
            FormBox[\(\[DoubleStruckCapitalR]\^n\),
              "TraditionalForm"]}], " "}], TraditionalForm]]],
  "and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " is a real parameter.\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False],

Cell["\<\
This definition is known as directional derivative in calculus. A \
more explicit way to write the definition is given by\
\>", "Text",
  Evaluatable->False,
  CellTags->"directional derivative"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  "(f) = ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderscriptBox[
            FormBox[\(lim\+\(\  \)\),
              "TraditionalForm"], \(t \[Rule] 0\)], 
          
          StyleBox[
            \(\(f(x\&\[RightVector] + t\ x\&\[RightVector]\_0)\  - \ 
                  f(x\&\[RightVector])\)\/t\),
            ScriptLevel->0]}], TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],

Cell[TextData[{
  "Relation (3.5) is more convenient in comparison with the definition of an \
ordinary derivative. On the other hand, equation ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  " is more useful in the implementation of the tangent vector in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Although the second definition (3.5) is based on a complicated \
mathematical process involving the determination of a limit, the first \
expression is easier to handle symbolically. The reason is that equation \
(3.4) contains basic operations like an ordinary differentiation and a \
substitution. Both of these operations are easily handled by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not know how to calculate the tangent vector of a function, we must \
define an operator which handles this kind of calculation. Let us now examine \
equation ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  " in more detail to see how an implementation can be based on it. In the \
calculation of the tangent vector for an arbitrary function ",
  StyleBox["f,",
    FontSlant->"Italic"],
  " we need to know the function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "itself, the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  ", and the support point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\_0\)]],
  ". We use these three components as input parameters for our function ",
  StyleBox["TangentVector[]", "MmaText"],
  ". We define the function ",
  StyleBox["TangentVector[] in", "MmaText"],
  " the following way:"
}], "Text",
  Evaluatable->False,
  CellTags->{"operator", "independent variables", "input", "TangentVector[]"}],

Cell[BoxData[
    \(TangentVector[f_, x_List, x0_List] := \n\t
      Block[{rule, res, t}, \n\t\trule = Thread[x \[Rule] x + t\ x0]; \n\t\t
        res = f /. rule; \n\t\tres = \[PartialD]\_t res /. t \[Rule] 0]\)], 
  "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "These few lines closely follow the definition given in equation ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  ". The lines just state that the original argument is replaced by a new \
argument and that after the replacement, a differentiation with respect to \
the  parameter ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " takes place. At the end of the calculation ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is replaced by zero. The actual calculation is reduced to an ordinary \
differentiation with respect to a parameter. All other operations are \
replacements given as a transformation of the argument and as a side \
condition. The definition given in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is capable of reproducing the general formula in ",
  ButtonBox["(3.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  " at a certain point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\_0\)]],
  ". As an example, we demonstrate here the calculation for a function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " depending on four independent variables:"
}], "Text",
  Evaluatable->False,
  CellTags->"ordinary differentiation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[
        f[x1, x2, x3, x4], {x1, x2, x3, x4}, {x10, x20, x30, x40}] // 
      LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(x10\ f\_x1 + x20\ f\_x2 + x30\ f\_x3 + x40\ f\_x4\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "As expected, the result of our calculation is a sum of four products. Each \
product consists of a partial derivative with respect to the coordinate ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["x", 
          StyleBox["q",
            FontWeight->"Plain",
            FontSlant->"Italic",
            FontTracking->"Plain",
            FontVariations->{"Underline"->False,
            "Outline"->False,
            "Shadow"->False,
            "StrikeThrough"->False,
            "Masked"->False,
            "CompatibilityType"->0,
            "RotationAngle"->0}]], TraditionalForm]]],
  " and the component ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(0\_q\)\)]],
  " of the related location. Similar to the ordinary differentiation, the \
function ",
  StyleBox["TangentVector[]", "MmaText"],
  " satisfies some additional properties. Some of these algebraic features of \
the directional derivative are listed below. Let us assume that we have two \
real numbers ",
  StyleBox["a",
    FontSlant->"Italic"],
  " and",
  StyleBox[" b",
    FontSlant->"Italic"],
  " and two independent functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". Then, we can show that the relation"
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[a\ f[x1, x2] + b\ g[x1, x2], {x1, x2}, {x10, x20}] == \n\t
      a\ TangentVector[f[x1, x2], {x1, x2}, {x10, x20}] + \n\t\t
        b\ TangentVector[g[x1, x2], {x1, x2}, {x10, x20}]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "is satisfied. This behavior of the tangent vector is known as linearity. \
Thus, we can say that ",
  StyleBox["TangentVector[]", "MmaText"],
  " is a linear operator. The application of ",
  StyleBox["TangentVector[]", "MmaText"],
  " on a product gives us"
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[f[x1, x2]\ g[x1, x2], \n\t{x1, x2}, {x10, x20}]\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(g[x1, x2]\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"x20", " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}], "+", 
            RowBox[{"x10", " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], 
          ")"}]}], "+", 
      RowBox[{\(f[x1, x2]\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"x20", " ", 
              RowBox[{
                SuperscriptBox["g", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}], "+", 
            RowBox[{"x10", " ", 
              RowBox[{
                SuperscriptBox["g", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], 
          ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is just the scalar product of the vector ",
  StyleBox["(f, g)",
    FontSlant->"Italic"],
  " with a vector containing the two tangent vectors of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "as elements. There is also a chain rule for the tangent vector similar to \
the case of ordinary differentiation. For example, let ",
  Cell[BoxData[
      \(TraditionalForm\`g\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g\_2\)]],
  " be two differentiable functions depending on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  ". For a function ",
  StyleBox["F",
    FontSlant->"Italic"],
  " given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"scalar product", "tangent vector"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = F[g1[x1, x2], g2[x1, x2]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(F[g1[x1, x2], g2[x1, x2]]\)], "Output"]
}, Open  ]],

Cell["we can derive the tangent vector in the form", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(TangentVector[f, {x1, x2}, {x10, x20}] // LieTraditionalForm\)], "Input",\

  PageWidth->Infinity],

Cell[BoxData[
    \(F\_g1\ \((x10\ g1\_x1 + x20\ g1\_x2)\) + 
      F\_g2\ \((x10\ g2\_x1 + x20\ g2\_x2)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is a superposition of the vector field of ",
  Cell[BoxData[
      \(TraditionalForm\`g\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g\_2\)]],
  " multiplied by the derivatives of ",
  StyleBox["F",
    FontSlant->"Italic"],
  ". As we demonstrated, all these properties are immediately available \
without any additional definitions. This behavior is actually based on the \
implementation of the derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->"superposition"],

Cell[TextData[{
  "The name used for our function to calculate the tangent vector of a given \
function is somewhat misleading. Actually, we calculate a scalar product of \
the tangent vector and a support vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\_0\)]],
  " using our function. In some calculations, however, it is necessary to \
have the vector components of the tangent vector available. Such an \
application, for example, is the calculation of the tangent surface on a \
hypersurface. "
}], "Text",
  Evaluatable->False,
  CellTags->{"components of the tangent vector", "tangent surface"}],

Cell[TextData[{
  "The components of the tangent vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_x\)]],
  " become available by altering ",
  StyleBox["TangentVector[]", "MmaText"],
  " in an appropriate way. The following lines generalize the function in \
such a way that the result of the calculation is a vector of differentials \
applied to a function. We also assume in our definition that the support \
point is arbitrary and thus can be created by the operator ",
  StyleBox["TangentVector[]", "MmaText"],
  " itself:"
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[BoxData[
    \(TangentVector[f_, x_List] := 
      Block[{rule, res, t}, \n\t\t
        x0 = Table[Unique["\<$aU\>"], \n\t\t\t\t{i, 1, Length[x]}]; \n\t\t
        rule = Thread[x \[Rule] x + t\ x0]; \n\t\tres = f /. rule; \n\t\t
        res = \[PartialD]\_t res /. t \[Rule] 0; \n\t\t
        Table[Coefficient[res, x0\[LeftDoubleBracket]i\[RightDoubleBracket]], 
          \n\t\t\t{i, 1, Length[x0]}]]\)], "Input"],

Cell[TextData[{
  "The application of the function ",
  StyleBox["TangentVector[]", "MmaText"],
  " on a function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "depending on three independent variables gives us"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[f]; \n
    TangentVector[f[x1, x2, x3], {x1, x2, x3}] // LieTraditionalForm\)], 
  "Input"],

Cell[BoxData[
    \({f\_x1, f\_x2, f\_x3}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is, in fact, the gradient of the scalar function ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". We note that the function ",
  StyleBox["TangentVector[]", "MmaText"],
  " needs only two arguments, the function ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "and a list of independent variables. "
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[TextData[{
  "For some applications in geometry and physics, we need to calculate the \
tangent surface of a given function. Recalling the definition of the tangent \
of a function given at the beginning of this section, we generalize this \
one-dimensional definition to a two-dimensional version. Using the vector \
representation of the tangent vector at a certain point ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\)]],
  " for the two-dimensional case, we can represent the tangent surface by"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(f\_s\),
                "TraditionalForm"], " ", "=", " ", 
              FormBox[
                RowBox[{
                  FormBox[\(f(x\_0\),
                    "TraditionalForm"], ",", \(y\_0\)}],
                "TraditionalForm"]}], ")"}], " ", "+", " ", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                FormBox[\(x\&\[RightVector]\),
                  "TraditionalForm"], "-", 
                FormBox[\(x\&\[RightVector]\_0\),
                  "TraditionalForm"]}], ")"}], " ", "\[CenterDot]", " ", 
            FormBox[
              RowBox[{
                FormBox[\(v\&\[RightVector]\_x\),
                  "TraditionalForm"], \((f)\)}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  ","
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "representing the sum of the function at the support point ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_0, y\_0)\)\)]],
  " and the scalar product of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            FormBox[\(x\&\[RightVector]\),
              "TraditionalForm"], "-", 
            FormBox[\(x\&\[RightVector]\_0\),
              "TraditionalForm"]}], ")"}], TraditionalForm]]],
  " and the tangent vector. Similar to the definition of a tangent vector, we \
can implement a tangent surface by"
}], "Text",
  Evaluatable->False,
  CellTags->"tangent surface"],

Cell[BoxData[
    \(Clear[TangentSurface]; \n
    TangentSurface[f_, x_List, x0_List] := \n\t
      Block[{rule, tvector, sf, surface}, \n\t\trule = Thread[x \[Rule] x0]; 
        \n\t\ttvector = TangentVector[f, x]; \n\t\tsf = f /. rule; \n\t\t
        surface = sf + \((x - x0)\) . tvector]\)], "Input",
  PageWidth->Infinity,
  CellTags->"TangentSurface[]"],

Cell[TextData[{
  "Using the function ",
  StyleBox["TangentSurface[]", "MmaText"],
  ", we can determine the tangent space located at ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " of a given function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". As an example, let us consider a function ",
  StyleBox["h",
    FontSlant->"Italic"],
  " in a two-dimensional space with coordinates ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  CellTags->"TangentSurface[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h = Sin[x]\ Cos[y]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Cos[y]\ Sin[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["h",
    FontSlant->"Italic"],
  "[",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  "] has the graphical representation"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(pl1 = 
      Plot3D[h, {x, \(-\[Pi]\), \[Pi]\/2}, {y, \(-\[Pi]\), \[Pi]}, 
        AxesLabel \[Rule] {"\<x\>", "\<y\>", "\<h\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-017 1.04977 -0.0679587 1.04977 [
[.04501 .23932 -12 -8.75252 ]
[.04501 .23932 0 .24748 ]
[.17172 .18945 -11.8183 -9 ]
[.17172 .18945 .18174 0 ]
[.30499 .13702 -11.2873 -9 ]
[.30499 .13702 .71266 0 ]
[.44535 .08183 -5.37821 -9 ]
[.44535 .08183 .62179 0 ]
[.59338 .02365 -5.11275 -9 ]
[.59338 .02365 .88725 0 ]
[.29165 .07573 -9.31117 -12.875 ]
[.29165 .07573 .68883 0 ]
[.76162 .0881 0 -6.17057 ]
[.76162 .0881 12 2.82943 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.93925 .36012 0 -5.91342 ]
[.93925 .36012 6 3.08658 ]
[.91861 .21225 0 -8.62807 ]
[.91861 .21225 10 4.24693 ]
[.02411 .26511 -12 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -18 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[-0.05457 .39542 -10 -4.05332 ]
[-0.05457 .39542 0 8.82168 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.05455 .24833 m
.05931 .25284 L
s
[(-3)] .04501 .23932 1 .945 Mshowa
.18085 .19887 m
.18542 .20358 L
s
[(-2)] .17172 .18945 .96971 1 Mshowa
.31367 .14687 m
.318 .15179 L
s
[(-1)] .30499 .13702 .88122 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(0)] .44535 .08183 .79274 1 Mshowa
.60094 .03438 m
.60471 .03974 L
s
[(1)] .59338 .02365 .70425 1 Mshowa
.125 Mabswid
.07931 .23863 m
.08215 .24136 L
s
.10432 .22884 m
.10713 .23159 L
s
.12958 .21895 m
.13237 .22173 L
s
.15509 .20896 m
.15785 .21176 L
s
.20688 .18868 m
.20959 .19153 L
s
.23317 .17839 m
.23586 .18126 L
s
.25973 .16799 m
.26239 .17089 L
s
.28656 .15748 m
.28919 .16041 L
s
.34105 .13614 m
.34363 .13912 L
s
.36873 .12531 m
.37127 .12831 L
s
.39669 .11436 m
.3992 .11739 L
s
.42495 .10329 m
.42743 .10635 L
s
.48236 .08081 m
.48477 .08392 L
s
.51153 .06939 m
.51391 .07253 L
s
.54101 .05784 m
.54335 .06101 L
s
.57081 .04618 m
.57312 .04937 L
s
.63139 .02246 m
.63362 .0257 L
s
.66218 .0104 m
.66436 .01367 L
s
gsave
.29165 .07573 -70.3112 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.74932 .09266 m
.74316 .09495 L
s
[(-2)] .76162 .0881 -1 .37124 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.92673 .36405 m
.92047 .36602 L
s
[(2)] .93925 .36012 -1 .31409 Mshowa
.125 Mabswid
.77428 .13086 m
.77058 .1322 L
s
.79837 .1677 m
.79466 .16902 L
s
.82162 .20326 m
.8179 .20455 L
s
.86578 .27081 m
.86204 .27206 L
s
.88677 .30292 m
.88302 .30414 L
s
.90707 .33398 m
.90332 .33518 L
s
.72342 .05305 m
.71974 .05445 L
s
.69654 .01193 m
.69287 .01336 L
s
.94577 .39318 m
.94201 .39434 L
s
.96423 .4214 m
.96046 .42254 L
s
gsave
.91861 .21225 -61 -12.6281 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(-1)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-0.5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
gsave
-0.05457 .39542 -71 -8.05332 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 56.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 56.000000 4.000000 lineto
 56.000000 16.875000 lineto
closepath
clip newpath
57.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
57.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
0 .381 .827 r
.37901 .68206 .40169 .70185 .43867 .72499 .4162 .70177 Metetra
.145 .484 .9 r
.4162 .70177 .43867 .72499 .47696 .745 .45467 .71857 Metetra
.362 .576 .922 r
.45467 .71857 .47696 .745 .51651 .75812 .49439 .72909 Metetra
.527 .636 .901 r
.49439 .72909 .51651 .75812 .55708 .76125 .53516 .73054 Metetra
.636 .672 .868 r
.53516 .73054 .55708 .76125 .59834 .75246 .57669 .7212 Metetra
.709 .697 .837 r
.57669 .7212 .59834 .75246 .63987 .7313 .6186 .70067 Metetra
.759 .718 .815 r
.6186 .70067 .63987 .7313 .68129 .69895 .66054 .66999 Metetra
.794 .739 .802 r
.66054 .66999 .68129 .69895 .72236 .65799 .70226 .63148 Metetra
.819 .761 .798 r
.70226 .63148 .72236 .65799 .763 .61197 .74368 .58832 Metetra
.834 .786 .805 r
.74368 .58832 .763 .61197 .80334 .56486 .78489 .5441 Metetra
.838 .812 .825 r
.78489 .5441 .80334 .56486 .8437 .52056 .82616 .50235 Metetra
.825 .839 .858 r
.82616 .50235 .8437 .52056 .88455 .48246 .86791 .46617 Metetra
.784 .859 .905 r
.86791 .46617 .88455 .48246 .92646 .45313 .91066 .43795 Metetra
.701 .856 .956 r
.91066 .43795 .92646 .45313 .97003 .43424 .95495 .41922 Metetra
.253 .583 .945 r
.35573 .66174 .37901 .68206 .4162 .70177 .39341 .67182 Metetra
.431 .583 .903 r
.39341 .67182 .4162 .70177 .45467 .71857 .43217 .67972 Metetra
.529 .574 .845 r
.43217 .67972 .45467 .71857 .49439 .72909 .47202 .68316 Metetra
.588 .573 .804 r
.47202 .68316 .49439 .72909 .53516 .73054 .51283 .68027 Metetra
.631 .581 .78 r
.51283 .68027 .53516 .73054 .57669 .7212 .5544 .6699 Metetra
.667 .597 .768 r
.5544 .6699 .57669 .7212 .6186 .70067 .59648 .65179 Metetra
.699 .621 .767 r
.59648 .65179 .6186 .70067 .66054 .66999 .63883 .62663 Metetra
.73 .655 .775 r
.63883 .62663 .66054 .66999 .70226 .63148 .68126 .59595 Metetra
.761 .701 .795 r
.68126 .59595 .70226 .63148 .74368 .58832 .72369 .56189 Metetra
.791 .765 .829 r
.72369 .56189 .74368 .58832 .78489 .5441 .76619 .5269 Metetra
.811 .848 .877 r
.76619 .5269 .78489 .5441 .82616 .50235 .80891 .49347 Metetra
.789 .939 .927 r
.80891 .49347 .82616 .50235 .86791 .46617 .85216 .46381 Metetra
.65 .964 .917 r
.85216 .46381 .86791 .46617 .91066 .43795 .8963 .43964 Metetra
.387 .846 .801 r
.8963 .43964 .91066 .43795 .95495 .41922 .94172 .42211 Metetra
.559 .723 .95 r
.33183 .64088 .35573 .66174 .39341 .67182 .37031 .63697 Metetra
.597 .63 .854 r
.37031 .63697 .39341 .67182 .43217 .67972 .40956 .63213 Metetra
.61 .578 .793 r
.40956 .63213 .43217 .67972 .47202 .68316 .44959 .62554 Metetra
.618 .553 .758 r
.44959 .62554 .47202 .68316 .51283 .68027 .49038 .61659 Metetra
.627 .544 .742 r
.49038 .61659 .51283 .68027 .5544 .6699 .53184 .60489 Metetra
.637 .548 .738 r
.53184 .60489 .5544 .6699 .59648 .65179 .57392 .59035 Metetra
.65 .564 .745 r
.57392 .59035 .59648 .65179 .63883 .62663 .61652 .57319 Metetra
.667 .595 .765 r
.61652 .57319 .63883 .62663 .68126 .59595 .65959 .55392 Metetra
.689 .647 .803 r
.65959 .55392 .68126 .59595 .72369 .56189 .7031 .53327 Metetra
.713 .733 .866 r
.7031 .53327 .72369 .56189 .76619 .5269 .74707 .51208 Metetra
.717 .864 .951 r
.74707 .51208 .76619 .5269 .80891 .49347 .79157 .49126 Metetra
.567 .932 .924 r
.79157 .49126 .80891 .49347 .85216 .46381 .8367 .47163 Metetra
.8367 .47163 .85216 .46381 .8963 .43964 .88263 .45384 Metetra
.06 0 0 r
.88263 .45384 .8963 .43964 .94172 .42211 .92949 .43834 Metetra
.721 .764 .887 r
.30728 .61945 .33183 .64088 .37031 .63697 .34685 .59994 Metetra
.691 .658 .813 r
.34685 .59994 .37031 .63697 .40956 .63213 .38679 .58109 Metetra
.663 .594 .768 r
.38679 .58109 .40956 .63213 .44959 .62554 .42713 .56365 Metetra
.643 .557 .742 r
.42713 .56365 .44959 .62554 .49038 .61659 .46791 .5482 Metetra
.628 .535 .731 r
.46791 .5482 .49038 .61659 .53184 .60489 .50923 .53509 Metetra
.617 .527 .73 r
.50923 .53509 .53184 .60489 .57392 .59035 .55119 .52439 Metetra
.609 .531 .742 r
.55119 .52439 .57392 .59035 .61652 .57319 .5939 .51589 Metetra
.603 .551 .769 r
.5939 .51589 .61652 .57319 .65959 .55392 .63746 .50911 Metetra
.598 .595 .819 r
.63746 .50911 .65959 .55392 .7031 .53327 .68193 .50337 Metetra
.585 .679 .905 r
.68193 .50337 .7031 .53327 .74707 .51208 .72734 .49781 Metetra
.507 .801 .998 r
.72734 .49781 .74707 .51208 .79157 .49126 .77365 .49152 Metetra
.204 .732 .796 r
.77365 .49152 .79157 .49126 .8367 .47163 .8208 .48364 Metetra
.092 0 0 r
.8208 .48364 .8367 .47163 .88263 .45384 .86867 .47343 Metetra
.195 0 0 r
.86867 .47343 .88263 .45384 .92949 .43834 .91714 .4604 Metetra
.793 .769 .831 r
.28205 .59743 .30728 .61945 .34685 .59994 .32285 .56374 Metetra
.748 .684 .79 r
.32285 .56374 .34685 .59994 .38679 .58109 .36364 .53234 Metetra
.706 .623 .762 r
.36364 .53234 .38679 .58109 .42713 .56365 .40443 .5053 Metetra
.669 .58 .746 r
.40443 .5053 .42713 .56365 .46791 .5482 .44533 .48414 Metetra
.634 .548 .74 r
.44533 .48414 .46791 .5482 .50923 .53509 .48656 .46975 Metetra
.601 .528 .744 r
.48656 .46975 .50923 .53509 .55119 .52439 .5284 .46233 Metetra
.568 .518 .76 r
.5284 .46233 .55119 .52439 .5939 .51589 .57114 .46135 Metetra
.53 .521 .79 r
.57114 .46135 .5939 .51589 .63746 .50911 .61503 .46559 Metetra
.482 .544 .843 r
.61503 .46559 .63746 .50911 .68193 .50337 .66024 .47322 Metetra
.403 .592 .921 r
.66024 .47322 .68193 .50337 .72734 .49781 .70683 .48193 Metetra
.24 .643 .96 r
.70683 .48193 .72734 .49781 .77365 .49152 .75473 .48916 Metetra
0 .563 .744 r
.75473 .48916 .77365 .49152 .8208 .48364 .8037 .49239 Metetra
.156 0 0 r
.8037 .49239 .8208 .48364 .86867 .47343 .8534 .48943 Metetra
.159 0 0 r
.8534 .48943 .86867 .47343 .91714 .4604 .90343 .47876 Metetra
.823 .767 .8 r
.25611 .57479 .28205 .59743 .32285 .56374 .29811 .53105 Metetra
.786 .712 .782 r
.29811 .53105 .32285 .56374 .36364 .53234 .33977 .49088 Metetra
.745 .666 .773 r
.33977 .49088 .36364 .53234 .40443 .5053 .3811 .45715 Metetra
.699 .625 .77 r
.3811 .45715 .40443 .5053 .44533 .48414 .42227 .432 Metetra
.648 .589 .774 r
.42227 .432 .44533 .48414 .48656 .46975 .46358 .41662 Metetra
.59 .557 .786 r
.46358 .41662 .48656 .46975 .5284 .46233 .50542 .41129 Metetra
.522 .53 .805 r
.50542 .41129 .5284 .46233 .57114 .46135 .5482 .41528 Metetra
.44 .509 .833 r
.5482 .41528 .57114 .46135 .61503 .46559 .59231 .42695 Metetra
.339 .496 .868 r
.59231 .42695 .61503 .46559 .66024 .47322 .63801 .44375 Metetra
.216 .495 .901 r
.63801 .44375 .66024 .47322 .70683 .48193 .68543 .46241 Metetra
.084 .507 .902 r
.68543 .46241 .70683 .48193 .75473 .48916 .73446 .47922 Metetra
0 .53 .838 r
.73446 .47922 .75473 .48916 .8037 .49239 .7848 .49039 Metetra
.001 .577 .745 r
.7848 .49039 .8037 .49239 .8534 .48943 .83594 .49261 Metetra
.83594 .49261 .8534 .48943 .90343 .47876 .88728 .48355 Metetra
.831 .765 .79 r
.22944 .55152 .25611 .57479 .29811 .53105 .27233 .50377 Metetra
.812 .747 .792 r
.27233 .50377 .29811 .53105 .33977 .49088 .31475 .4601 Metetra
.781 .727 .803 r
.31475 .4601 .33977 .49088 .3811 .45715 .35667 .42367 Metetra
.736 .705 .822 r
.35667 .42367 .3811 .45715 .42227 .432 .39827 .3968 Metetra
.67 .676 .847 r
.39827 .3968 .42227 .432 .46358 .41662 .43987 .38081 Metetra
.578 .637 .873 r
.43987 .38081 .46358 .41662 .50542 .41129 .48192 .37598 Metetra
.457 .584 .892 r
.48192 .37598 .50542 .41129 .5482 .41528 .52489 .38155 Metetra
.319 .523 .897 r
.52489 .38155 .5482 .41528 .59231 .42695 .56921 .39569 Metetra
.191 .469 .888 r
.56921 .39569 .59231 .42695 .63801 .44375 .61522 .41564 Metetra
.11 .446 .881 r
.61522 .41564 .63801 .44375 .68543 .46241 .66308 .43776 Metetra
.1 .474 .894 r
.66308 .43776 .68543 .46241 .73446 .47922 .71272 .45791 Metetra
.175 .559 .933 r
.71272 .45791 .73446 .47922 .7848 .49039 .7638 .47183 Metetra
.329 .686 .98 r
.7638 .47183 .7848 .49039 .83594 .49261 .81579 .47575 Metetra
.52 .81 .998 r
.81579 .47575 .83594 .49261 .88728 .48355 .868 .46699 Metetra
.823 .767 .8 r
.202 .52757 .22944 .55152 .27233 .50377 .2453 .48265 Metetra
.822 .789 .821 r
.2453 .48265 .27233 .50377 .31475 .4601 .28819 .44136 Metetra
.807 .813 .856 r
.28819 .44136 .31475 .4601 .35667 .42367 .33064 .4066 Metetra
.764 .834 .905 r
.33064 .4066 .35667 .42367 .39827 .3968 .37279 .38051 Metetra
.674 .834 .96 r
.37279 .38051 .39827 .3968 .43987 .38081 .41493 .36431 Metetra
.517 .786 .994 r
.41493 .36431 .43987 .38081 .48192 .37598 .45748 .35826 Metetra
.322 .682 .978 r
.45748 .35826 .48192 .37598 .52489 .38155 .50088 .36165 Metetra
.168 .569 .934 r
.50088 .36165 .52489 .38155 .56921 .39569 .54554 .37278 Metetra
.108 .501 .905 r
.54554 .37278 .56921 .39569 .61522 .41564 .59179 .38911 Metetra
.143 .491 .904 r
.59179 .38911 .61522 .41564 .66308 .43776 .63982 .40732 Metetra
.245 .523 .914 r
.63982 .40732 .66308 .43776 .71272 .45791 .68957 .42364 Metetra
.374 .572 .916 r
.68957 .42364 .71272 .45791 .7638 .47183 .74079 .43423 Metetra
.498 .621 .903 r
.74079 .43423 .7638 .47183 .81579 .47575 .79299 .43573 Metetra
.603 .663 .881 r
.79299 .43573 .81579 .47575 .868 .46699 .84556 .42574 Metetra
.793 .769 .831 r
.17377 .50293 .202 .52757 .2453 .48265 .21683 .46715 Metetra
.806 .84 .877 r
.21683 .46715 .2453 .48265 .28819 .44136 .25979 .43373 Metetra
.785 .917 .927 r
.25979 .43373 .28819 .44136 .33064 .4066 .30262 .40477 Metetra
.684 .955 .95 r
.30262 .40477 .33064 .4066 .37279 .38051 .34538 .38182 Metetra
.478 .895 .9 r
.34538 .38182 .37279 .38051 .41493 .36431 .3883 .36579 Metetra
.25 .763 .816 r
.3883 .36579 .41493 .36431 .45748 .35826 .43167 .35688 Metetra
.11 .662 .791 r
.43167 .35688 .45748 .35826 .50088 .36165 .47582 .35453 Metetra
.091 .629 .856 r
.47582 .35453 .50088 .36165 .54554 .37278 .52106 .35752 Metetra
.185 .633 .942 r
.52106 .35752 .54554 .37278 .59179 .38911 .56765 .36395 Metetra
.321 .621 .957 r
.56765 .36395 .59179 .38911 .63982 .40732 .61572 .37147 Metetra
.432 .596 .913 r
.61572 .37147 .63982 .40732 .68957 .42364 .66529 .37744 Metetra
.51 .578 .859 r
.66529 .37744 .68957 .42364 .74079 .43423 .71617 .37926 Metetra
.566 .572 .819 r
.71617 .37926 .74079 .43423 .79299 .43573 .76806 .37466 Metetra
.61 .577 .792 r
.76806 .37466 .79299 .43573 .84556 .42574 .82056 .36208 Metetra
.721 .764 .887 r
.1447 .47755 .17377 .50293 .21683 .46715 .18688 .45551 Metetra
.718 .882 .957 r
.18688 .45551 .21683 .46715 .25979 .43373 .22947 .43411 Metetra
.603 .942 .939 r
.22947 .43411 .25979 .43373 .30262 .40477 .27243 .41414 Metetra
.351 .818 .744 r
.27243 .41414 .30262 .40477 .34538 .38182 .3158 .3962 Metetra
.3158 .3962 .34538 .38182 .3883 .36579 .35968 .38064 Metetra
.35968 .38064 .3883 .36579 .43167 .35688 .40417 .36755 Metetra
.40417 .36755 .43167 .35688 .47582 .35453 .44941 .35669 Metetra
.213 .738 .783 r
.44941 .35669 .47582 .35453 .52106 .35752 .49555 .34758 Metetra
.433 .826 .984 r
.49555 .34758 .52106 .35752 .56765 .36395 .54269 .33948 Metetra
.555 .754 .97 r
.54269 .33948 .56765 .36395 .61572 .37147 .5909 .33151 Metetra
.59 .656 .882 r
.5909 .33151 .61572 .37147 .66529 .37744 .64019 .32273 Metetra
.6 .591 .814 r
.64019 .32273 .66529 .37744 .71617 .37926 .69054 .31222 Metetra
.606 .556 .772 r
.69054 .31222 .71617 .37926 .76806 .37466 .74184 .29922 Metetra
.614 .541 .749 r
.74184 .29922 .76806 .37466 .82056 .36208 .79398 .28321 Metetra
.559 .723 .95 r
.11475 .45142 .1447 .47755 .18688 .45551 .15558 .44501 Metetra
.462 .826 .994 r
.15558 .44501 .18688 .45551 .22947 .43411 .19739 .43755 Metetra
.238 .755 .793 r
.19739 .43755 .22947 .43411 .27243 .41414 .24024 .42819 Metetra
.24024 .42819 .27243 .41414 .3158 .3962 .28414 .41625 Metetra
.28414 .41625 .3158 .3962 .35968 .38064 .32905 .40133 Metetra
.32905 .40133 .35968 .38064 .40417 .36755 .37488 .38333 Metetra
.37488 .38333 .40417 .36755 .44941 .35669 .42152 .3625 Metetra
.488 .901 .824 r
.42152 .3625 .44941 .35669 .49555 .34758 .46886 .33936 Metetra
.691 .938 .964 r
.46886 .33936 .49555 .34758 .54269 .33948 .51683 .31469 Metetra
.727 .816 .92 r
.51683 .31469 .54269 .33948 .5909 .33151 .5654 .2894 Metetra
.699 .696 .844 r
.5654 .2894 .5909 .33151 .64019 .32273 .61459 .26443 Metetra
.667 .616 .788 r
.61459 .26443 .64019 .32273 .69054 .31222 .66447 .24062 Metetra
.641 .565 .754 r
.66447 .24062 .69054 .31222 .74184 .29922 .71519 .21869 Metetra
.622 .536 .736 r
.71519 .21869 .74184 .29922 .79398 .28321 .76691 .19907 Metetra
.253 .583 .945 r
.08389 .42449 .11475 .45142 .15558 .44501 .1232 .43245 Metetra
.079 .596 .881 r
.1232 .43245 .15558 .44501 .19739 .43755 .16403 .43804 Metetra
.034 0 0 r
.16403 .43804 .19739 .43755 .24024 .42819 .20658 .43875 Metetra
.023 0 0 r
.20658 .43875 .24024 .42819 .28414 .41625 .25089 .43255 Metetra
.25089 .43255 .28414 .41625 .32905 .40133 .29681 .41821 Metetra
.29681 .41821 .32905 .40133 .37488 .38333 .34403 .39543 Metetra
.533 .912 .761 r
.34403 .39543 .37488 .38333 .42152 .3625 .39221 .36499 Metetra
.748 .99 .883 r
.39221 .36499 .42152 .3625 .46886 .33936 .44097 .32855 Metetra
.827 .933 .9 r
.44097 .32855 .46886 .33936 .51683 .31469 .49004 .28844 Metetra
.813 .825 .859 r
.49004 .28844 .51683 .31469 .5654 .2894 .53925 .24731 Metetra
.769 .727 .814 r
.53925 .24731 .5654 .2894 .61459 .26443 .58864 .20782 Metetra
.721 .651 .779 r
.58864 .20782 .61459 .26443 .66447 .24062 .63836 .1723 Metetra
.677 .595 .756 r
.63836 .1723 .66447 .24062 .71519 .21869 .68873 .14255 Metetra
.637 .555 .745 r
.68873 .14255 .71519 .21869 .76691 .19907 .74018 .11974 Metetra
0 .381 .827 r
.05208 .39672 .08389 .42449 .1232 .43245 .09011 .41475 Metetra
0 .399 .771 r
.09011 .41475 .1232 .43245 .16403 .43804 .13008 .42959 Metetra
0 .489 .744 r
.13008 .42959 .16403 .43804 .20658 .43875 .17234 .4375 Metetra
.091 .649 .778 r
.17234 .4375 .20658 .43875 .25089 .43255 .21695 .43539 Metetra
.357 .831 .849 r
.21695 .43539 .25089 .43255 .29681 .41821 .26372 .42132 Metetra
.615 .955 .901 r
.26372 .42132 .29681 .41821 .34403 .39543 .3122 .39485 Metetra
.782 .983 .904 r
.3122 .39485 .34403 .39543 .39221 .36499 .36182 .35719 Metetra
.854 .944 .877 r
.36182 .35719 .39221 .36499 .44097 .32855 .41201 .31093 Metetra
.867 .882 .845 r
.41201 .31093 .44097 .32855 .49004 .28844 .46228 .25961 Metetra
.848 .816 .818 r
.46228 .25961 .49004 .28844 .53925 .24731 .51239 .20719 Metetra
.812 .753 .798 r
.51239 .20719 .53925 .24731 .58864 .20782 .56232 .15749 Metetra
.767 .697 .785 r
.56232 .15749 .58864 .20782 .63836 .1723 .61229 .1138 Metetra
.716 .647 .779 r
.61229 .1138 .63836 .1723 .68873 .14255 .66273 .07859 Metetra
.661 .603 .779 r
.66273 .07859 .68873 .14255 .74018 .11974 .71423 .05343 Metetra
0 .292 .757 r
.01926 .36808 .05208 .39672 .09011 .41475 .05672 .38958 Metetra
0 .37 .799 r
.05672 .38958 .09011 .41475 .13008 .42959 .09633 .40763 Metetra
.075 .536 .901 r
.09633 .40763 .13008 .42959 .17234 .4375 .13851 .41798 Metetra
.354 .723 .987 r
.13851 .41798 .17234 .4375 .21695 .43539 .1834 .41711 Metetra
.596 .837 .99 r
.1834 .41711 .21695 .43539 .26372 .42132 .23079 .40279 Metetra
.743 .87 .939 r
.23079 .40279 .26372 .42132 .3122 .39485 .28017 .37454 Metetra
.816 .863 .883 r
.28017 .37454 .3122 .39485 .36182 .35719 .33087 .33373 Metetra
.848 .844 .84 r
.33087 .33373 .36182 .35719 .41201 .31093 .3822 .28335 Metetra
.858 .823 .813 r
.3822 .28335 .41201 .31093 .46228 .25961 .43358 .22742 Metetra
.852 .802 .801 r
.43358 .22742 .46228 .25961 .51239 .20719 .48468 .17039 Metetra
.834 .78 .8 r
.48468 .17039 .51239 .20719 .56232 .15749 .53544 .11653 Metetra
.803 .757 .81 r
.53544 .11653 .56232 .15749 .61229 .1138 .58609 .06944 Metetra
.757 .729 .826 r
.58609 .06944 .61229 .1138 .66273 .07859 .63708 .03184 Metetra
.693 .694 .847 r
.63708 .03184 .66273 .07859 .71423 .05343 .68905 .00539 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.05455 .24833 m
.05931 .25284 L
s
[(-3)] .04501 .23932 1 .945 Mshowa
.18085 .19887 m
.18542 .20358 L
s
[(-2)] .17172 .18945 .96971 1 Mshowa
.31367 .14687 m
.318 .15179 L
s
[(-1)] .30499 .13702 .88122 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(0)] .44535 .08183 .79274 1 Mshowa
.60094 .03438 m
.60471 .03974 L
s
[(1)] .59338 .02365 .70425 1 Mshowa
.125 Mabswid
.07931 .23863 m
.08215 .24136 L
s
.10432 .22884 m
.10713 .23159 L
s
.12958 .21895 m
.13237 .22173 L
s
.15509 .20896 m
.15785 .21176 L
s
.20688 .18868 m
.20959 .19153 L
s
.23317 .17839 m
.23586 .18126 L
s
.25973 .16799 m
.26239 .17089 L
s
.28656 .15748 m
.28919 .16041 L
s
.34105 .13614 m
.34363 .13912 L
s
.36873 .12531 m
.37127 .12831 L
s
.39669 .11436 m
.3992 .11739 L
s
.42495 .10329 m
.42743 .10635 L
s
.48236 .08081 m
.48477 .08392 L
s
.51153 .06939 m
.51391 .07253 L
s
.54101 .05784 m
.54335 .06101 L
s
.57081 .04618 m
.57312 .04937 L
s
.63139 .02246 m
.63362 .0257 L
s
.66218 .0104 m
.66436 .01367 L
s
gsave
.29165 .07573 -70.3112 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{331, 163.313},
  ImageMargins->{{0, 0}, {0, 3.25}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005;0000Xa000`40O003h00OogooC7oo002mOol5
0029Ool00;moo`03001oogoo08Uoo`00_goo00<007ooOol0RGoo002oOol00`00Oomoo`29Ool00;mo
o`03001oogoo015oo`8007Ioo`00_Woo0P004Goo1@00MGoo003>Ool500000eJj0000001eOol00<]o
o`<00006Ool00000E[YJfUJj0`00M7oo0039Ool20002Ool20005E[X01000E[X00000Lgoo0036Ool4
00000goo00000003E[X01U[JE[YF^UJj001F^P8007=oo`00Ogoo0P0000=oo`000000?goo0`0017oo
00<005JjE[X01eJj00<005JjE[X00P00LWoo0020Ool00`00Ool0000nOol30004Ool200001F;j001F
^UJjF]X00eJj00QJfUJj001F^U[J001oo`00LGoo0021Ool00`00Oomoo`0MOol2000KOol30006Ool0
1@00G]UNfUkI000025Jj00@005JjE[YF^P80075oo`00Ogoo0P0000=oo`00000077oo00@007ooOol0
01Qoo`8000Moo`800006G]URnUkIG_YNf@000eJj00EJfUJjE[YF^P0000=F^P03001oo`00071oo`00
X7oo00@007ooOol001Eoo`<000Qoo`04001NfEkIG]X3G]T00ekJ001F^P06E[X00`00E[YF^P02E[X3
001_Ool00:1oo`04001oogoo000COol2000:Ool03000G_YNfF;jG]UNnUkIH_YNfEkj001JfP=F^P05
F]YF^P00E[YJfP0300000goo001oo`1^Ool00:1oo`04001oogoo000@Ool3000:Ool20002G]T01EkJ
G]UNfEkIG]X00ekI00<005JjE[X01EJj0P000e9H00<007oo0000KWoo002QOol2000>Ool3000<Ool0
4@00G]UNnUkIH_YNfEkjG]URnUkIG_YNfF;jG]T005JjF]X00UJj0`0000MBN59GEWQBF000Ool0000<
Ool4001NOol00:moo`@000aoo`05001Rn@00G]UNfP03G]T01EkJG]UNfEkIG]X00UkI00<005JjE[X0
0P000U9H00<0059HDUP00e9H00<007oo00002goo00<007ooOol0Ggoo002/Ool3000?Ool04@00H_UV
n@00H_YNfEkjG]URnUkIG_YNfF;jG]UNnUkIH_X00P0000]BEeIhDUQBN000EWQBF59hDUMFN000009o
o`03001oogoo00Uoo`03001oogoo05ioo`00ZWoo0`0047oo00<006;iI_T00VKi00@005kIG]UNfP=N
f@04G]YNfEkIG]T30005DUP00`00DUQBF003DUP01000Oomoo`0017oo100017oo00<007ooOol0GGoo
002WOol3000AOol2000086;iI_URn6LIH_T005kIH_YNfEkjG]URnUkIG_YNf@00FWQJV5Ig001BF59h
DUMFN000DWQBEeIhDUQBN59G0002Ool00`00Oomoo`07Ool01000Oomoo`00GWoo0025Ool5000KOol2
000COol00`00I_URn@03I_T016;iI_UVn@000ekI00INfUkIG]UNf@00FWP3FYP00`00DUQBF002DUP0
0`00DUQBF004DUP00`00Ool000020009Ool2001OOol008Moo`03001oogoo01Qoo`<0009oo`03001o
ogoo00moo`0@001W6F;iI_URn6LIH_UVnF;hIaT005kjG]URnUkIG_X200004UYhFYQFMeZHFWQJV000
EWQBF59h001FN59HDWQBEeIhDUP000=oo`03001oogoo06Qoo`00Qgoo00<007ooOol05Goo0`005Woo
00<006KiH_T00fKi00QRnFKiI_UVnF;iI_T005kJ0UkI00<005ZHFWP00eZH00AJN5ZHFYP000=BF003
001BF59H00EBF005001oogooOol0001YOol007moo`@000Aoo`03001oogoo01=oo`8001Qoo`0?001W
6F;iI_URn6LIH_UVnF;hIaURnFKiH_P005kI0080000FFYQJN5ZHEWMJV5YhFYQFMeZH001BN59GEWP0
059hDUMFN59HDWQBEeIh0004Ool00`00Oomoo`1VOol008Moo`03001oogoo011oo`<001Uoo`03001V
nF;i00=Vn@05H_UVnFKiI_URn@03I_T01F;i001JV5ZHFWP00eZH00MJN5ZHFYQJV5YhFYP00002DUP0
0`00DUQBF006DUP01@00Oomoogoo0000J7oo0026Ool2000@Ool2000KOol03`00JaT006KiH_QW6F;i
I_URn6LIH_UVnF;hIaURn@0200005eZHFWQJV5IgFYQJN5ZHEWMJV5YhFYQFM`00DUQBN000EWQBF59h
DUMFN59HDWP00P0017oo00<007ooOol0IGoo002EOol3000LOol01000JaUW60000VKi00ERnFKiI_UV
nF;i00=Vn@800003G[QR^00000=JV005FWQJV5ZHFYQJN003FYP015Yh001BF0001E9H0P0000=B=`00
Ool017oo00<007ooOol0I7oo002BOol300000goo001oo`0KOol09@00JaUW66/II_P006;iI_URn6LI
H_UVnF;hIaT006;HG[QRf5jh001FMeZHFWQJV5IgFYQJN5ZHEWMJV5YhFYP005Ih001BN59G00<00005
CQIB=dhFDSL00004Ool00`00Oomoo`1TOol0091oo`80021oo`07001[6FLHJaU[66/I00000fKi00eR
nFKiI_UVn@00H[QN^6:hG[QR^5jh001JN003FYP01EYhFYQJV5ZHFWP00eZH10000dhg00EB=dhgCSM>
=`0000Eoo`03001oogoo06=oo`00SGoo0`0000=oo`00Ool07Woo02<006/IIaQ[6FKhJaUW66/I001W
6F;iI_URn6LI001Rf5jhH]QN^6;HG[QRf000FYQFMeZHFWQJV5IgFYQJN5ZHEWMJV5Yh0080000:DSM>
5U8gCQIB=dhFDSM>5U8g0006Ool00`00Oomoo`1ROol006Yoo`@001eoo`8002Aoo`0:001W66/IJaQ[
6FLHJaU[66/I0002I_T2000036:hG[QR^5jhH[QN^6:hG[QR^000FYQJN0=JV004FWQJV5ZHFYP40003
CSL01E8gCSM>=dhgDSL00Thg00<007ooOol00goo00<007ooOol0HWoo001ZOol00`00Oomoo`0KOol3
00000goo001oo`0ROol08000IaQ[6FKhJaUW66/II_Q[6FLH001Rn000G[QRf5jhH]QN^6;HG[QRf5jh
H]QN^000FWQJV5IgFYQJN5ZHEWL200003eIGDUMFF000DSM>5U8gCQIB=dhFDSM>5U8gCQH00006Ool0
0`00Oomoo`1QOol006]oo`03001oogoo01Moo`<002Moo`0K001W66/IJaQ[6FLHJaU[66/IIaQ[6F/H
001N^6:hG[QR^5jhH[QN^6:hG[QR^5jhH[QN^000009JV005FWQJV5ZH001BE`03EUL0159G001>=e8g
0dhg00IB=dhgCSM>=e8g0007Ool00`00Oomoo`1POol006Aoo`@000Aoo`03001oogoo01Aoo`800003
Ool007oo02Ioo`0<001W66/II_Q[6FLHJaUVn6/IIaQ[6FKh0P00015Rf5jhH]QN^6;HG[QRf5jhH]QN
^6;HG[QRf000FYQJN5ZH0080000CDUMFEe9GEUQBEeIG001B=dhFDSM>5U8gCQIB=dhFDSM>5U8g0000
1Woo00<007ooOol0H7oo001ZOol01000Oomoo`004Woo0`00:Woo01d006LHJaU[66/IIaQ[6F/HJaUW
66/IJaP006KhI_T006:hG[QR^5jhH[QN^6:hG[QR^5jhH[QN^6:h00<00003EUMBEeIG009FE`03DUMF
EeIG0080009>=`05DSM>=dhgCSMB=`03CSL00`00Oomoo`04Ool2001QOol006]oo`80015oo`800003
Ool007oo02Uoo`0Y001W66/II_Q[6FLHJaUVn6/IIaQ[6FKh001Vn6KiH_P005jhH]QN^6;HG[QRf5jh
H]QN^6;HG[QRf5jh001BEeIHDUMFEe9GEUQBEeIGDUMFF00200002dhFDSM>5U8gCQIB=dhFDSM>5U8g
00001goo00<007ooOol0Ggoo001kOol3000]Ool07@00JaP006/HJaUW66/IJaQ[6FLHJaU[6000I_QV
nFKhI_UVn000G[QR^5jhH[QN^6:hG[QR^5jhH[P00`0000=FEe9GEUL00UIG00EBEeIGEUMFEe9G0080
0005DSM>=dhgCSMB=`03CSL0158gCSM>=`001goo00<007ooOol0GWoo001hOol300000goo001oo`0/
Ool0>@00JaQ_>@00JaUW66/II_Q[6FLHJaUVn000I_QVnF;hI_UVn6Ki001Rf5jhH]QN^6;HG[QRf5jh
H]P005ZHFWMJV000EUMBEeIHDUMFEe9GEUQBEeIG001FF000DSM>5U8gCQIB=dhFDSM>5U8gCQH00008
Ool00`00Oomoo`0EOol20016Ool007Ioo`80035oo`03001[66/i009[>@0I001[6F/HJaUW66/IJaP0
06KhI_UVn6KiI_QVnFKhI_T006:hG[QR^5jhH[QN^6:h000015ZH00@005IGEUMBE`=FE`04DUMFEeIG
EUL200000dhgDSM>=`02CSL01U8gCSM>=dhgDSL000Qoo`03001oogoo01Ioo`03001oogoo04Aoo`00
Lgoo1000<Goo01`006/HKcU[66liJaQ_>@00JaUW66/II_P006KhI_URn6KiI_QVnF;hI_UVn000G[QR
f5jhH]QN^080000@FYQJMeZHFWQJV5Yg001BEeIGDUMFF59GEUMBEeIHDUL20000358gCQIB=dhFDSM>
5U8gCQIB=dhFDSL000Qoo`03001oogoo01Ioo`03001oogoo04=oo`00LGoo0P00=7oo00<006/HJcT0
0V/i01Q[66/iJcU[>@00JaU[6000I_QVnFKhI_UVn6KiI_QVnFKhI_UVn000G[QR^5jh0008FYP01@00
EUMFEeIGDUL00eIG00EBEeIG001FE`00009>=`05DSM>=dhgCSMB=`02CSL20009Ool00`00Oomoo`0D
Ool00`00Ool00014Ool0059oo`8001Yoo`<00003Ool007oo03=oo`0J001_>F/HKcU[66liJaQ_>F/H
001Vn000I_QVnF;hI_UVn6KiH_QVnFKhI_URn6Ki001Rf080000MFWQJV5YgFYQJN5ZHFWMJV5Yh001B
EeIHDUMFEe9GEUQBEeIGDUL0059G001>5U8gCQIB=dhFDSM>5P0200000dhg001oo`08Ool2000DOol0
1000Oomoo`00A7oo001AOol01000Oomoo`005goo0P00>7oo00D006/iJcU[>F/H00=[>@0CJaQ[>F/i
001Vn6KiI_QVnFKhI_UVn6KiI_QVnFKhI_UVn6Ki000035ZH00<0059GEUL00UIG00QBEeIGEUMFE`00
EUL0058g0dhg0`0000E>5ThGCQI>5`0000Uoo`03001oogoo015oo`<00003Ool0000004=oo`00Dgoo
00<007ooOol04goo1000>7oo01X006liJaQ_>F/HKcU[66liJaQ_>F/H001[>@00H_QVnFKhI_URn6Ki
I_QVnF;hI_UVn6Ki0P0001YJN5ZHFWMJV5YhFYQJMeZHFWQJV5YgFYP005IGDUMFF59GEUMBEeIHDUL0
059GEUP0058g0P0000Q>5ThGBQI>=dhFCQM:5P002Woo00<007ooOol017oo0P00Dgoo001;Ool40005
Ool00`00Oomoo`0?Ool3000kOol01@00JcU[>F/iJaP00f/i00A[66/iJcT0009[>@0@001VnFKhI_UV
n6KiI_QVnFKhI_UVn6Ki001RfEkI000;FYP01000EUMFEe9G0eIG00ABEeIG001FE`<0000:CQM>5ThG
CQI>5dhFCQM>5ThG000:Ool00`00Oomoo`03Ool01000Oomoo`00DWoo001AOol01000Oomoo`003goo
0P0000=oo`00Ool0>Woo00`006liJaQ_>F/HKcU[66liJaQ_>F/H0003JcT096lj001VnF;hI_UVn6Ki
H_QVnFKhI_T006;iG]URn@00FYQJN5ZHFWMJV5YhFYQJMeZHFWQJV5Yg001BEeIGDUMFF59GEUMBE`80
000=DSL004hgCQI>5dXFCSM>5ThGBQI>=dhF00002goo00<007ooOol00Woo00@007ooOol0059oo`00
DWoo0P003Goo0`00?Woo00D006/iJcU[>F/H00=[>@04JaQ[>F/i0006JcT01`00I_UVn6KiI_QVnFKh
00800006H]UNfF;IG]URf@002eZH00D005IGEUMFEe9G00@0000?DSM>=e8g001>5dhFCQM>5ThGCQI>
5dhFCQM>5P0000]oo`05001oogooOol00002Ool00`00Oomoo`1@Ool005moo`800003Ool007oo03eo
o`0;001_F@00KcU[66liJaQ_>F/HKcU[60020002JcT08FljJcU[>F/iKcX006KiH_QVnFKh001NfF;i
G]URnEkIH_UNf@00FWMJV5YhFYQJMeZHFWQJV5YgFYQJN5ZH001FF00200004dhgDSQ>=`00CSMB>4hg
001:5ThgCQI>5dXFCSM>5ThGBQI>=`0000]oo`05001oogooOol00002Ool00`00Oomoo`1@Ool005ao
o`<0045oo`05001[>F/iKcT00003JcT01F/HJcU[>F/i000026/i00l006KhI_UVn000G]URfEkIH]UN
fF;IG]URfEkI00002eZH0P0001EB=dhgDSM>=e8g001B=dhgDSL004hGCQI>5dhFCQM>5ThGCQI>5dhF
00002goo0P000goo0P00Dgoo001IOol30002Ool00`00Oomoo`0nOol03@00KeU[>FmIJcU_F@00KcU[
66liJaQ_>@00009[>@05KcY[>F/iJcU_>P03JcT05`00I_P005kIH_UNfF;iG]URnEkIH_UNfF;i001J
V5YgFYQJN5ZHFWMJV5YhFYP00`0000EB=dhgDSQ>=e8g0080000@CSMB=dhgDSP004hGBQI>=dhFCQM:
5ThgCQI>5dXF000<Ool00`00Oomoo`1EOol005Moo`8004Eoo`04001[>F/iKcT3JcT00fli001[>@02
JcT00`00JcU[>@0:JcT03P00G]URfEkIH]UNfF;IG]URfEkIH]UNfF;I0006FYP200001E9hDUQBN000
DSL00`00019B=dhg001>=e8gCSL004hFCQM>5ThGCQI>5dhFCQM>5ThG000<Ool00`00Oomoo`1EOol0
05Eoo`80009oo`03001oogoo045oo`0=001_FF/iKeU[>FmIJcU_FF/iKeT006li00000V/i00E_>V/i
JcU[>Flj00=[>@0EKcY[>@00IcX005kIH_UNfF;iG]URnEkIH_UNfF;iG]T005YhFYQJMeZH00800004
DUQFNE9HEWP300005E8gCSMB>4hgDSL0058hCSMB=`00CSM>5ThGBQI>=dhFCQM:5ThgCQH0000=Ool0
0`00Oomoo`1DOol005Eoo`8004Ioo`03001[>Fli00=[>@06KcU[>F/iJcU_>@002f/i0P00015W>VMK
001RfEkIH]UNfF;IG]URfEkIH]UNfF;IG]T005ZH008000=BN00LDUP00000DWP0058gCSMB=dhgDSM>
=e8g001B=dhg001>5ThGCQI>5dhFCQM>5ThGCQI>5dhF000=Ool00`00Oomoo`1COol005Eoo`03001o
o`0004Aoo`0?001[>FmIJcU_FF/iKeU[>FmIJcU_F@00KgX006lj00=[>@0GKcY[>F/iJcU_>P00Ie]W
>VMKIcYWF`00H_UNfF;iG]URnEkIH_UNfF;iG]URn@0200000e9HEWQBF00300006e9HEWUBF5Ih001B
>4hgDSM>=e8hCSMB=`00DSQ>=`00BQI>=dhFCQM:5ThgCQI>5dXFCSL0000=Ool00`00Oomoo`1COol0
04eoo`D0009oo`80009oo`03001oogoo041oo`03001[>Fli00=[>@06KcU[>F/iJcU_>@000fmj00<0
06/iJcT01F/i00@006LjIcYWF`=W>P0:001NfF;IG]URfEkIH]UNfF;IG]T300001E9H00000000DUP0
0e9h01YBF59hDWP004hgDSM>=e8gCSMB=dhgDSL0058g001>5dhFCQM>5ThGCQI>5dhFCQM>5P003Woo
00<007ooOol0DWoo001?Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0nOol04`00JcU_
FF/iKeU[>FmIJcU_FF/iKeT006mjJgY_VV]j001[>Flj00=[>@0AKcX006MKIcYWFfLjIe]W>VMKIcX0
05kIH_UNfF;iG]URn@0200009EJj00000000DUQFNE9HEWQBF5IiDUQFN59HEWT0058gCSMB>4hgDSM>
=e8hCSL004hg001>5ThGBQI>=dhFCQM:5ThgCQI>5`0000eoo`8005Aoo`00Cgoo00<007ooOol00Woo
0P0017oo00<007ooOol0?7oo00<006/iKcT00f/i00I_>F/iJcU[>Fli0003KgX016]jKgY_NP000f/i
0P000VLj00EWFfLjIcYW>VMK00=W>P04001NfF;IG]T50002E[X00`00DWQBF003DWP07E9HDWQBN59h
DUQBN000DSM>=e8gCSMB=dhgDSM>=`00CSL004hFCQM>5ThGCQI>5dhFCQM>5ThG00003Woo00<007oo
Ool0DGoo0017Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0jOol09@00JcU_
FF/iKeU[>FmIJcU_FF/iKeT006mjJgY_VV]jKgY[NVnJJgX006/i001W>VMKIcYWFfLjIe]W>VMKIcYW
FfLjIe/006;i00@0000KE[YJfUJjF]YF^U[J001FN59HEWUBF5IhDUQFNE9HEWQBF000CSMB=dhgDSQ>
=e8gCSMB>4hg00800009CSM>5ThGBQI>=dhFCQM:5Thg008000moo`03001oogoo051oo`00Cgoo00<0
07ooOol00Woo00<007ooOol01Goo0P00>Goo00<006]J00000f/i00I_>F/iJcU[>Fli0003KgX01F]j
KgY_NVmjJgX00Vmj00D006LjIcYW>VMK00=W>P05Ie]W>VLjIcYWF`02IcX20009E[X01000DWQBN59H
0e9h01IBF59hDWQBN59H001>=e8gCSMB=dhgDSM>=e8gCSL004hFCQM>5ThGCQI>5`<00003CQL007oo
00ioo`03001oogoo051oo`00CWoo0P0017oo00<007ooOol01goo00<007ooOol0=Goo00@006]IKeY[
FP80000MKeU[>FmIJcU_F@00KgY[NVnJJgY_NV]jKiY[NVmjJgX006NK001W>VMKIcYWFfLjIe]W>VMK
IcYWF`0300008Elm001JfUJjF]YF^U[JE[YJfUJjF]YF^P00DUQFN59HEWUBF5IhDUQFNE9HEWP0058h
CSMB=dhgDSQ>=e8gCSMB>00200000dXF0000000200001ThgBQM>=dXFCSL000moo`03001oogoo04mo
o`00Dgoo0P002Woo00<007ooOol0<goo00<006]JJeX00f]J0P000V/i00=_>@00KgX00Vmj00I[NVmj
KgY_NV]jKgX20003Ik`01@00IcYW>VLjIe/00VLj100000AK?5/mFc`000YF^P05001BN59hDWQBF003
DWP0359HDWQBN000CSMB=dhgDSM>=e8gCSMB=`@00005BQM>5dhGCQM:5`03CQL00dXG001oo`0?Ool0
0`00Oomoo`1>Ool005=oo`03001oogoo00Yoo`03001oogoo035oo`03001[FFmJ009[FP0JJeU_FV]J
JeX006mI001_NV]jKiY[NVmjJgY_VV]jKgX006^lIi][_6NKJkaWV`00IcYWF`D0000OGceK?5lmFcaO
?E/l001F^U[JE[YJfUJjF]YF^U[JE[YJfP00EWUBF5IhDUQFNE9HEWQBF5IiDUP004hgDSP01@0000i>
>4XG000004hgBQI>=dXGCSM:5ThgBQM>=`0047oo00<007ooOol0CWoo001COol2000<Ool00`00Oomo
o`0_Ool00`00JeY[FP08JeX01@00KgY_NVmjJgX00fmj00A[NVmj001[_0=W_003JkaW_6Nl00<00003
IcX0000000=K?006FceK?5/lFcaK?@002UJj00<0059HDWP00U9h00ABF59hDWQBN0D0009:>007CSQ:
=dXhBSQ>>4Xg00000ThG00E:5dhGCQM>5dXG00=>5`03001oogoo00ioo`03001oogoo04eoo`00Dgoo
00<007ooOol037oo00<007ooOol0;Goo00<006]IKeX00V]J01I[FFmJJeY[FV]IKeX006nk001_VV]j
KgY[NVnJJgY_NP00JkaWVf^lIi][_0<0000MJkaWV`00001O?E/lGceK?5lmFcaO?E/lGceK?5lm001J
fUJjF]YF^U[JE[YJfUJjF]YF^P00DUQFN@0500003DYIBST004XGCSQ:5dhhBQM>>4XGCSQ:5dhh0080
000:BQM>=dXFCSM:5dhgBQI>=dXG000AOol00`00Oomoo`1<Ool0045oo`8000Aoo`8000Aoo`8000Ao
o`03001oogoo00eoo`03001oogoo02]oo`03001[FV]J00Q[FP04001[^f^kJk/20002KgX016]j0000
06^l0fNl0P000VNl00E[_000001G_P0000=K?005FceK?5/lFcaK?@03Fc`00e/m001F^P06E[X50008
BUT01000BSQ>>4Xg0TXh00M>>4XgBSQ:>000BQL00002CQL01dXGCQM>5dhGBQM>5`00015oo`03001o
ogoo04aoo`00@7oo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`0>Ool00`00Oomoo`0Y
Ool00`00JeU_FP02JeX04f]IKeY[FV]JJeU_FP00Kk][^foKJk]_^f^k001[NP00Ii][_6NK00<00003
Ii][_6NK0080000DEkiG_ENnEkd005/lGceK?5lmFcaO?E/lGceK?5lmFc`005JjF]YF^P@00003BY]6
N`00009:F@06BSU>FDYIBUU:>DiI0TYI01L004hhBQM>>4XGCSQ:5dhhBQM>>4XG001:5P00BQM>=dXF
CSM:5dhgBQI>=`00015oo`03001oogoo04]oo`00@7oo00@007ooOol000]oo`05001oogooOol0000A
Ool00`00Oomoo`0WOol00`00JeY[FP08JeX00`00Jk][^`06Jk/5000016NlJkaW_6Nl0P001eNn00D0
05/lFcaK?5/m00=K?003FceK?00000@000M:V`03001:FDYI00Q:F@05001:>4XhCSQ:=`02BSP01Thh
BSM:>000CQL000=>5`06BQM>5dhGCQM:5`004Woo00<007ooOol0BWoo000jOol40002Ool01000Oomo
o`002Goo0P000goo0P004Woo00<007ooOol09Goo00<006]IKeX00V]J00E[FFmJJeY[FV]I00800008
Kk][^foKJk]_^f^kKm][^`H0000BJkaWV`00001G_UNmEkiG_ENnEkeG_UNmEkiG_@00FcaO?E/l1@00
00I2oTLN@_h004IkBY`2BY/01TIkBYa:VdZK001>F@9:F@0MBSU>FDYIBUU:>DiIBUT004XGCSQ:5dhh
BQM>>4XGCSQ:5`00BQM>=`00CSM:5dhgBQI>=dXGCSL0000AOol2001<Ool0041oo`04001oogoo0009
Ool00`00Oomoo`02Ool00`00Oomoo`0BOol00`00Oomoo`0ROol200000fMK00000006JeX00`00Jk][
^`05Jk/30002Go/015oKGo]Oneok10001eNn1`0024Kn00<004ZKBY/01dZK00<004YIBUT01dYI00<0
04hhBSL00TXh00M>>4XgBSQ:>4hhBSL00002CQL01@00CQM>5dhGBQL00dhG00<007ooOol047oo00<0
07ooOol00goo1000@Woo0011Ool2000:Ool30002Ool2000DOol00`00Oomoo`0POol02000IgaWFfMl
Ie]WO000KeX2JeX01f]I001[^fnkJk]_ff^k00@00006GoaKfeolGm]Oo5_K0P0000@oVS]i?iXkN@L0
000D<chgGc<n=elc?P00@_i77T;nA_i2oTLN@_i6oT;nAah004ZKAW]:W09:V`06AW]:W4ZK001:>DiI
0TYI01a:>DiIBUU:FDXiCUT004hhBQM>>4XGCSQ:5dhhBQM>>000CSM:5`00BQI>=dXGCSM:5ThgBQL0
01=oo`03001oogoo009oo`03001oogoo04=oo`00DWoo00<007ooOol057oo00<007ooOol07Goo0P00
00MWNfMKIg]WFfMkIe]WN`0200000f]J001[^`03Jk/20002Jk/01P00Go]OneokGm]On`800003>iTo
V@0000<000046]PJn1[H6_P20003=ch013MO=chg?SLn0P0024Kn00<004ZKBY/01dZK00<004YIBUT0
1dYI00@004XhCSQ:=`9:>006CSQ:=dXhBSP004XG0ThG00<004XGCQL00ThG00=:5dhG00004goo00<0
07ooOol00goo00<007ooOol0@Woo001BOol00`00Oomoo`0EOol2000LOol03000Ie]WO6MKIgaWFfMl
Ie]WO6MKIgaWF`800006Kk/00000001_^f^k0P0000AOo5_KGoaOfaH0000==elc?SMO00177T;nA_i2
oTLN@_i6oT;n00000TZK00Y6NdZLBY]:VdIkBY`004YIBSU>F@9:F@0KBSU>FDYIBUT004hhBQM>>4XG
CSQ:5dhhBQM>>4XG001:5ThgBQL004XFCSM:5dhgBQI>=`0001=oo`03001oogoo00=oo`03001oogoo
045oo`00DWoo00<007ooOol05goo00<007ooOol067oo00/006MKIg]WFfMkIe]WNfMKIg]WFfMk00L0
009[^`03001Ofeok00L00004@alo7d<O00029[h7000010Yj2W/000000QIm1`001TKn00<004ZKBY/0
1TZK00<004YIBUT01dYI00D004XhBSQ>>4Xg009:>006CSQ:=dXh001>5dXG0ThG00<004XGCQL00ThG
0P0057oo00@007ooOol0009oo`03001oogoo041oo`00DGoo0`006Goo00<007ooOol05Goo0P0000YW
FfMlIe]WO6MKIgaWFfMlIe]WO0<00005HoaSff?lHmaSo00800004ClN@clo7T<O?ai3?clN@al002Zo
9YhZ_bJN:[lVWP004S`01P0000LFWA9m5YhFOAJM000ZOP0500000dKn001:W002BY/01TIkBYa:VdZK
AW/0009:F@0HBSU>FDYIBUU:>DiIBUT004XGCSQ:5dhhBQM>>4XGCSQ:5`00BQM>=dXFCSL004hg0`00
00=>F@00Ool04Woo0P000goo0P00@goo001;Ool20004Ool3000JOol00`00Oomoo`0COol02P00Ig]W
FfMkIe]WNfMKIg]WFfMk0`0000ESo6?LHmaSg6?l009Sg0800005@iL00000EeiC?@0200002T<O?am3
7clO@alo7d<O?am37`001RJn0P000Q8m00<F?@0000000P0011Im00H002In9WdVORIm9Wh70004BY/0
0`00BUU:F@07BUT01P00BSM:>4XhCSQ:=`9:>004CSQ:=`00CQL400001TiHBSQ>>4XhCUP001Aoo`03
001oogoo04Eoo`00BWoo00@007ooOol000=oo`D001Uoo`03001oogoo011oo`800007Ggd00000Ie]W
O6MKIg`01@0000USo6?LHoaSff?lHmaSo000@kP00P0000IC?EMNDceGGU<mEeh200001ClN@clo7T<O
?ah0200000TZ_bJN:[l001IM4SdF?A8l5Ud0100000hFOAJM000ZORIM:WhVGBYn9UdZOP00=UdbG3IL
6P0000Y:>4iIBSQ>F@00CUU:>4iIBSP001Aoo`03001oogoo04Eoo`00BWoo00@007ooOol000=oo`03
001oogoo00@001Qoo`03001oogoo00ioo`03001OOEmm00=OO@09001WF`00001WNfMK001Sg6?l00=S
g003HoaSg00000<00009EeiCGUMNDceGGU=NEeiC?EMN00H000=6N`05BY/003YL=U/jG00600001a8m
5SdB?A8m000=o0Wl00@000079WhVOBIn9WdVORIm000023IL00@003hj?SXnF`<n>P03?U/n>P0000U6
>@0=001:>4hhBSQ>F4XhCSP004iHBSQ>>4Xh000057oo00<007ooOol0A7oo001:Ool01000Oomoo`00
0goo00<007ooOol00Woo00@0004G000001Moo`03001oogoo00]oo`800005FeeOOE]MGgeKG@040000
2VMl000006?KHoaSg6?lHm]So6?L1@0000MC?EMNDceGGU<mEeiC?@0200004eJjDYX004IjBY]6NdZK
AWY:VdIk000f>cYL=S/jG3Hk>U`f>cYL00@000074S`000Wl3O`9n`gl2O`00`0002dVGBYn9UdZORIM
000bG3IM<U`fG39L=UdbG000?SY2Fchj@U/n>T9K?SY2Fchj0016>DIIASU6FTHiAUU6>DIJAST004Xh
CUU:>4iIBSP004XhCUU:>4iI00005Goo00<007ooOol0@goo001:Ool01000Oomoo`000goo00<007oo
Ool00goo00<0004G0AL00P005Woo00<007ooOol02Goo00<005mmGgd00Umm0`0015mm10000f?L00IS
o000000006=LGc`2Ge`200000eMNDeh0000200001U:jE[YBVU:j001:V`=6N`0?BY]6NdIkAW/003Hk
>U`fFcYL=S/jG3IK000UnbHL00@000032O`=o0Wl0089o0083O`00000000VORIm9Wh000PfG005000n
>Shj?SXnF`03?SX00ciK0016>@08AST03@00CUQ:>4hhBSQ>F4Xh001:>4iHBSQ>>00001Aoo`8004Ao
o`00=Goo0`0000=oo`00000047oo0P0017oo00<007ooOol017oo0P0000@1=`00000001Eoo`03001o
ogoo00Ioo`800003GgeKG@0000800005FeeOOE]MGgeKG@02000014oLBk]?g4^k1@0000QO>f=LGcaS
G5lkHeaO?6=L0P0001iBVUJjDYYF^U:JE[YBVUJj001:VdIjBY]6NdZKAWY:VdIk000f>cYL=S/jG3Hk
>U`f>`009O/Z72Gk9Q`300001`gl2O/=o0Wl000=fa7l0080000Z9UdZOP00=U`bG3IM<U`fG39L=Ud0
049K?SY2Fchj@U/n>T9K?SY2F`00AUY6>DIIASU6FTHiAUU6>DIJ001>FDXhCUU:>4iIBSP004XhCUU:
>0005Goo00<007ooOol0@Woo000fOol01000Oomoo`005Woo0P001goo1`0057oo00<007ooOol00goo
0P0000AOO@00000000MOO@07001;_4oLCka?g4^lCm`00`000UmL00ISG5llGeaOG6=LGc`200001UkI
001B^U:jE[YBVP9B^P05E[YBVU:j001:V`03AW/03TZKAW]6NdIk000f>cYL=U/jG3Hk>U`fF`009O/3
9Q`012Gk000000000`Wl00@000gL4O`=o0<000PfG003000nFchj008n>P05?U/n>Shj?SX00009AST0
3000BSQ>F4XhCSQ:>4iH001>>4XhCUP001Ioo`03001oogoo045oo`00=Woo00@007ooOol001Ioo`03
001oogoo00Moo`D000040EP00000000BOol900001emmFeeOOE]MGgeKGEmm00800004Bk]?g4^kCm`4
0000<EllHeaO>f=LGcaSG5lkHeaO?000F[UNfUZi001BVUJjDYYF^U:JE[YBVUJjDYYF^P00BY]6NTZK
AW]:VdIjBY/003YL=S/jG3Hk>U`f>cYL000V72Gk:Q`UnbHL9O/001GK008000073O`9o0003M/Ao0gL
4O`00`0002HfG39L=UdbG3IL<U`003hj@U/n>T9K?SY2Fchj@U/n>P00ASU6FTHiAUU6>DIJASU6FDHi
001:>4iIBSQ>FDXhCUT004iIBSQ>F@005Goo00<007ooOol0@Goo000fOol3000GOol2000:Ool00`00
0GX00008000<Ool300001D]NBel00000Beh00d]O00<005mmGgd00emm00D004oLBka?g4nl0080009S
W@06001W>P00001SG5ll0UmL00YSG000001J^EkIF[UNfEZi001BVP9B^P09E[YBVU:jD[YF^U:J0016
NdZK00=6N`d000059O/V72HL9Q`000025M/02QGL000000004O`=g17l3O`Ao0gL1@000cIL00<003hj
?U/00chj00@nFchj?SX000U6>@0<001>>4XhCUQ:>4hhBSQ>F000CSQ:>0005Woo00<007ooOol0@7oo
000fOol00`00Oomoo`0GOol00`00Oomoo`0:Ool00`000GX1N@0500000`HK2Q`0000;00000d/nBel0
000200001d]OBci;Gd/nBem;?T]O00800004Fed00000Cm`4000026>LHkeSW000HcYW>f<jIc/20000
55lk000005kJF[UNfUZiG]YJ^EkJF[T005:JE[YBVUJjDYYF^U:JE[X6000034XHBSQ66000?QQ26Cgh
@QTn648I?OQ26@@000079O/V70005M`EfaGL5M/00`0000P=fa7l3M`Ao0gK000Io1hL1@0001m2Fchj
@U/n>T9K?SY2Fchj@U/004IIASU6FTHiAUU6>DIJASU6F@00CUU:>4iIBSQ>FDXhCUT004iIBSP0000D
Ool30011Ool003Eoo`8001Uoo`8000aoo`<000030GT0000000<000032Q`670HL00800006:]hZgb[N
:]lZgR[O0`000d]O00E;GT]OBem;Gd]N009;G`L0009SW@04HiaSWF>M0003IcX04VLkIcYW>VLj001J
^EkIF[UNfEZiG]UJ^EkIF[UNfEZi001BVP9B^P06E[YBVP00001BF00024Xh00@0048I@QTn6@=26@05
?QT003Gj=OXen@0400025M/00aGL5M/Ef`030000117l3O`Ao0000ahL00<Mo1hL7Q`0100000LnFchj
?SXn>SiK?SX00009AST02000BSQ>>4XhCUQ:>4hhBSP4000AOol300000e]nEed00011Ool003eoo`80
00Aoo`8000Aoo`8000Eoo`03001oogoo00aoo`/000052S`66`00:]h^o`0300000bko:]h^g`020000
14/nBem;?T]O100000X[>P00000006>LHkeSW6>mHiaS_@80000GHcYW>f<jIc]S>VLkHcX006;H001J
^EkJF[UNfUZiG]YJ^EkJF[UNfP00E[YBVP0300006dhgDUQ>=e9H001:>DXHBSQ664XiBQQ:>000@QTn
648I?OQ26ChH@QTmn000=OTf6SGi=QXen@0300001QGK5M`EfaGL000=f`<0000;4O`001hM6O`N71Wl
7QdIo1hL000^G@0500003d9K?SX004HiAUU6>DIJASU6FDHiAUY6>@00BSQ>F@0600000dZKC[`0000=
Ool4000015MMFgiGGE]n0P00@7oo000lOol01000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo
00eoo`8000037SdNG@0000X00005:]lZgR[O:]hZg`0>000026>LHieSWF>MHiaSW@00Ic/3IcX04fLk
IcYW>VLj001Rf6;I001NfEZiG]UJ^EkIF[UNfEZiG]UJ^EkI00800005CUQBF59HDUQ>F002DUP00`00
BSQ:>006BSP01@00@QU26D8I?QT00d8I00D003Gj=OXenSGi00<enP@0008Ef`04000=^`Vk3K/30003
7Q`011gl7Q`N70001Rhl3`001TZK00<004ZK00002Woo0`000`@000L005]nEeeGGUMMFgh00010Ool0
03aoo`04001oogoo000;Ool01000Oomoogoo0P004Goo00H001hm7UhN?AiM7SdC00001eMmFiiKOE]n
001WFf=K00<0000IHiaS_@00Ic]S>VLkHcYW>f<jIc]S>P00H]QRnEkHH_T005kJF[UNfUZiG]YJ^EkJ
F[T00`0002E>=e9HCSMBF4hgDUQ>=e9HCSL004HHBSU:64XhAQQ:>DXH000mn48I?QQ26Cgh@QTn648I
000f6SGi=QXenCHJ=OT002GJ:O/UfP04000010gK2K/=g0Vk0`0002@Io1hL6O`N7AWl000Z?2iM;S`^
GBXl;Ud^?2iM000nO3iL?W`jFcil?U`nO3YK001:VdjKBY]>_4ZKCY]:VdjlBY/004ZK0007Ool20004
1002000015]nEeeKOUMM0`00@7oo000lOol01000Oomoo`002Goo0P0017oo00<007ooOol04Goo00@0
01hm7UdNG@X0008k?`03>elk?c/o00800007FgeKOU]mFgiKOE]n00001VMK0P0000EW>fLjIcYW>VLk
009W>P80000>H]QRfF;IH]URf6;I001NfEZiG]UJ^EkIF[T0009FN005EWL0059HDUQ>F003DUP00diH
DUP00008BSP00`00?QU26@02@QT01ChI@QU26@00=OT00cGj00@enCGj=OX000DYn`<000042K/=^`Vk
3K/3000011hL7O`N700022hl00<003il?W`01cil00<004ZKBY/01TZK00@004ZKBY/000Aoo`800084
00D00003FgiGGEMN0080009oo`03001oogoo03ioo`00?7oo00@007ooOol000Uoo`03001oogoo00=o
o`8001=oo`D00005@]e6oTKMA]i2g@0300000cLn>elg?P0200004E^NFgeKOUMmFiiKOE]n001WFf=K
Ie]S>fMKHe]WF`00JcX00P00019S>VLkHcYW>`00H_URf6;iG]QRnF;HH_UNf6;i001NfUZiG]X20000
;UIGFWQFMeYh001BF4hgDUQ>=e9HCSMBF4hg001:64XhAQQ:>DXHBSQ664Xi00126Cgh@QTn648I?OQ2
6ChH000enCHJ=OTf6SGi=QX002Wk9MXYnbGJ:O/UfRWk0`0000D=g0Vk3M/000gl0080000Q6O`N7@00
;UdZ?2iM;S`^GBXl;Ud^?000>U/nO3iL?W`jFcil?U`nO000C[a:VdjKBY]>_4ZKCY]:Vdjl001>V`00
009oo`L000<D0004001GG@000005Ool00`00Oomoo`0mOol003eoo`8000Yoo`<000=oo`03001oogoo
00moo`<00003Ool004KM0096g@05A]i6gDKMA]e6gP03A]d300001e]mFgiKOE]nFgeKOU]m008000MW
F`03001W6FLI009W6@800004IcX006;IH]P3H]T01f;HH]URfF;IH]P005Zi008000=FN005EWMFN5Ih
EWP00003DUP01TiHDUQBF59HCUP000Q:>00300126ChI00=26@05?QU26@00=OXen@03=OX00cGi=OX0
0006:O/00`006O`Io00200001@Vk0009f`WL2M/00`0022hl00<003il?W`01cil00<004ZKBY/01dZK
00<004ZK000010001Q@00`001goo00<007ooOol0?Goo001?Ool00`00Oomoo`0<Ool30005Ool02P00
@]e6oTKMA]i2gDKnA]e6gT;M0P0004QK7000000005]nEgeKWU]m001S>fMKHe]WFf<kIe]SFfMK001[
>VLIJaYW6F/jIaU[6P00H_URf6;iG]QRnF;HH_UNf6;iH]QRnEkH001FMeYhEUMJN5IgFWQFEeYhEWL0
04hgDUQ>=e9HCSMBF4hgDUP004XiBQQ:>4HHBSU:64XhAQP003hH@QTmn48I?QP800003SHJ=OT002GJ
:O/UfRWk9MXYnbGJ000IfaWl5M/3000010WK3O`9f`WL100001/Z?2iM;S`^GBXl;Ud003il>U/nO3iL
?W`jFcil?U`004ZKC[a:VdjKBY]>_4ZKCY]:V`00BY/00`000a@000<H01@050000`002Goo00<007oo
Ool0?Goo001?Ool00`00Oomoo`09Ool30009Ool01@00A]e6gDKMA]h00dKM00H005[kF_]Jne/LF_/3
00000e]m001WF`06Ie/20007IaT00`00I_P00003H]T01F;HH]URfF;IH]P00V;I0P000eIh00UFMeIh
EWQFN5IgEWP0059HCUP00e9H00E>F59HDUQBF00000A:>0T00004AOM65dGg0002@QP00d7h00000005
0005:O/00`006O`Io0026O`300001PWL2M/9g0WK000B?@D00003;S`003il00PnO003001:VdZK00M:
V`@000<D00<00003400007oo00Uoo`03001oogoo03eoo`00CWoo0P0027oo0`003Goo00D004;MA_i6
gDKN00800008F_]K75[kFaaJne/LF_]K7080000LHc]WFf=KIe]S>fMKHe/006LIJcYW6F/JIaU[>VLI
JaX006KiI_QVn@00H_URf6;iG]QRnF;HH_T2000055ZGG[P005YhEWMJN5IGFWQFMeYhEUMJN000DUQ>
=e9HCSMBF4hgDUP600005dWfCQM:5TXG001:64GgAQQ5mdXHAOM664Gg0011n48I?OQ26D7h@QTmn000
>QX0100000PYn`006O`IfaWl5M/Io1WK1@0000L9f`00000F?A8L5SdB?00800001cil>U/nO000CY]:
Vdjl00H00003?al003lo00@000<@0003001oogoo00Uoo`03001oogoo03eoo`00CWoo00<007ooOol0
1Goo0P004Goo00D004KM000005/L00=Jn`05FaaJne[kF_]K700200000f;i00000004Ie/00`00IaUW
6@06IaT00`00I_QVn002I_P00`00H]QRf@02H]T01F;HH]T005jHGYL00UjH00<005IgEWP00UIh00IF
MeIhEWQFN5Ig0002DUP00diHDUQBF00200000dhg001:5`08BQL02@00AQM5mdHGAOM65dGgAQL00003
@QP01D7h@QQ2648H00000SXJ00<n>SXJ>QX01`000QWl0P0000<9o00000000`0000XF?A8m5SdB?AHm
4Sd002Jn:[hV_PP000=3?`08?cm3?d<o@clo?`00@cl000D@0003001oogoo00Uoo`03001oogoo03eo
o`00CWoo0P000goo0`0057oo014005[kFaaJne/LF_]K75[kFaaJne/L001W6V;iIaYRnFLJ0080000Y
He/006LIJcYW6F/JIaU[>VLIJaX006KiI_QVnF;HI_UVn000G]QRnF;HH_T005jhFYMN^5ZGG[QJU`00
EUMJN5IgFWQFEeYhEWMJN5IG001>=`030000:ThFDSM>5U8g001:5dWfCQM:5TXGBOI>5dXF0015mdXH
AOM664GgBQQ5m`00?OQ26D7h@QTmn48I@OQ26@00?SXj6Shj>QTn>SXJ?SX0039M<U`bG@L000032O`5
n`0000<0000=5SdB?1Hm4Q`002Jn:[lVWRZo9[hZ_bJN:[l00P0000/o7d<o?cm3?clO@clo?d<o0013
?`00008@00<000aoo`03001oogoo03eoo`00CWoo00<007oo00000P0067oo00D005[kF_]Jne/L00=J
n`800009HaYRnFLJH_US6V;iIaYRn@0000UW6@03001Vn6Kh00EVn006001Rf000001NV5jG0ejH00EN
UejH001FN5Ig00=FN004EWMFN5IhEWP2000024hGCSM>5ThgCQM>=dhF0008BQL02`00AQM5mdHGAOM6
5dGgAQM5m`00@OP00d8H00A1n48H@QP000<j6P05?SXj6SXJ>QX00003<U`01C9M<U`bG39L<Ud03000
00XB?@009[hZ_RJn:[hV_RZn9[hZ_P800006?cm3?d<o@clo?d<o1P0047oo00<007ooOol0?7oo0016
Ool50003Ool2000LOol2000045/LF_]K75[k001RnFLJH_UW6V;iIaYRnFLJH_T006Kh0P00029[6VLI
JcYW6F/JIaT006KhI_URf6KiI_QVnF;HI_UVn000FYMN^5ZGG[QJUejhFYMN^5ZGG[P005YhEUMJN5Ig
FWQFE`<0000dCQIB=dhFDSM>5U8gCQIB=dhF001:5TXGBOI>5dXFBQM9mThG001664GgBQQ5mdHHAOM:
6000@QTmn48I@OQ26Cgh@QU1n000>QTn>SXJ?SXj6Chj>QX002hl<UdbG39M;S`bGC9L<Ud2000011Ym
7YhJOAjN600000=W>V]K00004Woo00<007ooOol0?7oo0018Ool00`00Oomoo`04Ool00`00Oomoo`0L
Ool04`00F_/00000H_US6V;iIaYRnF<JH_UW6V;i001Vn6LII_QW6@0000AW6@03001Vn6Kh00MVn080
0003GYQNUejH009NV006GYMNV5jHGYQNU`000UIh015FMeIh0000058gDUMB=`00CQI>=dhGCSM>5Thg
CQM>=`0000Q:5`0<0015mdHGAOM65dGgAQM5mdHG0012647h0d8H00A1n48H000n>P<j6P05?SXj6SXJ
>QX00003<U`0139M<U`bG39L1`000Slo00<o7clo?cl00P000U]m00UKOP00000006>mHk`006MJJe/0
0fMJ00I[FfMJIeX007oo000AOol00`00Oomoo`0lOol004Qoo`03001oogoo00Eoo`8001eoo`0B001W
6V;iIaYRnFLJH_UW6V;iIaYRn@00I_Q[6FKhJaUVn6/I0P0001]W6@00I_QVnF;HI_UVn6KiH]QVnFKh
001R^6KH001N^5ZGG[QJUejhFYMN^5ZGG[QJU`00EWL00P0003EFEe8fEUMB=UIG001B=dhFDSM>5U8g
CQIB=dhF0019mThGBQI:5dWfCQM:5TXG001:64GgAQQ5mdXHAOM664Gg0011n48I?OQ26D7h@QTmn48I
000n>SXI?SXj6Shj>QTn>P00<Ud^?39M00@00003AYa:_4JK00800005?clo7d<o?alo?`02000025]M
FgiGGE]nFed006=KIg/200002FLjJe]W>V]KIcY[FfLjJe/00002Ool00`00Oomoo`0?Ool00`00Oomo
o`0lOol004Qoo`03001oogoo00Moo`03001oogoo01]oo`0D001S6V;iIaYRnF<JH_UW6V;i001Vn6LI
I_QW6FKhIaUVn6LII_P000UVn005001Rf6;HH]P00002GYP01EjGGYQNV5jHGYL00ejH0P00019B=eIG
DSMBEe8gEUMB=e9G001>=dhFCSM>5dhgCQI>=dhG0008BQL02@00AQM5mdHGAOM65dGgAQL00003@QP0
247h@QQ2648H@OP003XJ?SX3>QX60003B[`01DJLB[a:_4ZlAY`00P0000Ho?clO000005]nFed2Fgd0
0e]n00000003Ie/00`00JcT00003IeX016]KIeX0000017oo00<007ooOol03Woo00<007ooOol0?7oo
0018Ool00`00Oomoo`08Ool00`00Oomoo`0KOol200009f;iIaYRnFLJH_T006KhJaUVn6/II_Q[6FKh
JaUVn000I_P006;HI_UVn6KiH]QVnFKh001R^6KHH[QRf6:h001JUejhFYMN^5ZGG[QJU`030000:E8f
EUMB=UIGDSIFEe8fEUMB=P00CQIB=dhFDSM>5U8gCQIB=`00BQM9mThGBQI:5dWfCQM:5P00AOM:64Gg
AQQ5mdXHAOM66000@QU1n48I?OP02@000dYI00e>FP00B[a6VdZlAYa:_4JKB[a6W4ZlAY]:_0020000
55MMFgiKGE]nEeeKOP00Ie]SFfMkIe/006LIJcYW>@00IcY[FfLj0007Ool00`00Oomoo`0=Ool00`00
Oomoo`0lOol004Moo`8000]oo`03001oogoo01aoo`0C001RnFLJH_T006KhIaUVn6LII_QW6FKhIaUV
n000I_QZn6Kh00001FKh00<006;HH]P016;H00D005jHGYQNV5jG009NV00G001FMeYgEWL0058gDUMB
=eIGDSMBEe8gEUL004hgCQM>=dhFCSM>5dhgCQH00008BQL02000AQM5mdHGAOM65dGgAQL600001DXG
BSQ:=dXh00002DYI00<004ZlAY`00dZl00=6W4ZlB[`00P0000AJf`00001KG@9KO@03Fgh006MK00=W
F`03001[>F/j00=[>@03001WFP0000Qoo`03001oogoo00eoo`03001oogoo03aoo`00EGoo0P007Goo
02<006;i001Vn6/II_Q[6FKhJaUVn6/II_P006KhJaUVn6/II_P006;HI_UVn000H[QVf6:hH]QR^6KH
H[QRf000G[QJUejh0080000SEWMJN5IGFWP005IGDSIFEe8fEUMB=UIGDSIFE`00DSM>5U8gCQIB=dhF
DSM>5P00BQI:5dWfCQM:5TXGBOI>5`00AQQ5m`0400003DhG001>>4XGCSQ:5dhhBQM>>4XGCSP004iJ
00=:F@0;CUY:FDYIBUU>FP00B[a6VdZlAYa:_002000015KJF_]FfU[k0P00011GG@00001WFf=KIg]W
F`00IaU[>VLiJcYW6F/jIcT000Yoo`03001oogoo00aoo`03001oogoo03aoo`00Egoo00<007ooOol0
6goo01D006KhIaUVn6LII_QW6FKhIaUVn000I_QZn6KhJaQVn6[hI_P006Kh00002F;H01h005jG0000
05YhEWMJMeIgFWQFMeYg001FEe8gDUMB=eIGDSMBEe8g001>5ThgCQM>=dhFCSM>5dhg0007BQL40000
44XFBQM:5dhGBQI:5`00BSQ:5dXhBSM:>4XGBSQ:=`002TYI00<004ZlAY`00P0000IJne[JF]]Jfe[k
F]X2F]/00`00Ie]WF`04Ie/00`00JcY[>@02JcT00f/jJcT0000<Ool00`00Oomoo`0<Ool00`00Oomo
o`0kOol005Qoo`03001oogoo01]oo`0n001Vn6/II_Q[6FKhJaUVn000I_Q[6FKhJaUVn6/II_Q[6FKh
001R^6KHH[QRf6:hI]QR^6;HH[QVf6:h001FEeYhEWMJN5IGFWQFMeYhEUL0058fEUMB=UIGDSIFEe8f
EUMB=P00CQIB=dhFDSM>5U8gCQIB=`00CQM:5P@0000GCQL004hGBQI>5dWfCQM:5ThGBOH004XGCSQ:
5dhhBQM>>4XGCSQ:5`00BUU>FP03BUT014iJBUU:FDYI0`0000iFfU[kE]YJneKJF_]FfU[kE]X006;i
001SFfMk0VMK00P006/jIcU[>VLIJcYW>@003Woo00<007ooOol02goo00<007ooOol0>goo001IOol0
0`00Oomoo`0KOol04`00I_QW6FKhIaUVn000I_QZn6KhJaQVn6[hI_Q[66Kh001Vn00000URf080000K
FWQFMeYgEWMJN5IgFWMFMeYhEWL0058gEUMB=e9GDSMFEe8gDUL004hgCQI>=dhGCSM>5Thg00@0009>
5P05BQI>5ThFCQH00002BQL044hGBQI:5dXGCQM:5P00BSM:>4XGBSQ:=dXhBQM:>0001dYI0P0000EF
N5JI001Jne[J009Jf`08F_]JfU[KF]/006;iH_X000=WF`03001[>V/i009[>@03JcY[>@0000moo`03
001oogoo00]oo`03001oogoo03]oo`00FWoo0P0077oo01T006KhJaUVn000I_Q[6FKhJaUVn6/II_Q[
6FKh001Vn6/I001Rf6:hI]QR^6;HH[QVf00200006EZHG[T005YhEUMJN5IgFWQFEeYhEWMJN000EUMB
=UIGDSIFEe8fEUMB=UIG001B=dhF00@0000NCQL004hGBOI>5dWfCQM9mThGBOH004WfCQM:5ThGBOI>
5dXFCQL004hhBQM>>4XGCSQ:5dhhBQM>>0000TYI01m>FTYI000005JIEWQFVEIh001FfU[kE]YJneKJ
F_]FfP00H_UW6V;iIaX006MK001[>VLiJcYW6F/jIcT0000AOol00`00Oomoo`0:Ool00`00Oomoo`0k
Ool005aoo`03001oogoo01Yoo`0B001Vn000I_QZn6KhJaQVn6[hI_Q[66Kh001Vn6LII_QW6@001F;H
00<005jhG[P00Ujh01<005IgFWQFMeYgEWMJN5IgFWMFMeYh001BEe8gEUMB=e9GDSMFE`040003CQH0
1ThGCQI>5P00CQI:5P=>5P05BQI>5P00CQM:5P02BQL03dhGBQI:5dXGCQL004XhBSM:>4XGBSQ:=dXh
BQL00002BUT20002EYT02UIhEYUFVEJIEWP005[KF_]JfU[K0P0000QRnF;jH_US6V;iH_X006/j0f/i
00A[>V/iJcT0019oo`03001oogoo00Uoo`03001oogoo03]oo`00GGoo00<007ooOol06Woo00T006Kh
JaUVn6/II_Q[6FKhJaT00P00025Vn6/II_Q[6FKhJaT006;HH[QVf000G[UJV5jiG[QN^EZH001FMeYh
EUMJN5IgFWQFEeYhEWL0058fEUMB=UIGDSH00P0002IB=`00CQM>5ThGCQI>5dhFCQM>5P00BOI>5dWf
CQM9mThGBOI>5`00CQM9mThGBQI>5dWfCQM:5P00BQM>>4XGCSQ:5dhhBQM>>4XG0P0001iFVEIhEYUF
N5JIEWQFVEIhEYUFN000E]YJn`00IaYRnFLJH_UW6V;iIaX006/i001[>VLIJcYW>F/j000COol00`00
Oomoo`09Ool00`00Oomoo`0kOol005ioo`03001oogoo01Yoo`0B001Vn6/HI_QZn6KhJaP006LII_QW
6FKhIaUVn6LII_P006;H0P001ejh00d005YgEWMJN5IgFWMFMeYhEWMJMeIg001B=`0300001DhfDSM>
=e8g00000ThF00I>5dhFCQI>5ThG0003CQH02DXFCQI>5ThFBQH004XGCQM:5P02BQL02dhGBQI:5dXG
001:5dXhBSM:>4XGBSP00`000eJI00EFN5JIEYUFVEIh00=FV@0@001Jf`00HaYRnF;jH_US6V;iH_X0
06/IIaU[6@00JcX2JcT00`00Oomoo`0COol00`00Oomoo`08Ool00`00Oomoo`0kOol005moo`8001]o
o`80000SJaUVn6/I001[6FKhJaUVn6/II_Q[6FKhJaUVn000G[QN^EZHG[UN^5jiFYQN^EjhG[T005Yh
EWMJN5IGFWQFMeYhEUMJN00200009dhFDSM>5U8gCQIB=dhF001>5ThGCQI>5dhFCQM>5ThG001>5dWf
CQM9mThGBOI>5`00CQM:5ThGBOI>5dXFCQM9mThG001>>4XGCSQ:5`02000085IHDUMFF000EYUFN5JI
EWQFVEIhEYUFN5JIEWQFV@00IaYRnFLJH_UW6V;iIaX006/iIaQ[6FLHJcT006/j000GOol00`00Oomo
o`08Ool00`00Oomoo`0jOol0065oo`03001oogoo01Yoo`0@001[6000IaUVn6LII_QW6FKhIaUVn6LI
I_P006;i0009G[P02000EWMJMeIgFWQFMeYgEWL300002ThgDSM>=U8gCSMB=dhfDSL004hG0dhF00I>
5dhFCQI>5P00BQH3CQH01DXFCQI>5P00BQH00TXG00U>5dXFBQM:5dhGBQI:5`00BSP00P0000=BEe9H
DUL00U9G00<005IhEYT00UJI015FN5JIEYUFVEIhEYT005kI001RnV;iHaYRnF;j001[6FLI00=[6@03
IaU[6@0001Uoo`03001oogoo00Moo`03001oogoo03Yoo`00HWoo00<007ooOol06Woo01h006/II_Q[
6FKhJaUVn6/II_Q[6FKh001RnFLJ001N^EjhG[UJV5jiG[QN^EZHG[UN^000EUMJN5IgFWP200009U9G
DUQBE`00CQIB=dhFDSM>5U8gCQH004hFCQM>5ThGCQI>5dhFCQL004hGBOI>5dWfCQM9mThGBOH004Wf
CQM:5ThGBOI>5dXFCQL3000045IHDUMFF59GEUQBEeIHDUL005IhEYUFN5JIEWQFVEIh0P00011RfEjh
001RnFLJH_UW6P00JcUW66/IIaQ[>FLHJaT001Yoo`03001oogoo00Moo`03001oogoo03Yoo`00Hgoo
00<007ooOol06Woo00l006LII_QW6FKhIaUVn6LII_P006;iHaYRnFLJ00002Ejh00<005YhEWL00P00
015BF59GDUQBEe9H001B=dhgDSM>=U8gCSMB=dhf001>5ThG00=>5P03CQM>5P00009>5P09BQI>5ThF
CQI:5ThF001>5dXF009:5`06CQM:5P00001B=`000U9G00EBF59GDUMBEe9H009BE`03001FVEIh00=F
V@04EWP005jhG]T3G[P01P00H_URnP00JaUW6@=[6@03IaU[6@0001aoo`03001oogoo00Ioo`03001o
ogoo03Yoo`00I7oo00<007ooOol06Woo0P0001EVn6/II_Q[6FKh001RnFLJH_UW6V;iIaX005jiG[QN
^EZHG[UN^5jiFYP00`0002IBEeIHDUMBF59GEUQBE`00CQIB=dhFDSM>5U8gCQIB=`00CQM>5ThGCQI>
5dhFCQM>5P00BOI>5dWfCQM9mThGBOH004XFCQM9mThG0P0002E>=U8gCSIB=`00EUQBEeIHDUMFF59G
EUQBEeIH001FVEIhEYUFN000G[QRfEjhH]UN^6;I001W6P00JcUW66/IIaQ[>FLHJaT0000NOol00`00
Oomoo`05Ool00`00Oomoo`0jOol006Eoo`8001aoo`0>001Vn6LII_P006;iHaYRnFLJH_US6V;iIaX0
00EN^080000DEYT0059GDUQBEe9HDUMBF59GDUQBE`00CSIB=dhgDSM>=U8gCSL000=>5P06CQM>5ThF
CQI>5`000dhF00M:5ThFCQI>5TXF001:5`020006DSL01@00DUMBEe9GDUP00e9G00=BF59G00000UJI
0P0000=N^5kIG[P00Ujh00INfEjhG[P006/IIaT3JaT00fLIJaT0000POol00`00Oomoo`04Ool00`00
Oomoo`0jOol006Moo`03001oogoo01Yoo`0?001Vn000H_UW6V;iIaYRnFLJH_UW6V;i001JV5ji00<0
00AFV@0R001BEe9HDUMFF59GDUQBEeIH001B=dhFDSM>5U8gCQIB=dhF001>5ThGCQI>5dhFCQM>5P00
BOI>5dWfCQM9mThGBOH300004dhfDSM>=U8gCSIB=dhfDSL005IHDUMFF59GEUQBEeIHDUMFF59G0080
000CH]UN^6;IG[QRfEjhH]UN^6;I001[6@00JaUW66/iIaQ[6FLH000087oo00<007ooOol017oo00<0
07ooOol0>Woo001XOol00`00Oomoo`0JOol03000H_US6V;iIaYRnF<JH_UW6V;iHaYRn@8000MFV@0D
001BF59GDUQBEe9HDUMBF59G001>=e8gCSIB=dhgDSM>=U8g001>5`=>5P07CQM>5ThFCQH004XFCQH0
100000=>5P00DSL02E8g00<0059HDUL00U9G00IBF59GDUMBEe9H0002G[P01EkIG[QN^5jhG]T00Ujh
00L006KiI_QVn@00JaUW6@02JaT00`00Oomoo`0POol00`00Oomoo`04Ool00`00Oomoo`0iOol006Uo
o`03001oogoo01Yoo`09001RnFLJH_UW6V;iIaYRnFLJ00800003F_/005JI00MFV@0I001FF59GDUQB
EeIHDUMBF59G001>5U8gCQIB=dhFDSM>5P00CQI>5dhFCQM>5ThGCQH0100002eB=dhFDSM>5U8gCQH0
04hfDSM>=U8gCSIB=dhfDSM>=P00DUMFF59GEUQBEeIHDUMFF000GYP006;IG[QRfEjhH]UN^6;I001[
6FKhIaUVn000IaQ[6FLH000097oo00<007ooOol00goo00<007ooOol0>Goo001ZOol2000KOol01P00
H_US6V;iIaYRn@800004FaaJne[k0008EYT04P00DUMBF59GDUQBEe9HDUMBF000DSM>=e8gCSIB=dhg
DSL0009>5P03CQM>5ThF0080000;CQH004hFDSM>5ThgCQIB=dhFCSL0000:DSL00`00DUMBF003DUL2
0002FYP01@00G[QN^5jhG]T00Ujh00X006KiI_QVnFKhI_UVn000JaT002Eoo`03001oogoo00=oo`03
001oogoo03Uoo`00K7oo00<007ooOol06Goo00<006;iIaX00P0000MJne/LF_]K75[kFa`00007EYT0
5000DUQBEeIHDUMBF59GEUQBE`00CQIB=dhFDSM>5U8gCQIB=`00CQL30000<DhgCQI>=dhF001>5U8g
CQIB=dhFDSM>5U8g001B=dhfDSM>=U8gCSIB=dhfDSL005IHDUMFF59G001JUejHFWMNV5ZG001N^6;I
G[QRfEjh001Vn6LII_Q[6FKhIaUVn00002Moo`03001oogoo009oo`03001oogoo03Uoo`00KGoo00<0
07ooOol06Goo0P000U[k00MK75[kF_]Jne/LF_/00008EYT03P00DUQBEe9HDUMBF59GDUQBE`00CSIB
=dhgDSL50002CQL03dhgCQI>5dhGCSL004hgCQIB=dhFCSM>5U8gCQH00009DSL01@00DUMBEe9G0000
1UZH00<005kIG[P00Ujh00T006KhI_UVn6KiI_QVnFKh0000:Goo00D007ooOomoo`0003]oo`00KWoo
00<007ooOol06Goo00/005[kFaaJne/LF_]K75[kFaaJn`0000MFV@08001BEe9HDUMFF59GDUQBE`H0
000PCSQ:5dhh001>=dhFCSM>5ThgCQI>=dhFCSL0058gCQIB=dhFDSM>5U8gCQH004hfDSM>=U8gCSIB
=dhfDSM>=P<0000DFYMNV5YgGYQJUejHFWMNV000H]UN^000I_QW6FKhJaUVn6LII_P002]oo`04001o
ogoo000kOol006moo`8001Yoo`80009Jn`07FaaJne[kF_]K75[k00001eJI00<0059GDUP0100000E:
>000CSM>=dhG00=>=`05CQM>=`00CSM>5P02CQL03ThgCQI>5dhG001>5ThgCQIB=dhFCSM>5U8g0009
DSL00`00FYQJV008FYP02`00G[P006KhI_UVn6KiI_QVnFKh0000;7oo00@007ooOol003]oo`00LGoo
00<007ooOol06Goo00T005/LF_]K75[kFaaJne/L000015JI1P0002Q>FDXhCUU:>4iIBSP004XGCSQ:
5dhhBQM>>4XG001>5ThgCQI>=dhFCSM>5Thg001B=dhFDSM>5U8gCQIB=dhFDSL0058gCSIB=dhfDSM>
=P<0000DFYMNV5YgGYQJUejHFWMNV5ZGGYQJM`00I_QW6FKhJaUVn6LII_P002ioo`03001oo`0003]o
o`00LWoo00<007ooOol06Goo300014Yj00T004hhBSQ>FDXhCSQ:>4iI00000dhg00E>5dhgCSM>=`00
009>5`0ACSM>5ThGCQM>=dhFCQL0058gCQI>=dhFDSM>5ThgCQH00004DSL2000015IgEWQFM`002EZH
00X006;H001Vn6KiI_QVnFKhI_T002moo`03001oo`0003Yoo`00Lgoo00<007ooOol06Goo03D004Kn
A]e6gT;MA_i6gDKN001:VdYjBW]:NTZKBWX004XhCUU:>4iIBSQ>FDXhCUT004hhBQM>>4XGCSQ:5dhh
001>=dhFCSM>5ThgCQI>=dhF001>5U8gCQIB=dhFDSM>5U8gCQH004hf0080000HFWQFEeYhEUMJN000
GYQJUejHFWMNV5ZGGYQJM`00H]QVnF;H001Vn6LII_Q[6@00<Goo0P00>Woo001dOol2000JOol20000
0dKMA]i6g@02A]d00`00BWY:NP05BWX02P00BSQ>>4XhCUU:>4hhBSP004hG0dhg00E>5dhgCSL004hF
009>5`0?CSM>5ThGCQM>=`00CSM>5U8gCQI>=dhFDSM>5Thg00800009EWMFN5IgEWQFMeIhEWMFN000
00IJV00:001Rf6;iH_UVn@00I_UVn6Ki000bOol2000jOol007Ioo`03001oogoo01Uoo`0^0016gDKN
@]e6oTKM001:NTZKBWY:NdYjBY/004iIBSQ>FDXhCUU:>4iI001>>4XGCSQ:5dhhBQM>>000CSM>5Thg
CQI>=dhFCSM>5Thg001B=dhFDSM>5U8gCQH300003UIGFWQFEeYhEUMJN5IGFWQFE`00FWMNV5ZGGYP2
00002F;HI_URf6KiH]QVn@00JaT0000cOol2000jOol007Moo`03001oogoo01Uoo`800005A]i6gDKM
A]d00006BWX02`00CUU:>4hhBSQ>FDXhCSP004hgCQL00dhg00E>5dhg001>=dhF009>5`09CSM>5ThG
CQL004hFCSM>5U8g0080000>DUMBF59G001FMeIhEWMFN5IgEWQFMeIhEWL0009JV003001VnF;H009R
n@06I_URf6;iH_UVn@00<7oo1000?7oo001hOol00`00Oomoo`0IOol600008TYkBWY:VdYjBW]:NP00
BSQ>FDXhCUU:>4iIBSP004XGCSQ:5dhhBQM>>4XG001>5ThgCQI>=dhFCSM>5ThgCQH004hF0P0001aF
F59GEUQBEeIH001JN5IGFWQFEeYhEUMJN5IGFWP005jH001VnF;HI_URf6KiH]QVnF;HI_T002eoo`@0
041oo`00NGoo0P006Woo00@001iM7UdN?@@000A:NP09001:>4iIBSQ>>4XhCUU:>000009>=`05CQM>
=dhgCSL00002CQL01DhgCQI>5dhGCSL0100001EBEe9HDUMBF59GDUQBEe9H001FN5IgEWQFMeIhEWMF
N5IgEWP006KiH]P00V;i00IVnF;HH_URnFKi000ZOol40014Ool007]oo`03001oogoo01Qoo`05000N
?AiM7SdNGP0700004TiIBSQ>FDXhCUU:>4iI001>>4XGCSQ:5dhhBQM>>000CSM>5P@0000PCUQ>=`00
DUMFF59GEUQBEeIHDUMFF59G001FEeYhEUMJN5IGFWQFEeYh001Rf@00I_URf6KiH]QVnF;HI_T002Mo
o`@004Qoo`00O7oo00<007ooOol067oo0P0000LNGAhm7Ud003IL=S`fG007000014hhBSQ>F@000dhg
1P0001M>>4iHCSQ>F4hhCUQ>>000DUMBF59GDUQBEe9HDUMBF000EWQFMeIhEWMFN5Ig0080009Nf@04
001RnFKiH]P2H_T00fKi001oo`0SOol4001<Ool007eoo`03001oogoo01Qoo`<0000;7Sd0038l=U`b
>cIL<S`fG000@UY2>P080000:4YIASQ:F@00CUQ>=e9HCSQ>F4hgDUQ>>4iH001FF59GEUQBEeIHDUMF
F59GEUP005YhEUMJN5IG001N^F;IG]URfEji001Rf6KiH]QVn@008Goo1000D7oo001nOol2000IOol5
0002=U`013Hl=U`fG0001T8j00<004XiBSP00dXi01Y:>4Xi001>F4hhCUQ>>4iHCSQ>F4hhCUP0059H
DUMBF59GDUQBEe9HDUL005IgEWQFM`001ekI00@006;iI_T001ioo`@005Aoo`00P7oo00<007ooOol0
67oo100002Lb?3IL<S/fG38l000n>T9J@SY2FShj@UX004YIASQ:FDHhBUU6>000CSQ>F4hgDUQ>>4iH
CSMBF4hh001BEeIHDUMFF59GEUQBEeIHDUL00`0000]N^F;IG]URfEjiH]UNfF;I001Vn@0001]oo`@0
05Qoo`00PGoo00<007ooOol067oo00<0005j00000P0000@fG3Hl=U`000I2>P04001:>DXiBSP3BST0
5DXh001>>4iHCSQ>F4hhCUQ>>4iH001BF59GDUQBEe9HDUMBF59GDUP0000;G]T00`00Oomoo`0FOol4
001LOol0089oo`03001oogoo01Moo`<0000U0GT00000000b>cIL0012FShj@UY2>T9J?SX004HhBUU6
>4YIASQ:F@00DUQ>>4iHCSMBF4hhCUQ>=e9H001FF59GEUQBEeIHDUL00P0000aJfP00H]UNfF;IG[UR
fEkIH]UN^F;I000FOol3001POol008=oo`8001Moo`07001oogoo0001N@004M`00`001T8j00D004Xi
BSU:>DXh00=:>@0>001>F4hhCUQ>>4iHCSQ>F4hh001BEe9HDUMBF0800004E[YJ^UZj0007G]T2000C
Ool4001SOol008Eoo`03001oogoo01Aoo`04001oogooOol200000a7l3M/Ao0030000649J?SY2FT8j
@UX004YIASQ:FDHhBUU6>000CSMBF4hhCUQ>=e9HCSQ>F4hg001BE`80000=F]YF^E[JE[UJfUJi001N
^F;IG]URfEji00004Goo1000Igoo0026Ool00`00Oomoo`0COol00`00Oomoo`02Ool200024M`00a7l
3M`000030002@SX00`00BSQ:>@02BST02dXhBSU:>@00CSQ>F4hhCUQ>>4iHCSP00`000UZj00EF^UZj
F[YJ^UJj009J^P05001NfEkIG]T0000>Ool4001[Ool008Moo`03001oogoo019oo`03001oogoo00Ao
o`07000Ao0gK4O`002iM:S`00`0000a2>P00ASQ:FDHhBUU6>4YI001>F4hgDUP400003TjJD[/005[J
E[UJfUJiF]YF^E[JE[UJfP00H]T2000;Ool4001_Ool008Qoo`03001oogoo015oo`03001oogoo00Eo
o`8000074M`Ao000;SdZ?2iM:S`0300000Q>^djKC[]>VdjkCY/005Jj0eZj00MF^UZjF[YJ^UJjF[X0
0009Ool4001cOol008Uoo`80015oo`03001oogoo00Moo`80000P4O`002iM:S`^GBXl;Ud004:L?W]2
W3ik@Y`nNd:L001B^djJD[]>VU:kCYYB^djJ001F^E[JE[UJfUJiF]YF^@8000Ioo`@007Moo`00Rgoo
00<007ooOol03Woo00<007ooOol02Goo0P0000LZ?2hm:S`^GBXl;Sd00006@W`03000CY]>^djKC[]>
VdjkCY]>^djK001F^P=J^P8000Aoo`@007]oo`00S7oo00<007ooOol03Goo00<007ooOol02goo0`00
01LZ?2iM:S`003ik@Y`nNd:L?W]2W3ik001>VU:kCYYB^djJD[]>VU:k001JfUJi0080009oo`@007mo
o`00SGoo00<007ooOol037oo00<007ooOol03Woo1@001d9l00P004jKC[]>VdjkCY]>^djK1`00Pgoo
002>Ool2000;Ool00`00Oomoo`0COol600001Sik@Y`005:kCYYB^`L008Moo`00T7oo00<007ooOol0
27oo00<007ooOol06Goo2P00RWoo002AOol00`00Oomoo`07Ool00`00Oomoo`0KOol4002>Ool0099o
o`03001oogoo00Ioo`03001oogoo01Moo`@0099oo`00Tgoo0P001Woo00<007ooOol04goo1000UWoo
002EOol00`00Oomoo`03Ool00`00Oomoo`0?Ool4002JOol009Ioo`03001oogoo009oo`03001oogoo
00]oo`@009ioo`00Ugoo00D007ooOomoo`0000Uoo`@00:9oo`00V7oo0P0000=oo`00Ool017oo1000
YWoo002JOol200000goo00000002002ZOol009]oo`800:ioo`00\
\>"],
  ImageRangeCache->{{{0, 330}, {162.313, 0}} -> {-0.382303, 0.0432245, \
0.00489303, 0.00489303}}]
}, Open  ]],

Cell[TextData[{
  "We calculate the tangent surface of this function at the point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\((x\_0\),
            "TraditionalForm"], ",", \(y\_0\)}], TraditionalForm]]],
  ") = (\[Pi]/2, 0) by using our function"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ht = TangentSurface[h, {x, y}, {\[Pi]\/2, 0}]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(1 + \((\(-\(\[Pi]\/2\)\) + x)\)\ Cos[x]\ Cos[y] - y\ Sin[x]\ Sin[y]\)], 
  "Output"]
}, Open  ]],

Cell["\<\
A graphical representation of this relation for the tangent surface \
follows with\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(pl2 = 
      Plot3D[ht, {x,  .5, 2}, {y, \(-1\), 1}, \n\t\tColorFunction \[Rule] Hue]
        \)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-016 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -18 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.22808 .16727 -5.79519 -9 ]
[.22808 .16727 .20481 0 ]
[.44535 .08183 -16.1346 -9 ]
[.44535 .08183 1.86537 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 24 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 18 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -18 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -24 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0.5)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(1.5)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-1)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-0.5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(0.5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(1)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(0.25)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0.5)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.75)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
1 .668 0 r
.38253 .59755 .40453 .62075 .44146 .61045 .41954 .59369 Metetra
1 .794 0 r
.41954 .59369 .44146 .61045 .4789 .60066 .45722 .59009 Metetra
1 .929 0 r
.45722 .59009 .4789 .60066 .5169 .59115 .49561 .5864 Metetra
.932 1 0 r
.49561 .5864 .5169 .59115 .55547 .58173 .53474 .5823 Metetra
.799 1 0 r
.53474 .5823 .55547 .58173 .59464 .57221 .57459 .57748 Metetra
.678 1 0 r
.57459 .57748 .59464 .57221 .6344 .5624 .61516 .57166 Metetra
.574 1 0 r
.61516 .57166 .6344 .5624 .67477 .55217 .65644 .5646 Metetra
.491 1 0 r
.65644 .5646 .67477 .55217 .71575 .54139 .69839 .5561 Metetra
.435 1 0 r
.69839 .5561 .71575 .54139 .75732 .52996 .74096 .54598 Metetra
.406 1 0 r
.74096 .54598 .75732 .52996 .79948 .51783 .78412 .53415 Metetra
.406 1 0 r
.78412 .53415 .79948 .51783 .84221 .50496 .82781 .52056 Metetra
.435 1 0 r
.82781 .52056 .84221 .50496 .88552 .49136 .87199 .50521 Metetra
.492 1 0 r
.87199 .50521 .88552 .49136 .9294 .47709 .91661 .48818 Metetra
.575 1 0 r
.91661 .48818 .9294 .47709 .97385 .46221 .96163 .46957 Metetra
1 .696 0 r
.35995 .57497 .38253 .59755 .41954 .59369 .39698 .57703 Metetra
.995 1 0 r
.39698 .57703 .41954 .59369 .45722 .59009 .43484 .57915 Metetra
.686 1 0 r
.43484 .57915 .45722 .59009 .49561 .5864 .47356 .58087 Metetra
.39 1 0 r
.47356 .58087 .49561 .5864 .53474 .5823 .51317 .58175 Metetra
.115 1 0 r
.51317 .58175 .53474 .5823 .57459 .57748 .55365 .58136 Metetra
0 1 .128 r
.55365 .58136 .57459 .57748 .61516 .57166 .59499 .57931 Metetra
0 1 .332 r
.59499 .57931 .61516 .57166 .65644 .5646 .63713 .57525 Metetra
0 1 .491 r
.63713 .57525 .65644 .5646 .69839 .5561 .68002 .5689 Metetra
0 1 .6 r
.68002 .5689 .69839 .5561 .74096 .54598 .72359 .56003 Metetra
0 1 .655 r
.72359 .56003 .74096 .54598 .78412 .53415 .76774 .54847 Metetra
0 1 .655 r
.76774 .54847 .78412 .53415 .82781 .52056 .8124 .53416 Metetra
0 1 .599 r
.8124 .53416 .82781 .52056 .87199 .50521 .85747 .5171 Metetra
0 1 .49 r
.85747 .5171 .87199 .50521 .91661 .48818 .90287 .49739 Metetra
0 1 .33 r
.90287 .49739 .91661 .48818 .96163 .46957 .94854 .47519 Metetra
1 .743 0 r
.33675 .55266 .35995 .57497 .39698 .57703 .37375 .5599 Metetra
.785 1 0 r
.37375 .5599 .39698 .57703 .43484 .57915 .41174 .56705 Metetra
.323 1 0 r
.41174 .56705 .43484 .57915 .47356 .58087 .45073 .57356 Metetra
0 1 .114 r
.45073 .57356 .47356 .58087 .51317 .58175 .49075 .57887 Metetra
0 1 .514 r
.49075 .57887 .51317 .58175 .55365 .58136 .5318 .58244 Metetra
0 1 .865 r
.5318 .58244 .55365 .58136 .59499 .57931 .57382 .58377 Metetra
0 .842 1 r
.57382 .58377 .59499 .57931 .63713 .57525 .61677 .58242 Metetra
0 .615 1 r
.61677 .58242 .63713 .57525 .68002 .5689 .66055 .57801 Metetra
0 .46 1 r
.66055 .57801 .68002 .5689 .72359 .56003 .70506 .57023 Metetra
0 .382 1 r
.70506 .57023 .72359 .56003 .76774 .54847 .75019 .55888 Metetra
0 .383 1 r
.75019 .55888 .76774 .54847 .8124 .53416 .7958 .54387 Metetra
0 .462 1 r
.7958 .54387 .8124 .53416 .85747 .5171 .84177 .52519 Metetra
0 .617 1 r
.84177 .52519 .85747 .5171 .90287 .49739 .88799 .50298 Metetra
0 .845 1 r
.88799 .50298 .90287 .49739 .94854 .47519 .93434 .47745 Metetra
1 .797 0 r
.31291 .53032 .33675 .55266 .37375 .5599 .34987 .54179 Metetra
.594 1 0 r
.34987 .54179 .37375 .5599 .41174 .56705 .38793 .55308 Metetra
.003 1 0 r
.38793 .55308 .41174 .56705 .45073 .57356 .42713 .56355 Metetra
0 1 .552 r
.42713 .56355 .45073 .57356 .49075 .57887 .4675 .57254 Metetra
0 .943 1 r
.4675 .57254 .49075 .57887 .5318 .58244 .50903 .57941 Metetra
0 .501 1 r
.50903 .57941 .5318 .58244 .57382 .58377 .55166 .58357 Metetra
0 .134 1 r
.55166 .58357 .57382 .58377 .61677 .58242 .59532 .58447 Metetra
.15 0 1 r
.59532 .58447 .61677 .58242 .66055 .57801 .63991 .58165 Metetra
.343 0 1 r
.63991 .58165 .66055 .57801 .70506 .57023 .68531 .57474 Metetra
.441 0 1 r
.68531 .57474 .70506 .57023 .75019 .55888 .73135 .56351 Metetra
.44 0 1 r
.73135 .56351 .75019 .55888 .7958 .54387 .77788 .54782 Metetra
.342 0 1 r
.77788 .54782 .7958 .54387 .84177 .52519 .82474 .52769 Metetra
.147 0 1 r
.82474 .52769 .84177 .52519 .88799 .50298 .87178 .50326 Metetra
0 .137 1 r
.87178 .50326 .88799 .50298 .93434 .47745 .91886 .4748 Metetra
1 .847 0 r
.28842 .50766 .31291 .53032 .34987 .54179 .32533 .52225 Metetra
.437 1 0 r
.32533 .52225 .34987 .54179 .38793 .55308 .36344 .53662 Metetra
0 1 .254 r
.36344 .53662 .38793 .55308 .42713 .56355 .40281 .55003 Metetra
0 1 .901 r
.40281 .55003 .42713 .56355 .4675 .57254 .44346 .56176 Metetra
0 .512 1 r
.44346 .56176 .4675 .57254 .50903 .57941 .48538 .57109 Metetra
0 0 1 r
.48538 .57109 .50903 .57941 .55166 .58357 .52853 .57734 Metetra
.426 0 1 r
.52853 .57734 .55166 .58357 .59532 .58447 .57281 .5799 Metetra
.754 0 1 r
.57281 .5799 .59532 .58447 .63991 .58165 .61812 .57823 Metetra
.978 0 1 r
.61812 .57823 .63991 .58165 .68531 .57474 .66429 .57191 Metetra
1 0 .91 r
.66429 .57191 .68531 .57474 .73135 .56351 .71117 .56067 Metetra
1 0 .911 r
.71117 .56067 .73135 .56351 .77788 .54782 .75856 .54434 Metetra
.976 0 1 r
.75856 .54434 .77788 .54782 .82474 .52769 .80627 .52296 Metetra
.751 0 1 r
.80627 .52296 .82474 .52769 .87178 .50326 .85412 .49668 Metetra
.422 0 1 r
.85412 .49668 .87178 .50326 .91886 .4748 .90195 .46582 Metetra
1 .885 0 r
.26326 .48447 .28842 .50766 .32533 .52225 .30014 .50094 Metetra
.325 1 0 r
.30014 .50094 .32533 .52225 .36344 .53662 .3383 .51715 Metetra
0 1 .434 r
.3383 .51715 .36344 .53662 .40281 .55003 .37781 .53234 Metetra
0 .856 1 r
.37781 .53234 .40281 .55003 .44346 .56176 .41868 .54572 Metetra
0 .213 1 r
.41868 .54572 .44346 .56176 .48538 .57109 .46093 .55651 Metetra
.348 0 1 r
.46093 .55651 .48538 .57109 .52853 .57734 .5045 .56399 Metetra
.813 0 1 r
.5045 .56399 .52853 .57734 .57281 .5799 .5493 .56749 Metetra
1 0 .828 r
.5493 .56749 .57281 .5799 .61812 .57823 .5952 .56642 Metetra
1 0 .585 r
.5952 .56642 .61812 .57823 .66429 .57191 .64205 .56034 Metetra
1 0 .462 r
.64205 .56034 .66429 .57191 .71117 .56067 .68966 .54892 Metetra
1 0 .462 r
.68966 .54892 .71117 .56067 .75856 .54434 .73781 .53202 Metetra
1 0 .587 r
.73781 .53202 .75856 .54434 .80627 .52296 .78631 .50964 Metetra
1 0 .832 r
.78631 .50964 .80627 .52296 .85412 .49668 .83494 .48197 Metetra
.808 0 1 r
.83494 .48197 .85412 .49668 .90195 .46582 .88353 .44936 Metetra
1 .906 0 r
.2374 .46061 .26326 .48447 .30014 .50094 .27432 .4776 Metetra
.268 1 0 r
.27432 .4776 .30014 .50094 .3383 .51715 .31256 .49433 Metetra
0 1 .526 r
.31256 .49433 .3383 .51715 .37781 .53234 .3522 .51001 Metetra
0 .732 1 r
.3522 .51001 .37781 .53234 .41868 .54572 .39327 .52382 Metetra
0 .06 1 r
.39327 .52382 .41868 .54572 .46093 .55651 .43578 .53497 Metetra
.525 0 1 r
.43578 .53497 .46093 .55651 .5045 .56399 .47968 .54271 Metetra
1 0 .989 r
.47968 .54271 .5045 .56399 .5493 .56749 .52489 .54634 Metetra
1 0 .615 r
.52489 .54634 .5493 .56749 .5952 .56642 .57127 .54526 Metetra
1 0 .361 r
.57127 .54526 .5952 .56642 .64205 .56034 .61866 .53901 Metetra
1 0 .233 r
.61866 .53901 .64205 .56034 .68966 .54892 .66687 .52725 Metetra
1 0 .234 r
.66687 .52725 .68966 .54892 .73781 .53202 .71569 .50983 Metetra
1 0 .363 r
.71569 .50983 .73781 .53202 .78631 .50964 .76488 .48675 Metetra
1 0 .619 r
.76488 .48675 .78631 .50964 .83494 .48197 .81425 .45821 Metetra
1 0 .994 r
.81425 .45821 .83494 .48197 .88353 .44936 .86358 .42458 Metetra
1 .906 0 r
.21083 .43602 .2374 .46061 .27432 .4776 .24788 .45213 Metetra
.268 1 0 r
.24788 .45213 .27432 .4776 .31256 .49433 .28626 .46799 Metetra
0 1 .526 r
.28626 .46799 .31256 .49433 .3522 .51001 .32606 .4828 Metetra
0 .732 1 r
.32606 .4828 .3522 .51001 .39327 .52382 .36731 .49577 Metetra
0 .06 1 r
.36731 .49577 .39327 .52382 .43578 .53497 .41004 .50612 Metetra
.525 0 1 r
.41004 .50612 .43578 .53497 .47968 .54271 .4542 .51309 Metetra
1 0 .989 r
.4542 .51309 .47968 .54271 .52489 .54634 .49971 .516 Metetra
1 0 .615 r
.49971 .516 .52489 .54634 .57127 .54526 .54645 .51426 Metetra
1 0 .361 r
.54645 .51426 .57127 .54526 .61866 .53901 .59426 .50741 Metetra
1 0 .233 r
.59426 .50741 .61866 .53901 .66687 .52725 .64294 .49512 Metetra
1 0 .234 r
.64294 .49512 .66687 .52725 .71569 .50983 .69229 .47724 Metetra
1 0 .363 r
.69229 .47724 .71569 .50983 .76488 .48675 .74208 .45378 Metetra
1 0 .619 r
.74208 .45378 .76488 .48675 .81425 .45821 .7921 .42492 Metetra
1 0 .994 r
.7921 .42492 .81425 .45821 .86358 .42458 .84214 .39104 Metetra
1 .885 0 r
.18351 .41069 .21083 .43602 .24788 .45213 .22082 .42452 Metetra
.325 1 0 r
.22082 .42452 .24788 .45213 .28626 .46799 .25944 .43812 Metetra
0 1 .434 r
.25944 .43812 .28626 .46799 .32606 .4828 .29945 .45073 Metetra
0 .856 1 r
.29945 .45073 .32606 .4828 .36731 .49577 .34091 .46159 Metetra
0 .213 1 r
.34091 .46159 .36731 .49577 .41004 .50612 .38384 .46996 Metetra
.348 0 1 r
.38384 .46996 .41004 .50612 .4542 .51309 .4282 .47513 Metetra
.813 0 1 r
.4282 .47513 .4542 .51309 .49971 .516 .47393 .47647 Metetra
1 0 .828 r
.47393 .47647 .49971 .516 .54645 .51426 .52092 .47342 Metetra
1 0 .585 r
.52092 .47342 .54645 .51426 .59426 .50741 .56901 .46554 Metetra
1 0 .462 r
.56901 .46554 .59426 .50741 .64294 .49512 .61803 .45254 Metetra
1 0 .462 r
.61803 .45254 .64294 .49512 .69229 .47724 .66778 .43427 Metetra
1 0 .587 r
.66778 .43427 .69229 .47724 .74208 .45378 .71805 .41073 Metetra
1 0 .832 r
.71805 .41073 .74208 .45378 .7921 .42492 .76863 .38212 Metetra
.808 0 1 r
.76863 .38212 .7921 .42492 .84214 .39104 .81932 .34876 Metetra
1 .847 0 r
.15539 .38473 .18351 .41069 .22082 .42452 .19313 .39493 Metetra
.437 1 0 r
.19313 .39493 .22082 .42452 .25944 .43812 .23211 .40492 Metetra
0 1 .254 r
.23211 .40492 .25944 .43812 .29945 .45073 .27244 .41403 Metetra
0 1 .901 r
.27244 .41403 .29945 .45073 .34091 .46159 .31416 .42157 Metetra
0 .512 1 r
.31416 .42157 .34091 .46159 .38384 .46996 .35729 .42686 Metetra
0 0 1 r
.35729 .42686 .38384 .46996 .4282 .47513 .40183 .42928 Metetra
.426 0 1 r
.40183 .42928 .4282 .47513 .47393 .47647 .44771 .42825 Metetra
.754 0 1 r
.44771 .42825 .47393 .47647 .52092 .47342 .49485 .42328 Metetra
.978 0 1 r
.49485 .42328 .52092 .47342 .56901 .46554 .54311 .41398 Metetra
1 0 .91 r
.54311 .41398 .56901 .46554 .61803 .45254 .59233 .40009 Metetra
1 0 .911 r
.59233 .40009 .61803 .45254 .66778 .43427 .64235 .38149 Metetra
.976 0 1 r
.64235 .38149 .66778 .43427 .71805 .41073 .69297 .35818 Metetra
.751 0 1 r
.69297 .35818 .71805 .41073 .76863 .38212 .744 .33032 Metetra
.422 0 1 r
.744 .33032 .76863 .38212 .81932 .34876 .79528 .29821 Metetra
1 .797 0 r
.12642 .3583 .15539 .38473 .19313 .39493 .16478 .3636 Metetra
.594 1 0 r
.16478 .3636 .19313 .39493 .23211 .40492 .2043 .36877 Metetra
.003 1 0 r
.2043 .36877 .23211 .40492 .27244 .41403 .24505 .37321 Metetra
0 1 .552 r
.24505 .37321 .27244 .41403 .31416 .42157 .28711 .37633 Metetra
0 .943 1 r
.28711 .37633 .31416 .42157 .35729 .42686 .33049 .37756 Metetra
0 .501 1 r
.33049 .37756 .35729 .42686 .40183 .42928 .3752 .37637 Metetra
0 .134 1 r
.3752 .37637 .40183 .42928 .44771 .42825 .4212 .37227 Metetra
.15 0 1 r
.4212 .37227 .44771 .42825 .49485 .42328 .46841 .36485 Metetra
.343 0 1 r
.46841 .36485 .49485 .42328 .54311 .41398 .51673 .35379 Metetra
.441 0 1 r
.51673 .35379 .54311 .41398 .59233 .40009 .56604 .33887 Metetra
.44 0 1 r
.56604 .33887 .59233 .40009 .64235 .38149 .6162 .31998 Metetra
.342 0 1 r
.6162 .31998 .64235 .38149 .69297 .35818 .66705 .29714 Metetra
.147 0 1 r
.66705 .29714 .69297 .35818 .744 .33032 .71843 .27049 Metetra
0 .137 1 r
.71843 .27049 .744 .33032 .79528 .29821 .77021 .24025 Metetra
1 .743 0 r
.0965 .33164 .12642 .3583 .16478 .3636 .13573 .33092 Metetra
.785 1 0 r
.13573 .33092 .16478 .3636 .2043 .36877 .17596 .33018 Metetra
.323 1 0 r
.17596 .33018 .2043 .36877 .24505 .37321 .2173 .32894 Metetra
0 1 .114 r
.2173 .32894 .24505 .37321 .28711 .37633 .2598 .32673 Metetra
0 1 .514 r
.2598 .32673 .28711 .37633 .33049 .37756 .3035 .32308 Metetra
0 1 .865 r
.3035 .32308 .33049 .37756 .3752 .37637 .34841 .31758 Metetra
0 .842 1 r
.34841 .31758 .3752 .37637 .4212 .37227 .39451 .30984 Metetra
0 .615 1 r
.39451 .30984 .4212 .37227 .46841 .36485 .44175 .29954 Metetra
0 .46 1 r
.44175 .29954 .46841 .36485 .51673 .35379 .49006 .28645 Metetra
0 .382 1 r
.49006 .28645 .51673 .35379 .56604 .33887 .53936 .27038 Metetra
0 .383 1 r
.53936 .27038 .56604 .33887 .6162 .31998 .58955 .25125 Metetra
0 .462 1 r
.58955 .25125 .6162 .31998 .66705 .29714 .64051 .22909 Metetra
0 .617 1 r
.64051 .22909 .66705 .29714 .71843 .27049 .69213 .20399 Metetra
0 .845 1 r
.69213 .20399 .71843 .27049 .77021 .24025 .74431 .17614 Metetra
1 .696 0 r
.06554 .30507 .0965 .33164 .13573 .33092 .10587 .29736 Metetra
.995 1 0 r
.10587 .29736 .13573 .33092 .17596 .33018 .14705 .28982 Metetra
.686 1 0 r
.14705 .28982 .17596 .33018 .2173 .32894 .18914 .2821 Metetra
.39 1 0 r
.18914 .2821 .2173 .32894 .2598 .32673 .23222 .27383 Metetra
.115 1 0 r
.23222 .27383 .2598 .32673 .3035 .32308 .27633 .26468 Metetra
0 1 .128 r
.27633 .26468 .3035 .32308 .34841 .31758 .32149 .25434 Metetra
0 1 .332 r
.32149 .25434 .34841 .31758 .39451 .30984 .3677 .24255 Metetra
0 1 .491 r
.3677 .24255 .39451 .30984 .44175 .29954 .41496 .22908 Metetra
0 1 .6 r
.41496 .22908 .44175 .29954 .49006 .28645 .46322 .21375 Metetra
0 1 .655 r
.46322 .21375 .49006 .28645 .53936 .27038 .51244 .19645 Metetra
0 1 .655 r
.51244 .19645 .53936 .27038 .58955 .25125 .56257 .17712 Metetra
0 1 .599 r
.56257 .17712 .58955 .25125 .64051 .22909 .61354 .15577 Metetra
0 1 .49 r
.61354 .15577 .64051 .22909 .69213 .20399 .66529 .13247 Metetra
0 1 .33 r
.66529 .13247 .69213 .20399 .74431 .17614 .71778 .10736 Metetra
1 .668 0 r
.03339 .27895 .06554 .30507 .10587 .29736 .0751 .26349 Metetra
1 .794 0 r
.0751 .26349 .10587 .29736 .14705 .28982 .11744 .24847 Metetra
1 .929 0 r
.11744 .24847 .14705 .28982 .18914 .2821 .16049 .23366 Metetra
.932 1 0 r
.16049 .23366 .18914 .2821 .23222 .27383 .2043 .21883 Metetra
.799 1 0 r
.2043 .21883 .23222 .27383 .27633 .26468 .24894 .20376 Metetra
.678 1 0 r
.24894 .20376 .27633 .26468 .32149 .25434 .29443 .18826 Metetra
.574 1 0 r
.29443 .18826 .32149 .25434 .3677 .24255 .3408 .17216 Metetra
.491 1 0 r
.3408 .17216 .3677 .24255 .41496 .22908 .38808 .15533 Metetra
.435 1 0 r
.38808 .15533 .41496 .22908 .46322 .21375 .43627 .13766 Metetra
.406 1 0 r
.43627 .13766 .46322 .21375 .51244 .19645 .48537 .11908 Metetra
.406 1 0 r
.48537 .11908 .51244 .19645 .56257 .17712 .53538 .09956 Metetra
.435 1 0 r
.53538 .09956 .56257 .17712 .61354 .15577 .58629 .0791 Metetra
.492 1 0 r
.58629 .0791 .61354 .15577 .66529 .13247 .6381 .05774 Metetra
.575 1 0 r
.6381 .05774 .66529 .13247 .71778 .10736 .6908 .03557 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0.5)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(1.5)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{333, 158.625},
  ImageMargins->{{0, 0}, {0, 1.3125}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005=0000WQ000`40O003h00OogooCWoo003=Ool4
001lOol00<eoo`03001oogoo07eoo`00cWoo00<007ooOol0O7oo003?Ool00`00Oomoo`1kOol00<eo
o`04001oogoo001lOol00<ioo`8000]oo`D006eoo`00gGoo00<007ooOol0KGoo003MOol00`00Oomo
o`1]Ool00=Eoo`@000Aoo`03001oogoo06eoo`00gGoo00<007ooOol0KGoo003AOol20009Ool2001_
Ool00<moo`800003Ool0000007Uoo`00c7oo0`000goo0P00NGoo0039Ool30006Ool00`00Ool0001h
Ool00<Moo`<000Qoo`04001oogoo001gOol00<Aoo`<000]oo`04001oo`00001gOol00<9oo`8000eo
o`8000=oo`03001oogoo07Aoo`00Ugoo1@000Woo0P0017oo0P006Goo0`003Goo0P0000=7h000Ool0
0goo00<007ooOol0Lgoo002IOol00`00Oomoo`07Ool01000Oomoo`005Woo0P003Woo0P0000=7h4_P
An000P000goo00<007ooOol0Lgoo002IOol00`00Oomoo`0:Ool00`00Oomoo`0AOol3000>Ool20000
1D_PAn17h4OPBn000P0017oo00<007ooOol0LWoo002IOol00`00Oomoo`08Ool2000BOol2000>Ool3
00002TOPBn17h4_PAn1;h4OP0017h0000Woo00<007oo0000Lgoo002IOol00`00Oomoo`08Ool00`00
Oomoo`0>Ool4000=Ool2000013_P0017h4_P0dOP00A;h4OPAn17h08000Aoo`03001oogoo075oo`00
V7oo0P002Woo0`002goo0`003Woo0`0000doh3_P?n0kh000An1;h4OPBn17h4_PAn1;h0020005Ool0
0`00Oomoo`1`Ool00;1oo`8000moo`8000<oh005>n0oh3oP?n000002An002D_PAn17h4OPBn17h000
An000005Ool00`00Oomoo`1_Ool00:eoo`@000eoo`<0000E>n0oh3_P?n0kh3oP>n0oh3_P0017h4_P
An1;h4OPBn17h4_P001;h00000Aoo`80075oo`00Zgoo0P003goo0P0000<gh000>n000coP00Dkh3oP
?n0oh3_P008oh0050017h4OPAn1;h003An000`00An000006Ool00`00Oomoo`1^Ool00:Qoo`<000mo
o`80000K=n0ch3OP=n0003_P?n0kh3oP>n0oh3_P?n0kh3oP001;h4OPBn17h4_PAn1;h000Bn17h000
00Ioo`03001oogoo06eoo`00YWoo0`003goo0P001SOP00<003oP>n000coP00Pkh3oP?n0oh3_P?n00
04_P0dOP00I;h4OP0017h4_P0006Ool00`00Oomoo`1]Ool00:=oo`<000moo`<000<gh00M<n0gh3OP
=n0ch000>n0oh3_P?n0kh3oP>n0oh3_P?n0kh000An1;h4OPBn17h4_P001;h4OPBn000005Ool2000<
Ool20004Ool20004Ool2001DOol00:1oo`<000moo`<00003<n0003OP00Tgh004000oh3oP>n03?n00
1C_P?n0oh3oP00000TOP00E;h4OPAn17h00000=7h003001oogoo00Eoo`03001oogoo00Qoo`04001o
ogoo0008Ool01000Oomoo`00Dgoo002NOol3000>Ool30003<n001BoP<n0003OP<n000cOP01Pch3OP
=n0gh000?n0kh3oP>n0oh3_P?n0kh3oP>n0oh000Bn17h4_PAn1;h000Bn030007Ool00`00Oomoo`08
Ool01000Oomoo`002goo00<007ooOol0DGoo002KOol3000>Ool30008<n000`00=n0gh008=n001@00
?n0oh3oP>n000coP00@kh3oP?n0000=7h008Bn17h0000003jP?Y0nX000Moo`04001oogooOol40002
Ool01000Oomoo`002Goo0P00E7oo001jOol5000JOol2000?Ool2000013?P000ch2oP0c?P00D_h3?P
<n0ch00000<gh005<n0gh3OP=n0ch002=n003`00>n0oh3_P?n0kh3oP>n0oh3_P?n0004_PAn1;h003
00001@?Z0nT3jP?Y000027oo00<007ooOol01Woo00@007ooOol000Uoo`03001oogoo05=oo`00O7oo
00<007ooOol05goo0`003goo0P0013?P00<003?P<n001c?P00<003OP=n001cOP00<003oP>n000coP
00Hkh3oP?n0oh3_P?n0300002@?Z0nT000?Y0nX3j@?Z0nT00006Ool20009Ool2000:Ool3001COol0
07aoo`03001oogoo01Eoo`80011oo`800003<n0_h3?P008ch005;n0003?P<n0_h003<n001BoP<n0c
h000<n000cOP010ch3OP=n0gh3?P=n0003oP>n0oh3_P?n0kh3oP>n0oh080000;0nT3jP?Y0nX000?Z
0nT3jP?Y0nX00008Ool00`00Oomoo`1XOol007aoo`03001oogoo019oo`<000moo`<000Pch003000c
h3?P00Pch003000gh3OP00Lgh004000oh3oP>n03?n0043_P000000?_0003jP?Y0nX3j@000nT3jP?Y
0nX3j@002Goo00<007ooOol0Igoo001lOol00`00Oomoo`0@Ool2000?Ool300001C?P000ch3?P;n00
0c?P00D_h3?P<n0ch00000<ch009;n0ch3?P<n0_h3?P000gh3?P00<gh009<n0gh3OP=n0003oP>n0o
h3_P00<0000@0nh3k`?^0nl000?Z0nT3jP000nX3j@?Z0nT3jP?Y0008Ool00`00Oomoo`1WOol007]o
o`8000moo`<000ioo`<000Dgh003000ch3?P00Lch003000ch3?P00Lch003000gh3OP00Pgh005000o
h0000003kP030nl03`?^0nl3k`000nT3jP?Y0003j@?Z0nT3jP?Y0nX00008Ool2001XOol008Uoo`<0
00ioo`<00005<n0gh3OP=n0ch003=n001@00<n0ch3?P;n000c?P00D_h3?P<n0002oP00<ch006;n0c
h3?P<n0_h0000SOP00Hch3OP=n0gh3?P=n0300005@?_0nh3k`?^0nl3kP?_0nh3k`000nX3j@?Z0003
jP?Y0nX3j@?Z0nT0000:Ool00`00Oomoo`1UOol008Moo`8000moo`800003>n0003OP00Pgh003000c
h3?P00Pch003000ch3?P00Lch003000gh3OP00@gh08000040o8000?_0nh30nl04P?^0nl3k`?_0nh3
k`000nX3j@000nT3jP?Y0nX3j@?Z0nT000Uoo`03001oogoo06Eoo`00Q7oo0`003Woo0`0000Doh3_P
?n0kh000008gh005<n0gh3OP=n0ch002=n000`00;n0ch002<n001RoP<n0ch3?P;n00008ch005;n0c
h3?P<n0_h002<n000`00<n0gh002=n0200030o8060?c0003k`?^0nl3kP?_0nh3k`?^0nl3kP000nT3
jP000nX3j@?Z0nT3jP?Y0nX000Yoo`03001oogoo06Aoo`00PWoo0P003Woo0`000coP00Dkh3oP?n0o
h00000Tgh003000ch3?P00Pch003000ch3?P00Lch004000gh00000060o8010000nl3k`?^0`?_0143
kP?_0nl3k`000nX3j@000nT3jP?Y0nX3j@?Z0nT3jP0000Qoo`<006Eoo`00Ogoo0`003Woo0P0000a;
h000?n0kh3oP>n0oh3_P?n0kh3oP0003=n002C?P=n0gh3OP<n0gh000<n0_h003<n001BoP<n0ch3?P
00000c?P00D_h3?P<n0ch2oP00<000030o83l`?b0083lP0K0o<3lP?b0o8000?^0nl3kP?_0nh3k`?^
0nl3kP000nT3jP000nX3j@?Z0nT3jP?Y0nX3j@0000Yoo`03001oogoo06=oo`00OGoo0P000Woo00<0
07ooOol02Goo0`0014OP00<003oP>n000coP00@kh3oP?n0000Tgh003000ch3?P00Lch003000ch3?P
00<ch0<000030o@000?b00T3lP050003k`?_0nl3kP030nl030?^0nl3k`000nT3jP000nX3j@?Z0nT3
jP<000]oo`03001oogoo069oo`00NWoo0`003Goo0`0001=7h4_PAn1;h4OPBn17h000>n0oh3_P?n0k
h3oP>n0oh000=n0ch003=n001C?P=n0gh3OP00000c?P00D_h3?P<n0ch2oP008ch003000_h0000080
00060o<3m0?d0o@3l`000`?b01P3l`?b0o83lP?c0o8000?^0nl3kP?_0nh3k`?^0nl3kP?_0003jP?Y
0003j@?Z0nT200030el00`00Oomoo`09Ool00`00Oomoo`1QOol007Moo`<000eoo`<00003En0004OP
00Q7h004000oh3oP>n03?n000c_P?n000009=n000`00<n0ch006<n0300080o@00`000o83lP080o80
0`000nh3k`020nl02P?^0nl3k`?_0nh000?Y0nX000?Z0P001@=O00<007ooOol027oo0P00Hgoo001e
Ool2000=Ool3000065?PEn1Ch5OPDn0004OPBn17h4_PAn1;h4OPBn0003oP>n0oh3_P?n0kh3oP>n00
008gh005<n0gh3OP=n0ch002=n000`00;n0ch002<n001RoP<n0000000o<00083m0050o<3m0?d0o@3
l`030o@00`000o<3lP020o804P?c0o83lP?b0o<000?_0nh3k`?^0nl3kP?_0nh3k`?^0003j@8000P3
G`03001oogoo00Uoo`03001oogoo061oo`00BWoo0P0017oo0P0017oo0P006Woo0`0037oo0`000UOP
00MCh5OPEn1Gh5?PEn000008An000`00>n0oh002?n001C_P?n0oh3oP00002COP00<003?P<n000S?P
0P0010?d00<000?d0o@01`?d00<000?b0o801`?b00@000?_0nl3kP<3k`030nh3k`?_00@000T3G`03
001oogoo00Yoo`03001oogoo05moo`00BGoo00@007ooOol000Qoo`04001oogoo000GOol3000:Ool4
00007f?P001Ch5OPDn1Gh5?PEn1Ch5OPDn0004OPBn17h4_PAn1;h4OPBn17h000>n0oh3_P?n0kh3oP
>n0oh00000<gh008<n0gh3OP=n0ch3OP000ch0800083m0050o<3m0?d0o@000030o@01`?c0o@3m0?d
0o<3m0000083lP050o<3lP?b0o83l`030o801`000nh3k`?^0nl3kP?_008000040Ul000=O000:0el0
0`00Oomoo`09Ool00`00Oomoo`04Ool2001IOol004Uoo`04001oogoo000;Ool00`00Oomoo`0BOol3
0009Ool4000026OPHn1Wh6?PIn1Sh000Dn03En001U?PEn1Gh5OPDn0000Q7h003000oh3_P00<oh004
>n0oh3oP0007=n0400080o@00`000o@3m0080o@00`000o83lP070o801@000nl3k`?_0nh00P0000@2
O`9O0Wl2O`8000X3G`03001oogoo00Uoo`8000Aoo`04001oogoo001HOol004Uoo`04001oogoo0009
Ool2000BOol3000:Ool20000:W?PMn0006OPHn1Wh6?PIn1Sh6OP001Gh5?PEn1Ch5OPDn1Gh5?PEn00
04_PAn1;h4OPBn17h4_PAn0003_P?n0kh3oP>n0oh3_P?n0kh000<n0gh0@00083lP050003m0?d0o@3
l`030o@01@?c0o@3m0000o<00`?d00H3l`?d0o@3m0?c00030o801@?c0o83lP?b0o<00P?b00X000?_
0000009O0Wl2G`9o0Ul2O`8000/3G`03001oogoo00Uoo`03001oogoo009oo`04001oogoo001HOol0
04Uoo`04001oogoo0009Ool00`00Oomoo`0?Ool40008Ool30004Mn003000Hn1Wh6?PIn1Sh6OPHn1W
h000En1Ch0=Gh004Dn1Gh5OP0009An001000?n0oh3_P0coP00<kh00000000P001`?b00<000?d0o@0
1`?d00<000?d0o@01`?d00<000?b0o801`?b0`000`9o00L2G`9o0Wl2O`9O0Wl0000;0el00`00Oomo
o`0:Ool01@00Oomoogoo00000Woo00<007ooOol0EWoo001:Ool2000:Ool3000<Ool30009Ool30000
:GOPLn1gh7?PMn1ch7OPLn0006?PIn1Sh6OPHn1Wh6?P001Ch5OPDn1Gh5?PEn1Ch5OPDn0004OPBn17
h4_PAn1;h4OPBn0003oP>n0oh3_P?n000P0000<3kP000o800P?b00P3l`?b0o83lP?c0o8000?c0`?d
00T3l`?d0o@3m0?c0o@000?d0o<00`?d00H3l`?d0o@3m0000o<30o804@?c0o8000000Ml0009o0Ul2
O`9O0Wl2G`9o0Ul2O`9O000030=O00<007ooOol02Woo00@007ooOol0009oo`03001oogoo05Ioo`00
Hgoo0P002Woo0P000WnP00<007OPMn001WOP00X006OPHn1Wh6?PIn1Sh6OPHn00009Gh007Dn1Gh5OP
En1Ch5OP00002DOP00<003oP00000P000`?_00<3kP000o8020?b00<000?d0o@01`?d00<000?d0o@0
1`?d00<000?b0o800P?b0P00107O00<0009o0Ul00`9o00@2G`9o0Wl2O`8000/3G`03001oogoo00Uo
o`8000=oo`8005Uoo`00H7oo0`0000=oo`00Ool01goo0P0002MoP7nPOh1oX000Mn1ch7OPLn1gh7?P
Mn1ch7OP001Wh6?PIn1Sh6OPHn1Wh000En1Ch5OPDn1Gh5?PEn1Ch000An1;h4OPBn17h4_PAn001000
00T3k`?^0nl3kP?_0nh3k`000o<00`?b00P3l`?b0o83lP?c0003m0?c0`?d00D3l`?d0o@3m00000<3
m0050o<3m0?d0o@3l`020o@04`000o8000000Ml1_`7O0Kl1g`6o0002G`9o0Ul2O`9O0Wl2G`9o00<0
00T3G`<000eoo`03001oogoo05]oo`00GWoo0P002Woo0`0000=oX7n0Oj000WnP00=oP7nP000027OP
00X006?PIn1Sh6OPHn1Wh6?PIn0000=Gh006Dn1Gh5OPEn1Ch0000TOP100000D3j@?Z0003k`?^00<3
k`050nh3k`?_0nl000080o800`000o@3m0080o@00`000o@3m0060o@300090Ml01@000Wl2O`9O0Wl0
0`000P9o00<000=O0el01@=O0P000P1o00<0W`00Ool037oo00<007ooOol0FWoo001LOol20008Ool4
000097lPO`0007n0Oj1oP7nPOh1oX7n0Oj0007OPLn1gh7?PMn1ch7OPLn0006?PIn1Sh6OPHn1Wh6?P
001Ch5OPDn1Gh5?PEn1Ch0@0000C0nX3j@?Z0nT3jP?Y0nX000?_0nh3k`?^0nl3kP?_0nh000?b0o<0
0`?b00D3l`?b0o83lP000083m0050o<3m0?d0o@3l`020o@00`000o<3m0020o@04P?c0o@000000Gl0
006o0Ml1_`7O0Kl1g`6o0Ml1_`7O0002O`<000050Wl2G`9o0Ul2O`0200050el01`0007l0W`1o09l0
O`0000eoo`03001oogoo05Yoo`00G7oo0P0017oo100000=o07lPO`000Wl000=o8000Oj000WnP00Io
P7nPOj1oX7n00008Mn003000In1Sh6OPHn1Wh6?PIn1Sh000Dn1Gh0@0000<0n<000?Y0nX3j@?Z0nT3
jP?Y0nX3j@000P?_00L3kP?_0nl3k`?^0nl000090o800`000o@3m0070o@00`000o@3m0020o@20004
0Gl00`000Ml1g`060Ml300030Wl01`9O0Wl2O`9o0Ul2O`0000<3G`8000<0O`0409l0O`1o000=Ool2
001KOol005Ioo`8000Aoo`04001oo`00Ool200008WjPOX0007l0Ob1o07lPO`1o87l0Ob0007nPOh1o
X7n0Oj1oP7nPOh0007?PMn1ch7OPLn1gh7?PMn0006OPHn1Wh6?P1P001P?S01@000?Y0nX3j@?Z0nT3
jP?Y0nX3j@000nh3k`?^0nl3kP?_0nh3k`000P?b00P3l`?b0o83lP?c0o8000?c0`?d00P3l`?d0o@3
m0?c0o@000?d0P0000d1O`6O0Gl1W`5o0Il0007O0Kl1g`6o0Ml1_`0200003@7O0Kl0009O0Wl2G`9o
0Ul2O`9O0Wl2G`9o00<0000:09l0O`2O07l0W`1o09l0O`2O000>Ool00`00Oomoo`1HOol005Eoo`04
001oogoo0002Ool500001Wj0OZ1nP7j0001o80=o0006Ob1o07l0O`1o80000gnP00IoP7nPOj1oX7n0
0006Mn0600023n000`_P3n0000070n<02`000nX3j@?Z0nT3jP?Y0nX3j@?Z00000`?_00H3kP?_0nl3
k`?^00090o800`000o@3m0060o@300090Gl00`000Ml1g`0300040Ml00`000Wl2G`030Wl01@9O0Wl2
O`9o0Ul00P0000D0W`1o07l0O`2O00<0O`0309l0O`0000ioo`03001oogoo05Qoo`00EGoo00@007oo
Ool0009oo`80000MOX1nX7j0OZ1nP7jPOX1nX000Ob1o07lPO`1o87l0Ob1o07lP001oX7n0Oj1oP7nP
Oh1oX000Mn1ch00400002c?P;n0000_P3n0;h0oP2n0?h0_P000020?S01@000?Z0nT3jP?Y0nX3j@?Z
0nT3jP000nl3kP?_0nh3k`?^0nl000?c0`?b00P3l`?b0o83lP?c0003m0?c0`?d0`0000`1O`000Il1
O`6O0Gl1W`5o0Il1O`6O0Gl30000406o0Ml1_`7O0Kl1g`6o0002G`9o0Ul2O`9O0Wl2G`9o100000`0
O`2O07l0W`1o09l0O`2O07l0W`1o000>Ool00`00Oomoo`1GOol005Eoo`04001oogoo0002Ool20002
OX001GjPOX1nP7j0OZ000Wj000<007lPO`000Wl000Io87l0O`1o0000Oh03Oj000gn0000000030000
0boP<n0_h002;n000c?P000?h0023n001P_P3n0?h0oP2n0000L3h`0<0003j@?Z0nT3jP?Y0nX3j@?Z
0nT000?^0`?_00D3kP?_0nl3k`0000T3lP030003m000008000D1O`030001O`5o00@1O`@000X1g`04
0002O`9o0Ul20Wl2000341l200000`1o09l0O`0207l01P2O07l0O`1o09l000eoo`03001oo`0005Qo
o`00EGoo00@007ooOol0009oo`<0000AOZ1nP7jPOX1nX7j0OZ1nP7jP001o87l0Ob1o07lPO`1o8006
00005E?PEn1Gh5OP000ch2oP<n0_h3?P;n0ch0003n0;h0oP2n0?h0_P3n0000080n<05@000nT3jP?Y
0nX3j@?Z0nT3jP000nl3kP?_0nh3k`?^0nl3kP000o83l`030o800`?c0o80000300020Gl02P6O0Gl1
O`5o0Il1O`000Gl1W`5o0`000181O`6O0Gl1W`000Ml1_`7O0Kl1g`6o0Ml1_`7O0002O`9O0Wl20000
4P`O41l<7a0O31l0001o0000O`2O07l0W`1o09l0O`2O07l000moo`03001oogoo05Ioo`00EWoo0P00
0goo00<007ooOol00P0000=nP7jPOX000Wj000InX7j0001o07lPO`040002On000`00En1Gh005En00
1@00;n0_h2oP<n000boP00<000_P3n000PoP00D;h0oP3n0?h00000L3h`0=0003jP?Y0nX3j@?Z0nT3
jP?Y0nX000?_0nh00`?_00@3kP?_0nl00083lP@00081g`030001O`5o00P1O`<000L1O`030001g`7O
00P1g`<0000341l<7a0O008@7`0831l@7a0O0000O`0007l0W`<0O`0509l0O`1o07l0000?Ool00`00
Oomoo`1EOol005]oo`03001oogoo009oo`05001nP7jPOX1nX00600002G_POn1kh7oPNn1oh000En1C
h003En0055?PEn1Gh000;n0ch2oP<n0_h3?P;n0000_P3n0;h0oP2n0?h0_P00080n<04@000nX3j@?Z
0nT3jP?Y0nX3j@000nh3k`?^0nl3kP?_0nh0100000T1g`6o0Ml1_`7O0Kl1g`000Il00`5o00<1W`5o
00000`0001<1W`5o0Il1O`6O0Gl1W`5o0Il0007O0Kl1g`6o0Ml1_`7O0Kl1g`0200005``O41l<7a0O
31l@7``O41l<7a0O0000W`0009l0O`2O07l0W`1o09l0O`2O00003goo0P00EWoo001JOol20005Ool4
0004OZ000`00On1oh006On000`00En1Gh006En001@00;n0_h2oP<n000RoP00<000oP2n000`oP00@;
h0oP3n0000L3h`0;0003j@?Z0nT3jP?Y0nX3j@?Z0nT000020nl400001@9O0001g`7O0Kl00`7O00@1
_`7O0Ml000<1O`<000@1O`030001O`5o00L1O`030001g`7O00@1g`800004:1l0010O31l341l02@`O
41l@7a0O31l@7`0009l0000207l0102O07l0O`1o0`0047oo00<007ooOol0E7oo001JOol20006Ool0
5000OZ1n`7jPO/1nX7k0OZ0007_POn1kh7oPNn1oh7_POn0005OPDn03En004e?PEn0003?P;n0ch2oP
<n0_h3?P000?h0_P3n0;h0oP2n0?h00000P3h`050003j@?Z0nT3jP070000409o0Ul2O`9O0Wl2G`00
0Kl1g`6o0Ml1_`7O0Kl1g`6o0`000`5o01<1W`5o0Gl1O`000Gl1W`5o0Il1O`6O0Gl1W`5o0001_`7O
0Kl1g`020002:1l06R@O:1l0010O31l@7``O41l<7a0O31l@7``O0000O`2O0000W`1o09l0O`00<1ld
7c0O000@Ool00`00Oomoo`04Ool20004Ool20004Ool20011Ool005Yoo`03001oogoo00Ioo`03001n
X7jP00EnX003001oh7oP00Eoh003001Gh5OP00IGh003000ch2oP008_h003<n0_h000008?h0072n0?
h0oP3n0;h0oP000010?S200010=O00<0009O0Wl00P9o00D2G`9o0Wl2O`0000<1g`040Kl1g`7O0Ml3
00090Gl00`000Gl1O`080Gl010000Ml000001RPO00@0010O41l<7`<@7`0831l@7a0O41l<7`0007l0
0080O`800005<1ld7c0O=1l0000AOol00`00Oomoo`02Ool01000Oomoo`0027oo00@007ooOol0041o
o`00@Woo0P0017oo0P000goo10000goo0P0017oo0P0027oo0P0000mn`7jPO/1nX7k0OZ0007_POn1k
h7oPNn1oh7_P00000UOP019Ch5OPEn1Gh5?P000_h3?P;n0ch2oP<n0_h0002n0?h0_P3n08000010?j
0o/3nP000P=O00D3?`=O0el3G`<o0083G`0=0002G`9o0Ul2O`9O0Wl2G`9o0001g`6o0Ml00`0000@1
g`6o0Ml00081O`050Il1O`5o0Gl1W`020Gl02@000Il1O`6O0Gl1W`5o0Il1O`0300001B@O:1lX7bPO
91l00bPO00lT7`0031l@7``O41l<7a0O31l@7``O41l0002O07l00P0000Pd7c0O=1l`7c@O<1ld7`00
3goo0P0017oo00@007ooOol000]oo`03001oogoo03ioo`00@Goo00@007ooOol000Qoo`03001oogoo
00=oo`04001oogoo0003Ool00`00Oomoo`09Ool00`00OZ1nX004OZ000`00On1oh004On000`00En1G
h003En0?00020nl00`?`0nl000020o/01P?j0o/3n`?k0oX000P3G`030002O`9O00<2O`030Ul2O`9o
00@000030Ml1_`7O0081g`030Kl0005o00P1O`030001O`5o00<1O`<00003=1l002PO00TX7`05000@
7a0O41l<7`0341l010`O41l@7a0O100000P`7c@O<1ld7c0O=1l`7`004Goo00D007ooOomoo`00009o
o`03001oogoo00Moo`80045oo`00@Goo00@007ooOol000Uoo`03001oogoo00Eoo`05001oogooOol0
000<OolC000072_P9n0[h2OP0003hP?S0n83h`?R0n<000?`0nl3l0?_0o03k`?`0003n`?j0o/3nP?k
0oX3n`000`=O00`3?`=O0el3G`<o0002G`9o0Ul2O`9O0Wl400002P6o0Ml1_`7O0Kl1g`6o0Ml0006O
0`5o00P1W`5o0Gl1O`6O0Gl0005o0`001C@O00@002PO:1lT7`<X7`0L91lX7bPO:1l0010O31l@7``O
41l<7a0O31l@7``O000`7c@O<1l0030O=1l`7c@O<1ld7c0O000AOol01000Oomoo`000Woo00<007oo
Ool01goo00<007ooOol0@7oo0011Ool01000Oomoo`002Woo00<007ooOol00Woo0P000goo00<007oo
Ool037oo00<007kPO^0017kP00<006?PHn0016?P00<002OP9n001BOP00D000?S0n<3h`?R0083h`05
0003k`?_0nl3l0030nl00`?`0003n`020o/01@?j0o/3n`?k000020=O00<0009o0Wl00`0000H2O`9O
0Wl0007O0Kl30Ml01@6o0Ml1g`7O0000205o0`0023@O00<002PO:1l022PO00<000`O41l00Q0O00@<
7a0O41l@7`<0000<=1l`7c@O000d7c0O=1l`7c@O<1ld7`0047oo0P000goo0P002Woo0`00@7oo0011
Ool01000Oomoo`0027oo00@007ooOol000=oo`03001oogoo009oo`8000ioo`08001nh7k0O^1n`7kP
O/0000ESh00R000Wh2_P9n0[h2OP:n0Wh2_P0003h`?R0n<3hP?S0n8000?_0o03k`?`0nl3l0?_0003
nP?k0oX3n`?j0o/3nP000cl30el010<o0el3G`=O0`0001<2O`9O0Wl2G`9o0Ul0006o0Ml1_`7O0Kl1
g`6o0Ml1_`000Gl1W`030Gl300000c@O000d7`08=1l00`0091lX7`02:1l01B@O:1lX7bPO91l00RPO
00H000`O41l<7a0O31l20003G1l03@00=1l`7c@O000d7c0O=1l`7c@O<1ld7`00015oo`03001oogoo
04moo`00@Woo0P002Woo0P0017oo0`000Woo00<007ooOol03Woo00<007kPO^0017kP00<006?PHn00
0f?P00<002OP9n001ROP00P000?S0n<3h`?R0n<000?`0`?_00H3l0?_0nl3k`000oX30o/010?j0o/3
n`0010=O0`0000<3G`000Wl00P9o00H2G`9o0Wl2O`9O00020Ml01@6o0Ml1g`7O0Kl00P7O00<0005o
00000P001C@O00<003@O=1l01c@O00<002PO:1l022PO00@0010O31l@7`8000EL7`0=000`7c@O<1ld
7`00=1l`7c@O<1ld7c0O00004Woo00<007ooOol0CWoo001IOol2000@Ool01`00O^1n`7kPO/1nh000
00ISh00Q000Wh2_P9n0[h2OP:n0Wh0000n83h`?R0n<3hP?S0003l0?_0o03k`?`0nl3l0000o/3nP?k
0oX3n`?j0o/000=O00<0000E0el3?`=O0el0009O0Wl2G`9o0Ul2O`9O0Wl0007O0Kl1g`6o0Ml1_`7O
00@000Pd7`03000d7c@O00Ld7`03000X7b@O00<X7`0691lX7bPO:1lT7bPO0`0025`O00T0030O=1l`
7c@O000d7c0O=1l00P0000=P7`00Ool047oo00<007ooOol0CWoo001IOol00`00Oomoo`0@Ool40002
O^000`00Hn1Sh004Hn000`009n0Wh0059n000`000n83h`020n<010?R0003k`?`0`?_00H3l0?_0nl0
00?k0oX30o/300070el00`000Wl2G`030Wl01@9O0Wl2O`9o00000P7O10000RPO00<003@O=1l01c@O
00<003@O=1l023@O00<002PO:1l01bPO0P002U`O00T003@O<1ld7c0O000`7c@O00000f@O00<007oo
Ool03Woo00<007oo0000Cgoo001IOol2000BOol00`00Ob1o00070002Hn006`00:n0Wh2_P9n0[h2OP
:n0000?S0n83h`?R0n<3hP000nl3l0?_0o03k`?`0nl000?j0o/3nP0200000`?k0oX000020el02`<o
0el3G`=O0cl3G`000Wl2G`9o0Ul01`000RPO00HT7bPO:1lX7b@O0009=1l00`00=1ld7`07=1l01000
:1lX7b@O0bPO00DT7`00001h7`0000]L7`05000d7c0O=1l`7`0200001V@OH1mT7f0OI1l0019oo`03
001oogoo04aoo`00Agoo0P0017oo0P0017oo0P000goo00<007ooOol04goo0P0000Eo07lPO`1o8000
009;h0l00083h`040003k`?_0o030nl00`?`0nl0000200001P?j0o/3n`?k0oX000@3G`P000D@7`03
000X7bPO00HX7`03000d7c@O00Ld7`03000d7c@O00Ld7`03000X7bPO008X7`<000Ah7`03001L7e`O
00QL7`07000`7c@O<1l006@O00001V@O00<007ooOol03goo00<007ooOol0C7oo0016Ool01000Oomo
o`0027oo00@007ooOol0009oo`8001Ioo`06001o07lPO`1o80001D_P00<000?P0n001@?P00<000?a
0o0060000100W`1o09l0O`0031l@7``O41l<7a0O31l@7`00:1lT7`<X7`0491lX7bPO000:=1l00`00
=1ld7`07=1l01P00:1l00000N1ml7`=h7`03O1mh7`0000]L7`<0000:H1mT7f0O001P7f@OH1mT7f0O
000AOol2001=Ool004Ioo`04001oogoo000;Ool01000Oomoo`0067oo0P0000Ao87l0Ob0000E;h003
0003h0?P00@3h0040003l@?a0o030o4400040kl00`000Ol1o`050Ol00`0007l0O`0507l00`0041l@
7`0741l00`00:1lX7`06:1l00`00=1ld7`07=1l00`00=1ld7`06=1l3000:N1l00`00G1mL7`08G1l0
0`00I1mT7`03I1l00`00I1mT7`04I1l00`00Oomoo`0@Ool00`00Oomoo`1:Ool004Ioo`04001oogoo
0009Ool20003Ool2000HOol60005Bn000`000n03h0040n0010000o03l@?`0`0000<3_`?O0kl00P>o
00<3g`>o00001`7o01<0001o09l0O`2O07l0W`1o09l0010O31l@7``O41l<7a0O31l00002:1l01b@O
:1lX7bPO91lX7`0000Td7`03000d7c@O00<d7`<00005O1el7000N1ml7`03N1l01W`ON1mh7gPOO1l0
00QL7`80000>O1X006@OH1mT7f0OI1l006@OH1mT7f0OI1l0019oo`03001oogoo04Yoo`00AWoo00@0
07ooOol000Uoo`03001oogoo009oo`03001oogoo01Qoo`04001o@7m0Od030003Bn000`000n03h005
0n03000010?`0o43l@001`>o00<0007o0Ol01@7o00<0001o07l01@1o00<0010O41l01a0O00<002PO
:1l01RPO00<003@O=1l01c@O00<003@O00000P001G`L00<007PON1l02GPO00<005`OG1l00e`O0P00
00Al6G`JO1T000IT7`03001T7f@O00=T7`03001oogoo00moo`8004]oo`00Agoo0P002Woo0`000Woo
00<007ooOol06Goo00<007m0Od000Wm01P000`?P100000T3l@?`0o43l0?a0o0000>o0ml00`>o00<3
g`000Ol01P7o01<0002O07l0W`1o09l0O`2O07l000`O41l<7a0O31l@7``O41l00003:1l01R@O:1lX
7bPO91l000Pd7`<00005O1el77`LO1al7@03O1`01G`M001h7gPOO1l00gPO00El7gPON1mh7`0000=L
7`80000@O1Yl6G`JO1Ul6W`I001P7f@OH1mT7f0O001P7f@OH1l200000g`O001oo`0AOol00`00Oomo
o`18Ool005Moo`8001aoo`03001o@7m0009o@004000gh3OP=n0400040n001`000o43l@?a0o03l@00
00L3_`030001o`7o00D1o`030000O`1o00D0O`03000@7a0O00L@7`03000X7bPO00DX7`03000d7c@O
00<d7`<0009l7003001l77`L00Ml7003001h7gPO00Uh7`<0000:O1Ul6W`IO1Yl6G`JO1Ul6W`I0005
I1l00`00I1l00003O1l00`00Oomoo`0@Ool00`00Oomoo`03Ool50010Ool005Moo`8001eoo`8000=o
@0@00003<n00000000<000090n0000?`0o43l0?a0o03l@000083_`050ml3_`>o0kl000070Ol05000
07l0W`1o09l0O`2O07l0W`0041l<7a0O31l@7``O41l<7`0091l3:1l01R@O:1lX7bPO000d7`<000El
7004001l77`LO1d3O1`01G`MO1al77`L00000gPO00Il7gPON1mh7g`ON1l200004G`JO1Ul6W`IO1Yl
6G`JO1Ul6W`IO1X006@OH1mT7f0OI1l00P0000Il7W`OO1il7g`N000AOol20006Ool00`00Oomoo`10
Ool005Moo`03001oogoo01eoo`D000Dgh0040003i`?W0nL600000`?a0o0000070kl00`000Ol1o`05
0Ol00`0007l0O`0507l00`0041l@7`0741l00`00:1lX7`02:1l50009O1`00`00O1al7007O1`00`00
N1mh7`05N1l20002O1803@00O1Yl6G`JO1Ul6W`IO1Yl6G`JO1Ul6P0000=T7`04001l7g`O0004O1l0
0`00Oomoo`0?Ool00`00Ool00005Ool00`00Oomoo`10Ool005Moo`8001ioo`H00006<n0gh3OP=n0c
h0000`?W00D3j0?W0003n`?l00L000040ml3_`>o00070Ol03P0009l0O`2O07l0W`1o09l0O`0031l@
7``O41l900001G`ON1ml7gPO00002G`L00D007`LO1al77`M00=l7005O1el77`L001l7`03N1l20000
4W`BO15l4W`A001l6G`JO1Ul6W`IO1Yl6G`JO1Ul6W`I001P7`80000:O1ml7W`O001l7g`NO1ml7W`O
000BOol00`00Oomoo`03Ool00`00Oomoo`10Ool005Moo`03001oogoo01Yoo`<0009oo`03001oH7mP
00<000<gh0030003i`?W00<3i`030003o0?l00@3o0030001o`8O01T000AL7`03001h7gPO00Ih7`03
001l77`L00Ql7003001l77`L00Ml7003001h7gPO008000Ml4P0=001l6G`JO1Ul6W`IO1Yl6G`JO1Ul
6W`I00001W`O00<007`OO1l00W`O00<007ooOol047oo0P0017oo00<007ooOol0@7oo000oOol20004
Ool20005Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`0GOol30006Ool01000Of1oP7mP1P0001@3
j0?W0nL3i`?X0003o0?k0o`3n`?l00027`7o0Ql1o`8O0Ol27`001`0O00X003@O<1ld7c0O=1l`7c@O
001P7`=L7`0>H1mL7e`OG1l007POO1mh7g`ON1ml7gPOO1l000Ul7003001l7G`L009l7005O1el77`L
O1al7@0300004g`BO15l4W`AO19l4G`BO15l4P00O1Yl6G`JO1Ul6W`IO1Yl6G`J0080000>O18007`N
O1ml7W`OO1il7`00O1ml7P00O1h000ioo`D000=oo`80049oo`00?Woo00@007ooOol000Yoo`05001o
ogooOol00002Ool00`00Oomoo`03000EOol3000:Ool20002Of0010009n0Wh2OP0`0010?W00<000?l
0o`00`?l00@0007o0Ol27`<1o`0300007`0O00D07`03000`7c@O008d7`04<1ld7c@O0008G1l00`00
N1mh7`06N1l00`00O1al7008O1`00`00O1al7004O1`20002O0h00`00O19l4P08O1801`00O1Yl6G`J
O1Ul6W`I008000=l4`03001l7g`O00El7`8000=l7`03001oogoo00Moo`@000Aoo`03001oogoo04Eo
o`00?Woo00@007ooOol000Yoo`03001oogoo00Aoo`04001oogoo000DOol3000>Ool300001WmP000W
h2_P9n0[h0H0000>0o/3o0?k0o`3n`?l00027`7o0Ql1o`8O0Ol000L07`0;000`7c@O<1ld7c0O=1l`
7`00G1mP7`03G1l03F0OG1mL7`00O1mh7g`ON1ml7gPOO1mh7`0000Ul7003001l77`M009l7080000D
O0el3W`=O0h007`BO15l4W`AO19l4G`BO15l4W`A001l6G`JO1Ul6P80000<O19l4g`BO1=l4W`C001l
7g`NO1ml7W`O0P0000Il7W`OO1il7g`N0005Ool30008Ool00`00Oomoo`15Ool003ioo`04001oogoo
000;Ool01000Oomoogoo0P000goo0P0047oo0`004Woo1@000bOP00<[h0000nd00P?]0`001@?l00@0
007o0Ol27`<1o`0300007`0O00@07`03000d7c0O00<d7`03<1ld7`0000QL7`03001h7gPO00Ih7`03
001l77`L00Ql7004001l70000007O0h00`00O19l4P08O1801000O1T000002G`C00D007`OO1ml7`00
009l7`03001l7g`O00=l7`03001oo`00008000]oo`03001oogoo04Eoo`00?Woo00@007ooOol000Qo
o`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool3000GOol00`00Oh000002000012_P
9n0[h0000`?]00<3k00000000`0000T3n`000Ol27`7o0Ql1o`8O00001`0O00T003@O<1ld7c0O=1l`
7c@O00000U`O011P7e`OG1mL7f0OG1l007POO1mh7g`ON1ml7gPOO1l000Ml70@0000CO0el3W`=O0il
3G`>O0el3W`=001l4G`BO15l4W`AO19l4G`BO1400`0000el4W`CO19l4g`BO1=l4W`CO19l4g`B001l
7P0200001g`OO1il7g`N001l7W`O00800003H1l007oo00ioo`03001oogoo04Aoo`00?goo0P002Goo
10000goo0`000Woo0P002Woo0`006goo0P0000=oP0000000100010?]00@000=O0gl3G`@00081o`04
0Ql1o`7o000601l01000=1ld7c0O0c@O00<`7`00G1l01e`O00<007PON1l01WPO00@007`LO1al70@0
00=l3P03001l3W`>00Ql3P03001l4W`B00Al4P800003O0Yl2`0000al4`03001l7g`O00Al7`03001l
7`0000AT7`03001oogoo00Yoo`<004Ioo`00EWoo00<007ooOol01goo0P007goo1@0000<Sh1oP0000
0P000P?]00L3k0000el3O`=O0gl3G`0500000`7o00007`0601l02@00<1ld7c0O=1l`7c@O<1l00003
G1l02V0OG1mL7e`OH1l007`ON1ml7gPO1`0001Ml3G`>O0el3W`=O0il3@00O0el3W`=O0il3G`>O0el
3W`=O0h007`BO15l4W`A0080000?O0]l2W`;O0Yl2`00O1=l4W`CO19l4g`BO1=l4W`C00800007O180
07`NO1ml7W`OO1h00P0000MT7f0OI1mP7f@OH1l00009Ool300000goo001oo`15Ool005Eoo`8000Io
o`<0029oo`D000038n0Oh2?P00<000050nd000=O0el3O`030el010000=l0g`3O1P000`0O00D003@O
=1ld7c0O00<d7`03001L7e`O00=L7`P0009l4P04O15l4W`B0009O0h00`00O0il3P08O0h03@00O180
0000O0Yl2g`:O0]l2W`;O0Yl2`0000Il4`8000Al4`05001l7g`OO1l00002I1l00`00I1mT7`02I1l0
1000<1l0000017oo1@000Woo00<007ooOol0A7oo001EOol00`00Oomoo`02Ool3000WOol00`00Oh00
0002000011oP8n0000?`0`0000d3O`=O0gl3G`=o0el0002o0=l0_`3O0;l00002:1lA00008G`JO1Ul
6W`I001l4G`BO15l4W`AO19l4G`B001l3W`=O0il3G`>O0el3W`=O0il3@00O0el3W`=O0il3G`>O0el
3P0300003g`;O0Yl2g`:O0]l2W`;O0Yl2g`:001l4W`CO19l4`02000027`BO1=l4W`CO19l4`00O1l2
00001V0OI1mP7f@O001T7`800004<1ld7c0O=1l80003Ool00`00Oomoo`14Ool005Eoo`D002]oo`80
0006Oh000000000Sh0000P?`0`0000D3G`=o0el3G`0000D0g`03000X7bPO00DX7`03001T7f@O00ET
7`04001l6G`IO1X3O1T00g`J001l4P02O1801g`AO19l4W`BO15l4P0000Yl3P03001l3W`>00=l3P80
009l1P0>001l2W`;O0Yl2g`:O0]l2W`;O0Yl2g`:001l4`8000Ul4`03001T7f@O00AT7`800004=1l`
7c@O<1l20000102O000000=O0P001Goo00<007ooOol0A7oo001>Ool50002Ool2000_Ool800000`?`
0nl3l00500002@=o0000g`2o0=l0_`3O000/7`03:1l00b`O:1l00007I1l08000O1Ul6W`IO1Yl6G`J
O1Ul6P00O19l4G`BO15l4W`AO19l4G`B001l3W`=O0il3G`>O0el3W`=O0h007`>O0d3000047`6O0Ml
1W`7O0H007`:O0]l2W`;O0Yl2g`:O0]l2W`;0P0000Ul4W`CO19l4g`BO1=l4W`CO1800P0000Ml6P00
I1mP7f@OH1mT7`020000230O=1l`7`0007l0W`000el20007Ool00`00Oomoo`14Ool0051oo`03001o
ogoo00=oo`03001oogoo02ioo`03001oH000008000047n00000000020o0010000]l2g`;o1000103O
00<002PO:1l012PO00<006@OI1l01F@O00D007`IO1Ul6G`J00=l6@03O1X007`B009l4P06O15l4W`B
O19l4@002G`>0`0000=l1W`7O0H00W`600al1g`6O0Il1P00O0Yl2g`:O0]l2W`;O0X200000g`;O0X0
0006O1<2000017`IO1Yl6G`J0P0000ET7`00000d7c0O00<0000307l00000008000Uoo`03001oogoo
04Aoo`00D7oo00<007ooOol017oo0P00;Woo00@007n0Of1oP08000037n0Sh000008000070o0000;o
0]l2o`;O0_l01P0000<X7b`O:1l00RPO00</7`00I1l01f@O01P007`IO1Yl6G`JO1Ul6W`I001l4G`B
O15l4W`AO19l4G`BO14007`=O0il3G`>O0d300004W`6O0L007`7O0Il1g`6O0Ml1W`7O0Il1`00O0]l
2W`;O0Yl2`800009O0Yl2g`:O0]l2P00O19l4g`B00800007O1Yl6G`JO1Ul6W`IO1X00`0000<d7c0O
00001P0037oo00<007ooOol0@goo001@Ool00`00Oomoo`06Ool00`00Oomoo`0/Ool00`00Of1oH002
Of0200000b?P0003l00300020]l00`;o0]l0000403l30005:1l00`00I1mT7`06I1l01@00O1Ul6G`I
O1X00g`I00<007`AO1800W`B00El4G`BO19l4P00009l3P<00003O0Il1g`6009l1P05001l1W`6O0Il
1`03O0H01W`7O0Il1P00O0]l2P800009O0]l2W`;O0Yl2g`:O0/007`C00800007O1Ul6W`IO1Yl6G`J
O1T00P000e`O1P003goo00<007ooOol0@goo001@Ool00`00Oomoo`07Ool00`00Oomoo`0/Ool20000
0gmPOh1oH00400000`?`0nl00002000010;O0_l2g`001@0o1@0000<X7`00I1l01f@O00h007`JO1Ul
6W`IO1Yl6G`J001l4W`AO19l4G`B1P0001=l1W`7O0Il1g`6O0Ml1W`7O0H007`6O0Ml1W`7O0Il1g`6
O0Ml1P0300004W`:O0]l2W`;O0Yl2g`:O0]l2W`;001l6W`IO1Yl6G`JO1Ul6P8000=L7`80000341l0
0000009oo`03001oogoo00eoo`03001oogoo04=oo`00Cgoo0P002Woo00<007ooOol0;7oo1P0000@W
h00000000083l0<000030_l2g`0000D0?`0400107d0O@1lH00001W`;O0Yl2g`:O0/0009l1P05O0Ml
1W`6O0Il1`03O0H01P00O0Il1W`6O0Ml1P<0009l1P09001l2g`:O0]l2W`;O0Yl2g`:00800006O180
0000O1Ul6W`I0P000e`O0P0000<@7`0000001Goo00<007ooOol037oo00<007ooOol0@goo001LOol2
000]Ool20002Od0300001B_P000000000o001@001P0o02h003`O@1ll7d0O?1l007`NO1ml7W`OO1il
7g`NO1l007`CO19l4g`BO1=l4W`C001l2g`:O0]l2W`;O0Yl2g`:O0/007`7O0Il1g`6O0Ml1W`7O0Il
1`00O0Ml1P<0000<O0Il1g`6O0Ml1W`7001l2g`:O0]l2W`;0P0000El4G`BO15l4W`A00<000=L7`80
000341l0000000Moo`03001oogoo00aoo`03001oogoo04=oo`00GWoo00<007ooOol0;7oo00@007m0
Od1o@0T000040]l00000000403l00`00@1m07`04@1l01000O1ml7g`N0g`O00El7P00O1=l4g`B00=l
4`0<O19l4`00O0]l2W`;O0Yl2g`:O0]l2P000g`600El1g`6O0Il1W`700@000=l1P05O0Ml1W`6O0Il
1`02O0H00`00O0]l2P020005O1820003N1l6000:Ool00`00Oomoo`0;Ool00`00Oomoo`13Ool005mo
o`03001oogoo02aoo`80009o@0D00083k@<000030_l0000000<0000V03l0040O?1m07c`O@1ll7`00
O1il7g`NO1ml7W`OO1h007`BO1=l4W`CO19l4g`BO1<007`;O0Yl2g`:O0]l2W`;O0X007`6O0Ml1P@0
000>O0Ml1W`7001l1g`6O0Ml1W`7O0Il1g`6O0Ml1P<00005O15l4W`AO19l4@020002N1l00g`ON1l0
0003000>Ool00`00Oomoo`0:Ool00`00Oomoo`13Ool0061oo`03001oogoo02aoo`H00004=n000000
00020nd5000203l60003@1l01000O1ml7g`N0g`O00El7P00O1=l4g`B00=l4`08O19l4`00O0]l2W`;
O0Yl2`H00003O0Il1g`6009l1P05O0Ml1W`6001l1`03O0H00g`7O0H000020002O0h20002O1820004
N1l4000AOol00`00Oomoo`09Ool00`00Oomoo`13Ool0065oo`8002eoo`04001o07lPO`0300000c?P
00000007000403l200000c`O0000000600002G`OO1il7`00O1=l4W`CO19l4`0900004W`;O0Yl2g`:
001l1W`7O0Il1g`6O0Ml1W`7O0Il1`00O0Ml1P<00006O0el3W`=O0il3G`>0`0000Al7gPON1mh7`<0
01Aoo`03001oogoo00Yoo`03001oogoo049oo`00Hgoo00<007ooOol0:goo00D007l0Ob1o07lP00D0
0083i`P00080?`8000A07`03001l7g`O00T000=l4`0<O19l4`00O0]l2W`;O0Yl2g`:O0]l2P000g`6
00El1g`6O0Il1W`700@000Ml3P8000=l70@001Qoo`03001oogoo00Uoo`03001oogoo049oo`00I7oo
00<007ooOol0:goo100000Ao8000001;h0<000030nL3j00000@000030=l0000000@00003?1m07c`O
00800005O1ml7W`OO1il7`0200005G`BO1=l4W`CO19l4g`BO1<007`;O0Yl2g`:O0]l2W`;O0X007`6
O0Ml1P0400000g`>O0el3P0200000g`=O0il3@030003O1`017`M000000006goo00<007ooOol027oo
00<007ooOol0@Woo001UOol00`00Oomoo`0[Ool00`00O^1nh00=000010?l000000000`3O1@0000A0
7`00O1ml7P=l7`05O1h00000O1=l4P03O1<027`BO1<007`;O0Yl2g`:O0/60008O0h40004O1`3000O
Ool00`00Oomoo`07Ool00`00Oomoo`12Ool006Ioo`03001oogoo02]oo`07001n`7kPO/1nh7k00000
0V?P40000RPO5`0000Al4W`AO19l4@800004O0il3G`>O0d40004O1`4000ROol00`00Oomoo`07Ool0
0`00Oomoo`12Ool006Moo`8002aoo`03001nh7kP00=nh08000ASh0D000030o40000000P00003:1l0
000000IT7`03001l6W`I009l6@03O1Yl6G`I00800006O15l4W`BO19l4G`B1P0017`L10009goo00<0
07ooOol01Woo00<007ooOol0@Woo001YOol00`00Oomoo`0ZOol;00001F?P000002_P9n002P0000<0
7`0000001P000V@O0P0000El6G`JO1Ul6W`I00P00004O1mh7g`ON1l6000/Ool00`00Oomoo`05Ool0
0`00Oomoo`12Ool006Yoo`03001oogoo02Yoo`03001nX7jP00AnX003001oh7oP024000AL7`P003=o
o`03001oogoo00Aoo`03001oogoo049oo`00Jgoo00<007ooOol0:Woo00L007jPO/1nX7k0OZ1n`002
000017_POn1kh7oP0P0000ECh5OPEn1Gh5?P00L00003Ln1gh00000<000Aoo`T003]oo`03001oogoo
00Eoo`03001oogoo045oo`00K7oo0P00:goo00<007jPOZ000WjP3P0000AoP7nPOj1oX0D004eoo`03
001oogoo00Aoo`03001oogoo045oo`00KWoo00<007ooOol0:Goo100000anX7j0OZ1nP000O`1o87l0
Ob1o07lPO`06001COol00`00Oomoo`03Ool00`00Oomoo`11Ool006moo`03001oogoo02Uoo`03001n
P7jP00=nP006OZ1nP000001o87l01000F7oo00<007ooOol00goo00<007ooOol0@Goo001`Ool00`00
Oomoo`0YOol02000OX1nX7j0OZ1nP7jPOX03001MOol00`00Oomoo`02Ool00`00Oomoo`11Ool0075o
o`8002Yoo`03001nP7jP00@0065oo`05001oogooOol00013Ool007=oo`03001oogoo02Qoo`8006Io
o`04001oogoo0013Ool007Aoo`03001oogoo02Qoo`03001oogoo06Aoo`04001oogoo0013Ool007Eo
o`03001oogoo02Moo`03001oogoo06Eoo`04001oogoo0012Ool007Ioo`8002Moo`03001oogoo06Io
o`03001oo`00049oo`00N7oo00<007ooOol097oo00<007ooOol0Igoo0P00@Woo001iOol00`00Oomo
o`0SOol00`00Oomoo`1WOol20012Ool007Yoo`03001oogoo025oo`03001oogoo06Qoo`80049oo`00
Ngoo0P008Goo00<007ooOol0I7oo1000A7oo001mOol00`00Oomoo`0NOol00`00Oomoo`1POol40018
Ool007ioo`03001oogoo01eoo`03001oogoo05aoo`@004aoo`00Ogoo00<007ooOol077oo00<007oo
Ool0F7oo1000D7oo0020Ool2000LOol00`00Oomoo`1DOol4001DOol0089oo`03001oogoo01Uoo`03
001oogoo051oo`@005Qoo`00Pgoo00<007ooOol067oo00<007ooOol0C7oo1000G7oo0024Ool00`00
Oomoo`0GOol00`00Oomoo`18Ool4001POol008Eoo`8001Moo`03001oogoo04Eoo`<006Aoo`00Qgoo
00<007ooOol057oo00<007ooOol0@Goo1000Igoo0028Ool00`00Oomoo`0COol00`00Oomoo`0mOol4
001[Ool008Uoo`03001oogoo019oo`03001oogoo03Uoo`@006moo`00RWoo00<007ooOol04Goo00<0
07ooOol0=Goo1000Lgoo002;Ool2000AOol00`00Oomoo`0aOol4001gOol008eoo`03001oogoo00io
o`03001oogoo02eoo`@007]oo`00SWoo00<007ooOol03Goo00<007ooOol0:Goo1000Ogoo002?Ool0
0`00Oomoo`0<Ool00`00Oomoo`0UOol40023Ool0091oo`8000aoo`03001oogoo025oo`@008Moo`00
TWoo00<007ooOol027oo00<007ooOol07goo0`00Rgoo002COol00`00Oomoo`07Ool00`00Oomoo`0K
Ool4002>Ool009Aoo`03001oogoo00Ioo`03001oogoo01Moo`@0099oo`00UGoo0P001Woo00<007oo
Ool04goo1000UWoo002GOol00`00Oomoo`03Ool00`00Oomoo`0?Ool4002JOol009Qoo`03001oogoo
009oo`03001oogoo00]oo`@009ioo`00VGoo00D007ooOomoo`0000Uoo`@00:9oo`00VWoo0P0000=o
o`00Ool017oo1000YWoo002LOol200000goo00000002002ZOol009eoo`800:ioo`00\
\>"],
  ImageRangeCache->{{{0, 332}, {157.625, 0}} -> {-0.452169, 0.00684964, \
0.00526931, 0.00526931}}]
}, Open  ]],

Cell[TextData[{
  "Superimposing both surfaces demonstrates that the two functions have the \
common point ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\((x\_0\),
            "TraditionalForm"], ",", \(y\_0\)}], TraditionalForm]]],
  ")=(\[Pi]/2, 0)."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[pl1, pl2, 
      PlotRange \[Rule] {{\(-2\), 2}, {\(-2\), 2}, {\(-1\), 1}}, 
      ViewPoint \[Rule] {3.130, \(-1.044\), 0.751}, Boxed \[Rule] False]\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53411 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0922957 1.0923 -0.233922 1.0923 [
[.66323 .54776 -5.89295 0 ]
[.66323 .54776 6.10705 9 ]
[.73187 .52455 -5.85757 0 ]
[.73187 .52455 6.14243 9 ]
[.8096 .49827 -2.90867 0 ]
[.8096 .49827 3.09133 9 ]
[.89835 .46826 -2.88559 0 ]
[.89835 .46826 3.11441 9 ]
[1.00064 .43367 -2.85884 0 ]
[1.00064 .43367 3.14116 9 ]
[.81168 .56651 -4.84778 0 ]
[.81168 .56651 5.15222 12.875 ]
[.15994 -0.01365 -5.84217 -9 ]
[.15994 -0.01365 6.15783 0 ]
[.3824 .01059 -5.96172 -9 ]
[.3824 .01059 6.03828 0 ]
[.5933 .03357 -3.03728 -9 ]
[.5933 .03357 2.96272 0 ]
[.79351 .0554 -3.09063 -9 ]
[.79351 .0554 2.90937 0 ]
[.98382 .07614 -3.14116 -9 ]
[.98382 .07614 2.85884 0 ]
[.59245 -0.03469 -5.06214 -12.875 ]
[.59245 -0.03469 4.93786 0 ]
[.99803 .09126 0 -4.01021 ]
[.99803 .09126 12 4.98979 ]
[1.00185 .1719 0 -4.05835 ]
[1.00185 .1719 24 4.94165 ]
[1.00572 .25371 0 -4.10724 ]
[1.00572 .25371 6 4.89276 ]
[1.00964 .33671 0 -4.15688 ]
[1.00964 .33671 18 4.84312 ]
[1.01362 .42092 0 -4.20731 ]
[1.01362 .42092 6 4.79269 ]
[1.07373 .25965 0 -5.87563 ]
[1.07373 .25965 10 6.99937 ]
[ 0 0 0 0 ]
[ 1 .53411 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.66298 .53411 m
1 .42004 L
s
.66298 .53411 m
.66286 .52729 L
s
[(-2)] .66323 .54776 -0.01784 -1 Mshowa
.73155 .5109 m
.73138 .50408 L
s
[(-1)] .73187 .52455 -0.02374 -1 Mshowa
.80918 .48462 m
.80898 .4778 L
s
[(0)] .8096 .49827 -0.03044 -1 Mshowa
.89783 .45462 m
.89757 .4478 L
s
[(1)] .89835 .46826 -0.03814 -1 Mshowa
1 .42004 m
.99968 .41322 L
s
[(2)] 1.00064 .43367 -0.04705 -1 Mshowa
.125 Mabswid
.67605 .52969 m
.67597 .52559 L
s
.68942 .52516 m
.68934 .52107 L
s
.70312 .52052 m
.70304 .51643 L
s
.71716 .51577 m
.71707 .51168 L
s
.74629 .50591 m
.74619 .50182 L
s
.76141 .50079 m
.76131 .4967 L
s
.77693 .49554 m
.77681 .49145 L
s
.79285 .49015 m
.79273 .48606 L
s
.82596 .47894 m
.82583 .47485 L
s
.8432 .47311 m
.84306 .46902 L
s
.86091 .46712 m
.86076 .46302 L
s
.87911 .46096 m
.87896 .45686 L
s
.91709 .4481 m
.91693 .44401 L
s
.93691 .44139 m
.93674 .4373 L
s
.95732 .43448 m
.95714 .43039 L
s
.97834 .42737 m
.97815 .42328 L
s
gsave
.81168 .56651 -65.8478 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.15958 0 m
.98446 .08978 L
s
.15958 0 m
.1594 .00682 L
s
[(-2)] .15994 -0.01365 -0.0263 1 Mshowa
.38232 .02424 m
.38227 .03107 L
s
[(-1)] .3824 .01059 -0.00638 1 Mshowa
.59347 .04723 m
.59356 .05405 L
s
[(0)] .5933 .03357 .01243 1 Mshowa
.79392 .06904 m
.79413 .07587 L
s
[(1)] .79351 .0554 .03021 1 Mshowa
.98446 .08978 m
.98478 .0966 L
s
[(2)] .98382 .07614 .04705 1 Mshowa
.125 Mabswid
.2051 .00495 m
.20501 .00905 L
s
.25012 .00986 m
.25005 .01395 L
s
.29466 .0147 m
.2946 .0188 L
s
.33872 .0195 m
.33868 .02359 L
s
.42544 .02894 m
.42543 .03303 L
s
.46812 .03358 m
.46812 .03768 L
s
.51034 .03818 m
.51036 .04227 L
s
.55212 .04273 m
.55216 .04682 L
s
.63439 .05168 m
.63446 .05577 L
s
.67489 .05609 m
.67497 .06018 L
s
.71497 .06045 m
.71507 .06455 L
s
.75465 .06477 m
.75476 .06886 L
s
.8328 .07327 m
.83294 .07737 L
s
.87128 .07746 m
.87144 .08156 L
s
.90939 .08161 m
.90955 .0857 L
s
.94711 .08572 m
.94729 .08981 L
s
gsave
.59245 -0.03469 -66.0621 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.98446 .08978 m
1 .42004 L
s
.98446 .08978 m
.97767 .08904 L
s
[(-1)] .99803 .09126 -1 -0.10884 Mshowa
.98826 .17057 m
.98147 .1699 L
s
[(-0.5)] 1.00185 .1719 -1 -0.09814 Mshowa
.99212 .25253 m
.98532 .25193 L
s
[(0)] 1.00572 .25371 -1 -0.08728 Mshowa
.99603 .33567 m
.98922 .33515 L
s
[(0.5)] 1.00964 .33671 -1 -0.07625 Mshowa
1 .42004 m
.99319 .41959 L
s
[(1)] 1.01362 .42092 -1 -0.06504 Mshowa
.125 Mabswid
.98522 .10585 m
.98114 .10541 L
s
.98597 .12196 m
.9819 .12153 L
s
.98674 .13812 m
.98266 .1377 L
s
.9875 .15432 m
.98342 .15391 L
s
.98903 .18687 m
.98495 .18648 L
s
.9898 .20321 m
.98572 .20283 L
s
.99057 .2196 m
.98649 .21923 L
s
.99134 .23604 m
.98726 .23567 L
s
.9929 .26906 m
.98881 .26871 L
s
.99368 .28564 m
.98959 .2853 L
s
.99446 .30227 m
.99038 .30194 L
s
.99524 .31895 m
.99116 .31863 L
s
.99682 .35245 m
.99273 .35214 L
s
.99761 .36927 m
.99353 .36898 L
s
.99841 .38614 m
.99432 .38586 L
s
.9992 .40306 m
.99511 .40279 L
s
gsave
1.07373 .25965 -61 -9.87563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .53411 L
0 .53411 L
closepath
clip
newpath
.5 Mabswid
.66478 .44904 m .66148 .44984 L p .64292 .42438 L .309 .562 .926 r
F P
0 g
s
.66148 .44984 m .62997 .42789 L .64292 .42438 L p .309 .562 .926 r
F P
0 g
s
.64292 .42438 m .62997 .42789 L .60276 .40419 L p .423 .58 .904 r
F P
0 g
s
.64292 .42438 m .67485 .44968 L .66478 .44904 L p .309 .562 .926 r
F P
0 g
s
.57246 .36295 m .64292 .42438 L p .60276 .40419 L .423 .58 .904 r
F P
0 g
s
.60276 .40419 m .56036 .37171 L .57246 .36295 L p .423 .58 .904 r
F P
0 g
s
.57246 .36295 m .56036 .37171 L .53294 .35 L p .503 .614 .895 r
F P
0 g
s
.50147 .30665 m .57246 .36295 L p .53294 .35 L .503 .614 .895 r
F P
0 g
s
.53294 .35 m .49016 .32018 L .50147 .30665 L p .503 .614 .895 r
F P
0 g
s
.50147 .30665 m .49016 .32018 L .4625 .30439 L p .573 .667 .902 r
F P
0 g
s
.68699 .445 m .67485 .44968 L p .66486 .41516 L .36 .554 .907 r
F P
0 g
s
.67485 .44968 m .64292 .42438 L .66486 .41516 L p .36 .554 .907 r
F P
0 g
s
.42981 .26564 m .50147 .30665 L p .4625 .30439 L .573 .667 .902 r
F P
0 g
s
.4625 .30439 m .41926 .28253 L .42981 .26564 L p .573 .667 .902 r
F P
0 g
s
.59304 .35132 m .66486 .41516 L .64292 .42438 L p .37 .54 .892 r
F P
0 g
s
.64292 .42438 m .57246 .36295 L .59304 .35132 L p .37 .54 .892 r
F P
0 g
s
.42981 .26564 m .41926 .28253 L .39122 .27543 L p .64 .742 .923 r
F P
0 g
s
.52069 .29283 m .59304 .35132 L .57246 .36295 L p .392 .565 .904 r
F P
0 g
s
.57246 .36295 m .50147 .30665 L .52069 .29283 L p .392 .565 .904 r
F P
0 g
s
.35712 .24708 m .42981 .26564 L p .39122 .27543 L .64 .742 .923 r
F P
0 g
s
.39122 .27543 m .3473 .26532 L .35712 .24708 L p .64 .742 .923 r
F P
0 g
s
.44768 .2502 m .52069 .29283 L .50147 .30665 L p .434 .634 .939 r
F P
0 g
s
.50147 .30665 m .42981 .26564 L .44768 .2502 L p .434 .634 .939 r
F P
0 g
s
.66486 .41516 m .69739 .44145 L .68699 .445 L p .36 .554 .907 r
F P
0 g
s
.35712 .24708 m .3473 .26532 L .3187 .26803 L p .703 .84 .948 r
F P
0 g
s
.37365 .23088 m .44768 .2502 L .42981 .26564 L p .5 .751 .985 r
F P
0 g
s
.42981 .26564 m .35712 .24708 L .37365 .23088 L p .5 .751 .985 r
F P
0 g
s
.28288 .25395 m .35712 .24708 L p .3187 .26803 L .703 .84 .948 r
F P
0 g
s
.3187 .26803 m .27383 .27127 L .28288 .25395 L p .703 .84 .948 r
F P
0 g
s
.70999 .43476 m .69739 .44145 L p .68763 .40218 L .404 .565 .9 r
F P
0 g
s
.69739 .44145 m .66486 .41516 L .68763 .40218 L p .404 .565 .9 r
F P
0 g
s
.61451 .3426 m .68763 .40218 L .66486 .41516 L p .321 .518 .893 r
F P
0 g
s
.66486 .41516 m .59304 .35132 L .61451 .3426 L p .321 .518 .893 r
F P
0 g
s
.28288 .25395 m .27383 .27127 L .24449 .28309 L p .731 .942 .953 r
F P
0 g
s
.29805 .23798 m .37365 .23088 L .35712 .24708 L p .57 .884 .991 r
F P
0 g
s
.35712 .24708 m .28288 .25395 L .29805 .23798 L p .57 .884 .991 r
F P
0 g
s
.54077 .2879 m .61451 .3426 L .59304 .35132 L p .232 .502 .903 r
F P
0 g
s
.59304 .35132 m .52069 .29283 L .54077 .2879 L p .232 .502 .903 r
F P
0 g
s
.20661 .28449 m .28288 .25395 L p .24449 .28309 L .731 .942 .953 r
F P
0 g
s
.24449 .28309 m .19839 .29877 L .20661 .28449 L p .731 .942 .953 r
F P
0 g
s
.46631 .24784 m .54077 .2879 L .52069 .29283 L p .141 .528 .919 r
F P
0 g
s
.52069 .29283 m .44768 .2502 L .46631 .24784 L p .141 .528 .919 r
F P
0 g
s
.68763 .40218 m .72073 .42672 L .70999 .43476 L p .404 .565 .9 r
F P
0 g
s
.22035 .26968 m .29805 .23798 L .28288 .25395 L p .591 .947 .896 r
F P
0 g
s
.28288 .25395 m .20661 .28449 L .22035 .26968 L p .591 .947 .896 r
F P
0 g
s
.20661 .28449 m .19839 .29877 L .16818 .31722 L p .647 .969 .866 r
F P
0 g
s
.39078 .22934 m .46631 .24784 L .44768 .2502 L p .081 .597 .883 r
F P
0 g
s
.44768 .2502 m .37365 .23088 L .3867 .22971 L p .081 .597 .883 r
F P
0 g
s
.44768 .2502 m .3867 .22971 L .40094 .23306 L .081 .597 .883 r
F
.46631 .24784 m .48581 .25811 L p .51946 .27635 L 0 .242 .631 r
F P
0 g
s
.54077 .2879 m .51246 .27266 L p .51946 .27635 L 0 .242 .631 r
F P
0 g
s
.51246 .27266 m .46631 .24784 L p .51946 .27635 L 0 .242 .631 r
F P
0 g
s
.56182 .29154 m .63695 .33664 L .61451 .3426 L p 0 .407 .853 r
F P
0 g
s
.61451 .3426 m .54077 .2879 L .56182 .29154 L p 0 .407 .853 r
F P
0 g
s
.48581 .25811 m .56182 .29154 L .54077 .2879 L p 0 .242 .631 r
F P
0 g
s
.56182 .29154 m .58393 .30242 L p .63296 .33406 L 0 .265 .683 r
F P
0 g
s
.63695 .33664 m .63356 .3346 L p .63296 .33406 L 0 .265 .683 r
F P
0 g
s
.63356 .3346 m .56182 .29154 L p .63296 .33406 L 0 .265 .683 r
F P
0 g
s
.58393 .30242 m .66043 .33292 L .63695 .33664 L p 0 .265 .683 r
F P
0 g
s
.66043 .33292 m .58393 .30242 L .60719 .31828 L p .469 0 0 r
F P
0 g
s
.68502 .33061 m .66043 .33292 L p .61903 .32153 L .469 0 0 r
F P
0 g
s
.60719 .31828 m .61717 .31986 L p .61903 .32153 L .469 0 0 r
F P
0 g
s
.61717 .31986 m .68502 .33061 L p .61903 .32153 L .469 0 0 r
F P
0 g
s
.58393 .30242 m .56182 .29154 L p .53842 .28632 L .612 .045 0 r
F P
0 g
s
.5063 .27915 m .54929 .29203 L p .53842 .28632 L .612 .045 0 r
F P
0 g
s
.54929 .29203 m .58393 .30242 L p .53842 .28632 L .612 .045 0 r
F P
0 g
s
.40864 .24196 m .48581 .25811 L .46846 .24896 L p .454 0 0 r
F P
0 g
s
.46846 .24896 m .46631 .24784 L p .46165 .24736 L .454 0 0 r
F P
0 g
s
.46165 .24736 m .40864 .24196 L .46846 .24896 L .454 0 0 r
F
.3867 .22971 m .39078 .22934 L p .40094 .23306 L .081 .597 .883 r
F P
0 g
s
.12795 .33239 m .20661 .28449 L p .16818 .31722 L .647 .969 .866 r
F P
0 g
s
.16818 .31722 m .12069 .34202 L .12795 .33239 L p .647 .969 .866 r
F P
0 g
s
.7338 .41804 m .72073 .42672 L p .71128 .38553 L .446 .593 .904 r
F P
0 g
s
.72073 .42672 m .68763 .40218 L .71128 .38553 L p .446 .593 .904 r
F P
0 g
s
.63695 .33664 m .71128 .38553 L .68763 .40218 L p .274 .518 .905 r
F P
0 g
s
.68763 .40218 m .61451 .3426 L .63695 .33664 L p .274 .518 .905 r
F P
0 g
s
.31368 .2353 m .39078 .22934 L .37365 .23088 L p .12 .671 .751 r
F P
0 g
s
.37365 .23088 m .29805 .23798 L .31368 .2353 L p .12 .671 .751 r
F P
0 g
s
.14018 .31945 m .22035 .26968 L .20661 .28449 L p .56 .924 .76 r
F P
0 g
s
.20661 .28449 m .12795 .33239 L .14018 .31945 L p .56 .924 .76 r
F P
0 g
s
.12795 .33239 m .12069 .34202 L .08956 .36327 L p .399 .821 .645 r
F P
0 g
s
.71128 .38553 m .74488 .40568 L .7338 .41804 L p .446 .593 .904 r
F P
0 g
s
.04683 .3877 m .12795 .33239 L p .08956 .36327 L .399 .821 .645 r
F P
0 g
s
.08956 .36327 m .04066 .39195 L .04683 .3877 L p .399 .821 .645 r
F P
0 g
s
.2345 .26405 m .31368 .2353 L .29805 .23798 L p 0 0 0 r
F P
0 g
s
.29805 .23798 m .22035 .26968 L .2345 .26405 L p 0 0 0 r
F P
0 g
s
.46631 .24784 m .39078 .22934 L .40864 .24196 L p .454 0 0 r
F P
0 g
s
.75845 .39525 m .74488 .40568 L p .73586 .36568 L .489 .638 .921 r
F P
0 g
s
.74488 .40568 m .71128 .38553 L .73586 .36568 L p .489 .638 .921 r
F P
0 g
s
.05745 .37697 m .14018 .31945 L .12795 .33239 L p .52 .889 .686 r
F P
0 g
s
.12795 .33239 m .04683 .3877 L .05745 .37697 L p .52 .889 .686 r
F P
0 g
s
.04066 .39195 m .00873 .41143 L p .00912 .4107 L 0 0 0 r
F P
0 g
s
.00912 .4107 m .04683 .3877 L .04066 .39195 L p 0 0 0 r
F P
0 g
s
.66043 .33292 m .73586 .36568 L .71128 .38553 L p .226 .543 .927 r
F P
0 g
s
.71128 .38553 m .63695 .33664 L .66043 .33292 L p .226 .543 .927 r
F P
0 g
s
.32989 .24547 m .40864 .24196 L .39078 .22934 L p .355 0 0 r
F P
0 g
s
.39078 .22934 m .31368 .2353 L .32989 .24547 L p .355 0 0 r
F P
0 g
s
.22035 .26968 m .16195 .30594 L p .15286 .30951 L .447 .85 .663 r
F P
0 g
s
.16195 .30594 m .14018 .31945 L .15286 .30951 L p .447 .85 .663 r
F P
0 g
s
.08049 .34323 m .14329 .31328 L p .15286 .30951 L .687 .98 .837 r
F P
0 g
s
.15286 .30951 m .2345 .26405 L .22035 .26968 L p .447 .85 .663 r
F P
0 g
s
.2345 .26405 m .16154 .30468 L p .16603 .30243 L 0 0 0 r
F P
0 g
s
.16154 .30468 m .15286 .30951 L .16603 .30243 L p 0 0 0 r
F P
0 g
s
.16603 .30243 m .24913 .26726 L .2345 .26405 L p 0 0 0 r
F P
0 g
s
.09293 .32078 m .17074 .30007 L p .16603 .30243 L .713 .978 .913 r
F P
0 g
s
.24913 .26726 m .16993 .30078 L p .17976 .29767 L 0 0 0 r
F P
0 g
s
.16993 .30078 m .16603 .30243 L .17976 .29767 L p 0 0 0 r
F P
0 g
s
.17976 .29767 m .26435 .27797 L .24913 .26726 L p 0 0 0 r
F P
0 g
s
.10601 .29562 m .19007 .29441 L p .17976 .29767 L .69 .935 .966 r
F P
0 g
s
.26435 .27797 m .18064 .29747 L p .19412 .29435 L 0 0 0 r
F P
0 g
s
.18064 .29747 m .17976 .29767 L .19412 .29435 L p 0 0 0 r
F P
0 g
s
.19412 .29435 m .28028 .29386 L .26435 .27797 L p 0 0 0 r
F P
0 g
s
.1197 .26883 m .20828 .29107 L p .19412 .29435 L .625 .857 .986 r
F P
0 g
s
.20828 .29107 m .20919 .2913 L .19412 .29435 L p .625 .857 .986 r
F P
0 g
s
.19007 .29441 m .19412 .29435 L .17976 .29767 L p .69 .935 .966 r
F P
0 g
s
.17074 .30007 m .17976 .29767 L .16603 .30243 L p .713 .978 .913 r
F P
0 g
s
.14329 .31328 m .16603 .30243 L .15286 .30951 L p .687 .98 .837 r
F P
0 g
s
.00873 .41143 m .00343 .41421 L .00401 .41426 L p 0 0 0 r
F P
0 g
s
.00401 .41426 m .00912 .4107 L p .00873 .41143 L 0 0 0 r
F P
0 g
s
.73586 .36568 m .76989 .37924 L .75845 .39525 L p .489 .638 .921 r
F P
0 g
s
.56182 .29154 m .48581 .25811 L .5063 .27915 L p .612 .045 0 r
F P
0 g
s
.01355 .40655 m .01896 .4009 L p .04683 .3877 L .484 .877 .701 r
F P
0 g
s
.01896 .4009 m .05745 .37697 L .04683 .3877 L p .484 .877 .701 r
F P
0 g
s
.04683 .3877 m .00912 .4107 L .01355 .40655 L p .484 .877 .701 r
F P
0 g
s
.24913 .26726 m .32989 .24547 L .31368 .2353 L p .087 0 0 r
F P
0 g
s
.31368 .2353 m .2345 .26405 L .24913 .26726 L p .087 0 0 r
F P
0 g
s
.78401 .36745 m .76989 .37924 L p .76145 .34342 L .536 .704 .948 r
F P
0 g
s
.76989 .37924 m .73586 .36568 L .76145 .34342 L p .536 .704 .948 r
F P
0 g
s
.42736 .26671 m .5063 .27915 L .48581 .25811 L p .639 .128 .015 r
F P
0 g
s
.48581 .25811 m .40864 .24196 L .42736 .26671 L p .639 .128 .015 r
F P
0 g
s
.06866 .36211 m .15286 .30951 L .14018 .31945 L p .619 .946 .755 r
F P
0 g
s
.14018 .31945 m .05745 .37697 L .06866 .36211 L p .619 .946 .755 r
F P
0 g
s
.68502 .33061 m .76145 .34342 L .73586 .36568 L p .175 .593 .939 r
F P
0 g
s
.73586 .36568 m .66043 .33292 L .68502 .33061 L p .175 .593 .939 r
F P
0 g
s
.3468 .2666 m .42736 .26671 L .40864 .24196 L p .545 .051 .034 r
F P
0 g
s
.40864 .24196 m .32989 .24547 L .3468 .2666 L p .545 .051 .034 r
F P
0 g
s
.76145 .34342 m .79585 .34887 L .78401 .36745 L p .536 .704 .948 r
F P
0 g
s
.02376 .39191 m .02949 .38397 L p .05745 .37697 L .725 .989 .861 r
F P
0 g
s
.02949 .38397 m .06866 .36211 L .05745 .37697 L p .725 .989 .861 r
F P
0 g
s
.05745 .37697 m .01896 .4009 L .02376 .39191 L p .725 .989 .861 r
F P
0 g
s
.52789 .30776 m .60719 .31828 L .58393 .30242 L p .675 .165 .022 r
F P
0 g
s
.58393 .30242 m .5063 .27915 L .52789 .30776 L p .675 .165 .022 r
F P
0 g
s
.81054 .33627 m .79585 .34887 L p .78811 .3198 L .583 .792 .979 r
F P
0 g
s
.79585 .34887 m .76145 .34342 L .78811 .3198 L p .583 .792 .979 r
F P
0 g
s
.26435 .27797 m .3468 .2666 L .32989 .24547 L p .307 0 0 r
F P
0 g
s
.32989 .24547 m .24913 .26726 L .26435 .27797 L p .307 0 0 r
F P
0 g
s
.15286 .30951 m .06866 .36211 L .08049 .34323 L p .687 .98 .837 r
F P
0 g
s
.71078 .3286 m .78811 .3198 L .76145 .34342 L p .119 .643 .88 r
F P
0 g
s
.76145 .34342 m .68665 .33088 L p .71078 .3286 L .119 .643 .88 r
F P
0 g
s
.65735 .35251 m .73609 .32621 L p .71078 .3286 L .446 0 0 r
F P
0 g
s
.73609 .32621 m .73776 .32565 L .71078 .3286 L p .446 0 0 r
F P
0 g
s
.68665 .33088 m .68502 .33061 L .71078 .3286 L p .119 .643 .88 r
F P
0 g
s
.44705 .30002 m .52789 .30776 L .5063 .27915 L p .679 .221 .156 r
F P
0 g
s
.5063 .27915 m .42736 .26671 L .44705 .30002 L p .679 .221 .156 r
F P
0 g
s
.78811 .3198 m .82285 .3165 L .81054 .33627 L p .583 .792 .979 r
F P
0 g
s
.63165 .33613 m .71078 .3286 L .68502 .33061 L p .506 0 0 r
F P
0 g
s
.68502 .33061 m .60719 .31828 L .63165 .33613 L p .506 0 0 r
F P
0 g
s
.36455 .29546 m .44705 .30002 L .42736 .26671 L p .616 .154 .133 r
F P
0 g
s
.42736 .26671 m .3468 .2666 L .36455 .29546 L p .616 .154 .133 r
F P
0 g
s
.03466 .37032 m .04071 .36009 L p .06866 .36211 L .804 .97 .907 r
F P
0 g
s
.04071 .36009 m .08049 .34323 L .06866 .36211 L p .804 .97 .907 r
F P
0 g
s
.06866 .36211 m .02949 .38397 L .03466 .37032 L p .804 .97 .907 r
F P
0 g
s
.83818 .30371 m .82285 .3165 L p .81598 .29597 L .615 .89 .989 r
F P
0 g
s
.82285 .3165 m .78811 .3198 L .81598 .29597 L p .615 .89 .989 r
F P
0 g
s
.55066 .33964 m .63165 .33613 L .60719 .31828 L p .657 .184 .117 r
F P
0 g
s
.60719 .31828 m .52789 .30776 L .55066 .33964 L p .657 .184 .117 r
F P
0 g
s
.78811 .3198 m .71562 .32805 L p .73776 .32565 L 0 0 0 r
F P
0 g
s
.71562 .32805 m .71078 .3286 L .73776 .32565 L p 0 0 0 r
F P
0 g
s
.68432 .36384 m .76104 .32313 L p .73776 .32565 L .327 0 0 r
F P
0 g
s
.73776 .32565 m .81598 .29597 L .78811 .3198 L p 0 0 0 r
F P
0 g
s
.76104 .32313 m .76603 .32048 L .73776 .32565 L p .327 0 0 r
F P
0 g
s
.28028 .29386 m .36455 .29546 L .3468 .2666 L p .429 0 0 r
F P
0 g
s
.3468 .2666 m .26435 .27797 L .28028 .29386 L p .429 0 0 r
F P
0 g
s
.16603 .30243 m .08049 .34323 L .09293 .32078 L p .713 .978 .913 r
F P
0 g
s
.81598 .29597 m .85104 .28429 L .83818 .30371 L p .615 .89 .989 r
F P
0 g
s
.46784 .33711 m .55066 .33964 L .52789 .30776 L p .676 .235 .196 r
F P
0 g
s
.52789 .30776 m .44705 .30002 L .46784 .33711 L p .676 .235 .196 r
F P
0 g
s
.71078 .3286 m .63165 .33613 L .65735 .35251 L p .446 0 0 r
F P
0 g
s
.04623 .34247 m .05261 .33019 L p .08049 .34323 L .805 .914 .913 r
F P
0 g
s
.05261 .33019 m .09293 .32078 L .08049 .34323 L p .805 .914 .913 r
F P
0 g
s
.08049 .34323 m .04071 .36009 L .04623 .34247 L p .805 .914 .913 r
F P
0 g
s
.86708 .27191 m .85104 .28429 L p .84517 .27311 L .585 .941 .918 r
F P
0 g
s
.85104 .28429 m .81598 .29597 L .84517 .27311 L p .585 .941 .918 r
F P
0 g
s
.38327 .32767 m .46784 .33711 L .44705 .30002 L p .641 .18 .143 r
F P
0 g
s
.44705 .30002 m .36455 .29546 L .38327 .32767 L p .641 .18 .143 r
F P
0 g
s
.81598 .29597 m .73776 .32565 L .76603 .32048 L p 0 0 0 r
F P
0 g
s
.76603 .32048 m .84517 .27311 L .81598 .29597 L p 0 0 0 r
F P
0 g
s
.57466 .36976 m .65735 .35251 L .63165 .33613 L p .599 .137 .127 r
F P
0 g
s
.63165 .33613 m .55066 .33964 L .57466 .36976 L p .599 .137 .127 r
F P
0 g
s
.17976 .29767 m .09293 .32078 L .10601 .29562 L p .69 .935 .966 r
F P
0 g
s
.29703 .31181 m .38327 .32767 L .36455 .29546 L p .487 0 0 r
F P
0 g
s
.36455 .29546 m .28028 .29386 L .29703 .31181 L p .487 0 0 r
F P
0 g
s
.84517 .27311 m .88059 .25435 L .86708 .27191 L p .585 .941 .918 r
F P
0 g
s
.48981 .37236 m .57466 .36976 L .55066 .33964 L p .644 .193 .166 r
F P
0 g
s
.55066 .33964 m .46784 .33711 L .48981 .37236 L p .644 .193 .166 r
F P
0 g
s
.73776 .32565 m .65735 .35251 L .68432 .36384 L p .327 0 0 r
F P
0 g
s
.05843 .30974 m .06515 .29585 L p .09293 .32078 L .774 .855 .911 r
F P
0 g
s
.06515 .29585 m .10601 .29562 L .09293 .32078 L p .774 .855 .911 r
F P
0 g
s
.09293 .32078 m .05261 .33019 L .05843 .30974 L p .774 .855 .911 r
F P
0 g
s
.89741 .24296 m .88059 .25435 L p .87583 .25224 L .462 .874 .73 r
F P
0 g
s
.88059 .25435 m .84517 .27311 L .87583 .25224 L p .462 .874 .73 r
F P
0 g
s
.19412 .29435 m .20919 .2913 L p .2726 .29358 L .111 .662 .797 r
F P
0 g
s
.28028 .29386 m .27513 .29389 L p .2726 .29358 L .111 .662 .797 r
F P
0 g
s
.27513 .29389 m .19412 .29435 L p .2726 .29358 L .111 .662 .797 r
F P
0 g
s
.20919 .2913 m .29703 .31181 L .28028 .29386 L p .111 .662 .797 r
F P
0 g
s
.20919 .2913 m .22505 .2872 L p .27802 .30531 L .097 .614 .885 r
F P
0 g
s
.29703 .31181 m .28256 .30844 L p .27802 .30531 L .097 .614 .885 r
F P
0 g
s
.28256 .30844 m .20919 .2913 L p .27802 .30531 L .097 .614 .885 r
F P
0 g
s
.31474 .32825 m .29703 .31181 L p .22801 .28821 L .097 .614 .885 r
F P
0 g
s
.31474 .32825 m .40307 .35811 L .38327 .32767 L p .48 0 0 r
F P
0 g
s
.38327 .32767 m .29703 .31181 L .31474 .32825 L p .48 0 0 r
F P
0 g
s
.31474 .32825 m .33351 .33942 L p .35931 .34636 L .363 0 0 r
F P
0 g
s
.40307 .35811 m .34213 .33751 L p .35931 .34636 L .363 0 0 r
F P
0 g
s
.34213 .33751 m .31474 .32825 L p .35931 .34636 L .363 0 0 r
F P
0 g
s
.42404 .38143 m .51301 .39989 L .48981 .37236 L p .562 .014 0 r
F P
0 g
s
.48981 .37236 m .40307 .35811 L .42404 .38143 L p .562 .014 0 r
F P
0 g
s
.33351 .33942 m .42404 .38143 L .40307 .35811 L p .363 0 0 r
F P
0 g
s
.51301 .39989 m .42404 .38143 L .44483 .39195 L p .328 0 0 r
F P
0 g
s
.44483 .39195 m .44623 .39267 L p .44968 .39304 L .328 0 0 r
F P
0 g
s
.51301 .39989 m .44483 .39195 L .44968 .39304 L .328 0 0 r
F
.51301 .39989 m .59991 .3929 L .57466 .36976 L p .567 .077 .052 r
F P
0 g
s
.57466 .36976 m .48981 .37236 L .51301 .39989 L p .567 .077 .052 r
F P
0 g
s
.53745 .41422 m .6264 .40419 L .59991 .3929 L p .371 0 0 r
F P
0 g
s
.59991 .3929 m .51301 .39989 L .53745 .41422 L p .371 0 0 r
F P
0 g
s
.44623 .39267 m .53745 .41422 L .51301 .39989 L p .328 0 0 r
F P
0 g
s
.53857 .40604 m .56716 .40478 L .55896 .39636 L p .547 .045 .015 r
F P
0 g
s
.55896 .39636 m .5306 .39731 L .53857 .40604 L p .547 .045 .015 r
F P
0 g
s
.50973 .40113 m .53857 .40604 L .5306 .39731 L p .576 .034 0 r
F P
0 g
s
.5306 .39731 m .502 .39269 L .50973 .40113 L p .576 .034 0 r
F P
0 g
s
.48068 .39014 m .50973 .40113 L .502 .39269 L p .568 0 0 r
F P
0 g
s
.54666 .41142 m .57364 .41003 L p .56716 .40478 L .41 0 0 r
F P
0 g
s
.6264 .40419 m .71254 .36685 L .68432 .36384 L p .299 0 0 r
F P
0 g
s
.68432 .36384 m .59991 .3929 L .6264 .40419 L p .299 0 0 r
F P
0 g
s
.71254 .36685 m .6264 .40419 L .6541 .39981 L p 0 0 0 r
F P
0 g
s
.62132 .40083 m .6126 .40321 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.6541 .39981 m .6264 .40419 L p .59861 .40719 L .088 .646 .711 r
F P
0 g
s
.60019 .40682 m .6541 .39981 L .59861 .40719 L .088 .646 .711 r
F
.60363 .40603 m .62132 .40083 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.6126 .40321 m .60397 .40205 L p .59145 .40796 L .151 0 0 r
F P
0 g
s
.59145 .40796 m .59146 .40796 L .6126 .40321 L .151 0 0 r
F
.59801 .40725 m .60019 .40682 L .59861 .40719 L .088 .646 .711 r
F
.59135 .40797 m .59977 .40688 L .59801 .40725 L F
.59977 .40688 m .60019 .40682 L .59801 .40725 L F
.6126 .40321 m .60043 .40674 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.59145 .40796 m .6541 .39981 L .59135 .40797 L .088 .646 .711 r
F
.62456 .40345 m .62938 .40286 L p .59145 .40796 L F P
0 g
s
.62938 .40286 m .6541 .39981 L p .59145 .40796 L .088 .646 .711 r
F P
0 g
s
.6264 .40419 m .55392 .41236 L p .55884 .41179 L .088 .646 .711 r
F P
0 g
s
.57067 .41038 m .57233 .41019 L .53984 .41392 L .088 .646 .711 r
F
.57233 .41019 m .6264 .40419 L .55446 .41228 L F
.57233 .41019 m .55446 .41228 L .53984 .41392 L F
.60397 .40205 m .57615 .40975 L p .57761 .40958 L .151 0 0 r
F P
0 g
s
.57606 .40976 m .61204 .40574 L .57563 .40981 L .088 .646 .711 r
F
.59135 .40797 m .59617 .40745 L .57606 .40976 L F
.59617 .40745 m .61204 .40574 L .57606 .40976 L F
.59545 .39755 m .56716 .40478 L .57532 .40984 L p .371 0 0 r
F P
0 g
s
.60397 .40205 m .57761 .40958 L .59145 .40796 L .151 0 0 r
F
.61204 .40574 m .6264 .40419 L .57233 .41019 L .088 .646 .711 r
F
.61204 .40574 m .57233 .41019 L .57563 .40981 L F
.57761 .40958 m .576 .41004 L .59135 .40797 L .151 0 0 r
F
.57761 .40958 m .59135 .40797 L .59145 .40796 L F
.57514 .40986 m .57233 .41019 L .57364 .41003 L .088 .646 .711 r
F
.57547 .40993 m .57364 .41003 L p .55486 .41315 L .158 0 0 r
F P
0 g
s
.57364 .41003 m .54666 .41142 L .55157 .41246 L p .158 0 0 r
F P
0 g
s
.57364 .41003 m .57233 .41019 L .55204 .41244 L .088 .646 .711 r
F
.55201 .41245 m .55204 .41244 L .54881 .4128 L F
.57364 .41003 m .55204 .41244 L .55201 .41245 L F
.56716 .40478 m .53857 .40604 L .54666 .41142 L p .41 0 0 r
F P
0 g
s
.54666 .41142 m .53857 .40604 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.52342 .40733 m .54666 .41142 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.48829 .39464 m .51485 .40521 L p .50973 .40113 L .38 0 0 r
F P
0 g
s
.51706 .40595 m .50973 .40113 L p .51485 .40521 L .38 0 0 r
F P
0 g
s
.53857 .40604 m .50973 .40113 L .51706 .40595 L p .42 0 0 r
F P
0 g
s
.53857 .40604 m .51706 .40595 L .51861 .40629 L .42 0 0 r
F
.50973 .40113 m .48068 .39014 L .48742 .39412 L p .38 0 0 r
F P
0 g
s
.48742 .39412 m .48829 .39464 L p .49019 .39521 L .38 0 0 r
F P
0 g
s
.50973 .40113 m .48742 .39412 L .49019 .39521 L .38 0 0 r
F
.49603 .39575 m .50674 .40015 L p .51118 .40288 L 0 .453 .799 r
F P
0 g
s
.54666 .41142 m .52342 .40733 L p .53929 .41018 L .138 0 0 r
F P
0 g
s
.48829 .39464 m .49603 .39575 L p .51346 .40428 L 0 .453 .799 r
F P
0 g
s
.52497 .40761 m .51571 .40567 L .51346 .40428 L .131 .634 .905 r
F
.52394 .40742 m .51571 .40567 L .52497 .40761 L F
.54193 .41366 m .51514 .40555 L .52521 .40769 L F
.51485 .40521 m .51758 .4063 L .51706 .40595 L p .38 0 0 r
F P
0 g
s
.51758 .4063 m .51485 .40521 L p .51346 .40428 L 0 .453 .799 r
F P
0 g
s
.51485 .40521 m .48829 .39464 L p .51346 .40428 L 0 .453 .799 r
F P
0 g
s
.51094 .4026 m .51346 .40428 L .51042 .40241 L .131 .634 .905 r
F
.52497 .40761 m .51346 .40428 L .51094 .4026 L F
.52521 .40769 m .52394 .40742 L .52497 .40761 L F
.52212 .40766 m .528 .41055 L .51514 .40555 L F
.55157 .41246 m .54874 .41281 L p .52451 .40744 L F P
0 g
s
.54874 .41281 m .54193 .41366 L p .52538 .40775 L .131 .634 .905 r
F P
0 g
s
.54874 .41281 m .52538 .40775 L .52451 .40744 L .131 .634 .905 r
F
.51758 .4063 m .52556 .40787 L p .53929 .41018 L .138 0 0 r
F P
0 g
s
.52342 .40733 m .51758 .4063 L p .53929 .41018 L .138 0 0 r
F P
0 g
s
.51706 .40595 m .51758 .4063 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.51758 .4063 m .52342 .40733 L p .51861 .40629 L .42 0 0 r
F P
0 g
s
.5145 .40479 m .51346 .40428 L .51907 .40659 L 0 .453 .799 r
F
.51346 .40428 m .49603 .39575 L .51118 .40288 L F
.51346 .40428 m .51118 .40288 L .51907 .40659 L F
.59545 .39755 m .57532 .40984 L .57568 .4098 L .371 0 0 r
F
.60397 .40205 m .59545 .39755 L p .57568 .4098 L F P
0 g
s
.57615 .40975 m .60397 .40205 L p .57568 .4098 L .371 0 0 r
F P
0 g
s
.57532 .40984 m .56716 .40478 L p .57364 .41003 L .41 0 0 r
F P
0 g
s
.56296 .41098 m .55157 .41246 L .51151 .40043 L .131 .634 .905 r
F
.56296 .41098 m .51151 .40043 L .51471 .40056 L F
.51541 .40059 m .51471 .40056 L .51536 .40058 L F
.56296 .41098 m .51471 .40056 L .51541 .40059 L F
.49603 .39575 m .50389 .39327 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.50674 .40015 m .49603 .39575 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.50389 .39327 m .52217 .40085 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.51536 .40058 m .51151 .40043 L .50309 .3979 L .131 .634 .905 r
F
.54666 .41142 m .53929 .41018 L .54909 .412 L .138 0 0 r
F
.55157 .41246 m .54666 .41142 L p .55109 .41247 L F P
0 g
s
.502 .39269 m .4732 .38255 L .48068 .39014 L p .568 0 0 r
F P
0 g
s
.45147 .3734 m .48068 .39014 L .4732 .38255 L p .5 0 0 r
F P
0 g
s
.45883 .37681 m .48829 .39464 L .48068 .39014 L p 0 .267 .673 r
F P
0 g
s
.4732 .38255 m .502 .39269 L .4944 .38135 L p .661 .134 0 r
F P
0 g
s
.4944 .38135 m .46584 .37225 L .4732 .38255 L p .661 .134 0 r
F P
0 g
s
.44423 .36723 m .4732 .38255 L .46584 .37225 L p .628 .065 0 r
F P
0 g
s
.4732 .38255 m .44423 .36723 L .45147 .3734 L p .5 0 0 r
F P
0 g
s
.46633 .3772 m .49603 .39575 L .48829 .39464 L p 0 .431 .848 r
F P
0 g
s
.48829 .39464 m .45883 .37681 L .46633 .3772 L p 0 .431 .848 r
F P
0 g
s
.55157 .41246 m .52451 .40744 L .46968 .38787 L .131 .634 .905 r
F
.52556 .40787 m .50674 .40015 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.53365 .40562 m .52556 .40787 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.54881 .4128 m .56276 .41106 L p .59135 .40797 L .088 .646 .711 r
F P
0 g
s
.56312 .41102 m .59135 .40797 L .56276 .41106 L .088 .646 .711 r
F
.5632 .41101 m .59135 .40797 L .56304 .41103 L F
.56321 .41101 m .56321 .41101 L .5632 .41101 L F
.56321 .41101 m .59135 .40797 L .5632 .41101 L F
.60043 .40674 m .6126 .40321 L p .59146 .40796 L .151 0 0 r
F P
0 g
s
.6126 .40321 m .64095 .38873 L .63213 .38826 L p .127 0 0 r
F P
0 g
s
.63213 .38826 m .60397 .40205 L .6126 .40321 L p .127 0 0 r
F P
0 g
s
.64095 .38873 m .6126 .40321 L .62132 .40083 L p 0 0 0 r
F P
0 g
s
.62132 .40083 m .60363 .40603 L p .60103 .40318 L .485 .9 .884 r
F P
0 g
s
.56321 .41101 m .60374 .40602 L .59135 .40797 L .088 .646 .711 r
F
.60374 .40602 m .60383 .40601 L .59135 .40797 L F
.56356 .41096 m .60388 .406 L p .56321 .41101 L F P
0 g
s
.59944 .40702 m .60043 .40674 L p .59144 .40796 L .151 0 0 r
F P
0 g
s
.59144 .40796 m .60043 .40674 L .59146 .40796 L .151 0 0 r
F
.60388 .406 m .62456 .40345 L p .60043 .40674 L .088 .646 .711 r
F P
0 g
s
.60388 .406 m .60043 .40674 L .59135 .40797 L .088 .646 .711 r
F
.58389 .41153 m .59241 .40932 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.60043 .40674 m .58389 .41153 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.59241 .40932 m .60363 .40603 L p .60222 .40635 L 0 0 0 r
F P
0 g
s
.58389 .41153 m .59944 .40702 L p .59144 .40796 L .151 0 0 r
F P
0 g
s
.60363 .40603 m .59241 .40932 L .59588 .40685 L p .485 .9 .884 r
F P
0 g
s
.59588 .40685 m .60103 .40318 L p .60363 .40603 L .485 .9 .884 r
F P
0 g
s
.60374 .40602 m .60388 .406 L .60383 .40601 L .088 .646 .711 r
F
.5633 .411 m .56311 .41102 L .56317 .41099 L .195 .723 .831 r
F
.56321 .41101 m .56356 .41096 L .56321 .41101 L .088 .646 .711 r
F
.56331 .411 m .56321 .41101 L .5633 .411 L .195 .723 .831 r
F
.56321 .41101 m .56311 .41102 L .5633 .411 L F
.56312 .41102 m .5633 .411 L p .56321 .41101 L .088 .646 .711 r
F P
0 g
s
.5633 .411 m .56356 .41096 L p .56321 .41101 L .088 .646 .711 r
F P
0 g
s
.57159 .4048 m .60103 .40318 L .59588 .40685 L p .481 .864 .978 r
F P
0 g
s
.59588 .40685 m .59514 .40738 L p .59333 .40718 L .481 .864 .978 r
F P
0 g
s
.59333 .40718 m .57159 .4048 L .59588 .40685 L .481 .864 .978 r
F
.59135 .40797 m .57563 .40981 L .54881 .4128 L .088 .646 .711 r
F
.576 .41004 m .58389 .41153 L p .59144 .40796 L .151 0 0 r
F P
0 g
s
.59145 .40796 m .59135 .40797 L .59144 .40796 L .151 0 0 r
F
.59135 .40797 m .576 .41004 L .59144 .40796 L F
.59145 .40796 m .59144 .40796 L .59146 .40796 L F
.59514 .40738 m .59241 .40932 L p .58747 .40825 L .481 .864 .978 r
F P
0 g
s
.58747 .40825 m .57159 .4048 L .59514 .40738 L .481 .864 .978 r
F
.53984 .41392 m .54881 .4128 L p .57067 .41038 L .088 .646 .711 r
F P
0 g
s
.57364 .41003 m .56256 .41125 L .56008 .41228 L .158 0 0 r
F
.53745 .41422 m .53984 .41392 L p .55884 .41179 L .088 .646 .711 r
F P
0 g
s
.55392 .41236 m .53745 .41422 L p .55884 .41179 L .088 .646 .711 r
F P
0 g
s
.56256 .41125 m .55157 .41246 L .56008 .41228 L .158 0 0 r
F
.55157 .41246 m .55486 .41315 L p .56008 .41228 L F P
0 g
s
.55486 .41315 m .58389 .41153 L .57547 .40993 L p .158 0 0 r
F P
0 g
s
.56304 .41103 m .56317 .41099 L p .55849 .41295 L .195 .723 .831 r
F P
0 g
s
.40307 .35811 m .48981 .37236 L .46784 .33711 L p .632 .143 .073 r
F P
0 g
s
.46584 .37225 m .4944 .38135 L .48693 .36756 L p .701 .219 .1 r
F P
0 g
s
.502 .39269 m .5306 .39731 L .52276 .38564 L p .651 .162 .078 r
F P
0 g
s
.52276 .38564 m .4944 .38135 L .502 .39269 L p .651 .162 .078 r
F P
0 g
s
.47396 .37436 m .50389 .39327 L .49603 .39575 L p .184 .538 .926 r
F P
0 g
s
.56312 .41102 m .50309 .3979 L .5025 .39754 L .131 .634 .905 r
F
.49831 .39496 m .52165 .40074 L p .5025 .39754 L F P
0 g
s
.50389 .39327 m .51187 .38706 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52195 .40082 m .56312 .41102 L p .50397 .39786 L .131 .634 .905 r
F P
0 g
s
.53365 .40562 m .52217 .40085 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52217 .40085 m .50389 .39327 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52165 .40074 m .52195 .40082 L p .5025 .39754 L .131 .634 .905 r
F P
0 g
s
.50397 .39786 m .5025 .39754 L .52195 .40082 L .131 .634 .905 r
F
.5306 .39731 m .55896 .39636 L .55088 .38506 L p .621 .164 .146 r
F P
0 g
s
.55088 .38506 m .52276 .38564 L .5306 .39731 L p .621 .164 .146 r
F P
0 g
s
.51187 .38706 m .54185 .3994 L .53674 .40327 L p .39 .683 .976 r
F P
0 g
s
.53674 .40327 m .53365 .40562 L p .52947 .40205 L .39 .683 .976 r
F P
0 g
s
.52947 .40205 m .51187 .38706 L .53674 .40327 L .39 .683 .976 r
F
.52217 .40085 m .53365 .40562 L p .51471 .40056 L .194 .613 .946 r
F P
0 g
s
.56289 .41094 m .56317 .41099 L .56304 .41103 L p .201 .687 .928 r
F P
0 g
s
.56308 .41101 m .56302 .41102 L .56296 .41098 L .131 .634 .905 r
F
.56302 .41102 m .55157 .41246 L .56296 .41098 L F
.56304 .41103 m .55157 .41246 L p .56308 .41101 L F P
0 g
s
.53365 .40562 m .56289 .41094 L p .55486 .41315 L .201 .687 .928 r
F P
0 g
s
.56276 .41106 m .56304 .41103 L p .56312 .41102 L .088 .646 .711 r
F P
0 g
s
.56304 .41103 m .55486 .41315 L p .56289 .41094 L .201 .687 .928 r
F P
0 g
s
.52556 .40787 m .53365 .40562 L p .55248 .41231 L .201 .687 .928 r
F P
0 g
s
.55109 .41247 m .55486 .41315 L .55157 .41246 L p .138 0 0 r
F P
0 g
s
.55486 .41315 m .55109 .41247 L p .55248 .41231 L .201 .687 .928 r
F P
0 g
s
.52556 .40787 m .55109 .41247 L p .54909 .412 L .138 0 0 r
F P
0 g
s
.53929 .41018 m .52556 .40787 L .54909 .412 L .138 0 0 r
F
.55109 .41247 m .52556 .40787 L p .55248 .41231 L .201 .687 .928 r
F P
0 g
s
.56304 .41103 m .56312 .41102 L p .56321 .41101 L .088 .646 .711 r
F P
0 g
s
.58389 .41153 m .55849 .41295 L p .56311 .41102 L .195 .723 .831 r
F P
0 g
s
.58389 .41153 m .56311 .41102 L .56331 .411 L .195 .723 .831 r
F
.55849 .41295 m .55486 .41315 L .56304 .41103 L p F P
0 g
s
.56312 .41102 m .56304 .41103 L p .56308 .41101 L .131 .634 .905 r
F P
0 g
s
.49603 .39575 m .46633 .3772 L .47396 .37436 L p .184 .538 .926 r
F P
0 g
s
.46968 .38787 m .49831 .39496 L p .50309 .3979 L .131 .634 .905 r
F P
0 g
s
.51042 .40241 m .51514 .40555 L .46968 .38787 L .131 .634 .905 r
F
.51571 .40567 m .51514 .40555 L .51042 .40241 L F
.52556 .40787 m .51907 .40659 L p .51118 .40288 L 0 .453 .799 r
F P
0 g
s
.50674 .40015 m .52556 .40787 L p .51118 .40288 L 0 .453 .799 r
F P
0 g
s
.51907 .40659 m .51758 .4063 L p .5145 .40479 L 0 .453 .799 r
F P
0 g
s
.54193 .41366 m .53597 .41233 L .52212 .40766 L .131 .634 .905 r
F
.53597 .41233 m .528 .41055 L .52212 .40766 L F
.57563 .40981 m .57514 .40986 L .57364 .41003 L .088 .646 .711 r
F
.57532 .40984 m .57547 .40993 L p .57568 .4098 L .371 0 0 r
F P
0 g
s
.57547 .40993 m .576 .41004 L p .57761 .40958 L .151 0 0 r
F P
0 g
s
.57615 .40975 m .57547 .40993 L p .57761 .40958 L .151 0 0 r
F P
0 g
s
.57547 .40993 m .57615 .40975 L p .57568 .4098 L .371 0 0 r
F P
0 g
s
.57364 .41003 m .57547 .40993 L .57532 .40984 L p .41 0 0 r
F P
0 g
s
.54193 .41366 m .53745 .41422 L p .528 .41055 L .131 .634 .905 r
F P
0 g
s
.44623 .39267 m .42404 .38143 L p .38518 .35968 L 0 .425 .798 r
F P
0 g
s
.35341 .3419 m .39803 .3663 L p .38518 .35968 L 0 .425 .798 r
F P
0 g
s
.39803 .3663 m .44623 .39267 L p .38518 .35968 L 0 .425 .798 r
F P
0 g
s
.33351 .33942 m .31474 .32825 L p .24907 .28541 L .116 .558 .918 r
F P
0 g
s
.2418 .28067 m .24726 .28417 L p .24907 .28541 L .116 .558 .918 r
F P
0 g
s
.24726 .28417 m .33351 .33942 L p .24907 .28541 L .116 .558 .918 r
F P
0 g
s
.22505 .2872 m .227 .28809 L p .22801 .28821 L .097 .614 .885 r
F P
0 g
s
.227 .28809 m .31474 .32825 L p .22801 .28821 L .097 .614 .885 r
F P
0 g
s
.64465 .31474 m .65289 .31617 L p .66898 .31868 L .123 0 0 r
F P
0 g
s
.6706 .31894 m .66931 .31873 L p .66898 .31868 L .123 0 0 r
F P
0 g
s
.66931 .31873 m .64465 .31474 L p .66898 .31868 L .123 0 0 r
F P
0 g
s
.65289 .31617 m .67892 .31507 L .6706 .31894 L p .123 0 0 r
F P
0 g
s
.67892 .31507 m .65289 .31617 L .66127 .31788 L p .183 0 0 r
F P
0 g
s
.68737 .31166 m .67892 .31507 L p .66207 .31775 L .183 0 0 r
F P
0 g
s
.66127 .31788 m .6619 .31773 L p .66207 .31775 L .183 0 0 r
F P
0 g
s
.6619 .31773 m .68737 .31166 L p .66207 .31775 L .183 0 0 r
F P
0 g
s
.62669 .31773 m .65289 .31617 L .64465 .31474 L p .513 0 0 r
F P
0 g
s
.64465 .31474 m .61856 .31146 L .62669 .31773 L p .513 0 0 r
F P
0 g
s
.79562 .31193 m .87583 .25224 L .84517 .27311 L p 0 0 0 r
F P
0 g
s
.84517 .27311 m .76603 .32048 L .79562 .31193 L p 0 0 0 r
F P
0 g
s
.46784 .33711 m .38327 .32767 L .40307 .35811 L p .632 .143 .073 r
F P
0 g
s
.60029 .31932 m .62669 .31773 L .61856 .31146 L p .644 .167 .107 r
F P
0 g
s
.61856 .31146 m .5923 .30882 L .60029 .31932 L p .644 .167 .107 r
F P
0 g
s
.5737 .32054 m .60029 .31932 L .5923 .30882 L p .69 .266 .236 r
F P
0 g
s
.5923 .30882 m .56588 .30658 L .5737 .32054 L p .69 .266 .236 r
F P
0 g
s
.59991 .3929 m .68432 .36384 L .65735 .35251 L p .495 .021 .06 r
F P
0 g
s
.65735 .35251 m .57466 .36976 L .59991 .3929 L p .495 .021 .06 r
F P
0 g
s
.19412 .29435 m .10601 .29562 L .1197 .26883 L p .625 .857 .986 r
F P
0 g
s
.63496 .32411 m .66127 .31788 L .65289 .31617 L p .492 0 0 r
F P
0 g
s
.65289 .31617 m .62669 .31773 L .63496 .32411 L p .492 0 0 r
F P
0 g
s
.87583 .25224 m .91168 .22859 L .89741 .24296 L p .462 .874 .73 r
F P
0 g
s
.5469 .32109 m .5737 .32054 L .56588 .30658 L p .71 .316 .3 r
F P
0 g
s
.56588 .30658 m .53928 .30455 L .5469 .32109 L p .71 .316 .3 r
F P
0 g
s
.60842 .32979 m .63496 .32411 L .62669 .31773 L p .608 .156 .153 r
F P
0 g
s
.62669 .31773 m .60029 .31932 L .60842 .32979 L p .608 .156 .153 r
F P
0 g
s
.66979 .31959 m .69596 .30855 L .68737 .31166 L p .199 0 0 r
F P
0 g
s
.68737 .31166 m .66127 .31788 L .66979 .31959 L p .199 0 0 r
F P
0 g
s
.51991 .32072 m .5469 .32109 L .53928 .30455 L p .719 .34 .33 r
F P
0 g
s
.53928 .30455 m .51251 .30257 L .51991 .32072 L p .719 .34 .33 r
F P
0 g
s
.58165 .33437 m .60842 .32979 L .60029 .31932 L p .66 .249 .254 r
F P
0 g
s
.60029 .31932 m .5737 .32054 L .58165 .33437 L p .66 .249 .254 r
F P
0 g
s
.64336 .33026 m .66979 .31959 L .66127 .31788 L p .451 0 .014 r
F P
0 g
s
.66127 .31788 m .63496 .32411 L .64336 .33026 L p .451 0 .014 r
F P
0 g
s
.49272 .31928 m .51991 .32072 L .51251 .30257 L p .722 .347 .339 r
F P
0 g
s
.51251 .30257 m .48555 .30056 L .49272 .31928 L p .722 .347 .339 r
F P
0 g
s
.71254 .36685 m .79562 .31193 L .76603 .32048 L p .153 0 0 r
F P
0 g
s
.76603 .32048 m .68432 .36384 L .71254 .36685 L p .153 0 0 r
F P
0 g
s
.07124 .27405 m .07828 .25915 L p .10601 .29562 L .724 .799 .911 r
F P
0 g
s
.07828 .25915 m .1197 .26883 L .10601 .29562 L p .724 .799 .911 r
F P
0 g
s
.10601 .29562 m .06515 .29585 L .07124 .27405 L p .724 .799 .911 r
F P
0 g
s
.92938 .21861 m .91168 .22859 L p .90811 .23413 L 0 0 0 r
F P
0 g
s
.91168 .22859 m .87583 .25224 L .90811 .23413 L p 0 0 0 r
F P
0 g
s
.55466 .33742 m .58165 .33437 L .5737 .32054 L p .688 .299 .305 r
F P
0 g
s
.5737 .32054 m .5469 .32109 L .55466 .33742 L p .688 .299 .305 r
F P
0 g
s
.67843 .32107 m .70469 .30557 L .69596 .30855 L p .186 0 0 r
F P
0 g
s
.69596 .30855 m .66979 .31959 L .67843 .32107 L p .186 0 0 r
F P
0 g
s
.46534 .31671 m .49272 .31928 L .48555 .30056 L p .719 .34 .33 r
F P
0 g
s
.48555 .30056 m .45841 .29847 L .46534 .31671 L p .719 .34 .33 r
F P
0 g
s
.61669 .3398 m .64336 .33026 L .63496 .32411 L p .565 .131 .176 r
F P
0 g
s
.63496 .32411 m .60842 .32979 L .61669 .3398 L p .565 .131 .176 r
F P
0 g
s
.52745 .33862 m .55466 .33742 L .5469 .32109 L p .705 .326 .328 r
F P
0 g
s
.5469 .32109 m .51991 .32072 L .52745 .33862 L p .705 .326 .328 r
F P
0 g
s
.43778 .31304 m .46534 .31671 L .45841 .29847 L p .71 .316 .299 r
F P
0 g
s
.45841 .29847 m .43109 .29635 L .43778 .31304 L p .71 .316 .299 r
F P
0 g
s
.6519 .33582 m .67843 .32107 L .66979 .31959 L p .401 0 .051 r
F P
0 g
s
.66979 .31959 m .64336 .33026 L .6519 .33582 L p .401 0 .051 r
F P
0 g
s
.58975 .34757 m .61669 .3398 L .60842 .32979 L p .624 .221 .258 r
F P
0 g
s
.60842 .32979 m .58165 .33437 L .58975 .34757 L p .624 .221 .258 r
F P
0 g
s
.8266 .29908 m .90811 .23413 L .87583 .25224 L p 0 0 0 r
F P
0 g
s
.87583 .25224 m .79562 .31193 L .8266 .29908 L p 0 0 0 r
F P
0 g
s
.50002 .33773 m .52745 .33862 L .51991 .32072 L p .715 .337 .331 r
F P
0 g
s
.51991 .32072 m .49272 .31928 L .50002 .33773 L p .715 .337 .331 r
F P
0 g
s
.41004 .30842 m .43778 .31304 L .43109 .29635 L p .688 .266 .238 r
F P
0 g
s
.43109 .29635 m .40358 .29428 L .41004 .30842 L p .688 .266 .238 r
F P
0 g
s
.68722 .32206 m .71356 .30258 L .70469 .30557 L p .156 0 0 r
F P
0 g
s
.70469 .30557 m .67843 .32107 L .68722 .32206 L p .156 0 0 r
F P
0 g
s
.56256 .353 m .58975 .34757 L .58165 .33437 L p .661 .273 .299 r
F P
0 g
s
.58165 .33437 m .55466 .33742 L .56256 .353 L p .661 .273 .299 r
F P
0 g
s
.62508 .34894 m .6519 .33582 L .64336 .33026 L p .514 .093 .18 r
F P
0 g
s
.64336 .33026 m .61669 .3398 L .62508 .34894 L p .514 .093 .18 r
F P
0 g
s
.4724 .33469 m .50002 .33773 L .49272 .31928 L p .72 .333 .316 r
F P
0 g
s
.49272 .31928 m .46534 .31671 L .4724 .33469 L p .72 .333 .316 r
F P
0 g
s
.38212 .30306 m .41004 .30842 L .40358 .29428 L p .637 .166 .119 r
F P
0 g
s
.40358 .29428 m .37588 .29242 L .38212 .30306 L p .637 .166 .119 r
F P
0 g
s
.90811 .23413 m .94452 .20841 L .92938 .21861 L p 0 0 0 r
F P
0 g
s
.53512 .35568 m .56256 .353 L .55466 .33742 L p .686 .303 .315 r
F P
0 g
s
.55466 .33742 m .52745 .33862 L .53512 .35568 L p .686 .303 .315 r
F P
0 g
s
.13402 .24167 m .22505 .2872 L .20919 .2913 L p .535 .76 .98 r
F P
0 g
s
.20919 .2913 m .1197 .26883 L .13402 .24167 L p .535 .76 .98 r
F P
0 g
s
.66057 .34047 m .68722 .32206 L .67843 .32107 L p .342 0 .064 r
F P
0 g
s
.67843 .32107 m .6519 .33582 L .66057 .34047 L p .342 0 .064 r
F P
0 g
s
.44459 .32952 m .4724 .33469 L .46534 .31671 L p .718 .313 .279 r
F P
0 g
s
.46534 .31671 m .43778 .31304 L .44459 .32952 L p .718 .313 .279 r
F P
0 g
s
.59798 .35965 m .62508 .34894 L .61669 .3398 L p .582 .181 .247 r
F P
0 g
s
.61669 .3398 m .58975 .34757 L .59798 .35965 L p .582 .181 .247 r
F P
0 g
s
.35403 .29729 m .38212 .30306 L .37588 .29242 L p .503 0 0 r
F P
0 g
s
.37588 .29242 m .34799 .29099 L .35403 .29729 L p .503 0 0 r
F P
0 g
s
.69613 .32235 m .72256 .29943 L .71356 .30258 L p .117 0 0 r
F P
0 g
s
.71356 .30258 m .68722 .32206 L .69613 .32235 L p .117 0 0 r
F P
0 g
s
.50746 .35532 m .53512 .35568 L .52745 .33862 L p .704 .317 .312 r
F P
0 g
s
.52745 .33862 m .50002 .33773 L .50746 .35532 L p .704 .317 .312 r
F P
0 g
s
.41661 .32242 m .44459 .32952 L .43778 .31304 L p .704 .266 .208 r
F P
0 g
s
.43778 .31304 m .41004 .30842 L .41661 .32242 L p .704 .266 .208 r
F P
0 g
s
.32576 .29151 m .35403 .29729 L .34799 .29099 L p .136 0 0 r
F P
0 g
s
.34799 .29099 m .32064 .29024 L p .32576 .29151 L .136 0 0 r
F P
0 g
s
.35403 .29729 m .32576 .29151 L .33174 .29307 L p .176 0 0 r
F P
0 g
s
.30313 .28234 m .33098 .29279 L p .32576 .29151 L .325 .739 .978 r
F P
0 g
s
.33098 .29279 m .33174 .29307 L .32576 .29151 L p .325 .739 .978 r
F P
0 g
s
.32064 .29024 m .31989 .29022 L .32576 .29151 L p .136 0 0 r
F P
0 g
s
.63361 .35681 m .66057 .34047 L .6519 .33582 L p .455 .042 .167 r
F P
0 g
s
.6519 .33582 m .62508 .34894 L .63361 .35681 L p .455 .042 .167 r
F P
0 g
s
.57059 .36729 m .59798 .35965 L .58975 .34757 L p .628 .235 .28 r
F P
0 g
s
.58975 .34757 m .56256 .353 L .57059 .36729 L p .628 .235 .28 r
F P
0 g
s
.4796 .35183 m .50746 .35532 L .50002 .33773 L p .716 .317 .29 r
F P
0 g
s
.50002 .33773 m .4724 .33469 L .4796 .35183 L p .716 .317 .29 r
F P
0 g
s
.38848 .31368 m .41661 .32242 L .41004 .30842 L p .661 .17 .072 r
F P
0 g
s
.41004 .30842 m .38212 .30306 L .38848 .31368 L p .661 .17 .072 r
F P
0 g
s
.31989 .29022 m .29158 .29043 L .29731 .28615 L p .405 .825 .968 r
F P
0 g
s
.29731 .28615 m .32576 .29151 L .31989 .29022 L p .405 .825 .968 r
F P
0 g
s
.66937 .34393 m .69613 .32235 L .68722 .32206 L p .275 0 .058 r
F P
0 g
s
.68722 .32206 m .66057 .34047 L .66937 .34393 L p .275 0 .058 r
F P
0 g
s
.54294 .37134 m .57059 .36729 L .56256 .353 L p .662 .268 .29 r
F P
0 g
s
.56256 .353 m .53512 .35568 L .54294 .37134 L p .662 .268 .29 r
F P
0 g
s
.0846 .23763 m .09196 .2224 L p .1197 .26883 L .659 .744 .913 r
F P
0 g
s
.09196 .2224 m .13402 .24167 L .1197 .26883 L p .659 .744 .913 r
F P
0 g
s
.1197 .26883 m .07828 .25915 L .0846 .23763 L p .659 .744 .913 r
F P
0 g
s
.60634 .37017 m .63361 .35681 L .62508 .34894 L p .53 .127 .221 r
F P
0 g
s
.62508 .34894 m .59798 .35965 L .60634 .37017 L p .53 .127 .221 r
F P
0 g
s
.742 .35895 m .8266 .29908 L .79562 .31193 L p 0 0 0 r
F P
0 g
s
.79562 .31193 m .71254 .36685 L .742 .35895 L p 0 0 0 r
F P
0 g
s
.36018 .30372 m .38848 .31368 L .38212 .30306 L p .533 0 0 r
F P
0 g
s
.38212 .30306 m .35403 .29729 L .36018 .30372 L p .533 0 0 r
F P
0 g
s
.45154 .34524 m .4796 .35183 L .4724 .33469 L p .721 .299 .243 r
F P
0 g
s
.4724 .33469 m .44459 .32952 L .45154 .34524 L p .721 .299 .243 r
F P
0 g
s
.70517 .32174 m .7317 .29601 L .72256 .29943 L p .07 0 0 r
F P
0 g
s
.72256 .29943 m .69613 .32235 L .70517 .32174 L p .07 0 0 r
F P
0 g
s
.51504 .37148 m .54294 .37134 L .53512 .35568 L p .688 .286 .279 r
F P
0 g
s
.53512 .35568 m .50746 .35532 L .51504 .37148 L p .688 .286 .279 r
F P
0 g
s
.33174 .29307 m .36018 .30372 L .35403 .29729 L p .176 0 0 r
F P
0 g
s
.42332 .33578 m .45154 .34524 L .44459 .32952 L p .713 .253 .157 r
F P
0 g
s
.44459 .32952 m .41661 .32242 L .42332 .33578 L p .713 .253 .157 r
F P
0 g
s
.64226 .36304 m .66937 .34393 L .66057 .34047 L p .384 0 .136 r
F P
0 g
s
.66057 .34047 m .63361 .35681 L .64226 .36304 L p .384 0 .136 r
F P
0 g
s
.57875 .37978 m .60634 .37017 L .59798 .35965 L p .585 .183 .246 r
F P
0 g
s
.59798 .35965 m .57059 .36729 L .57875 .37978 L p .585 .183 .246 r
F P
0 g
s
.67829 .34591 m .70517 .32174 L .69613 .32235 L p .199 0 .032 r
F P
0 g
s
.69613 .32235 m .66937 .34393 L .67829 .34591 L p .199 0 .032 r
F P
0 g
s
.39495 .32383 m .42332 .33578 L .41661 .32242 L p .672 .155 0 r
F P
0 g
s
.41661 .32242 m .38848 .31368 L .39495 .32383 L p .672 .155 0 r
F P
0 g
s
.32576 .29151 m .29731 .28615 L .30313 .28234 L p .325 .739 .978 r
F P
0 g
s
.48693 .36756 m .51504 .37148 L .50746 .35532 L p .707 .288 .248 r
F P
0 g
s
.50746 .35532 m .4796 .35183 L .48693 .36756 L p .707 .288 .248 r
F P
0 g
s
.31474 .32825 m .22505 .2872 L .2418 .28067 L p .116 .558 .918 r
F P
0 g
s
.61482 .37868 m .64226 .36304 L .63361 .35681 L p .464 .055 .178 r
F P
0 g
s
.63361 .35681 m .60634 .37017 L .61482 .37868 L p .464 .055 .178 r
F P
0 g
s
.55088 .38506 m .57875 .37978 L .57059 .36729 L p .628 .219 .248 r
F P
0 g
s
.57059 .36729 m .54294 .37134 L .55088 .38506 L p .628 .219 .248 r
F P
0 g
s
.71434 .32007 m .74098 .29222 L .7317 .29601 L p .016 0 0 r
F P
0 g
s
.7317 .29601 m .70517 .32174 L .71434 .32007 L p .016 0 0 r
F P
0 g
s
.36644 .3099 m .39495 .32383 L .38848 .31368 L p .535 0 0 r
F P
0 g
s
.38848 .31368 m .36018 .30372 L .36644 .3099 L p .535 0 0 r
F P
0 g
s
.45863 .35965 m .48693 .36756 L .4796 .35183 L p .717 .27 .187 r
F P
0 g
s
.4796 .35183 m .45154 .34524 L .45863 .35965 L p .717 .27 .187 r
F P
0 g
s
.65104 .3673 m .67829 .34591 L .66937 .34393 L p .298 0 .087 r
F P
0 g
s
.66937 .34393 m .64226 .36304 L .65104 .3673 L p .298 0 .087 r
F P
0 g
s
.33174 .29307 m .33781 .29465 L p .35692 .3024 L 0 .391 .722 r
F P
0 g
s
.36018 .30372 m .35785 .30285 L p .35692 .3024 L 0 .391 .722 r
F P
0 g
s
.35785 .30285 m .33174 .29307 L p .35692 .3024 L 0 .391 .722 r
F P
0 g
s
.33781 .29465 m .36644 .3099 L .36018 .30372 L p 0 .391 .722 r
F P
0 g
s
.33781 .29465 m .34399 .29598 L p .36153 .30685 L 0 .372 .771 r
F P
0 g
s
.36644 .3099 m .36266 .30788 L p .36153 .30685 L 0 .372 .771 r
F P
0 g
s
.36266 .30788 m .33781 .29465 L p .36153 .30685 L 0 .372 .771 r
F P
0 g
s
.37282 .31548 m .36644 .3099 L p .34531 .29679 L 0 .372 .771 r
F P
0 g
s
.37282 .31548 m .40155 .33308 L .39495 .32383 L p .499 0 0 r
F P
0 g
s
.39495 .32383 m .36644 .3099 L .37282 .31548 L p .499 0 0 r
F P
0 g
s
.37282 .31548 m .37933 .32012 L p .39261 .32787 L .421 0 0 r
F P
0 g
s
.40155 .33308 m .39263 .32761 L p .39261 .32787 L .421 0 0 r
F P
0 g
s
.39263 .32761 m .37282 .31548 L p .39261 .32787 L .421 0 0 r
F P
0 g
s
.37933 .32012 m .40828 .34103 L .40155 .33308 L p .421 0 0 r
F P
0 g
s
.40828 .34103 m .37933 .32012 L .38595 .32352 L p 0 .216 .67 r
F P
0 g
s
.41514 .34729 m .40828 .34103 L p .39256 .3287 L 0 .216 .67 r
F P
0 g
s
.38595 .32352 m .39255 .32889 L p .39256 .3287 L 0 .216 .67 r
F P
0 g
s
.39255 .32889 m .41514 .34729 L p .39256 .3287 L 0 .216 .67 r
F P
0 g
s
.37933 .32012 m .37282 .31548 L p .35284 .29891 L 0 .363 .804 r
F P
0 g
s
.35028 .2968 m .35224 .29837 L p .35284 .29891 L 0 .363 .804 r
F P
0 g
s
.35224 .29837 m .37933 .32012 L p .35284 .29891 L 0 .363 .804 r
F P
0 g
s
.34399 .29598 m .34492 .29661 L p .34531 .29679 L 0 .372 .771 r
F P
0 g
s
.34492 .29661 m .37282 .31548 L p .34531 .29679 L 0 .372 .771 r
F P
0 g
s
.52276 .38564 m .55088 .38506 L .54294 .37134 L p .662 .238 .227 r
F P
0 g
s
.54294 .37134 m .51504 .37148 L .52276 .38564 L p .662 .238 .227 r
F P
0 g
s
.43016 .34801 m .45863 .35965 L .45154 .34524 L p .711 .221 .08 r
F P
0 g
s
.45154 .34524 m .42332 .33578 L .43016 .34801 L p .711 .221 .08 r
F P
0 g
s
.58704 .39 m .61482 .37868 L .60634 .37017 L p .527 .109 .192 r
F P
0 g
s
.60634 .37017 m .57875 .37978 L .58704 .39 L p .527 .109 .192 r
F P
0 g
s
.68732 .3462 m .71434 .32007 L .70517 .32174 L p .112 0 0 r
F P
0 g
s
.70517 .32174 m .67829 .34591 L .68732 .3462 L p .112 0 0 r
F P
0 g
s
.30904 .27884 m .33781 .29465 L .33174 .29307 L p .259 .651 .965 r
F P
0 g
s
.33174 .29307 m .30313 .28234 L .30904 .27884 L p .259 .651 .965 r
F P
0 g
s
.14899 .21538 m .2418 .28067 L .22505 .2872 L p .434 .661 .956 r
F P
0 g
s
.22505 .2872 m .13402 .24167 L .14899 .21538 L p .434 .661 .956 r
F P
0 g
s
.40155 .33308 m .43016 .34801 L .42332 .33578 L p .661 .116 0 r
F P
0 g
s
.42332 .33578 m .39495 .32383 L .40155 .33308 L p .661 .116 0 r
F P
0 g
s
.4944 .38135 m .52276 .38564 L .51504 .37148 L p .688 .24 .182 r
F P
0 g
s
.51504 .37148 m .48693 .36756 L .4944 .38135 L p .688 .24 .182 r
F P
0 g
s
.6541 .39981 m .742 .35895 L .71254 .36685 L p 0 0 0 r
F P
0 g
s
.72363 .31721 m .7504 .28798 L .74098 .29222 L p 0 0 0 r
F P
0 g
s
.74098 .29222 m .71434 .32007 L .72363 .31721 L p 0 0 0 r
F P
0 g
s
.62342 .38482 m .65104 .3673 L .64226 .36304 L p .377 0 .11 r
F P
0 g
s
.64226 .36304 m .61482 .37868 L .62342 .38482 L p .377 0 .11 r
F P
0 g
s
.55896 .39636 m .58704 .39 L .57875 .37978 L p .579 .145 .181 r
F P
0 g
s
.57875 .37978 m .55088 .38506 L .55896 .39636 L p .579 .145 .181 r
F P
0 g
s
.48693 .36756 m .45863 .35965 L .46584 .37225 L p .701 .219 .1 r
F P
0 g
s
.65992 .36932 m .68732 .3462 L .67829 .34591 L p .19 0 .013 r
F P
0 g
s
.67829 .34591 m .65104 .3673 L .65992 .36932 L p .19 0 .013 r
F P
0 g
s
.59545 .39755 m .62342 .38482 L .61482 .37868 L p .444 .005 .107 r
F P
0 g
s
.61482 .37868 m .58704 .39 L .59545 .39755 L p .444 .005 .107 r
F P
0 g
s
.43713 .35864 m .46584 .37225 L .45863 .35965 L p .689 .163 0 r
F P
0 g
s
.45863 .35965 m .43016 .34801 L .43713 .35864 L p .689 .163 0 r
F P
0 g
s
.69647 .34462 m .72363 .31721 L .71434 .32007 L p .01 0 0 r
F P
0 g
s
.71434 .32007 m .68732 .3462 L .69647 .34462 L p .01 0 0 r
F P
0 g
s
.09849 .20279 m .10617 .18793 L p .13402 .24167 L .575 .688 .918 r
F P
0 g
s
.10617 .18793 m .14899 .21538 L .13402 .24167 L p .575 .688 .918 r
F P
0 g
s
.13402 .24167 m .09196 .2224 L .09849 .20279 L p .575 .688 .918 r
F P
0 g
s
.31504 .27547 m .34399 .29598 L .33781 .29465 L p .21 .573 .94 r
F P
0 g
s
.33781 .29465 m .30904 .27884 L .31504 .27547 L p .21 .573 .94 r
F P
0 g
s
.73304 .31307 m .75996 .28323 L .7504 .28798 L p 0 0 0 r
F P
0 g
s
.7504 .28798 m .72363 .31721 L .73304 .31307 L p 0 0 0 r
F P
0 g
s
.40828 .34103 m .43713 .35864 L .43016 .34801 L p .615 .047 0 r
F P
0 g
s
.43016 .34801 m .40155 .33308 L .40828 .34103 L p .615 .047 0 r
F P
0 g
s
.63213 .38826 m .65992 .36932 L .65104 .3673 L p .258 0 .01 r
F P
0 g
s
.65104 .3673 m .62342 .38482 L .63213 .38826 L p .258 0 .01 r
F P
0 g
s
.42404 .38143 m .33351 .33942 L .35341 .3419 L p 0 .425 .798 r
F P
0 g
s
.56716 .40478 m .59545 .39755 L .58704 .39 L p .501 .034 .077 r
F P
0 g
s
.58704 .39 m .55896 .39636 L .56716 .40478 L p .501 .034 .077 r
F P
0 g
s
.66891 .36886 m .69647 .34462 L .68732 .3462 L p .056 0 0 r
F P
0 g
s
.68732 .3462 m .65992 .36932 L .66891 .36886 L p .056 0 0 r
F P
0 g
s
.37282 .31548 m .34399 .29598 L .35028 .2968 L p 0 .363 .804 r
F P
0 g
s
.70573 .34104 m .73304 .31307 L .72363 .31721 L p 0 0 0 r
F P
0 g
s
.72363 .31721 m .69647 .34462 L .70573 .34104 L p 0 0 0 r
F P
0 g
s
.60397 .40205 m .63213 .38826 L .62342 .38482 L p .319 0 0 r
F P
0 g
s
.62342 .38482 m .59545 .39755 L .60397 .40205 L p .319 0 0 r
F P
0 g
s
.32114 .27208 m .35028 .2968 L .34399 .29598 L p .179 .51 .913 r
F P
0 g
s
.34399 .29598 m .31504 .27547 L .32114 .27208 L p .179 .51 .913 r
F P
0 g
s
.46584 .37225 m .43713 .35864 L .44423 .36723 L p .628 .065 0 r
F P
0 g
s
.74258 .30759 m .76967 .27795 L .75996 .28323 L p 0 0 0 r
F P
0 g
s
.75996 .28323 m .73304 .31307 L .74258 .30759 L p 0 0 0 r
F P
0 g
s
.2595 .27046 m .35341 .3419 L .33351 .33942 L p .154 .519 .916 r
F P
0 g
s
.33351 .33942 m .2418 .28067 L .2595 .27046 L p .154 .519 .916 r
F P
0 g
s
.64095 .38873 m .66891 .36886 L .65992 .36932 L p .094 0 0 r
F P
0 g
s
.65992 .36932 m .63213 .38826 L .64095 .38873 L p .094 0 0 r
F P
0 g
s
.41514 .34729 m .44423 .36723 L .43713 .35864 L p .516 0 0 r
F P
0 g
s
.43713 .35864 m .40828 .34103 L .41514 .34729 L p .516 0 0 r
F P
0 g
s
.678 .36577 m .70573 .34104 L .69647 .34462 L p 0 0 0 r
F P
0 g
s
.69647 .34462 m .66891 .36886 L .678 .36577 L p 0 0 0 r
F P
0 g
s
.35668 .29688 m .38595 .32352 L .37933 .32012 L p 0 .361 .825 r
F P
0 g
s
.37933 .32012 m .35028 .2968 L .35668 .29688 L p 0 .361 .825 r
F P
0 g
s
.71509 .33538 m .74258 .30759 L .73304 .31307 L p 0 0 0 r
F P
0 g
s
.73304 .31307 m .70573 .34104 L .71509 .33538 L p 0 0 0 r
F P
0 g
s
.32735 .26852 m .35668 .29688 L .35028 .2968 L p .163 .463 .888 r
F P
0 g
s
.35028 .2968 m .32114 .27208 L .32735 .26852 L p .163 .463 .888 r
F P
0 g
s
.75224 .30076 m .77952 .27215 L .76967 .27795 L p 0 0 0 r
F P
0 g
s
.76967 .27795 m .74258 .30759 L .75224 .30076 L p 0 0 0 r
F P
0 g
s
.16463 .19108 m .2595 .27046 L .2418 .28067 L p .337 .574 .928 r
F P
0 g
s
.2418 .28067 m .14899 .21538 L .16463 .19108 L p .337 .574 .928 r
F P
0 g
s
.64986 .38605 m .678 .36577 L .66891 .36886 L p 0 0 0 r
F P
0 g
s
.66891 .36886 m .64095 .38873 L .64986 .38605 L p 0 0 0 r
F P
0 g
s
.53745 .41422 m .44623 .39267 L .46968 .38787 L p .131 .634 .905 r
F P
0 g
s
.44423 .36723 m .41514 .34729 L .42213 .35154 L p 0 .184 .623 r
F P
0 g
s
.42213 .35154 m .45147 .3734 L .44423 .36723 L p 0 .184 .623 r
F P
0 g
s
.68719 .35995 m .71509 .33538 L .70573 .34104 L p 0 0 0 r
F P
0 g
s
.70573 .34104 m .678 .36577 L .68719 .35995 L p 0 0 0 r
F P
0 g
s
.3927 .32539 m .42213 .35154 L .41514 .34729 L p 0 .284 .761 r
F P
0 g
s
.41514 .34729 m .38595 .32352 L .3927 .32539 L p 0 .284 .761 r
F P
0 g
s
.72457 .32762 m .75224 .30076 L .74258 .30759 L p 0 0 0 r
F P
0 g
s
.74258 .30759 m .71509 .33538 L .72457 .32762 L p 0 0 0 r
F P
0 g
s
.11289 .17166 m .12091 .1578 L p .14899 .21538 L .465 .627 .922 r
F P
0 g
s
.12091 .1578 m .16463 .19108 L .14899 .21538 L p .465 .627 .922 r
F P
0 g
s
.14899 .21538 m .10617 .18793 L .11289 .17166 L p .465 .627 .922 r
F P
0 g
s
.36321 .29603 m .3927 .32539 L .38595 .32352 L p .006 .367 .836 r
F P
0 g
s
.38595 .32352 m .35668 .29688 L .36321 .29603 L p .006 .367 .836 r
F P
0 g
s
.62132 .40083 m .64986 .38605 L .64095 .38873 L p 0 0 0 r
F P
0 g
s
.76202 .29263 m .78951 .26584 L .77952 .27215 L p 0 0 0 r
F P
0 g
s
.77952 .27215 m .75224 .30076 L .76202 .29263 L p 0 0 0 r
F P
0 g
s
.33366 .26466 m .36321 .29603 L .35668 .29688 L p .157 .432 .868 r
F P
0 g
s
.35668 .29688 m .32735 .26852 L .33366 .26466 L p .157 .432 .868 r
F P
0 g
s
.48068 .39014 m .45147 .3734 L .45883 .37681 L p 0 .267 .673 r
F P
0 g
s
.65887 .38009 m .68719 .35995 L .678 .36577 L p 0 0 0 r
F P
0 g
s
.678 .36577 m .64986 .38605 L .65887 .38009 L p 0 0 0 r
F P
0 g
s
.42925 .35347 m .45883 .37681 L .45147 .3734 L p 0 .309 .77 r
F P
0 g
s
.45147 .3734 m .42213 .35154 L .42925 .35347 L p 0 .309 .77 r
F P
0 g
s
.71509 .33538 m .68719 .35995 L .69647 .35137 L p .494 .835 .553 r
F P
0 g
s
.69647 .35137 m .72457 .32762 L .71509 .33538 L p .494 .835 .553 r
F P
0 g
s
.37452 .33296 m .46968 .38787 L .44623 .39267 L p .167 .555 .93 r
F P
0 g
s
.44623 .39267 m .35341 .3419 L .37452 .33296 L p .167 .555 .93 r
F P
0 g
s
.39958 .32552 m .42925 .35347 L .42213 .35154 L p 0 .345 .82 r
F P
0 g
s
.42213 .35154 m .3927 .32539 L .39958 .32552 L p 0 .345 .82 r
F P
0 g
s
.75224 .30076 m .72457 .32762 L .73414 .3178 L p .525 .84 .534 r
F P
0 g
s
.73414 .3178 m .76202 .29263 L .75224 .30076 L p .525 .84 .534 r
F P
0 g
s
.36986 .29407 m .39958 .32552 L .3927 .32539 L p .065 .378 .843 r
F P
0 g
s
.3927 .32539 m .36321 .29603 L .36986 .29407 L p .065 .378 .843 r
F P
0 g
s
.63014 .39477 m .65887 .38009 L .64986 .38605 L p .443 .862 .721 r
F P
0 g
s
.64986 .38605 m .62132 .40083 L .63014 .39477 L p .443 .862 .721 r
F P
0 g
s
.77193 .28327 m .79966 .25911 L .78951 .26584 L p 0 0 0 r
F P
0 g
s
.78951 .26584 m .76202 .29263 L .77193 .28327 L p 0 0 0 r
F P
0 g
s
.34008 .26041 m .36986 .29407 L .36321 .29603 L p .159 .412 .854 r
F P
0 g
s
.36321 .29603 m .33366 .26466 L .34008 .26041 L p .159 .412 .854 r
F P
0 g
s
.56317 .41099 m .59241 .40932 L .58389 .41153 L p .195 .723 .831 r
F P
0 g
s
.66796 .37083 m .69647 .35137 L .68719 .35995 L p .595 .929 .721 r
F P
0 g
s
.68719 .35995 m .65887 .38009 L .66796 .37083 L p .595 .929 .721 r
F P
0 g
s
.70585 .34008 m .73414 .3178 L .72457 .32762 L p .656 .944 .697 r
F P
0 g
s
.72457 .32762 m .69647 .35137 L .70585 .34008 L p .656 .944 .697 r
F P
0 g
s
.27823 .25558 m .37452 .33296 L .35341 .3419 L p .202 .506 .909 r
F P
0 g
s
.35341 .3419 m .2595 .27046 L .27823 .25558 L p .202 .506 .909 r
F P
0 g
s
.43651 .35286 m .46633 .3772 L .45883 .37681 L p .022 .409 .858 r
F P
0 g
s
.45883 .37681 m .42925 .35347 L .43651 .35286 L p .022 .409 .858 r
F P
0 g
s
.60103 .40318 m .63014 .39477 L .62132 .40083 L p .485 .9 .884 r
F P
0 g
s
.74383 .30603 m .77193 .28327 L .76202 .29263 L p .649 .932 .664 r
F P
0 g
s
.76202 .29263 m .73414 .3178 L .74383 .30603 L p .649 .932 .664 r
F P
0 g
s
.40659 .3237 m .43651 .35286 L .42925 .35347 L p .073 .395 .853 r
F P
0 g
s
.42925 .35347 m .39958 .32552 L .40659 .3237 L p .073 .395 .853 r
F P
0 g
s
.63904 .38499 m .66796 .37083 L .65887 .38009 L p .658 .972 .866 r
F P
0 g
s
.65887 .38009 m .63014 .39477 L .63904 .38499 L p .658 .972 .866 r
F P
0 g
s
.37662 .29086 m .40659 .3237 L .39958 .32552 L p .121 .393 .847 r
F P
0 g
s
.39958 .32552 m .36986 .29407 L .37662 .29086 L p .121 .393 .847 r
F P
0 g
s
.34661 .25568 m .37662 .29086 L .36986 .29407 L p .167 .402 .845 r
F P
0 g
s
.36986 .29407 m .34008 .26041 L .34661 .25568 L p .167 .402 .845 r
F P
0 g
s
.59241 .40932 m .56317 .41099 L .57159 .4048 L p .481 .864 .978 r
F P
0 g
s
.67714 .35831 m .70585 .34008 L .69647 .35137 L p .74 .992 .83 r
F P
0 g
s
.69647 .35137 m .66796 .37083 L .67714 .35831 L p .74 .992 .83 r
F P
0 g
s
.181 .16961 m .27823 .25558 L .2595 .27046 L p .25 .506 .902 r
F P
0 g
s
.2595 .27046 m .16463 .19108 L .181 .16961 L p .25 .506 .902 r
F P
0 g
s
.71532 .32618 m .74383 .30603 L .73414 .3178 L p .764 .994 .798 r
F P
0 g
s
.73414 .3178 m .70585 .34008 L .71532 .32618 L p .764 .994 .798 r
F P
0 g
s
.60974 .39306 m .63904 .38499 L .63014 .39477 L p .667 .949 .955 r
F P
0 g
s
.63014 .39477 m .60103 .40318 L .60974 .39306 L p .667 .949 .955 r
F P
0 g
s
.44389 .34955 m .47396 .37436 L .46633 .3772 L p .176 .479 .896 r
F P
0 g
s
.46633 .3772 m .43651 .35286 L .44389 .34955 L p .176 .479 .896 r
F P
0 g
s
.54185 .3994 m .57159 .4048 L .56317 .41099 L p .442 .779 .998 r
F P
0 g
s
.56317 .41099 m .53365 .40562 L .54185 .3994 L p .442 .779 .998 r
F P
0 g
s
.41373 .3198 m .44389 .34955 L .43651 .35286 L p .172 .437 .87 r
F P
0 g
s
.43651 .35286 m .40659 .3237 L .41373 .3198 L p .172 .437 .87 r
F P
0 g
s
.12782 .14595 m .1362 .13359 L p .16463 .19108 L .32 .553 .918 r
F P
0 g
s
.1362 .13359 m .181 .16961 L .16463 .19108 L p .32 .553 .918 r
F P
0 g
s
.16463 .19108 m .12091 .1578 L .12782 .14595 L p .32 .553 .918 r
F P
0 g
s
.64803 .37154 m .67714 .35831 L .66796 .37083 L p .766 .98 .913 r
F P
0 g
s
.66796 .37083 m .63904 .38499 L .64803 .37154 L p .766 .98 .913 r
F P
0 g
s
.38352 .2863 m .41373 .3198 L .40659 .3237 L p .173 .412 .851 r
F P
0 g
s
.40659 .3237 m .37662 .29086 L .38352 .2863 L p .173 .412 .851 r
F P
0 g
s
.58009 .39453 m .60974 .39306 L .60103 .40318 L p .632 .88 .987 r
F P
0 g
s
.60103 .40318 m .57159 .4048 L .58009 .39453 L p .632 .88 .987 r
F P
0 g
s
.35326 .25041 m .38352 .2863 L .37662 .29086 L p .18 .4 .84 r
F P
0 g
s
.37662 .29086 m .34661 .25568 L .35326 .25041 L p .18 .4 .84 r
F P
0 g
s
.68641 .34266 m .71532 .32618 L .70585 .34008 L p .811 .99 .877 r
F P
0 g
s
.70585 .34008 m .67714 .35831 L .68641 .34266 L p .811 .99 .877 r
F P
0 g
s
.4817 .36817 m .51187 .38706 L .50389 .39327 L p .339 .597 .941 r
F P
0 g
s
.50389 .39327 m .47396 .37436 L .4817 .36817 L p .339 .597 .941 r
F P
0 g
s
.61854 .37901 m .64803 .37154 L .63904 .38499 L p .747 .926 .949 r
F P
0 g
s
.63904 .38499 m .60974 .39306 L .61854 .37901 L p .747 .926 .949 r
F P
0 g
s
.55015 .38917 m .58009 .39453 L .57159 .4048 L p .573 .792 .982 r
F P
0 g
s
.57159 .4048 m .54185 .3994 L .55015 .38917 L p .573 .792 .982 r
F P
0 g
s
.4514 .34342 m .4817 .36817 L .47396 .37436 L p .293 .527 .907 r
F P
0 g
s
.47396 .37436 m .44389 .34955 L .4514 .34342 L p .293 .527 .907 r
F P
0 g
s
.6571 .35456 m .68641 .34266 L .67714 .35831 L p .808 .947 .913 r
F P
0 g
s
.67714 .35831 m .64803 .37154 L .6571 .35456 L p .808 .947 .913 r
F P
0 g
s
.421 .31375 m .4514 .34342 L .44389 .34955 L p .255 .473 .878 r
F P
0 g
s
.44389 .34955 m .41373 .3198 L .421 .31375 L p .255 .473 .878 r
F P
0 g
s
.39053 .28035 m .421 .31375 L .41373 .3198 L p .222 .433 .855 r
F P
0 g
s
.41373 .3198 m .38352 .2863 L .39053 .28035 L p .222 .433 .855 r
F P
0 g
s
.51996 .37707 m .55015 .38917 L .54185 .3994 L p .508 .706 .959 r
F P
0 g
s
.54185 .3994 m .51187 .38706 L .51996 .37707 L p .508 .706 .959 r
F P
0 g
s
.5887 .38023 m .61854 .37901 L .60974 .39306 L p .701 .855 .956 r
F P
0 g
s
.60974 .39306 m .58009 .39453 L .5887 .38023 L p .701 .855 .956 r
F P
0 g
s
.36002 .24457 m .39053 .28035 L .38352 .2863 L p .196 .406 .841 r
F P
0 g
s
.38352 .2863 m .35326 .25041 L .36002 .24457 L p .196 .406 .841 r
F P
0 g
s
.48957 .3586 m .51996 .37707 L .51187 .38706 L p .444 .628 .932 r
F P
0 g
s
.51187 .38706 m .4817 .36817 L .48957 .3586 L p .444 .628 .932 r
F P
0 g
s
.62741 .36117 m .6571 .35456 L .64803 .37154 L p .778 .888 .924 r
F P
0 g
s
.64803 .37154 m .61854 .37901 L .62741 .36117 L p .778 .888 .924 r
F P
0 g
s
.55855 .37498 m .5887 .38023 L .58009 .39453 L p .643 .782 .948 r
F P
0 g
s
.58009 .39453 m .55015 .38917 L .55855 .37498 L p .643 .782 .948 r
F P
0 g
s
.45903 .33444 m .48957 .3586 L .4817 .36817 L p .382 .561 .905 r
F P
0 g
s
.4817 .36817 m .4514 .34342 L .45903 .33444 L p .382 .561 .905 r
F P
0 g
s
.42839 .30552 m .45903 .33444 L .4514 .34342 L p .324 .505 .881 r
F P
0 g
s
.4514 .34342 m .421 .31375 L .42839 .30552 L p .324 .505 .881 r
F P
0 g
s
.52815 .36335 m .55855 .37498 L .55015 .38917 L p .58 .711 .933 r
F P
0 g
s
.55015 .38917 m .51996 .37707 L .52815 .36335 L p .58 .711 .933 r
F P
0 g
s
.59738 .36205 m .62741 .36117 L .61854 .37901 L p .733 .827 .923 r
F P
0 g
s
.61854 .37901 m .5887 .38023 L .59738 .36205 L p .733 .827 .923 r
F P
0 g
s
.39768 .27298 m .42839 .30552 L .421 .31375 L p .268 .457 .861 r
F P
0 g
s
.421 .31375 m .39053 .28035 L .39768 .27298 L p .268 .457 .861 r
F P
0 g
s
.36691 .23817 m .39768 .27298 L .39053 .28035 L p .214 .417 .845 r
F P
0 g
s
.39053 .28035 m .36002 .24457 L .36691 .23817 L p .214 .417 .845 r
F P
0 g
s
.49755 .3457 m .52815 .36335 L .51996 .37707 L p .516 .647 .915 r
F P
0 g
s
.51996 .37707 m .48957 .3586 L .49755 .3457 L p .516 .647 .915 r
F P
0 g
s
.56705 .35698 m .59738 .36205 L .5887 .38023 L p .682 .768 .916 r
F P
0 g
s
.5887 .38023 m .55855 .37498 L .56705 .35698 L p .682 .768 .916 r
F P
0 g
s
.46679 .32266 m .49755 .3457 L .48957 .3586 L p .451 .588 .899 r
F P
0 g
s
.48957 .3586 m .45903 .33444 L .46679 .32266 L p .451 .588 .899 r
F P
0 g
s
.43591 .29514 m .46679 .32266 L .45903 .33444 L p .383 .534 .883 r
F P
0 g
s
.45903 .33444 m .42839 .30552 L .43591 .29514 L p .383 .534 .883 r
F P
0 g
s
.53646 .34605 m .56705 .35698 L .55855 .37498 L p .627 .712 .908 r
F P
0 g
s
.55855 .37498 m .52815 .36335 L .53646 .34605 L p .627 .712 .908 r
F P
0 g
s
.40495 .26424 m .43591 .29514 L .42839 .30552 L p .312 .483 .868 r
F P
0 g
s
.42839 .30552 m .39768 .27298 L .40495 .26424 L p .312 .483 .868 r
F P
0 g
s
.37391 .23124 m .40495 .26424 L .39768 .27298 L p .235 .435 .853 r
F P
0 g
s
.39768 .27298 m .36691 .23817 L .37391 .23124 L p .235 .435 .853 r
F P
0 g
s
.50565 .32959 m .53646 .34605 L .52815 .36335 L p .568 .66 .899 r
F P
0 g
s
.52815 .36335 m .49755 .3457 L .50565 .32959 L p .568 .66 .899 r
F P
0 g
s
.47467 .3082 m .50565 .32959 L .49755 .3457 L p .505 .611 .892 r
F P
0 g
s
.49755 .3457 m .46679 .32266 L .47467 .3082 L p .505 .611 .892 r
F P
0 g
s
.44356 .28273 m .47467 .3082 L .46679 .32266 L p .435 .562 .884 r
F P
0 g
s
.46679 .32266 m .43591 .29514 L .44356 .28273 L p .435 .562 .884 r
F P
0 g
s
.41235 .25421 m .44356 .28273 L .43591 .29514 L p .354 .512 .876 r
F P
0 g
s
.43591 .29514 m .40495 .26424 L .41235 .25421 L p .354 .512 .876 r
F P
0 g
s
.38104 .22384 m .41235 .25421 L .40495 .26424 L p .258 .459 .866 r
F P
0 g
s
.40495 .26424 m .37391 .23124 L .38104 .22384 L p .258 .459 .866 r
F P
0 g
s
.25 Mabswid
.98446 .08978 m
1 .42004 L
s
.98446 .08978 m
.97767 .08904 L
s
[(-1)] .99803 .09126 -1 -0.10884 Mshowa
.98826 .17057 m
.98147 .1699 L
s
[(-0.5)] 1.00185 .1719 -1 -0.09814 Mshowa
.99212 .25253 m
.98532 .25193 L
s
[(0)] 1.00572 .25371 -1 -0.08728 Mshowa
.99603 .33567 m
.98922 .33515 L
s
[(0.5)] 1.00964 .33671 -1 -0.07625 Mshowa
1 .42004 m
.99319 .41959 L
s
[(1)] 1.01362 .42092 -1 -0.06504 Mshowa
.125 Mabswid
.98522 .10585 m
.98114 .10541 L
s
.98597 .12196 m
.9819 .12153 L
s
.98674 .13812 m
.98266 .1377 L
s
.9875 .15432 m
.98342 .15391 L
s
.98903 .18687 m
.98495 .18648 L
s
.9898 .20321 m
.98572 .20283 L
s
.99057 .2196 m
.98649 .21923 L
s
.99134 .23604 m
.98726 .23567 L
s
.9929 .26906 m
.98881 .26871 L
s
.99368 .28564 m
.98959 .2853 L
s
.99446 .30227 m
.99038 .30194 L
s
.99524 .31895 m
.99116 .31863 L
s
.99682 .35245 m
.99273 .35214 L
s
.99761 .36927 m
.99353 .36898 L
s
.99841 .38614 m
.99432 .38586 L
s
.9992 .40306 m
.99511 .40279 L
s
gsave
1.07373 .25965 -61 -9.87563 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 153.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VA000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00U7oo0P00RWoo002EOol00`00Oomoo`28Ool009Ioo`03001oogoo08Moo`00UGoo
00<007oo0000R7oo002DOol01000Oomoo`00R7oo002COol300000goo00000027Ool003aoo`@00>1o
o`00?7oo00<007ooOol0hGoo000mOol00`00Oomoo`3POol003Ioo`@000Aoo`03001oogoo0=moo`00
?7oo00@007ooOol00>1oo`00?Goo0P00:goo1@00/Goo001/Ool00`00Oomoo`2aOol006aoo`03001o
ogoo0;5oo`00I7oo100017oo00<007ooOol0/Goo001/Ool00`00Oomoo`2aOol006]oo`8002Qoo`80
08Uoo`00>Woo1@00EGoo00@007ooOol008Qoo`00>Woo00<007ooOol00Woo2@00C7oo00@007ooOol0
08Qoo`00A7oo00@007ooOomoo`X0049oo`04001oogoo0028Ool004eoo`03001oogoo009oo`T003Uo
o`04001oogoo0028Ool005Moo`04001oogooOol9000aOol2000WOol5001MOol0061oo`04001oogoo
Ool9001COol00`00Oomoo`1MOol006Uoo`04001oogooOol9001:Ool00`00Oomoo`1MOol006Uoo`03
001oogoo00Ioo`04001oogooOol:0010Ool00`00Oomoo`1MOol007]oo`03001oogoo009oo`T003Mo
o`03001oogoo02=oo`@003Ioo`00Q7oo00<007ooOol00Woo2@00;Goo0P009Goo00<007ooOol0=goo
002=Ool00`00Oomoo`02Ool9001<Ool00`00Oomoo`0fOol009Ioo`03001oogoo009oo`T004Aoo`03
001oogoo03Eoo`00Wgoo00<007ooOol00Woo2P00>7oo00@007ooOol003Ioo`00Ygoo00<007ooOol0
17oo2@00<7oo0P00=goo002`Ool00`00Oomoo`04Ool9001POol00<1oo`X005Ioo`00`7oo00<007oo
Ool01Woo2@00CWoo003AOol;0014Ool00=Uoo`03001oogoo00T000eoo`D002Uoo`00hGoo00@007oo
Oomoo`D000Yoo`03001oogoo02Uoo`00jGoo00<007ooOol027oo00<007ooOol0:Goo003YOol00`00
Oomoo`040004Ool00`00Oomoo`0YOol00>Qoo`8000Yoo`03001oogoo02Uoo`00jGoo00<007ooOol0
1goo0P00:goo003YOol00`00Oomoo`0dOol00>Uoo`03001oogoo03Aoo`00j7oo0P00=Woo003YOol0
0`00Oomoo`0dOol003Eoo`03001oogoo0;5oo`03001oogoo03Aoo`00=Goo0P00/Goo0P00=Woo000d
Ool00`009Q`Z?@02002`Ool00`00Oomoo`0dOol003Aoo`03000V?BHL008V?003001oogoo0:ioo`03
001oogoo03=oo`00<goo00P002Xm9Q`V?BHL:SdV7000[Goo00<007oo0000=Goo000bOol00`009SdV
70029S`01BHm9Q`V?2Hl0000[Goo0P00=Goo000aOol02`00>Wd002Hm9Q`Z?BHL9SdV72Xm9Q`00P00
[7oo00<007ooOol0<goo000aOol00`00>W`jO@0200001BHL9S`V?2Hm9Q`00RHl00<V?@00Ool0ZWoo
00<007ooOol01goo0P0017oo0P0017oo0P007Woo000`Ool04000>W`jOCIl>WdjO0009Q`Z?BHL9SdV
72Xm9Q`V?@00Z7oo0`0027oo00@007ooOol000Qoo`04001oogoo000MOol0031oo`09000jOCYl>Wdj
O3Ym>W`002HL008V?0069SdV72Hl000Mo000ZGoo00<007ooOol01Woo00@007ooOol000]oo`03001o
ogoo01]oo`00<7oo00P003Il>WdjO3Ym=W`jOCYl0P0000PZ?BHL9Sd001hL7O/Mo000Z7oo00<007oo
Ool010000Woo00@007ooOol000Uoo`8001ioo`00;goo00h003Yl>WdjO3Ym>W`jOCYl>WdjO3Ym000V
?0001Agl00<007ooOol0Y7oo0P0027oo00@007ooOol000Uoo`03001oogoo01eoo`00;goo01D003Ym
>W`jOCIl>WdjO3Ym=W`jOCYl>Wd001hL7O/Mo1Wk7Q`Mnagl0000YWoo00<007ooOol01goo0P002Woo
0`007Goo000^Ool03`00B[d00000>W`jOCYl>WdjO3Ym>W`jO@00:Sd000077O`2002TOol00`00Oomo
o`0cOol002ioo`040016_4ZmA[`200004cYm=W`jOCYl>WdfO0009S`ZG@007Q`Mnagl6O/N71gk7O`I
n`000:=oo`03001oogoo03=oo`00;Goo00D004JlA[a6_4Zm0096_0800005>W`jOCYl000Z?003:Sd2
00077O`00`00Oomoo`2OOol2000eOol002eoo`09001:_DJlB[e6_4ZmA[a:_DJl0080000A>Wd002YM
9S`ZGBHl:UdV?0007O/Mo1Wk7Q`Mnagl6O/0002GOol00`00Oomoo`07Ool00`00Oomoo`0cOol002eo
o`030016_4Zm00=6_006B[e6_4JlA[a:_@000bXm00HZ?2Xm:SdZ?BXl00077O`00`00Oomoo`2BOol2
000:Ool00`00Oomoo`0cOol002aoo`0;0016_4ZmA[a:_DJlB[e6_4ZmA[a:_@04000042Hl:UdV?2YM
9S`ZGBHl000Mnagl6O/N71gk7O`In`00TGoo0P002goo0P00=Goo000/Ool20003A[`02dZmA[a6_4Jl
B[e6_000=YdfWSJM00000RXm00HZ?2Xm:SdZ?BXl00077O`00`00Oomoo`0KOol00`00Oomoo`1_Ool2
000=Ool00`00Oomoo`0cOol002]oo`03001BoE;L00800006B[e6_4ZmA[a:_DJl0P0000@f_SJM=Yhb
W@800006:UdV?2YM9S`ZGBHl0P0000LMo1Wk7Q`Mnagl6O/0000JOol7001[Ool2000?Ool00`00Oomo
o`0cOol002]oo`03001Bo5;l009Bo080000;A[a:_DJlA[`003JN=YdfWSJM=YhfW@0200000bXm:S`Z
?@02:Sd00bXl000000067O`00`00Oomoo`0?Ool:00027M/7001UOol2000AOol00`00Oomoo`0cOol0
02Yoo`08001Bg5;lD]aBoE;LD_aBg080000JB[d00000=YdfWS:M=[hfWCJN<Ydf_P00:UdV?2YM9S`Z
GBHl:Ud001gl6O/N71gk7O`In`8000Moo`T0000B;00X02`0:00/02P0000I^Qfk000Qfafj000X0000
=00h03@01000H7oo0P004Goo0P00=Goo000ZOol00`00D_aBo007D_`200002SJM=YhfWCJN=YdfWSJM
=YhfWCJN0P0000LZ?2Xm:SdZ?BXl:Sd000077O`00`00Oomoo`02Ool5000220020008:00200000aVj
7KX000027M/5000013@0>00d03P01000Fgoo0P004goo00<007ooOol0<goo000ZOol02P00D]aBoE;L
D_aBg5;mD]aBo5;L100001Tf_SJM=YhbWCJn=YdfWS:M=[hfW@009S`ZGBHl:UdV?2YM000Mo1Wk7Q`M
nagl6O/N700600001@@0200400P010002P0000`I^QFJ000I^Qfk000Qfafj00108@00C606000013P0
=0000000Egoo0`0057oo00<007ooOol00Woo0P00;goo000YOol00`00D_aBo008D_`01000@_i2oT;n
0P0000TfWCJN=YdfWSJM=YhfWCJN=Yd00P000bXm00<Z?2Xm00001agl0P0010P010000b@000D0040Q
@2508@00008EVP07000IVQVJ000I^P007KX00QgK00D0040Q001<H51Q00=<H003D640000000@005Ao
o`<001Aoo`8000=oo`04001oogoo000^Ool002Uoo`0:001BoE;LD_aBg5;mD]aBo5;LD_d200001D;n
@am2oT<O@_h00P0000lfWS:M=[hfWCJN<Ydf_SJM=Yh002YM9S`ZGBHl:Ud00P0000HInahL7O/Mo1Wk
7Q`5000022@0800T0200900P02@0800300003A5j000ENAVJ000I^P007K/I^P007KXQfafj0080000;
D65<H51QC61@HDaPD65<H51QC61@H@04001?Ool4000GOol01000Oomoo`000Woo00<007ooOol02Goo
0`0000=oo`0000007Goo000YOol30007D_`00`00@_i2oP06@_h2000023JM=YhfWCJN=YdfWSJM=Yh2
0002:Sd012Xl:SdZ?@0011gl00<001Gl00002b@000H0016J4IX001FJ00025IX02@006IX001fj6KX0
01fj000Yn`020002C6001E1QC61<H4aPD6400daP00=@HDaPC6000`00?Woo0P0037oo100067oo00@0
07ooOol0009oo`03001oogoo00Yoo`04001oogoo000NOol002Uoo`03001K?5/L00@0000>D_eBg000
00137d;n@am2oT<O@_i37d;n@am2oP800007=[hfWCJN<Ydf_SJM=Yh00P0000LV?2YM9S`ZGBHl000I
n`0200000aWl5O`J700200006b00900P02@0800T02009000016k000EVQ5j000ANP005GT001FJ6KX0
01fk6KX002Wk;Q/Yn`0400003E1QC61@HDaPD65<H51QC61@HDaPD64004`P008003Yoo`<000aoo`@0
01Uoo`04001oogoo0002Ool00`00Oomoo`0:Ool01000Oomoo`007Woo000XOol02000FcaK75/lFaaK
?5/LFc`5000;@_h2000023JM=YhfWCJN=YdfWSJM0002:Sd012Xl:SdZ?@000aGl00HIo1Gl5O`Eo000
90060000116k000AVP000Q6J00D001FJ000EVP00008IVP@000<Yn`800003E<@0000000@000=<H006
D65<H4aP001<84PP0P00=Woo10002goo0`0000=;_@00Ool05goo0`000goo0P003Goo0`007goo000X
Ool03@00FaaO?E/LFcaK75lmFaaK?000Cgm?GTmo00D00008@am2oT<O@_i37d;n@am2oP800006=Yhb
WCJn=YdfWS:M0P0000@ZG@00000Ao08000066Q`Eo1Wl5O`J71Gl0P00028d00005Q`001GL000A^`00
4K/001FJ000EVQ5j000EN@005IXI^P009O/UfP00:O/^6bWk001@`eC4D<ADa533E<A@a0H00005D640
04`PB21<8002000cOol3000<Ool300000d^m001oo`0JOol00`00Oomoo`0@Ool00`00Oomoo`0OOol0
02Qoo`0B001K?5/LFcaK75/lFaaK?5/L001?GTmOCei?OdmNCem?GTmo10001T;n0P0000/fWCJN=Ydf
WSJM=Yh0018L4O`B717l0080008Eo0046O`Eo1Gl5O`60000217K000A^`004IX0016J00025IX01P00
5IX000008M/0008Uf`80008Yn`03001@a5C4009Da005D<ADa5C4E<A@a003E<@400000dPPC2188002
000`Ool3000;Ool6000LOol00`00Oomoo`0?Ool2000QOol002Moo`0G001O?E/LFcaK75lmFaaK?5/L
001?GTmoBei?OdmNCgm;GTmoCei?Od]NCgm?GP0500000d;n@am2oP0200001CJn=Yd000003Sd00P00
00`=o18M4O`B7@006Q`Eo1Wl5O`J71Gl6O`700008a6k000A^`005IX001FJ4GX001VJ000M^R7K000U
nbGJ9O/002hK:O/00533E<A@a5C4D<=Da534E<A@`eC4D<ADa533E<@0100000A884`P000002aoo`@0
00Yoo`H001eoo`8003Aoo`009goo01`005/LFcaK75/lFaaK?5/LFc`004mOCei?OdmNCem?GTmoCei?
GdmNCgm?GTmOCei?OdmNCem?GPL000033S`>?@Xl008>?005000Ao18L4O`B700200000aGl6O`Eo002
5O`00aWl0000000500001A6k000AVP004IX00P0000LAVP006KX001fj8M/000029M/00bGk00000003
0003E<@01E34E<ADa5C4D<@00eC400E@a000D85DPE2000H002Qoo`D000Yoo`H001moo`03001oogoo
039oo`009Woo9P0000@>?@XL3Sd:708000034QdAo18M008000065O`Io1Gl6Q`Eo1Wl1`0002TA^`00
000000fJ000E^`006K/IVP007KXQf`009O/UfRGk000f?3Hk=S`005C4D<ADa533E<A@a5C4D<=Da534
E<A@``00D81DXE20E:5@P5BQ00@0029oo`P000Uoo`D00003Bgi?W`0001moo`03001oogoo039oo`00
9Woo00<006=LHe`01F=L0P003UNn100000=?fP0000001Woo0`0000`:?0hl3S`>?@004Q`Ao18L4O`0
01Gl6O`35O`00aWl5O`000050000205j0005NP003IX001FJ00026KX020007KXQf`009M/002hK0003
=S/90003E<@02U34001@PEB1D81DPE21E85@P5B10`007Woo2@0027oo1P0000=?OdnO000087oo00<0
07ooOol0<Woo000UOol02`00HgaOG6=mGeaSO5mLHgeOG000Eid00eNn00EGWENnEkiG_UNM009G_PD0
0004CmYCf`00000;Ool300001`XL3Sd000004O`B7@gl008000086O`Eo1XL5O`Io1Gl000h00@0000E
0GX000Ej000=VP005K/001Vk6IX001fj8M/0038L;Q/b7000=S`f>cHl00800006FDUIBP00001IBEU:
2`0000EDXE20E:5@P5BQ00<001Uoo`L00003@e1?U00000Ioo`P00004Bgi?Wd]n000OOol2000dOol0
02Eoo`03001SG6=L00ESG08000MG_PL0009Cf`80011oo`8000063Sd:?0004O`B717l0P0000HIo1Gl
5O`Eo1Wl5O`200000c`00000000300001PEj0000016J5IX0008I^P@000<^6`03000f>cHk008f>`04
001IBEU:0004FDX02@00FDUIBUU9FDYIB@00EBQI:@0;000BOol=0005Ool80002Cgl00dnOBgh0000Q
Ool00`00Oomoo`0bOol002Eoo`09001SOEmLHgaOG6=mGeaSO00000=G_P03Eid0000000800003Fod0
000000<00003Dm/0000001Aoo`@0000>4O`B7@gl4Qd001Wl5O`J71Gl6O`Eo1XL000l00H0000E2GX0
016J000IVQVk6IX002Gk:O/0038L;Q/b7000=S`f>`00?U/005U900800003FDYIBEU:00800004FDUI
BUTYFDX200002EDXFBUE:5TY001E1eCVE@MDiP0200000e2S000000090003Ool800000`@000000004
0005Ool900000dnOBgi?W`02000ROol00`00Oomoo`0bOol002Eoo`03001SG6=L00ASG0H000=Kg0<0
0005AiL004oJDm/0000IOol300000a8L4O`B700200035O`01QWl5O`Eo000?00h00D000083GX0016J
000I^P007M/0008Un`09000^6bhK;Q/003Hk000nO3iK00D0009IBP0?001IBUU9FDYIBEU:001I:EDX
FBUI:000E>IE1eCV01<0000750000000000<000010001P000goo3`008goo0P00=7oo000TOol01`00
GeaSO5mLHgeOG6=l00<00004FoaGg5_mEm`4000014Nh000004oJ0P0077oo0P0000<B7@gl4Qd00P00
00HEo1XL5O`Io1Gl6Q`200000cP000000003000010Uj000000000agK00`002Gk:O/0038L;Q/b7000
@W`nFcil?U/200000eU:EBT0000@0002D>L01e370018Q4b4B6=<Q4R400@00005>0400000000`0@0;
000016?i001oogoo1P0000<@00000000100000=77T/o00009Goo00<007ooOol0<Woo000TOol00`00
HeaSG0060003Fm`700000e?K0000000POol20000117l4Q`Ao0000aGl00@Io1Gl5O`Eo0L000041IX0
016k00037M/010009O/Un`000RhK0`0001DnFcil?U/nO000FDYIBEU:FDT005DYFBUE:EU:EBT005D9
EBUE2EDY00001E3W00<004R4B8@00`0000=4I@0000000`0000<`0@0000000`0000<P0@0050401000
00=On@0000001P000Q00100000I77T/NBai;7TLN000UOol00`00Oomoo`0bOol002Aoo`<00007HiaW
W6>LIkd005_lEm`00P0000IGnP00000oM@00CmX2000TOol010003O`B7A7l0P0000DJ71Gl6O`Eo1XL
00800003>00l000000<000041GX0016J00037M/00`009O/Yn`02000023Hk>U`f>`00?U/nO3iK@W`2
00004EDYFDX005U:EBUIBUDYFDX005DYE@QE:ED8EBT0053WD<L01@0000A4I4AUA6A4Q@<00007<040
0000000X0@0080402P0000<T02P000000P0000<@00`000000`0000M;?dLNBcm77T/oAah0000VOol0
0`00Oomoo`02Ool20004Ool20004Ool2000ROol002=oo`03001WW6NL00AWW0@00003EmX0000000D0
02Moo`8000044Q`Ao00000025O`200024Sd300001DaQ000000001IX00`000agK00@002Gk9O/0008f
G008>U`fG000?U/nO3iK0016W18000=<a`030014IDAU0080008lA@04@4D00000:04200000b010000
000300001VOkIm/00000:00T00<0008@00D00003Bai77T/N009;7P03Aai;7P0002Eoo`8000=oo`04
001oogoo0008Ool01000Oomoo`008Goo000ROol01`00HiaW_F>LIiaSW6Nm00<00003EoX0000000D0
02]oo`H000064Q`F?A8L5SdB71Hm0P0000I<HDb2000000Ej2I/200037M/200001Rhl000jG3Hk>U`f
>`<00004AY]:W4JKAY`300003UDYD@UE:ED9001@j5D9D>QA2E3X001<adc8B<L500000ca4@4Dl9002
00001cPU00000000804001P100800003Hm]WnfOK00800004:000000000034005000024/oAai;?dLN
Bcm77T/o000WOol01@00Oomoogoo00000Woo00<007ooOol02Goo00<007ooOol07goo000ROol00`00
IiaWW002Ii`30002EmX00`00CkL00003000_Ool200000`6i000000074Sd00`00C65<P@0200021IX2
000011gK000R70000Rhl0P0000DfG3YL=U`fG00000I6W0<00008E@UE:@00001@j549D@QA2@D00005
B:M4YdRW000lA@02000013@T000000000R`31@0000EWn`00000002P0008000<@00D00003@[d00000
00<00003Aai;7P0002Qoo`05001oogooOol00002Ool00`00Oomoo`07Ool2000ROol0029oo`03001S
W6NL00800003Hm`0000000800005CmL00000;c<0000bOol200002@6H000001Hm4Q`F?A8L5SdB7002
00001Db2000000Ej2I/00P0000@Qo2HL8O`0008^?0800004=S/jG000@Yd2000014JKBYa6VdJL0P00
00=>_00000000P0000aA2@00000004cXC<L004B7B:M4QTRWA8L200001SPU00000000<0@/0`<00004
HkaWg000Io/500001100300@01001@0000I2_DKN@[e2gT:mA]h3000XOol20003Ool01000Oomoo`00
2Goo00<007ooOol08Goo000QOol01`00Ii`00000ImaSg6OL00800003CkL0000000<003Eoo`800003
0KT0000000HB?@D000071I/00000000V728L00000bhl00L003IL000nO4:L?Y`00003AY`00`00C]a>
g003C]`500001Dc8C>P004RWA:L00`000T1V1`000fNl1P0011001P0000U2_D;M@[e2gD:m@]e2_D;M
0000:Woo00<007ooOol00Woo0P002Woo0`008Goo000QOol200001f?LImaSg6OL001?f4^g00800003
<e@007oo03Qoo`800009:00000005SdB71Hm4Q`F?A8L00@000071I/001Gl000V727l00000Rhl00L^
6`00?Wa2WCil@YdnO00400002TkLC[a>g4jlC]a>_000D_aG7E;l300000MSWF=l001S_6OMHkaWg005
000340000``00000000400002T;N@[e6gT:m@]i2_DKN@[e2gP00:goo00<007ooOol0<Woo000QOol0
1000ImaWg6?L0`0000E?]`00000c=00003aoo`8000030KT0000000DB?@80000<0CP000FK000Eg000
9Q`R7000;S`003Im0P0000E2W3il@Y`nW4:L008000E>g0800005EaaFo5LLE_aG7002000015/lFceK
?5mM0P0000ASO6>MHgaSOA@0000:@[e2gD:m@]e2_D;M@[e2gD:m000[Ool00`00Oomoo`0bOol0021o
o`06001Sg6OLHm`005_J0`0000<_<`000000?goo0P0000P1V0004Q`F?A8L5SdB71Hm0`0000<5V`00
5O`00P0000dQo000=W`fOCIl>Wd004:M?Wa2W@00B]e6_00400004TkL001G7E;lEaeBo5LMD_`005/l
GeeK?5mMFc`005mlHieSO0<00003GmaSo5oL00800004900P02@08006000011hm000nWCYl0P0000M2
gT:mA]i2_D;N@[d0000[Ool3000cOol0021oo`05001Wg000001KnP050013Ool400064Sd400025M`0
1000:Ud000000cIm0P0000PnO000A]e:gDKMB]e6gD[M1@0000QG75Kl000005/mFcaOGE/l1@0000AO
_@00GmaSg0<00003900P02@000H000036Qd00000008nO003?YdjO3il00800004@[e2g@00000^Ool0
0`00Oomoo`0aOol001moo`<00003Fo]KfUok00<004Moo`@000054Q`F?A8L5SdB7005000011HL0000
02YM0P0000<fO3Ym=W`00P0000Y:gDJlB]e6_4[MA[`004lMDai?7@/00005GieO_U^M001Og0040000
0b@08000000600002aXL000jO3jM>W`nWCYl?YdjO3jM>W`00P00<7oo00<007ooOol0<Goo000OOol0
1000FmYKne_j0`00Bgoo10001A8m10000QHM00<002YM:Ud0100000<ngP0000000P000156gD[M001C
7DlMDae?7E<M001GGUMMFeiGGEMN001O_EnM009O_@D000038000000000@000068Q`Qo28L8O`003Yl
0Sil00PnWCYl?W`nO3jM>W`nO000<7oo0P00<goo000OOol00`00Fo]KfP02001@Ool300000a8L5SdB
700500001QHL5Qd000009UdZG@800005?[e2gSjm@]hn_@0500002DlMDai?7@00EeeKOUMMFgiGG@0?
00001agk8Q`Mo28L7O/003IL00800009?YdjO3jM>W`nWCYl?YdjO000031oo`8003=oo`007Woo00@0
05_k000005Aoo`@000D>O0H00003<[h^_P0000800004?[dngP00Aal2Aah;00000e>nDkd0000;0000
0b8L8O`R70020004=U`01@00?W`nO3jM>W`00Sil00<007ooOol0<7oo00<007ooOol0<Goo000NOol3
001IOol500001@ik4Y`000003W/00`0000<^WS:o;Yh01@0000U77T/oAah004mnDim?OTmoCgh03@00
01@UnbXL9O/Z70008Q`003YL=U`jG3Hk>U`fG3YL000nWCYl?YdjO000<goo00<007ooOol0<Goo000L
Ool3001POol400023W`30002;[h01000=alg7cLO300000<kVcnK0000100000X^70009Q`UnbHL9O/V
72Gk9Q`000TfG0800003?W`007oo039oo`8003=oo`006goo0`00IGoo2P0000<foc/O=al00P0000<o
Oc]N00000`00010:UP00000b?000:Q/^?2XK;S`Z6bhl000Z72Gk:Q`Un`80000=<S`00000=S/jG3IL
>U`f>cYL=U`jG3Hk0000=Goo00<007ooOol0<Goo000IOol3001/Ool>0004Ool03000=U`b?000;Q/^
72hK;Q`^6bhL000V708000Db?003000fG3IL00DfG003001oogoo03Aoo`04001oogooOol5000[Ool0
09aoo`08000b?000:Q/^?2XK;S`Z6`80000?<S`^>c8l<S/b?2hk<S`b>`00=S/jG3IL>U`f>`0003Mo
o`03001oogoo00=oo`03001oogoo02]oo`00WGoo00D0038l000^6bhL00800004:Q`^?0000007<S`2
00000cIL0000000cOol00`00Oomoo`030005Ool00`00Oomoo`0[Ool009ioo`@0000@;S`Z72hl:Q`^
?2XL000^>c8l<S/b?2hk<S`b>c8l000eOol40007Ool00`00Oomoo`0[Ool009moo`0;000V?@00000^
?2Xl;S`Z72hl:S`00006<S`00`00Oomoo`0`Ool00`00Ool00002000:Ool00`00Oomoo`0[Ool00:1o
o`8000089Sd002hl:Q`^?2XL;S`Z70800004<S`b>`00000^Ool01000Oomoogoo0`0037oo0P00;Goo
002ROol02P009Sd002hl:S`^?2XL;S`Z?2hl0P00<Goo0`00?Woo002SOol01P009Sd00000:Q`^?0<0
02ioo`03001oo`000080045oo`00Y7oo1@00;Goo00<007ooOol00`00A7oo003BOol01000Oomoogoo
0`004Goo1000<Woo003BOol4000DOol00`00Oomoo`0cOol00<ioo`03001oo`00008001Qoo`03001o
ogoo039oo`00bgoo00<007oo00000P0077oo00<007ooOol0<Goo0037Ool00`00Oomoo`03000MOol0
1000Oomoo`00<Woo0033Ool01000Oomoogoo0`008Goo0P00<goo0034Ool4001HOol00<1oo`03001o
o`00008000moo`D004Moo`00_Goo00<007oo00000P0057oo00<007ooOol0Agoo002iOol00`00Oomo
o`03000GOol00`00Oomoo`17Ool00;=oo`04001oogoo0002Ool3000JOol00`00Oomoo`17Ool00;=o
o`03001oogoo00<001eoo`03001oogoo04Moo`00/7oo00<007ooOol00`007goo0P00BGoo002]Ool0
0`00Oomoo`03000@Ool2001KOol00:Yoo`03001oogoo00<0019oo`04001oogoo001JOol00:Eoo`03
001oo`00009oo`<001Eoo`04001oogoo001JOol00:Eoo`03001oo`00008001Qoo`04001oogoo001J
Ool00:Eoo`8001]oo`04001oogoo001JOol00<=oo`8005]oo`00]7oo1@00Igoo002fOol00`00Oomo
o`1WOol00;Ioo`03001oogoo06Moo`00[Woo100017oo00<007ooOol0Igoo002fOol00`00Oomoo`1W
Ool00:Ioo`@000]oo`8006Uoo`00YWoo00<007ooOol0Mgoo002WOol00`00Oomoo`1fOol00:1oo`@0
00Aoo`03001oogoo07Eoo`00YWoo00@007ooOol001Moo`800003Ool0000005Yoo`00Ygoo0P006Goo
00<007oo0000Fgoo0033Ool00`00Oomoo`1JOol00<5oo`800003Ool0000005Yoo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {152.75, 0}} -> {-0.0242472, 0.126595, \
0.00433389, 0.00433389}}]
}, Open  ]],

Cell[TextData[{
  "In the above figure, we observe that the tangent surface is located below \
the surface ",
  StyleBox["h",
    FontSlant->"Italic"],
  ". The tangent surface is plotted for a smaller interval in the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " directions to prevent intersections of ",
  StyleBox["h ",
    FontSlant->"Italic"],
  "and the tangent surface. This example shows that the one-dimensional \
notion of a tangent can be generalized to a two-dimensional version. This \
generalization is not restricted to two dimensions but can be extended to \
higher dimensions. Since the higher-dimensional cases cannot be represented \
easily by graphics, we suppress a further discussion of these tangent \
surfaces."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "This section was intended to show how a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function for a derivative can be defined if we know an appropriate \
mathematical definition. We also notice that not every mathematical \
definition is an efficient definition for an implementation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". An essential point to efficiently implement a mathematical relation in ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a mathematical definition based on structures which are basic elements \
in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In the case of the ",
  StyleBox["TangentVector[]", "MmaText"],
  " function, it was essential that we used the pattern matching of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the replacement rules. The application of such simple operations \
allows us to write refined functions. In the next section, we will come back \
to a derivative already known by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the total derivative."
}], "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.3 The Total Derivative", "Section",
  Evaluatable->False,
  CellTags->"total derivative"],

Cell[TextData[{
  "Let us consider functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  " depending on a set of independent variables ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "= ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\((x\_1\),
                "TraditionalForm"], ",", \(x\_2\)}],
            "TraditionalForm"], ",", "\[Ellipsis]", ",", \(x\_n\)}], 
        TraditionalForm]]],
  ") and a set of dependent variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, 2, \[Ellipsis]\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  " represents all possible derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u = \((u\^1, u\^2, \[Ellipsis], u\^\[Alpha])\)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "with respect to the independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". We are interested in the derivative of these functions with respect to \
all independent variables. If we assume that ",
  StyleBox["u",
    FontSlant->"Italic"],
  " depends on the vector ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", we must consider all derivatives of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  ". In other words, we obtain the total derivative of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "by differentiating ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", while treating all the ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  "'s and their derivatives as functions of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"dependent variables", "independent variables"}],

Cell["Definition: Total derivative", "Definition",
  CellTags->"Definition: Total derivative"],

Cell[TextData[{
  "The total derivative of a function ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, u\_\((k)\))\)]],
  " with respect to the independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " is given by"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(D\_i\) f\), " ", "=", "  ", 
        RowBox[{\(\[PartialD]f\/\[PartialD]x\_i\), "+", 
          StyleBox[
            UnderoverscriptBox[
              StyleBox["\[Sum]",
                ScriptLevel->0,
                FontFamily->"Times",
                FontSize->12,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              \(\[Alpha] = 1\), "q"],
            ScriptLevel->0], 
          StyleBox[
            UnderscriptBox[
              StyleBox["\[Sum]",
                FontFamily->"Times",
                FontSize->8,
                FontWeight->"Plain",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], "J"],
            ScriptLevel->0], " ", 
          \(u\_\(J, i\)\%\[Alpha]\ 
            \[PartialD]f\/\[PartialD]u\_j\%\[Alpha]\)}]}], TextForm]], 
  "NumberedEquation",
  Evaluatable->False,
  FontVariations->{"CompatibilityType"->0},
  CellTags->"eq-7"],

Cell[TextData[{
  "where for ",
  Cell[BoxData[
      \(TraditionalForm\`J = \((j\_1, j\_2, \ \[Ellipsis], j\_j)\)\)]],
  ","
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TextForm
    \`\(u\_\(J, j\)\%\[Alpha]\  = \ 
      \(\[PartialD]u\_j\%\[Alpha]\/\[PartialD]x\_i\  = \ 
        \[PartialD]\^\(l + 1\)u\^\[Alpha]\/\(\[PartialD]x\_i 
            \[PartialD]x\_\(j\_1\) \[PartialD]x\_\(j\_2\) \[CenterEllipsis] 
            \[PartialD]x\_\(j\_l\)\)\), \)\)], "NumberedEquation",
  Evaluatable->False,
  FontVariations->{"CompatibilityType"->0},
  CellTags->"eq-8"],

Cell[TextData[{
  "and the sum in ",
  ButtonBox["(3.7)",
    ButtonData:>"eq-7",
    ButtonStyle->"Hyperlink"],
  "  runs over all ",
  StyleBox["J",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s of order ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(0\  \[LessEqual] \)\  | \(J | \ \( \[LessEqual] \ k\)\)\)]],
  " with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"|", 
          RowBox[{\(J | \), " ", "=", " ", 
            FormBox[\(\[Sum]\_\(i = 1\)\%l j\_i\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ".  ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is the highest order of the derivatives occurring in ",
  StyleBox["f",
    FontSlant->"Italic"],
  ".\[ThickSpace]\[EmptyCircle] "
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " analogue of this definition is available by the function ",
  StyleBox["D[],", "MmaText"],
  "  which ",
  ButtonBox["S. Wolfram [1991]",
    ButtonData:>{"Literat.nb", "Wolf-91"},
    ButtonStyle->"Hyperlink"],
  " calls a partial derivative. Showing the equivalence of both notions, let \
us demonstrate the action of the function ",
  StyleBox["D[]", "MmaText"],
  " by considering a simple example."
}], "Text",
  Evaluatable->False,
  CellTags->"D[]"],

Cell[TextData[{
  "Let us examine a function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", " ", "=", " ", 
          RowBox[{"x", " ", "u", " ", 
            FormBox[\(u\_xy\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`u\  = \ u(x, y)\)]],
  " is a function of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". We apply the function ",
  StyleBox["D[]", "MmaText"],
  " on this expression in two steps. First, we use ",
  StyleBox["x",
    FontSlant->"Italic"],
  " as the variable of differentiation, and in a second step, we \
differentiate with respect to ",
  StyleBox["y",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = x\ u[x, y]\ \[PartialD]\_\(x, y\)u[x, y]; 
    f // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\ x\ u\_\(x, y\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[f, x] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\ u\_\(x, y\) + x\ u\_x\ u\_\(x, y\) + u\ x\ u\_\(x, x, y\)\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[f, y] // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(x\ u\_y\ u\_\(x, y\) + u\ x\ u\_\(x, y, y\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing the results obtained by ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "with the ",
  ButtonBox["definition",
    ButtonData:>"Definition: Complete derivative",
    ButtonStyle->"Hyperlink"],
  " given above demonstrates the equivalence of both notions. Higher-order \
total derivatives are defined by a repeated application of the single \
operator ",
  ButtonBox["(3.7)",
    ButtonData:>"eq-7",
    ButtonStyle->"Hyperlink"],
  " with different variables of differentiation. If ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[
                RowBox[{
                  FormBox[\(J = \((j\_1\)\),
                    "TraditionalForm"], ",", \(j\_2\)}],
                "TraditionalForm"], ",", "\[Ellipsis]", ",", \(j\_m\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " is a ",
  StyleBox["m",
    FontSlant->"Italic"],
  StyleBox["th",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["-",
    FontSlant->"Italic"],
  "order multi-index, with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(1 \[LessEqual] j\_m \[LessEqual] \),
            "TraditionalForm"], "p"}], TraditionalForm]]],
  " for each m, then the ",
  StyleBox["j",
    FontSlant->"Italic"],
  "th total derivative is denoted by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "higher order total derivatives", "multi index", "total derivative"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(D\_J\), " ", "=", " ", 
        RowBox[{
        \(D\_\(j\_1\)\), "\[NegativeVeryThinSpace]", \(D\_\(j\_2\)\), 
          "\[CenterEllipsis]", " ", 
          RowBox[{
            SubscriptBox[
              StyleBox["D",
                FontSlant->"Italic"], \(j\_m\)], "."}]}]}], TextForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "For example, we find the ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(D\_x\),
            "TraditionalForm"], \(D\_y\)}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(D\_y\),
            "TraditionalForm"], \(D\_x\)}], TraditionalForm]]],
  " derivatives by successively applying ",
  Cell[BoxData[
      \(TraditionalForm\`D\_x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_y\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we can realize this by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(df1\  = \ D[D[f, x], y]; df1 // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\_y\ u\_\(x, y\) + x\ u\_\(x, y\)\%2 + x\ u\_y\ u\_\(x, x, y\) + 
      u\ u\_\(x, y, y\) + x\ u\_x\ u\_\(x, y, y\) + 
      u\ x\ u\_\(x, x, y, y\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(df2\  = \ D[D[f, y], x]; df2 // LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(u\_y\ u\_\(x, y\) + x\ u\_\(x, y\)\%2 + x\ u\_y\ u\_\(x, x, y\) + 
      u\ u\_\(x, y, y\) + x\ u\_x\ u\_\(x, y, y\) + 
      u\ x\ u\_\(x, x, y, y\)\)], "Output"]
}, Open  ]],

Cell["\<\
Subtracting both representations of the mixed derivatives from each \
other, we get\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(df1 - df2\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "It is obvious that both expressions contain the same result. This implies  \
that we can commute the ",
  Cell[BoxData[
      \(TraditionalForm\`D\_x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_y\)]],
  ". In general, we can interchange the ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  "\[CloseCurlyQuote]s in the calculation in any order."
}], "Text",
  Evaluatable->False,
  CellTags->"commutation of derivatives"],

Cell["\<\
Another representation of derivatives instrumental in the \
calculation of symmetries is the prolongation. A prolongation is not a \
completely new derivative; however, it introduces a geometrical concept in \
the manifold, allowing a greater flexibility in the use of coordinates.\
\>", 
  "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.4 Prolongations", "Section",
  Evaluatable->False,
  CellTags->{"Prolongations", "prolongation"}],

Cell[TextData[{
  "In the calculation of symmetries, we frequently have to calculate the \
prolongation of a given system of differential equations. Here, we first \
define the term prolongation for a function. In S",
  ButtonBox["ection 3.7,",
    ButtonData:>{"derivat1.nb", "Prolongation of vector fields"},
    ButtonStyle->"Hyperlink"],
  " we will discuss the application of prolongations to vector fields. This \
definition is extended to differential equations in an additional step in S",
  ButtonBox["ection 4.2.5",
    ButtonData:>{"symmet1.nb", "Prolongation of Transformations"},
    ButtonStyle->"Hyperlink"],
  " for ODEs and in S",
  ButtonBox["ection 5.4.1",
    ButtonData:>{"symmet5.nb", "Calculation of prolongations"},
    ButtonStyle->"Hyperlink"],
  " for PDEs. "
}], "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "vector field", "ODE", "PDE"}],

Cell[TextData[{
  "The term prolongation actually means an extension of the space of \
coordinates by their derivatives up to a certain order. As a simple example, \
we can extend or prolong the space of variables ",
  StyleBox["u",
    FontSlant->"Italic"],
  " for a function ",
  Cell[BoxData[
      \(TraditionalForm
      \`u : \ \[DoubleStruckCapitalR]\  \[Rule] \ 
        \[DoubleStruckCapitalR]\)]],
  " by its first derivative. In classical mechanics, such an extension of the \
configuration space with coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " to a space with ",
  StyleBox["u ",
    FontSlant->"Italic"],
  "and",
  StyleBox[" u'",
    FontSlant->"Italic"],
  " as coordinates is known as an extension of the configuration space to \
phase space. A more specific example occurring frequently in mathematical \
physics is given by a vector-valued function u = f(x) = ",
  Cell[BoxData[
      \(TraditionalForm\`\((f\_1\)\)]],
  "(x), \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`f\_m\)]],
  "(x)) with ",
  StyleBox["n",
    FontSlant->"Italic"],
  " independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\( = \((x\_1\)\)\)]],
  ",\[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  ") and ",
  StyleBox["m",
    FontSlant->"Italic"],
  " dependent variables. For such an ",
  StyleBox["n \[Times] m",
    FontSlant->"Italic"],
  " space, the definition of the prolongation reads"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "prolong the space of variables", "extension", "configuration space"}],

Cell["Definition: Prolongation", "Definition",
  CellTags->"Definition: Prolongation"],

Cell[TextData[{
  "For a given vector-valued function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", ":", " ", 
          
          FormBox[\(\[DoubleStruckCapitalR]\^n \[Rule] \ 
              \[DoubleStruckCapitalR]\^m\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", we define the",
  StyleBox[" ",
    FontSlant->"Italic"],
  "k",
  StyleBox["th",
    FontSlant->"Italic"],
  " prolongation of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " by"
}], "Text",
  Evaluatable->False,
  CellTags->"vector valued function"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(pr\^\((k)\)\),
            "TraditionalForm"], \(f(x)\)}], " ", ":=", " ", 
        RowBox[{
          FormBox[\(u\^\((k)\)\),
            "TraditionalForm"], "."}]}], TraditionalForm]]],
"\[ThickSpace]\[EmptyCircle]"], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "This relation means that we have to determine all derivatives of ",
  StyleBox["u ",
    FontSlant->"Italic"],
  "up to a certain order ",
  StyleBox["k",
    FontSlant->"Italic"],
  ". The result of such a calculation is a set of terms containing all \
possible derivatives of ",
  StyleBox["u",
    FontSlant->"Italic"],
  " up to ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th order."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The calculation of the",
  StyleBox[" k",
    FontSlant->"Italic"],
  "th prolongation is in some sense equivalent to the calculation of the \
first ",
  StyleBox["k",
    FontSlant->"Italic"],
  " coefficients in a Taylor expansion of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "at the point ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"calculation of the kth prolongation", "Taylor expansion"}],

Cell[TextData[{
  "Let us demonstrate the calculation of the prolongation for a single \
function ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\  = \ f\) \((x, y, z)\)\)]],
  ". Here, ",
  Cell[BoxData[
      \(TraditionalForm\`n\  = \ 3\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\  = \ 1\)]],
  ". We are looking for the second prolongation of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  "; i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`k\  = \ 2\)]],
  ". We use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to carry out such a calculation. If we do the calculation by hand, we \
have to collect the derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)], "MmaText"],
  " with respect to the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\  = \)\ \) \((x, y, z)\)\)]],
  " up to order 2"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(pr\^\((2)\)\),
            "TraditionalForm"], "f", \((x, y, z)\)}], " ", "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"f", ",", " ", 
              
              FormBox[\(\[PartialD]f\/\[PartialD]x, 
                \[PartialD]f\/\[PartialD]y, \ \[PartialD]f\/\[PartialD]z, 
                \[PartialD]\^2 f\/\(\[PartialD]x \[PartialD]y\), \t\ 
                \[PartialD]\^2 f\/\(\[PartialD]x \[PartialD]z\), \ 
                \(\n\t\[PartialD]\^2 f\)\/\(\[PartialD]y\ \[PartialD]z\), 
                \[PartialD]\^2 f\/\[PartialD]x\^2, 
                \[PartialD]\^2 f\/\[PartialD]y\^2, 
                \[PartialD]\^2 f\/\[PartialD]z\^2\ \),
                "TraditionalForm"]}], ")"}], "."}]}], TextForm]], 
  "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-11"],

Cell[TextData[{
  "This list of terms represents the expansion coefficients of a Taylor \
series of ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "around ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  ". The first few terms can be read off from the following series \
expansion:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[f, x, y, z, x0, y0, z0]; \n
    Normal[Series[f[x, y, z], {x, x0, 1}, \n\t\t{y, y0, 1}, {z, z0, 1}]] // 
      LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(f + \((x - x0)\)\ f\_x0 + 
      \((y - y0)\)\ \((f\_y0 + \((x - x0)\)\ f\_\(x0, y0\))\) + 
      \((z - z0)\)\ 
        \((f\_z0 + \((x - x0)\)\ f\_\(x0, z0\) + 
            \((y - y0)\)\ 
              \((f\_\(y0, z0\) + \((x - x0)\)\ f\_\(x0, y0, z0\))\))\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we do the calculation for the prolongation by applying the function ",
  StyleBox["Outer[]", "MmaText"],
  " in connection with the differentiation ",
  StyleBox["D[]", "MmaText"],
  ". The aim is to reproduce the content of equation ",
  ButtonBox["(3.11)",
    ButtonData:>"eq-11",
    ButtonStyle->"Hyperlink"],
  ". So we have to define a function called ",
  StyleBox["prolongation[]", "MmaText"],
  " using lists as input variables for the functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and the independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The third argument of ",
  StyleBox["prolongation[]", "MmaText"],
  " determines the largest order ",
  StyleBox["k",
    FontSlant->"Italic"],
  " of differentiation:"
}], "Text",
  Evaluatable->False,
  CellTags->{"D[]", "prolongation[]"}],

Cell[BoxData[
    \(prolongation[f_List, x_List, order_] := \n\t
      Block[{aux, dresult}, \n\t\tresult = f; \n\t\taux = result; \n\t\t
        Do[aux = Outer[D, aux, x]; \n\t\t\t
          AppendTo[result, aux], {i, 1, order}]; \n\t\t
        Sort[Union[Flatten[result]], \n\t\t\tderivativeOrder[#1, #2]&]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The function ",
  StyleBox["prolongation[]", "MmaText"],
  " is based on the auxiliary function ",
  StyleBox["derivativeOrder[]", "MmaText"],
  ". This function determines the order of a differential expression. The \
result of ",
  StyleBox["derivativeOrder[]", "MmaText"],
  " influences the sorting of the derivatives in the function ",
  StyleBox["Sort[]", "MmaText"],
  ". ",
  StyleBox["derivativeOrder[]", "MmaText"],
  " allows us to sort the derivatives by an increasing order."
}], "Text",
  Evaluatable->False,
  CellTags->{"derivativeOrder[]", "Sort[]"}],

Cell[BoxData[
    RowBox[{
      RowBox[{\(derivativeOrder[expr1_, expr2_]\), ":=", "\n", "\t", 
        RowBox[{"If", "[", 
          RowBox[{
          \(FreeQ[expr1, Derivative] || \n\t\t\tFreeQ[expr2, Derivative]\), 
            ",", "True", ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"Plus", "[", 
                RowBox[{"expr1", "/.", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["_", 
                        TagBox[\((x___)\),
                          Derivative],
                        MultilineFunction->None], "[", "___", "]"}], 
                    "\[Rule]", "x"}]}], "]"}], "<", "\n", "\t\t\t", 
              RowBox[{"Plus", "[", 
                RowBox[{"expr2", "/.", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["_", 
                        TagBox[\((x___)\),
                          Derivative],
                        MultilineFunction->None], "[", "___", "]"}], 
                    "\[Rule]", "x"}]}], "]"}]}]}], "]"}]}], ";"}]], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The function ",
  StyleBox["derivativeOrder[]", "MmaText"],
  " checks the two arguments ",
  StyleBox["expr1 ",
    FontSlant->"Italic"],
  "and ",
  StyleBox["expr2",
    FontSlant->"Italic"],
  " on derivatives. If the expressions are free of derivatives, the function \
returns ",
  StyleBox["True",
    FontSlant->"Italic"],
  ". If the expressions contain derivatives, the function only returns True \
if the order of the derivatives increases. The application of ",
  StyleBox["prolongation[]", "MmaText"],
  " on ",
  StyleBox["f[x,y,z]", "MmaText"],
  " up to second order gives us the coordinates of the extended space"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(prolongation[{f[x, y, z]}, {x, y, z}, 2] // LieTraditionalForm\)], 
  "Input"],

Cell[BoxData[
    \({f, f\_x, f\_y, f\_z, f\_\(x, x\), f\_\(x, y\), f\_\(x, z\), 
      f\_\(y, y\), f\_\(y, z\), f\_\(z, z\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "From a mathematical point of view, we determined the coordinates of a \
jet-space of order 2 (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "). The ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(pr\^\((k)\)\),
            "TraditionalForm"], \((f(x))\)}], TraditionalForm]]],
  " is also known as the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-jet of ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". The related space of independent and dependent variables extended by the \
derivatives is thus called jet-space. Thus, if ",
  Cell[BoxData[
      \(TraditionalForm\`u = f(x)\)]],
  " is a function whose graph lies in the space of dependent and independent \
variables, the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(pr\^\((k)\)\),
            "TraditionalForm"], \((f(x))\)}], TraditionalForm]]],
  " is a function whose graph lies in the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-jet space."
}], "Text",
  Evaluatable->False,
  CellTags->{"jet-space", "k-jet", "prolongation", "space"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.5 The Fr\[EAcute]chet Derivative", "Section",
  Evaluatable->False,
  CellTags->"The Frechet derivative"],

Cell[TextData[{
  "In the previous sections, we discussed differential operators available in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This section deals with a differential operator instrumental in the \
theory of symmetry analysis. Here, we discuss a generalized derivative and \
its definition in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The derivative is called a Gateaux or Fr\[EAcute]chet derivative. This \
kind of derivative is very useful in the calculations of symmetries (",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Fokas [1980, 1987]",
    ButtonData:>{"Literat.nb", "Fokas-1981"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Fokas and Fuchssteiner [1981], Baumann [1997]",
    ButtonData:>{"Literat.nb", "Fokas-1987"},
    ButtonStyle->"Hyperlink"],
  "). Such a derivative uses not only the steepest descent of a function but \
also puts a weight on it."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}],

Cell["Definition: Fr\[EAcute]chet derivative", "Definition",
  CellTags->"Definition: Frechet derivative"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(f = \(f(x, u\_\((n)\)\)\),
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " be a function in ",
  StyleBox["p",
    FontSlant->"Italic"],
  " independent and ",
  StyleBox["q",
    FontSlant->"Italic"],
  " dependent variables. ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((n)\)\)]],
  " denotes all the derivatives in this function up to order ",
  Cell[BoxData[
      \(TraditionalForm\`n = 0, 1, 2, \[Ellipsis]\)]],
  ". The Fr\[EAcute]chet derivative ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_f\)]],
  " of a function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " based on ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(w(x, u\_\((n)\)\),
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " is defined in such a way that"
}], "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\(\[GothicCapitalD]\_f\)(w)\), " ", "=", " ", 
        RowBox[{
          StyleBox[
            FractionBox["d", 
              StyleBox[
                RowBox[{
                  StyleBox["d",
                    FontFamily->"Times",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Italic",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                  "\[Epsilon]"}]]],
            ScriptLevel->0], " ", \(f(u + \[Epsilon]\ \(w(u)\))\), 
          \(|\_\(\[Epsilon] = 0\)\)}]}], TraditionalForm]]]], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-12"],

Cell[TextData[{
  "holds for all auxiliary functions ",
  StyleBox["w",
    FontSlant->"Italic"],
  ". We call the function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " the support of the Fr\[EAcute]chet derivative and ",
  StyleBox["w",
    FontSlant->"Italic"],
  " the test function.\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->{"test function", "support"}],

Cell[TextData[{
  "The algorithmic content of this definition is that ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[GothicCapitalD]\_f\)(w)\)]],
  " is calculated by replacing ",
  StyleBox["u",
    FontSlant->"Italic"],
  " and all of its derivatives in ",
  StyleBox["f",
    FontSlant->"Italic"],
  " ",
  StyleBox["b",
    FontSlant->"Italic"],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`u + \[Epsilon]\ w\)]],
  ". If we later differentiate the resulting expression with respect to \
\[Epsilon] and set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ", we determined the Fr\[EAcute]chet derivative. The result of these two \
steps is the Fr\[EAcute]chet derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " based on the test function ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ". Using the steps in a pencil calculation for one independent and one \
dependent variable, equation ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  " can be reduced to an explicit expression like"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\[GothicCapitalD]\_f\  = \ 
      \(\(\[Sum]\ \)\+\(k = 0\)\%\[Infinity]\) 
        \(\[PartialD]f\/\[PartialD]u\_\((k)\)\) 
        \(\[PartialD]\^k\/\[PartialD]x\^k . \)\)], "NumberedEquation",
  Evaluatable->False,
  FontSlant->"Plain",
  CellTags->"eq-13"],

Cell[TextData[{
  "In (3.13) ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  " denotes the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th derivative of ",
  StyleBox["u",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The sum in ",
  ButtonBox["(3.13)",
    ButtonData:>"eq-13",
    ButtonStyle->"Hyperlink"],
  " is finite since the order of the largest derivative of the support is \
finite. This is the case in all practical situations."
}], "Text",
  Evaluatable->False,
  CellTags->"support"],

Cell[TextData[{
  "Let us consider as a support function",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              FormBox[\(f = u\_x\),
                "TraditionalForm"], " ", 
              FormBox[\(u\_\(x, x, x\)\),
                "TraditionalForm"]}], " ", "+", " ", 
            FormBox[\(u\_x\%2\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". The Fr\[EAcute]chet derivative with a test function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(w = \(w(x, u\_\(x, x, x\)\)\),
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " contained in the class of support functions ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is given by applying equation ",
  ButtonBox["(3.13)",
    ButtonData:>"eq-13",
    ButtonStyle->"Hyperlink"],
  "  to ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[GothicCapitalD]\_f\)(w)\  = \ 
        \((u\_\(x, x, x\)\  + \ 2\ u\_x)\)\ \(D\_x\) w\  + \ 
          u\_x\ \(D\_\(x, x, x\)\) w\)]],
  ","
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-14"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`D\_x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_\(x, x, x\)\)]],
  " denote the first- and third-order total derivatives. If we choose the \
test  function as ",
  Cell[BoxData[
      \(TraditionalForm\`w = u\_x\%2/2\)]],
  ", we get from relation ",
  ButtonBox["(3.14)",
    ButtonData:>"eq-14",
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`\(\[GothicCapitalD]\_f\)(w)\  = \ 
      \(\((u\_\(x, x, x\)\  + \ 2  u\_x)\)\ u\_x\  = \ 
        \(u\_x\) u\_\(x, x, x\)\  + \ 2\ u\_x\%2\)\)]]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "representing a differential expression containing only derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The definition of the ",
  ButtonBox["Fr\[EAcute]chet derivative",
    ButtonData:>"Definition: Frechet derivative",
    ButtonStyle->"Hyperlink"],
  " given above for one independent and one dependent variable is easily \
generalized to a vector of ",
  StyleBox["r ",
    FontSlant->"Italic"],
  "support functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\(f = \((f\_1\)\),
                "TraditionalForm"], ",", "\[Ellipsis]", ",", \(f\_r\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " and ",
  StyleBox["q",
    FontSlant->"Italic"],
  " test functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                RowBox[{"w", 
                  FormBox[\( = \((w\_1\)\),
                    "TraditionalForm"]}], ",", \(w\_2\)}],
              "TraditionalForm"], ",", " ", "\[Ellipsis]", ",", " ", 
            FormBox[\(w\_q\),
              "TraditionalForm"]}], ")"}], TraditionalForm]]],
  ". Then the Fr\[EAcute]chet derivative of such an ",
  StyleBox["r",
    FontSlant->"Italic"],
  "-tuple is given by the relation"
}], "Text",
  Evaluatable->False,
  CellTags->"vector Frechet derivative"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\(\[GothicCapitalD]\_f\)(w)\), " ", "=", " ", 
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox["d", 
                StyleBox[
                  RowBox[{
                    StyleBox["d",
                      FontFamily->"Times",
                      FontSize->10,
                      FontWeight->"Roman",
                      FontSlant->"Italic",
                      FontTracking->"Plain",
                      PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                    "\[Epsilon]"}]]],
              ScriptLevel->0], 
            RowBox[{"(", GridBox[{
                  {
                    \(\(f\_1\)(u\_1 + \[Epsilon]\ w\_1, u\_2, \[Ellipsis], 
                        u\_r) + \[CenterEllipsis] + 
                      \(f\_1\)(u\_1, u\_2, \[Ellipsis], 
                        u\_r + \[Epsilon]\ w\_r)\)},
                  {
                    \(\(f\_2\)(u\_1 + \[Epsilon]\ w\_1, u\_2, \[Ellipsis], 
                        u\_r) + \[CenterEllipsis] + 
                      \(f\_2\)(u\_1, u\_2, \[Ellipsis], 
                        u\_r + \[Epsilon]\ w\_r)\)},
                  {"\[VerticalEllipsis]"},
                  {
                    \(\(f\_r\)(u\_1 + \[Epsilon]\ w\_1, u\_2, \[Ellipsis], 
                        u\_r) + \[CenterEllipsis] + 
                      \(f\_r\)(u\_1, u\_2, \[Ellipsis], 
                        u\_r + \[Epsilon]\ w\_r)\)}
                  }], ")"}]}], " ", \( | \_\(\[Epsilon] = 0\)\), "."}]}], 
      TraditionalForm]]]], "NumberedEquation",
  CellTags->"eq-16add"],

Cell[TextData[{
  "Introducing the ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " test functions as a column vector allows us to define the ",
  StyleBox["q",
    FontSlant->"Italic"],
  "\[Times]",
  StyleBox["r",
    FontSlant->"Italic"],
  " matrix differential operator"
}], "Text",
  Evaluatable->False,
  CellTags->"matrix differential operator"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(\((\(\[GothicCapitalD]\_f\)(w))\)\_\[Mu]\[Alpha]\), " ", "=", " ", 
          RowBox[{
            FractionBox["d", 
              StyleBox[
                RowBox[{
                  StyleBox["d",
                    FontFamily->"Times",
                    FontSize->10,
                    FontWeight->"Roman",
                    FontSlant->"Italic",
                    FontTracking->"Plain",
                    PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
                  "\[Epsilon]"}]]], 
            \(\(f\_\[Mu]\)(u\_\[Alpha] + \ \[Epsilon]\ \(\(w\_\[Alpha]\)(u)\))
              \), " ", \(|\_\(\[Epsilon] = 0\)\)}]}], " ", ",", "       ", 
        \(\[Mu] = 1\), ",", "\[Ellipsis]", ",", "r", ",", "    ", 
        \(\[Alpha] = 1\), ",", "\[Ellipsis]", ",", "q"}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-16"],

Cell["\<\
This expression is equivalent to the matrix differential operator \
\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\(\((\[GothicCapitalD]\_f)\)\_\[Mu]\[Alpha]\  = \ 
        \[Sum]\+J\ \[PartialD]f\_\[Mu]\/\[PartialD]u\_J\%\[Alpha]\ D\_J, 
      \ \ \ \ \ \(\[Mu] = \)\ \[InvisibleComma] 1, \[Ellipsis], r; 
      \ \ \ \ \ \ \[Alpha] = 1, \[Ellipsis], \(q . \)\)\)], "NumberedEquation",\

  Evaluatable->False,
  CellTags->"eq-17"],

Cell[TextData[{
  "The sum in ",
  ButtonBox["(3.18)",
    ButtonData:>"eq-17",
    ButtonStyle->"Hyperlink"],
  " extends over all multi-indices ",
  StyleBox["J",
    FontSlant->"Italic"],
  ". To define the Fr\[EAcute]chet derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we use relation ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  " and its matrix version ",
  ButtonBox["(3.16)",
    ButtonData:>"eq-16add",
    ButtonStyle->"Hyperlink"],
  ". We note again that the ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  " and all their derivatives are replaced by ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  " + \[Epsilon]\[ThinSpace]",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Alpha]\)]],
  ". After the replacement of the arguments, we differentiate with respect to \
\[Epsilon] and set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  " in the next step. The result in the general case is a matrix containing \
the derivatives of the support ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " based on the test functions ",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Alpha]\)]],
  ". The implementation of the Fr\[EAcute]chet derivative in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(FrechetD[support_List, dependVar_List, \n\tindependVar_List, 
        testfunction_List] := \n\t
      Block[{indep, frechet, deriv, \[Epsilon], r0, x1, x2}, \n\t\tr0 = 
          Function[indep, x1 + \[Epsilon]\ x2]; \n\t\tfrechet = {}; 
        Do[deriv = {}; \n\t\t\tDo[
            AppendTo[
              deriv, \[PartialD]\_\[Epsilon]\((support\[LeftDoubleBracket]
                        j\[RightDoubleBracket] /. \n\t\t\t\t\t\t\t\tdependVar\
\[LeftDoubleBracket]
                          i\[RightDoubleBracket] \[Rule] \((r0 /. \n\t{indep \
\[Rule] independVar, \n\tx1 \[Rule] 
                                dependVar\[LeftDoubleBracket]
                                    i\[RightDoubleBracket] @@ 
                                  independVar, \n\t
                              x2 \[Rule] 
                                testfunction\[LeftDoubleBracket]
                                    i\[RightDoubleBracket] @@ 
                                  independVar})\))\) /. \[Epsilon] \[Rule] 
                  0], \n\t\t\t\t{i, 1, Length[support]}]; \n\t\t\tAppendTo[
            frechet, deriv], \n\t\t\t{j, 1, 
            Length[support]}]; \n\t\tfrechet]\)], "Input",
  PageWidth->Infinity,
  CellTags->{"FrechetD", "FrechetD[]"}],

Cell[TextData[{
  "The code of the Fr\[EAcute]chet derivative follows closely the relation \
given in equation ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  ". In ",
  StyleBox["FrechetD[],", "MmaText"],
  " we first define a pure function stored in the variable ",
  StyleBox["r",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\_0\)]],
  StyleBox[".",
    FontSlant->"Italic"],
  " This function serves as a general pattern to replace the original \
argument by a varied argument. A loop extending over the number of dependent \
variables replaces the independent and dependent variables. This step creates \
an explicit rule for the replacement. After the replacement, a \
differentiation with respect to the parameter \[Epsilon] is performed and, at \
the end, \[Epsilon] is replaced by zero. The resulting expressions are \
collected in the list ",
  StyleBox["frechet",
    FontSlant->"Italic"],
  " which is returned by the function. An example will demonstrate the \
application of the function."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "In FrechetD[]", "pure function", "dependent variables", 
    "independent variables"}],

Cell["Example 1", "Example"],

Cell["\<\
Consider a set of two expressions representing a system of partial \
differential equations given by\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        AdjustmentBox["  ",
          BoxMargins->{{0, 0}, {-0.740741, 0.740741}},
          BoxBaselineShift->0.740741], 
        RowBox[{
          FormBox[\(v\_x\  - \ u\  = \ 0\),
            "TraditionalForm"], ",", 
          AdjustmentBox["\n",
            BoxMargins->{{0, 0}, {0.592593, -0.592593}},
            BoxBaselineShift->-0.592593], 
          FormBox[
            RowBox[{
              FormBox[\(v\_t\  - \ u\_x\/\(u\^2\ \)\  = \ 0\),
                "TraditionalForm"], ","}],
            "TextForm"]}]}], TextForm]], "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-18"],

Cell[TextData[{
  "where ",
  StyleBox["u",
    FontSlant->"Italic"],
  " and ",
  StyleBox["v",
    FontSlant->"Italic"],
  " are functions of ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "and",
  StyleBox[" t.",
    FontSlant->"Italic"],
  " This set of equations is equivalent to a non-linear diffusion equation in \
",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ". Our aim is to calculate the Fr\[EAcute]chet derivative of the left-hand \
side of the system ",
  ButtonBox["(3.19).",
    ButtonData:>"eq-18",
    ButtonStyle->"Hyperlink"],
  " Let us define a variable ",
  StyleBox["eqsys",
    FontSlant->"Italic"],
  " containing the left-hand side of the equations:"
}], "Text",
  Evaluatable->False,
  CellTags->"nonlinear diffusion equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqsys = {\[PartialD]\_x v[x, t] - u[x, t], 
        \[PartialD]\_t v[x, t] - \[PartialD]\_x u[x, t]\/u[x, t]\^2}; 
    eqsys // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({\(-u\) + v\_x, \(-\(u\_x\/u\^2\)\) + v\_t}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The application of our function ",
  StyleBox["FrechetD[]", "MmaText"],
  " to this expression gives us"
}], "Text",
  CellTags->"FrechetD[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FrechetD[eqsys, {u, v}, {x, t}, {w1, w2}] // \n\tMatrixForm\) // 
      LieTraditionalForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-w1\), \(w2\_x\)},
            {
              StyleBox[\(\(2\ w1\ u\_x\)\/u\^3 - w1\_x\/u\^2\),
                ScriptLevel->0], \(w2\_t\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The calculation of the Fr\[EAcute]chet derivative using ",
  StyleBox["FrechetD[]", "MmaText"],
  " is carried out by supplying four arguments containing the equations: the \
dependent variables of the support, the independent variables, and the test \
functions ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\_2\)]],
  ". The result is a 2 \[Times] 2 matrix containing expressions of ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\_2\)]],
  " and their derivatives. From the result, we can get the corresponding \
operators if we consider ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\_2\)]],
  " as auxiliary functions. The related matrix operator reads"
}], "Text",
  Evaluatable->False,
  CellTags->{"support", "matrix operator"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", GridBox[{
              {\(-1\), \(\[PartialD]\_x\)},
              {
                RowBox[{
                  StyleBox[
                    FractionBox[
                      RowBox[{"2", "  ", 
                        SuperscriptBox[\(u\_x\), 
                          TagBox["",
                            Derivative],
                          MultilineFunction->None]}], \(u\^3\)],
                    ScriptLevel->0], 
                  StyleBox["-",
                    ScriptLevel->0], 
                  RowBox[{
                    StyleBox[
                      FractionBox[
                        SuperscriptBox["1", 
                          TagBox["",
                            Derivative],
                          MultilineFunction->None], \(u\^2\)],
                      
                      ScriptLevel->
                        0], \(\[PartialD]\_x\)}]}], \(\[PartialD]\_t\)}
              }], ")"}], "."}], TextForm]], "NumberedEquation"],

Cell[TextData[{
  "In our symmetry calculations, we sometimes need also the adjoint \
representation of the Fr\[EAcute]chet derivative. In general, the adjoint \
representation of a differential operator is defined via an integral \
expression. Assume that we know the differential operator ",
  ButtonBox["(3.12)",
    ButtonData:>"eq-12",
    ButtonStyle->"Hyperlink"],
  ". We denote the adjoint operator of ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_f\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[GothicCapitalD]\_f\%*\)\)]],
  " satisfying"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "adjoint representation", "adjoint Frechet derivative", "adjoint operator"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            
            FormBox[\(\[Integral]\_\[CapitalOmega]\ 
                V\ \(\[GothicCapitalD]\_f\) W\),
              "TraditionalForm"], \(\[DifferentialD]x\)}], "  ", "=", " ", 
          RowBox[{
            
            FormBox[\(\[Integral]\_\[CapitalOmega]\ 
                W\ \(\[GothicCapitalD]\_f\%*\) V\),
              "TraditionalForm"], \(\[DifferentialD]x\)}]}], 
        TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Equation (3.21) holds for any pair of functions ",
  StyleBox["W",
    FontSlant->"Italic"],
  " and ",
  StyleBox["V",
    FontSlant->"Italic"],
  ". If we examine definition (3.21) in more detail, we can replace the \
integral operation by a plain differential representation (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "). The corresponding expression to ",
  ButtonBox["(3.18) ",
    ButtonData:>"eq-17",
    ButtonStyle->"Hyperlink"],
  "is given by"
}], "Text",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(\((\(\[GothicCapitalD]\_f\%*\))\)\_\[Mu]\[Alpha]\), " ", "=", 
          RowBox[{
            StyleBox[\(\[Sum]\+J\),
              ScriptLevel->0], 
            RowBox[{\(\((\(-1\))\)\^J\), " ", 
              RowBox[{\(D\_J\), "(", 
                StyleBox[\(\[PartialD]f\_\[Mu]\/\[PartialD]u\_J\%\[Alpha]\),
                  ScriptLevel->0], ")"}]}]}]}], ",", "      ", \(\[Mu] = 1\), 
        ",", "\[Ellipsis]", ",", \(r; \ \ \ \[Alpha] = 1\), ",", 
        "\[Ellipsis]", ",", " ", \(q . \)}], TraditionalForm]]]], 
  "NumberedEquation",
  Evaluatable->False,
  CellTags->{"eq-20", "adjoint Frechet derivative"}],

Cell[TextData[{
  "In view of an algorithm in ",
  StyleBox["Mathematica, ",
    FontSlant->"Italic"],
  "this means that we convert derivatives of the test functions to \
derivatives of the support multiplied by some coefficients. This is strictly \
the definition of an adjoint differential operator. The described procedure \
is implemented in the following function ",
  StyleBox["AdjointFrechetD[]:", "MmaText"]
}], "Text",
  Evaluatable->False,
  CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}],

Cell[BoxData[
    RowBox[{\(AdjointFrechetD[support_List, dependVar_List, \n\t
        independVar_List, testfunction_List]\), ":=", "\n", "\t", 
      RowBox[{"Block", "[", 
        RowBox[{\({subrule, $testf, frechet, n, b}\), ",", "\n", "\t\t", 
          RowBox[{
            RowBox[{"subrule", "=", 
              RowBox[{
                RowBox[{"b_.", " ", 
                  RowBox[{
                    SuperscriptBox["$testf", 
                      TagBox[\((n___)\),
                        Derivative],
                      MultilineFunction->None], "@@", "independVar"}]}], 
                "\[RuleDelayed]", "\n", 
                "\t\t\t\t", \(\((\(-1\))\)\^Plus @@ {n}\ \[IndentingNewLine]\
\[PartialD]\_\(Delete[Thread[{independVar, {n}}], 0]\)\((b\ $testf @@ 
                          independVar)\)\)}]}], ";", "\n", 
            "\t\t", \(frechet = 
              FrechetD[support, dependVar, \n\t\t\t\tindependVar, 
                testfunction]\), ";", "\n", 
            "\t\t", \(Do[
              frechet = 
                frechet /. \n\t\t\t\t\t\((subrule /. $testf \[Rule] 
                        testfunction\[LeftDoubleBracket]
                          i\[RightDoubleBracket])\), \n\t\t\t{i, 1, 
                Length[testfunction]}]\), ";", "\n", 
            "\t\t", \(frechet = Transpose[frechet]\)}]}], "]"}]}]], "Input",
  PageWidth->Infinity,
  PageBreakWithin->Automatic,
  PageBreakBelow->True,
  CellTags->"AdjointFrechetD[]"],

Cell[TextData[{
  "The adjoint representation of the Fr\[EAcute]chet derivative of the system \
",
  StyleBox["eqsys",
    FontSlant->"Italic"],
  " is thus given by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(AdjointFrechetD[eqsys, {u, v}, {x, t}, \n\t{w1, w2}] // MatrixForm
        \) // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-w1\), 
              FormBox[
                StyleBox[\(w1\_x\/u\^2\),
                  ScriptLevel->0],
                "StandardForm"]},
            {\(-w2\_x\), \(-w2\_t\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"derivat1.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{658, 668},
WindowMargins->{{130, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->38,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Derivatives", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Ordinary and Partial Derivatives", "Tangent Vector", 
                "The Total Derivative", "Prolongations", 
                "The Fr\[EAcute]chet Derivative"}, #]&)], FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellBracket->True,
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "differential operators"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "ordinary differentiation"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}],
    Cell[103556, 3203, 1248, 32, 129, "Text",
      Evaluatable->False,
      CellTags->"ordinary differentiation"]},
  "total differential"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "Frechet derivative"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}],
    Cell[345517, 11152, 970, 34, 63, "Text",
      Evaluatable->False,
      CellTags->"Frechet derivative"],
    Cell[349627, 11294, 981, 32, 44, "Text",
      Evaluatable->False,
      CellTags->"Frechet derivative"]},
  "Euler-Lagrange derivative"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "prolongation"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}],
    Cell[331708, 10714, 105, 2, 43, "Section",
      Evaluatable->False,
      CellTags->{"Prolongations", "prolongation"}],
    Cell[331816, 10718, 880, 19, 78, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}],
    Cell[342868, 11069, 1266, 41, 95, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "LieTraditionalForm[]"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "traditional form"->{
    Cell[2351, 63, 1809, 37, 199, "Text",
      PageBreakBelow->False,
      CellTags->{
      "differential operators", "ordinary differentiation", 
        "total differential", "Frechet derivative", 
        "Euler-Lagrange derivative", "prolongation", "LieTraditionalForm[]", 
        "traditional form"}]},
  "Ordinary and partial derivatives"->{
    Cell[4185, 104, 391, 6, 43, "Section",
      Evaluatable->False,
      CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Ordinary and partial derivatives"]},
  "calculus"->{
    Cell[4579, 112, 1120, 21, 146, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Gauss"->{
    Cell[4579, 112, 1120, 21, 146, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Leibniz"->{
    Cell[4579, 112, 1120, 21, 146, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Newton"->{
    Cell[4579, 112, 1120, 21, 146, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "slope"->{
    Cell[4579, 112, 1120, 21, 146, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "derivative"->{
    Cell[4579, 112, 1120, 21, 146, "Text",
      Evaluatable->False,
      CellTags->{
      "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}]},
  "Definition: Ordinary derivative"->{
    Cell[5702, 135, 100, 1, 33, "Definition",
      CellTags->"Definition: Ordinary derivative"]},
  "trigonometric function"->{
    Cell[6534, 163, 1248, 32, 146, "Text",
      Evaluatable->False,
      CellTags->"trigonometric function"],
    Cell[15416, 469, 1059, 31, 95, "Text",
      Evaluatable->False,
      CellTags->"trigonometric function"]},
  "symbolic calculation"->{
    Cell[8190, 219, 275, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"symbolic calculation"]},
  "ordinary differential"->{
    Cell[8623, 237, 992, 30, 78, "Text",
      Evaluatable->False,
      CellTags->{"ordinary differential", "independent variable"}]},
  "independent variable"->{
    Cell[8623, 237, 992, 30, 78, "Text",
      Evaluatable->False,
      CellTags->{"ordinary differential", "independent variable"}]},
  "geometrical interpretation"->{
    Cell[9618, 269, 1294, 36, 131, "Text",
      Evaluatable->False,
      CellTags->{"geometrical interpretation", "Limit[]"}]},
  "Limit[]"->{
    Cell[9618, 269, 1294, 36, 131, "Text",
      Evaluatable->False,
      CellTags->{"geometrical interpretation", "Limit[]"}]},
  "pure function"->{
    Cell[13913, 422, 841, 23, 26, "Text",
      Evaluatable->False,
      CellTags->"pure function"],
    Cell[359081, 11575, 1199, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "tangent"->{
    Cell[34894, 1081, 1617, 55, 112, "Text",
      Evaluatable->False,
      CellTags->{"tangent", "envelope"}]},
  "envelope"->{
    Cell[34894, 1081, 1617, 55, 112, "Text",
      Evaluatable->False,
      CellTags->{"tangent", "envelope"}]},
  "differentiation of a product"->{
    Cell[84307, 2573, 812, 21, 76, "Text",
      Evaluatable->False,
      CellTags->"differentiation of a product"]},
  "rational function"->{
    Cell[85401, 2611, 358, 8, 43, "Text",
      CellTags->{"rational function", "differentiation of the ratio"}]},
  "differentiation of the ratio"->{
    Cell[85401, 2611, 358, 8, 43, "Text",
      CellTags->{"rational function", "differentiation of the ratio"}]},
  "chain rule of Leibniz"->{
    Cell[85998, 2633, 188, 5, 26, "Text",
      Evaluatable->False,
      CellTags->"chain rule of Leibniz"]},
  "partial derivativ"->{
    Cell[86909, 2670, 1180, 22, 160, "Text",
      Evaluatable->False,
      CellTags->"partial derivativ"]},
  "Definition: Partial derivative"->{
    Cell[88092, 2694, 98, 1, 30, "Definition",
      CellTags->"Definition: Partial derivative"]},
  "partial derivative"->{
    Cell[89268, 2733, 1619, 54, 110, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "D[]"}],
    Cell[94246, 2908, 1416, 48, 78, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "order of differentiation"}]},
  "D[]"->{
    Cell[89268, 2733, 1619, 54, 110, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "D[]"}],
    Cell[325441, 10476, 538, 16, 65, "Text",
      Evaluatable->False,
      CellTags->"D[]"],
    Cell[338939, 10952, 911, 28, 86, "Text",
      Evaluatable->False,
      CellTags->{"D[]", "prolongation[]"}]},
  "higher order derivatives"->{
    Cell[92216, 2838, 170, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"higher order derivatives"]},
  "Definition: kth order derivative"->{
    Cell[93378, 2875, 165, 6, 33, "Definition",
      CellTags->"Definition: kth order derivative"]},
  "order of differentiation"->{
    Cell[94246, 2908, 1416, 48, 78, "Text",
      Evaluatable->False,
      CellTags->{"partial derivative", "order of differentiation"}]},
  "variational derivative"->{
    Cell[96466, 2988, 638, 13, 95, "Text",
      Evaluatable->False,
      CellTags->{"variational derivative", "Euler derivative"}]},
  "Euler derivative"->{
    Cell[96466, 2988, 638, 13, 95, "Text",
      Evaluatable->False,
      CellTags->{"variational derivative", "Euler derivative"}]},
  "tangent vector"->{
    Cell[97141, 3006, 89, 2, 43, "Section",
      Evaluatable->False,
      CellTags->"tangent vector"],
    Cell[97233, 3010, 1816, 53, 129, "Text",
      Evaluatable->False,
      CellTags->{"measure", "tangent vector", "symmetry analysis"}],
    Cell[99145, 3068, 500, 15, 27, "Text",
      Evaluatable->False,
      CellTags->"tangent vector"],
    Cell[108387, 3354, 848, 29, 61, "Text",
      Evaluatable->False,
      CellTags->{"scalar product", "tangent vector"}]},
  "measure"->{
    Cell[97233, 3010, 1816, 53, 129, "Text",
      Evaluatable->False,
      CellTags->{"measure", "tangent vector", "symmetry analysis"}]},
  "symmetry analysis"->{
    Cell[97233, 3010, 1816, 53, 129, "Text",
      Evaluatable->False,
      CellTags->{"measure", "tangent vector", "symmetry analysis"}],
    Cell[344287, 11119, 1118, 28, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Definition: Tangent vector"->{
    Cell[99052, 3065, 90, 1, 33, "Definition",
      CellTags->"Definition: Tangent vector"]},
  "eq-4"->{
    Cell[99648, 3085, 607, 18, 35, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-4"]},
  "directional derivative"->{
    Cell[100703, 3122, 205, 5, 44, "Text",
      Evaluatable->False,
      CellTags->"directional derivative"]},
  "eq-5"->{
    Cell[100911, 3129, 530, 18, 36, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-5"]},
  "operator"->{
    Cell[101444, 3149, 1856, 45, 182, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}]},
  "independent variables"->{
    Cell[101444, 3149, 1856, 45, 182, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}],
    Cell[320614, 10311, 1953, 68, 114, "Text",
      Evaluatable->False,
      CellTags->{"dependent variables", "independent variables"}],
    Cell[359081, 11575, 1199, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "input"->{
    Cell[101444, 3149, 1856, 45, 182, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}]},
  "TangentVector[]"->{
    Cell[101444, 3149, 1856, 45, 182, "Text",
      Evaluatable->False,
      CellTags->{
      "operator", "independent variables", "input", "TangentVector[]"}],
    Cell[105073, 3248, 1338, 40, 98, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[106720, 3301, 342, 9, 48, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[110988, 3444, 613, 14, 82, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[112489, 3490, 390, 12, 46, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"],
    Cell[319305, 10272, 1172, 30, 148, "Text",
      Evaluatable->False,
      CellTags->"TangentVector[]"]},
  "scalar product"->{
    Cell[108387, 3354, 848, 29, 61, "Text",
      Evaluatable->False,
      CellTags->{"scalar product", "tangent vector"}]},
  "superposition"->{
    Cell[109785, 3410, 575, 18, 61, "Text",
      Evaluatable->False,
      CellTags->"superposition"]},
  "components of the tangent vector"->{
    Cell[110363, 3430, 622, 12, 78, "Text",
      Evaluatable->False,
      CellTags->{"components of the tangent vector", "tangent surface"}]},
  "tangent surface"->{
    Cell[110363, 3430, 622, 12, 78, "Text",
      Evaluatable->False,
      CellTags->{"components of the tangent vector", "tangent surface"}],
    Cell[114369, 3545, 620, 17, 44, "Text",
      Evaluatable->False,
      CellTags->"tangent surface"]},
  "TangentSurface[]"->{
    Cell[114992, 3564, 360, 7, 112, "Input",
      CellTags->"TangentSurface[]"],
    Cell[115355, 3573, 566, 20, 46, "Text",
      Evaluatable->False,
      CellTags->"TangentSurface[]"]},
  "total derivative"->{
    Cell[320514, 10307, 97, 2, 43, "Section",
      Evaluatable->False,
      CellTags->"total derivative"],
    Cell[327464, 10559, 1475, 46, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "higher order total derivatives", "multi index", "total derivative"}]},
  "dependent variables"->{
    Cell[320614, 10311, 1953, 68, 114, "Text",
      Evaluatable->False,
      CellTags->{"dependent variables", "independent variables"}],
    Cell[359081, 11575, 1199, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "Definition: Total derivative"->{
    Cell[322570, 10381, 94, 1, 33, "Definition",
      CellTags->"Definition: Total derivative"]},
  "eq-7"->{
    Cell[322939, 10395, 1155, 31, 54, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-7"]},
  "eq-8"->{
    Cell[324259, 10436, 415, 9, 41, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-8"]},
  "higher order total derivatives"->{
    Cell[327464, 10559, 1475, 46, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "higher order total derivatives", "multi index", "total derivative"}]},
  "multi index"->{
    Cell[327464, 10559, 1475, 46, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "higher order total derivatives", "multi index", "total derivative"}]},
  "commutation of derivatives"->{
    Cell[330879, 10686, 459, 14, 45, "Text",
      Evaluatable->False,
      CellTags->"commutation of derivatives"]},
  "Prolongations"->{
    Cell[331708, 10714, 105, 2, 43, "Section",
      Evaluatable->False,
      CellTags->{"Prolongations", "prolongation"}]},
  "vector field"->{
    Cell[331816, 10718, 880, 19, 78, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}]},
  "ODE"->{
    Cell[331816, 10718, 880, 19, 78, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}]},
  "PDE"->{
    Cell[331816, 10718, 880, 19, 78, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "vector field", "ODE", "PDE"}]},
  "prolong the space of variables"->{
    Cell[332699, 10739, 1621, 50, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "prolong the space of variables", "extension", 
        "configuration space"}]},
  "extension"->{
    Cell[332699, 10739, 1621, 50, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "prolong the space of variables", "extension", 
        "configuration space"}]},
  "configuration space"->{
    Cell[332699, 10739, 1621, 50, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "prolong the space of variables", "extension", 
        "configuration space"}]},
  "Definition: Prolongation"->{
    Cell[334323, 10791, 86, 1, 33, "Definition",
      CellTags->"Definition: Prolongation"]},
  "vector valued function"->{
    Cell[334412, 10794, 561, 21, 27, "Text",
      Evaluatable->False,
      CellTags->"vector valued function"]},
  "calculation of the kth prolongation"->{
    Cell[335780, 10847, 474, 17, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the kth prolongation", "Taylor expansion"}]},
  "Taylor expansion"->{
    Cell[335780, 10847, 474, 17, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "calculation of the kth prolongation", "Taylor expansion"}]},
  "eq-11"->{
    Cell[337173, 10897, 931, 23, 69, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-11"]},
  "prolongation[]"->{
    Cell[338939, 10952, 911, 28, 86, "Text",
      Evaluatable->False,
      CellTags->{"D[]", "prolongation[]"}]},
  "derivativeOrder[]"->{
    Cell[340204, 10991, 586, 15, 67, "Text",
      Evaluatable->False,
      CellTags->{"derivativeOrder[]", "Sort[]"}]},
  "Sort[]"->{
    Cell[340204, 10991, 586, 15, 67, "Text",
      Evaluatable->False,
      CellTags->{"derivativeOrder[]", "Sort[]"}]},
  "jet-space"->{
    Cell[342868, 11069, 1266, 41, 95, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "k-jet"->{
    Cell[342868, 11069, 1266, 41, 95, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "space"->{
    Cell[342868, 11069, 1266, 41, 95, "Text",
      Evaluatable->False,
      CellTags->{"jet-space", "k-jet", "prolongation", "space"}]},
  "The Frechet derivative"->{
    Cell[344171, 11115, 113, 2, 43, "Section",
      Evaluatable->False,
      CellTags->"The Frechet derivative"]},
  "generalized derivative"->{
    Cell[344287, 11119, 1118, 28, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Gateaux"->{
    Cell[344287, 11119, 1118, 28, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Frechet"->{
    Cell[344287, 11119, 1118, 28, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}]},
  "Definition: Frechet derivative"->{
    Cell[345408, 11149, 106, 1, 33, "Definition",
      CellTags->"Definition: Frechet derivative"]},
  "eq-12"->{
    Cell[346490, 11188, 760, 20, 33, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-12"]},
  "test function"->{
    Cell[347253, 11210, 394, 13, 44, "Text",
      Evaluatable->False,
      CellTags->{"test function", "support"}]},
  "support"->{
    Cell[347253, 11210, 394, 13, 44, "Text",
      Evaluatable->False,
      CellTags->{"test function", "support"}],
    Cell[349060, 11271, 564, 21, 45, "Text",
      Evaluatable->False,
      CellTags->"support"],
    Cell[362841, 11703, 937, 27, 97, "Text",
      Evaluatable->False,
      CellTags->{"support", "matrix operator"}]},
  "eq-13"->{
    Cell[348755, 11261, 302, 8, 41, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-13"]},
  "eq-14"->{
    Cell[350611, 11328, 275, 9, 23, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-14"]},
  "vector Frechet derivative"->{
    Cell[351587, 11364, 1415, 43, 79, "Text",
      Evaluatable->False,
      CellTags->"vector Frechet derivative"]},
  "eq-16add"->{
    Cell[353005, 11409, 1639, 37, 59, "NumberedEquation",
      CellTags->"eq-16add"]},
  "matrix differential operator"->{
    Cell[354647, 11448, 360, 13, 27, "Text",
      Evaluatable->False,
      CellTags->"matrix differential operator"]},
  "eq-16"->{
    Cell[355010, 11463, 945, 23, 35, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-16"]},
  "eq-17"->{
    Cell[356075, 11494, 359, 8, 43, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-17"]},
  "FrechetD"->{
    Cell[357806, 11550, 1272, 23, 217, "Input",
      CellTags->{"FrechetD", "FrechetD[]"}]},
  "FrechetD[]"->{
    Cell[357806, 11550, 1272, 23, 217, "Input",
      CellTags->{"FrechetD", "FrechetD[]"}],
    Cell[362219, 11678, 161, 5, 29, "Text",
      CellTags->"FrechetD[]"]},
  "In FrechetD[]"->{
    Cell[359081, 11575, 1199, 30, 131, "Text",
      Evaluatable->False,
      CellTags->{
      "In FrechetD[]", "pure function", "dependent variables", 
        "independent variables"}]},
  "eq-18"->{
    Cell[360463, 11615, 692, 20, 45, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-18"]},
  "nonlinear diffusion equation"->{
    Cell[361158, 11637, 762, 28, 61, "Text",
      Evaluatable->False,
      CellTags->"nonlinear diffusion equation"]},
  "matrix operator"->{
    Cell[362841, 11703, 937, 27, 97, "Text",
      Evaluatable->False,
      CellTags->{"support", "matrix operator"}]},
  "adjoint representation"->{
    Cell[364818, 11761, 707, 18, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "adjoint representation", "adjoint Frechet derivative", 
        "adjoint operator"}]},
  "adjoint Frechet derivative"->{
    Cell[364818, 11761, 707, 18, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "adjoint representation", "adjoint Frechet derivative", 
        "adjoint operator"}],
    Cell[366662, 11820, 703, 16, 41, "NumberedEquation",
      Evaluatable->False,
      CellTags->{"eq-20", "adjoint Frechet derivative"}]},
  "adjoint operator"->{
    Cell[364818, 11761, 707, 18, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "adjoint representation", "adjoint Frechet derivative", 
        "adjoint operator"}]},
  "eq-20"->{
    Cell[366662, 11820, 703, 16, 41, "NumberedEquation",
      Evaluatable->False,
      CellTags->{"eq-20", "adjoint Frechet derivative"}]},
  "adjoint differential operator"->{
    Cell[367368, 11838, 518, 11, 63, "Text",
      Evaluatable->False,
      CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}]},
  "AdjointFrechetD[]"->{
    Cell[367368, 11838, 518, 11, 63, "Text",
      Evaluatable->False,
      CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}],
    Cell[367889, 11851, 1471, 31, 187, "Input",
      PageBreakWithin->Automatic,
      PageBreakBelow->True,
      CellTags->"AdjointFrechetD[]"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"differential operators", 372163, 11972},
  {"ordinary differentiation", 372507, 11980},
  {"total differential", 372962, 11991},
  {"Frechet derivative", 373300, 11999},
  {"Euler-Lagrange derivative", 373865, 12013},
  {"prolongation", 374197, 12021},
  {"LieTraditionalForm[]", 374936, 12038},
  {"traditional form", 375272, 12046},
  {"Ordinary and partial derivatives", 375624, 12054},
  {"calculus", 376002, 12062},
  {"Gauss", 376176, 12067},
  {"Leibniz", 376352, 12072},
  {"Newton", 376527, 12077},
  {"slope", 376701, 12082},
  {"derivative", 376880, 12087},
  {"Definition: Ordinary derivative", 377080, 12092},
  {"trigonometric function", 377209, 12095},
  {"symbolic calculation", 377462, 12102},
  {"ordinary differential", 377599, 12106},
  {"independent variable", 377763, 12110},
  {"geometrical interpretation", 377933, 12114},
  {"Limit[]", 378078, 12118},
  {"pure function", 378229, 12122},
  {"tangent", 378537, 12131},
  {"envelope", 378667, 12135},
  {"differentiation of a product", 378817, 12139},
  {"rational function", 378961, 12143},
  {"differentiation of the ratio", 379112, 12146},
  {"chain rule of Leibniz", 379256, 12149},
  {"partial derivativ", 379392, 12153},
  {"Definition: Partial derivative", 379540, 12157},
  {"partial derivative", 379665, 12160},
  {"D[]", 379935, 12167},
  {"higher order derivatives", 380297, 12177},
  {"Definition: kth order derivative", 380451, 12181},
  {"order of differentiation", 380585, 12184},
  {"variational derivative", 380755, 12188},
  {"Euler derivative", 380914, 12192},
  {"tangent vector", 381071, 12196},
  {"measure", 381561, 12209},
  {"symmetry analysis", 381727, 12213},
  {"Definition: Tangent vector", 382070, 12221},
  {"eq-4", 382177, 12224},
  {"directional derivative", 382314, 12228},
  {"eq-5", 382439, 12232},
  {"operator", 382563, 12236},
  {"independent variables", 382756, 12241},
  {"input", 383263, 12254},
  {"TangentVector[]", 383450, 12259},
  {"scalar product", 384169, 12279},
  {"superposition", 384316, 12283},
  {"components of the tangent vector", 384461, 12287},
  {"tangent surface", 384629, 12291},
  {"TangentSurface[]", 384904, 12298},
  {"total derivative", 385118, 12304},
  {"dependent variables", 385422, 12312},
  {"Definition: Total derivative", 385789, 12321},
  {"eq-7", 385900, 12324},
  {"eq-8", 386022, 12328},
  {"higher order total derivatives", 386168, 12332},
  {"multi index", 386355, 12337},
  {"commutation of derivatives", 386557, 12342},
  {"Prolongations", 386697, 12346},
  {"vector field", 386843, 12350},
  {"ODE", 386991, 12354},
  {"PDE", 387139, 12358},
  {"prolong the space of variables", 387314, 12362},
  {"extension", 387510, 12368},
  {"configuration space", 387716, 12374},
  {"Definition: Prolongation", 387927, 12380},
  {"vector valued function", 388052, 12383},
  {"calculation of the kth prolongation", 388210, 12387},
  {"Taylor expansion", 388391, 12392},
  {"eq-11", 388561, 12397},
  {"prolongation[]", 388693, 12401},
  {"derivativeOrder[]", 388834, 12405},
  {"Sort[]", 388970, 12409},
  {"jet-space", 389109, 12413},
  {"k-jet", 389261, 12417},
  {"space", 389413, 12421},
  {"The Frechet derivative", 389582, 12425},
  {"generalized derivative", 389729, 12429},
  {"Gateaux", 389913, 12434},
  {"Frechet", 390097, 12439},
  {"Definition: Frechet derivative", 390304, 12444},
  {"eq-12", 390419, 12447},
  {"test function", 390550, 12451},
  {"support", 390684, 12455},
  {"eq-13", 391035, 12465},
  {"eq-14", 391157, 12469},
  {"vector Frechet derivative", 391299, 12473},
  {"eq-16add", 391434, 12477},
  {"matrix differential operator", 391558, 12480},
  {"eq-16", 391692, 12484},
  {"eq-17", 391815, 12488},
  {"FrechetD", 391940, 12492},
  {"FrechetD[]", 392052, 12495},
  {"In FrechetD[]", 392242, 12500},
  {"eq-18", 392446, 12506},
  {"nonlinear diffusion equation", 392592, 12510},
  {"matrix operator", 392736, 12514},
  {"adjoint representation", 392887, 12518},
  {"adjoint Frechet derivative", 393104, 12524},
  {"adjoint operator", 393452, 12533},
  {"eq-20", 393648, 12539},
  {"adjoint differential operator", 393827, 12543},
  {"AdjointFrechetD[]", 393997, 12547}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 301, 4, 94, "ChapterLine",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2043, 57, 305, 4, 155, "Title",
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2351, 63, 1809, 37, 199, "Text",
  PageBreakBelow->False,
  CellTags->{
  "differential operators", "ordinary differentiation", "total differential", 
    "Frechet derivative", "Euler-Lagrange derivative", "prolongation", 
    "LieTraditionalForm[]", "traditional form"}],

Cell[CellGroupData[{
Cell[4185, 104, 391, 6, 43, "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 3}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Ordinary and partial derivatives"],
Cell[4579, 112, 1120, 21, 146, "Text",
  Evaluatable->False,
  CellTags->{
  "calculus", "Gauss", "Leibniz", "Newton", "slope", "derivative"}],
Cell[5702, 135, 100, 1, 33, "Definition",
  CellTags->"Definition: Ordinary derivative"],
Cell[5805, 138, 331, 11, 27, "Text",
  Evaluatable->False],
Cell[6139, 151, 392, 10, 35, "NumberedEquation"],
Cell[6534, 163, 1248, 32, 146, "Text",
  Evaluatable->False,
  CellTags->"trigonometric function"],
Cell[7785, 197, 71, 2, 22, "Input"],
Cell[7859, 201, 145, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8029, 211, 103, 2, 33, "Input"],
Cell[8135, 215, 40, 1, 23, "Output"]
}, Open  ]],
Cell[8190, 219, 275, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"symbolic calculation"],

Cell[CellGroupData[{
Cell[8490, 229, 75, 2, 22, "Input"],
Cell[8568, 233, 40, 1, 23, "Output"]
}, Open  ]],
Cell[8623, 237, 992, 30, 78, "Text",
  Evaluatable->False,
  CellTags->{"ordinary differential", "independent variable"}],
Cell[9618, 269, 1294, 36, 131, "Text",
  Evaluatable->False,
  CellTags->{"geometrical interpretation", "Limit[]"}],
Cell[10915, 307, 64, 2, 21, "Input"],

Cell[CellGroupData[{
Cell[11004, 313, 103, 2, 30, "Input"],
Cell[11110, 317, 72, 1, 33, "Output"]
}, Open  ]],
Cell[11197, 321, 456, 14, 43, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11678, 339, 97, 2, 21, "Input"],
Cell[11778, 343, 127, 3, 24, "Output"]
}, Open  ]],
Cell[11920, 349, 282, 10, 43, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12227, 363, 70, 2, 21, "Input"],
Cell[12300, 367, 205, 5, 33, "Output"]
}, Open  ]],
Cell[12520, 375, 760, 23, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13305, 402, 96, 2, 21, "Input"],
Cell[13404, 406, 494, 13, 24, "Output"]
}, Open  ]],
Cell[13913, 422, 841, 23, 26, "Text",
  Evaluatable->False,
  CellTags->"pure function"],

Cell[CellGroupData[{
Cell[14779, 449, 109, 2, 21, "Input"],
Cell[14891, 453, 510, 13, 24, "Output"]
}, Open  ]],
Cell[15416, 469, 1059, 31, 95, "Text",
  Evaluatable->False,
  CellTags->"trigonometric function"],
Cell[16478, 502, 71, 2, 22, "Input"],
Cell[16552, 506, 673, 27, 44, "Text",
  Evaluatable->False],
Cell[17228, 535, 64, 2, 22, "Input"],
Cell[17295, 539, 85, 2, 22, "Input"],
Cell[17383, 543, 363, 13, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17771, 560, 240, 5, 102, "Input"],
Cell[18014, 567, 16865, 511, 162, 6045, 372, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False,
  ImageCacheValid->False]
}, Open  ]],
Cell[34894, 1081, 1617, 55, 112, "Text",
  Evaluatable->False,
  CellTags->{"tangent", "envelope"}],

Cell[CellGroupData[{
Cell[36536, 1140, 295, 6, 124, "Input"],
Cell[36834, 1148, 26104, 821, 186, 9491, 610, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False,
  ImageCacheValid->False]
}, Open  ]],
Cell[62953, 1972, 567, 15, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[63545, 1991, 257, 5, 91, "Input"],
Cell[63805, 1998, 20115, 557, 186, 6201, 379, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False,
  ImageCacheValid->False]
}, Open  ]],
Cell[83935, 2558, 369, 13, 43, "Text",
  Evaluatable->False],
Cell[84307, 2573, 812, 21, 76, "Text",
  Evaluatable->False,
  CellTags->"differentiation of a product"],
Cell[85122, 2596, 67, 2, 21, "Input"],

Cell[CellGroupData[{
Cell[85214, 2602, 118, 3, 21, "Input"],
Cell[85335, 2607, 51, 1, 24, "Output"]
}, Open  ]],
Cell[85401, 2611, 358, 8, 43, "Text",
  CellTags->{"rational function", "differentiation of the ratio"}],

Cell[CellGroupData[{
Cell[85784, 2623, 135, 4, 32, "Input"],
Cell[85922, 2629, 61, 1, 35, "Output"]
}, Open  ]],
Cell[85998, 2633, 188, 5, 26, "Text",
  Evaluatable->False,
  CellTags->"chain rule of Leibniz"],

Cell[CellGroupData[{
Cell[86211, 2642, 108, 2, 21, "Input"],
Cell[86322, 2646, 44, 1, 24, "Output"]
}, Open  ]],
Cell[86381, 2650, 525, 18, 60, "Text",
  Evaluatable->False],
Cell[86909, 2670, 1180, 22, 160, "Text",
  Evaluatable->False,
  CellTags->"partial derivativ"],
Cell[88092, 2694, 98, 1, 30, "Definition",
  CellTags->"Definition: Partial derivative"],
Cell[88193, 2697, 643, 23, 43, "Text",
  Evaluatable->False],
Cell[88839, 2722, 426, 9, 40, "NumberedEquation"],
Cell[89268, 2733, 1619, 54, 110, "Text",
  Evaluatable->False,
  CellTags->{"partial derivative", "D[]"}],

Cell[CellGroupData[{
Cell[90912, 2791, 112, 2, 22, "Input"],
Cell[91027, 2795, 45, 1, 24, "Output"]
}, Open  ]],
Cell[91087, 2799, 621, 17, 60, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[91733, 2820, 420, 12, 22, "Input"],
Cell[92156, 2834, 45, 1, 23, "Output"]
}, Open  ]],
Cell[92216, 2838, 170, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"higher order derivatives"],

Cell[CellGroupData[{
Cell[92411, 2847, 326, 9, 22, "Input"],
Cell[92740, 2858, 51, 1, 23, "Output"]
}, Open  ]],
Cell[92806, 2862, 569, 11, 95, "Text",
  Evaluatable->False],
Cell[93378, 2875, 165, 6, 33, "Definition",
  CellTags->"Definition: kth order derivative"],
Cell[93546, 2883, 460, 17, 28, "Text",
  Evaluatable->False],
Cell[94009, 2902, 234, 4, 41, "NumberedEquation"],
Cell[94246, 2908, 1416, 48, 78, "Text",
  Evaluatable->False,
  CellTags->{"partial derivative", "order of differentiation"}],
Cell[95665, 2958, 572, 17, 61, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[96262, 2979, 123, 3, 22, "Input"],
Cell[96388, 2984, 63, 1, 23, "Output"]
}, Open  ]],
Cell[96466, 2988, 638, 13, 95, "Text",
  Evaluatable->False,
  CellTags->{"variational derivative", "Euler derivative"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[97141, 3006, 89, 2, 43, "Section",
  Evaluatable->False,
  CellTags->"tangent vector"],
Cell[97233, 3010, 1816, 53, 129, "Text",
  Evaluatable->False,
  CellTags->{"measure", "tangent vector", "symmetry analysis"}],
Cell[99052, 3065, 90, 1, 33, "Definition",
  CellTags->"Definition: Tangent vector"],
Cell[99145, 3068, 500, 15, 27, "Text",
  Evaluatable->False,
  CellTags->"tangent vector"],
Cell[99648, 3085, 607, 18, 35, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-4"],
Cell[100258, 3105, 442, 15, 27, "Text",
  Evaluatable->False],
Cell[100703, 3122, 205, 5, 44, "Text",
  Evaluatable->False,
  CellTags->"directional derivative"],
Cell[100911, 3129, 530, 18, 36, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],
Cell[101444, 3149, 1856, 45, 182, "Text",
  Evaluatable->False,
  CellTags->{
  "operator", "independent variables", "input", "TangentVector[]"}],
Cell[103303, 3196, 250, 5, 82, "Input"],
Cell[103556, 3203, 1248, 32, 129, "Text",
  Evaluatable->False,
  CellTags->"ordinary differentiation"],

Cell[CellGroupData[{
Cell[104829, 3239, 143, 3, 22, "Input"],
Cell[104975, 3244, 83, 1, 23, "Output"]
}, Open  ]],
Cell[105073, 3248, 1338, 40, 98, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{
Cell[106436, 3292, 228, 3, 52, "Input"],
Cell[106667, 3297, 38, 1, 23, "Output"]
}, Open  ]],
Cell[106720, 3301, 342, 9, 48, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],

Cell[CellGroupData[{
Cell[107087, 3314, 97, 2, 37, "Input"],
Cell[107187, 3318, 1185, 33, 38, "Output"]
}, Open  ]],
Cell[108387, 3354, 848, 29, 61, "Text",
  Evaluatable->False,
  CellTags->{"scalar product", "tangent vector"}],

Cell[CellGroupData[{
Cell[109260, 3387, 85, 2, 22, "Input"],
Cell[109348, 3391, 59, 1, 23, "Output"]
}, Open  ]],
Cell[109422, 3395, 82, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[109529, 3400, 118, 3, 22, "Input"],
Cell[109650, 3405, 120, 2, 23, "Output"]
}, Open  ]],
Cell[109785, 3410, 575, 18, 61, "Text",
  Evaluatable->False,
  CellTags->"superposition"],
Cell[110363, 3430, 622, 12, 78, "Text",
  Evaluatable->False,
  CellTags->{"components of the tangent vector", "tangent surface"}],
Cell[110988, 3444, 613, 14, 82, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],
Cell[111604, 3460, 420, 7, 127, "Input"],
Cell[112027, 3469, 247, 8, 29, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[112299, 3481, 117, 3, 37, "Input"],
Cell[112419, 3486, 55, 1, 23, "Output"]
}, Open  ]],
Cell[112489, 3490, 390, 12, 46, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"],
Cell[112882, 3504, 554, 10, 78, "Text",
  Evaluatable->False],
Cell[113439, 3516, 927, 27, 22, "NumberedEquation",
  Evaluatable->False],
Cell[114369, 3545, 620, 17, 44, "Text",
  Evaluatable->False,
  CellTags->"tangent surface"],
Cell[114992, 3564, 360, 7, 112, "Input",
  CellTags->"TangentSurface[]"],
Cell[115355, 3573, 566, 20, 46, "Text",
  Evaluatable->False,
  CellTags->"TangentSurface[]"],

Cell[CellGroupData[{
Cell[115946, 3597, 74, 2, 22, "Input"],
Cell[116023, 3601, 48, 1, 23, "Output"]
}, Open  ]],
Cell[116086, 3605, 248, 12, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[116359, 3621, 162, 3, 32, "Input"],
Cell[116524, 3626, 64338, 1470, 175, 26004, 991, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[180877, 5099, 307, 9, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[181209, 5112, 101, 2, 32, "Input"],
Cell[181313, 5116, 104, 2, 33, "Output"]
}, Open  ]],
Cell[181432, 5121, 128, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[181585, 5129, 150, 4, 37, "Input"],
Cell[181738, 5135, 49461, 1161, 168, 20018, 792, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[231214, 6299, 309, 10, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[231548, 6313, 190, 4, 22, "Input"],
Cell[231741, 6319, 86721, 3927, 162, 71206, 3731, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[318477, 10249, 825, 21, 112, "Text",
  Evaluatable->False],
Cell[319305, 10272, 1172, 30, 148, "Text",
  Evaluatable->False,
  CellTags->"TangentVector[]"]
}, Open  ]],

Cell[CellGroupData[{
Cell[320514, 10307, 97, 2, 43, "Section",
  Evaluatable->False,
  CellTags->"total derivative"],
Cell[320614, 10311, 1953, 68, 114, "Text",
  Evaluatable->False,
  CellTags->{"dependent variables", "independent variables"}],
Cell[322570, 10381, 94, 1, 33, "Definition",
  CellTags->"Definition: Total derivative"],
Cell[322667, 10384, 269, 9, 28, "Text",
  Evaluatable->False],
Cell[322939, 10395, 1155, 31, 54, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-7"],
Cell[324097, 10428, 159, 6, 28, "Text",
  Evaluatable->False],
Cell[324259, 10436, 415, 9, 41, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-8"],
Cell[324677, 10447, 761, 27, 44, "Text",
  Evaluatable->False],
Cell[325441, 10476, 538, 16, 65, "Text",
  Evaluatable->False,
  CellTags->"D[]"],
Cell[325982, 10494, 834, 31, 64, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[326841, 10529, 130, 3, 22, "Input"],
Cell[326974, 10534, 51, 1, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[327062, 10540, 85, 2, 22, "Input"],
Cell[327150, 10544, 97, 2, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[327284, 10551, 85, 2, 22, "Input"],
Cell[327372, 10555, 77, 1, 23, "Output"]
}, Open  ]],
Cell[327464, 10559, 1475, 46, 78, "Text",
  Evaluatable->False,
  CellTags->{
  "higher order total derivatives", "multi index", "total derivative"}],
Cell[328942, 10607, 381, 11, 24, "NumberedEquation",
  Evaluatable->False],
Cell[329326, 10620, 620, 24, 45, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[329971, 10648, 106, 2, 22, "Input"],
Cell[330080, 10652, 183, 3, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[330300, 10660, 106, 2, 22, "Input"],
Cell[330409, 10664, 183, 3, 24, "Output"]
}, Open  ]],
Cell[330607, 10670, 129, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[330761, 10678, 65, 2, 22, "Input"],
Cell[330829, 10682, 35, 1, 23, "Output"]
}, Open  ]],
Cell[330879, 10686, 459, 14, 45, "Text",
  Evaluatable->False,
  CellTags->"commutation of derivatives"],
Cell[331341, 10702, 330, 7, 61, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[331708, 10714, 105, 2, 43, "Section",
  Evaluatable->False,
  CellTags->{"Prolongations", "prolongation"}],
Cell[331816, 10718, 880, 19, 78, "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "vector field", "ODE", "PDE"}],
Cell[332699, 10739, 1621, 50, 129, "Text",
  Evaluatable->False,
  CellTags->{
  "prolong the space of variables", "extension", "configuration space"}],
Cell[334323, 10791, 86, 1, 33, "Definition",
  CellTags->"Definition: Prolongation"],
Cell[334412, 10794, 561, 21, 27, "Text",
  Evaluatable->False,
  CellTags->"vector valued function"],
Cell[334976, 10817, 354, 10, 22, "NumberedEquation",
  Evaluatable->False],
Cell[335333, 10829, 444, 16, 44, "Text",
  Evaluatable->False],
Cell[335780, 10847, 474, 17, 44, "Text",
  Evaluatable->False,
  CellTags->{"calculation of the kth prolongation", "Taylor expansion"}],
Cell[336257, 10866, 913, 29, 78, "Text",
  Evaluatable->False],
Cell[337173, 10897, 931, 23, 69, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-11"],
Cell[338107, 10922, 324, 11, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[338456, 10937, 168, 3, 52, "Input"],
Cell[338627, 10942, 297, 7, 38, "Output"]
}, Open  ]],
Cell[338939, 10952, 911, 28, 86, "Text",
  Evaluatable->False,
  CellTags->{"D[]", "prolongation[]"}],
Cell[339853, 10982, 348, 7, 127, "Input"],
Cell[340204, 10991, 586, 15, 67, "Text",
  Evaluatable->False,
  CellTags->{"derivativeOrder[]", "Sort[]"}],
Cell[340793, 11008, 1109, 26, 82, "Input"],
Cell[341905, 11036, 682, 20, 82, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[342612, 11060, 98, 2, 22, "Input"],
Cell[342713, 11064, 140, 2, 23, "Output"]
}, Open  ]],
Cell[342868, 11069, 1266, 41, 95, "Text",
  Evaluatable->False,
  CellTags->{"jet-space", "k-jet", "prolongation", "space"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[344171, 11115, 113, 2, 43, "Section",
  Evaluatable->False,
  CellTags->"The Frechet derivative"],
Cell[344287, 11119, 1118, 28, 112, "Text",
  Evaluatable->False,
  CellTags->{
  "symmetry analysis", "generalized derivative", "Gateaux", "Frechet"}],
Cell[345408, 11149, 106, 1, 33, "Definition",
  CellTags->"Definition: Frechet derivative"],
Cell[345517, 11152, 970, 34, 63, "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],
Cell[346490, 11188, 760, 20, 33, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-12"],
Cell[347253, 11210, 394, 13, 44, "Text",
  Evaluatable->False,
  CellTags->{"test function", "support"}],
Cell[347650, 11225, 1102, 34, 96, "Text",
  Evaluatable->False],
Cell[348755, 11261, 302, 8, 41, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-13"],
Cell[349060, 11271, 564, 21, 45, "Text",
  Evaluatable->False,
  CellTags->"support"],
Cell[349627, 11294, 981, 32, 44, "Text",
  Evaluatable->False,
  CellTags->"Frechet derivative"],
Cell[350611, 11328, 275, 9, 23, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-14"],
Cell[350889, 11339, 447, 16, 44, "Text",
  Evaluatable->False],
Cell[351339, 11357, 245, 5, 22, "NumberedEquation",
  Evaluatable->False],
Cell[351587, 11364, 1415, 43, 79, "Text",
  Evaluatable->False,
  CellTags->"vector Frechet derivative"],
Cell[353005, 11409, 1639, 37, 59, "NumberedEquation",
  CellTags->"eq-16add"],
Cell[354647, 11448, 360, 13, 27, "Text",
  Evaluatable->False,
  CellTags->"matrix differential operator"],
Cell[355010, 11463, 945, 23, 35, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-16"],
Cell[355958, 11488, 114, 4, 27, "Text",
  Evaluatable->False],
Cell[356075, 11494, 359, 8, 43, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-17"],
Cell[356437, 11504, 1366, 44, 95, "Text",
  Evaluatable->False],
Cell[357806, 11550, 1272, 23, 217, "Input",
  CellTags->{"FrechetD", "FrechetD[]"}],
Cell[359081, 11575, 1199, 30, 131, "Text",
  Evaluatable->False,
  CellTags->{
  "In FrechetD[]", "pure function", "dependent variables", 
    "independent variables"}],
Cell[360283, 11607, 28, 0, 29, "Example"],
Cell[360314, 11609, 146, 4, 27, "Text",
  Evaluatable->False],
Cell[360463, 11615, 692, 20, 45, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-18"],
Cell[361158, 11637, 762, 28, 61, "Text",
  Evaluatable->False,
  CellTags->"nonlinear diffusion equation"],

Cell[CellGroupData[{
Cell[361945, 11669, 179, 3, 36, "Input"],
Cell[362127, 11674, 77, 1, 32, "Output"]
}, Open  ]],
Cell[362219, 11678, 161, 5, 29, "Text",
  CellTags->"FrechetD[]"],

Cell[CellGroupData[{
Cell[362405, 11687, 148, 3, 37, "Input"],
Cell[362556, 11692, 270, 8, 46, "Output"]
}, Open  ]],
Cell[362841, 11703, 937, 27, 97, "Text",
  Evaluatable->False,
  CellTags->{"support", "matrix operator"}],
Cell[363781, 11732, 1034, 27, 49, "NumberedEquation"],
Cell[364818, 11761, 707, 18, 63, "Text",
  Evaluatable->False,
  CellTags->{
  "adjoint representation", "adjoint Frechet derivative", 
    "adjoint operator"}],
Cell[365528, 11781, 552, 17, 24, "NumberedEquation",
  Evaluatable->False],
Cell[366083, 11800, 576, 18, 61, "Text",
  Evaluatable->False],
Cell[366662, 11820, 703, 16, 41, "NumberedEquation",
  Evaluatable->False,
  CellTags->{"eq-20", "adjoint Frechet derivative"}],
Cell[367368, 11838, 518, 11, 63, "Text",
  Evaluatable->False,
  CellTags->{"adjoint differential operator", "AdjointFrechetD[]"}],
Cell[367889, 11851, 1471, 31, 187, "Input",
  PageBreakWithin->Automatic,
  PageBreakBelow->True,
  CellTags->"AdjointFrechetD[]"],
Cell[369363, 11884, 200, 7, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[369588, 11895, 134, 2, 37, "Input"],
Cell[369725, 11899, 308, 10, 46, "Output"]
}, Open  ]],
Cell[370048, 11912, 148, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

