(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    120224,       3855]*)
(*NotebookOutlinePosition[    148026,       4518]*)
(*  CellTagsIndexPosition[    143514,       4415]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["4.3 Symmetry Transformations of Differential Equations", "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 8}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Symmetry Transformations of Differential Equations"],

Cell["\<\
In this section, we collect the main tools for determining the \
symmetries of differential equations. We define the notion of symmetry for a \
differential equation and discuss the main properties of the symmetry group. \
Using these definitions, we interactively calculate the infinitesimal \
symmetries of differential equations. We also introduce the notion of \
canonical variables useful in deriving the solution of a differential \
equation. Let us first start with the definition of a symmetry group.\
\>", \
"Text",
  CellTags->{
  "differential equation", "main properties of a symmetry group", 
    "canonical variables"}],

Cell[CellGroupData[{

Cell["4.3.1 Definition of a Symmetry Group", "Subsection",
  CellTags->"Definition of a symmetry group"],

Cell[TextData[{
  "Let \[GothicCapitalG] be a group of point transformations and let ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalG]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalG]\_2, \[Ellipsis]\)]],
  " be its first, second, \[Ellipsis] prolongation. Then, we define the \
symmetry of a differential equation as"
}], "Text",
  CellTags->{
  "point transformation", "prolongation", 
    "symmetry of a differential equation"}],

Cell["Definition: Symmetry of a differential equation", "Definition",
  CellTags->"Definition: Symmetry of a differential equation"],

Cell[TextData[{
  "A group \[GothicCapitalG] of point transformations is a symmetry group of \
an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th-order ordinary differential equation"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CapitalDelta]", "(", 
          RowBox[{"x", ",", \(u(x)\), ",", 
            FractionBox[
              StyleBox["du",
                FontSlant->"Italic"], 
              StyleBox["dx",
                FontSlant->"Italic"]], ",", "\[Ellipsis]", ",", 
            FractionBox[\(\(d\^n\) u\), 
              SuperscriptBox[
                StyleBox["dx",
                  FontSlant->"Italic"], "n"]]}], ")"}], " ", "=", " ", "0"}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "or (4.9) admits \[GothicCapitalG] if the ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th extended manifold ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalM]\^n\)]],
  " is invariant with respect to the ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th prolongation ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalG]\_n\)]],
  " of the group \[GothicCapitalG].\[ThickSpace]\[EmptyCircle]"
}], "Text"],

Cell["\<\
This definition actually contains the special case for first-order \
ordinary differential equations. For this special type of equation, we will \
discuss the application of the definition. A first-order differential \
equation\
\>", "Text",
  CellTags->"first-order ordinary differential equation"],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta](x, u(x), u' \((x)\))\  = \ 0\)], 
  "NumberedEquation",
  CellTags->"eq-2"],

Cell[TextData[{
  "admits a group \[GothicCapitalG] if the once extended manifold ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalM]\^1\)]],
  ", the surface in the space ",
  Cell[BoxData[
      \(TraditionalForm\`x, u, u'\)]],
  ", is invariant with respect to the first prolongation ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalG]\_1\)]],
  " of \[GothicCapitalG]. This means that equation ",
  ButtonBox["(4.10)",
    ButtonData:>"eq-2",
    ButtonStyle->"Hyperlink"],
  " is invariant under the coordinate transformation ",
  Cell[BoxData[
      \(TraditionalForm\`X = X(x, u, \[Epsilon])\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`U = U(x, u, \[Epsilon])\)]],
  ". The invariance condition can be formulated as"
}], "Text",
  CellTags->{"manifold", "first prolongation", "invariance condition"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[CapitalDelta](X, U, U')\  = \ \(\[CapitalDelta](x, u, u') . \)\)], 
  "NumberedEquation",
  CellTags->"eq-3"],

Cell[TextData[{
  "This kind of relation also holds for the general case of an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th-order equation. Lie demonstrated that the invariance condition of the \
differential equation has a direct consequence for the solutions. He \
summarized this behavior in a theorem which is one of the main properties of \
a symmetry group."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.2 Main Properties of Symmetry Groups", "Subsection",
  CellTags->"Main properties of symmetry groups"],

Cell[TextData[{
  "Let us consider again the case of an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th-order ordinary differential equation. We represent the equation in such \
a way that ",
  Cell[BoxData[
      FormBox[
        FractionBox[\(\(d\^n\) u\), 
          SuperscriptBox[
            StyleBox["dx",
              FontSlant->"Italic"], "n"]], TraditionalForm]]],
  " is the left hand side of the general expression. The general equation \
reads"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[\(\(d\^n\) u\), 
            SuperscriptBox[
              StyleBox["dx",
                FontSlant->"Italic"], "n"]], " ", "=", " ", 
          \(f(x, u(x), u' \((x)\), \[Ellipsis], \(u\_\((n - 1)\)\)(x))\)}], 
        ","}], TraditionalForm]], "NumberedEquation",
  CellTags->"eq-4"],

Cell[TextData[{
  "with a smooth function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " depending on the derivatives up to (",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  ")st order, ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((n - 1)\)\)]],
  ". The main property of a symmetry group first proved by ",
  ButtonBox["Lie in 1891",
    ButtonData:>{"Literat.nb", "Sche-1891"},
    ButtonStyle->"Hyperlink"],
  " is the following (cf. Scheffers and ",
  ButtonBox["Lie [1891]",
    ButtonData:>{"Literat.nb", "Sche-1891"},
    ButtonStyle->"Hyperlink"],
  "  p. 352, Theorem 1):"
}], "Text",
  CellTags->"main property of a symmetry group"],

Cell["Theorem: Symmetry transformation", "Theorem",
  CellTags->"Theorem: Symmetry Transformation"],

Cell[TextData[{
  "A group \[GothicCapitalG] is a symmetry group of an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th-order ordinary differential equation if and only if \[GothicCapitalG]  \
converts any solution of the equation"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[\(\(d\^n\) u\), 
          SuperscriptBox[
            StyleBox["dx",
              FontSlant->"Italic"], "n"]], " ", "=", " ", 
        \(f(x, u(x), u' \((x)\), \[Ellipsis], \(u\_\((n - 1)\)\)(x))\)}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[
"into a solution of the same equation.\[ThickSpace]\[EmptyCircle]"], "Text"],

Cell[TextData[
"This theorem is one of the cornerstones of Lie\[CloseCurlyQuote]s theory. It \
serves as the starting point for the calculation of the symmetries."], "Text",\

  CellTags->"calculation of the symmetries"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.3 Calculation of the Infinitesimal Symmetries", "Subsection",
  CellTags->"Calculation of the infinitesimal symmetries"],

Cell[TextData[{
  "We already mentioned that a sufficient condition for invariance is the \
vanishing of the extended tangent vector field applied to the differential \
equation, meaning that we use the condition ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(pr\^\((k)\)\) \(\(v\&\[RightVector]\)(\[CapitalDelta])\)\)]],
  " as the defining equation for the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  ". This condition follows from the invariance of the differential equations \
",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " under the transformation of independent and dependent variables. The \
derivation of this invariance criterion follows from a similar calculation as \
presented for functions in S",
  ButtonBox["ection 4.2.3",
    ButtonData:>{"symmet1.nb", "invariace condition"},
    ButtonStyle->"Hyperlink"],
  ". The invariance condition of the tangent vector field supplies a system \
of equations serving as the determining system for the infinitesimals. We \
will see that this system is linear but coupled in ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  ". As mentioned in S",
  ButtonBox["ection 3.7,",
    ButtonData:>{"derivat1.nb", "Prolongation of vector fields"},
    ButtonStyle->"Hyperlink"],
  " the invariance condition is closely related to the prolongation of the \
vector field."
}], "Text",
  CellTags->{
  "sufficient condition for invariance", "infinitesimals", 
    "invariance of a differential equation", "transformation", 
    "tangent vector field"}],

Cell[TextData[{
  "Before discussing the application, let us describe the algorithm of \
constructing infinitesimal symmetries. For first-order equations, it is known \
that an infinite number of symmetries always exists (cf. ",
  ButtonBox["Stephani [1989]",
    ButtonData:>{"Literat.nb", "Step-89"},
    ButtonStyle->"Hyperlink"],
  "). For special cases, however, we find so-called conformal symmetries \
which are a subset of the possible symmetries (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Hydon [1994]",
    ButtonData:>{"Literat.nb", "Hydon-1994"},
    ButtonStyle->"Hyperlink"],
  "). Because of these difficulties, it is more convenient to start our \
discussion with second-order equations:"
}], "Text",
  CellTags->{
  "infinitesimal symmetries", "infinite number of symmetries", 
    "conformal symmetries", "second-order differential equation"}],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalDelta](x, u(x), u', \(u'\)')\  = \ 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  "Using the ",
  ButtonBox["definition of the symmetry group",
    ButtonData:>"Definition: Symmetry of a differential equation",
    ButtonStyle->"Hyperlink"],
  " in connection with the extended vector field,"
}], "Text"],

Cell[BoxData[
    \(Tangent[\[CapitalDelta]_] := 
      \[Xi][x, u]\ \[PartialD]\_x \[CapitalDelta] + 
        \[Phi][x, u]\ \[PartialD]\_u \[CapitalDelta] + 
        \[Phi]\_\((1)\)[x, u]\ \[PartialD]\_p \[CapitalDelta] + \n\t\t
        \[Phi]\_\((2)\)[x, u]\ \[PartialD]\_q \[CapitalDelta]\)], "Input"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are abbreviations for the first and second derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The infinitesimal invariance criterion contained in equation ",
  ButtonBox["(4.11)",
    ButtonData:>"eq-3",
    ButtonStyle->"Hyperlink"],
  " takes the form"
}], "Text",
  CellTags->"infinitesimal invariance criterion"],

Cell[BoxData[
    FormBox[
      FormBox[
        \(\(pr\^\((k)\)\) \(\(v\&\[RightVector]\)(\[CapitalDelta])\)\ 
          \(\[VerticalSeparator]\_\(\[CapitalDelta] = 0\)\ \( = \ 0\) . \)\),
        "TraditionalForm"], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "This expression follows by expanding (4.11) around the identity ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  " and taking into account the prolongation formulas for the derivatives. A \
detailed derivation of this formula can be found by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  " or ",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  ". The general equation (4.15) reduces for a second-order ODE to the \
relation"
}], "Text",
  CellTags->"prolongation formula"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tangent[\[CapitalDelta][x, u, p, q]] == 0\  /. \ 
        \[CapitalDelta][_] \[Rule] 0 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\[Phi]\ \[CapitalDelta]\_u + \[Xi]\ \[CapitalDelta]\_x + 
        \[CapitalDelta]\_p\ \[Phi]\_1[x, u] + 
        \[CapitalDelta]\_q\ \[Phi]\_2[x, u] == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  " are the first and second components of the prolongation, respectively. \
They are computed via the prolongation formula given in S",
  ButtonBox["ection 3.7",
    ButtonData:>{"derivat1.nb", "Prolongation of vector fields"},
    ButtonStyle->"Hyperlink"],
  ". The equation derived is called the determining equation for the group \
admitted by the ordinary differential equation."
}], "Text",
  CellTags->{
  "first prolongation", "second prolongation", 
    "determining equation for the group"}],

Cell[TextData[{
  "If the differential equation is written in the representation of ",
  ButtonBox["(4.12)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(equat = q - f[x, u, p]\)], "Input",
  CellTags->"equat"],

Cell[BoxData[
    \(q - f[x, u, p]\)], "Output"]
}, Open  ]],

Cell["\<\
we can derive the explicit form of the determining equation by \
applying the twice extended vector field on this expression:\
\>", "Text",
  CellTags->{"determining equation", "extended vector field"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(determining = Tangent[equat]; determining // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\)\ f\_u - \[Xi]\ f\_x - f\_p\ \[Phi]\_1[x, u] + 
                \[Phi]\_2[x, u] == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The remaining unknowns in this result are the first and second extensions \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  ". We are able to extract the representation of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  " from the variable ",
  StyleBox["prolongation",
    FontSlant->"Italic"],
  " calculated in the section on ",
  ButtonBox["prolongation of transformations",
    ButtonData:>{"symmet1.nb", "Prolongation of Transformations"},
    ButtonStyle->"Hyperlink"],
  ". Using the variables ",
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`U'\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\(U'\)'\)]],
  " and searching for the coefficients of the group parameter \[Epsilon], we \
end up with the infinitesimals \[Xi] and \[Phi] and the first and second \
extension ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  ":"
}], "Text",
  CellTags->{"first extension", "second extension"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"prol", "=", 
        RowBox[{
          RowBox[{"Coefficient", "[", 
            RowBox[{
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                  \(X[x, u, \[Epsilon]]\), ",", \(U[x, u, \[Epsilon]]\), ",", 
                    "\n", "\t\t\t", 
                    RowBox[{
                      SuperscriptBox["U", "\[Prime]",
                        MultilineFunction->None], "[", \(x, u, \[Epsilon]\), 
                      "]"}], ",", 
                    RowBox[{
                      SuperscriptBox["U", "\[DoublePrime]",
                        MultilineFunction->None], "[", \(x, u, \[Epsilon]\), 
                      "]"}]}], "}"}], "/.", "prolongation"}], ",", 
              "\[Epsilon]"}], "]"}], "/.", "\n", "\t\t", 
          \(u[x] \[Rule] u\)}]}], ";", \(prol // LTF\)}]], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Xi] == 0\)},
          {\(\[Phi] == 0\)},
          {
            \(u\_x\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + u\_x\ \[Phi]\_u + 
                \[Phi]\_x == 0\)},
          {
            \(2\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\)\ u\_\(x, x\) + 
                \[Phi]\_u\ u\_\(x, x\) - 
                u\_x\ \((
                    \[Xi]\_u\ u\_\(x, x\) + u\_x\ \[Xi]\_\(x, u\) + 
                      u\_x\ \((u\_x\ \[Xi]\_\(u, u\) + \[Xi]\_\(x, u\))\) + 
                      \[Xi]\_\(x, x\))\) + u\_x\ \[Phi]\_\(x, u\) + 
                u\_x\ \((u\_x\ \[Phi]\_\(u, u\) + \[Phi]\_\(x, u\))\) + 
                \[Phi]\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "For our calculations, we only need the expressions representing ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  " given by the third and fourth element of the list ",
  StyleBox["prol",
    FontSlant->"Italic"],
  ". In the next step, we define two rules representing ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  " by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule1 = {\[Phi]\_1 \[Rule] Function[{x, u}, w], \n\t\t
          \[Phi]\_2 \[Rule] Function[{x, u}, v]} /. \n
        \t\t{w \[Rule] prol\[LeftDoubleBracket]3\[RightDoubleBracket], 
          v \[Rule] prol\[LeftDoubleBracket]4\[RightDoubleBracket]}\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(\[Phi]\_1\), "\[Rule]", 
          RowBox[{"Function", "[", 
            RowBox[{\({x, u}\), ",", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["u", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}], " ", 
                  RowBox[{
                    SuperscriptBox["\[Phi]", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, u\), "]"}]}], "+", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["u", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"-", 
                          RowBox[{
                            SuperscriptBox["u", "\[Prime]",
                              MultilineFunction->None], "[", "x", "]"}]}], 
                        " ", 
                        RowBox[{
                          SuperscriptBox["\[Xi]", 
                            TagBox[\((0, 1)\),
                              Derivative],
                            MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                      "-", 
                      RowBox[{
                        SuperscriptBox["\[Xi]", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                    ")"}]}], "+", 
                RowBox[{
                  SuperscriptBox["\[Phi]", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, u\), "]"}]}]}], 
            "]"}]}], ",", 
        RowBox[{\(\[Phi]\_2\), "\[Rule]", 
          RowBox[{"Function", "[", 
            RowBox[{\({x, u}\), ",", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["u", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}], " ", 
                  RowBox[{
                    SuperscriptBox["\[Phi]", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, u\), "]"}]}], "+", 
                RowBox[{"2", " ", 
                  RowBox[{
                    SuperscriptBox["u", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"-", 
                          RowBox[{
                            SuperscriptBox["u", "\[Prime]",
                              MultilineFunction->None], "[", "x", "]"}]}], 
                        " ", 
                        RowBox[{
                          SuperscriptBox["\[Xi]", 
                            TagBox[\((0, 1)\),
                              Derivative],
                            MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                      "-", 
                      RowBox[{
                        SuperscriptBox["\[Xi]", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                    ")"}]}], "+", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["u", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}], " ", 
                  RowBox[{
                    SuperscriptBox["\[Phi]", 
                      TagBox[\((1, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, u\), "]"}]}], "+", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["u", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          SuperscriptBox["u", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox["\[Phi]", 
                            TagBox[\((0, 2)\),
                              Derivative],
                            MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                      "+", 
                      RowBox[{
                        SuperscriptBox["\[Phi]", 
                          TagBox[\((1, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                    ")"}]}], "-", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["u", "\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          SuperscriptBox["u", "\[DoublePrime]",
                            MultilineFunction->None], "[", "x", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox["\[Xi]", 
                            TagBox[\((0, 1)\),
                              Derivative],
                            MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                      "+", 
                      RowBox[{
                        RowBox[{
                          SuperscriptBox["u", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox["\[Xi]", 
                            TagBox[\((1, 1)\),
                              Derivative],
                            MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                      "+", 
                      RowBox[{
                        RowBox[{
                          SuperscriptBox["u", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}], " ", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                SuperscriptBox["u", "\[Prime]",
                                  MultilineFunction->None], "[", "x", "]"}], 
                              " ", 
                              RowBox[{
                                SuperscriptBox["\[Xi]", 
                                  TagBox[\((0, 2)\),
                                    Derivative],
                                  MultilineFunction->None], "[", \(x, u\), 
                                "]"}]}], "+", 
                            RowBox[{
                              SuperscriptBox["\[Xi]", 
                                TagBox[\((1, 1)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(x, u\), 
                              "]"}]}], ")"}]}], "+", 
                      RowBox[{
                        SuperscriptBox["\[Xi]", 
                          TagBox[\((2, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                    ")"}]}], "+", 
                RowBox[{
                  SuperscriptBox["\[Phi]", 
                    TagBox[\((2, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, u\), "]"}]}]}], 
            "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "These expressions are used in the determining equation to eliminate ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_2\)]],
  ":"
}], "Text",
  CellTags->"determining equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(determ = determining /. rule1; determ // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\)\ f\_u - \[Xi]\ f\_x - 
                f\_p\ \((
                    u\_x\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + 
                      u\_x\ \[Phi]\_u + \[Phi]\_x)\) + 
                2\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\)\ u\_\(x, x\) + 
                \[Phi]\_u\ u\_\(x, x\) - 
                u\_x\ \((
                    \[Xi]\_u\ u\_\(x, x\) + u\_x\ \[Xi]\_\(x, u\) + 
                      u\_x\ \((u\_x\ \[Xi]\_\(u, u\) + \[Xi]\_\(x, u\))\) + 
                      \[Xi]\_\(x, x\))\) + u\_x\ \[Phi]\_\(x, u\) + 
                u\_x\ \((u\_x\ \[Phi]\_\(u, u\) + \[Phi]\_\(x, u\))\) + 
                \[Phi]\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The above calculations deliver an expression containing the determining \
equations of the infinitesimals \[Xi] and \[Phi] in an implicit way. The main \
characteristic of the result is the dependence on derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". However, we know that the equation",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox[ButtonBox["equat",
    ButtonData:>"equat",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "has to be satisfied on the manifold \[GothicCapitalM]. This allows us to \
eliminate certain derivatives by using the equation itself. By replacing one \
type of derivative, we eliminate redundant information in the expression ",
  StyleBox["determ",
    FontSlant->"Italic"],
  ". The replacement is carried out by"
}], "Text",
  CellTags->{"infinitesimals", "manifold", "redundant information"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(determi = 
      determ /. 
        \((Solve[equat == 0, q] /. \n\t\t\t\t
            q \[Rule] \[PartialD]\_{x, 2}u[x])\); determi // LTF\ \)\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\)\ f\_u - \[Xi]\ f\_x + 
                2\ f\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + f\ \[Phi]\_u - 
                f\_p\ \((
                    u\_x\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + 
                      u\_x\ \[Phi]\_u + \[Phi]\_x)\) - 
                u\_x\ \((
                    f\ \[Xi]\_u + u\_x\ \[Xi]\_\(x, u\) + 
                      u\_x\ \((u\_x\ \[Xi]\_\(u, u\) + \[Xi]\_\(x, u\))\) + 
                      \[Xi]\_\(x, x\))\) + u\_x\ \[Phi]\_\(x, u\) + 
                u\_x\ \((u\_x\ \[Phi]\_\(u, u\) + \[Phi]\_\(x, u\))\) + 
                \[Phi]\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["f\[MediumSpace]",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  "[",
  StyleBox["x",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  ", ",
  StyleBox["u",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  ", ",
  StyleBox["p",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  "] is a known function. On the other hand, the infinitesimals \[Xi] and \
\[Phi] are unknown functions of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Thus, the expressions containing first-order derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are independent from each other. This independence creates a system of \
determining equations in the variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". An additional feature of these equations is that we find more \
determining equations than unknown functions \[Xi] and \[Phi]. Thus, the \
system of determining equations is overdetermined. Solving this system, we \
find the infinitesimal symmetries \[Xi] and \[Phi] of the equation. "
}], "Text",
  CellTags->{
  "infinitesimals", "system of determining equations", 
    "determining equations", "overdetermined system of equations", 
    "infinitesimal symmetries"}],

Cell["Example 1", "Example"],

Cell["\<\
Let us examine the infinitesimal symmetries of the second-order \
equation\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dequ2 = \[PartialD]\_{x, 2}u[x] + \[PartialD]\_x u[x]\/x - Exp[u[x]]; 
    dequ2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(-E\^u\), "+", 
                StyleBox[\(u\_x\/x\),
                  ScriptLevel->0], "+", \(u\_\(x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We use here the function ",
  StyleBox["LTF[]", "MmaText"],
  " to represent the equation in mathematcal index notation. The highly \
nonlinear ordinary differential equation of second order has a right-hand \
side ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " given by "
}], "Text",
  CellTags->{"nonlinear ordinary differential equation", "LTF[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(subrule = f \[Rule] Function[{x, u, p}, Exp[u] - p\/x]\)], "Input"],

Cell[BoxData[
    \(f \[Rule] Function[{x, u, p}, Exp[u] - p\/x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The defining equation for the infinitesimals follows by inserting the rule \
for ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "  into the expression ",
  StyleBox["determi",
    FontSlant->"Italic"],
  " and replacing the derivatives ",
  StyleBox["p",
    FontSlant->"Italic"],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  "  "
}], "Text",
  CellTags->{"infinitesimals", "defining equation for infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(detex1 = \(determi /. subrule\) /. {p \[Rule] \[PartialD]\_x u[x]}; 
    detex1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(\(-E\^u\)\ \[Phi]\), "-", 
                StyleBox[\(\(\[Xi]\ u\_x\)\/x\^2\),
                  ScriptLevel->0], "+", 
                RowBox[{"2", " ", 
                  RowBox[{"(", 
                    RowBox[{\(E\^u\), "-", 
                      StyleBox[\(u\_x\/x\),
                        ScriptLevel->0]}], ")"}], " ", 
                  \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\)}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{\(E\^u\), "-", 
                      StyleBox[\(u\_x\/x\),
                        ScriptLevel->0]}], ")"}], " ", \(\[Phi]\_u\)}], "+", 
                
                StyleBox[
                  \(\(u\_x\ \((\(-u\_x\)\ \[Xi]\_u - \[Xi]\_x)\) + 
                        u\_x\ \[Phi]\_u + \[Phi]\_x\)\/x\),
                  ScriptLevel->0], "-", 
                RowBox[{\(u\_x\), " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{\(E\^u\), "-", 
                            StyleBox[\(u\_x\/x\),
                              ScriptLevel->0]}], ")"}], " ", \(\[Xi]\_u\)}], 
                      "+", \(u\_x\ \[Xi]\_\(x, u\)\), "+", 
                      \(u\_x\ \((u\_x\ \[Xi]\_\(u, u\) + \[Xi]\_\(x, u\))
                          \)\), "+", \(\[Xi]\_\(x, x\)\)}], ")"}]}], "+", 
                \(u\_x\ \[Phi]\_\(x, u\)\), "+", 
                \(u\_x\ \((u\_x\ \[Phi]\_\(u, u\) + \[Phi]\_\(x, u\))\)\), 
                "+", \(\[Phi]\_\(x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting expression is a third-degree polynomial in the derivatives \
of ",
  StyleBox["u",
    FontSlant->"Italic"],
  "'. Since the infinitesimals \[Xi] and \[Phi] do not depend on the \
derivatives the determining equations decompose into the following three \
relations. These equations follow by setting the coefficients of the various \
powers of ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  " equal to zero"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab1 = 
      Flatten[Table[
          Coefficient[Expand[detex1], \n\t\t\t\t
            \((\[PartialD]\_x u[x])\)\^i], {i, 3, 1, \(-1\)}]]; 
    tab1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-\[Xi]\_\(u, u\)\) == 0\)},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\(2\ \[Xi]\_u\)\/x\),
                  ScriptLevel->0], "-", \(2\ \[Xi]\_\(x, u\)\), "+", 
                \(\[Phi]\_\(u, u\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\[Xi]\/x\^2\),
                    ScriptLevel->0]}], "-", \(3\ E\^u\ \[Xi]\_u\), "+", 
                StyleBox[\(\[Xi]\_x\/x\),
                  ScriptLevel->0], "-", \(\[Xi]\_\(x, x\)\), "+", 
                \(2\ \[Phi]\_\(x, u\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The fourth equation free of any ",
  StyleBox["u",
    FontSlant->"Italic"],
  "' is derived by the following line"
}], "Text"],

Cell[BoxData[
    \(\(AppendTo[tab1, \n\t
      Expand[detex1 - 
          Plus@@\((
              tab1 . {\((\[PartialD]\_x u[x])\)\^3, \n\t\t\t\t\t\t\t
                  \((\[PartialD]\_x u[x])\)\^2, \[PartialD]\_x u[x]})\)]]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab1 = Flatten[tab1]; tab1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-\[Xi]\_\(u, u\)\) == 0\)},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\(2\ \[Xi]\_u\)\/x\),
                  ScriptLevel->0], "-", \(2\ \[Xi]\_\(x, u\)\), "+", 
                \(\[Phi]\_\(u, u\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\[Xi]\/x\^2\),
                    ScriptLevel->0]}], "-", \(3\ E\^u\ \[Xi]\_u\), "+", 
                StyleBox[\(\[Xi]\_x\/x\),
                  ScriptLevel->0], "-", \(\[Xi]\_\(x, x\)\), "+", 
                \(2\ \[Phi]\_\(x, u\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
              \(\(-E\^u\)\ \[Phi]\), "-", \(2\ E\^u\ \[Xi]\_x\), "+", 
                \(E\^u\ \[Phi]\_u\), "+", 
                StyleBox[\(\[Phi]\_x\/x\),
                  ScriptLevel->0], "+", \(\[Phi]\_\(x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"These four equations are the defining equations for the infinitesimals \[Xi] \
and \[Phi]. The next step in finding the symmetries is the solution of these \
equations. We do this step by step. If we integrate the first and second \
equation, we find the general expressions for the solution"], "Text",
  CellTags->"defining equations for infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule2 = {\[Xi] \[Rule] Function[{x, u}, p[x]\ u + a[x]], \n\t\t
        \[Phi] \[Rule] 
          Function[{x, u}, 
            \((\[PartialD]\_x p[x] + p[x]\/x)\)\ u\^2 + \n\t\t\t\t\t
              \((2\ \((\[PartialD]\_x a[x] - a[x]\/x)\) + q[x])\)\ u + b[x]]}
        \)], "Input"],

Cell[BoxData[
    \({\[Xi] \[Rule] Function[{x, u}, p[x]\ u + a[x]], 
      \[Phi] \[Rule] 
        Function[{x, u}, 
          \((\[PartialD]\_x p[x] + p[x]\/x)\)\ u\^2 + 
            \((2\ \((\[PartialD]\_x a[x] - a[x]\/x)\) + q[x])\)\ u + b[x]]}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(a, \)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " are arbitrary functions of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Substituting this result into the determining equations in ",
  StyleBox["tab1",
    FontSlant->"Italic"],
  ", we get a reduced set of determining equations connecting the arbitrary \
functions ",
  StyleBox["a",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\((x)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`b(x)\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`q(x)\)]],
  "."
}], "Text",
  CellTags->"determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(tab2 = Expand[tab1 /. rule2]; tab2 // LTF\ \)\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"True"},
          {
            StyleBox[\(\(4\ p\)\/x == 0\),
              ScriptLevel->0]},
          {
            RowBox[{
              RowBox[{\(\(-3\)\ E\^u\ p\), "+", 
                StyleBox[\(\(3\ a\)\/x\^2\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(\(5\ p\ u\)\/x\^2\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(\(3\ a\_x\)\/x\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(5\ u\ p\_x\)\/x\),
                  ScriptLevel->0], "+", \(2\ q\_x\), "+", \(3\ a\_\(x, x\)\), 
                "+", \(3\ u\ p\_\(x, x\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
              \(\(-b\)\ E\^u\), "+", \(E\^u\ q\), "-", \(E\^u\ q\ u\), "-", 
                StyleBox[\(\(2\ a\ u\)\/x\^3\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(p\ u\^2\)\/x\^3\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ a\ E\^u\)\/x\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ a\ E\^u\ u\)\/x\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ E\^u\ p\ u\)\/x\),
                  ScriptLevel->0], "-", 
                StyleBox[\(\(E\^u\ p\ u\^2\)\/x\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(2\ E\^u\ u\ a\_x\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ u\ a\_x\)\/x\^2\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(b\_x\/x\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(E\^u\ u\^2\ p\_x\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(\(u\^2\ p\_x\)\/x\^2\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(u\ q\_x\)\/x\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(b\_\(x, x\)\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ u\^2\ p\_\(x, x\)\)\/x\),
                  ScriptLevel->0], "+", \(u\ q\_\(x, x\)\), "+", 
                \(2\ u\ a\_\(x, x, x\)\), "+", \(u\^2\ p\_\(x, x, x\)\)}], 
              "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The second equation shows us that the function ",
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  " has to vanish identically to satisfy the equation. Using this fact in the \
representation of the infinitesimals, we can simplify the results to"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule3 = rule2 /. p \[Rule] Function[x, 0]\)], "Input"],

Cell[BoxData[
    \({\[Xi] \[Rule] Function[{x, u}, \(Function[x, 0]\)[x]\ u + a[x]], 
      \[Phi] \[Rule] 
        Function[{x, u}, 
          \((\[PartialD]\_x\( Function[x, 0]\)[x] + \(Function[x, 0]\)[x]\/x)
                \)\ u\^2 + 
            \((2\ \((\[PartialD]\_x a[x] - a[x]\/x)\) + q[x])\)\ u + b[x]]}
      \)], "Output"]
}, Open  ]],

Cell["\<\
These expressions can be used again to simplify the set of the \
determining equations\
\>", "Text",
  CellTags->"simplify the determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab2 = Expand[tab1 /. rule3]; tab2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"True"},
          {"True"},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\(3\ a\)\/x\^2\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(\(3\ a\_x\)\/x\),
                  ScriptLevel->0], "+", \(2\ q\_x\), "+", 
                \(3\ a\_\(x, x\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
              \(\(-b\)\ E\^u\), "+", \(E\^u\ q\), "-", \(E\^u\ q\ u\), "-", 
                StyleBox[\(\(2\ a\ u\)\/x\^3\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ a\ E\^u\)\/x\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ a\ E\^u\ u\)\/x\),
                  ScriptLevel->0], "-", \(2\ E\^u\ u\ a\_x\), "+", 
                StyleBox[\(\(2\ u\ a\_x\)\/x\^2\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(b\_x\/x\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(u\ q\_x\)\/x\),
                  ScriptLevel->0], "+", \(b\_\(x, x\)\), "+", 
                \(u\ q\_\(x, x\)\), "+", \(2\ u\ a\_\(x, x, x\)\)}], "==", 
              "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "A second glance at these equations shows us that a combination of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-dependent auxiliary functions ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " occur in connection with ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  "-dependent coefficients. Since the auxiliary functions do not depend on ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", the determining equations decompose into another set of equations. Let \
us extract the equations from the terms containing factors like ",
  Cell[BoxData[
      \(TraditionalForm\`u\ Exp[u]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`Exp[u]\)]],
  " ."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef1 = 
      DeleteCases[
        Flatten[\n\t\t\t
          Table[Coefficient[\n\t\t\t\t\ttab2, Exp[u]\ u\^i], {i, 1, 0, 
                \(-1\)}] /. u \[Rule] 0], 0]; coef1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(-q\), "+", 
                StyleBox[\(\(2\ a\)\/x\),
                  ScriptLevel->0], "-", \(2\ a\_x\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{\(-b\), "+", "q", "-", 
                StyleBox[\(\(2\ a\)\/x\),
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The remaining set of equations follow from the terms containing pure \
coefficients in\[NonBreakingSpace]\[NoBreak]",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[coef1, \n\t
      DeleteCases[Coefficient[\n\t\t\ttab2 /. Exp[u] \[Rule] 0, u], 0]]; 
    \(coef1 // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(-q\), "+", 
                StyleBox[\(\(2\ a\)\/x\),
                  ScriptLevel->0], "-", \(2\ a\_x\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{\(-b\), "+", "q", "-", 
                StyleBox[\(\(2\ a\)\/x\),
                  ScriptLevel->0]}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(2\ a\)\/x\^3\),
                    ScriptLevel->0]}], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(\(2\ a\_x\)\/x\^2\),
                  ScriptLevel->0], 
                StyleBox["+",
                  ScriptLevel->0], 
                StyleBox[\(q\_x\/x\),
                  ScriptLevel->0], "+", \(q\_\(x, x\)\), "+", 
                \(2\ a\_\(x, x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The last set of equations follows from those terms which are free of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(AppendTo[coef1, 
      DeleteCases[\n\t\ttab2 /. {Exp[u] \[Rule] 0, u \[Rule] 0}, 0]]; 
    \(coef1 // Flatten\) // LTF\ \)\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            StyleBox[\(\(-q\) + \(2\ a\)\/x - 2\ a\_x == 0\),
              ScriptLevel->0]},
          {
            StyleBox[\(\(-b\) + q - \(2\ a\)\/x == 0\),
              ScriptLevel->0]},
          {
            
            StyleBox[
              \(\(-\(\(2\ a\)\/x\^3\)\) + \(2\ a\_x\)\/x\^2 + q\_x\/x + 
                  q\_\(x, x\) + 2\ a\_\(x, x, x\) == 0\),
              ScriptLevel->0]},
          {
            
            StyleBox[
              \(\(3\ a\)\/x\^2 - \(3\ a\_x\)\/x + 2\ q\_x + 3\ a\_\(x, x\) == 
                0\),
              ScriptLevel->0]},
          {
            StyleBox[\(b\_x\/x + b\_\(x, x\) == 0\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["Thus, the complete set of determining equations reads", "Text",
  CellTags->"determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef1 = Flatten[coef1]; coef1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            StyleBox[\(\(-q\) + \(2\ a\)\/x - 2\ a\_x == 0\),
              ScriptLevel->0]},
          {
            StyleBox[\(\(-b\) + q - \(2\ a\)\/x == 0\),
              ScriptLevel->0]},
          {
            
            StyleBox[
              \(\(-\(\(2\ a\)\/x\^3\)\) + \(2\ a\_x\)\/x\^2 + q\_x\/x + 
                  q\_\(x, x\) + 2\ a\_\(x, x, x\) == 0\),
              ScriptLevel->0]},
          {
            
            StyleBox[
              \(\(3\ a\)\/x\^2 - \(3\ a\_x\)\/x + 2\ q\_x + 3\ a\_\(x, x\) == 
                0\),
              ScriptLevel->0]},
          {
            StyleBox[\(b\_x\/x + b\_\(x, x\) == 0\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "To find the most general solution of these equations, we start by solving \
the last equation of this set. This second-order equation in ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " has the solution"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = Flatten[DSolve[Last[coef1] == 0, b, x]]\)], "Input"],

Cell[BoxData[
    \({b \[Rule] \((C[2] + C[1]\ Log[#1]&)\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "As expected, the solution contains two integrating constants ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2]. Applying this solution to the remaining equations"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef2 = coef1 /. sol1; coef2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            StyleBox[\(\(-q\) + \(2\ a\)\/x - 2\ a\_x == 0\),
              ScriptLevel->0]},
          {
            StyleBox[\(q - \(2\ a\)\/x - C[2] - C[1]\ Log[x] == 0\),
              ScriptLevel->0]},
          {
            
            StyleBox[
              \(\(-\(\(2\ a\)\/x\^3\)\) + \(2\ a\_x\)\/x\^2 + q\_x\/x + 
                  q\_\(x, x\) + 2\ a\_\(x, x, x\) == 0\),
              ScriptLevel->0]},
          {
            
            StyleBox[
              \(\(3\ a\)\/x\^2 - \(3\ a\_x\)\/x + 2\ q\_x + 3\ a\_\(x, x\) == 
                0\),
              ScriptLevel->0]},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "simplifies the expressions. We find determining equations for ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". If we examine the equations, we realize that the second equation is a \
purely algebraic equation which can be solved either for ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". We decide here to solve the equation for ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = 
      Flatten[Solve[coef2\[LeftDoubleBracket]2\[RightDoubleBracket] == 0, 
            a[x]] /. a[x] \[Rule] w]\)], "Input"],

Cell[BoxData[
    \({w \[Rule] \(-\(1\/2\)\)\ x\ \((C[2] + C[1]\ Log[x] - q[x])\)}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
For further use of this solution, we convert the result into a pure \
function.\
\>", "Text",
  CellTags->"pure function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol21 = a \[Rule] Function[x, w] /. sol2\)], "Input"],

Cell[BoxData[
    \(a \[Rule] 
      Function[x, \(-\(1\/2\)\)\ x\ \((C[2] + C[1]\ Log[x] - q[x])\)]\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The application of this solution to the determining equations simplifies \
the equations to an overdetermined system in ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ":"
}], "Text",
  CellTags->{"determining equations", "overdetermined system"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef3 = Simplify[coef2 /. sol21]; coef3 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-q\) + C[1] - x\ q\_x == 0\)},
          {"True"},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\(2\ q\_x\)\/x\),
                  ScriptLevel->0], "+", \(4\ q\_\(x, x\)\), "+", 
                \(x\ q\_\(x, x, x\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(1\/2\),
                  ScriptLevel->0], " ", \((7\ q\_x + 3\ x\ q\_\(x, x\))\)}], 
              "==", "0"}]},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we examine these equations, we observe that all three equations are \
connected by the derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". Solving the first equation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`q'\)]],
  " and substituting the result into the rest gives us"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hel1 = 
      Solve[coef3\[LeftDoubleBracket]1\[RightDoubleBracket] == 0, 
        \[PartialD]\_x q[x]]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["q", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          \(-\(\(\(-C[1]\) + q[x]\)\/x\)\)}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef3 = Flatten[coef3 /. hel1]; coef3 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"True"},
          {"True"},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(2\ \((q - C[1])\)\)\/x\^2\),
                    ScriptLevel->0]}], "+", \(4\ q\_\(x, x\)\), "+", 
                \(x\ q\_\(x, x, x\)\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(1\/2\),
                  ScriptLevel->0], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"-", 
                      StyleBox[\(\(7\ \((q - C[1])\)\)\/x\),
                        ScriptLevel->0]}], "+", \(3\ x\ q\_\(x, x\)\)}], 
                  ")"}]}], "==", "0"}]},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "a system of two coupled equations which are connected by ",
  Cell[BoxData[
      \(TraditionalForm\`\(q'\)'\)]],
  ". The solution of the second equation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`\(q'\)'\)]],
  " and the reinsertion of the result into the equations gives"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hel2 = 
      Flatten[Solve[coef3\[LeftDoubleBracket]4\[RightDoubleBracket] == 0, 
          \[PartialD]\_{x, 2}q[x]]]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["q", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
        \(-\(\(7\ \((C[1] - q[x])\)\)\/\(3\ x\^2\)\)\)}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef3 = Flatten[Simplify[coef3 /. hel2]]; coef3 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"True"},
          {"True"},
          {
            RowBox[{
              
              StyleBox[
                \(\(22\ q - 22\ C[1] + 3\ x\^3\ q\_\(x, x, x\)\)\/\(3\ 
                      x\^2\)\),
                ScriptLevel->0], "==", "0"}]},
          {"True"},
          {"True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "a single equation of third order in ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". One solution of this remaining equation is given by a constant ",
  StyleBox["q",
    FontSlant->"Italic"],
  "[",
  StyleBox["x",
    FontSlant->"Italic"],
  "]",
  StyleBox[" = C",
    FontSlant->"Italic"],
  "[1]. Thus, we can define ",
  StyleBox["q",
    FontSlant->"Italic"],
  " as"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol3 = q \[Rule] Function[x, C[1]]\)], "Input"],

Cell[BoxData[
    \(q \[Rule] Function[x, C[1]]\)], "Output"]
}, Open  ]],

Cell["We check this solution by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(coef3 /. sol3\)], "Input"],

Cell[BoxData[
    \({0, 0, 0, 0, 0}\)], "Output"]
}, Open  ]],

Cell[TextData["The infinitesimals \[Xi] and \[Phi] are thus given by"], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infini = 
      Simplify[\(\(\({\[Xi][x, u], \[Phi][x, u]} /. \n\t\t\trule3\) /. sol1
              \) /. sol21\) /. sol3]\)], "Input"],

Cell[BoxData[
    \({\(-\(1\/2\)\)\ x\ \((\(-C[1]\) + C[2] + C[1]\ Log[x])\), 
      C[2] + C[1]\ Log[x]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, the infinitesimals depend on two arbitrary parameters ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[2] representing the group parameters. In view of the linearity of the \
determining equations, the general solution can be represented as a linear \
combination of two independent solutions"
}], "Text",
  CellTags->{"group parameters", "linearity of determining equations"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(nfini1 = infini /. {C[1] \[Rule] 1, C[2] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({\(-\(1\/2\)\)\ x\ \((\(-1\) + Log[x])\), Log[x]}\)], "Output"]
}, Open  ]],

Cell["and", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nfini2 = infini /. {C[1] \[Rule] 0, C[2] \[Rule] 1}\)], "Input"],

Cell[BoxData[
    \({\(-\(x\/2\)\), 1}\)], "Output"]
}, Open  ]],

Cell[TextData[
"This means that our original equation admits two linearly independent \
operators and that we have to consider a two-dimensional vector space with \
the basis given above.\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->"linearly independent operators"],

Cell["\<\
The example discussed shows that the derivation of the determining \
equations is very laborious when done interactively. Therefore, it is our \
goal to present a procedure which automatically delivers at least a \
prolongation of the equation.\
\>", "Text",
  CellTags->"prolongation"],

Cell[TextData[{
  "We already know that the prolongation is related to an expansion of the \
infinitesimals. The actual connection is a special form of a derivative known \
as Fr\[EAcute]chet derivative. The definition of a ",
  ButtonBox["Fr\[EAcute]chet derivative",
    ButtonData:>{"derivat.nb", "Definition: Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  " was introduced in C",
  ButtonBox["hapter 3.",
    ButtonData:>{"derivat.nb", None},
    ButtonStyle->"Hyperlink"],
  " Here, we will shortly recall the definition in an appropriate form \
applicable on ordinary differential equations. A Fr\[EAcute]chet derivative \
is a generalization of an ordinary derivative including a weight of the \
differential. The symbolic definition is"
}], "Text",
  CellTags->{"infinitesimals", "Frechet derivative"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(\[GothicCapitalD]\_P\)(Q)\), " ", "=", " ", 
        RowBox[{
          FractionBox["d", 
            StyleBox[
              RowBox[{
                StyleBox["d",
                  FontSlant->"Italic"], "\[Epsilon]"}]]], " ", 
          \(P(u + \[Epsilon]\ \(Q(u)\))\), \(|\_\(\[Epsilon] = 0\) . \)}]}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"eq-8"],

Cell[TextData[{
  "In ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " this definition is realized by the function ",
  ButtonBox["FrechetD[]",
    ButtonData:>{"derivat.nb", "FrechetD"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"FrechetD[]"],

Cell[TextData[{
  "The operational meaning of equation ",
  ButtonBox["(4.16)",
    ButtonData:>"eq-8",
    ButtonStyle->"Hyperlink"],
  " is that the dependent variables are replaced by their variations in the \
support function ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  ". The dependent variables are replaced by the variables and by the test \
function ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " multiplied by \[Epsilon]. After the substitution a differentiation with \
respect to \[Epsilon] is carried out and finally we set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ". This relation defined in general for an ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  "-dimensional support function ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " and for a ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  "-dimensional test function ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " allows a very efficient implementation in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->{"test function", "support function"}],

Cell[TextData[{
  "In S",
  ButtonBox["ection 3.7",
    ButtonData:>{"derivat1.nb", "Prolongation of vector fields"},
    ButtonStyle->"Hyperlink"],
  ", we discussed the connection between the prolongation and the  \
Fr\[EAcute]chet derivative. This relation is given by"
}], "Text",
  CellTags->{"prolongation", "Frechet derivative"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((k)\)\) \(\(v\&\[RightVector]\)(\[CapitalDelta])\)\  = \ 
      \(\[GothicCapitalD]\_\[CapitalDelta]\)(Q)\  + \ 
        \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ \(\(D\_i\)(\[CapitalDelta])\)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where the test function ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " is a combination of the infinitesimals \[Xi] and \[Phi]."
}], "Text",
  CellTags->"infinitesimals"],

Cell[BoxData[
    \(TraditionalForm
    \`Q\_\[Alpha]\  = \ 
      \(\[Phi]\_\[Alpha]\  - \ 
          \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ 
              \[PartialD]u\^\[Alpha]\/\[PartialD]x\_i\ \ \ \ \ \ \ \ \ 
              \[Alpha] = 1\), 2, \[Ellipsis], \(q . \)\)], "NumberedEquation"],

Cell["\<\
The actual invariance condition for a given system of differential \
equations is then given by\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
        \(pr\^\((k)\)\), \(\(v\&\[RightVector]\)(\[CapitalDelta])\), " ", 
          RowBox[{
          \(\[VerticalSeparator]\_\(\[CapitalDelta] = 0\)\), "=", " ", 
            RowBox[{
              RowBox[{
                RowBox[{"(", 
                  RowBox[{\(\(\[GothicCapitalD]\_\[CapitalDelta]\)(Q)\), 
                    SubscriptBox["\[VerticalSeparator]", 
                      RowBox[{\(Q\_\[Alpha]\), " ", "=", " ", 
                        RowBox[{\(\[Phi]\_\[Alpha]\), " ", "-", 
                          StyleBox[" ",
                            FontSize->8], 
                          RowBox[{
                            StyleBox[\(\[Sum]\+\(i = 1\)\%p\),
                              FontSize->7], 
                            
                            StyleBox[
                              \(\[Xi]\_i\ 
                                \[PartialD]u\^\[Alpha]\/\[PartialD]x\_i\),
                              FontSize->8]}]}]}]], 
                    RowBox[{"+", 
                      StyleBox[" ",
                        FontSize->16], 
                      RowBox[{
                        StyleBox[\(\[Sum]\+\(i = 1\)\%p\),
                          ScriptLevel->0], 
                        \(\[Xi]\_i\ \(\(D\_i\)(\[CapitalDelta])\)\)}]}]}], 
                  " ", ")"}], 
                \(\[VerticalSeparator]\_\(\[CapitalDelta] = 0\)\)}], "=", 
              " ", "0"}]}]}], TraditionalForm]]],
  "."
}], "NumberedEquation",
  CellTags->"eq-11"],

Cell[TextData[
"The algorithm for calculating the prolongation now consists of three steps. \
These steps are contained in equations (4.17)\[Dash](4.19). They are verbally \
expressed by the following:"], "Text",
  CellTags->{"algorithm", "algorithm calculating the prolongation"}],

Cell[TextData[{
  "1. Define the test functions ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " using the infinitesimals as given in (4.18)."
}], "ListItem"],

Cell["\<\
2. Calculate the Fr\[EAcute]chet derivative and the complete \
derivative by equation (4.16).\
\>", "ListItem"],

Cell["\<\
3. Apply the side conditions (4.18) and the original equation to \
the result.\
\>", "ListItem"],

Cell[TextData[{
  "The three steps of the calculation for an ordinary differential equation \
are collected in the function ",
  StyleBox["ProlongationODE[]", "MmaText"],
  ". The function ",
  StyleBox["ProlongationODE[] ", "MmaText"],
  "needs the equation, the dependent and independent variables, as input \
parameters. The function is written in such a form that only one dependent \
and one independent variable is allowed. The general definition of ",
  StyleBox["ProlongationODE[]", "MmaText"],
  " is given in S",
  ButtonBox["ection 3.7",
    ButtonData:>{"derivat1.nb", "Function Prolongation"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"ProlongationODE[]"],

Cell[BoxData[
    \(Clear[ProlongationODE]; \n
    ProlongationODE[equations_, dependent_, \n\tindependent_] := 
      Block[\n\t\t{vars, eta, testfunction, mainrule, prolong, \n\t\t\tux, x, 
          w}, \n\t\t
        vars = Flatten[
            Join[\n\t\t\t\t\t{dependent@@{independent}}, {independent}]]; \n
        \t\teta = 
          \[Phi]@@vars - 
            \[Xi]@@vars\ \ \[PartialD]\_independent dependent@@{independent}; 
        \n\t\ttestfunction = Unique["\<w$x\>"]; \n\t\t
        mainrule = ux \[Rule] Function[x, w]; \n\t\t
        prolong = 
          FrechetD[{equations}, {dependent}, \n
            \t\t\t\t{independent}, {testfunction}]; \n\t\t
        prolong = 
          prolong /. 
            \((mainrule /. \n
                \t\t\t\t\t\t{ux \[Rule] testfunction, x \[Rule] independent, 
                  \n\t\t\t\t\t\t\tw \[Rule] eta})\); \n\t\t
        prolong = 
          Expand[Apply[Plus, prolong, 1] + \n\t\t\t\t\t
              \[Xi]@@vars\ \[PartialD]\_independent equations]]\)], "Input",
  CellTags->"ProlongationODE[]"],

Cell[TextData[{
  "The action of the function ",
  StyleBox["ProlongationODE[]", "MmaText"],
  " is demonstrated by applying it to some examples. "
}], "Text",
  CellTags->"ProlongationODE[]"],

Cell["Example 1", "Example"],

Cell["Let us consider the general ordinary differential equation", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ode3 = \[PartialD]\_x u[x] - F[u[x], x]; ode3 // LTF\ \)\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-F\) + u\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["ProlongationODE[]", "MmaText"],
  " actually only treats the left-hand side of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x u\  - F(x, u) = 0\)]],
  ". The application of the function to the equation provides the following \
information:"
}], "Text",
  CellTags->"ProlongationODE[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(prolode3 = ProlongationODE[ode3, u, x]; prolode3 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\)\ F\_u - \[Xi]\ F\_x - u\_x\%2\ \[Xi]\_u - 
                u\_x\ \[Xi]\_x + u\_x\ \[Phi]\_u + \[Phi]\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting expression contains derivatives of the arbitrary function ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " and the infinitesimals. We notice that the derivative of the dependent \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " occurs in different locations. We know that the first derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " can be expressed by the differential equation itself. In this way, we can \
replace the first derivative by\[NonBreakingSpace]\[NoBreak]",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ":"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pode3 = prolode3 /. \[PartialD]\_x u[x] \[Rule] F[u[x], x]; 
    pode3 // LTF\)], "Input",
  CellTags->"pode3"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\)\ F\_u - \[Xi]\ F\_x - F\^2\ \[Xi]\_u - 
                F\ \[Xi]\_x + F\ \[Phi]\_u + \[Phi]\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, we eliminated the redundant information contained in the original \
differential equation. Since the prolonged vector field must vanish according \
to equation ",
  ButtonBox["(4.19)",
    ButtonData:>"eq-11",
    ButtonStyle->"Hyperlink"],
  ", we get conditions determining the infinitesimals. The arbitrary function \
",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " in our example is known for a certain type of equation. Thus, the partial \
differential equation for \[Xi] and \[Phi] has solutions ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi] = \[Xi](x, u)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi] = \[Phi](x, u)\)]],
  ". The three steps of deriving the prolongation can be simplified in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by"
}], "Text",
  CellTags->{"prolonged vector field", "prolongation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Map[# == 0&, ProlongationODE[ode3, u, x]] /. \n\t
          Solve[ode3 == 0, \[PartialD]\_x u[x]] // LieTraditionalForm\) // 
      TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\)\ F\_u - \[Xi]\ F\_x - F\^2\ \[Xi]\_u - 
                F\ \[Xi]\_x + F\ \[Phi]\_u + \[Phi]\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"With this expression, we are able to derive the invariance condition for any \
ordinary differential equation. A specific example may demonstrate the \
derivation of the invariance condition.\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->"invariance condition"],

Cell["Example 2", "Example"],

Cell["\<\
Let us assume that we have to find the invariance properties of the \
equation\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ode4 = \[PartialD]\_x u[x] - g[u[x]]\ f[x]; 
    \(Map[# == 0&, {ode4}] // LieTraditionalForm\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-f\)\ g + u\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, f, g], 
            Subscript[ u, x]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " are arbitrary functions of the independent and dependent variables, \
respectively. The invariance condition for this differential equation is \
given by"
}], "Text",
  CellTags->"invariance condition"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pode4 = 
      ProlongationODE[ode4, u, x] /. \n\t\t
        Solve[ode4 == 0, \[PartialD]\_x u[x]]; 
    \(pode4 // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-g\)\ \[Xi]\ f\_x - f\ \[Phi]\ g\_u - f\^2\ g\^2\ \[Xi]\_u - 
                f\ g\ \[Xi]\_x + f\ g\ \[Phi]\_u + \[Phi]\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["A solution satisfying the invariance equation is given by", "Text",
  CellTags->"invariance equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infiode4 = {\[Xi] \[Rule] Function[{u, x}, 1\/f[x]], \n\t\t
        \[Phi] \[Rule] Function[{u, x}, 0]}\)], "Input"],

Cell[BoxData[
    \({\[Xi] \[Rule] Function[{u, x}, 1\/f[x]], 
      \[Phi] \[Rule] Function[{u, x}, 0]}\)], "Output"]
}, Open  ]],

Cell["\<\
We can check this result directly by inserting the solutions into \
the invariance condition\
\>", "Text",
  CellTags->"invariance condition"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(pode4 /. u[x] \[Rule] u\) /. infiode4\)], "Input"],

Cell[BoxData[
    \({{0}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"The result demonstrates that the given solutions satisfy the invariance \
condition.\[ThickSpace]\[EmptySquare]"], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "A special note on the arguments of functions is appropriate here. In the \
above calculations, we used the functions ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", \[Xi], and \[Phi] depending on independent and dependent variables. In \
paper and pencil calculations, we are free to interchange these arguments \
because we know that these functions are the same, independent of the order \
of the arguments. However, in a symbolic calculation, we cannot change the \
slots of the variables, since a computer does not know how to handle the same \
function with interchanged arguments. So a good rule is to fix the arguments \
at the beginning of the calculation and to use the same order in all \
calculations."
}], "Text",
  CellTags->{
  "independent variables", "dependent variables", 
    "paper and pencil calculations", "symbolic calculation"}],

Cell[TextData[{
  "In the above example, the infinitesimals are given. How these solutions \
are derived from the invariance condition will be discussed below. We saw in \
the example discussed that we can always express the invariance condition of \
first-order differential equations free of any derivative. One consequence of \
this observation is that a first-order differential equation actually has an \
infinite number of symmetries. This behavior can be read off directly from \
relation",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox[ButtonBox["pode3",
    ButtonData:>"pode3",
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ", where \[Xi] is connected by \[Phi]. However, there are exceptions to \
this statement where only a finite number of symmetries exist."
}], "Text",
  CellTags->{
  "infinitesimals", "invariance condition", 
    "first-order differential equation", "infinite number of symmetries", 
    "finite number of symmetries"}],

Cell["Example 3", "Example"],

Cell["\<\
The derivation of a finite number of symmetries can be best \
demonstrated with a higher-order differential equation. In the examples above \
we restricted our discussions to first-order differential equations. If one \
has to examine higher-order differential equations, we have to extend or \
prolong the tangent vector field to the order of the differential equation; \
e.g., to the second prolongation for second-order differential equations. To \
demonstrate the calculation let us examine the following general second-order \
equation\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ode5 = \[PartialD]\_{x, 2}u[x] - F[x, u[x], \[PartialD]\_x u[x]]; 
    ode5 // LTF\ \)\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-F\) + u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The invariance condition (4.19) for this equation stays the same. The only \
difference is the higher order of differentiation which the function ",
  StyleBox["ProlongationODE[]", "MmaText"],
  " detects by itself. "
}], "Text",
  CellTags->"ProlongationODE[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pode5 = 
      ProlongationODE[ode5, u, x] /. \n\t\t
        Solve[ode5 == 0, \[PartialD]\_{x, 2}u[x]]; 
    \(pode5 // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\)\ F\_u - \[Xi]\ F\_x - 3\ F\ u\_x\ \[Xi]\_u + 
                F\_\(u\_x\)\ u\_x\%2\ \[Xi]\_u - 2\ F\ \[Xi]\_x + 
                F\_\(u\_x\)\ u\_x\ \[Xi]\_x + F\ \[Phi]\_u - 
                F\_\(u\_x\)\ u\_x\ \[Phi]\_u - F\_\(u\_x\)\ \[Phi]\_x - 
                u\_x\%3\ \[Xi]\_\(u, u\) - 2\ u\_x\%2\ \[Xi]\_\(u, x\) - 
                u\_x\ \[Xi]\_\(x, x\) + u\_x\%2\ \[Phi]\_\(u, u\) + 
                2\ u\_x\ \[Phi]\_\(u, x\) + \[Phi]\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "From this relation we have to determine \[Xi] and \[Phi]. The equation \
found is an identity in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x\)]],
  ". As a consequence of the point symmetries the infinitesimals are \
independent of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x\)]],
  ". This condition will split the general relation into several equations \
according to the different dependence of its parts on ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  ". We see that the same function ",
  StyleBox["ProlongationODE[]", "MmaText"],
  " is useful to calculate the invariance relation ",
  ButtonBox["(4.19)",
    ButtonData:>"eq-11",
    ButtonStyle->"Hyperlink"],
  " independent of the order of differentiation. In S",
  ButtonBox["ection 4.4.2",
    ButtonData:>{"symmet3.nb", 
      "Second order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  " on second-order differential equations we will show how we can extract \
the determining equations from such a relation. For the moment we stop at \
this point and discuss another useful tool called canonical variables."
}], "Text",
  CellTags->{"point symmetries", "infinitesimals", "canonical variables"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.3.4 Canonical Variables", "Subsection",
  CellTags->"Canonical variables"],

Cell[TextData[{
  "In his work ",
  ButtonBox["Lie ",
    ButtonData:>{"Literat.nb", "Enge-12"},
    ButtonStyle->"Hyperlink"],
  "pointed out that the introduction of suitable variables will drastically \
simplify the representation of a group. We discuss here the so-called \
canonical variables. On the other hand, canonical variables are a very \
efficient tool in the solution of ordinary differential equations. In this \
section we consider the distinguished situation of having a group consisting \
of two independent infinitesimal transformations."
}], "Text",
  CellTags->{"canonical variables", "infinitesimal transformation"}],

Cell[TextData[{
  "Two infinitesimal transformations given by their vector fields ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_2\)]],
  " are independent from each other if the following relations do not exist"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(v\&\[RightVector]\_1\),
          "TraditionalForm"], " ", "=", " ", 
        RowBox[{"c", " ", 
          FormBox[\(v\&\[RightVector]\_2, \),
            "TraditionalForm"]}]}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " is a constant, and the Lie product delivers"
}], "Text",
  Evaluatable->False,
  CellTags->"Lie product"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"[", 
          RowBox[{
            FormBox[\(v\&\[RightVector]\_1, \),
              "TraditionalForm"], " ", 
            FormBox[\(v\&\[RightVector]\_2\),
              "TraditionalForm"]}], " ", "]"}], " ", "=", " ", 
        RowBox[{
          RowBox[{\(c\_1\), " ", 
            FormBox[\(v\&\[RightVector]\_1\),
              "TraditionalForm"]}], " ", "+", " ", 
          RowBox[{\(c\_2\), " ", 
            FormBox[\(v\&\[RightVector]\_2\),
              "TraditionalForm"]}]}]}], TraditionalForm]], "NumberedEquation",\

  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_2\)]],
  " are constants again. The second relation can be simplified by assuming \
that the two independent transformations can be used to represent the product \
in a different way. If we assume that ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_2\)]],
  " are equal to zero, we get"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\([v\&\[RightVector]\_1, \),
              "TraditionalForm"], " ", 
            FormBox[\(v\&\[RightVector]\_2]\),
              "TraditionalForm"]}], "  ", "=", " ", "0."}], " "}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell["\<\
On the other hand, we can assume that the infinitesimal \
transformations are given by a linear combination of the transformations by\
\
\>", "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimal transformation", "linear combination of transformations"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"[", 
            RowBox[{
              FormBox[
                RowBox[{
                  RowBox[{\(\(a\_\(1\ \)\) v\&\[RightVector]\_1\), "+", 
                    RowBox[{\(a\_2\), " ", 
                      FormBox[\(v\&\[RightVector]\_2\),
                        "TraditionalForm"]}]}], " ", ",", \(b\_1\)}],
                "TraditionalForm"], " ", 
              FormBox[
                RowBox[{\(v\&\[RightVector]\_1\), "+", " ", 
                  RowBox[{\(b\_2\), " ", 
                    FormBox[\(v\&\[RightVector]\_2\),
                      "TraditionalForm"]}]}],
                "TraditionalForm"]}], " ", "]"}], " ", "=", " ", "0"}], 
        ","}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`a\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`i = 1, 2\)]],
  ", are constants. In these cases, the group is represented by commuting \
infinitesimal transformations. If, for example, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(c\_1\),
            "TraditionalForm"], "\[NotEqual]", "0"}], TraditionalForm]]],
  ", we represent the two infinitesimal transformations by"
}], "Text",
  Evaluatable->False,
  CellTags->"commuting infinitesimal transformation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          OverscriptBox[
            FormBox[\(v\&_\),
              "TraditionalForm"], "\[RightVector]"], "1"], " ", "=", " ", 
        \(v\&\[RightVector]\_1\  + \ \(c\_2\/c\_1\) v\&\[RightVector]\_2\)}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell["and", "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          OverscriptBox[
            FormBox[\(v\&_\),
              "TraditionalForm"], "\[RightVector]"], "2"], " ", "=", 
        \(\(1\/c\_1\) \(v\&\[RightVector]\_2 . \)\)}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell["\<\
By using this representation, we can rewrite the above condition as\
\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm
    \`\([\(v\&_\)\&\[RightVector]\_1, \(v\&_\)\&\[RightVector]\_2]\)\  = \ 
      \(\(1\/c\_1\)[v\&\[RightVector]\_1, v\&\[RightVector]\_2]\  + \ 
          \(c\_2\/c\_1\%2\)[v\&\[RightVector]\_1, v\&\[RightVector]\_2]\  = \ 
        \(\(1\/c\_1\) 
            \((c\_1\ v\&\[RightVector]\_1\  + c\_2\ v\&\[RightVector]\_2)
              \)\  = \ \(\(v\&_\)\&\[RightVector]\_1 . \)\)\)\)], 
  "NumberedEquation",
  Evaluatable->False],

Cell["Thus, we can write down the following theorem", "Text",
  Evaluatable->False],

Cell["Theorem: Canonical variables", "Theorem",
  CellTags->"Theorem: Canonical variables"],

Cell[TextData[{
  "Each two-dimensional group of infinitesimal transformations ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_2\)]],
  " can be used to represent the product of the two transformations in each \
of the following forms:"
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimal transformation"],

Cell[BoxData[
    \(TraditionalForm
    \`\([v\&\[RightVector]\_1, v\&\[RightVector]\_2]\)\  = \ 0\)], 
  "NumberedEquation",
  Evaluatable->False],

Cell["or", "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{"[", 
        RowBox[{
          FormBox[\(v\&\[RightVector]\_1, v\&\[RightVector]\_2]\),
            "TraditionalForm"], " ", "=", " ", 
          \(v\&\[RightVector]\_1 . \)}]}], TraditionalForm]], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[
"Each of the two results is independent from the other. \[ThickSpace]\
\[EmptyCircle]"], "Text",
  Evaluatable->False],

Cell["\<\
This theorem divides the two-dimensional groups in two classes. \
Each of these two classes can be divided into two subclasses.\
\>", "Text",
  Evaluatable->False,
  CellTags->"two-dimensional group"],

Cell["Canonical variables now follow from the definition:", "Text"],

Cell["Definition: Canonical variable", "Definition",
  CellTags->"Definition: Canonical variable"],

Cell[TextData[{
  "Every one-parameter group of transformations reduces to the group of \
translations",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(t\&_\),
              "TraditionalForm"], " ", "=", " ", \(t\  + \ \[Epsilon]\)}]}], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\&_ = \ w\)]],
  ", with the vector field"
}], "Text",
  CellTags->"group of translation"],

Cell[BoxData[
    \(TraditionalForm\`v\&\[RightVector]\  = \ \ \[PartialD]\_t\)], 
  "NumberedEquation"],

Cell[TextData[{
  "by a suitable change of variables ",
  Cell[BoxData[
      \(TraditionalForm\`t = \ t(x, u)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w = \ w(x, u)\)]],
  ". The variables ",
  StyleBox["t",
    FontSlant->"Italic"],
  " and ",
  StyleBox["w",
    FontSlant->"Italic"],
  " are the canonical variables.\[ThickSpace]\[EmptyCircle]"
}], "Text"],

Cell["\<\
The proof of this theorem follows from the fact that the tangent \
vector field in the original variables transforms according to the \
formula\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`v\&\[RightVector]\  = \ 
      \((\ v\&\[RightVector]\ t)\) 
        \[PartialD]\_t\ \(+\ \((v\&\[RightVector]\ \ w)\)\)\ 
        \[PartialD]\_w . \)], "NumberedEquation"],

Cell["\<\
In other words, canonical variables follow from the solution of the \
following linear partial differential equations. These two equations \
represent the invariance of the transformation\
\>", "Text",
  CellTags->"invariance of transformation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(canonicalEquations = {
        \[Xi][x, u]\ \[PartialD]\_x t[x, u] + \n\t\t\t
            \[Phi][x, u]\ \[PartialD]\_u t[x, u] == 1, \n\t\t
        \[Xi][x, u]\ \[PartialD]\_x w[x, u] + 
            \[Phi][x, u]\ \[PartialD]\_u w[x, u] == 0}; 
    \(canonicalEquations // LieTraditionalForm\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\ t\_u + \[Xi]\ t\_x == 1\)},
          {\(\[Phi]\ w\_u + \[Xi]\ w\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ \[Phi], 
              Subscript[ t, u]], 
            Times[ \[Xi], 
              Subscript[ t, x]]], 1], 
        Equal[ 
          Plus[ 
            Times[ \[Phi], 
              Subscript[ w, u]], 
            Times[ \[Xi], 
              Subscript[ w, x]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The two equations follow from the definition by applying the tangent \
vector ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " to the canonical variables ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]]
}], "Text",
  CellTags->"canonical variables"],

Cell[BoxData[
    \(TraditionalForm\`v\&\[RightVector]\ t\  = \ 1, \ \ \ \ \ \ \ \ \ \ 
    v\&\[RightVector]\ w\  = \ 0. \)], "NumberedEquation"],

Cell[TextData[
"The relations (4.24)\[Dash](4.26) define the canonical variables and present \
a way how these variables can be determined. The following examples discuss \
the derivation of canonical variables. First, we carry out a manual \
calculation of the canonical variables, and at the end of the section, we \
discuss an automatic procedure."], "Text",
  CellTags->{
  "calculation of canonical variables", "derivation of canonical variables"}],

Cell["Example 1", "Example"],

Cell["\<\
To see how these concepts work in practical applications, let us \
examine a specific problem. We will examine a scaling symmetry represented by \
the vector field\
\>", "Text",
  CellTags->"scaling symmetry"],

Cell[CellGroupData[{

Cell[BoxData[
    \(veccan = {\[Xi] \[Rule] Function[{x, u}, x], \n\t\t
        \[Phi] \[Rule] Function[{x, u}, \(-u\)]}\)], "Input"],

Cell[BoxData[
    \({\[Xi] \[Rule] Function[{x, u}, x], 
      \[Phi] \[Rule] Function[{x, u}, \(-u\)]}\)], "Output"]
}, Open  ]],

Cell["\<\
For this example, the defining equations for the canonical \
variables reduce to\
\>", "Text",
  CellTags->"equations for canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(caneq = canonicalEquations /. veccan; 
    \(caneq // LieTraditionalForm\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-u\)\ t\_u + x\ t\_x == 1\)},
          {\(\(-u\)\ w\_u + x\ w\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, u, 
              Subscript[ t, u]], 
            Times[ x, 
              Subscript[ t, x]]], 1], 
        Equal[ 
          Plus[ 
            Times[ -1, u, 
              Subscript[ w, u]], 
            Times[ x, 
              Subscript[ w, x]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "These two linear partial differential equations are solved by using the \
function ",
  StyleBox["DSolve[]", "MmaText"],
  " capable of solving first-order partial differential equations. The \
solution for ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " follows by"
}], "Text",
  CellTags->{"DSolve[]", "partial differential equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solc1 = 
      DSolve[caneq\[LeftDoubleBracket]1\[RightDoubleBracket], t[x, u], {x, u}]
        \)], "Input"],

Cell[BoxData[
    \({{t[x, u] \[Rule] Log[x] + \(C[1]\)[u\ x]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "and the solution for ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " reads"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solc2 = 
      DSolve[caneq\[LeftDoubleBracket]2\[RightDoubleBracket], w[x, u], {x, u}]
        \)], "Input"],

Cell[BoxData[
    \({{w[x, u] \[Rule] \(C[1]\)[u\ x]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result for ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " logarithmically depends on ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and allows an arbitrary function ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] combining the two old variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " by a product. The second canonical variable ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " is given by an arbitrary function which also connects ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " by a product. Since we are only interested in a special solution of the \
defining equations, we can simplify the arbitrary function by"
}], "Text",
  CellTags->"canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(r1 = \(C[1]\)[u\ x] \[Rule] x\ u\)], "Input"],

Cell[BoxData[
    \(\(C[1]\)[u\ x] \[Rule] u\ x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "For the inhomogeneous equation, we are mainly interested in a special \
solution. Thus, the general solution derived by the function ",
  StyleBox["DSolve[]", "MmaText"],
  " reduces if we set the arbitrary function ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1][", "MmaText"],
  StyleBox["x", "MmaText",
    FontSlant->"Italic"],
  StyleBox[", ", "MmaText"],
  StyleBox["u", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " to zero. Applying the reasoning to our solutions, we get"
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(csol = 
      Flatten[{solc1 /. \(C[1]\)[x\ u] \[Rule] 0, \n\t\t\tsolc2 /. r1}]\)], 
  "Input"],

Cell[BoxData[
    \({t[x, u] \[Rule] Log[x], w[x, u] \[Rule] u\ x}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "We can check the derived result by inserting the solutions into the \
defining equations ",
  StyleBox["caneq. ",
    FontSlant->"Italic"],
  "First, we have to transform the representation of the solutions into a \
pure function"
}], "Text",
  CellTags->"pure function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(r2 = 
      Thread[{t, w} \[Rule] \n\t\t\t
          \((Function[{x, u}, #1]&)\)/@
            \(({t[x, u], \n\t\t\t\t\t\tw[x, u]} /. csol)\)]\)], "Input"],

Cell[BoxData[
    \({t \[Rule] Function[{x, u}, Log[x]], w \[Rule] Function[{x, u}, u\ x]}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The application of the result on the original equations gives us a list \
containing ",
  StyleBox["True",
    FontSlant->"Italic"],
  " for each equation:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[caneq /. r2]\)], "Input"],

Cell[BoxData[
    \({True, True}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This result shows that the solutions given in ",
  StyleBox["csol",
    FontSlant->"Italic"],
  " satisfy the defining equations for the canonical variables.\[ThickSpace]\
\[EmptySquare]"
}], "Text"],

Cell["Example 2", "Example"],

Cell["\<\
Another example of great interest is the group of rotations. For \
this kind of symmetry group, the infinitesimals are given by\
\>", "Text",
  Evaluatable->False,
  CellTags->"rotation and canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(veccan = {\[Xi] \[Rule] Function[{x, u}, \(-u\)], \n\t\t
        \[Phi] \[Rule] Function[{x, u}, x]}\)], "Input"],

Cell[BoxData[
    \({\[Xi] \[Rule] Function[{x, u}, \(-u\)], 
      \[Phi] \[Rule] Function[{x, u}, x]}\)], "Output"]
}, Open  ]],

Cell["\<\
The equations determining the canonical variables are thus given by\
\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(caneq = canonicalEquations /. veccan; 
    \(caneq // LieTraditionalForm\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(x\ t\_u - u\ t\_x == 1\)},
          {\(x\ w\_u - u\ w\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ x, 
              Subscript[ t, u]], 
            Times[ -1, u, 
              Subscript[ t, x]]], 1], 
        Equal[ 
          Plus[ 
            Times[ x, 
              Subscript[ w, u]], 
            Times[ -1, u, 
              Subscript[ w, x]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution for the new independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " follows from"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solct = 
      DSolve[caneq\[LeftDoubleBracket]1\[RightDoubleBracket], t[x, u], {x, u}]
        \)], "Input"],

Cell[BoxData[
    \({{t[x, u] \[Rule] 
          \(-ArcTan[x\/\@u\^2]\) + \(C[1]\)[1\/2\ \((\(-u\^2\) - x\^2)\)]}, {
        t[x, u] \[Rule] 
          ArcTan[x\/\@u\^2] + \(C[1]\)[1\/2\ \((\(-u\^2\) - x\^2)\)]}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The new dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " is determined by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solcw = 
      DSolve[caneq\[LeftDoubleBracket]2\[RightDoubleBracket], w[x, u], {x, u}]
        \)], "Input"],

Cell[BoxData[
    \({{w[x, u] \[Rule] \(C[1]\)[\(-\(u\^2\/2\)\) - x\^2\/2]}}\)], "Output"]
}, Open  ]],

Cell["\<\
Again, we are only interested in a special solution which follows \
from\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solct = 
      PowerExpand[
        solct\[LeftDoubleBracket]2\[RightDoubleBracket] /. 
          \(C[1]\)[_] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \({t[x, u] \[Rule] ArcTan[x\/u]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution for ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " is extracted with"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solcw = Flatten[solcw /. \(C[1]\)[x_] \[Rule] x]\)], "Input"],

Cell[BoxData[
    \({w[x, u] \[Rule] \(-\(u\^2\/2\)\) - x\^2\/2}\)], "Output"]
}, Open  ]],

Cell["The complete expression of the canonical variables are thus ", "Text",
  Evaluatable->False,
  CellTags->"canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(r3 = 
      Thread[{t, w} \[Rule] \n\t\t\t
          \((Function[{x, u}, #1]&)\)/@
            \(({t[x, u], \n\t\t\t\t\t\tw[x, u]} /. {
                  solct\[LeftDoubleBracket]1\[RightDoubleBracket], 
                  solcw\[LeftDoubleBracket]1\[RightDoubleBracket]})\)]\)], 
  "Input"],

Cell[BoxData[
    \({t \[Rule] Function[{x, u}, ArcTan[x\/u]], 
      w \[Rule] Function[{x, u}, \(-\(u\^2\/2\)\) - x\^2\/2]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The canonical variables of the rotation group are given by the ",
  StyleBox["ArcTan ",
    FontSlant->"Italic"],
  "of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " divided by ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and the representation of a circle.\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False],

Cell["Example 3", "Example"],

Cell["\<\
Another kind of symmetry frequently encountered in problems is \
given by a projective group\
\>", "Text",
  Evaluatable->False,
  CellTags->"projective group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(veccan = {\[Xi] \[Rule] Function[{x, u}, x\ u], \n\t\t
        \[Phi] \[Rule] Function[{x, u}, u]}\)], "Input"],

Cell[BoxData[
    \({\[Xi] \[Rule] Function[{x, u}, x\ u], 
      \[Phi] \[Rule] Function[{x, u}, u]}\)], "Output"]
}, Open  ]],

Cell["The corresponding determining equations are", "Text",
  Evaluatable->False,
  CellTags->"determining equations for canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(caneq = canonicalEquations /. veccan; 
    \(caneq // LieTraditionalForm\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(u\ t\_u + u\ x\ t\_x == 1\)},
          {\(u\ w\_u + u\ x\ w\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ u, 
              Subscript[ t, u]], 
            Times[ u, x, 
              Subscript[ t, x]]], 1], 
        Equal[ 
          Plus[ 
            Times[ u, 
              Subscript[ w, u]], 
            Times[ u, x, 
              Subscript[ w, x]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We solve these equations by using the function ",
  StyleBox["DSolve[]", "MmaText"],
  " for the first and second equations:"
}], "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solct = 
      DSolve[caneq\[LeftDoubleBracket]1\[RightDoubleBracket], t[x, u], {x, u}]
        \)], "Input"],

Cell[BoxData[
    \({{t[x, u] \[Rule] Log[u] + \(C[1]\)[u - Log[x]]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(solcw = 
      DSolve[caneq\[LeftDoubleBracket]2\[RightDoubleBracket], w[x, u], {x, u}]
        \)], "Input"],

Cell[BoxData[
    \({{w[x, u] \[Rule] \(C[1]\)[u - Log[x]]}}\)], "Output"]
}, Open  ]],

Cell["We extract a special solution from these expressions by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(csol = 
      Flatten[{solct /. \(C[1]\)[_] \[Rule] 0, \n\t\t\t
          solcw /. \(C[1]\)[x_] \[Rule] x}]\)], "Input"],

Cell[BoxData[
    \({t[x, u] \[Rule] Log[u], w[x, u] \[Rule] u - Log[x]}\)], "Output"]
}, Open  ]],

Cell["and transform the relations to", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(r4 = 
      Thread[{t, w} \[Rule] \n\t\t\t
          \((Function[{x, u}, #1]&)\)/@
            \(({t[x, u], \n\t\t\t\t\t\tw[x, u]} /. csol)\)]\)], "Input"],

Cell[BoxData[
    \({t \[Rule] Function[{x, u}, Log[u]], 
      w \[Rule] Function[{x, u}, u - Log[x]]}\)], "Output"]
}, Open  ]],

Cell[TextData[
"The result is a representation of canonical variables for the projective  \
group.\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->"canonical variables of the projective group"],

Cell[TextData[{
  "The interactive steps of the calculation can be collected in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["CanonicalVariables[]", "MmaText"],
  ". The function needs the dependent and independent variables of the old \
coordinates. We also supply the infinitesimals for these coordinates as input \
information. The last two arguments contain lists of the new variable names \
for the dependent and independent variables, respectively."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "CanonicalVariables[]", "infinitesimals", "determining equations", 
    "pure function"}],

Cell[TextData[{
  "The function ",
  StyleBox["CanonicalVariables[]", "MmaText"],
  " calculates the general transformation using the first-order partial \
differential equations defining the determining equations. The function is \
designed to generalize the theory in such a way that an arbitrary number of \
independent and dependent variables can be transformed. The returned result \
of the function ",
  StyleBox["CanonicalVariables[]", "MmaText"],
  " is a list of solutions represented in a pure function form. The following \
code serves as the definition of this function."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(Clear[CanonicalVariables]\), 
    \(CanonicalVariables[depend_List, indep_List, \n\txi_List, phi_List, \n\t
        ndepend_List, nindep_List] := \n\t
      Block[{equations = {}, solutions = {}, \n\t\t\tssol, rule, csol}, \n\t\t
        vars = Join[indep, depend]; \n\t\tinfini = Join[xi, phi]; \n\t\t
        nvars = Join[ndepend, nindep]; \n\t\t
        newvars = Table[Unique["\<w$\>"], \n\t\t\t\t{i, 1, Length[vars]}]; \n
        \t\tdnewv = 
          Table[newvars\[LeftDoubleBracket]i\[RightDoubleBracket]@@vars, \n
            \t\t\t\t{i, 1, Length[newvars]}]; \n\t\t
        rule = Thread[newvars \[Rule] nvars]; \n\t\t
        Do[\n\t\t\t
          AppendTo[equations, \n\t\t\t\t
            \[Sum]\+\(i = 1\)\%\(Length[vars]\)infini\[LeftDoubleBracket]i
                    \[RightDoubleBracket]\ 
                  \[PartialD]\_\(vars\[LeftDoubleBracket]i
                        \[RightDoubleBracket]\)dnewv\[LeftDoubleBracket]j
                      \[RightDoubleBracket] == 0], \n
          \t\t\t{j, 1, Length[dnewv] - 1}]; \n\t\t
        AppendTo[equations, \n\t\t\t
          \[Sum]\+\(i = 1\)\%\(Length[vars]\)infini\[LeftDoubleBracket]i
                  \[RightDoubleBracket]\ 
                \[PartialD]\_\(vars\[LeftDoubleBracket]i
                      \[RightDoubleBracket]\)Last[dnewv] == 1]; \n\t\t
        Do[\n\t\t\t
          AppendTo[solutions, \n\t\t\t\t
            DSolve[equations\[LeftDoubleBracket]i\[RightDoubleBracket], 
              dnewv\[LeftDoubleBracket]i\[RightDoubleBracket], vars]], \n
          \t\t\t{i, 1, Length[equations]}]; \n\t\t
        ssol = PowerExpand[
            Table[solutions\[LeftDoubleBracket]i\[RightDoubleBracket] /. \n
                \t\t\t\t\t\t
                \(C[_]\)[x___] 
                  \[RuleDelayed] {x}\[LeftDoubleBracket]i
                    \[RightDoubleBracket], \n
              \t\t\t\t\t{i, 1, Length[solutions] - 1}]]; \n\t\t
        AppendTo[ssol, 
          PowerExpand[
            Last[solutions] /. \n\t\t\t\t\t\(C[_]\)[___] \[Rule] 0]]; \n\t\t
        csol = Flatten[ssol] /. rule; \n\t\t
        Thread[nvars \[Rule] \n\t\t\t\t
              \((Function[vars$, #1]&)\)/@
                \((\(dnewv /. \n\t\t\t\t\t\t\trule\) /. csol)\)] /. 
          vars$ \[Rule] vars]\)}], "Input",
  CellTags->{"CanonicalVariables[", "CanonicalVariables[]"}],

Cell[TextData[{
  "The application of the function ",
  StyleBox["CanonicalVariables[]", "MmaText"],
  " to different symmetry groups is demonstrated in the examples below. Let \
us first examine an inhomogeneous scaling group for two variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The names of the new variables are ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{"CanonicalVariables[]", "inhomogeneous scaling group"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {a\ x}, \n\t{b\ u}, {w}, {t}]\)], "Input"],

Cell[BoxData[
    \({w \[Rule] Function[{x, u}, u\ x\^\(-\(b\/a\)\)], 
      t \[Rule] Function[{x, u}, Log[x]\/a]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a logarithmic dependence in the new independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and a quotient of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\^\(b/a\)\)]],
  ". Another example is related to the projective group. The result becomes \
more readable if we apply the function ",
  StyleBox["LTF[]:", "MmaText"]
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {x\^2\ u}, {1}, \n\t{w}, {t}] // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(t == \(-u\)\)},
          {
            RowBox[{"w", "==", 
              RowBox[{
                StyleBox[\(u\^2\/2\),
                  ScriptLevel->0], "+", 
                StyleBox[\(1\/x\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Times[ -1, u]], 
        Equal[ w, 
          Plus[ 
            Times[ 
              Rational[ 1, 2], 
              Power[ u, 2]], 
            Power[ x, -1]]]}]]], "Output"]
}, Open  ]],

Cell["A further example is the inhomogeneous translation group", "Text",
  Evaluatable->False,
  CellTags->"translation group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {l}, {k}, \n\t{w}, {t}] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{"t", "==", 
              StyleBox[\(x\/l\),
                ScriptLevel->0]}]},
          {
            RowBox[{"w", "==", 
              RowBox[{"-", 
                StyleBox[\(\(\(-l\)\ u + k\ x\)\/l\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Times[ 
            Power[ l, -1], x]], 
        Equal[ w, 
          Times[ -1, 
            Power[ l, -1], 
            Plus[ 
              Times[ -1, l, u], 
              Times[ k, x]]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
The symmetry of rotation is connected with the canonical \
variables\
\>", "Text",
  Evaluatable->False,
  CellTags->"rotation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {u}, {\(-x\)}, \n\t{w}, {t}] // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              StyleBox["t",
                ScriptLevel->1], 
              StyleBox["==",
                ScriptLevel->1], 
              RowBox[{
                StyleBox["-",
                  ScriptLevel->0], 
                RowBox[{
                  StyleBox["ArcTan",
                    ScriptLevel->0], 
                  StyleBox["[",
                    ScriptLevel->0], \(x\/u\), 
                  StyleBox["]",
                    ScriptLevel->0]}]}]}]},
          {
            RowBox[{"w", "==", 
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(u\^2\/2\),
                    ScriptLevel->0]}], "-", 
                StyleBox[\(x\^2\/2\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Times[ -1, 
            ArcTan[ 
              Times[ 
                Power[ u, -1], x]]]], 
        Equal[ w, 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ u, 2]], 
            Times[ 
              Rational[ -1, 2], 
              Power[ x, 2]]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
The scaling of one of the coordinates allows the canonical \
variables\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {x}, {1}, \n\t{w}, {t}] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(t == Log[x]\)},
          {\(w == u - Log[x]\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Log[ x]], 
        Equal[ w, 
          Plus[ u, 
            Times[ -1, 
              Log[ x]]]]}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {1}, {u}, \n\t{w}, {t}] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(t == x\)},
          {\(w == E\^\(-x\)\ u\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, x], 
        Equal[ w, 
          Times[ 
            Power[ E, 
              Times[ -1, x]], u]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Several other examples demonstrate the capabilities of this function. The \
occurrence of the ",
  StyleBox["Log[]", "MmaText"],
  " in one of the infinitesimals demonstrates the flexibility of the \
function"
}], "Text",
  Evaluatable->False,
  CellTags->"Log[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {Log[x]\ u}, {1}, \n\t{w}, {t}] // LTF\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(t == \(-u\)\)},
          {\(w == u\^2\/2 - LogIntegral[x]\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Times[ -1, u]], 
        Equal[ w, 
          Plus[ 
            Times[ 
              Rational[ 1, 2], 
              Power[ u, 2]], 
            Times[ -1, 
              LogIntegral[ x]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "An example with parameters in the infinitesimals shows that ",
  StyleBox["CanonicalVariables[]", "MmaText"],
  " can handle rational expressions:"
}], "Text",
  CellTags->"CanonicalVariables[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u}, {x}, {k1 + k2\ x}, \n
        \t{k3 + 2\ k2\ u}, {w}, {t}] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{"t", "==", 
              StyleBox[\(Log[k1 + k2\ x]\/k2\),
                ScriptLevel->0]}]},
          {
            RowBox[{"w", "==", 
              RowBox[{"-", 
                
                StyleBox[
                  \(\(\(-k3\) - 2\ k2\ u\)\/\(2\ k2\ \((k1 + k2\ x)\)\^2\)\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ t, 
          Times[ 
            Power[ k2, -1], 
            Log[ 
              Plus[ k1, 
                Times[ k2, x]]]]], 
        Equal[ w, 
          Times[ 
            Rational[ -1, 2], 
            Power[ k2, -1], 
            Plus[ 
              Times[ -1, k3], 
              Times[ -2, k2, u]], 
            Power[ 
              Plus[ k1, 
                Times[ k2, x]], -2]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"An example for a higher-dimensional manifold \[GothicCapitalM] is examined \
next:"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CanonicalVariables[{u, v}, {x, t}, {x, t}, \n
        \t{0, 0}, {un, vn}, {xn, tn}] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(tn == Log[x]\)},
          {\(un == u\)},
          {\(vn == v\)},
          {
            RowBox[{"xn", "==", 
              StyleBox[\(t\/x\),
                ScriptLevel->0]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ tn, 
          Log[ x]], 
        Equal[ un, u], 
        Equal[ vn, v], 
        Equal[ xn, 
          Times[ t, 
            Power[ x, -1]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
This list of examples can be extended by the reader's experiments. \
We demonstrated that the knowledge of the infinitesimals allows the \
introduction of new variables. Lie pointed out that these canonical variables \
simplify the solution of the original equation. The advantage of canonical \
coordinates is that we may simplify the solution algorithm. This algorithm \
consists of first finding the infinitesimals, second, calculating the \
canonical variables, and third, transforming the original equation to a \
simpler form. These three steps will be the subject of the next \
sections.\
\>", "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet2.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
WindowSize->{669, 668},
WindowMargins->{{87, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->126,
PrintingPageRange->{122, 122},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Symmetries of Ordinary Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Symmetry Transformations of Differential Equations"}, \
#]&)], FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
NumberMarks->False,
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Symmetry Transformations of Differential Equations"->{
    Cell[1739, 51, 416, 5, 43, "Section",
      CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 8}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Symmetry Transformations of Differential Equations"]},
  "differential equation"->{
    Cell[2158, 58, 643, 12, 95, "Text",
      CellTags->{
      "differential equation", "main properties of a symmetry group", 
        "canonical variables"}]},
  "main properties of a symmetry group"->{
    Cell[2158, 58, 643, 12, 95, "Text",
      CellTags->{
      "differential equation", "main properties of a symmetry group", 
        "canonical variables"}]},
  "canonical variables"->{
    Cell[2158, 58, 643, 12, 95, "Text",
      CellTags->{
      "differential equation", "main properties of a symmetry group", 
        "canonical variables"}],
    Cell[81647, 2509, 1335, 34, 133, "Text",
      CellTags->{
      "point symmetries", "infinitesimals", "canonical variables"}],
    Cell[83104, 2551, 638, 12, 78, "Text",
      CellTags->{"canonical variables", "infinitesimal transformation"}],
    Cell[93254, 2886, 350, 12, 27, "Text",
      CellTags->"canonical variables"],
    Cell[96646, 3010, 852, 28, 78, "Text",
      CellTags->"canonical variables"],
    Cell[102785, 3259, 133, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"canonical variables"]},
  "Definition of a symmetry group"->{
    Cell[2826, 74, 104, 1, 41, "Subsection",
      CellTags->"Definition of a symmetry group"]},
  "point transformation"->{
    Cell[2933, 77, 469, 12, 44, "Text",
      CellTags->{
      "point transformation", "prolongation", 
        "symmetry of a differential equation"}]},
  "prolongation"->{
    Cell[2933, 77, 469, 12, 44, "Text",
      CellTags->{
      "point transformation", "prolongation", 
        "symmetry of a differential equation"}],
    Cell[62568, 1933, 296, 6, 61, "Text",
      CellTags->"prolongation"],
    Cell[65486, 2019, 336, 8, 44, "Text",
      CellTags->{"prolongation", "Frechet derivative"}],
    Cell[73363, 2256, 883, 23, 95, "Text",
      CellTags->{"prolonged vector field", "prolongation"}]},
  "symmetry of a differential equation"->{
    Cell[2933, 77, 469, 12, 44, "Text",
      CellTags->{
      "point transformation", "prolongation", 
        "symmetry of a differential equation"}]},
  "Definition: Symmetry of a differential equation"->{
    Cell[3405, 91, 132, 1, 33, "Definition",
      CellTags->"Definition: Symmetry of a differential equation"]},
  "first-order ordinary differential equation"->{
    Cell[4749, 134, 309, 6, 44, "Text",
      CellTags->"first-order ordinary differential equation"]},
  "eq-2"->{
    Cell[5061, 142, 128, 3, 22, "NumberedEquation",
      CellTags->"eq-2"]},
  "manifold"->{
    Cell[5192, 147, 840, 22, 61, "Text",
      CellTags->{"manifold", "first prolongation", "invariance condition"}],
    Cell[29198, 818, 927, 22, 95, "Text",
      CellTags->{"infinitesimals", "manifold", "redundant information"}]},
  "first prolongation"->{
    Cell[5192, 147, 840, 22, 61, "Text",
      CellTags->{"manifold", "first prolongation", "invariance condition"}],
    Cell[14484, 419, 653, 17, 61, "Text",
      CellTags->{
      "first prolongation", "second prolongation", 
        "determining equation for the group"}]},
  "invariance condition"->{
    Cell[5192, 147, 840, 22, 61, "Text",
      CellTags->{"manifold", "first prolongation", "invariance condition"}],
    Cell[74808, 2301, 281, 4, 44, "Text",
      CellTags->"invariance condition"],
    Cell[75756, 2335, 341, 11, 44, "Text",
      CellTags->"invariance condition"],
    Cell[77071, 2383, 152, 4, 27, "Text",
      CellTags->"invariance condition"],
    Cell[78447, 2422, 973, 20, 112, "Text",
      CellTags->{
      "infinitesimals", "invariance condition", 
        "first-order differential equation", "infinite number of symmetries", 
        "finite number of symmetries"}]},
  "eq-3"->{
    Cell[6035, 171, 153, 4, 22, "NumberedEquation",
      CellTags->"eq-3"]},
  "Main properties of symmetry groups"->{
    Cell[6616, 190, 112, 1, 41, "Subsection",
      CellTags->"Main properties of symmetry groups"]},
  "eq-4"->{
    Cell[7213, 209, 366, 10, 35, "NumberedEquation",
      CellTags->"eq-4"]},
  "main property of a symmetry group"->{
    Cell[7582, 221, 662, 20, 45, "Text",
      CellTags->"main property of a symmetry group"]},
  "Theorem: Symmetry Transformation"->{
    Cell[8247, 243, 99, 1, 33, "Theorem",
      CellTags->"Theorem: Symmetry Transformation"]},
  "calculation of the symmetries"->{
    Cell[9010, 267, 220, 4, 44, "Text",
      CellTags->"calculation of the symmetries"]},
  "Calculation of the infinitesimal symmetries"->{
    Cell[9267, 276, 130, 1, 41, "Subsection",
      CellTags->"Calculation of the infinitesimal symmetries"]},
  "sufficient condition for invariance"->{
    Cell[9400, 279, 1717, 41, 146, "Text",
      CellTags->{
      "sufficient condition for invariance", "infinitesimals", 
        "invariance of a differential equation", "transformation", 
        "tangent vector field"}]},
  "infinitesimals"->{
    Cell[9400, 279, 1717, 41, 146, "Text",
      CellTags->{
      "sufficient condition for invariance", "infinitesimals", 
        "invariance of a differential equation", "transformation", 
        "tangent vector field"}],
    Cell[29198, 818, 927, 22, 95, "Text",
      CellTags->{"infinitesimals", "manifold", "redundant information"}],
    Cell[31209, 874, 1449, 42, 95, "Text",
      CellTags->{
      "infinitesimals", "system of determining equations", 
        "determining equations", "overdetermined system of equations", 
        "infinitesimal symmetries"}],
    Cell[33923, 967, 455, 16, 44, "Text",
      CellTags->{"infinitesimals", "defining equation for infinitesimals"}],
    Cell[44845, 1299, 311, 7, 44, "Text",
      CellTags->"infinitesimals"],
    Cell[61002, 1879, 109, 1, 27, "Text",
      CellTags->"infinitesimals"],
    Cell[62867, 1941, 818, 16, 95, "Text",
      CellTags->{"infinitesimals", "Frechet derivative"}],
    Cell[66086, 2036, 197, 6, 27, "Text",
      CellTags->"infinitesimals"],
    Cell[72206, 2217, 640, 17, 61, "Text",
      CellTags->"infinitesimals"],
    Cell[78447, 2422, 973, 20, 112, "Text",
      CellTags->{
      "infinitesimals", "invariance condition", 
        "first-order differential equation", "infinite number of symmetries", 
        "finite number of symmetries"}],
    Cell[81647, 2509, 1335, 34, 133, "Text",
      CellTags->{
      "point symmetries", "infinitesimals", "canonical variables"}],
    Cell[106810, 3411, 634, 14, 80, "Text",
      Evaluatable->False,
      CellTags->{
      "CanonicalVariables[]", "infinitesimals", "determining equations", 
        "pure function"}]},
  "invariance of a differential equation"->{
    Cell[9400, 279, 1717, 41, 146, "Text",
      CellTags->{
      "sufficient condition for invariance", "infinitesimals", 
        "invariance of a differential equation", "transformation", 
        "tangent vector field"}]},
  "transformation"->{
    Cell[9400, 279, 1717, 41, 146, "Text",
      CellTags->{
      "sufficient condition for invariance", "infinitesimals", 
        "invariance of a differential equation", "transformation", 
        "tangent vector field"}]},
  "tangent vector field"->{
    Cell[9400, 279, 1717, 41, 146, "Text",
      CellTags->{
      "sufficient condition for invariance", "infinitesimals", 
        "invariance of a differential equation", "transformation", 
        "tangent vector field"}]},
  "infinitesimal symmetries"->{
    Cell[11120, 322, 952, 21, 95, "Text",
      CellTags->{
      "infinitesimal symmetries", "infinite number of symmetries", 
        "conformal symmetries", "second-order differential equation"}],
    Cell[31209, 874, 1449, 42, 95, "Text",
      CellTags->{
      "infinitesimals", "system of determining equations", 
        "determining equations", "overdetermined system of equations", 
        "infinitesimal symmetries"}]},
  "infinite number of symmetries"->{
    Cell[11120, 322, 952, 21, 95, "Text",
      CellTags->{
      "infinitesimal symmetries", "infinite number of symmetries", 
        "conformal symmetries", "second-order differential equation"}],
    Cell[78447, 2422, 973, 20, 112, "Text",
      CellTags->{
      "infinitesimals", "invariance condition", 
        "first-order differential equation", "infinite number of symmetries", 
        "finite number of symmetries"}]},
  "conformal symmetries"->{
    Cell[11120, 322, 952, 21, 95, "Text",
      CellTags->{
      "infinitesimal symmetries", "infinite number of symmetries", 
        "conformal symmetries", "second-order differential equation"}]},
  "second-order differential equation"->{
    Cell[11120, 322, 952, 21, 95, "Text",
      CellTags->{
      "infinitesimal symmetries", "infinite number of symmetries", 
        "conformal symmetries", "second-order differential equation"}]},
  "infinitesimal invariance criterion"->{
    Cell[12739, 364, 475, 16, 44, "Text",
      CellTags->"infinitesimal invariance criterion"]},
  "prolongation formula"->{
    Cell[13477, 389, 636, 16, 61, "Text",
      CellTags->"prolongation formula"]},
  "second prolongation"->{
    Cell[14484, 419, 653, 17, 61, "Text",
      CellTags->{
      "first prolongation", "second prolongation", 
        "determining equation for the group"}]},
  "determining equation for the group"->{
    Cell[14484, 419, 653, 17, 61, "Text",
      CellTags->{
      "first prolongation", "second prolongation", 
        "determining equation for the group"}]},
  "equat"->{
    Cell[15339, 447, 76, 2, 23, "Input",
      CellTags->"equat"]},
  "determining equation"->{
    Cell[15481, 455, 212, 4, 44, "Text",
      CellTags->{"determining equation", "extended vector field"}],
    Cell[27904, 778, 266, 9, 27, "Text",
      CellTags->"determining equation"]},
  "extended vector field"->{
    Cell[15481, 455, 212, 4, 44, "Text",
      CellTags->{"determining equation", "extended vector field"}]},
  "first extension"->{
    Cell[16144, 479, 1271, 43, 78, "Text",
      CellTags->{"first extension", "second extension"}]},
  "second extension"->{
    Cell[16144, 479, 1271, 43, 78, "Text",
      CellTags->{"first extension", "second extension"}]},
  "redundant information"->{
    Cell[29198, 818, 927, 22, 95, "Text",
      CellTags->{"infinitesimals", "manifold", "redundant information"}]},
  "system of determining equations"->{
    Cell[31209, 874, 1449, 42, 95, "Text",
      CellTags->{
      "infinitesimals", "system of determining equations", 
        "determining equations", "overdetermined system of equations", 
        "infinitesimal symmetries"}]},
  "determining equations"->{
    Cell[31209, 874, 1449, 42, 95, "Text",
      CellTags->{
      "infinitesimals", "system of determining equations", 
        "determining equations", "overdetermined system of equations", 
        "infinitesimal symmetries"}],
    Cell[40560, 1165, 869, 36, 44, "Text",
      CellTags->"determining equations"],
    Cell[51956, 1536, 106, 1, 27, "Text",
      CellTags->"determining equations"],
    Cell[55900, 1685, 271, 7, 44, "Text",
      CellTags->{"determining equations", "overdetermined system"}],
    Cell[106810, 3411, 634, 14, 80, "Text",
      Evaluatable->False,
      CellTags->{
      "CanonicalVariables[]", "infinitesimals", "determining equations", 
        "pure function"}]},
  "overdetermined system of equations"->{
    Cell[31209, 874, 1449, 42, 95, "Text",
      CellTags->{
      "infinitesimals", "system of determining equations", 
        "determining equations", "overdetermined system of equations", 
        "infinitesimal symmetries"}]},
  "nonlinear ordinary differential equation"->{
    Cell[33337, 946, 378, 10, 46, "Text",
      CellTags->{"nonlinear ordinary differential equation", "LTF[]"}]},
  "LTF[]"->{
    Cell[33337, 946, 378, 10, 46, "Text",
      CellTags->{"nonlinear ordinary differential equation", "LTF[]"}]},
  "defining equation for infinitesimals"->{
    Cell[33923, 967, 455, 16, 44, "Text",
      CellTags->{"infinitesimals", "defining equation for infinitesimals"}]},
  "defining equations for infinitesimals"->{
    Cell[39573, 1139, 371, 5, 61, "Text",
      CellTags->"defining equations for infinitesimals"]},
  "simplify the determining equations"->{
    Cell[45610, 1323, 160, 4, 27, "Text",
      CellTags->"simplify the determining equations"]},
  "pure function"->{
    Cell[55535, 1668, 132, 4, 27, "Text",
      CellTags->"pure function"],
    Cell[98487, 3078, 290, 8, 44, "Text",
      CellTags->"pure function"],
    Cell[106810, 3411, 634, 14, 80, "Text",
      Evaluatable->False,
      CellTags->{
      "CanonicalVariables[]", "infinitesimals", "determining equations", 
        "pure function"}]},
  "overdetermined system"->{
    Cell[55900, 1685, 271, 7, 44, "Text",
      CellTags->{"determining equations", "overdetermined system"}]},
  "group parameters"->{
    Cell[61428, 1894, 458, 11, 61, "Text",
      CellTags->{"group parameters", "linearity of determining equations"}]},
  "linearity of determining equations"->{
    Cell[61428, 1894, 458, 11, 61, "Text",
      CellTags->{"group parameters", "linearity of determining equations"}]},
  "linearly independent operators"->{
    Cell[62294, 1927, 271, 4, 44, "Text",
      CellTags->"linearly independent operators"]},
  "Frechet derivative"->{
    Cell[62867, 1941, 818, 16, 95, "Text",
      CellTags->{"infinitesimals", "Frechet derivative"}],
    Cell[65486, 2019, 336, 8, 44, "Text",
      CellTags->{"prolongation", "Frechet derivative"}]},
  "eq-8"->{
    Cell[63688, 1959, 416, 11, 35, "NumberedEquation",
      CellTags->"eq-8"]},
  "FrechetD[]"->{
    Cell[64107, 1972, 268, 10, 27, "Text",
      CellTags->"FrechetD[]"]},
  "test function"->{
    Cell[64378, 1984, 1105, 33, 95, "Text",
      CellTags->{"test function", "support function"}]},
  "support function"->{
    Cell[64378, 1984, 1105, 33, 95, "Text",
      CellTags->{"test function", "support function"}]},
  "eq-11"->{
    Cell[66696, 2057, 1553, 36, 39, "NumberedEquation",
      CellTags->"eq-11"]},
  "algorithm"->{
    Cell[68252, 2095, 281, 4, 44, "Text",
      CellTags->{"algorithm", "algorithm calculating the prolongation"}]},
  "algorithm calculating the prolongation"->{
    Cell[68252, 2095, 281, 4, 44, "Text",
      CellTags->{"algorithm", "algorithm calculating the prolongation"}]},
  "ProlongationODE[]"->{
    Cell[68936, 2118, 688, 16, 84, "Text",
      CellTags->"ProlongationODE[]"],
    Cell[69627, 2136, 1065, 23, 279, "Input",
      CellTags->"ProlongationODE[]"],
    Cell[70695, 2161, 192, 5, 29, "Text",
      CellTags->"ProlongationODE[]"],
    Cell[71366, 2188, 357, 9, 46, "Text",
      CellTags->"ProlongationODE[]"],
    Cell[80426, 2474, 281, 6, 46, "Text",
      CellTags->"ProlongationODE[]"]},
  "pode3"->{
    Cell[72871, 2238, 131, 3, 23, "Input",
      CellTags->"pode3"]},
  "prolonged vector field"->{
    Cell[73363, 2256, 883, 23, 95, "Text",
      CellTags->{"prolonged vector field", "prolongation"}]},
  "invariance equation"->{
    Cell[76666, 2369, 108, 1, 27, "Text",
      CellTags->"invariance equation"]},
  "independent variables"->{
    Cell[77565, 2404, 879, 16, 112, "Text",
      CellTags->{
      "independent variables", "dependent variables", 
        "paper and pencil calculations", "symbolic calculation"}]},
  "dependent variables"->{
    Cell[77565, 2404, 879, 16, 112, "Text",
      CellTags->{
      "independent variables", "dependent variables", 
        "paper and pencil calculations", "symbolic calculation"}]},
  "paper and pencil calculations"->{
    Cell[77565, 2404, 879, 16, 112, "Text",
      CellTags->{
      "independent variables", "dependent variables", 
        "paper and pencil calculations", "symbolic calculation"}]},
  "symbolic calculation"->{
    Cell[77565, 2404, 879, 16, 112, "Text",
      CellTags->{
      "independent variables", "dependent variables", 
        "paper and pencil calculations", "symbolic calculation"}]},
  "first-order differential equation"->{
    Cell[78447, 2422, 973, 20, 112, "Text",
      CellTags->{
      "infinitesimals", "invariance condition", 
        "first-order differential equation", "infinite number of symmetries", 
        "finite number of symmetries"}]},
  "finite number of symmetries"->{
    Cell[78447, 2422, 973, 20, 112, "Text",
      CellTags->{
      "infinitesimals", "invariance condition", 
        "first-order differential equation", "infinite number of symmetries", 
        "finite number of symmetries"}]},
  "point symmetries"->{
    Cell[81647, 2509, 1335, 34, 133, "Text",
      CellTags->{
      "point symmetries", "infinitesimals", "canonical variables"}]},
  "Canonical variables"->{
    Cell[83019, 2548, 82, 1, 41, "Subsection",
      CellTags->"Canonical variables"]},
  "infinitesimal transformation"->{
    Cell[83104, 2551, 638, 12, 78, "Text",
      CellTags->{"canonical variables", "infinitesimal transformation"}],
    Cell[86063, 2645, 271, 7, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal transformation", 
        "linear combination of transformations"}],
    Cell[89248, 2746, 406, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"infinitesimal transformation"]},
  "Lie product"->{
    Cell[84390, 2586, 185, 7, 27, "Text",
      Evaluatable->False,
      CellTags->"Lie product"]},
  "linear combination of transformations"->{
    Cell[86063, 2645, 271, 7, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimal transformation", 
        "linear combination of transformations"}]},
  "commuting infinitesimal transformation"->{
    Cell[87151, 2676, 628, 20, 44, "Text",
      Evaluatable->False,
      CellTags->"commuting infinitesimal transformation"]},
  "Theorem: Canonical variables"->{
    Cell[89154, 2743, 91, 1, 33, "Theorem",
      CellTags->"Theorem: Canonical variables"]},
  "two-dimensional group"->{
    Cell[90274, 2783, 210, 5, 44, "Text",
      Evaluatable->False,
      CellTags->"two-dimensional group"]},
  "Definition: Canonical variable"->{
    Cell[90557, 2792, 98, 1, 33, "Definition",
      CellTags->"Definition: Canonical variable"]},
  "group of translation"->{
    Cell[90658, 2795, 456, 15, 44, "Text",
      CellTags->"group of translation"]},
  "invariance of transformation"->{
    Cell[91990, 2845, 255, 5, 44, "Text",
      CellTags->"invariance of transformation"]},
  "calculation of canonical variables"->{
    Cell[93756, 2904, 453, 7, 61, "Text",
      CellTags->{
      "calculation of canonical variables", 
        "derivation of canonical variables"}]},
  "derivation of canonical variables"->{
    Cell[93756, 2904, 453, 7, 61, "Text",
      CellTags->{
      "calculation of canonical variables", 
        "derivation of canonical variables"}]},
  "scaling symmetry"->{
    Cell[94243, 2915, 219, 5, 44, "Text",
      CellTags->"scaling symmetry"]},
  "equations for canonical variables"->{
    Cell[94755, 2933, 153, 4, 27, "Text",
      CellTags->"equations for canonical variables"]},
  "DSolve[]"->{
    Cell[95681, 2969, 363, 10, 46, "Text",
      CellTags->{"DSolve[]", "partial differential equation"}],
    Cell[97667, 3049, 582, 16, 63, "Text",
      CellTags->"DSolve[]"],
    Cell[105169, 3347, 202, 6, 29, "Text",
      Evaluatable->False,
      CellTags->"DSolve[]"]},
  "partial differential equation"->{
    Cell[95681, 2969, 363, 10, 46, "Text",
      CellTags->{"DSolve[]", "partial differential equation"}]},
  "rotation and canonical variables"->{
    Cell[99688, 3128, 221, 5, 44, "Text",
      Evaluatable->False,
      CellTags->"rotation and canonical variables"]},
  "projective group"->{
    Cell[103801, 3295, 170, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"projective group"]},
  "determining equations for canonical variables"->{
    Cell[104260, 3313, 142, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"determining equations for canonical variables"]},
  "canonical variables of the projective group"->{
    Cell[106612, 3406, 195, 3, 27, "Text",
      CellTags->"canonical variables of the projective group"]},
  "CanonicalVariables[]"->{
    Cell[106810, 3411, 634, 14, 80, "Text",
      Evaluatable->False,
      CellTags->{
      "CanonicalVariables[]", "infinitesimals", "determining equations", 
        "pure function"}],
    Cell[108067, 3441, 2366, 45, 585, "Input",
      CellTags->{"CanonicalVariables[", "CanonicalVariables[]"}],
    Cell[110436, 3488, 613, 19, 63, "Text",
      Evaluatable->False,
      CellTags->{"CanonicalVariables[]", "inhomogeneous scaling group"}],
    Cell[117231, 3752, 214, 5, 29, "Text",
      CellTags->"CanonicalVariables[]"]},
  "CanonicalVariables["->{
    Cell[108067, 3441, 2366, 45, 585, "Input",
      CellTags->{"CanonicalVariables[", "CanonicalVariables[]"}]},
  "inhomogeneous scaling group"->{
    Cell[110436, 3488, 613, 19, 63, "Text",
      Evaluatable->False,
      CellTags->{"CanonicalVariables[]", "inhomogeneous scaling group"}]},
  "translation group"->{
    Cell[112575, 3567, 127, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"translation group"]},
  "rotation"->{
    Cell[113547, 3604, 138, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"rotation"]},
  "Log[]"->{
    Cell[116295, 3715, 283, 8, 46, "Text",
      Evaluatable->False,
      CellTags->"Log[]"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Symmetry Transformations of Differential Equations", 121949, 3903},
  {"differential equation", 122331, 3910},
  {"main properties of a symmetry group", 122537, 3915},
  {"canonical variables", 122727, 3920},
  {"Definition of a symmetry group", 123452, 3937},
  {"point transformation", 123577, 3940},
  {"prolongation", 123752, 3945},
  {"symmetry of a differential equation", 124228, 3956},
  {"Definition: Symmetry of a differential equation", 124438, 3961},
  {"first-order ordinary differential equation", 124602, 3964},
  {"eq-2", 124718, 3967},
  {"manifold", 124812, 3970},
  {"first prolongation", 125073, 3975},
  {"invariance condition", 125380, 3982},
  {"eq-3", 125992, 3996},
  {"Main properties of symmetry groups", 126112, 3999},
  {"eq-4", 126226, 4002},
  {"main property of a symmetry group", 126346, 4005},
  {"Theorem: Symmetry Transformation", 126482, 4008},
  {"calculation of the symmetries", 126615, 4011},
  {"Calculation of the infinitesimal symmetries", 126757, 4014},
  {"sufficient condition for invariance", 126911, 4017},
  {"infinitesimals", 127161, 4023},
  {"invariance of a differential equation", 128863, 4061},
  {"transformation", 129113, 4067},
  {"tangent vector field", 129369, 4073},
  {"infinitesimal symmetries", 129629, 4079},
  {"infinite number of symmetries", 130098, 4089},
  {"conformal symmetries", 130558, 4099},
  {"second-order differential equation", 130801, 4104},
  {"infinitesimal invariance criterion", 131044, 4109},
  {"prolongation formula", 131170, 4112},
  {"second prolongation", 131281, 4115},
  {"determining equation for the group", 131484, 4120},
  {"equat", 131658, 4125},
  {"determining equation", 131754, 4128},
  {"extended vector field", 131975, 4133},
  {"first extension", 132108, 4136},
  {"second extension", 132234, 4139},
  {"redundant information", 132365, 4142},
  {"system of determining equations", 132521, 4145},
  {"determining equations", 132782, 4151},
  {"overdetermined system of equations", 133525, 4168},
  {"nonlinear ordinary differential equation", 133805, 4174},
  {"LTF[]", 133933, 4177},
  {"defining equation for infinitesimals", 134092, 4180},
  {"defining equations for infinitesimals", 134257, 4183},
  {"simplify the determining equations", 134400, 4186},
  {"pure function", 134519, 4189},
  {"overdetermined system", 134890, 4199},
  {"group parameters", 135026, 4202},
  {"linearity of determining equations", 135189, 4205},
  {"linearly independent operators", 135348, 4208},
  {"Frechet derivative", 135468, 4211},
  {"eq-8", 135682, 4216},
  {"FrechetD[]", 135781, 4219},
  {"test function", 135877, 4222},
  {"support function", 136002, 4225},
  {"eq-11", 136116, 4228},
  {"algorithm", 136216, 4231},
  {"algorithm calculating the prolongation", 136379, 4234},
  {"ProlongationODE[]", 136521, 4237},
  {"pode3", 136940, 4248},
  {"prolonged vector field", 137040, 4251},
  {"invariance equation", 137172, 4254},
  {"independent variables", 137284, 4257},
  {"dependent variables", 137496, 4262},
  {"paper and pencil calculations", 137718, 4267},
  {"symbolic calculation", 137931, 4272},
  {"first-order differential equation", 138157, 4277},
  {"finite number of symmetries", 138424, 4283},
  {"point symmetries", 138680, 4289},
  {"Canonical variables", 138840, 4293},
  {"infinitesimal transformation", 138964, 4296},
  {"Lie product", 139395, 4307},
  {"linear combination of transformations", 139541, 4311},
  {"commuting infinitesimal transformation", 139764, 4317},
  {"Theorem: Canonical variables", 139929, 4321},
  {"two-dimensional group", 140052, 4324},
  {"Definition: Canonical variable", 140201, 4328},
  {"group of translation", 140328, 4331},
  {"invariance of transformation", 140449, 4334},
  {"calculation of canonical variables", 140583, 4337},
  {"derivation of canonical variables", 140777, 4342},
  {"scaling symmetry", 140954, 4347},
  {"equations for canonical variables", 141075, 4350},
  {"DSolve[]", 141188, 4353},
  {"partial differential equation", 141503, 4361},
  {"rotation and canonical variables", 141651, 4364},
  {"projective group", 141797, 4368},
  {"determining equations for canonical variables", 141957, 4372},
  {"canonical variables of the projective group", 142144, 4376},
  {"CanonicalVariables[]", 142280, 4379},
  {"CanonicalVariables[", 142838, 4392},
  {"inhomogeneous scaling group", 142987, 4395},
  {"translation group", 143157, 4399},
  {"rotation", 143281, 4403},
  {"Log[]", 143393, 4407}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 416, 5, 43, "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 8}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Symmetry Transformations of Differential Equations"],
Cell[2158, 58, 643, 12, 95, "Text",
  CellTags->{
  "differential equation", "main properties of a symmetry group", 
    "canonical variables"}],

Cell[CellGroupData[{
Cell[2826, 74, 104, 1, 41, "Subsection",
  CellTags->"Definition of a symmetry group"],
Cell[2933, 77, 469, 12, 44, "Text",
  CellTags->{
  "point transformation", "prolongation", 
    "symmetry of a differential equation"}],
Cell[3405, 91, 132, 1, 33, "Definition",
  CellTags->"Definition: Symmetry of a differential equation"],
Cell[3540, 94, 204, 6, 27, "Text"],
Cell[3747, 102, 539, 14, 35, "NumberedEquation"],
Cell[4289, 118, 457, 14, 44, "Text"],
Cell[4749, 134, 309, 6, 44, "Text",
  CellTags->"first-order ordinary differential equation"],
Cell[5061, 142, 128, 3, 22, "NumberedEquation",
  CellTags->"eq-2"],
Cell[5192, 147, 840, 22, 61, "Text",
  CellTags->{"manifold", "first prolongation", "invariance condition"}],
Cell[6035, 171, 153, 4, 22, "NumberedEquation",
  CellTags->"eq-3"],
Cell[6191, 177, 388, 8, 61, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6616, 190, 112, 1, 41, "Subsection",
  CellTags->"Main properties of symmetry groups"],
Cell[6731, 193, 479, 14, 46, "Text"],
Cell[7213, 209, 366, 10, 35, "NumberedEquation",
  CellTags->"eq-4"],
Cell[7582, 221, 662, 20, 45, "Text",
  CellTags->"main property of a symmetry group"],
Cell[8247, 243, 99, 1, 33, "Theorem",
  CellTags->"Theorem: Symmetry Transformation"],
Cell[8349, 246, 251, 6, 44, "Text"],
Cell[8603, 254, 310, 8, 35, "NumberedEquation"],
Cell[8916, 264, 91, 1, 27, "Text"],
Cell[9010, 267, 220, 4, 44, "Text",
  CellTags->"calculation of the symmetries"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9267, 276, 130, 1, 41, "Subsection",
  CellTags->"Calculation of the infinitesimal symmetries"],
Cell[9400, 279, 1717, 41, 146, "Text",
  CellTags->{
  "sufficient condition for invariance", "infinitesimals", 
    "invariance of a differential equation", "transformation", 
    "tangent vector field"}],
Cell[11120, 322, 952, 21, 95, "Text",
  CellTags->{
  "infinitesimal symmetries", "infinite number of symmetries", 
    "conformal symmetries", "second-order differential equation"}],
Cell[12075, 345, 111, 2, 22, "NumberedEquation"],
Cell[12189, 349, 240, 6, 27, "Text"],
Cell[12432, 357, 304, 5, 39, "Input"],
Cell[12739, 364, 475, 16, 44, "Text",
  CellTags->"infinitesimal invariance criterion"],
Cell[13217, 382, 257, 5, 22, "NumberedEquation"],
Cell[13477, 389, 636, 16, 61, "Text",
  CellTags->"prolongation formula"],

Cell[CellGroupData[{
Cell[14138, 409, 141, 2, 23, "Input"],
Cell[14282, 413, 187, 3, 23, "Output"]
}, Open  ]],
Cell[14484, 419, 653, 17, 61, "Text",
  CellTags->{
  "first prolongation", "second prolongation", 
    "determining equation for the group"}],
Cell[15140, 438, 174, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[15339, 447, 76, 2, 23, "Input",
  CellTags->"equat"],
Cell[15418, 451, 48, 1, 23, "Output"]
}, Open  ]],
Cell[15481, 455, 212, 4, 44, "Text",
  CellTags->{"determining equation", "extended vector field"}],

Cell[CellGroupData[{
Cell[15718, 463, 81, 1, 23, "Input"],
Cell[15802, 466, 327, 10, 23, "Output"]
}, Open  ]],
Cell[16144, 479, 1271, 43, 78, "Text",
  CellTags->{"first extension", "second extension"}],

Cell[CellGroupData[{
Cell[17440, 526, 884, 20, 55, "Input"],
Cell[18327, 548, 891, 22, 74, "Output"]
}, Open  ]],
Cell[19233, 573, 512, 17, 44, "Text"],

Cell[CellGroupData[{
Cell[19770, 594, 285, 5, 55, "Input"],
Cell[20058, 601, 7831, 174, 68, "Output"]
}, Open  ]],
Cell[27904, 778, 266, 9, 27, "Text",
  CellTags->"determining equation"],

Cell[CellGroupData[{
Cell[28195, 791, 77, 1, 23, "Input"],
Cell[28275, 794, 908, 21, 38, "Output"]
}, Open  ]],
Cell[29198, 818, 927, 22, 95, "Text",
  CellTags->{"infinitesimals", "manifold", "redundant information"}],

Cell[CellGroupData[{
Cell[30150, 844, 180, 5, 39, "Input"],
Cell[30333, 851, 861, 20, 38, "Output"]
}, Open  ]],
Cell[31209, 874, 1449, 42, 95, "Text",
  CellTags->{
  "infinitesimals", "system of determining equations", 
    "determining equations", "overdetermined system of equations", 
    "infinitesimal symmetries"}],
Cell[32661, 918, 28, 0, 29, "Example"],
Cell[32692, 920, 98, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[32815, 927, 120, 2, 34, "Input"],
Cell[32938, 931, 384, 12, 32, "Output"]
}, Open  ]],
Cell[33337, 946, 378, 10, 46, "Text",
  CellTags->{"nonlinear ordinary differential equation", "LTF[]"}],

Cell[CellGroupData[{
Cell[33740, 960, 87, 1, 32, "Input"],
Cell[33830, 963, 78, 1, 32, "Output"]
}, Open  ]],
Cell[33923, 967, 455, 16, 44, "Text",
  CellTags->{"infinitesimals", "defining equation for infinitesimals"}],

Cell[CellGroupData[{
Cell[34403, 987, 119, 2, 23, "Input"],
Cell[34525, 991, 1858, 43, 58, "Output"]
}, Open  ]],
Cell[36398, 1037, 459, 12, 61, "Text"],

Cell[CellGroupData[{
Cell[36882, 1053, 191, 5, 39, "Input"],
Cell[37076, 1060, 842, 23, 72, "Output"]
}, Open  ]],
Cell[37933, 1086, 146, 5, 27, "Text"],
Cell[38082, 1093, 249, 6, 55, "Input"],

Cell[CellGroupData[{
Cell[38356, 1103, 66, 1, 23, "Input"],
Cell[38425, 1106, 1133, 30, 98, "Output"]
}, Open  ]],
Cell[39573, 1139, 371, 5, 61, "Text",
  CellTags->"defining equations for infinitesimals"],

Cell[CellGroupData[{
Cell[39969, 1148, 304, 6, 81, "Input"],
Cell[40276, 1156, 269, 6, 51, "Output"]
}, Open  ]],
Cell[40560, 1165, 869, 36, 44, "Text",
  CellTags->"determining equations"],

Cell[CellGroupData[{
Cell[41454, 1205, 80, 1, 23, "Input"],
Cell[41537, 1208, 3293, 88, 128, "Output"]
}, Open  ]],
Cell[44845, 1299, 311, 7, 44, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[45181, 1310, 74, 1, 23, "Input"],
Cell[45258, 1313, 337, 7, 51, "Output"]
}, Open  ]],
Cell[45610, 1323, 160, 4, 27, "Text",
  CellTags->"simplify the determining equations"],

Cell[CellGroupData[{
Cell[45795, 1331, 74, 1, 23, "Input"],
Cell[45872, 1334, 1679, 46, 110, "Output"]
}, Open  ]],
Cell[47566, 1383, 826, 27, 78, "Text"],

Cell[CellGroupData[{
Cell[48417, 1414, 216, 5, 55, "Input"],
Cell[48636, 1421, 553, 17, 60, "Output"]
}, Open  ]],
Cell[49204, 1441, 202, 6, 27, "Text"],

Cell[CellGroupData[{
Cell[49431, 1451, 159, 3, 55, "Input"],
Cell[49593, 1456, 1098, 32, 86, "Output"]
}, Open  ]],
Cell[50706, 1491, 156, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[50887, 1500, 158, 3, 39, "Input"],
Cell[51048, 1505, 893, 28, 138, "Output"]
}, Open  ]],
Cell[51956, 1536, 106, 1, 27, "Text",
  CellTags->"determining equations"],

Cell[CellGroupData[{
Cell[52087, 1541, 69, 1, 23, "Input"],
Cell[52159, 1544, 893, 28, 138, "Output"]
}, Open  ]],
Cell[53067, 1575, 240, 6, 44, "Text"],

Cell[CellGroupData[{
Cell[53332, 1585, 79, 1, 23, "Input"],
Cell[53414, 1588, 73, 1, 23, "Output"]
}, Open  ]],
Cell[53502, 1592, 251, 8, 44, "Text"],

Cell[CellGroupData[{
Cell[53778, 1604, 68, 1, 23, "Input"],
Cell[53849, 1607, 829, 26, 124, "Output"]
}, Open  ]],
Cell[54693, 1636, 548, 18, 61, "Text"],

Cell[CellGroupData[{
Cell[55266, 1658, 152, 3, 23, "Input"],
Cell[55421, 1663, 99, 2, 34, "Output"]
}, Open  ]],
Cell[55535, 1668, 132, 4, 27, "Text",
  CellTags->"pure function"],

Cell[CellGroupData[{
Cell[55692, 1676, 73, 1, 23, "Input"],
Cell[55768, 1679, 117, 3, 34, "Output"]
}, Open  ]],
Cell[55900, 1685, 271, 7, 44, "Text",
  CellTags->{"determining equations", "overdetermined system"}],

Cell[CellGroupData[{
Cell[56196, 1696, 79, 1, 23, "Input"],
Cell[56278, 1699, 706, 22, 96, "Output"]
}, Open  ]],
Cell[56999, 1724, 342, 9, 44, "Text"],

Cell[CellGroupData[{
Cell[57366, 1737, 136, 3, 23, "Input"],
Cell[57505, 1742, 271, 7, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57813, 1754, 77, 1, 23, "Input"],
Cell[57893, 1757, 931, 28, 96, "Output"]
}, Open  ]],
Cell[58839, 1788, 322, 8, 44, "Text"],

Cell[CellGroupData[{
Cell[59186, 1800, 151, 3, 23, "Input"],
Cell[59340, 1805, 254, 6, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59631, 1816, 87, 1, 23, "Input"],
Cell[59721, 1819, 504, 18, 84, "Output"]
}, Open  ]],
Cell[60240, 1840, 412, 17, 44, "Text"],

Cell[CellGroupData[{
Cell[60677, 1861, 67, 1, 23, "Input"],
Cell[60747, 1864, 61, 1, 23, "Output"]
}, Open  ]],
Cell[60823, 1868, 41, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[60889, 1872, 46, 1, 23, "Input"],
Cell[60938, 1875, 49, 1, 23, "Output"]
}, Open  ]],
Cell[61002, 1879, 109, 1, 27, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[61136, 1884, 155, 3, 39, "Input"],
Cell[61294, 1889, 119, 2, 34, "Output"]
}, Open  ]],
Cell[61428, 1894, 458, 11, 61, "Text",
  CellTags->{"group parameters", "linearity of determining equations"}],

Cell[CellGroupData[{
Cell[61911, 1909, 84, 1, 23, "Input"],
Cell[61998, 1912, 83, 1, 34, "Output"]
}, Open  ]],
Cell[62096, 1916, 19, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[62140, 1920, 84, 1, 23, "Input"],
Cell[62227, 1923, 52, 1, 32, "Output"]
}, Open  ]],
Cell[62294, 1927, 271, 4, 44, "Text",
  CellTags->"linearly independent operators"],
Cell[62568, 1933, 296, 6, 61, "Text",
  CellTags->"prolongation"],
Cell[62867, 1941, 818, 16, 95, "Text",
  CellTags->{"infinitesimals", "Frechet derivative"}],
Cell[63688, 1959, 416, 11, 35, "NumberedEquation",
  CellTags->"eq-8"],
Cell[64107, 1972, 268, 10, 27, "Text",
  CellTags->"FrechetD[]"],
Cell[64378, 1984, 1105, 33, 95, "Text",
  CellTags->{"test function", "support function"}],
Cell[65486, 2019, 336, 8, 44, "Text",
  CellTags->{"prolongation", "Frechet derivative"}],
Cell[65825, 2029, 258, 5, 40, "NumberedEquation"],
Cell[66086, 2036, 197, 6, 27, "Text",
  CellTags->"infinitesimals"],
Cell[66286, 2044, 285, 6, 48, "NumberedEquation"],
Cell[66574, 2052, 119, 3, 27, "Text"],
Cell[66696, 2057, 1553, 36, 39, "NumberedEquation",
  CellTags->"eq-11"],
Cell[68252, 2095, 281, 4, 44, "Text",
  CellTags->{"algorithm", "algorithm calculating the prolongation"}],
Cell[68536, 2101, 164, 5, 20, "ListItem"],
Cell[68703, 2108, 121, 3, 20, "ListItem"],
Cell[68827, 2113, 106, 3, 20, "ListItem"],
Cell[68936, 2118, 688, 16, 84, "Text",
  CellTags->"ProlongationODE[]"],
Cell[69627, 2136, 1065, 23, 279, "Input",
  CellTags->"ProlongationODE[]"],
Cell[70695, 2161, 192, 5, 29, "Text",
  CellTags->"ProlongationODE[]"],
Cell[70890, 2168, 28, 0, 29, "Example"],
Cell[70921, 2170, 74, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[71020, 2174, 91, 1, 23, "Input"],
Cell[71114, 2177, 237, 8, 23, "Output"]
}, Open  ]],
Cell[71366, 2188, 357, 9, 46, "Text",
  CellTags->"ProlongationODE[]"],

Cell[CellGroupData[{
Cell[71748, 2201, 88, 1, 23, "Input"],
Cell[71839, 2204, 352, 10, 24, "Output"]
}, Open  ]],
Cell[72206, 2217, 640, 17, 61, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[72871, 2238, 131, 3, 23, "Input",
  CellTags->"pode3"],
Cell[73005, 2243, 343, 10, 24, "Output"]
}, Open  ]],
Cell[73363, 2256, 883, 23, 95, "Text",
  CellTags->{"prolonged vector field", "prolongation"}],

Cell[CellGroupData[{
Cell[74271, 2283, 176, 3, 39, "Input"],
Cell[74450, 2288, 343, 10, 24, "Output"]
}, Open  ]],
Cell[74808, 2301, 281, 4, 44, "Text",
  CellTags->"invariance condition"],
Cell[75092, 2307, 28, 0, 29, "Example"],
Cell[75123, 2309, 102, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[75250, 2316, 141, 2, 23, "Input"],
Cell[75394, 2320, 347, 12, 23, "Output"]
}, Open  ]],
Cell[75756, 2335, 341, 11, 44, "Text",
  CellTags->"invariance condition"],

Cell[CellGroupData[{
Cell[76122, 2350, 165, 4, 39, "Input"],
Cell[76290, 2356, 361, 10, 24, "Output"]
}, Open  ]],
Cell[76666, 2369, 108, 1, 27, "Text",
  CellTags->"invariance equation"],

Cell[CellGroupData[{
Cell[76799, 2374, 136, 2, 54, "Input"],
Cell[76938, 2378, 118, 2, 36, "Output"]
}, Open  ]],
Cell[77071, 2383, 152, 4, 27, "Text",
  CellTags->"invariance condition"],

Cell[CellGroupData[{
Cell[77248, 2391, 72, 1, 23, "Input"],
Cell[77323, 2394, 39, 1, 23, "Output"]
}, Open  ]],
Cell[77377, 2398, 185, 4, 27, "Text"],
Cell[77565, 2404, 879, 16, 112, "Text",
  CellTags->{
  "independent variables", "dependent variables", 
    "paper and pencil calculations", "symbolic calculation"}],
Cell[78447, 2422, 973, 20, 112, "Text",
  CellTags->{
  "infinitesimals", "invariance condition", 
    "first-order differential equation", "infinite number of symmetries", 
    "finite number of symmetries"}],
Cell[79423, 2444, 28, 0, 29, "Example"],
Cell[79454, 2446, 564, 9, 95, "Text"],

Cell[CellGroupData[{
Cell[80043, 2459, 121, 2, 23, "Input"],
Cell[80167, 2463, 244, 8, 23, "Output"]
}, Open  ]],
Cell[80426, 2474, 281, 6, 46, "Text",
  CellTags->"ProlongationODE[]"],

Cell[CellGroupData[{
Cell[80732, 2484, 169, 4, 39, "Input"],
Cell[80904, 2490, 728, 16, 38, "Output"]
}, Open  ]],
Cell[81647, 2509, 1335, 34, 133, "Text",
  CellTags->{"point symmetries", "infinitesimals", "canonical variables"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[83019, 2548, 82, 1, 41, "Subsection",
  CellTags->"Canonical variables"],
Cell[83104, 2551, 638, 12, 78, "Text",
  CellTags->{"canonical variables", "infinitesimal transformation"}],
Cell[83745, 2565, 340, 9, 44, "Text",
  Evaluatable->False],
Cell[84088, 2576, 299, 8, 22, "NumberedEquation",
  Evaluatable->False],
Cell[84390, 2586, 185, 7, 27, "Text",
  Evaluatable->False,
  CellTags->"Lie product"],
Cell[84578, 2595, 612, 17, 22, "NumberedEquation",
  Evaluatable->False],
Cell[85193, 2614, 516, 17, 61, "Text",
  Evaluatable->False],
Cell[85712, 2633, 348, 10, 22, "NumberedEquation",
  Evaluatable->False],
Cell[86063, 2645, 271, 7, 44, "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimal transformation", "linear combination of transformations"}],
Cell[86337, 2654, 811, 20, 22, "NumberedEquation",
  Evaluatable->False],
Cell[87151, 2676, 628, 20, 44, "Text",
  Evaluatable->False,
  CellTags->"commuting infinitesimal transformation"],
Cell[87782, 2698, 339, 9, 35, "NumberedEquation",
  Evaluatable->False],
Cell[88124, 2709, 41, 1, 27, "Text",
  Evaluatable->False],
Cell[88168, 2712, 307, 9, 37, "NumberedEquation",
  Evaluatable->False],
Cell[88478, 2723, 115, 4, 27, "Text",
  Evaluatable->False],
Cell[88596, 2729, 469, 9, 39, "NumberedEquation",
  Evaluatable->False],
Cell[89068, 2740, 83, 1, 27, "Text",
  Evaluatable->False],
Cell[89154, 2743, 91, 1, 33, "Theorem",
  CellTags->"Theorem: Canonical variables"],
Cell[89248, 2746, 406, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"infinitesimal transformation"],
Cell[89657, 2759, 147, 4, 22, "NumberedEquation",
  Evaluatable->False],
Cell[89807, 2765, 40, 1, 27, "Text",
  Evaluatable->False],
Cell[89850, 2768, 285, 8, 22, "NumberedEquation",
  Evaluatable->False],
Cell[90138, 2778, 133, 3, 27, "Text",
  Evaluatable->False],
Cell[90274, 2783, 210, 5, 44, "Text",
  Evaluatable->False,
  CellTags->"two-dimensional group"],
Cell[90487, 2790, 67, 0, 27, "Text"],
Cell[90557, 2792, 98, 1, 33, "Definition",
  CellTags->"Definition: Canonical variable"],
Cell[90658, 2795, 456, 15, 44, "Text",
  CellTags->"group of translation"],
Cell[91117, 2812, 104, 2, 22, "NumberedEquation"],
Cell[91224, 2816, 376, 14, 27, "Text"],
Cell[91603, 2832, 167, 4, 44, "Text"],
Cell[91773, 2838, 214, 5, 22, "NumberedEquation"],
Cell[91990, 2845, 255, 5, 44, "Text",
  CellTags->"invariance of transformation"],

Cell[CellGroupData[{
Cell[92270, 2854, 338, 6, 71, "Input"],
Cell[92611, 2862, 628, 21, 32, "Output"]
}, Open  ]],
Cell[93254, 2886, 350, 12, 27, "Text",
  CellTags->"canonical variables"],
Cell[93607, 2900, 146, 2, 22, "NumberedEquation"],
Cell[93756, 2904, 453, 7, 61, "Text",
  CellTags->{
  "calculation of canonical variables", 
    "derivation of canonical variables"}],
Cell[94212, 2913, 28, 0, 29, "Example"],
Cell[94243, 2915, 219, 5, 44, "Text",
  CellTags->"scaling symmetry"],

Cell[CellGroupData[{
Cell[94487, 2924, 133, 2, 39, "Input"],
Cell[94623, 2928, 117, 2, 23, "Output"]
}, Open  ]],
Cell[94755, 2933, 153, 4, 27, "Text",
  CellTags->"equations for canonical variables"],

Cell[CellGroupData[{
Cell[94933, 2941, 120, 2, 23, "Input"],
Cell[95056, 2945, 610, 21, 32, "Output"]
}, Open  ]],
Cell[95681, 2969, 363, 10, 46, "Text",
  CellTags->{"DSolve[]", "partial differential equation"}],

Cell[CellGroupData[{
Cell[96069, 2983, 129, 3, 23, "Input"],
Cell[96201, 2988, 77, 1, 23, "Output"]
}, Open  ]],
Cell[96293, 2992, 113, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[96431, 3001, 129, 3, 23, "Input"],
Cell[96563, 3006, 68, 1, 23, "Output"]
}, Open  ]],
Cell[96646, 3010, 852, 28, 78, "Text",
  CellTags->"canonical variables"],

Cell[CellGroupData[{
Cell[97523, 3042, 65, 1, 23, "Input"],
Cell[97591, 3045, 61, 1, 23, "Output"]
}, Open  ]],
Cell[97667, 3049, 582, 16, 63, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[98274, 3069, 115, 3, 39, "Input"],
Cell[98392, 3074, 80, 1, 23, "Output"]
}, Open  ]],
Cell[98487, 3078, 290, 8, 44, "Text",
  CellTags->"pure function"],

Cell[CellGroupData[{
Cell[98802, 3090, 175, 4, 55, "Input"],
Cell[98980, 3096, 111, 2, 23, "Output"]
}, Open  ]],
Cell[99106, 3101, 187, 6, 27, "Text"],

Cell[CellGroupData[{
Cell[99318, 3111, 54, 1, 23, "Input"],
Cell[99375, 3114, 46, 1, 23, "Output"]
}, Open  ]],
Cell[99436, 3118, 218, 6, 27, "Text"],
Cell[99657, 3126, 28, 0, 29, "Example"],
Cell[99688, 3128, 221, 5, 44, "Text",
  Evaluatable->False,
  CellTags->"rotation and canonical variables"],

Cell[CellGroupData[{
Cell[99934, 3137, 133, 2, 39, "Input"],
Cell[100070, 3141, 117, 2, 23, "Output"]
}, Open  ]],
Cell[100202, 3146, 115, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[100342, 3154, 120, 2, 23, "Input"],
Cell[100465, 3158, 600, 21, 32, "Output"]
}, Open  ]],
Cell[101080, 3182, 167, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[101272, 3192, 129, 3, 23, "Input"],
Cell[101404, 3197, 229, 5, 73, "Output"]
}, Open  ]],
Cell[101648, 3205, 152, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[101825, 3215, 129, 3, 23, "Input"],
Cell[101957, 3220, 90, 1, 35, "Output"]
}, Open  ]],
Cell[102062, 3224, 118, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[102205, 3232, 153, 4, 23, "Input"],
Cell[102361, 3238, 64, 1, 32, "Output"]
}, Open  ]],
Cell[102440, 3242, 143, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[102608, 3252, 81, 1, 23, "Input"],
Cell[102692, 3255, 78, 1, 35, "Output"]
}, Open  ]],
Cell[102785, 3259, 133, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"canonical variables"],

Cell[CellGroupData[{
Cell[102943, 3265, 310, 7, 55, "Input"],
Cell[103256, 3274, 139, 2, 35, "Output"]
}, Open  ]],
Cell[103410, 3279, 357, 12, 44, "Text",
  Evaluatable->False],
Cell[103770, 3293, 28, 0, 29, "Example"],
Cell[103801, 3295, 170, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"projective group"],

Cell[CellGroupData[{
Cell[103996, 3304, 131, 2, 39, "Input"],
Cell[104130, 3308, 115, 2, 23, "Output"]
}, Open  ]],
Cell[104260, 3313, 142, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"determining equations for canonical variables"],

Cell[CellGroupData[{
Cell[104427, 3319, 120, 2, 23, "Input"],
Cell[104550, 3323, 604, 21, 32, "Output"]
}, Open  ]],
Cell[105169, 3347, 202, 6, 29, "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[105396, 3357, 129, 3, 23, "Input"],
Cell[105528, 3362, 83, 1, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105648, 3368, 129, 3, 23, "Input"],
Cell[105780, 3373, 74, 1, 23, "Output"]
}, Open  ]],
Cell[105869, 3377, 93, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[105987, 3382, 140, 3, 39, "Input"],
Cell[106130, 3387, 86, 1, 23, "Output"]
}, Open  ]],
Cell[106231, 3391, 46, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[106302, 3395, 175, 4, 55, "Input"],
Cell[106480, 3401, 117, 2, 23, "Output"]
}, Open  ]],
Cell[106612, 3406, 195, 3, 27, "Text",
  CellTags->"canonical variables of the projective group"],
Cell[106810, 3411, 634, 14, 80, "Text",
  Evaluatable->False,
  CellTags->{
  "CanonicalVariables[]", "infinitesimals", "determining equations", 
    "pure function"}],
Cell[107447, 3427, 617, 12, 101, "Text",
  Evaluatable->False],
Cell[108067, 3441, 2366, 45, 585, "Input",
  CellTags->{"CanonicalVariables[", "CanonicalVariables[]"}],
Cell[110436, 3488, 613, 19, 63, "Text",
  Evaluatable->False,
  CellTags->{"CanonicalVariables[]", "inhomogeneous scaling group"}],

Cell[CellGroupData[{
Cell[111074, 3511, 91, 1, 39, "Input"],
Cell[111168, 3514, 129, 2, 34, "Output"]
}, Open  ]],
Cell[111312, 3519, 467, 14, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[111804, 3537, 101, 2, 39, "Input"],
Cell[111908, 3541, 652, 23, 46, "Output"]
}, Open  ]],
Cell[112575, 3567, 127, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"translation group"],

Cell[CellGroupData[{
Cell[112727, 3573, 92, 1, 39, "Input"],
Cell[112822, 3576, 710, 25, 58, "Output"]
}, Open  ]],
Cell[113547, 3604, 138, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"rotation"],

Cell[CellGroupData[{
Cell[113710, 3613, 100, 2, 39, "Input"],
Cell[113813, 3617, 1298, 44, 50, "Output"]
}, Open  ]],
Cell[115126, 3664, 116, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[115267, 3672, 92, 1, 39, "Input"],
Cell[115362, 3675, 400, 15, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115799, 3695, 92, 1, 39, "Input"],
Cell[115894, 3698, 386, 14, 32, "Output"]
}, Open  ]],
Cell[116295, 3715, 283, 8, 46, "Text",
  Evaluatable->False,
  CellTags->"Log[]"],

Cell[CellGroupData[{
Cell[116603, 3727, 103, 2, 39, "Input"],
Cell[116709, 3731, 507, 18, 38, "Output"]
}, Open  ]],
Cell[117231, 3752, 214, 5, 29, "Text",
  CellTags->"CanonicalVariables[]"],

Cell[CellGroupData[{
Cell[117470, 3761, 122, 2, 39, "Input"],
Cell[117595, 3765, 981, 34, 64, "Output"]
}, Open  ]],
Cell[118591, 3802, 109, 2, 27, "Text"],

Cell[CellGroupData[{
Cell[118725, 3808, 123, 2, 39, "Input"],
Cell[118851, 3812, 562, 21, 68, "Output"]
}, Open  ]],
Cell[119428, 3836, 618, 10, 95, "Text"],
Cell[120049, 3848, 147, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

