(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    759756,      19716]*)
(*NotebookOutlinePosition[    792547,      20518]*)
(*  CellTagsIndexPosition[    787795,      20410]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["4.4 Analysis of Ordinary Differential Equations", "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 31}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Analysis of Ordinary Differential Equations"],

Cell[TextData[{
  "The Lie point symmetries of an ordinary differential equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " are determined by calculating the general solution for the infinitesimals \
\[Xi] and \[Phi]. The procedure follows the steps discussed in S",
  ButtonBox["ection 4.3",
    ButtonData:>{"symmet11.nb", 
      "Symmetry Transformations of Differential Equations"},
    ButtonStyle->"Hyperlink"],
  ". The first step is to write down the invariance condition for the \
equation and then solve the linear determining equations. The steps of \
deriving and solving the determining equations are accessible within ",
  StyleBox["MathLie ",
    FontSlant->"Italic"],
  "and can be carried out automatically. The calculations done by hand are \
very cumbersome, but using computer algebra, the work is easy to accomplish. \
However, the view taken here is somewhat optimistic and cases exist which \
sometimes involve peculiar results."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimals", "invariance condition", "linear determining equations", 
    "determining equations", "computer algebra"}],

Cell["\<\
One of these peculiarities is the case of first-order differential \
equations. As we will soon show, first-order differential equations always \
have an infinite number of symmetries and are thus not very appropriate for \
Lie's method. However, we will discuss a procedure which allows us to find a \
restricted class of point symmetries, the so-called conformal \
symmetries.\
\>", "Text",
  CellTags->{
  "first-order differential equation", "infinite number of symmetries", 
    "point symmetries", "conformal symmetries"}],

Cell[CellGroupData[{

Cell["4.4.1 First-Order Equations", "Subsection",
  CellTags->"First order equations"],

Cell["\<\
The general representation of a first-order ordinary differential \
equation is given by\
\>", "Text",
  CellTags->"first-order ordinary differential equation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"F", " ", 
            RowBox[{"(", 
              RowBox[{"x", ",", \(u(x)\), ",", 
                FractionBox[
                  StyleBox["du",
                    FontSlant->"Italic"], 
                  StyleBox["dx",
                    FontSlant->"Italic"]]}], ")"}]}], " ", "=", " ", "0"}], 
        ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is an arbitrary function combining the independent and dependent \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", respectively, and the derivatives in a general way. Our intention here \
is to use point symmetries to solve this type of equation. We state the main \
result at the beginning of this section. A first-order differential equation \
always has an infinite number of symmetries. This is immediately obvious if \
we consider the geometrical interpretation of the equation. As we know, the \
set of solutions of a first-order differential equation is a one-parameter \
family of curves which look like the ensemble in the following figure:"
}], "Text",
  CellTags->{
  "point symmetries", "infinite number of symmetries", 
    "geometrical interpretation of first-order ODE"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.928571 0.952381 0.603319 0.0824045 [
[(1.2)] .21429 .60332 0 2 Msboxa
[(1.4)] .40476 .60332 0 2 Msboxa
[(1.6)] .59524 .60332 0 2 Msboxa
[(1.8)] .78571 .60332 0 2 Msboxa
[(2)] .97619 .60332 0 2 Msboxa
[(x)] 1.025 .60332 -1 0 Msboxa
[(-7)] .01131 .02649 1 0 Msboxa
[(-6)] .01131 .10889 1 0 Msboxa
[(-5)] .01131 .1913 1 0 Msboxa
[(-4)] .01131 .2737 1 0 Msboxa
[(-3)] .01131 .35611 1 0 Msboxa
[(-2)] .01131 .43851 1 0 Msboxa
[(-1)] .01131 .52091 1 0 Msboxa
[(u)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .60332 m
.21429 .60957 L
s
P
[(1.2)] .21429 .60332 0 2 Mshowa
p
.002 w
.40476 .60332 m
.40476 .60957 L
s
P
[(1.4)] .40476 .60332 0 2 Mshowa
p
.002 w
.59524 .60332 m
.59524 .60957 L
s
P
[(1.6)] .59524 .60332 0 2 Mshowa
p
.002 w
.78571 .60332 m
.78571 .60957 L
s
P
[(1.8)] .78571 .60332 0 2 Mshowa
p
.002 w
.97619 .60332 m
.97619 .60957 L
s
P
[(2)] .97619 .60332 0 2 Mshowa
p
.001 w
.0619 .60332 m
.0619 .60707 L
s
P
p
.001 w
.1 .60332 m
.1 .60707 L
s
P
p
.001 w
.1381 .60332 m
.1381 .60707 L
s
P
p
.001 w
.17619 .60332 m
.17619 .60707 L
s
P
p
.001 w
.25238 .60332 m
.25238 .60707 L
s
P
p
.001 w
.29048 .60332 m
.29048 .60707 L
s
P
p
.001 w
.32857 .60332 m
.32857 .60707 L
s
P
p
.001 w
.36667 .60332 m
.36667 .60707 L
s
P
p
.001 w
.44286 .60332 m
.44286 .60707 L
s
P
p
.001 w
.48095 .60332 m
.48095 .60707 L
s
P
p
.001 w
.51905 .60332 m
.51905 .60707 L
s
P
p
.001 w
.55714 .60332 m
.55714 .60707 L
s
P
p
.001 w
.63333 .60332 m
.63333 .60707 L
s
P
p
.001 w
.67143 .60332 m
.67143 .60707 L
s
P
p
.001 w
.70952 .60332 m
.70952 .60707 L
s
P
p
.001 w
.74762 .60332 m
.74762 .60707 L
s
P
p
.001 w
.82381 .60332 m
.82381 .60707 L
s
P
p
.001 w
.8619 .60332 m
.8619 .60707 L
s
P
p
.001 w
.9 .60332 m
.9 .60707 L
s
P
p
.001 w
.9381 .60332 m
.9381 .60707 L
s
P
[(x)] 1.025 .60332 -1 0 Mshowa
p
.002 w
0 .60332 m
1 .60332 L
s
P
p
.002 w
.02381 .02649 m
.03006 .02649 L
s
P
[(-7)] .01131 .02649 1 0 Mshowa
p
.002 w
.02381 .10889 m
.03006 .10889 L
s
P
[(-6)] .01131 .10889 1 0 Mshowa
p
.002 w
.02381 .1913 m
.03006 .1913 L
s
P
[(-5)] .01131 .1913 1 0 Mshowa
p
.002 w
.02381 .2737 m
.03006 .2737 L
s
P
[(-4)] .01131 .2737 1 0 Mshowa
p
.002 w
.02381 .35611 m
.03006 .35611 L
s
P
[(-3)] .01131 .35611 1 0 Mshowa
p
.002 w
.02381 .43851 m
.03006 .43851 L
s
P
[(-2)] .01131 .43851 1 0 Mshowa
p
.002 w
.02381 .52091 m
.03006 .52091 L
s
P
[(-1)] .01131 .52091 1 0 Mshowa
p
.001 w
.02381 .04297 m
.02756 .04297 L
s
P
p
.001 w
.02381 .05945 m
.02756 .05945 L
s
P
p
.001 w
.02381 .07593 m
.02756 .07593 L
s
P
p
.001 w
.02381 .09241 m
.02756 .09241 L
s
P
p
.001 w
.02381 .12537 m
.02756 .12537 L
s
P
p
.001 w
.02381 .14185 m
.02756 .14185 L
s
P
p
.001 w
.02381 .15833 m
.02756 .15833 L
s
P
p
.001 w
.02381 .17482 m
.02756 .17482 L
s
P
p
.001 w
.02381 .20778 m
.02756 .20778 L
s
P
p
.001 w
.02381 .22426 m
.02756 .22426 L
s
P
p
.001 w
.02381 .24074 m
.02756 .24074 L
s
P
p
.001 w
.02381 .25722 m
.02756 .25722 L
s
P
p
.001 w
.02381 .29018 m
.02756 .29018 L
s
P
p
.001 w
.02381 .30666 m
.02756 .30666 L
s
P
p
.001 w
.02381 .32314 m
.02756 .32314 L
s
P
p
.001 w
.02381 .33962 m
.02756 .33962 L
s
P
p
.001 w
.02381 .37259 m
.02756 .37259 L
s
P
p
.001 w
.02381 .38907 m
.02756 .38907 L
s
P
p
.001 w
.02381 .40555 m
.02756 .40555 L
s
P
p
.001 w
.02381 .42203 m
.02756 .42203 L
s
P
p
.001 w
.02381 .45499 m
.02756 .45499 L
s
P
p
.001 w
.02381 .47147 m
.02756 .47147 L
s
P
p
.001 w
.02381 .48795 m
.02756 .48795 L
s
P
p
.001 w
.02381 .50443 m
.02756 .50443 L
s
P
p
.001 w
.02381 .5374 m
.02756 .5374 L
s
P
p
.001 w
.02381 .55388 m
.02756 .55388 L
s
P
p
.001 w
.02381 .57036 m
.02756 .57036 L
s
P
p
.001 w
.02381 .58684 m
.02756 .58684 L
s
P
p
.001 w
.02381 .01001 m
.02756 .01001 L
s
P
[(u)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
0 1 1 r
p
.004 w
.02381 .43851 m
.06349 .45119 L
.10317 .46205 L
.14286 .47147 L
.18254 .47971 L
.22222 .48698 L
.2619 .49345 L
.30159 .49923 L
.34127 .50443 L
.38095 .50914 L
.42063 .51342 L
.46032 .51733 L
.5 .52091 L
.53968 .52421 L
.57937 .52725 L
.61905 .53007 L
.65873 .53269 L
.69841 .53512 L
.7381 .5374 L
.77778 .53952 L
.81746 .54152 L
.85714 .54339 L
.89683 .54515 L
.93651 .54681 L
.97619 .54838 L
s
P
P
p
0 .4 1 r
p
.004 w
.02381 .60332 m
.06349 .60332 L
.10317 .60332 L
.14286 .60332 L
.18254 .60332 L
.22222 .60332 L
.2619 .60332 L
.30159 .60332 L
.34127 .60332 L
.38095 .60332 L
.42063 .60332 L
.46032 .60332 L
.5 .60332 L
.53968 .60332 L
.57937 .60332 L
.61905 .60332 L
.65873 .60332 L
.69841 .60332 L
.7381 .60332 L
.77778 .60332 L
.81746 .60332 L
.85714 .60332 L
.89683 .60332 L
.93651 .60332 L
.97619 .60332 L
s
P
P
p
.2 0 1 r
p
.004 w
.02381 .39731 m
.06349 .41674 L
.10317 .43283 L
.14286 .44636 L
.18254 .4579 L
.22222 .46786 L
.2619 .47654 L
.30159 .48418 L
.34127 .49095 L
.38095 .49699 L
.42063 .50242 L
.46032 .50731 L
.5 .51176 L
.53968 .51581 L
.57937 .51952 L
.61905 .52292 L
.65873 .52606 L
.69841 .52897 L
.7381 .53166 L
.77778 .53417 L
.81746 .5365 L
.85714 .53869 L
.89683 .54073 L
.93651 .54265 L
.97619 .54446 L
s
P
P
p
.8 0 1 r
p
.004 w
.02381 .60332 m
.06349 .60332 L
.10317 .60332 L
.14286 .60332 L
.18254 .60332 L
.22222 .60332 L
.2619 .60332 L
.30159 .60332 L
.34127 .60332 L
.38095 .60332 L
.42063 .60332 L
.46032 .60332 L
.5 .60332 L
.53968 .60332 L
.57937 .60332 L
.61905 .60332 L
.65873 .60332 L
.69841 .60332 L
.7381 .60332 L
.77778 .60332 L
.81746 .60332 L
.85714 .60332 L
.89683 .60332 L
.93651 .60332 L
.97619 .60332 L
s
P
P
p
1 0 .6 r
p
.004 w
.02381 .32864 m
.06349 .36213 L
.10317 .38835 L
.14286 .40943 L
.18254 .42674 L
.22222 .44121 L
.2619 .45349 L
.30159 .46404 L
.34127 .47321 L
.38095 .48124 L
.42063 .48834 L
.46032 .49465 L
.5 .50031 L
.53968 .50541 L
.57937 .51003 L
.61905 .51423 L
.65873 .51807 L
.69841 .5216 L
.7381 .52484 L
.77778 .52783 L
.81746 .53061 L
.85714 .53319 L
.89683 .53559 L
.93651 .53783 L
.97619 .53993 L
s
P
P
p
1 0 0 r
p
.004 w
.02381 .60332 m
.06349 .60332 L
.10317 .60332 L
.14286 .60332 L
.18254 .60332 L
.22222 .60332 L
.2619 .60332 L
.30159 .60332 L
.34127 .60332 L
.38095 .60332 L
.42063 .60332 L
.46032 .60332 L
.5 .60332 L
.53968 .60332 L
.57937 .60332 L
.61905 .60332 L
.65873 .60332 L
.69841 .60332 L
.7381 .60332 L
.77778 .60332 L
.81746 .60332 L
.85714 .60332 L
.89683 .60332 L
.93651 .60332 L
.97619 .60332 L
s
P
P
p
0 1 1 r
p
.004 w
.02381 .1913 m
.06349 .26233 L
.10317 .31248 L
.14286 .34977 L
.18254 .37858 L
.22222 .40151 L
.2619 .4202 L
.30159 .43572 L
.34127 .44881 L
.38095 .46001 L
.42063 .46969 L
.46032 .47815 L
.5 .4856 L
.53968 .49221 L
.57937 .49812 L
.61905 .50343 L
.65873 .50824 L
.69841 .5126 L
.7381 .51658 L
.77778 .52022 L
.81746 .52357 L
.85714 .52666 L
.89683 .52952 L
.93651 .53218 L
.97619 .53465 L
s
P
P
p
0 .4 1 r
p
.004 w
.02381 .60332 m
.06349 .60332 L
.10317 .60332 L
.14286 .60332 L
.18254 .60332 L
.22222 .60332 L
.2619 .60332 L
.30159 .60332 L
.34127 .60332 L
.38095 .60332 L
.42063 .60332 L
.46032 .60332 L
.5 .60332 L
.53968 .60332 L
.57937 .60332 L
.61905 .60332 L
.65873 .60332 L
.69841 .60332 L
.7381 .60332 L
.77778 .60332 L
.81746 .60332 L
.85714 .60332 L
.89683 .60332 L
.93651 .60332 L
.97619 .60332 L
s
P
P
p
.2 0 1 r
p
.004 w
s
s
.05921 0 m
.06349 .02164 L
s
.06349 .02164 m
.08333 .09621 L
.10317 .15384 L
.12302 .1997 L
.14286 .23708 L
.18254 .2943 L
.22222 .33606 L
.2619 .36788 L
.30159 .39292 L
.34127 .41315 L
.38095 .42984 L
.42063 .44383 L
.46032 .45573 L
.5 .46598 L
.53968 .4749 L
.57937 .48273 L
.61905 .48966 L
.65873 .49583 L
.69841 .50138 L
.7381 .50637 L
.77778 .5109 L
.81746 .51503 L
.85714 .5188 L
.89683 .52227 L
.93651 .52546 L
.97619 .52841 L
s
P
P
p
.8 0 1 r
p
.004 w
.02381 .60332 m
.06349 .60332 L
.10317 .60332 L
.14286 .60332 L
.18254 .60332 L
.22222 .60332 L
.2619 .60332 L
.30159 .60332 L
.34127 .60332 L
.38095 .60332 L
.42063 .60332 L
.46032 .60332 L
.5 .60332 L
.53968 .60332 L
.57937 .60332 L
.61905 .60332 L
.65873 .60332 L
.69841 .60332 L
.7381 .60332 L
.77778 .60332 L
.81746 .60332 L
.85714 .60332 L
.89683 .60332 L
.93651 .60332 L
.97619 .60332 L
s
P
P
p
1 0 .6 r
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.15464 0 m
.1627 .03826 L
s
.1627 .03826 m
.18254 .10889 L
.20238 .16383 L
.22222 .20778 L
.2619 .2737 L
.30159 .32079 L
.34127 .35611 L
.38095 .38357 L
.42063 .40555 L
.46032 .42353 L
.5 .43851 L
.53968 .45119 L
.57937 .46205 L
.61905 .47147 L
.65873 .47971 L
.69841 .48698 L
.7381 .49345 L
.77778 .49923 L
.81746 .50443 L
.85714 .50914 L
.89683 .51342 L
.93651 .51733 L
.97619 .52091 L
s
P
P
p
1 0 0 r
p
.004 w
.02381 .60332 m
.06349 .60332 L
.10317 .60332 L
.14286 .60332 L
.18254 .60332 L
.22222 .60332 L
.2619 .60332 L
.30159 .60332 L
.34127 .60332 L
.38095 .60332 L
.42063 .60332 L
.46032 .60332 L
.5 .60332 L
.53968 .60332 L
.57937 .60332 L
.61905 .60332 L
.65873 .60332 L
.69841 .60332 L
.7381 .60332 L
.77778 .60332 L
.81746 .60332 L
.85714 .60332 L
.89683 .60332 L
.93651 .60332 L
.97619 .60332 L
s
P
P
P
p
p
.004 w
.21429 .32864 m
.21429 .1913 L
s
p
.21429 .1913 m
.20679 .2413 L
.21429 .2413 L
.22179 .2413 L
.21429 .1913 L
F
.21429 .1913 m
.20679 .2413 L
.21429 .2413 L
.22179 .2413 L
.21429 .1913 L
s
P
P
p
.004 w
.21429 .32864 m
.30952 .32864 L
s
p
.30952 .32864 m
.25952 .32114 L
.25952 .32864 L
.25952 .33614 L
.30952 .32864 L
F
.30952 .32864 m
.25952 .32114 L
.25952 .32864 L
.25952 .33614 L
.30952 .32864 L
s
P
P
p
.004 w
.21429 .1913 m
.30952 .32864 L
s
p
.30952 .32864 m
.28719 .28328 L
.28103 .28755 L
.27487 .29182 L
.30952 .32864 L
F
.30952 .32864 m
.28719 .28328 L
.28103 .28755 L
.27487 .29182 L
.30952 .32864 L
s
P
P
P
p
[(v)] .16667 .2325 0 0 Mshowa
[(v')] .28095 .35611 0 0 Mshowa
[(S)] .29048 .24898 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{228.5, 138},
  ImageMargins->{{50, 0}, {0, 0.5}},
  ImageRegion->{{-0.15942, 1.16149}, {0, 1}},
  FontFamily->"Courier New",
  FontSize->8,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003T0000RQ000`40O003h00Oi7oo003TOol0021o
o`03001oogoo00=oo`0351moogoo00eoo`03O19oogoo0:]oo`0087oo00<007ooOol00goo00<D7goo
Ool03Goo00=l4WooOol0Zgoo000KOol00`00Oomoo`02Ool20005Ool00a@OOomoo`0=Ool00g`BOomo
o`2ZOol001]oo`03001oogoo009oo`03001oogoo00Aoo`0351moogoo00eoo`03O19oogoo0:Yoo`00
6goo00<007ooOol00Woo0P001Goo00<D7gooOol03Goo00=l4WooOol0ZWoo000COol40005Ool01@00
Oomoogoo00001Woo00<D7gooOol03Goo00=l4WooOol0ZWoo000IOol01000Oomoo`000goo00<007oo
Ool01Goo00<D7gooOol03Goo00=l4WooOol0ZGoo000IOol40003Ool20006Ool00a@OOomoo`0=Ool0
0g`BOomoo`2YOol0021oo`03001oogoo00Eoo`0351moogoo00eoo`03O19oogoo0:Uoo`0087oo00<0
07ooOol01Goo00<D7gooOol03Woo00=l4WooOol0Z7oo000POol20007Ool00a@OOomoo`0=Ool00g`B
Oomoo`2XOol0021oo`03001oogoo00Ioo`0351moogoo00eoo`03O19oogoo0:Qoo`0087oo00<007oo
Ool01Woo00<D7gooOol03Goo00=l4WooOol0Z7oo000POol20007Ool00a@OOomoo`0>Ool00g`BOomo
o`2WOol0021oo`03001oogoo00Moo`0351moogoo00eoo`03O19oogoo0:Moo`0087oo00<007ooOol0
1goo00<D7gooOol03Goo00=l4WooOol0Ygoo000POol20008Ool00a@OOomoo`0=Ool00g`BOomoo`2W
Ool001Uoo`<000Aoo`03001oogoo00Moo`0351moogoo00ioo`03O19oogoo0:Ioo`006Goo00@007oo
Ool000=oo`03001oogoo00Qoo`0351moogoo00eoo`03O19oogoo0:Ioo`006Goo00@007ooOol000=o
o`8000Uoo`0351moogoo00eoo`03O19oogoo0:Ioo`004goo10000Woo0`0017oo00<007ooOol02Goo
00<D7gooOol037oo00=l4WooOol0YWoo000JOol00`00Oomoo`03Ool2000:Ool00a@OOomoo`0=Ool0
0g`BOomoo`2UOol001Yoo`<000=oo`03001oogoo00Uoo`0351moogoo00eoo`03O19oogoo0:Eoo`00
87oo00<007ooOol02Woo00<D7gooOol03Goo00=l4WooOol0Y7oo000POol2000;Ool00a@OOomoo`0=
Ool00g`BOomoo`2TOol0021oo`03001oogoo00]oo`0351moogoo00eoo`03O19oogoo0:=oo`0087oo
00<007ooOol02goo00<D7gooOol03Goo00=l4WooOol0Xgoo000POol2000<Ool00a@OOomoo`0>Ool0
0g`BOomoo`2ROol0021oo`03001oogoo00aoo`0351moogoo00eoo`03O19oogoo0:9oo`0087oo00<0
07ooOol037oo00<D7gooOol03Goo00=l4WooOol0XWoo000POol2000>Ool00a@OOomoo`0=Ool00g`B
Oomoo`2QOol001Yoo`8000Aoo`03001oogoo00eoo`0351moogoo00eoo`03O19oogoo0:5oo`006Goo
00@007ooOol000=oo`03001oogoo00eoo`0351moogoo00ioo`03O19oogoo0:1oo`0077oo00H007oo
Oomoo`?o000?Ool00a@OOomoo`0=Ool00`00Oomoo`2POol001=oo`@000=oo`8000Aoo`030003ogoo
00ioo`0351moogoo00eoo`800:5oo`006Woo00<007ooOol00goo00<000?oOol03goo00<D7gooOol0
2goo0`00XGoo000JOol30003Ool00`00Ool3o`0?Ool00a@OOomoo`0;Ool200000goo001oo`2OOol0
021oo`03001oo`?o011oo`0351moogoo00Yoo`<00003O18007oo09ioo`0087oo0P0000=oo`?oOol0
3Woo00@D7gooOomoo`8000Moo`<00003Ool007oo09ioo`0087oo00D007ooOomoo`?o00moo`0351mo
ogoo008000Ioo`@00003Ooml4P0009ioo`0087oo00D007ooOomoo`?o00moo`0351moo`00009oo`03
001oogoo00=oo`@0009oo`03O18007oo00Aoo`<009Eoo`0087oo0P000goo00<3ogooOol03Goo0P00
0Woo0P0017oo10000goo00=l4P00Ool00goo00@007ooOol009Aoo`0087oo00<007ooOol00Woo00<3
ogooOol03Goo00<D7gooOol02Goo00<007ooOol00Woo00=l4P00Ool01Woo00<007ooOol0TWoo000P
Ool00`00Oomoo`03Ool00`?oOomoo`0=Ool00a@OOomoo`08Ool00`00Oomoo`03Ool00g`B001oo`03
Ool2002EOol0021oo`8000Aoo`030omoogoo00ioo`0351moogoo00Moo`03001oogoo00=oo`03O19o
o`00009oo`04001oogoo002DOol001]oo`<0009oo`03001oogoo00Aoo`030omoogoo00ioo`0351mo
ogoo00Ioo`03001oogoo00Aoo`04O18007ooOol4002DOol001aoo`05001oogooOol00007Ool00`?o
Oomoo`0=Ool00a@OOomoo`06Ool00`00Oomoo`04Ool00g`BOol0002IOol001Uoo`D0009oo`8000Mo
o`030omoogoo00eoo`0351moogoo00Eoo`03001oogoo00Eoo`03O19oo`0009Qoo`004goo10000Woo
00@007ooOol000=oo`03001oogoo00Moo`030omoogoo00eoo`0351moogoo00Aoo`03001oogoo00Io
o`04O18007oo002FOol001Yoo`03001oo`0000=oo`03001oogoo00Qoo`030omoogoo00aoo`0351mo
ogoo00Aoo`03001oogoo00Moo`04O1800000002EOol001]oo`8000=oo`8000Uoo`030omoogoo00eo
o`0351moogoo00=oo`03001oogoo00Moo`@009Eoo`0087oo00<007ooOol02Goo00<3ogooOol03Goo
00<D7gooOol00Woo00<007ooOol027oo1000U7oo000POol2000;Ool00`?oOomoo`0=Ool01A@OOomo
ogoo00002goo0`00U7oo000POol00`00Oomoo`0;Ool00`?oOomoo`0=Ool011@OOomoo`0037oo0`00
Tgoo000POol00`00Oomoo`0<Ool00`?oOomoo`0=Ool00a@OOol0000=Ool2002COol0021oo`8000io
o`030omoogoo00eoo`0351l007oo00Eoo`D000=oo`80099oo`0087oo00=l4WooOol03Woo00<3ogoo
Ool03Goo4@00TWoo000POol00`00O19oo`0>Ool00`?oOomoo`0>Ool00a@OOomoo`03Ool50005Ool0
0g`BOomoo`2?Ool0021oo`800003O19oogoo00eoo`030omoogoo00ioo`0351moogoo00eoo`03O19o
ogoo08ioo`006Woo0P0017oo00<007ooOol00W`B3Woo00<3ogooOol03Woo00@D7gooOomoo`8000Yo
o`03O19oogoo08eoo`006Goo00@007ooOol000=oo`03001oogoo009oo`03O19oogoo00aoo`030omo
ogoo00ioo`8D7`03Ool0000000]oo`03O19oogoo08aoo`006goo00<007ooOol00Woo0P0017oo00=l
4WooOol037oo0P?o47oo00@007ooOol000]oo`03O19oogoo08]oo`004goo10001Goo00D007ooOomo
o`0000Ioo`03O19oogoo00eoo`030omoogoo00aoo`80000451moo`000003Ool00`00Oomoo`05Ool2
O1:;Ool001Uoo`04001oogoo0003Ool00`00Oomoo`05Ool2O18>Ool00`?oOomoo`0>Ool00a@OOomo
o`03Ool00`00Oomoo`07Ool2O1:9Ool001Yoo`8000Aoo`8000Qoo`9l4Peoo`83o`moo`8D7`=oo`03
001oogoo00Uoo`9l4XMoo`0087oo00<007ooOol02Goo0W`B3Goo00<3ogooOol03Woo0Q@O3goo00=l
4WooOol0Q7oo000POol2000<Ool00g`BOomoo`0;Ool20ol@Ool251l>Ool2O1:4Ool0021oo`03001o
ogoo00aoo`9l4Peoo`83oa1oo`0351moogoo00eoo`9l4X9oo`0087oo0Q@O3goo00=l4WooOol037oo
0P?o3goo0Q@O3goo0W`BP7oo000POol2000251l>Ool2O18>Ool20ol?Ool00a@OOomoo`0>Ool2O19n
Ool0021oo`04001oogooOol251l>Ool2O18>Ool20ol>Ool251l@Ool2O19lOol0021oo`03001oogoo
00=oo`<D7`eoo`9l4Pioo`83o`ioo`8D7a1oo`9l4WYoo`0087oo0P001goo0Q@O3Goo0W`B3Woo0`?o
3Goo11@O3Woo0W`BN7oo000IOol40003Ool00`00Oomoo`08Ool251l=Ool3O18>Ool40ol=Ool351l=
Ool2O19fOol001Uoo`03001oogoo00Aoo`03001oogoo00Yoo`<D7`eoo`Al4Pioo`83o`ioo`8D7`eo
o`9l4WAoo`006Woo00<007ooOol00goo0P?o3Woo0a@O3Woo0g`B3Goo0P?o3Woo0Q@O3Goo0g`BLGoo
000COol40004Ool00`00Oomoo`02Ool00`00Ool3o`030ol=Ool351l>Ool4O18;Ool20ol>Ool351l=
Ool4O19]Ool001Uoo`04001oogoo0003Ool00`00Oomoo`03Ool30ol=Ool451l>Ool3O18:Ool30ol>
Ool451l=Ool3O19ZOol001Yoo`8000Aoo`8000Moo`@3o`eoo`<D7`ioo`Al4PUoo`@3o`ioo`<D7`eo
o`Al4VIoo`0087oo00<007ooOol02Woo10?o37oo11@O3Woo0g`B2Woo1@?o37oo0a@O3Woo1G`BHGoo
000POol2000?Ool50ol;Ool551l<Ool3O18<Ool50ol:Ool551l>Ool5O19LOol0021oo`03001oogoo
01=oo`@3o`aoo`DD7`Yoo`El4Paoo`@3o`]oo`LD7`aoo`Al4UQoo`0087oo00<007ooOol05goo1@?o
37oo11@O2goo1g`B2Goo10?o3Woo1A@O2goo17`BE7oo000POol2000MOol70ol9Ool451l>Ool7O186
Ool70ol<Ool451l;Ool7O19=Ool0021oo`03001oogoo02=oo`L3o`Ioo`LD7`ioo`Il4PMoo`L3o`Uo
o`DD7`eoo`Ml4TIoo`0087oo00<007ooOol0:Woo1P?o1goo1a@O3Goo1g`B1goo1`?o1goo1Q@O3Woo
1g`B?goo000POol2000aOol70ol7Ool751l=Ool7O187Ool70ol6Ool>51l7Ool6O18iOol001Uoo`D0
009oo`03001oogoo03Moo`L3o`Moo`dD7`Moo`Ml4PMoo`d3o`Moo`LD7`Ioo`Ml4S9oo`006goo00<0
07ooOol00Woo00<007ooOol0?Woo3@?o1goo1a@O1goo3G`B1goo1`?o1goo1Q@O1goo3W`B97oo000K
Ool00`00Oomoo`02Ool2000GOol50002Ool20003Ool4000@Ool50002Ool20005Ool30004Ool>0ol>
51l6Ool7O183Ool4000=0ol>51l7Ool4O1800`00Oomoo`0MOol001=oo`@000Aoo`03001oogoo009o
o`03001oogoo01Qoo`03001oogoo00Moo`03001oogoo01=oo`03001oogoo00Yoo`03001oogoo015o
o`h3o`dD7`il4P06Ool007ooOol007oo3P?o2a@O87oo000KOol00`00Oomoo`02Ool00`00Oomoo`0H
Ool00`00Oomoo`08Ool00`00Oomoo`0BOol00`00Oomoo`07Ool5000BOol00`00Oomoo`07Ool01000
Oomoo`003@?o3Q@O57`B2`?o87oo000JOol20004Ool2000IOol00`00Oomoo`09Ool00`00Oomoo`0A
Ool00`00Oomoo`07Ool01000Oomoo`004goo00<007ooOol01goo0`003Woo3P?o51@O2g`B87oo000P
Ool00`00Oomoo`0HOol00`00Oomoo`07Ool01000Oomoo`004Woo00<007ooOol027oo00<007oo0000
4goo00<007ooOol027oo00<007ooOol04Woo00<007ooOol01goo00D007ooOol007oo00h3o`/D7`03
001oogoo01eoo`0087oo00<007ooOol05goo0P002Woo0P004Woo0P002goo0P004Woo0P002Woo0`00
4Goo0P002Woo0P005goo10?o87oo000POol20032Ool0021oo`03001oogoo0<5oo`0087oo0P00`Woo
000POol00`00Oomoo`31Ool0021oo`03001oogoo0<5oo`0087oo0P00`Woo000POol00`00Oomoo`2X
Ool200000goo0000000DOol0021oo`03001oogoo0:Uoo`03001oo`0001Eoo`0077oo1000Y7`01000
1Goo00<007ooOol057oo000POol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`05Ool200000goo0000000DOol0021oo`03001oogoo
0<5oo`00i7oo003TOol00>Aoo`00i7oo003TOol00>Aoo`00i7oo003TOol00>Aoo`00i7oo003TOol0
0>Aoo`00i7oo003TOol00>Aoo`00i7oo003TOol00>Aoo`00i7oo003TOol00>Aoo`007goo1000`Goo
000NOol01000Oomoo`00`Woo000NOol01000Oomoo`00`Woo000MOol200000goo00000032Ool00>Ao
o`00i7oo003TOol00>Aoo`00i7oo0000\
\>"],
  ImageRangeCache->{{{-36.375, 264.375}, {137, 0}} -> {0.799543, -7.42646, \
0.00614973, 0.0710749}}],

Cell[TextData[{
  "A symmetry transformation is by definition a transformation mapping \
solutions into solutions. As the example in the above figure shows, new \
solutions follow from old solutions by successively changing the involved \
integration constant. Every symmetry transformation is represented by a \
generator ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " corresponding to a vector field leading from curves to their neighboring \
curves. As we know, the vector field always exists and can be represented by \
the infinitesimals \[Xi] and \[Phi]. A different choice ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]'\)]],
  " of the vector field will result in a different location on the target \
curve; however, both points on the target curve are connected by a third \
vector field ",
  Cell[BoxData[
      \(TraditionalForm\`S\&\[RightVector]\)]],
  " (see the figure). This is one of several ways to interpret a differential \
equation. Another view is the following:"
}], "Text",
  CellTags->{
  "symmetry transformation", "transformation", 
    "map solutions into solutions", "vector field", "infinitesimals", 
    "target curve"}],

Cell["\<\
From a conceptual point of view, a differential equation contains \
two components:\
\>", "Text",
  Evaluatable->False],

Cell["(i) the skeleton of the differential equation", "ListItem",
  Evaluatable->False,
  CellTags->"skeleton of differential equation"],

Cell["(ii) the solution manifold.", "ListItem",
  Evaluatable->False,
  CellTags->"solution manifold"],

Cell[TextData[{
  "These two parts of a differential equation will be the subject of the \
following. The term skeleton was introduced by ",
  ButtonBox["Lie [1899]",
    ButtonData:>{"Literat.nb", "Lie-Engel-1899"},
    ButtonStyle->"Hyperlink"],
  " to denote the extended manifold on which the differential equation \
exists. We will show you how the symmetries connect these two parts. We start \
with the skeleton of a first-order ordinary differential equation."
}], "Text",
  Evaluatable->False,
  CellTags->{"extended manifold", "skeleton"}],

Cell[CellGroupData[{

Cell["4.4.1.1 The Skeleton of an Ordinary Differential Equation", 
  "Subsubsection",
  CellTags->"The skeleton of an ordinary differential equation"],

Cell["\<\
As mentioned, the concept of an ordinary differential equation has \
two components. Let us first consider the first-order differential equation \
in the form\
\>", "Text",
  Evaluatable->False,
  CellTags->"first-order differential equation"],

Cell[BoxData[
    \(TraditionalForm\`\(F(x, u(x), u')\  = \ 0, \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u'\), "=", 
          FractionBox[
            StyleBox["du",
              FontSlant->"Italic"], 
            StyleBox["dx",
              FontSlant->"Italic"]]}], TraditionalForm]]],
  " is the first-order derivative. The two components of an ordinary \
differential equation are as follows:"
}], "Text",
  Evaluatable->False],

Cell["Definition: The Skeleton", "Definition",
  CellTags->"Definition: The Skeleton"],

Cell["\<\
The skeleton of a differential equation is defined as the surface\
\
\>", "Text",
  Evaluatable->False,
  CellTags->"surface"],

Cell[BoxData[
    \(TraditionalForm\`F(x, u, p)\  = 0\)], "NumberedEquation"],

Cell[TextData[{
  "in the space of the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ".  ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " denote the sets of dependent variables and derivatives, respectively. The \
corresponding differential equation follows from the skeleton with the \
replacement of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " by the derivatives ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((1)\)\)]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->"skeleton"],

Cell[TextData[
"This general definition reduced to first-order equations introduces nothing \
more than an extension of the manifold \[GothicCapitalM]. This extended \
manifold consists of the independent and dependent variables with the third \
direction denoting the first derivative. The once extended manifold is a very \
useful term in the discussion of first-order ordinary differential equations. \
Another term we need is the class of solutions."], "Text",
  CellTags->{"manifold", "extended manifold", "class of solutions"}],

Cell["\<\
The class of solutions is defined in consensus with certain \
mathematical or physical assumptions. \
\>", "Text"],

Cell["Definition: A class of solutions", "Definition",
  CellTags->"Definition: A Class of Solutions"],

Cell[TextData[{
  "A solution is a continuously differentiable function ",
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  " such that the curve ",
  Cell[BoxData[
      \(TraditionalForm\`u = h(x)\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u'\), "=", 
          FractionBox[
            RowBox[{
              StyleBox["dh",
                FontSlant->"Italic"], "(", "x", ")"}], 
            StyleBox["dx",
              FontSlant->"Italic"]]}], TraditionalForm]]],
  " belongs to the skeleton, that is, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"F", "(", 
            RowBox[{"x", ",", \(h(x)\), ",", 
              FractionBox[
                RowBox[{
                  StyleBox["dh",
                    FontSlant->"Italic"], "(", "x", ")"}], 
                StyleBox["dx",
                  FontSlant->"Italic"]]}], ")"}], "=", "0"}], 
        TraditionalForm]]],
  " identically in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " for some interval.\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The combination of both terms allows us to solve the first-order equation. \
The crucial step in integrating differential equations is a simplification of \
the skeleton. This simplification can be gained by a suitable change of \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". To this end, we use symmetry groups of differential equations, leaving \
the skeleton invariant. Provided a symmetry group is known, a simplification  \
of the skeleton can be carried out by introducing canonical variables, for \
example. This kind of simplification is demonstrated by the following \
examples."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "simplification of the skeleton", "change of variables", 
    "canonical variables"}],

Cell["Example 1", "Example"],

Cell["Let us consider the Riccati equation as a first example:", "Text",
  CellTags->"Riccati equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(riccati = \[PartialD]\_x u[x] + u[x]\^2 - 2\/x\^2 == 0; 
    riccati // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(u\^2\), "-", 
                StyleBox[\(2\/x\^2\),
                  ScriptLevel->0], "+", \(u\_x\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The skeleton of this Riccati equation is defined by the algebraic \
equation\
\>", "Text",
  Evaluatable->False,
  CellTags->"skeleton of the Riccati equation"],

Cell[BoxData[
    \(p + u\^2 - 2\/x\^2 == 0\)], "Input"],

Cell[TextData[{
  "and its surface, a so-called hyperbolic paraboloid, can be displayed by \
defining the skeleton as a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function:"
}], "Text",
  Evaluatable->False,
  CellTags->"hyperbolic paraboloid"],

Cell[BoxData[
    \(f[x_, u_] := \(-u\^2\) + 2\/x\^2\)], "Input"],

Cell["The corresponding surface in three dimensions is given by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pl1 = 
      Plot3D[f[x, u], {x, 0.25, 2}, {u, \(-5\), 5}, \n\t\tBoxed \[Rule] True, 
        Axes \[Rule] True, Mesh \[Rule] False, \n\t\tTicks \[Rule] None, 
        PlotPoints \[Rule] 30, \n\t\tBoxRatios \[Rule] {1, 3\/5, 1}, \n\t\t
        ViewPoint \[Rule] {1.975, \(-1.884\), 2.000}, \n\t\t
        AxesLabel \[Rule] {"\<x\>", "\<u\>", "\<p\>"}]\)], "Input",
  CellTags->"skeleton-Riccati"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.20141 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.149908 1.2594 0 1.2594 [
[.66677 1.1669 -5.73785 0 ]
[.66677 1.1669 6.26215 19 ]
[.19359 1.22462 -6.39592 0 ]
[.19359 1.22462 5.60408 19 ]
[1.03519 .50652 0 -14.8336 ]
[1.03519 .50652 12 4.1664 ]
[ 0 0 0 0 ]
[ 1 1.20141 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.38081 1.20141 m
1 .91828 L
s
gsave
.66677 1.1669 -66.7378 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 1.05195 m
.38081 1.20141 L
s
gsave
.19359 1.22462 -67.3959 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.9135 .24802 m
1 .91828 L
s
gsave
1.03519 .50652 -61 -18.8336 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.07455 .4049 m
0 1.05195 L
s
0 1.05195 m
.38081 1.20141 L
s
.38081 1.20141 m
.39495 .58525 L
s
.39495 .58525 m
.07455 .4049 L
s
.58882 0 m
.9135 .24802 L
s
.9135 .24802 m
1 .91828 L
s
1 .91828 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.07455 .4049 m
0 1.05195 L
s
0 1.05195 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.58882 0 m
.07455 .4049 L
s
.39495 .58525 m
.9135 .24802 L
s
.9135 .24802 m
1 .91828 L
s
1 .91828 m
.38081 1.20141 L
s
.38081 1.20141 m
.39495 .58525 L
s
0 0 m
1 0 L
1 1.20141 L
0 1.20141 L
closepath
clip
newpath
.969 .769 .579 r
.37564 .93374 .38764 .90365 .40654 .77943 .39504 .80736 Mtetra
.992 .875 .547 r
.39504 .80736 .40654 .77943 .42386 .70885 .41269 .73567 Mtetra
.807 .843 .381 r
.41269 .73567 .42386 .70885 .44059 .66259 .42966 .68877 Mtetra
0 0 0 r
.42966 .68877 .44059 .66259 .45709 .62902 .44636 .65478 Mtetra
0 0 .014 r
.44636 .65478 .45709 .62902 .47354 .60269 .46299 .62817 Mtetra
0 0 .1 r
.46299 .62817 .47354 .60269 .49003 .58079 .47965 .60608 Mtetra
.045 0 .148 r
.47965 .60608 .49003 .58079 .50661 .56175 .49639 .58688 Mtetra
.099 0 .177 r
.49639 .58688 .50661 .56175 .5233 .5446 .51324 .56963 Mtetra
.135 0 .196 r
.51324 .56963 .5233 .5446 .54013 .52876 .53022 .5537 Mtetra
.159 0 .208 r
.53022 .5537 .54013 .52876 .5571 .51384 .54735 .5387 Mtetra
.176 0 .217 r
.54735 .5387 .5571 .51384 .57424 .49956 .56465 .52437 Mtetra
.189 0 .223 r
.56465 .52437 .57424 .49956 .59154 .48575 .58211 .51051 Mtetra
.198 0 .228 r
.58211 .51051 .59154 .48575 .60901 .47226 .59974 .49698 Mtetra
.205 0 .232 r
.59974 .49698 .60901 .47226 .62666 .45901 .61756 .48369 Mtetra
.211 0 .234 r
.61756 .48369 .62666 .45901 .64449 .44592 .63555 .47056 Mtetra
.215 0 .236 r
.63555 .47056 .64449 .44592 .66251 .43293 .65374 .45753 Mtetra
.219 0 .238 r
.65374 .45753 .66251 .43293 .68071 .41999 .67212 .44457 Mtetra
.222 0 .239 r
.67212 .44457 .68071 .41999 .69911 .40708 .69069 .43163 Mtetra
.224 0 .241 r
.69069 .43163 .69911 .40708 .7177 .39417 .70947 .41869 Mtetra
.226 0 .241 r
.70947 .41869 .7177 .39417 .7365 .38124 .72845 .40573 Mtetra
.228 0 .242 r
.72845 .40573 .7365 .38124 .75549 .36826 .74763 .39272 Mtetra
.229 0 .243 r
.74763 .39272 .75549 .36826 .7747 .35522 .76703 .37965 Mtetra
.23 0 .243 r
.76703 .37965 .7747 .35522 .79411 .3421 .78664 .36651 Mtetra
.231 0 .244 r
.78664 .36651 .79411 .3421 .81374 .32891 .80647 .35328 Mtetra
.232 0 .244 r
.80647 .35328 .81374 .32891 .83359 .31562 .82653 .33996 Mtetra
.233 0 .244 r
.82653 .33996 .83359 .31562 .85365 .30223 .84681 .32654 Mtetra
.233 0 .245 r
.84681 .32654 .85365 .30223 .87395 .28873 .86732 .313 Mtetra
.234 0 .245 r
.86732 .313 .87395 .28873 .89447 .27511 .88806 .29935 Mtetra
.88806 .29935 .89447 .27511 .91522 .26138 .90905 .28557 Mtetra
.961 .759 .585 r
.36343 .96196 .37564 .93374 .39504 .80736 .38334 .8335 Mtetra
.995 .867 .572 r
.38334 .8335 .39504 .80736 .41269 .73567 .40131 .76074 Mtetra
.872 .884 .453 r
.40131 .76074 .41269 .73567 .42966 .68877 .41851 .71321 Mtetra
0 0 0 r
.41851 .71321 .42966 .68877 .44636 .65478 .43541 .67882 Mtetra
.43541 .67882 .44636 .65478 .46299 .62817 .45222 .65194 Mtetra
0 0 .037 r
.45222 .65194 .46299 .62817 .47965 .60608 .46903 .62965 Mtetra
0 0 .094 r
.46903 .62965 .47965 .60608 .49639 .58688 .48592 .61031 Mtetra
.055 0 .129 r
.48592 .61031 .49639 .58688 .51324 .56963 .50292 .59295 Mtetra
.096 0 .151 r
.50292 .59295 .51324 .56963 .53022 .5537 .52006 .57693 Mtetra
.123 0 .166 r
.52006 .57693 .53022 .5537 .54735 .5387 .53734 .56187 Mtetra
.143 0 .177 r
.53734 .56187 .54735 .5387 .56465 .52437 .55478 .54747 Mtetra
.158 0 .185 r
.55478 .54747 .56465 .52437 .58211 .51051 .57239 .53356 Mtetra
.168 0 .19 r
.57239 .53356 .58211 .51051 .59974 .49698 .59018 .51999 Mtetra
.176 0 .194 r
.59018 .51999 .59974 .49698 .61756 .48369 .60815 .50666 Mtetra
.183 0 .198 r
.60815 .50666 .61756 .48369 .63555 .47056 .6263 .4935 Mtetra
.188 0 .2 r
.6263 .4935 .63555 .47056 .65374 .45753 .64465 .48044 Mtetra
.192 0 .202 r
.64465 .48044 .65374 .45753 .67212 .44457 .66319 .46744 Mtetra
.195 0 .204 r
.66319 .46744 .67212 .44457 .69069 .43163 .68194 .45447 Mtetra
.198 0 .205 r
.68194 .45447 .69069 .43163 .70947 .41869 .70088 .4415 Mtetra
.2 0 .206 r
.70088 .4415 .70947 .41869 .72845 .40573 .72004 .42851 Mtetra
.202 0 .207 r
.72004 .42851 .72845 .40573 .74763 .39272 .7394 .41547 Mtetra
.203 0 .208 r
.7394 .41547 .74763 .39272 .76703 .37965 .75898 .40237 Mtetra
.205 0 .208 r
.75898 .40237 .76703 .37965 .78664 .36651 .77879 .3892 Mtetra
.206 0 .209 r
.77879 .3892 .78664 .36651 .80647 .35328 .79881 .37594 Mtetra
.207 0 .209 r
.79881 .37594 .80647 .35328 .82653 .33996 .81906 .36258 Mtetra
.207 0 .21 r
.81906 .36258 .82653 .33996 .84681 .32654 .83954 .34913 Mtetra
.208 0 .21 r
.83954 .34913 .84681 .32654 .86732 .313 .86026 .33555 Mtetra
.209 0 .21 r
.86026 .33555 .86732 .313 .88806 .29935 .88122 .32186 Mtetra
.88122 .32186 .88806 .29935 .90905 .28557 .90242 .30805 Mtetra
.953 .749 .59 r
.35102 .98818 .36343 .96196 .38334 .8335 .37145 .85773 Mtetra
.994 .856 .593 r
.37145 .85773 .38334 .8335 .40131 .76074 .38973 .78394 Mtetra
.922 .911 .518 r
.38973 .78394 .40131 .76074 .41851 .71321 .40717 .73581 Mtetra
.657 .791 .334 r
.40717 .73581 .41851 .71321 .43541 .67882 .42426 .70103 Mtetra
0 0 0 r
.42426 .70103 .43541 .67882 .45222 .65194 .44123 .67389 Mtetra
.44123 .67389 .45222 .65194 .46903 .62965 .4582 .65141 Mtetra
0 0 .028 r
.4582 .65141 .46903 .62965 .48592 .61031 .47523 .63194 Mtetra
0 0 .069 r
.47523 .63194 .48592 .61031 .50292 .59295 .49238 .61446 Mtetra
.047 0 .096 r
.49238 .61446 .50292 .59295 .52006 .57693 .50965 .59836 Mtetra
.08 0 .115 r
.50965 .59836 .52006 .57693 .53734 .56187 .52707 .58323 Mtetra
.102 0 .128 r
.52707 .58323 .53734 .56187 .55478 .54747 .54465 .56877 Mtetra
.119 0 .137 r
.54465 .56877 .55478 .54747 .57239 .53356 .5624 .55481 Mtetra
.132 0 .144 r
.5624 .55481 .57239 .53356 .59018 .51999 .58033 .5412 Mtetra
.141 0 .149 r
.58033 .5412 .59018 .51999 .60815 .50666 .59845 .52783 Mtetra
.148 0 .153 r
.59845 .52783 .60815 .50666 .6263 .4935 .61675 .51462 Mtetra
.154 0 .156 r
.61675 .51462 .6263 .4935 .64465 .48044 .63525 .50153 Mtetra
.159 0 .158 r
.63525 .50153 .64465 .48044 .66319 .46744 .65395 .4885 Mtetra
.163 0 .16 r
.65395 .4885 .66319 .46744 .68194 .45447 .67285 .4755 Mtetra
.166 0 .162 r
.67285 .4755 .68194 .45447 .70088 .4415 .69196 .4625 Mtetra
.168 0 .163 r
.69196 .4625 .70088 .4415 .72004 .42851 .71128 .44948 Mtetra
.17 0 .164 r
.71128 .44948 .72004 .42851 .7394 .41547 .73081 .4364 Mtetra
.172 0 .165 r
.73081 .4364 .7394 .41547 .75898 .40237 .75057 .42327 Mtetra
.174 0 .165 r
.75057 .42327 .75898 .40237 .77879 .3892 .77055 .41006 Mtetra
.175 0 .166 r
.77055 .41006 .77879 .3892 .79881 .37594 .79075 .39677 Mtetra
.176 0 .167 r
.79075 .39677 .79881 .37594 .81906 .36258 .81119 .38338 Mtetra
.177 0 .167 r
.81119 .38338 .81906 .36258 .83954 .34913 .83186 .36989 Mtetra
.178 0 .167 r
.83186 .36989 .83954 .34913 .86026 .33555 .85278 .35628 Mtetra
.178 0 .168 r
.85278 .35628 .86026 .33555 .88122 .32186 .87394 .34255 Mtetra
.179 0 .168 r
.87394 .34255 .88122 .32186 .90242 .30805 .89535 .32869 Mtetra
.945 .739 .594 r
.33844 1.0123 .35102 .98818 .37145 .85773 .35937 .87994 Mtetra
.988 .842 .609 r
.35937 .87994 .37145 .85773 .38973 .78394 .37797 .80517 Mtetra
.956 .923 .573 r
.37797 .80517 .38973 .78394 .40717 .73581 .39564 .75646 Mtetra
.756 .865 .435 r
.39564 .75646 .40717 .73581 .42426 .70103 .41291 .72132 Mtetra
0 0 0 r
.41291 .72132 .42426 .70103 .44123 .67389 .43004 .69392 Mtetra
.43004 .69392 .44123 .67389 .4582 .65141 .44715 .67127 Mtetra
.44715 .67127 .4582 .65141 .47523 .63194 .46433 .65165 Mtetra
.46433 .65165 .47523 .63194 .49238 .61446 .4816 .63407 Mtetra
0 0 .027 r
.4816 .63407 .49238 .61446 .50965 .59836 .49901 .61789 Mtetra
.025 0 .05 r
.49901 .61789 .50965 .59836 .52707 .58323 .51656 .60268 Mtetra
.051 0 .065 r
.51656 .60268 .52707 .58323 .54465 .56877 .53427 .58817 Mtetra
.071 0 .076 r
.53427 .58817 .54465 .56877 .5624 .55481 .55215 .57416 Mtetra
.086 0 .085 r
.55215 .57416 .5624 .55481 .58033 .5412 .57022 .5605 Mtetra
.097 0 .091 r
.57022 .5605 .58033 .5412 .59845 .52783 .58847 .54709 Mtetra
.105 0 .096 r
.58847 .54709 .59845 .52783 .61675 .51462 .60691 .53385 Mtetra
.112 0 .1 r
.60691 .53385 .61675 .51462 .63525 .50153 .62555 .52072 Mtetra
.118 0 .103 r
.62555 .52072 .63525 .50153 .65395 .4885 .64439 .50765 Mtetra
.122 0 .105 r
.64439 .50765 .65395 .4885 .67285 .4755 .66344 .49462 Mtetra
.126 0 .107 r
.66344 .49462 .67285 .4755 .69196 .4625 .6827 .48158 Mtetra
.128 0 .109 r
.6827 .48158 .69196 .4625 .71128 .44948 .70217 .46852 Mtetra
.131 0 .11 r
.70217 .46852 .71128 .44948 .73081 .4364 .72186 .45542 Mtetra
.133 0 .111 r
.72186 .45542 .73081 .4364 .75057 .42327 .74178 .44225 Mtetra
.135 0 .112 r
.74178 .44225 .75057 .42327 .77055 .41006 .76192 .42901 Mtetra
.136 0 .112 r
.76192 .42901 .77055 .41006 .79075 .39677 .7823 .41568 Mtetra
.137 0 .113 r
.7823 .41568 .79075 .39677 .81119 .38338 .80291 .40225 Mtetra
.138 0 .114 r
.80291 .40225 .81119 .38338 .83186 .36989 .82377 .38871 Mtetra
.139 0 .114 r
.82377 .38871 .83186 .36989 .85278 .35628 .84486 .37506 Mtetra
.14 0 .114 r
.84486 .37506 .85278 .35628 .87394 .34255 .86621 .36129 Mtetra
.141 0 .115 r
.86621 .36129 .87394 .34255 .89535 .32869 .88781 .34739 Mtetra
.936 .73 .598 r
.32569 1.03419 .33844 1.0123 .35937 .87994 .34714 .90003 Mtetra
.979 .827 .622 r
.34714 .90003 .35937 .87994 .37797 .80517 .36605 .82433 Mtetra
.975 .921 .617 r
.36605 .82433 .37797 .80517 .39564 .75646 .38394 .77508 Mtetra
.841 .922 .531 r
.38394 .77508 .39564 .75646 .41291 .72132 .40138 .73958 Mtetra
.608 .803 .384 r
.40138 .73958 .41291 .72132 .43004 .69392 .41866 .71195 Mtetra
0 0 0 r
.41866 .71195 .43004 .69392 .44715 .67127 .43592 .68912 Mtetra
.43592 .68912 .44715 .67127 .46433 .65165 .45322 .66937 Mtetra
.45322 .66937 .46433 .65165 .4816 .63407 .47062 .65169 Mtetra
.47062 .65169 .4816 .63407 .49901 .61789 .48814 .63542 Mtetra
.48814 .63542 .49901 .61789 .51656 .60268 .50581 .62015 Mtetra
.50581 .62015 .51656 .60268 .53427 .58817 .52365 .60557 Mtetra
.009 0 0 r
.52365 .60557 .53427 .58817 .55215 .57416 .54165 .59151 Mtetra
.027 0 .01 r
.54165 .59151 .55215 .57416 .57022 .5605 .55984 .5778 Mtetra
.04 0 .018 r
.55984 .5778 .57022 .5605 .58847 .54709 .57822 .56434 Mtetra
.05 0 .024 r
.57822 .56434 .58847 .54709 .60691 .53385 .59679 .55106 Mtetra
.058 0 .028 r
.59679 .55106 .60691 .53385 .62555 .52072 .61555 .53789 Mtetra
.065 0 .032 r
.61555 .53789 .62555 .52072 .64439 .50765 .63453 .52479 Mtetra
.07 0 .035 r
.63453 .52479 .64439 .50765 .66344 .49462 .65371 .51172 Mtetra
.074 0 .037 r
.65371 .51172 .66344 .49462 .6827 .48158 .67311 .49865 Mtetra
.078 0 .039 r
.67311 .49865 .6827 .48158 .70217 .46852 .69273 .48555 Mtetra
.081 0 .041 r
.69273 .48555 .70217 .46852 .72186 .45542 .71257 .47241 Mtetra
.083 0 .042 r
.71257 .47241 .72186 .45542 .74178 .44225 .73263 .4592 Mtetra
.085 0 .043 r
.73263 .4592 .74178 .44225 .76192 .42901 .75293 .44592 Mtetra
.087 0 .044 r
.75293 .44592 .76192 .42901 .7823 .41568 .77346 .43255 Mtetra
.088 0 .045 r
.77346 .43255 .7823 .41568 .80291 .40225 .79424 .41908 Mtetra
.089 0 .046 r
.79424 .41908 .80291 .40225 .82377 .38871 .81526 .4055 Mtetra
.091 0 .046 r
.81526 .4055 .82377 .38871 .84486 .37506 .83652 .39181 Mtetra
.091 0 .047 r
.83652 .39181 .84486 .37506 .86621 .36129 .85805 .37799 Mtetra
.092 0 .047 r
.85805 .37799 .86621 .36129 .88781 .34739 .87983 .36404 Mtetra
.928 .72 .601 r
.31279 1.05376 .32569 1.03419 .34714 .90003 .33476 .9179 Mtetra
.968 .81 .632 r
.33476 .9179 .34714 .90003 .36605 .82433 .35398 .84133 Mtetra
.981 .909 .649 r
.35398 .84133 .36605 .82433 .38394 .77508 .37208 .79157 Mtetra
.903 .954 .612 r
.37208 .79157 .38394 .77508 .40138 .73958 .3897 .75574 Mtetra
.725 .894 .508 r
.3897 .75574 .40138 .73958 .41866 .71195 .40712 .72787 Mtetra
0 0 0 r
.40712 .72787 .41866 .71195 .43592 .68912 .4245 .70487 Mtetra
.4245 .70487 .43592 .68912 .45322 .66937 .44192 .685 Mtetra
.44192 .685 .45322 .66937 .47062 .65169 .45943 .66721 Mtetra
.45943 .66721 .47062 .65169 .48814 .63542 .47707 .65086 Mtetra
.47707 .65086 .48814 .63542 .50581 .62015 .49485 .63552 Mtetra
.49485 .63552 .50581 .62015 .52365 .60557 .5128 .62089 Mtetra
.5128 .62089 .52365 .60557 .54165 .59151 .53092 .60676 Mtetra
.53092 .60676 .54165 .59151 .55984 .5778 .54922 .59301 Mtetra
.54922 .59301 .55984 .5778 .57822 .56434 .56771 .5795 Mtetra
.56771 .5795 .57822 .56434 .59679 .55106 .58639 .56618 Mtetra
.58639 .56618 .59679 .55106 .61555 .53789 .60528 .55297 Mtetra
.60528 .55297 .61555 .53789 .63453 .52479 .62437 .53983 Mtetra
.002 0 0 r
.62437 .53983 .63453 .52479 .65371 .51172 .64368 .52671 Mtetra
.007 0 0 r
.64368 .52671 .65371 .51172 .67311 .49865 .66321 .5136 Mtetra
.011 0 0 r
.66321 .5136 .67311 .49865 .69273 .48555 .68295 .50046 Mtetra
.015 0 0 r
.68295 .50046 .69273 .48555 .71257 .47241 .70293 .48728 Mtetra
.018 0 0 r
.70293 .48728 .71257 .47241 .73263 .4592 .72313 .47403 Mtetra
.02 0 0 r
.72313 .47403 .73263 .4592 .75293 .44592 .74357 .4607 Mtetra
.022 0 0 r
.74357 .4607 .75293 .44592 .77346 .43255 .76424 .44729 Mtetra
.024 0 0 r
.76424 .44729 .77346 .43255 .79424 .41908 .78517 .43378 Mtetra
.026 0 0 r
.78517 .43378 .79424 .41908 .81526 .4055 .80634 .42015 Mtetra
.027 0 0 r
.80634 .42015 .81526 .4055 .83652 .39181 .82776 .40641 Mtetra
.028 0 0 r
.82776 .40641 .83652 .39181 .85805 .37799 .84944 .39254 Mtetra
.029 0 0 r
.84944 .39254 .85805 .37799 .87983 .36404 .87139 .37854 Mtetra
.919 .71 .604 r
.29979 1.07088 .31279 1.05376 .33476 .9179 .32227 .93346 Mtetra
.956 .792 .639 r
.32227 .93346 .33476 .9179 .35398 .84133 .34179 .85608 Mtetra
.977 .889 .672 r
.34179 .85608 .35398 .84133 .37208 .79157 .36009 .80583 Mtetra
.941 .961 .674 r
.36009 .80583 .37208 .79157 .3897 .75574 .37787 .76969 Mtetra
.821 .957 .62 r
.37787 .76969 .3897 .75574 .40712 .72787 .39543 .74161 Mtetra
.659 .886 .531 r
.39543 .74161 .40712 .72787 .4245 .70487 .41292 .71845 Mtetra
0 0 0 r
.41292 .71845 .4245 .70487 .44192 .685 .43046 .69845 Mtetra
.43046 .69845 .44192 .685 .45943 .66721 .44807 .68057 Mtetra
.44807 .68057 .45943 .66721 .47707 .65086 .46581 .66413 Mtetra
.46581 .66413 .47707 .65086 .49485 .63552 .48369 .64872 Mtetra
.48369 .64872 .49485 .63552 .5128 .62089 .50174 .63402 Mtetra
.50174 .63402 .5128 .62089 .53092 .60676 .51996 .61984 Mtetra
.51996 .61984 .53092 .60676 .54922 .59301 .53836 .60603 Mtetra
.53836 .60603 .54922 .59301 .56771 .5795 .55695 .59248 Mtetra
.55695 .59248 .56771 .5795 .58639 .56618 .57574 .57911 Mtetra
.57574 .57911 .58639 .56618 .60528 .55297 .59473 .56585 Mtetra
.59473 .56585 .60528 .55297 .62437 .53983 .61394 .55267 Mtetra
.61394 .55267 .62437 .53983 .64368 .52671 .63336 .53951 Mtetra
.63336 .53951 .64368 .52671 .66321 .5136 .653 .52635 Mtetra
.653 .52635 .66321 .5136 .68295 .50046 .67286 .51317 Mtetra
.67286 .51317 .68295 .50046 .70293 .48728 .69295 .49994 Mtetra
.69295 .49994 .70293 .48728 .72313 .47403 .71328 .48664 Mtetra
.71328 .48664 .72313 .47403 .74357 .4607 .73385 .47327 Mtetra
.73385 .47327 .74357 .4607 .76424 .44729 .75465 .45981 Mtetra
.75465 .45981 .76424 .44729 .78517 .43378 .77571 .44625 Mtetra
.77571 .44625 .78517 .43378 .80634 .42015 .79702 .43257 Mtetra
.79702 .43257 .80634 .42015 .82776 .40641 .81858 .41878 Mtetra
.81858 .41878 .82776 .40641 .84944 .39254 .84041 .40485 Mtetra
.84041 .40485 .84944 .39254 .87139 .37854 .86251 .39079 Mtetra
.911 .701 .606 r
.28668 1.08548 .29979 1.07088 .32227 .93346 .30967 .94661 Mtetra
.942 .774 .645 r
.30967 .94661 .32227 .93346 .34179 .85608 .32949 .86849 Mtetra
.966 .865 .688 r
.32949 .86849 .34179 .85608 .36009 .80583 .34799 .8178 Mtetra
.955 .947 .717 r
.34799 .8178 .36009 .80583 .37787 .76969 .36592 .78136 Mtetra
.886 .984 .709 r
.36592 .78136 .37787 .76969 .39543 .74161 .3836 .75307 Mtetra
.772 .964 .663 r
.3836 .75307 .39543 .74161 .41292 .71845 .40121 .72976 Mtetra
.648 .91 .599 r
.40121 .72976 .41292 .71845 .43046 .69845 .41884 .70964 Mtetra
.54 .848 .538 r
.41884 .70964 .43046 .69845 .44807 .68057 .43655 .69166 Mtetra
0 0 0 r
.43655 .69166 .44807 .68057 .46581 .66413 .45438 .67515 Mtetra
.45438 .67515 .46581 .66413 .48369 .64872 .47235 .65966 Mtetra
.47235 .65966 .48369 .64872 .50174 .63402 .49048 .6449 Mtetra
.49048 .6449 .50174 .63402 .51996 .61984 .50879 .63066 Mtetra
.50879 .63066 .51996 .61984 .53836 .60603 .52728 .61679 Mtetra
.52728 .61679 .53836 .60603 .55695 .59248 .54596 .60319 Mtetra
.54596 .60319 .55695 .59248 .57574 .57911 .56485 .58977 Mtetra
.56485 .58977 .57574 .57911 .59473 .56585 .58394 .57646 Mtetra
.58394 .57646 .59473 .56585 .61394 .55267 .60324 .56323 Mtetra
.60324 .56323 .61394 .55267 .63336 .53951 .62275 .55002 Mtetra
.62275 .55002 .63336 .53951 .653 .52635 .64249 .53681 Mtetra
.64249 .53681 .653 .52635 .67286 .51317 .66246 .52358 Mtetra
.66246 .52358 .67286 .51317 .69295 .49994 .68266 .5103 Mtetra
.68266 .5103 .69295 .49994 .71328 .48664 .7031 .49696 Mtetra
.7031 .49696 .71328 .48664 .73385 .47327 .72378 .48353 Mtetra
.72378 .48353 .73385 .47327 .75465 .45981 .7447 .47002 Mtetra
.7447 .47002 .75465 .45981 .77571 .44625 .76587 .4564 Mtetra
.76587 .4564 .77571 .44625 .79702 .43257 .78731 .44267 Mtetra
.78731 .44267 .79702 .43257 .81858 .41878 .809 .42882 Mtetra
.809 .42882 .81858 .41878 .84041 .40485 .83095 .41483 Mtetra
.83095 .41483 .84041 .40485 .86251 .39079 .85318 .40072 Mtetra
.902 .692 .608 r
.27351 1.09745 .28668 1.08548 .30967 .94661 .297 .95728 Mtetra
.928 .757 .648 r
.297 .95728 .30967 .94661 .32949 .86849 .3171 .87848 Mtetra
.95 .837 .697 r
.3171 .87848 .32949 .86849 .34799 .8178 .3358 .82738 Mtetra
.951 .919 .742 r
.3358 .82738 .34799 .8178 .36592 .78136 .35386 .79068 Mtetra
.917 .976 .767 r
.35386 .79068 .36592 .78136 .3836 .75307 .37166 .76219 Mtetra
.848 .996 .763 r
.37166 .76219 .3836 .75307 .40121 .72976 .38937 .73874 Mtetra
.761 .982 .736 r
.38937 .73874 .40121 .72976 .41884 .70964 .40709 .7185 Mtetra
.675 .951 .7 r
.40709 .7185 .41884 .70964 .43655 .69166 .42488 .70043 Mtetra
.601 .915 .664 r
.42488 .70043 .43655 .69166 .45438 .67515 .44279 .68383 Mtetra
.541 .882 .633 r
.44279 .68383 .45438 .67515 .47235 .65966 .46084 .66827 Mtetra
.493 .853 .606 r
.46084 .66827 .47235 .65966 .49048 .6449 .47905 .65344 Mtetra
.456 .829 .585 r
.47905 .65344 .49048 .6449 .50879 .63066 .49744 .63914 Mtetra
.426 .81 .568 r
.49744 .63914 .50879 .63066 .52728 .61679 .516 .62522 Mtetra
0 0 0 r
.516 .62522 .52728 .61679 .54596 .60319 .53477 .61156 Mtetra
.53477 .61156 .54596 .60319 .56485 .58977 .55373 .59808 Mtetra
.55373 .59808 .56485 .58977 .58394 .57646 .5729 .58472 Mtetra
.5729 .58472 .58394 .57646 .60324 .56323 .59228 .57143 Mtetra
.59228 .57143 .60324 .56323 .62275 .55002 .61189 .55817 Mtetra
.61189 .55817 .62275 .55002 .64249 .53681 .63171 .54491 Mtetra
.63171 .54491 .64249 .53681 .66246 .52358 .65177 .53162 Mtetra
.65177 .53162 .66246 .52358 .68266 .5103 .67206 .51829 Mtetra
.67206 .51829 .68266 .5103 .7031 .49696 .6926 .50489 Mtetra
.6926 .50489 .7031 .49696 .72378 .48353 .71337 .49141 Mtetra
.71337 .49141 .72378 .48353 .7447 .47002 .7344 .47784 Mtetra
.7344 .47784 .7447 .47002 .76587 .4564 .75567 .46416 Mtetra
.75567 .46416 .76587 .4564 .78731 .44267 .77721 .45037 Mtetra
.77721 .45037 .78731 .44267 .809 .42882 .79901 .43645 Mtetra
.79901 .43645 .809 .42882 .83095 .41483 .82108 .4224 Mtetra
.82108 .4224 .83095 .41483 .85318 .40072 .84343 .40822 Mtetra
.894 .683 .61 r
.26029 1.10671 .27351 1.09745 .297 .95728 .28427 .96539 Mtetra
.914 .739 .651 r
.28427 .96539 .297 .95728 .3171 .87848 .30465 .88598 Mtetra
.932 .809 .702 r
.30465 .88598 .3171 .87848 .3358 .82738 .32353 .83451 Mtetra
.937 .883 .755 r
.32353 .83451 .3358 .82738 .35386 .79068 .34173 .79756 Mtetra
.92 .944 .798 r
.34173 .79756 .35386 .79068 .37166 .76219 .35963 .7689 Mtetra
.882 .984 .823 r
.35963 .7689 .37166 .76219 .38937 .73874 .37743 .74531 Mtetra
.829 .999 .829 r
.37743 .74531 .38937 .73874 .40709 .7185 .39522 .72497 Mtetra
.772 .997 .822 r
.39522 .72497 .40709 .7185 .42488 .70043 .41309 .70679 Mtetra
.718 .985 .809 r
.41309 .70679 .42488 .70043 .44279 .68383 .43107 .69011 Mtetra
.671 .97 .794 r
.43107 .69011 .44279 .68383 .46084 .66827 .44919 .67448 Mtetra
.632 .955 .779 r
.44919 .67448 .46084 .66827 .47905 .65344 .46746 .65958 Mtetra
.6 .941 .766 r
.46746 .65958 .47905 .65344 .49744 .63914 .48591 .64522 Mtetra
.574 .928 .755 r
.48591 .64522 .49744 .63914 .516 .62522 .50454 .63123 Mtetra
.553 .918 .746 r
.50454 .63123 .516 .62522 .53477 .61156 .52337 .61751 Mtetra
.536 .909 .738 r
.52337 .61751 .53477 .61156 .55373 .59808 .5424 .60398 Mtetra
.522 .902 .732 r
.5424 .60398 .55373 .59808 .5729 .58472 .56164 .59056 Mtetra
.511 .895 .726 r
.56164 .59056 .5729 .58472 .59228 .57143 .5811 .57721 Mtetra
.502 .89 .722 r
.5811 .57721 .59228 .57143 .61189 .55817 .60077 .56389 Mtetra
.494 .886 .718 r
.60077 .56389 .61189 .55817 .63171 .54491 .62067 .55057 Mtetra
.487 .882 .715 r
.62067 .55057 .63171 .54491 .65177 .53162 .64081 .53723 Mtetra
.482 .879 .713 r
.64081 .53723 .65177 .53162 .67206 .51829 .66118 .52383 Mtetra
.477 .876 .711 r
.66118 .52383 .67206 .51829 .6926 .50489 .68179 .51037 Mtetra
.473 .874 .709 r
.68179 .51037 .6926 .50489 .71337 .49141 .70264 .49683 Mtetra
.47 .872 .707 r
.70264 .49683 .71337 .49141 .7344 .47784 .72375 .48319 Mtetra
.467 .871 .706 r
.72375 .48319 .7344 .47784 .75567 .46416 .74512 .46945 Mtetra
.465 .869 .705 r
.74512 .46945 .75567 .46416 .77721 .45037 .76675 .45559 Mtetra
.463 .868 .704 r
.76675 .45559 .77721 .45037 .79901 .43645 .78864 .4416 Mtetra
.461 .867 .703 r
.78864 .4416 .79901 .43645 .82108 .4224 .81081 .42749 Mtetra
.46 .866 .703 r
.81081 .42749 .82108 .4224 .84343 .40822 .83326 .41323 Mtetra
.885 .674 .611 r
.24705 1.1132 .26029 1.10671 .28427 .96539 .27152 .97086 Mtetra
.9 .722 .652 r
.27152 .97086 .28427 .96539 .30465 .88598 .29217 .89092 Mtetra
.912 .782 .704 r
.29217 .89092 .30465 .88598 .32353 .83451 .31122 .83913 Mtetra
.915 .844 .759 r
.31122 .83913 .32353 .83451 .34173 .79756 .32954 .80197 Mtetra
.906 .9 .809 r
.32954 .80197 .34173 .79756 .35963 .7689 .34753 .77314 Mtetra
.883 .942 .848 r
.34753 .77314 .35963 .7689 .37743 .74531 .3654 .74942 Mtetra
.851 .969 .873 r
.3654 .74942 .37743 .74531 .39522 .72497 .38327 .72897 Mtetra
.816 .983 .887 r
.38327 .72897 .39522 .72497 .41309 .70679 .4012 .7107 Mtetra
.781 .988 .893 r
.4012 .7107 .41309 .70679 .43107 .69011 .41923 .69394 Mtetra
.75 .988 .895 r
.41923 .69394 .43107 .69011 .44919 .67448 .4374 .67823 Mtetra
.723 .985 .894 r
.4374 .67823 .44919 .67448 .46746 .65958 .45573 .66327 Mtetra
.7 .981 .891 r
.45573 .66327 .46746 .65958 .48591 .64522 .47424 .64883 Mtetra
.681 .977 .888 r
.47424 .64883 .48591 .64522 .50454 .63123 .49292 .63478 Mtetra
.665 .973 .886 r
.49292 .63478 .50454 .63123 .52337 .61751 .5118 .621 Mtetra
.652 .97 .883 r
.5118 .621 .52337 .61751 .5424 .60398 .53089 .6074 Mtetra
.642 .966 .881 r
.53089 .6074 .5424 .60398 .56164 .59056 .55018 .59392 Mtetra
.633 .963 .879 r
.55018 .59392 .56164 .59056 .5811 .57721 .56969 .5805 Mtetra
.625 .961 .877 r
.56969 .5805 .5811 .57721 .60077 .56389 .58942 .56712 Mtetra
.619 .959 .876 r
.58942 .56712 .60077 .56389 .62067 .55057 .60939 .55374 Mtetra
.614 .957 .875 r
.60939 .55374 .62067 .55057 .64081 .53723 .62958 .54033 Mtetra
.61 .955 .874 r
.62958 .54033 .64081 .53723 .66118 .52383 .65001 .52686 Mtetra
.606 .954 .873 r
.65001 .52686 .66118 .52383 .68179 .51037 .67069 .51333 Mtetra
.603 .953 .872 r
.67069 .51333 .68179 .51037 .70264 .49683 .69161 .49972 Mtetra
.6 .952 .871 r
.69161 .49972 .70264 .49683 .72375 .48319 .71279 .48602 Mtetra
.598 .951 .871 r
.71279 .48602 .72375 .48319 .74512 .46945 .73423 .4722 Mtetra
.596 .95 .87 r
.73423 .4722 .74512 .46945 .76675 .45559 .75593 .45827 Mtetra
.594 .949 .87 r
.75593 .45827 .76675 .45559 .78864 .4416 .77791 .44421 Mtetra
.592 .949 .87 r
.77791 .44421 .78864 .4416 .81081 .42749 .80015 .43002 Mtetra
.591 .948 .869 r
.80015 .43002 .81081 .42749 .83326 .41323 .82268 .41568 Mtetra
.877 .665 .612 r
.23381 1.11683 .24705 1.1132 .27152 .97086 .25876 .97365 Mtetra
.886 .706 .653 r
.25876 .97365 .27152 .97086 .29217 .89092 .27967 .89326 Mtetra
.892 .755 .704 r
.27967 .89326 .29217 .89092 .31122 .83913 .29888 .84119 Mtetra
.891 .805 .758 r
.29888 .84119 .31122 .83913 .32954 .80197 .31731 .80383 Mtetra
.882 .851 .808 r
.31731 .80383 .32954 .80197 .34753 .77314 .33539 .77486 Mtetra
.865 .887 .85 r
.33539 .77486 .34753 .77314 .3654 .74942 .35333 .75101 Mtetra
.843 .913 .883 r
.35333 .75101 .3654 .74942 .38327 .72897 .37125 .73046 Mtetra
.819 .931 .906 r
.37125 .73046 .38327 .72897 .4012 .7107 .38923 .71211 Mtetra
.797 .942 .921 r
.38923 .71211 .4012 .7107 .41923 .69394 .40731 .69526 Mtetra
.776 .948 .932 r
.40731 .69526 .41923 .69394 .4374 .67823 .42552 .67947 Mtetra
.758 .951 .939 r
.42552 .67947 .4374 .67823 .45573 .66327 .44389 .66443 Mtetra
.743 .953 .944 r
.44389 .66443 .45573 .66327 .47424 .64883 .46243 .64993 Mtetra
.73 .954 .947 r
.46243 .64993 .47424 .64883 .49292 .63478 .48116 .63581 Mtetra
.719 .954 .949 r
.48116 .63581 .49292 .63478 .5118 .621 .50008 .62196 Mtetra
.71 .954 .951 r
.50008 .62196 .5118 .621 .53089 .6074 .5192 .60829 Mtetra
.703 .953 .952 r
.5192 .60829 .53089 .6074 .55018 .59392 .53854 .59474 Mtetra
.697 .953 .953 r
.53854 .59474 .55018 .59392 .56969 .5805 .55809 .58126 Mtetra
.691 .952 .954 r
.55809 .58126 .56969 .5805 .58942 .56712 .57787 .5678 Mtetra
.687 .952 .954 r
.57787 .5678 .58942 .56712 .60939 .55374 .59787 .55435 Mtetra
.683 .951 .955 r
.59787 .55435 .60939 .55374 .62958 .54033 .61811 .54087 Mtetra
.68 .951 .955 r
.61811 .54087 .62958 .54033 .65001 .52686 .6386 .52733 Mtetra
.677 .951 .955 r
.6386 .52733 .65001 .52686 .67069 .51333 .65932 .51373 Mtetra
.675 .95 .955 r
.65932 .51373 .67069 .51333 .69161 .49972 .6803 .50004 Mtetra
.673 .95 .955 r
.6803 .50004 .69161 .49972 .71279 .48602 .70153 .48626 Mtetra
.671 .95 .956 r
.70153 .48626 .71279 .48602 .73423 .4722 .72302 .47237 Mtetra
.67 .949 .956 r
.72302 .47237 .73423 .4722 .75593 .45827 .74478 .45835 Mtetra
.669 .949 .956 r
.74478 .45835 .75593 .45827 .77791 .44421 .76681 .44422 Mtetra
.668 .949 .956 r
.76681 .44422 .77791 .44421 .80015 .43002 .78912 .42994 Mtetra
.667 .949 .956 r
.78912 .42994 .80015 .43002 .82268 .41568 .81171 .41552 Mtetra
.869 .657 .612 r
.22062 1.11757 .23381 1.11683 .25876 .97365 .24602 .97371 Mtetra
.872 .69 .653 r
.24602 .97371 .25876 .97365 .27967 .89326 .26718 .89295 Mtetra
.872 .729 .701 r
.26718 .89295 .27967 .89326 .29888 .84119 .28654 .84064 Mtetra
.866 .768 .752 r
.28654 .84064 .29888 .84119 .31731 .80383 .30507 .80311 Mtetra
.854 .803 .8 r
.30507 .80311 .31731 .80383 .33539 .77486 .32322 .774 Mtetra
.838 .83 .84 r
.32322 .774 .33539 .77486 .35333 .75101 .34121 .75005 Mtetra
.819 .851 .872 r
.34121 .75005 .35333 .75101 .37125 .73046 .35918 .7294 Mtetra
.801 .865 .896 r
.35918 .7294 .37125 .73046 .38923 .71211 .37719 .71096 Mtetra
.784 .875 .914 r
.37719 .71096 .38923 .71211 .40731 .69526 .39531 .69403 Mtetra
.768 .882 .928 r
.39531 .69403 .40731 .69526 .42552 .67947 .41355 .67816 Mtetra
.755 .886 .938 r
.41355 .67816 .42552 .67947 .44389 .66443 .43195 .66305 Mtetra
.744 .889 .945 r
.43195 .66305 .44389 .66443 .46243 .64993 .45052 .64847 Mtetra
.735 .891 .95 r
.45052 .64847 .46243 .64993 .48116 .63581 .46927 .63427 Mtetra
.728 .892 .955 r
.46927 .63427 .48116 .63581 .50008 .62196 .48822 .62035 Mtetra
.721 .893 .958 r
.48822 .62035 .50008 .62196 .5192 .60829 .50737 .6066 Mtetra
.716 .893 .961 r
.50737 .6066 .5192 .60829 .53854 .59474 .52674 .59298 Mtetra
.711 .894 .963 r
.52674 .59298 .53854 .59474 .55809 .58126 .54632 .57942 Mtetra
.708 .894 .964 r
.54632 .57942 .55809 .58126 .57787 .5678 .56612 .5659 Mtetra
.704 .894 .966 r
.56612 .5659 .57787 .5678 .59787 .55435 .58616 .55236 Mtetra
.702 .894 .967 r
.58616 .55236 .59787 .55435 .61811 .54087 .60643 .5388 Mtetra
.699 .894 .968 r
.60643 .5388 .61811 .54087 .6386 .52733 .62694 .52519 Mtetra
.697 .894 .968 r
.62694 .52519 .6386 .52733 .65932 .51373 .6477 .51151 Mtetra
.696 .894 .969 r
.6477 .51151 .65932 .51373 .6803 .50004 .66871 .49774 Mtetra
.694 .894 .97 r
.66871 .49774 .6803 .50004 .70153 .48626 .68998 .48387 Mtetra
.693 .894 .97 r
.68998 .48387 .70153 .48626 .72302 .47237 .71151 .4699 Mtetra
.692 .894 .971 r
.71151 .4699 .72302 .47237 .74478 .45835 .73331 .4558 Mtetra
.691 .894 .971 r
.73331 .4558 .74478 .45835 .76681 .44422 .75538 .44157 Mtetra
.69 .894 .971 r
.75538 .44157 .76681 .44422 .78912 .42994 .77774 .4272 Mtetra
.689 .894 .971 r
.77774 .4272 .78912 .42994 .81171 .41552 .80037 .41269 Mtetra
.861 .648 .613 r
.20748 1.11537 .22062 1.11757 .24602 .97371 .23334 .97099 Mtetra
.859 .675 .652 r
.23334 .97099 .24602 .97371 .26718 .89295 .25472 .88994 Mtetra
.853 .705 .698 r
.25472 .88994 .26718 .89295 .28654 .84064 .27422 .83745 Mtetra
.841 .734 .745 r
.27422 .83745 .28654 .84064 .30507 .80311 .29284 .79977 Mtetra
.826 .758 .788 r
.29284 .79977 .30507 .80311 .32322 .774 .31105 .77055 Mtetra
.808 .777 .824 r
.31105 .77055 .32322 .774 .34121 .75005 .32909 .74649 Mtetra
.79 .791 .853 r
.32909 .74649 .34121 .75005 .35918 .7294 .34709 .72575 Mtetra
.773 .8 .875 r
.34709 .72575 .35918 .7294 .37719 .71096 .36513 .70722 Mtetra
.758 .807 .892 r
.36513 .70722 .37719 .71096 .39531 .69403 .38326 .69021 Mtetra
.746 .811 .904 r
.38326 .69021 .39531 .69403 .41355 .67816 .40153 .67426 Mtetra
.735 .814 .914 r
.40153 .67426 .41355 .67816 .43195 .66305 .41994 .65907 Mtetra
.726 .816 .921 r
.41994 .65907 .43195 .66305 .45052 .64847 .43853 .64441 Mtetra
.718 .818 .927 r
.43853 .64441 .45052 .64847 .46927 .63427 .45729 .63014 Mtetra
.712 .819 .931 r
.45729 .63014 .46927 .63427 .48822 .62035 .47625 .61613 Mtetra
.707 .819 .935 r
.47625 .61613 .48822 .62035 .50737 .6066 .49542 .60231 Mtetra
.703 .82 .937 r
.49542 .60231 .50737 .6066 .52674 .59298 .5148 .58861 Mtetra
.699 .82 .939 r
.5148 .58861 .52674 .59298 .54632 .57942 .53439 .57497 Mtetra
.697 .82 .941 r
.53439 .57497 .54632 .57942 .56612 .5659 .55421 .56136 Mtetra
.694 .82 .943 r
.55421 .56136 .56612 .5659 .58616 .55236 .57426 .54775 Mtetra
.692 .82 .944 r
.57426 .54775 .58616 .55236 .60643 .5388 .59455 .53411 Mtetra
.69 .82 .945 r
.59455 .53411 .60643 .5388 .62694 .52519 .61508 .52041 Mtetra
.689 .82 .946 r
.61508 .52041 .62694 .52519 .6477 .51151 .63586 .50664 Mtetra
.687 .82 .947 r
.63586 .50664 .6477 .51151 .66871 .49774 .65688 .49278 Mtetra
.686 .82 .947 r
.65688 .49278 .66871 .49774 .68998 .48387 .67817 .47883 Mtetra
.685 .82 .948 r
.67817 .47883 .68998 .48387 .71151 .4699 .69972 .46476 Mtetra
.684 .82 .948 r
.69972 .46476 .71151 .4699 .73331 .4558 .72155 .45057 Mtetra
.684 .82 .949 r
.72155 .45057 .73331 .4558 .75538 .44157 .74364 .43624 Mtetra
.683 .82 .949 r
.74364 .43624 .75538 .44157 .77774 .4272 .76602 .42178 Mtetra
.682 .82 .949 r
.76602 .42178 .77774 .4272 .80037 .41269 .78868 .40717 Mtetra
.854 .64 .613 r
.19444 1.11019 .20748 1.11537 .23334 .97099 .22073 .96547 Mtetra
.846 .661 .651 r
.22073 .96547 .23334 .97099 .25472 .88994 .24233 .88422 Mtetra
.834 .682 .694 r
.24233 .88422 .25472 .88994 .27422 .83745 .26195 .83158 Mtetra
.818 .702 .737 r
.26195 .83158 .27422 .83745 .29284 .79977 .28065 .79379 Mtetra
.798 .717 .775 r
.28065 .79379 .29284 .79977 .31105 .77055 .29891 .76447 Mtetra
.779 .729 .806 r
.29891 .76447 .31105 .77055 .32909 .74649 .31698 .74032 Mtetra
.76 .737 .831 r
.31698 .74032 .32909 .74649 .34709 .72575 .335 .7195 Mtetra
.744 .742 .85 r
.335 .7195 .34709 .72575 .36513 .70722 .35306 .70088 Mtetra
.73 .745 .864 r
.35306 .70088 .36513 .70722 .38326 .69021 .3712 .68379 Mtetra
.718 .747 .875 r
.3712 .68379 .38326 .69021 .40153 .67426 .38947 .66776 Mtetra
.709 .748 .883 r
.38947 .66776 .40153 .67426 .41994 .65907 .40789 .65248 Mtetra
.701 .749 .889 r
.40789 .65248 .41994 .65907 .43853 .64441 .42647 .63774 Mtetra
.694 .749 .894 r
.42647 .63774 .43853 .64441 .45729 .63014 .44524 .62339 Mtetra
.689 .75 .898 r
.44524 .62339 .45729 .63014 .47625 .61613 .4642 .6093 Mtetra
.685 .75 .901 r
.4642 .6093 .47625 .61613 .49542 .60231 .48337 .59539 Mtetra
.681 .75 .903 r
.48337 .59539 .49542 .60231 .5148 .58861 .50274 .5816 Mtetra
.678 .75 .905 r
.50274 .5816 .5148 .58861 .53439 .57497 .52234 .56788 Mtetra
.675 .75 .907 r
.52234 .56788 .53439 .57497 .55421 .56136 .54216 .55419 Mtetra
.673 .75 .908 r
.54216 .55419 .55421 .56136 .57426 .54775 .56221 .54048 Mtetra
.671 .75 .909 r
.56221 .54048 .57426 .54775 .59455 .53411 .58249 .52675 Mtetra
.67 .75 .91 r
.58249 .52675 .59455 .53411 .61508 .52041 .60302 .51296 Mtetra
.669 .749 .911 r
.60302 .51296 .61508 .52041 .63586 .50664 .6238 .4991 Mtetra
.667 .749 .912 r
.6238 .4991 .63586 .50664 .65688 .49278 .64483 .48514 Mtetra
.64483 .48514 .65688 .49278 .67817 .47883 .66612 .47109 Mtetra
.666 .749 .913 r
.66612 .47109 .67817 .47883 .69972 .46476 .68768 .45692 Mtetra
.665 .749 .913 r
.68768 .45692 .69972 .46476 .72155 .45057 .70951 .44263 Mtetra
.664 .749 .913 r
.70951 .44263 .72155 .45057 .74364 .43624 .73161 .42821 Mtetra
.664 .749 .914 r
.73161 .42821 .74364 .43624 .76602 .42178 .75399 .41364 Mtetra
.663 .749 .914 r
.75399 .41364 .76602 .42178 .78868 .40717 .77666 .39893 Mtetra
.846 .632 .613 r
.18152 1.10201 .19444 1.11019 .22073 .96547 .20822 .95713 Mtetra
.834 .647 .65 r
.20822 .95713 .22073 .96547 .24233 .88422 .23003 .87577 Mtetra
.816 .661 .69 r
.23003 .87577 .24233 .88422 .26195 .83158 .24976 .82304 Mtetra
.795 .673 .729 r
.24976 .82304 .26195 .83158 .28065 .79379 .26852 .78516 Mtetra
.773 .681 .762 r
.26852 .78516 .28065 .79379 .29891 .76447 .28682 .75576 Mtetra
.752 .686 .788 r
.28682 .75576 .29891 .76447 .31698 .74032 .30491 .73153 Mtetra
.732 .689 .809 r
.30491 .73153 .31698 .74032 .335 .7195 .32294 .71062 Mtetra
.716 .691 .824 r
.32294 .71062 .335 .7195 .35306 .70088 .341 .69192 Mtetra
.703 .691 .836 r
.341 .69192 .35306 .70088 .3712 .68379 .35914 .67475 Mtetra
.691 .691 .845 r
.35914 .67475 .3712 .68379 .38947 .66776 .3774 .65863 Mtetra
.682 .691 .852 r
.3774 .65863 .38947 .66776 .40789 .65248 .39581 .64327 Mtetra
.675 .691 .857 r
.39581 .64327 .40789 .65248 .42647 .63774 .41438 .62845 Mtetra
.669 .69 .861 r
.41438 .62845 .42647 .63774 .44524 .62339 .43314 .614 Mtetra
.664 .69 .864 r
.43314 .614 .44524 .62339 .4642 .6093 .45208 .59983 Mtetra
.66 .689 .867 r
.45208 .59983 .4642 .6093 .48337 .59539 .47123 .58583 Mtetra
.657 .689 .869 r
.47123 .58583 .48337 .59539 .50274 .5816 .4906 .57195 Mtetra
.654 .689 .87 r
.4906 .57195 .50274 .5816 .52234 .56788 .51018 .55814 Mtetra
.652 .689 .871 r
.51018 .55814 .52234 .56788 .54216 .55419 .52998 .54435 Mtetra
.65 .688 .873 r
.52998 .54435 .54216 .55419 .56221 .54048 .55001 .53055 Mtetra
.649 .688 .873 r
.55001 .53055 .56221 .54048 .58249 .52675 .57029 .51672 Mtetra
.647 .688 .874 r
.57029 .51672 .58249 .52675 .60302 .51296 .5908 .50283 Mtetra
.646 .688 .875 r
.5908 .50283 .60302 .51296 .6238 .4991 .61157 .48887 Mtetra
.645 .688 .875 r
.61157 .48887 .6238 .4991 .64483 .48514 .63258 .47482 Mtetra
.644 .687 .876 r
.63258 .47482 .64483 .48514 .66612 .47109 .65386 .46066 Mtetra
.643 .687 .876 r
.65386 .46066 .66612 .47109 .68768 .45692 .6754 .44639 Mtetra
.643 .687 .877 r
.6754 .44639 .68768 .45692 .70951 .44263 .69721 .43199 Mtetra
.642 .687 .877 r
.69721 .43199 .70951 .44263 .73161 .42821 .7193 .41746 Mtetra
.7193 .41746 .73161 .42821 .75399 .41364 .74167 .40278 Mtetra
.641 .687 .877 r
.74167 .40278 .75399 .41364 .77666 .39893 .76433 .38795 Mtetra
.839 .625 .613 r
.16875 1.09084 .18152 1.10201 .20822 .95713 .19584 .94596 Mtetra
.822 .634 .648 r
.19584 .94596 .20822 .95713 .23003 .87577 .21784 .86458 Mtetra
.8 .641 .685 r
.21784 .86458 .23003 .87577 .24976 .82304 .23767 .81181 Mtetra
.775 .646 .72 r
.23767 .81181 .24976 .82304 .26852 .78516 .25648 .77387 Mtetra
.75 .648 .749 r
.25648 .77387 .26852 .78516 .28682 .75576 .2748 .7444 Mtetra
.727 .649 .771 r
.2748 .7444 .28682 .75576 .30491 .73153 .2929 .7201 Mtetra
.707 .648 .788 r
.2929 .7201 .30491 .73153 .32294 .71062 .31093 .69911 Mtetra
.691 .647 .801 r
.31093 .69911 .32294 .71062 .341 .69192 .32897 .68034 Mtetra
.677 .645 .81 r
.32897 .68034 .341 .69192 .35914 .67475 .3471 .66308 Mtetra
.667 .644 .818 r
.3471 .66308 .35914 .67475 .3774 .65863 .36534 .64688 Mtetra
.658 .642 .823 r
.36534 .64688 .3774 .65863 .39581 .64327 .38373 .63143 Mtetra
.651 .641 .827 r
.38373 .63143 .39581 .64327 .41438 .62845 .40228 .61652 Mtetra
.646 .64 .83 r
.40228 .61652 .41438 .62845 .43314 .614 .42101 .60199 Mtetra
.641 .639 .833 r
.42101 .60199 .43314 .614 .45208 .59983 .43993 .58772 Mtetra
.637 .639 .835 r
.43993 .58772 .45208 .59983 .47123 .58583 .45905 .57363 Mtetra
.634 .638 .836 r
.45905 .57363 .47123 .58583 .4906 .57195 .47839 .55965 Mtetra
.632 .637 .838 r
.47839 .55965 .4906 .57195 .51018 .55814 .49794 .54574 Mtetra
.63 .637 .839 r
.49794 .54574 .51018 .55814 .52998 .54435 .51771 .53185 Mtetra
.628 .637 .84 r
.51771 .53185 .52998 .54435 .55001 .53055 .53772 .51795 Mtetra
.627 .636 .84 r
.53772 .51795 .55001 .53055 .57029 .51672 .55796 .50402 Mtetra
.625 .636 .841 r
.55796 .50402 .57029 .51672 .5908 .50283 .57844 .49003 Mtetra
.624 .636 .842 r
.57844 .49003 .5908 .50283 .61157 .48887 .59917 .47596 Mtetra
.623 .636 .842 r
.59917 .47596 .61157 .48887 .63258 .47482 .62016 .4618 Mtetra
.623 .635 .842 r
.62016 .4618 .63258 .47482 .65386 .46066 .64141 .44753 Mtetra
.622 .635 .843 r
.64141 .44753 .65386 .46066 .6754 .44639 .66292 .43315 Mtetra
.621 .635 .843 r
.66292 .43315 .6754 .44639 .69721 .43199 .6847 .41864 Mtetra
.6847 .41864 .69721 .43199 .7193 .41746 .70676 .40399 Mtetra
.62 .635 .843 r
.70676 .40399 .7193 .41746 .74167 .40278 .72909 .38919 Mtetra
.72909 .38919 .74167 .40278 .76433 .38795 .75172 .37424 Mtetra
.832 .617 .613 r
.15615 1.07667 .16875 1.09084 .19584 .94596 .18361 .93199 Mtetra
.81 .621 .646 r
.18361 .93199 .19584 .94596 .21784 .86458 .20578 .85067 Mtetra
.784 .623 .681 r
.20578 .85067 .21784 .86458 .23767 .81181 .2257 .7979 Mtetra
.756 .622 .711 r
.2257 .7979 .23767 .81181 .25648 .77387 .24456 .75993 Mtetra
.729 .619 .736 r
.24456 .75993 .25648 .77387 .2748 .7444 .26289 .73041 Mtetra
.705 .616 .755 r
.26289 .73041 .2748 .7444 .2929 .7201 .28098 .70605 Mtetra
.684 .612 .769 r
.28098 .70605 .2929 .7201 .31093 .69911 .29899 .68499 Mtetra
.668 .609 .78 r
.29899 .68499 .31093 .69911 .32897 .68034 .31702 .66614 Mtetra
.655 .606 .787 r
.31702 .66614 .32897 .68034 .3471 .66308 .33512 .6488 Mtetra
.645 .603 .793 r
.33512 .6488 .3471 .66308 .36534 .64688 .35333 .63251 Mtetra
.636 .601 .797 r
.35333 .63251 .36534 .64688 .38373 .63143 .37168 .61698 Mtetra
.63 .599 .801 r
.37168 .61698 .38373 .63143 .40228 .61652 .39019 .60197 Mtetra
.625 .598 .803 r
.39019 .60197 .40228 .61652 .42101 .60199 .40888 .58734 Mtetra
.62 .597 .805 r
.40888 .58734 .42101 .60199 .43993 .58772 .42776 .57298 Mtetra
.617 .596 .807 r
.42776 .57298 .43993 .58772 .45905 .57363 .44685 .55879 Mtetra
.614 .595 .808 r
.44685 .55879 .45905 .57363 .47839 .55965 .46613 .54471 Mtetra
.612 .594 .809 r
.46613 .54471 .47839 .55965 .49794 .54574 .48564 .5307 Mtetra
.61 .594 .81 r
.48564 .5307 .49794 .54574 .51771 .53185 .50537 .5167 Mtetra
.608 .593 .811 r
.50537 .5167 .51771 .53185 .53772 .51795 .52533 .5027 Mtetra
.607 .593 .811 r
.52533 .5027 .53772 .51795 .55796 .50402 .54553 .48866 Mtetra
.606 .593 .812 r
.54553 .48866 .55796 .50402 .57844 .49003 .56597 .47455 Mtetra
.605 .592 .812 r
.56597 .47455 .57844 .49003 .59917 .47596 .58665 .46037 Mtetra
.604 .592 .812 r
.58665 .46037 .59917 .47596 .62016 .4618 .60759 .4461 Mtetra
.603 .592 .813 r
.60759 .4461 .62016 .4618 .64141 .44753 .62879 .43172 Mtetra
.62879 .43172 .64141 .44753 .66292 .43315 .65025 .41721 Mtetra
.602 .591 .813 r
.65025 .41721 .66292 .43315 .6847 .41864 .67198 .40258 Mtetra
.67198 .40258 .6847 .41864 .70676 .40399 .69399 .38781 Mtetra
.601 .591 .813 r
.69399 .38781 .70676 .40399 .72909 .38919 .71628 .3729 Mtetra
.601 .591 .814 r
.71628 .3729 .72909 .38919 .75172 .37424 .73886 .35782 Mtetra
.825 .61 .612 r
.14376 1.05952 .15615 1.07667 .18361 .93199 .17156 .91521 Mtetra
.799 .609 .644 r
.17156 .91521 .18361 .93199 .20578 .85067 .19389 .83404 Mtetra
.769 .605 .676 r
.19389 .83404 .20578 .85067 .2257 .7979 .21388 .78133 Mtetra
.738 .6 .703 r
.21388 .78133 .2257 .7979 .24456 .75993 .23276 .74336 Mtetra
.709 .593 .724 r
.23276 .74336 .24456 .75993 .26289 .73041 .2511 .71381 Mtetra
.684 .587 .74 r
.2511 .71381 .26289 .73041 .28098 .70605 .26917 .68939 Mtetra
.664 .581 .752 r
.26917 .68939 .28098 .70605 .29899 .68499 .28716 .66827 Mtetra
.648 .576 .76 r
.28716 .66827 .29899 .68499 .31702 .66614 .30515 .64935 Mtetra
.635 .572 .767 r
.30515 .64935 .31702 .66614 .33512 .6488 .32321 .63192 Mtetra
.625 .569 .771 r
.32321 .63192 .33512 .6488 .35333 .63251 .34137 .61555 Mtetra
.617 .566 .775 r
.34137 .61555 .35333 .63251 .37168 .61698 .35968 .59992 Mtetra
.611 .564 .777 r
.35968 .59992 .37168 .61698 .39019 .60197 .37814 .58482 Mtetra
.606 .562 .779 r
.37814 .58482 .39019 .60197 .40888 .58734 .39678 .5701 Mtetra
.602 .561 .781 r
.39678 .5701 .40888 .58734 .42776 .57298 .41561 .55563 Mtetra
.599 .56 .782 r
.41561 .55563 .42776 .57298 .44685 .55879 .43464 .54134 Mtetra
.596 .559 .783 r
.43464 .54134 .44685 .55879 .46613 .54471 .45387 .52716 Mtetra
.594 .558 .784 r
.45387 .52716 .46613 .54471 .48564 .5307 .47332 .51303 Mtetra
.592 .557 .785 r
.47332 .51303 .48564 .5307 .50537 .5167 .49299 .49893 Mtetra
.59 .557 .785 r
.49299 .49893 .50537 .5167 .52533 .5027 .51289 .48481 Mtetra
.589 .556 .786 r
.51289 .48481 .52533 .5027 .54553 .48866 .53303 .47065 Mtetra
.588 .556 .786 r
.53303 .47065 .54553 .48866 .56597 .47455 .5534 .45644 Mtetra
.587 .556 .786 r
.5534 .45644 .56597 .47455 .58665 .46037 .57403 .44214 Mtetra
.586 .555 .787 r
.57403 .44214 .58665 .46037 .60759 .4461 .5949 .42774 Mtetra
.5949 .42774 .60759 .4461 .62879 .43172 .61604 .41324 Mtetra
.585 .555 .787 r
.61604 .41324 .62879 .43172 .65025 .41721 .63743 .39861 Mtetra
.63743 .39861 .65025 .41721 .67198 .40258 .6591 .38386 Mtetra
.584 .555 .787 r
.6591 .38386 .67198 .40258 .69399 .38781 .68104 .36896 Mtetra
.584 .555 .788 r
.68104 .36896 .69399 .38781 .71628 .3729 .70326 .35391 Mtetra
.584 .554 .788 r
.70326 .35391 .71628 .3729 .73886 .35782 .72577 .33871 Mtetra
.818 .603 .612 r
.1316 1.03943 .14376 1.05952 .17156 .91521 .15972 .89566 Mtetra
.789 .597 .642 r
.15972 .89566 .17156 .91521 .19389 .83404 .18219 .81474 Mtetra
.755 .589 .671 r
.18219 .81474 .19389 .83404 .21388 .78133 .20224 .76212 Mtetra
.722 .58 .695 r
.20224 .76212 .21388 .78133 .23276 .74336 .22113 .72418 Mtetra
.692 .57 .714 r
.22113 .72418 .23276 .74336 .2511 .71381 .23945 .69462 Mtetra
.666 .561 .727 r
.23945 .69462 .2511 .71381 .26917 .68939 .2575 .67016 Mtetra
.646 .554 .736 r
.2575 .67016 .26917 .68939 .28716 .66827 .27545 .64898 Mtetra
.63 .548 .743 r
.27545 .64898 .28716 .66827 .30515 .64935 .29339 .62999 Mtetra
.618 .543 .748 r
.29339 .62999 .30515 .64935 .32321 .63192 .3114 .61248 Mtetra
.608 .539 .752 r
.3114 .61248 .32321 .63192 .34137 .61555 .32951 .59603 Mtetra
.6 .536 .755 r
.32951 .59603 .34137 .61555 .35968 .59992 .34776 .58031 Mtetra
.594 .534 .757 r
.34776 .58031 .35968 .59992 .37814 .58482 .36616 .56511 Mtetra
.589 .532 .758 r
.36616 .56511 .37814 .58482 .39678 .5701 .38474 .55028 Mtetra
.586 .53 .76 r
.38474 .55028 .39678 .5701 .41561 .55563 .4035 .53571 Mtetra
.582 .529 .761 r
.4035 .53571 .41561 .55563 .43464 .54134 .42245 .52131 Mtetra
.58 .528 .761 r
.42245 .52131 .43464 .54134 .45387 .52716 .44162 .50702 Mtetra
.578 .527 .762 r
.44162 .50702 .45387 .52716 .47332 .51303 .461 .49278 Mtetra
.576 .527 .763 r
.461 .49278 .47332 .51303 .49299 .49893 .48059 .47856 Mtetra
.575 .526 .763 r
.48059 .47856 .49299 .49893 .51289 .48481 .50042 .46433 Mtetra
.574 .526 .763 r
.50042 .46433 .51289 .48481 .53303 .47065 .52048 .45005 Mtetra
.573 .525 .764 r
.52048 .45005 .53303 .47065 .5534 .45644 .54078 .43571 Mtetra
.572 .525 .764 r
.54078 .43571 .5534 .45644 .57403 .44214 .56133 .42129 Mtetra
.571 .524 .764 r
.56133 .42129 .57403 .44214 .5949 .42774 .58212 .40677 Mtetra
.57 .524 .764 r
.58212 .40677 .5949 .42774 .61604 .41324 .60317 .39214 Mtetra
.57 .524 .765 r
.60317 .39214 .61604 .41324 .63743 .39861 .62449 .37738 Mtetra
.569 .524 .765 r
.62449 .37738 .63743 .39861 .6591 .38386 .64607 .3625 Mtetra
.64607 .3625 .6591 .38386 .68104 .36896 .66793 .34746 Mtetra
.569 .523 .765 r
.66793 .34746 .68104 .36896 .70326 .35391 .69007 .33228 Mtetra
.568 .523 .765 r
.69007 .33228 .70326 .35391 .72577 .33871 .71249 .31694 Mtetra
.811 .596 .611 r
.1197 1.01643 .1316 1.03943 .15972 .89566 .14811 .87339 Mtetra
.778 .586 .64 r
.14811 .87339 .15972 .89566 .18219 .81474 .1707 .79279 Mtetra
.742 .574 .666 r
.1707 .79279 .18219 .81474 .20224 .76212 .19079 .74032 Mtetra
.706 .561 .688 r
.19079 .74032 .20224 .76212 .22113 .72418 .20968 .70245 Mtetra
.675 .549 .703 r
.20968 .70245 .22113 .72418 .23945 .69462 .22798 .67288 Mtetra
.65 .539 .715 r
.22798 .67288 .23945 .69462 .2575 .67016 .24599 .6484 Mtetra
.63 .53 .722 r
.24599 .6484 .2575 .67016 .27545 .64898 .26389 .62717 Mtetra
.614 .523 .728 r
.26389 .62717 .27545 .64898 .29339 .62999 .28178 .6081 Mtetra
.602 .518 .732 r
.28178 .6081 .29339 .62999 .3114 .61248 .29972 .59052 Mtetra
.592 .514 .735 r
.29972 .59052 .3114 .61248 .32951 .59603 .31776 .57398 Mtetra
.585 .51 .737 r
.31776 .57398 .32951 .59603 .34776 .58031 .33594 .55816 Mtetra
.579 .508 .739 r
.33594 .55816 .34776 .58031 .36616 .56511 .35427 .54286 Mtetra
.575 .506 .74 r
.35427 .54286 .36616 .56511 .38474 .55028 .37276 .52793 Mtetra
.571 .504 .741 r
.37276 .52793 .38474 .55028 .4035 .53571 .39145 .51325 Mtetra
.568 .503 .742 r
.39145 .51325 .4035 .53571 .42245 .52131 .41032 .49874 Mtetra
.566 .502 .742 r
.41032 .49874 .42245 .52131 .44162 .50702 .4294 .48433 Mtetra
.564 .501 .743 r
.4294 .48433 .44162 .50702 .461 .49278 .4487 .46998 Mtetra
.562 .5 .743 r
.4487 .46998 .461 .49278 .48059 .47856 .46821 .45564 Mtetra
.561 .499 .744 r
.46821 .45564 .48059 .47856 .50042 .46433 .48795 .44129 Mtetra
.56 .499 .744 r
.48795 .44129 .50042 .46433 .52048 .45005 .50792 .42689 Mtetra
.559 .499 .744 r
.50792 .42689 .52048 .45005 .54078 .43571 .52812 .41242 Mtetra
.558 .498 .744 r
.52812 .41242 .54078 .43571 .56133 .42129 .54858 .39787 Mtetra
.557 .498 .745 r
.54858 .39787 .56133 .42129 .58212 .40677 .56928 .38322 Mtetra
.56928 .38322 .58212 .40677 .60317 .39214 .59023 .36846 Mtetra
.556 .497 .745 r
.59023 .36846 .60317 .39214 .62449 .37738 .61145 .35357 Mtetra
.61145 .35357 .62449 .37738 .64607 .3625 .63293 .33855 Mtetra
.555 .497 .745 r
.63293 .33855 .64607 .3625 .66793 .34746 .65469 .32338 Mtetra
.65469 .32338 .66793 .34746 .69007 .33228 .67672 .30806 Mtetra
.67672 .30806 .69007 .33228 .71249 .31694 .69904 .29257 Mtetra
.804 .589 .611 r
.10807 .99058 .1197 1.01643 .14811 .87339 .13675 .84843 Mtetra
.768 .576 .638 r
.13675 .84843 .14811 .87339 .1707 .79279 .15945 .76825 Mtetra
.729 .56 .662 r
.15945 .76825 .1707 .79279 .19079 .74032 .17956 .71599 Mtetra
.692 .544 .68 r
.17956 .71599 .19079 .74032 .20968 .70245 .19844 .67819 Mtetra
.661 .53 .694 r
.19844 .67819 .20968 .70245 .22798 .67288 .2167 .64865 Mtetra
.635 .518 .703 r
.2167 .64865 .22798 .67288 .24599 .6484 .23466 .62415 Mtetra
.615 .509 .71 r
.23466 .62415 .24599 .6484 .26389 .62717 .2525 .60287 Mtetra
.6 .501 .714 r
.2525 .60287 .26389 .62717 .28178 .6081 .27032 .58374 Mtetra
.588 .496 .717 r
.27032 .58374 .28178 .6081 .29972 .59052 .28819 .56609 Mtetra
.579 .491 .72 r
.28819 .56609 .29972 .59052 .31776 .57398 .30615 .54945 Mtetra
.572 .488 .721 r
.30615 .54945 .31776 .57398 .33594 .55816 .32424 .53354 Mtetra
.566 .485 .723 r
.32424 .53354 .33594 .55816 .35427 .54286 .34249 .51814 Mtetra
.562 .483 .724 r
.34249 .51814 .35427 .54286 .37276 .52793 .3609 .50311 Mtetra
.558 .481 .725 r
.3609 .50311 .37276 .52793 .39145 .51325 .37949 .48832 Mtetra
.555 .48 .725 r
.37949 .48832 .39145 .51325 .41032 .49874 .39827 .47369 Mtetra
.553 .479 .726 r
.39827 .47369 .41032 .49874 .4294 .48433 .41725 .45917 Mtetra
.551 .478 .726 r
.41725 .45917 .4294 .48433 .4487 .46998 .43645 .44469 Mtetra
.55 .477 .726 r
.43645 .44469 .4487 .46998 .46821 .45564 .45586 .43023 Mtetra
.548 .476 .727 r
.45586 .43023 .46821 .45564 .48795 .44129 .4755 .41575 Mtetra
.547 .476 .727 r
.4755 .41575 .48795 .44129 .50792 .42689 .49536 .40122 Mtetra
.546 .476 .727 r
.49536 .40122 .50792 .42689 .52812 .41242 .51546 .38662 Mtetra
.546 .475 .727 r
.51546 .38662 .52812 .41242 .54858 .39787 .53581 .37194 Mtetra
.545 .475 .727 r
.53581 .37194 .54858 .39787 .56928 .38322 .5564 .35716 Mtetra
.544 .475 .728 r
.5564 .35716 .56928 .38322 .59023 .36846 .57724 .34226 Mtetra
.544 .474 .728 r
.57724 .34226 .59023 .36846 .61145 .35357 .59835 .32723 Mtetra
.59835 .32723 .61145 .35357 .63293 .33855 .61971 .31207 Mtetra
.543 .474 .728 r
.61971 .31207 .63293 .33855 .65469 .32338 .64135 .29676 Mtetra
.64135 .29676 .65469 .32338 .67672 .30806 .66326 .28129 Mtetra
.66326 .28129 .67672 .30806 .69904 .29257 .68546 .26566 Mtetra
.798 .583 .61 r
.09675 .96196 .10807 .99058 .13675 .84843 .12567 .82087 Mtetra
.759 .566 .635 r
.12567 .82087 .13675 .84843 .15945 .76825 .14845 .74119 Mtetra
.718 .547 .657 r
.14845 .74119 .15945 .76825 .17956 .71599 .16858 .68916 Mtetra
.679 .528 .674 r
.16858 .68916 .17956 .71599 .19844 .67819 .18743 .65149 Mtetra
.647 .512 .685 r
.18743 .65149 .19844 .67819 .2167 .64865 .20564 .62198 Mtetra
.622 .5 .693 r
.20564 .62198 .2167 .64865 .23466 .62415 .22354 .59747 Mtetra
.602 .49 .698 r
.22354 .59747 .23466 .62415 .2525 .60287 .2413 .57616 Mtetra
.587 .482 .702 r
.2413 .57616 .2525 .60287 .27032 .58374 .25904 .55697 Mtetra
.575 .476 .704 r
.25904 .55697 .27032 .58374 .28819 .56609 .27683 .53924 Mtetra
.566 .471 .706 r
.27683 .53924 .28819 .56609 .30615 .54945 .2947 .52252 Mtetra
.559 .468 .708 r
.2947 .52252 .30615 .54945 .32424 .53354 .3127 .50651 Mtetra
.554 .465 .709 r
.3127 .50651 .32424 .53354 .34249 .51814 .33084 .49101 Mtetra
.55 .463 .709 r
.33084 .49101 .34249 .51814 .3609 .50311 .34915 .47586 Mtetra
.547 .461 .71 r
.34915 .47586 .3609 .50311 .37949 .48832 .36764 .46096 Mtetra
.544 .46 .71 r
.36764 .46096 .37949 .48832 .39827 .47369 .38632 .44622 Mtetra
.542 .459 .711 r
.38632 .44622 .39827 .47369 .41725 .45917 .40519 .43157 Mtetra
.54 .458 .711 r
.40519 .43157 .41725 .45917 .43645 .44469 .42428 .41698 Mtetra
.538 .457 .711 r
.42428 .41698 .43645 .44469 .45586 .43023 .44358 .40239 Mtetra
.537 .456 .712 r
.44358 .40239 .45586 .43023 .4755 .41575 .4631 .38778 Mtetra
.536 .456 .712 r
.4631 .38778 .4755 .41575 .49536 .40122 .48284 .37312 Mtetra
.535 .455 .712 r
.48284 .37312 .49536 .40122 .51546 .38662 .50283 .35839 Mtetra
.50283 .35839 .51546 .38662 .53581 .37194 .52305 .34357 Mtetra
.534 .455 .712 r
.52305 .34357 .53581 .37194 .5564 .35716 .54351 .32865 Mtetra
.534 .454 .712 r
.54351 .32865 .5564 .35716 .57724 .34226 .56423 .31361 Mtetra
.533 .454 .712 r
.56423 .31361 .57724 .34226 .59835 .32723 .5852 .29844 Mtetra
.533 .454 .713 r
.5852 .29844 .59835 .32723 .61971 .31207 .60644 .28314 Mtetra
.532 .454 .713 r
.60644 .28314 .61971 .31207 .64135 .29676 .62794 .26768 Mtetra
.62794 .26768 .64135 .29676 .66326 .28129 .64972 .25207 Mtetra
.64972 .25207 .66326 .28129 .68546 .26566 .67177 .23629 Mtetra
.792 .576 .609 r
.08575 .93063 .09675 .96196 .12567 .82087 .11488 .79077 Mtetra
.75 .556 .633 r
.11488 .79077 .12567 .82087 .14845 .74119 .13772 .71166 Mtetra
.706 .534 .653 r
.13772 .71166 .14845 .74119 .16858 .68916 .15785 .65993 Mtetra
.667 .514 .667 r
.15785 .65993 .16858 .68916 .18743 .65149 .17667 .62239 Mtetra
.635 .497 .677 r
.17667 .62239 .18743 .65149 .20564 .62198 .19482 .59295 Mtetra
.609 .483 .683 r
.19482 .59295 .20564 .62198 .22354 .59747 .21264 .56844 Mtetra
.59 .472 .688 r
.21264 .56844 .22354 .59747 .2413 .57616 .23032 .54709 Mtetra
.575 .464 .69 r
.23032 .54709 .2413 .57616 .25904 .55697 .24797 .52785 Mtetra
.564 .458 .692 r
.24797 .52785 .25904 .55697 .27683 .53924 .26566 .51004 Mtetra
.555 .454 .694 r
.26566 .51004 .27683 .53924 .2947 .52252 .28343 .49324 Mtetra
.549 .45 .695 r
.28343 .49324 .2947 .52252 .3127 .50651 .30132 .47714 Mtetra
.543 .447 .696 r
.30132 .47714 .3127 .50651 .33084 .49101 .31936 .46154 Mtetra
.539 .445 .696 r
.31936 .46154 .33084 .49101 .34915 .47586 .33756 .44628 Mtetra
.536 .443 .697 r
.33756 .44628 .34915 .47586 .36764 .46096 .35593 .43126 Mtetra
.534 .442 .697 r
.35593 .43126 .36764 .46096 .38632 .44622 .37449 .4164 Mtetra
.531 .441 .698 r
.37449 .4164 .38632 .44622 .40519 .43157 .39325 .40163 Mtetra
.53 .44 .698 r
.39325 .40163 .40519 .43157 .42428 .41698 .41221 .38691 Mtetra
.528 .439 .698 r
.41221 .38691 .42428 .41698 .44358 .40239 .43138 .3722 Mtetra
.527 .439 .698 r
.43138 .3722 .44358 .40239 .4631 .38778 .45077 .35745 Mtetra
.526 .438 .698 r
.45077 .35745 .4631 .38778 .48284 .37312 .47039 .34266 Mtetra
.525 .438 .699 r
.47039 .34266 .48284 .37312 .50283 .35839 .49024 .32779 Mtetra
.525 .437 .699 r
.49024 .32779 .50283 .35839 .52305 .34357 .51032 .31284 Mtetra
.524 .437 .699 r
.51032 .31284 .52305 .34357 .54351 .32865 .53065 .29778 Mtetra
.53065 .29778 .54351 .32865 .56423 .31361 .55123 .28259 Mtetra
.523 .436 .699 r
.55123 .28259 .56423 .31361 .5852 .29844 .57206 .26728 Mtetra
.57206 .26728 .5852 .29844 .60644 .28314 .59314 .25183 Mtetra
.59314 .25183 .60644 .28314 .62794 .26768 .6145 .23623 Mtetra
.522 .436 .699 r
.6145 .23623 .62794 .26768 .64972 .25207 .63612 .22047 Mtetra
.63612 .22047 .64972 .25207 .67177 .23629 .65802 .20454 Mtetra
.785 .57 .608 r
.0751 .89668 .08575 .93063 .11488 .79077 .10441 .7582 Mtetra
.741 .547 .631 r
.10441 .7582 .11488 .79077 .13772 .71166 .1273 .67976 Mtetra
.696 .522 .649 r
.1273 .67976 .13772 .71166 .15785 .65993 .14741 .62836 Mtetra
.656 .5 .661 r
.14741 .62836 .15785 .65993 .17667 .62239 .16617 .59099 Mtetra
.623 .482 .669 r
.16617 .59099 .17667 .62239 .19482 .59295 .18425 .56162 Mtetra
.598 .468 .674 r
.18425 .56162 .19482 .59295 .21264 .56844 .20199 .53713 Mtetra
.579 .457 .678 r
.20199 .53713 .21264 .56844 .23032 .54709 .21958 .51576 Mtetra
.564 .449 .68 r
.21958 .51576 .23032 .54709 .24797 .52785 .23713 .49646 Mtetra
.553 .442 .682 r
.23713 .49646 .24797 .52785 .26566 .51004 .25471 .47859 Mtetra
.545 .438 .683 r
.25471 .47859 .26566 .51004 .28343 .49324 .27237 .4617 Mtetra
.539 .434 .684 r
.27237 .4617 .28343 .49324 .30132 .47714 .29014 .44551 Mtetra
.534 .431 .684 r
.29014 .44551 .30132 .47714 .31936 .46154 .30806 .4298 Mtetra
.53 .429 .685 r
.30806 .4298 .31936 .46154 .33756 .44628 .32614 .41443 Mtetra
.527 .427 .685 r
.32614 .41443 .33756 .44628 .35593 .43126 .34438 .3993 Mtetra
.524 .426 .685 r
.34438 .3993 .35593 .43126 .37449 .4164 .36281 .38432 Mtetra
.522 .425 .686 r
.36281 .38432 .37449 .4164 .39325 .40163 .38144 .36943 Mtetra
.521 .424 .686 r
.38144 .36943 .39325 .40163 .41221 .38691 .40026 .35458 Mtetra
.519 .423 .686 r
.40026 .35458 .41221 .38691 .43138 .3722 .4193 .33973 Mtetra
.518 .423 .686 r
.4193 .33973 .43138 .3722 .45077 .35745 .43855 .32486 Mtetra
.517 .422 .686 r
.43855 .32486 .45077 .35745 .47039 .34266 .45802 .30993 Mtetra
.516 .422 .686 r
.45802 .30993 .47039 .34266 .49024 .32779 .47773 .29492 Mtetra
.516 .421 .687 r
.47773 .29492 .49024 .32779 .51032 .31284 .49766 .27983 Mtetra
.515 .421 .687 r
.49766 .27983 .51032 .31284 .53065 .29778 .51784 .26462 Mtetra
.51784 .26462 .53065 .29778 .55123 .28259 .53826 .2493 Mtetra
.514 .42 .687 r
.53826 .2493 .55123 .28259 .57206 .26728 .55893 .23384 Mtetra
.55893 .23384 .57206 .26728 .59314 .25183 .57986 .21824 Mtetra
.57986 .21824 .59314 .25183 .6145 .23623 .60105 .20249 Mtetra
.513 .42 .687 r
.60105 .20249 .6145 .23623 .63612 .22047 .6225 .18658 Mtetra
.6225 .18658 .63612 .22047 .65802 .20454 .64423 .1705 Mtetra
.779 .564 .608 r
.06482 .86023 .0751 .89668 .10441 .7582 .09427 .72327 Mtetra
.733 .538 .628 r
.09427 .72327 .10441 .7582 .1273 .67976 .11718 .64556 Mtetra
.686 .511 .644 r
.11718 .64556 .1273 .67976 .14741 .62836 .13726 .59454 Mtetra
.645 .487 .655 r
.13726 .59454 .14741 .62836 .16617 .59099 .15596 .55737 Mtetra
.612 .468 .662 r
.15596 .55737 .16617 .59099 .18425 .56162 .17396 .52809 Mtetra
.587 .454 .666 r
.17396 .52809 .18425 .56162 .20199 .53713 .19161 .50362 Mtetra
.568 .443 .669 r
.19161 .50362 .20199 .53713 .21958 .51576 .20909 .48224 Mtetra
.554 .434 .671 r
.20909 .48224 .21958 .51576 .23713 .49646 .22652 .4629 Mtetra
.544 .428 .672 r
.22652 .4629 .23713 .49646 .25471 .47859 .24399 .44496 Mtetra
.536 .423 .673 r
.24399 .44496 .25471 .47859 .27237 .4617 .26153 .42799 Mtetra
.529 .42 .673 r
.26153 .42799 .27237 .4617 .29014 .44551 .27918 .4117 Mtetra
.525 .417 .674 r
.27918 .4117 .29014 .44551 .30806 .4298 .29697 .39589 Mtetra
.521 .415 .674 r
.29697 .39589 .30806 .4298 .32614 .41443 .31491 .38042 Mtetra
.518 .413 .675 r
.31491 .38042 .32614 .41443 .34438 .3993 .33302 .36517 Mtetra
.516 .412 .675 r
.33302 .36517 .34438 .3993 .36281 .38432 .35131 .35007 Mtetra
.514 .411 .675 r
.35131 .35007 .36281 .38432 .38144 .36943 .36979 .33505 Mtetra
.512 .41 .675 r
.36979 .33505 .38144 .36943 .40026 .35458 .38847 .32007 Mtetra
.511 .409 .675 r
.38847 .32007 .40026 .35458 .4193 .33973 .40736 .3051 Mtetra
.51 .408 .675 r
.40736 .3051 .4193 .33973 .43855 .32486 .42646 .29009 Mtetra
.509 .408 .675 r
.42646 .29009 .43855 .32486 .45802 .30993 .44577 .27502 Mtetra
.508 .407 .675 r
.44577 .27502 .45802 .30993 .47773 .29492 .46532 .25988 Mtetra
.507 .407 .676 r
.46532 .25988 .47773 .29492 .49766 .27983 .48509 .24464 Mtetra
.48509 .24464 .49766 .27983 .51784 .26462 .5051 .22929 Mtetra
.506 .406 .676 r
.5051 .22929 .51784 .26462 .53826 .2493 .52535 .21383 Mtetra
.52535 .21383 .53826 .2493 .55893 .23384 .54585 .19822 Mtetra
.54585 .19822 .55893 .23384 .57986 .21824 .56661 .18247 Mtetra
.505 .406 .676 r
.56661 .18247 .57986 .21824 .60105 .20249 .58762 .16657 Mtetra
.58762 .16657 .60105 .20249 .6225 .18658 .60889 .15051 Mtetra
.60889 .15051 .6225 .18658 .64423 .1705 .63043 .13428 Mtetra
.774 .558 .607 r
.05491 .82136 .06482 .86023 .09427 .72327 .08448 .68608 Mtetra
.725 .529 .626 r
.08448 .68608 .09427 .72327 .11718 .64556 .1074 .60917 Mtetra
.676 .5 .64 r
.1074 .60917 .11718 .64556 .13726 .59454 .12743 .55857 Mtetra
.635 .476 .65 r
.12743 .55857 .13726 .59454 .15596 .55737 .14606 .52162 Mtetra
.602 .456 .655 r
.14606 .52162 .15596 .55737 .17396 .52809 .16397 .49245 Mtetra
.577 .441 .659 r
.16397 .49245 .17396 .52809 .19161 .50362 .1815 .46802 Mtetra
.559 .43 .661 r
.1815 .46802 .19161 .50362 .20909 .48224 .19887 .44662 Mtetra
.545 .421 .662 r
.19887 .44662 .20909 .48224 .22652 .4629 .21618 .42724 Mtetra
.535 .415 .663 r
.21618 .42724 .22652 .4629 .24399 .44496 .23352 .40924 Mtetra
.527 .41 .664 r
.23352 .40924 .24399 .44496 .26153 .42799 .25093 .39219 Mtetra
.521 .407 .664 r
.25093 .39219 .26153 .42799 .27918 .4117 .26845 .37581 Mtetra
.516 .404 .664 r
.26845 .37581 .27918 .4117 .29697 .39589 .28609 .3599 Mtetra
.513 .402 .665 r
.28609 .3599 .29697 .39589 .31491 .38042 .30389 .34432 Mtetra
.51 .4 .665 r
.30389 .34432 .31491 .38042 .33302 .36517 .32186 .32896 Mtetra
.508 .399 .665 r
.32186 .32896 .33302 .36517 .35131 .35007 .34 .31374 Mtetra
.506 .398 .665 r
.34 .31374 .35131 .35007 .36979 .33505 .35833 .2986 Mtetra
.504 .397 .665 r
.35833 .2986 .36979 .33505 .38847 .32007 .37685 .28349 Mtetra
.503 .396 .665 r
.37685 .28349 .38847 .32007 .40736 .3051 .39558 .26838 Mtetra
.502 .395 .665 r
.39558 .26838 .40736 .3051 .42646 .29009 .41451 .25324 Mtetra
.501 .395 .666 r
.41451 .25324 .42646 .29009 .44577 .27502 .43366 .23804 Mtetra
.5 .394 .666 r
.43366 .23804 .44577 .27502 .46532 .25988 .45304 .22276 Mtetra
.45304 .22276 .46532 .25988 .48509 .24464 .47264 .20738 Mtetra
.499 .394 .666 r
.47264 .20738 .48509 .24464 .5051 .22929 .49247 .19189 Mtetra
.49247 .19189 .5051 .22929 .52535 .21383 .51254 .17628 Mtetra
.498 .393 .666 r
.51254 .17628 .52535 .21383 .54585 .19822 .53286 .16053 Mtetra
.53286 .16053 .54585 .19822 .56661 .18247 .55342 .14463 Mtetra
.55342 .14463 .56661 .18247 .58762 .16657 .57424 .12858 Mtetra
.57424 .12858 .58762 .16657 .60889 .15051 .59531 .11237 Mtetra
.497 .393 .666 r
.59531 .11237 .60889 .15051 .63043 .13428 .61666 .09598 Mtetra
.768 .552 .606 r
.0454 .78021 .05491 .82136 .08448 .68608 .07506 .64672 Mtetra
.717 .521 .624 r
.07506 .64672 .08448 .68608 .1074 .60917 .09796 .57068 Mtetra
.667 .49 .636 r
.09796 .57068 .1074 .60917 .12743 .55857 .11793 .52055 Mtetra
.625 .464 .644 r
.11793 .52055 .12743 .55857 .14606 .52162 .13647 .48384 Mtetra
.593 .444 .649 r
.13647 .48384 .14606 .52162 .16397 .49245 .15427 .4548 Mtetra
.568 .429 .651 r
.15427 .4548 .16397 .49245 .1815 .46802 .1717 .43041 Mtetra
.55 .418 .653 r
.1717 .43041 .1815 .46802 .19887 .44662 .18894 .40902 Mtetra
.537 .409 .654 r
.18894 .40902 .19887 .44662 .21618 .42724 .20613 .38961 Mtetra
.527 .403 .655 r
.20613 .38961 .21618 .42724 .23352 .40924 .22333 .37155 Mtetra
.519 .398 .655 r
.22333 .37155 .23352 .40924 .25093 .39219 .2406 .35442 Mtetra
.513 .395 .655 r
.2406 .35442 .25093 .39219 .26845 .37581 .25797 .33795 Mtetra
.509 .392 .656 r
.25797 .33795 .26845 .37581 .28609 .3599 .27547 .32195 Mtetra
.505 .39 .656 r
.27547 .32195 .28609 .3599 .30389 .34432 .29311 .30626 Mtetra
.502 .388 .656 r
.29311 .30626 .30389 .34432 .32186 .32896 .31092 .29078 Mtetra
.5 .387 .656 r
.31092 .29078 .32186 .32896 .34 .31374 .3289 .27544 Mtetra
.498 .386 .656 r
.3289 .27544 .34 .31374 .35833 .2986 .34707 .26018 Mtetra
.497 .385 .656 r
.34707 .26018 .35833 .2986 .37685 .28349 .36542 .24495 Mtetra
.496 .384 .656 r
.36542 .24495 .37685 .28349 .39558 .26838 .38398 .22971 Mtetra
.495 .383 .656 r
.38398 .22971 .39558 .26838 .41451 .25324 .40274 .21443 Mtetra
.494 .383 .656 r
.40274 .21443 .41451 .25324 .43366 .23804 .42172 .19909 Mtetra
.493 .383 .656 r
.42172 .19909 .43366 .23804 .45304 .22276 .44091 .18367 Mtetra
.493 .382 .657 r
.44091 .18367 .45304 .22276 .47264 .20738 .46032 .16816 Mtetra
.492 .382 .657 r
.46032 .16816 .47264 .20738 .49247 .19189 .47997 .15253 Mtetra
.47997 .15253 .49247 .19189 .51254 .17628 .49985 .13677 Mtetra
.491 .381 .657 r
.49985 .13677 .51254 .17628 .53286 .16053 .51996 .12087 Mtetra
.51996 .12087 .53286 .16053 .55342 .14463 .54033 .10483 Mtetra
.54033 .10483 .55342 .14463 .57424 .12858 .56094 .08863 Mtetra
.56094 .08863 .57424 .12858 .59531 .11237 .58181 .07227 Mtetra
.49 .381 .657 r
.58181 .07227 .59531 .11237 .61666 .09598 .60294 .05574 Mtetra
.762 .546 .605 r
.0363 .73688 .0454 .78021 .07506 .64672 .06601 .60532 Mtetra
.709 .513 .621 r
.06601 .60532 .07506 .64672 .09796 .57068 .08888 .53022 Mtetra
.659 .481 .632 r
.08888 .53022 .09796 .57068 .11793 .52055 .10878 .48058 Mtetra
.617 .454 .639 r
.10878 .48058 .11793 .52055 .13647 .48384 .12722 .44414 Mtetra
.584 .433 .643 r
.12722 .44414 .13647 .48384 .15427 .4548 .14491 .41524 Mtetra
.56 .418 .645 r
.14491 .41524 .15427 .4548 .1717 .43041 .1622 .39092 Mtetra
.542 .406 .646 r
.1622 .39092 .1717 .43041 .18894 .40902 .17932 .36953 Mtetra
.529 .398 .647 r
.17932 .36953 .18894 .40902 .20613 .38961 .19636 .35009 Mtetra
.519 .392 .647 r
.19636 .35009 .20613 .38961 .22333 .37155 .21342 .33197 Mtetra
.512 .387 .647 r
.21342 .33197 .22333 .37155 .2406 .35442 .23054 .31478 Mtetra
.506 .384 .648 r
.23054 .31478 .2406 .35442 .25797 .33795 .24776 .29823 Mtetra
.502 .381 .648 r
.24776 .29823 .25797 .33795 .27547 .32195 .2651 .28212 Mtetra
.498 .379 .648 r
.2651 .28212 .27547 .32195 .29311 .30626 .28258 .26633 Mtetra
.496 .377 .648 r
.28258 .26633 .29311 .30626 .31092 .29078 .30023 .25074 Mtetra
.493 .376 .648 r
.30023 .25074 .31092 .29078 .3289 .27544 .31804 .23529 Mtetra
.492 .375 .648 r
.31804 .23529 .3289 .27544 .34707 .26018 .33603 .2199 Mtetra
.49 .374 .648 r
.33603 .2199 .34707 .26018 .36542 .24495 .35421 .20454 Mtetra
.489 .373 .648 r
.35421 .20454 .36542 .24495 .38398 .22971 .37259 .18918 Mtetra
.488 .373 .648 r
.37259 .18918 .38398 .22971 .40274 .21443 .39117 .17377 Mtetra
.487 .372 .648 r
.39117 .17377 .40274 .21443 .42172 .19909 .40995 .1583 Mtetra
.40995 .1583 .42172 .19909 .44091 .18367 .42895 .14274 Mtetra
.486 .371 .648 r
.42895 .14274 .44091 .18367 .46032 .16816 .44817 .12709 Mtetra
.44817 .12709 .46032 .16816 .47997 .15253 .46762 .11132 Mtetra
.485 .371 .648 r
.46762 .11132 .47997 .15253 .49985 .13677 .48729 .09542 Mtetra
.48729 .09542 .49985 .13677 .51996 .12087 .5072 .07938 Mtetra
.485 .37 .648 r
.5072 .07938 .51996 .12087 .54033 .10483 .52736 .0632 Mtetra
.484 .37 .648 r
.52736 .0632 .54033 .10483 .56094 .08863 .54775 .04685 Mtetra
.54775 .04685 .56094 .08863 .58181 .07227 .5684 .03034 Mtetra
.5684 .03034 .58181 .07227 .60294 .05574 .5893 .01366 Mtetra
0 g
.58882 0 m
.9135 .24802 L
s
.9135 .24802 m
1 .91828 L
s
1 .91828 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.07455 .4049 m
0 1.05195 L
s
0 1.05195 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.58882 0 m
.07455 .4049 L
s
0 1.05195 m
.38081 1.20141 L
s
gsave
.19359 1.22462 -67.3959 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.9135 .24802 m
1 .91828 L
s
gsave
1.03519 .50652 -61 -18.8336 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{176.688, 180},
  ImageMargins->{{60, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0.009921, 1.00727}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002`0000]1000`40O003h00O/7oo002`Ool005]o
o`03001oogoo059oo`00FWoo0`00Dgoo001HOol200000goo001oo`02001AOol005Moo`05001oogoo
?G@00003Ool00`00Oomoo`1>Ool005Ioo`06001oocUd?G@iL`0017oo00<007ooOol0CGoo001EOol0
1`00OoliDced>E<mM00000Eoo`03001oogoo04aoo`00Dgoo0P000SUd00DmM3Uc>G@iM00000Ioo`80
04aoo`00DWoo00X007oo?G@iDced>E<mM3UC?G@000Qoo`03001oogoo04Uoo`00DGoo00H007oo>G@i
M3ed>G<2>G@00ced>G<00009Ool00`00Oomoo`18Ool004moo`80000;OolmM3UC?G@iDced>E<mM3UC
?G@0000:Ool20018Ool004ioo`07001oogoo?G@iM3ed>G<00SUd00HmM3Uc>G@mM000>G@;Ool00`00
Oomoo`15Ool004eoo`0@001oogoo?G@iDced>E<mM3UC?G@iDced>G@mU000?G@<Ool00`00Oomoo`14
Ool004aoo`0;001oogoo?G@iM3ed>G<mM3Ud?G@iL`03?G@013Ud000mM3ed37oo00<007ooOol0@goo
001:Ool200004Woo>E<mM3UC?G@iDced>E<mM3UC?G@iM3fD>G@mM000?I@iM0eoo`8004=oo`00BGoo
00`007ooOoliLced>G@mM3Uc?G@iM3ed>G@3?G@01SUd?G@mM000>G@mU0moo`03001oogoo041oo`00
B7oo01L007ooOoliDced>E<mM3UC?G@iDced>G@mM3Ud?I@iM3ed>G@mU000?IDiM3fE00moo`03001o
ogoo03moo`00Agoo00`007ooOoliLced>G@mM3Uc?G@iM3ed>G@3?G@00cUd?G@mM002?G@013fD000m
U3ed47oo00<007ooOol0?Woo0015Ool200006Goo?G@iDced>E<mM3UC?G@iDced>G@mM3Ud?I@iM3ed
>G@mU3ed?IDiM000?G@mUCUd011oo`8003ioo`00A7oo00d007ooOolmM3Uc?G@iM3ed>G<mM3Ud?G@i
M003?G@00cUd?G@mM002?G@01cfD?G@mU000?I@mM3fD019oo`03001oogoo03]oo`00@goo01h007oo
OolmM3UC?G@iDced>E<mM3UC?I@iM3ed>G@mU3Ud?G@iM3fE?G@mUCUd?IDmM000>G@mUCfD?IDBOol0
0`00Oomoo`0jOol0049oo`09001oogoo?G@iLced>G@mM3Uc00<mM005>G@mM3ed?G@iM002?G@02SfD
?G@mU3ed?I@mM3fD000mUCfD0SfE4goo0P00>Woo0010Ool2000087oo>E<mM3Uc?G@iDced>E<mM3Ud
?I@iM3ed>G@mU3Ud?G@iM3fE?G@mUCUd?IDmM3fE>G@003fD?IDmM46E?I@DOol00`00Oomoo`0gOol0
03moo`0:001oogoo>G@mM3Uc?G@iM3ed>G<3?G@01CUd?G@mM3ed>G@00Sed00LmU3ed?I@mM3fD?G@m
U002?ID01P00?IDmUCfE?I@mUAEoo`03001oogoo03Ioo`00?Woo02@007ooOoliDced>G<mM3UC?G@i
Dced>G@mU3Ud?G@iM3fD>G@mM3Ud?IDmM3fE>G@mUCed?IDmM46E?I@003ed@IDmU3fE?I@FOol00`00
Oomoo`0eOol003eoo`0:001oogoo>G@mM3Uc?G@iM3ed>G<3?G@01CUd?G@mM3ed>G@00Sed00LmU3ed
?I@mM3fD?G@mU002?ID01CfD?ID003fE?I@00SfE00=1]CfEOol05Goo0P00=Goo000kOol200009Woo
?G@iDced>G<mM3UC?G@iLcfD>G@mU3Ud?G@iM3fD>G@mUCUd?IDmM3fE>G@mUCed?IDmM46E?I@mUCed
000mU3fE?IA1]CfE@KDHOol00`00Oomoo`0bOol003Yoo`0;001oogoo?G@iM3ed>G<mM3Ud?G@iL`07
?G@02CUd?I@mM3fD?G@mU3ed?I@mM003?ID01CfD?IDmUCfE00000SfE00E1]CfE?IDmUD6e01Qoo`03
001oogoo035oo`00>Goo02/007ooOolmM3UC?G@iLced>E<mM3Uc?I@iLcfD>G@mM3Ud?I@mM3fE>G@m
UCed?IDiM3fE?G@mUCed@IDmU3fE?GA1UCfD000mU46e?IE1]CfD@KDmU@0IOol00`00Oomoo`0`Ool0
03Moo`80009oo`<mM003>G<mM3Ud00XmM006?I@mM3fD?G@mU3ed0SfD0cfE00PmU3fE?IDmUCfD?ID0
046e0cfE00=1]CfE@KD06Woo0P00<7oo000fOol0;`00Oomoogoo?G@iDced>G<mM3UC?G@iM3fD>G<m
U3Ud?I@iLcfD?G@mUCUd?IDmM3fE>G@mUCfD?IDmM46E?I@mUCed@IDmUD6e?I@003fE@KDmU46e?KE1
]SfE@KH06goo00<007ooOol0;Goo000eOol01000Oomoogoo0ced00<iLced?G@02Sed00HmU3ed?I@m
M3fD?G@2?I@3?ID00cfD?IDmU@04?ID01T6e000mUCfE@KDm]@=1]@03?KEoogoo01Yoo`03001oogoo
02aoo`00=7oo034007ooOoliLced>E<mM3Uc?G@iDced>G@mU3Uc?I@iM3fD>G<mUCed?IDiM3fE?G@m
UCUd?IDmU3fE?GA1UCfD?IDmM46E?IE1]CfD@KDmU@00?IA1]Sfe@KHmUD6f?KE1]P0MOol2000/Ool0
039oo`80009oo`05?G<mM3ed?G@iL`0:?G@02SfD?G@mU3ed?I@mM3fD?G@mUCfD0cfE00<mU3fE?ID0
13fE00I1]CfE?ID0046e?KD3@KD013fe@KE1]T7F7Woo00<007ooOol0:Goo000aOol02`00Oomoogoo
>G<mM3Uc?G@iLced>E<00Sed02PmU3Uc?I@iM3fD>G<mUCed?IDiM3fE?G@mUCUd@IDmU3fE?IA1UCfD
?IDmM46e?IE1]CfD@KDmUD6e?ID003fe@KHmUD6f?KE1]T6e@MI1]Amoo`03001oogoo02Qoo`00<7oo
00D007ooOomoocec00<mM003>G<mM3ed00PmM003?I@mM3fD008mU005?G@mU3ed?IDmU003?ID013fD
?IDmUD6e0cfE00=1]CfE?ID00T6e00/0046e@KE1]Cfe@KE1]T7F@KI1eT6f01aoo`<002Yoo`00;goo
03P007ooOomoocUc?G@iLced>G<mM3UC?I@mM3fD>G<mU3Ud?I@mM3fE?G@mUCed?IDmM3fE>GA1UCfD
?IDmU46E?I@mUCfD@KDmUD6e?IA1]CfE@KHmUD6f?KD003fE@KHm]D7F@KE1eT6e@MI1]D7F6goo00@0
07oo70L002Yoo`00;Goo0P000goo00DmLced?G@mM3ec00TmM08mU005?G@mU3fD?I@mM002?I@00cfE
?I@mU@02?ID013fD?IDmUD6e0cfE00=1]CfE@KD00T6e00/m]D6e0011]Cfe@MI1]T7F@KI1eT6f00=1
eQQoo`80008H1`03Ool007oo02Uoo`00;7oo03`007ooOomoocfD?G<mM3Uc?G@iLced>G<mU3ed?I@i
LcfD?G@mU3ed?IDmM3fE?G@mUCed?IDmU46E?IA1UCfD@IDmU3fE?IA1]CfE@KDmU46e?IE1]SfE@KHm
]D6f?ID0046e@MI1]D7F@KE1eT6eAOM1eTGG@MHFOol2000017oo60HL1aP60Woo00<007ooOol09goo
000[Ool01P00Oomoogoo?G@mL`<mM004?G<mM3ed?I@6?G@2?I@03Ced?I@mU3fD?G@mUCfD?IDmU3fE
?I@mUCfD008mU@06@KDmUCfE?IE1]CfE0d6e00`m]D6e@KE1]@00@MI1]T7F@KI1eT6fAMH3@MH00dGF
@MIoo`0COol00`00Oomoo`0360L011P6Oomoo`00:Goo000ZOol0=P00Oomoogoo?I@mLced>G<mU3ec
?G@mLcfD?G@mU3Uc?I@mM3fD?GA1UCed?IDmM3fE?GA1UCfD@IDmU46E?IA1UCfD@KDmU46e?IE1]CfD
@KDm]D6f?IE1]Sfe@KHmUD7F@KD0046e@MI1]@91eP08AOM1eTGG@MI5md7FAOM1eQ5oo`80009oo`04
60HL1aP660H3Ool00`00Oomoo`0WOol002Qoo`8000=oo`03?G@mLced008mM004?G<mM3ed?I@3?G@0
0cfD?G@mM002?I@04ced?I@mU3fD?G@mUCfD?IDmU3fE?I@mUCfD@KDmUD6e?IE1UCfE00Q1]@06@MI1
]T7F0011eT6f0T7F00E5eT7F@MI1eTGF00A5ma1oo`04001oogoo70L360L00aP650Eoo`02Ool00`00
Oomoo`0WOol002Moo`03001oogoo009oo`0b@I@mLcfD?G<mU3ec?G@mLcfD?G@mU3Uc?I@mM3fE?GA1
UCed?IDmM46E?GA1UCfD@IDmU46E?IA1UCfD@KDmU46e?IE1]CfD@KHm]D6f?IE1]Sfe@KI1]D7F@KE1
eT6e0011]@91eP0;AOM1eTGG@MI5md7fAOM1eTGg@OI5m`0=Ool200001goo60HL1aP670LD1AP6008D
1@=oo`03001oogoo02Moo`009Woo00<007ooOol00Woo00=1U3ec?G@00Sed00@mLced?G@mU0<mM003
?I@mM3fD008mU00C?G@mU3fD?I@mM3fE?I@mUCfD?IDmU3fE?IA1]CfE@KDmUD6e?ID01d6e00M1]T7F
@KI1eT6f@MH00002@MH014GF@MI1eT7F24Gg2goo0P000Woo00@H1a`760LH1`8H1P0350DD11@400=o
o`03001oogoo02Moo`009Goo00<007ooOol00Woo0491U3ec?I@mLd6D?G<mM3ec@I@mM3fD?G<mU3ed
@IDmM46E?G@mUCed@IDmM46E?IA1UCfD@IDmU46E?IE1]CfD@KDmUD6e?IA1]Sfe@KHmUD6f?KE1]T6e
@MI1]D7F@KE1eT6e0011eTGg@MI5ed7FAOM1mTGg@MI5md7fAOM1eTXHAOL9Ool01P00Oomooa`760HL
1`8H1P0650DH1Q@550D@11@50goo00<007ooOol09goo000SOol20004Ool00d6D?G<mM002?G@013ec
?G@mM3fD0ced00<mU3ed?I@01cfD00hmUCfD@IDmU3fE?IA1]CfE@KDmUD6e?IE1]CfE1d6e00Y1]T7F
@KI1eT6f@MI1]T7F0015eP91ePQ5m`04AQM664GgAQL7Ool20002Ool260L00a`760LH1P0260H01A04
50@D11@530800goo00<007ooOol09goo000ROol00`00Oomoo`04Ool0;cec@I@mLd6D?G<mU3ec@I@m
M46D?G=1U3ed@IDmM46E?GA1UCed@IDmU46E?IA1UCfD@IDmU46e?IE1]CfD@KDmUD6e?KE1]Sfe@KHm
UD6f?KE1eT6e@MI1]D7F@KD00T7F00a5ed7F0011eTGG@MI5md7fAOM1eTGg@OH2AOL01DXHAOM664HH
BST01Goo00L007ooOolH1Q`760HL1`0260H01a@560H@11@540@@0``200Eoo`03001oogoo02Ioo`00
8Goo00<007ooOol017oo00DmLd6D?GA1U3ec008mU006@I@mM3fD?G@mU3ed23fD00@mUCfD@IDmU08m
U@06@KDmUD6e?IE1]CfE246e00I1eT6f@MI1]T7F@KH4@MH00dGF@MH00007AOL2AQL00dHHAOM65`02
BSP014HHOomoogoo0P000Woo0aP700HH1Q@560HD1Q@440@250@00a0330880@05Ool00`00Oomoo`0V
Ool001moo`8000Ioo`11@G=1U3ec@I@mLd6D?G=1U3ed@I@mLd6D?GA1UCed@IDmM46E?GA1UCfD@IDm
U46e?IA1UCfD@KDmUD6e?IA1]CfE@KDm]D6f?KE1]Sfe@KI1]D7F@KE1eT6e@MI1]DGg@MI5ed7FAOM1
eTGG0015md7fAOM1eTXHAOM664GgBQQ5m`02AQP01TXiAQQ:>4HHOol000=oo`0<60HL1aP660HD1AP6
40@D1A0450D<0Q030PP11Woo00<007ooOol09Woo000NOol00`00Oomoo`04Ool02T6D@G=1U3ed@I@m
Lced?IA1U3ed1SfD0191U3fD?I@mU46E?IA1UCfD@IDmU3fE@IE1]CfE@KDmUD6e?ID7@KD0246f@MI1
]T7F@KI1eT6fAMH3@MH01DGF@MI5mdGg00000dGg00I664HGAQM65dHHAQL3BSP00dHhBSQ:>002BUT0
0goo60LH1`0260L011@660HD1AP60Q@400@<0P`330<@0`<80@Ioo`03001oogoo02Ioo`007Goo00<0
07ooOol017oo03Y5U45c@I@mLd6D?G=1U3ec@I@mM46D?G=1U3fD@I@mM46E?GA1UCed@KDmU46E?IA1
]CfD@IDmU46e?IE1]CfD@KDmUD6f?KE1]Sfe@KHm]D6f@KE1eT6e@MI1]D7F@KE5md7FAMM1eTGg@MI5
md7FAOL00095m`0=BQQ5mdHHAOM:64GgBSQ664XiAQQ:>4XiCUT00TYI00I:>A`760HL1a@560H250D0
1A0450D<0Q0330800PP10P001goo00<007ooOol09Woo000LOol00`00Oomoo`05Ool01D6C@IA1U46D
@G<00d6D00PmM46D?IA1U3fD@I@mU46D0cfD00i1UCfD@IDmU46E?IA1]D6E@KDmUD6e@IE1]CfE1d6e
00Q1]T7F@KI1eT6f@MI1]TGF0d7F00=5eTGgAOL00dGg00<004HGAQP00dHG00=664HhBSP00TXh00=6
>4XhBUT014YI0Tij00@H1a@660HD1@<D1003308<0``300880@8000Qoo`03001oogoo02Ioo`006Woo
0P001goo02e1TdFD@G=1U45c@I@mLd6D?GA1U3ec@I@mU46D?GA1UCfD@I@mM46e?IA1UCfD@KDmU46e
?IA1]CfE@KDmU46e?IE1]Sfe@KHm]D6f?KE5eT6e@MI1]D7F@KD00T7F01U5md7FAMM1eTGg@OI5md7F
AOM1mTHH001:64GgAQQ5mdXHAQQ:>4HHBSU664YIBSU>F@02BUT03TYiCYY:NTjJ50DH1Q0450D@11@5
308@0`@120430009Ool00`00Oomoo`0VOol001Uoo`03001oogoo00Ioo`05AI=1U46D@IA1L`05@I@0
0cfD@IA1U003@I@02CfD@I@mU46E?IA1UCfD@IDmU003@KD01CfE@KE1UD6e?ID01T6e00I1eT6f@MI1
]T7F@KH2@MH014GF@MI1eT7F1TGg0THG00H004HGAQM65dXhASP3BSP00dHhBUU:F@03BUT4CWX024jk
D[]>^a@440@@0``230<22043000:Ool00`00Oomoo`0VOol001Qoo`03001oogoo00Moo`0NAKA1LdFD
@I=5U3ecAI@mU46D?G=1U3fD@I@mU46E?IA1U3ed@KDmU46e?IA1]CfD@KDmU46e?IE1]CfD0T6e03I1
]Sfe@KI1]D6f?KE5eT6e@MI1]DGF@KE5ed7FAOM1eTGG@MI5md7fAOM1eTGg@OI664GgBQP004HHAOM:
>DHHBSQ664XiBUU>FDXiCUU:FDjJBWU>VTYjCYY>Ve:kC[]Bo5;LE_d<0Q031044000<Ool00`00Oomo
o`0UOol001Qoo`<000Ioo`95U003AKA1Td6D00Y1U007?IA1U46D@IE1U46E@I@00T6E0d6e00=1UD6e
@KD0246e00A1eT6f@MI1]P91eP03AMI1eTGF00=1ePI5m`965`03AQQ65`00009:>004ASQ:>4XhBSP5
BUT5CWX00djkD[]Bo003D_`2Ecd01@P100000000>gD03Goo00<007ooOol09Goo000HOol00`00Oomo
o`020004Ool01T6CAKA5TdFD@G=5]091U00]@I=1U46D@K@mU46E?IA1U3fD@KDmU46e?IA1]D6E@KDm
U46e?IE1]CfD@MI1]D6f?KE1]T6e@KI1]DGF@KE1eT6eAMI1eTGG@MI5md7FAMM1eTGg@OI5md7F0095
m`0GBQQ5mdXHAOM66000BSU664XhAQQ:>DYICUU:>DiIBWY>VTYiCYY:NU:kCY]B^`02D_`025;LEeiC
?ELnEgiGWU>mBm/?Ool00`00Oomoo`0UOol001Qoo`03001oogoo009oo`800009Oom9/dFdAI=5U46D
AKA1U4FD00U1U004@KE1U46E@I@2@ID3@KD00d6E@KE1]@06@KD3@MH02T6f@MI1]TGF@MI5eT7FAMI1
eTGF1TGg0dHG00E664HGBSQ:>000009:>0I:F@E>NP03D[]>^e;l00=Bo09G?@03EiiGOU>n009;^a1o
o`03001oogoo00aoo`<001Ioo`0067oo00<007ooOol017oo00h004VdAI=5]4FCAKA1U4Fd@I=5U46D
@KA1U46e0d6D00Y1]D6D@KDmU46e@IE1]CfD@KE1U@91]@0aAMI1]D6f@KE1]T6eAMI1]DGF@KE1eT6e
AOM1eTGG@MI5md7FAMM1eTGgAOI5md7FBQQ5mdXHAOM:64GgBSQ664Xi001:>4XiCUU:FDiIBSU>VTYj
CYY:NDjJC[]B^djKE_d00U;l00QC?EMNDceGWUMnEmi;^T_K4Goo00<007ooOol03Goo00<007ooOol0
5Goo000GOol00`00Oomoo`05Ool01DVdAK=9]4FDAK@00TFD00=1U4Fd@I@01T6D00A1]D6D@IE1U0E1
]@03@IE1]D6e00E1]@05@KI1eT7F@MI1]P02@MH01TGF@MI5eT7FAMI1ePI5m`06AQQ65dHGAQM664HG
14Xh00<004YIBUT00dYI0dij00A>^e:kC[]B^`ABo09G?@03EgiGWU>m009;^a=oo`03001oogoo00eo
o`<001Eoo`005goo00<007ooOol017oo01A=e4FCBKA5TdVdAI=5]46CAKA5U4Fd@IA5]D6D@KA1U4Fe
@IA1]CfD0d6e00=1U46e@ID00T6e03Y5eT6e@KI1]D7F@KE5eT6eAMI1]DGF@KE5md7FAOI1eTGg@MI5
md7FAOM5mTGg@MI:64GgBQQ5mdXHAOM:>4HHBSU664iI001>FDYICUU:NDjJCWY>VTjKD[]>^e:kD]aF
oE;lEciC?EMNEgiGWU>mBm];^QAoo`03001oogoo00eoo`04001oogoo000DOol001Moo`03001oogoo
00Aoo`05BK=9]4VcBKA5U003AK@0146DAKA1U4Fd0T6D00E1]4Fe@IA1]D6D00i1]@=1eP09@KI1eTGF
AMI1eTGF@MI5eT7F00I5m`05AQQ65dHGAQM66004BSP3BUT00`00BUU>NP03CWX015:kC[]B^djk15;l
0ULm00=GWUMnDkh00T^k5Woo00<007ooOol03Goo00@007ooOol001Aoo`005goo00<007ooOol00goo
01U9/dgDBK=9]4VcAKA5TdVdAI=5]46DAKE1U4Fd@IA5]D6DAKE1U4Fe@KA1]D6DAKE1U@02@KD05TGF
@KE1]T6eAMI1]DGF@KE5eT6eAMI1eTGg@MI5mT7FAOM5mTGg@MI5mdGf0TGg021:64GgBQQ5mdXHAQQ:
>4HHBSU:FDiIBSQ>F@00CYY:NDjJCWYB^djKD[]>^eKlD]aFoELmEciGOU^NEgiGgSME6Goo00<007oo
Ool02goo10005Goo000GOol00`00Oomoo`03Ool014gCCK==e4Fc0TVd00=5]4FDAK@00dFd00I1U4Fd
AKE1U46e@K@8@KD02dFe@KE1]D6eAMI1eDGF@MI5eT6e@MH00TGF00=1eTGFAMH01dGg00=65dXHAQL0
0THG1DXh14YI00U>NP00CWY>NTjkD[]>^e:kC[/00e;l0ULm00AGOUNNDkeC_Q]oo`03001oogoo02Ao
o`005goo00<007ooOol00Woo031=e4VcCMA9/dVdAK=9e4FCBKA5]4FeAIA5]46DAKE1]4Fe@IA5]D6d
AKE1]4Fe@KE5eD6eAMI1]DGF@KE5eT6eAMI1]DGF@KE5eT7FAOM1eTGf@MI5mdGfAOM1eTGgAOH2AOL0
7dXHAOM:64HHBSU664XhAQQ:>DYICUU:>4iICWY>VP00CYY>^e:kC[YFoE;lE_aBg5MNEceGWUMnFiiC
_EON01aoo`03001oogoo02Aoo`005goo00<007ooOol00Woo00A=/dgDBK==e0=9]095]006BKA5]4Fd
AKA5]D6d0TFd00U5]D6eAKE1]DFe@KE5]D6eAMD00d6e00I5eT7EAMI1eTGF@MD6AMH5AOL3AQL00dXH
AQM65`05BSP014iIBUU:FDYI14ij00@004jkD[]B^`9Bo0AG?@04EiiGOUONDkdNOol00`00Oomoo`0T
Ool001Moo`0[001oogooOomAddgDBK==e4VcBMA9/dVdAKA9]4FdBKA1U4WEAKA5]D6DAKE1]4Fe@KA5
]D6dAME1]DGF@KE5eD6eAMI1eDGF@KE5eT6eAOI1eTGg@MH00TGf00A5mdGfAOM5mP95m`0PBQQ5mdXH
AOM:>4HHBSQ:64XhAQQ>FDYICUU:>4jJCWY>VTYiCYX005:kD]aFoE;lEciC?EMNEgiGWU>mCm/kMAmo
o`03001oogoo02Aoo`005Woo00<007ooOol00Woo00IAle7CCM==ddgDCM<2BK@01DWDAKA5]4FdAKD0
0dFd1DFe0T6e00]5]DGE@KE5]D6eAMI1eDGF@MI5eT7E0095eP03AOI5eTGF0095m`04AOI5mdGgBQP3
AQL00dXHAQM:>004BSP00dYICUU:F@02BUT4CWX01U:kC[/005;lE_aBo0=G?@05EgiGWU>mBm/0000P
Ool00`00Oomoo`0TOol001Ioo`03001oogoo009oo`08DM=AldVcCMA=/dgDAK==e099]00KAKA9eDFd
AKE5]4WEAKA5eDFdAME1]4Fe@KE5eT6eAME1]DGF@ME5eT6eAMI1]DGf@MI5md7F0095mP0>BOM5mTGg
AOI:64HGBQQ5mdXHAOM:>4HHBSQ:609:>00ECUU:FDiIBSQ>VTijCYY:NE:kC[]Fo000E_eBo5LnEceK
WUMnEmi;^ToK029oo`03001oogoo02Aoo`005Woo00@007ooOomoo`=Ad`07CMA=ddgDCM=9e4VdBM@0
0dVd00A9e4FdAKE5]0=5]@06@KE5]DGEAME5]DGE0TGF00E5eDGFAMI5eT7E0095eP03AOI5eTGF0095
m`09AOI5mdGgBQM65dXGAQM:64HG00E:>004BUU>FDYIBUT4CWX2D[/014jkD_aBo0000eLm00AGWUMn
EkhkMRAoo`03001oogoo02Aoo`005Woo01`007ooOomooe7cDM=Am4fcCMA9/dgDBKA=e4VcCMA5]4WE
AKA9eDFdBME5]4GEAKA5eDFeAMI5]@95e@0DAMI5eDGF@KE5eT7EAOI1eTGgAMI9mdGfBQM5mTGgAOI:
64HGBQQ5m`9:600DBSQ:64XhBUU>FDYHCUU:FDiICWU>VTijD[]>^U:kC[]Fo5;LE_`0009G?@03FiiC
_EON02Moo`03001oogoo02=oo`005Woo00T007ooOomooe7CDO=Ade7cCM<00TgD00=9e4VdBM@00TWD
00M9]4WDAKA9eDFeBME5]@03AMD01DFeAME5eDGFAMD014GF00A5mTGFAOI5eP=5m`08AOI5mdHGBQM6
5dXGAQM:5`A:>005BUU>FDYICUU:F@02CWX00djJCWYB^`03D[/2D_`2Ecd01@00EgiGWUNmEkh0:7oo
00<007ooOol08goo000FOol06P00OomooeGbDOAAdeGdDM==e4fcDMA=ddgDBKA=e4VdBME9e4WEAKA9
eDFdAME5]DWEAKD2AMD014GFAME5eTGE0TGF00m9mTGFAOM5eTWgAOI:5dGfBOM5mdXHAQM:64GgBQP0
0TXh01Q:64XhBUU>FDYHCUU>NDjJCWUBVTjkD[]>^U:kD_aFo5;LFeiG?E^N001GgU>m000YOol00`00
Oomoo`0SOol001Ioo`06001oogooFQ=Ele7C0U7c011AddgDCMA=e4VdCMA9e4gDBKA9eDWDBME5]4WE
AME9e@=5e@04BMI5eDGFAMD2AMH02DGfAMI5mTGFBOM5mdWgAOI5m`04BQL00dHGBQM:>003BSP014YI
CUU:FDiI0dij00i>VU:kD[]B^eKlD_aFo5;lEceGOUNNEkd004^k:goo00<007ooOol08goo000FOol0
7P00OomooeGbFQ=AdeGdDM=Em4gCDOA=ddgDBKA=eDWDBME9]4gEBMA9eDGEBME5]DWEAKE9mTGEBMI5
e@95eP0?BOI5eTWfAMI:5dGfBQM5mTWgAQM:64HGBQQ5mdhh009:>00?BQQ>FDYHCUU:F5:JCWU>VTii
D[]>^U:kC[YFo5;l009G?@06FeiGOU^NDke?f`00;7oo00<007ooOol08goo000EOol01000Oomoogoo
0UWc00AAle7CDO=Al`==e007DMA=e4WDCMA9e4WEBM@014WE0TGE00M9mTGEAMI5eDWfAMI9mP02AOH0
1TGFBOM5mdWgAOI9m`E:5`A:>005CUU:FDiICUU>VP03CWX3D[/00e;lE_aBo003Ecd01UMnEkiG_DoK
?gH002aoo`03001oogoo02=oo`005Goo01D007ooOomJ4eGbFQ=AdeGdDM=Em4gCDMA=de7dBMA=e4WD
COE9e4WEBM@00dWE00m5eDWfAME9mTGEBOI5eTWfAMI9mTGfBQM5mTXGAOH00TXG01e:64HGBQQ65dhh
BSQ>>4XGCUU:F4iIBUQBVTiiDYY>NE:kD[YB^e;KE_aBo5/mEceKGEMmEmiG_CnF009oo`03001oogoo
02Yoo`03001oogoo02=oo`005Goo00H007ooOomIleXCEO<4DO<025GcCMAAm4gDDOA9e4geCM@2BMD0
0dgeBME9e@02BOD3BMD3BOH01dGfBOI9mTWgBOI9mdGf00A:5`9:>004CSQ:>4XhBSP4CUT015:JCWU>
NTij0U:k0eKl00MBo5LmEceKWUMnEki?f`05Ool00`00Oomoo`0YOol00`00Oomoo`0SOol001Eoo`0O
001oogooFQ=ElUXCDM=Em57cEOAAde7dCMAAm4gCCOE=e4geBMA=mDWDCOE5eDgfBME9mTGECOI9mDWf
AMD00TWf00A:5dGfBQM5mP9:5`0LBQQ:5dhhBSM>>4XhCSQ:F4iIBUQ>FDiiDYY>NE:JD[YB^e:jE_aB
feKlEceK?EMmFiiGOE_N?gH6Ool00`00Oomoo`0ZOol00`00Oomoo`0ROol001Eoo`05001ooeXCEO=I
l`02FQ<0257CEO=EleGdCMAAm57DDO@3CM@01TgeBME9eDWEBOE9e@99m@I9mP04BOM9mTXGBOH4BQL0
0dhhBSQ>>002BSP4CUT00dijDYY>N@03D[/015:jE_aFo5Kl0ULm00EKOU^NEkeG_@0000Moo`03001o
ogoo02Yoo`03001oogoo029oo`005Goo00d007ooEO9J4eGbFQ=IleGdDM=Em57cDOA=d`03DO@0<4WD
DOE=m4geBMA=mTWECOI9eDgfBOE9mTWeCOI9mThGBOI:5dWfCQM:5dhhBQM>>4XgCSQ:=dhhBUQ>NDiH
CUU>NE:JCWUB^e:jD[]B^UKlD]]KGELmFiiGOE_NCm]Cf`Uoo`03001oogoo02Yoo`03001oogoo029o
o`005Goo00`007ooFO=IleXCFO=J4eGcEOAAleGdEO<4DO@00dgeCOA=m@04COD3BOD4BOH00dXFBOI:
5`03BQL00dhGBSQ>>002CSP02DXhCSQ>FDiICUQ>FE9iDYYB^P03D[/2E_`01ULmFceG?E^NFgiKgP9C
f`Yoo`03001oogoo02Yoo`03001oogoo029oo`005Goo01@007ooEO9J4eWcFQ=ElUGdDO=Em57cEQA=
e57dCMAAmDgdDOE=e57e0Tge00e9eDgfBOE>5TWeCOI9mThGBOI>5dXGCSM:5`02CSL06DhhBSM>>4Xg
CUU>F59iCUQBVTiiDYYB^UJkD[YFo5KkE_aG?5]MEcaKWUNmFmi?fdNg00]oo`03001oogoo02Yoo`03
001oogoo029oo`005Goo00@005hBHS9El`AJ4`9El`03EOAEle7d00=Am0M=m@05BOE=mTgfCOI9mP03
CQH4CQL04DXGCSQ>>4hhBSQ>FDiHCUUBNE:IDWUBVU:jD[]B^UKlE_/015/m00AKWU^mFme3U`eoo`03
001oogoo02Yoo`03001oogoo029oo`0057oo00H007ooHS=N4UXCEO83FQ<04E7CEQAEleHDCMAAmE7d
EQEAm57eCOAB5DgdCOI=mE8FBOD00dhF00e9mThGCQI>=dXFCSM:5dhhBSM>F4hgDUU>F002DWT03e:J
CWUBVU:jE[]Ffe[lE_]K?ELlFeeKOEnNFkeGo00?Ool00`00Oomoo`0ZOol00`00Oomoo`0ROol001Ao
o`04001ooehBGQ82FQ<01UWcFQ=J4eGdEO=Em09F50=Am00:DQA=m57eDOEB5DgeCQE=mDgfBOD3CQH0
2DWfCSM>5dhgCQM>>4hgCSQ>=`02DUP02TiICUQBVE9iE[]B^UJjE_]Jo5Kk0e/m00AKOEnMFke;^11o
o`03001oogoo02Yoo`03001oogoo029oo`0057oo00h007ooHS=N4UXCFO=J4eWcGQ=EleHDDO=J55Gc
0U7d02UF5E7dDQE=m58ECOEB5TgeDQI=mDhFCOIB5ThFCSM>5U8gCQIBF4hgDUQ>=e9iCUQBNDiHDYYB
NEJkD[YF^eKKF_aFne/mFcaO?E]mGmiK_Cmc015oo`03001oogoo02]oo`03001oogoo025oo`0057oo
00D005hBGQ9R<UWc00EJ4`06EO=Em5GdEQAAm58D0U7d00QF558ECOEAmE8ECQI=mE8F0dhF00AB=e8f
CSM>5`9B=`08CSQ>=e9HDUQBFDiHDYUBN@=F^P9Jn`05E_]K?5/lFceOO@02Gkd00`00Oomoo`0@Ool0
0`00Oomoo`0[Ool00`00Oomoo`0QOol001Aoo`0R001N4V8cGQ9R<eGbGQ=J4ehCFQ=F55GcFQAEleXD
DOAF5E7dEQE=mE8EDOEF5TgeDQI>5E8fCQIB=dhFDSM>=e9HCSL2DUP01U9hCUQBNE9iEYUBN@=F^P0:
E]]Jo5KkGcaK?5nNFgeOgE_K000COol00`00Oomoo`0[Ool00`00Oomoo`0QOol001Aoo`05001R<UhB
HS9N<P04FQ<01UhCFQ=F55HDFQAF509Am004EQEB55HEDOD3DQD3DQH01e8gDSIB=e8gDUMB=e9G00=B
F004DWQBNEJIEYT3E[X2F_/00e/lGcaK?002Ggd00enmDmP0000DOol00`00Oomoo`0[Ool00`00Oomo
o`0QOol001Aoo`05001N4V8cGQ9R<`02FQ<03UWcGS=J4ehCEO=J55HDFQAF4eHEDQAF5E7dEQH3DQD0
758fCQIF=e8FDSM>5U9GDSMFEe9HEWQBEeIhDWUFVE9hF[YF^E[kE]YJne/lGcaK6f>MGkeSgE?H5Woo
00<007ooOol0:goo00<007ooOol08Goo000DOol01@00GQ9N4V8cGQ800UXC00eN4eXCFQ=J4eHDEOAJ
55HDFQAB55HEEQAF=@03DQD00eHfDQEB5P03DSH01U9GDSMBEeIGEWQBF09FN004EYUF^UZjE[X3F_/3
Gc`016=mHkeS_E_I5goo00<007ooOol0:goo00<007ooOol08Goo000COol0<`00HS=N4V8cGQ9R<eWc
GQ=J4ehCFQ=N=5XCFQAF4eXDEQAF5E7dEQEF55HeDOEF=U8EESIB5UHgDSIFEe8fEUMB=eIhDUMFVEIh
EYUF^EZjE[UJ^U[JG_]O6f<lGgaSWEnlHmeC]@0HOol00`00Oomoo`0[Ool00`00Oomoo`0QOol001=o
o`07001N4V8bGQ9R<UhbHS<00eXC00QN4eXCGS=F55XDEQAJ=5XD15HE00EF=U8EESEB5EHf009B=P9F
E`05EUIFN5IGFYQFN002EYT3F[T015[kGcaO>ell0V=l00=S_6NlDkD05goo0P0000=oo`000000:goo
00<007ooOol08Goo000COol08@00HS=N4V8cGQ9R<ehBGQ=J4ehcFQ=N<eXCFQAF55XDEQAJ=58DESEF
55XeESEF=U8EFUIF=EHfDSIFEeHfFWMFE`02EWP03eZHEWQJ^UZiF[YJfV<kGa]S>f=LHgeS_6OlGoUC
T`0EOol20005Ool2000ZOol00`00Oomoo`0POol001=oo`05001N4UhBGS9R<`02HS801eXCGQ=J4eXC
GQ=N<eHD009J5004FSAJ55HEEQD2ESD00eXeDQEF=P02ESH2FUH025IFFWMFMeYgEWQJV5JHG[T2F[T2
G_X02ElKHc]WO6MlIkaWff?iDi9_K@0COol20009Ool2000XOol00`00Oomoo`0POol001=oo`0b001R
<ehBHS=N4V8cGQ9N<eXCGQ=J4ehdGQ=N=5HCFSAJ55XdFQAJ=EHDFSEF5EXeESEF=UHeFUMFEUYgEUMJ
N5YgGYQFN5ZIF[UN^EkIH_YO6f<kHe][_6NLIoaWnF?EGdeoLA9oo`03001oogoo00]oo`03001oogoo
02Eoo`03001oogoo021oo`004goo00@005hBHS=N4P9R<P06HS=R<UXCFQ=N<eXC0Uhc00=J=5XDFS@0
0UXd00=F5EXeESD00UXe00QJEEHfFUIFEUYFFWIJMeIG0eZH0UZi00ENfEkjHaYS6VMK009[V`05Jm]W
nF?DIk=_K@0AOol2000?Ool2000UOol00`00Oomoo`0POol001=oo`0K001R<ehBHS=N4V8cHS9R<eXC
GS=J4ehcFQ=N=5XDFSAF55heFSAN=5HEFSEF=EYEFSEJEeIF009JEP05GWMJEUjHFWMNV002G[P03EkI
H_YS6VLkIeY[Nf^KJia_fFohIk9k/W]A00moo`8001=oo`8002=oo`03001oogoo021oo`004goo00D0
05hBHS9N<V8c00=R<P04HS=J4ehcGQ<3GS<00eXDFSAJ=002FS@015XeESEJEEXe0UYE0UYF00EJMeYf
GYMNUeZH009N^09Rf@9W6@9WF`9[V`06KmU_nFNcIm=_KGma3Goo0P005goo00<007ooOol087oo00<0
07ooOol087oo000COol03`00HS=N4V8cGQ9R<ehbHS=R<UhcFQ=N=5hCHSAN<`02FS@015hdFQANEEXd
0UXe00UJEUYEGUIJEEigFUINMeYfGYL00Ujh00mNV6;iH]QW6VLiJeY[NVnJKkYcnW?GJm=gTGmbNg00
37oo00<007ooOol067oo0P0087oo00<007ooOol087oo000BOol01@00OomN<V8cGQ800V8b00AR<f8b
HS9N4`IN<`AJ=006GSAJ=EYEFSENEEYE0Uif00AJMejGGYMNM`9R]`9Rf@9W6@0:JeY[>VmjKkY_nG?G
MmEc/W^aOe4;Ool2000MOol2000NOol00`00Oomoo`0POol0019oo`0a001oof8cGQ9R<ehBHS=R<V8c
GS9RDeXCGSAJ4f8dGS=R=5XDGSEJ=5iEFSAREEXeGUIJEEifGWENMUYfGYMNMf:hGYMVf6;GIaYRnF]J
IcY_VVmhMmUcegOHMkAk/W]BOg402Goo0P008Goo0P007Goo00<007ooOol07goo000BOol00`00OomN
4P02HS801V8cHS9R<V8bHS=R<PIN<`05HUAJ=5hdGSANE@02GU@00eYEGUINMP02GWH01V:FGWMNUf:g
H[QRf09Vn00<J_Q[66mIKeUcVG>hLmQge7nDMi5oLGm`27oo00<007ooOol08goo00<007ooOol06Woo
00<007ooOol07goo000BOol0<@00OomR<ehBHS=N4V8cGS9R<f8bHS=J4ehdGS=R=5hcHUAN<eiEFSAN
EEhdGUEN=69eFUENMUiEHYINMV:FGYMR^6;GI]QVn6/IJaQ_>FmHLiUc^7^gMkEoU7^BOe=kDG/B00Io
o`8002Moo`8001Yoo`03001oogoo01moo`004Woo00@007ooGS9R<`=R<P04HS=R<V8bHS86GS<0168c
GSAN=5Xd0UiD00=REEiDGWH00Uif00YRMV:FHYIV]V;HI]QVn6[hI_Q[>@9_F@9gM`07MiMgeG^DNk5o
DWmaN_4017oo0P00:goo0P0067oo00<007ooOol07goo000BOol0<000OomooehBHS=N4V8cHS9R<f8b
HU=R<UhdGS=R=5hcHUAN<f9DFSANEEhdHUENE69eHUARMUifHYINMVJgHYIVefJfJ_MZeVliKeQcNG=G
MiMgUW_FNi=oU7/bOg9jl@=oo`8002moo`03001oogoo01Eoo`03001oogoo01moo`004Woo00<007oo
Ool00V8b00ER<f8bHS9R<V8c009R<P=N<`03HS=N<f9D009RD`04GUANEEiDHUD3HWD2HYH02VJfHYIV
]fJfJ_MZeflGK_Mc=g=G0WMg00Mk]g]ENiAkU7mCOe9k4P02Ool00`00Oomoo`0`Ool2000EOol00`00
Oomoo`0OOol0019oo`0R001oogooGQ9R<f8bHS=N<V9CHS9VDf8bHSAN<f8dGS=RE68cHUAN<f9EGSAR
MEiDHWERM69eHWAV]f:FI[MV]V[GJ]H2J_L037<hKaMgF7=gNkMkEGnENi=oDg]BOg9jl@8003Eoo`80
01=oo`03001oogoo01moo`004Goo00D007ooOomoof8c00=R<P06HS=R<V8bHS9RDf8b0Uhc00URE5hc
HU=RDf9DHU=REEiEHUD00f9e0VJE00=R]VJfI]L00V[G00A^mflGKcMcE`9gM`06MeEkMG]dOiAkDWmB
0P00>Goo0P004Goo00<007ooOol07goo000AOol06`00OomoogooGQ9R<ehbHS=R<V8cHS9VDf8bIU=N
<f8dGS=RE5hcHUARDf9DGUARMEiDHWERE004IYD016[GI[IZmfKF0VlG00Qc>7=GMcIc=G]eNgAoU7/c
0P0000=k4W[aOol0>Woo00<007ooOol03goo00<007ooOol07Woo000AOol00`00Oomoo`02Ool00f8b
HS=R<P02HS803V9CHS9R<V9BIU=N<f8cHU=RE69CHUARDfIdGU@2HWD00fJEHWEVU@02IYD04VJeJ[EZ
]FlGJ_Mc=g<ELaIg=GMENgEkUG/c001kDW[bN_5k4Saoo`8000moo`03001oogoo01ioo`004Goo00<0
07ooOol00Woo01AR<f8bHS=R<V9CHS9VDf8bIU=R<V9DGS=RE68cHUARDfIdHU=VM69D0V9e0VJE00eV
]FJEJ[EZ]FkFK]E^mVkeMaIc=GLfMcEoU@0200001G/bOg9flW/B0000?Woo0P003Goo00<007ooOol0
7Woo000AOol00`00Oomoo`02Ool3HS802F8cHS9R<V8bIU=R<VICGS=RE003HU<0269DHU=VE69CIWAR
MFJEHWD2IYD2J[D026[EK]E^eFkeLaIc5GLeMeD200001g/CNc=kDgKbN_9jl@00041oo`8000]oo`03
001oogoo01ioo`004Goo00<007ooOol00Woo025R<ehbHS=R<V8cHS9VDf8bIU=R<VICHS=RE5hcIUAR
DfIdHU=VM6ICIYERM6JeIYEZ]FJEK]IZ]FkfJ]Ec5W<ELaH00P0000Uflg/dMa=oDg]BN_9flG/B0000
@Woo00<007ooOol027oo00<007ooOol07Woo000AOol00`00Oomoo`03Ool02V8cHS9R<V8bHU=R<VIC
HU9VDf9B0V9C00IRE69CHUARDfIdIW<3IW@2IYD3J[D02V[EK]EbmVkeLaH007]EL_=g57LC0W/c0WKb
00=jlW[a0000@goo0P0027oo00<007ooOol07Woo000AOol00`00Oomoo`03Ool07F8bHS=R<VICHS9V
Df8bIU=R<VICHU9RE68cHUARDfIdHU=VM6IcJYAVLfZDIYEZ]VZeK]IZ]FkfK_D00P0000ag=W;cMaAg
4g/dNc=oDgKBN_9flG/B0015Ool20006Ool00`00Oomoo`0NOol0011oo`03001oogoo00Eoo`03HS9R
<f8b009R<P0;IU=R<VICIU9VDf9CHUARDfIdHU=VE002IW@00fIcJYAZU002JY@00f[EJ[E^eP020000
2G<ELaIbe7KdMaAk57LCNc=fdP02M_800g[bOol00017Ool00`00Oomoo`03Ool00`00Oomoo`0NOol0
011oo`03001oogoo00Eoo`0HHU=R<VICHS9VDf8bIU=R<VICIU9VDf9CIUARDfIdHU=VM6IcJYAVLfZD
JY=ZU6ZC0P0000mbe6jcL]A^dg;dL_=k57LCNcAbdWKcM_9jlWKa0000BGoo0P0017oo00<007ooOol0
7Goo000@Ool00`00Oomoo`05Ool3HS803V9CHS9VDfIBIU=VDVICIU9VDf9CIUARDfIdIW<2IW@4JY@0
1000JYA^]6jd0W;D00Ibm7KdM_Ag4g/CNc<2M]8017KbN_9k4P00Bgoo0P000Woo00<007ooOol07Goo
000@Ool00`00Oomoo`06Ool0568bIU=R<VICHS9VDf8bIU=RDVICIU9VM69CIWAVDfZDIW=ZU6IcJY@2
00004VZCK[AZ/g;DK]=be7;CMaAflgLDMa=fdgKBM_9fdG/BN_4004eoo`<001moo`0047oo00<007oo
Ool01Woo00iRDf8bHS9RDVICHU9VDfIBIU=VDVICIU9VM69C16Id0P000VZD00AZ]6jdK]A^]09be00<
L_AblgLDMa=k57;BM]9flW[bN_5k4P00CWoo0P007goo000@Ool00`00Oomoo`06Ool0468bIU=R<VIC
HS9VDf8bIU=VDVIcIU9ZLf9CIWARDfZD0P0000EVLfZdJY=^]6ZC009^]00?L]A^dg;DL]=fm7KcNcAb
/WKbL]9jlWKbNa9oo`0004aoo`80025oo`0047oo00<007ooOol01Woo0V8b00]RDf8bIU=VDVICIU9V
DfIBIU=VDVIc009VM003001VM6ZD009ZU005J[AZU6jdK[A^e003L]@01G;dM_Ag57:bL]800gKB00Af
lW[bOol004Yoo`8002=oo`0047oo00<007ooOol01goo00aVDf8bIU=R<VICHS9VDf9BJW=VDVYcIU82
00001VZDIW=ZU6IcJYAZT`=^]00@K[=be6kCL_Ablg/DL[9fdg;BM_=fdWKbM]5k4Woo0018Ool2000U
Ool0011oo`03001oogoo00Moo`0:HS9VDf9BIU=RDVICIU9VDfIBIW<200001FIBJW=VM6ZDIW@00VZD
00E^]6ZDK[A^]6kD009be005L_Afm7:bL[9bdP02M]82M_8017[bOomoo`00AWoo0P009goo000?Ool0
0`00Oomoo`09Ool08f8bIU=R<VICHU9VDfIBIW<006YcIU9ZLfIBJW=VLfZDJY=Z]6ZCK[AZ/g;DK[Ab
e7;CM_A^/W;CL[9fdg;BM_9fdW[bM_400Woo00<007ooOol0@Woo0P00:Goo000?Ool00`00Oomoo`09
Ool01VICHS9VDfIBIU=VDP800008JW=VDVYcIW9ZLfYbJW=ZLP9ZU004J[A^]6jdK[@2L]@01W:cK[9b
/W:bM]9b/P9fdP9flP=oo`03001oogoo03moo`<002]oo`003goo00<007ooOol02Goo00AR<VICHS9V
D`80000=IU9ZLfIBJW=VDVYcIW9ZLfYbJY=ZLVjdJY<00Vjd00ebe6jBL[=^TW:cK[9fdg:bM]=bdWKc
M]9jlP03Ool00`00Oomoo`0mOol2000^Ool000moo`03001oogoo00Yoo`0KIU800000IU=VDVICIU9V
LfIBJW=ZLVYcJW9ZLfYbJW=ZTVjCKY9^TfjBK[=^TW:cK[9bdg:b009bdP9fdP03M_9oogoo009oo`03
001oogoo03]oo`80031oo`003goo00<007ooOol02Woo0200068bIU=RDVYcIU9ZLfIBJW=VDVYcIU9Z
TfYbKY=ZLVjCJW9^TfZBK[=^TW:cKY9bdg:bL]=b/WKCM]9flWKB17oo00<007ooOol0>Goo0P00<Woo
000?Ool00`00Oomoo`08Ool2000067ooIU=VDVICIU9VDfIBJW=VDVYcJW9ZLfYbJW=ZLVZCJW9^TfjB
KY=^TVjcK[9b/`=b/P04M]9bdWKBM_85Ool00`00Oomoo`0gOol2000dOol000moo`03001oogoo00Io
o`8000=oo`0NHS9VDfIBIW=VDVYcIU9ZLfIBJW=VLVYcJW9^TfYbKY=ZTVjCKY9b/fjBL[=^TW:cL[9f
dg:bM]9bdW[b1Goo00<007ooOol0=Goo0P00=Woo000?Ool00`00Oomoo`04Ool20006Ool06VIBIU=V
DVICIU9VLfIbJW=ZLVYcJW9ZLfYbKY=ZTVjCKY9^TfjBK[=^/W:cL[9bdg:bL]82M]86Ool00`00Oomo
o`0bOol3000hOol000ioo`03001oogoo00Aoo`03001oogoo00Ioo`0KIU=RDVYcIU9ZLfIBJW=VLVYc
IU9ZTfYbKY=ZLVjCJY9^TfjBL[=^TW:cKY9bdg:bM]=b/WKc00Moo`03001oogoo031oo`8003]oo`00
3Woo00<007ooOol00Woo0P002Goo01IVDVICIU9VDfIBJW=VDVYcJW9ZLfYbJW=ZLVjCJW9^TfjBKY=^
TVjcK[9b/`9b/P03L]9fdWKB00Moo`03001oogoo02ioo`8003eoo`003Woo00<007ooOol00P0037oo
01UVDVIcIU9ZLfIBJW=VDVYcJW9ZLfYbKY=ZLVjCJY9^/fjBL[=^TW:cK[9bdg:bM]=bdP08Ool00`00
Oomoo`0/Ool2000oOol000ioo`<000ioo`0DIU=VDVYcIU9ZLfIbJW=ZLVYcJW9ZTfYbKY=ZTVjCKY9^
TfjBL[=^/P9b/P03L]=b/WKB00Qoo`03001oogoo02Yoo`80045oo`003Woo0P0047oo01MZLfIBJW=V
DVYcIW9ZLfYbJY=ZLVjCJW9^TfZBK[=^TW:cKY9b/fjbM]=b/WKC00Uoo`03001oogoo02Qoo`8004=o
o`0047oo0P003goo01EVLfIbJW=VDVYcJW9ZLfYbJW=ZTVjCKY9^TfjBK[=^TW:cK[9b/g:bL]802Woo
00<007ooOol09Woo0P00AGoo000BOol3000=Ool056YcIU9ZLfIBJW=ZLVjCJW9^TfYbKY=^TVjcKY9b
/fjBL[=^/W;CL[8:Ool00`00Oomoo`0SOol30017Ool001Eoo`8000]oo`0AIU9ZLfYbJW=ZLVYcJW9Z
TfYbKY=^TVjCKY9^/fjBL[=^/P02L[8;Ool00`00Oomoo`0QOol2001:Ool001Moo`<000Uoo`0AIU9Z
LfIbJW=ZLVjCJW9^TfYbKY=^TVjcKY9b/fjBL[=b/P0<Ool00`00Oomoo`0OOol2001<Ool001Yoo`80
00Qoo`0?JW9ZLfYbJW=ZLVYcJY9^TfjBKY=^TVjcK[9b/g:b00eoo`03001oogoo01eoo`8004ioo`00
77oo0`001Woo00eVDVZCJW9^TfYbKY=ZTVjCKY9b/fjBL[=^TP0>Ool00`00Oomoo`0KOol2001@Ool0
01moo`8000Eoo`0:JW9ZLfYbKY=ZLVjCKY9^TfjBK[<@Ool00`00Oomoo`0IOol2001BOol0025oo`<0
00=oo`07JW9^TfYbKY=ZTVjcKY804Woo00<007ooOol05Woo0`00E7oo000TOol20003Ool00fjCJY9^
T`0DOol00`00Oomoo`0DOol2001GOol002Ioo`<001Moo`03001oogoo019oo`8005Uoo`00:Goo0P00
5Goo00<007ooOol047oo0P00Fgoo000[Ool3000BOol00`00Oomoo`0>Ool2001MOol002ioo`80011o
o`03001oogoo00aoo`8005moo`00<7oo0`003Goo00<007ooOol02Goo0`00HGoo000cOol2000;Ool0
0`00Oomoo`07Ool2001TOol003Eoo`<000Qoo`03001oogoo00Eoo`8006Ioo`00>7oo0P001Woo00<0
07ooOol00goo0P00J7oo000jOol30003Ool01000Oomoogoo0P00JWoo000mOol200000goo001oo`02
001/Ool003moo`<006ioo`00/7oo001QOol200000goo0000001:Ool0069oo`03001oo`0004]oo`00
Hgoo00<007ooOol0BWoo001QOol200000goo0000001:Ool00;1oo`00/7oo002`Ool002Eoo`@008Mo
o`0097oo00@007ooOol008Qoo`0097oo00@007ooOol008Qoo`008goo0P0000=oo`000000R7oo002`
Ool00;1oo`00/7oo002`Ool00;1oo`00/7oo002`Ool00;1oo`00\
\>"],
  ImageRangeCache->{{{0, 175.688}, {177.25, -1.25}} -> {0.0310554, \
-0.0076255, 0.00609651, 0.00609651}}]
}, Open  ]],

Cell[TextData[{
  "This figure shows that the skeleton in the coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " has a singularity in the limit ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] 0\)]],
  ". We also observe the parabolic shape of the surface for large ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-values. Thus, the surface is twisted in two directions, which obviously \
baffles the discovery of the solution. Our goal is to find a transformation \
which reduces the twisted shape to a simpler representation. For the Riccati \
equation, a one-parameter symmetry group is provided by the following scaling \
transformations. ",
  ButtonBox["Ibragimov [1994]",
    ButtonData:>{"Literat.nb", "Ibragimov-1994"},
    ButtonStyle->"Hyperlink"],
  " calls this transformation a non-homogeneous dilation."
}], "Text",
  CellTags->{
  "parabolic surface", "scaling transformation", "non-homogeneous dilation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(transformation = {x \[Rule] r\ Exp[\(-a\)], \n\t\t
        u \[Rule] Function[x, w[x\ Exp[a]]\ Exp[a]]}\)], "Input"],

Cell[BoxData[
    \({x \[Rule] E\^\(-a\)\ r, u \[Rule] Function[x, w[x\ Exp[a]]\ Exp[a]]}
      \)], "Output"]
}, Open  ]],

Cell["\<\
We can check the invariance of the Riccati equation by taking into \
account that the derivatives also need to be transformed by the rule\
\>", 
  "Text",
  Evaluatable->False,
  CellTags->"invariance of the Riccati equation"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"dtrafo", "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["v_", 
            TagBox[\((n_)\),
              Derivative],
            MultilineFunction->None], "[", \(a_. \ x_\), "]"}], 
        "\[RuleDelayed]", 
        RowBox[{\(a\^\(-n\)\), " ", 
          RowBox[{
            SuperscriptBox["v", 
              TagBox[\((n)\),
                Derivative],
              MultilineFunction->None], "[", \(a\ x\), "]"}]}]}]}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["v_", 
          TagBox[\((n_)\),
            Derivative],
          MultilineFunction->None], "[", \(a_. \ x_\), "]"}], 
      "\[RuleDelayed]", 
      RowBox[{\(a\^\(-n\)\), " ", 
        RowBox[{
          SuperscriptBox["v", 
            TagBox[\((n)\),
              Derivative],
            MultilineFunction->None], "[", \(a\ x\), "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The rule ",
  StyleBox["dtrafo",
    FontSlant->"Italic"],
  " represents the fact that the ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th derivative of a function under a scaling is replaced by the ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th derivative divided by the scaling factor ",
  Cell[BoxData[
      \(TraditionalForm\`a\^n\)]],
  ". The application of ",
  StyleBox["transformation",
    FontSlant->"Italic"],
  " and ",
  StyleBox["dtrafo",
    FontSlant->"Italic"],
  " to the Riccati equation gives us"
}], "Text",
  Evaluatable->False,
  CellTags->"scaling factor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(triccati = \(riccati /. transformation\) /. dtrafo; triccati // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(2\ E\^\(2\ a\)\)\/r\^2\),
                    ScriptLevel->0]}], "+", \(E\^\(2\ a\)\ w\^2\), "+", 
                \(E\^\(2\ a\)\ w\_r\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We note that the original equation ",
  StyleBox["riccati",
    FontSlant->"Italic"],
  " is reproduced up to a common factor ",
  Cell[BoxData[
      StyleBox[\(E\^\(2 a\)\),
        "InlineFormula",
        FontFamily->"Times"]]],
  ". In the definition of the transformation, it is essential that we use the \
new variables in the representation for the original variables. ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is simply replaced by the new independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " multiplied by the factor ",
  Cell[BoxData[
      \(TraditionalForm\`E\^\(-a\)\)]],
  ". The dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is replaced by ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SuperscriptBox[
            StyleBox["wE",
              FontSlant->"Italic"], "a"],
          "DisplayFormula"], TraditionalForm]]],
  ". Since ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " depends on the new variable ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ", we have to use the representation of ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " in the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", " ", 
          StyleBox[\(E\^a\),
            "InlineFormula",
            FontSlant->"Italic"]}], TraditionalForm]]],
  ". We also have to take into account that the derivatives need a special \
treatment which is contained in the rule ",
  StyleBox["dtrafo",
    FontSlant->"Italic"],
  ". Combining all these rules in the transformation of the original \
equation, we end up with the equation given in ",
  StyleBox["triccati",
    FontSlant->"Italic"],
  ". The different replacements of variables are actually the steps necessary \
to carry out the transformation by hand. The application of the \
transformation on the first derivative shows us that its behavior is"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[PartialD]\_x u[x] /. transformation\) /. dtrafo // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(E\^\(2\ a\)\ w\_r == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which in conventional notation reads ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(w'\),
            "InlineFormula"], 
          StyleBox[" ",
            "InlineFormula"], "\[Rule]", 
          StyleBox[" ",
            "InlineFormula"], 
          StyleBox[
            RowBox[{\(u'\), 
              FormBox[\(e\^\(\(-2\) a\)\),
                "TraditionalForm"]}],
            "InlineFormula"]}], TraditionalForm]]],
  ". Thus, we observe that the equation's skeleton is invariant under the \
inhomogeneous stretching ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{"r", "\[Rule]", 
            RowBox[{"x", " ", 
              FormBox[\(e\^a\),
                "TraditionalForm"]}]}],
          "InlineFormula"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["w",
            "InlineFormula",
            FontSlant->"Italic"], 
          StyleBox["\[Rule]",
            FontSlant->"Plain"], 
          StyleBox[
            SuperscriptBox["ue", 
              RowBox[{
                StyleBox["-",
                  FontSlant->"Plain"], "a"}]],
            "InlineFormula",
            FontSlant->"Italic"]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(w'\),
            "InlineFormula"], "\[Rule]", 
          StyleBox[\(u' e\^\(\(-2\) a\)\),
            "InlineFormula"]}], TraditionalForm]]],
  " which is obtained by extending the transformations of the group to the \
first derivative ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(u'\),
          "InlineFormula"], TraditionalForm]]],
  ". We can also check the invariance of the skeleton equation by applying \
the extended vector field to the skeleton equation. We define the vector \
field by"
}], "Text",
  CellTags->{
  "invariant skeleton", "inhomogeneous stretching", "extended vector field"}],

Cell[BoxData[
    \(Vect[f_] := 
      x\ \[PartialD]\_x f - u\ \[PartialD]\_u f - 2\ p\ \[PartialD]\_p f\)], 
  "Input"],

Cell["The skeleton of the Riccati equation is ", "Text",
  Evaluatable->False,
  CellTags->"skeleton of the Riccati equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(skeleton = 
      riccati /. {\[PartialD]\_x u[x] \[Rule] p, u[x] \[Rule] u}\)], "Input"],

Cell[BoxData[
    \(p + u\^2 - 2\/x\^2 == 0\)], "Output"]
}, Open  ]],

Cell["The application of the vector field gives us", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Vect/@skeleton\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ p - 2\ u\^2 + 4\/x\^2 == 0\)], "Output"]
}, Open  ]],

Cell[TextData[
"If we compare the two expressions, the original and the transformed, we \
observe that the original equation is reproduced up to a factor \[Dash]2. \
Thus, if the skeleton vanishes, the application of the vector field to the \
skeleton also vanishes. This result shows us that under a scaling \
transformation, the skeleton of the Riccati equation is invariant.\
\[ThickSpace]\[EmptySquare]"], "Text",
  Evaluatable->False],

Cell["Example 2", "Example"],

Cell["\<\
Another example for a first-order ordinary differential equation is\
\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(example2 = 
      \(-\(\[PartialD]\_x u[x]\/x\^2\)\) + 
          \((u[x]\^2\/x\^2 + u[x]\^3\/x)\) == 0; example2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(u\^2\/x\^2\),
                  ScriptLevel->0], "+", 
                StyleBox[\(u\^3\/x\),
                  ScriptLevel->0], "-", 
                StyleBox[\(u\_x\/x\^2\),
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
This example is also invariant with respect to an inhomogeneous \
scaling transformation. We define this sort of transformation by a \
transformation rule like\
\>", "Text",
  Evaluatable->False,
  CellTags->"inhomogeneous scaling transformation"],

Cell[BoxData[{
    RowBox[{
    \(scalingtrafo = {x \[Rule] Exp[\(-a\)]\ r, \n\t\t
          u \[Rule] Function[x, w[x\ Exp[a]]\ Exp[a]]}\), ";", "\n", 
      RowBox[{
        RowBox[{"dtrafo", "=", 
          RowBox[{
            RowBox[{
              SuperscriptBox["v_", 
                TagBox[\((n_)\),
                  Derivative],
                MultilineFunction->None], "[", \(a_. \ x_\), "]"}], 
            "\[RuleDelayed]", 
            RowBox[{\(a\^\(-n\)\), " ", 
              RowBox[{
                SuperscriptBox["v", 
                  TagBox[\((n)\),
                    Derivative],
                  MultilineFunction->None], "[", \(a\ x\), "]"}]}]}]}], 
        ";"}]}], \(scaling[x_] := \(x /. scalingtrafo\) /. dtrafo\)}], "Input"],

Cell[TextData[{
  "The application of the function ",
  StyleBox["scaling[]", "MmaText"],
  " to the second example shows the invariance of this equation"
}], "Text",
  Evaluatable->False,
  CellTags->"scaling[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(scaling[example2] // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\(E\^\(4\ a\)\ w\^2\)\/r\^2\),
                  ScriptLevel->0], "+", 
                StyleBox[\(\(E\^\(4\ a\)\ w\^3\)\/r\),
                  ScriptLevel->0], "-", 
                StyleBox[\(\(E\^\(4\ a\)\ w\_r\)\/r\^2\),
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The graphical representation of the skeleton for this equation is \
created by\
\>", "Text",
  Evaluatable->False,
  CellTags->{"skeleton", "skeleton graphical representation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[u\^2 - x\ u\^3, {x, \(-1\), 1}, {u, \(-2\), 2}, \n\t
      PlotRange \[Rule] All, AxesLabel \[Rule] {"\<x\>", "\<u\>", "\<p\>"}, \n
      \tViewPoint \[Rule] {5.287, 3.905, 3.613}, \n\tMesh \[Rule] False, 
      Ticks \[Rule] None, BoxRatios \[Rule] {1, 3\/5, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.2911 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.15508 1.33719 0 1.33719 [
[.29256 1.24495 -6.10331 0 ]
[.29256 1.24495 5.89669 19 ]
[.24498 -0.00784 -5.86086 -19 ]
[.24498 -0.00784 6.13914 0 ]
[-0.0767 .60501 -12 -5.85525 ]
[-0.0767 .60501 0 13.1448 ]
[ 0 0 0 0 ]
[ 1 1.2911 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.56186 1.2911 m
0 .98363 L
s
gsave
.29256 1.24495 -67.1033 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.03279 .18101 m
.46159 0 L
s
gsave
.24498 -0.00784 -66.8609 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.03279 .18101 m
0 .98363 L
s
gsave
-0.0767 .60501 -73 -9.85525 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.55904 .5391 m
.56186 1.2911 L
s
.56186 1.2911 m
1 1.16201 L
s
1 1.16201 m
.97048 .38826 L
s
.97048 .38826 m
.55904 .5391 L
s
.03279 .18101 m
.46159 0 L
s
.46159 0 m
.45789 .82684 L
s
.45789 .82684 m
0 .98363 L
s
0 .98363 m
.03279 .18101 L
s
.55904 .5391 m
.56186 1.2911 L
s
.56186 1.2911 m
0 .98363 L
s
0 .98363 m
.03279 .18101 L
s
.03279 .18101 m
.55904 .5391 L
s
.97048 .38826 m
.46159 0 L
s
.46159 0 m
.45789 .82684 L
s
.45789 .82684 m
1 1.16201 L
s
1 1.16201 m
.97048 .38826 L
s
0 0 m
1 0 L
1 1.2911 L
0 1.2911 L
closepath
clip
newpath
.779 .546 .582 r
.5591 .55599 .58799 .62665 .55331 .6345 .52451 .58122 Mtetra
.766 .523 .566 r
.52451 .58122 .55331 .6345 .51801 .64248 .48921 .60698 Mtetra
.744 .484 .537 r
.48921 .60698 .51801 .64248 .48208 .65061 .45317 .63327 Mtetra
.697 .407 .48 r
.45317 .63327 .48208 .65061 .4455 .65888 .41637 .66011 Mtetra
.548 .19 .312 r
.41637 .66011 .4455 .65888 .40826 .66731 .37879 .68753 Mtetra
0 0 0 r
.37879 .68753 .40826 .66731 .37033 .67589 .3404 .71553 Mtetra
.9 .938 .828 r
.3404 .71553 .37033 .67589 .33171 .68463 .30118 .74415 Mtetra
.896 .824 .768 r
.30118 .74415 .33171 .68463 .29236 .69353 .2611 .77339 Mtetra
.88 .768 .734 r
.2611 .77339 .29236 .69353 .25226 .7026 .22013 .80327 Mtetra
.869 .738 .715 r
.22013 .80327 .25226 .7026 .21141 .71184 .17824 .83383 Mtetra
.862 .718 .702 r
.17824 .83383 .21141 .71184 .16977 .72126 .1354 .86509 Mtetra
.857 .705 .693 r
.1354 .86509 .16977 .72126 .12731 .73086 .09157 .89706 Mtetra
.853 .696 .687 r
.09157 .89706 .12731 .73086 .08403 .74065 .04673 .92977 Mtetra
.85 .688 .682 r
.04673 .92977 .08403 .74065 .03989 .75064 .00083 .96325 Mtetra
.784 .506 .515 r
.58799 .62665 .61718 .66926 .58243 .66428 .55331 .6345 Mtetra
.764 .456 .465 r
.55331 .6345 .58243 .66428 .54714 .65922 .51801 .64248 Mtetra
.714 .351 .359 r
.51801 .64248 .54714 .65922 .51129 .65408 .48208 .65061 Mtetra
.514 .024 .032 r
.48208 .65061 .51129 .65408 .47487 .64886 .4455 .65888 Mtetra
.444 .879 .881 r
.4455 .65888 .47487 .64886 .43788 .64356 .40826 .66731 Mtetra
.813 .893 .9 r
.40826 .66731 .43788 .64356 .40028 .63817 .37033 .67589 Mtetra
.843 .809 .817 r
.37033 .67589 .40028 .63817 .36208 .63269 .33171 .68463 Mtetra
.845 .763 .772 r
.33171 .68463 .36208 .63269 .32325 .62712 .29236 .69353 Mtetra
.844 .736 .745 r
.29236 .69353 .32325 .62712 .28377 .62147 .25226 .7026 Mtetra
.842 .719 .728 r
.25226 .7026 .28377 .62147 .24364 .61571 .21141 .71184 Mtetra
.84 .706 .715 r
.21141 .71184 .24364 .61571 .20284 .60986 .16977 .72126 Mtetra
.839 .697 .706 r
.16977 .72126 .20284 .60986 .16135 .60392 .12731 .73086 Mtetra
.838 .69 .699 r
.12731 .73086 .16135 .60392 .11914 .59787 .08403 .74065 Mtetra
.837 .684 .693 r
.08403 .74065 .11914 .59787 .07622 .59171 .03989 .75064 Mtetra
.743 .308 .216 r
.61718 .66926 .64652 .689 .61175 .67522 .58243 .66428 Mtetra
.562 .004 0 r
.58243 .66428 .61175 .67522 .57648 .66123 .54714 .65922 Mtetra
.107 .644 .855 r
.54714 .65922 .57648 .66123 .54071 .64705 .51129 .65408 Mtetra
.619 .842 .985 r
.51129 .65408 .54071 .64705 .50442 .63266 .47487 .64886 Mtetra
.746 .807 .901 r
.47487 .64886 .50442 .63266 .4676 .61807 .43788 .64356 Mtetra
.785 .77 .84 r
.43788 .64356 .4676 .61807 .43025 .60326 .40028 .63817 Mtetra
.801 .745 .801 r
.40028 .63817 .43025 .60326 .39235 .58823 .36208 .63269 Mtetra
.809 .727 .774 r
.36208 .63269 .39235 .58823 .35388 .57298 .32325 .62712 Mtetra
.814 .715 .755 r
.32325 .62712 .35388 .57298 .31484 .5575 .28377 .62147 Mtetra
.817 .705 .741 r
.28377 .62147 .31484 .5575 .27521 .54179 .24364 .61571 Mtetra
.819 .697 .73 r
.24364 .61571 .27521 .54179 .23498 .52584 .20284 .60986 Mtetra
.821 .691 .721 r
.20284 .60986 .23498 .52584 .19413 .50964 .16135 .60392 Mtetra
.822 .686 .714 r
.16135 .60392 .19413 .50964 .15265 .4932 .11914 .59787 Mtetra
.823 .682 .708 r
.11914 .59787 .15265 .4932 .11053 .4765 .07622 .59171 Mtetra
.424 .728 .989 r
.64652 .689 .67595 .69155 .64119 .67229 .61175 .67522 Mtetra
.595 .759 .957 r
.61175 .67522 .64119 .67229 .60597 .65278 .57648 .66123 Mtetra
.677 .754 .91 r
.57648 .66123 .60597 .65278 .57028 .633 .54071 .64705 Mtetra
.72 .743 .87 r
.54071 .64705 .57028 .633 .5341 .61296 .50442 .63266 Mtetra
.746 .731 .839 r
.50442 .63266 .5341 .61296 .49743 .59264 .4676 .61807 Mtetra
.763 .722 .814 r
.4676 .61807 .49743 .59264 .46026 .57205 .43025 .60326 Mtetra
.774 .713 .795 r
.43025 .60326 .46026 .57205 .42257 .55117 .39235 .58823 Mtetra
.783 .706 .78 r
.39235 .58823 .42257 .55117 .38436 .53 .35388 .57298 Mtetra
.789 .7 .767 r
.35388 .57298 .38436 .53 .34561 .50853 .31484 .5575 Mtetra
.794 .695 .756 r
.31484 .5575 .34561 .50853 .30631 .48676 .27521 .54179 Mtetra
.797 .691 .747 r
.27521 .54179 .30631 .48676 .26646 .46468 .23498 .52584 Mtetra
.801 .687 .74 r
.23498 .52584 .26646 .46468 .22604 .44229 .19413 .50964 Mtetra
.803 .684 .733 r
.19413 .50964 .22604 .44229 .18503 .41957 .15265 .4932 Mtetra
.805 .681 .727 r
.15265 .4932 .18503 .41957 .14343 .39652 .11053 .4765 Mtetra
.681 .715 .874 r
.67595 .69155 .70543 .68283 .67073 .66067 .64119 .67229 Mtetra
.7 .712 .858 r
.64119 .67229 .67073 .66067 .63558 .63821 .60597 .65278 Mtetra
.716 .709 .843 r
.60597 .65278 .63558 .63821 .59998 .61547 .57028 .633 Mtetra
.728 .706 .83 r
.57028 .633 .59998 .61547 .5639 .59243 .5341 .61296 Mtetra
.738 .703 .818 r
.5341 .61296 .5639 .59243 .52736 .56908 .49743 .59264 Mtetra
.747 .7 .807 r
.49743 .59264 .52736 .56908 .49033 .54543 .46026 .57205 Mtetra
.754 .697 .798 r
.46026 .57205 .49033 .54543 .4528 .52145 .42257 .55117 Mtetra
.76 .695 .79 r
.42257 .55117 .4528 .52145 .41477 .49716 .38436 .53 Mtetra
.765 .692 .782 r
.38436 .53 .41477 .49716 .37622 .47254 .34561 .50853 Mtetra
.77 .69 .775 r
.34561 .50853 .37622 .47254 .33715 .44758 .30631 .48676 Mtetra
.774 .688 .769 r
.30631 .48676 .33715 .44758 .29754 .42228 .26646 .46468 Mtetra
.777 .686 .763 r
.26646 .46468 .29754 .42228 .25739 .39662 .22604 .44229 Mtetra
.78 .684 .758 r
.22604 .44229 .25739 .39662 .21667 .37062 .18503 .41957 Mtetra
.783 .683 .753 r
.18503 .41957 .21667 .37062 .17538 .34424 .14343 .39652 Mtetra
.71 .695 .834 r
.70543 .68283 .73498 .66893 .70037 .64559 .67073 .66067 Mtetra
.715 .695 .83 r
.67073 .66067 .70037 .64559 .66532 .62195 .63558 .63821 Mtetra
.719 .694 .825 r
.63558 .63821 .66532 .62195 .62981 .59801 .59998 .61547 Mtetra
.723 .693 .821 r
.59998 .61547 .62981 .59801 .59385 .57375 .5639 .59243 Mtetra
.727 .692 .817 r
.5639 .59243 .59385 .57375 .55741 .54918 .52736 .56908 Mtetra
.731 .692 .813 r
.52736 .56908 .55741 .54918 .5205 .52429 .49033 .54543 Mtetra
.734 .691 .81 r
.49033 .54543 .5205 .52429 .4831 .49906 .4528 .52145 Mtetra
.737 .69 .806 r
.4528 .52145 .4831 .49906 .4452 .47351 .41477 .49716 Mtetra
.74 .69 .803 r
.41477 .49716 .4452 .47351 .40679 .44761 .37622 .47254 Mtetra
.743 .689 .799 r
.37622 .47254 .40679 .44761 .36787 .42136 .33715 .44758 Mtetra
.746 .688 .796 r
.33715 .44758 .36787 .42136 .32842 .39475 .29754 .42228 Mtetra
.748 .687 .793 r
.29754 .42228 .32842 .39475 .28843 .36778 .25739 .39662 Mtetra
.75 .687 .79 r
.25739 .39662 .28843 .36778 .24789 .34044 .21667 .37062 Mtetra
.753 .686 .787 r
.21667 .37062 .24789 .34044 .20679 .31272 .17538 .34424 Mtetra
.704 .691 .835 r
.73498 .66893 .7647 .65599 .73019 .63236 .70037 .64559 Mtetra
.704 .691 .834 r
.70037 .64559 .73019 .63236 .69523 .60842 .66532 .62195 Mtetra
.705 .691 .834 r
.66532 .62195 .69523 .60842 .65983 .58418 .62981 .59801 Mtetra
.706 .691 .833 r
.62981 .59801 .65983 .58418 .62396 .55962 .59385 .57375 Mtetra
.707 .691 .832 r
.59385 .57375 .62396 .55962 .58763 .53474 .55741 .54918 Mtetra
.55741 .54918 .58763 .53474 .55082 .50954 .5205 .52429 Mtetra
.708 .69 .831 r
.5205 .52429 .55082 .50954 .51352 .484 .4831 .49906 Mtetra
.709 .69 .831 r
.4831 .49906 .51352 .484 .47572 .45812 .4452 .47351 Mtetra
.709 .69 .83 r
.4452 .47351 .47572 .45812 .43742 .4319 .40679 .44761 Mtetra
.71 .69 .829 r
.40679 .44761 .43742 .4319 .3986 .40532 .36787 .42136 Mtetra
.711 .69 .829 r
.36787 .42136 .3986 .40532 .35926 .37838 .32842 .39475 Mtetra
.711 .69 .828 r
.32842 .39475 .35926 .37838 .31938 .35107 .28843 .36778 Mtetra
.712 .69 .827 r
.28843 .36778 .31938 .35107 .27894 .32339 .24789 .34044 Mtetra
.713 .69 .827 r
.24789 .34044 .27894 .32339 .23795 .29532 .20679 .31272 Mtetra
.656 .691 .871 r
.7647 .65599 .79475 .65019 .76031 .6263 .73019 .63236 Mtetra
.658 .691 .87 r
.73019 .63236 .76031 .6263 .72543 .6021 .69523 .60842 Mtetra
.659 .691 .869 r
.69523 .60842 .72543 .6021 .69011 .57759 .65983 .58418 Mtetra
.66 .691 .868 r
.65983 .58418 .69011 .57759 .65432 .55276 .62396 .55962 Mtetra
.661 .691 .868 r
.62396 .55962 .65432 .55276 .61806 .5276 .58763 .53474 Mtetra
.662 .691 .867 r
.58763 .53474 .61806 .5276 .58133 .50212 .55082 .50954 Mtetra
.664 .691 .866 r
.55082 .50954 .58133 .50212 .54412 .47629 .51352 .484 Mtetra
.665 .691 .865 r
.51352 .484 .54412 .47629 .5064 .45013 .47572 .45812 Mtetra
.666 .691 .864 r
.47572 .45812 .5064 .45013 .46818 .42361 .43742 .4319 Mtetra
.667 .691 .863 r
.43742 .4319 .46818 .42361 .42945 .39673 .3986 .40532 Mtetra
.668 .691 .863 r
.3986 .40532 .42945 .39673 .39018 .36949 .35926 .37838 Mtetra
.669 .691 .862 r
.35926 .37838 .39018 .36949 .35038 .34188 .31938 .35107 Mtetra
.67 .691 .861 r
.31938 .35107 .35038 .34188 .31003 .31388 .27894 .32339 Mtetra
.671 .691 .86 r
.27894 .32339 .31003 .31388 .26912 .2855 .23795 .29532 Mtetra
.425 .644 .948 r
.79475 .65019 .82533 .6578 .79091 .63281 .76031 .6263 Mtetra
.456 .653 .945 r
.76031 .6263 .79091 .63281 .75606 .60751 .72543 .6021 Mtetra
.485 .662 .94 r
.72543 .6021 .75606 .60751 .72077 .58188 .69011 .57759 Mtetra
.51 .668 .934 r
.69011 .57759 .72077 .58188 .68502 .55592 .65432 .55276 Mtetra
.532 .673 .928 r
.65432 .55276 .68502 .55592 .6488 .52962 .61806 .5276 Mtetra
.552 .678 .922 r
.61806 .5276 .6488 .52962 .61212 .50299 .58133 .50212 Mtetra
.57 .681 .915 r
.58133 .50212 .61212 .50299 .57495 .476 .54412 .47629 Mtetra
.586 .684 .908 r
.54412 .47629 .57495 .476 .53729 .44866 .5064 .45013 Mtetra
.601 .686 .902 r
.5064 .45013 .53729 .44866 .49914 .42095 .46818 .42361 Mtetra
.614 .687 .895 r
.46818 .42361 .49914 .42095 .46047 .39288 .42945 .39673 Mtetra
.626 .688 .889 r
.42945 .39673 .46047 .39288 .42128 .36442 .39018 .36949 Mtetra
.637 .689 .882 r
.39018 .36949 .42128 .36442 .38156 .33558 .35038 .34188 Mtetra
.647 .69 .876 r
.35038 .34188 .38156 .33558 .3413 .30635 .31003 .31388 Mtetra
.656 .69 .87 r
.31003 .31388 .3413 .30635 .30048 .27671 .26912 .2855 Mtetra
.658 .114 0 r
.82533 .6578 .85672 .68528 .82223 .65747 .79091 .63281 Mtetra
.531 0 0 r
.79091 .63281 .82223 .65747 .78731 .62932 .75606 .60751 Mtetra
0 .178 .627 r
.75606 .60751 .78731 .62932 .75197 .60082 .72077 .58188 Mtetra
0 .331 .778 r
.72077 .58188 .75197 .60082 .71618 .57197 .68502 .55592 Mtetra
.044 .458 .88 r
.68502 .55592 .71618 .57197 .67994 .54275 .6488 .52962 Mtetra
.213 .548 .93 r
.6488 .52962 .67994 .54275 .64324 .51317 .61212 .50299 Mtetra
.343 .606 .946 r
.61212 .50299 .64324 .51317 .60608 .48321 .57495 .476 Mtetra
.44 .641 .942 r
.57495 .476 .60608 .48321 .56845 .45287 .53729 .44866 Mtetra
.512 .661 .929 r
.53729 .44866 .56845 .45287 .53033 .42214 .49914 .42095 Mtetra
.565 .673 .912 r
.49914 .42095 .53033 .42214 .49172 .39101 .46047 .39288 Mtetra
.605 .68 .894 r
.46047 .39288 .49172 .39101 .4526 .35947 .42128 .36442 Mtetra
.636 .684 .878 r
.42128 .36442 .4526 .35947 .41298 .32752 .38156 .33558 Mtetra
.661 .685 .862 r
.38156 .33558 .41298 .32752 .37283 .29515 .3413 .30635 Mtetra
.681 .686 .848 r
.3413 .30635 .37283 .29515 .33214 .26235 .30048 .27671 Mtetra
.885 .516 .339 r
.85672 .68528 .8893 .73946 .85457 .70615 .82223 .65747 Mtetra
.88 .483 .274 r
.82223 .65747 .85457 .70615 .81944 .67246 .78731 .62932 Mtetra
.864 .432 .18 r
.78731 .62932 .81944 .67246 .78391 .63838 .75197 .60082 Mtetra
.823 .345 .034 r
.75197 .60082 .78391 .63838 .74796 .6039 .71618 .57197 Mtetra
.72 .195 0 r
.71618 .57197 .74796 .6039 .7116 .56903 .67994 .54275 Mtetra
.487 0 0 r
.67994 .54275 .7116 .56903 .67481 .53374 .64324 .51317 Mtetra
0 .332 .794 r
.64324 .51317 .67481 .53374 .63758 .49803 .60608 .48321 Mtetra
.211 .526 .92 r
.60608 .48321 .63758 .49803 .59991 .4619 .56845 .45287 Mtetra
.423 .616 .931 r
.56845 .45287 .59991 .4619 .56179 .42534 .53033 .42214 Mtetra
.545 .653 .906 r
.53033 .42214 .56179 .42534 .52321 .38834 .49172 .39101 Mtetra
.618 .667 .875 r
.49172 .39101 .52321 .38834 .48416 .35089 .4526 .35947 Mtetra
.665 .673 .848 r
.4526 .35947 .48416 .35089 .44464 .31299 .41298 .32752 Mtetra
.696 .674 .825 r
.41298 .32752 .44464 .31299 .40464 .27462 .37283 .29515 Mtetra
.718 .674 .806 r
.37283 .29515 .40464 .27462 .36414 .23578 .33214 .26235 Mtetra
.89 .592 .476 r
.8893 .73946 .92351 .82781 .88831 .78524 .85457 .70615 Mtetra
.895 .58 .445 r
.85457 .70615 .88831 .78524 .85276 .74225 .81944 .67246 Mtetra
.899 .562 .4 r
.81944 .67246 .85276 .74225 .81685 .69882 .78391 .63838 Mtetra
.9 .532 .33 r
.78391 .63838 .81685 .69882 .78057 .65495 .74796 .6039 Mtetra
.888 .473 .21 r
.74796 .6039 .78057 .65495 .74392 .61063 .7116 .56903 Mtetra
.822 .344 0 r
.7116 .56903 .74392 .61063 .7069 .56586 .67481 .53374 Mtetra
.557 .043 0 r
.67481 .53374 .7069 .56586 .6695 .52062 .63758 .49803 Mtetra
0 .366 .834 r
.63758 .49803 .6695 .52062 .6317 .47492 .59991 .4619 Mtetra
.384 .568 .909 r
.59991 .4619 .6317 .47492 .59352 .42873 .56179 .42534 Mtetra
.563 .629 .876 r
.56179 .42534 .59352 .42873 .55493 .38207 .52321 .38834 Mtetra
.649 .649 .836 r
.52321 .38834 .55493 .38207 .51594 .33491 .48416 .35089 Mtetra
.697 .655 .805 r
.48416 .35089 .51594 .33491 .47653 .28726 .44464 .31299 Mtetra
.726 .657 .781 r
.44464 .31299 .47653 .28726 .43671 .23909 .40464 .27462 Mtetra
.746 .658 .763 r
.40464 .27462 .43671 .23909 .39645 .19041 .36414 .23578 Mtetra
.89 .622 .526 r
.92351 .82781 .95992 .9588 .92393 .90193 .88831 .78524 Mtetra
.897 .617 .505 r
.88831 .78524 .92393 .90193 .88765 .84462 .85276 .74225 Mtetra
.904 .609 .476 r
.85276 .74225 .88765 .84462 .85109 .78686 .81685 .69882 Mtetra
.913 .595 .429 r
.81685 .69882 .85109 .78686 .81424 .72863 .78057 .65495 Mtetra
.919 .566 .348 r
.78057 .65495 .81424 .72863 .7771 .66994 .74392 .61063 Mtetra
.904 .493 .181 r
.74392 .61063 .7771 .66994 .73965 .61078 .7069 .56586 Mtetra
.736 .259 0 r
.7069 .56586 .73965 .61078 .70191 .55115 .6695 .52062 Mtetra
0 .259 .768 r
.6695 .52062 .70191 .55115 .66386 .49104 .6317 .47492 Mtetra
.41 .534 .871 r
.6317 .47492 .66386 .49104 .6255 .43043 .59352 .42873 Mtetra
.597 .605 .831 r
.59352 .42873 .6255 .43043 .58684 .36934 .55493 .38207 Mtetra
.677 .627 .793 r
.55493 .38207 .58684 .36934 .54785 .30775 .51594 .33491 Mtetra
.719 .636 .765 r
.51594 .33491 .54785 .30775 .50855 .24565 .47653 .28726 Mtetra
.744 .64 .745 r
.47653 .28726 .50855 .24565 .46892 .18304 .43671 .23909 Mtetra
.761 .642 .73 r
.43671 .23909 .46892 .18304 .42897 .11991 .39645 .19041 Mtetra
.893 .64 .549 r
.95992 .9588 .99925 1.14243 .96202 1.06461 .92393 .90193 Mtetra
.901 .639 .532 r
.92393 .90193 .96202 1.06461 .92461 .98641 .88765 .84462 Mtetra
.91 .635 .508 r
.88765 .84462 .92461 .98641 .88703 .90785 .85109 .78686 Mtetra
.922 .629 .47 r
.85109 .78686 .88703 .90785 .84926 .82891 .81424 .72863 Mtetra
.936 .612 .401 r
.81424 .72863 .84926 .82891 .81132 .7496 .7771 .66994 Mtetra
.935 .562 .249 r
.7771 .66994 .81132 .7496 .77319 .66991 .73965 .61078 Mtetra
.774 .342 0 r
.73965 .61078 .77319 .66991 .73489 .58984 .70191 .55115 Mtetra
0 .241 .753 r
.70191 .55115 .73489 .58984 .69639 .50938 .66386 .49104 Mtetra
.464 .513 .823 r
.66386 .49104 .69639 .50938 .65772 .42853 .6255 .43043 Mtetra
.626 .583 .786 r
.6255 .43043 .65772 .42853 .61885 .3473 .58684 .36934 Mtetra
.694 .608 .755 r
.58684 .36934 .61885 .3473 .5798 .26567 .54785 .30775 Mtetra
.731 .619 .734 r
.54785 .30775 .5798 .26567 .54056 .18365 .50855 .24565 Mtetra
.753 .625 .718 r
.50855 .24565 .54056 .18365 .50113 .10123 .46892 .18304 Mtetra
.768 .629 .707 r
.46892 .18304 .50113 .10123 .46151 .0184 .42897 .11991 Mtetra
0 g
.03279 .18101 m
.46159 0 L
s
.46159 0 m
.45789 .82684 L
s
.45789 .82684 m
0 .98363 L
s
0 .98363 m
.03279 .18101 L
s
.97048 .38826 m
.46159 0 L
s
.46159 0 m
.45789 .82684 L
s
.45789 .82684 m
1 1.16201 L
s
1 1.16201 m
.97048 .38826 L
s
.03279 .18101 m
0 .98363 L
s
gsave
-0.0767 .60501 -73 -9.85525 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{154.125, 180.125},
  ImageMargins->{{59, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002J0000]1000`40O003h00OVWoo002JOol009Yo
o`00VWoo002JOol009Yoo`00VWoo000hOol4001NOol003Moo`04001oogoo001OOol003Moo`04001o
ogoo001OOol003Ioo`800003Ool0000005moo`00VWoo002JOol009Yoo`00VWoo002JOol009Yoo`00
VWoo002JOol009Yoo`00DGoo0P00Agoo001?Ool200000goo00000016Ool004eoo`8000=oo`04001o
o`000014Ool004]oo`8000Eoo`05001oogooOol00013Ool004Qoo`<000Ioo`03HWH007oo00=oo`03
001oogoo041oo`00AWoo0P002Goo00=NM@00GWD017oo0P00@7oo0014Ool2000;Ool00f9f001RMP06
Ool00`00Oomoo`0mOol0045oo`<000aoo`05HYINM@00GWERUP06Ool00`00Oomoo`0lOol003moo`80
00moo`05GWERMP00HWINM@07Ool2000lOol003eoo`80015oo`06HWINM@00GWERMUie27oo00<007oo
Ool0>Goo000kOol2000BOol01f9fGWERMP00HWINMF9f00Uoo`03001oogoo03Qoo`00>7oo0`0057oo
00QNMF:FGWD005ieHYINMF9f2Goo00<007ooOol0=goo000fOol2000GOol0269fGWERMP00HWINMF9f
GWD:Ool2000gOol003Aoo`8001Qoo`09HYINMF9fGWD005ieHWINMF:F00aoo`03001oogoo03Aoo`00
<Goo0`006Woo00QNMF9fGWERMP00HWINMF9f0Uif37oo00<007ooOol0<goo000_Ool2000MOol02V:G
GWERUUie001NMF:FGWENMUiE3Goo0P00<goo000]Ool2000NOol025jFGWIRMUieHWH0069fGWD4GWH>
Ool00`00Oomoo`0`Ool002]oo`80021oo`09GWIRUeifHWINM@00GWERMUiE00=NMPmoo`03001oogoo
02moo`00:7oo0`008Woo00MNUUifGYINMV9f001RMP06GWH?Ool00`00Oomoo`0^Ool002Ioo`8002Ao
o`08HYMNMV:GGWIRUeif001NM@=NMP03GUENMUif011oo`8002ioo`0097oo0P009Woo00MNMUjFGWIN
UUifGYH00008GWHAOol00`00Oomoo`0[Ool0029oo`8002Moo`08GWIRUeifHYMNMV:GGWH0009NMP06
GUENMUifGWINEEif4Woo00<007ooOol0:Woo000ROol3000VOol02EjFGWINUUifGYINMUjF001NM`06
GWH00eYfOomoo`0AOol2000ZOol0029oo`04001oogoo000TOol02UjHFYMRUeifHYMNMV:GGWH005Yf
0eif00ENEEifGWINMeYF01Aoo`03001oogoo02Moo`008Woo00@007ooOomoo`80025oo`9NU`0:GYQN
UejFGWINUUifGWL005jGGWL4GWH2FWH00eigOomoo`0COol00`00Oomoo`0VOol0029oo`03001oogoo
00=oo`03001oogoo01ioo`0=FYMNV5ZGGYQNMV:GGWINUeYf001JMUjGGUD00eif00AJEUigFUINMaEo
o`8002Ioo`008Woo00<007ooOol017oo0P007Goo00=NUejHGYL00UjG00INV5ifGYINMejG0002GWL0
1EjGGWINMUYfGWL00eYf5goo00<007ooOol08goo000ROol00`00Oomoo`06Ool00`00Oomoo`0IOol0
5eZGGYQJUejHFYMNV5ZGGYQJMUjGFWH005YfGYMJMUifGUENMeYFGWMJEUigFUH05goo00<007ooOol0
8Woo000ROol00`00Oomoo`07Ool2000HOol00eZIF[UNU`02GYL00ejHGYMNU`02FYP2GWL00`00GYMN
M`03GWL3FWH00eigFWIJMP0HOol00`00Oomoo`0QOol0029oo`03001oogoo00Uoo`03001oogoo01=o
o`0;F[UFV5ZiFYQJ^EZGGYQJUejHFYMNV002FYP03UYf001JMUjGFWIJV5YgGWMJEUigFUINMeYFGWLH
Ool2000QOol0029oo`03001oogoo00Yoo`80019oo`08F[UJVEZiFYUJ^EZIF[UJV@9NU`EJV004001N
MeigGYL2FWL00eYfGWMJMP02FWH00eigFWIoo`0IOol00`00Oomoo`0NOol0029oo`03001oogoo00ao
o`03001oogoo00aoo`0=E[]B^UJjDYYJ^EZHF[UFV5ZiFYQJ^EJHGYP00UZH015JUejHFYP005YfGYMJ
MeZHFWMJV5YFGWMJEUigFUIFMeIG01Yoo`03001oogoo01eoo`008Woo00<007ooOol03Goo00<007oo
Ool01goo1E:k15Jj00QJ^EZIF[UJVEZiFYUF^UJI1EZH00<005jGGWL00UYg00EJN5YgFWMJMUig009J
MP03EUMFMgoo01Yoo`8001eoo`008Goo00<007ooOol03goo0P001Woo01AB^UJkC[YB^e:jD[]>^UJk
D[YF^U:JE[]JV5ZiEYUJ^UJIF[YFVEjH0UZH011JU`00FYQJV5YgFYQJMeZHFWMJV5YFGWMFEeYhEUMF
Maaoo`03001oogoo01Yoo`008Goo00<007ooOol04Goo00T007ooOomooeJkD[YB^e:jE[/01U:k15Jj
00IFVEJjEYUF^EJIE[X4FYP01000EYUFVEYh0eYg00EJN5YgFWIJMUIg00=FEaeoo`03001oogoo01Uo
o`008Goo00<007ooOol04Goo02eF^EZjE[UJ^UJiE[]B^UJkD[YF^e:jD[]B^U:kC[YB^e:jD[]BVUJk
EYUJ^UJIF[YFVEZjFYMNV5JH001FN5ZIEYQJV5YgFYQJMeZHFWMJN5IGEWMFEeYhEUL07Goo00<007oo
Ool067oo000QOol00`00Oomoo`0@Ool2G[P00eZiF[YJ^@02F[T01UZjD[YB^e:jE[]B^P=B^`0<C[]B
^e:jD[]B^U:kD[YF^UJIE[UFVEJj0UJI00H005JIEYUFVEYgFWP3FWL01EIiDWQFEeIGEWL00UIG7Woo
0P0067oo000QOol00`00Oomoo`0@Ool0;ejhGYQN^EJiF[YF^EZjE[UJ^U:jE[]B^UJkD[YB^djkD[]>
^e:kC[]B^e:JE[]B^U:kDYYF^e:JE[YFN000EYQJVEIhFYUJMeZHDWQFNE9hEWUFEeYhEUMFMeIGFWP0
7goo00<007ooOol05Goo000QOol00`00Oomoo`0?Ool6G[P02UZjF[UJ^EZiF[YB^U:kD[YF^e:j0e:k
00=>^e:kD[/01Djk00EBVU:jDYYB^P0000EFV@03EWQFNE9h009FN006EWUFEeIGEUMFMeIG87oo00<0
07ooOol057oo000QOol00`00Oomoo`0>Ool00ejhGYQN^@02G[P0;EjHG[UN^5ZjE[UJ^UJiF[YF^EJk
D[YF^e:jE[]B^U:kC[]B_4jkD[]>Ve:kC[]B^e:JE[]BVP00DYYJVEJHFYU>NE:JDWQFNE9hEWUBN5Ig
EUMJN5IGEWMFE`0POol2000DOol0025oo`03001oogoo00eoo`9R]`QN^005F[YJ^EZiF[UJ^P02F[T0
1U:jE[]B^U:kD[YB^`=>^`03D[]>^djk009>^`04DYYB^P00D[X6DYX00eIhEWUBN002EWP01EIgEUMF
EeIGCUP08Woo00<007ooOol04Goo000QOol00`00Oomoo`0=Ool0=6:GH[MRUf:gGYQN^EjhG[UJV5ji
G[QN^EJiF[YF^EZjE[UJ^U:jE[]B^UJkD[YF^djkD[a>^e:kC[]B^djkD[]:VP00BY]>^dZJDYY>NE:J
CWUBVU9hEWUBN5IiEUMFMdhhCUU>>4iH8Woo00<007ooOol047oo000QOol00`00Oomoo`0<Ool6H[L9
G[P2F[T02EZjF[UJ^EZiE[]B^U:kD[YF^`03C[/01TjlC[]:_4ZkB[`000A>V`EBVP04EWQFNE9hEWP2
CUP00dhhCUQ>F00SOol2000@Ool0025oo`03001oogoo00]oo`0gHYMR]f:GH[MRUf:gHYMR^5ZHG[UN
^5jiFYQN^EjhG[UJV5ZjE[UJ^UJiF[YF^EZjD[YF^e:jE[]>^djlC[]>_4jkC[a:V`00BY]>^dZKC[]:
VU:JCWUBVTiiDYY:FDYjBUU:NThhCUQ>>4iICSP097oo00<007ooOol03Goo000QOol00`00Oomoo`0;
Ool:H[L6G[P03UjiG[QN^5ZiF[YJ^EZjF[UJ^U:jD[]B^UJkD[X2C[/01TjlC[]:_000B[a:^`A>V`E6
N`03BUU:FTYI00=>F003CSQ>F7oo02=oo`8000ioo`008Goo00<007ooOol02Woo02MR]f:GH[MRUf:g
HYMR]ejGH[QR]f:hGYMR^5jhG[UJV5jiG[QN^EZHG[UF^EZjE[UJ^UJiF[YF^EJkD[YF^e:jC[a>^djl
C[/004JLA[`00TJL00A2W4JL@W]6V`=6N`08BWY:FDYjBUU>FDhhCUQ>>25oo`<00003Ool007oo00eo
o`008Goo00<007ooOol02Woo00=V]V:gH[L02f:g00=N^5jiG[P00Ujh00iN^EjhG[QJ^EZjF[UJ^UZi
F[YJ^E:kD[YB^e:j0djl00D004JlAYa6_4JL0092W003AYa2W4Ik00=6N`04BUY:FDYJBUT3CUP00dhh
Oomoo`0LOol20004Ool00`00Oomoo`0<Ool0025oo`03001oogoo00Uoo`0`HYIV]f:FI[MRUf:gHYMR
^6:gH[QNUf:hH[MR^5jGH[QN]ejiFYQN^EZhG[UJ^5jiF[QJ^UJiF[YF^EZjE[UF^e:jE[]B^UJkB[/0
04ZKC[a6W4JlAYa6_D:LAYa2NdJK0dIk00M:NTYIBWY:FDiICSQ>F00KOol30006Ool00`00Oomoo`0<
Ool0025oo`03001oogoo00Uoo`IV]PQR]`05H[QR]f:gH[MR^003G[P06UjiG[QN^5jhG[UF^EZjF[UJ
^UJiF[YB^U:kD[YB^`00C[a:^djlAYa6_4JLA[a2W4JL@Y`3AW/01DYIBUY:FDYJCSP00diH5goo0`00
2Goo00<007ooOol037oo000QOol00`00Oomoo`09Ool0<6:FI[MRUVJgHYIV]f:fI[MNUf:hH[MR^5jG
H[QN]f:hGYMR^5jgH[QJ^5jiF[QN^EZhG[UJ^5jiE[UJ^UJiF[YF^EZjD[YF^e:j001B^TZlBY]>_3jL
@YdnW4:m<U`fO@8bG009;S`b?4YIBWY:FDYjCSQ>FDhh01Eoo`8000aoo`03001oogoo00aoo`008Goo
00<007ooOol027oo1VJf00QR]VJfI[IV]f:fI[IR]f:h0f:g00IR^6:gH[QR]f:hH[L2G[P02ejiG[QN
^EjhG[UN^5ZjF[UJ^UJiF[X00U:k00@005:kD[]B^`=:_006@YdnW3jM?YdfOC9M0bhl138K0cWi4Goo
0`003Woo00<007ooOol037oo000QOol00`00Oomoo`08Ool0?FJgHYIV]f:FI[MRUVJgHYIV]f:fI[MR
UVJgG[MR^5jGH[QN]f:hG[MR^5jgH[QN]ejiF[QN^EZhG[UJ^5jiF[QJ^UJiF[YF^EZjE[T005:jE[]B
^UJkBY]>_4ZkB[`nW4:m?Y`fOC9L=Wd^?38l<QXb6c8J>QXenCXJ00ioo`<0015oo`03001oogoo00ao
o`008Goo00<007ooOol027oo1fJf00IV]f:fI[IV]VJgH[H2I[L03V:hH[MR^6:gH[QR]f:hH[MR^5jh
H[QN^5jiG[P3G[T02EZhF[YJ^EZjE[UJ^P00F[YB^P03D[/4B[`013Im=YdfOAXM0QXL00<^?38K<Q/0
0S8K00<j6CWi>OT02goo0P0057oo00<007ooOol037oo000QOol00`00Oomoo`07Ool0?f:FI[MRUVJg
HYIV]f:FI[MR]VJgHYIV]f:fI[MRUVJgH[IR^5jgH[QN]f:hG[MR^5jgH[QN]f:hG[MN^EZhG[UJ^5ji
F[QN^EJiF[YF^@00E[UJ^U:jE[]B^UJkD[Y:_4JlB[a6W3JN=WdJ7AGl6Qd^?38K<QXb6cGi>QXen@08
Ool3000FOol00`00Oomoo`0<Ool0025oo`03001oogoo00Moo`IV]P06I[MR]VJfI[IV]f:f0fJg00UR
]VJgH[MV]f:gH[QR]f:hG[P00f:h0ejh00=N^EZhG[T00Uji00UJ^5jiF[UJ^P00F[YJ^EZjE[T00e:k
00=B^TZlB[`00TZl00<fWCIm6Qd00QXL00L1NS8K<Q/b6cWi>QTin@04Ool3000IOol00`00Oomoo`0<
Ool0021oo`03001oogoo00Qoo`11IYEZ]V:FI[MRUVJgH[IV]f:FI[MR]VJgHYIV]f:fI[MR]VJgH[MV
]f:fI[MN]f:hG[MR^5jgH[QN^6;HG[QR^5ZhG[UJ^5jiF[QN^EZh001F^EZjE[UJ^UJiE[]B^U:kD[Y:
_DJLA[e6W2Yn:UdJ7AGl6Qd1F@4H<QXj6SGi>QYoo`03000MOol00`00Oomoo`0;Ool0021oo`03001o
ogoo00Moo`9V]P05I[EV]VJfI[MR]P02I[H00fJgH[IV]`02I[L026:fI[MV]fJgH[MV]f:gI[L2H[L2
H[P015jhH[QN^6:h0ejh00iR^5jhG[UJ^EjiF[UN^@00G[UF^EZjF[UJ^UJi0e:k00=B^U:kA[`00dJl
00LZG@5I0CP1F05j0?P0m`02>OT00cXIOomoo`0NOol00`00Oomoo`0;Ool0021oo`03001oogoo00Mo
o`0oJ[IVUFZfIYEZ]VJeJ[IRUVJgH[IV]f:FI[MR]VJgHYIV]f:gI[MR]VJgH[MV]f:gI]QR]f:hG[MR
f5jhH[QN^6;HG[QR^EjhG[UJ^5jiF[P005ZiG[UF^EZjE[UJ^UJiF[YB^U:kD[YF^e:jA[e6W4Zm:UdZ
OP4h0ET0m`4H0080m`03=OUoogoo01ioo`03001oogoo00]oo`0087oo00<007ooOol01goo00=V]FJf
I[H01fJf0VJg00QR]VJgI[MV]f:gI[MR]fJg0f:g00EV]f:gH[MR]f:h00=N^003H[QN^5jh00AN^003
F[UN^@00009J^@07G[UJ^EZjF[UJ^UJiF[X00U:k00eB^U:kD[]6_D:LA[dJ7AXm6Qd1F03g0?P0e`02
0?LOOol00`00Oomoo`0;Ool0021oo`03001oogoo00Ioo`14IYEZ]VJEJ[IVUFZfIYEZ]VJeJ[IVUFZf
I[IZ]VJfJ[IR]fJgH[IV]f:gI[MR]fKHH[MV]f:gI]QR]f;HG[QRf5jhH[UN^6;IG[QR^EjhH]UJ^@00
F[QN^EZiG[UJ^5jiE[UJ^UJiF[YF^E:kD[YF^e:jD[]2W4Jm@Y`J?AHL0ET0m`4H0=L0mamoo`03001o
ogoo00]oo`0087oo00<007ooOol01Woo0fJf00=V]FJfI[H036Jf00EV]f:gI[MR]fJg00=R]`06I[MR
]f:hH[MRf6:g25jh00=N^@00G[T00eZi00YN^EZiF[UF^EZjE[UJ^UJiF[YB^P=B^`0:@Ya6_DJl6SdJ
7AXm0?L0n03G0?LNOol00`00Oomoo`0;Ool0021oo`03001oogoo00Ioo`15IYEZ]VJEJ[IVUFZfI[EZ
]VJEJ[IV]VZfI[IZ]VJfI]MV]V[GI[IVef:gI]QR]fJgH[MVf6:gH]QR]fKHH[MRf6:gH]QN^6:iG[QR
fEjhG]UN^000G[QN^EZhG]UJ^EjiF[UNfEZiF[YF^EZjE[UJ^U:jE[]B^U:k@Ya2_D:L1M/5^`GLF>00
m`3G01ioo`03001oogoo00]oo`0087oo00<007ooOol01Woo00=V]VJeI[H04FJf00YVefJfH[MR]fJg
H[MR^6:gH]QR]`9R^00=H]QR^6;HH[QRf5jhG[UN^5ji001N^EjhG[T00eZi00YN^EZiF[UJ^EZjE[UJ
^UJiF[YF^@AB^`08@[e2WD:m1K/5feSP0?L0eaeoo`03001oogoo00]oo`0087oo00<007ooOol01Goo
04MZ]VJEJ[IVUFZfI[EZ]VJEJ[IV]FZfI[IZ]VJfJ[IV]V[GI[IVefJfJ]MV]VKGI[IZefJfH]QR]fKH
H[MRf6:gH]QR^6;HH[MRf5jhH]UN^6;IG[P005jhG]UN^5kIF[UNfEZiG[UJ^EkJF[UJ^UJiF[YF^EZj
E[UF^e:jD[]B^T:m@Ya2_@Fk1MaHh03g01eoo`03001oogoo00]oo`0087oo00<007ooOol01Goo00=V
]FJfI[H04VJf00AVefJgI]MV]P=Ve`07H[MR^6:gH]QR^6;HH[P016;H00ERfF;HG[T005kI00=N^@03
G]UN^EZi00IJ^@05E[UJ^UJiF[YF^@05D[/01SjM?[d1>0GKHD00maaoo`03001oogoo00]oo`0087oo
00<007ooOol01Goo01]Z]VJEJ[IVUFZfIYEZ]VJeJ[IV]VZfI[IZ]VJfJ[IV]VKGI[IZefJfI]MV]V[G
I[IVefJgI]P00VKG02]V]f;HH[QRf6:gH]QR^6;IG[QRfEjhH]UN^000G[QNfEZhG]UN^5kIF[UNfUZi
G[UJ^EkJF[UN^EJiF[YF^EZjE[UJ^U:jD[]B^U:kD[Y2_CjL0EP0e`0LOol00`00Oomoo`0;Ool0021o
o`03001oogoo00Aoo`=V]P03I[EV]VJf00iV]P04I]MV]fKGI[H6I]L3I]P00f:hH]QR^002H]P02F;I
H]QRf6;HH]T005kIG[UNf@02G[T015ZiG]UJ^Eji1UZi00IF^EZjE[YJ^UJiF[X5D[/013jM>YeQ@03g
6goo00<007ooOol02goo000;Ool3000BOol00`00Oomoo`04Ool06VJEJ[IVUFZfIYEZ]VJeJ[IVUFZf
I[IZ]VJfJ[IV]VKGI[IZefJfI]MV]V[GI[IVefJfI]P2I]L04VJgI]QVefKhH]MVn6KGH]UN^6;IG[QR
fEjhH]UNf@00G]URf@9Nf@0KF[UNfUZiG]UJ^EkJF[UJ^UZiG]YJ^EZjF[UJ^UJiF[YF^EZjD[YB^e:j
D[]B^U:k>YeQ@6E101Yoo`03001oogoo00]oo`0037oo00<007ooOol04Goo00<007ooOol017oo16Ze
46Jf00AVefJfI]MV]`EVe`EVf0=Vn@04H_QVnFKiH]T2G]T00`00H]UNf@02G]X01ekjF[UN^EZiG]UJ
^E[J00MJ^@06F[YF^UZjE[UJ^UJj1E:k00=Q@6g6ID406Goo00<007ooOol02goo000<Ool3000AOol0
0`00Oomoo`04Ool066JeJ[EVUFZfI[EZ]VJeJ[IV]F[FI[EZeVJeJ]IV]V[GI[IVefJfJ]MV]VKGI[IZ
e`9Ve`0cI[MVf6KGI_QRefKhI]MVn6;HI_URf6KiH]QS6V;jHaYNf@00G]UNnU[IG_YJfEkjF]UNfUZi
G]YJ^EkJF[UNfUZiG]YJ^EZjF[UJfUJiF[YF^EZjE[UB^e:jD[]B^U:kGB1aiVE101Qoo`03001oogoo
00]oo`0037oo00@007ooOol0011oo`03001oogoo00=oo`UZ]@0>J[IZ]FZfJ[EZ]VZeJ]IZ]V[FJ[IZ
eVJfI]MV]`IVe`EVf09Vn@05H_QVnFKiHaYRnP03HaX01000G]YNfUkj0ekJ0U[k00MJfUZiF]YJ^E[J
F[UJfP03F[T02EZjF[UJ^EZiF[YF^EZjE[YJ^P04D[/0177ULPYU@FfU5Woo00<007ooOol02goo000<
Ool01000Oomoo`0047oo00<007ooOol00goo055Z]FJEJ[IV]FZfI[EZ]VJeJ[IV]F[FI[EZeVJeJ]IZ
]V[FI[EZeVZfJ]MVeV[GJ]IZmf[FJ_MZeVKhH]MVn6KGI_QRefKiH]QVnF;HHaYRnV<JH_US6V;j001K
6ellF]UNnU[IF_]JfU[kF]YJneZiG]YJ^E[JF[YJfUJiF]YJ^EZjF[UJfUZiF[YF^EZjE[UJ^UJiD[]B
^V50LRYb2VV4KJD05Goo00<007ooOol02goo000;Ool4000AOol00`00Oomoo`03Ool9J[D016ZfJ[EZ
]VZe0VZf00AZeVZfJ]IZ]PAZeP08J_MZef[gJ]MZmf[hJaQZm`9Zn006I_URn6KiI_US6V;j0f<J0Ull
00<005llGc`00Ull1e[k0U[J015J^U[JF]YJfUZjF]YJ^EZjF[UJ^UZiF[YF^EZjE[YJ^UJi009B^`03
LNE]aG8:009]YAAoo`03001oogoo00]oo`0087oo00<007ooOol00goo01YZ]VJeJ[EVUFZfI[EZ]VJe
J[IV]F[FI[EZeVJeJ]IV]F[FJ[IZeVKFJ]MZeV[GJ]IZmf[F0V[g00E[66[gJaQZmf/j009[>@0aIaUW
W6MkIiaWNfNLFa]O?5/K001K6dmOBci?Gd]NCem;?TmOD_aFo5;lEaaBo5[JE[UJfUZjF]]F^U[KF[UJ
^UJiF]YJ^EZjE[UJ^UJiF[YF^EZjGD1f:Vh9LPYYQ6gXKLL04Woo00<007ooOol02goo000POol00`00
Oomoo`02Ool:J[D026ZfJ[EZ]VZeJ]IZ]V[FJ[H5J]H01f[GJ_MZef[gJ]M[66[g009Zn0E[>@04IgaW
W6MlIi`2=g/00c`Q@2400002?2402T0Q?24l8@Yj3YX:NPZJ2WYFo5;l0eKl0eKJ00IJfeKJE]YFfUZj
F[T3F[X03EJiF[YF^UZjE[UJ^WHWMRYb2G8/KJE]j6g8015oo`03001oogoo00]oo`0087oo00<007oo
Ool00Woo021V]FZeIYEZ]VJeJ[IV]FZfI[EZeVJeJ]IV]F[FI[EZeVZfJ]IV]F[GJ]IZefKFJ_MZeV[g
J]I[66[gJaQZmf/H0V/i00IW6F/jIg]WW6MkA:T5Ool00`00Oomoo`07Ool080jK2WX>Vd[mBai:oD/N
B_eJfeJjF]]F^U[KE[YJ^UJiF]YF^EZjE[UJ^UJiF[Yoof50LRYf:Vh9LRa]afgXKLL@Ool00`00Oomo
o`0;Ool0021oo`03001oogoo009oo`YZ]@08J[IZ]FZfJ[EZeVZfJ]IZ]PAZeP04J_MZef[gJ]L2J_L2
J_P00f/HJcU[>@02JcT300000dBYOomoo`04Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00d[nB_e:
oP06E]/01EJiF[YJ^UZjE[T017oo00=f9g8ZLTd00W8/00A]b6gXKNY^2Pioo`03001oogoo00]oo`00
87oo00<007ooOol00Woo015VUFZfI[EZ]FJeJ[IV]FZfI[EZeVJeJ]IV]F[FJ[IZeVJe009ZeP06J]MV
eV[GJ]IZmf[F0V[g00M[66[gJaQ_^G>jKkUc^P030008Ool00`00Oomoo`08Ool00`00Oomoo`05Ool0
2C;N=_lbgUKKD[YFfe;KE]]B^P07Ool02W86MVab:W8:KP]b;6g7KNQ]jG8:3Woo00<007ooOol02Woo
000OOol00`00Oomoo`03Ool8J[D016ZfJ[EZ]VZe0VZf00AZeVZfJ]IZ]P=ZeP09J]MZmf[GJ_MZeg<h
LcMc>6lg009c^@04LkX000000009Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00cKO<]lfg`0<Ool0
0gHWLRYbC@02LR`0179=KLQ^2VgZ3Woo00<007ooOol02Woo000OOol00`00Oomoo`02Ool08VZfI[EZ
]FJEJ[IV]FZfI[EZ]VJeJ]IV]F[FI[EZeVJeJ]IZ]V[GI]IZef[FKaM^mW<GK_I_5flgLeQ_=g>jKkUc
^Vni0P002Woo00<007ooOol027oo00<007ooOol05Woo00Yf9g9;MR]bC78/KP]bCVg7LPY]j@eoo`03
001oogoo00Yoo`007goo00<007ooOol00Woo2FZe00AZ]VZeJ[IZ]@9Z]P06J]IZ]V[FK]I^mVkF0Vkf
00]_5fkfKaIc=g<hKcMc>7>iLkYc^@0000aoo`03001oogoo00Qoo`03001oogoo01Moo`09MVafC79=
LTib;6h]LTe]jVh:00eoo`03001oogoo00Yoo`007goo00<007ooOol00Woo021Z]FJEJ[IV]FZeI[EZ
]VJeJ[IV]F[FI[EZeVJeJ]IZ]VkFJ[E^mV[FK_IZeG<GK_I_5fkfLeQ_=g=HKkUc^Vni3Woo00<007oo
Ool027oo00<007ooOol05goo00Yf9gI/LRYfCG9>LRa^;G9?KNUb2Paoo`03001oogoo00Yoo`007goo
00<007ooOol00Woo2FZe01IZ]VZeJ[IZ]FkFJ]E^eF[EK_I^eVkfK]I_5fkfKaI^mW<hKcMc>7<gLkYc
^@moo`03001oogoo00Qoo`03001oogoo01Qoo`09MTafK79<LTib;79=KRe^CVgZ00aoo`03001oogoo
00Yoo`007goo01T007ooOomoofJEJ[IV]FZeIYEZ]VJeJ[IV]FkFJ[E^eFZeK]IZeFkFJ[E^eV[FK_IZ
e@02K_H01flGK_Ic5flgLeQ_=g>j015oo`03001oogoo00Qoo`03001oogoo01Qoo`0:MVafBgI^LTab
Kfh[LTe^;W9?KNT;Ool00`00Oomoo`0:Ool001moo`04001oogooOol:J[D04f[EJ[E^eFZeK]EZeFkF
J]E^mVkFK_I^eVlFK_I_5flgLcQc=g<h019oo`03001oogoo00Qoo`03001oogoo01Uoo`03MVafC79=
009bCP04LRebCFi>KTh;Ool00`00Oomoo`0:Ool001moo`0I001oogooOomZ]6ZeJ[A^]FZdK]EZ]6kE
J[E^eFZeK]IZ]FkFJ[E^eV[EK]IZeFkfJ]H00Vkf00Ec5fkfLeQ_=g=H01=oo`03001oogoo00Qoo`03
001oogoo01Uoo`09LT]fK79^LVi^CW9`KRebCVh^00]oo`03001oogoo00Yoo`007goo00@007ooOomo
o`QZ]@04J]EZ]FkEJ[D2J]D01VkFJ]E^eFkFK_I^eP9^mP04KaM^mW<hLcLEOol00`00Oomoo`08Ool0
0`00Oomoo`0JOol02GI<MVibCG9^LTibKg8]LTi^CP0:Ool00`00Oomoo`0:Ool001moo`0L001oogoo
OomZ]6jeJ[AZ]FZdK]EZ]FkEJ[E^eVZeK]EZ]FkFJ]E^eVZeK_IZeVkfJ]Ec5fkfKaLGOol00`00Oomo
o`08Ool00`00Oomoo`0JOol02GI/LT]fSW9>LVi^Cg9>KTibCP0:Ool00`00Oomoo`0:Ool001moo`03
001oogoo00UZ]@08K]EZ]F[EJ[E^eF[EK]EZe@9^eP05K_I^eVkfK_I_5P0HOol00`00Oomoo`08Ool0
0`00Oomoo`0KOol02GI/LVibCG9>LVm^Cg9=KTibCP09Ool00`00Oomoo`0:Ool001moo`0J001oogoo
K[EZ]6ZeJ[A^]FZeK]EZ]6kEJ[E^eFZeK]IZeFkFJ[E^eV[FK_IZeFkfJ]I_5aUoo`03001oogoo00Qo
o`03001oogoo01]oo`09MT]fKW9^LVmbCW9_KTmbCfi>00Uoo`03001oogoo00Yoo`007goo00<007oo
Ool02FZe00eZeFZeK]EZ]FkEJ]E^eV[EK_I^eVkfK]I_5P0JOol00`00Oomoo`08Ool00`00Oomoo`0L
Ool017I<MVibKg9>0W9_00=^L6i>Ool027oo00<007ooOol02Woo000OOol06000OomoofZeJ[A^]FZd
K]EZ]6kEJ[E^eFZeK]IZ]FkEJ[E^eV[EK]IZeFkfJ]I^mQ]oo`03001oogoo00Qoo`03001oogoo01ao
o`09MVabKWI^KTibKfi?LVm^Cg9?00Qoo`03001oogoo00Yoo`007goo00<007ooOol02FZe00]^eFZe
J]EZ]FkFJ]E^eF[EK_I^eVkf01aoo`03001oogoo00Qoo`03001oogoo01eoo`04MVibKW9_LTh2LVl0
0g9`KTioo`07Ool00`00Oomoo`0:Ool001moo`0E001oofZdK[EZ]6ZeJ[A^eFZeK]EZ]6kFJ[E^eFZe
K]IZeFkFJ[E^mV[F01eoo`8000Yoo`03001oogoo01eoo`09LT]fSW9_LY1^Cg9`KVmbL6h^00Moo`03
001oogoo00Yoo`007goo00<007ooJ[D02FZe00MZeFZeK]EZeFkEJ]E^eP0LOol30002Ool20008Ool0
0`00Oomoo`0NOol0279^LVmbKg9^KTmbKfi`LW07Ool00`00Oomoo`0:Ool001moo`0B001oofZdJ[EZ
]6jeJ[E^eFZdK]EZ]FkEJ[E^eVZeK]IZ]FkF6Woo0`001goo0P001Woo00<007ooOol07Woo00=fKW9^
LY000W9_00=^Cg9`KVl01goo00<007ooOol02Woo000OOol00`00OomZ]@07J[D016[EJ[E^eFZe0V[E
00=^eWooOol05Woo0`0037oo00<007ooOol00goo00<007ooOol07goo00EfKW9_LVmbL79_00=^L0Io
o`03001oogoo00Yoo`007goo00l007ooJ[A^]FZdJ[EZ]6kEJ[E^eFZeK]IZ]FkEJ[D067oo0P0047oo
0P000goo00<007ooOol07goo00QbKW:@LVmbT6i?LW1^Cg9`1Woo00<007ooOol02Woo000OOol00`00
J[EZ]@07J[D016kEJ[EZeFZe5Woo0`0057oo00@007ooOol0029oo`07LVibKg9_LW1bKg9`KW001Woo
00<007ooOol02Woo000OOol03@00K[EZ]6ZeJ[A^eFZeK]EZ]6kFJ[E^eFZe01Aoo`<001Qoo`<0029o
o`07MXibKg:@KW1bL6i_LW001goo00<007ooOol02Goo000NOol00`00OomZ]@08J[D00f[EOomoo`0A
Ool3000MOol2000ROol2LVl01G:@LW1^L6i`LW001Woo00<007ooOol02Goo000NOol02P00OomZ]FZd
K[EZ]6kEJ[A^eFZe4Woo0`0087oo00<007oo00008Goo00MbKg:@LVmbT6i?LW1^K`06Ool00`00Oomo
o`09Ool001ioo`03001Z]FZe00IZ]A1oo`<002=oo`03001oogoo0080021oo`9bK`04LW1bT6i`KW06
Ool00`00Oomoo`09Ool001ioo`08001Z]6jeJ[AZ]FZdK]EZ]@ioo`<002Ioo`03001oogoo009oo`03
001oogoo01eoo`07LY1bKg:@KW1bTFi?LW001Goo00<007ooOol02Goo000NOol00`00J[EZ]@03J[D=
Ool3000YOol00`00Oomoo`03Ool2000NOol01W9_LW1bL6i`LW1^L0Eoo`03001oogoo00Uoo`007Woo
00D006ZdJ[EZ]6je00]oo`<002aoo`03001oogoo00Eoo`8001aoo`06LVmbT6i`LY1^L79`1Goo00<0
07ooOol02Goo000NOol01000J[EZ]FZe2Woo0P00;goo00<007ooOol01goo00<007ooOol06Woo00Eb
Kg:@LW1bLFi`00Eoo`03001oogoo00Uoo`007Woo00<006ZdK[D027oo0`00<Goo00<007ooOol027oo
0P006Woo00IbT6i`LY1^L7:AKVl4Ool00`00Oomoo`09Ool001ioo`03001oogoo00Eoo`<003Aoo`03
001oogoo00Yoo`03001oogoo01Qoo`9bL003LY5^L79a00Aoo`03001oogoo00Uoo`007Woo00<007oo
Ool00Woo0`00=goo00<007ooOol02goo0P0067oo00EbKg:@KW1bTFi`00Aoo`03001oogoo00Uoo`00
7Woo00<007oo00000P00>Woo00<007ooOol03Goo0P005goo0W9`00=^L7:AOol00goo00<007ooOol0
2Goo000NOol2000mOol00`00Oomoo`0?Ool00`00Oomoo`0DOol01G:@KW1bTFi`LY400goo00<007oo
Ool02Goo000OOol2000lOol00`00Oomoo`0@Ool2000DOol01G9`LY1^L79aKW000goo00<007ooOol0
2Goo000QOol2000jOol00`00Oomoo`0BOol00`00Oomoo`0BOol016i`LY5^L7:A0goo00<007ooOol0
2Goo000SOol2000hOol00`00Oomoo`0COol2000BOol2LW000g:AKW1oo`02Ool00`00Oomoo`09Ool0
02Eoo`8003Ioo`03001oogoo01Eoo`80015oo`04LY1^L7:AKW02Ool00`00Oomoo`09Ool002Moo`03
001oogoo03=oo`03001oogoo01Moo`03001oogoo00ioo`04LW1bLFi`LY42Ool00`00Oomoo`09Ool0
02Qoo`8003=oo`03001oogoo01Qoo`8000moo`03KW1bTFi`009oo`03001oogoo00Uoo`00:Woo0P00
<Goo00<007ooOol06Woo00<007ooOol037oo00=bT6i`LW400Woo00<007ooOol02Goo000/Ool2000_
Ool00`00Oomoo`0KOol2000=Ool01G:AKW1bTGoo00002goo000^Ool2000]Ool00`00Oomoo`0MOol2
000;Ool01Fi`LY5^L7oo00002goo000`Ool00`00Oomoo`0ZOol00`00Oomoo`0OOol00`00Oomoo`09
Ool01Fi`LY5oogoo00002Woo000aOol2000ZOol00`00Oomoo`0POol20009Ool01G9aKW1oogoo0000
2Woo000cOol2000XOol00`00Oomoo`0ROol00`00Oomoo`07Ool017:AKW1oo`002Woo000eOol2000V
Ool00`00Oomoo`0SOol20007Ool016i`LW5oo`002Woo000gOol2000TOol00`00Oomoo`0UOol20006
Ool00fi`Ool0000:Ool003Uoo`03001oogoo025oo`03001oogoo02Moo`03001oogoo00=oo`03LY5o
o`0000Yoo`00>Woo0P008Goo00<007ooOol0:7oo0P0017oo00=bT@00Ool02Goo000lOol2000OOol0
0`00Oomoo`0ZOol01P00OomoogooKW0000Yoo`00?Woo0P007Goo00<007ooOol0:goo0P000Woo00<0
07ooOol027oo0010Ool2000KOol00`00Oomoo`0]Ool3000:Ool0049oo`03001oogoo01Qoo`03001o
ogoo02ioo`8000Yoo`00@goo0P0067oo00<007ooOol0:goo0`0037oo0015Ool2000FOol00`00Oomo
o`0WOol4000?Ool004Moo`8001Aoo`03001oogoo02Aoo`<001=oo`00BGoo0P004Woo00<007ooOol0
8Goo0`005Woo001;Ool00`00Oomoo`0?Ool00`00Oomoo`0MOol4000IOol004aoo`8000moo`03001o
ogoo01Yoo`<001eoo`00CWoo0P003Goo00<007ooOol05goo0`0087oo001@Ool2000;Ool00`00Oomo
o`0COol4000SOol0059oo`8000Uoo`03001oogoo011oo`<002Moo`00E7oo00<007ooOol01Woo00<0
07ooOol03Goo0`00:Woo001EOol20006Ool00`00Oomoo`09Ool4000]Ool005Moo`8000Aoo`03001o
ogoo00Ioo`<0035oo`00FGoo0P000Woo00<007ooOol00goo0`00=7oo001KOol300000goo00000002
000gOol005eoo`8003]oo`00>goo0P0000=oo`000000FWoo000lOol00`00Ool0001KOol003eoo`03
001oogoo05Yoo`00>goo0P0000=oo`000000FWoo002JOol009Yoo`00VWoo002JOol009Yoo`00VWoo
002JOol009Yoo`00VWoo0000\
\>"],
  ImageRangeCache->{{{0, 153.125}, {179.125, 0}} -> {-0.0868974, -0.132004, \
0.00663874, 0.00663874}}]
}, Open  ]],

Cell["\<\
This three-dimensional representation of the skeleton looks like a \
stingray. The structure of this entangled surface is simplified if we apply \
the following canonical transformation:\
\>", "Text",
  Evaluatable->False,
  CellTags->"canonical transformation"],

Cell[BoxData[{
    \(\(canonical = {x \[Rule] Exp[t], u \[Rule] Function[x, w[Log[x]]\/x]}; 
    \)\), 
    \(canonicaltransform[x_] := 
      Simplify[PowerExpand[\n\t\t\tx /. canonical]]\)}], "Input"],

Cell["The transformation is carried out by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(canonicaltransform[Thread[example2\ Exp[4\ t], Equal]] // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(w + w\^2 + w\^3 - w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The related skeleton simplifies the surface:", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[w + w\^2 + w\^3, {t, \(-1\), 1}, {w, \(-2\), 2}, \n\t
      PlotRange \[Rule] All, ViewPoint \[Rule] {2.460, \(-1.182\), 2.000}, \n
      \tAxesLabel \[Rule] {"\<t\>", "\<w\>", "\<w'\>"}, \n\t
      ViewPoint \[Rule] {5.287, 3.905, 3.613}, \n\tPlotPoints \[Rule] 30, 
      Mesh \[Rule] False, Ticks \[Rule] None, \n\t
      BoxRatios \[Rule] {1, 3\/5, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.3929 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.273905 1.46403 0 1.46403 [
[.11554 .27502 -12 -12.6017 ]
[.11554 .27502 0 6.3983 ]
[.72714 .00641 -1.75732 -19 ]
[.72714 .00641 10.2427 0 ]
[1.0531 .57514 0 -6.39074 ]
[1.0531 .57514 20 12.6093 ]
[ 0 0 0 0 ]
[ 1 1.3929 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.06876 .56114 m
.40529 0 L
s
gsave
.11554 .27502 -73 -16.6017 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.40529 0 m
.90636 .18624 L
s
gsave
.72714 .00641 -62.7573 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.90636 .18624 m
1 .96984 L
s
gsave
1.0531 .57514 -61 -10.3907 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
79.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.06876 .56114 m
0 1.28979 L
s
0 1.28979 m
.50579 1.3929 L
s
.50579 1.3929 m
.499 .68638 L
s
.499 .68638 m
.06876 .56114 L
s
.40529 0 m
.90636 .18624 L
s
.90636 .18624 m
1 .96984 L
s
1 .96984 m
.39338 .80427 L
s
.39338 .80427 m
.40529 0 L
s
.06876 .56114 m
0 1.28979 L
s
0 1.28979 m
.39338 .80427 L
s
.39338 .80427 m
.40529 0 L
s
.40529 0 m
.06876 .56114 L
s
.499 .68638 m
.90636 .18624 L
s
.90636 .18624 m
1 .96984 L
s
1 .96984 m
.50579 1.3929 L
s
.50579 1.3929 m
.499 .68638 L
s
0 0 m
1 0 L
1 1.3929 L
0 1.3929 L
closepath
clip
newpath
.311 .226 .596 r
.48869 1.28516 .50561 1.37336 .51921 1.36158 .50196 1.27294 Mtetra
.50196 1.27294 .51921 1.36158 .533 1.34963 .51542 1.26056 Mtetra
.51542 1.26056 .533 1.34963 .54699 1.33752 .52907 1.248 Mtetra
.52907 1.248 .54699 1.33752 .56118 1.32522 .54291 1.23526 Mtetra
.54291 1.23526 .56118 1.32522 .57558 1.31275 .55695 1.22234 Mtetra
.55695 1.22234 .57558 1.31275 .59019 1.30009 .5712 1.20923 Mtetra
.5712 1.20923 .59019 1.30009 .60501 1.28725 .58565 1.19593 Mtetra
.58565 1.19593 .60501 1.28725 .62006 1.27421 .60031 1.18244 Mtetra
.60031 1.18244 .62006 1.27421 .63533 1.26098 .61519 1.16874 Mtetra
.61519 1.16874 .63533 1.26098 .65083 1.24755 .63029 1.15485 Mtetra
.63029 1.15485 .65083 1.24755 .66657 1.23392 .64561 1.14074 Mtetra
.64561 1.14074 .66657 1.23392 .68255 1.22008 .66117 1.12643 Mtetra
.66117 1.12643 .68255 1.22008 .69878 1.20602 .67696 1.11189 Mtetra
.67696 1.11189 .69878 1.20602 .71526 1.19174 .693 1.09714 Mtetra
.693 1.09714 .71526 1.19174 .732 1.17724 .70928 1.08215 Mtetra
.70928 1.08215 .732 1.17724 .749 1.16251 .72582 1.06694 Mtetra
.72582 1.06694 .749 1.16251 .76627 1.14755 .74261 1.05148 Mtetra
.74261 1.05148 .76627 1.14755 .78382 1.13235 .75967 1.03578 Mtetra
.75967 1.03578 .78382 1.13235 .80166 1.11689 .777 1.01983 Mtetra
.777 1.01983 .80166 1.11689 .81979 1.10119 .79461 1.00363 Mtetra
.79461 1.00363 .81979 1.10119 .83821 1.08523 .81251 .98716 Mtetra
.81251 .98716 .83821 1.08523 .85694 1.069 .8307 .97042 Mtetra
.8307 .97042 .85694 1.069 .87599 1.0525 .84918 .95341 Mtetra
.84918 .95341 .87599 1.0525 .89536 1.03572 .86797 .93612 Mtetra
.86797 .93612 .89536 1.03572 .91506 1.01866 .88708 .91853 Mtetra
.88708 .91853 .91506 1.01866 .93509 1.0013 .90651 .90066 Mtetra
.90651 .90066 .93509 1.0013 .95547 .98365 .92627 .88247 Mtetra
.92627 .88247 .95547 .98365 .97621 .96568 .94637 .86398 Mtetra
.94637 .86398 .97621 .96568 .99732 .9474 .96681 .84516 Mtetra
.32 .239 .606 r
.47231 1.20874 .48869 1.28516 .50196 1.27294 .48529 1.19616 Mtetra
.48529 1.19616 .50196 1.27294 .51542 1.26056 .49846 1.18341 Mtetra
.49846 1.18341 .51542 1.26056 .52907 1.248 .5118 1.17048 Mtetra
.5118 1.17048 .52907 1.248 .54291 1.23526 .52534 1.15736 Mtetra
.52534 1.15736 .54291 1.23526 .55695 1.22234 .53907 1.14407 Mtetra
.53907 1.14407 .55695 1.22234 .5712 1.20923 .55299 1.13058 Mtetra
.55299 1.13058 .5712 1.20923 .58565 1.19593 .56711 1.1169 Mtetra
.56711 1.1169 .58565 1.19593 .60031 1.18244 .58144 1.10303 Mtetra
.58144 1.10303 .60031 1.18244 .61519 1.16874 .59597 1.08895 Mtetra
.59597 1.08895 .61519 1.16874 .63029 1.15485 .61072 1.07466 Mtetra
.61072 1.07466 .63029 1.15485 .64561 1.14074 .62568 1.06017 Mtetra
.62568 1.06017 .64561 1.14074 .66117 1.12643 .64087 1.04545 Mtetra
.64087 1.04545 .66117 1.12643 .67696 1.11189 .65628 1.03052 Mtetra
.65628 1.03052 .67696 1.11189 .693 1.09714 .67193 1.01537 Mtetra
.67193 1.01537 .693 1.09714 .70928 1.08215 .68782 .99998 Mtetra
.68782 .99998 .70928 1.08215 .72582 1.06694 .70394 .98436 Mtetra
.70394 .98436 .72582 1.06694 .74261 1.05148 .72032 .96849 Mtetra
.72032 .96849 .74261 1.05148 .75967 1.03578 .73695 .95238 Mtetra
.73695 .95238 .75967 1.03578 .777 1.01983 .75385 .93602 Mtetra
.75385 .93602 .777 1.01983 .79461 1.00363 .77101 .91939 Mtetra
.77101 .91939 .79461 1.00363 .81251 .98716 .78844 .90251 Mtetra
.78844 .90251 .81251 .98716 .8307 .97042 .80615 .88535 Mtetra
.80615 .88535 .8307 .97042 .84918 .95341 .82415 .86791 Mtetra
.82415 .86791 .84918 .95341 .86797 .93612 .84245 .85019 Mtetra
.84245 .85019 .86797 .93612 .88708 .91853 .86104 .83218 Mtetra
.86104 .83218 .88708 .91853 .90651 .90066 .87995 .81387 Mtetra
.87995 .81387 .90651 .90066 .92627 .88247 .89917 .79525 Mtetra
.89917 .79525 .92627 .88247 .94637 .86398 .91871 .77632 Mtetra
.91871 .77632 .94637 .86398 .96681 .84516 .93859 .75706 Mtetra
.331 .255 .619 r
.45634 1.14265 .47231 1.20874 .48529 1.19616 .46907 1.12977 Mtetra
.46907 1.12977 .48529 1.19616 .49846 1.18341 .48198 1.1167 Mtetra
.48198 1.1167 .49846 1.18341 .5118 1.17048 .49506 1.10346 Mtetra
.49506 1.10346 .5118 1.17048 .52534 1.15736 .50833 1.09004 Mtetra
.50833 1.09004 .52534 1.15736 .53907 1.14407 .52178 1.07642 Mtetra
.52178 1.07642 .53907 1.14407 .55299 1.13058 .53541 1.06262 Mtetra
.53541 1.06262 .55299 1.13058 .56711 1.1169 .54925 1.04862 Mtetra
.54925 1.04862 .56711 1.1169 .58144 1.10303 .56328 1.03442 Mtetra
.56328 1.03442 .58144 1.10303 .59597 1.08895 .57751 1.02001 Mtetra
.57751 1.02001 .59597 1.08895 .61072 1.07466 .59194 1.0054 Mtetra
.59194 1.0054 .61072 1.07466 .62568 1.06017 .60659 .99057 Mtetra
.60659 .99057 .62568 1.06017 .64087 1.04545 .62145 .97553 Mtetra
.62145 .97553 .64087 1.04545 .65628 1.03052 .63654 .96026 Mtetra
.63654 .96026 .65628 1.03052 .67193 1.01537 .65184 .94477 Mtetra
.65184 .94477 .67193 1.01537 .68782 .99998 .66738 .92904 Mtetra
.66738 .92904 .68782 .99998 .70394 .98436 .68315 .91308 Mtetra
.68315 .91308 .70394 .98436 .72032 .96849 .69917 .89687 Mtetra
.69917 .89687 .72032 .96849 .73695 .95238 .71542 .88041 Mtetra
.71542 .88041 .73695 .95238 .75385 .93602 .73193 .8637 Mtetra
.73193 .8637 .75385 .93602 .77101 .91939 .7487 .84673 Mtetra
.7487 .84673 .77101 .91939 .78844 .90251 .76573 .82949 Mtetra
.76573 .82949 .78844 .90251 .80615 .88535 .78304 .81198 Mtetra
.78304 .81198 .80615 .88535 .82415 .86791 .80061 .79419 Mtetra
.80061 .79419 .82415 .86791 .84245 .85019 .81847 .77611 Mtetra
.81847 .77611 .84245 .85019 .86104 .83218 .83663 .75773 Mtetra
.83663 .75773 .86104 .83218 .87995 .81387 .85507 .73906 Mtetra
.85507 .73906 .87995 .81387 .89917 .79525 .87383 .72008 Mtetra
.87383 .72008 .89917 .79525 .91871 .77632 .89289 .70078 Mtetra
.89289 .70078 .91871 .77632 .93859 .75706 .91228 .68116 Mtetra
.343 .274 .633 r
.4407 1.08566 .45634 1.14265 .46907 1.12977 .45321 1.07251 Mtetra
.45321 1.07251 .46907 1.12977 .48198 1.1167 .46588 1.05919 Mtetra
.46588 1.05919 .48198 1.1167 .49506 1.10346 .47873 1.04568 Mtetra
.47873 1.04568 .49506 1.10346 .50833 1.09004 .49175 1.03199 Mtetra
.49175 1.03199 .50833 1.09004 .52178 1.07642 .50496 1.01811 Mtetra
.50496 1.01811 .52178 1.07642 .53541 1.06262 .51835 1.00403 Mtetra
.51835 1.00403 .53541 1.06262 .54925 1.04862 .53192 .98976 Mtetra
.53192 .98976 .54925 1.04862 .56328 1.03442 .54569 .97528 Mtetra
.54569 .97528 .56328 1.03442 .57751 1.02001 .55965 .9606 Mtetra
.55965 .9606 .57751 1.02001 .59194 1.0054 .57382 .94571 Mtetra
.57382 .94571 .59194 1.0054 .60659 .99057 .58819 .9306 Mtetra
.58819 .9306 .60659 .99057 .62145 .97553 .60276 .91528 Mtetra
.60276 .91528 .62145 .97553 .63654 .96026 .61755 .89973 Mtetra
.61755 .89973 .63654 .96026 .65184 .94477 .63256 .88395 Mtetra
.63256 .88395 .65184 .94477 .66738 .92904 .64779 .86793 Mtetra
.64779 .86793 .66738 .92904 .68315 .91308 .66325 .85168 Mtetra
.66325 .85168 .68315 .91308 .69917 .89687 .67894 .83518 Mtetra
.67894 .83518 .69917 .89687 .71542 .88041 .69488 .81843 Mtetra
.69488 .81843 .71542 .88041 .73193 .8637 .71105 .80142 Mtetra
.71105 .80142 .73193 .8637 .7487 .84673 .72748 .78415 Mtetra
.72748 .78415 .7487 .84673 .76573 .82949 .74416 .76662 Mtetra
.74416 .76662 .76573 .82949 .78304 .81198 .7611 .74881 Mtetra
.7611 .74881 .78304 .81198 .80061 .79419 .77831 .73071 Mtetra
.77831 .73071 .80061 .79419 .81847 .77611 .79579 .71233 Mtetra
.79579 .71233 .81847 .77611 .83663 .75773 .81355 .69365 Mtetra
.81355 .69365 .83663 .75773 .85507 .73906 .83161 .67467 Mtetra
.83161 .67467 .85507 .73906 .87383 .72008 .84995 .65539 Mtetra
.84995 .65539 .87383 .72008 .89289 .70078 .8686 .63578 Mtetra
.8686 .63578 .89289 .70078 .91228 .68116 .88756 .61585 Mtetra
.358 .296 .65 r
.4253 1.03669 .4407 1.08566 .45321 1.07251 .43761 1.02332 Mtetra
.43761 1.02332 .45321 1.07251 .46588 1.05919 .45008 1.00977 Mtetra
.45008 1.00977 .46588 1.05919 .47873 1.04568 .46272 .99603 Mtetra
.46272 .99603 .47873 1.04568 .49175 1.03199 .47553 .98211 Mtetra
.47553 .98211 .49175 1.03199 .50496 1.01811 .48851 .968 Mtetra
.48851 .968 .50496 1.01811 .51835 1.00403 .50168 .95369 Mtetra
.50168 .95369 .51835 1.00403 .53192 .98976 .51503 .93919 Mtetra
.51503 .93919 .53192 .98976 .54569 .97528 .52856 .92448 Mtetra
.52856 .92448 .54569 .97528 .55965 .9606 .54229 .90956 Mtetra
.54229 .90956 .55965 .9606 .57382 .94571 .55621 .89443 Mtetra
.55621 .89443 .57382 .94571 .58819 .9306 .57033 .87908 Mtetra
.57033 .87908 .58819 .9306 .60276 .91528 .58466 .86352 Mtetra
.58466 .86352 .60276 .91528 .61755 .89973 .59919 .84772 Mtetra
.59919 .84772 .61755 .89973 .63256 .88395 .61393 .8317 Mtetra
.61393 .8317 .63256 .88395 .64779 .86793 .6289 .81544 Mtetra
.6289 .81544 .64779 .86793 .66325 .85168 .64408 .79894 Mtetra
.64408 .79894 .66325 .85168 .67894 .83518 .65949 .78219 Mtetra
.65949 .78219 .67894 .83518 .69488 .81843 .67513 .76519 Mtetra
.67513 .76519 .69488 .81843 .71105 .80142 .69101 .74793 Mtetra
.69101 .74793 .71105 .80142 .72748 .78415 .70714 .73041 Mtetra
.70714 .73041 .72748 .78415 .74416 .76662 .72351 .71262 Mtetra
.72351 .71262 .74416 .76662 .7611 .74881 .74014 .69455 Mtetra
.74014 .69455 .7611 .74881 .77831 .73071 .75702 .6762 Mtetra
.75702 .6762 .77831 .73071 .79579 .71233 .77418 .65756 Mtetra
.77418 .65756 .79579 .71233 .81355 .69365 .7916 .63862 Mtetra
.7916 .63862 .81355 .69365 .83161 .67467 .80931 .61938 Mtetra
.80931 .61938 .83161 .67467 .84995 .65539 .8273 .59983 Mtetra
.8273 .59983 .84995 .65539 .8686 .63578 .84558 .57996 Mtetra
.84558 .57996 .8686 .63578 .88756 .61585 .86417 .55976 Mtetra
.376 .321 .669 r
.41008 .9948 .4253 1.03669 .43761 1.02332 .4222 .98124 Mtetra
.4222 .98124 .43761 1.02332 .45008 1.00977 .43449 .96749 Mtetra
.43449 .96749 .45008 1.00977 .46272 .99603 .44694 .95356 Mtetra
.44694 .95356 .46272 .99603 .47553 .98211 .45956 .93944 Mtetra
.45956 .93944 .47553 .98211 .48851 .968 .47235 .92513 Mtetra
.47235 .92513 .48851 .968 .50168 .95369 .48532 .91063 Mtetra
.48532 .91063 .50168 .95369 .51503 .93919 .49846 .89592 Mtetra
.49846 .89592 .51503 .93919 .52856 .92448 .51179 .88101 Mtetra
.51179 .88101 .52856 .92448 .54229 .90956 .52531 .86589 Mtetra
.52531 .86589 .54229 .90956 .55621 .89443 .53902 .85055 Mtetra
.53902 .85055 .55621 .89443 .57033 .87908 .55292 .835 Mtetra
.55292 .835 .57033 .87908 .58466 .86352 .56702 .81923 Mtetra
.56702 .81923 .58466 .86352 .59919 .84772 .58132 .80322 Mtetra
.58132 .80322 .59919 .84772 .61393 .8317 .59583 .78699 Mtetra
.59583 .78699 .61393 .8317 .6289 .81544 .61056 .77052 Mtetra
.61056 .77052 .6289 .81544 .64408 .79894 .6255 .7538 Mtetra
.6255 .7538 .64408 .79894 .65949 .78219 .64066 .73684 Mtetra
.64066 .73684 .65949 .78219 .67513 .76519 .65605 .71963 Mtetra
.65605 .71963 .67513 .76519 .69101 .74793 .67167 .70215 Mtetra
.67167 .70215 .69101 .74793 .70714 .73041 .68753 .68441 Mtetra
.68753 .68441 .70714 .73041 .72351 .71262 .70363 .6664 Mtetra
.70363 .6664 .72351 .71262 .74014 .69455 .71998 .64811 Mtetra
.71998 .64811 .74014 .69455 .75702 .6762 .73658 .62953 Mtetra
.73658 .62953 .75702 .6762 .77418 .65756 .75345 .61067 Mtetra
.75345 .61067 .77418 .65756 .7916 .63862 .77058 .5915 Mtetra
.77058 .5915 .7916 .63862 .80931 .61938 .78798 .57204 Mtetra
.78798 .57204 .80931 .61938 .8273 .59983 .80566 .55226 Mtetra
.80566 .55226 .8273 .59983 .84558 .57996 .82362 .53216 Mtetra
.82362 .53216 .84558 .57996 .86417 .55976 .84188 .51173 Mtetra
.396 .35 .69 r
.39497 .95916 .41008 .9948 .4222 .98124 .40693 .94543 Mtetra
.40693 .94543 .4222 .98124 .43449 .96749 .41905 .93151 Mtetra
.41905 .93151 .43449 .96749 .44694 .95356 .43133 .91742 Mtetra
.43133 .91742 .44694 .95356 .45956 .93944 .44378 .90313 Mtetra
.44378 .90313 .45956 .93944 .47235 .92513 .4564 .88865 Mtetra
.4564 .88865 .47235 .92513 .48532 .91063 .46919 .87397 Mtetra
.46919 .87397 .48532 .91063 .49846 .89592 .48215 .85909 Mtetra
.48215 .85909 .49846 .89592 .51179 .88101 .4953 .844 Mtetra
.4953 .844 .51179 .88101 .52531 .86589 .50863 .8287 Mtetra
.50863 .8287 .52531 .86589 .53902 .85055 .52214 .81319 Mtetra
.52214 .81319 .53902 .85055 .55292 .835 .53585 .79746 Mtetra
.53585 .79746 .55292 .835 .56702 .81923 .54975 .78151 Mtetra
.54975 .78151 .56702 .81923 .58132 .80322 .56385 .76532 Mtetra
.56385 .76532 .58132 .80322 .59583 .78699 .57816 .74891 Mtetra
.57816 .74891 .59583 .78699 .61056 .77052 .59267 .73225 Mtetra
.59267 .73225 .61056 .77052 .6255 .7538 .60739 .71535 Mtetra
.60739 .71535 .6255 .7538 .64066 .73684 .62233 .6982 Mtetra
.62233 .6982 .64066 .73684 .65605 .71963 .6375 .6808 Mtetra
.6375 .6808 .65605 .71963 .67167 .70215 .65289 .66313 Mtetra
.65289 .66313 .67167 .70215 .68753 .68441 .66851 .6452 Mtetra
.66851 .6452 .68753 .68441 .70363 .6664 .68438 .627 Mtetra
.68438 .627 .70363 .6664 .71998 .64811 .70048 .60851 Mtetra
.70048 .60851 .71998 .64811 .73658 .62953 .71683 .58974 Mtetra
.71683 .58974 .73658 .62953 .75345 .61067 .73344 .57068 Mtetra
.73344 .57068 .75345 .61067 .77058 .5915 .75031 .55132 Mtetra
.75031 .55132 .77058 .5915 .78798 .57204 .76744 .53166 Mtetra
.76744 .53166 .78798 .57204 .80566 .55226 .78485 .51168 Mtetra
.78485 .51168 .80566 .55226 .82362 .53216 .80254 .49138 Mtetra
.80254 .49138 .82362 .53216 .84188 .51173 .82051 .47075 Mtetra
.419 .383 .713 r
.37992 .92901 .39497 .95916 .40693 .94543 .39173 .91514 Mtetra
.39173 .91514 .40693 .94543 .41905 .93151 .40371 .90108 Mtetra
.40371 .90108 .41905 .93151 .43133 .91742 .41584 .88684 Mtetra
.41584 .88684 .43133 .91742 .44378 .90313 .42813 .8724 Mtetra
.42813 .8724 .44378 .90313 .4564 .88865 .44059 .85777 Mtetra
.44059 .85777 .4564 .88865 .46919 .87397 .45322 .84294 Mtetra
.45322 .84294 .46919 .87397 .48215 .85909 .46603 .82791 Mtetra
.46603 .82791 .48215 .85909 .4953 .844 .47901 .81267 Mtetra
.47901 .81267 .4953 .844 .50863 .8287 .49217 .79722 Mtetra
.49217 .79722 .50863 .8287 .52214 .81319 .50551 .78155 Mtetra
.50551 .78155 .52214 .81319 .53585 .79746 .51904 .76567 Mtetra
.51904 .76567 .53585 .79746 .54975 .78151 .53276 .74955 Mtetra
.53276 .74955 .54975 .78151 .56385 .76532 .54668 .73321 Mtetra
.54668 .73321 .56385 .76532 .57816 .74891 .5608 .71663 Mtetra
.5608 .71663 .57816 .74891 .59267 .73225 .57513 .69982 Mtetra
.57513 .69982 .59267 .73225 .60739 .71535 .58966 .68275 Mtetra
.58966 .68275 .60739 .71535 .62233 .6982 .6044 .66544 Mtetra
.6044 .66544 .62233 .6982 .6375 .6808 .61937 .64787 Mtetra
.61937 .64787 .6375 .6808 .65289 .66313 .63456 .63004 Mtetra
.63456 .63004 .65289 .66313 .66851 .6452 .64997 .61194 Mtetra
.64997 .61194 .66851 .6452 .68438 .627 .66562 .59357 Mtetra
.66562 .59357 .68438 .627 .70048 .60851 .68151 .57491 Mtetra
.68151 .57491 .70048 .60851 .71683 .58974 .69764 .55597 Mtetra
.69764 .55597 .71683 .58974 .73344 .57068 .71402 .53674 Mtetra
.71402 .53674 .73344 .57068 .75031 .55132 .73066 .5172 Mtetra
.73066 .5172 .75031 .55132 .76744 .53166 .74756 .49736 Mtetra
.74756 .49736 .76744 .53166 .78485 .51168 .76473 .47721 Mtetra
.76473 .47721 .78485 .51168 .80254 .49138 .78217 .45673 Mtetra
.78217 .45673 .80254 .49138 .82051 .47075 .79989 .43592 Mtetra
.445 .42 .737 r
.36489 .90368 .37992 .92901 .39173 .91514 .37657 .88968 Mtetra
.37657 .88968 .39173 .91514 .40371 .90108 .38841 .8755 Mtetra
.38841 .8755 .40371 .90108 .41584 .88684 .40041 .86113 Mtetra
.40041 .86113 .41584 .88684 .42813 .8724 .41256 .84656 Mtetra
.41256 .84656 .42813 .8724 .44059 .85777 .42488 .8318 Mtetra
.42488 .8318 .44059 .85777 .45322 .84294 .43737 .81684 Mtetra
.43737 .81684 .45322 .84294 .46603 .82791 .45002 .80168 Mtetra
.45002 .80168 .46603 .82791 .47901 .81267 .46285 .7863 Mtetra
.46285 .7863 .47901 .81267 .49217 .79722 .47586 .77072 Mtetra
.47586 .77072 .49217 .79722 .50551 .78155 .48905 .75491 Mtetra
.48905 .75491 .50551 .78155 .51904 .76567 .50242 .73889 Mtetra
.50242 .73889 .51904 .76567 .53276 .74955 .51599 .72264 Mtetra
.51599 .72264 .53276 .74955 .54668 .73321 .52974 .70616 Mtetra
.52974 .70616 .54668 .73321 .5608 .71663 .54369 .68944 Mtetra
.54369 .68944 .5608 .71663 .57513 .69982 .55785 .67248 Mtetra
.55785 .67248 .57513 .69982 .58966 .68275 .57221 .65527 Mtetra
.57221 .65527 .58966 .68275 .6044 .66544 .58678 .63781 Mtetra
.58678 .63781 .6044 .66544 .61937 .64787 .60157 .6201 Mtetra
.60157 .6201 .61937 .64787 .63456 .63004 .61657 .60212 Mtetra
.61657 .60212 .63456 .63004 .64997 .61194 .6318 .58387 Mtetra
.6318 .58387 .64997 .61194 .66562 .59357 .64726 .56534 Mtetra
.64726 .56534 .66562 .59357 .68151 .57491 .66296 .54654 Mtetra
.66296 .54654 .68151 .57491 .69764 .55597 .67889 .52744 Mtetra
.67889 .52744 .69764 .55597 .71402 .53674 .69507 .50806 Mtetra
.69507 .50806 .71402 .53674 .73066 .5172 .71151 .48837 Mtetra
.71151 .48837 .73066 .5172 .74756 .49736 .7282 .46837 Mtetra
.7282 .46837 .74756 .49736 .76473 .47721 .74515 .44805 Mtetra
.74515 .44805 .76473 .47721 .78217 .45673 .76238 .42741 Mtetra
.76238 .42741 .78217 .45673 .79989 .43592 .77988 .40644 Mtetra
.473 .46 .763 r
.34985 .88254 .36489 .90368 .37657 .88968 .36141 .86843 Mtetra
.36141 .86843 .37657 .88968 .38841 .8755 .37313 .85414 Mtetra
.37313 .85414 .38841 .8755 .40041 .86113 .385 .83965 Mtetra
.385 .83965 .40041 .86113 .41256 .84656 .39702 .82497 Mtetra
.39702 .82497 .41256 .84656 .42488 .8318 .40921 .8101 Mtetra
.40921 .8101 .42488 .8318 .43737 .81684 .42157 .79502 Mtetra
.42157 .79502 .43737 .81684 .45002 .80168 .43409 .77974 Mtetra
.43409 .77974 .45002 .80168 .46285 .7863 .44678 .76425 Mtetra
.44678 .76425 .46285 .7863 .47586 .77072 .45965 .74854 Mtetra
.45965 .74854 .47586 .77072 .48905 .75491 .4727 .73262 Mtetra
.4727 .73262 .48905 .75491 .50242 .73889 .48593 .71647 Mtetra
.48593 .71647 .50242 .73889 .51599 .72264 .49935 .70009 Mtetra
.49935 .70009 .51599 .72264 .52974 .70616 .51296 .68349 Mtetra
.51296 .68349 .52974 .70616 .54369 .68944 .52676 .66664 Mtetra
.52676 .66664 .54369 .68944 .55785 .67248 .54077 .64956 Mtetra
.54077 .64956 .55785 .67248 .57221 .65527 .55497 .63222 Mtetra
.55497 .63222 .57221 .65527 .58678 .63781 .56938 .61463 Mtetra
.56938 .61463 .58678 .63781 .60157 .6201 .58401 .59678 Mtetra
.58401 .59678 .60157 .6201 .61657 .60212 .59885 .57867 Mtetra
.59885 .57867 .61657 .60212 .6318 .58387 .61391 .56029 Mtetra
.61391 .56029 .6318 .58387 .64726 .56534 .6292 .54163 Mtetra
.6292 .54163 .64726 .56534 .66296 .54654 .64472 .52269 Mtetra
.64472 .52269 .66296 .54654 .67889 .52744 .66048 .50346 Mtetra
.66048 .50346 .67889 .52744 .69507 .50806 .67649 .48393 Mtetra
.67649 .48393 .69507 .50806 .71151 .48837 .69274 .4641 Mtetra
.69274 .4641 .71151 .48837 .7282 .46837 .70924 .44395 Mtetra
.70924 .44395 .7282 .46837 .74515 .44805 .72601 .4235 Mtetra
.72601 .4235 .74515 .44805 .76238 .42741 .74304 .40271 Mtetra
.74304 .40271 .76238 .42741 .77988 .40644 .76034 .38159 Mtetra
.502 .502 .789 r
.33477 .865 .34985 .88254 .36141 .86843 .34622 .85079 Mtetra
.34622 .85079 .36141 .86843 .37313 .85414 .35782 .83639 Mtetra
.35782 .83639 .37313 .85414 .385 .83965 .36958 .82181 Mtetra
.36958 .82181 .385 .83965 .39702 .82497 .38149 .80703 Mtetra
.38149 .80703 .39702 .82497 .40921 .8101 .39356 .79205 Mtetra
.39356 .79205 .40921 .8101 .42157 .79502 .40579 .77687 Mtetra
.40579 .77687 .42157 .79502 .43409 .77974 .41819 .76148 Mtetra
.41819 .76148 .43409 .77974 .44678 .76425 .43076 .74589 Mtetra
.43076 .74589 .44678 .76425 .45965 .74854 .4435 .73007 Mtetra
.4435 .73007 .45965 .74854 .4727 .73262 .45642 .71404 Mtetra
.45642 .71404 .4727 .73262 .48593 .71647 .46953 .69778 Mtetra
.46953 .69778 .48593 .71647 .49935 .70009 .48281 .6813 Mtetra
.48281 .6813 .49935 .70009 .51296 .68349 .49628 .66458 Mtetra
.49628 .66458 .51296 .68349 .52676 .66664 .50995 .64762 Mtetra
.50995 .64762 .52676 .66664 .54077 .64956 .52381 .63042 Mtetra
.52381 .63042 .54077 .64956 .55497 .63222 .53788 .61297 Mtetra
.53788 .61297 .55497 .63222 .56938 .61463 .55215 .59526 Mtetra
.55215 .59526 .56938 .61463 .58401 .59678 .56662 .5773 Mtetra
.56662 .5773 .58401 .59678 .59885 .57867 .58132 .55906 Mtetra
.58132 .55906 .59885 .57867 .61391 .56029 .59623 .54056 Mtetra
.59623 .54056 .61391 .56029 .6292 .54163 .61137 .52178 Mtetra
.61137 .52178 .6292 .54163 .64472 .52269 .62673 .50271 Mtetra
.62673 .50271 .64472 .52269 .66048 .50346 .64233 .48335 Mtetra
.64233 .48335 .66048 .50346 .67649 .48393 .65817 .46369 Mtetra
.65817 .46369 .67649 .48393 .69274 .4641 .67426 .44373 Mtetra
.67426 .44373 .69274 .4641 .70924 .44395 .6906 .42346 Mtetra
.6906 .42346 .70924 .44395 .72601 .4235 .70719 .40287 Mtetra
.70719 .40287 .72601 .4235 .74304 .40271 .72405 .38195 Mtetra
.72405 .38195 .74304 .40271 .76034 .38159 .74117 .3607 Mtetra
.531 .544 .814 r
.31963 .85049 .33477 .865 .34622 .85079 .33098 .83619 Mtetra
.33098 .83619 .34622 .85079 .35782 .83639 .34247 .82171 Mtetra
.34247 .82171 .35782 .83639 .36958 .82181 .35412 .80703 Mtetra
.35412 .80703 .36958 .82181 .38149 .80703 .36592 .79216 Mtetra
.36592 .79216 .38149 .80703 .39356 .79205 .37788 .77709 Mtetra
.37788 .77709 .39356 .79205 .40579 .77687 .39 .76182 Mtetra
.39 .76182 .40579 .77687 .41819 .76148 .40229 .74634 Mtetra
.40229 .74634 .41819 .76148 .43076 .74589 .41475 .73064 Mtetra
.41475 .73064 .43076 .74589 .4435 .73007 .42737 .71473 Mtetra
.42737 .71473 .4435 .73007 .45642 .71404 .44017 .6986 Mtetra
.44017 .6986 .45642 .71404 .46953 .69778 .45315 .68225 Mtetra
.45315 .68225 .46953 .69778 .48281 .6813 .46632 .66566 Mtetra
.46632 .66566 .48281 .6813 .49628 .66458 .47967 .64884 Mtetra
.47967 .64884 .49628 .66458 .50995 .64762 .49321 .63178 Mtetra
.49321 .63178 .50995 .64762 .52381 .63042 .50694 .61447 Mtetra
.50694 .61447 .52381 .63042 .53788 .61297 .52088 .59691 Mtetra
.52088 .59691 .53788 .61297 .55215 .59526 .53501 .5791 Mtetra
.53501 .5791 .55215 .59526 .56662 .5773 .54936 .56103 Mtetra
.54936 .56103 .56662 .5773 .58132 .55906 .56391 .54268 Mtetra
.56391 .54268 .58132 .55906 .59623 .54056 .57869 .52407 Mtetra
.57869 .52407 .59623 .54056 .61137 .52178 .59368 .50517 Mtetra
.59368 .50517 .61137 .52178 .62673 .50271 .60891 .48599 Mtetra
.60891 .48599 .62673 .50271 .64233 .48335 .62436 .46651 Mtetra
.62436 .46651 .64233 .48335 .65817 .46369 .64006 .44674 Mtetra
.64006 .44674 .65817 .46369 .67426 .44373 .65599 .42666 Mtetra
.65599 .42666 .67426 .44373 .6906 .42346 .67218 .40627 Mtetra
.67218 .40627 .6906 .42346 .70719 .40287 .68862 .38555 Mtetra
.68862 .38555 .70719 .40287 .72405 .38195 .70532 .36451 Mtetra
.70532 .36451 .72405 .38195 .74117 .3607 .72228 .34313 Mtetra
.558 .583 .836 r
.30442 .83847 .31963 .85049 .33098 .83619 .31567 .8241 Mtetra
.31567 .8241 .33098 .83619 .34247 .82171 .32707 .80953 Mtetra
.32707 .80953 .34247 .82171 .35412 .80703 .33861 .79478 Mtetra
.33861 .79478 .35412 .80703 .36592 .79216 .35031 .77982 Mtetra
.35031 .77982 .36592 .79216 .37788 .77709 .36217 .76467 Mtetra
.36217 .76467 .37788 .77709 .39 .76182 .37418 .74931 Mtetra
.37418 .74931 .39 .76182 .40229 .74634 .38636 .73374 Mtetra
.38636 .73374 .40229 .74634 .41475 .73064 .39871 .71796 Mtetra
.39871 .71796 .41475 .73064 .42737 .71473 .41123 .70196 Mtetra
.41123 .70196 .42737 .71473 .44017 .6986 .42392 .68574 Mtetra
.42392 .68574 .44017 .6986 .45315 .68225 .43679 .66929 Mtetra
.43679 .66929 .45315 .68225 .46632 .66566 .44984 .65262 Mtetra
.44984 .65262 .46632 .66566 .47967 .64884 .46307 .6357 Mtetra
.46307 .6357 .47967 .64884 .49321 .63178 .47649 .61854 Mtetra
.47649 .61854 .49321 .63178 .50694 .61447 .49011 .60114 Mtetra
.49011 .60114 .50694 .61447 .52088 .59691 .50392 .58349 Mtetra
.50392 .58349 .52088 .59691 .53501 .5791 .51794 .56557 Mtetra
.51794 .56557 .53501 .5791 .54936 .56103 .53216 .5474 Mtetra
.53216 .5474 .54936 .56103 .56391 .54268 .54659 .52895 Mtetra
.54659 .52895 .56391 .54268 .57869 .52407 .56123 .51023 Mtetra
.56123 .51023 .57869 .52407 .59368 .50517 .5761 .49123 Mtetra
.5761 .49123 .59368 .50517 .60891 .48599 .59119 .47194 Mtetra
.59119 .47194 .60891 .48599 .62436 .46651 .60651 .45236 Mtetra
.60651 .45236 .62436 .46651 .64006 .44674 .62207 .43247 Mtetra
.62207 .43247 .64006 .44674 .65599 .42666 .63787 .41228 Mtetra
.63787 .41228 .65599 .42666 .67218 .40627 .65391 .39177 Mtetra
.65391 .39177 .67218 .40627 .68862 .38555 .67021 .37094 Mtetra
.67021 .37094 .68862 .38555 .70532 .36451 .68677 .34978 Mtetra
.68677 .34978 .70532 .36451 .72228 .34313 .70359 .32828 Mtetra
.582 .618 .854 r
.28914 .82843 .30442 .83847 .31567 .8241 .30029 .81398 Mtetra
.30029 .81398 .31567 .8241 .32707 .80953 .31159 .79934 Mtetra
.31159 .79934 .32707 .80953 .33861 .79478 .32304 .78451 Mtetra
.32304 .78451 .33861 .79478 .35031 .77982 .33464 .76948 Mtetra
.33464 .76948 .35031 .77982 .36217 .76467 .3464 .75425 Mtetra
.3464 .75425 .36217 .76467 .37418 .74931 .35832 .73881 Mtetra
.35832 .73881 .37418 .74931 .38636 .73374 .37039 .72316 Mtetra
.37039 .72316 .38636 .73374 .39871 .71796 .38264 .7073 Mtetra
.38264 .7073 .39871 .71796 .41123 .70196 .39505 .69122 Mtetra
.39505 .69122 .41123 .70196 .42392 .68574 .40764 .67492 Mtetra
.40764 .67492 .42392 .68574 .43679 .66929 .4204 .65838 Mtetra
.4204 .65838 .43679 .66929 .44984 .65262 .43334 .64162 Mtetra
.43334 .64162 .44984 .65262 .46307 .6357 .44646 .62462 Mtetra
.44646 .62462 .46307 .6357 .47649 .61854 .45978 .60737 Mtetra
.45978 .60737 .47649 .61854 .49011 .60114 .47328 .58988 Mtetra
.47328 .58988 .49011 .60114 .50392 .58349 .48698 .57213 Mtetra
.48698 .57213 .50392 .58349 .51794 .56557 .50088 .55412 Mtetra
.50088 .55412 .51794 .56557 .53216 .5474 .51498 .53585 Mtetra
.51498 .53585 .53216 .5474 .54659 .52895 .52929 .51731 Mtetra
.52929 .51731 .54659 .52895 .56123 .51023 .54382 .49849 Mtetra
.54382 .49849 .56123 .51023 .5761 .49123 .55856 .47939 Mtetra
.55856 .47939 .5761 .49123 .59119 .47194 .57353 .46 Mtetra
.57353 .46 .59119 .47194 .60651 .45236 .58873 .44031 Mtetra
.58873 .44031 .60651 .45236 .62207 .43247 .60416 .42032 Mtetra
.60416 .42032 .62207 .43247 .63787 .41228 .61983 .40002 Mtetra
.61983 .40002 .63787 .41228 .65391 .39177 .63574 .37941 Mtetra
.63574 .37941 .65391 .39177 .67021 .37094 .65191 .35847 Mtetra
.65191 .35847 .67021 .37094 .68677 .34978 .66833 .33719 Mtetra
.66833 .33719 .68677 .34978 .70359 .32828 .68501 .31558 Mtetra
.601 .647 .868 r
.27377 .81985 .28914 .82843 .30029 .81398 .28483 .80533 Mtetra
.28483 .80533 .30029 .81398 .31159 .79934 .29604 .79062 Mtetra
.29604 .79062 .31159 .79934 .32304 .78451 .3074 .77572 Mtetra
.3074 .77572 .32304 .78451 .33464 .76948 .31891 .76062 Mtetra
.31891 .76062 .33464 .76948 .3464 .75425 .33057 .74531 Mtetra
.33057 .74531 .3464 .75425 .35832 .73881 .34239 .7298 Mtetra
.34239 .7298 .35832 .73881 .37039 .72316 .35437 .71408 Mtetra
.35437 .71408 .37039 .72316 .38264 .7073 .36651 .69814 Mtetra
.36651 .69814 .38264 .7073 .39505 .69122 .37883 .68198 Mtetra
.37883 .68198 .39505 .69122 .40764 .67492 .39131 .6656 Mtetra
.39131 .6656 .40764 .67492 .4204 .65838 .40397 .64898 Mtetra
.40397 .64898 .4204 .65838 .43334 .64162 .41681 .63214 Mtetra
.41681 .63214 .43334 .64162 .44646 .62462 .42983 .61505 Mtetra
.42983 .61505 .44646 .62462 .45978 .60737 .44303 .59772 Mtetra
.44303 .59772 .45978 .60737 .47328 .58988 .45643 .58014 Mtetra
.45643 .58014 .47328 .58988 .48698 .57213 .47002 .5623 Mtetra
.47002 .5623 .48698 .57213 .50088 .55412 .48381 .54421 Mtetra
.48381 .54421 .50088 .55412 .51498 .53585 .4978 .52585 Mtetra
.4978 .52585 .51498 .53585 .52929 .51731 .512 .50721 Mtetra
.512 .50721 .52929 .51731 .54382 .49849 .52641 .4883 Mtetra
.52641 .4883 .54382 .49849 .55856 .47939 .54104 .4691 Mtetra
.54104 .4691 .55856 .47939 .57353 .46 .55589 .44961 Mtetra
.55589 .44961 .57353 .46 .58873 .44031 .57097 .42983 Mtetra
.57097 .42983 .58873 .44031 .60416 .42032 .58628 .40974 Mtetra
.58628 .40974 .60416 .42032 .61983 .40002 .60182 .38933 Mtetra
.60182 .38933 .61983 .40002 .63574 .37941 .61761 .36861 Mtetra
.61761 .36861 .63574 .37941 .65191 .35847 .63365 .34756 Mtetra
.63365 .34756 .65191 .35847 .66833 .33719 .64995 .32618 Mtetra
.64995 .32618 .66833 .33719 .68501 .31558 .6665 .30446 Mtetra
.614 .666 .877 r
.25834 .81221 .27377 .81985 .28483 .80533 .26931 .79763 Mtetra
.26931 .79763 .28483 .80533 .29604 .79062 .28043 .78286 Mtetra
.28043 .78286 .29604 .79062 .3074 .77572 .29169 .76788 Mtetra
.29169 .76788 .3074 .77572 .31891 .76062 .30311 .75271 Mtetra
.30311 .75271 .31891 .76062 .33057 .74531 .31468 .73734 Mtetra
.31468 .73734 .33057 .74531 .34239 .7298 .3264 .72175 Mtetra
.3264 .72175 .34239 .7298 .35437 .71408 .33829 .70596 Mtetra
.33829 .70596 .35437 .71408 .36651 .69814 .35034 .68995 Mtetra
.35034 .68995 .36651 .69814 .37883 .68198 .36255 .67371 Mtetra
.36255 .67371 .37883 .68198 .39131 .6656 .37494 .65725 Mtetra
.37494 .65725 .39131 .6656 .40397 .64898 .3875 .64056 Mtetra
.3875 .64056 .40397 .64898 .41681 .63214 .40023 .62363 Mtetra
.40023 .62363 .41681 .63214 .42983 .61505 .41315 .60647 Mtetra
.41315 .60647 .42983 .61505 .44303 .59772 .42625 .58905 Mtetra
.42625 .58905 .44303 .59772 .45643 .58014 .43954 .57139 Mtetra
.43954 .57139 .45643 .58014 .47002 .5623 .45303 .55347 Mtetra
.45303 .55347 .47002 .5623 .48381 .54421 .46671 .53529 Mtetra
.46671 .53529 .48381 .54421 .4978 .52585 .48059 .51684 Mtetra
.48059 .51684 .4978 .52585 .512 .50721 .49468 .49811 Mtetra
.49468 .49811 .512 .50721 .52641 .4883 .50898 .47911 Mtetra
.50898 .47911 .52641 .4883 .54104 .4691 .5235 .45982 Mtetra
.5235 .45982 .54104 .4691 .55589 .44961 .53823 .44024 Mtetra
.53823 .44024 .55589 .44961 .57097 .42983 .55319 .42035 Mtetra
.55319 .42035 .57097 .42983 .58628 .40974 .56839 .40016 Mtetra
.56839 .40016 .58628 .40974 .60182 .38933 .58381 .37966 Mtetra
.58381 .37966 .60182 .38933 .61761 .36861 .59948 .35884 Mtetra
.59948 .35884 .61761 .36861 .63365 .34756 .6154 .33768 Mtetra
.6154 .33768 .63365 .34756 .64995 .32618 .63157 .31619 Mtetra
.63157 .31619 .64995 .32618 .6665 .30446 .648 .29436 Mtetra
.62 .675 .881 r
.24284 .80502 .25834 .81221 .26931 .79763 .25373 .79038 Mtetra
.25373 .79038 .26931 .79763 .28043 .78286 .26476 .77554 Mtetra
.26476 .77554 .28043 .78286 .29169 .76788 .27593 .7605 Mtetra
.27593 .7605 .29169 .76788 .30311 .75271 .28726 .74526 Mtetra
.28726 .74526 .30311 .75271 .31468 .73734 .29873 .72981 Mtetra
.29873 .72981 .31468 .73734 .3264 .72175 .31036 .71416 Mtetra
.31036 .71416 .3264 .72175 .33829 .70596 .32216 .69829 Mtetra
.32216 .69829 .33829 .70596 .35034 .68995 .33411 .68221 Mtetra
.33411 .68221 .35034 .68995 .36255 .67371 .34623 .6659 Mtetra
.34623 .6659 .36255 .67371 .37494 .65725 .35852 .64936 Mtetra
.35852 .64936 .37494 .65725 .3875 .64056 .37098 .6326 Mtetra
.37098 .6326 .3875 .64056 .40023 .62363 .38361 .61559 Mtetra
.38361 .61559 .40023 .62363 .41315 .60647 .39643 .59835 Mtetra
.39643 .59835 .41315 .60647 .42625 .58905 .40943 .58085 Mtetra
.40943 .58085 .42625 .58905 .43954 .57139 .42261 .56311 Mtetra
.42261 .56311 .43954 .57139 .45303 .55347 .43599 .5451 Mtetra
.43599 .5451 .45303 .55347 .46671 .53529 .44957 .52683 Mtetra
.44957 .52683 .46671 .53529 .48059 .51684 .46334 .5083 Mtetra
.46334 .5083 .48059 .51684 .49468 .49811 .47732 .48948 Mtetra
.47732 .48948 .49468 .49811 .50898 .47911 .49151 .47039 Mtetra
.49151 .47039 .50898 .47911 .5235 .45982 .50592 .45101 Mtetra
.50592 .45101 .5235 .45982 .53823 .44024 .52054 .43133 Mtetra
.52054 .43133 .53823 .44024 .55319 .42035 .53539 .41135 Mtetra
.53539 .41135 .55319 .42035 .56839 .40016 .55046 .39106 Mtetra
.55046 .39106 .56839 .40016 .58381 .37966 .56577 .37046 Mtetra
.56577 .37046 .58381 .37966 .59948 .35884 .58132 .34953 Mtetra
.58132 .34953 .59948 .35884 .6154 .33768 .59712 .32827 Mtetra
.59712 .32827 .6154 .33768 .63157 .31619 .61317 .30668 Mtetra
.61317 .30668 .63157 .31619 .648 .29436 .62947 .28474 Mtetra
.22732 .79778 .24284 .80502 .25373 .79038 .23811 .78306 Mtetra
.23811 .78306 .25373 .79038 .26476 .77554 .24905 .76816 Mtetra
.24905 .76816 .26476 .77554 .27593 .7605 .26013 .75305 Mtetra
.26013 .75305 .27593 .7605 .28726 .74526 .27137 .73774 Mtetra
.27137 .73774 .28726 .74526 .29873 .72981 .28275 .72223 Mtetra
.28275 .72223 .29873 .72981 .31036 .71416 .29429 .7065 Mtetra
.29429 .7065 .31036 .71416 .32216 .69829 .30598 .69056 Mtetra
.30598 .69056 .32216 .69829 .33411 .68221 .31784 .67441 Mtetra
.31784 .67441 .33411 .68221 .34623 .6659 .32986 .65802 Mtetra
.32986 .65802 .34623 .6659 .35852 .64936 .34205 .64141 Mtetra
.34205 .64141 .35852 .64936 .37098 .6326 .35441 .62457 Mtetra
.35441 .62457 .37098 .6326 .38361 .61559 .36695 .60748 Mtetra
.36695 .60748 .38361 .61559 .39643 .59835 .37966 .59016 Mtetra
.37966 .59016 .39643 .59835 .40943 .58085 .39256 .57258 Mtetra
.39256 .57258 .40943 .58085 .42261 .56311 .40564 .55475 Mtetra
.40564 .55475 .42261 .56311 .43599 .5451 .41891 .53667 Mtetra
.41891 .53667 .43599 .5451 .44957 .52683 .43238 .51831 Mtetra
.43238 .51831 .44957 .52683 .46334 .5083 .44605 .49969 Mtetra
.44605 .49969 .46334 .5083 .47732 .48948 .45992 .48078 Mtetra
.45992 .48078 .47732 .48948 .49151 .47039 .47399 .4616 Mtetra
.47399 .4616 .49151 .47039 .50592 .45101 .48829 .44212 Mtetra
.48829 .44212 .50592 .45101 .52054 .43133 .50279 .42235 Mtetra
.50279 .42235 .52054 .43133 .53539 .41135 .51753 .40227 Mtetra
.51753 .40227 .53539 .41135 .55046 .39106 .53248 .38189 Mtetra
.53248 .38189 .55046 .39106 .56577 .37046 .54768 .36118 Mtetra
.54768 .36118 .56577 .37046 .58132 .34953 .56311 .34015 Mtetra
.56311 .34015 .58132 .34953 .59712 .32827 .57878 .31879 Mtetra
.57878 .31879 .59712 .32827 .61317 .30668 .59471 .29709 Mtetra
.59471 .29709 .61317 .30668 .62947 .28474 .61089 .27504 Mtetra
.612 .663 .876 r
.21178 .78997 .22732 .79778 .23811 .78306 .22249 .77519 Mtetra
.22249 .77519 .23811 .78306 .24905 .76816 .23334 .76021 Mtetra
.23334 .76021 .24905 .76816 .26013 .75305 .24433 .74504 Mtetra
.24433 .74504 .26013 .75305 .27137 .73774 .25547 .72966 Mtetra
.25547 .72966 .27137 .73774 .28275 .72223 .26675 .71407 Mtetra
.26675 .71407 .28275 .72223 .29429 .7065 .2782 .69828 Mtetra
.2782 .69828 .29429 .7065 .30598 .69056 .2898 .68226 Mtetra
.2898 .68226 .30598 .69056 .31784 .67441 .30155 .66603 Mtetra
.30155 .66603 .31784 .67441 .32986 .65802 .31348 .64957 Mtetra
.31348 .64957 .32986 .65802 .34205 .64141 .32556 .63288 Mtetra
.32556 .63288 .34205 .64141 .35441 .62457 .33782 .61596 Mtetra
.33782 .61596 .35441 .62457 .36695 .60748 .35025 .59879 Mtetra
.35025 .59879 .36695 .60748 .37966 .59016 .36286 .58138 Mtetra
.36286 .58138 .37966 .59016 .39256 .57258 .37565 .56373 Mtetra
.37565 .56373 .39256 .57258 .40564 .55475 .38863 .54581 Mtetra
.38863 .54581 .40564 .55475 .41891 .53667 .40179 .52764 Mtetra
.40179 .52764 .41891 .53667 .43238 .51831 .41515 .50919 Mtetra
.41515 .50919 .43238 .51831 .44605 .49969 .42871 .49048 Mtetra
.42871 .49048 .44605 .49969 .45992 .48078 .44247 .47148 Mtetra
.44247 .47148 .45992 .48078 .47399 .4616 .45643 .45221 Mtetra
.45643 .45221 .47399 .4616 .48829 .44212 .47061 .43263 Mtetra
.47061 .43263 .48829 .44212 .50279 .42235 .485 .41277 Mtetra
.485 .41277 .50279 .42235 .51753 .40227 .49961 .39259 Mtetra
.49961 .39259 .51753 .40227 .53248 .38189 .51445 .3721 Mtetra
.51445 .3721 .53248 .38189 .54768 .36118 .52952 .3513 Mtetra
.52952 .3513 .54768 .36118 .56311 .34015 .54483 .33016 Mtetra
.54483 .33016 .56311 .34015 .57878 .31879 .56038 .3087 Mtetra
.56038 .3087 .57878 .31879 .59471 .29709 .57618 .28688 Mtetra
.57618 .28688 .59471 .29709 .61089 .27504 .59223 .26472 Mtetra
.598 .643 .866 r
.19628 .78109 .21178 .78997 .22249 .77519 .20689 .76624 Mtetra
.20689 .76624 .22249 .77519 .23334 .76021 .21765 .7512 Mtetra
.21765 .7512 .23334 .76021 .24433 .74504 .22854 .73595 Mtetra
.22854 .73595 .24433 .74504 .25547 .72966 .23958 .7205 Mtetra
.23958 .7205 .25547 .72966 .26675 .71407 .25077 .70484 Mtetra
.25077 .70484 .26675 .71407 .2782 .69828 .26212 .68896 Mtetra
.26212 .68896 .2782 .69828 .2898 .68226 .27362 .67287 Mtetra
.27362 .67287 .2898 .68226 .30155 .66603 .28527 .65656 Mtetra
.28527 .65656 .30155 .66603 .31348 .64957 .29709 .64002 Mtetra
.29709 .64002 .31348 .64957 .32556 .63288 .30908 .62325 Mtetra
.30908 .62325 .32556 .63288 .33782 .61596 .32123 .60624 Mtetra
.32123 .60624 .33782 .61596 .35025 .59879 .33356 .58899 Mtetra
.33356 .58899 .35025 .59879 .36286 .58138 .34606 .5715 Mtetra
.34606 .5715 .36286 .58138 .37565 .56373 .35874 .55376 Mtetra
.35874 .55376 .37565 .56373 .38863 .54581 .3716 .53575 Mtetra
.3716 .53575 .38863 .54581 .40179 .52764 .38466 .51749 Mtetra
.38466 .51749 .40179 .52764 .41515 .50919 .3979 .49895 Mtetra
.3979 .49895 .41515 .50919 .42871 .49048 .41134 .48015 Mtetra
.41134 .48015 .42871 .49048 .44247 .47148 .42498 .46106 Mtetra
.42498 .46106 .44247 .47148 .45643 .45221 .43883 .44168 Mtetra
.43883 .44168 .45643 .45221 .47061 .43263 .45288 .42201 Mtetra
.45288 .42201 .47061 .43263 .485 .41277 .46715 .40204 Mtetra
.46715 .40204 .485 .41277 .49961 .39259 .48164 .38177 Mtetra
.48164 .38177 .49961 .39259 .51445 .3721 .49636 .36118 Mtetra
.49636 .36118 .51445 .3721 .52952 .3513 .5113 .34026 Mtetra
.5113 .34026 .52952 .3513 .54483 .33016 .52648 .31902 Mtetra
.52648 .31902 .54483 .33016 .56038 .3087 .5419 .29744 Mtetra
.5419 .29744 .56038 .3087 .57618 .28688 .55757 .27552 Mtetra
.55757 .27552 .57618 .28688 .59223 .26472 .57349 .25324 Mtetra
.577 .613 .852 r
.18085 .77066 .19628 .78109 .20689 .76624 .19137 .75574 Mtetra
.19137 .75574 .20689 .76624 .21765 .7512 .20202 .74061 Mtetra
.20202 .74061 .21765 .7512 .22854 .73595 .21282 .72529 Mtetra
.21282 .72529 .22854 .73595 .23958 .7205 .22376 .70976 Mtetra
.22376 .70976 .23958 .7205 .25077 .70484 .23485 .69402 Mtetra
.23485 .69402 .25077 .70484 .26212 .68896 .24609 .67806 Mtetra
.24609 .67806 .26212 .68896 .27362 .67287 .25748 .66189 Mtetra
.25748 .66189 .27362 .67287 .28527 .65656 .26904 .64549 Mtetra
.26904 .64549 .28527 .65656 .29709 .64002 .28075 .62887 Mtetra
.28075 .62887 .29709 .64002 .30908 .62325 .29262 .61201 Mtetra
.29262 .61201 .30908 .62325 .32123 .60624 .30467 .59492 Mtetra
.30467 .59492 .32123 .60624 .33356 .58899 .31688 .57758 Mtetra
.31688 .57758 .33356 .58899 .34606 .5715 .32927 .55999 Mtetra
.32927 .55999 .34606 .5715 .35874 .55376 .34184 .54216 Mtetra
.34184 .54216 .35874 .55376 .3716 .53575 .35459 .52406 Mtetra
.35459 .52406 .3716 .53575 .38466 .51749 .36752 .5057 Mtetra
.36752 .5057 .38466 .51749 .3979 .49895 .38065 .48707 Mtetra
.38065 .48707 .3979 .49895 .41134 .48015 .39397 .46816 Mtetra
.39397 .46816 .41134 .48015 .42498 .46106 .40749 .44898 Mtetra
.40749 .44898 .42498 .46106 .43883 .44168 .42121 .4295 Mtetra
.42121 .4295 .43883 .44168 .45288 .42201 .43514 .40973 Mtetra
.43514 .40973 .45288 .42201 .46715 .40204 .44928 .38965 Mtetra
.44928 .38965 .46715 .40204 .48164 .38177 .46364 .36927 Mtetra
.46364 .36927 .48164 .38177 .49636 .36118 .47822 .34857 Mtetra
.47822 .34857 .49636 .36118 .5113 .34026 .49303 .32755 Mtetra
.49303 .32755 .5113 .34026 .52648 .31902 .50808 .3062 Mtetra
.50808 .3062 .52648 .31902 .5419 .29744 .52336 .2845 Mtetra
.52336 .2845 .5419 .29744 .55757 .27552 .53889 .26247 Mtetra
.53889 .26247 .55757 .27552 .57349 .25324 .55466 .24007 Mtetra
.551 .577 .834 r
.16555 .75818 .18085 .77066 .19137 .75574 .17596 .74317 Mtetra
.17596 .74317 .19137 .75574 .20202 .74061 .18651 .72796 Mtetra
.18651 .72796 .20202 .74061 .21282 .72529 .19721 .71256 Mtetra
.19721 .71256 .21282 .72529 .22376 .70976 .20804 .69694 Mtetra
.20804 .69694 .22376 .70976 .23485 .69402 .21903 .68111 Mtetra
.21903 .68111 .23485 .69402 .24609 .67806 .23016 .66507 Mtetra
.23016 .66507 .24609 .67806 .25748 .66189 .24144 .64881 Mtetra
.24144 .64881 .25748 .66189 .26904 .64549 .25289 .63232 Mtetra
.25289 .63232 .26904 .64549 .28075 .62887 .26449 .61561 Mtetra
.26449 .61561 .28075 .62887 .29262 .61201 .27625 .59866 Mtetra
.27625 .59866 .29262 .61201 .30467 .59492 .28818 .58147 Mtetra
.28818 .58147 .30467 .59492 .31688 .57758 .30027 .56404 Mtetra
.30027 .56404 .31688 .57758 .32927 .55999 .31254 .54636 Mtetra
.31254 .54636 .32927 .55999 .34184 .54216 .32499 .52842 Mtetra
.32499 .52842 .34184 .54216 .35459 .52406 .33762 .51022 Mtetra
.33762 .51022 .35459 .52406 .36752 .5057 .35043 .49176 Mtetra
.35043 .49176 .36752 .5057 .38065 .48707 .36343 .47303 Mtetra
.36343 .47303 .38065 .48707 .39397 .46816 .37662 .45402 Mtetra
.37662 .45402 .39397 .46816 .40749 .44898 .39001 .43473 Mtetra
.39001 .43473 .40749 .44898 .42121 .4295 .4036 .41514 Mtetra
.4036 .41514 .42121 .4295 .43514 .40973 .41739 .39526 Mtetra
.41739 .39526 .43514 .40973 .44928 .38965 .4314 .37508 Mtetra
.4314 .37508 .44928 .38965 .46364 .36927 .44562 .35458 Mtetra
.44562 .35458 .46364 .36927 .47822 .34857 .46007 .33377 Mtetra
.46007 .33377 .47822 .34857 .49303 .32755 .47473 .31263 Mtetra
.47473 .31263 .49303 .32755 .50808 .3062 .48963 .29116 Mtetra
.48963 .29116 .50808 .3062 .52336 .2845 .50477 .26935 Mtetra
.50477 .26935 .52336 .2845 .53889 .26247 .52015 .24719 Mtetra
.52015 .24719 .53889 .26247 .55466 .24007 .53577 .22468 Mtetra
.52 .535 .811 r
.15042 .74317 .16555 .75818 .17596 .74317 .16073 .72807 Mtetra
.16073 .72807 .17596 .74317 .18651 .72796 .17118 .71277 Mtetra
.17118 .71277 .18651 .72796 .19721 .71256 .18176 .69727 Mtetra
.18176 .69727 .19721 .71256 .20804 .69694 .19249 .68156 Mtetra
.19249 .68156 .20804 .69694 .21903 .68111 .20336 .66564 Mtetra
.20336 .66564 .21903 .68111 .23016 .66507 .21438 .6495 Mtetra
.21438 .6495 .23016 .66507 .24144 .64881 .22555 .63314 Mtetra
.22555 .63314 .24144 .64881 .25289 .63232 .23687 .61656 Mtetra
.23687 .61656 .25289 .63232 .26449 .61561 .24835 .59975 Mtetra
.24835 .59975 .26449 .61561 .27625 .59866 .26 .5827 Mtetra
.26 .5827 .27625 .59866 .28818 .58147 .2718 .56541 Mtetra
.2718 .56541 .28818 .58147 .30027 .56404 .28377 .54787 Mtetra
.28377 .54787 .30027 .56404 .31254 .54636 .29592 .53009 Mtetra
.29592 .53009 .31254 .54636 .32499 .52842 .30824 .51205 Mtetra
.30824 .51205 .32499 .52842 .33762 .51022 .32073 .49375 Mtetra
.32073 .49375 .33762 .51022 .35043 .49176 .33341 .47518 Mtetra
.33341 .47518 .35043 .49176 .36343 .47303 .34628 .45634 Mtetra
.34628 .45634 .36343 .47303 .37662 .45402 .35934 .43721 Mtetra
.35934 .43721 .37662 .45402 .39001 .43473 .37259 .41781 Mtetra
.37259 .41781 .39001 .43473 .4036 .41514 .38604 .39811 Mtetra
.38604 .39811 .4036 .41514 .41739 .39526 .39969 .37812 Mtetra
.39969 .37812 .41739 .39526 .4314 .37508 .41355 .35781 Mtetra
.41355 .35781 .4314 .37508 .44562 .35458 .42763 .3372 Mtetra
.42763 .3372 .44562 .35458 .46007 .33377 .44192 .31627 Mtetra
.44192 .31627 .46007 .33377 .47473 .31263 .45644 .29501 Mtetra
.45644 .29501 .47473 .31263 .48963 .29116 .47118 .27342 Mtetra
.47118 .27342 .48963 .29116 .50477 .26935 .48616 .25148 Mtetra
.48616 .25148 .50477 .26935 .52015 .24719 .50138 .22919 Mtetra
.50138 .22919 .52015 .24719 .53577 .22468 .51684 .20655 Mtetra
.487 .491 .786 r
.13554 .72516 .15042 .74317 .16073 .72807 .14574 .70997 Mtetra
.14574 .70997 .16073 .72807 .17118 .71277 .15607 .69457 Mtetra
.15607 .69457 .17118 .71277 .18176 .69727 .16654 .67897 Mtetra
.16654 .67897 .18176 .69727 .19249 .68156 .17715 .66316 Mtetra
.17715 .66316 .19249 .68156 .20336 .66564 .18791 .64713 Mtetra
.18791 .64713 .20336 .66564 .21438 .6495 .19881 .63089 Mtetra
.19881 .63089 .21438 .6495 .22555 .63314 .20985 .61443 Mtetra
.20985 .61443 .22555 .63314 .23687 .61656 .22105 .59774 Mtetra
.22105 .59774 .23687 .61656 .24835 .59975 .23241 .58081 Mtetra
.23241 .58081 .24835 .59975 .26 .5827 .24392 .56366 Mtetra
.24392 .56366 .26 .5827 .2718 .56541 .2556 .54626 Mtetra
.2556 .54626 .2718 .56541 .28377 .54787 .26744 .52861 Mtetra
.26744 .52861 .28377 .54787 .29592 .53009 .27945 .51072 Mtetra
.27945 .51072 .29592 .53009 .30824 .51205 .29164 .49256 Mtetra
.29164 .49256 .30824 .51205 .32073 .49375 .304 .47415 Mtetra
.304 .47415 .32073 .49375 .33341 .47518 .31653 .45546 Mtetra
.31653 .45546 .33341 .47518 .34628 .45634 .32926 .4365 Mtetra
.32926 .4365 .34628 .45634 .35934 .43721 .34217 .41726 Mtetra
.34217 .41726 .35934 .43721 .37259 .41781 .35527 .39774 Mtetra
.35527 .39774 .37259 .41781 .38604 .39811 .36857 .37792 Mtetra
.36857 .37792 .38604 .39811 .39969 .37812 .38207 .3578 Mtetra
.38207 .3578 .39969 .37812 .41355 .35781 .39578 .33738 Mtetra
.39578 .33738 .41355 .35781 .42763 .3372 .4097 .31664 Mtetra
.4097 .31664 .42763 .3372 .44192 .31627 .42383 .29558 Mtetra
.42383 .29558 .44192 .31627 .45644 .29501 .43818 .27419 Mtetra
.43818 .27419 .45644 .29501 .47118 .27342 .45276 .25247 Mtetra
.45276 .25247 .47118 .27342 .48616 .25148 .46757 .2304 Mtetra
.46757 .2304 .48616 .25148 .50138 .22919 .48262 .20798 Mtetra
.48262 .20798 .50138 .22919 .51684 .20655 .4979 .1852 Mtetra
.453 .445 .76 r
.12097 .70372 .13554 .72516 .14574 .70997 .13106 .68842 Mtetra
.13106 .68842 .14574 .70997 .15607 .69457 .14127 .67291 Mtetra
.14127 .67291 .15607 .69457 .16654 .67897 .15162 .6572 Mtetra
.15162 .6572 .16654 .67897 .17715 .66316 .16211 .64128 Mtetra
.16211 .64128 .17715 .66316 .18791 .64713 .17273 .62514 Mtetra
.17273 .62514 .18791 .64713 .19881 .63089 .18351 .60878 Mtetra
.18351 .60878 .19881 .63089 .20985 .61443 .19443 .59221 Mtetra
.19443 .59221 .20985 .61443 .22105 .59774 .2055 .5754 Mtetra
.2055 .5754 .22105 .59774 .23241 .58081 .21672 .55836 Mtetra
.21672 .55836 .23241 .58081 .24392 .56366 .2281 .54109 Mtetra
.2281 .54109 .24392 .56366 .2556 .54626 .23964 .52357 Mtetra
.23964 .52357 .2556 .54626 .26744 .52861 .25134 .5058 Mtetra
.25134 .5058 .26744 .52861 .27945 .51072 .26321 .48779 Mtetra
.26321 .48779 .27945 .51072 .29164 .49256 .27525 .46951 Mtetra
.27525 .46951 .29164 .49256 .304 .47415 .28746 .45097 Mtetra
.28746 .45097 .304 .47415 .31653 .45546 .29985 .43216 Mtetra
.29985 .43216 .31653 .45546 .32926 .4365 .31242 .41308 Mtetra
.31242 .41308 .32926 .4365 .34217 .41726 .32517 .39371 Mtetra
.32517 .39371 .34217 .41726 .35527 .39774 .33812 .37406 Mtetra
.33812 .37406 .35527 .39774 .36857 .37792 .35126 .35411 Mtetra
.35126 .35411 .36857 .37792 .38207 .3578 .3646 .33386 Mtetra
.3646 .33386 .38207 .3578 .39578 .33738 .37814 .3133 Mtetra
.37814 .3133 .39578 .33738 .4097 .31664 .39189 .29243 Mtetra
.39189 .29243 .4097 .31664 .42383 .29558 .40585 .27124 Mtetra
.40585 .27124 .42383 .29558 .43818 .27419 .42002 .24972 Mtetra
.42002 .24972 .43818 .27419 .45276 .25247 .43442 .22786 Mtetra
.43442 .22786 .45276 .25247 .46757 .2304 .44905 .20565 Mtetra
.44905 .20565 .46757 .2304 .48262 .20798 .46391 .18309 Mtetra
.46391 .18309 .48262 .20798 .4979 .1852 .47901 .16017 Mtetra
.418 .399 .732 r
.1068 .67843 .12097 .70372 .13106 .68842 .11675 .66301 Mtetra
.11675 .66301 .13106 .68842 .14127 .67291 .12684 .64738 Mtetra
.12684 .64738 .14127 .67291 .15162 .6572 .13706 .63155 Mtetra
.13706 .63155 .15162 .6572 .16211 .64128 .14742 .61551 Mtetra
.14742 .61551 .16211 .64128 .17273 .62514 .15792 .59925 Mtetra
.15792 .59925 .17273 .62514 .18351 .60878 .16856 .58277 Mtetra
.16856 .58277 .18351 .60878 .19443 .59221 .17934 .56607 Mtetra
.17934 .56607 .19443 .59221 .2055 .5754 .19027 .54914 Mtetra
.19027 .54914 .2055 .5754 .21672 .55836 .20135 .53197 Mtetra
.20135 .53197 .21672 .55836 .2281 .54109 .21259 .51457 Mtetra
.21259 .51457 .2281 .54109 .23964 .52357 .22398 .49692 Mtetra
.22398 .49692 .23964 .52357 .25134 .5058 .23554 .47903 Mtetra
.23554 .47903 .25134 .5058 .26321 .48779 .24725 .46088 Mtetra
.24725 .46088 .26321 .48779 .27525 .46951 .25914 .44247 Mtetra
.25914 .44247 .27525 .46951 .28746 .45097 .27119 .4238 Mtetra
.27119 .4238 .28746 .45097 .29985 .43216 .28342 .40486 Mtetra
.28342 .40486 .29985 .43216 .31242 .41308 .29583 .38564 Mtetra
.29583 .38564 .31242 .41308 .32517 .39371 .30842 .36614 Mtetra
.30842 .36614 .32517 .39371 .33812 .37406 .3212 .34635 Mtetra
.3212 .34635 .33812 .37406 .35126 .35411 .33416 .32627 Mtetra
.33416 .32627 .35126 .35411 .3646 .33386 .34733 .30588 Mtetra
.34733 .30588 .3646 .33386 .37814 .3133 .36069 .28518 Mtetra
.36069 .28518 .37814 .3133 .39189 .29243 .37425 .26417 Mtetra
.37425 .26417 .39189 .29243 .40585 .27124 .38803 .24284 Mtetra
.38803 .24284 .40585 .27124 .42002 .24972 .40202 .22117 Mtetra
.40202 .22117 .42002 .24972 .43442 .22786 .41622 .19917 Mtetra
.41622 .19917 .43442 .22786 .44905 .20565 .43065 .17682 Mtetra
.43065 .17682 .44905 .20565 .46391 .18309 .44531 .15411 Mtetra
.44531 .15411 .46391 .18309 .47901 .16017 .4602 .13105 Mtetra
.384 .355 .704 r
.09308 .64892 .1068 .67843 .11675 .66301 .10291 .63337 Mtetra
.10291 .63337 .11675 .66301 .12684 .64738 .11286 .61761 Mtetra
.11286 .61761 .12684 .64738 .13706 .63155 .12295 .60165 Mtetra
.12295 .60165 .13706 .63155 .14742 .61551 .13317 .58547 Mtetra
.13317 .58547 .14742 .61551 .15792 .59925 .14353 .56908 Mtetra
.14353 .56908 .15792 .59925 .16856 .58277 .15403 .55247 Mtetra
.15403 .55247 .16856 .58277 .17934 .56607 .16467 .53563 Mtetra
.16467 .53563 .17934 .56607 .19027 .54914 .17545 .51857 Mtetra
.17545 .51857 .19027 .54914 .20135 .53197 .18638 .50127 Mtetra
.18638 .50127 .20135 .53197 .21259 .51457 .19747 .48373 Mtetra
.19747 .48373 .21259 .51457 .22398 .49692 .20871 .46594 Mtetra
.20871 .46594 .22398 .49692 .23554 .47903 .2201 .44791 Mtetra
.2201 .44791 .23554 .47903 .24725 .46088 .23166 .42962 Mtetra
.23166 .42962 .24725 .46088 .25914 .44247 .24338 .41108 Mtetra
.24338 .41108 .25914 .44247 .27119 .4238 .25527 .39226 Mtetra
.25527 .39226 .27119 .4238 .28342 .40486 .26733 .37318 Mtetra
.26733 .37318 .28342 .40486 .29583 .38564 .27956 .35382 Mtetra
.27956 .35382 .29583 .38564 .30842 .36614 .29197 .33417 Mtetra
.29197 .33417 .30842 .36614 .3212 .34635 .30457 .31424 Mtetra
.30457 .31424 .3212 .34635 .33416 .32627 .31735 .29401 Mtetra
.31735 .29401 .33416 .32627 .34733 .30588 .33033 .27348 Mtetra
.33033 .27348 .34733 .30588 .36069 .28518 .3435 .25264 Mtetra
.3435 .25264 .36069 .28518 .37425 .26417 .35687 .23148 Mtetra
.35687 .23148 .37425 .26417 .38803 .24284 .37045 .20999 Mtetra
.37045 .20999 .38803 .24284 .40202 .22117 .38423 .18818 Mtetra
.38423 .18818 .40202 .22117 .41622 .19917 .39823 .16603 Mtetra
.39823 .16603 .41622 .19917 .43065 .17682 .41245 .14353 Mtetra
.41245 .14353 .43065 .17682 .44531 .15411 .42689 .12067 Mtetra
.42689 .12067 .44531 .15411 .4602 .13105 .44156 .09746 Mtetra
.351 .314 .677 r
.07991 .61485 .09308 .64892 .10291 .63337 .0896 .59915 Mtetra
.0896 .59915 .10291 .63337 .11286 .61761 .09942 .58326 Mtetra
.09942 .58326 .11286 .61761 .12295 .60165 .10937 .56715 Mtetra
.10937 .56715 .12295 .60165 .13317 .58547 .11944 .55084 Mtetra
.11944 .55084 .13317 .58547 .14353 .56908 .12965 .5343 Mtetra
.12965 .5343 .14353 .56908 .15403 .55247 .14 .51755 Mtetra
.14 .51755 .15403 .55247 .16467 .53563 .15049 .50057 Mtetra
.15049 .50057 .16467 .53563 .17545 .51857 .16112 .48336 Mtetra
.16112 .48336 .17545 .51857 .18638 .50127 .17189 .46591 Mtetra
.17189 .46591 .18638 .50127 .19747 .48373 .18282 .44823 Mtetra
.18282 .44823 .19747 .48373 .20871 .46594 .19389 .4303 Mtetra
.19389 .4303 .20871 .46594 .2201 .44791 .20512 .41212 Mtetra
.20512 .41212 .2201 .44791 .23166 .42962 .2165 .39368 Mtetra
.2165 .39368 .23166 .42962 .24338 .41108 .22805 .37499 Mtetra
.22805 .37499 .24338 .41108 .25527 .39226 .23976 .35603 Mtetra
.23976 .35603 .25527 .39226 .26733 .37318 .25164 .33679 Mtetra
.25164 .33679 .26733 .37318 .27956 .35382 .26369 .31728 Mtetra
.26369 .31728 .27956 .35382 .29197 .33417 .27592 .29749 Mtetra
.27592 .29749 .29197 .33417 .30457 .31424 .28832 .2774 Mtetra
.28832 .2774 .30457 .31424 .31735 .29401 .30091 .25702 Mtetra
.30091 .25702 .31735 .29401 .33033 .27348 .31368 .23633 Mtetra
.31368 .23633 .33033 .27348 .3435 .25264 .32665 .21534 Mtetra
.32665 .21534 .3435 .25264 .35687 .23148 .33981 .19403 Mtetra
.33981 .19403 .35687 .23148 .37045 .20999 .35317 .17239 Mtetra
.35317 .17239 .37045 .20999 .38423 .18818 .36674 .15043 Mtetra
.36674 .15043 .38423 .18818 .39823 .16603 .38052 .12812 Mtetra
.38052 .12812 .39823 .16603 .41245 .14353 .39451 .10547 Mtetra
.39451 .10547 .41245 .14353 .42689 .12067 .40872 .08246 Mtetra
.40872 .08246 .42689 .12067 .44156 .09746 .42315 .05909 Mtetra
.319 .275 .65 r
.06737 .57594 .07991 .61485 .0896 .59915 .07692 .5601 Mtetra
.07692 .5601 .0896 .59915 .09942 .58326 .08659 .54405 Mtetra
.08659 .54405 .09942 .58326 .10937 .56715 .09638 .5278 Mtetra
.09638 .5278 .10937 .56715 .11944 .55084 .10631 .51133 Mtetra
.10631 .51133 .11944 .55084 .12965 .5343 .11637 .49464 Mtetra
.11637 .49464 .12965 .5343 .14 .51755 .12656 .47774 Mtetra
.12656 .47774 .14 .51755 .15049 .50057 .13689 .4606 Mtetra
.13689 .4606 .15049 .50057 .16112 .48336 .14735 .44324 Mtetra
.14735 .44324 .16112 .48336 .17189 .46591 .15796 .42564 Mtetra
.15796 .42564 .17189 .46591 .18282 .44823 .16871 .4078 Mtetra
.16871 .4078 .18282 .44823 .19389 .4303 .17961 .38972 Mtetra
.17961 .38972 .19389 .4303 .20512 .41212 .19066 .37138 Mtetra
.19066 .37138 .20512 .41212 .2165 .39368 .20187 .35279 Mtetra
.20187 .35279 .2165 .39368 .22805 .37499 .21323 .33394 Mtetra
.21323 .33394 .22805 .37499 .23976 .35603 .22476 .31482 Mtetra
.22476 .31482 .23976 .35603 .25164 .33679 .23644 .29543 Mtetra
.23644 .29543 .25164 .33679 .26369 .31728 .2483 .27577 Mtetra
.2483 .27577 .26369 .31728 .27592 .29749 .26032 .25581 Mtetra
.26032 .25581 .27592 .29749 .28832 .2774 .27253 .23557 Mtetra
.27253 .23557 .28832 .2774 .30091 .25702 .2849 .21503 Mtetra
.2849 .21503 .30091 .25702 .31368 .23633 .29747 .19419 Mtetra
.29747 .19419 .31368 .23633 .32665 .21534 .31022 .17304 Mtetra
.31022 .17304 .32665 .21534 .33981 .19403 .32316 .15157 Mtetra
.32316 .15157 .33981 .19403 .35317 .17239 .33629 .12978 Mtetra
.33629 .12978 .35317 .17239 .36674 .15043 .34963 .10766 Mtetra
.34963 .10766 .36674 .15043 .38052 .12812 .36317 .08519 Mtetra
.36317 .08519 .38052 .12812 .39451 .10547 .37692 .06239 Mtetra
.37692 .06239 .39451 .10547 .40872 .08246 .39088 .03922 Mtetra
.39088 .03922 .40872 .08246 .42315 .05909 .40506 .01569 Mtetra
0 g
.40529 0 m
.90636 .18624 L
s
.90636 .18624 m
1 .96984 L
s
1 .96984 m
.39338 .80427 L
s
.39338 .80427 m
.40529 0 L
s
.06876 .56114 m
0 1.28979 L
s
0 1.28979 m
.39338 .80427 L
s
.39338 .80427 m
.40529 0 L
s
.40529 0 m
.06876 .56114 L
s
.06876 .56114 m
.40529 0 L
s
gsave
.11554 .27502 -73 -16.6017 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.90636 .18624 m
1 .96984 L
s
gsave
1.0531 .57514 -61 -10.3907 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
79.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{143.125, 179.563},
  ImageMargins->{{92, 0}, {0, 0}},
  ImageRegion->{{-0.097234, 1.114}, {-0.031989, 0.983339}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002?0000/a000`40O003h00OSgoo001GOol00`00
Ool0000eOol005Ioo`05001oo`00Ool0000dOol005Ioo`05001oo`00Ool0000dOol005Eoo`<00003
Ool0000003Aoo`00Sgoo002?Ool008moo`00Sgoo002?Ool008moo`00Sgoo000`Ool2001MOol002mo
o`800003Ool0000005]oo`00;goo0P000goo0`00F7oo000^Ool00`009A@00006Ool3001EOol002io
o`03000Tl`0000Uoo`8005=oo`00;Goo00@002DD9A@000]oo`<0051oo`00;7oo00H002Cc9A@Tl`00
9?<=Ool3001=Ool002aoo`06000U52DD9A@002DD47oo0P00Bgoo000[Ool01`009A@TlbTD9?<002Td
019oo`<004Qoo`00:goo00<002DD9A@00RDD00<002Te:C@057oo0`00AGoo000ZOol02@009?<Y52Cc
9A@Tl`00:C@Y=@0GOol20013Ool002Uoo`03000U52DD00<U5003:CD002Te008Y=AQoo`<0041oo`00
:Goo00/002TD9?<U52Cc:A@Y=000:C@]=BTd01]oo`8003ioo`00:7oo00<002DD9A@00bDD00LY=2Te
000Y=BTd;EH]E@0LOol3000kOol002Qoo`0=000TlbDD9?<Y52Cc:CDY=000:C@Y=BeE<GH07goo0`00
>7oo000WOol00`009A@U50039A@3:CD01P00:CD]EBeF;ED]ER5oo`8003Ioo`009Woo010007oo9A@T
lbTD9?<Y=BTd;CDY=000;EDaMReE<GH]EB=oo`<003=oo`009Woo00<002DD9A@00bDD0RTe00TY=2Te
000]EReE;EH]ECFG<IH09Goo0`00<7oo000UOol03`009A@TlbTD9?<U52Td;CDY=2Te:C@002eE<GH]
E@02<GH00cFGOomoo`0VOol2000^Ool002Aoo`03000U52DD00<U508Y=@08:C@Y=BTe;EH002eF;ED]
EP<aUP03=IMoogoo02Moo`<002]oo`0097oo01D002Cc:A@TlbDD9?<]=BTd:CDY=2de;ED002eE<GH]
ECFG<GHeUcFg>KP0:goo0`00:7oo000SOol00`009A@U50039A@00bTe:C@Y=@02:CD01BeE;EH002eF
;ED00S6F00@eUc6F=KLe]bioo`8002Ioo`008goo01L002TD9?<U52Cc:A@Y=2Te:C@]=BTd<GH]E@00
;EDeUc5f=ILaMSVh=KLif3Fg02moo`8002Aoo`008Woo00<002DD9A@00bDD00`Y=2Te:CDY=BTd;EH]
EBeF000]ES6F=IL2<IH01CFg>KLe]cFg>OP0;Woo0P0097oo000QOol03`00OolTlbDD9?<Y52Td:CDY
=2de:C@Y=BeE<GH00002<GH02SFG<GHeUcFg>MPe]cVh>MPmnCWH;7oo00<007oo000097oo000QOol0
0`009A@U50039A@3:CD022Td:CD]EBeF;ED0036F=IL3<IH023Vg=KLe]cFg?OPif3gh>OP[Ool00`00
Ool0000TOol0021oo`0N001oobDD9?<Y52Cc:CDY=2de:C@Y=BeE<GH]EC5f000eUc5f=ILaMSWH=KLi
^3Fg?OTif3gh>MQ26ChI:Goo00@007ooOol002Aoo`001Woo0P0067oo00<002DD9A@00bDD0RTe00PY
=2Te:CD]EReE;EH]E@000c6F00Xi]cFg=KLe]cgh>MPmn3Wh@QTn6@926BMoo`03001oogoo009oo`03
001oogoo025oo`001Goo00@007ooOol001Ioo`0Q000U52Cc:A@TlbDD:C@]=BTd:CDY=35f;EDaMReE
=IL003FG<GHif3Fg>KPe]cgi>MPmn3WH@QTn6D8I?QQ6FT8i02Eoo`03001oogoo00=oo`03001oogoo
025oo`001Goo00<007ooOol05Woo00<007oo9A@00bDD0RTe00`Y=2Te:CD]EReE;EH]EBeF<IH0036F
=IL3=KL01SVg>MPmn3Wh?OPn6@926@04AUY2>DHjASXSOol00`00Oomoo`04Ool00`00Oomoo`0QOol0
00Aoo`D001Eoo`0>000TlbTD9?<U52Cc;CDY=2Te:C@aMReE<GH]E@8aMP06=IL003FG=KLi^3Fg0SWH
00dmn3WH?OTn6D8I?QQ6FT8iAUY2>DYkAUY:N`0QOol00`00Oomoo`04Ool00`00Oomoo`0QOol000Eo
o`03001oogoo01Eoo`03000U52DD00<U5003:CDY=2Te008Y=@04;ED]EReE;EH3<IH02P00<IHe]cFg
>KLif3gh>OPmn3hI0d8I00U2>DHjASY:NTIJAWY:NdZKBWX07Woo00<007ooOol01Goo00<007ooOol0
8Goo000MOol03@00:A@TlbDD9?<Y52Td:CDY=2de;EDaMReE008aMP0H=ILaMSFG000i^3Fg>MPe]cgh
>MPmnChI@QTn648I@SU6FT8iBW]6FTYkAUY>VdYj0TZK77oo00<007ooOol01Woo00<007ooOol08Goo
000LOol00`009A@U50039A@02BTd:CDY=BTe:C@]EReE;EH]E@02<IH02SFG<IH003Fg>KLe]cgh>OPm
n3WH0d8I00=2>DHjASX00TIJ00A6NTIJBY]:NP9:V`03CY]:VdjK01Uoo`03001oogoo00Moo`03001o
ogoo025oo`006goo024007oo9?<U52Cc:A@Y=2Te:C@]=BTd<GH]EC5f;EDeUc5f=ILaMSFG000if3Fg
>KPif3gi>MQ26ChH@QTn6DIJ@ST00TIJ00a:NdIJBW]:NTZKBWY>^dZKCY]:VdjlBY/FOol00`00Oomo
o`08Ool00`00Oomoo`0QOol001]oo`03000U52DD008U500<:C@Y=BTe:CDY=2eF;ED]EReE;EHaUSFG
0S6F00Pe]`00=KLe]cWh?OPif3gh0T8I00Ln6DHjASY6FT8iAWY6FP02BWX014ZKBW]>VdZK0TjK00E>
^djKC[]>Vdjk01Aoo`03001oogoo00Uoo`03001oogoo021oo`006Woo00h002Cc9A@TlbTD9?<Y=BTd
;CDY=2Te;EDaMReE0S5f02@eUc5f=ILe]cWH000i^3WH?OTif3gh?QQ26ChI@QU2>DIJ@SU:NdIJBW]:
NTZKBWY>VdZKCY]:VdjlBY]>^dZKC[a:VdjkBY/AOol00`00Oomoo`0:Ool00`00Oomoo`0POol001Yo
o`03000U52DD008U50<Y=@08:C@Y=BeE;EH]EBeF<IHeU`8aUP0E=KLi]cFg000e]cgh>MPmn3Wh@QTn
6D8IASY6FT8iAWY6FTYjAUY:VdYk009:V`08CY]:VdjkCY]>^djKC[]:V`9>V`03BY]:NdZK00ioo`03
001oogoo00]oo`03001oogoo021oo`006Goo024002DD9?<Y52Cc9A@Y=2de:C@Y=BeE<GH]EC5f;EDe
Uc5f=ILaMSWH=KLi^000?OTif3gh>MQ26ChI@QU2>DIJ@ST00TIJ01E:NdIJBY]:NTjKBY]>VdZKC[a:
VdjkBY]>_4ZKC[]:VdjkBWY:VdIJBW/037oo00<007ooOol037oo00<007ooOol087oo000HOol00`00
9A@U50049A@02BTe:C@Y=BTe;EH]EBeF;EDeU`03<IH02SVg=KLe]cFg000if3gh>OQ26ChI0T8I00Q6
FT8iASY6FTYjAUY:VdYk0TZK00M>VdZKC[]>VdjkCY]>^`04CY/01dYkBY]:VdYjAWY:NTIj00Uoo`03
001oogoo00eoo`03001oogoo021oo`0067oo00h002Cc:A@TlbDD9?<]=BTd:CDY=35f;EDaMReE0S5f
010eUc5f=ILe]cVh=KLmn@00?OPif48I?QU26ChHAUY2>@96FP0GBW]6FTZKBWY>VdZKCY]:VdjlBY]>
^dZKC[a:VdjkBY]>^dYjBY]:NTYkAUY:N`02AUX00d8iOomoo`06Ool00`00Oomoo`0=Ool00`00Oomo
o`0POol001Moo`03001oobDD00<U5003:CDY=2Te008Y=@04;ED]EReE;EH3<IH02SFG=KLe]cFg>KLi
f000>OPmn3hI0T8I0156FT8iASY6FTYjAUY:VdYkBY]:NTjKBY]>^djKC[]>Vdjk00A>V`09BW]:VdZK
BWY6NTYjAWY6FTHj0096FPIoo`03001oogoo00ioo`03001oogoo021oo`005goo00d002TD9?<U52Cc
;CDY=2Te:C@]=BeE<GH]E@02<GH01SFG<GHeUcFg>KPe]`8if008?OP003gi?QU26ChHAUY2>@96FP0G
BW]6FTYkBWY>VdYjCY]:VdjkBY]>^dZKC[a:VdjkBY]>^dYjBY]:NTYkAUY:N`02AUX01D8iAUY2>D8i
@QT017oo00<007ooOol03goo00<007ooOol087oo000FOol00`009A@U50039A@022Td:CDY=BTe;ED]
EReE;EH3<IH02SFG<IHe]cFg>KLif3gh>OP003hI0d8I00]2>DHjASY:NTIJAWY:NdZKBWY>VdZK009>
V`03C[]>Vdjk00A>V`A:V`05AWY:NTIjBWY6>P02AUX0148i@QU26D8I0Woo00<007ooOol04Goo00<0
07ooOol07goo000EOol0<P00:A@TlbDD9?<Y52Td:CDY=2de;EDaMReE<GH]ECFG<GHeUc5f>KPe]cWH
=KLmn3WH?OT0048I?QQ26D8iAUY2>DYkAUY:NdIJCY]:NTjKBY]>^dZKC[]:VdjlBY]>^dZKC[/2BY/0
24YjCY]6FTYkAUY:Nd8iAUX2@ST01T8I@STn6Cgi?OP001Aoo`03001oogoo01moo`005Goo00<002DD
9A@00bDD0bTe00DY=2eF;ED]EReE008aUP0;=ILaUSFg=KLi]cFg?OPin3gh>MP00002@QT00d8iASY6
>P02AUX014IjAUY:VdYj0TZK0TjK00E>^djKC[]>Vdjk009>V`09BY]>VdZKBY]:NdYjAWY:NTHj00=6
FP=26@@mn1Aoo`03001oogoo01moo`0057oo00h002Cc9A@TlbTD9?<Y=BTd;CDY=35f;EDaMReE0S5f
010eUc5f=ILe]cWH=KLi^3WH?OTif48I00126ChIAUY2>@96FP04BW]6FTjKBWX2BY/06DjkBY]>^dZK
C[a:VdjkBY]>^dZKC[]:NTjKBWY:NdIJBW]2>DIJ@SU6FT8I@STn6Cgi00<mn003?MPi]goo019oo`03
001oogoo01moo`0057oo00<002DD9A@00bDD0RTe00PY=2Te;ED]EReE;EHaUSFG0S6F00Le]cVg=KLe
]cWh?OPif002@QT01000?QU6>THj0TIJ00A6NTIJBWY:NP9:V`07CY]:VdjkCY]>^djKC[/00TjK00U:
VdjKBY]:VdYkBWY6NTYjASX00dIJ0d8I00=2>Cgh?OP00Sgh00<i]cWGOol04Woo00<007ooOol07goo
000COol03@009A@TlbTD9?<U52Td;CDY=2Te;EDaMReE008aMP0@=ILaMSFG<GHif3Fg>KPif3gi>MPm
n3hH@QT004IJ@ST2AUX05dYkAUY:NdYjBY]:NTjkBY]>VdZKC[a:VdjkBY]>^dZKC[]:NTjKBWY:NdIJ
BW/00TIJ00I2>DIJ@QU2>ChI@ST3?OP01Cgi>KLif3Vg?MP04Woo00<007ooOol07goo000BOol00`00
OolU50039A@2:CD022Td:CDY=BeF;ED]EReE=IL3<IH01cVg=KLe]cWh?OPif3gh00926@03?QT004Hj
0096FP08AWY6FTYjBWY:VdYkCY]:V`9>V`07C[]>VdjkCY]>^dZKCY/00TZK00E:NdZKAWY:NTIj00=6
FP=26@03@STmn3gh008mn006>KLiecWG>MPeUSFG4Goo00<007ooOol07goo000BOol0=`009?<Y52Cc
9A@Tlbde:C@Y=BTd<GH]EC5f;EDeUc5f=ILaMSWH=KLi^3Fg?OTif3gh?QQ26ChI@QT004IJ@SU:NdIJ
BW]:NTZKBWY>^dZKCY]:VdjlBY]>^dZKC[a:VdjkBY]>VdYjBY]6FTYk0096FP06@SU6FT8I@STn6D8i
0cgh00TmnCVg>MPi]cgH>KLe]cFF>KL047oo00<007ooOol07goo000AOol00`009A@U50039A@02BTe
:C@Y=BTe;EH]EBeF;EDeU`03<IH05SVg=KLe]cFg?OPif3gh>OQ26ChI@QU6>P00@SU6NTIJBWY6FTZK
BW]>VdZK0TjK00I>^djKC[]>VdjkBY/2CY/01TZKBW]:VdIjBWY6NP=6FP=26@03@STmn3gh008mn009
>KLiecWG>MPi]cFG=IHe]cFF011oo`03001oogoo01moo`0047oo01H002Cc:A@TlbDD9?<Y52Td:CDY
=2de;EDaMReE=ILaMSFG<GHeUcFg>KPe]`8if008?OPif48I?QU26D8iAUX00096FP0EBW]6FTZKBWY>
VdZKCY]:VdjlBY]>^dZKC[a:VdjkBY]>VdYjBY]6FTYk0096FP06@SU6FT8i@STn6D8i0cgh00`mnCVg
>MPi]cgH>KLe]cFF>KLeUSFg=IH@Ool00`00Oomoo`0NOol0011oo`03000U52DD00<U5008:C@Y=BTe
:CD]EBeF;ED]EP<aUP0:=ILe]cFg=KLi]cWH?OPin3gh?QT2@QT024IJ@ST004IJBWY6FTZKBW/2BY/0
24jKBY]>^djKC[]>VdjkBY/2CY/01TZKBW]:VdIjBWY6NP=6FP04ASY26D8I@ST4?OP03CVg>MLiecWH
>KLeUcFF=KLeUSFG=IHeMS5f00moo`03001oogoo01ioo`003goo00d002TD9?<U52Cc:A@Y=2Te:C@]
=BTd<GH]E@02<GH01SFG<GHeUcFg>KPe]`8if00O?OPif3gi?QU26ChHAUY2>DIJ001:NdIJBY]:NTjK
BY]>VdZKC[a:VdjkBY]>_4ZKC[]:VdjKBWY:VdIJBW/00TIJ00M2>DIJ@SU2>ChI@SU26@02?OP02cgi
?OPif3Vg?MPi]cFg=IHi]cFF=KL00SFF00<aMCFFOol03Woo00<007ooOol07Woo000?Ool00`009A@U
50029A@02BTd:CDY=BTe:C@]EReE;EH]E@02<IH02SFG=KLe]cFg>KLe]cgh>OPmn3hI0d8I00]2>DHj
AUX004IJBY]:NdZKBWY>VdZK009>V`03C[]>Vdjk00=>V`07BY]:NdZKBY]:NTIjBWX00TIJ00E6>T8I
@QU2>D8I00@mn08ie`09>MPi]cFG=IHe]cFF=ILeUSEf00<aMP03=GIoogoo00aoo`03001oogoo01io
o`003Woo03T002Cc9A@TlbTD9?<Y=BTd;CDY=35f;EDaMReE=ILaMSFG<GHi^3Fg>MPe]cgh>MPmnChI
@QTn648I@SU6FT8iBW/004YkBWY>VdYjCY]:VdjkBY]>^dZKC[a:VdjkBY]>^dYjBY]:NTYkAUY:Nd8i
AUX00T8i00<n6D8i@QT00Sgh00/mnCgh>MPi]cgH>KLe]cFF>KLeUSFg008eUP05<GDeUS5e=IHaM@0>
Ool00`00Oomoo`0NOol000eoo`03001oobDD00<U50<Y=@09:C@]EReE;EH]EBeF<IHeUc6F008e]`06
>KLe]cgh>OPmn3WH0d8I00]2>DHjASY:NTIJ001:NdZKBWY>VdZK009>V`05C[]>VdjkCY]>^`02CY/0
2DYkBY]:VdZKAWY:NTIjAUY6>P02@QT00d8i@QTmn003?OP2>ML02CWH>KLiecFF=KLeUSFG=IHeMP03
<GH013Ef<GHaEC5E3Goo00<007ooOol07Woo000=Ool03@009A@TlbTD9?<U52Td;CDY=2Te;EDaMReE
008aMP0Q=ILaMSFG=KLif3Fg?OPif3gi>MQ26ChH@QU2>DIJ@SU:NdIJBW/004jKBWY>VdZKC[]:Vdjk
BY]>_4ZKC[]:Vdjk009:V`04BWY>VdIJBW/2AUX07D8iAUXn6D8i@QU2>Cgh?OTmn3WH>KLmf3Vg>MPe
USVg=IHe]cFF>KLaMCFF<GDeUS5e<ED]EC5e;ED037oo00<007ooOol07Woo000<Ool00`00OolU5003
9A@2:CD022Td:CD]EBeF;ED]ES6F=IL3<IH01SVg=KLe]cWh?OPif0=26@03?QU6>THj0096FP04AWY6
FP00BWX2BY/2CY/01DjkCY]>^djKC[/00TjK14ZK00Q6NTYjAWY6FTHjAUY26D8i0T8I0cgh0SWG00Ti
f3Vg>MLiecFg=IHeUcFF=KL00c5f00<eMS5f<ED00S5E00<]EC5EOol02goo00<007ooOol07Woo000<
Ool07P009?<Y52Cc9A@Tlbde:C@Y=BTd<GH]EC5f;EDeUc5f=ILaMSWH=KLi^3WH?OTif48I?QQ26ChI
AUY2>@96FP04BW]6FTjK0002BY/02DjkBY]>^dZKC[a:VdjkBY]>^`02BY/014YjCY]6FTYk0TIJ00Q2
>DIJ@SU2>D8I@STmn3gi0Sgh00@i]cgH>KLif08i]`0@=IHe]cFF>KLaMCFF<GDeUS5e<ED]EC5e;EDa
EBeE<GD<Ool00`00Oomoo`0MOol000]oo`03000U52DD00<U5009:CDY=2Te:CD]EReE;EH]ECFG00<a
UP07>KLe]cFg>OPmn3WH?OP00T8I018n6DHjASY6FT8iAWY6FTZKBWX004ZKCY]:VdjkCY]>^djKC[/2
CY/4BY/01DIjBWY6NTIJASX00TIJ00A2>D8I@QU26@<mn003>MLif3Vg008ie`05=KLeUSFG=IHe]`03
<GH00cEf<GHaE@02<ED01BeE<EDaEC5E;C@037oo00<007ooOol07Goo000:Ool03P009?<Y52Cc9A@T
lbde:C@Y=BTd<GH]EC5f;ED2<GH07cFG<GHif3Fg>KPif3gi>MPmn3hH@QTn6DIJ@SU6FT8iBW]6FTYk
BWY:V`00C[]:VdjkBY]>_4ZKC[]:Vdjk009:V`04BWY>VdIJBW/2AUX0248iAUY2>D8i@QU2>ChI?OT3
?OP00cgH>KLif002>KL043FF=KLeUSVg<GDeUS5e=IHaMCFF;EDaMBeE<ED]EC5e0ReE00<]=7ooOol0
2Goo00<007ooOol07Goo000:Ool00`009A@U50029A@02BTe:C@Y=BTe;EH]EBeF;ED]EP03<IH043FG
=KLe]cFg?OPif3gh>OQ26ChI@QU6>TIJ@SU6NTIJ0TYj00U:VdYk001:VdjkCY]>^djKC[/00TjK00U:
VdjKBY]:VdIjBWY6NTIJASX00TIJ00A2>D8I@QU26@@mn009>MPi]cWG>MLe]cFF=ILeUSFg00<aMP03
=GHaMS5f008aE@05;EDaEC5E<ED]E@02;C@00bdeOomoo`09Ool00`00Oomoo`0MOol000Uoo`0=000Y
52Cc9A@TlbTD:C@Y=BTd;CD]EC5f;ED00S5f02TeUc5f=ILe]cVh=KLmnCWH?OPif48I?QU26D8iAUY2
>DYkAUY:NdYjBY]:NTjk001>VdZKC[a:VdjkBY]>^dZKC[]:NTjKBWY:NdIJBW]2>DIJ0092>@04@QU2
>ChI?OT3?OP00cgH>KLif002>KL043FF=KLeUSVg<GDeUS5e=IHaMCFF;EDaMBeE<ED]EC5e0ReE00<]
=2eE;C@02goo00<007ooOol07Goo0009Ool00`009A@U50029A@022Td:CDY=BTe;ED]EReE;EH3<IH0
43FG<IHe]cFg>KLif3gh>OQ26ChI@QU6>TIJ@SU6>TIJ0TYj00U:VdYkCY]:V`00CY]>^djKC[/00TjK
00U:VdjKBY]:VdYkBWY6NTYjASX00TIJ00A2>D8I@QU26@@mn00:>MPi]cWG>MLe]cFF=ILeUSFg=IH2
<GH00cEf<GHaMP02<ED012eE<EDaEC5E0bdd00@]=Bdd;C@]=0Yoo`03001oogoo01eoo`0027oo01@0
02Cc9A@TlbTD9?<Y=BTd;CDY=35f;EDaMReE=ILaMSFG<GHi^3Fg0SWH00Pmn3WH?OTn6D8I?QQ6FT8i
0TIJ01E:NdIJBY]:NTjkBY]>V`00C[a:VdjkBY]>_4ZKC[]:NTjKBWY:NdIJBW/00TIJ0T8i00A26D8i
?QTmn@<mn009?MPi]cWH>KLmf3FF=KLeUSVg008eUP0B<GDeUS5e=IH]EC5e;EDaEBeE<GD]=2eE;C@]
EBdd;ED]=2eE2Woo00<007ooOol07Goo0008Ool00`009A@U50029A@3:CD01BTd;EH]EBeF;ED00S6F
00XeUc6F=KLe]cVg>MPmn3Wh?OPn6@926@08AUY2>DHjAUY:NTIJBY]:N`9:V`08CY]:V`00CY]>^djK
C[]:V`9>V`06BY]:NdYjAWY:NTIj0dIJ0d8I13gh00Xif3Vg>MLiecWH=IHeUcFF=KLeUP8aMP03=GHa
MS5f008aE@04;EDaEC5E<ED3;C@01Rde;C@]=2dd;CDY50Yoo`03001oogoo01eoo`0027oo00`002Cc
:A@TlbDD:C@]=BTd:CD]EC5f;ED2<GH013FG<GHi^3Fg0SWH00Pmn3WH?OTif48I?QQ26D8i0TIJ01E:
NdIJBY]:NTjKBY]>VdZKC[`004jkBY]>_4ZKC[]:VdjKBWY:VdIJBW/00TIJ00I2>DIJ@QU2>ChI?OT3
?OP02CgH>KLif3Vg?MPeUSFg=IHi]`02=IH05C5e=IHaMCFF;EDaMBeE<ED]EC5e;C@]EBdd;ED]=2eE
;C@]EBTC;C@Y4`0:Ool00`00Oomoo`0<Ool00`00Ool0000=Ool000Qoo`04000U52DD9A@2:CD022Td
:CD]EBeF;ED]ES6F=IL2<IH01cFg>KLe]cgh>OPmn3WH00=26@0;@SU6>THjBWY6FTZKBW]:VdYjCY]:
V`02CY/01000CY]>^dZK0TjK00I:VdYkBY]6NTYjAWX3AUX3@QT00d8i?OPmn002?OP02CVg>MLiecWH
=IHeUcFF=KLeUP02<GH01SEf<GHaMS5f<ED]E@<aE@04;ED]=2dd;CD3;C@01Bde:A@Y52TD;C@02Woo
00<007ooOol02goo00D007oo001oo`0000aoo`0027oo03T002Cc9A@Tlbde:C@Y=BTd<GH]EC5f;EDe
Uc5f=ILe]cWH=KLmn3WH?OTif48I?QQ26D8iAUY2>DYkAUY:NdYjCY]:NTjKBY]>^dZKC[/004jlBY]>
^dZKCY]:NTZKBWY:NdIJBW]2>DIJ@QU2>ChI@ST00cgh00TmnCVg>MPi]cgH=IHe]cFF>KL00SFF00@a
MCFF<GDeUP8aM@04;EDaEBeE<GD2;ED01Rdd;ED]=2eE;C@]E@8]=004:A<]=2TC;C@9Ool00`00Oomo
o`0;Ool01@00Ool007oo000037oo0008Ool01@00OolU52Te:C@00RTe00D]EReE;EH]ECFG00<aUP06
>KLe]cFg>OPmn3WH0d8I00]2>DHjASY:NTIJAWY:NdZKBWY>VdZK009>V`03C[]>V`0000=>V`07BY]:
NdZKBY]:NTIjBWX00TIJ0d8I00=2>Cgh?OP00Sgh00Ti]cWG>MLif3FF=ILeUSFg=IH00S5f00HeMS5f
<GHaMS5E;ED3<ED012eE;C@]=2de0bdd00D]=Bdd:A@Y52dd00<Y50Uoo`03001oogoo00Yoo`<00003
Ool0000000Eoo`03001oogoo00Aoo`001goo024007ooOol]=BTd:CDY=35f;EDaMReE=ILaMSFG<GHi
f3Fg>KPif3gi>MPmn3hH@QTn6DIJ@SU:NdIJBW]:NTjKBWX00TZK01E>^dZKC[]:V`00BY]>^dZKCY]:
NTZKBWY:NdIJBW]2>DIJ@QU2>ChI@ST00cgh00TmnCVg>MPi]cgH>KLe]cFF>KL00SFF00@aMCFF<GDe
UP8aM@04;EDaEBeE<GD2;ED01Rdd;ED]=2eE;C@]E@8]=007:A<]=2TC;C@Y4bdd:A<027oo00<007oo
Ool05Goo00<007ooOol017oo0007Ool01000OomoobTd0RTe00D]EReE;EH]ECFG00<aUP07>KLe]cFg
>OPmn3WH?OP00T8I00<n6DHjASX00TIJ00A6NTYkBY]:NP9:V`06CY]:VdjkCY]>^`000djK00I:NdZK
BY]:NTIjBWX2AUX014Hj@QU26D8i13gh00Ti]cWG>MLif3Vg=ILeUSFg=IH00S5f00HeMS5f<GHaMS5E
;ED3<ED012eE;C@]=2de0bdd00D]=Bdd:A@Y52dd00<Y5003;C@Y52TD00Qoo`03001oogoo01Eoo`03
001oogoo00Aoo`001goo01T007ooOomoobTd;CD]EC5f;EDeUc5f=ILaMSWH=KLi^3WH?OTif3gh>MQ2
6ChIAUY2>@02AUX014YkAUY>VdYj0TZK015>^dZKC[]:VdjlBY/004ZKC[]:NTZKBWY:NdIJBW]2>DIJ
0092>@03?QU2>Cgh008mn009?OTi]cWH>KLmf3Vg=KLeUSVg008eUP04<GDeUS5e=IH2<GD012eE<ED]
EC5e0ReE00H]=2eE;C@]EBdd;ED2;C@02BTC;C@Y4bdd:A<]=2TC;C@Tl`08Ool00`00Oomoo`0LOol0
00Moo`09001oogooOolY=BeE;EH]EBeF00<aUP0:=ILe]cFg=KLmn3WH?OPin48I?QT2ASX01TIJ@SU6
NTIJBY]:NP9:V`0:CY]:VdjkCY]>^djKC[/004jKBW/3BY/01DIjBWY6FTIJASX00T8I00=2>D8I?OP0
0Sgh00`i]cWG>MLif3Vg=ILeUSFg=IHeUc5f=GH3<GH00c5E;EDaE@02<ED012eE;C@]=2de0bdd00D]
=Bdd:A@Y52dd00<Y5003;C@Y52TD00<Y4`Moo`03001oogoo01aoo`001goo00L007ooOomoobeE<GH]
E@02<GH09CFG<GHeUcFg>KPe]cgi>MPmn3WH@QTn6DIJ@SU6FT8iBW]6FTYkBWY:VdYjC[]:VdjkBY]>
_4ZKC[]:V`00BWY:VdYjCY]6FTYk0096FP92>@03?QU2>D8I008mn00??OTmn3WH>KLmf3Vg=KLeUSVg
=IHe]c5e=IHaMCFF008aM@04;EDaEBeE<GD2;ED01Rdd;ED]=2eE;C@]E@8]=00<:A<]=2TC;C@Y4bdd
:A<]=2Cc:A@XlbTD1goo00<007ooOol077oo0007Ool00`00Oomoo`02Ool00beE;EH]E@02<IH043FG
=KLe]cFg>KLif3gh>OQ26ChI@QU6>TIJ@SU6NTIJ0TYj00A:VdYkCY]:V`9>V`03C[]>Vdjk009>V`0=
001:VdZKBY]6NTYjAWY6FTHjAUY26D8i@QT013gh0SWG00Tif3Vg=ILeUSFg=IHeUc5f=GH00c5f00<e
MReE<ED00S5E00@]EC5E;C@]=@<]=005;CD]=2TD:A@]=003:A@00bdd:A@Y5006:A<7Ool00`00Oomo
o`0KOol000Moo`03001oogoo009oo`08<GH]ECFG<GHeUc5f>KPe]`8if00<?OPif48I?QU26D8iAUY2
>DYkAUY:NdYj0TZK00m>^dZKCY]:VdjlBY]>^dZKC[]:V`00BWY>VdIJBW/00TIJ00E2>DIJ?QU2>D8I
008mn00M?OTmn3gh>KLmf3Vg=KLeUSVg=IHe]c5e=IHaMCFF<GDeUReE<ED]EC5e;EDaEBdd;ED]=2eE
;C@]E@02;C@03bTC;C@Y4bdd:A<]=2TC;C@TlbTD:?<Y52Cc:A@Xl`07Ool00`00Oomoo`0KOol000Mo
o`03001oogoo00=oo`04;EHaUSFG<IH2=KL01SVg=KLmn3Wh?OPn6@926@04AUY2>DHjAUX2BWX02DZK
BW]>VdZKC[]>VdjkCY]>^`02CY/2BY/02P00BY]6NTYjAWY6FTHjAUY26D8i0T8I13gh00XiecWH>KLe
UcFF=KLeUSFG<GHeMP<aMP03=GH]EC5E008aE@04;EDaEBdd;CD3;C@01Bde;C@]=2TD;C@00bTD00<]
=2TD:A<02BTC1Woo00<007ooOol06goo0007Ool00`00Oomoo`03Ool03c5f=ILaMSFG=KLif3Fg?OPi
f3gi?QU26ChHAUY2>@02AUX03DYkAUY:VdYjC[]:VdjKBY]>_4ZKC[]:Vdjk009:V`0TBWX004IJBW]6
FTYk@SU6FShI@SU26D8i?OPmnCgh>MPi]cgH>KLif3FF>KLeUSFg<GDeUS5e=IHaMCFF;EDaEBeE<GD]
EC5E0ReE01P]=2eE;C@]EBdd;EDY4bdd:A<]=2TC;C@Y4bTD9?<Y52Sc:A@TlbTD:?<Y52Cc:A@6Ool0
0`00Oomoo`0KOol000Moo`03001oogoo00=oo`0:=ILaUS6F=KLi]cFg?OPin3gh?QT3@QT01d8iASY6
>TYjAUY:VdYk009:V`9>V`03C[]>Vdjk009>V`09BY]>VdZKBY/004YjAWY:NTHj0096FP03@SU26D8I
00@mn00:>MLif3Vg>MLeUSFg=IHeUc5f=GH3<GH00cEf;EDaE@02<ED012eE<EDaEBde0bdd00D]=Bdd
;C@Y52dd00<Y5003;C@Y52TD00XY4`039?=oogoo00Aoo`03001oogoo01]oo`001Woo00<007ooOol0
1Goo02DeUcFg>MPe]cgh>MPmnChI@QTn648I@SU6FT8iBW]6FTYkBWY>VdZKCY]:VdjlBY]>^dZKC[a:
VdjkBWY>VdYj0016FTYk@SU6FP02@ST0148I@STmn3gi0Sgh01@i]cgH>KLif3FF>KLeUSFg<GDeUS5e
=IHaMCFF;EDaEBeE<GD]EC5E0ReE01P]=2eE;C@]EBdd;EDY4bdd:A<]=2TC;C@Y4bdd9?<Y52Sc:A@T
lbTD:?<Y52Cc:A@2:?<00bCbOomoo`03Ool00`00Oomoo`0KOol000Ioo`03001oogoo00Eoo`07=KLi
]cFg=KLin3gh>MP00d8I00M2>DHjASY:NTIJAWY:N`02BY/024jKBY]>^djKC[]>VdjkBY/2CY/01TZK
BW]:NP00BWY6>P96FP04@SU26D8I@QT3?OP02SWG>MPi]cWG=IHe]cFF=ILeUSEf0c5f00<eMReE<ED0
0S5E00@]EC5E<ED]=@<]=005;CD]=2dd:A@]=003:A@00bdd:A@Y500;:A<00bSc9?<Xl`05Ool00`00
Oomoo`0KOol000Ioo`03001oogoo00Ioo`0P=KLi^3WH?OTif48I?QQ26D8iAUY2>DYkAUY:NdYjCY]:
VdjKBY]>_4ZKC[]:VdjlBY]>^dZKCY]:NTZKAUX00096FP92>@04@QU2>ChI?OT2?OP013Vg?MPi]cWH
0SVg00heUSFg=IHeUS5e=IHaMCFF;EDaEBeE<GD]EC5E0ReE01P]=2eE;C@]EBdd;EDY4bdd:A<]=2TC
;C@Y4bdd9?<Y52Sc:A@TlbTD:?<Y52Cc:A@2:?<00bCb:A<TlP05Ool00`00Oomoo`0KOol000Ioo`03
001oogoo00Moo`04>OPmn3WH?OP2@QT04ChIASY6>TYjAUY6NTYkBY]:NTjKBY]>^djKC[]>VdjkBY/0
0TjK00I:VdYkBY]6NTYj0003AUX3@QT3?OP00cWG>MPi]`02>ML01CFg=IHeUcFF=GH00c5f00<eMS5f
<ED00S5E00@]EC5E<ED]=@<]=005;CD]=2dd:A@]=003:A@00bdd:A@Y500::A<01bCc:?<TlbSc9?<X
lbCc00Eoo`03001oogoo01Yoo`001Woo00<007ooOol027oo00Lif3gh?QQ26ChIAUY2>@02AUX06dYk
AUY>VdYjCY]:VdjkBY]>^dZKC[a:VdjkBY]>VdYjBY]6FTYk@ST0048iAUY26D8i?QTmn@02?OP013Vg
?MPi]cWH0SVg00heUSFg=IHeUS5e=IHaMCFF<GDaEBeE<GD]EC5E0ReE020]=2eE;C@]EBdd;EDY4bdd
:A<]=2TC;C@Y4bdd9?<Y52Sc:A@TlbTD:?<Y52Cc:A@TlRSc9?8Y4bCb:?<TlRTC1Goo00<007ooOol0
6Woo0006Ool00`00Oomoo`09Ool2@QT00chIASY6>P02AUX014IjAUY:VdYj0TZK0TjK00=>^djKC[/0
14jK00Q:NdZKAWY:NTIjAUX004IJ0d8I00I2>Cgh?OPmn3WH>KL2>ML01CFg=IHeUcFF=KL00c5f00<e
MS5f<ED00S5E00@]EC5E<ED]=@<]=005;CD]=2dd:A@]=003:A@00bdd:A@Y500::A<02BCc:?<TlbSc
9?<XlbCc:?<Tl`05Ool00`00Oomoo`0JOol000Ioo`03001oogoo00Yoo`09?QU26D8iAUY2>DYkAUY>
VdYj009:V`0=C[]:VdjkBY]>_4ZKC[]:VdjkBWY:VdYjBW/00TIJ00I2>@00@QU2>ChI@ST3?OP00cgH
>KLif002>KL03SFF=KLeUSVg<GDeUS5e=IHaMC5E;EDaMBeE<ED2;ED08bdd;ED]=2eE;C@]EBTC;C@Y
4bdd:A<]=2TC;C@TlbTD:?<Y52Cc:A@XlbTD9?<Y52Cb:?<TlRTC9?8XlbCb:A<TlRSc9?8017oo00<0
07ooOol06Woo0006Ool00`00Oomoo`0;Ool044HjAUY2>DIjAUY:VdYjCY]:VdjKBY]>^djKC[]>Vdjk
0TjK00I:NdZKBY]:NTIjBWX2AUX01000@QU26D8i0cgh00Tif3Vg>MLiecFg=IHeUcFF=KL00c5f00<e
MS5f<ED00S5E00@]EC5E<ED]=@<]=005;CD]=2dd:A@]=003:A@00bdd:A@Y500::A<032Cc:?<TlbSc
9?<XlbCc:?<TlbSc9?<Xl`Aoo`03001oogoo01Yoo`001Woo00<007ooOol037oo00E2>DYkAUY>VdYj
009:V`0EC[]:VdjkBY]>_4ZKC[]:VdjkBWY:VdYjBW]6FTYk@SU6FT8i000n6D8i00<mn00j?MPi]cWH
>KLmf3FF=KLeUSVg<GDeUS5e=IHaMC5E;EDaMBeE<ED]EC5e;C@]EBdd;ED]=2eE:A<]=2TC;C@Y4bdd
:A<]=2Cc:A@XlbTD9?<Y52Sc:A@TlbTD9?8XlbCb:A<TlRSc9?8Y4bCb:?<TlRTC9=84Ool00`00Oomo
o`0JOol000Ioo`03001oogoo00aoo`04AWY6FTYjBWX2BY/01djKBY]>^djKC[]>Vdjk009>V`06BW]:
VdZKBWY6NTYj0TIJ0T8I00<0048i?OP00cgh00Pi]cWG>MLif3FF=ILeUSFg0c5f00<eMS5f<ED00S5E
00@]EC5E<EDaE@<]=005;CD]=2dd:A@]=003:A@00bdd:A@Y500::A<03BCc:?<TlbSc9?<XlbCc:?<T
lbSc9?<XlbCB008TlP=oo`03001oogoo01Yoo`001Woo00<007ooOol03Woo00a:NTZKBWY>^dZKC[]:
VdjlBY]>^dZKC[/2BY/01TYjBW]6FTYk@SU6FP92>@03?QT003gh008mn00m?OTi]cWH>KLmf3FF=KLe
USVg<GDeUS5e=IHaMC5E;EDaMBeE<ED]EC5e;C@]EBdd;ED]=2eE:A<]=2TC;C@Y4bdd:A<]=2Cc:A@X
lbTD9?<Y52Sc:A@TlbTD9?8XlbCb:A<TlRSc9?8Y4bCb:?<TlRTC9=8TlbCB:?<00goo00<007ooOol0
6Woo0005Ool00`00Oomoo`0AOol01djKBY]>VdjKC[]>Vdjk009>V`A:V`05AWY:NTIjAUY6>P02@QT0
0d8i000mn002?OP02CVg>MLiecWH=IHeUcFF=KLeUP02<GH00cEf<GHaMP02<ED012eE<EDaEC5E0bdd
00<]=Bdd;C@00Rdd0bTD00<]=2TD:A@02RTC00dTlbSc9?<XlbCc:?<TlbSc9?<XlbCc:?<TdP029?80
0bCc9=9oo`02Ool00`00Oomoo`0JOol000Eoo`03001oogoo01=oo`06BY]>_4ZKC[]:Vdjk0TZK00A:
NTjKAUY:N`96FP0@@SU6FShI@SU26@00?OPmnCVg>MPi]cgH=IHe]cFF>KL2=IH0235e=IHaMCFF;EDa
MBeE<ED2;ED01Rdd;ED]=2eE;C@]E@8]=00S:A<]=2TC;C@Y4bdd9?<Y52Sc:A@TlbTD:?<Y52Cc:A@T
lRSc9?8Y4bCb:?<TlRTC9?8XlbCb:A<TdRCc9=8XlbCB9?<TdP03Ool00`00Oomoo`0IOol000Eoo`03
001oogoo01Eoo`03C[]>VdjK00A:V`0:AWY:NTIJAUY6>TIJ@QU2>D8I?OP200002CVg>MLiecWH=IHe
UcFF=KLeUP02<GH00cEf<GHaMP02<ED012eE<EDaEC5E0bdd00<]=Bdd;C@00Rdd0bTD00<]=2TD:A@0
2bTC00`XlbCc:?<TlbSc9?<XlbCc:?<TlbSc9=829?801BCc9=8TlRCb9?<00goo00<007ooOol06Goo
0005Ool00`00Oomoo`0FOol01djkBY]:VdYjCY]6FTYk0096FP09@SU6FShI@SU26Cgh000mnCgh00@0
0003=KLeUSVg008eUP0@<GDeUS5e=IH]EC5e;EDaEBeE<GD]=2eE;C@]EBdd;ED2;C@042TC;C@Y4bdd
:A<]=2Cc:A@XlbTD9?<Y52Sc:A@TlbTD0RSc01<TlRTC9?8XlbCb:A<TlRSc9?8Y4bCB9?<TdRSc9=8T
lbCB:?<TdP03Ool00`00Oomoo`0IOol000Eoo`03001oogoo01Yoo`0;AWY:NTIjAUY6>TIJ@QU2>D8I
?OP00002?OP2>ML00cWH>KLeU`040000135f=GHaMS5f0S5E00@]EC5E<EDaE@<]=003;CD]=2dd008]
=0<Y5004;C@Y52TD:A@::A<032Sc9?<XlbCc:?<TlbSc9?<XlbCc:?<TdP8TlP079?<TdRCb9?8TlbCB
9?800goo00<007ooOol06Goo0005Ool00`00Oomoo`0KOol01dIJBW]2>DIJ?QU2>D8I008mn009000m
n3WH>KLmf3Vg=KLeUSVg008eUP03<GD000000080000;<GD]EC5E;EDaMBdd;ED]=2eE;C@]E@02;C@0
42TC;C@Y4bdd:A<]=2TC:A@XlbTD9?<Y52Sc:A@TlbTD0RSc01HTlRTC9?8XlbCb:A<TlRSc9?8Y4bCB
9?<TdRSc9=8TlbCB:?<TdRCc9=8Xl`9oo`03001oogoo01Uoo`001Goo00<007ooOol077oo00A6>TIJ
AUY2>@926@03?OP003gh008ie`06>MPi]cFG=IHe]cFF0S5f00<eMS5f<GH00S5E0`0000DaEBdd;C@]
=2de00@]=0<Y5004;C@Y52TD:A@::A<032Sc9?<XlbCc:?<TlbSc9?<XlbCc:?<TdP8TlP069?<TdRCb
9?8TlbCB0RCb00DTlbCBOomoo`0001]oo`001Goo00<007ooOol07Woo01=2>D8I@STmn000?OPif3Vg
?MPi]cFg=IHi]cFF=KLaMCFF<GDeUP02<GD012eE<ED]EC5e100001@]=2eE;C@]=2TC;C@Y4bdd:A<]
=2TC:A@XlbTD9?<Y52Sc:A@TlbTD0RSc01HTlRTC9?8XlbCb:A<TlRSc9?8Y4bCB9?<TdRSc9=8TlbCB
:?<TdRCc9=8Xl`8TdP9oo`03001oogoo01Uoo`001Goo00<007ooOol07goo00A26Cgh000mn08ie`09
>MPi]cFG=IHe]cFF=ILaMSEf00<aMP03<ED]EC5E008aE@05;ED]=2dd;CD]=0040002:A@012dd:A@Y
52TD2RTC00`XlbCc:?<TlbSc9?<XlbCc:?<TlbSc9=829?801RCc9=8TlRCb9?<TdP8TlP039?<TdRCb
008TdP03Ool007oo01Yoo`001Goo00<007ooOol07goo010mn000?OPif3Vg?MPi]cWH=IHi]cFF=KLa
MCFF<GDeUP8aM@04;EDaEBeE<GD2;ED022dd;ED]=2eE;C@]EBTC;C@400002RTC:A@XlbTD9?<Y52Sc
:A@TlbTD0RSc01/TlRTC9?8XlbCb:A<TlRSc9?8Y4bCB9?<TdRSc9=8TlbCB:?<TdRCc9=8XlbCB9?<P
dRCb9=800Woo00<007ooOol067oo0005Ool00`00Oomoo`0OOol03@00?OPmn3WG>MPi]cWG=IHe]cFF
=ILaMSEf00<aMP03<ED]EC5E008aE@04;ED]=2dd;CD4;C@3:A@012dd:A@Y52TD0`001bTC00`XlbCc
:?<TlbSc9?<XlbCc:?<TlbSc9=829?801RCc9=8TlRCb9?<TdP8TlP039?<TdRCb00@TdP9oo`03001o
ogoo01Qoo`0017oo00<007ooOol087oo00h007oo>KLmf3Vg>MPeUSVg=IHe]c5e=IHaMCFF0S5e00@]
EC5E;EDaM@8]E@04;C@]EBdd;ED2;C@02bTC;C@Y4bdd:A<]=2TC:A@XlbTD9?<0100001dY52Sc:?<T
lRTC9?8XlbCb:A<TlRSc9?8Y4bCB9?<TdRSc9=8TlbCB:?<TdRCc9=8XlbCB9?<PdRCb008TdP048=8T
lWoo000JOol000Aoo`03001oogoo01moo`0<001oogooOoli]cWG=IHe]cFF=ILaMSEf0c5f00<aEBeE
<ED00S5E0bdd00<]=Bdd;C@00Rdd0bTD00@]=2TD:A@Y50TY4`@000099?<XlbCc:?<TlbSc9?<XlbCB
008TlP069?<TdRCb9?8TlbCB0RCb00<TlbCB9?801bCB00=oo`00Ool06Goo0004Ool00`00Oomoo`0N
Ool00`00Oomoo`03Ool023FF>KLeUSFg<GDeUS5e=IH2<GD012eE<ED]EC5e0ReE01/]=2eE;C@]EBdd
;EDY4bdd:A<]=2TC;C@Y4bTD:?<Y52Cc:A@XlbTD9?<Y52Cb:?<TlRTC9?800`00010TlRSc9?8XlbCB
9?<TdRSc9=8TlbCB:?<TdRCc9=8Xl`8TdP068=8TlRCB9=8PdRCb0RCB00=oo`00Ool06Goo0004Ool0
0`00Oomoo`0MOol00`00Oomoo`05Ool013FF=ILeUSEf0c5f00<eMReE<ED00S5E00@]EBdd;C@]=@<]
=005;CDY52TD:A@]=003:A@00bdd:A<Y4`06:A<02BCc:?<TlbSc9?<XlbCc:?<Tl`0400029?801RCc
9=8TlRCb9?<TdP8TlP039?<TdRCB00XTdP03001oogoo01Qoo`0017oo00<007ooOol077oo00<007oo
Ool01Woo00/e]cFF=IHaMCFF<GDeUReE<ED]EC5e008]E@0T;C@]EBdd;ED]=2eE:A<]=2TC;C@Y4bdd
:A<]=2Sc:A@TlbTD:?<Y52Cc:A@TlRSc9?8Y4bCb:?<TlRTC9?8XlbCb:?<TdRCc100000HTdRSc9=8T
lbCB:?<29=801R3B9?8TdRCB8=8TlP8TdP048=8TlRCB000JOol000Aoo`03001oogoo01]oo`03001o
ogoo00Qoo`06=GHaMS5f<GHeMReE0c5E00@]EBdd;C@]=@<]=005;CDY52TD:A@]=003:A@9:A<02RCc
:?<TlbSc9?<XlbCc:?<TlbSc0RCc00DTdRCb9?8TlbCB008TlP@000039?<TdRCB00`TdP03001oogoo
01Qoo`0017oo00<007ooOol06goo00<007ooOol027oo00PaMCFF<GDeUReE<ED]EC5e0ReE00@]=2eE
;C@]E@8]=00X:A<]=2TC;C@Y4bdd:A<Y52Sc:A@TlbTD:?<Y52Cc:A@TlRSc9?8Y4bCb:?<TlRTC9?8X
lbCb:?<TdRCc9=8XlbCB9?<TdRSc9=8TlbCB:?<300001BCb9=8TdR3B9?800RCB00LPdRCb9=8TdR3B
9?80000IOol000Aoo`03001oogoo01Yoo`03001oogoo00Yoo`03<GHeMReE00<aE@04;ED]=2dd;CD3
;C@01Bde:A@Y52TD;C@00bTD2BTC00XTlbSc9?<XlbCc:?<TlbSc9?<Xl`8Tl`059=8TlRCb9?<TdP02
9?801BCc9=8TlRCb9?<012CB10002BCB00<007ooOol05goo0004Ool00`00Oomoo`0IOol00`00Oomo
o`0;Ool01CFF;EDaEBeE<GD00ReE01H]=2eE;C@]EBdd;EDY4bdd:A<]=2TC;C@Y4bdd:?<Y52Cc:A@X
lbTD9?<Y508Xl`0F9?8Y4bCb:?<TlRTC9?8XlbCb:?<TdRCc9=8XlbCB9?<TdRSc9=8TlbCB:?<29=80
1b3B9?8TdRCB8=8TlRCB00@000069=8PdRCb9=9oo`006Goo0004Ool00`00Oomoo`0HOol00`00Oomo
o`0<Ool022eE<EDaEC5E;EDaEBdd;CD3;C@01Bde:A@Y52TD;C@00bTD00<]=2TC:A<01bTC00TXlbCc
:?<TlbSc9?<XlbCc:?<00RCc00DTdRCb9?8TlbCB008TlP059?<TdRCb9?8Tl`0>9=8400000goo001o
o`0HOol000=oo`03001oogoo01Qoo`03001oogoo00ioo`0J;EDaMBeE<ED]=2eE;C@]EBdd;EDY4bdd
:A<]=2TC;C@Y4bdd:?<Y52Cc:A@XlbTD9?<Y508Xl`0F9?8Y4bCb:?<TlRTC9?8XlbCb:?<TdRCc9=8X
lbCB9?<TdRSc9=8TlbCB:?<29=801R3B9?8TdRCB8=8TlP8TdP078=8TlRCB9=8PdRCb9=800Woo0P00
6Goo0003Ool00`00Oomoo`0HOol00`00Oomoo`0>Ool01C5E;EDaEBdd;CD00bdd00D]=BTD:A@Y52dd
00<Y5003;C@Y4bTC00LY4`0<:?<TlbSc9?<XlbCc:?<TlbSc9?<XlbCB0RCb00HTlbCB9?8TlRCc9=82
9?800bCc9=8TdP0?9=83Ool00`00Oomoo`0HOol000=oo`03001oogoo01Moo`03001oogoo011oo`0_
<ED]=2eE;C@]EBdd;EDY4bdd:A<]=2TC;C@Y4bTD:?<Y52Cc:A@XlbTD9?<Y52Cb:?<TlRTC9?8XlbCb
:A<TlRSc9?8Y4bCB9?<TdRSc9=8TlbCB:?<TdRCc9=8Xl`029=801R3B9?8TdRCB8=8TlP8TdP078=8T
lRCB9=8PdRCb9=800goo00<007ooOol06Goo0003Ool00`00Oomoo`0FOol00`00Oomoo`0AOol00bdd
;CD]=002;C@01Bde:A@Y52TD;C@00bTD00<]=2TC:A<01RTC00dTlbSc9?<XlbCc:?<TlbSc9?<XlbCc
:?<TdP029?801RCc9=8TlRCb9?<TdP8TlP039?<TdRCB00lTdP9oo`8001aoo`000goo00<007ooOol0
5Goo00<007ooOol04Woo00D]EBdd;ED]=2eE008]=00V:A<]=2TC;C@Y4bdd:?<Y52Cc:A@XlbTD9?<Y
52Cb:?<TlRTC9?8XlbCb:A<TlRSc9?8Y4bCB9?<TdRSc9=8TlbCB:?<TdRCc9=8Xl`8TdP068=8TlRCB
9=8PdRCb0RCB00LPdRCb9=8TdR3B9?8TdP02Ool00`00Oomoo`0LOol000=oo`03001oogoo01Aoo`03
001oogoo01Aoo`8]=005;CD]=2TD:A@]=003:A@00bdd:A<Y4`07:A<02BSc9?<XlbCc:?<TlbSc9?<X
l`029?<01BCB9?8TlRCc9=800RCb00DTlbCB9?8TlRCc014TdP9oo`03001oogoo01eoo`000goo00<0
07ooOol04goo00<007ooOol05Goo018]=2eE:A<]=2TC;C@Y4bdd:A<]=2Sc:A@TlbTD:?<Y52Cc:A@2
:?<05RCb:A<TlRSc9?8Y4bCb:?<TlRSc9=8TlbCB:?<TdRCc9=8XlbCB9?<TdRSc0RCB00HPdRCb9=8T
dR3B9?829=801R3B9?8TdRCB8=8TlP=oo`03001oogoo01ioo`000goo00<007ooOol04goo00<007oo
Ool05Woo00@]=2TD:A@]=0<Y5003;C@Y4bTC00LY4`09:?<TlbSc9?<XlbCc:?<TlbSc008Tl`059=8T
lRCb9?<TdP029?801BCc9=8TlRCb9?<042CB0goo00<007ooOol07goo0003Ool00`00Oomoo`0BOol0
0`00Oomoo`0GOol03bdd:A<]=2TC;C@Y4bdd:?<Y52Cc:A@XlbTD9?<Y5002:?<05RCb:A<TlRSc9?8Y
4bCb:?<TlRSc9=8TlbCB:?<TdRCc9=8XlbCB9?<TdRSc0RCB00HPdRCb9=8TdR3B9?829=801R3B9?8T
dRCB8=8TlP9oo`80029oo`000goo00<007ooOol04Goo00<007ooOol067oo00<Y52dd:A@00RTD00<]
=2TC:A<01RTC00XTlbSc9?<XlbCc:?<TlbSc9?<Xl`8Tl`059=8TlRCb9?<TdP029?801BCc9=8TlRCb
9?<042CB0Woo00<007ooOol08Woo0003Ool00`00Oomoo`0@Ool00`00Oomoo`0JOol032TC;C@Y4bdd
:?<Y52Cc:A@XlbTD9?<Y508Xl`0F9?8Y4bCb:?<TlRTC9?8XlbCb:?<TdRCc9=8XlbCB9?<TdRSc9=8T
lbCB:?<29=801R3B9?8TdRCB8=8TlP8TdP068=8TlRCB9=8PdRCb0Woo00<007ooOol08goo0002Ool0
0`00Oomoo`0@Ool00`00Oomoo`0KOol2:A@00bdd:A<Y4`07:A<02BSc9?<XlbCc:?<TlbSc9?<Xl`02
9?<01BCB9?8TlRCc9=800RCb00@TlbCB9?8TlQ4TdP9oo`03001oogoo02Aoo`000Woo00<007ooOol0
47oo00<007ooOol06goo028Y4bdd:?<Y52Cc:A@XlbTD9?<Y52Cb:?<TlRTC9?8XlbCb:A<TlRSc9?8X
lbCB9?<TdRSc9=8TlbCB:?<TdRCc9=8TlP8TdP068=8TlRCB9=8PdRCb0RCB00DPdRCb9=8TdR3B00=o
o`03001oogoo02Eoo`000Woo00<007ooOol03goo00<007ooOol07Goo00<Y52TC:A<01RTC00TXlbCc
:?<TlbSc9?<XlbCc:?<00RCc00DTdRCb9?8TlbCB008TlP049?<TdRCb9?8?9=84Ool00`00Oomoo`0V
Ool0009oo`03001oogoo00ioo`03001oogoo01ioo`07:A@TlbTD:?<Y52Cc:A@00RSc01HTlRTC9?8X
lbCb:A<TlRSc9?8XlbCB9?<TdRSc9=8TlbCB:?<TdRCc9=8TlP8TdP068=8TlRCB9=8PdRCb0RCB00@P
dRCb9=8TdP=oo`8002Uoo`000Woo00<007ooOol03Goo00<007ooOol07goo1bTC00TXlbCc:?<TlbSc
9?<XlbCc:?<00RCc00DTdRCb9?8TlbCB008TlP049?<TdRCb9?8?9=83Ool00`00Oomoo`0YOol0009o
o`03001oogoo00aoo`03001oogoo025oo`04:?<Y52Cc:A@2:?<05RCb:A<TlRSc9?8Y4bCb:?<TlRSc
9=8TlbCB:?<TdRCc9=8XlbCB9?<TdRCb0RCB00HPdRCb9=8TdR3B9?829=80123B9?8TdRCB0goo00<0
07ooOol0:Woo0002Ool00`00Oomoo`0;Ool00`00Oomoo`0ROol4:A<02BSc9?<XlbCc:?<TlbSc9?<X
l`029?<01BCB9?8TlRCc9=800RCb00@TlbCB9?8TlPlTdP=oo`03001oogoo02]oo`000Woo00<007oo
Ool02goo00<007ooOol08Woo01XTlbTD:?<XlbCb:A<TlRSc9?8Y4bCb:?<TlRSc9=8TlbCB:?<TdRCc
9=8XlbCB9?<TdRCb0RCB00HPdRCb9=8TdR3B9?829=80123B9?8TdRCB0goo00<007ooOol0;7oo0002
Ool00`00Oomoo`0:Ool00`00Oomoo`0TOol02RTC:?<TlbSc9?<XlbCc:?<TlbSc0RCc00DTdRCb9?8T
lbCB008TlP049?<TdRCb9?8?9=82Ool2000_Ool0009oo`03001oogoo00Uoo`03001oogoo02Eoo`0G
:?<TlRTC9?8XlbCb:A<TlRSc9=8XlbCB9?<TdRSc9=8TlbCB:?<TdRCc9=8TlP029=801R3B9?8TdRCB
8=8TlP8TdP048=8TlRCB9=82Ool00`00Oomoo`0_Ool0009oo`03001oogoo00Qoo`03001oogoo02Io
o`089?<XlbCc:?<TlbSc9?<Xl`8Tl`059=8TlRCb9?<TdP029?8012Cc9=8TlRCb3bCB0Woo00<007oo
Ool0<7oo00000goo001oo`09Ool00`00Oomoo`0WOol05BTC9?8XlbCb:A<TlRSc9?8XlbCB9?<TdRSc
9=8TlbCB:?<TdRCc9=8TlP029=801R3B9?8TdRCB8=8TlP8TdP048=8TlRCB9=82Ool00`00Oomoo`0a
Ool00003Ool007oo00Qoo`03001oogoo02Qoo`099?<XlbCc:?<TlbSc9?8TlbCB008TlP079?<TdRCb
9?8TlbCB9?8042CB0Woo00<007ooOol0<Woo00000goo001oo`08Ool00`00Oomoo`0YOol04RCb:A<T
lRSc9=8XlbCB9?<TdRSc9=8TlbCB:?<TdRCc8=8TlP8TdP068=8TlRCB9=8PdRCb0RCB00<PdRCb9=80
0goo00<007ooOol0<goo00000goo001oo`07Ool00`00Oomoo`0ZOol01RSc9?<XlbCb9?<TdP8TlP07
9?<TdRCb9?8TlbCB9?803bCB0Woo0P00=Woo00000goo001oo`06Ool00`00Oomoo`0[Ool042Cb:?<T
dRSc9=8TlbCB:?<TdRCc9=8XlbCB9?<PdRCb0RCB00HPdRCb9=8TdR3B9?829=800b3B9?8TdP02Ool0
0`00Oomoo`0fOol00003Ool007oo00Eoo`03001oogoo02aoo`04:?<TlRCc9=829?801bCc9=8TlRCb
9?<TdRCb00lTdP9oo`03001oogoo03Moo`0000=oo`00Ool017oo00<007ooOol0;Goo00hTdRSc9=8T
lbCB:?<TdRCc9=8XlbCB9?<PdRCb0RCB00HPdRCb9=8TdR3B9?829=800b3B9?8TdP02Ool00`00Oomo
o`0hOol00003Ool007oo00Aoo`03001oogoo02eoo`069?<TdRCb9?8TlbCB0RCb00<TlbCB9?803RCB
0goo00<007ooOol0>Goo00000goo001oo`03Ool00`00Oomoo`0^Ool032CB9?<TdRSc9=8TlbCB:?<T
dRCc8=8TlP8TdP068=8TlRCB9=8PdRCb0RCB00@PdRCbOomoo`8003aoo`0000=oo`00Ool00Woo00<0
07ooOol0<7oo00<TlRCc9=800RCb00<TlbCB9?803RCB0Woo00<007ooOol0?7oo00001@00Oomoogoo
0000<goo00TXlbCB9?<TdRSc9=8Tlb3B9?800RCB00HPdRCb9=8TdR3B9?829=801B3BOomoogoo0000
?goo00001000Oomoo`00=7oo00HTdRCb9?8TlbCB9?8>9=82Ool00`00Oomoo`0nOol00003001oo`00
03Eoo`039?<TdRSc008TdP068=8TlRCB9=8PdRCb0RCB00HPdRCb9=8TdR3B9?82Ool00`00Oomoo`0o
Ool00003001oo`0003Ioo`039?<TdRCB00hTdP03Ool00000049oo`000P00=goo0RCB00HPdRCb9=8T
dR3B9?829=80223B9?8TdRCB8=8TlWoo0014Ool000<003Ioo`hTdP9oo`03001oogoo04=oo`000goo
1@00<Goo00HPdRCb9=8TdR3B9?829=801B3B9?8TdRCB8=800Woo00<007ooOol0A7oo0008Ool5000/
Ool<9=82Ool00`00Oomoo`15Ool000eoo`D002Qoo`039=8PdRCb008TdP058=8TlRCB9=8PdP02Ool0
0`00Oomoo`16Ool0019oo`D002=oo`TTdP03Ool0000004Uoo`005goo1@007Woo00DTlRCB9=8PdRCb
008TdP038=9oo`0004]oo`0077oo10006Woo1RCB0Woo00<007ooOol0BWoo000POol5000EOol00bCB
8=8TlP029=82Ool00`00Oomoo`1;Ool002Eoo`D0015oo`<TdP9oo`03001oogoo04aoo`00:Woo1@00
37oo0RCB00=oo`000000Cgoo000_Ool50007Ool00`00Ool0001AOol003Aoo`D0009oo`80059oo`00
>Goo0`00Dgoo002?Ool008moo`00Sgoo0000\
\>"],
  ImageRangeCache->{{{-13.875, 158.438}, {184.25, 3}} -> {0.183215, \
-0.0890177, 0.00583696, 0.00583696}}]
}, Open  ]],

Cell[TextData[{
  "which is a third-order parabola translated along the ",
  StyleBox["t",
    FontSlant->"Italic"],
  "-axis. This example shows that the introduction of canonical coordinates \
radically simplifies the shape of the skeleton and thus allows access to the \
solution.\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->"third-order parabola"],

Cell["Example 3", "Example"],

Cell["\<\
Another example demonstrating the concept of the skeleton is given \
by the first-order equation\
\>", "Text",
  Evaluatable->False,
  CellTags->"skeleton"],

Cell[CellGroupData[{

Cell[BoxData[
    \(example3 = x\ \[PartialD]\_x u[x] - u[x] + \@\(u[x]\/x\) == 0; 
    example3 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(-u\), "+", 
                SqrtBox[
                  StyleBox[\(u\/x\),
                    ScriptLevel->0]], "+", \(x\ u\_x\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This type of equation is invariant with respect to the global \
transformation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalXi] = x\/\(1 - \[Epsilon]x\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi] = y\/\(1 - \[Epsilon]x\)\)]],
  "; the related canonical variables are ",
  Cell[BoxData[
      \(TraditionalForm\`w = u\/x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t = \(-1\)\/x\)]],
  ". The equation in canonical variables reads"
}], "Text",
  Evaluatable->False,
  CellTags->{"global transformation", "canonical variables"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(cexample3 = \[PartialD]\_t w[t] + \@w[t] == 0; cexample3 // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\@w + w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
Each skeleton of these two equations is represented in the \
following figure:\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\n
        \t\t{Plot3D[u\/x - \@\(u\/x\)\/x, {x,  .1, 1}, {u, 0, 2}, \n\t\t\t\t
            PlotRange \[Rule] All, 
            AxesLabel \[Rule] {"\<x\>", "\<u\>", "\<p\>"}, \n\t\t\t\t
            ViewPoint \[Rule] {\(-2.566\), 1.572, 1.548}, Mesh \[Rule] False, 
            \n\t\t\t\tTicks \[Rule] None, PlotPoints \[Rule] 30, \n\t\t\t\t
            DisplayFunction \[Rule] Identity, 
            BoxRatios \[Rule] {1, 3\/5, 1}], \n\t\t\t
          Plot3D[\(-\@w\), {t,  .1, 1}, {w, 0, 2}, \n\t\t\t\t
            PlotRange \[Rule] All, 
            AxesLabel \[Rule] {"\<t\>", "\<w\>", "\<w'\>"}, \n\t\t\t\t
            ViewPoint \[Rule] {\(-2.566\), 1.572, 1.548}, Mesh \[Rule] False, 
            \n\t\t\t\tTicks \[Rule] None, PlotPoints \[Rule] 30, \n\t\t\t\t
            DisplayFunction \[Rule] Identity, \n\t\t\t\t
            BoxRatios \[Rule] {1, 3\/5, 1}]}], \n\t
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61186 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.014568 0.47619 [
[ 0 0 0 0 ]
[ 1 .61186 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61186 L
0 .61186 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.014568 0.477324 0.597289 MathSubStart
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.235457 1.39492 1.11022e-016 1.39492 [
[.13973 .21216 -12 -12.7992 ]
[.13973 .21216 0 6.2008 ]
[.70223 -0.00719 -6.27755 -19 ]
[.70223 -0.00719 5.72245 0 ]
[1.06018 .61135 0 -6.3528 ]
[1.06018 .61135 12 12.6472 ]
[ 0 0 0 0 ]
[ 1 1.2849 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.46728 0 m
.05486 .44445 L
s
gsave
.13973 .21216 -73 -16.7992 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
.46728 0 L
s
gsave
.70223 -0.00719 -67.2776 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
1 1.03178 L
s
gsave
1.06018 .61135 -61 -10.3528 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
1 1.03178 L
s
1 1.03178 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
.46728 0 m
.92704 .1866 L
s
.45805 .56681 m
.05486 .44445 L
s
.05486 .44445 m
0 1.205 L
s
0 1.205 m
.45756 1.2849 L
s
.45756 1.2849 m
.45805 .56681 L
s
.92704 .1866 m
1 1.03178 L
s
1 1.03178 m
.45756 1.2849 L
s
.45756 1.2849 m
.45805 .56681 L
s
.45805 .56681 m
.92704 .1866 L
s
.46728 0 m
.05486 .44445 L
s
.05486 .44445 m
0 1.205 L
s
0 1.205 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
0 0 m
1 0 L
1 1.2849 L
0 1.2849 L
closepath
clip
newpath
.524 .661 .922 r
.47245 1.24088 .45785 1.23203 .44307 1.23962 .45758 1.24808 Mtetra
.522 .654 .918 r
.48753 1.23358 .47285 1.22431 .45785 1.23203 .47245 1.24088 Mtetra
.52 .646 .913 r
.50283 1.22617 .48807 1.21644 .47285 1.22431 .48753 1.23358 Mtetra
.518 .638 .907 r
.51835 1.21866 .5035 1.20842 .48807 1.21644 .50283 1.22617 Mtetra
.516 .63 .902 r
.53409 1.21103 .51916 1.20025 .5035 1.20842 .51835 1.21866 Mtetra
.513 .62 .896 r
.55007 1.20329 .53505 1.19191 .51916 1.20025 .53409 1.21103 Mtetra
.51 .611 .889 r
.56629 1.19544 .55117 1.18339 .53505 1.19191 .55007 1.20329 Mtetra
.507 .6 .882 r
.58275 1.18747 .56753 1.17468 .55117 1.18339 .56629 1.19544 Mtetra
.503 .589 .874 r
.59946 1.17938 .58413 1.16578 .56753 1.17468 .58275 1.18747 Mtetra
.499 .578 .865 r
.61643 1.17116 .60098 1.15665 .58413 1.16578 .59946 1.17938 Mtetra
.495 .565 .856 r
.63365 1.16282 .61808 1.14729 .60098 1.15665 .61643 1.17116 Mtetra
.49 .552 .846 r
.65114 1.15435 .63544 1.13766 .61808 1.14729 .63365 1.16282 Mtetra
.486 .538 .836 r
.66891 1.14575 .65306 1.12775 .63544 1.13766 .65114 1.15435 Mtetra
.48 .523 .825 r
.68695 1.13701 .67094 1.11752 .65306 1.12775 .66891 1.14575 Mtetra
.475 .508 .812 r
.70528 1.12813 .68909 1.10693 .67094 1.11752 .68695 1.13701 Mtetra
.468 .492 .8 r
.7239 1.11911 .70751 1.09592 .68909 1.10693 .70528 1.12813 Mtetra
.462 .475 .786 r
.74282 1.10995 .72621 1.08442 .70751 1.09592 .7239 1.11911 Mtetra
.455 .457 .771 r
.76205 1.10064 .74518 1.07234 .72621 1.08442 .74282 1.10995 Mtetra
.447 .439 .756 r
.78159 1.09117 .76441 1.05957 .74518 1.07234 .76205 1.10064 Mtetra
.44 .42 .74 r
.80146 1.08155 .78391 1.04594 .76441 1.05957 .78159 1.09117 Mtetra
.431 .4 .723 r
.82165 1.07178 .80366 1.03121 .78391 1.04594 .80146 1.08155 Mtetra
.423 .38 .706 r
.84219 1.06183 .82364 1.01505 .80366 1.03121 .82165 1.07178 Mtetra
.414 .36 .689 r
.86307 1.05172 .84382 .99696 .82364 1.01505 .84219 1.06183 Mtetra
.405 .34 .671 r
.8843 1.04144 .86412 .97616 .84382 .99696 .86307 1.05172 Mtetra
.397 .32 .653 r
.9059 1.03097 .88446 .95138 .86412 .97616 .8843 1.04144 Mtetra
.388 .301 .636 r
.92788 1.02033 .90462 .92039 .88446 .95138 .9059 1.03097 Mtetra
.379 .283 .619 r
.95024 1.0095 .92424 .87903 .90462 .92039 .92788 1.02033 Mtetra
.371 .265 .603 r
.973 .99848 .9425 .81859 .92424 .87903 .95024 1.0095 Mtetra
.364 .25 .588 r
.99616 .98727 .95744 .71803 .9425 .81859 .973 .99848 Mtetra
.558 .778 .981 r
.45785 1.23203 .44319 1.22804 .42847 1.23576 .44307 1.23962 Mtetra
.558 .776 .98 r
.47285 1.22431 .45812 1.22016 .44319 1.22804 .45785 1.23203 Mtetra
.558 .773 .978 r
.48807 1.21644 .47327 1.21213 .45812 1.22016 .47285 1.22431 Mtetra
.559 .77 .977 r
.5035 1.20842 .48863 1.20394 .47327 1.21213 .48807 1.21644 Mtetra
.559 .766 .975 r
.51916 1.20025 .50422 1.19557 .48863 1.20394 .5035 1.20842 Mtetra
.56 .762 .973 r
.53505 1.19191 .52004 1.18702 .50422 1.19557 .51916 1.20025 Mtetra
.56 .758 .97 r
.55117 1.18339 .53608 1.17827 .52004 1.18702 .53505 1.19191 Mtetra
.561 .754 .968 r
.56753 1.17468 .55237 1.16931 .53608 1.17827 .55117 1.18339 Mtetra
.562 .748 .965 r
.58413 1.16578 .56889 1.16012 .55237 1.16931 .56753 1.17468 Mtetra
.562 .742 .961 r
.60098 1.15665 .58566 1.15068 .56889 1.16012 .58413 1.16578 Mtetra
.563 .736 .957 r
.61808 1.14729 .60268 1.14096 .58566 1.15068 .60098 1.15665 Mtetra
.563 .728 .952 r
.63544 1.13766 .61996 1.13094 .60268 1.14096 .61808 1.14729 Mtetra
.563 .72 .947 r
.65306 1.12775 .63749 1.12058 .61996 1.13094 .63544 1.13766 Mtetra
.564 .711 .94 r
.67094 1.11752 .65528 1.10984 .63749 1.12058 .65306 1.12775 Mtetra
.564 .7 .933 r
.68909 1.10693 .67333 1.09865 .65528 1.10984 .67094 1.11752 Mtetra
.564 .689 .924 r
.70751 1.09592 .69165 1.08695 .67333 1.09865 .68909 1.10693 Mtetra
.564 .675 .914 r
.72621 1.08442 .71024 1.07464 .69165 1.08695 .70751 1.09592 Mtetra
.564 .66 .902 r
.74518 1.07234 .72908 1.06161 .71024 1.07464 .72621 1.08442 Mtetra
.564 .644 .888 r
.76441 1.05957 .74818 1.04768 .72908 1.06161 .74518 1.07234 Mtetra
.563 .625 .872 r
.78391 1.04594 .76753 1.03265 .74818 1.04768 .76441 1.05957 Mtetra
.562 .604 .853 r
.80366 1.03121 .7871 1.01619 .76753 1.03265 .78391 1.04594 Mtetra
.561 .582 .832 r
.82364 1.01505 .80687 .99785 .7871 1.01619 .80366 1.03121 Mtetra
.559 .557 .808 r
.84382 .99696 .82678 .97694 .80687 .99785 .82364 1.01505 Mtetra
.558 .532 .782 r
.86412 .97616 .84676 .95242 .82678 .97694 .84382 .99696 Mtetra
.557 .505 .753 r
.88446 .95138 .86665 .92256 .84676 .95242 .86412 .97616 Mtetra
.557 .48 .723 r
.90462 .92039 .88621 .88433 .86665 .92256 .88446 .95138 Mtetra
.56 .456 .693 r
.92424 .87903 .90492 .83213 .88621 .88433 .90462 .92039 Mtetra
.566 .436 .663 r
.9425 .81859 .92174 .75424 .90492 .83213 .92424 .87903 Mtetra
.578 .423 .635 r
.95744 .71803 .93411 .62274 .92174 .75424 .9425 .81859 Mtetra
.563 .8 .988 r
.44319 1.22804 .42846 1.22482 .4138 1.23265 .42847 1.23576 Mtetra
.564 .798 .987 r
.45812 1.22016 .44332 1.21684 .42846 1.22482 .44319 1.22804 Mtetra
.565 .796 .986 r
.47327 1.21213 .4584 1.2087 .44332 1.21684 .45812 1.22016 Mtetra
.566 .795 .985 r
.48863 1.20394 .4737 1.20038 .4584 1.2087 .47327 1.21213 Mtetra
.567 .792 .984 r
.50422 1.19557 .48921 1.19188 .4737 1.20038 .48863 1.20394 Mtetra
.569 .79 .983 r
.52004 1.18702 .50496 1.18319 .48921 1.19188 .50422 1.19557 Mtetra
.57 .787 .981 r
.53608 1.17827 .52094 1.17428 .50496 1.18319 .52004 1.18702 Mtetra
.572 .784 .979 r
.55237 1.16931 .53715 1.16514 .52094 1.17428 .53608 1.17827 Mtetra
.573 .781 .977 r
.56889 1.16012 .5536 1.15575 .53715 1.16514 .55237 1.16931 Mtetra
.575 .777 .974 r
.58566 1.15068 .5703 1.1461 .5536 1.15575 .56889 1.16012 Mtetra
.577 .772 .972 r
.60268 1.14096 .58724 1.13614 .5703 1.1461 .58566 1.15068 Mtetra
.58 .767 .968 r
.61996 1.13094 .60444 1.12584 .58724 1.13614 .60268 1.14096 Mtetra
.582 .762 .964 r
.63749 1.12058 .62189 1.11517 .60444 1.12584 .61996 1.13094 Mtetra
.585 .755 .959 r
.65528 1.10984 .6396 1.10407 .62189 1.11517 .63749 1.12058 Mtetra
.588 .747 .953 r
.67333 1.09865 .65757 1.09247 .6396 1.10407 .65528 1.10984 Mtetra
.591 .738 .946 r
.69165 1.08695 .67581 1.08029 .65757 1.09247 .67333 1.09865 Mtetra
.594 .728 .937 r
.71024 1.07464 .6943 1.06742 .67581 1.08029 .69165 1.08695 Mtetra
.598 .716 .927 r
.72908 1.06161 .71304 1.05372 .6943 1.06742 .71024 1.07464 Mtetra
.601 .703 .915 r
.74818 1.04768 .73203 1.039 .71304 1.05372 .72908 1.06161 Mtetra
.605 .687 .9 r
.76753 1.03265 .75126 1.02299 .73203 1.039 .74818 1.04768 Mtetra
.609 .668 .882 r
.7871 1.01619 .7707 1.00531 .75126 1.02299 .76753 1.03265 Mtetra
.613 .648 .861 r
.80687 .99785 .79032 .98544 .7707 1.00531 .7871 1.01619 Mtetra
.617 .625 .836 r
.82678 .97694 .81005 .96255 .79032 .98544 .80687 .99785 Mtetra
.621 .6 .807 r
.84676 .95242 .8298 .9354 .81005 .96255 .82678 .97694 Mtetra
.625 .573 .776 r
.86665 .92256 .8494 .90193 .8298 .9354 .84676 .95242 Mtetra
.63 .547 .741 r
.88621 .88433 .86855 .85857 .8494 .90193 .86665 .92256 Mtetra
.637 .522 .706 r
.90492 .83213 .88668 .79865 .86855 .85857 .88621 .88433 Mtetra
.646 .5 .67 r
.92174 .75424 .90258 .70837 .88668 .79865 .90492 .83213 Mtetra
.66 .486 .638 r
.93411 .62274 .91332 .55504 .90258 .70837 .92174 .75424 Mtetra
.566 .811 .991 r
.42846 1.22482 .41364 1.22201 .39906 1.22991 .4138 1.23265 Mtetra
.567 .81 .99 r
.44332 1.21684 .42844 1.21395 .41364 1.22201 .42846 1.22482 Mtetra
.568 .809 .989 r
.4584 1.2087 .44345 1.20572 .42844 1.21395 .44332 1.21684 Mtetra
.57 .807 .989 r
.4737 1.20038 .45868 1.19731 .44345 1.20572 .4584 1.2087 Mtetra
.572 .806 .988 r
.48921 1.19188 .47413 1.1887 .45868 1.19731 .4737 1.20038 Mtetra
.573 .804 .987 r
.50496 1.18319 .48981 1.17989 .47413 1.1887 .48921 1.19188 Mtetra
.575 .802 .985 r
.52094 1.17428 .50572 1.17086 .48981 1.17989 .50496 1.18319 Mtetra
.578 .8 .984 r
.53715 1.16514 .52186 1.16158 .50572 1.17086 .52094 1.17428 Mtetra
.58 .798 .982 r
.5536 1.15575 .53824 1.15205 .52186 1.16158 .53715 1.16514 Mtetra
.583 .795 .98 r
.5703 1.1461 .55487 1.14222 .53824 1.15205 .5536 1.15575 Mtetra
.586 .792 .978 r
.58724 1.13614 .57174 1.13207 .55487 1.14222 .5703 1.1461 Mtetra
.589 .788 .975 r
.60444 1.12584 .58886 1.12157 .57174 1.13207 .58724 1.13614 Mtetra
.593 .784 .971 r
.62189 1.11517 .60624 1.11066 .58886 1.12157 .60444 1.12584 Mtetra
.597 .779 .967 r
.6396 1.10407 .62388 1.09928 .60624 1.11066 .62189 1.11517 Mtetra
.602 .773 .962 r
.65757 1.09247 .64177 1.08736 .62388 1.09928 .6396 1.10407 Mtetra
.607 .766 .956 r
.67581 1.08029 .65992 1.07482 .64177 1.08736 .65757 1.09247 Mtetra
.612 .758 .948 r
.6943 1.06742 .67833 1.06152 .65992 1.07482 .67581 1.08029 Mtetra
.618 .748 .938 r
.71304 1.05372 .69698 1.0473 .67833 1.06152 .6943 1.06742 Mtetra
.625 .736 .927 r
.73203 1.039 .71589 1.03195 .69698 1.0473 .71304 1.05372 Mtetra
.632 .722 .912 r
.75126 1.02299 .73501 1.01518 .71589 1.03195 .73203 1.039 Mtetra
.639 .705 .895 r
.7707 1.00531 .75434 .99656 .73501 1.01518 .75126 1.02299 Mtetra
.647 .686 .873 r
.79032 .98544 .77384 .97548 .75434 .99656 .7707 1.00531 Mtetra
.654 .664 .847 r
.81005 .96255 .79342 .95105 .77384 .97548 .79032 .98544 Mtetra
.662 .64 .817 r
.8298 .9354 .813 .92183 .79342 .95105 .81005 .96255 Mtetra
.669 .613 .783 r
.8494 .90193 .83239 .88551 .813 .92183 .8298 .9354 Mtetra
.676 .586 .746 r
.86855 .85857 .85125 .83808 .83239 .88551 .8494 .90193 Mtetra
.685 .56 .707 r
.88668 .79865 .86896 .77203 .85125 .83808 .86855 .85857 Mtetra
.694 .537 .669 r
.90258 .70837 .88421 .67191 .86896 .77203 .88668 .79865 Mtetra
.707 .52 .634 r
.91332 .55504 .89384 .50132 .88421 .67191 .90258 .70837 Mtetra
.568 .818 .992 r
.41364 1.22201 .39875 1.21945 .38423 1.22742 .39906 1.22991 Mtetra
.569 .817 .992 r
.42844 1.21395 .41348 1.21132 .39875 1.21945 .41364 1.22201 Mtetra
.571 .816 .991 r
.44345 1.20572 .42842 1.20302 .41348 1.21132 .42844 1.21395 Mtetra
.572 .815 .99 r
.45868 1.19731 .44358 1.19453 .42842 1.20302 .44345 1.20572 Mtetra
.574 .815 .99 r
.47413 1.1887 .45897 1.18584 .44358 1.19453 .45868 1.19731 Mtetra
.576 .813 .989 r
.48981 1.17989 .47458 1.17694 .45897 1.18584 .47413 1.1887 Mtetra
.579 .812 .988 r
.50572 1.17086 .49042 1.1678 .47458 1.17694 .48981 1.17989 Mtetra
.581 .811 .986 r
.52186 1.16158 .50649 1.15842 .49042 1.1678 .50572 1.17086 Mtetra
.584 .809 .985 r
.53824 1.15205 .5228 1.14876 .50649 1.15842 .52186 1.16158 Mtetra
.588 .807 .983 r
.55487 1.14222 .53936 1.1388 .5228 1.14876 .53824 1.15205 Mtetra
.591 .804 .981 r
.57174 1.13207 .55616 1.1285 .53936 1.1388 .55487 1.14222 Mtetra
.596 .802 .979 r
.58886 1.12157 .57321 1.11782 .55616 1.1285 .57174 1.13207 Mtetra
.6 .798 .975 r
.60624 1.11066 .59052 1.10671 .57321 1.11782 .58886 1.12157 Mtetra
.605 .794 .972 r
.62388 1.09928 .60808 1.09511 .59052 1.10671 .60624 1.11066 Mtetra
.611 .789 .967 r
.64177 1.08736 .6259 1.08294 .60808 1.09511 .62388 1.09928 Mtetra
.618 .784 .961 r
.65992 1.07482 .64397 1.0701 .6259 1.08294 .64177 1.08736 Mtetra
.625 .777 .954 r
.67833 1.06152 .6623 1.05644 .64397 1.0701 .65992 1.07482 Mtetra
.633 .768 .945 r
.69698 1.0473 .68088 1.04181 .6623 1.05644 .67833 1.06152 Mtetra
.641 .758 .933 r
.71589 1.03195 .6997 1.02595 .68088 1.04181 .69698 1.0473 Mtetra
.65 .745 .919 r
.73501 1.01518 .71874 1.00855 .6997 1.02595 .71589 1.03195 Mtetra
.66 .73 .901 r
.75434 .99656 .73797 .98915 .71874 1.00855 .73501 1.01518 Mtetra
.67 .712 .879 r
.77384 .97548 .75736 .96709 .73797 .98915 .75434 .99656 Mtetra
.68 .69 .853 r
.79342 .95105 .77683 .94136 .75736 .96709 .77384 .97548 Mtetra
.69 .666 .821 r
.813 .92183 .79628 .91043 .77683 .94136 .79342 .95105 Mtetra
.699 .639 .786 r
.83239 .88551 .81549 .87174 .79628 .91043 .813 .92183 Mtetra
.708 .611 .746 r
.85125 .83808 .83414 .8209 .81549 .87174 .83239 .88551 Mtetra
.717 .584 .706 r
.86896 .77203 .85154 .74973 .83414 .8209 .85125 .83808 Mtetra
.726 .56 .666 r
.88421 .67191 .86632 .64136 .85154 .74973 .86896 .77203 Mtetra
.737 .542 .63 r
.89384 .50132 .87516 .45635 .86632 .64136 .88421 .67191 Mtetra
.569 .823 .993 r
.39875 1.21945 .38377 1.21707 .36932 1.22509 .38423 1.22742 Mtetra
.57 .822 .993 r
.41348 1.21132 .39844 1.20888 .38377 1.21707 .39875 1.21945 Mtetra
.572 .822 .992 r
.42842 1.20302 .41331 1.20052 .39844 1.20888 .41348 1.21132 Mtetra
.574 .821 .992 r
.44358 1.19453 .4284 1.19196 .41331 1.20052 .42842 1.20302 Mtetra
.576 .821 .991 r
.45897 1.18584 .44372 1.1832 .4284 1.19196 .44358 1.19453 Mtetra
.579 .82 .99 r
.47458 1.17694 .45926 1.17422 .44372 1.1832 .45897 1.18584 Mtetra
.581 .819 .989 r
.49042 1.1678 .47503 1.165 .45926 1.17422 .47458 1.17694 Mtetra
.584 .818 .988 r
.50649 1.15842 .49103 1.15552 .47503 1.165 .49042 1.1678 Mtetra
.588 .817 .987 r
.5228 1.14876 .50728 1.14576 .49103 1.15552 .50649 1.15842 Mtetra
.591 .815 .985 r
.53936 1.1388 .52376 1.13569 .50728 1.14576 .5228 1.14876 Mtetra
.595 .813 .983 r
.55616 1.1285 .5405 1.12526 .52376 1.13569 .53936 1.1388 Mtetra
.6 .811 .981 r
.57321 1.11782 .55748 1.11444 .5405 1.12526 .55616 1.1285 Mtetra
.606 .809 .978 r
.59052 1.10671 .57471 1.10317 .55748 1.11444 .57321 1.11782 Mtetra
.611 .805 .974 r
.60808 1.09511 .5922 1.09139 .57471 1.10317 .59052 1.10671 Mtetra
.618 .801 .97 r
.6259 1.08294 .60995 1.079 .5922 1.09139 .60808 1.09511 Mtetra
.626 .796 .964 r
.64397 1.0701 .62795 1.0659 .60995 1.079 .6259 1.08294 Mtetra
.634 .79 .957 r
.6623 1.05644 .64621 1.05195 .62795 1.0659 .64397 1.0701 Mtetra
.643 .783 .948 r
.68088 1.04181 .66471 1.03696 .64621 1.05195 .6623 1.05644 Mtetra
.654 .773 .937 r
.6997 1.02595 .68345 1.02068 .66471 1.03696 .68088 1.04181 Mtetra
.665 .762 .922 r
.71874 1.00855 .70241 1.00275 .68345 1.02068 .6997 1.02595 Mtetra
.676 .747 .904 r
.73797 .98915 .72156 .9827 .70241 1.00275 .71874 1.00855 Mtetra
.688 .73 .882 r
.75736 .96709 .74086 .95979 .72156 .9827 .73797 .98915 Mtetra
.7 .709 .855 r
.77683 .94136 .76024 .93297 .74086 .95979 .75736 .96709 Mtetra
.711 .684 .822 r
.79628 .91043 .77957 .90056 .76024 .93297 .77683 .94136 Mtetra
.722 .657 .785 r
.81549 .87174 .79865 .85984 .77957 .90056 .79628 .91043 Mtetra
.731 .629 .744 r
.83414 .8209 .81713 .80607 .79865 .85984 .81549 .87174 Mtetra
.739 .6 .702 r
.85154 .74973 .83431 .73046 .81713 .80607 .83414 .8209 Mtetra
.748 .575 .662 r
.86632 .64136 .84875 .61496 .83431 .73046 .85154 .74973 Mtetra
.757 .556 .625 r
.87516 .45635 .85703 .41747 .84875 .61496 .86632 .64136 Mtetra
.57 .826 .994 r
.38377 1.21707 .36871 1.21482 .35432 1.22289 .36932 1.22509 Mtetra
.571 .826 .993 r
.39844 1.20888 .38331 1.20658 .36871 1.21482 .38377 1.21707 Mtetra
.573 .826 .993 r
.41331 1.20052 .39811 1.19816 .38331 1.20658 .39844 1.20888 Mtetra
.575 .826 .992 r
.4284 1.19196 .41314 1.18955 .39811 1.19816 .41331 1.20052 Mtetra
.578 .825 .992 r
.44372 1.1832 .42838 1.18073 .41314 1.18955 .4284 1.19196 Mtetra
.58 .825 .991 r
.45926 1.17422 .44386 1.17168 .42838 1.18073 .44372 1.1832 Mtetra
.583 .824 .99 r
.47503 1.165 .45956 1.16239 .44386 1.17168 .45926 1.17422 Mtetra
.586 .823 .989 r
.49103 1.15552 .47549 1.15284 .45956 1.16239 .47503 1.165 Mtetra
.59 .823 .988 r
.50728 1.14576 .49167 1.14299 .47549 1.15284 .49103 1.15552 Mtetra
.594 .821 .986 r
.52376 1.13569 .50808 1.13281 .49167 1.14299 .50728 1.14576 Mtetra
.599 .82 .985 r
.5405 1.12526 .52475 1.12228 .50808 1.13281 .52376 1.13569 Mtetra
.604 .818 .982 r
.55748 1.11444 .54166 1.11134 .52475 1.12228 .5405 1.12526 Mtetra
.61 .816 .98 r
.57471 1.10317 .55882 1.09993 .54166 1.11134 .55748 1.11444 Mtetra
.616 .814 .976 r
.5922 1.09139 .57624 1.08799 .55882 1.09993 .57471 1.10317 Mtetra
.624 .81 .972 r
.60995 1.079 .59392 1.07542 .57624 1.08799 .5922 1.09139 Mtetra
.632 .806 .966 r
.62795 1.0659 .61185 1.06211 .59392 1.07542 .60995 1.079 Mtetra
.641 .801 .959 r
.64621 1.05195 .63003 1.0479 .61185 1.06211 .62795 1.0659 Mtetra
.652 .794 .95 r
.66471 1.03696 .64846 1.03261 .63003 1.0479 .64621 1.05195 Mtetra
.663 .785 .939 r
.68345 1.02068 .66713 1.01596 .64846 1.03261 .66471 1.03696 Mtetra
.676 .774 .924 r
.70241 1.00275 .68602 .99758 .66713 1.01596 .68345 1.02068 Mtetra
.689 .76 .906 r
.72156 .9827 .70509 .97696 .68602 .99758 .70241 1.00275 Mtetra
.702 .743 .883 r
.74086 .95979 .72431 .95332 .70509 .97696 .72156 .9827 Mtetra
.715 .722 .855 r
.76024 .93297 .7436 .92554 .72431 .95332 .74086 .95979 Mtetra
.728 .698 .822 r
.77957 .90056 .76284 .89185 .7436 .92554 .76024 .93297 Mtetra
.739 .67 .783 r
.79865 .85984 .78182 .84934 .76284 .89185 .77957 .90056 Mtetra
.748 .641 .742 r
.81713 .80607 .80017 .79299 .78182 .84934 .79865 .85984 Mtetra
.756 .612 .699 r
.83431 .73046 .81719 .71346 .80017 .79299 .81713 .80607 Mtetra
.764 .586 .657 r
.84875 .61496 .83139 .59165 .81719 .71346 .83431 .73046 Mtetra
.772 .566 .621 r
.85703 .41747 .83929 .38315 .83139 .59165 .84875 .61496 Mtetra
.57 .829 .994 r
.36871 1.21482 .35357 1.21267 .33925 1.22078 .35432 1.22289 Mtetra
.572 .829 .994 r
.38331 1.20658 .36809 1.20439 .35357 1.21267 .36871 1.21482 Mtetra
.574 .829 .993 r
.39811 1.19816 .38283 1.19593 .36809 1.20439 .38331 1.20658 Mtetra
.576 .829 .993 r
.41314 1.18955 .39779 1.18726 .38283 1.19593 .39811 1.19816 Mtetra
.579 .829 .992 r
.42838 1.18073 .41296 1.17839 .39779 1.18726 .41314 1.18955 Mtetra
.581 .829 .992 r
.44386 1.17168 .42836 1.16928 .41296 1.17839 .42838 1.18073 Mtetra
.584 .828 .991 r
.45956 1.16239 .444 1.15993 .42836 1.16928 .44386 1.17168 Mtetra
.588 .828 .99 r
.47549 1.15284 .45986 1.15031 .444 1.15993 .45956 1.16239 Mtetra
.592 .827 .989 r
.49167 1.14299 .47597 1.14038 .45986 1.15031 .47549 1.15284 Mtetra
.596 .826 .987 r
.50808 1.13281 .49231 1.13013 .47597 1.14038 .49167 1.14299 Mtetra
.601 .825 .986 r
.52475 1.12228 .5089 1.1195 .49231 1.13013 .50808 1.13281 Mtetra
.607 .824 .983 r
.54166 1.11134 .52575 1.10845 .5089 1.1195 .52475 1.12228 Mtetra
.613 .822 .981 r
.55882 1.09993 .54284 1.09693 .52575 1.10845 .54166 1.11134 Mtetra
.62 .82 .977 r
.57624 1.08799 .56019 1.08485 .54284 1.09693 .55882 1.09993 Mtetra
.628 .817 .973 r
.59392 1.07542 .5778 1.07212 .56019 1.08485 .57624 1.08799 Mtetra
.637 .814 .968 r
.61185 1.06211 .59566 1.05862 .5778 1.07212 .59392 1.07542 Mtetra
.647 .809 .961 r
.63003 1.0479 .61377 1.0442 .59566 1.05862 .61185 1.06211 Mtetra
.659 .803 .952 r
.64846 1.03261 .63213 1.02865 .61377 1.0442 .63003 1.0479 Mtetra
.671 .794 .94 r
.66713 1.01596 .65073 1.01168 .63213 1.02865 .64846 1.03261 Mtetra
.685 .784 .926 r
.68602 .99758 .66955 .9929 .65073 1.01168 .66713 1.01596 Mtetra
.699 .771 .907 r
.70509 .97696 .68855 .97178 .66955 .9929 .68602 .99758 Mtetra
.714 .754 .884 r
.72431 .95332 .7077 .9475 .68855 .97178 .70509 .97696 Mtetra
.728 .733 .855 r
.7436 .92554 .72692 .91888 .7077 .9475 .72431 .95332 Mtetra
.741 .708 .821 r
.76284 .89185 .74608 .88405 .72692 .91888 .7436 .92554 Mtetra
.752 .68 .781 r
.78182 .84934 .76498 .83994 .74608 .88405 .76284 .89185 Mtetra
.762 .65 .739 r
.80017 .79299 .78323 .78129 .76498 .83994 .78182 .84934 Mtetra
.77 .621 .695 r
.81719 .71346 .80013 .69826 .78323 .78129 .80017 .79299 Mtetra
.776 .595 .654 r
.83139 .59165 .81418 .57077 .80013 .69826 .81719 .71346 Mtetra
.783 .574 .617 r
.83929 .38315 .82185 .35237 .81418 .57077 .83139 .59165 Mtetra
.57 .832 .995 r
.35357 1.21267 .33833 1.21061 .32408 1.21875 .33925 1.22078 Mtetra
.572 .832 .994 r
.36809 1.20439 .35279 1.20229 .33833 1.21061 .35357 1.21267 Mtetra
.574 .832 .994 r
.38283 1.19593 .36746 1.19378 .35279 1.20229 .36809 1.20439 Mtetra
.577 .832 .993 r
.39779 1.18726 .38235 1.18508 .36746 1.19378 .38283 1.19593 Mtetra
.579 .832 .993 r
.41296 1.17839 .39745 1.17615 .38235 1.18508 .39779 1.18726 Mtetra
.582 .832 .992 r
.42836 1.16928 .41278 1.167 .39745 1.17615 .41296 1.17839 Mtetra
.585 .831 .991 r
.444 1.15993 .42834 1.15759 .41278 1.167 .42836 1.16928 Mtetra
.589 .831 .99 r
.45986 1.15031 .44414 1.14791 .42834 1.15759 .444 1.15993 Mtetra
.593 .831 .989 r
.47597 1.14038 .46017 1.13792 .44414 1.14791 .45986 1.15031 Mtetra
.598 .83 .988 r
.49231 1.13013 .47645 1.12759 .46017 1.13792 .47597 1.14038 Mtetra
.603 .83 .986 r
.5089 1.1195 .49297 1.11688 .47645 1.12759 .49231 1.13013 Mtetra
.609 .829 .984 r
.52575 1.10845 .50974 1.10574 .49297 1.11688 .5089 1.1195 Mtetra
.615 .827 .982 r
.54284 1.09693 .52677 1.09411 .50974 1.10574 .52575 1.10845 Mtetra
.623 .825 .978 r
.56019 1.08485 .54405 1.08191 .52677 1.09411 .54284 1.09693 Mtetra
.632 .823 .974 r
.5778 1.07212 .56158 1.06905 .54405 1.08191 .56019 1.08485 Mtetra
.641 .82 .969 r
.59566 1.05862 .57937 1.05539 .56158 1.06905 .5778 1.07212 Mtetra
.652 .815 .962 r
.61377 1.0442 .59742 1.04078 .57937 1.05539 .59566 1.05862 Mtetra
.664 .81 .953 r
.63213 1.02865 .61571 1.02499 .59742 1.04078 .61377 1.0442 Mtetra
.678 .802 .941 r
.65073 1.01168 .63424 1.00774 .61571 1.02499 .63213 1.02865 Mtetra
.692 .792 .926 r
.66955 .9929 .65299 .98862 .63424 1.00774 .65073 1.01168 Mtetra
.707 .779 .907 r
.68855 .97178 .67193 .96705 .65299 .98862 .66955 .9929 Mtetra
.723 .762 .884 r
.7077 .9475 .69102 .94221 .67193 .96705 .68855 .97178 Mtetra
.738 .741 .854 r
.72692 .91888 .71017 .91284 .69102 .94221 .7077 .9475 Mtetra
.752 .716 .819 r
.74608 .88405 .72927 .87698 .71017 .91284 .72692 .91888 Mtetra
.763 .688 .779 r
.76498 .83994 .7481 .83145 .72927 .87698 .74608 .88405 Mtetra
.773 .658 .736 r
.78323 .78129 .76629 .77071 .7481 .83145 .76498 .83994 Mtetra
.78 .628 .692 r
.80013 .69826 .78311 .68449 .76629 .77071 .78323 .78129 Mtetra
.786 .601 .65 r
.81418 .57077 .79707 .55184 .78311 .68449 .80013 .69826 Mtetra
.791 .579 .614 r
.82185 .35237 .80463 .32444 .79707 .55184 .81418 .57077 Mtetra
.571 .834 .995 r
.33833 1.21061 .32301 1.20861 .30884 1.21679 .32408 1.21875 Mtetra
.572 .834 .995 r
.35279 1.20229 .3374 1.20026 .32301 1.20861 .33833 1.21061 Mtetra
.575 .834 .994 r
.36746 1.19378 .352 1.19171 .3374 1.20026 .35279 1.20229 Mtetra
.577 .834 .994 r
.38235 1.18508 .36681 1.18297 .352 1.19171 .36746 1.19378 Mtetra
.58 .834 .993 r
.39745 1.17615 .38185 1.174 .36681 1.18297 .38235 1.18508 Mtetra
.583 .834 .993 r
.41278 1.167 .39711 1.1648 .38185 1.174 .39745 1.17615 Mtetra
.586 .834 .992 r
.42834 1.15759 .4126 1.15535 .39711 1.1648 .41278 1.167 Mtetra
.59 .834 .991 r
.44414 1.14791 .42832 1.14561 .4126 1.15535 .42834 1.15759 Mtetra
.594 .834 .99 r
.46017 1.13792 .44429 1.13556 .42832 1.14561 .44414 1.14791 Mtetra
.599 .834 .989 r
.47645 1.12759 .46049 1.12517 .44429 1.13556 .46017 1.13792 Mtetra
.604 .833 .987 r
.49297 1.11688 .47694 1.11439 .46049 1.12517 .47645 1.12759 Mtetra
.61 .832 .985 r
.50974 1.10574 .49364 1.10318 .47694 1.11439 .49297 1.11688 Mtetra
.617 .831 .982 r
.52677 1.09411 .5106 1.09146 .49364 1.10318 .50974 1.10574 Mtetra
.625 .83 .979 r
.54405 1.08191 .52781 1.07915 .5106 1.09146 .52677 1.09411 Mtetra
.634 .828 .975 r
.56158 1.06905 .54527 1.06617 .52781 1.07915 .54405 1.08191 Mtetra
.645 .825 .969 r
.57937 1.05539 .56299 1.05237 .54527 1.06617 .56158 1.06905 Mtetra
.656 .821 .963 r
.59742 1.04078 .58097 1.03759 .56299 1.05237 .57937 1.05539 Mtetra
.669 .815 .954 r
.61571 1.02499 .5992 1.0216 .58097 1.03759 .59742 1.04078 Mtetra
.683 .808 .942 r
.63424 1.00774 .61766 1.0041 .5992 1.0216 .61571 1.02499 Mtetra
.699 .798 .927 r
.65299 .98862 .63635 .98467 .61766 1.0041 .63424 1.00774 Mtetra
.715 .785 .908 r
.67193 .96705 .65523 .96271 .63635 .98467 .65299 .98862 Mtetra
.731 .769 .883 r
.69102 .94221 .67425 .93736 .65523 .96271 .67193 .96705 Mtetra
.746 .748 .853 r
.71017 .91284 .69334 .90731 .67425 .93736 .69102 .94221 Mtetra
.761 .723 .817 r
.72927 .87698 .71239 .87053 .69334 .90731 .71017 .91284 Mtetra
.772 .694 .777 r
.7481 .83145 .73117 .8237 .71239 .87053 .72927 .87698 Mtetra
.782 .663 .733 r
.76629 .77071 .74931 .76106 .73117 .8237 .7481 .83145 Mtetra
.788 .633 .688 r
.78311 .68449 .7661 .67192 .74931 .76106 .76629 .77071 Mtetra
.794 .606 .647 r
.79707 .55184 .78002 .53454 .7661 .67192 .78311 .68449 Mtetra
.798 .584 .611 r
.80463 .32444 .78758 .29887 .78002 .53454 .79707 .55184 Mtetra
.571 .835 .995 r
.32301 1.20861 .30761 1.20667 .2935 1.21487 .30884 1.21679 Mtetra
.573 .835 .995 r
.3374 1.20026 .32192 1.19828 .30761 1.20667 .32301 1.20861 Mtetra
.575 .836 .994 r
.352 1.19171 .33645 1.18971 .32192 1.19828 .3374 1.20026 Mtetra
.577 .836 .994 r
.36681 1.18297 .35119 1.18093 .33645 1.18971 .352 1.19171 Mtetra
.58 .836 .994 r
.38185 1.174 .36616 1.17193 .35119 1.18093 .36681 1.18297 Mtetra
.583 .836 .993 r
.39711 1.1648 .38134 1.16269 .36616 1.17193 .38185 1.174 Mtetra
.586 .837 .992 r
.4126 1.15535 .39676 1.15319 .38134 1.16269 .39711 1.1648 Mtetra
.59 .837 .991 r
.42832 1.14561 .41241 1.14341 .39676 1.15319 .4126 1.15535 Mtetra
.595 .837 .99 r
.44429 1.13556 .4283 1.13331 .41241 1.14341 .42832 1.14561 Mtetra
.6 .836 .989 r
.46049 1.12517 .44444 1.12286 .4283 1.13331 .44429 1.13556 Mtetra
.605 .836 .987 r
.47694 1.11439 .46081 1.11202 .44444 1.12286 .46049 1.12517 Mtetra
.612 .836 .985 r
.49364 1.10318 .47744 1.10073 .46081 1.11202 .47694 1.11439 Mtetra
.619 .835 .983 r
.5106 1.09146 .49433 1.08893 .47744 1.10073 .49364 1.10318 Mtetra
.627 .834 .98 r
.52781 1.07915 .51147 1.07654 .49433 1.08893 .5106 1.09146 Mtetra
.637 .832 .975 r
.54527 1.06617 .52886 1.06345 .51147 1.07654 .52781 1.07915 Mtetra
.648 .829 .97 r
.56299 1.05237 .54652 1.04953 .52886 1.06345 .54527 1.06617 Mtetra
.66 .826 .963 r
.58097 1.03759 .56443 1.0346 .54652 1.04953 .56299 1.05237 Mtetra
.673 .82 .954 r
.5992 1.0216 .58259 1.01843 .56443 1.0346 .58097 1.03759 Mtetra
.688 .813 .942 r
.61766 1.0041 .60098 1.00071 .58259 1.01843 .5992 1.0216 Mtetra
.704 .804 .927 r
.63635 .98467 .61961 .981 .60098 1.00071 .61766 1.0041 Mtetra
.721 .791 .908 r
.65523 .96271 .63843 .95869 .61961 .981 .63635 .98467 Mtetra
.737 .774 .883 r
.67425 .93736 .65739 .93288 .63843 .95869 .65523 .96271 Mtetra
.754 .753 .852 r
.69334 .90731 .67644 .90221 .65739 .93288 .67425 .93736 Mtetra
.768 .728 .816 r
.71239 .87053 .69544 .86459 .67644 .90221 .69334 .90731 Mtetra
.78 .699 .774 r
.73117 .8237 .71418 .81658 .69544 .86459 .71239 .87053 Mtetra
.789 .668 .73 r
.74931 .76106 .7323 .75219 .71418 .81658 .73117 .8237 Mtetra
.795 .637 .685 r
.7661 .67192 .74907 .66037 .7323 .75219 .74931 .76106 Mtetra
.8 .609 .644 r
.78002 .53454 .76302 .5186 .74907 .66037 .7661 .67192 Mtetra
.804 .587 .609 r
.78758 .29887 .77066 .27527 .76302 .5186 .78002 .53454 Mtetra
.57 .837 .995 r
.30761 1.20667 .29211 1.20477 .27808 1.21301 .2935 1.21487 Mtetra
.572 .837 .995 r
.32192 1.19828 .30635 1.19636 .29211 1.20477 .30761 1.20667 Mtetra
.575 .837 .995 r
.33645 1.18971 .32081 1.18776 .30635 1.19636 .32192 1.19828 Mtetra
.577 .838 .994 r
.35119 1.18093 .33548 1.17895 .32081 1.18776 .33645 1.18971 Mtetra
.58 .838 .994 r
.36616 1.17193 .35037 1.16991 .33548 1.17895 .35119 1.18093 Mtetra
.583 .838 .993 r
.38134 1.16269 .36548 1.16064 .35037 1.16991 .36616 1.17193 Mtetra
.587 .839 .993 r
.39676 1.15319 .38083 1.1511 .36548 1.16064 .38134 1.16269 Mtetra
.591 .839 .992 r
.41241 1.14341 .39641 1.14128 .38083 1.1511 .39676 1.15319 Mtetra
.595 .839 .991 r
.4283 1.13331 .41222 1.13114 .39641 1.14128 .41241 1.14341 Mtetra
.6 .839 .989 r
.44444 1.12286 .42828 1.12064 .41222 1.13114 .4283 1.13331 Mtetra
.606 .839 .988 r
.46081 1.11202 .44459 1.10974 .42828 1.12064 .44444 1.12286 Mtetra
.613 .838 .986 r
.47744 1.10073 .46115 1.0984 .44459 1.10974 .46081 1.11202 Mtetra
.62 .838 .983 r
.49433 1.08893 .47796 1.08653 .46115 1.0984 .47744 1.10073 Mtetra
.629 .837 .98 r
.51147 1.07654 .49502 1.07406 .47796 1.08653 .49433 1.08893 Mtetra
.639 .835 .976 r
.52886 1.06345 .51235 1.06087 .49502 1.07406 .51147 1.07654 Mtetra
.65 .833 .971 r
.54652 1.04953 .52994 1.04684 .51235 1.06087 .52886 1.06345 Mtetra
.662 .83 .964 r
.56443 1.0346 .54778 1.03178 .52994 1.04684 .54652 1.04953 Mtetra
.676 .825 .955 r
.58259 1.01843 .56587 1.01545 .54778 1.03178 .56443 1.0346 Mtetra
.692 .818 .943 r
.60098 1.00071 .58421 .99753 .56587 1.01545 .58259 1.01843 Mtetra
.708 .809 .927 r
.61961 .981 .60277 .97758 .58421 .99753 .60098 1.00071 Mtetra
.726 .796 .907 r
.63843 .95869 .62153 .95495 .60277 .97758 .61961 .981 Mtetra
.743 .779 .882 r
.65739 .93288 .64044 .92872 .62153 .95495 .63843 .95869 Mtetra
.76 .758 .851 r
.67644 .90221 .65944 .8975 .64044 .92872 .65739 .93288 Mtetra
.775 .732 .814 r
.69544 .86459 .6784 .85911 .65944 .8975 .67644 .90221 Mtetra
.787 .703 .772 r
.71418 .81658 .69712 .81 .6784 .85911 .69544 .86459 Mtetra
.795 .672 .727 r
.7323 .75219 .71523 .744 .69712 .81 .71418 .81658 Mtetra
.801 .64 .683 r
.74907 .66037 .73202 .64969 .71523 .744 .7323 .75219 Mtetra
.805 .613 .642 r
.76302 .5186 .74603 .50385 .73202 .64969 .74907 .66037 Mtetra
.809 .59 .607 r
.77066 .27527 .75383 .25338 .74603 .50385 .76302 .5186 Mtetra
.57 .838 .996 r
.29211 1.20477 .27652 1.20292 .26256 1.21118 .27808 1.21301 Mtetra
.572 .838 .995 r
.30635 1.19636 .29069 1.19448 .27652 1.20292 .29211 1.20477 Mtetra
.574 .839 .995 r
.32081 1.18776 .30507 1.18585 .29069 1.19448 .30635 1.19636 Mtetra
.577 .839 .995 r
.33548 1.17895 .31967 1.17701 .30507 1.18585 .32081 1.18776 Mtetra
.58 .839 .994 r
.35037 1.16991 .33449 1.16795 .31967 1.17701 .33548 1.17895 Mtetra
.583 .84 .994 r
.36548 1.16064 .34953 1.15864 .33449 1.16795 .35037 1.16991 Mtetra
.587 .84 .993 r
.38083 1.1511 .3648 1.14908 .34953 1.15864 .36548 1.16064 Mtetra
.591 .841 .992 r
.39641 1.14128 .3803 1.13922 .3648 1.14908 .38083 1.1511 Mtetra
.595 .841 .991 r
.41222 1.13114 .39604 1.12903 .3803 1.13922 .39641 1.14128 Mtetra
.601 .841 .99 r
.42828 1.12064 .41203 1.11849 .39604 1.12903 .41222 1.13114 Mtetra
.607 .841 .988 r
.44459 1.10974 .42826 1.10755 .41203 1.11849 .42828 1.12064 Mtetra
.613 .841 .986 r
.46115 1.0984 .44475 1.09615 .42826 1.10755 .44459 1.10974 Mtetra
.621 .841 .984 r
.47796 1.08653 .46148 1.08422 .44475 1.09615 .46115 1.0984 Mtetra
.63 .84 .981 r
.49502 1.07406 .47848 1.07168 .46148 1.08422 .47796 1.08653 Mtetra
.64 .838 .976 r
.51235 1.06087 .49573 1.05841 .47848 1.07168 .49502 1.07406 Mtetra
.652 .836 .971 r
.52994 1.04684 .51325 1.04428 .49573 1.05841 .51235 1.06087 Mtetra
.665 .833 .964 r
.54778 1.03178 .53102 1.02911 .51325 1.04428 .52994 1.04684 Mtetra
.679 .829 .955 r
.56587 1.01545 .54905 1.01264 .53102 1.02911 .54778 1.03178 Mtetra
.695 .822 .943 r
.58421 .99753 .56732 .99454 .54905 1.01264 .56587 1.01545 Mtetra
.712 .813 .927 r
.60277 .97758 .58583 .97436 .56732 .99454 .58421 .99753 Mtetra
.73 .8 .907 r
.62153 .95495 .60453 .95145 .58583 .97436 .60277 .97758 Mtetra
.748 .783 .882 r
.64044 .92872 .6234 .92484 .60453 .95145 .62153 .95495 Mtetra
.765 .762 .85 r
.65944 .8975 .64235 .89311 .6234 .92484 .64044 .92872 Mtetra
.78 .736 .812 r
.6784 .85911 .66128 .85402 .64235 .89311 .65944 .8975 Mtetra
.792 .706 .77 r
.69712 .81 .67998 .8039 .66128 .85402 .6784 .85911 Mtetra
.801 .675 .725 r
.71523 .744 .69809 .73641 .67998 .8039 .69712 .81 Mtetra
.806 .643 .68 r
.73202 .64969 .71492 .63977 .69809 .73641 .71523 .744 Mtetra
.81 .615 .639 r
.74603 .50385 .72904 .49011 .71492 .63977 .73202 .64969 Mtetra
.813 .593 .605 r
.75383 .25338 .73708 .23295 .72904 .49011 .74603 .50385 Mtetra
.57 .839 .996 r
.27652 1.20292 .26085 1.2011 .24696 1.20938 .26256 1.21118 Mtetra
.572 .839 .995 r
.29069 1.19448 .27494 1.19264 .26085 1.2011 .27652 1.20292 Mtetra
.574 .84 .995 r
.30507 1.18585 .28925 1.18399 .27494 1.19264 .29069 1.19448 Mtetra
.577 .84 .995 r
.31967 1.17701 .30377 1.17512 .28925 1.18399 .30507 1.18585 Mtetra
.58 .841 .994 r
.33449 1.16795 .31851 1.16603 .30377 1.17512 .31967 1.17701 Mtetra
.583 .841 .994 r
.34953 1.15864 .33347 1.1567 .31851 1.16603 .33449 1.16795 Mtetra
.587 .842 .993 r
.3648 1.14908 .34867 1.1471 .33347 1.1567 .34953 1.15864 Mtetra
.591 .842 .992 r
.3803 1.13922 .3641 1.13721 .34867 1.1471 .3648 1.14908 Mtetra
.595 .843 .991 r
.39604 1.12903 .37977 1.12699 .3641 1.13721 .3803 1.13922 Mtetra
.601 .843 .99 r
.41203 1.11849 .39568 1.11642 .37977 1.12699 .39604 1.12903 Mtetra
.607 .843 .989 r
.42826 1.10755 .41183 1.10543 .39568 1.11642 .41203 1.11849 Mtetra
.614 .843 .987 r
.44475 1.09615 .42824 1.09398 .41183 1.10543 .42826 1.10755 Mtetra
.622 .843 .984 r
.46148 1.08422 .44491 1.082 .42824 1.09398 .44475 1.09615 Mtetra
.631 .842 .981 r
.47848 1.07168 .46183 1.0694 .44491 1.082 .46148 1.08422 Mtetra
.642 .841 .977 r
.49573 1.05841 .47901 1.05606 .46183 1.0694 .47848 1.07168 Mtetra
.653 .839 .972 r
.51325 1.04428 .49646 1.04185 .47901 1.05606 .49573 1.05841 Mtetra
.667 .836 .965 r
.53102 1.02911 .51416 1.02657 .49646 1.04185 .51325 1.04428 Mtetra
.682 .832 .955 r
.54905 1.01264 .53212 1.00997 .51416 1.02657 .53102 1.02911 Mtetra
.698 .826 .943 r
.56732 .99454 .55033 .99172 .53212 1.00997 .54905 1.01264 Mtetra
.716 .816 .928 r
.58583 .97436 .56878 .97134 .55033 .99172 .56732 .99454 Mtetra
.734 .804 .907 r
.60453 .95145 .58743 .94816 .56878 .97134 .58583 .97436 Mtetra
.753 .787 .881 r
.6234 .92484 .60624 .92121 .58743 .94816 .60453 .95145 Mtetra
.77 .766 .849 r
.64235 .89311 .62516 .88902 .60624 .92121 .6234 .92484 Mtetra
.785 .739 .811 r
.66128 .85402 .64406 .84928 .62516 .88902 .64235 .89311 Mtetra
.797 .709 .768 r
.67998 .8039 .66275 .79822 .64406 .84928 .66128 .85402 Mtetra
.805 .677 .723 r
.69809 .73641 .68088 .72934 .66275 .79822 .67998 .8039 Mtetra
.81 .646 .678 r
.71492 .63977 .69778 .63052 .68088 .72934 .69809 .73641 Mtetra
.813 .617 .637 r
.72904 .49011 .71203 .47727 .69778 .63052 .71492 .63977 Mtetra
.816 .595 .603 r
.73708 .23295 .72037 .21382 .71203 .47727 .72904 .49011 Mtetra
.569 .84 .996 r
.26085 1.2011 .24508 1.19931 .23126 1.20761 .24696 1.20938 Mtetra
.572 .84 .996 r
.27494 1.19264 .2591 1.19083 .24508 1.19931 .26085 1.2011 Mtetra
.574 .841 .995 r
.28925 1.18399 .27333 1.18216 .2591 1.19083 .27494 1.19264 Mtetra
.576 .841 .995 r
.30377 1.17512 .28777 1.17327 .27333 1.18216 .28925 1.18399 Mtetra
.579 .842 .995 r
.31851 1.16603 .30243 1.16416 .28777 1.17327 .30377 1.17512 Mtetra
.583 .843 .994 r
.33347 1.1567 .31732 1.1548 .30243 1.16416 .31851 1.16603 Mtetra
.586 .843 .993 r
.34867 1.1471 .33244 1.14518 .31732 1.1548 .33347 1.1567 Mtetra
.591 .844 .993 r
.3641 1.13721 .34779 1.13526 .33244 1.14518 .34867 1.1471 Mtetra
.595 .844 .992 r
.37977 1.12699 .36338 1.12501 .34779 1.13526 .3641 1.13721 Mtetra
.601 .845 .99 r
.39568 1.11642 .37922 1.1144 .36338 1.12501 .37977 1.12699 Mtetra
.607 .845 .989 r
.41183 1.10543 .3953 1.10338 .37922 1.1144 .39568 1.11642 Mtetra
.614 .845 .987 r
.42824 1.09398 .41163 1.09189 .3953 1.10338 .41183 1.10543 Mtetra
.622 .845 .985 r
.44491 1.082 .42822 1.07986 .41163 1.09189 .42824 1.09398 Mtetra
.632 .845 .981 r
.46183 1.0694 .44507 1.0672 .42822 1.07986 .44491 1.082 Mtetra
.643 .844 .977 r
.47901 1.05606 .46218 1.0538 .44507 1.0672 .46183 1.0694 Mtetra
.655 .842 .972 r
.49646 1.04185 .47956 1.03951 .46218 1.0538 .47901 1.05606 Mtetra
.668 .839 .965 r
.51416 1.02657 .49719 1.02414 .47956 1.03951 .49646 1.04185 Mtetra
.684 .835 .956 r
.53212 1.00997 .51509 1.00743 .49719 1.02414 .51416 1.02657 Mtetra
.701 .829 .944 r
.55033 .99172 .53323 .98904 .51509 1.00743 .53212 1.00997 Mtetra
.719 .82 .928 r
.56878 .97134 .55162 .96848 .53323 .98904 .55033 .99172 Mtetra
.738 .807 .907 r
.58743 .94816 .57021 .94507 .55162 .96848 .56878 .97134 Mtetra
.756 .79 .881 r
.60624 .92121 .58898 .9178 .57021 .94507 .58743 .94816 Mtetra
.774 .769 .848 r
.62516 .88902 .60786 .88518 .58898 .9178 .60624 .92121 Mtetra
.789 .742 .81 r
.64406 .84928 .62674 .84484 .60786 .88518 .62516 .88902 Mtetra
.801 .712 .766 r
.66275 .79822 .64543 .79292 .62674 .84484 .64406 .84928 Mtetra
.809 .679 .721 r
.68088 .72934 .66359 .72273 .64543 .79292 .66275 .79822 Mtetra
.814 .648 .676 r
.69778 .63052 .68057 .62187 .66359 .72273 .68088 .72934 Mtetra
.817 .619 .635 r
.71203 .47727 .695 .46523 .68057 .62187 .69778 .63052 Mtetra
.819 .596 .601 r
.72037 .21382 .7037 .19582 .695 .46523 .71203 .47727 Mtetra
.569 .841 .996 r
.24508 1.19931 .22921 1.19755 .21548 1.20587 .23126 1.20761 Mtetra
.571 .841 .996 r
.2591 1.19083 .24316 1.18905 .22921 1.19755 .24508 1.19931 Mtetra
.573 .842 .996 r
.27333 1.18216 .25731 1.18036 .24316 1.18905 .2591 1.19083 Mtetra
.576 .842 .995 r
.28777 1.17327 .27168 1.17145 .25731 1.18036 .27333 1.18216 Mtetra
.579 .843 .995 r
.30243 1.16416 .28626 1.16232 .27168 1.17145 .28777 1.17327 Mtetra
.582 .844 .994 r
.31732 1.1548 .30107 1.15294 .28626 1.16232 .30243 1.16416 Mtetra
.586 .844 .994 r
.33244 1.14518 .31611 1.14329 .30107 1.15294 .31732 1.1548 Mtetra
.59 .845 .993 r
.34779 1.13526 .33139 1.13335 .31611 1.14329 .33244 1.14518 Mtetra
.595 .846 .992 r
.36338 1.12501 .3469 1.12307 .33139 1.13335 .34779 1.13526 Mtetra
.601 .846 .991 r
.37922 1.1144 .36266 1.11243 .3469 1.12307 .36338 1.12501 Mtetra
.607 .846 .989 r
.3953 1.10338 .37866 1.10138 .36266 1.11243 .37922 1.1144 Mtetra
.614 .847 .987 r
.41163 1.09189 .39492 1.08985 .37866 1.10138 .3953 1.10338 Mtetra
.623 .847 .985 r
.42822 1.07986 .41143 1.07779 .39492 1.08985 .41163 1.09189 Mtetra
.632 .847 .982 r
.44507 1.0672 .42821 1.06508 .41143 1.07779 .42822 1.07986 Mtetra
.643 .846 .978 r
.46218 1.0538 .44524 1.05163 .42821 1.06508 .44507 1.0672 Mtetra
.656 .844 .973 r
.47956 1.03951 .46254 1.03727 .44524 1.05163 .46218 1.0538 Mtetra
.67 .842 .966 r
.49719 1.02414 .48011 1.02182 .46254 1.03727 .47956 1.03951 Mtetra
.685 .838 .956 r
.51509 1.00743 .49794 1.00501 .48011 1.02182 .49719 1.02414 Mtetra
.703 .832 .944 r
.53323 .98904 .51602 .98649 .49794 1.00501 .51509 1.00743 Mtetra
.721 .823 .928 r
.55162 .96848 .53434 .96577 .51602 .98649 .53323 .98904 Mtetra
.741 .81 .907 r
.57021 .94507 .55289 .94215 .53434 .96577 .55162 .96848 Mtetra
.76 .793 .88 r
.58898 .9178 .57161 .9146 .55289 .94215 .57021 .94507 Mtetra
.778 .772 .847 r
.60786 .88518 .59046 .88158 .57161 .9146 .58898 .9178 Mtetra
.793 .745 .808 r
.62674 .84484 .60932 .84068 .59046 .88158 .60786 .88518 Mtetra
.805 .714 .765 r
.64543 .79292 .62802 .78795 .60932 .84068 .62674 .84484 Mtetra
.813 .681 .719 r
.66359 .72273 .64622 .71654 .62802 .78795 .64543 .79292 Mtetra
.817 .649 .674 r
.68057 .62187 .66329 .61375 .64622 .71654 .66359 .72273 Mtetra
.82 .621 .634 r
.695 .46523 .67792 .45391 .66329 .61375 .68057 .62187 Mtetra
.821 .598 .6 r
.7037 .19582 .68704 .17884 .67792 .45391 .695 .46523 Mtetra
.568 .841 .996 r
.22921 1.19755 .21326 1.19582 .1996 1.20415 .21548 1.20587 Mtetra
.571 .842 .996 r
.24316 1.18905 .22712 1.1873 .21326 1.19582 .22921 1.19755 Mtetra
.573 .843 .996 r
.25731 1.18036 .2412 1.17859 .22712 1.1873 .24316 1.18905 Mtetra
.576 .843 .995 r
.27168 1.17145 .25548 1.16966 .2412 1.17859 .25731 1.18036 Mtetra
.578 .844 .995 r
.28626 1.16232 .26999 1.16051 .25548 1.16966 .27168 1.17145 Mtetra
.582 .845 .994 r
.30107 1.15294 .28472 1.15111 .26999 1.16051 .28626 1.16232 Mtetra
.586 .845 .994 r
.31611 1.14329 .29968 1.14144 .28472 1.15111 .30107 1.15294 Mtetra
.59 .846 .993 r
.33139 1.13335 .31488 1.13148 .29968 1.14144 .31611 1.14329 Mtetra
.595 .847 .992 r
.3469 1.12307 .33031 1.12118 .31488 1.13148 .33139 1.13335 Mtetra
.601 .847 .991 r
.36266 1.11243 .34599 1.11052 .33031 1.12118 .3469 1.12307 Mtetra
.607 .848 .99 r
.37866 1.10138 .36192 1.09943 .34599 1.11052 .36266 1.11243 Mtetra
.614 .848 .988 r
.39492 1.08985 .3781 1.08788 .36192 1.09943 .37866 1.10138 Mtetra
.623 .849 .985 r
.41143 1.07779 .39453 1.07577 .3781 1.08788 .39492 1.08985 Mtetra
.633 .848 .982 r
.42821 1.06508 .41123 1.06303 .39453 1.07577 .41143 1.07779 Mtetra
.644 .848 .978 r
.44524 1.05163 .42819 1.04953 .41123 1.06303 .42821 1.06508 Mtetra
.656 .846 .973 r
.46254 1.03727 .44542 1.03511 .42819 1.04953 .44524 1.05163 Mtetra
.671 .844 .966 r
.48011 1.02182 .46291 1.01959 .44542 1.03511 .46254 1.03727 Mtetra
.687 .84 .957 r
.49794 1.00501 .48067 1.0027 .46291 1.01959 .48011 1.02182 Mtetra
.705 .834 .944 r
.51602 .98649 .49869 .98407 .48067 1.0027 .49794 1.00501 Mtetra
.724 .825 .928 r
.53434 .96577 .51695 .9632 .49869 .98407 .51602 .98649 Mtetra
.743 .813 .907 r
.55289 .94215 .53544 .93938 .51695 .9632 .53434 .96577 Mtetra
.763 .796 .88 r
.57161 .9146 .55413 .91157 .53544 .93938 .55289 .94215 Mtetra
.781 .774 .847 r
.59046 .88158 .57294 .87819 .55413 .91157 .57161 .9146 Mtetra
.796 .747 .807 r
.60932 .84068 .59179 .83678 .57294 .87819 .59046 .88158 Mtetra
.808 .716 .763 r
.62802 .78795 .6105 .78329 .59179 .83678 .60932 .84068 Mtetra
.816 .683 .717 r
.64622 .71654 .62875 .71073 .6105 .78329 .62802 .78795 Mtetra
.82 .651 .672 r
.66329 .61375 .64594 .60611 .62875 .71073 .64622 .71654 Mtetra
.822 .622 .632 r
.67792 .45391 .6608 .44323 .64594 .60611 .66329 .61375 Mtetra
.823 .599 .599 r
.68704 .17884 .67038 .16277 .6608 .44323 .67792 .45391 Mtetra
.568 .842 .996 r
.21326 1.19582 .19721 1.1941 .18363 1.20245 .1996 1.20415 Mtetra
.57 .843 .996 r
.22712 1.1873 .21099 1.18557 .19721 1.1941 .21326 1.19582 Mtetra
.572 .843 .996 r
.2412 1.17859 .22498 1.17684 .21099 1.18557 .22712 1.1873 Mtetra
.575 .844 .996 r
.25548 1.16966 .23919 1.1679 .22498 1.17684 .2412 1.17859 Mtetra
.578 .845 .995 r
.26999 1.16051 .25362 1.15873 .23919 1.1679 .25548 1.16966 Mtetra
.581 .846 .995 r
.28472 1.15111 .26827 1.14931 .25362 1.15873 .26999 1.16051 Mtetra
.585 .846 .994 r
.29968 1.14144 .28315 1.13963 .26827 1.14931 .28472 1.15111 Mtetra
.589 .847 .993 r
.31488 1.13148 .29827 1.12964 .28315 1.13963 .29968 1.14144 Mtetra
.594 .848 .992 r
.33031 1.12118 .31362 1.11933 .29827 1.12964 .31488 1.13148 Mtetra
.6 .849 .991 r
.34599 1.11052 .32922 1.10864 .31362 1.11933 .33031 1.12118 Mtetra
.607 .849 .99 r
.36192 1.09943 .34506 1.09754 .32922 1.10864 .34599 1.11052 Mtetra
.614 .85 .988 r
.3781 1.08788 .36116 1.08595 .34506 1.09754 .36192 1.09943 Mtetra
.623 .85 .986 r
.39453 1.07577 .37752 1.07382 .36116 1.08595 .3781 1.08788 Mtetra
.633 .85 .983 r
.41123 1.06303 .39414 1.06104 .37752 1.07382 .39453 1.07577 Mtetra
.644 .85 .979 r
.42819 1.04953 .41103 1.04749 .39414 1.06104 .41123 1.06303 Mtetra
.657 .848 .973 r
.44542 1.03511 .42818 1.03303 .41103 1.04749 .42819 1.04953 Mtetra
.672 .846 .966 r
.46291 1.01959 .4456 1.01745 .42818 1.03303 .44542 1.03511 Mtetra
.688 .842 .957 r
.48067 1.0027 .46329 1.00048 .4456 1.01745 .46291 1.01959 Mtetra
.706 .837 .945 r
.49869 .98407 .48124 .98175 .46329 1.00048 .48067 1.0027 Mtetra
.725 .828 .928 r
.51695 .9632 .49945 .96075 .48124 .98175 .49869 .98407 Mtetra
.746 .815 .907 r
.53544 .93938 .51788 .93675 .49945 .96075 .51695 .9632 Mtetra
.765 .798 .88 r
.55413 .91157 .53652 .9087 .51788 .93675 .53544 .93938 Mtetra
.784 .776 .846 r
.57294 .87819 .55531 .87499 .53652 .9087 .55413 .91157 Mtetra
.799 .749 .806 r
.59179 .83678 .57414 .8331 .55531 .87499 .57294 .87819 Mtetra
.811 .718 .762 r
.6105 .78329 .59287 .7789 .57414 .8331 .59179 .83678 Mtetra
.819 .684 .716 r
.62875 .71073 .61118 .70526 .59287 .7789 .6105 .78329 Mtetra
.823 .652 .671 r
.64594 .60611 .6285 .59892 .61118 .70526 .62875 .71073 Mtetra
.824 .623 .631 r
.6608 .44323 .64362 .43313 .6285 .59892 .64594 .60611 Mtetra
.825 .6 .597 r
.67038 .16277 .65372 .14752 .64362 .43313 .6608 .44323 Mtetra
.567 .843 .996 r
.19721 1.1941 .18106 1.1924 .16756 1.20076 .18363 1.20245 Mtetra
.569 .843 .996 r
.21099 1.18557 .19476 1.18385 .18106 1.1924 .19721 1.1941 Mtetra
.572 .844 .996 r
.22498 1.17684 .20867 1.17511 .19476 1.18385 .21099 1.18557 Mtetra
.574 .845 .996 r
.23919 1.1679 .2228 1.16616 .20867 1.17511 .22498 1.17684 Mtetra
.577 .846 .995 r
.25362 1.15873 .23715 1.15697 .2228 1.16616 .23919 1.1679 Mtetra
.581 .846 .995 r
.26827 1.14931 .25172 1.14754 .23715 1.15697 .25362 1.15873 Mtetra
.585 .847 .994 r
.28315 1.13963 .26652 1.13784 .25172 1.14754 .26827 1.14931 Mtetra
.589 .848 .994 r
.29827 1.12964 .28155 1.12784 .26652 1.13784 .28315 1.13963 Mtetra
.594 .849 .993 r
.31362 1.11933 .29682 1.11751 .28155 1.12784 .29827 1.12964 Mtetra
.6 .85 .992 r
.32922 1.10864 .31233 1.1068 .29682 1.11751 .31362 1.11933 Mtetra
.606 .85 .99 r
.34506 1.09754 .3281 1.09568 .31233 1.1068 .32922 1.10864 Mtetra
.614 .851 .988 r
.36116 1.08595 .34412 1.08407 .3281 1.09568 .34506 1.09754 Mtetra
.623 .851 .986 r
.37752 1.07382 .3604 1.07191 .34412 1.08407 .36116 1.08595 Mtetra
.633 .852 .983 r
.39414 1.06104 .37694 1.0591 .3604 1.07191 .37752 1.07382 Mtetra
.644 .851 .979 r
.41103 1.04749 .39374 1.04552 .37694 1.0591 .39414 1.06104 Mtetra
.657 .85 .974 r
.42818 1.03303 .41082 1.03102 .39374 1.04552 .41103 1.04749 Mtetra
.672 .848 .967 r
.4456 1.01745 .42817 1.01538 .41082 1.03102 .42818 1.03303 Mtetra
.689 .845 .958 r
.46329 1.00048 .44579 .99834 .42817 1.01538 .4456 1.01745 Mtetra
.707 .839 .945 r
.48124 .98175 .46368 .97952 .44579 .99834 .46329 1.00048 Mtetra
.727 .83 .929 r
.49945 .96075 .48182 .95841 .46368 .97952 .48124 .98175 Mtetra
.748 .818 .907 r
.51788 .93675 .5002 .93426 .48182 .95841 .49945 .96075 Mtetra
.768 .801 .88 r
.53652 .9087 .5188 .90599 .5002 .93426 .51788 .93675 Mtetra
.786 .778 .846 r
.55531 .87499 .53755 .87197 .5188 .90599 .53652 .9087 Mtetra
.802 .751 .805 r
.57414 .8331 .55638 .82963 .53755 .87197 .55531 .87499 Mtetra
.814 .719 .761 r
.59287 .7789 .57513 .77477 .55638 .82963 .57414 .8331 Mtetra
.821 .686 .714 r
.61118 .70526 .5935 .7001 .57513 .77477 .59287 .7789 Mtetra
.825 .653 .669 r
.6285 .59892 .61097 .59212 .5935 .7001 .61118 .70526 Mtetra
.826 .624 .629 r
.64362 .43313 .62637 .42356 .61097 .59212 .6285 .59892 Mtetra
.827 .601 .596 r
.65372 .14752 .63703 .13303 .62637 .42356 .64362 .43313 Mtetra
.567 .843 .997 r
.18106 1.1924 .16481 1.19072 .1514 1.1991 .16756 1.20076 Mtetra
.569 .844 .996 r
.19476 1.18385 .17844 1.18216 .16481 1.19072 .18106 1.1924 Mtetra
.571 .845 .996 r
.20867 1.17511 .19227 1.1734 .17844 1.18216 .19476 1.18385 Mtetra
.574 .845 .996 r
.2228 1.16616 .20631 1.16444 .19227 1.1734 .20867 1.17511 Mtetra
.577 .846 .995 r
.23715 1.15697 .22057 1.15524 .20631 1.16444 .2228 1.16616 Mtetra
.58 .847 .995 r
.25172 1.14754 .23506 1.1458 .22057 1.15524 .23715 1.15697 Mtetra
.584 .848 .994 r
.26652 1.13784 .24977 1.13608 .23506 1.1458 .25172 1.14754 Mtetra
.588 .849 .994 r
.28155 1.12784 .26472 1.12607 .24977 1.13608 .26652 1.13784 Mtetra
.593 .85 .993 r
.29682 1.11751 .27991 1.11572 .26472 1.12607 .28155 1.12784 Mtetra
.599 .851 .992 r
.31233 1.1068 .29534 1.105 .27991 1.11572 .29682 1.11751 Mtetra
.606 .852 .99 r
.3281 1.09568 .31102 1.09386 .29534 1.105 .31233 1.1068 Mtetra
.614 .852 .989 r
.34412 1.08407 .32696 1.08223 .31102 1.09386 .3281 1.09568 Mtetra
.622 .853 .986 r
.3604 1.07191 .34316 1.07005 .32696 1.08223 .34412 1.08407 Mtetra
.633 .853 .983 r
.37694 1.0591 .35962 1.05722 .34316 1.07005 .3604 1.07191 Mtetra
.644 .853 .98 r
.39374 1.04552 .37635 1.04361 .35962 1.05722 .37694 1.0591 Mtetra
.658 .852 .974 r
.41082 1.03102 .39335 1.02907 .37635 1.04361 .39374 1.04552 Mtetra
.673 .85 .967 r
.42817 1.01538 .41062 1.01339 .39335 1.02907 .41082 1.03102 Mtetra
.69 .847 .958 r
.44579 .99834 .42817 .99629 .41062 1.01339 .42817 1.01538 Mtetra
.709 .841 .946 r
.46368 .97952 .44599 .97739 .42817 .99629 .44579 .99834 Mtetra
.729 .832 .929 r
.48182 .95841 .46407 .95618 .44599 .97739 .46368 .97952 Mtetra
.749 .82 .907 r
.5002 .93426 .4824 .93188 .46407 .95618 .48182 .95841 Mtetra
.77 .803 .879 r
.5188 .90599 .50095 .90342 .4824 .93188 .5002 .93426 Mtetra
.789 .78 .845 r
.53755 .87197 .51968 .86911 .50095 .90342 .5188 .90599 Mtetra
.804 .753 .805 r
.55638 .82963 .5385 .82636 .51968 .86911 .53755 .87197 Mtetra
.816 .721 .76 r
.57513 .77477 .55727 .77087 .5385 .82636 .55638 .82963 Mtetra
.823 .687 .713 r
.5935 .7001 .57572 .69524 .55727 .77087 .57513 .77477 Mtetra
.827 .654 .668 r
.61097 .59212 .59334 .58569 .57572 .69524 .5935 .7001 Mtetra
.828 .625 .628 r
.62637 .42356 .60905 .41449 .59334 .58569 .61097 .59212 Mtetra
.829 .602 .595 r
.63703 .13303 .62031 .11922 .60905 .41449 .62637 .42356 Mtetra
.566 .844 .997 r
.16481 1.19072 .14847 1.18905 .13514 1.19744 .1514 1.1991 Mtetra
.568 .844 .997 r
.17844 1.18216 .16201 1.18048 .14847 1.18905 .16481 1.19072 Mtetra
.57 .845 .996 r
.19227 1.1734 .17576 1.17171 .16201 1.18048 .17844 1.18216 Mtetra
.573 .846 .996 r
.20631 1.16444 .18972 1.16273 .17576 1.17171 .19227 1.1734 Mtetra
.576 .847 .996 r
.22057 1.15524 .20389 1.15353 .18972 1.16273 .20631 1.16444 Mtetra
.579 .848 .995 r
.23506 1.1458 .2183 1.14407 .20389 1.15353 .22057 1.15524 Mtetra
.583 .849 .995 r
.24977 1.13608 .23293 1.13434 .2183 1.14407 .23506 1.1458 Mtetra
.588 .85 .994 r
.26472 1.12607 .24779 1.12432 .23293 1.13434 .24977 1.13608 Mtetra
.593 .851 .993 r
.27991 1.11572 .26289 1.11396 .24779 1.12432 .26472 1.12607 Mtetra
.598 .852 .992 r
.29534 1.105 .27824 1.10323 .26289 1.11396 .27991 1.11572 Mtetra
.605 .853 .991 r
.31102 1.09386 .29384 1.09207 .27824 1.10323 .29534 1.105 Mtetra
.613 .853 .989 r
.32696 1.08223 .30969 1.08043 .29384 1.09207 .31102 1.09386 Mtetra
.622 .854 .987 r
.34316 1.07005 .3258 1.06824 .30969 1.08043 .32696 1.08223 Mtetra
.632 .854 .984 r
.35962 1.05722 .34218 1.05538 .3258 1.06824 .34316 1.07005 Mtetra
.644 .854 .98 r
.37635 1.04361 .35883 1.04175 .34218 1.05538 .35962 1.05722 Mtetra
.658 .854 .975 r
.39335 1.02907 .37575 1.02718 .35883 1.04175 .37635 1.04361 Mtetra
.673 .852 .968 r
.41062 1.01339 .39295 1.01146 .37575 1.02718 .39335 1.02907 Mtetra
.69 .848 .959 r
.42817 .99629 .41042 .99431 .39295 1.01146 .41062 1.01339 Mtetra
.709 .843 .946 r
.44599 .97739 .42817 .97535 .41042 .99431 .42817 .99629 Mtetra
.73 .834 .929 r
.46407 .95618 .44619 .95404 .42817 .97535 .44599 .97739 Mtetra
.751 .822 .907 r
.4824 .93188 .46447 .92962 .44619 .95404 .46407 .95618 Mtetra
.772 .805 .879 r
.50095 .90342 .48298 .90097 .46447 .92962 .4824 .93188 Mtetra
.791 .782 .845 r
.51968 .86911 .50168 .8664 .48298 .90097 .50095 .90342 Mtetra
.807 .754 .804 r
.5385 .82636 .52049 .82326 .50168 .8664 .51968 .86911 Mtetra
.818 .722 .759 r
.55727 .77087 .53929 .76719 .52049 .82326 .5385 .82636 Mtetra
.825 .688 .712 r
.57572 .69524 .55783 .69064 .53929 .76719 .55727 .77087 Mtetra
.829 .655 .667 r
.59334 .58569 .57562 .5796 .55783 .69064 .57572 .69524 Mtetra
.83 .626 .627 r
.60905 .41449 .59165 .40586 .57562 .5796 .59334 .58569 Mtetra
.83 .603 .595 r
.62031 .11922 .60355 .10604 .59165 .40586 .60905 .41449 Mtetra
.565 .844 .997 r
.14847 1.18905 .13203 1.1874 .11878 1.1958 .13514 1.19744 Mtetra
.567 .845 .997 r
.16201 1.18048 .14548 1.17882 .13203 1.1874 .14847 1.18905 Mtetra
.569 .846 .996 r
.17576 1.17171 .15914 1.17004 .14548 1.17882 .16201 1.18048 Mtetra
.572 .847 .996 r
.18972 1.16273 .17302 1.16105 .15914 1.17004 .17576 1.17171 Mtetra
.575 .847 .996 r
.20389 1.15353 .18711 1.15183 .17302 1.16105 .18972 1.16273 Mtetra
.578 .848 .995 r
.2183 1.14407 .20143 1.14237 .18711 1.15183 .20389 1.15353 Mtetra
.582 .849 .995 r
.23293 1.13434 .21597 1.13263 .20143 1.14237 .2183 1.14407 Mtetra
.587 .85 .994 r
.24779 1.12432 .23075 1.1226 .21597 1.13263 .23293 1.13434 Mtetra
.592 .851 .993 r
.26289 1.11396 .24576 1.11223 .23075 1.1226 .24779 1.12432 Mtetra
.598 .852 .992 r
.27824 1.10323 .26102 1.10148 .24576 1.11223 .26289 1.11396 Mtetra
.604 .853 .991 r
.29384 1.09207 .27654 1.09032 .26102 1.10148 .27824 1.10323 Mtetra
.612 .854 .989 r
.30969 1.08043 .2923 1.07867 .27654 1.09032 .29384 1.09207 Mtetra
.621 .855 .987 r
.3258 1.06824 .30833 1.06646 .2923 1.07867 .30969 1.08043 Mtetra
.632 .856 .984 r
.34218 1.05538 .32462 1.05359 .30833 1.06646 .3258 1.06824 Mtetra
.644 .856 .98 r
.35883 1.04175 .34119 1.03994 .32462 1.05359 .34218 1.05538 Mtetra
.658 .855 .975 r
.37575 1.02718 .35803 1.02534 .34119 1.03994 .35883 1.04175 Mtetra
.673 .853 .968 r
.39295 1.01146 .37515 1.00959 .35803 1.02534 .37575 1.02718 Mtetra
.691 .85 .959 r
.41042 .99431 .39255 .9924 .37515 1.00959 .39295 1.01146 Mtetra
.71 .845 .947 r
.42817 .97535 .41023 .97338 .39255 .9924 .41042 .99431 Mtetra
.731 .836 .93 r
.44619 .95404 .42819 .95199 .41023 .97338 .42817 .97535 Mtetra
.752 .824 .908 r
.46447 .92962 .44641 .92745 .42819 .95199 .44619 .95404 Mtetra
.774 .807 .879 r
.48298 .90097 .46487 .89864 .44641 .92745 .46447 .92962 Mtetra
.793 .784 .844 r
.50168 .8664 .48355 .86383 .46487 .89864 .48298 .90097 Mtetra
.809 .756 .803 r
.52049 .82326 .50236 .82033 .48355 .86383 .50168 .8664 Mtetra
.82 .723 .758 r
.53929 .76719 .52119 .76371 .50236 .82033 .52049 .82326 Mtetra
.827 .689 .711 r
.55783 .69064 .53981 .68629 .52119 .76371 .53929 .76719 Mtetra
.831 .656 .666 r
.57562 .5796 .55778 .57383 .53981 .68629 .55783 .69064 Mtetra
.831 .627 .626 r
.59165 .40586 .57416 .39765 .55778 .57383 .57562 .5796 Mtetra
.831 .604 .594 r
.60355 .10604 .58675 .09344 .57416 .39765 .59165 .40586 Mtetra
.564 .845 .997 r
.13203 1.1874 .11549 1.18575 .10233 1.19416 .11878 1.1958 Mtetra
.566 .845 .997 r
.14548 1.17882 .12886 1.17716 .11549 1.18575 .13203 1.1874 Mtetra
.568 .846 .997 r
.15914 1.17004 .14243 1.16838 .12886 1.17716 .14548 1.17882 Mtetra
.571 .847 .996 r
.17302 1.16105 .15622 1.15938 .14243 1.16838 .15914 1.17004 Mtetra
.574 .848 .996 r
.18711 1.15183 .17022 1.15015 .15622 1.15938 .17302 1.16105 Mtetra
.577 .849 .996 r
.20143 1.14237 .18445 1.14068 .17022 1.15015 .18711 1.15183 Mtetra
.581 .85 .995 r
.21597 1.13263 .19891 1.13094 .18445 1.14068 .20143 1.14237 Mtetra
.586 .851 .994 r
.23075 1.1226 .21359 1.12089 .19891 1.13094 .21597 1.13263 Mtetra
.591 .852 .994 r
.24576 1.11223 .22852 1.11052 .21359 1.12089 .23075 1.1226 Mtetra
.597 .853 .993 r
.26102 1.10148 .2437 1.09977 .22852 1.11052 .24576 1.11223 Mtetra
.604 .854 .991 r
.27654 1.09032 .25912 1.08859 .2437 1.09977 .26102 1.10148 Mtetra
.612 .855 .99 r
.2923 1.07867 .2748 1.07694 .25912 1.08859 .27654 1.09032 Mtetra
.621 .856 .988 r
.30833 1.06646 .29074 1.06472 .2748 1.07694 .2923 1.07867 Mtetra
.631 .857 .985 r
.32462 1.05359 .30695 1.05183 .29074 1.06472 .30833 1.06646 Mtetra
.643 .857 .981 r
.34119 1.03994 .32343 1.03817 .30695 1.05183 .32462 1.05359 Mtetra
.657 .856 .976 r
.35803 1.02534 .34019 1.02355 .32343 1.03817 .34119 1.03994 Mtetra
.673 .855 .969 r
.37515 1.00959 .35723 1.00778 .34019 1.02355 .35803 1.02534 Mtetra
.691 .852 .96 r
.39255 .9924 .37455 .99055 .35723 1.00778 .37515 1.00959 Mtetra
.711 .847 .947 r
.41023 .97338 .39216 .97148 .37455 .99055 .39255 .9924 Mtetra
.732 .838 .93 r
.42819 .95199 .41005 .95002 .39216 .97148 .41023 .97338 Mtetra
.754 .826 .908 r
.44641 .92745 .42822 .92538 .41005 .95002 .42819 .95199 Mtetra
.775 .808 .88 r
.46487 .89864 .44664 .89642 .42822 .92538 .44641 .92745 Mtetra
.794 .785 .844 r
.48355 .86383 .46529 .86139 .44664 .89642 .46487 .89864 Mtetra
.811 .757 .803 r
.50236 .82033 .4841 .81756 .46529 .86139 .48355 .86383 Mtetra
.822 .724 .757 r
.52119 .76371 .50296 .76042 .4841 .81756 .50236 .82033 Mtetra
.829 .69 .71 r
.53981 .68629 .52168 .68217 .50296 .76042 .52119 .76371 Mtetra
.832 .657 .665 r
.55778 .57383 .53984 .56835 .52168 .68217 .53981 .68629 Mtetra
.833 .627 .625 r
.57416 .39765 .55659 .38982 .53984 .56835 .55778 .57383 Mtetra
.832 .604 .593 r
.58675 .09344 .56989 .08138 .55659 .38982 .57416 .39765 Mtetra
.563 .845 .997 r
.11549 1.18575 .09885 1.18412 .08577 1.19254 .10233 1.19416 Mtetra
.565 .846 .997 r
.12886 1.17716 .11213 1.17552 .09885 1.18412 .11549 1.18575 Mtetra
.568 .847 .997 r
.14243 1.16838 .12561 1.16673 .11213 1.17552 .12886 1.17716 Mtetra
.57 .847 .996 r
.15622 1.15938 .13931 1.15772 .12561 1.16673 .14243 1.16838 Mtetra
.573 .848 .996 r
.17022 1.15015 .15323 1.14849 .13931 1.15772 .15622 1.15938 Mtetra
.576 .849 .996 r
.18445 1.14068 .16736 1.13901 .15323 1.14849 .17022 1.15015 Mtetra
.58 .851 .995 r
.19891 1.13094 .18173 1.12926 .16736 1.13901 .18445 1.14068 Mtetra
.585 .852 .995 r
.21359 1.12089 .19633 1.11921 .18173 1.12926 .19891 1.13094 Mtetra
.59 .853 .994 r
.22852 1.11052 .21117 1.10883 .19633 1.11921 .21359 1.12089 Mtetra
.596 .854 .993 r
.2437 1.09977 .22625 1.09807 .21117 1.10883 .22852 1.11052 Mtetra
.603 .855 .992 r
.25912 1.08859 .24159 1.0869 .22625 1.09807 .2437 1.09977 Mtetra
.611 .856 .99 r
.2748 1.07694 .25718 1.07523 .24159 1.0869 .25912 1.08859 Mtetra
.62 .857 .988 r
.29074 1.06472 .27303 1.06301 .25718 1.07523 .2748 1.07694 Mtetra
.631 .858 .985 r
.30695 1.05183 .28915 1.05012 .27303 1.06301 .29074 1.06472 Mtetra
.643 .858 .981 r
.32343 1.03817 .30555 1.03644 .28915 1.05012 .30695 1.05183 Mtetra
.657 .858 .976 r
.34019 1.02355 .32222 1.02181 .30555 1.03644 .32343 1.03817 Mtetra
.673 .856 .969 r
.35723 1.00778 .33918 1.00602 .32222 1.02181 .34019 1.02355 Mtetra
.691 .853 .96 r
.37455 .99055 .35643 .98876 .33918 1.00602 .35723 1.00778 Mtetra
.711 .848 .948 r
.39216 .97148 .37396 .96965 .35643 .98876 .37455 .99055 Mtetra
.733 .84 .931 r
.41005 .95002 .39179 .94813 .37396 .96965 .39216 .97148 Mtetra
.755 .828 .908 r
.42822 .92538 .4099 .9234 .39179 .94813 .41005 .95002 Mtetra
.776 .81 .88 r
.44664 .89642 .42827 .89431 .4099 .9234 .42822 .92538 Mtetra
.796 .787 .844 r
.46529 .86139 .44689 .85907 .42827 .89431 .44664 .89642 Mtetra
.812 .758 .802 r
.4841 .81756 .4657 .81493 .44689 .85907 .46529 .86139 Mtetra
.824 .725 .756 r
.50296 .76042 .4846 .7573 .4657 .81493 .4841 .81756 Mtetra
.831 .691 .709 r
.52168 .68217 .50342 .67827 .4846 .7573 .50296 .76042 Mtetra
.833 .657 .664 r
.53984 .56835 .52178 .56314 .50342 .67827 .52168 .68217 Mtetra
.834 .628 .624 r
.55659 .38982 .53892 .38235 .52178 .56314 .53984 .56835 Mtetra
.833 .605 .592 r
.56989 .08138 .55298 .06981 .53892 .38235 .55659 .38982 Mtetra
.562 .845 .997 r
.09885 1.18412 .08211 1.1825 .06912 1.19092 .08577 1.19254 Mtetra
.564 .846 .997 r
.11213 1.17552 .0953 1.17389 .08211 1.1825 .09885 1.18412 Mtetra
.567 .847 .997 r
.12561 1.16673 .10869 1.16509 .0953 1.17389 .11213 1.17552 Mtetra
.569 .848 .997 r
.13931 1.15772 .1223 1.15608 .10869 1.16509 .12561 1.16673 Mtetra
.572 .849 .996 r
.15323 1.14849 .13612 1.14684 .1223 1.15608 .13931 1.15772 Mtetra
.575 .85 .996 r
.16736 1.13901 .15017 1.13735 .13612 1.14684 .15323 1.14849 Mtetra
.579 .851 .995 r
.18173 1.12926 .16444 1.1276 .15017 1.13735 .16736 1.13901 Mtetra
.584 .852 .995 r
.19633 1.11921 .17895 1.11755 .16444 1.1276 .18173 1.12926 Mtetra
.589 .853 .994 r
.21117 1.10883 .1937 1.10716 .17895 1.11755 .19633 1.11921 Mtetra
.595 .855 .993 r
.22625 1.09807 .20869 1.0964 .1937 1.10716 .21117 1.10883 Mtetra
.602 .856 .992 r
.24159 1.0869 .22393 1.08522 .20869 1.0964 .22625 1.09807 Mtetra
.61 .857 .99 r
.25718 1.07523 .23943 1.07356 .22393 1.08522 .24159 1.0869 Mtetra
.619 .858 .988 r
.27303 1.06301 .2552 1.06133 .23943 1.07356 .25718 1.07523 Mtetra
.63 .859 .985 r
.28915 1.05012 .27123 1.04843 .2552 1.06133 .27303 1.06301 Mtetra
.642 .859 .982 r
.30555 1.03644 .28754 1.03475 .27123 1.04843 .28915 1.05012 Mtetra
.656 .859 .977 r
.32222 1.02181 .30412 1.02011 .28754 1.03475 .30555 1.03644 Mtetra
.673 .858 .97 r
.33918 1.00602 .321 1.0043 .30412 1.02011 .32222 1.02181 Mtetra
.691 .855 .961 r
.35643 .98876 .33817 .98703 .321 1.0043 .33918 1.00602 Mtetra
.711 .85 .948 r
.37396 .96965 .35563 .96788 .33817 .98703 .35643 .98876 Mtetra
.733 .842 .931 r
.39179 .94813 .37339 .94631 .35563 .96788 .37396 .96965 Mtetra
.756 .829 .909 r
.4099 .9234 .39144 .9215 .37339 .94631 .39179 .94813 Mtetra
.778 .812 .88 r
.42827 .89431 .40977 .89229 .39144 .9215 .4099 .9234 Mtetra
.798 .789 .844 r
.44689 .85907 .42836 .85687 .40977 .89229 .42827 .89431 Mtetra
.814 .76 .802 r
.4657 .81493 .44717 .81244 .42836 .85687 .44689 .85907 Mtetra
.825 .726 .756 r
.4846 .7573 .46611 .75435 .44717 .81244 .4657 .81493 Mtetra
.832 .692 .708 r
.50342 .67827 .48503 .67457 .46611 .75435 .4846 .7573 Mtetra
.835 .658 .663 r
.52178 .56314 .5036 .55819 .48503 .67457 .50342 .67827 Mtetra
.835 .628 .623 r
.53892 .38235 .52114 .37522 .5036 .55819 .52178 .56314 Mtetra
.834 .605 .592 r
.55298 .06981 .536 .05871 .52114 .37522 .53892 .38235 Mtetra
.561 .846 .997 r
.08211 1.1825 .06526 1.18088 .05236 1.18931 .06912 1.19092 Mtetra
.563 .846 .997 r
.0953 1.17389 .07836 1.17227 .06526 1.18088 .08211 1.1825 Mtetra
.566 .847 .997 r
.10869 1.16509 .09166 1.16346 .07836 1.17227 .0953 1.17389 Mtetra
.568 .848 .997 r
.1223 1.15608 .10518 1.15444 .09166 1.16346 .10869 1.16509 Mtetra
.571 .849 .996 r
.13612 1.14684 .11891 1.1452 .10518 1.15444 .1223 1.15608 Mtetra
.574 .85 .996 r
.15017 1.13735 .13287 1.13571 .11891 1.1452 .13612 1.14684 Mtetra
.578 .851 .996 r
.16444 1.1276 .14705 1.12595 .13287 1.13571 .15017 1.13735 Mtetra
.583 .853 .995 r
.17895 1.11755 .16146 1.1159 .14705 1.12595 .16444 1.1276 Mtetra
.588 .854 .994 r
.1937 1.10716 .17611 1.10551 .16146 1.1159 .17895 1.11755 Mtetra
.594 .855 .993 r
.20869 1.0964 .19101 1.09475 .17611 1.10551 .1937 1.10716 Mtetra
.601 .856 .992 r
.22393 1.08522 .20616 1.08357 .19101 1.09475 .20869 1.0964 Mtetra
.609 .858 .991 r
.23943 1.07356 .22157 1.07191 .20616 1.08357 .22393 1.08522 Mtetra
.618 .859 .989 r
.2552 1.06133 .23724 1.05968 .22157 1.07191 .23943 1.07356 Mtetra
.629 .86 .986 r
.27123 1.04843 .25318 1.04678 .23724 1.05968 .2552 1.06133 Mtetra
.641 .86 .982 r
.28754 1.03475 .2694 1.0331 .25318 1.04678 .27123 1.04843 Mtetra
.656 .86 .977 r
.30412 1.02011 .2859 1.01846 .2694 1.0331 .28754 1.03475 Mtetra
.672 .859 .971 r
.321 1.0043 .30269 1.00264 .2859 1.01846 .30412 1.02011 Mtetra
.691 .856 .961 r
.33817 .98703 .31978 .98534 .30269 1.00264 .321 1.0043 Mtetra
.712 .851 .949 r
.35563 .96788 .33716 .96617 .31978 .98534 .33817 .98703 Mtetra
.734 .843 .932 r
.37339 .94631 .35485 .94456 .33716 .96617 .35563 .96788 Mtetra
.756 .831 .909 r
.39144 .9215 .37284 .91968 .35485 .94456 .37339 .94631 Mtetra
.779 .813 .88 r
.40977 .89229 .39112 .89036 .37284 .91968 .39144 .9215 Mtetra
.799 .79 .844 r
.42836 .85687 .40969 .85477 .39112 .89036 .40977 .89229 Mtetra
.815 .761 .802 r
.44717 .81244 .4285 .81007 .40969 .85477 .42836 .85687 Mtetra
.827 .727 .755 r
.46611 .75435 .44748 .75155 .4285 .81007 .44717 .81244 Mtetra
.833 .692 .707 r
.48503 .67457 .46651 .67106 .44748 .75155 .46611 .75435 Mtetra
.836 .658 .662 r
.5036 .55819 .4853 .55348 .46651 .67106 .48503 .67457 Mtetra
.836 .629 .623 r
.52114 .37522 .50326 .3684 .4853 .55348 .5036 .55819 Mtetra
.835 .606 .591 r
.536 .05871 .51895 .04804 .50326 .3684 .52114 .37522 Mtetra
.56 .846 .997 r
.06526 1.18088 .04831 1.17927 .0355 1.18771 .05236 1.18931 Mtetra
.562 .847 .997 r
.07836 1.17227 .06132 1.17065 .04831 1.17927 .06526 1.18088 Mtetra
.564 .848 .997 r
.09166 1.16346 .07453 1.16184 .06132 1.17065 .07836 1.17227 Mtetra
.567 .849 .997 r
.10518 1.15444 .08795 1.15282 .07453 1.16184 .09166 1.16346 Mtetra
.57 .85 .997 r
.11891 1.1452 .10159 1.14357 .08795 1.15282 .10518 1.15444 Mtetra
.573 .851 .996 r
.13287 1.13571 .11545 1.13408 .10159 1.14357 .11891 1.1452 Mtetra
.577 .852 .996 r
.14705 1.12595 .12953 1.12432 .11545 1.13408 .13287 1.13571 Mtetra
.582 .853 .995 r
.16146 1.1159 .14385 1.11426 .12953 1.12432 .14705 1.12595 Mtetra
.587 .854 .994 r
.17611 1.10551 .15841 1.10388 .14385 1.11426 .16146 1.1159 Mtetra
.593 .856 .994 r
.19101 1.09475 .17322 1.09312 .15841 1.10388 .17611 1.10551 Mtetra
.6 .857 .992 r
.20616 1.08357 .18827 1.08194 .17322 1.09312 .19101 1.09475 Mtetra
.608 .858 .991 r
.22157 1.07191 .20358 1.07028 .18827 1.08194 .20616 1.08357 Mtetra
.617 .86 .989 r
.23724 1.05968 .21916 1.05805 .20358 1.07028 .22157 1.07191 Mtetra
.628 .861 .986 r
.25318 1.04678 .23501 1.04516 .21916 1.05805 .23724 1.05968 Mtetra
.641 .861 .983 r
.2694 1.0331 .25113 1.03148 .23501 1.04516 .25318 1.04678 Mtetra
.655 .861 .978 r
.2859 1.01846 .26754 1.01683 .25113 1.03148 .2694 1.0331 Mtetra
.672 .86 .971 r
.30269 1.00264 .28425 1.00101 .26754 1.01683 .2859 1.01846 Mtetra
.691 .858 .962 r
.31978 .98534 .30125 .98371 .28425 1.00101 .30269 1.00264 Mtetra
.712 .853 .95 r
.33716 .96617 .31856 .96452 .30125 .98371 .31978 .98534 Mtetra
.734 .845 .933 r
.35485 .94456 .33618 .94287 .31856 .96452 .33716 .96617 Mtetra
.757 .833 .91 r
.37284 .91968 .3541 .91794 .33618 .94287 .35485 .94456 Mtetra
.78 .815 .881 r
.39112 .89036 .37234 .88852 .3541 .91794 .37284 .91968 Mtetra
.8 .791 .844 r
.40969 .85477 .39087 .85278 .37234 .88852 .39112 .89036 Mtetra
.816 .762 .802 r
.4285 .81007 .40968 .80783 .39087 .85278 .40969 .85477 Mtetra
.828 .728 .755 r
.44748 .75155 .42871 .7489 .40968 .80783 .4285 .81007 Mtetra
.835 .693 .707 r
.46651 .67106 .44785 .66773 .42871 .7489 .44748 .75155 Mtetra
.837 .659 .661 r
.4853 .55348 .46687 .549 .44785 .66773 .46651 .67106 Mtetra
.837 .629 .622 r
.50326 .3684 .48527 .36188 .46687 .549 .4853 .55348 Mtetra
.836 .606 .591 r
.51895 .04804 .50181 .03778 .48527 .36188 .50326 .3684 Mtetra
.559 .846 .998 r
.04831 1.17927 .03126 1.17767 .01854 1.18611 .0355 1.18771 Mtetra
.561 .847 .997 r
.06132 1.17065 .04417 1.16904 .03126 1.17767 .04831 1.17927 Mtetra
.563 .848 .997 r
.07453 1.16184 .05728 1.16023 .04417 1.16904 .06132 1.17065 Mtetra
.566 .849 .997 r
.08795 1.15282 .07061 1.1512 .05728 1.16023 .07453 1.16184 Mtetra
.569 .85 .997 r
.10159 1.14357 .08415 1.14195 .07061 1.1512 .08795 1.15282 Mtetra
.572 .851 .996 r
.11545 1.13408 .09792 1.13246 .08415 1.14195 .10159 1.14357 Mtetra
.576 .852 .996 r
.12953 1.12432 .11191 1.1227 .09792 1.13246 .11545 1.13408 Mtetra
.58 .854 .995 r
.14385 1.11426 .12613 1.11265 .11191 1.1227 .12953 1.12432 Mtetra
.585 .855 .995 r
.15841 1.10388 .14059 1.10226 .12613 1.11265 .14385 1.11426 Mtetra
.591 .856 .994 r
.17322 1.09312 .1553 1.09151 .14059 1.10226 .15841 1.10388 Mtetra
.598 .858 .993 r
.18827 1.08194 .17025 1.08033 .1553 1.09151 .17322 1.09312 Mtetra
.606 .859 .991 r
.20358 1.07028 .18547 1.06867 .17025 1.08033 .18827 1.08194 Mtetra
.616 .86 .989 r
.21916 1.05805 .20095 1.05645 .18547 1.06867 .20358 1.07028 Mtetra
.627 .861 .987 r
.23501 1.04516 .2167 1.04356 .20095 1.05645 .21916 1.05805 Mtetra
.64 .862 .983 r
.25113 1.03148 .23274 1.02989 .2167 1.04356 .23501 1.04516 Mtetra
.654 .862 .978 r
.26754 1.01683 .24906 1.01525 .23274 1.02989 .25113 1.03148 Mtetra
.671 .861 .972 r
.28425 1.00101 .26567 .99943 .24906 1.01525 .26754 1.01683 Mtetra
.69 .859 .963 r
.30125 .98371 .28259 .98212 .26567 .99943 .28425 1.00101 Mtetra
.711 .854 .95 r
.31856 .96452 .29982 .96292 .28259 .98212 .30125 .98371 Mtetra
.734 .847 .933 r
.33618 .94287 .31736 .94124 .29982 .96292 .31856 .96452 Mtetra
.758 .834 .911 r
.3541 .91794 .33522 .91626 .31736 .94124 .33618 .94287 Mtetra
.78 .817 .881 r
.37234 .88852 .35341 .88676 .33522 .91626 .3541 .91794 Mtetra
.801 .793 .845 r
.39087 .85278 .37192 .85088 .35341 .88676 .37234 .88852 Mtetra
.818 .763 .802 r
.40968 .80783 .39072 .8057 .37192 .85088 .39087 .85278 Mtetra
.829 .729 .754 r
.42871 .7489 .4098 .74639 .39072 .8057 .40968 .80783 Mtetra
.836 .694 .706 r
.44785 .66773 .42905 .66458 .4098 .74639 .42871 .7489 Mtetra
.838 .659 .661 r
.46687 .549 .44832 .54473 .42905 .66458 .44785 .66773 Mtetra
.838 .63 .621 r
.48527 .36188 .46717 .35564 .44832 .54473 .46687 .549 Mtetra
.837 .606 .59 r
.50181 .03778 .4846 .02789 .46717 .35564 .48527 .36188 Mtetra
.558 .846 .998 r
.03126 1.17767 .01409 1.17607 .00148 1.18452 .01854 1.18611 Mtetra
.56 .847 .997 r
.04417 1.16904 .02691 1.16744 .01409 1.17607 .03126 1.17767 Mtetra
.562 .848 .997 r
.05728 1.16023 .03993 1.15862 .02691 1.16744 .04417 1.16904 Mtetra
.565 .849 .997 r
.07061 1.1512 .05316 1.14959 .03993 1.15862 .05728 1.16023 Mtetra
.568 .85 .997 r
.08415 1.14195 .06661 1.14034 .05316 1.14959 .07061 1.1512 Mtetra
.571 .851 .996 r
.09792 1.13246 .08027 1.13085 .06661 1.14034 .08415 1.14195 Mtetra
.575 .853 .996 r
.11191 1.1227 .09417 1.12109 .08027 1.13085 .09792 1.13246 Mtetra
.579 .854 .996 r
.12613 1.11265 .10829 1.11104 .09417 1.12109 .11191 1.1227 Mtetra
.584 .855 .995 r
.14059 1.10226 .12265 1.10066 .10829 1.11104 .12613 1.11265 Mtetra
.59 .857 .994 r
.1553 1.09151 .13726 1.08991 .12265 1.10066 .14059 1.10226 Mtetra
.597 .858 .993 r
.17025 1.08033 .15212 1.07874 .13726 1.08991 .1553 1.09151 Mtetra
.605 .86 .992 r
.18547 1.06867 .16723 1.06708 .15212 1.07874 .17025 1.08033 Mtetra
.615 .861 .99 r
.20095 1.05645 .18262 1.05487 .16723 1.06708 .18547 1.06867 Mtetra
.626 .862 .987 r
.2167 1.04356 .19827 1.04199 .18262 1.05487 .20095 1.05645 Mtetra
.639 .863 .984 r
.23274 1.02989 .21421 1.02833 .19827 1.04199 .2167 1.04356 Mtetra
.653 .863 .979 r
.24906 1.01525 .23043 1.0137 .21421 1.02833 .23274 1.02989 Mtetra
.67 .863 .972 r
.26567 .99943 .24696 .99788 .23043 1.0137 .24906 1.01525 Mtetra
.69 .86 .963 r
.28259 .98212 .26379 .98057 .24696 .99788 .26567 .99943 Mtetra
.711 .856 .951 r
.29982 .96292 .28093 .96137 .26379 .98057 .28259 .98212 Mtetra
.734 .848 .934 r
.31736 .94124 .2984 .93967 .28093 .96137 .29982 .96292 Mtetra
.758 .836 .911 r
.33522 .91626 .3162 .91465 .2984 .93967 .31736 .94124 Mtetra
.781 .818 .882 r
.35341 .88676 .33434 .88508 .3162 .91465 .33522 .91626 Mtetra
.802 .794 .845 r
.37192 .85088 .35281 .84907 .33434 .88508 .35341 .88676 Mtetra
.819 .764 .802 r
.39072 .8057 .37162 .80368 .35281 .84907 .37192 .85088 Mtetra
.83 .73 .754 r
.4098 .74639 .39074 .74401 .37162 .80368 .39072 .8057 Mtetra
.837 .694 .706 r
.42905 .66458 .41012 .66158 .39074 .74401 .4098 .74639 Mtetra
.839 .66 .66 r
.44832 .54473 .42962 .54067 .41012 .66158 .42905 .66458 Mtetra
.839 .63 .621 r
.46717 .35564 .44895 .34966 .42962 .54067 .44832 .54473 Mtetra
.837 .607 .59 r
.4846 .02789 .4673 .01837 .44895 .34966 .46717 .35564 Mtetra
0 g
.92704 .1866 m
1 1.03178 L
s
1 1.03178 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
.46728 0 m
.92704 .1866 L
s
.46728 0 m
.05486 .44445 L
s
.05486 .44445 m
0 1.205 L
s
0 1.205 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
.46728 0 m
.05486 .44445 L
s
gsave
.13973 .21216 -73 -16.7992 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
1 1.03178 L
s
gsave
1.06018 .61135 -61 -10.3528 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.014568 0.97619 0.597289 MathSubStart
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.235457 1.39492 1.11022e-016 1.39492 [
[.13973 .21216 -12 -12.7992 ]
[.13973 .21216 0 6.2008 ]
[.70223 -0.00719 -6.27755 -19 ]
[.70223 -0.00719 5.72245 0 ]
[1.06018 .61135 0 -6.3528 ]
[1.06018 .61135 20 12.6472 ]
[ 0 0 0 0 ]
[ 1 1.2849 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.46728 0 m
.05486 .44445 L
s
gsave
.13973 .21216 -73 -16.7992 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
.46728 0 L
s
gsave
.70223 -0.00719 -67.2776 -23 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
1 1.03178 L
s
gsave
1.06018 .61135 -61 -10.3528 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
79.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
1 1.03178 L
s
1 1.03178 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
.46728 0 m
.92704 .1866 L
s
.45805 .56681 m
.05486 .44445 L
s
.05486 .44445 m
0 1.205 L
s
0 1.205 m
.45756 1.2849 L
s
.45756 1.2849 m
.45805 .56681 L
s
.92704 .1866 m
1 1.03178 L
s
1 1.03178 m
.45756 1.2849 L
s
.45756 1.2849 m
.45805 .56681 L
s
.45805 .56681 m
.92704 .1866 L
s
.46728 0 m
.05486 .44445 L
s
.05486 .44445 m
0 1.205 L
s
0 1.205 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
0 0 m
1 0 L
1 1.2849 L
0 1.2849 L
closepath
clip
newpath
.372 .268 .605 r
.47248 1.25864 .45793 1.11597 .44341 1.12392 .45757 1.26573 Mtetra
.4876 1.25144 .47266 1.10791 .45793 1.11597 .47248 1.25864 Mtetra
.50294 1.24415 .48759 1.09973 .47266 1.10791 .4876 1.25144 Mtetra
.5185 1.23674 .50274 1.09143 .48759 1.09973 .50294 1.24415 Mtetra
.5343 1.22922 .51811 1.08302 .50274 1.09143 .5185 1.23674 Mtetra
.55032 1.2216 .5337 1.07448 .51811 1.08302 .5343 1.22922 Mtetra
.56659 1.21386 .54952 1.06582 .5337 1.07448 .55032 1.2216 Mtetra
.5831 1.206 .56558 1.05703 .54952 1.06582 .56659 1.21386 Mtetra
.59986 1.19803 .58187 1.04811 .56558 1.05703 .5831 1.206 Mtetra
.61688 1.18993 .59841 1.03906 .58187 1.04811 .59986 1.19803 Mtetra
.63416 1.18171 .61519 1.02986 .59841 1.03906 .61688 1.18993 Mtetra
.65171 1.17336 .63223 1.02054 .61519 1.02986 .63416 1.18171 Mtetra
.66953 1.16488 .64953 1.01106 .63223 1.02054 .65171 1.17336 Mtetra
.68763 1.15626 .6671 1.00144 .64953 1.01106 .66953 1.16488 Mtetra
.70603 1.14751 .68494 .99167 .6671 1.00144 .68763 1.15626 Mtetra
.72471 1.13862 .70306 .98175 .68494 .99167 .70603 1.14751 Mtetra
.7437 1.12959 .72147 .97168 .70306 .98175 .72471 1.13862 Mtetra
.76299 1.12041 .74017 .96144 .72147 .97168 .7437 1.12959 Mtetra
.7826 1.11108 .75917 .95103 .74017 .96144 .76299 1.12041 Mtetra
.80254 1.10159 .77848 .94046 .75917 .95103 .7826 1.11108 Mtetra
.82281 1.09195 .7981 .92972 .77848 .94046 .80254 1.10159 Mtetra
.84342 1.08214 .81804 .9188 .7981 .92972 .82281 1.09195 Mtetra
.86438 1.07217 .83832 .9077 .81804 .9188 .84342 1.08214 Mtetra
.8857 1.06202 .85893 .89641 .83832 .9077 .86438 1.07217 Mtetra
.90738 1.05171 .87989 .88493 .85893 .89641 .8857 1.06202 Mtetra
.92944 1.04121 .90121 .87326 .87989 .88493 .90738 1.05171 Mtetra
.95189 1.03053 .92289 .86139 .90121 .87326 .92944 1.04121 Mtetra
.97474 1.01965 .94495 .84931 .92289 .86139 .95189 1.03053 Mtetra
.998 1.00859 .9674 .83702 .94495 .84931 .97474 1.01965 Mtetra
.404 .333 .663 r
.45793 1.11597 .4437 1.05666 .42936 1.06497 .44341 1.12392 Mtetra
.47266 1.10791 .45823 1.04823 .4437 1.05666 .45793 1.11597 Mtetra
.48759 1.09973 .47297 1.03969 .45823 1.04823 .47266 1.10791 Mtetra
.50274 1.09143 .48791 1.03102 .47297 1.03969 .48759 1.09973 Mtetra
.51811 1.08302 .50308 1.02222 .48791 1.03102 .50274 1.09143 Mtetra
.5337 1.07448 .51846 1.01331 .50308 1.02222 .51811 1.08302 Mtetra
.54952 1.06582 .53406 1.00426 .51846 1.01331 .5337 1.07448 Mtetra
.56558 1.05703 .54989 .99507 .53406 1.00426 .54952 1.06582 Mtetra
.58187 1.04811 .56596 .98576 .54989 .99507 .56558 1.05703 Mtetra
.59841 1.03906 .58227 .9763 .56596 .98576 .58187 1.04811 Mtetra
.61519 1.02986 .59882 .9667 .58227 .9763 .59841 1.03906 Mtetra
.63223 1.02054 .61562 .95696 .59882 .9667 .61519 1.02986 Mtetra
.64953 1.01106 .63267 .94707 .61562 .95696 .63223 1.02054 Mtetra
.6671 1.00144 .64999 .93703 .63267 .94707 .64953 1.01106 Mtetra
.68494 .99167 .66757 .92683 .64999 .93703 .6671 1.00144 Mtetra
.70306 .98175 .68543 .91648 .66757 .92683 .68494 .99167 Mtetra
.72147 .97168 .70356 .90596 .68543 .91648 .70306 .98175 Mtetra
.74017 .96144 .72199 .89528 .70356 .90596 .72147 .97168 Mtetra
.75917 .95103 .7407 .88442 .72199 .89528 .74017 .96144 Mtetra
.77848 .94046 .75972 .87339 .7407 .88442 .75917 .95103 Mtetra
.7981 .92972 .77904 .86219 .75972 .87339 .77848 .94046 Mtetra
.81804 .9188 .79869 .8508 .77904 .86219 .7981 .92972 Mtetra
.83832 .9077 .81865 .83922 .79869 .8508 .81804 .9188 Mtetra
.85893 .89641 .83894 .82745 .81865 .83922 .83832 .9077 Mtetra
.87989 .88493 .85958 .81548 .83894 .82745 .85893 .89641 Mtetra
.90121 .87326 .88056 .80332 .85958 .81548 .87989 .88493 Mtetra
.92289 .86139 .9019 .79094 .88056 .80332 .90121 .87326 Mtetra
.94495 .84931 .9236 .77835 .9019 .79094 .92289 .86139 Mtetra
.9674 .83702 .94569 .76555 .9236 .77835 .94495 .84931 Mtetra
.419 .363 .688 r
.4437 1.05666 .42958 1.01092 .4154 1.01951 .42936 1.06497 Mtetra
.45823 1.04823 .44395 1.00221 .42958 1.01092 .4437 1.05666 Mtetra
.47297 1.03969 .45852 .99338 .44395 1.00221 .45823 1.04823 Mtetra
.48791 1.03102 .4733 .98442 .45852 .99338 .47297 1.03969 Mtetra
.50308 1.02222 .48829 .97533 .4733 .98442 .48791 1.03102 Mtetra
.51846 1.01331 .5035 .96611 .48829 .97533 .50308 1.02222 Mtetra
.53406 1.00426 .51893 .95676 .5035 .96611 .51846 1.01331 Mtetra
.54989 .99507 .53458 .94728 .51893 .95676 .53406 1.00426 Mtetra
.56596 .98576 .55046 .93765 .53458 .94728 .54989 .99507 Mtetra
.58227 .9763 .56658 .92788 .55046 .93765 .56596 .98576 Mtetra
.59882 .9667 .58293 .91797 .56658 .92788 .58227 .9763 Mtetra
.61562 .95696 .59953 .90791 .58293 .91797 .59882 .9667 Mtetra
.63267 .94707 .61639 .89769 .59953 .90791 .61562 .95696 Mtetra
.64999 .93703 .6335 .88732 .61639 .89769 .63267 .94707 Mtetra
.66757 .92683 .65087 .87679 .6335 .88732 .64999 .93703 Mtetra
.68543 .91648 .66851 .8661 .65087 .87679 .66757 .92683 Mtetra
.70356 .90596 .68643 .85523 .66851 .8661 .68543 .91648 Mtetra
.72199 .89528 .70463 .8442 .68643 .85523 .70356 .90596 Mtetra
.7407 .88442 .72312 .833 .70463 .8442 .72199 .89528 Mtetra
.75972 .87339 .7419 .82161 .72312 .833 .7407 .88442 Mtetra
.77904 .86219 .76099 .81004 .7419 .82161 .75972 .87339 Mtetra
.79869 .8508 .78038 .79829 .76099 .81004 .77904 .86219 Mtetra
.81865 .83922 .8001 .78634 .78038 .79829 .79869 .8508 Mtetra
.83894 .82745 .82013 .77419 .8001 .78634 .81865 .83922 Mtetra
.85958 .81548 .84051 .76185 .82013 .77419 .83894 .82745 Mtetra
.88056 .80332 .86122 .74929 .84051 .76185 .85958 .81548 Mtetra
.9019 .79094 .88229 .73652 .86122 .74929 .88056 .80332 Mtetra
.9236 .77835 .90371 .72354 .88229 .73652 .9019 .79094 Mtetra
.94569 .76555 .9255 .71033 .90371 .72354 .9236 .77835 Mtetra
.43 .385 .707 r
.42958 1.01092 .41553 .97215 .40149 .98098 .4154 1.01951 Mtetra
.44395 1.00221 .42975 .9632 .41553 .97215 .42958 1.01092 Mtetra
.45852 .99338 .44418 .95412 .42975 .9632 .44395 1.00221 Mtetra
.4733 .98442 .45881 .94491 .44418 .95412 .45852 .99338 Mtetra
.48829 .97533 .47365 .93557 .45881 .94491 .4733 .98442 Mtetra
.5035 .96611 .4887 .9261 .47365 .93557 .48829 .97533 Mtetra
.51893 .95676 .50397 .9165 .4887 .9261 .5035 .96611 Mtetra
.53458 .94728 .51946 .90675 .50397 .9165 .51893 .95676 Mtetra
.55046 .93765 .53518 .89686 .51946 .90675 .53458 .94728 Mtetra
.56658 .92788 .55113 .88682 .53518 .89686 .55046 .93765 Mtetra
.58293 .91797 .56731 .87664 .55113 .88682 .56658 .92788 Mtetra
.59953 .90791 .58374 .8663 .56731 .87664 .58293 .91797 Mtetra
.61639 .89769 .60042 .85581 .58374 .8663 .59953 .90791 Mtetra
.6335 .88732 .61735 .84515 .60042 .85581 .61639 .89769 Mtetra
.65087 .87679 .63454 .83434 .61735 .84515 .6335 .88732 Mtetra
.66851 .8661 .65199 .82335 .63454 .83434 .65087 .87679 Mtetra
.68643 .85523 .66971 .8122 .65199 .82335 .66851 .8661 Mtetra
.70463 .8442 .68772 .80087 .66971 .8122 .68643 .85523 Mtetra
.72312 .833 .706 .78936 .68772 .80087 .70463 .8442 Mtetra
.7419 .82161 .72458 .77767 .706 .78936 .72312 .833 Mtetra
.76099 .81004 .74346 .7658 .72458 .77767 .7419 .82161 Mtetra
.78038 .79829 .76264 .75373 .74346 .7658 .76099 .81004 Mtetra
.8001 .78634 .78213 .74146 .76264 .75373 .78038 .79829 Mtetra
.82013 .77419 .80195 .72899 .78213 .74146 .8001 .78634 Mtetra
.84051 .76185 .82209 .71632 .80195 .72899 .82013 .77419 Mtetra
.86122 .74929 .84257 .70343 .82209 .71632 .84051 .76185 Mtetra
.88229 .73652 .8634 .69032 .84257 .70343 .86122 .74929 Mtetra
.90371 .72354 .88458 .677 .8634 .69032 .88229 .73652 Mtetra
.9255 .71033 .90612 .66344 .88458 .677 .90371 .72354 Mtetra
.439 .403 .721 r
.41553 .97215 .40152 .9378 .38762 .94684 .40149 .98098 Mtetra
.42975 .9632 .41562 .92863 .40152 .9378 .41553 .97215 Mtetra
.44418 .95412 .42991 .91933 .41562 .92863 .42975 .9632 Mtetra
.45881 .94491 .4444 .9099 .42991 .91933 .44418 .95412 Mtetra
.47365 .93557 .4591 .90034 .4444 .9099 .45881 .94491 Mtetra
.4887 .9261 .47401 .89064 .4591 .90034 .47365 .93557 Mtetra
.50397 .9165 .48913 .88081 .47401 .89064 .4887 .9261 Mtetra
.51946 .90675 .50448 .87083 .48913 .88081 .50397 .9165 Mtetra
.53518 .89686 .52004 .8607 .50448 .87083 .51946 .90675 Mtetra
.55113 .88682 .53584 .85042 .52004 .8607 .53518 .89686 Mtetra
.56731 .87664 .55187 .84 .53584 .85042 .55113 .88682 Mtetra
.58374 .8663 .56814 .82941 .55187 .84 .56731 .87664 Mtetra
.60042 .85581 .58465 .81867 .56814 .82941 .58374 .8663 Mtetra
.61735 .84515 .60141 .80777 .58465 .81867 .60042 .85581 Mtetra
.63454 .83434 .61843 .7967 .60141 .80777 .61735 .84515 Mtetra
.65199 .82335 .63571 .78545 .61843 .7967 .63454 .83434 Mtetra
.66971 .8122 .65326 .77404 .63571 .78545 .65199 .82335 Mtetra
.68772 .80087 .67108 .76244 .65326 .77404 .66971 .8122 Mtetra
.706 .78936 .68919 .75067 .67108 .76244 .68772 .80087 Mtetra
.72458 .77767 .70758 .7387 .68919 .75067 .706 .78936 Mtetra
.74346 .7658 .72626 .72655 .70758 .7387 .72458 .77767 Mtetra
.76264 .75373 .74525 .7142 .72626 .72655 .74346 .7658 Mtetra
.78213 .74146 .76455 .70164 .74525 .7142 .76264 .75373 Mtetra
.80195 .72899 .78416 .68889 .76455 .70164 .78213 .74146 Mtetra
.82209 .71632 .80409 .67592 .78416 .68889 .80195 .72899 Mtetra
.84257 .70343 .82436 .66273 .80409 .67592 .82209 .71632 Mtetra
.8634 .69032 .84497 .64933 .82436 .66273 .84257 .70343 Mtetra
.88458 .677 .86593 .63569 .84497 .64933 .8634 .69032 Mtetra
.90612 .66344 .88724 .62183 .86593 .63569 .88458 .677 Mtetra
.447 .418 .733 r
.40152 .9378 .38756 .90656 .37378 .9158 .38762 .94684 Mtetra
.41562 .92863 .40153 .8972 .38756 .90656 .40152 .9378 Mtetra
.42991 .91933 .41569 .8877 .40153 .8972 .41562 .92863 Mtetra
.4444 .9099 .43005 .87807 .41569 .8877 .42991 .91933 Mtetra
.4591 .90034 .44462 .8683 .43005 .87807 .4444 .9099 Mtetra
.47401 .89064 .4594 .85839 .44462 .8683 .4591 .90034 Mtetra
.48913 .88081 .47438 .84834 .4594 .85839 .47401 .89064 Mtetra
.50448 .87083 .48958 .83815 .47438 .84834 .48913 .88081 Mtetra
.52004 .8607 .50501 .82781 .48958 .83815 .50448 .87083 Mtetra
.53584 .85042 .52066 .81731 .50501 .82781 .52004 .8607 Mtetra
.55187 .84 .53654 .80666 .52066 .81731 .53584 .85042 Mtetra
.56814 .82941 .55266 .79586 .53654 .80666 .55187 .84 Mtetra
.58465 .81867 .56902 .78489 .55266 .79586 .56814 .82941 Mtetra
.60141 .80777 .58563 .77375 .56902 .78489 .58465 .81867 Mtetra
.61843 .7967 .60249 .76244 .58563 .77375 .60141 .80777 Mtetra
.63571 .78545 .61961 .75096 .60249 .76244 .61843 .7967 Mtetra
.65326 .77404 .637 .73931 .61961 .75096 .63571 .78545 Mtetra
.67108 .76244 .65465 .72747 .637 .73931 .65326 .77404 Mtetra
.68919 .75067 .67258 .71544 .65465 .72747 .67108 .76244 Mtetra
.70758 .7387 .6908 .70323 .67258 .71544 .68919 .75067 Mtetra
.72626 .72655 .70931 .69082 .6908 .70323 .70758 .7387 Mtetra
.74525 .7142 .72811 .67821 .70931 .69082 .72626 .72655 Mtetra
.76455 .70164 .74722 .6654 .72811 .67821 .74525 .7142 Mtetra
.78416 .68889 .76665 .65237 .74722 .6654 .76455 .70164 Mtetra
.80409 .67592 .78639 .63913 .76665 .65237 .78416 .68889 Mtetra
.82436 .66273 .80646 .62567 .78639 .63913 .80409 .67592 Mtetra
.84497 .64933 .82687 .61199 .80646 .62567 .82436 .66273 Mtetra
.86593 .63569 .84762 .59807 .82687 .61199 .84497 .64933 Mtetra
.88724 .62183 .86873 .58392 .84762 .59807 .86593 .63569 Mtetra
.454 .43 .743 r
.38756 .90656 .37361 .87767 .35995 .88709 .37378 .9158 Mtetra
.40153 .8972 .38746 .86812 .37361 .87767 .38756 .90656 Mtetra
.41569 .8877 .40151 .85843 .38746 .86812 .40153 .8972 Mtetra
.43005 .87807 .41575 .84861 .40151 .85843 .41569 .8877 Mtetra
.44462 .8683 .43019 .83865 .41575 .84861 .43005 .87807 Mtetra
.4594 .85839 .44483 .82855 .43019 .83865 .44462 .8683 Mtetra
.47438 .84834 .45969 .81831 .44483 .82855 .4594 .85839 Mtetra
.48958 .83815 .47476 .80791 .45969 .81831 .47438 .84834 Mtetra
.50501 .82781 .49005 .79737 .47476 .80791 .48958 .83815 Mtetra
.52066 .81731 .50556 .78667 .49005 .79737 .50501 .82781 Mtetra
.53654 .80666 .52131 .77581 .50556 .78667 .52066 .81731 Mtetra
.55266 .79586 .53728 .7648 .52131 .77581 .53654 .80666 Mtetra
.56902 .78489 .5535 .75361 .53728 .7648 .55266 .79586 Mtetra
.58563 .77375 .56996 .74226 .5535 .75361 .56902 .78489 Mtetra
.60249 .76244 .58667 .73074 .56996 .74226 .58563 .77375 Mtetra
.61961 .75096 .60364 .71904 .58667 .73074 .60249 .76244 Mtetra
.637 .73931 .62087 .70715 .60364 .71904 .61961 .75096 Mtetra
.65465 .72747 .63837 .69509 .62087 .70715 .637 .73931 Mtetra
.67258 .71544 .65614 .68283 .63837 .69509 .65465 .72747 Mtetra
.6908 .70323 .67419 .67038 .65614 .68283 .67258 .71544 Mtetra
.70931 .69082 .69253 .65773 .67419 .67038 .6908 .70323 Mtetra
.72811 .67821 .71116 .64488 .69253 .65773 .70931 .69082 Mtetra
.74722 .6654 .7301 .63182 .71116 .64488 .72811 .67821 Mtetra
.76665 .65237 .74935 .61855 .7301 .63182 .74722 .6654 Mtetra
.78639 .63913 .76891 .60506 .74935 .61855 .76665 .65237 Mtetra
.80646 .62567 .78879 .59135 .76891 .60506 .78639 .63913 Mtetra
.82687 .61199 .80901 .5774 .78879 .59135 .80646 .62567 Mtetra
.84762 .59807 .82957 .56322 .80901 .5774 .82687 .61199 Mtetra
.86873 .58392 .85049 .5488 .82957 .56322 .84762 .59807 Mtetra
.459 .442 .752 r
.37361 .87767 .35969 .85061 .34614 .86021 .35995 .88709 Mtetra
.38746 .86812 .37342 .84089 .35969 .85061 .37361 .87767 Mtetra
.40151 .85843 .38735 .83103 .37342 .84089 .38746 .86812 Mtetra
.41575 .84861 .40147 .82103 .38735 .83103 .40151 .85843 Mtetra
.43019 .83865 .41579 .81089 .40147 .82103 .41575 .84861 Mtetra
.44483 .82855 .43031 .80061 .41579 .81089 .43019 .83865 Mtetra
.45969 .81831 .44504 .79018 .43031 .80061 .44483 .82855 Mtetra
.47476 .80791 .45999 .77959 .44504 .79018 .45969 .81831 Mtetra
.49005 .79737 .47515 .76886 .45999 .77959 .47476 .80791 Mtetra
.50556 .78667 .49053 .75797 .47515 .76886 .49005 .79737 Mtetra
.52131 .77581 .50614 .74691 .49053 .75797 .50556 .78667 Mtetra
.53728 .7648 .52198 .7357 .50614 .74691 .52131 .77581 Mtetra
.5535 .75361 .53806 .72431 .52198 .7357 .53728 .7648 Mtetra
.56996 .74226 .55438 .71276 .53806 .72431 .5535 .75361 Mtetra
.58667 .73074 .57095 .70103 .55438 .71276 .56996 .74226 Mtetra
.60364 .71904 .58777 .68912 .57095 .70103 .58667 .73074 Mtetra
.62087 .70715 .60485 .67702 .58777 .68912 .60364 .71904 Mtetra
.63837 .69509 .62219 .66474 .60485 .67702 .62087 .70715 Mtetra
.65614 .68283 .63981 .65227 .62219 .66474 .63837 .69509 Mtetra
.67419 .67038 .65771 .63959 .63981 .65227 .65614 .68283 Mtetra
.69253 .65773 .67589 .62672 .65771 .63959 .67419 .67038 Mtetra
.71116 .64488 .69436 .61364 .67589 .62672 .69253 .65773 Mtetra
.7301 .63182 .71313 .60035 .69436 .61364 .71116 .64488 Mtetra
.74935 .61855 .7322 .58684 .71313 .60035 .7301 .63182 Mtetra
.76891 .60506 .75159 .57311 .7322 .58684 .74935 .61855 Mtetra
.78879 .59135 .7713 .55916 .75159 .57311 .76891 .60506 Mtetra
.80901 .5774 .79134 .54497 .7713 .55916 .78879 .59135 Mtetra
.82957 .56322 .81172 .53054 .79134 .54497 .80901 .5774 Mtetra
.85049 .5488 .83245 .51587 .81172 .53054 .82957 .56322 Mtetra
.465 .452 .759 r
.35969 .85061 .34577 .82505 .33233 .83481 .34614 .86021 Mtetra
.37342 .84089 .35939 .81516 .34577 .82505 .35969 .85061 Mtetra
.38735 .83103 .37321 .80513 .35939 .81516 .37342 .84089 Mtetra
.40147 .82103 .38721 .79496 .37321 .80513 .38735 .83103 Mtetra
.41579 .81089 .40142 .78465 .38721 .79496 .40147 .82103 Mtetra
.43031 .80061 .41582 .77419 .40142 .78465 .41579 .81089 Mtetra
.44504 .79018 .43043 .76359 .41582 .77419 .43031 .80061 Mtetra
.45999 .77959 .44525 .75283 .43043 .76359 .44504 .79018 Mtetra
.47515 .76886 .46029 .74191 .44525 .75283 .45999 .77959 Mtetra
.49053 .75797 .47554 .73083 .46029 .74191 .47515 .76886 Mtetra
.50614 .74691 .49102 .7196 .47554 .73083 .49053 .75797 Mtetra
.52198 .7357 .50673 .70819 .49102 .7196 .50614 .74691 Mtetra
.53806 .72431 .52268 .69661 .50673 .70819 .52198 .7357 Mtetra
.55438 .71276 .53886 .68486 .52268 .69661 .53806 .72431 Mtetra
.57095 .70103 .55529 .67294 .53886 .68486 .55438 .71276 Mtetra
.58777 .68912 .57197 .66083 .55529 .67294 .57095 .70103 Mtetra
.60485 .67702 .58891 .64853 .57197 .66083 .58777 .68912 Mtetra
.62219 .66474 .60611 .63604 .58891 .64853 .60485 .67702 Mtetra
.63981 .65227 .62358 .62336 .60611 .63604 .62219 .66474 Mtetra
.65771 .63959 .64132 .61048 .62358 .62336 .63981 .65227 Mtetra
.67589 .62672 .65935 .59739 .64132 .61048 .65771 .63959 Mtetra
.69436 .61364 .67766 .58409 .65935 .59739 .67589 .62672 Mtetra
.71313 .60035 .69627 .57058 .67766 .58409 .69436 .61364 Mtetra
.7322 .58684 .71519 .55685 .69627 .57058 .71313 .60035 Mtetra
.75159 .57311 .73441 .54289 .71519 .55685 .7322 .58684 Mtetra
.7713 .55916 .75395 .5287 .73441 .54289 .75159 .57311 Mtetra
.79134 .54497 .77382 .51428 .75395 .5287 .7713 .55916 Mtetra
.81172 .53054 .79402 .49961 .77382 .51428 .79134 .54497 Mtetra
.83245 .51587 .81457 .4847 .79402 .49961 .81172 .53054 Mtetra
.47 .461 .766 r
.34577 .82505 .33186 .80073 .31853 .81064 .33233 .83481 Mtetra
.35939 .81516 .34537 .79068 .33186 .80073 .34577 .82505 Mtetra
.37321 .80513 .35908 .78049 .34537 .79068 .35939 .81516 Mtetra
.38721 .79496 .37297 .77016 .35908 .78049 .37321 .80513 Mtetra
.40142 .78465 .38706 .75968 .37297 .77016 .38721 .79496 Mtetra
.41582 .77419 .40135 .74906 .38706 .75968 .40142 .78465 Mtetra
.43043 .76359 .41584 .73828 .40135 .74906 .41582 .77419 Mtetra
.44525 .75283 .43054 .72735 .41584 .73828 .43043 .76359 Mtetra
.46029 .74191 .44546 .71626 .43054 .72735 .44525 .75283 Mtetra
.47554 .73083 .46059 .70501 .44546 .71626 .46029 .74191 Mtetra
.49102 .7196 .47595 .69359 .46059 .70501 .47554 .73083 Mtetra
.50673 .70819 .49153 .682 .47595 .69359 .49102 .7196 Mtetra
.52268 .69661 .50734 .67024 .49153 .682 .50673 .70819 Mtetra
.53886 .68486 .5234 .65831 .50734 .67024 .52268 .69661 Mtetra
.55529 .67294 .53969 .64619 .5234 .65831 .53886 .68486 Mtetra
.57197 .66083 .55624 .63389 .53969 .64619 .55529 .67294 Mtetra
.58891 .64853 .57303 .62139 .55624 .63389 .57197 .66083 Mtetra
.60611 .63604 .59009 .60871 .57303 .62139 .58891 .64853 Mtetra
.62358 .62336 .60742 .59583 .59009 .60871 .60611 .63604 Mtetra
.64132 .61048 .62502 .58274 .60742 .59583 .62358 .62336 Mtetra
.65935 .59739 .6429 .56945 .62502 .58274 .64132 .61048 Mtetra
.67766 .58409 .66106 .55594 .6429 .56945 .65935 .59739 Mtetra
.69627 .57058 .67952 .54222 .66106 .55594 .67766 .58409 Mtetra
.71519 .55685 .69827 .52827 .67952 .54222 .69627 .57058 Mtetra
.73441 .54289 .71734 .51409 .69827 .52827 .71519 .55685 Mtetra
.75395 .5287 .73672 .49968 .71734 .51409 .73441 .54289 Mtetra
.77382 .51428 .75642 .48503 .73672 .49968 .75395 .5287 Mtetra
.79402 .49961 .77645 .47014 .75642 .48503 .77382 .51428 Mtetra
.81457 .4847 .79682 .45499 .77645 .47014 .79402 .49961 Mtetra
.474 .469 .772 r
.33186 .80073 .31795 .77745 .30472 .78751 .31853 .81064 Mtetra
.34537 .79068 .33136 .76725 .31795 .77745 .33186 .80073 Mtetra
.35908 .78049 .34495 .75691 .33136 .76725 .34537 .79068 Mtetra
.37297 .77016 .35874 .74642 .34495 .75691 .35908 .78049 Mtetra
.38706 .75968 .37272 .73578 .35874 .74642 .37297 .77016 Mtetra
.40135 .74906 .38689 .725 .37272 .73578 .38706 .75968 Mtetra
.41584 .73828 .40127 .71406 .38689 .725 .40135 .74906 Mtetra
.43054 .72735 .41586 .70296 .40127 .71406 .41584 .73828 Mtetra
.44546 .71626 .43065 .6917 .41586 .70296 .43054 .72735 Mtetra
.46059 .70501 .44567 .68028 .43065 .6917 .44546 .71626 Mtetra
.47595 .69359 .4609 .66869 .44567 .68028 .46059 .70501 Mtetra
.49153 .682 .47636 .65693 .4609 .66869 .47595 .69359 Mtetra
.50734 .67024 .49204 .64499 .47636 .65693 .49153 .682 Mtetra
.5234 .65831 .50797 .63287 .49204 .64499 .50734 .67024 Mtetra
.53969 .64619 .52413 .62058 .50797 .63287 .5234 .65831 Mtetra
.55624 .63389 .54055 .60809 .52413 .62058 .53969 .64619 Mtetra
.57303 .62139 .55721 .59541 .54055 .60809 .55624 .63389 Mtetra
.59009 .60871 .57413 .58253 .55721 .59541 .57303 .62139 Mtetra
.60742 .59583 .59132 .56946 .57413 .58253 .59009 .60871 Mtetra
.62502 .58274 .60878 .55618 .59132 .56946 .60742 .59583 Mtetra
.6429 .56945 .62651 .54268 .60878 .55618 .62502 .58274 Mtetra
.66106 .55594 .64453 .52897 .62651 .54268 .6429 .56945 Mtetra
.67952 .54222 .66283 .51505 .64453 .52897 .66106 .55594 Mtetra
.69827 .52827 .68144 .50089 .66283 .51505 .67952 .54222 Mtetra
.71734 .51409 .70035 .4865 .68144 .50089 .69827 .52827 Mtetra
.73672 .49968 .71957 .47188 .70035 .4865 .71734 .51409 Mtetra
.75642 .48503 .73911 .45701 .71957 .47188 .73672 .49968 Mtetra
.77645 .47014 .75898 .44189 .73911 .45701 .75642 .48503 Mtetra
.79682 .45499 .77919 .42652 .75898 .44189 .77645 .47014 Mtetra
.478 .477 .778 r
.31795 .77745 .30404 .75508 .29092 .76529 .30472 .78751 Mtetra
.33136 .76725 .31734 .74473 .30404 .75508 .31795 .77745 Mtetra
.34495 .75691 .33083 .73423 .31734 .74473 .33136 .76725 Mtetra
.35874 .74642 .34451 .72359 .33083 .73423 .34495 .75691 Mtetra
.37272 .73578 .35838 .7128 .34451 .72359 .35874 .74642 Mtetra
.38689 .725 .37244 .70186 .35838 .7128 .37272 .73578 Mtetra
.40127 .71406 .38671 .69076 .37244 .70186 .38689 .725 Mtetra
.41586 .70296 .40118 .67951 .38671 .69076 .40127 .71406 Mtetra
.43065 .6917 .41586 .66809 .40118 .67951 .41586 .70296 Mtetra
.44567 .68028 .43076 .6565 .41586 .66809 .43065 .6917 Mtetra
.4609 .66869 .44587 .64474 .43076 .6565 .44567 .68028 Mtetra
.47636 .65693 .46121 .63281 .44587 .64474 .4609 .66869 Mtetra
.49204 .64499 .47677 .6207 .46121 .63281 .47636 .65693 Mtetra
.50797 .63287 .49257 .60841 .47677 .6207 .49204 .64499 Mtetra
.52413 .62058 .50861 .59594 .49257 .60841 .50797 .63287 Mtetra
.54055 .60809 .52489 .58327 .50861 .59594 .52413 .62058 Mtetra
.55721 .59541 .54143 .57041 .52489 .58327 .54055 .60809 Mtetra
.57413 .58253 .55822 .55735 .54143 .57041 .55721 .59541 Mtetra
.59132 .56946 .57527 .54409 .55822 .55735 .57413 .58253 Mtetra
.60878 .55618 .59258 .53061 .57527 .54409 .59132 .56946 Mtetra
.62651 .54268 .61018 .51693 .59258 .53061 .60878 .55618 Mtetra
.64453 .52897 .62805 .50302 .61018 .51693 .62651 .54268 Mtetra
.66283 .51505 .64621 .4889 .62805 .50302 .64453 .52897 Mtetra
.68144 .50089 .66467 .47454 .64621 .4889 .66283 .51505 Mtetra
.70035 .4865 .68343 .45995 .66467 .47454 .68144 .50089 Mtetra
.71957 .47188 .70249 .44511 .68343 .45995 .70035 .4865 Mtetra
.73911 .45701 .72188 .43003 .70249 .44511 .71957 .47188 Mtetra
.75898 .44189 .74159 .4147 .72188 .43003 .73911 .45701 Mtetra
.77919 .42652 .76163 .39911 .74159 .4147 .75898 .44189 Mtetra
.482 .484 .783 r
.30404 .75508 .29012 .73348 .2771 .74384 .29092 .76529 Mtetra
.31734 .74473 .30332 .72299 .29012 .73348 .30404 .75508 Mtetra
.33083 .73423 .31671 .71235 .30332 .72299 .31734 .74473 Mtetra
.34451 .72359 .33028 .70157 .31671 .71235 .33083 .73423 Mtetra
.35838 .7128 .34404 .69063 .33028 .70157 .34451 .72359 Mtetra
.37244 .70186 .358 .67953 .34404 .69063 .35838 .7128 Mtetra
.38671 .69076 .37216 .66828 .358 .67953 .37244 .70186 Mtetra
.40118 .67951 .38652 .65687 .37216 .66828 .38671 .69076 Mtetra
.41586 .66809 .40109 .64529 .38652 .65687 .40118 .67951 Mtetra
.43076 .6565 .41586 .63354 .40109 .64529 .41586 .66809 Mtetra
.44587 .64474 .43086 .62162 .41586 .63354 .43076 .6565 Mtetra
.46121 .63281 .44608 .60953 .43086 .62162 .44587 .64474 Mtetra
.47677 .6207 .46152 .59725 .44608 .60953 .46121 .63281 Mtetra
.49257 .60841 .4772 .58479 .46152 .59725 .47677 .6207 Mtetra
.50861 .59594 .49311 .57214 .4772 .58479 .49257 .60841 Mtetra
.52489 .58327 .50927 .5593 .49311 .57214 .50861 .59594 Mtetra
.54143 .57041 .52567 .54627 .50927 .5593 .52489 .58327 Mtetra
.55822 .55735 .54233 .53303 .52567 .54627 .54143 .57041 Mtetra
.57527 .54409 .55925 .51958 .54233 .53303 .55822 .55735 Mtetra
.59258 .53061 .57643 .50592 .55925 .51958 .57527 .54409 Mtetra
.61018 .51693 .59389 .49205 .57643 .50592 .59258 .53061 Mtetra
.62805 .50302 .61162 .47795 .59389 .49205 .61018 .51693 Mtetra
.64621 .4889 .62964 .46363 .61162 .47795 .62805 .50302 Mtetra
.66467 .47454 .64795 .44908 .62964 .46363 .64621 .4889 Mtetra
.68343 .45995 .66656 .43429 .64795 .44908 .66467 .47454 Mtetra
.70249 .44511 .68548 .41925 .66656 .43429 .68343 .45995 Mtetra
.72188 .43003 .70471 .40396 .68548 .41925 .70249 .44511 Mtetra
.74159 .4147 .72427 .38842 .70471 .40396 .72188 .43003 Mtetra
.76163 .39911 .74415 .37262 .72427 .38842 .74159 .4147 Mtetra
.486 .49 .787 r
.29012 .73348 .2762 .71258 .26327 .72307 .2771 .74384 Mtetra
.30332 .72299 .2893 .70195 .2762 .71258 .29012 .73348 Mtetra
.31671 .71235 .30258 .69117 .2893 .70195 .30332 .72299 Mtetra
.33028 .70157 .31605 .68024 .30258 .69117 .31671 .71235 Mtetra
.34404 .69063 .32971 .66915 .31605 .68024 .33028 .70157 Mtetra
.358 .67953 .34356 .65791 .32971 .66915 .34404 .69063 Mtetra
.37216 .66828 .35761 .64651 .34356 .65791 .358 .67953 Mtetra
.38652 .65687 .37186 .63494 .35761 .64651 .37216 .66828 Mtetra
.40109 .64529 .38631 .62321 .37186 .63494 .38652 .65687 Mtetra
.41586 .63354 .40098 .61131 .38631 .62321 .40109 .64529 Mtetra
.43086 .62162 .41586 .59923 .40098 .61131 .41586 .63354 Mtetra
.44608 .60953 .43096 .58698 .41586 .59923 .43086 .62162 Mtetra
.46152 .59725 .44629 .57454 .43096 .58698 .44608 .60953 Mtetra
.4772 .58479 .46184 .56191 .44629 .57454 .46152 .59725 Mtetra
.49311 .57214 .47763 .5491 .46184 .56191 .4772 .58479 Mtetra
.50927 .5593 .49367 .53608 .47763 .5491 .49311 .57214 Mtetra
.52567 .54627 .50994 .52287 .49367 .53608 .50927 .5593 Mtetra
.54233 .53303 .52647 .50946 .50994 .52287 .52567 .54627 Mtetra
.55925 .51958 .54326 .49583 .52647 .50946 .54233 .53303 Mtetra
.57643 .50592 .56031 .482 .54326 .49583 .55925 .51958 Mtetra
.59389 .49205 .57763 .46794 .56031 .482 .57643 .50592 Mtetra
.61162 .47795 .59523 .45366 .57763 .46794 .59389 .49205 Mtetra
.62964 .46363 .61311 .43915 .59523 .45366 .61162 .47795 Mtetra
.64795 .44908 .63127 .4244 .61311 .43915 .62964 .46363 Mtetra
.66656 .43429 .64974 .40941 .63127 .4244 .64795 .44908 Mtetra
.68548 .41925 .66851 .39418 .64974 .40941 .66656 .43429 Mtetra
.70471 .40396 .68759 .37869 .66851 .39418 .68548 .41925 Mtetra
.72427 .38842 .707 .36295 .68759 .37869 .70471 .40396 Mtetra
.74415 .37262 .72673 .34693 .707 .36295 .72427 .38842 Mtetra
.489 .496 .791 r
.2762 .71258 .26226 .69229 .24944 .70291 .26327 .72307 Mtetra
.2893 .70195 .27527 .68152 .26226 .69229 .2762 .71258 Mtetra
.30258 .69117 .28845 .6706 .27527 .68152 .2893 .70195 Mtetra
.31605 .68024 .30181 .65953 .28845 .6706 .30258 .69117 Mtetra
.32971 .66915 .31537 .6483 .30181 .65953 .31605 .68024 Mtetra
.34356 .65791 .32911 .63692 .31537 .6483 .32971 .66915 Mtetra
.35761 .64651 .34306 .62537 .32911 .63692 .34356 .65791 Mtetra
.37186 .63494 .3572 .61365 .34306 .62537 .35761 .64651 Mtetra
.38631 .62321 .37154 .60177 .3572 .61365 .37186 .63494 Mtetra
.40098 .61131 .3861 .58972 .37154 .60177 .38631 .62321 Mtetra
.41586 .59923 .40087 .57748 .3861 .58972 .40098 .61131 Mtetra
.43096 .58698 .41585 .56507 .40087 .57748 .41586 .59923 Mtetra
.44629 .57454 .43106 .55247 .41585 .56507 .43096 .58698 Mtetra
.46184 .56191 .4465 .53968 .43106 .55247 .44629 .57454 Mtetra
.47763 .5491 .46217 .5267 .4465 .53968 .46184 .56191 Mtetra
.49367 .53608 .47808 .51353 .46217 .5267 .47763 .5491 Mtetra
.50994 .52287 .49423 .50015 .47808 .51353 .49367 .53608 Mtetra
.52647 .50946 .51063 .48656 .49423 .50015 .50994 .52287 Mtetra
.54326 .49583 .52729 .47276 .51063 .48656 .52647 .50946 Mtetra
.56031 .482 .54421 .45875 .52729 .47276 .54326 .49583 Mtetra
.57763 .46794 .5614 .44451 .54421 .45875 .56031 .482 Mtetra
.59523 .45366 .57886 .43005 .5614 .44451 .57763 .46794 Mtetra
.61311 .43915 .5966 .41535 .57886 .43005 .59523 .45366 Mtetra
.63127 .4244 .61463 .40042 .5966 .41535 .61311 .43915 Mtetra
.64974 .40941 .63296 .38524 .61463 .40042 .63127 .4244 Mtetra
.66851 .39418 .65158 .36981 .63296 .38524 .64974 .40941 Mtetra
.68759 .37869 .67052 .35412 .65158 .36981 .66851 .39418 Mtetra
.707 .36295 .68977 .33818 .67052 .35412 .68759 .37869 Mtetra
.72673 .34693 .70935 .32196 .68977 .33818 .707 .36295 Mtetra
.492 .502 .795 r
.26226 .69229 .24832 .67254 .23559 .6833 .24944 .70291 Mtetra
.27527 .68152 .26122 .66164 .24832 .67254 .26226 .69229 Mtetra
.28845 .6706 .2743 .65058 .26122 .66164 .27527 .68152 Mtetra
.30181 .65953 .28757 .63937 .2743 .65058 .28845 .6706 Mtetra
.31537 .6483 .30102 .62801 .28757 .63937 .30181 .65953 Mtetra
.32911 .63692 .31466 .61648 .30102 .62801 .31537 .6483 Mtetra
.34306 .62537 .3285 .60479 .31466 .61648 .32911 .63692 Mtetra
.3572 .61365 .34253 .59293 .3285 .60479 .34306 .62537 Mtetra
.37154 .60177 .35677 .5809 .34253 .59293 .3572 .61365 Mtetra
.3861 .58972 .37121 .56869 .35677 .5809 .37154 .60177 Mtetra
.40087 .57748 .38587 .55631 .37121 .56869 .3861 .58972 Mtetra
.41585 .56507 .40074 .54374 .38587 .55631 .40087 .57748 Mtetra
.43106 .55247 .41584 .53099 .40074 .54374 .41585 .56507 Mtetra
.4465 .53968 .43116 .51804 .41584 .53099 .43106 .55247 Mtetra
.46217 .5267 .44671 .5049 .43116 .51804 .4465 .53968 Mtetra
.47808 .51353 .4625 .49156 .44671 .5049 .46217 .5267 Mtetra
.49423 .50015 .47853 .47801 .4625 .49156 .47808 .51353 Mtetra
.51063 .48656 .49481 .46426 .47853 .47801 .49423 .50015 Mtetra
.52729 .47276 .51134 .45029 .49481 .46426 .51063 .48656 Mtetra
.54421 .45875 .52813 .4361 .51134 .45029 .52729 .47276 Mtetra
.5614 .44451 .54519 .42169 .52813 .4361 .54421 .45875 Mtetra
.57886 .43005 .56251 .40705 .54519 .42169 .5614 .44451 Mtetra
.5966 .41535 .58012 .39217 .56251 .40705 .57886 .43005 Mtetra
.61463 .40042 .59801 .37705 .58012 .39217 .5966 .41535 Mtetra
.63296 .38524 .6162 .36168 .59801 .37705 .61463 .40042 Mtetra
.65158 .36981 .63468 .34606 .6162 .36168 .63296 .38524 Mtetra
.67052 .35412 .65347 .33019 .63468 .34606 .65158 .36981 Mtetra
.68977 .33818 .67258 .31404 .65347 .33019 .67052 .35412 Mtetra
.70935 .32196 .69201 .29762 .67258 .31404 .68977 .33818 Mtetra
.495 .507 .799 r
.24832 .67254 .23436 .65329 .22172 .66417 .23559 .6833 Mtetra
.26122 .66164 .24716 .64225 .23436 .65329 .24832 .67254 Mtetra
.2743 .65058 .26015 .63106 .24716 .64225 .26122 .66164 Mtetra
.28757 .63937 .27331 .61972 .26015 .63106 .2743 .65058 Mtetra
.30102 .62801 .28666 .60821 .27331 .61972 .28757 .63937 Mtetra
.31466 .61648 .3002 .59655 .28666 .60821 .30102 .62801 Mtetra
.3285 .60479 .31393 .58472 .3002 .59655 .31466 .61648 Mtetra
.34253 .59293 .32786 .57271 .31393 .58472 .3285 .60479 Mtetra
.35677 .5809 .34199 .56054 .32786 .57271 .34253 .59293 Mtetra
.37121 .56869 .35633 .54819 .34199 .56054 .35677 .5809 Mtetra
.38587 .55631 .37087 .53565 .35633 .54819 .37121 .56869 Mtetra
.40074 .54374 .38563 .52293 .37087 .53565 .38587 .55631 Mtetra
.41584 .53099 .40061 .51003 .38563 .52293 .40074 .54374 Mtetra
.43116 .51804 .41582 .49693 .40061 .51003 .41584 .53099 Mtetra
.44671 .5049 .43125 .48363 .41582 .49693 .43116 .51804 Mtetra
.4625 .49156 .44692 .47012 .43125 .48363 .44671 .5049 Mtetra
.47853 .47801 .46283 .45642 .44692 .47012 .4625 .49156 Mtetra
.49481 .46426 .47899 .4425 .46283 .45642 .47853 .47801 Mtetra
.51134 .45029 .49539 .42836 .47899 .4425 .49481 .46426 Mtetra
.52813 .4361 .51206 .414 .49539 .42836 .51134 .45029 Mtetra
.54519 .42169 .52899 .39941 .51206 .414 .52813 .4361 Mtetra
.56251 .40705 .54618 .38459 .52899 .39941 .54519 .42169 Mtetra
.58012 .39217 .56366 .36954 .54618 .38459 .56251 .40705 Mtetra
.59801 .37705 .58141 .35424 .56366 .36954 .58012 .39217 Mtetra
.6162 .36168 .59946 .33869 .58141 .35424 .59801 .37705 Mtetra
.63468 .34606 .61781 .32288 .59946 .33869 .6162 .36168 Mtetra
.65347 .33019 .63646 .30681 .61781 .32288 .63468 .34606 Mtetra
.67258 .31404 .65542 .29047 .63646 .30681 .65347 .33019 Mtetra
.69201 .29762 .6747 .27386 .65542 .29047 .67258 .31404 Mtetra
.498 .512 .802 r
.23436 .65329 .22038 .63447 .20784 .64549 .22172 .66417 Mtetra
.24716 .64225 .23309 .62331 .22038 .63447 .23436 .65329 Mtetra
.26015 .63106 .24598 .61199 .23309 .62331 .24716 .64225 Mtetra
.27331 .61972 .25904 .60051 .24598 .61199 .26015 .63106 Mtetra
.28666 .60821 .27229 .58887 .25904 .60051 .27331 .61972 Mtetra
.3002 .59655 .28573 .57707 .27229 .58887 .28666 .60821 Mtetra
.31393 .58472 .29936 .5651 .28573 .57707 .3002 .59655 Mtetra
.32786 .57271 .31318 .55296 .29936 .5651 .31393 .58472 Mtetra
.34199 .56054 .32721 .54064 .31318 .55296 .32786 .57271 Mtetra
.35633 .54819 .34143 .52814 .32721 .54064 .34199 .56054 Mtetra
.37087 .53565 .35587 .51546 .34143 .52814 .35633 .54819 Mtetra
.38563 .52293 .37052 .5026 .35587 .51546 .37087 .53565 Mtetra
.40061 .51003 .38539 .48954 .37052 .5026 .38563 .52293 Mtetra
.41582 .49693 .40048 .47628 .38539 .48954 .40061 .51003 Mtetra
.43125 .48363 .4158 .46283 .40048 .47628 .41582 .49693 Mtetra
.44692 .47012 .43135 .44917 .4158 .46283 .43125 .48363 Mtetra
.46283 .45642 .44714 .4353 .43135 .44917 .44692 .47012 Mtetra
.47899 .4425 .46317 .42122 .44714 .4353 .46283 .45642 Mtetra
.49539 .42836 .47945 .40691 .46317 .42122 .47899 .4425 Mtetra
.51206 .414 .49599 .39239 .47945 .40691 .49539 .42836 Mtetra
.52899 .39941 .51279 .37763 .49599 .39239 .51206 .414 Mtetra
.54618 .38459 .52986 .36264 .51279 .37763 .52899 .39941 Mtetra
.56366 .36954 .5472 .3474 .52986 .36264 .54618 .38459 Mtetra
.58141 .35424 .56483 .33192 .5472 .3474 .56366 .36954 Mtetra
.59946 .33869 .58274 .31619 .56483 .33192 .58141 .35424 Mtetra
.61781 .32288 .60095 .3002 .58274 .31619 .59946 .33869 Mtetra
.63646 .30681 .61945 .28394 .60095 .3002 .61781 .32288 Mtetra
.65542 .29047 .63827 .26741 .61945 .28394 .63646 .30681 Mtetra
.6747 .27386 .65741 .2506 .63827 .26741 .65542 .29047 Mtetra
.501 .517 .805 r
.22038 .63447 .20639 .61606 .19394 .6272 .20784 .64549 Mtetra
.23309 .62331 .219 .60477 .20639 .61606 .22038 .63447 Mtetra
.24598 .61199 .23179 .59332 .219 .60477 .23309 .62331 Mtetra
.25904 .60051 .24476 .58172 .23179 .59332 .24598 .61199 Mtetra
.27229 .58887 .25791 .56994 .24476 .58172 .25904 .60051 Mtetra
.28573 .57707 .27125 .55801 .25791 .56994 .27229 .58887 Mtetra
.29936 .5651 .28477 .5459 .27125 .55801 .28573 .57707 Mtetra
.31318 .55296 .29849 .53362 .28477 .5459 .29936 .5651 Mtetra
.32721 .54064 .31241 .52116 .29849 .53362 .31318 .55296 Mtetra
.34143 .52814 .32653 .50852 .31241 .52116 .32721 .54064 Mtetra
.35587 .51546 .34086 .4957 .32653 .50852 .34143 .52814 Mtetra
.37052 .5026 .3554 .48268 .34086 .4957 .35587 .51546 Mtetra
.38539 .48954 .37015 .46948 .3554 .48268 .37052 .5026 Mtetra
.40048 .47628 .38513 .45607 .37015 .46948 .38539 .48954 Mtetra
.4158 .46283 .40033 .44246 .38513 .45607 .40048 .47628 Mtetra
.43135 .44917 .41577 .42865 .40033 .44246 .4158 .46283 Mtetra
.44714 .4353 .43144 .41462 .41577 .42865 .43135 .44917 Mtetra
.46317 .42122 .44735 .40037 .43144 .41462 .44714 .4353 Mtetra
.47945 .40691 .46351 .38591 .44735 .40037 .46317 .42122 Mtetra
.49599 .39239 .47993 .37122 .46351 .38591 .47945 .40691 Mtetra
.51279 .37763 .4966 .35629 .47993 .37122 .49599 .39239 Mtetra
.52986 .36264 .51354 .34113 .4966 .35629 .51279 .37763 Mtetra
.5472 .3474 .53076 .32572 .51354 .34113 .52986 .36264 Mtetra
.56483 .33192 .54825 .31006 .53076 .32572 .5472 .3474 Mtetra
.58274 .31619 .56603 .29415 .54825 .31006 .56483 .33192 Mtetra
.60095 .3002 .5841 .27798 .56603 .29415 .58274 .31619 Mtetra
.61945 .28394 .60247 .26153 .5841 .27798 .60095 .3002 Mtetra
.63827 .26741 .62114 .24482 .60247 .26153 .61945 .28394 Mtetra
.65741 .2506 .64014 .22781 .62114 .24482 .63827 .26741 Mtetra
.503 .521 .808 r
.20639 .61606 .19238 .59802 .18003 .60928 .19394 .6272 Mtetra
.219 .60477 .2049 .5866 .19238 .59802 .20639 .61606 Mtetra
.23179 .59332 .21759 .57503 .2049 .5866 .219 .60477 Mtetra
.24476 .58172 .23046 .56329 .21759 .57503 .23179 .59332 Mtetra
.25791 .56994 .24351 .55139 .23046 .56329 .24476 .58172 Mtetra
.27125 .55801 .25675 .53932 .24351 .55139 .25791 .56994 Mtetra
.28477 .5459 .27017 .52708 .25675 .53932 .27125 .55801 Mtetra
.29849 .53362 .28379 .51466 .27017 .52708 .28477 .5459 Mtetra
.31241 .52116 .2976 .50207 .28379 .51466 .29849 .53362 Mtetra
.32653 .50852 .31162 .48929 .2976 .50207 .31241 .52116 Mtetra
.34086 .4957 .32584 .47632 .31162 .48929 .32653 .50852 Mtetra
.3554 .48268 .34027 .46316 .32584 .47632 .34086 .4957 Mtetra
.37015 .46948 .35491 .4498 .34027 .46316 .3554 .48268 Mtetra
.38513 .45607 .36978 .43625 .35491 .4498 .37015 .46948 Mtetra
.40033 .44246 .38487 .42249 .36978 .43625 .38513 .45607 Mtetra
.41577 .42865 .40019 .40852 .38487 .42249 .40033 .44246 Mtetra
.43144 .41462 .41574 .39434 .40019 .40852 .41577 .42865 Mtetra
.44735 .40037 .43153 .37993 .41574 .39434 .43144 .41462 Mtetra
.46351 .38591 .44757 .36531 .43153 .37993 .44735 .40037 Mtetra
.47993 .37122 .46387 .35045 .44757 .36531 .46351 .38591 Mtetra
.4966 .35629 .48041 .33536 .46387 .35045 .47993 .37122 Mtetra
.51354 .34113 .49723 .32003 .48041 .33536 .4966 .35629 Mtetra
.53076 .32572 .51431 .30445 .49723 .32003 .51354 .34113 Mtetra
.54825 .31006 .53167 .28862 .51431 .30445 .53076 .32572 Mtetra
.56603 .29415 .54932 .27253 .53167 .28862 .54825 .31006 Mtetra
.5841 .27798 .56725 .25617 .54932 .27253 .56603 .29415 Mtetra
.60247 .26153 .58549 .23955 .56725 .25617 .5841 .27798 Mtetra
.62114 .24482 .60402 .22264 .58549 .23955 .60247 .26153 Mtetra
.64014 .22781 .62288 .20545 .60402 .22264 .62114 .24482 Mtetra
.506 .526 .811 r
.19238 .59802 .17834 .58032 .16609 .5917 .18003 .60928 Mtetra
.2049 .5866 .19077 .56878 .17834 .58032 .19238 .59802 Mtetra
.21759 .57503 .20337 .55708 .19077 .56878 .2049 .5866 Mtetra
.23046 .56329 .21614 .54521 .20337 .55708 .21759 .57503 Mtetra
.24351 .55139 .22909 .53318 .21614 .54521 .23046 .56329 Mtetra
.25675 .53932 .24223 .52098 .22909 .53318 .24351 .55139 Mtetra
.27017 .52708 .25555 .50861 .24223 .52098 .25675 .53932 Mtetra
.28379 .51466 .26907 .49605 .25555 .50861 .27017 .52708 Mtetra
.2976 .50207 .28278 .48332 .26907 .49605 .28379 .51466 Mtetra
.31162 .48929 .29669 .4704 .28278 .48332 .2976 .50207 Mtetra
.32584 .47632 .3108 .45729 .29669 .4704 .31162 .48929 Mtetra
.34027 .46316 .32512 .44399 .3108 .45729 .32584 .47632 Mtetra
.35491 .4498 .33966 .43049 .32512 .44399 .34027 .46316 Mtetra
.36978 .43625 .35441 .41679 .33966 .43049 .35491 .4498 Mtetra
.38487 .42249 .36939 .40288 .35441 .41679 .36978 .43625 Mtetra
.40019 .40852 .38459 .38876 .36939 .40288 .38487 .42249 Mtetra
.41574 .39434 .40003 .37442 .38459 .38876 .40019 .40852 Mtetra
.43153 .37993 .41571 .35986 .40003 .37442 .41574 .39434 Mtetra
.44757 .36531 .43163 .34507 .41571 .35986 .43153 .37993 Mtetra
.46387 .35045 .4478 .33006 .43163 .34507 .44757 .36531 Mtetra
.48041 .33536 .46422 .3148 .4478 .33006 .46387 .35045 Mtetra
.49723 .32003 .48091 .2993 .46422 .3148 .48041 .33536 Mtetra
.51431 .30445 .49787 .28355 .48091 .2993 .49723 .32003 Mtetra
.53167 .28862 .5151 .26755 .49787 .28355 .51431 .30445 Mtetra
.54932 .27253 .53261 .25128 .5151 .26755 .53167 .28862 Mtetra
.56725 .25617 .55041 .23475 .53261 .25128 .54932 .27253 Mtetra
.58549 .23955 .56851 .21794 .55041 .23475 .56725 .25617 Mtetra
.60402 .22264 .58691 .20085 .56851 .21794 .58549 .23955 Mtetra
.62288 .20545 .60562 .18347 .58691 .20085 .60402 .22264 Mtetra
.508 .53 .814 r
.17834 .58032 .16429 .56292 .15213 .57443 .16609 .5917 Mtetra
.19077 .56878 .17662 .55126 .16429 .56292 .17834 .58032 Mtetra
.20337 .55708 .18913 .53944 .17662 .55126 .19077 .56878 Mtetra
.21614 .54521 .2018 .52745 .18913 .53944 .20337 .55708 Mtetra
.22909 .53318 .21466 .51529 .2018 .52745 .21614 .54521 Mtetra
.24223 .52098 .2277 .50296 .21466 .51529 .22909 .53318 Mtetra
.25555 .50861 .24092 .49045 .2277 .50296 .24223 .52098 Mtetra
.26907 .49605 .25433 .47777 .24092 .49045 .25555 .50861 Mtetra
.28278 .48332 .26794 .4649 .25433 .47777 .26907 .49605 Mtetra
.29669 .4704 .28174 .45184 .26794 .4649 .28278 .48332 Mtetra
.3108 .45729 .29575 .43859 .28174 .45184 .29669 .4704 Mtetra
.32512 .44399 .30996 .42515 .29575 .43859 .3108 .45729 Mtetra
.33966 .43049 .32439 .41151 .30996 .42515 .32512 .44399 Mtetra
.35441 .41679 .33903 .39766 .32439 .41151 .33966 .43049 Mtetra
.36939 .40288 .3539 .3836 .33903 .39766 .35441 .41679 Mtetra
.38459 .38876 .36899 .36933 .3539 .3836 .36939 .40288 Mtetra
.40003 .37442 .38431 .35484 .36899 .36933 .38459 .38876 Mtetra
.41571 .35986 .39987 .34012 .38431 .35484 .40003 .37442 Mtetra
.43163 .34507 .41567 .32518 .39987 .34012 .41571 .35986 Mtetra
.4478 .33006 .43172 .31 .41567 .32518 .43163 .34507 Mtetra
.46422 .3148 .44802 .29458 .43172 .31 .4478 .33006 Mtetra
.48091 .2993 .46458 .27892 .44802 .29458 .46422 .3148 Mtetra
.49787 .28355 .48141 .263 .46458 .27892 .48091 .2993 Mtetra
.5151 .26755 .49852 .24683 .48141 .263 .49787 .28355 Mtetra
.53261 .25128 .5159 .23039 .49852 .24683 .5151 .26755 Mtetra
.55041 .23475 .53357 .21368 .5159 .23039 .53261 .25128 Mtetra
.56851 .21794 .55153 .19669 .53357 .21368 .55041 .23475 Mtetra
.58691 .20085 .56979 .17942 .55153 .19669 .56851 .21794 Mtetra
.60562 .18347 .58836 .16185 .56979 .17942 .58691 .20085 Mtetra
.51 .533 .816 r
.16429 .56292 .15021 .54582 .13814 .55744 .15213 .57443 Mtetra
.17662 .55126 .16245 .53403 .15021 .54582 .16429 .56292 Mtetra
.18913 .53944 .17486 .52209 .16245 .53403 .17662 .55126 Mtetra
.2018 .52745 .18744 .50997 .17486 .52209 .18913 .53944 Mtetra
.21466 .51529 .2002 .49769 .18744 .50997 .2018 .52745 Mtetra
.2277 .50296 .21314 .48523 .2002 .49769 .21466 .51529 Mtetra
.24092 .49045 .22626 .47259 .21314 .48523 .2277 .50296 Mtetra
.25433 .47777 .23957 .45977 .22626 .47259 .24092 .49045 Mtetra
.26794 .4649 .25308 .44677 .23957 .45977 .25433 .47777 Mtetra
.28174 .45184 .26678 .43358 .25308 .44677 .26794 .4649 Mtetra
.29575 .43859 .28068 .42019 .26678 .43358 .28174 .45184 Mtetra
.30996 .42515 .29479 .40661 .28068 .42019 .29575 .43859 Mtetra
.32439 .41151 .30911 .39282 .29479 .40661 .30996 .42515 Mtetra
.33903 .39766 .32364 .37883 .30911 .39282 .32439 .41151 Mtetra
.3539 .3836 .33839 .36463 .32364 .37883 .33903 .39766 Mtetra
.36899 .36933 .35337 .35021 .33839 .36463 .3539 .3836 Mtetra
.38431 .35484 .36857 .33557 .35337 .35021 .36899 .36933 Mtetra
.39987 .34012 .38402 .3207 .36857 .33557 .38431 .35484 Mtetra
.41567 .32518 .3997 .3056 .38402 .3207 .39987 .34012 Mtetra
.43172 .31 .41563 .29026 .3997 .3056 .41567 .32518 Mtetra
.44802 .29458 .43181 .27468 .41563 .29026 .43172 .31 Mtetra
.46458 .27892 .44825 .25885 .43181 .27468 .44802 .29458 Mtetra
.48141 .263 .46495 .24277 .44825 .25885 .46458 .27892 Mtetra
.49852 .24683 .48193 .22642 .46495 .24277 .48141 .263 Mtetra
.5159 .23039 .49918 .20981 .48193 .22642 .49852 .24683 Mtetra
.53357 .21368 .51671 .19293 .49918 .20981 .5159 .23039 Mtetra
.55153 .19669 .53454 .17576 .51671 .19293 .53357 .21368 Mtetra
.56979 .17942 .55267 .1583 .53454 .17576 .55153 .19669 Mtetra
.58836 .16185 .5711 .14056 .55267 .1583 .56979 .17942 Mtetra
.513 .537 .818 r
.15021 .54582 .13611 .52898 .12413 .54072 .13814 .55744 Mtetra
.16245 .53403 .14826 .51707 .13611 .52898 .15021 .54582 Mtetra
.17486 .52209 .16057 .505 .14826 .51707 .16245 .53403 Mtetra
.18744 .50997 .17306 .49276 .16057 .505 .17486 .52209 Mtetra
.2002 .49769 .18572 .48035 .17306 .49276 .18744 .50997 Mtetra
.21314 .48523 .19856 .46777 .18572 .48035 .2002 .49769 Mtetra
.22626 .47259 .21159 .455 .19856 .46777 .21314 .48523 Mtetra
.23957 .45977 .2248 .44206 .21159 .455 .22626 .47259 Mtetra
.25308 .44677 .2382 .42892 .2248 .44206 .23957 .45977 Mtetra
.26678 .43358 .2518 .41559 .2382 .42892 .25308 .44677 Mtetra
.28068 .42019 .26559 .40207 .2518 .41559 .26678 .43358 Mtetra
.29479 .40661 .27959 .38835 .26559 .40207 .28068 .42019 Mtetra
.30911 .39282 .2938 .37442 .27959 .38835 .29479 .40661 Mtetra
.32364 .37883 .30823 .36029 .2938 .37442 .30911 .39282 Mtetra
.33839 .36463 .32287 .34594 .30823 .36029 .32364 .37883 Mtetra
.35337 .35021 .33773 .33137 .32287 .34594 .33839 .36463 Mtetra
.36857 .33557 .35282 .31658 .33773 .33137 .35337 .35021 Mtetra
.38402 .3207 .36815 .30156 .35282 .31658 .36857 .33557 Mtetra
.3997 .3056 .38371 .2863 .36815 .30156 .38402 .3207 Mtetra
.41563 .29026 .39952 .27081 .38371 .2863 .3997 .3056 Mtetra
.43181 .27468 .41558 .25507 .39952 .27081 .41563 .29026 Mtetra
.44825 .25885 .4319 .23907 .41558 .25507 .43181 .27468 Mtetra
.46495 .24277 .44848 .22282 .4319 .23907 .44825 .25885 Mtetra
.48193 .22642 .46533 .20631 .44848 .22282 .46495 .24277 Mtetra
.49918 .20981 .48245 .18953 .46533 .20631 .48193 .22642 Mtetra
.51671 .19293 .49985 .17247 .48245 .18953 .49918 .20981 Mtetra
.53454 .17576 .51755 .15513 .49985 .17247 .51671 .19293 Mtetra
.55267 .1583 .53554 .13749 .51755 .15513 .53454 .17576 Mtetra
.5711 .14056 .55384 .11956 .53554 .13749 .55267 .1583 Mtetra
.515 .54 .82 r
.13611 .52898 .12199 .51238 .1101 .52424 .12413 .54072 Mtetra
.14826 .51707 .13404 .50036 .12199 .51238 .13611 .52898 Mtetra
.16057 .505 .14626 .48817 .13404 .50036 .14826 .51707 Mtetra
.17306 .49276 .15865 .47581 .14626 .48817 .16057 .505 Mtetra
.18572 .48035 .17122 .46327 .15865 .47581 .17306 .49276 Mtetra
.19856 .46777 .18396 .45056 .17122 .46327 .18572 .48035 Mtetra
.21159 .455 .19689 .43767 .18396 .45056 .19856 .46777 Mtetra
.2248 .44206 .21 .42459 .19689 .43767 .21159 .455 Mtetra
.2382 .42892 .2233 .41132 .21 .42459 .2248 .44206 Mtetra
.2518 .41559 .23679 .39786 .2233 .41132 .2382 .42892 Mtetra
.26559 .40207 .25049 .38421 .23679 .39786 .2518 .41559 Mtetra
.27959 .38835 .26438 .37035 .25049 .38421 .26559 .40207 Mtetra
.2938 .37442 .27848 .35628 .26438 .37035 .27959 .38835 Mtetra
.30823 .36029 .2928 .342 .27848 .35628 .2938 .37442 Mtetra
.32287 .34594 .30733 .32751 .2928 .342 .30823 .36029 Mtetra
.33773 .33137 .32208 .31279 .30733 .32751 .32287 .34594 Mtetra
.35282 .31658 .33706 .29785 .32208 .31279 .33773 .33137 Mtetra
.36815 .30156 .35227 .28268 .33706 .29785 .35282 .31658 Mtetra
.38371 .2863 .36771 .26727 .35227 .28268 .36815 .30156 Mtetra
.39952 .27081 .3834 .25162 .36771 .26727 .38371 .2863 Mtetra
.41558 .25507 .39934 .23572 .3834 .25162 .39952 .27081 Mtetra
.4319 .23907 .41554 .21957 .39934 .23572 .41558 .25507 Mtetra
.44848 .22282 .43199 .20315 .41554 .21957 .4319 .23907 Mtetra
.46533 .20631 .44871 .18647 .43199 .20315 .44848 .22282 Mtetra
.48245 .18953 .46571 .16952 .44871 .18647 .46533 .20631 Mtetra
.49985 .17247 .48298 .15229 .46571 .16952 .48245 .18953 Mtetra
.51755 .15513 .50055 .13477 .48298 .15229 .49985 .17247 Mtetra
.53554 .13749 .5184 .11696 .50055 .13477 .51755 .15513 Mtetra
.55384 .11956 .53656 .09884 .5184 .11696 .53554 .13749 Mtetra
.517 .544 .822 r
.12199 .51238 .10784 .49601 .09604 .50799 .1101 .52424 Mtetra
.13404 .50036 .1198 .48387 .10784 .49601 .12199 .51238 Mtetra
.14626 .48817 .13193 .47156 .1198 .48387 .13404 .50036 Mtetra
.15865 .47581 .14422 .45908 .13193 .47156 .14626 .48817 Mtetra
.17122 .46327 .15669 .44642 .14422 .45908 .15865 .47581 Mtetra
.18396 .45056 .16934 .43359 .15669 .44642 .17122 .46327 Mtetra
.19689 .43767 .18216 .42057 .16934 .43359 .18396 .45056 Mtetra
.21 .42459 .19518 .40736 .18216 .42057 .19689 .43767 Mtetra
.2233 .41132 .20837 .39397 .19518 .40736 .21 .42459 Mtetra
.23679 .39786 .22177 .38037 .20837 .39397 .2233 .41132 Mtetra
.25049 .38421 .23535 .36658 .22177 .38037 .23679 .39786 Mtetra
.26438 .37035 .24914 .35258 .23535 .36658 .25049 .38421 Mtetra
.27848 .35628 .26314 .33838 .24914 .35258 .26438 .37035 Mtetra
.2928 .342 .27734 .32396 .26314 .33838 .27848 .35628 Mtetra
.30733 .32751 .29176 .30932 .27734 .32396 .2928 .342 Mtetra
.32208 .31279 .3064 .29446 .29176 .30932 .30733 .32751 Mtetra
.33706 .29785 .32127 .27937 .3064 .29446 .32208 .31279 Mtetra
.35227 .28268 .33636 .26405 .32127 .27937 .33706 .29785 Mtetra
.36771 .26727 .35169 .24849 .33636 .26405 .35227 .28268 Mtetra
.3834 .25162 .36727 .23268 .35169 .24849 .36771 .26727 Mtetra
.39934 .23572 .38308 .21662 .36727 .23268 .3834 .25162 Mtetra
.41554 .21957 .39916 .20031 .38308 .21662 .39934 .23572 Mtetra
.43199 .20315 .41549 .18373 .39916 .20031 .41554 .21957 Mtetra
.44871 .18647 .43208 .16689 .41549 .18373 .43199 .20315 Mtetra
.46571 .16952 .44895 .14977 .43208 .16689 .44871 .18647 Mtetra
.48298 .15229 .46609 .13236 .44895 .14977 .46571 .16952 Mtetra
.50055 .13477 .48353 .11467 .46609 .13236 .48298 .15229 Mtetra
.5184 .11696 .50125 .09668 .48353 .11467 .50055 .13477 Mtetra
.53656 .09884 .51927 .07838 .50125 .09668 .5184 .11696 Mtetra
.519 .547 .824 r
.10784 .49601 .09366 .47986 .08196 .49195 .09604 .50799 Mtetra
.1198 .48387 .10553 .4676 .09366 .47986 .10784 .49601 Mtetra
.13193 .47156 .11757 .45517 .10553 .4676 .1198 .48387 Mtetra
.14422 .45908 .12977 .44257 .11757 .45517 .13193 .47156 Mtetra
.15669 .44642 .14214 .42979 .12977 .44257 .14422 .45908 Mtetra
.16934 .43359 .15469 .41683 .14214 .42979 .15669 .44642 Mtetra
.18216 .42057 .16742 .40369 .15469 .41683 .16934 .43359 Mtetra
.19518 .40736 .18033 .39035 .16742 .40369 .18216 .42057 Mtetra
.20837 .39397 .19343 .37683 .18033 .39035 .19518 .40736 Mtetra
.22177 .38037 .20671 .3631 .19343 .37683 .20837 .39397 Mtetra
.23535 .36658 .2202 .34917 .20671 .3631 .22177 .38037 Mtetra
.24914 .35258 .23388 .33504 .2202 .34917 .23535 .36658 Mtetra
.26314 .33838 .24777 .3207 .23388 .33504 .24914 .35258 Mtetra
.27734 .32396 .26187 .30614 .24777 .3207 .26314 .33838 Mtetra
.29176 .30932 .27618 .29136 .26187 .30614 .27734 .32396 Mtetra
.3064 .29446 .29071 .27636 .27618 .29136 .29176 .30932 Mtetra
.32127 .27937 .30546 .26112 .29071 .27636 .3064 .29446 Mtetra
.33636 .26405 .32044 .24565 .30546 .26112 .32127 .27937 Mtetra
.35169 .24849 .33565 .22993 .32044 .24565 .33636 .26405 Mtetra
.36727 .23268 .35111 .21397 .33565 .22993 .35169 .24849 Mtetra
.38308 .21662 .3668 .19776 .35111 .21397 .36727 .23268 Mtetra
.39916 .20031 .38275 .18129 .3668 .19776 .38308 .21662 Mtetra
.41549 .18373 .39896 .16455 .38275 .18129 .39916 .20031 Mtetra
.43208 .16689 .41543 .14754 .39896 .16455 .41549 .18373 Mtetra
.44895 .14977 .43217 .13025 .41543 .14754 .43208 .16689 Mtetra
.46609 .13236 .44919 .11267 .43217 .13025 .44895 .14977 Mtetra
.48353 .11467 .46649 .0948 .44919 .11267 .46609 .13236 Mtetra
.50125 .09668 .48408 .07664 .46649 .0948 .48353 .11467 Mtetra
.51927 .07838 .50197 .05816 .48408 .07664 .50125 .09668 Mtetra
.52 .55 .826 r
.09366 .47986 .07946 .4639 .06784 .47611 .08196 .49195 Mtetra
.10553 .4676 .09124 .45153 .07946 .4639 .09366 .47986 Mtetra
.11757 .45517 .10318 .43898 .09124 .45153 .10553 .4676 Mtetra
.12977 .44257 .11528 .42626 .10318 .43898 .11757 .45517 Mtetra
.14214 .42979 .12756 .41336 .11528 .42626 .12977 .44257 Mtetra
.15469 .41683 .14001 .40028 .12756 .41336 .14214 .42979 Mtetra
.16742 .40369 .15264 .38701 .14001 .40028 .15469 .41683 Mtetra
.18033 .39035 .16545 .37355 .15264 .38701 .16742 .40369 Mtetra
.19343 .37683 .17845 .35989 .16545 .37355 .18033 .39035 Mtetra
.20671 .3631 .19164 .34604 .17845 .35989 .19343 .37683 Mtetra
.2202 .34917 .20502 .33198 .19164 .34604 .20671 .3631 Mtetra
.23388 .33504 .2186 .31771 .20502 .33198 .2202 .34917 Mtetra
.24777 .3207 .23238 .30323 .2186 .31771 .23388 .33504 Mtetra
.26187 .30614 .24637 .28853 .23238 .30323 .24777 .3207 Mtetra
.27618 .29136 .26057 .27361 .24637 .28853 .26187 .30614 Mtetra
.29071 .27636 .27498 .25846 .26057 .27361 .27618 .29136 Mtetra
.30546 .26112 .28962 .24308 .27498 .25846 .29071 .27636 Mtetra
.32044 .24565 .30449 .22746 .28962 .24308 .30546 .26112 Mtetra
.33565 .22993 .31959 .21159 .30449 .22746 .32044 .24565 Mtetra
.35111 .21397 .33492 .19548 .31959 .21159 .33565 .22993 Mtetra
.3668 .19776 .3505 .17911 .33492 .19548 .35111 .21397 Mtetra
.38275 .18129 .36633 .16248 .3505 .17911 .3668 .19776 Mtetra
.39896 .16455 .38242 .14558 .36633 .16248 .38275 .18129 Mtetra
.41543 .14754 .39876 .1284 .38242 .14558 .39896 .16455 Mtetra
.43217 .13025 .41538 .11095 .39876 .1284 .41543 .14754 Mtetra
.44919 .11267 .43226 .0932 .41538 .11095 .43217 .13025 Mtetra
.46649 .0948 .44943 .07516 .43226 .0932 .44919 .11267 Mtetra
.48408 .07664 .46689 .05682 .44943 .07516 .46649 .0948 Mtetra
.50197 .05816 .48465 .03816 .46689 .05682 .48408 .07664 Mtetra
.522 .552 .828 r
.07946 .4639 .06523 .44814 .0537 .46046 .06784 .47611 Mtetra
.09124 .45153 .07691 .43565 .06523 .44814 .07946 .4639 Mtetra
.10318 .43898 .08876 .42298 .07691 .43565 .09124 .45153 Mtetra
.11528 .42626 .10077 .41014 .08876 .42298 .10318 .43898 Mtetra
.12756 .41336 .11295 .39712 .10077 .41014 .11528 .42626 Mtetra
.14001 .40028 .12531 .38392 .11295 .39712 .12756 .41336 Mtetra
.15264 .38701 .13784 .37052 .12531 .38392 .14001 .40028 Mtetra
.16545 .37355 .15055 .35694 .13784 .37052 .15264 .38701 Mtetra
.17845 .35989 .16345 .34315 .15055 .35694 .16545 .37355 Mtetra
.19164 .34604 .17653 .32917 .16345 .34315 .17845 .35989 Mtetra
.20502 .33198 .18981 .31497 .17653 .32917 .19164 .34604 Mtetra
.2186 .31771 .20328 .30057 .18981 .31497 .20502 .33198 Mtetra
.23238 .30323 .21696 .28595 .20328 .30057 .2186 .31771 Mtetra
.24637 .28853 .23084 .27112 .21696 .28595 .23238 .30323 Mtetra
.26057 .27361 .24493 .25606 .23084 .27112 .24637 .28853 Mtetra
.27498 .25846 .25924 .24076 .24493 .25606 .26057 .27361 Mtetra
.28962 .24308 .27376 .22524 .25924 .24076 .27498 .25846 Mtetra
.30449 .22746 .28852 .20947 .27376 .22524 .28962 .24308 Mtetra
.31959 .21159 .3035 .19345 .28852 .20947 .30449 .22746 Mtetra
.33492 .19548 .31872 .17719 .3035 .19345 .31959 .21159 Mtetra
.3505 .17911 .33418 .16066 .31872 .17719 .33492 .19548 Mtetra
.36633 .16248 .34989 .14387 .33418 .16066 .3505 .17911 Mtetra
.38242 .14558 .36585 .12681 .34989 .14387 .36633 .16248 Mtetra
.39876 .1284 .38207 .10947 .36585 .12681 .38242 .14558 Mtetra
.41538 .11095 .39856 .09185 .38207 .10947 .39876 .1284 Mtetra
.43226 .0932 .41532 .07394 .39856 .09185 .41538 .11095 Mtetra
.44943 .07516 .43236 .05572 .41532 .07394 .43226 .0932 Mtetra
.46689 .05682 .44968 .0372 .43236 .05572 .44943 .07516 Mtetra
.48465 .03816 .4673 .01837 .44968 .0372 .46689 .05682 Mtetra
0 g
.92704 .1866 m
1 1.03178 L
s
1 1.03178 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
.46728 0 m
.92704 .1866 L
s
.46728 0 m
.05486 .44445 L
s
.05486 .44445 m
0 1.205 L
s
0 1.205 m
.4682 .90215 L
s
.4682 .90215 m
.46728 0 L
s
.46728 0 m
.05486 .44445 L
s
gsave
.13973 .21216 -73 -16.7992 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.92704 .1866 m
1 1.03178 L
s
gsave
1.06018 .61135 -61 -10.3528 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
79.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{288, 176.188},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/1000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo001BOol4003:Ool0055oo`04001oogoo003;Ool0
055oo`04001oogoo003;Ool0051oo`800003Ool000000<]oo`00ogoo8Goo003LOol00`00Ool00011
Ool00=]oo`05001oo`00Ool00010Ool00=]oo`05001oo`00Ool00010Ool00=Yoo`<00003Ool00000
041oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000kOol2003SOol003Yoo`800003Ool0
00000>5oo`00>Goo00<007oo00000goo0`00gWoo000hOol01000Oomoo`001Woo0P00g7oo000gOol0
1P00Oomoogoo001ZDPMoo`800=Yoo`00=Woo00<007ooOol00Woo00<006YbIU8027oo0`00OGoo0P00
F7oo000eOol00`00Oomoo`03Ool01@00JU9ZDVYBJW802Goo0P00NWoo0P0000=oo`000000EWoo000e
Ool00`00Oomoo`03Ool01`00JW9VDFYbIU9ZLVIA00Uoo`<007Ioo`03001oo`0000=oo`8005Aoo`00
=7oo00<007ooOol017oo00<006YBJW800fYB00=ZLVIBJU802Woo0P00Lgoo00@007oo@SX000Eoo`<0
055oo`00<goo00<007ooOol01Goo00/006YbIU9ZLVIAJW9VDVYbIU5ZLVIB00Yoo`<006moo`06001o
od8j?QT003hI1goo0P00Cgoo000bOol00`00Oomoo`06Ool01P00JU9ZDVYBJW9VDP=ZDP03IU9ZDVIB
00aoo`8006aoo`08001ood8j?QU2>@00@SXn6@Qoo`<004aoo`00<Goo00<007ooOol01goo00d006Yb
IU5ZLVIBJW9VDFYbIU9ZLVIAJW9VDP0=Ool2001YOol02@00Oom2>ShI@SXn6@00?QU2>P0;Ool2001:
Ool0031oo`03001oogoo00Moo`04JU8006YBJW83JU800fYbIU9ZDP02JU8016IBJU9VDVYB3Goo0`00
IGoo00@007oo@SXn6@92>@05@SX0048i@QU2>@0<Ool20018Ool002moo`03001oogoo00Qoo`0AJW80
06YbIU9ZLVIAJW9VDVYbIU5ZLVIBJW9VDFYbIU9ZLP0?Ool2001SOol03000@SXn6D8j?QU2>ShI000n
6D8j?QU2>Peoo`<004Eoo`00;Woo00<007ooOol02Goo00=ZDP00JU800VYB00=ZLVIBJU800VYB00QV
DVYBIU9ZDVIBJU9VDVYB47oo0`00Ggoo00<007oo?QT00T8i00U2>ShI@ST0048i?QU2>ChI@ST03goo
0P00@goo000]Ool00`00Oomoo`0:Ool04fYb001ZLVIAJW9VDVYbIU5ZLVIBJW9VDFYbIU9ZLVIBJW9V
DVYb019oo`8005aoo`0@001oochI@SXn6D8j?QU2>ShI000n6D8j?QU2>ShI@SX@Ool30010Ool002ao
o`03001oogoo00]oo`04JU8006YBJW83JU800fYbIU9ZDP02JU8026IBJU9VDVYBIU9ZDVIBJU8COol3
001HOol00`00Ooln6@02@ST03D8j?QU2>D8I@ST0048i?QU2>ChI@QTn6D8I019oo`8003ioo`00:goo
00<007ooOol037oo01EZLP00JW9VDVYbIU5ZLVIBJW9VDFYbIU9ZLVIAJW9VDVYbIU9ZLVIBJU805Goo
0P00EGoo01<007oo?QU2>ShI@SXn6D8j?QU2>ShI000n6D8j?QU2>ShI@SXn6@0DOol2000lOol000ao
o`800003Ool0000001Uoo`03001oogoo00eoo`03JU8006YB009ZDP03JW9VDVYB009ZDP08IU9ZDVIB
JU9VDVYBIU9ZDP=VDP03JU9oogoo01Aoo`80059oo`030012>ShI0092>@0=@SXn6D8i@QU2>ChI@ST0
048i?QU26ChI@QT00chI5Goo0`00>Goo000=Ool00`00Ool0000JOol00`00Oomoo`0=Ool05fYb001Z
LVIAJW9VDVYbIU5ZLVIBJW9VDFYbIU9ZLVIBJW9VDVYbIU9ZLVIBJU805goo0`00CWoo01L007oo?QU2
>ShI@SXn6D8j?QU2>ShI@SXn6@00?QU2>ShI@SXn6D8i?QU2>ShI01Moo`8003Moo`003Woo00<007oo
Ool067oo00<007ooOol03Woo00AZDP00JU9ZLP=ZDP03JW9VDVYB009ZDP08IU9ZDVIBJU9VDVYBIU9Z
DPEVDQQoo`8004]oo`03001oochI0092>@0=@SXn6D8i@QU2>ChI@STn6D8i00126ChI@QT00chI00A2
6ChI?QTn6AQoo`<003Aoo`0037oo0P0000=oo`0000005goo00<007ooOol03goo01YZLP00JW9VDVYb
IU5ZLVIBJW9VDFYbIU9ZLVIBJW9VDVYbIU9ZLVIBJU9VDVYbIU9ZDVIB6Goo0P00;Goo0P006Goo01/0
07oo?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QT003hI@SXn6D8i?QU2>ShI@QTn6D8I?QT06Woo0P00
<Woo000WOol00`00Oomoo`0@Ool00fYB001ZDP02JU800fYbIU9ZDP02JU8026IBJU9VDVYBIU9ZDVIB
JU83IU800fYBIU9VDP03IU8HOol2000/Ool01000Oomoo`005goo00<007oo?QT00T8i00e2>ShI@SU2
6D8i?QU2>ChI@STn6D8I00126@03?QT00d8I?QTn6@04?QTLOol2000`Ool002Ioo`03001oogoo015o
o`0LJW8006YbIU5ZLVIBJW9VDFYbIU9ZLVIAJW9VDVYbIU9ZLVIBJW9VDVYbIU9ZDVIBJW=VDVYBIU8E
Ool200000goo001oo`0[Ool00`00Oomoo`0GOol07P00Ooln6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn
6D8j?QT003hI@STn6D8j?QU26ChI@QTn6D8I?OU26Aeoo`<002eoo`009Goo00<007ooOol04Woo00AZ
DP00JU9ZLP=ZDP03JW9VDVYB009ZDP08IU9ZDVIBJU9VDVYBIU9ZDPUVDQ=oo`05001oogooOol0000[
Ool5000EOol00`00Ooln6@02@ST03T8j?QU2>D8I@STn6D8i?QU2>ChI@QTn6D8I0002?QT00d8I?QTn
6@08?QTOOol2000[Ool002Aoo`03001oogoo01=oo`0KJW8006YbIU9ZLVIAJW9VDVYbIU5ZLVIBJW9V
DVYbIU9ZLVIBJW9VDVYBIU9ZLVIBJU9VDVYc00=VDQ5oo`03001oogoo009oo`03001oogoo02Yoo`03
001oogoo01Eoo`0R001oochI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QT003hI@SXn6D8I
?QU26ChI@QTn6D8I?QU26Cgh@QTPOol2000YOol002=oo`03001oogoo01Aoo`03JU8006YB009ZDP03
JW9VDVYB009ZDP08IU9ZDVIBJU9VDVYBIU9ZDP=VDP03JU9VDVIB00MVDPmoo`03001oogoo00=oo`03
001oogoo045oo`03001oochI0092>@0=@SXn6D8i@QU2>ChI@STn6D8i?QU26ChI@QT00ShI00<0048I
?QT033hI87oo0P00:Goo000ROol00`00Oomoo`0EOol07fYb001ZLVIAJW9VDVYbIU5ZLVIBJW9VDFYb
IU9ZLVIBJW9VDVYbIU9ZLVIBJU9VDVYcIU9ZDVIBJU=VDVIC00eoo`8000Moo`03001oogoo03moo`0U
001oochI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ChI000n6D8I?QU26ChI@QTmnD8I
?QU26Cgh@QTmnChI?OP07Goo0P0000=oo`00Ool0:7oo000QOol00`00Oomoo`0FOol016YB001ZDVYb
16YB00aVDVYBJU9ZDVIBJU9VDVYBIU9ZDVIBJU8<IU8;Ool00`00Oomoo`07Ool00`00Oomoo`0nOol0
0`00Oomoo`02@ST03D8j?QU2>D8I@STn6D8i?QU2>ChI@QTn6D8I00<n6@03@QT003hI00hn6@03?OUo
ogoo01Uoo`05001oogooOol0000YOol0021oo`03001oogoo01Moo`0KJW8006YbIU9ZLVIAJW9VDVYb
IU5ZLVIBJW9VDVYbIU9ZLVIBJW9VDVYBIU9ZLVIBJU9VDVYc00=VDP03IU=VDWoo00Uoo`03001oogoo
00Qoo`03001oogoo03ioo`0X001ood8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@STn6D8j
?QT003hI@QTn6D8I?OU26ChI@QTmn48I?OTn6Cgh?QTmn3hI?OPIOol00`00Oomoo`02Ool00`00Oomo
o`0WOol001moo`03001oogoo01Moo`9ZDP06001ZDVYBJU9ZLVIB0fYB00QVDVYBIU9ZDVIBJU9VDVYB
0fIB00=ZDVIBIU802FIB27oo00<007ooOol02Goo00<007ooOol0?Goo014003hI@SU2>D8j?QU2>D8I
@SXn6D8i?QU2>ChI@QTn6D8I00<n6@04@QTn6ChI000=?QT01Cgi?QTn6ChI?OT05goo00<007ooOol0
0goo00<007ooOol09goo000NOol00`00Oomoo`0HOol08fIAJW8006YbIU5ZLVIBJW9VDFYbIU9ZLVIA
JW9VDVYbIU9ZLVIBJW9VDVYbIU9ZDVIBJW=VDVYBIU9ZDfIBIU=V<VICIU801Woo00<007ooOol02Woo
00<007ooOol0?7oo02`007oo@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ChI@SXn6D8I
?QT003hI@QTmnD8I?QU26Cgh@QTmnChI?OPn6Cgh?QTmn3hI?OPn6Cgh57oo0P001Woo00<007ooOol0
9goo000NOol00`00Oomoo`0HOol01FYbJU8006YBJW8016YB00aVDVYBJU9ZDVIBJU9VDVYBIU9ZDVIB
JU8?IU83Ool2000=Ool00`00Oomoo`0kOol04@00Oom2>D8i@SXn6D8i@QU2>ChI@STn6D8i?QU26ChI
@QT00chI00=26ChI?QT00ShI00<003hI?QT02ChI00PmnChI?OTn6Cgi?QTmnChI4goo00<007ooOol0
1goo00<007ooOol09Woo000MOol00`00Oomoo`0IOol076IBJW8006YbIU9ZLVIAJW9VDVYbIU5ZLVIB
JW9VDVYbIU9ZLVIBJW9VDVYBIU9ZLVIBJU9VDVYc0fIB00EVDfIBIU=R<VIC009oo`03001oogoo00eo
o`03001oogoo03Yoo`0_000n6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@STn6D8j?QU2
6ChI@QTn6@00?OU26ChI@QTmn48I?OTn6Cgh?QTmn3hI?OPn6Cgh?QTmn3hI?OPn6@0AOol00`00Oomo
o`08Ool00`00Oomoo`0VOol001aoo`03001oogoo01Yoo`9ZDP06001ZDVYBJU9ZLVIB0fYB00QVDVYB
IU9ZDVIBJU9VDVYB0fIB00=ZDVIBIU802FIB00AVDf9BIU80011oo`03001oogoo03Uoo`0A001ood8i
@SU2>ShI@SU26D8j?QU2>ChI@STn6D8I?QU26@03?QT00d8I?QTn6@04?QT00`00?QTn6@07?QT02Cgi
?QTmnChI?OTn6Cgi?QTmn002?OT@Ool00`00Oomoo`09Ool00`00Oomoo`0VOol001]oo`03001oogoo
01]oo`0VIU5ZLP00JW9VDFYbIU9ZLVIAJW9VDVYbIU5ZLVIBJW9VDVYbIU9ZDVIBJW9VDVYBIU9ZLfIB
JU9VDVYCIU9VDfHbIU=VDVICHS9VDa1oo`03001oogoo03Qoo`0b001ood8j?QU2>ShI@SXn6D8j?QU2
>ShI@SXn6D8j?QU2>ShI@STn6D8j?QU26ChI@QTn6D8I?OT003hI@QTmn48I?OTn6Cgh?QTmn3hI?OPn
6Cgh?QTmn3hI?OPn6CWh?QTin0eoo`8000aoo`03001oogoo02Ioo`006Woo00<007ooOol077oo00EZ
LVYB001ZDVYb00AZDP0<IU9ZDVYBJU9VDVYBIU9ZDVIBJU9VDVYB3fIB00=VDf8bIU<03goo00<007oo
Ool0=goo014007oo@SU2>D8j?QU2>D8I@SXn6D8i?QU2>ChI@QTn6D8I00<n6@03@QTn6ChI00Hn6@03
000n6ChI00Dn6@0??OTn6Cgi?QTmnChI?OTn6Cgh?OTmn3gi?OPmnCgh00]oo`03001oogoo00aoo`03
001oogoo02Ioo`006Goo00<007ooOol07Goo01aVDVYb001ZLVIBJW9VDFYbIU9ZLVIAJW9VDVYbIU9Z
LVIBJW9VDVYbIU9ZDVIBJW=VDVYBIU9ZL`=VDP09IU=VDVICHS9VDf8bIU=R<VIC00ioo`03001oogoo
03Ioo`0f001ood8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@STn6D8j?QU26ChI@QTn6D8I
?OU26ChI000mn48I?OTn6Cgh?QTmn3hI?OPn6Cgh?QTin3hI?OPn6CWh?QTin3gi>OPmnCWh2Goo00<0
07ooOol03Goo00<007ooOol09Woo000HOol00`00Oomoo`0NOol2JU801P00JU9ZDVYBJW9VDP=ZDP08
IU9ZDVIBJU9VDVYBIU9ZDP=VDP03JU9VDVIB00UVDP06IU=RDVIBHU9VDf8b3Woo00<007ooOol0=Goo
014007oo@SU2>D8j?QU2>D8I@STn6D8i?QU2>ChI@QTn6D8I00<n6@03@QTn6ChI00Pn6@03000n6ChI
00<n6@0B?OTn6Cgi?QTmnChI?OTn6Cgh?OTmn3gi?OPmnCgh?OTin3gh27oo00<007ooOol03Woo00<0
07ooOol09Woo000GOol00`00Oomoo`0OOol06VIAJW8006YbIU5ZLVIBJW9VDFYbIU9ZLVIAJW9VDVYb
IU9ZLVIBJU9VDVYbIU9ZDVIBJW<3IU8036ICIU9VDfHbIU=VDVICHS9VDf8bIU=R<Pioo`03001oogoo
03=oo`0M001ood8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@STn6D8j?QU26ChI@QTn6D8I
?OU26@02?QT06Sgh000mnChI?OPn6Cgh?QTmn3hI?OPn6CWh?QTmn3hI>OPn6CWh?OTin3gi>OPmnCWh
?OT5Ool2000AOol00`00Oomoo`0VOol001Ioo`03001oogoo021oo`9ZL`03001ZDVYb00AZDP0<IU9Z
DVYBJU9VDVYBIU9ZDVIBJU9VDVYB3fIB00EVDf8bIU=R<f9C00ioo`03001oogoo039oo`0A001ood8i
@SU2>ShI@SU26D8j?QU2>ChI@STn6D8I?QU26@03?QT00d8I?QTn6@0:?QT05@00?QTn6ChI?OTn6Cgi
?QTmnChI?OTn6Cgh?OTmn3gi?OPmnCgh?OTin003?OP00cWh?OQoo`02Ool00`00Oomoo`0AOol00`00
Oomoo`0VOol001Eoo`03001oogoo025oo`0ZIW9ZL`00JY=VDVYbIU5ZLVIBJW9VDFYbIU9ZLVIBJW9V
DVYbIU9ZLVIBJU9VDVYcIU9ZDVIBJU=VDVICIU9VDfIBIU=R<VICHS9VDf8bIU=R<V9C3Goo00<007oo
Ool0<Goo01d007oo@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ChI@SXn6D8I?QU26ChI
@QTmnD8I008n6@0P?OQ26Cgi000mn3hI?OPn6Cgh?QTmn3hI>OPn6Cgh?QTin3hI>OPmnCWh?OTin3gi
>OPmnCWH?OTif3giOol001Aoo`03001oogoo02Ioo`0057oo00<007ooOol08Woo0VYc00<006YcJW<0
0fYc0fYB00QVDVYBIU9ZDVIBJU9VDVYB0fIB00=ZDVIBIU802FIB00QVDf9BIU9RDVICHS9RDf8c3Goo
00<007ooOol0<7oo014007oo@SU2>D8j?QU2>D8I@SXn6D8i?QU2>ChI@QTn6D8I00<n6@03@QTn6ChI
00`n6@06000n6Cgi?QTmnChI0cgi00Xn6Cgh?OTmn3gi?OPmnCgh?OTin0<mn006>OPmn3gh?OPif3gh
5Goo00<007ooOol09Woo000COol00`00Oomoo`0ROol06fYcIW9ZT`00JW=VLVZCIW=ZLfIbJW=VDVYb
IU5ZLVIBJW9VDVYbIU9ZDVIBJW9VDVYBIU9ZL`03IU803VICIU9VDfHbIU=VDVICHS9VDf8bIU=R<V9C
HS8<Ool00`00Oomoo`0_Ool0@000OomoochI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8i?QU2
>ShI@QTn6D8I?QU26Cgi@QTn6D8I?OQ26Cgi?QTmn000?OPn6Cgh?QTmn3hI>OPn6Cgh?QTin3hI>OPm
nCWh?OTin3gi>OPmnCWH?OTif3gi>MPmn3WH5Goo00<007ooOol09Woo000COol00`00Oomoo`0ROol3
JW<00`00JW=ZL`04JW<036IcJW=ZLfYBIU9ZDVIBJU9VDVYBIU9ZDPmVDP06IU=R<VICHS=RDf8b0V8c
2goo00<007ooOol0;goo010007oo@SU2>ShI@SU26D8i?QU2>ChI@STn6D8I?QU26@<n6@03@QTn6ChI
00hn6@04000n6Cgi?QT3?OT01ChI?OPmnCgh?OT00cgh00<mnCWh?OP00Sgh00Tin3gh?OPmn3WH?OPi
n3gh>MP05Goo00<007ooOol09Goo000BOol00`00Oomoo`0SOol0;FZCIW9ZL`00JY=VLfYcIW9ZTfIc
JW=VLVYcIW=ZLVIBJW9VDVYbIU9ZLVIBJU9VDVYcIU9ZDVIBJU=VDVICIU9VDfIBIU=R<VICHS9VDf8b
IU=R<V9CHS9R<`0;Ool00`00Oomoo`0^Ool07000@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j
?QU26ChI@SXn6D8I?QU26ChI@QTmnD8I0ShI02@mn48I?OTn6Cgh?QTmn000?OPn6Cgh?QTin3hI?OPm
nCWh?QTin3gi>OPmnCWh?OTif3gi>MPmnCWH?OTif3gh>MPmnCWH?OPEOol00`00Oomoo`0UOol0015o
o`03001oogoo02Aoo`=ZL`03001ZLfYc00IZL`08IW=ZLfIcJW=VDVYBIU9ZDP=VDP03JU9VDVIB00UV
DP07IU=RDVIBHU9VDf8bHU<00V8c00=N<f8cOol02Goo00<007ooOol0;Goo0100048i@SU2>ShI@SU2
6D8j?QU2>ChI@STn6D8I?QU26@<n6@03@QTn6ChI00hn6@04?OTn6@00?QT3?OT02ShI?OPmnCgh?OTm
n3gi?OPmnCWh0cgh00Pin3gh?OPmn3WH?OPin3gh0cWH00<mn7ooOol04Woo00<007ooOol09Goo000@
Ool00`00Oomoo`0UOol06fYcIW9ZT`00JW=VLVZCIW=ZLfIbJW=VLfYcIW9ZLfIcJW=VLfYcIW=ZDVIB
JW9VDVYBIU9ZL`03IU8046ICIU9VDfHbIU=R<VICHS9VDf8bIU=R<V9CHS9R<ehb2Woo00<007ooOol0
;7oo01`007oo?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@STn6D8j?QU26ChI@QTn6D8I?OU2
6@8n6@0W?OQ26Cgi?QTmn3hI?OPn6Cgh000mn3hI>OPn6Cgh?OTin3hI>OPmnCWh?OTin3gi>MPmnCWH
?OTif3gi>MPmn3WH?OPif3gh>MPmn3WH01Aoo`03001oogoo02Eoo`003goo00<007ooOol09Woo0fYc
00<006YcJW<016Yc00QVLfYcJW=ZLfIcJW=VLfYc0fIc00=ZDVIBIU803FIB00IVDf8bIU=R<f9CHS83
HS<00ehcOomoo`07Ool00`00Oomoo`0[Ool04000Oom2>D8j?QU2>D8I@STn6D8i?QU2>ChI@QTn6D8I
0chI00=26ChI?QT03ShI00DmnChI?OTn6@00008mn@05?QTmn3gi?OPmn@03?OP00cgi>OPmn002?OP0
23Wh?OPmn3gh>MPmn3Wh?OP3>MP013gh>MPif3WH4goo00<007ooOol09Goo000>Ool00`00Oomoo`0W
Ool0;fZCIW9ZL`00JY=VLfYcIW9ZLfIcJW=VLVYcIW=ZLfIcJW=VLfYcIU=ZM6IcJU9VDVYcIU9ZDVIB
JU=VDVICIU9VDfIBIU=R<VICHS9VDf8bIU=R<V9CHS9R<ehbGS<02Goo00<007ooOol0:Woo01`007oo
?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@STn6D8j?QU26ChI@QTn6D8I?OU26@8n6@0[?OQ2
6Cgh?QTmn3hI?OPn6Cgh?QTmn000>OPn6Cgh?OTin3hI>OPmnCWh?OTin3gi>MPmnCWH?OTif3gi>MPm
n3WH?OPif3gh>MPmn3WH?OPiecgh>MP04Woo00<007ooOol09Goo000=Ool2000YOol3JW<00`00JW=Z
L`02JW<036IcJW=ZLfYcIW=ZLfIcJW=VLfYcIW=ZL`AVL`]VDP07IU=RDVICHU9RDf8bHU<00V8c00AN
<f8cGS=N<`Qoo`03001oogoo02Uoo`0@0012>D8i@SXn6D8i@QU2>ShI@STn6D8i?QU26ChI@QT3?QT0
0d8I?QTn6@0:?QT04Cgi?QTn6ChI?OTn6Cgi?QTmn3gi000n6Cgh?OTmn3gi>OP00Sgh00<mnCWh?OP0
0Sgh00Pin3gh>OPmn3WH?OPin3gh0cWH00<mn3WH>MP01CWH4Goo00<007ooOol09Goo000=Ool00`00
Ool00003000TOol076IbJW=VLVZC001ZLfIbJY=VLfYcIW9ZLfIcJW=VLVYcIW=ZLfIcJW=VLfYcIU=Z
M6IcJW=VDfYc0fIB019VDfIBIU=V<VICHS9VDf8bIU=R<VICHS9RDf8bHS=N<V8cGQ<9Ool00`00Oomo
o`0WOol20000AShI@SXn6D8j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8i?QU2>ShI@QTn6D8I?QU26Cgi
@QTmnChI?OQ26Cgh?QTmn3hI?OPn6Cgh?QTmn3hI>OP003Wh?OTin3hI>OPmnCWh?OTin3gi>MPmnCWH
?OTif3gi>MPmn3WH?OPif3gh>MPmn3WH?OPiecgh0SWH00<iecgHOol047oo00<007ooOol09Goo000=
Ool00`00Oomoo`03Ool3000QOol4JW<00`00JW=ZL`04JW<026IcJW=ZLfYcIW=ZLfIcJW<3IW<00fYc
IW=VL`04IW<9IU801VICHS9RDf8cHU=R<P=R<`9N<`Uoo`03001oogoo02Moo`0?0012>D8j?QU2>D8I
@SXn6D8i?QU2>ChI@QTn6D8I00<n6@03@QTn6ChI00Xn6@09?OTn6ChI?QTmnChI?OTn6Cgh008mn@06
?QT003gi?OPmnCWh0Sgh00<mnCWh?OP00Sgh00Pin3gh>OPmn3WH?OPin3gh33WH00<iecWHOol03goo
00<007ooOol09Goo000=Ool00`00Oomoo`06Ool4000MOol07VIbJY=VLVYc001ZTfIcJW=VLVYcIW=Z
LfIbJW=VLfYcIW=ZLfIcJW=VDfYdIW=ZLfICJWAVLfIdIU=ZM09VD`0BIU9VDfIBIU=R<VICHS9VDf8b
IU=R<V9CHS9R<ehbGS=N4Uhd27oo00<007ooOol09goo01X0048j?QU2>ShI@SXn6D8j?QU2>ShI@SXn
6D8j?QU2>ChI@SXn6D8I?QU26ChI@QTmnD8I0ShI02Xmn48I?OPn6Cgh?QTmn3hI?OPn6Cgh?QTin3hI
>OP003Wh?QTin3gi>OPmnCWh?OTif3gi>MPmn3WH?OTif3gh>MPmn3WH?OPif3gh>MPmn3WG?OP2>MP0
1SWG?MPiecWH>KLif0moo`03001oogoo02Eoo`003Goo00<007ooOol02Woo0`006Woo16Yc00<006Yc
JW<00VYc00aVLfYcJW=ZLfIcJW=VLfYcIW=ZLfIcJW<;IW<4IU801VICHU9VDf9BHU=R<P=R<`05GS=R
<ehcGS=J4`08Ool00`00Oomoo`0WOol03@00?QU2>D8I@SXn6D8i?QU2>ChI@QTn6D8I00<n6@03@QTn
6ChI00Xn6@09?OTn6ChI?QTmnChI?OTn6Cgh008mn@06?QTmn3gi000mnCWh0Sgh00<mnCWh?OP00Sgh
00Pin3gh>OPmn3WH?OPif3gh23WH00TiecWH>MPif3WG>MPiecWH>ML03goo00<007ooOol09Goo000=
Ool00`00Oomoo`0=Ool4000FOol086IbJW=VLVZC001ZLfIbJY=VLfYcIW9ZLfIcJW=VLfYcIW=ZLfIc
JW=VLfYcIU=ZM6IcJW=VDfYdIU=VM6ICIW@2IU<04FHbIU=R<VICHS9VDf8bIU=R<V9CGS9R<ehbHS=N
4ehcFQ<01goo00<007ooOol09goo04l0048j?QU2>ShI@SXn6D8j?QU2>ShI@SXn6D8i?QU2>ShI@QTn
6D8I?QU26Cgi@QTmnChI?OQ26Cgh?QTmn3hI?OPn6Cgh?QTmn3hI>OPn6CWh?OTin000>OPmnCWh?OTi
f3gi>MPmnCWH?OPif3gi>MPmn3WH?OPif3gh>MLmn3WH?OPiecgh>MLif3WG?MPiecWH>KLif3Vg>MPi
]`0>Ool00`00Oomoo`0UOol000eoo`03001oogoo015oo`<001=oo`AZL`03001ZLfYc00AZL`08IW=Z
LfYcJW=VLfYcIW=ZL`=VL`03JW=VLfIc00IVL`04IU=VLfIcIW@3IU800fICHS9RD`02HS<0168bHS=R
<f8c0Uhc00=J4ehCOol01Woo00<007ooOol09goo00/007ooOoln6D8i?QU2>ChI@QTn6D8I00<n6@03
@QTn6ChI00Xn6@09?OTn6ChI?QTmnChI?OTn6Cgh008mn@06?QTmn3gi?OPmn@000Sgh00<mnCWh?OP0
0Sgh00@in3gh>OPmn0<if003?OPif3WH00Hif00:>MLif3WH>MPiecWH>MLif3WG>MP2>ML00cVgOomo
o`0;Ool00`00Oomoo`0UOol000aoo`03001oogoo01Eoo`<0011oo`0cIW9ZTfIbJW<006ZCIW=ZLfIb
JW=VLfYcIW9ZLfIcJW=VLfYcIW=ZLfICJWAVLfYcIU=ZM6ICIWAVDfYdIU=VM6ICIWAVDfIdHS9VDf8b
IU=R<VICHS9RDehbHS=N<UhcGQ9N=5XC00Moo`03001oogoo02Moo`1@001oogooOoln6D8j?QU2>ShI
@SXn6D8i?QU2>ShI@QTn6D8I?QU26Cgi@QTmnChI?OPn6Cgh?QTmn3hI?OPn6Cgh?QTmn3hI>OPn6CWh
?OTin3hI>OP003Wh?OTif3gi>MPmnCWH?OPif3gi>MPmn3WH?OPif3gh>MLmn3WH?OPiecgH>MLif3WG
?MPiecWH>KLif3Vg>MPi]cWH>KLif0ioo`03001oogoo02Aoo`0037oo00<007ooOol067oo10002goo
1FYc00<006YcJW<00VYc00QVLfYcJW=ZLfIcJW=VLfYc0fIc00=ZLfIcIW<02FIc00=VM6ICIW<00VIC
00ERDVICHU9RDf8b00=R<`07GS=R<ehcGS=J4ehCEQ<01Woo00<007ooOol09Woo00<007ooOol00Woo
00E2>ChI@QTn6D8I00<n6@03@QTn6ChI00Xn6@09?OTn6ChI?QTmnChI?OTn6Cgh00<mn@09?OPmnCgh
?OTin3gh000mn3Wh00<mn004>MPmn3Wh?OP3>MP00cgh>MPif006>MP02SWG>MPif3WH>MLif3WG>MPi
ecWH0SWG0cVg00<iegooOol02goo00<007ooOol097oo000<Ool00`00Oomoo`0LOol30008Ool0=FZC
IW9ZLfIbJY<006YcIW9ZTfIcJW=VLVYcIW=ZLfIcJW=VLfYcIU=ZLfIcJW=VDfYdIW=ZLfICJWAVDfId
IU=VM6ICIWARDfIdHU=VDf8bIU=R<VICHS9RDehbHS=N4V8cGQ=N<eXCFQ@01Woo00<007ooOol09Woo
00<007ooOol00goo04a2>ShI@SXn6D8i?QU2>ShI@QTn6D8I?QU26Cgi@QTmnChI?OQ26Cgh?QTmn3hI
?OPn6Cgh?QTmn3hI>OPn6CWh?OTin3gi>OPmnCWh000if3gi>MPmnCWH?OPif3gi>MPmn3WH?OPif3gh
>MLmn3WH?OPiecgH>MLif3WG?MPiecWH>KLif3Vg>MPi]cWH>KLif3Fg>MPi]`eoo`03001oogoo02Ao
o`0037oo00<007ooOol07goo100017oo1FYc00<006YcJW<016Yc00QVLfYcJW=ZLfIcJW=VLfYc2fIc
00]VM6ICIW=VLfIdIU=VE69CIU=R<V9C009R<`03HS9R<f8c00=N<`03FQ=N4eGc00Ioo`03001oogoo
02Ioo`03001oogoo00Aoo`05@QTn6ChI?QU26@0<?QT02Cgi?QTn6ChI?OTn6Cgi?QTmn003?OT01Cgh
?OTmn3gi>OP00cgh00P003gh?OPmn3WH?OPin3gh0cWH00<mn3WH>MP01SWH00`iecWH>MPif3WG>MPi
ecWH>MLif3Vg>ML3>KL013WG=KLi]cVg37oo00<007ooOol097oo000<Ool00`00Oomoo`0SOol30000
=gooJW=VLVZCIW9ZL`00JY=VLfYcIW9ZLfIcJW=VLVYcIW=ZLfIcJW=VLfYcIU=ZM6IcJW=VDfYdIU=V
M6ICJWAVDfIdHU=VM69CIWARDfIdHU=VDf8bIU=R<V9CGS9R<ehCGS=N4UhdFQ=J55Gc00Eoo`03001o
ogoo02Ioo`03001oogoo00Eoo`0c@QTn6D8j?QU26ChI@QTn6D8I?OU26Cgi?QTmn3hI?OPn6Cgh?QTm
n3hI>OPn6Cgh?QTin3hI>OPmnCWh?OTin3gi>OPmnCWH000if3gi>MPmn3WH?OTif3gh>MPmn3WH?OPi
ecgh008if00F>MLmf3WG>MPiecWH>KLif3Vg>MPi]cWH=KLif3Vg>MPe]cWH=KLi]cFg>ML<Ool00`00
Oomoo`0TOol000aoo`03001oogoo02Ioo`03001ZU6ZD00=ZU003001ZU6Yc009ZL`08IW=ZLfYcJW=V
LfYcIW=ZL`=VL`03JW=VLfIc00UVL`06IWAVDfIdIU=VM69C0V9D00=RDf8bHS<00V8c0ehc00EN4eXC
GQ=F4eXC00Eoo`03001oogoo02Ioo`03001oogoo00Ioo`03@QTn6ChI00Xn6@0A?OTn6ChI?QTmnChI
?OTn6Cgh?OTmn3gi?OPmnCgh?OTin003?OP023Wh?OP003gh>MPmn3Wh?OP3>MP00cgh>MPif006>MP0
2CWG>MPif3WH>MLif3WG>MPie`02>KL00cWG>KLi]`02>KL01SFg>KLi]cVg=KLi]`]oo`03001oogoo
02Aoo`0037oo00<007ooOol09goo03IZU6JDJYAVU6ZE001ZU6JDJYEVU6ZDIW9ZLfIcJW=VLfYcIW=Z
LfICJW=VLfYcIU=ZM6IcJW=VDfYdIU=VM6ICIWAVDfIdHU=VM69CIWARDfIdHU=VDf8bHU=N<V8cGQ9R
<eXCGS=J4eXDEO<6Ool00`00Oomoo`0UOol00`00Oomoo`07Ool0BT8I?QU26ChI@QTmnD8I?OTn6Cgh
?QTmn3hI?OPn6Cgh?QTmn3hI?OPn6CWh?QTin3gi>OPmnCWh?OTin3gi>MPmnCWH000if3gh>MPmn3WH
?OPif3gh>MPmn3WG?OPif3gh>MLmf3WG>MPiecWH>KLif3Vg>MPi]cWH=KLif3Vg>MPe]cWG=KLi]cFg
>MLe]cVg=IH;Ool00`00Oomoo`0TOol000aoo`03001oogoo02Moo`EZU003001ZU6ZD00AZU008IYAZ
LfYcJW=VLfYcIW=ZL`]VL`0:IWAVDfIcIW=VM6ICIUARDfIdHU<2HU@0168cHS9R<f8c0Uhc00IN4eXC
GQ=EleXCDM<5Ool00`00Oomoo`0UOol00`00Oomoo`08Ool9?QT04Cgi?QTmnChI?OTn6Cgi?QTmn3gi
?OPmnCgh?OTmn3gi>OP00cgh00Pin3gh?OPmn000?OPin3gh0cWH00<mn3WH>MP01SWH00PiecWH>MLi
f3WG>MPiecWH0cVg00<iecVg>KL00SVg00Te]cVg>KLi]cFg>KLe]cVg=KL02Woo00<007ooOol097oo
000<Ool00`00Oomoo`0VOol0>6JDJYAVU6ZEIYAZU000JYEVU6ZDIYAZUFJDJYAVU6ZEIYAZUFIcJW=V
LfYcIU=ZM6IcJW=VDfYdIU=VM6ICJWAVDfIdHU=VM69CIWARDfIdHU=VM69CIWANE69CGS9R<ehCGS=J
4ehdFQ=J55GcDO@5Ool00`00Oomoo`0UOol00`00Oomoo`08Ool0;3hI@QTmnD8I?OTn6Cgh?QTmn3hI
?OPn6Cgh?QTin3hI?OPn6CWh?QTin3gi>OPmnCWh?OTif3gi>MPmnCWH?OTif000>MPmnCWH?OPif3gh
>MPmn3WG?OP2>MP073WG?MPiecWH>KLif3Vg>MPi]cWH>KLif3Fg>MPi]cWH=KLiecFg>KLe]cWG=IHi
]cFF>KLeUSVg2Woo00<007ooOol097oo000<Ool00`00Oomoo`0VOol6JY@00`00JYAZU002JY@02FJD
JYAZU6ZDIYAZU6JDJYAVU002IW<00fYcIW=VL`09IW<01VIdIU=VM6ICIWARD`IRE005HS=N<ehcGS=N
4`02FQ<00eHCFQ=Ad`05Ool00`00Oomoo`0UOol00`00Oomoo`09Ool6?QT04Cgi?QTn6ChI?OTn6Cgi
?QTmn3gi?OPmnCgh?OTmn3gi>OP00cgh00Pin3gh>OPmn3WH?OP003gh0cWH00<mn3WH>MP01SWH00Pi
ecWH>MLif3WG>MPiecWH0cVg00<iecVg>KL00SVg00/e]cVg>KLi]cFg>KLe]cVg=KLi]cFg00Yoo`03
001oogoo02Aoo`0037oo00<007ooOol09Woo03QVU6ZDIYAZU6JDJYD006ZDIYAZUFJDJYAVU6ZEIYAZ
UFIdJYEVU6ZEIWAZUFJDJYEVDfYdIW=VM6ICJWAVDfIdIU=VM6ICIWARDfIdHU=VM69CIWARDf9DGU=R
E5hdHS=N4V8cFQ=N<eGcFQAEle7d1Goo00<007ooOol02Woo0`0067oo00<007ooOol02Woo04TmnChI
?OPn6Cgh?QTmn3hI?OPn6CWh?QTmn3hI>OPn6CWh?OTin3gi>OPmnCWH?OTif3gi>MPmnCWH?OPif000
>MPmn3WH?OPif3gh>MLmn3WG>MPiecgH>MLif3Vg>MPi]cWH>KLif3Vg>MPe]cWH=KLi]cFg>MLe]cVg
=KLiecFF>KLeUSVg=IHi]cFF>KLeUP09Ool00`00Oomoo`0TOol000aoo`03001oogoo02Ioo`IZU004
001ZU6ZDIY@3JY@026JDJYAVU6ZDIYAZU6JDJYD3IY@00fJEIW=VL`05IW<02VIdIU=VLfIcIWARDfID
HUAVM69C169D00ENE68cGS=N<ehC009J4`04EO=J4e7CDO@4Ool00`00Oomoo`0;Ool00`00Oomoo`0G
Ool00`00Oomoo`0;Ool2?QT033gi?QTmnChI?OTn6Cgi?QTmn3gi?OPmn@<mn003?OTin3gh008mn009
>OPmn3Wh?OPif3gh>MPmn00000Lif00<>MLif3WH>MPiecWH>MLif3WG>MPi]cWG0cVg00<iecFg>KL0
0SVg00`e]cVg>KLi]cFg>KLe]cVg=KLi]cFF=KL2=IH9Ool00`00Oomoo`0TOol000aoo`03001oogoo
02Ioo`0iIYAZU6JDJYEVU6ZD001ZUFJDJYAVU6ZEIYAZUFJDJYEVU6ZEIWAZUFJDJYEVM6ZEIWAVUFId
JWAVDfIdIU=VM6ICIWARDfIdHU=VM69CIWARDfIdHU=VM5iDHUAN=69DGQ=N<eXCGSAEleXDEO=Am57C
00Aoo`03001oogoo00]oo`<001Moo`03001oogoo00aoo`18?OPn6Cgh?QTmn3hI>OPn6Cgh?OTin3hI
>OPmnCWh?OTin3gi>MPmnCWH?OTif3gi>MPmn3WH?OPif000>MPmn3WH?OPiecgh>MLif3WG?MPiecWH
>KLif3Vg>MPe]cWH>KLif3Fg>MPe]cVg=KLiecFg>KLeUSVg=IHi]cFF>KLeUSVg=IHi]cFF>KLeUSVg
2Goo00<007ooOol02Woo00<007oo00005Woo000<Ool00`00Oomoo`0VOol6JY@00`00JYAZU002JY@0
26JDJYAVU6ZDIYAZU6JDJY@3IY@01fZEIYAVU6JDIYEVU6JE009VL`09IU=VLfIcIWAVDfIdHU=VM69C
00ERE006GUARE5iDGSAN<ehC0UXC00AF4eXCDM=Al`Aoo`03001oogoo00]oo`04001oogoo000FOol0
0`00Oomoo`0=Ool02Sgi?QTmnChI?OTn6Cgh?OTmn3gi0cgh00<mnCWh?OP00Sgh00Pin3gh>OPmn3WH
?OPif3gh0SWH00<003WH>MP00cWH00`iecWH>MPif3WG>MPiecWH>MLif3Vg>ML4>KL03CFg>KLi]cVg
=KLi]cFg>KLe]cVg=KLi]cFg008eUP06=KLeUSFF=IHe]cFF2Goo00<007ooOol02Goo00D007oo001o
o`0001Eoo`002goo00<007ooOol09Woo01mZU6JDJYEVU6ZDIYAZU@00JYAVU6ZEIYAZU6JDJYEVU6ZE
IWAZUFJDJYEVM6ZEIYAZUFIdJYEVM6JEIWAVU@02IW@06FICIWAVDfIdHU=VM69CIWARDfIdHU=RE5iC
HUAN=69DFSAR<eXCGS=EleXDDM=Am57C00Aoo`03001oogoo00]oo`04001oogoo000EOol00`00Oomo
o`0?Ool0A3gh?QTin3hI?OPmnCWh?QTin3gi>OPmnCWh?OTif3gi>MPmn3WH?OTif3gh>MPmn3WH?OPi
e`00>MPmn3WG?MPiecWH>MLmf3Vg>MPi]cWH>KLif3Fg>MPi]cWH=KLif3Fg>KLe]cWG=KLi]cFF>KLe
USVg=IHi]cFF>KLeUSVg=IHi]cFF>KL2=IH00cEfOomoo`06Ool00`00Oomoo`09Ool01@00Ool007oo
00005Goo000;Ool00`00Oomoo`0VOol7JY@01000JYAZU6JD0fZD00QVU6ZDIYAZU6JDJYAVU6ZE0fJD
00IVUFJDIYEVU6JEIW@3IYD026ICIW=VDfIdHU=VE69DIW@4HU@4GU@02EhdGQ=J4eXCEO=Ale7CDOA5
T`03Ool00`00Oomoo`0:Ool4000FOol00`00Oomoo`0?Ool2?OT01ChI?OPmnCgh?OT00cgh00<mnCWh
?OP00Sgh00@in3gh>OPmn0<if003?OPif3WH008if005000if3WH>MPie`03>MP013WG>MPiecWH0cVg
00HiecVg>KLi]cWG=KL3>KL023Fg>KLe]cVg=KLi]cFg>KL3=IH01CFg=IHeUSFF=KL013FF27oo00<0
07ooOol027oo0`0000=oo`0000001Goo00<007ooOol03Goo000;Ool00`00Oomoo`0VOol0>fZDIYAZ
U6JDJYEVU6ZD001ZUFJDJYAVU6ZEIYAZUFJDJYEVU6ZEIWAZUFJDJYEVM6ZEIWAVUFIdJYEVM6JEIWAV
UFIdIYERM6IdHU=VM69CIWARDf9DHU=RE5iDHUAN=5iEGSANE5XDGSAEleXDDM=Am57CBK@00goo00<0
07ooOol097oo00<007ooOol047oo044n6Cgh?OTin3hI>OPmnCWh?OTin3gi>MPmnCWH?OPif3gi>MPm
n3WH?OPif3gh>MLmn3WH000iecgH>MLif3WG>MPi]cWH>KLif3Vg>MPe]cWH>KLif3Fg>MLe]cVg=KLi
ecFF>KLeUSVg=IHi]cFF>KLeUSVg=IHi]cFF>KLeUSVg008eUP04=GHeUSFF=IH7Ool00`00Oomoo`0C
Ool00`00Oomoo`0=Ool000]oo`03001oogoo02Ioo`MZU003001ZU6ZD009ZU008IYAZU6JDJYAVU6ZD
IYAZU0=VU006JYEVU6JEIYAVUFJD0fJE00UVM6JEIWEVUF9eIWERDfIdHU<01F9D00=NE69DGS@00Uhd
00QJ=5XCFQ=F4e7dDM=AldFC17oo00<007ooOol08goo00<007ooOol047oo00@mn3gi?OPmn@<mn003
?OTin3gh008mn004>OPmn3Wh?OP3>MP00cgh>MPif004>MP00`00>MPie`03>MP01CWG>MPiecWH>ML0
0SVg00<iecVg>KL00SVg00Xe]cVg>KLi]cFg>KLe]cVg=KLi]`8e]`<eUP03=KLeUSFF00TeUPMoo`03
001oogoo01=oo`03001oogoo00eoo`002goo00<007ooOol09Woo03aZ]VJeJ]IV]FZDIYAZU@00JYAV
U6ZEIYAZU6JDJYEVU6ZEIWAZUFJDJYEVM6ZEIYAZUFIdJYEVM6JEIWAVUFIdIYERM6JEHWAVUF9dIYER
MFIdHU=VM69CHUANDf9DGSANE5XdGUEJ=5XeEO=J557CDOAAddVdAI<3Ool00`00Oomoo`0SOol00`00
Oomoo`0AOol09SWh?QTin3gi>OPmnCWH?OTif3gi>MPmn3WH?OTif3gh>MPmn3WH?OPiecgh>MPmn3WG
000iecWH>MLif3Vg>MPi]cWH>KLif3Fg>MP2>KL05CFg>MLe]cVg=KLiecFF>KLeUSVg=IHi]cFF>KLe
USVg=IHi]cFF>KLeMP03=IH01SEf=IHeUSFF<GDeUPMoo`03001oogoo02=oo`002goo00<007ooOol0
9Woo00]Z]FZfJ[EZ]VZeJ[IV]@00J[EZ]VJe00=ZU004IYAZU6JDJY@3IY@02VZEIYAVU6JDIYEVU6JE
IYAVUFId0fJE0fIe00EVUF9eHWERMFId00ARE09NE003GSANE5Xd009J=007EQEEle7cDM=Am4FCAK<0
0goo00<007ooOol08goo00<007ooOol04Woo00Din3gh?OPmnCWh00<mn004>MPmn3Wh?OP3>MP00cgh
>MPif006>MP01P00>MPiecWH>MLif08ie`<i]`03>MLi]cVg008i]`0:=KLi]cVg>KLe]cVg=KLi]cFg
>KL2=KL3=IH00cFg=IHeUP08=IH013Ee=GHeMCEf1Woo00<007ooOol08goo000;Ool00`00Oomoo`0U
Ool0?FJeJ]IV]FZfI[EZeVJeJ[H006[FI[EZ]VJeJ[IV]FZfIWAZUFJDJYEVM6ZEIYAZUFIdJYEVM6JE
IWAZUFIdIYERM6JEHWAVUF9dIYERMFJEHWAVUF9eHUARDf9DGSARE5hdGUEN=5XeFQAN=EHDFQAAde7d
DM=9]4FC00=oo`03001oogoo02=oo`03001oogoo01=oo`0B>OPmnCWH?OTif3gi>MPmn3WH?OTif3gh
>MPmn3WH?OPiecgh0SWH00hiecgH>ML003Vg>MPi]cWH>KLif3Vg>MPe]cWH0SVg01De]cWG=KLi]cFg
>KLeUSVg=IHi]cFF>KLeUSVg=IHi]cFF>KLeUSVg=GH00cFF00TeMSFF=IHeUS5e=IHaMCFF<GD01Woo
00<007ooOol08goo000;Ool00`00Oomoo`0UOol04FZfJ[EZ]VZeJ[IV]FZfJ[D006JeJ[IV]VZfI[EZ
]VJfJ[H00fJf00YZUFJDIYAVU6JEIYAVUFJDIYEVU0=VU@04IWAVUFIeIYD8HWD0169DGUANE69D0Uhd
0UXd0eHD00EAm57CAK=5TdVc00=oo`03001oogoo02=oo`03001oogoo01=oo`03?OPin3gh008mn004
>MPmn3Wh?OP3>MP00cgh>MPif006>MP01SWG>MP003WH>MLif08ie`<i]`03>MLi]cVg008i]`09=KLi
]cVg>KLe]cVg=KLi]cFg008eUP05=KLeUSFF=IHe]`09=IH023Ef=GDeMSEe=GHeMCEf=GD5Ool00`00
Oomoo`0SOol000]oo`03001oogoo02Eoo`0/I[EZ]VJeJ]IV]FZfI[EZeP00J[IV]FZfI[EZ]VJeJ[IV
]FZfI[EZ]VJeJ[IVUFZfIWAZUFIdJYEVM6JEIWAVUFIdIYERM6JEHWAVUF9dIYERMF:EHWERMP9RM@0@
GSARE5hdGUAJ=5heFSAF5EHDFSEAde7dAI=9]4FCBK@2Ool00`00Oomoo`0SOol00`00Oomoo`0DOol0
<cgi>MPmnCWH?OPif3gh>MPmn3WH?OPif3gh>MLmn3WG>MPiecgH>MLif3Vg000i]cWH>KLif3Vg>MPe
]cWH=KLi]cFg>MLe]cVg=KLi]cFF>KLeUSVg=IHi]cFF>KLeUSVg=IHi]`02=IH043Ef=IHeUSFF=GHe
US5e=IHaMCFF<GDeUS5e=IHaMCFF1Goo00<007ooOol08goo000;Ool00`00Oomoo`0UOol03fZfJ[EZ
]VZeJ[IZ]FZfI[D006JfJ[IV]FZfI[IZ]P03I[H00fZfI[IV]P06I[H026JDIYEVUFJEIWAVUFIeIYD3
IWD00fJEHWERM@05HWD01F9DGUAN=5hdGU@00UXd00UF55HEEQAAle7CBK=5TdFcAI<00Woo00<007oo
Ool08goo00<007ooOol05Goo00Dmn3WH?OPin3gh00Pif00<>MLif3WH>MPiecWH>MLif000>MPi]cWG
13Vg00`e]cVg>KLi]cFg>KLe]cVg=KLi]cFg>KL3=IH01CFg=IHeUSFF=KL023FF00/eMCEf=GDeMSEe
=GHeMCEf=GDaMC5E00Eoo`03001oogoo02=oo`002goo00<007ooOol097oo02]Z]VJeJ]IV]FZfI[EZ
eVJeJ[H006[FI[EZ]VJeJ[IV]FZfI[EZ]VJeJ[IVUFZfI[EZ]VJEJ[IVUVJfIYIVUFIdIYERM6JEHWAV
UF9dIYERMFJEHWEVU@02HWD04UiEHWINEF9DFSANEEhdFSEJ55XeEQAF5DgDDOA5TdVdAI=9]09oo`03
001oogoo02=oo`03001oogoo01Ioo`0_?OPif3gh>MPmn3WH?OPif3gh>MLmf3WG>MPiecgH>MLif3Vg
>MPi]`00=KLif3Vg>MPe]cWG=KLi]cFg>MLe]cVg=IHi]cFF>KLeUSVg=IHi]cFF>KLeUSVg=IHi]`02
=IH04cEf=IHeUSFF=GHeUS5e=IHaMCFF<GDeUS5e=IHaMCEe<EDeMC5E00Eoo`03001oogoo029oo`00
2goo00<007ooOol097oo019Z]FZfJ[EZ]VZeJ[IV]FZfJ[D006JeJ[IV]VZfI[EZ]VJfJ[H<I[H026JF
I[IV]VJfIWEVUFIeIYD8HWD2GWD00eiEGUAN=003FS@2EQ@01e7dDOEAddFcAI=9/dFC009oo`03001o
ogoo02=oo`03001oogoo01Ioo`03>MPmn3WH00Lif00<>MLif3WH>MPiecWH>MLif3WG>KL003WG13Vg
00Xe]cVg>KLi]cFg>KLe]cVg=KLi]`8e]`<eUP03=KLeUSFF00PeUP0@=GDeMSEe=GHeMCEf=GDeMSEe
=GHeMC5e<EDeMC5E<GD5Ool00`00Oomoo`0ROol000]oo`03001oogoo02Aoo`0IJ]IV]FZfI[EZeVJe
J[IV]F[F001Z]VJeJ[IV]FZfI[EZ]VJeJ[IV]FZfI[EZ]VJEJ[H00VJf02AVUVJfIYIV]V:FI[MRUVJf
HYIVUF9dIYERM6JEHWERUEieHWINEF9eGUERMUYEGUAJ55heFSAF5EHDDOE=m57eAI=9]4FC;?82Ool0
0`00Oomoo`0SOol00`00Oomoo`0GOol0:cWH?OPiecgh>MPmn3WG?OPiecWH>MLmf3Vg>MPi]cWH>KLi
f3Fg000i]cWH=KLiecFg>KLe]cWG=IHi]cFF>KLeUSVg=IHi]cFF>KLeUSVg=IHi]cEf00<eUP0E=GHe
USFF=IHaMCFF<GDeUS5e=IHaMCFF<GDeUS5E=GDaECEe<EDeMC5E00Eoo`03001oogoo029oo`002goo
00<007ooOol097oo011Vef[GI]MZefJeJ[IZ]FZfI[D006JfJ[IV]FZfI[IZ]P=V]P03J[IV]VJf00YV
]P08IYIV]VJFI[IRUV:fHWEVU@MRM@04GWENEEiEGUD2FS@2EQ@01eHECOAAm57dBK=5TdFc008/lP03
Ool007oo02=oo`03001oogoo01Qoo`Lif008>MLif3WH>MPiecWH>MLif0<i]`03>ML003Vg008i]`0<
=KLi]cVg>KLe]cVg=KLi]cFg>KLeUSFg0cFF00<e]cFF=IH01cFF00TeMSEe=GHeMCEf=GDeMSEe=GH0
0SEe00TaEC5e<EDeMC5E<GDaECEe<ED017oo00<007ooOol08Woo000:Ool00`00Oomoo`0TOol0;6KG
J_MVef[hI]MZmfKGJ_QVef[G001Zn6JeJ[IV]FZfI[EZ]VJeJ[IV]FZfIYEZ]VJeI[IVUFJfIYIV]V:F
I[IRUVJfHYIV]f:FI[MRUVJgHYIRUF9eHWH2HWD01UiEHWINEEiFFUENMP9J=@0=EQAJ=EHDDOE=e57e
AI=9]4FC;?8XlGoo000097oo00<007ooOol06Goo02Dmn3WH?OPiecgH>MLif3WG>MPi]cWH>KLif3Vg
>MPe]cWH>KL003Fg>MLe]cVg=KLi]cFF>KLeUSVg=IHi]cFF>KLeUSVg=IHi]`02=IH01CEf=IHeUSFF
=GH00cFF01@aMCFF<GDeUS5e=IHaMCEe<EDeMC5E=GDaECEe<EDeMC5E=GDaECEe17oo00<007ooOol0
8Woo000:Ool00`00Oomoo`0TOol00f[GI]MZe`03I]L01F[GI]MVefKG00001fKG00=Z]VJfI[H02VJf
00QVUVJfI[IV]V:FH[IRUV:f0f:F00=RUf9eHWD00V9e00QNEEieGUENEUYEFUIJEEHE0UHD00QAm57e
COA5]4FCBK<XlRcb0Woo00<007ooOol08Goo00<007ooOol06Woo0cWH00PiecWH>MPif3WG>MPiecWH
0cVg00HiecVg>KL003Vg=KL3>KL01CFg>KLe]cVg=KL00SFF00De]cFF=IHeUSFg00TeUP0D=GHeMCEf
=GDeMSEe=GHeMC5e<EDeMC5E<GDaECEe<EDaMC5E=GDaE@8aE0Aoo`03001oogoo029oo`002Woo00<0
07ooOol097oo045Vef[hI]MZmfKGJ_QVef[gI]MZn000J]MVef[hI]MVf6KGJ_QVefKHI]MVf6JeJ[IV
UFZfIYIV]VJFI[IVUVJfHYIV]f:FI[IRUVJgHYIR]f:FH[MRUV:GGYIRMUiEGWINEEifFUEJEUHeFUIF
=EHECMAAmDgdAKA5U4VdAI</lRSA009oo`03001oogoo025oo`03001oogoo01Yoo`0>>MLmf3WG>MPi
]cWH>KLif3Vg>MPi]cWH=KLif08i]`0B=KL003Fg>KLe]cVg=IHi]cFF>KLeUSVg=IHi]cFF>KLeUSVg
0SFF01leMSFF=IHeUSEf=IHaMCFF<GDeUS5e=IHaMCFF<GDeMC5E=GDaECEe<EDeMC5E=GDaECEe<C@a
E2dd<EDa=003Ool00`00Oomoo`0ROol000Yoo`03001oogoo02Aoo`05J]MVef[GI]MZe`03I]L00f[G
I]L0000=I]L00fKHI]MVe`02I[H026JFI[IV]VJfIYIV]VJFI[H3HYH04f:GHYIRUf:FHYMNUV9eGUEN
MEYEGUEJEEYFFSEF=UHDDOE=m57d0095]004AI=5/bcb;?82Ool00`00Oomoo`0QOol00`00Oomoo`0K
Ool023WG>MPiecWH>MLif3WG>MP3>KL00cWG=KLi]`02>KL02@00>KLe]cVg=KLi]cFg>KLe]`02=IH0
1CFg=IHeUSFF=KL01cFF01HeMSEe=GHeMCEf=GDeMSEe=GHaEC5e<EDeMC5E<GDaECEe<EDaMC5E<E@a
=0<aE003<C@aE7oo009oo`03001oogoo029oo`002Woo00<007ooOol08goo049Zn6KGJ_MVef[hI]MZ
mfKGJ_QVef[G001Zn6KGJ]MVef[hI]MVf6KGI]QVefKHI]MVf6KGI]QR]fKHH[MV]V:FI[MRUVJfHYIV
]f:FI[MRUVJgHYIRUejFHYMNMV:GGWIRMUYEGUIJEEYFFSEF=U8EESI=m57eCMA5]DFdBK@XdBcb:?42
Ool00`00Oomoo`0QOol00`00Oomoo`0KOol07CWH>KLif3Vg>MPi]cWH>KLif3Fg>MPe]cVg=KLiecFg
000eUSVg=IHi]cFF>KLeUSVg=IHi]cFF>KL013FF01PeMSFF=IHeUS5e=IHaMCFF<GDeUS5e=IHaMCEe
<EDeMC5E=GDaECEe<EDeMC5E=GD2<ED0234d<E@]=35E<C@aE2dd<ED2Ool00`00Oomoo`0ROol000Yo
o`03001oogoo02=oo`04I]MZefKGJ]L3I]L01F[GI]MVefKG00003fKG00eVf6KGI]MVefKHH[MVf6JF
I[IRUV:fHYIR]P03HYH01V:GGYINUejGHYMNMP9NE@09GUIJ=EYFESEF=UHeCQIAm57e00=5]003;?8X
lRcb009oo`03001oogoo025oo`03001oogoo01aoo`03>MPiecWH008ie`@i]`0:=KLi]cVg>KLe]cVg
000i]cFg>KL2=KL3=IH00cFg=IHeUP08=IH05cEe=GHeMCEf=GDeMSEe=GHaECEe<EDaMC5E=GDaEC5e
<EDeMC5E<GDaEC5D<C@00c5D00Da=35D<E@aE34d009oo`03001oogoo029oo`002Woo00<007ooOol0
8goo03]W6FKhJaUVn6LII_QW6FKhJ]MVef[h001ZefKGJ_QVefKHI]MZf6KGI]QVefKHI]MVf6:gI]QR
]fKHH[MVf6:gI]QR]fKHH[MRf6:gI[MRUV:GHYIR]ejFHYMNMV:GGWINUeYfGWIJ=EYFESEF=UHeDQI=
mE7e0095]005AIA5]BSa;?8Xd@02Ool00`00Oomoo`0QOol00`00Oomoo`0LOol063Vg>MPe]cWH>KLi
f3Fg>MLe]cVg=KLiecFg>KLeUP00=IHi]cFF>KLeUSVg=IHi]`8eUP05=GHeUSFF=IHeMP03=IH08c5e
=IHaMCFF<GDeUS5e=IHaECEe<EDeMC5E=GDaECEe<EDeMC5E<E@]=35E<C@aE2dd<EDa=35D;C@aEC4d
<E@]=7oo000097oo000:Ool00`00Oomoo`0ROol2I_T00fLII_QVn@02I_T01VKhI_UVnFKiI_P0009V
n@]Ve`0:I]QVefKGI]MVf6;GI]QRef;HH[L2H[P05V;HH[QR^6:FHYMNUV:GHYIRUejFGYMJMeigFWMJ
EUYEFUIF=EHfCQEB5Tge14Fd0bcb00<XlWoo00008goo00<007ooOol07Goo00<i]cWG>KL00cVg00`e
]cVg>KLi]cFg>KLe]cVg000i]cFF=KL3=IH00cFg=IHeUP07=IH053Ef=GDeMSEe=GHeMCEf=GDeMS5E
=GDaEC5e<EDeMC5E<GDaECEe<C@3<E@01C4d<E@aE35D<C@00c5D00Ha=35D<E@aE7oo000TOol000Yo
o`03001oogoo029oo`16I_Q[6FKhIaUVn6LII_QW6FKhIaUVn6LI001W6FKhI_URn6LIH_QVnF;hI]QV
efKHH[MVf6;GI]QR]fKHH[MVf6:gI]QR]fKHH[MVf6:gH]QN]f;HG[MRUejFHYMNMV:GFWINUeYfGWMF
EUYFESEF=U8EDQI=mE8FAIA5]DFd;A<XdBcb:?4/lWoo000SOol00`00Oomoo`0NOol053Vg>MPe]cWG
=KLi]cFg>MLeUSVg=IHi]cFF000eUSVg=IHi]cFF>KL2=IH063Ef=IHeUSFF=GHeUS5e=IHaMCFF<GDe
US5e=IHaMCEe<EDeMC5E=GDaECEe<EDeM@8aE@0C<C@aE2dd<EDa=35D;C@aEC4d<E@]=35E<C@aE2Sb
;A</lWoo000097oo000:Ool00`00Oomoo`0QOol00fKiIaUVn002I_T00fLII_QVn@02I_T01FKhI_UV
n@00I_P00fKi00QVn6KiI_UVnF;iI_URnFKi0V;i00]VefKHH]MVf6;GI]QR]f;HH[QRf6:g00=R^008
G[QR^5jhH[QNUUjGGWMNU`9JM`09FUMJMeIGESIF=EHfCOE>5ThE00=5]003;?8]4RSb008/lP03Ool0
07oo029oo`03001oogoo01ioo`<i]`0<=KLi]cVg>KLe]cVg=KLi]cFg=IH003Fg33FF01DeMCEf=GDe
MSEe=GHeMCEf=GDaMC5E=GDaEC5e<EDeMC5E<GDaEC5D<C@00c5D00Da=35D<E@aE34d00<aE006<C@]
4Rcb;A8/lRdB0Woo00<007ooOol08Goo000:Ool00`00Oomoo`0QOol0;F/II_QW6FKhIaUVn6LII_QW
6FKhIaURn6LI001VnF;hIaURn6KiH_QVnF;hI_URf6KiH_QVnF;HI_URf6;iH]QVf6:gI]QR]fKHH[MR
f5jgH]QN]f:hG[MR^002G[P2GYL05UYfGWMJMUYgEUIJMe8fESI=mE8FCOE5eTFeAKA5U2dC:?8/lRSA
;?9oo`008goo00<007ooOol07goo00liecFg>KLe]cVg=IHi]cFF>KLeUSVg=IH003FF>KL013FF01Pe
MSFF=IHeUSEf=IHaMCFF<GDeUS5e=IHaMCFF<EDeMC5E=GDaECEe<EDeMC5E=GD2<ED05S4d<E@]=35E
<C@aE2dd<EDa=35D;C@aEC4d;A<XlRdC;?8]4bSb;A=oo`008goo000:Ool00`00Oomoo`0QOol02F<J
IaYW6VLjHaYW6V<JIaYVn003I_T01FKh001VnFKiI_P00fKi00ARnFKiI_UVn@=Rn@03I_URnF;i009R
n@05H]URnF;IH_UR]`03H[P015jhH[QR^6:h15jh00IJV5YgFWMJMeIGFWL2EUL01U9GCQI>5E8FAKE5
e@95]0@/lP03:?9oo`0002=oo`03001oogoo01moo`08=KLi]cFg>KLe]cVg=KLi]`<eUP03=KL003FF
00PeUP08=GDeMSEe=GHeMCEf=GDeMP8eM@0:<EDaMC5E=GDaEC5e<EDeMC5E<GD2<E@01C4d<E@aE35D
<C@00c5D00la=35D<E@aE34d;A8/lRdB;?8]4Rcb;A8/lWoo00008goo000:Ool00`00Oomoo`0POol0
<V<JIcYS6VLjHaYW>V<JIcYS6VLJHaYW>V<JIaX006LJHaYVnF;hI_URn6KiH_QVnF;hI_URf6KiH]QV
nF;HI_URfF;iG]QRnF;IH_UNfF;HH[MR^5jgH[QN^6:hGYMN^5ZHG[P2FYP055IFFWMFEUIGDSIFEdhF
DQI=mDGE@KE5eRSb;A<XlRcb:?4/lWoo000SOol00`00Oomoo`0POol033FF>KLeUSVg=IHi]cFF>KLe
USVg=IH000@eUP0b=GHeUSFF=IHaMCFF<GDeUS5e=IHaMCFF<EDeMC5E=GDaECEe<EDeMC5E=GDaEC5D
;C@aEC4d<E@]=35E<C@aE2dd<EDa=35D;C@aEBcb;A<XlRdC;?8]4bSb;A</lRdCOol002=oo`002Woo
00<007ooOol087oo0VLJ00UW>V<JIaYS6VLJHaYW6V<JIaX00f<J00<006<JHaX01V<J00ARnFKiH_UV
n@ARn@04H]URnF;iH_T3H]T00f;iG]URf@02G]T4G[P00eZHGYQJV002FYP035IhFUMFEe9GEUM>5dhg
COE5eDFeAME5]@8/lP04;A8XlRcb;?82Ool00`00Oomoo`0OOol00`00Oomoo`0QOol00cVg=KLi]`02
=KL3=IH013Fg=IHeUP001SFF01@eMSEe=GHeMCEf=GDeMSEe<GDaECEe<EDaMC5E=GDaEC5e<EDeMC4d
0c5D00Da=35D<E@aE34d00<aE00A<C@aE2cb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4RcbOol0000SOol0
00Uoo`03001oogoo021oo`0CIcYS6VLjHaYW>V<JIcYS6VLjHaYW>V<JIaYS6VLJ001W6V<JIaX00V<J
01IRnVLJH_YS6V;jHaYRnV<JG_YVnF;IH_URf6;iH]URnEkIH_UNfF;iG]URnP9Nf@04G[UN^5jHG[P4
FYP05EIhFYUB=UIGDSIB=dhFCSM1]DGFAKE5eBSb;A<XlRdC:=4/lRSaOol0000QOol00`00Oomoo`0R
Ool02SVg=IHi]cFF>KLeUSVg=IHi]cEf0`0001@eMSFF<GDeUS5e=IHaMCFF<GDeUS5e=GDaECEe<EDe
MC5E=GDaECEe0S5E01ha=35D;C@aEC4d<E@]=35E<C@aE2dd<EDa=2dC:?8]4bcb;A<XlRdC;?8]4bSb
;A</lRdC:?8]4goo000SOol000Uoo`03001oogoo01moo`US>`03HaYW6V<J009S6P03IaYS6P0000iS
6P08H_YS6V;jHaYRfF;iH]URn@9Rf@INf@03F[UNV5jH00=JV00>EWQFV5IhDWQFEdhgCQI>=dhGAMI5
]DGE;A<]4P@/lP04:?8/lWoo000QOol00`00Oomoo`0ROol00cFF=KLeUP02=IH00cFg=IHeUP020003
=IH400003cEf=GDeMSEe=GHaEC5e<EDeMC5E<GDaECEe<EDaM@02<E@01C4d<E@aE35D<C@00c5D01La
=35D<E@aE2cb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?9oo`0002=oo`002Goo00<007oo
Ool07goo00IO>f=LHc]S>elkHc`2Hc/025lKHcaO>f<kGa]S?5lKHc/300000f<JH_YW6P02HaX06V;j
HaYRnV<JG_YS6UkjHaYNnV<KG_YS6UkjHa]NnV;iG]URnUkIH]UN^EkJF[UNfUZiG]X2FYP05eIhFYUF
N5IhDUQFN4hFCSM>5TGg@MI5eD6e<A<]4RdC:?8]4bSa;?8XdGoo00008Goo00<007ooOol08goo00@e
USVg=IHi]`8eUP0:000eUSFF=IHeMSFF<GDeUS5e=IH40000;35E=GDaECEe<EDeMC5E=GDaECEe;C@a
EC4d<E@]=35E<C@aE2dd<EDa=35D;C@aEBcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]
4bSb000SOol000Uoo`03001oogoo01ioo`mS>`800003Hc]O>f<k00@00003Ga]S>f<J00=S6P04H_YS
6V;jHaX:G_X2G]T00eZiG]UJ^@04F[T01EJHEWQFN59HEWP00Thh00=>5dhgAMH00TGF0bdC00</lRdB
;?800bcb00=oo`00Ool087oo00<007ooOol08goo13FF0P0013FF00XeMSEe=GHeMCEf=GDeMS5E=GDa
E@@00004<GDaECEe<ED3<E@01C4d<E@aE35D<C@00c5D01Ta=35D<E@aE2cb;A8/lRdB;?8]4Rcb;A8/
lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A80000SOol000Uoo`03001oogoo01eoo`0:GcaSGEllHeaO?6=L
GcaS>elkHc`2Hc/03ElKHcaO6`00Ga]S?5lKHc]O6f<lGa]S>elK00@0000`HcaO6elkGa]S6ekjHaYN
nV<KG_YS6UkjH_]JnUkkF]YNneZiG]YJ^EkJF[UJ^UJIE[YFVEJjDUQFN59HCUQ:=diH@MI5mT7FAOL]
4RdC;A8]4bSb;A<XdBcb:?5oo`008Goo00<007ooOol097oo00@eUP00000eMP<eUP0@<GDeUS5e=IHa
MCFF<GDeUS5E=GDaECEe<EDeMC5E=GD500008c5E<C@aE2dd<EDa=35D;C@aEC4d<E@]=2dC;?8]4bSb
;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb00008goo0009Ool00`00Oomoo`0MOol5
Ge`015llGeaO?5mL0ell00=OG00000000V<k00QO>f<kHc]S>elKHc]O>f<k0elK00=O>`0000000P00
15lK1Ukj00=JnUkjF]X015[J0eZi0UJI00=BNE:IDWT00dhh0TGg0TGF12dC0bcb00D]4RSb;?9oo`00
025oo`03001oogoo02Aoo`03000eUSFF008eUP0D=GHeMCEf=GDeMSEe=GHeMC5e<EDeMC5E<GDaECEe
<EDaMC5E<E@a=0<aE0@0000O<C@aE35D<E@a=35D;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb
;A8/lRdB;?8]4Rcb;A8/lRdB00008goo0009Ool00`00Oomoo`0LOol036=MGcaSG5llHeaO?5mLGcaS
G5llGeaO?0800007GeaO?5mLGcaOG5/lGe`00Ull00]K?6<lGa]S>elKHcaO6elkGa]S?5lK00@0000X
Ga]JnelLF_]Nne[JG_]JfUkkF]YJfe[JF]]F^U[KEYUF^UJIEYYBNDiIBUQ>F4hgAOM1mdGg@MHa=2dC
<A<]4RdC:?8]4bSb;?8XdGoo000QOol00`00Oomoo`0ROol200000goo=GHeUP02=IH06c5e=IHaMCFF
<GDeUS5e=GDaECEe<EDeMC5E=GDaECEe;C@aEC4d<E@]=35E<C@aE2dd<EDa=00400006bdC:?8]4bcb
;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?80000SOol000Uoo`03001o
ogoo01]oo`05GeeKGE]MFeeOG@03Fed01EmMGcaOG5ll000045ll00AK?5llFcaO?0IO6`D00003Fa]J
ne[J00AJfP03E]YJfUJj009F^P03DYUBNE9i00=>F@A5m`8]<`05<C<]4bdC;A<]4P04;?800goo001o
o`0POol00`00Oomoo`0QOol01000Oomoogoo0SFF014eMSEe=GHeMCEf=GDeMS5E<GDaECEe<EDaMC5E
=GDaEC5e008aE005<C@aE35D<E@a=003<E@01S4d<E@aE35D;?8]4P@0000H;?8]4Rcb;A8/lRdB;?8]
4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A9oo`008Woo0009Ool00`00Oomoo`0JOol02emmFeeO
GE]LGeeKG5mMFcaOGE]LGed00P0000QK?5mMFcaOGE/lGeeK?5mL0Ull01IK?5llFcaO?5/lGcaK?5ll
FaaO?5/LGcaK75llFaaO6e[kGaaJnelLF_]O70@00006E]]Jo5JjF]]F^UJk0U:j0U:J00Y:F4iiBUQ6
648HAQM1mc4d;A<a=08]4`09;A8a4bSb;A<XlRcb:?4/lP00025oo`03001oogoo01moo`8000Aoo`0W
<GDeUS5e=IHaMCFF<GDeMC5E=GDaECEe<EDeMC5E=GDaEC5D;C@aEC4d<E@]=35E<C@aE2dd<EDa=35D
;C@]4bcb;A<XlRdC;?8]4bSb00@0000D;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb
;A<0029oo`002Goo00<007ooOol06Goo00EKOU]MFeeKGE]N00=KG@05GeeKGE]M001OG@03Fed00emM
FeeKG@02Fed01E/lFeeK?E]MFc`00U/m00IKGE/lGcaK?5llFa`3Fc`7Fa`00e/KF_]Jn`02F_/00eKk
000000020003E[X2DYX2CWX2CUT2AQP2AOL0134d<C<]4bdc0bdC0Rcb00D]4RSb;?8/lP00025oo`03
001oogoo01eoo`8000Ioo`05=GHeMCEf=GDeMP02=GD02C5E<GDaECEe<EDaMC5E=GDa=003<E@01C4d
<E@aE35D<C@00c5D010a=35D;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4PD0000?;A8/lRdB;?8]
4Rcb;A8/lRdB;?8]4Rcb;A8/lP00029oo`002Goo00<007ooOol067oo00YKOUMMFgiGGE]nEeeKOUMM
FgiGG@80000MFgiGGE]NEeeOGE/lGeeK?5mMFcaOGE/lGeeK?5]MFcaOGE/lFeeK?5]MFcaK?ELlGcaK
75/lFaaK?002Fa`02ULLFaaG75/LE_aK75KKF_aFfeKl0UKK100001M:FDijBWU>NT8HAQQ264HH;C<a
E2dd<C@]4c4d;A8]4bSb;A<XlRdC:=4/lP00025oo`03001oogoo01aoo`03001oogoo00Moo`0_=IHa
MCFF<EDeMC5E=GDaECEe<EDeMC5E=GDa=35D;C@aEC4d<E@]=35E<C@aE2dd<EDa=35D:?8]4bcb;A<X
lRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4`0400002bSb;A</lRdC:?8]4bcb;A<XlRdC0000
8Woo0009Ool00`00Oomoo`0GOol01EMnEeiGOU]MFeh01E]M00<005]MFed015]M00UGGE]MFeeKGEMM
FeeGGE]MFc`00U/m00=KGE/lFcd00U/m00EK?5/mFceK?E/l00=K?@06EaaK75/LFaaG75/L0ULL0eKl
0UKK0U;K00AFfdjkD[]>NPD000966006<E@a=2dd<C@]<c4c0bdC00<]4Rcb;?800Rcb00<XlWoo0000
87oo00<007ooOol06Woo0P002Woo00deMCEf<EDeMC5E<GDaECEe<EDaMC5E<E@a=003<E@01C4d<E@a
E35D<C@00c5D01/a=2dB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/
lRdB;?80100000L]4Rcb;A8/lRdB;?80000ROol000Uoo`03001oogoo01Ioo`09EgiGGEMnEeeGOUMM
EgiGGEMn0080000ZEeeGOUMMFeiGGE]NEeeKGULmFeiGGE]MEceKGULmFeeG?E]NEceKGELmFeiG?E/m
EcaK?ELlFceG75/mEaaK?ELLFceG75LmE_aK75KlEaaFneKl0U;l00]Bfe:kC[]B^dYjCY]:NTHi@QQ6
>DHH00@0000;<C@]<c4d;A<a=2dB<A<]4RdC:?8]4`03Ool00`00Oomoo`0MOol00`00Oomoo`0JOol0
0`00Oomoo`0:Ool02CEe<EDeMC5E=GDaECEe<EDeM@02<ED0;34d<E@]=35E<C@aE2dd<EDa=35D;C@a
EBcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]
4bSb;A<40002Ool00`00Oomoo`0POol000Uoo`03001oogoo01Eoo`05EgiCGU=nEeiGOP03Eeh20003
Eeh01EMMEeiGGUMNEed00eMN00aGGEMNEeiGGUMMFeeGGE]MEceGGELmFed7Ecd00e/mEaaG?@02Ead0
2ULLEaeG7ELMDaaG7ELLE_aBo5Kl0U;L00I>^dkLBYY>VdYjAUX3AST00c5e<EDaE@02<E@400001Rdc
;A<]4bdC;?8]4PAoo`03001oogoo01eoo`03001oogoo01Qoo`8000eoo`08<EDeMC5E<GDaECEe<EDa
M@8aE005<C@aE35D<E@a=003<E@09S4d<E@aE2dB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb
;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A83Ool3000ROol000Qoo`03001oogoo
01Eoo`0UEgiCGUMnDeiGOU=NEgiCGP00DeiGOU=NEgiCGUMnDeiGOUMMEeiGGEMNEeeGGUMMEeiGGEMN
DceGGULmEeiC?EMNEceKGELmFeh00eLm02AG?ULmEceC7ELmDaeG?E<LEaeBo5LMD_aG7E;lEaeBfe;L
C[]Bg4ZKC[a:VdIJ@SU6FTHi<GDaECEe<E@aEBdd<E@]=34d;A<40006Ool00`00Oomoo`0MOol00`00
Oomoo`0GOol00`00Oomoo`0>Ool0=C5E=GDaECEe<EDaE2dd<EDa=35D;C@aEC4d<E@]=35E<C@aE2Sb
;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb
;A<XlRdC;?8017oo0P0097oo0008Ool00`00Oomoo`0DOol01e=nDeiCOU=NDgiCGU=n0080000NDeiG
GU=NEgiCGUMNDeiGGU=NEeiCGUMNDeiGGU=NEeiGGEMNEeeGGUMMEeiGGEMNEceGGULmEeiC?ELn1ULm
00AC7ELmDaeG?@AC7@=Bo0=>g003BY]>^dZK00=6FP09ASTeMS5E<GDaEC5e<E@aEBdd008a=003<C<]
4bdc009oo`@0009oo`03001oogoo01eoo`03001oogoo01Eoo`80015oo`04<GDaECEe<ED3<E@01C4d
<E@aE35D<C@00c5D02<a=35D;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb
;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb00Eoo`8002Ioo`0027oo00<007ooOol04goo035COe=NDgm?
GU=oDeiCO`00DgmCGU=oCeiCOe=NDgiCGU=oDeiGOU=MEgiCGUMNDeeGGU=NEeiCGEMNDeiGGU<mEeiC
?UMNDceGGU<mEeiC?EMNDceG?U<mEciC?E<nDaeG?@04Dad014klDae>o5;M0TkL00a:VdjlB[]6Nd9J
AW]6FSEf<GDeUS5E<GD2<ED0135D<ED]<c5D2Goo0`007goo00<007ooOol04goo0P0057oo02leMC4d
<E@]=35E<C@aE2dd<EDa=35D;C@aEC4d;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb
;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC00Eoo`8002Qoo`0027oo00<007ooOol04Woo00IC
OdmNCgi?GU=oCeh200001E=oCeiCGTmNDgh04e=N00=GGU=NDeh00U=N00AC?U=NDciCGP9C?P03DceC
?U<m009C?@03DciC7E<M009C7@06C_eBoDkmC_e>g4km0dZl0TIk0TIJ00<eUS5e=GH00S5e00<aEC5e
<ED00S5D2Woo0P008Goo00<007ooOol04Woo00<007ooOol057oo00Da=35D<E@aE34d00<aE00U<C@a
E35D<E@/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]
4Rcb;A8/lRdB;?801Goo0P00:Woo0008Ool00`00Oomoo`0AOol05TmoCei?OdmNCgm?GP00CeiCOdmN
Dgm?GU=oCeiCOdmNDgm?GU=oCeiCOdmN0U=N00ECOe=NDei?GU=O009CGP0HCciCGU<nDei??UMNDceC
GU<mDeiC?E=NCceC?TlmDciC7E<nCaeC7TlMDai>oE<M0Tkm00M>g4kmB[a>gDZlAW]6FP02AW/02CFF
<GHeUc5e=GHaMCEe<EDaM@0:Ool2000SOol00`00Oomoo`0@Ool2000GOol0:c5D;C@aEC4d<E@]=35E
<C@aE2dd<ED/lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC
:?8]4bcb;A<XlRdC00Eoo`8002aoo`0027oo00<007ooOol047oo00E?OdmNCgm?GTmo0080000GCei?
OdmNCem?GTmoCei?GdmNDgi?GU=NCeiCGTmNDei?GU=NCeiCGTmNDei?GP07Deh01E<nDeiC?U=NCch0
1e<n00I?7DlNCae?7TkmCad4C_d01dZlB]a6NdJKAW]6W3FF008eU`8eUP03=GHaMCEf00]oo`8002Eo
o`03001oogoo00moo`03001oogoo01Moo`8aE00W<C@aE35D<E@a=35D;?8]4Rcb;A8/lRdB;?8]4Rcb
;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb00Eoo`8002ioo`00
27oo00<007ooOol03Woo00E;GTmoBei?Od]N00800013Cgm;GTmoBei?OdmNDgm?GTmoCeiCOdmNCgm?
GU=oCeiCOdmNDgm?GU=OCeiCGdmNDem?GU=OCeiCGdlnDem??U=NCciCGTlnDei??U=NCciC?TlmDci?
7U<nCae?7TkmCai:oDlNB_e:gDZlC]e6VdJLAW]6W3Fg>KLeUSFg<GHeUS5f=IH02Woo0P009goo00<0
07ooOol03Goo0P006goo02Ha=35D;C@aEC4d;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]
4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC17oo0`00<7oo0008Ool00`00Oomoo`0=Ool0
0d]OBgm;GP02Bel04@00Bei?GdmOCgm?GTmOCei?OdmNCem?GTmOCei?GdmNCel00dmN00E?GdmNCei?
GTmO00=?GP09Cem?GTmNCeiCGTlnCei??TmN00Q??PI?7P03B_e>oD[m00=:g@=6W0De]`04=IHeUcFF
=IH9Ool2000YOol00`00Oomoo`0<Ool00`00Oomoo`0KOol3<E@08Bcb;A8/lRdB;?8]4Rcb;A8/lRdB
;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lP04Ool2000cOol000Qo
o`03001oogoo00aoo`04Bei;Od]NCgl20000:4]NCgm;GTmoBei?Od]NCgm;GTmoBei?OdmNCgm;GTmo
Cei?Gd]NCgm?GTmOBei?GdmNCem;GU=OCei?GdlnDem??TmOCci?GdlnCem??U=O0Tln00Y;7TlnBai?
?T/NCai;7DlNB_e?7P9:o@0:B]a6_DJLA[`e]cWH=KLi]cFg>KP2=KL00cFFOomoo`07Ool2000[Ool0
0`00Oomoo`0:Ool2000NOol08Rdd<ED/lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<X
lRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC17oo0P00=Goo0008Ool00`00Oomoo`0;Ool01d]OBgm;
Gd]O001;Od]N009;G`03Bgm;GT]O009;G`05Bei?Gd]OCem;GP03Cel034]NCem?GTmOBei?GdmNCem?
GTmOCei?G`=?GP03Cem?GTmN009?GPQ??P04Cai??T/NCah4Bah01D[MB_e:gDJmA[`00cWH00<e]cWH
=KL00cFg27oo0`00;Goo00<007ooOol027oo0P0087oo020]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]
4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb17oo0P00=goo0008Ool00`00Oomo
o`09Ool014]oAei;Od]N0P00045;Od]NBgm;GT]oBei;Od]NCgm;GTmoBei?Od]NCgm;GTmoBei?Gd]N
Cgm;GTmOBei?Gd]NCem;?TmOBei?Gd/nCem;?TmOBci?Gd/nCem;?TmOBci?Gd/nCcm;7TlnBai??T/N
Cai:oD[nA_e:oTJlA[dif3Wi=MPinCGH>MPe]cWH00Uoo`80031oo`03001oogoo00Moo`03001oogoo
021oo`0N;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb
;A</lRdC17oo0P00>Goo0008Ool00`00Oomoo`08Ool3Bel2000:Bel01D]NBem;Gd]OBeh00d]O00E;
GT]OBem?Gd]N009;G`0ECem;GT]OBem?Gd]NCem;GTmOBei?Gd/nCem;?T]NBci??d/nCci;?Tln009;
?P04Bai;?T/NBah2B_h014KmA[e6_DKM0SWi00<in3Wi>MP00SWH2Goo0P00<Goo00<007ooOol01Woo
0P008goo01`]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb
;A8/lPAoo`8003]oo`0027oo00<007ooOol01Woo03A7GT]oAei;O`00Bgm7GT]oAei;OdMNBgm;GT]o
Aei;Od]NBem7GT]oBei;GdMNCgm;GT]OBei?Gd]NBem;GTmOBei;Gd/nCem;GTmOBci?Gd/nCem;?TmO
Bci?Gd/nCem;?TloBci??`9;?PA;7P0<A_e;7TKmA]e6_DKM>OTj6CWh>OTif3Wi2Goo0P00<goo00<0
07ooOol01Goo00<007ooOol08goo01XXlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A</
lRdC:?8]4bcb;A<XlRdC0goo0`00?Goo0008Ool00`00Oomoo`05Ool3Ael20002Ael00d]OAem;G`02
Bel00dMOBem;G`09Bel01D]NBem;Gd]OBeh00d]O00E;GT]OBem;Gd]N00=;G`0>Bei;Gd]NBem;?T/o
Bci;?d/nBcm;?T/oBai;?PA;7P03A_i;7TKM0096g@03>QXinCXI00<in@Uoo`8003Eoo`03001oogoo
00=oo`8002Moo`0G;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A8/lP03
Ool20010Ool000Moo`03001oogoo00Aoo`15Bgm7GT]OAeh004MNBem7GT]oAei;GdMNBgm7GT]OAei;
OdMNBem7GT]oAei;GdMNBem7GT]OAei;Gd]NBem;GT]OBei;Gd/nBem;?T]OBci;Gd/nBem;?TmOBci;
Gd/nBem;?T]OBci;?d/NBcm77T/oAai;7TKmA_i6gDKn>QTn>SXI?QXinChJ00Uoo`8003Moo`04001o
ogooOol2000YOol05BdC:?8]4bcb;A<XlRdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4`03Ool2
0012Ool000Moo`03001oogoo00=oo`=7G`8000M7G`06Bem7GdMOAem;GdMO0d]O00=7Gd]OBel02D]O
00E;GT]OBem;Gd]N00=;G`0=Bci;Gd/oBem;?T/oBci;?d/nBcm;?T/oAah00T/N00I;?TKnAai6gDKn
A]d3?SX00cXJ?QXj6P09Ool2000iOol01000Oomoo`00:goo01</lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb
;A8/lRdB;?8]4Rcb;A8/lP03Ool20014Ool000Moo`06001oogooOom7GdMo0TMO03H004]oAem;GdMN
Bgm7GT]OAei;OdMNBem7GT]OAei;GdMNBem7GT]OAei;GdMNBem7GT]OAei;GdLnBem7GT]OAci;GdLn
Bem7?T]OBci;GdLnBem7?T]OAci;GdLnBcm77T/oAci;?dLNBal2A_h024;MA_hj>Shk>SXn>SXJ?SX8
Ool3000kOol3000/Ool04BdC;?8]4bSb;A</lRdC:?8]4bcb;A<XlRdC;?8]4bSb;A<00goo0P00AWoo
0007Ool00`00Oomoo`03Ael2000@Ael01D]OAem7GdMOBel00dMO00=;GdMOBel00T]O00E7Gd]OBem;
GdMO00=;G`05Bci;Gd/oBem7?P03Bcl01TLnBcm7?T/oAci;?P977PA6oP05?SXn>chj?S/n>P08Ool2
000nOol3000/Ool03Rcb;A8/lRdB;?8]4Rcb;A8/lRdB;?8]4Rcb;A84Ool20018Ool000Moo`040017
Gd=OAel200000dMOAgm7G`02Ael0;d]OAem7GdMOBem7GTMOAei;GdMNBem7GT]OAei;GdLnBem7GT]O
Aci;GdMNBem7?T]OAci;GdLnBem7?T]OAci;GdLnBem7?T]OAci;GdLnBem7?T/oAai;?dLNBcl00TLN
0TKn00I2oCiK?S/nFcXj?U/8Ool20013Ool6000VOol032dC:?8]4bcb;A<XlRdC;?8]4bSb;A</lPAo
o`8004Yoo`001goo00@004MOAel001Y7G`05Bem7GdMOAem;G`03Ael03T]OAem;GdMOBem7?d]OAcm;
GdLnBcm7?d/oAch2Acl00d/oAai77P04A_h5?U/8Ool2001;Ool6000POol02Rcb;A8/lRdB;?8]4Rcb
;A8/lRdB0goo0`00C7oo0007Ool30002Ool3Ael00d=OAem7G`06Ael0;T]OAei7GdLnBem7GT]OAci;
GdMNBem7?T]OAei;GdLnBem7?T]OAci;GdLnBem7?T]OAci;GdLnBem7?T]OAci;?dLnBcm77T/oAai7
?d;nAam6oT9l?U]2O3iK2Goo0P00Dgoo1P006goo00P/lRdC:?8]4bcb;A<XlRdC0Woo0P00Cgoo0007
Ool3000<OolEAel02T]OAcm7GdLoAem7?dMOAcm;GdLn0dLo00A7?TLoAci77`977P03A_i77Sik008n
O003@Waoogoo00Moo`8005]oo`H001Eoo`05;A8/lRdB;?8]4P03Ool2001AOol000Yoo`H0011oo`0R
Aem7?T]OAci7GdLnBem7?TMOAci;GdLnBem7?T]OAci;GdLnBem7?T]OAci;?dLnAcm77TLoA_i77d;n
AalnNd9l?W/9Ool2001SOol6000?Ool00bSb;A</lP03Ool2001COol0011oo`H001=oo`05Aem7?dMO
Acm7G`08Acl01DLnAcm77TLoA_h00TLN00=2W3il@W`027oo0`00Jgoo1P002Goo00@]4WooOomoo`80
05Eoo`005Woo1@005Goo00m;GdLnAcm77TLoAci7?dLNAam2oTLO?Wa2WCil@Y`01goo0P00M7oo1P00
0goo00@007oo000005Moo`006goo1P005Goo00M77TLO@Ya2WD:L@YdnW007Ool2001lOol5001IOol0
025oo`H001=oo`03001oogoo00Eoo`800=aoo`009goo1@003Woo00<007ooOol00goo0P00gWoo000/
Ool60008Ool01000Oomoogoo0P00h7oo000bOol60002Ool01000Ool00000hWoo000hOol4003TOol0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {175.188, 0}} -> {-0.0525058, -0.0305993, \
0.00733454, 0.00733454}, {{7.125, 137}, {171, 4.125}} -> {0.122852, \
-0.168258, 0.00644782, 0.00644782}, {{149.938, 279.813}, {171, 4.125}} -> \
{-0.868368, -0.213855, 0.00691729, 0.00691729}}]
}, Open  ]],

Cell[TextData[{
  "It is obvious from this figure that the skeleton of the original equation \
is reduced to a much simpler representation. The convex shape of the original \
skeleton reduces to a concave surface which is invariant with respect to a \
translation along the ",
  StyleBox["t",
    FontSlant->"Italic"],
  "-axis.\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"skeleton", "concave surface"}],

Cell["\<\
Upon observing that a canonical transformation simplifies the \
skeleton, we approach the second component of a differential equation. The \
second component was concerned with the solution of the equation. The \
question now is: How can we use the information of the symmetries to find \
solutions of any first-order equation possessing some symmetries? One idea to \
solve this problem is to use canonical variables which allow a transformation \
to a simpler representation of the equation.\
\>", "Text",
  CellTags->{
  "canonical transformation simplifies the skeleton", "canonical variables"}],

Cell["\<\
Returning to our first example of the Riccati equation, we know \
that the canonical variables for a non-homogeneous dilation is given by\
\>", 
  "Text",
  CellTags->"non-homogeneous dilation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(trafo1 = {x \[Rule] Exp[t], u \[Rule] Function[x, w[Log[x]]\/x]}\)], 
  "Input"],

Cell[BoxData[
    \({x \[Rule] E\^t, u \[Rule] Function[x, w[Log[x]]\/x]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In S",
  ButtonBox["ection 4.3.4,",
    ButtonData:>{"symmet11.nb", "Canonical variables"},
    ButtonStyle->"Hyperlink"],
  " we derived this type of transformations by solving the defining equations \
for ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ". The solution used here is a special type of the general solution derived \
in Section 4.3.4. Application of this transformation to the Riccati equation \
gives us the following result:"
}], "Text",
  Evaluatable->False,
  CellTags->"Riccati equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(riccati1 = 
      Simplify[Thread[\n\t\t\tPowerExpand[riccati /. trafo1]\ Exp[2\ t], 
          Equal]]; riccati1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-2\) - w + w\^2 + w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The transformation straightens out the skeleton of the original \
Riccati equation, taking it to a parabolic cylinder\
\>", "Text",
  CellTags->"skeleton"],

Cell[BoxData[
    \(g[t_, w_] := 2 + w - w\^2\)], "Input"],

Cell[TextData[{
  "The right-hand side of ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "is independent of ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "; thus, the skeleton reduces to a cylindrical surface centered along the ",
  
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "-axis."
}], "Text",
  Evaluatable->False,
  CellTags->"cylindrical surface"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pl2 = 
      Plot3D[g[t, w], {t, 0.25, 2}, {w, \(-5\), 5}, \n\t\tBoxed \[Rule] True, 
        Axes \[Rule] True, Mesh \[Rule] False, Ticks \[Rule] None, \n\t\t
        PlotPoints \[Rule] 30, BoxRatios \[Rule] {1, 3\/5, 1}, \n\t\t
        ViewPoint \[Rule] {1.975, \(-1.884\), 2.000}, \n\t\t
        AxesLabel \[Rule] {"\<t\>", "\<w\>", "\<w'\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.20141 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.149908 1.2594 0 1.2594 [
[.66677 1.1669 -5.73785 0 ]
[.66677 1.1669 6.26215 19 ]
[.19359 1.22462 -6.39592 0 ]
[.19359 1.22462 5.60408 19 ]
[1.03519 .50652 0 -14.8336 ]
[1.03519 .50652 20 4.1664 ]
[ 0 0 0 0 ]
[ 1 1.20141 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.38081 1.20141 m
1 .91828 L
s
gsave
.66677 1.1669 -66.7378 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 1.05195 m
.38081 1.20141 L
s
gsave
.19359 1.22462 -67.3959 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.9135 .24802 m
1 .91828 L
s
gsave
1.03519 .50652 -61 -18.8336 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
79.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.07455 .4049 m
0 1.05195 L
s
0 1.05195 m
.38081 1.20141 L
s
.38081 1.20141 m
.39495 .58525 L
s
.39495 .58525 m
.07455 .4049 L
s
.58882 0 m
.9135 .24802 L
s
.9135 .24802 m
1 .91828 L
s
1 .91828 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.07455 .4049 m
0 1.05195 L
s
0 1.05195 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.58882 0 m
.07455 .4049 L
s
.39495 .58525 m
.9135 .24802 L
s
.9135 .24802 m
1 .91828 L
s
1 .91828 m
.38081 1.20141 L
s
.38081 1.20141 m
.39495 .58525 L
s
0 0 m
1 0 L
1 1.20141 L
0 1.20141 L
closepath
clip
newpath
.358 .118 .408 r
.37848 .8234 .39063 .7732 .40683 .76361 .3949 .81391 Mtetra
.3949 .81391 .40683 .76361 .4232 .75393 .41149 .80432 Mtetra
.41149 .80432 .4232 .75393 .43974 .74415 .42826 .79463 Mtetra
.42826 .79463 .43974 .74415 .45645 .73426 .44521 .78484 Mtetra
.44521 .78484 .45645 .73426 .47334 .72427 .46233 .77494 Mtetra
.46233 .77494 .47334 .72427 .4904 .71417 .47964 .76493 Mtetra
.47964 .76493 .4904 .71417 .50764 .70397 .49714 .75482 Mtetra
.49714 .75482 .50764 .70397 .52507 .69366 .51482 .7446 Mtetra
.51482 .7446 .52507 .69366 .54269 .68324 .5327 .73427 Mtetra
.5327 .73427 .54269 .68324 .56049 .67271 .55078 .72382 Mtetra
.55078 .72382 .56049 .67271 .57849 .66206 .56905 .71326 Mtetra
.56905 .71326 .57849 .66206 .59668 .6513 .58753 .70258 Mtetra
.58753 .70258 .59668 .6513 .61508 .64041 .60622 .69178 Mtetra
.60622 .69178 .61508 .64041 .63367 .62941 .62511 .68087 Mtetra
.62511 .68087 .63367 .62941 .65247 .61829 .64421 .66982 Mtetra
.64421 .66982 .65247 .61829 .67148 .60704 .66354 .65866 Mtetra
.66354 .65866 .67148 .60704 .69071 .59567 .68308 .64736 Mtetra
.68308 .64736 .69071 .59567 .71015 .58417 .70285 .63594 Mtetra
.70285 .63594 .71015 .58417 .72981 .57254 .72284 .62438 Mtetra
.72284 .62438 .72981 .57254 .74969 .56077 .74307 .61269 Mtetra
.74307 .61269 .74969 .56077 .7698 .54888 .76354 .60087 Mtetra
.76354 .60087 .7698 .54888 .79014 .53684 .78424 .5889 Mtetra
.78424 .5889 .79014 .53684 .81072 .52467 .80519 .57679 Mtetra
.80519 .57679 .81072 .52467 .83154 .51235 .82639 .56454 Mtetra
.82639 .56454 .83154 .51235 .8526 .49989 .84784 .55215 Mtetra
.84784 .55215 .8526 .49989 .87391 .48728 .86955 .5396 Mtetra
.86955 .5396 .87391 .48728 .89548 .47452 .89152 .5269 Mtetra
.89152 .5269 .89548 .47452 .9173 .46161 .91376 .51405 Mtetra
.91376 .51405 .9173 .46161 .93938 .44855 .93627 .50104 Mtetra
.349 .104 .394 r
.36604 .87073 .37848 .8234 .3949 .81391 .38266 .86134 Mtetra
.38266 .86134 .3949 .81391 .41149 .80432 .39946 .85184 Mtetra
.39946 .85184 .41149 .80432 .42826 .79463 .41645 .84225 Mtetra
.41645 .84225 .42826 .79463 .44521 .78484 .43361 .83254 Mtetra
.43361 .83254 .44521 .78484 .46233 .77494 .45097 .82274 Mtetra
.45097 .82274 .46233 .77494 .47964 .76493 .46851 .81283 Mtetra
.46851 .81283 .47964 .76493 .49714 .75482 .48624 .8028 Mtetra
.48624 .8028 .49714 .75482 .51482 .7446 .50417 .79267 Mtetra
.50417 .79267 .51482 .7446 .5327 .73427 .5223 .78243 Mtetra
.5223 .78243 .5327 .73427 .55078 .72382 .54063 .77207 Mtetra
.54063 .77207 .55078 .72382 .56905 .71326 .55917 .76159 Mtetra
.55917 .76159 .56905 .71326 .58753 .70258 .57791 .751 Mtetra
.57791 .751 .58753 .70258 .60622 .69178 .59687 .74029 Mtetra
.59687 .74029 .60622 .69178 .62511 .68087 .61605 .72945 Mtetra
.61605 .72945 .62511 .68087 .64421 .66982 .63544 .71849 Mtetra
.63544 .71849 .64421 .66982 .66354 .65866 .65506 .7074 Mtetra
.65506 .7074 .66354 .65866 .68308 .64736 .67491 .69619 Mtetra
.67491 .69619 .68308 .64736 .70285 .63594 .69499 .68484 Mtetra
.69499 .68484 .70285 .63594 .72284 .62438 .7153 .67336 Mtetra
.7153 .67336 .72284 .62438 .74307 .61269 .73586 .66175 Mtetra
.73586 .66175 .74307 .61269 .76354 .60087 .75666 .64999 Mtetra
.75666 .64999 .76354 .60087 .78424 .5889 .77771 .6381 Mtetra
.77771 .6381 .78424 .5889 .80519 .57679 .79901 .62606 Mtetra
.79901 .62606 .80519 .57679 .82639 .56454 .82057 .61388 Mtetra
.82057 .61388 .82639 .56454 .84784 .55215 .84239 .60155 Mtetra
.84239 .60155 .84784 .55215 .86955 .5396 .86448 .58906 Mtetra
.86448 .58906 .86955 .5396 .89152 .5269 .88684 .57643 Mtetra
.88684 .57643 .89152 .5269 .91376 .51405 .90948 .56363 Mtetra
.90948 .56363 .91376 .51405 .93627 .50104 .9324 .55068 Mtetra
.338 .086 .377 r
.35333 .91489 .36604 .87073 .38266 .86134 .37014 .90559 Mtetra
.37014 .90559 .38266 .86134 .39946 .85184 .38714 .89618 Mtetra
.38714 .89618 .39946 .85184 .41645 .84225 .40432 .88668 Mtetra
.40432 .88668 .41645 .84225 .43361 .83254 .42169 .87707 Mtetra
.42169 .87707 .43361 .83254 .45097 .82274 .43926 .86735 Mtetra
.43926 .86735 .45097 .82274 .46851 .81283 .45702 .85753 Mtetra
.45702 .85753 .46851 .81283 .48624 .8028 .47497 .84759 Mtetra
.47497 .84759 .48624 .8028 .50417 .79267 .49313 .83755 Mtetra
.49313 .83755 .50417 .79267 .5223 .78243 .51149 .82739 Mtetra
.51149 .82739 .5223 .78243 .54063 .77207 .53006 .81711 Mtetra
.53006 .81711 .54063 .77207 .55917 .76159 .54884 .80672 Mtetra
.54884 .80672 .55917 .76159 .57791 .751 .56784 .79621 Mtetra
.56784 .79621 .57791 .751 .59687 .74029 .58706 .78558 Mtetra
.58706 .78558 .59687 .74029 .61605 .72945 .6065 .77483 Mtetra
.6065 .77483 .61605 .72945 .63544 .71849 .62617 .76395 Mtetra
.62617 .76395 .63544 .71849 .65506 .7074 .64606 .75294 Mtetra
.64606 .75294 .65506 .7074 .67491 .69619 .6662 .7418 Mtetra
.6662 .7418 .67491 .69619 .69499 .68484 .68657 .73053 Mtetra
.68657 .73053 .69499 .68484 .7153 .67336 .70719 .71912 Mtetra
.70719 .71912 .7153 .67336 .73586 .66175 .72805 .70758 Mtetra
.72805 .70758 .73586 .66175 .75666 .64999 .74917 .6959 Mtetra
.74917 .6959 .75666 .64999 .77771 .6381 .77054 .68408 Mtetra
.77054 .68408 .77771 .6381 .79901 .62606 .79217 .67211 Mtetra
.79217 .67211 .79901 .62606 .82057 .61388 .81407 .65999 Mtetra
.81407 .65999 .82057 .61388 .84239 .60155 .83625 .64772 Mtetra
.83625 .64772 .84239 .60155 .86448 .58906 .8587 .6353 Mtetra
.8587 .6353 .86448 .58906 .88684 .57643 .88143 .62273 Mtetra
.88143 .62273 .88684 .57643 .90948 .56363 .90445 .60999 Mtetra
.90445 .60999 .90948 .56363 .9324 .55068 .92776 .5971 Mtetra
.325 .065 .356 r
.34038 .95557 .35333 .91489 .37014 .90559 .35737 .94635 Mtetra
.35737 .94635 .37014 .90559 .38714 .89618 .37455 .93703 Mtetra
.37455 .93703 .38714 .89618 .40432 .88668 .39192 .92761 Mtetra
.39192 .92761 .40432 .88668 .42169 .87707 .40948 .91809 Mtetra
.40948 .91809 .42169 .87707 .43926 .86735 .42723 .90845 Mtetra
.42723 .90845 .43926 .86735 .45702 .85753 .44519 .89871 Mtetra
.44519 .89871 .45702 .85753 .47497 .84759 .46335 .88886 Mtetra
.46335 .88886 .47497 .84759 .49313 .83755 .48172 .8789 Mtetra
.48172 .8789 .49313 .83755 .51149 .82739 .5003 .86882 Mtetra
.5003 .86882 .51149 .82739 .53006 .81711 .51909 .85863 Mtetra
.51909 .85863 .53006 .81711 .54884 .80672 .5381 .84832 Mtetra
.5381 .84832 .54884 .80672 .56784 .79621 .55733 .83788 Mtetra
.55733 .83788 .56784 .79621 .58706 .78558 .57679 .82733 Mtetra
.57679 .82733 .58706 .78558 .6065 .77483 .59647 .81665 Mtetra
.59647 .81665 .6065 .77483 .62617 .76395 .61639 .80585 Mtetra
.61639 .80585 .62617 .76395 .64606 .75294 .63655 .79491 Mtetra
.63655 .79491 .64606 .75294 .6662 .7418 .65695 .78385 Mtetra
.65695 .78385 .6662 .7418 .68657 .73053 .67759 .77265 Mtetra
.67759 .77265 .68657 .73053 .70719 .71912 .69849 .76132 Mtetra
.69849 .76132 .70719 .71912 .72805 .70758 .71964 .74984 Mtetra
.71964 .74984 .72805 .70758 .74917 .6959 .74105 .73823 Mtetra
.74105 .73823 .74917 .6959 .77054 .68408 .76273 .72647 Mtetra
.76273 .72647 .77054 .68408 .79217 .67211 .78467 .71457 Mtetra
.78467 .71457 .79217 .67211 .81407 .65999 .80689 .70251 Mtetra
.80689 .70251 .81407 .65999 .83625 .64772 .8294 .69031 Mtetra
.8294 .69031 .83625 .64772 .8587 .6353 .85218 .67795 Mtetra
.85218 .67795 .8587 .6353 .88143 .62273 .87526 .66543 Mtetra
.87526 .66543 .88143 .62273 .90445 .60999 .89863 .65275 Mtetra
.89863 .65275 .90445 .60999 .92776 .5971 .92231 .63991 Mtetra
.308 .038 .33 r
.32724 .99246 .34038 .95557 .35737 .94635 .34439 .98332 Mtetra
.34439 .98332 .35737 .94635 .37455 .93703 .36173 .97408 Mtetra
.36173 .97408 .37455 .93703 .39192 .92761 .37926 .96474 Mtetra
.37926 .96474 .39192 .92761 .40948 .91809 .39699 .95529 Mtetra
.39699 .95529 .40948 .91809 .42723 .90845 .41493 .94573 Mtetra
.41493 .94573 .42723 .90845 .44519 .89871 .43307 .93607 Mtetra
.43307 .93607 .44519 .89871 .46335 .88886 .45141 .92629 Mtetra
.45141 .92629 .46335 .88886 .48172 .8789 .46997 .91641 Mtetra
.46997 .91641 .48172 .8789 .5003 .86882 .48875 .9064 Mtetra
.48875 .9064 .5003 .86882 .51909 .85863 .50774 .89628 Mtetra
.50774 .89628 .51909 .85863 .5381 .84832 .52696 .88604 Mtetra
.52696 .88604 .5381 .84832 .55733 .83788 .5464 .87568 Mtetra
.5464 .87568 .55733 .83788 .57679 .82733 .56607 .8652 Mtetra
.56607 .8652 .57679 .82733 .59647 .81665 .58599 .85459 Mtetra
.58599 .85459 .59647 .81665 .61639 .80585 .60614 .84386 Mtetra
.60614 .84386 .61639 .80585 .63655 .79491 .62653 .83299 Mtetra
.62653 .83299 .63655 .79491 .65695 .78385 .64717 .82199 Mtetra
.64717 .82199 .65695 .78385 .67759 .77265 .66807 .81086 Mtetra
.66807 .81086 .67759 .77265 .69849 .76132 .68922 .79959 Mtetra
.68922 .79959 .69849 .76132 .71964 .74984 .71064 .78818 Mtetra
.71064 .78818 .71964 .74984 .74105 .73823 .73232 .77663 Mtetra
.73232 .77663 .74105 .73823 .76273 .72647 .75427 .76493 Mtetra
.75427 .76493 .76273 .72647 .78467 .71457 .77651 .75308 Mtetra
.77651 .75308 .78467 .71457 .80689 .70251 .79902 .74109 Mtetra
.79902 .74109 .80689 .70251 .8294 .69031 .82183 .72894 Mtetra
.82183 .72894 .8294 .69031 .85218 .67795 .84492 .71663 Mtetra
.84492 .71663 .85218 .67795 .87526 .66543 .86832 .70416 Mtetra
.86832 .70416 .87526 .66543 .89863 .65275 .89202 .69154 Mtetra
.89202 .69154 .89863 .65275 .92231 .63991 .91604 .67874 Mtetra
.287 .002 .295 r
.31394 1.02527 .32724 .99246 .34439 .98332 .33123 1.0162 Mtetra
.33123 1.0162 .34439 .98332 .36173 .97408 .34871 1.00703 Mtetra
.34871 1.00703 .36173 .97408 .37926 .96474 .36639 .99776 Mtetra
.36639 .99776 .37926 .96474 .39699 .95529 .38428 .98838 Mtetra
.38428 .98838 .39699 .95529 .41493 .94573 .40237 .97889 Mtetra
.40237 .97889 .41493 .94573 .43307 .93607 .42067 .96929 Mtetra
.42067 .96929 .43307 .93607 .45141 .92629 .43918 .95958 Mtetra
.43918 .95958 .45141 .92629 .46997 .91641 .45791 .94976 Mtetra
.45791 .94976 .46997 .91641 .48875 .9064 .47686 .93982 Mtetra
.47686 .93982 .48875 .9064 .50774 .89628 .49604 .92977 Mtetra
.49604 .92977 .50774 .89628 .52696 .88604 .51544 .91959 Mtetra
.51544 .91959 .52696 .88604 .5464 .87568 .53507 .90929 Mtetra
.53507 .90929 .5464 .87568 .56607 .8652 .55495 .89887 Mtetra
.55495 .89887 .56607 .8652 .58599 .85459 .57506 .88832 Mtetra
.57506 .88832 .58599 .85459 .60614 .84386 .59542 .87765 Mtetra
.59542 .87765 .60614 .84386 .62653 .83299 .61602 .86684 Mtetra
.61602 .86684 .62653 .83299 .64717 .82199 .63689 .8559 Mtetra
.63689 .8559 .64717 .82199 .66807 .81086 .65801 .84482 Mtetra
.65801 .84482 .66807 .81086 .68922 .79959 .67939 .83361 Mtetra
.67939 .83361 .68922 .79959 .71064 .78818 .70105 .82225 Mtetra
.70105 .82225 .71064 .78818 .73232 .77663 .72298 .81075 Mtetra
.72298 .81075 .73232 .77663 .75427 .76493 .74518 .7991 Mtetra
.74518 .7991 .75427 .76493 .77651 .75308 .76768 .78731 Mtetra
.76768 .78731 .77651 .75308 .79902 .74109 .79046 .77536 Mtetra
.79046 .77536 .79902 .74109 .82183 .72894 .81354 .76326 Mtetra
.81354 .76326 .82183 .72894 .84492 .71663 .83692 .75099 Mtetra
.83692 .75099 .84492 .71663 .86832 .70416 .86061 .73857 Mtetra
.86061 .73857 .86832 .70416 .89202 .69154 .88461 .72598 Mtetra
.88461 .72598 .89202 .69154 .91604 .67874 .90893 .71323 Mtetra
.256 0 .246 r
.30052 1.05372 .31394 1.02527 .33123 1.0162 .31793 1.04472 Mtetra
.31793 1.04472 .33123 1.0162 .34871 1.00703 .33554 1.0356 Mtetra
.33554 1.0356 .34871 1.00703 .36639 .99776 .35336 1.02639 Mtetra
.35336 1.02639 .36639 .99776 .38428 .98838 .37137 1.01706 Mtetra
.37137 1.01706 .38428 .98838 .40237 .97889 .3896 1.00763 Mtetra
.3896 1.00763 .40237 .97889 .42067 .96929 .40804 .99809 Mtetra
.40804 .99809 .42067 .96929 .43918 .95958 .4267 .98843 Mtetra
.4267 .98843 .43918 .95958 .45791 .94976 .44558 .97867 Mtetra
.44558 .97867 .45791 .94976 .47686 .93982 .46468 .96878 Mtetra
.46468 .96878 .47686 .93982 .49604 .92977 .48402 .95878 Mtetra
.48402 .95878 .49604 .92977 .51544 .91959 .50358 .94865 Mtetra
.50358 .94865 .51544 .91959 .53507 .90929 .52338 .93841 Mtetra
.52338 .93841 .53507 .90929 .55495 .89887 .54343 .92803 Mtetra
.54343 .92803 .55495 .89887 .57506 .88832 .56372 .91753 Mtetra
.56372 .91753 .57506 .88832 .59542 .87765 .58426 .90691 Mtetra
.58426 .90691 .59542 .87765 .61602 .86684 .60506 .89615 Mtetra
.60506 .89615 .61602 .86684 .63689 .8559 .62611 .88525 Mtetra
.62611 .88525 .63689 .8559 .65801 .84482 .64743 .87422 Mtetra
.64743 .87422 .65801 .84482 .67939 .83361 .66902 .86305 Mtetra
.66902 .86305 .67939 .83361 .70105 .82225 .69089 .85173 Mtetra
.69089 .85173 .70105 .82225 .72298 .81075 .71304 .84027 Mtetra
.71304 .84027 .72298 .81075 .74518 .7991 .73547 .82866 Mtetra
.73547 .82866 .74518 .7991 .76768 .78731 .75819 .8169 Mtetra
.75819 .8169 .76768 .78731 .79046 .77536 .78121 .80499 Mtetra
.78121 .80499 .79046 .77536 .81354 .76326 .80454 .79292 Mtetra
.80454 .79292 .81354 .76326 .83692 .75099 .82817 .7807 Mtetra
.82817 .7807 .83692 .75099 .86061 .73857 .85212 .7683 Mtetra
.85212 .7683 .86061 .73857 .88461 .72598 .87639 .75575 Mtetra
.87639 .75575 .88461 .72598 .90893 .71323 .90098 .74302 Mtetra
.212 0 .175 r
.28705 1.07757 .30052 1.05372 .31793 1.04472 .30456 1.06861 Mtetra
.30456 1.06861 .31793 1.04472 .33554 1.0356 .32227 1.05954 Mtetra
.32227 1.05954 .33554 1.0356 .35336 1.02639 .34019 1.05036 Mtetra
.34019 1.05036 .35336 1.02639 .37137 1.01706 .35832 1.04108 Mtetra
.35832 1.04108 .37137 1.01706 .3896 1.00763 .37667 1.03169 Mtetra
.37667 1.03169 .3896 1.00763 .40804 .99809 .39523 1.02219 Mtetra
.39523 1.02219 .40804 .99809 .4267 .98843 .41401 1.01258 Mtetra
.41401 1.01258 .4267 .98843 .44558 .97867 .43301 1.00285 Mtetra
.43301 1.00285 .44558 .97867 .46468 .96878 .45225 .993 Mtetra
.45225 .993 .46468 .96878 .48402 .95878 .47171 .98304 Mtetra
.47171 .98304 .48402 .95878 .50358 .94865 .49142 .97295 Mtetra
.49142 .97295 .50358 .94865 .52338 .93841 .51136 .96274 Mtetra
.51136 .96274 .52338 .93841 .54343 .92803 .53155 .9524 Mtetra
.53155 .9524 .54343 .92803 .56372 .91753 .552 .94194 Mtetra
.552 .94194 .56372 .91753 .58426 .90691 .57269 .93134 Mtetra
.57269 .93134 .58426 .90691 .60506 .89615 .59365 .92061 Mtetra
.59365 .92061 .60506 .89615 .62611 .88525 .61487 .90975 Mtetra
.61487 .90975 .62611 .88525 .64743 .87422 .63637 .89875 Mtetra
.63637 .89875 .64743 .87422 .66902 .86305 .65813 .8876 Mtetra
.65813 .8876 .66902 .86305 .69089 .85173 .68018 .87632 Mtetra
.68018 .87632 .69089 .85173 .71304 .84027 .70252 .86488 Mtetra
.70252 .86488 .71304 .84027 .73547 .82866 .72514 .8533 Mtetra
.72514 .8533 .73547 .82866 .75819 .8169 .74807 .84156 Mtetra
.74807 .84156 .75819 .8169 .78121 .80499 .77129 .82967 Mtetra
.77129 .82967 .78121 .80499 .80454 .79292 .79483 .81763 Mtetra
.79483 .81763 .80454 .79292 .82817 .7807 .81868 .80542 Mtetra
.81868 .80542 .82817 .7807 .85212 .7683 .84285 .79304 Mtetra
.84285 .79304 .85212 .7683 .87639 .75575 .86736 .7805 Mtetra
.86736 .7805 .87639 .75575 .90098 .74302 .89219 .76778 Mtetra
.142 0 .063 r
.27355 1.09657 .28705 1.07757 .30456 1.06861 .29114 1.08763 Mtetra
.29114 1.08763 .30456 1.06861 .32227 1.05954 .30894 1.07859 Mtetra
.30894 1.07859 .32227 1.05954 .34019 1.05036 .32695 1.06945 Mtetra
.32695 1.06945 .34019 1.05036 .35832 1.04108 .34517 1.06019 Mtetra
.34517 1.06019 .35832 1.04108 .37667 1.03169 .36361 1.05083 Mtetra
.36361 1.05083 .37667 1.03169 .39523 1.02219 .38226 1.04135 Mtetra
.38226 1.04135 .39523 1.02219 .41401 1.01258 .40114 1.03176 Mtetra
.40114 1.03176 .41401 1.01258 .43301 1.00285 .42025 1.02206 Mtetra
.42025 1.02206 .43301 1.00285 .45225 .993 .43959 1.01223 Mtetra
.43959 1.01223 .45225 .993 .47171 .98304 .45917 1.00229 Mtetra
.45917 1.00229 .47171 .98304 .49142 .97295 .47898 .99222 Mtetra
.47898 .99222 .49142 .97295 .51136 .96274 .49905 .98203 Mtetra
.49905 .98203 .51136 .96274 .53155 .9524 .51936 .97171 Mtetra
.51936 .97171 .53155 .9524 .552 .94194 .53993 .96127 Mtetra
.53993 .96127 .552 .94194 .57269 .93134 .56075 .95069 Mtetra
.56075 .95069 .57269 .93134 .59365 .92061 .58184 .93998 Mtetra
.58184 .93998 .59365 .92061 .61487 .90975 .60321 .92913 Mtetra
.60321 .92913 .61487 .90975 .63637 .89875 .62484 .91814 Mtetra
.62484 .91814 .63637 .89875 .65813 .8876 .64675 .90701 Mtetra
.64675 .90701 .65813 .8876 .68018 .87632 .66895 .89573 Mtetra
.66895 .89573 .68018 .87632 .70252 .86488 .69145 .88431 Mtetra
.69145 .88431 .70252 .86488 .72514 .8533 .71423 .87273 Mtetra
.71423 .87273 .72514 .8533 .74807 .84156 .73732 .861 Mtetra
.73732 .861 .74807 .84156 .77129 .82967 .76072 .84912 Mtetra
.76072 .84912 .77129 .82967 .79483 .81763 .78444 .83707 Mtetra
.78444 .83707 .79483 .81763 .81868 .80542 .80847 .82486 Mtetra
.80847 .82486 .81868 .80542 .84285 .79304 .83284 .81249 Mtetra
.83284 .81249 .84285 .79304 .86736 .7805 .85753 .79994 Mtetra
.85753 .79994 .86736 .7805 .89219 .76778 .88257 .78722 Mtetra
.019 0 0 r
.26009 1.11052 .27355 1.09657 .29114 1.08763 .27774 1.1016 Mtetra
.27774 1.1016 .29114 1.08763 .30894 1.07859 .2956 1.09256 Mtetra
.2956 1.09256 .30894 1.07859 .32695 1.06945 .31368 1.08343 Mtetra
.31368 1.08343 .32695 1.06945 .34517 1.06019 .33196 1.07418 Mtetra
.33196 1.07418 .34517 1.06019 .36361 1.05083 .35047 1.06482 Mtetra
.35047 1.06482 .36361 1.05083 .38226 1.04135 .3692 1.05536 Mtetra
.3692 1.05536 .38226 1.04135 .40114 1.03176 .38815 1.04577 Mtetra
.38815 1.04577 .40114 1.03176 .42025 1.02206 .40734 1.03607 Mtetra
.40734 1.03607 .42025 1.02206 .43959 1.01223 .42676 1.02625 Mtetra
.42676 1.02625 .43959 1.01223 .45917 1.00229 .44642 1.01631 Mtetra
.44642 1.01631 .45917 1.00229 .47898 .99222 .46633 1.00625 Mtetra
.46633 1.00625 .47898 .99222 .49905 .98203 .48648 .99606 Mtetra
.48648 .99606 .49905 .98203 .51936 .97171 .50689 .98574 Mtetra
.50689 .98574 .51936 .97171 .53993 .96127 .52755 .97529 Mtetra
.52755 .97529 .53993 .96127 .56075 .95069 .54848 .96471 Mtetra
.54848 .96471 .56075 .95069 .58184 .93998 .56967 .954 Mtetra
.56967 .954 .58184 .93998 .60321 .92913 .59114 .94314 Mtetra
.59114 .94314 .60321 .92913 .62484 .91814 .61289 .93215 Mtetra
.61289 .93215 .62484 .91814 .64675 .90701 .63492 .92101 Mtetra
.63492 .92101 .64675 .90701 .66895 .89573 .65724 .90973 Mtetra
.65724 .90973 .66895 .89573 .69145 .88431 .67985 .89829 Mtetra
.67985 .89829 .69145 .88431 .71423 .87273 .70277 .88671 Mtetra
.70277 .88671 .71423 .87273 .73732 .861 .72599 .87497 Mtetra
.72599 .87497 .73732 .861 .76072 .84912 .74953 .86307 Mtetra
.74953 .86307 .76072 .84912 .78444 .83707 .77338 .85101 Mtetra
.77338 .85101 .78444 .83707 .80847 .82486 .79757 .83878 Mtetra
.79757 .83878 .80847 .82486 .83284 .81249 .82208 .82639 Mtetra
.82208 .82639 .83284 .81249 .85753 .79994 .84694 .81382 Mtetra
.84694 .81382 .85753 .79994 .88257 .78722 .87214 .80108 Mtetra
0 0 0 r
.24671 1.11925 .26009 1.11052 .27774 1.1016 .26441 1.11031 Mtetra
.26441 1.11031 .27774 1.1016 .2956 1.09256 .28231 1.10127 Mtetra
.28231 1.10127 .2956 1.09256 .31368 1.08343 .30042 1.09213 Mtetra
.30042 1.09213 .31368 1.08343 .33196 1.07418 .31876 1.08287 Mtetra
.31876 1.08287 .33196 1.07418 .35047 1.06482 .33731 1.0735 Mtetra
.33731 1.0735 .35047 1.06482 .3692 1.05536 .35609 1.06402 Mtetra
.35609 1.06402 .3692 1.05536 .38815 1.04577 .37509 1.05442 Mtetra
.37509 1.05442 .38815 1.04577 .40734 1.03607 .39433 1.04471 Mtetra
.39433 1.04471 .40734 1.03607 .42676 1.02625 .41381 1.03487 Mtetra
.41381 1.03487 .42676 1.02625 .44642 1.01631 .43353 1.02492 Mtetra
.43353 1.02492 .44642 1.01631 .46633 1.00625 .45349 1.01484 Mtetra
.45349 1.01484 .46633 1.00625 .48648 .99606 .47371 1.00463 Mtetra
.47371 1.00463 .48648 .99606 .50689 .98574 .49418 .99429 Mtetra
.49418 .99429 .50689 .98574 .52755 .97529 .51491 .98382 Mtetra
.51491 .98382 .52755 .97529 .54848 .96471 .53591 .97322 Mtetra
.53591 .97322 .54848 .96471 .56967 .954 .55718 .96248 Mtetra
.55718 .96248 .56967 .954 .59114 .94314 .57873 .9516 Mtetra
.57873 .9516 .59114 .94314 .61289 .93215 .60055 .94058 Mtetra
.60055 .94058 .61289 .93215 .63492 .92101 .62266 .92942 Mtetra
.62266 .92942 .63492 .92101 .65724 .90973 .64507 .9181 Mtetra
.64507 .9181 .65724 .90973 .67985 .89829 .66777 .90664 Mtetra
.66777 .90664 .67985 .89829 .70277 .88671 .69078 .89502 Mtetra
.69078 .89502 .70277 .88671 .72599 .87497 .7141 .88325 Mtetra
.7141 .88325 .72599 .87497 .74953 .86307 .73774 .87131 Mtetra
.73774 .87131 .74953 .86307 .77338 .85101 .7617 .85921 Mtetra
.7617 .85921 .77338 .85101 .79757 .83878 .78599 .84695 Mtetra
.78599 .84695 .79757 .83878 .82208 .82639 .81062 .83451 Mtetra
.81062 .83451 .82208 .82639 .84694 .81382 .83559 .8219 Mtetra
.83559 .8219 .84694 .81382 .87214 .80108 .86091 .80912 Mtetra
.501 .909 .873 r
.23348 1.12261 .24671 1.11925 .26441 1.11031 .25119 1.11365 Mtetra
.25119 1.11365 .26441 1.11031 .28231 1.10127 .26911 1.10458 Mtetra
.26911 1.10458 .28231 1.10127 .30042 1.09213 .28724 1.0954 Mtetra
.28724 1.0954 .30042 1.09213 .31876 1.08287 .3056 1.08611 Mtetra
.3056 1.08611 .31876 1.08287 .33731 1.0735 .32417 1.07671 Mtetra
.32417 1.07671 .33731 1.0735 .35609 1.06402 .34298 1.0672 Mtetra
.34298 1.0672 .35609 1.06402 .37509 1.05442 .36201 1.05757 Mtetra
.36201 1.05757 .37509 1.05442 .39433 1.04471 .38128 1.04782 Mtetra
.38128 1.04782 .39433 1.04471 .41381 1.03487 .40078 1.03795 Mtetra
.40078 1.03795 .41381 1.03487 .43353 1.02492 .42053 1.02795 Mtetra
.42053 1.02795 .43353 1.02492 .45349 1.01484 .44053 1.01783 Mtetra
.44053 1.01783 .45349 1.01484 .47371 1.00463 .46078 1.00759 Mtetra
.46078 1.00759 .47371 1.00463 .49418 .99429 .48129 .99721 Mtetra
.48129 .99721 .49418 .99429 .51491 .98382 .50206 .9867 Mtetra
.50206 .9867 .51491 .98382 .53591 .97322 .5231 .97605 Mtetra
.5231 .97605 .53591 .97322 .55718 .96248 .54441 .96527 Mtetra
.54441 .96527 .55718 .96248 .57873 .9516 .566 .95434 Mtetra
.566 .95434 .57873 .9516 .60055 .94058 .58787 .94327 Mtetra
.58787 .94327 .60055 .94058 .62266 .92942 .61004 .93206 Mtetra
.61004 .93206 .62266 .92942 .64507 .9181 .63249 .92069 Mtetra
.63249 .92069 .64507 .9181 .66777 .90664 .65525 .90917 Mtetra
.65525 .90917 .66777 .90664 .69078 .89502 .67832 .8975 Mtetra
.67832 .8975 .69078 .89502 .7141 .88325 .7017 .88567 Mtetra
.7017 .88567 .7141 .88325 .73774 .87131 .7254 .87368 Mtetra
.7254 .87368 .73774 .87131 .7617 .85921 .74943 .86152 Mtetra
.74943 .86152 .7617 .85921 .78599 .84695 .77378 .84919 Mtetra
.77378 .84919 .78599 .84695 .81062 .83451 .79848 .83669 Mtetra
.79848 .83669 .81062 .83451 .83559 .8219 .82353 .82402 Mtetra
.82353 .82402 .83559 .8219 .86091 .80912 .84893 .81117 Mtetra
.626 .863 .987 r
.22044 1.12051 .23348 1.12261 .25119 1.11365 .23814 1.1115 Mtetra
.23814 1.1115 .25119 1.11365 .26911 1.10458 .25606 1.10238 Mtetra
.25606 1.10238 .26911 1.10458 .28724 1.0954 .27419 1.09315 Mtetra
.27419 1.09315 .28724 1.0954 .3056 1.08611 .29254 1.08381 Mtetra
.29254 1.08381 .3056 1.08611 .32417 1.07671 .31112 1.07436 Mtetra
.31112 1.07436 .32417 1.07671 .34298 1.0672 .32992 1.06479 Mtetra
.32992 1.06479 .34298 1.0672 .36201 1.05757 .34895 1.0551 Mtetra
.34895 1.0551 .36201 1.05757 .38128 1.04782 .36822 1.04529 Mtetra
.36822 1.04529 .38128 1.04782 .40078 1.03795 .38773 1.03537 Mtetra
.38773 1.03537 .40078 1.03795 .42053 1.02795 .40749 1.02531 Mtetra
.40749 1.02531 .42053 1.02795 .44053 1.01783 .42749 1.01513 Mtetra
.42749 1.01513 .44053 1.01783 .46078 1.00759 .44775 1.00482 Mtetra
.44775 1.00482 .46078 1.00759 .48129 .99721 .46826 .99438 Mtetra
.46826 .99438 .48129 .99721 .50206 .9867 .48904 .9838 Mtetra
.48904 .9838 .50206 .9867 .5231 .97605 .51009 .97309 Mtetra
.51009 .97309 .5231 .97605 .54441 .96527 .53141 .96224 Mtetra
.53141 .96224 .54441 .96527 .566 .95434 .55302 .95124 Mtetra
.55302 .95124 .566 .95434 .58787 .94327 .57491 .9401 Mtetra
.57491 .9401 .58787 .94327 .61004 .93206 .59708 .92881 Mtetra
.59708 .92881 .61004 .93206 .63249 .92069 .61956 .91738 Mtetra
.61956 .91738 .63249 .92069 .65525 .90917 .64234 .90578 Mtetra
.64234 .90578 .65525 .90917 .67832 .8975 .66543 .89403 Mtetra
.66543 .89403 .67832 .8975 .7017 .88567 .68883 .88212 Mtetra
.68883 .88212 .7017 .88567 .7254 .87368 .71255 .87005 Mtetra
.71255 .87005 .7254 .87368 .74943 .86152 .7366 .85781 Mtetra
.7366 .85781 .74943 .86152 .77378 .84919 .76099 .84539 Mtetra
.76099 .84539 .77378 .84919 .79848 .83669 .78572 .83281 Mtetra
.78572 .83281 .79848 .83669 .82353 .82402 .8108 .82004 Mtetra
.8108 .82004 .82353 .82402 .84893 .81117 .83624 .8071 Mtetra
.613 .716 .919 r
.20764 1.11289 .22044 1.12051 .23814 1.1115 .22532 1.10381 Mtetra
.22532 1.10381 .23814 1.1115 .25606 1.10238 .24321 1.09462 Mtetra
.24321 1.09462 .25606 1.10238 .27419 1.09315 .26132 1.08532 Mtetra
.26132 1.08532 .27419 1.09315 .29254 1.08381 .27965 1.0759 Mtetra
.27965 1.0759 .29254 1.08381 .31112 1.07436 .2982 1.06637 Mtetra
.2982 1.06637 .31112 1.07436 .32992 1.06479 .31697 1.05673 Mtetra
.31697 1.05673 .32992 1.06479 .34895 1.0551 .33598 1.04696 Mtetra
.33598 1.04696 .34895 1.0551 .36822 1.04529 .35523 1.03708 Mtetra
.35523 1.03708 .36822 1.04529 .38773 1.03537 .37471 1.02707 Mtetra
.37471 1.02707 .38773 1.03537 .40749 1.02531 .39445 1.01693 Mtetra
.39445 1.01693 .40749 1.02531 .42749 1.01513 .41443 1.00666 Mtetra
.41443 1.00666 .42749 1.01513 .44775 1.00482 .43466 .99627 Mtetra
.43466 .99627 .44775 1.00482 .46826 .99438 .45516 .98574 Mtetra
.45516 .98574 .46826 .99438 .48904 .9838 .47591 .97508 Mtetra
.47591 .97508 .48904 .9838 .51009 .97309 .49694 .96428 Mtetra
.49694 .96428 .51009 .97309 .53141 .96224 .51825 .95333 Mtetra
.51825 .95333 .53141 .96224 .55302 .95124 .53983 .94224 Mtetra
.53983 .94224 .55302 .95124 .57491 .9401 .5617 .93101 Mtetra
.5617 .93101 .57491 .9401 .59708 .92881 .58386 .91962 Mtetra
.58386 .91962 .59708 .92881 .61956 .91738 .60632 .90809 Mtetra
.60632 .90809 .61956 .91738 .64234 .90578 .62908 .89639 Mtetra
.62908 .89639 .64234 .90578 .66543 .89403 .65215 .88454 Mtetra
.65215 .88454 .66543 .89403 .68883 .88212 .67554 .87253 Mtetra
.67554 .87253 .68883 .88212 .71255 .87005 .69925 .86035 Mtetra
.69925 .86035 .71255 .87005 .7366 .85781 .72329 .848 Mtetra
.72329 .848 .7366 .85781 .76099 .84539 .74766 .83548 Mtetra
.74766 .83548 .76099 .84539 .78572 .83281 .77238 .82278 Mtetra
.77238 .82278 .78572 .83281 .8108 .82004 .79745 .8099 Mtetra
.79745 .8099 .8108 .82004 .83624 .8071 .82288 .79684 Mtetra
.579 .603 .841 r
.19515 1.09973 .20764 1.11289 .22532 1.10381 .21278 1.09056 Mtetra
.21278 1.09056 .22532 1.10381 .24321 1.09462 .23062 1.08128 Mtetra
.23062 1.08128 .24321 1.09462 .26132 1.08532 .24868 1.07188 Mtetra
.24868 1.07188 .26132 1.08532 .27965 1.0759 .26696 1.06237 Mtetra
.26696 1.06237 .27965 1.0759 .2982 1.06637 .28546 1.05274 Mtetra
.28546 1.05274 .2982 1.06637 .31697 1.05673 .30419 1.043 Mtetra
.30419 1.043 .31697 1.05673 .33598 1.04696 .32315 1.03313 Mtetra
.32315 1.03313 .33598 1.04696 .35523 1.03708 .34235 1.02314 Mtetra
.34235 1.02314 .35523 1.03708 .37471 1.02707 .36178 1.01303 Mtetra
.36178 1.01303 .37471 1.02707 .39445 1.01693 .38146 1.00279 Mtetra
.38146 1.00279 .39445 1.01693 .41443 1.00666 .40139 .99242 Mtetra
.40139 .99242 .41443 1.00666 .43466 .99627 .42158 .98192 Mtetra
.42158 .98192 .43466 .99627 .45516 .98574 .44202 .97128 Mtetra
.44202 .97128 .45516 .98574 .47591 .97508 .46273 .9605 Mtetra
.46273 .9605 .47591 .97508 .49694 .96428 .48371 .94959 Mtetra
.48371 .94959 .49694 .96428 .51825 .95333 .50496 .93853 Mtetra
.50496 .93853 .51825 .95333 .53983 .94224 .52649 .92733 Mtetra
.52649 .92733 .53983 .94224 .5617 .93101 .54831 .91598 Mtetra
.54831 .91598 .5617 .93101 .58386 .91962 .57042 .90447 Mtetra
.57042 .90447 .58386 .91962 .60632 .90809 .59282 .89281 Mtetra
.59282 .89281 .60632 .90809 .62908 .89639 .61553 .881 Mtetra
.61553 .881 .62908 .89639 .65215 .88454 .63855 .86902 Mtetra
.63855 .86902 .65215 .88454 .67554 .87253 .66189 .85688 Mtetra
.66189 .85688 .67554 .87253 .69925 .86035 .68554 .84457 Mtetra
.68554 .84457 .69925 .86035 .72329 .848 .70953 .83209 Mtetra
.70953 .83209 .72329 .848 .74766 .83548 .73385 .81943 Mtetra
.73385 .81943 .74766 .83548 .77238 .82278 .75852 .8066 Mtetra
.75852 .8066 .77238 .82278 .79745 .8099 .78353 .79358 Mtetra
.78353 .79358 .79745 .8099 .82288 .79684 .80891 .78038 Mtetra
.549 .526 .782 r
.183 1.08107 .19515 1.09973 .21278 1.09056 .20057 1.07178 Mtetra
.20057 1.07178 .21278 1.09056 .23062 1.08128 .21834 1.06238 Mtetra
.21834 1.06238 .23062 1.08128 .24868 1.07188 .23633 1.05287 Mtetra
.23633 1.05287 .24868 1.07188 .26696 1.06237 .25454 1.04324 Mtetra
.25454 1.04324 .26696 1.06237 .28546 1.05274 .27296 1.03349 Mtetra
.27296 1.03349 .28546 1.05274 .30419 1.043 .29162 1.02363 Mtetra
.29162 1.02363 .30419 1.043 .32315 1.03313 .31051 1.01364 Mtetra
.31051 1.01364 .32315 1.03313 .34235 1.02314 .32963 1.00353 Mtetra
.32963 1.00353 .34235 1.02314 .36178 1.01303 .34899 .99329 Mtetra
.34899 .99329 .36178 1.01303 .38146 1.00279 .36859 .98292 Mtetra
.36859 .98292 .38146 1.00279 .40139 .99242 .38845 .97243 Mtetra
.38845 .97243 .40139 .99242 .42158 .98192 .40855 .96179 Mtetra
.40855 .96179 .42158 .98192 .44202 .97128 .42892 .95102 Mtetra
.42892 .95102 .44202 .97128 .46273 .9605 .44954 .94012 Mtetra
.44954 .94012 .46273 .9605 .48371 .94959 .47044 .92907 Mtetra
.47044 .92907 .48371 .94959 .50496 .93853 .49161 .91787 Mtetra
.49161 .91787 .50496 .93853 .52649 .92733 .51306 .90653 Mtetra
.51306 .90653 .52649 .92733 .54831 .91598 .53479 .89504 Mtetra
.53479 .89504 .54831 .91598 .57042 .90447 .55682 .88339 Mtetra
.55682 .88339 .57042 .90447 .59282 .89281 .57914 .87159 Mtetra
.57914 .87159 .59282 .89281 .61553 .881 .60176 .85962 Mtetra
.60176 .85962 .61553 .881 .63855 .86902 .62469 .8475 Mtetra
.62469 .8475 .63855 .86902 .66189 .85688 .64793 .83521 Mtetra
.64793 .83521 .66189 .85688 .68554 .84457 .6715 .82274 Mtetra
.6715 .82274 .68554 .84457 .70953 .83209 .69539 .81011 Mtetra
.69539 .81011 .70953 .83209 .73385 .81943 .71962 .7973 Mtetra
.71962 .7973 .73385 .81943 .75852 .8066 .74419 .7843 Mtetra
.74419 .7843 .75852 .8066 .78353 .79358 .76911 .77113 Mtetra
.76911 .77113 .78353 .79358 .80891 .78038 .79439 .75776 Mtetra
.526 .473 .739 r
.17126 1.05696 .183 1.08107 .20057 1.07178 .18873 1.04753 Mtetra
.18873 1.04753 .20057 1.07178 .21834 1.06238 .20641 1.038 Mtetra
.20641 1.038 .21834 1.06238 .23633 1.05287 .22431 1.02835 Mtetra
.22431 1.02835 .23633 1.05287 .25454 1.04324 .24242 1.01859 Mtetra
.24242 1.01859 .25454 1.04324 .27296 1.03349 .26076 1.0087 Mtetra
.26076 1.0087 .27296 1.03349 .29162 1.02363 .27932 .9987 Mtetra
.27932 .9987 .29162 1.02363 .31051 1.01364 .2981 .98857 Mtetra
.2981 .98857 .31051 1.01364 .32963 1.00353 .31713 .97831 Mtetra
.31713 .97831 .32963 1.00353 .34899 .99329 .33639 .96793 Mtetra
.33639 .96793 .34899 .99329 .36859 .98292 .35589 .95741 Mtetra
.35589 .95741 .36859 .98292 .38845 .97243 .37564 .94676 Mtetra
.37564 .94676 .38845 .97243 .40855 .96179 .39564 .93598 Mtetra
.39564 .93598 .40855 .96179 .42892 .95102 .4159 .92506 Mtetra
.4159 .92506 .42892 .95102 .44954 .94012 .43642 .914 Mtetra
.43642 .914 .44954 .94012 .47044 .92907 .4572 .90279 Mtetra
.4572 .90279 .47044 .92907 .49161 .91787 .47826 .89144 Mtetra
.47826 .89144 .49161 .91787 .51306 .90653 .49959 .87993 Mtetra
.49959 .87993 .51306 .90653 .53479 .89504 .52121 .86828 Mtetra
.52121 .86828 .53479 .89504 .55682 .88339 .54312 .85647 Mtetra
.54312 .85647 .55682 .88339 .57914 .87159 .56532 .8445 Mtetra
.56532 .8445 .57914 .87159 .60176 .85962 .58782 .83237 Mtetra
.58782 .83237 .60176 .85962 .62469 .8475 .61062 .82007 Mtetra
.61062 .82007 .62469 .8475 .64793 .83521 .63374 .80761 Mtetra
.63374 .80761 .64793 .83521 .6715 .82274 .65718 .79497 Mtetra
.65718 .79497 .6715 .82274 .69539 .81011 .68094 .78216 Mtetra
.68094 .78216 .69539 .81011 .71962 .7973 .70504 .76917 Mtetra
.70504 .76917 .71962 .7973 .74419 .7843 .72947 .756 Mtetra
.72947 .756 .74419 .7843 .76911 .77113 .75426 .74263 Mtetra
.75426 .74263 .76911 .77113 .79439 .75776 .77939 .72908 Mtetra
.509 .434 .707 r
.15995 1.02751 .17126 1.05696 .18873 1.04753 .17732 1.01794 Mtetra
.17732 1.01794 .18873 1.04753 .20641 1.038 .19489 1.00825 Mtetra
.19489 1.00825 .20641 1.038 .22431 1.02835 .21267 .99845 Mtetra
.21267 .99845 .22431 1.02835 .24242 1.01859 .23067 .98853 Mtetra
.23067 .98853 .24242 1.01859 .26076 1.0087 .24889 .97848 Mtetra
.24889 .97848 .26076 1.0087 .27932 .9987 .26733 .96832 Mtetra
.26733 .96832 .27932 .9987 .2981 .98857 .28599 .95803 Mtetra
.28599 .95803 .2981 .98857 .31713 .97831 .30489 .94761 Mtetra
.30489 .94761 .31713 .97831 .33639 .96793 .32403 .93706 Mtetra
.32403 .93706 .33639 .96793 .35589 .95741 .3434 .92638 Mtetra
.3434 .92638 .35589 .95741 .37564 .94676 .36302 .91556 Mtetra
.36302 .91556 .37564 .94676 .39564 .93598 .38289 .90461 Mtetra
.38289 .90461 .39564 .93598 .4159 .92506 .40302 .89351 Mtetra
.40302 .89351 .4159 .92506 .43642 .914 .4234 .88228 Mtetra
.4234 .88228 .43642 .914 .4572 .90279 .44404 .87089 Mtetra
.44404 .87089 .4572 .90279 .47826 .89144 .46496 .85936 Mtetra
.46496 .85936 .47826 .89144 .49959 .87993 .48615 .84768 Mtetra
.48615 .84768 .49959 .87993 .52121 .86828 .50762 .83584 Mtetra
.50762 .83584 .52121 .86828 .54312 .85647 .52938 .82385 Mtetra
.52938 .82385 .54312 .85647 .56532 .8445 .55142 .81169 Mtetra
.55142 .81169 .56532 .8445 .58782 .83237 .57377 .79938 Mtetra
.57377 .79938 .58782 .83237 .61062 .82007 .59642 .78689 Mtetra
.59642 .78689 .61062 .82007 .63374 .80761 .61937 .77423 Mtetra
.61937 .77423 .63374 .80761 .65718 .79497 .64265 .7614 Mtetra
.64265 .7614 .65718 .79497 .68094 .78216 .66624 .74839 Mtetra
.66624 .74839 .68094 .78216 .70504 .76917 .69017 .7352 Mtetra
.69017 .7352 .70504 .76917 .72947 .756 .71443 .72183 Mtetra
.71443 .72183 .72947 .756 .75426 .74263 .73904 .70826 Mtetra
.73904 .70826 .75426 .74263 .77939 .72908 .76399 .69451 Mtetra
.494 .404 .682 r
.14913 .9929 .15995 1.02751 .17732 1.01794 .16636 .98315 Mtetra
.16636 .98315 .17732 1.01794 .19489 1.00825 .18381 .9733 Mtetra
.18381 .9733 .19489 1.00825 .21267 .99845 .20146 .96332 Mtetra
.20146 .96332 .21267 .99845 .23067 .98853 .21932 .95322 Mtetra
.21932 .95322 .23067 .98853 .24889 .97848 .2374 .943 Mtetra
.2374 .943 .24889 .97848 .26733 .96832 .2557 .93266 Mtetra
.2557 .93266 .26733 .96832 .28599 .95803 .27422 .92219 Mtetra
.27422 .92219 .28599 .95803 .30489 .94761 .29298 .91159 Mtetra
.29298 .91159 .30489 .94761 .32403 .93706 .31196 .90086 Mtetra
.31196 .90086 .32403 .93706 .3434 .92638 .33119 .88999 Mtetra
.33119 .88999 .3434 .92638 .36302 .91556 .35065 .87899 Mtetra
.35065 .87899 .36302 .91556 .38289 .90461 .37036 .86785 Mtetra
.37036 .86785 .38289 .90461 .40302 .89351 .39033 .85656 Mtetra
.39033 .85656 .40302 .89351 .4234 .88228 .41055 .84513 Mtetra
.41055 .84513 .4234 .88228 .44404 .87089 .43103 .83356 Mtetra
.43103 .83356 .44404 .87089 .46496 .85936 .45177 .82183 Mtetra
.45177 .82183 .46496 .85936 .48615 .84768 .47279 .80995 Mtetra
.47279 .80995 .48615 .84768 .50762 .83584 .49408 .79792 Mtetra
.49408 .79792 .50762 .83584 .52938 .82385 .51566 .78572 Mtetra
.51566 .78572 .52938 .82385 .55142 .81169 .53752 .77336 Mtetra
.53752 .77336 .55142 .81169 .57377 .79938 .55968 .76084 Mtetra
.55968 .76084 .57377 .79938 .59642 .78689 .58214 .74814 Mtetra
.58214 .74814 .59642 .78689 .61937 .77423 .6049 .73528 Mtetra
.6049 .73528 .61937 .77423 .64265 .7614 .62798 .72223 Mtetra
.62798 .72223 .64265 .7614 .66624 .74839 .65137 .70901 Mtetra
.65137 .70901 .66624 .74839 .69017 .7352 .67509 .69561 Mtetra
.67509 .69561 .69017 .7352 .71443 .72183 .69914 .68201 Mtetra
.69914 .68201 .71443 .72183 .73904 .70826 .72352 .66823 Mtetra
.72352 .66823 .73904 .70826 .76399 .69451 .74826 .65425 Mtetra
.483 .38 .662 r
.13882 .95329 .14913 .9929 .16636 .98315 .15591 .94337 Mtetra
.15591 .94337 .16636 .98315 .18381 .9733 .17321 .93332 Mtetra
.17321 .93332 .18381 .9733 .20146 .96332 .1907 .92316 Mtetra
.1907 .92316 .20146 .96332 .21932 .95322 .20841 .91287 Mtetra
.20841 .91287 .21932 .95322 .2374 .943 .22633 .90246 Mtetra
.22633 .90246 .2374 .943 .2557 .93266 .24447 .89192 Mtetra
.24447 .89192 .2557 .93266 .27422 .92219 .26283 .88126 Mtetra
.26283 .88126 .27422 .92219 .29298 .91159 .28142 .87046 Mtetra
.28142 .87046 .29298 .91159 .31196 .90086 .30023 .85953 Mtetra
.30023 .85953 .31196 .90086 .33119 .88999 .31928 .84847 Mtetra
.31928 .84847 .33119 .88999 .35065 .87899 .33857 .83726 Mtetra
.33857 .83726 .35065 .87899 .37036 .86785 .3581 .82592 Mtetra
.3581 .82592 .37036 .86785 .39033 .85656 .37788 .81443 Mtetra
.37788 .81443 .39033 .85656 .41055 .84513 .39791 .80279 Mtetra
.39791 .80279 .41055 .84513 .43103 .83356 .4182 .79101 Mtetra
.4182 .79101 .43103 .83356 .45177 .82183 .43875 .77907 Mtetra
.43875 .77907 .45177 .82183 .47279 .80995 .45957 .76698 Mtetra
.45957 .76698 .47279 .80995 .49408 .79792 .48066 .75472 Mtetra
.48066 .75472 .49408 .79792 .51566 .78572 .50202 .74231 Mtetra
.50202 .74231 .51566 .78572 .53752 .77336 .52367 .72974 Mtetra
.52367 .72974 .53752 .77336 .55968 .76084 .54561 .71699 Mtetra
.54561 .71699 .55968 .76084 .58214 .74814 .56785 .70407 Mtetra
.56785 .70407 .58214 .74814 .6049 .73528 .59039 .69098 Mtetra
.59039 .69098 .6049 .73528 .62798 .72223 .61323 .67771 Mtetra
.61323 .67771 .62798 .72223 .65137 .70901 .63638 .66426 Mtetra
.63638 .66426 .65137 .70901 .67509 .69561 .65986 .65063 Mtetra
.65986 .65063 .67509 .69561 .69914 .68201 .68366 .6368 Mtetra
.68366 .6368 .69914 .68201 .72352 .66823 .7078 .62278 Mtetra
.7078 .62278 .72352 .66823 .74826 .65425 .73227 .60856 Mtetra
.473 .361 .646 r
.12907 .90893 .13882 .95329 .15591 .94337 .146 .8988 Mtetra
.146 .8988 .15591 .94337 .17321 .93332 .16312 .88856 Mtetra
.16312 .88856 .17321 .93332 .1907 .92316 .18045 .87819 Mtetra
.18045 .87819 .1907 .92316 .20841 .91287 .19798 .8677 Mtetra
.19798 .8677 .20841 .91287 .22633 .90246 .21573 .85709 Mtetra
.21573 .85709 .22633 .90246 .24447 .89192 .23369 .84635 Mtetra
.23369 .84635 .24447 .89192 .26283 .88126 .25186 .83547 Mtetra
.25186 .83547 .26283 .88126 .28142 .87046 .27026 .82447 Mtetra
.27026 .82447 .28142 .87046 .30023 .85953 .28889 .81333 Mtetra
.28889 .81333 .30023 .85953 .31928 .84847 .30774 .80205 Mtetra
.30774 .80205 .31928 .84847 .33857 .83726 .32683 .79063 Mtetra
.32683 .79063 .33857 .83726 .3581 .82592 .34616 .77907 Mtetra
.34616 .77907 .3581 .82592 .37788 .81443 .36573 .76736 Mtetra
.36573 .76736 .37788 .81443 .39791 .80279 .38554 .75551 Mtetra
.38554 .75551 .39791 .80279 .4182 .79101 .40562 .7435 Mtetra
.40562 .7435 .4182 .79101 .43875 .77907 .42594 .73134 Mtetra
.42594 .73134 .43875 .77907 .45957 .76698 .44654 .71902 Mtetra
.44654 .71902 .45957 .76698 .48066 .75472 .46739 .70654 Mtetra
.46739 .70654 .48066 .75472 .50202 .74231 .48853 .6939 Mtetra
.48853 .6939 .50202 .74231 .52367 .72974 .50994 .6811 Mtetra
.50994 .6811 .52367 .72974 .54561 .71699 .53163 .66812 Mtetra
.53163 .66812 .54561 .71699 .56785 .70407 .55361 .65497 Mtetra
.55361 .65497 .56785 .70407 .59039 .69098 .57589 .64164 Mtetra
.57589 .64164 .59039 .69098 .61323 .67771 .59847 .62813 Mtetra
.59847 .62813 .61323 .67771 .63638 .66426 .62136 .61444 Mtetra
.62136 .61444 .63638 .66426 .65986 .65063 .64456 .60056 Mtetra
.64456 .60056 .65986 .65063 .68366 .6368 .66808 .58649 Mtetra
.66808 .58649 .68366 .6368 .7078 .62278 .69193 .57223 Mtetra
.69193 .57223 .7078 .62278 .73227 .60856 .71611 .55776 Mtetra
.464 .345 .632 r
.1199 .86006 .12907 .90893 .146 .8988 .13664 .84972 Mtetra
.13664 .84972 .146 .8988 .16312 .88856 .15358 .83927 Mtetra
.15358 .83927 .16312 .88856 .18045 .87819 .17072 .82869 Mtetra
.17072 .82869 .18045 .87819 .19798 .8677 .18807 .81799 Mtetra
.18807 .81799 .19798 .8677 .21573 .85709 .20562 .80716 Mtetra
.20562 .80716 .21573 .85709 .23369 .84635 .22338 .7962 Mtetra
.22338 .7962 .23369 .84635 .25186 .83547 .24135 .78511 Mtetra
.24135 .78511 .25186 .83547 .27026 .82447 .25954 .77389 Mtetra
.25954 .77389 .27026 .82447 .28889 .81333 .27795 .76253 Mtetra
.27795 .76253 .28889 .81333 .30774 .80205 .29659 .75103 Mtetra
.29659 .75103 .30774 .80205 .32683 .79063 .31546 .73938 Mtetra
.31546 .73938 .32683 .79063 .34616 .77907 .33456 .7276 Mtetra
.33456 .7276 .34616 .77907 .36573 .76736 .35391 .71566 Mtetra
.35391 .71566 .36573 .76736 .38554 .75551 .37349 .70358 Mtetra
.37349 .70358 .38554 .75551 .40562 .7435 .39332 .69134 Mtetra
.39332 .69134 .40562 .7435 .42594 .73134 .41341 .67895 Mtetra
.41341 .67895 .42594 .73134 .44654 .71902 .43375 .6664 Mtetra
.43375 .6664 .44654 .71902 .46739 .70654 .45435 .65368 Mtetra
.45435 .65368 .46739 .70654 .48853 .6939 .47522 .6408 Mtetra
.47522 .6408 .48853 .6939 .50994 .6811 .49637 .62776 Mtetra
.49637 .62776 .50994 .6811 .53163 .66812 .51779 .61454 Mtetra
.51779 .61454 .53163 .66812 .55361 .65497 .53949 .60115 Mtetra
.53949 .60115 .55361 .65497 .57589 .64164 .56149 .58758 Mtetra
.56149 .58758 .57589 .64164 .59847 .62813 .58377 .57382 Mtetra
.58377 .57382 .59847 .62813 .62136 .61444 .60636 .55988 Mtetra
.60636 .55988 .62136 .61444 .64456 .60056 .62926 .54575 Mtetra
.62926 .54575 .64456 .60056 .66808 .58649 .65247 .53143 Mtetra
.65247 .53143 .66808 .58649 .69193 .57223 .676 .51691 Mtetra
.676 .51691 .69193 .57223 .71611 .55776 .69986 .50219 Mtetra
.457 .331 .621 r
.11132 .80697 .1199 .86006 .13664 .84972 .12787 .79642 Mtetra
.12787 .79642 .13664 .84972 .15358 .83927 .14461 .78575 Mtetra
.14461 .78575 .15358 .83927 .17072 .82869 .16155 .77495 Mtetra
.16155 .77495 .17072 .82869 .18807 .81799 .17869 .76403 Mtetra
.17869 .76403 .18807 .81799 .20562 .80716 .19603 .75298 Mtetra
.19603 .75298 .20562 .80716 .22338 .7962 .21357 .7418 Mtetra
.21357 .7418 .22338 .7962 .24135 .78511 .23133 .73048 Mtetra
.23133 .73048 .24135 .78511 .25954 .77389 .24929 .71903 Mtetra
.24929 .71903 .25954 .77389 .27795 .76253 .26748 .70744 Mtetra
.26748 .70744 .27795 .76253 .29659 .75103 .28588 .69571 Mtetra
.28588 .69571 .29659 .75103 .31546 .73938 .30451 .68384 Mtetra
.30451 .68384 .31546 .73938 .33456 .7276 .32337 .67182 Mtetra
.32337 .67182 .33456 .7276 .35391 .71566 .34246 .65965 Mtetra
.34246 .65965 .35391 .71566 .37349 .70358 .36179 .64733 Mtetra
.36179 .64733 .37349 .70358 .39332 .69134 .38136 .63485 Mtetra
.38136 .63485 .39332 .69134 .41341 .67895 .40118 .62222 Mtetra
.40118 .62222 .41341 .67895 .43375 .6664 .42125 .60943 Mtetra
.42125 .60943 .43375 .6664 .45435 .65368 .44158 .59648 Mtetra
.44158 .59648 .45435 .65368 .47522 .6408 .46216 .58335 Mtetra
.46216 .58335 .47522 .6408 .49637 .62776 .48302 .57006 Mtetra
.48302 .57006 .49637 .62776 .51779 .61454 .50414 .5566 Mtetra
.50414 .5566 .51779 .61454 .53949 .60115 .52554 .54296 Mtetra
.52554 .54296 .53949 .60115 .56149 .58758 .54723 .52914 Mtetra
.54723 .52914 .56149 .58758 .58377 .57382 .5692 .51514 Mtetra
.5692 .51514 .58377 .57382 .60636 .55988 .59146 .50094 Mtetra
.59146 .50094 .60636 .55988 .62926 .54575 .61403 .48656 Mtetra
.61403 .48656 .62926 .54575 .65247 .53143 .6369 .47199 Mtetra
.6369 .47199 .65247 .53143 .676 .51691 .66008 .45721 Mtetra
.66008 .45721 .676 .51691 .69986 .50219 .68358 .44223 Mtetra
.45 .319 .611 r
.10336 .74996 .11132 .80697 .12787 .79642 .1197 .73919 Mtetra
.1197 .73919 .12787 .79642 .14461 .78575 .13623 .7283 Mtetra
.13623 .7283 .14461 .78575 .16155 .77495 .15296 .71728 Mtetra
.15296 .71728 .16155 .77495 .17869 .76403 .16987 .70613 Mtetra
.16987 .70613 .17869 .76403 .19603 .75298 .18698 .69485 Mtetra
.18698 .69485 .19603 .75298 .21357 .7418 .2043 .68344 Mtetra
.2043 .68344 .21357 .7418 .23133 .73048 .22182 .6719 Mtetra
.22182 .6719 .23133 .73048 .24929 .71903 .23954 .66022 Mtetra
.23954 .66022 .24929 .71903 .26748 .70744 .25748 .6484 Mtetra
.25748 .6484 .26748 .70744 .28588 .69571 .27563 .63643 Mtetra
.27563 .63643 .28588 .69571 .30451 .68384 .29401 .62433 Mtetra
.29401 .62433 .30451 .68384 .32337 .67182 .3126 .61207 Mtetra
.3126 .61207 .32337 .67182 .34246 .65965 .33143 .59966 Mtetra
.33143 .59966 .34246 .65965 .36179 .64733 .35048 .58711 Mtetra
.35048 .58711 .36179 .64733 .38136 .63485 .36978 .57439 Mtetra
.36978 .57439 .38136 .63485 .40118 .62222 .38931 .56152 Mtetra
.38931 .56152 .40118 .62222 .42125 .60943 .40909 .54849 Mtetra
.40909 .54849 .42125 .60943 .44158 .59648 .42911 .53529 Mtetra
.42911 .53529 .44158 .59648 .46216 .58335 .4494 .52192 Mtetra
.4494 .52192 .46216 .58335 .48302 .57006 .46994 .50838 Mtetra
.46994 .50838 .48302 .57006 .50414 .5566 .49074 .49467 Mtetra
.49074 .49467 .50414 .5566 .52554 .54296 .51182 .48078 Mtetra
.51182 .48078 .52554 .54296 .54723 .52914 .53317 .46671 Mtetra
.53317 .46671 .54723 .52914 .5692 .51514 .5548 .45246 Mtetra
.5548 .45246 .5692 .51514 .59146 .50094 .57672 .43802 Mtetra
.57672 .43802 .59146 .50094 .61403 .48656 .59892 .42338 Mtetra
.59892 .42338 .61403 .48656 .6369 .47199 .62143 .40855 Mtetra
.62143 .40855 .6369 .47199 .66008 .45721 .64424 .39352 Mtetra
.64424 .39352 .66008 .45721 .68358 .44223 .66736 .37828 Mtetra
.444 .309 .602 r
.09603 .68937 .10336 .74996 .1197 .73919 .11215 .67838 Mtetra
.11215 .67838 .1197 .73919 .13623 .7283 .12846 .66726 Mtetra
.12846 .66726 .13623 .7283 .15296 .71728 .14495 .65601 Mtetra
.14495 .65601 .15296 .71728 .16987 .70613 .16163 .64464 Mtetra
.16163 .64464 .16987 .70613 .18698 .69485 .1785 .63313 Mtetra
.1785 .63313 .18698 .69485 .2043 .68344 .19557 .62149 Mtetra
.19557 .62149 .2043 .68344 .22182 .6719 .21284 .60972 Mtetra
.21284 .60972 .22182 .6719 .23954 .66022 .23031 .5978 Mtetra
.23031 .5978 .23954 .66022 .25748 .6484 .24799 .58575 Mtetra
.24799 .58575 .25748 .6484 .27563 .63643 .26588 .57355 Mtetra
.26588 .57355 .27563 .63643 .29401 .62433 .28398 .56121 Mtetra
.28398 .56121 .29401 .62433 .3126 .61207 .3023 .54872 Mtetra
.3023 .54872 .3126 .61207 .33143 .59966 .32084 .53608 Mtetra
.32084 .53608 .33143 .59966 .35048 .58711 .3396 .52328 Mtetra
.3396 .52328 .35048 .58711 .36978 .57439 .3586 .51033 Mtetra
.3586 .51033 .36978 .57439 .38931 .56152 .37783 .49721 Mtetra
.37783 .49721 .38931 .56152 .40909 .54849 .3973 .48394 Mtetra
.3973 .48394 .40909 .54849 .42911 .53529 .41701 .4705 Mtetra
.41701 .4705 .42911 .53529 .4494 .52192 .43697 .45689 Mtetra
.43697 .45689 .4494 .52192 .46994 .50838 .45718 .44311 Mtetra
.45718 .44311 .46994 .50838 .49074 .49467 .47764 .42915 Mtetra
.47764 .42915 .49074 .49467 .51182 .48078 .49837 .41501 Mtetra
.49837 .41501 .51182 .48078 .53317 .46671 .51937 .4007 Mtetra
.51937 .4007 .53317 .46671 .5548 .45246 .54064 .38619 Mtetra
.54064 .38619 .5548 .45246 .57672 .43802 .56218 .3715 Mtetra
.56218 .3715 .57672 .43802 .59892 .42338 .58401 .35662 Mtetra
.58401 .35662 .59892 .42338 .62143 .40855 .60613 .34153 Mtetra
.60613 .34153 .62143 .40855 .64424 .39352 .62854 .32625 Mtetra
.62854 .32625 .64424 .39352 .66736 .37828 .65125 .31077 Mtetra
.439 .3 .594 r
.08933 .62553 .09603 .68937 .11215 .67838 .10522 .61431 Mtetra
.10522 .61431 .11215 .67838 .12846 .66726 .12129 .60297 Mtetra
.12129 .60297 .12846 .66726 .14495 .65601 .13754 .5915 Mtetra
.13754 .5915 .14495 .65601 .16163 .64464 .15398 .5799 Mtetra
.15398 .5799 .16163 .64464 .1785 .63313 .1706 .56816 Mtetra
.1706 .56816 .1785 .63313 .19557 .62149 .18741 .5563 Mtetra
.18741 .5563 .19557 .62149 .21284 .60972 .20442 .54429 Mtetra
.20442 .54429 .21284 .60972 .23031 .5978 .22162 .53215 Mtetra
.22162 .53215 .23031 .5978 .24799 .58575 .23902 .51986 Mtetra
.23902 .51986 .24799 .58575 .26588 .57355 .25663 .50744 Mtetra
.25663 .50744 .26588 .57355 .28398 .56121 .27444 .49486 Mtetra
.27444 .49486 .28398 .56121 .3023 .54872 .29247 .48213 Mtetra
.29247 .48213 .3023 .54872 .32084 .53608 .31071 .46926 Mtetra
.31071 .46926 .32084 .53608 .3396 .52328 .32918 .45623 Mtetra
.32918 .45623 .3396 .52328 .3586 .51033 .34786 .44304 Mtetra
.34786 .44304 .3586 .51033 .37783 .49721 .36677 .42969 Mtetra
.36677 .42969 .37783 .49721 .3973 .48394 .38591 .41618 Mtetra
.38591 .41618 .3973 .48394 .41701 .4705 .40529 .4025 Mtetra
.40529 .4025 .41701 .4705 .43697 .45689 .42491 .38865 Mtetra
.42491 .38865 .43697 .45689 .45718 .44311 .44477 .37463 Mtetra
.44477 .37463 .45718 .44311 .47764 .42915 .46489 .36043 Mtetra
.46489 .36043 .47764 .42915 .49837 .41501 .48525 .34606 Mtetra
.48525 .34606 .49837 .41501 .51937 .4007 .50588 .3315 Mtetra
.50588 .3315 .51937 .4007 .54064 .38619 .52676 .31675 Mtetra
.52676 .31675 .54064 .38619 .56218 .3715 .54792 .30182 Mtetra
.54792 .30182 .56218 .3715 .58401 .35662 .56935 .28669 Mtetra
.56935 .28669 .58401 .35662 .60613 .34153 .59106 .27137 Mtetra
.59106 .27137 .60613 .34153 .62854 .32625 .61306 .25584 Mtetra
.61306 .25584 .62854 .32625 .65125 .31077 .63534 .24011 Mtetra
.434 .291 .587 r
.08327 .55878 .08933 .62553 .10522 .61431 .09892 .54734 Mtetra
.09892 .54734 .10522 .61431 .12129 .60297 .11474 .53578 Mtetra
.11474 .53578 .12129 .60297 .13754 .5915 .13074 .52408 Mtetra
.13074 .52408 .13754 .5915 .15398 .5799 .14692 .51226 Mtetra
.14692 .51226 .15398 .5799 .1706 .56816 .16328 .50031 Mtetra
.16328 .50031 .1706 .56816 .18741 .5563 .17982 .48822 Mtetra
.17982 .48822 .18741 .5563 .20442 .54429 .19655 .47599 Mtetra
.19655 .47599 .20442 .54429 .22162 .53215 .21348 .46362 Mtetra
.21348 .46362 .22162 .53215 .23902 .51986 .23059 .45111 Mtetra
.23059 .45111 .23902 .51986 .25663 .50744 .24791 .43845 Mtetra
.24791 .43845 .25663 .50744 .27444 .49486 .26543 .42565 Mtetra
.26543 .42565 .27444 .49486 .29247 .48213 .28315 .4127 Mtetra
.28315 .4127 .29247 .48213 .31071 .46926 .30108 .39959 Mtetra
.30108 .39959 .31071 .46926 .32918 .45623 .31922 .38633 Mtetra
.31922 .38633 .32918 .45623 .34786 .44304 .33758 .37292 Mtetra
.33758 .37292 .34786 .44304 .36677 .42969 .35616 .35934 Mtetra
.35616 .35934 .36677 .42969 .38591 .41618 .37497 .3456 Mtetra
.37497 .3456 .38591 .41618 .40529 .4025 .394 .33169 Mtetra
.394 .33169 .40529 .4025 .42491 .38865 .41326 .31761 Mtetra
.41326 .31761 .42491 .38865 .44477 .37463 .43276 .30336 Mtetra
.43276 .30336 .44477 .37463 .46489 .36043 .45251 .28893 Mtetra
.45251 .28893 .46489 .36043 .48525 .34606 .47249 .27432 Mtetra
.47249 .27432 .48525 .34606 .50588 .3315 .49273 .25953 Mtetra
.49273 .25953 .50588 .3315 .52676 .31675 .51322 .24455 Mtetra
.51322 .24455 .52676 .31675 .54792 .30182 .53397 .22939 Mtetra
.53397 .22939 .54792 .30182 .56935 .28669 .55499 .21403 Mtetra
.55499 .21403 .56935 .28669 .59106 .27137 .57627 .19847 Mtetra
.57627 .19847 .59106 .27137 .61306 .25584 .59783 .18272 Mtetra
.59783 .18272 .61306 .25584 .63534 .24011 .61967 .16675 Mtetra
.429 .284 .581 r
.07784 .48947 .08327 .55878 .09892 .54734 .09324 .47782 Mtetra
.09324 .47782 .09892 .54734 .11474 .53578 .10881 .46604 Mtetra
.10881 .46604 .11474 .53578 .13074 .52408 .12455 .45413 Mtetra
.12455 .45413 .13074 .52408 .14692 .51226 .14046 .4421 Mtetra
.14046 .4421 .14692 .51226 .16328 .50031 .15654 .42992 Mtetra
.15654 .42992 .16328 .50031 .17982 .48822 .17281 .41762 Mtetra
.17281 .41762 .17982 .48822 .19655 .47599 .18926 .40517 Mtetra
.18926 .40517 .19655 .47599 .21348 .46362 .20589 .39259 Mtetra
.20589 .39259 .21348 .46362 .23059 .45111 .22271 .37986 Mtetra
.22271 .37986 .23059 .45111 .24791 .43845 .23973 .36698 Mtetra
.23973 .36698 .24791 .43845 .26543 .42565 .25694 .35396 Mtetra
.25694 .35396 .26543 .42565 .28315 .4127 .27435 .34079 Mtetra
.27435 .34079 .28315 .4127 .30108 .39959 .29195 .32747 Mtetra
.29195 .32747 .30108 .39959 .31922 .38633 .30977 .31399 Mtetra
.30977 .31399 .31922 .38633 .33758 .37292 .32779 .30035 Mtetra
.32779 .30035 .33758 .37292 .35616 .35934 .34603 .28655 Mtetra
.34603 .28655 .35616 .35934 .37497 .3456 .36448 .27259 Mtetra
.36448 .27259 .37497 .3456 .394 .33169 .38316 .25846 Mtetra
.38316 .25846 .394 .33169 .41326 .31761 .40205 .24416 Mtetra
.40205 .24416 .41326 .31761 .43276 .30336 .42118 .22969 Mtetra
.42118 .22969 .43276 .30336 .45251 .28893 .44054 .21505 Mtetra
.44054 .21505 .45251 .28893 .47249 .27432 .46013 .20022 Mtetra
.46013 .20022 .47249 .27432 .49273 .25953 .47997 .18521 Mtetra
.47997 .18521 .49273 .25953 .51322 .24455 .50005 .17002 Mtetra
.50005 .17002 .51322 .24455 .53397 .22939 .52038 .15463 Mtetra
.52038 .15463 .53397 .22939 .55499 .21403 .54097 .13906 Mtetra
.54097 .13906 .55499 .21403 .57627 .19847 .56182 .12328 Mtetra
.56182 .12328 .57627 .19847 .59783 .18272 .58293 .10731 Mtetra
.58293 .10731 .59783 .18272 .61967 .16675 .60431 .09113 Mtetra
.425 .277 .575 r
.07304 .41796 .07784 .48947 .09324 .47782 .08818 .4061 Mtetra
.08818 .4061 .09324 .47782 .10881 .46604 .10349 .39411 Mtetra
.10349 .39411 .10881 .46604 .12455 .45413 .11895 .382 Mtetra
.11895 .382 .12455 .45413 .14046 .4421 .13459 .36976 Mtetra
.13459 .36976 .14046 .4421 .15654 .42992 .1504 .35738 Mtetra
.1504 .35738 .15654 .42992 .17281 .41762 .16638 .34486 Mtetra
.16638 .34486 .17281 .41762 .18926 .40517 .18254 .33221 Mtetra
.18254 .33221 .18926 .40517 .20589 .39259 .19887 .31942 Mtetra
.19887 .31942 .20589 .39259 .22271 .37986 .21539 .30648 Mtetra
.21539 .30648 .22271 .37986 .23973 .36698 .23209 .2934 Mtetra
.23209 .2934 .23973 .36698 .25694 .35396 .24899 .28017 Mtetra
.24899 .28017 .25694 .35396 .27435 .34079 .26607 .26679 Mtetra
.26607 .26679 .27435 .34079 .29195 .32747 .28335 .25326 Mtetra
.28335 .25326 .29195 .32747 .30977 .31399 .30082 .23957 Mtetra
.30082 .23957 .30977 .31399 .32779 .30035 .3185 .22573 Mtetra
.3185 .22573 .32779 .30035 .34603 .28655 .33639 .21173 Mtetra
.33639 .21173 .34603 .28655 .36448 .27259 .35448 .19756 Mtetra
.35448 .19756 .36448 .27259 .38316 .25846 .37278 .18322 Mtetra
.37278 .18322 .38316 .25846 .40205 .24416 .3913 .16872 Mtetra
.3913 .16872 .40205 .24416 .42118 .22969 .41004 .15404 Mtetra
.41004 .15404 .42118 .22969 .44054 .21505 .42901 .13919 Mtetra
.42901 .13919 .44054 .21505 .46013 .20022 .4482 .12416 Mtetra
.4482 .12416 .46013 .20022 .47997 .18521 .46763 .10895 Mtetra
.46763 .10895 .47997 .18521 .50005 .17002 .48729 .09355 Mtetra
.48729 .09355 .50005 .17002 .52038 .15463 .50719 .07796 Mtetra
.50719 .07796 .52038 .15463 .54097 .13906 .52734 .06218 Mtetra
.52734 .06218 .54097 .13906 .56182 .12328 .54774 .04621 Mtetra
.54774 .04621 .56182 .12328 .58293 .10731 .56839 .03004 Mtetra
.56839 .03004 .58293 .10731 .60431 .09113 .5893 .01366 Mtetra
0 g
.58882 0 m
.9135 .24802 L
s
.9135 .24802 m
1 .91828 L
s
1 .91828 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.07455 .4049 m
0 1.05195 L
s
0 1.05195 m
.61333 .69967 L
s
.61333 .69967 m
.58882 0 L
s
.58882 0 m
.07455 .4049 L
s
0 1.05195 m
.38081 1.20141 L
s
gsave
.19359 1.22462 -67.3959 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.9135 .24802 m
1 .91828 L
s
gsave
1.03519 .50652 -61 -18.8336 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(w) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(') show
79.000000 17.437500 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{160.25, 179.625},
  ImageMargins->{{86, 0}, {0, 0}},
  ImageRegion->{{-0.049922, 1.08112}, {0, 1.0254}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002P0000/a000`40O003h00ODGoo00<007ooOol0
C7oo001@Ool3001=Ool004ioo`800003Ool007oo008004]oo`00CGoo00D007ooOola4@0000=oo`03
001oogoo04Qoo`00C7oo00H007oo=A8`lCDB0004Ool00`00Oomoo`17Ool004Yoo`800006Oole4S4A
=A4a4@001Goo0P00Agoo0019Ool02@00OomoocDB<?4e4S3a=A800007Ool00`00Oomoo`14Ool004Qo
o`0:001oogoo=A8a4CDA<A4e4S4A0008Ool00`00Oomoo`13Ool004Moo`0;001ooc3a=A8`lCDB<?4e
4S3a=A800009Ool20013Ool004Eoo`80000;Oola4CDB<A4e4C4A=A8a4CDA<A40000;Ool00`00Oomo
o`10Ool004Aoo`0?001oocDB<?4e4S3a=A8`lCDB<?4e4S3a=A8003DB00]oo`03001oogoo03moo`00
@goo010007oo=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A000a4@aoo`8003moo`00@Woo014007oo=A8`
lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8003DB00ioo`03001oogoo03aoo`00@7oo0P00015oocDA<A4e
4S4A=A4a4CDB<A4e4C4A=A8a4CDA<A40034A00moo`03001oogoo03]oo`00?goo01@007oo<?4e4S3a
=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8003DB47oo0P00>goo000nOol05P00Oola4CDA<A4e4S4A
=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A000e4CDB4Goo00<007ooOol0>7oo000lOol200005Woo<?4e
4S3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8a4CDB<A40034A4Woo00<007ooOol0=goo000kOol0
6@00Oomooc4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A=A4a4CDB<A4e4SDA=A8003DB01=oo`8003Mo
o`00>Woo01X007ooOol`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S4A=A8a4CDB<A40034A
5Goo00<007ooOol0=7oo000iOol06`00Oomooc4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A=A4a4CDB
<A4e4SDA=A8a4CDB000e4P0FOol00`00Oomoo`0cOol003Moo`80009oo`0J<?4e4S3a=A8`lCDB<?4e
4S3a=A8`lCDB<?4e4S3a=A8a4CDB<A4e4S4A=A8a4@00<A4e4QIoo`8003=oo`00=Woo014007ooOole
4S4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A008e4@0<=A8a4CDB=A4e4S4A=A8e4CDB000e4SDA67oo
00<007ooOol0<7oo000eOol08000Ool`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S4A=A8a
4CDB<A4e4S4A=A8a4CDB<A40034A=A8IOol00`00Oomoo`0_Ool003=oo`80000NOola4CDB<A4e4C4A
=A8a4CDA<A4e4S4A=A4a4CDB<A4e4SDA=A8a4CDB=A4e4S4A=A8e4CDB<A4e4P000SDB6Woo0P00;goo
000bOol08`00Oole4S3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<A4e4S4A=A8a4CDB<A4e
4S4A=A8a4CDB<A4003DA=C8077oo00<007ooOol0;7oo000aOol08P00Oole4C4A=A8a4CDA<A4e4S4A
=A4a4CDB<A4e4C4A=A8a4CDB=A4e4S4A=A8e4CDB<A4e4SDA=A8a4CDB=A4e4P000cDB77oo00<007oo
Ool0:goo000`Ool09P00Oole4S3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<A4e4S4A=A8a
4CDB<A4e4S4A=A8a4CDB<A4e<SDA000a4CDb=A4MOol2000[Ool002ioo`80000MOole4C4A=A8a4CDA
<A4e4S4A=A4a4CDB<A4e4C4A=A8a4CDB=A4e4S4A=A8e4CDB<A4e4SDA=A8a4@05=A801000=A8e4SDB
7goo00<007ooOol0:7oo000]Ool0:@00Ool`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S4A
=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDb=A4e<S4A000e4CDb<A4087oo00<007ooOol09goo
000/Ool08@00Oola4CDA<A4e4S4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A=A8e4CDB<A4e4SDA=A8a
4CDB=A4e4S4A=A8e4@05=A801000=A8e4SDB8Goo0P009goo000[Ool0;000Ool`lCDB<?4e4S3a=A8`
lCDB<?4e4S3a=A8`lCDB<?4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDb=A4e<S4A=C8e
4@00<A4e<SDA=C8ROol00`00Oomoo`0TOol002Uoo`80000NOola4CDA<A4e4S4A=A4a4CDB<A4e4C4A
=A8a4CDA<A4e4S4A=A8e4CDB<A4e4SDA=A8a4CDB=A4e4S4A2CDB00<003DB=A800SDB8goo00<007oo
Ool08goo000XOol0;`00Oomooc3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<A4e4S4A=A8a
4CDB<A4e4S4A=A8a4CDB<A4e4S4A=C8e4CDb<A4e<SDA=C8a4@00=A4e<S4A=C8097oo0P008goo000W
Ool04000Oomooc4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A0SDA00he4S4A=A8e4CDB<A4e4SDA=A8a
4CDB=A4e4S4A2cDB00<003DB=A800SDB9Woo00<007ooOol087oo000UOol20000<Goo=A8`lCDB<?4e
4S3a=A8`lCDB<?4e4S3a=A8`lCDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=C8a4CDb=A4e
<S4A=C8e4CDb<A4e<SDA000a4CDb=A8e<SDB02=oo`<0029oo`0097oo014007ooOole4S4A=A4a4CDB
<A4e4C4A=A8a4CDA<A4e4S4A008e4@0<=A8a4CDB=A4e4S4A=A8e4CDB<A4e4SDA3cDB00H003Db=A8e
<SDB=C8ROol01000Oomoo`008Woo000SOol0=@00OomoocDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB
<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8e4CDb<A4e<SDA=C8a4CDb=A4e<S4A=C8e4CDb
=A8003DB=C8e4SDb=A8087oo0P000goo00<007ooOol087oo000ROol07`00Oola4CDB<A4e4C4A=A8a
4CDA<A4e4S4A=A4a4CDB<A4e4SDA=A8a4CDB=A4e4S4A=A8e4CDB<A4e4SDA010e4P08=C8003Db=A8e
<SDB=C8e4Qioo`03001oogoo00=oo`03001oogoo021oo`0087oo0P0003Mooc3a=A8`lCDB<?4e4S3a
=A8`lCDB<?4e4S3a=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4SDA=C8a4CDb=A4e<S4A
=C8e4CDb<A4e<SDA=C8e4SDb=A8003DB=C8e4SDb=A8e<P0LOol20007Ool00`00Oomoo`0OOol001mo
o`0P001oocDA<A4e4S4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A=A8e4CDB<A4e4SDA=A8a4CDB=A4e
4S4A=A8e4A0e4P0:=C8e4SDb000e<SDB=C8e4SDb=A8JOol20009Ool00`00Oomoo`0OOol001ioo`0k
001oocDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A
=A8a4CDb=A4e<S4A=C8e4CDb<A4e<SDA=C8a4CDb=A4e<SDB=C8e4SDb=A8003DB=C8e4SDb=A8e<P0I
Ool00`00Oomoo`09Ool00`00Oomoo`0OOol001aoo`80000MOole4C4A=A8a4CDA<A4e4S4A=A4a4CDB
<A4e4C4A=A8a4CDB=A4e4S4A=A8e4CDB<A4e4SDA=A8a4@0@=A803cDb=A8e<SDB=C8e4SDb000e<SDB
=C8e4SDb=A8e<P0FOol2000<Ool00`00Oomoo`0OOol001]oo`0o001oogoo=A8`lCDB<?4e4S3a=A8`
lCDB<?4e4S3a=A8`lCDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e<S4A=C8e4CDb<A4e<SDA=C8a
4CDb=A4e<S4A=C8e4SDb=A8e<SDB=C8e4SDb=A8003DB=C8e4SDb=A8e<SDB01Eoo`03001oogoo00ao
o`03001oogoo01moo`006Woo01l007ooOole4C4A=A8a4CDA<A4e4S4A=A4a4CDB<A4e4C4A=A8a4CDB
=A4e4S4A=A8e4CDB<A4e4SDA=A8a4@0@=A803SDb=A8e<SDB=C8e4SDb=A8e<P00=C8e4SDb=A83=C8C
Ool2000?Ool00`00Oomoo`0OOol001Uoo`11001ooc3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8a
4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB=A4e<S4A=C8e4CDb<A4e<SDA=C8a4CDb=A4e<S4A=C8e
4SDb=A8e<SDB=C8e4SDb=A8e<SDB000e4SDb=A8i<cDb=C<e4P0BOol00`00Oomoo`0?Ool00`00Oomo
o`0OOol001Moo`80000>Oola4CDA<A4e4S4A=A4a4CDB<A4e4C4A=A8a4@8e4@0<=A8a4CDB=A4e4S4A
=A8e4CDB<A4e4SDA43DB010e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<P00=C8e4PHe<Pmoo`80019o
o`03001oogoo01moo`005Woo04D007ooOol`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`lCDB<A4e4S4A
=A8a4CDB<A4e4S4A=A8a4CDB<A4e<SDA=C8a4CDb=A4e<S4A=C8e4CDb<A4e<SDA=C8e4SDb=A8e<SDB
=C8e4SDb=A8e<SDB=C8e4SDb=A8003DB>C<e<SDc=A8i<cDb=C<03Woo00<007ooOol04goo00<007oo
Ool07Woo000EOol07P00Oomooc4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A=A8e4CDB<A4e4SDA=A8a
4CDB=A4e4S4A=A8e4A0e4P0>=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4P8e<P03000e<SDb00De
<Paoo`8001Ioo`03001oogoo01ioo`0057oo04L007oo=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8`
lCDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e<SDA=C8a4CDb=A4e<S4A=C8e4CDb<A4e<SDA=C8e
4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<cDB>C<003Dc=A8i<cDb=C<e4STc00Yoo`8001Qo
o`03001oogoo01ioo`004Woo0P0001da4CDB<A4e4C4A=A8a4CDA<A4e4S4A=A4a4CDB<A4e4SDA=A8a
4CDB=A4e4S4A=A8e4CDB<A4e4SDA010e4P0>=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4P@e<P03
000e<SDb00He<PQoo`03001oogoo01Qoo`03001oogoo01ioo`004Goo04/007oo<?4e4S3a=A8`lCDB
<?4e4S3a=A8`lCDB<?4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDb=A4e<S4A=C8e4CDb
<A4e<SDA=C8a4CDb=A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDc=A8i<cDb=C<003Tc
=C8e<cDB>C<e<SDc=A801Woo0P006goo00<007ooOol07Woo000@Ool07@00Oola4CDB<A4e4C4A=A8a
4CDA<A4e4S4A=A4a4CDB<A4e4SDA=A8a4CDB=A4e4S4A=A8e4CDB<A4043DB010e<SDB=C8e4SDb=A8e
<SDB=C8e4SDb=A8e<SDB=C8e4PHe<P03000e<SDb00He<PEoo`03001oogoo01]oo`03001oogoo01io
o`003Woo0P0003Yooc3a=A8`lCDB<?4e4S3a=A8`lCDB<?4e4S3a=A8a4CDB<A4e4S4A=A8a4CDB<A4e
4S4A=A8a4CDB<A4e<SDA=C8a4CDb=A4e<S4A=C8e4CDb<A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e
<SDB=C8e4P8e<P0@=C<e4STc=C8e<cDB>C<003Dc=A8i<cDb=C<e4STc=C83Ool2000NOol00`00Oomo
o`0NOol000eoo`0N001oogoo<A4e4S4A=A4a4CDB<A4e4C4A=A8a4CDA<A4e4S4A=A8e4CDB<A4e4SDA
=A8a4CDB=A4e4S4A43DB00he<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB2SDb00<003Db=C800cDb
00Hi<cDb=C<e<Woo000POol00`00Oomoo`0NOol000aoo`1B001oocDB<?4e4S3a=A8`lCDB<?4e4S3a
=A8`lCDB<?4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=C8a4CDb=A4e<S4A=C8e4CDb<A4e<SDA
=C8a4CDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB>C<e<SDc=A8i<cDb=C<e4STc=C8e<`00
>C<e<SDc=A8iDcDb>C<e<SUC000ROol00`00Oomoo`0MOol000aoo`0K000e4C4A=A8a4CDA<A4e4S4A
=A4a4CDB<A4e4C4A=A8a4CDB=A4e4S4A=A8e4CDB<A4e4SDA018e4P0<=C8e4SDb=A8e<SDB=C8e4SDb
=A8e<SDB3SDb00X003Db=C8e<STc=C8e<cDb>C<e<R=oo`03001oogoo01eoo`0037oo0540033a=A8`
lCDB<?4e4S3a=A8`lCDB<?4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8e4CDb<A4e<SDA=C8a
4CDb=A4e<S4A=C8e4CDb<A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C<e4STc=C8e<cDB>C<e
<SDc=A8i<cDb=C<e4STc000i<cDb>E<e<STc=C8iDcDb>C<08goo00<007ooOol07Goo000<Ool06@00
=A8a4CDA<A4e4S4A=A4a4CDB<A4e4SDA=A8a4CDB=A4e4S4A=A8e4CDB<A4e4SDA00he4P0>=C8e4SDb
=A8e<SDB=C8e4SDb=A8e<SDB=C8e4Q8e<P0;000e<STc=C8e<cDb>C<e<SDc=C8i<`0ROol00`00Oomo
o`0MOol000aoo`0d000`lCDB<?4e4S3a=A8`lCDB<?4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A
=A8e4CDb<A4e<SDA=C8a4CDb=A4e<S4A=C8e4CDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A82=C80
73Dc=A8i<cDb=C<e4STc=C8e<cDB>C<e<SDc=A8i<cDb>C<003UC=C8i<cDb>E<e<STc=C8iDcDb8Woo
00<007ooOol07Goo000;Ool06000<A4e4C4A=A8a4CDA<A4e4S4A=A8e4CDB<A4e4SDA=A8a4CDB=A4e
4S4A=A8e4@he4P0>=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4Q8e<P0==C<e<P00=C8e<cDb>C<e
<SDc=C8i<cDb=C<08Woo00<007ooOol03Woo00<007oo000037oo000;Ool0D`00=A8`lCDB<?4e4S3a
=A8`lCDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e<SDA=C8a4CDb=A4e<S4A=C8e4CDb<A4e<SDA
=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4STc=C8e<cDB>C<e<SDc=A8i<cDb=C<e4STc=C8e<cDB
>C<e<STc=C8iD`00>C<e<SUC=C8i<cDb>E<e<STc=C808Woo00<007ooOol03Goo00D007oo001oo`00
00]oo`002goo01@007oo=A8a4CDA<A4e4S4A=A8e4CDB<A4e4SDA=A8a4CDB=A4e4S4A43DB00he<SDB
=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB43Db018i<cDb=C<e<STc=C8003Db>C<e<SDc=C8i<cDb>E<e
<cUC=C<POol00bQ/001oo`0>Ool01@00Ool007oo00002goo000;Ool0E000Ool`lCDB<?4e4S4A=A8a
4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDb=A4e<S4A=C8e4CDb<A4e<SDA=C8a4CDb=A8e<SDB=C8e
4SDb=A8e<SDB=C8e4SDb=A8e<SDB>C<e<SDc=A8i<cDb=C<e4STc=C8e<cDB>C<e<STc=C8iDcDb>C<e
<SUC=C8i<`00>E<e<STc=C8iDcDb>E<e<SUC=C8iDaioo`05:4`/K2Q<Ool0000=Ool300000goo0000
0005Ool00`00Oomoo`03Ool000]oo`0B001oocDA<A4e4S4A=A8e4CDB<A4e4SDA=A8a4CDB=A4e4S4A
43DB00`e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8@=C805SDc=C8i<cDb=C<e<STc=C8e<cDb000e<SDc
=C8i<cDc>E<e<cUC=C<iDcDc6goo00<XK2a/:6`00RQ/00</K7oo000067oo00<007ooOol00goo000;
Ool0E000Ool`lCDB<A4e4S4A=A8a4CDB<A4e4S4A=A8a4CDB<A4e4S4A=C8e4CDb<A4e<SDA=C8a4CDb
=A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8i<cDb=C<e4STc=C8e<cDB>C<e<SDc
=A8i<cDb>C<e<SUC=C8i<cDb>E<e<STc=C8iD`00>C<e<SUC=C8iDcDb>E<e<SUC=C8iDaYoo`09:4`/
K2Q<;6`XC2a/:4aoo`0001Qoo`03001oogoo00=oo`002goo00h007oo=A8a4CDB=A4e4S4A=A8e4CDB
<A4e4SDA43DB00he<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB43Db01Te<cDb>C<e<SDc=C8i<cDb
=C<e<STc=C8003Db>E<e<cUC=C<iDcDc>E<e<cUC=C<iD`0GOol2:6`01Ba/:6`XK2Q/;6`00RQ/00=o
o`00Ool07Goo000;Ool0E@00Oola4CDB<A4e4S4A=A8a4CDB<A4e4S4A=A8e4CDb<A4e<SDA=C8a4CDb
=A4e<S4A=C8e4CDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C<e4STc=C8e<cDB>C<e<SDc
=A8i<cDb=C<e4SUC=C8i<cDb>E<e<STc=C8iDcDb>C<e<SUC=C8i<`00>E<e<SUC=C8iDcDb>E<e<SUC
=C8iDcDb01Ioo`0<;6`XC2a/:4`/K2Q<;6`XC2a/:4aoo`007Woo000;Ool03000Oole4SDA=A8a4CDB
=A4e4S4A=A8e4A0e4P0>=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4Phe<P0M>C<e<SDc=C8i<cDb
=C<e<STc=C8e<cDb>C<e<SUC=C<003Dc>E<e<cUC=C<iDcDc>E<e<cUC=C<iD`0DOol3:6`01Ba/:6`X
K2Q/;6`00bQ/00</K7oo00007Woo000:Ool0EP00Oomooc4A=A8a4CDB<A4e4S4A=A8a4CDB=A4e<S4A
=C8e4CDb<A4e<SDA=C8a4CDb=A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB>C<e<SDc=A8i<cDb
=C<e4STc=C8e<cDB>C<e<SDc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<STc=C8iDcDb>E<e<SUC000iDcDb
>E<e<SUC=C8iDcDb>E<e<SUC=E<COol03bQ<;6`XC2a/:4`/K2Q<;6`XC2a/:4`/K2Q;Ool0000NOol0
00Yoo`0;001oogoo=A8a4CDB=A4e4S4A=A8e4@0@=A8033Db=A8e<SDB=C8e4SDb=A8e<SDB=C8e4Q0e
<P0L>C<e<SDc=C8i<cDb=C<e<STc=C8e<cDb>C<e<SUC=C<iDcDc000e<cUC=C<iDcDc>E<e<cUC=C<4
>E<AOol3:6`01Ba/:6`XK2Q/;6`00bQ/00DXC2Q;:4aoo`0001ioo`002Woo05L007ooOola4CDB<A4e
4S4A=A8a4CDb=A4e<S4A=C8e4CDb<A4e<SDA=C8a4CDb=A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e
<SDB>C<e<SDc=A8i<cDb=C<e4STc=C8e<cDB>C<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<STc=C8i
DcDb>E<e<SUC=C8iD`00>E<e<SUC=C8iDcDb>E<e<SUD=E<iDcEC>E@03Woo014XC2a/:4`/K2Q<;6`X
C2a/:4`/K2Q<:6`XBba/:4/XK2Q;009oo`03001oogoo01]oo`002Woo00T007ooOole4SDA=A8a4CDB
=A403SDB00he<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB3SDb01`e<cDb>C<e<SDc=C8i<cDb=C<e
<STc=C8e<cDb>C<e<cUC=C<iDcDc>E<e<`00=C<iDcDc>E<e<`PiD`eoo`03:6`/K2Q/008XK00<;6`X
K2Q/:6`/K2Q/:4`XBbQ<:4/XC2Q;0goo00<007ooOol06goo000:Ool0E`00Oomooc4A=A8a4CDB<A4e
<SDA=C8a4CDb=A4e<S4A=C8e4CDb<A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4STc=C8e
<cDB>C<e<SDc=A8i<cDb=C<e4STc=C8i<cDb>E<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8i
DcDb>E<e<SUC000iDcDb>E<e<SUC=E<iE3EC>E<eDcUD=E<iD`0;Ool04ba/:4`/K2Q<;6`XC2a/:4`/
K2Q<;6`XBbQ/:4//K2Q;:6`XBba/00=oo`03001oogoo01]oo`002Woo00D007ooOole4S4A010e4P0<
=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB3SDb01hi<cDb=C<e<STc=C8e<cDb>C<e<SDc=C8i<cDb=C<e
<SUC=C<iDcDc>E<e<cUC=C<iDcDc000e<cUC=C<;>E<7Ool01Ba/:6`XK2Q/;6`00bQ/00h/K2Q/:6`X
K2a/:4/XC2Q;:4`XBbQ<:4/XC2Q;0goo00<007ooOol06goo000:Ool0F000Oomooc4A=C8a4CDb=A4e
<S4A=C8e4CDb<A4e<SDA=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<cDB>C<e<SDc=A8i
<cDb=C<e4STc=C8e<cDB>E<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8iDcDb>E<e<SUC=C8i
DcDb>E<e<SUC000iDcEC>E<eDcUD=E<iDcEC>E@eDcUC=E<iE3EC1Woo01L/K2Q<;6`XC2a/:4`/K2Q<
;6`XC2a/:4`/K2Q;:6`XBba/:4/XK2Q;;6`XBbQ/00=oo`03001oogoo01]oo`002Woo00<007ooOol0
3SDB00`e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8@=C807CTc=C8e<cDb>C<e<SDc=C8i<cDb=C<e<STc
=C8iDcDc>E<e<cUC=C<iDcDc>E<e<cUC=C<iDcDc00003SUC1Goo00D/K2Q/:6`XK2a/00<XK00=;6`X
K2Q/:6`XC2Q;:4`XBbQ<:4/XC2Q;:4`00bQ;0goo00<007ooOol06goo0009Ool07@00Oomoogoo<A4e
<SDA=C8a4CDb=A4e<S4A=C8e4CDb=A8e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A800SDb03Pe<cDB>C<e
<SDc=A8i<cDb=C<e4STc=C8e<cDb>E<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8iDcDb>E<e
<SUC=C8iDcDb>E<e<SUC=C8iE000>E<eDcUD=E<iDcEC>E@eDcUC=E<iE3EC0SUC17oo01T/K2Q<;6`X
C2a/:4`/K2Q<;6`XC2a/:4//K2Q;:6`XBba/:4/XK2Q;;6`T:bQ;92/XB`03Ool00`00Oomoo`0KOol0
00Uoo`04001oogooOol<=A8033Db=A8e<SDB=C8e4SDb=A8e<SDB=C8e4Q0e<P0J>C<e<SDc=C8i<cDb
=C<e<STc=C8e<cDb>C<e<cUC=C<iDcDc>E<e<cUC=C<iDcDc>E<e<`@iD`03000iDcUC00TiD`07>G@i
E3Ud>E=oobQ/;6`00bQ/00l/K2Q/:6`XK2a/:4/XC2Q;:4`XBbQ<:4/XC2Q;:4`01bQ;0goo00<007oo
Ool06goo0009Ool0KP00Oomoogoo=A4e<S4A=C8e4CDb<A4e<SDA=C8e4SDb=A8e<SDB=C8e4SDb=A8e
<SDB=C8e4STc=C8e<cDB>C<e<SDc=A8i<cDb=C<e4STc=C8e<cDb>E<e<STc=C8iDcDb>C<e<SUC=C8i
<cDb>E<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUC=E<iE3EC>E<003UD=E<iDcEC>E@eDcUC=E<m
M3UC>G@iDced>E<iM2Q<;6`XC2a/:4`/K2Q<;6`XC2a/:4/XK2Q;;6`XBbQ/:4//K2Q;:6`2:4/01R@[
:4/T:bQ;92/XB`Aoo`03001oogoo01Yoo`002Goo00@007ooOomoo`Pe4P0<=C8e4SDb=A8e<SDB=C8e
4SDb=A8e<SDB43Db01`e<cDb>C<e<SDc=C8i<cDb=C<e<STc=C8e<cDb>E<e<cUC=C<iDcDc>E<e<cUC
=C<iDcDc>E<e<`LiD`03000iDcUC00@iD`09>G@iDcUd>E@iM3UC>G@iE2a/00<XK00?;6`XK2Q/:6`X
C2Q;:4`XBbQ<:4/XC2Q;:4`XBbQ<00TXB`Aoo`03001oogoo01Yoo`002Goo00<007ooOol00Woo04Xe
<SDA=C8a4CDb=A4e<SDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB>C<e<SDc=A8i<cDb=C<e4STc=C8e
<cDB>C<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<STc=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUC=C8i
DcEC>E<eDcUD=E<iDcEC>E@eD`00=E<iE3EC0SUC02DmM3UC>G@iDced>E<iM3UC?G@iDba/:4`/K2Q<
;6`XBba/:4/XK2Q;;6`XBbQ/:4//K2@[:4/T:bQ;92/XBb@[:4/T:bQ;92/XB`04Ool00`00Oomoo`0J
Ool000Uoo`03001oogoo009oo`De4P0<=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB43Db00`e<cDb>C<e
<SDc=C8i<cDb=C<e<STc=C82=C<033UC=C<iDcDc>E<e<cUC=C<iDcDc>E<e<`/iD`0B000iDcUC>E<i
E3Ud>E<iM3UD>G@iDcUd>E@iM3UC>G@XK2a/0RQ/00XXBbQ<:4/XC2Q;:4`XBbQ<:4/XC0/XB`03:2/T
:Woo00=oo`03001oogoo01Yoo`002Goo00<007ooOol00Woo05@e<S4A=C8e4SDb=A8e<SDB=C8e4SDb
=A8e<SDB=C8e4SDb=A8i<cDb=C<e4STc=C8e<cDB>C<e<SDc=A8iDcDb>C<e<SUC=C8i<cDb>E<e<STc
=C8iDcDb>C<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUD=E<iDcEC>E@eDcUC=E<iE3EC>E<eD`00
=E<iM3UC?G@iDcUd>E<mM3UC>G@iDced>E<2>G@02ba/:4`XK2Q;;6`XBbQ/:4//K2Q;:6`00RQ;00hT
:bQ;92/XBb@[:4/T:bQ;92/XBb@Z:2/T:RP[17oo00<007ooOol06Woo0009Ool00`00Oomoo`02Ool0
3CDB=C8e4SDb=A8e<SDB=C8e4SDb=A8e<SDB010e<P0L>C<e<SDc=C8i<cDb=C<e<STc=C8e<cDb>C<e
<cUC=C<iDcDc>E<e<cUC=C<iDcDc>E<e<cUC=C<=>E<03@00>G@iE3Ud>E<iM3UD>G@iDcUd>E@iM3UC
008iM00;?G@iM2Q<:4/XC2Q;:4`XBbQ<:4/XC00::4/392X012P[92XT:R@Z17oo00<007ooOol06Woo
0009Ool00`00Oomoo`02Ool033Db=A8e<SDB=C8e4SDb=A8e<SDB=C8e4P8e<P1R=C<e4STc=C8e<cDB
>C<e<SDc=A8i<cDb=C<e4SUC=C8i<cDb>E<e<STc=C8iDcDb>C<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb
>E<e<SUC=C8iDcEC>E@eDcUC=E<iE3EC>E<eDcUD=E<iDcEC?G@iD`00>E<mM3UC>G@iDced>E<iM3UC
?G@iDced>G@mUCUd?G@XBba/:4/XK2Q;;6`XBbQ/92/XBb@[:4/T:bQ;92/XBb@[:4/T:RP[92XX:b@Z
:2/T:PEoo`03001oogoo01Yoo`0027oo00<007ooOol00goo00/e4SDb=A8e<SDB=C8e4SDb=A8e<SDB
00he<P0L=C<e<STc=C8e<cDb>C<e<SDc=C8i<cDb=C<e<SUC=C<iDcDc>E<e<cUC=C<iDcDc>E<e<cUC
=C<>>E<033Ud>E<iM000>G@iDcUd>E@iM3UC>G@iE0@iM009?G@iM3Ud>G@mM2Q;:4`XBbQ<00/XB`05
:2/T:R@Z92XX:`0392X00bP[Oomoo`03Ool00`00Oomoo`0JOol000Qoo`03001oogoo00=oo`10=C8e
4SDb=A8e<SDB=C8e4SDb=A8i<cDb=C<e4STc=C8e<cDB>C<e<SDc=A8i<cDb>C<e<SUC=C8i<cDb>E<e
<STc=C8iDcDb>C<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUC=C8iDcEC>E@eDcUC=E<iE3EC>E<e
DcUD=E<2>E<0;Sed>E<iM3UC000iDcUd>E<mM3UC>G@iDced>G@mM3Ud?IDiM3ed>G@mUCUd:6`XBba/
92/XBb@[:4/T:bQ;92/XBb@[:4/T:bP[92XX:b@Z:2/T:RP[92XX:b@Z1Goo00<007ooOol06Woo0008
Ool00`00Oomoo`03Ool02CDB=C8e4SDb=A8e<SDB=C8e4P0>=C806SDc=C8i<cDb=C<e<STc=C8e<cDb
>C<e<SDc=C8iDcDc>E<e<cUC=C<iDcDc>E<e<cUC=C<?>E<03SUD>G@iDcUd>E@iM000>G@iE3Ud>E<i
M3UD?G@3>G@01Ced>G@iM3Ud?G@00cUd00<XC2Q;:4/022Q;00<T:RP[92X00R@Z00<X:b@Z92X00R@Z
00<T:B@ZOol01Goo00<007ooOol06Goo0008Ool00`00Oomoo`04Ool0JSDB=C8e4SDb=A8e<SDB>C<e
<SDc=A8i<cDb=C<e4STc=C8e<cDB>E<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8iDcDb>E<e
<SUC=C8iDcDb>E<e<SUC=C8iE3EC>E<eDcUD=E<iDcEC>E@eDcUC=E<iE3EC>G@iDced>E<iM3UC?G@i
D`00>E<mM3UC>G@iDcfE>G@mM3Ud?IDiM3ed>G@mUCUd?G@iM3fE92/XBb@[:4/T:bQ;92/XBb@Z:2/T
:RP[92XX:b@Z:2/T:RP[0R@Z00<P:B@Z82T01Woo00<007ooOol06Goo0008Ool00`00Oomoo`04Ool0
13Db=A8e<SDB3SDb01Xi<cDb=C<e<STc=C8e<cDb>C<e<SDc=C8i<cDb>E<e<cUC=C<iDcDc>E<e<cUC
=C<iDcDc3SUC00hiM3UC>G@iE3Ud>E<iM3UD>G@iDcUd000iM3UC0SUd00DmM3Ud>G@iM3ed00<iM003
?G@iM3fE00<mU@LXB`<T:P05:2/T:R@Z92XX:`0292X01B@Y92XT:B@Z92T01goo00<007ooOol06Goo
0008Ool00`00Oomoo`04Ool0ISDB=C8e4SDc=A8i<cDb=C<e4STc=C8e<cDB>C<e<SDc=A8iDcDb>C<e
<SUC=C8i<cDb>E<e<STc=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E<eDcUD=E<iDcEC>E@e
DcUC=E<iE3EC>E<eDced>E<iM3UC?G@iDcUd>E<mM3UC>G@iD`00>E<mM3Ud?IDiM3ed>G@mUCUd?G@i
M3fE>G@mUCUd?IDiU3fE>G@XBb@[:4/T:bP[92XX:b@Z:2/T:RP[92XX:`8T:P0682TT:R0Y92XP:B@Z
1goo00<007ooOol06Goo0008Ool00`00Oomoo`04Ool00cDb=A8e<P0==C806STc=C8e<cDb>C<e<SDc
=C8i<cDb=C<e<STc=C8iDcDc>E<e<cUC=C<iDcDc>E<e<cUC=C<>>E<03SUd>E<iM3UD>G@iDcUd>E@i
M3UC>G@iE3Ud0002>G@01Ced>G@iM3Ud?G@00cUd00<mM3fE?ID01SfE0bQ;00DX:b@Z92XT:RP[00<T
:P0::2/T:B@Z92TT:R@Y92XT:B@Z92T7Ool00`00Oomoo`0IOol000Qoo`03001oogoo00Aoo`11=C8e
<cDB>C<e<SDc=A8i<cDb=C<e4STc=C8e<cDb>E<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8i
DcDb>E<e<SUC=C8iDcDb>E<e<SUC=E<iE3EC>E<eDcUD=E<iDcEC>E@eDcUC=E<mM3UC>G@iDced>E<i
M3UC?G@iD`02>G@0:cfE>G@003Ud?IDiM3ed>G@mUCUd?G@iM3fE>I@mUCUd?IDiU3fE>G@mUCVD?IDT
:RP[92XX:b@Z:2/T:RP[82TT:R0Y92XP:B@Z82TT:R0Y92XP:B0900Moo`03001oogoo01Uoo`0027oo
00<007ooOol017oo33Db01`e<cDb>C<e<SDc=C8i<cDb=C<e<STc=C8e<cDb>E<e<cUC=C<iDcDc>E<e
<cUC=C<iDcDc>E<e<`diD`0;>E@iM3UC>G@iE3Ud>E<iM3UD>G@iD`02>G@01Ced>G@iM000?G@00cUd
00@mM3Ud>G@iM0`mU@05:2/T:R@Z92XX:`0292X02R@Y92XT:B@Z92TT:R@Y92XT:B@Z0b081goo00<0
07ooOol06Goo0007Ool00`00Oomoo`05Ool0<cDB>C<e<SDc=A8i<cDb=C<e4STc=C8i<cDb>E<e<STc
=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E@eDcUC=E<iE3EC>E<eDcUD
=E<iDcEC>E@eD`02>E<08Sed>E<iM3UC?G@iDcUd>E<mM3UC?G@iM3fE>G@mM3Ud000iM3ed>G@mUCUd
?G@iM3fE>I@mUCUd?IDiU3fE>G@mUCVD0SfE00E1]R@Z:2/T:RP[008T:P0=82TT:R0Y92XP:B@Z82TT
:R0890TP220980P027oo00<007ooOol06Goo0007Ool00`00Oomoo`05Ool:=C8033Dc=C8i<cDb=C<e
<STc=C8e<cDb>C<e<P8e<`0<>E<e<cUC=C<iDcDc>E<e<cUC=C<iDcDc3SUC00`iM3UD>G@iDcUd>E@i
M3UC>G@iE3Ud>E<2>G@00ced>G@iM002000013Ud000003ed0SUd2cfE00Lm]Sfe?KHm]Cff92XX:`02
92X01b@Y92XT:B@Z92TT:R@Y008P200580TP220880PP2@09Ool00`00Oomoo`0HOol000Moo`03001o
ogoo00Ioo`10=C<e4STc=C8e<cDB>C<e<STc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8iDcDb>E<e
<SUC=C8iDcDb>E<e<SUC=C8iE3EC>E<eDcUD=E<iDcEC>E@eDcUC=E<mM3UC>G@iDced>E<iM3UC?G@i
DcUd>E<mM3Ud?G@iM3fE>G@200001CfE>G@mM3Ud?ID00P0002<iM3fE>I@mUCUd?IDiU3fE>G@mUCVD
@KHmUD6f?KE1]SfE:2/P:B@Z82TT:R0Y92XP:B@Z80PP2B0890TP220980PT2A`600Uoo`03001oogoo
01Qoo`001goo00<007ooOol01Woo1CDb01Xi<cDb=C<e<STc=C8e<cDb>C<e<SDc=C8i<cDb>E<e<cUC
=C<iDcDc>E<e<cUC=C<iDcDc3SUC00`iM3UC>G@iE3Ud>E<iM3UD>G@iDcUd>E@4>G@01Ced000003Ud
?G@00cUd00@mM3fE?IDmU@8000LmU@0@?KDm]Sfe?KHm]Cff?KDm]Sfe92XT:B@Z92TT:R@Y92X380P0
120980PP22080a`72Goo00<007ooOol067oo0007Ool00`00Oomoo`06Ool0:STc=C8e<cDb>E<e<STc
=C8iDcDb>C<e<SUC=C8i<cDb>E<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUC=E<iE3EC>E<eDcUD
=E<iDcEC>E@eD`8iD`0O?G@iDcUd>E<mM3UC>G@iDced>E<iM3UC?IDiM3ed>G@mU@00?G@iM3fE>G@m
M3Ud?IDiU3fE>G@mUCVD?ID00P0001hiU3fE?IE1]Sfe@KHmUD6f?KE1]SfE@KHm]D6f82TT:R0Y92XP
:B@980PP2B0890TP220980PP1a`670L:Ool00`00Oomoo`0HOol000Moo`03001oogoo00Ioo`<e<P0J
>C<e<SDc=C8i<cDb=C<e<STc=C8e<cDb>E<e<cUC=C<iDcDc>E<e<cUC=C<iDcDc>E<e<`diD`0;>E@i
M3UC>G@iE3Ud>E<iM3UD>G@iD`02>G@013ed>G@iM3Ud0P000SUd00<mM3Ud>G@02cfE00`003fe?KHm
]Cff?KDm]Sfe?KHm]D7G@MH3@ML012@Y80PP22090b0800<P2B0880P01A`72Woo00<007ooOol067oo
0007Ool00`00Oomoo`06Ool0:3Tc=C8iDcDb>C<e<SUC=C8i<cDb>E<e<STc=C8iDcDb>E<e<SUC=C8i
DcDb>E<e<SUC=C8iDcDb>E<eDcUD=E<iDcEC>E@eDcUC=E<iE3EC0SUC00XmM3UC>G@iDced>E<iM3UC
?G@iD`8iM003?IDiM3ed0080000C>G@mM3Ud?IDiM3fE>G@mUCVD?IDiM3fE>I@mUCUd?IDiU46f?ID0
0P0001]1]SfE@KHm]D6f?IE1mcgF@MLmeT7g?MHP2B0890TP220980PT2B0870LL1R0770HL1a`660D0
2Woo00<007ooOol067oo0007Ool00`00Oomoo`06Ool02cDb>C<e<SDc=C8i<cDb=C<e<STc=C800SDc
00`iDcDc>E<e<cUC=C<iDcDc>E<e<cUC=C<>>E<033Ud>E@iM3UC>G@iE3Ud>E<iM3UD>G@iD`8iM005
?G@iM000000mM003>G@00ced>G@mU@0:?ID01Sfe?KHm]Cff?KDm]P800005?KDm]T7G@MM1eP03@ML0
147F@MM1eb090b0800<P2A`770L011`700<H11P560@02Woo00<007ooOol067oo0006Ool00`00Oomo
o`07Ool0DSUC=C8i<cDb>E<e<STc=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E<eDcUD=E<i
DcEC>E@eDcUC=E<iE3EC>E<eDcUD>E<iM3UC?G@iDcUd>E<mM3UC>G@iDced>E<mM3Ud?IDiM000>G@m
UCUd?G@iM3fE>I@mUCUd?IDiU3fE>G@mUCVD?IDiM46f?KE1]SfE@KHm]D6f?IE1]Sfe0P0001I1mcgF
@MLmeT7g?MI1ed7hAQQ1n20970HP1a`670LL1R0770HH1A@460DD10]oo`03001oogoo01Qoo`001Woo
00<007ooOol01goo01De<SDc=C8i<cDb=C<e<STc=C8iDcDc>E<e<cUC=C<iDcDc>E<e<cUC=C<03SUC
00`iM3UC>G@iE3Ud>E<iM3UD>G@iDcUd>E@4>G@01Ced000003Ud?G@00cUd00<mM3fE?ID02CfE00Xm
]Sfe?KHm]Cff?KDm]Sfe?KHm]@=1e`800091e`06@MI6648HAQQ264HH1Q`700HH11P560@H1AP460D<
Ool00`00Oomoo`0GOol000Ioo`03001oogoo00Qoo`0O=C8iDcDb>C<e<SUC=C8iDcDb>E<e<SUC=C8i
DcDb>E<e<SUC=C8iDcEC>E@eDcUC=E<iE3EC>E<eDcUD=E<00SUC00XmM3UC>G@iDced>E<iM3UC?G@i
D`8iM004?IDiM3ed>G@2000043ed>G@mUCUd?G@iM3fE>I@mUCUd?IDiU3fE>G@mUCVD0SfE02A1]Sfe
@KHmUD6f?KE1]SfE@KHmeT7G?MI1mcgF@MLmeP00?MI6647hAQQ1n4HH@OQ661`670LL1R0750@H1A@4
404<0A01304<Ool00`00Oomoo`0GOol000Ioo`03001oogoo00Qoo`0B>C<e<SDc=C8i<cDc>E<e<cUC
=C<iDcDc>E<e<cUC=C<iDcDc3CUC00/iE3Ud>E<iM3UD>G@iDcUd>E@iM3UC008iM003?G@iM3Ud0080
00<iM003?G@iM3fE00XmU@0=?KDm]Sfe?KHm]Cff?KDm]Sfe?KHm]D7G@MH00d7G00E1eT7G@MM1ed8H
0080000@AQQ264HH@QQ:FTIJBUXL1aP560@H1AP4404<0A01304=Ool00`00Oomoo`0GOol000Ioo`03
001oogoo00Qoo`1H=C8i<cDb>E<e<SUC=C8iDcDb>E<e<SUC=C8iDcDb>E<e<SUC=E<iE3EC>E<eDcUD
=E<iDcEC>E@eDcUd>E<mM3UC>G@iDced>E<iM3UC?G@iDced>G@mUCUd?G@003fE>G@mM3Ud?IDiM3fE
>G@mUCVD?IDiM3fE>I@mUCUd?IDm]D6f?IE1]Sfe@KHmUD6f?KE1ecgF@OLmeT7G?MI1mcgF@MLmeT7g
@OQ6647hAQP200003DIIBWY6FTYjAUTH1A@460D<0A01304@0@0000ioo`03001oogoo01Moo`001Woo
00<007ooOol027oo00he<cDb>E<e<cUC=C<iDcDc>E<e<cUC=C<iDcDc33UC00`iM3UC>G@iE3Ud>E<i
M3UD>G@iDcUd>E@4>G@01Ced>G@00000?G@00cUd00<mM3fE?ID02CfE00Xm]Sfe?KHm]Cff?KDm]Sfe
?KHm]@=1e`05@MI1ed7G@MM1eP02@ML024HH@QQ6648HAQQ264HHAUX2000024YJAUY:FTIJ60D<0A01
3042000?Ool00`00Oomoo`0GOol000Ioo`03001oogoo00Qoo`0Z=C8iDcDb>E<e<SUC=C8iDcDb>E<e
<SUC=C8iE3EC>E<eDcUD=E<iDcEC>E@eDcUC=E<mM3UC>G@iDced>E<iM3UC?G@iDcUd>E<mM3Ud?G@i
M3fE0P0003LiM3fE>G@mM3Ud?IDiU3fE>G@mUCVD?IDiM3fE>I@mUCUd@KHm]D6f?IE1]Sfe@KHmUD6f
?MI1ecgF@OLmeT7G?MI1md7hAQQ1n4HH@OQ6647hAQQ1n4YjAUU:NTIJBWX004kMB]a>gDZl404<0@02
000@Ool00`00Oomoo`0GOol000Ioo`03001oogoo00Qoo`0<>E<e<cUC=C<iDcDc>E<e<cUC=C<iDcDc
33UC00diM3UC>G@iE3Ud>E<iM3UD>G@iDcUd>E@mM003>G@20002>G@013ed>G@iM3Ud2cfE00/m]Cff
?KDm]Sfe?KHm]Cff?KDm]T7F00=1e`0D@MI1ed7G@MM264HH@QQ6648HAQQ264HH@QQ:FTIJBUY6FTYJ
B]a>g@800004B]a?OdmNCglBOol00`00Oomoo`0GOol000Ioo`03001oogoo00Qoo`1O=C8iDcDb>E<e
<SUC=C8iDcDb>E<eDcUD=E<iDcEC>E@eDcUC=E<iE3EC>G@iDced>E<iM3UC?G@iDcUd>E<mM3UC>G@i
DcfE>G@mM3Ud000iM3ed>G@mUCUd?G@iM3fE>I@mUCUd?IDiU3fE>G@mUCfe@KHmUD6f?KE1]SfE@KHm
]D6f?IE1mcgF@MLmeT7g?MI1ecgFAQQ1n4HH@OQ6647hAQQ1n4HHAUY:NTIIBWY6FTkMB[a>gD[LC]e?
GP02000DOol00`00Oomoo`0GOol000Eoo`03001oogoo00Uoo`08>E<e<cUC=C<iDcDc>E<e<``iD`0<
>G@iE3Ud>E<iM3UD>G@iDcUd>E@iM3UC0SUd00<mM3Ud>G@00P000cUd00<mM3Ud>G@02SfE00Tm]Cff
?KDm]Sfe?KHm]Cff?KD00d7G00E1eT7G@MM1ed7F0091e`0DAQQ264HH@QQ6648HBUY6FTYJAUY:FTIJ
BUY:g4kLB]a>gDmNCgm?GP8oV`03Ool0000001=oo`03001oogoo01Ioo`001Goo00<007ooOol02Woo
028iDcDb>E<e<SUC=E<iDcEC>E@eDcUC=E<iE3EC>E<eDcUD=E<iM3UC?G@iDcUd>E<mM3UC>G@iDced
>E<mM3Ud?IDiM080000i?IDiM3ed>G@mUCUd?IDiM3fE>I@mUCUd?IDiU3fE>GA1]Sfe@KHmUD6f?KE1
]SfE@KHm]D7G?MI1mcgF@MLmeT7g?MI1ed7hAQQ1n4HH@OQ6647hBWY6FDYjAUY:NTIIC]e:g4kMB[a?
OdmNCgloVSnK00Eoo`80015oo`03001oogoo01Ioo`001Goo00<007ooOol02Woo00<e<cUC=C<03SUC
00`iM3UD>G@iDcUd>E@iM3UC>G@iE3Ud>E<2>G@01Ced000003Ud?G@00cUd2SfE00`m]Sfe?KHm]Cff
?KDm]Sfe?KHm]Cff@MH3@ML06T7F@MM1ed7G@QQ6648HAQQ264HH@QQ664IJBUY6FTYJAUY:FTIJC]e:
g4kLCei?OdmNCgl:Ool00`00Oomoo`0>Ool00`00Oomoo`0FOol000Eoo`03001oogoo00Yoo`1H>E<e
<SUC=E<iDcEC>E@eDcUC=E<iE3EC>E<eDcUD>E<iM3UC?G@iDcUd>E<mM3UC>G@iDced>G@mM3Ud?ID0
03ed>G@mUCUd?G@iM3fE>I@mUCUd?IDiU3fE>G@mUCVD@KHmUD6f?KE1]SfE@KHm]D6f?IE1]SgF@MLm
eT7g?MI1ecgF@OM1n4HH@OQ6647hAQQ1n4HHAUY:NTIIBWY6FTYjB[a>gD[LC]e?GTmoCeh=Ool2000>
Ool00`00Oomoo`0FOol000Eoo`03001oogoo00Yoo`diD`0:>G@iDcUd>E@iM3UC>G@iE3Ud>E<2>G@0
13ed>G@iM3Ud0P000SUd00@mM3Ud>G@iM0XmU@0<?KHm]Cff?KDm]Sfe?KHm]Cff?KE1ed7F0d7G01U1
eT7G@MM6648HAQQ264HH@QQ6648HBUY6FTYJAUY:FT[LC]a:g4kMB]a?OdmN?i/0000@Ool2000<Ool0
0`00Oomoo`0FOol000Eoo`03001oogoo00Yoo`0:>E@eDcUC=E<iE3EC>E<eDcUD=E<2>E<02Sed>E<i
M3UC?G@iDcUd>E<mM3UC0SUd00<mUCUd?G@00P0003PiM3ed>G@mUCUd?IDiM3fE>I@mUCUd?IDiU3fE
>G@mUCVD@KHmUD6f?KE1]SfE@KHm]D7G?MI1mcgF@MLmeT7g?MI1ecgFAQQ1n4HH@OQ6647hBWY6FDYj
AUY:NTIIBWY:g4kMB[a?OdmNCgloVSnK57oo0P002Woo00<007ooOol05Woo0005Ool00`00Oomoo`0;
Ool9>E<02cUD>G@iDcUd>E@iM3UC>G@iE3Ud>E<00SUd00DmM3Ud>G@003ed00<iM003?G@iM3fE00Xm
U@09?KDm]Sfe?KHm]Cff?KDm]Sfe00=1e`0I@MI1ed7G@MM1eT7G@QQ6648HAQQ264HH@QQ:FTIJBUY6
FTYJAUY>gD[LC]a:g4moCeh00SnK67oo0P0027oo00<007ooOol05Woo0005Ool00`00Oomoo`0;Ool0
5cEC>E@eDcUC=E<iE3EC>G@iDced>E<iM3UC?G@iDcUd>E<mM3Ud?G@iM3fE>G@00P0000hmUCUd?G@i
M3fE>I@mUCUd?IDiU3fE>G@mUCVD0SfE02I1]Sfe@KHmUD6f?KE1]SfE@KHmeT7G?MI1mcgF@MLmeT7g
@OQ6647hAQQ1n4HH@OQ664IJBWY6FDYjAUY>gDZlC]e:g4kMCei?OdmN7Goo00<007ooOol01Goo00<0
07ooOol05Woo0005Ool00`00Oomoo`0;Ool6>E<02cUd>E@iM3UC>G@iE3Ud>E<iM3UD?G@00cUd00Dm
M000000iM3ed00<iM0/mU@08?KDm]Sfe?KHm]Cff?KDm]P91e`05@MI1ed7G@MM1eP03@ML05D8HAQQ2
64HH@QQ6648HAQQ6FTYJAUY:FTIJC]a:g4kMB]a?OdmNCgloV`0OOol20006Ool00`00Oomoo`0EOol0
00Aoo`03001oogoo00aoo`0C=E<iDcEC?G@iDcUd>E<mM3UC>G@iDced>E<iM3UC?IDiM3ed>G@00P00
03LmM3Ud?IDiM3ed>G@mUCVD?IDiM3fE>I@mUCUd?IDiU46f?IE1]Sfe@KHmUD6f?KE1]SgF@OLmeT7G
?MI1mcgF@MLmeTHH@OQ6647hAQQ1n4HH@OQ:NTIJBWY6FDYjB]a>gDZlC]e?GTmo?iXoV`0SOol20004
Ool00`00Oomoo`0EOol000Aoo`03001oogoo00eoo`0>>E<iM3UC>G@iE3Ud>E<iM3UD>G@iDcUd>E@m
M0<iM005000iM3Ud>G@mM002>G@:?ID02Sfe?KHm]Cff?KDm]Sfe?KHm]Cff0T7G01Y1eT7G@MM1ed7F
AQQ264HH@QQ6648HAQQ264YJAUY:FTIJBUY6FTkMB]a>g4mNCgm?GTmo:7oo0P000Woo00<007ooOol0
5Goo0004Ool00`00Oomoo`0=Ool03ced>E<iM3UC?G@iDcUd>E<mM3UC?G@iM3fE>G@mM0020000=SUd
?G@iM3fE>I@mUCUd?IDiU3fE>G@mUCVD?IDiM3fE?KE1]SfE@KHm]D6f?IE1]SgF@MLmeT7g?MI1ecgF
@OLmeTHH@OQ6647hAQQ1n4HH@OQ:NTIIBWY6FTYjB[a>gD[LC]e?GTmoCehoVb]oo`<001Moo`0017oo
00<007ooOol03Goo00TiDcUd>E@iM3UC>G@iE3Ud>E<00SUd00DmM3Ud000003ed00<iM0`mU@0:?KHm
]Cff?KDm]Sfe?KHm]Cff@MH3@ML05d7F@MM1ed7G@QQ6648HAQQ264HH@QQ664IJBUY6FTYJB]a>g4[L
C]e:g4moCeh00SnK;Woo0P005goo0004Ool00`00Oomoo`0=Ool02cUd>E<mM3UC>G@iDced>E<mM3Ud
?ID00P0003DiM3fE>G@mM3Ud?IDiU3fE>G@mUCVD?IDiM3fE>IA1]SfE@KHm]D6f?IE1]Sfe@KHmUD7g
?MI1ecgF@OLmeT7G@OQ6647hAQQ1n4HH@OQ664IIBWY6FTYjAUU:NT[LC]e:_4moCei?OdmN02moo`80
01Uoo`0017oo00<007ooOol03Woo00DiM3UC>G@iE3ed00<iM005?G@003Ud>G@mM002>G@:?ID02Cfe
?KHm]Cff?KDm]Sfe?KHm]@03@ML06d7F@MM1ed7G@MI1ed8HAQQ264HH@QQ6648HAQQ6FTYJAUY:FTIJ
BUY:g4kLB]a?OdmNCgloV`0^Ool2000KOol000Aoo`03001oogoo00ioo`07>E<iM3Ud?IDiM3ed>G@0
0P0003<mM3Ud?IDiM3fE>G@mUCVD?IDiM3fE>I@mUCUd?IDm]D6f?IE1]Sfe@KHmUD6f?KE1ecgF@OLm
eT7G?MI1mcgFAQQ1n4HH@OQ6647hAQQ1n4YjAUU:NTIJBWY:_4kMB]a>gDmNCgl00SnK;Woo0P007Goo
0004Ool00`00Oomoo`0>Ool2>G@00ced>G@iM0020003>G@00ced>G@mU@09?ID02Sff?KDm]Sfe?KHm
]Cff?KDm]Sfe0d7G01Q1eT7G@MM1ed8HAQQ264HH@QQ6648HBUY6FTYJAUY:FTIJBUY:g4kMCei?OdmN
Cgl_Ool2000OOol000=oo`03001oogoo00moo`03>G@mUCUd0080000>?IDiM3ed>G@mUCUd?IDiM3fE
>I@mUCUd?IDiU08mU@0U@KHm]D6f?IE1]Sfe@KHmUD7g?MI1ecgF@OLmeT7G?MI1md7hAQQ1n4HH@OQ6
647hBWY6FTYjAUU:NTIJC]e:_4kMCei?OdmN?i/0;Goo0`008Goo0003Ool00`00Oomoo`0?Ool01Ced
>G@003Ud?G@00cUd2cfE00/m]Cff?KDm]Sfe?KHm]Cff?KE1ed7F00=1e`0E@MI1ed7GAQQ264HH@QQ6
648HAQQ6FTYJAUY:FTIJC]e:g4kLB]a?OdmN008oVbeoo`8002Aoo`000goo00<007ooOol03goo0P00
03@iM3fE>G@mM3Ud?IDiU3fE>G@mUCVD?IDiM3fE>IA1]SfE@KHm]D6f?IE1]Sfe@KHmeT7g?MI1ecgF
@OLmeTHH@OQ6647hAQQ1n4HHAUY:NTIIBWY6FTYjAUU>gD[LC]e?GTmoCeh002eoo`8002Ioo`000goo
00<007ooOol03Goo0P0000=oocUd?G@00SUd2SfE00Tm]Cff?KDm]Sfe?KHm]Cff?KD00d7G01U1eT7G
@MM1ed7FAQQ264HH@QQ6648HBUY6FTYJAUY:FTIJBUY:g4kMB]a>g4mNCgloV`0]Ool2000XOol000=o
o`03001oogoo00]oo`8000=oo`0:?IDiM3ed>G@mUCVD?IDiM3fE>I@2?ID09D6f?KE1]SfE@KHm]D6f
?IE1mcgF@MLmeT7g?MI1ecgF@OLmeTHH@OQ6647hAQQ1n4YjAUY:NTIIBWY:g4kMB[a>gD[LCgm?GSnK
02eoo`8002Yoo`000goo00<007ooOol02Woo00<007ooOol00goo2SfE00/m]Cff?KDm]Sfe?KHm]Cff
?KE1ed7F00=1e`0G@MI1ed7GAQQ264HH@QQ6648HAQQ6FTYJAUY:FT[LC]e:g4kLB]a?OdmNCgm?GP0]
Ool2000/Ool000=oo`03001oogoo00Qoo`8000Ioo`08?IDiM3fE>I@mUCUd?IDiU08mU@0S@KHm]D6f
?IE1]Sfe@KHmUD7g?MI1ecgF@OLmeTHH@OQ6647hAQQ1n4HHAUY:NTIIBWY6FTYjB[a>gD[LC]e:_4mo
Cei?O`0/Ool3000^Ool000=oo`03001oogoo00Ioo`8000Uoo`DmU@09?KDm]Sfe?KHm]Cff?KDm]Sfe
00=1e`0H@MI1ed7G@MM1eTHH@QQ6648HAQQ264HHAUY:FTIJBUY6FTYJB]a>gD[LC]a?GTmo0SnK:goo
0P00<Goo0003Ool00`00Oomoo`04Ool2000;Ool0:3VD?IDiM46f?KE1]SfE@KHm]D6f?IE1]SgF@MLm
eT7g?MI1ecgF@OLmeTHH@OQ6647hAQQ1n4HHAUY:NTIIBWY:g4kMB[a>gD[LCgloVSnK;7oo0P00<goo
0002Ool00`00Oomoo`04Ool00`00Oomoo`0<Ool02cfE?KHm]Cff?KDm]Sfe?KHm]Cff@MH00d7G01I1
eT7G@MM6648HAQQ264HH@QQ664IJBUY6FTYJAUY:FT[LC]a:g4moCei?Obeoo`8003Eoo`000Woo00<0
07ooOol00Woo0P003goo02=1]Sfe@KHmUD6f?KE1]SfE@OLmeT7G?MI1mcgF@MM1n4HH@OQ6647hAQQ1
n4YjAUU:NTIJBWY6FDkMB]a>gDZlCgm?GTmo02aoo`8003Moo`000Woo00<007ooOol00P004Goo00Hm
]Cff?KDm]Sfe?KH2@ML0647F@MM1ed7G@MI1ed8HAQQ264HH@QQ6648HBUY6FTYJAUY:FT[LC]e:g4kL
Cei?O`8oVbYoo`<003Uoo`000Woo0`0057oo01hmUD6f?KE1ecgF@OLmeT7G?MI1mcgFAQQ1n4HH@OQ6
647hAQQ6FTYjAUU:NT[LC]e:_4kMB]a?OcnJ?i/[Ool2000lOol0009oo`8001Eoo`03?KHm]D7G0091
e`0H@MI1ed7G@MM264HH@QQ6648HAQQ6FTYJAUY:FTIJC]e:g4kLB]a?OdmNCgmoo`00:Woo0P00?Woo
0004Ool2000COol06SgF@MLmeT7g?MI1ed7hAQQ1n4HH@OQ6647hBWY6FDYjAUY:NTIIC]e:g4kMB[a?
OdmNCgl2Ool00`00Oomoo`0VOol20010Ool000Ioo`<0015oo`91e`0E@MI1ed8HAQQ264HH@QQ6648H
BUY6FTYJAUY:FT[LC]e:g4kLCei?OcnK00Aoo`03001oogoo02Aoo`80049oo`002Goo0P003goo01E1
mcgF@MM1n4HH@OQ6647hAQQ1n4YjAUU:NTIJC]e:_4kMB]a?OdmN?i/01Woo00<007ooOol08Woo0P00
A7oo000;Ool3000=Ool044HH@QQ6648HAQQ264YJAUY:FTIJC]e:g4kLB]a?OdmN0SnK27oo00<007oo
Ool07goo0`00AWoo000>Ool3000;Ool03THH@OQ664IIBWY6FTYjAUU>gD[LC]e?GTmoCeh;Ool00`00
Oomoo`0MOol20019Ool0015oo`8000Uoo`0=AUY:FTIJBUY6FTYJAUY>gD[LC]a?GTmoCeh037oo00<0
07ooOol06goo0P00Bgoo000COol30007Ool02TIIBWY6FTkMB[a>gD[LC]e?GSnK3Woo00<007ooOol0
6Goo0P00CGoo000FOol20006Ool01T[LC]a:g4kMCei?O`8oV`moo`03001oogoo01Moo`8004moo`00
67oo0`001Goo00=?OdmN?i/04Woo00<007ooOol057oo0`00DGoo000KOol2000HOol00`00Oomoo`0B
Ool2001DOol001eoo`<001Eoo`03001oogoo011oo`8005Ioo`0087oo0P004goo00<007ooOol03Woo
0P00F7oo000ROol3000@Ool00`00Oomoo`0<Ool2001JOol002Eoo`8000ioo`03001oogoo00Yoo`80
05aoo`009goo0`002goo00<007ooOol01goo0`00GWoo000ZOol30008Ool00`00Oomoo`05Ool2001Q
Ool002eoo`8000Ioo`03001oogoo00=oo`8006=oo`00;goo0`000goo00@007ooOomoo`8006Eoo`00
<Woo0P0000=oo`00Ool00P00Igoo000dOol3001YOol00:1oo`00FWoo0P00A7oo001IOol01000Oomo
o`00@goo001IOol00`00Oomoo`14Ool005Qoo`D004=oo`00FGoo00<007ooOol0A7oo002POol00:1o
o`00X7oo000JOol00`00Ool00023Ool001Uoo`05001oo`00Ool00022Ool001Uoo`05001oo`00Ool0
0022Ool001Qoo`<00003Ool00000089oo`00X7oo002POol00:1oo`00X7oo0000\
\>"],
  ImageRangeCache->{{{-8, 172.188}, {178.625, -4.5}} -> {0.102882, \
-0.0266661, 0.00592471, 0.00592471}}]
}, Open  ]],

Cell[TextData[{
  "The simplification of the skeleton is the reason why the Riccati equation \
takes the integrable form when written in canonical variables (cf. the ",
  ButtonBox["skeleton of the original Riccati equation",
    ButtonData:>"skeleton-Riccati",
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  CellTags->"canonical variables"],

Cell[TextData[{
  "The stretching of the original Riccati equation is replaced by a group of \
translations",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[
            RowBox[{
              FormBox[\(t\&_\),
                "TraditionalForm"], "=", \(t + \[Epsilon]\)}],
            "InlineFormula"]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(w = u\),
          "InlineFormula"], TraditionalForm]]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`w' = u'\)], "InlineFormula"],
  ". The calculations so far executed by hand can be collected in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function. The information we need for the calculation are the original \
equation and the names of the dependent and independent variables. We also \
need the canonical transformations which are derived by the function ",
  ButtonBox["CanonicalVariables[]",
    ButtonData:>{"symmet11.nb", "CanonicalVariables["},
    ButtonStyle->"Hyperlink"],
  ". Finally, the function has to know the names of the new coordinates. The \
representation of the original equation is carried out by the function ",
  StyleBox["CanonicalRepresentation[]:", "MmaText"]
}], "Text",
  CellTags->{"CanonicalVariables[]", "CanonicalRepresentation[]"}],

Cell[BoxData[{\(Clear[CanonicalRepresentation]\), 
    RowBox[{
    \(CanonicalRepresentation[equation_, depend_, \n\tindepend_, 
        canonicaltrafo_List, newdepend_, \n\tnewindepend_]\), ":=", "\n", 
      "\t", 
      RowBox[{"Block", "[", 
        RowBox[{
        \({pattern1, trafo1, eqin, ctrafo, \n\t\t\tcanonicalvariables, sol, 
            equat}\), ",", "\n", "\t\t", 
          RowBox[{
            RowBox[{"pattern1", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{"a_.", " ", 
                      RowBox[{
                        SuperscriptBox["u_", "\[Prime]",
                          MultilineFunction->None], "[", "x_", "]"}]}], "+", 
                    "p_."}], "==", "0"}], "\[RuleDelayed]", 
                \(\(a\ Dt[u]\)\/Dt[x] + p\)}]}], ";", "\n", "\t\t", 
            \(trafo1 = depend@@{independ} \[Rule] depend\), ";", "\n", 
            "\t\t", \(eqin = \(equation /. pattern1\) /. trafo1\), ";", "\n", 
            "\t\t", \(ctrafo = canonicaltrafo /. Rule \[Rule] Equal\), ";", 
            "\n", "\t\t", 
            \(canonicalvariables = 
              Flatten[canonicaltrafo /. \n\t\t\t\t\t
                  \((a_ \[Rule] b_)\) \[Rule] {a}]\), ";", "\n", "\t\t", 
            \(sol = Solve[ctrafo, {depend, independ}]\), ";", "\n", "\t\t", 
            \(equat = Expand[eqin /. sol]\), ";", "\n", "\t\t", 
            \(equat = equat /. newdepend \[Rule] newdepend@@{newindepend}\), 
            ";", "\n", "\t\t", 
            \(equat\[LeftDoubleBracket]1\[RightDoubleBracket] == 0\)}]}], 
        "]"}]}]}], "Input",
  CellTags->"CanonicalRepresentation[]"],

Cell["\<\
We demonstrate the use of this function by applying it to the \
Riccati equation. We know that the Riccati equation is invariant with respect \
to an inhomogeneous scaling transformation. The related canonical variables \
are given by\
\>", "Text",
  Evaluatable->False,
  CellTags->{
  "Riccati equation", "inhomogeneous scaling transformation", 
    "canonical variables"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ccoord = 
      CanonicalVariables[{u}, {x}, {x}, {\(-u\)}, \n\t\t{w}, {t}]\)], "Input"],

Cell[BoxData[
    \({w \[Rule] Function[{x, u}, u\ x], t \[Rule] Function[{x, u}, Log[x]]}
      \)], "Output"]
}, Open  ]],

Cell["\<\
The result is identical with the variables stated above. Using this \
transformation, we can reduce the Riccati equation to\
\>", "Text",
  Evaluatable->False,
  CellTags->"reduce the Riccati equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cricc = 
      CanonicalRepresentation[riccati, u, x, \n
        \t\t{w \[Rule] x\ u, t \[Rule] Log[x]}, w, t]; cricc // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-2\)\ E\^\(\(-2\)\ t\) - E\^\(\(-2\)\ t\)\ w + 
                E\^\(\(-2\)\ t\)\ w\^2 + E\^\(\(-2\)\ t\)\ w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting equation has the same structure as the manually derived one. \
The common factor ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\^\(\(-2\) t\)\),
          "InlineFormula"], TraditionalForm]]],
  " is a non-vanishing term which can be eliminated by multiplying with the \
inverse:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(cricc = Simplify[Thread[cricc\ Exp[2\ t], Equal]]; cricc // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-2\) - w + w\^2 + w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This equation can be solved by quadrature or a separation of variables. We \
use here the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["DSolve[]", "MmaText"],
  " to integrate the equation."
}], "Text",
  Evaluatable->False,
  CellTags->{"separation of variables", "quadrature", "DSolve[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sricc = DSolve[cricc, w, t]\)], "Input"],

Cell[BoxData[
    \({{w \[Rule] 
          \((\(2\ E\^\(3\ #1\) + E\^\(3\ C[1]\)\)\/\(E\^\(3\ #1\) - 
                  E\^\(3\ C[1]\)\)&)\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
The solution in the original variables follows by applying the \
canonical transformation again,\
\>", "Text",
  Evaluatable->False,
  CellTags->"canonical transformation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solricc = 
      Simplify[\(w[x, u] == 
              \((w[t] /. sricc)\)\[LeftDoubleBracket]1
                \[RightDoubleBracket] /. \n\t\t\tt \[Rule] t[x, u]\) /. 
          ccoord]\)], "Input"],

Cell[BoxData[
    \(u\ x == 
      \(E\^\(3\ C[1]\) + 2\ x\^3\)\/\(\(-E\^\(3\ C[1]\)\) + x\^3\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "and solving the implicit solution with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ","
}], "Text",
  Evaluatable->False,
  CellTags->"implicit solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[solricc, u]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \(E\^\(3\ C[1]\) + 2\ x\^3\)\/\(x\ 
              \((\(-E\^\(3\ C[1]\)\) + x\^3)\)\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
The second of our examples discussed above allows the same scaling \
symmetries. The reduced equation follows from\
\>", "Text",
  Evaluatable->False,
  CellTags->"scaling symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cex2 = 
      CanonicalRepresentation[example2, u, x, \n
        \t\t{w \[Rule] x\ u, t \[Rule] Log[x]}, w, t]; cex2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(E\^\(\(-4\)\ t\)\ w + E\^\(\(-4\)\ t\)\ w\^2 + 
                E\^\(\(-4\)\ t\)\ w\^3 - E\^\(\(-4\)\ t\)\ w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The common factor is eliminated by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(cex2 = Simplify[Thread[cex2\ Exp[4\ t], Equal]]; cex2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(w + w\^2 + w\^3 - w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution in the canonical variable ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " follows by separation of variables and integrating the left-hand side and \
the right-hand side:"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "canonical variables", "separation of variables", 
    "integration by separation of variables"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sex2 = 
      Simplify[\[Integral]\(1\/\(w + w\^2 + w\^3\)\) \[DifferentialD]w == 
          \[Integral]1 \[DifferentialD]t + c]\)], "Input"],

Cell[BoxData[
    \(\(-\(ArcTan[\(1 + 2\ w\)\/\@3]\/\@3\)\) + Log[w] - 
        1\/2\ Log[1 + w + w\^2] == c + t\)], "Output"]
}, Open  ]],

Cell["\<\
Since the solution contains transcendent functions, it is hard to \
get an explicit solution at this stage. The inversion of the canonical \
transformation does not resolve this problem:\
\>", "Text",
  Evaluatable->False,
  CellTags->"canonical transformation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(iex2 = \(sex2 /. {w \[Rule] w[x, u], t \[Rule] t[x, u]}\) /. ccoord\)], 
  "Input"],

Cell[BoxData[
    \(\(-\(ArcTan[\(1 + 2\ u\ x\)\/\@3]\/\@3\)\) + Log[u\ x] - 
        1\/2\ Log[1 + u\ x + u\^2\ x\^2] == c + Log[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "However, we can resolve this problem by a graphical representation of the \
solution. We create a contour plot by displaying the implicit function for a \
fixed parameter ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->"graphical representation of the solution"],

Cell[BoxData[
    \(\(iex2h = \(iex2 /. a_ == b_ \[Rule] a - b\) /. c \[Rule] 1; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[iex2h, {x,  .01, 2}, {u,  .01, 1}, \n\t
      ColorFunction \[Rule] Hue, PlotPoints \[Rule] 20]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0143989 0.483185 0.00951826 0.971251 [
[.0144 -0.0125 -3 -9 ]
[.0144 -0.0125 3 0 ]
[.25599 -0.0125 -9 -9 ]
[.25599 -0.0125 9 0 ]
[.49758 -0.0125 -3 -9 ]
[.49758 -0.0125 3 0 ]
[.73918 -0.0125 -9 -9 ]
[.73918 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00952 -6 -4.5 ]
[-0.0125 .00952 0 4.5 ]
[-0.0125 .20377 -18 -4.5 ]
[-0.0125 .20377 0 4.5 ]
[-0.0125 .39802 -18 -4.5 ]
[-0.0125 .39802 0 4.5 ]
[-0.0125 .59227 -18 -4.5 ]
[-0.0125 .59227 0 4.5 ]
[-0.0125 .78652 -18 -4.5 ]
[-0.0125 .78652 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0144 0 m
.0144 .00625 L
s
[(0)] .0144 -0.0125 0 1 Mshowa
.25599 0 m
.25599 .00625 L
s
[(0.5)] .25599 -0.0125 0 1 Mshowa
.49758 0 m
.49758 .00625 L
s
[(1)] .49758 -0.0125 0 1 Mshowa
.73918 0 m
.73918 .00625 L
s
[(1.5)] .73918 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06272 0 m
.06272 .00375 L
s
.11104 0 m
.11104 .00375 L
s
.15935 0 m
.15935 .00375 L
s
.20767 0 m
.20767 .00375 L
s
.30431 0 m
.30431 .00375 L
s
.35263 0 m
.35263 .00375 L
s
.40095 0 m
.40095 .00375 L
s
.44927 0 m
.44927 .00375 L
s
.5459 0 m
.5459 .00375 L
s
.59422 0 m
.59422 .00375 L
s
.64254 0 m
.64254 .00375 L
s
.69086 0 m
.69086 .00375 L
s
.7875 0 m
.7875 .00375 L
s
.83581 0 m
.83581 .00375 L
s
.88413 0 m
.88413 .00375 L
s
.93245 0 m
.93245 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00952 m
.00625 .00952 L
s
[(0)] -0.0125 .00952 1 0 Mshowa
0 .20377 m
.00625 .20377 L
s
[(0.2)] -0.0125 .20377 1 0 Mshowa
0 .39802 m
.00625 .39802 L
s
[(0.4)] -0.0125 .39802 1 0 Mshowa
0 .59227 m
.00625 .59227 L
s
[(0.6)] -0.0125 .59227 1 0 Mshowa
0 .78652 m
.00625 .78652 L
s
[(0.8)] -0.0125 .78652 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05808 m
.00375 .05808 L
s
0 .10664 m
.00375 .10664 L
s
0 .15521 m
.00375 .15521 L
s
0 .25233 m
.00375 .25233 L
s
0 .30089 m
.00375 .30089 L
s
0 .34946 m
.00375 .34946 L
s
0 .44658 m
.00375 .44658 L
s
0 .49514 m
.00375 .49514 L
s
0 .54371 m
.00375 .54371 L
s
0 .64083 m
.00375 .64083 L
s
0 .68939 m
.00375 .68939 L
s
0 .73796 m
.00375 .73796 L
s
0 .83508 m
.00375 .83508 L
s
0 .88364 m
.00375 .88364 L
s
0 .93221 m
.00375 .93221 L
s
.25 Mabswid
0 0 m
0 1 L
s
.0144 .99375 m
.0144 1 L
s
.25599 .99375 m
.25599 1 L
s
.49758 .99375 m
.49758 1 L
s
.73918 .99375 m
.73918 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06272 .99625 m
.06272 1 L
s
.11104 .99625 m
.11104 1 L
s
.15935 .99625 m
.15935 1 L
s
.20767 .99625 m
.20767 1 L
s
.30431 .99625 m
.30431 1 L
s
.35263 .99625 m
.35263 1 L
s
.40095 .99625 m
.40095 1 L
s
.44927 .99625 m
.44927 1 L
s
.5459 .99625 m
.5459 1 L
s
.59422 .99625 m
.59422 1 L
s
.64254 .99625 m
.64254 1 L
s
.69086 .99625 m
.69086 1 L
s
.7875 .99625 m
.7875 1 L
s
.83581 .99625 m
.83581 1 L
s
.88413 .99625 m
.88413 1 L
s
.93245 .99625 m
.93245 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .00952 m
1 .00952 L
s
.99375 .20377 m
1 .20377 L
s
.99375 .39802 m
1 .39802 L
s
.99375 .59227 m
1 .59227 L
s
.99375 .78652 m
1 .78652 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05808 m
1 .05808 L
s
.99625 .10664 m
1 .10664 L
s
.99625 .15521 m
1 .15521 L
s
.99625 .25233 m
1 .25233 L
s
.99625 .30089 m
1 .30089 L
s
.99625 .34946 m
1 .34946 L
s
.99625 .44658 m
1 .44658 L
s
.99625 .49514 m
1 .49514 L
s
.99625 .54371 m
1 .54371 L
s
.99625 .64083 m
1 .64083 L
s
.99625 .68939 m
1 .68939 L
s
.99625 .73796 m
1 .73796 L
s
.99625 .83508 m
1 .83508 L
s
.99625 .88364 m
1 .88364 L
s
.99625 .93221 m
1 .93221 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
1 .6 0 r
.01923 .0276 m
.06984 .028 L
.12045 .02842 L
.17105 .02887 L
.22166 .02935 L
.27227 .02985 L
.32287 .03037 L
.37348 .03092 L
.42409 .0315 L
.4747 .03211 L
.5253 .03274 L
.57591 .03341 L
.62652 .0341 L
.67713 .03483 L
.72773 .03559 L
.77834 .03637 L
.82895 .0372 L
.87955 .03805 L
.93016 .03894 L
.98077 .03987 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .0276 m
.06984 .028 L
.12045 .02842 L
.17105 .02887 L
.22166 .02935 L
.27227 .02985 L
.32287 .03037 L
.37348 .03092 L
.42409 .0315 L
.4747 .03211 L
.5253 .03274 L
.57591 .03341 L
.62652 .0341 L
.67713 .03483 L
.72773 .03559 L
.77834 .03637 L
.82895 .0372 L
.87955 .03805 L
.93016 .03894 L
.98077 .03987 L
s
.8 1 0 r
.01923 .03598 m
.06984 .03648 L
.12045 .037 L
.17105 .03755 L
.22166 .03813 L
.27227 .03874 L
.32287 .03937 L
.37348 .04002 L
.42409 .04071 L
.4747 .04142 L
.5253 .04216 L
.57591 .04293 L
.62652 .04373 L
.67713 .04455 L
.72773 .04541 L
.77834 .04629 L
.82895 .04721 L
.87955 .04815 L
.93016 .04912 L
.98077 .05013 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .03598 m
.06984 .03648 L
.12045 .037 L
.17105 .03755 L
.22166 .03813 L
.27227 .03874 L
.32287 .03937 L
.37348 .04002 L
.42409 .04071 L
.4747 .04142 L
.5253 .04216 L
.57591 .04293 L
.62652 .04373 L
.67713 .04455 L
.72773 .04541 L
.77834 .04629 L
.82895 .04721 L
.87955 .04815 L
.93016 .04912 L
.98077 .05013 L
s
.2 1 0 r
.01923 .04488 m
.06984 .04524 L
.12045 .04562 L
.17105 .04601 L
.22166 .04641 L
.27227 .04683 L
.32287 .04726 L
.37348 .04769 L
.42409 .04814 L
.4747 .04861 L
.5253 .04908 L
.57591 .04956 L
.62652 .05005 L
.67713 .05055 L
.72773 .05107 L
.77834 .05159 L
.82895 .05212 L
.87955 .05266 L
.93016 .0532 L
.98077 .05376 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .04488 m
.06984 .04524 L
.12045 .04562 L
.17105 .04601 L
.22166 .04641 L
.27227 .04683 L
.32287 .04726 L
.37348 .04769 L
.42409 .04814 L
.4747 .04861 L
.5253 .04908 L
.57591 .04956 L
.62652 .05005 L
.67713 .05055 L
.72773 .05107 L
.77834 .05159 L
.82895 .05212 L
.87955 .05266 L
.93016 .0532 L
.98077 .05376 L
s
0 1 .4 r
.01923 .05973 m
.06984 .06003 L
.12045 .06033 L
.17105 .06064 L
.22166 .06095 L
.27227 .06127 L
.32287 .06158 L
.37348 .0619 L
.42409 .06222 L
.4747 .06254 L
.5253 .06286 L
.57591 .06319 L
.62652 .06351 L
.67713 .06384 L
.72773 .06416 L
.77834 .06449 L
.82895 .06482 L
.87955 .06515 L
.93016 .06548 L
.98077 .06581 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .05973 m
.06984 .06003 L
.12045 .06033 L
.17105 .06064 L
.22166 .06095 L
.27227 .06127 L
.32287 .06158 L
.37348 .0619 L
.42409 .06222 L
.4747 .06254 L
.5253 .06286 L
.57591 .06319 L
.62652 .06351 L
.67713 .06384 L
.72773 .06416 L
.77834 .06449 L
.82895 .06482 L
.87955 .06515 L
.93016 .06548 L
.98077 .06581 L
s
0 1 1 r
.01923 .08597 m
.06984 .08658 L
.12045 .08721 L
.17105 .08785 L
.22166 .08851 L
.27227 .08919 L
.32287 .08988 L
.37348 .0906 L
.42409 .09134 L
.4747 .0921 L
.5253 .09289 L
.57591 .0937 L
.62652 .09454 L
.67713 .09541 L
.72773 .09631 L
.77834 .09724 L
.82895 .09821 L
.87955 .09921 L
.93016 .10026 L
.98077 .10135 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .08597 m
.06984 .08658 L
.12045 .08721 L
.17105 .08785 L
.22166 .08851 L
.27227 .08919 L
.32287 .08988 L
.37348 .0906 L
.42409 .09134 L
.4747 .0921 L
.5253 .09289 L
.57591 .0937 L
.62652 .09454 L
.67713 .09541 L
.72773 .09631 L
.77834 .09724 L
.82895 .09821 L
.87955 .09921 L
.93016 .10026 L
.98077 .10135 L
s
0 .4 1 r
.01923 .12887 m
.06984 .13043 L
.12045 .13205 L
.17105 .13373 L
.22166 .13549 L
.27227 .13731 L
.32287 .13923 L
.37348 .14123 L
.42409 .14332 L
.4747 .14552 L
.5253 .14784 L
.57591 .15027 L
.62652 .15285 L
.67713 .15557 L
.72773 .15845 L
.77834 .1615 L
.82895 .16475 L
.87955 .16822 L
.9187 .17105 L
.93016 .17188 L
.98077 .17567 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .12887 m
.06984 .13043 L
.12045 .13205 L
.17105 .13373 L
.22166 .13549 L
.27227 .13731 L
.32287 .13923 L
.37348 .14123 L
.42409 .14332 L
.4747 .14552 L
.5253 .14784 L
.57591 .15027 L
.62652 .15285 L
.67713 .15557 L
.72773 .15845 L
.77834 .1615 L
.82895 .16475 L
.87955 .16822 L
.9187 .17105 L
.93016 .17188 L
.98077 .17567 L
s
.2 0 1 r
.01923 .19512 m
.06984 .19895 L
.12045 .20303 L
.17105 .20739 L
.22166 .21205 L
.27227 .21706 L
.3157 .22166 L
.32287 .22244 L
.37348 .22822 L
.42409 .23447 L
.4747 .24126 L
.5253 .24869 L
.57591 .25686 L
.62652 .26588 L
.65935 .27227 L
.67713 .27588 L
.72773 .28698 L
.77834 .29952 L
.82895 .31384 L
.85758 .32287 L
.87955 .33026 L
.93016 .34935 L
.98077 .37206 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .19512 m
.06984 .19895 L
.12045 .20303 L
.17105 .20739 L
.22166 .21205 L
.27227 .21706 L
.3157 .22166 L
.32287 .22244 L
.37348 .22822 L
.42409 .23447 L
.4747 .24126 L
.5253 .24869 L
.57591 .25686 L
.62652 .26588 L
.65935 .27227 L
.67713 .27588 L
.72773 .28698 L
.77834 .29952 L
.82895 .31384 L
.85758 .32287 L
.87955 .33026 L
.93016 .34935 L
.98077 .37206 L
s
.8 0 1 r
.01923 .29819 m
.06984 .30765 L
.12045 .31809 L
.14198 .32287 L
.17105 .32968 L
.22166 .34263 L
.27227 .35723 L
.32184 .37348 L
.32287 .37384 L
.37348 .39289 L
.42409 .41508 L
.44246 .42409 L
.4747 .44129 L
.5253 .47287 L
.52794 .4747 L
.57591 .51178 L
.59104 .5253 L
.62652 .56135 L
.6391 .57591 L
.67664 .62652 L
.67713 .62726 L
.70658 .67713 L
.72773 .72059 L
.73087 .72773 L
.75088 .77834 L
.76756 .82895 L
.77834 .86693 L
.78163 .87955 L
.79362 .93016 L
.80391 .98077 L
.01923 .98077 L
F
0 g
.01923 .29819 m
.06984 .30765 L
.12045 .31809 L
.14198 .32287 L
.17105 .32968 L
.22166 .34263 L
.27227 .35723 L
.32184 .37348 L
.32287 .37384 L
.37348 .39289 L
.42409 .41508 L
.44246 .42409 L
.4747 .44129 L
.5253 .47287 L
.52794 .4747 L
.57591 .51178 L
.59104 .5253 L
.62652 .56135 L
.6391 .57591 L
.67664 .62652 L
.67713 .62726 L
.70658 .67713 L
.72773 .72059 L
.73087 .72773 L
.75088 .77834 L
.76756 .82895 L
.77834 .86693 L
.78163 .87955 L
.79362 .93016 L
.80391 .98077 L
s
1 0 .6 r
.01923 .45874 m
.0543 .4747 L
.06984 .48232 L
.12045 .50998 L
.14514 .5253 L
.17105 .54294 L
.21343 .57591 L
.22166 .58301 L
.26635 .62652 L
.27227 .633 L
.30833 .67713 L
.32287 .69755 L
.34228 .72773 L
.37019 .77834 L
.37348 .78498 L
.39344 .82895 L
.41304 .87955 L
.42409 .91214 L
.42974 .93016 L
.44408 .98077 L
.01923 .98077 L
F
0 g
.01923 .45874 m
.0543 .4747 L
.06984 .48232 L
.12045 .50998 L
.14514 .5253 L
.17105 .54294 L
.21343 .57591 L
.22166 .58301 L
.26635 .62652 L
.27227 .633 L
.30833 .67713 L
.32287 .69755 L
.34228 .72773 L
.37019 .77834 L
.37348 .78498 L
.39344 .82895 L
.41304 .87955 L
.42409 .91214 L
.42974 .93016 L
.44408 .98077 L
s
1 0 0 r
.01923 .7092 m
.03619 .72773 L
.06984 .76924 L
.07651 .77834 L
.10977 .82895 L
.12045 .84733 L
.13761 .87955 L
.16119 .93016 L
.17105 .95396 L
.18137 .98077 L
.01923 .98077 L
F
0 g
.01923 .7092 m
.03619 .72773 L
.06984 .76924 L
.07651 .77834 L
.10977 .82895 L
.12045 .84733 L
.13761 .87955 L
.16119 .93016 L
.17105 .95396 L
.18137 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{182, 183},
  ImageMargins->{{64, 0}, {0, 0}},
  ImageRegion->{{0, 0.989011}, {-0.043716, 1.03825}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002f0000]a000`40O003h00O]Woo002fOol00;Io
o`00]Woo002fOol00;Ioo`005Goo0P007Woo0P0017oo0P0017oo0P007Woo1@006goo1@000Woo0P00
17oo0P007Goo10001Goo000DOol01000Oomoo`0077oo00@007ooOol000Qoo`04001oogoo000OOol0
0`00Oomoo`0MOol00`00Oomoo`07Ool01000Oomoo`0077oo00<007ooOol01Woo000DOol01000Oomo
o`0077oo00@007ooOol000]oo`03001oogoo01eoo`03001oogoo01eoo`03001oogoo00Yoo`03001o
ogoo01]oo`03001oogoo00Eoo`0057oo00@007ooOol001aoo`04001oogoo0009Ool2000POol00`00
Oomoo`0MOol00`00Oomoo`08Ool2000OOol00`00Oomoo`04Ool001Aoo`04001oogoo000LOol01000
Oomoo`002Goo00<007ooOol07goo00<007ooOol07Goo00<007ooOol027oo00<007ooOol077oo00@0
07ooOol000Eoo`005Goo0P007Woo0P002Woo0`007Woo0P007Woo0P002Woo0`007Goo0P001Woo002f
Ool00;Ioo`00]Woo002fOol000ioo`8000=ooj0000=oo`003Goo00@007ooOol0009oo`04001oogoo
0006Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool01000Oomo
o`000goo000=Ool01000Oomoo`000Woo0P00W7oo0P000goo000=Ool01000Oomoo`000Woo00<007oo
Ool0W7oo00<007ooOol00Goo000=Ool01000Oomoo`000Woo00@007ooOomooiQl00=oo`03001oogoo
005oo`003Woo0P000goo00@007ooOomooe@004Al00=oo`03001oogoo005oo`004goo00@007ooOomo
ob`00003OT1nH7i0009n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP
00=n@005OV1n@7i0OT1nH003OT000giPOT1n@0100004O003Ool00`00Oomoo`01Ool001=oo`04001o
ogooOol<000086OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn10000XOT050002Ool00`00Oomoo`01Ool001=oo`0@001oogooOolGh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n2=0002Ool00`00Oomoo`01Ool001=oo`04001oogooOol25n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DK
h1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000a_P5n00
000L0002Ool00`00Oomoo`01Ool001=oo`80009oog@0000T5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0goo00<007ooOol0
0Goo000COol01000OomoogooM0?/9@000Woo00<007ooOol00Goo000COol0W000Oomoogoo0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0=o
o`03001oogoo005oo`004goo00@007ooOomooiP3k0=oo`03001oogoo005oo`004goo00@007ooOomo
ob`0001/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0goo00<007ooOol00Goo000C
Ool01000Oomoogoo;0?o@000;0?/0goo00<007ooOol00Goo000COol01000OomoogooK0?o;@000Woo
00<007ooOol00Goo000COol20002OonH0ol3Ool00`00Oomoo`01Ool001=oo`04001oogooOonH0ol3
Ool00`00Oomoo`01Ool001=oo`04001oogooOonH0ol3Ool00`00Oomoo`01Ool001=oo`04001oogoo
OonH0ol3Ool00`00Oomoo`01Ool001=oo`04001oogooOolD00240ol3Ool00`00Oomoo`01Ool001=o
o`0H001oogooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O8000I0?o0goo
00<007ooOol00Goo000COol01000Oomoogoo=06O6000C0?o0goo00<007ooOol00Goo000COol0D000
Oomoogoo0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il@000l0ol3Ool00`00Oomoo`01Ool0
01=oo`80009ooe`1WaP002@3o`=oo`03001oogoo005oo`004goo07P007ooOomoo`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il@000D0ol3Ool00`00Oomoo`01
Ool001=oo`04001oogooOon40Il;00090ol3Ool00`00Oomoo`01Ool001=oo`2C001oogooOol1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00X0009oo`03001oogoo005o
o`004goo00@007ooOomooiP1W`=oo`03001oogoo005oo`004goo09`007ooOomoo`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3Ool00`00
Oomoo`01Ool0009oo`8000Aoo`8000=oo`@0009oo`04001oogooOol4002D0Il3Ool00`00Oomoo`01
Ool00005Ool007ooOol00008Ool00`00Oomoo`03Ool02000Oomoogoo51lH7a@O61l80000S05o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3Ool00`00Oomoo`01Ool00005Ool007oo
Ool00009Ool00`00Oomoo`02Ool20002Ool251l01APO51lD7a@O61l00a@O00<H7a@O00003`00O06O
0Woo0P000goo00001Goo001oogoo00002Woo00D007ooOomoo`0000=oo`0L51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l80000M05o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3Ool00`00Oomoo`01Ool00005Ool0
07ooOol00008Ool01000Oomoo`000Woo00D007ooOomooaPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l8001/0Il3Ool00`00Oomo
o`01Ool0009oo`8000Yoo`8000=oo`0`001oogooOolD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
200006@1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`=oo`03001oogoo005oo`004goo00@007ooOomoo`8D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7`0000L005`1W`=oo`03001oogoo
005oo`004goo040007ooOomooa@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7`P0001D0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0goo00<007ooOol00Goo000COol01@00Oomoogoo61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l8001<
0Il3Ool00`00Oomoo`01Ool001=oo`80009oo`1<51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61l80000A05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3Ool00`00Oomoo`01Ool001=oo`04001oogooOol251l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O00001@00?P6O0goo00<007oo
Ool00Goo000COol0GP00Oomoogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO100003X1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`=oo`03001oogoo005oo`004goo00D007ooOomooaPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O
00001000=@6O0goo00<007ooOol00Goo000COol0I`00Oomoogoo51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O00L0
000^0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3Ool00`00Oomoo`01Ool001=oo`04001o
ogooOol251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O1000:P6O0goo00<007ooOol00Goo000C
Ool0LP00Oomoogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`@0000V0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`=oo`03001oogoo005oo`004goo00D007ooOomooaPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7`@00281W`=oo`03001oogoo005oo`004goo0P00
0Woo1000078D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l40000
7P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`=oo`03001oogoo005oo`004goo00P007ooOomoof@OH1mT7f0O1P0000DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l4000J0Il3Ool00`00Oomoo`01Ool001=oo`0>001oogoo
OomP7f@OH1mT7f0OI1mP7f@OH1mT7`@0001`51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61l400005P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0goo00<007ooOol00Goo000COol04P00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`@0
008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7`8001@1W`=oo`03001o
ogoo005oo`004goo01H007ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`@0
001^51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`<0000A0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`03Ool00`00Oomoo`01Ool001=oo`0J001oogooOomT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`@0000561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00`003P6O0goo00<007ooOol00Goo000COol07P00OomoogooH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`@0001/51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0P0000`1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il3
Ool00`00Oomoo`01Ool001=oo`0R001oogooOomT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l4000251l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O0`002@6O0goo00<007ooOol00Goo000COol20002Ool08V0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O100006TD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51l00`0000H1O`6O0Gl1W`5o0Il3Ool00`00Oomoo`01Ool001=oo`0Z
001oogooOomT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O100000DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`8000@1
W`=oo`03001oogoo005oo`004goo02h007ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`80001X
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`<000050ImoogooOol00003Ool001=oo`0`001oogoo
OomT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0`0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H
7a@O51l00P000Woo00<007ooOol00Goo000COol0<`00OomoogooH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`030000IQ@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`=oo`03001oogoo005oo`00
4goo03H007ooOomoof@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l2000251l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l00aPO51moo`02Ool00`00Oomoo`01Ool0009oo`8000Aoo`8000Eoo`<00003Ool0
07oo009oo`0dH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l30000HAPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO00=oo`03001oogoo005oo`0000Eoo`00Oomoo`0000]oo`04001oogoo0003Ool0
=f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O00<0008D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O
51lD7`=oo`03001oogoo005oo`0000Eoo`00Oomoo`0000Qoo`D00003Ool00000009oo`0jH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l20000G1@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l2
Ool20003Ool00005Ool007ooOol00008Ool01000Oomoo`000Woo040007ooOomoof@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`<000<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7`=oo`03001oogoo
005oo`0000Eoo`00Oomoo`0000Uoo`03001oo`00009oo`13001oogooOomP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00P0005LH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00goo00<007oo
Ool00Goo0002Ool2000;Ool20002Ool0A@00OomoogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0200000a@O61lD7`0251l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O0goo00<007ooOol00Goo000COol0
A`00OomoogooH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00P0005<H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO00=oo`03001oogoo005oo`004goo04T007ooOomoof@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7`02000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7`=oo`03001oogoo
005oo`004goo04/007ooOomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00P0004lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool001=oo`80009oo`19I1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l00P0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
0goo00<007ooOol00Goo000COol0W000OomoogooH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`=oo`03001oogoo005oo`004goo050007oo
Oomoo`00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0P0000DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00<H7a@OOol00Woo00<007ooOol00Goo000COol01@00OomoogooO1800P0004]T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l00P0004PD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l3Ool00`00Oomo
o`01Ool001=oo`04001oogooOol3O1820000C60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`00
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l011PO51lD7a@O0goo00<007ooOol00Goo000COol01000Oomoogoo0g`B09El4g`B
000006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO00=oo`03
001oogoo005oo`004goo00@007ooOomoo`Ml4P80001:H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H
7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00<H7a@OOol00Woo00<007ooOol00Goo000COol01P00OomoogooO19l4`=l4P04
O1=l4W`BO1820000Af@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l00P0004@D7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0goo
00<007ooOol00Goo000COol20002Ool;O1820000B60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l000<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O0goo00<007ooOol00Goo000COol01000Oomoogoo0g`B00El4g`BO19l4W`C00=l4P2=O1=l
4P00001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO00=oo`03001oogoo005oo`004goo
00@007ooOomoo`ml4P800015H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0080008D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7`=oo`03001oogoo
005oo`004goo00H007ooOomoog`BO1<3O1801G`CO19l4W`BO1<00g`B08]l4g`BO19l4P00H1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool001=oo`04001oogooOolBO1820000
AV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0461lD7a@O51l3Ool00`00Oomoo`01Ool001=oo`04001oogooOol3O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P25O1<006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0
0goo00<007ooOol00Goo000COol01000Oomoogoo5G`B04L006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`00008D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51mo
o`02Ool00`00Oomoo`01Ool001=oo`06001oogooOoml4W`C0g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O180Pg`C0000060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00goo00<007ooOol00Goo000COol20002
OolHO180A@00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0200000a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l011PO51lD7a@O0goo00<007ooOol00Goo000COol01000Oomoogoo0g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180QG`CO19l4W`BO1=l4P00H1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
00=oo`03001oogoo005oo`004goo00@007ooOomooaYl4P19001P7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@OOol00Woo00<007oo
Ool00Goo000COol01P00OomoogooO19l4`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00Il4g`BO19l4W`CO1820000Nf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool001=oo`04001oogooOolMO180
A@00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1l0000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
11PO51lD7a@O0goo00<007ooOol00Goo0002Ool20004Ool20003Ool30003Ool01000Oomoogoo0g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B07el4g`BO18006@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
00=oo`03001oogoo005oo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0002Ool01000Oomoogoo7g`B
0P0004=P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1l0000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
0aPO51moo`02Ool00`00Oomoo`01Ool00005Ool007ooOol00008Ool01000Oomoo`000Woo0P000Woo
00=l4W`CO1800W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
07]l4g`BO19l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61l00Woo0P000goo00001Goo001oogoo000027oo0`000goo00@007ooOomoob9l4P13001P
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0O00000a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O0goo00<007oo
Ool00Goo00001Goo001oogoo00002Goo00<007ooOol00Woo00@007ooOomoo`=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180M@00H1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomo
o`01Ool0009oo`8000Yoo`<0009oo`04001oogooOolTO180@`00H1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0000<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l3Ool00`00Oomoo`01Ool001=oo`06001oogooOoml
4W`C0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P1c001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61l00goo00<007ooOol00Goo000COol01000Oomoogoo9W`B04<0060OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0461lD7a@O51l3Ool00`00Oomoo`01Ool001=oo`04001oogooOol3O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B07El4g`BO19l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0
0goo00<007ooOol00Goo000COol01000Oomoogoo:7`B04<0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0361lD7goo009oo`03001oogoo005oo`004goo0P000Woo00=l4W`CO1800W`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P1cO1=l4W`BO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00goo
00<007ooOol00Goo000COol01000Oomoogoo:G`B04@006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO0a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l3Ool00`00Oomoo`01Ool001=oo`04001oogooOol3O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
009l4P1^001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`=oo`03001oogoo005o
o`004goo00@007ooOomoob]l4P11001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0000251l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD
7goo009oo`03001oogoo005oo`004goo00H007ooOomoog`BO1<3O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C009l
4P1/001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0goo00<007ooOol00Goo000COol0
1000Oomoogoo;7`B0440060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O0goo00<007ooOol0
0Goo000COol01000Oomoogoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180KG`CO180060OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO00=oo`03001oogoo005oo`004goo00@007ooOomoobil4P11001P
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@O000H7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l3Ool00`00Oomoo`01Ool001=oo`80009oo`03O19l
4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B06]l4g`B001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO00=oo`03001oogoo005oo`004goo00@007ooOomooc1l4P11001P7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H
7a@O51lD7`=oo`03001oogoo005oo`004goo00@007ooOomoo`=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
06el4g`BO19l4W`CO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool001=o
o`05001oogooOol0000`O180?`00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l3Ool00`00Oomoo`01
Ool001=oo`06001oogooOoml00000g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180Jg`CO19l4W`BO1<006@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61l00goo00<007ooOol00Goo000COol01P00OomoogooO000031l4P0o
001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`0000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l011PO51lD7a@O0goo00<007ooOol00Goo000COol01000Oomoogoo0W`000<0
07`CO1800W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180JG`CO19l4W`B001P7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7`03Ool00`00Oomoo`01Ool001=oo`04001oogooOol3O0000`00O19l4P0^O180?`00H1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00<H7a@OOol00Woo00<007ooOol00Goo000COol20002Ool4O0000`00O1=l4P02O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P1WO1=l4W`B001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00goo00<007ooOol00Goo000C
Ool01000Oomoogoo1G`000<007`BO180;G`B040006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7`<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l3Ool00`00Oomoo`01Ool0
01=oo`04001oogooOol5O0000`00O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P1UO1=l4P00H1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0
01@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool001=oo`04001oogooOol6O0000`00O19l4P0]O180
?P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@O000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00<H7a@OOol00Woo00<007ooOol00Goo000COol01000Oomoogoo1g`000<007`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O180Hg`C001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01
Ool0009oo`8000Aoo`8000Aoo`8000=oo`04001oogooOol8O0000`00O19l4P0/O180?P00I1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O0goo00<007ooOol00Goo00001Goo001oogoo000027oo00@007ooOol0009oo`04001oogooOol9
O0000`00O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P1Q001P7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00goo00<007oo
Ool00Goo00001Goo001oogoo000027oo00@007ooOol0009oo`80009oo`Yl0003001l4W`B02]l4P0o
001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
000D7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`06
61lD7a@O51lH7a@O0Woo0P000goo00001Goo001oogoo00002Goo0P000goo00@007ooOomoo`Yl0004
001l4W`BO1<3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C009l4P1P001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0goo00<007ooOol00Goo
00001Goo001oogoo000027oo00@007ooOol0009oo`04001oogooOol;O0000`00O19l4P0[O180?@00
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`00
008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l3Ool00`00Oomoo`01Ool0009oo`8000Yoo`8000=oo`04001oogooOol<O0001000O19l
4W`C0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P1UO1=l4W`BO19l4g`B001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool001=oo`04001o
ogooOol<O0000`00O19l4P0[O180?@00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l001PO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O0goo00<007ooOol00Goo000COol01000Oomoogoo
3G`000D007`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O180Hg`CO19l4W`BO1<006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool0
01=oo`04001oogooOol=O0000`00O19l4P0[O180?P00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7a@O0goo00<007ooOol00Goo000COol01000
Oomoogoo3W`000<007`CO1800W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180G@00H1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomo
o`01Ool001=oo`80009oo`ml0003001l4W`B02Ul4P0l001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`000a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l3Ool00`00Oomoo`01Ool001=oo`04
001oogooOol?O0000`00O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C009l4P1L001T7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`=oo`03001oogoo
005oo`004goo00@007ooOomooa1l0003001l4W`B02Ul4P0m001P7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7`=oo`03001oogoo005oo`004goo
00@007ooOomooa1l0004001l4W`BO1<3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B065l4g`BO19l4W`CO180060OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01
Ool001=oo`04001oogooOolAO0000`00O19l4P0YO180?P00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51moo`02Ool00`00Oomoo`01Ool001=oo`04
001oogooOolAO0001@00O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P1OO1=l4W`BO180060OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool0
01=oo`04001oogooOolBO0000`00O19l4P0YO180?000H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0461lD7a@O51l3Ool00`00Oomoo`01Ool001=oo`04001oogoo
OolBO0000`00O1=l4P02O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C009l4P1J001T7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0goo00<007ooOol00Goo000COol2
0002OolCO0000`00O19l4P0XO180?@00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l001PO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0361lD7goo009oo`03001oogoo005oo`004goo00@007ooOomooa=l0003
001l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O180Gg`CO19l4W`BO1=l4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00goo00<007ooOol00Goo000COol01000Oomoogoo57`0
00<007`BO180:7`B03h006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0O000D7aPO0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O0goo00<007ooOol00Goo000COol01000Oomoogoo57`000@007`BO19l4`=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
GG`CO19l4W`BO1<006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7`03Ool00`00Oomoo`01Ool001=oo`04001oogooOolEO0000`00O19l4P0XO180>`00H1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00000a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@OOol00Woo00<0
07ooOol00Goo000COol01000Oomoogoo5G`000D007`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180Fg`CO19l4P00I1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO00=oo`03001o
ogoo005oo`004goo00@007ooOomooaIl0003001l4W`B02Ql4P0l001T7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO0a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O0goo00<007ooOol00Goo000COol20002OolFO000
0`00O1=l4P02O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B05el4g`BO19l4W`CO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61l00goo00<007ooOol00Goo000COol01000Oomoogoo5g`000<0
07`BO1809g`B03/006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7`00008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0361lD7goo009oo`03001oogoo005oo`004goo00@007ooOomooaMl0003001l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
Fg`CO19l4W`BO1<006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO00=oo`03001oogoo005oo`004goo00@007ooOomooaQl0003001l4W`B02Ml4P0k001P7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l3Ool00`00Oomoo`01Ool001=o
o`04001oogooOolHO0001000O19l4W`C0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P1IO1=l4W`B001T7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`03Ool00`00Oomoo`01Ool001=oo`04001oogoo
OolHO0000`00O19l4P0WO180?@00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0O000D7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH
7a@O51lD7aPO51l3Ool00`00Oomoo`01Ool000eoo`D00003Ool007oo009ooaUl0005001l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B05Ml4g`B001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61l00goo00<007ooOol00Goo000?Ool01@00Oomoogoo00000goo6G`000<007`BO1809g`B03X0
06@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l000<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`=oo`03001oogoo005o
o`003goo00@007ooOomoo`80009ooaUl0003001l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180FG`CO19l4W`B001P7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00Woo0P000goo000?Ool01@00
Oomoogoo0000WWoo00<007ooOol00Goo000?Ool01@00Oomoogoo00000Woo00<007ooOol08goo00<0
07ooOol097oo00<007ooOol08goo00<007ooOol08goo00@007ooOol000=oo`003Woo0P000gooX000
0goo002fOol00;Ioo`00]Woo002fOol00;Ioo`00]Woo002fOol00001\
\>"],
  ImageRangeCache->{{{0, 179}, {190, -6.9375}} -> {-0.290141, -0.208954, \
0.0130256, 0.00648006}}]
}, Open  ]],

Cell[TextData[{
  "Generally, we observe that ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " increases if ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " increases. For small values of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", there exists a nearly linear relation between ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell["\<\
The third example discussed above is represented in canonical \
variables by\
\>", "Text",
  Evaluatable->False,
  CellTags->"canonical variables"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cex3 = 
      CanonicalRepresentation[example3, u, x, \n
        \t\t{w \[Rule] u\/x, t \[Rule] \(-\(1\/x\)\)}, w, t]; cex3 // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\@w + w\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution of this equation for ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " follows from"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(sex3 = DSolve[cex3, w, t]\)], "Input"],

Cell[BoxData[
    \({{w \[Rule] \((1\/4\ \((#1\^2 - 2\ #1\ C[1] + C[1]\^2)\)&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Inverting the transformation and solving for ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " gives us the explicit solution"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solex3 = 
      u\/x == \((w[t] /. sex3)\)\[LeftDoubleBracket]1\[RightDoubleBracket] /. 
        t \[Rule] \(-\(1\/x\)\)\)], "Input"],

Cell[BoxData[
    \(u\/x == 1\/4\ \((1\/x\^2 + \(2\ C[1]\)\/x + C[1]\^2)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol3 = Solve[solex3, u]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] \(-\(\(\(-1\) - 2\ x\ C[1] - x\^2\ C[1]\^2\)\/\(4\ x\)\)\)}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "So far, we have discussed some examples to show that canonical variables \
can be used to simplify the integration process of first-order equations. The \
method of canonical variables is useful not only in the integration process \
of first-order ordinary differential equations but also in the integration of \
higher-order ordinary differential equations. We will come back to this \
general procedure in S",
  ButtonBox["ection 4.4.2.2",
    ButtonData:>{"symmet3.nb", "Method of canonical variables"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "canonical variables", "first-order equations", 
    "method of canonical variables"}],

Cell["\<\
Before proceeding with second-order equations, we first discuss \
another approach to integrate first-order ordinary differential equations. \
This method uses the fact that a first-order equation can be integrated if an \
integrating factor is known. The procedure introduced by Lie in 1891 is very \
useful if one knows the point symmetries of the equation in an infinitesimal \
representation.\
\>", "Text",
  Evaluatable->False,
  CellTags->"integrating factor"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.4.1.2 Integrating Factor", "Subsubsection",
  CellTags->"Integrating factor"],

Cell[TextData[{
  "The common belief in literature is that the method of an integrating \
factor is only useful in connection with a first-order ordinary differential \
equation. For the moment, we will take this point of view. However, in S",
  ButtonBox["ection 4.4.2.2,",
    ButtonData:>{"symmet3.nb", "Method of integrating factor"},
    ButtonStyle->"Hyperlink"],
  " we will generalize the method of an integrating factor to higher-order \
equations. In S",
  ButtonBox["ection 4.2.3",
    ButtonData:>{"symmet1.nb", "Group invariants"},
    ButtonStyle->"Hyperlink"],
  ", we demonstrated by several examples that a curve is invariant under a \
symmetry transformation if the tangent vector applied to the curve vanishes. \
Let us assume that the curves discussed are integral curves or solutions of a \
first-order differential equation. For example, the ODE is"
}], "Text",
  CellTags->{
  "method of an integrating factor", 
    "first-order ordinary differential equation", "tangent vector", 
    "integral curves", "solutions"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ode1 = \[PartialD]\_x u[x] == f[x, u[x]]; ode1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-f\) + u\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is given by the ratio of two functions ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`X\)]]
}], "Text"],

Cell[BoxData[
    \(\(f[x, u[x]] = U[x, u[x]]\/X[x, u[x]]; \)\)], "Input"],

Cell[TextData[{
  "If ",
  StyleBox["F", "InlineFormula",
    FontSlant->"Italic"],
  StyleBox["[", "InlineFormula"],
  StyleBox["x", "InlineFormula",
    FontSlant->"Italic"],
  StyleBox[",", "InlineFormula"],
  StyleBox["u", "InlineFormula",
    FontSlant->"Italic"],
  StyleBox["] = const", "InlineFormula"],
  ". are integral curves, we get"
}], "Text",
  CellTags->"integral curves"],

Cell[CellGroupData[{

Cell[BoxData[
    \(invar1 = Dt[F[x, u]] == 0; invar1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(Dt[u]\ F\_u + Dt[x]\ F\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Let us further assume that the differential equation is invariant under an \
infinitesimal transformation represented by the ",
  ButtonBox["vector field",
    ButtonData:>{"symmet1.nb", "TangentVector["},
    ButtonStyle->"Hyperlink"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ". Then, we find"
}], "Text",
  CellTags->"infinitesimal transformation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(invar2 = TangentVector[F[x, u], {u}, {x}] == H; invar2 // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-H\) + F\_x\ \[Xi]\_1[x, u] + F\_u\ \[Phi]\_1[x, u] == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We always can rescale ",
  StyleBox["invar2",
    FontSlant->"Italic"],
  " in such a way that the right-hand side equals 1."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(invar2 = invar2 /. H \[Rule] 1; invar2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-1\) + F\_x\ \[Xi]\_1[x, u] + F\_u\ \[Phi]\_1[x, u] == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, we derived two equations for the derivatives of the invariant curve \
which have to be satisfied under the given infinitesimal transformation. We \
can solve these two equations for the derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " by"
}], "Text",
  CellTags->{"invariant curve", "infinitesimal transformation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      Solve[{invar1, invar2}, \n
          \t\t{\[PartialD]\_x F[x, u], \[PartialD]\_u F[x, u]}] /. {
          Dt[u] \[Rule] U[x, u], \n\t\t\tDt[x] \[Rule] X[x, u]}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["F", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, u\), "]"}], "\[Rule]", 
            \(U[x, u]\/\(U[x, u]\ \[Xi]\_1[x, u] - 
                  X[x, u]\ \[Phi]\_1[x, u]\)\)}], ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox["F", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, u\), "]"}], "\[Rule]", 
            \(-\(X[x, u]\/\(U[x, u]\ \[Xi]\_1[x, u] - 
                    X[x, u]\ \[Phi]\_1[x, u]\)\)\)}]}], "}"}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "We understand from this result that the partial derivatives of the \
integral curve are known as functions of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". On the other hand, the result shows that the total differential of the \
integral curve ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is known. The following expression represents the total differential \
Dt[F]:"
}], "Text",
  CellTags->{"integral curve", "total differential"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(invar3 = Simplify[\(invar1 /. sol\) /. 0 \[Rule] Dt[F]]\)], "Input"],

Cell[BoxData[
    \({\(Dt[x]\ U[x, u] - Dt[u]\ X[x, u]\)\/\(U[x, u]\ \[Xi]\_1[x, u] - 
            X[x, u]\ \[Phi]\_1[x, u]\) == Dt[F]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Recall the definition of an integrating factor ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](x, u)\)]],
  " which is, by definition, a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " that makes ",
  Cell[BoxData[
      \(TraditionalForm\`Dt[x] Y - Dt[u] X\)]],
  " the differential of the integral curve ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ". This information allows us to extract from our result ",
  StyleBox["invar3",
    FontSlant->"Italic"],
  " the integrating factor"
}], "Text",
  CellTags->{"integrating factor", "integral curve"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Mu] = 
      1\/Denominator[invar3\[LeftDoubleBracket]1, 1\[RightDoubleBracket]]\)], 
  "Input"],

Cell[BoxData[
    \(1\/\(U[x, u]\ \[Xi]\_1[x, u] - X[x, u]\ \[Phi]\_1[x, u]\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This result was obtained by ",
  ButtonBox["Lie in 1874",
    ButtonData:>{"Literat.nb", "Lie-1874"},
    ButtonStyle->"Hyperlink"],
  ". For the derivation of integrating factors, it is important to know the \
structure of the equation and the symmetries."
}], "Text",
  CellTags->"integrating factor"],

Cell["\<\
In 1874, Lie proved that a first-order ordinary differential \
equation can be solved by a quadrature if the symmetries of the equation are \
known. He collected his observations in the following theorem.\
\>", "Text",
  CellTags->"quadrature"],

Cell["Theorem: Integrating factor", "Theorem",
  CellTags->"Theorem: Integrating Factor"],

Cell["The first-order ordinary differential equation", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(U(x, u)\), " ", 
            StyleBox["dx",
              FontSlant->"Italic"]}], " ", "-", " ", 
          RowBox[{\(X(x, u)\), " ", 
            StyleBox["du",
              FontSlant->"Italic"]}]}], "=", "0"}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "possesses a one-parameter group allowing the vector field ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(v\&\[RightVector]\),
              "TraditionalForm"], " ", "=", " ", 
            RowBox[{
              RowBox[{"\[Xi]", " ", 
                FormBox[\(\[PartialD]\_x\),
                  "TraditionalForm"]}], "+", " ", 
              FormBox[\(\[Phi] \[PartialD]\_u\),
                "TraditionalForm"]}]}], "  "}], TraditionalForm]]],
  "if and only if the function"
}], "Text",
  CellTags->"one parameter group"],

Cell[BoxData[
    \(TraditionalForm\`\[Mu]\  = \ 1\/\(\[Xi]  U - \[Phi]  X\)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "is an integrating factor with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              RowBox[{
                StyleBox["\[Xi]",
                  "InlineFormula"], 
                StyleBox["U",
                  FontSlant->"Italic"]}]], 
            StyleBox["-",
              "InlineFormula"], 
            StyleBox[
              RowBox[{
                StyleBox["\[Phi]",
                  "InlineFormula"], 
                StyleBox["X",
                  FontSlant->"Italic"]}]]}], 
          StyleBox["\[NotEqual]",
            "InlineFormula"], 
          StyleBox["0",
            "InlineFormula"]}], TraditionalForm]]],
  ". If this is the case, the original equation is solved by a quadrature:"
}], "Text",
  CellTags->"integrating factor"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Integral]", 
          FractionBox[
            RowBox[{
              RowBox[{"U", " ", 
                StyleBox["dx",
                  FontSlant->"Italic"]}], "-", 
              RowBox[{"X", " ", 
                StyleBox["du",
                  FontSlant->"Italic"]}]}], \(\[Xi]\ U - \[Phi]\ X\)]}], " ", 
        "=", " ", \(const . \[ThickSpace]\[EmptyCircle]\)}], 
      TraditionalForm]], "NumberedEquation"],

Cell["\<\
Relation (4.37) can be simplified if we introduce the following \
determinants:\
\>", "Text",
  CellTags->"determinant"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[
          RowBox[{
            StyleBox["d",
              FontSlant->"Italic"], "\[CapitalDelta]"}]], " ", "=", " ", 
        RowBox[{"det", 
          FormBox[
            RowBox[{"(", GridBox[{
                  {
                    StyleBox["dx",
                      FontSlant->"Italic"], 
                    StyleBox["du",
                      FontSlant->"Italic"]},
                  {"X", "U"}
                  }], ")"}],
            "TraditionalForm"]}]}], TraditionalForm]], "NumberedEquation"],

Cell["and", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[CapitalDelta]", " ", "=", " ", 
        RowBox[{
          RowBox[{"det", " ", 
            RowBox[{"(", GridBox[{
                  {"\[Xi]", "\[Phi]"},
                  {"X", "U"}
                  }], ")"}]}], " ", "=", " ", \(1\/\(\[Mu] . \)\)}]}], 
      TraditionalForm]], "NumberedEquation"],

Cell["Then, equation (4.37) reduces to the simple relation", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Integral]", " ", 
          FormBox[
            RowBox[{"(", 
              FormBox[
                FractionBox[
                  StyleBox[
                    RowBox[{
                      StyleBox["d",
                        FontSlant->"Italic"], "\[CapitalDelta]"}]], 
                  "\[CapitalDelta]"],
                "TraditionalForm"], ")"}],
            "TraditionalForm"]}], " ", "=", " ", \(const . \)}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[
"Equation (4.40) combines all information necessary for a solution in a \
nutshell. All we need to know are the infinitesimals and the left-hand side \
of equation (4.35). Integration over the manifold provides us with the \
solution. A few examples will demonstrate the application of Lie\
\[CloseCurlyQuote]s theorem."], "Text",
  CellTags->{"infinitesimals", "manifold"}],

Cell["Example 1", "Example"],

Cell["\<\
As an example of these considerations, let us examine the \
first-order ODE\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ode2 = \[PartialD]\_x u[x] == 1 + Tan[x - u]\/x; 
    ode2 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(u\_x == 1 - Tan[u - x]\/x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The functions ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X[x, u]\),
          "InlineFormula"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`U[x, u]\)], "InlineFormula"],
  " are found by extracting the coefficients of the differentials. First, we \
extract this part from the ODE free of any differential:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ode2h = ode2\[LeftDoubleBracket]2\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \(1 - Tan[u - x]\/x\)], "Output"]
}, Open  ]],

Cell["Then, we generate a common denominator,", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ode2h = Together[ode2h]\)], "Input"],

Cell[BoxData[
    \(\(x - Tan[u - x]\)\/x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "and determine ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X[x, u]\),
          "InlineFormula"], TraditionalForm]]],
  " by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(X[x, u] = Denominator[ode2h]\)], "Input"],

Cell[BoxData[
    \(x\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[\(U[x, u]\),
          "InlineFormula"], TraditionalForm]]],
  " is then given by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(U[x, u] = Numerator[ode2h]\)], "Input"],

Cell[BoxData[
    \(x - Tan[u - x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals of the first-order equation ",
  StyleBox["ode2",
    FontSlant->"Italic"],
  " are"
}], "Text",
  CellTags->"infinitesimals"],

Cell[BoxData[
    \(\(\[Xi]\_1[x, u] = 0; \)\)], "Input"],

Cell["and", "Text"],

Cell[BoxData[
    \(\(\[Phi]\_1[x, u] = 1\/\(x\ Cos[x - u]\); \)\)], "Input"],

Cell[TextData[
"Knowing these relations, we use the definition of \[Mu] to get the explicit \
representation of the integrating factor"], "Text",
  CellTags->"integrating factor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Mu]\)], "Input"],

Cell[BoxData[
    \(\(-Cos[u - x]\)\)], "Output"]
}, Open  ]],

Cell["The related total differential of the integral curve reads", "Text",
  CellTags->"total differential"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[invar3]\)], "Input"],

Cell[BoxData[
    \({\(-Cos[u - x]\)\ \((\(-x\)\ Dt[u] + Dt[x]\ \((x - Tan[u - x])\))\) == 
        Dt[F]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This equation has to be integrated on the right-hand side with respect to \
",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", and on the left-hand side with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The result is"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ip = 
      F == \[Integral]Coefficient[\n\t\t\t\t
                Expand[invar3\[LeftDoubleBracket]1, 1\[RightDoubleBracket]], 
                Dt[u]] \[DifferentialD]u + \n\t\t\t
          \[Integral]Coefficient[
                Expand[invar3\[LeftDoubleBracket]1, 1\[RightDoubleBracket]], 
                Dt[x]] \[DifferentialD]x\)], "Input"],

Cell[BoxData[
    \(F == 2\ x\ Sin[u - x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "defining the solution of ",
  StyleBox["ode2",
    FontSlant->"Italic"],
  " in an implicit form. To see how this solution behaves in the variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we graphically represent this solution for three values of the constant \
",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ". The use of the function ",
  StyleBox["ImplicitPlot[]", "MmaText"],
  " creates a contour plot of the implicit function in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane:"
}], "Text",
  CellTags->"ImplicitPlot[]"],

Cell[BoxData[
    \(<< "\<Graphics`ImplicitPlot`\>"\)], "Input",
  CellTags->"Graphics`ImplicitPlot`"],

Cell[CellGroupData[{

Cell[BoxData[
    \(iph\  = Table[ip\  /. \ F \[Rule] \ i, {i,  .1, 2,  .9}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          StyleBox["0.1`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1], "==", \(2\ x\ Sin[u - x]\)}], ",", 
        \(1.` == 2\ x\ Sin[u - x]\), ",", 
        \(1.90000000000000017` == 2\ x\ Sin[u - x]\)}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImplicitPlot[iph, {x, \(-10\), 10}, {u, 0, 20}, \n\t
      AxesLabel \[Rule] {"\<x\>", "\<u\>"}, PlotPoints \[Rule] 100, \n\t
      PlotStyle 
        \[Rule] {RGBColor[1.000, 0.000, 0.000], \n\t\t\t
          RGBColor[0.000, 0.000, 1.000], \n\t\t\t
          RGBColor[0.000, 0.251, 0.000]}]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.047619 0.0238095 0.047619 [
[.02381 .01131 -9 -9 ]
[.02381 .01131 9 0 ]
[.2619 .01131 -6 -9 ]
[.2619 .01131 6 0 ]
[.7381 .01131 -3 -9 ]
[.7381 .01131 3 0 ]
[.97619 .01131 -6 -9 ]
[.97619 .01131 6 0 ]
[1.025 .02381 0 -9.5 ]
[1.025 .02381 12 9.5 ]
[.4875 .2619 -6 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .5 -12 -4.5 ]
[.4875 .5 0 4.5 ]
[.4875 .7381 -12 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -12 -4.5 ]
[.4875 .97619 0 4.5 ]
[.5 1.025 -6 0 ]
[.5 1.025 6 19 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .02381 m
.02381 .03006 L
s
[(-10)] .02381 .01131 0 1 Mshowa
.2619 .02381 m
.2619 .03006 L
s
[(-5)] .2619 .01131 0 1 Mshowa
.7381 .02381 m
.7381 .03006 L
s
[(5)] .7381 .01131 0 1 Mshowa
.97619 .02381 m
.97619 .03006 L
s
[(10)] .97619 .01131 0 1 Mshowa
.125 Mabswid
.07143 .02381 m
.07143 .02756 L
s
.11905 .02381 m
.11905 .02756 L
s
.16667 .02381 m
.16667 .02756 L
s
.21429 .02381 m
.21429 .02756 L
s
.30952 .02381 m
.30952 .02756 L
s
.35714 .02381 m
.35714 .02756 L
s
.40476 .02381 m
.40476 .02756 L
s
.45238 .02381 m
.45238 .02756 L
s
.54762 .02381 m
.54762 .02756 L
s
.59524 .02381 m
.59524 .02756 L
s
.64286 .02381 m
.64286 .02756 L
s
.69048 .02381 m
.69048 .02756 L
s
.78571 .02381 m
.78571 .02756 L
s
.83333 .02381 m
.83333 .02756 L
s
.88095 .02381 m
.88095 .02756 L
s
.92857 .02381 m
.92857 .02756 L
s
.25 Mabswid
0 .02381 m
1 .02381 L
s
gsave
1.025 .02381 -61 -13.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.5 .2619 m
.50625 .2619 L
s
[(5)] .4875 .2619 1 0 Mshowa
.5 .5 m
.50625 .5 L
s
[(10)] .4875 .5 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(15)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(20)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
gsave
.5 1.025 -67 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27 translate 1 -1 scale
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
71.000000 17.437500 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .44498 m
.02594 .44709 L
.03343 .45459 L
.03554 .45671 L
.04305 .46421 L
.04517 .46633 L
.05267 .47382 L
.05479 .47595 L
.06229 .48344 L
.06442 .48557 L
.07191 .49305 L
.07405 .49519 L
.08153 .50267 L
.08367 .50481 L
.09115 .51228 L
.0933 .51443 L
.10077 .52189 L
.10292 .52405 L
.11039 .53151 L
.11255 .53367 L
.12001 .54112 L
.12218 .54329 L
.12963 .55073 L
.13181 .55291 L
.13925 .56034 L
.14143 .56253 L
.14887 .56995 L
.15106 .57215 L
.15849 .57957 L
.16069 .58177 L
.16811 .58918 L
.17032 .59139 L
.17773 .59879 L
.17995 .60101 L
.18735 .6084 L
.18958 .61063 L
.19697 .618 L
.19921 .62025 L
.20659 .62761 L
.20885 .62987 L
.21621 .63722 L
.21848 .63949 L
.22583 .64682 L
.22811 .64911 L
.23545 .65643 L
.23775 .65873 L
.24507 .66603 L
.24739 .66835 L
.25469 .67564 L
.25702 .67797 L
Mistroke
.26431 .68524 L
.26666 .68759 L
.27393 .69484 L
.2763 .69721 L
.28355 .70443 L
.28594 .70683 L
.29317 .71403 L
.29559 .71645 L
.30279 .72362 L
.30523 .72607 L
.31241 .73321 L
.31488 .73569 L
.32203 .7428 L
.32454 .74531 L
.33165 .75238 L
.33419 .75493 L
.34127 .76196 L
.34385 .76455 L
.35089 .77154 L
.35352 .77417 L
.36051 .78111 L
.36319 .78379 L
.37013 .79066 L
.37287 .79341 L
.37975 .80022 L
.38256 .80303 L
.38937 .80975 L
.39226 .81265 L
.39899 .81928 L
.40197 .82227 L
.40861 .82878 L
.41171 .83189 L
.41823 .83825 L
.42146 .84151 L
.42785 .84769 L
.43124 .85113 L
.43747 .85706 L
.44106 .86075 L
.44709 .86635 L
.45089 .87037 L
.45671 .8755 L
.46061 .87999 L
.46633 .88437 L
.47232 .88961 L
.47595 .89264 L
.48557 .89908 L
.49519 .89195 L
.49577 .88961 L
.49682 .87999 L
.49726 .87037 L
Mistroke
.4975 .86075 L
.4976 .85113 L
.49761 .84151 L
.49751 .83189 L
.49727 .82227 L
.49682 .81265 L
.49594 .80303 L
.49544 .79341 L
.49519 .79165 L
.49311 .78379 L
.49043 .77417 L
.48557 .76527 L
.48492 .76455 L
.47797 .75493 L
.47595 .75248 L
.46842 .74531 L
.46633 .74151 L
.46048 .73569 L
.45671 .73114 L
.45166 .72607 L
.44709 .72104 L
.44252 .71645 L
.43747 .71109 L
.43323 .70683 L
.42785 .70123 L
.42385 .69721 L
.41823 .69142 L
.41441 .68759 L
.40861 .68166 L
.40493 .67797 L
.39899 .67192 L
.39543 .66835 L
.38937 .6622 L
.38591 .65873 L
.37975 .6525 L
.37637 .64911 L
.37013 .64281 L
.36681 .63949 L
.36051 .63313 L
.35725 .62987 L
.35089 .62346 L
.34769 .62025 L
.34127 .61379 L
.33811 .61063 L
.33165 .60413 L
.32853 .60101 L
.32203 .59447 L
.31895 .59139 L
.31241 .58482 L
.30936 .58177 L
Mistroke
.30279 .57517 L
.29977 .57215 L
.29317 .56553 L
.29018 .56253 L
.28355 .55588 L
.28058 .55291 L
.27393 .54624 L
.27098 .54329 L
.26431 .5366 L
.26138 .53367 L
.25469 .52696 L
.25178 .52405 L
.24507 .51732 L
.24218 .51443 L
.23545 .50769 L
.23257 .50481 L
.22583 .49805 L
.22297 .49519 L
.21621 .48842 L
.21336 .48557 L
.20659 .47878 L
.20376 .47595 L
.19697 .46915 L
.19415 .46633 L
.18735 .45952 L
.18454 .45671 L
.17773 .44989 L
.17493 .44709 L
.16811 .44026 L
.16532 .43747 L
.15849 .43063 L
.15571 .42785 L
.14887 .421 L
.1461 .41823 L
.13925 .41137 L
.13649 .40861 L
.12963 .40174 L
.12688 .39899 L
.12001 .39212 L
.11726 .38937 L
.11039 .38249 L
.10765 .37975 L
.10077 .37286 L
.09804 .37013 L
.09115 .36323 L
.08842 .36051 L
.08153 .35361 L
.07881 .35089 L
.07191 .34398 L
.0692 .34127 L
Mistroke
.06229 .33436 L
.05958 .33165 L
.05267 .32473 L
.04997 .32203 L
.04305 .3151 L
.04035 .31241 L
.03343 .30548 L
.03075 .30279 L
.02381 .29585 L
Mfstroke
.97619 .94856 m
.97495 .94733 L
.96657 .93894 L
.96535 .93771 L
.95695 .92931 L
.95573 .92809 L
.94733 .91969 L
.94612 .91847 L
.93771 .91006 L
.9365 .90885 L
.92809 .90043 L
.92689 .89923 L
.91847 .89081 L
.91728 .88961 L
.90885 .88118 L
.90766 .87999 L
.89923 .87155 L
.89805 .87037 L
.88961 .86193 L
.88844 .86075 L
.87999 .8523 L
.87882 .85113 L
.87037 .84267 L
.86921 .84151 L
.86075 .83304 L
.8596 .83189 L
.85113 .82342 L
.84999 .82227 L
.84151 .81379 L
.84038 .81265 L
.83189 .80416 L
.83077 .80303 L
.82227 .79453 L
.82116 .79341 L
.81265 .7849 L
.81155 .78379 L
.80303 .77526 L
.80194 .77417 L
.79341 .76563 L
.79233 .76455 L
.78379 .756 L
.78273 .75493 L
.77417 .74636 L
.77312 .74531 L
.76455 .73673 L
.76352 .73569 L
.75493 .72709 L
.75391 .72607 L
.74531 .71746 L
.74431 .71645 L
Mistroke
.73569 .70782 L
.73471 .70683 L
.72607 .69818 L
.72511 .69721 L
.71645 .68853 L
.71551 .68759 L
.70683 .67889 L
.70592 .67797 L
.69721 .66924 L
.69632 .66835 L
.68759 .65959 L
.68673 .65873 L
.67797 .64994 L
.67715 .64911 L
.66835 .64028 L
.66756 .63949 L
.65873 .63062 L
.65798 .62987 L
.64911 .62096 L
.64841 .62025 L
.63949 .61129 L
.63884 .61063 L
.62987 .60161 L
.62929 .60101 L
.62025 .59192 L
.61974 .59139 L
.61063 .58221 L
.6102 .58177 L
.60101 .5725 L
.60068 .57215 L
.59139 .56276 L
.59117 .56253 L
.58177 .55299 L
.58169 .55291 L
.57225 .54329 L
.57215 .54319 L
.56287 .53367 L
.56253 .53333 L
.55358 .52405 L
.55291 .52338 L
.54444 .51443 L
.54329 .51328 L
.53558 .50481 L
.53367 .50291 L
.52743 .49519 L
.52405 .49194 L
.51894 .48557 L
.51443 .47915 L
.51247 .47595 L
.50803 .46633 L
Mistroke
.50564 .45671 L
.50481 .45278 L
.50409 .44709 L
.50363 .43747 L
.50296 .42785 L
.50261 .41823 L
.50244 .40861 L
.50238 .39899 L
.50243 .38937 L
.50258 .37975 L
.50288 .37013 L
.50348 .36051 L
.50481 .35247 L
.50519 .35089 L
.51443 .34533 L
.52292 .35089 L
.52405 .35178 L
.53367 .36005 L
.53427 .36051 L
.54329 .36892 L
.54469 .37013 L
.55291 .37806 L
.55475 .37975 L
.56253 .38735 L
.56467 .38937 L
.57215 .39673 L
.57451 .39899 L
.58177 .40617 L
.58429 .40861 L
.59139 .41564 L
.59405 .41823 L
.60101 .42514 L
.60377 .42785 L
.61063 .43466 L
.61348 .43747 L
.62025 .4442 L
.62318 .44709 L
.62987 .45375 L
.63286 .45671 L
.63949 .46331 L
.64254 .46633 L
.64911 .47288 L
.65221 .47595 L
.65873 .48245 L
.66187 .48557 L
.66835 .49203 L
.67153 .49519 L
.67797 .50162 L
.68119 .50481 L
.68759 .5112 L
Mistroke
.69084 .51443 L
.69721 .52079 L
.70048 .52405 L
.70683 .53039 L
.71013 .53367 L
.71645 .53998 L
.71977 .54329 L
.72607 .54958 L
.72941 .55291 L
.73569 .55918 L
.73905 .56253 L
.74531 .56878 L
.74869 .57215 L
.75493 .57838 L
.75833 .58177 L
.76455 .58799 L
.76796 .59139 L
.77417 .59759 L
.7776 .60101 L
.78379 .6072 L
.78723 .61063 L
.79341 .61681 L
.79686 .62025 L
.80303 .62641 L
.8065 .62987 L
.81265 .63602 L
.81613 .63949 L
.82227 .64563 L
.82576 .64911 L
.83189 .65524 L
.83539 .65873 L
.84151 .66485 L
.84502 .66835 L
.85113 .67446 L
.85465 .67797 L
.86075 .68407 L
.86427 .68759 L
.87037 .69369 L
.8739 .69721 L
.87999 .7033 L
.88353 .70683 L
.88961 .71291 L
.89316 .71645 L
.89923 .72252 L
.90278 .72607 L
.90885 .73214 L
.91241 .73569 L
.91847 .74175 L
.92204 .74531 L
.92809 .75136 L
Mistroke
.93166 .75493 L
.93771 .76098 L
.94129 .76455 L
.94733 .77059 L
.95091 .77417 L
.95695 .78021 L
.96054 .78379 L
.96657 .78982 L
.97015 .79341 L
.97619 .79944 L
Mfstroke
.97619 .64936 m
.97594 .64911 L
.96657 .63974 L
.96632 .63949 L
.95695 .63011 L
.95671 .62987 L
.94733 .62049 L
.94709 .62025 L
.93771 .61086 L
.93748 .61063 L
.92809 .60123 L
.92787 .60101 L
.91847 .59161 L
.91825 .59139 L
.90885 .58198 L
.90864 .58177 L
.89923 .57236 L
.89903 .57215 L
.88961 .56273 L
.88941 .56253 L
.87999 .5531 L
.8798 .55291 L
.87037 .54347 L
.87019 .54329 L
.86075 .53385 L
.86058 .53367 L
.85113 .52422 L
.85096 .52405 L
.84151 .51459 L
.84135 .51443 L
.83189 .50496 L
.83174 .50481 L
.82227 .49533 L
.82213 .49519 L
.81265 .4857 L
.81252 .48557 L
.80303 .47607 L
.80292 .47595 L
.79341 .46643 L
.79331 .46633 L
.78379 .4568 L
.7837 .45671 L
.77417 .44717 L
.77409 .44709 L
.76455 .43753 L
.76449 .43747 L
.75493 .42789 L
.75489 .42785 L
.74531 .41826 L
.74528 .41823 L
Mistroke
.73569 .40862 L
.73568 .40861 L
.72608 .39899 L
.72607 .39898 L
.71648 .38937 L
.71645 .38934 L
.70689 .37975 L
.70683 .37969 L
.6973 .37013 L
.69721 .37004 L
.68771 .36051 L
.68759 .3604 L
.67812 .35089 L
.67797 .35074 L
.66853 .34127 L
.66835 .34109 L
.65895 .33165 L
.65873 .33143 L
.64938 .32203 L
.64911 .32176 L
.63981 .31241 L
.63949 .31209 L
.63025 .30279 L
.62987 .30241 L
.6207 .29317 L
.62025 .29272 L
.61116 .28355 L
.61063 .28301 L
.60164 .27393 L
.60101 .2733 L
.59214 .26431 L
.59139 .26356 L
.58266 .25469 L
.58177 .25379 L
.57323 .24507 L
.57215 .24399 L
.56385 .23545 L
.56253 .23413 L
.55456 .22583 L
.55291 .22418 L
.54542 .21621 L
.54329 .21408 L
.53658 .20659 L
.53367 .20371 L
.52849 .19697 L
.52405 .19274 L
.51969 .18735 L
.51443 .17995 L
.51305 .17773 L
.50838 .16811 L
Mistroke
.5059 .15849 L
.50481 .15358 L
.50419 .14887 L
.50372 .13925 L
.50301 .12963 L
.50264 .12001 L
.50245 .11039 L
.50238 .10077 L
.50242 .09115 L
.50256 .08153 L
.50284 .07191 L
.50339 .06229 L
.50481 .05327 L
.50495 .05267 L
.51443 .04613 L
.52405 .05258 L
.52416 .05267 L
.53367 .06085 L
.53557 .06229 L
.54329 .06972 L
.54582 .07191 L
.55291 .07886 L
.55582 .08153 L
.56253 .08815 L
.56571 .09115 L
.57215 .09753 L
.57553 .10077 L
.58177 .10697 L
.5853 .11039 L
.59139 .11644 L
.59505 .12001 L
.60101 .12594 L
.60477 .12963 L
.61063 .13546 L
.61448 .13925 L
.62025 .145 L
.62417 .14887 L
.62987 .15455 L
.63385 .15849 L
.63949 .16411 L
.64353 .16811 L
.64911 .17368 L
.6532 .17773 L
.65873 .18325 L
.66286 .18735 L
.66835 .19283 L
.67252 .19697 L
.67797 .20242 L
.68217 .20659 L
.68759 .212 L
Mistroke
.69182 .21621 L
.69721 .22159 L
.70147 .22583 L
.70683 .23119 L
.71111 .23545 L
.71645 .24078 L
.72076 .24507 L
.72607 .25038 L
.7304 .25469 L
.73569 .25998 L
.74004 .26431 L
.74531 .26958 L
.74967 .27393 L
.75493 .27918 L
.75931 .28355 L
.76455 .28879 L
.76895 .29317 L
.77417 .29839 L
.77858 .30279 L
.78379 .308 L
.78821 .31241 L
.79341 .31761 L
.79785 .32203 L
.80303 .32721 L
.80748 .33165 L
.81265 .33682 L
.81711 .34127 L
.82227 .34643 L
.82674 .35089 L
.83189 .35604 L
.83637 .36051 L
.84151 .36565 L
.846 .37013 L
.85113 .37526 L
.85563 .37975 L
.86075 .38487 L
.86525 .38937 L
.87037 .39449 L
.87488 .39899 L
.87999 .4041 L
.88451 .40861 L
.88961 .41371 L
.89414 .41823 L
.89923 .42332 L
.90376 .42785 L
.90885 .43294 L
.91339 .43747 L
.91847 .44255 L
.92302 .44709 L
.92809 .45216 L
Mistroke
.93264 .45671 L
.93771 .46178 L
.94227 .46633 L
.94733 .47139 L
.95189 .47595 L
.95695 .48101 L
.96152 .48557 L
.96657 .49062 L
.97113 .49519 L
.97619 .50024 L
Mfstroke
.85366 .97619 m
.85113 .97366 L
.84404 .96657 L
.84151 .96405 L
.83441 .95695 L
.83189 .95444 L
.82478 .94733 L
.82227 .94483 L
.81515 .93771 L
.81265 .93522 L
.80551 .92809 L
.80303 .92561 L
.79588 .91847 L
.79341 .91601 L
.78625 .90885 L
.78379 .9064 L
.77662 .89923 L
.77417 .89679 L
.76698 .88961 L
.76455 .88719 L
.75735 .87999 L
.75493 .87758 L
.74771 .87037 L
.74531 .86798 L
.73807 .86075 L
.73569 .85838 L
.72843 .85113 L
.72607 .84878 L
.71879 .84151 L
.71645 .83918 L
.70915 .83189 L
.70683 .82959 L
.6995 .82227 L
.69721 .81999 L
.68985 .81265 L
.68759 .8104 L
.6802 .80303 L
.67797 .80082 L
.67055 .79341 L
.66835 .79123 L
.66089 .78379 L
.65873 .78165 L
.65122 .77417 L
.64911 .77208 L
.64155 .76455 L
.63949 .76251 L
.63187 .75493 L
.62987 .75295 L
.62219 .74531 L
.62025 .7434 L
Mistroke
.61249 .73569 L
.61063 .73386 L
.60278 .72607 L
.60101 .72434 L
.59304 .71645 L
.59139 .71484 L
.58328 .70683 L
.58177 .70537 L
.57349 .69721 L
.57215 .69593 L
.56363 .68759 L
.56253 .68655 L
.55368 .67797 L
.55291 .67726 L
.54356 .66835 L
.54329 .66812 L
.53367 .65925 L
.53309 .65873 L
.52405 .65098 L
.52164 .64911 L
.51443 .64453 L
.50548 .64911 L
.50481 .65166 L
.50357 .65873 L
.50292 .66835 L
.5026 .67797 L
.50244 .68759 L
.50238 .69721 L
.50243 .70683 L
.50259 .71645 L
.50292 .72607 L
.50354 .73569 L
.50398 .74531 L
.50481 .75197 L
.5054 .75493 L
.50769 .76455 L
.51192 .77417 L
.51443 .77835 L
.51821 .78379 L
.52405 .79114 L
.52638 .79341 L
.53367 .80211 L
.53459 .80303 L
.54329 .81248 L
.54346 .81265 L
.55266 .82227 L
.55291 .82257 L
.56196 .83189 L
.56253 .83252 L
.57134 .84151 L
Mistroke
.57215 .84239 L
.58076 .85113 L
.58177 .85219 L
.59023 .86075 L
.59139 .86196 L
.59972 .87037 L
.60101 .8717 L
.60924 .87999 L
.61063 .88141 L
.61877 .88961 L
.62025 .89111 L
.62832 .89923 L
.62987 .9008 L
.63788 .90885 L
.63949 .91048 L
.64744 .91847 L
.64911 .92016 L
.65702 .92809 L
.65873 .92982 L
.66659 .93771 L
.66835 .93948 L
.67618 .94733 L
.67797 .94914 L
.68576 .95695 L
.68759 .95879 L
.69535 .96657 L
.69721 .96844 L
.70494 .97619 L
Mfstroke
.5527 .97619 m
.54329 .96732 L
.54302 .96657 L
.53367 .95845 L
.53199 .95695 L
.52405 .95018 L
.52031 .94733 L
.51443 .94373 L
.50582 .94733 L
.50481 .95086 L
.50368 .95695 L
.50297 .96657 L
.50263 .97619 L
s
.02381 .59505 m
.02977 .60101 L
.03343 .60468 L
.03937 .61063 L
.04305 .6143 L
.04899 .62025 L
.05267 .62393 L
.0586 .62987 L
.06229 .63356 L
.06822 .63949 L
.07191 .64318 L
.07783 .64911 L
.08153 .65281 L
.08745 .65873 L
.09115 .66243 L
.09706 .66835 L
.10077 .67206 L
.10667 .67797 L
.11039 .68169 L
.11628 .68759 L
.12001 .69131 L
.1259 .69721 L
.12963 .70094 L
.13551 .70683 L
.13925 .71057 L
.14512 .71645 L
.14887 .7202 L
.15473 .72607 L
.15849 .72983 L
.16434 .73569 L
.16811 .73946 L
.17395 .74531 L
.17773 .74909 L
.18356 .75493 L
.18735 .75872 L
.19317 .76455 L
.19697 .76835 L
.20278 .77417 L
.20659 .77798 L
.21238 .78379 L
.21621 .78762 L
.22199 .79341 L
.22583 .79725 L
.2316 .80303 L
.23545 .80688 L
.2412 .81265 L
.24507 .81652 L
.2508 .82227 L
.25469 .82616 L
.2604 .83189 L
Mistroke
.26431 .8358 L
.27 .84151 L
.27393 .84544 L
.2796 .85113 L
.28355 .85508 L
.2892 .86075 L
.29317 .86472 L
.29879 .87037 L
.30279 .87437 L
.30838 .87999 L
.31241 .88402 L
.31797 .88961 L
.32203 .89367 L
.32755 .89923 L
.33165 .90333 L
.33713 .90885 L
.34127 .91299 L
.34671 .91847 L
.35089 .92266 L
.35628 .92809 L
.36051 .93233 L
.36584 .93771 L
.37013 .94201 L
.37539 .94733 L
.37975 .9517 L
.38493 .95695 L
.38937 .9614 L
.39446 .96657 L
.39899 .97112 L
.40396 .97619 L
Mfstroke
.02381 .74418 m
.02495 .74531 L
.03343 .75379 L
.03457 .75493 L
.04305 .76341 L
.04419 .76455 L
.05267 .77302 L
.05382 .77417 L
.06229 .78264 L
.06344 .78379 L
.07191 .79225 L
.07307 .79341 L
.08153 .80187 L
.08269 .80303 L
.09115 .81148 L
.09232 .81265 L
.10077 .82109 L
.10195 .82227 L
.11039 .83071 L
.11157 .83189 L
.12001 .84032 L
.1212 .84151 L
.12963 .84993 L
.13083 .85113 L
.13925 .85954 L
.14046 .86075 L
.14887 .86915 L
.15008 .87037 L
.15849 .87876 L
.15971 .87999 L
.16811 .88838 L
.16934 .88961 L
.17773 .89799 L
.17897 .89923 L
.18735 .90759 L
.1886 .90885 L
.19697 .9172 L
.19824 .91847 L
.20659 .92681 L
.20787 .92809 L
.21621 .93642 L
.2175 .93771 L
.22583 .94602 L
.22714 .94733 L
.23545 .95563 L
.23677 .95695 L
.24507 .96523 L
.24641 .96657 L
.25469 .97483 L
.25604 .97619 L
Mistroke
Mfstroke
.02381 .89425 m
.0288 .89923 L
.03343 .90388 L
.0384 .90885 L
.04305 .9135 L
.04801 .91847 L
.05267 .92313 L
.05762 .92809 L
.06229 .93275 L
.06724 .93771 L
.07191 .94238 L
.07685 .94733 L
.08153 .95201 L
.08647 .95695 L
.09115 .96163 L
.09608 .96657 L
.10077 .97126 L
.10569 .97619 L
s
.97619 .05096 m
.96828 .04305 L
.96657 .04134 L
.95867 .03343 L
.95695 .03171 L
.94905 .02381 L
s
.97619 .20104 m
.9721 .19697 L
.96657 .19142 L
.9625 .18735 L
.95695 .18181 L
.95287 .17773 L
.94733 .17219 L
.94325 .16811 L
.93771 .16258 L
.93362 .15849 L
.92809 .15297 L
.924 .14887 L
.91847 .14335 L
.91437 .13925 L
.90885 .13374 L
.90474 .12963 L
.89923 .12412 L
.89512 .12001 L
.88961 .11451 L
.88549 .11039 L
.87999 .1049 L
.87586 .10077 L
.87037 .09529 L
.86623 .09115 L
.86075 .08567 L
.85661 .08153 L
.85113 .07606 L
.84698 .07191 L
.84151 .06645 L
.83735 .06229 L
.83189 .05684 L
.82772 .05267 L
.82227 .04723 L
.81809 .04305 L
.81265 .03762 L
.80846 .03343 L
.80303 .02802 L
.79883 .02381 L
s
.97619 .35016 m
.9673 .34127 L
.96657 .34054 L
.95769 .33165 L
.95695 .33091 L
.94807 .32203 L
.94733 .32129 L
.93846 .31241 L
.93771 .31166 L
.92884 .30279 L
.92809 .30204 L
.91923 .29317 L
.91847 .29241 L
.90962 .28355 L
.90885 .28278 L
.9 .27393 L
.89923 .27316 L
.89039 .26431 L
.88961 .26353 L
.88078 .25469 L
.87999 .2539 L
.87117 .24507 L
.87037 .24427 L
.86155 .23545 L
.86075 .23465 L
.85194 .22583 L
.85113 .22502 L
.84233 .21621 L
.84151 .21539 L
.83272 .20659 L
.83189 .20576 L
.82311 .19697 L
.82227 .19613 L
.8135 .18735 L
.81265 .1865 L
.80389 .17773 L
.80303 .17687 L
.79429 .16811 L
.79341 .16723 L
.78468 .15849 L
.78379 .1576 L
.77507 .14887 L
.77417 .14797 L
.76547 .13925 L
.76455 .13833 L
.75586 .12963 L
.75493 .1287 L
.74626 .12001 L
.74531 .11906 L
.73666 .11039 L
Mistroke
.73569 .10942 L
.72706 .10077 L
.72607 .09978 L
.71746 .09115 L
.71645 .09014 L
.70787 .08153 L
.70683 .08049 L
.69827 .07191 L
.69721 .07085 L
.68868 .06229 L
.68759 .0612 L
.6791 .05267 L
.67797 .05154 L
.66951 .04305 L
.66835 .04189 L
.65993 .03343 L
.65873 .03223 L
.65036 .02381 L
Mfstroke
.34964 .02381 m
.35089 .02506 L
.35921 .03343 L
.36051 .03473 L
.36877 .04305 L
.37013 .04441 L
.37832 .05267 L
.37975 .0541 L
.38786 .06229 L
.38937 .0638 L
.39738 .07191 L
.39899 .07352 L
.40688 .08153 L
.40861 .08326 L
.41636 .09115 L
.41823 .09303 L
.4258 .10077 L
.42785 .10283 L
.43517 .11039 L
.43747 .11269 L
.44446 .12001 L
.44709 .12264 L
.4536 .12963 L
.45671 .13274 L
.46243 .13925 L
.46633 .14311 L
.47044 .14887 L
.47595 .15408 L
.47954 .15849 L
.48557 .16687 L
.48636 .16811 L
.49124 .17773 L
.49381 .18735 L
.49519 .19324 L
.49569 .19697 L
.49617 .20659 L
.49694 .21621 L
.49733 .22583 L
.49754 .23545 L
.49761 .24507 L
.49759 .25469 L
.49746 .26431 L
.4972 .27393 L
.49669 .28355 L
.4953 .29317 L
.49519 .29354 L
.48557 .30069 L
.47595 .29424 L
.47465 .29317 L
.46633 .28597 L
Mistroke
.46313 .28355 L
.45671 .2771 L
.45306 .27393 L
.44709 .26796 L
.44313 .26431 L
.43747 .25867 L
.43327 .25469 L
.42785 .24929 L
.42346 .24507 L
.41823 .23985 L
.41369 .23545 L
.40861 .23038 L
.40395 .22583 L
.39899 .22088 L
.39424 .21621 L
.38937 .21135 L
.38453 .20659 L
.37975 .20182 L
.37484 .19697 L
.37013 .19227 L
.36516 .18735 L
.36051 .18271 L
.35549 .17773 L
.35089 .17314 L
.34582 .16811 L
.34127 .16356 L
.33616 .15849 L
.33165 .15399 L
.3265 .14887 L
.32203 .1444 L
.31685 .13925 L
.31241 .13481 L
.3072 .12963 L
.30279 .12522 L
.29755 .12001 L
.29317 .11563 L
.28791 .11039 L
.28355 .10604 L
.27826 .10077 L
.27393 .09644 L
.26862 .09115 L
.26431 .08684 L
.25898 .08153 L
.25469 .07724 L
.24935 .07191 L
.24507 .06763 L
.23971 .06229 L
.23545 .05803 L
.23007 .05267 L
.22583 .04843 L
Mistroke
.22044 .04305 L
.21621 .03882 L
.21081 .03343 L
.20659 .02922 L
.20117 .02381 L
Mfstroke
.02381 .14578 m
.02692 .14887 L
.03343 .1554 L
.03652 .15849 L
.04305 .16501 L
.04615 .16811 L
.05267 .17462 L
.05577 .17773 L
.06229 .18424 L
.0654 .18735 L
.07191 .19385 L
.07502 .19697 L
.08153 .20347 L
.08465 .20659 L
.09115 .21308 L
.09428 .21621 L
.10077 .22269 L
.1039 .22583 L
.11039 .23231 L
.11353 .23545 L
.12001 .24192 L
.12316 .24507 L
.12963 .25153 L
.13279 .25469 L
.13925 .26114 L
.14241 .26431 L
.14887 .27076 L
.15204 .27393 L
.15849 .28037 L
.16167 .28355 L
.16811 .28998 L
.1713 .29317 L
.17773 .29959 L
.18093 .30279 L
.18735 .3092 L
.19056 .31241 L
.19697 .3188 L
.20019 .32203 L
.20659 .32841 L
.20983 .33165 L
.21621 .33802 L
.21946 .34127 L
.22583 .34762 L
.22909 .35089 L
.23545 .35723 L
.23873 .36051 L
.24507 .36683 L
.24836 .37013 L
.25469 .37644 L
.258 .37975 L
Mistroke
.26431 .38604 L
.26764 .38937 L
.27393 .39564 L
.27728 .39899 L
.28355 .40523 L
.28692 .40861 L
.29317 .41483 L
.29657 .41823 L
.30279 .42442 L
.30622 .42785 L
.31241 .43401 L
.31586 .43747 L
.32203 .4436 L
.32552 .44709 L
.33165 .45319 L
.33517 .45671 L
.34127 .46276 L
.34484 .46633 L
.35089 .47234 L
.3545 .47595 L
.36051 .48191 L
.36417 .48557 L
.37013 .49147 L
.37385 .49519 L
.37975 .50102 L
.38354 .50481 L
.38937 .51055 L
.39325 .51443 L
.39899 .52008 L
.40296 .52405 L
.40861 .52958 L
.4127 .53367 L
.41823 .53905 L
.42246 .54329 L
.42785 .54849 L
.43225 .55291 L
.43747 .55787 L
.44208 .56253 L
.44709 .56716 L
.45196 .57215 L
.45671 .5763 L
.46185 .58177 L
.46633 .58517 L
.47347 .59139 L
.47595 .59344 L
.48557 .59989 L
.49519 .59274 L
.49556 .59139 L
.49676 .58177 L
.49723 .57215 L
Mistroke
.49748 .56253 L
.4976 .55291 L
.49761 .54329 L
.49752 .53367 L
.4973 .52405 L
.49688 .51443 L
.49606 .50481 L
.49557 .49519 L
.49519 .49245 L
.49348 .48557 L
.49085 .47595 L
.48574 .46633 L
.48557 .46607 L
.47876 .45671 L
.47595 .45328 L
.4694 .44709 L
.46633 .44231 L
.46144 .43747 L
.45671 .43194 L
.45262 .42785 L
.44709 .42184 L
.44349 .41823 L
.43747 .41189 L
.4342 .40861 L
.42785 .40203 L
.42482 .39899 L
.41823 .39222 L
.41538 .38937 L
.40861 .38246 L
.40591 .37975 L
.39899 .37272 L
.3964 .37013 L
.38937 .363 L
.38688 .36051 L
.37975 .3533 L
.37734 .35089 L
.37013 .34361 L
.36779 .34127 L
.36051 .33393 L
.35823 .33165 L
.35089 .32426 L
.34866 .32203 L
.34127 .31459 L
.33909 .31241 L
.33165 .30493 L
.32951 .30279 L
.32203 .29527 L
.31993 .29317 L
.31241 .28562 L
.31034 .28355 L
Mistroke
.30279 .27597 L
.30075 .27393 L
.29317 .26633 L
.29115 .26431 L
.28355 .25668 L
.28156 .25469 L
.27393 .24704 L
.27196 .24507 L
.26431 .2374 L
.26236 .23545 L
.25469 .22776 L
.25276 .22583 L
.24507 .21812 L
.24316 .21621 L
.23545 .20849 L
.23355 .20659 L
.22583 .19885 L
.22395 .19697 L
.21621 .18922 L
.21434 .18735 L
.20659 .17958 L
.20473 .17773 L
.19697 .16995 L
.19513 .16811 L
.18735 .16032 L
.18552 .15849 L
.17773 .15069 L
.17591 .14887 L
.16811 .14106 L
.1663 .13925 L
.15849 .13143 L
.15669 .12963 L
.14887 .1218 L
.14708 .12001 L
.13925 .11217 L
.13747 .11039 L
.12963 .10254 L
.12785 .10077 L
.12001 .09292 L
.11824 .09115 L
.11039 .08329 L
.10863 .08153 L
.10077 .07366 L
.09902 .07191 L
.09115 .06403 L
.0894 .06229 L
.08153 .05441 L
.07979 .05267 L
.07191 .04478 L
.07018 .04305 L
Mistroke
.06229 .03516 L
.06056 .03343 L
.05267 .02554 L
.05095 .02381 L
Mfstroke
0 0 1 r
.02381 .44284 m
.0281 .44709 L
.03343 .45241 L
.03775 .45671 L
.04305 .46198 L
.04742 .46633 L
.05267 .47154 L
.0571 .47595 L
.06229 .48111 L
.06678 .48557 L
.07191 .49067 L
.07646 .49519 L
.08153 .50023 L
.08614 .50481 L
.09115 .50978 L
.09582 .51443 L
.10077 .51934 L
.10551 .52405 L
.11039 .52889 L
.11521 .53367 L
.12001 .53843 L
.1249 .54329 L
.12963 .54797 L
.1346 .55291 L
.13925 .55751 L
.14431 .56253 L
.14887 .56705 L
.15402 .57215 L
.15849 .57658 L
.16373 .58177 L
.16811 .5861 L
.17345 .59139 L
.17773 .59562 L
.18318 .60101 L
.18735 .60513 L
.19291 .61063 L
.19697 .61463 L
.20265 .62025 L
.20659 .62413 L
.2124 .62987 L
.21621 .63362 L
.22216 .63949 L
.22583 .6431 L
.23193 .64911 L
.23545 .65257 L
.24171 .65873 L
.24507 .66202 L
.2515 .66835 L
.25469 .67147 L
.26131 .67797 L
Mistroke
.26431 .6809 L
.27114 .68759 L
.27393 .69031 L
.28098 .69721 L
.28355 .69971 L
.29085 .70683 L
.29317 .70908 L
.30074 .71645 L
.30279 .71843 L
.31066 .72607 L
.31241 .72776 L
.32062 .73569 L
.32203 .73705 L
.33061 .74531 L
.33165 .7463 L
.34066 .75493 L
.34127 .75551 L
.35077 .76455 L
.35089 .76466 L
.36051 .77375 L
.36095 .77417 L
.37013 .78276 L
.37122 .78379 L
.37975 .79167 L
.3816 .79341 L
.38937 .80045 L
.39216 .80303 L
.39899 .80907 L
.40295 .81265 L
.40861 .81747 L
.41412 .82227 L
.41823 .82557 L
.42599 .83189 L
.42785 .83325 L
.43747 .84028 L
.4393 .84151 L
.44709 .84628 L
.45671 .85039 L
.46633 .85036 L
.47446 .84151 L
.47572 .83189 L
.47595 .82929 L
.47619 .82227 L
.47595 .81583 L
.47569 .81265 L
.47439 .80303 L
.47229 .79341 L
.46941 .78379 L
.46633 .77551 L
.46575 .77417 L
Mistroke
.46119 .76455 L
.45671 .75624 L
.45593 .75493 L
.44986 .74531 L
.44709 .74111 L
.44322 .73569 L
.43747 .72787 L
.43607 .72607 L
.42847 .71645 L
.42785 .71567 L
.42051 .70683 L
.41823 .7041 L
.41228 .69721 L
.40861 .69296 L
.40384 .68759 L
.39899 .68212 L
.39523 .67797 L
.38937 .6715 L
.38647 .66835 L
.37975 .66105 L
.37759 .65873 L
.37013 .65071 L
.36862 .64911 L
.36051 .64048 L
.35957 .63949 L
.35089 .63033 L
.35045 .62987 L
.34127 .62025 L
.34127 .62025 L
.33205 .61063 L
.33165 .61021 L
.32278 .60101 L
.32203 .60023 L
.31348 .59139 L
.31241 .59028 L
.30415 .58177 L
.30279 .58036 L
.2948 .57215 L
.29317 .57047 L
.28542 .56253 L
.28355 .56061 L
.27603 .55291 L
.27393 .55076 L
.26661 .54329 L
.26431 .54094 L
.25718 .53367 L
.25469 .53113 L
.24774 .52405 L
.24507 .52133 L
.23828 .51443 L
Mistroke
.23545 .51155 L
.22881 .50481 L
.22583 .50178 L
.21933 .49519 L
.21621 .49202 L
.20985 .48557 L
.20659 .48227 L
.20035 .47595 L
.19697 .47252 L
.19085 .46633 L
.18735 .46279 L
.18134 .45671 L
.17773 .45306 L
.17182 .44709 L
.16811 .44334 L
.1623 .43747 L
.15849 .43362 L
.15277 .42785 L
.14887 .42391 L
.14324 .41823 L
.13925 .4142 L
.1337 .40861 L
.12963 .4045 L
.12416 .39899 L
.12001 .3948 L
.11462 .38937 L
.11039 .38511 L
.10507 .37975 L
.10077 .37542 L
.09551 .37013 L
.09115 .36573 L
.08596 .36051 L
.08153 .35605 L
.0764 .35089 L
.07191 .34637 L
.06684 .34127 L
.06229 .33669 L
.05728 .33165 L
.05267 .32701 L
.04771 .32203 L
.04305 .31734 L
.03814 .31241 L
.03343 .30767 L
.02859 .30279 L
.02381 .298 L
Mfstroke
.97619 .94642 m
.96753 .93771 L
.96657 .93675 L
.95796 .92809 L
.95695 .92708 L
.94839 .91847 L
.94733 .9174 L
.93883 .90885 L
.93771 .90773 L
.92927 .89923 L
.92809 .89805 L
.91971 .88961 L
.91847 .88837 L
.91015 .87999 L
.90885 .87869 L
.90059 .87037 L
.89923 .869 L
.89104 .86075 L
.88961 .85931 L
.8815 .85113 L
.87999 .84961 L
.87195 .84151 L
.87037 .83992 L
.86241 .83189 L
.86075 .83021 L
.85288 .82227 L
.85113 .82051 L
.84335 .81265 L
.84151 .8108 L
.83382 .80303 L
.83189 .80108 L
.8243 .79341 L
.82227 .79136 L
.81479 .78379 L
.81265 .78163 L
.80528 .77417 L
.80303 .77189 L
.79578 .76455 L
.79341 .76215 L
.78629 .75493 L
.78379 .7524 L
.77681 .74531 L
.77417 .74264 L
.76733 .73569 L
.76455 .73287 L
.75787 .72607 L
.75493 .72309 L
.74842 .71645 L
.74531 .71329 L
.73898 .70683 L
Mistroke
.73569 .70348 L
.72955 .69721 L
.72607 .69366 L
.72015 .68759 L
.71645 .68381 L
.71076 .67797 L
.70683 .67395 L
.70139 .66835 L
.69721 .66406 L
.69205 .65873 L
.68759 .65414 L
.68273 .64911 L
.67797 .64419 L
.67345 .63949 L
.66835 .6342 L
.6642 .62987 L
.65873 .62417 L
.655 .62025 L
.64911 .61408 L
.64584 .61063 L
.63949 .60393 L
.63675 .60101 L
.62987 .5937 L
.62772 .59139 L
.62025 .58337 L
.61878 .58177 L
.61063 .57291 L
.60994 .57215 L
.60123 .56253 L
.60101 .56229 L
.59268 .55291 L
.59139 .55145 L
.58433 .54329 L
.58177 .54032 L
.57622 .53367 L
.57215 .52875 L
.56841 .52405 L
.56253 .51654 L
.56097 .51443 L
.55397 .50481 L
.55291 .5033 L
.5476 .49519 L
.54329 .48818 L
.54185 .48557 L
.53686 .47595 L
.53367 .46891 L
.53267 .46633 L
.52932 .45671 L
.52676 .44709 L
.52498 .43747 L
Mistroke
.52405 .4286 L
.524 .42785 L
.52387 .41823 L
.52405 .41513 L
.52476 .40861 L
.52826 .39899 L
.53367 .39403 L
.54329 .39401 L
.55291 .39814 L
.55498 .39899 L
.56253 .40413 L
.56936 .40861 L
.57215 .41117 L
.58113 .41823 L
.58177 .41885 L
.59139 .42695 L
.59246 .42785 L
.60101 .43535 L
.60344 .43747 L
.61063 .44397 L
.61412 .44709 L
.62025 .45275 L
.62458 .45671 L
.62987 .46166 L
.63491 .46633 L
.63949 .47066 L
.64512 .47595 L
.64911 .47975 L
.65526 .48557 L
.65873 .48891 L
.66532 .49519 L
.66835 .49811 L
.67533 .50481 L
.67797 .50737 L
.6853 .51443 L
.68759 .51666 L
.69523 .52405 L
.69721 .52598 L
.70513 .53367 L
.70683 .53533 L
.71501 .54329 L
.71645 .54471 L
.72486 .55291 L
.72607 .5541 L
.73469 .56253 L
.73569 .56352 L
.7445 .57215 L
.74531 .57295 L
.7543 .58177 L
.75493 .58239 L
Mistroke
.76408 .59139 L
.76455 .59185 L
.77386 .60101 L
.77417 .60132 L
.78362 .61063 L
.78379 .6108 L
.79337 .62025 L
.79341 .62029 L
.80303 .62978 L
.80312 .62987 L
.81265 .63929 L
.81285 .63949 L
.82227 .6488 L
.82258 .64911 L
.83189 .65832 L
.83231 .65873 L
.84151 .66784 L
.84202 .66835 L
.85113 .67737 L
.85174 .67797 L
.86075 .6869 L
.86144 .68759 L
.87037 .69644 L
.87115 .69721 L
.87999 .70598 L
.88084 .70683 L
.88961 .71553 L
.89054 .71645 L
.89923 .72508 L
.90023 .72607 L
.90885 .73463 L
.90992 .73569 L
.91847 .74419 L
.9196 .74531 L
.92809 .75375 L
.92928 .75493 L
.93771 .76331 L
.93896 .76455 L
.94733 .77288 L
.94863 .77417 L
.95695 .78244 L
.95831 .78379 L
.96657 .79201 L
.96797 .79341 L
.97619 .80158 L
Mfstroke
.97619 .64722 m
.9685 .63949 L
.96657 .63755 L
.95893 .62987 L
.95695 .62788 L
.94937 .62025 L
.94733 .61821 L
.9398 .61063 L
.93771 .60853 L
.93024 .60101 L
.92809 .59885 L
.92068 .59139 L
.91847 .58917 L
.91112 .58177 L
.90885 .57949 L
.90157 .57215 L
.89923 .5698 L
.89202 .56253 L
.88961 .56011 L
.88247 .55291 L
.87999 .55042 L
.87292 .54329 L
.87037 .54072 L
.86339 .53367 L
.86075 .53102 L
.85385 .52405 L
.85113 .52131 L
.84432 .51443 L
.84151 .5116 L
.83479 .50481 L
.83189 .50188 L
.82527 .49519 L
.82227 .49216 L
.81576 .48557 L
.81265 .48243 L
.80625 .47595 L
.80303 .4727 L
.79675 .46633 L
.79341 .46295 L
.78726 .45671 L
.78379 .4532 L
.77777 .44709 L
.77417 .44344 L
.7683 .43747 L
.76455 .43367 L
.75883 .42785 L
.75493 .42389 L
.74938 .41823 L
.74531 .41409 L
.73994 .40861 L
Mistroke
.73569 .40428 L
.73051 .39899 L
.72607 .39446 L
.7211 .38937 L
.71645 .38461 L
.71171 .37975 L
.70683 .37475 L
.70234 .37013 L
.69721 .36486 L
.693 .36051 L
.68759 .35494 L
.68368 .35089 L
.67797 .34499 L
.67439 .34127 L
.66835 .335 L
.66514 .33165 L
.65873 .32497 L
.65593 .32203 L
.64911 .31488 L
.64677 .31241 L
.63949 .30473 L
.63767 .30279 L
.62987 .2945 L
.62863 .29317 L
.62025 .28417 L
.61968 .28355 L
.61083 .27393 L
.61063 .27371 L
.60211 .26431 L
.60101 .26309 L
.59355 .25469 L
.59139 .25225 L
.58517 .24507 L
.58177 .24112 L
.57704 .23545 L
.57215 .22955 L
.56919 .22583 L
.56253 .21734 L
.56169 .21621 L
.55467 .20659 L
.55291 .2041 L
.54823 .19697 L
.54329 .18898 L
.54239 .18735 L
.53733 .17773 L
.53367 .1697 L
.53305 .16811 L
.52963 .15849 L
.52698 .14887 L
.52513 .13925 L
Mistroke
.52407 .12963 L
.52405 .1294 L
.52384 .12001 L
.52405 .11593 L
.52463 .11039 L
.52771 .10077 L
.53367 .09483 L
.54329 .09481 L
.55291 .09894 L
.55733 .10077 L
.56253 .10493 L
.57058 .11039 L
.57215 .11197 L
.58177 .11965 L
.58222 .12001 L
.59139 .12775 L
.59363 .12963 L
.60101 .13615 L
.60456 .13925 L
.61063 .14477 L
.6152 .14887 L
.62025 .15355 L
.62565 .15849 L
.62987 .16246 L
.63595 .16811 L
.63949 .17146 L
.64616 .17773 L
.64911 .18055 L
.65628 .18735 L
.65873 .18971 L
.66634 .19697 L
.66835 .19891 L
.67634 .20659 L
.67797 .20817 L
.68631 .21621 L
.68759 .21746 L
.69624 .22583 L
.69721 .22678 L
.70613 .23545 L
.70683 .23613 L
.716 .24507 L
.71645 .24551 L
.72585 .25469 L
.72607 .2549 L
.73568 .26431 L
.73569 .26432 L
.74531 .27375 L
.7455 .27393 L
.75493 .28319 L
.75529 .28355 L
Mistroke
.76455 .29265 L
.76508 .29317 L
.77417 .30212 L
.77485 .30279 L
.78379 .3116 L
.78461 .31241 L
.79341 .32109 L
.79437 .32203 L
.80303 .33059 L
.80411 .33165 L
.81265 .34009 L
.81385 .34127 L
.82227 .3496 L
.82358 .35089 L
.83189 .35912 L
.8333 .36051 L
.84151 .36864 L
.84301 .37013 L
.85113 .37817 L
.85273 .37975 L
.86075 .3877 L
.86243 .38937 L
.87037 .39724 L
.87213 .39899 L
.87999 .40679 L
.88183 .40861 L
.88961 .41633 L
.89153 .41823 L
.89923 .42588 L
.90122 .42785 L
.90885 .43543 L
.9109 .43747 L
.91847 .44499 L
.92059 .44709 L
.92809 .45455 L
.93027 .45671 L
.93771 .46411 L
.93994 .46633 L
.94733 .47368 L
.94962 .47595 L
.95695 .48324 L
.95929 .48557 L
.96657 .49281 L
.96895 .49519 L
.97619 .50238 L
Mfstroke
.85075 .97619 m
.84151 .96704 L
.84104 .96657 L
.83189 .95752 L
.83132 .95695 L
.82227 .948 L
.8216 .94733 L
.81265 .93849 L
.81187 .93771 L
.80303 .92898 L
.80213 .92809 L
.79341 .91949 L
.79238 .91847 L
.78379 .91 L
.78263 .90885 L
.77417 .90052 L
.77287 .89923 L
.76455 .89105 L
.76309 .88961 L
.75493 .88159 L
.75331 .87999 L
.74531 .87215 L
.74351 .87037 L
.73569 .86272 L
.73369 .86075 L
.72607 .8533 L
.72386 .85113 L
.71645 .84391 L
.71401 .84151 L
.70683 .83453 L
.70413 .83189 L
.69721 .82518 L
.69423 .82227 L
.68759 .81586 L
.68429 .81265 L
.67797 .80657 L
.67432 .80303 L
.66835 .79731 L
.6643 .79341 L
.65873 .78811 L
.65423 .78379 L
.64911 .77895 L
.64409 .77417 L
.63949 .76986 L
.63386 .76455 L
.62987 .76086 L
.62352 .75493 L
.62025 .75195 L
.61303 .74531 L
.61063 .74317 L
Mistroke
.60232 .73569 L
.60101 .73455 L
.59139 .72615 L
.59131 .72607 L
.58177 .71804 L
.58004 .71645 L
.57215 .71037 L
.56799 .70683 L
.56253 .70333 L
.55291 .69734 L
.55266 .69721 L
.54329 .69321 L
.53367 .69324 L
.52891 .69721 L
.5249 .70683 L
.52405 .71433 L
.52391 .71645 L
.52395 .72607 L
.52405 .72779 L
.52485 .73569 L
.52654 .74531 L
.52903 .75493 L
.53229 .76455 L
.53367 .76811 L
.53639 .77417 L
.54131 .78379 L
.54329 .78738 L
.54698 .79341 L
.55291 .80249 L
.55329 .80303 L
.56024 .81265 L
.56253 .81574 L
.56764 .82227 L
.57215 .82795 L
.57541 .83189 L
.58177 .83951 L
.58349 .84151 L
.59139 .85065 L
.59182 .85113 L
.60036 .86075 L
.60101 .86149 L
.60906 .87037 L
.61063 .87211 L
.61788 .87999 L
.62025 .88257 L
.62681 .88961 L
.62987 .8929 L
.63583 .89923 L
.63949 .90313 L
.64491 .90885 L
Mistroke
.64911 .91328 L
.65406 .91847 L
.65873 .92337 L
.66326 .92809 L
.66835 .9334 L
.6725 .93771 L
.67797 .94339 L
.68178 .94733 L
.68759 .95334 L
.6911 .95695 L
.69721 .96326 L
.70044 .96657 L
.70683 .97313 L
.7098 .97619 L
Mfstroke
.02381 .5972 m
.02761 .60101 L
.03343 .60687 L
.03717 .61063 L
.04305 .61654 L
.04674 .62025 L
.05267 .62621 L
.0563 .62987 L
.06229 .63589 L
.06587 .63949 L
.07191 .64557 L
.07543 .64911 L
.08153 .65525 L
.08499 .65873 L
.09115 .66493 L
.09454 .66835 L
.10077 .67462 L
.10409 .67797 L
.11039 .68431 L
.11364 .68759 L
.12001 .694 L
.12319 .69721 L
.12963 .7037 L
.13273 .70683 L
.13925 .7134 L
.14227 .71645 L
.14887 .72311 L
.1518 .72607 L
.15849 .73282 L
.16133 .73569 L
.16811 .74254 L
.17085 .74531 L
.17773 .75226 L
.18037 .75493 L
.18735 .76199 L
.18988 .76455 L
.19697 .77172 L
.19938 .77417 L
.20659 .78146 L
.20888 .78379 L
.21621 .79122 L
.21837 .79341 L
.22583 .80098 L
.22785 .80303 L
.23545 .81075 L
.23732 .81265 L
.24507 .82053 L
.24678 .82227 L
.25469 .83033 L
.25622 .83189 L
Mistroke
.26431 .84014 L
.26565 .84151 L
.27393 .84996 L
.27507 .85113 L
.28355 .85981 L
.28447 .86075 L
.29317 .86967 L
.29385 .87037 L
.30279 .87956 L
.30321 .87999 L
.31241 .88948 L
.31254 .88961 L
.32184 .89923 L
.32203 .89943 L
.33111 .90885 L
.33165 .90941 L
.34033 .91847 L
.34127 .91945 L
.34951 .92809 L
.35089 .92953 L
.35864 .93771 L
.36051 .93968 L
.3677 .94733 L
.37013 .94991 L
.37668 .95695 L
.37975 .96024 L
.38557 .96657 L
.38937 .97071 L
.39434 .97619 L
Mfstroke
.02381 .74204 m
.02712 .74531 L
.03343 .75161 L
.03677 .75493 L
.04305 .76118 L
.04644 .76455 L
.05267 .77074 L
.05611 .77417 L
.06229 .78031 L
.06579 .78379 L
.07191 .78987 L
.07547 .79341 L
.08153 .79943 L
.08515 .80303 L
.09115 .80898 L
.09484 .81265 L
.10077 .81854 L
.10453 .82227 L
.11039 .82809 L
.11422 .83189 L
.12001 .83763 L
.12391 .84151 L
.12963 .84717 L
.13361 .85113 L
.13925 .85671 L
.14332 .86075 L
.14887 .86625 L
.15303 .87037 L
.15849 .87578 L
.16274 .87999 L
.16811 .8853 L
.17246 .88961 L
.17773 .89482 L
.18219 .89923 L
.18735 .90433 L
.19192 .90885 L
.19697 .91383 L
.20166 .91847 L
.20659 .92333 L
.21141 .92809 L
.21621 .93282 L
.22117 .93771 L
.22583 .9423 L
.23093 .94733 L
.23545 .95177 L
.24071 .95695 L
.24507 .96122 L
.25051 .96657 L
.25469 .97066 L
.26031 .97619 L
Mistroke
Mfstroke
.02381 .8964 m
.02664 .89923 L
.03343 .90607 L
.0362 .90885 L
.04305 .91574 L
.04576 .91847 L
.05267 .92541 L
.05533 .92809 L
.06229 .93509 L
.06489 .93771 L
.07191 .94477 L
.07446 .94733 L
.08153 .95445 L
.08401 .95695 L
.09115 .96413 L
.09357 .96657 L
.10077 .97381 L
.10312 .97619 L
s
.97619 .04882 m
.97044 .04305 L
.96657 .03915 L
.96088 .03343 L
.95695 .02948 L
.95131 .02381 L
s
.97619 .20318 m
.96993 .19697 L
.96657 .19361 L
.96028 .18735 L
.95695 .18404 L
.95061 .17773 L
.94733 .17448 L
.94093 .16811 L
.93771 .16491 L
.93125 .15849 L
.92809 .15535 L
.92157 .14887 L
.91847 .14579 L
.91189 .13925 L
.90885 .13623 L
.9022 .12963 L
.89923 .12668 L
.89251 .12001 L
.88961 .11713 L
.88282 .11039 L
.87999 .10759 L
.87312 .10077 L
.87037 .09804 L
.86342 .09115 L
.86075 .08851 L
.85372 .08153 L
.85113 .07897 L
.844 .07191 L
.84151 .06944 L
.83429 .06229 L
.83189 .05992 L
.82457 .05267 L
.82227 .0504 L
.81484 .04305 L
.81265 .04089 L
.8051 .03343 L
.80303 .03139 L
.79536 .02381 L
s
.97619 .34802 m
.96947 .34127 L
.96657 .33835 L
.95991 .33165 L
.95695 .32868 L
.95034 .32203 L
.94733 .31901 L
.94078 .31241 L
.93771 .30933 L
.93121 .30279 L
.92809 .29965 L
.92165 .29317 L
.91847 .28997 L
.91209 .28355 L
.90885 .28029 L
.90254 .27393 L
.89923 .2706 L
.89299 .26431 L
.88961 .26091 L
.88344 .25469 L
.87999 .25122 L
.8739 .24507 L
.87037 .24152 L
.86436 .23545 L
.86075 .23182 L
.85482 .22583 L
.85113 .22211 L
.84529 .21621 L
.84151 .2124 L
.83576 .20659 L
.83189 .20268 L
.82624 .19697 L
.82227 .19296 L
.81673 .18735 L
.81265 .18323 L
.80722 .17773 L
.80303 .1735 L
.79772 .16811 L
.79341 .16375 L
.78822 .15849 L
.78379 .154 L
.77874 .14887 L
.77417 .14424 L
.76926 .13925 L
.76455 .13447 L
.75979 .12963 L
.75493 .12469 L
.75034 .12001 L
.74531 .11489 L
.7409 .11039 L
Mistroke
.73569 .10508 L
.73147 .10077 L
.72607 .09526 L
.72206 .09115 L
.71645 .08541 L
.71267 .08153 L
.70683 .07555 L
.7033 .07191 L
.69721 .06566 L
.69395 .06229 L
.68759 .05574 L
.68463 .05267 L
.67797 .04579 L
.67533 .04305 L
.66835 .0358 L
.66608 .03343 L
.65873 .02577 L
.65686 .02381 L
Mfstroke
.34314 .02381 m
.35089 .03194 L
.3523 .03343 L
.36051 .04209 L
.36141 .04305 L
.37013 .05232 L
.37046 .05267 L
.37941 .06229 L
.37975 .06265 L
.38827 .07191 L
.38937 .07311 L
.397 .08153 L
.39899 .08373 L
.40558 .09115 L
.40861 .09456 L
.41398 .10077 L
.41823 .1057 L
.42214 .11039 L
.42785 .11727 L
.43003 .12001 L
.43747 .12948 L
.43758 .12963 L
.44464 .13925 L
.44709 .14271 L
.45114 .14887 L
.45671 .15785 L
.45707 .15849 L
.46218 .16811 L
.46633 .17713 L
.46657 .17773 L
.47006 .18735 L
.47278 .19697 L
.47472 .20659 L
.47586 .21621 L
.47595 .21742 L
.47618 .22583 L
.47595 .23089 L
.4755 .23545 L
.47441 .24507 L
.46633 .25199 L
.45671 .25201 L
.44709 .24788 L
.44234 .24507 L
.43747 .24189 L
.42838 .23545 L
.42785 .23485 L
.41823 .22717 L
.41655 .22583 L
.40861 .21907 L
.40522 .21621 L
Mistroke
.39899 .21067 L
.39434 .20659 L
.38937 .20205 L
.38373 .19697 L
.37975 .19327 L
.3733 .18735 L
.37013 .18436 L
.36301 .17773 L
.36051 .17535 L
.35281 .16811 L
.35089 .16626 L
.3427 .15849 L
.34127 .15711 L
.33265 .14887 L
.33165 .1479 L
.32265 .13925 L
.32203 .13865 L
.31269 .12963 L
.31241 .12936 L
.30279 .12004 L
.30276 .12001 L
.29317 .11068 L
.29287 .11039 L
.28355 .10131 L
.28299 .10077 L
.27393 .09191 L
.27315 .09115 L
.26431 .0825 L
.26332 .08153 L
.25469 .07307 L
.2535 .07191 L
.24507 .06362 L
.24371 .06229 L
.23545 .05417 L
.23392 .05267 L
.22583 .0447 L
.22415 .04305 L
.21621 .03522 L
.21439 .03343 L
.20659 .02573 L
.20464 .02381 L
Mfstroke
.02381 .14364 m
.02909 .14887 L
.03343 .15321 L
.03874 .15849 L
.04305 .16278 L
.04841 .16811 L
.05267 .17234 L
.05808 .17773 L
.06229 .18191 L
.06776 .18735 L
.07191 .19147 L
.07744 .19697 L
.08153 .20103 L
.08712 .20659 L
.09115 .21058 L
.09681 .21621 L
.10077 .22014 L
.1065 .22583 L
.11039 .22969 L
.11619 .23545 L
.12001 .23923 L
.12589 .24507 L
.12963 .24878 L
.13559 .25469 L
.13925 .25831 L
.1453 .26431 L
.14887 .26785 L
.15501 .27393 L
.15849 .27738 L
.16472 .28355 L
.16811 .2869 L
.17444 .29317 L
.17773 .29642 L
.18417 .30279 L
.18735 .30593 L
.1939 .31241 L
.19697 .31543 L
.20365 .32203 L
.20659 .32493 L
.2134 .33165 L
.21621 .33442 L
.22316 .34127 L
.22583 .3439 L
.23293 .35089 L
.23545 .35337 L
.24271 .36051 L
.24507 .36282 L
.2525 .37013 L
.25469 .37227 L
.26231 .37975 L
Mistroke
.26431 .3817 L
.27214 .38937 L
.27393 .39111 L
.28199 .39899 L
.28355 .40051 L
.29186 .40861 L
.29317 .40988 L
.30175 .41823 L
.30279 .41924 L
.31168 .42785 L
.31241 .42856 L
.32164 .43747 L
.32203 .43785 L
.33164 .44709 L
.33165 .4471 L
.34127 .45631 L
.34169 .45671 L
.35089 .46546 L
.35179 .46633 L
.36051 .47455 L
.36197 .47595 L
.37013 .48356 L
.37225 .48557 L
.37975 .49247 L
.38266 .49519 L
.38937 .50125 L
.39324 .50481 L
.39899 .50987 L
.40408 .51443 L
.40861 .51827 L
.41533 .52405 L
.41823 .52637 L
.42733 .53367 L
.42785 .53404 L
.43747 .54108 L
.4408 .54329 L
.44709 .54708 L
.45671 .5512 L
.46633 .55117 L
.4744 .54329 L
.47562 .53367 L
.47595 .53009 L
.47619 .52405 L
.47595 .51663 L
.47578 .51443 L
.47456 .50481 L
.47254 .49519 L
.46974 .48557 L
.46633 .47633 L
.46617 .47595 L
Mistroke
.46169 .46633 L
.45671 .45705 L
.45651 .45671 L
.4505 .44709 L
.44709 .44191 L
.44393 .43747 L
.43747 .42868 L
.43683 .42785 L
.42925 .41823 L
.42785 .41647 L
.42133 .40861 L
.41823 .4049 L
.41313 .39899 L
.40861 .39376 L
.40471 .38937 L
.39899 .38292 L
.39612 .37975 L
.38937 .3723 L
.38737 .37013 L
.37975 .36185 L
.3785 .36051 L
.37013 .35152 L
.36954 .35089 L
.36051 .34129 L
.36049 .34127 L
.35138 .33165 L
.35089 .33113 L
.3422 .32203 L
.34127 .32105 L
.33298 .31241 L
.33165 .31101 L
.32372 .30279 L
.32203 .30103 L
.31443 .29317 L
.31241 .29108 L
.3051 .28355 L
.30279 .28116 L
.29575 .27393 L
.29317 .27127 L
.28638 .26431 L
.28355 .26141 L
.27698 .25469 L
.27393 .25156 L
.26757 .24507 L
.26431 .24174 L
.25814 .23545 L
.25469 .23193 L
.2487 .22583 L
.24507 .22213 L
.23924 .21621 L
Mistroke
.23545 .21235 L
.22978 .20659 L
.22583 .20258 L
.2203 .19697 L
.21621 .19282 L
.21081 .18735 L
.20659 .18307 L
.20132 .17773 L
.19697 .17332 L
.19181 .16811 L
.18735 .16359 L
.18231 .15849 L
.17773 .15386 L
.17279 .14887 L
.16811 .14414 L
.16327 .13925 L
.15849 .13442 L
.15374 .12963 L
.14887 .12471 L
.14421 .12001 L
.13925 .115 L
.13467 .11039 L
.12963 .1053 L
.12513 .10077 L
.12001 .0956 L
.11559 .09115 L
.11039 .08591 L
.10604 .08153 L
.10077 .07622 L
.09649 .07191 L
.09115 .06653 L
.08693 .06229 L
.08153 .05685 L
.07737 .05267 L
.07191 .04717 L
.06781 .04305 L
.06229 .03749 L
.05825 .03343 L
.05267 .02782 L
.04869 .02381 L
Mfstroke
0 .251 0 r
.02381 .44069 m
.03029 .44709 L
.03343 .45021 L
.03999 .45671 L
.04305 .45974 L
.04971 .46633 L
.05267 .46925 L
.05944 .47595 L
.06229 .47877 L
.06917 .48557 L
.07191 .48828 L
.0789 .49519 L
.08153 .49778 L
.08865 .50481 L
.09115 .50728 L
.09839 .51443 L
.10077 .51677 L
.10815 .52405 L
.11039 .52626 L
.11791 .53367 L
.12001 .53574 L
.12768 .54329 L
.12963 .54521 L
.13746 .55291 L
.13925 .55467 L
.14724 .56253 L
.14887 .56413 L
.15704 .57215 L
.15849 .57357 L
.16685 .58177 L
.16811 .58301 L
.17666 .59139 L
.17773 .59243 L
.1865 .60101 L
.18735 .60184 L
.19634 .61063 L
.19697 .61124 L
.2062 .62025 L
.20659 .62063 L
.21608 .62987 L
.21621 .62999 L
.22583 .63934 L
.22598 .63949 L
.23545 .64867 L
.2359 .64911 L
.24507 .65798 L
.24584 .65873 L
.25469 .66727 L
.25581 .66835 L
.26431 .67652 L
Mistroke
.26581 .67797 L
.27393 .68575 L
.27585 .68759 L
.28355 .69493 L
.28593 .69721 L
.29317 .70408 L
.29605 .70683 L
.30279 .71318 L
.30624 .71645 L
.31241 .72222 L
.3165 .72607 L
.32203 .7312 L
.32684 .73569 L
.33165 .74011 L
.33729 .74531 L
.34127 .74892 L
.34787 .75493 L
.35089 .75762 L
.35863 .76455 L
.36051 .76619 L
.36963 .77417 L
.37013 .7746 L
.37975 .7828 L
.38087 .78379 L
.38937 .79073 L
.39255 .79341 L
.39899 .7983 L
.40512 .80303 L
.40861 .80537 L
.41823 .81173 L
.41977 .81265 L
.42785 .81701 L
.43747 .82041 L
.44709 .81986 L
.45387 .81265 L
.45485 .80303 L
.45425 .79341 L
.45238 .78379 L
.4495 .77417 L
.44709 .76753 L
.44577 .76455 L
.44125 .75493 L
.43747 .74774 L
.43607 .74531 L
.43026 .73569 L
.42785 .7319 L
.42392 .72607 L
.41823 .71794 L
.41714 .71645 L
.40995 .70683 L
Mistroke
.40861 .70507 L
.40243 .69721 L
.39899 .6929 L
.39464 .68759 L
.38937 .68123 L
.38661 .67797 L
.37975 .66992 L
.37839 .66835 L
.37013 .65888 L
.37 .65873 L
.36146 .64911 L
.36051 .64804 L
.3528 .63949 L
.35089 .63737 L
.34404 .62987 L
.34127 .62684 L
.3352 .62025 L
.33165 .61641 L
.32627 .61063 L
.32203 .60607 L
.31728 .60101 L
.31241 .59581 L
.30824 .59139 L
.30279 .58561 L
.29914 .58177 L
.29317 .57547 L
.29 .57215 L
.28355 .56538 L
.28082 .56253 L
.27393 .55533 L
.27161 .55291 L
.26431 .54531 L
.26236 .54329 L
.25469 .53533 L
.25309 .53367 L
.24507 .52537 L
.24379 .52405 L
.23545 .51544 L
.23447 .51443 L
.22583 .50553 L
.22513 .50481 L
.21621 .49564 L
.21577 .49519 L
.20659 .48577 L
.2064 .48557 L
.19701 .47595 L
.19697 .47591 L
.1876 .46633 L
.18735 .46607 L
.17819 .45671 L
Mistroke
.17773 .45624 L
.16876 .44709 L
.16811 .44643 L
.15932 .43747 L
.15849 .43662 L
.14987 .42785 L
.14887 .42683 L
.14041 .41823 L
.13925 .41704 L
.13095 .40861 L
.12963 .40727 L
.12148 .39899 L
.12001 .3975 L
.112 .38937 L
.11039 .38774 L
.10251 .37975 L
.10077 .37798 L
.09302 .37013 L
.09115 .36824 L
.08352 .36051 L
.08153 .35849 L
.07401 .35089 L
.07191 .34876 L
.0645 .34127 L
.06229 .33903 L
.05499 .33165 L
.05267 .3293 L
.04547 .32203 L
.04305 .31958 L
.03595 .31241 L
.03343 .30986 L
.02644 .30279 L
.02381 .30015 L
Mfstroke
.97619 .94427 m
.96969 .93771 L
.96657 .93456 L
.96017 .92809 L
.95695 .92484 L
.95065 .91847 L
.94733 .91512 L
.94113 .90885 L
.93771 .90539 L
.93162 .89923 L
.92809 .89566 L
.92212 .88961 L
.91847 .88592 L
.91261 .87999 L
.90885 .87618 L
.90312 .87037 L
.89923 .86643 L
.89363 .86075 L
.88961 .85668 L
.88414 .85113 L
.87999 .84692 L
.87467 .84151 L
.87037 .83715 L
.8652 .83189 L
.86075 .82737 L
.85574 .82227 L
.85113 .81759 L
.84628 .81265 L
.84151 .80779 L
.83684 .80303 L
.83189 .79799 L
.8274 .79341 L
.82227 .78817 L
.81798 .78379 L
.81265 .77835 L
.80857 .77417 L
.80303 .76851 L
.79917 .76455 L
.79341 .75865 L
.78979 .75493 L
.78379 .74878 L
.78042 .74531 L
.77417 .73889 L
.77107 .73569 L
.76455 .72898 L
.76174 .72607 L
.75493 .71905 L
.75243 .71645 L
.74531 .70909 L
.74314 .70683 L
Mistroke
.73569 .6991 L
.73387 .69721 L
.72607 .68909 L
.72464 .68759 L
.71645 .67903 L
.71544 .67797 L
.70683 .66894 L
.70627 .66835 L
.69721 .6588 L
.69715 .65873 L
.68807 .64911 L
.68759 .6486 L
.67905 .63949 L
.67797 .63834 L
.67008 .62987 L
.66835 .62801 L
.66119 .62025 L
.65873 .61758 L
.65238 .61063 L
.64911 .60705 L
.64366 .60101 L
.63949 .59638 L
.63505 .59139 L
.62987 .58554 L
.62657 .58177 L
.62025 .5745 L
.61824 .57215 L
.61063 .56318 L
.61009 .56253 L
.60215 .55291 L
.60101 .55151 L
.59447 .54329 L
.59139 .53936 L
.58709 .53367 L
.58177 .52647 L
.58005 .52405 L
.57343 .51443 L
.57215 .51251 L
.56731 .50481 L
.56253 .49664 L
.56174 .49519 L
.55682 .48557 L
.55291 .47671 L
.55262 .47595 L
.54922 .46633 L
.54673 .45671 L
.54533 .44709 L
.54536 .43747 L
.54914 .42785 L
.55291 .42463 L
Mistroke
.56253 .42401 L
.57215 .42743 L
.57341 .42785 L
.58177 .43267 L
.58974 .43747 L
.59139 .43905 L
.60101 .44613 L
.60231 .44709 L
.61063 .45369 L
.61443 .45671 L
.62025 .46162 L
.6259 .46633 L
.62987 .46981 L
.63697 .47595 L
.63949 .47822 L
.64778 .48557 L
.64911 .48679 L
.6584 .49519 L
.65873 .4955 L
.66835 .50431 L
.66889 .50481 L
.67797 .51322 L
.67928 .51443 L
.68759 .52219 L
.68958 .52405 L
.69721 .53124 L
.6998 .53367 L
.70683 .54034 L
.70995 .54329 L
.71645 .54948 L
.72006 .55291 L
.72607 .55867 L
.73011 .56253 L
.73569 .56789 L
.74013 .57215 L
.74531 .57715 L
.75011 .58177 L
.75493 .58643 L
.76007 .59139 L
.76455 .59574 L
.77 .60101 L
.77417 .60507 L
.7799 .61063 L
.78379 .61442 L
.78979 .62025 L
.79341 .62379 L
.79966 .62987 L
.80303 .63317 L
.80951 .63949 L
.81265 .64257 L
Mistroke
.81934 .64911 L
.82227 .65198 L
.82916 .65873 L
.83189 .66141 L
.83897 .66835 L
.84151 .67084 L
.84877 .67797 L
.85113 .68029 L
.85856 .68759 L
.86075 .68974 L
.86834 .69721 L
.87037 .69921 L
.87812 .70683 L
.87999 .70868 L
.88788 .71645 L
.88961 .71816 L
.89764 .72607 L
.89923 .72765 L
.90739 .73569 L
.90885 .73714 L
.91713 .74531 L
.91847 .74664 L
.92687 .75493 L
.92809 .75614 L
.9366 .76455 L
.93771 .76565 L
.94633 .77417 L
.94733 .77516 L
.95605 .78379 L
.95695 .78468 L
.96577 .79341 L
.96657 .7942 L
.97547 .80303 L
.97619 .80373 L
Mfstroke
.97619 .64507 m
.97066 .63949 L
.96657 .63536 L
.96114 .62987 L
.95695 .62564 L
.95162 .62025 L
.94733 .61592 L
.9421 .61063 L
.93771 .60619 L
.93259 .60101 L
.92809 .59646 L
.92308 .59139 L
.91847 .58672 L
.91358 .58177 L
.90885 .57698 L
.90408 .57215 L
.89923 .56723 L
.89459 .56253 L
.88961 .55748 L
.88511 .55291 L
.87999 .54772 L
.87563 .54329 L
.87037 .53795 L
.86616 .53367 L
.86075 .52817 L
.8567 .52405 L
.85113 .51839 L
.84724 .51443 L
.84151 .5086 L
.8378 .50481 L
.83189 .49879 L
.82836 .49519 L
.82227 .48897 L
.81894 .48557 L
.81265 .47915 L
.80953 .47595 L
.80303 .46931 L
.80013 .46633 L
.79341 .45945 L
.79074 .45671 L
.78379 .44958 L
.78137 .44709 L
.77417 .43969 L
.77202 .43747 L
.76455 .42978 L
.76269 .42785 L
.75493 .41985 L
.75337 .41823 L
.74531 .40989 L
.74408 .40861 L
Mistroke
.73569 .3999 L
.73481 .39899 L
.72607 .38989 L
.72558 .38937 L
.71645 .37983 L
.71637 .37975 L
.7072 .37013 L
.70683 .36974 L
.69807 .36051 L
.69721 .3596 L
.68899 .35089 L
.68759 .3494 L
.67996 .34127 L
.67797 .33915 L
.67099 .33165 L
.66835 .32881 L
.66209 .32203 L
.65873 .31838 L
.65327 .31241 L
.64911 .30785 L
.64455 .30279 L
.63949 .29718 L
.63592 .29317 L
.62987 .28634 L
.62743 .28355 L
.62025 .2753 L
.61908 .27393 L
.61091 .26431 L
.61063 .26398 L
.60295 .25469 L
.60101 .25232 L
.59524 .24507 L
.59139 .24016 L
.58782 .23545 L
.58177 .22727 L
.58075 .22583 L
.57409 .21621 L
.57215 .21332 L
.56791 .20659 L
.56253 .19743 L
.56228 .19697 L
.55729 .18735 L
.55301 .17773 L
.55291 .17752 L
.54953 .16811 L
.54694 .15849 L
.54542 .14887 L
.54528 .13925 L
.54666 .12963 L
.55291 .1254 L
Mistroke
.56253 .1248 L
.57215 .12822 L
.57497 .12963 L
.58177 .13347 L
.59087 .13925 L
.59139 .13985 L
.60101 .14693 L
.60363 .14887 L
.61063 .15449 L
.61564 .15849 L
.62025 .16242 L
.62704 .16811 L
.62987 .17061 L
.63806 .17773 L
.63949 .17902 L
.64884 .18735 L
.64911 .1876 L
.65873 .1963 L
.65947 .19697 L
.66835 .20511 L
.66996 .20659 L
.67797 .21402 L
.68034 .21621 L
.68759 .22299 L
.69063 .22583 L
.69721 .23204 L
.70084 .23545 L
.70683 .24114 L
.71099 .24507 L
.71645 .25028 L
.72108 .25469 L
.72607 .25947 L
.73114 .26431 L
.73569 .26869 L
.74115 .27393 L
.74531 .27795 L
.75113 .28355 L
.75493 .28723 L
.76108 .29317 L
.76455 .29654 L
.77101 .30279 L
.77417 .30587 L
.78091 .31241 L
.78379 .31522 L
.79079 .32203 L
.79341 .32459 L
.80066 .33165 L
.80303 .33397 L
.81051 .34127 L
.81265 .34337 L
Mistroke
.82034 .35089 L
.82227 .35278 L
.83016 .36051 L
.83189 .36221 L
.83997 .37013 L
.84151 .37164 L
.84977 .37975 L
.85113 .38109 L
.85956 .38937 L
.86075 .39055 L
.86934 .39899 L
.87037 .40001 L
.87911 .40861 L
.87999 .40948 L
.88887 .41823 L
.88961 .41896 L
.89863 .42785 L
.89923 .42845 L
.90838 .43747 L
.90885 .43794 L
.91812 .44709 L
.91847 .44744 L
.92786 .45671 L
.92809 .45694 L
.93759 .46633 L
.93771 .46645 L
.94732 .47595 L
.94733 .47596 L
.95695 .48548 L
.95704 .48557 L
.96657 .495 L
.96676 .49519 L
.97619 .50453 L
Mfstroke
.84778 .97619 m
.84151 .97004 L
.83798 .96657 L
.83189 .96061 L
.82817 .95695 L
.82227 .95118 L
.81834 .94733 L
.81265 .94177 L
.8085 .93771 L
.80303 .93237 L
.79865 .92809 L
.79341 .92299 L
.78878 .91847 L
.78379 .91362 L
.7789 .90885 L
.77417 .90427 L
.76899 .89923 L
.76455 .89494 L
.75906 .88961 L
.75493 .88563 L
.7491 .87999 L
.74531 .87635 L
.73911 .87037 L
.73569 .86709 L
.72909 .86075 L
.72607 .85787 L
.71903 .85113 L
.71645 .84868 L
.70892 .84151 L
.70683 .83954 L
.69876 .83189 L
.69721 .83044 L
.68853 .82227 L
.68759 .8214 L
.67822 .81265 L
.67797 .81242 L
.66835 .80351 L
.66784 .80303 L
.65873 .7947 L
.65734 .79341 L
.64911 .78599 L
.6467 .78379 L
.63949 .77742 L
.63586 .77417 L
.62987 .76901 L
.62474 .76455 L
.62025 .76082 L
.61321 .75493 L
.61063 .75289 L
.60101 .74533 L
Mistroke
.60099 .74531 L
.59139 .73824 L
.58836 .73569 L
.58177 .73188 L
.57215 .72662 L
.57092 .72607 L
.56253 .72322 L
.55291 .72387 L
.55 .72607 L
.54546 .73569 L
.54526 .74531 L
.54653 .75493 L
.54892 .76455 L
.55224 .77417 L
.55291 .77595 L
.55636 .78379 L
.56121 .79341 L
.56253 .79585 L
.56672 .80303 L
.57215 .8117 L
.57278 .81265 L
.57936 .82227 L
.58177 .82568 L
.58635 .83189 L
.59139 .83855 L
.5937 .84151 L
.60101 .85071 L
.60135 .85113 L
.60927 .86075 L
.61063 .86238 L
.61741 .87037 L
.62025 .8737 L
.62572 .87999 L
.62987 .88474 L
.63418 .88961 L
.63949 .89558 L
.64278 .89923 L
.64911 .90625 L
.65149 .90885 L
.65873 .91678 L
.66029 .91847 L
.66835 .92721 L
.66917 .92809 L
.67797 .93754 L
.67813 .93771 L
.68715 .94733 L
.68759 .9478 L
.69622 .95695 L
.69721 .958 L
.70534 .96657 L
Mistroke
.70683 .96813 L
.7145 .97619 L
Mfstroke
.02381 .59935 m
.02547 .60101 L
.03343 .60906 L
.03498 .61063 L
.04305 .61878 L
.0445 .62025 L
.05267 .6285 L
.05402 .62987 L
.06229 .63823 L
.06354 .63949 L
.07191 .64796 L
.07305 .64911 L
.08153 .65769 L
.08255 .65873 L
.09115 .66744 L
.09205 .66835 L
.10077 .67718 L
.10154 .67797 L
.11039 .68694 L
.11103 .68759 L
.12001 .6967 L
.12051 .69721 L
.12963 .70647 L
.12999 .70683 L
.13925 .71624 L
.13945 .71645 L
.14887 .72603 L
.14891 .72607 L
.15836 .73569 L
.15849 .73582 L
.1678 .74531 L
.16811 .74563 L
.17723 .75493 L
.17773 .75544 L
.18664 .76455 L
.18735 .76527 L
.19605 .77417 L
.19697 .77511 L
.20544 .78379 L
.20659 .78497 L
.21482 .79341 L
.21621 .79484 L
.22418 .80303 L
.22583 .80473 L
.23352 .81265 L
.23545 .81464 L
.24284 .82227 L
.24507 .82457 L
.25214 .83189 L
.25469 .83453 L
Mistroke
.26142 .84151 L
.26431 .84451 L
.27067 .85113 L
.27393 .85453 L
.27988 .86075 L
.28355 .86458 L
.28907 .87037 L
.29317 .87467 L
.29821 .87999 L
.30279 .88481 L
.30731 .88961 L
.31241 .89501 L
.31637 .89923 L
.32203 .90527 L
.32536 .90885 L
.33165 .91561 L
.33429 .91847 L
.34127 .92604 L
.34315 .92809 L
.35089 .93657 L
.35192 .93771 L
.36051 .94724 L
.36059 .94733 L
.36913 .95695 L
.37013 .95808 L
.37754 .96657 L
.37975 .96913 L
.38578 .97619 L
Mfstroke
.02381 .73989 m
.0293 .74531 L
.03343 .74941 L
.039 .75493 L
.04305 .75894 L
.04872 .76455 L
.05267 .76845 L
.05845 .77417 L
.06229 .77797 L
.06818 .78379 L
.07191 .78748 L
.07791 .79341 L
.08153 .79698 L
.08765 .80303 L
.09115 .80648 L
.0974 .81265 L
.10077 .81597 L
.10715 .82227 L
.11039 .82546 L
.11691 .83189 L
.12001 .83494 L
.12668 .84151 L
.12963 .84441 L
.13646 .85113 L
.13925 .85387 L
.14624 .86075 L
.14887 .86333 L
.15604 .87037 L
.15849 .87277 L
.16585 .87999 L
.16811 .88221 L
.17566 .88961 L
.17773 .89163 L
.18549 .89923 L
.18735 .90104 L
.19534 .90885 L
.19697 .91044 L
.2052 .91847 L
.20659 .91983 L
.21507 .92809 L
.21621 .92919 L
.22497 .93771 L
.22583 .93854 L
.23489 .94733 L
.23545 .94787 L
.24483 .95695 L
.24507 .95718 L
.25469 .96646 L
.2548 .96657 L
.26431 .97571 L
Mistroke
.2648 .97619 L
Mfstroke
.02381 .89855 m
.02449 .89923 L
.03343 .90826 L
.03401 .90885 L
.04305 .91798 L
.04354 .91847 L
.05267 .9277 L
.05306 .92809 L
.06229 .93743 L
.06257 .93771 L
.07191 .94716 L
.07208 .94733 L
.08153 .95689 L
.08159 .95695 L
.09109 .96657 L
.09115 .96664 L
.10058 .97619 L
s
.97619 .04667 m
.97259 .04305 L
.96657 .03696 L
.96308 .03343 L
.95695 .02724 L
.95356 .02381 L
s
.97619 .20533 m
.96774 .19697 L
.96657 .1958 L
.95803 .18735 L
.95695 .18628 L
.94831 .17773 L
.94733 .17676 L
.93858 .16811 L
.93771 .16725 L
.92885 .15849 L
.92809 .15774 L
.91911 .14887 L
.91847 .14824 L
.90937 .13925 L
.90885 .13874 L
.89962 .12963 L
.89923 .12925 L
.88986 .12001 L
.88961 .11976 L
.8801 .11039 L
.87999 .11028 L
.87037 .10081 L
.87033 .10077 L
.86075 .09135 L
.86055 .09115 L
.85113 .08189 L
.85076 .08153 L
.84151 .07245 L
.84097 .07191 L
.83189 .06301 L
.83116 .06229 L
.82227 .05359 L
.82134 .05267 L
.81265 .04417 L
.8115 .04305 L
.80303 .03477 L
.80166 .03343 L
.79341 .0254 L
.79179 .02381 L
s
.97619 .34587 m
.97163 .34127 L
.96657 .33616 L
.96211 .33165 L
.95695 .32644 L
.95259 .32203 L
.94733 .31672 L
.94307 .31241 L
.93771 .30699 L
.93356 .30279 L
.92809 .29726 L
.92405 .29317 L
.91847 .28752 L
.91455 .28355 L
.90885 .27778 L
.90505 .27393 L
.89923 .26803 L
.89556 .26431 L
.88961 .25828 L
.88607 .25469 L
.87999 .24852 L
.8766 .24507 L
.87037 .23875 L
.86712 .23545 L
.86075 .22897 L
.85766 .22583 L
.85113 .21919 L
.84821 .21621 L
.84151 .2094 L
.83876 .20659 L
.83189 .19959 L
.82932 .19697 L
.82227 .18977 L
.8199 .18735 L
.81265 .17995 L
.81049 .17773 L
.80303 .17011 L
.80108 .16811 L
.79341 .16025 L
.7917 .15849 L
.78379 .15038 L
.78232 .14887 L
.77417 .14049 L
.77297 .13925 L
.76455 .13058 L
.76363 .12963 L
.75493 .12065 L
.75432 .12001 L
.74531 .11069 L
.74502 .11039 L
Mistroke
.73575 .10077 L
.73569 .1007 L
.72651 .09115 L
.72607 .09069 L
.71731 .08153 L
.71645 .08064 L
.70813 .07191 L
.70683 .07054 L
.699 .06229 L
.69721 .0604 L
.68992 .05267 L
.68759 .05021 L
.68088 .04305 L
.67797 .03995 L
.6719 .03343 L
.66835 .0296 L
.663 .02381 L
Mfstroke
.337 .02381 m
.34127 .02846 L
.34583 .03343 L
.35089 .03897 L
.35457 .04305 L
.36051 .04964 L
.3632 .05267 L
.37013 .06048 L
.37171 .06229 L
.37975 .07152 L
.38008 .07191 L
.38827 .08153 L
.38937 .08283 L
.39625 .09115 L
.39899 .0945 L
.40399 .10077 L
.40861 .10666 L
.41144 .11039 L
.41823 .11955 L
.41856 .12001 L
.42526 .12963 L
.42785 .1335 L
.43148 .13925 L
.43718 .14887 L
.43747 .14938 L
.44223 .15849 L
.44659 .16811 L
.44709 .16919 L
.45016 .17773 L
.45285 .18735 L
.45449 .19697 L
.45478 .20659 L
.45353 .21621 L
.44709 .22145 L
.43747 .22202 L
.42785 .2186 L
.4232 .21621 L
.41823 .21334 L
.40861 .20696 L
.40805 .20659 L
.39899 .19989 L
.39506 .19697 L
.38937 .19233 L
.38317 .18735 L
.37975 .1844 L
.37184 .17773 L
.37013 .1762 L
.36086 .16811 L
.36051 .16779 L
.35089 .15922 L
Mistroke
.35007 .15849 L
.34127 .15052 L
.33945 .14887 L
.33165 .14171 L
.32897 .13925 L
.32203 .1328 L
.3186 .12963 L
.31241 .12382 L
.30833 .12001 L
.30279 .11478 L
.29812 .11039 L
.29317 .10568 L
.28798 .10077 L
.28355 .09654 L
.27789 .09115 L
.27393 .08735 L
.26784 .08153 L
.26431 .07813 L
.25783 .07191 L
.25469 .06887 L
.24786 .06229 L
.24507 .05959 L
.23791 .05267 L
.23545 .05028 L
.22799 .04305 L
.22583 .04095 L
.21809 .03343 L
.21621 .03159 L
.20821 .02381 L
Mfstroke
.02381 .14149 m
.03127 .14887 L
.03343 .15101 L
.04098 .15849 L
.04305 .16054 L
.0507 .16811 L
.05267 .17005 L
.06043 .17773 L
.06229 .17957 L
.07016 .18735 L
.07191 .18908 L
.0799 .19697 L
.08153 .19858 L
.08964 .20659 L
.09115 .20808 L
.09939 .21621 L
.10077 .21757 L
.10914 .22583 L
.11039 .22706 L
.11891 .23545 L
.12001 .23654 L
.12868 .24507 L
.12963 .24601 L
.13845 .25469 L
.13925 .25547 L
.14824 .26431 L
.14887 .26493 L
.15804 .27393 L
.15849 .27437 L
.16785 .28355 L
.16811 .28381 L
.17767 .29317 L
.17773 .29323 L
.18735 .30264 L
.1875 .30279 L
.19697 .31204 L
.19734 .31241 L
.20659 .32143 L
.20721 .32203 L
.21621 .3308 L
.21708 .33165 L
.22583 .34015 L
.22698 .34127 L
.23545 .34948 L
.2369 .35089 L
.24507 .35879 L
.24685 .36051 L
.25469 .36807 L
.25682 .37013 L
.26431 .37732 L
Mistroke
.26682 .37975 L
.27393 .38655 L
.27687 .38937 L
.28355 .39574 L
.28695 .39899 L
.29317 .40488 L
.29709 .40861 L
.30279 .41398 L
.30728 .41823 L
.31241 .42302 L
.31755 .42785 L
.32203 .432 L
.3279 .43747 L
.33165 .44091 L
.33837 .44709 L
.34127 .44972 L
.34897 .45671 L
.35089 .45842 L
.35975 .46633 L
.36051 .46699 L
.37013 .4754 L
.37074 .47595 L
.37975 .4836 L
.38201 .48557 L
.38937 .49153 L
.39379 .49519 L
.39899 .4991 L
.40657 .50481 L
.40861 .50616 L
.41823 .51254 L
.42145 .51443 L
.42785 .51781 L
.43747 .52122 L
.44709 .52067 L
.45371 .51443 L
.45482 .50481 L
.45437 .49519 L
.45262 .48557 L
.44983 .47595 L
.44709 .46834 L
.44618 .46633 L
.44175 .45671 L
.43747 .44855 L
.43663 .44709 L
.43087 .43747 L
.42785 .4327 L
.42459 .42785 L
.41823 .41875 L
.41785 .41823 L
.4107 .40861 L
Mistroke
.40861 .40587 L
.40321 .39899 L
.39899 .3937 L
.39545 .38937 L
.38937 .38203 L
.38744 .37975 L
.37975 .37072 L
.37924 .37013 L
.37086 .36051 L
.37013 .35968 L
.36233 .35089 L
.36051 .34884 L
.35369 .34127 L
.35089 .33817 L
.34494 .33165 L
.34127 .32764 L
.3361 .32203 L
.33165 .31721 L
.32718 .31241 L
.32203 .30687 L
.3182 .30279 L
.31241 .29661 L
.30916 .29317 L
.30279 .28642 L
.30007 .28355 L
.29317 .27627 L
.29093 .27393 L
.28355 .26618 L
.28176 .26431 L
.27393 .25613 L
.27255 .25469 L
.26431 .24611 L
.2633 .24507 L
.25469 .23613 L
.25403 .23545 L
.24507 .22617 L
.24474 .22583 L
.23545 .21624 L
.23542 .21621 L
.22608 .20659 L
.22583 .20633 L
.21672 .19697 L
.21621 .19644 L
.20735 .18735 L
.20659 .18657 L
.19796 .17773 L
.19697 .17671 L
.18856 .16811 L
.18735 .16687 L
.17914 .15849 L
Mistroke
.17773 .15704 L
.16972 .14887 L
.16811 .14723 L
.16028 .13925 L
.15849 .13742 L
.15083 .12963 L
.14887 .12763 L
.14138 .12001 L
.13925 .11784 L
.13191 .11039 L
.12963 .10807 L
.12244 .10077 L
.12001 .0983 L
.11296 .09115 L
.11039 .08854 L
.10347 .08153 L
.10077 .07878 L
.09398 .07191 L
.09115 .06904 L
.08448 .06229 L
.08153 .05929 L
.07498 .05267 L
.07191 .04956 L
.06547 .04305 L
.06229 .03983 L
.05596 .03343 L
.05267 .03011 L
.04644 .02381 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  Evaluatable->False,
  ImageSize->{223, 223},
  ImageMargins->{{50, 0}, {0, 2}},
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  FontSize->8,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontTracking->"Plain",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003O0000ga000`40O003h00Oggoo000;Ool50002
Ool2000YOol2001FOol2000WOol50002Ool2000HOol000eoo`05001oogooOol00002Ool00`00Oomo
o`0UOol01000Oomoo`00E7oo00@007ooOol002Qoo`05001oogooOol00002Ool00`00Oomoo`0EOol0
00eoo`05001oogooOol00002Ool00`00Oomoo`0XOol00`00Oomoo`1EOol00`00Oomoo`0VOol01@00
Oomoogoo00000Woo00<007ooOol05Goo0005Ool40004Ool01@00Oomoogoo00000Woo00<007ooOol0
7goo10000goo0P00EWoo0P00:Goo00D007ooOomoo`00009oo`03001oogoo01Eoo`003Goo00D007oo
Oomoo`00009oo`03001oogoo02Ioo`03001oogoo05Eoo`03001oogoo02Qoo`05001oogooOol00002
Ool00`00Oomoo`0EOol000aoo`8000Aoo`8002Uoo`<005Eoo`<002Moo`8000Aoo`8001Qoo`00J7oo
00<007ooOol0M7oo001XOol00`00Oomoo`1dOol006Qoo`03001oogoo06Aoo`800003Ool0000000]o
o`00J7oo00<007ooOol0IGoo00<007oo000037oo001XOol00`00Oomoo`1VOol00`00Oomoo`0;Ool0
00Uoo`T000030>1l000001X00003O000h00001L000040>007`00O00h000017`001l07`3P5`0000<0
h00OO0006`0000=l003P000020001Woo0P0000=oo`0000002goo000=Ool00`00Oomoo`03Ool0103P
O01oo`0027oo00<007ooOol01goo00<007ooOol017oo00=l003P0>0027oo00<007ooOol01Woo00<0
07ooOol00goo00@0h00O01ml00Qoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03
001oogoo00Moo`03001oogoo00Ioo`06001oog`0Ool07`3P0goo00<007ooOol01Woo00<007ooOol0
1Woo00@007oo0>007`Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo009oo`05O000h7oo
Ool0000KOol001=oo`030>007g`001]oo`03O000h7oo01Moo`040>007g`0O00IOol00`00Oomoo`0L
Ool00g`001l0h00HOol00`3P01moo`0KOol00g`00>00h00LOol001Aoo`80h003O01oogoo01Uoo`03
O000h03P01Moo`040>007`0OO00HOol00`00Oomoo`0MOol2O0000`3POomoo`0FOol00`3P01moo`0K
Ool00g`001l0h00KOol001Eoo`030>007goo01]oo`03O000h7oo01Ioo`040>1oo`0OO00HOol01000
Oomoog`07Goo00=l000O0>0067oo00<0h00OO0006goo00<07`3POol06Woo000FOol20>000g`0Oomo
o`0IOol00g`00>00h00FOol20>0201l00g`0Oomoo`0DOol01000O01l07oo0W`077oo00Al000O0>00
h1Moo`80h003O01oogoo01Uoo`0301moogoo01Uoo`0067oo00<0h7ooOol06goo00<07`3POol05Woo
00<0h7oo01l05Woo00<007`0Ool00goo00=l07ooOol06goo00<07goo0>005goo00<0h00OO000=Woo
000HOol20>000g`0Oomoo`0JOol00`0O0>1oo`0EOol20>000`0OO01l000DOol00`00O01oo`04Ool0
0g`0Oomoo`0JOol00g`001l0h00HOol20>000g`0Oomoo`0cOol001Yoo`030>1oogoo01]oo`0301l0
h7oo01Ioo`030>007g`001Aoo`03001l07oo00Eoo`03O01oogoo01Yoo`03O0007`3P01Uoo`030>1l
07oo03=oo`006Woo0P3P00=l07ooOol06Goo00=l003P0>005Woo00<0h7oo01l00W`04Woo00<007`0
Ool01Woo00=l07ooOol06Woo00=l000O0>006Goo00<0h7`0Ool0<Woo000LOol00`3PO01oo`0JOol0
0g`001l0h00FOol01@3POol07gooO0004Goo00<007`0Ool01goo00=l07ooOol06Woo00=l000O0>00
6Goo00<0h00OOol0<Goo000LOol00`3P01ml000KOol00g`001l0h00FOol01@3POol07gooO00047oo
00<007`0Ool027oo00=l07ooOol06Woo00=l000O0>0067oo0P3P00=l07ooOol0;goo000MOol20>00
0g`0Oomoo`0IOol00g`001l0h00FOol01@3POol07gooO0003goo00<007`0Ool02Goo00=l07ooOol0
6Woo00=l000O0>006Goo00<0h7ooOol0;goo000NOol00`3P01ml000KOol00g`001l0h00EOol20>02
01l2O00>Ool00`00O01oo`04Ool301l3Ool00g`0Oomoo`0JOol00g`001l0h00HOol00`3P01moo`0_
Ool001moo`80h003O01oogoo01Uoo`03O0007`3P01Ioo`050>1oo`0OOoml000=Ool00`00O01oo`03
Ool01@0OOomoogoo01l00goo00=l07ooOol06Woo00=l000O0>0067oo00<0h00OOol0;Woo000POol0
0`3P01moo`0KOol00g`001l0h00EOol0103POol07goo0W`037oo00<007`0Ool00goo00<07gooOol0
0Woo0P0O0Woo00=l07ooOol06Woo00=l003POol067oo00<0h00OO000;Goo000QOol20>000g`0Oomo
o`0IOol017`001l0h03P57oo00<0h7oo01l00Woo00=l07ooOol02Goo00<007`0Ool00Woo00<07goo
Ool01Goo0P0O00=oog`0O0006goo00=l003P0>0067oo0P3P00<07gooOol0:Woo000SOol00`3POomo
o`0KOol00`0OOol0h00DOol01@3POol07gooO0002goo00<007`0Ool00Woo00<07gooOol01Woo00D0
7gooOomoog`001aoo`030>1oogoo01Qoo`030>007goo02Yoo`008goo0P3P00=l07ooOol06Woo0P0O
00<0h7ooOol04Woo00@0h7oo01moo`9l00Uoo`03001l07oo009oo`0301moogoo00Moo`807`03Ooml
07`001]oo`03O000h03P01Uoo`030>1l07oo02Uoo`009Goo00<0h7ooOol06goo00=l003POol057oo
00D0h7oo01moog`000Uoo`03001l07oo009oo`0301moogoo009oo`<0h0Aoo`0401moogooO00KOol0
0g`001l0h00IOol00`3PO01oo`0XOol002Eoo`80h003O01oogoo01Uoo`04O0007`3P0>0COol00`3P
Ool07`02Ool00g`0Oomoo`06Ool00`00O01oo`02Ool01@0OOomoogoo0>000goo0`3P0Woo00<07goo
O00077oo00=l000O0>006Goo00<0h7`0Ool09goo000WOol00`3PO01oo`0JOol00g`001l0h00DOol0
0`3POol07`02Ool00g`0Oomoo`05Ool00`00O01oo`02Ool01@0OOomoogoo0>001Woo00<0h7ooOol0
0P0O0W`06goo00=l000O0>006Goo00<0h00OOol09Woo000=Ool00`3POomoo`0GOol00`3P01ml000K
Ool017`001l0h03P4Woo00@0h7ooOol07`9oo`03O01oogoo00Aoo`03001l07oo009oo`0501moogoo
Ool0h007Ool20>0017oo01moog`077oo00=l000O0>006Goo00<0h7`0Ool09Goo000=Ool00`0O0>1o
o`0HOol00`3P01ml000KOol017`001moo`3P4Woo00<0h7oo01l00goo00=l07ooOol00goo00<007`0
Ool00Woo00D07gooOomoo`3P00Uoo`80h0807`03O01oogoo01Yoo`03O0007`3P01Uoo`030>1oogoo
02Aoo`003Woo00<07`3POol067oo00<0h00OO0006goo00Al000OOol0h15oo`040>1oogoo01l3Ool0
0g`0Oomoo`02Ool00`00O01oo`02Ool01@0OOomoogoo0>002Woo00D0h7oo01moog`001aoo`03O000
h03P01Qoo`80h2Eoo`003goo00<07`3POol067oo0P3P00=l07ooOol06Goo00Al000O01l0h15oo`04
0>1oogoo01l3Ool01W`0Oomoogoo001l00Aoo`0401moogoo0>0;Ool20>000`0OOoml000LOol00g`0
01l0h00IOol00`3POomoo`0ROol0011oo`80h1Uoo`030>007goo01]oo`04O0007goo0>0@Ool0103P
Oomoo`0O0goo00Il07ooOomoo`00O004Ool0100OOomoo`3P37oo0P3P0P0O00=l07ooOol06Woo00<0
7`3POol067oo00<0h00OO0008Woo000AOol00g`00>1oo`0HOol00`3PO01oo`0KOol00g`001l07`02
0>0?Ool0103POomoo`0O0goo0W`000Aoo`00001l00Aoo`0401moogoo0>0=Ool0103POol07g`077oo
00<07`3POol067oo0P3P00=l07ooOol07goo000AOol00g`00>00h00IOol00`3PO01oo`0KOol017`0
01moo`3P3goo00@0h7ooOol07`Aoo`05O01oo`00Ooml0004Ool0100OOomoo`3P3Woo00@0h00O01ml
01aoo`0301l0h7oo01Qoo`030>007g`0021oo`004Woo0W`000<0h7ooOol05goo0P3P00=l07ooOol0
6Woo0P0O0P3P3Woo00@0h7ooOol07`Aoo`05O00007ooOoml0003Ool0100OOomoo`3P3goo0P3P00<0
7g`0O0006goo00<07`3P0>0067oo0P3P00<07gooOol07Goo000DOol00g`00>1oo`0IOol00`3POomo
o`0KOol017`001moo`3P3Goo00D0h7ooOomoo`0O00=oo`05O00007ooOoml0004Ool0100OOomoo`3P
3goo00D0h7oo01moog`001]oo`03O000h7oo01Uoo`030>007goo01eoo`005Goo00=l003POol067oo
00<0h00OO00077oo0P0O0P3P37oo00D0h7ooOomoo`0O00=oo`03O00007oo009oo`05O01oogooOol0
7`02Ool00`3POomoo`0>Ool20>000`0OO01oo`0KOol00g`00>00h00IOol00`3PO01oo`0LOol001Io
o`030>1oogoo01Qoo`030>007goo01]oo`05O01oo`0OOol0h00<Ool0103POomoo`0O0goo00=l0000
Ool00goo00El07ooOomoo`0O009oo`030>1oogoo00moo`040>007g`0O00KOol00g`00>1oo`0IOol0
0`3P01moo`0KOol001Moo`80h1Uoo`030>007g`001]oo`05O01oo`0OOol0h00;Ool0103POomoo`0O
17oo00=l07ooOol00goo00Ml07ooOomoo`0OOol0h00BOol00`3P01l07`0LOol00g`00>1oo`0IOol0
0`3PO01oo`0JOol001Qoo`0301l0h7oo01Qoo`030>007g`001]oo`05O01oo`0OOol0h00:Ool0103P
Oomoo`0O17oo00=l07ooOol017oo00Al07ooOol07`9oo`030>1oogoo011oo`030>1oo`0O01aoo`03
O000h7oo01Uoo`030>1oogoo01Uoo`006Goo00<07`3POol067oo00<0h00OO0006goo00Al07oo01mo
o`80h0Qoo`040>1oogoo01l4Ool00g`0Oomoo`04Ool01g`0Oomoogoo01moo`3P01=oo`030>007g`0
01aoo`03O000h03P01Qoo`030>1oogoo01Uoo`006Woo00<07`3POol067oo0P3P00=l07ooOol06Goo
00=l07oo01l00Woo0P3P1Goo00<0h7ooOol00Woo00H07gooOomoog`00006Ool2O002Ool00`0OOol0
h00COol00`3P01ml000LOol00g`001l0h00cOol001]oo`0301l0h7oo01Qoo`030>1l07`001]oo`04
O01oo`0O01l2Ool20>03Ool00`3POomoo`02Ool01@0OOomoogooO00027oo00Al07ooOol07`9oo`03
0>1oogoo015oo`030>007g`001aoo`0301l0h03P039oo`0077oo00=l003POol067oo00<0h00OO000
6goo00Al07ooOol07`=oo`<0h0Eoo`0501moogooOoml0009Ool017`0Oomoo`0O0Woo00<0h7ooOol0
4Goo00<0h00OO00077oo0P0O00<0h7ooOol0;goo000MOol00`0O0>1oo`0GOol20>000g`0Oomoo`0J
Ool2O00201l:Ool01@0OOomoogooO0002Woo00Il07ooOol07goo0>0DOol00`3P01ml000LOol00`0O
0>1oo`0`Ool001ioo`03O000h7oo01Qoo`030>007g`001aoo`04O01oo`0O01l8Ool01@0OOomoogoo
O0002goo0W`000Aoo`0OOol0h1Aoo`80h00301ml07oo01Yoo`0301l0h03P02moo`007goo00=l003P
Ool05goo00<0h7oo01l07Goo00Al07ooOol07`Ioo`0301moogoo009oo`03O01oogoo00]oo`05O01o
o`0OOol0h00EOol00`3POoml000LOol00`3POomoo`0]Ool0021oo`03O000h7oo01Moo`80h00301ml
07oo01]oo`04O01oo`0O01l5Ool00`0OOomoo`02Ool00g`0Oomoo`0;Ool01W`0Oomoo`0OOol0h1Eo
o`030>007g`001]oo`0301l0h7oo02eoo`008Goo00<07`3POol067oo00<0h00OOol077oo00Al07oo
Ool07`=oo`0301l007oo00=oo`03O01oogoo00aoo`06O01oogoo01moo`3P5Goo00<0h00OO0006goo
00=l003POol0;7oo000ROol00`0O0>1oo`0HOol00`3P01ml000LOol00g`0Oomoo`0401l00goo001o
o`02Ool00g`0Oomoo`0=Ool01G`0Ool07goo0>005Woo00<0h00OOol06goo00=l003POol0:goo000S
Ool00`0O0>1oo`0HOol00`3P01ml000KOol00g`0Oomoo`05Ool01@00OomoogooO0000P003Woo00El
07oo01moo`3P01Ioo`030>007goo01]oo`03O000h7oo02Yoo`0097oo00<07`3POol067oo00<0h7`0
O0006goo00=l07ooOol00Woo0P0017oo00=l07ooOol03goo00El07oo01moo`3P01Ioo`030>007goo
01]oo`03O000h7oo02Uoo`009Goo00<07`3POol067oo00<0h00OO0006goo00El07ooOomoo`0000Eo
o`03O01oogoo011oo`05O01oo`0OOol0h00EOol00`3P01ml000LOol00g`00>1oo`0XOol002Ioo`03
01l0h7oo01Moo`80h09l01]oo`9l0004Ool000000003Ool00g`0Oomoo`0AOol017`0Ool07`3P5Woo
00<0h00OO00077oo00<07`3P0>009goo000WOol00g`00>1oo`0HOol00`3P01ml000LOol00g`0Oomo
o`04Ool00g`0Oomoo`0BOol2O0000`0O0>1oo`0EOol00`3P01ml000LOol201l00`3POomoo`0TOol0
02Qoo`0301l0h7oo01Moo`80h003O01oogoo01Yoo`9l00Eoo`03O01oogoo01=oo`04O0007goo0>0F
Ool20>000g`0Oomoo`0JOol00`0O0>1oo`0UOol002Uoo`03O000h03P01Qoo`030>007g`001aoo`06
O01oogooOoml00005Woo00Al000O01l0h1Moo`030>007g`001]oo`0301l0h7oo02Aoo`003Goo00<0
7gooOol06Woo00=l000O0>005goo00<0h7oo01l07Goo00El07ooOoml000001Moo`04O0007goo0>0G
Ool00`3P01ml000LOol00`3POomoo`0ROol000eoo`80h003O01oogoo01Uoo`03O000h03P01Moo`80
h00301ml07oo01]oo`9l0003Ool007oo01Moo`04O0007`0O0>0GOol00`3P01ml000KOol00`0O0>1o
o`0ROol000moo`030>1oogoo01Yoo`0301moo`3P01Moo`030>1oo`0O01moo`03001oogoo01Moo`04
O0007goo0>0GOol00`3P01ml000KOol00g`00>1oo`0QOol000moo`80h1]oo`03O0007`3P01Qoo`04
0>007g`0O00MOol2000IOol017`001moo`3P5goo00<0h00OOol06goo00<07`3POol087oo000AOol0
0`3POomoo`0JOol00`0O0>1oo`0GOol00`3P01ml000MOol00`00Oomoo`0IOol017`001moo`3P5goo
00<0h00OOol06goo00=l003POol07goo000AOol00`3P01ml000KOol00`0O0>1oo`0GOol0103P01ml
07`06goo00<007ooOol06Woo00=l000O0>0067oo00<0h00OOol06goo00=l003POol07Woo000BOol2
0>000g`0Oomoo`0IOol00`0O0>1oo`0GOol0103P01moog`06Woo00<007ooOol06goo00Al000O0>00
h1Moo`030>007goo01]oo`03O000h7oo01eoo`004goo00<0h00OO0006goo00<07`3POol05goo00@0
h00OO01l01Uoo`03001oogoo01aoo`03O0007`3P01Qoo`030>007goo01]oo`0301l0h7oo01aoo`00
57oo0P3P00=l07ooOol06Goo00=l003P0>005goo00@0h00O01ml01Qoo`03001oogoo01eoo`03O01o
o`3P01Qoo`030>007goo01]oo`0301l0h7oo01]oo`005Goo00<0h7`0Ool06goo00<07`3POol05Woo
00@0h7oo01ml01Qoo`04001oogooO00MOol00g`001l0h00HOol00`3PO01oo`0KOol00`0O0>1oo`0J
Ool001Ioo`80h003O01oogoo01Uoo`03O000h03P01Ioo`80h00301ml07`001Ioo`04001l07`0Ool2
O00LOol00g`001l0h00HOol20>000g`0Oomoo`0IOol00`3POomoo`0IOol001Qoo`030>1oogoo01Yo
o`03O0007`3P01Moo`030>1oog`001Ioo`03001l07oo009oo`03O01oogoo01]oo`03O0007`3P01Qo
o`030>007g`003Ioo`0067oo0P3P00=l07ooOol06Goo00=l000O0>005Woo0P3P00<07g`0O00057oo
00<007`0Ool00goo0W`077oo00=l000O0>0067oo0P3P00=l07ooOol0<goo000JOol00`3POomoo`0J
Ool00g`001l0h00GOol00`3POoml000DOol00`00O01oo`05Ool00g`0Oomoo`0JOol00g`001l0h00H
Ool00`3P01ml000dOol001Yoo`030>007goo01]oo`03O000h03P01Ioo`030>007`0O009l019oo`03
001l07oo00Ioo`03O01oogoo01Yoo`03O0007`3P01Qoo`80h003O01oogoo035oo`006goo00<0h00O
Ool06goo00<07goo0>005Woo00@0h00OOoml019oo`03001l07oo00Moo`03O01oogoo01Yoo`03O000
7`3P01Uoo`030>1l07oo035oo`0077oo00<0h00OOol06goo00<07`3P0>005Woo00@0h00OOoml015o
o`03001l07oo00Moo`9l01aoo`03O0007`3P01Qoo`80h39oo`007Goo00<0h00OOol06goo00=l000O
0>005Woo00@0h00OOoml011oo`03001l07oo00Uoo`03O01oogoo01Yoo`03O0007`3P01Uoo`030>1o
ogoo02moo`007Woo00<0h00OO0006goo00=l000O0>005Goo00@0h7oo01moo`9l00ioo`03001l07oo
00Yoo`03O01oogoo01Yoo`03O0007`3P01Qoo`030>007goo02moo`007goo0P3P00=l07ooOol06Goo
00=l000O0>005Goo00<0h7oo01l00Woo00=l07ooOol02goo00<007`0Ool017oo0`0O17oo00=l07oo
Ool06Woo00=l000O0>0067oo00<0h00OOol0;Woo000POol00`3PO01oo`0KOol00g`001l0h00EOol0
103POol07goo0W`037oo00<007`0Ool00goo00@07gooOomoo`807`=oo`03O01oogoo01Yoo`0301l0
h7oo01Qoo`030>007goo02eoo`008Goo00<0h7`0Ool06goo00=l000O0>005Goo00<0h7oo01l00Woo
00=l07ooOol02Goo00<007`0Ool00Woo00<07gooOol017oo00D07gooOomoog`001aoo`0301l0h7oo
01Qoo`030>007goo02aoo`008Woo00<0h7`0Ool06goo00<07`3POol057oo00<0h7oo01l00Woo00=l
07ooOol02Goo00<007`0Ool00Woo00<07gooOol01Goo0P0O00=oog`0Ool06goo00=l000O0>006Goo
00<0h7`0Ool0:goo000SOol20>000g`0Oomoo`0IOol00g`00>00h00DOol20>0201l00gooO01l0009
Ool00`00O01oo`02Ool00`0OOomoo`07Ool201l2O00KOol017`001l0h03P67oo0P3P00=l07ooOol0
:7oo000UOol00`3POomoo`0JOol00g`001l0h00EOol01@3POol07gooO0002Goo00<007`0Ool00Woo
00<07gooOol017oo00<0h7ooOol00Woo00<07gooO00077oo00=l003POol067oo00<0h00OO000:Goo
000UOol00`3P01moo`0KOol00g`001l0h00DOol00`3POol07`02Ool00g`0Oomoo`06Ool00`00O01o
o`02Ool00`0OOomoo`02Ool20>000goo0>00h003Ool00`0OOoml000LOol00g`00>00h00HOol20>00
0g`0Oomoo`0VOol002Ioo`030>007goo01]oo`03O0007`3P01Aoo`030>1oo`0O009oo`03O01oogoo
00Eoo`03001l07oo009oo`0501moogooOol0h005Ool20>02Ool00`0OOoml000LOol00g`00>1oo`0I
Ool00`3PO01oo`0VOol002Moo`030>007goo01]oo`03O0007`3P01=oo`040>1oogoo01l2Ool00g`0
Oomoo`04Ool00`00O01oo`02Ool01@0OOomoogoo0>001goo0P3P00Aoo`0OOoml01aoo`03O000h03P
01Qoo`80h2Moo`003Goo00<0h7ooOol067oo00<0h00OOol06goo00=l000O0>004goo00<0h7oo01l0
0goo00=l07ooOol00goo00<007`0Ool00Woo00D07gooOomoo`3P00Uoo`050>1oo`0O01ml000LOol0
0g`001l0h00IOol00`3POomoo`0TOol000ioo`80h1Uoo`030>007g`001]oo`04O0007`3P0>0AOol0
103POomoo`0O0Woo00=l07ooOol00goo00<007`0Ool00Woo00D07gooOomoo`3P00Yoo`050>1oo`0O
Ooml000LOol00`0O0>00h00HOol00`3P01moo`0TOol000moo`0301l0h7oo01Qoo`030>007g`001]o
o`04O0007goo0>0AOol0103POomoo`0O0Woo0W`00goo00<007`0Ool00goo00@07gooOol0h0]oo`80
h00301moog`001aoo`807`030>1oogoo01Ioo`030>007goo02=oo`003goo00=l003P0>006Goo00<0
h7`0Ool06goo00Al000O0>00h11oo`040>1oogoo01l3Ool01W`0Oomoogoo001l00Aoo`0401moogoo
0>0<Ool01@3POol07gooO00077oo00<07`3POol067oo00<0h00OOol08Woo000@Ool00g`001l0h00I
Ool00`3PO01oo`0KOol017`001l07`3P47oo00@0h7ooOol07`=oo`06O01oogoo001oog`017oo00@0
7gooOol0h0aoo`050>1oo`0OOoml000LOol00`0O0>1oo`0HOol20>0ROol0015oo`03O000h03P01Qo
o`80h003O01oogoo01Yoo`04O0007`3P0>0?Ool0103POomoo`0O17oo00El07oo001oog`000Aoo`04
01moogoo0>0=Ool20>0201l00g`0Oomoo`0IOol00g`001l0h00IOol00`3P01moo`0POol0019oo`03
O0007`3P01Uoo`80h003O01oogoo01Uoo`03O0007`0O0080h0ioo`040>1oogoo01l4Ool01G`0001o
ogooO0000goo00@07gooOol0h0moo`80h00301ml07oo01Yoo`04O0007`3P0>0HOol20>000g`0Oomo
o`0MOol001Aoo`03O000h7oo01Qoo`030>007goo01]oo`05O01oo`0OOol0h00=Ool01@3POomoogoo
01l00goo00El0000Oomoog`000Aoo`0301moo`3P011oo`040>1oo`0OO00LOol00g`00>1oo`0IOol0
0`3PO01oo`0MOol001Eoo`0301l0h7oo01Qoo`030>007goo01]oo`03O0007`0O0080h0aoo`050>1o
ogooOol07`03Ool00g`0001oo`02Ool01G`0Oomoogoo01l00Woo00<0h7ooOol03Woo0P3P00<07g`0
Ool06goo00<07`3POol06Goo00<0h7`0Ool077oo000FOol00`3POomoo`0HOol00`3P01moo`0KOol0
1G`0Ool07goo0>001goo1@0000@0h7oo00007`=oo`03O00007oo00=oo`05O01oogooOol07`02Ool0
0`3POomoo`0?Ool0103P01ml07`06goo00=l003POol06Goo00<0h7`0Ool06goo000FOol00g`00>00
h00IOol00`3P01moo`0KOol01G`001l07goo0>0027oo00P007ooOol0h000Ool07`000Woo00=l0000
Ool017oo00Al07ooOol07`9oo`030>1oogoo011oo`030>007g`001aoo`0301l0h7oo01Uoo`030>1o
ogoo01Yoo`0067oo00<0h7ooOol067oo00<0h00OOol06goo00El07oo01moo`3P00Moo`08001oogoo
0>0007oo01l000=oo`03O000000000Aoo`04O01oogoo01l2Ool00`3POomoo`0@Ool00`3P01ml000L
Ool00g`00>1oo`0IOol00`3POomoo`0IOol001Qoo`03O000h03P01Uoo`030>1l07`001]oo`04O01o
o`0OOol20>05Ool02000Oomoo`3P001oo`0O0003Ool00g`0Oomoo`04Ool00g`0Oomoo`0201l00goo
0>1oo`0BOol00`3P01ml000LOol00`0O0>1oo`0HOol00`3POomoo`0IOol001Yoo`0301l0h7oo01Qo
o`030>007g`001]oo`03O01oo`0O009oo`80h0=oo`05001oo`3POol00002Ool01@0OOomoogooO000
1goo00Ml07ooOomoo`0OOol0h00COol00`3P01ml000LOol00`0O0>1oo`0cOol001Yoo`03O000h03P
01Uoo`030>1l07`001]oo`03O01oo`0O009oo`<0h0800004Ool0h7ooOol200001@0OOomoogooO000
27oo00Il07ooOol07goo0>0COol20>000`0OO01oo`0KOol00`0O0>1oo`0bOol001]oo`03O0007`3P
01Uoo`030>007g`001]oo`03O01oo`0O00Aoo`<0h0Eoo`0501moogooOoml0009Ool01W`0Oomoo`0O
Ool0h1Aoo`030>007g`001aoo`0301l0h7oo035oo`0077oo00=l003P0>0067oo0P3P00=l07ooOol0
6Woo00Al07oo01l07`Yoo`0501moogooOoml000:Ool00g`0Ool07`02Ool00`3POomoo`0BOol00`3P
01ml000KOol00g`001l0h00aOol001eoo`03O0007`3P01Uoo`030>007g`001]oo`9l0003Ool07goo
00Qoo`0501moogooOoml000;Ool01W`0Ool07`0OOol0h1Aoo`80h00301ml07oo01Yoo`0301l0h7oo
02moo`007goo00=l003POol05goo00<0h7oo01l07Goo00=l07oo01l01goo00<07gooOol00Woo00=l
07ooOol02Woo00Il07ooOol07goo0>0EOol00`3POoml000JOol00g`0Ool0h00_Ool0021oo`03O000
h7oo01Moo`80h00301ml07oo01Yoo`03O01oogoo00807`Eoo`0301moogoo009oo`03O01oogoo00]o
o`05O01oo`0OOol0h00EOol20>000g`0Oomoo`0IOol00g`001l0h00^Ool0025oo`030>1oogoo01Mo
o`030>1oo`0O01aoo`9l009oo`0501moogooOol07`05Ool00g`0001oo`0<Ool01G`0Ool07goo0>00
5Woo00<0h7`0Ool06goo00=l003POol0;7oo000QOol00g`00>00h00HOol20>000g`0Oomoo`0JOol0
17`0Oomoogoo100O1Goo00=l07ooOol03Goo00El07oo01moo`3P01Eoo`030>007`0O01aoo`0301l0
h7oo02]oo`008goo00<07`3POol05goo00<0h00OO00077oo00=l07ooOol02Goo00=l07ooOol03Woo
00El07oo01moo`3P01Eoo`80h00301moogoo01Yoo`03O000h7oo02Yoo`008goo00=l000O0>0067oo
00<0h00OO00077oo00=l07ooOol027oo00=l07ooOol03goo00=l07oo01l00P3P5Goo00<0h00OO000
77oo00<07`3POol0:Goo000UOol00`0O0>1oo`0GOol00`3P01ml000LOol00g`0Oomoo`07Ool00g`0
Oomoo`0@Ool01G`0Ool07goo0>005Goo00<0h00OO00077oo00<07`3POol0:7oo000VOol00`0O0>1o
o`0GOol20>02O00KOol00g`0Oomoo`06Ool00g`0Oomoo`0AOol017`001l07`3P5Woo00<0h00OO000
77oo00<07`3POol09goo000WOol00`0O0>1oo`0HOol00`3P01ml000KOol00g`0Oomoo`05Ool00g`0
Oomoo`0BOol017`0Ool07`3P5Woo00<0h00OO00077oo00<07`3POol09Woo000WOol00g`001l0h00H
Ool20>000g`0Oomoo`0JOol2O005Ool00g`0Oomoo`0BOol2O0000`0OOol0h00FOol00`3P01ml000L
Ool00`3POomoo`0UOol002Qoo`03O0007`3P01Uoo`030>1l07oo01aoo`06O01oogooOoml00005Woo
00Al000OOol0h1Ioo`030>007g`001aoo`030>1l07oo02Aoo`003Goo00=l07ooOol06Goo00=l003P
0>0067oo00<0h00OO00077oo0W`00Woo00=l000000005Goo00=l07oo01l00P3P5Woo0P3P00=l07oo
Ool06Goo00=l003P0>0097oo000=Ool20>0KOol2O0000`3POomoo`0FOol0103P01ml07`077oo0W`0
00=oo`00Ool05Woo0W`00P0O00<0h7ooOol05Goo00<0h00OOol06Woo00=l000O0>008goo000?Ool0
0`3POomoo`0JOol00`3POomoo`0GOol00`3P01ml000OOol00`00Oomoo`0GOol017`001moo`3P5goo
00<0h00OOol06goo00=l003POol08Goo000?Ool00`3P01moo`0JOol00g`00>00h00HOol00`3P01ml
000NOol00`00Oomoo`0HOol00g`001l0h00HOol00`3P01moo`0KOol00`0O0>1oo`0POol0011oo`03
0>007goo01]oo`0301l0h7oo01Moo`030>007g`001eoo`03001oogoo01Uoo`03O0007`3P01Qoo`03
0>007goo01]oo`0301l0h7oo01moo`004Goo00<0h00OOol06Woo00=l000O0>0067oo00<0h00OO000
77oo00<007ooOol06Woo00=l000O0>0067oo00<0h00OOol06goo00<07`3POol07Woo000BOol00`3P
01moo`0KOol00`0O0>1oo`0GOol00`3P01ml000KOol00`00Oomoo`0KOol00g`001l0h00GOol00`3P
01ml000LOol00`0O0>1oo`0MOol001=oo`030>1l07oo01]oo`0301l0h7oo01Ioo`040>1oo`0OO00J
Ool00`00Oomoo`0LOol00g`001l0h00GOol20>000g`0Oomoo`0JOol00`0O0>1oo`0LOol001Aoo`80
h1aoo`0301l0h7oo01Ioo`80h00301ml07oo01Qoo`03001oogoo01eoo`03O0007`3P01Moo`030>00
7g`001aoo`0301l0h7oo01]oo`005Goo00<0h7`0Ool06Woo00=l000O0>005goo00@0h00O01ml01Qo
o`8001ioo`9l000301l0h7oo01Ioo`80h003O01oogoo01Yoo`030>1oogoo01Yoo`005Woo00<0h7`0
Ool06Woo0W`00P3P5Woo0P3P00<07g`0Ool05Woo00@007ooOoml01ioo`0301moo`3P01Qoo`030>1l
07oo01]oo`030>1oogoo01Uoo`005goo00<0h7`0Ool06Woo00=l000O0>005goo00@0h00OOoml01Io
o`04001l07`0Ool2O00LOol00g`001l0h00HOol20>000g`0Oomoo`0IOol00g`0Oomoo`0IOol001Qo
o`030>007goo01Yoo`9l0080h1Ioo`80h00301ml07oo01Aoo`03001l07oo00=oo`9l01]oo`04O000
7`3P0>0HOol00`3P01ml000eOol001Uoo`030>007goo01]oo`03O0007`3P01Ioo`040>007gooO00D
Ool00`00O01oo`04Ool00g`0Oomoo`0JOol017`0Ool07`3P67oo00<0h00OO000=7oo000JOol00`3P
01moo`0KOol00g`00>00h00FOol0103P01l07g`04goo00<007`0Ool01Goo0W`06goo0W`000<07`3P
Ool05goo00<0h00OOol0<goo000KOol00`3P01moo`0KOol00`0OOol0h00EOol01@3POol07gooO000
4Woo00<007`0Ool01goo00=l07ooOol06Woo00=l000O0>0067oo00<0h00OO000<Woo000LOol00`3P
01moo`0JOol017`001l0h03P5Goo0P3P00<07gooO0004Goo00<007`0Ool01goo0W`077oo00=l000O
0>0067oo00<0h00OOol0<Goo000MOol00`3P01moo`0KOol00`0OOol0h00EOol01@3POol07gooO000
47oo00<007`0Ool02Goo00=l07ooOol06Woo00=l000O0>0067oo00<0h00OOol0<7oo000NOol00`3P
O01oo`0KOol00`0O0>1oo`0EOol01@3POol07gooO0003goo00<007`0Ool02Goo0W`077oo00<07`3P
0>0067oo00<0h00OOol0;goo000OOol00`3P01moo`0KOol00g`00>00h00EOol01@3POol07gooO000
3Woo00<007`0Ool017oo0`0O17oo00=l07ooOol06Woo0P0O00<0h7ooOol05Woo00<0h00OOol0;Woo
000POol00`3PO01oo`0KOol00`0O0>1oo`0EOol01@3POol07gooO0003Goo00<007`0Ool00goo00D0
7gooOomoo`0O00=oo`03O01oogoo01Yoo`03O0007`3P01Uoo`030>1l07oo02eoo`008Goo00<0h7`0
Ool06goo00=l003P0>005Goo00D0h7oo01moog`000aoo`03001l07oo009oo`0301moogoo00=oo`80
7`9oo`9l01aoo`0301l0h7oo01Qoo`030>007goo02aoo`008Goo0P3P00=l07ooOol06Goo00=l000O
0>005Goo00<0h7oo01l00Woo00=l07ooOol02Goo00<007`0Ool00Woo00<07gooOol01Goo0P0O00=o
og`0Ool06goo00=l000O0>006Goo00<0h7`0Ool0:goo000SOol00`3P01moo`0JOol2O0020>0DOol0
1P3POol07`0OOoml00Yoo`03001l07oo009oo`0301moogoo00Moo`807`9l01]oo`04O0007`3P0>0H
Ool20>000g`0Oomoo`0XOol002Aoo`030>007goo01]oo`03O0007`3P01Aoo`060>1oogoo01moog`0
2Goo00<007`0Ool00Woo00<07gooOol027oo00@07gooOoml01]oo`03O01oo`3P01Uoo`030>007g`0
02Uoo`009Goo00<0h00OOol06goo00=l003P0>0057oo00<0h7oo01l00Woo00=l07ooOol01Woo00<0
07`0Ool00Woo00<07gooOol00Woo1@3P0Woo0P0O00=oog`0Ool06Woo00=l000O0>006Goo00<0h00O
Ool0:7oo000VOol00`3P01moo`0KOol00`0OOol0h00DOol00`3P01l00002000017`0Ool0000017oo
00<007`0Ool00Woo00D07gooOomoo`3P00Eoo`80h09oo`0301moog`001aoo`03O000h7oo01Qoo`03
0>007g`002Moo`009goo00<0h00OOol06Woo00Al000O01l0h1=oo`030>1oo`0O00=oo`04O01oogoo
0003Ool00`00O01oo`02Ool01@0OOomoogoo0>001goo00H0h7ooOol07gooO00LOol00`0O0>1oo`0H
Ool20>0WOol000eoo`030>1oogoo01Qoo`030>007goo01]oo`03O0007`3P01=oo`030>00000O00=o
o`03O01oo`0000=oo`03001l0000009oo`0501moogooOol0h008Ool01P3POomoo`0OOoml01aoo`03
01l0h7oo01Uoo`030>1oogoo02Aoo`003Goo00=l003POol06Goo00<0h7`0Ool06goo00=l000O0>00
4Woo00@0h000Ool07`9oo`03O00007oo00=oo`03001l07oo009oo`0501moogooOol0h009Ool20>00
17oo01ml07`077oo00<07`3POol067oo00<0h00OOol097oo000>Ool00g`00>1oo`0IOol00`3P01mo
o`0KOol00g`001l0h00BOol01P3POomoo`0OOol0009l00=oo`03001l07oo00=oo`0401moogoo0>0;
Ool20>000`0OOoml000LOol00`0O0>1oo`0HOol00`3P01moo`0SOol000moo`03O000h7oo01Uoo`03
0>1l07oo01]oo`04O0007`3P0>0?Ool01P000>1oogoo01moo`800006O01oogooOol007`017oo00@0
7gooOol0h0aoo`050>1oo`0OOoml000KOol00g`001l0h00IOol00`3PO01oo`0ROol0011oo`03O000
h7oo01Uoo`030>1oogoo01]oo`04O0007`0O0>0@Ool0103POomoo`0O0goo00Il07ooOol007ooO004
Ool0100OOomoo`3P37oo00D0h7oo01moog`001aoo`030>1oogoo01Qoo`030>007goo025oo`004Goo
00=l003P0>0067oo00<0h00OO0006goo00=l07oo01l00P3P3goo00@0h7ooOol07`=oo`9l0004Ool0
07ooO004Ool0100OOomoo`3P3Goo00@0h7oo01ml01aoo`03O000h03P01Uoo`030>1l07oo021oo`00
4Woo00=l000O0>0067oo0P3P00<07gooOol06Goo0W`00P0O00<0h7ooOol03Goo00@0h7ooOol07`=o
o`03O01oo`00009oo`05O01oogooOol07`02Ool00`3POomoo`0<Ool20>0201l00g`0Oomoo`0IOol0
0g`001l0h00IOol20>000g`0Oomoo`0MOol001Aoo`0301l0h7oo01Moo`030>1oo`0O01aoo`03O01o
o`3P00moo`040>1oogoo01l4Ool01G`0001oogooO00017oo00<07goo0>0047oo00@0h7oo01ml01]o
o`03O01oo`3P01Uoo`030>007g`001ioo`005Goo00<07`3POol05goo0P3P00<07gooOol06Woo00=l
000O0>000P3P37oo00@0h7ooOol07`Aoo`03O00007oo009oo`05O01oogooOol07`02Ool00`3POomo
o`0>Ool0103POol07g`06goo00=l000O0>006Goo0P3P7Woo000FOol00`3POomoo`0GOol00`3POol0
7`0LOol01G`0Ool07goo0>0037oo00@0h7ooOol07`=oo`03O000000000=oo`05O01oogooOol07`02
Ool00`3POomoo`0>Ool0103POol07g`06goo00=l07oo0>006Goo00<0h00OO00077oo000FOol00g`0
0>00h00HOol20>000g`0Oomoo`0IOol2O00201l20>0;Ool0103POomoo`0O0goo00=l0000Ool00goo
00El07ooOomoo`0O009oo`030>1oogoo00moo`80h00301ml07oo01Yoo`03O0007`3P01Uoo`80h1ao
o`0067oo00<0h7ooOol067oo00<0h7`0Ool06goo00El07oo01moo`3P00Yoo`040>1oogoo01l4Ool0
0g`0Oomoo`03Ool01g`0Oomoogoo01moo`3P01=oo`030>007g`001aoo`0301l0h7oo01Uoo`030>1o
ogoo01Uoo`0067oo00=l003POol06Goo00<0h7`0Ool06goo00Al000O01moo`80h0Qoo`040>1oogoo
01l4Ool00g`0Oomoo`04Ool00g`0Oomoo`0201l00goo0>1oo`0AOol20>000`0OO01oo`0KOol00`0O
0>1oo`0HOol00`3POomoo`0IOol001Uoo`03O000h7oo01Uoo`030>007goo01]oo`03O01oo`0O009o
o`030>1oogoo00Eoo`050>1oogooOol07`03Ool00g`0Oomoo`05Ool01g`0Oomoogoo01moo`3P01=o
o`030>1oog`001aoo`0301l0h7oo03=oo`006Woo00=l003P0>0067oo0P3P00=l07ooOol06Woo00=l
07oo01l00Woo00<0h7ooOol017oo00D0h7ooOomoo`0O00=oo`03O01oogoo00Ioo`06O01oogoo01mo
o`3P4goo00@0h00O01ml01]oo`03O0007`3P03=oo`006goo00=l000O0>006Goo00<0h00OOol06goo
00=l07oo01l00Woo1P3P17oo00D07gooOomoog`000Uoo`06O01oogoo01moo`3P4goo00@0h7oo01ml
01aoo`0301l0h7oo035oo`0077oo00=l003P0>0067oo0P3P00=l07ooOol06Woo00Al07oo01l07`Yo
o`0501moogooOoml0009Ool017`0Oomoo`0O0Woo00<0h7ooOol04Goo00@0h7oo01ml01]oo`03O000
h7oo035oo`007Goo00=l000O0>006Goo00<0h7`0Ool06goo00Al07ooOol07`Uoo`0501moogooOoml
000:Ool017`0Oomoo`0O0Woo00<0h7ooOol04Goo0P3P00<07g`0Ool06goo00<0h7ooOol0;goo000N
Ool00g`00>00h00HOol00`3P01ml000KOol00g`0Oomoo`0201l8Ool01P0OOomoogooO00000Yoo`06
O01oogoo01moo`3P57oo00<0h00O01l077oo00=l003POol0;goo000OOol00g`001l0h00HOol20>00
0g`0Oomoo`0IOol2O002Ool201l5Ool00`0OOomoo`02Ool00g`0Oomoo`0:Ool2O00017oo01moo`3P
57oo0P3P00<07g`0Ool06Woo00=l003P0>00;Woo000QOol00`3POomoo`0GOol00`3P01ml000LOol0
1G`0Oomoogoo01l00goo00<07gooOol00goo00=l07ooOol02goo00Il07ooOol07goo0>0EOol00`3P
01ml000KOol00g`0Ool0h00]Ool0025oo`03O000h03P01Qoo`030>007g`001aoo`04O01oogooOol4
01l5Ool00g`0Oomoo`0<Ool2O00017oo01moo`3P5Goo00<0h00OO0006goo00=l000O0>00;7oo000S
Ool00`3POomoo`0GOol00`3P01ml000LOol00g`0Oomoo`09Ool00g`0Oomoo`0>Ool01G`0Ool07goo
0>005Goo00<0h00OO00077oo00<07`3POol0:Woo000SOol00g`00>00h00HOol00`3P01ml000LOol0
0g`0Oomoo`08Ool00g`0Oomoo`0?Ool00g`0Ool07`020>0EOol00`3P01ml000LOol00`0O0>1oo`0Y
Ool002Eoo`030>1oogoo01Moo`030>007g`001aoo`03O01oogoo00Moo`03O01oogoo011oo`05O01o
o`0OOol0h00EOol00`3P01ml000LOol00`0O0>1oo`0XOol002Eoo`03O000h03P01Qoo`030>007g`0
01aoo`03O01oogoo00Ioo`03O01oogoo011oo`9l00807`030>1oogoo01Aoo`030>007g`001aoo`03
0>1oogoo02Moo`009Woo00=l000O0>0067oo00<0h00OO00077oo00=l07ooOol01Goo00=l07ooOol0
4Woo00=l07oo0>005goo00<0h00OO00077oo0P3P9goo000WOol00g`00>00h00HOol00`3P01ml000L
Ool00g`0Oomoo`04Ool00g`0001oo`0BOol2O0000`0O0>1oo`0FOol00`3P01ml000KOol00g`00>1o
o`0VOol002Qoo`03O0007`3P01Qoo`030>007goo01aoo`03O01oogoo00=oo`03O01oogoo01Aoo`03
O0007`3P01Moo`030>007g`001aoo`030>1oogoo02Aoo`003Goo00=l07ooOol06Goo00=l003P0>00
5goo00@0h00OO01l01aoo`9l009oo`9l01Ioo`04O01oo`0O0>0GOol00`3P01moo`0KOol00g`00>1o
o`0TOol000eoo`030>007goo01Yoo`03O0007`3P01Moo`80h00301ml07oo01aoo`9l0003Ool007oo
01Ioo`9l000301l0h03P01Ioo`80h00301moogoo01Uoo`03O000h03P02=oo`003Woo00<0h00OOol0
6goo00<0h7ooOol05goo00<0h00OO0007goo00<007ooOol05Woo00El07oo01moo`3P01Moo`030>1l
07oo01Yoo`03O0007`3P029oo`003goo00<0h00OOol06Woo00=l003P0>005goo0P3P00<07g`0Ool0
7Goo00<007ooOol05goo0W`000<07`3POol05goo00<0h00OOol06Woo00=l003P0>008Goo000@Ool0
0`3P01moo`0KOol00`3POomoo`0GOol00`3P01ml000MOol00`00Oomoo`0HOol017`0Ool07`3P67oo
00<0h00OOol06Woo00=l000O0>0087oo000AOol00`3PO01oo`0JOol00g`00>00h00GOol20>000`0O
O01oo`0KOol00`00Oomoo`0IOol2O0000`0O0>1oo`0GOol00`3PO01oo`0JOol00g`001l0h00OOol0
019oo`030>007goo01]oo`0301l0h7oo01Moo`030>007g`001]oo`03001oogoo01]oo`03O0007`3P
01Moo`030>007g`001aoo`0301l0h7oo01eoo`004goo00<0h7`0Ool06Woo00=l000O0>005goo00@0
h7oo01ml01Yoo`8001aoo`9l000301l0h7oo01Ioo`030>007g`001aoo`030>1oogoo01aoo`0057oo
00<0h00OOol06Woo00=l000O0>005goo00@0h7oo01ml01Uoo`03001oogoo01eoo`03O0007`3P01Mo
o`030>007g`001aoo`80h1aoo`005Goo00<0h7`0Ool06Woo00=l000O0>005goo00@0h00O01ml01Qo
o`03001oogoo01eoo`04O0007`3P0>0GOol00`3P01ml000KOol00g`00>1oo`0KOol001Ioo`030>1o
ogoo01Yoo`03O0007`3P01Moo`030>1oo`0O01Qoo`04001oogooO00NOol00`0O0>1oo`0GOol00`3P
01ml000LOol00`3POomoo`0IOol001Ioo`030>007goo01]oo`03O0007`3P01Moo`040>007g`0O00F
Ool01000O01l07oo0W`077oo00=l000O0>0067oo0P3P77oo00=l07ooOol06Goo000GOol20>000`0O
Oomoo`0IOol2O0000`3POomoo`0EOol0103P01l07g`05Goo00<007`0Ool00goo00=l07ooOol06Woo
00Al000O0>00h1Qoo`030>007goo03Eoo`006Goo00<0h00OOol06goo00=l003POol05Goo00D0h7oo
01moog`001Aoo`03001l07oo00Aoo`03O01oogoo01Yoo`03O01oo`3P01Uoo`030>1l07oo03Aoo`00
6Woo00<0h00OOol06goo00=l003POol05Goo0P3P00<07gooO0001Woo10000goo0P0017oo00<007`0
Ool01Goo0W`06goo00Al000O0>00h1Qoo`030>007goo03=oo`006goo00<0h00OOol06goo00<07`3P
Ool05Goo00D0h7oo01moog`000Eoo`03001oogoo00=oo`04001oogoo0003Ool00`00O01oo`07Ool0
0g`0Oomoo`0IOol00g`0Ool0h00IOol00`3P01moo`0bOol001aoo`030>1l07oo01Yoo`03O0007`3P
01Ioo`050>1oo`0OOoml0005Ool00`00Oomoo`02Ool01000Oomoo`000goo00<007`000001goo00=l
07ooOol06Woo00=l000O0>006Goo00<0h7`0Ool0<Goo001MOol01@00Oomoogoo00000Woo00D007oo
Oomoo`0007Ioo`00Fgoo00@007ooOol0009oo`04001oogoo0003Ool00`00Oomoo`1dOol005aoo`80
00Aoo`8000Aoo`03001oogoo07Aoo`00J7oo00<007ooOol0M7oo001XOol00`00Oomoo`1dOol00=mo
o`00ggoo003OOol00=moo`00ggoo003OOol00=moo`00ggoo003OOol00=moo`00IWoo1000MGoo001U
Ool01000Oomoo`00MWoo001UOol01000Oomoo`00MWoo001TOol200000goo0000001fOol00=moo`00
ggoo003OOol00=moo`00ggoo003OOol00=moo`00ggoo003OOol00001\
\>"],
  ImageRangeCache->{{{0, 222}, {222, 0}} -> {-11.503, -1.25017, 0.109731, \
0.109731}}]
}, Open  ]],

Cell[TextData[{
  "We clearly observe that small values for ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " will force the function to be located at the vertical axis at ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  ". Larger values of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " push the function away from this vertical axis. Examination of this \
example demonstrates that the knowledge of the infinitesimals is very useful \
in constructing solutions of first-order differential equations. For the \
present equation, we only stated the existence of the infinitesimal \
transformations. In S",
  ButtonBox["ection 4.4.1.3",
    ButtonData:>
      "Infinitesimals of first order ordinary differential equations",
    ButtonStyle->"Hyperlink"],
  ", we will show how such infinitesimals can be derived from the invariance \
condition of the differential equation.\[ThickSpace]\[EmptySquare]"
}], "Text",
  PageBreakWithin->True,
  CellTags->{
  "infinitesimals", "solutions of first-order differential equations", 
    "infinitesimal transformation", "invariance condition"}],

Cell[TextData[{
  "Let us demonstrate the application of Lie\[CloseCurlyQuote]s integrating \
factor theorem by another example. We are especially interested in collecting \
the steps of calculation in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function. The basis of this function is the ",
  ButtonBox["above theorem",
    ButtonData:>"Theorem: Integrating Factor",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  Evaluatable->False,
  CellTags->"integrating factor theorem"],

Cell["Example 2", "Example"],

Cell["\<\
Let us again examine the Riccati equation discussed in connection \
with the skeleton of a first-order ordinary differential equation:\
\>", 
  "Text",
  Evaluatable->False,
  CellTags->{"Riccati equation", "skeleton"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(riccati // LTF\)], "Input"],

Cell[BoxData[
    \(u\^2 - 2\/x\^2 + u\_x == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Considering this equation, it is useful to determine the symmetry. Since \
this equation is of a polynomial type, it is natural to assume that the \
symmetries of this equation are of a scaling type. We already know that the \
infinitesimals are given by ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi] = x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi] = \(-u\)\)]],
  ". If we represent the Riccati equation in the form"
}], "Text",
  Evaluatable->False,
  CellTags->{"polynomial", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ricc = Dt[u] + \((u\^2 - 2\/x\^2)\)\ Dt[x] == 0\)], "Input"],

Cell[BoxData[
    \(Dt[u] + \((u\^2 - 2\/x\^2)\)\ Dt[x] == 0\)], "Output"]
}, Open  ]],

Cell[TextData[
"we are able to use Lie\[CloseCurlyQuote]s theorem to determine the \
integrating factor in a straightforward way:"], "Text",
  Evaluatable->False,
  CellTags->"integrating factor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Mu] = Simplify[Together[1\/\(x\ \((u\^2 - 2\/x\^2)\) - u\)]]\)], 
  "Input"],

Cell[BoxData[
    \(x\/\(\(-2\) - u\ x + u\^2\ x\^2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Multiplying the equation ",
  StyleBox["ricc",
    FontSlant->"Italic"],
  " by the integrating factor \[Mu], we get"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ricc1 = Simplify[Thread[ricc\ mu, Equal]]\)], "Input"],

Cell[BoxData[
    \(\(x\ \((Dt[u] + \((u\^2 - 2\/x\^2)\)\ Dt[x])\)\)\/\(\(-2\) - u\ x + 
          u\^2\ x\^2\) == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Integrating the coefficients of the total differentials with respect to \
the differential, we get for ",
  StyleBox["Dt",
    FontSlant->"Italic"],
  "[",
  StyleBox["u",
    FontSlant->"Italic"],
  "]",
  " and ",
  StyleBox["Dt",
    FontSlant->"Italic"],
  "[",
  StyleBox["x",
    FontSlant->"Italic"],
  "] respectively"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solu = 
      \[Integral]Coefficient[
            Expand[ricc1\[LeftDoubleBracket]1\[RightDoubleBracket]], Dt[u]] 
          \[DifferentialD]u\)], "Input"],

Cell[BoxData[
    \(1\/3\ Log[\(-2\) + u\ x] - 1\/3\ Log[1 + u\ x]\)], "Output"]
}, Open  ]],

Cell["and", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solx = 
      \[Integral]Coefficient[
            Expand[ricc1\[LeftDoubleBracket]1\[RightDoubleBracket]], Dt[x]] 
          \[DifferentialD]x\)], "Input"],

Cell[BoxData[
    \(Log[x] + 1\/3\ Log[\(-2\) + u\ x] - 1\/3\ Log[1 + u\ x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing the two integrals, we observe that common terms exist. Thus, the \
complete solution which is equal to a constant ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] follows:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(isol = Expand[1\/2\ \((\((solx - solu)\) + solu + solx)\)] == C[1]\)], 
  "Input"],

Cell[BoxData[
    \(Log[x] + 1\/3\ Log[\(-2\) + u\ x] - 1\/3\ Log[1 + u\ x] == C[1]\)], 
  "Output"]
}, Open  ]],

Cell["\<\
After the collection of logarithmic terms and an exponentiation, we \
get \
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(iisol = 
      Thread[Exp[
          isol //. 
            a_. \ Log[b_] + c_. \ Log[d_] \[Rule] \n\t\t\t\t\t
              Log[b\^a\ d\^c]], Equal]\)], "Input"],

Cell[BoxData[
    \(\(x\ \((\(-2\) + u\ x)\)\^\(1/3\)\)\/\((1 + u\ x)\)\^\(1/3\) == 
      E\^C[1]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution of this relation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " reproduces the known result:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[iisol, u]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \(E\^\(3\ C[1]\) + 2\ x\^3\)\/\(x\ 
              \((\(-E\^\(3\ C[1]\)\) + x\^3)\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "All these steps to solve a first-order ordinary differential equation are \
completely algorithmic. That is why we can collect them in a common function \
called ",
  StyleBox["IntegratingFactor[]", "MmaText"],
  ". The function ",
  StyleBox["IntegratingFactor[]", "MmaText"],
  " needs as input parameters, the equation, the dependent and independent \
variables, and the infinitesimals. The following lines define this function \
using the steps of the calculation discussed above:"
}], "Text",
  Evaluatable->False,
  CellTags->"IntegratingFactor[]"],

Cell[BoxData[{\(Clear[IntegratingFactor]\), "\n", 
    RowBox[{\(IntegratingFactor[equation_, depend_:  Symbol, \n\t
        independ_:  Symbol, xi_, phi_]\), ":=", "\n", "\t", 
      RowBox[{"Block", "[", 
        RowBox[{\({pattern1, pattern2, eq, eqin, q, p, \n\t\t\tifactor, t1, 
            t2, it1, it2}\), ",", "\n", "\t\t", 
          RowBox[{
            RowBox[{"If", "[", 
              RowBox[{
                RowBox[{"equation", "/.", 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{"p_.", " ", 
                          RowBox[{
                            SuperscriptBox["u_", 
                              TagBox[\((n_)\),
                                Derivative],
                              MultilineFunction->None], "[", "t_", "]"}]}], 
                        "+", "q_"}], "==", "0"}], 
                    "\[RuleDelayed]", \(n > 1\)}]}], ",", "\n", 
                "\t\t\t", \(Return[
                  Hold[IntegratingFactor[equation, \n\t\t\t\t\t\tdepend, 
                      independ, xi, phi]]]\)}], "]"}], ";", "\n", 
            "\t\t", \(If[
              FreeQ[equation, Equal], \n\t\t\tReturn[
                Hold[IntegratingFactor[equation, \n\t\t\t\t\t\tdepend, 
                    independ, xi, phi]]]]\), ";", "\n", 
            "\t\t", \(trafo = depend @@ {independ} \[Rule] depend\), ";", 
            "\n", "\t\t", \(itrafo = depend \[Rule] depend @@ {independ}\), 
            ";", "\n", "\t\t", 
            RowBox[{"pattern1", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{"p_.", " ", 
                      RowBox[{
                        SuperscriptBox["u_", "\[Prime]",
                          MultilineFunction->None], "[", "t_", "]"}]}], "+", 
                    "q_"}], "==", "0"}], 
                "\[RuleDelayed]", \(\(-p\)\ Dt[u] + q\ Dt[t]\)}]}], ";", "\n",
             "\t\t", 
            RowBox[{"pattern2", "=", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{"p_.", " ", 
                      RowBox[{
                        SuperscriptBox["u_", "\[Prime]",
                          MultilineFunction->None], "[", "t_", "]"}]}], "+", 
                    "q_"}], "==", "0"}], 
                "\[RuleDelayed]", \({q, \(-p\)}\)}]}], ";", "\n", 
            "\t\t", \(eqin = equation /. trafo\), 
            ";", \(eq = eqin /. pattern1\), ";", "\n", 
            "\t\t", \({q, p} = eqin /. pattern2\), ";", "\n", 
            "\t\t", \(ifactor = 1\/\(xi\ q - phi\ p\)\), ";", "\n", 
            "\t\t", \(eqh = Together[eq\ ifactor]\), ";", "\n", 
            "\t\t", \(num = Numerator[eqh]\), ";", "\n", 
            "\t\t", \(den = Denominator[eqh]\), ";", "\n", 
            "\t\t", \(t1 = Coefficient[num, Dt[independ]]\/den\), ";", "\n", 
            "\t\t", \(t2 = Coefficient[num, Dt[depend]]\/den\), ";", "\n", 
            "\t\t", \(it1 = \[Integral]t1 \[DifferentialD]independ\), ";", 
            "\n", "\t\t", \(it2 = \[Integral]t2 \[DifferentialD]depend\), ";",
             "\n", "\t\t", \(If[
              FreeQ[it1, Integrate] && FreeQ[it2, Integrate], \n\t\t\tit1 = 
                Expand[1\/2\ \((\((it1 - it2)\) + it1 + 
                        it2)\)], \n\t\t\tReturn[
                Hold[IntegratingFactor[equation, \n\t\t\t\t\t\tdepend, 
                    independ, xi, phi]]]]\), ";", "\n", 
            "\t\t", \(Simplify[it1 == C[1] /. itrafo]\), 
            "         "}]}]}]}]}], "Input",
  CellTags->"IntegratingFactor[]"],

Cell[TextData[{
  "The following examples demonstrate the application of the function ",
  StyleBox["IntegratingFactor[]", "MmaText"],
  ". "
}], "Text",
  Evaluatable->False],

Cell["Example 3", "Example"],

Cell["\<\
The first equation solved by this function is a first-order \
equation containing a ratio of dependent and independent variables:\
\>", 
  "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq2 = \[PartialD]\_x u[x] - \(x\^2 + u[x]\^2\)\/\(x\ u[x]\) == 0; 
    eq2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(u\^2 + x\^2\)\/\(u\ x\)\),
                    ScriptLevel->0]}], "+", \(u\_x\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Knowing the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi] = x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi] = u\)]],
  ", the function ",
  StyleBox["IntegratingFactor[]", "MmaText"],
  " is able to calculate the implicit solution in the form"
}], "Text",
  Evaluatable->False,
  CellTags->{"implicit solution", "IntegratingFactor[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ieq2 = IntegratingFactor[eq2, u, x, x, u]\)], "Input"],

Cell[BoxData[
    \(Log[x] - u[x]\^2\/\(2\ x\^2\) == C[1]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Solving this equation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we find that the solution is given by two expressions containing a Log[",
  
  StyleBox["x",
    FontSlant->"Italic"],
  "] in the radicand of a square root:"
}], "Text",
  Evaluatable->False,
  CellTags->"Log[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[ieq2, u[x]]\)], "Input"],

Cell[BoxData[
    \({{u[x] \[Rule] \(-I\)\ \@2\ \@\(x\^2\ C[1] - x\^2\ Log[x]\)}, {
        u[x] \[Rule] I\ \@2\ \@\(x\^2\ C[1] - x\^2\ Log[x]\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Extracting ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " from the constant of integration ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1], we find the same solution as ",
  StyleBox["DSolve[]", "MmaText"],
  " does:"
}], "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[eq2, u[x], x]\)], "Input",
  ShowCellBracket->True],

Cell[BoxData[
    \({{u[x] \[Rule] \(-\@2\)\ \@\(x\^2\ C[1] + x\^2\ Log[x]\)}, {
        u[x] \[Rule] \@2\ \@\(x\^2\ C[1] + x\^2\ Log[x]\)}}
        \[ThickSpace]\[EmptySquare]\)], "Output"]
}, Open  ]],

Cell["Example 4", "Example"],

Cell["\<\
Another example for which an integrating factor exists but the \
quadrature is impossible is given by\
\>", "Text",
  Evaluatable->False,
  CellTags->{"integrating factor", "quadrature"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq3 = \[PartialD]\_x u[x] - u[x]\ \((1 - u[x]\^2\ Exp[u[x]])\) == 0; 
    eq3 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-u\)\ \((1 - E\^u\ u\^2)\) + u\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["IntegratingFactor[] ", "MmaText"],
  "returns the original input"
}], "Text",
  Evaluatable->False,
  CellTags->"IntegratingFactor[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ieq3 = IntegratingFactor[eq3, u, x, 1, 0]\)], "Input"],

Cell[BoxData[
    RowBox[{"IntegratingFactor", "[", 
      RowBox[{
        RowBox[{
          RowBox[{\(\(-u[x]\)\ \((1 - E\^u[x]\ u[x]\^2)\)\), "+", 
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", "0"}], 
        ",", "u", ",", "x", ",", "1", ",", "0"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["IntegratingFactor[]", "MmaText"],
  " is simple to use. If the function cannot find an integrating factor or is \
unable to carry out the integrations, it returns the input line.\[ThickSpace]\
\[EmptySquare]"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The presented method of an integrating factor for first-order equations \
can be generalized to higher-order equations. This generalization is further \
discussed in S",
  ButtonBox["ection 4.4.2.2",
    ButtonData:>{"symmet3.nb", "Method of integrating factor"},
    ButtonStyle->"Hyperlink"],
  " for second-order and in S",
  ButtonBox["ection 4.4.3.1",
    ButtonData:>{"symmet4.nb", "Integrating factor method"},
    ButtonStyle->"Hyperlink"],
  " for higher-order equations. The method of an integrating factor was only \
useful in cases where we knew the infinitesimals. At the beginning of this \
section, we noted that the first-order equations have some peculiarities in \
determining the symmetries. The following section will discuss how this \
problem can be partially solved by introducing conformal symmetries or using \
heuristic ans\[ADoubleDot]tze for the infinitesimals."
}], "Text",
  CellTags->{"infinitesimals", "conformal symmetries"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
4.4.1.3 Infinitesimals of First-Order Ordinary Differential \
Equations\
\>", "Subsubsection",
  CellTags->"Infinitesimals of first order ordinary differential equations"],

Cell[TextData[
"The determination of infinitesimal transformations of first-order ordinary \
differential equations is a special problem in Lie\[CloseCurlyQuote]s theory. \
The problem is that first-order ordinary differential equations allow an \
infinite number of symmetries. This property is an essential obstacle in the \
calculation of the symmetries. The central point in a practical calculation \
is that the determining equations for the infinitesimals reduce to a \
first-order partial differential equation. Let us demonstrate this by the \
general equation of a first-order ODE:"], "Text",
  CellTags->{
  "determination of infinitesimal transformations", 
    "infinite number of symmetries"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ode11\  = \ \[PartialD]\_x u[x] - \ \[Omega][x, u[x]]; ode11 // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-\[Omega]\) + u\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Applying the function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  " of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to this ODE, we find a single first-order PDE for the two unknowns ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  ":"
}], "Text",
  CellTags->"DeterminingEquations[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeterminingEquations[{ode11}, {u}, {x}, {\[PartialD]\_x u[x]}] // LTF
      \)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Phi]\_1\)\ \[Omega]\_u - \[Xi]\_1\ \[Omega]\_x - 
                \[Omega]\^2\ \((\[Xi]\_1)\)\_u - 
                \[Omega]\ \((\[Xi]\_1)\)\_x + \[Omega]\ \((\[Phi]\_1)\)\_u + 
                \((\[Phi]\_1)\)\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
Such an equation has no unique solution in general. Thus, the \
problem is that we cannot derive an overdetermined system of determining \
equations allowing us to calculate the symmetries. This is due to the \
elimination of the first-order derivatives in the prolongation formula.\
\>", 
  "Text",
  CellTags->{
  "over determined system of determining equations", "prolongation formula"}],

Cell[TextData[{
  "To solve this difficulty, several approaches are discussed in the \
literature. The first and original, already discussed by Lie, is to use group \
classification, i.e., to find families of ODEs that are invariant under the \
group generated by a particular transformation. Most elementary methods are \
based on this idea. A more recent idea, suggested by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ", is to regard the first-order equation as an inappropriate reduction of a \
second-order ODE which has a solvable non-Abelian Lie algebra. This procedure \
will lead to hidden symmetries of type I. Hidden symmetries are used by ",
  ButtonBox["Abraham-Schrauner and Guo [1993]",
    ButtonData:>{"Literat.nb", "Abraham-Schrauner-93"},
    ButtonStyle->"Hyperlink"],
  " to classify families of ODEs."
}], "Text",
  CellTags->{
  "group classification", "families of ODEs", "particular transformation", 
    "solvable non-Abelian Lie algebra", "hidden symmetries"}],

Cell[TextData[{
  "Neither of the above methods is helpful when \[Omega] is given and the \
equation ",
  StyleBox["ode11",
    FontSlant->"Italic"],
  " does not belong to a family of ODEs having known point or hidden \
symmetries. A way out of this dilemma is a restriction of the admitted \
symmetries. Olver [1986] and ",
  ButtonBox["Hydon [1994]",
    ButtonData:>{"Literat.nb", "Hydon-1994"},
    ButtonStyle->"Hyperlink"],
  " introduced the term of a conformal symmetry. The background of this \
notion is that a vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector] = \[Sum]\+\(i = 1\)\%n \[Alpha]\_i\
\ \[PartialD]\_\(x\_i\)\)], "InlineFormula"],
  " generates a one-parameter group of conformal transformations if"
}], "Text",
  CellTags->{"conformal symmetry", "conformal transformations"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\[Alpha]\_i\/\[PartialD]x\_j\  + \ 
        \[PartialD]\[Alpha]\_j\/\[PartialD]x\_i\  = \ 0\)], "NumberedEquation"],

Cell["and ", "Text"],

Cell[BoxData[
    \(TextForm
    \`\[PartialD]\[Alpha]\_i\/\[PartialD]x\_i = \ \[CurlyPhi] \((x)\)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "for a certain function \[CurlyPhi](",
  StyleBox["x",
    FontSlant->"Italic"],
  "). The condition for a one-parameter group thus reduces to the \
Cauchy-Riemann equations"
}], "Text",
  CellTags->"one-parameter group"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Xi]\_x\), " ", "=", " ", 
        RowBox[{\(\[Phi]\_y\), "   ", "and", "   ", 
          FormBox[\(\[Xi]\_y\  = \ \(\(-\[Phi]\_x\) . \)\),
            "TraditionalForm"]}]}], TraditionalForm]], "NumberedEquation"],

Cell["In turn, the invariance condition simplifies to", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Phi]\_x\)(1 - \[Omega]\^2)\  - \[Xi]\ \[Omega]\_x\  - 
        \[Phi]\ \[Omega]\_y\  = \ 0. \)], "NumberedEquation"],

Cell[TextData[
"This relation is a result of Lie\[CloseCurlyQuote]s theorem on first-order \
differential equations."], "Text"],

Cell["Theorem: Symmetries of first-order ODEs", "Theorem",
  CellTags->"Theorem: Symmetries of first order ODEs"],

Cell[TextData[{
  "A first-order ODE ",
  Cell[BoxData[
      \(TraditionalForm\`u' = \[Omega](x, u)\)]],
  " allows a one-parameter group ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Xi] \[PartialD]\_x\(+\[Phi]\) \[PartialD]\_u\),
          "InlineFormula"], TraditionalForm]]],
  " if the relation"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FractionBox["d", 
              StyleBox["dx",
                FontSlant->"Italic"]], \((1\/\(\[Phi] - \[Omega]\[Xi]\))\)}], 
          " ", "+", " ", 
          RowBox[{
            FractionBox["d", 
              StyleBox["du",
                FontSlant->"Italic"]], 
            \((\[Omega]\/\(\[Phi] - \[Omega]\[Xi]\))\)}]}], " ", "=", "0"}], 
      TraditionalForm]], "NumberedEquation"],

Cell["or, equivalently,", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Phi]\_x + \((\[Phi]\_u - \[Xi]\_x)\)\ \[Omega]\  - \ 
        \(\[Xi]\_u\) \[Omega]\^2\  - \ 
        \[Xi]\ \[PartialD]\[Omega]\/\[PartialD]x - 
        \[Phi] \[PartialD]\[Omega]\/\[PartialD]u = 0\)], "NumberedEquation"],

Cell[TextData[{
  "holds for all values of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text"],

Cell[TextData[{
  "This theorem was given by Lie (Vol. 3, XIII, Theorem 1, ",
  ButtonBox["Engel and Heegaard [1912]",
    ButtonData:>{"Literat.nb", "Enge-12"},
    ButtonStyle->"Hyperlink"],
  ") to determine the infinitesimals of a first-order ODE."
}], "Text"],

Cell["Introducing in (4.43) the complex variables", "Text",
  CellTags->"complex variables"],

Cell[BoxData[
    \(TraditionalForm\`\(w = \[Phi] - i\ \[Xi], \ w\&_ = \[Phi] + i\ \[Xi], \ 
    \)\)], "NumberedEquation"],

Cell["and", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"z", "=", 
          RowBox[{"x", "+", 
            StyleBox["iu",
              FontSlant->"Italic"]}]}], ",", " ", 
        RowBox[{\(z\&_\), "=", 
          RowBox[{"x", "-", 
            StyleBox["iu",
              FontSlant->"Italic"]}]}]}], TextForm]], "NumberedEquation"],

Cell["and the real functions", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Mu](z, z\&_)\  = \ 
      arctan\ \((\ \[Omega](\(z + z\&_\)\/2, \(z - z\&_\)\/\(2  i\)))
            \)\ \ \ \ \ \ \ \ \ \ with\ \[Mu]\  \[Element] \ 
        \((\(-\(\[Pi]\/2\)\), \[Pi]\/2)\), \)\)], "NumberedEquation"],

Cell["the invariance condition reduces to", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"Im", "(", 
          RowBox[{
            RowBox[{\(i\/2\), 
              FractionBox[
                StyleBox["dw",
                  FontSlant->"Italic"], 
                StyleBox["dz",
                  FontSlant->"Italic"]]}], "+", " ", \(w\ \[Mu]\_z\)}], 
          ")"}], "=", "0."}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "The bars over ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " in relations (4.46)\[Dash](4.48) denote the complex conjugate values. \
Subscripts in these relations indicate a differentiation with respect to the \
variable."
}], "Text",
  CellTags->"complex conjugate value"],

Cell[TextData[{
  "The replacement of the variables ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`w\&_\)]],
  " by the functions"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Zeta](z) = 
      \(\[Integral]\(1\/\(w(z)\)\) \[DifferentialD]z\ \ \ and\ \ \ 
            \(\(\[Zeta]\&_\)(z\&_)\)\  = \ 
        \[Integral]\(1\/\(\(w\&_\)(z\&_)\)\) \[DifferentialD]z\&_\)\)], 
  "NumberedEquation"],

Cell["and the derivatives", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Zeta]' \((z)\)\), "=", 
        RowBox[{\(1\/\(w(z)\)\), "   ", "and", "   ", 
          FormBox[\(\[Zeta]\&_' \((z\&_)\)\  = \ 1\/\(\(w\&_\)(z\&_)\)\),
            "TraditionalForm"]}]}], TraditionalForm]], "NumberedEquation"],

Cell["allows the representation of the infinitesimals by", "Text",
  CellTags->"infinitesimals"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Xi]", " ", "=", " ", 
        RowBox[{
        \(\(Im(\[Zeta]' \((z)\))\)\/\(\[VerticalSeparator] \[Zeta]' \((z)\) 
                \[VerticalSeparator]\^2\)\), "   ", "and", "   ", 
          RowBox[{
            
            FormBox[\(\[Phi]\  = \ 
                \(Re(\[Zeta]' \((z)\))\)\/\(\[VerticalSeparator] \[Zeta]' 
                    \((z)\) \[VerticalSeparator]\^2\)\),
              "TraditionalForm"], "."}]}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell["\<\
In addition to the infinitesimals, the canonical variables are \
defined by\
\>", "Text",
  CellTags->"canonical variables"],

Cell[BoxData[
    \(TraditionalForm
    \`s\  = \ \ 
      \(\(\[Zeta](z)\  + \ \(\[Zeta]\&_\)(z\&_)\)\/2\  = \ 
        \[Integral]\(\[Phi] \[DifferentialD]x\  - 
              \[Xi] \[DifferentialD]u\)\/\(\[Xi]\^2 + \[Phi]\^2\)\)\)], 
  "NumberedEquation"],

Cell["and", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`t\  = \ \(\(\[Zeta](z)\  - \ \(\[Zeta]\&_\)(z\&_)\)\/\(2  i\)\  = \ 
        \[Integral]\(\[Xi] \[DifferentialD]x\  + 
              \[Phi] \[DifferentialD]u\)\/\(\[Xi]\^2 + \[Phi]\^2\) . \)\)], 
  "NumberedEquation"],

Cell[TextData[
"Relations (4.45)\[Dash](4.53) are helpful to reformulate Lie\
\[CloseCurlyQuote]s theorem on infinitesimal symmetries."], "Text",
  CellTags->"infinitesimal symmetries"],

Cell["Theorem: Conformal symmetries", "Theorem",
  CellTags->"Theorem: Conformal Symmetries"],

Cell[TextData[{
  "A first-order ordinary differential equation ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(u'\  = \ \(\[Omega](x, u)\  = \)\),
          "InlineFormula"], TraditionalForm]]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["tan",
            "InlineFormula"], 
          StyleBox["(",
            "InlineFormula"], 
          RowBox[{
            StyleBox["\[Mu]",
              "InlineFormula"], 
            StyleBox["(",
              "InlineFormula"], 
            RowBox[{
              RowBox[{
                StyleBox["x",
                  "InlineFormula"], 
                StyleBox["+",
                  "InlineFormula"], 
                StyleBox["iu",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                "InlineFormula"], 
              RowBox[{
                StyleBox["x",
                  "InlineFormula"], 
                StyleBox["-",
                  "InlineFormula"], 
                StyleBox["iu",
                  FontSlant->"Italic"]}]}], 
            StyleBox[")",
              "InlineFormula"]}], 
          StyleBox[")",
            "InlineFormula"]}], TraditionalForm]]],
  " allows a one-parameter group of conformal transformations if"
}], "Text",
  CellTags->"conformal transformations"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Mu](z, z\&_)\  = \ 
      F(r)\  + \ \(i\/2\) \(ln(\[Zeta]' \((z)\))\)\  - \ 
        \(i\/2\) ln  \[Zeta]\&_' \((z\&_)\), \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is a real function and \[Zeta] an analytic complex function.\[ThickSpace]\
\[EmptyCircle]"
}], "Text"],

Cell["\<\
If we know the conformal symmetries, we also know the general \
solution of the equation. The solution follows either from the theorem on an \
integrating factor or via canonical variables.\
\>", "Text",
  CellTags->{
  "conformal symmetries", "integrating factor", "canonical variables"}],

Cell["\<\
So far, we have discussed symmetries and solution procedures of \
first-order ODEs. The problem of first-order ODEs was the assessment of the \
infinitesimal transformation. This problem dissolves if we consider ODEs of \
higher order. In the following section, we discuss the solution of \
second-order ODEs by utilizing symmetry methods.\
\>", "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet3.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
AutoGeneratedPackage->Automatic,
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{663, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->151,
PrintingPageRange->{148, 148},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Symmetries of Ordinary Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Analysis of Ordinary Differential Equations"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintingMargins"->{{99, 99}, {180, 59}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Analysis of Ordinary Differential Equations"->{
    Cell[1739, 51, 425, 6, 43, "Section",
      Evaluatable->False,
      CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 31}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Analysis of Ordinary Differential Equations"]},
  "infinitesimals"->{
    Cell[2167, 59, 1157, 23, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimals", "invariance condition", 
        "linear determining equations", "determining equations", 
        "computer algebra"}],
    Cell[24222, 1190, 1190, 24, 130, "Text",
      CellTags->{
      "symmetry transformation", "transformation", 
        "map solutions into solutions", "vector field", "infinitesimals", 
        "target curve"}],
    Cell[632251, 14109, 389, 6, 61, "Text",
      CellTags->{"infinitesimals", "manifold"}],
    Cell[634364, 14202, 164, 6, 27, "Text",
      CellTags->"infinitesimals"],
    Cell[730168, 18777, 1106, 25, 95, "Text",
      PageBreakWithin->True,
      CellTags->{
      "infinitesimals", "solutions of first-order differential equations", 
        "infinitesimal transformation", "invariance condition"}],
    Cell[732189, 18838, 540, 13, 61, "Text",
      Evaluatable->False,
      CellTags->{"polynomial", "infinitesimals"}],
    Cell[744670, 19257, 977, 18, 112, "Text",
      CellTags->{"infinitesimals", "conformal symmetries"}],
    Cell[755622, 19586, 96, 1, 27, "Text",
      CellTags->"infinitesimals"]},
  "invariance condition"->{
    Cell[2167, 59, 1157, 23, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimals", "invariance condition", 
        "linear determining equations", "determining equations", 
        "computer algebra"}],
    Cell[730168, 18777, 1106, 25, 95, "Text",
      PageBreakWithin->True,
      CellTags->{
      "infinitesimals", "solutions of first-order differential equations", 
        "infinitesimal transformation", "invariance condition"}]},
  "linear determining equations"->{
    Cell[2167, 59, 1157, 23, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimals", "invariance condition", 
        "linear determining equations", "determining equations", 
        "computer algebra"}]},
  "determining equations"->{
    Cell[2167, 59, 1157, 23, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimals", "invariance condition", 
        "linear determining equations", "determining equations", 
        "computer algebra"}]},
  "computer algebra"->{
    Cell[2167, 59, 1157, 23, 112, "Text",
      Evaluatable->False,
      CellTags->{
      "infinitesimals", "invariance condition", 
        "linear determining equations", "determining equations", 
        "computer algebra"}]},
  "first-order differential equation"->{
    Cell[3327, 84, 538, 10, 78, "Text",
      CellTags->{
      "first-order differential equation", "infinite number of symmetries", 
        "point symmetries", "conformal symmetries"}],
    Cell[26518, 1249, 253, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"first-order differential equation"]},
  "infinite number of symmetries"->{
    Cell[3327, 84, 538, 10, 78, "Text",
      CellTags->{
      "first-order differential equation", "infinite number of symmetries", 
        "point symmetries", "conformal symmetries"}],
    Cell[4585, 121, 943, 21, 112, "Text",
      CellTags->{
      "point symmetries", "infinite number of symmetries", 
        "geometrical interpretation of first-order ODE"}],
    Cell[745868, 19286, 706, 11, 95, "Text",
      CellTags->{
      "determination of infinitesimal transformations", 
        "infinite number of symmetries"}]},
  "point symmetries"->{
    Cell[3327, 84, 538, 10, 78, "Text",
      CellTags->{
      "first-order differential equation", "infinite number of symmetries", 
        "point symmetries", "conformal symmetries"}],
    Cell[4585, 121, 943, 21, 112, "Text",
      CellTags->{
      "point symmetries", "infinite number of symmetries", 
        "geometrical interpretation of first-order ODE"}]},
  "conformal symmetries"->{
    Cell[3327, 84, 538, 10, 78, "Text",
      CellTags->{
      "first-order differential equation", "infinite number of symmetries", 
        "point symmetries", "conformal symmetries"}],
    Cell[744670, 19257, 977, 18, 112, "Text",
      CellTags->{"infinitesimals", "conformal symmetries"}],
    Cell[758901, 19692, 299, 6, 44, "Text",
      CellTags->{
      "conformal symmetries", "integrating factor", "canonical variables"}]},
  "First order equations"->{
    Cell[3890, 98, 86, 1, 41, "Subsection",
      CellTags->"First order equations"]},
  "first-order ordinary differential equation"->{
    Cell[3979, 101, 170, 4, 27, "Text",
      CellTags->"first-order ordinary differential equation"],
    Cell[620563, 13714, 1041, 20, 112, "Text",
      CellTags->{
      "method of an integrating factor", 
        "first-order ordinary differential equation", "tangent vector", 
        "integral curves", "solutions"}]},
  "geometrical interpretation of first-order ODE"->{
    Cell[4585, 121, 943, 21, 112, "Text",
      CellTags->{
      "point symmetries", "infinite number of symmetries", 
        "geometrical interpretation of first-order ODE"}]},
  "symmetry transformation"->{
    Cell[24222, 1190, 1190, 24, 130, "Text",
      CellTags->{
      "symmetry transformation", "transformation", 
        "map solutions into solutions", "vector field", "infinitesimals", 
        "target curve"}]},
  "transformation"->{
    Cell[24222, 1190, 1190, 24, 130, "Text",
      CellTags->{
      "symmetry transformation", "transformation", 
        "map solutions into solutions", "vector field", "infinitesimals", 
        "target curve"}]},
  "map solutions into solutions"->{
    Cell[24222, 1190, 1190, 24, 130, "Text",
      CellTags->{
      "symmetry transformation", "transformation", 
        "map solutions into solutions", "vector field", "infinitesimals", 
        "target curve"}]},
  "vector field"->{
    Cell[24222, 1190, 1190, 24, 130, "Text",
      CellTags->{
      "symmetry transformation", "transformation", 
        "map solutions into solutions", "vector field", "infinitesimals", 
        "target curve"}]},
  "target curve"->{
    Cell[24222, 1190, 1190, 24, 130, "Text",
      CellTags->{
      "symmetry transformation", "transformation", 
        "map solutions into solutions", "vector field", "infinitesimals", 
        "target curve"}]},
  "skeleton of differential equation"->{
    Cell[25547, 1222, 136, 2, 20, "ListItem",
      Evaluatable->False,
      CellTags->"skeleton of differential equation"]},
  "solution manifold"->{
    Cell[25686, 1226, 102, 2, 20, "ListItem",
      Evaluatable->False,
      CellTags->"solution manifold"]},
  "extended manifold"->{
    Cell[25791, 1230, 549, 11, 61, "Text",
      Evaluatable->False,
      CellTags->{"extended manifold", "skeleton"}],
    Cell[28321, 1317, 533, 7, 78, "Text",
      CellTags->{"manifold", "extended manifold", "class of solutions"}]},
  "skeleton"->{
    Cell[25791, 1230, 549, 11, 61, "Text",
      Evaluatable->False,
      CellTags->{"extended manifold", "skeleton"}],
    Cell[27582, 1288, 736, 27, 62, "Text",
      Evaluatable->False,
      CellTags->"skeleton"],
    Cell[139168, 3983, 187, 5, 27, "Text",
      Evaluatable->False,
      CellTags->{"skeleton", "skeleton graphical representation"}],
    Cell[267805, 6400, 166, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"skeleton"],
    Cell[447402, 10117, 435, 10, 61, "Text",
      Evaluatable->False,
      CellTags->{"skeleton", "concave surface"}],
    Cell[449922, 10195, 165, 4, 27, "Text",
      CellTags->"skeleton"],
    Cell[731810, 18821, 229, 6, 44, "Text",
      Evaluatable->False,
      CellTags->{"Riccati equation", "skeleton"}]},
  "The skeleton of an ordinary differential equation"->{
    Cell[26365, 1245, 150, 2, 31, "Subsubsection",
      CellTags->"The skeleton of an ordinary differential equation"]},
  "Definition: The Skeleton"->{
    Cell[27274, 1275, 86, 1, 33, "Definition",
      CellTags->"Definition: The Skeleton"]},
  "surface"->{
    Cell[27363, 1278, 136, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"surface"]},
  "manifold"->{
    Cell[28321, 1317, 533, 7, 78, "Text",
      CellTags->{"manifold", "extended manifold", "class of solutions"}],
    Cell[632251, 14109, 389, 6, 61, "Text",
      CellTags->{"infinitesimals", "manifold"}]},
  "class of solutions"->{
    Cell[28321, 1317, 533, 7, 78, "Text",
      CellTags->{"manifold", "extended manifold", "class of solutions"}]},
  "Definition: A Class of Solutions"->{
    Cell[28984, 1331, 102, 1, 33, "Definition",
      CellTags->"Definition: A Class of Solutions"]},
  "simplification of the skeleton"->{
    Cell[30169, 1371, 823, 19, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "simplification of the skeleton", "change of variables", 
        "canonical variables"}]},
  "change of variables"->{
    Cell[30169, 1371, 823, 19, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "simplification of the skeleton", "change of variables", 
        "canonical variables"}]},
  "canonical variables"->{
    Cell[30169, 1371, 823, 19, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "simplification of the skeleton", "change of variables", 
        "canonical variables"}],
    Cell[268534, 6429, 594, 17, 47, "Text",
      Evaluatable->False,
      CellTags->{"global transformation", "canonical variables"}],
    Cell[447840, 10129, 609, 10, 95, "Text",
      CellTags->{
      "canonical transformation simplifies the skeleton", 
        "canonical variables"}],
    Cell[540206, 11739, 346, 8, 44, "Text",
      CellTags->"canonical variables"],
    Cell[543530, 11818, 385, 9, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "Riccati equation", "inhomogeneous scaling transformation", 
        "canonical variables"}],
    Cell[548471, 12008, 358, 10, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "canonical variables", "separation of variables", 
        "integration by separation of variables"}],
    Cell[617628, 13607, 157, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"canonical variables"],
    Cell[619260, 13680, 699, 15, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "canonical variables", "first-order equations", 
        "method of canonical variables"}],
    Cell[756237, 19603, 134, 4, 27, "Text",
      CellTags->"canonical variables"],
    Cell[758901, 19692, 299, 6, 44, "Text",
      CellTags->{
      "conformal symmetries", "integrating factor", "canonical variables"}]},
  "Riccati equation"->{
    Cell[31026, 1394, 104, 1, 27, "Text",
      CellTags->"Riccati equation"],
    Cell[448886, 10158, 592, 17, 61, "Text",
      Evaluatable->False,
      CellTags->"Riccati equation"],
    Cell[543530, 11818, 385, 9, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "Riccati equation", "inhomogeneous scaling transformation", 
        "canonical variables"}],
    Cell[731810, 18821, 229, 6, 44, "Text",
      Evaluatable->False,
      CellTags->{"Riccati equation", "skeleton"}]},
  "skeleton of the Riccati equation"->{
    Cell[31657, 1418, 170, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"skeleton of the Riccati equation"],
    Cell[135402, 3853, 126, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"skeleton of the Riccati equation"]},
  "hyperbolic paraboloid"->{
    Cell[31889, 1428, 260, 8, 44, "Text",
      Evaluatable->False,
      CellTags->"hyperbolic paraboloid"]},
  "skeleton-Riccati"->{
    Cell[32318, 1445, 416, 7, 118, "Input",
      CellTags->"skeleton-Riccati"]},
  "parabolic surface"->{
    Cell[127257, 3581, 1064, 27, 112, "Text",
      CellTags->{
      "parabolic surface", "scaling transformation", 
        "non-homogeneous dilation"}]},
  "scaling transformation"->{
    Cell[127257, 3581, 1064, 27, 112, "Text",
      CellTags->{
      "parabolic surface", "scaling transformation", 
        "non-homogeneous dilation"}]},
  "non-homogeneous dilation"->{
    Cell[127257, 3581, 1064, 27, 112, "Text",
      CellTags->{
      "parabolic surface", "scaling transformation", 
        "non-homogeneous dilation"}],
    Cell[448452, 10141, 204, 5, 44, "Text",
      CellTags->"non-homogeneous dilation"]},
  "invariance of the Riccati equation"->{
    Cell[128610, 3621, 236, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"invariance of the Riccati equation"]},
  "scaling factor"->{
    Cell[129792, 3663, 621, 22, 61, "Text",
      Evaluatable->False,
      CellTags->"scaling factor"]},
  "invariant skeleton"->{
    Cell[133335, 3785, 1940, 61, 78, "Text",
      CellTags->{
      "invariant skeleton", "inhomogeneous stretching", 
        "extended vector field"}]},
  "inhomogeneous stretching"->{
    Cell[133335, 3785, 1940, 61, 78, "Text",
      CellTags->{
      "invariant skeleton", "inhomogeneous stretching", 
        "extended vector field"}]},
  "extended vector field"->{
    Cell[133335, 3785, 1940, 61, 78, "Text",
      CellTags->{
      "invariant skeleton", "inhomogeneous stretching", 
        "extended vector field"}]},
  "inhomogeneous scaling transformation"->{
    Cell[137271, 3922, 257, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"inhomogeneous scaling transformation"],
    Cell[543530, 11818, 385, 9, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "Riccati equation", "inhomogeneous scaling transformation", 
        "canonical variables"}]},
  "scaling[]"->{
    Cell[138294, 3951, 213, 6, 29, "Text",
      Evaluatable->False,
      CellTags->"scaling[]"]},
  "skeleton graphical representation"->{
    Cell[139168, 3983, 187, 5, 27, "Text",
      Evaluatable->False,
      CellTags->{"skeleton", "skeleton graphical representation"}]},
  "canonical transformation"->{
    Cell[178175, 4849, 272, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"canonical transformation"],
    Cell[546293, 11920, 182, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"canonical transformation"],
    Cell[549159, 12032, 272, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"canonical transformation"]},
  "third-order parabola"->{
    Cell[267390, 6387, 381, 9, 44, "Text",
      Evaluatable->False,
      CellTags->"third-order parabola"]},
  "global transformation"->{
    Cell[268534, 6429, 594, 17, 47, "Text",
      Evaluatable->False,
      CellTags->{"global transformation", "canonical variables"}]},
  "concave surface"->{
    Cell[447402, 10117, 435, 10, 61, "Text",
      Evaluatable->False,
      CellTags->{"skeleton", "concave surface"}]},
  "canonical transformation simplifies the skeleton"->{
    Cell[447840, 10129, 609, 10, 95, "Text",
      CellTags->{
      "canonical transformation simplifies the skeleton", 
        "canonical variables"}]},
  "cylindrical surface"->{
    Cell[450151, 10204, 369, 14, 44, "Text",
      Evaluatable->False,
      CellTags->"cylindrical surface"]},
  "CanonicalVariables[]"->{
    Cell[540555, 11749, 1304, 32, 114, "Text",
      CellTags->{"CanonicalVariables[]", "CanonicalRepresentation[]"}]},
  "CanonicalRepresentation[]"->{
    Cell[540555, 11749, 1304, 32, 114, "Text",
      CellTags->{"CanonicalVariables[]", "CanonicalRepresentation[]"}],
    Cell[541862, 11783, 1665, 33, 280, "Input",
      CellTags->"CanonicalRepresentation[]"]},
  "reduce the Riccati equation"->{
    Cell[544177, 11840, 212, 5, 44, "Text",
      Evaluatable->False,
      CellTags->"reduce the Riccati equation"]},
  "separation of variables"->{
    Cell[545687, 11897, 347, 10, 48, "Text",
      Evaluatable->False,
      CellTags->{"separation of variables", "quadrature", "DSolve[]"}],
    Cell[548471, 12008, 358, 10, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "canonical variables", "separation of variables", 
        "integration by separation of variables"}]},
  "quadrature"->{
    Cell[545687, 11897, 347, 10, 48, "Text",
      Evaluatable->False,
      CellTags->{"separation of variables", "quadrature", "DSolve[]"}],
    Cell[627819, 13963, 254, 5, 44, "Text",
      CellTags->"quadrature"],
    Cell[743103, 19200, 197, 5, 27, "Text",
      Evaluatable->False,
      CellTags->{"integrating factor", "quadrature"}]},
  "DSolve[]"->{
    Cell[545687, 11897, 347, 10, 48, "Text",
      Evaluatable->False,
      CellTags->{"separation of variables", "quadrature", "DSolve[]"}],
    Cell[742450, 19172, 311, 12, 29, "Text",
      Evaluatable->False,
      CellTags->"DSolve[]"]},
  "implicit solution"->{
    Cell[546848, 11942, 192, 7, 27, "Text",
      Evaluatable->False,
      CellTags->"implicit solution"],
    Cell[741292, 19126, 391, 12, 46, "Text",
      Evaluatable->False,
      CellTags->{"implicit solution", "IntegratingFactor[]"}]},
  "scaling symmetries"->{
    Cell[547276, 11962, 194, 5, 44, "Text",
      Evaluatable->False,
      CellTags->"scaling symmetries"]},
  "integration by separation of variables"->{
    Cell[548471, 12008, 358, 10, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "canonical variables", "separation of variables", 
        "integration by separation of variables"}]},
  "graphical representation of the solution"->{
    Cell[549723, 12051, 336, 9, 44, "Text",
      Evaluatable->False,
      CellTags->"graphical representation of the solution"]},
  "first-order equations"->{
    Cell[619260, 13680, 699, 15, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "canonical variables", "first-order equations", 
        "method of canonical variables"}]},
  "method of canonical variables"->{
    Cell[619260, 13680, 699, 15, 78, "Text",
      Evaluatable->False,
      CellTags->{
      "canonical variables", "first-order equations", 
        "method of canonical variables"}]},
  "integrating factor"->{
    Cell[619962, 13697, 476, 9, 78, "Text",
      Evaluatable->False,
      CellTags->"integrating factor"],
    Cell[626584, 13919, 658, 21, 61, "Text",
      CellTags->{"integrating factor", "integral curve"}],
    Cell[627494, 13953, 322, 8, 44, "Text",
      CellTags->"integrating factor"],
    Cell[629267, 14009, 823, 26, 27, "Text",
      CellTags->"integrating factor"],
    Cell[634693, 14218, 179, 3, 27, "Text",
      CellTags->"integrating factor"],
    Cell[732926, 18862, 196, 4, 27, "Text",
      Evaluatable->False,
      CellTags->"integrating factor"],
    Cell[743103, 19200, 197, 5, 27, "Text",
      Evaluatable->False,
      CellTags->{"integrating factor", "quadrature"}],
    Cell[758901, 19692, 299, 6, 44, "Text",
      CellTags->{
      "conformal symmetries", "integrating factor", "canonical variables"}]},
  "Integrating factor"->{
    Cell[620475, 13711, 85, 1, 31, "Subsubsection",
      CellTags->"Integrating factor"]},
  "method of an integrating factor"->{
    Cell[620563, 13714, 1041, 20, 112, "Text",
      CellTags->{
      "method of an integrating factor", 
        "first-order ordinary differential equation", "tangent vector", 
        "integral curves", "solutions"}]},
  "tangent vector"->{
    Cell[620563, 13714, 1041, 20, 112, "Text",
      CellTags->{
      "method of an integrating factor", 
        "first-order ordinary differential equation", "tangent vector", 
        "integral curves", "solutions"}]},
  "integral curves"->{
    Cell[620563, 13714, 1041, 20, 112, "Text",
      CellTags->{
      "method of an integrating factor", 
        "first-order ordinary differential equation", "tangent vector", 
        "integral curves", "solutions"}],
    Cell[622289, 13767, 388, 13, 27, "Text",
      CellTags->"integral curves"]},
  "solutions"->{
    Cell[620563, 13714, 1041, 20, 112, "Text",
      CellTags->{
      "method of an integrating factor", 
        "first-order ordinary differential equation", "tangent vector", 
        "integral curves", "solutions"}]},
  "infinitesimal transformation"->{
    Cell[623042, 13798, 402, 11, 44, "Text",
      CellTags->"infinitesimal transformation"],
    Cell[624415, 13851, 361, 8, 44, "Text",
      CellTags->{"invariant curve", "infinitesimal transformation"}],
    Cell[730168, 18777, 1106, 25, 95, "Text",
      PageBreakWithin->True,
      CellTags->{
      "infinitesimals", "solutions of first-order differential equations", 
        "infinitesimal transformation", "invariance condition"}]},
  "invariant curve"->{
    Cell[624415, 13851, 361, 8, 44, "Text",
      CellTags->{"invariant curve", "infinitesimal transformation"}]},
  "integral curve"->{
    Cell[625773, 13892, 531, 15, 61, "Text",
      CellTags->{"integral curve", "total differential"}],
    Cell[626584, 13919, 658, 21, 61, "Text",
      CellTags->{"integrating factor", "integral curve"}]},
  "total differential"->{
    Cell[625773, 13892, 531, 15, 61, "Text",
      CellTags->{"integral curve", "total differential"}],
    Cell[635002, 14232, 108, 1, 27, "Text",
      CellTags->"total differential"]},
  "Theorem: Integrating Factor"->{
    Cell[628076, 13970, 89, 1, 33, "Theorem",
      CellTags->"Theorem: Integrating Factor"]},
  "one parameter group"->{
    Cell[628570, 13987, 588, 16, 27, "Text",
      CellTags->"one parameter group"]},
  "determinant"->{
    Cell[630575, 14052, 130, 4, 27, "Text",
      CellTags->"determinant"]},
  "ImplicitPlot[]"->{
    Cell[636118, 14274, 652, 21, 63, "Text",
      CellTags->"ImplicitPlot[]"]},
  "Graphics`ImplicitPlot`"->{
    Cell[636773, 14297, 102, 2, 23, "Input",
      CellTags->"Graphics`ImplicitPlot`"]},
  "solutions of first-order differential equations"->{
    Cell[730168, 18777, 1106, 25, 95, "Text",
      PageBreakWithin->True,
      CellTags->{
      "infinitesimals", "solutions of first-order differential equations", 
        "infinitesimal transformation", "invariance condition"}]},
  "integrating factor theorem"->{
    Cell[731277, 18804, 499, 13, 61, "Text",
      Evaluatable->False,
      CellTags->"integrating factor theorem"]},
  "polynomial"->{
    Cell[732189, 18838, 540, 13, 61, "Text",
      Evaluatable->False,
      CellTags->{"polynomial", "infinitesimals"}]},
  "IntegratingFactor[]"->{
    Cell[736128, 19001, 573, 12, 80, "Text",
      Evaluatable->False,
      CellTags->"IntegratingFactor[]"],
    Cell[736704, 19015, 3626, 71, 570, "Input",
      CellTags->"IntegratingFactor[]"],
    Cell[741292, 19126, 391, 12, 46, "Text",
      Evaluatable->False,
      CellTags->{"implicit solution", "IntegratingFactor[]"}],
    Cell[743719, 19224, 181, 6, 29, "Text",
      Evaluatable->False,
      CellTags->"IntegratingFactor[]"]},
  "Log[]"->{
    Cell[741871, 19149, 326, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"Log[]"]},
  "Infinitesimals of first order ordinary differential equations"->{
    Cell[745684, 19280, 181, 4, 31, "Subsubsection",
      CellTags->
      "Infinitesimals of first order ordinary differential equations"]},
  "determination of infinitesimal transformations"->{
    Cell[745868, 19286, 706, 11, 95, "Text",
      CellTags->{
      "determination of infinitesimal transformations", 
        "infinite number of symmetries"}]},
  "DeterminingEquations[]"->{
    Cell[746964, 19316, 402, 14, 46, "Text",
      CellTags->"DeterminingEquations[]"]},
  "over determined system of determining equations"->{
    Cell[747972, 19353, 401, 8, 61, "Text",
      CellTags->{
      "over determined system of determining equations", 
        "prolongation formula"}]},
  "prolongation formula"->{
    Cell[747972, 19353, 401, 8, 61, "Text",
      CellTags->{
      "over determined system of determining equations", 
        "prolongation formula"}]},
  "group classification"->{
    Cell[748376, 19363, 1049, 19, 112, "Text",
      CellTags->{
      "group classification", "families of ODEs", "particular transformation",
         "solvable non-Abelian Lie algebra", "hidden symmetries"}]},
  "families of ODEs"->{
    Cell[748376, 19363, 1049, 19, 112, "Text",
      CellTags->{
      "group classification", "families of ODEs", "particular transformation",
         "solvable non-Abelian Lie algebra", "hidden symmetries"}]},
  "particular transformation"->{
    Cell[748376, 19363, 1049, 19, 112, "Text",
      CellTags->{
      "group classification", "families of ODEs", "particular transformation",
         "solvable non-Abelian Lie algebra", "hidden symmetries"}]},
  "solvable non-Abelian Lie algebra"->{
    Cell[748376, 19363, 1049, 19, 112, "Text",
      CellTags->{
      "group classification", "families of ODEs", "particular transformation",
         "solvable non-Abelian Lie algebra", "hidden symmetries"}]},
  "hidden symmetries"->{
    Cell[748376, 19363, 1049, 19, 112, "Text",
      CellTags->{
      "group classification", "families of ODEs", "particular transformation",
         "solvable non-Abelian Lie algebra", "hidden symmetries"}]},
  "conformal symmetry"->{
    Cell[749428, 19384, 824, 18, 78, "Text",
      CellTags->{"conformal symmetry", "conformal transformations"}]},
  "conformal transformations"->{
    Cell[749428, 19384, 824, 18, 78, "Text",
      CellTags->{"conformal symmetry", "conformal transformations"}],
    Cell[757203, 19634, 1312, 42, 44, "Text",
      CellTags->"conformal transformations"]},
  "one-parameter group"->{
    Cell[750577, 19416, 239, 7, 44, "Text",
      CellTags->"one-parameter group"]},
  "Theorem: Symmetries of first order ODEs"->{
    Cell[751441, 19443, 113, 1, 33, "Theorem",
      CellTags->"Theorem: Symmetries of first order ODEs"]},
  "complex variables"->{
    Cell[753139, 19501, 92, 1, 27, "Text",
      CellTags->"complex variables"]},
  "complex conjugate value"->{
    Cell[754481, 19546, 359, 11, 44, "Text",
      CellTags->"complex conjugate value"]},
  "infinitesimal symmetries"->{
    Cell[756919, 19626, 185, 3, 27, "Text",
      CellTags->"infinitesimal symmetries"]},
  "Theorem: Conformal Symmetries"->{
    Cell[757107, 19631, 93, 1, 33, "Theorem",
      CellTags->"Theorem: Conformal Symmetries"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Analysis of Ordinary Differential Equations", 761672, 19768},
  {"infinitesimals", 762067, 19776},
  {"invariance condition", 763257, 19804},
  {"linear determining equations", 763760, 19816},
  {"determining equations", 764021, 19823},
  {"computer algebra", 764277, 19830},
  {"first-order differential equation", 764550, 19837},
  {"infinite number of symmetries", 764899, 19845},
  {"point symmetries", 765455, 19858},
  {"conformal symmetries", 765852, 19867},
  {"First order equations", 766317, 19877},
  {"first-order ordinary differential equation", 766454, 19880},
  {"geometrical interpretation of first-order ODE", 766833, 19888},
  {"symmetry transformation", 767044, 19893},
  {"transformation", 767283, 19899},
  {"map solutions into solutions", 767536, 19905},
  {"vector field", 767773, 19911},
  {"target curve", 768010, 19917},
  {"skeleton of differential equation", 768268, 19923},
  {"solution manifold", 768420, 19927},
  {"extended manifold", 768556, 19931},
  {"skeleton", 768810, 19937},
  {"The skeleton of an ordinary differential equation", 769637, 19958},
  {"Definition: The Skeleton", 769791, 19961},
  {"surface", 769899, 19964},
  {"manifold", 770012, 19968},
  {"class of solutions", 770248, 19973},
  {"Definition: A Class of Solutions", 770405, 19976},
  {"simplification of the skeleton", 770545, 19979},
  {"change of variables", 770757, 19985},
  {"canonical variables", 770969, 19991},
  {"Riccati equation", 772460, 20029},
  {"skeleton of the Riccati equation", 772997, 20043},
  {"hyperbolic paraboloid", 773270, 20050},
  {"skeleton-Riccati", 773405, 20054},
  {"parabolic surface", 773512, 20057},
  {"scaling transformation", 773699, 20062},
  {"non-homogeneous dilation", 773888, 20067},
  {"invariance of the Riccati equation", 774176, 20074},
  {"scaling factor", 774323, 20078},
  {"invariant skeleton", 774455, 20082},
  {"inhomogeneous stretching", 774643, 20087},
  {"extended vector field", 774828, 20092},
  {"inhomogeneous scaling transformation", 775028, 20097},
  {"scaling[]", 775360, 20106},
  {"skeleton graphical representation", 775501, 20110},
  {"canonical transformation", 775671, 20114},
  {"third-order parabola", 776044, 20124},
  {"global transformation", 776184, 20128},
  {"concave surface", 776345, 20132},
  {"canonical transformation simplifies the skeleton", 776523, 20136},
  {"cylindrical surface", 776706, 20141},
  {"CanonicalVariables[]", 776846, 20145},
  {"CanonicalRepresentation[]", 776999, 20148},
  {"reduce the Riccati equation", 777248, 20153},
  {"separation of variables", 777398, 20157},
  {"quadrature", 777758, 20166},
  {"DSolve[]", 778118, 20175},
  {"implicit solution", 778387, 20182},
  {"scaling symmetries", 778656, 20189},
  {"integration by separation of variables", 778812, 20193},
  {"graphical representation of the solution", 779059, 20199},
  {"first-order equations", 779220, 20203},
  {"method of canonical variables", 779445, 20209},
  {"integrating factor", 779659, 20215},
  {"Integrating factor", 780522, 20236},
  {"method of an integrating factor", 780653, 20239},
  {"tangent vector", 780898, 20245},
  {"integral curves", 781144, 20251},
  {"solutions", 781465, 20259},
  {"infinitesimal transformation", 781724, 20265},
  {"invariant curve", 782191, 20275},
  {"integral curve", 782328, 20278},
  {"total differential", 782563, 20283},
  {"Theorem: Integrating Factor", 782786, 20288},
  {"one parameter group", 782908, 20291},
  {"determinant", 783013, 20294},
  {"ImplicitPlot[]", 783112, 20297},
  {"Graphics`ImplicitPlot`", 783223, 20300},
  {"solutions of first-order differential equations", 783367, 20303},
  {"integrating factor theorem", 783637, 20309},
  {"polynomial", 783774, 20313},
  {"IntegratingFactor[]", 783924, 20317},
  {"Log[]", 784381, 20329},
  {"Infinitesimals of first order ordinary differential equations", 784548, \
20333},
  {"determination of infinitesimal transformations", 784745, 20337},
  {"DeterminingEquations[]", 784939, 20342},
  {"over determined system of determining equations", 785083, 20345},
  {"prolongation formula", 785266, 20350},
  {"group classification", 785449, 20355},
  {"families of ODEs", 785686, 20360},
  {"particular transformation", 785932, 20365},
  {"solvable non-Abelian Lie algebra", 786185, 20370},
  {"hidden symmetries", 786423, 20375},
  {"conformal symmetry", 786662, 20380},
  {"conformal transformations", 786811, 20383},
  {"one-parameter group", 787046, 20388},
  {"Theorem: Symmetries of first order ODEs", 787178, 20391},
  {"complex variables", 787311, 20394},
  {"complex conjugate value", 787424, 20397},
  {"infinitesimal symmetries", 787546, 20400},
  {"Theorem: Conformal Symmetries", 787673, 20403}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 425, 6, 43, "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 31}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Analysis of Ordinary Differential Equations"],
Cell[2167, 59, 1157, 23, 112, "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimals", "invariance condition", "linear determining equations", 
    "determining equations", "computer algebra"}],
Cell[3327, 84, 538, 10, 78, "Text",
  CellTags->{
  "first-order differential equation", "infinite number of symmetries", 
    "point symmetries", "conformal symmetries"}],

Cell[CellGroupData[{
Cell[3890, 98, 86, 1, 41, "Subsection",
  CellTags->"First order equations"],
Cell[3979, 101, 170, 4, 27, "Text",
  CellTags->"first-order ordinary differential equation"],
Cell[4152, 107, 430, 12, 35, "NumberedEquation"],
Cell[4585, 121, 943, 21, 112, "Text",
  CellTags->{
  "point symmetries", "infinite number of symmetries", 
    "geometrical interpretation of first-order ODE"}],
Cell[5531, 144, 18688, 1044, 163, 10001, 924, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[24222, 1190, 1190, 24, 130, "Text",
  CellTags->{
  "symmetry transformation", "transformation", "map solutions into solutions",
     "vector field", "infinitesimals", "target curve"}],
Cell[25415, 1216, 129, 4, 27, "Text",
  Evaluatable->False],
Cell[25547, 1222, 136, 2, 20, "ListItem",
  Evaluatable->False,
  CellTags->"skeleton of differential equation"],
Cell[25686, 1226, 102, 2, 20, "ListItem",
  Evaluatable->False,
  CellTags->"solution manifold"],
Cell[25791, 1230, 549, 11, 61, "Text",
  Evaluatable->False,
  CellTags->{"extended manifold", "skeleton"}],

Cell[CellGroupData[{
Cell[26365, 1245, 150, 2, 31, "Subsubsection",
  CellTags->"The skeleton of an ordinary differential equation"],
Cell[26518, 1249, 253, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"first-order differential equation"],
Cell[26774, 1257, 89, 1, 22, "NumberedEquation"],
Cell[26866, 1260, 405, 13, 45, "Text",
  Evaluatable->False],
Cell[27274, 1275, 86, 1, 33, "Definition",
  CellTags->"Definition: The Skeleton"],
Cell[27363, 1278, 136, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"surface"],
Cell[27502, 1285, 77, 1, 22, "NumberedEquation"],
Cell[27582, 1288, 736, 27, 62, "Text",
  Evaluatable->False,
  CellTags->"skeleton"],
Cell[28321, 1317, 533, 7, 78, "Text",
  CellTags->{"manifold", "extended manifold", "class of solutions"}],
Cell[28857, 1326, 124, 3, 27, "Text"],
Cell[28984, 1331, 102, 1, 33, "Definition",
  CellTags->"Definition: A Class of Solutions"],
Cell[29089, 1334, 1077, 35, 48, "Text",
  Evaluatable->False],
Cell[30169, 1371, 823, 19, 95, "Text",
  Evaluatable->False,
  CellTags->{
  "simplification of the skeleton", "change of variables", 
    "canonical variables"}],
Cell[30995, 1392, 28, 0, 29, "Example"],
Cell[31026, 1394, 104, 1, 27, "Text",
  CellTags->"Riccati equation"],

Cell[CellGroupData[{
Cell[31155, 1399, 108, 2, 34, "Input"],
Cell[31266, 1403, 376, 12, 34, "Output"]
}, Open  ]],
Cell[31657, 1418, 170, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"skeleton of the Riccati equation"],
Cell[31830, 1425, 56, 1, 34, "Input"],
Cell[31889, 1428, 260, 8, 44, "Text",
  Evaluatable->False,
  CellTags->"hyperbolic paraboloid"],
Cell[32152, 1438, 65, 1, 34, "Input"],
Cell[32220, 1441, 73, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[32318, 1445, 416, 7, 118, "Input",
  CellTags->"skeleton-Riccati"],
Cell[32737, 1454, 94505, 2124, 188, 68383, 1796, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[127257, 3581, 1064, 27, 112, "Text",
  CellTags->{
  "parabolic surface", "scaling transformation", 
    "non-homogeneous dilation"}],

Cell[CellGroupData[{
Cell[128346, 3612, 136, 2, 39, "Input"],
Cell[128485, 3616, 110, 2, 23, "Output"]
}, Open  ]],
Cell[128610, 3621, 236, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"invariance of the Riccati equation"],

Cell[CellGroupData[{
Cell[128871, 3631, 479, 14, 23, "Input"],
Cell[129353, 3647, 424, 13, 23, "Output"]
}, Open  ]],
Cell[129792, 3663, 621, 22, 61, "Text",
  Evaluatable->False,
  CellTags->"scaling factor"],

Cell[CellGroupData[{
Cell[130438, 3689, 103, 2, 23, "Input"],
Cell[130544, 3693, 472, 14, 34, "Output"]
}, Open  ]],
Cell[131031, 3710, 1929, 57, 163, "Text"],

Cell[CellGroupData[{
Cell[132985, 3771, 91, 1, 23, "Input"],
Cell[133079, 3774, 241, 8, 24, "Output"]
}, Open  ]],
Cell[133335, 3785, 1940, 61, 78, "Text",
  CellTags->{
  "invariant skeleton", "inhomogeneous stretching", 
    "extended vector field"}],
Cell[135278, 3848, 121, 3, 23, "Input"],
Cell[135402, 3853, 126, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"skeleton of the Riccati equation"],

Cell[CellGroupData[{
Cell[135553, 3859, 109, 2, 23, "Input"],
Cell[135665, 3863, 57, 1, 34, "Output"]
}, Open  ]],
Cell[135737, 3867, 82, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[135844, 3872, 47, 1, 23, "Input"],
Cell[135894, 3875, 68, 1, 34, "Output"]
}, Open  ]],
Cell[135977, 3879, 439, 7, 78, "Text",
  Evaluatable->False],
Cell[136419, 3888, 28, 0, 29, "Example"],
Cell[136450, 3890, 115, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[136590, 3898, 153, 3, 42, "Input"],
Cell[136746, 3903, 510, 16, 34, "Output"]
}, Open  ]],
Cell[137271, 3922, 257, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"inhomogeneous scaling transformation"],
Cell[137531, 3930, 760, 19, 71, "Input"],
Cell[138294, 3951, 213, 6, 29, "Text",
  Evaluatable->False,
  CellTags->"scaling[]"],

Cell[CellGroupData[{
Cell[138532, 3961, 57, 1, 23, "Input"],
Cell[138592, 3964, 561, 16, 34, "Output"]
}, Open  ]],
Cell[139168, 3983, 187, 5, 27, "Text",
  Evaluatable->False,
  CellTags->{"skeleton", "skeleton graphical representation"}],

Cell[CellGroupData[{
Cell[139380, 3992, 303, 4, 84, "Input"],
Cell[139686, 3998, 38474, 848, 189, 19358, 606, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[178175, 4849, 272, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"canonical transformation"],
Cell[178450, 4857, 202, 4, 67, "Input"],
Cell[178655, 4863, 52, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[178732, 4867, 97, 2, 23, "Input"],
Cell[178832, 4871, 246, 8, 24, "Output"]
}, Open  ]],
Cell[179093, 4882, 82, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[179200, 4887, 396, 6, 116, "Input"],
Cell[179599, 4895, 87776, 1489, 188, 57763, 1113, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[267390, 6387, 381, 9, 44, "Text",
  Evaluatable->False,
  CellTags->"third-order parabola"],
Cell[267774, 6398, 28, 0, 29, "Example"],
Cell[267805, 6400, 166, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"skeleton"],

Cell[CellGroupData[{
Cell[267996, 6409, 116, 2, 40, "Input"],
Cell[268115, 6413, 404, 13, 40, "Output"]
}, Open  ]],
Cell[268534, 6429, 594, 17, 47, "Text",
  Evaluatable->False,
  CellTags->{"global transformation", "canonical variables"}],

Cell[CellGroupData[{
Cell[269153, 6450, 99, 2, 24, "Input"],
Cell[269255, 6454, 234, 8, 25, "Output"]
}, Open  ]],
Cell[269504, 6465, 124, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[269653, 6473, 981, 17, 270, "Input"],
Cell[270637, 6492, 176750, 3622, 185, 130853, 3050, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[447402, 10117, 435, 10, 61, "Text",
  Evaluatable->False,
  CellTags->{"skeleton", "concave surface"}],
Cell[447840, 10129, 609, 10, 95, "Text",
  CellTags->{
  "canonical transformation simplifies the skeleton", 
    "canonical variables"}],
Cell[448452, 10141, 204, 5, 44, "Text",
  CellTags->"non-homogeneous dilation"],

Cell[CellGroupData[{
Cell[448681, 10150, 100, 2, 34, "Input"],
Cell[448784, 10154, 87, 1, 34, "Output"]
}, Open  ]],
Cell[448886, 10158, 592, 17, 61, "Text",
  Evaluatable->False,
  CellTags->"Riccati equation"],

Cell[CellGroupData[{
Cell[449503, 10179, 153, 3, 39, "Input"],
Cell[449659, 10184, 248, 8, 24, "Output"]
}, Open  ]],
Cell[449922, 10195, 165, 4, 27, "Text",
  CellTags->"skeleton"],
Cell[450090, 10201, 58, 1, 23, "Input"],
Cell[450151, 10204, 369, 14, 44, "Text",
  Evaluatable->False,
  CellTags->"cylindrical surface"],

Cell[CellGroupData[{
Cell[450545, 10222, 379, 6, 102, "Input"],
Cell[450927, 10230, 89264, 1506, 188, 57937, 1114, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[540206, 11739, 346, 8, 44, "Text",
  CellTags->"canonical variables"],
Cell[540555, 11749, 1304, 32, 114, "Text",
  CellTags->{"CanonicalVariables[]", "CanonicalRepresentation[]"}],
Cell[541862, 11783, 1665, 33, 280, "Input",
  CellTags->"CanonicalRepresentation[]"],
Cell[543530, 11818, 385, 9, 61, "Text",
  Evaluatable->False,
  CellTags->{
  "Riccati equation", "inhomogeneous scaling transformation", 
    "canonical variables"}],

Cell[CellGroupData[{
Cell[543940, 11831, 108, 2, 39, "Input"],
Cell[544051, 11835, 111, 2, 23, "Output"]
}, Open  ]],
Cell[544177, 11840, 212, 5, 44, "Text",
  Evaluatable->False,
  CellTags->"reduce the Riccati equation"],

Cell[CellGroupData[{
Cell[544414, 11849, 160, 4, 39, "Input"],
Cell[544577, 11855, 350, 10, 24, "Output"]
}, Open  ]],
Cell[544942, 11868, 355, 10, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[545322, 11882, 99, 2, 23, "Input"],
Cell[545424, 11886, 248, 8, 24, "Output"]
}, Open  ]],
Cell[545687, 11897, 347, 10, 48, "Text",
  Evaluatable->False,
  CellTags->{"separation of variables", "quadrature", "DSolve[]"}],

Cell[CellGroupData[{
Cell[546059, 11911, 60, 1, 23, "Input"],
Cell[546122, 11914, 156, 3, 41, "Output"]
}, Open  ]],
Cell[546293, 11920, 182, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"canonical transformation"],

Cell[CellGroupData[{
Cell[546500, 11929, 218, 5, 39, "Input"],
Cell[546721, 11936, 112, 3, 36, "Output"]
}, Open  ]],
Cell[546848, 11942, 192, 7, 27, "Text",
  Evaluatable->False,
  CellTags->"implicit solution"],

Cell[CellGroupData[{
Cell[547065, 11953, 50, 1, 23, "Input"],
Cell[547118, 11956, 143, 3, 37, "Output"]
}, Open  ]],
Cell[547276, 11962, 194, 5, 44, "Text",
  Evaluatable->False,
  CellTags->"scaling symmetries"],

Cell[CellGroupData[{
Cell[547495, 11971, 156, 3, 39, "Input"],
Cell[547654, 11976, 348, 10, 24, "Output"]
}, Open  ]],
Cell[548017, 11989, 72, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[548114, 11994, 93, 1, 23, "Input"],
Cell[548210, 11997, 246, 8, 24, "Output"]
}, Open  ]],
Cell[548471, 12008, 358, 10, 44, "Text",
  Evaluatable->False,
  CellTags->{
  "canonical variables", "separation of variables", 
    "integration by separation of variables"}],

Cell[CellGroupData[{
Cell[548854, 12022, 161, 3, 34, "Input"],
Cell[549018, 12027, 126, 2, 48, "Output"]
}, Open  ]],
Cell[549159, 12032, 272, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"canonical transformation"],

Cell[CellGroupData[{
Cell[549456, 12042, 103, 2, 23, "Input"],
Cell[549562, 12046, 146, 2, 48, "Output"]
}, Open  ]],
Cell[549723, 12051, 336, 9, 44, "Text",
  Evaluatable->False,
  CellTags->"graphical representation of the solution"],
Cell[550062, 12062, 99, 2, 23, "Input"],

Cell[CellGroupData[{
Cell[550186, 12068, 140, 2, 39, "Input"],
Cell[550329, 12072, 66830, 1512, 191, 11061, 818, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[617174, 13587, 451, 18, 44, "Text",
  Evaluatable->False],
Cell[617628, 13607, 157, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"canonical variables"],

Cell[CellGroupData[{
Cell[617810, 13616, 166, 4, 52, "Input"],
Cell[617979, 13622, 234, 8, 25, "Output"]
}, Open  ]],
Cell[618228, 13633, 155, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[618408, 13643, 58, 1, 23, "Input"],
Cell[618469, 13646, 99, 2, 34, "Output"]
}, Open  ]],
Cell[618583, 13651, 184, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[618792, 13661, 153, 3, 34, "Input"],
Cell[618948, 13666, 88, 1, 34, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[619073, 13672, 56, 1, 23, "Input"],
Cell[619132, 13675, 113, 2, 36, "Output"]
}, Open  ]],
Cell[619260, 13680, 699, 15, 78, "Text",
  Evaluatable->False,
  CellTags->{
  "canonical variables", "first-order equations", 
    "method of canonical variables"}],
Cell[619962, 13697, 476, 9, 78, "Text",
  Evaluatable->False,
  CellTags->"integrating factor"]
}, Open  ]],

Cell[CellGroupData[{
Cell[620475, 13711, 85, 1, 31, "Subsubsection",
  CellTags->"Integrating factor"],
Cell[620563, 13714, 1041, 20, 112, "Text",
  CellTags->{
  "method of an integrating factor", 
    "first-order ordinary differential equation", "tangent vector", 
    "integral curves", "solutions"}],

Cell[CellGroupData[{
Cell[621629, 13738, 86, 1, 23, "Input"],
Cell[621718, 13741, 237, 8, 23, "Output"]
}, Open  ]],
Cell[621970, 13752, 239, 10, 27, "Text"],
Cell[622212, 13764, 74, 1, 36, "Input"],
Cell[622289, 13767, 388, 13, 27, "Text",
  CellTags->"integral curves"],

Cell[CellGroupData[{
Cell[622702, 13784, 73, 1, 23, "Input"],
Cell[622778, 13787, 249, 8, 23, "Output"]
}, Open  ]],
Cell[623042, 13798, 402, 11, 44, "Text",
  CellTags->"infinitesimal transformation"],

Cell[CellGroupData[{
Cell[623469, 13813, 97, 2, 23, "Input"],
Cell[623569, 13817, 277, 8, 23, "Output"]
}, Open  ]],
Cell[623861, 13828, 156, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[624042, 13837, 78, 1, 23, "Input"],
Cell[624123, 13840, 277, 8, 23, "Output"]
}, Open  ]],
Cell[624415, 13851, 361, 8, 44, "Text",
  CellTags->{"invariant curve", "infinitesimal transformation"}],

Cell[CellGroupData[{
Cell[624801, 13863, 205, 4, 55, "Input"],
Cell[625009, 13869, 749, 20, 66, "Output"]
}, Open  ]],
Cell[625773, 13892, 531, 15, 61, "Text",
  CellTags->{"integral curve", "total differential"}],

Cell[CellGroupData[{
Cell[626329, 13911, 88, 1, 23, "Input"],
Cell[626420, 13914, 149, 2, 36, "Output"]
}, Open  ]],
Cell[626584, 13919, 658, 21, 61, "Text",
  CellTags->{"integrating factor", "integral curve"}],

Cell[CellGroupData[{
Cell[627267, 13944, 118, 3, 36, "Input"],
Cell[627388, 13949, 91, 1, 36, "Output"]
}, Open  ]],
Cell[627494, 13953, 322, 8, 44, "Text",
  CellTags->"integrating factor"],
Cell[627819, 13963, 254, 5, 44, "Text",
  CellTags->"quadrature"],
Cell[628076, 13970, 89, 1, 33, "Theorem",
  CellTags->"Theorem: Integrating Factor"],
Cell[628168, 13973, 62, 0, 27, "Text"],
Cell[628233, 13975, 334, 10, 22, "NumberedEquation"],
Cell[628570, 13987, 588, 16, 27, "Text",
  CellTags->"one parameter group"],
Cell[629161, 14005, 103, 2, 37, "NumberedEquation"],
Cell[629267, 14009, 823, 26, 27, "Text",
  CellTags->"integrating factor"],
Cell[630093, 14037, 479, 13, 37, "NumberedEquation"],
Cell[630575, 14052, 130, 4, 27, "Text",
  CellTags->"determinant"],
Cell[630708, 14058, 569, 17, 33, "NumberedEquation"],
Cell[631280, 14077, 19, 0, 27, "Text"],
Cell[631302, 14079, 343, 9, 37, "NumberedEquation"],
Cell[631648, 14090, 68, 0, 27, "Text"],
Cell[631719, 14092, 529, 15, 35, "NumberedEquation"],
Cell[632251, 14109, 389, 6, 61, "Text",
  CellTags->{"infinitesimals", "manifold"}],
Cell[632643, 14117, 28, 0, 29, "Example"],
Cell[632674, 14119, 99, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[632798, 14126, 113, 2, 34, "Input"],
Cell[632914, 14130, 59, 1, 34, "Output"]
}, Open  ]],
Cell[632988, 14134, 375, 11, 44, "Text"],

Cell[CellGroupData[{
Cell[633388, 14149, 87, 1, 23, "Input"],
Cell[633478, 14152, 51, 1, 34, "Output"]
}, Open  ]],
Cell[633544, 14156, 55, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[633624, 14160, 56, 1, 23, "Input"],
Cell[633683, 14163, 55, 1, 34, "Output"]
}, Open  ]],
Cell[633753, 14167, 164, 7, 27, "Text"],

Cell[CellGroupData[{
Cell[633942, 14178, 61, 1, 23, "Input"],
Cell[634006, 14181, 35, 1, 23, "Output"]
}, Open  ]],
Cell[634056, 14185, 158, 6, 27, "Text"],

Cell[CellGroupData[{
Cell[634239, 14195, 59, 1, 23, "Input"],
Cell[634301, 14198, 48, 1, 23, "Output"]
}, Open  ]],
Cell[634364, 14202, 164, 6, 27, "Text",
  CellTags->"infinitesimals"],
Cell[634531, 14210, 57, 1, 23, "Input"],
Cell[634591, 14213, 19, 0, 27, "Text"],
Cell[634613, 14215, 77, 1, 36, "Input"],
Cell[634693, 14218, 179, 3, 27, "Text",
  CellTags->"integrating factor"],

Cell[CellGroupData[{
Cell[634897, 14225, 38, 1, 23, "Input"],
Cell[634938, 14228, 49, 1, 23, "Output"]
}, Open  ]],
Cell[635002, 14232, 108, 1, 27, "Text",
  CellTags->"total differential"],

Cell[CellGroupData[{
Cell[635135, 14237, 47, 1, 23, "Input"],
Cell[635185, 14240, 120, 2, 23, "Output"]
}, Open  ]],
Cell[635320, 14245, 334, 12, 44, "Text"],

Cell[CellGroupData[{
Cell[635679, 14261, 366, 7, 77, "Input"],
Cell[636048, 14270, 55, 1, 23, "Output"]
}, Open  ]],
Cell[636118, 14274, 652, 21, 63, "Text",
  CellTags->"ImplicitPlot[]"],
Cell[636773, 14297, 102, 2, 23, "Input",
  CellTags->"Graphics`ImplicitPlot`"],

Cell[CellGroupData[{
Cell[636900, 14303, 89, 1, 23, "Input"],
Cell[636992, 14306, 313, 8, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[637342, 14319, 381, 7, 83, "Input"],
Cell[637726, 14328, 92427, 4446, 241, 64096, 4083, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[730168, 18777, 1106, 25, 95, "Text",
  PageBreakWithin->True,
  CellTags->{
  "infinitesimals", "solutions of first-order differential equations", 
    "infinitesimal transformation", "invariance condition"}],
Cell[731277, 18804, 499, 13, 61, "Text",
  Evaluatable->False,
  CellTags->"integrating factor theorem"],
Cell[731779, 18819, 28, 0, 29, "Example"],
Cell[731810, 18821, 229, 6, 44, "Text",
  Evaluatable->False,
  CellTags->{"Riccati equation", "skeleton"}],

Cell[CellGroupData[{
Cell[732064, 18831, 47, 1, 23, "Input"],
Cell[732114, 18834, 60, 1, 34, "Output"]
}, Open  ]],
Cell[732189, 18838, 540, 13, 61, "Text",
  Evaluatable->False,
  CellTags->{"polynomial", "infinitesimals"}],

Cell[CellGroupData[{
Cell[732754, 18855, 80, 1, 34, "Input"],
Cell[732837, 18858, 74, 1, 34, "Output"]
}, Open  ]],
Cell[732926, 18862, 196, 4, 27, "Text",
  Evaluatable->False,
  CellTags->"integrating factor"],

Cell[CellGroupData[{
Cell[733147, 18870, 98, 2, 40, "Input"],
Cell[733248, 18874, 67, 1, 33, "Output"]
}, Open  ]],
Cell[733330, 18878, 170, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[733525, 18888, 74, 1, 23, "Input"],
Cell[733602, 18891, 130, 2, 39, "Output"]
}, Open  ]],
Cell[733747, 18896, 379, 17, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[734151, 18917, 175, 4, 33, "Input"],
Cell[734329, 18923, 80, 1, 34, "Output"]
}, Open  ]],
Cell[734424, 18927, 41, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[734490, 18932, 175, 4, 33, "Input"],
Cell[734668, 18938, 89, 1, 34, "Output"]
}, Open  ]],
Cell[734772, 18942, 238, 7, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[735035, 18953, 102, 2, 34, "Input"],
Cell[735140, 18957, 100, 2, 34, "Output"]
}, Open  ]],
Cell[735255, 18962, 120, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[735400, 18970, 181, 5, 39, "Input"],
Cell[735584, 18977, 112, 2, 40, "Output"]
}, Open  ]],
Cell[735711, 18982, 183, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[735919, 18992, 48, 1, 23, "Input"],
Cell[735970, 18995, 143, 3, 37, "Output"]
}, Open  ]],
Cell[736128, 19001, 573, 12, 80, "Text",
  Evaluatable->False,
  CellTags->"IntegratingFactor[]"],
Cell[736704, 19015, 3626, 71, 570, "Input",
  CellTags->"IntegratingFactor[]"],
Cell[740333, 19088, 175, 5, 29, "Text",
  Evaluatable->False],
Cell[740511, 19095, 28, 0, 29, "Example"],
Cell[740542, 19097, 178, 5, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[740745, 19106, 114, 2, 39, "Input"],
Cell[740862, 19110, 415, 13, 34, "Output"]
}, Open  ]],
Cell[741292, 19126, 391, 12, 46, "Text",
  Evaluatable->False,
  CellTags->{"implicit solution", "IntegratingFactor[]"}],

Cell[CellGroupData[{
Cell[741708, 19142, 74, 1, 23, "Input"],
Cell[741785, 19145, 71, 1, 36, "Output"]
}, Open  ]],
Cell[741871, 19149, 326, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"Log[]"],

Cell[CellGroupData[{
Cell[742222, 19164, 50, 1, 23, "Input"],
Cell[742275, 19167, 160, 2, 26, "Output"]
}, Open  ]],
Cell[742450, 19172, 311, 12, 29, "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[742786, 19188, 78, 2, 23, "Input"],
Cell[742867, 19192, 190, 3, 26, "Output"]
}, Open  ]],
Cell[743072, 19198, 28, 0, 29, "Example"],
Cell[743103, 19200, 197, 5, 27, "Text",
  Evaluatable->False,
  CellTags->{"integrating factor", "quadrature"}],

Cell[CellGroupData[{
Cell[743325, 19209, 117, 2, 23, "Input"],
Cell[743445, 19213, 259, 8, 24, "Output"]
}, Open  ]],
Cell[743719, 19224, 181, 6, 29, "Text",
  Evaluatable->False,
  CellTags->"IntegratingFactor[]"],

Cell[CellGroupData[{
Cell[743925, 19234, 74, 1, 23, "Input"],
Cell[744002, 19237, 361, 8, 23, "Output"]
}, Open  ]],
Cell[744378, 19248, 289, 7, 46, "Text",
  Evaluatable->False],
Cell[744670, 19257, 977, 18, 112, "Text",
  CellTags->{"infinitesimals", "conformal symmetries"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[745684, 19280, 181, 4, 31, "Subsubsection",
  CellTags->"Infinitesimals of first order ordinary differential equations"],
Cell[745868, 19286, 706, 11, 95, "Text",
  CellTags->{
  "determination of infinitesimal transformations", 
    "infinite number of symmetries"}],

Cell[CellGroupData[{
Cell[746599, 19301, 103, 2, 23, "Input"],
Cell[746705, 19305, 244, 8, 23, "Output"]
}, Open  ]],
Cell[746964, 19316, 402, 14, 46, "Text",
  CellTags->"DeterminingEquations[]"],

Cell[CellGroupData[{
Cell[747391, 19334, 109, 2, 23, "Input"],
Cell[747503, 19338, 454, 12, 24, "Output"]
}, Open  ]],
Cell[747972, 19353, 401, 8, 61, "Text",
  CellTags->{
  "over determined system of determining equations", 
    "prolongation formula"}],
Cell[748376, 19363, 1049, 19, 112, "Text",
  CellTags->{
  "group classification", "families of ODEs", "particular transformation", 
    "solvable non-Abelian Lie algebra", "hidden symmetries"}],
Cell[749428, 19384, 824, 18, 78, "Text",
  CellTags->{"conformal symmetry", "conformal transformations"}],
Cell[750255, 19404, 168, 3, 40, "NumberedEquation"],
Cell[750426, 19409, 20, 0, 27, "Text"],
Cell[750449, 19411, 125, 3, 37, "NumberedEquation"],
Cell[750577, 19416, 239, 7, 44, "Text",
  CellTags->"one-parameter group"],
Cell[750819, 19425, 258, 5, 24, "NumberedEquation"],
Cell[751080, 19432, 63, 0, 27, "Text"],
Cell[751146, 19434, 162, 3, 24, "NumberedEquation"],
Cell[751311, 19439, 127, 2, 27, "Text"],
Cell[751441, 19443, 113, 1, 33, "Theorem",
  CellTags->"Theorem: Symmetries of first order ODEs"],
Cell[751557, 19446, 322, 10, 27, "Text"],
Cell[751882, 19458, 482, 14, 37, "NumberedEquation"],
Cell[752367, 19474, 33, 0, 27, "Text"],
Cell[752403, 19476, 266, 5, 35, "NumberedEquation"],
Cell[752672, 19483, 197, 8, 27, "Text"],
Cell[752872, 19493, 264, 6, 44, "Text"],
Cell[753139, 19501, 92, 1, 27, "Text",
  CellTags->"complex variables"],
Cell[753234, 19504, 123, 2, 22, "NumberedEquation"],
Cell[753360, 19508, 19, 0, 27, "Text"],
Cell[753382, 19510, 337, 10, 22, "NumberedEquation"],
Cell[753722, 19522, 38, 0, 27, "Text"],
Cell[753763, 19524, 267, 5, 36, "NumberedEquation"],
Cell[754033, 19531, 51, 0, 27, "Text"],
Cell[754087, 19533, 391, 11, 35, "NumberedEquation"],
Cell[754481, 19546, 359, 11, 44, "Text",
  CellTags->"complex conjugate value"],
Cell[754843, 19559, 198, 8, 27, "Text"],
Cell[755044, 19569, 262, 6, 37, "NumberedEquation"],
Cell[755309, 19577, 35, 0, 27, "Text"],
Cell[755347, 19579, 272, 5, 37, "NumberedEquation"],
Cell[755622, 19586, 96, 1, 27, "Text",
  CellTags->"infinitesimals"],
Cell[755721, 19589, 513, 12, 37, "NumberedEquation"],
Cell[756237, 19603, 134, 4, 27, "Text",
  CellTags->"canonical variables"],
Cell[756374, 19609, 258, 6, 40, "NumberedEquation"],
Cell[756635, 19617, 19, 0, 27, "Text"],
Cell[756657, 19619, 259, 5, 40, "NumberedEquation"],
Cell[756919, 19626, 185, 3, 27, "Text",
  CellTags->"infinitesimal symmetries"],
Cell[757107, 19631, 93, 1, 33, "Theorem",
  CellTags->"Theorem: Conformal Symmetries"],
Cell[757203, 19634, 1312, 42, 44, "Text",
  CellTags->"conformal transformations"],
Cell[758518, 19678, 195, 4, 35, "NumberedEquation"],
Cell[758716, 19684, 182, 6, 27, "Text"],
Cell[758901, 19692, 299, 6, 44, "Text",
  CellTags->{
  "conformal symmetries", "integrating factor", "canonical variables"}],
Cell[759203, 19700, 363, 6, 78, "Text"],
Cell[759569, 19708, 147, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

