(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     85057,       3312]*)
(*NotebookOutlinePosition[    100489,       3700]*)
(*  CellTagsIndexPosition[     98362,       3641]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["4.4.3 Higher-Order Ordinary Differential Equations", "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Higher order ordinary differential equations"],

Cell["\<\
Differential equations of higher order arise naturally in physics. \
For example, third-order ODEs come up in fluid dynamics and fourth-order ODEs \
in elasticity. For general higher-order equations, there exist hardly any \
techniques for obtaining explicit symbolic solutions. This means that \
higher-order ODEs are thus not well studied in the literature. In the \
following, we will present a symbolic technique for producing explicit \
solutions independent of the order of the equation. The method described in \
the preceding sections can, without essential changes, be generalized to the \
solution of differential equations of higher order.\
\>", "Text",
  CellTags->{
  "fluid dynamics", "elasticity", "symbolic solution", 
    "symbolic technique producing explicit solutions"}],

Cell[CellGroupData[{

Cell["4.4.3.1 Integrating Factor Method", "Subsection",
  CellTags->"Integrating factor method"],

Cell[TextData[{
  "The essential change in the theory of an integrating factor for \
higher-order ODEs is the extension of the Lie matrix to higher prolongations. \
Extending the Lie matrix to higher prolongations is the key step for \
generalizing the procedure of integrating factors. ",
  ButtonBox["Lie",
    ButtonData:>{"Literat.nb", "Enge-12"},
    ButtonStyle->"Hyperlink"],
  " called this extension the determination of the multiplier of the \
differential equation."
}], "Text",
  CellTags->{
  "integrating factor", "Lie matrix", "higher prolongation", "prolongation", 
    "determination of the multiplier of adifferential equation"}],

Cell[TextData[{
  "The ",
  ButtonBox["five steps of integration",
    ButtonData:>{"symmet3.nb", "five steps of integration"},
    ButtonStyle->"Hyperlink"],
  " discussed for second-order equations remain the same for higher-order \
equations. However, the dimension of the Lie matrix changes from a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Times]3\)]],
  " matrix to an ",
  Cell[BoxData[
      \(TraditionalForm\`\((n + 1)\)\[Times]\((n + 1)\)\)]],
  " matrix. Before we discuss the algorithm, let us state the general \
settings for higher-order equations."
}], "Text",
  CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],

Cell[TextData[{
  "The most general form of an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th-order ODE is given by"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(F(x, u, u', \(u'\)', \[Ellipsis], u\_\((n)\))\  = \ 0, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u\_\((n)\)\), "=", 
          FractionBox[\(\(d\^n\) u\), 
            SuperscriptBox[
              StyleBox["dx",
                FontSlant->"Italic"], "n"]]}], TraditionalForm]]],
  " denotes the ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". In the following, we assume that equation (4.65) can be solved with \
respect to the ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th derivative. Thus, the actual equation under consideration is"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_\((n)\)\  = \ \[Omega](x, u, u', \[Ellipsis], u\_\((n - 1)\)), 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where \[Omega] is a given function of ",
  Cell[BoxData[
      \(TraditionalForm\`x, u\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u', \[Ellipsis], u\_\((n - 1)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "If an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th-order equation admits a finite symmetry of dimension ",
  Cell[BoxData[
      \(TraditionalForm\`r \[GreaterEqual] n\)]],
  ", then the equation can be integrated by group-theoretic quadrature \
methods. This, also, can be done in various ways. For a discussion of other \
procedures, compare Sections ",
  ButtonBox["4.4.1",
    ButtonData:>{"symmet2.nb", "First order equations"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["4.4.2",
    ButtonData:>{"symmet3.nb", 
      "Second order ordinary differential equations"},
    ButtonStyle->"Hyperlink"],
  ". One of the group-theoretic algorithms is based on first integrals. The \
algorithm for an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "th-order ODE is summarized as follows:"
}], "Text",
  CellTags->{
  "finite symmetry", "quadrature method", "group theoretic algorithm"}],

Cell[TextData[{
  "Compute the Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  ". A basis for  ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  " is the set  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_1\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_2\)]],
  ", \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_r\)]],
  ". The tangent vector fields ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\& \[RightVector] \)\_i\)]],
  " follow from appropriately specifying the group constants."
}], "ListItem",
  CellDingbat->"1.",
  CellTags->{"Lie algebra", "tangent vector", "group constant"}],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`r = n\)]],
  ", go to the next step;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r > n\)]],
  ",  distinguish any ",
  StyleBox["n",
    FontSlant->"Italic"],
  "-dimensional subalgebra ",
  Cell[BoxData[
      \(TraditionalForm\`L\_n\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`L\_r\)]],
  ".\nIf ",
  Cell[BoxData[
      \(TraditionalForm\`r = n - 1\)]],
  ", the order of the equation may be lowered;\nif ",
  Cell[BoxData[
      \(TraditionalForm\`r = 0\)]],
  ", the group method is not useful."
}], "ListItem",
  CellDingbat->"2."],

Cell[TextData[{
  "Calculate the Lie determinants ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["d",
                FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\)]],
  ", and if possible, determine the ",
  StyleBox["n",
    FontSlant->"Italic"],
  " first integrals by integration. The Lie determinants are defined by"
}], "ListItem",
  CellDingbat->"3.",
  CellTags->{"Lie determinant", "first integral"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox[
                RowBox[{
                  StyleBox["d",
                    FontSlant->"Italic"], "\[CapitalDelta]"}]], "1"], " ", 
            "=", " ", 
            RowBox[{"det", "(", GridBox[{
                  {
                    StyleBox["dx",
                      FontSlant->"Italic"], 
                    StyleBox["du",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["du",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontSlant->"Plain"]}], "\[Ellipsis]", 
                    SuperscriptBox[
                      StyleBox["du",
                        FontSlant->"Italic"], \((n - 1)\)]},
                  {\(\[Xi]\_2\), \(\[Phi]\_2\), \(\[Phi]\_2\%'\), 
                    "\[Ellipsis]", \(\[Phi]\_2\%\((n - 1)\)\)},
                  {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                    "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                    "\[VerticalEllipsis]"},
                  {"1", \(u'\), \(\(u'\)'\), "\[Ellipsis]", "\[Omega]"}
                  }], ")"}]}], ","}], " "}], TraditionalForm]]]], 
  "NumberedEquation"],

Cell["and", "ListItem",
  TextAlignment->Left,
  TextJustification->0],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["d",
                FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], "=", " ", 
        RowBox[{"det", "(", GridBox[{
              {\(\[Xi]\_1\), \(\[Phi]\_1\), \(\[Phi]\_1'\), "\[Ellipsis]", 
                \(\[Phi]\_1\%\((n - 1)\)\)},
              {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                "\[VerticalEllipsis]"},
              {
                StyleBox["dx",
                  FontSlant->"Italic"], 
                StyleBox["du",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["du",
                    FontSlant->"Italic"], "'"}], "\[Ellipsis]", 
                SuperscriptBox[
                  StyleBox["du",
                    FontSlant->"Italic"], \((n - 1)\)]},
              {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                "\[VerticalEllipsis]"},
              {"1", \(u'\), \(\(u'\)'\), "\[CenterEllipsis]", "\[Omega]"}
              }], ")"}]}], TraditionalForm]]]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  StyleBox["i",
    FontSlant->"Italic"],
  " denotes the row of the Lie matrix in which infinitesimals are replaced by \
 differentials. The ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontSlant->"Italic"], "\[Times]", 
          StyleBox["n",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " Lie determinant \[CapitalDelta] reads"
}], "ListItem",
  CellTags->{"Lie matrix", "Lie determinant"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[CapitalDelta]", " ", "=", " ", 
          RowBox[{"det", 
            FormBox[
              RowBox[{"(", GridBox[{
                    {\(\[Xi]\_1\), \(\[Phi]\_1\), \(\[Phi]\_1\%'\), 
                      "\[Ellipsis]", \(\[Phi]\_1\%\((n - 1)\)\)},
                    {\(\[Xi]\_2\), \(\[Phi]\_2\), \(\[Phi]\_2\%'\), 
                      "\[Ellipsis]", \(\[Phi]\_2\%\((n - 1)\)\)},
                    {"\[VerticalEllipsis]", "\[VerticalEllipsis]", 
                      "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
                      "\[VerticalEllipsis]"},
                    {"1", \(u'\), \(\(u'\)'\), "\[Ellipsis]", "\[Omega]"}
                    }], ")"}],
              "TraditionalForm"]}]}], " ", ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\)]],
  " are the infinitesimals of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Phi]\_i\%'\)\)]],
  " denotes the first and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\%\((n - 1)\)\)]],
  " the (",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["\[Dash]1",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[")",
    FontSlant->"Italic"],
  "th extension of the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_i\)]],
  ". The corresponding first integrals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_i\)]],
  " are given by"
}], "ListItem",
  CellTags->{"infinitesimals", "first integral"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Psi]\_i\), " ", "=", " ", 
          RowBox[{
            RowBox[{"\[Integral]", 
              FractionBox[
                SubscriptBox[
                  StyleBox[
                    RowBox[{
                      StyleBox["d",
                        FontSlant->"Italic"], "\[CapitalDelta]"}]], "i"], 
                "\[CapitalDelta]"]}], " ", "=", " ", \(c\_i\)}]}], ",", 
        "         ", \(i = 1\), ",", "2", ",", "\[Ellipsis]", ",", 
        \(n . \)}], TraditionalForm]], "NumberedEquation",
  CellTags->"eq-27"],

Cell[TextData[{
  "The constants ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " denote the integration constants of the ODE."
}], "ListItem"],

Cell[TextData[{
  "Solve one of the ",
  StyleBox["n",
    FontSlant->"Italic"],
  " integrals with respect to the (",
  StyleBox["n\[Dash]",
    FontSlant->"Italic"],
  "1",
  StyleBox[")",
    FontSlant->"Italic"],
  "th-order derivative and substitute the result into the remaining \
relations. Repeat this procedure until no derivative remains in the \
relations."
}], "ListItem",
  CellDingbat->"4."],

Cell[TextData[{
  "If we can solve the resulting relation with respect to the unknown \
function ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we have found an explicit solution. Otherwise, our solution is \
implicit."
}], "ListItem",
  CellDingbat->"5."],

Cell["\<\
This procedure becomes very cumbersome with increasing orders of \
the equation if done by hand. In principle, the procedure can be applied to \
any kind of linear or non-linear ODE. How the algorithm works in particular \
examples is demonstrated below.\
\>", "Text"],

Cell["Example 1 ", "Example"],

Cell[TextData[{
  "The first example is a third-order equation listed by ",
  ButtonBox["Kamke [1977]",
    ButtonData:>{"Literat.nb", "Kamke-1977"},
    ButtonStyle->"Hyperlink"],
  " as No. 7.13:"
}], "Text",
  CellTags->"third-order equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(thirdOrderExample\  = \ 
      \[PartialD]\_\(x, x\)u[x] \[PartialD]\_{x, 3}u[x] - 
        \[Alpha] 
          \@\( 1 + \(\[Beta]\^2\) \((\[PartialD]\_\(x, x\)u[x])\)\^2\)\ ; 
    \(Map[# == 0&, {thirdOrderExample}] // LieTraditionalForm\) // TableForm
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\[Alpha]\)\ \@\(1 + \[Beta]\^2\ u\_\(x, x\)\%2\) + 
                u\_\(x, x\)\ u\_\(x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, \[Alpha], 
              Power[ 
                Plus[ 1, 
                  Times[ 
                    Power[ \[Beta], 2], 
                    Power[ 
                      Subscript[ u, x, x], 2]]], 
                Rational[ 1, 2]]], 
            Times[ 
              Subscript[ u, x, x], 
              Subscript[ u, x, x, x]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The parameters \[Alpha] and \[Beta] are real constants. According to \
Kamke, this third-order ODE is solvable and the solution can only be \
represented in parametric form. We will show here that an explicit solution \
of the equation is possible. First, let us check if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve the third-order equation."
}], "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[thirdOrderExample == 0, u, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(-\[Alpha]\), " ", 
              SqrtBox[
                RowBox[{"1", "+", 
                  RowBox[{\(\[Beta]\^2\), " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", "\[DoublePrime]",
                          MultilineFunction->None], "[", "x", "]"}], 
                      "2"]}]}]]}], "+", 
            RowBox[{
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], " ", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}]}], "==", "0"}], 
        ",", "u", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The above line shows that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is not capable of solving the equation. The question now is: Can we \
derive the necessary number of symmetries in order to integrate the equation? \
Deriving the symmetries is the first step in the general algorithm. The \
calculation of symmetries is carried out by the ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Infinitesimals[]", "MmaText"]
}], "Text",
  CellTags->{"necessary number of symmetries", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      Infinitesimals[thirdOrderExample, u, x, {\[Alpha], \[Beta]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 3}u[x]}]\)], "Input"],

Cell[BoxData[
    \({phi[1] \[Rule] Function[{x, u}, k2 + k3\ x], 
      xi[1] \[Rule] Function[{x, u}, k1]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a symmetry group of order three. The number of group \
constants is equal to the order of the equation. This allows us to apply the \
integrating algorithm discussed above. The specific symmetries are denoted by \
the group constants ",
  StyleBox["k1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k3",
    FontSlant->"Italic"],
  ". Each of these parameters is related to a vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`i = 1, 2, 3\)]],
  ". Since the number of vector fields is equal to the order of the equation, \
we can go to step 3 of the algorithm. In the third step, we determine the Lie \
matrix by inserting the prolongations of the infinitesimals and the equation \
itself:"
}], "Text",
  CellTags->{
  "symmetry group", "group constants", "order of equation", 
    "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],

Cell[BoxData[
    \(\(inf1\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\) /. {
            k1 \[Rule] 1, k2 \[Rule] 0, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf2\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 1, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf3\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell["The Lie matrix is derived by", "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, 
        \(\[Alpha] 
            \@\( 1 + 
                \(\[Beta]\^2\) 
                  \((\[PartialD]\_\(x, x\)u[x])\)\^2\)\)\/\[PartialD]\_\(x, x
              \)u[x], 3, {inf1, inf2, inf3}]; 
    TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "0", "0", "0"},
          {"0", "1", "0", "0"},
          {"0", "x", "1", "0"},
          {"1", \(u\_x\), \(u\_\(x, x\)\), 
            
            StyleBox[
              \(\(\[Alpha]\ \@\(1 + \[Beta]\^2\ u\_\(x, x\)\%2\)\)\/u\_\(x, x
                    \)\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["One of the three first integrals is ", "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 1] == \ c1 // Simplify; 
    integ1 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(x - \@\(1 + \[Beta]\^2\ u\_\(x, x\)\%2\)\/\(\[Alpha]\ \[Beta]\^2\) == c1
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result depends on ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " and now allows us to rewrite all terms containing ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " in the Lie matrices. Next, we solve the first integral with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  ". Since the integral depends quadratically on ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  ", we get two solutions:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ Solve[integ1, \[PartialD]\_\(x, x\)u[x]]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(-\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\)}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The first of the two solutions is used to replace ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " in the Lie matrix. The reader can easily do the calculation for the \
second solution by himself:"
}], "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dmat\  = \ 
      \[CapitalDelta]matrix /. 
        sol1\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({1, 0, 0, 0}\), ",", \({0, 1, 0, 0}\), ",", \({0, x, 1, 0}\), ",", 
        RowBox[{"{", 
          RowBox[{"1", ",", 
            RowBox[{
              SuperscriptBox["u", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], ",", 
            \(-\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\), ",", 
            \(-\(\((\[Alpha]\ 
                    \[Sqrt]\((
                        1 + \[Beta]\^2\ 
                            \((\(-\(1\/\[Beta]\^2\)\) + 
                                c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                                x\^2\ \[Alpha]\^2\ \[Beta]\^2)\))\))\)/
                \((\@\(\(-\(1\/\[Beta]\^2\)\) + 
                      c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                      2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                      x\^2\ \[Alpha]\^2\ \[Beta]\^2\))\)\)\)}], "}"}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The simplified Lie matrix is used again to calculate the second \
first integral of the third-order equation:\
\>", "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ2\  = \ FirstIntegral[x, u, dmat, 3] == \ c2 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"(", 
          RowBox[{
          \(\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\ 
              \((\(-1\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^4 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^4)\)\), "+", 
            RowBox[{
            "\[Alpha]", " ", \(\[Beta]\^2\), " ", 
              \(\@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\)\), " ", 
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}]}], ")"}], "/", 
        \((\[Alpha]\ \[Beta]\^2\ 
            \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\)}], "==", 
      "c2"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "As expected, we find the integral depending only on first derivatives of ",
  
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Since this integral is linear in ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  ", it is uniquely solvable in ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ Solve[integ2, \(u'\)[x]] // Simplify\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          \(c2 - \((
                \[Sqrt]\((
                      \(-\(1\/\[Beta]\^2\)\) + 
                        c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                        2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                        x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                  \((\(-1\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^4 - 
                      2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                      x\^2\ \[Alpha]\^2\ \[Beta]\^4)\))\)/
              \((\[Alpha]\ \[Beta]\^2\ 
                  \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\)\)}], 
        "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resultant expression contains radicals of quadratic polynomials in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Inserting this result into the Lie matrix, we are able to eliminate the \
dependencies on ",
  Cell[BoxData[
      \(TraditionalForm\`u'\)]],
  ". We find"
}], "Text",
  CellTags->{"quadratic polynomial", "Lie matrix"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(dmat1\  = \ 
      dmat\  /. \ sol2\[LeftDoubleBracket]1, 1\[RightDoubleBracket] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, 0}, {0, x, 1, 0}, {1, 
        c2 - \((\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                    2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                    x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\ 
                \((\(-1\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^4 - 
                    2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                    x\^2\ \[Alpha]\^2\ \[Beta]\^4)\))\)/
            \((\[Alpha]\ \[Beta]\^2\ 
                \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\), 
        \(-\@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
              2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
              x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\), 
        \(-\(\(\[Alpha]\ 
                \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\)\)\/\@\(\(-
                    \(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\)\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The last step of integration is inserting the Lie matrices into the third \
first integral depending on ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ":"
}], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ3\  = \ FirstIntegral[x, u, dmat1, 2] == \ c3 // Simplify\)], 
  "Input"],

Cell[BoxData[
    \(\((\(-c2\)\ x\^3\ \[Alpha]\^4\ \[Beta]\^8 + 
            c2\ \[Alpha]\ \[Beta]\^2\ 
              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) - 
            c2\ x\^2\ \[Alpha]\^3\ \[Beta]\^6\ 
              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) + 
            \@\(\(-\(1\/\[Beta]\^2\)\) + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                x\^2\ \[Alpha]\^2\ \[Beta]\^2\) - 
            2\ x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) + 
            c1\^4\ \[Alpha]\^4\ \[Beta]\^8\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) - 
            4\ c1\^3\ x\ \[Alpha]\^4\ \[Beta]\^8\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) + 
            x\^4\ \[Alpha]\^4\ \[Beta]\^8\ 
              \@\(\(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                  x\^2\ \[Alpha]\^2\ \[Beta]\^2\) + 
            2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4\ 
              \((c2\ x\ \[Alpha]\^2\ \[Beta]\^4 + 
                  c2\ \[Alpha]\ \[Beta]\^2\ 
                    \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) + 
                  2\ \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) - 
                  2\ x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\))\) + 
            c1\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
              \((\(-c2\)\ x\ \[Alpha]\^2\ \[Beta]\^4 - 
                  c2\ \[Alpha]\ \[Beta]\^2\ 
                    \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) - 
                  2\ \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) + 
                  6\ x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\))\) + 
            \((c1 - x)\)\^2\ \[Alpha]\^4\ \[Beta]\^8\ u[x])\)/
        \((\((c1 - x)\)\^2\ \[Alpha]\^4\ \[Beta]\^8)\) == c3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The integral contains the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " again as a linear variable. In turn, we end up with a unique solution for \
the Kamke equation 7.13, which is"
}], "Text",
  CellTags->"unique solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution\  = \ Solve[integ3, u[x]] // Simplify\)], "Input"],

Cell[BoxData[
    \({{u[x] \[Rule] 
          c3 - \((c1\^4\ \[Alpha]\^4\ \[Beta]\^8\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) - 
                  4\ c1\^3\ x\ \[Alpha]\^4\ \[Beta]\^8\ 
                    \[Sqrt]\((
                        \(-1\)\/\[Beta]\^2 + c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\) + 
                  \[Sqrt]\((
                        \(-\(1\/\[Beta]\^2\)\) + 
                          c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                          2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                          x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                    \((\(-1\) + x\^2\ \[Alpha]\^2\ \[Beta]\^4)\)\^2 - 
                  c2\ \[Alpha]\ \[Beta]\^2\ 
                    \((x\^3\ \[Alpha]\^3\ \[Beta]\^6 - 
                        \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\) + 
                        x\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                          \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))\) + 
                  c1\^2\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \((2\ \[Sqrt]\((
                              \(-1\)\/\[Beta]\^2 + 
                                c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                                x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                          \((\(-1\) + 3\ x\^2\ \[Alpha]\^2\ \[Beta]\^4)\) - 
                        c2\ \[Alpha]\ \[Beta]\^2\ 
                          \((x\ \[Alpha]\ \[Beta]\^2 + 
                              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))
                            \))\) + 
                  2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^4\ 
                    \((\(-2\)\ 
                          \[Sqrt]\((
                              \(-1\)\/\[Beta]\^2 + 
                                c1\^2\ \[Alpha]\^2\ \[Beta]\^2 - 
                                2\ c1\ x\ \[Alpha]\^2\ \[Beta]\^2 + 
                                x\^2\ \[Alpha]\^2\ \[Beta]\^2)\)\ 
                          \((\(-1\) + x\^2\ \[Alpha]\^2\ \[Beta]\^4)\) + 
                        c2\ \[Alpha]\ \[Beta]\^2\ 
                          \((x\ \[Alpha]\ \[Beta]\^2 + 
                              \@\(\((c1 - x)\)\^2\ \[Alpha]\^2\ \[Beta]\^4\))
                            \))\))\)/
              \((\((c1 - x)\)\^2\ \[Alpha]\^4\ \[Beta]\^8)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solution depends on three constants ",
  StyleBox["c1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["c2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c3, ",
    FontSlant->"Italic"],
  "all of which are constants of integration. The parameters \[Alpha] and \
\[Beta] are the parameters of the original equation. To get a feeling how the \
solution evolves, we plot the solution for different parameter sets ",
  StyleBox["c1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["c2",
    FontSlant->"Italic"],
  ",",
  StyleBox[" c3 ",
    FontSlant->"Italic"],
  "at fixed \[Alpha] and \[Beta]:"
}], "Text"],

Cell[BoxData[
    \(\(s1\  = \ 
      Table[\((\(u[x]\  /. solution\)\  /. {c1 \[Rule] 1, c2 \[Rule] 1\/2, 
                c3 \[Rule] i, \[Alpha] \[Rule] 1, \[Beta] \[Rule] 1\/2})
            \)\[LeftDoubleBracket]1\[RightDoubleBracket], {i, 0, 5}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[s1], {x, 5, 7}, 
      PlotStyle 
        \[Rule] {RGBColor[0, \ 0, \ 0.996109], RGBColor[0, \ 0, \ 0.62501], 
          RGBColor[0.500008, \ 0, \ 0.500008], 
          RGBColor[0.500008, \ 0, \ 0.996109], 
          RGBColor[0.996109, \ 0, \ 0.500008], 
          RGBColor[0.500008, \ 0, \ 0.250004]}, 
      AxesLabel \[Rule] {"\<x\>", "\<u\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: .61803 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

-2.35714 0.476191 0.437763 0.0214979 [

[.2619 .42526 -9 -9 ]

[.2619 .42526 9 0 ]

[.5 .42526 -3 -9 ]

[.5 .42526 3 0 ]

[.7381 .42526 -9 -9 ]

[.7381 .42526 9 0 ]

[.97619 .42526 -3 -9 ]

[.97619 .42526 3 0 ]

[1.025 .43776 0 -7.5 ]

[1.025 .43776 10 7.5 ]

[.01131 .0078 -18 -4.5 ]

[.01131 .0078 0 4.5 ]

[.01131 .11529 -18 -4.5 ]

[.01131 .11529 0 4.5 ]

[.01131 .22278 -18 -4.5 ]

[.01131 .22278 0 4.5 ]

[.01131 .33027 -12 -4.5 ]

[.01131 .33027 0 4.5 ]

[.01131 .54525 -6 -4.5 ]

[.01131 .54525 0 4.5 ]

[.02381 .64303 -5 0 ]

[.02381 .64303 5 15 ]

[ 0 0 0 0 ]

[ 1 .61803 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

.2619 .43776 m

.2619 .44401 L

s

[(5.5)] .2619 .42526 0 1 Mshowa

.5 .43776 m

.5 .44401 L

s

[(6)] .5 .42526 0 1 Mshowa

.7381 .43776 m

.7381 .44401 L

s

[(6.5)] .7381 .42526 0 1 Mshowa

.97619 .43776 m

.97619 .44401 L

s

[(7)] .97619 .42526 0 1 Mshowa

.125 Mabswid

.07143 .43776 m

.07143 .44151 L

s

.11905 .43776 m

.11905 .44151 L

s

.16667 .43776 m

.16667 .44151 L

s

.21429 .43776 m

.21429 .44151 L

s

.30952 .43776 m

.30952 .44151 L

s

.35714 .43776 m

.35714 .44151 L

s

.40476 .43776 m

.40476 .44151 L

s

.45238 .43776 m

.45238 .44151 L

s

.54762 .43776 m

.54762 .44151 L

s

.59524 .43776 m

.59524 .44151 L

s

.64286 .43776 m

.64286 .44151 L

s

.69048 .43776 m

.69048 .44151 L

s

.78571 .43776 m

.78571 .44151 L

s

.83333 .43776 m

.83333 .44151 L

s

.88095 .43776 m

.88095 .44151 L

s

.92857 .43776 m

.92857 .44151 L

s

.25 Mabswid

0 .43776 m

1 .43776 L

s

gsave

1.025 .43776 -61 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

.02381 .0078 m

.03006 .0078 L

s

[(-20)] .01131 .0078 1 0 Mshowa

.02381 .11529 m

.03006 .11529 L

s

[(-15)] .01131 .11529 1 0 Mshowa

.02381 .22278 m

.03006 .22278 L

s

[(-10)] .01131 .22278 1 0 Mshowa

.02381 .33027 m

.03006 .33027 L

s

[(-5)] .01131 .33027 1 0 Mshowa

.02381 .54525 m

.03006 .54525 L

s

[(5)] .01131 .54525 1 0 Mshowa

.125 Mabswid

.02381 .0293 m

.02756 .0293 L

s

.02381 .0508 m

.02756 .0508 L

s

.02381 .0723 m

.02756 .0723 L

s

.02381 .0938 m

.02756 .0938 L

s

.02381 .13679 m

.02756 .13679 L

s

.02381 .15829 m

.02756 .15829 L

s

.02381 .17979 m

.02756 .17979 L

s

.02381 .20129 m

.02756 .20129 L

s

.02381 .24428 m

.02756 .24428 L

s

.02381 .26578 m

.02756 .26578 L

s

.02381 .28728 m

.02756 .28728 L

s

.02381 .30878 m

.02756 .30878 L

s

.02381 .35177 m

.02756 .35177 L

s

.02381 .37327 m

.02756 .37327 L

s

.02381 .39477 m

.02756 .39477 L

s

.02381 .41626 m

.02756 .41626 L

s

.02381 .45926 m

.02756 .45926 L

s

.02381 .48076 m

.02756 .48076 L

s

.02381 .50226 m

.02756 .50226 L

s

.02381 .52375 m

.02756 .52375 L

s

.02381 .56675 m

.02756 .56675 L

s

.02381 .58825 m

.02756 .58825 L

s

.02381 .60975 m

.02756 .60975 L

s

.25 Mabswid

.02381 0 m

.02381 .61803 L

s

gsave

.02381 .64303 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

0 0 m

1 0 L

1 .61803 L

0 .61803 L

closepath

clip

newpath

0 0 .996 r

.5 Mabswid

.02381 .49151 m

.04262 .49274 L

.06244 .49388 L

.08255 .49481 L

.09396 .49522 L

.09905 .49537 L

.10458 .49551 L

.11004 .49562 L

.11508 .4957 L

.11989 .49576 L

.12232 .49579 L

.12369 .4958 L

.125 .49581 L

.12615 .49581 L

.12741 .49582 L

.12855 .49582 L

.12962 .49583 L

.13088 .49583 L

.13202 .49583 L

.13334 .49583 L

.13459 .49583 L

.13568 .49582 L

.13684 .49582 L

.1389 .49581 L

.14113 .49579 L

.14357 .49577 L

.14881 .4957 L

.15378 .49561 L

.16308 .49538 L

.1731 .49504 L

.184 .49455 L

.20377 .49334 L

.22478 .49159 L

.26253 .48718 L

.30273 .4806 L

.34142 .47234 L

.38256 .46139 L

.42218 .44865 L

.46029 .43431 L

.50085 .41673 L

.5399 .39749 L

.5814 .3745 L

.62138 .34982 L

.65984 .32368 L

.70076 .29326 L

.74017 .26136 L

.77805 .22824 L

.81839 .19032 L

.85722 .15117 L

.89849 .10667 L

Mistroke

.93826 .06096 L

.97619 .01472 L

Mfstroke

0 0 .625 r

.02381 .51301 m

.04262 .51424 L

.06244 .51538 L

.08255 .51631 L

.09396 .51671 L

.09905 .51686 L

.10458 .517 L

.11004 .51712 L

.11508 .5172 L

.11989 .51726 L

.12232 .51729 L

.12369 .5173 L

.125 .51731 L

.12615 .51731 L

.12741 .51732 L

.12855 .51732 L

.12962 .51732 L

.13088 .51733 L

.13202 .51733 L

.13334 .51733 L

.13459 .51732 L

.13568 .51732 L

.13684 .51732 L

.1389 .51731 L

.14113 .51729 L

.14357 .51727 L

.14881 .5172 L

.15378 .51711 L

.16308 .51688 L

.1731 .51653 L

.184 .51604 L

.20377 .51484 L

.22478 .51309 L

.26253 .50868 L

.30273 .5021 L

.34142 .49384 L

.38256 .48289 L

.42218 .47015 L

.46029 .45581 L

.50085 .43823 L

.5399 .41899 L

.5814 .396 L

.62138 .37132 L

.65984 .34518 L

.70076 .31475 L

.74017 .28286 L

.77805 .24974 L

.81839 .21181 L

.85722 .17267 L

.89849 .12817 L

Mistroke

.93826 .08246 L

.97619 .03621 L

Mfstroke

.5 0 .5 r

.02381 .5345 m

.04262 .53574 L

.06244 .53688 L

.08255 .53781 L

.09396 .53821 L

.09905 .53836 L

.10458 .5385 L

.11004 .53862 L

.11508 .5387 L

.11989 .53876 L

.12232 .53878 L

.12369 .53879 L

.125 .5388 L

.12615 .53881 L

.12741 .53882 L

.12855 .53882 L

.12962 .53882 L

.13088 .53882 L

.13202 .53883 L

.13334 .53882 L

.13459 .53882 L

.13568 .53882 L

.13684 .53881 L

.1389 .5388 L

.14113 .53879 L

.14357 .53876 L

.14881 .5387 L

.15378 .53861 L

.16308 .53838 L

.1731 .53803 L

.184 .53754 L

.20377 .53634 L

.22478 .53459 L

.26253 .53018 L

.30273 .5236 L

.34142 .51534 L

.38256 .50438 L

.42218 .49165 L

.46029 .47731 L

.50085 .45973 L

.5399 .44049 L

.5814 .4175 L

.62138 .39282 L

.65984 .36668 L

.70076 .33625 L

.74017 .30435 L

.77805 .27124 L

.81839 .23331 L

.85722 .19417 L

.89849 .14967 L

Mistroke

.93826 .10396 L

.97619 .05771 L

Mfstroke

.5 0 .996 r

.02381 .556 m

.04262 .55723 L

.06244 .55838 L

.08255 .5593 L

.09396 .55971 L

.09905 .55986 L

.10458 .56 L

.11004 .56011 L

.11508 .5602 L

.11989 .56026 L

.12232 .56028 L

.12369 .56029 L

.125 .5603 L

.12615 .56031 L

.12741 .56031 L

.12855 .56032 L

.12962 .56032 L

.13088 .56032 L

.13202 .56032 L

.13334 .56032 L

.13459 .56032 L

.13568 .56032 L

.13684 .56031 L

.1389 .5603 L

.14113 .56029 L

.14357 .56026 L

.14881 .56019 L

.15378 .5601 L

.16308 .55987 L

.1731 .55953 L

.184 .55904 L

.20377 .55783 L

.22478 .55608 L

.26253 .55168 L

.30273 .5451 L

.34142 .53683 L

.38256 .52588 L

.42218 .51315 L

.46029 .4988 L

.50085 .48122 L

.5399 .46199 L

.5814 .439 L

.62138 .41432 L

.65984 .38818 L

.70076 .35775 L

.74017 .32585 L

.77805 .29274 L

.81839 .25481 L

.85722 .21567 L

.89849 .17117 L

Mistroke

.93826 .12546 L

.97619 .07921 L

Mfstroke

.996 0 .5 r

.02381 .5775 m

.04262 .57873 L

.06244 .57987 L

.08255 .5808 L

.09396 .58121 L

.09905 .58136 L

.10458 .5815 L

.11004 .58161 L

.11508 .5817 L

.11989 .58176 L

.12232 .58178 L

.12369 .58179 L

.125 .5818 L

.12615 .58181 L

.12741 .58181 L

.12855 .58182 L

.12962 .58182 L

.13088 .58182 L

.13202 .58182 L

.13334 .58182 L

.13459 .58182 L

.13568 .58181 L

.13684 .58181 L

.1389 .5818 L

.14113 .58178 L

.14357 .58176 L

.14881 .58169 L

.15378 .5816 L

.16308 .58137 L

.1731 .58103 L

.184 .58054 L

.20377 .57933 L

.22478 .57758 L

.26253 .57317 L

.30273 .56659 L

.34142 .55833 L

.38256 .54738 L

.42218 .53464 L

.46029 .5203 L

.50085 .50272 L

.5399 .48349 L

.5814 .4605 L

.62138 .43581 L

.65984 .40967 L

.70076 .37925 L

.74017 .34735 L

.77805 .31424 L

.81839 .27631 L

.85722 .23716 L

.89849 .19267 L

Mistroke

.93826 .14696 L

.97619 .10071 L

Mfstroke

.5 0 .25 r

.02381 .599 m

.04262 .60023 L

.06244 .60137 L

.08255 .6023 L

.09396 .60271 L

.09905 .60285 L

.10458 .603 L

.11004 .60311 L

.11508 .60319 L

.11989 .60325 L

.12232 .60328 L

.12369 .60329 L

.125 .6033 L

.12615 .6033 L

.12741 .60331 L

.12855 .60331 L

.12962 .60332 L

.13088 .60332 L

.13202 .60332 L

.13334 .60332 L

.13459 .60332 L

.13568 .60331 L

.13684 .60331 L

.1389 .6033 L

.14113 .60328 L

.14357 .60326 L

.14881 .60319 L

.15378 .6031 L

.16308 .60287 L

.1731 .60253 L

.184 .60204 L

.20377 .60083 L

.22478 .59908 L

.26253 .59467 L

.30273 .58809 L

.34142 .57983 L

.38256 .56888 L

.42218 .55614 L

.46029 .5418 L

.50085 .52422 L

.5399 .50498 L

.5814 .48199 L

.62138 .45731 L

.65984 .43117 L

.70076 .40075 L

.74017 .36885 L

.77805 .33573 L

.81839 .29781 L

.85722 .25866 L

.89849 .21416 L

Mistroke

.93826 .16845 L

.97619 .1222 L

Mfstroke

% End of Graphics

MathPictureEnd


\
\>"], "Output",
  CellMargins->{{110, Inherited}, {Inherited, Inherited}},
  ImageSize->{216, 133.25},
  ImageMargins->{{24, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003H0000QA000`40O003h00Of7oo003HOol00=Qo
o`002Woo10000goo0P0017oo00<007ooOol0_Woo000:Ool00`00Oomoo`03Ool01000Oomoo`000goo
00<007ooOol0_Woo000;Ool00`00Oomoo`02Ool01000Oomoo`000goo0P00_goo0004Ool40004Ool0
1@00Oomoogoo00000Woo00D007ooOomoo`000:Qoo`0301moogoo01Eoo`002Woo00@007ooOol0009o
o`04001oogoo0003Ool00`00Oomoo`2UOol00`0OOomoo`0FOol000]oo`8000Aoo`8000Aoo`03001o
ogoo0:Eoo`0301moogoo01Ioo`005goo0P00YGoo00<07gooOol05goo000GOol00`00Oomoo`2SOol0
100OOomoo`0C5goo000GOol00`00Oomoo`2ROol0100OOomoo`0C67oo000GOol2002SOol0100OOomo
o`0C67oo000GOol00`00Oomoo`2QOol0100OOomoo`0C6Goo000GOol00`00Oomoo`2POol0100OOomo
o`0C0Woo00<l3gooOol05Goo000GOol00`00Oomoo`2OOol0100OOomoo`0C0Woo00<l3gooOol05Woo
000GOol2002OOol01@0OOomoogoo01<00Woo00<l3gooOol05Woo000GOol00`00Oomoo`2MOol01@0O
Oomoogoo01<00Woo00<l3goo?1l05goo000GOol00`00Oomoo`2MOol0100OOomoo`0C0Woo00<l3goo
?1l067oo000GOol00`00Oomoo`2LOol0100OOomoo`0C0Woo00@l3gooOoll7aQoo`005goo0P00W7oo
00@07gooOol04`=oo`03?0mooc`O01Uoo`005goo00<007ooOol0VWoo00@07gooOol04`=oo`03?0mo
oc`O009oo`03O0moogoo01Eoo`002Woo1@000Woo0P0017oo00<007ooOol0VGoo00D07gooOomoo`0C
009oo`06?0moogoo?1moog`?67oo000<Ool01@00Oomoogoo00000Woo00D007ooOomoo`0009Yoo`05
01moogooOol04`02Ool013`?Oomooc`O0Woo00=l3gooOol05Woo000<Ool00`00Oomoo`04Ool01000
Oomoogoo0P00V7oo00D07gooOomoo`0C009oo`04?0moogoo?1l2Ool00g`?Oomoo`0GOol000Aoo`@0
00Aoo`03001oogoo009oo`8000Aoo`03001oogoo09Ioo`0501moogooOol04`02Ool01c`?Oomoogoo
?1moog`?009oo`03?0Moogoo01Eoo`0037oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
UGoo00D07gooOomoo`0C00=oo`06?0moogoo?1moog`?0Woo00<l1gooOol05Woo000;Ool20004Ool3
0003Ool00`00Oomoo`2DOol01@0OOomoogoo01<00goo00@l3gooOoll7`9oo`04O0moogoo?0LHOol0
01Moo`8009Aoo`0501moogooOol04`03Ool013`?Oomooc`O0Woo00Al3gooOoll1aUoo`005goo00<0
07ooOol0TWoo00D07gooOomoo`0C00=oo`04?0moogoo?1l2Ool017`?Oomooc`76Woo000GOol00`00
Oomoo`2AOol01@0OOomoogoo01<00goo00Ll3gooOomooc`OOoml3`02Ool00c`7Oomoo`0IOol001Mo
o`80095oo`0501moogooOol04`03Ool01c`?Oomoogoo?1moog`?00=oo`03?0Moogoo01Uoo`005goo
00<007ooOol0Sgoo00D07gooOomoo`0C00=oo`05?0moogooOoll7`02Ool017`?Oomooc`777oo000G
Ool00`00Oomoo`2>Ool01@0OOomoogoo01<00goo00Dl3gooOomooc`O009oo`04O0moogoo?0LMOol0
01Moo`03001oogoo08eoo`0501moogooOol04`03Ool01C`?Oomoogoo?1l00Woo00Al3gooOoll1aio
o`005goo0P00SGoo00D07gooOomoo`0C00=oo`05?0moogooOoll7`02Ool017`?Oomooc`77goo000G
Ool00`00Oomoo`2;Ool01@0OOomoogoo01<00goo00Dl3gooOomooc`O00=oo`03O0mooc`7021oo`00
5goo00<007ooOol0RWoo00D07gooOomoo`0C00=oo`05?0moogooOoll7`03Ool017`?Oomooc`787oo
000GOol00`00Oomoo`29Ool01@0OOomoogoo01<00goo00Dl3gooOomooc`O00=oo`04O0moogoo?0LQ
Ool001Moo`8008Uoo`0501moogooOol04`03Ool01C`?Oomoogoo?1l00goo00Al3gooOoll1b9oo`00
5goo00<007ooOol0Qgoo00D07gooOomoo`0C00=oo`05?0moogooOoll7`03Ool017`?Oomooc`78goo
000:Ool50002Ool20004Ool00`00Oomoo`26Ool01@0OOomoogoo01<00goo00Dl3gooOomooc`O009o
o`9l3`9oo`03?0Moogoo029oo`0037oo00D007ooOomoo`00009oo`05001oogooOol00027Ool01@0O
Oomoogoo01<00goo00Dl3gooOomooc`O009oo`05O0moogooOoll1`0UOol000aoo`05001oogooOol0
0002Ool01000Oomoogoo0P00QGoo00D07gooOomoo`0C00=oo`05?0moogooOoll7`02Ool01G`?Oomo
ogoo?0L09Woo0004Ool40004Ool01@00Oomoogoo00000Woo00D007ooOomoo`0008Eoo`0501moogoo
Ool04`03Ool01C`?Oomoogoo?1l00Woo00El3gooOomooc`702Moo`0037oo00D007ooOomoo`00009o
o`05001oogooOol00024Ool01@0OOomoogoo01<00goo00Dl3gooOomooc`O009oo`05O0moogooOoll
1`0XOol000]oo`8000Aoo`8000Aoo`03001oogoo085oo`0501moogooOol04`03Ool01C`?Oomoogoo
?1l00Woo00El3gooOomooc`702Uoo`005goo0P00P7oo0P0O0goo00D04gooOomooc`?00=oo`04?1mo
ogooO0l3Ool00c`7Oomoo`0XOol001Moo`03001oogoo07ioo`0301moogoo009oo`0501=oogooOoll
3`03Ool013`OOomoog`?0goo00<l1gooOol0:Goo000GOol00`00Oomoo`1mOol00`0OOomoo`02Ool0
1@0COomoogoo?0l00goo00@l7gooOoml3`=oo`03?0Moogoo02Yoo`005goo00<007ooOol0O7oo00<0
7gooOol00Woo00D04gooOomooc`?00=oo`04?1moogooO0l3Ool00c`7Oomoo`0[Ool001Moo`8007]o
o`807`=oo`804`=oo`05?0moogooOoll7`02Ool01G`?Oomoogoo?0L0;Woo000GOol00`00Oomoo`1i
Ool00`0OOomoo`02Ool00`0COomoo`02Ool00c`?Oomoo`02?1l2Ool01G`?Oomoogoo?0L0;goo000G
Ool00`00Oomoo`1hOol00`0OOomoo`02Ool0100COomoogoo0S`?0Woo00Dl7gooOomoog`?00=oo`03
?0Moogoo02ioo`005goo0P00Mgoo0P0O17oo00D04gooOomooc`?00=oo`05?1moogooOoml3`03Ool0
0c`7Oomoo`0_Ool001Moo`03001oogoo07Eoo`0301moogoo009oo`804`=oo`05?0moogooOoll7`03
Ool01G`?Oomoogoo?0L0<Woo000GOol00`00Oomoo`1dOol00`0OOomoo`02Ool0100COomoogoo0S`?
0goo00Dl7gooOomoog`?00=oo`03?0Moogoo035oo`005goo00<007ooOol0Lgoo00<07gooOol00Woo
00D04gooOomooc`?00Aoo`05?1moogooOoml3`03Ool00c`7Oomoo`0bOol001Moo`80079oo`807`=o
o`804`=oo`04?0moogooOol2?1l3Ool01G`?Oomoogoo?0L0=Goo000GOol00`00Oomoo`1`Ool00`0O
Oomoo`02Ool00`0COomoo`02Ool01C`?Oomoogoo?1l017oo00El3gooOomooc`703Ioo`004Goo0P00
17oo00<007ooOol0Kgoo00<07gooOol00Woo00@04gooOomoo`8l3`=oo`03?1moogoo009oo`05O0mo
ogooOoll1`0gOol0011oo`04001oogoo0003Ool00`00Oomoo`1^Ool00`0OOomoo`02Ool01@0COomo
ogoo?0l017oo00<l7gooOol00Woo00El3gooOomooc`703Qoo`004goo00@007ooOomoo`8006eoo`80
7`=oo`804`=oo`03?0moogoo009oo`04?1moogooOol2O0l3Ool00c`7Oomoo`0gOol000Yoo`@000=o
o`8000Aoo`03001oogoo06Yoo`807`Aoo`0301=oogoo009oo`03?0moogoo009oo`05?1moogooOoml
3`04Ool00c`7Oomoo`0hOol0015oo`03001oogoo00=oo`03001oogoo06Qoo`807`Eoo`0401=oogoo
Ool2?0l3Ool2?1l3Ool00g`?Oomoo`02Ool00c`7Oomoo`0iOol0015oo`<000=oo`03001oogoo06Mo
o`0301moogoo00Aoo`0501=oogooOoll3`04Ool00c`OOomoo`02Ool00g`?Oomoo`02Ool00c`7Oomo
o`0jOol001Moo`8006Ioo`807`Eoo`804`=oo`03?0moogoo009oo`03?1moogoo009oo`04O0moogoo
Ool2?0LmOol001Moo`03001oogoo06Aoo`0301moogoo00=oo`804`=oo`8l3`Aoo`03?1moogoo009o
o`05O0moogooOoll1`0oOol001Moo`03001oogoo06=oo`0301moogoo009oo`804`Aoo`03?0moogoo
009oo`8l7`=oo`9l3`=oo`03?0Moogoo03ioo`005goo00<007ooOol0HGoo0P0O17oo00<04gooOol0
0Woo0S`?17oo00<l7gooOol00Woo00=l3gooOol00Woo00<l1gooOol0?goo000GOol2001QOol00`0O
Oomoo`02Ool201<4Ool00c`?Oomoo`03Ool00c`OOomoo`02Ool017`?Oomoogoo0S`7@Woo000GOol0
0`00Oomoo`0QOol20004Ool20004Ool2000QOol3000;Ool201l4Ool00`0COomoo`03Ool00c`?Oomo
o`02Ool2?1l3Ool00`00O0l00002Ool013`7Ool0000017oo0P008goo00<007ooOol05Goo000GOol0
0`00Oomoo`0POol01000Oomoo`0027oo00@007ooOol0021oo`04001oogoo0008Ool201l5Ool00`0C
Oomoo`02Ool2?0l4Ool00c`OOomoo`02Ool2O0l2Ool00`00?0Moo`06Ool01000Oomoo`008Woo00<0
07ooOol05Goo000GOol2000TOol00`00Oomoo`09Ool00`00Oomoo`0NOol01000Oomoo`001Woo0P0O
1Goo0P0C17oo00<l3gooOol00Woo0S`O17oo00Al3goo001oo`8l1`]oo`03001oogoo021oo`03001o
ogoo01Eoo`005goo00<007ooOol08Goo0P002Woo0P008Goo0`001Goo0P0O1Woo00<04gooOol00Woo
0S`?17oo00<l7gooOol00goo00Il3gooOol003`7000:Ool2000TOol00`00Oomoo`0DOol001Moo`03
001oogoo025oo`03001oogoo00Uoo`03001oogoo025oo`03001oogoo009oo`807`Ioo`804`=oo`8l
3`Eoo`03?1moogoo009oo`9l3`=oo`03?0L007oo00Yoo`03001oogoo021oo`04001oogoo000FOol0
01Moo`03001oogoo025oo`<000Uoo`<0025oo`<000807`Ioo`804`=oo`8l3`Eoo`8l7`Aoo`03O0mo
ogoo009oo`03?0Moo`00008000Uoo`<0021oo`@001Ioo`005goo0P00DWoo0`0O1Woo0P0C17oo00<l
3gooOol017oo00<l7gooOol00Woo0W`?0goo0S`7Bgoo000GOol00`00Oomoo`1?Ool201l7Ool201<4
Ool2?0l5Ool2?1l4Ool00g`?Oomoo`02Ool00c`7Oomoo`1;Ool001Moo`03001oogoo04eoo`807`Mo
o`804`Eoo`03?0moogoo00=oo`8l7`Eoo`03O0moogoo009oo`03?0Moogoo03moo`800003Ool00000
00Qoo`005goo00<007ooOol0BWoo0`0O1goo0P0C1Woo00<l3gooOol00Woo0S`O1Goo0W`?17oo00<l
1gooOol0@Goo00<007oo00002Goo000COom?000201l7000301<60002?0l400000c`O000000040000
0g`?000000020002?0Ln0007Ool00`00Oomoo`08Ool001Moo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo009oo`807`03Ool007oo00Aoo`804`03Ool007oo00Aoo`8l3`04
001oogooOol2?1l3Ool01000Ooml3g`?17oo00<l1gooOol01Woo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol0
27oo0P0000=oo`00000027oo000GOol00`00Oomoo`13Ool301l7Ool201<7Ool2?0l4Ool2?1l5Ool2
O0l5Ool00c`7Oomoo`1AOol001Moo`03001oogoo03moo`@07`Moo`<04`Moo`8l3`Aoo`8l7`Eoo`9l
3`Eoo`8l1eAoo`005goo0P00?Goo0`0O2Goo0P0C1goo0c`?1Goo00<l7gooOol017oo00=l3gooOol0
17oo00<l1gooOol0E7oo000GOol00`00Oomoo`0hOol401l:Ool201<7Ool2?0l6Ool2?1l5Ool2O0l5
Ool2?0MGOol001Moo`03001oogoo03Eoo`<07`]oo`<04`Moo`8l3`Ioo`8l7`Eoo`9l3`Eoo`8l1eUo
o`005goo00<007ooOol0<Goo100O2Woo100C1goo0c`?1Woo0S`O1Goo0W`?1Goo0S`7Fgoo000GOol2
000]Ool501l;Ool301<9Ool2?0l7Ool2?1l6Ool00g`?Oomoo`04Ool00c`7Oomoo`1KOol001Moo`03
001oogoo02Eoo`L07`aoo`@04`Yoo`8l3`Moo`8l7`Ioo`9l3`Eoo`8l1eioo`005goo:00O3Woo1@0C
2goo0c`?1goo0S`O1Woo0W`?1Goo0S`7H7oo000GOol00`00Oomoo`0^Ool501<<Ool4?0l7Ool3?1l6
Ool2O0l5Ool2?0MROol001Moo`8002]oo`@04`ioo`<l3`Moo`@l7`Moo`9l3`Eoo`8l1fAoo`005goo
0P0C87oo2`0C3Woo13`?1goo0c`O2Goo0W`?1Goo0S`7IWoo000GOol00`00Ool04`0O01<DOol5?0l9
Ool2?1l:Ool2O0l5Ool2?0MXOol001Moo`8002eoo`Ll3`aoo`8l7`Uoo`=l3`Eoo`8l1fYoo`005goo
00<007ooOol09Goo1c`?47oo0c`O1goo17`?1Woo0S`7K7oo000AOol20004Ool6?0lLOol6?0lCOol4
?1l7Ool3O0l8Ool2?0M^Ool0011oo`04001oogoo0003Ool00`00Oomoo`03OolL?0lDOol5?1l9Ool2
O0l9Ool2?0M`Ool001=oo`04001oogooOol2000]Ool7?1l<Ool2O0l9Ool2?0MbOol0015oo`8000Ao
o`03001oogoo02Eoo`Ll7`ioo`El3`Moo`@l1gAoo`004Goo00<007ooOol00goo2C`O5Woo2C`O47oo
1G`?2Goo0c`7N7oo000AOol30003Ool00`00Oomoo`06OolF?1lEOol4O0l:Ool4?0MkOol001Moo`80
02eoo`El3`]oo`<l1gmoo`005goo00<007ooOol09Goo1g`?37oo13`7PWoo000GOol<O0l>Ool>O0l@
Ool3?0N6Ool001Moo`03001oogoo00Uoo`il3aYoo`@l1hUoo`005goo0P00;Goo1C`7SGoo000GOol0
0`00Oomoo`0UOol7?0NBOol001MoobPl1iUoo`005goo00<007ooOol0_Woo000GOol2002oOol001Mo
o`03001oogoo0;ioo`00f7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo003HOol00=Qoo`00
5Woo1000_Woo000EOol01000Oomoo`00_goo000EOol01000Oomoo`00_goo000DOol200000goo0000
002oOol00=Qoo`00f7oo003HOol00=Qoo`00f7oo003HOol00001\
\>"],
  ImageRangeCache->{{{0, 215}, {132.25, 0}} -> {4.71891, -21.1797, 0.0118314, \
0.262073}}]
}, Open  ]],

Cell["\<\
The figure represents the real valued solutions of the \
equation\
\>", "Text",
  TextJustification->1],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(\[PartialD]\_\(x, x\)u[x] \[PartialD]\_{x, 3}u[x]\),
          "Text",
          FontFamily->"Times"], 
        StyleBox[\(-\ \),
          "Text",
          FontFamily->"Times"], 
        StyleBox["\[Alpha]",
          "Text",
          FontFamily->"Times"], 
        StyleBox[
          \(\@\(1 + \(\(\[Beta]\^2\)(\[PartialD]\_\(x, x\)u[x])\)\^2\)\),
          ScriptLevel->1,
          FontFamily->"Times"], 
        StyleBox[" ",
          "Text",
          FontFamily->"Times"], 
        StyleBox[\( = 0. \),
          "Text",
          FontFamily->"Times"]}], TraditionalForm]], "DisplayFormula",
  TextJustification->1],

Cell[TextData[{
  "The different curves represent the solutions for values of  ",
  Cell[BoxData[
      \(TraditionalForm\`c3\  \[Element] {0, 1, 2, 3, 4, 5}\)]],
  " and fixed values for c2 = 1/2, c1 = 1. The parameters of the equation are \
\[Alpha] = 1 and \[Beta] = 1/2."
}], "Text",
  TextJustification->1],

Cell[TextData[{
  "We note that the solution is explicitly represented by a complicated \
expression containing radicals and polynomials. This result is new, as Kamke \
only offers a parametric representation of the solution. The example shows \
that with Lie\[CloseCurlyQuote]s procedure, we are able to arrive at a \
solution for higher-order ODEs. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", by itself, is not yet able to handle this type of equation.\[ThickSpace]\
\[EmptySquare]"
}], "Text",
  CellTags->"radical"],

Cell["Example 2", "Example"],

Cell["\<\
The second example for higher-order equations is a third-order \
equation. In this case, the equation has no direct physical origin. It is \
only used for checking the integration procedure:\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_\(x, x, x\) + \ 
        \[GothicCapitalR]\[GothicE]\ 
          \((u\_x\ u\_\(x, x\) - \ \(u(x)\)\ u\_\(x, x, x\))\)\  = \ 0, 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where \[GothicCapitalR]\[GothicE] is a positive constant. The equation has \
some resemblance to hydrodynamic equations if the first term of the equation \
is replaced by a fourth-order derivative ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, x, x, x\)\)]],
  ". However, the fourth-order equation does not possess the necessary number \
of symmetries to start the integration process. The reader may check this. \
The equation under consideration is thus"
}], "Text",
  CellTags->{
  "hydrodynamic equations", "necessary number of symmetries", 
    "integration process"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(thirdOrder\  = \ 
      \[PartialD]\_\(x, x, x\)u[x] + \ 
        \[GothicCapitalR]\[GothicE]\ 
          \((\[PartialD]\_x u[x] \[PartialD]\_\(x, x\)u[x] - \ 
              u[x] \[PartialD]\_\(x, x, x\)u[x])\); 
    \(Map[# == 0&, {thirdOrder}] // LieTraditionalForm\) // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(u\_\(x, x, x\) + 
                \[GothicCapitalR]\[GothicE]\ 
                  \((u\_x\ u\_\(x, x\) - u\ u\_\(x, x, x\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Subscript[ u, x, x, x], 
            Times[ \[GothicCapitalR]\[GothicE], 
              Plus[ 
                Times[ 
                  Subscript[ u, x], 
                  Subscript[ u, x, x]], 
                Times[ -1, u, 
                  Subscript[ u, x, x, x]]]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[GothicCapitalR]\[GothicE] is a real constant. The equation has a \
minimum of required symmetries given by"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = \ 
      Infinitesimals[thirdOrder\ , u, x, {\[GothicCapitalR]\[GothicE]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 3}u[x]}]\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, u}, k1 + k2\ x], 
      phi[1] \[Rule] 
        Function[{x, u}, 
          \(k3\ \((\(-1\) + u\ \[GothicCapitalR]\[GothicE])
                \)\)\/\[GothicCapitalR]\[GothicE]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The calculation below shows that the functions of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " are not able to find all first integrals in a single run. We need to \
split the integration into a few steps considering the symmetries given by \
the vector fields ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  ". The three symmetries related to the vector fields are given by"
}], "Text",
  CellTags->{"first integrals", "vector field"}],

Cell[BoxData[
    \(\(inf1\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\) /. {
            k1 \[Rule] 1, k2 \[Rule] 0, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf2\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 1, k3 \[Rule] 0}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(inf3\  = \ 
      \(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}}\  /. infi\)\  /. {
            k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1}\)\  /. u \[Rule] u[x]; 
    \)\)], "Input"],

Cell[TextData[
"The right-hand side of the third-order equation \[Omega] is given by"], 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Omega]\  = \ 
      \((Solve[thirdOrder == 0, \[PartialD]\_\(x, x, x\)u[x]])
          \)\[LeftDoubleBracket]1, 1, 2\[RightDoubleBracket]; 
    \[Omega] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(\[GothicCapitalR]\[GothicE]\ u\_x\ u\_\(x, x\)\)\/\(\(-1\) + 
        u\ \[GothicCapitalR]\[GothicE]\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`4\[Times]4\)]],
  " Lie matrix follows by inserting the infinitesimals of the vector fields \
and \[Omega] into the function ",
  StyleBox["DeltaMatrix[]:", "MmaText"]
}], "Text",
  CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, \[Omega], 3, {inf1, inf2, inf3}]; 
    TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "0", "0", "0"},
          {"x", "0", \(-u\_x\), \(\(-2\)\ u\_\(x, x\)\)},
          {"0", 
            RowBox[{
              
              StyleBox[
                \(\(\(-1\) + 
                      u\ \[GothicCapitalR]\[GothicE]\)\/\[GothicCapitalR]\),
                ScriptLevel->0], "\[GothicE]"}], \(u\_x\), \(u\_\(x, x\)\)},
          {"1", \(u\_x\), \(u\_\(x, x\)\), 
            
            StyleBox[
              \(\(\[GothicCapitalR]\[GothicE]\ u\_x\ 
                    u\_\(x, x\)\)\/\(\(-1\) + 
                    u\ \[GothicCapitalR]\[GothicE]\)\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The determinant of the Lie matrix is a polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`u, u'\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  ":"
}], "Text",
  CellTags->{"determinant", "Lie matrix"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(2\ u\_x\%2\ u\_\(x, x\) - 2\ u\ u\_\(x, x\)\%2 + 
      \(2\ u\_\(x, x\)\%2\)\/\[GothicCapitalR]\[GothicE]\)], "Output"]
}, Open  ]],

Cell[TextData[
"In order to obtain first integrals for the equation, the second line of the \
above \[CapitalDelta] matrix is replaced by the differentials:"], "Text",
  CellTags->"matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 2] == \ c1 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(1\/2\), " ", 
        RowBox[{"(", 
          RowBox[{\(Log[\(-1\) + \[GothicCapitalR]\[GothicE]\ u[x]]\), "-", 
            RowBox[{"Log", "[", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], "]"}]}], 
          ")"}]}], "==", "c1"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The remaining two integrals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_3\)]],
  " are not accessible to ",
  StyleBox["FirstIntegral[]", "MmaText"],
  ". The reason for this is that the function ",
  StyleBox["Integrate[]", "MmaText"],
  " of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot solve certain types of integrals. However, the result so far \
derived is helpful to find a solution of the equation. If we look at the \
first integral ",
  Cell[BoxData[
      \(TraditionalForm\`\[Psi]\_2\)]],
  ", we observe that this relation is a second-order ODE. The solution for ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " clearly shows"
}], "Text",
  CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ Solve[integ1, \[PartialD]\_\(x, x\)u[x]] // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          \(E\^\(\(-2\)\ c1\)\ 
            \((\(-1\) + \[GothicCapitalR]\[GothicE]\ u[x])\)\)}], "}"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we transform ",
  StyleBox["Rule",
    FontSlant->"Italic"],
  " to ",
  StyleBox["Equal",
    FontSlant->"Italic"],
  ", we get the equation"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqh\  = \ 
      \((sol1\  /. \ Rule \[Rule] Equal)\)\[LeftDoubleBracket]1, 1
        \[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["u", "\[DoublePrime]",
          MultilineFunction->None], "[", "x", "]"}], "==", 
      \(E\^\(\(-2\)\ c1\)\ 
        \((\(-1\) + \[GothicCapitalR]\[GothicE]\ u[x])\)\)}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "a second-order equation which is now solvable by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ DSolve[eqh, u, x]\  /. \ c1 \[Rule] C[3]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \((1\/\[GothicCapitalR]\[GothicE] + 
                E\^\(\(-E\^\(-C[3]\)\)\ \@\[GothicCapitalR]\[GothicE]\ #1\)\ 
                  C[1] + E
                    \^\(E\^\(-C[3]\)\ \@\[GothicCapitalR]\[GothicE]\ #1\)\ 
                  C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
Inserting this solution into the original equation, we can verify \
that the original equation is satisfied,\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(thirdOrder\  /. \ sol2 // Simplify\)], "Input"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "meaning that the left-hand side of the equation vanishes, and, in turn, \
equality has been established. Solving the original equation with ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " we get"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[thirdOrder == 0, u, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["u", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}], "+", 
            RowBox[{"\[GothicCapitalR]\[GothicE]", " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["u", "\[Prime]",
                        MultilineFunction->None], "[", "x", "]"}], " ", 
                    RowBox[{
                      SuperscriptBox["u", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}]}], "-", 
                  RowBox[{\(u[x]\), " ", 
                    RowBox[{
                      SuperscriptBox["u", 
                        TagBox[\((3)\),
                          Derivative],
                        MultilineFunction->None], "[", "x", "]"}]}]}], 
                ")"}]}]}], "==", "0"}], ",", "u", ",", "x"}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "showing us that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the present form is not capable of handling third-order equations."
}], "Text"],

Cell[TextData[
"The example demonstrates that we can even find solutions for cases where we \
know fewer first integrals than the order of the equation. The procedure of \
integration splits heterogeneously using different tools to solve the reduced \
equation. This behavior of higher-order ODEs creates some difficulties in the \
automatic solution process.\[ThickSpace]\[EmptySquare]"], "Text",
  CellTags->"higher-order ODE"],

Cell["Example 3", "Example"],

Cell[TextData[{
  "The third example considers the fourth-order ODE No. 7.16 of ",
  ButtonBox["Kamke [1977]",
    ButtonData:>{"Literat.nb", "Kamke-1977"},
    ButtonStyle->"Hyperlink"],
  ". This equation is a non-linear ODE containing second-, third-, and \
fourth-order derivatives. The problem with such an equation is that no \
standard procedure in literature offers a way to construct the solution given \
by Kamke. We will demonstrate that the integrating factor method is very \
effective for the construction of the solution. The equation No. 7.16 by \
Kamke reads"
}], "Text",
  CellTags->{"fourth-order ODE", "integrating factor method"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(kamke716\  = 
      3\ \[PartialD]\_\(x, x\)u[x] \[PartialD]\_{x, 4}u[x]\  - 
          5\ \((\[PartialD]\_\(x, x, x\)u[x])\)\^2 == 0; 
    kamke716 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-5\)\ u\_\(x, x, x\)\%2 + 3\ u\_\(x, x\)\ u\_\(x, x, x, x\) == 0\)], 
  "Output"]
}, Open  ]],

Cell["\<\
Kamke also lists the solution of the above ODE in implicit \
form:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", 
        RowBox[{
          RowBox[{\(u(x)\), " ", "+", 
            
            FormBox[\(\(\(C\_1\) x\  + \ C\_2)\)\^2\  = \ 
                \(C\_3\) x\  + \ C\_4\),
              "TraditionalForm"]}], ","}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`C\_1, C\_2, C\_3\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`C\_4\)]],
  " are real constants. The following examinations will demonstrate that this \
simple solution follows from our procedure. The first step of Lie's procedure \
is the determination of the infinitesimals:"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infkamke\  = \ 
      Infinitesimals[kamke716, u, x, 
        SubstitutionRules \[Rule] {\[PartialD]\_{x, 4}\ u[x]}]\)], "Input"],

Cell[BoxData[
    \({phi[1] \[Rule] Function[{x, u}, k3 + k1\ u + k4\ x], 
      xi[1] \[Rule] Function[{x, u}, k5 + k2\ u + k6\ x]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of this calculation is a symmetry group containing six group \
parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k\_i\)]],
  ". The second step consists in finding a solvable subalgebra of dimension \
four from these infinitesimals. The determination of all solvable subalgebras \
of dimension four is carried out with"
}], "Text",
  CellTags->{"symmetry group", "group parameter", "solvable subalgebra"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solvable\  = \ SolvableAlgebrasOfOrderN[infkamke, {u}, {x}, 4]\)], 
  "Input",
  CellTags->"SolvableAlgebrasOfOrderN[]"],

Cell[BoxData[
    \({{{k1 \[Rule] 1}, {k2 \[Rule] 1}, {k3 \[Rule] 1}, {k5 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k2 \[Rule] 1}, {k4 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k2 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k3 \[Rule] 1}, {k4 \[Rule] 1}, {k5 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k3 \[Rule] 1}, {k4 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k1 \[Rule] 1}, {k3 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k2 \[Rule] 1}, {k3 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}, {{
          k3 \[Rule] 1}, {k4 \[Rule] 1}, {k5 \[Rule] 1}, {k6 \[Rule] 1}}}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
From the result, we can choose one of the eight solvable algebras. \
The related coefficients of the vector fields creating these subalgebras are \
derived by inserting the above result and assuming the other group constants \
equal to zero:\
\>", "Text",
  CellTags->"subalgebra"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vectorBasis\  = 
      Map[\((\(\({{\(xi[1]\)[x, u]}, {\(phi[1]\)[x, u]}} /. infkamke\) /. #
                \) /. {k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, 
                k4 \[Rule] 0, k5 \[Rule] 0, k6 \[Rule] 0, u \[Rule] u[x]})
            \)&, solvable]\)], "Input"],

Cell[BoxData[
    \({{{{0}, {u[x]}}, {{u[x]}, {0}}, {{0}, {1}}, {{1}, {0}}}, {{{0}, {
            u[x]}}, {{u[x]}, {0}}, {{0}, {x}}, {{x}, {0}}}, {{{0}, {u[x]}}, {{
            u[x]}, {0}}, {{1}, {0}}, {{x}, {0}}}, {{{0}, {u[x]}}, {{0}, {
            1}}, {{0}, {x}}, {{1}, {0}}}, {{{0}, {u[x]}}, {{0}, {1}}, {{0}, {
            x}}, {{x}, {0}}}, {{{0}, {u[x]}}, {{0}, {1}}, {{1}, {0}}, {{x}, {
            0}}}, {{{u[x]}, {0}}, {{0}, {1}}, {{1}, {0}}, {{x}, {0}}}, {{{
            0}, {1}}, {{0}, {x}}, {{1}, {0}}, {{x}, {0}}}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Knowing the infinitesimals of the solvable subalgebras, we can proceed to \
the integration step of the algorithm. The information from the original \
equation ",
  StyleBox["kamke176",
    FontSlant->"Italic"],
  " about the right-hand side of the equation is extracted by"
}], "Text",
  CellTags->{"infinitesimals", "algorithm"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Omega]\  = \ 
      \(Solve[kamke716, \[PartialD]\_{x, 4}u[x]]\)[\([1, 1, 2]\)]; 
    \[Omega] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(5\ u\_\(x, x, x\)\%2\)\/\(3\ u\_\(x, x\)\)\)], "Output"]
}, Open  ]],

Cell["\<\
The Lie matrix of the equation is then calculated for the fourth \
subalgebra by\
\>", "Text",
  CellTags->{"Lie matrix", "subalgebra"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CapitalDelta]matrix = 
      DeltaMatrix[x, u, \[Omega], 4, 
        vectorBasis\[LeftDoubleBracket]4\[RightDoubleBracket]]; 
    TableForm[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0", "u", \(u\_x\), \(u\_\(x, x\)\), \(u\_\(x, x, x\)\)},
          {"0", "1", "0", "0", "0"},
          {"0", "x", "1", "0", "0"},
          {"1", "0", "0", "0", "0"},
          {"1", \(u\_x\), \(u\_\(x, x\)\), \(u\_\(x, x, x\)\), 
            StyleBox[\(\(5\ u\_\(x, x, x\)\%2\)\/\(3\ u\_\(x, x\)\)\),
              ScriptLevel->0]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData["The determinant of the \[CapitalDelta] matrix is"], "Text",
  CellTags->"determinant"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[\[CapitalDelta]matrix] // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-\(2\/3\)\)\ u\_\(x, x, x\)\%2\)], "Output"]
}, Open  ]],

Cell[TextData[
"Knowing that the determinant of Lie\[CloseCurlyQuote]s matrix is a \
non-vanishing quantity, we can calculate the first integrals of the equation. \
One of these integrals is"], "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 1] == \ c1 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(1\/2\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"5", " ", 
              RowBox[{"Log", "[", 
                RowBox[{
                  SuperscriptBox["u", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}], "]"}]}], "-", 
            RowBox[{"3", " ", 
              RowBox[{"Log", "[", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((3)\),
                      Derivative],
                    MultilineFunction->None], "[", "x", "]"}], "]"}]}]}], 
          ")"}]}], "==", "c1"}]], "Output"]
}, Open  ]],

Cell["A second first integral follows by", "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ2\  = \ 
      FirstIntegral[x, u, \[CapitalDelta]matrix, 4] == \ c2 // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"x", "+", 
        FractionBox[
          RowBox[{"3", " ", 
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], 
          RowBox[{"2", " ", 
            RowBox[{
              SuperscriptBox["u", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}]]}], "==", 
      "c2"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "At this point of our calculation, we know that equation No. 7.16 by Kamke \
allows two conserved quantities given by ",
  StyleBox["integ1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["integ2",
    FontSlant->"Italic"],
  ". The right-hand sides of these differential expressions ",
  StyleBox["c1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["c2",
    FontSlant->"Italic"],
  " are two real constants. The two integrals contain derivatives of third \
and second order. Since we know that both expressions are conserved, we can \
use one of these quantities to eliminate higher derivatives. We decide to \
eliminate the third-order derivative in the first integral ",
  StyleBox["integ1",
    FontSlant->"Italic"],
  " by"
}], "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1\  = \ Solve[integ2, \[PartialD]\_\(x, x, x\)u[x]] // Simplify\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          FractionBox[
            RowBox[{"3", " ", 
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], 
            \(2\ c2 - 2\ x\)]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The elimination of the third-order derivative in ",
  StyleBox["integ1",
    FontSlant->"Italic"],
  " gives us"
}], "Text",
  CellTags->"third-order derivative"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ1Help\  = \ 
      integ1\  /. s1\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(1\/2\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"5", " ", 
              RowBox[{"Log", "[", 
                RowBox[{
                  SuperscriptBox["u", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}], "]"}]}], "-", 
            RowBox[{"3", " ", 
              RowBox[{"Log", "[", 
                FractionBox[
                  RowBox[{"3", " ", 
                    RowBox[{
                      SuperscriptBox["u", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}]}], 
                  \(2\ c2 - 2\ x\)], "]"}]}]}], ")"}]}], "==", "c1"}]], 
  "Output"]
}, Open  ]],

Cell["\<\
representing an integral containing only second-order derivatives. \
The solution of this expression with respect to the second integral \
delivers\
\>", "Text",
  CellTags->"second-order derivative"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2\  = \ Solve[integ1Help, \[PartialD]\_\(x, x\)u[x]]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(-\(\(3\ \@3\ 
                    E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                      8\ x\^3\)\)\)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
            \(\(3\ \@3\ 
                  E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                    8\ x\^3\)\)}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The two resulting expressions can be integrated twice to find the \
solution. However, we apply ",
  StyleBox["DSolve[]", "MmaText"],
  " to the expressions to find the solution. Before we can use ",
  StyleBox["DSolve[],", "MmaText"],
  " we need to transform the rules to equations by"
}], "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqh\  = \ s2\  /. Rule \[Rule] Equal // Flatten\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "==", 
          \(-\(\(3\ \@3\ 
                  E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                    8\ x\^3\)\)\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "==", 
          \(\(3\ \@3\ 
                E\^c1\)\/\@\(8\ c2\^3 - 24\ c2\^2\ x + 24\ c2\ x\^2 - 
                  8\ x\^3\)\)}]}], "}"}]], "Output"]
}, Open  ]],

Cell["Solving the first equation gives us", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ DSolve[eqh[\([1]\)], u, x]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \((C[1] + C[2]\ #1 - 
                \(3\ \@3\ E\^c1\ 
                    \@\(8\ c2\^3 - 24\ c2\^2\ #1 + 24\ c2\ #1\^2 - 
                        8\ #1\^3\)\)\/\(2\ \((\(-c2\) + #1)\)\)&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The second relation for ",
  Cell[BoxData[
      \(TraditionalForm\`\(u'\)'\)]],
  " delivers the second solution"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ DSolve[eqh[\([2]\)], u, x]\)], "Input"],

Cell[BoxData[
    \({{u \[Rule] 
          \((C[1] + C[2]\ #1 + 
                \(3\ \@3\ E\^c1\ 
                    \@\(8\ c2\^3 - 24\ c2\^2\ #1 + 24\ c2\ #1\^2 - 
                        8\ #1\^3\)\)\/\(2\ \((\(-c2\) + #1)\)\)&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "In conclusion, we find two solutions in an explicit representation. This \
has to be expected since the solution given by Kamke contains the unknown \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " in quadratic form. The derived solution can be inserted into the original \
equation to verify that the gained results are correct. For the first \
solution, we find"
}], "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{

Cell[BoxData[
    \(kamke716 /. sol1 // Simplify\)], "Input"],

Cell[BoxData[
    \({True}\)], "Output"]
}, Open  ]],

Cell["\<\
meaning that the first solution satisfies the equation. The second \
solution also satisfies the equation\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(kamke716 /. sol2 // Simplify\)], "Input"],

Cell[BoxData[
    \({True}\)], "Output"]
}, Open  ]],

Cell[TextData[
"At the end, we demonstrated that the integrating factor method is capable of \
solving a fourth-order equation.\[ThickSpace]\[EmptySquare]"], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet5.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
AutoGeneratedPackage->Automatic,
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{729, 668},
WindowMargins->{{8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->205,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Symmetries of Ordinary Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Analysis of Ordinary Differential Equations", FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Hyperlinks"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Higher order ordinary differential equations"->{
    Cell[1739, 51, 407, 5, 43, "Section",
      CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 64}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Higher order ordinary differential equations"]},
  "fluid dynamics"->{
    Cell[2149, 58, 800, 13, 95, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "elasticity"->{
    Cell[2149, 58, 800, 13, 95, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "symbolic solution"->{
    Cell[2149, 58, 800, 13, 95, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "symbolic technique producing explicit solutions"->{
    Cell[2149, 58, 800, 13, 95, "Text",
      CellTags->{
      "fluid dynamics", "elasticity", "symbolic solution", 
        "symbolic technique producing explicit solutions"}]},
  "Integrating factor method"->{
    Cell[2974, 75, 96, 1, 41, "Subsection",
      CellTags->"Integrating factor method"]},
  "integrating factor"->{
    Cell[3073, 78, 647, 13, 61, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}]},
  "Lie matrix"->{
    Cell[3073, 78, 647, 13, 61, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}],
    Cell[3723, 93, 646, 15, 61, "Text",
      CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],
    Cell[11200, 329, 477, 15, 20, "ListItem",
      CellTags->{"Lie matrix", "Lie determinant"}],
    Cell[18785, 571, 1021, 26, 95, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
    Cell[20416, 617, 70, 1, 27, "Text",
      CellTags->"Lie matrix"],
    Cell[23219, 709, 266, 7, 44, "Text",
      CellTags->"Lie matrix"],
    Cell[27207, 824, 365, 10, 44, "Text",
      CellTags->{"quadratic polynomial", "Lie matrix"}],
    Cell[62657, 2580, 309, 8, 29, "Text",
      CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],
    Cell[64004, 2623, 253, 9, 27, "Text",
      CellTags->{"determinant", "Lie matrix"}],
    Cell[75290, 2977, 146, 4, 27, "Text",
      CellTags->{"Lie matrix", "subalgebra"}],
    Cell[76537, 3020, 227, 4, 44, "Text",
      CellTags->"Lie matrix"]},
  "higher prolongation"->{
    Cell[3073, 78, 647, 13, 61, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}]},
  "prolongation"->{
    Cell[3073, 78, 647, 13, 61, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}],
    Cell[18785, 571, 1021, 26, 95, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "determination of the multiplier of adifferential equation"->{
    Cell[3073, 78, 647, 13, 61, "Text",
      CellTags->{
      "integrating factor", "Lie matrix", "higher prolongation", 
        "prolongation", 
        "determination of the multiplier of adifferential equation"}]},
  "algorithm"->{
    Cell[3723, 93, 646, 15, 61, "Text",
      CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],
    Cell[18785, 571, 1021, 26, 95, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
    Cell[74668, 2956, 350, 8, 44, "Text",
      CellTags->{"infinitesimals", "algorithm"}]},
  "higher-order equation"->{
    Cell[3723, 93, 646, 15, 61, "Text",
      CellTags->{"Lie matrix", "algorithm", "higher-order equation"}]},
  "finite symmetry"->{
    Cell[5679, 162, 920, 25, 78, "Text",
      CellTags->{
      "finite symmetry", "quadrature method", "group theoretic algorithm"}]},
  "quadrature method"->{
    Cell[5679, 162, 920, 25, 78, "Text",
      CellTags->{
      "finite symmetry", "quadrature method", "group theoretic algorithm"}]},
  "group theoretic algorithm"->{
    Cell[5679, 162, 920, 25, 78, "Text",
      CellTags->{
      "finite symmetry", "quadrature method", "group theoretic algorithm"}]},
  "Lie algebra"->{
    Cell[6602, 189, 708, 22, 34, "ListItem",
      CellTags->{"Lie algebra", "tangent vector", "group constant"}]},
  "tangent vector"->{
    Cell[6602, 189, 708, 22, 34, "ListItem",
      CellTags->{"Lie algebra", "tangent vector", "group constant"}]},
  "group constant"->{
    Cell[6602, 189, 708, 22, 34, "ListItem",
      CellTags->{"Lie algebra", "tangent vector", "group constant"}]},
  "Lie determinant"->{
    Cell[7935, 239, 584, 19, 20, "ListItem",
      CellTags->{"Lie determinant", "first integral"}],
    Cell[11200, 329, 477, 15, 20, "ListItem",
      CellTags->{"Lie matrix", "Lie determinant"}]},
  "first integral"->{
    Cell[7935, 239, 584, 19, 20, "ListItem",
      CellTags->{"Lie determinant", "first integral"}],
    Cell[12511, 365, 883, 31, 34, "ListItem",
      CellTags->{"infinitesimals", "first integral"}],
    Cell[21381, 651, 82, 1, 27, "Text",
      CellTags->"first integral"],
    Cell[24785, 751, 163, 4, 27, "Text",
      CellTags->"first integral"],
    Cell[28764, 863, 280, 10, 27, "Text",
      CellTags->"first integral"],
    Cell[77570, 3053, 80, 1, 27, "Text",
      CellTags->"first integral"],
    Cell[78294, 3080, 793, 22, 78, "Text",
      CellTags->"first integral"]},
  "infinitesimals"->{
    Cell[12511, 365, 883, 31, 34, "ListItem",
      CellTags->{"infinitesimals", "first integral"}],
    Cell[62657, 2580, 309, 8, 29, "Text",
      CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],
    Cell[71496, 2874, 400, 11, 44, "Text",
      CellTags->"infinitesimals"],
    Cell[74668, 2956, 350, 8, 44, "Text",
      CellTags->{"infinitesimals", "algorithm"}]},
  "eq-27"->{
    Cell[13397, 398, 589, 15, 35, "NumberedEquation",
      CellTags->"eq-27"]},
  "third-order equation"->{
    Cell[15133, 457, 246, 7, 27, "Text",
      CellTags->"third-order equation"]},
  "Kamke"->{
    Cell[16454, 502, 419, 9, 61, "Text",
      CellTags->"Kamke"],
    Cell[83864, 3266, 433, 10, 61, "Text",
      CellTags->"Kamke"]},
  "necessary number of symmetries"->{
    Cell[17883, 544, 564, 13, 63, "Text",
      CellTags->{"necessary number of symmetries", "Infinitesimals[]"}],
    Cell[58817, 2464, 598, 12, 61, "Text",
      CellTags->{
      "hydrodynamic equations", "necessary number of symmetries", 
        "integration process"}]},
  "Infinitesimals[]"->{
    Cell[17883, 544, 564, 13, 63, "Text",
      CellTags->{"necessary number of symmetries", "Infinitesimals[]"}]},
  "symmetry group"->{
    Cell[18785, 571, 1021, 26, 95, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
    Cell[72234, 2899, 440, 9, 61, "Text",
      CellTags->{
      "symmetry group", "group parameter", "solvable subalgebra"}]},
  "group constants"->{
    Cell[18785, 571, 1021, 26, 95, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "order of equation"->{
    Cell[18785, 571, 1021, 26, 95, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "integrating algorithm"->{
    Cell[18785, 571, 1021, 26, 95, "Text",
      CellTags->{
      "symmetry group", "group constants", "order of equation", 
        "integrating algorithm", "algorithm", "Lie matrix", 
        "prolongation"}]},
  "quadratic polynomial"->{
    Cell[27207, 824, 365, 10, 44, "Text",
      CellTags->{"quadratic polynomial", "Lie matrix"}]},
  "unique solution"->{
    Cell[32176, 936, 272, 7, 44, "Text",
      CellTags->"unique solution"]},
  "radical"->{
    Cell[57823, 2436, 535, 11, 61, "Text",
      CellTags->"radical"]},
  "hydrodynamic equations"->{
    Cell[58817, 2464, 598, 12, 61, "Text",
      CellTags->{
      "hydrodynamic equations", "necessary number of symmetries", 
        "integration process"}]},
  "integration process"->{
    Cell[58817, 2464, 598, 12, 61, "Text",
      CellTags->{
      "hydrodynamic equations", "necessary number of symmetries", 
        "integration process"}]},
  "first integrals"->{
    Cell[61070, 2532, 489, 11, 61, "Text",
      CellTags->{"first integrals", "vector field"}]},
  "vector field"->{
    Cell[61070, 2532, 489, 11, 61, "Text",
      CellTags->{"first integrals", "vector field"}]},
  "DeltaMatrix[]"->{
    Cell[62657, 2580, 309, 8, 29, "Text",
      CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}]},
  "determinant"->{
    Cell[64004, 2623, 253, 9, 27, "Text",
      CellTags->{"determinant", "Lie matrix"}],
    Cell[76246, 3008, 101, 1, 27, "Text",
      CellTags->"determinant"]},
  "matrix"->{
    Cell[64521, 2644, 189, 3, 27, "Text",
      CellTags->"matrix"]},
  "FirstIntegral[]"->{
    Cell[65254, 2668, 846, 24, 80, "Text",
      CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}]},
  "Integrate[]"->{
    Cell[65254, 2668, 846, 24, 80, "Text",
      CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}]},
  "second-order ODE"->{
    Cell[65254, 2668, 846, 24, 80, "Text",
      CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}]},
  "DSolve[]"->{
    Cell[67185, 2738, 141, 4, 29, "Text",
      CellTags->"DSolve[]"],
    Cell[81836, 3195, 342, 8, 48, "Text",
      CellTags->"DSolve[]"]},
  "higher-order ODE"->{
    Cell[69635, 2821, 429, 6, 61, "Text",
      CellTags->"higher-order ODE"]},
  "fourth-order ODE"->{
    Cell[70098, 2831, 651, 12, 78, "Text",
      CellTags->{"fourth-order ODE", "integrating factor method"}]},
  "integrating factor method"->{
    Cell[70098, 2831, 651, 12, 78, "Text",
      CellTags->{"fourth-order ODE", "integrating factor method"}]},
  "group parameter"->{
    Cell[72234, 2899, 440, 9, 61, "Text",
      CellTags->{
      "symmetry group", "group parameter", "solvable subalgebra"}]},
  "solvable subalgebra"->{
    Cell[72234, 2899, 440, 9, 61, "Text",
      CellTags->{
      "symmetry group", "group parameter", "solvable subalgebra"}]},
  "SolvableAlgebrasOfOrderN[]"->{
    Cell[72699, 2912, 140, 3, 23, "Input",
      CellTags->"SolvableAlgebrasOfOrderN[]"]},
  "subalgebra"->{
    Cell[73499, 2929, 291, 6, 44, "Text",
      CellTags->"subalgebra"],
    Cell[75290, 2977, 146, 4, 27, "Text",
      CellTags->{"Lie matrix", "subalgebra"}]},
  "third-order derivative"->{
    Cell[79731, 3127, 181, 6, 27, "Text",
      CellTags->"third-order derivative"]},
  "second-order derivative"->{
    Cell[80766, 3162, 210, 5, 44, "Text",
      CellTags->"second-order derivative"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Higher order ordinary differential equations", 86802, 3360},
  {"fluid dynamics", 87172, 3367},
  {"elasticity", 87370, 3372},
  {"symbolic solution", 87575, 3377},
  {"symbolic technique producing explicit solutions", 87810, 3382},
  {"Integrating factor method", 88023, 3387},
  {"integrating factor", 88140, 3390},
  {"Lie matrix", 88379, 3396},
  {"higher prolongation", 89644, 3424},
  {"prolongation", 89885, 3430},
  {"determination of the multiplier of adifferential equation", 90384, 3441},
  {"algorithm", 90622, 3447},
  {"higher-order equation", 91059, 3456},
  {"finite symmetry", 91194, 3459},
  {"quadrature method", 91356, 3463},
  {"group theoretic algorithm", 91526, 3467},
  {"Lie algebra", 91682, 3471},
  {"tangent vector", 91820, 3474},
  {"group constant", 91958, 3477},
  {"Lie determinant", 92097, 3480},
  {"first integral", 92319, 3485},
  {"infinitesimals", 92926, 3500},
  {"eq-27", 93321, 3509},
  {"third-order equation", 93430, 3512},
  {"Kamke", 93526, 3515},
  {"necessary number of symmetries", 93701, 3520},
  {"Infinitesimals[]", 94002, 3527},
  {"symmetry group", 94140, 3530},
  {"group constants", 94496, 3538},
  {"order of equation", 94735, 3544},
  {"integrating algorithm", 94978, 3550},
  {"quadratic polynomial", 95220, 3556},
  {"unique solution", 95343, 3559},
  {"radical", 95436, 3562},
  {"hydrodynamic equations", 95538, 3565},
  {"integration process", 95727, 3570},
  {"first integrals", 95912, 3575},
  {"vector field", 96030, 3578},
  {"DeltaMatrix[]", 96149, 3581},
  {"determinant", 96279, 3584},
  {"matrix", 96458, 3589},
  {"FirstIntegral[]", 96551, 3592},
  {"Integrate[]", 96687, 3595},
  {"second-order ODE", 96828, 3598},
  {"DSolve[]", 96961, 3601},
  {"higher-order ODE", 97128, 3606},
  {"fourth-order ODE", 97232, 3609},
  {"integrating factor method", 97377, 3612},
  {"group parameter", 97512, 3615},
  {"solvable subalgebra", 97668, 3619},
  {"SolvableAlgebrasOfOrderN[]", 97831, 3623},
  {"subalgebra", 97940, 3626},
  {"third-order derivative", 98133, 3631},
  {"second-order derivative", 98250, 3634}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 407, 5, 43, "Section",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Higher order ordinary differential equations"],
Cell[2149, 58, 800, 13, 95, "Text",
  CellTags->{
  "fluid dynamics", "elasticity", "symbolic solution", 
    "symbolic technique producing explicit solutions"}],

Cell[CellGroupData[{
Cell[2974, 75, 96, 1, 41, "Subsection",
  CellTags->"Integrating factor method"],
Cell[3073, 78, 647, 13, 61, "Text",
  CellTags->{
  "integrating factor", "Lie matrix", "higher prolongation", "prolongation", 
    "determination of the multiplier of adifferential equation"}],
Cell[3723, 93, 646, 15, 61, "Text",
  CellTags->{"Lie matrix", "algorithm", "higher-order equation"}],
Cell[4372, 110, 132, 5, 27, "Text"],
Cell[4507, 117, 128, 3, 23, "NumberedEquation"],
Cell[4638, 122, 677, 23, 46, "Text"],
Cell[5318, 147, 141, 3, 23, "NumberedEquation"],
Cell[5462, 152, 214, 8, 28, "Text"],
Cell[5679, 162, 920, 25, 78, "Text",
  CellTags->{
  "finite symmetry", "quadrature method", "group theoretic algorithm"}],
Cell[6602, 189, 708, 22, 34, "ListItem",
  CellTags->{"Lie algebra", "tangent vector", "group constant"}],
Cell[7313, 213, 619, 24, 62, "ListItem"],
Cell[7935, 239, 584, 19, 20, "ListItem",
  CellTags->{"Lie determinant", "first integral"}],
Cell[8522, 260, 1336, 32, 67, "NumberedEquation"],
Cell[9861, 294, 70, 2, 20, "ListItem"],
Cell[9934, 298, 1263, 29, 81, "NumberedEquation"],
Cell[11200, 329, 477, 15, 20, "ListItem",
  CellTags->{"Lie matrix", "Lie determinant"}],
Cell[11680, 346, 828, 17, 69, "NumberedEquation"],
Cell[12511, 365, 883, 31, 34, "ListItem",
  CellTags->{"infinitesimals", "first integral"}],
Cell[13397, 398, 589, 15, 35, "NumberedEquation",
  CellTags->"eq-27"],
Cell[13989, 415, 152, 5, 20, "ListItem"],
Cell[14144, 422, 405, 14, 34, "ListItem"],
Cell[14552, 438, 265, 8, 20, "ListItem"],
Cell[14820, 448, 278, 5, 44, "Text"],
Cell[15101, 455, 29, 0, 29, "Example"],
Cell[15133, 457, 246, 7, 27, "Text",
  CellTags->"third-order equation"],

Cell[CellGroupData[{
Cell[15404, 468, 293, 6, 46, "Input"],
Cell[15700, 476, 739, 23, 30, "Output"]
}, Open  ]],
Cell[16454, 502, 419, 9, 61, "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{
Cell[16898, 515, 69, 1, 23, "Input"],
Cell[16970, 518, 898, 23, 30, "Output"]
}, Open  ]],
Cell[17883, 544, 564, 13, 63, "Text",
  CellTags->{"necessary number of symmetries", "Infinitesimals[]"}],

Cell[CellGroupData[{
Cell[18472, 561, 173, 3, 23, "Input"],
Cell[18648, 566, 122, 2, 23, "Output"]
}, Open  ]],
Cell[18785, 571, 1021, 26, 95, "Text",
  CellTags->{
  "symmetry group", "group constants", "order of equation", 
    "integrating algorithm", "algorithm", "Lie matrix", "prolongation"}],
Cell[19809, 599, 198, 4, 23, "Input"],
Cell[20010, 605, 200, 4, 23, "Input"],
Cell[20213, 611, 200, 4, 23, "Input"],
Cell[20416, 617, 70, 1, 27, "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{
Cell[20511, 622, 340, 8, 64, "Input"],
Cell[20854, 632, 512, 16, 82, "Output"]
}, Open  ]],
Cell[21381, 651, 82, 1, 27, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[21488, 656, 153, 3, 23, "Input"],
Cell[21644, 661, 113, 2, 44, "Output"]
}, Open  ]],
Cell[21772, 666, 486, 14, 44, "Text"],

Cell[CellGroupData[{
Cell[22283, 684, 84, 1, 23, "Input"],
Cell[22370, 687, 834, 19, 41, "Output"]
}, Open  ]],
Cell[23219, 709, 266, 7, 44, "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{
Cell[23510, 720, 131, 3, 23, "Input"],
Cell[23644, 725, 1126, 23, 81, "Output"]
}, Open  ]],
Cell[24785, 751, 163, 4, 27, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[24973, 759, 97, 2, 23, "Input"],
Cell[25073, 763, 863, 19, 75, "Output"]
}, Open  ]],
Cell[25951, 785, 330, 11, 44, "Text"],

Cell[CellGroupData[{
Cell[26306, 800, 80, 1, 23, "Input"],
Cell[26389, 803, 803, 18, 64, "Output"]
}, Open  ]],
Cell[27207, 824, 365, 10, 44, "Text",
  CellTags->{"quadratic polynomial", "Lie matrix"}],

Cell[CellGroupData[{
Cell[27597, 838, 134, 3, 23, "Input"],
Cell[27734, 843, 1015, 17, 114, "Output"]
}, Open  ]],
Cell[28764, 863, 280, 10, 27, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[29069, 877, 98, 2, 23, "Input"],
Cell[29170, 881, 2991, 52, 248, "Output"]
}, Open  ]],
Cell[32176, 936, 272, 7, 44, "Text",
  CellTags->"unique solution"],

Cell[CellGroupData[{
Cell[32473, 947, 79, 1, 23, "Input"],
Cell[32555, 950, 2649, 46, 200, "Output"]
}, Open  ]],
Cell[35219, 999, 632, 22, 61, "Text"],
Cell[35854, 1023, 269, 5, 34, "Input"],

Cell[CellGroupData[{
Cell[36148, 1032, 394, 8, 71, "Input"],
Cell[36545, 1042, 20143, 1352, 143, 10479, 1228, "GraphicsData", \
"PostScript", "Output"]
}, Open  ]],
Cell[56703, 2397, 113, 4, 27, "Text"],
Cell[56819, 2403, 687, 22, 29, "DisplayFormula"],
Cell[57509, 2427, 311, 7, 44, "Text"],
Cell[57823, 2436, 535, 11, 61, "Text",
  CellTags->"radical"],
Cell[58361, 2449, 28, 0, 29, "Example"],
Cell[58392, 2451, 214, 4, 44, "Text"],
Cell[58609, 2457, 205, 5, 23, "NumberedEquation"],
Cell[58817, 2464, 598, 12, 61, "Text",
  CellTags->{
  "hydrodynamic equations", "necessary number of symmetries", 
    "integration process"}],

Cell[CellGroupData[{
Cell[59440, 2480, 318, 7, 39, "Input"],
Cell[59761, 2489, 693, 21, 23, "Output"]
}, Open  ]],
Cell[60469, 2513, 141, 2, 27, "Text"],

Cell[CellGroupData[{
Cell[60635, 2519, 178, 3, 23, "Input"],
Cell[60816, 2524, 239, 5, 34, "Output"]
}, Open  ]],
Cell[61070, 2532, 489, 11, 61, "Text",
  CellTags->{"first integrals", "vector field"}],
Cell[61562, 2545, 198, 4, 23, "Input"],
Cell[61763, 2551, 200, 4, 23, "Input"],
Cell[61966, 2557, 200, 4, 23, "Input"],
Cell[62169, 2563, 98, 2, 27, "Text"],

Cell[CellGroupData[{
Cell[62292, 2569, 209, 4, 23, "Input"],
Cell[62504, 2575, 138, 2, 35, "Output"]
}, Open  ]],
Cell[62657, 2580, 309, 8, 29, "Text",
  CellTags->{"Lie matrix", "infinitesimals", "DeltaMatrix[]"}],

Cell[CellGroupData[{
Cell[62991, 2592, 175, 3, 23, "Input"],
Cell[63169, 2597, 820, 23, 86, "Output"]
}, Open  ]],
Cell[64004, 2623, 253, 9, 27, "Text",
  CellTags->{"determinant", "Lie matrix"}],

Cell[CellGroupData[{
Cell[64282, 2636, 81, 1, 23, "Input"],
Cell[64366, 2639, 140, 2, 36, "Output"]
}, Open  ]],
Cell[64521, 2644, 189, 3, 27, "Text",
  CellTags->"matrix"],

Cell[CellGroupData[{
Cell[64735, 2651, 121, 3, 23, "Input"],
Cell[64859, 2656, 380, 9, 34, "Output"]
}, Open  ]],
Cell[65254, 2668, 846, 24, 80, "Text",
  CellTags->{"FirstIntegral[]", "Integrate[]", "second-order ODE"}],

Cell[CellGroupData[{
Cell[66125, 2696, 99, 2, 23, "Input"],
Cell[66227, 2700, 336, 9, 23, "Output"]
}, Open  ]],
Cell[66578, 2712, 176, 8, 27, "Text"],

Cell[CellGroupData[{
Cell[66779, 2724, 140, 3, 23, "Input"],
Cell[66922, 2729, 248, 6, 23, "Output"]
}, Open  ]],
Cell[67185, 2738, 141, 4, 29, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[67351, 2746, 84, 1, 23, "Input"],
Cell[67438, 2749, 303, 6, 34, "Output"]
}, Open  ]],
Cell[67756, 2758, 132, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[67913, 2765, 67, 1, 23, "Input"],
Cell[67983, 2768, 37, 1, 23, "Output"]
}, Open  ]],
Cell[68035, 2772, 238, 6, 44, "Text"],

Cell[CellGroupData[{
Cell[68298, 2782, 62, 1, 23, "Input"],
Cell[68363, 2785, 1078, 26, 23, "Output"]
}, Open  ]],
Cell[69456, 2814, 176, 5, 27, "Text"],
Cell[69635, 2821, 429, 6, 61, "Text",
  CellTags->"higher-order ODE"],
Cell[70067, 2829, 28, 0, 29, "Example"],
Cell[70098, 2831, 651, 12, 78, "Text",
  CellTags->{"fourth-order ODE", "integrating factor method"}],

Cell[CellGroupData[{
Cell[70774, 2847, 203, 4, 23, "Input"],
Cell[70980, 2853, 103, 2, 24, "Output"]
}, Open  ]],
Cell[71098, 2858, 90, 3, 27, "Text"],
Cell[71191, 2863, 302, 9, 24, "NumberedEquation"],
Cell[71496, 2874, 400, 11, 44, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[71921, 2889, 149, 3, 23, "Input"],
Cell[72073, 2894, 146, 2, 23, "Output"]
}, Open  ]],
Cell[72234, 2899, 440, 9, 61, "Text",
  CellTags->{"symmetry group", "group parameter", "solvable subalgebra"}],

Cell[CellGroupData[{
Cell[72699, 2912, 140, 3, 23, "Input",
  CellTags->"SolvableAlgebrasOfOrderN[]"],
Cell[72842, 2917, 642, 9, 68, "Output"]
}, Open  ]],
Cell[73499, 2929, 291, 6, 44, "Text",
  CellTags->"subalgebra"],

Cell[CellGroupData[{
Cell[73815, 2939, 293, 5, 39, "Input"],
Cell[74111, 2946, 542, 7, 113, "Output"]
}, Open  ]],
Cell[74668, 2956, 350, 8, 44, "Text",
  CellTags->{"infinitesimals", "algorithm"}],

Cell[CellGroupData[{
Cell[75043, 2968, 151, 3, 23, "Input"],
Cell[75197, 2973, 78, 1, 38, "Output"]
}, Open  ]],
Cell[75290, 2977, 146, 4, 27, "Text",
  CellTags->{"Lie matrix", "subalgebra"}],

Cell[CellGroupData[{
Cell[75461, 2985, 219, 4, 23, "Input"],
Cell[75683, 2991, 548, 14, 88, "Output"]
}, Open  ]],
Cell[76246, 3008, 101, 1, 27, "Text",
  CellTags->"determinant"],

Cell[CellGroupData[{
Cell[76372, 3013, 81, 1, 23, "Input"],
Cell[76456, 3016, 66, 1, 34, "Output"]
}, Open  ]],
Cell[76537, 3020, 227, 4, 44, "Text",
  CellTags->"Lie matrix"],

Cell[CellGroupData[{
Cell[76789, 3028, 121, 3, 23, "Input"],
Cell[76913, 3033, 642, 17, 34, "Output"]
}, Open  ]],
Cell[77570, 3053, 80, 1, 27, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[77675, 3058, 121, 3, 23, "Input"],
Cell[77799, 3063, 480, 14, 36, "Output"]
}, Open  ]],
Cell[78294, 3080, 793, 22, 78, "Text",
  CellTags->"first integral"],

Cell[CellGroupData[{
Cell[79112, 3106, 100, 2, 23, "Input"],
Cell[79215, 3110, 501, 14, 34, "Output"]
}, Open  ]],
Cell[79731, 3127, 181, 6, 27, "Text",
  CellTags->"third-order derivative"],

Cell[CellGroupData[{
Cell[79937, 3137, 113, 2, 23, "Input"],
Cell[80053, 3141, 698, 18, 34, "Output"]
}, Open  ]],
Cell[80766, 3162, 210, 5, 44, "Text",
  CellTags->"second-order derivative"],

Cell[CellGroupData[{
Cell[81001, 3171, 86, 1, 23, "Input"],
Cell[81090, 3174, 731, 18, 49, "Output"]
}, Open  ]],
Cell[81836, 3195, 342, 8, 48, "Text",
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[82203, 3207, 80, 1, 23, "Input"],
Cell[82286, 3210, 635, 16, 49, "Output"]
}, Open  ]],
Cell[82936, 3229, 51, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[83012, 3233, 70, 1, 23, "Input"],
Cell[83085, 3236, 253, 6, 53, "Output"]
}, Open  ]],
Cell[83353, 3245, 145, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[83523, 3254, 70, 1, 23, "Input"],
Cell[83596, 3257, 253, 6, 53, "Output"]
}, Open  ]],
Cell[83864, 3266, 433, 10, 61, "Text",
  CellTags->"Kamke"],

Cell[CellGroupData[{
Cell[84322, 3280, 61, 1, 23, "Input"],
Cell[84386, 3283, 40, 1, 23, "Output"]
}, Open  ]],
Cell[84441, 3287, 129, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[84595, 3294, 61, 1, 23, "Input"],
Cell[84659, 3297, 40, 1, 23, "Output"]
}, Open  ]],
Cell[84714, 3301, 165, 2, 27, "Text"],
Cell[84882, 3305, 147, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

