(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    213500,       6221]*)
(*NotebookOutlinePosition[    281739,       7819]*)
(*  CellTagsIndexPosition[    272996,       7615]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5", "ChapterLine",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Point Symmetries of Partial Differential Equations"],

Cell["\<\
Point Symmetries of Partial
Differential Equations\
\>", "Title",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[CellGroupData[{

Cell["5.1 Introduction", "Section",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Introduction"],

Cell[TextData[
"The subject of this section is to discuss the basic tools of Lie\
\[CloseCurlyQuote]s symmetry method in connection with partial differential \
equations. These tools will support the practical calculations. We will show \
how the theory of Lie becomes vital again by using computer algebra \
calculations."], "Text",
  CellTags->{
  "tools of Lie's symmetry method", "partial differential equation", 
    "computer algebra"}],

Cell[TextData[{
  "The theory under discussion is the symmetry theory of Lie. This theory is \
useful for solving partial differential equations in a systematic way. The \
question Lie had raised more than 100 years ago was how to systematically \
solve differential equations. He was wondering about the many methods his \
colleagues used in solving differential equations. Up to the present day, \
this question of deriving solutions for a given differential equation has \
been of topical interest for physicists and mathematicians alike. Lie found a \
solution to this problem by introducing a method which allows the examination \
of symmetry transformations of equations. Using this method, he was able to \
find solutions not only for ordinary differential equations as discussed in \
C",
  ButtonBox["hapter 4",
    ButtonData:>{"symmet1.nb", 
      "Symmetries of Ordinary Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " but also for non-linear partial differential equations."
}], "Text",
  CellTags->{
  "symmetry theory of Lie", "partial differential equation", 
    "systematically solve differential equations", 
    "nonlinear partial differential equation"}],

Cell[TextData[
"From these remarks, we can deduce that Lie\[CloseCurlyQuote]s method is \
capable of handling a large number of equations. The application of this \
method depends neither on the type of the equation nor on the number of \
variables involved in the equations. Lie\[CloseCurlyQuote]s method is a \
general procedure appropriate for any type of differential equation. However, \
perusing the literature on Lie\[CloseCurlyQuote]s method, we observe that \
this method has rarely been applied, compared with the wealth of differential \
equations in practical and theoretical problems."], "Text"],

Cell[TextData[{
  "The reason for the widespread rejection of Lie\[CloseCurlyQuote]s method \
during the last hundred years by the community of mathematicians and \
physicists is that his method demands a huge number of algebraic calculations \
in order to extract the symmetries of a differential equation. Even for \
simple equations, the algebraic amount of calculations is large compared to \
other methods. If someone is genial enough to guess a solution to solve a \
particular problem, he probably does not have a deeper insight into the \
solution structure of the equation. However, if he or she is interested in a \
complete solution of the symmetry problem, the reader is offered the ability \
to obtain the information needed on an equation by using a symbolic \
calculation in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". This tool allows us to completely solve the symmetry problem either in a \
non-interactive or an interactive way."
}], "Text",
  CellTags->{
  "Lie's method", "algebraic calculation", 
    "symmetries of a differential equation", 
    "symbolic calculation in MathLie"}],

Cell[TextData[{
  "This chapter is organized as follows: In Section 5.2 we review Lie\
\[CloseCurlyQuote]s method using the terminology of today. In Section 5.3, we \
introduce the invariance condition based on Fr\[EAcute]chet derivatives. \
Section 5.4 discusses some capabilities of the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and presents some examples of how to use ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to find symmetries. Section 5.5 introduces the term similarity reduction. \
Section 5.6 is devoted to a number of applications of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Lie's method", "MathLie"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "5.2 ",
  "Lie's Theory Used in ",
  StyleBox["MathLie",
    FontSlant->"Italic"]
}], "Section",
  CellTags->"Lie's theory used in MathLie"],

Cell["\<\
In his work, Lie pointed out that the symmetry of any differential \
equation is defined as follows:\
\>", "Text",
  CellTags->"symmetry of a differential equation"],

Cell["Definition: Lie symmetry", "Definition",
  CellTags->"Definition: Lie Symmetry"],

Cell[TextData[
"A Lie (point) symmetry is characterized by an infinitesimal transformation \
which leaves the given differential equation invariant under the \
transformation of all independent and dependent variables.\[ThickSpace]\
\[EmptyCircle]"], "Text",
  Background->None,
  CellTags->{"point symmetry", "Lie symmetry"}],

Cell[TextData[{
  "The Lie symmetries of differential equations (DEQs) naturally form a \
group: Since the composition of any two symmetries is also a symmetry, there \
is an identity transformation; the composition of symmetries is obviously \
associative; and any symmetry has an inverse. Such groups are called Lie \
groups and are invertible point transformations of both the dependent and \
independent variables of the DEQs. The DEQs may depend on continuous \
parameters. Lie pointed out that this group is of great importance in \
understanding and constructing solutions of DEQs. Lie demonstrated that many \
techniques for finding solutions can be unified and extended by considering \
symmetry groups. Today, we know several applications of Lie groups in the \
theory of differential equations (cf. ",
  ButtonBox["Ibragimov [1985]",
    ButtonData:>{"Literat.nb", "Ibra-85"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Ovsiannikov [1982]",
    ButtonData:>{"Literat.nb", "Ovsi-82"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Ibragimov [1994",
    ButtonData:>{"Literat.nb", "Ibra-949596"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[Dash]",
    ButtonData:>{"Literat.nb", "Ibra-949596"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["1996], Baumann [1987]",
    ButtonData:>{"Literat.nb", "Ibra-949596"},
    ButtonStyle->"Hyperlink"],
  "). "
}], "Text",
  CellTags->{
  "group", "composition of two symmetries", "identity transformation", 
    "associative", "inverse symmetry", "invertible point transformation", 
    "point transformation", "Lie groups", "continuous parameter", "unified", 
    "unified technique"}],

Cell["\<\
To use the symmetry groups in any application, we first need to \
find the symmetries of the equations. A first approach to finding point \
symmetries of such systems is to make a general change of all variables and \
then enforce the new variables to satisfy the same set of DEQs. This approach \
leads to complicated non-linear systems of DEQs for the functions used in the \
transformations. Lie demonstrated that such a procedure is unnecessary. He \
established an efficient method based on an infinitesimal formulation of the \
problem of finding the symmetry group of a set of DEQs, replacing these \
highly complicated and in most cases intractable non-linear equations by \
tractable linear overdetermined systems of partial differential equations. \
The solution of these so-called infinitesimal determining equations can be \
used to determine symmetry transformations.\
\>", "Text",
  CellTags->{
  "calculate symmetries", "point symmetries", "nonlinear systems of DEQs", 
    "transformation", "infinitesimal formulation", "symmetry group", 
    "nonlinear equation", 
    "linear overdetermined systems of partial differential equations", 
    "infinitesimal determining equations", "symmetry transformation"}],

Cell[TextData[{
  "Let us consider the general case of a non-linear system of differential \
equations for an arbitrary number ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " of unknown functions ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  " which may depend on ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". We denote these sets of variables simply by ",
  Cell[BoxData[
      \(TraditionalForm\`u = \((u\^1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\^2\)]],
  ", \[Ellipsis] , ",
  Cell[BoxData[
      \(TraditionalForm\`u\^q\)]],
  ") and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\(x = \((x\_1\)\),
                "TraditionalForm"], ",", \(x\_2\)}],
            "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", \(x\_p\)}], 
        TraditionalForm]]],
  "), respectively. The general case is given by a system of ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " non-linear differential equations"
}], "Text",
  CellTags->{
  "nonlinear system of differential equations", 
    "nonlinear differential equations"}],

Cell[BoxData[
    \(TraditionalForm\`\(\[CapitalDelta]\^i\)(x, u\_\((k)\))\  = \ 0\ , 
    \ \ \ \ \ \ \ \ i = 1, 2, \[Ellipsis], m\)], "NumberedEquation",
  CellTags->"eq-1"],

Cell[TextData[{
  "of order ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ".  The term ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  " is understood as the ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "th derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". We note that ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are arbitrary, positive integers. Consider, further, a one-parameter \
\[Epsilon]-Lie group of transformations"
}], "Text",
  CellTags->"one-parameter \[Epsilon]-Lie group"],

Cell[BoxData[
    \(TraditionalForm\`\(\(x\^*\) = \ \[CapitalXi](x, u, \[Epsilon])\ , 
    \)\)], "NumberedEquation",
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-2"],

Cell[BoxData[
    \(TraditionalForm\`\(\(u\^*\)\  = \ \[CapitalPhi](x, u, \[Epsilon])\ \ \ 
    \)\)], "NumberedEquation",
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-3"],

Cell[TextData[{
  "under which ",
  ButtonBox["(5.1)",
    ButtonData:>"eq-1",
    ButtonStyle->"Hyperlink"],
  " must be invariant. The star on the variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " denote the new variables. Invariance of ",
  ButtonBox["(5.1)",
    ButtonData:>"eq-1",
    ButtonStyle->"Hyperlink"],
  " under the action of (5.",
  ButtonBox["2",
    ButtonData:>"eq-2",
    ButtonStyle->"Hyperlink"],
  ") and (5.",
  ButtonBox["3",
    ButtonData:>"eq-3",
    ButtonStyle->"Hyperlink"],
  ") means that any solution ",
  Cell[BoxData[
      \(TraditionalForm\`u = \[CapitalTheta](x)\)]],
  " of (5.1) maps into some other solution",
  Cell[BoxData[
      \(TraditionalForm\`\(\ v = \[CapitalPsi](x; \ \[Epsilon])\)\)]],
  " of (5.1).  Let ",
  Cell[BoxData[
      \(TraditionalForm\`u = \[CapitalTheta](x)\)]],
  " be a solution of (5.1).  If we replace the dependent and independent \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\^*\) = \[CapitalXi]\)]],
  ", respectively, equations (5.1) become"
}], "Text",
  CellTags->{"new variable", "solution maps into other solution"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[CapitalDelta]\^i\)(\(x\^*\), v\_\((k)\))\  = \ 0\ , \ \ \ \ i = 1, 
    2, \[Ellipsis], \(m . \)\)], "NumberedEquation",
  CellTags->"eq-4"],

Cell[TextData[{
  "Then, ",
  Cell[BoxData[
      \(TraditionalForm\`v = \[CapitalTheta](\(x\^*\))\)]],
  " are solutions of ",
  ButtonBox["(5.4)",
    ButtonData:>"eq-4",
    ButtonStyle->"Hyperlink"],
  ". This implies that if (5.1) and (5.4) have a unique solution, then"
}], "Text",
  CellTags->"unique solution"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(\[CapitalTheta](\(x\^*\)\),
            "TraditionalForm"], ")"}], " ", "=", " ", 
        \(\[CapitalPhi](x, \ \[CapitalTheta](x), \ \[Epsilon]\ ) . \)}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"eq-5"],

Cell[TextData[
"Hence, \[CapitalTheta] satisfies the one-parameter functional equation"], 
  "Text",
  CellTags->"one-parameter functional equation"],

Cell[BoxData[
    \(TraditionalForm
    \`\[CapitalTheta](\[CapitalXi](x, \[Epsilon]))\  = \ 
      \(\[CapitalPhi](x, \[CapitalTheta], \[Epsilon]) . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "Expanding equations ",
  ButtonBox["(5.2)",
    ButtonData:>"eq-2",
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["(5.3)",
    ButtonData:>"eq-3",
    ButtonStyle->"Hyperlink"],
  " around the identity ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ", we can generate the following infinitesimal transformations:"
}], "Text",
  CellTags->"infinitesimal transformation"],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ 
    \(x\_i\%*\)\  = \ 
      x\_i\  + \ \[Epsilon]\ \(\(\[Xi]\_i\)(x, u)\)\  + \ O(\[Epsilon]\^2)\ , 
    \ \ \ \ \ \ \ \ \ \ i = 1, 2, \[Ellipsis], p\)\)], "NumberedEquation",
  CellTags->"eq-7"],

Cell[BoxData[
    \(TraditionalForm
    \`u\^\(*\[Alpha]\)\  = \ 
      u\^\[Alpha]\  + \ \[Epsilon]\ \(\(\[Phi]\_\[Alpha]\)(x, u)\)\  + \ 
        O(\[Epsilon]\^2)\ , \ \ \ \ \ \ \[Alpha] = 1, 2, \[Ellipsis], q\)], 
  "NumberedEquation",
  CellTags->"eq-8"],

Cell[TextData[{
  "where the functions ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " are the infinitesimals of the transformations for the independent and \
dependent variables, respectively. In order to find the unknown \
infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  ", we need to extend or prolong the transformation group to include the \
properties of the derivatives. It is an infinitesimal approach which \
considers the Lie algebra \[GothicCapitalL] corresponding to the Lie group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". Generalizing the formulas of C",
  ButtonBox["hapter 4,",
    ButtonData:>{"symmet1.nb", 
      "Symmetries of Ordinary Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " the infinitesimal transformation (5.",
  ButtonBox["7)",
    ButtonData:>"eq-7",
    ButtonStyle->"Hyperlink"],
  " and (5.",
  ButtonBox["8",
    ButtonData:>"eq-8",
    ButtonStyle->"Hyperlink"],
  ") can be put into the form"
}], "Text",
  CellTags->{
  "transformation", "infinitesimals", "prolong the transformation group", 
    "Lie-algebra", "Lie group", "infinitesimal transformation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(v\&\[RightVector]\  = \ 
      \[Sum]\+\(i = 1\)\%p\(\( \[Xi]\_i\)(x, u)\)\ 
            \[PartialD]\/\[PartialD]x\_i\  + \ 
        \[Sum]\+\(\[Alpha] = 1\)\%q\(\( \[Phi]\_\[Alpha]\)(x, u)\)\ 
            \[PartialD]\/\[PartialD]u\_\[Alpha], \)\)], "NumberedEquation",
  CellTags->"eq-9"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " represents a linear combination of the vector fields generating \
\[GothicCapitalL], which, in turn, is based on the characteristic quantities \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " of the transformation (5.7) and (5.8). The algorithm used in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " for finding the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " is described below. We emphasize that the infinitesimals in this simple \
form only depend on independent and dependent variables. A prolongation of \
the dependencies to derivatives extends the Lie symmetries to so-called \
generalized Lie symmetries, which are discussed in C",
  ButtonBox["hapter 9",
    ButtonData:>{"Symmet75.nb", 
      "Generalized Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  ". Transformations (5.7) and (5.8), together with the transformations for \
the first, second, \[Ellipsis] derivatives of the ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\[Alpha]\)]],
  "\[CloseCurlyQuote]s, are called first, second,\[ThinSpace]\[Ellipsis]\
\[ThinSpace]prolongations. Using these various extensions, the infinitesimal \
criterion for the invariance of ",
  ButtonBox["(5.1)",
    ButtonData:>"eq-1",
    ButtonStyle->"Hyperlink"],
  " under the group (5.",
  ButtonBox["2",
    ButtonData:>"eq-2",
    ButtonStyle->"Hyperlink"],
  ") and (5.",
  ButtonBox["3",
    ButtonData:>"eq-3",
    ButtonStyle->"Hyperlink"],
  ") is derivable by"
}], "Text",
  CellTags->{
  "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
    "generalized Lie symmetries", "infinitesimal criterion of invariance"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(pr\^\((k)\)\) v\&\[RightVector]\ \[CapitalDelta]\ 
      \[VerticalSeparator]\_\(\[CapitalDelta] = 0\)\ \( = \ 0\), \)\)], 
  "NumberedEquation",
  CellTags->"eq-10"],

Cell[TextData[{
  "where the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\ \)\&\[RightVector]\)]],
  " is given by"
}], "Text",
  CellTags->{"kth prolongation", "prolongation"}],

Cell[BoxData[
    \(TraditionalForm
    \`pr\^\((k)\)\ \(v\& \[RightVector] \)\  = \ 
      \(v\& \[RightVector] \)\  + \ 
        \[Sum]\+\(\[Alpha] = 1\)\%q
            \(\[Sum]\+J\(\( \[Phi]\_\[Alpha]\%J\)(x, u\_\((k)\))\)\ 
              \[PartialD]\/\[PartialD]u\_J\%\[Alpha]\) . \)], 
  "NumberedEquation",
  CellTags->"eq-11"],

Cell[TextData[{
  "The second summation extends over all multi-indices ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\(J = \((j\_1\)\),
                "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", \(j\_l\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] j\_l \[LessEqual] p\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] \ l \[LessEqual] k\)]],
  ". The ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation coefficients ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\%J\)]],
  " are given by"
}], "Text",
  CellTags->"prolongation coefficients"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\(\[Phi]\_\[Alpha]\%J\)(x, u\^\((k)\))\), " ", "=", " ", 
          RowBox[{
            RowBox[{\(D\_J\), "(", 
              RowBox[{\(\[Phi]\_\[Alpha]\), " ", "-", " ", 
                RowBox[{
                  UnderoverscriptBox[
                    StyleBox["\[Sum]",
                      ScriptLevel->0], \(i = 1\), "p"], 
                  \(\(\[Xi]\_i\) u\_i\%\[Alpha]\)}]}], ")"}], " ", "+", " ", 
            RowBox[{
              UnderoverscriptBox[
                StyleBox["\[Sum]",
                  ScriptLevel->0], \(i = 1\), "p"], 
              \(\(\[Xi]\_i\) u\_\(J, i\)\%\[Alpha]\)}]}]}], " ", ","}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"eq-12"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm
      \`u\_i\%\[Alpha]\  = \ \[PartialD]u\^\[Alpha]/\[PartialD]x\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm
      \`u\_\(J, i\)\%\[Alpha]\  = \ 
        \[PartialD]u\_J\%\[Alpha]/\[PartialD]x\_i\)]],
  ". Thus, the system of differential equations ",
  ButtonBox["(5.1)",
    ButtonData:>"eq-1",
    ButtonStyle->"Hyperlink"],
  " is invariant under the transformation of a one-parameter group with the \
infinitesimal generator ",
  ButtonBox["(5.9)",
    ButtonData:>"eq-9",
    ButtonStyle->"Hyperlink"],
  " if the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  "'",
  "s and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  "\[CloseCurlyQuote]s are determined from equation ",
  ButtonBox["(5.10)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"one-parameter group", "infinitesimal generator"}],

Cell[TextData[{
  "So far, we discussed the standard procedure to derive the determining \
equations for the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  ". This procedure is widely used in the literature (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Ibragimov [1985]",
    ButtonData:>{"Literat.nb", "Ibra-85"},
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["Bluman and Kumei [1990]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  ", and ",
  ButtonBox["Ovsiannikov [1982]",
    ButtonData:>{"Literat.nb", "Ovsi-82"},
    ButtonStyle->"Hyperlink"],
  "). From a calculation point of view, the procedure described above is very \
inefficient and time- and memory-consuming. The main slowing-down step of the \
procedure is the recursive calculation of the expansion coefficients in \
equation ",
  ButtonBox["(5.11)",
    ButtonData:>"eq-11",
    ButtonStyle->"Hyperlink"],
  ". The following section will discuss a more efficient way to derive the \
determining equations. This procedure is based on the powerful \
pattern-matching capability of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and uses the ",
  ButtonBox["Fr\[EAcute]chet derivative",
    ButtonData:>{"derivat.nb", "The Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  " to represent the invariance condition ",
  ButtonBox["(5.10)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{
  "determining equations", "infinitesimals", "Fr\[EAcute]chet derivative", 
    "invariance condition"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.3 Invariance Based on Fr\[EAcute]chet Derivatives", "Section",
  CellTags->"Invariance Based on Frechet Derivatives"],

Cell["\<\
The Fr\[EAcute]chet derivative can be considered as a \
generalization of the complete derivative. In this section, we will use this \
type of derivative to formulate an efficient procedure for the calculation of \
the invariance condition used in the derivation of the determining equations.\
\
\>", "Text",
  CellTags->{
  "Fr\[EAcute]chet derivative", "calculation of the invariance condition", 
    "determining equations"}],

Cell[TextData[{
  ButtonBox["The Fr\[EAcute]chet",
    ButtonData:>{"derivat.nb", "Definition: Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  " derivative of a support function ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " with respect to a test function ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " was defined in C",
  ButtonBox["hapter 2",
    ButtonData:>{"derivat.nb", "Definition: Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]],
  "by"
}], "Text",
  CellTags->{"support function", "test function"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(\[GothicCapitalD]\_P\)(Q)\), " ", "=", " ", 
        RowBox[{
          FractionBox["d", 
            StyleBox[
              RowBox[{
                StyleBox["d",
                  FontSlant->"Italic"], "\[Epsilon]"}]]], 
          \(P(u + \[Epsilon]Q)\), 
          \(\[VerticalSeparator]\_\(\[Epsilon] = 0\) . \)}]}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"eq-13"],

Cell[TextData[{
  "The meaning of equation ",
  ButtonBox["(5.13)",
    ButtonData:>"eq-13",
    ButtonStyle->"Hyperlink"],
  " is that in the support ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  ", we have to replace the dependent variables and their derivatives by a \
variation of the original variables. The variation is represented by the \
variables themselves and by a test function weighted by a parameter \
\[Epsilon]. After the substitution, we differentiate with respect to \
\[Epsilon] and then set ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Epsilon] = 0\)\)]],
  "."
}], "Text",
  CellTags->{"support", "variation of the argument"}],

Cell[TextData[{
  "This relation defined for an ",
  StyleBox["r",
    FontSlant->"Italic"],
  "-dimensional support ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " and for a ",
  StyleBox["q",
    FontSlant->"Italic"],
  "-dimensional test function ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " can be implemented very efficiently in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " The implementation was given in S",
  ButtonBox["ection 3.5",
    ButtonData:>{"derivat.nb", "FrechetD"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell[TextData[{
  "Let us now briefly discuss the connection between the invariance condition \
",
  ButtonBox["(5.10)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  " and the Fr\[EAcute]chet derivative. To calculate the determining \
equations, we need the prolongation of a vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  " applied to the system of differential equations \[CapitalDelta]. If we \
assume that the related characteristic ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " depends on the dependent variables and their derivatives, we can write \
down a relation which connects the prolongation of a differential system with \
the Fr\[EAcute]chet derivative of the system in an evolutionary \
representation (cf. ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "). The term evolutionary representation means that we consider \
infinitesimal transformations independent of the independent variables. The \
connection between the prolongation and the Fr\[EAcute]chet derivative is \
given by"
}], "Text",
  CellTags->{
  "invariance condition", "Fr\[EAcute]chet derivative", 
    "determining equations", "prolongation", "vector field", 
    "system of differential equations", "characteristic", 
    "evolutionary representation", "infinitesimal transformation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(pr\^\((k)\)\) \(\(v\&\[RightVector]\_Q\)(\[CapitalDelta])\)\  = \ 
      \(\[GothicCapitalD]\_\[CapitalDelta]\)(Q), \)\)], "NumberedEquation",
  CellTags->"eq-14"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " is now the support and we have in mind that \[CapitalDelta] is the system \
of partial differential equations. ",
  "This relation follows from the definition of the prolongation in \
evolutionary representation:"
}], "Text",
  CellTags->{
  "support", "system of partial differential equations", 
    "prolongation in evolutionary representation"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(pr\^\((k)\)\ \(v\& \[RightVector] \)\_Q\), " ", "=", " ", 
        RowBox[{
          UnderoverscriptBox[
            StyleBox["\[Sum]",
              ScriptLevel->0], \(\[Alpha] = 1\), "p"], \(\[Sum]\+J\), 
          \(\(D\_J\) Q\_\[Alpha]\ 
            \[PartialD]\/\[PartialD]u\_J\%\[Alpha]\)}]}], TraditionalForm]], 
  "NumberedEquation",
  CellTags->"eq-15"],

Cell[TextData[{
  "with ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\  = \ \(Q\_\[Alpha]\)(u\^\((k)\))\)]],
  " depending only on the derivatives of the dependent variables ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, \[Ellipsis]\)]],
  ". If, in addition, we use the definition of the Fr\[EAcute]chet derivative \
given by equation ",
  ButtonBox["(5.13)",
    ButtonData:>"eq-13",
    ButtonStyle->"Hyperlink"],
  ", we can immediately reproduce equation ",
  ButtonBox["(5.14)",
    ButtonData:>"eq-14",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"Fr\[EAcute]chet derivative"],

Cell[TextData[{
  "Thus, the prolongation operator is related to the Fr\[EAcute]chet \
derivative. We can utilize this relation to reformulate the invariance \
condition ",
  ButtonBox["(5.10)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  ". Applying relation (5.14) and the definition of the evolutionary vector \
field, we are able to replace the invariance condition (5.10) by the \
relation"
}], "Text",
  CellTags->{"invariance condition", "evolutionary vector field"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            RowBox[{
            \(\(\[GothicCapitalD]\_\[CapitalDelta]\)(Q)\), " ", "+", " ", 
              RowBox[{
                UnderoverscriptBox[
                  StyleBox["\[Sum]",
                    ScriptLevel->0], \(i = 1\), "p"], 
                \(\[Xi]\_i\ D\_i\ \[CapitalDelta]\)}]}], ")"}], 
          SubscriptBox[
            StyleBox["\[VerticalSeparator]",
              FontSize->16], 
            UnderscriptBox[\(\[CapitalDelta] = 0\), 
              RowBox[{\(Q\_\[Alpha]\), "=", " ", 
                RowBox[{\(\[Phi]\_\[Alpha]\), "-", 
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox["\[Sum]",
                        ScriptLevel->3], \(i = 1\), "p"], 
                    \(\(\[Xi]\_i\) u\_i\%\[Alpha]\)}]}]}]]]}], "=", "0."}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->{"eq-16", "Invariance condition for point symmetry"}],

Cell[TextData[{
  "At first glance, this expression appears to be very complicated from the \
calculation point of view. Indeed, it is very cumbersome if one tries to use \
this formula in a manual calculation. In fact, in a pencil calculation, we \
first have to replace all dependent variables and their derivatives by the \
variation of the dependent variables which must be extended up to the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th order in the derivatives. After the substitutions, we have to \
differentiate the expression obtained with respect to \[Epsilon] and \
afterward set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ". These steps contain a lot of work if we do them by hand. However, with ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", all the steps are very easy to handle. This is possible because ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "offers powerful matching procedures already implemented in its kernel to \
carry out the calculations."
}], "Text",
  CellTags->"pencil calculation"],

Cell["\<\
The advantage of this method to calculate the prolongation of a \
given system of differential equations is not only its fast calculation but \
also the flexibility in choosing expressions for the characteristics in the \
calculation which allows an extension to generalized symmetries.\
\>", "Text",\

  CellTags->{"calculate the prolongation", "prolongation"}],

Cell[TextData[{
  "All the steps given above to derive the determining equations are \
incorporated in the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The result of the ",
  StyleBox["MathLie ",
    FontSlant->"Italic"],
  "functions is a system of linear homogeneous partial differential equations \
for the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\  = \ \(\[Xi]\_i\)(x, u)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha] = \(\[Phi]\_\[Alpha]\)(x, u)\)]],
  ", in which ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are vectors of the independent and dependent variables. These are the \
so-called determining equations for the symmetries of the system \
\[CapitalDelta]."
}], "Text",
  CellTags->{
  "system of linear homogeneous partial differential equations", 
    "infinitesimals", "determining equations"}],

Cell[TextData[{
  "At this point of the discussion, we note that equation ",
  ButtonBox["(5.16)",
    ButtonData:>"eq-16",
    ButtonStyle->"Hyperlink"],
  " looks very similar to the invariance condition of the non-classical \
symmetry method. The difference is that the second side condition ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\)]],
  " is not equal to zero in relation ",
  ButtonBox["(5.16)",
    ButtonData:>"eq-16",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"non-classical symmetry"],

Cell["\<\
In summary, in this section we discussed the algorithm in \
mathematical terms to calculate Lie point symmetries. The essential steps of \
this calculation are as follows:\
\>", "Text",
  Evaluatable->False,
  CellTags->{"algorithm", "Lie point symmetries"}],

Cell[TextData[{
  "Calculate the prolongation of the system of differential equations up to ",
  
  StyleBox["k",
    FontSlant->"Italic"],
  "th order by"
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  CellTags->"prolongation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((k)\)\) v\&\[RightVector]\ \[CapitalDelta]\  = \ 0. \)], 
  "NumberedEquation",
  Evaluatable->False],

Cell["\<\
Use the equations themselves to eliminate redundant information of \
the prolongation\
\>", "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  CellTags->"redundant information"],

Cell[BoxData[
    \(TraditionalForm
    \`\(pr\^\((k)\)\) v\&\[RightVector]\ 
        \[CapitalDelta]\( \[VerticalSeparator] \_\(\[CapitalDelta] = 0\)\)\ 
      \( = \ 0. \)\)], "NumberedEquation"],

Cell["\<\
Extract the determining equations from the prolongation by setting \
the coefficients of the derivatives in the dependent variables equal to zero.\
\
\>", "ListItem",
  CellDingbat->"3.",
  Evaluatable->False,
  CellTags->"determining equations"],

Cell["Solve the resulting determining equations.", "ListItem",
  CellDingbat->"4.",
  Evaluatable->False],

Cell[TextData[{
  "Steps 1 to 3 will be discussed in this section. The fourth step deals with \
the solution of the determining equations to be discussed in detail in C",
  ButtonBox["hapter 10",
    ButtonData:>{"symmet8.nb", 
      "Solution of Coupled Linear Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  ". We note at this stage that the determining equations are always solvable \
in closed form since they build up an overdetermined system of linear partial \
differential equations."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "solution of the determining equations", 
    "overdetermined system of linear partial differential equations"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.4 Application of the Theory", "Section",
  Evaluatable->False,
  CellTags->"Application of the theory"],

Cell[TextData[{
  "In this section, we discuss the application of the theoretical formulas \
discussed to appropriately calculate Lie point symmetries. We apply the \
theoretical notions in terms of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " functions. The main tools discussed here are the prolongation operator \
and the derivation of the determining equations."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "application of theoretical formulas", "Lie point symmetries", 
    "prolongation operator", "derivation of the determining equations"}],

Cell[CellGroupData[{

Cell["5.4.1 Calculation of Prolongations", "Subsection",
  CellTags->"Calculation of prolongations"],

Cell[TextData[{
  "Calculation of the prolongation in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can easily be carried out by using the formula based on the definition of \
the Fr\[EAcute]chet derivative. The theoretical concept of the prolongation \
is realized in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " by the function ",
  StyleBox["Prolongation[]", "MmaText"],
  ". The on-line information on this function reads"
}], "Text",
  CellTags->{
  "calculation of prolongations", "Fr\[EAcute]chet derivative", 
    "Prolongation[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<Prolongation\>", LongForm \[Rule] False]\)], "Input"],

Cell[BoxData[
    \("Prolongation[equation_,dependent_,independent_,parameters_:{}] \n      \
 determines the prolongation of an equation or a system of equations."\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "This function expects four different quantities as input. The first \
argument of the function contains the equations ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  "; the second and third arguments specify the dependent and independent \
variables. The fourth slot contains the parameters of the equation. This \
input quantity is optional and can be omitted if the equation contains no \
parameters. The function ",
  StyleBox["Prolongation[]", "MmaText"],
  " applied to an arbitrary partial differential equation ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, t, u, u\_t) = 0\)]],
  " allows us to calculate the prolongation for this expression. Let us first \
define the equation by"
}], "Text",
  CellTags->{
  "slot", "Prolongation[]", "calculate the prolongation", "prolongation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(equat1 = F[x, t, u[x, t], \[PartialD]\_t u[x, t]] == 0\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      RowBox[{"F", "[", 
        RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}], "==", 
      "0"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Applying the function ",
  StyleBox["Prolongation[]", "MmaText"],
  " to this expression, we have to supply the additional two arguments as \
well. The second and third lists contain the dependent and independent \
variables. Collecting this information, we can write"
}], "Text",
  CellTags->"Prolongation[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pr1 = Prolongation[equat1, {u}, {x, t}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["u", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "2"], " ", 
          RowBox[{
            SuperscriptBox[\(xi[2]\), 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[2]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{\(\(phi[1]\)[x, t, u[x, t]]\), " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{\(\(xi[2]\)[x, t, u[x, t]]\), " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 1, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{\(\(xi[1]\)[x, t, u[x, t]]\), " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((1, 0, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " are by default denoted by ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[",
  StyleBox["p",
    FontSlant->"Italic"],
  "][",
  StyleBox["x,u",
    FontSlant->"Italic"],
  "[",
  StyleBox["x,t",
    FontSlant->"Italic"],
  "]] and ",
  StyleBox["phi",
    FontSlant->"Italic"],
  "[",
  StyleBox["q",
    FontSlant->"Italic"],
  "][",
  StyleBox["x,u",
    FontSlant->"Italic"],
  "[",
  StyleBox["x,t",
    FontSlant->"Italic"],
  "]]",
  StyleBox[",",
    FontSlant->"Italic"],
  " where ",
  StyleBox["xi",
    FontSlant->"Italic"],
  " stands for the infinitesimals of the independent variables and ",
  StyleBox["phi",
    FontSlant->"Italic"],
  " for the dependent one. The number in square brackets denotes the first, \
second, third, etc. variables in the set of independent and dependent \
variables, respectively. Here, ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[1] stands for the first independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[2] for the second variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". In our example, only one dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is present, so the related infinitesimal is ",
  StyleBox["phi",
    FontSlant->"Italic"],
  "[1]. The argument of the infinitesimals contains the independent and \
dependent variables with all the dependencies."
}], "Text",
  CellTags->{
  "TraditionalLieForm", "infinitesimals", 
    "representatio of infinitesimals in MathLie"}],

Cell[TextData[{
  "The result of the above calculation represents the first-order \
prolongation of the general equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"F", 
              FormBox[\((x, t, u, u\_t\),
                "TraditionalForm"]}], ")"}], "=", "0"}], TraditionalForm]]],
  ". Alternatively, we can use a shorthand notation for the function \
Prolongation[] by the symbol ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            SubsuperscriptBox[
              RowBox[{"(", 
                TagBox[
                  RowBox[{
                    StyleBox[
                      SuperscriptBox[
                        StyleBox["pr",
                          FontSize->10,
                          FontSlant->"Italic"], 
                        StyleBox["k",
                          FontSize->10]],
                      FontSize->10], 
                    StyleBox[
                      OverscriptBox["v", 
                        StyleBox["\[RightVector]",
                          FontSize->10]],
                      FontSlant->"Italic"]}],
                  NotationBoxTag,
                  Editable->True], ")"}], \(u, x\), "\[Gamma]"], "[", 
            "\[CapitalDelta]", "]"}],
          FontSize->10], TraditionalForm]], "InlineFormula"],
  ". This symbol is part of a palette ",
  StyleBox["accompanying",
    Evaluatable->False],
  " ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". Thus, the more symbolic representation of the prolongation is"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "first order prolongation", "Prolongation[]", "palette", 
    "symbolic representation of the prolongation in MathLie"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"prolong", " ", "=", 
      RowBox[{
        SubsuperscriptBox[
          RowBox[{"(", 
            TagBox[
              RowBox[{
                StyleBox[
                  SuperscriptBox[
                    StyleBox["pr",
                      FontSize->9,
                      FontSlant->"Italic"], "k"],
                  FontSize->9], 
                StyleBox[\(v\&\[RightVector]\),
                  FontSize->9,
                  FontSlant->"Italic"]}],
              NotationBoxTag,
              Editable->True], ")"}], \({u}, {x, t}\), \({}\)], "[", 
        "equat1", "]"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["u", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], "2"], " ", 
          RowBox[{
            SuperscriptBox[\(xi[2]\), 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "-", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], " ", 
          RowBox[{
            SuperscriptBox[\(xi[2]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{\(\(phi[1]\)[x, t, u[x, t]]\), " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{\(\(xi[2]\)[x, t, u[x, t]]\), " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((0, 1, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{\(\(xi[1]\)[x, t, u[x, t]]\), " ", 
          RowBox[{
            SuperscriptBox["F", 
              TagBox[\((1, 0, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", 
            RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result created by this operator is identical to the result derived by \
",
  StyleBox["Prolongation[]", "MmaText"],
  ". The function behind the operator ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            SubsuperscriptBox[
              RowBox[{"(", 
                TagBox[
                  RowBox[{
                    SuperscriptBox["pr", 
                      StyleBox["k",
                        FontSize->10]], 
                    StyleBox[
                      OverscriptBox[
                        StyleBox["v",
                          FontSize->10], "\[RightVector]"],
                      FontSlant->"Italic"]}],
                  NotationBoxTag,
                  Editable->True], ")"}], \(u, x\), "\[Gamma]"], "[", 
            "\[CapitalDelta]", "]"}],
          FontSize->10], TraditionalForm]],
    FontSize->10],
  " automatically detects the number of variables involved and creates the \
representation of the infinitesimals. Input quantities needed are just the \
independent and dependent variables and the equation. To some, the result may \
look somehow strange. If one likes to have the result represented in a more \
traditional form, the standard representation of this expression can be \
transform by means of ",
  StyleBox["LieTraditionalForm[]", "MmaText"],
  ". The result contains Greek letters and indices for the numbering of the \
infinitesimals. The transformation of the previous result is carried out by \
the following line:"
}], "Text",
  CellTags->{
  "Prolongation[]", "infinitesimals", "traditional form", 
    "LieTraditionalForm[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(prolong // \ LieTraditionalForm\ \)\)], "Input"],

Cell[BoxData[
    \({F\_x\ \[Xi]\_1 + F\_t\ \[Xi]\_2 + F\_u\ \[Phi]\_1 - 
        F\_\(u\_t\)\ u\_x\ \((\[Xi]\_1)\)\_t - 
        F\_\(u\_t\)\ u\_t\ u\_x\ \((\[Xi]\_1)\)\_u - 
        F\_\(u\_t\)\ u\_t\ \((\[Xi]\_2)\)\_t - 
        F\_\(u\_t\)\ u\_t\%2\ \((\[Xi]\_2)\)\_u + 
        F\_\(u\_t\)\ \((\[Phi]\_1)\)\_t + 
        F\_\(u\_t\)\ u\_t\ \((\[Phi]\_1)\)\_u}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "To be more specific, let us calculate the prolongation of the Burgers \
equation as another example. The Burgers equation, ",
  Cell[BoxData[
      \(TraditionalForm\`u\_t + uu\_x - u\_\(x, x\) = 0\)]],
  ", is one of the standard equations treated in non-linear physics. This \
equation was used by ",
  ButtonBox["Burgers [1948]",
    ButtonData:>{"Literat.nb", "Burg-48"},
    ButtonStyle->"Hyperlink"],
  " as a mathematical model of turbulence. The Burgers equation in the field \
variable"
}], "Text",
  Evaluatable->False,
  CellTags->{"Burgers equation", "turbulence"}],

Cell[BoxData[
    \(\(U = u[x, t]; \)\)], "Input",
  PageWidth->Infinity],

Cell["reads", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(burgers = 
      \[PartialD]\_t U + U\ \[PartialD]\_x U - \[PartialD]\_{x, 2}U == 0; 
    LieTraditionalForm[burgers]\)], "Input"],

Cell[BoxData[
    \(u\_t + u\ u\_x - u\_\(x, x\) == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The prolongation of this equation follows with the prolongation operator \
or the function ",
  StyleBox["Prolongation[]", "MmaText"],
  " as"
}], "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "prolongation operator", "Prolongation[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SubsuperscriptBox[
          RowBox[{"(", 
            TagBox[
              RowBox[{
                StyleBox[\(pr\^k\),
                  FontSize->9], 
                StyleBox[\(v\&\[RightVector]\),
                  FontSize->9,
                  FontSlant->"Italic"]}],
              NotationBoxTag,
              Editable->True], ")"}], \(u, {x, t}\), \({}\)], "[", "burgers", 
        "]"}], " ", "//", " ", "LieTraditionalForm"}]], "Input"],

Cell[BoxData[
    \({u\_x\ \[Phi]\_1 - u\_x\ \((\[Xi]\_1)\)\_t - 
        u\_t\ u\_x\ \((\[Xi]\_1)\)\_u - u\ u\_x\%2\ \((\[Xi]\_1)\)\_u - 
        u\ u\_x\ \((\[Xi]\_1)\)\_x - u\_t\ \((\[Xi]\_2)\)\_t - 
        u\_t\%2\ \((\[Xi]\_2)\)\_u - u\ u\_t\ u\_x\ \((\[Xi]\_2)\)\_u - 
        u\ u\_t\ \((\[Xi]\_2)\)\_x + \((\[Phi]\_1)\)\_t + 
        u\_t\ \((\[Phi]\_1)\)\_u + u\ u\_x\ \((\[Phi]\_1)\)\_u + 
        u\ \((\[Phi]\_1)\)\_x + 2\ u\_x\ \((\[Xi]\_2)\)\_u\ u\_\(x, t\) + 
        2\ \((\[Xi]\_2)\)\_x\ u\_\(x, t\) + 
        3\ u\_x\ \((\[Xi]\_1)\)\_u\ u\_\(x, x\) + 
        2\ \((\[Xi]\_1)\)\_x\ u\_\(x, x\) + 
        u\_t\ \((\[Xi]\_2)\)\_u\ u\_\(x, x\) - 
        \((\[Phi]\_1)\)\_u\ u\_\(x, x\) + u\_x\%3\ \((\[Xi]\_1)\)\_\(u, u\) + 
        2\ u\_x\%2\ \((\[Xi]\_1)\)\_\(x, u\) + 
        u\_x\ \((\[Xi]\_1)\)\_\(x, x\) + 
        u\_t\ u\_x\%2\ \((\[Xi]\_2)\)\_\(u, u\) + 
        2\ u\_t\ u\_x\ \((\[Xi]\_2)\)\_\(x, u\) + 
        u\_t\ \((\[Xi]\_2)\)\_\(x, x\) - u\_x\%2\ \((\[Phi]\_1)\)\_\(u, u\) - 
        2\ u\_x\ \((\[Phi]\_1)\)\_\(x, u\) - \((\[Phi]\_1)\)\_\(x, x\)}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result contains derivatives of the infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " related to the two independent variables and the dependent variable. We \
note that the numbers of the indices of the infinitesimals are related to the \
occurrence of the variables in the argument of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Index 1 is connected to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and 2 denotes the second independent variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[TextData[{
  "Another function more flexible in its specification of the infinitesimals \
is ",
  StyleBox["FrechetProlong[]", "MmaText"],
  ". This function allows us to supply expressions for infinitesimals. The \
first three arguments of the function are the same as in ",
  StyleBox["Prolongation[]", "MmaText"],
  ". The difference is that, in general, we have to deliver infinitesimals in \
the last two arguments in such a way that there exists an expression for each \
variable. The position in the first list is directly related to the position \
of the independent variable in the arguments of dependent variables. The \
order in the second list depends also on the order of dependent variables in \
the arguments of the infinitesimals. Concerning the names of the \
infinitesimals, we can arbitrarily choose them. We demonstrate this by \
calculating the prolongation of the Harry-Dym equation. Originally a pure \
mathematical object, the ",
  ButtonBox["Harry-Dym",
    ButtonData:>{"Literat.nb", "Kada-90"},
    ButtonStyle->"Hyperlink"],
  " equation today is discussed in connection with physical applications (",
  ButtonBox["Kadanoff [1990]",
    ButtonData:>{"Literat.nb", "Kada-90"},
    ButtonStyle->"Hyperlink"],
  "). It is a special feature of ",
  StyleBox["FrechetProlong[]", "MmaText"],
  " that only the left-hand sides of the equations are needed. In case of the \
Harry-Dym equation"
}], "Text",
  Evaluatable->False,
  CellTags->{"FrechetProlong[]", "infinitesimals", "Harry-Dym equation"}],

Cell[BoxData[
    \(TraditionalForm\`u\_t\  - \ \[Lambda]\ u\^3\ u\_\(x, x, x\)\  = \ 0\)], 
  "NumberedEquation"],

Cell["the left-hand side of the equation is expected in a list:", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(harryDym = {\[PartialD]\_t U - \[Lambda]\ U\^3\ \[PartialD]\_{x, 3}U}; 
    harryDym // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - u\^3\ \[Lambda]\ u\_\(x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The Harry-Dym equation is a third-order non-linear partial differential \
equation in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". \[Lambda] is a real parameter in this equation. The prolongation in the \
infinitesimals ",
  StyleBox["\[Xi]",
    FontSlant->"Italic"],
  ", ",
  StyleBox["\[Tau]",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["\[CapitalPhi]  ",
    FontSlant->"Italic"],
  "follows by"
}], "Text",
  Evaluatable->False,
  CellTags->{"Harry-Dym equation", "nonlinear partial differential equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(pharryDym = 
      FrechetProlong[harryDym, {u}, {x, t}, \n
        \t\t{\[Xi][x, t, U], \[Tau][x, t, U]}, {\[CapitalPhi][x, t, U]}]; 
    pharryDym // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({\(-u\_x\)\ \[Xi]\_t - u\_t\ u\_x\ \[Xi]\_u - u\_t\ \[Tau]\_t - 
        u\_t\%2\ \[Tau]\_u + \[CapitalPhi]\_t + u\_t\ \[CapitalPhi]\_u + 
        3\ u\^3\ \[Lambda]\ \[Tau]\_u\ u\_\(x, t\)\ u\_\(x, x\) + 
        3\ u\^3\ \[Lambda]\ \[Xi]\_u\ u\_\(x, x\)\%2 + 
        6\ u\^3\ \[Lambda]\ u\_x\%2\ u\_\(x, x\)\ \[Xi]\_\(u, u\) + 
        9\ u\^3\ \[Lambda]\ u\_x\ u\_\(x, x\)\ \[Xi]\_\(x, u\) + 
        3\ u\^3\ \[Lambda]\ u\_\(x, x\)\ \[Xi]\_\(x, x\) + 
        3\ u\^3\ \[Lambda]\ u\_x\%2\ u\_\(x, t\)\ \[Tau]\_\(u, u\) + 
        3\ u\^3\ \[Lambda]\ u\_t\ u\_x\ u\_\(x, x\)\ \[Tau]\_\(u, u\) + 
        6\ u\^3\ \[Lambda]\ u\_x\ u\_\(x, t\)\ \[Tau]\_\(x, u\) + 
        3\ u\^3\ \[Lambda]\ u\_t\ u\_\(x, x\)\ \[Tau]\_\(x, u\) + 
        3\ u\^3\ \[Lambda]\ u\_\(x, t\)\ \[Tau]\_\(x, x\) - 
        3\ u\^3\ \[Lambda]\ u\_x\ u\_\(x, x\)\ \[CapitalPhi]\_\(u, u\) - 
        3\ u\^3\ \[Lambda]\ u\_\(x, x\)\ \[CapitalPhi]\_\(x, u\) + 
        3\ u\^3\ \[Lambda]\ u\_x\ \[Tau]\_u\ u\_\(x, x, t\) + 
        3\ u\^3\ \[Lambda]\ \[Tau]\_x\ u\_\(x, x, t\) - 
        3\ u\^2\ \[Lambda]\ \[CapitalPhi]\ u\_\(x, x, x\) + 
        4\ u\^3\ \[Lambda]\ u\_x\ \[Xi]\_u\ u\_\(x, x, x\) + 
        3\ u\^3\ \[Lambda]\ \[Xi]\_x\ u\_\(x, x, x\) + 
        u\^3\ \[Lambda]\ u\_t\ \[Tau]\_u\ u\_\(x, x, x\) - 
        u\^3\ \[Lambda]\ \[CapitalPhi]\_u\ u\_\(x, x, x\) + 
        u\^3\ \[Lambda]\ u\_x\%4\ \[Xi]\_\(u, u, u\) + 
        3\ u\^3\ \[Lambda]\ u\_x\%3\ \[Xi]\_\(x, u, u\) + 
        3\ u\^3\ \[Lambda]\ u\_x\%2\ \[Xi]\_\(x, x, u\) + 
        u\^3\ \[Lambda]\ u\_x\ \[Xi]\_\(x, x, x\) + 
        u\^3\ \[Lambda]\ u\_t\ u\_x\%3\ \[Tau]\_\(u, u, u\) + 
        3\ u\^3\ \[Lambda]\ u\_t\ u\_x\%2\ \[Tau]\_\(x, u, u\) + 
        3\ u\^3\ \[Lambda]\ u\_t\ u\_x\ \[Tau]\_\(x, x, u\) + 
        u\^3\ \[Lambda]\ u\_t\ \[Tau]\_\(x, x, x\) - 
        u\^3\ \[Lambda]\ u\_x\%3\ \[CapitalPhi]\_\(u, u, u\) - 
        3\ u\^3\ \[Lambda]\ u\_x\%2\ \[CapitalPhi]\_\(x, u, u\) - 
        3\ u\^3\ \[Lambda]\ u\_x\ \[CapitalPhi]\_\(x, x, u\) - 
        u\^3\ \[Lambda]\ \[CapitalPhi]\_\(x, x, x\)}\)], "Output"]
}, Open  ]],

Cell["\<\
This representation of the prolongation contains the infinitesimals \
in a more indicative form connecting the name of the independent variables \
with the names of the infinitesimals in Greek. However, the direct access by \
subscripts is lost. We see that the use of names for the infinitesimals is by \
no means restricted.\
\>", "Text",
  CellTags->{"prolongation", "infinitesimals"}],

Cell[TextData[{
  "Another problem frequently encountered in the calculation of infinitesimal \
transformations is the partial knowledge of the infinitesimals. We illustrate \
this kind of calculation for the heat equation. The ",
  ButtonBox["heat equation",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  " "
}], "Text",
  CellTags->{"heat equation", "partial knowledge of the infinitesimals"}],

Cell[BoxData[
    \(TraditionalForm\`u\_t - u\_\(x, x\) = 0\)], "NumberedEquation"],

Cell[TextData[{
  "is a second-order partial differential equation used in the description of \
temperature changes in solid and fluid media (",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  "). The left-hand side of the equation for the scaled temperature field ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " depending on the temporal and spatial coordinate reads "
}], "Text",
  CellTags->{"temperature", "scaled temperature"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(heat = {\[PartialD]\_t U - \[PartialD]\_{x, 2}U}; heat // LTF\ \)\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "If we know a partial representation of the infinitesimals, we can use this \
information to define the infinitesimals for the function ",
  StyleBox["FrechetProlong[]", "MmaText"],
  ". For the heat equation, let us assume that the infinitesimals are given \
by linear functions in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The infinitesimals for the independent and dependent variables are thus"
}], "Text",
  Evaluatable->False,
  CellTags->{"FrechetProlong[]", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepInfinitesimals = {f[x, t]\ U + g[x, t], h[t]}\)], "Input"],

Cell[BoxData[
    \({g[x, t] + f[x, t]\ u[x, t], h[t]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dependentInfinitesimals = {k[t]\ U}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({k[t]\ u[x, t]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This representation of the infinitesimals contains incomplete information \
about the final form and thus restricts the solution manifold for the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  ". Inserting this form for the infinitesimals in ",
  StyleBox["FrechetProlong[]", "MmaText"],
  ", we end up with a special representation of the prolongation:"
}], "Text",
  Evaluatable->False,
  CellTags->"FrechetProlong[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pheat = 
      FrechetProlong[heat, {u}, {x, t}, \n\t\tindepInfinitesimals, 
        dependentInfinitesimals]; LieTraditionalForm[pheat]\)], "Input"],

Cell[BoxData[
    \({u\ k\_t + k\ u\_t - h\_t\ u\_t - u\ f\_t\ u\_x - g\_t\ u\_x - 
        f\ u\_t\ u\_x + 2\ f\_x\ u\_x\%2 + u\ u\_x\ f\_\(x, x\) + 
        u\_x\ g\_\(x, x\) - k\ u\_\(x, x\) + 2\ u\ f\_x\ u\_\(x, x\) + 
        2\ g\_x\ u\_\(x, x\) + 3\ f\ u\_x\ u\_\(x, x\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result gained is an expression containing functions ",
  Cell[BoxData[
      \(TraditionalForm\`f, g, h\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ". If we know these arbitrary functions, we can check the invariance of the \
equation directly. It is sufficient to know a subgroup of the complete group \
to check the invariance. It is well known that the heat equation is invariant \
with respect to translations (",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  "). As we know from C",
  ButtonBox["hapter 2,",
    ButtonData:>{"Group.nb", "translation"},
    ButtonStyle->"Hyperlink"],
  " these symmetries are represented in infinitesimal form by "
}], "Text",
  Evaluatable->False,
  CellTags->{"group", "check the invariance", "translation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepndInfinitesimls = {k1, k2}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({k1, k2}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dependentInfinitesimals = {k3}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({k3}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The group constants ",
  StyleBox["k1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k3",
    FontSlant->"Italic"],
  " are real constants. Inserting these infinitesimals in our function ",
  StyleBox["FrechetProlong[],", "MmaText"],
  " we find"
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pheats = 
      FrechetProlong[heat, {u}, {x, t}, \n\t\tindepndInfinitesimls, 
        dependentInfinitesimals]\)], "Input"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result reveals that the heat equation is invariant with respect to \
translations. It is now easy to manually check other types of symmetries for \
the heat equation. We only have to specify the infinitesimals in the function \
",
  StyleBox["FrechetProlong[]", "MmaText"],
  ". Let us assume another type of invariance to be given by a rotation of \
the independent variables and a translation of the dependent variable. The \
check of these hypothetical infinitesimals"
}], "Text",
  Evaluatable->False,
  CellTags->{"heat equation", "infinitesimals", "FrechetProlong[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(pheatss = 
      FrechetProlong[heat, {u}, {x, t}, \n\t\t{\(-k1\)\ t, k1\ x}, {k2}]; 
    pheatss // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(k1\ u\_x + 2\ k1\ u\_\(x, t\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
shows that the heat equation is not invariant with respect to \
rotations in the independent variables.\
\>", "Text",
  Evaluatable->False],

Cell[TextData[{
  "The function ",
  StyleBox["FrechetProlong[]", "MmaText"],
  " can be used not only to derive the prolongation of an equation but also \
to calculate the expansion coefficients of the prolongation in general. For \
example, if we need the general representation of the first coefficient of \
the prolongation related to variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", we construct this term by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "FrechetProlong[]", "prolongation", "first coefficient of prolongation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(firstExtension = 
      FrechetProlong[{\[PartialD]\_t u[x, t]}, {u}, {x, t}, \n
        \t\t{\(xi[1]\)[x, t, u[x, t]], \(xi[2]\)[x, t, u[x, t]]}, \n
        \t\t{\(phi[1]\)[x, t, u[x, t]]}]; 
    firstExtension\  // \ LieTraditionalForm\ \)\)], "Input"],

Cell[BoxData[
    \({\(-u\_x\)\ \((\[Xi]\_1)\)\_t - u\_t\ u\_x\ \((\[Xi]\_1)\)\_u - 
        u\_t\ \((\[Xi]\_2)\)\_t - u\_t\%2\ \((\[Xi]\_2)\)\_u + 
        \((\[Phi]\_1)\)\_t + u\_t\ \((\[Phi]\_1)\)\_u}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result represents the general formula for the first extension with \
respect to ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". This sort of expression is tabulated in the book of ",
  ButtonBox["Bluman and Cole [1974]",
    ButtonData:>{"Literat.nb", "Bum-74"},
    ButtonStyle->"Hyperlink"],
  " and is now available to any order or number of variables. The general \
expression of the second prolongation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " follows from"
}], "Text",
  Evaluatable->False,
  CellTags->{"first extension", "second prolongation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(secondExtension = 
      FrechetProlong[{\[PartialD]\_{x, 2}u[x, t]}, \n\t\t{u}, {x, t}, \n
        \t\t{\(xi[1]\)[x, t, u[x, t]], \(xi[2]\)[x, t, u[x, t]]}, \n
        \t\t{\(phi[1]\)[x, t, u[x, t]]}]; 
    secondExtension\  // \ LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({\(-2\)\ u\_x\ \((\[Xi]\_2)\)\_u\ u\_\(x, t\) - 
        2\ \((\[Xi]\_2)\)\_x\ u\_\(x, t\) - 
        3\ u\_x\ \((\[Xi]\_1)\)\_u\ u\_\(x, x\) - 
        2\ \((\[Xi]\_1)\)\_x\ u\_\(x, x\) - 
        u\_t\ \((\[Xi]\_2)\)\_u\ u\_\(x, x\) + 
        \((\[Phi]\_1)\)\_u\ u\_\(x, x\) - u\_x\%3\ \((\[Xi]\_1)\)\_\(u, u\) - 
        2\ u\_x\%2\ \((\[Xi]\_1)\)\_\(x, u\) - 
        u\_x\ \((\[Xi]\_1)\)\_\(x, x\) - 
        u\_t\ u\_x\%2\ \((\[Xi]\_2)\)\_\(u, u\) - 
        2\ u\_t\ u\_x\ \((\[Xi]\_2)\)\_\(x, u\) - 
        u\_t\ \((\[Xi]\_2)\)\_\(x, x\) + u\_x\%2\ \((\[Phi]\_1)\)\_\(u, u\) + 
        2\ u\_x\ \((\[Phi]\_1)\)\_\(x, u\) + \((\[Phi]\_1)\)\_\(x, x\)}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing the results with expressions given in ",
  ButtonBox["Bluman and Cole [1974],",
    ButtonData:>{"Literat.nb", "Bum-74"},
    ButtonStyle->"Hyperlink"],
  " it is obvious that the formulas are identical. The reader may calculate, \
for example, the fifth expansion coefficient related to terms ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, x, t, t, t\)\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The function ",
  StyleBox["FrechetProlong[]", "MmaText"],
  " is also capable of calculating the prolongation of a general expression \
containing derivatives. Let us demonstrate this behavior by examining the \
general partial differential equation of second order given by the relation"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "FrechetProlong[]", "prolongation", 
    "general partial differential equation of second-order"}],

Cell[BoxData[
    \(TraditionalForm\`F(x, t, u, u\_x, u\_t, u\_\(x, x\)) = 0. \)], 
  "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "The left-hand side of this general second-order equation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reads"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pde2 = {
        F[x, t, U, \[PartialD]\_x U, \[PartialD]\_t U, \[PartialD]\_{x, 2}U]}
        \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"F", "[", 
        RowBox[{"x", ",", "t", ",", \(u[x, t]\), ",", 
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The prolongation formula for this general PDE of second-order \
follows from\
\>", "Text",
  Evaluatable->False,
  CellTags->"prolongation formula"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrintDf[
      FrechetProlong[pde2, {u}, {x, t}, \n
          \t\t\t{\(xi[1]\)[x, t, u[x, t]], \(xi[2]\)[x, t, u[x, t]]}, \n
          \t\t\t{\(phi[1]\)[x, t, u[x, t]]}]\  // \ LieTraditionalForm]\)], 
  "Input"],

Cell[BoxData[
    StyleBox[\({F\_x\ \[Xi]\_1 + F\_t\ \[Xi]\_2 + F\_u\ \[Phi]\_1 - 
          F\_\(u\_t\)\ u\_x\ \((\[Xi]\_1)\)\_t - 
          F\_\(u\_t\)\ u\_t\ u\_x\ \((\[Xi]\_1)\)\_u - 
          F\_\(u\_x\)\ u\_x\%2\ \((\[Xi]\_1)\)\_u - 
          F\_\(u\_x\)\ u\_x\ \((\[Xi]\_1)\)\_x - 
          F\_\(u\_t\)\ u\_t\ \((\[Xi]\_2)\)\_t - 
          F\_\(u\_t\)\ u\_t\%2\ \((\[Xi]\_2)\)\_u - 
          F\_\(u\_x\)\ u\_t\ u\_x\ \((\[Xi]\_2)\)\_u - 
          F\_\(u\_x\)\ u\_t\ \((\[Xi]\_2)\)\_x + 
          F\_\(u\_t\)\ \((\[Phi]\_1)\)\_t + 
          F\_\(u\_t\)\ u\_t\ \((\[Phi]\_1)\)\_u + 
          F\_\(u\_x\)\ u\_x\ \((\[Phi]\_1)\)\_u + 
          F\_\(u\_x\)\ \((\[Phi]\_1)\)\_x - 
          2\ F\_\(u\_\(x, x\)\)\ u\_x\ \((\[Xi]\_2)\)\_u\ u\_\(x, t\) - 
          2\ F\_\(u\_\(x, x\)\)\ \((\[Xi]\_2)\)\_x\ u\_\(x, t\) - 
          3\ F\_\(u\_\(x, x\)\)\ u\_x\ \((\[Xi]\_1)\)\_u\ u\_\(x, x\) - 
          2\ F\_\(u\_\(x, x\)\)\ \((\[Xi]\_1)\)\_x\ u\_\(x, x\) - 
          F\_\(u\_\(x, x\)\)\ u\_t\ \((\[Xi]\_2)\)\_u\ u\_\(x, x\) + 
          F\_\(u\_\(x, x\)\)\ \((\[Phi]\_1)\)\_u\ u\_\(x, x\) - 
          F\_\(u\_\(x, x\)\)\ u\_x\%3\ \((\[Xi]\_1)\)\_\(u, u\) - 
          2\ F\_\(u\_\(x, x\)\)\ u\_x\%2\ \((\[Xi]\_1)\)\_\(x, u\) - 
          F\_\(u\_\(x, x\)\)\ u\_x\ \((\[Xi]\_1)\)\_\(x, x\) - 
          F\_\(u\_\(x, x\)\)\ u\_t\ u\_x\%2\ \((\[Xi]\_2)\)\_\(u, u\) - 
          2\ F\_\(u\_\(x, x\)\)\ u\_t\ u\_x\ \((\[Xi]\_2)\)\_\(x, u\) - 
          F\_\(u\_\(x, x\)\)\ u\_t\ \((\[Xi]\_2)\)\_\(x, x\) + 
          F\_\(u\_\(x, x\)\)\ u\_x\%2\ \((\[Phi]\_1)\)\_\(u, u\) + 
          2\ F\_\(u\_\(x, x\)\)\ u\_x\ \((\[Phi]\_1)\)\_\(x, u\) + 
          F\_\(u\_\(x, x\)\)\ \((\[Phi]\_1)\)\_\(x, x\)}\),
      FontColor->RGBColor[1, 0, 0]]], "Print"]
}, Open  ]],

Cell[TextData[{
  "The result of this calculation was converted to a more readable form in \
index notation by the function ",
  StyleBox["LieTraditionalForm[]", "MmaText"],
  ". This function reduces the standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " output to a shorter representation by deleting the arguments of any \
derivative and using the variables of differentiation as an index. The \
expressions free of any derivatives remain unchanged."
}], "Text",
  Evaluatable->False,
  CellTags->"PrintDf[]"],

Cell[TextData[{
  "So far, we discussed some applications of the functions ",
  StyleBox["Prolongation[]", "MmaText"],
  " and ",
  StyleBox["FrechetProlong[]", "MmaText"],
  ", allowing us to derive the prolongation of a differential equation. As we \
know from the theoretical considerations, the prolongation of a differential \
equation is the basis for the derivation of determining equations. In the \
following section, we will discuss a function of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " which is instrumental in the derivation of determining equations."
}], "Text",
  Evaluatable->False,
  CellTags->{"Prolongation[]", "FrechetProlong[]"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.4.2 Derivation of Determining Equations", "Subsection",
  CellTags->"Derivation of the determining equations"],

Cell[TextData[{
  "Determining equations for infinitesimals are the result of invariance \
condition ",
  ButtonBox["(5.10)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  ". The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " provides a function allowing us to derive determining equations for a \
given system of differential equations. The name of the function is  ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  ". The on-line description of the function"
}], "Text",
  Evaluatable->False,
  CellTags->{"determining equations", "DeterminingEquations[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<DeterminingEquations\>", LongForm \[Rule] False]\)], 
  "Input"],

Cell[BoxData[
    \("DeterminingEquations[equations_List, \
dependvar_List,independvar_List,substitutionTerms_List,parameters_List:{}] \
calculates the determining equations for a given system of equations. The \
function uses the Frechet derivative to calculate the prolongation."\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "tells us that we need five input arguments. The first argument contains \
the left-hand side of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  ". The second and third arguments are lists for the dependent and \
independent variables. The fourth list contains terms for which the equation \
\[CapitalDelta] = 0 is solved. The solutions with respect to these terms are \
used as side conditions in the invariance relation ",
  ButtonBox["(5.10)",
    ButtonData:>"eq-10",
    ButtonStyle->"Hyperlink"],
  ". If the equations under examination contain parameters, we can feed in \
these symbols in the last list. This list can be suppressed if no parameters \
are contained in the PDE. The function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  " uses the function ",
  StyleBox["FrechetProlong[]", "MmaText"],
  " to calculate the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation of the equations. After the calculation of the \
prolongation, the side conditions are applied to the result of the function ",
  
  StyleBox["FrechetProlong[]", "MmaText"],
  ". This step reduces the redundant information in the manifold of the \
equation. Upon application of the side conditions, the determining equations \
are extracted as coefficients of the derivatives of the dependent variables.  \
Since the infinitesimals themselves are independent of derivatives, we find \
the determining equations as a set of coupled PDEs."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "invariance relation", "FrechetProlong[]", "prolongation", 
    "determining equations", "coupled PDEs"}],

Cell[TextData[{
  "Application of the function ",
  StyleBox["DeterminingEquations[] ", "MmaText"],
  "is demonstrated by the heat equation. The determining equations of the \
infinitesimals for the heat equation follow from"
}], "Text",
  Evaluatable->False,
  CellTags->{"DeterminingEquations[]", "heat equation", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(detheat = 
      DeterminingEquations[heat, {u}, {x, t}, \n\t\t{\[PartialD]\_t U}]; 
    detheat\  // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {\(\((\[Phi]\_1)\)\_t - \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {\(2\ \((\[Xi]\_1)\)\_x - \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of this calculation ",
  StyleBox["detheat", "MmaText",
    FontSlant->"Italic"],
  " consists of a list containing the left-hand sides of the seven \
determining equations. We transformed these expressions to a system of \
equations by ",
  StyleBox["LTF[]", "MmaText"],
  " adding zero to the right-hand side, and the result is displayed in a \
table. The seven equations contain the unknown functions ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  ". The function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  " automatically implants these names for the infinitesimals. The unknown \
functions ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " depend on the independent variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " and on the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The symmetries of the heat equation are determined by this set of \
equations."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "DeterminingEquations[]", "infinitesimals", 
    "symmetries of the heat equation", "heat equation", "LTF[]"}],

Cell["\<\
Taking a closer look at these equations, we realize that they are \
linear but coupled. However, the main observation is that they are linear. \
Linearity of the equations is a general feature of the determining equations \
for point symmetries. This feature is of great advantage in solving the \
equations. Another general property of the determining equations is that this \
set of equations is always overdetermined. This means that, in general, there \
exist more equations than unknown functions. This fact helps a lot in the \
derivation of the solution.\
\>", "Text",
  Evaluatable->False,
  CellTags->{"point symmetries", "determining equations", "overdetermined"}],

Cell[TextData[{
  "In the present case of the heat equation, we find seven equations for \
three unknowns ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  ". Another example demonstrating these two general properties again is the \
general second-order partial differential equation"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Clear[F]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gheat = {\[PartialD]\_t U + F[\[PartialD]\_{x, 2}U]}; gheat // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(F + u\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing one of many generalizations of the heat equation. If we apply \
the function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  " to this equation, we find"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "generalizations of the heat equation", "DeterminingEquations[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(detgheat = 
      DeterminingEquations[gheat, {u}, {x, t}, {\[PartialD]\_t U}]; 
    detgheat // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Phi]\_1)\)\_t == 0\)},
          {\(\((\[Xi]\_1)\)\_t == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {\(\((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_\(x, x\)\) + 2\ \((\[Phi]\_1)\)\_\(x, u\) == 
              0\)},
          {\(\(-2\)\ \((\[Xi]\_1)\)\_x + \((\[Phi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_t - \((\[Phi]\_1)\)\_u == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Looking at this system of 10 equations, we recognize the same 2 properties \
as in the example for the heat equation linearity and a larger number of \
equations than unknown functions. The equations are linear in the \
infinitesimals independent of the form of general function ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", and they are overdetermined. This general behavior does not change if we \
examine non-linear equations like the Burgers equation or the Harry-Dym \
equation. The determining equations for these two models follow by"
}], "Text",
  Evaluatable->False,
  CellTags->{"linearity", "nonlinear equations", "Harry-Dym equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeterminingEquations[{
          burgers\[LeftDoubleBracket]1\[RightDoubleBracket]}, {u}, {x, t}, {
          \[PartialD]\_t U}] // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\[Phi]\_1 - \((\[Xi]\_1)\)\_t - u\ \((\[Xi]\_1)\)\_x + 
                u\ \((\[Xi]\_2)\)\_t + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\((\[Phi]\_1)\)\_t + u\ \((\[Phi]\_1)\)\_x - 
                \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {\(2\ \((\[Xi]\_1)\)\_x - \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
which are six determining equations in the case of the Burgers \
equation\
\>", "Text",
  Evaluatable->False,
  CellTags->"Burgers equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeterminingEquations[
        harryDym, {u}, {x, t}, {\[PartialD]\_t U}, {\[Lambda]}] // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + 
                u\^3\ \[Lambda]\ \((\[Xi]\_1)\)\_\(x, x, x\) - 
                3\ u\^3\ \[Lambda]\ \((\[Phi]\_1)\)\_\(x, x, u\) == 0\)},
          {
            \(\((\[Phi]\_1)\)\_t - 
                u\^3\ \[Lambda]\ \((\[Phi]\_1)\)\_\(x, x, x\) == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_\(x, x\)\) + \((\[Phi]\_1)\)\_\(x, u\) == 0
              \)},
          {
            \(3\ \[Phi]\_1 - 3\ u\ \((\[Xi]\_1)\)\_x + 
                u\ \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "and eight determining equations for the Harry-Dym equation. Since the \
Harry-Dym equation contains a parameter \[Lambda], we have to tell the \
function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  " that \[Lambda] is a variable in the equation which does not depend on the \
independent variables. The last argument of the function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  " contains this information."
}], "Text",
  Evaluatable->False,
  CellTags->{"Harry-Dym equation", "DeterminingEquations[]"}],

Cell[TextData[{
  "Up to now, we discussed equations containing only a single dependent \
variable. The following example examines a system of two equations. The \
physical background of these equations is the flow in a polytropic gas. \
Following ",
  ButtonBox["Ibragimov [1985]",
    ButtonData:>{"Literat.nb", "Ibra-85"},
    ButtonStyle->"Hyperlink"],
  ", we can write down the equations of motion for polytropic gas in two \
spatial dimensions and one temporal dimension. In polar coordinates, the \
radial and angular velocity fields are"
}], "Text",
  CellTags->"flow in a polytropic gas"],

Cell[BoxData[
    \(\(Vr = vr[r, \[Theta], t]; \)\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(V\[Theta] = v\[Theta][r, \[Theta], t]; \)\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The depth ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " of the fluid above a flat bottom is given by"
}], "Text",
  Evaluatable->False,
  CellTags->"fluid"],

Cell[BoxData[
    \(\(H = h[r, \[Theta], t]; \)\)], "Input",
  PageWidth->Infinity],

Cell["The equations of motion for this fluid are given by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly = {
        \[PartialD]\_t Vr + Vr\ \[PartialD]\_r Vr + 
          \(V\[Theta]\ \[PartialD]\_\[Theta] Vr\)\/r + \[PartialD]\_r H, \n
        \t\t\[PartialD]\_t V\[Theta] + Vr\ \[PartialD]\_r V\[Theta] + 
          \(V\[Theta]\ \[PartialD]\_\[Theta] V\[Theta]\)\/r + 
          \[PartialD]\_\[Theta] H\/r, \n\t\t
        \[PartialD]\_t H + Vr\ \[PartialD]\_r H + 
          \(V\[Theta]\ \[PartialD]\_\[Theta] H\)\/r + 
          H\ \((\[PartialD]\_r\((Vr\ r)\)\/r + 
                \[PartialD]\_\[Theta] V\[Theta]\/r)\)}; poly // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
              \(h\_r\), "+", \(v\_r\ \((v\_r)\)\_r\), "+", \(\((v\_r)\)\_t\), 
                "+", 
                StyleBox[\(\(v\_\[Theta]\ \((v\_r)\)\_\[Theta]\)\/r\),
                  ScriptLevel->0]}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(h\_\[Theta]\/r\),
                  ScriptLevel->0], "+", \(v\_r\ \((v\_\[Theta])\)\_r\), "+", 
                \(\((v\_\[Theta])\)\_t\), "+", 
                StyleBox[\(\(v\_\[Theta]\ \((v\_\[Theta])\)\_\[Theta]\)\/r\),
                  ScriptLevel->0]}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{\(h\_t\), "+", \(h\_r\ v\_r\), "+", 
                StyleBox[\(\(h\_\[Theta]\ v\_\[Theta]\)\/r\),
                  ScriptLevel->0], "+", 
                RowBox[{"h", " ", 
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox[\(\(v\_r + r\ \((v\_r)\)\_r\)\/r\),
                        ScriptLevel->0], "+", 
                      StyleBox[\(\((v\_\[Theta])\)\_\[Theta]\/r\),
                        ScriptLevel->0]}], ")"}]}]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This system consists of three equations for the dependent variables ",
  Cell[BoxData[
      FormBox[
        StyleBox["vr",
          "InlineFormula",
          FontSlant->"Italic"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            StyleBox["v",
              FontSlant->"Italic"], 
            StyleBox["\[Theta]",
              "InlineFormula"]}]], TraditionalForm]]],
  ", and ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          "InlineFormula"], TraditionalForm]]],
  ". The independent variables are the radius ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " and the angle ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\)]],
  ". The determining equations for the polytropic gas follow by specifying \
the knowledge on all the variables and the equations in the function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  ". The equations do not depend on a parameter, so the parameter list is \
empty."
}], "Text",
  Evaluatable->False,
  CellTags->"determining equations for the polytropic gas"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeterminingEquations[
        poly, {vr, v\[Theta], h}, {r, \[Theta], t}, {\[PartialD]\_t Vr, 
          \[PartialD]\_t V\[Theta], \[PartialD]\_t H}, {}] // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_h == 0\)},
          {\(\((\[Xi]\_2)\)\_h == 0\)},
          {\(\((\[Xi]\_3)\)\_h == 0\)},
          {\(\((\[Phi]\_3)\)\_\(v\_\[Theta]\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(v\_\[Theta]\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(v\_\[Theta]\) == 0\)},
          {\(\((\[Xi]\_3)\)\_\(v\_\[Theta]\) == 0\)},
          {\(\((\[Phi]\_3)\)\_\(v\_r\) == 0\)},
          {\(\((\[Xi]\_1)\)\_\(v\_r\) == 0\)},
          {\(\((\[Xi]\_2)\)\_\(v\_r\) == 0\)},
          {\(\((\[Xi]\_3)\)\_\(v\_r\) == 0\)},
          {
            \(\(-v\_\[Theta]\)\ \[Xi]\_1 + r\ \[Phi]\_2 - 
                r\^2\ v\_r\ \((\[Xi]\_2)\)\_r - r\^2\ \((\[Xi]\_2)\)\_t - 
                r\ v\_\[Theta]\ \((\[Xi]\_2)\)\_\[Theta] + 
                r\ v\_r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_r + 
                r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_t + 
                h\ \((\[Xi]\_3)\)\_\[Theta] + 
                v\_\[Theta]\%2\ \((\[Xi]\_3)\)\_\[Theta] + 
                h\ r\ \((\[Phi]\_2)\)\_h == 0\)},
          {
            \(\(-v\_\[Theta]\)\ \[Xi]\_1 + r\ \[Phi]\_2 - 
                r\^2\ v\_r\ \((\[Xi]\_2)\)\_r - r\^2\ \((\[Xi]\_2)\)\_t - 
                r\ v\_\[Theta]\ \((\[Xi]\_2)\)\_\[Theta] + 
                r\ v\_r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_r + 
                r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_t + 
                h\ \((\[Xi]\_3)\)\_\[Theta] + 
                v\_\[Theta]\%2\ \((\[Xi]\_3)\)\_\[Theta] - 
                h\ r\ \((\[Phi]\_2)\)\_h == 0\)},
          {
            \(\(-v\_\[Theta]\)\ \[Xi]\_1 + r\ \[Phi]\_2 - 
                r\^2\ v\_r\ \((\[Xi]\_2)\)\_r - r\^2\ \((\[Xi]\_2)\)\_t - 
                r\ v\_\[Theta]\ \((\[Xi]\_2)\)\_\[Theta] + 
                r\ v\_r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_r + 
                r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_t + 
                v\_\[Theta]\%2\ \((\[Xi]\_3)\)\_\[Theta] == 0\)},
          {
            \(\(-r\)\ \((\[Xi]\_2)\)\_r + v\_\[Theta]\ \((\[Xi]\_3)\)\_r + 
                \((\[Phi]\_2)\)\_\(v\_r\) == 0\)},
          {
            \(r\ \((\[Xi]\_2)\)\_r - v\_\[Theta]\ \((\[Xi]\_3)\)\_r + 
                \((\[Phi]\_1)\)\_\(v\_\[Theta]\) == 0\)},
          {
            \(\(-h\)\ v\_r\ \[Xi]\_1 + h\ r\ \[Phi]\_1 + r\ v\_r\ \[Phi]\_3 + 
                h\ r\ v\_r\%2\ \((\[Xi]\_3)\)\_r + 
                h\ r\ v\_r\ \((\[Xi]\_3)\)\_t + 
                h\ v\_r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] + 
                h\ r\^2\ \((\[Phi]\_1)\)\_r + 
                h\ r\ \((\[Phi]\_2)\)\_\[Theta] - 
                h\ r\ v\_r\ \((\[Phi]\_3)\)\_h + 
                r\^2\ v\_r\ \((\[Phi]\_3)\)\_r + r\^2\ \((\[Phi]\_3)\)\_t + 
                r\ v\_\[Theta]\ \((\[Phi]\_3)\)\_\[Theta] == 0\)},
          {
            \(r\ \[Phi]\_1 - r\ v\_r\ \((\[Xi]\_1)\)\_r - 
                r\ \((\[Xi]\_1)\)\_t - 
                v\_\[Theta]\ \((\[Xi]\_1)\)\_\[Theta] + 
                h\ r\ \((\[Xi]\_3)\)\_r + r\ v\_r\%2\ \((\[Xi]\_3)\)\_r + 
                r\ v\_r\ \((\[Xi]\_3)\)\_t + 
                v\_r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] + 
                h\ r\ \((\[Phi]\_1)\)\_h == 0\)},
          {
            \(r\ \[Phi]\_1 - r\ v\_r\ \((\[Xi]\_1)\)\_r - 
                r\ \((\[Xi]\_1)\)\_t - 
                v\_\[Theta]\ \((\[Xi]\_1)\)\_\[Theta] + 
                h\ r\ \((\[Xi]\_3)\)\_r + r\ v\_r\%2\ \((\[Xi]\_3)\)\_r + 
                r\ v\_r\ \((\[Xi]\_3)\)\_t + 
                v\_r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] - 
                h\ r\ \((\[Phi]\_1)\)\_h == 0\)},
          {
            \(r\ \[Phi]\_1 - r\ v\_r\ \((\[Xi]\_1)\)\_r - 
                r\ \((\[Xi]\_1)\)\_t - 
                v\_\[Theta]\ \((\[Xi]\_1)\)\_\[Theta] + 
                r\ v\_r\%2\ \((\[Xi]\_3)\)\_r + r\ v\_r\ \((\[Xi]\_3)\)\_t + 
                v\_r\ v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] == 0\)},
          {
            \(r\ \[Phi]\_3 - h\ r\ \((\[Xi]\_1)\)\_r + 
                2\ h\ r\ v\_r\ \((\[Xi]\_3)\)\_r + h\ r\ \((\[Xi]\_3)\)\_t + 
                h\ v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] + 
                h\ r\ \((\[Phi]\_1)\)\_\(v\_r\) - h\ r\ \((\[Phi]\_3)\)\_h == 
              0\)},
          {
            \(h\ v\_r\ \((\[Xi]\_3)\)\_r - h\ v\_r\ \((\[Phi]\_1)\)\_h + 
                r\ v\_r\ \((\[Phi]\_1)\)\_r + r\ \((\[Phi]\_1)\)\_t + 
                v\_\[Theta]\ \((\[Phi]\_1)\)\_\[Theta] + 
                r\ \((\[Phi]\_3)\)\_r == 0\)},
          {
            \(\(-h\)\ \[Xi]\_1 + r\ \[Phi]\_3 - 
                h\ r\ \((\[Xi]\_2)\)\_\[Theta] + 
                h\ r\ v\_r\ \((\[Xi]\_3)\)\_r + h\ r\ \((\[Xi]\_3)\)\_t + 
                2\ h\ v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] + 
                h\ r\ \((\[Phi]\_2)\)\_\(v\_\[Theta]\) - 
                h\ r\ \((\[Phi]\_3)\)\_h == 0\)},
          {
            \(\(-r\)\ \((\[Xi]\_1)\)\_r + 2\ r\ v\_r\ \((\[Xi]\_3)\)\_r + 
                r\ \((\[Xi]\_3)\)\_t + 
                v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] - 
                r\ \((\[Phi]\_1)\)\_\(v\_r\) + r\ \((\[Phi]\_3)\)\_h == 0\)},
          {
            \(\(-\[Xi]\_1\) - r\ \((\[Xi]\_2)\)\_\[Theta] + 
                r\ v\_r\ \((\[Xi]\_3)\)\_r + r\ \((\[Xi]\_3)\)\_t + 
                2\ v\_\[Theta]\ \((\[Xi]\_3)\)\_\[Theta] - 
                r\ \((\[Phi]\_2)\)\_\(v\_\[Theta]\) + 
                r\ \((\[Phi]\_3)\)\_h == 0\)},
          {\(\(-\((\[Xi]\_3)\)\_r\) + \((\[Phi]\_1)\)\_h == 0\)},
          {
            \(h\ v\_r\ \((\[Xi]\_3)\)\_\[Theta] - 
                h\ r\ v\_r\ \((\[Phi]\_2)\)\_h + 
                r\^2\ v\_r\ \((\[Phi]\_2)\)\_r + r\^2\ \((\[Phi]\_2)\)\_t + 
                r\ v\_\[Theta]\ \((\[Phi]\_2)\)\_\[Theta] + 
                r\ \((\[Phi]\_3)\)\_\[Theta] == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_\[Theta]\) + 
                v\_r\ \((\[Xi]\_3)\)\_\[Theta] + 
                r\ \((\[Phi]\_1)\)\_\(v\_\[Theta]\) == 0\)},
          {
            \(\((\[Xi]\_1)\)\_\[Theta] - v\_r\ \((\[Xi]\_3)\)\_\[Theta] + 
                r\ \((\[Phi]\_2)\)\_\(v\_r\) == 0\)},
          {\(\(-\((\[Xi]\_3)\)\_\[Theta]\) + r\ \((\[Phi]\_2)\)\_h == 0\)}
          },
        RowSpacings->2,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting 29 equations are again linear. The symmetries of polytropic \
gas follow by solving this set of overdetermined equations. For polytropic \
gas equations, we not only have to provide three dependent variables but also \
three terms in the list for the substitutions. Compared with the examples \
discussed above, the typing is a little bit tedious, but the gain of the \
calculation is greater than this little hazel. To simplify the input of the \
information ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " provides a template for the function ",
  StyleBox["DeterminingEquations[] ", "MmaText"],
  "which looks like ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            SubsuperscriptBox[
              TagBox[
                StyleBox["\[ScriptCapitalD]\[ScriptE]\[ScriptT]Eq",
                  "InlineFormula"],
                NotationBoxTag,
                Editable->True], \(u, x\), \(\[Delta], \[Gamma]\)], "[", 
            "\[CapitalDelta]", "]"}],
          "InlineFormula"], TraditionalForm]]],
  " . This operator has the same functionality as function ",
  StyleBox["DeterminingEquations[]", "MmaText"],
  " itself. In fact it derives the determining equations using the function ",
  
  StyleBox["DeterminingEquations[]", "MmaText"],
  ". The following example shows the location of the input variables for the \
Harry-Dym equation. "
}], "Text",
  Evaluatable->False,
  CellTags->{
  "overdetermined equations", "polytropic gas equations", "template", 
    "DeterminingEquations[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"detHarryDym", " ", "=", 
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalD]\[ScriptE]\[ScriptT]Eq",
                  FontSize->10],
                NotationBoxTag,
                Editable->True],
              FontSize->10], \({u}, {x, t}\), 
            \({\[PartialD]\_t U}, {\[Lambda]}\)], "[", "harryDym", "]"}]}], 
      " ", ";", " ", \(detHarryDym // LTF\)}]], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + 
                u\^3\ \[Lambda]\ \((\[Xi]\_1)\)\_\(x, x, x\) - 
                3\ u\^3\ \[Lambda]\ \((\[Phi]\_1)\)\_\(x, x, u\) == 0\)},
          {
            \(\((\[Phi]\_1)\)\_t - 
                u\^3\ \[Lambda]\ \((\[Phi]\_1)\)\_\(x, x, x\) == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_\(x, x\)\) + \((\[Phi]\_1)\)\_\(x, u\) == 0
              \)},
          {
            \(3\ \[Phi]\_1 - 3\ u\ \((\[Xi]\_1)\)\_x + 
                u\ \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "So far, we have been able to calculate the determining equations for a \
given system of partial differential equations. The question arises of how to \
solve these equations. The following section will discuss an interactive \
procedure to construct solutions for the determining equations. In C",
  ButtonBox["hapter 10,",
    ButtonData:>{"symmet8.nb", 
      "Solution of Coupled Linear Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " we will discuss procedures allowing the automatic solution of the \
determining equations."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.4.3 Interactive Solution of Determining Equations", "Subsection",
  CellTags->"Solution of the determining equations"],

Cell[TextData[{
  "In the above discussions, we found a lot of equations determining the \
infinitesimal transformations of the different models. We realized that a \
common property of all these systems of equations was their linearity. Since \
determining equations are linear, contrary to the equations we started from \
(compare with the Burgers or Harry-Dym equations), we expect that the linear \
equations can be solved more easily. How to tackle this problem interactively \
by ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is the content of this section. We will show you a way which is similar \
to the automatic procedure of solving equations."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "determining equations", "Harry-Dym equation", "Burgers equation"}],

Cell["\<\
Let us demonstrate the interactive solution steps for the heat \
equation. The seven determining equations for the heat equation are\
\>", 
  "Text",
  Evaluatable->False,
  CellTags->{"interactive solution", "heat equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(detheat // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {\(\((\[Phi]\_1)\)\_t - \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {\(2\ \((\[Xi]\_1)\)\_x - \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Before discussing the solution of these equations, let us introduce some \
simplification. During the solution steps of these equations, the variables ",
  
  Cell[BoxData[
      \(TraditionalForm\`x, t\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are taking the role of independent variables. Taking this behavior into \
account in our calculations, we can remove the dependencies in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we just replace the dependent variable by the variable itself:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(detheat = detheat /. u[x, t] \[Rule] u\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox[\(xi[1]\), 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(phi[1]\), 
            TagBox[\((0, 0, 2)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u\), "]"}], ",", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u\), "]"}]}], "-", 
          RowBox[{"2", " ", 
            RowBox[{
              SuperscriptBox[\(phi[1]\), 
                TagBox[\((1, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u\), "]"}]}], "+", 
          RowBox[{
            SuperscriptBox[\(xi[1]\), 
              TagBox[\((2, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u\), "]"}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u\), "]"}], "-", 
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((2, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u\), "]"}]}], ",", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u\), "]"}]}], "+", 
          RowBox[{"2", " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u\), "]"}]}]}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This simplifies a little the representation of the equations but does not \
solve them. If we look at the first four equations, we observe that the \
infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " are reduced to special presolutions resulting especially from single \
terms. For example, the first two equations state that the infinitesimals for \
the independent variables are independent of the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The fourth equation says that, in addition, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  " is independent of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The third equation in the list ",
  StyleBox["detheat",
    FontSlant->"Italic"],
  " suggests that the infinitesimal ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_1\)]],
  " is linear in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". All this information can be collected in rules allowing us to simplify \
the determining equations:"
}], "Text",
  CellTags->{"pre-solutions", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infini1 = {xi[1] \[Rule] Function[{x, t, u}, \(xi[1]\)[x, t]], \n\t\t
        xi[2] \[Rule] Function[{x, t, u}, \(xi[2]\)[t]], \n\t\t
        phi[1] \[Rule] Function[{x, t, u}, f1[x, t]\ u + f2[x, t]]}\)], 
  "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t, u}, \(xi[1]\)[x, t]], 
      xi[2] \[Rule] Function[{x, t, u}, \(xi[2]\)[t]], 
      phi[1] \[Rule] Function[{x, t, u}, f1[x, t]\ u + f2[x, t]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  StyleBox["f1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["f2",
    FontSlant->"Italic"],
  " are two arbitrary functions depending on ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Inserting this primal representation of the infinitesimals into the \
determining equations, we end up with the following system:"
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(detheat1 = detheat /. infini1; detheat1 // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {"True"},
          {"True"},
          {"True"},
          {"True"},
          {
            \(\(-2\)\ f1\_x - \((\[Xi]\_1)\)\_t + \((\[Xi]\_1)\)\_\(x, x\) == 
              0\)},
          {\(u\ f1\_t + f2\_t - u\ f1\_\(x, x\) - f2\_\(x, x\) == 0\)},
          {\(2\ \((\[Xi]\_1)\)\_x - \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The seven equations reduce to three equations for the unknown functions ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2\)]],
  ", ",
  StyleBox["f1",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["f2",
    FontSlant->"Italic"],
  ". Considering the last equation of this set by differentiating with \
respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ","
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x Last[detheat1] // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {\(2\ \((\[Xi]\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "we realize that a single term remains. This term defines a partial \
differential equation of second order for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  ". The solution of this equation is given by a linear function in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Thus, we define"
}], "Text",
  Evaluatable->False,
  CellTags->"partial differential equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infini2 = {xi[1] \[Rule] Function[{x, t}, g1[t]\ x + g2[t]]}\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t}, g1[t]\ x + g2[t]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Inserting this partial solution again into the reduced determining \
equations ",
  StyleBox["detheat1,",
    FontSlant->"Italic"],
  " we can simplify the determining equations a second time. The resulting \
equations read"
}], "Text",
  Evaluatable->False,
  CellTags->{"partial solution", "reduced determining equations"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(detheat2 = detheat1 /. infini2; detheat2 // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {"True"},
          {"True"},
          {"True"},
          {"True"},
          {\(\(-2\)\ f1\_x - x\ g1\_t - g2\_t == 0\)},
          {\(u\ f1\_t + f2\_t - u\ f1\_\(x, x\) - f2\_\(x, x\) == 0\)},
          {\(2\ g\_1 - \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "An integration of the fifth element of the list ",
  StyleBox["detheat2",
    FontSlant->"Italic"],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " gives us"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(integ = 
      \[Integral]detheat2\[LeftDoubleBracket]5\[RightDoubleBracket] 
            \[DifferentialD]x - g3[t]; integ // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(\(-2\)\ f\_1\), "-", \(g\_3\), "-", 
                StyleBox[\(\(x\^2\ g1\_t\)\/2\),
                  ScriptLevel->0], "-", \(x\ g2\_t\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "meaning that function ",
  StyleBox["f1",
    FontSlant->"Italic"],
  " can be expressed by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = Flatten[Solve[integ == 0, f1[x, t]] /. f1[x, t] \[Rule] w]\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"w", "\[Rule]", 
        RowBox[{\(1\/4\), " ", 
          RowBox[{"(", 
            RowBox[{\(\(-2\)\ g3[t]\), "-", 
              RowBox[{\(x\^2\), " ", 
                RowBox[{
                  SuperscriptBox["g1", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "-", 
              RowBox[{"2", " ", "x", " ", 
                RowBox[{
                  SuperscriptBox["g2", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell["which is converted in a pure function by", "Text",
  Evaluatable->False,
  CellTags->"pure function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infini3 = f1 \[Rule] Function[{x, t}, w] /. sol\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"f1", "\[Rule]", 
      RowBox[{"Function", "[", 
        RowBox[{\({x, t}\), ",", 
          RowBox[{\(1\/4\), " ", 
            RowBox[{"(", 
              RowBox[{\(\(-2\)\ g3[t]\), "-", 
                RowBox[{\(x\^2\), " ", 
                  RowBox[{
                    SuperscriptBox["g1", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], "-", 
                RowBox[{"2", " ", "x", " ", 
                  RowBox[{
                    SuperscriptBox["g2", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}], 
              ")"}]}]}], "]"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Inserting the result again in the reduced set of determining \
equations, we find\
\>", "Text",
  Evaluatable->False,
  CellTags->"reduced set of determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(detheat3 = Simplify[detheat2 /. infini3]; detheat3 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"True"},
          {"True"},
          {"True"},
          {"True"},
          {"True"},
          {
            RowBox[{
              RowBox[{\(f2\_t\), "+", 
                StyleBox[\(\(u\ g1\_t\)\/2\),
                  ScriptLevel->0], "-", \(f2\_\(x, x\)\), "-", 
                RowBox[{
                  StyleBox[\(1\/4\),
                    ScriptLevel->0], " ", "u", " ", 
                  \((2\ g3\_t + x\ \((x\ g1\_\(t, t\) + 2\ g2\_\(t, t\))\))
                    \)}]}], "==", "0"}]},
          {\(2\ g\_1 - \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Apart from ",
  StyleBox["xi",
    FontSlant->"Italic"],
  "[2], the equations contain only relations for the auxiliary functions ",
  StyleBox["g1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["g2",
    FontSlant->"Italic"],
  ", ",
  StyleBox["g3",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["f2",
    FontSlant->"Italic"],
  ". Extracting the coefficients of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\ x\)]],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"u", 
          FormBox[\(x\^2\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", we get the following set of equations:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(equat = Table[Coefficient[detheat3, u\ x\^i], {i, 2, 1, \(-1\)}]; 
    equat // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0, 0, \(-\(g1\_\(t, t\)\/4\)\), 0}, {0, 0, 0, 0, 0, 
        \(-\(g2\_\(t, t\)\/2\)\), 0}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(AppendTo[equat, Coefficient[detheat3 /. x \[Rule] 0, u]]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[equat, 
      \((detheat3 /. u \[Rule] 0)\)\[LeftDoubleBracket]6
        \[RightDoubleBracket]]; equat // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0, 0, \(-\(g1\_\(t, t\)\/4\)\), 0}, {0, 0, 0, 0, 0, 
        \(-\(g2\_\(t, t\)\/2\)\), 0}, {0, 0, 0, 0, 0, g1\_t\/2 - g3\_t\/2, 
        0}, f2\_t - f2\_\(x, x\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(h1 = DeleteCases[Flatten[equat], 0]; h1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{"-", 
                StyleBox[\(g1\_\(t, t\)\/4\),
                  ScriptLevel->0]}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{"-", 
                StyleBox[\(g2\_\(t, t\)\/2\),
                  ScriptLevel->0]}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(g1\_t\/2\),
                  ScriptLevel->0], "-", 
                StyleBox[\(g3\_t\/2\),
                  ScriptLevel->0]}], "==", "0"}]},
          {\(f2\_t - f2\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The final set of determining equations is solved step by step using the \
function ",
  StyleBox["DSolve[]", "MmaText"],
  ". By renaming the constants of integration, we prevent misinterpretations \
of the group parameters. Function ",
  StyleBox["g1",
    FontSlant->"Italic"],
  " follows from the first equation of the set ",
  StyleBox["h1 ",
    FontSlant->"Italic"],
  "by"
}], "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1 = 
      DSolve[h1\[LeftDoubleBracket]1\[RightDoubleBracket] == 0, g1, t] /. {
          C[1] \[Rule] k1, C[2] \[Rule] k2}\)], "Input"],

Cell[BoxData[
    \({{g1 \[Rule] \((k1 + k2\ #1&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The second auxiliary function ",
  StyleBox["g2",
    FontSlant->"Italic"],
  " is"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2 = 
      DSolve[h1\[LeftDoubleBracket]2\[RightDoubleBracket] == 0, g2, t] /. {
          C[1] \[Rule] k3, C[2] \[Rule] k4}\)], "Input"],

Cell[BoxData[
    \({{g2 \[Rule] \((k3 + k4\ #1&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The last of the auxiliary functions ",
  StyleBox["g3",
    FontSlant->"Italic"],
  " reads"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s3 = 
      DSolve[h1\[LeftDoubleBracket]3\[RightDoubleBracket] == 0 /. s1, g3, 
          t] /. {C[1] \[Rule] k5}\)], "Input"],

Cell[BoxData[
    \({{g3 \[Rule] \((k5 + k2\ #1&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Knowing the representations of functions ",
  StyleBox["g1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["g2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["g3",
    FontSlant->"Italic"],
  ", we can integrate the remaining equation of the determining system"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s4 = 
      DSolve[\((Last[detheat3] /. s1)\)\[LeftDoubleBracket]1
              \[RightDoubleBracket] == 0, xi[2], t] /. \n\t\t
        C[1] \[Rule] k6\)], "Input"],

Cell[BoxData[
    \({{xi[2] \[Rule] \((k6 + 2\ k1\ #1 + k2\ #1\^2&)\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
Knowledge of the auxiliary functions allows us to write down the \
solutions for the infinitesimals:\
\>", "Text",
  Evaluatable->False,
  CellTags->"solutions for the infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infinitesimals = 
      Flatten[\(\(\(\(\(\({\(xi[1]\)[x, t, u], \n\t\t\t\(xi[2]\)[x, t, u], 
                        \(phi[1]\)[x, t, u]} /. infini1\) /. \n\t\t\tinfini2
                    \) /. infini3\) /. s1\) /. s2\) /. s3\) /. s4]\)], "Input"],

Cell[BoxData[
    \({k3 + k4\ t + \((k1 + k2\ t)\)\ x, k6 + 2\ k1\ t + k2\ t\^2, 
      1\/4\ u\ \((\(-2\)\ \((k5 + k2\ t)\) - 2\ k4\ x - k2\ x\^2)\) + 
        f2[x, t]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the infinitesimals depend on six parameters ",
  StyleBox["k1\[Dash]k6,",
    FontSlant->"Italic"],
  " which are the group parameters of the symmetry group. In addition to \
these six parameters, the infinitesimals contain the auxiliary function ",
  StyleBox["f2",
    FontSlant->"Italic"],
  " which satisfies the heat equation. The heat equation remains as a last \
condition in variable ",
  StyleBox["h1",
    FontSlant->"Italic"],
  ". The symmetry represented by ",
  StyleBox["f2",
    FontSlant->"Italic"],
  " is related to an infinite dimensional group. This infinite dimensional \
group is characteristic for linear partial differential equations. The \
subgroups determined by one of the parameters ",
  StyleBox["k1\[Dash]k6",
    FontSlant->"Italic"],
  " are related to translations, scalings, and Galilean boosts."
}], "Text",
  CellTags->{
  "infinitesimals of the heat equation", "infinite dimensional group"}],

Cell[TextData[{
  "We demonstrated by the above calculation how the linear coupled system of \
partial differential equations is solved by using simple integration steps. \
The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " offers a function to carry out all these simple steps in one shot. The \
name of the related ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function is ",
  StyleBox["Infinitesimals[]", "MmaText"],
  ". This function allows the automatic derivation of the infinitesimal \
transformations. The shorthand description of the function shows us the \
information needed to carry out the calculation:"
}], "Text",
  CellTags->"Infinitesimals[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<Infinitesimals\>", LongForm \[Rule] False]\)], "Input"],

Cell[BoxData[
    \("Infinitesimals[equations_,dependentVariables_, \
independentVariables_,parameters_,options___] The function Infinitesimals \
calculates the point symmetries of a given system of equations. The results \
of the calculation are not saved in a file. They are available in a pure \
function representation."\)], "Output"]
}, Open  ]],

Cell["The application of this function to the heat equation reads ", "Text",
  Evaluatable->False,
  CellTags->"heat equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Infinitesimals[heat, {u}, {x, t}, {}]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({xi[1] \[Rule] Function[{x, t, u}, k5 - 2\ k2\ t + k6\ x + k4\ t\ x], 
          xi[2] \[Rule] Function[{x, t, u}, k3 + t\ \((2\ k6 + k4\ t)\)], 
          phi[1] \[Rule] 
            Function[{x, t, u}, 
              u\ \((k1 - \(k4\ t\)\/2 + k2\ x - \(k4\ x\^2\)\/4)\) + 
                \(free[1]\)[x, t]]}\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                SuperscriptBox[\(free[1]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "+", 
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}]}], "}"}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " consists of a nested list. The first part of the list contains the \
infinitesimals; the second, a list of remaining equations. The remaining \
equations of the second part are equations which are not solved by the ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " package. The function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] occurring in the remaining equation is also part of the infinitesimals. \
This result has to be expected since the original equation is a linear \
equation which has to satisfy the superposition principle reflected by the \
occurrence of the auxiliary function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "]. The first list of the result circumscribes the infinitesimals in a pure \
function representation. This cast allows direct substitution of the \
infinitesimals into any equation containing the infinitesimals or their \
derivatives. The result found for the heat equation represents a \
six-dimensional finite group which is isomorphic to the finite group derived \
by our manual calculations."
}], "Text",
  Evaluatable->False,
  CellTags->{"Infinitesimals[]", "infinitesimals", "finite group"}],

Cell[TextData[{
  "Having the function ",
  StyleBox["Infinitesimals[] ", "MmaText"],
  "available, we are able to determine the point symmetries of the other \
equations discussed above. For example, the Harry-Dym equation allows the \
symmetries"
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the Harry-Dym equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(symharryDym = 
      Infinitesimals[
        \[PartialD]\_t u[x, t] - 
            \[Lambda]\ \(u[x, t]\^3\) \[PartialD]\_\(x, x, x\)u[x, t] == 0, {
          u}, {x, t}, {\[Lambda]}]\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t, u}, k3 + x\ \((k4 + k5\ x)\)], 
      xi[2] \[Rule] Function[{x, t, u}, k1 + k2\ t], 
      phi[1] \[Rule] 
        Function[{x, t, u}, u\ \((\(-\(k2\/3\)\) + k4 + 2\ k5\ x)\)]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the Harry-Dym equation allows a five-dimensional \
finite group independent of the parameter \[Lambda]. Group parameters ",
  StyleBox["k3",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k1",
    FontSlant->"Italic"],
  " represent the invariance of the Harry-Dym equation with respect to \
translations. The scaling symmetries are determined by the parameters ",
  StyleBox["k4",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k2.",
    FontSlant->"Italic"],
  " The remaining parameter, ",
  StyleBox["k5",
    FontSlant->"Italic"],
  ", represents a non-standard conformal transformation."
}], "Text",
  Evaluatable->False,
  CellTags->{"translation", "conformal transformation"}],

Cell["\<\
Another example for a calculation of point symmetries is given by \
the two-dimensional polytropic gas discussed above. The symmetries follow \
by\
\>", "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the polytropic gas"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sympoly = 
      Infinitesimals[poly, {vr, v\[Theta], h}, {r, \[Theta], t}]\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] 
        Function[{r, \[Theta], t, vr, v\[Theta], h}, \((k2 + k3)\)\ r], 
      xi[2] \[Rule] Function[{r, \[Theta], t, vr, v\[Theta], h}, \(-k4\)], 
      xi[3] \[Rule] Function[{r, \[Theta], t, vr, v\[Theta], h}, k1 + k2\ t], 
      phi[3] \[Rule] Function[{r, \[Theta], t, vr, v\[Theta], h}, 2\ h\ k3], 
      phi[1] \[Rule] Function[{r, \[Theta], t, vr, v\[Theta], h}, k3\ vr], 
      phi[2] \[Rule] 
        Function[{r, \[Theta], t, vr, v\[Theta], h}, k3\ v\[Theta]]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting point symmetries are given by a four-dimensional group. The \
symmetry transformations are translations in the time coordinate and the \
angular direction. The related group parameters are ",
  StyleBox["k1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k4. ",
    FontSlant->"Italic"],
  "In addition to the translations, the polytropic gas enables a scaling of \
the radial and temporal coordinate denoted by ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ". Group parameter ",
  StyleBox["k3",
    FontSlant->"Italic"],
  " represents a special type of scaling."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " can not only explicitly treat given equations but is also capable of \
analyzing equations of a general form, like"
}], "Text",
  Evaluatable->False,
  CellTags->"Infinitesimals[]"],

Cell[BoxData[
    \(TraditionalForm\`\(u\_t\  - \ F(x, u, u\_x, u\_\(x, x\))\  = \ 0, 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is an arbitrary function depending on a set of independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and a set of dependent variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". An example of such an equation for one dependent and two independent \
variables is given by the general second-order equation"
}], "Text",
  Evaluatable->False,
  CellTags->"general second-order equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(geneq = {
        \[PartialD]\_t U - F[x, U, \[PartialD]\_x U, \[PartialD]\_\(x, x\)U]}
        \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          RowBox[{"F", "[", 
            RowBox[{"x", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}]}], 
        "+", 
        RowBox[{
          SuperscriptBox["u", 
            TagBox[\((0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t\), "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The corresponding infinitesimals for this type of equation follow \
by\
\>", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(symgeneq = Infinitesimals[geneq, {u}, {x, t}]\)], "Input"],

Cell[BoxData[
    \({phi[1] \[Rule] Function[{x, t, u}, 0], 
      xi[1] \[Rule] Function[{x, t, u}, 0], 
      xi[2] \[Rule] Function[{x, t, u}, k1]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing a one-dimensional symmetry group. Parameter ",
  StyleBox["k1",
    FontSlant->"Italic"],
  " characterizes the translations under which the general evolution equation \
is invariant. Let us now specify the auxiliary function ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " in a more explicit form. For example, let us assume that ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is replaced by a function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " independent of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". We further assume that the second derivative in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is created by a derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Taking into account all these assumptions, we end up with an expression \
for a general nonlinear diffusion equation:"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "one-dimensional symmetry group", "nonlinear diffusion equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(geneqe = {\[PartialD]\_t U - \[PartialD]\_x f[\[PartialD]\_x U]}; 
    geneqe // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - f\_\(u\_x\)\ u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The symmetries of this general non-linear diffusion equation \
are\
\>", "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the general nonlinear diffusion equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(symgeneqe = Infinitesimals[geneqe, {u}, {x, t}]\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t, u}, k2 + \(k4\ x\)\/2], 
      xi[2] \[Rule] Function[{x, t, u}, k3 + k4\ t], 
      phi[1] \[Rule] Function[{x, t, u}, k1 + \(k4\ u\)\/2]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The four group parameters ",
  StyleBox["k1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k3",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k4",
    FontSlant->"Italic"],
  " represent the translation and scaling symmetries of the equation. If we \
further assume that ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is given by a power of the derivatives ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x\)]],
  ", we get the equation"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(geneqe = {
        \[PartialD]\_t U - \[PartialD]\_x\((\[PartialD]\_x U)\)\^\[Mu]}; 
    geneqe // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - \[Mu]\ u\_x\%\(\(-1\) + \[Mu]\)\ u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[Mu] is a real parameter. The infinitesimals of this non-linear heat \
equation read"], "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the nonlinear heat equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(symgeneqe = Infinitesimals[geneqe, {u}, {x, t}, {\[Mu]}]\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t, u}, k4 + k5\ x], 
      xi[2] \[Rule] 
        Function[{x, t, u}, 
          k1 + t\ \((\(-k3\)\ \((\(-1\) + \[Mu])\) + k5\ \((1 + \[Mu])\))\)], 
      phi[1] \[Rule] Function[{x, t, u}, k2 + k3\ u]}\)], "Output"]
}, Open  ]],

Cell[TextData[
"The five-dimensional group contains translations and scaling symmetries. In \
addition the symmetry group depends on the parameter \[Mu]."], "Text",
  Evaluatable->False,
  CellTags->{"translation", "scaling symmetries"}],

Cell[TextData[{
  "The function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " is also available in a shorthand operator notation. The related operator \
template is ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            SubsuperscriptBox[
              TagBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                NotationBoxTag,
                Editable->True], \(u, x\), "\[Gamma]"], "[", 
            "\[CapitalDelta]", "]"}],
          "InlineFormula"], TraditionalForm]]],
  ". As input quantities, this operator needs the independent and dependent \
variables, the equations, and the parameters. The example of the Harry-Dym \
equation reduces to"
}], "Text",
  CellTags->{"Infinitesimals[]", "infinitesimals of the Harry-Dym equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox[
          TagBox[
            StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
              FontSize->9],
            NotationBoxTag,
            Editable->True],
          FontSize->18], \({u}, {x, t}\), \({\[Lambda]}\)], "[", "harryDym", 
      "]"}]], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t, u}, k3 + x\ \((k4 + k5\ x)\)], 
      xi[2] \[Rule] Function[{x, t, u}, k1 + k2\ t], 
      phi[1] \[Rule] 
        Function[{x, t, u}, u\ \((\(-\(k2\/3\)\) + k4 + 2\ k5\ x)\)]}\)], 
  "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.4.4 Data Basis of Symmetries", "Subsection",
  CellTags->"Data basis of symmetries"],

Cell[TextData[{
  "The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " offers a few functions allowing the creation of a database for \
differential equations. The database consists of different files containing \
information on the specific equation. Each file stores information on the \
equation itself and results gained by the application of different functions. \
The merits of such a database are the consecutive collection of information \
on symmetries, on algebraic properties, on transformation properties, and on \
solutions for the equation under consideration. Since the information is \
stored on disk, it can always be retrieved from there."
}], "Text",
  Evaluatable->False,
  CellTags->{"data basis for differential equations", "data basis"}],

Cell[TextData[{
  "The basic element of the database is a file containing information on each \
individual equation. Such a file is created by the function ",
  StyleBox["LieEquations[]", "MmaText"],
  ". The file contains information on the independent and dependent variables \
of the equation and the equation itself. It also contains information on \
possible parameters of the equation. Also included in the file are the \
expressions for which the equations are solved and applied as side conditions \
in the determining equations. After the solution of the determining \
equations, the file contains information on the infinitesimals. Sometimes, it \
is helpful to have the source or name of an equation available. This \
information is contained in two different global variables called ",
  StyleBox["Title", "MmaText",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Source", "MmaText",
    FontSlant->"Italic"],
  ". The entire information needed to carry out a symmetry analysis can be \
created by exerting the function ",
  StyleBox["LieEquations[]", "MmaText"],
  ". An example will show us how to facilitate this function."
}], "Text",
  Evaluatable->False,
  CellTags->{"LieEquations[]", "sidecondition", "determining equations"}],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Let us again discuss the heat equation. The first step in adding \
information to the database is the creation of the related file. For the heat \
equation, we create the file ",
  StyleBox["heat.dgl", "MmaText",
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"],
  " The function ",
  StyleBox["LieEquations[]", "MmaText"],
  " will do the necessary job:"
}], "Text",
  Evaluatable->False,
  CellTags->"heat equation"],

Cell[BoxData[
    \(LieEquations[
      "\<heat.dgl\>", {
        \[PartialD]\_t u[x, t] - d\ \[PartialD]\_{x, 2}u[x, t]}, \n
      \t{u}, {x, t}, {d}, {"\<Heat equation\>"}, \n
      \t{{"\<G. Baumann\>"}, {"\<Ulm 1997\>"}}]\)], "Input"],

Cell[TextData[{
  "The file with the name ",
  StyleBox["heat.dgl", "MmaText",
    FontSlant->"Italic"],
  " is created by this function in the current directory. The file contains \
the equation, which is given as second argument in a list. The third and \
fourth arguments of ",
  StyleBox["LieEquations[]", "MmaText"],
  " are lists containing the dependent and independent variables. The fifth \
argument is a list containing the parameters of the equation\[LongDash]in our \
example the diffusion constant ",
  StyleBox["d",
    FontSlant->"Italic"],
  ". The sixth and seventh arguments of ",
  StyleBox["LieEquations[]", "MmaText"],
  " are lists containing strings. The sixth list carries the name of the \
equation, here ",
  StyleBox["Heat equation,",
    FontSlant->"Italic"],
  " and the seventh list consists of sublists specifying for example the \
source of the equation. The file created by ",
  StyleBox["LieEquations[]", "MmaText"],
  " contains this information and more. We can print the contents of the file \
by"
}], "Text",
  Evaluatable->False,
  CellTags->"LieEquations[]"],

Cell[BoxData[
    \(\(! \(! heat . dgl\)\)\)], "Input"],

Cell[BoxData[
    \(Title\  = \ 
      \({"\<Heat equation\>"}\nSource\  = \ 
        \({{"\<G. Baumann\>"}, \ {"\<Ulm 1997\>"}}\nIndepVar\  = \ 
          \({x, \ t}\nDependVar\  = \ 
            \({u}\nEqList\  = \ 
              \({\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]\  - \ 
                      d*\(\(Derivative[2, \ 0]\)[u]\)[x, \ t]}\nSubsList\  = 
                \ \({\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]}\nParameterS\  = \ 
                  \({d}\nListXi\  = \ 
                    \({}\nListPhi\  = \ {}\)\)\)\)\)\)\)\)\)], "Input"],

Cell[TextData[{
  "The above printout shows that the file contains variables like ",
  StyleBox["Title", "MmaText",
    FontSlant->"Italic"],
  ",",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["Source", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["IndepVar", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["DependVar", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["EqList", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["SubsList", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["ParameterS", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["ListXi",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["ListPh", "MmaText",
    FontSlant->"Italic"],
  StyleBox["i", "MmaText"],
  ". These variables are global variables in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and are used extensively in the package. Be sure not to use these names \
in your calculations. If you set up this file, it provides you with the \
information needed in symmetry calculations. For example, if you have to \
derive the determining equations for the heat equation, you can use the \
function ",
  StyleBox["Lie[]", "MmaText"],
  " of the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The function ",
  StyleBox["Lie[]", "MmaText"],
  " delivers in its simpler applications, results similar to those obtained \
by the program of ",
  ButtonBox["Champagne et al. [1991]",
    ButtonData:>{"Literat.nb", "Champagne-1990"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"global variables in MathLie", "Lie[]"}],

Cell[TextData[{
  "The function ",
  StyleBox["Lie[]", "MmaText"],
  " needs one argument and a set of options. The options of ",
  StyleBox["Lie[]", "MmaText"],
  " influence the properties of this function."
}], "Text",
  Evaluatable->False],

Cell["\<\
Let us calculate the determining equations for the heat equation. \
We start the calculation simply by\
\>", "Text",
  Evaluatable->False,
  CellTags->{"determining equations", "heat equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(detheat = Lie["\<heat.dgl\>"]; detheat\  // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + d\ \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ d\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {\(\((\[Phi]\_1)\)\_t - d\ \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {\(\(-2\)\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Function Lie[] calculates the prolongation of the equation using the Fr\
\[EAcute]chet derivative. After extraction of coefficients and a \
simplification of these equations, the function returns the determining \
equations collected in a list. This list can be used to manipulate the \
equations. For example, you can manually solve them as discussed in S",
  ButtonBox["ection 5.4.3",
    ButtonData:>"Solution of the determining equations",
    ButtonStyle->"Hyperlink"],
  ". As mentioned above, the behavior of the function ",
  StyleBox["Lie[]", "MmaText"],
  " is controlled by different options. One of these options is called ",
  StyleBox["ScreenPrint", "MmaText"],
  " which is set to False by default and thus suppresses all printing. If\
\[NonBreakingSpace]we want to see how the calculation proceeds, we can set \
the option ",
  StyleBox["TraceSteps\[Rule]True,", "MmaText"],
  " which is another option of ",
  StyleBox["Lie[]", "MmaText"],
  ". These two options are helpful in checking the calculation if one is \
curious about the steps operated by ",
  StyleBox["Lie[]", "MmaText"],
  ". The options also help in locating some errors that occurred during the \
calculation. The silent calculation done for the heat equation then looks \
like"
}], "Text",
  Evaluatable->False,
  CellTags->{"Fr\[EAcute]chet derivative", "prolongation", "Lie[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<heat.dgl\>", TraceSteps \[Rule] True, ScreenPrint \[Rule] True]
      \)], "Input"],

Cell[BoxData[{"\<\" +--------------------------------------------+\"\>", 
  "\<\"  Welcome to MathLie\[Trademark]\"\>", 
  "\<\"  for the calculation of the symmetry group\"\>", 
  \("  by"\ \ G . \ Baumann, \ \[Copyright]\ 1992 - 1999\), 
  "\<\" +--------------------------------------------+\"\>", 
    InterpretationBox[
      \("Loading previous calculations of the determining equations from  "\
\[InvisibleSpace]"HEAT.DEQ"\),
      SequenceForm[ 
      "Loading previous calculations of the determining equations from  ", 
        "HEAT.DEQ"],
      Editable->False], 
    InterpretationBox[\("Loading data from  "\[InvisibleSpace]"HEAT.DGL"\),
      SequenceForm[ "Loading data from  ", "HEAT.DGL"],
      Editable->False]}], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{
  \(Title\ of\ the\ 
      \(equations : \n
        "-----------------------------------------------------"\)\), 
  "\<\"Heat equation\"\>", "\<\"Source of the equations:\"\>", 
  "\<\"G. Baumann\"\>", "\<\"Ulm 1997\"\>", "\<\"Equations of motion:\"\>", 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. "\[InvisibleSpace]1\),
      SequenceForm[ "Equation No. ", 1],
      Editable->False], 
    RowBox[{
      RowBox[{
        InterpretationBox[\(u\_t\),
          Subscripted[ 
            u[ t]],
          Editable->False], "-", 
        RowBox[{"d", " ", 
          InterpretationBox[\(u\_\(x, x\)\),
            Subscripted[ 
              u[ x, x]],
            Editable->False]}]}], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Substitution No. "\[InvisibleSpace]1\),
      SequenceForm[ "Substitution No. ", 1],
      Editable->False], 
    RowBox[{
      InterpretationBox[\(u\_t\),
        Subscripted[ 
          u[ t]],
        Editable->False], "\[Rule]", 
      RowBox[{"d", " ", 
        InterpretationBox[\(u\_\(x, x\)\),
          Subscripted[ 
            u[ x, x]],
          Editable->False]}]}], 
  "\<\"-----------------------------------------------------\"\>", 
  "\<\"We are using all the equation(s) checking the infinitesimals\"\>", 
    InterpretationBox[
      \("of the given system consisting of "\[InvisibleSpace]1
        \[InvisibleSpace]" equation(s) in total."\),
      SequenceForm[ 
      "of the given system consisting of ", 1, " equation(s) in total."],
      Editable->False]}], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{
  "\<\"We find 7 determining equations after simplification.\"\>", 
  "\<\"A list of the determining equations follows.\"\>", 
    InterpretationBox[\("Equation No. : "\[InvisibleSpace]1\),
      SequenceForm[ "Equation No. : ", 1],
      Editable->False], 
  "\<\"-----------------------------------------------------\"\>", 
    RowBox[{
      InterpretationBox[\(\((xi[1])\)\_u\),
        Subscripted[ 
          xi[ 1][ u]],
        Editable->False], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. : "\[InvisibleSpace]2\),
      SequenceForm[ "Equation No. : ", 2],
      Editable->False], 
  "\<\"-----------------------------------------------------\"\>", 
    RowBox[{
      InterpretationBox[\(\((xi[2])\)\_u\),
        Subscripted[ 
          xi[ 2][ u]],
        Editable->False], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. : "\[InvisibleSpace]3\),
      SequenceForm[ "Equation No. : ", 3],
      Editable->False], 
  "\<\"-----------------------------------------------------\"\>", 
    RowBox[{
      InterpretationBox[\(\((phi[1])\)\_\(u, u\)\),
        Subscripted[ 
          phi[ 1][ u, u]],
        Editable->False], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. : "\[InvisibleSpace]4\),
      SequenceForm[ "Equation No. : ", 4],
      Editable->False], 
  "\<\"-----------------------------------------------------\"\>", 
    RowBox[{
      InterpretationBox[\(\((xi[2])\)\_x\),
        Subscripted[ 
          xi[ 2][ x]],
        Editable->False], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. : "\[InvisibleSpace]5\),
      SequenceForm[ "Equation No. : ", 5],
      Editable->False], 
    RowBox[{
      RowBox[{
      "\<\"-----------------------------------------------------\"\>", "\n", 
        "-", 
        RowBox[{"2", " ", "d", " ", 
          InterpretationBox[\(\((phi[1])\)\_\(x, u\)\),
            Subscripted[ 
              phi[ 1][ x, u]],
            Editable->False]}], "-", 
        InterpretationBox[\(\((xi[1])\)\_t\),
          Subscripted[ 
            xi[ 1][ t]],
          Editable->False], "+", 
        RowBox[{"d", " ", 
          InterpretationBox[\(\((xi[1])\)\_\(x, x\)\),
            Subscripted[ 
              xi[ 1][ x, x]],
            Editable->False]}]}], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. : "\[InvisibleSpace]6\),
      SequenceForm[ "Equation No. : ", 6],
      Editable->False], 
  "\<\"-----------------------------------------------------\"\>", 
    RowBox[{
      RowBox[{
        InterpretationBox[\(\((phi[1])\)\_t\),
          Subscripted[ 
            phi[ 1][ t]],
          Editable->False], "-", 
        RowBox[{"d", " ", 
          InterpretationBox[\(\((phi[1])\)\_\(x, x\)\),
            Subscripted[ 
              phi[ 1][ x, x]],
            Editable->False]}]}], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. : "\[InvisibleSpace]7\),
      SequenceForm[ "Equation No. : ", 7],
      Editable->False], 
    RowBox[{
      RowBox[{
      "\<\"-----------------------------------------------------\"\>", "\n", 
        "-", 
        RowBox[{"2", " ", 
          InterpretationBox[\(\((xi[1])\)\_x\),
            Subscripted[ 
              xi[ 1][ x]],
            Editable->False]}], "+", 
        InterpretationBox[\(\((xi[2])\)\_t\),
          Subscripted[ 
            xi[ 2][ t]],
          Editable->False]}], "==", "0"}], 
  "\<\"-----------------------------------------------------\"\>", 
  "\<\"We have to treat 7 determining equations after simplification.\"\>"}], 
  "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    \("Results are collected in the list FinalResult."\)], "Output"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox[\(xi[1]\), 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(phi[1]\), 
            TagBox[\((0, 0, 2)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "-", 
          RowBox[{"2", " ", "d", " ", 
            RowBox[{
              SuperscriptBox[\(phi[1]\), 
                TagBox[\((1, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{"d", " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((2, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(phi[1]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], "-", 
          RowBox[{"d", " ", 
            RowBox[{
              SuperscriptBox[\(phi[1]\), 
                TagBox[\((2, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox[\(xi[2]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], "-", 
          RowBox[{"2", " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), 
              "]"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The results of the calculation are again the determining equations. If you \
look at the beginning of the calculation, you will realize that ",
  StyleBox["Lie[]", "MmaText"],
  " opens a file called ",
  StyleBox["heat.deq",
    FontSlant->"Italic"],
  " containing the determining equations. This file was created by ",
  StyleBox["Lie[]", "MmaText"],
  " at the end of the first run for the specific equation. The file contains \
the complete set of determining equations, thus keeping information on one \
equation in two different files. The first file with extension ",
  StyleBox[".dgl", "MmaText",
    FontSlant->"Italic"],
  " contains the essential information on the equation itself. The second \
file with extension ",
  StyleBox[".", "MmaText"],
  StyleBox["deq", "MmaText",
    FontSlant->"Italic"],
  " is used as source of derived information for the determining equations. \
Whenever you call ",
  StyleBox["Lie[]", "MmaText"],
  " or derivatives of the function ",
  StyleBox["Lie[]", "MmaText"],
  " be aware that both files contain information on the same equation.\
\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"determining equations", "Lie[]"}],

Cell[TextData[{
  "Let us now solve the determining equations. This can be done by using the \
function ",
  StyleBox["LieSolve[]", "MmaText"],
  ". This function allows the solution of the determining equations by \
exerting the same procedures as the function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  ". The difference is that the information gained is saved in the file \
currently opened. In the case of the heat equation, we get"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "LieSolve[]", "solution of the determining equations", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solheat = LieSolve["\<heat.dgl\>"]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({xi[1] \[Rule] 
            Function[{x, t, u}, k5 - 2\ d\ k2\ t + k6\ x + k4\ t\ x], 
          xi[2] \[Rule] Function[{x, t, u}, k3 + t\ \((2\ k6 + k4\ t)\)], 
          phi[1] \[Rule] 
            Function[{x, t, u}, 
              u\ \((k1 - \(k4\ t\)\/2 + k2\ x - \(k4\ x\^2\)\/\(4\ d\))\) + 
                \(free[1]\)[x, t]]}\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"-", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[\(free[1]\), 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}], "d"]}], 
            "+", 
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}]}], "}"}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of this calculation is a list containing the infinitesimals and \
the remaining equations. The remaining equations are usually not solvable by \
the procedures used by ",
  StyleBox["LieSolve[]", "MmaText"],
  ". If we look at the first part of this list, we realize that the \
infinitesimals ",
  StyleBox["xi[1]", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["xi[2]", "MmaText",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["phi[1]", "MmaText",
    FontSlant->"Italic"],
  " for the heat equation are given in a pure function representation. This \
representation allows us to use the results for the infinitesimals in further \
calculations. The second part of the resulting list contains the unsolved \
equations, which in the present case is given by the original equation. We \
have to expect that the arbitrary function ",
  StyleBox["free[1]",
    FontSlant->"Italic"],
  " must satisfy the heat equation since we analyzed a linear partial \
differential equation. As noted, the function ",
  StyleBox["LieSolve[]", "MmaText"],
  " saves the derived infinitesimals in the file ",
  StyleBox["heat.dgl", "MmaText",
    FontSlant->"Italic"],
  ". The information on the structure of the infinitesimals is contained in \
the lists ",
  StyleBox["ListXi", "MmaText",
    FontSlant->"Italic"],
  " and ",
  StyleBox["ListPhi", "MmaText",
    FontSlant->"Italic"],
  ". We can check the contents of ",
  StyleBox["heat.dgl", "MmaText",
    FontSlant->"Italic"],
  " again by"
}], "Text",
  Evaluatable->False,
  CellTags->"LieSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(! \(! heat . dgl\)\)\)], "Input"],

Cell[BoxData[{
    \(Title\  = \ {"Heat equation"}\), 
    \(Source\  = \ {{"G. Baumann"}, \ {"Ulm 1997"}}\), 
    \(IndepVar\  = \ {x, \ t}\), 
    \(DependVar\  = \ {u}\), 
    \(EqList\  = 
      \ {\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]\  - \ 
          d*\(\(Derivative[2, \ 0]\)[u]\)[x, \ t]}\), 
    \(SubsList\  = \ {\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]}\), 
    \(ParameterS\  = \ {d}\), 
    \(ListXi\  = \ {}\), 
    \(ListPhi\  = \ {}\), 
    \(ListXi\  = 
      \ {k5\  - \ 2*d*k2*t\  + \ k6*x\  + \ k4*t*x, \ 
        k3\  + \ t*\((2*k6\  + \ k4*t)\)}\), 
    \(ListPhi\  = 
      \ {\((k1\  - \ \((k4*t)\)/2\  + \ k2*x\  - \ \((k4*x^2)\)/\((4*d)\))\)*
            u[x, \ t]\  + \ \(free[1]\)[x, \ t]}\), 
    \(ListEquations\  = \ \n
      \ \ {\(-\((\(\(Derivative[0, \ 1]\)[free[1]]\)[x, \ t]/d)\)\)\  + \ 
          \(\(Derivative[2, \ 0]\)[free[1]]\)[x, \ t]}\)}], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  FontSize->9]
}, Open  ]],

Cell[TextData[{
  "In addition to the two augmented lists ",
  StyleBox["ListXi", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ", "MmaText"],
  "and ",
  StyleBox["ListPhi", "MmaText",
    FontSlant->"Italic"],
  StyleBox[", ", "MmaText"],
  "the file contains a new variable ",
  StyleBox["ListEquations", "MmaText",
    FontSlant->"Italic"],
  " storing the unsolved equations. After the application of ",
  StyleBox["Lie[]", "MmaText"],
  " and ",
  StyleBox["LieSolve[]", "MmaText"],
  " to the heat equation, we created an information basis on the symmetries \
of the equation. The symmetries of the heat equation are presented by \
constants ",
  StyleBox["k1", "MmaText",
    FontSlant->"Italic"],
  " to ",
  StyleBox["k6", "MmaText",
    FontSlant->"Italic"],
  " and by the arbitrary function ",
  StyleBox["free[1]", "MmaText",
    FontSlant->"Italic"],
  ". We can independently check the gained information to verify the \
invariance of the heat equation. Again, we apply function Lie[] in connection \
with the option ",
  StyleBox["Info\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  ". The application of ",
  StyleBox["Lie[]", "MmaText"],
  " to ",
  StyleBox["heat.dgl", "MmaText",
    FontSlant->"Italic"],
  " in connection with the option ",
  StyleBox["Info\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "gives us"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<heat.dgl\>", Info \[Rule] True] // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\((\[ScriptCapitalF]\_1)\)\_t - 
                d\ \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Lie[] ", "MmaText"],
  "takes the information on the infinitesimals and carries out the \
calculation of a symmetry analysis. In the last step of the calculation, the \
infinitesimals are inserted into the determining equations. The result shows \
that the original equation must be satisfied by the arbitrary function",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[ScriptCapitalF]\_1\),
            "TraditionalForm"], "=", 
          StyleBox[\(free[1]\),
            FontSlant->"Italic"]}], TraditionalForm]], "MmaText"],
  ". It is essential for this example that the check reproduces the heat \
equation; otherwise, there would exist an error in the calculation. We note \
that for other equations the result may be an empty list, especially if the \
equation is a non-linear one. We also note that the check of the results is \
completely independent of the solution procedure used by ",
  StyleBox["LieSolve[]", "MmaText"],
  ". Thus, we have an independent tool allowing us to examine the results of  \
",
  StyleBox["LieSolve[]", "MmaText"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"Lie[]", "arbitrary function", "heat equation"}],

Cell["Example 2", "Example"],

Cell[TextData[{
  "Let us demonstrate the whole procedure of deriving the symmetries for \
another example. Closely related to the heat equation is the so-called \
non-linear filtration equation (",
  ButtonBox["Ibragimov [1994]",
    ButtonData:>{"Literat.nb", "Ibra-949596"},
    ButtonStyle->"Hyperlink"],
  "). The equation of motion is given for a field ",
  Cell[BoxData[
      \(TraditionalForm\`u = u(x, t)\)]],
  " by"
}], "Text",
  Evaluatable->False,
  CellTags->"nonlinear filtration equation"],

Cell[BoxData[
    \(TraditionalForm\`\(u\_t\  - \(k(u\_x)\)\ u\_\(x, x\) = \ 0, \)\)], 
  "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`k(u\_x)\)]],
  " is an arbitrary function of ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x\)]],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s notation, the left-hand side of the equation reads"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(filtration = {
        \[PartialD]\_t u[x, t] - 
          k[\[PartialD]\_x u[x, t]]\ \[PartialD]\_{x, 2}u[x, t]}; 
    filtration // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - k\ u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
We suppressed the right-hand side of the equation and collected the \
left-hand side in a list. The file containing the information on this \
equation is created by\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(LieEquations["\<filtra.dgl\>", 
      filtration, {u}, {x, 
        t}, {}, \n{"\<Nonlinear Filtration Equation\>"}, \n{{"\<I.Sh. \
Akhatov, R.K. Gazizov and N.H. Ibragimov\>"}, \n{"\<Group classification of \
nonlinear filtration equations\>"}, \n{"\<Soviet Math. Dokl. 35, 384, \
1987\>"}, \n{"\<The equation is listed in the CRC Handbook
of Lie Group Analysis of Differential Equations\>"}, \n\t\t{"\<Vol. 1, \
Chapter 10.3, p. 129\>"}, \n\t\t{"\<Ed. N.H. Ibragimov\>"}, \n\t\t{"\<Boca \
Raton 1994\>"}}]\)], "Input",
  PageWidth->Infinity,
  CellTags->"LieEquations[]"],

Cell["The symmetries of this equation follow by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solfilt = LieSolve["\<filtra.dgl\>"]\)], "Input",
  PageWidth->Infinity,
  CellTags->"LieSolve[]"],

Cell[BoxData[
    \({{xi[1] \[Rule] Function[{x, t, u}, k2 + \(k4\ x\)\/2], 
        xi[2] \[Rule] Function[{x, t, u}, k3 + k4\ t], 
        phi[1] \[Rule] Function[{x, t, u}, k1 + \(k4\ u\)\/2]}, {}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is isomorphic to the result given by ",
  ButtonBox["Ibragimov [1994]",
    ButtonData:>{"Literat.nb", "Ibra-949596"},
    ButtonStyle->"Hyperlink"],
  " representing translations and scaling. Since the filtration equation is a \
non-linear PDE, we actually do not expect that arbitrary functions occur in \
the infinitesimals. However, there exists quite a number of non-linear \
examples for which the symmetry group is of infinite order and thus contains \
arbitrary functions. These functions are usually restricted by one or more \
PDEs which are different from the original equation."
}], "Text",
  Evaluatable->False,
  CellTags->{"translation", "scaling"}],

Cell[TextData[{
  "If we know the symmetries, we can use another function of ",
  StyleBox["MathLie,",
    FontSlant->"Italic"],
  " called ",
  StyleBox["LieStructureForm[]", "MmaText"],
  ", to derive the algebraic properties of the related Lie algebra. We get \
the structural properties of the algebra and the transformation properties \
by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "LieStructureForm[]", "Lie algebra", "structural properties", 
    "transformation properties"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieStructureForm["\<filtra.dgl\>"]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[{
  "\<\"We will check the infinitesimals and calculate algebraic\"\>", 
  "\<\"as well as group properties\"\>", 
  "\<\" +--------------------------------------------+\"\>", 
  "\<\"  Welcome to MathLie\[Trademark]\"\>", 
  "\<\"  for the calculation of the symmetry group\"\>", 
  \("  by"\ \ G . \ Baumann, \ \[Copyright]\ 1992 - 1999\), 
  "\<\" +--------------------------------------------+\"\>", 
    InterpretationBox[
      \("Loading previous calculations of the determining equations from  "\
\[InvisibleSpace]"FILTRA.DEQ"\),
      SequenceForm[ 
      "Loading previous calculations of the determining equations from  ", 
        "FILTRA.DEQ"],
      Editable->False]}], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{
    InterpretationBox[\("Loading data from  "\[InvisibleSpace]"FILTRA.DGL"\),
      SequenceForm[ "Loading data from  ", "FILTRA.DGL"],
      Editable->False], "\<\"Title of the equations:\"\>", 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"Nonlinear Filtration Equation\"\>", 
  "\<\"Source of the equations:\"\>", 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"I.Sh. Akhatov, R.K. Gazizov and N.H. Ibragimov\"\>", 
  "\<\"Group classificatin of nonlinear filtration equations\"\>", 
  "\<\"Soviet Math. Dokl. 35, 384, 1987\"\>", 
  "\<\"The equation is listed in the CRC Handbook of Lie Group\:f39fAnalysis \
of Differential Equations\"\>", "\<\"Vol. 1, Chapter 10.3, p. 129\"\>", 
  "\<\"Ed. N.H. Ibragimov\"\>", "\<\"Boca Raton 1994\"\>"}], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{"\<\"Equations of motion:\"\>", 
  "\<\"------------------------------------------------------\"\>", 
    InterpretationBox[\("Equation No. "\[InvisibleSpace]1\),
      SequenceForm[ "Equation No. ", 1],
      Editable->False], 
    RowBox[{
      RowBox[{
        InterpretationBox[\(u\_t\),
          Subscripted[ 
            u[ t]],
          Editable->False], "-", 
        RowBox[{
          RowBox[{"k", "[", 
            InterpretationBox[\(u\_x\),
              Subscripted[ 
                u[ x]],
              Editable->False], "]"}], " ", 
          InterpretationBox[\(u\_\(x, x\)\),
            Subscripted[ 
              u[ x, x]],
            Editable->False]}]}], "==", "0"}], 
  "\<\"------------------------------------------------------\"\>", 
    InterpretationBox[\("Substitution No. "\[InvisibleSpace]1\),
      SequenceForm[ "Substitution No. ", 1],
      Editable->False], 
    RowBox[{
      InterpretationBox[\(u\_t\),
        Subscripted[ 
          u[ t]],
        Editable->False], "\[Rule]", 
      RowBox[{
        RowBox[{"k", "[", 
          InterpretationBox[\(u\_x\),
            Subscripted[ 
              u[ x]],
            Editable->False], "]"}], " ", 
        InterpretationBox[\(u\_\(x, x\)\),
          Subscripted[ 
            u[ x, x]],
          Editable->False]}]}], 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"Infinitesimals :\"\>", 
    InterpretationBox[
      \("  Xi"\[InvisibleSpace]1
        \[InvisibleSpace]" = "\[InvisibleSpace]\(k2 + \(k4\ x\)\/2\)\),
      SequenceForm[ "  Xi", 1, " = ", 
        Plus[ k2, 
          Times[ 
            Rational[ 1, 2], k4, x]]],
      Editable->False], 
    InterpretationBox[
      \("  Xi"\[InvisibleSpace]2
        \[InvisibleSpace]" = "\[InvisibleSpace]\(k3 + k4\ t\)\),
      SequenceForm[ "  Xi", 2, " = ", 
        Plus[ k3, 
          Times[ k4, t]]],
      Editable->False], 
    InterpretationBox[
      \("  Phi"\[InvisibleSpace]1
        \[InvisibleSpace]" = "\[InvisibleSpace]\(k1 + 1\/2\ k4\ u[x, t]\)\),
      SequenceForm[ "  Phi", 1, " = ", 
        Plus[ k1, 
          Times[ 
            Rational[ 1, 2], k4, 
            u[ x, t]]]],
      Editable->False], 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"We are using all the equation(s) checking the infinitesimals\"\>", 
    InterpretationBox[
      \("of the given system consisting of "\[InvisibleSpace]1
        \[InvisibleSpace]" equation(s) in total."\),
      SequenceForm[ 
      "of the given system consisting of ", 1, " equation(s) in total."],
      Editable->False]}], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{
    \("We have to treat 0 determining equations after simplification."\), 
    \("Calculation of the commutator table of the Lie algebra."\)}], "Output",\

  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{"\<\"Basis of the Lie algebra.\"\>", 
  "\<\"------------------------------------------------------\"\>", 
    RowBox[{
      InterpretationBox[\(v\_1\),
        Subscripted[ 
          v[ 1]],
        Editable->False], "==", 
      InterpretationBox[\("\[Eth]"\_u\),
        Subscripted[ 
          "\[Eth]"[ u]],
        Editable->False]}], 
    RowBox[{
      InterpretationBox[\(v\_2\),
        Subscripted[ 
          v[ 2]],
        Editable->False], "==", 
      InterpretationBox[\("\[Eth]"\_x\),
        Subscripted[ 
          "\[Eth]"[ x]],
        Editable->False]}], 
    RowBox[{
      InterpretationBox[\(v\_3\),
        Subscripted[ 
          v[ 3]],
        Editable->False], "==", 
      InterpretationBox[\("\[Eth]"\_t\),
        Subscripted[ 
          "\[Eth]"[ t]],
        Editable->False]}], 
    RowBox[{
      InterpretationBox[\(v\_4\),
        Subscripted[ 
          v[ 4]],
        Editable->False], "==", 
      RowBox[{
        RowBox[{"t", " ", 
          InterpretationBox[\("\[Eth]"\_t\),
            Subscripted[ 
              "\[Eth]"[ t]],
            Editable->False]}], "+", 
        FractionBox[
          RowBox[{"u", " ", 
            InterpretationBox[\("\[Eth]"\_u\),
              Subscripted[ 
                "\[Eth]"[ u]],
              Editable->False]}], "2"], "+", 
        FractionBox[
          RowBox[{"x", " ", 
            InterpretationBox[\("\[Eth]"\_x\),
              Subscripted[ 
                "\[Eth]"[ x]],
              Editable->False]}], "2"]}]}], 
  "\<\"------------------------------------------------------\"\>"}], "Output",\

  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{"\<\"Structure of the Lie algebra.\"\>", 
  "\<\"------------------------------------------------------\"\>", 
    InterpretationBox[
      RowBox[{
      "\<\"Ideal \"\>", "\[InvisibleSpace]", "0", "\[InvisibleSpace]", 
        "\<\" :  \"\>", "\[InvisibleSpace]", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(v\_1\),
              Subscripted[ 
                v[ 1]],
              Editable->False], ",", 
            InterpretationBox[\(v\_2\),
              Subscripted[ 
                v[ 2]],
              Editable->False], ",", 
            InterpretationBox[\(v\_3\),
              Subscripted[ 
                v[ 3]],
              Editable->False], ",", 
            InterpretationBox[\(v\_4\),
              Subscripted[ 
                v[ 4]],
              Editable->False]}], "}"}]}],
      SequenceForm[ "Ideal ", 0, " :  ", {
        Subscripted[ 
          v[ 1]], 
        Subscripted[ 
          v[ 2]], 
        Subscripted[ 
          v[ 3]], 
        Subscripted[ 
          v[ 4]]}],
      Editable->False], 
    InterpretationBox[
      RowBox[{
      "\<\"Ideal \"\>", "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        "\<\" :  \"\>", "\[InvisibleSpace]", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(v\_1\),
              Subscripted[ 
                v[ 1]],
              Editable->False], ",", 
            InterpretationBox[\(v\_2\),
              Subscripted[ 
                v[ 2]],
              Editable->False], ",", 
            InterpretationBox[\(v\_3\),
              Subscripted[ 
                v[ 3]],
              Editable->False]}], "}"}]}],
      SequenceForm[ "Ideal ", 1, " :  ", {
        Subscripted[ 
          v[ 1]], 
        Subscripted[ 
          v[ 2]], 
        Subscripted[ 
          v[ 3]]}],
      Editable->False], 
    InterpretationBox[
      \("Ideal "\[InvisibleSpace]2
        \[InvisibleSpace]" :  "\[InvisibleSpace]{"solvable algebra"}\),
      SequenceForm[ "Ideal ", 2, " :  ", {"solvable algebra"}],
      Editable->False], 
  "\<\"------------------------------------------------------\"\>"}], "Output",\

  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[{"\<\"Casimier(s) of the Lie algebra.\"\>", 
    InterpretationBox[\("  "\[InvisibleSpace]{}\),
      SequenceForm[ "  ", {}],
      Editable->False], 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"Commutator table of the Lie algebra.\"\>", 
  "\<\"------------------------------------------------------\"\>", 
    InterpretationBox[
      RowBox[{"\<\"  \"\>", "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "0", "0", 
                  RowBox[{"-", 
                    FractionBox[
                      InterpretationBox[\(v\_1\),
                        Subscripted[ 
                          v[ 1]],
                        Editable->False], "2"]}]},
                {"0", "0", "0", 
                  RowBox[{"-", 
                    FractionBox[
                      InterpretationBox[\(v\_2\),
                        Subscripted[ 
                          v[ 2]],
                        Editable->False], "2"]}]},
                {"0", "0", "0", 
                  RowBox[{"-", 
                    InterpretationBox[\(v\_3\),
                      Subscripted[ 
                        v[ 3]],
                      Editable->False]}]},
                {
                  FractionBox[
                    InterpretationBox[\(v\_1\),
                      Subscripted[ 
                        v[ 1]],
                      Editable->False], "2"], 
                  FractionBox[
                    InterpretationBox[\(v\_2\),
                      Subscripted[ 
                        v[ 2]],
                      Editable->False], "2"], 
                  InterpretationBox[\(v\_3\),
                    Subscripted[ 
                      v[ 3]],
                    Editable->False], "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "  ", 
        MatrixForm[ {{0, 0, 0, 
          Times[ 
            Rational[ -1, 2], 
            Subscripted[ 
              v[ 1]]]}, {0, 0, 0, 
          Times[ 
            Rational[ -1, 2], 
            Subscripted[ 
              v[ 2]]]}, {0, 0, 0, 
          Times[ -1, 
            Subscripted[ 
              v[ 3]]]}, {
          Times[ 
            Rational[ 1, 2], 
            Subscripted[ 
              v[ 1]]], 
          Times[ 
            Rational[ 1, 2], 
            Subscripted[ 
              v[ 2]]], 
          Subscripted[ 
            v[ 3]], 0}}]],
      Editable->False], 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"The commutator table is stored in list LieTable.\"\>", 
  "\<\"The nonzero structure constants are\"\>", 
  "\<\"------------------------------------------------------\"\>", 
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(C\_\(1, 4, 1\)\),
          Subscripted[ 
            C[ 1, 4, 1]],
          Editable->False], "\[InvisibleSpace]", "\<\" = \"\>", 
        "\[InvisibleSpace]", \(-\(1\/2\)\)}],
      SequenceForm[ 
        Subscripted[ 
          C[ 1, 4, 1]], " = ", 
        Rational[ -1, 2]],
      Editable->False], 
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(C\_\(2, 4, 2\)\),
          Subscripted[ 
            C[ 2, 4, 2]],
          Editable->False], "\[InvisibleSpace]", "\<\" = \"\>", 
        "\[InvisibleSpace]", \(-\(1\/2\)\)}],
      SequenceForm[ 
        Subscripted[ 
          C[ 2, 4, 2]], " = ", 
        Rational[ -1, 2]],
      Editable->False], 
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(C\_\(3, 4, 3\)\),
          Subscripted[ 
            C[ 3, 4, 3]],
          Editable->False], "\[InvisibleSpace]", "\<\" = \"\>", 
        "\[InvisibleSpace]", \(-1\)}],
      SequenceForm[ 
        Subscripted[ 
          C[ 3, 4, 3]], " = ", -1],
      Editable->False], 
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(C\_\(4, 1, 1\)\),
          Subscripted[ 
            C[ 4, 1, 1]],
          Editable->False], "\[InvisibleSpace]", "\<\" = \"\>", 
        "\[InvisibleSpace]", \(1\/2\)}],
      SequenceForm[ 
        Subscripted[ 
          C[ 4, 1, 1]], " = ", 
        Rational[ 1, 2]],
      Editable->False], 
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(C\_\(4, 2, 2\)\),
          Subscripted[ 
            C[ 4, 2, 2]],
          Editable->False], "\[InvisibleSpace]", "\<\" = \"\>", 
        "\[InvisibleSpace]", \(1\/2\)}],
      SequenceForm[ 
        Subscripted[ 
          C[ 4, 2, 2]], " = ", 
        Rational[ 1, 2]],
      Editable->False], 
    InterpretationBox[
      RowBox[{
        InterpretationBox[\(C\_\(4, 3, 3\)\),
          Subscripted[ 
            C[ 4, 3, 3]],
          Editable->False], "\[InvisibleSpace]", "\<\" = \"\>", 
        "\[InvisibleSpace]", "1"}],
      SequenceForm[ 
        Subscripted[ 
          C[ 4, 3, 3]], " = ", 1],
      Editable->False], 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"Structure constants are contained in the list LieStructure.\"\>", 
  "\<\"Metric of the structure constants\"\>", 
    InterpretationBox[
      RowBox[{"\<\"g_{ij} =      \"\>", "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "0", "0", "0"},
                {"0", "0", "0", "0"},
                {"0", "0", "0", "0"},
                {"0", "0", "0", \(3\/2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "g_{ij} =      ", 
        MatrixForm[ {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
          Rational[ 3, 2]}}]],
      Editable->False], "\<\"Determinant of the metric\"\>", 
    InterpretationBox[\("det(g) = "\[InvisibleSpace]0\),
      SequenceForm[ "det(g) = ", 0],
      Editable->False], 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"Calculate the symmetry groups of the transformations\"\>", 
  "\<\"------------------------------------------------------\"\>", 
    InterpretationBox[\(" Xi(1) = "\[InvisibleSpace]\(k2 + \(k4\ x\)\/2\)\),
      SequenceForm[ " Xi(1) = ", 
        Plus[ k2, 
          Times[ 
            Rational[ 1, 2], k4, x]]],
      Editable->False], 
    InterpretationBox[\(" Xi(2) = "\[InvisibleSpace]\(k3 + k4\ t\)\),
      SequenceForm[ " Xi(2) = ", 
        Plus[ k3, 
          Times[ k4, t]]],
      Editable->False], 
    InterpretationBox[
      \(" Phi(1) = "\[InvisibleSpace]\(k1 + 1\/2\ k4\ u[x, t]\)\),
      SequenceForm[ " Phi(1) = ", 
        Plus[ k1, 
          Times[ 
            Rational[ 1, 2], k4, 
            u[ x, t]]]],
      Editable->False], 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"Group order = 4\"\>", "\<\"Number of classes = 15\"\>", 
  "\<\"------------------------------------------------------\"\>", 
  "\<\"The subgroups and the related transformations read \"\>", 
  "\<\"------------------------------------------------------\"\>", 
  \({k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 1}\), 
  \(x[s] == {x[s], t[s], u[s]}\), 
  \(t[s] == {x[s] \[Rule] \((E\^\(s/2\)\ C[3]&)\), 
        t[s] \[Rule] \((E\^s\ C[1]&)\), u[s] \[Rule] \((E\^\(s/2\)\ C[2]&)\)}
        \), \(u[s] == {{}}\), 
  "\<\"------------------------------------------------------\"\>", 
  \({k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1, k4 \[Rule] 0}\), 
  \(x[s] == {x[s], t[s], u[s]}\), 
  \(t[s] == {x[s] \[Rule] \((C[3]&)\), t[s] \[Rule] \((C[1] + s&)\), 
        u[s] \[Rule] \((C[2]&)\)}\), \(u[s] == {{}}\), 
  "\<\"------------------------------------------------------\"\>", 
  \({k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1, k4 \[Rule] 1}\), 
  \(x[s] == {x[s], t[s], u[s]}\), 
  \(t[s] == {x[s] \[Rule] \((E\^\(s/2\)\ C[3]&)\), 
        t[s] \[Rule] \((\(-1\) + E\^s\ C[1]&)\), 
        u[s] \[Rule] \((E\^\(s/2\)\ C[2]&)\)}\), \(u[s] == {{}}\), 
  "\<\"------------------------------------------------------\"\>", 
    RowBox[{" ", 
      \(To\ save\ space\ the\ rest\ of\ the\ output\ was\ 
        deleted\  . \n
          "------------------------------------------------------"\)}], 
  "\<\"There exist no transformations creating new solutions.\"\>", 
  "\<\"Results are collected in the list FinalResult.\"\>", 
  "\<\"The infinitesimals are contained in Result2.\"\>", \({}\)}], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[TextData[{
  "The function actually does not return any result for further use. However, \
the function prints out the result shown on the screen. As a first result, we \
get the algebraic properties based on the vector fields of the symmetry \
group. The commutator table of the vector fields is followed by a number of \
group transformations based on subgroups of the symmetry. The subgroup is \
specified by replacement rules setting the values of the group parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k\_i\)]],
  ". Transformations for the dependent and independent variables are given in \
a most general form. If the classification of the group allows a \
transformation of known solutions to other solutions of the equation, a \
graphical representation of this transformation is created.\[ThickSpace]\
\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"commutator table", "vector field", "group transformations"}],

Cell["Example 3 ", "Example"],

Cell[TextData[{
  "One of the frequently used partial differential equations in the \
description of non-linear phenomena in physics is the Burgers equation. \
Writing down the equation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", let us first define the field ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " by"
}], "Text",
  CellTags->"Burgers equation"],

Cell[BoxData[
    \(\(U = u[x, t]; \)\)], "Input"],

Cell["The left-hand side of the Burgers equation is given by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(burgers = {
        \[PartialD]\_t U + 2\ U\ \[PartialD]\_x U - \[PartialD]\_{x, 2}U}; 
    burgers // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t + 2\ u\ u\_x - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The physical background and the important solutions are discussed by ",
  ButtonBox["Lighthill [1956]",
    ButtonData:>{"Literat.nb", "Ligh-56"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Crighton [1979]",
    ButtonData:>{"Literat.nb", "Crig-79"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["\<\
The well-known Cole-Hopf transformation converts the Burgers \
equation to the linear diffusion equation. Hence, the solution for the former \
can be explicitly obtained by solving the linear problem of the diffusion \
equation. Our intention here is to find the symmetries of the Burgers \
equation for the standard representation given above.\
\>", "Text",
  CellTags->{
  "Cole-Hopf transformation", "diffusion equation", 
    "symmetries of the Burgers equation"}],

Cell["\<\
Derivation of the symmetries as a part of our database system \
presumes that first we have to create the information file for the Burgers \
equation. The representation of the Burgers equation given above was taken \
from\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(source = {{"\<M.J. Ablowitz and P.A. Clarkson\>"}, \n
        \t\t{"\<Solitons, Nonlinear Evolution Equations and Inverse \
Scattering\>"}, \n\t\t{"\<Cambridge University Press, 1991\>"}, \n
        \t\t{"\<first equation on page 34\>"}}\)], "Input"],

Cell[BoxData[
    \({{"M.J. Ablowitz and P.A. Clarkson"}, {
        "Solitons, Nonlinear Evolution Equations and Inverse Scattering"}, {
        "Cambridge University Press, 1991"}, {"first equation on page 34"}}
      \)], "Output"]
}, Open  ]],

Cell["We set the title of the equation to", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(title = {"\<Burgers equation\>"}\)], "Input"],

Cell[BoxData[
    \({"Burgers equation"}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The file ",
  StyleBox["burgers.dgl ",
    FontSlant->"Italic"],
  "is then created by"
}], "Text"],

Cell[BoxData[
    \(LieEquations["\<burgers.dgl\>", burgers, {u}, {x, t}, {}, title, source]
      \)], "Input"],

Cell["The derivation of the determining equations is pursued by", "Text",
  CellTags->"determining equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(burgersDetEquations\  = \ 
      Lie["\<burgers.dgl\>", Statistics \[Rule] True]; 
    burgersDetEquations // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u == 0\)},
          {\(\((\[Xi]\_2)\)\_u == 0\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\) == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(2\ \[Phi]\_1 - \((\[Xi]\_1)\)\_t - 2\ u\ \((\[Xi]\_1)\)\_x + 
                2\ u\ \((\[Xi]\_2)\)\_t + \((\[Xi]\_1)\)\_\(x, x\) - 
                2\ \((\[Phi]\_1)\)\_\(x, u\) == 0\)},
          {
            \(\((\[Phi]\_1)\)\_t + 2\ u\ \((\[Phi]\_1)\)\_x - 
                \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {\(2\ \((\[Xi]\_1)\)\_x - \((\[Xi]\_2)\)\_t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 1], u], 0], 
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 2], u], 0], 
        Equal[ 
          Subscript[ 
            Subscript[ \[Phi], 1], u, u], 0], 
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 2], x], 0], 
        Equal[ 
          Plus[ 
            Times[ 2, 
              Subscript[ \[Phi], 1]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[Xi], 1], t]], 
            Times[ -2, u, 
              Subscript[ 
                Subscript[ \[Xi], 1], x]], 
            Times[ 2, u, 
              Subscript[ 
                Subscript[ \[Xi], 2], t]], 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x], 
            Times[ -2, 
              Subscript[ 
                Subscript[ \[Phi], 1], x, u]]], 0], 
        Equal[ 
          Plus[ 
            Subscript[ 
              Subscript[ \[Phi], 1], t], 
            Times[ 2, u, 
              Subscript[ 
                Subscript[ \[Phi], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[Phi], 1], x, x]]], 0], 
        Equal[ 
          Plus[ 
            Times[ 2, 
              Subscript[ 
                Subscript[ \[Xi], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[Xi], 2], t]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, the result of this calculation is a system of linear coupled \
partial differential equations. These equations are the basis for the \
determination of the symmetries. Before we attempt to solve these equations, \
we discuss another representation of the Burgers equation which follows from \
the above if we replace the dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " by the gradient of a field ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ". We define this substitution by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(subst = u \[Rule] Function[{x, t}, \[PartialD]\_x v[x, t]]\)], "Input"],

Cell[BoxData[
    \(u \[Rule] Function[{x, t}, \[PartialD]\_x v[x, t]]\)], "Output"]
}, Open  ]],

Cell["and apply this transformation to the Burgers equation", "Text",
  CellTags->"potential Burgers equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(burgersx = burgers /. subst; burgersx // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(v\_\(x, t\) + 2\ v\_x\ v\_\(x, x\) - v\_\(x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a third-order non-linear PDE for the field ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ". Integrating this equation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", we obtain a potential representation of the Burgers equation:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pburgers = 
      \[Integral]burgersx\[LeftDoubleBracket]1\[RightDoubleBracket] 
          \[DifferentialD]x; pburgers // \ LTF\)], "Input",
  CellTags->"potential Burgers equation"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(v\_t + v\_x\%2 - v\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This sort of equation was examined by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["\<\
In the following, we will show how group properties of the \
potential representation differ from the original representation of the \
Burgers equation. Let us again extend our database by a new file containing \
the information on the potential Burgers equation. We create a file for the \
potential Burgers equation by\
\>", "Text",
  CellTags->"potential Burgers equation"],

Cell[BoxData[
    \(LieEquations["\<burgersp.dgl\>", pburgers, {v}, {x, t}, {}, \n
      \t{"\<Burgers equation\>"}, {{"\<G. Baumann\>"}, \n
        \t\t{"\<Burgers equation in potential form\>"}, {"\<Ulm 1997\>"}}]
      \)], "Input"],

Cell["The corresponding determining equations follow by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lie["\<burgersp.dgl\>"] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_v == 0\)},
          {\(\((\[Xi]\_2)\)\_v == 0\)},
          {\(\((\[Xi]\_2)\)\_x == 0\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + 2\ \((\[Phi]\_1)\)\_x + 
                \((\[Xi]\_1)\)\_\(x, x\) - 2\ \((\[Phi]\_1)\)\_\(x, v\) == 0
              \)},
          {\(\((\[Phi]\_1)\)\_t - \((\[Phi]\_1)\)\_\(x, x\) == 0\)},
          {\(2\ \((\[Xi]\_1)\)\_x - \((\[Xi]\_2)\)\_t == 0\)},
          {
            \(\(-2\)\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_2)\)\_t + 
                \((\[Phi]\_1)\)\_v - \((\[Phi]\_1)\)\_\(v, v\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 1], v], 0], 
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 2], v], 0], 
        Equal[ 
          Subscript[ 
            Subscript[ \[Xi], 2], x], 0], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[Xi], 1], t]], 
            Times[ 2, 
              Subscript[ 
                Subscript[ \[Phi], 1], x]], 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x], 
            Times[ -2, 
              Subscript[ 
                Subscript[ \[Phi], 1], x, v]]], 0], 
        Equal[ 
          Plus[ 
            Subscript[ 
              Subscript[ \[Phi], 1], t], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[Phi], 1], x, x]]], 0], 
        Equal[ 
          Plus[ 
            Times[ 2, 
              Subscript[ 
                Subscript[ \[Xi], 1], x]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[Xi], 2], t]]], 0], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ 
                Subscript[ \[Xi], 1], x]], 
            Subscript[ 
              Subscript[ \[Xi], 2], t], 
            Subscript[ 
              Subscript[ \[Phi], 1], v], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[Phi], 1], v, v]]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "A comparison of the results shows that in both calculations, the number of \
equations are the same. However, the seven equations differ in their forms. \
Consequently, the structure of the symmetries is different. We can illustrate \
this by using the function ",
  StyleBox["LieSolve[]", "MmaText"],
  " of the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The function ",
  StyleBox["LieSolve[]", "MmaText"],
  " provides us with the representation of the symmetries in infinitesimal \
form. The infinitesimals of the Burgers equation thus follow by"
}], "Text",
  CellTags->{"LieSolve[]", "infinitesimals of the Burgers equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(iburgers = LieSolve["\<burgers.dgl\>"]\)], "Input"],

Cell[BoxData[
    \({{xi[1] \[Rule] Function[{x, t, u}, k2 + k4\ t + \((k3 + k5\ t)\)\ x], 
        xi[2] \[Rule] Function[{x, t, u}, k1 + t\ \((2\ k3 + k5\ t)\)], 
        phi[1] \[Rule] 
          Function[{x, t, u}, 
            1\/2\ \((k4 - 2\ \((k3 + k5\ t)\)\ u + k5\ x)\)]}, {}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a list containing the infinitesimals in a pure function \
representation. The first two elements ",
  StyleBox["xi[1]",
    FontSlant->"Italic"],
  " and ",
  StyleBox["xi[2]",
    FontSlant->"Italic"],
  " of the list represent the infinitesimals for the independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", respectively. The third element, ",
  StyleBox["phi[1]",
    FontSlant->"Italic"],
  ", is the infinitesimal for the dependent variable. Among the \
five-dimensional symmetry group are symmetries of translation and scaling. \
The infinitesimals for the potential Burgers equation follow by a similar \
calculation from"
}], "Text",
  CellTags->"infinitesimals for the potential Burgers equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(iburgersp = LieSolve["\<burgersp.dgl\>"]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({xi[1] \[Rule] 
            Function[{x, t, v}, k2 + 2\ k5\ t + \((k3 + 4\ k6\ t)\)\ x], 
          xi[2] \[Rule] Function[{x, t, v}, k1 + 2\ t\ \((k3 + 2\ k6\ t)\)], 
          phi[1] \[Rule] 
            Function[{x, t, v}, 
              k4 + 2\ k6\ t + k5\ x + k6\ x\^2 + E\^v\ \(free[1]\)[x, t]]}\), 
        ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                SuperscriptBox[\(free[1]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "+", 
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}]}], "}"}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing both results, we recognize that the symmetry structure of the \
original Burgers equation and the potential representation of the Burgers \
equation are the same for the infinitesimals of the independent variables. \
The structure of the dependent variables is completely different. In the case \
of the Burgers equation, we find a finite dimensional representation of the \
symmetry group, whereas in the potential representation, we get an infinite \
dimensional group characterized by the arbitrary function ",
  StyleBox["free[1][x,t]",
    FontSlant->"Italic"],
  ". This arbitrary function has to satisfy the heat equation as an \
additional equation. The last list of the result contains this equation. The \
discrete part of the symmetry group of the potential Burgers equation is also \
extended by one degree to a six-dimensional symmetry group.\[ThickSpace]\
\[EmptySquare]"
}], "Text",
  CellTags->{"Burgers equation", "infinite dimensional group"}],

Cell[TextData[{
  "In physical applications, however, the model equations often turn out to \
be more complicated than the Burgers equation, involving as they do, a \
geometrical expansion term, a non-linear damping term, or a more general \
convection term. In the following, we will examine the influence of this \
change on the symmetries if the convection term in the original equation is \
altered. The convective extension of the Burgers equation is obtained by \
replacing ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x\)]],
  " with ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(u\^2\) u\_x\),
          "InlineFormula"], TraditionalForm]]],
  ". This quadratic extension is sometimes called ",
  StyleBox["generalized Burgers equation",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{
  "convective extension of the Burgers equation", 
    "generalized Burgers equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(burgersc = {
        \[PartialD]\_t U + U\^2\ \[PartialD]\_x U - \[PartialD]\_{x, 2}U}; 
    burgersc // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t + u\^2\ u\_x - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "For a quick overview of the changes in the symmetries, we take advantage \
of the interactive function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  ". Application of this function to the equation can also be used to create \
a database if the related notebook is considered the basic part of the data \
system. The advantage of this view is that the complete information on an \
equation is collected in one file and that background information which is \
not necessary for a symmetry analysis can also be collected in the notebook. \
The determination of the symmetries for this generalized equation is carried \
out by "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(iburgersc = Infinitesimals[burgersc, {u}, {x, t}]\)], "Input"],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t, u}, k1 + \(k3\ x\)\/2], 
      xi[2] \[Rule] Function[{x, t, u}, k2 + k3\ t], 
      phi[1] \[Rule] Function[{x, t, u}, \(-\(\(k3\ u\)\/4\)\)]}\)], "Output"]
}, Open  ]],

Cell["\<\
The result shows that the symmetry group of the generalized Burgers \
equation is reduced from a six-dimensional to a three-dimensional group \
containing only translations in the independent variables and a scaling.\
\>",
   "Text",
  CellTags->"symmetry group of the generalized Burgers equation"],

Cell[TextData[{
  "We recognize now that classification of the group of differential \
equations is an easy task. For example, the group structure of the Burgers \
equation with generalized convection term ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(u\^m\) u\_x\),
          "InlineFormula"], TraditionalForm]]],
  " is analyzed by"
}], "Text",
  CellTags->"Burgers equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Infinitesimals[{
        \[PartialD]\_t U + U\^m\ \[PartialD]\_x U - \[PartialD]\_{x, 2}U}, {
        u}, {x, t}, {m}]\)], "Input",
  PageBreakBelow->False],

Cell[BoxData[
    \({xi[1] \[Rule] Function[{x, t, u}, k1 + \(k3\ x\)\/2], 
      xi[2] \[Rule] Function[{x, t, u}, k2 + k3\ t], 
      phi[1] \[Rule] Function[{x, t, u}, \(-\(\(k3\ u\)\/\(2\ m\)\)\)]}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " is an arbitrary constant. The result demonstrates that for an arbitrary ",
  
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", the symmetry group is of the same structure as for the generalized \
Burgers equation with quadratic convection term. The difference between the \
two results is the dependence of ",
  StyleBox["phi[1]", "MmaText",
    FontSlant->"Italic"],
  " on the parameter ",
  Cell[BoxData[
      FormBox[
        StyleBox["m",
          "MmaText"], TraditionalForm]]],
  ". This result displays that the function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  " is capable of handling not only the specific models of the Burgers \
equation but also a model depending on an arbitrary parameter."
}], "Text",
  CellTags->"Infinitesimals[]"],

Cell[TextData[{
  "Concluding this section, we can state that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can be used to collect information on symmetries in different ways: \
first, creation of a file system containing information essential for each \
equation; second, by creating notebooks that allow detailed discussion of the \
equation. Both methods will be used in the remaining parts of this book."
}], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Reductio.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{696, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->220,
PrintingPageRange->{245, 246},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Introduction", "Lie's Theory Used in MathLie", 
                "Invariance Based on Fr\[EAcute]chet Derivatives", 
                "Application of the Theory"}, #]&)], FontSlant -> "Italic"], 
          "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageFooters->{{Inherited, None, Inherited}, {Inherited, None, Inherited}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ScriptMinSize->5,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Point Symmetries of Partial Differential Equations"->{
    Cell[1739, 51, 367, 5, 94, "ChapterLine",
      CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Point Symmetries of Partial Differential Equations"]},
  "Introduction"->{
    Cell[2486, 69, 340, 5, 43, "Section",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Introduction"]},
  "tools of Lie's symmetry method"->{
    Cell[2829, 76, 442, 8, 61, "Text",
      CellTags->{
      "tools of Lie's symmetry method", "partial differential equation", 
        "computer algebra"}]},
  "partial differential equation"->{
    Cell[2829, 76, 442, 8, 61, "Text",
      CellTags->{
      "tools of Lie's symmetry method", "partial differential equation", 
        "computer algebra"}],
    Cell[3274, 86, 1187, 21, 129, "Text",
      CellTags->{
      "symmetry theory of Lie", "partial differential equation", 
        "systematically solve differential equations", 
        "nonlinear partial differential equation"}],
    Cell[119375, 3398, 407, 11, 44, "Text",
      Evaluatable->False,
      CellTags->"partial differential equation"]},
  "computer algebra"->{
    Cell[2829, 76, 442, 8, 61, "Text",
      CellTags->{
      "tools of Lie's symmetry method", "partial differential equation", 
        "computer algebra"}]},
  "symmetry theory of Lie"->{
    Cell[3274, 86, 1187, 21, 129, "Text",
      CellTags->{
      "symmetry theory of Lie", "partial differential equation", 
        "systematically solve differential equations", 
        "nonlinear partial differential equation"}]},
  "systematically solve differential equations"->{
    Cell[3274, 86, 1187, 21, 129, "Text",
      CellTags->{
      "symmetry theory of Lie", "partial differential equation", 
        "systematically solve differential equations", 
        "nonlinear partial differential equation"}]},
  "nonlinear partial differential equation"->{
    Cell[3274, 86, 1187, 21, 129, "Text",
      CellTags->{
      "symmetry theory of Lie", "partial differential equation", 
        "systematically solve differential equations", 
        "nonlinear partial differential equation"}],
    Cell[66728, 1915, 549, 18, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "Harry-Dym equation", "nonlinear partial differential equation"}]},
  "Lie's method"->{
    Cell[5075, 119, 1116, 20, 146, "Text",
      CellTags->{
      "Lie's method", "algebraic calculation", 
        "symmetries of a differential equation", 
        "symbolic calculation in MathLie"}],
    Cell[6194, 141, 687, 16, 78, "Text",
      CellTags->{"Lie's method", "MathLie"}]},
  "algebraic calculation"->{
    Cell[5075, 119, 1116, 20, 146, "Text",
      CellTags->{
      "Lie's method", "algebraic calculation", 
        "symmetries of a differential equation", 
        "symbolic calculation in MathLie"}]},
  "symmetries of a differential equation"->{
    Cell[5075, 119, 1116, 20, 146, "Text",
      CellTags->{
      "Lie's method", "algebraic calculation", 
        "symmetries of a differential equation", 
        "symbolic calculation in MathLie"}]},
  "symbolic calculation in MathLie"->{
    Cell[5075, 119, 1116, 20, 146, "Text",
      CellTags->{
      "Lie's method", "algebraic calculation", 
        "symmetries of a differential equation", 
        "symbolic calculation in MathLie"}]},
  "MathLie"->{
    Cell[6194, 141, 687, 16, 78, "Text",
      CellTags->{"Lie's method", "MathLie"}]},
  "Lie's theory used in MathLie"->{
    Cell[6918, 162, 158, 6, 43, "Section",
      CellTags->"Lie's theory used in MathLie"]},
  "symmetry of a differential equation"->{
    Cell[7079, 170, 175, 4, 27, "Text",
      CellTags->"symmetry of a differential equation"]},
  "Definition: Lie Symmetry"->{
    Cell[7257, 176, 86, 1, 33, "Definition",
      CellTags->"Definition: Lie Symmetry"]},
  "point symmetry"->{
    Cell[7346, 179, 326, 6, 44, "Text",
      CellTags->{"point symmetry", "Lie symmetry"}]},
  "Lie symmetry"->{
    Cell[7346, 179, 326, 6, 44, "Text",
      CellTags->{"point symmetry", "Lie symmetry"}]},
  "group"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}],
    Cell[73362, 2093, 863, 21, 78, "Text",
      Evaluatable->False,
      CellTags->{"group", "check the invariance", "translation"}]},
  "composition of two symmetries"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "identity transformation"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "associative"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "inverse symmetry"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "invertible point transformation"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "point transformation"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "Lie groups"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "continuous parameter"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "unified"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "unified technique"->{
    Cell[7675, 187, 1883, 43, 146, "Text",
      CellTags->{
      "group", "composition of two symmetries", "identity transformation", 
        "associative", "inverse symmetry", "invertible point transformation", 
        "point transformation", "Lie groups", "continuous parameter", 
        "unified", "unified technique"}]},
  "calculate symmetries"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "point symmetries"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}],
    Cell[89964, 2574, 684, 11, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "determining equations", "overdetermined"}]},
  "nonlinear systems of DEQs"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "transformation"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}],
    Cell[16815, 466, 1313, 37, 95, "Text",
      CellTags->{
      "transformation", "infinitesimals", "prolong the transformation group", 
        "Lie-algebra", "Lie group", "infinitesimal transformation"}]},
  "infinitesimal formulation"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "symmetry group"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "nonlinear equation"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "linear overdetermined systems of partial differential equations"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "infinitesimal determining equations"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "symmetry transformation"->{
    Cell[9561, 232, 1234, 19, 146, "Text",
      CellTags->{
      "calculate symmetries", "point symmetries", "nonlinear systems of DEQs",
         "transformation", "infinitesimal formulation", "symmetry group", 
        "nonlinear equation", 
        "linear overdetermined systems of partial differential equations", 
        "infinitesimal determining equations", "symmetry transformation"}]},
  "nonlinear system of differential equations"->{
    Cell[10798, 253, 1226, 40, 79, "Text",
      CellTags->{
      "nonlinear system of differential equations", 
        "nonlinear differential equations"}]},
  "nonlinear differential equations"->{
    Cell[10798, 253, 1226, 40, 79, "Text",
      CellTags->{
      "nonlinear system of differential equations", 
        "nonlinear differential equations"}]},
  "eq-1"->{
    Cell[12027, 295, 175, 3, 23, "NumberedEquation",
      CellTags->"eq-1"]},
  "one-parameter \[Epsilon]-Lie group"->{
    Cell[12205, 300, 790, 31, 45, "Text",
      CellTags->"one-parameter \[Epsilon]-Lie group"]},
  "eq-2"->{
    Cell[12998, 333, 186, 5, 22, "NumberedEquation",
      CellTags->"eq-2"]},
  "eq-3"->{
    Cell[13187, 340, 191, 5, 22, "NumberedEquation",
      CellTags->"eq-3"]},
  "new variable"->{
    Cell[13381, 347, 1360, 47, 78, "Text",
      CellTags->{"new variable", "solution maps into other solution"}]},
  "solution maps into other solution"->{
    Cell[13381, 347, 1360, 47, 78, "Text",
      CellTags->{"new variable", "solution maps into other solution"}]},
  "eq-4"->{
    Cell[14744, 396, 186, 4, 23, "NumberedEquation",
      CellTags->"eq-4"]},
  "unique solution"->{
    Cell[14933, 402, 318, 10, 27, "Text",
      CellTags->"unique solution"]},
  "eq-5"->{
    Cell[15254, 414, 300, 8, 22, "NumberedEquation",
      CellTags->"eq-5"]},
  "one-parameter functional equation"->{
    Cell[15557, 424, 149, 3, 27, "Text",
      CellTags->"one-parameter functional equation"]},
  "infinitesimal transformation"->{
    Cell[15891, 435, 415, 14, 44, "Text",
      CellTags->"infinitesimal transformation"],
    Cell[16815, 466, 1313, 37, 95, "Text",
      CellTags->{
      "transformation", "infinitesimals", "prolong the transformation group", 
        "Lie-algebra", "Lie group", "infinitesimal transformation"}],
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}]},
  "eq-7"->{
    Cell[16309, 451, 242, 5, 23, "NumberedEquation",
      CellTags->"eq-7"]},
  "eq-8"->{
    Cell[16554, 458, 258, 6, 22, "NumberedEquation",
      CellTags->"eq-8"]},
  "infinitesimals"->{
    Cell[16815, 466, 1313, 37, 95, "Text",
      CellTags->{
      "transformation", "infinitesimals", "prolong the transformation group", 
        "Lie-algebra", "Lie group", "infinitesimal transformation"}],
    Cell[18467, 514, 1927, 51, 129, "Text",
      CellTags->{
      "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
        "generalized Lie symmetries", 
        "infinitesimal criterion of invariance"}],
    Cell[23678, 675, 1736, 48, 129, "Text",
      CellTags->{
      "determining equations", "infinitesimals", "Fr\[EAcute]chet derivative",
         "invariance condition"}],
    Cell[34283, 974, 954, 27, 78, "Text",
      CellTags->{
      "system of linear homogeneous partial differential equations", 
        "infinitesimals", "determining equations"}],
    Cell[48027, 1376, 1648, 62, 112, "Text",
      CellTags->{
      "TraditionalLieForm", "infinitesimals", 
        "representatio of infinitesimals in MathLie"}],
    Cell[58763, 1695, 1642, 39, 119, "Text",
      CellTags->{
      "Prolongation[]", "infinitesimals", "traditional form", 
        "LieTraditionalForm[]"}],
    Cell[63787, 1834, 768, 24, 61, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[64558, 1860, 1526, 29, 186, "Text",
      Evaluatable->False,
      CellTags->{"FrechetProlong[]", "infinitesimals", "Harry-Dym equation"}],
    
    Cell[69634, 1979, 398, 7, 61, "Text",
      CellTags->{"prolongation", "infinitesimals"}],
    Cell[71443, 2032, 515, 11, 63, "Text",
      Evaluatable->False,
      CellTags->{"FrechetProlong[]", "infinitesimals"}],
    Cell[74561, 2136, 385, 15, 46, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[75170, 2164, 597, 11, 82, "Text",
      Evaluatable->False,
      CellTags->{"heat equation", "infinitesimals", "FrechetProlong[]"}],
    Cell[87373, 2492, 334, 7, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "heat equation", "infinitesimals"}],
    Cell[88524, 2527, 1437, 45, 120, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "infinitesimals", 
        "symmetries of the heat equation", "heat equation", "LTF[]"}],
    Cell[115614, 3265, 1243, 35, 112, "Text",
      CellTags->{"pre-solutions", "infinitesimals"}],
    Cell[117346, 3316, 479, 17, 44, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[133248, 3881, 1349, 31, 148, "Text",
      Evaluatable->False,
      CellTags->{"Infinitesimals[]", "infinitesimals", "finite group"}]},
  "prolong the transformation group"->{
    Cell[16815, 466, 1313, 37, 95, "Text",
      CellTags->{
      "transformation", "infinitesimals", "prolong the transformation group", 
        "Lie-algebra", "Lie group", "infinitesimal transformation"}]},
  "Lie-algebra"->{
    Cell[16815, 466, 1313, 37, 95, "Text",
      CellTags->{
      "transformation", "infinitesimals", "prolong the transformation group", 
        "Lie-algebra", "Lie group", "infinitesimal transformation"}]},
  "Lie group"->{
    Cell[16815, 466, 1313, 37, 95, "Text",
      CellTags->{
      "transformation", "infinitesimals", "prolong the transformation group", 
        "Lie-algebra", "Lie group", "infinitesimal transformation"}]},
  "eq-9"->{
    Cell[18131, 505, 333, 7, 48, "NumberedEquation",
      CellTags->"eq-9"]},
  "vector field"->{
    Cell[18467, 514, 1927, 51, 129, "Text",
      CellTags->{
      "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
        "generalized Lie symmetries", 
        "infinitesimal criterion of invariance"}],
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}],
    Cell[192925, 5598, 951, 16, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "group transformations"}]},
  "prolongation"->{
    Cell[18467, 514, 1927, 51, 129, "Text",
      CellTags->{
      "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
        "generalized Lie symmetries", 
        "infinitesimal criterion of invariance"}],
    Cell[20612, 574, 264, 9, 27, "Text",
      CellTags->{"kth prolongation", "prolongation"}],
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}],
    Cell[33908, 965, 372, 7, 61, "Text",
      CellTags->{"calculate the prolongation", "prolongation"}],
    Cell[36043, 1028, 242, 9, 20, "ListItem",
      Evaluatable->False,
      CellTags->"prolongation"],
    Cell[39592, 1142, 834, 17, 97, "Text",
      CellTags->{
      "slot", "Prolongation[]", "calculate the prolongation", 
        "prolongation"}],
    Cell[61874, 1785, 268, 7, 29, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "prolongation operator", "Prolongation[]"}],
    Cell[69634, 1979, 398, 7, 61, "Text",
      CellTags->{"prolongation", "infinitesimals"}],
    Cell[76354, 2201, 554, 13, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "FrechetProlong[]", "prolongation", 
        "first coefficient of prolongation"}],
    Cell[79513, 2287, 457, 10, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "FrechetProlong[]", "prolongation", 
        "general partial differential equation of second-order"}],
    Cell[85720, 2456, 1650, 34, 186, "Text",
      Evaluatable->False,
      CellTags->{
      "invariance relation", "FrechetProlong[]", "prolongation", 
        "determining equations", "coupled PDEs"}],
    Cell[152782, 4481, 1384, 27, 154, "Text",
      Evaluatable->False,
      CellTags->{"Fr\[EAcute]chet derivative", "prolongation", "Lie[]"}]},
  "Lie symmetries"->{
    Cell[18467, 514, 1927, 51, 129, "Text",
      CellTags->{
      "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
        "generalized Lie symmetries", 
        "infinitesimal criterion of invariance"}]},
  "generalized Lie symmetries"->{
    Cell[18467, 514, 1927, 51, 129, "Text",
      CellTags->{
      "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
        "generalized Lie symmetries", 
        "infinitesimal criterion of invariance"}]},
  "infinitesimal criterion of invariance"->{
    Cell[18467, 514, 1927, 51, 129, "Text",
      CellTags->{
      "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
        "generalized Lie symmetries", 
        "infinitesimal criterion of invariance"}]},
  "eq-10"->{
    Cell[20397, 567, 212, 5, 22, "NumberedEquation",
      CellTags->"eq-10"]},
  "kth prolongation"->{
    Cell[20612, 574, 264, 9, 27, "Text",
      CellTags->{"kth prolongation", "prolongation"}]},
  "eq-11"->{
    Cell[20879, 585, 333, 8, 48, "NumberedEquation",
      CellTags->"eq-11"]},
  "prolongation coefficients"->{
    Cell[21215, 595, 746, 24, 44, "Text",
      CellTags->"prolongation coefficients"]},
  "eq-12"->{
    Cell[21964, 621, 751, 18, 41, "NumberedEquation",
      CellTags->"eq-12"]},
  "one-parameter group"->{
    Cell[22718, 641, 957, 32, 62, "Text",
      CellTags->{"one-parameter group", "infinitesimal generator"}]},
  "infinitesimal generator"->{
    Cell[22718, 641, 957, 32, 62, "Text",
      CellTags->{"one-parameter group", "infinitesimal generator"}]},
  "determining equations"->{
    Cell[23678, 675, 1736, 48, 129, "Text",
      CellTags->{
      "determining equations", "infinitesimals", "Fr\[EAcute]chet derivative",
         "invariance condition"}],
    Cell[25579, 731, 438, 9, 61, "Text",
      CellTags->{
      "Fr\[EAcute]chet derivative", "calculation of the invariance condition",
         "determining equations"}],
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}],
    Cell[34283, 974, 954, 27, 78, "Text",
      CellTags->{
      "system of linear homogeneous partial differential equations", 
        "infinitesimals", "determining equations"}],
    Cell[36838, 1059, 256, 7, 20, "ListItem",
      Evaluatable->False,
      CellTags->"determining equations"],
    Cell[84689, 2425, 591, 15, 63, "Text",
      Evaluatable->False,
      CellTags->{"determining equations", "DeterminingEquations[]"}],
    Cell[85720, 2456, 1650, 34, 186, "Text",
      Evaluatable->False,
      CellTags->{
      "invariance relation", "FrechetProlong[]", "prolongation", 
        "determining equations", "coupled PDEs"}],
    Cell[89964, 2574, 684, 11, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "determining equations", "overdetermined"}],
    Cell[110712, 3122, 782, 15, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "determining equations", "Harry-Dym equation", "Burgers equation"}],
    Cell[146247, 4294, 1248, 23, 154, "Text",
      Evaluatable->False,
      CellTags->{"LieEquations[]", "sidecondition", "determining equations"}],
    
    Cell[151805, 4450, 204, 5, 27, "Text",
      Evaluatable->False,
      CellTags->{"determining equations", "heat equation"}],
    Cell[163458, 4759, 1216, 28, 137, "Text",
      Evaluatable->False,
      CellTags->{"determining equations", "Lie[]"}],
    Cell[196910, 5721, 110, 1, 27, "Text",
      CellTags->"determining equations"]},
  "Fr\[EAcute]chet derivative"->{
    Cell[23678, 675, 1736, 48, 129, "Text",
      CellTags->{
      "determining equations", "infinitesimals", "Fr\[EAcute]chet derivative",
         "invariance condition"}],
    Cell[25579, 731, 438, 9, 61, "Text",
      CellTags->{
      "Fr\[EAcute]chet derivative", "calculation of the invariance condition",
         "determining equations"}],
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}],
    Cell[30717, 881, 617, 18, 44, "Text",
      CellTags->"Fr\[EAcute]chet derivative"],
    Cell[38721, 1114, 559, 15, 63, "Text",
      CellTags->{
      "calculation of prolongations", "Fr\[EAcute]chet derivative", 
        "Prolongation[]"}],
    Cell[152782, 4481, 1384, 27, 154, "Text",
      Evaluatable->False,
      CellTags->{"Fr\[EAcute]chet derivative", "prolongation", "Lie[]"}]},
  "invariance condition"->{
    Cell[23678, 675, 1736, 48, 129, "Text",
      CellTags->{
      "determining equations", "infinitesimals", "Fr\[EAcute]chet derivative",
         "invariance condition"}],
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}],
    Cell[31337, 901, 488, 11, 61, "Text",
      CellTags->{"invariance condition", "evolutionary vector field"}]},
  "Invariance Based on Frechet Derivatives"->{
    Cell[25451, 728, 125, 1, 43, "Section",
      CellTags->"Invariance Based on Frechet Derivatives"]},
  "calculation of the invariance condition"->{
    Cell[25579, 731, 438, 9, 61, "Text",
      CellTags->{
      "Fr\[EAcute]chet derivative", "calculation of the invariance condition",
         "determining equations"}]},
  "support function"->{
    Cell[26020, 742, 587, 18, 27, "Text",
      CellTags->{"support function", "test function"}]},
  "test function"->{
    Cell[26020, 742, 587, 18, 27, "Text",
      CellTags->{"support function", "test function"}]},
  "eq-13"->{
    Cell[26610, 762, 433, 12, 35, "NumberedEquation",
      CellTags->"eq-13"]},
  "support"->{
    Cell[27046, 776, 660, 17, 61, "Text",
      CellTags->{"support", "variation of the argument"}],
    Cell[29876, 856, 429, 11, 44, "Text",
      CellTags->{
      "support", "system of partial differential equations", 
        "prolongation in evolutionary representation"}]},
  "variation of the argument"->{
    Cell[27046, 776, 660, 17, 61, "Text",
      CellTags->{"support", "variation of the argument"}]},
  "system of differential equations"->{
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}]},
  "characteristic"->{
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}]},
  "evolutionary representation"->{
    Cell[28271, 818, 1390, 30, 130, "Text",
      CellTags->{
      "invariance condition", "Fr\[EAcute]chet derivative", 
        "determining equations", "prolongation", "vector field", 
        "system of differential equations", "characteristic", 
        "evolutionary representation", "infinitesimal transformation"}]},
  "eq-14"->{
    Cell[29664, 850, 209, 4, 23, "NumberedEquation",
      CellTags->"eq-14"]},
  "system of partial differential equations"->{
    Cell[29876, 856, 429, 11, 44, "Text",
      CellTags->{
      "support", "system of partial differential equations", 
        "prolongation in evolutionary representation"}]},
  "prolongation in evolutionary representation"->{
    Cell[29876, 856, 429, 11, 44, "Text",
      CellTags->{
      "support", "system of partial differential equations", 
        "prolongation in evolutionary representation"}]},
  "eq-15"->{
    Cell[30308, 869, 406, 10, 48, "NumberedEquation",
      CellTags->"eq-15"]},
  "evolutionary vector field"->{
    Cell[31337, 901, 488, 11, 61, "Text",
      CellTags->{"invariance condition", "evolutionary vector field"}]},
  "eq-16"->{
    Cell[31828, 914, 1002, 24, 47, "NumberedEquation",
      CellTags->{"eq-16", "Invariance condition for point symmetry"}]},
  "Invariance condition for point symmetry"->{
    Cell[31828, 914, 1002, 24, 47, "NumberedEquation",
      CellTags->{"eq-16", "Invariance condition for point symmetry"}]},
  "pencil calculation"->{
    Cell[32833, 940, 1072, 23, 129, "Text",
      CellTags->"pencil calculation"]},
  "calculate the prolongation"->{
    Cell[33908, 965, 372, 7, 61, "Text",
      CellTags->{"calculate the prolongation", "prolongation"}],
    Cell[39592, 1142, 834, 17, 97, "Text",
      CellTags->{
      "slot", "Prolongation[]", "calculate the prolongation", 
        "prolongation"}]},
  "system of linear homogeneous partial differential equations"->{
    Cell[34283, 974, 954, 27, 78, "Text",
      CellTags->{
      "system of linear homogeneous partial differential equations", 
        "infinitesimals", "determining equations"}]},
  "non-classical symmetry"->{
    Cell[35240, 1003, 529, 15, 44, "Text",
      CellTags->"non-classical symmetry"]},
  "algorithm"->{
    Cell[35772, 1020, 268, 6, 44, "Text",
      Evaluatable->False,
      CellTags->{"algorithm", "Lie point symmetries"}]},
  "Lie point symmetries"->{
    Cell[35772, 1020, 268, 6, 44, "Text",
      Evaluatable->False,
      CellTags->{"algorithm", "Lie point symmetries"}],
    Cell[38030, 1095, 563, 12, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "application of theoretical formulas", "Lie point symmetries", 
        "prolongation operator", 
        "derivation of the determining equations"}]},
  "redundant information"->{
    Cell[36442, 1045, 193, 6, 20, "ListItem",
      Evaluatable->False,
      CellTags->"redundant information"]},
  "solution of the determining equations"->{
    Cell[37205, 1072, 674, 14, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "solution of the determining equations", 
        "overdetermined system of linear partial differential equations"}],
    Cell[164677, 4789, 567, 12, 65, "Text",
      Evaluatable->False,
      CellTags->{
      "LieSolve[]", "solution of the determining equations", 
        "Infinitesimals[]"}]},
  "overdetermined system of linear partial differential equations"->{
    Cell[37205, 1072, 674, 14, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "solution of the determining equations", 
        "overdetermined system of linear partial differential equations"}]},
  "Application of the theory"->{
    Cell[37916, 1091, 111, 2, 43, "Section",
      Evaluatable->False,
      CellTags->"Application of the theory"]},
  "application of theoretical formulas"->{
    Cell[38030, 1095, 563, 12, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "application of theoretical formulas", "Lie point symmetries", 
        "prolongation operator", 
        "derivation of the determining equations"}]},
  "prolongation operator"->{
    Cell[38030, 1095, 563, 12, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "application of theoretical formulas", "Lie point symmetries", 
        "prolongation operator", "derivation of the determining equations"}],
    Cell[61874, 1785, 268, 7, 29, "Text",
      Evaluatable->False,
      CellTags->{
      "prolongation", "prolongation operator", "Prolongation[]"}]},
  "derivation of the determining equations"->{
    Cell[38030, 1095, 563, 12, 61, "Text",
      Evaluatable->False,
      CellTags->{
      "application of theoretical formulas", "Lie point symmetries", 
        "prolongation operator", 
        "derivation of the determining equations"}]},
  "Calculation of prolongations"->{
    Cell[38618, 1111, 100, 1, 41, "Subsection",
      CellTags->"Calculation of prolongations"]},
  "calculation of prolongations"->{
    Cell[38721, 1114, 559, 15, 63, "Text",
      CellTags->{
      "calculation of prolongations", "Fr\[EAcute]chet derivative", 
        "Prolongation[]"}]},
  "Prolongation[]"->{
    Cell[38721, 1114, 559, 15, 63, "Text",
      CellTags->{
      "calculation of prolongations", "Fr\[EAcute]chet derivative", 
        "Prolongation[]"}],
    Cell[39592, 1142, 834, 17, 97, "Text",
      CellTags->{
      "slot", "Prolongation[]", "calculate the prolongation", 
        "prolongation"}],
    Cell[40901, 1179, 329, 7, 46, "Text",
      CellTags->"Prolongation[]"],
    Cell[49678, 1440, 1733, 48, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "first order prolongation", "Prolongation[]", "palette", 
        "symbolic representation of the prolongation in MathLie"}],
    Cell[58763, 1695, 1642, 39, 119, "Text",
      CellTags->{
      "Prolongation[]", "infinitesimals", "traditional form", 
        "LieTraditionalForm[]"}],
    Cell[61874, 1785, 268, 7, 29, "Text",
      Evaluatable->False,
      CellTags->{"prolongation", "prolongation operator", "Prolongation[]"}],
    Cell[83867, 2403, 664, 14, 80, "Text",
      Evaluatable->False,
      CellTags->{"Prolongation[]", "FrechetProlong[]"}]},
  "slot"->{
    Cell[39592, 1142, 834, 17, 97, "Text",
      CellTags->{
      "slot", "Prolongation[]", "calculate the prolongation", 
        "prolongation"}]},
  "TraditionalLieForm"->{
    Cell[48027, 1376, 1648, 62, 112, "Text",
      CellTags->{
      "TraditionalLieForm", "infinitesimals", 
        "representatio of infinitesimals in MathLie"}]},
  "representatio of infinitesimals in MathLie"->{
    Cell[48027, 1376, 1648, 62, 112, "Text",
      CellTags->{
      "TraditionalLieForm", "infinitesimals", 
        "representatio of infinitesimals in MathLie"}]},
  "first order prolongation"->{
    Cell[49678, 1440, 1733, 48, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "first order prolongation", "Prolongation[]", "palette", 
        "symbolic representation of the prolongation in MathLie"}]},
  "palette"->{
    Cell[49678, 1440, 1733, 48, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "first order prolongation", "Prolongation[]", "palette", 
        "symbolic representation of the prolongation in MathLie"}]},
  "symbolic representation of the prolongation in MathLie"->{
    Cell[49678, 1440, 1733, 48, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "first order prolongation", "Prolongation[]", "palette", 
        "symbolic representation of the prolongation in MathLie"}]},
  "traditional form"->{
    Cell[58763, 1695, 1642, 39, 119, "Text",
      CellTags->{
      "Prolongation[]", "infinitesimals", "traditional form", 
        "LieTraditionalForm[]"}]},
  "LieTraditionalForm[]"->{
    Cell[58763, 1695, 1642, 39, 119, "Text",
      CellTags->{
      "Prolongation[]", "infinitesimals", "traditional form", 
        "LieTraditionalForm[]"}]},
  "Burgers equation"->{
    Cell[60896, 1751, 596, 14, 61, "Text",
      Evaluatable->False,
      CellTags->{"Burgers equation", "turbulence"}],
    Cell[94403, 2705, 151, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"Burgers equation"],
    Cell[110712, 3122, 782, 15, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "determining equations", "Harry-Dym equation", "Burgers equation"}],
    Cell[193911, 5618, 381, 11, 44, "Text",
      CellTags->"Burgers equation"],
    Cell[207577, 6059, 990, 16, 129, "Text",
      CellTags->{"Burgers equation", "infinite dimensional group"}],
    Cell[211212, 6151, 387, 10, 44, "Text",
      CellTags->"Burgers equation"]},
  "turbulence"->{
    Cell[60896, 1751, 596, 14, 61, "Text",
      Evaluatable->False,
      CellTags->{"Burgers equation", "turbulence"}]},
  "FrechetProlong[]"->{
    Cell[64558, 1860, 1526, 29, 186, "Text",
      Evaluatable->False,
      CellTags->{"FrechetProlong[]", "infinitesimals", "Harry-Dym equation"}],
    
    Cell[71443, 2032, 515, 11, 63, "Text",
      Evaluatable->False,
      CellTags->{"FrechetProlong[]", "infinitesimals"}],
    Cell[72332, 2064, 526, 13, 63, "Text",
      Evaluatable->False,
      CellTags->"FrechetProlong[]"],
    Cell[75170, 2164, 597, 11, 82, "Text",
      Evaluatable->False,
      CellTags->{"heat equation", "infinitesimals", "FrechetProlong[]"}],
    Cell[76354, 2201, 554, 13, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "FrechetProlong[]", "prolongation", 
        "first coefficient of prolongation"}],
    Cell[79513, 2287, 457, 10, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "FrechetProlong[]", "prolongation", 
        "general partial differential equation of second-order"}],
    Cell[83867, 2403, 664, 14, 80, "Text",
      Evaluatable->False,
      CellTags->{"Prolongation[]", "FrechetProlong[]"}],
    Cell[85720, 2456, 1650, 34, 186, "Text",
      Evaluatable->False,
      CellTags->{
      "invariance relation", "FrechetProlong[]", "prolongation", 
        "determining equations", "coupled PDEs"}]},
  "Harry-Dym equation"->{
    Cell[64558, 1860, 1526, 29, 186, "Text",
      Evaluatable->False,
      CellTags->{"FrechetProlong[]", "infinitesimals", "Harry-Dym equation"}],
    
    Cell[66728, 1915, 549, 18, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "Harry-Dym equation", "nonlinear partial differential equation"}],
    Cell[92756, 2662, 676, 12, 95, "Text",
      Evaluatable->False,
      CellTags->{"linearity", "nonlinear equations", "Harry-Dym equation"}],
    Cell[95625, 2746, 541, 11, 65, "Text",
      Evaluatable->False,
      CellTags->{"Harry-Dym equation", "DeterminingEquations[]"}],
    Cell[110712, 3122, 782, 15, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "determining equations", "Harry-Dym equation", "Burgers equation"}]},
  "heat equation"->{
    Cell[70035, 1988, 425, 9, 44, "Text",
      CellTags->{"heat equation", "partial knowledge of the infinitesimals"}],
    
    Cell[75170, 2164, 597, 11, 82, "Text",
      Evaluatable->False,
      CellTags->{"heat equation", "infinitesimals", "FrechetProlong[]"}],
    Cell[87373, 2492, 334, 7, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "heat equation", "infinitesimals"}],
    Cell[88524, 2527, 1437, 45, 120, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "infinitesimals", 
        "symmetries of the heat equation", "heat equation", "LTF[]"}],
    Cell[111497, 3139, 236, 6, 44, "Text",
      Evaluatable->False,
      CellTags->{"interactive solution", "heat equation"}],
    Cell[132102, 3846, 127, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"heat equation"],
    Cell[147529, 4321, 455, 13, 46, "Text",
      Evaluatable->False,
      CellTags->"heat equation"],
    Cell[151805, 4450, 204, 5, 27, "Text",
      Evaluatable->False,
      CellTags->{"determining equations", "heat equation"}],
    Cell[170830, 4974, 1266, 28, 135, "Text",
      Evaluatable->False,
      CellTags->{"Lie[]", "arbitrary function", "heat equation"}]},
  "partial knowledge of the infinitesimals"->{
    Cell[70035, 1988, 425, 9, 44, "Text",
      CellTags->{
      "heat equation", "partial knowledge of the infinitesimals"}]},
  "temperature"->{
    Cell[70549, 2002, 506, 11, 61, "Text",
      CellTags->{"temperature", "scaled temperature"}]},
  "scaled temperature"->{
    Cell[70549, 2002, 506, 11, 61, "Text",
      CellTags->{"temperature", "scaled temperature"}]},
  "check the invariance"->{
    Cell[73362, 2093, 863, 21, 78, "Text",
      Evaluatable->False,
      CellTags->{"group", "check the invariance", "translation"}]},
  "translation"->{
    Cell[73362, 2093, 863, 21, 78, "Text",
      Evaluatable->False,
      CellTags->{"group", "check the invariance", "translation"}],
    Cell[135442, 3941, 729, 21, 78, "Text",
      Evaluatable->False,
      CellTags->{"translation", "conformal transformation"}],
    Cell[143705, 4223, 237, 4, 44, "Text",
      Evaluatable->False,
      CellTags->{"translation", "scaling symmetries"}],
    Cell[174817, 5095, 694, 13, 95, "Text",
      Evaluatable->False,
      CellTags->{"translation", "scaling"}]},
  "first coefficient of prolongation"->{
    Cell[76354, 2201, 554, 13, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "FrechetProlong[]", "prolongation", 
        "first coefficient of prolongation"}]},
  "first extension"->{
    Cell[77444, 2231, 613, 16, 61, "Text",
      Evaluatable->False,
      CellTags->{"first extension", "second prolongation"}]},
  "second prolongation"->{
    Cell[77444, 2231, 613, 16, 61, "Text",
      Evaluatable->False,
      CellTags->{"first extension", "second prolongation"}]},
  "general partial differential equation of second-order"->{
    Cell[79513, 2287, 457, 10, 63, "Text",
      Evaluatable->False,
      CellTags->{
      "FrechetProlong[]", "prolongation", 
        "general partial differential equation of second-order"}]},
  "prolongation formula"->{
    Cell[81141, 2341, 158, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"prolongation formula"]},
  "PrintDf[]"->{
    Cell[83335, 2389, 529, 12, 82, "Text",
      Evaluatable->False,
      CellTags->"PrintDf[]"]},
  "Derivation of the determining equations"->{
    Cell[84568, 2422, 118, 1, 41, "Subsection",
      CellTags->"Derivation of the determining equations"]},
  "DeterminingEquations[]"->{
    Cell[84689, 2425, 591, 15, 63, "Text",
      Evaluatable->False,
      CellTags->{"determining equations", "DeterminingEquations[]"}],
    Cell[87373, 2492, 334, 7, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "heat equation", "infinitesimals"}],
    Cell[88524, 2527, 1437, 45, 120, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "infinitesimals", 
        "symmetries of the heat equation", "heat equation", "LTF[]"}],
    Cell[91531, 2623, 308, 8, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "generalizations of the heat equation", "DeterminingEquations[]"}],
    Cell[95625, 2746, 541, 11, 65, "Text",
      Evaluatable->False,
      CellTags->{"Harry-Dym equation", "DeterminingEquations[]"}],
    Cell[106948, 3021, 1570, 36, 135, "Text",
      Evaluatable->False,
      CellTags->{
      "overdetermined equations", "polytropic gas equations", "template", 
        "DeterminingEquations[]"}]},
  "invariance relation"->{
    Cell[85720, 2456, 1650, 34, 186, "Text",
      Evaluatable->False,
      CellTags->{
      "invariance relation", "FrechetProlong[]", "prolongation", 
        "determining equations", "coupled PDEs"}]},
  "coupled PDEs"->{
    Cell[85720, 2456, 1650, 34, 186, "Text",
      Evaluatable->False,
      CellTags->{
      "invariance relation", "FrechetProlong[]", "prolongation", 
        "determining equations", "coupled PDEs"}]},
  "symmetries of the heat equation"->{
    Cell[88524, 2527, 1437, 45, 120, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "infinitesimals", 
        "symmetries of the heat equation", "heat equation", "LTF[]"}]},
  "LTF[]"->{
    Cell[88524, 2527, 1437, 45, 120, "Text",
      Evaluatable->False,
      CellTags->{
      "DeterminingEquations[]", "infinitesimals", 
        "symmetries of the heat equation", "heat equation", "LTF[]"}]},
  "overdetermined"->{
    Cell[89964, 2574, 684, 11, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "determining equations", "overdetermined"}]},
  "generalizations of the heat equation"->{
    Cell[91531, 2623, 308, 8, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "generalizations of the heat equation", "DeterminingEquations[]"}]},
  "linearity"->{
    Cell[92756, 2662, 676, 12, 95, "Text",
      Evaluatable->False,
      CellTags->{"linearity", "nonlinear equations", "Harry-Dym equation"}]},
  "nonlinear equations"->{
    Cell[92756, 2662, 676, 12, 95, "Text",
      Evaluatable->False,
      CellTags->{"linearity", "nonlinear equations", "Harry-Dym equation"}]},
  "flow in a polytropic gas"->{
    Cell[96169, 2759, 598, 12, 78, "Text",
      CellTags->"flow in a polytropic gas"]},
  "fluid"->{
    Cell[96960, 2781, 184, 7, 27, "Text",
      Evaluatable->False,
      CellTags->"fluid"]},
  "determining equations for the polytropic gas"->{
    Cell[99315, 2849, 1111, 34, 80, "Text",
      Evaluatable->False,
      CellTags->"determining equations for the polytropic gas"]},
  "overdetermined equations"->{
    Cell[106948, 3021, 1570, 36, 135, "Text",
      Evaluatable->False,
      CellTags->{
      "overdetermined equations", "polytropic gas equations", "template", 
        "DeterminingEquations[]"}]},
  "polytropic gas equations"->{
    Cell[106948, 3021, 1570, 36, 135, "Text",
      Evaluatable->False,
      CellTags->{
      "overdetermined equations", "polytropic gas equations", "template", 
        "DeterminingEquations[]"}]},
  "template"->{
    Cell[106948, 3021, 1570, 36, 135, "Text",
      Evaluatable->False,
      CellTags->{
      "overdetermined equations", "polytropic gas equations", "template", 
        "DeterminingEquations[]"}]},
  "Solution of the determining equations"->{
    Cell[110583, 3119, 126, 1, 41, "Subsection",
      CellTags->"Solution of the determining equations"]},
  "interactive solution"->{
    Cell[111497, 3139, 236, 6, 44, "Text",
      Evaluatable->False,
      CellTags->{"interactive solution", "heat equation"}]},
  "pre-solutions"->{
    Cell[115614, 3265, 1243, 35, 112, "Text",
      CellTags->{"pre-solutions", "infinitesimals"}]},
  "partial solution"->{
    Cell[120002, 3420, 344, 9, 44, "Text",
      Evaluatable->False,
      CellTags->{"partial solution", "reduced determining equations"}]},
  "reduced determining equations"->{
    Cell[120002, 3420, 344, 9, 44, "Text",
      Evaluatable->False,
      CellTags->{"partial solution", "reduced determining equations"}]},
  "pure function"->{
    Cell[122687, 3519, 107, 2, 27, "Text",
      Evaluatable->False,
      CellTags->"pure function"]},
  "reduced set of determining equations"->{
    Cell[123589, 3547, 179, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"reduced set of determining equations"]},
  "DSolve[]"->{
    Cell[127118, 3678, 457, 14, 63, "Text",
      Evaluatable->False,
      CellTags->"DSolve[]"]},
  "solutions for the infinitesimals"->{
    Cell[129279, 3769, 194, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"solutions for the infinitesimals"]},
  "infinitesimals of the heat equation"->{
    Cell[129970, 3790, 971, 23, 112, "Text",
      CellTags->{
      "infinitesimals of the heat equation", "infinite dimensional group"}]},
  "infinite dimensional group"->{
    Cell[129970, 3790, 971, 23, 112, "Text",
      CellTags->{
      "infinitesimals of the heat equation", "infinite dimensional group"}],
    Cell[207577, 6059, 990, 16, 129, "Text",
      CellTags->{"Burgers equation", "infinite dimensional group"}]},
  "Infinitesimals[]"->{
    Cell[130944, 3815, 687, 16, 97, "Text",
      CellTags->"Infinitesimals[]"],
    Cell[133248, 3881, 1349, 31, 148, "Text",
      Evaluatable->False,
      CellTags->{"Infinitesimals[]", "infinitesimals", "finite group"}],
    Cell[137734, 4010, 263, 7, 46, "Text",
      Evaluatable->False,
      CellTags->"Infinitesimals[]"],
    Cell[143945, 4229, 775, 19, 63, "Text",
      CellTags->{
      "Infinitesimals[]", "infinitesimals of the Harry-Dym equation"}],
    Cell[164677, 4789, 567, 12, 65, "Text",
      Evaluatable->False,
      CellTags->{
      "LieSolve[]", "solution of the determining equations", 
        "Infinitesimals[]"}],
    Cell[212036, 6178, 841, 23, 80, "Text",
      CellTags->"Infinitesimals[]"]},
  "finite group"->{
    Cell[133248, 3881, 1349, 31, 148, "Text",
      Evaluatable->False,
      CellTags->{"Infinitesimals[]", "infinitesimals", "finite group"}]},
  "infinitesimals of the Harry-Dym equation"->{
    Cell[134600, 3914, 338, 8, 46, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals of the Harry-Dym equation"],
    Cell[143945, 4229, 775, 19, 63, "Text",
      CellTags->{
      "Infinitesimals[]", "infinitesimals of the Harry-Dym equation"}]},
  "conformal transformation"->{
    Cell[135442, 3941, 729, 21, 78, "Text",
      Evaluatable->False,
      CellTags->{"translation", "conformal transformation"}]},
  "infinitesimals of the polytropic gas"->{
    Cell[136174, 3964, 244, 6, 44, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals of the polytropic gas"]},
  "general second-order equation"->{
    Cell[138120, 4023, 499, 14, 61, "Text",
      Evaluatable->False,
      CellTags->"general second-order equation"]},
  "one-dimensional symmetry group"->{
    Cell[139971, 4088, 1202, 37, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "one-dimensional symmetry group", "nonlinear diffusion equation"}]},
  "nonlinear diffusion equation"->{
    Cell[139971, 4088, 1202, 37, 95, "Text",
      Evaluatable->False,
      CellTags->{
      "one-dimensional symmetry group", "nonlinear diffusion equation"}]},
  "infinitesimals of the general nonlinear diffusion equation"->{
    Cell[141588, 4144, 186, 5, 27, "Text",
      Evaluatable->False,
      CellTags->
      "infinitesimals of the general nonlinear diffusion equation"]},
  "infinitesimals of the nonlinear heat equation"->{
    Cell[143107, 4204, 201, 4, 27, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals of the nonlinear heat equation"]},
  "scaling symmetries"->{
    Cell[143705, 4223, 237, 4, 44, "Text",
      Evaluatable->False,
      CellTags->{"translation", "scaling symmetries"}]},
  "Data basis of symmetries"->{
    Cell[145374, 4275, 92, 1, 41, "Subsection",
      CellTags->"Data basis of symmetries"]},
  "data basis for differential equations"->{
    Cell[145469, 4278, 775, 14, 95, "Text",
      Evaluatable->False,
      CellTags->{"data basis for differential equations", "data basis"}]},
  "data basis"->{
    Cell[145469, 4278, 775, 14, 95, "Text",
      Evaluatable->False,
      CellTags->{"data basis for differential equations", "data basis"}]},
  "LieEquations[]"->{
    Cell[146247, 4294, 1248, 23, 154, "Text",
      Evaluatable->False,
      CellTags->{"LieEquations[]", "sidecondition", "determining equations"}],
    
    Cell[148228, 4343, 1098, 26, 137, "Text",
      Evaluatable->False,
      CellTags->"LieEquations[]"],
    Cell[173764, 5065, 593, 11, 167, "Input",
      CellTags->"LieEquations[]"]},
  "sidecondition"->{
    Cell[146247, 4294, 1248, 23, 154, "Text",
      Evaluatable->False,
      CellTags->{
      "LieEquations[]", "sidecondition", "determining equations"}]},
  "global variables in MathLie"->{
    Cell[149937, 4386, 1619, 53, 118, "Text",
      Evaluatable->False,
      CellTags->{"global variables in MathLie", "Lie[]"}]},
  "Lie[]"->{
    Cell[149937, 4386, 1619, 53, 118, "Text",
      Evaluatable->False,
      CellTags->{"global variables in MathLie", "Lie[]"}],
    Cell[152782, 4481, 1384, 27, 154, "Text",
      Evaluatable->False,
      CellTags->{"Fr\[EAcute]chet derivative", "prolongation", "Lie[]"}],
    Cell[163458, 4759, 1216, 28, 137, "Text",
      Evaluatable->False,
      CellTags->{"determining equations", "Lie[]"}],
    Cell[170830, 4974, 1266, 28, 135, "Text",
      Evaluatable->False,
      CellTags->{"Lie[]", "arbitrary function", "heat equation"}]},
  "LieSolve[]"->{
    Cell[164677, 4789, 567, 12, 65, "Text",
      Evaluatable->False,
      CellTags->{
      "LieSolve[]", "solution of the determining equations", 
        "Infinitesimals[]"}],
    Cell[166316, 4836, 1582, 41, 154, "Text",
      Evaluatable->False,
      CellTags->"LieSolve[]"],
    Cell[174464, 5083, 118, 3, 23, "Input",
      CellTags->"LieSolve[]"],
    Cell[204667, 5974, 672, 14, 80, "Text",
      CellTags->{"LieSolve[]", "infinitesimals of the Burgers equation"}]},
  "arbitrary function"->{
    Cell[170830, 4974, 1266, 28, 135, "Text",
      Evaluatable->False,
      CellTags->{"Lie[]", "arbitrary function", "heat equation"}]},
  "nonlinear filtration equation"->{
    Cell[172130, 5006, 506, 13, 61, "Text",
      Evaluatable->False,
      CellTags->"nonlinear filtration equation"]},
  "scaling"->{
    Cell[174817, 5095, 694, 13, 95, "Text",
      Evaluatable->False,
      CellTags->{"translation", "scaling"}]},
  "LieStructureForm[]"->{
    Cell[175514, 5110, 492, 13, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "LieStructureForm[]", "Lie algebra", "structural properties", 
        "transformation properties"}]},
  "Lie algebra"->{
    Cell[175514, 5110, 492, 13, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "LieStructureForm[]", "Lie algebra", "structural properties", 
        "transformation properties"}]},
  "structural properties"->{
    Cell[175514, 5110, 492, 13, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "LieStructureForm[]", "Lie algebra", "structural properties", 
        "transformation properties"}]},
  "transformation properties"->{
    Cell[175514, 5110, 492, 13, 46, "Text",
      Evaluatable->False,
      CellTags->{
      "LieStructureForm[]", "Lie algebra", "structural properties", 
        "transformation properties"}]},
  "commutator table"->{
    Cell[192925, 5598, 951, 16, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "group transformations"}]},
  "group transformations"->{
    Cell[192925, 5598, 951, 16, 129, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "group transformations"}]},
  "Cole-Hopf transformation"->{
    Cell[195188, 5666, 478, 9, 61, "Text",
      CellTags->{
      "Cole-Hopf transformation", "diffusion equation", 
        "symmetries of the Burgers equation"}]},
  "diffusion equation"->{
    Cell[195188, 5666, 478, 9, 61, "Text",
      CellTags->{
      "Cole-Hopf transformation", "diffusion equation", 
        "symmetries of the Burgers equation"}]},
  "symmetries of the Burgers equation"->{
    Cell[195188, 5666, 478, 9, 61, "Text",
      CellTags->{
      "Cole-Hopf transformation", "diffusion equation", 
        "symmetries of the Burgers equation"}]},
  "potential Burgers equation"->{
    Cell[200156, 5824, 111, 1, 27, "Text",
      CellTags->"potential Burgers equation"],
    Cell[200991, 5855, 202, 4, 33, "Input",
      CellTags->"potential Burgers equation"],
    Cell[201645, 5880, 386, 7, 61, "Text",
      CellTags->"potential Burgers equation"]},
  "infinitesimals of the Burgers equation"->{
    Cell[204667, 5974, 672, 14, 80, "Text",
      CellTags->{"LieSolve[]", "infinitesimals of the Burgers equation"}]},
  "infinitesimals for the potential Burgers equation"->{
    Cell[205756, 6004, 822, 22, 78, "Text",
      CellTags->"infinitesimals for the potential Burgers equation"]},
  "convective extension of the Burgers equation"->{
    Cell[208570, 6077, 902, 22, 95, "Text",
      CellTags->{
      "convective extension of the Burgers equation", 
        "generalized Burgers equation"}]},
  "generalized Burgers equation"->{
    Cell[208570, 6077, 902, 22, 95, "Text",
      CellTags->{
      "convective extension of the Burgers equation", 
        "generalized Burgers equation"}]},
  "symmetry group of the generalized Burgers equation"->{
    Cell[210900, 6143, 309, 6, 44, "Text",
      CellTags->"symmetry group of the generalized Burgers equation"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Point Symmetries of Partial Differential Equations", 215529, 6274},
  {"Introduction", 215906, 6281},
  {"tools of Lie's symmetry method", 216259, 6288},
  {"partial differential equation", 216458, 6293},
  {"computer algebra", 216999, 6306},
  {"symmetry theory of Lie", 217191, 6311},
  {"systematically solve differential equations", 217478, 6317},
  {"nonlinear partial differential equation", 217761, 6323},
  {"Lie's method", 218177, 6333},
  {"algebraic calculation", 218498, 6341},
  {"symmetries of a differential equation", 218748, 6347},
  {"symbolic calculation in MathLie", 218992, 6353},
  {"MathLie", 219212, 6359},
  {"Lie's theory used in MathLie", 219336, 6362},
  {"symmetry of a differential equation", 219472, 6365},
  {"Definition: Lie Symmetry", 219601, 6368},
  {"point symmetry", 219714, 6371},
  {"Lie symmetry", 219828, 6374},
  {"group", 219935, 6377},
  {"composition of two symmetries", 220438, 6387},
  {"identity transformation", 220799, 6394},
  {"associative", 221148, 6401},
  {"inverse symmetry", 221502, 6408},
  {"invertible point transformation", 221871, 6415},
  {"point transformation", 222229, 6422},
  {"Lie groups", 222577, 6429},
  {"continuous parameter", 222935, 6436},
  {"unified", 223280, 6443},
  {"unified technique", 223635, 6450},
  {"calculate symmetries", 223993, 6457},
  {"point symmetries", 224416, 6465},
  {"nonlinear systems of DEQs", 225006, 6477},
  {"transformation", 225427, 6485},
  {"infinitesimal formulation", 226069, 6497},
  {"symmetry group", 226490, 6505},
  {"nonlinear equation", 226915, 6513},
  {"linear overdetermined systems of partial differential equations", 227385, \
6521},
  {"infinitesimal determining equations", 227827, 6529},
  {"symmetry transformation", 228257, 6537},
  {"nonlinear system of differential equations", 228706, 6545},
  {"nonlinear differential equations", 228907, 6550},
  {"eq-1", 229080, 6555},
  {"one-parameter \[Epsilon]-Lie group", 229201, 6558},
  {"eq-2", 229311, 6561},
  {"eq-3", 229402, 6564},
  {"new variable", 229501, 6567},
  {"solution maps into other solution", 229658, 6570},
  {"eq-4", 229786, 6573},
  {"unique solution", 229888, 6576},
  {"eq-5", 229979, 6579},
  {"one-parameter functional equation", 230099, 6582},
  {"infinitesimal transformation", 230231, 6585},
  {"eq-7", 230870, 6598},
  {"eq-8", 230961, 6601},
  {"infinitesimals", 231062, 6604},
  {"prolong the transformation group", 233668, 6665},
  {"Lie-algebra", 233898, 6670},
  {"Lie group", 234126, 6675},
  {"eq-9", 234349, 6680},
  {"vector field", 234448, 6683},
  {"prolongation", 235179, 6699},
  {"Lie symmetries", 237178, 6745},
  {"generalized Lie symmetries", 237440, 6751},
  {"infinitesimal criterion of invariance", 237713, 6757},
  {"eq-10", 237954, 6763},
  {"kth prolongation", 238058, 6766},
  {"eq-11", 238168, 6769},
  {"prolongation coefficients", 238281, 6772},
  {"eq-12", 238383, 6775},
  {"one-parameter group", 238491, 6778},
  {"infinitesimal generator", 238634, 6781},
  {"determining equations", 238775, 6784},
  {"Fr\[EAcute]chet derivative", 240944, 6834},
  {"invariance condition", 242041, 6858},
  {"Invariance Based on Frechet Derivatives", 242704, 6871},
  {"calculation of the invariance condition", 242856, 6874},
  {"support function", 243055, 6879},
  {"test function", 243175, 6882},
  {"eq-13", 243287, 6885},
  {"support", 243383, 6888},
  {"variation of the argument", 243697, 6895},
  {"system of differential equations", 243839, 6898},
  {"characteristic", 244187, 6905},
  {"evolutionary representation", 244548, 6912},
  {"eq-14", 244887, 6919},
  {"system of partial differential equations", 245015, 6922},
  {"prolongation in evolutionary representation", 245246, 6927},
  {"eq-15", 245439, 6932},
  {"evolutionary vector field", 245553, 6935},
  {"eq-16", 245681, 6938},
  {"Invariance condition for point symmetry", 245855, 6941},
  {"pencil calculation", 246008, 6944},
  {"calculate the prolongation", 246126, 6947},
  {"system of linear homogeneous partial differential equations", 246450, \
6954},
  {"non-classical symmetry", 246664, 6959},
  {"algorithm", 246768, 6962},
  {"Lie point symmetries", 246921, 6966},
  {"redundant information", 247319, 6976},
  {"solution of the determining equations", 247479, 6980},
  {"overdetermined system of linear partial differential equations", 247941, \
6991},
  {"Application of the theory", 248186, 6997},
  {"application of theoretical formulas", 248347, 7001},
  {"prolongation operator", 248621, 7008},
  {"derivation of the determining equations", 249057, 7018},
  {"Calculation of prolongations", 249338, 7025},
  {"calculation of prolongations", 249472, 7028},
  {"Prolongation[]", 249653, 7033},
  {"slot", 250703, 7059},
  {"TraditionalLieForm", 250880, 7064},
  {"representatio of infinitesimals in MathLie", 251097, 7069},
  {"first order prolongation", 251296, 7074},
  {"palette", 251532, 7080},
  {"symbolic representation of the prolongation in MathLie", 251815, 7086},
  {"traditional form", 252060, 7092},
  {"LieTraditionalForm[]", 252249, 7097},
  {"Burgers equation", 252434, 7102},
  {"turbulence", 253119, 7119},
  {"FrechetProlong[]", 253266, 7123},
  {"Harry-Dym equation", 254529, 7155},
  {"heat equation", 255311, 7174},
  {"partial knowledge of the infinitesimals", 256599, 7205},
  {"temperature", 256747, 7209},
  {"scaled temperature", 256873, 7212},
  {"check the invariance", 257001, 7215},
  {"translation", 257157, 7219},
  {"first coefficient of prolongation", 257707, 7232},
  {"first extension", 257908, 7238},
  {"second prolongation", 258066, 7242},
  {"general partial differential equation of second-order", 258258, 7246},
  {"prolongation formula", 258484, 7252},
  {"PrintDf[]", 258611, 7256},
  {"Derivation of the determining equations", 258758, 7260},
  {"DeterminingEquations[]", 258897, 7263},
  {"invariance relation", 259927, 7288},
  {"coupled PDEs", 260154, 7294},
  {"symmetries of the heat equation", 260400, 7300},
  {"LTF[]", 260625, 7306},
  {"overdetermined", 260859, 7312},
  {"generalizations of the heat equation", 261062, 7317},
  {"linearity", 261240, 7322},
  {"nonlinear equations", 261414, 7326},
  {"flow in a polytropic gas", 261593, 7330},
  {"fluid", 261695, 7333},
  {"determining equations for the polytropic gas", 261842, 7337},
  {"overdetermined equations", 262010, 7341},
  {"polytropic gas equations", 262244, 7347},
  {"template", 262462, 7353},
  {"Solution of the determining equations", 262709, 7359},
  {"interactive solution", 262845, 7362},
  {"pre-solutions", 262996, 7366},
  {"partial solution", 263121, 7369},
  {"reduced determining equations", 263300, 7373},
  {"pure function", 263463, 7377},
  {"reduced set of determining equations", 263611, 7381},
  {"DSolve[]", 263754, 7385},
  {"solutions for the infinitesimals", 263894, 7389},
  {"infinitesimals of the heat equation", 264060, 7393},
  {"infinite dimensional group", 264235, 7397},
  {"Infinitesimals[]", 264514, 7403},
  {"finite group", 265262, 7422},
  {"infinitesimals of the Harry-Dym equation", 265456, 7426},
  {"conformal transformation", 265753, 7433},
  {"infinitesimals of the polytropic gas", 265930, 7437},
  {"general second-order equation", 266094, 7441},
  {"one-dimensional symmetry group", 266253, 7445},
  {"nonlinear diffusion equation", 266453, 7450},
  {"infinitesimals of the general nonlinear diffusion equation", 266683, \
7455},
  {"infinitesimals of the nonlinear heat equation", 266892, 7460},
  {"scaling symmetries", 267054, 7464},
  {"Data basis of symmetries", 267212, 7468},
  {"data basis for differential equations", 267351, 7471},
  {"data basis", 267514, 7475},
  {"LieEquations[]", 267681, 7479},
  {"sidecondition", 268047, 7489},
  {"global variables in MathLie", 268241, 7494},
  {"Lie[]", 268386, 7498},
  {"LieSolve[]", 268946, 7511},
  {"arbitrary function", 269450, 7524},
  {"nonlinear filtration equation", 269627, 7528},
  {"scaling", 269763, 7532},
  {"LieStructureForm[]", 269905, 7536},
  {"Lie algebra", 270121, 7542},
  {"structural properties", 270347, 7548},
  {"transformation properties", 270577, 7554},
  {"commutator table", 270798, 7560},
  {"group transformations", 270986, 7565},
  {"Cole-Hopf transformation", 271177, 7570},
  {"diffusion equation", 271370, 7575},
  {"symmetries of the Burgers equation", 271579, 7580},
  {"potential Burgers equation", 271780, 7585},
  {"infinitesimals of the Burgers equation", 272098, 7592},
  {"infinitesimals for the potential Burgers equation", 272275, 7595},
  {"convective extension of the Burgers equation", 272442, 7598},
  {"generalized Burgers equation", 272638, 7603},
  {"symmetry group of the generalized Burgers equation", 272856, 7608}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 367, 5, 94, "ChapterLine",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Point Symmetries of Partial Differential Equations"],
Cell[2109, 58, 352, 7, 184, "Title",
  CounterAssignments->{{"Title", 4}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2486, 69, 340, 5, 43, "Section",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],
Cell[2829, 76, 442, 8, 61, "Text",
  CellTags->{
  "tools of Lie's symmetry method", "partial differential equation", 
    "computer algebra"}],
Cell[3274, 86, 1187, 21, 129, "Text",
  CellTags->{
  "symmetry theory of Lie", "partial differential equation", 
    "systematically solve differential equations", 
    "nonlinear partial differential equation"}],
Cell[4464, 109, 608, 8, 95, "Text"],
Cell[5075, 119, 1116, 20, 146, "Text",
  CellTags->{
  "Lie's method", "algebraic calculation", 
    "symmetries of a differential equation", 
    "symbolic calculation in MathLie"}],
Cell[6194, 141, 687, 16, 78, "Text",
  CellTags->{"Lie's method", "MathLie"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6918, 162, 158, 6, 43, "Section",
  CellTags->"Lie's theory used in MathLie"],
Cell[7079, 170, 175, 4, 27, "Text",
  CellTags->"symmetry of a differential equation"],
Cell[7257, 176, 86, 1, 33, "Definition",
  CellTags->"Definition: Lie Symmetry"],
Cell[7346, 179, 326, 6, 44, "Text",
  CellTags->{"point symmetry", "Lie symmetry"}],
Cell[7675, 187, 1883, 43, 146, "Text",
  CellTags->{
  "group", "composition of two symmetries", "identity transformation", 
    "associative", "inverse symmetry", "invertible point transformation", 
    "point transformation", "Lie groups", "continuous parameter", "unified", 
    "unified technique"}],
Cell[9561, 232, 1234, 19, 146, "Text",
  CellTags->{
  "calculate symmetries", "point symmetries", "nonlinear systems of DEQs", 
    "transformation", "infinitesimal formulation", "symmetry group", 
    "nonlinear equation", 
    "linear overdetermined systems of partial differential equations", 
    "infinitesimal determining equations", "symmetry transformation"}],
Cell[10798, 253, 1226, 40, 79, "Text",
  CellTags->{
  "nonlinear system of differential equations", 
    "nonlinear differential equations"}],
Cell[12027, 295, 175, 3, 23, "NumberedEquation",
  CellTags->"eq-1"],
Cell[12205, 300, 790, 31, 45, "Text",
  CellTags->"one-parameter \[Epsilon]-Lie group"],
Cell[12998, 333, 186, 5, 22, "NumberedEquation",
  CellTags->"eq-2"],
Cell[13187, 340, 191, 5, 22, "NumberedEquation",
  CellTags->"eq-3"],
Cell[13381, 347, 1360, 47, 78, "Text",
  CellTags->{"new variable", "solution maps into other solution"}],
Cell[14744, 396, 186, 4, 23, "NumberedEquation",
  CellTags->"eq-4"],
Cell[14933, 402, 318, 10, 27, "Text",
  CellTags->"unique solution"],
Cell[15254, 414, 300, 8, 22, "NumberedEquation",
  CellTags->"eq-5"],
Cell[15557, 424, 149, 3, 27, "Text",
  CellTags->"one-parameter functional equation"],
Cell[15709, 429, 179, 4, 22, "NumberedEquation"],
Cell[15891, 435, 415, 14, 44, "Text",
  CellTags->"infinitesimal transformation"],
Cell[16309, 451, 242, 5, 23, "NumberedEquation",
  CellTags->"eq-7"],
Cell[16554, 458, 258, 6, 22, "NumberedEquation",
  CellTags->"eq-8"],
Cell[16815, 466, 1313, 37, 95, "Text",
  CellTags->{
  "transformation", "infinitesimals", "prolong the transformation group", 
    "Lie-algebra", "Lie group", "infinitesimal transformation"}],
Cell[18131, 505, 333, 7, 48, "NumberedEquation",
  CellTags->"eq-9"],
Cell[18467, 514, 1927, 51, 129, "Text",
  CellTags->{
  "vector field", "infinitesimals", "prolongation", "Lie symmetries", 
    "generalized Lie symmetries", "infinitesimal criterion of invariance"}],
Cell[20397, 567, 212, 5, 22, "NumberedEquation",
  CellTags->"eq-10"],
Cell[20612, 574, 264, 9, 27, "Text",
  CellTags->{"kth prolongation", "prolongation"}],
Cell[20879, 585, 333, 8, 48, "NumberedEquation",
  CellTags->"eq-11"],
Cell[21215, 595, 746, 24, 44, "Text",
  CellTags->"prolongation coefficients"],
Cell[21964, 621, 751, 18, 41, "NumberedEquation",
  CellTags->"eq-12"],
Cell[22718, 641, 957, 32, 62, "Text",
  CellTags->{"one-parameter group", "infinitesimal generator"}],
Cell[23678, 675, 1736, 48, 129, "Text",
  CellTags->{
  "determining equations", "infinitesimals", "Fr\[EAcute]chet derivative", 
    "invariance condition"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25451, 728, 125, 1, 43, "Section",
  CellTags->"Invariance Based on Frechet Derivatives"],
Cell[25579, 731, 438, 9, 61, "Text",
  CellTags->{
  "Fr\[EAcute]chet derivative", "calculation of the invariance condition", 
    "determining equations"}],
Cell[26020, 742, 587, 18, 27, "Text",
  CellTags->{"support function", "test function"}],
Cell[26610, 762, 433, 12, 35, "NumberedEquation",
  CellTags->"eq-13"],
Cell[27046, 776, 660, 17, 61, "Text",
  CellTags->{"support", "variation of the argument"}],
Cell[27709, 795, 559, 21, 44, "Text"],
Cell[28271, 818, 1390, 30, 130, "Text",
  CellTags->{
  "invariance condition", "Fr\[EAcute]chet derivative", 
    "determining equations", "prolongation", "vector field", 
    "system of differential equations", "characteristic", 
    "evolutionary representation", "infinitesimal transformation"}],
Cell[29664, 850, 209, 4, 23, "NumberedEquation",
  CellTags->"eq-14"],
Cell[29876, 856, 429, 11, 44, "Text",
  CellTags->{
  "support", "system of partial differential equations", 
    "prolongation in evolutionary representation"}],
Cell[30308, 869, 406, 10, 48, "NumberedEquation",
  CellTags->"eq-15"],
Cell[30717, 881, 617, 18, 44, "Text",
  CellTags->"Fr\[EAcute]chet derivative"],
Cell[31337, 901, 488, 11, 61, "Text",
  CellTags->{"invariance condition", "evolutionary vector field"}],
Cell[31828, 914, 1002, 24, 47, "NumberedEquation",
  CellTags->{"eq-16", "Invariance condition for point symmetry"}],
Cell[32833, 940, 1072, 23, 129, "Text",
  CellTags->"pencil calculation"],
Cell[33908, 965, 372, 7, 61, "Text",
  CellTags->{"calculate the prolongation", "prolongation"}],
Cell[34283, 974, 954, 27, 78, "Text",
  CellTags->{
  "system of linear homogeneous partial differential equations", 
    "infinitesimals", "determining equations"}],
Cell[35240, 1003, 529, 15, 44, "Text",
  CellTags->"non-classical symmetry"],
Cell[35772, 1020, 268, 6, 44, "Text",
  Evaluatable->False,
  CellTags->{"algorithm", "Lie point symmetries"}],
Cell[36043, 1028, 242, 9, 20, "ListItem",
  Evaluatable->False,
  CellTags->"prolongation"],
Cell[36288, 1039, 151, 4, 22, "NumberedEquation",
  Evaluatable->False],
Cell[36442, 1045, 193, 6, 20, "ListItem",
  Evaluatable->False,
  CellTags->"redundant information"],
Cell[36638, 1053, 197, 4, 22, "NumberedEquation"],
Cell[36838, 1059, 256, 7, 20, "ListItem",
  Evaluatable->False,
  CellTags->"determining equations"],
Cell[37097, 1068, 105, 2, 20, "ListItem",
  Evaluatable->False],
Cell[37205, 1072, 674, 14, 61, "Text",
  Evaluatable->False,
  CellTags->{
  "solution of the determining equations", 
    "overdetermined system of linear partial differential equations"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[37916, 1091, 111, 2, 43, "Section",
  Evaluatable->False,
  CellTags->"Application of the theory"],
Cell[38030, 1095, 563, 12, 61, "Text",
  Evaluatable->False,
  CellTags->{
  "application of theoretical formulas", "Lie point symmetries", 
    "prolongation operator", "derivation of the determining equations"}],

Cell[CellGroupData[{
Cell[38618, 1111, 100, 1, 41, "Subsection",
  CellTags->"Calculation of prolongations"],
Cell[38721, 1114, 559, 15, 63, "Text",
  CellTags->{
  "calculation of prolongations", "Fr\[EAcute]chet derivative", 
    "Prolongation[]"}],

Cell[CellGroupData[{
Cell[39305, 1133, 88, 1, 23, "Input"],
Cell[39396, 1136, 181, 3, 38, "Output"]
}, Open  ]],
Cell[39592, 1142, 834, 17, 97, "Text",
  CellTags->{
  "slot", "Prolongation[]", "calculate the prolongation", "prolongation"}],

Cell[CellGroupData[{
Cell[40451, 1163, 110, 2, 23, "Input"],
Cell[40564, 1167, 322, 9, 23, "Output"]
}, Open  ]],
Cell[40901, 1179, 329, 7, 46, "Text",
  CellTags->"Prolongation[]"],

Cell[CellGroupData[{
Cell[41255, 1190, 72, 1, 23, "Input"],
Cell[41330, 1193, 6682, 180, 146, "Output"]
}, Open  ]],
Cell[48027, 1376, 1648, 62, 112, "Text",
  CellTags->{
  "TraditionalLieForm", "infinitesimals", 
    "representatio of infinitesimals in MathLie"}],
Cell[49678, 1440, 1733, 48, 63, "Text",
  Evaluatable->False,
  CellTags->{
  "first order prolongation", "Prolongation[]", "palette", 
    "symbolic representation of the prolongation in MathLie"}],

Cell[CellGroupData[{
Cell[51436, 1492, 627, 18, 25, "Input"],
Cell[52066, 1512, 6682, 180, 146, "Output"]
}, Open  ]],
Cell[58763, 1695, 1642, 39, 119, "Text",
  CellTags->{
  "Prolongation[]", "infinitesimals", "traditional form", 
    "LieTraditionalForm[]"}],

Cell[CellGroupData[{
Cell[60430, 1738, 70, 1, 23, "Input"],
Cell[60503, 1741, 378, 7, 23, "Output"]
}, Open  ]],
Cell[60896, 1751, 596, 14, 61, "Text",
  Evaluatable->False,
  CellTags->{"Burgers equation", "turbulence"}],
Cell[61495, 1767, 73, 2, 23, "Input"],
Cell[61571, 1771, 43, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[61639, 1776, 150, 3, 23, "Input"],
Cell[61792, 1781, 67, 1, 23, "Output"]
}, Open  ]],
Cell[61874, 1785, 268, 7, 29, "Text",
  Evaluatable->False,
  CellTags->{"prolongation", "prolongation operator", "Prolongation[]"}],

Cell[CellGroupData[{
Cell[62167, 1796, 499, 14, 25, "Input"],
Cell[62669, 1812, 1103, 19, 70, "Output"]
}, Open  ]],
Cell[63787, 1834, 768, 24, 61, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],
Cell[64558, 1860, 1526, 29, 186, "Text",
  Evaluatable->False,
  CellTags->{"FrechetProlong[]", "infinitesimals", "Harry-Dym equation"}],
Cell[66087, 1891, 114, 2, 23, "NumberedEquation"],
Cell[66204, 1895, 95, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[66324, 1900, 124, 2, 23, "Input"],
Cell[66451, 1904, 262, 8, 24, "Output"]
}, Open  ]],
Cell[66728, 1915, 549, 18, 44, "Text",
  Evaluatable->False,
  CellTags->{
  "Harry-Dym equation", "nonlinear partial differential equation"}],

Cell[CellGroupData[{
Cell[67302, 1937, 203, 4, 39, "Input"],
Cell[67508, 1943, 2111, 33, 98, "Output"]
}, Open  ]],
Cell[69634, 1979, 398, 7, 61, "Text",
  CellTags->{"prolongation", "infinitesimals"}],
Cell[70035, 1988, 425, 9, 44, "Text",
  CellTags->{"heat equation", "partial knowledge of the infinitesimals"}],
Cell[70463, 1999, 83, 1, 23, "NumberedEquation"],
Cell[70549, 2002, 506, 11, 61, "Text",
  CellTags->{"temperature", "scaled temperature"}],

Cell[CellGroupData[{
Cell[71080, 2017, 103, 2, 23, "Input"],
Cell[71186, 2021, 242, 8, 23, "Output"]
}, Open  ]],
Cell[71443, 2032, 515, 11, 63, "Text",
  Evaluatable->False,
  CellTags->{"FrechetProlong[]", "infinitesimals"}],

Cell[CellGroupData[{
Cell[71983, 2047, 83, 1, 23, "Input"],
Cell[72069, 2050, 68, 1, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72174, 2056, 91, 2, 23, "Input"],
Cell[72268, 2060, 49, 1, 23, "Output"]
}, Open  ]],
Cell[72332, 2064, 526, 13, 63, "Text",
  Evaluatable->False,
  CellTags->"FrechetProlong[]"],

Cell[CellGroupData[{
Cell[72883, 2081, 169, 3, 39, "Input"],
Cell[73055, 2086, 292, 4, 38, "Output"]
}, Open  ]],
Cell[73362, 2093, 863, 21, 78, "Text",
  Evaluatable->False,
  CellTags->{"group", "check the invariance", "translation"}],

Cell[CellGroupData[{
Cell[74250, 2118, 87, 2, 23, "Input"],
Cell[74340, 2122, 42, 1, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74419, 2128, 86, 2, 23, "Input"],
Cell[74508, 2132, 38, 1, 23, "Output"]
}, Open  ]],
Cell[74561, 2136, 385, 15, 46, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[74971, 2155, 144, 3, 39, "Input"],
Cell[75118, 2160, 37, 1, 23, "Output"]
}, Open  ]],
Cell[75170, 2164, 597, 11, 82, "Text",
  Evaluatable->False,
  CellTags->{"heat equation", "infinitesimals", "FrechetProlong[]"}],

Cell[CellGroupData[{
Cell[75792, 2179, 139, 3, 39, "Input"],
Cell[75934, 2184, 253, 8, 23, "Output"]
}, Open  ]],
Cell[76202, 2195, 149, 4, 27, "Text",
  Evaluatable->False],
Cell[76354, 2201, 554, 13, 63, "Text",
  Evaluatable->False,
  CellTags->{
  "FrechetProlong[]", "prolongation", "first coefficient of prolongation"}],

Cell[CellGroupData[{
Cell[76933, 2218, 276, 5, 55, "Input"],
Cell[77212, 2225, 217, 3, 23, "Output"]
}, Open  ]],
Cell[77444, 2231, 613, 16, 61, "Text",
  Evaluatable->False,
  CellTags->{"first extension", "second prolongation"}],

Cell[CellGroupData[{
Cell[78082, 2251, 282, 5, 71, "Input"],
Cell[78367, 2258, 696, 13, 40, "Output"]
}, Open  ]],
Cell[79078, 2274, 432, 11, 44, "Text",
  Evaluatable->False],
Cell[79513, 2287, 457, 10, 63, "Text",
  Evaluatable->False,
  CellTags->{
  "FrechetProlong[]", "prolongation", 
    "general partial differential equation of second-order"}],
Cell[79973, 2299, 130, 3, 23, "NumberedEquation"],
Cell[80106, 2304, 156, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[80287, 2313, 151, 4, 23, "Input"],
Cell[80441, 2319, 685, 19, 23, "Output"]
}, Open  ]],
Cell[81141, 2341, 158, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"prolongation formula"],

Cell[CellGroupData[{
Cell[81324, 2350, 232, 5, 55, "Input"],
Cell[81559, 2357, 1761, 29, 85, "Print"]
}, Open  ]],
Cell[83335, 2389, 529, 12, 82, "Text",
  Evaluatable->False,
  CellTags->"PrintDf[]"],
Cell[83867, 2403, 664, 14, 80, "Text",
  Evaluatable->False,
  CellTags->{"Prolongation[]", "FrechetProlong[]"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[84568, 2422, 118, 1, 41, "Subsection",
  CellTags->"Derivation of the determining equations"],
Cell[84689, 2425, 591, 15, 63, "Text",
  Evaluatable->False,
  CellTags->{"determining equations", "DeterminingEquations[]"}],

Cell[CellGroupData[{
Cell[85305, 2444, 99, 2, 23, "Input"],
Cell[85407, 2448, 298, 5, 53, "Output"]
}, Open  ]],
Cell[85720, 2456, 1650, 34, 186, "Text",
  Evaluatable->False,
  CellTags->{
  "invariance relation", "FrechetProlong[]", "prolongation", 
    "determining equations", "coupled PDEs"}],
Cell[87373, 2492, 334, 7, 46, "Text",
  Evaluatable->False,
  CellTags->{"DeterminingEquations[]", "heat equation", "infinitesimals"}],

Cell[CellGroupData[{
Cell[87732, 2503, 140, 3, 39, "Input"],
Cell[87875, 2508, 634, 16, 102, "Output"]
}, Open  ]],
Cell[88524, 2527, 1437, 45, 120, "Text",
  Evaluatable->False,
  CellTags->{
  "DeterminingEquations[]", "infinitesimals", 
    "symmetries of the heat equation", "heat equation", "LTF[]"}],
Cell[89964, 2574, 684, 11, 95, "Text",
  Evaluatable->False,
  CellTags->{"point symmetries", "determining equations", "overdetermined"}],
Cell[90651, 2587, 459, 14, 44, "Text",
  Evaluatable->False],
Cell[91113, 2603, 41, 1, 23, "Input"],

Cell[CellGroupData[{
Cell[91179, 2608, 102, 2, 23, "Input"],
Cell[91284, 2612, 232, 8, 23, "Output"]
}, Open  ]],
Cell[91531, 2623, 308, 8, 46, "Text",
  Evaluatable->False,
  CellTags->{
  "generalizations of the heat equation", "DeterminingEquations[]"}],

Cell[CellGroupData[{
Cell[91864, 2635, 135, 3, 23, "Input"],
Cell[92002, 2640, 739, 19, 140, "Output"]
}, Open  ]],
Cell[92756, 2662, 676, 12, 95, "Text",
  Evaluatable->False,
  CellTags->{"linearity", "nonlinear equations", "Harry-Dym equation"}],

Cell[CellGroupData[{
Cell[93457, 2678, 170, 3, 23, "Input"],
Cell[93630, 2683, 758, 19, 102, "Output"]
}, Open  ]],
Cell[94403, 2705, 151, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"Burgers equation"],

Cell[CellGroupData[{
Cell[94579, 2714, 128, 3, 23, "Input"],
Cell[94710, 2719, 900, 24, 118, "Output"]
}, Open  ]],
Cell[95625, 2746, 541, 11, 65, "Text",
  Evaluatable->False,
  CellTags->{"Harry-Dym equation", "DeterminingEquations[]"}],
Cell[96169, 2759, 598, 12, 78, "Text",
  CellTags->"flow in a polytropic gas"],
Cell[96770, 2773, 85, 2, 23, "Input"],
Cell[96858, 2777, 99, 2, 23, "Input"],
Cell[96960, 2781, 184, 7, 27, "Text",
  Evaluatable->False,
  CellTags->"fluid"],
Cell[97147, 2790, 83, 2, 23, "Input"],
Cell[97233, 2794, 89, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[97347, 2799, 574, 11, 92, "Input"],
Cell[97924, 2812, 1376, 34, 86, "Output"]
}, Open  ]],
Cell[99315, 2849, 1111, 34, 80, "Text",
  Evaluatable->False,
  CellTags->"determining equations for the polytropic gas"],

Cell[CellGroupData[{
Cell[100451, 2887, 193, 3, 23, "Input"],
Cell[100647, 2892, 6286, 126, 588, "Output"]
}, Open  ]],
Cell[106948, 3021, 1570, 36, 135, "Text",
  Evaluatable->False,
  CellTags->{
  "overdetermined equations", "polytropic gas equations", "template", 
    "DeterminingEquations[]"}],

Cell[CellGroupData[{
Cell[108543, 3061, 503, 13, 24, "Input"],
Cell[109049, 3076, 900, 24, 118, "Output"]
}, Open  ]],
Cell[109964, 3103, 582, 11, 78, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110583, 3119, 126, 1, 41, "Subsection",
  CellTags->"Solution of the determining equations"],
Cell[110712, 3122, 782, 15, 95, "Text",
  Evaluatable->False,
  CellTags->{
  "determining equations", "Harry-Dym equation", "Burgers equation"}],
Cell[111497, 3139, 236, 6, 44, "Text",
  Evaluatable->False,
  CellTags->{"interactive solution", "heat equation"}],

Cell[CellGroupData[{
Cell[111758, 3149, 47, 1, 23, "Input"],
Cell[111808, 3152, 634, 16, 102, "Output"]
}, Open  ]],
Cell[112457, 3171, 644, 18, 78, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[113126, 3193, 94, 2, 23, "Input"],
Cell[113223, 3197, 2376, 65, 53, "Output"]
}, Open  ]],
Cell[115614, 3265, 1243, 35, 112, "Text",
  CellTags->{"pre-solutions", "infinitesimals"}],

Cell[CellGroupData[{
Cell[116882, 3304, 237, 4, 55, "Input"],
Cell[117122, 3310, 209, 3, 38, "Output"]
}, Open  ]],
Cell[117346, 3316, 479, 17, 44, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[117850, 3337, 102, 2, 23, "Input"],
Cell[117955, 3341, 527, 16, 96, "Output"]
}, Open  ]],
Cell[118497, 3360, 492, 19, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[119014, 3383, 92, 2, 23, "Input"],
Cell[119109, 3387, 251, 8, 24, "Output"]
}, Open  ]],
Cell[119375, 3398, 407, 11, 44, "Text",
  Evaluatable->False,
  CellTags->"partial differential equation"],

Cell[CellGroupData[{
Cell[119807, 3413, 93, 1, 23, "Input"],
Cell[119903, 3416, 84, 1, 23, "Output"]
}, Open  ]],
Cell[120002, 3420, 344, 9, 44, "Text",
  Evaluatable->False,
  CellTags->{"partial solution", "reduced determining equations"}],

Cell[CellGroupData[{
Cell[120371, 3433, 103, 2, 23, "Input"],
Cell[120477, 3437, 458, 14, 94, "Output"]
}, Open  ]],
Cell[120950, 3454, 237, 9, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[121212, 3467, 185, 4, 33, "Input"],
Cell[121400, 3473, 414, 12, 36, "Output"]
}, Open  ]],
Cell[121829, 3488, 145, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[121999, 3498, 100, 2, 23, "Input"],
Cell[122102, 3502, 570, 14, 34, "Output"]
}, Open  ]],
Cell[122687, 3519, 107, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"pure function"],

Cell[CellGroupData[{
Cell[122819, 3525, 103, 2, 23, "Input"],
Cell[122925, 3529, 649, 15, 34, "Output"]
}, Open  ]],
Cell[123589, 3547, 179, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"reduced set of determining equations"],

Cell[CellGroupData[{
Cell[123793, 3556, 90, 1, 23, "Input"],
Cell[123886, 3559, 766, 23, 106, "Output"]
}, Open  ]],
Cell[124667, 3585, 723, 30, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[125415, 3619, 131, 2, 23, "Input"],
Cell[125549, 3623, 135, 2, 35, "Output"]
}, Open  ]],
Cell[125699, 3628, 98, 2, 23, "Input"],

Cell[CellGroupData[{
Cell[125822, 3634, 166, 3, 23, "Input"],
Cell[125991, 3639, 207, 3, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[126235, 3647, 79, 1, 23, "Input"],
Cell[126317, 3650, 786, 25, 100, "Output"]
}, Open  ]],
Cell[127118, 3678, 457, 14, 63, "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[127600, 3696, 158, 3, 23, "Input"],
Cell[127761, 3701, 67, 1, 23, "Output"]
}, Open  ]],
Cell[127843, 3705, 136, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[128004, 3715, 158, 3, 23, "Input"],
Cell[128165, 3720, 67, 1, 23, "Output"]
}, Open  ]],
Cell[128247, 3724, 145, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[128417, 3734, 147, 3, 23, "Input"],
Cell[128567, 3739, 67, 1, 23, "Output"]
}, Open  ]],
Cell[128649, 3743, 317, 12, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[128991, 3759, 185, 4, 39, "Input"],
Cell[129179, 3765, 85, 1, 25, "Output"]
}, Open  ]],
Cell[129279, 3769, 194, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"solutions for the infinitesimals"],

Cell[CellGroupData[{
Cell[129498, 3778, 270, 4, 55, "Input"],
Cell[129771, 3784, 184, 3, 34, "Output"]
}, Open  ]],
Cell[129970, 3790, 971, 23, 112, "Text",
  CellTags->{
  "infinitesimals of the heat equation", "infinite dimensional group"}],
Cell[130944, 3815, 687, 16, 97, "Text",
  CellTags->"Infinitesimals[]"],

Cell[CellGroupData[{
Cell[131656, 3835, 90, 1, 23, "Input"],
Cell[131749, 3838, 338, 5, 68, "Output"]
}, Open  ]],
Cell[132102, 3846, 127, 2, 27, "Text",
  Evaluatable->False,
  CellTags->"heat equation"],

Cell[CellGroupData[{
Cell[132254, 3852, 93, 2, 23, "Input"],
Cell[132350, 3856, 883, 22, 85, "Output"]
}, Open  ]],
Cell[133248, 3881, 1349, 31, 148, "Text",
  Evaluatable->False,
  CellTags->{"Infinitesimals[]", "infinitesimals", "finite group"}],
Cell[134600, 3914, 338, 8, 46, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the Harry-Dym equation"],

Cell[CellGroupData[{
Cell[134963, 3926, 216, 5, 23, "Input"],
Cell[135182, 3933, 245, 5, 51, "Output"]
}, Open  ]],
Cell[135442, 3941, 729, 21, 78, "Text",
  Evaluatable->False,
  CellTags->{"translation", "conformal transformation"}],
Cell[136174, 3964, 244, 6, 44, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the polytropic gas"],

Cell[CellGroupData[{
Cell[136443, 3974, 108, 2, 23, "Input"],
Cell[136554, 3978, 525, 9, 53, "Output"]
}, Open  ]],
Cell[137094, 3990, 637, 18, 78, "Text",
  Evaluatable->False],
Cell[137734, 4010, 263, 7, 46, "Text",
  Evaluatable->False,
  CellTags->"Infinitesimals[]"],
Cell[138000, 4019, 117, 2, 23, "NumberedEquation"],
Cell[138120, 4023, 499, 14, 61, "Text",
  Evaluatable->False,
  CellTags->"general second-order equation"],

Cell[CellGroupData[{
Cell[138644, 4041, 152, 4, 23, "Input"],
Cell[138799, 4047, 756, 21, 23, "Output"]
}, Open  ]],
Cell[139570, 4071, 116, 4, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[139711, 4079, 78, 1, 23, "Input"],
Cell[139792, 4082, 164, 3, 23, "Output"]
}, Open  ]],
Cell[139971, 4088, 1202, 37, 95, "Text",
  Evaluatable->False,
  CellTags->{
  "one-dimensional symmetry group", "nonlinear diffusion equation"}],

Cell[CellGroupData[{
Cell[141198, 4129, 117, 2, 23, "Input"],
Cell[141318, 4133, 255, 8, 23, "Output"]
}, Open  ]],
Cell[141588, 4144, 186, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the general nonlinear diffusion equation"],

Cell[CellGroupData[{
Cell[141799, 4153, 80, 1, 23, "Input"],
Cell[141882, 4156, 204, 3, 61, "Output"]
}, Open  ]],
Cell[142101, 4162, 553, 22, 44, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[142679, 4188, 135, 3, 23, "Input"],
Cell[142817, 4193, 275, 8, 24, "Output"]
}, Open  ]],
Cell[143107, 4204, 201, 4, 27, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals of the nonlinear heat equation"],

Cell[CellGroupData[{
Cell[143333, 4212, 89, 1, 23, "Input"],
Cell[143425, 4215, 265, 5, 53, "Output"]
}, Open  ]],
Cell[143705, 4223, 237, 4, 44, "Text",
  Evaluatable->False,
  CellTags->{"translation", "scaling symmetries"}],
Cell[143945, 4229, 775, 19, 63, "Text",
  CellTags->{
  "Infinitesimals[]", "infinitesimals of the Harry-Dym equation"}],

Cell[CellGroupData[{
Cell[144745, 4252, 332, 10, 23, "Input"],
Cell[145080, 4264, 245, 5, 51, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[145374, 4275, 92, 1, 41, "Subsection",
  CellTags->"Data basis of symmetries"],
Cell[145469, 4278, 775, 14, 95, "Text",
  Evaluatable->False,
  CellTags->{"data basis for differential equations", "data basis"}],
Cell[146247, 4294, 1248, 23, 154, "Text",
  Evaluatable->False,
  CellTags->{"LieEquations[]", "sidecondition", "determining equations"}],
Cell[147498, 4319, 28, 0, 29, "Example"],
Cell[147529, 4321, 455, 13, 46, "Text",
  Evaluatable->False,
  CellTags->"heat equation"],
Cell[147987, 4336, 238, 5, 55, "Input"],
Cell[148228, 4343, 1098, 26, 137, "Text",
  Evaluatable->False,
  CellTags->"LieEquations[]"],
Cell[149329, 4371, 55, 1, 23, "Input"],
Cell[149387, 4374, 547, 10, 151, "Input"],
Cell[149937, 4386, 1619, 53, 118, "Text",
  Evaluatable->False,
  CellTags->{"global variables in MathLie", "Lie[]"}],
Cell[151559, 4441, 243, 7, 46, "Text",
  Evaluatable->False],
Cell[151805, 4450, 204, 5, 27, "Text",
  Evaluatable->False,
  CellTags->{"determining equations", "heat equation"}],

Cell[CellGroupData[{
Cell[152034, 4459, 82, 1, 23, "Input"],
Cell[152119, 4462, 648, 16, 102, "Output"]
}, Open  ]],
Cell[152782, 4481, 1384, 27, 154, "Text",
  Evaluatable->False,
  CellTags->{"Fr\[EAcute]chet derivative", "prolongation", "Lie[]"}],

Cell[CellGroupData[{
Cell[154191, 4512, 110, 2, 23, "Input"],
Cell[154304, 4516, 795, 16, 113, "Output"],
Cell[155102, 4534, 1718, 44, 248, "Output"],
Cell[156823, 4580, 3992, 101, 476, "Output"],
Cell[160818, 4683, 82, 1, 23, "Output"],
Cell[160903, 4686, 2540, 70, 83, "Output"]
}, Open  ]],
Cell[163458, 4759, 1216, 28, 137, "Text",
  Evaluatable->False,
  CellTags->{"determining equations", "Lie[]"}],
Cell[164677, 4789, 567, 12, 65, "Text",
  Evaluatable->False,
  CellTags->{
  "LieSolve[]", "solution of the determining equations", 
    "Infinitesimals[]"}],

Cell[CellGroupData[{
Cell[165269, 4805, 67, 1, 23, "Input"],
Cell[165339, 4808, 962, 25, 98, "Output"]
}, Open  ]],
Cell[166316, 4836, 1582, 41, 154, "Text",
  Evaluatable->False,
  CellTags->"LieSolve[]"],

Cell[CellGroupData[{
Cell[167923, 4881, 55, 1, 23, "Input"],
Cell[167981, 4884, 960, 23, 203, "Output"]
}, Open  ]],
Cell[168956, 4910, 1428, 44, 124, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[170409, 4958, 78, 1, 23, "Input"],
Cell[170490, 4961, 325, 10, 24, "Output"]
}, Open  ]],
Cell[170830, 4974, 1266, 28, 135, "Text",
  Evaluatable->False,
  CellTags->{"Lie[]", "arbitrary function", "heat equation"}],
Cell[172099, 5004, 28, 0, 29, "Example"],
Cell[172130, 5006, 506, 13, 61, "Text",
  Evaluatable->False,
  CellTags->"nonlinear filtration equation"],
Cell[172639, 5021, 134, 3, 23, "NumberedEquation"],
Cell[172776, 5026, 317, 11, 27, "Text"],

Cell[CellGroupData[{
Cell[173118, 5041, 170, 4, 23, "Input"],
Cell[173291, 5047, 245, 8, 23, "Output"]
}, Open  ]],
Cell[173551, 5058, 210, 5, 44, "Text",
  Evaluatable->False],
Cell[173764, 5065, 593, 11, 167, "Input",
  CellTags->"LieEquations[]"],
Cell[174360, 5078, 79, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[174464, 5083, 118, 3, 23, "Input",
  CellTags->"LieSolve[]"],
Cell[174585, 5088, 217, 4, 61, "Output"]
}, Open  ]],
Cell[174817, 5095, 694, 13, 95, "Text",
  Evaluatable->False,
  CellTags->{"translation", "scaling"}],
Cell[175514, 5110, 492, 13, 46, "Text",
  Evaluatable->False,
  CellTags->{
  "LieStructureForm[]", "Lie algebra", "structural properties", 
    "transformation properties"}],

Cell[CellGroupData[{
Cell[176031, 5127, 90, 2, 23, "Input"],
Cell[176124, 5131, 758, 16, 128, "Output"],
Cell[176885, 5149, 882, 15, 218, "Output"],
Cell[177770, 5166, 2694, 75, 259, "Output"],
Cell[180467, 5243, 222, 5, 38, "Output"],
Cell[180692, 5250, 1668, 55, 126, "Output"],
Cell[182363, 5307, 2216, 68, 98, "Output"],
Cell[184582, 5377, 8328, 218, 1011, "Output"]
}, Open  ]],
Cell[192925, 5598, 951, 16, 129, "Text",
  Evaluatable->False,
  CellTags->{"commutator table", "vector field", "group transformations"}],
Cell[193879, 5616, 29, 0, 29, "Example"],
Cell[193911, 5618, 381, 11, 44, "Text",
  CellTags->"Burgers equation"],
Cell[194295, 5631, 50, 1, 23, "Input"],
Cell[194348, 5634, 70, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[194443, 5638, 139, 3, 23, "Input"],
Cell[194585, 5643, 255, 8, 23, "Output"]
}, Open  ]],
Cell[194855, 5654, 330, 10, 27, "Text"],
Cell[195188, 5666, 478, 9, 61, "Text",
  CellTags->{
  "Cole-Hopf transformation", "diffusion equation", 
    "symmetries of the Burgers equation"}],
Cell[195669, 5677, 246, 5, 44, "Text"],

Cell[CellGroupData[{
Cell[195940, 5686, 270, 4, 71, "Input"],
Cell[196213, 5692, 233, 4, 53, "Output"]
}, Open  ]],
Cell[196461, 5699, 51, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[196537, 5703, 65, 1, 23, "Input"],
Cell[196605, 5706, 54, 1, 23, "Output"]
}, Open  ]],
Cell[196674, 5710, 118, 5, 27, "Text"],
Cell[196795, 5717, 112, 2, 23, "Input"],
Cell[196910, 5721, 110, 1, 27, "Text",
  CellTags->"determining equations"],

Cell[CellGroupData[{
Cell[197045, 5726, 146, 3, 23, "Input"],
Cell[197194, 5731, 2182, 67, 102, "Output"]
}, Open  ]],
Cell[199391, 5801, 547, 12, 78, "Text"],

Cell[CellGroupData[{
Cell[199963, 5817, 91, 1, 23, "Input"],
Cell[200057, 5820, 84, 1, 23, "Output"]
}, Open  ]],
Cell[200156, 5824, 111, 1, 27, "Text",
  CellTags->"potential Burgers equation"],

Cell[CellGroupData[{
Cell[200292, 5829, 77, 1, 23, "Input"],
Cell[200372, 5832, 275, 8, 23, "Output"]
}, Open  ]],
Cell[200662, 5843, 304, 8, 44, "Text"],

Cell[CellGroupData[{
Cell[200991, 5855, 202, 4, 33, "Input",
  CellTags->"potential Burgers equation"],
Cell[201196, 5861, 252, 8, 24, "Output"]
}, Open  ]],
Cell[201463, 5872, 179, 6, 27, "Text"],
Cell[201645, 5880, 386, 7, 61, "Text",
  CellTags->"potential Burgers equation"],
Cell[202034, 5889, 235, 4, 55, "Input"],
Cell[202272, 5895, 87, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[202384, 5900, 63, 1, 23, "Input"],
Cell[202450, 5903, 2202, 68, 102, "Output"]
}, Open  ]],
Cell[204667, 5974, 672, 14, 80, "Text",
  CellTags->{"LieSolve[]", "infinitesimals of the Burgers equation"}],

Cell[CellGroupData[{
Cell[205364, 5992, 71, 1, 23, "Input"],
Cell[205438, 5995, 303, 6, 66, "Output"]
}, Open  ]],
Cell[205756, 6004, 822, 22, 78, "Text",
  CellTags->"infinitesimals for the potential Burgers equation"],

Cell[CellGroupData[{
Cell[206603, 6030, 73, 1, 23, "Input"],
Cell[206679, 6033, 883, 23, 68, "Output"]
}, Open  ]],
Cell[207577, 6059, 990, 16, 129, "Text",
  CellTags->{"Burgers equation", "infinite dimensional group"}],
Cell[208570, 6077, 902, 22, 95, "Text",
  CellTags->{
  "convective extension of the Burgers equation", 
    "generalized Burgers equation"}],

Cell[CellGroupData[{
Cell[209497, 6103, 141, 3, 23, "Input"],
Cell[209641, 6108, 255, 8, 24, "Output"]
}, Open  ]],
Cell[209911, 6119, 656, 11, 97, "Text"],

Cell[CellGroupData[{
Cell[210592, 6134, 82, 1, 23, "Input"],
Cell[210677, 6137, 208, 3, 61, "Output"]
}, Open  ]],
Cell[210900, 6143, 309, 6, 44, "Text",
  CellTags->"symmetry group of the generalized Burgers equation"],
Cell[211212, 6151, 387, 10, 44, "Text",
  CellTags->"Burgers equation"],

Cell[CellGroupData[{
Cell[211624, 6165, 176, 4, 23, "Input",
  PageBreakBelow->False],
Cell[211803, 6171, 218, 4, 61, "Output"]
}, Open  ]],
Cell[212036, 6178, 841, 23, 80, "Text",
  CellTags->"Infinitesimals[]"],
Cell[212880, 6203, 429, 8, 61, "Text"],
Cell[213312, 6213, 148, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

