(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    807692,      40020]*)
(*NotebookOutlinePosition[    829085,      40519]*)
(*  CellTagsIndexPosition[    826020,      40444]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6 Working Examples", "Section",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 47}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Working examples"],

Cell[TextData[{
  "This section contains some working examples to show the application of the \
package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". We discuss the necessary steps for solving some physical and \
mathematical problems. The first example deals with the diffusion equation \
applied to the problem of thermal oscillations on a surface. A second example \
discusses the application of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " in the derivation of symmetries for a model describing a single flux line \
in a superconductor. Several applications from hydrodynamics demonstrate the \
engineering challenge of the symmetry method. The first atomic explosion \
serves to demonstrate the extraordinary success of symmetry analysis for \
estimating unknown quantities from a movie. The formation of droplets is an \
example currently under discussion in industrial applications."
}], "Text",
  CellTags->{
  "solve physical and mathematical problems", "diffusion equation", 
    "thermal oscillations", "single flux line in a superconductor", 
    "hydrodynamics", "first atomic explosion", "symmetry analysis", 
    "formation of droplets", "industrial applications"}],

Cell[CellGroupData[{

Cell["5.6.1 The Diffusion Equation", "Subsection",
  CellTags->"The diffusion equation"],

Cell[TextData[{
  "The diffusion equation is one of the extensively discussed examples in \
symmetry analysis. Since the beginning of the theory, this equation was used \
to demonstrate the usefulness of the symmetry method to derive solutions. ",
  ButtonBox["Lie",
    ButtonData:>{"Literat.nb", "Lie-Engel-1899"},
    ButtonStyle->"Hyperlink"],
  " himself used the diffusion equation as an example to illustrate the \
capabilities of the method. In his work, the diffusion equation is one of the \
equations comprehensively discussed. The diffusion equation is used by many \
other authors to introduce the method and show how the symmetry method can be \
extended in different ways. The diffusion equation here is chosen as a \
reminiscence to the tremendous work of Lie. The example of the diffusion \
equation illustrates how ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " can be exerted to derive the symmetries of this equation. We also will \
show how the gained information can be employed to solve a particular \
problem. The problem we discuss is a boundary value problem concerned with \
the seasonal oscillations of the temperature on the surface of the earth."
}], "Text",
  CellTags->{
  "diffusion equation", "derive the symmetries", "boundary value problem", 
    "seasonal oscillations of the temperature"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"5.6.2 The Earthworm\[CloseCurlyQuote]s New Year Problem"], "Subsection",
  CellTags->"The earthworm's New Year problem"],

Cell[TextData[{
  "This problem is concerned with the propagation of damped temperature waves \
into the earth due to annual temperature variation. This example is discussed \
extensively by ",
  ButtonBox["Bluman and Cole [1974].",
    ButtonData:>{"Literat.nb", "Bum-74"},
    ButtonStyle->"Hyperlink"],
  " Imagine a worm has to decide when he has to celebrate New Year. The only \
indicator of seasonal changes he has is the variation of temperature. Let us \
assume that the worm will celebrate New Year when he measures the lowest \
temperature in the year. The propagation of the seasonal temperature wave the \
worm must follow is described by a diffusion process. The measured quantity \
is the temperature denoted by the variable "
}], "Text",
  CellTags->{"damped temperature waves", "New Year problem"}],

Cell[BoxData[
    \(\(U = u[x, t]; \)\)], "Input"],

Cell[TextData[{
  "The field ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " measures the temperature variation toward the center of the earth ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((x\  > 0)\)\ \)\)]],
  "at a certain time ",
  Cell[BoxData[
      \(TraditionalForm\`\((t > 0)\)\)]],
  ". The diffusion process of heat is governed by the equation"
}], "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(diffusion = {\[PartialD]\_t U - \[PartialD]\_{x, 2}U}; 
    diffusion // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
A sketch of the physical situation we have in mind is given in the \
following figure:\
\>", "Text",
  ImageMargins->{{Inherited, Inherited}, {5, 0}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.01 -0.5 0.01 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .6 L
0 .6 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
newpath
0 -0.5 1 36 81 arc
s
0 0 1 r
0 -0.5 m
0 -0.5 1 36 81 arc
F
.502 0 1 r
0 -0.5 m
0 -0.5 .98 36 81 arc
F
.502 0 .502 r
0 -0.5 m
0 -0.5 .96 36 81 arc
F
.502 0 .251 r
0 -0.5 m
0 -0.5 .94 36 81 arc
F
1 0 .502 r
0 -0.5 m
0 -0.5 .92 36 81 arc
F
.502 0 0 r
0 -0.5 m
0 -0.5 .9 36 81 arc
F
1 0 0 r
0 -0.5 m
0 -0.5 .88 36 81 arc
F
0 g
.5 0 m
.70711 .20711 L
s
% Start of user PostScript
0 0 70.7107 70.7107 MAarrowhead1
% End of user PostScript
gsave
.74246 .24246 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(T) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
1 1 0 r
gsave
.4 .19282 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(T) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(3) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .502 0 r
gsave
.75 .36603 -101.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
55.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
55.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(T) show
61.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(2) show
71.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(Cos) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
89.562500 14.437500 moveto
(@) show
95.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(2) show
107.562500 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(p) show
119.625000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
(t) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
125.625000 14.437500 moveto
(D) show
139.625000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.502007 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Math2Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Math2Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Math2Mono
%%DocumentFonts: + font Courier
grestore
1 1 0 r
gsave
.56569 .06569 -69 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(-) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
(x) show
75.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{240, 153.25},
  ImageMargins->{{45.125, 0}, {Inherited, Inherited}},
  ImageRegion->{{-0.095398, 1.20426}, {-0.156627, 1.16954}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003`0000VA000`40O003h00O00=oog`0O000PG`0
00<007`0O000>7`0<Goo00000gooO01l0022O0000`00O01l000hO0000g`?Oomoo`0]Ool0009oohAl
0003001l07`003Ul02ioo`000WooQG`000<007`0O000>G`0;Goo0002Oon6O0000`00O01l000iO000
0g`?Oomoo`0YOol0009oohMl0003001l07`003Yl02Yoo`000WooR7`000<007`0O000>7`00S`000=l
3gooOol09Woo0002Oon9O0000`00O01l000gO003?0000g`?Oomoo`0UOol0009oo`03?01l07`008Ml
0003001l07`003El00Dl0003O0moogoo02Aoo`000gooRW`000<007`0O000<g`023`000=l3gooOol0
8Woo0003Oon;O0000`00O01l000aO008?003O0lSOol000=oohal0003001l07`002ml00Pl00El3b9o
o`000gooSG`000<007`0O000;W`01c`027`?87oo0003Oon>O0000`00O01l000/O008?007O0l2?0LO
Ool000=oohml0003001l07`002Yl00Pl00Ql3`<l1aioo`0017ooSg`000<007`0O000:G`01c`027`?
1C`700<l7gooOol06Woo0004Oon@O0000`00O01l000WO008?007O0l8?0LKOol000Aooi5l0003001l
07`002El00Pl00Ql3`Ll1`8l3`03?1moogoo01Moo`0017ooTW`000D007`0On1oh7`0009oh1ml00Pl
00Ql3`Pl1`<l3`03?1moogoo01Ioo`0017ooSg`017oP00D007`0On1l07oP01ml00Tl00Ml3`Pl1`Dl
3`03?1moogoo01Eoo`0017ooU7`000<007`0On0087`023`027`?1c`723`?00<l7gooOol04goo0004
Ool00c`0O01l002AO002On000g`0On1oh00MO008?008O0l8?0L7?0l3?1lDOol000EooiEl0003001l
07`001al00Ll00Ul3`Pl1`Pl3`@l7a=oo`001GooUW`000<007`0O0006G`023`027`?2C`723`?1c`O
4Goo0005OonGO0000`00O01l000GO009?007O0l:?0L7?0l7?1l201l@Ool000EooiQl0003001l07`0
01Il00Pl00Ql3`Tl1`Ll3`Pl7`<07`moo`001GooVG`000<007`0O00057`023`027`?2C`71c`?23`O
1@0O3Woo0005OonJO0000`00O01l000BO008?008O0l8?0L8?0l8?1l801l00`00Oomoo`09Ool000Io
oiYl0003001l07`0011l00Pl00Ul3`Ll1`Pl3`Tl7`L07`03001oogoo00Yoo`001WooVg`000<007`0
O0003W`02C`027`?23`71c`?2C`O200O3Goo0006OonLO0000`00O01l000=O008?008O0l8?0L8?0l8
?1l801l00`00Oomoo`0;Ool000Iooiel0003001l07`000]l00Pl00Ul3`Ll1`Pl3`Pl7`T07`ioo`00
1WooWW`000<007`0O0002G`023`02G`?23`71c`?23`O2@0O00<007ooOol037oo0006OonOO0000`00
O01l0006O009?009O0l8?0L8?0l7?1l901l00`00Oomoo`0=Ool000Ioo`03?01l07`009el0003001l
07`000Al00Tl00Ql3`Tl1`Pl3`Pl7`P07`03001oogoo00ioo`001gooX7`000<007`0O0000g`023`0
27`?2C`723`?23`O200O00<007ooOol03goo0007OonQO0001000O01l07`023`02G`?23`72C`?1c`O
200O00<007ooOol047oo0007OonRO0000`00O00l0008?008O0l8?0L9?0l8?1l701l00`00Oomoo`0A
Ool000Mooj=l0003000l03`000Hl00Ql3`Pl1`Tl3`Pl7`P07`03001oogoo015oo`001gooXW`00S`0
00<003`0?00013`027`?23`72C`?23`O200O00<007ooOol04Woo0007OonPO005?0001000?00l03`0
2G`?2C`723`?23`O200O00<007ooOol04goo0008OonNO007?0000`00?01l3`08O0l9?0L8?0l8?1l8
01l00`00Oomoo`0DOol000Qooiil00Pl0003001l3g`?00Il3`Tl1`Pl3`Pl7`P07`03001oogoo01Eo
o`0027ooWG`02C`000=l3`00O0l01G`?2C`723`?2C`O1`0O00<007ooOol05Woo0008OonLO009?003
O0l00`00O0ml3`02O0l9?0L8?0l9?1l801l00`00Oomoo`0FOol000QooiYl00Xl00El3`03001l3g`?
00Tl1`Pl3`Tl7`P07`03001oogoo01Moo`0027ooVG`02S`01g`?00<003`7?0L01c`723`?2C`O200O
00<007ooOol067oo0009OonGO009?009O0l00c`7000l1`06?0L9?0l8?1l901l00`00Oomoo`0HOol0
00UooiIl00Tl00Ul3`<l1`03000l1c`700<l1`Tl3`Pl7`T07`03001oogoo01Uoo`002GooUG`02S`0
27`?1C`700@003`7?0Ll1`Tl3`Pl7`T07`03001oogoo01Yoo`002GooU7`02S`027`?1c`700<003`7
?0l00c`?00<003`??0l00S`?23`O2@0O00<007ooOol06goo0009OonCO00:?008O0l9?0L01000?0ll
3c`?0`000S`?23`O2@0O00<007ooOol077oo0009OonBO009?009O0l9?0L2?0l00`00?0l000030000
0c`??1ll7`06?1l901l00`00Oomoo`0MOol000Uoo`03?01l07`008il00Tl00Ul3`Tl1`@l3`H000Ll
7`T07`03001oogoo01ioo`002WooSW`02C`02W`?2C`71C`?1P001c`O200O00<007ooOol07goo000:
Oon=O009?00:O0l9?0L5?0l80005?1l801l00`00Oomoo`0POol000Yooeal00=oh2el00Tl00Yl3`Tl
1`Dl3`T000@l7`P07`03001oogoo025oo`002WooGW`000=oh7`0O000:W`02C`02W`?2C`71c`?2@00
00<l7`0O01l01`0O00<007ooOol08Woo000:OomFO003On04O0000goPO01l000YO00:?00:O0l9?0L9
?0l00c`O00000006000801l00`00Oomoo`0SOol000YooeMl0003On1l07`0009l00=oh2Ul00Xl00Yl
3`Tl1`Tl3`@l7`H000L07`03001oogoo02Aoo`002gooEW`000=oh7`0O000;7`02c`02W`?2C`72C`?
1S`O1P001@0O00<007ooOol09Goo000;OomFO0000goPO01l000[O00;?009O0l9?0L:?0l9?1l40005
01l00`00Oomoo`0UOol000]ooeAl0005On1l07oPO01oh00ZO00;?009O0l9?0L:?0l9?1l201l40003
01l00`00Oomoo`0VOol000]ooeAl00Eoh2Ul00Xl00Ul3`/l1`Pl3`Xl7`D07`8000807`03001oogoo
02Moo`002gooP7`02c`02G`?2c`723`?2S`O200O0P00:Woo000;OomoO00:?00;O0l:?0L9?0l8?1l:
01l00`00Oomoo`0YOol000]oo`03?01l07`007Yl00/l00]l3`Tl1`Xl3`Pl7`X07`03001oogoo02Yo
o`0037ooNg`02S`037`?2C`72S`?23`O2@0O00<007ooOol0;7oo000<OomjO00:?00;O0l9?0L:?0l9
?1l901l00`00Oomoo`0]Ool000aoogUl00Xl00]l3`Tl1`Xl3`Tl7`T07`03001oogoo02ioo`0037oo
Mg`02c`02W`?2S`72S`?2C`O2@0O00<007ooOol0;goo000<OomfO00:?00;O0l:?0L:?0l9?1l901l0
0`00Oomoo`0AOol2000MOol000aoogAl00/l00Yl3`/l1`Xl3`Tl7`T07`03001oogoo01=oo`03001o
ogoo01]oo`003GooLW`02S`02g`?2c`72C`?2S`O2@0O00<007ooOol03Goo0`0017oo00<007ooOol0
6goo000=Oom`O00;?00:O0l<?0L9?0l:?1l901l00`00Oomoo`0?Ool00`00Oomoo`02Ool2000MOol0
00eoofml00Xl00]l3`/l1`Tl3`Xl7`X07`03001oogoo011oo`03001oogoo025oo`003GooKG`02c`0
2g`?2c`72C`?2S`O2P0O00<007ooOol04Goo00<007ooOol08Goo000=Oom[O00;?00<O0l:?0L;?0l9
?1l:01l00`00Oomoo`0@Ool01@00Ool007oo00008Goo000=OomZO00;?00;O0l;?0L;?0l9?1l:01l0
0`00Oomoo`0AOol5000QOol000eoo`03?01l07`006El00`l00]l3`Xl1``l3`Tl7`X07`03001oogoo
03Qoo`003WooIW`033`02W`?2c`72c`?2C`O2P0O00<007ooOol0>Woo000>OomTO00<?00;O0l:?0L<
?0l9?1l:01l00`00Oomoo`0kOol000ioof=l00`l00Yl3`/l1`/l3`Xl7`X07`03001oogoo03aoo`00
3WooHG`033`02g`?2c`72c`?2S`O2P0O00<007ooOol0?Goo000>OomNO00>?00:O0l<?0L:?0l;?1l:
01l00`00Oomoo`0nOol000iooeel00dl00]l3``l1`Xl3`Xl7`X07`03001oogoo041oo`003gooFW`0
33`037`?33`72S`?2c`O2P0O00<007ooOol0@Goo000?OomGO00>?00<O0l<?0L:?0l;?1l901l00`00
Oomoo`13Ool000mooeIl00dl00al3``l1`/l3`/l7`T07`03001oogoo04Aoo`003gooE7`03S`037`?
33`72c`?2S`O2P0O00<007ooOol0AGoo000?OomAO00??00<O0l<?0L<?0l9?1l;01l00`00Oomoo`16
Ool000mooe1l00dl00il3`Xl1`dl3`Xl7`/07`03001oogoo04Moo`003goo00<l07`0O000Bg`03C`0
3W`?2c`73C`?2S`O2P0O00<007ooOol0BGoo000@Oom:O00??00>O0l:?0L=?0l;?1l:01l00`00Oomo
o`1:Ool0011oodQl00ll00al3`dl1``l3`/l7`X07`8004eoo`0047ooAg`03C`03W`?33`73C`?2c`O
2P0O00<007ooOol0CGoo000@Oom4O00??00=O0l=?0L<?0l;?1l;01l00`00Oomoo`1>Ool0011ood9l
00ll00il3``l1`dl3`/l7`/07`03001oogoo04moo`0047oo00<l07`0O000?7`03c`03g`?3C`733`?
2c`O300O00<007ooOol0D7oo000AOolkO00A?00=O0l>?0L=?0l;?1l;01l2001COol0015oocUl014l
00il3`dl1`dl3`/l7`/07`8005Eoo`004Goo=W`04C`03g`?3S`733`?33`O2`0O00<007ooOol0EGoo
000AOolcO00B?00?O0l=?0L<?0l=?1l;01l2001HOol0015ooc9l010l00ml3`hl1`dl3``l7``07`03
001oogoo05Qoo`004Goo;W`04S`047`?3S`733`?3C`O2`0O0P00Fgoo000BOolZO00B?00AO0l>?0L<
?0l=?1l<01l00`00Oomoo`1KOol0019oobMl018l015l3`ll1`dl3`dl7`/07`8005ioo`004Woo97`0
4c`04G`?3S`73S`?3C`O2`0O0P00H7oo000BOolQO00C?00AO0l@?0L>?0l<?1l<01l00`00Oomoo`1P
Ool0019ooaal01Dl019l3a0l1`hl3`dl7`/07`8003aoo`81h21oo`81h0=oo`004Woo67`05c`04G`?
43`73S`?3S`O2`0O0P007goo0P7P7Goo00<1h7ooOol087oo00<1h7ooOol00Goo000BOol00c`0O01l
000BO00G?00CO0l??0L>?0l??1l;01l00`00Oomoo`0IOol30N03Ool00`7POomoo`09Ool30N03Ool2
0N03Ool30N05Ool0107POomoogoo107P1goo00<1h7ooOol00Woo00<1h7ooOol01Woo0P7P17oo00<1
h7ooOol00Goo000COol?O00I?00BO0lA?0L??0l<?1l=01l2000MOol00`7POomoo`03Ool00`7POomo
o`07Ool00`7POomoo`03Ool0107POomoo`7P1Goo00<1h7ooOol00Woo00D1h7ooOomoo`7P00]oo`04
0N1oogoo0N08Ool0107POomoo`7P0goo00<1h7ooOol00Goo000COol:O00K?00DO0l??0L@?0l=?1l=
01l00`00Oomoo`0MOol00`7POomoo`02Ool20N09Ool00`7POomoo`03Ool0107POomoo`7P0Woo0`7P
1Goo00<1h7ooOol00Woo00<1h7ooOol02Goo00<1h7oo0N0027oo00<1h7ooOol017oo00<1h7ooOol0
0Goo000COol5O00L?00DO0lA?0L@?0l=?1l=01l2000POol00`7POomoo`0=Ool00`7POomoo`04Ool2
0N03Ool40N04Ool00`7POomoo`03Ool00`7POomoo`08Ool00`7POol1h007Ool50N03Ool00`7POomo
o`01Ool001=ooa`l01Il3a4l1a0l3`hl7`d07`80021oo`050N1oo`7POol1h00=Ool0107POomoo`7P
47oo00D1h7ooOomoo`7P009oo`030N1oogoo00Ioo`D1h0Moo`030N1oogoo00Aoo`030N1oogoo005o
o`004goo6C`05W`?4S`743`?3c`O3@0O00<007ooOol087oo1@7P3Woo0`7P47oo0P7P0goo0P7P6goo
0P7P0goo000COolF?00GO0lA?0LB?0l>?1l=01l2001`Ool001Aooa0l01Ul3a8l1a0l3`ll7`h07`80
079oo`0057oo2c`06W`?4c`74S`?3S`O3P0O0P00M7oo000DOol5?00MO0lD?0L@?0l@?1l?01l00`00
Oomoo`1dOol001Aooael3aHl1a4l3a4l7``07`8007Uoo`0057oo6G`?5c`74c`?3S`O3`0O00<007oo
Ool0NGoo000DOolFO0lF?0LC?0l@?1l?01l2001lOol001Eooa1l3aTl1a@l3a0l7`h07`8007ioo`00
5Goo2g`?6c`74c`?43`O4@0O00<007ooOol0OWoo000EOol6O0lM?0LC?0lB?1l@01l20021Ool001Eo
oadl1aLl3a8l7`h07`8008Eoo`005Goo6S`75c`?4C`O4@0O00<007ooOol0QGoo000EOolF?0LG?0lD
?1l@01l20028Ool001Iooa0l1aTl3a<l7a007`8008aoo`005Woo3C`76S`?4c`O4@0O00<007ooOol0
S7oo000FOol7?0LL?0lD?1lB01l2002?Ool001Ioo`8l1a`l3aLl7a007`8009=oo`005Woo6S`?5c`O
4`0O00<007ooOol0Tgoo000FOolG?0lG?1lD01l2002FOol001Mooa8l3aLl7a@07`8009Yoo`005goo
3C`?6C`O500O00<007ooOol0W7oo000GOol8?0lL?1lD01l2002OOol001Moo`8l3adl7aD07`800:=o
o`005goo6c`O5`0O0P00YGoo000GOolG?1lH01l2002XOol001Qooa<l7aL07`800:aoo`0067oo3C`O
6@0O0P00/7oo000HOol8?1lK01l2002cOol001Qoo`8l7ad07`800;Moo`0067oo6`0O0P00^goo000H
OolH01l2002nOol001Uooa<07`800<9oo`006Goo3@0O0P00b7oo000IOol:01l2003;Ool001Uoo`@0
7`800=5oo`00l7oo0000\
\>"],
  ImageRangeCache->{{{-22.875, 288}, {176.25, -25.9375}} -> {7.35784, \
34.1371, 0.321676, 0.321676}}],

Cell[TextData[{
  "The constant temperatures ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`T\_3\)]],
  " describe the temperature on the surface and in the interior of the earth \
at a certain depth. The seasonal changes of the temperature near the surface \
are assumed to be ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\ \(cos(2\ \[Pi]t)\)\)]],
  " and are due to radiation changes of the sun. So, besides the diffusion \
equation, the solution of the problem has to satisfy additionally boundary \
conditions. In deriving the solution of this boundary value problem, we have \
to solve the diffusion equation for the given boundary conditions on the \
surface and in the center. Examining the symmetries of the diffusion equation \
allows us to decide how the general equation is transformed and what types of \
transformation are allowed to find the solution. We use the functions ",
  StyleBox["LieEquations[]", "MmaText"],
  " and ",
  StyleBox["LieSolve[]", "MmaText"],
  " of the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to create another example in our data basis. We start with the creation \
of the information file and carry out the symmetry analysis by applying the \
function ",
  StyleBox["LieSolve[]", "MmaText"],
  ". After the derivation of the symmetries, we will consider the boundary \
values and check the invariance of these conditions under the symmetry \
transformations. In a last step, we will reduce the partial differential \
equation to an ordinary differential equation. The solution of this ODE will \
provide us with the information the worm needs to decide when the turn of the \
year happens."
}], "Text",
  CellTags->{
  "temperature on the surface", "radiation changes", "LieEquations[]", 
    "LieSolve[]", "symmetry analysis", "boundary values"}],

Cell[CellGroupData[{

Cell["5.6.2.1 Symmetry Analysis", "Subsubsection"],

Cell[TextData[{
  "The first step in an automatic symmetry analysis is the collection of all \
the information available on the equation. The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " offers the function ",
  StyleBox["LieEquations[]", "MmaText"],
  " to collect this information. If you solve a differential equation with \
pencil and paper, you need to know the equation itself. You also have to know \
the names of the dependent variables and the independent variables. \
Sometimes, the equation contains some parameters which you can also save by \
using the function ",
  StyleBox["LieEquations[]", "MmaText"],
  ". If you assemble a greater number of equations in a database, it is good \
practice to supply the files with information on the problem and on the \
sources from which the equation comes. In ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ", all this information is stored in a single file whose name is used by ",
  StyleBox["LieEquation[]", "MmaText"],
  " as first argument. The information we need to handle in the example for \
the earthworm\[CloseCurlyQuote]s New Year problem is given below:"
}], "Text",
  CellTags->{
  "automatic symmetry analysis", "pencil and paper", "equation parameters"}],

Cell[BoxData[
    \(LieEquations["\<diffuw.dgl\>", diffusion, {u}, {x, t}, {}, \n
      \t{"\<The earthworm's New Year problem\>"}, \n
      \t{{"\<G.W. Bluman and J.D. Cole\>"}, \n
        \t\t{"\<Similarity Methods for Differential Equations\>"}, \n
        \t\t{"\<Springer, New York, 1974\>"}, {"\<pp. 233\>"}}]\)], "Input"],

Cell[TextData[{
  "After the completion of these lines, the function ",
  StyleBox["LieEquations[]", "MmaText"],
  " created a file containing the information necessary for the symmetry \
analysis. The content of the file ",
  StyleBox["diffuw.dgl", "MmaText",
    FontSlant->"Italic"],
  " looks like"
}], "Text",
  CellTags->"LieEquations[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(! \(! diffuw . dgl\)\)\)], "Input"],

Cell[BoxData[{
    \(Title\  = \ {"The earthworm's New Year problem"}\), 
    \(Source\  = 
      \ {{"G.W. Bluman and J.D. Cole"}, \ \n
        \ \ \ {"Similarity Methods for Differential Equations"}, \ \n
        \ \ \ {"Springer, New York, 1974"}, \ {"pp. 233"}}\), 
    \(IndepVar\  = \ {x, \ t}\), 
    \(DependVar\  = \ {u}\), 
    \(EqList\  = 
      \ {\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]\  - \ 
          \(\(Derivative[2, \ 0]\)[u]\)[x, \ t]}\), 
    \(SubsList\  = \ {\(\(Derivative[0, \ 1]\)[u]\)[x, \ t]}\), 
    \(ParameterS\  = \ {}\), 
    \(ListXi\  = \ {}\), 
    \(ListPhi\  = \ {}\)}], "Output",
  Evaluatable->False,
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[TextData[{
  "The symmetries of the diffusion equation are calculated by applying the \
function ",
  StyleBox["LieSolve[]", "MmaText"],
  " to the collected information. The function ",
  StyleBox["LieSolve[]", "MmaText"],
  " exerts the invariance condition based on the prolongation formalism. The \
prolongation of the equation is calculated by using the Fr\[EAcute]chet \
derivative. Knowing the prolongation of the equation, the coefficients of the \
derivatives of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " are extracted. The redundant information contained in these equations is \
eliminated in the next step by inserting the diffusion equation itself into \
the prolongation. After the extraction of the coefficients of the \
derivatives, a system of determining equations for the infinitesimals \
results. The determining equations are linear but coupled. In the next step, \
a general canonical representation of these equations is calculated by ",
  StyleBox["LieSolve[]", "MmaText"],
  ". The last calculation step of ",
  StyleBox["LieSolve[]", "MmaText"],
  " solves the general canonical form. The result of this sequence of steps \
is an explicit representation of the infinitesimals for the diffusion \
equation:"
}], "Text",
  CellTags->{
  "LieSolve[]", "prolongation formalism", "invariance condition", 
    "system of determining equations", "general canonical form"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieSolve["\<diffuw.dgl\>"] // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {\(\[Xi]\_1 == k5 - 2\ k2\ t + k6\ x + k4\ t\ x\)},
          {\(\[Xi]\_2 == k3 + t\ \((2\ k6 + k4\ t)\)\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{"u", " ", 
                  RowBox[{"(", 
                    RowBox[{"k1", "-", 
                      StyleBox[\(\(k4\ t\)\/2\),
                        ScriptLevel->0], "+", \(k2\ x\), "-", 
                      StyleBox[\(\(k4\ x\^2\)\/4\),
                        ScriptLevel->0]}], ")"}]}], "+", 
                \(\[ScriptCapitalF]\_1\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k5, 
            Times[ -2, k2, t], 
            Times[ k6, x], 
            Times[ k4, t, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k3, 
            Times[ t, 
              Plus[ 
                Times[ 2, k6], 
                Times[ k4, t]]]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ u, 
              Plus[ k1, 
                Times[ 
                  Rational[ -1, 2], k4, t], 
                Times[ k2, x], 
                Times[ 
                  Rational[ -1, 4], k4, 
                  Power[ x, 2]]]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an infinite dimensional Lie group containing a \
six-dimensional discrete subgroup. The group parameters are denoted by ",
  StyleBox["k1\[Dash]k6",
    FontSlant->"Italic"],
  ". The discrete symmetries serve to construct similarity solutions."
}], "Text",
  CellTags->{
  "infinite-dimensional Lie group", "discrete subgroup", 
    "similarity solution"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.6.2.2. Similarity Solution", "Subsubsection"],

Cell[TextData[
"Knowing the infinitesimals of the diffusion equation, we are ready to solve \
the boundary value problem for the earthworm\[CloseCurlyQuote]s problem. The \
additional condition that the symmetries have to satisfy are confined in the \
side conditions on the surface and in the center of the earth. These boundary \
conditions are"], "Text",
  CellTags->"boundary value problem"],

Cell[CellGroupData[{

Cell[BoxData[
    \(b1 = v[0, t] == T\_2\ Exp[I\ 2\ \[Pi]\ t]\)], "Input"],

Cell[BoxData[
    \(v[0, t] == E\^\(2\ I\ \[Pi]\ t\)\ T\_2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b2 = v[\[Infinity], t] == 0\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"v", "[", 
        RowBox[{
          InterpretationBox["\[Infinity]",
            DirectedInfinity[ 1]], ",", "t"}], "]"}], "==", "0"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Using this complex-valued representation for the temperature, ",
  Cell[BoxData[
      \(TraditionalForm\`u = Re(v)\)]],
  ", we can check the invariance of the boundary conditions by using the \
infinitesimals. The invariance of ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  " implies that"
}], "Text",
  CellTags->{"invariance of the boundary conditions", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((ListXi\[LeftDoubleBracket]1\[RightDoubleBracket] /. x \[Rule] 0)
        \) == 0\)], "Input"],

Cell[BoxData[
    \(k5 - 2\ k2\ t == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "From this relation, it follows that the group constants ",
  StyleBox["k5",
    FontSlant->"Italic"],
  " and",
  StyleBox[" k2 ",
    FontSlant->"Italic"],
  "have to",
  StyleBox[" ",
    FontSlant->"Italic"],
  "vanish. We collect these results in a list of rules:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule = {k5 \[Rule] 0, k2 \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({k5 \[Rule] 0, k2 \[Rule] 0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The invariance of the first boundary condition ",
  StyleBox["b1",
    FontSlant->"Italic"],
  ", on the other hand, yields the relation"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(equt1 = 
      k1 - \(k4\ t\)\/2 == 
        I\ 2\ \[Pi]\ 
          \((ListXi\[LeftDoubleBracket]2\[RightDoubleBracket] /. x \[Rule] 0)
            \)\)], "Input"],

Cell[BoxData[
    \(k1 - \(k4\ t\)\/2 == 2\ I\ \[Pi]\ \((k3 + t\ \((2\ k6 + k4\ t)\))\)\)], 
  "Output"]
}, Open  ]],

Cell["which has the general solutions", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(res = 
      Reduce[CoefficientList[equt1 /. l_ == r_ \[Rule] l - r, t]\n
          \t == {0, 0, 0}, {k1, k3, k4, k6}]\)], "Input"],

Cell[BoxData[
    \(k1 == 2\ I\ k3\ \[Pi] && k4 == 0 && k6 == 0\)], "Output"]
}, Open  ]],

Cell["\<\
We transform the equations to rules and add it to the list of rules \
for the group constants:\
\>", "Text",
  CellTags->"group constants"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[rule, ToRules[res]]; rule = Flatten[rule]\)], "Input"],

Cell[BoxData[
    \({k5 \[Rule] 0, k2 \[Rule] 0, k1 \[Rule] 2\ I\ k3\ \[Pi], k4 \[Rule] 0, 
      k6 \[Rule] 0}\)], "Output"]
}, Open  ]],

Cell["\<\
The general representation of the infinitesimals for the diffusion \
equation thus reduces to\
\>", "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Infinitesimals = 
      \({ListXi, ListPhi} /. rule\) /. \n
        \t\t{\(free[_]\)[___] \[Rule] 0, u[___] \[Rule] u}\)], "Input"],

Cell[BoxData[
    \({{0, k3}, {2\ I\ k3\ \[Pi]\ u}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The reduction of the original equation follows by applying the function ",
  StyleBox["LieReduction[]", "MmaText"],
  " in the subgroup of the diffusion equation:"
}], "Text",
  Evaluatable->False,
  CellTags->"LieRedunction[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LTF[
        Flatten[LieReduction[diffusion, {u}, {x, t}, \n\t
            Infinitesimals\[LeftDoubleBracket]1\[RightDoubleBracket], 
            Infinitesimals\[LeftDoubleBracket]2\[RightDoubleBracket]]]] /. 
      zeta1 \[Rule] \[Zeta]\_1\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x - \[Zeta]\_1 == 0\)},
          {\(E\^\(\(-2\)\ I\ \[Pi]\ t\)\ u - F\_1 == 0\)},
          {
            \(I\ E\^\(2\ I\ \[Pi]\ t\)\ 
                \((2\ \[Pi]\ F\_1 + I\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\))
                  \) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity variable is ",
  StyleBox["zeta1 = x",
    FontSlant->"Italic"],
  " and the solution has the similarity form"
}], "Text",
  CellTags->"similarity form"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SimilaritySolution = 
      u \[Rule] Function[{x, t}, \n\t\t\tExp[I\ 2\ \[Pi]\ t]\ F1[x]]\)], 
  "Input"],

Cell[BoxData[
    \(u \[Rule] Function[{x, t}, Exp[I\ 2\ \[Pi]\ t]\ F1[x]]\)], "Output"]
}, Open  ]],

Cell["\<\
Substituting the similarity solution into the diffusion equation \
gives us\
\>", "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(equat2 = 
      \(Expand[\(diffusion /. SimilaritySolution\)\/Exp[I\ 2\ \[Pi]\ t]]
            \)\[LeftDoubleBracket]1\[RightDoubleBracket] == 0; 
    equat2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(2\ I\ \[Pi]\ F\_1 - \((F\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This second-order equation also contained in the result of ",
  StyleBox["LieReduction[]", "MmaText"],
  " is solved by applying the function ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->"LieReduction[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(res2 = Simplify[DSolve[equat2, F1, x]]\)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ #1\)\ C[1] + 
                E\^\(\((1 + I)\)\ \@\[Pi]\ #1\)\ C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Examining the behavior for ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] \[Infinity]\)]],
  ", we find that the second constant of integration ",
  StyleBox["C[2]",
    FontSlant->"Italic"],
  " has to vanish to satisfy the second boundary condition ",
  StyleBox["b2",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h1 = 
      Factor[Expand[
            Simplify[\n\t\t\t\tTrigToExp[ComplexExpand[F1[x] /. res2]]]] /. \n
          \t\t\t{C[2] \[Rule] 0}]\)], "Input"],

Cell[BoxData[
    \({E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ x\)\ C[1]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing the result with the first boundary condition, we observe that \
the real part of ",
  StyleBox["C[1]",
    FontSlant->"Italic"],
  " is given by ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h2 = 
      \((h1 /. C[1] \[Rule] T\_2)\)\[LeftDoubleBracket]1
        \[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \(E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ x\)\ T\_2\)], "Output"]
}, Open  ]],

Cell["The complete solution is thus given by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SimSol = SimilaritySolution /. F1[x] \[Rule] h2\)], "Input"],

Cell[BoxData[
    \(u \[Rule] 
      Function[{x, t}, 
        Exp[I\ 2\ \[Pi]\ t]\ \((E\^\(\((\(-1\) - I)\)\ \@\[Pi]\ x\)\ T\_2)\)]
        \)], "Output"]
}, Open  ]],

Cell["After a rearrangement of terms in the exponent,", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      \(u[x, t] /. SimSol\) /. \n\t\t
        c_. \ Exp[a_. \ Complex[d_, e_] + b_. \ Complex[f_, g_]] \[Rule] \n
          \t\t\tc\ Exp[\((a\ d + b\ f)\) + \((a\ e + b\ g)\)\ I]\)], "Input"],

Cell[BoxData[
    \(E\^\(\(-\@\[Pi]\)\ x + I\ \((2\ \[Pi]\ t - \@\[Pi]\ x)\)\)\ T\_2\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Re[sol]\)], "Input"],

Cell[BoxData[
    \(Re[E\^\(\(-\@\[Pi]\)\ x + I\ \((2\ \[Pi]\ t - \@\[Pi]\ x)\)\)\ T\_2]
      \)], "Output"]
}, Open  ]],

Cell["we can extract the real part of the solution by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution = Re[ExpToTrig[sol]] // Simplify\)], "Input"],

Cell[BoxData[
    \(Re[\((
          Cosh[\((1 + I)\)\ 
                \((\((\(-1\) - I)\)\ \[Pi]\ t + 
                    x\ \((Cosh[Log[\[Pi]]\/2] + Sinh[Log[\[Pi]]\/2])\))\)] - 
            Sinh[\((1 + I)\)\ 
                \((\((\(-1\) - I)\)\ \[Pi]\ t + 
                    x\ \((Cosh[Log[\[Pi]]\/2] + Sinh[Log[\[Pi]]\/2])\))\)])
          \)\ T\_2]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The derived solution describes the temperature variation near the surface \
of the earth. The solution indicates that the spatial and temporal \
coordinates are coupled. If now ",
  Cell[BoxData[
      \(TraditionalForm\`t = T\)]],
  " is the New Year of a person on the surface, then an earthworm will \
celebrate New Year at time ",
  Cell[BoxData[
      FormBox[
        RowBox[{"t", " ", "=", 
          RowBox[{"T", "+", 
            StyleBox[" ",
              ScriptLevel->1], 
            StyleBox[
              FormBox[\(\(\@\(1/2 \[Pi]\ \)\) x\_l\),
                "TraditionalForm"],
              ScriptLevel->1]}]}], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_l\)]],
  " is the depth of the earthworm. The solution in the time and spatial \
coordinate with unique ",
  Cell[BoxData[
      \(TraditionalForm\`T\_2\)]],
  " looks like"
}], "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[solution /. T\_2 \[Rule] 1, {x, 0, 2}, {t, 0, 1}, \n\t
      PlotRange \[Rule] All, PlotPoints \[Rule] 30, \n\t
      AxesLabel \[Rule] {"\<x\>", "\<t\>", "\<u\>"}, \n\t
      ViewPoint \[Rule] {\(-2.468\), \(-2.587\), 1.256}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60304 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00421689 1.00422 -0.152798 1.00422 [
[.48417 -0.01255 -2.99423 -9 ]
[.48417 -0.01255 3.00577 0 ]
[.62672 .04935 -9.1611 -9 ]
[.62672 .04935 8.8389 0 ]
[.75605 .10553 -3.10678 -9 ]
[.75605 .10553 2.89322 0 ]
[.87394 .15674 -9.46337 -9 ]
[.87394 .15674 8.53663 0 ]
[.98184 .2036 -3.19751 -9 ]
[.98184 .2036 2.80249 0 ]
[.75382 .04281 -5.17797 -15 ]
[.75382 .04281 4.82203 0 ]
[.48417 -0.01255 -2.99423 -9 ]
[.48417 -0.01255 3.00577 0 ]
[.3756 .03977 -8.84686 -9 ]
[.3756 .03977 9.15314 0 ]
[.27559 .08797 -8.72348 -9 ]
[.27559 .08797 9.27652 0 ]
[.18316 .13252 -8.6109 -9 ]
[.18316 .13252 9.3891 0 ]
[.0975 .17381 -8.50778 -9 ]
[.0975 .17381 9.49222 0 ]
[.01787 .21218 -2.80432 -9 ]
[.01787 .21218 3.19568 0 ]
[.23081 .04795 -4.81441 -15 ]
[.23081 .04795 5.18559 0 ]
[.99492 .21749 0 -6.00518 ]
[.99492 .21749 12 2.99482 ]
[.99903 .279 0 -5.91574 ]
[.99903 .279 24 3.08426 ]
[1.0032 .34155 0 -5.82504 ]
[1.0032 .34155 6 3.17496 ]
[1.00744 .40515 0 -5.73304 ]
[1.00744 .40515 18 3.26696 ]
[1.01174 .46985 0 -5.63972 ]
[1.01174 .46985 6 3.36028 ]
[1.06343 .3242 0 -9.7075 ]
[1.06343 .3242 10 5.2925 ]
[ 0 0 0 0 ]
[ 1 .60304 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.48415 0 m
.98267 .21613 L
s
.48415 0 m
.48414 .00628 L
s
[(0)] .48417 -0.01255 -0.00192 1 Mshowa
.62694 .06191 m
.62705 .06818 L
s
[(0.5)] .62672 .04935 .0179 1 Mshowa
.7565 .11808 m
.75672 .12435 L
s
[(1)] .75605 .10553 .03559 1 Mshowa
.87459 .16927 m
.87491 .17554 L
s
[(1.5)] .87394 .15674 .05149 1 Mshowa
.98267 .21613 m
.98308 .22239 L
s
[(2)] .98184 .2036 .06584 1 Mshowa
.125 Mabswid
.51386 .01288 m
.51387 .01665 L
s
.54298 .02551 m
.543 .02927 L
s
.57152 .03788 m
.57156 .04164 L
s
.5995 .05001 m
.59956 .05378 L
s
.65385 .07357 m
.65393 .07734 L
s
.68025 .08502 m
.68034 .08878 L
s
.70614 .09624 m
.70625 .10001 L
s
.73156 .10726 m
.73168 .11103 L
s
.78099 .12869 m
.78113 .13245 L
s
.80503 .13911 m
.80518 .14288 L
s
.82863 .14935 m
.8288 .15311 L
s
.85182 .1594 m
.852 .16316 L
s
.89696 .17897 m
.89717 .18273 L
s
.91895 .1885 m
.91916 .19226 L
s
.94055 .19787 m
.94078 .20163 L
s
.96179 .20708 m
.96203 .21083 L
s
gsave
.75382 .04281 -66.178 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.48415 0 m
.01705 .22471 L
s
.48415 0 m
.48414 .00628 L
s
[(0)] .48417 -0.01255 -0.00192 1 Mshowa
.37539 .05232 m
.37528 .0586 L
s
[(0.2)] .3756 .03977 -0.01702 1 Mshowa
.2752 .10052 m
.27501 .10679 L
s
[(0.4)] .27559 .08797 -0.03072 1 Mshowa
.18262 .14506 m
.18235 .15133 L
s
[(0.6)] .18316 .13252 -0.04323 1 Mshowa
.09681 .18634 m
.09647 .19261 L
s
[(0.8)] .0975 .17381 -0.05469 1 Mshowa
.01705 .22471 m
.01664 .23097 L
s
[(1)] .01787 .21218 -0.06523 1 Mshowa
.125 Mabswid
.45609 .0135 m
.45607 .01726 L
s
.42863 .02671 m
.42859 .03048 L
s
.40173 .03965 m
.40168 .04341 L
s
.34958 .06474 m
.3495 .0685 L
s
.32429 .07691 m
.3242 .08067 L
s
.2995 .08883 m
.2994 .09259 L
s
.25138 .11198 m
.25125 .11574 L
s
.22802 .12322 m
.22788 .12698 L
s
.2051 .13424 m
.20495 .13801 L
s
.16056 .15567 m
.16039 .15943 L
s
.13892 .16608 m
.13873 .16984 L
s
.11767 .1763 m
.11747 .18007 L
s
.07633 .19619 m
.07611 .19995 L
s
.05621 .20587 m
.05599 .20963 L
s
.03646 .21537 m
.03622 .21913 L
s
gsave
.23081 .04795 -65.8144 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.98267 .21613 m
1 .47942 L
s
.98302 .22147 m
.97707 .22346 L
s
[(-1)] .99492 .21749 -1 .33448 Mshowa
.98705 .28277 m
.98107 .28465 L
s
[(-0.5)] .99903 .279 -1 .31461 Mshowa
.99116 .34509 m
.98514 .34687 L
s
[(0)] 1.0032 .34155 -1 .29445 Mshowa
.99533 .40847 m
.98928 .41013 L
s
[(0.5)] 1.00744 .40515 -1 .27401 Mshowa
.99957 .47293 m
.99349 .47447 L
s
[(1)] 1.01174 .46985 -1 .25327 Mshowa
.125 Mabswid
.98382 .23365 m
.98024 .23483 L
s
.98462 .24587 m
.98104 .24704 L
s
.98543 .25813 m
.98185 .25928 L
s
.98624 .27043 m
.98265 .27157 L
s
.98787 .29515 m
.98427 .29627 L
s
.98869 .30757 m
.98509 .30868 L
s
.98951 .32004 m
.9859 .32113 L
s
.99033 .33254 m
.98672 .33362 L
s
.99199 .35768 m
.98837 .35873 L
s
.99282 .37032 m
.9892 .37135 L
s
.99365 .38299 m
.99003 .38402 L
s
.99449 .39571 m
.99086 .39672 L
s
.99617 .42128 m
.99254 .42226 L
s
.99702 .43413 m
.99338 .43509 L
s
.99787 .44702 m
.99422 .44797 L
s
.99872 .45995 m
.99507 .46089 L
s
gsave
1.06343 .3242 -61 -13.7075 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
0 .4861 L
s
0 .4861 m
.01705 .22471 L
s
.01705 .22471 m
.48415 0 L
s
.98267 .21613 m
.50758 .37586 L
s
.50758 .37586 m
.50787 .60304 L
s
.50787 .60304 m
1 .47942 L
s
1 .47942 m
.98267 .21613 L
s
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
1 .47942 L
s
1 .47942 m
.98267 .21613 L
s
.98267 .21613 m
.48415 0 L
s
.01705 .22471 m
.50758 .37586 L
s
.50758 .37586 m
.50787 .60304 L
s
.50787 .60304 m
0 .4861 L
s
0 .4861 m
.01705 .22471 L
s
0 0 m
1 0 L
1 .60304 L
0 .60304 L
closepath
clip
newpath
.5 Mabswid
.559 .795 .987 r
.50714 .4761 .49296 .48004 .50772 .48456 .52191 .4807 Metetra
.562 .794 .986 r
.49222 .47139 .47805 .47545 .49296 .48004 .50714 .4761 Metetra
.566 .794 .985 r
.47715 .4666 .46299 .47079 .47805 .47545 .49222 .47139 Metetra
.571 .794 .983 r
.46193 .46172 .44778 .46607 .46299 .47079 .47715 .4666 Metetra
.577 .794 .981 r
.44655 .45678 .43241 .46133 .44778 .46607 .46193 .46172 Metetra
.584 .794 .979 r
.43101 .45178 .41688 .45657 .43241 .46133 .44655 .45678 Metetra
.593 .796 .977 r
.41532 .44675 .4012 .45183 .41688 .45657 .43101 .45178 Metetra
.602 .797 .974 r
.39946 .44172 .38535 .44714 .4012 .45183 .41532 .44675 Metetra
.612 .799 .971 r
.38343 .43674 .36933 .44254 .38535 .44714 .39946 .44172 Metetra
.624 .802 .968 r
.36724 .43184 .35314 .43808 .36933 .44254 .38343 .43674 Metetra
.636 .806 .964 r
.35087 .42707 .33677 .43382 .35314 .43808 .36724 .43184 Metetra
.649 .81 .961 r
.33431 .42251 .32022 .42983 .33677 .43382 .35087 .42707 Metetra
.663 .815 .956 r
.31757 .41823 .30348 .42616 .32022 .42983 .33431 .42251 Metetra
.678 .821 .952 r
.30064 .4143 .28654 .42291 .30348 .42616 .31757 .41823 Metetra
.693 .828 .948 r
.2835 .41082 .26939 .42015 .28654 .42291 .30064 .4143 Metetra
.708 .836 .943 r
.26615 .4079 .25203 .41799 .26939 .42015 .2835 .41082 Metetra
.723 .845 .939 r
.24858 .40565 .23444 .41652 .25203 .41799 .26615 .4079 Metetra
.738 .855 .935 r
.23077 .40418 .21661 .41585 .23444 .41652 .24858 .40565 Metetra
.753 .866 .931 r
.21271 .40362 .19852 .41607 .21661 .41585 .23077 .40418 Metetra
.767 .88 .928 r
.19438 .40411 .18017 .41728 .19852 .41607 .21271 .40362 Metetra
.779 .894 .925 r
.17577 .40576 .16153 .41958 .18017 .41728 .19438 .40411 Metetra
.79 .911 .923 r
.15686 .40871 .14259 .42303 .16153 .41958 .17577 .40576 Metetra
.798 .93 .92 r
.13762 .41307 .12333 .42771 .14259 .42303 .15686 .40871 Metetra
.801 .951 .917 r
.11804 .41893 .10374 .43363 .12333 .42771 .13762 .41307 Metetra
.795 .972 .911 r
.09809 .42636 .0838 .44079 .10374 .43363 .11804 .41893 Metetra
.769 .988 .895 r
.07776 .43539 .06351 .44914 .0838 .44079 .09809 .42636 Metetra
.706 .985 .856 r
.05703 .44602 .04285 .45854 .06351 .44914 .07776 .43539 Metetra
.569 .927 .759 r
.03589 .45814 .02181 .46881 .04285 .45854 .05703 .44602 Metetra
.01432 .47159 .00042 .47966 .02181 .46881 .03589 .45814 Metetra
.553 .794 .988 r
.52147 .47226 .50714 .4761 .52191 .4807 .53625 .47692 Metetra
.555 .792 .987 r
.50654 .46747 .49222 .47139 .50714 .4761 .52147 .47226 Metetra
.558 .791 .986 r
.49146 .46258 .47715 .4666 .49222 .47139 .50654 .46747 Metetra
.562 .791 .985 r
.47623 .45757 .46193 .46172 .47715 .4666 .49146 .46258 Metetra
.567 .79 .983 r
.46084 .45245 .44655 .45678 .46193 .46172 .47623 .45757 Metetra
.574 .79 .981 r
.4453 .44724 .43101 .45178 .44655 .45678 .46084 .45245 Metetra
.581 .79 .979 r
.42959 .44196 .41532 .44675 .43101 .45178 .4453 .44724 Metetra
.59 .791 .976 r
.41372 .43663 .39946 .44172 .41532 .44675 .42959 .44196 Metetra
.6 .793 .973 r
.39768 .43128 .38343 .43674 .39946 .44172 .41372 .43663 Metetra
.611 .795 .969 r
.38148 .42595 .36724 .43184 .38343 .43674 .39768 .43128 Metetra
.624 .798 .966 r
.3651 .4207 .35087 .42707 .36724 .43184 .38148 .42595 Metetra
.637 .801 .961 r
.34855 .41557 .33431 .42251 .35087 .42707 .3651 .4207 Metetra
.652 .805 .957 r
.33181 .41065 .31757 .41823 .33431 .42251 .34855 .41557 Metetra
.667 .81 .952 r
.31488 .40601 .30064 .4143 .31757 .41823 .33181 .41065 Metetra
.683 .816 .946 r
.29775 .40175 .2835 .41082 .30064 .4143 .31488 .40601 Metetra
.7 .823 .941 r
.28041 .39797 .26615 .4079 .2835 .41082 .29775 .40175 Metetra
.717 .831 .935 r
.26286 .39481 .24858 .40565 .26615 .4079 .28041 .39797 Metetra
.734 .839 .93 r
.24507 .39238 .23077 .40418 .24858 .40565 .26286 .39481 Metetra
.75 .849 .924 r
.22704 .39084 .21271 .40362 .23077 .40418 .24507 .39238 Metetra
.767 .861 .919 r
.20875 .39034 .19438 .40411 .21271 .40362 .22704 .39084 Metetra
.783 .874 .914 r
.19018 .39103 .17577 .40576 .19438 .40411 .20875 .39034 Metetra
.799 .888 .909 r
.17131 .39309 .15686 .40871 .17577 .40576 .19018 .39103 Metetra
.813 .905 .905 r
.15211 .39668 .13762 .41307 .15686 .40871 .17131 .39309 Metetra
.825 .924 .9 r
.13257 .40195 .11804 .41893 .13762 .41307 .15211 .39668 Metetra
.834 .945 .895 r
.11266 .40905 .09809 .42636 .11804 .41893 .13257 .40195 Metetra
.835 .968 .887 r
.09234 .4181 .07776 .43539 .09809 .42636 .11266 .40905 Metetra
.824 .989 .873 r
.0716 .42918 .05703 .44602 .07776 .43539 .09234 .4181 Metetra
.784 .998 .839 r
.05041 .44232 .03589 .45814 .05703 .44602 .0716 .42918 Metetra
.684 .968 .761 r
.02875 .45749 .01432 .47159 .03589 .45814 .05041 .44232 Metetra
.547 .793 .99 r
.53596 .4685 .52147 .47226 .53625 .47692 .55075 .4732 Metetra
.548 .791 .989 r
.52102 .46367 .50654 .46747 .52147 .47226 .53596 .4685 Metetra
.55 .79 .988 r
.50594 .4587 .49146 .46258 .50654 .46747 .52102 .46367 Metetra
.553 .788 .986 r
.49069 .45359 .47623 .45757 .49146 .46258 .50594 .4587 Metetra
.557 .787 .985 r
.47529 .44835 .46084 .45245 .47623 .45757 .49069 .45359 Metetra
.562 .786 .983 r
.45973 .44298 .4453 .44724 .46084 .45245 .47529 .44835 Metetra
.569 .786 .981 r
.44402 .43748 .42959 .44196 .4453 .44724 .45973 .44298 Metetra
.577 .786 .978 r
.42813 .43188 .41372 .43663 .42959 .44196 .44402 .43748 Metetra
.586 .786 .975 r
.41209 .42621 .39768 .43128 .41372 .43663 .42813 .43188 Metetra
.597 .788 .972 r
.39587 .42049 .38148 .42595 .39768 .43128 .41209 .42621 Metetra
.609 .789 .968 r
.37949 .41477 .3651 .4207 .38148 .42595 .39587 .42049 Metetra
.623 .792 .963 r
.36292 .4091 .34855 .41557 .3651 .4207 .37949 .41477 Metetra
.637 .795 .958 r
.34618 .40355 .33181 .41065 .34855 .41557 .36292 .4091 Metetra
.653 .799 .953 r
.32925 .39819 .31488 .40601 .33181 .41065 .34618 .40355 Metetra
.67 .804 .947 r
.31213 .39311 .29775 .40175 .31488 .40601 .32925 .39819 Metetra
.687 .81 .941 r
.29481 .38843 .28041 .39797 .29775 .40175 .31213 .39311 Metetra
.705 .816 .934 r
.27727 .38427 .26286 .39481 .28041 .39797 .29481 .38843 Metetra
.724 .824 .927 r
.25951 .38076 .24507 .39238 .26286 .39481 .27727 .38427 Metetra
.742 .832 .92 r
.24152 .37807 .22704 .39084 .24507 .39238 .25951 .38076 Metetra
.761 .842 .913 r
.22327 .37636 .20875 .39034 .22704 .39084 .24152 .37807 Metetra
.779 .853 .906 r
.20474 .37582 .19018 .39103 .20875 .39034 .22327 .37636 Metetra
.798 .866 .899 r
.18593 .37665 .17131 .39309 .19018 .39103 .20474 .37582 Metetra
.815 .88 .892 r
.16679 .37905 .15211 .39668 .17131 .39309 .18593 .37665 Metetra
.832 .896 .886 r
.14732 .38324 .13257 .40195 .15211 .39668 .16679 .37905 Metetra
.847 .914 .879 r
.12746 .38942 .11266 .40905 .13257 .40195 .14732 .38324 Metetra
.86 .935 .872 r
.10721 .39779 .09234 .4181 .11266 .40905 .12746 .38942 Metetra
.868 .957 .862 r
.08651 .40854 .0716 .42918 .09234 .4181 .10721 .39779 Metetra
.867 .98 .847 r
.06534 .4218 .05041 .44232 .0716 .42918 .08651 .40854 Metetra
.846 .998 .818 r
.04367 .4377 .02875 .45749 .05041 .44232 .06534 .4218 Metetra
.542 .793 .991 r
.55061 .46481 .53596 .4685 .55075 .4732 .5654 .46951 Metetra
.542 .791 .99 r
.53567 .45996 .52102 .46367 .53596 .4685 .55061 .46481 Metetra
.543 .789 .989 r
.52057 .45495 .50594 .4587 .52102 .46367 .53567 .45996 Metetra
.545 .787 .988 r
.50532 .44979 .49069 .45359 .50594 .4587 .52057 .45495 Metetra
.547 .785 .987 r
.4899 .44446 .47529 .44835 .49069 .45359 .50532 .44979 Metetra
.551 .783 .985 r
.47433 .43896 .45973 .44298 .47529 .44835 .4899 .44446 Metetra
.556 .782 .983 r
.4586 .43331 .44402 .43748 .45973 .44298 .47433 .43896 Metetra
.563 .781 .981 r
.44271 .4275 .42813 .43188 .44402 .43748 .4586 .43331 Metetra
.571 .781 .978 r
.42665 .42155 .41209 .42621 .42813 .43188 .44271 .4275 Metetra
.581 .781 .974 r
.41042 .41549 .39587 .42049 .41209 .42621 .42665 .42155 Metetra
.592 .782 .97 r
.39402 .40936 .37949 .41477 .39587 .42049 .41042 .41549 Metetra
.605 .783 .966 r
.37745 .40319 .36292 .4091 .37949 .41477 .39402 .40936 Metetra
.62 .785 .961 r
.3607 .39704 .34618 .40355 .36292 .4091 .37745 .40319 Metetra
.636 .788 .955 r
.34377 .39098 .32925 .39819 .34618 .40355 .3607 .39704 Metetra
.653 .792 .949 r
.32665 .38509 .31213 .39311 .32925 .39819 .34377 .39098 Metetra
.671 .797 .942 r
.30934 .37949 .29481 .38843 .31213 .39311 .32665 .38509 Metetra
.69 .802 .934 r
.29181 .37429 .27727 .38427 .29481 .38843 .30934 .37949 Metetra
.709 .808 .927 r
.27408 .36963 .25951 .38076 .27727 .38427 .29181 .37429 Metetra
.729 .816 .918 r
.25611 .36567 .24152 .37807 .25951 .38076 .27408 .36963 Metetra
.749 .824 .91 r
.23791 .36259 .22327 .37636 .24152 .37807 .25611 .36567 Metetra
.769 .833 .901 r
.21944 .36059 .20474 .37582 .22327 .37636 .23791 .36259 Metetra
.789 .844 .893 r
.20069 .3599 .18593 .37665 .20474 .37582 .21944 .36059 Metetra
.809 .856 .884 r
.18163 .36075 .16679 .37905 .18593 .37665 .20069 .3599 Metetra
.828 .869 .875 r
.16223 .3634 .14732 .38324 .16679 .37905 .18163 .36075 Metetra
.847 .884 .867 r
.14247 .3681 .12746 .38942 .14732 .38324 .16223 .3634 Metetra
.864 .901 .858 r
.1223 .37515 .10721 .39779 .12746 .38942 .14247 .3681 Metetra
.88 .921 .848 r
.1017 .38479 .08651 .40854 .10721 .39779 .1223 .37515 Metetra
.893 .942 .837 r
.08061 .39729 .06534 .4218 .08651 .40854 .1017 .38479 Metetra
.899 .965 .821 r
.059 .41288 .04367 .4377 .06534 .4218 .08061 .39729 Metetra
.539 .794 .992 r
.56542 .46114 .55061 .46481 .5654 .46951 .58022 .46582 Metetra
.537 .791 .991 r
.55047 .4563 .53567 .45996 .55061 .46481 .56542 .46114 Metetra
.537 .789 .991 r
.53537 .4513 .52057 .45495 .53567 .45996 .55047 .4563 Metetra
.537 .786 .99 r
.5201 .44612 .50532 .44979 .52057 .45495 .53537 .4513 Metetra
.538 .784 .989 r
.50468 .44075 .4899 .44446 .50532 .44979 .5201 .44612 Metetra
.54 .781 .987 r
.4891 .43518 .47433 .43896 .4899 .44446 .50468 .44075 Metetra
.543 .779 .985 r
.47335 .42942 .4586 .43331 .47433 .43896 .4891 .43518 Metetra
.548 .777 .983 r
.45745 .42345 .44271 .4275 .4586 .43331 .47335 .42942 Metetra
.555 .775 .981 r
.44137 .4173 .42665 .42155 .44271 .4275 .45745 .42345 Metetra
.563 .775 .978 r
.42513 .41097 .41042 .41549 .42665 .42155 .44137 .4173 Metetra
.574 .774 .974 r
.40872 .40448 .39402 .40936 .41042 .41549 .42513 .41097 Metetra
.586 .775 .969 r
.39213 .39788 .37745 .40319 .39402 .40936 .40872 .40448 Metetra
.6 .776 .964 r
.37537 .39119 .3607 .39704 .37745 .40319 .39213 .39788 Metetra
.615 .777 .959 r
.35844 .38449 .34377 .39098 .3607 .39704 .37537 .39119 Metetra
.632 .78 .952 r
.34131 .37784 .32665 .38509 .34377 .39098 .35844 .38449 Metetra
.651 .784 .945 r
.324 .37134 .30934 .37949 .32665 .38509 .34131 .37784 Metetra
.67 .788 .937 r
.30649 .3651 .29181 .37429 .30934 .37949 .324 .37134 Metetra
.691 .793 .928 r
.28877 .35925 .27408 .36963 .29181 .37429 .30649 .3651 Metetra
.712 .799 .919 r
.27084 .35396 .25611 .36567 .27408 .36963 .28877 .35925 Metetra
.733 .806 .91 r
.25267 .34941 .23791 .36259 .25611 .36567 .27084 .35396 Metetra
.754 .814 .9 r
.23425 .3458 .21944 .36059 .23791 .36259 .25267 .34941 Metetra
.776 .823 .889 r
.21557 .34336 .20069 .3599 .21944 .36059 .23425 .3458 Metetra
.797 .833 .879 r
.19659 .34236 .18163 .36075 .20069 .3599 .21557 .34336 Metetra
.818 .844 .869 r
.17729 .34309 .16223 .3634 .18163 .36075 .19659 .34236 Metetra
.838 .856 .858 r
.15763 .34585 .14247 .3681 .16223 .3634 .17729 .34309 Metetra
.858 .87 .848 r
.13759 .35096 .1223 .37515 .14247 .3681 .15763 .34585 Metetra
.877 .886 .837 r
.11711 .35878 .1017 .38479 .1223 .37515 .13759 .35096 Metetra
.894 .904 .826 r
.09615 .36965 .08061 .39729 .1017 .38479 .11711 .35878 Metetra
.91 .924 .812 r
.07467 .38391 .059 .41288 .08061 .39729 .09615 .36965 Metetra
.536 .795 .993 r
.5804 .45747 .56542 .46114 .58022 .46582 .5952 .46211 Metetra
.533 .792 .992 r
.56545 .45267 .55047 .4563 .56542 .46114 .5804 .45747 Metetra
.531 .789 .992 r
.55033 .4477 .53537 .4513 .55047 .4563 .56545 .45267 Metetra
.53 .786 .991 r
.53506 .44254 .5201 .44612 .53537 .4513 .55033 .4477 Metetra
.529 .783 .99 r
.51963 .43717 .50468 .44075 .5201 .44612 .53506 .44254 Metetra
.529 .78 .989 r
.50403 .43159 .4891 .43518 .50468 .44075 .51963 .43717 Metetra
.531 .777 .988 r
.48828 .42578 .47335 .42942 .4891 .43518 .50403 .43159 Metetra
.534 .774 .986 r
.47235 .41973 .45745 .42345 .47335 .42942 .48828 .42578 Metetra
.539 .771 .984 r
.45626 .41344 .44137 .4173 .45745 .42345 .47235 .41973 Metetra
.545 .769 .981 r
.44 .40691 .42513 .41097 .44137 .4173 .45626 .41344 Metetra
.554 .767 .977 r
.42358 .40015 .40872 .40448 .42513 .41097 .44 .40691 Metetra
.564 .767 .973 r
.40698 .39319 .39213 .39788 .40872 .40448 .42358 .40015 Metetra
.577 .766 .969 r
.3902 .38606 .37537 .39119 .39213 .39788 .40698 .39319 Metetra
.592 .767 .963 r
.37325 .37879 .35844 .38449 .37537 .39119 .3902 .38606 Metetra
.608 .768 .956 r
.35612 .37144 .34131 .37784 .35844 .38449 .37325 .37879 Metetra
.627 .771 .949 r
.33881 .36411 .324 .37134 .34131 .37784 .35612 .37144 Metetra
.647 .774 .941 r
.3213 .35688 .30649 .3651 .324 .37134 .33881 .36411 Metetra
.668 .778 .932 r
.30359 .34988 .28877 .35925 .30649 .3651 .3213 .35688 Metetra
.689 .783 .922 r
.28568 .34326 .27084 .35396 .28877 .35925 .30359 .34988 Metetra
.712 .789 .912 r
.26755 .33719 .25267 .34941 .27084 .35396 .28568 .34326 Metetra
.734 .795 .901 r
.24918 .33187 .23425 .3458 .25267 .34941 .26755 .33719 Metetra
.757 .803 .89 r
.23055 .32755 .21557 .34336 .23425 .3458 .24918 .33187 Metetra
.78 .811 .878 r
.21165 .3245 .19659 .34236 .21557 .34336 .23055 .32755 Metetra
.802 .821 .866 r
.19245 .323 .17729 .34309 .19659 .34236 .21165 .3245 Metetra
.823 .831 .854 r
.17292 .32342 .15763 .34585 .17729 .34309 .19245 .323 Metetra
.845 .842 .842 r
.15301 .3261 .13759 .35096 .15763 .34585 .17292 .32342 Metetra
.865 .855 .83 r
.13269 .33146 .11711 .35878 .13759 .35096 .15301 .3261 Metetra
.885 .87 .818 r
.1119 .33991 .09615 .36965 .11711 .35878 .13269 .33146 Metetra
.904 .886 .804 r
.0906 .3519 .07467 .38391 .09615 .36965 .1119 .33991 Metetra
.535 .797 .994 r
.59555 .45376 .5804 .45747 .5952 .46211 .61035 .45833 Metetra
.531 .794 .993 r
.58059 .44902 .56545 .45267 .5804 .45747 .59555 .45376 Metetra
.528 .791 .993 r
.56547 .44411 .55033 .4477 .56545 .45267 .58059 .44902 Metetra
.525 .787 .993 r
.55019 .43901 .53506 .44254 .55033 .4477 .56547 .44411 Metetra
.522 .784 .992 r
.53475 .43369 .51963 .43717 .53506 .44254 .55019 .43901 Metetra
.521 .78 .991 r
.51914 .42814 .50403 .43159 .51963 .43717 .53475 .43369 Metetra
.52 .776 .99 r
.50337 .42234 .48828 .42578 .50403 .43159 .51914 .42814 Metetra
.521 .772 .988 r
.48743 .41627 .47235 .41973 .48828 .42578 .50337 .42234 Metetra
.523 .768 .986 r
.47133 .40992 .45626 .41344 .47235 .41973 .48743 .41627 Metetra
.527 .765 .984 r
.45505 .40328 .44 .40691 .45626 .41344 .47133 .40992 Metetra
.533 .762 .981 r
.43861 .39635 .42358 .40015 .44 .40691 .45505 .40328 Metetra
.542 .759 .977 r
.42199 .38913 .40698 .39319 .42358 .40015 .43861 .39635 Metetra
.552 .758 .973 r
.4052 .38164 .3902 .38606 .40698 .39319 .42199 .38913 Metetra
.566 .757 .968 r
.38823 .37391 .37325 .37879 .3902 .38606 .4052 .38164 Metetra
.581 .757 .962 r
.37109 .36598 .35612 .37144 .37325 .37879 .38823 .37391 Metetra
.599 .758 .955 r
.35376 .35792 .33881 .36411 .35612 .37144 .37109 .36598 Metetra
.619 .76 .946 r
.33625 .34979 .3213 .35688 .33881 .36411 .35376 .35792 Metetra
.64 .763 .937 r
.31855 .34171 .30359 .34988 .3213 .35688 .33625 .34979 Metetra
.662 .767 .927 r
.30065 .33381 .28568 .34326 .30359 .34988 .31855 .34171 Metetra
.686 .771 .916 r
.28254 .32625 .26755 .33719 .28568 .34326 .30065 .33381 Metetra
.71 .777 .905 r
.26421 .31922 .24918 .33187 .26755 .33719 .28254 .32625 Metetra
.734 .783 .892 r
.24564 .31295 .23055 .32755 .24918 .33187 .26421 .31922 Metetra
.757 .79 .88 r
.22682 .30771 .21165 .3245 .23055 .32755 .24564 .31295 Metetra
.781 .798 .867 r
.20771 .3038 .19245 .323 .21165 .3245 .22682 .30771 Metetra
.804 .807 .853 r
.1883 .30159 .17292 .32342 .19245 .323 .20771 .3038 Metetra
.827 .817 .84 r
.16853 .30145 .15301 .3261 .17292 .32342 .1883 .30159 Metetra
.848 .827 .827 r
.14838 .30383 .13269 .33146 .15301 .3261 .16853 .30145 Metetra
.869 .839 .813 r
.12779 .3092 .1119 .33991 .13269 .33146 .14838 .30383 Metetra
.89 .853 .8 r
.10671 .31808 .0906 .3519 .1119 .33991 .12779 .3092 Metetra
.535 .8 .994 r
.61087 .44996 .59555 .45376 .61035 .45833 .62567 .45447 Metetra
.53 .797 .994 r
.5959 .44531 .58059 .44902 .59555 .45376 .61087 .44996 Metetra
.526 .793 .994 r
.58078 .44049 .56547 .44411 .58059 .44902 .5959 .44531 Metetra
.521 .79 .994 r
.56549 .43547 .55019 .43901 .56547 .44411 .58078 .44049 Metetra
.517 .785 .994 r
.55004 .43024 .53475 .43369 .55019 .43901 .56549 .43547 Metetra
.513 .781 .993 r
.53443 .42477 .51914 .42814 .53475 .43369 .55004 .43024 Metetra
.511 .776 .992 r
.51865 .41904 .50337 .42234 .51914 .42814 .53443 .42477 Metetra
.509 .771 .991 r
.50269 .41302 .48743 .41627 .50337 .42234 .51865 .41904 Metetra
.508 .766 .989 r
.48657 .40668 .47133 .40992 .48743 .41627 .50269 .41302 Metetra
.509 .762 .987 r
.47028 .40002 .45505 .40328 .47133 .40992 .48657 .40668 Metetra
.513 .757 .985 r
.45381 .39301 .43861 .39635 .45505 .40328 .47028 .40002 Metetra
.518 .753 .981 r
.43718 .38564 .42199 .38913 .43861 .39635 .45381 .39301 Metetra
.527 .75 .977 r
.42036 .37792 .4052 .38164 .42199 .38913 .43718 .38564 Metetra
.538 .747 .973 r
.40338 .36986 .38823 .37391 .4052 .38164 .42036 .37792 Metetra
.551 .746 .967 r
.38621 .36147 .37109 .36598 .38823 .37391 .40338 .36986 Metetra
.568 .745 .96 r
.36887 .3528 .35376 .35792 .37109 .36598 .38621 .36147 Metetra
.586 .746 .953 r
.35135 .34391 .33625 .34979 .35376 .35792 .36887 .3528 Metetra
.607 .747 .944 r
.33364 .33488 .31855 .34171 .33625 .34979 .35135 .34391 Metetra
.63 .75 .934 r
.31574 .32581 .30065 .33381 .31855 .34171 .33364 .33488 Metetra
.654 .753 .923 r
.29765 .31685 .28254 .32625 .30065 .33381 .31574 .32581 Metetra
.679 .758 .91 r
.27934 .30816 .26421 .31922 .28254 .32625 .29765 .31685 Metetra
.705 .763 .898 r
.26082 .29997 .24564 .31295 .26421 .31922 .27934 .30816 Metetra
.73 .769 .884 r
.24206 .29252 .22682 .30771 .24564 .31295 .26082 .29997 Metetra
.755 .776 .87 r
.22304 .28611 .20771 .3038 .22682 .30771 .24206 .29252 Metetra
.78 .784 .856 r
.20374 .2811 .1883 .30159 .20771 .3038 .22304 .28611 Metetra
.804 .792 .842 r
.18412 .27787 .16853 .30145 .1883 .30159 .20374 .2811 Metetra
.827 .802 .827 r
.16415 .27688 .14838 .30383 .16853 .30145 .18412 .27787 Metetra
.849 .812 .813 r
.14377 .27865 .12779 .3092 .14838 .30383 .16415 .27688 Metetra
.871 .823 .798 r
.12292 .28373 .10671 .31808 .12779 .3092 .14377 .27865 Metetra
.536 .803 .995 r
.62635 .44605 .61087 .44996 .62567 .45447 .64116 .45047 Metetra
.531 .8 .995 r
.61139 .44149 .5959 .44531 .61087 .44996 .62635 .44605 Metetra
.526 .797 .995 r
.59627 .43677 .58078 .44049 .5959 .44531 .61139 .44149 Metetra
.52 .793 .995 r
.58098 .43187 .56549 .43547 .58078 .44049 .59627 .43677 Metetra
.514 .788 .995 r
.56552 .42677 .55004 .43024 .56549 .43547 .58098 .43187 Metetra
.509 .783 .994 r
.5499 .42142 .53443 .42477 .55004 .43024 .56552 .42677 Metetra
.504 .778 .994 r
.5341 .41581 .51865 .41904 .53443 .42477 .5499 .42142 Metetra
.499 .772 .993 r
.51814 .40989 .50269 .41302 .51865 .41904 .5341 .41581 Metetra
.496 .766 .992 r
.502 .40365 .48657 .40668 .50269 .41302 .51814 .40989 Metetra
.494 .76 .99 r
.48569 .39705 .47028 .40002 .48657 .40668 .502 .40365 Metetra
.493 .754 .988 r
.46921 .39006 .45381 .39301 .47028 .40002 .48569 .39705 Metetra
.496 .748 .985 r
.45255 .38266 .43718 .38564 .45381 .39301 .46921 .39006 Metetra
.5 .743 .982 r
.43571 .37484 .42036 .37792 .43718 .38564 .45255 .38266 Metetra
.508 .739 .978 r
.4187 .36658 .40338 .36986 .42036 .37792 .43571 .37484 Metetra
.519 .735 .973 r
.40151 .35788 .38621 .36147 .40338 .36986 .4187 .36658 Metetra
.533 .733 .967 r
.38415 .34877 .36887 .3528 .38621 .36147 .40151 .35788 Metetra
.55 .732 .959 r
.36661 .33927 .35135 .34391 .36887 .3528 .38415 .34877 Metetra
.57 .731 .951 r
.34888 .32945 .33364 .33488 .35135 .34391 .36661 .33927 Metetra
.593 .733 .941 r
.33098 .31938 .31574 .32581 .33364 .33488 .34888 .32945 Metetra
.617 .735 .93 r
.31288 .30917 .29765 .31685 .31574 .32581 .33098 .31938 Metetra
.643 .738 .918 r
.29459 .29897 .27934 .30816 .29765 .31685 .31288 .30917 Metetra
.67 .743 .905 r
.2761 .28896 .26082 .29997 .27934 .30816 .29459 .29897 Metetra
.697 .748 .891 r
.25739 .27938 .24206 .29252 .26082 .29997 .2761 .28896 Metetra
.724 .754 .876 r
.23844 .27048 .22304 .28611 .24206 .29252 .25739 .27938 Metetra
.75 .761 .861 r
.21924 .26262 .20374 .2811 .22304 .28611 .23844 .27048 Metetra
.776 .768 .846 r
.19975 .25617 .18412 .27787 .20374 .2811 .21924 .26262 Metetra
.801 .777 .83 r
.17994 .25159 .16415 .27688 .18412 .27787 .19975 .25617 Metetra
.825 .786 .815 r
.15977 .2494 .14377 .27865 .16415 .27688 .17994 .25159 Metetra
.848 .795 .8 r
.13918 .25018 .12292 .28373 .14377 .27865 .15977 .2494 Metetra
.539 .806 .995 r
.64202 .44198 .62635 .44605 .64116 .45047 .65682 .44632 Metetra
.534 .804 .995 r
.62706 .43752 .61139 .44149 .62635 .44605 .64202 .44198 Metetra
.528 .8 .996 r
.61193 .43293 .59627 .43677 .61139 .44149 .62706 .43752 Metetra
.521 .797 .996 r
.59664 .42816 .58098 .43187 .59627 .43677 .61193 .43293 Metetra
.514 .792 .996 r
.58118 .4232 .56552 .42677 .58098 .43187 .59664 .42816 Metetra
.507 .787 .996 r
.56555 .41801 .5499 .42142 .56552 .42677 .58118 .4232 Metetra
.499 .781 .995 r
.54975 .41256 .5341 .41581 .5499 .42142 .56555 .41801 Metetra
.492 .775 .995 r
.53377 .40682 .51814 .40989 .5341 .41581 .54975 .41256 Metetra
.486 .768 .994 r
.51762 .40073 .502 .40365 .51814 .40989 .53377 .40682 Metetra
.48 .76 .992 r
.50129 .39428 .48569 .39705 .502 .40365 .51762 .40073 Metetra
.476 .753 .99 r
.48479 .38741 .46921 .39006 .48569 .39705 .50129 .39428 Metetra
.475 .745 .988 r
.46811 .38009 .45255 .38266 .46921 .39006 .48479 .38741 Metetra
.475 .738 .985 r
.45125 .37229 .43571 .37484 .45255 .38266 .46811 .38009 Metetra
.479 .732 .982 r
.43421 .36398 .4187 .36658 .43571 .37484 .45125 .37229 Metetra
.485 .726 .977 r
.417 .35514 .40151 .35788 .4187 .36658 .43421 .36398 Metetra
.496 .721 .972 r
.3996 .34576 .38415 .34877 .40151 .35788 .417 .35514 Metetra
.51 .717 .966 r
.38203 .33586 .36661 .33927 .38415 .34877 .3996 .34576 Metetra
.528 .715 .958 r
.36429 .32544 .34888 .32945 .36661 .33927 .38203 .33586 Metetra
.549 .715 .949 r
.34636 .31458 .33098 .31938 .34888 .32945 .36429 .32544 Metetra
.573 .715 .939 r
.32825 .30333 .31288 .30917 .33098 .31938 .34636 .31458 Metetra
.6 .717 .927 r
.30996 .29182 .29459 .29897 .31288 .30917 .32825 .30333 Metetra
.628 .721 .914 r
.29148 .28018 .2761 .28896 .29459 .29897 .30996 .29182 Metetra
.656 .725 .9 r
.2728 .26862 .25739 .27938 .2761 .28896 .29148 .28018 Metetra
.686 .731 .885 r
.25391 .25737 .23844 .27048 .25739 .27938 .2728 .26862 Metetra
.715 .737 .869 r
.23479 .24674 .21924 .26262 .23844 .27048 .25391 .25737 Metetra
.743 .744 .853 r
.21541 .23709 .19975 .25617 .21924 .26262 .23479 .24674 Metetra
.77 .752 .836 r
.19575 .22884 .17994 .25159 .19975 .25617 .21541 .23709 Metetra
.796 .76 .82 r
.17578 .22251 .15977 .2494 .17994 .25159 .19575 .22884 Metetra
.821 .769 .804 r
.15543 .21868 .13918 .25018 .15977 .2494 .17578 .22251 Metetra
.544 .81 .995 r
.65786 .43774 .64202 .44198 .65682 .44632 .67266 .442 Metetra
.538 .807 .996 r
.6429 .43338 .62706 .43752 .64202 .44198 .65786 .43774 Metetra
.531 .805 .996 r
.62778 .4289 .61193 .43293 .62706 .43752 .6429 .43338 Metetra
.524 .801 .996 r
.61248 .42428 .59664 .42816 .61193 .43293 .62778 .4289 Metetra
.516 .797 .997 r
.59702 .41948 .58118 .4232 .59664 .42816 .61248 .42428 Metetra
.507 .792 .997 r
.58139 .41447 .56555 .41801 .58118 .4232 .59702 .41948 Metetra
.498 .786 .997 r
.56558 .40923 .54975 .41256 .56555 .41801 .58139 .41447 Metetra
.489 .779 .996 r
.5496 .40369 .53377 .40682 .54975 .41256 .56558 .40923 Metetra
.48 .771 .995 r
.53343 .39783 .51762 .40073 .53377 .40682 .5496 .40369 Metetra
.471 .763 .994 r
.51709 .39159 .50129 .39428 .51762 .40073 .53343 .39783 Metetra
.463 .754 .993 r
.50057 .38494 .48479 .38741 .50129 .39428 .51709 .39159 Metetra
.456 .745 .991 r
.48387 .37781 .46811 .38009 .48479 .38741 .50057 .38494 Metetra
.452 .735 .988 r
.46698 .37016 .45125 .37229 .46811 .38009 .48387 .37781 Metetra
.45 .726 .985 r
.44992 .36195 .43421 .36398 .45125 .37229 .46698 .37016 Metetra
.452 .718 .981 r
.43267 .35313 .417 .35514 .43421 .36398 .44992 .36195 Metetra
.457 .71 .977 r
.41525 .34368 .3996 .34576 .417 .35514 .43267 .35313 Metetra
.467 .704 .971 r
.39765 .33357 .38203 .33586 .3996 .34576 .41525 .34368 Metetra
.481 .699 .965 r
.37987 .3228 .36429 .32544 .38203 .33586 .39765 .33357 Metetra
.5 .696 .957 r
.36191 .31138 .34636 .31458 .36429 .32544 .37987 .3228 Metetra
.522 .695 .947 r
.34378 .29935 .32825 .30333 .34636 .31458 .36191 .31138 Metetra
.548 .695 .936 r
.32547 .28678 .30996 .29182 .32825 .30333 .34378 .29935 Metetra
.577 .697 .924 r
.30699 .27378 .29148 .28018 .30996 .29182 .32547 .28678 Metetra
.607 .701 .91 r
.28831 .2605 .2728 .26862 .29148 .28018 .30699 .27378 Metetra
.639 .705 .895 r
.26945 .24713 .25391 .25737 .2728 .26862 .28831 .2605 Metetra
.67 .711 .879 r
.25038 .23392 .23479 .24674 .25391 .25737 .26945 .24713 Metetra
.702 .718 .862 r
.2311 .22121 .21541 .23709 .23479 .24674 .25038 .23392 Metetra
.732 .725 .845 r
.21156 .20939 .19575 .22884 .21541 .23709 .2311 .22121 Metetra
.761 .734 .828 r
.19175 .19892 .17578 .22251 .19575 .22884 .21156 .20939 Metetra
.788 .742 .811 r
.17163 .19037 .15543 .21868 .17578 .22251 .19175 .19892 Metetra
.549 .813 .995 r
.67388 .43328 .65786 .43774 .67266 .442 .68867 .43747 Metetra
.543 .811 .996 r
.65892 .42902 .6429 .43338 .65786 .43774 .67388 .43328 Metetra
.537 .809 .996 r
.6438 .42466 .62778 .4289 .6429 .43338 .65892 .42902 Metetra
.529 .806 .997 r
.62851 .42018 .61248 .42428 .62778 .4289 .6438 .42466 Metetra
.521 .802 .997 r
.61305 .41555 .59702 .41948 .61248 .42428 .62851 .42018 Metetra
.511 .798 .997 r
.59742 .41074 .58139 .41447 .59702 .41948 .61305 .41555 Metetra
.501 .792 .997 r
.5816 .40571 .56558 .40923 .58139 .41447 .59742 .41074 Metetra
.489 .785 .997 r
.56561 .40043 .5496 .40369 .56558 .40923 .5816 .40571 Metetra
.478 .777 .997 r
.54944 .39483 .53343 .39783 .5496 .40369 .56561 .40043 Metetra
.466 .768 .996 r
.53309 .38888 .51709 .39159 .53343 .39783 .54944 .39483 Metetra
.454 .758 .995 r
.51655 .38251 .50057 .38494 .51709 .39159 .53309 .38888 Metetra
.442 .747 .993 r
.49983 .37567 .48387 .37781 .50057 .38494 .51655 .38251 Metetra
.433 .735 .99 r
.48292 .3683 .46698 .37016 .48387 .37781 .49983 .37567 Metetra
.425 .724 .988 r
.46583 .36033 .44992 .36195 .46698 .37016 .48292 .3683 Metetra
.42 .712 .984 r
.44855 .3517 .43267 .35313 .44992 .36195 .46583 .36033 Metetra
.419 .701 .98 r
.43109 .34237 .41525 .34368 .43267 .35313 .44855 .3517 Metetra
.423 .691 .975 r
.41345 .33227 .39765 .33357 .41525 .34368 .43109 .34237 Metetra
.431 .683 .969 r
.39564 .32139 .37987 .3228 .39765 .33357 .41345 .33227 Metetra
.445 .677 .962 r
.37764 .30968 .36191 .31138 .37987 .3228 .39564 .32139 Metetra
.464 .672 .954 r
.35948 .29716 .34378 .29935 .36191 .31138 .37764 .30968 Metetra
.488 .67 .944 r
.34114 .28385 .32547 .28678 .34378 .29935 .35948 .29716 Metetra
.516 .67 .933 r
.32263 .26981 .30699 .27378 .32547 .28678 .34114 .28385 Metetra
.548 .673 .92 r
.30394 .25513 .28831 .2605 .30699 .27378 .32263 .26981 Metetra
.581 .677 .905 r
.28509 .23996 .26945 .24713 .28831 .2605 .30394 .25513 Metetra
.616 .682 .89 r
.26605 .2245 .25038 .23392 .26945 .24713 .28509 .23996 Metetra
.65 .689 .873 r
.24681 .20901 .2311 .22121 .25038 .23392 .26605 .2245 Metetra
.684 .697 .855 r
.22737 .19385 .21156 .20939 .2311 .22121 .24681 .20901 Metetra
.717 .705 .838 r
.2077 .17942 .19175 .19892 .21156 .20939 .22737 .19385 Metetra
.748 .714 .82 r
.18776 .16624 .17163 .19037 .19175 .19892 .2077 .17942 Metetra
.555 .816 .994 r
.69008 .42861 .67388 .43328 .68867 .43747 .70486 .43275 Metetra
.55 .815 .995 r
.67513 .42442 .65892 .42902 .67388 .43328 .69008 .42861 Metetra
.543 .814 .996 r
.66001 .42016 .6438 .42466 .65892 .42902 .67513 .42442 Metetra
.536 .811 .997 r
.64473 .41582 .62851 .42018 .6438 .42466 .66001 .42016 Metetra
.527 .808 .997 r
.62927 .41136 .61305 .41555 .62851 .42018 .64473 .41582 Metetra
.517 .804 .998 r
.61363 .40675 .59742 .41074 .61305 .41555 .62927 .41136 Metetra
.506 .799 .998 r
.59782 .40195 .5816 .40571 .59742 .41074 .61363 .40675 Metetra
.494 .792 .998 r
.58183 .39693 .56561 .40043 .5816 .40571 .59782 .40195 Metetra
.48 .784 .998 r
.56565 .39164 .54944 .39483 .56561 .40043 .58183 .39693 Metetra
.465 .775 .997 r
.54929 .38602 .53309 .38888 .54944 .39483 .56565 .39164 Metetra
.45 .764 .996 r
.53273 .38 .51655 .38251 .53309 .38888 .54929 .38602 Metetra
.434 .752 .994 r
.516 .37353 .49983 .37567 .51655 .38251 .53273 .38 Metetra
.419 .739 .992 r
.49907 .36654 .48292 .3683 .49983 .37567 .516 .37353 Metetra
.405 .724 .989 r
.48195 .35894 .46583 .36033 .48292 .3683 .49907 .36654 Metetra
.393 .71 .986 r
.46464 .35066 .44855 .3517 .46583 .36033 .48195 .35894 Metetra
.384 .695 .982 r
.44715 .34163 .43109 .34237 .44855 .3517 .46464 .35066 Metetra
.38 .681 .977 r
.42947 .33178 .41345 .33227 .43109 .34237 .44715 .34163 Metetra
.38 .668 .972 r
.41161 .32102 .39564 .32139 .41345 .33227 .42947 .33178 Metetra
.387 .657 .965 r
.39357 .30932 .37764 .30968 .39564 .32139 .41161 .32102 Metetra
.4 .649 .958 r
.37536 .29662 .35948 .29716 .37764 .30968 .39357 .30932 Metetra
.419 .643 .95 r
.35698 .28291 .34114 .28385 .35948 .29716 .37536 .29662 Metetra
.445 .64 .94 r
.33843 .26819 .32263 .26981 .34114 .28385 .35698 .28291 Metetra
.476 .641 .928 r
.31971 .2525 .30394 .25513 .32263 .26981 .33843 .26819 Metetra
.51 .643 .915 r
.30083 .23594 .28509 .23996 .30394 .25513 .31971 .2525 Metetra
.548 .648 .9 r
.28179 .21863 .26605 .2245 .28509 .23996 .30083 .23594 Metetra
.586 .655 .884 r
.26258 .20078 .24681 .20901 .26605 .2245 .28179 .21863 Metetra
.625 .663 .867 r
.24319 .18266 .22737 .19385 .24681 .20901 .26258 .20078 Metetra
.662 .672 .849 r
.22361 .16461 .2077 .17942 .22737 .19385 .24319 .18266 Metetra
.698 .682 .831 r
.20382 .1471 .18776 .16624 .2077 .17942 .22361 .16461 Metetra
.561 .819 .994 r
.70646 .4237 .69008 .42861 .70486 .43275 .72123 .42781 Metetra
.556 .819 .995 r
.69152 .41957 .67513 .42442 .69008 .42861 .70646 .4237 Metetra
.551 .818 .996 r
.67641 .4154 .66001 .42016 .67513 .42442 .69152 .41957 Metetra
.544 .816 .996 r
.66113 .41117 .64473 .41582 .66001 .42016 .67641 .4154 Metetra
.536 .814 .997 r
.64567 .40686 .62927 .41136 .64473 .41582 .66113 .41117 Metetra
.526 .811 .998 r
.63004 .40244 .61363 .40675 .62927 .41136 .64567 .40686 Metetra
.515 .806 .998 r
.61423 .39787 .59782 .40195 .61363 .40675 .63004 .40244 Metetra
.502 .8 .999 r
.59824 .39313 .58183 .39693 .59782 .40195 .61423 .39787 Metetra
.487 .793 .999 r
.58206 .38815 .56565 .39164 .58183 .39693 .59824 .39313 Metetra
.47 .784 .998 r
.56569 .38288 .54929 .38602 .56565 .39164 .58206 .38815 Metetra
.452 .773 .997 r
.54913 .37727 .53273 .38 .54929 .38602 .56569 .38288 Metetra
.432 .76 .996 r
.53238 .37124 .516 .37353 .53273 .38 .54913 .37727 Metetra
.412 .746 .994 r
.51543 .3647 .49907 .36654 .516 .37353 .53238 .37124 Metetra
.392 .729 .99 r
.49829 .35759 .48195 .35894 .49907 .36654 .51543 .3647 Metetra
.372 .711 .987 r
.48095 .3498 .46464 .35066 .48195 .35894 .49829 .35759 Metetra
.355 .693 .982 r
.46343 .34125 .44715 .34163 .46464 .35066 .48095 .3498 Metetra
.34 .674 .977 r
.44571 .33184 .42947 .33178 .44715 .34163 .46343 .34125 Metetra
.331 .656 .971 r
.4278 .32146 .41161 .32102 .42947 .33178 .44571 .33184 Metetra
.328 .639 .965 r
.40972 .31004 .39357 .30932 .41161 .32102 .4278 .32146 Metetra
.331 .625 .958 r
.39145 .29749 .37536 .29662 .39357 .30932 .40972 .31004 Metetra
.343 .614 .951 r
.37301 .28374 .35698 .28291 .37536 .29662 .39145 .29749 Metetra
.362 .607 .942 r
.35441 .26875 .33843 .26819 .35698 .28291 .37301 .28374 Metetra
.39 .603 .933 r
.33564 .2525 .31971 .2525 .33843 .26819 .35441 .26875 Metetra
.423 .603 .921 r
.31672 .23501 .30083 .23594 .31971 .2525 .33564 .2525 Metetra
.462 .607 .909 r
.29765 .21635 .28179 .21863 .30083 .23594 .31672 .23501 Metetra
.504 .613 .894 r
.27842 .19664 .26258 .20078 .28179 .21863 .29765 .21635 Metetra
.548 .622 .878 r
.25905 .17607 .24319 .18266 .26258 .20078 .27842 .19664 Metetra
.591 .632 .86 r
.23952 .15491 .22361 .16461 .24319 .18266 .25905 .17607 Metetra
.634 .644 .842 r
.21982 .13353 .20382 .1471 .22361 .16461 .23952 .15491 Metetra
.567 .821 .993 r
.72302 .41857 .70646 .4237 .72123 .42781 .73779 .42267 Metetra
.564 .822 .994 r
.70809 .41446 .69152 .41957 .70646 .4237 .72302 .41857 Metetra
.559 .821 .995 r
.69299 .41035 .67641 .4154 .69152 .41957 .70809 .41446 Metetra
.553 .821 .996 r
.67772 .40621 .66113 .41117 .67641 .4154 .69299 .41035 Metetra
.546 .819 .997 r
.66227 .40202 .64567 .40686 .66113 .41117 .67772 .40621 Metetra
.537 .817 .998 r
.64664 .39777 .63004 .40244 .64567 .40686 .66227 .40202 Metetra
.526 .814 .998 r
.63084 .39342 .61423 .39787 .63004 .40244 .64664 .39777 Metetra
.513 .809 .999 r
.61485 .38893 .59824 .39313 .61423 .39787 .63084 .39342 Metetra
.497 .803 .999 r
.59867 .38427 .58206 .38815 .59824 .39313 .61485 .38893 Metetra
.48 .795 .999 r
.5823 .37937 .56569 .38288 .58206 .38815 .59867 .38427 Metetra
.46 .784 .999 r
.56573 .37418 .54913 .37727 .56569 .38288 .5823 .37937 Metetra
.438 .772 .997 r
.54897 .36862 .53238 .37124 .54913 .37727 .56573 .37418 Metetra
.413 .757 .995 r
.53201 .36262 .51543 .3647 .53238 .37124 .54897 .36862 Metetra
.387 .739 .991 r
.51485 .35608 .49829 .35759 .51543 .3647 .53201 .36262 Metetra
.36 .718 .987 r
.49749 .3489 .48095 .3498 .49829 .35759 .51485 .35608 Metetra
.334 .696 .982 r
.47993 .34097 .46343 .34125 .48095 .3498 .49749 .3489 Metetra
.309 .672 .975 r
.46218 .33218 .44571 .33184 .46343 .34125 .47993 .34097 Metetra
.288 .648 .968 r
.44423 .32242 .4278 .32146 .44571 .33184 .46218 .33218 Metetra
.271 .624 .96 r
.42609 .31155 .40972 .31004 .4278 .32146 .44423 .32242 Metetra
.262 .602 .953 r
.40777 .29946 .39145 .29749 .40972 .31004 .42609 .31155 Metetra
.261 .584 .945 r
.38926 .28605 .37301 .28374 .39145 .29749 .40777 .29946 Metetra
.27 .569 .937 r
.37059 .27121 .35441 .26875 .37301 .28374 .38926 .28605 Metetra
.29 .56 .929 r
.35176 .25486 .33564 .2525 .35441 .26875 .37059 .27121 Metetra
.318 .555 .92 r
.33277 .23696 .31672 .23501 .33564 .2525 .35176 .25486 Metetra
.356 .556 .91 r
.31364 .21751 .29765 .21635 .31672 .23501 .33277 .23696 Metetra
.4 .561 .898 r
.29438 .19653 .27842 .19664 .29765 .21635 .31364 .21751 Metetra
.448 .57 .885 r
.27498 .17414 .25905 .17607 .27842 .19664 .29438 .19653 Metetra
.499 .582 .869 r
.25545 .1505 .23952 .15491 .25905 .17607 .27498 .17414 Metetra
.549 .595 .853 r
.23579 .12589 .21982 .13353 .23952 .15491 .25545 .1505 Metetra
.573 .823 .992 r
.73977 .4132 .72302 .41857 .73779 .42267 .75453 .41732 Metetra
.571 .824 .993 r
.72485 .4091 .70809 .41446 .72302 .41857 .73977 .4132 Metetra
.567 .824 .994 r
.70976 .40501 .69299 .41035 .70809 .41446 .72485 .4091 Metetra
.562 .825 .995 r
.69449 .40092 .67772 .40621 .69299 .41035 .70976 .40501 Metetra
.556 .824 .996 r
.67906 .39683 .66227 .40202 .67772 .40621 .69449 .40092 Metetra
.548 .823 .997 r
.66344 .39271 .64664 .39777 .66227 .40202 .67906 .39683 Metetra
.538 .821 .998 r
.64764 .38854 .63084 .39342 .64664 .39777 .66344 .39271 Metetra
.526 .818 .999 r
.63166 .38429 .61485 .38893 .63084 .39342 .64764 .38854 Metetra
.512 .813 1 r
.61548 .37992 .59867 .38427 .61485 .38893 .63166 .38429 Metetra
.494 .806 1 r
.59911 .37539 .5823 .37937 .59867 .38427 .61548 .37992 Metetra
.474 .797 .999 r
.58254 .37062 .56573 .37418 .5823 .37937 .59911 .37539 Metetra
.45 .786 .998 r
.56578 .36556 .54897 .36862 .56573 .37418 .58254 .37062 Metetra
.423 .771 .996 r
.54881 .36012 .53201 .36262 .54897 .36862 .56578 .36556 Metetra
.392 .753 .993 r
.53163 .3542 .51485 .35608 .53201 .36262 .54881 .36012 Metetra
.359 .731 .988 r
.51426 .34772 .49749 .3489 .51485 .35608 .53163 .3542 Metetra
.325 .706 .981 r
.49667 .34054 .47993 .34097 .49749 .3489 .51426 .34772 Metetra
.289 .677 .973 r
.47888 .33253 .46218 .33218 .47993 .34097 .49667 .34054 Metetra
.255 .647 .964 r
.46089 .32357 .44423 .32242 .46218 .33218 .47888 .33253 Metetra
.224 .615 .953 r
.4427 .31351 .42609 .31155 .44423 .32242 .46089 .32357 Metetra
.198 .584 .943 r
.42432 .30219 .40777 .29946 .42609 .31155 .4427 .31351 Metetra
.181 .555 .932 r
.40575 .28946 .38926 .28605 .40777 .29946 .42432 .30219 Metetra
.174 .53 .922 r
.38701 .27518 .37059 .27121 .38926 .28605 .40575 .28946 Metetra
.179 .511 .913 r
.3681 .25922 .35176 .25486 .37059 .27121 .38701 .27518 Metetra
.197 .498 .905 r
.34903 .24145 .33277 .23696 .35176 .25486 .3681 .25922 Metetra
.227 .493 .898 r
.32982 .2218 .31364 .21751 .33277 .23696 .34903 .24145 Metetra
.268 .495 .89 r
.31047 .20022 .29438 .19653 .31364 .21751 .32982 .2218 Metetra
.319 .502 .881 r
.29101 .17671 .27498 .17414 .29438 .19653 .31047 .20022 Metetra
.375 .515 .87 r
.27144 .15134 .25545 .1505 .27498 .17414 .29101 .17671 Metetra
.435 .531 .857 r
.25176 .12428 .23579 .12589 .25545 .1505 .27144 .15134 Metetra
.579 .824 .991 r
.75671 .40762 .73977 .4132 .75453 .41732 .77145 .4118 Metetra
.577 .825 .992 r
.7418 .40349 .72485 .4091 .73977 .4132 .75671 .40762 Metetra
.575 .827 .993 r
.72672 .39938 .70976 .40501 .72485 .4091 .7418 .40349 Metetra
.571 .828 .994 r
.71146 .39532 .69449 .40092 .70976 .40501 .72672 .39938 Metetra
.566 .828 .995 r
.69604 .39127 .67906 .39683 .69449 .40092 .71146 .39532 Metetra
.56 .828 .996 r
.68043 .38725 .66344 .39271 .67906 .39683 .69604 .39127 Metetra
.552 .828 .997 r
.66464 .38322 .64764 .38854 .66344 .39271 .68043 .38725 Metetra
.541 .826 .998 r
.64866 .37917 .63166 .38429 .64764 .38854 .66464 .38322 Metetra
.528 .823 .999 r
.63249 .37506 .61548 .37992 .63166 .38429 .64866 .37917 Metetra
.512 .818 1 r
.61613 .37085 .59911 .37539 .61548 .37992 .63249 .37506 Metetra
.492 .811 1 r
.59957 .36648 .58254 .37062 .59911 .37539 .61613 .37085 Metetra
.468 .801 .999 r
.5828 .3619 .56578 .36556 .58254 .37062 .59957 .36648 Metetra
.44 .788 .998 r
.56583 .35703 .54881 .36012 .56578 .36556 .5828 .3619 Metetra
.407 .77 .994 r
.54865 .35178 .53163 .3542 .54881 .36012 .56583 .35703 Metetra
.37 .749 .989 r
.53125 .34603 .51426 .34772 .53163 .3542 .54865 .35178 Metetra
.329 .722 .982 r
.51365 .33968 .49667 .34054 .51426 .34772 .53125 .34603 Metetra
.284 .691 .972 r
.49583 .33258 .47888 .33253 .49667 .34054 .51365 .33968 Metetra
.237 .655 .96 r
.4778 .32459 .46089 .32357 .47888 .33253 .49583 .33258 Metetra
.191 .615 .945 r
.45957 .31554 .4427 .31351 .46089 .32357 .4778 .32459 Metetra
.147 .574 .93 r
.44113 .30525 .42432 .30219 .4427 .31351 .45957 .31554 Metetra
.11 .533 .913 r
.4225 .29354 .40575 .28946 .42432 .30219 .44113 .30525 Metetra
.082 .494 .898 r
.40368 .28022 .38701 .27518 .40575 .28946 .4225 .29354 Metetra
.066 .461 .885 r
.38468 .2651 .3681 .25922 .38701 .27518 .40368 .28022 Metetra
.065 .436 .874 r
.36552 .24801 .34903 .24145 .3681 .25922 .38468 .2651 Metetra
.08 .419 .866 r
.3462 .22878 .32982 .2218 .34903 .24145 .36552 .24801 Metetra
.11 .412 .861 r
.32676 .20728 .31047 .20022 .32982 .2218 .3462 .22878 Metetra
.156 .415 .856 r
.3072 .18342 .29101 .17671 .31047 .20022 .32676 .20728 Metetra
.214 .426 .852 r
.28754 .15716 .27144 .15134 .29101 .17671 .3072 .18342 Metetra
.28 .444 .846 r
.2678 .12854 .25176 .12428 .27144 .15134 .28754 .15716 Metetra
.583 .824 .99 r
.77384 .40186 .75671 .40762 .77145 .4118 .78857 .40612 Metetra
.583 .826 .991 r
.75894 .39765 .7418 .40349 .75671 .40762 .77384 .40186 Metetra
.582 .828 .991 r
.74387 .3935 .72672 .39938 .7418 .40349 .75894 .39765 Metetra
.579 .83 .992 r
.72863 .3894 .71146 .39532 .72672 .39938 .74387 .3935 Metetra
.576 .831 .993 r
.71321 .38537 .69604 .39127 .71146 .39532 .72863 .3894 Metetra
.572 .832 .994 r
.69761 .38139 .68043 .38725 .69604 .39127 .71321 .38537 Metetra
.565 .833 .996 r
.68183 .37745 .66464 .38322 .68043 .38725 .69761 .38139 Metetra
.557 .833 .997 r
.66587 .37354 .64866 .37917 .66464 .38322 .68183 .37745 Metetra
.546 .832 .998 r
.64971 .36963 .63249 .37506 .64866 .37917 .66587 .37354 Metetra
.531 .829 .999 r
.63335 .3657 .61613 .37085 .63249 .37506 .64971 .36963 Metetra
.513 .824 1 r
.6168 .36169 .59957 .36648 .61613 .37085 .63335 .3657 Metetra
.491 .817 1 r
.60004 .35756 .5828 .3619 .59957 .36648 .6168 .36169 Metetra
.464 .806 .999 r
.58307 .35323 .56583 .35703 .5828 .3619 .60004 .35756 Metetra
.431 .791 .996 r
.56588 .34863 .54865 .35178 .56583 .35703 .58307 .35323 Metetra
.392 .771 .991 r
.54848 .34364 .53125 .34603 .54865 .35178 .56588 .34863 Metetra
.347 .745 .984 r
.53086 .33816 .51365 .33968 .53125 .34603 .54848 .34364 Metetra
.295 .712 .973 r
.51303 .33204 .49583 .33258 .51365 .33968 .53086 .33816 Metetra
.238 .673 .958 r
.49497 .32513 .4778 .32459 .49583 .33258 .51303 .33204 Metetra
.177 .627 .939 r
.4767 .31725 .45957 .31554 .4778 .32459 .49497 .32513 Metetra
.116 .576 .917 r
.45821 .30821 .44113 .30525 .45957 .31554 .4767 .31725 Metetra
.057 .522 .893 r
.43951 .2978 .4225 .29354 .44113 .30525 .45821 .30821 Metetra
.005 .468 .868 r
.42061 .28579 .40368 .28022 .4225 .29354 .43951 .2978 Metetra
0 .417 .845 r
.40153 .27196 .38468 .2651 .40368 .28022 .42061 .28579 Metetra
0 .373 .825 r
.38226 .25606 .36552 .24801 .38468 .2651 .40153 .27196 Metetra
0 .338 .811 r
.36284 .23786 .3462 .22878 .36552 .24801 .38226 .25606 Metetra
0 .316 .803 r
.34328 .21715 .32676 .20728 .3462 .22878 .36284 .23786 Metetra
0 .307 .8 r
.32359 .19373 .3072 .18342 .32676 .20728 .34328 .21715 Metetra
.014 .311 .801 r
.30381 .16747 .28754 .15716 .3072 .18342 .32359 .19373 Metetra
.08 .326 .804 r
.28395 .13825 .2678 .12854 .28754 .15716 .30381 .16747 Metetra
.587 .823 .989 r
.79116 .39594 .77384 .40186 .78857 .40612 .80589 .40031 Metetra
.587 .826 .989 r
.77627 .39162 .75894 .39765 .77384 .40186 .79116 .39594 Metetra
.587 .828 .99 r
.76121 .38738 .74387 .3935 .75894 .39765 .77627 .39162 Metetra
.587 .83 .991 r
.74599 .38321 .72863 .3894 .74387 .3935 .76121 .38738 Metetra
.585 .833 .992 r
.73058 .37913 .71321 .38537 .72863 .3894 .74599 .38321 Metetra
.582 .835 .993 r
.715 .37514 .69761 .38139 .71321 .38537 .73058 .37913 Metetra
.578 .837 .994 r
.69923 .37123 .68183 .37745 .69761 .38139 .715 .37514 Metetra
.572 .838 .995 r
.68327 .3674 .66587 .37354 .68183 .37745 .69923 .37123 Metetra
.563 .839 .997 r
.66713 .36364 .64971 .36963 .66587 .37354 .68327 .3674 Metetra
.552 .838 .998 r
.65078 .35991 .63335 .3657 .64971 .36963 .66713 .36364 Metetra
.537 .836 .999 r
.63424 .3562 .6168 .36169 .63335 .3657 .65078 .35991 Metetra
.517 .831 1 r
.61748 .35245 .60004 .35756 .6168 .36169 .63424 .3562 Metetra
.492 .824 .999 r
.60052 .34862 .58307 .35323 .60004 .35756 .61748 .35245 Metetra
.462 .812 .998 r
.58334 .34462 .56588 .34863 .58307 .35323 .60052 .34862 Metetra
.424 .795 .994 r
.56594 .34036 .54848 .34364 .56588 .34863 .58334 .34462 Metetra
.377 .772 .987 r
.54832 .33574 .53086 .33816 .54848 .34364 .56594 .34036 Metetra
.322 .741 .976 r
.53047 .33063 .51303 .33204 .53086 .33816 .54832 .33574 Metetra
.258 .701 .96 r
.51239 .32486 .49497 .32513 .51303 .33204 .53047 .33063 Metetra
.187 .652 .938 r
.49408 .31826 .4767 .31725 .49497 .32513 .51239 .32486 Metetra
.109 .593 .91 r
.47555 .31063 .45821 .30821 .4767 .31725 .49408 .31826 Metetra
.03 .527 .876 r
.4568 .30174 .43951 .2978 .45821 .30821 .47555 .31063 Metetra
0 .457 .839 r
.43783 .29135 .42061 .28579 .43951 .2978 .4568 .30174 Metetra
0 .386 .801 r
.41866 .27917 .40153 .27196 .42061 .28579 .43783 .29135 Metetra
0 .32 .766 r
.3993 .26493 .38226 .25606 .40153 .27196 .41866 .27917 Metetra
0 .263 .737 r
.37975 .24834 .36284 .23786 .38226 .25606 .3993 .26493 Metetra
0 .219 .717 r
.36006 .2291 .34328 .21715 .36284 .23786 .37975 .24834 Metetra
0 .189 .707 r
.34023 .20692 .32359 .19373 .34328 .21715 .36006 .2291 Metetra
0 .176 .707 r
.32029 .18155 .30381 .16747 .32359 .19373 .34023 .20692 Metetra
0 .18 .714 r
.30028 .15277 .28395 .13825 .30381 .16747 .32029 .18155 Metetra
.589 .822 .988 r
.80869 .38989 .79116 .39594 .80589 .40031 .8234 .3944 Metetra
.591 .824 .988 r
.79381 .38543 .77627 .39162 .79116 .39594 .80869 .38989 Metetra
.592 .827 .989 r
.77876 .38106 .76121 .38738 .77627 .39162 .79381 .38543 Metetra
.593 .83 .989 r
.76354 .37678 .74599 .38321 .76121 .38738 .77876 .38106 Metetra
.593 .833 .99 r
.74815 .3726 .73058 .37913 .74599 .38321 .76354 .37678 Metetra
.592 .836 .991 r
.73258 .36854 .715 .37514 .73058 .37913 .74815 .3726 Metetra
.59 .839 .992 r
.71682 .3646 .69923 .37123 .715 .37514 .73258 .36854 Metetra
.586 .842 .993 r
.70088 .36077 .68327 .3674 .69923 .37123 .71682 .3646 Metetra
.58 .844 .995 r
.68475 .35707 .66713 .36364 .68327 .3674 .70088 .36077 Metetra
.572 .846 .996 r
.66842 .35348 .65078 .35991 .66713 .36364 .68475 .35707 Metetra
.56 .846 .997 r
.65189 .34998 .63424 .3562 .65078 .35991 .66842 .35348 Metetra
.544 .844 .999 r
.63514 .34653 .61748 .35245 .63424 .3562 .65189 .34998 Metetra
.523 .84 .999 r
.61819 .34311 .60052 .34862 .61748 .35245 .63514 .34653 Metetra
.496 .833 .998 r
.60102 .33964 .58334 .34462 .60052 .34862 .61819 .34311 Metetra
.462 .82 .996 r
.58363 .33605 .56594 .34036 .58334 .34462 .60102 .33964 Metetra
.418 .802 .99 r
.566 .33224 .54832 .33574 .56594 .34036 .58363 .33605 Metetra
.364 .775 .981 r
.54815 .32811 .53047 .33063 .54832 .33574 .566 .33224 Metetra
.298 .738 .965 r
.53006 .32349 .51239 .32486 .53047 .33063 .54815 .32811 Metetra
.22 .689 .942 r
.51174 .31821 .49408 .31826 .51239 .32486 .53006 .32349 Metetra
.131 .627 .909 r
.49317 .31208 .47555 .31063 .49408 .31826 .51174 .31821 Metetra
.034 .552 .867 r
.47438 .30487 .4568 .30174 .47555 .31063 .49317 .31208 Metetra
0 .468 .817 r
.45535 .2963 .43783 .29135 .4568 .30174 .47438 .30487 Metetra
0 .378 .763 r
.4361 .28609 .41866 .27917 .43783 .29135 .45535 .2963 Metetra
0 .289 .708 r
.41664 .27391 .3993 .26493 .41866 .27917 .4361 .28609 Metetra
0 .207 .658 r
.39698 .25943 .37975 .24834 .3993 .26493 .41664 .27391 Metetra
0 .137 .618 r
.37714 .24228 .36006 .2291 .37975 .24834 .39698 .25943 Metetra
0 .082 .59 r
.35716 .2221 .34023 .20692 .36006 .2291 .37714 .24228 Metetra
0 .044 .576 r
.33705 .19852 .32029 .18155 .34023 .20692 .35716 .2221 Metetra
0 .025 .577 r
.31685 .17121 .30028 .15277 .32029 .18155 .33705 .19852 Metetra
.591 .82 .987 r
.82642 .38375 .80869 .38989 .8234 .3944 .84112 .38843 Metetra
.593 .823 .987 r
.81155 .37913 .79381 .38543 .80869 .38989 .82642 .38375 Metetra
.595 .826 .987 r
.79651 .37459 .77876 .38106 .79381 .38543 .81155 .37913 Metetra
.597 .829 .988 r
.78131 .37015 .76354 .37678 .77876 .38106 .79651 .37459 Metetra
.599 .832 .988 r
.76593 .36582 .74815 .3726 .76354 .37678 .78131 .37015 Metetra
.6 .836 .989 r
.75037 .36163 .73258 .36854 .74815 .3726 .76593 .36582 Metetra
.599 .84 .99 r
.73462 .35759 .71682 .3646 .73258 .36854 .75037 .36163 Metetra
.598 .844 .991 r
.71869 .3537 .70088 .36077 .71682 .3646 .73462 .35759 Metetra
.595 .847 .992 r
.70257 .34998 .68475 .35707 .70088 .36077 .71869 .3537 Metetra
.59 .85 .994 r
.68626 .34642 .66842 .35348 .68475 .35707 .70257 .34998 Metetra
.582 .853 .995 r
.66974 .34303 .65189 .34998 .66842 .35348 .68626 .34642 Metetra
.57 .854 .997 r
.65301 .33979 .63514 .34653 .65189 .34998 .66974 .34303 Metetra
.554 .854 .998 r
.63608 .33667 .61819 .34311 .63514 .34653 .65301 .33979 Metetra
.533 .85 .998 r
.61892 .33362 .60102 .33964 .61819 .34311 .63608 .33667 Metetra
.504 .843 .997 r
.60154 .3306 .58363 .33605 .60102 .33964 .61892 .33362 Metetra
.466 .831 .993 r
.58392 .32752 .566 .33224 .58363 .33605 .60154 .3306 Metetra
.416 .811 .986 r
.56607 .32428 .54815 .32811 .566 .33224 .58392 .32752 Metetra
.353 .78 .972 r
.54798 .32075 .53006 .32349 .54815 .32811 .56607 .32428 Metetra
.275 .736 .95 r
.52965 .31678 .51174 .31821 .53006 .32349 .54798 .32075 Metetra
.181 .676 .917 r
.51107 .31217 .49317 .31208 .51174 .31821 .52965 .31678 Metetra
.072 .599 .871 r
.49224 .3067 .47438 .30487 .49317 .31208 .51107 .31217 Metetra
0 .505 .811 r
.47316 .30009 .45535 .2963 .47438 .30487 .49224 .3067 Metetra
0 .399 .74 r
.45385 .29206 .4361 .28609 .45535 .2963 .47316 .30009 Metetra
0 .288 .664 r
.4343 .28225 .41664 .27391 .4361 .28609 .45385 .29206 Metetra
.382 0 0 r
.41453 .2703 .39698 .25943 .41664 .27391 .4343 .28225 Metetra
.463 0 0 r
.39457 .25578 .37714 .24228 .39698 .25943 .41453 .2703 Metetra
.522 0 0 r
.37442 .23827 .35716 .2221 .37714 .24228 .39457 .25578 Metetra
.56 .06 0 r
.35413 .21732 .33705 .19852 .35716 .2221 .37442 .23827 Metetra
.575 .105 0 r
.33372 .19246 .31685 .17121 .33705 .19852 .35413 .21732 Metetra
.591 .817 .986 r
.84436 .37756 .82642 .38375 .84112 .38843 .85905 .38243 Metetra
.594 .82 .986 r
.8295 .37275 .81155 .37913 .82642 .38375 .84436 .37756 Metetra
.597 .823 .986 r
.81448 .36801 .79651 .37459 .81155 .37913 .8295 .37275 Metetra
.6 .827 .986 r
.79928 .36337 .78131 .37015 .79651 .37459 .81448 .36801 Metetra
.603 .83 .986 r
.78391 .35885 .76593 .36582 .78131 .37015 .79928 .36337 Metetra
.605 .835 .987 r
.76836 .35448 .75037 .36163 .76593 .36582 .78391 .35885 Metetra
.607 .839 .988 r
.75263 .35026 .73462 .35759 .75037 .36163 .76836 .35448 Metetra
.608 .843 .988 r
.73671 .34623 .71869 .3537 .73462 .35759 .75263 .35026 Metetra
.607 .848 .989 r
.72061 .34241 .70257 .34998 .71869 .3537 .73671 .34623 Metetra
.605 .853 .991 r
.70431 .3388 .68626 .34642 .70257 .34998 .72061 .34241 Metetra
.601 .857 .992 r
.6878 .33541 .66974 .34303 .68626 .34642 .70431 .3388 Metetra
.594 .861 .994 r
.67109 .33225 .65301 .33979 .66974 .34303 .6878 .33541 Metetra
.583 .864 .995 r
.65417 .32931 .63608 .33667 .65301 .33979 .67109 .33225 Metetra
.568 .864 .996 r
.63703 .32656 .61892 .33362 .63608 .33667 .65417 .32931 Metetra
.545 .862 .996 r
.61967 .32397 .60154 .3306 .61892 .33362 .63703 .32656 Metetra
.515 .856 .994 r
.60207 .32148 .58392 .32752 .60154 .3306 .61967 .32397 Metetra
.473 .844 .99 r
.58423 .31902 .56607 .32428 .58392 .32752 .60207 .32148 Metetra
.418 .822 .98 r
.56615 .31647 .54798 .32075 .56607 .32428 .58423 .31902 Metetra
.346 .788 .961 r
.54781 .31371 .52965 .31678 .54798 .32075 .56615 .31647 Metetra
.255 .736 .931 r
.52923 .31055 .51107 .31217 .52965 .31678 .54781 .31371 Metetra
.142 .663 .885 r
.51038 .3068 .49224 .3067 .51107 .31217 .52923 .31055 Metetra
.012 .567 .821 r
.49127 .3022 .47316 .30009 .49224 .3067 .51038 .3068 Metetra
0 .451 .738 r
.47191 .29645 .45385 .29206 .47316 .30009 .49127 .3022 Metetra
.267 0 0 r
.45229 .28921 .4343 .28225 .45385 .29206 .47191 .29645 Metetra
.395 0 0 r
.43243 .28008 .41453 .2703 .4343 .28225 .45229 .28921 Metetra
.502 0 0 r
.41234 .26863 .39457 .25578 .41453 .2703 .43243 .28008 Metetra
.587 .035 0 r
.39204 .25436 .37442 .23827 .39457 .25578 .41234 .26863 Metetra
.649 .123 0 r
.37157 .23675 .35413 .21732 .37442 .23827 .39204 .25436 Metetra
.69 .191 0 r
.35094 .21526 .33372 .19246 .35413 .21732 .37157 .23675 Metetra
.59 .814 .985 r
.86251 .37136 .84436 .37756 .85905 .38243 .87719 .37642 Metetra
.593 .817 .985 r
.84767 .36633 .8295 .37275 .84436 .37756 .86251 .37136 Metetra
.597 .82 .985 r
.83265 .36138 .81448 .36801 .8295 .37275 .84767 .36633 Metetra
.601 .824 .985 r
.81747 .35651 .79928 .36337 .81448 .36801 .83265 .36138 Metetra
.605 .827 .985 r
.80211 .35175 .78391 .35885 .79928 .36337 .81747 .35651 Metetra
.609 .832 .985 r
.78657 .34714 .76836 .35448 .78391 .35885 .80211 .35175 Metetra
.612 .836 .985 r
.77085 .34269 .75263 .35026 .76836 .35448 .78657 .34714 Metetra
.615 .842 .986 r
.75494 .33845 .73671 .34623 .75263 .35026 .77085 .34269 Metetra
.617 .847 .987 r
.73885 .33443 .72061 .34241 .73671 .34623 .75494 .33845 Metetra
.618 .853 .988 r
.72256 .33066 .70431 .3388 .72061 .34241 .73885 .33443 Metetra
.617 .858 .989 r
.70607 .32717 .6878 .33541 .70431 .3388 .72256 .33066 Metetra
.615 .864 .99 r
.68938 .32397 .67109 .33225 .6878 .33541 .70607 .32717 Metetra
.609 .869 .991 r
.67248 .32107 .65417 .32931 .67109 .33225 .68938 .32397 Metetra
.599 .874 .993 r
.65536 .31847 .63703 .32656 .65417 .32931 .67248 .32107 Metetra
.584 .876 .994 r
.63801 .31615 .61967 .32397 .63703 .32656 .65536 .31847 Metetra
.562 .876 .993 r
.62043 .31409 .60207 .32148 .61967 .32397 .63801 .31615 Metetra
.53 .871 .991 r
.60262 .31223 .58423 .31902 .60207 .32148 .62043 .31409 Metetra
.486 .859 .985 r
.58455 .3105 .56615 .31647 .58423 .31902 .60262 .31223 Metetra
.426 .836 .971 r
.56623 .30879 .54781 .31371 .56615 .31647 .58455 .3105 Metetra
.345 .798 .948 r
.54764 .30696 .52923 .31055 .54781 .31371 .56623 .30879 Metetra
.239 .737 .908 r
.52879 .30482 .51038 .3068 .52923 .31055 .54764 .30696 Metetra
.108 .649 .846 r
.50967 .30216 .49127 .3022 .51038 .3068 .52879 .30482 Metetra
0 .533 .759 r
.49028 .29869 .47191 .29645 .49127 .3022 .50967 .30216 Metetra
.204 0 0 r
.47061 .29409 .45229 .28921 .47191 .29645 .49028 .29869 Metetra
.358 0 0 r
.45067 .28795 .43243 .28008 .45229 .28921 .47061 .29409 Metetra
.492 0 0 r
.43048 .27984 .41234 .26863 .43243 .28008 .45067 .28795 Metetra
.6 .032 0 r
.41005 .26924 .39204 .25436 .41234 .26863 .43048 .27984 Metetra
.683 .141 0 r
.38941 .25557 .37157 .23675 .39204 .25436 .41005 .26924 Metetra
.743 .23 0 r
.36857 .23821 .35094 .21526 .37157 .23675 .38941 .25557 Metetra
.588 .811 .985 r
.88089 .36518 .86251 .37136 .87719 .37642 .89556 .37045 Metetra
.592 .814 .984 r
.86606 .35993 .84767 .36633 .86251 .37136 .88089 .36518 Metetra
.596 .817 .984 r
.85105 .35473 .83265 .36138 .84767 .36633 .86606 .35993 Metetra
.601 .82 .984 r
.83587 .34961 .81747 .35651 .83265 .36138 .85105 .35473 Metetra
.606 .824 .984 r
.82052 .34458 .80211 .35175 .81747 .35651 .83587 .34961 Metetra
.61 .828 .983 r
.80499 .33969 .78657 .34714 .80211 .35175 .82052 .34458 Metetra
.615 .833 .983 r
.78928 .33496 .77085 .34269 .78657 .34714 .80499 .33969 Metetra
.62 .838 .984 r
.77339 .33043 .75494 .33845 .77085 .34269 .78928 .33496 Metetra
.624 .844 .984 r
.75731 .32614 .73885 .33443 .75494 .33845 .77339 .33043 Metetra
.627 .85 .984 r
.74103 .32213 .72256 .33066 .73885 .33443 .75731 .32614 Metetra
.63 .857 .985 r
.72456 .31842 .70607 .32717 .72256 .33066 .74103 .32213 Metetra
.631 .864 .986 r
.70788 .31505 .68938 .32397 .70607 .32717 .72456 .31842 Metetra
.63 .871 .987 r
.691 .31204 .67248 .32107 .68938 .32397 .70788 .31505 Metetra
.625 .878 .988 r
.6739 .30943 .65536 .31847 .67248 .32107 .691 .31204 Metetra
.617 .884 .99 r
.65657 .30721 .63801 .31615 .65536 .31847 .6739 .30943 Metetra
.604 .889 .99 r
.63902 .30538 .62043 .31409 .63801 .31615 .65657 .30721 Metetra
.583 .89 .989 r
.62122 .30393 .60262 .31223 .62043 .31409 .63902 .30538 Metetra
.551 .888 .986 r
.60318 .3028 .58455 .3105 .60262 .31223 .62122 .30393 Metetra
.505 .877 .978 r
.58488 .30193 .56623 .30879 .58455 .3105 .60318 .3028 Metetra
.441 .854 .961 r
.56631 .30121 .54764 .30696 .56623 .30879 .58488 .30193 Metetra
.351 .811 .931 r
.54747 .3005 .52879 .30482 .54764 .30696 .56631 .30121 Metetra
.231 .741 .879 r
.52835 .29961 .50967 .30216 .52879 .30482 .54747 .3005 Metetra
.081 .637 .799 r
.50894 .2983 .49028 .29869 .50967 .30216 .52835 .29961 Metetra
.092 0 0 r
.48925 .29627 .47061 .29409 .49028 .29869 .50894 .2983 Metetra
.269 0 0 r
.46926 .29315 .45067 .28795 .47061 .29409 .48925 .29627 Metetra
.432 0 0 r
.449 .2885 .43048 .27984 .45067 .28795 .46926 .29315 Metetra
.566 0 0 r
.42846 .28181 .41005 .26924 .43048 .27984 .449 .2885 Metetra
.671 .119 0 r
.40766 .27249 .38941 .25557 .41005 .26924 .42846 .28181 Metetra
.748 .227 0 r
.38663 .25987 .36857 .23821 .38941 .25557 .40766 .27249 Metetra
.585 .808 .985 r
.8995 .35906 .88089 .36518 .89556 .37045 .91416 .36454 Metetra
.589 .81 .984 r
.88467 .35358 .86606 .35993 .88089 .36518 .8995 .35906 Metetra
.594 .813 .983 r
.86968 .34813 .85105 .35473 .86606 .35993 .88467 .35358 Metetra
.599 .816 .983 r
.85451 .34273 .83587 .34961 .85105 .35473 .86968 .34813 Metetra
.604 .819 .982 r
.83917 .33741 .82052 .34458 .83587 .34961 .85451 .34273 Metetra
.61 .823 .982 r
.82365 .33221 .80499 .33969 .82052 .34458 .83917 .33741 Metetra
.616 .828 .982 r
.80795 .32715 .78928 .33496 .80499 .33969 .82365 .33221 Metetra
.622 .833 .981 r
.79206 .32228 .77339 .33043 .78928 .33496 .80795 .32715 Metetra
.628 .839 .981 r
.77599 .31765 .75731 .32614 .77339 .33043 .79206 .32228 Metetra
.633 .846 .981 r
.75972 .31329 .74103 .32213 .75731 .32614 .77599 .31765 Metetra
.638 .853 .982 r
.74326 .30925 .72456 .31842 .74103 .32213 .75972 .31329 Metetra
.642 .861 .982 r
.7266 .30559 .70788 .31505 .72456 .31842 .74326 .30925 Metetra
.645 .87 .983 r
.70973 .30234 .691 .31204 .70788 .31505 .7266 .30559 Metetra
.646 .878 .984 r
.69265 .29954 .6739 .30943 .691 .31204 .70973 .30234 Metetra
.644 .887 .985 r
.67535 .29723 .65657 .30721 .6739 .30943 .69265 .29954 Metetra
.638 .895 .985 r
.65782 .29543 .63902 .30538 .65657 .30721 .67535 .29723 Metetra
.627 .902 .985 r
.64005 .29415 .62122 .30393 .63902 .30538 .65782 .29543 Metetra
.607 .906 .984 r
.62203 .29338 .60318 .3028 .62122 .30393 .64005 .29415 Metetra
.577 .906 .979 r
.60376 .29309 .58488 .30193 .60318 .3028 .62203 .29338 Metetra
.531 .897 .969 r
.58522 .29322 .56631 .30121 .58488 .30193 .60376 .29309 Metetra
.463 .874 .949 r
.5664 .29367 .54747 .3005 .56631 .30121 .58522 .29322 Metetra
.366 .828 .911 r
.5473 .2943 .52835 .29961 .54747 .3005 .5664 .29367 Metetra
.233 .749 .846 r
.5279 .29491 .50894 .2983 .52835 .29961 .5473 .2943 Metetra
.064 .629 .745 r
.5082 .29525 .48925 .29627 .50894 .2983 .5279 .29491 Metetra
.127 0 0 r
.48819 .29501 .46926 .29315 .48925 .29627 .5082 .29525 Metetra
.318 0 0 r
.46787 .29377 .449 .2885 .46926 .29315 .48819 .29501 Metetra
.484 0 0 r
.44725 .29105 .42846 .28181 .449 .2885 .46787 .29377 Metetra
.616 .056 0 r
.42634 .28628 .40766 .27249 .42846 .28181 .44725 .29105 Metetra
.714 .187 0 r
.40515 .27878 .38663 .25987 .40766 .27249 .42634 .28628 Metetra
.581 .805 .985 r
.91834 .35302 .8995 .35906 .91416 .36454 .93298 .3587 Metetra
.585 .806 .984 r
.90353 .34732 .88467 .35358 .8995 .35906 .91834 .35302 Metetra
.59 .808 .983 r
.88854 .34162 .86968 .34813 .88467 .35358 .90353 .34732 Metetra
.595 .811 .982 r
.87338 .33593 .85451 .34273 .86968 .34813 .88854 .34162 Metetra
.601 .814 .982 r
.85805 .33031 .83917 .33741 .85451 .34273 .87338 .33593 Metetra
.607 .818 .981 r
.84254 .32476 .82365 .33221 .83917 .33741 .85805 .33031 Metetra
.614 .822 .98 r
.82684 .31934 .80795 .32715 .82365 .33221 .84254 .32476 Metetra
.621 .828 .98 r
.81096 .31409 .79206 .32228 .80795 .32715 .82684 .31934 Metetra
.628 .834 .979 r
.7949 .30905 .77599 .31765 .79206 .32228 .81096 .31409 Metetra
.636 .84 .979 r
.77864 .30427 .75972 .31329 .77599 .31765 .7949 .30905 Metetra
.643 .848 .979 r
.76219 .29982 .74326 .30925 .75972 .31329 .77864 .30427 Metetra
.65 .856 .978 r
.74554 .29575 .7266 .30559 .74326 .30925 .76219 .29982 Metetra
.656 .865 .978 r
.72868 .29211 .70973 .30234 .7266 .30559 .74554 .29575 Metetra
.661 .874 .979 r
.71162 .28897 .69265 .29954 .70973 .30234 .72868 .29211 Metetra
.664 .885 .979 r
.69434 .28638 .67535 .29723 .69265 .29954 .71162 .28897 Metetra
.665 .895 .979 r
.67683 .28439 .65782 .29543 .67535 .29723 .69434 .28638 Metetra
.661 .905 .979 r
.65908 .28304 .64005 .29415 .65782 .29543 .67683 .28439 Metetra
.653 .915 .979 r
.6411 .28236 .62203 .29338 .64005 .29415 .65908 .28304 Metetra
.636 .922 .976 r
.62286 .28236 .60376 .29309 .62203 .29338 .6411 .28236 Metetra
.608 .924 .971 r
.60435 .28302 .58522 .29322 .60376 .29309 .62286 .28236 Metetra
.564 .918 .958 r
.58557 .28429 .5664 .29367 .58522 .29322 .60435 .28302 Metetra
.495 .896 .933 r
.5665 .28609 .5473 .2943 .5664 .29367 .58557 .28429 Metetra
.392 .849 .887 r
.54712 .28829 .5279 .29491 .5473 .2943 .5665 .28609 Metetra
.248 .762 .809 r
.52744 .29068 .5082 .29525 .5279 .29491 .54712 .28829 Metetra
.50743 .29303 .48819 .29501 .5082 .29525 .52744 .29068 Metetra
.146 0 0 r
.48709 .29497 .46787 .29377 .48819 .29501 .50743 .29303 Metetra
.346 0 0 r
.46643 .29608 .44725 .29105 .46787 .29377 .48709 .29497 Metetra
.514 0 0 r
.44543 .29583 .42634 .28628 .44725 .29105 .46643 .29608 Metetra
.642 .108 0 r
.42412 .29357 .40515 .27878 .42634 .28628 .44543 .29583 Metetra
.577 .802 .985 r
.93742 .34709 .91834 .35302 .93298 .3587 .95205 .35296 Metetra
.581 .803 .984 r
.92262 .34117 .90353 .34732 .91834 .35302 .93742 .34709 Metetra
.585 .804 .983 r
.90765 .33522 .88854 .34162 .90353 .34732 .92262 .34117 Metetra
.591 .806 .982 r
.8925 .32926 .87338 .33593 .88854 .34162 .90765 .33522 Metetra
.597 .809 .981 r
.87717 .32332 .85805 .33031 .87338 .33593 .8925 .32926 Metetra
.603 .812 .98 r
.86167 .31743 .84254 .32476 .85805 .33031 .87717 .32332 Metetra
.61 .816 .979 r
.84598 .31162 .82684 .31934 .84254 .32476 .86167 .31743 Metetra
.618 .821 .978 r
.8301 .30595 .81096 .31409 .82684 .31934 .84598 .31162 Metetra
.626 .827 .977 r
.81404 .30046 .7949 .30905 .81096 .31409 .8301 .30595 Metetra
.635 .833 .977 r
.79779 .29521 .77864 .30427 .7949 .30905 .81404 .30046 Metetra
.644 .84 .976 r
.78135 .29026 .76219 .29982 .77864 .30427 .79779 .29521 Metetra
.653 .848 .975 r
.76471 .28567 .74554 .29575 .76219 .29982 .78135 .29026 Metetra
.662 .858 .975 r
.74786 .28153 .72868 .29211 .74554 .29575 .76471 .28567 Metetra
.67 .868 .974 r
.73081 .27789 .71162 .28897 .72868 .29211 .74786 .28153 Metetra
.677 .879 .974 r
.71354 .27484 .69434 .28638 .71162 .28897 .73081 .27789 Metetra
.683 .89 .973 r
.69605 .27244 .67683 .28439 .69434 .28638 .71354 .27484 Metetra
.686 .902 .973 r
.67834 .27078 .65908 .28304 .67683 .28439 .69605 .27244 Metetra
.686 .915 .972 r
.66038 .26991 .6411 .28236 .65908 .28304 .67834 .27078 Metetra
.681 .927 .97 r
.64217 .26987 .62286 .28236 .6411 .28236 .66038 .26991 Metetra
.669 .937 .967 r
.6237 .27071 .60435 .28302 .62286 .28236 .64217 .26987 Metetra
.644 .943 .959 r
.60496 .27243 .58557 .28429 .60435 .28302 .6237 .27071 Metetra
.602 .94 .944 r
.58593 .275 .5665 .28609 .58557 .28429 .60496 .27243 Metetra
.535 .92 .915 r
.56659 .27835 .54712 .28829 .5665 .28609 .58593 .275 Metetra
.43 .872 .861 r
.54694 .28237 .52744 .29068 .54712 .28829 .56659 .27835 Metetra
.277 .778 .769 r
.52696 .28687 .50743 .29303 .52744 .29068 .54694 .28237 Metetra
.50664 .2916 .48709 .29497 .50743 .29303 .52696 .28687 Metetra
.144 0 0 r
.48596 .29619 .46643 .29608 .48709 .29497 .50664 .2916 Metetra
.352 0 0 r
.46492 .30019 .44543 .29583 .46643 .29608 .48596 .29619 Metetra
.521 0 0 r
.44353 .30303 .42412 .29357 .44543 .29583 .46492 .30019 Metetra
.572 .799 .985 r
.95676 .34127 .93742 .34709 .95205 .35296 .97137 .34731 Metetra
.575 .799 .984 r
.94197 .33515 .92262 .34117 .93742 .34709 .95676 .34127 Metetra
.58 .8 .983 r
.92701 .32897 .90765 .33522 .92262 .34117 .94197 .33515 Metetra
.585 .802 .982 r
.91187 .32275 .8925 .32926 .90765 .33522 .92701 .32897 Metetra
.591 .804 .981 r
.89655 .3165 .87717 .32332 .8925 .32926 .91187 .32275 Metetra
.597 .807 .98 r
.88105 .31026 .86167 .31743 .87717 .32332 .89655 .3165 Metetra
.605 .81 .979 r
.86537 .30407 .84598 .31162 .86167 .31743 .88105 .31026 Metetra
.613 .814 .977 r
.8495 .29796 .8301 .30595 .84598 .31162 .86537 .30407 Metetra
.622 .819 .976 r
.83344 .29199 .81404 .30046 .8301 .30595 .8495 .29796 Metetra
.631 .825 .975 r
.81719 .28622 .79779 .29521 .81404 .30046 .83344 .29199 Metetra
.641 .832 .974 r
.80075 .28071 .78135 .29026 .79779 .29521 .81719 .28622 Metetra
.652 .84 .972 r
.78411 .27553 .76471 .28567 .78135 .29026 .80075 .28071 Metetra
.663 .848 .971 r
.76727 .27077 .74786 .28153 .76471 .28567 .78411 .27553 Metetra
.673 .858 .97 r
.75023 .2665 .73081 .27789 .74786 .28153 .76727 .27077 Metetra
.684 .869 .969 r
.73297 .26282 .71354 .27484 .73081 .27789 .75023 .2665 Metetra
.694 .882 .968 r
.7155 .25983 .69605 .27244 .71354 .27484 .73297 .26282 Metetra
.702 .895 .967 r
.6978 .25761 .67834 .27078 .69605 .27244 .7155 .25983 Metetra
.709 .909 .965 r
.67987 .25627 .66038 .26991 .67834 .27078 .6978 .25761 Metetra
.713 .923 .963 r
.6617 .25588 .64217 .26987 .66038 .26991 .67987 .25627 Metetra
.712 .937 .96 r
.64327 .25654 .6237 .27071 .64217 .26987 .6617 .25588 Metetra
.703 .95 .955 r
.62456 .25829 .60496 .27243 .6237 .27071 .64327 .25654 Metetra
.684 .959 .945 r
.60558 .26117 .58593 .275 .60496 .27243 .62456 .25829 Metetra
.647 .96 .927 r
.58629 .26519 .56659 .27835 .58593 .275 .60558 .26117 Metetra
.583 .944 .893 r
.56669 .27031 .54694 .28237 .56659 .27835 .58629 .26519 Metetra
.479 .897 .832 r
.54676 .27642 .52696 .28687 .54694 .28237 .56669 .27031 Metetra
.322 .8 .728 r
.52647 .28337 .50664 .2916 .52696 .28687 .54676 .27642 Metetra
.50582 .2909 .48596 .29619 .50664 .2916 .52647 .28337 Metetra
.119 0 0 r
.48478 .29866 .46492 .30019 .48596 .29619 .50582 .2909 Metetra
.335 0 0 r
.46336 .30617 .44353 .30303 .46492 .30019 .48478 .29866 Metetra
.567 .796 .986 r
.97634 .33557 .95676 .34127 .97137 .34731 .99094 .34176 Metetra
.57 .796 .985 r
.96157 .32928 .94197 .33515 .95676 .34127 .97634 .33557 Metetra
.574 .797 .984 r
.94662 .32289 .92701 .32897 .94197 .33515 .96157 .32928 Metetra
.578 .797 .982 r
.9315 .31642 .91187 .32275 .92701 .32897 .94662 .32289 Metetra
.584 .799 .981 r
.91619 .30988 .89655 .3165 .91187 .32275 .9315 .31642 Metetra
.59 .801 .98 r
.9007 .30331 .88105 .31026 .89655 .3165 .91619 .30988 Metetra
.598 .803 .979 r
.88502 .29674 .86537 .30407 .88105 .31026 .9007 .30331 Metetra
.606 .807 .977 r
.86915 .2902 .8495 .29796 .86537 .30407 .88502 .29674 Metetra
.615 .811 .975 r
.8531 .28375 .83344 .29199 .8495 .29796 .86915 .2902 Metetra
.625 .816 .974 r
.83685 .27743 .81719 .28622 .83344 .29199 .8531 .28375 Metetra
.636 .822 .972 r
.82041 .27132 .80075 .28071 .81719 .28622 .83685 .27743 Metetra
.647 .829 .97 r
.80377 .26549 .78411 .27553 .80075 .28071 .82041 .27132 Metetra
.659 .838 .969 r
.78693 .26002 .76727 .27077 .78411 .27553 .80377 .26549 Metetra
.672 .847 .967 r
.76989 .25502 .75023 .2665 .76727 .27077 .78693 .26002 Metetra
.685 .858 .965 r
.75264 .25057 .73297 .26282 .75023 .2665 .76989 .25502 Metetra
.698 .87 .963 r
.73518 .24679 .7155 .25983 .73297 .26282 .75264 .25057 Metetra
.71 .883 .961 r
.7175 .24381 .6978 .25761 .7155 .25983 .73518 .24679 Metetra
.722 .898 .959 r
.69958 .24173 .67987 .25627 .6978 .25761 .7175 .24381 Metetra
.732 .913 .956 r
.68144 .24069 .6617 .25588 .67987 .25627 .69958 .24173 Metetra
.74 .929 .952 r
.66304 .24079 .64327 .25654 .6617 .25588 .68144 .24069 Metetra
.743 .946 .947 r
.64438 .24216 .62456 .25829 .64327 .25654 .66304 .24079 Metetra
.739 .961 .94 r
.62544 .24488 .60558 .26117 .62456 .25829 .64438 .24216 Metetra
.725 .973 .927 r
.60621 .24903 .58629 .26519 .60558 .26117 .62544 .24488 Metetra
.695 .977 .906 r
.58667 .25465 .56669 .27031 .58629 .26519 .60621 .24903 Metetra
.637 .965 .868 r
.56679 .26175 .54676 .27642 .56669 .27031 .58667 .25465 Metetra
.537 .921 .8 r
.54657 .27024 .52647 .28337 .54676 .27642 .56679 .26175 Metetra
.382 .824 .688 r
.52597 .28001 .50582 .2909 .52647 .28337 .54657 .27024 Metetra
.50497 .29082 .48478 .29866 .50582 .2909 .52597 .28001 Metetra
.072 0 0 r
.48357 .30233 .46336 .30617 .48478 .29866 .50497 .29082 Metetra
0 g
.25 Mabswid
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
0 .4861 L
s
0 .4861 m
.01705 .22471 L
s
.01705 .22471 m
.48415 0 L
s
.48415 0 m
.48355 .31002 L
s
.48355 .31002 m
1 .47942 L
s
1 .47942 m
.98267 .21613 L
s
.98267 .21613 m
.48415 0 L
s
.48415 0 m
.98267 .21613 L
s
.48415 0 m
.48414 .00628 L
s
[(0)] .48417 -0.01255 -0.00192 1 Mshowa
.62694 .06191 m
.62705 .06818 L
s
[(0.5)] .62672 .04935 .0179 1 Mshowa
.7565 .11808 m
.75672 .12435 L
s
[(1)] .75605 .10553 .03559 1 Mshowa
.87459 .16927 m
.87491 .17554 L
s
[(1.5)] .87394 .15674 .05149 1 Mshowa
.98267 .21613 m
.98308 .22239 L
s
[(2)] .98184 .2036 .06584 1 Mshowa
.125 Mabswid
.51386 .01288 m
.51387 .01665 L
s
.54298 .02551 m
.543 .02927 L
s
.57152 .03788 m
.57156 .04164 L
s
.5995 .05001 m
.59956 .05378 L
s
.65385 .07357 m
.65393 .07734 L
s
.68025 .08502 m
.68034 .08878 L
s
.70614 .09624 m
.70625 .10001 L
s
.73156 .10726 m
.73168 .11103 L
s
.78099 .12869 m
.78113 .13245 L
s
.80503 .13911 m
.80518 .14288 L
s
.82863 .14935 m
.8288 .15311 L
s
.85182 .1594 m
.852 .16316 L
s
.89696 .17897 m
.89717 .18273 L
s
.91895 .1885 m
.91916 .19226 L
s
.94055 .19787 m
.94078 .20163 L
s
.96179 .20708 m
.96203 .21083 L
s
gsave
.75382 .04281 -66.178 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{288, 173.625},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000[A000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00OGoo0P00XGoo001lOol01000Oomoo`00X7oo001lOol01000Oomoo`00X7oo001l
Ool01000Oomoo`00X7oo001lOol01000Oomoo`00X7oo001mOol2002QOol00?moob5oo`00ogoo8Goo
003oOolQOol00?moob5oo`00ogoo8Goo001mOol3002POol007]oo`800003Ool007oo008003moo`80
0003Ool0000005Yoo`00FWoo0P0017oo0P000goo100047oo0P000goo00@007ooOomoo`8003ioo`03
001oo`0005]oo`00>goo0P0077oo00@007ooOol000Qoo`03001oogoo00ioo`<000Eoo`03001oogoo
00=oo`<003aoo`03001oogoo05Yoo`00>Woo00@007ooOol001]oo`04001oogoo0009Ool00`00Oomo
o`0<Ool20007Ool00`00Oomoo`04Ool01000Ool00000>7oo0P0000=oo`000000FWoo000jOol00`00
Oomoo`0LOol01000Oomoo`002Woo00<007ooOol02Goo0P002Goo00<007ooOol027oo0P004Goo0P00
17oo0P0017oo0P00MWoo000iOol5000KOol01000Oomoo`0027oo00@007ooOol000Qoo`8000]oo`03
001oogoo00Yoo`<000eoo`04001oogoo0008Ool01000Oomoo`00MGoo000jOol00`00Oomoo`0MOol2
000:Ool20007Ool2000=Ool00`00Oomoo`0<Ool3000;Ool01000Oomoo`002goo00<007ooOol0Lgoo
001]Ool3000>Ool00`00Oomoo`0?Ool20009Ool01000Oomoo`002Goo0P00MWoo001[Ool2000AOol0
0`00Oomoo`0AOol20007Ool01000Oomoo`002Goo00<007ooOol0MGoo001XOol3000COol00`00Oomo
o`0COol30005Ool2000:Ool3001eOol006Ioo`<001Eoo`03001oogoo01=oo`03001oogoo008008Mo
o`00I7oo0P0067oo00<007ooOol067oo0P00QGoo001QOol3000JOol00`00Oomoo`0JOol30022Ool0
061oo`8001aoo`03001oogoo01]oo`04001oo`000020Ool0045oo`8000Aoo`8000Eoo`<000eoo`80
0003Ool007oo01]oo`03001oogoo01moo`8007ioo`00@7oo00@007ooOol000]oo`03001oogoo00Yo
o`80021oo`03001oogoo025oo`<007]oo`00@7oo00@007ooOol000Qoo`D000Uoo`80029oo`03001o
ogoo029oo`04001oo`00001iOol0041oo`04001oogoo0008Ool01000Oomoo`0027oo0P0000=oo`00
Ool08Goo00<007ooOol08Woo00@007ooOomoo`8007Moo`00@7oo00@007ooOol000Uoo`03001oo`00
00Eoo`<002Ioo`03001oogoo02Qoo`8001Moo`D005Uoo`00@Goo0P002goo0P000goo0P00:Goo00<0
07ooOol0:Goo10005Woo00<007ooOol0FGoo001AOol200000goo001oo`0XOol00`00Oomoo`0]Ool2
000DOol00`00Oomoo`1IOol004moo`8002eoo`03001oogoo02moo`80019oo`03001oogoo05Uoo`00
CGoo0P00;goo00<007ooOol0<7oo10003goo00<007ooOol0FGoo001;Ool3000`Ool00`00Oomoo`0d
Ool2000<Ool2001KOol004Uoo`8003=oo`03001oogoo03Ioo`8006Moo`00:Goo0P0017oo0P000goo
0`0047oo0P00=Goo00<007ooOol0=Woo00<007oo00000P00I7oo000XOol01000Oomoo`0027oo00@0
07ooOol000eoo`<003Ioo`03001oogoo03]oo`80069oo`00:7oo00@007ooOol000Qoo`04001oogoo
000;Ool20002Ool00`00Oomoo`0dOol00`00Oomoo`0mOol2001POol002Qoo`04001oogoo0008Ool3
0009Ool3000kOol00`00Oomoo`0mOol01000Ool00000GWoo000XOol01000Oomoo`002Goo00<007oo
Ool01Woo0P0000=oo`00Ool0>goo00<007ooOol0@Goo0`00Fgoo000YOol2000:Ool30004Ool20010
Ool00`00Oomoo`14Ool2001IOol003Yoo`8000Aoo`<003]oo`03001oogoo04Aoo`04001oo`00001G
Ool003Qoo`800003Ool007oo00<00003=QXf6`0000<003Qoo`03001oogoo04Qoo`<000moo`D0009o
o`8000Aoo`8003Ioo`00=Woo0P000goo0P0000Y2FP00<OXf6cHJ000M^R7J8KX003Moo`03001oogoo
04Yoo`<000moo`03001oogoo00Moo`04001oogoo000eOol003Aoo`8000=oo`800005AUY2FTIJ@UX0
0003=QX00`008KXQ^P03000eOol00`00Oomoo`1=Ool2000=Ool00`00Oomoo`0:Ool00`00Oomoo`0c
Ool0039oo`80000FOol007ooOol004ii0012FTIK@UY6Fd9J000anSHK=QX001fj8MX000UI000dOol0
0`00Oomoo`1?Ool3000:Ool00`00Oomoo`08Ool2000fOol0019oo`8000Aoo`8000Aoo`80011oo`80
00Aoo`80000:CWY>VTij0012FTIJ@UY6FP00=Q/3=QX01P008KXQ^P002ET003=oo`03001oogoo051o
o`04001oo`000008Ool00`00Oomoo`08Ool00`00Oomoo`0eOol0015oo`04001oogoo0008Ool01000
Oomoo`003Goo0P001Goo01H005:JCWUBVTijDYY>N@00@UY6Fd9JAU/003HK<OXf6`008KXM^P001CP9
F@80035oo`03001oogoo05Aoo`8000Eoo`8000Yoo`<003Eoo`004Goo00@007ooOol000Qoo`04001o
ogoo000:Ool300000goo001oo`03Ool03@00E[X004jJCWY>VTijCYY>NP00@UY6FT9J00H0008Q^P03
0005>@UI0080031oo`03001oogoo05Ioo`8004Moo`004Goo00@007ooOol000Uoo`8000Uoo`8000Qo
o`0;001J^UJIF[X005:JCWUBVTijDYY>N@0300001SXj?U/002hK:OX^6`<000052ET5>00009D0000_
Ool00`00Oomoo`1FOol00`00Ool000020014Ool0015oo`04001oogoo0008Ool01000Oomoo`001Woo
0`0027oo01L005JjE[UF^UJiE[X004jJCWY>VTij001:NP00?S/nFchk?U/002hK;O/001Vj00<00004
1CT0002f000]Ool00`00Oomoo`1LOol20012Ool0019oo`8000Yoo`8000Eoo`8000Yoo`0:001J^UJI
F[YFVEZjEYUJ^P00DYX200003TYjBW]6NP00?SXnFcXj?U/002hK:OX001FJ6K/6000/Ool00`00Oomo
o`1MOol30010Ool002=oo`8000]oo`0J001F^UJiE[YF^EJjE[UF^UJiE[X004YkBWY:NdYjBW]:NP00
?S/nFchk000]nbhK;O/0008I^P030001>@0000<002]oo`03001oogoo061oo`<003eoo`008Goo0P00
00=oo`00Ool02Goo024005kI000005JIF[YFVEZjEYUJ^P00E[/004YkAWY:VdYjBW/003iK?SXnFcXj
000]nRhK:OX001FJ6K/000Di0CP00`00:Woo00<007ooOol0Hgoo0P00>goo000OOol2000>Ool03@00
G]UNfEkI001F^EJjE[UF^P00D[YBVU:j00800008BWY:NdYjBW/003iK?S/nF`<00007;Q/001Vj6KX0
004h0CT01000:Goo00<007ooOol0Hgoo00@007oo000001Ioo`@001moo`007Goo0P003goo00H005Zi
G]YN^EkIF[T2000035Zj001F^e:JD[YBVUJkDYX004IjBY]:NP@00003>S`f>`0000@000045IX0004H
1CT3000YOol00`00Oomoo`1SOol01000Oomoogoo0`004goo00<007ooOol087oo0002Ool5000DOol2
00000goo001oo`0=Ool00`00G]UNf@06G]T02@00D[YBVU:jDYYB^U:JD[YBVP0300000d9kAW/00004
=S/00`009O/Un`0400000`4h0CT00002000XOol00`00Oomoo`1YOol3000BOol00`00Oomoo`0OOol0
00Aoo`03001oogoo015oo`<0019oo`0:001NfUjiG]UJ^EkJG[UNf@00F]X200004U:JE[]BVU:jDYX0
04jJ0012FdIk@W]6N`00>U`f>cXl=S/0008Un`06000A^`00000160Di0`009goo00<007ooOol0K7oo
0P004Goo00<007ooOol07Woo0004Ool00`00Oomoo`0?Ool200000goo001oo`0AOol00`00G]UNf@05
G]T01@00F]YJ^U[JF[X00P0000AB^P00001>VP9>V`060012NdIk@W]6N`000cHk00D002Gk9O/Un`00
008AVPH002Ioo`03001oogoo06ioo`<000aoo`04001oogoo000OOol000Aoo`03001oogoo00eoo`80
00=oo`03001oogoo00moo`0W001Vn@00001J^EkJG[UNf@00F]YJ^E[JE[UJfUZiF]X004jkCYY>VdZJ
C[]>VP00@U]6Nd9kAW/003YL=S/j?000:O`Un`003IXA^a6J00D002Ioo`03001oogoo06moo`04001o
o`00000;Ool2000POol000Aoo`03001oogoo00]oo`8001Moo`04001RfF;iH_T2000035kI001JfUZj
F]YJ^U[JF[YJfP00E[X000=>V`07CYY>VdjK0012NdIk@W/01`0000<Un`004IX00Q6J00<0004h0000
0P009Goo00<007ooOol0Lgoo0P00:goo0003Ool2000;Ool200000goo001oo`0EOol01`00H]URnF;H
I_URfF;i0080000:F[UJfUJiF]YJ^E[J001FfeJjE]/200001DjJCY]:VTjkCYX00`0000HnFcil000b
?2hk<S`50000116k0001>@4H0`0097oo00<007ooOol0MGoo0P004goo1@004Goo000>Ool2000JOol0
2@00H_URnF;iH]URn@00G_YNf@0300000eZjF]X00006E[X00`00CY]>V`0200001dZK000nFcil?U/n
O00000<b?003000Qnagk00@000050CT1>0000340000SOol00`00Oomoo`1gOol3000BOol00`00Oomo
o`0AOol000aoo`<001Yoo`0=001RnF;HI_URfF;iH]P005kIH_YNfF;jG]T00P0000QFfeJjE]]B^UKK
E[YFfe:j0P00019:W4IkBYa6V`00?U]2O3iK?W`0038l;S/b?0008O`Mf`002IX200000`4i00000002
000ROol00`00Oomoo`1jOol2000@Ool00`00Oomoo`0AOol000Yoo`8001eoo`04001RnF;iH]T2H_T0
1@00G]UNfEkIG_X00UkI00@005kJ000000EF^P03001B^`0000E:V`06000nFcil?U/nO0000c8l00H0
027k7O/000VJ3I/6000QOol00`00Oomoo`1jOol01000Ool000001Woo100017oo00<007ooOol04Goo
0008Ool2000NOol04P00H]QVnF;IH_URf000G]URnUkIH_YNfF;j001NnU[JG]YJfP800006E]/00000
C[]B^djj0P0000Q:W4IkBYa6V`00?U]2O3iK1P0000DQo0003I/9VPfk00H0021oo`03001oogoo07io
o`8000aoo`03001oogoo015oo`001Woo0P0000=oo`00Ool07Goo0`000f;i00@005kIG]UNnP9Nf@03
001NfU[J009JfP04G]YJfU[J0007D[/01000BY]:VdZK100000<jG3Yl00000RXl00T^?000000000fK
2IX=V`000CT010007goo00<007ooOol0Ngoo0`0000=oo`0000002Woo0P004goo0004Ool2000QOol0
1000JaUVn6/I1@0001ERnUkIH_X005kjF]YNfU[JG_YJfUkJ001Jf`00D[]>^U:kC[]B^djjD[/00`00
00]6W49k000fG3Yl=U`jO000;S`Z72hl00D000033K/0004i00@001ioo`03001oogoo07Qoo`<000=o
o`<001moo`0017oo00<007oo00000P007Woo00H006KhIaUVnFLI0002H_T01FKi00000000G]X00e[J
00MNfU[JF]X005[KE]YFf`020004D[/01`00C[/004JL@Wa6W4:L0080008jG009>W`002Xl:S`^?000
6O`000Vk00<000030CT00000008001eoo`03001oogoo07Eoo`<000Moo`03001oogoo01ioo`0017oo
00<007ooOol00Woo0`006Woo00d006KhJaUVn6/II_P006;iIaYRnFLI001RnP0200003E[JG_YJfUkJ
F]X005KJF]]F^U[KE]X004jj00800003C[a:Vdjl0080000B@W]6W49kAY`003Yl=U`jO000;S`Z7000
6M/Mo0002K/5VPVk0P0000<0e@0000007Goo00<007ooOol0LWoo0`002Woo00<007ooOol07Woo0004
Ool00`00Oomoo`05Ool4000FOol02000IaUVnFLII_P006;iI_T3H_T01000G_YRnV;j0P000U[J00X0
05KJE]]FfU[KE]YFfeKJ001:^`9>^`08C[a:^djkC[/0049lAYa2W0L00008:S`001Wk6O`000Vk1IX9
V`8000030=H0000001aoo`03001oogoo06moo`<000eoo`8001moo`0017oo00<007ooOol02Goo0`00
4Woo018006/II_Q[6FKhJaT006LJH_UW6F;i001NnF;jG_URnUkiH_X3000025[KE[YJfeKJF]]F^P00
D[/200001TjlBY]>_4ZKC[a:V`<00006?Wa2W@00=WdbG3Im1@0000DMo0002K/5VPVk008000030=D0
000001]oo`03001oogoo02moo`D003Qoo`<0011oo`03001oogoo01ioo`0017oo00<007ooOol037oo
0`003goo00L006KiIaUVn6LI001Vn@03H_T00`00G_YRnP02H_X015kjH_YRnP000Ukj0P0000AFfUKK
000000=Bf`05E]/00000C[]>_00200002dJl000nO3jL?W`nW000=U`bG3IM00000RHl1P0000<9V`00
00000`006Woo00<007ooOol09Goo2P0000EO_P00FiiKWEnN00T002eoo`8001Aoo`03001oogoo01eo
o`0017oo00<007ooOol03goo0`002goo01P006KhJaUVn6/II_P006;iIaURnFLJ001RnUkiH_YNnF;j
G_T005[JG_]JfUkkF]X2000025KLD[]Ffe:kE]aB^eKKD[/2000014ZlAY]:_4JL0P0000Y2WCil@Yd0
03Im<U`fO@00:SdV708000036O`000Fk00P001Qoo`03001oogoo021oo`D00009Fkd005^mGmiK_EoN
001O_U^M0080000=GiiKWEnnFieOWP00FiiKOE^N001KWUMmFih01@009Goo0`005Goo0P007goo0004
Ool00`00Oomoo`0BOol30008Ool<0002H_X01EkjH_YRnV;j00001Ekj00H005[k000005;KE]/3D]/0
4P00C[/004JlB[a6W4ZlA[a:_000?Y`nO3jL000fG39L=Ud0008V?0039Sd001Gl00800085^`<00003
G<00000001Moo`03001oogoo01]oo`D00004Fmd005_MGmd20003Gkd20002Gkd01P00FieKWU^MGiiK
W@800006FiiKO@00001KOUMn0U]n0P000eMn10007Woo0`006Goo00<007ooOol07Goo0004Ool00`00
Oomoo`0EOol40004Ool03000JaQ[>F/H001W6F/IIaU[>@00IaYRn@<0000=G_URnP00G_]JfUkkF]YN
n`00F_]JfU[kE]X00P0000IFf`00001>^e;LC[/200001DZlAY]:_4JLB[`03P0000@Eo0001IX5^`<0
0003G>00000001Ioo`03001oogoo01Moo`@00004Em/005_LFmd200002E^mGmd005oNFkeOgU^m001K
W@05000035^MGkiKW@00FgeKWU]m001GOE^NEgeKWP800005EeeKOUMMFgiGG@0200000eMnEeh00002
000HOol3000LOol00`00Oomoo`0MOol000=oo`03001oogoo01Yoo`@00005JaQ[6F/HJcT00002IaT0
26/IIaT006LIIaYS6FLJIaT40003G_X04`00F_]Jfe[kF]]Jne[KF_/005;LC[]>g4jlD]a>^dkL001:
_4JL00800006A[d003ZM>WdjW@000RiM00<bG@008Sd00R8m1@0000D5^`000GX005c0008001Eoo`03
001oogoo01Eoo`<0009Gg0800004FmaKg@00Gmd:00001E^n001KWU^nFih03@0015Mn0P0000AGGUMn
EeiGGP800003Deh0000001=oo`<001ioo`8001moo`000goo00<007ooOol07Goo01@006/iJaQ_>@00
JaUW6F/iIaT006;iIaYRnFLJH_UW6P00HaYNnV<J100000QJfU[kE]YJne[JF_/005Kl0P0000I>^e;L
C[]Bg4jkD]`2000014:LA[e2W4Jm0P0000HjO3ZM000002iL<Wd200001B8l9Sd000004O`0100000<1
NP0000000`004goo00<007ooOol04Woo1@0000AGg5Ol001Oo@D00005Emd005_NEkeKgP02000025Nm
Fkh00000EieK_UNMFkh200002eNMFih00000EgeKWUMnFih005^NEgh01@0000=CGEMnEeh00P0000EG
GU=NEeiCGEMN00@000aoo`<0029oo`03001oogoo01eoo`000goo00<007ooOol077oo00P006/IJaQ[
>F/H001W6F/I0VLI00l006LJHaUW6VLIIaX006<JH_YS6V;jHaX005kkG_X00P0000EJne[K000005Kk
00=Ff`80000EC]a>_000001:_000A[e2W4Jl@Ya6_D:L000jOCZM>W`002iM<Ud^G@00008R?@038S`0
01Gl00@000030GX0000000<0019oo`03001oogoo011oo`<00003Cm/005OL00L00006EmeG_@00001K
gUNm0P0000QK_U^mFkh005^nFiiK_U^N0P000U^N0P000UNN00AKWUMn000000=GOP8000=GOP@00004
EeiCGUMNDeh20004Deh40005Ool3000UOol00`00Oomoo`09Ool20004Ool20004Ool20006Ool000=o
o`03001oogoo01aoo`0K001[66liJaP006LIJcUW6F/I001W6V;iIaYRnFLJ001S6UkjHaYNnV<J001O
6ekjGa]JnUlK00800008D]]Fo5KKE_aBfeKlE]]Fo0800004B[a>g4ZlC]`200000d:LA[e2W00@0000
0aHL0005g007000AOol00`00Oomoo`0>Ool:000025?M000005>mEmiG_@00EkdC00001eMmFiiGOP00
EgeKWUMn00800005EgiGGUMnDeiGOP0200000e=NEgh0000300001U<nDeiC?U=NDciCGP800003CciC
GP0000@002Qoo`03001oogoo00Qoo`04001oogoo0008Ool01000Oomoo`001Goo0003Ool00`00Oomo
o`0KOol01`00JaQ[>F/HJaT006/I00=W6@0D001S6FLJIaUW6P00HaYRnV<JH_YS6V;j001NnUkkG_YN
nekj001Jn`80009Ff`06E_]FfeKK001Bg0000TZl00A>g4ZlB[a:_0<0000<?Ye2_CjM000fOCJM=Wd0
02YM;WdZG@000R8m00<N?@0000001P0000=HX00000000P003goo00<007ooOol037oo0P0000=3V000
00000P0000=;_00000002P0000E?_@00DkiG_U>n00800003EkiGWUNn008000=GWP04001GWUNNEih9
0003Egh2000015MNDeiGOU=N0P000U=N0P000U=N0P0000ACGTlnDeiC?P800003Cch0000002Moo`80
00Yoo`04001oogoo000;Ool00`00Oomoo`03Ool000=oo`03001oogoo01]oo`03001_>F/H00h0000=
HaYNnV<JG_X005kjGa]JnUlKG_X005[kGa/00U[k0P0000IFf`00001Bo5;KD]`200001DZlC]`00000
A[`00P0000Q2_CjL@[dnW000=WdfWCIm0P0000H^OBYM0000028m7S`200000aHM00000009000=Ool0
0`00Oomoo`0:Ool>00000dnmBke?_P0200001TnmDmh00000DieG_P800003DiiG_U>N00800003EkiG
WUNn00800004EgiGWU=nEil200001e=nEil00000DgiGWe=n00@00003EgiCGUMn00800003DeiGOU=N
009CGP07Egh00000001CGTlnDeh00P0000E??U=NCciCGTln00<002Eoo`03001oogoo009oo`@0009o
o`04001oogoo0009Ool20006Ool000=oo`03001oogoo01Yoo`03001[>@00008000A[>@06001W6FLi
IcU[>P000fLJ1P0000ANnUkkG_X000MJn`03001Bg5;L00EBg0800005B[e6_4JmA[a:_@0200001cjM
@[dnW@00=WdfWCIm00@00007;Ud0028m7SdR?@005Qd030002goo00<007ooOol02Goo2P0000=3W000
00000d^m0P0000EC_TnnDkh005>n00T000=GWP03001GWUNN009GWP80009GOP8000=GOP04DgiGOP00
0002Dgh50004Deh20003Deh40004Cch20003Cch2000SOol20009Ool01000Oomoo`002Goo00<007oo
Ool01Goo0003Ool00`00Oomoo`0JOol200000fmIJcP00002JcT04F/IKcT006/jIaU[>VLI001S6FLj
HaYW>V<I001S6V<KGaX0100000QO6e[kF_]JnelKF_/005KK0P0000=Bg4kKD_`00P0000U>g000001:
gDJlB]e6_4[MA[`01`0000@bOCJN000ZOPP000034O`000GK00<00003C400000000@000Uoo`03001o
ogoo00Moo`H00003<gXgN`0001800007Dki?WU>o001C_dnNDkl03P0000=COUNODgh00P0000AGOe=N
EgiCGP800003DgiCGUMo00@00004CeiCGTlnDeh200000dlnDem??P0400000dlnBci??`02Cch00d/n
Ccl00002000OOol2000;Ool2000:Ool30005Ool000=oo`03001oogoo01Uoo`05001_>6liKcP00004
JcT01P00IcUW>F/jIaT0009W6P04HaYW6VLJ0003HaX00f<KHaX00002Ga/20002F_/2000015KkE_aF
neKl0`001DkL0P0000U6_4Jm000004:m000jWCjm>Yd00P0000<fWS9m<Yd00P0000HZGBYm000NGAhm
7Ud800000da0D60000070005Ool00`00Oomoo`05Ool=0002?id01Smm000004NnAie7WP800007Bii;
_P00001?WTnnCih00P000e>N0P0015>N0P0000ACOU>N000000=COP@00003EgiCOU=n008000=CGP04
DgiCGP000002Deh400001E=NCciCGTlnDeh00P000Tln0P000dln0P000dln0`007Goo00<007ooOol0
7Goo0003Ool00`00Oomoo`0IOol07`00KeU[>6mI001[>F/IKcU[>@00IaU[>VLI001S6FLjHaYW>V<I
IcX006<KGaYS6f<J001NnV<KG_YO6ekj00800008F_aFfe[lE_]Jo5KK001Bg0800006C]e>g4kLC]a>
gDkL0P0000A6gD:mA[e2_0800003?[djWCjn00800006<WdfWS9m000VGBYn0P0000DN?B9N0000018L
00L00003C400000000X000=oo`L000037aTJn1lI01h00003DgiGWe>N00800009EimCOP00001GWe=n
DimCOUNO00800003DeiGO`0000@00003DgiCGUMo00800004CeiCOe=NDeh200001DmN000005=OCch0
0P0000ICGdlnCei??U=OCch3000014/nCci;7Tlo0P0000A;7Tlo000001]oo`03001oogoo01eoo`00
0goo00<007ooOol067oo00D006liKcQ_>@0000A[>@08001W>F/jIaUW>@00IaYS6P=W6P04001S6V<J
Ha/2HaX00`00Ga]O6`03Ga/01P00Fa/00000E_]Fo08000=Bo003E_`00000009>g080000<B]d00000
A[e2_DJm@[e6_@00?[djWCjM300000@NG@005SdF?@8000032Q`0000001`00003;e`[?2ll008000<k
O@8000=3WP800004Aii;WTNNAih20002Bih200000dnNCim?WP090003Dgh20004Dgh200000e=nDeiC
OP040003Deh200001E=NCeiCGTmNDeh010000dln00=?GP0000000dln10000T/n00A??T/nBci;?P80
01Uoo`8001ioo`000goo00<007ooOol067oo00L006/hKeU[>000JaU_>@02JcT00`00JcX0000:0000
3V<KHaYS6`00Ha]NnUlKG_YS6`00GaaJnelLF_/300001e;LE_aBfeKlD]aFo5;K00800005B]e:_4kM
B]a:g@0200000d:mA[e2_00400001SZn=Yd00000<Yh^O@800004:WhVO@007Ud;000013`0@00l0400
900000=7OT^OAih00P0000Q?Wd^N000004nOCgi?Wdmn0P0000QCWdmnDim?OP00CgiCWdmn100000=C
Oe=NEgl00P0000A?GU=oDeiCO`800003CeiCOdmN00@00004Dem?GU=NCch2000015=OCciCGdln1000
00A??T/nCem??P800007Ccm;?P00001??d/NCcl00P0000A;7T/o000001Qoo`03001oogoo01aoo`00
0goo00<007ooOol05goo00D006lhKcU_>000009[>@D00003JcT006/j00=W>P03JcX006Lj009W>PD0
00=O6`09001K6e[kFa]Jne/K001K75Kk00800003E_aBo5;l00800005C]aBo000001:g003B]d40000
23jm@[d00000>Ydj_SZM>[h20002<Yh200000bIn000000027Ud010005SdFGAIM200000<X02@0:000
1@0000D6>@8i000000jJ00<:VPD000@[?@8000<gGP8000@oOPh00003Cim?WU>O00800003CgiCWdmn
00800003Dgm?OU=n00T00004DgiCGU=NDeh200000e=NCeiCGP050003Ceh014ln000004mN0Tln1000
00I;?TlnBci??T/nCch300000d/nBai;?P02Bch014/N000000005Goo00<007ooOol077oo0003Ool0
0`00Oomoo`0GOol01000KeU[>6mI0`0001E_F@00KeY[>F]JJcT006LjJcYW>F]JIcX006<JIc]S6VLk
001S>f<JHc/0100000=JnelLF_/00P0000EK75KkFaaFne/L00<00006D_e>g5;mC]aBoDkL100000Q:
gDJm000004:n?[e2gSjm0P0000<j_SJM>[h01`0000@ZOP008WhNG@8000036UhF?AYM00X000031QX6
>`0000T000056]`No1[L7_`Jg00:000014=o?ghoOcmn0P0000Q7Wd=n000004^OAgi;WdMn0P0000=?
Wd]nCil0200000A?OU=oCgiCO`800004CeiCOdmNDgl200000dmNDgl00003000014mNDem?GU=o0P00
00A??U=OCeiCG`@00005Cci?GdlnCem??P0200001TmO000004/nCcm;?P800007Ccm;7P00001;?d/N
Ccl00P0000=77T/oBah00`004Goo0P005goo10000goo0003Ool00`00Oomoo`0FOol00`00KcU_>002
0004KeT01@00JcU[>F/i00000fLj00=[>VLj00000VLj00US>VLj001S>f<JHc]S6f<k00000UlK1000
00MK75KkF_aFo5/LE_/00002E_`200000dkLD_e>g00200000dkm00000004A]d200000cjm@[e2_@04
00001SJn=Yh00000<Yh^WQ00008>?1P00003=ehcGSMN008gGPT0009;O`07Bil00000Bgm;Wd]nBgl0
0P0000=;OTmoCgl00P0000=?Odmn0000100000=?OU=nDgh00P0000ACOTmNDgm?GP800003Dem?GP00
00<000I?GP800003Ceh00000009??P8000E??P<000E;?P@000=;?P05Bah00000Bcm77P02000@Ool0
0`00Oomoo`0DOol01000Oomoo`0017oo0003Ool00`00Oomoo`0FOol300008VmH001[>FmIJcT006/i
JeY[>FmJ001[>VLiJeYW>P00HaYW>f<JIc]S6P00HaYS>elJHc/005lkGa]S?5lK001K6elL0P0000UF
ne/L000005;lEaaBo5LLD_`00`0000E:g4kmB]a>oD[L00800003B]e6_D[M00@00008?[dngP00>[hf
WCJn=Ydj_P800003;YdbWP0000<000077WdROP00000JGAYn6Ud0400000<F_A:L5[d01@0000D[?R/M
:ah[7B/n00D00004?glkGSmo>eh200000d=o@ei3O`0900000dnOBgi?W`02000014mnCgm;OTmo0P00
00=?GU=oCeh0100000=COdmNDgl00P0000Q?GU=oCeiCOdmN001?GU=O0P0000U?GU=O000004lnCem?
?TmOCch00`0000A;?TmOBci?G`800003Bci??d/n00D00004Bai;?d/NBcl400001TLNBcm77T/oAai;
?`8000ioo`03001oogoo01Aoo`04001oogoo0004Ool000=oo`03001oogoo01Eoo`800003KeU_F000
00A_F@05001[>F/iJeX00002IcX01V/jIcYW>P00IcYS>P9W>P06001S6V<kHa]S>`0015lK00H005/K
GaaK6e/LFa/30002E_`01U;lE_aFo5Kl001Bo@800006B]e>oDkMC_e:gDkm0`0000M6gD;M000n_Cjn
?[dn_P020002=[h00cJN0000000800001b9n7Wd000006WhJGAYm00D000035WdBO@0000X000048]dR
oB;M8_h50002<ch00cLn<chc?P040002@gl014=n@gl000000dMo0P000d]o2@0000A?OdmnCgm?OP80
0003Cgm?GTmo00D00003Dem?GTmN008000=?GP03Cem?GP0000800004Cci?GTmNCeh200000dlnCei?
?P04000014lnBci??T/n0P000T/n0P000d/n0P0000M;7T/n000004LNBci;7P02000014LnAah00000
2goo0P005Goo0P0000=oo`00000017oo0002Ool00`00Oomoo`0EOol04@00KeQcNFmHLgT006mIJcU_
F@00JeY[>FmJJcT006LiJeX03`0000aS?5lKGc/005lLFa]O75/KGa`005/LE_/2000025LLD_`00000
D_e>o5;mD_`200002TkmB]`00000B_d004KN@[e6gT;M0P0000<ngSjm?]h0100000LbWSJn<Yh002jN
<[h^WP0Q000012[n;ah[7RlN1@0000@oGc]N>elkGPT00004Agi;OdMnBgl2000014]NCgm;OT]o0P00
00=;GTmo00000`0000A?GU=oCei?O`800004Cei?OdmNDgl4000014mNDem?GU=O0P0000=??TmOCch0
100000A?Gd/nCem;?P800003Cem;?TmO00@00006Bai??d/nCcm;7Tlo0`0000I;?d/NBcm77T/oBah3
00001DLNBcm77T/oAah00`002Woo00<007ooOol077oo0002Ool00`00Oomoo`0EOol01@00KeU_F7=I
000016mI00<006/i00001@0000Q[FP00IeYW>VMJIcX006<j0fLk00@006<kHc]S>`@00003Fa]K75/K
008000=K7003EaaK700000800007D_eBo5;mD_aBoE;lD_d00P0000A:gD[mB]e:g@800003@]e6gD;M
00@00004?[hj_P000004=[h20002;Yh200000bZN9Yh0000200000b:N000000027Yh200000ajN6YhN
WP0200001aZN7[h000007[hNgQjm00@000039_h0000000<00005<clc?S<o<chc?`050002?el01T=o
000004=OAgm3G`D000=;O`800003Cgm;OT]o00800003Bei?Odmo00D00004Cei?GdmNCgl200000dmN
Cem?GP040002Ceh01dmOCeh00000Cem??TmN00@0009??P04Bci??P000002Bch20003Bch20002Bch2
0002Bch01T/o000004/nBcm77PD00003Aai7?dLN008000Qoo`03001oogoo00=oo`8001Moo`000Woo
00<007ooOol057oo00P007=iKeQcNFmH001[>FmI100000=[F@00JcT00f]J00e[>@00IcY[FfLj001S
>VMKHcYWF`00Hc]O6`03Hc/00`00HcaO6`0400002E/LE_]K75KlFaaFn`00E_aG7@0200000e;lD_e>
o00200001dkm000004[MB_e6gD[m00@00003@]e2gSjm00800003?]hj_CkN00800003<Yhf_S:N02@0
0003;alZoRlO00D00004>elg?S]O>ch5000014=NAgm3GTMo0P0000=7GTMoAeh02@0000A;GTmoBei?
O`800003Bei?Od]N00@00004Cem?GTmoCeh200000dmOCei?G`04000014/nCem??TmO0P0000=;?TmO
Bch0100000I?Gd/nCcm;?TmOBch300001D/nBcm;7T/oBch0100000A;?dLNBcm77P800008Bcm77P00
001;?dLNBcm77P@000Eoo`03001oogoo009oo`04001oogoo000FOol0009oo`03001oogoo01Aoo`06
001_F7=IKeP006mI0`0000E_FFmJJeU_FP0000A[FP06001W>VMJIcYWFP000fLk00=S>P00Hc/00f<k
00<005llGa/00Ulk00<005/LFa`00P0000EG75/L000005Kl00=G7004E_`000000005C_d40002A]d0
0dKn00000002@]h00d;M@]h00007000013:n000000000Rjn0P0000LZWRZn:Yh002JN9[hVWP020000
0b:n8YhR_P0200028[h200038]h200039_h50002<cl00cLo<ahc?`050004?el9000014MOBgm;Od]o
0P0000=;Gd]oBel010000TmO00M?Od]N000004mOCei?G`04000014mNCem?GTmN0P000dmN100000A?
Gd/nCci??P800004Cci;?P000002Bch01Tlo000004/nBcm;?PD00004Bci;?d/nBch400001TLNBcm7
7T/nAai;?`@00004Aai77dLNAcl30002Ool00`00Oomoo`02Ool01000Oomoo`005Woo0002Ool00`00
Oomoo`0COol01@00KeQcNFmHLgT00P0000M_FG=i001_NV]IKgX00003JeX03F/i001W>V]KIcY[F`00
Ie]S>VMKHcX005lK00=S>`0;001S?5lKGcaO6`00Fa]O?5/KGcaK6`04000015LMD_aG7EKl0P0000IG
7@00001>g5;mC_d2000024knB_d00000B_i6gDKnA]d400001d;N?]h00000>]hj_S[N00800003<[hf
_S:n00800006;[l^WP00000Z_bJN0P0000<V_R:N9[l00P0000<RWRJo8Yh03@0000@^oRlO;_h_7`D0
0004>elg?S/o=ch50003@el01T=o000004=OAgm3G`@00004Bgm;GT]oBeh200000dmoBei;O`040000
14]NCgm;GTmo0P0000=;GTmOBeh0100000A?Gd/nCem;?P800003Cem;?TmO00@00006Bci?Gd/nCem;
?TmO0`0000A;?d/nCcm;?P800007Bcm;?P00001;?d/NBcl00P0000M77T/o000004LNBcm77P020000
1d/oAah00000Acm77T/o00800003Aai;?`00008000Aoo`04001oogoo000FOol0009oo`03001oogoo
01=oo`03001cFFmH008000=_N@05001_FV]IKeX00005JeX00`00IeX0000>0002Gc/01Ell001K75/L
Gc`00U/L00@005/LFaaK70@00005D_eC7E;lDaeBo@0300000d[mC_e:o@02B_d00dkm000000020000
14;MA]h0000013kN0`0000<jgSZn0000500000LV_R[O000002KN:]lVgP0200000b[o:_hZoP050000
0cLo<alg7`0400000c/o00000003?el00clo000000020003Ael00d=O00000003Ael4000014]OBgm;
GT]O0P0000=;GT]OBel0100000A?Gd]NCem?GP800003Cem?GTmO00@00004Bci?GTmNCel200001d/n
Cel00000Bci??d/n00800003Bcm;?T/n00@00003Bci;?d/n009;?P@00005Bcm77T/nBci;?`040000
1DLNAci77T/oAah0100000E77dLNAcm77TLO00<000=oo`04001oogoo000FOol0009oo`03001oogoo
019oo`0>001cN@00001_N000KeUcNFmI001[FFmjJeT0009[FPD0000?Jg/006MKIeY[FfMJ001S>fML
Hc]WF`00HeaO>f=L00@00003Fa]O?5/K00800008FceG75/LEaaK?@00EaeG70800006DaeBo000001C
7Dkl0P0000=>oD[MC_h00P0000M6g@000016oT;MA_i2g@0400000d;N0000000200001SJn>]l003KO
<[hfg`800003;[hbgbjn00800006;]lZ_P00000ZgbJn0P0000@ZgbJn:]lV_PT00003;_hc7bkn0080
0004=clc7SLo<ah500000c/o?elk?`0200000d=O?em3G`04000014MOBgm7GdMo0P0000=7GT]oAeh0
1@0000A;GTmoBei?O`800003Bei?O`0000@00004Cem;?TmOBeh200000dmOBch0000300001DmOBci?
Gd/nCel0100000A;?TmOBci??`800003Bci;?d/n00D00004Bai;?dLNBcl5000014/oAai;?dLN1@00
00A77T/oAai;?`P000Aoo`8001Moo`000Woo00<007ooOol04Woo0P000W=i00L006miKgU_N@00JeU_
FP0500001Vmj001[FV]JJg/000AWF`07001SFfMKHc]WF`00Hc`00f<k00AS?000GcaO?0D000=K7080
0005EaeG75LMEaaG7@020003C_d00e<MC_e>o@030002B_d00d[nB_e:o@090002?]h200000c[N=[hj
gP020003<[hA00000b[N:]lZgP020003;_l:0004>cl40002@el013mO@el000000d=O1@0000A7Gd]O
Aem;G`8000=;G`@0009;G`07Cem;GP00001?Gd]NBel0100000A;GTmOBei?G`800003Bci;G`0000@0
0004Ccm;?T/nBch4000014/oBci;?T/n0P000T/n0P000T/n00E;?`00001;?T/o00800003Aci;?dLN
00800006Bcm77P000017?dLN0`001Woo00<007ooOol06goo0002Ool00`00Oomoo`0BOol02000LiU_
N7>I001cNFmILgX400008F]JKgY[FVmkJeX006MJJg]WFP00IeY[FfMJIe/006MLHc]WFf<k001O>f=L
Gc]SG000GcaO>f<lGc/005/LGcaK7005000015LLEaeG75LM0P0000IC7000001C7DkmDad200001d[m
Cah00000A]e:oTKM00D00008@]i2oP00000jgSkN>]hngPP00007<[hfg`00000^_S;O;[h00P0000L^
gbZn000002kO:[h^g`02000012[N;_lZgRko100000<boS<O<_h00P0000<g?c<N=cl01@0000@oGc/o
?elk?`D00004@em7Gd=OAel200000d=OAem7G`04000014]OAei;Od]N0P0000=;Gd]NBel0100000A;
?TmOBei?G`800003Bci?Gd/n00@00004Cem;?TmOBch200001TmO000004/nCem;?P800003Bcm;?TmO
00@00006Bci;?d/nBcm;?T/o0`0000E;?dLNBcm77T/o00@00005Aai;?dLNBcm77P030009Ool00`00
Oomoo`0KOol0009oo`03001oogoo015oo`05001cNG=iLgT00003KgT20002KgX02P00JgY[NVmjJgX0
06]JJg][FP0016MK00H006MKHc]WFf=K0003Hc/00f<l001O?002Gc`200000e/lGcaK?002Fc`01000
FaaK?5/L100000EG7E<MDaeC7ELM00<000I>o@@00096oP800092gP03@_i2gP0000<00004?]hjgP00
0002=]h01S[O000003;N=]lbgP800003<]l^_S;O00d00006<_l^o`00000c7c;o0S<O1@0013/o1@00
00=3Gclo00001@0014MO0P000dMO10000T]O00E;GT]O000004]N009;G`@00004Cem;GT]OBeh20000
0d]OBei;G`0400001D/nBcm;?T]OBch00`000d/n00E;?`00001;?T/o00800003Bci;?d/n00800003
Bcm;?T/n00D00004Bcm7?T/oAch5000;Ool2000MOol0009oo`03001oogoo015oo`06001_N7>ILgP0
06mI0P0000]_VVmiKiX006mjJeY_Nf]J001WFV]k01L00003GcaK75ll00800007EaaK?ELLFceG7000
Ea`00P0000=G7E;lEad00P0000E>oE<M000004[m00@00007Cah00000A]e:oTKMA_h0100000<ngT;o
?]h00P0000<noc[N?]l00P0000<fgS[O=[h0200000Lboc;N000003;o;]hbo`0200000bkN<_l^gP09
0003=al00cLo00000003000013lo>cloGc/o1@0000=3?`0000001@0000A7GT]OAei;G`800003Aei;
GdMN00@00004Cem;GT]OBeh200000d]OBci?G`04000014/nCem;?TmO0P0000=;?TmOBch01@0000=;
?TmOBch0100000E;?d/nBem;?T/o00@00004Aai;?dLnBcl200001dLNBcl00000Aai;?dLN0080011o
o`03001oogoo01]oo`000Woo00<007ooOol047oo00@007=iLgUcN0<00005KiT006mjKgX00002JgX0
0fmjJgY[NP0400001VMkJg]WNfMk001WN`=WF`0:001SFf=LHe]SG000HeaOG6=L0003Gc`500000e/l
FaaK?@02000015LMEceG75LM0`000e<M00=?7@0000000`0000E:oD[nB_e:oT[m00@00003A_i2oTKn
00800004?]i2oSkN@_h800001SKN=]l00000<]hfg`800004<]hbgc;O<]l90002<_l2000013LO<alg
7c;o1@000S/o00<k7c/o0000100000=3?clo?cl0200000=7G`0000001`0014]O100000A;GT]OBem;
G`80009;G`03Beh0000000800004Bem;?T]OBch200001d]OBch00000Bcm;?T/o00800003Bci;?`00
00@00004Bcm;?T/nBch400001D/oAci;?d/nBcl010004Woo00<007ooOol06goo0002Ool00`00Oomo
o`0@Ool03P00LiUcN7>I001cVVnI001_NFnJKgT006]JKg/400007V]jJi/006]kIe][N`00IgaWFfMl
He/006=KHeaSFfML001SG5lkHe`005mLFcaOG5llGe`005lmFcaO?@D00003EceG75Lm00800003DaeG
7@0000<00004C_d00000Cah200000d[mBai:o@02000024[nA_d00000A_i2gDKn@]h400001T;o?]h0
0000?_ljgP800004>]lfgS[o=]h800000cKo<]hfo`0200000c;N=_lbgP09000013LO>clg7c/O1@00
00@o?c/o?clk7`D00004@cm3Gclo@el600001dLoAel00000Aci;GdLn00D00003Aci;Gd/n00@00004
Bem;?TmOBch200000dmOBci;G`0400001D/nCem;?T]OBch0100000A;Gd/nBcm;?P800006Bcl00000
Bci;?dLn0P0000=;?dLNBcl01@005Woo00<007ooOol06goo0002Ool00`00Oomoo`0?Ool00`00LgUc
N002000017>JKiUcV@000Vmj100000M_VP00Jg][NV]k001[N`03Ig/03`00Ie]WFfMK001SFf=LHe]S
G000HeaOG6=LGc`00003Gc`200001U/mFcaK?5/lFcd000=K?@<00003EaeC7E<M00800005Dad00000
001>o@03Cad00dkm0000000200001D[nA_i:oTKnB_h010000T;n0P000Skn00<ngSkn00001`0000<f
gS[o=]h00P0000HfocKN000003Ko<]h2<_l40003=_l200000cKo=alg7`0500000c/O>clk7`020003
?cl200000clo@cl00004000014=O@cm7Gd<o1@000dMO0P0000=;GdMOAel01@0000=;Gd]NBel01000
00A;?T]OBci;G`800003Bci;Gd/n00D00004Bci;?d/nBcl4000014/nBcm;?T/o100000A;?T/oBci;
?`8001Uoo`8001eoo`000Woo00<007ooOol03goo00T007=h001cV000KiUcVP00KiX00P0000m[NVnK
JgY_V`00Ji][NV^K001[NfMKJg]WFP00Ie/04`0000=K?5lmFc`00P0000MK?ELLFceG75/m001G?@03
00001ULmDad00000Dai?7@D00004B_e?7T[mCah500001DLNA_h00000A_l00T;n00=2gP0000000P00
00HnockN000003ko>]h2000013[o=]hjocKN2@0000PfoSKo000003;n=alboSLO1@0000Pk7cLO0000
03/o>alo?c/O100000A3?clo@elo?`800006@el00000@cm7Gd<o0P0000=7Gd<oAel0100000A7?T]O
Aci;G`800007Aci;G`00001;?T]OAch00P0000=;GdLn00000`0000A;Gd/nBem;?P800007Bem;?P00
001;Gd/nBel00P0000=;?T]OBch0100000A;?dLnBcm;?P@001aoo`03001oogoo01]oo`000Woo00<0
07ooOol03Woo0`0000EcV@00KiUcVFnI00800004KiX006nKJiX2KiX01P00JgY[Nf]k001WN`D00007
Ig/006=LIgaSO6Ml000016=L00P005mLGeaOG000GcaOGE/l1@000U/m00=G?00000000P000ULm1000
0e<M0P000TlM0P0000=:oD/NB_d00P0000=;7P00000014Kn10000T;n0P000ckn00<no`0000001P00
00<foS[o=_l00P000cKo2@000SLO00<k7`0000000S/O00<g7c/O00000`0013lo10001D<o100000A7
GdLoAem7G`800097G`@00005Bem7?d]OAem;G`04000014/nBem;Gd]O0P0000=;?d]O00000`0000E;
?T/oBci;Gd/n00@00004Bcm;?T/oBch200000d/oBch00004000POol00`00Oomoo`0KOol0009oo`03
001oogoo00ioo`0A001c^G>HLkT007>JKgT006nJKkX006nKJgY_Vf]j001[NP0500003VMk001WNfMl
Ig/006=KIgaSFfMl001SO5mKHg`200003EllHeeOG000FcaOGE/lGeeK?000FcaKGE/l00@00004EceG
7ELmEa`200000eLmDaeG?P0300001U<NCae?7TkmDai?7@<00005B_e;7TKmBai:o@04000024LN@_h0
0000@_lngT;o?_h400000cko>]hno`02000023[N?_l00000=]hjocKN>_l4000023Kn>al00000=_hk
7cKn>al900000clo>alo?`05000014<o?cm3?clo1@0000A3?dMO@cm7G`@00004Aci7GdLnAel20000
0dLn00000004000014]OAci;GdLn100000A;GdLnBem;?P800003Bem;?P0000@00004Aci;Gd/nBel4
000014LnBem;?T/o0P008Woo0P007Goo00000goo001oo`0?Ool01P00LkUcVG>i001cV@80009_VP04
001_Vf^JKiX4000046^K001WNf^KIi/006MkIgaWN`00HeaWO6=lIg`006=L1@000emL00@005mMFcaO
G0800003FcaK?E/m00<00003EceK?@0000@00004DceC7ELmDad200001U<M000004lMCai?7@800006
Cah00000B_i;7T[n0P0000M;7TKn000004Kn@_i6oP0400000ckn@_lnoP02000013ko?_hnockn2000
0S[o0P0000@jocKo>_lfo`@000<k7`8000<k7`D00004?alo?clo?cl50003@cl50002Acl00dMO@cl0
0003000014MOAcm7GdLo2@0000A;?d]OBci;G`@00004Bcm;Gd/nBcl200000d/nBcl00004000014/o
Bci;?d/n10009Goo00<007ooOol06goo00000goo001oo`0?Ool01000LiQc^G>I0P0000AcfP00KkY_
VPD000=[V`06001WNf^LIg/006Mk2P0000ESO@00HgeOG6=m00h00003EcaK?ELm008000=G?@@00005
CaeC?U<MDci?7@0300001D[mCai:oDlNB_d0100000E;7TKnBai6oT/N00<00003Aam2oTLO00800004
?_i2ockn@_l400001c[n?_l00000>_hjoc[n00T00003>_hk7cKn00800004>alfoc/O>_l400000clo
>alo?`05000014<o?am3?clo1@0000=3?dMO@cl01@0000A3?TMOAci7G`@00004Aci;GdLnBel90000
14]OAci;GdLn100000A;Gd/nBem7?P800006Bel00000Bci;?dLn0P00:7oo00<007ooOol00goo0P00
17oo0P0017oo0P002Woo00000goo001oo`0>Ool02000LiUc^G>I001_^W>j0002KiX200000fnkJk/0
0003Ji/00`00Ig/0000400001fNL001SO6MlHgaWW00000=SO00:001SO5mLHgeOG6=l001OGEmLGed=
0004Ecd200000e<m00000003Dad200000dlNCad000040004Bah5000014LNA_h0000014;n100000Pn
ockn000003ko?_hnockn10000S[o0P000S[o00<k7`00000020000c/O1@0000<o7clo?al01@0014<o
1@0000=7?d<oAcl01@0000A7GdLoAcm7?`@00004Bem7?T]OAcl9000014/nBcm;?d]O100000A;?T/o
Bci;?`@002Yoo`8000=oo`04001oogoo0008Ool01000Oomoo`002Goo00000goo001oo`0>Ool02000
LkT00000KkUcfP00KkX200001V^kKk][VVnk001[V`@00009Ii/006NLIiaWN`00HgaWW6=l00800008
HgaSG6=m001SOEmLHgeOG0800003GgeOG00000800003FcaOGE/l00800007FeeG?5]MFcd005LmFed0
100000EC7ELnDaeG?U<M00@00003Dai?7E<n00800007Bae?7P00001:oDlNB_d00P0000M;7P000016
oTLOA_i77P04000024;n@al00000?_i37ckn@_l4000023[n?al00000>_ho7c[n?al400000c[n?alj
oP0200000clO>_lo7`0500000clo>alo?`0500000d<o?am3?`0200000clo@clo?`020002@cl50000
0d<nAem3?P05000014LnBem7?T]O100000A7?T]OAci;G`<00003Bel0000000<00004Bem7?T]OAch4
000^Ool00`00Oomoo`02Ool01000Oomoo`002goo00<007ooOol01goo00000goo001oo`0=Ool01`00
LkT007?I001c^Vnj00800005Km/006nkJk]_^`04000016NLIkaWW0000fNL00<006=l00005`0000=K
GE/mFed00P0000EG?E/mEceG?@00009G?@800007EceC7@00001C?U<MDcd010001DlN0`001D/N1000
00E77T;n000004<O00=2oP@00006?alnoP00000nockn0Sko100000<o7c[o?al00P0000@joc/O>alk
7`@00003>alo7clO00D00004?alo?`000003?cl00d<o000000020004@cl200000d<o00000003Acl2
00000dLoAel000040002Acl00d]OAcl000030002Bcl01D]O00000000Bcl00P000T/o00=;?P000000
<Woo00D007ooOomoo`00009oo`03001oogoo00Moo`8000Yoo`0000=oo`00Ool03Goo0P0000]cfP00
LmY_^@00JkY_f`00Kk][VVnk00800007Ik/006NKJkaWV`00Ii`01@0000]SW000HgaSWEmlHid006=m
GgaSWEml00<00008GeaOO@00GgeKGEmm001OG@9KG@@00003EceKGELm00800005EciC?ELnDceG?P03
000015<nDaeC?TlM0P0000=C?TlM0000100000=;7TlNBad01@0000Q6oT/N000004;nAam2oTLO1000
00PnoT<O000003kn@alnoT<O100000PjoSlO000003[n?aljoSlO1@0000<o7c[n?al01@0000Po?clO
000003lo?am3?clO100000A3?clO@clo?`@00005Acm3?dMO@cm7?`03000014MO@ci7GdLn0P0000=;
GdLn0000100000A7?T]OAci;G`@00003Aci;G`0000D003Aoo`05001oogooOol00002Ool00`00Oomo
o`07Ool00`00Oomoo`09Ool00003Ool007oo00aoo`0<001cfG?ILmT006nj001_^VoKKkX006^k0P00
0f^l00<006Nl00000`0000US_000HiaSWF>L001SO6>MHg`00P0000=SOEmmHgd00`0000QOOEmM0000
05mMFeeOG@001E]M00<005]MFed01@0015Lm0P0000=C?E<n00000`0000A?7DlNCaiC?P800003Cah0
000000=;7P800003Bah0000000A77P@00003@ai2oTLO00T00003?alnoclO00T000<o7`03>al00000
00<0008o7`8000@o7`@00003?cm3?clO00D000A3?`D00003Acm3?dLo00@000A7?`800097?`D00004
Bcm7?T/oAcl4000017oo00000000<Woo0`0017oo0P002Woo0`002Goo00000goo001oo`0;Ool01000
KmUcfVni100000=_ff^j00000`0000=[_6NkJm`0100000YSW6NmHi`006>LIieSW6Nm001SWA8000=K
G@800003FeeG?E]N00800003EceKGULm00@00004EciC7ELnDcd200000e<nCad00004000014/MCci?
7Dln100000A77T/NBai;7P@00003A_i77dKn00D00003@_i77d;n00800003@alnoP0000@00003?_i3
7ckn00800003?alnoSlO00D00005?alo7P00000o?`02?al00c/O0000000200000d<o?am3?`050000
0d<o?am3?`05000014Lo@ci7?d<n1@0000=7?TMO@ch0100000A;GdLnBem7?P800003Bem7?P0000@0
00Qoo`<0035oo`03001oogoo01Yoo`0000=oo`00Ool02goo00l007?ILmUcf@00KmX006oKKkY_f`00
JmaWf`00Jk`00`0000QW_000HkaW_6>lIkd006>M1@0000Aoo`00000000ioo`T00004EceGGELmEcd2
00000e<mEcd0000400000e<nDceC?P0200000dlNCci??P04000014lNBai;7T/N100000=;7TLNBah0
0P000TLN0P000TLN0P0000A2oT<N@ai37`<00003@alnoT<O00800004?_ho7clO?al40002?al20004
?al40003?al500000clO@cm3?`050003@cl5000014<oAcm7?dLo1@000dLo100000A7?TLoAcm7?`80
00ioo`<002ioo`03001oogoo01Yoo`0000=oo`00Ool02Woo00T007?JKkUcfP00KoX006oKJkX00P00
00=[g6OK00000`0000EWgF>lImd006Nm00D000Aoo`8001Yoo`D00003DceGGU<m00800003DciC?ELn
00@00004CaeC?TlMDch200001T/M000004lNBae??P800007Bah00000Bai6oT/OAah00`0000E2oTLO
@_i77d;n00@00008@am2oP0000137ckn@alnoP@00003@alnoT<O00T00003?alo7T<o00D00003@clo
7d<o00D00003@clo7d<o00D00003Acm3?TLo00D00004Acm3?TMO@ch500000dLnBem7?P04000COol3
000ZOol2000LOol00003Ool007oo00Yoo`04001cf@000002KmX400001V_L00000000Im`0009W_0@0
00Ioo`<0025oo`@00004DciC?E<nDcd20002Dch400001DlnCai??TlNCch00`001D/N10000dLN1@00
00Q37TLO000004<N@am37T<O10000T<O00<o7P0000000`0000@o7d<O000000<o7`D00003?am37clO
00D00093?`03@al0000000<00093?`800003@cm7?d<o00800003Acm3?`0000@000A7?`@001Yoo`<0
02Qoo`03001oogoo01Yoo`0000=oo`00Ool02Goo00H006ni000006ojJmX200000f_k000000020000
0f?LImeSg0030007Ool3000XOol4000014lMDci??E<n0P0000=?7E<n0000100000=??T/NCch01@00
00=;?dLNBah01@0000Q77dLN000004LO@_i77d;n100000=37d;n@al01@0000Q37clN000004<O?ai3
7ckn100000=3?clN@al01@0000M3?clN000004<o?ai3?`0200001d<N000004Lo@ci3?d<N00<00004
@ci7?d<nAcl200001T<n000004MOAci7?`80021oo`<002Eoo`03001oogoo01Yoo`0000=oo`00Ool0
2Goo0P0000I[n@00000006OKIo/2000015oK001Sg6OL0`001Woo0`00;goo100014ln0P0000I??P00
001;7TlNBah200000d/N00000003Bah200000dLN00000003Aah00dLO0000000200000d<N@am37P05
00001D<N@al00000?ah00d<O100000<o7d<O?al01@0000Po7d<O000003lO@cm37d<o0`001D<o1000
0d<o10001DLo0`009Goo0`008Goo0P0077oo00000goo001oo`08Ool00`00JoY[n@0300001FOK0000
06?lGm/010001Woo0`00=Woo1@0000A??T/MCci?7P@00004Bci;7TloBah300001DLNBam77T/oAah0
100000=77d<NAal01@0000Q77d;n000004<O?_i37d<N100000=37clN@al01@0000Q3?clN000004<o
?ai3?clN100000=3?clN@cl01@0000=3?d<NAcl01@0000=7?d<nAcl01@00:goo0`007goo00<007oo
Ool06Woo00000goo001oo`07Ool01@00JoU[n@00HoX0100000ASo000000000Moo`8003ioo`@00004
Bai??T/NCch40003Bah500000dLNAam77P05000024LNAal00000@ai37d<N@al40002@al00d<N0000
00030003@al900000d<O@cm37`050002@cl00d<O0000000300000d<oAcm3?`05000bOol3000LOol0
0`00Oomoo`0JOol00003Ool007oo00Ioo`05001[nP00001Sn@02000015_k000000001goo0`00A7oo
1@0000=;7TlnBah0100000=;?dLNBcl01@0000Q7?dLN000004LO@ai77d<N100000=77d<N@al01@00
00=3?d<N@al01@0000M3?d<N000004<o?ai3?`0500000d<o@ai3?`0500000dLo@ai3?`05000iOol3
000HOol2000LOol00003Ool007oo00Ioo`D00004EmX000000006Ool3001;Ool50002Bah00d/n0000
00020003Aah20002Aah00dLO0000000200000d<NAam37P0500000d<N@am37`05000014<N@al00000
14<O100000=37d<o@al01@0000=37d<o@cl01@00@7oo0`005Woo00<007ooOol06Woo00000`00Oomo
o`05Ool70006Ool3001AOol200000dLNBcm;7P0200001d/o000004LNBcm77T/o00<00003Aam37TLo
00D00003Aam37TLo00D00008@am37P0000137clN@cm37P@00003@clo7T<o00D00003@cm37T<o00@0
04Qoo`@0019oo`03001oogoo01Yoo`0000<007ooOol017oo00@005OG0017]`8000Ioo`8005Ioo`<0
0003Bai;?TLN009;7P@00003Aam77TLN00@00003Aai77d<N00D00004@am77`000002@al00d<N@al0
00030002@al00d<N0000000300000d<O@cm37`04001@Ool3000@Ool01000Oomoogoo1@004goo0000
0`00Oomoo`03Ool50005Ool3001KOol500000dLNBcm77P0500000dLNAcm37P04000024Lo@ah00000
Acm37TLO@ah400000dLo@ai3?`0500000dLo@ai3?`04001GOol3000<Ool20005Ool00`00Oomoo`0C
Ool00003001oogoo009oo`@000Aoo`<0069oo`D000977P03Acl0000000<00007Aam77P0000177d<N
Aal0100000=37T<O@al01@0000=37T<O@al01@00GGoo0`002Woo00<007ooOol00goo00<007ooOol0
4goo00001000Oomoogoo0`000goo0`00JGoo1@0000M77TLo000004<NAcm37P0400000dLo@ai7?`05
00000dLo@ai7?`05001TOol30007Ool00`00Oomoo`03Ool00`00Oomoo`0COol00003001oogoo0080
009oo`<006moo`800004Acm77TLOAah300000dLNAam77P0500000d<OAcm37P05001[Ool30002Ool3
0005Ool00`00Oomoo`0COol000<0009oo`8007Aoo`@00003Aai7?d<N00@00003Acm37TLo00D0079o
o`<00003Ool007oo00=oo`8001Eoo`0000<007oo00000P00NGoo1@0000=77dLNAcl01000NGoo0P00
6goo0003001oOol4001iOol4000MOol000=oo`@007eoo`03001oogoo07Aoo`@0025oo`001goo1000
NGoo00<007ooOol0L7oo10009Goo000;Ool4001eOol00`00Oomoo`1/Ool4000YOol000moo`D0071o
o`03001oogoo06Qoo`@002eoo`0057oo1000K7oo00<007ooOol0I7oo1000<Goo000HOol4001XOol0
0`00Oomoo`1POol4000eOol001aoo`@006Aoo`03001oogoo05aoo`@003Uoo`0087oo1@00Ggoo00<0
07ooOol0F7oo1000?Goo000UOol4001KOol00`00Oomoo`1DOol40011Ool002Uoo`@005Moo`03001o
ogoo051oo`@004Eoo`00;Goo1000Dgoo00<007ooOol0C7oo1000BGoo000aOol5001>Ool00`00Oomo
o`18Ool4001=Ool003Ioo`@004Yoo`03001oogoo04Aoo`@0055oo`00>Woo1000AWoo00<007ooOol0
@7oo1000EGoo000nOol40012Ool00`00Oomoo`0lOol4001IOol0049oo`D003eoo`03001oogoo03Qo
o`@005eoo`00Agoo1000>Goo00<007ooOol0=7oo1000HGoo001;Ool4000eOol00`00Oomoo`0`Ool4
001UOol004moo`D0031oo`03001oogoo02aoo`@006Uoo`00E7oo1000;7oo00<007ooOol0:7oo1000
KGoo001HOol4000XOol00`00Oomoo`0TOol4001aOol005aoo`@002Aoo`03001oogoo021oo`@007Eo
o`00H7oo1@007goo00<007ooOol077oo1000NGoo001UOol4000KOol00`00Oomoo`0HOol4001mOol0
06Uoo`@001Moo`03001oogoo01Aoo`@0085oo`00KGoo10004goo00<007ooOol047oo1000QGoo001a
Ool5000>Ool00`00Oomoo`0<Ool40029Ool007Ioo`@000Yoo`03001oogoo00Qoo`@008eoo`00NWoo
10001Woo00<007ooOol017oo1000TGoo001nOol40002Ool00`00Oomoo`04002EOol0089oo`D009Uo
o`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {172.625, 0}} -> {0.00419387, 0.0989838, \
0.003823, 0.003823}}]
}, Open  ]],

Cell["\<\
A contour plot of the temperature variation illustrates that the \
worm in a depth of about 1.5 meters cannot feel any changes in the \
temperature. Worms which are between the surface and the 1.5-meter limit are \
able to realize the temperature changes during the year. However, the contour \
plot shows also that a worm located at a certain depth will measure a certain \
value of the temperature some time later than an observer on the surface. \
This delay is larger for worms living in a deeper region.\
\>", "Text",
  CellTags->{"temperature variation", "contour plot"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[solution /. T\_2 \[Rule] 1, {x, 0, 2}, {t, 0, 1}, \n\t
      PlotRange \[Rule] All, \n\tPlotPoints \[Rule] 30, 
      AxesLabel \[Rule] {"\<x\>", "\<t\>"}, \n\tColorFunction \[Rule] Hue, 
      Axes \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.480769 0.0192308 0.961538 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -9 -9 ]
[.25962 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .21154 -18 -4.5 ]
[-0.0125 .21154 0 4.5 ]
[-0.0125 .40385 -18 -4.5 ]
[-0.0125 .40385 0 4.5 ]
[-0.0125 .59615 -18 -4.5 ]
[-0.0125 .59615 0 4.5 ]
[-0.0125 .78846 -18 -4.5 ]
[-0.0125 .78846 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .21154 m
.00625 .21154 L
s
[(0.2)] -0.0125 .21154 1 0 Mshowa
0 .40385 m
.00625 .40385 L
s
[(0.4)] -0.0125 .40385 1 0 Mshowa
0 .59615 m
.00625 .59615 L
s
[(0.6)] -0.0125 .59615 1 0 Mshowa
0 .78846 m
.00625 .78846 L
s
[(0.8)] -0.0125 .78846 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .25962 m
.00375 .25962 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .45192 m
.00375 .45192 L
s
0 .5 m
.00375 .5 L
s
0 .54808 m
.00375 .54808 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .74038 m
.00375 .74038 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .21154 m
1 .21154 L
s
.99375 .40385 m
1 .40385 L
s
.99375 .59615 m
1 .59615 L
s
.99375 .78846 m
1 .78846 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .25962 m
1 .25962 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .5 m
1 .5 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .74038 m
1 .74038 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .4 r
.01923 .72625 m
.05239 .74312 L
.06327 .74867 L
.08554 .75974 L
.1187 .77608 L
.13034 .78183 L
.15186 .79211 L
.18501 .80779 L
.20032 .81499 L
.21817 .82305 L
.25133 .83787 L
.27492 .84814 L
.28448 .85212 L
.31764 .86579 L
.3508 .87871 L
.35733 .8813 L
.38395 .89082 L
.41711 .90194 L
.45027 .91183 L
.45827 .91446 L
.48342 .92028 L
.51658 .92692 L
.54973 .93112 L
.58289 .93187 L
.61605 .92697 L
.64215 .91446 L
.6492 .90823 L
.66392 .8813 L
.66425 .84814 L
.65459 .81499 L
.6492 .79952 L
.6384 .78183 L
.61728 .74867 L
.61605 .74686 L
.5921 .71552 L
.58289 .70423 L
.56345 .68236 L
.54973 .6675 L
.5317 .6492 L
.51658 .63426 L
.49713 .61605 L
.48342 .60347 L
.45996 .58289 L
.45027 .57453 L
.42039 .54973 L
.41711 .54705 L
.38395 .52073 L
.37855 .51658 L
.3508 .4954 L
.33461 .48342 L
.31764 .47093 L
.2888 .45027 L
.28448 .44718 L
.25133 .42403 L
.24119 .41711 L
.21817 .40142 L
.192 .38395 L
.18501 .37928 L
.15186 .35754 L
.14138 .3508 L
.1187 .33616 L
.08953 .31764 L
.08554 .3151 L
.05239 .29429 L
.03684 .28448 L
.01923 .27375 L
F
0 g
.01923 .72625 m
.05239 .74312 L
.06327 .74867 L
.08554 .75974 L
.1187 .77608 L
.13034 .78183 L
.15186 .79211 L
.18501 .80779 L
.20032 .81499 L
.21817 .82305 L
.25133 .83787 L
.27492 .84814 L
.28448 .85212 L
.31764 .86579 L
.3508 .87871 L
.35733 .8813 L
.38395 .89082 L
.41711 .90194 L
.45027 .91183 L
.45827 .91446 L
.48342 .92028 L
.51658 .92692 L
.54973 .93112 L
.58289 .93187 L
.61605 .92697 L
.64215 .91446 L
.6492 .90823 L
.66392 .8813 L
.66425 .84814 L
.65459 .81499 L
.6492 .79952 L
.6384 .78183 L
.61728 .74867 L
.61605 .74686 L
.5921 .71552 L
.58289 .70423 L
.56345 .68236 L
.54973 .6675 L
.5317 .6492 L
.51658 .63426 L
.49713 .61605 L
.48342 .60347 L
.45996 .58289 L
.45027 .57453 L
.42039 .54973 L
.41711 .54705 L
.38395 .52073 L
.37855 .51658 L
.3508 .4954 L
.33461 .48342 L
Mistroke
.31764 .47093 L
.2888 .45027 L
.28448 .44718 L
.25133 .42403 L
.24119 .41711 L
.21817 .40142 L
.192 .38395 L
.18501 .37928 L
.15186 .35754 L
.14138 .3508 L
.1187 .33616 L
.08953 .31764 L
.08554 .3151 L
.05239 .29429 L
.03684 .28448 L
.01923 .27375 L
Mfstroke
0 .4 1 r
.01923 .24458 m
.03321 .25133 L
.05239 .26133 L
.08554 .27782 L
.09895 .28448 L
.1187 .294 L
.15186 .30987 L
.16821 .31764 L
.18501 .32534 L
.21817 .34039 L
.24163 .3508 L
.25133 .35492 L
.28448 .3689 L
.31764 .38219 L
.32193 .38395 L
.3508 .39474 L
.38395 .40637 L
.41711 .41686 L
.41776 .41711 L
.45027 .42611 L
.48342 .43372 L
.51658 .43921 L
.54973 .44182 L
.58289 .4402 L
.61605 .43079 L
.63352 .41711 L
.64844 .38395 L
.64614 .3508 L
.63487 .31764 L
.61752 .28448 L
.61605 .2819 L
.59545 .25133 L
.58289 .23432 L
.56949 .21817 L
.54973 .19524 L
.54015 .18501 L
.51658 .16046 L
.50777 .15186 L
.48342 .12852 L
.47262 .1187 L
.45027 .0987 L
.4349 .08554 L
.41711 .07051 L
.39482 .05239 L
.38395 .04375 L
.35255 .01923 L
.01923 .01923 L
F
0 g
.01923 .24458 m
.03321 .25133 L
.05239 .26133 L
.08554 .27782 L
.09895 .28448 L
.1187 .294 L
.15186 .30987 L
.16821 .31764 L
.18501 .32534 L
.21817 .34039 L
.24163 .3508 L
.25133 .35492 L
.28448 .3689 L
.31764 .38219 L
.32193 .38395 L
.3508 .39474 L
.38395 .40637 L
.41711 .41686 L
.41776 .41711 L
.45027 .42611 L
.48342 .43372 L
.51658 .43921 L
.54973 .44182 L
.58289 .4402 L
.61605 .43079 L
.63352 .41711 L
.64844 .38395 L
.64614 .3508 L
.63487 .31764 L
.61752 .28448 L
.61605 .2819 L
.59545 .25133 L
.58289 .23432 L
.56949 .21817 L
.54973 .19524 L
.54015 .18501 L
.51658 .16046 L
.50777 .15186 L
.48342 .12852 L
.47262 .1187 L
.45027 .0987 L
.4349 .08554 L
.41711 .07051 L
.39482 .05239 L
.38395 .04375 L
.35255 .01923 L
s
.2 1 0 r
.01923 .69656 m
.05239 .70937 L
.06868 .71552 L
.08554 .72131 L
.1187 .73227 L
.15186 .74197 L
.17783 .74867 L
.18501 .75011 L
.21817 .75641 L
.25133 .76014 L
.28448 .76015 L
.31764 .75374 L
.32954 .74867 L
.3508 .73075 L
.35868 .71552 L
.36136 .68236 L
.35305 .6492 L
.3508 .64127 L
.3378 .61605 L
.31764 .58313 L
.31744 .58289 L
.29289 .54973 L
.28448 .53917 L
.26479 .51658 L
.25133 .50173 L
.23354 .48342 L
.21817 .46803 L
.19942 .45027 L
.18501 .4369 L
.16267 .41711 L
.15186 .40769 L
.12349 .38395 L
.1187 .38 L
.08554 .35351 L
.08203 .3508 L
.05239 .32803 L
.03859 .31764 L
.01923 .30344 L
F
0 g
.01923 .69656 m
.05239 .70937 L
.06868 .71552 L
.08554 .72131 L
.1187 .73227 L
.15186 .74197 L
.17783 .74867 L
.18501 .75011 L
.21817 .75641 L
.25133 .76014 L
.28448 .76015 L
.31764 .75374 L
.32954 .74867 L
.3508 .73075 L
.35868 .71552 L
.36136 .68236 L
.35305 .6492 L
.3508 .64127 L
.3378 .61605 L
.31764 .58313 L
.31744 .58289 L
.29289 .54973 L
.28448 .53917 L
.26479 .51658 L
.25133 .50173 L
.23354 .48342 L
.21817 .46803 L
.19942 .45027 L
.18501 .4369 L
.16267 .41711 L
.15186 .40769 L
.12349 .38395 L
.1187 .38 L
.08554 .35351 L
.08203 .3508 L
.05239 .32803 L
.03859 .31764 L
.01923 .30344 L
s
.2 0 1 r
.01923 .21485 m
.03057 .21817 L
.05239 .22753 L
.08554 .23934 L
.1187 .25005 L
.12226 .25133 L
.15186 .25954 L
.18501 .26747 L
.21817 .27337 L
.25133 .27656 L
.28448 .27584 L
.31764 .26842 L
.34166 .25133 L
.3508 .23739 L
.35599 .21817 L
.35343 .18501 L
.3508 .1752 L
.34201 .15186 L
.32453 .1187 L
.31764 .10705 L
.30238 .08554 L
.28448 .06192 L
.27634 .05239 L
.25133 .0252 L
.24693 .01923 L
.01923 .01923 L
F
0 g
.01923 .21485 m
.03057 .21817 L
.05239 .22753 L
.08554 .23934 L
.1187 .25005 L
.12226 .25133 L
.15186 .25954 L
.18501 .26747 L
.21817 .27337 L
.25133 .27656 L
.28448 .27584 L
.31764 .26842 L
.34166 .25133 L
.3508 .23739 L
.35599 .21817 L
.35343 .18501 L
.3508 .1752 L
.34201 .15186 L
.32453 .1187 L
.31764 .10705 L
.30238 .08554 L
.28448 .06192 L
.27634 .05239 L
.25133 .0252 L
.24693 .01923 L
s
0 .4 1 r
.01923 .75542 m
.05239 .77609 L
.06145 .78183 L
.08554 .79701 L
.11362 .81499 L
.1187 .81824 L
.15186 .83979 L
.16447 .84814 L
.18501 .86172 L
.21403 .8813 L
.21817 .8841 L
.25133 .90697 L
.26194 .91446 L
.28448 .9304 L
.30818 .94761 L
.31764 .95454 L
.3508 .97942 L
.35255 .98077 L
.01923 .98077 L
F
0 g
.01923 .75542 m
.05239 .77609 L
.06145 .78183 L
.08554 .79701 L
.11362 .81499 L
.1187 .81824 L
.15186 .83979 L
.16447 .84814 L
.18501 .86172 L
.21403 .8813 L
.21817 .8841 L
.25133 .90697 L
.26194 .91446 L
.28448 .9304 L
.30818 .94761 L
.31764 .95454 L
.3508 .97942 L
.35255 .98077 L
s
.2 0 1 r
.01923 .78515 m
.05239 .80989 L
.05903 .81499 L
.08554 .83549 L
.10136 .84814 L
.1187 .86215 L
.14151 .8813 L
.15186 .8901 L
.17928 .91446 L
.18501 .91962 L
.21449 .94761 L
.21817 .95125 L
.24693 .98077 L
.01923 .98077 L
F
0 g
.01923 .78515 m
.05239 .80989 L
.05903 .81499 L
.08554 .83549 L
.10136 .84814 L
.1187 .86215 L
.14151 .8813 L
.15186 .8901 L
.17928 .91446 L
.18501 .91962 L
.21449 .94761 L
.21817 .95125 L
.24693 .98077 L
s
.8 1 0 r
.01923 .66505 m
.05239 .67288 L
.08554 .67863 L
.1187 .68159 L
.15186 .68056 L
.18501 .67318 L
.21306 .6492 L
.21817 .63895 L
.22232 .61605 L
.21817 .5855 L
.21745 .58289 L
.20454 .54973 L
.18596 .51658 L
.18501 .51501 L
.1629 .48342 L
.15186 .46892 L
.13609 .45027 L
.1187 .43049 L
.10599 .41711 L
.08554 .39614 L
.07292 .38395 L
.05239 .36453 L
.03724 .3508 L
.01923 .33495 L
F
0 g
.01923 .66505 m
.05239 .67288 L
.08554 .67863 L
.1187 .68159 L
.15186 .68056 L
.18501 .67318 L
.21306 .6492 L
.21817 .63895 L
.22232 .61605 L
.21817 .5855 L
.21745 .58289 L
.20454 .54973 L
.18596 .51658 L
.18501 .51501 L
.1629 .48342 L
.15186 .46892 L
.13609 .45027 L
.1187 .43049 L
.10599 .41711 L
.08554 .39614 L
.07292 .38395 L
.05239 .36453 L
.03724 .3508 L
.01923 .33495 L
s
.8 0 1 r
.01923 .18322 m
.02644 .18501 L
.05239 .19087 L
.08554 .19645 L
.1187 .19918 L
.15186 .19763 L
.18501 .18794 L
.19023 .18501 L
.21633 .15186 L
.21806 .1187 L
.2092 .08554 L
.19358 .05239 L
.18501 .03773 L
.1729 .01923 L
.01923 .01923 L
F
0 g
.01923 .18322 m
.02644 .18501 L
.05239 .19087 L
.08554 .19645 L
.1187 .19918 L
.15186 .19763 L
.18501 .18794 L
.19023 .18501 L
.21633 .15186 L
.21806 .1187 L
.2092 .08554 L
.19358 .05239 L
.18501 .03773 L
.1729 .01923 L
s
.8 0 1 r
.01923 .81678 m
.05239 .84657 L
.05406 .84814 L
.08554 .87845 L
.08836 .8813 L
.1187 .91321 L
.11981 .91446 L
.14812 .94761 L
.15186 .9524 L
.1729 .98077 L
.01923 .98077 L
F
0 g
.01923 .81678 m
.05239 .84657 L
.05406 .84814 L
.08554 .87845 L
.08836 .8813 L
.1187 .91321 L
.11981 .91446 L
.14812 .94761 L
.15186 .9524 L
.1729 .98077 L
s
1 .6 0 r
.01923 .62954 m
.05239 .62966 L
.08554 .62349 L
.10185 .61605 L
.1187 .60107 L
.12789 .58289 L
.12967 .54973 L
.12085 .51658 L
.1187 .50943 L
.10525 .48342 L
.08554 .4514 L
.0846 .45027 L
.05982 .41711 L
.05239 .40783 L
.03158 .38395 L
.01923 .37046 L
F
0 g
.01923 .62954 m
.05239 .62966 L
.08554 .62349 L
.10185 .61605 L
.1187 .60107 L
.12789 .58289 L
.12967 .54973 L
.12085 .51658 L
.1187 .50943 L
.10525 .48342 L
.08554 .4514 L
.0846 .45027 L
.05982 .41711 L
.05239 .40783 L
.03158 .38395 L
.01923 .37046 L
s
1 0 .6 r
.01923 .14754 m
.05239 .14733 L
.08554 .14115 L
.11655 .1187 L
.1187 .11561 L
.12807 .08554 L
.12424 .05239 L
.1187 .03503 L
.11201 .01923 L
.01923 .01923 L
F
0 g
.01923 .14754 m
.05239 .14733 L
.08554 .14115 L
.11655 .1187 L
.1187 .11561 L
.12807 .08554 L
.12424 .05239 L
.1187 .03503 L
.11201 .01923 L
s
1 0 .6 r
.01923 .85246 m
.04488 .8813 L
.05239 .89 L
.07129 .91446 L
.08554 .93396 L
.09393 .94761 L
.11201 .98077 L
.01923 .98077 L
F
0 g
.01923 .85246 m
.04488 .8813 L
.05239 .89 L
.07129 .91446 L
.08554 .93396 L
.09393 .94761 L
.11201 .98077 L
s
1 0 0 r
.01923 .58388 m
.02165 .58289 L
.05239 .5595 L
.05756 .54973 L
.06183 .51658 L
.0544 .48342 L
.05239 .47544 L
.03978 .45027 L
.01987 .41711 L
.01923 .41612 L
F
0 g
.01923 .58388 m
.02165 .58289 L
.05239 .5595 L
.05756 .54973 L
.06183 .51658 L
.0544 .48342 L
.05239 .47544 L
.03978 .45027 L
.01987 .41711 L
.01923 .41612 L
s
1 0 0 r
.01923 .10214 m
.04413 .08554 L
.05239 .07469 L
.05968 .05239 L
.05758 .01923 L
.01923 .01923 L
F
0 g
.01923 .10214 m
.04413 .08554 L
.05239 .07469 L
.05968 .05239 L
.05758 .01923 L
s
1 0 0 r
.01923 .89786 m
.02919 .91446 L
.04644 .94761 L
.05239 .96471 L
.05758 .98077 L
.01923 .98077 L
F
0 g
.01923 .89786 m
.02919 .91446 L
.04644 .94761 L
.05239 .96471 L
.05758 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{198, 198},
  ImageMargins->{{60.625, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000360000aQ000`40O003h00OaWoo0036Ool00<Io
o`005Woo0P007goo0P0017oo0P0017oo0P007Woo1@0077oo1@000Woo0P0017oo0P007Woo10004Goo
000EOol01000Oomoo`007Goo00@007ooOol000Qoo`04001oogoo000OOol00`00Oomoo`0NOol00`00
Oomoo`07Ool01000Oomoo`007Goo00<007ooOol04Woo000EOol01000Oomoo`007Goo00@007ooOol0
00]oo`03001oogoo01eoo`03001oogoo01ioo`03001oogoo00Yoo`03001oogoo01aoo`03001oogoo
015oo`005Goo00@007ooOol001eoo`04001oogoo0009Ool2000POol00`00Oomoo`0NOol00`00Oomo
o`08Ool2000POol00`00Oomoo`0@Ool001Eoo`04001oogoo000MOol01000Oomoo`002Goo00<007oo
Ool07goo00<007ooOol07Woo00<007ooOol027oo00<007ooOol07Goo00@007ooOol0015oo`005Woo
0P007goo0P002Woo0`007Woo0P007goo0P002Woo0`007Woo0P004Woo0036Ool00<Ioo`00aWoo002m
Ool200000goo00000004Ool00;ioo`03001oo`0000Eoo`0057ooX`0027oo00<007ooOol017oo000>
Ool20004Ool01000Oomoo`009Woo00<007ooOol097oo00<007ooOol097oo00<007ooOol097oo00@0
07ooOol000Ioo`800003Ool0000000Aoo`003Goo00@007ooOol000=oo`03001oogoo09moo`03001o
ogoo00eoo`003Goo00@007ooOol000=oo`8000Moo`03001oogoo00Ioo`03001oogoo00Moo`03001o
ogoo00Uoo`03001oogoo00ioo`03001oogoo06Eoo`8000moo`003Goo00@007ooOol000=oo`03001o
ogoo00Il0003001l4W`B00Ml4P0=001P7f@OH1mT7f0OI1mP7f@OH1l001@O61l00a@O00HH7a@O51lD
7aPO000A0Il00`000ol3o`1R0ol3Ool00`00Oomoo`0=Ool000eoo`04001oogoo0003Ool00`00Oomo
o`06O0000`00O1=l4P02O180;G`CO19l4W`BO1<006@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH
7a@O61lD7aPO51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02001R0ol3Ool0
0`00Oomoo`0=Ool000ioo`8000Aoo`03001oogoo00Il0003001l4W`B00Ml4P0<001P7f@OH1mT7f0O
I1mP7f@OH1mT7`000Q@O00DH7a@O51lD7aPO00<D7`0361l000000141W`030003o`?o05l3o`=oo`03
001oogoo00eoo`0057oo00<007ooOol01W`000@007`BO19l4`=l4P0_O1=l4W`BO180060OI1mP7f@O
H1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl0001P0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00Il0003001l4W`B
00Ql4P0<001T7f0OI1mP7f@OH1mT7f0OI1mP7`000a@O00DH7a@O51lD7aPO00<D7`0361lD7`000141
W`8005h3o`=oo`03001oogoo00eoo`0057oo00<007ooOol01W`000<007`CO1800W`B03Al4g`BO19l
4W`CO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il005d3o`=oo`03001oogoo00eoo`0057oo
00<007ooOol01G`000<007`BO1802G`B00h006@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO0a@O00DH
7a@O51lD7aPO00<D7`0361l0006O0181W`030003o`?o05X3o`=oo`03001oogoo00eoo`0057oo00<0
07ooOol01G`000D007`BO19l4W`C00=l4P0dO1=l4W`BO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O001K0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00El0003001l4W`B00Ul4P0@
001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l351l01APO51lD7a@O61l00a@O00<H7`000Il0
4P6O0P00F@?o0goo00<007ooOol03Goo000DOol00`00Oomoo`04O0001000O19l4W`C0g`B03Ul4g`B
O19l4W`CO180060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000F0?o0goo00<0
07ooOol03Goo000DOol00`00Oomoo`03O0000`00O19l4P0;O1803`00I1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1l0000251l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO000D0Il00`000ol3o`1E0ol3
Ool00`00Oomoo`0=Ool001Aoo`04001oogooO0020002O1801G`CO19l4W`BO1<00g`B03Ul4g`BO19l
4P00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000EP?o0goo00<007oo
Ool03Goo000DOol01000Oomoo`003g`B0140060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`00
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O00005@6O00<000?o0ol0D`?o0goo00<007ooOol0
3Goo000DOol00`00Oomoo`03O1801G`CO19l4W`BO1<00g`B03el4g`BO19l4W`C001T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`000Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0001D0ol3Ool00`00Oomoo`0=Ool0
01Aoo`03001oogoo011l4P0C001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l00a@O
00DH7a@O51lD7aPO00<D7`0461lD7a@O000F0Il2001B0ol3Ool00`00Oomoo`0=Ool001Aoo`05001o
ogooO19l4`03O1801G`CO19l4W`BO1<00g`B03il4g`BO18006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00D@?o0goo00<007ooOol03Goo000DOol00`00
Oomoo`0>O18200004F@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00000a@O00DH7a@O51lD
7aPO00<D7`0761lD7a@O51lH7a@O0000606O00<000?o0ol0CP?o0goo00<007ooOol03Goo000DOol0
0`00Oomoo`03O1801G`CO19l4W`BO1<00g`B049l4g`B001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O001?0ol3Ool00`00Oomoo`0=Ool0
01Aoo`03001oogoo00]l4P80000FH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0
01@O61l351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO000I0Il00`000ol3o`1<0ol3Ool00`00
Oomoo`0=Ool001Aoo`05001oogooO19l4`03O1800g`CO19l4P030000A6@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O001=
0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00P0000II1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00000a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l00`000Il1W`0H0Il00`000ol3o`1:0ol3Ool00`00Oomoo`0=Ool001Aoo`1D001oogooH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00B`?o0goo00<007ooOol03Goo000DOol0
8`00Oomoof@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O00000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7`006`6O
00<000?o0ol0B0?o0goo00<007ooOol03Goo000DOol0EP00Oomoof0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00190ol3Ool00`00Oomoo`0=Ool001Aoo`0Q001oogooI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`00008D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00LH7a@O51lD7aPO51l0000L0Il00`000ol3
o`160ol3Ool00`00Oomoo`0=Ool001Aoo`1H001oogoo001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00170ol3Ool00`00Oomoo`0=Ool001Aoo`04001oogoo51l20000
5f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00`0000<D7aPO51l0
0Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O00007P6O00<000?o0ol0
A0?o0goo00<007ooOol03Goo000DOol01P00Oomooa@O61lD7`D0000?H1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0O00<0000m51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0000A@?o0goo00<007ooOol03Goo0002Ool20004Ool20003Ool40003
Ool01000OomooaPO0a@O00@H7a@O51lD7`l0000351lH7a@O008D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7`000201W`030003o`?o0483o`=oo`03001o
ogoo00eoo`0000Eoo`00Oomoo`0000Qoo`03001oogoo00Aoo`1L001oogoo51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il004<3o`=oo`03001oogoo00eo
o`0000Eoo`00Oomoo`0000Uoo`03001oogoo00=oo`800004OolD7a@O61l351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l00aPO0001W`0O0Il00`000ol3o`110ol2Ool2000?Ool00005
Ool007ooOol0000:Ool00`00Oomoo`02Ool00`00Oomoo`030000EaPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000120ol3Ool00`00Oomoo`0=Ool00005Ool0
07ooOol00008Ool01000Oomoo`000goo00<007ooOol00`6O0P000a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00Q@O00<0006O0Il0806O00<000?o0ol0?`?o0goo00<007ooOol03Goo0002
Ool2000:Ool20004Ool02000Oomoo`5o0Il1O`6O0Gl20000E1PO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00443o`=oo`03001oogoo00eoo`0057oo00<007ooOol01`6O
0P0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00`000Il1W`0R0Il00`000ol3o`0n0ol3
Ool00`00Oomoo`0=Ool001Aoo`0<001oogoo0001W`5o0Il1O`6O0Gl1W`5o100004lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02000n0ol3Ool00`00Oomoo`0=Ool001Aoo`04001o
ogoo0ol2000:0Il5000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00<0006O0Il09`6O00<000?o0ol0>`?o0goo00<007ooOol03Goo
000DOol00`00Oomoo`030ol200003@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0080001<51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o000l0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00D3
o`030001W`6O00`1W`@0008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO008D7`8002`1W`030003o`?o03X3o`=oo`03001oogoo00eoo`0057oo00<007ooOol01P?o0P00
0101O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`H0000@51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61l30000<06O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il003/3o`=oo`03
001oogoo00eoo`0057oo00@007ooOol000L3o`8001@1W`D0000351lH7a@O008D7`0361l0000000<0
0381W`030003o`?o03T3o`=oo`03001oogoo00eoo`0057oo00@007ooOol3j`8000L3o`80000G0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`060000>@6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000j0ol3Ool00`00Oomoo`0=
Ool001Aoo`03001oogoo00<3k0030003o`?o00H3o`<00581W`030003o`?o03P3o`=oo`03001oogoo
00eoo`0057oo00L007ooOol3j`?/0n/3k00200090ol20000DP6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`00>@?o0goo00<007ooOol03Goo000DOol00`00Oomoo`060n`00`00
0ol3o`080ol2001?0Il00`000ol3o`0g0ol3Ool00`00Oomoo`0=Ool001Aoo`0:001oogoo0003k0?[
0n`3j`?/0n/2000:0ol20000C`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0003P3
o`=oo`03001oogoo00eoo`0057oo00@007ooOolGh08000H3k0030003o`?o00T3o`8004`1W`030003
o`?o03H3o`=oo`03001oogoo00eoo`0057oo00d007ooOolGh1_P5n0000?[0n`3j`?/0n/3k002000;
0ol20000C06O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00=`?o0goo00<007ooOol03Goo000D
Ool01000Oomooa_P0aOP00<000?/0n`01@?/0P002`?o0P00B@6O00<000?o0ol0=@?o0goo00<007oo
Ool03Goo000DOol04@00OomooaOP6n0Gh1_P5n0000?[0n`3j`?/0n/3k0?[0n`00P002`?o0P0004T1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0000f0ol3Ool00`00Oomoo`0=Ool001Aoo`06001oogoo000G
h1_P0aOP00<000?/0n`01`?/00<000?o0ol02P?o0P00AP6O00<000?o0ol0=0?o0goo00<007ooOol0
3Goo000DOol02P00Oomoof?P000Gh1_P5n0Kh1OP0P0000T3k0?[0n`3j`?/0n/3k0?[00003@?o0P00
04D1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0000=P?o0goo00<007ooOol03Goo000DOol02000OomoofOPHn0001OP
6n035n000a_P0003k0070n`2000=0ol200130Il00`000ol3o`0c0ol3Ool00`00Oomoo`0=Ool001Ao
o`0H001oogooHn1Wh6?P000Gh1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0003P?o0`000441
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`0003D3o`=oo`03001oogoo00eoo`0057oo00X007ooOomWh6?PIn1Sh0005n0Kh0<Gh003
6n00000000P3k0030003o`?o00h3o`8003h1W`030003o`?o03<3o`=oo`03001oogoo00eoo`0057oo
01T007ooOomSh6OPHn1Wh6?P000Gh1_P5n0Kh1OP6n0Gh0000n/3k0?[0n`3j`?/0n/3k002000@0ol2
0000?@5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`0003D3o`=oo`03001oogoo00eoo`0057oo00`007ooOol006?PIn1Sh6OPHn0001OP6n035n00
11_P5n00000020?/0P0040?o0`00>@6O00<000?o0ol0<`?o0goo00<007ooOol03Goo000DOol07@00
Oomoogi0001Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`00P00
4@?o0P0003P1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00
=@?o0goo00<007ooOol03Goo000DOol00`00Oomoo`02OT002@00Hn1Wh6?PIn1Sh0005n0Kh0035n00
11_P5n0Gh0002P?/00<000?o0ol040?o1000<`6O00<000?o0ol0<`?o0goo00<007ooOol03Goo0002
Ool20004Ool20005Ool30002Ool08@00Oomoogi0OV1n@000Hn1Wh6?PIn1Sh0005n0Kh1OP6n0Gh1_P
5n0Kh0000n`3j`?/0n/3k0?[0n`3j`?/0n/0000E0ol20000<P6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O000e0ol3Ool00`00Oomoo`0=Ool00005Ool007ooOol0000;Ool01@00Oomo
ogoo00000Woo17i000T006?PIn1Sh6OPHn0001OP6n000aOP00@Kh1OP5n0000X3k08001D3o`<002d1
W`030003o`?o03@3o`=oo`03001oogoo00eoo`0000Eoo`00Oomoo`0000Qoo`D0009oo`80000ROomn
@7i0OT1nH000In1Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3
j`?/000G0ol20000;05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o000f0ol2Ool2000?Ool00005Ool0
07ooOol00008Ool01000Oomoo`000goo00<007ooOol01Gi000L006OPHn1Wh6?PIn1Sh00200001A_P
5n0Gh1OP6n000QOP00<000?/0n`02@?/0P005`?o10009P6O00<000?o0ol0=@?o0goo00<007ooOol0
3Goo00001Goo001oogoo00002Goo00<007oo00000goo00D007ooOol007iP00=n@00AOV0006OPHn1W
h6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh00200002`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00P006@?o
1@000281W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il003L3o`=oo`03001oogoo00eoo`000Woo0P002goo0P000goo00D007ooOoml0000
00En@00:001Wh6?PIn1Sh6OPHn1Wh0006n035n001A_P5n0Gh1OP000030?/00<000?o0ol06`?o0P00
7P6O00<000?o0ol0=P?o0goo00<007ooOol03Goo000DOol01`00Oomoog`0001n@7iP00=n@00O001S
h6OPHn1Wh6?PIn1Sh0005n0Kh1OP6n0Gh1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0000
7`?o100001X1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00
>@?o0goo00<007ooOol03Goo000DOol00`00Oomoo`02O0000`00OT1n@003OT002`00Hn1Wh6?PIn1S
h6OPHn0001OP6n000aOP00DKh1OP5n0Gh00000/3k0800243o`D00141W`<003X3o`=oo`03001oogoo
00eoo`0057oo00<007ooOol00W`000@007i0OT1nH0=n@00O001Sh6OPHn1Wh6?PIn1Sh0005n0Kh1OP
6n0Gh1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P0090?o1P0000D1O`6O0Gl1W`5o
00H003d3o`=oo`03001oogoo00eoo`0057oo00<007ooOol00g`000<007i0OT000gi000`006OPHn1W
h6?PIn1Sh6OPHn0001OP6n035n001A_P5n0Gh1OP00003@?/0P00:0?o1@00@`?o0goo00<007ooOol0
3Goo000DOol00`00Oomoo`03O0001@00OT1n@7i0OV000Wi002<006OPHn1Wh6?PIn1Sh6OPHn0001OP
6n0Gh1_P5n0Kh1OP6n0Gh0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00006l3o`=oo`03001o
ogoo00eoo`0057oo00<007ooOol017`000<007i0OT0017i000`006OPHn1Wh6?PIn1Sh6OPHn0001OP
6n035n001A_P5n0Gh1OP00003P?/00<000?o0ol0K0?o0goo00<007ooOol03Goo000DOol00`00Oomo
o`04O0000`00OV1n@002OT009GiPOT1n@000In1Sh6OPHn1Wh6?PIn0001_P5n0Kh1OP6n0Gh1_P5n0K
h1OP0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/008006`3o`=oo`03001oogoo00eoo`0057oo
00<007ooOol01G`000<007i0OT0017i000X006?PIn1Sh6OPHn1Wh6?PIn00008Gh0056n0Gh1OP5n0K
h0035n000`000n`3k00=0n`00`000ol3o`1Y0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00El
0003001n@7iP00=n@00FOV1n@000Hn1Wh6?PIn1Sh6OPHn1Wh0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n02
00003P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/2001Y0ol3Ool00`00Oomoo`0=Ool001Aoo`03
001oogoo00El0003001n@7i000In@00:001Sh6OPHn1Wh6?PIn1Sh6OP00025n001A_P5n0Gh1OP6n00
0aOP00<Kh0000n`03P?/00<000?o0ol0IP?o0goo00<007ooOol03Goo000DOol00`00Oomoo`05O000
1@00OT1n@7i0OV000gi002MnH000In1Sh6OPHn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P00IP?o0goo00<007ooOol03Goo000D
Ool00`00Oomoo`06O0000`00OT1n@006OT002`00In1Sh6OPHn1Wh6?PIn1Sh6OP00000QOP00DKh1OP
5n0Gh1_P00<Gh0030003k0?/00l3k0030003o`?o06<3o`=oo`03001oogoo00eoo`0057oo00<007oo
Ool01W`000<007iPOT000Wi002enH7i0OT1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0000I0?o0goo00<0
07ooOol03Goo000DOol00`00Oomoo`06O0000`00OT1n@007OT002`00Hn1Wh6?PIn1Sh6OPHn1Wh6?P
00000aOP00DKh1OP5n0Gh1_P00<Gh0030003k0?/00l3k0030003o`?o0643o`=oo`03001oogoo00eo
o`0057oo00<007ooOol01g`000<007i0OV000gi002enH7i0OT0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0000HP?o0goo00<007ooOol03Goo000DOol00`00Oomoo`07O0000`00OT1n@006OT003@00Hn1Wh6?P
In1Sh6OPHn1Wh6?PIn0001_P00<Gh0056n0Gh1OP5n0Kh0035n000`000n`3k00?0n`2001P0ol3Ool0
0`00Oomoo`0=Ool001Aoo`03001oogoo00Ml0005001n@7i0OT1nH003OT00;WiP001Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k000G`?o0goo00<007ooOol03Goo000DOol00`00Oomoo`07O0000`00OT1n
@007OT003P00In1Sh6OPHn1Wh6?PIn1Sh6OPHn0001OP6n035n001A_P5n0Gh1OP6n000aOP00<000?/
0n`040?/00<000?o0ol0G0?o0goo00<007ooOol03Goo000DOol00`00Oomoo`06O0001000OT1n@7iP
0gi0039nH7i0OT1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000G@?o0goo00<007ooOol0
3Goo000DOol00`00Oomoo`06O0000`00OT1n@009OT003000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn00008G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP00004P?/00<000?o0ol0FP?o0goo00<007ooOol03Goo
000DOol00`00Oomoo`06O0000`00OV1n@002OT001GiPOT1n@7i0OV000Wi002h006OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k08005X3o`=oo`03001oogoo00eoo`0057oo00<007ooOol01G`000<0
07i0OT002Wi000d006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0000035n001A_P5n0Gh1OP6n000aOP00@K
h1OP5n0001@3k0030003o`?o05L3o`=oo`03001oogoo00eoo`0057oo00<007ooOol01G`000D007i0
OT1n@7iP00=n@00fOV1n@7i0OT1nH000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0P00E`?o0goo00<007ooOol03Goo000DOol00`00Oomoo`03O002000<OT004000In1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn0001_P0aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh00001H3k0030003o`?o05@3
o`=oo`03001oogoo00eoo`0057oo00@007ooOoml00800005OV1n@7i0OT1nH003OT00?7iPOT1n@7i0
OV1n@000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`005D3o`=oo`03
001oogoo00eoo`0057oo00@007ooOol0011n@00B001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
000Gh1_P0aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh00001H3k0030003o`?o0583o`=oo`03001oogoo
00eoo`000Woo0P0017oo0P000goo0`0017oo00D007ooOol007iP00=n@005OV1n@7i0OT1nH003OT00
?7iPOT1n@7i0001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0
05<3o`=oo`03001oogoo00eoo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0003Ool00`00Oomoo`0@
OT004@00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00000aOP00DKh1OP5n0Gh1_P00<Gh006
6n0Gh1OP5n0Kh0005`?/00<000?o0ol0D0?o0goo00<007ooOol03Goo00001Goo001oogoo000027oo
00@007ooOol000=oo`800005Oomn@7i0OT1nH003OT001GiPOT1n@7i0OV000gi003anH000In1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/001A0ol2Ool2000?
Ool00005Ool007ooOol00008Ool30004Ool00`00Oomoo`0?OT005000In1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh0006n035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh00001P3k0030003
o`?o04h3o`=oo`03001oogoo00eoo`0000Eoo`00Oomoo`0000Uoo`03001oogoo00=oo`05001oogoo
OT1nH003OT001GiPOT1n@7i0OV000gi003mnH000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?P000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P00CP?o0goo00<007ooOol03Goo0002Ool2
000:Ool30003Ool00`00Oomoo`0<OT02000056OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OP00025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0030003k0?/01L3k0030003
o`?o04/3o`=oo`03001oogoo00eoo`0057oo00<007ooOol00gi000EnH7i0OT1n@7iP00@00014Hn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/004`3o`=oo`03001oogoo00eoo`0057oo00<007ooOol0200001]Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0001OP6n000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0025n000`000n`3k00H0n`00`000ol3o`190ol3Ool00`00Oomoo`0=Ool0
01Aoo`1E001oogooHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0000BP?o
0goo00<007ooOol03Goo000DOol09000OomoofOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0000<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00<Kh1OP00006`?/00<000?o0ol0A`?o0goo00<007ooOol03Goo000DOol0E`00Oomo
of?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?P000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000180ol3Ool00`00
Oomoo`0=Ool001Aoo`0R001oogooIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n00000M0n`00`000ol3o`150ol3Ool00`00Oomoo`0=Ool001Aoo`1I001oogooHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0005n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/000160ol3Ool00`00Oomo
o`0=Ool001Aoo`03001oogoo00<0000JHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn0000<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P008Gh0030003k0?/01`3k0030003o`?o04<3o`=oo`03001oogoo00eoo`0057oo00H007ooOolG
h1_P5n0500004F?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000`0003`Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00140ol3Ool00`00
Oomoo`0=Ool001Aoo`03001oogoo008Gh0066n0Gh1OP5n0Kh1OP1@0000ISh6OPHn1Wh6?PIn060000
0aOP6n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
0a_P0003k00N0n`00`000ol3o`120ol3Ool00`00Oomoo`0=Ool001Aoo`0@001oogoo5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n060000AQ_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000@`?o0goo00<007ooOol03Goo
000DOol01000Oomooa_P0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP
5n000243k0030003o`?o0403o`=oo`03001oogoo00eoo`0057oo00<007ooOol00P0005TGh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP0003j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0000443o`=oo`03
001oogoo00eoo`0057oo00<007ooOol00P?/0P000QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00<Kh0000n`08P?/00<000?o0ol0?P?o0goo00<007ooOol03Goo000DOol01`00Oomo
o`?[0n`3j`?/00<0001F6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP0003j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`003l3o`=oo`03001oogoo00eoo`0057oo00<007ooOol01`?/0P000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n0011_P5n0Gh0009@?/00<000?o0ol0?0?o0goo00<007ooOol03Goo000DOol03000Oomo
o`?[0n`3j`?/0n/3k0?[0n`3j`<0001C5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`0000m0ol3Ool00`00Oomoo`0=Ool001Aoo`04001oogoo000;0n`300035n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DK
h1OP5n0Gh00002P3k0030003o`?o03X3o`=oo`03001oogoo00eoo`0057oo00@007ooOol3o`80000<
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[100004dKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`0003`3o`=oo`03001oogoo00eoo`0057oo00<007ooOol00`?o0P003P?/1@0000DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh08002X3k0030003o`?o
03T3o`=oo`03001oogoo00eoo`0057oo00<007ooOol01@?o0`000103j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0<0000G6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh0020000;P?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`00>P?o0goo00<007ooOol03Goo
000DOol00`00Oomoo`080ol2000A0n`300001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0@0
0303k0030003o`?o03L3o`=oo`03001oogoo00eoo`0057oo00@007ooOol000T3o`0D0003k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k100000e0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`0000i0ol3Ool00`00Oomoo`0=Ool001Aoo`04001oogoo0Il20008
0ol2001F0n`00`000ol3o`0f0ol3Ool00`00Oomoo`0=Ool001Aoo`06001oogoo0Gl1W`5o0P0020?o
0P0005H3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k000=`?o
0goo00<007ooOol03Goo0002Ool20004Ool20004Ool20004Ool00`00Oomoo`050Il00`000ol3o`07
0ol2001C0n`00`000ol3o`0e0ol3Ool00`00Oomoo`0=Ool00005Ool007ooOol00008Ool01000Oomo
o`000goo00T007ooOol0006O0Gl1W`5o0Il00P002@?o0P0005<3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`0003H3o`=oo`03001oogoo00eoo`0000Eoo`00Oomoo`0000Qo
o`04001oogoo0003Ool200000goo61l000060Il200090ol2001@0n`00`000ol3o`0d0ol2Ool2000?
Ool00005Ool007ooOol00009Ool20004Ool01@00Oomooa@O61l00P0000L1O`6O0Gl1W`5o0Il0000:
0ol20000D0?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/000e0ol3Ool00`00Oomo
o`0=Ool00005Ool007ooOol00008Ool01000Oomoo`000goo00<007ooOol00Q@O00<H7a@O00001P6O
0P002P?o0`00C0?/00<000?o0ol0<`?o0goo00<007ooOol03Goo0002Ool2000:Ool20004Ool04000
Oomooa@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0P002`?o0P0004`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/003@3o`=oo`03001oogoo00eoo`0057oo00@007ooOolH7`<D7`0361lD7`0000P1
W`030003o`?o00X3o`8004T3k0030003o`?o0383o`=oo`03001oogoo00eoo`0057oo01@007ooOol0
01PO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`003@?o0P0004P3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[000d0ol3Ool00`00Oomoo`0=Ool001Aoo`06001oogooI1l001PO0a@O00<H7a@O0000206O0P00
3@?o0P00AP?/00<000?o0ol0<@?o0goo00<007ooOol03Goo000DOol01@00Oomoof0OI1l00P0000lD
7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl00P003@?o0P0004D3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0000
<`?o0goo00<007ooOol03Goo000DOol02000Oomoof@OH1mT7f0O000351l00aPO51l0000:0Il00`00
0ol3o`0<0ol200120n`00`000ol3o`0a0ol3Ool00`00Oomoo`0=Ool001Aoo`0>001oogooH1mT7f0O
I1mP7`0051lH7a@O61lD7`80000:0Il1O`6O0Gl1W`5o0Il1O`6O000?0ol20000@P?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
0383o`=oo`03001oogoo00eoo`0057oo00X007ooOol0060OI1mP7f@O000H7`<D7`0461lD7a@O0009
0Il00`000ol3o`0>0ol4000m0n`00`000ol3o`0`0ol3Ool00`00Oomoo`0=Ool001Aoo`0A001oogoo
O180060OI1mP7f@O000H7a@O61lD7aPO51lH7`020000205o0Il1O`6O0Gl1W`5o0Il2000B0ol20000
?0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
0383o`=oo`03001oogoo00eoo`0057oo00<007ooOol00W`B00L0060OI1mP7f@O000H7`0351l01APO
51lD7a@O00002@6O0P004P?o0P00>@?/00<000?o0ol0<0?o0goo00<007ooOol03Goo000DOol00`00
Oomoo`02O1806`00I1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o
0Il0000C0ol20000>0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[000b0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00=l4P08001T7f0OI1mP7f@O000H7`<D
7`0461lD7a@O51l200090Il2000C0ol3000d0n`00`000ol3o`0`0ol3Ool00`00Oomoo`0=Ool001Ao
o`05001oogooO19l4`02O1801P00I1mP7f@OH1mT7`80000D51lH7a@O61lD7aPO51lH7`000Il1O`6O
0Gl1W`5o0Il1O`6O0Gl001D3o`<0000b0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/00383o`=oo`03001oogoo00eoo`0057oo00<007ooOol01G`B00P006@OH1mT7f0OI1mP7`000a@O
00HH7a@O51lD7aPO000:0Il00`000ol3o`0E0ol2000^0n`00`000ol3o`0a0ol3Ool00`00Oomoo`0=
Ool001Aoo`03001oogoo00=l4P0NO1=l4P00H1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O0001
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0P005`?o100002X3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[000d0ol3
Ool00`00Oomoo`0=Ool001Aoo`04001oogoo0005O1802@00H1mT7f0OI1mP7f@OH1l0000351l011PO
51lD7a@O0P002`6O0P006@?o10009@?/00<000?o0ol0<P?o0goo00<007ooOol03Goo000DOol01@00
Oomoog`000000g`B01=l4g`B001P7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7`020000305o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl001`3o`<0000R0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/000e0ol3Ool00`00Oomoo`0=Ool001Ao
o`05001oogooO0000006O1802@00H1mT7f0OI1mP7f@OH1l0000351l01aPO51lD7a@O61lD7`0000/1
W`8001d3o`@001`3k0030003o`?o03@3o`=oo`03001oogoo00eoo`0057oo00<007ooOol00W`000<0
07`CO1800W`B029l4g`B001P7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il00203o`@0000H0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k000=`?o0goo00<007ooOol03Goo000DOol00`00Oomoo`02O0000`00O19l4P04
O1802P00I1mP7f@OH1mT7f0OI1mP7`000a@O00LH7a@O51lD7aPO51l0000<0Il2000R0ol3000B0n`2
000h0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00=l0003001l4W`C00=l4P0SO1<006@OH1mT
7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl0
000T0olB000j0ol3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00=l0003001l4W`B00Al4P0;001P
7f@OH1mT7f0OI1mP7f@O000H7`0351l01QPO51lD7a@O61l000h1W`030003o`?o06d3o`=oo`03001o
ogoo00eoo`0057oo00<007ooOol017`000@007`BO19l4`=l4P0R001P7f@OH1mT7f0OI1mP7f@O000H
7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl2001]0ol3Ool00`00
Oomoo`0=Ool001Aoo`03001oogoo00Al0003001l4W`B00El4P0;001P7f@OH1mT7f0OI1mP7f@O000H
7`0351l01APO51lD7a@O61l00P003P6O00<000?o0ol0JP?o0goo00<007ooOol03Goo000DOol00`00
Oomoo`04O0000`00O1=l4P02O180:7`CO19l4W`B001P7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO
51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`00J`?o0goo00<007ooOol03Goo
000DOol00`00Oomoo`05O0000`00O19l4P05O1803000I1mP7f@OH1mT7f0OI1mP7`0051lH7`<D7`07
61lD7a@O51lH7a@O00003P6O0P00J@?o0goo00<007ooOol03Goo000=Ool50002Ool00`00Oomoo`05
O0000`00O19l4`03O180:G`CO19l4P00I1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O
61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0000J0?o0goo00<007ooOol03Goo000?
Ool00`00Oomoo`02Ool00`00Oomoo`06O0000`00O19l4P05O1803@00H1mT7f0OI1mP7f@OH1mT7f0O
000D7aPO00<D7`0761lD7a@O51lH7a@O00003`6O0P00IP?o0goo00<007ooOol03Goo000?Ool00`00
Oomoo`02Ool200000gooO01l0004O0001000O19l4W`C0g`B02Yl4g`B001P7f@OH1mT7f0OI1mP7f@O
H1l001@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
001U0ol2Ool2000?Ool000moo`03001oogoo009oo`03001oogoo09moo`03001oogoo00eoo`003goo
00<007ooOol00Woo00@007ooOol002Ioo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Ao
o`04001oogoo000?Ool000ioo`8000Aooj<000moo`00aWoo0036Ool00<Ioo`00aWoo0036Ool00<Io
o`00aWoo0036Ool00<Ioo`004goo0P00/Goo000BOol01000Oomoo`00/7oo000BOol00`00Oomoo`2a
Ool0015oo`D00;1oo`004Woo00<007ooOol0/Goo0036Ool00<Ioo`00aWoo0036Ool00<Ioo`00aWoo
0036Ool00001\
\>"],
  ImageRangeCache->{{{0, 197}, {197, 0}} -> {-0.295859, -0.103237, 0.0127694, \
0.00638468}}]
}, Open  ]],

Cell[TextData[{
  "This example demonstrates that the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is not only helpful in finding the symmetries of a PDE but also can \
facilitate the solution of boundary value problems."
}], "Text",
  Evaluatable->False,
  CellTags->"symmetries of PDEs"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.6.3 Single Flux Line in Superconductors", "Subsection",
  CellTags->"Single Flux Line in Superconductors"],

Cell[TextData[{
  "In another example, let us examine an equation published by ",
  ButtonBox["Tang et al. [1994]",
    ButtonData:>{"Literat.nb", "Tang-94"},
    ButtonStyle->"Hyperlink"],
  ". These authors discuss the dynamics and noise spectra of a driven single \
flux line in superconductors. The authors examine the low-temperature \
dynamics of a single flux line in a bulk type-II superconductor, driven by \
the Lorentz force acting near the sample surface, both near and above the \
depinning threshold. The equation of motion they derive without considering \
the random fluctuations is given by"
}], "Text",
  CellTags->{
  "single flux line in superconductors", "low temperature dynamics", 
    "type-II superconductor", "Lorentz force", "depinning threshold"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(tang = {
        \[PartialD]\_t u[x, t] - 
          \(k\ \[PartialD]\_{x, 2}u[x, t]\)\/\(1 + 
              \((\[PartialD]\_x u[x, t])\)\^2\)}; tang // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(u\_t\), "-", 
                StyleBox[\(\(k\ u\_\(x, x\)\)\/\(1 + u\_x\%2\)\),
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is the shape function of the flux line and ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " is a constant. As Tang et al. note the equation of motion in its \
two-dimensional representation is a valid approximation when the driving \
force is very large ",
  Cell[BoxData[
      \(TraditionalForm\`\((j \[GreaterGreater] j\_c)\)\)]],
  " and the string moves with a high velocity. The authors discuss only the \
steady-state solution of the non-linear problem. We will demonstrate that the \
symmetries of the equation are the cornerstone for the solution of the \
non-steady equation. We will add this example to our database of equations. \
The input parameters needed to create the data file containing the \
information for ",
  StyleBox["Lie[]", "MmaText"],
  " is given by the independent variables"
}], "Text",
  CellTags->{"flux line", "Lie[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(independentVariables = {x, t}\)], "Input"],

Cell[BoxData[
    \({x, t}\)], "Output"]
}, Open  ]],

Cell["and the dependent variables", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dependentVariables = {u}\)], "Input"],

Cell[BoxData[
    \({u}\)], "Output"]
}, Open  ]],

Cell["The parameters of the equations are collected in the list", "Text",
  CellTags->"parameters of the equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(parameters = {k}\)], "Input"],

Cell[BoxData[
    \({k}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The parameter ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " combines the critical field ",
  Cell[BoxData[
      \(TraditionalForm\`H\_c\)]],
  ", the Ginzburg-Landau parameter and the damping coefficient of the \
Bardeen-Stephen model. The physical interpretation of these parameters is \
discussed, for example, in the book by ",
  ButtonBox["Tinkham [1975]",
    ButtonData:>{"Literat.nb", "Tink-75"},
    ButtonStyle->"Hyperlink"],
  ". We choose the title of the equation to be"
}], "Text",
  CellTags->{
  "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(title = {"\<Single Flux Line in Superconductors\>"}\)], "Input"],

Cell[BoxData[
    \({"Single Flux Line in Superconductors"}\)], "Output"]
}, Open  ]],

Cell["\<\
The source of the equation, contained in a nested list, is given by\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(source = {{"\<C. Tang, S. Feng and L. Golubovic\>"}, \n
        \t\t{"\<Dynamics and Noise Spectra of a Driven SingleFlux  Line in  \
Superconductors\>"}, \n\t\t{"\<Phys. Rev. Lett. 72, 1264-1267, (1994)\>"}, \n
        \t\t{"\<equation 7\>"}}\)], "Input"],

Cell[BoxData[
    \({{"C. Tang, S. Feng and L. Golubovic"}, {
        "Dynamics and Noise Spectra of a Driven SingleFlux  Line in  \
Superconductors"}, {"Phys. Rev. Lett. 72, 1264-1267, (1994)"}, {"equation 7"}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "All the information available on the equation is now stored in the file ",
  StyleBox["ctang.dgl", "MmaText",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "The function ",
  StyleBox["LieEquation[]", "MmaText"],
  " is designed to do it for us. Be sure that you do not use",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox[".deq", "MmaText",
    FontSlant->"Italic"],
  " as an extension of your file names. The extension ",
  StyleBox[".deq", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "is reserved for a file containing the information on the determining \
equation for the infinitesimals. This file is automatically created by the \
functions ",
  StyleBox["Lie[]", "MmaText"],
  ", ",
  StyleBox["LieSolve[]", "MmaText"],
  ", and ",
  StyleBox["LieStructureForm[]", "MmaText"],
  "."
}], "Text",
  CellTags->{
  "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
    "LieSolve[]", "LieStructureForm[]"}],

Cell[BoxData[
    \(LieEquations["\<ctang.dgl\>", tang, \n\tdependentVariables, 
      independentVariables, \n\tparameters, title, source]\)], "Input"],

Cell["\<\
After the completion of this line, we added another example to our \
database of differential equations. The next step is the determination of the \
symmetries.\
\>", "Text",
  CellTags->{"data basis", "determination of the symmetries"}],

Cell[CellGroupData[{

Cell["5.6.3.1 Symmetries", "Subsubsection"],

Cell[TextData[{
  "Using the information collected in the file ",
  StyleBox["ctang.dgl", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ", "MmaText"],
  "in the calculation for the infinitesimals, we start the symmetry analysis \
with"
}], "Text",
  CellTags->"symmetry analysis"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieSolve["\<ctang.dgl\>"] // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Xi]\_2 == k1 + 2\ k5\ t\)},
          {\(\[Phi]\_1 == k2 + k5\ u + k3\ x\)},
          {\(\[Xi]\_1 == k4 - k3\ u + k5\ x\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 2, k5, t]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k2, 
            Times[ k5, u], 
            Times[ k3, x]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k4, 
            Times[ -1, k3, u], 
            Times[ k5, x]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The application of ",
  StyleBox["LieSolve[]", "MmaText"],
  " results in a list of infinitesimals representing a finite \
five-dimensional point group. Curiously, the result is that the infinitesimal \
",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1\)]],
  " depends on the variable ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". Such a dependence is quite unusual, although it is possible. All the \
examples discussed so far do not show this kind of symmetry (cf. the ",
  ButtonBox["Burgers",
    ButtonData:>{"symmet5.nb", "Burgers equation"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["heat equation",
    ButtonData:>{"symmet5.nb", "heat equation"},
    ButtonStyle->"Hyperlink"],
  "). The symmetry of the subgroup related to this special kind of \
transformation allows a rotation in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane. This rotation keeps the equation unchanged."
}], "Text",
  CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],

Cell[TextData[{
  "The function ",
  StyleBox["LieSolve[]", "MmaText"],
  " produces, in addition to the infinitesimals, additional information not \
displayed on the screen. These results, like the determining equations of the \
equation, the original equations themselves, the substitutions, etc. are \
collected during the calculation in a separate global variable called ",
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  ". The reason why we introduced a global variable ",
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  " is the necessity of having all information on the calculation available. \
A printout of the information contained in",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  " for our calculation of Tang\[CloseCurlyQuote]s problem can be obtained by \
calling"
}], "Text",
  CellTags->{"LieSolve[]", "FinalResult"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(FinalResult // \ Flatten\) // LieTraditionalForm\) // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(u\_t\), "-", 
              StyleBox[\(\(k\ u\_\(x, x\)\)\/\(1 + u\_x\%2\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(u\_t\), "\[Rule]", 
              StyleBox[\(\(k\ u\_\(x, x\)\)\/\(1 + u\_x\%2\)\),
                ScriptLevel->0]}]},
          {\(\((\[Xi]\_2)\)\_u\)},
          {\(\((\[Xi]\_2)\)\_x\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_t + k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              2\ k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              4\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-2\)\ \((\[Xi]\_1)\)\_t + k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-6\)\ \((\[Xi]\_1)\)\_t + k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              5\ k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              10\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-3\)\ \((\[Xi]\_1)\)\_t + 2\ k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(\(-6\)\ \((\[Xi]\_1)\)\_t + 5\ k\ \((\[Xi]\_1)\)\_\(u, u\) + 
              k\ \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ k\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {
            \(6\ \((\[Phi]\_1)\)\_t + 10\ k\ \((\[Xi]\_1)\)\_\(x, u\) - 
              5\ k\ \((\[Phi]\_1)\)\_\(u, u\) - 
              k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {\(\((\[Phi]\_1)\)\_t - k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\(-3\)\ \((\[Phi]\_1)\)\_t - 4\ k\ \((\[Xi]\_1)\)\_\(x, u\) + 
              2\ k\ \((\[Phi]\_1)\)\_\(u, u\) + 
              k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(6\ \((\[Phi]\_1)\)\_t + 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) - 
              k\ \((\[Phi]\_1)\)\_\(u, u\) - 
              5\ k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\(-2\)\ \((\[Phi]\_1)\)\_t - 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) + 
              k\ \((\[Phi]\_1)\)\_\(u, u\) + k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\(-3\)\ \((\[Phi]\_1)\)\_t - 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) + 
              k\ \((\[Phi]\_1)\)\_\(u, u\) + 
              2\ k\ \((\[Phi]\_1)\)\_\(x, x\)\)},
          {
            \(\((\[Phi]\_1)\)\_t + 2\ k\ \((\[Xi]\_1)\)\_\(x, u\) - 
              k\ \((\[Phi]\_1)\)\_\(u, u\)\)},
          {
            \(6\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              4\ \((\[Phi]\_1)\)\_u\)},
          {
            \(8\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              2\ \((\[Phi]\_1)\)\_u\)},
          {
            \(4\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              6\ \((\[Phi]\_1)\)\_u\)},
          {\(\(-2\)\ \((\[Xi]\_1)\)\_x + \((\[Xi]\_2)\)\_t\)},
          {
            \(2\ \((\[Xi]\_1)\)\_x - 5\ \((\[Xi]\_2)\)\_t + 
              8\ \((\[Phi]\_1)\)\_u\)},
          {\(\((\[Xi]\_1)\)\_u + \((\[Phi]\_1)\)\_x\)},
          {\(\((\[Xi]\_1)\)\_u + \((\[Phi]\_1)\)\_x\)},
          {\(\((\[Xi]\_1)\)\_u + \((\[Phi]\_1)\)\_x\)},
          {\(\(-\((\[Xi]\_2)\)\_t\) + 2\ \((\[Phi]\_1)\)\_u\)},
          {\(\(-\((\[Xi]\_1)\)\_t\) + k\ \((\[Xi]\_1)\)\_\(u, u\)\)},
          {"LieStructure"},
          {"Metric"},
          {"SymmGroup"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Plus[ 
          Subscript[ u, t], 
          Times[ -1, k, 
            Power[ 
              Plus[ 1, 
                Power[ 
                  Subscript[ u, x], 2]], -1], 
            Subscript[ u, x, x]]], Subscript[ u, t] -> Times[ k, 
          Power[ 
            Plus[ 1, 
              Power[ 
                Subscript[ u, x], 2]], -1], 
          Subscript[ u, x, x]], 
        Subscript[ 
          Subscript[ \[Xi], 2], u], 
        Subscript[ 
          Subscript[ \[Xi], 2], x], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -4, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -2, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -6, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ 5, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -10, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ -6, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ 5, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, x]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ 10, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ -5, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Phi], 1], t], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ -4, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ -5, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ -2, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ -3, 
            Subscript[ 
              Subscript[ \[Phi], 1], t]], 
          Times[ -2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Phi], 1], t], 
          Times[ 2, k, 
            Subscript[ 
              Subscript[ \[Xi], 1], x, u]], 
          Times[ -1, k, 
            Subscript[ 
              Subscript[ \[Phi], 1], u, u]]], 
        Plus[ 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 4, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ 8, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 2, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ 4, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 6, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ -2, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Subscript[ 
            Subscript[ \[Xi], 2], t]], 
        Plus[ 
          Times[ 2, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -5, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 8, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Xi], 1], u], 
          Subscript[ 
            Subscript[ \[Phi], 1], x]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Xi], 1], u], 
          Subscript[ 
            Subscript[ \[Phi], 1], x]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Xi], 1], u], 
          Subscript[ 
            Subscript[ \[Phi], 1], x]], 
        Plus[ 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]], 
          Times[ 2, 
            Subscript[ 
              Subscript[ \[Phi], 1], u]]], 
        Plus[ 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Times[ k, 
            Subscript[ 
              Subscript[ \[Xi], 1], u, u]]], LieStructure, Metric, 
        SymmGroup}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The last four elements of the list ",
  StyleBox["FinalResult", "MmaText",
    FontSlant->"Italic"],
  " are empty or contain symbolic names which carry no information at this \
stage of the calculation. Another global variable of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is called ",
  StyleBox["Result2", "MmaText",
    FontSlant->"Italic"],
  StyleBox[",", "MmaText"],
  " containing the information on the infinitesimals:"
}], "Text",
  CellTags->{"symbolic names", "Result2", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Result2\)], "Input"],

Cell[BoxData[
    \({{xi[2] \[Rule] Function[{x, t, u}, k1 + 2\ k5\ t], 
        phi[1] \[Rule] Function[{x, t, u}, k2 + k5\ u + k3\ x], 
        xi[1] \[Rule] Function[{x, t, u}, k4 - k3\ u + k5\ x]}, {}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The global variable ",
  StyleBox["Result2", "MmaText",
    FontSlant->"Italic"],
  " contains the infinitesimals and the remaining equations of the \
determining equations not solved by the function ",
  StyleBox["PDESolve[]", "MmaText"],
  ". The function ",
  StyleBox["PDESolve[]", "MmaText"],
  " is the solver of the package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". For the current equation, all determining equations are solved. Thus, \
the last element of ",
  StyleBox["Result2", "MmaText",
    FontSlant->"Italic"],
  " is empty. The results for the infinitesimals are given by substitution \
rules usable in other calculations. For example, an application of this kind \
of calculation is the reduction of the equation."
}], "Text",
  CellTags->{"remaining equations", "PDESolve[]"}],

Cell["\<\
We select the subgroup of interest by setting a subgroup of the \
group constants to a numeric value and others to a symbolic value. The \
infinitesimals are thus reduced  by\
\>", "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, t, u[x, t]], \(xi[2]\)[x, t, u[x, t]]}, {
              \(phi[1]\)[x, t, u[x, t]]}} /. 
          Result2\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] v, k2 \[Rule] 1, k3 \[Rule] 0, k4 \[Rule] 1, 
          k5 \[Rule] 0, u[___] \[Rule] u}\)], "Input"],

Cell[BoxData[
    \({{1, v}, {1}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"This special extraction of a subgroup is related to a moving wave solution. \
Tang\[CloseCurlyQuote]s equation is thus invariant with respect to \
translations:"], "Text",
  Evaluatable->False,
  CellTags->"moving wave solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rtang = 
      LieReduction[tang, {u}, {x, t}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[rtang]] /. {zeta1 \[Rule] \[Zeta]\_1}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - v\ x - \[Zeta]\_1 == 0\)},
          {\(u - x - F\_1 == 0\)},
          {
            \(2\ F1\_\(\[Zeta]\_1\) - 2\ v\ F1\_\[Zeta]\_1\%2 + 
                v\^2\ F1\_\[Zeta]\_1\%3 - 
                k\ v\^2\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The reduced equation is solved by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(mwtang = 
      DSolve[rtang\[LeftDoubleBracket]3, 1\[RightDoubleBracket] == 0, F1, 
        zeta1]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"Solve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(1\/\(2\ k\)\), 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(-k\), " ", \(v\^2\), " ", 
                    RowBox[{"ArcTan", "[", 
                      RowBox[{"1", "-", 
                        RowBox[{"v", " ", 
                          RowBox[{
                            SuperscriptBox["F1", "\[Prime]",
                              MultilineFunction->None], "[", "#1", "]"}]}]}], 
                      "]"}]}], "+", 
                  RowBox[{"2", " ", "k", " ", 
                    RowBox[{"Log", "[", 
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{
                            SuperscriptBox["F1", "\[Prime]",
                              MultilineFunction->None], "[", "#1", "]"}], 
                          \(v\^2\/2\)], " ", 
                        SuperscriptBox[
                          RowBox[{"(", 
                            RowBox[{"2", "-", 
                              RowBox[{"2", " ", "v", " ", 
                                RowBox[{
                                  SuperscriptBox["F1", "\[Prime]",
                                    MultilineFunction->None], "[", "#1", 
                                  "]"}]}], "+", 
                              RowBox[{\(v\^2\), " ", 
                                SuperscriptBox[
                                  RowBox[{
                                    SuperscriptBox["F1", "\[Prime]",
                                      MultilineFunction->None], "[", "#1", 
                                    "]"}], "2"]}]}], ")"}], 
                          \(-\(v\^2\/4\)\)]}], "]"}]}], "-", \(2\ #1\)}], 
                ")"}]}], "==", \(C[1]\)}], ",", 
          RowBox[{"{", 
            RowBox[{
              SuperscriptBox["F1", "\[Prime]",
                MultilineFunction->None], "[", "#1", "]"}], "}"}]}], "]"}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is an implicit representation of the solution entangling the \
similarity function ",
  Cell[BoxData[
      FormBox[
        StyleBox["F1",
          FontSlant->"Italic"], TraditionalForm]]],
  " in trigonometric and logarithmic relations."
}], "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],

Cell[TextData[{
  "Another reduction of the equation follows by the choice ",
  Cell[BoxData[
      \(TraditionalForm\`k3 = c\)]],
  ":"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, t, u[x, t]], \(xi[2]\)[x, t, u[x, t]]}, {
              \(phi[1]\)[x, t, u[x, t]]}} /. \n\t\t
          Result2\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] c, k4 \[Rule] 0, 
          k5 \[Rule] 0, \n\t\t\tu[___] \[Rule] u}\)], "Input"],

Cell[BoxData[
    \({{\(-c\)\ u, 0}, {c\ x}}\)], "Output"]
}, Open  ]],

Cell["The related reduction is", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(r1tang = 
      LieReduction[tang, {u}, {x, t}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[r1tang]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - \[Zeta]\_1 == 0\)},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(u\^2\/2\),
                    ScriptLevel->0]}], 
                StyleBox["-",
                  ScriptLevel->0], 
                StyleBox[\(x\^2\/2\),
                  ScriptLevel->0], "-", \(F\_1\)}], "==", "0"}]},
          {\(\(-k\) + F1\_\(\[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
Solving the reduced equation, we get the explicit representation \
for the similarity solution by\
\>", "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1tang = 
      DSolve[r1tang\[LeftDoubleBracket]3, 1\[RightDoubleBracket] == 0, F1, 
        zeta1]\)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((C[1] + k\ #1&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Inserting this solution into the similarity representation, we end up with \
an implicit representation of the solution for the field ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "similarity representation", "implicit representation of the solution"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      Flatten[r1tang\[LeftDoubleBracket]2\[RightDoubleBracket] /. s1tang]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\(-\(u\^2\/2\)\) - x\^2\/2 == k\ t + C[1]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This result illustrates that the circles in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane are dependent on the time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". The radius of the circle depends on the actual time and on the signs of \
the constants ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`k\)], "MmaText"],
  ". If both constants are negative the radius of the circle increases to \
infinity if time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " increases. If ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] is negative and ",
  Cell[BoxData[
      \(TraditionalForm\`k > 0\)]],
  ", we get an upper limit for ",
  Cell[BoxData[
      \(TraditionalForm\`t = \( | C[1] | \(/ k\)\)\)]],
  " for which the radius is real. However, if we set ",
  Cell[BoxData[
      \(TraditionalForm\`C[1] > 0\)]],
  ", there exist no real radii in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, u)\)\)]],
  "-plane. We demonstrate this behavior for ",
  Cell[BoxData[
      \(TraditionalForm\`k = \(-3\)/2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`C[1] = 1/2\)]],
  " for which a lower limit in ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " exists. The following animation shows the increase of the radius ",
  Cell[BoxData[
      \(TraditionalForm\`\(-k\)\ t - C[1]\)]],
  " by increasing the time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " above the threshold of ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 1/4\)]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{"circle", "animation"}],

Cell[BoxData[
    \(<< Graphics`ImplicitPlot`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[ImplicitPlot[
        u\^2\/2 + x\^2\/2 == \(-k\)\ t - C[1] /. {t \[Rule] ti, 
            k \[Rule] \(-1.5\), C[1] \[Rule] 1\/2}, {x, \(-2\), 2}, 
        PlotRange \[Rule] {{\(-2\), 2}, {\(-2\), 2}}, PlotPoints \[Rule] 35, 
        PlotStyle \[Rule] Hue[ti], 
        PlotLabel \[Rule] "\<             t=\>"<>ToString[ti], 
        AxesLabel \[Rule] {"\<x\>", "\<u\>"}], {ti, 1.5, 0.251, \(- .05\)}]
      \)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.5) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 1 r

.5 Mabswid

.03229 .4999 m

.03429 .45685 L

.04026 .41406 L

.05015 .37201 L

.06388 .33104 L

.08133 .29152 L

.10235 .25378 L

.12676 .21814 L

.15436 .18491 L

.18491 .15436 L

.21814 .12676 L

.25378 .10235 L

.29152 .08133 L

.33104 .06388 L

.37201 .05015 L

.41406 .04026 L

.45685 .03429 L

.5 .03229 L

.54315 .03429 L

.58594 .04026 L

.62799 .05015 L

.66896 .06388 L

.70848 .08133 L

.74622 .10235 L

.78186 .12676 L

.81509 .15436 L

.84564 .18491 L

.87324 .21814 L

.89765 .25378 L

.91867 .29152 L

.93612 .33104 L

.94985 .37201 L

.95974 .41406 L

.96571 .45685 L

.96771 .4999 L

s

.03229 .5001 m

.03429 .54315 L

.04026 .58594 L

.05015 .62799 L

.06388 .66896 L

.08133 .70848 L

.10235 .74622 L

.12676 .78186 L

.15436 .81509 L

.18491 .84564 L

.21814 .87324 L

.25378 .89765 L

.29152 .91867 L

.33104 .93612 L

.37201 .94985 L

.41406 .95974 L

.45685 .96571 L

.5 .96771 L

.54315 .96571 L

.58594 .95974 L

.62799 .94985 L

.66896 .93612 L

.70848 .91867 L

.74622 .89765 L

.78186 .87324 L

.81509 .84564 L

.84564 .81509 L

.87324 .78186 L

.89765 .74622 L

.91867 .70848 L

.93612 .66896 L

.94985 .62799 L

.95974 .58594 L

.96571 .54315 L

.96771 .5001 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->24,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001BOolF0omKOol0
04eoo`D3o`Yoo`03001oogoo00Uoo`D3oeIoo`00BGoo10?o3goo00<007ooOol03Woo10?oDWoo0015
Ool40olCOol2000COol30om?Ool0045oo`@3oaMoo`03001oogoo01Eoo`@3od]oo`00?Woo0`?o6goo
00<007ooOol06Goo0`?oB7oo000lOol20olNOol00`00Oomoo`0LOol20om6Ool003Yoo`83ob1oo`80
01moo`83odAoo`00>7oo0P?o8Woo00<007ooOol087oo0P?o@Woo000fOol20olTOol00`00Oomoo`0R
Ool20om0Ool003Eoo`030omoogoo02Aoo`03001oogoo02Aoo`83ocioo`00<goo0P?o9goo0P009goo
0P?o?7oo000bOol00`?oOomoo`0WOol00`00Oomoo`0XOol00`?oOomoo`0iOol0031oo`83obYoo`03
001oogoo02Uoo`83ocUoo`00;goo00<3ogooOol05goo1@000Woo0P0017oo0P0017oo00<007ooOol0
:goo00<3ogooOol0=Woo000]Ool20olLOol00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0
;7oo0P?o=Woo000/Ool00`?oOomoo`0LOol00`00Oomoo`0:Ool01000Oomoogoo0P00;goo00<3ogoo
Ool0<goo000[Ool00`?oOomoo`0EOol40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`0_Ool0
0`?oOomoo`0bOol002Yoo`030omoogoo01ioo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo
031oo`030omoogoo035oo`00:7oo0P?o87oo0P002Woo0`000goo00<007ooOol0<Goo0P?o<Goo000W
Ool00`?oOomoo`0bOol2000dOol00`?oOomoo`0^Ool002Ioo`030omoogoo03=oo`03001oogoo03Ao
o`030omoogoo02eoo`009Goo00<3ogooOol0=7oo00<007ooOol0=Goo00<3ogooOol0;7oo000TOol0
0`?oOomoo`0eOol00`00Oomoo`0fOol00`?oOomoo`0[Ool002=oo`030omoogoo03Ioo`8003Qoo`03
0omoogoo02Yoo`008Woo00<3ogooOol0=goo00<007ooOol0>7oo00<3ogooOol0:Goo000QOol00`?o
Oomoo`0hOol00`00Oomoo`0iOol00`?oOomoo`0XOol0021oo`030omoogoo03Uoo`03001oogoo03Yo
o`030omoogoo02Moo`007goo00<3ogooOol0>Woo0P00?7oo00<3ogooOol09Woo000NOol00`?oOomo
o`0kOol00`00Oomoo`0lOol00`?oOomoo`0UOol001ioo`030omoogoo03]oo`03001oogoo03aoo`03
0omoogoo02Eoo`007Goo00<3ogooOol0?7oo00<007ooOol0?Goo00<3ogooOol097oo000LOol00`?o
Oomoo`0mOol00`00Oomoo`0nOol00`?oOomoo`0SOol001]oo`030omoogoo03ioo`80041oo`030omo
ogoo029oo`006goo00<3ogooOol0?Woo00<007ooOol0?goo00<3ogooOol08Woo000JOol00`?oOomo
o`0hOol50002Ool00`00Oomoo`10Ool00`?oOomoo`0QOol001Uoo`030omoogoo03]oo`03001oogoo
009oo`03001oogoo045oo`030omoogoo021oo`006Goo00<3ogooOol0>goo00<007ooOol00Woo0P00
@Woo00<3ogooOol087oo000HOol00`?oOomoo`0dOol40004Ool00`00Oomoo`02Ool00`00Oomoo`12
Ool00`?oOomoo`0OOol001Moo`030omoogoo03eoo`03001oogoo009oo`03001oogoo04=oo`030omo
ogoo01ioo`005goo00<3ogooOol0?7oo0P0017oo00<007ooOol0@goo00<3ogooOol07Woo000FOol0
0`?oOomoo`13Ool20015Ool00`?oOomoo`0MOol001Eoo`030omoogoo04Aoo`03001oogoo04Aoo`03
0omoogoo01eoo`005Goo00<3ogooOol0A7oo00<007ooOol0AGoo00<3ogooOol077oo000DOol00`?o
Oomoo`15Ool00`00Oomoo`15Ool00`?oOomoo`0LOol001Aoo`030omoogoo04Eoo`03001oogoo04Eo
o`030omoogoo01aoo`004goo00<3ogooOol0AWoo0P00Agoo00<3ogooOol06goo000COol00`?oOomo
o`16Ool00`00Oomoo`16Ool00`?oOomoo`0KOol0019oo`030omoogoo04Moo`03001oogoo04Moo`03
0omoogoo01Yoo`004Woo00<3ogooOol0Agoo00<007ooOol0Agoo00<3ogooOol06Woo000AOol00`?o
Oomoo`18Ool20019Ool00`?oOomoo`0IOol0015oo`030omoogoo04Qoo`03001oogoo04Qoo`030omo
ogoo01Uoo`004Goo00<3ogooOol0B7oo00<007ooOol0B7oo00<3ogooOol06Goo000@Ool00`?oOomo
o`19Ool00`00Oomoo`19Ool00`?oOomoo`0HOol0011oo`030omoogoo04Uoo`8004Yoo`030omoogoo
01Qoo`0047oo00<3ogooOol0BGoo00<007ooOol0BWoo00<3ogooOol05goo000@Ool00`?oOomoo`19
Ool00`00Oomoo`1:Ool00`?oOomoo`0GOol000moo`030omoogoo03Qoo`8000Aoo`8000Aoo`8000Ao
o`03001oogoo04]oo`030omoogoo01Ioo`003goo00<3ogooOol0=goo00@007ooOol000Qoo`04001o
ogoo0003Ool00`00Oomoo`1;Ool00`?oOomoo`0FOol000moo`030omoogoo03Moo`04001oogoo000;
Ool01000Oomoogoo0P00C7oo00<3ogooOol05Woo000>Ool00`?oOomoo`0bOol40002Ool01000Oomo
o`002Goo0P0017oo00<007ooOol0C7oo00<3ogooOol05Goo000>Ool00`?oOomoo`0hOol01000Oomo
o`002Goo00<007ooOol00goo00<007ooOol0C7oo00<3ogooOol05Goo000>Ool00`?oOomoo`0iOol2
000:Ool30003Ool00`00Oomoo`1<Ool00`?oOomoo`0EOol000ioo`030omoogoo04]oo`8004eoo`03
0omoogoo01Eoo`003Goo00<3ogooOol0C7oo00<007ooOol0CGoo00<3ogooOol057oo000=Ool00`?o
Oomoo`1<Ool00`00Oomoo`1=Ool00`?oOomoo`0DOol000eoo`030omoogoo04aoo`03001oogoo04eo
o`030omoogoo01Aoo`003Goo00<3ogooOol0C7oo0P00CWoo00<3ogooOol057oo000=Ool00`?oOomo
o`1<Ool00`00Oomoo`1=Ool00`?oOomoo`0DOol000aoo`030omoogoo04eoo`03001oogoo04ioo`03
0omoogoo01=oo`001goo100000=oo`?oOol02Goo1@000Woo0P0017oo0P0037oo1@0037oo0P0017oo
0P0017oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo1@002goo1@000Woo0P0017oo
0P002Goo00@3ogooOomoo`@000ioo`001goo00<007ooOol00Woo00<3ogooOol02Woo00<007ooOol0
1goo00@007ooOol000eoo`03001oogoo00]oo`04001oogoo0008Ool01000Oomoo`002Woo00<007oo
Ool02goo00@007ooOol000Qoo`04001oogoo000=Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool01000
Oomoo`0027oo00D3ogooOomoo`00015oo`0027oo00D007ooOomoo`?o00aoo`03001oogoo00Yoo`03
001oogoo00]oo`03001oogoo00]oo`04001oogoo000;Ool00`00Oomoo`08Ool2000<Ool01000Oomo
o`002goo00<007ooOol02goo00<007ooOol03Goo00<007ooOol02Woo00<007ooOol01Woo00<3ogoo
Ool00Woo00<007ooOol03Woo00000goo000000020004Ool01000Oomoo`?o17oo100017oo00<007oo
Ool027oo0P001Woo100017oo00<007ooOol01Goo10000Woo00@007ooOol000Uoo`8000]oo`03001o
ogoo00]oo`04001oogoo0009Ool2000>Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool20009Ool00`?o
Oomoo`03Ool00`00Oomoo`0=Ool000Moo`06001oogoo001oo`?o37oo00<007ooOol027oo00<007oo
Ool03Goo00<007ooOol02goo00@007ooOol000Uoo`03001oogoo00Yoo`03001oogoo00]oo`04001o
ogoo0009Ool00`00Oomoo`0=Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool00`00Oomoo`08Ool01@?o
Oomoogoo00000Woo00<007ooOol037oo0008Ool20002Ool00`?oOomoo`09Ool2000:Ool3000<Ool2
000>Ool2000:Ool3000:Ool00`00Oomoo`0<Ool2000:Ool3000<Ool2000>Ool2000:Ool30008Ool0
0`?oOomoo`02Ool2000?Ool000aoo`030omoogoo04eoo`8004moo`030omoogoo01=oo`0037oo00<3
ogooOol0CGoo00<007ooOol0CWoo00<3ogooOol04goo000<Ool00`?oOomoo`1=Ool00`00Oomoo`1>
Ool00`?oOomoo`0COol000aoo`030omoogoo04eoo`03001oogoo04ioo`030omoogoo00Uoo`800003
Ool0000000Eoo`001Woo1P0000<3o`000000WP0000<3o`00000010001Woo00<007oo00001Woo0006
Ool01`00Oomoogoo001oo`?o009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo
00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`0000Aoo`05001oogooOol00003
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03
001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03
001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo00<3o`00
Ool00goo00<007ooOol01Goo00<007ooOol01Goo000<Ool00`?oOomoo`1=Ool00`00Oomoo`1>Ool0
0`?oOomoo`09Ool200000goo00000005Ool000aoo`030omoogoo04eoo`03001oogoo04ioo`030omo
ogoo01=oo`0037oo00<3ogooOol0CGoo0P00Cgoo00<3ogooOol04goo000<Ool00`?oOomoo`1=Ool0
0`00Oomoo`1>Ool00`?oOomoo`0COol000aoo`030omoogoo04eoo`03001oogoo04ioo`030omoogoo
01=oo`0037oo00<3ogooOol0CGoo00<007ooOol0CWoo00<3ogooOol04goo000<Ool00`?oOomoo`1=
Ool00`00Oomoo`1>Ool00`?oOomoo`0COol000aoo`030omoogoo04eoo`8004moo`030omoogoo01=o
o`0037oo00<3ogooOol0CGoo00<007ooOol0CWoo00<3ogooOol04goo000<Ool00`?oOomoo`1=Ool0
0`00Oomoo`1>Ool00`?oOomoo`0COol000eoo`030omoogoo04aoo`03001oogoo04eoo`030omoogoo
01Aoo`003Goo00<3ogooOol0C7oo0P00CWoo00<3ogooOol057oo000=Ool00`?oOomoo`1<Ool00`00
Oomoo`1=Ool00`?oOomoo`0DOol000eoo`030omoogoo04aoo`03001oogoo04eoo`030omoogoo01Ao
o`003Goo00<3ogooOol0C7oo00<007ooOol0CGoo00<3ogooOol057oo000>Ool00`?oOomoo`1;Ool2
001=Ool00`?oOomoo`0EOol000ioo`030omoogoo04]oo`03001oogoo04aoo`030omoogoo01Eoo`00
3Woo00<3ogooOol0Bgoo00<007ooOol0C7oo00<3ogooOol05Goo000>Ool00`?oOomoo`0iOol20004
Ool20004Ool20004Ool00`00Oomoo`1<Ool00`?oOomoo`0EOol000moo`030omoogoo03Moo`04001o
ogoo0008Ool01000Oomoo`000goo00<007ooOol0Bgoo00<3ogooOol05Woo000?Ool00`?oOomoo`0g
Ool01000Oomoo`002goo00@007ooOomoo`8004aoo`030omoogoo01Ioo`003goo00<3ogooOol0=goo
00@007ooOol000Uoo`8000Aoo`03001oogoo04]oo`030omoogoo01Ioo`0047oo00<3ogooOol0=Woo
00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo04Yoo`030omoogoo01Moo`0047oo00<3ogoo
Ool0=goo0P002Woo0`000goo00<007ooOol0BWoo00<3ogooOol05goo000@Ool00`?oOomoo`19Ool2
001:Ool00`?oOomoo`0HOol0011oo`030omoogoo04Uoo`03001oogoo04Uoo`030omoogoo01Qoo`00
4Goo00<3ogooOol0B7oo00<007ooOol0B7oo00<3ogooOol06Goo000AOol00`?oOomoo`18Ool00`00
Oomoo`18Ool00`?oOomoo`0IOol0015oo`030omoogoo04Qoo`8004Uoo`030omoogoo01Uoo`004Woo
00<3ogooOol0Agoo00<007ooOol0Agoo00<3ogooOol06Woo000BOol00`?oOomoo`17Ool00`00Oomo
o`17Ool00`?oOomoo`0JOol001=oo`030omoogoo04Ioo`03001oogoo04Ioo`030omoogoo01]oo`00
4goo00<3ogooOol0AWoo00<007ooOol0AWoo00<3ogooOol06goo000DOol00`?oOomoo`15Ool20016
Ool00`?oOomoo`0LOol001Aoo`030omoogoo04Eoo`03001oogoo04Eoo`030omoogoo01aoo`005Goo
00<3ogooOol0A7oo00<007ooOol0AGoo00<3ogooOol077oo000EOol00`?oOomoo`14Ool00`00Oomo
o`14Ool00`?oOomoo`0MOol001Ioo`030omoogoo04=oo`8004Eoo`030omoogoo01eoo`005Woo00<3
ogooOol0@goo00<007ooOol0@goo00<3ogooOol07Woo000GOol00`?oOomoo`0kOol50002Ool00`00
Oomoo`13Ool00`?oOomoo`0NOol001Moo`030omoogoo03eoo`03001oogoo009oo`03001oogoo049o
o`030omoogoo01moo`0067oo00<3ogooOol0?7oo00<007ooOol00Woo0P00@goo00<3ogooOol07goo
000IOol00`?oOomoo`0kOol00`00Oomoo`02Ool00`00Oomoo`11Ool00`?oOomoo`0POol001Uoo`03
0omoogoo03]oo`03001oogoo009oo`03001oogoo045oo`030omoogoo021oo`006Woo00<3ogooOol0
>Goo0P0017oo00<007ooOol0@7oo00<3ogooOol08Goo000KOol00`?oOomoo`0nOol00`00Oomoo`0o
Ool00`?oOomoo`0ROol001]oo`030omoogoo03ioo`80041oo`030omoogoo029oo`0077oo00<3ogoo
Ool0?Goo00<007ooOol0?Woo00<3ogooOol08goo000MOol00`?oOomoo`0lOol00`00Oomoo`0mOol0
0`?oOomoo`0TOol001ioo`030omoogoo03]oo`03001oogoo03aoo`030omoogoo02Eoo`007goo00<3
ogooOol0>Woo0P00?7oo00<3ogooOol09Woo000POol00`?oOomoo`0iOol00`00Oomoo`0jOol00`?o
Oomoo`0WOol0025oo`030omoogoo03Qoo`03001oogoo03Uoo`030omoogoo02Qoo`008Woo00<3ogoo
Ool0=goo00<007ooOol0>7oo00<3ogooOol0:Goo000SOol00`?oOomoo`0fOol2000hOol00`?oOomo
o`0ZOol002Aoo`030omoogoo03Eoo`03001oogoo03Ioo`030omoogoo02]oo`0097oo00<3ogooOol0
=Goo00<007ooOol0=Woo00<3ogooOol0:goo000UOol00`?oOomoo`0dOol00`00Oomoo`0eOol00`?o
Oomoo`0/Ool002Ioo`030omoogoo03=oo`8003Eoo`030omoogoo02eoo`009goo0P?o<goo00<007oo
Ool0<Woo0P?o<7oo000YOol00`?oOomoo`0`Ool00`00Oomoo`0aOol00`?oOomoo`0`Ool002Yoo`83
oaeoo`D0009oo`8000Aoo`8000Aoo`03001oogoo02moo`83oc=oo`00;7oo00<3ogooOol077oo00<0
07ooOol01goo00@007ooOol000=oo`03001oogoo02ioo`030omoogoo03=oo`00;Goo00<3ogooOol0
6goo00<007ooOol02Woo00@007ooOomoo`8002ioo`030omoogoo03Aoo`00;Woo00<3ogooOol06Woo
00<007ooOol027oo0P0017oo00<007ooOol0;7oo00<3ogooOol0=Goo000_Ool20olJOol00`00Oomo
o`08Ool00`00Oomoo`03Ool00`00Oomoo`0ZOol20olhOol0035oo`030omoogoo01Ioo`8000Yoo`<0
00=oo`03001oogoo02Uoo`030omoogoo03Qoo`00<Woo00<3ogooOol09goo0P00:7oo0P?o>goo000c
Ool20olWOol00`00Oomoo`0UOol20olmOol003Eoo`83obEoo`03001oogoo02=oo`83ocmoo`00=goo
0`?o8Woo00<007ooOol087oo0`?o@Goo000jOol20olPOol2000OOol20om4Ool003aoo`83oaioo`03
001oogoo01aoo`83odIoo`00?Woo0`?o6goo00<007ooOol06Goo0`?oB7oo0011Ool20olIOol00`00
Oomoo`0GOol20om;Ool004=oo`83oaMoo`03001oogoo01Eoo`83odeoo`00AGoo1@?o4Woo0P004Goo
1@?oCgoo001:Ool80ol:Ool00`00Oomoo`09Ool70omDOol0059oo`L3o`=oo`03001oogoo009oo`L3
oe]oo`00FGoo20?oHWoo001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo10000goo00<007oo
Ool0I7oo001EOol00`00Oomoo`04Ool00`00Oomoo`1TOol005Ioo`03001oogoo00=oo`8006Eoo`00
Egoo00<007ooOol0JGoo001EOol01000Oomoo`00JWoo001FOol2001[Ool00<=oo`00`goo0033Ool0
07Ioo`8000=oo`@0009oo`D0009oo`8000Aoo`8003=oo`00MGoo00@007ooOol000Yoo`03001oogoo
00Moo`04001oogoo000bOol005]oo`@001Ioo`03001oogoo00=oo`@000Aoo`03001oogoo00Yoo`03
001oogoo031oo`00FWoo00@007ooOol001Ioo`D000Yoo`03001oogoo00Qoo`8003=oo`00FWoo00@0
07ooOol001Moo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo039oo`00FGoo0P0000=oo`00
000097oo0P002Woo0`00<Woo0033Ool00<=oo`00`goo0033Ool00<=oo`00\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.45) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .7 r

.5 Mabswid

.04242 .4999 m

.04438 .45778 L

.05022 .41592 L

.05989 .37478 L

.07332 .3347 L

.0904 .29604 L

.11096 .25912 L

.13485 .22425 L

.16185 .19173 L

.19173 .16185 L

.22425 .13485 L

.25912 .11096 L

.29604 .0904 L

.3347 .07332 L

.37478 .05989 L

.41592 .05022 L

.45778 .04438 L

.5 .04242 L

.54222 .04438 L

.58408 .05022 L

.62522 .05989 L

.6653 .07332 L

.70396 .0904 L

.74088 .11096 L

.77575 .13485 L

.80827 .16185 L

.83815 .19173 L

.86515 .22425 L

.88904 .25912 L

.9096 .29604 L

.92668 .3347 L

.94011 .37478 L

.94978 .41592 L

.95562 .45778 L

.95758 .4999 L

s

.04242 .5001 m

.04438 .54222 L

.05022 .58408 L

.05989 .62522 L

.07332 .6653 L

.0904 .70396 L

.11096 .74088 L

.13485 .77575 L

.16185 .80827 L

.19173 .83815 L

.22425 .86515 L

.25912 .88904 L

.29604 .9096 L

.3347 .92668 L

.37478 .94011 L

.41592 .94978 L

.45778 .95562 L

.5 .95758 L

.54222 .95562 L

.58408 .94978 L

.62522 .94011 L

.6653 .92668 L

.70396 .9096 L

.74088 .88904 L

.77575 .86515 L

.80827 .83815 L

.83815 .80827 L

.86515 .77575 L

.88904 .74088 L

.9096 .70396 L

.92668 .6653 L

.94011 .62522 L

.94978 .58408 L

.95562 .54222 L

.95758 .5001 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005Uoo`L3mF=oo`00DWoo1`?e0goo00@007ooOomoo`P3mE]oo`00Bgoo1`?e2Woo0P002Woo
1`?eE7oo0016Ool50oDAOol00`00Oomoo`0@Ool50oE?Ool004Aoo`83mAIoo`03001oogoo01Eoo`83
mDeoo`00@Woo0P?e67oo00<007ooOol05goo0P?eBgoo000oOol30oDJOol2000JOol20oE9Ool003eo
o`83mAeoo`03001oogoo01]oo`83mDMoo`00>goo0P?e7goo00<007ooOol07Goo0P?eAGoo000iOol2
0oDQOol00`00Oomoo`0OOol30oE2Ool003Moo`83mB=oo`8002=oo`83mD1oo`00=Goo0P?e9Goo00<0
07ooOol097oo0P?e?Woo000cOol20oDWOol00`00Oomoo`0VOol20oDlOol0035oo`83mAIoo`D0009o
o`8000Aoo`8000Aoo`03001oogoo02Qoo`83mCYoo`00<7oo00<3mGooOol067oo00<007ooOol01goo
00@007ooOol000=oo`03001oogoo02Yoo`030oEoogoo03Moo`00;Woo0P?e6goo00<007ooOol02Woo
00@007ooOomoo`8002aoo`83mCMoo`00;Goo00<3mGooOol04goo100017oo00<007ooOol027oo0P00
17oo00<007ooOol0;Goo00<3mGooOol0=7oo000/Ool00`?eOomoo`0LOol00`00Oomoo`08Ool00`00
Oomoo`03Ool00`00Oomoo`0^Ool00`?eOomoo`0cOol002]oo`030oEoogoo01aoo`8000Yoo`<000=o
o`03001oogoo02moo`030oEoogoo039oo`00:Goo0P?e<Goo0P00<Goo00<3mGooOol0<Goo000XOol0
0`?eOomoo`0aOol00`00Oomoo`0aOol00`?eOomoo`0`Ool002Moo`030oEoogoo039oo`03001oogoo
039oo`030oEoogoo02moo`009Woo00<3mGooOol0<goo00<007ooOol0<goo00<3mGooOol0;Woo000U
Ool00`?eOomoo`0dOol2000eOol00`?eOomoo`0]Ool002Aoo`030oEoogoo03Eoo`03001oogoo03Eo
o`83mBeoo`008goo00<3mGooOol0=Woo00<007ooOol0=goo00<3mGooOol0:Woo000ROol00`?eOomo
o`0gOol00`00Oomoo`0hOol00`?eOomoo`0YOol0025oo`030oEoogoo03Qoo`8003Yoo`030oEoogoo
02Qoo`0087oo00<3mGooOol0>Goo00<007ooOol0>Goo00<3mGooOol0:7oo000OOol00`?eOomoo`0j
Ool00`00Oomoo`0jOol00`?eOomoo`0WOol001moo`030oEoogoo03Yoo`03001oogoo03]oo`030oEo
ogoo02Ioo`007Woo00<3mGooOol0>goo00<007ooOol0>goo00<3mGooOol09Woo000MOol00`?eOomo
o`0lOol2000mOol00`?eOomoo`0UOol001aoo`030oEoogoo03eoo`03001oogoo03eoo`030oEoogoo
02Aoo`0077oo00<3mGooOol0=Woo1@000Woo00<007ooOol0?Goo00<3mGooOol097oo000KOol00`?e
Oomoo`0iOol00`00Oomoo`02Ool00`00Oomoo`0nOol00`?eOomoo`0SOol001Yoo`030oEoogoo03Yo
o`03001oogoo009oo`80041oo`030oEoogoo029oo`006Woo00<3mGooOol0<Woo100017oo00<007oo
Ool00Woo00<007ooOol0?goo00<3mGooOol08Woo000IOol00`?eOomoo`0kOol00`00Oomoo`02Ool0
0`00Oomoo`10Ool00`?eOomoo`0QOol001Qoo`030oEoogoo03]oo`8000Aoo`03001oogoo045oo`03
0oEoogoo021oo`0067oo00<3mGooOol0@Goo0P00@Woo00<3mGooOol087oo000GOol00`?eOomoo`12
Ool00`00Oomoo`12Ool00`?eOomoo`0OOol001Moo`030oEoogoo049oo`03001oogoo04=oo`030oEo
ogoo01ioo`005Woo00<3mGooOol0@goo00<007ooOol0@goo00<3mGooOol07Woo000FOol00`?eOomo
o`13Ool00`00Oomoo`14Ool00`?eOomoo`0MOol001Ioo`030oEoogoo04=oo`8004Eoo`030oEoogoo
01eoo`005Goo00<3mGooOol0A7oo00<007ooOol0AGoo00<3mGooOol077oo000EOol00`?eOomoo`14
Ool00`00Oomoo`15Ool00`?eOomoo`0LOol001Aoo`030oEoogoo04Eoo`03001oogoo04Ioo`030oEo
ogoo01]oo`0057oo00<3mGooOol0AGoo0P00Agoo00<3mGooOol06goo000COol00`?eOomoo`16Ool0
0`00Oomoo`17Ool00`?eOomoo`0JOol001=oo`030oEoogoo04Ioo`03001oogoo04Moo`030oEoogoo
01Yoo`004goo00<3mGooOol0AWoo00<007ooOol0Agoo00<3mGooOol06Woo000BOol00`?eOomoo`17
Ool20019Ool00`?eOomoo`0IOol0019oo`030oEoogoo04Moo`03001oogoo04Qoo`030oEoogoo01Uo
o`004Woo00<3mGooOol0Agoo00<007ooOol0B7oo00<3mGooOol06Goo000BOol00`?eOomoo`0eOol2
0004Ool20004Ool20004Ool00`00Oomoo`18Ool00`?eOomoo`0IOol0015oo`030oEoogoo03Eoo`04
001oogoo0008Ool01000Oomoo`000goo00<007ooOol0BGoo00<3mGooOol067oo000AOol00`?eOomo
o`0eOol01000Oomoo`002goo00@007ooOomoo`8004Yoo`030oEoogoo01Qoo`004Goo00<3mGooOol0
;goo10000Woo00@007ooOol000Uoo`8000Aoo`03001oogoo04Uoo`030oEoogoo01Qoo`0047oo00<3
mGooOol0=Woo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo04Yoo`030oEoogoo01Moo`00
47oo00<3mGooOol0=goo0P002Woo0`000goo00<007ooOol0BWoo00<3mGooOol05goo000@Ool00`?e
Oomoo`19Ool2001;Ool00`?eOomoo`0GOol0011oo`030oEoogoo04Uoo`03001oogoo04Yoo`030oEo
ogoo01Moo`003goo00<3mGooOol0BWoo00<007ooOol0Bgoo00<3mGooOol05Woo000?Ool00`?eOomo
o`1:Ool00`00Oomoo`1;Ool00`?eOomoo`0FOol000moo`030oEoogoo04Yoo`8004aoo`030oEoogoo
01Ioo`003goo00<3mGooOol0BWoo00<007ooOol0Bgoo00<3mGooOol05Woo000?Ool00`?eOomoo`1:
Ool00`00Oomoo`1;Ool00`?eOomoo`0FOol000Moo`@000=oo`030oEoogoo00Ioo`D0009oo`8000Ao
o`8000aoo`D000aoo`8000Aoo`8000Aoo`8000]oo`03001oogoo00aoo`8000Aoo`8000Aoo`8000ao
o`D000]oo`D0009oo`8000Aoo`8000Moo`030oEoogoo00=oo`@000ioo`001goo00<007ooOol017oo
00<3mGooOol027oo00<007ooOol01goo00@007ooOol000eoo`03001oogoo00]oo`04001oogoo0008
Ool01000Oomoo`002Woo00<007ooOol02goo00@007ooOol000Qoo`04001oogoo000=Ool00`00Oomo
o`0=Ool00`00Oomoo`07Ool01000Oomoo`001Woo00<3mGooOol00goo00<007ooOol03goo0008Ool0
0`00Oomoo`03Ool00`?eOomoo`08Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool0
1000Oomoo`002goo00<007ooOol027oo0P0037oo00@007ooOol000]oo`03001oogoo00]oo`03001o
ogoo00eoo`03001oogoo00Yoo`03001oogoo00Aoo`030oEoogoo00Aoo`03001oogoo00ioo`0000=o
o`0000000P0017oo00<007ooOol00Woo00<3mGooOol0100017oo00<007ooOol027oo0P001Woo1000
17oo00<007ooOol01Goo10000Woo00@007ooOol000Uoo`8000]oo`03001oogoo00]oo`04001oogoo
0009Ool2000>Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool20007Ool00`?eOomoo`05Ool00`00Oomo
o`0=Ool000Moo`04001oogoo0003Ool00`?eOomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool0
0`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol02Woo00<007ooOol02goo00@007ooOol000Uo
o`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00Qoo`03001oogoo00Ioo`030oEoogoo00=o
o`04001oogoo000>Ool000Qoo`8000Aoo`030oEoogoo00Moo`8000Yoo`<000aoo`8000ioo`8000Yo
o`<000Yoo`03001oogoo00aoo`8000Yoo`<000aoo`8000ioo`8000Yoo`<000Ioo`030oEoogoo00Ao
o`8000moo`003Woo00<3mGooOol0Bgoo0P00CGoo00<3mGooOol05Goo000=Ool00`?eOomoo`1<Ool0
0`00Oomoo`1<Ool00`?eOomoo`0EOol000eoo`030oEoogoo04aoo`03001oogoo04aoo`030oEoogoo
01Eoo`003Goo00<3mGooOol0C7oo00<007ooOol0C7oo00<3mGooOol02goo0P0000=oo`0000001Goo
0006Ool700000`?e0000002K00000`?e000000060006Ool00`00Ool00006Ool000Ioo`05001oogoo
Ool00002Ool00`?eOol00003Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001oogoo
009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo
00D007ooOomoo`0000=oo`05001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo
00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00
Oomoogoo00000goo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00
Oomoogoo00000goo00<007ooOol00Woo00H007ooOomoo`000oD2Ool00`00Oomoo`02Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool000eoo`030oEoogoo04aoo`03001oogoo04aoo`030oEoogoo00]oo`80
0003Ool0000000Eoo`003Goo00<3mGooOol0C7oo00<007ooOol0C7oo00<3mGooOol05Goo000>Ool0
0`?eOomoo`1;Ool2001=Ool00`?eOomoo`0EOol000ioo`030oEoogoo04]oo`03001oogoo04aoo`03
0oEoogoo01Eoo`003Woo00<3mGooOol0Bgoo00<007ooOol0C7oo00<3mGooOol05Goo000>Ool00`?e
Oomoo`1;Ool00`00Oomoo`1<Ool00`?eOomoo`0EOol000ioo`030oEoogoo04]oo`03001oogoo04ao
o`030oEoogoo01Eoo`003Woo00<3mGooOol0Bgoo0P00CGoo00<3mGooOol05Goo000>Ool00`?eOomo
o`1;Ool00`00Oomoo`1<Ool00`?eOomoo`0EOol000moo`030oEoogoo04Yoo`03001oogoo04]oo`03
0oEoogoo01Ioo`003goo00<3mGooOol0BWoo00<007ooOol0Bgoo00<3mGooOol05Woo000?Ool00`?e
Oomoo`1:Ool2001<Ool00`?eOomoo`0FOol000moo`030oEoogoo04Yoo`03001oogoo04]oo`030oEo
ogoo01Ioo`003goo00<3mGooOol0BWoo00<007ooOol0Bgoo00<3mGooOol05Woo000?Ool00`?eOomo
o`1:Ool00`00Oomoo`1;Ool00`?eOomoo`0FOol0011oo`030oEoogoo04Uoo`8004]oo`030oEoogoo
01Moo`0047oo00<3mGooOol0BGoo00<007ooOol0BWoo00<3mGooOol05goo000@Ool00`?eOomoo`19
Ool00`00Oomoo`1:Ool00`?eOomoo`0GOol0011oo`030oEoogoo03Moo`8000Aoo`8000Aoo`8000Ao
o`03001oogoo04Yoo`030oEoogoo01Moo`004Goo00<3mGooOol0=Goo00@007ooOol000Qoo`04001o
ogoo0003Ool00`00Oomoo`19Ool00`?eOomoo`0HOol0015oo`030oEoogoo03Eoo`04001oogoo000;
Ool01000Oomoogoo0P00BWoo00<3mGooOol067oo000AOol00`?eOomoo`0eOol01000Oomoo`002Goo
0P0017oo00<007ooOol0BGoo00<3mGooOol067oo000BOol00`?eOomoo`0dOol01000Oomoo`002Goo
00<007ooOol00goo00<007ooOol0B7oo00<3mGooOol06Goo000BOol00`?eOomoo`0eOol2000:Ool3
0003Ool00`00Oomoo`18Ool00`?eOomoo`0IOol0019oo`030oEoogoo04Moo`8004Uoo`030oEoogoo
01Uoo`004Woo00<3mGooOol0Agoo00<007ooOol0B7oo00<3mGooOol06Goo000COol00`?eOomoo`16
Ool00`00Oomoo`17Ool00`?eOomoo`0JOol001=oo`030oEoogoo04Ioo`03001oogoo04Moo`030oEo
ogoo01Yoo`0057oo00<3mGooOol0AGoo0P00Agoo00<3mGooOol06goo000DOol00`?eOomoo`15Ool0
0`00Oomoo`16Ool00`?eOomoo`0KOol001Eoo`030oEoogoo04Aoo`03001oogoo04Eoo`030oEoogoo
01aoo`005Goo00<3mGooOol0A7oo00<007ooOol0AGoo00<3mGooOol077oo000FOol00`?eOomoo`13
Ool00`00Oomoo`14Ool00`?eOomoo`0MOol001Ioo`030oEoogoo04=oo`8004Eoo`030oEoogoo01eo
o`005Woo00<3mGooOol0@goo00<007ooOol0@goo00<3mGooOol07Woo000GOol00`?eOomoo`12Ool0
0`00Oomoo`13Ool00`?eOomoo`0NOol001Moo`030oEoogoo049oo`03001oogoo049oo`030oEoogoo
01moo`0067oo00<3mGooOol0@Goo0P00@goo00<3mGooOol07goo000HOol00`?eOomoo`11Ool00`00
Oomoo`11Ool00`?eOomoo`0POol001Uoo`030oEoogoo03Uoo`D0009oo`03001oogoo045oo`030oEo
ogoo021oo`006Goo00<3mGooOol0>goo00<007ooOol00Woo00<007ooOol0@7oo00<3mGooOol08Goo
000JOol00`?eOomoo`0jOol00`00Oomoo`02Ool20010Ool00`?eOomoo`0ROol001Yoo`030oEoogoo
03Yoo`03001oogoo009oo`03001oogoo03moo`030oEoogoo029oo`006goo00<3mGooOol0>Goo00<0
07ooOol00Woo00<007ooOol0?Woo00<3mGooOol08goo000LOol00`?eOomoo`0gOol20004Ool00`00
Oomoo`0mOol00`?eOomoo`0TOol001aoo`030oEoogoo03eoo`03001oogoo03eoo`030oEoogoo02Ao
o`007Goo00<3mGooOol0?7oo0P00?Goo00<3mGooOol09Goo000NOol00`?eOomoo`0kOol00`00Oomo
o`0kOol00`?eOomoo`0VOol001moo`030oEoogoo03Yoo`03001oogoo03Yoo`030oEoogoo02Moo`00
87oo00<3mGooOol0>Goo00<007ooOol0>Woo00<3mGooOol09goo000QOol00`?eOomoo`0hOol2000j
Ool00`?eOomoo`0XOol0029oo`030oEoogoo03Moo`03001oogoo03Qoo`030oEoogoo02Uoo`008goo
00<3mGooOol0=Woo00<007ooOol0=goo00<3mGooOol0:Woo000TOol00`?eOomoo`0eOol00`00Oomo
o`0fOol00`?eOomoo`0[Ool002Eoo`030oEoogoo03Aoo`8003Eoo`83mBioo`009Woo00<3mGooOol0
<goo00<007ooOol0<goo00<3mGooOol0;Woo000WOol00`?eOomoo`0bOol00`00Oomoo`0bOol00`?e
Oomoo`0_Ool002Qoo`030oEoogoo035oo`03001oogoo035oo`030oEoogoo031oo`00:Goo00<3mGoo
Ool0<7oo0P00<Goo00<3mGooOol0<Goo000ZOol20oD`Ool00`00Oomoo`0_Ool00`?eOomoo`0bOol0
02aoo`030oEoogoo02eoo`03001oogoo02ioo`030oEoogoo03=oo`00;Goo00<3mGooOol06Goo1@00
0Woo0P0017oo0P0017oo00<007ooOol0;Goo00<3mGooOol0=7oo000^Ool20oDKOol00`00Oomoo`07
Ool01000Oomoo`000goo00<007ooOol0:goo0P?e=goo000`Ool00`?eOomoo`0HOol00`00Oomoo`0:
Ool01000Oomoogoo0P00:goo00<3mGooOol0=goo000aOol20oDHOol00`00Oomoo`08Ool20004Ool0
0`00Oomoo`0XOol20oDjOol003=oo`030oEoogoo01Eoo`03001oogoo00Qoo`03001oogoo00=oo`03
001oogoo02Moo`030oEoogoo03Yoo`00=7oo0P?e57oo0P002Woo0`000goo00<007ooOol09Goo0P?e
?Goo000fOol00`?eOomoo`0SOol2000TOol20oDoOol003Moo`83mB=oo`03001oogoo025oo`83mD5o
o`00>Goo0P?e8Goo00<007ooOol087oo00<3mGooOol0@Goo000kOol20oDOOol00`00Oomoo`0NOol2
0oE4Ool003eoo`83mAeoo`8001eoo`83mDIoo`00?goo0`?e6Woo00<007ooOol06Goo0`?eB7oo0012
Ool40oDFOol00`00Oomoo`0EOol40oE;Ool004Ioo`<3mA=oo`03001oogoo019oo`<3mDmoo`00BGoo
10?e3goo00<007ooOol03Woo10?eDWoo001=Ool50oD:Ool2000:Ool50oEFOol0059ooaH3mE]oo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol40003Ool00`00Oomoo`1TOol005Eoo`03001oogoo00Aoo`03001oogoo06Aoo`00EWoo00<0
07ooOol00goo0P00IGoo001GOol00`00Oomoo`1YOol005Eoo`04001oogoo001ZOol005Ioo`8006]o
o`00`goo0033Ool00<=oo`00Lgoo0P000goo10000Woo1@000Woo0P001Goo0`000Woo0P00<7oo001b
Ool01000Oomoo`002Woo00<007ooOol02Woo00@007ooOol0009oo`03001oogoo02eoo`00Fgoo1000
4goo00<007ooOol00goo100017oo00<007ooOol01goo1@0017oo00<007ooOol0;Goo001JOol01000
Oomoo`004goo1@002Woo00<007ooOol01goo00@007ooOol000=oo`80031oo`00FWoo00@007ooOol0
01Aoo`03001oogoo00]oo`03001oogoo00Qoo`03001oo`0000=oo`03001oogoo02moo`00FGoo0P00
00=oo`0000008Goo0P002goo0P000goo0`00;goo0033Ool00<=oo`00`goo0033Ool00<=oo`00\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.4) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .4 r

.5 Mabswid

.05279 .49991 m

.05469 .45874 L

.0604 .41782 L

.06986 .37761 L

.08299 .33845 L

.09967 .30066 L

.11977 .26457 L

.14312 .23049 L

.16951 .19871 L

.19871 .16951 L

.23049 .14312 L

.26457 .11977 L

.30066 .09967 L

.33845 .08299 L

.37761 .06986 L

.41782 .0604 L

.45874 .05469 L

.5 .05279 L

.54126 .05469 L

.58218 .0604 L

.62239 .06986 L

.66155 .08299 L

.69934 .09967 L

.73543 .11977 L

.76951 .14312 L

.80129 .16951 L

.83049 .19871 L

.85688 .23049 L

.88023 .26457 L

.90033 .30066 L

.91701 .33845 L

.93014 .37761 L

.9396 .41782 L

.94531 .45874 L

.94721 .49991 L

s

.05279 .50009 m

.05469 .54126 L

.0604 .58218 L

.06986 .62239 L

.08299 .66155 L

.09967 .69934 L

.11977 .73543 L

.14312 .76951 L

.16951 .80129 L

.19871 .83049 L

.23049 .85688 L

.26457 .88023 L

.30066 .90033 L

.33845 .91701 L

.37761 .93014 L

.41782 .9396 L

.45874 .94531 L

.5 .94721 L

.54126 .94531 L

.58218 .9396 L

.62239 .93014 L

.66155 .91701 L

.69934 .90033 L

.73543 .88023 L

.76951 .85688 L

.80129 .83049 L

.83049 .80129 L

.85688 .76951 L

.88023 .73543 L

.90033 .69934 L

.91701 .66155 L

.93014 .62239 L

.9396 .58218 L

.94531 .54126 L

.94721 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001BOolE0naLOol004eoo`D3k0Yo
o`03001oogoo00Qoo`H3k5Ioo`00BGoo10?/3goo00<007ooOol03Woo0`?/Dgoo0016Ool30n`COol0
0`00Oomoo`0AOol30na@Ool004=oo`<3k1Ioo`8001Eoo`@3k4aoo`00@7oo0`?/6Goo00<007ooOol0
67oo0`?/BGoo000nOol20n`LOol00`00Oomoo`0KOol20na7Ool003aoo`83k1ioo`03001oogoo01eo
o`83k4Eoo`00>Woo0P?/87oo0P0087oo0P?/@goo000hOol20n`ROol00`00Oomoo`0QOol20na1Ool0
03Moo`030naoogoo029oo`03001oogoo02=oo`030naoogoo03ioo`00=Goo0P?/4Woo1@000Woo0P00
17oo0P0017oo00<007ooOol097oo0P?/?Woo000dOol00`?/Oomoo`0DOol00`00Oomoo`07Ool01000
Oomoo`000goo00<007ooOol09Woo00<3k7ooOol0>goo000bOol20n`GOol00`00Oomoo`0:Ool01000
Oomoogoo0P00:7oo0P?/>goo000aOol00`?/Oomoo`0?Ool40004Ool00`00Oomoo`08Ool20004Ool0
0`00Oomoo`0YOol00`?/Oomoo`0hOol002moo`83k1Yoo`03001oogoo00Qoo`03001oogoo00=oo`03
001oogoo02Yoo`83k3Qoo`00;Woo00<3k7ooOol06Goo0P002Woo0`000goo00<007ooOol0;7oo00<3
k7ooOol0=Goo000/Ool20n`^Ool2000^Ool00`?/Oomoo`0dOol002]oo`030naoogoo02ioo`03001o
ogoo02ioo`83k3Aoo`00:Goo0P?/<Goo00<007ooOol0<7oo00<3k7ooOol0<Goo000XOol00`?/Oomo
o`0aOol00`00Oomoo`0aOol00`?/Oomoo`0`Ool002Moo`030naoogoo039oo`8003=oo`030naoogoo
02moo`009Woo00<3k7ooOol0<goo00<007ooOol0<goo00<3k7ooOol0;Woo000UOol00`?/Oomoo`0d
Ool00`00Oomoo`0dOol00`?/Oomoo`0]Ool002Aoo`030naoogoo03Eoo`03001oogoo03Eoo`030nao
ogoo02aoo`008goo00<3k7ooOol0=Woo0P00=goo00<3k7ooOol0:goo000ROol00`?/Oomoo`0gOol0
0`00Oomoo`0gOol00`?/Oomoo`0ZOol0029oo`030naoogoo03Moo`03001oogoo03Qoo`030naoogoo
02Uoo`008Goo00<3k7ooOol0>7oo00<007ooOol0>Goo00<3k7ooOol0:7oo000POol00`?/Oomoo`0i
Ool00`00Oomoo`0iOol00`?/Oomoo`0XOol0021oo`030naoogoo03Uoo`8003]oo`030naoogoo02Mo
o`007goo00<3k7ooOol0>Woo00<007ooOol0>goo00<3k7ooOol09Woo000NOol00`?/Oomoo`0dOol5
0002Ool00`00Oomoo`0lOol00`?/Oomoo`0UOol001ioo`030naoogoo03Ioo`03001oogoo009oo`03
001oogoo03aoo`030naoogoo02Eoo`007Goo00<3k7ooOol0=goo00<007ooOol00Woo0P00?Woo00<3
k7ooOol097oo000LOol00`?/Oomoo`0`Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`0nOol00`?/
Oomoo`0SOol001aoo`030naoogoo03Qoo`03001oogoo009oo`03001oogoo03ioo`030naoogoo02=o
o`006goo00<3k7ooOol0>7oo0P0017oo00<007ooOol0?goo00<3k7ooOol08Woo000JOol00`?/Oomo
o`0oOol20011Ool00`?/Oomoo`0QOol001Yoo`030naoogoo03moo`03001oogoo041oo`030naoogoo
025oo`006Goo00<3k7ooOol0@7oo00<007ooOol0@Goo00<3k7ooOol087oo000HOol00`?/Oomoo`11
Ool00`00Oomoo`11Ool00`?/Oomoo`0POol001Qoo`030naoogoo045oo`03001oogoo049oo`030nao
ogoo01moo`005goo00<3k7ooOol0@Woo0P00@goo00<3k7ooOol07goo000FOol00`?/Oomoo`13Ool0
0`00Oomoo`13Ool00`?/Oomoo`0NOol001Ioo`030naoogoo04=oo`03001oogoo04=oo`030naoogoo
01ioo`005Goo00<3k7ooOol0A7oo00<007ooOol0A7oo00<3k7ooOol07Goo000EOol00`?/Oomoo`14
Ool20015Ool00`?/Oomoo`0MOol001Aoo`030naoogoo04Eoo`03001oogoo04Eoo`030naoogoo01ao
o`0057oo00<3k7ooOol0AGoo00<007ooOol0AGoo00<3k7ooOol077oo000DOol00`?/Oomoo`15Ool0
0`00Oomoo`15Ool00`?/Oomoo`0LOol001=oo`030naoogoo04Ioo`8004Moo`030naoogoo01]oo`00
4goo00<3k7ooOol0AWoo00<007ooOol0AWoo00<3k7ooOol06goo000COol00`?/Oomoo`16Ool00`00
Oomoo`16Ool00`?/Oomoo`0KOol001=oo`030naoogoo03Aoo`8000Aoo`8000Aoo`8000Aoo`03001o
ogoo04Ioo`030naoogoo01]oo`004Woo00<3k7ooOol0=7oo00@007ooOol000Qoo`04001oogoo0003
Ool00`00Oomoo`17Ool00`?/Oomoo`0JOol0019oo`030naoogoo03Aoo`04001oogoo000;Ool01000
Oomoogoo0P00B7oo00<3k7ooOol06Woo000BOol00`?/Oomoo`0^Ool40002Ool01000Oomoo`002Goo
0P0017oo00<007ooOol0Agoo00<3k7ooOol06Woo000BOol00`?/Oomoo`0dOol01000Oomoo`002Goo
00<007ooOol00goo00<007ooOol0B7oo00<3k7ooOol06Goo000BOol00`?/Oomoo`0eOol2000:Ool3
0003Ool00`00Oomoo`18Ool00`?/Oomoo`0IOol0015oo`030naoogoo04Qoo`8004Uoo`030naoogoo
01Uoo`004Goo00<3k7ooOol0B7oo00<007ooOol0B7oo00<3k7ooOol06Goo000AOol00`?/Oomoo`18
Ool00`00Oomoo`19Ool00`?/Oomoo`0HOol0015oo`030naoogoo04Qoo`03001oogoo04Uoo`030nao
ogoo01Qoo`004Goo00<3k7ooOol0B7oo0P00BWoo00<3k7ooOol067oo000AOol00`?/Oomoo`18Ool0
0`00Oomoo`19Ool00`?/Oomoo`0HOol0015oo`030naoogoo04Qoo`03001oogoo04Uoo`030naoogoo
01Qoo`001goo10001Goo00<3k7ooOol017oo1@000Woo0P0017oo0P0037oo1@0037oo0P0017oo0P00
17oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo1@002goo1@000Woo0P0017oo0P00
1Goo00<3k7ooOol01Goo10003Woo0007Ool00`00Oomoo`06Ool00`?/Oomoo`06Ool00`00Oomoo`07
Ool01000Oomoo`003Goo00<007ooOol02goo00@007ooOol000Qoo`04001oogoo000:Ool00`00Oomo
o`0;Ool01000Oomoo`0027oo00@007ooOol000eoo`03001oogoo00eoo`03001oogoo00Moo`04001o
ogoo0004Ool00`?/Oomoo`05Ool00`00Oomoo`0?Ool000Qoo`03001oogoo00Eoo`030naoogoo00Io
o`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`04001oogoo000;Ool00`00Oomoo`08
Ool2000<Ool01000Oomoo`002goo00<007ooOol02goo00<007ooOol03Goo00<007ooOol02Woo00<0
07ooOol00Woo00<3k7ooOol01Woo00<007ooOol03Woo00000goo000000020004Ool00`00Oomoo`04
Ool00`?/000000020004Ool00`00Oomoo`08Ool20006Ool40004Ool00`00Oomoo`05Ool40002Ool0
1000Oomoo`002Goo0P002goo00<007ooOol02goo00@007ooOol000Uoo`8000ioo`03001oogoo00eo
o`03001oogoo00Qoo`8000Eoo`030naoogoo00Moo`03001oogoo00eoo`001goo00@007ooOol000Eo
o`030naoogoo00Ioo`03001oogoo00Qoo`03001oogoo00eoo`03001oogoo00]oo`04001oogoo0009
Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol03Goo00<007ooOol0
3Goo00<007ooOol027oo00<007ooOol017oo00<3k7ooOol01Goo00@007ooOol000ioo`0027oo0P00
1Woo00<3k7ooOol01Goo0P002Woo0`0037oo0P003Woo0P002Woo0`002Woo00<007ooOol037oo0P00
2Woo0`0037oo0P003Woo0P002Woo0`0017oo00<3k7ooOol01Woo0P003goo000@Ool00`?/Oomoo`19
Ool2001;Ool00`?/Oomoo`0GOol000moo`030naoogoo04Yoo`03001oogoo04Yoo`030naoogoo01Mo
o`003goo00<3k7ooOol0BWoo00<007ooOol0BWoo00<3k7ooOol05goo000?Ool00`?/Oomoo`1:Ool0
0`00Oomoo`1:Ool00`?/Oomoo`0=Ool200000goo00000005Ool000Ioo`T000030n`0000009L00003
0n`0000000P000Ioo`03001oo`0000Ioo`001Woo00D007ooOomoo`0000Aoo`050naoogooOol00003
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03
001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007oo
Oomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007oo
Ool00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo
000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02
Ool01@00Oomoo`?/00000goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo000?Ool0
0`?/Oomoo`1:Ool00`00Oomoo`1:Ool00`?/Oomoo`0=Ool200000goo00000005Ool000moo`030nao
ogoo04Yoo`03001oogoo04Yoo`030naoogoo01Moo`0047oo00<3k7ooOol0BGoo0P00Bgoo00<3k7oo
Ool05goo000@Ool00`?/Oomoo`19Ool00`00Oomoo`1:Ool00`?/Oomoo`0GOol0011oo`030naoogoo
04Uoo`03001oogoo04Yoo`030naoogoo01Moo`0047oo00<3k7ooOol0BGoo00<007ooOol0BWoo00<3
k7ooOol05goo000@Ool00`?/Oomoo`19Ool00`00Oomoo`1:Ool00`?/Oomoo`0GOol0011oo`030nao
ogoo04Uoo`8004]oo`030naoogoo01Moo`0047oo00<3k7ooOol0BGoo00<007ooOol0BWoo00<3k7oo
Ool05goo000AOol00`?/Oomoo`18Ool00`00Oomoo`19Ool00`?/Oomoo`0HOol0015oo`030naoogoo
04Qoo`03001oogoo04Uoo`030naoogoo01Qoo`004Goo00<3k7ooOol0B7oo0P00BWoo00<3k7ooOol0
67oo000AOol00`?/Oomoo`18Ool00`00Oomoo`19Ool00`?/Oomoo`0HOol0015oo`030naoogoo04Qo
o`03001oogoo04Uoo`030naoogoo01Qoo`004Goo00<3k7ooOol0B7oo00<007ooOol0B7oo00<3k7oo
Ool06Goo000AOol00`?/Oomoo`18Ool20019Ool00`?/Oomoo`0IOol0019oo`030naoogoo04Moo`03
001oogoo04Qoo`030naoogoo01Uoo`004Woo00<3k7ooOol0Agoo00<007ooOol0B7oo00<3k7ooOol0
6Goo000BOol00`?/Oomoo`0eOol20004Ool20004Ool20004Ool00`00Oomoo`17Ool00`?/Oomoo`0J
Ool0019oo`030naoogoo03Aoo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol0Agoo00<3
k7ooOol06Woo000BOol00`?/Oomoo`0dOol01000Oomoo`002goo00@007ooOomoo`8004Qoo`030nao
ogoo01Yoo`004goo00<3k7ooOol0<goo00@007ooOol000Uoo`8000Aoo`03001oogoo04Ioo`030nao
ogoo01]oo`004goo00<3k7ooOol0<goo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo04Io
o`030naoogoo01]oo`004goo00<3k7ooOol0=7oo0P002Woo0`000goo00<007ooOol0AWoo00<3k7oo
Ool06goo000COol00`?/Oomoo`16Ool20017Ool00`?/Oomoo`0KOol001Aoo`030naoogoo04Eoo`03
001oogoo04Eoo`030naoogoo01aoo`0057oo00<3k7ooOol0AGoo00<007ooOol0AGoo00<3k7ooOol0
77oo000DOol00`?/Oomoo`15Ool00`00Oomoo`15Ool00`?/Oomoo`0LOol001Eoo`030naoogoo04Ao
o`8004Eoo`030naoogoo01eoo`005Goo00<3k7ooOol0A7oo00<007ooOol0A7oo00<3k7ooOol07Goo
000FOol00`?/Oomoo`13Ool00`00Oomoo`13Ool00`?/Oomoo`0NOol001Ioo`030naoogoo04=oo`03
001oogoo04=oo`030naoogoo01ioo`005goo00<3k7ooOol0@Woo00<007ooOol0@Woo00<3k7ooOol0
7goo000GOol00`?/Oomoo`12Ool20013Ool00`?/Oomoo`0OOol001Qoo`030naoogoo045oo`03001o
ogoo045oo`030naoogoo021oo`0067oo00<3k7ooOol0@Goo00<007ooOol0@Goo00<3k7ooOol087oo
000IOol00`?/Oomoo`10Ool00`00Oomoo`10Ool00`?/Oomoo`0QOol001Yoo`030naoogoo03moo`80
045oo`030naoogoo025oo`006Woo00<3k7ooOol0?goo00<007ooOol0?goo00<3k7ooOol08Woo000K
Ool00`?/Oomoo`0gOol50002Ool00`00Oomoo`0oOol00`?/Oomoo`0ROol001aoo`030naoogoo03Qo
o`03001oogoo009oo`03001oogoo03ioo`030naoogoo02=oo`0077oo00<3k7ooOol0>7oo00<007oo
Ool00Woo0P00?goo00<3k7ooOol08goo000MOol00`?/Oomoo`0gOol00`00Oomoo`02Ool00`00Oomo
o`0mOol00`?/Oomoo`0TOol001ioo`030naoogoo03Ioo`03001oogoo009oo`03001oogoo03aoo`03
0naoogoo02Eoo`007Woo00<3k7ooOol0=Goo0P0017oo00<007ooOol0?7oo00<3k7ooOol09Goo000O
Ool00`?/Oomoo`0jOol00`00Oomoo`0kOol00`?/Oomoo`0VOol0021oo`030naoogoo03Uoo`8003]o
o`030naoogoo02Moo`008Goo00<3k7ooOol0>7oo00<007ooOol0>Goo00<3k7ooOol0:7oo000QOol0
0`?/Oomoo`0hOol00`00Oomoo`0hOol00`?/Oomoo`0YOol0029oo`030naoogoo03Moo`03001oogoo
03Moo`030naoogoo02Yoo`008goo00<3k7ooOol0=Woo0P00=goo00<3k7ooOol0:goo000TOol00`?/
Oomoo`0eOol00`00Oomoo`0eOol00`?/Oomoo`0/Ool002Eoo`030naoogoo03Aoo`03001oogoo03Ao
o`030naoogoo02eoo`009Woo00<3k7ooOol0<goo00<007ooOol0<goo00<3k7ooOol0;Woo000WOol0
0`?/Oomoo`0bOol2000cOol00`?/Oomoo`0_Ool002Qoo`030naoogoo035oo`03001oogoo035oo`03
0naoogoo031oo`00:Goo00<3k7ooOol0<7oo00<007ooOol0<7oo00<3k7ooOol0<Goo000ZOol00`?/
Oomoo`0_Ool00`00Oomoo`0_Ool00`?/Oomoo`0bOol002]oo`83k2moo`8002moo`030naoogoo03=o
o`00;Goo00<3k7ooOol0;7oo00<007ooOol0;Goo00<3k7ooOol0=7oo000^Ool00`?/Oomoo`0[Ool0
0`00Oomoo`0/Ool00`?/Oomoo`0eOol002moo`83k1Qoo`D0009oo`8000Aoo`8000Aoo`03001oogoo
02Yoo`83k3Qoo`00<Goo00<3k7ooOol05goo00<007ooOol01goo00@007ooOol000=oo`03001oogoo
02Uoo`030naoogoo03Qoo`00<Woo0P?/5goo00<007ooOol02Woo00@007ooOomoo`8002Qoo`83k3]o
o`00=7oo00<3k7ooOol057oo00<007ooOol027oo0P0017oo00<007ooOol09Woo00<3k7ooOol0>goo
000eOol20n`DOol00`00Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`0TOol20n`nOol003Moo`83
k15oo`8000Yoo`<000=oo`03001oogoo029oo`83k41oo`00>Goo0`?/87oo0P0087oo0`?/@Woo000l
Ool20n`NOol00`00Oomoo`0MOol20na5Ool003ioo`83k1aoo`03001oogoo01]oo`83k4Moo`00@7oo
0`?/6Goo00<007ooOol067oo0`?/BGoo0013Ool30n`FOol2000EOol40na<Ool004Ioo`<3k1=oo`03
001oogoo015oo`<3k51oo`00BGoo10?/3goo00<007ooOol03Woo0`?/Dgoo001=Ool50n`:Ool00`00
Oomoo`09Ool50naFOol0059ooaH3k5]oo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo
10000goo00<007ooOol0I7oo001EOol00`00Oomoo`04Ool00`00Oomoo`1TOol005Ioo`03001oogoo
00=oo`8006Eoo`00Egoo00<007ooOol0JGoo001EOol01000Oomoo`00JWoo001FOol2001[Ool00<=o
o`00`goo0033Ool007Ioo`8000=oo`@0009oo`D0009oo`8000Eoo`<0035oo`00MGoo00@007ooOol0
00Yoo`03001oogoo00Yoo`03001oogoo031oo`00Fgoo10005Woo00<007ooOol00goo100017oo00<0
07ooOol01goo1@00<Goo001JOol01000Oomoo`005Woo1@002Woo00<007ooOol01goo00@007ooOol0
039oo`00FWoo00@007ooOol001Moo`03001oogoo00]oo`03001oogoo00Qoo`03001oo`00039oo`00
FGoo0P0000=oo`00000097oo0P002goo0P00<Woo0033Ool00<=oo`00`goo0033Ool00<=oo`00\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.35) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .1 r

.5 Mabswid

.06339 .49991 m

.06526 .45971 L

.07083 .41977 L

.08006 .38052 L

.09288 .34228 L

.10917 .30539 L

.12879 .27016 L

.15158 .23689 L

.17734 .20586 L

.20586 .17734 L

.23689 .15158 L

.27016 .12879 L

.30539 .10917 L

.34228 .09288 L

.38052 .08006 L

.41977 .07083 L

.45972 .06526 L

.5 .06339 L

.54028 .06526 L

.58023 .07083 L

.61948 .08006 L

.65772 .09288 L

.69461 .10917 L

.72984 .12879 L

.76311 .15158 L

.79414 .17734 L

.82266 .20586 L

.84842 .23689 L

.87121 .27016 L

.89083 .30539 L

.90712 .34228 L

.91994 .38052 L

.92917 .41977 L

.93474 .45971 L

.93661 .49991 L

s

.06339 .50009 m

.06526 .54029 L

.07083 .58023 L

.08006 .61948 L

.09288 .65772 L

.10917 .69461 L

.12879 .72984 L

.15158 .76311 L

.17734 .79414 L

.20586 .82266 L

.23689 .84842 L

.27016 .87121 L

.30539 .89083 L

.34228 .90712 L

.38052 .91994 L

.41977 .92917 L

.45972 .93474 L

.5 .93661 L

.54028 .93474 L

.58023 .92917 L

.61948 .91994 L

.65772 .90712 L

.69461 .89083 L

.72984 .87121 L

.76311 .84842 L

.79414 .82266 L

.82266 .79414 L

.84842 .76311 L

.87121 .72984 L

.89083 .69461 L

.90712 .65772 L

.91994 .61948 L

.92917 .58023 L

.93474 .54029 L

.93661 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006UooaH3hWAoo`00IGoo10?R
2goo00<007ooOol027oo10?RL7oo001QOol40n8?Ool00`00Oomoo`0<Ool40n9/Ool005eoo`@3hQ=o
o`03001oogoo011oo`@3hVQoo`00FGoo10?R5goo00<007ooOol057oo1@?RHgoo001EOol40n8KOol0
0`00Oomoo`0IOol40n9OOol0059oo`<3hQmoo`03001oogoo01eoo`<3hUaoo`00D7oo0P?R8Woo00<0
07ooOol087oo0P?RFWoo001>Ool20n8TOol00`00Oomoo`0ROol20n9HOol004aoo`83hRIoo`03001o
ogoo02Aoo`83hUIoo`00BWoo0P?R3goo1@0017oo0P001Goo10001Goo00<007ooOol09Woo0P?RE7oo
0018Ool20n8COol00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`0XOol20n9BOol004Ioo`83hQEoo`03001oogoo00moo`03001oogoo009oo`03001oogoo02Yoo`83
hU1oo`00A7oo0P?R37oo1P001Goo00<007ooOol03goo00<007ooOol00Woo0P00;Goo0P?RCWoo0012
Ool20n8IOol00`00Oomoo`0;Ool40005Ool00`00Oomoo`0^Ool00`?ROomoo`1;Ool0041oo`83hQ]o
o`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo02moo`83hT]oo`00?goo00<3hWooOol06Goo
0`003Goo00<007ooOol01Woo00<007ooOol0<Goo00<3hWooOol0B7oo000nOol00`?ROomoo`0LOol0
0`00Oomoo`0;Ool50004Ool00`00Oomoo`0bOol00`?ROomoo`17Ool003aoo`83hSIoo`03001oogoo
03=oo`83hTMoo`00>goo00<3hWooOol0=Woo00<007ooOol0=Goo00<3hWooOol0A7oo000jOol00`?R
Oomoo`0gOol00`00Oomoo`0fOol00`?ROomoo`13Ool003Uoo`030n9oogoo03Qoo`03001oogoo03Mo
o`030n9oogoo049oo`00=goo0P?R>goo00<007ooOol0>7oo0P?R@Woo000fOol00`?ROomoo`0kOol0
0`00Oomoo`0jOol00`?ROomoo`0oOol003Eoo`030n9oogoo03aoo`03001oogoo03]oo`030n9oogoo
03ioo`00=7oo00<3hWooOol0?Goo00<007ooOol0?7oo00<3hWooOol0?Goo000cOol00`?ROomoo`0n
Ool00`00Oomoo`0mOol00`?ROomoo`0lOol0039oo`030n9oogoo03moo`03001oogoo03ioo`030n9o
ogoo03]oo`00<Goo00<3hWooOol0@7oo00<007ooOol0?goo00<3hWooOol0>Woo000`Ool00`?ROomo
o`11Ool00`00Oomoo`10Ool00`?ROomoo`0iOol002moo`030n9oogoo049oo`03001oogoo045oo`03
0n9oogoo03Qoo`00;Woo00<3hWooOol0@goo00<007ooOol0@Woo00<3hWooOol0=goo000]Ool00`?R
Oomoo`14Ool00`00Oomoo`13Ool00`?ROomoo`0fOol002aoo`030n9oogoo04Eoo`03001oogoo04Ao
o`030n9oogoo03Eoo`00:goo00<3hWooOol0AWoo00<007ooOol0AGoo00<3hWooOol0=7oo000[Ool0
0`?ROomoo`16Ool00`00Oomoo`16Ool00`?ROomoo`0cOol002Yoo`030n9oogoo04Moo`03001oogoo
04Moo`030n9oogoo039oo`00:Goo00<3hWooOol0?goo1@0017oo00<007ooOol0B7oo00<3hWooOol0
<Goo000XOol00`?ROomoo`12Ool00`00Oomoo`04Ool00`00Oomoo`19Ool00`?ROomoo`0`Ool002Qo
o`030n9oogoo049oo`03001oogoo00Aoo`03001oogoo04Uoo`030n9oogoo031oo`009goo00<3hWoo
Ool0>7oo1P001Goo00<007ooOol017oo0P00Bgoo00<3hWooOol0;goo000VOol00`?ROomoo`14Ool0
0`00Oomoo`04Ool00`00Oomoo`1;Ool00`?ROomoo`0^Ool002Ioo`030n9oogoo04Aoo`03001oogoo
00Aoo`03001oogoo04]oo`030n9oogoo02ioo`009Goo00<3hWooOol0@goo0`001Woo00<007ooOol0
C7oo00<3hWooOol0;Goo000UOol00`?ROomoo`15Ool00`00Oomoo`04Ool00`00Oomoo`1<Ool00`?R
Oomoo`0]Ool002Aoo`030n9oogoo04eoo`03001oogoo04eoo`030n9oogoo02aoo`008goo00<3hWoo
Ool0CWoo00<007ooOol0CWoo00<3hWooOol0:goo000SOol00`?ROomoo`1>Ool00`00Oomoo`1>Ool0
0`?ROomoo`0[Ool0029oo`030n9oogoo04moo`03001oogoo04moo`030n9oogoo02Yoo`008Goo00<3
hWooOol0D7oo00<007ooOol0Cgoo00<3hWooOol0:Woo000POol00`?ROomoo`1AOol00`00Oomoo`1@
Ool00`?ROomoo`0YOol0021oo`030n9oogoo055oo`03001oogoo051oo`030n9oogoo02Uoo`007goo
00<3hWooOol0DWoo00<007ooOol0DGoo00<3hWooOol0:7oo000OOol00`?ROomoo`1BOol00`00Oomo
o`1AOol00`?ROomoo`0XOol001ioo`030n9oogoo05=oo`03001oogoo059oo`030n9oogoo02Moo`00
7Woo00<3hWooOol0Dgoo00<007ooOol0DWoo00<3hWooOol09goo000MOol00`?ROomoo`1DOol00`00
Oomoo`1COol00`?ROomoo`0VOol001eoo`030n9oogoo05Aoo`03001oogoo05=oo`030n9oogoo02Io
o`007Goo00<3hWooOol0E7oo00<007ooOol0Dgoo00<3hWooOol09Woo000LOol00`?ROomoo`1EOol0
0`00Oomoo`1DOol00`?ROomoo`0UOol001aoo`030n9oogoo05Eoo`03001oogoo05Aoo`030n9oogoo
02Eoo`0077oo00<3hWooOol0EGoo00<007ooOol0E7oo00<3hWooOol09Goo000KOol00`?ROomoo`1F
Ool00`00Oomoo`1EOol00`?ROomoo`0TOol001]oo`030n9oogoo05Ioo`03001oogoo05Eoo`030n9o
ogoo02Aoo`006Woo00<3hWooOol0?Woo10001Goo0P001Goo10001Goo00<007ooOol0EWoo00<3hWoo
Ool08goo000JOol00`?ROomoo`0mOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`1FOol00`?ROomoo`0SOol001Yoo`030n9oogoo03eoo`03
001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo05Ioo`030n9oogoo02=oo`00
6Goo00<3hWooOol0=Woo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00Woo0P00
F7oo00<3hWooOol08Woo000IOol00`?ROomoo`0nOol00`00Oomoo`02Ool00`00Oomoo`09Ool40005
Ool00`00Oomoo`1GOol00`?ROomoo`0ROol001Uoo`030n9oogoo03ioo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo00Ioo`03001oogoo05Moo`030n9oogoo029oo`006Goo00<3hWooOol0?Woo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0Egoo00<3hWooOol08Woo
000HOol00`?ROomoo`10Ool4000<Ool50004Ool00`00Oomoo`1HOol00`?ROomoo`0QOol001Qoo`03
0n9oogoo05Uoo`03001oogoo05Qoo`030n9oogoo025oo`0067oo00<3hWooOol0FGoo00<007ooOol0
F7oo00<3hWooOol08Goo000HOol00`?ROomoo`1IOol00`00Oomoo`1HOol00`?ROomoo`0QOol001Mo
o`030n9oogoo05Yoo`03001oogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<007oo
Ool0FGoo00<3hWooOol087oo000GOol00`?ROomoo`1JOol00`00Oomoo`1IOol00`?ROomoo`0POol0
01Moo`030n9oogoo05Yoo`03001oogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<0
07ooOol0FGoo00<3hWooOol087oo0009Ool50009Ool00`?ROomoo`03Ool50004Ool20005Ool4000?
Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4000?Ool5000>
Ool50004Ool20005Ool400000goo0n9oo`0;Ool5000AOol000Uoo`05001oogooOol00009Ool00`?R
Oomoo`05Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0>
Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`000n9oo`0;Ool01@00
Oomoogoo00004Goo000:Ool00`00Oomoo`09Ool00`?ROomoo`06Ool00`00Oomoo`0?Ool00`00Oomo
o`0>Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomo
o`0?Ool00`00Ool3hP0<Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`80
00040n8000000005Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool60005Ool00`00Oomoo`05Ool60002
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0?Ool00`00Ool3hP0=
Ool00`00Oomoo`0AOol000aoo`03001oogoo00Moo`030n9oogoo00Ioo`03001oogoo00]oo`@0015o
o`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@000eoo`03001oogoo00eoo`03001o
ogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo011oo`03001oogoo00]oo`@0009oo`030n9o
ogoo00aoo`03001oogoo011oo`003Goo00<007ooOol01Woo00<3hWooOol01Woo00<007ooOol02goo
00<007ooOol04Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007ooOol047oo
00<007ooOol02goo00<007ooOol00goo00<3hWooOol03Goo00<007ooOol03goo0009Ool01@00Oomo
ogoo000027oo00<3hWooOol017oo0`003Goo00<007ooOol047oo0`003goo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<0
07ooOol047oo0`0047oo0`003Goo00<007ooOol00goo00<3hWooOol02Goo00D007ooOomoo`00015o
o`002Woo0`002Goo00<3hWooOol01Woo00<007ooOol02goo1@0047oo00<007ooOol03Woo100037oo
1@0037oo00<007ooOol03Woo100037oo1@0047oo00<007ooOol047oo00<007ooOol02goo1@0000=o
o`?ROol02goo0`004Woo000FOol00`?ROomoo`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Io
o`030n9oogoo05]oo`03001oogoo05Yoo`030n9oogoo01moo`005Woo00<3hWooOol0Fgoo00<007oo
Ool0Fgoo00<3hWooOol07Woo000FOol00`?ROomoo`1KOol00`00Oomoo`1KOol00`?ROomoo`0NOol0
01Ioo`030n9oogoo05]oo`03001oogoo05]oo`030n9oogoo01=oo`80009oo`8000Eoo`005Woo00<3
hWooOol0Fgoo00<007ooOol0Fgoo00<3hWooOol057oo00@007ooOol000Ioo`0027oo3P0000<3hP00
0000^@0000<3hP00000030002Goo0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01P00
Oomoo`?ROol000Aoo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`04001oogoo0n82
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`07Ool20007Ool000Qoo`03001oogoo00]o
o`030n9oogoo00Yoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qo
o`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo00Yoo`030n9oogoo00]oo`03001oogoo00Io
o`04001oogoo0006Ool001Ioo`030n9oogoo05]oo`03001oogoo05]oo`030n9oogoo01=oo`80009o
o`8000Eoo`005Woo00<3hWooOol0Fgoo00<007ooOol0Fgoo00<3hWooOol07Woo000FOol00`?ROomo
o`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Ioo`030n9oogoo05]oo`03001oogoo05Yoo`03
0n9oogoo01moo`005Woo00<3hWooOol0Fgoo00<007ooOol0FWoo00<3hWooOol07goo000FOol00`?R
Oomoo`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Ioo`030n9oogoo05]oo`03001oogoo05Yo
o`030n9oogoo01moo`005Woo00<3hWooOol0Fgoo00<007ooOol0FWoo00<3hWooOol07goo000FOol0
0`?ROomoo`1KOol00`00Oomoo`1JOol00`?ROomoo`0OOol001Ioo`030n9oogoo05]oo`03001oogoo
05Yoo`030n9oogoo01moo`005goo00<3hWooOol0FWoo00<007ooOol0FGoo00<3hWooOol087oo000G
Ool00`?ROomoo`1JOol00`00Oomoo`1IOol00`?ROomoo`0POol001Moo`030n9oogoo05Yoo`03001o
ogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<007ooOol0FGoo00<3hWooOol087oo
000GOol00`?ROomoo`1JOol00`00Oomoo`1IOol00`?ROomoo`0POol001Moo`030n9oogoo05Yoo`03
001oogoo05Uoo`030n9oogoo021oo`005goo00<3hWooOol0FWoo00<007ooOol0FGoo00<3hWooOol0
87oo000HOol00`?ROomoo`1IOol00`00Oomoo`1HOol00`?ROomoo`0QOol001Qoo`030n9oogoo05Uo
o`03001oogoo05Qoo`030n9oogoo025oo`0067oo00<3hWooOol0FGoo00<007ooOol0F7oo00<3hWoo
Ool08Goo000HOol00`?ROomoo`1IOol00`00Oomoo`1HOol00`?ROomoo`0QOol001Uoo`030n9oogoo
03moo`@000Eoo`8000Eoo`@000Eoo`03001oogoo05Moo`030n9oogoo029oo`006Goo00<3hWooOol0
?Woo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol0Egoo00<3hWooOol08Woo000IOol00`?ROomoo`0nOol00`00Oomoo`02Ool00`00Oomoo`0=
Ool00`00Oomoo`02Ool00`00Oomoo`1GOol00`?ROomoo`0ROol001Uoo`030n9oogoo03ioo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo009oo`8005Qoo`030n9oogoo029oo`006Woo00<3hWoo
Ool0?Goo00<007ooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol0EWoo00<3hWooOol08goo
000JOol00`?ROomoo`0mOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomo
o`1FOol00`?ROomoo`0SOol001]oo`030n9oogoo03aoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Ioo`03001oogoo05Eoo`030n9oogoo02Aoo`006goo00<3hWooOol0?Goo100037oo1@00
17oo00<007ooOol0EGoo00<3hWooOol097oo000KOol00`?ROomoo`1FOol00`00Oomoo`1EOol00`?R
Oomoo`0TOol001aoo`030n9oogoo05Eoo`03001oogoo05Aoo`030n9oogoo02Eoo`0077oo00<3hWoo
Ool0EGoo00<007ooOol0E7oo00<3hWooOol09Goo000LOol00`?ROomoo`1EOol00`00Oomoo`1DOol0
0`?ROomoo`0UOol001eoo`030n9oogoo05Aoo`03001oogoo05=oo`030n9oogoo02Ioo`007Goo00<3
hWooOol0E7oo00<007ooOol0Dgoo00<3hWooOol09Woo000NOol00`?ROomoo`1COol00`00Oomoo`1B
Ool00`?ROomoo`0WOol001ioo`030n9oogoo05=oo`03001oogoo059oo`030n9oogoo02Moo`007Woo
00<3hWooOol0Dgoo00<007ooOol0DWoo00<3hWooOol09goo000OOol00`?ROomoo`1BOol00`00Oomo
o`1AOol00`?ROomoo`0XOol001moo`030n9oogoo059oo`03001oogoo055oo`030n9oogoo02Qoo`00
87oo00<3hWooOol0DGoo00<007ooOol0D7oo00<3hWooOol0:Goo000POol00`?ROomoo`1AOol00`00
Oomoo`1@Ool00`?ROomoo`0YOol0025oo`030n9oogoo051oo`03001oogoo04moo`030n9oogoo02Yo
o`008Woo00<3hWooOol0Cgoo00<007ooOol0Cgoo00<3hWooOol0:Woo000ROol00`?ROomoo`1?Ool0
0`00Oomoo`1>Ool00`?ROomoo`0[Ool002=oo`030n9oogoo04ioo`03001oogoo04ioo`030n9oogoo
02]oo`008goo00<3hWooOol0CWoo00<007ooOol0CGoo00<3hWooOol0;7oo000TOol00`?ROomoo`1=
Ool00`00Oomoo`1=Ool00`?ROomoo`0/Ool002Eoo`030n9oogoo04=oo`D000Aoo`03001oogoo04ao
o`030n9oogoo02eoo`009Goo00<3hWooOol0AGoo00<007ooOol017oo00<007ooOol0C7oo00<3hWoo
Ool0;Goo000VOol00`?ROomoo`14Ool00`00Oomoo`04Ool00`00Oomoo`1;Ool00`?ROomoo`0^Ool0
02Moo`030n9oogoo04=oo`03001oogoo00Aoo`8004]oo`030n9oogoo02moo`00:7oo00<3hWooOol0
@Woo00<007ooOol017oo00<007ooOol0BGoo00<3hWooOol0<7oo000XOol00`?ROomoo`12Ool00`00
Oomoo`04Ool00`00Oomoo`19Ool00`?ROomoo`0`Ool002Uoo`030n9oogoo03moo`<000Ioo`03001o
ogoo04Qoo`030n9oogoo035oo`00:Woo00<3hWooOol0@7oo00<007ooOol017oo00<007ooOol0Agoo
00<3hWooOol0<Woo000ZOol00`?ROomoo`17Ool00`00Oomoo`16Ool00`?ROomoo`0cOol002]oo`03
0n9oogoo04Ioo`03001oogoo04Eoo`030n9oogoo03Aoo`00;7oo00<3hWooOol0AGoo00<007ooOol0
AGoo00<3hWooOol0=7oo000]Ool00`?ROomoo`14Ool00`00Oomoo`14Ool00`?ROomoo`0eOol002eo
o`030n9oogoo04Aoo`03001oogoo04=oo`030n9oogoo03Ioo`00;Woo00<3hWooOol0@goo00<007oo
Ool0@Woo00<3hWooOol0=goo000_Ool00`?ROomoo`12Ool00`00Oomoo`11Ool00`?ROomoo`0hOol0
031oo`030n9oogoo045oo`03001oogoo041oo`030n9oogoo03Uoo`00<Goo00<3hWooOol0@7oo00<0
07ooOol0?goo00<3hWooOol0>Woo000bOol00`?ROomoo`0oOol00`00Oomoo`0nOol00`?ROomoo`0k
Ool003=oo`030n9oogoo03ioo`03001oogoo03eoo`030n9oogoo03aoo`00=7oo00<3hWooOol0?Goo
00<007ooOol0?7oo00<3hWooOol0?Goo000eOol20n8mOol00`00Oomoo`0jOol20n90Ool003Moo`03
0n9oogoo03Yoo`03001oogoo03Uoo`030n9oogoo041oo`00>7oo00<3hWooOol0>Goo00<007ooOol0
>7oo00<3hWooOol0@Goo000iOol20n8iOol00`00Oomoo`0fOol20n94Ool003]oo`030n9oogoo03Io
o`03001oogoo03Eoo`030n9oogoo04Aoo`00?7oo0P?R=Woo00<007ooOol0<goo0P?RAgoo000nOol0
0`?ROomoo`0cOol00`00Oomoo`0bOol00`?ROomoo`17Ool003moo`030n9oogoo01Uoo`D000Aoo`80
00Eoo`@000Eoo`03001oogoo035oo`030n9oogoo04Qoo`00@7oo0P?R6goo00<007ooOol017oo0P00
17oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0;goo0P?RBgoo0012Ool00`?ROomoo`0H
Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomoo`0^Ool00`?ROomoo`1;Ool004=oo`83hQQo
o`03001oogoo00moo`03001oogoo009oo`8002eoo`83hTioo`00AGoo0P?R5Woo00<007ooOol02goo
10001Goo00<007ooOol0:Woo0P?RD7oo0017Ool20n8DOol00`00Oomoo`0;Ool00`00Oomoo`06Ool0
0`00Oomoo`0XOol20n9BOol004Uoo`83hQ1oo`<000eoo`03001oogoo00Ioo`03001oogoo02Moo`03
0n9oogoo059oo`00Bgoo0P?R47oo00<007ooOol02goo1@0017oo00<007ooOol09Goo0P?REGoo001=
Ool20n8UOol00`00Oomoo`0SOol20n9GOol004moo`83hR=oo`03001oogoo025oo`83hUUoo`00DGoo
0`?R87oo00<007ooOol07Woo0`?RFgoo001DOol20n8NOol00`00Oomoo`0KOol30n9NOol005Ioo`<3
hQ]oo`03001oogoo01Qoo`<3hV5oo`00FGoo0`?R67oo00<007ooOol05Goo0`?RI7oo001LOol40n8D
Ool00`00Oomoo`0AOol40n9WOol0061oo`L3hPeoo`03001oogoo00Yoo`L3hV]oo`00Igoo6P?RLWoo
001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol006Yoo`D000Eo
o`03001oogoo07aoo`00JWoo00D007ooOomoo`0000Eoo`03001oogoo07aoo`00Jgoo00<007ooOol0
1Woo00<007ooOol0O7oo001/Ool00`00Oomoo`05Ool2001mOol006eoo`03001oogoo08=oo`00KWoo
00<007ooOol0PWoo001ZOol01@00Oomoogoo0000Q7oo001[Ool30025Ool00?=oo`00lgoo003cOol0
0?=oo`00TGoo0`002goo1@0017oo0P001Goo0`001Goo1000>7oo002@Ool01P00Oomoogoo001oo`H0
00Eoo`03001oogoo00Aoo`8000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool00`00Oomoo`0e
Ool007=oo`800003Ool0000001Qoo`03001oogoo00ioo`03001oogoo00ioo`03001oogoo00Ioo`03
001oogoo03Eoo`00LWoo00<007ooOol00P006Goo00<007ooOol00goo1P001Goo00<007ooOol03Woo
00<007ooOol01Woo00<007ooOol0=Goo001bOol01@00Oomoogoo00006Goo00<007ooOol03Woo00<0
07ooOol037oo0P001Goo1000>7oo001bOol01@00Oomoogoo000067oo1@003Goo00<007ooOol03Woo
00<007ooOol00Woo00<007ooOol0>Goo001bOol01@00Oomoogoo00006Goo00<007ooOol037oo0`00
37oo00D007ooOomoo`0000Aoo`03001oogoo03Uoo`00LGoo0P000Woo0P00:Woo00<007ooOol02goo
0`001Goo1@00=goo003cOol00?=oo`00lgoo003cOol00?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.3) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.2 1 0 r

.5 Mabswid

.07427 .49991 m

.07608 .46072 L

.08151 .42177 L

.09052 .38349 L

.10301 .34621 L

.1189 .31023 L

.13803 .27588 L

.16026 .24344 L

.18538 .21318 L

.21318 .18538 L

.24344 .16026 L

.27588 .13803 L

.31023 .1189 L

.34621 .10301 L

.38349 .09052 L

.42177 .08151 L

.46072 .07608 L

.5 .07427 L

.53928 .07608 L

.57823 .08151 L

.61651 .09052 L

.65379 .10301 L

.68977 .1189 L

.72412 .13803 L

.75656 .16026 L

.78682 .18538 L

.81462 .21318 L

.83974 .24344 L

.86197 .27588 L

.8811 .31023 L

.89699 .34621 L

.90948 .38349 L

.91849 .42177 L

.92392 .46072 L

.92573 .49991 L

s

.07427 .50009 m

.07608 .53928 L

.08151 .57823 L

.09052 .61651 L

.10301 .65379 L

.1189 .68977 L

.13803 .72412 L

.16026 .75656 L

.18538 .78682 L

.21318 .81462 L

.24344 .83974 L

.27588 .86197 L

.31023 .8811 L

.34621 .89699 L

.38349 .90948 L

.42177 .91849 L

.46072 .92392 L

.5 .92573 L

.53928 .92392 L

.57823 .91849 L

.61651 .90948 L

.65379 .89699 L

.68977 .8811 L

.72412 .86197 L

.75656 .83974 L

.78682 .81462 L

.81462 .78682 L

.83974 .75656 L

.86197 .72412 L

.8811 .68977 L

.89699 .65379 L

.90948 .61651 L

.91849 .57823 L

.92392 .53928 L

.92573 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005=ooa@Gh5aoo`00CWoo1AOP
2Goo00<007ooOol027oo1AOPEgoo001:Ool45n0>Ool00`00Oomoo`0=Ool35n1DOol004Moo`<Gh19o
o`03001oogoo011oo`<Gh55oo`00A7oo0aOP5Goo0P0057oo11OPCGoo0011Ool35n0HOol00`00Oomo
o`0GOol35n1:Ool003ioo`<Gh1]oo`03001oogoo01Yoo`<Gh4Moo`00?7oo0QOP2goo1@000Woo0P00
17oo0P0017oo00<007ooOol07Goo0QOPAGoo000jOol25n0?Ool00`00Oomoo`07Ool01000Oomoo`00
0goo00<007ooOol07goo0QOP@goo000iOol00aOPOomoo`0?Ool00`00Oomoo`0:Ool01000Oomoogoo
0P008Woo00<Gh7ooOol0@7oo000gOol25n0:Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomo
o`0ROol25n10Ool003Ioo`035n1oogoo019oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo
02Aoo`035n1oogoo03eoo`00=7oo0QOP57oo0P002Woo0`000goo00<007ooOol09Goo0QOP?Goo000c
Ool00aOPOomoo`0VOol2000XOol00aOPOomoo`0jOol0035oo`8Gh2Uoo`03001oogoo02Qoo`8Gh3Yo
o`00<7oo00<Gh7ooOol0:Goo00<007ooOol0:Woo00<Gh7ooOol0=goo000_Ool00aOPOomoo`0ZOol0
0`00Oomoo`0[Ool00aOPOomoo`0fOol002eoo`8Gh2eoo`8002eoo`8Gh3Ioo`00;7oo00<Gh7ooOol0
;Goo00<007ooOol0;Woo00<Gh7ooOol0<goo000[Ool00aOPOomoo`0^Ool00`00Oomoo`0_Ool00aOP
Oomoo`0bOol002Yoo`035n1oogoo02moo`03001oogoo031oo`035n1oogoo035oo`00:Goo00<Gh7oo
Ool0<7oo0P00<Woo00<Gh7ooOol0<7oo000XOol00aOPOomoo`0aOol00`00Oomoo`0bOol00aOPOomo
o`0_Ool002Moo`035n1oogoo039oo`03001oogoo03=oo`035n1oogoo02ioo`009Woo00<Gh7ooOol0
<goo00<007ooOol0=7oo00<Gh7ooOol0;Goo000UOol00aOPOomoo`0dOol00`00Oomoo`0eOol00aOP
Oomoo`0/Ool002Aoo`035n1oogoo03Eoo`8003Moo`035n1oogoo02]oo`0097oo00<Gh7ooOol0=Goo
00<007ooOol0=Woo00<Gh7ooOol0:goo000SOol00aOPOomoo`0_Ool50002Ool00`00Oomoo`0gOol0
0aOPOomoo`0ZOol0029oo`035n1oogoo039oo`03001oogoo009oo`03001oogoo03Qoo`035n1oogoo
02Uoo`008Goo00<Gh7ooOol0<goo00<007ooOol00Woo0P00>Woo00<Gh7ooOol0:7oo000QOol00aOP
Oomoo`0[Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00aOPOomoo`0XOol0021oo`035n1o
ogoo03Aoo`03001oogoo009oo`03001oogoo03Yoo`035n1oogoo02Moo`007goo00<Gh7ooOol0=7oo
0P0017oo00<007ooOol0>goo00<Gh7ooOol09Woo000OOol00aOPOomoo`0jOol2000lOol00aOPOomo
o`0VOol001ioo`035n1oogoo03]oo`03001oogoo03aoo`035n1oogoo02Eoo`007Goo00<Gh7ooOol0
?7oo00<007ooOol0?Goo00<Gh7ooOol097oo000MOol00aOPOomoo`0lOol00`00Oomoo`0mOol00aOP
Oomoo`0TOol001aoo`035n1oogoo03eoo`03001oogoo03ioo`035n1oogoo02=oo`0077oo00<Gh7oo
Ool0?Goo0P00?goo00<Gh7ooOol08goo000KOol00aOPOomoo`0nOol00`00Oomoo`0oOol00aOPOomo
o`0ROol001]oo`035n1oogoo03ioo`03001oogoo03moo`035n1oogoo029oo`006Woo00<Gh7ooOol0
?goo00<007ooOol0@7oo00<Gh7ooOol08Goo000JOol00aOPOomoo`0oOol20011Ool00aOPOomoo`0Q
Ool001Uoo`035n1oogoo041oo`03001oogoo045oo`035n1oogoo021oo`006Goo00<Gh7ooOol0@7oo
00<007ooOol0@Goo00<Gh7ooOol087oo000HOol00aOPOomoo`11Ool00`00Oomoo`12Ool00aOPOomo
o`0OOol001Qoo`035n1oogoo045oo`8004=oo`035n1oogoo01moo`0067oo00<Gh7ooOol0@Goo00<0
07ooOol0@Woo00<Gh7ooOol07goo000GOol00aOPOomoo`12Ool00`00Oomoo`13Ool00aOPOomoo`0N
Ool001Moo`035n1oogoo031oo`8000Aoo`8000Aoo`8000Aoo`03001oogoo04=oo`035n1oogoo01io
o`005goo00<Gh7ooOol0;goo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`13Ool00aOP
Oomoo`0NOol001Ioo`035n1oogoo031oo`04001oogoo000;Ool01000Oomoogoo0P00AGoo00<Gh7oo
Ool07Goo000FOol00aOPOomoo`0ZOol40002Ool01000Oomoo`002Goo0P0017oo00<007ooOol0A7oo
00<Gh7ooOol07Goo000FOol00aOPOomoo`0`Ool01000Oomoo`002Goo00<007ooOol00goo00<007oo
Ool0A7oo00<Gh7ooOol07Goo000EOol00aOPOomoo`0bOol2000:Ool30003Ool00`00Oomoo`14Ool0
0aOPOomoo`0MOol001Eoo`035n1oogoo04Aoo`8004Eoo`035n1oogoo01eoo`005Goo00<Gh7ooOol0
A7oo00<007ooOol0AGoo00<Gh7ooOol077oo000EOol00aOPOomoo`14Ool00`00Oomoo`15Ool00aOP
Oomoo`0LOol001Aoo`035n1oogoo04Eoo`03001oogoo04Eoo`035n1oogoo01aoo`0057oo00<Gh7oo
Ool0AGoo0P00AWoo00<Gh7ooOol077oo000DOol00aOPOomoo`15Ool00`00Oomoo`15Ool00aOPOomo
o`0LOol001Aoo`035n1oogoo04Eoo`03001oogoo04Eoo`035n1oogoo01aoo`001goo100027oo00@G
h7ooOomoo`D0009oo`8000Aoo`8000aoo`D000aoo`8000Aoo`8000Aoo`8000]oo`03001oogoo00ao
o`8000Aoo`8000Aoo`8000aoo`D000]oo`D0009oo`8000Aoo`800003OolGh7oo00Yoo`@000ioo`00
1goo00<007ooOol02Goo00<Gh7ooOol00goo00<007ooOol01goo00@007ooOol000eoo`03001oogoo
00]oo`04001oogoo0008Ool01000Oomoo`002Woo00<007ooOol02goo00@007ooOol000Qoo`04001o
ogoo000=Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool01@00Oomoo`005n002goo00<007ooOol03goo
0008Ool00`00Oomoo`08Ool00aOPOomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomo
o`0;Ool01000Oomoo`002goo00<007ooOol027oo0P0037oo00@007ooOol000]oo`03001oogoo00]o
o`03001oogoo00eoo`03001oogoo00Yoo`03000Gh7oo00]oo`03001oogoo00ioo`0000=oo`000000
0P0017oo00<007ooOol01Goo0P0000<Gh000Ool00goo00<007ooOol027oo0P001Woo100017oo00<0
07ooOol01Goo10000Woo00@007ooOol000Uoo`8000]oo`03001oogoo00]oo`04001oogoo0009Ool2
000>Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool200000goo5n1oo`0<Ool00`00Oomoo`0=Ool000Mo
o`04001oogoo0008Ool00aOPOomoo`03Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool00`00Oomoo`0;
Ool01000Oomoo`002Goo00<007ooOol02Woo00<007ooOol02goo00@007ooOol000Uoo`03001oogoo
00eoo`03001oogoo00eoo`03001oogoo00Qoo`04001oogoo5n0;Ool01000Oomoo`003Woo0008Ool2
0009Ool00aOPOomoo`02Ool2000:Ool3000<Ool2000>Ool2000:Ool3000:Ool00`00Oomoo`0<Ool2
000:Ool3000<Ool2000>Ool2000:Ool300000aOPOomoo`0:Ool2000?Ool001=oo`035n1oogoo04Io
o`8004Moo`035n1oogoo01]oo`004goo00<Gh7ooOol0AWoo00<007ooOol0Agoo00<Gh7ooOol06Woo
000COol00aOPOomoo`16Ool00`00Oomoo`17Ool00aOPOomoo`0JOol001=oo`035n1oogoo04Ioo`03
001oogoo04Moo`035n1oogoo011oo`800003Ool0000000Eoo`001Woo3@0000<Gh0000000T00000<G
h00000002`001Woo00<007oo00001Woo0006Ool01@00Oomoogoo000017oo00D007ooOomooaOP00=o
o`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<0
07ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomo
ogoo000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomo
o`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`05001oogooOol0
0004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009o
o`055n1oogooOol00003Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`05Ool001=oo`03
5n1oogoo04Ioo`03001oogoo04Moo`035n1oogoo011oo`800003Ool0000000Eoo`004goo00<Gh7oo
Ool0AWoo00<007ooOol0Agoo00<Gh7ooOol06Woo000COol00aOPOomoo`16Ool20017Ool00aOPOomo
o`0KOol001=oo`035n1oogoo04Ioo`03001oogoo04Ioo`035n1oogoo01]oo`004goo00<Gh7ooOol0
AWoo00<007ooOol0AWoo00<Gh7ooOol06goo000COol00aOPOomoo`16Ool00`00Oomoo`16Ool00aOP
Oomoo`0KOol001=oo`035n1oogoo04Ioo`03001oogoo04Ioo`035n1oogoo01]oo`004goo00<Gh7oo
Ool0AWoo0P00Agoo00<Gh7ooOol06goo000COol00aOPOomoo`16Ool00`00Oomoo`16Ool00aOPOomo
o`0KOol001Aoo`035n1oogoo04Eoo`03001oogoo04Eoo`035n1oogoo01aoo`0057oo00<Gh7ooOol0
AGoo00<007ooOol0AGoo00<Gh7ooOol077oo000DOol00aOPOomoo`15Ool20016Ool00aOPOomoo`0L
Ool001Aoo`035n1oogoo04Eoo`03001oogoo04Eoo`035n1oogoo01aoo`0057oo00<Gh7ooOol0AGoo
00<007ooOol0AGoo00<Gh7ooOol077oo000EOol00aOPOomoo`14Ool00`00Oomoo`15Ool00aOPOomo
o`0LOol001Eoo`035n1oogoo04Aoo`8004Eoo`035n1oogoo01eoo`005Goo00<Gh7ooOol0A7oo00<0
07ooOol0A7oo00<Gh7ooOol07Goo000FOol00aOPOomoo`13Ool00`00Oomoo`14Ool00aOPOomoo`0M
Ool001Ioo`035n1oogoo035oo`8000Aoo`8000Aoo`8000Aoo`03001oogoo04Aoo`035n1oogoo01eo
o`005Woo00<Gh7ooOol0<7oo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`14Ool00aOP
Oomoo`0MOol001Moo`035n1oogoo02moo`04001oogoo000;Ool01000Oomoogoo0P00A7oo00<Gh7oo
Ool07Woo000GOol00aOPOomoo`0_Ool01000Oomoo`002Goo0P0017oo00<007ooOol0@goo00<Gh7oo
Ool07Woo000GOol00aOPOomoo`0_Ool01000Oomoo`002Goo00<007ooOol00goo00<007ooOol0@goo
00<Gh7ooOol07Woo000GOol00aOPOomoo`0`Ool2000:Ool30003Ool00`00Oomoo`13Ool00aOPOomo
o`0NOol001Qoo`035n1oogoo045oo`8004=oo`035n1oogoo01moo`0067oo00<Gh7ooOol0@Goo00<0
07ooOol0@Woo00<Gh7ooOol07goo000IOol00aOPOomoo`10Ool00`00Oomoo`11Ool00aOPOomoo`0P
Ool001Uoo`035n1oogoo041oo`03001oogoo045oo`035n1oogoo021oo`006Woo00<Gh7ooOol0?goo
0P00@Goo00<Gh7ooOol08Goo000JOol00aOPOomoo`0oOol00`00Oomoo`10Ool00aOPOomoo`0QOol0
01]oo`035n1oogoo03ioo`03001oogoo03moo`035n1oogoo029oo`006goo00<Gh7ooOol0?Woo00<0
07ooOol0?goo00<Gh7ooOol08Woo000LOol00aOPOomoo`0mOol00`00Oomoo`0nOol00aOPOomoo`0S
Ool001aoo`035n1oogoo03eoo`8003moo`035n1oogoo02=oo`007Goo00<Gh7ooOol0?7oo00<007oo
Ool0?Goo00<Gh7ooOol097oo000MOol00aOPOomoo`0lOol00`00Oomoo`0mOol00aOPOomoo`0TOol0
01ioo`035n1oogoo03]oo`03001oogoo03aoo`035n1oogoo02Eoo`007Woo00<Gh7ooOol0>goo0P00
?Goo00<Gh7ooOol09Goo000OOol00aOPOomoo`0jOol00`00Oomoo`0kOol00aOPOomoo`0VOol0021o
o`035n1oogoo039oo`D0009oo`03001oogoo03Yoo`035n1oogoo02Moo`0087oo00<Gh7ooOol0=7oo
00<007ooOol00Woo00<007ooOol0>Woo00<Gh7ooOol09goo000QOol00aOPOomoo`0cOol00`00Oomo
o`02Ool2000jOol00aOPOomoo`0XOol0029oo`035n1oogoo039oo`03001oogoo009oo`03001oogoo
03Qoo`035n1oogoo02Uoo`008goo00<Gh7ooOol0<Goo00<007ooOol00Woo00<007ooOol0=goo00<G
h7ooOol0:Woo000SOol00aOPOomoo`0`Ool20004Ool00`00Oomoo`0gOol00aOPOomoo`0ZOol002Ao
o`035n1oogoo03Eoo`03001oogoo03Ioo`035n1oogoo02]oo`009Goo00<Gh7ooOol0=7oo0P00=Woo
00<Gh7ooOol0;7oo000UOol00aOPOomoo`0dOol00`00Oomoo`0eOol00aOPOomoo`0/Ool002Ioo`03
5n1oogoo03=oo`03001oogoo03Aoo`035n1oogoo02eoo`009goo00<Gh7ooOol0<Woo00<007ooOol0
<goo00<Gh7ooOol0;Woo000XOol25n0bOol2000bOol25n0aOol002Yoo`035n1oogoo02moo`03001o
ogoo031oo`035n1oogoo035oo`00:goo00<Gh7ooOol0;Woo00<007ooOol0;goo00<Gh7ooOol0<Woo
000/Ool00aOPOomoo`0]Ool00`00Oomoo`0^Ool00aOPOomoo`0cOol002eoo`035n1oogoo02aoo`80
02ioo`035n1oogoo03Aoo`00;Woo00<Gh7ooOol0:goo00<007ooOol0;7oo00<Gh7ooOol0=Goo000_
Ool00aOPOomoo`0ZOol00`00Oomoo`0[Ool00aOPOomoo`0fOol0031oo`035n1oogoo02Uoo`03001o
ogoo02Yoo`035n1oogoo03Moo`00<Goo0QOP:Goo0P00:Goo0QOP>Woo000cOol00aOPOomoo`0VOol0
0`00Oomoo`0WOol00aOPOomoo`0jOol003Aoo`8Gh2Ioo`03001oogoo02Eoo`8Gh3eoo`00=Woo00<G
h7ooOol047oo1@000Woo0P0017oo0P0017oo00<007ooOol097oo00<Gh7ooOol0?Goo000gOol25n0B
Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol08Woo0QOP@7oo000iOol25n0@Ool00`00
Oomoo`0:Ool01000Oomoogoo0P008Goo0QOP@Woo000kOol25n0>Ool00`00Oomoo`08Ool20004Ool0
0`00Oomoo`0NOol25n14Ool003eoo`8Gh0aoo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo
01aoo`8Gh4Ioo`00?goo0QOP2Goo0P002Woo0`000goo00<007ooOol06Woo0QOPB7oo0011Ool35n0H
Ool2000HOol35n1:Ool004Aoo`<Gh1Eoo`03001oogoo01=oo`@Gh4eoo`00Agoo1AOP47oo00<007oo
Ool03goo11OPDGoo001<Ool75n09Ool00`00Oomoo`08Ool75n1EOol005=oo`HGh0=oo`80009oo`LG
h5aoo`00FGoo1aOPHgoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007oo
Ool0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00
Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001EOol40003Ool00`00Oomoo`1TOol0
05Eoo`03001oogoo00Aoo`03001oogoo06Aoo`00EWoo00<007ooOol00goo0P00IGoo001GOol00`00
Oomoo`1YOol005Eoo`04001oogoo001ZOol005Ioo`8006]oo`00`goo0033Ool00<=oo`00MWoo0P00
0goo10000Woo1@000Woo0P0017oo0P00<goo001eOol01000Oomoo`002Woo00<007ooOol01goo00@0
07ooOol0039oo`00Fgoo10005Woo00<007ooOol00goo100017oo00<007ooOol02Goo00<007ooOol0
<Goo001JOol01000Oomoo`005Woo1@002Woo00<007ooOol02Woo00<007ooOol0<7oo001JOol01000
Oomoo`005goo00<007ooOol02goo00<007ooOol01goo00@007ooOol0039oo`00FGoo0P0000=oo`00
000097oo0P002Woo0P00<goo0033Ool00<=oo`00`goo0033Ool00<=oo`00\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.25) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.5 1 0 r

.5 Mabswid

.08542 .49991 m

.08719 .46175 L

.09248 .42382 L

.10125 .38655 L

.11342 .35024 L

.12888 .31521 L

.14752 .28175 L

.16916 .25016 L

.19362 .2207 L

.2207 .19362 L

.25016 .16916 L

.28175 .14752 L

.31521 .12888 L

.35024 .11342 L

.38655 .10125 L

.42382 .09248 L

.46175 .08719 L

.5 .08542 L

.53825 .08719 L

.57618 .09248 L

.61345 .10125 L

.64976 .11342 L

.68479 .12888 L

.71825 .14752 L

.74984 .16916 L

.7793 .19362 L

.80638 .2207 L

.83084 .25016 L

.85248 .28175 L

.87112 .31521 L

.88658 .35024 L

.89875 .38655 L

.90752 .42382 L

.91281 .46175 L

.91458 .49991 L

s

.08542 .50009 m

.08719 .53825 L

.09248 .57618 L

.10125 .61345 L

.11342 .64976 L

.12888 .68479 L

.14752 .71825 L

.16916 .74984 L

.19362 .7793 L

.2207 .80638 L

.25016 .83084 L

.28175 .85248 L

.31521 .87112 L

.35024 .88658 L

.38655 .89875 L

.42382 .90752 L

.46175 .91281 L

.5 .91458 L

.53825 .91281 L

.57618 .90752 L

.61345 .89875 L

.64976 .88658 L

.68479 .87112 L

.71825 .85248 L

.74984 .83084 L

.7793 .80638 L

.80638 .7793 L

.83084 .74984 L

.85248 .71825 L

.87112 .68479 L

.88658 .64976 L

.89875 .61345 L

.90752 .57618 L

.91281 .53825 L

.91458 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001XOolH?n1cOol0069oo`Hoh0aoo`03001oogoo00Uoo`Hoh6eoo`00GWoo13oP4Woo00<0
07ooOol03goo13oPJGoo001JOol4?n0FOol00`00Oomoo`0COol4?n1UOol005Qoo`8oh1Yoo`03001o
ogoo01Moo`8oh6=oo`00EGoo0coP0goo1@0017oo0P001Goo10001Goo00<007ooOol06Goo0coPH7oo
001BOol3?n08Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`0LOol3?n1MOol0051oo`8oh0]oo`03001oogoo00moo`03001oogoo009oo`03001oogoo01moo`8o
h5]oo`00CWoo0SoP0Woo1P001Goo00<007ooOol03goo00<007ooOol00Woo0P008Woo0coPF7oo001<
Ool2?n0?Ool00`00Oomoo`0;Ool40005Ool00`00Oomoo`0TOol2?n1FOol004Yoo`8oh15oo`03001o
ogoo00]oo`03001oogoo00Ioo`03001oogoo02Ioo`8oh5Aoo`00B7oo0SoP4Goo0`003Goo00<007oo
Ool01Woo00<007ooOol0:7oo0SoPDWoo0016Ool2?n0EOol00`00Oomoo`0;Ool50004Ool00`00Oomo
o`0ZOol2?n1@Ool004Eoo`03?n1oogoo02aoo`03001oogoo02aoo`03?n1oogoo04eoo`00@goo0SoP
;goo00<007ooOol0;Goo0SoPCGoo0012Ool00coPOomoo`0_Ool00`00Oomoo`0_Ool00coPOomoo`1:
Ool0045oo`03?n1oogoo031oo`03001oogoo031oo`03?n1oogoo04Uoo`00?goo0SoP<goo00<007oo
Ool0<Goo0SoPBGoo000nOol00coPOomoo`0cOol00`00Oomoo`0cOol00coPOomoo`16Ool003aoo`8o
h3Ioo`03001oogoo03Aoo`03?n1oogoo04Eoo`00>goo00<oh7ooOol0=Woo00<007ooOol0=Goo00<o
h7ooOol0A7oo000jOol00coPOomoo`0gOol00`00Oomoo`0fOol2?n14Ool003Qoo`8oh3Yoo`03001o
ogoo03Qoo`03?n1oogoo045oo`00=goo00<oh7ooOol0>Woo00<007ooOol0>Goo00<oh7ooOol0@7oo
000fOol00coPOomoo`0kOol00`00Oomoo`0jOol00coPOomoo`0oOol003Eoo`03?n1oogoo03aoo`03
001oogoo03]oo`03?n1oogoo03ioo`00=7oo00<oh7ooOol0?Goo00<007ooOol0?7oo00<oh7ooOol0
?Goo000dOol00coPOomoo`0mOol00`00Oomoo`0mOol00coPOomoo`0lOol003=oo`03?n1oogoo03io
o`03001oogoo03ioo`03?n1oogoo03]oo`00<Woo00<oh7ooOol0?goo00<007ooOol0?goo00<oh7oo
Ool0>Woo000aOol00coPOomoo`10Ool00`00Oomoo`10Ool00coPOomoo`0iOol0031oo`03?n1oogoo
045oo`03001oogoo045oo`03?n1oogoo03Qoo`00;goo00<oh7ooOol0>Goo1@0017oo00<007ooOol0
@Woo00<oh7ooOol0=goo000^Ool00coPOomoo`0lOol00`00Oomoo`04Ool00`00Oomoo`12Ool00coP
Oomoo`0gOol002eoo`03?n1oogoo03eoo`03001oogoo00Aoo`03001oogoo04=oo`03?n1oogoo03Io
o`00;7oo00<oh7ooOol0<goo1P001Goo00<007ooOol017oo0P00AGoo00<oh7ooOol0=Goo000[Ool0
0coPOomoo`0oOol00`00Oomoo`04Ool00`00Oomoo`15Ool00coPOomoo`0dOol002]oo`03?n1oogoo
03moo`03001oogoo00Aoo`03001oogoo04Eoo`03?n1oogoo03Aoo`00:Woo00<oh7ooOol0?Woo0`00
1Woo00<007ooOol0AWoo00<oh7ooOol0<goo000ZOol00coPOomoo`10Ool00`00Oomoo`04Ool00`00
Oomoo`17Ool00coPOomoo`0bOol002Uoo`03?n1oogoo04Qoo`03001oogoo04Qoo`03?n1oogoo035o
o`00:Goo00<oh7ooOol0B7oo00<007ooOol0B7oo00<oh7ooOol0<Goo000XOol00coPOomoo`19Ool0
0`00Oomoo`19Ool00coPOomoo`0`Ool002Moo`03?n1oogoo04Yoo`03001oogoo04Yoo`03?n1oogoo
02moo`009goo00<oh7ooOol0BWoo00<007ooOol0BWoo00<oh7ooOol0;goo000VOol00coPOomoo`1;
Ool00`00Oomoo`1;Ool00coPOomoo`0^Ool002Ioo`03?n1oogoo04]oo`03001oogoo04]oo`03?n1o
ogoo02ioo`009Goo00<oh7ooOol0C7oo00<007ooOol0C7oo00<oh7ooOol0;Goo000UOol00coPOomo
o`1<Ool00`00Oomoo`1<Ool00coPOomoo`0]Ool002Aoo`03?n1oogoo04eoo`03001oogoo04eoo`03
?n1oogoo02aoo`008goo00<oh7ooOol0CWoo00<007ooOol0CGoo00<oh7ooOol0;7oo000SOol00coP
Oomoo`1>Ool00`00Oomoo`1>Ool00coPOomoo`0[Ool0029oo`03?n1oogoo04moo`03001oogoo04io
o`03?n1oogoo02]oo`008Woo00<oh7ooOol0Cgoo00<007ooOol0Cgoo00<oh7ooOol0:Woo000QOol0
0coPOomoo`1@Ool00`00Oomoo`1?Ool00coPOomoo`0ZOol0025oo`03?n1oogoo051oo`03001oogoo
04moo`03?n1oogoo02Yoo`0087oo00<oh7ooOol0DGoo00<007ooOol0D7oo00<oh7ooOol0:Goo000P
Ool00coPOomoo`1AOol00`00Oomoo`1@Ool00coPOomoo`0YOol0021oo`03?n1oogoo055oo`03001o
ogoo051oo`03?n1oogoo02Uoo`007goo00<oh7ooOol0>Goo10001Goo0P001Goo10001Goo00<007oo
Ool0DGoo00<oh7ooOol0:7oo000OOol00coPOomoo`0hOol00`00Oomoo`02Ool00`00Oomoo`02Ool2
0004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1AOol00coPOomoo`0XOol001moo`03
?n1oogoo03Qoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo059oo`03
?n1oogoo02Moo`007goo00<oh7ooOol0<7oo1P000Woo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol00Woo0P00Dgoo00<oh7ooOol09goo000NOol00coPOomoo`0iOol00`00Oomoo`02Ool00`00
Oomoo`09Ool40005Ool00`00Oomoo`1BOol00coPOomoo`0WOol001ioo`03?n1oogoo03Uoo`03001o
ogoo009oo`03001oogoo00Uoo`03001oogoo00Ioo`03001oogoo05=oo`03?n1oogoo02Ioo`007Woo
00<oh7ooOol0>Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0Dgoo
00<oh7ooOol09Woo000NOol00coPOomoo`0jOol4000<Ool50004Ool00`00Oomoo`1COol00coPOomo
o`0VOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`007Goo00<oh7ooOol0
E7oo00<007ooOol0E7oo00<oh7ooOol09Goo000MOol00coPOomoo`1DOol00`00Oomoo`1DOol00coP
Oomoo`0UOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`0077oo00<oh7oo
Ool0EGoo00<007ooOol0EGoo00<oh7ooOol097oo000LOol00coPOomoo`1EOol00`00Oomoo`1EOol0
0coPOomoo`0TOol001aoo`03?n1oogoo05Eoo`03001oogoo05Eoo`03?n1oogoo02Aoo`0077oo00<o
h7ooOol0EGoo00<007ooOol0EGoo00<oh7ooOol097oo0009Ool5000>Ool00coP000000030004Ool2
0005Ool4000?Ool5000>Ool40005Ool20005Ool4000=Ool00`00Oomoo`0>Ool40005Ool20005Ool4
000?Ool5000>Ool50004Ool20005Ool01000?n0000003Woo1@004Goo0009Ool01@00Oomoogoo0000
3Woo00@oh7ooOol000Ioo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00ioo`03
001oogoo011oo`03001oogoo00Aoo`8000Aoo`03001oocoP009oo`03001oogoo00]oo`05001oogoo
Ool0000AOol000Yoo`03001oogoo00ioo`05?n1oogooOol0000AOol00`00Oomoo`0>Ool00`00Oomo
o`0=Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0=Ool00coPOol0
000>Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Ioo`H00003Ooloh7oo009o
o`03001oogoo00moo`03001oogoo00=oo`H000Eoo`03001oogoo00Eoo`H0009oo`03001oogoo009o
o`03001oogoo00eoo`03001oogoo00Yoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00eo
o`03001oogoo00ioo`03001oogoo011oo`03001oogoo00eoo`03?n1oo`0000moo`03001oogoo015o
o`0037oo00<007ooOol037oo00Doh7ooOomoo`0000eoo`@0015oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo00Uoo`@000eoo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@0
015oo`03001oogoo011oo`03001oogoo00]oo`800003?n0007oo011oo`03001oogoo011oo`003Goo
00<007ooOol02goo00Doh7ooOomoo`0000eoo`03001oogoo019oo`03001oogoo00eoo`03001oogoo
009oo`03001oogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03001oogoo
00Uoo`03001oogoo019oo`03001oogoo011oo`03001oogoo00]oo`03001oocoP01=oo`03001oogoo
00moo`002Goo00D007ooOomoo`0000eoo`03?n1oo`00008000eoo`03001oogoo011oo`<000moo`03
001oogoo009oo`03001oogoo00Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo011oo`<0011oo`<000eoo`03001oocoP00moo`05001oogooOol0000A
Ool000Yoo`<000ioo`05?n1oogooOol0000=Ool5000@Ool00`00Oomoo`0>Ool4000<Ool5000<Ool0
0`00Oomoo`0>Ool4000<Ool5000@Ool00`00Oomoo`0@Ool00`00Oomoo`0;Ool200000coP0000000>
Ool3000BOol001]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7oo
Ool0EWoo00<007ooOol0EWoo00<oh7ooOol08goo000JOol00coPOomoo`1GOol00`00Oomoo`1FOol0
0coPOomoo`0SOol001Yoo`03?n1oogoo05Moo`03001oogoo05Ioo`03?n1oogoo02=oo`006Woo00<o
h7ooOol0Egoo00<007ooOol0EWoo00<oh7ooOol067oo0P000Woo0P001Goo000JOol00coPOomoo`1G
Ool00`00Oomoo`1FOol00coPOomoo`0IOol01000Oomoo`001Woo0008OolB00000coP0000002`0000
0coP0000000A0009Ool20007Ool000Qoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oocoP009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo009oo`06001oogoo?n1oo`001Goo00<007oo
Ool00Woo00<007ooOol00goo00<007ooOol01goo0P001goo0008Ool00`00Oomoo`0?Ool00coPOomo
o`06Ool00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomoo`0HOol00`00Oomo
o`0HOol00`00Oomoo`0HOol00`00Oomoo`05Ool00coPOomoo`0@Ool00`00Oomoo`06Ool01000Oomo
o`001Woo000JOol00coPOomoo`1GOol00`00Oomoo`1FOol00coPOomoo`0HOol20002Ool20005Ool0
01]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7ooOol0EWoo00<0
07ooOol0EWoo00<oh7ooOol08goo000KOol00coPOomoo`1FOol00`00Oomoo`1FOol00coPOomoo`0S
Ool001]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7ooOol0EWoo
00<007ooOol0EWoo00<oh7ooOol08goo000KOol00coPOomoo`1FOol00`00Oomoo`1FOol00coPOomo
o`0SOol001]oo`03?n1oogoo05Ioo`03001oogoo05Ioo`03?n1oogoo02=oo`006goo00<oh7ooOol0
EWoo00<007ooOol0EWoo00<oh7ooOol08goo000KOol00coPOomoo`1FOol00`00Oomoo`1FOol00coP
Oomoo`0SOol001aoo`03?n1oogoo05Eoo`03001oogoo05Eoo`03?n1oogoo02Aoo`0077oo00<oh7oo
Ool0EGoo00<007ooOol0EGoo00<oh7ooOol097oo000LOol00coPOomoo`1EOol00`00Oomoo`1EOol0
0coPOomoo`0TOol001aoo`03?n1oogoo05Eoo`03001oogoo05Eoo`03?n1oogoo02Aoo`0077oo00<o
h7ooOol0EGoo00<007ooOol0EGoo00<oh7ooOol097oo000LOol00coPOomoo`1EOol00`00Oomoo`1E
Ool00coPOomoo`0TOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`007Goo
00<oh7ooOol0E7oo00<007ooOol0E7oo00<oh7ooOol09Goo000MOol00coPOomoo`1DOol00`00Oomo
o`1DOol00coPOomoo`0UOol001eoo`03?n1oogoo05Aoo`03001oogoo05Aoo`03?n1oogoo02Eoo`00
7Woo00<oh7ooOol0Dgoo00<007ooOol0Dgoo00<oh7ooOol09Woo000NOol00coPOomoo`0jOol40005
Ool20005Ool40005Ool00`00Oomoo`1COol00coPOomoo`0VOol001ioo`03?n1oogoo03Uoo`03001o
ogoo009oo`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo05=o
o`03?n1oogoo02Ioo`007Woo00<oh7ooOol0>Goo00<007ooOol00Woo00<007ooOol03Goo00<007oo
Ool00Woo00<007ooOol0Dgoo00<oh7ooOol09Woo000OOol00coPOomoo`0hOol00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`02Ool2001COol00coPOomoo`0WOol001moo`03?n1oogoo03Qoo`03
001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001oogoo059oo`03?n1oogoo02Moo`007goo00<o
h7ooOol0>7oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0DGoo00<o
h7ooOol0:7oo000OOol00coPOomoo`0hOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06
Ool00`00Oomoo`1AOol00coPOomoo`0XOol0021oo`03?n1oogoo03Qoo`@000aoo`D000Aoo`03001o
ogoo051oo`03?n1oogoo02Uoo`0087oo00<oh7ooOol0DGoo00<007ooOol0D7oo00<oh7ooOol0:Goo
000QOol00coPOomoo`1@Ool00`00Oomoo`1@Ool00coPOomoo`0YOol0025oo`03?n1oogoo051oo`03
001oogoo04moo`03?n1oogoo02Yoo`008Woo00<oh7ooOol0Cgoo00<007ooOol0Cgoo00<oh7ooOol0
:Woo000ROol00coPOomoo`1?Ool00`00Oomoo`1>Ool00coPOomoo`0[Ool002=oo`03?n1oogoo04io
o`03001oogoo04ioo`03?n1oogoo02]oo`008goo00<oh7ooOol0CWoo00<007ooOol0CWoo00<oh7oo
Ool0:goo000TOol00coPOomoo`1=Ool00`00Oomoo`1=Ool00coPOomoo`0/Ool002Aoo`03?n1oogoo
04eoo`03001oogoo04eoo`03?n1oogoo02aoo`009Goo00<oh7ooOol0C7oo00<007ooOol0C7oo00<o
h7ooOol0;Goo000UOol00coPOomoo`1<Ool00`00Oomoo`1<Ool00coPOomoo`0]Ool002Ioo`03?n1o
ogoo04]oo`03001oogoo04]oo`03?n1oogoo02ioo`009Woo00<oh7ooOol0Bgoo00<007ooOol0Bgoo
00<oh7ooOol0;Woo000WOol00coPOomoo`1:Ool00`00Oomoo`1:Ool00coPOomoo`0_Ool002Moo`03
?n1oogoo04Yoo`03001oogoo04Yoo`03?n1oogoo02moo`00:7oo00<oh7ooOol0BGoo00<007ooOol0
BGoo00<oh7ooOol0<7oo000YOol00coPOomoo`18Ool00`00Oomoo`18Ool00coPOomoo`0aOol002Uo
o`03?n1oogoo04Qoo`03001oogoo04Qoo`03?n1oogoo035oo`00:Woo00<oh7ooOol0Agoo00<007oo
Ool0Agoo00<oh7ooOol0<Woo000ZOol00coPOomoo`0nOol50004Ool00`00Oomoo`16Ool00coPOomo
o`0cOol002]oo`03?n1oogoo03moo`03001oogoo00Aoo`03001oogoo04Eoo`03?n1oogoo03Aoo`00
:goo00<oh7ooOol0?goo00<007ooOol017oo00<007ooOol0AGoo00<oh7ooOol0=7oo000/Ool00coP
Oomoo`0nOol00`00Oomoo`04Ool20015Ool00coPOomoo`0eOol002eoo`03?n1oogoo03eoo`03001o
ogoo00Aoo`03001oogoo04=oo`03?n1oogoo03Ioo`00;Woo00<oh7ooOol0?7oo00<007ooOol017oo
00<007ooOol0@Woo00<oh7ooOol0=goo000_Ool00coPOomoo`0iOol30006Ool00`00Oomoo`11Ool0
0coPOomoo`0hOol0031oo`03?n1oogoo03Yoo`03001oogoo00Aoo`03001oogoo045oo`03?n1oogoo
03Qoo`00<Goo00<oh7ooOol0@7oo00<007ooOol0@7oo00<oh7ooOol0>Goo000bOol00coPOomoo`0o
Ool00`00Oomoo`0oOol00coPOomoo`0jOol003=oo`03?n1oogoo03ioo`03001oogoo03ioo`03?n1o
ogoo03]oo`00=7oo00<oh7ooOol0?Goo00<007ooOol0?Goo00<oh7ooOol0?7oo000eOol00coPOomo
o`0lOol00`00Oomoo`0lOol00coPOomoo`0mOol003Eoo`03?n1oogoo03aoo`03001oogoo03]oo`03
?n1oogoo03ioo`00=Woo00<oh7ooOol0>goo00<007ooOol0>Woo00<oh7ooOol0?goo000gOol00coP
Oomoo`0jOol00`00Oomoo`0iOol00coPOomoo`10Ool003Qoo`03?n1oogoo03Uoo`03001oogoo03Qo
o`03?n1oogoo045oo`00>Goo00<oh7ooOol0>7oo00<007ooOol0=goo00<oh7ooOol0@Woo000jOol2
?n0hOol00`00Oomoo`0fOol00coPOomoo`13Ool003aoo`03?n1oogoo03Eoo`03001oogoo03Eoo`03
?n1oogoo04Aoo`00?Goo00<oh7ooOol0=7oo00<007ooOol0=7oo00<oh7ooOol0AGoo000nOol00coP
Oomoo`0cOol00`00Oomoo`0cOol00coPOomoo`16Ool003moo`8oh3=oo`03001oogoo035oo`8oh4Uo
o`00@Goo0SoP<Goo00<007ooOol0;goo0SoPBgoo0013Ool2?n0_Ool00`00Oomoo`0]Ool2?n1=Ool0
04Eoo`03?n1oogoo02aoo`03001oogoo02aoo`03?n1oogoo04eoo`00AWoo0SoP;7oo00<007ooOol0
:Woo0SoPD7oo0018Ool2?n0AOol50004Ool20005Ool40005Ool00`00Oomoo`0XOol2?n1BOol004Yo
o`8oh15oo`03001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo02Io
o`8oh5Aoo`00C7oo00<oh7ooOol03Woo00<007ooOol03goo00<007ooOol00Woo00<007ooOol09Goo
00<oh7ooOol0E7oo001=Ool2?n0>Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool2000TOol2?n1GOol0
04moo`8oh0aoo`03001oogoo00]oo`@000Eoo`03001oogoo025oo`8oh5Uoo`00DGoo0SoP2Woo00<0
07ooOol02goo00<007ooOol01Woo00<007ooOol07goo0SoPFgoo001COol2?n06Ool3000=Ool00`00
Oomoo`06Ool00`00Oomoo`0LOol3?n1MOol005Eoo`@oh0Aoo`03001oogoo00]oo`D000Aoo`03001o
ogoo01Qoo`@oh61oo`00FGoo13oP5goo00<007ooOol057oo13oPI7oo001MOol4?n0COol00`00Oomo
o`0@Ool4?n1XOol0065oo`Hoh0eoo`03001oogoo00Yoo`Hoh6aoo`00Igoo2CoP17oo00<007ooOol0
0Woo23oPLWoo001`Ool9?n1jOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1l
Ool007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03
001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07ao
o`00M7oo00<007ooOol0O7oo001ZOol50005Ool00`00Oomoo`1lOol006Yoo`05001oogooOol00005
Ool00`00Oomoo`1lOol006]oo`03001oogoo00Ioo`03001oogoo07aoo`00K7oo00<007ooOol01Goo
0P00OGoo001]Ool00`00Oomoo`23Ool006ioo`03001oogoo089oo`00JWoo00D007ooOomoo`0008Ao
o`00Jgoo0`00QGoo003cOol00?=oo`00lgoo003cOol0095oo`<000]oo`D000Aoo`8000Aoo`D000Ao
o`@003Qoo`00T7oo00H007ooOomoo`00Ool60005Ool00`00Oomoo`04Ool20004Ool01@00Oomoogoo
00000goo00<007ooOol00Woo00<007ooOol0=Goo001cOol200000goo0000000HOol00`00Oomoo`0>
Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`0eOol0079oo`03001oogoo008001Uoo`03
001oogoo00=oo`H000Eoo`03001oogoo00aoo`03001oogoo00Qoo`03001oogoo03Eoo`00LWoo00D0
07ooOomoo`0001Uoo`03001oogoo00ioo`03001oogoo00eoo`03001oogoo00=oo`@003Qoo`00LWoo
00D007ooOomoo`0001Qoo`D000eoo`03001oogoo00ioo`03001oogoo009oo`03001oogoo03Uoo`00
LWoo00D007ooOomoo`0001Uoo`03001oogoo00aoo`<000aoo`05001oogooOol00004Ool00`00Oomo
o`0iOol0075oo`80009oo`8002Yoo`03001oogoo00]oo`<000Eoo`D003Moo`00lgoo003cOol00?=o
o`00lgoo003cOol00001\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.2) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.8 1 0 r

.5 Mabswid

.09689 .49991 m

.09861 .46281 L

.10375 .42593 L

.11228 .38968 L

.12411 .35438 L

.13915 .32032 L

.15727 .28779 L

.17831 .25707 L

.2021 .22842 L

.22842 .2021 L

.25707 .17831 L

.28779 .15727 L

.32032 .13915 L

.35438 .12411 L

.38968 .11228 L

.42593 .10375 L

.46281 .09861 L

.5 .09689 L

.53719 .09861 L

.57407 .10375 L

.61032 .11228 L

.64562 .12411 L

.67968 .13915 L

.71221 .15727 L

.74293 .17831 L

.77158 .2021 L

.7979 .22842 L

.82169 .25707 L

.84273 .28779 L

.86085 .32032 L

.87589 .35438 L

.88772 .38968 L

.89625 .42593 L

.90139 .46281 L

.90311 .49991 L

s

.09689 .50009 m

.09861 .53719 L

.10375 .57407 L

.11228 .61032 L

.12411 .64562 L

.13915 .67968 L

.15727 .71221 L

.17831 .74293 L

.2021 .77158 L

.22842 .7979 L

.25707 .82169 L

.28779 .84273 L

.32032 .86085 L

.35438 .87589 L

.38968 .88772 L

.42593 .89625 L

.46281 .90139 L

.5 .90311 L

.53719 .90139 L

.57407 .89625 L

.61032 .88772 L

.64562 .87589 L

.67968 .86085 L

.71221 .84273 L

.74293 .82169 L

.77158 .7979 L

.7979 .77158 L

.82169 .74293 L

.84273 .71221 L

.86085 .67968 L

.87589 .64562 L

.88772 .61032 L

.89625 .57407 L

.90139 .53719 L

.90311 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003c0000la000`40O003h00Olgoo003cOol006Yo
o`D008Aoo`00JWoo00D007ooOomoo`0008Aoo`00Jgoo00<007ooOol0QGoo001ROol60004Ool00`00
Oomoo`05Ool2001mOol006eoo`03001oogoo00Aoo`03001oogoo07aoo`00KWoo00<007ooOol00goo
00<007ooOol0O7oo001ZOol01@00Oomoogoo00001Goo00<007ooOol0O7oo001[Ool30006Ool00`00
Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol0
07Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001o
ogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00
M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007oo
Ool0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00LGoo1fOPNgoo001YOol8In03
Ool01000Oomoogoo26OPLgoo001SOol6In0;Ool00`00Oomoo`09Ool6In1]Ool005]oo`@000AWh003
Ool0000000Eoo`@000Eoo`03001oogoo00moo`AWh6Uoo`00Fgoo16OP1Goo0P0017oo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol04goo0fOPIWoo001GOol4In02Ool00`00Oomoo`0?Ool00`00
Oomoo`02Ool00`00Oomoo`0FOol4In1ROol0059oo`03001Wh6OP009Wh003001oogoo00=oo`03001o
ogoo00moo`03001oogoo009oo`8001]oo`AWh5ioo`00DGoo0VOP2Woo00<007ooOol02goo10001Goo
00<007ooOol07Woo0VOPG7oo001?Ool2In0<Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomo
o`0POol2In1JOol004eoo`9Wh0aoo`<000eoo`03001oogoo00Ioo`03001oogoo029oo`9Wh5Qoo`00
Bgoo0VOP47oo00<007ooOol02goo1@0017oo00<007ooOol097oo0VOPEWoo0019Ool2In0YOol00`00
Oomoo`0VOol2In1DOol004Moo`9Wh2]oo`03001oogoo02Qoo`9Wh59oo`00AWoo00=Wh7ooOol0:goo
00<007ooOol0:Woo00=Wh7ooOol0Cgoo0014Ool2In0^Ool00`00Oomoo`0[Ool2In1?Ool004=oo`03
In1oogoo02ioo`03001oogoo02eoo`03In1oogoo04aoo`00@Woo00=Wh7ooOol0;goo00<007ooOol0
;Woo00=Wh7ooOol0Bgoo0010Ool2In0bOol00`00Oomoo`0_Ool2In1;Ool003moo`03In1oogoo039o
o`03001oogoo035oo`03In1oogoo04Qoo`00?Woo00=Wh7ooOol0<goo00<007ooOol0<Woo00=Wh7oo
Ool0Agoo000mOol00fOPOomoo`0dOol00`00Oomoo`0cOol00fOPOomoo`16Ool003]oo`9Wh3Moo`03
001oogoo03Aoo`9Wh4Ioo`00>Woo00=Wh7ooOol0=goo00<007ooOol0=Woo00=Wh7ooOol0@goo000i
Ool00fOPOomoo`0hOol00`00Oomoo`0gOol00fOPOomoo`12Ool003Qoo`03In1oogoo03Uoo`03001o
ogoo03Qoo`03In1oogoo045oo`00=goo00=Wh7ooOol0>Woo00<007ooOol0>Goo00=Wh7ooOol0@7oo
000fOol00fOPOomoo`0kOol00`00Oomoo`0jOol00fOPOomoo`0oOol003Eoo`03In1oogoo03aoo`03
001oogoo03]oo`03In1oogoo03ioo`00=7oo00=Wh7ooOol0?Goo00<007ooOol0?7oo00=Wh7ooOol0
?Goo000cOol00fOPOomoo`0nOol00`00Oomoo`0mOol00fOPOomoo`0lOol0039oo`03In1oogoo03Io
o`D000Aoo`03001oogoo03ioo`03In1oogoo03]oo`00<Goo00=Wh7ooOol0>Goo00<007ooOol017oo
00<007ooOol0?goo00=Wh7ooOol0>Woo000`Ool00fOPOomoo`0jOol00`00Oomoo`04Ool00`00Oomo
o`10Ool00fOPOomoo`0iOol0031oo`03In1oogoo02moo`H000Eoo`03001oogoo00Aoo`80045oo`03
In1oogoo03Uoo`00;goo00=Wh7ooOol0>goo00<007ooOol017oo00<007ooOol0@Goo00=Wh7ooOol0
>7oo000^Ool00fOPOomoo`0lOol00`00Oomoo`04Ool00`00Oomoo`12Ool00fOPOomoo`0gOol002eo
o`03In1oogoo03]oo`<000Ioo`03001oogoo04=oo`03In1oogoo03Ioo`00;Goo00=Wh7ooOol0?Goo
00<007ooOol017oo00<007ooOol0A7oo00=Wh7ooOol0=Goo000/Ool00fOPOomoo`15Ool00`00Oomo
o`15Ool00fOPOomoo`0dOol002]oo`03In1oogoo04Ioo`03001oogoo04Eoo`03In1oogoo03Aoo`00
:goo00=Wh7ooOol0AWoo00<007ooOol0AWoo00=Wh7ooOol0<goo000ZOol00fOPOomoo`17Ool00`00
Oomoo`17Ool00fOPOomoo`0bOol002Uoo`03In1oogoo04Qoo`03001oogoo04Moo`03In1oogoo039o
o`00:Goo00=Wh7ooOol0B7oo00<007ooOol0B7oo00=Wh7ooOol0<Goo000XOol00fOPOomoo`19Ool0
0`00Oomoo`18Ool00fOPOomoo`0aOol002Qoo`03In1oogoo04Uoo`03001oogoo04Uoo`03In1oogoo
031oo`009goo00=Wh7ooOol0BWoo00<007ooOol0BGoo00=Wh7ooOol0<7oo000WOol00fOPOomoo`1:
Ool00`00Oomoo`1:Ool00fOPOomoo`0_Ool002Ioo`03In1oogoo04]oo`03001oogoo04Yoo`03In1o
ogoo02moo`009Woo00=Wh7ooOol0Bgoo00<007ooOol0Bgoo00=Wh7ooOol0;Woo000UOol00fOPOomo
o`1<Ool00`00Oomoo`1;Ool00fOPOomoo`0^Ool002Eoo`03In1oogoo04aoo`03001oogoo04aoo`03
In1oogoo02eoo`0097oo00=Wh7ooOol0CGoo00<007ooOol0C7oo00=Wh7ooOol0;Goo000TOol00fOP
Oomoo`1=Ool00`00Oomoo`1=Ool00fOPOomoo`0/Ool002Aoo`03In1oogoo04eoo`03001oogoo04eo
o`03In1oogoo02aoo`008goo00=Wh7ooOol0CWoo00<007ooOol0CWoo00=Wh7ooOol0:goo000SOol0
0fOPOomoo`1>Ool00`00Oomoo`1>Ool00fOPOomoo`0[Ool002=oo`03In1oogoo03Eoo`@000Eoo`80
00Eoo`@000Eoo`03001oogoo04ioo`03In1oogoo02]oo`008Woo00=Wh7ooOol0=Goo00<007ooOol0
0Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Cgoo00=W
h7ooOol0:Woo000ROol00fOPOomoo`0eOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`02
Ool00`00Oomoo`1?Ool00fOPOomoo`0ZOol0025oo`03In1oogoo02ioo`H0009oo`03001oogoo009o
o`03001oogoo00eoo`03001oogoo009oo`80051oo`03In1oogoo02Yoo`008Goo00=Wh7ooOol0=Woo
00<007ooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol0Cgoo00=Wh7ooOol0:Woo000POol0
0fOPOomoo`0gOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`1@Ool0
0fOPOomoo`0YOol0021oo`03In1oogoo03Moo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo
00Ioo`03001oogoo051oo`03In1oogoo02Uoo`0087oo00=Wh7ooOol0>7oo100037oo1@0017oo00<0
07ooOol0D7oo00=Wh7ooOol0:Goo000OOol00fOPOomoo`1BOol00`00Oomoo`1AOol00fOPOomoo`0X
Ool001moo`03In1oogoo059oo`03001oogoo055oo`03In1oogoo02Qoo`007goo00=Wh7ooOol0DWoo
00<007ooOol0DGoo00=Wh7ooOol0:7oo000OOol00fOPOomoo`1BOol00`00Oomoo`1AOol00fOPOomo
o`0XOol001ioo`03In1oogoo05=oo`03001oogoo059oo`03In1oogoo02Moo`007Woo00=Wh7ooOol0
Dgoo00<007ooOol0DWoo00=Wh7ooOol09goo000NOol00fOPOomoo`1COol00`00Oomoo`1BOol00fOP
Oomoo`0WOol001ioo`03In1oogoo05=oo`03001oogoo059oo`03In1oogoo02Moo`002Goo1@003goo
00<006OP00000P0017oo0P001Goo10003goo1@003Woo10001Goo0P001Goo10003Goo00<007ooOol0
3Woo10001Goo0P001Goo10003goo1@003Woo1@0017oo0P000goo00=Wh7oo00000`003Woo1@004Goo
0009Ool01@00Oomoogoo000047oo00=Wh000Ool01Goo0P0017oo00<007ooOol00Woo00<007ooOol0
3Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol02Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol0
0Woo00<007ooOol03Woo00<007ooOol047oo00<007ooOol017oo0P000goo00=Wh000Ool00goo00<0
07ooOol02goo00D007ooOomoo`00015oo`002Woo00<007ooOol047oo00=Wh7oo00004Goo00<007oo
Ool03Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol02Woo00<007oo
Ool03Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol047oo00<007oo
Ool02Woo00=Wh7ooOol00Woo00<007ooOol037oo00<007ooOol04Woo00000goo000000040004Ool0
0`00Oomoo`06Ool60003Ool00fOPOol0000AOol00`00Oomoo`03Ool60005Ool00`00Oomoo`05Ool6
0002Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0=Ool00`00Oomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool00`00Oomoo`0@Ool00`00Oomoo`0:Ool00fOPOomo
o`02Ool00`00Oomoo`0=Ool00`00Oomoo`0AOol000aoo`03001oogoo00ioo`03In1oo`0000eoo`@0
015oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo00Uoo`@000eoo`03001oogoo00eoo`03
001oogoo009oo`03001oogoo00Uoo`@0015oo`03001oogoo011oo`03001oogoo00Yoo`03In000000
0080015oo`03001oogoo011oo`003Goo00<007ooOol03Goo00=Wh7oo00003Goo00<007ooOol04Woo
00<007ooOol03Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol04Woo00<007ooOol047oo00<007ooOol02Woo
00=Wh000Ool057oo00<007ooOol03goo0009Ool01@00Oomoogoo00003goo00=Wh00000003Goo00<0
07ooOol047oo0`003goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol03Woo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol047oo0`0047oo0`0037oo00=Wh000Ool0
47oo00D007ooOomoo`00015oo`002Woo0`0047oo00=Wh7oo00003Goo1@0047oo00<007ooOol03Woo
100037oo1@0037oo00<007ooOol03Woo100037oo1@0047oo00<007ooOol047oo00<007ooOol02Woo
00=Wh00000000`003Woo0`004Woo000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0V
Ool001eoo`03In1oogoo05Aoo`03001oogoo05=oo`03In1oogoo02Ioo`007Goo00=Wh7ooOol0E7oo
00<007ooOol0E7oo00=Wh7ooOol09Goo000MOol00fOPOomoo`1DOol00`00Oomoo`1DOol00fOPOomo
o`0UOol001eoo`03In1oogoo05Aoo`03001oogoo05Aoo`03In1oogoo01Yoo`80009oo`8000Eoo`00
7Goo00=Wh7ooOol0E7oo00<007ooOol0E7oo00=Wh7ooOol06goo00@007ooOol000Ioo`0027oo5@00
00=Wh0000000Z`0000=Wh00000004`002Goo0P001goo0008Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00fOPOomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00In1oo`02
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`07Ool20007Ool000Qo
o`03001oogoo019oo`03In1oogoo00=oo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qo
o`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo01Qoo`03001oogoo00=oo`03In1oogoo019o
o`03001oogoo00Ioo`04001oogoo0006Ool001eoo`03In1oogoo05Aoo`03001oogoo05Aoo`03In1o
ogoo01Yoo`80009oo`8000Eoo`007Goo00=Wh7ooOol0E7oo00<007ooOol0Dgoo00=Wh7ooOol09Woo
000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0VOol001eoo`03In1oogoo05Aoo`03
001oogoo05=oo`03In1oogoo02Ioo`007Goo00=Wh7ooOol0E7oo00<007ooOol0Dgoo00=Wh7ooOol0
9Woo000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0VOol001eoo`03In1oogoo05Ao
o`03001oogoo05=oo`03In1oogoo02Ioo`007Goo00=Wh7ooOol0E7oo00<007ooOol0Dgoo00=Wh7oo
Ool09Woo000MOol00fOPOomoo`1DOol00`00Oomoo`1COol00fOPOomoo`0VOol001ioo`03In1oogoo
05=oo`03001oogoo059oo`03In1oogoo02Moo`007Woo00=Wh7ooOol0Dgoo00<007ooOol0DWoo00=W
h7ooOol09goo000NOol00fOPOomoo`1COol00`00Oomoo`1BOol00fOPOomoo`0WOol001ioo`03In1o
ogoo05=oo`03001oogoo059oo`03In1oogoo02Moo`007Woo00=Wh7ooOol0Dgoo00<007ooOol0DWoo
00=Wh7ooOol09goo000NOol00fOPOomoo`1COol00`00Oomoo`1BOol00fOPOomoo`0WOol001moo`03
In1oogoo059oo`03001oogoo055oo`03In1oogoo02Qoo`007goo00=Wh7ooOol0DWoo00<007ooOol0
DGoo00=Wh7ooOol0:7oo000OOol00fOPOomoo`1BOol00`00Oomoo`1AOol00fOPOomoo`0XOol001mo
o`03In1oogoo059oo`03001oogoo055oo`03In1oogoo02Qoo`0087oo00=Wh7ooOol0DGoo00<007oo
Ool0D7oo00=Wh7ooOol0:Goo000POol00fOPOomoo`1AOol00`00Oomoo`1@Ool00fOPOomoo`0YOol0
021oo`03In1oogoo03Qoo`@000Eoo`8000Eoo`@000Eoo`03001oogoo051oo`03In1oogoo02Uoo`00
87oo00=Wh7ooOol0=goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol0D7oo00=Wh7ooOol0:Goo000QOol00fOPOomoo`0fOol00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`1?Ool00fOPOomoo`0ZOol0025oo`03In1o
ogoo03Ioo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`80051oo`03In1oogoo02Yo
o`008Woo00=Wh7ooOol0=Goo00<007ooOol00Woo00<007ooOol02Goo10001Goo00<007ooOol0Cgoo
00=Wh7ooOol0:Woo000ROol00fOPOomoo`0eOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomo
o`06Ool00`00Oomoo`1?Ool00fOPOomoo`0ZOol0029oo`03In1oogoo03Eoo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo04ioo`03In1oogoo02]oo`008goo00=Wh7ooOol0
=Goo100037oo1@0017oo00<007ooOol0CWoo00=Wh7ooOol0:goo000SOol00fOPOomoo`1>Ool00`00
Oomoo`1>Ool00fOPOomoo`0[Ool002=oo`03In1oogoo04ioo`03001oogoo04eoo`03In1oogoo02ao
o`0097oo00=Wh7ooOol0CGoo00<007ooOol0CGoo00=Wh7ooOol0;7oo000TOol00fOPOomoo`1=Ool0
0`00Oomoo`1<Ool00fOPOomoo`0]Ool002Eoo`03In1oogoo04aoo`03001oogoo04aoo`03In1oogoo
02eoo`009Goo00=Wh7ooOol0C7oo00<007ooOol0Bgoo00=Wh7ooOol0;Woo000VOol00fOPOomoo`1;
Ool00`00Oomoo`1;Ool00fOPOomoo`0^Ool002Ioo`03In1oogoo04]oo`03001oogoo04Yoo`03In1o
ogoo02moo`009goo00=Wh7ooOol0BWoo00<007ooOol0BWoo00=Wh7ooOol0;goo000WOol00fOPOomo
o`1:Ool00`00Oomoo`19Ool00fOPOomoo`0`Ool002Qoo`03In1oogoo04Uoo`03001oogoo04Uoo`03
In1oogoo031oo`00:7oo00=Wh7ooOol0BGoo00<007ooOol0B7oo00=Wh7ooOol0<Goo000YOol00fOP
Oomoo`18Ool00`00Oomoo`18Ool00fOPOomoo`0aOol002Uoo`03In1oogoo04Qoo`03001oogoo04Mo
o`03In1oogoo039oo`00:Woo00=Wh7ooOol0Agoo00<007ooOol0Agoo00=Wh7ooOol0<Woo000[Ool0
0fOPOomoo`16Ool00`00Oomoo`16Ool00fOPOomoo`0cOol002]oo`03In1oogoo04Ioo`03001oogoo
04Ioo`03In1oogoo03=oo`00;7oo00=Wh7ooOol0AGoo00<007ooOol0AGoo00=Wh7ooOol0=7oo000/
Ool00fOPOomoo`15Ool00`00Oomoo`14Ool00fOPOomoo`0eOol002eoo`03In1oogoo03]oo`D000Ao
o`03001oogoo04=oo`03In1oogoo03Ioo`00;Goo00=Wh7ooOol0?Goo00<007ooOol017oo00<007oo
Ool0@goo00=Wh7ooOol0=Woo000^Ool00fOPOomoo`0lOol00`00Oomoo`04Ool00`00Oomoo`12Ool0
0fOPOomoo`0gOol002moo`03In1oogoo03]oo`03001oogoo00Aoo`80049oo`03In1oogoo03Qoo`00
<7oo00=Wh7ooOol0>Woo00<007ooOol017oo00<007ooOol0@7oo00=Wh7ooOol0>Goo000aOol00fOP
Oomoo`0iOol00`00Oomoo`04Ool00`00Oomoo`0oOol00fOPOomoo`0jOol0035oo`03In1oogoo03Mo
o`<000Ioo`03001oogoo03moo`03In1oogoo03Yoo`00<Woo00=Wh7ooOol0>7oo00<007ooOol017oo
00<007ooOol0?Woo00=Wh7ooOol0>goo000cOol00fOPOomoo`0nOol00`00Oomoo`0mOol00fOPOomo
o`0lOol003Aoo`03In1oogoo03eoo`03001oogoo03aoo`03In1oogoo03eoo`00=Goo00=Wh7ooOol0
?7oo00<007ooOol0>goo00=Wh7ooOol0?Woo000fOol2In0lOol00`00Oomoo`0iOol2In11Ool003Qo
o`03In1oogoo03Uoo`03001oogoo03Qoo`03In1oogoo045oo`00>Goo00=Wh7ooOol0>7oo00<007oo
Ool0=goo00=Wh7ooOol0@Woo000jOol00fOPOomoo`0gOol00`00Oomoo`0fOol00fOPOomoo`13Ool0
03]oo`03In1oogoo03Ioo`03001oogoo03Eoo`03In1oogoo04Aoo`00?7oo00=Wh7ooOol0=Goo00<0
07ooOol0=7oo00=Wh7ooOol0AGoo000mOol00fOPOomoo`0dOol00`00Oomoo`0cOol00fOPOomoo`16
Ool003ioo`03In1oogoo03=oo`03001oogoo039oo`03In1oogoo04Moo`00?goo00=Wh7ooOol0<Woo
00<007ooOol0<Goo00=Wh7ooOol0B7oo0010Ool2In0bOol00`00Oomoo`0_Ool2In1;Ool0049oo`9W
h31oo`03001oogoo02eoo`9Wh4eoo`00A7oo0VOP;Woo00<007ooOol0:goo0VOPCgoo0016Ool00fOP
Oomoo`0[Ool00`00Oomoo`0ZOol00fOPOomoo`1?Ool004Moo`9Wh2]oo`03001oogoo02Qoo`9Wh59o
o`00BGoo0VOP:Goo00<007ooOol09Woo0VOPE7oo001;Ool2In0WOol00`00Oomoo`0TOol2In1FOol0
04eoo`9Wh0aoo`D000Aoo`8000Eoo`@000Eoo`03001oogoo029oo`9Wh5Qoo`00Cgoo0VOP37oo00<0
07ooOol017oo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol087oo0VOPFWoo001A
Ool2In0:Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomoo`0NOol2In1LOol005=oo`=Wh0Mo
o`03001oogoo00moo`03001oogoo009oo`8001aoo`=Wh5ioo`00EWoo0VOP1Goo00<007ooOol02goo
10001Goo00<007ooOol06Goo0VOPHGoo001HOol3In02Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool0
0`00Oomoo`0FOol3In1SOol005]oo`=Wh0eoo`03001oogoo00Ioo`03001oogoo01=oo`=Wh6Ioo`00
GGoo00<006OPIn000VOP2Goo1@0017oo00<007ooOol03goo16OPJGoo001ROol6In0<Ool00`00Oomo
o`0:Ool5In1]Ool006QooaUWh79oo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Ao
o`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo
07aoo`00M7oo00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo
00<007ooOol0O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0
O7oo001dOol00`00Oomoo`1lOol007Aoo`03001oogoo07aoo`00M7oo00<007ooOol0O7oo001dOol0
0`00Oomoo`1lOol006Yoo`D000Eoo`03001oogoo07aoo`00JWoo00D007ooOomoo`0000Eoo`03001o
ogoo07aoo`00Jgoo00<007ooOol01Woo00<007ooOol0O7oo001/Ool00`00Oomoo`05Ool2001mOol0
06eoo`03001oogoo08=oo`00KWoo00<007ooOol0PWoo001ZOol01@00Oomoogoo0000Q7oo001[Ool3
0025Ool00?=oo`00lgoo003cOol00?=oo`00UGoo0`002goo1@0017oo0P0017oo1@00?7oo002DOol0
1P00Oomoogoo001oo`H000Eoo`03001oogoo00Aoo`8000Aoo`05001oogooOol0000lOol007=oo`80
0003Ool0000001aoo`03001oogoo00ioo`03001oogoo00]oo`03001oogoo03eoo`00LWoo00<007oo
Ool00P007Goo00<007ooOol00goo1P001Goo00<007ooOol037oo00<007ooOol0?7oo001bOol01@00
Oomoogoo00007Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol0>goo001bOol01@00Oomo
ogoo000077oo1@003Goo00<007ooOol03Woo00<007ooOol0>Woo001bOol01@00Oomoogoo00007Goo
00<007ooOol037oo0`0037oo00D007ooOomoo`0003aoo`00LGoo0P000Woo0P00;Woo00<007ooOol0
2goo0`00?Goo003cOol00?=oo`00lgoo003cOol00?=oo`00\
\>"],
  ImageRangeCache->{{{0, 242.75}, {242.75, 0}} -> {-2.15508, -2.10436, \
0.023187, 0.023187}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.15) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 .9 0 r

.5 Mabswid

.10869 .49991 m

.11036 .46389 L

.11535 .4281 L

.12363 .39291 L

.13511 .35864 L

.14971 .32558 L

.1673 .294 L

.18773 .26418 L

.21082 .23637 L

.23637 .21082 L

.26418 .18773 L

.294 .1673 L

.32558 .14971 L

.35864 .13511 L

.39291 .12363 L

.4281 .11535 L

.46389 .11036 L

.5 .10869 L

.53611 .11036 L

.5719 .11535 L

.60709 .12363 L

.64136 .13511 L

.67442 .14971 L

.706 .1673 L

.73582 .18773 L

.76363 .21082 L

.78918 .23637 L

.81227 .26418 L

.8327 .294 L

.85029 .32558 L

.86489 .35864 L

.87637 .39291 L

.88465 .4281 L

.88964 .46389 L

.89131 .49991 L

s

.10869 .50009 m

.11036 .53611 L

.11535 .5719 L

.12363 .60709 L

.13511 .64136 L

.14971 .67442 L

.1673 .706 L

.18773 .73582 L

.21082 .76363 L

.23637 .78918 L

.26418 .81227 L

.294 .8327 L

.32558 .85029 L

.35864 .86489 L

.39291 .87637 L

.4281 .88465 L

.46389 .88964 L

.5 .89131 L

.53611 .88964 L

.5719 .88465 L

.60709 .87637 L

.64136 .86489 L

.67442 .85029 L

.706 .8327 L

.73582 .81227 L

.76363 .78918 L

.78918 .76363 L

.81227 .73582 L

.8327 .706 L

.85029 .67442 L

.86489 .64136 L

.87637 .60709 L

.88465 .5719 L

.88964 .53611 L

.89131 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005Aooa9oP5eoo`00BGoo1@001Wn00Woo0P0017oo00<007ooOol01goo1Wn0Egoo
0019Ool5Oh07Ool01000Oomoo`000goo00<007ooOol03Goo1Gn0DWoo0016Ool3Oh02Ool00`00Oomo
o`0:Ool01000Oomoogoo0P004goo0gn0Cgoo0013Ool01000Oh1oP00017oo00<007ooOol027oo0P00
17oo00<007ooOol05Goo0Wn0CGoo0012Ool2Oh07Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00
Oomoo`0GOol2Oh1;Ool0041oo`9oP0Qoo`8000Yoo`<000=oo`03001oogoo01Uoo`9oP4Uoo`00?Woo
0Wn077oo0P0077oo00=oP7ooOol0AWoo000lOol2Oh0NOol00`00Oomoo`0LOol2Oh16Ool003Yoo`9o
P21oo`03001oogoo01ioo`9oP4Aoo`00>Goo00=oP7ooOol087oo00<007ooOol087oo0Wn0@Woo000g
Ool2Oh0SOol2000SOol2Oh10Ool003Eoo`9oP2Eoo`03001oogoo02Aoo`9oP3ioo`00=7oo00=oP7oo
Ool09Goo00<007ooOol09Woo00=oP7ooOol0>goo000cOol00gn0Oomoo`0VOol00`00Oomoo`0WOol0
0gn0Oomoo`0jOol0035oo`9oP2Uoo`8002Uoo`9oP3Yoo`00<7oo00=oP7ooOol0:Goo00<007ooOol0
:Woo00=oP7ooOol0=goo000_Ool00gn0Oomoo`0ZOol00`00Oomoo`0[Ool00gn0Oomoo`0fOol002io
o`03Oh1oogoo02]oo`03001oogoo02aoo`03Oh1oogoo03Eoo`00;Goo00=oP7ooOol0;7oo00<007oo
Ool0;Goo00=oP7ooOol0=7oo000]Ool00gn0Oomoo`0/Ool2000^Ool00gn0Oomoo`0dOol002aoo`03
Oh1oogoo02eoo`03001oogoo02ioo`03Oh1oogoo03=oo`00:goo00=oP7ooOol09goo1@000Woo00<0
07ooOol0;goo00=oP7ooOol0<Woo000ZOol00gn0Oomoo`0ZOol00`00Oomoo`02Ool00`00Oomoo`0`
Ool00gn0Oomoo`0aOol002Uoo`03Oh1oogoo02]oo`03001oogoo009oo`80039oo`03Oh1oogoo031o
o`00:Goo00=oP7ooOol08goo100017oo00<007ooOol00Woo00<007ooOol0<Goo00=oP7ooOol0<7oo
000XOol00gn0Oomoo`0/Ool00`00Oomoo`02Ool00`00Oomoo`0bOol00gn0Oomoo`0_Ool002Moo`03
Oh1oogoo02aoo`8000Aoo`03001oogoo03=oo`03Oh1oogoo02ioo`009Woo00=oP7ooOol0<goo0P00
=Goo00=oP7ooOol0;Goo000UOol00gn0Oomoo`0dOol00`00Oomoo`0eOol00gn0Oomoo`0/Ool002Eo
o`03Oh1oogoo03Aoo`03001oogoo03Eoo`03Oh1oogoo02aoo`0097oo00=oP7ooOol0=Goo00<007oo
Ool0=Woo00=oP7ooOol0:goo000SOol00gn0Oomoo`0fOol00`00Oomoo`0gOol00gn0Oomoo`0ZOol0
029oo`03Oh1oogoo03Moo`8003Uoo`03Oh1oogoo02Uoo`008Woo00=oP7ooOol0=goo00<007ooOol0
>7oo00=oP7ooOol0:Goo000QOol00gn0Oomoo`0hOol00`00Oomoo`0iOol00gn0Oomoo`0XOol0025o
o`03Oh1oogoo03Qoo`03001oogoo03Uoo`03Oh1oogoo02Qoo`0087oo00=oP7ooOol0>Goo0P00>goo
00=oP7ooOol09goo000OOol00gn0Oomoo`0jOol00`00Oomoo`0jOol00gn0Oomoo`0WOol001moo`03
Oh1oogoo03Yoo`03001oogoo03]oo`03Oh1oogoo02Ioo`007Woo00=oP7ooOol0>goo00<007ooOol0
>goo00=oP7ooOol09Woo000NOol00gn0Oomoo`0kOol2000lOol00gn0Oomoo`0VOol001eoo`03Oh1o
ogoo03aoo`03001oogoo03aoo`03Oh1oogoo02Eoo`007Goo00=oP7ooOol0?7oo00<007ooOol0?7oo
00=oP7ooOol09Goo000MOol00gn0Oomoo`0ZOol20004Ool20004Ool20004Ool00`00Oomoo`0lOol0
0gn0Oomoo`0UOol001aoo`03Oh1oogoo02Yoo`04001oogoo0008Ool01000Oomoo`000goo00<007oo
Ool0?Goo00=oP7ooOol097oo000LOol00gn0Oomoo`0ZOol01000Oomoo`002goo00@007ooOomoo`80
03ioo`03Oh1oogoo02Aoo`0077oo00=oP7ooOol097oo10000Woo00@007ooOol000Uoo`8000Aoo`03
001oogoo03eoo`03Oh1oogoo02Aoo`006goo00=oP7ooOol0:goo00@007ooOol000Uoo`03001oogoo
00=oo`03001oogoo03ioo`03Oh1oogoo02=oo`006goo00=oP7ooOol0;7oo0P002Woo0`000goo00<0
07ooOol0?Woo00=oP7ooOol08goo000KOol00gn0Oomoo`0nOol2000oOol00gn0Oomoo`0SOol001]o
o`03Oh1oogoo03ioo`03001oogoo03moo`03Oh1oogoo029oo`006Woo00=oP7ooOol0?goo00<007oo
Ool0?goo00=oP7ooOol08Woo000JOol00gn0Oomoo`0oOol00`00Oomoo`0oOol00gn0Oomoo`0ROol0
01Yoo`03Oh1oogoo03moo`80045oo`03Oh1oogoo025oo`006Woo00=oP7ooOol0?goo00<007ooOol0
@7oo00=oP7ooOol08Goo000JOol00gn0Oomoo`0oOol00`00Oomoo`10Ool00gn0Oomoo`0QOol000Mo
o`@000aoo`<00004Oh0007ooOol20004Ool2000<Ool5000<Ool20004Ool20004Ool2000;Ool00`00
Oomoo`0<Ool20004Ool20004Ool2000<Ool5000;Ool50002Ool2000017ooOh1oogoo0P003Goo1000
3Woo0007Ool00`00Oomoo`0?Ool00gn0Oomoo`07Ool01000Oomoo`003Goo00<007ooOol02goo00@0
07ooOol000Qoo`04001oogoo000:Ool00`00Oomoo`0;Ool01000Oomoo`0027oo00@007ooOol000eo
o`03001oogoo00eoo`03001oogoo00Eoo`03Oh1oo`00009oo`03001oogoo00Yoo`03001oogoo00mo
o`0027oo00<007ooOol03Woo00=oP7ooOol02Woo00<007ooOol02goo00<007ooOol02goo00@007oo
Ool000]oo`03001oogoo00Qoo`8000aoo`04001oogoo000;Ool00`00Oomoo`0;Ool00`00Oomoo`0=
Ool00`00Oomoo`05Ool00gn0Oomoo`02Ool00`00Oomoo`0;Ool00`00Oomoo`0>Ool00003Ool00000
008000Aoo`03001oogoo00Eoo`@000Aoo`03Oh1oogoo00Qoo`8000Ioo`@000Aoo`03001oogoo00Eo
o`@0009oo`04001oogoo0009Ool2000;Ool00`00Oomoo`0;Ool01000Oomoo`002Goo0P003Woo00<0
07ooOol03Goo00<007ooOol01Goo00=oP7ooOol00P003goo00<007ooOol03Goo0007Ool01000Oomo
o`003Woo00=oP7ooOol027oo00<007ooOol03Goo00<007ooOol02goo00@007ooOol000Uoo`03001o
ogoo00Yoo`03001oogoo00]oo`04001oogoo0009Ool00`00Oomoo`0=Ool00`00Oomoo`0=Ool00`00
Oomoo`05Ool017n0Oomoo`003Woo00@007ooOol000ioo`0027oo0P003Woo00<007n0Ool02Goo0`00
37oo0P003Woo0P002Woo0`002Woo00<007ooOol037oo0P002Woo0`0037oo0P003Woo0P001goo00=o
P7ooOol00`003Goo0P003goo000IOol00gn0Oomoo`10Ool20011Ool00gn0Oomoo`0QOol001Uoo`03
Oh1oogoo041oo`03001oogoo045oo`03Oh1oogoo021oo`006Goo00=oP7ooOol0@7oo00<007ooOol0
@Goo00=oP7ooOol087oo000IOol00gn0Oomoo`10Ool00`00Oomoo`11Ool00gn0Oomoo`0FOol20000
0goo00000005Ool000Iooa<00003Oh00000008@00003Oh000000014000Ioo`03001oo`0000Ioo`00
1Woo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00OomoP002Ool01@00Oomoogoo0000
0goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001o
ogoo009oo`05001oogooOol00003Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001o
ogoo009oo`05001oogooOol00002Ool00gn0001oo`03Ool01@00Oomoogoo00000goo00<007ooOol0
0Woo00<007ooOol01Goo00<007ooOol01Goo000IOol00gn0Oomoo`10Ool00`00Oomoo`11Ool00gn0
Oomoo`0FOol200000goo00000005Ool001Uoo`03Oh1oogoo041oo`03001oogoo041oo`03Oh1oogoo
025oo`006Goo00=oP7ooOol0@7oo0P00@Goo00=oP7ooOol08Goo000IOol00gn0Oomoo`10Ool00`00
Oomoo`10Ool00gn0Oomoo`0QOol001Uoo`03Oh1oogoo041oo`03001oogoo041oo`03Oh1oogoo025o
o`006Goo00=oP7ooOol0@7oo00<007ooOol0@7oo00=oP7ooOol08Goo000IOol00gn0Oomoo`10Ool0
0`00Oomoo`10Ool00gn0Oomoo`0QOol001Uoo`03Oh1oogoo041oo`80045oo`03Oh1oogoo025oo`00
6Woo00=oP7ooOol0?goo00<007ooOol0@7oo00=oP7ooOol08Goo000JOol00gn0Oomoo`0oOol00`00
Oomoo`10Ool00gn0Oomoo`0QOol001Yoo`03Oh1oogoo03moo`03001oogoo041oo`03Oh1oogoo025o
o`006Woo00=oP7ooOol0?goo0P00@Goo00=oP7ooOol08Goo000JOol00gn0Oomoo`0oOol00`00Oomo
o`10Ool00gn0Oomoo`0QOol001Yoo`03Oh1oogoo03moo`03001oogoo03moo`03Oh1oogoo029oo`00
6goo00=oP7ooOol0?Woo00<007ooOol0?goo00=oP7ooOol08Woo000KOol00gn0Oomoo`0nOol20010
Ool00gn0Oomoo`0ROol001]oo`03Oh1oogoo03ioo`03001oogoo03ioo`03Oh1oogoo02=oo`006goo
00=oP7ooOol0?Woo00<007ooOol0?Woo00=oP7ooOol08goo000KOol00gn0Oomoo`0/Ool20004Ool2
0004Ool20004Ool00`00Oomoo`0nOol00gn0Oomoo`0SOol001aoo`03Oh1oogoo02Yoo`04001oogoo
0008Ool01000Oomoo`000goo00<007ooOol0?Goo00=oP7ooOol097oo000LOol00gn0Oomoo`0ZOol0
1000Oomoo`002goo00@007ooOomoo`8003ioo`03Oh1oogoo02Aoo`0077oo00=oP7ooOol0:Woo00@0
07ooOol000Uoo`8000Aoo`03001oogoo03eoo`03Oh1oogoo02Aoo`007Goo00=oP7ooOol0:Goo00@0
07ooOol000Uoo`03001oogoo00=oo`03001oogoo03aoo`03Oh1oogoo02Eoo`007Goo00=oP7ooOol0
:Woo0P002Woo0`000goo00<007ooOol0?7oo00=oP7ooOol09Goo000NOol00gn0Oomoo`0kOol2000m
Ool00gn0Oomoo`0UOol001ioo`03Oh1oogoo03]oo`03001oogoo03]oo`03Oh1oogoo02Ioo`007goo
00=oP7ooOol0>Woo00<007ooOol0>goo00=oP7ooOol09Woo000OOol00gn0Oomoo`0jOol00`00Oomo
o`0jOol00gn0Oomoo`0WOol0021oo`03Oh1oogoo03Uoo`8003]oo`03Oh1oogoo02Moo`008Goo00=o
P7ooOol0>7oo00<007ooOol0>Goo00=oP7ooOol0:7oo000QOol00gn0Oomoo`0hOol00`00Oomoo`0i
Ool00gn0Oomoo`0XOol0029oo`03Oh1oogoo03Moo`03001oogoo03Qoo`03Oh1oogoo02Uoo`008Woo
00=oP7ooOol0=goo00<007ooOol0>7oo00=oP7ooOol0:Goo000SOol00gn0Oomoo`0fOol2000hOol0
0gn0Oomoo`0ZOol002=oo`03Oh1oogoo03Ioo`03001oogoo03Moo`03Oh1oogoo02Yoo`0097oo00=o
P7ooOol0=Goo00<007ooOol0=Woo00=oP7ooOol0:goo000UOol00gn0Oomoo`0dOol00`00Oomoo`0e
Ool00gn0Oomoo`0/Ool002Eoo`03Oh1oogoo03Aoo`8003Ioo`03Oh1oogoo02aoo`009Woo00=oP7oo
Ool0<goo00<007ooOol0=7oo00=oP7ooOol0;Goo000WOol00gn0Oomoo`0[Ool50002Ool00`00Oomo
o`0cOol00gn0Oomoo`0^Ool002Qoo`03Oh1oogoo02aoo`03001oogoo009oo`03001oogoo039oo`03
Oh1oogoo02moo`00:Goo00=oP7ooOol0:goo00<007ooOol00Woo0P00<Woo00=oP7ooOol0<7oo000Y
Ool00gn0Oomoo`0[Ool00`00Oomoo`02Ool00`00Oomoo`0aOol00gn0Oomoo`0`Ool002Yoo`03Oh1o
ogoo02Yoo`03001oogoo009oo`03001oogoo031oo`03Oh1oogoo035oo`00:goo00=oP7ooOol0:7oo
0P0017oo00<007ooOol0;goo00=oP7ooOol0<Woo000/Ool00gn0Oomoo`0]Ool00`00Oomoo`0^Ool0
0gn0Oomoo`0cOol002eoo`03Oh1oogoo02aoo`8002ioo`03Oh1oogoo03Aoo`00;Woo00=oP7ooOol0
:goo00<007ooOol0;7oo00=oP7ooOol0=Goo000_Ool00gn0Oomoo`0ZOol00`00Oomoo`0[Ool00gn0
Oomoo`0fOol0031oo`03Oh1oogoo02Uoo`03001oogoo02Yoo`03Oh1oogoo03Moo`00<Goo0Wn0:Goo
0P00:Goo0Wn0>Woo000cOol00gn0Oomoo`0VOol00`00Oomoo`0WOol00gn0Oomoo`0jOol003Aoo`03
Oh1oogoo02Eoo`03001oogoo02Ioo`03Oh1oogoo03]oo`00=Goo0Wn09Goo00<007ooOol097oo0Wn0
?Woo000gOol2Oh0SOol2000SOol2Oh10Ool003Uoo`03Oh1oogoo021oo`03001oogoo025oo`03Oh1o
ogoo041oo`00>Woo00=oP7ooOol07goo00<007ooOol07goo0Wn0@goo000kOol2Oh0OOol00`00Oomo
o`0NOol00gn0Oomoo`13Ool003eoo`03Oh1oogoo01aoo`8001eoo`9oP4Ioo`00?Woo0Wn077oo00<0
07ooOol06Woo0Wn0B7oo0010Ool3Oh0IOol00`00Oomoo`0HOol2Oh1:Ool004=oo`=oP0=oo`D0009o
o`8000Aoo`8000Aoo`03001oogoo01Eoo`=oP4aoo`00AWoo0gn00Woo00<007ooOol01goo00@007oo
Ool000=oo`03001oogoo019oo`=oP4moo`00BGoo17n02goo00@007ooOomoo`8000moo`AoP59oo`00
Bgoo00<007ooOh001Gn00goo0P0017oo00<007ooOol027oo1Wn0EWoo001;Ool00`00Oomoo`05Ool6
Oh03Ool01000Oomoogoo1gn0G7oo001:Ool2000:Ool30007Oh1SOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1T
Ool005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo
06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005Eoo`@000=oo`03001oogoo06Aoo`00EGoo
00<007ooOol017oo00<007ooOol0I7oo001FOol00`00Oomoo`03Ool2001UOol005Moo`03001oogoo
06Uoo`00EGoo00@007ooOol006Yoo`00EWoo0P00Jgoo0033Ool00<=oo`00`goo001cOol20003Ool4
0002Ool50002Ool20003Ool50002Ool2000`Ool0079oo`04001oogoo000:Ool00`00Oomoo`09Ool0
1@00Oomoogoo00000Woo00<007ooOol0;Goo001KOol4000COol00`00Oomoo`03Ool40004Ool00`00
Oomoo`09Ool00`00Oomoo`04Ool00`00Oomoo`0]Ool005Yoo`04001oogoo000COol5000:Ool00`00
Oomoo`09Ool00`00Oomoo`02Ool2000`Ool005Yoo`04001oogoo000DOol00`00Oomoo`0;Ool00`00
Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`0_Ool005Uoo`800003Ool00000025oo`8000Yoo`80
00Aoo`<002moo`00`goo0033Ool00<=oo`00`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.1) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 .6 0 r

.5 Mabswid

.12086 .49991 m

.12247 .46502 L

.12731 .43033 L

.13533 .39624 L

.14646 .36304 L

.1606 .331 L

.17765 .30041 L

.19744 .27151 L

.21981 .24457 L

.24457 .21981 L

.27151 .19744 L

.30041 .17765 L

.331 .1606 L

.36304 .14646 L

.39624 .13533 L

.43033 .12731 L

.46502 .12247 L

.5 .12086 L

.53498 .12247 L

.56967 .12731 L

.60376 .13533 L

.63696 .14646 L

.669 .1606 L

.69959 .17765 L

.72849 .19744 L

.75543 .21981 L

.78019 .24457 L

.80256 .27151 L

.82235 .30041 L

.8394 .331 L

.85354 .36304 L

.86467 .39624 L

.87269 .43033 L

.87753 .46502 L

.87914 .49991 L

s

.12086 .50009 m

.12247 .53498 L

.12731 .56967 L

.13533 .60376 L

.14646 .63696 L

.1606 .669 L

.17765 .69959 L

.19744 .72849 L

.21981 .75543 L

.24457 .78019 L

.27151 .80256 L

.30041 .82235 L

.331 .8394 L

.36304 .85354 L

.39624 .86467 L

.43033 .87269 L

.46502 .87753 L

.5 .87914 L

.53498 .87753 L

.56967 .87269 L

.60376 .86467 L

.63696 .85354 L

.669 .8394 L

.69959 .82235 L

.72849 .80256 L

.75543 .78019 L

.78019 .75543 L

.80256 .72849 L

.82235 .69959 L

.8394 .669 L

.85354 .63696 L

.86467 .60376 L

.87269 .56967 L

.87753 .53498 L

.87914 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`06OolAOT1NOol004]oo`03001oogoo00In@0Aoo`04001oogooOol20007
Ool6OT1HOol004=oo`@0009oo`En@0Qoo`8000Aoo`03001oogoo00aoo`En@5=oo`00Agoo0Wi00Woo
00<007ooOol027oo00<007ooOol00goo00<007ooOol04Goo0gi0D7oo0015Ool2OT03Ool2000:Ool3
0003Ool00`00Oomoo`0DOol2OT1>Ool004=oo`9n@1Moo`8001Moo`9n@4aoo`00@Goo0Wi06Goo00<0
07ooOol067oo0Wi0BWoo000oOol2OT0KOol00`00Oomoo`0JOol00gi0Oomoo`17Ool003eoo`9n@1eo
o`03001oogoo01]oo`9n@4Moo`00>goo0Wi07goo0P007Woo0Wi0AGoo000jOol00gi0Oomoo`0OOol0
0`00Oomoo`0OOol2OT13Ool003Qoo`9n@29oo`03001oogoo025oo`9n@45oo`00=Woo0Wi097oo00<0
07ooOol08goo0Wi0?goo000eOol00gi0Oomoo`0TOol2000VOol00gi0Oomoo`0lOol003Aoo`03OT1o
ogoo02Eoo`03001oogoo02Ioo`03OT1oogoo03]oo`00<Woo0Wi0:7oo00<007ooOol09goo00=n@7oo
Ool0>Woo000aOol00gi0Oomoo`0XOol00`00Oomoo`0XOol00gi0Oomoo`0iOol0031oo`03OT1oogoo
02Uoo`03001oogoo02Uoo`03OT1oogoo03Qoo`00;goo00=n@7ooOol0:Woo0P00:goo00=n@7ooOol0
=goo000^Ool00gi0Oomoo`0[Ool00`00Oomoo`0[Ool2OT0gOol002eoo`03OT1oogoo02Eoo`D0009o
o`03001oogoo02eoo`03OT1oogoo03Aoo`00;7oo00=n@7ooOol0:7oo00<007ooOol00Woo00<007oo
Ool0;Woo00=n@7ooOol0<goo000[Ool00gi0Oomoo`0YOol00`00Oomoo`02Ool2000`Ool00gi0Oomo
o`0bOol002Yoo`03OT1oogoo029oo`@000Aoo`03001oogoo009oo`03001oogoo02moo`03OT1oogoo
039oo`00:Woo00=n@7ooOol0:Woo00<007ooOol00Woo00<007ooOol0<7oo00=n@7ooOol0<Goo000Y
Ool00gi0Oomoo`0ZOol20004Ool00`00Oomoo`0`Ool00gi0Oomoo`0aOol002Qoo`03OT1oogoo035o
o`80039oo`03OT1oogoo031oo`009goo00=n@7ooOol0<Woo00<007ooOol0<Woo00=n@7ooOol0;goo
000WOol00gi0Oomoo`0bOol00`00Oomoo`0cOol00gi0Oomoo`0^Ool002Ioo`03OT1oogoo03=oo`03
001oogoo03=oo`03OT1oogoo02ioo`009Woo00=n@7ooOol0<goo00<007ooOol0=7oo00=n@7ooOol0
;Goo000UOol00gi0Oomoo`0dOol2000fOol00gi0Oomoo`0/Ool002Aoo`03OT1oogoo03Eoo`03001o
ogoo03Ioo`03OT1oogoo02]oo`0097oo00=n@7ooOol0=Goo00<007ooOol0=Woo00=n@7ooOol0:goo
000SOol00gi0Oomoo`0fOol00`00Oomoo`0gOol00gi0Oomoo`0ZOol002=oo`03OT1oogoo03Ioo`80
03Qoo`03OT1oogoo02Yoo`008Woo00=n@7ooOol0=goo00<007ooOol0>7oo00=n@7ooOol0:Goo000Q
Ool00gi0Oomoo`0hOol00`00Oomoo`0hOol00gi0Oomoo`0YOol0025oo`03OT1oogoo03Qoo`03001o
ogoo03Uoo`03OT1oogoo02Qoo`0087oo00=n@7ooOol0>Goo0P00>Woo00=n@7ooOol0:7oo000POol0
0gi0Oomoo`0iOol00`00Oomoo`0iOol00gi0Oomoo`0XOol001moo`03OT1oogoo03Yoo`03001oogoo
03Yoo`03OT1oogoo02Moo`007goo00=n@7ooOol0:7oo0P0017oo0P0017oo0P0017oo00<007ooOol0
>Woo00=n@7ooOol09goo000OOol00gi0Oomoo`0WOol01000Oomoo`0027oo00@007ooOol000=oo`03
001oogoo03Yoo`03OT1oogoo02Moo`007goo00=n@7ooOol09goo00@007ooOol000]oo`04001oogoo
Ool2000lOol00gi0Oomoo`0VOol001ioo`03OT1oogoo029oo`@0009oo`04001oogoo0009Ool20004
Ool00`00Oomoo`0kOol00gi0Oomoo`0VOol001ioo`03OT1oogoo02Qoo`04001oogoo0009Ool00`00
Oomoo`03Ool00`00Oomoo`0lOol00gi0Oomoo`0UOol001ioo`03OT1oogoo02Uoo`8000Yoo`<000=o
o`03001oogoo03aoo`03OT1oogoo02Eoo`007Woo00=n@7ooOol0>goo0P00?Goo00=n@7ooOol09Goo
000MOol00gi0Oomoo`0lOol00`00Oomoo`0mOol00gi0Oomoo`0TOol001eoo`03OT1oogoo03aoo`03
001oogoo03eoo`03OT1oogoo02Aoo`007Goo00=n@7ooOol0?7oo00<007ooOol0?Goo00=n@7ooOol0
97oo000LOol00gi0Oomoo`0mOol2000oOol00gi0Oomoo`0SOol001aoo`03OT1oogoo03eoo`03001o
ogoo03ioo`03OT1oogoo02=oo`0077oo00=n@7ooOol0?Goo00<007ooOol0?Woo00=n@7ooOol08goo
0007Ool4000<Ool5000017i0Ool0000017oo0P0037oo1@0037oo0P0017oo0P0017oo0P002goo00<0
07ooOol037oo0P0017oo0P0017oo0P0037oo1@002goo1@000Woo00<007i0Ool00goo0P003Goo1000
3Woo0007Ool00`00Oomoo`0?Ool00`00Oomn@007Ool01000Oomoo`003Goo00<007ooOol02goo00@0
07ooOol000Qoo`04001oogoo000:Ool00`00Oomoo`0;Ool01000Oomoo`0027oo00@007ooOol000eo
o`03001oogoo00eoo`03001oogoo00=oo`05OT1oogooOol00002Ool00`00Oomoo`0:Ool00`00Oomo
o`0?Ool000Qoo`03001oogoo00ioo`03001oogi000Yoo`03001oogoo00]oo`03001oogoo00]oo`04
001oogoo000;Ool00`00Oomoo`08Ool2000<Ool01000Oomoo`002goo00<007ooOol02goo00<007oo
Ool03Goo00<007ooOol00goo00=n@7ooOol017oo00<007ooOol02goo00<007ooOol03Woo00000goo
000000020004Ool00`00Oomoo`05Ool40004Ool00`00Oomn@008Ool20006Ool40004Ool00`00Oomo
o`05Ool40002Ool01000Oomoo`002Goo0P002goo00<007ooOol02goo00@007ooOol000Uoo`8000io
o`03001oogoo00eoo`03001oogoo00=oo`03OT1oogoo009oo`8000moo`03001oogoo00eoo`001goo
00@007ooOol000ioo`03001oogi000Qoo`03001oogoo00eoo`03001oogoo00]oo`04001oogoo0009
Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol03Goo00<007ooOol0
3Goo00<007ooOol00goo00=n@7ooOol00Woo00<007ooOol037oo00@007ooOol000ioo`0027oo0P00
3Woo0P0000=oogi0Ool01goo0`0037oo0P003Woo0P002Woo0`002Woo00<007ooOol037oo0P002Woo
0`0037oo0P003Woo0P001Goo00=n@7ooOol00Woo0`003Goo0P003goo000KOol00gi0Oomoo`0nOol2
000oOol00gi0Oomoo`0SOol001]oo`03OT1oogoo03ioo`03001oogoo03moo`03OT1oogoo029oo`00
6goo00=n@7ooOol0?Woo00<007ooOol0?goo00=n@7ooOol08Woo000KOol00gi0Oomoo`0nOol00`00
Oomoo`0oOol00gi0Oomoo`0HOol200000goo00000005Ool000IooaD00003OT00000008000003OT00
000001<000Ioo`03001oo`0000Ioo`001Woo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool0
1P00OomoogooOT0000=oo`05001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo
00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo000017oo
00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00
Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`05001oogooOol00004Ool01@00
Oomoogoo00000goo00<007ooOol00Woo00H007ooOomoo`00OT02Ool00`00Oomoo`02Ool01@00Oomo
ogoo00000goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo000KOol00gi0Oomoo`0n
Ool00`00Oomoo`0oOol00gi0Oomoo`0HOol200000goo00000005Ool001]oo`03OT1oogoo03ioo`03
001oogoo03ioo`03OT1oogoo02=oo`006goo00=n@7ooOol0?Woo0P00?goo00=n@7ooOol08goo000K
Ool00gi0Oomoo`0nOol00`00Oomoo`0nOol00gi0Oomoo`0SOol001]oo`03OT1oogoo03ioo`03001o
ogoo03ioo`03OT1oogoo02=oo`006goo00=n@7ooOol0?Woo00<007ooOol0?Woo00=n@7ooOol08goo
000KOol00gi0Oomoo`0nOol00`00Oomoo`0nOol00gi0Oomoo`0SOol001aoo`03OT1oogoo03eoo`80
03moo`03OT1oogoo02=oo`0077oo00=n@7ooOol0?Goo00<007ooOol0?Woo00=n@7ooOol08goo000L
Ool00gi0Oomoo`0mOol00`00Oomoo`0nOol00gi0Oomoo`0SOol001aoo`03OT1oogoo03eoo`03001o
ogoo03ioo`03OT1oogoo02=oo`0077oo00=n@7ooOol0?Goo0P00?goo00=n@7ooOol08goo000MOol0
0gi0Oomoo`0lOol00`00Oomoo`0mOol00gi0Oomoo`0TOol001eoo`03OT1oogoo03aoo`03001oogoo
03eoo`03OT1oogoo02Aoo`007Goo00=n@7ooOol0?7oo00<007ooOol0?Goo00=n@7ooOol097oo000N
Ool00gi0Oomoo`0kOol2000mOol00gi0Oomoo`0UOol001ioo`03OT1oogoo03]oo`03001oogoo03ao
o`03OT1oogoo02Eoo`007Woo00=n@7ooOol0>goo00<007ooOol0?7oo00=n@7ooOol09Goo000NOol0
0gi0Oomoo`0YOol20004Ool20004Ool20004Ool00`00Oomoo`0kOol00gi0Oomoo`0VOol001moo`03
OT1oogoo02Moo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol0>goo00=n@7ooOol09Woo
000OOol00gi0Oomoo`0WOol01000Oomoo`002goo00@007ooOomoo`8003aoo`03OT1oogoo02Ioo`00
7goo00=n@7ooOol09goo00@007ooOol000Uoo`8000Aoo`03001oogoo03Yoo`03OT1oogoo02Moo`00
7goo00=n@7ooOol09goo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo03Yoo`03OT1oogoo
02Moo`0087oo00=n@7ooOol09goo0P002Woo0`000goo00<007ooOol0>Woo00=n@7ooOol09goo000P
Ool00gi0Oomoo`0iOol2000jOol00gi0Oomoo`0XOol0025oo`03OT1oogoo03Qoo`03001oogoo03Uo
o`03OT1oogoo02Qoo`008Goo00=n@7ooOol0>7oo00<007ooOol0>7oo00=n@7ooOol0:Goo000ROol0
0gi0Oomoo`0gOol00`00Oomoo`0hOol00gi0Oomoo`0YOol002=oo`03OT1oogoo03Ioo`8003Qoo`03
OT1oogoo02Yoo`008goo00=n@7ooOol0=Woo00<007ooOol0=goo00=n@7ooOol0:Woo000TOol00gi0
Oomoo`0eOol00`00Oomoo`0fOol00gi0Oomoo`0[Ool002Aoo`03OT1oogoo03Eoo`03001oogoo03Io
o`03OT1oogoo02]oo`009Goo00=n@7ooOol0=7oo00<007ooOol0=Goo00=n@7ooOol0;7oo000UOol0
0gi0Oomoo`0dOol2000fOol00gi0Oomoo`0/Ool002Ioo`03OT1oogoo03=oo`03001oogoo03Aoo`03
OT1oogoo02eoo`009Woo00=n@7ooOol0<goo00<007ooOol0<goo00=n@7ooOol0;Woo000WOol00gi0
Oomoo`0bOol00`00Oomoo`0cOol00gi0Oomoo`0^Ool002Moo`03OT1oogoo039oo`8003=oo`03OT1o
ogoo02moo`00:7oo00=n@7ooOol0<Goo00<007ooOol0<Goo00=n@7ooOol0<7oo000YOol00gi0Oomo
o`0YOol50002Ool00`00Oomoo`0`Ool00gi0Oomoo`0aOol002Yoo`03OT1oogoo02Yoo`03001oogoo
009oo`03001oogoo02moo`03OT1oogoo039oo`00:goo00=n@7ooOol0:Goo00<007ooOol00Woo0P00
<7oo00=n@7ooOol0<Woo000/Ool00gi0Oomoo`0XOol00`00Oomoo`02Ool00`00Oomoo`0^Ool00gi0
Oomoo`0cOol002eoo`03OT1oogoo02Moo`03001oogoo009oo`03001oogoo02eoo`03OT1oogoo03Ao
o`00;Woo00=n@7ooOol09Goo0P0017oo00<007ooOol0:goo0Wi0=goo000_Ool00gi0Oomoo`0ZOol0
0`00Oomoo`0ZOol00gi0Oomoo`0gOol0031oo`03OT1oogoo02Uoo`8002Yoo`03OT1oogoo03Qoo`00
<Goo00=n@7ooOol0:7oo00<007ooOol0:7oo00=n@7ooOol0>Goo000bOol2OT0XOol00`00Oomoo`0W
Ool00gi0Oomoo`0jOol003Aoo`03OT1oogoo02Eoo`03001oogoo02Ioo`03OT1oogoo03]oo`00=Goo
00=n@7ooOol097oo0P009Woo00=n@7ooOol0?7oo000fOol00gi0Oomoo`0SOol00`00Oomoo`0TOol0
0gi0Oomoo`0mOol003Moo`9n@2=oo`03001oogoo029oo`9n@41oo`00>Goo00=n@7ooOol087oo00<0
07ooOol08Goo00=n@7ooOol0@7oo000jOol00gi0Oomoo`0OOol2000QOol00gi0Oomoo`11Ool003]o
o`9n@1moo`03001oogoo01ioo`9n@4Aoo`00?Goo0Wi07Goo00<007ooOol077oo0Wi0AWoo000oOol2
OT0KOol00`00Oomoo`0IOol3OT18Ool0045oo`=n@1Qoo`8001Qoo`9n@4]oo`00A7oo0gi05Goo00<0
07ooOol057oo0gi0CGoo0017Ool2OT0COol00`00Oomoo`0AOol3OT1@Ool004Uoo`An@003001oogoo
008000Aoo`8000Aoo`03001oogoo00eoo`An@5=oo`00Bgoo00<007ooOT001Gi00Woo00@007ooOol0
00=oo`03001oogoo00Moo`In@5Moo`00Bgoo00<007ooOol01Goo4gi0GGoo001;Ool00`00Oomoo`08
Ool20004Ool00`00Oomoo`1TOol004]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Ao
o`00BWoo0P002Woo0`000goo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001U
Ool005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`80
06Eoo`00G7oo00<007ooOol0I7oo001EOol40003Ool00`00Oomoo`1TOol005Eoo`03001oogoo00Ao
o`03001oogoo06Aoo`00EWoo00<007ooOol00goo0P00IGoo001GOol00`00Oomoo`1YOol005Eoo`04
001oogoo001ZOol005Ioo`8006]oo`00`goo0033Ool00<=oo`00MWoo0P000goo10000Woo1@000Woo
0P000goo1@00<Goo001eOol01000Oomoo`002Woo00<007ooOol02Goo00<007ooOol0<Goo001KOol4
000FOol00`00Oomoo`03Ool40004Ool00`00Oomoo`09Ool00`00Oomoo`0aOol005Yoo`04001oogoo
000FOol5000:Ool00`00Oomoo`09Ool00`00Oomoo`0aOol005Yoo`04001oogoo000GOol00`00Oomo
o`0;Ool00`00Oomoo`09Ool00`00Oomoo`0aOol005Uoo`800003Ool0000002Aoo`8000Yoo`8003=o
o`00`goo0033Ool00<=oo`00`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.05) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 .3 0 r

.5 Mabswid

.13343 .49991 m

.13499 .46618 L

.13967 .43264 L

.14742 .39968 L

.15818 .36758 L

.17186 .3366 L

.18833 .30702 L

.20747 .27909 L

.2291 .25304 L

.25304 .2291 L

.27909 .20747 L

.30702 .18833 L

.3366 .17186 L

.36758 .15818 L

.39968 .14742 L

.43264 .13967 L

.46618 .13499 L

.5 .13343 L

.53382 .13499 L

.56736 .13967 L

.60032 .14742 L

.63242 .15818 L

.6634 .17186 L

.69298 .18833 L

.72091 .20747 L

.74696 .2291 L

.7709 .25304 L

.79253 .27909 L

.81167 .30702 L

.82814 .3366 L

.84182 .36758 L

.85258 .39968 L

.86033 .43264 L

.86501 .46618 L

.86657 .49991 L

s

.13343 .50009 m

.13499 .53382 L

.13967 .56736 L

.14742 .60032 L

.15818 .63242 L

.17186 .6634 L

.18833 .69298 L

.20747 .72091 L

.2291 .74696 L

.25304 .7709 L

.27909 .79253 L

.30702 .81167 L

.3366 .82814 L

.36758 .84182 L

.39968 .85258 L

.43264 .86033 L

.46618 .86501 L

.5 .86657 L

.53382 .86501 L

.56736 .86033 L

.60032 .85258 L

.63242 .84182 L

.6634 .82814 L

.69298 .81167 L

.72091 .79253 L

.74696 .7709 L

.7709 .74696 L

.79253 .72091 L

.81167 .69298 L

.82814 .6634 L

.84182 .63242 L

.85258 .60032 L

.86033 .56736 L

.86501 .53382 L

.86657 .50009 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`07Ool@OB1NOol004]oo`04001oogoo
Ool6OB000goo001oo`04Ool00`00Oomoo`06Ool6OB1HOol004Yoo`Em80Moo`<000=oo`03001oogoo
00aoo`Em85=oo`00B7oo0WdP4Woo0P004Woo0WdPDGoo0016Ool2OB0DOol00`00Oomoo`0COol2OB1?
Ool004Aoo`9m81Ioo`03001oogoo01Eoo`9m84eoo`00@Woo0WdP67oo00<007ooOol05goo0WdPBgoo
000oOol3OB0JOol2000JOol3OB18Ool003eoo`9m81eoo`03001oogoo01aoo`9m84Ioo`00>goo0WdP
7goo00<007ooOol07Woo0WdPA7oo000jOol00gdPOomoo`0OOol00`00Oomoo`0POol00gdPOomoo`11
Ool003Qoo`9m829oo`80029oo`03OB1oogoo041oo`00=goo00=m87ooOol08Woo00<007ooOol08Woo
00=m87ooOol0?goo000fOol00gdPOomoo`0SOol00`00Oomoo`0SOol00gdPOomoo`0nOol003Eoo`03
OB1oogoo02Aoo`03001oogoo02Aoo`9m83ioo`00<goo0WdP9goo00<007ooOol09Woo0WdP?7oo000b
Ool00gdPOomoo`0WOol2000YOol00gdPOomoo`0iOol0035oo`03OB1oogoo02Qoo`03001oogoo02Uo
o`03OB1oogoo03Qoo`00<7oo00=m87ooOol08Woo1@000Woo00<007ooOol0:Woo00=m87ooOol0=goo
000`Ool00gdPOomoo`0TOol00`00Oomoo`02Ool00`00Oomoo`0ZOol00gdPOomoo`0gOol002moo`03
OB1oogoo02Eoo`03001oogoo009oo`8002aoo`03OB1oogoo03Ioo`00;Woo00=m87ooOol07Woo1000
17oo00<007ooOol00Woo00<007ooOol0;7oo00=m87ooOol0=Goo000]Ool00gdPOomoo`0WOol00`00
Oomoo`02Ool00`00Oomoo`0]Ool00gdPOomoo`0dOol002aoo`03OB1oogoo02Moo`8000Aoo`03001o
ogoo02ioo`03OB1oogoo03=oo`00:goo00=m87ooOol0;Woo0P00<7oo00=m87ooOol0<Woo000ZOol0
0gdPOomoo`0_Ool00`00Oomoo`0`Ool00gdPOomoo`0aOol002Uoo`03OB1oogoo031oo`03001oogoo
035oo`03OB1oogoo031oo`00:Goo00=m87ooOol0<7oo00<007ooOol0<Goo00=m87ooOol0<7oo000X
Ool00gdPOomoo`0aOol00`00Oomoo`0bOol00gdPOomoo`0_Ool002Qoo`03OB1oogoo035oo`8003=o
o`03OB1oogoo02moo`009goo00=m87ooOol0<Woo00<007ooOol0<goo00=m87ooOol0;Woo000VOol0
0gdPOomoo`0cOol00`00Oomoo`0dOol00gdPOomoo`0]Ool002Ioo`03OB1oogoo03=oo`03001oogoo
03Aoo`03OB1oogoo02eoo`009Goo00=m87ooOol0=7oo0P00=Woo00=m87ooOol0;7oo000UOol00gdP
Oomoo`0dOol00`00Oomoo`0eOol00gdPOomoo`0/Ool002Aoo`03OB1oogoo03Eoo`03001oogoo03Io
o`03OB1oogoo02]oo`008goo00=m87ooOol0=Woo00<007ooOol0=Woo00=m87ooOol0:goo000SOol0
0gdPOomoo`0fOol2000hOol00gdPOomoo`0ZOol0029oo`03OB1oogoo03Moo`03001oogoo03Moo`03
OB1oogoo02Yoo`008Woo00=m87ooOol0=goo00<007ooOol0>7oo00=m87ooOol0:Goo000QOol00gdP
Oomoo`0VOol20004Ool20004Ool20004Ool00`00Oomoo`0hOol00gdPOomoo`0YOol0025oo`03OB1o
ogoo02Eoo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol0>7oo00=m87ooOol0:Goo000Q
Ool00gdPOomoo`0UOol01000Oomoo`002goo00@007ooOomoo`8003Yoo`03OB1oogoo02Qoo`0087oo
00=m87ooOol087oo10000Woo00@007ooOol000Uoo`8000Aoo`03001oogoo03Uoo`03OB1oogoo02Qo
o`0087oo00=m87ooOol09Woo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo03Uoo`03OB1o
ogoo02Qoo`0087oo00=m87ooOol09goo0P002Woo0`000goo00<007ooOol0>Woo00=m87ooOol09goo
000POol00gdPOomoo`0iOol2000kOol00gdPOomoo`0WOol0021oo`03OB1oogoo03Uoo`03001oogoo
03Yoo`03OB1oogoo02Moo`007goo00=m87ooOol0>Woo00<007ooOol0>Woo00=m87ooOol09goo000O
Ool00gdPOomoo`0jOol00`00Oomoo`0kOol00gdPOomoo`0VOol001moo`03OB1oogoo03Yoo`8003ao
o`03OB1oogoo02Ioo`007Woo00=m87ooOol0>goo00<007ooOol0>goo00=m87ooOol09Woo000NOol0
0gdPOomoo`0kOol00`00Oomoo`0kOol00gdPOomoo`0VOol000Moo`@000aoo`D0009oo`03OB0007oo
00=oo`8000aoo`D000aoo`8000Aoo`8000Aoo`8000]oo`03001oogoo00aoo`8000Aoo`8000Aoo`80
00aoo`D000]oo`D00004OB1oo`000004Ool2000=Ool4000>Ool000Moo`03001oogoo00moo`03001o
ogoo009oo`03OB1oogoo009oo`04001oogoo000=Ool00`00Oomoo`0;Ool01000Oomoo`0027oo00@0
07ooOol000Yoo`03001oogoo00]oo`04001oogoo0008Ool01000Oomoo`003Goo00<007ooOol03Goo
00@007ooOomm80Ioo`04001oogoo000<Ool00`00Oomoo`0?Ool000Qoo`03001oogoo00ioo`05001o
ogooOomm8008Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool01000Oomoo`002goo00<007ooOol027oo
0P0037oo00@007ooOol000]oo`03001oogoo00]oo`03001oogoo00eoo`05001oogooOomm8008Ool0
0`00Oomoo`0;Ool00`00Oomoo`0>Ool00003Ool00000008000Aoo`03001oogoo00Eoo`@000Aoo`05
001oogooOomm8006Ool20006Ool40004Ool00`00Oomoo`05Ool40002Ool01000Oomoo`002Goo0P00
2goo00<007ooOol02goo00@007ooOol000Uoo`8000ioo`03001oogoo00eoo`05001oogooOomm8006
Ool2000?Ool00`00Oomoo`0=Ool000Moo`04001oogoo000>Ool01@00OomoogooOB001Woo00<007oo
Ool03Goo00<007ooOol02goo00@007ooOol000Uoo`03001oogoo00Yoo`03001oogoo00]oo`04001o
ogoo0009Ool00`00Oomoo`0=Ool00`00Oomoo`0=Ool01@00OomoogooOB001Woo00<007ooOol037oo
00@007ooOol000ioo`0027oo0P003Woo0P000goo00=m87ooOol017oo0`0037oo0P003Woo0P002Woo
0`002Woo00<007ooOol037oo0P002Woo0`0037oo0P003Woo0P000goo00=m87ooOol017oo0`003Goo
0P003goo000MOol00gdPOomoo`0lOol2000mOol00gdPOomoo`0UOol001eoo`03OB1oogoo03aoo`03
001oogoo03eoo`03OB1oogoo02Aoo`007Goo00=m87ooOol0?7oo00<007ooOol0?Goo00=m87ooOol0
97oo000MOol00gdPOomoo`0lOol00`00Oomoo`0mOol00gdPOomoo`0JOol200000goo00000005Ool0
00IooaL00003OB00000007`00003OB00000001D000Ioo`03001oo`0000Ioo`001Woo00D007ooOomo
o`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00OB1oogoo00000goo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool0
1@00Oomoogoo00000goo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool0
1@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001o
ogooOol00003Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001o
ogooOB000003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol0
1Goo00<007ooOol01Goo000MOol00gdPOomoo`0lOol00`00Oomoo`0mOol00gdPOomoo`0JOol20000
0goo00000005Ool001eoo`03OB1oogoo03aoo`03001oogoo03aoo`03OB1oogoo02Eoo`007Goo00=m
87ooOol0?7oo0P00?Goo00=m87ooOol09Goo000MOol00gdPOomoo`0lOol00`00Oomoo`0lOol00gdP
Oomoo`0UOol001eoo`03OB1oogoo03aoo`03001oogoo03aoo`03OB1oogoo02Eoo`007Goo00=m87oo
Ool0?7oo00<007ooOol0?7oo00=m87ooOol09Goo000MOol00gdPOomoo`0lOol00`00Oomoo`0lOol0
0gdPOomoo`0UOol001ioo`03OB1oogoo03]oo`8003aoo`03OB1oogoo02Ioo`007Woo00=m87ooOol0
>goo00<007ooOol0>goo00=m87ooOol09Woo000NOol00gdPOomoo`0kOol00`00Oomoo`0kOol00gdP
Oomoo`0VOol001ioo`03OB1oogoo03]oo`03001oogoo03]oo`03OB1oogoo02Ioo`007Woo00=m87oo
Ool0>goo0P00?7oo00=m87ooOol09Woo000OOol00gdPOomoo`0jOol00`00Oomoo`0kOol00gdPOomo
o`0VOol001moo`03OB1oogoo03Yoo`03001oogoo03Yoo`03OB1oogoo02Moo`0087oo00=m87ooOol0
>Goo00<007ooOol0>Woo00=m87ooOol09goo000POol00gdPOomoo`0iOol2000kOol00gdPOomoo`0W
Ool0021oo`03OB1oogoo03Uoo`03001oogoo03Yoo`03OB1oogoo02Moo`0087oo00=m87ooOol0>Goo
00<007ooOol0>Goo00=m87ooOol0:7oo000QOol00gdPOomoo`0VOol20004Ool20004Ool20004Ool0
0`00Oomoo`0iOol00gdPOomoo`0XOol0025oo`03OB1oogoo02Eoo`04001oogoo0008Ool01000Oomo
o`000goo00<007ooOol0>Goo00=m87ooOol0:7oo000QOol00gdPOomoo`0UOol01000Oomoo`002goo
00@007ooOomoo`8003Uoo`03OB1oogoo02Uoo`008Goo00=m87ooOol09Goo00@007ooOol000Uoo`80
00Aoo`03001oogoo03Qoo`03OB1oogoo02Uoo`008Woo00=m87ooOol097oo00@007ooOol000Uoo`03
001oogoo00=oo`03001oogoo03Qoo`03OB1oogoo02Uoo`008Woo00=m87ooOol09Goo0P002Woo0`00
0goo00<007ooOol0=goo00=m87ooOol0:Woo000SOol00gdPOomoo`0fOol2000hOol00gdPOomoo`0Z
Ool002=oo`03OB1oogoo03Ioo`03001oogoo03Ioo`03OB1oogoo02]oo`0097oo00=m87ooOol0=Goo
00<007ooOol0=Woo00=m87ooOol0:goo000UOol00gdPOomoo`0dOol00`00Oomoo`0eOol00gdPOomo
o`0/Ool002Eoo`03OB1oogoo03Aoo`8003Ioo`03OB1oogoo02aoo`009Woo00=m87ooOol0<goo00<0
07ooOol0=7oo00=m87ooOol0;Goo000VOol00gdPOomoo`0cOol00`00Oomoo`0dOol00gdPOomoo`0]
Ool002Moo`03OB1oogoo039oo`03001oogoo03=oo`03OB1oogoo02ioo`00:7oo00=m87ooOol0<Goo
00<007ooOol0<Woo00=m87ooOol0;goo000XOol00gdPOomoo`0aOol2000cOol00gdPOomoo`0_Ool0
02Uoo`03OB1oogoo031oo`03001oogoo035oo`03OB1oogoo031oo`00:Goo00=m87ooOol0<7oo00<0
07ooOol0<Goo00=m87ooOol0<7oo000ZOol00gdPOomoo`0_Ool00`00Oomoo`0`Ool00gdPOomoo`0a
Ool002]oo`03OB1oogoo02ioo`80031oo`03OB1oogoo039oo`00;7oo00=m87ooOol0;Goo00<007oo
Ool0;Woo00=m87ooOol0<goo000/Ool00gdPOomoo`0VOol50002Ool00`00Oomoo`0^Ool00gdPOomo
o`0cOol002eoo`03OB1oogoo02Moo`03001oogoo009oo`03001oogoo02eoo`03OB1oogoo03Aoo`00
;Woo00=m87ooOol09Woo00<007ooOol00Woo0P00;Goo00=m87ooOol0=Goo000_Ool00gdPOomoo`0U
Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool00gdPOomoo`0fOol0031oo`03OB1oogoo02Aoo`03001o
ogoo009oo`03001oogoo02Yoo`03OB1oogoo03Moo`00<Goo00=m87ooOol08Woo0P0017oo00<007oo
Ool0:Goo00=m87ooOol0>7oo000bOol00gdPOomoo`0WOol00`00Oomoo`0XOol00gdPOomoo`0iOol0
03=oo`03OB1oogoo02Ioo`8002Qoo`03OB1oogoo03Yoo`00=7oo00=m87ooOol09Goo00<007ooOol0
9Goo0WdP?Goo000eOol00gdPOomoo`0TOol00`00Oomoo`0TOol00gdPOomoo`0mOol003Ioo`03OB1o
ogoo02=oo`03001oogoo02=oo`03OB1oogoo03ioo`00=goo0WdP8goo0P008goo00=m87ooOol0?goo
000iOol2OB0QOol00`00Oomoo`0POol2OB12Ool003]oo`03OB1oogoo01ioo`03001oogoo01moo`03
OB1oogoo049oo`00?7oo0WdP7Woo00<007ooOol07Goo0WdPAGoo000nOol2OB0LOol2000LOol2OB17
Ool0041oo`9m81Yoo`03001oogoo01Uoo`9m84Uoo`00@Woo0gdP5goo00<007ooOol05Woo0gdPBgoo
0015Ool3OB0DOol00`00Oomoo`0COol3OB1>Ool004Qoo`9m819oo`80019oo`9m855oo`00BWoo17dP
3Woo00<007ooOol03Goo17dPDgoo001>Ool6OB08Ool00`00Oomoo`07Ool6OB1GOol004Uoo`D0009o
o`80009ooa9m85eoo`00Bgoo00<007ooOol01goo00@007ooOol000=oo`03001oogoo06Aoo`00Bgoo
00<007ooOol02Woo00@007ooOomoo`8006Eoo`00Bgoo00<007ooOol027oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`1TOol004Yoo`8000Yoo`<000=o
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo
001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1T
Ool005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo
06Aoo`00EGoo10000goo00<007ooOol0I7oo001EOol00`00Oomoo`04Ool00`00Oomoo`1TOol005Io
o`03001oogoo00=oo`8006Eoo`00Egoo00<007ooOol0JGoo001EOol01000Oomoo`00JWoo001FOol2
001[Ool00<=oo`00`goo0033Ool007=oo`8000=oo`@0009oo`D0009oo`8000Aoo`8000Aoo`80031o
o`00LWoo00@007ooOol000Yoo`03001oogoo00Moo`04001oogoo0002Ool01000Oomoo`00;goo001K
Ool4000COol00`00Oomoo`03Ool40004Ool00`00Oomoo`07Ool01000Oomoo`001Goo00<007ooOol0
;Goo001JOol01000Oomoo`004goo1@002Woo00<007ooOol01goo00@007ooOol000=oo`80031oo`00
FWoo00@007ooOol001Aoo`03001oogoo00]oo`03001oogoo00Moo`04001oogoo0003Ool00`00Oomo
o`0_Ool005Uoo`800003Ool00000025oo`8000Yoo`8000Aoo`<002moo`00`goo0033Ool00<=oo`00
`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -53 0 ]

[.5 1.0125 53 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -114 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1.) show

165.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 0 r

.5 Mabswid

.14645 .49992 m

.14795 .46738 L

.15247 .43503 L

.15994 .40325 L

.17032 .37228 L

.18351 .34241 L

.1994 .31388 L

.21786 .28694 L

.23872 .26181 L

.26181 .23872 L

.28694 .21786 L

.31388 .1994 L

.34241 .18351 L

.37228 .17032 L

.40325 .15994 L

.43503 .15247 L

.46738 .14795 L

.5 .14645 L

.53262 .14795 L

.56497 .15247 L

.59675 .15994 L

.62772 .17032 L

.65759 .18351 L

.68612 .1994 L

.71306 .21786 L

.73819 .23872 L

.76128 .26181 L

.78214 .28694 L

.8006 .31388 L

.81649 .34241 L

.82968 .37228 L

.84006 .40325 L

.84753 .43503 L

.85205 .46738 L

.85355 .49992 L

s

.14645 .50008 m

.14795 .53262 L

.15247 .56497 L

.15994 .59675 L

.17032 .62772 L

.18351 .65759 L

.1994 .68612 L

.21786 .71306 L

.23872 .73819 L

.26181 .76128 L

.28694 .78214 L

.31388 .8006 L

.34241 .81649 L

.37228 .82968 L

.40325 .84006 L

.43503 .84753 L

.46738 .85205 L

.5 .85355 L

.53262 .85205 L

.56497 .84753 L

.59675 .84006 L

.62772 .82968 L

.65759 .81649 L

.68612 .8006 L

.71306 .78214 L

.73819 .76128 L

.76128 .73819 L

.78214 .71306 L

.8006 .68612 L

.81649 .65759 L

.82968 .62772 L

.84006 .59675 L

.84753 .56497 L

.85205 .53262 L

.85355 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Goo47`0GWoo001@
Ool5O007Ool20007Ool5O01IOol004ioo`9l00aoo`03001oogoo00]oo`9l05Moo`00BWoo17`03Woo
00<007ooOol03Goo17`0Dgoo0016Ool4O00BOol00`00Oomoo`0AOol3O01@Ool004Aoo`9l01Ioo`80
01Eoo`9l04ioo`00@Woo0W`067oo00<007ooOol05Woo0W`0C7oo0010Ool2O00JOol00`00Oomoo`0H
Ool2O01:Ool003ioo`9l01aoo`03001oogoo01Yoo`9l04Qoo`00?7oo0W`07Woo0P007Goo0W`0AWoo
000kOol00g`0Oomoo`0NOol00`00Oomoo`0NOol00g`0Oomoo`13Ool003Yoo`03O01oogoo01moo`03
001oogoo01moo`9l04=oo`00>Goo00=l07ooOol087oo00<007ooOol08Goo00=l07ooOol0@7oo000h
Ool00g`0Oomoo`0QOol00`00Oomoo`0ROol00g`0Oomoo`0oOol003Ioo`9l02Aoo`8002Aoo`03O01o
ogoo03ioo`00=7oo0W`09Woo00<007ooOol097oo0W`0?Woo000cOol00g`0Oomoo`0OOol50002Ool0
0`00Oomoo`0VOol00g`0Oomoo`0kOol0039oo`03O01oogoo029oo`03001oogoo009oo`03001oogoo
02Moo`03O01oogoo03Yoo`00<Goo00=l07ooOol08goo00<007ooOol00Woo0P00:Goo00=l07ooOol0
>Goo000`Ool00g`0Oomoo`0LOol40004Ool00`00Oomoo`02Ool00`00Oomoo`0YOol00g`0Oomoo`0h
Ool002moo`03O01oogoo02Eoo`03001oogoo009oo`03001oogoo02Yoo`03O01oogoo03Moo`00;Woo
00=l07ooOol09Goo0P0017oo00<007ooOol0:goo00=l07ooOol0=Woo000]Ool00g`0Oomoo`0/Ool2
000]Ool00g`0Oomoo`0eOol002eoo`03O01oogoo02aoo`03001oogoo02eoo`03O01oogoo03Aoo`00
;7oo00=l07ooOol0;Goo00<007ooOol0;Woo00=l07ooOol0<goo000[Ool00g`0Oomoo`0^Ool00`00
Oomoo`0_Ool00g`0Oomoo`0bOol002]oo`03O01oogoo02ioo`03001oogoo02moo`03O01oogoo039o
o`00:Woo00=l07ooOol0;goo0P00<Goo00=l07ooOol0<Goo000ZOol00g`0Oomoo`0_Ool00`00Oomo
o`0`Ool00g`0Oomoo`0aOol002Uoo`03O01oogoo031oo`03001oogoo035oo`03O01oogoo031oo`00
:7oo00=l07ooOol0<Goo00<007ooOol0<Woo00=l07ooOol0;goo000XOol00g`0Oomoo`0aOol2000c
Ool00g`0Oomoo`0_Ool002Moo`03O01oogoo039oo`03001oogoo03=oo`03O01oogoo02ioo`009goo
00=l07ooOol0<Woo00<007ooOol0<goo00=l07ooOol0;Woo000VOol00g`0Oomoo`0cOol00`00Oomo
o`0dOol00g`0Oomoo`0]Ool002Ioo`03O01oogoo03=oo`8003Eoo`03O01oogoo02eoo`009Goo00=l
07ooOol0=7oo00<007ooOol0=Goo00=l07ooOol0;7oo000UOol00g`0Oomoo`0dOol00`00Oomoo`0e
Ool00g`0Oomoo`0/Ool002Aoo`03O01oogoo02=oo`8000Aoo`8000Aoo`8000Aoo`03001oogoo03Io
o`03O01oogoo02]oo`0097oo00=l07ooOol08Woo00@007ooOol000Qoo`04001oogoo0003Ool00`00
Oomoo`0fOol00g`0Oomoo`0[Ool002Aoo`03O01oogoo029oo`04001oogoo000;Ool01000Oomoogoo
0P00=goo00=l07ooOol0:goo000SOol00g`0Oomoo`0MOol40002Ool01000Oomoo`002Goo0P0017oo
00<007ooOol0=goo00=l07ooOol0:Woo000SOol00g`0Oomoo`0SOol01000Oomoo`002Goo00<007oo
Ool00goo00<007ooOol0=goo00=l07ooOol0:Woo000ROol00g`0Oomoo`0UOol2000:Ool30003Ool0
0`00Oomoo`0hOol00g`0Oomoo`0YOol0029oo`03O01oogoo03Moo`8003Uoo`03O01oogoo02Uoo`00
8Woo00=l07ooOol0=goo00<007ooOol0>7oo00=l07ooOol0:Goo000QOol00g`0Oomoo`0hOol00`00
Oomoo`0hOol00g`0Oomoo`0YOol0025oo`03O01oogoo03Qoo`03001oogoo03Uoo`03O01oogoo02Qo
o`008Goo00=l07ooOol0>7oo0P00>Woo00=l07ooOol0:7oo000POol00g`0Oomoo`0iOol00`00Oomo
o`0iOol00g`0Oomoo`0XOol0021oo`03O01oogoo03Uoo`03001oogoo03Uoo`03O01oogoo02Qoo`00
1goo100037oo1@000Woo0P0000Al07ooOomoo`8000aoo`D000aoo`8000Aoo`8000Aoo`8000]oo`03
001oogoo00aoo`8000Aoo`8000Aoo`8000aoo`D000]oo`<00004O00007ooOol20004Ool2000=Ool4
000>Ool000Moo`03001oogoo00moo`03001oogoo00Aoo`04O01oogoo0002Ool00`00Oomoo`0;Ool0
0`00Oomoo`0;Ool01000Oomoo`0027oo00@007ooOol000Yoo`03001oogoo00]oo`04001oogoo0008
Ool01000Oomoo`003Goo00<007ooOol03Goo00<007`0Ool01goo00@007ooOol000aoo`03001oogoo
00moo`0027oo00<007ooOol03Woo00<007ooOol017oo00=l07ooOol00goo00<007ooOol02goo00<0
07ooOol02goo00@007ooOol000]oo`03001oogoo00Qoo`8000aoo`04001oogoo000;Ool00`00Oomo
o`0;Ool00`00Oomoo`0=Ool00`00Ooml000:Ool00`00Oomoo`0;Ool00`00Oomoo`0>Ool00003Ool0
0000008000Aoo`03001oogoo00Eoo`@000Aoo`03001oogoo00Aoo`04O01oogooOol20006Ool40004
Ool00`00Oomoo`05Ool40002Ool01000Oomoo`002Goo0P002goo00<007ooOol02goo00@007ooOol0
00Uoo`8000ioo`03001oogoo00eoo`03001oog`000Qoo`8000moo`03001oogoo00eoo`001goo00@0
07ooOol000ioo`03001oogoo00Aoo`05O01oogooOol0000?Ool00`00Oomoo`0;Ool01000Oomoo`00
2Goo00<007ooOol02Woo00<007ooOol02goo00@007ooOol000Uoo`03001oogoo00eoo`03001oogoo
00eoo`03001oog`000Qoo`03001oogoo00aoo`04001oogoo000>Ool000Qoo`8000ioo`8000Ioo`04
O01oogooOol3000<Ool2000>Ool2000:Ool3000:Ool00`00Oomoo`0<Ool2000:Ool3000<Ool2000>
Ool200000gooO01oo`07Ool3000=Ool2000?Ool0021oo`03O01oogoo03Uoo`8003]oo`03O01oogoo
02Moo`0087oo00=l07ooOol0>Goo00<007ooOol0>Woo00=l07ooOol09goo000OOol00g`0Oomoo`0j
Ool00`00Oomoo`0jOol00g`0Oomoo`0WOol001moo`03O01oogoo03Yoo`03001oogoo03Yoo`03O01o
ogoo01eoo`800003Ool0000000Eoo`001Woo6@0000=l00000000M`0000=l0000000060001Woo00<0
07oo00001Woo0006Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05
001oogooO0000003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007oo
Oomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo000017oo00D007oo
Oomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo
00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`05001oogooOol00004Ool01@00Oomoogoo
00000goo00<007ooOol00Woo00El07ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003
Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`05Ool001moo`03O01oogoo03Yoo`03001o
ogoo03Yoo`03O01oogoo01eoo`800003Ool0000000Eoo`0087oo00=l07ooOol0>Goo00<007ooOol0
>Woo00=l07ooOol09goo000POol00g`0Oomoo`0iOol2000kOol00g`0Oomoo`0WOol0021oo`03O01o
ogoo03Uoo`03001oogoo03Yoo`03O01oogoo02Moo`0087oo00=l07ooOol0>Goo00<007ooOol0>Woo
00=l07ooOol09goo000POol00g`0Oomoo`0iOol00`00Oomoo`0jOol00g`0Oomoo`0WOol0021oo`03
O01oogoo03Uoo`03001oogoo03Yoo`03O01oogoo02Moo`0087oo00=l07ooOol0>Goo0P00>Woo00=l
07ooOol0:7oo000POol00g`0Oomoo`0iOol00`00Oomoo`0iOol00g`0Oomoo`0XOol0021oo`03O01o
ogoo03Uoo`03001oogoo03Uoo`03O01oogoo02Qoo`0087oo00=l07ooOol0>Goo00<007ooOol0>Goo
00=l07ooOol0:7oo000QOol00g`0Oomoo`0hOol2000jOol00g`0Oomoo`0XOol0025oo`03O01oogoo
03Qoo`03001oogoo03Qoo`03O01oogoo02Uoo`008Goo00=l07ooOol0>7oo00<007ooOol0>7oo00=l
07ooOol0:Goo000ROol00g`0Oomoo`0gOol00`00Oomoo`0hOol00g`0Oomoo`0YOol0029oo`03O01o
ogoo03Moo`8003Uoo`03O01oogoo02Uoo`008Woo00=l07ooOol0=goo00<007ooOol0>7oo00=l07oo
Ool0:Goo000SOol00g`0Oomoo`0fOol00`00Oomoo`0gOol00g`0Oomoo`0ZOol002=oo`03O01oogoo
02Aoo`8000Aoo`8000Aoo`8000Aoo`03001oogoo03Moo`03O01oogoo02Yoo`0097oo00=l07ooOol0
8Woo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`0fOol00g`0Oomoo`0[Ool002Aoo`03
O01oogoo029oo`04001oogoo000;Ool01000Oomoogoo0P00=goo00=l07ooOol0:goo000TOol00g`0
Oomoo`0ROol01000Oomoo`002Goo0P0017oo00<007ooOol0=Woo00=l07ooOol0:goo000UOol00g`0
Oomoo`0QOol01000Oomoo`002Goo00<007ooOol00goo00<007ooOol0=Goo00=l07ooOol0;7oo000U
Ool00g`0Oomoo`0ROol2000:Ool30003Ool00`00Oomoo`0eOol00g`0Oomoo`0/Ool002Ioo`03O01o
ogoo03=oo`8003Eoo`03O01oogoo02eoo`009Woo00=l07ooOol0<goo00<007ooOol0=7oo00=l07oo
Ool0;Goo000WOol00g`0Oomoo`0bOol00`00Oomoo`0cOol00g`0Oomoo`0^Ool002Moo`03O01oogoo
039oo`03001oogoo03=oo`03O01oogoo02ioo`00:7oo00=l07ooOol0<Goo0P00<goo00=l07ooOol0
;goo000XOol00g`0Oomoo`0aOol00`00Oomoo`0bOol00g`0Oomoo`0_Ool002Uoo`03O01oogoo031o
o`03001oogoo035oo`03O01oogoo031oo`00:Woo00=l07ooOol0;goo00<007ooOol0<7oo00=l07oo
Ool0<Goo000ZOol00g`0Oomoo`0_Ool00`00Oomoo`0`Ool00g`0Oomoo`0aOol002]oo`03O01oogoo
02ioo`80031oo`03O01oogoo039oo`00:goo00=l07ooOol0;Woo00<007ooOol0;goo00=l07ooOol0
<Woo000/Ool00g`0Oomoo`0]Ool00`00Oomoo`0^Ool00g`0Oomoo`0cOol002eoo`03O01oogoo02ao
o`03001oogoo02eoo`03O01oogoo03Aoo`00;Woo00=l07ooOol0:goo0P00;Goo00=l07ooOol0=Goo
000^Ool00g`0Oomoo`0[Ool00`00Oomoo`0[Ool00g`0Oomoo`0fOol002moo`03O01oogoo02=oo`D0
009oo`03001oogoo02Yoo`03O01oogoo03Moo`00<7oo00=l07ooOol097oo00<007ooOol00Woo00<0
07ooOol0:Goo00=l07ooOol0>7oo000aOol00g`0Oomoo`0SOol00`00Oomoo`02Ool2000YOol00g`0
Oomoo`0iOol0039oo`03O01oogoo029oo`03001oogoo009oo`03001oogoo02Moo`03O01oogoo03Yo
o`00<goo00=l07ooOol08Goo00<007ooOol00Woo00<007ooOol09Woo00=l07ooOol0>goo000dOol0
0g`0Oomoo`0OOol20004Ool00`00Oomoo`0UOol00g`0Oomoo`0lOol003Eoo`9l02Eoo`03001oogoo
02Aoo`03O01oogoo03eoo`00=goo00=l07ooOol08Woo0P0097oo00=l07ooOol0?Woo000hOol00g`0
Oomoo`0QOol00`00Oomoo`0ROol00g`0Oomoo`0oOol003Uoo`03O01oogoo021oo`03001oogoo021o
o`9l049oo`00>Woo0W`087oo00<007ooOol07Woo0W`0A7oo000lOol00g`0Oomoo`0MOol2000NOol0
0g`0Oomoo`14Ool003eoo`9l01eoo`03001oogoo01aoo`03O01oogoo04Eoo`00?goo0W`06goo00<0
07ooOol06Woo0W`0B7oo0011Ool2O00IOol00`00Oomoo`0HOol2O01:Ool004=oo`9l01Moo`8001Io
o`=l04aoo`00AGoo0g`057oo00<007ooOol04Woo0g`0Cgoo0018Ool3O00AOol00`00Oomoo`0@Ool2
O01BOol004]oo`Al00eoo`03001oogoo00aoo`Al05Aoo`00Cgoo1G`027oo0P0027oo1G`0F7oo001D
OolBO01MOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0I7oo
001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:Ool0
1000Oomoogoo0P00IGoo001;Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol004]oo`03001o
ogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<007ooOol0I7oo
001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1T
Ool005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo
06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007oo
Ool0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001EOol40003
Ool00`00Oomoo`1TOol005Eoo`03001oogoo00Aoo`03001oogoo06Aoo`00EWoo00<007ooOol00goo
0P00IGoo001GOol00`00Oomoo`1YOol005Eoo`04001oogoo001ZOol005Ioo`8006]oo`00`goo0033
Ool00<=oo`00NGoo0P000goo10000Woo1@000Woo0P00=Woo001hOol01000Oomoo`002Woo00<007oo
Ool0>Woo001KOol4000IOol00`00Oomoo`03Ool40004Ool00`00Oomoo`0jOol005Yoo`04001oogoo
000IOol5000:Ool00`00Oomoo`0jOol005Yoo`04001oogoo000JOol00`00Oomoo`0;Ool00`00Oomo
o`0jOol005Uoo`800003Ool0000002Moo`8003aoo`00`goo0033Ool00<=oo`00`goo0033Ool00001
\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.95) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 .3 r

.5 Mabswid

.15996 .49992 m

.16141 .46863 L

.16575 .43752 L

.17294 .40694 L

.18293 .37716 L

.19561 .34843 L

.21089 .32099 L

.22864 .29508 L

.24871 .27092 L

.27092 .24871 L

.29508 .22864 L

.32099 .21089 L

.34843 .19561 L

.37716 .18293 L

.40694 .17294 L

.43752 .16575 L

.46863 .16141 L

.5 .15996 L

.53137 .16141 L

.56248 .16575 L

.59306 .17294 L

.62284 .18293 L

.65157 .19561 L

.67901 .21089 L

.70492 .22864 L

.72908 .24871 L

.75129 .27092 L

.77136 .29508 L

.78911 .32099 L

.80439 .34843 L

.81707 .37716 L

.82706 .40694 L

.83425 .43752 L

.83859 .46863 L

.84004 .49992 L

s

.15996 .50008 m

.16141 .53137 L

.16575 .56248 L

.17294 .59306 L

.18293 .62284 L

.19561 .65157 L

.21089 .67901 L

.22864 .70492 L

.24871 .72908 L

.27092 .75129 L

.29508 .77136 L

.32099 .78911 L

.34843 .80439 L

.37716 .81707 L

.40694 .82706 L

.43752 .83425 L

.46863 .83859 L

.5 .84004 L

.53137 .83859 L

.56248 .83425 L

.59306 .82706 L

.62284 .81707 L

.65157 .80439 L

.67901 .78911 L

.70492 .77136 L

.72908 .75129 L

.75129 .72908 L

.77136 .70492 L

.78911 .67901 L

.80439 .65157 L

.81707 .62284 L

.82706 .59306 L

.83425 .56248 L

.83859 .53137 L

.84004 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo47`9GWoo001@Ool5O0T7Ool0
0`00Oomoo`06Ool5O0UIOol004]oo`El2@aoo`8000aoo`Al2EEoo`00BGoo0W`94Goo00<007ooOol0
3goo0g`9DWoo0016Ool3O0TCOol00`00Oomoo`0BOol2O0U@Ool004Aoo`9l2AIoo`03001oogoo01Ao
o`9l2Dioo`00@Woo0W`967oo0P005goo0g`9Bgoo0010Ool2O0TJOol00`00Oomoo`0IOol2O0U9Ool0
03ioo`9l2Aaoo`03001oogoo01]oo`9l2DMoo`00?7oo0W`97Woo00<007ooOol07Goo0W`9AGoo000j
Ool2O0TPOol00`00Oomoo`0OOol2O0U3Ool003Uoo`03O0Uoogoo021oo`80029oo`03O0Uoogoo041o
o`00>7oo00=l2GooOol08Goo00<007ooOol08Woo00=l2GooOol0?goo000gOol00g`9Oomoo`0KOol5
0002Ool00`00Oomoo`0SOol00g`9Oomoo`0nOol003Ioo`03O0Uoogoo01ioo`03001oogoo009oo`03
001oogoo02Aoo`03O0Uoogoo03eoo`00=Goo00=l2GooOol07goo00<007ooOol00Woo0P009Woo00=l
2GooOol0?7oo000dOol00g`9Oomoo`0HOol40004Ool00`00Oomoo`02Ool00`00Oomoo`0VOol00g`9
Oomoo`0kOol003=oo`03O0Uoogoo025oo`03001oogoo009oo`03001oogoo02Moo`03O0Uoogoo03Yo
o`00<Woo00=l2GooOol08Goo0P0017oo00<007ooOol0:7oo00=l2GooOol0>Goo000aOol00g`9Oomo
o`0XOol2000ZOol00g`9Oomoo`0hOol0031oo`03O0Uoogoo02Uoo`03001oogoo02Yoo`03O0Uoogoo
03Moo`00;goo00=l2GooOol0:Woo00<007ooOol0:goo00=l2GooOol0=Woo000_Ool00g`9Oomoo`0Z
Ool00`00Oomoo`0[Ool00g`9Oomoo`0fOol002ioo`03O0Uoogoo02]oo`03001oogoo02aoo`03O0Uo
ogoo03Eoo`00;Goo00=l2GooOol0;7oo0P00;Woo00=l2GooOol0=7oo000/Ool00g`9Oomoo`0]Ool0
0`00Oomoo`0^Ool00g`9Oomoo`0cOol002aoo`03O0Uoogoo02eoo`03001oogoo02ioo`03O0Uoogoo
03=oo`00:goo00=l2GooOol0;Woo00<007ooOol0;goo00=l2GooOol0<Woo000ZOol00g`9Oomoo`0_
Ool2000aOol00g`9Oomoo`0aOol002Yoo`03O0Uoogoo02moo`03001oogoo031oo`03O0Uoogoo035o
o`00:Goo00=l2GooOol0<7oo00<007ooOol0<Goo00=l2GooOol0<7oo000YOol00g`9Oomoo`0`Ool0
0`00Oomoo`0aOol00g`9Oomoo`0`Ool002Qoo`03O0Uoogoo035oo`8003=oo`03O0Uoogoo02moo`00
:7oo00=l2GooOol0<Goo00<007ooOol0<Woo00=l2GooOol0;goo000WOol00g`9Oomoo`0bOol00`00
Oomoo`0cOol00g`9Oomoo`0^Ool002Moo`03O0Uoogoo021oo`8000Aoo`8000Aoo`8000Aoo`03001o
ogoo03=oo`03O0Uoogoo02ioo`009Woo00=l2GooOol087oo00@007ooOol000Qoo`04001oogoo0003
Ool00`00Oomoo`0dOol00g`9Oomoo`0]Ool002Ioo`03O0Uoogoo021oo`04001oogoo000;Ool01000
Oomoogoo0P00=Goo00=l2GooOol0;Goo000VOol00g`9Oomoo`0JOol40002Ool01000Oomoo`002Goo
0P0017oo00<007ooOol0=7oo00=l2GooOol0;Goo000UOol00g`9Oomoo`0QOol01000Oomoo`002Goo
00<007ooOol00goo00<007ooOol0=Goo00=l2GooOol0;7oo000UOol00g`9Oomoo`0ROol2000:Ool3
0003Ool00`00Oomoo`0eOol00g`9Oomoo`0/Ool002Aoo`03O0Uoogoo03Eoo`8003Moo`03O0Uoogoo
02]oo`0097oo00=l2GooOol0=Goo00<007ooOol0=Woo00=l2GooOol0:goo000TOol00g`9Oomoo`0e
Ool00`00Oomoo`0fOol00g`9Oomoo`0[Ool002Aoo`03O0Uoogoo03Eoo`03001oogoo03Ioo`03O0Uo
ogoo02]oo`008goo00=l2GooOol0=Woo0P00>7oo00=l2GooOol0:Woo000SOol00g`9Oomoo`0fOol0
0`00Oomoo`0gOol00g`9Oomoo`0ZOol002=oo`03O0Uoogoo03Ioo`03001oogoo03Moo`03O0Uoogoo
02Yoo`001goo100037oo1@000Woo0P000goo00=l2@00000037oo1@0037oo0P0017oo0P0017oo0P00
2goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo1@002goo00<007`900000P000Woo0P0017oo
0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool00`00Oomoo`07Ool017`9Oomoo`003Goo00<007oo
Ool02goo00@007ooOol000Qoo`04001oogoo000:Ool00`00Oomoo`0;Ool01000Oomoo`0027oo00@0
07ooOol000eoo`03001oogoo00aoo`03O0T007oo00Qoo`04001oogoo000<Ool00`00Oomoo`0?Ool0
00Qoo`03001oogoo00ioo`03001oogoo00Ioo`05O0UoogooOol0000=Ool00`00Oomoo`0;Ool01000
Oomoo`002goo00<007ooOol027oo0P0037oo00@007ooOol000]oo`03001oogoo00]oo`03001oogoo
00eoo`03O0Uoogoo00Yoo`03001oogoo00]oo`03001oogoo00ioo`0000=oo`0000000P0017oo00<0
07ooOol01Goo100017oo00<007ooOol01Woo00Al2Goo000000Ioo`@000Aoo`03001oogoo00Eoo`@0
009oo`04001oogoo0009Ool2000;Ool00`00Oomoo`0;Ool01000Oomoo`002Goo0P003Woo00<007oo
Ool03Goo00=l2GooOol027oo0P003goo00<007ooOol03Goo0007Ool01000Oomoo`003Woo00<007oo
Ool01Woo00=l2Goo00003goo00<007ooOol02goo00@007ooOol000Uoo`03001oogoo00Yoo`03001o
ogoo00]oo`04001oogoo0009Ool00`00Oomoo`0=Ool00`00Oomoo`0=Ool00g`9Oomoo`08Ool00`00
Oomoo`0<Ool01000Oomoo`003Woo0008Ool2000>Ool20008Ool00g`9Ool00002000<Ool2000>Ool2
000:Ool3000:Ool00`00Oomoo`0<Ool2000:Ool3000<Ool2000>Ool00`00O0Uoo`09Ool3000=Ool2
000?Ool0029oo`03O0Uoogoo03Moo`8003Uoo`03O0Uoogoo02Uoo`008Woo00=l2GooOol0=goo00<0
07ooOol0>7oo00=l2GooOol0:Goo000ROol00g`9Oomoo`0gOol00`00Oomoo`0hOol00g`9Oomoo`0Y
Ool0029oo`03O0Uoogoo03Moo`03001oogoo03Qoo`03O0Uoogoo01moo`800003Ool0000000Eoo`00
1Woo700000=l2@000000LP0000=l2@0000006P001Woo00<007oo00001Woo0006Ool01@00Oomoogoo
000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`09001oogooOol007ooO0Uoo`0000Aoo`05
001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007oo
Oomoo`0000=oo`05001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007oo
Oomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo
00000goo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool01P00Oomoog`9Ool000=oo`05001o
ogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol0
1Goo000ROol00g`9Oomoo`0gOol00`00Oomoo`0hOol00g`9Oomoo`0OOol200000goo00000005Ool0
029oo`03O0Uoogoo03Moo`03001oogoo03Qoo`03O0Uoogoo02Uoo`008Woo00=l2GooOol0=goo0P00
>Goo00=l2GooOol0:Goo000ROol00g`9Oomoo`0gOol00`00Oomoo`0hOol00g`9Oomoo`0YOol0029o
o`03O0Uoogoo03Moo`03001oogoo03Qoo`03O0Uoogoo02Uoo`008Woo00=l2GooOol0=goo00<007oo
Ool0>7oo00=l2GooOol0:Goo000ROol00g`9Oomoo`0gOol00`00Oomoo`0hOol00g`9Oomoo`0YOol0
02=oo`03O0Uoogoo03Ioo`8003Qoo`03O0Uoogoo02Yoo`008goo00=l2GooOol0=Woo00<007ooOol0
=goo00=l2GooOol0:Woo000SOol00g`9Oomoo`0fOol00`00Oomoo`0gOol00g`9Oomoo`0ZOol002=o
o`03O0Uoogoo03Ioo`03001oogoo03Moo`03O0Uoogoo02Yoo`008goo00=l2GooOol0=Woo0P00>7oo
00=l2GooOol0:Woo000TOol00g`9Oomoo`0eOol00`00Oomoo`0fOol00g`9Oomoo`0[Ool002Aoo`03
O0Uoogoo03Eoo`03001oogoo03Ioo`03O0Uoogoo02]oo`0097oo00=l2GooOol0=Goo00<007ooOol0
=Woo00=l2GooOol0:goo000TOol00g`9Oomoo`0eOol2000gOol00g`9Oomoo`0[Ool002Eoo`03O0Uo
ogoo03Aoo`03001oogoo03Eoo`03O0Uoogoo02aoo`009Goo00=l2GooOol0=7oo00<007ooOol0=Goo
00=l2GooOol0;7oo000VOol00g`9Oomoo`0QOol20004Ool20004Ool20004Ool00`00Oomoo`0dOol0
0g`9Oomoo`0]Ool002Ioo`03O0Uoogoo021oo`04001oogoo0008Ool01000Oomoo`000goo00<007oo
Ool0=7oo00=l2GooOol0;Goo000VOol00g`9Oomoo`0POol01000Oomoo`002goo00@007ooOomoo`80
03Eoo`03O0Uoogoo02eoo`009goo00=l2GooOol07goo00@007ooOol000Uoo`8000Aoo`03001oogoo
03=oo`03O0Uoogoo02ioo`009goo00=l2GooOol07goo00@007ooOol000Uoo`03001oogoo00=oo`03
001oogoo03=oo`03O0Uoogoo02ioo`00:7oo00=l2GooOol07goo0P002Woo0`000goo00<007ooOol0
<Woo00=l2GooOol0;goo000XOol00g`9Oomoo`0aOol2000cOol00g`9Oomoo`0_Ool002Uoo`03O0Uo
ogoo031oo`03001oogoo035oo`03O0Uoogoo031oo`00:Goo00=l2GooOol0<7oo00<007ooOol0<Goo
00=l2GooOol0<7oo000ZOol00g`9Oomoo`0_Ool00`00Oomoo`0`Ool00g`9Oomoo`0aOol002Yoo`03
O0Uoogoo02moo`80035oo`03O0Uoogoo035oo`00:goo00=l2GooOol0;Woo00<007ooOol0;goo00=l
2GooOol0<Woo000/Ool00g`9Oomoo`0]Ool00`00Oomoo`0^Ool00g`9Oomoo`0cOol002eoo`03O0Uo
ogoo02aoo`03001oogoo02eoo`03O0Uoogoo03Aoo`00;Goo00=l2GooOol0;7oo00<007ooOol0;Goo
00=l2GooOol0=7oo000^Ool00g`9Oomoo`0[Ool2000]Ool00g`9Oomoo`0eOol002moo`03O0Uoogoo
02Yoo`03001oogoo02]oo`03O0Uoogoo03Ioo`00;goo00=l2GooOol0:Woo00<007ooOol0:goo00=l
2GooOol0=Woo000`Ool00g`9Oomoo`0YOol00`00Oomoo`0ZOol00g`9Oomoo`0gOol0031oo`03O0Uo
ogoo02Uoo`8002]oo`03O0Uoogoo03Moo`00<Goo00=l2GooOol0:7oo00<007ooOol0:Goo00=l2Goo
Ool0>7oo000bOol00g`9Oomoo`0POol50002Ool00`00Oomoo`0XOol00g`9Oomoo`0iOol003=oo`9l
2B9oo`03001oogoo009oo`03001oogoo02Ioo`9l2Caoo`00=Goo00=l2GooOol07goo00<007ooOol0
0Woo0P009Woo00=l2GooOol0?7oo000fOol00g`9Oomoo`0NOol00`00Oomoo`02Ool00`00Oomoo`0T
Ool00g`9Oomoo`0mOol003Moo`03O0Uoogoo01eoo`03001oogoo009oo`03001oogoo02=oo`03O0Uo
ogoo03ioo`00>7oo00=l2GooOol06goo0P0017oo00<007ooOol08Woo00=l2GooOol0?goo000iOol0
0g`9Oomoo`0POol00`00Oomoo`0QOol00g`9Oomoo`10Ool003Yoo`9l2B1oo`80021oo`9l2D=oo`00
?7oo0W`97Woo00<007ooOol07Goo0W`9AGoo000nOol00g`9Oomoo`0KOol00`00Oomoo`0LOol00g`9
Oomoo`15Ool003moo`03O0Uoogoo01Yoo`03001oogoo01Yoo`9l2DQoo`00@7oo0W`96Woo0P006Goo
0W`9BWoo0012Ool2O0THOol00`00Oomoo`0GOol00g`9Oomoo`1:Ool004Aoo`9l2AIoo`03001oogoo
01Eoo`9l2Deoo`00AWoo0g`94goo00<007ooOol04Woo0g`9Cgoo0019Ool2O0TAOol2000@Ool3O0UB
Ool004]oo`Al2@eoo`03001oogoo00]oo`Al2EEoo`00Cgoo1W`91goo00<007ooOol01Woo1G`9FGoo
001EOol@O0UNOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol004Uo
o`D0009oo`8000Aoo`8000Aoo`03001oogoo06Aoo`00Bgoo00<007ooOol01goo00@007ooOol000=o
o`03001oogoo06Aoo`00Bgoo00<007ooOol02Woo00@007ooOomoo`8006Eoo`00Bgoo00<007ooOol0
27oo0P0017oo00<007ooOol0I7oo001;Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`1T
Ool004Yoo`8000Yoo`<000=oo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol0
05aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Ao
o`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00
IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2
001UOol005aoo`03001oogoo06Aoo`00EGoo10000goo00<007ooOol0I7oo001EOol00`00Oomoo`04
Ool00`00Oomoo`1TOol005Ioo`03001oogoo00=oo`8006Eoo`00Egoo00<007ooOol0JGoo001EOol0
1000Oomoo`00JWoo001FOol2001[Ool00<=oo`00`goo0033Ool007=oo`8000=oo`@000=oo`8000Ao
o`8000=oo`<000Aoo`80031oo`00LWoo00@007ooOol000Qoo`04001oogoo000:Ool01@00Oomoogoo
00000Woo00<007ooOol0;Goo001KOol4000COol00`00Oomoo`03Ool40002Ool01000Oomoo`002Goo
0`001Goo00<007ooOol0;Goo001JOol01000Oomoo`004goo1@0027oo00@007ooOol000Qoo`04001o
ogoo0003Ool2000`Ool005Yoo`04001oogoo000DOol00`00Oomoo`09Ool01000Oomoo`0027oo00@0
07ooOol000=oo`03001oogoo02moo`00FGoo0P0000=oo`0000008Goo0P002Woo0`000goo0`00;goo
0033Ool00<=oo`00`goo0033Ool00<=oo`00\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.9) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 .6 r

.5 Mabswid

.17404 .49992 m

.17543 .46992 L

.17959 .4401 L

.18648 .4108 L

.19605 .38225 L

.20821 .35471 L

.22286 .3284 L

.23988 .30357 L

.25911 .2804 L

.2804 .25911 L

.30357 .23988 L

.3284 .22286 L

.35471 .20821 L

.38225 .19605 L

.4108 .18648 L

.4401 .17959 L

.46992 .17543 L

.5 .17404 L

.53008 .17543 L

.5599 .17959 L

.5892 .18648 L

.61775 .19605 L

.64529 .20821 L

.6716 .22286 L

.69643 .23988 L

.7196 .25911 L

.74089 .2804 L

.76012 .30357 L

.77714 .3284 L

.79179 .35471 L

.80395 .38225 L

.81352 .4108 L

.82041 .4401 L

.82457 .46992 L

.82596 .49992 L

s

.17404 .50008 m

.17543 .53008 L

.17959 .5599 L

.18648 .5892 L

.19605 .61775 L

.20821 .64529 L

.22286 .6716 L

.23988 .69643 L

.25911 .7196 L

.2804 .74089 L

.30357 .76012 L

.3284 .77714 L

.35471 .79179 L

.38225 .80395 L

.4108 .81352 L

.4401 .82041 L

.46992 .82457 L

.5 .82596 L

.53008 .82457 L

.5599 .82041 L

.5892 .81352 L

.61775 .80395 L

.64529 .79179 L

.6716 .77714 L

.69643 .76012 L

.7196 .74089 L

.74089 .7196 L

.76012 .69643 L

.77714 .6716 L

.79179 .64529 L

.80395 .61775 L

.81352 .5892 L

.82041 .5599 L

.82457 .53008 L

.82596 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005Eooa1l4Uioo`00D7oo1G`B1goo00<007ooOol01Woo1G`BFGoo001<Ool4O18<
Ool00`00Oomoo`0;Ool4O19EOol004Yoo`9l4Q1oo`03001oogoo00moo`9l4U=oo`00Agoo0g`B4Woo
0P004Woo0W`BDGoo0015Ool2O18EOol00`00Oomoo`0COol2O19?Ool004=oo`9l4QMoo`03001oogoo
01Eoo`=l4Taoo`00@Goo0W`B6Goo00<007ooOol067oo0W`BBWoo000oOol2O18KOol00`00Oomoo`0J
Ool2O198Ool003ioo`03O19oogoo01]oo`8001eoo`03O19oogoo04Eoo`00?7oo0W`B7Woo00<007oo
Ool07Goo0W`BAGoo000kOol00g`BOomoo`0GOol50002Ool00`00Oomoo`0OOol00g`BOomoo`12Ool0
03Yoo`03O19oogoo01Yoo`03001oogoo009oo`03001oogoo021oo`03O19oogoo045oo`00>Goo00=l
4WooOol06goo00<007ooOol00Woo0P008Woo00=l4WooOol0@7oo000hOol00g`BOomoo`0DOol40004
Ool00`00Oomoo`02Ool00`00Oomoo`0ROol00g`BOomoo`0oOol003Moo`03O19oogoo01eoo`03001o
ogoo009oo`03001oogoo02=oo`03O19oogoo03ioo`00=Woo00=l4WooOol07Goo0P0017oo00<007oo
Ool097oo00=l4WooOol0?Goo000dOol2O18VOol2000VOol2O18mOol003=oo`03O19oogoo02Ioo`03
001oogoo02Moo`03O19oogoo03Yoo`00<Woo00=l4WooOol09goo00<007ooOol0:7oo00=l4WooOol0
>Goo000aOol00g`BOomoo`0XOol00`00Oomoo`0YOol00g`BOomoo`0hOol0035oo`03O19oogoo02Qo
o`03001oogoo02Uoo`03O19oogoo03Qoo`00<7oo00=l4WooOol0:Goo0P00:goo00=l4WooOol0=goo
000_Ool00g`BOomoo`0ZOol00`00Oomoo`0[Ool00g`BOomoo`0fOol002moo`03O19oogoo02Yoo`03
001oogoo02]oo`03O19oogoo03Ioo`00;Woo00=l4WooOol0:goo00<007ooOol0;7oo00=l4WooOol0
=Goo000^Ool00g`BOomoo`0[Ool2000]Ool00g`BOomoo`0eOol002eoo`03O19oogoo02aoo`03001o
ogoo02eoo`03O19oogoo03Aoo`00;7oo00=l4WooOol0;Goo00<007ooOol0;Woo00=l4WooOol0<goo
000[Ool00g`BOomoo`0^Ool00`00Oomoo`0_Ool00g`BOomoo`0bOol002]oo`03O19oogoo02ioo`80
031oo`03O19oogoo039oo`00:Woo00=l4WooOol0;goo00<007ooOol0<7oo00=l4WooOol0<Goo000Z
Ool00g`BOomoo`0_Ool00`00Oomoo`0`Ool00g`BOomoo`0aOol002Uoo`03O19oogoo01ioo`8000Ao
o`8000Aoo`8000Aoo`03001oogoo035oo`03O19oogoo031oo`00:Goo00=l4WooOol07Goo00@007oo
Ool000Qoo`04001oogoo0003Ool00`00Oomoo`0aOol00g`BOomoo`0`Ool002Qoo`03O19oogoo01io
o`04001oogoo000;Ool01000Oomoogoo0P00<goo00=l4WooOol0;goo000XOol00g`BOomoo`0HOol4
0002Ool01000Oomoo`002Goo0P0017oo00<007ooOol0<Woo00=l4WooOol0;goo000XOol00g`BOomo
o`0NOol01000Oomoo`002Goo00<007ooOol00goo00<007ooOol0<Woo00=l4WooOol0;goo000WOol0
0g`BOomoo`0POol2000:Ool30003Ool00`00Oomoo`0bOol00g`BOomoo`0_Ool002Moo`03O19oogoo
039oo`8003Aoo`03O19oogoo02ioo`009Woo00=l4WooOol0<goo00<007ooOol0<goo00=l4WooOol0
;Woo000VOol00g`BOomoo`0cOol00`00Oomoo`0cOol00g`BOomoo`0^Ool002Ioo`03O19oogoo03=o
o`03001oogoo03=oo`03O19oogoo02ioo`009Woo00=l4WooOol0<goo0P00=Goo00=l4WooOol0;Goo
000UOol00g`BOomoo`0dOol00`00Oomoo`0dOol00g`BOomoo`0]Ool002Eoo`03O19oogoo03Aoo`03
001oogoo03Eoo`03O19oogoo02aoo`001goo100037oo1@000Woo0P0017oo00<007`BOol02goo1@00
37oo0P0017oo0P0017oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo1@002Woo00=l
4P0000000`000Woo0P0017oo0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool00`00Oomoo`07Ool0
1000Ooml4P003Goo00<007ooOol02goo00@007ooOol000Qoo`04001oogoo000:Ool00`00Oomoo`0;
Ool01000Oomoo`0027oo00@007ooOol000eoo`03001oogoo00Yoo`04O19oogoo0009Ool01000Oomo
o`0037oo00<007ooOol03goo0008Ool00`00Oomoo`0>Ool00`00Oomoo`09Ool00g`B001oo`0<Ool0
0`00Oomoo`0;Ool01000Oomoo`002goo00<007ooOol027oo0P0037oo00@007ooOol000]oo`03001o
ogoo00]oo`03001oogoo00Yoo`04O19oogoo000<Ool00`00Oomoo`0;Ool00`00Oomoo`0>Ool00003
Ool00000008000Aoo`03001oogoo00Eoo`@000Aoo`03001oogoo00Qoo`03O18007oo00Eoo`@000Ao
o`03001oogoo00Eoo`@0009oo`04001oogoo0009Ool2000;Ool00`00Oomoo`0;Ool01000Oomoo`00
2Goo0P003Woo00<007ooOol02Woo00Al4WooOol000Yoo`8000moo`03001oogoo00eoo`001goo00@0
07ooOol000ioo`03001oogoo00Qoo`03O19oogoo00eoo`03001oogoo00]oo`04001oogoo0009Ool0
0`00Oomoo`0:Ool00`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol03Goo00<007ooOol02Woo
00Al4WooOol000Yoo`03001oogoo00aoo`04001oogoo000>Ool000Qoo`8000ioo`8000Yoo`03O180
000000aoo`8000ioo`8000Yoo`<000Yoo`03001oogoo00aoo`8000Yoo`<000aoo`8000aoo`04O19o
o`00000:Ool3000=Ool2000?Ool002Aoo`03O19oogoo03Eoo`8003Ioo`03O19oogoo02aoo`0097oo
00=l4WooOol0=Goo00<007ooOol0=Goo00=l4WooOol0;7oo000TOol00g`BOomoo`0eOol00`00Oomo
o`0fOol00g`BOomoo`0[Ool002Aoo`03O19oogoo03Eoo`03001oogoo03Ioo`03O19oogoo025oo`80
0003Ool0000000Eoo`001Woo7P0000=l4P000000KP0000=l4P00000070001Woo00<007oo00001Woo
0006Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol0
0003Ool00g`BOomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=o
o`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=o
o`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<0
07ooOol00Woo00D007ooOomoo`0000=oo`05001oogooOol00004Ool01@00Oomoogoo00000goo00<0
07`BOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomo
o`02Ool00`00Oomoo`05Ool00`00Oomoo`05Ool002Aoo`03O19oogoo03Eoo`03001oogoo03Ioo`03
O19oogoo025oo`800003Ool0000000Eoo`0097oo00=l4WooOol0=Goo00<007ooOol0=Goo00=l4Woo
Ool0;7oo000TOol00g`BOomoo`0eOol2000fOol00g`BOomoo`0/Ool002Aoo`03O19oogoo03Eoo`03
001oogoo03Eoo`03O19oogoo02aoo`0097oo00=l4WooOol0=Goo00<007ooOol0=Goo00=l4WooOol0
;7oo000TOol00g`BOomoo`0eOol00`00Oomoo`0eOol00g`BOomoo`0/Ool002Eoo`03O19oogoo03Ao
o`03001oogoo03Eoo`03O19oogoo02aoo`009Goo00=l4WooOol0=7oo0P00=Woo00=l4WooOol0;7oo
000UOol00g`BOomoo`0dOol00`00Oomoo`0eOol00g`BOomoo`0/Ool002Eoo`03O19oogoo03Aoo`03
001oogoo03Eoo`03O19oogoo02aoo`009Goo00=l4WooOol0=7oo00<007ooOol0=7oo00=l4WooOol0
;Goo000VOol00g`BOomoo`0cOol2000eOol00g`BOomoo`0]Ool002Ioo`03O19oogoo03=oo`03001o
ogoo03Aoo`03O19oogoo02eoo`009Woo00=l4WooOol0<goo00<007ooOol0<goo00=l4WooOol0;Woo
000VOol00g`BOomoo`0cOol00`00Oomoo`0cOol00g`BOomoo`0^Ool002Moo`03O19oogoo039oo`80
03Aoo`03O19oogoo02ioo`009goo00=l4WooOol0<Woo00<007ooOol0<Woo00=l4WooOol0;goo000X
Ool00g`BOomoo`0aOol00`00Oomoo`0bOol00g`BOomoo`0_Ool002Qoo`03O19oogoo01moo`8000Ao
o`8000Aoo`8000Aoo`03001oogoo039oo`03O19oogoo02moo`00:7oo00=l4WooOol07Woo00@007oo
Ool000Qoo`04001oogoo0003Ool00`00Oomoo`0bOol00g`BOomoo`0_Ool002Uoo`03O19oogoo01eo
o`04001oogoo000;Ool01000Oomoogoo0P00<Woo00=l4WooOol0<7oo000YOol00g`BOomoo`0MOol0
1000Oomoo`002Goo0P0017oo00<007ooOol0<Goo00=l4WooOol0<7oo000ZOol00g`BOomoo`0LOol0
1000Oomoo`002Goo00<007ooOol00goo00<007ooOol0<7oo00=l4WooOol0<Goo000ZOol00g`BOomo
o`0MOol2000:Ool30003Ool00`00Oomoo`0`Ool00g`BOomoo`0aOol002]oo`03O19oogoo02ioo`80
031oo`03O19oogoo039oo`00:goo00=l4WooOol0;Woo00<007ooOol0;goo00=l4WooOol0<Woo000/
Ool00g`BOomoo`0]Ool00`00Oomoo`0^Ool00g`BOomoo`0cOol002aoo`03O19oogoo02eoo`03001o
ogoo02ioo`03O19oogoo03=oo`00;Goo00=l4WooOol0;7oo0P00;Woo00=l4WooOol0=7oo000^Ool0
0g`BOomoo`0[Ool00`00Oomoo`0/Ool00g`BOomoo`0eOol002moo`03O19oogoo02Yoo`03001oogoo
02]oo`03O19oogoo03Ioo`00;goo00=l4WooOol0:Woo00<007ooOol0:goo00=l4WooOol0=Woo000`
Ool00g`BOomoo`0YOol00`00Oomoo`0ZOol00g`BOomoo`0gOol0035oo`03O19oogoo02Qoo`8002Yo
o`03O19oogoo03Qoo`00<Woo00=l4WooOol09goo00<007ooOol0:7oo00=l4WooOol0>Goo000bOol0
0g`BOomoo`0WOol00`00Oomoo`0XOol00g`BOomoo`0iOol003=oo`03O19oogoo02Ioo`03001oogoo
02Moo`03O19oogoo03Yoo`00=7oo00=l4WooOol09Goo0P009goo00=l4WooOol0>goo000eOol00g`B
Oomoo`0TOol00`00Oomoo`0UOol00g`BOomoo`0lOol003Ioo`03O19oogoo01aoo`D0009oo`03001o
ogoo02Aoo`03O19oogoo03eoo`00=goo00=l4WooOol07Goo00<007ooOol00Woo00<007ooOol08goo
00=l4WooOol0?Woo000hOol00g`BOomoo`0LOol00`00Oomoo`02Ool2000SOol00g`BOomoo`0oOol0
03Uoo`9l4Qaoo`03001oogoo009oo`03001oogoo021oo`9l4T9oo`00>goo00=l4WooOol06Goo00<0
07ooOol00Woo00<007ooOol07goo00=l4WooOol0@Woo000lOol00g`BOomoo`0GOol20004Ool00`00
Oomoo`0NOol00g`BOomoo`13Ool003eoo`9l4Qeoo`03001oogoo01aoo`9l4TIoo`00?goo00=l4Woo
Ool06Woo0P006goo0W`BB7oo0010Ool2O18JOol00`00Oomoo`0HOol2O19:Ool0049oo`9l4QQoo`03
001oogoo01Ioo`9l4Taoo`00A7oo0W`B5Woo00<007ooOol05Goo00=l4WooOol0C7oo0016Ool2O18D
Ool2000DOol2O19?Ool004Qoo`=l4Q5oo`03001oogoo011oo`=l4U5oo`00Bgoo1G`B37oo00<007oo
Ool02goo1G`BE7oo001@Ool5O187Ool00`00Oomoo`06Ool5O19IOol005Eooa1l4Uioo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo001;Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol004]oo`03
001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001EOol4
0003Ool00`00Oomoo`1TOol005Eoo`03001oogoo00Aoo`03001oogoo06Aoo`00EWoo00<007ooOol0
0goo0P00IGoo001GOol00`00Oomoo`1YOol005Eoo`04001oogoo001ZOol005Ioo`8006]oo`00`goo
0033Ool00<=oo`00MWoo0P000goo10000goo0P0017oo0P000goo0`00<goo001eOol01000Oomoo`00
27oo00@007ooOol000Yoo`03001oogoo035oo`00Fgoo10005Woo00<007ooOol00goo10000Woo00@0
07ooOol000Uoo`<0039oo`00FWoo00@007ooOol001Ioo`D000Qoo`04001oogoo0008Ool01000Oomo
o`00<Woo001JOol01000Oomoo`005goo00<007ooOol02Goo00@007ooOol000Qoo`04001oogoo000b
Ool005Uoo`800003Ool0000002Aoo`8000Yoo`<0039oo`00`goo0033Ool00<=oo`00`goo0033Ool0
0001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.85) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

1 0 .9 r

.5 Mabswid

.18875 .49992 m

.19008 .47128 L

.19405 .44281 L

.20063 .41482 L

.20977 .38756 L

.22138 .36127 L

.23537 .33615 L

.25162 .31243 L

.26999 .29031 L

.29031 .26999 L

.31243 .25162 L

.33615 .23537 L

.36127 .22138 L

.38756 .20977 L

.41482 .20063 L

.44281 .19405 L

.47128 .19008 L

.5 .18875 L

.52872 .19008 L

.55719 .19405 L

.58518 .20063 L

.61244 .20977 L

.63873 .22138 L

.66385 .23537 L

.68757 .25162 L

.70969 .26999 L

.73001 .29031 L

.74838 .31243 L

.76463 .33615 L

.77862 .36127 L

.79023 .38756 L

.79937 .41482 L

.80595 .44281 L

.80992 .47128 L

.81125 .49992 L

s

.18875 .50008 m

.19008 .52872 L

.19405 .55719 L

.20063 .58518 L

.20977 .61244 L

.22138 .63873 L

.23537 .66385 L

.25162 .68757 L

.26999 .70969 L

.29031 .73001 L

.31243 .74838 L

.33615 .76463 L

.36127 .77862 L

.38756 .79023 L

.41482 .79937 L

.44281 .80595 L

.47128 .80992 L

.5 .81125 L

.52872 .80992 L

.55719 .80595 L

.58518 .79937 L

.61244 .79023 L

.63873 .77862 L

.66385 .76463 L

.68757 .74838 L

.70969 .73001 L

.73001 .70969 L

.74838 .68757 L

.76463 .66385 L

.77862 .63873 L

.79023 .61244 L

.79937 .58518 L

.80595 .55719 L

.80992 .52872 L

.81125 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{194.313, 194.313},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000320000`Q000`40O003h00O`Woo0032Ool00<9o
o`00EGoo1000JGoo001EOol00`00Oomoo`1ZOol005Ioo`03001oogoo00=oo`8006Aoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0Hgoo001EOol01000Oomoo`000goo00<007ooOol0Hgoo001F
Ool20004Ool00`00Oomoo`1SOol005aoo`8006Aoo`00G7oo00<007ooOol0Hgoo001LOol00`00Oomo
o`1SOol005aoo`03001oogoo06=oo`00G7oo0P00I7oo001LOol00`00Oomoo`1SOol005aoo`03001o
ogoo06=oo`00G7oo00<007ooOol0Hgoo001LOol00`00Oomoo`1SOol005aoo`8006Aoo`00G7oo00<0
07ooOol0Hgoo001LOol00`00Oomoo`1SOol005aoo`03001oogoo06=oo`00G7oo0P00I7oo001LOol0
0`00Oomoo`1SOol004Uoo`D0009oo`8000Aoo`8000Aoo`03001oogoo06=oo`00Bgoo00<007ooOol0
1goo00@007ooOol000=oo`03001oogoo06=oo`00Bgoo00<007ooOol02Woo00@007ooOomoo`8006Ao
o`00@goo100017oo00<007ooOol027oo0P0017oo00<007ooOol0Hgoo001;Ool00`00Oomoo`08Ool0
0`00Oomoo`03Ool00`00Oomoo`1SOol004Yoo`8000Yoo`<000=oo`03001oogoo06=oo`00G7oo0P00
I7oo001LOol00`00Oomoo`1SOol005aoo`03001oogoo06=oo`00G7oo00<007ooOol0Hgoo001LOol0
0`00Oomoo`1SOol005aoo`8006Aoo`00G7oo00<007ooOol0Hgoo001EOol?O1aNOol0051oo`El70Mo
o`03001oogoo00Eoo`El75Uoo`00CGoo0g`L37oo0P002goo0g`LEWoo001;Ool2O1`?Ool00`00Oomo
o`0=Ool2O1aDOol004Qoo`=l715oo`03001oogoo00moo`=l755oo`00AWoo0W`L57oo00<007ooOol0
4Woo0W`LCgoo0014Ool2O1`FOol2000EOol2O1a=Ool0049oo`9l71Qoo`03001oogoo01Ioo`9l74]o
o`00@7oo0W`L6Woo00<007ooOol067oo0W`LBGoo000oOol00g`LOomoo`0COol50002Ool00`00Oomo
o`0JOol00g`LOomoo`16Ool003eoo`9l71Qoo`03001oogoo009oo`03001oogoo01]oo`9l74Ioo`00
?7oo00=l77ooOol067oo00<007ooOol00Woo0P007Woo00=l77ooOol0@goo000kOol00g`LOomoo`0A
Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`0NOol00g`LOomoo`12Ool003Uoo`9l71aoo`03001o
ogoo009oo`03001oogoo01moo`9l749oo`00>7oo00=l77ooOol06goo0P0017oo00<007ooOol08Goo
00=l77ooOol0?goo000gOol00g`LOomoo`0ROol2000SOol00g`LOomoo`0nOol003Ioo`03O1aoogoo
02=oo`03001oogoo02=oo`03O1aoogoo03eoo`00=Woo00=l77ooOol08goo00<007ooOol08goo00=l
77ooOol0?Goo000eOol00g`LOomoo`0TOol00`00Oomoo`0TOol00g`LOomoo`0lOol003Aoo`03O1ao
ogoo02Eoo`8002Ioo`03O1aoogoo03]oo`00<Woo0W`L:7oo00<007ooOol09Woo0W`L>goo000aOol0
0g`LOomoo`0XOol00`00Oomoo`0XOol00g`LOomoo`0hOol0031oo`03O1aoogoo02Uoo`03001oogoo
02Uoo`03O1aoogoo03Moo`00<7oo00=l77ooOol0:Goo0P00:Woo00=l77ooOol0=goo000_Ool00g`L
Oomoo`0ZOol00`00Oomoo`0ZOol00g`LOomoo`0fOol002moo`03O1aoogoo02Yoo`03001oogoo02Yo
o`03O1aoogoo03Ioo`00;Woo00=l77ooOol0:goo00<007ooOol0:goo00=l77ooOol0=Goo000^Ool0
0g`LOomoo`0[Ool00`00Oomoo`0[Ool00g`LOomoo`0eOol002eoo`03O1aoogoo02aoo`8002eoo`03
O1aoogoo03Aoo`00;Goo00=l77ooOol0;7oo00<007ooOol0;7oo00=l77ooOol0=7oo000/Ool00g`L
Oomoo`0KOol20004Ool20004Ool20004Ool00`00Oomoo`0]Ool00g`LOomoo`0cOol002]oo`03O1ao
ogoo01]oo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol0;Woo00=l77ooOol0<Woo000[
Ool00g`LOomoo`0KOol01000Oomoo`002goo00@007ooOomoo`8002moo`03O1aoogoo039oo`00:Woo
00=l77ooOol05Woo10000Woo00@007ooOol000Uoo`8000Aoo`03001oogoo02moo`03O1aoogoo035o
o`00:Woo00=l77ooOol077oo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo02moo`03O1ao
ogoo035oo`00:Woo00=l77ooOol07Goo0P002Woo0`000goo00<007ooOol0;goo00=l77ooOol0<Goo
000ZOol00g`LOomoo`0_Ool2000`Ool00g`LOomoo`0aOol002Uoo`03O1aoogoo031oo`03001oogoo
031oo`03O1aoogoo031oo`00:Goo00=l77ooOol0<7oo00<007ooOol0<7oo00=l77ooOol0<7oo000Y
Ool00g`LOomoo`0`Ool00`00Oomoo`0`Ool00g`LOomoo`0`Ool002Uoo`03O1aoogoo031oo`03001o
ogoo031oo`03O1aoogoo031oo`00:7oo00=l77ooOol0<Goo0P00<Woo00=l77ooOol0;goo000XOol0
0g`LOomoo`0aOol00`00Oomoo`0aOol00g`LOomoo`0_Ool000Moo`@000aoo`D0009oo`8000Aoo`80
0003Ooml77oo00Uoo`D000aoo`8000Aoo`8000Aoo`8000]oo`03001oogoo00]oo`8000Aoo`8000Ao
o`8000eoo`D000Moo`03O1aoogoo00D0009oo`8000Aoo`8000eoo`@000ioo`001goo00<007ooOol0
3goo00<007ooOol01goo00D007ooOol007`L00aoo`03001oogoo00]oo`04001oogoo0008Ool01000
Oomoo`002Woo00<007ooOol02Woo00@007ooOol000Qoo`04001oogoo000>Ool00`00Oomoo`07Ool0
0g`LOomoo`02Ool00`00Oomoo`07Ool01000Oomoo`0037oo00<007ooOol03goo0008Ool00`00Oomo
o`0>Ool00`00Oomoo`0:Ool00`00O1aoo`0;Ool00`00Oomoo`0;Ool01000Oomoo`002goo00<007oo
Ool027oo0P002goo00@007ooOol000]oo`03001oogoo00aoo`03001oogoo00Moo`03O1aoogoo009o
o`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00ioo`0000=oo`0000000P0017oo00<007oo
Ool01Goo100017oo00<007ooOol027oo0P0000=oog`LOol00goo100017oo00<007ooOol01Goo1000
0Woo00@007ooOol000Uoo`8000]oo`03001oogoo00Yoo`04001oogoo0009Ool2000?Ool00`00Oomo
o`07Ool00g`LOomoo`02Ool00`00Oomoo`08Ool2000?Ool00`00Oomoo`0=Ool000Moo`04001oogoo
000>Ool00`00Oomoo`08Ool01000Oomoog`L37oo00<007ooOol02goo00@007ooOol000Uoo`03001o
ogoo00Yoo`03001oogoo00Yoo`04001oogoo0009Ool00`00Oomoo`0>Ool00`00Oomoo`07Ool00g`L
Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool01000Oomoo`003Woo0008Ool2000>Ool2000:
Ool300000g`LOomoo`09Ool2000>Ool2000:Ool3000:Ool00`00Oomoo`0;Ool2000:Ool3000=Ool2
0009Ool017`LOomoogoo0P002Woo0`003Goo0P003goo000WOol00g`LOomoo`0bOol2000cOol00g`L
Oomoo`0^Ool002Moo`03O1aoogoo039oo`03001oogoo039oo`03O1aoogoo02ioo`009goo00=l77oo
Ool0<Woo00<007ooOol0<Woo00=l77ooOol0;Woo000WOol00g`LOomoo`0bOol00`00Oomoo`0bOol0
0g`LOomoo`0TOol200000goo00000005Ool002Moo`03O1aoogoo039oo`03001oogoo039oo`03O1ao
ogoo02Eoo`03001oo`0000Ioo`001Woo8@0000=l70000000I`0000=l700000007`001goo00<007oo
Ool01Goo0006Ool00`00Oomoo`0COol00`00Oomoo`08Ool00g`LOomoo`07Ool00`00Oomoo`0COol0
0`00Oomoo`0BOol00`00Oomoo`0BOol00`00Oomoo`0COol00`00Oomoo`07Ool00g`LOomoo`08Ool0
0`00Oomoo`0COol00`00Oomoo`03Ool200000goo00000005Ool002Moo`03O1aoogoo039oo`03001o
ogoo039oo`03O1aoogoo02ioo`009goo00=l77ooOol0<Woo00<007ooOol0<Woo00=l77ooOol0;Woo
000WOol00g`LOomoo`0bOol2000cOol00g`LOomoo`0^Ool002Moo`03O1aoogoo039oo`03001oogoo
039oo`03O1aoogoo02ioo`009goo00=l77ooOol0<Woo00<007ooOol0<Woo00=l77ooOol0;Woo000W
Ool00g`LOomoo`0bOol00`00Oomoo`0bOol00g`LOomoo`0^Ool002Moo`03O1aoogoo039oo`8003=o
o`03O1aoogoo02ioo`009goo00=l77ooOol0<Woo00<007ooOol0<Woo00=l77ooOol0;Woo000WOol0
0g`LOomoo`0bOol00`00Oomoo`0bOol00g`LOomoo`0^Ool002Qoo`03O1aoogoo035oo`03001oogoo
035oo`03O1aoogoo02moo`00:7oo00=l77ooOol0<Goo0P00<Woo00=l77ooOol0;goo000YOol00g`L
Oomoo`0`Ool00`00Oomoo`0`Ool00g`LOomoo`0`Ool002Uoo`03O1aoogoo031oo`03001oogoo031o
o`03O1aoogoo031oo`00:Goo00=l77ooOol0<7oo00<007ooOol0<7oo00=l77ooOol0<7oo000YOol0
0g`LOomoo`0`Ool00`00Oomoo`0`Ool00g`LOomoo`0`Ool002Yoo`03O1aoogoo02moo`80031oo`03
O1aoogoo035oo`00:Woo00=l77ooOol0;goo00<007ooOol0;goo00=l77ooOol0<Goo000ZOol00g`L
Oomoo`0MOol20004Ool20004Ool20004Ool00`00Oomoo`0_Ool00g`LOomoo`0aOol002]oo`03O1ao
ogoo01]oo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol0;Woo00=l77ooOol0<Woo000[
Ool00g`LOomoo`0KOol01000Oomoo`002goo00@007ooOomoo`8002moo`03O1aoogoo039oo`00;7oo
00=l77ooOol06Woo00@007ooOol000Uoo`8000Aoo`03001oogoo02eoo`03O1aoogoo03=oo`00;7oo
00=l77ooOol06Woo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo02eoo`03O1aoogoo03=o
o`00;Goo00=l77ooOol06Woo0P002Woo0`000goo00<007ooOol0;7oo00=l77ooOol0=7oo000]Ool0
0g`LOomoo`0/Ool2000]Ool00g`LOomoo`0dOol002ioo`03O1aoogoo02]oo`03001oogoo02]oo`03
O1aoogoo03Eoo`00;Woo00=l77ooOol0:goo00<007ooOol0:goo00=l77ooOol0=Goo000_Ool00g`L
Oomoo`0ZOol00`00Oomoo`0ZOol00g`LOomoo`0fOol0031oo`03O1aoogoo02Uoo`03001oogoo02Uo
o`03O1aoogoo03Moo`00<7oo00=l77ooOol0:Goo0P00:Woo00=l77ooOol0=goo000aOol00g`LOomo
o`0XOol00`00Oomoo`0XOol00g`LOomoo`0hOol0035oo`03O1aoogoo02Qoo`03001oogoo02Qoo`03
O1aoogoo03Qoo`00<Woo00=l77ooOol09goo00<007ooOol09goo00=l77ooOol0>Goo000cOol00g`L
Oomoo`0VOol2000WOol00g`LOomoo`0jOol003Aoo`03O1aoogoo02Eoo`03001oogoo02Eoo`03O1ao
ogoo03]oo`00=Goo00=l77ooOol097oo00<007ooOol097oo00=l77ooOol0?7oo000fOol00g`LOomo
o`0SOol00`00Oomoo`0SOol00g`LOomoo`0mOol003Moo`03O1aoogoo029oo`8002=oo`03O1aoogoo
03ioo`00>7oo00=l77ooOol08Goo00<007ooOol08Goo00=l77ooOol0?goo000iOol00g`LOomoo`0I
Ool50002Ool00`00Oomoo`0POol00g`LOomoo`10Ool003Yoo`9l71]oo`03001oogoo009oo`03001o
ogoo01ioo`9l74=oo`00?7oo00=l77ooOol067oo00<007ooOol00Woo0P007Woo00=l77ooOol0@goo
000mOol00g`LOomoo`0GOol00`00Oomoo`02Ool00`00Oomoo`0LOol00g`LOomoo`14Ool003ioo`9l
71Moo`03001oogoo009oo`03001oogoo01Yoo`9l74Moo`00@7oo00=l77ooOol04goo0P0017oo00<0
07ooOol06Goo00=l77ooOol0Agoo0011Ool2O1`IOol00`00Oomoo`0GOol2O1a:Ool004=oo`=l71Io
o`8001Eoo`=l74aoo`00AWoo0W`L57oo00<007ooOol04Woo0W`LCgoo0018Ool2O1`BOol00`00Oomo
o`0@Ool2O1aAOol004Yoo`9l711oo`03001oogoo00ioo`9l75=oo`00C7oo17`L37oo0P002goo17`L
EGoo001@Ool5O1`7Ool00`00Oomoo`05Ool5O1aIOol005Eoo`ml75ioo`00G7oo00<007ooOol0Hgoo
001LOol2001TOol005aoo`03001oogoo06=oo`00G7oo00<007ooOol0Hgoo001LOol00`00Oomoo`1S
Ool005aoo`03001oogoo06=oo`00G7oo0P00I7oo001LOol00`00Oomoo`1SOol004Uoo`D0009oo`80
00Aoo`8000Aoo`03001oogoo06=oo`00Bgoo00<007ooOol01goo00@007ooOol000=oo`03001oogoo
06=oo`00Bgoo00<007ooOol02Woo00@007ooOomoo`8006Aoo`00Bgoo00<007ooOol027oo0P0017oo
00<007ooOol0Hgoo001;Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`1SOol004Yoo`80
00Yoo`<000=oo`03001oogoo06=oo`00G7oo0P00I7oo001LOol00`00Oomoo`1SOol005aoo`03001o
ogoo06=oo`00G7oo00<007ooOol0Hgoo001LOol2001TOol005aoo`03001oogoo06=oo`00G7oo00<0
07ooOol0Hgoo001LOol00`00Oomoo`1SOol005aoo`03001oogoo06=oo`00G7oo0P00I7oo001LOol0
0`00Oomoo`1SOol005aoo`03001oogoo06=oo`00G7oo00<007ooOol0Hgoo001LOol2001TOol005ao
o`03001oogoo06=oo`00EGoo10000goo00<007ooOol0Hgoo001EOol00`00Oomoo`04Ool00`00Oomo
o`1SOol005Ioo`03001oogoo00=oo`8006Aoo`00Egoo00<007ooOol0J7oo001EOol01000Oomoo`00
JGoo001FOol2001ZOol00<9oo`00`Woo0032Ool007=oo`8000=oo`@000=oo`8000Aoo`8000Aoo`80
00Aoo`8002moo`00LWoo00@007ooOol000Qoo`04001oogoo0008Ool01000Oomoo`000Woo00@007oo
Ool002ioo`00Fgoo10004goo00<007ooOol00goo10000Woo00@007ooOol000Qoo`04001oogoo0005
Ool00`00Oomoo`0/Ool005Yoo`04001oogoo000COol50008Ool01000Oomoo`002Goo0P0017oo0P00
;goo001JOol01000Oomoo`0057oo00<007ooOol02Goo00@007ooOol000Qoo`04001oogoo0003Ool0
0`00Oomoo`0^Ool005Uoo`800003Ool00000025oo`8000Yoo`8000Aoo`<002ioo`00`Woo0032Ool0
0<9oo`00`Woo0032Ool00001\
\>"],
  ImageRangeCache->{{{0, 193.313}, {193.313, 0}} -> {-2.15587, -2.10489, \
0.023304, 0.023304}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.8) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.8 0 1 r

.5 Mabswid

.2042 .49992 m

.20546 .47271 L

.20923 .44565 L

.21549 .41905 L

.22417 .39314 L

.23521 .36815 L

.2485 .34428 L

.26394 .32174 L

.2814 .30072 L

.30072 .2814 L

.32174 .26394 L

.34428 .2485 L

.36815 .23521 L

.39314 .22417 L

.41905 .21549 L

.44565 .20923 L

.47271 .20546 L

.5 .2042 L

.52729 .20546 L

.55435 .20923 L

.58095 .21549 L

.60686 .22417 L

.63185 .23521 L

.65572 .2485 L

.67826 .26394 L

.69928 .2814 L

.7186 .30072 L

.73606 .32174 L

.7515 .34428 L

.76479 .36815 L

.77583 .39314 L

.78451 .41905 L

.79077 .44565 L

.79454 .47271 L

.7958 .49992 L

s

.2042 .50008 m

.20546 .52729 L

.20923 .55435 L

.21549 .58095 L

.22417 .60686 L

.23521 .63185 L

.2485 .65572 L

.26394 .67826 L

.2814 .69928 L

.30072 .7186 L

.32174 .73606 L

.34428 .7515 L

.36815 .76479 L

.39314 .77583 L

.41905 .78451 L

.44565 .79077 L

.47271 .79454 L

.5 .7958 L

.52729 .79454 L

.55435 .79077 L

.58095 .78451 L

.60686 .77583 L

.63185 .76479 L

.65572 .7515 L

.67826 .73606 L

.69928 .7186 L

.7186 .69928 L

.73606 .67826 L

.7515 .65572 L

.76479 .63185 L

.77583 .60686 L

.78451 .58095 L

.79077 .55435 L

.79454 .52729 L

.7958 .50008 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001FOol>I1mOOol0055oo`ET7`Ioo`03001oogoo00Eoo`AT
7e]oo`00CWoo0f@O2goo00<007ooOol02Goo16@OEgoo001<Ool2I1l>Ool00`00Oomoo`0=Ool2I1mE
Ool004Yoo`9T7a1oo`80011oo`9T7e=oo`00B7oo0V@O4Woo00<007ooOol04Goo0V@ODGoo0016Ool2
I1l=Ool50002Ool00`00Oomoo`0COol2I1m?Ool004Aoo`9T7a5oo`03001oogoo009oo`03001oogoo
01Eoo`9T7deoo`00@Woo0V@O4goo00<007ooOol00Woo0P0067oo0V@OBgoo0010Ool2I1l=Ool40004
Ool00`00Oomoo`02Ool00`00Oomoo`0IOol2I1m9Ool003ioo`9T7aMoo`03001oogoo009oo`03001o
ogoo01]oo`9T7dMoo`00?Goo00=T7gooOol05Woo0P0017oo00<007ooOol07Goo00=T7gooOol0A7oo
000kOol2I1lOOol2000OOol2I1m4Ool003Yoo`03I1moogoo01moo`03001oogoo021oo`03I1moogoo
045oo`00>Goo00=T7gooOol087oo00<007ooOol08Goo00=T7gooOol0@7oo000hOol00f@OOomoo`0Q
Ool00`00Oomoo`0ROol00f@OOomoo`0oOol003Qoo`03I1moogoo025oo`03001oogoo029oo`03I1mo
ogoo03moo`00=goo00=T7gooOol08Woo0P0097oo00=T7gooOol0?Woo000fOol00f@OOomoo`0SOol0
0`00Oomoo`0TOol00f@OOomoo`0mOol003Eoo`03I1moogoo02Aoo`03001oogoo02Eoo`03I1moogoo
03aoo`00=7oo00=T7gooOol09Goo00<007ooOol09Woo00=T7gooOol0>goo000cOol00f@OOomoo`0V
Ool2000XOol00f@OOomoo`0jOol0039oo`03I1moogoo02Moo`03001oogoo02Qoo`03I1moogoo03Uo
o`00<Woo00=T7gooOol09goo00<007ooOol0:7oo00=T7gooOol0>Goo000aOol00f@OOomoo`0XOol0
0`00Oomoo`0YOol00f@OOomoo`0hOol0031oo`03I1moogoo02Uoo`8002]oo`03I1moogoo03Moo`00
<7oo00=T7gooOol0:Goo00<007ooOol0:Woo00=T7gooOol0=goo000_Ool00f@OOomoo`0ZOol00`00
Oomoo`0[Ool00f@OOomoo`0fOol002moo`03I1moogoo01Qoo`8000Aoo`8000Aoo`8000Aoo`03001o
ogoo02]oo`03I1moogoo03Ioo`00;goo00=T7gooOol05goo00@007ooOol000Qoo`04001oogoo0003
Ool00`00Oomoo`0[Ool00f@OOomoo`0fOol002ioo`03I1moogoo01Qoo`04001oogoo000;Ool01000
Oomoogoo0P00;Goo00=T7gooOol0=Goo000^Ool00f@OOomoo`0BOol40002Ool01000Oomoo`002Goo
0P0017oo00<007ooOol0;7oo00=T7gooOol0=Goo000]Ool00f@OOomoo`0IOol01000Oomoo`002Goo
00<007ooOol00goo00<007ooOol0;Goo00=T7gooOol0=7oo000]Ool00f@OOomoo`0JOol2000:Ool3
0003Ool00`00Oomoo`0]Ool00f@OOomoo`0dOol002aoo`03I1moogoo02eoo`8002ioo`03I1moogoo
03Aoo`00;7oo00=T7gooOol0;Goo00<007ooOol0;Woo00=T7gooOol0<goo000[Ool00f@OOomoo`0^
Ool00`00Oomoo`0^Ool00f@OOomoo`0cOol002]oo`03I1moogoo02ioo`03001oogoo02ioo`03I1mo
ogoo03=oo`00:goo00=T7gooOol0;Woo0P00;goo00=T7gooOol0<goo000[Ool00f@OOomoo`0^Ool0
0`00Oomoo`0^Ool00f@OOomoo`0cOol002Yoo`03I1moogoo02moo`03001oogoo02moo`03I1moogoo
039oo`001goo100037oo1@000Woo0P0017oo0P0017oo00=T7gooOol01Goo1@0037oo0P0017oo0P00
17oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo1@0017oo00=T7gooOol017oo1@00
0Woo0P0017oo0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool00`00Oomoo`07Ool01000Oomoo`00
0goo00=T7gooOol01goo00<007ooOol02goo00@007ooOol000Qoo`04001oogoo000:Ool00`00Oomo
o`0;Ool01000Oomoo`0027oo00@007ooOol000eoo`03001oogoo00Aoo`03I1moogoo00Ioo`03001o
ogoo00Moo`04001oogoo000<Ool00`00Oomoo`0?Ool000Qoo`03001oogoo00ioo`03001oogoo00Yo
o`05001oogooOomT7`09Ool00`00Oomoo`0;Ool01000Oomoo`002goo00<007ooOol027oo0P0037oo
00@007ooOol000]oo`03001oogoo00]oo`03001oogoo00Aoo`03I1moogoo00Ioo`03001oogoo00Yo
o`03001oogoo00]oo`03001oogoo00ioo`0000=oo`0000000P0017oo00<007ooOol01Goo100017oo
00<007ooOol027oo0P0017oo00=T7goo00000`0017oo00<007ooOol01Goo10000Woo00@007ooOol0
00Uoo`8000]oo`03001oogoo00]oo`04001oogoo0009Ool2000>Ool00`00Oomoo`05Ool00f@OOomo
o`05Ool00`00Oomoo`08Ool2000?Ool00`00Oomoo`0=Ool000Moo`04001oogoo000>Ool00`00Oomo
o`08Ool00`00Oomoo`03Ool00f@OOomoo`07Ool00`00Oomoo`0;Ool01000Oomoo`002Goo00<007oo
Ool02Woo00<007ooOol02goo00@007ooOol000Uoo`03001oogoo00eoo`03001oogoo00Eoo`03I1mo
ogoo00Eoo`03001oogoo00Qoo`03001oogoo00aoo`04001oogoo000>Ool000Qoo`8000ioo`8000Yo
o`<000=oo`03I1moogoo00Ioo`8000ioo`8000Yoo`<000Yoo`03001oogoo00aoo`8000Yoo`<000ao
o`8000Moo`03I1moogoo00Aoo`8000Yoo`<000eoo`8000moo`00:Woo00=T7gooOol0;goo0P00<Goo
00=T7gooOol0<Goo000ZOol00f@OOomoo`0_Ool00`00Oomoo`0`Ool00f@OOomoo`0aOol002Uoo`03
I1moogoo031oo`03001oogoo031oo`03I1moogoo035oo`00:Goo00=T7gooOol0<7oo00<007ooOol0
<7oo00=T7gooOol09goo0P0000=oo`0000001Goo0006OolS00000f@O0000001S00000f@O0000000R
0006Ool00`00Ool00006Ool000Ioo`05001oogooOol00004Ool01@00Oomoogoo00000goo00<007oo
Ool00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05I1moogooOol00003Ool00`00Oomoo`02
Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`05001oogooOol00004
Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05
001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`0000Aoo`05
001oogooI1l00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007oo
Oomoo`0000=oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`00:Goo00=T7gooOol0
<7oo00<007ooOol0<7oo00=T7gooOol09goo0P0000=oo`0000001Goo000ZOol00f@OOomoo`0_Ool0
0`00Oomoo`0`Ool00f@OOomoo`0aOol002Yoo`03I1moogoo02moo`80035oo`03I1moogoo035oo`00
:Woo00=T7gooOol0;goo00<007ooOol0<7oo00=T7gooOol0<Goo000ZOol00f@OOomoo`0_Ool00`00
Oomoo`0`Ool00f@OOomoo`0aOol002Yoo`03I1moogoo02moo`03001oogoo031oo`03I1moogoo035o
o`00:Woo00=T7gooOol0;goo00<007ooOol0;goo00=T7gooOol0<Woo000ZOol00f@OOomoo`0_Ool2
000`Ool00f@OOomoo`0bOol002Yoo`03I1moogoo02moo`03001oogoo02moo`03I1moogoo039oo`00
:Woo00=T7gooOol0;goo00<007ooOol0;goo00=T7gooOol0<Woo000[Ool00f@OOomoo`0^Ool00`00
Oomoo`0^Ool00f@OOomoo`0cOol002]oo`03I1moogoo02ioo`8002moo`03I1moogoo03=oo`00:goo
00=T7gooOol0;Woo00<007ooOol0;Woo00=T7gooOol0<goo000[Ool00f@OOomoo`0^Ool00`00Oomo
o`0^Ool00f@OOomoo`0cOol002aoo`03I1moogoo02eoo`03001oogoo02ioo`03I1moogoo03=oo`00
;7oo00=T7gooOol0;Goo0P00;Woo00=T7gooOol0=7oo000]Ool00f@OOomoo`0/Ool00`00Oomoo`0]
Ool00f@OOomoo`0dOol002eoo`03I1moogoo02aoo`03001oogoo02eoo`03I1moogoo03Aoo`00;Woo
00=T7gooOol06Goo0P0017oo0P0017oo0P0017oo00<007ooOol0;7oo00=T7gooOol0=Goo000^Ool0
0f@OOomoo`0HOol01000Oomoo`0027oo00@007ooOol000=oo`03001oogoo02aoo`03I1moogoo03Eo
o`00;goo00=T7gooOol05goo00@007ooOol000]oo`04001oogooOol2000/Ool00f@OOomoo`0fOol0
02moo`03I1moogoo01Moo`04001oogoo0009Ool20004Ool00`00Oomoo`0[Ool00f@OOomoo`0fOol0
031oo`03I1moogoo01Ioo`04001oogoo0009Ool00`00Oomoo`03Ool00`00Oomoo`0ZOol00f@OOomo
o`0gOol0031oo`03I1moogoo01Moo`8000Yoo`<000=oo`03001oogoo02Yoo`03I1moogoo03Moo`00
<Goo00=T7gooOol0:7oo0P00:Woo00=T7gooOol0>7oo000aOol00f@OOomoo`0XOol00`00Oomoo`0Y
Ool00f@OOomoo`0hOol0039oo`03I1moogoo02Moo`03001oogoo02Qoo`03I1moogoo03Uoo`00<goo
00=T7gooOol09Woo00<007ooOol09goo00=T7gooOol0>Woo000cOol00f@OOomoo`0VOol2000XOol0
0f@OOomoo`0jOol003Aoo`03I1moogoo02Eoo`03001oogoo02Ioo`03I1moogoo03]oo`00=Goo00=T
7gooOol097oo00<007ooOol09Goo00=T7gooOol0?7oo000fOol00f@OOomoo`0SOol00`00Oomoo`0T
Ool00f@OOomoo`0mOol003Moo`03I1moogoo029oo`03001oogoo02=oo`03I1moogoo03ioo`00>7oo
00=T7gooOol08Goo0P008goo00=T7gooOol0?goo000iOol00f@OOomoo`0POol00`00Oomoo`0QOol0
0f@OOomoo`10Ool003Uoo`03I1moogoo021oo`03001oogoo025oo`03I1moogoo041oo`00>Woo00=T
7gooOol07goo00<007ooOol087oo00=T7gooOol0@Goo000kOol00f@OOomoo`0NOol2000POol00f@O
Oomoo`12Ool003aoo`9T7aioo`03001oogoo01eoo`9T7dEoo`00?Woo00=T7gooOol057oo1@000Woo
00<007ooOol077oo00=T7gooOol0AGoo000oOol2I1lFOol00`00Oomoo`02Ool00`00Oomoo`0JOol2
I1m8Ool0045oo`9T7aAoo`03001oogoo009oo`8001Uoo`9T7dYoo`00@goo00=T7gooOol04Goo00<0
07ooOol00Woo00<007ooOol05goo00=T7gooOol0BWoo0014Ool2I1lAOol00`00Oomoo`02Ool00`00
Oomoo`0EOol2I1m=Ool004Ioo`03I1moogoo00eoo`8000Aoo`03001oogoo01Aoo`03I1moogoo04eo
o`00Agoo0V@O4goo00<007ooOol04Woo0V@OD7oo0019Ool3I1l@Ool2000?Ool4I1mBOol004aoo`ET
7`]oo`03001oogoo00Yoo`AT7eIoo`00DGoo1F@O1Woo00<007ooOol01Goo1F@OFWoo001FOol>I1mO
Ool005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo
06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007oo
Ool0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo0019Ool50002
Ool20004Ool20004Ool00`00Oomoo`1TOol004]oo`03001oogoo00Moo`04001oogoo0003Ool00`00
Oomoo`1TOol004]oo`03001oogoo00Yoo`04001oogooOol2001UOol004]oo`03001oogoo00Qoo`80
00Aoo`03001oogoo06Aoo`00Bgoo00<007ooOol027oo00<007ooOol00goo00<007ooOol0I7oo001:
Ool2000:Ool30003Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo
001LOol00`00Oomoo`1TOol005Eoo`@000=oo`03001oogoo06Aoo`00EGoo00<007ooOol017oo00<0
07ooOol0I7oo001FOol00`00Oomoo`03Ool2001UOol005Moo`03001oogoo06Uoo`00EGoo00@007oo
Ool006Yoo`00EWoo0P00Jgoo0033Ool00<=oo`00`goo001fOol20003Ool40003Ool20004Ool20004
Ool2000cOol007Eoo`04001oogoo0008Ool01000Oomoo`0027oo00@007ooOol0039oo`00Fgoo1000
5Woo00<007ooOol00goo10000Woo00@007ooOol000Qoo`04001oogoo000bOol005Yoo`04001oogoo
000FOol50008Ool01000Oomoo`002Goo0P00<goo001JOol01000Oomoo`005goo00<007ooOol02Goo
00@007ooOol000Qoo`04001oogoo000bOol005Uoo`800003Ool0000002Aoo`8000Yoo`8003=oo`00
`goo0033Ool00<=oo`00`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.75) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.5 0 1 r

.5 Mabswid

.22049 .49993 m

.22168 .47421 L

.22525 .44864 L

.23116 .42351 L

.23937 .39903 L

.24979 .37541 L

.26236 .35286 L

.27695 .33156 L

.29344 .3117 L

.3117 .29344 L

.33156 .27695 L

.35286 .26236 L

.37541 .24979 L

.39903 .23937 L

.42351 .23116 L

.44864 .22525 L

.47421 .22168 L

.5 .22049 L

.52579 .22168 L

.55136 .22525 L

.57649 .23116 L

.60097 .23937 L

.62459 .24979 L

.64714 .26236 L

.66844 .27695 L

.6883 .29344 L

.70656 .3117 L

.72305 .33156 L

.73764 .35286 L

.75021 .37541 L

.76063 .39903 L

.76884 .42351 L

.77475 .44864 L

.77832 .47421 L

.77951 .49993 L

s

.22049 .50007 m

.22168 .52579 L

.22525 .55136 L

.23116 .57649 L

.23937 .60097 L

.24979 .62459 L

.26236 .64714 L

.27695 .66844 L

.29344 .6883 L

.3117 .70656 L

.33156 .72305 L

.35286 .73764 L

.37541 .75021 L

.39903 .76063 L

.42351 .76884 L

.44864 .77475 L

.47421 .77832 L

.5 .77951 L

.52579 .77832 L

.55136 .77475 L

.57649 .76884 L

.60097 .76063 L

.62459 .75021 L

.64714 .73764 L

.66844 .72305 L

.6883 .70656 L

.70656 .6883 L

.72305 .66844 L

.73764 .64714 L

.75021 .62459 L

.76063 .60097 L

.76884 .57649 L

.77475 .55136 L

.77832 .52579 L

.77951 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001FOol=?1mPOol0059oo`@l7`Ioo`8000Eoo`Dl7e]oo`00CWoo13`O2Woo
00<007ooOol02Goo13`OEgoo001;Ool3?1l7Ool50002Ool00`00Oomoo`0=Ool3?1mDOol004Uoo`8l
7`aoo`03001oogoo009oo`03001oogoo011oo`8l7e9oo`00Agoo0S`O3Woo00<007ooOol00Woo0P00
4goo0S`OD7oo0015Ool2?1l8Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`0DOol2?1m>Ool004=o
o`8l7a9oo`03001oogoo009oo`03001oogoo01Ioo`8l7daoo`00@Woo00<l7gooOol04Goo0P0017oo
00<007ooOol067oo00<l7gooOol0BGoo0010Ool2?1lJOol2000JOol00c`OOomoo`18Ool003moo`03
?1moogoo01Yoo`03001oogoo01Yoo`03?1moogoo04Moo`00?Woo00<l7gooOol06goo00<007ooOol0
6goo00<l7gooOol0AWoo000mOol00c`OOomoo`0LOol00`00Oomoo`0LOol2?1m6Ool003aoo`03?1mo
ogoo01eoo`03001oogoo01ioo`03?1moogoo04=oo`00>goo00<l7gooOol07Woo0P0087oo00<l7goo
Ool0@Woo000jOol00c`OOomoo`0OOol00`00Oomoo`0POol00c`OOomoo`11Ool003Uoo`03?1moogoo
021oo`03001oogoo025oo`03?1moogoo041oo`00>7oo00<l7gooOol08Goo00<007ooOol08Woo00<l
7gooOol0?goo000gOol00c`OOomoo`0ROol2000TOol00c`OOomoo`0nOol003Ioo`03?1moogoo02=o
o`03001oogoo02Aoo`03?1moogoo03eoo`00=Goo00<l7gooOol097oo00<007ooOol09Goo00<l7goo
Ool0?7oo000dOol00c`OOomoo`0UOol00`00Oomoo`0UOol00c`OOomoo`0lOol003Aoo`03?1moogoo
02Eoo`8002Moo`03?1moogoo03]oo`00<goo00<l7gooOol09Woo00<007ooOol09Woo00<l7gooOol0
>goo000bOol00c`OOomoo`0WOol00`00Oomoo`0WOol00c`OOomoo`0jOol0039oo`03?1moogoo01Eo
o`8000Aoo`8000Aoo`8000Aoo`03001oogoo02Moo`03?1moogoo03Yoo`00<Goo00<l7gooOol05Goo
00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`0XOol00c`OOomoo`0iOol0035oo`03?1mo
ogoo01Eoo`04001oogoo000;Ool01000Oomoogoo0P00:Goo00<l7gooOol0>Goo000`Ool00c`OOomo
o`0@Ool40002Ool01000Oomoo`002Goo0P0017oo00<007ooOol0:Goo00<l7gooOol0>7oo000`Ool0
0c`OOomoo`0FOol01000Oomoo`002Goo00<007ooOol00goo00<007ooOol0:Goo00<l7gooOol0>7oo
000_Ool00c`OOomoo`0HOol2000:Ool30003Ool00`00Oomoo`0ZOol00c`OOomoo`0gOol002moo`03
?1moogoo02Yoo`8002]oo`03?1moogoo03Moo`00;goo00<l7gooOol0:Woo00<007ooOol0:goo00<l
7gooOol0=Woo000^Ool00c`OOomoo`0[Ool00`00Oomoo`0[Ool00c`OOomoo`0fOol002ioo`03?1mo
ogoo02]oo`03001oogoo02aoo`03?1moogoo03Eoo`00;Woo00<l7gooOol0:goo0P00;Goo00<l7goo
Ool0=Goo000^Ool00c`OOomoo`0[Ool00`00Oomoo`0/Ool00c`OOomoo`0eOol002eoo`03?1moogoo
02aoo`03001oogoo02eoo`03?1moogoo03Aoo`001goo100037oo1@000Woo0P0017oo0P001goo00<l
7gooOol00Woo1@0037oo0P0017oo0P0017oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P00
37oo1@000Woo00<l7gooOol01Woo1@000Woo0P0017oo0P003Goo10003Woo0007Ool00`00Oomoo`0?
Ool00`00Oomoo`07Ool01000Oomoo`001Woo00<l7gooOol017oo00<007ooOol02goo00@007ooOol0
00Qoo`04001oogoo000:Ool00`00Oomoo`0;Ool01000Oomoo`0027oo00@007ooOol000eoo`03001o
ogoo009oo`03?1moogoo00Qoo`03001oogoo00Moo`04001oogoo000<Ool00`00Oomoo`0?Ool000Qo
o`03001oogoo00ioo`03001oogoo00Yoo`03001oogoo00Aoo`03?1moogoo00Aoo`03001oogoo00]o
o`04001oogoo000;Ool00`00Oomoo`08Ool2000<Ool01000Oomoo`002goo00<007ooOol02goo00<0
07ooOol00Woo00<l7gooOol027oo00<007ooOol02Woo00<007ooOol02goo00<007ooOol03Woo0000
0goo000000020004Ool00`00Oomoo`05Ool40004Ool00`00Oomoo`08Ool20006Ool01000?1l00000
17oo00<007ooOol01Goo10000Woo00@007ooOol000Uoo`8000]oo`03001oogoo00]oo`04001oogoo
0009Ool2000>Ool00`00Oomoo`02Ool00c`OOomoo`08Ool00`00Oomoo`08Ool2000?Ool00`00Oomo
o`0=Ool000Moo`04001oogoo000>Ool00`00Oomoo`08Ool00`00Oomoo`05Ool00c`OOomoo`05Ool0
0`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol02Woo00<007ooOol02goo00@007ooOol000Uo
o`03001oogoo00eoo`03001oogoo009oo`03?1moogoo00Qoo`03001oogoo00Qoo`03001oogoo00ao
o`04001oogoo000>Ool000Qoo`8000ioo`8000Yoo`<000Eoo`03?1moogoo00Aoo`8000ioo`8000Yo
o`<000Yoo`03001oogoo00aoo`8000Yoo`<000aoo`8000Aoo`03?1moogoo00Moo`8000Yoo`<000eo
o`8000moo`00;7oo00<l7gooOol0;Goo0P00;Woo00<l7gooOol0=7oo000/Ool00c`OOomoo`0]Ool0
0`00Oomoo`0]Ool00c`OOomoo`0dOol002aoo`03?1moogoo02eoo`03001oogoo02ioo`03?1moogoo
03=oo`00;7oo00<l7gooOol0;Goo00<007ooOol0;Woo00<l7gooOol0:Goo0P0000=oo`0000001Goo
0006OolV00000c`O0000001N00000c`O0000000T0006Ool00`00Ool00006Ool000Ioo`05001oogoo
Ool00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo
009oo`05001oogoo?1l00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo
00D007ooOomoo`0000=oo`05001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo
00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00
Oomoogoo00000goo00D007ooOomoo`0000Aoo`05000l7gooOol00003Ool00`00Oomoo`02Ool01@00
Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo
00Eoo`03001oogoo00Eoo`00;7oo00<l7gooOol0;Goo00<007ooOol0;Woo00<l7gooOol0:Goo0P00
00=oo`0000001Goo000/Ool00c`OOomoo`0]Ool00`00Oomoo`0]Ool00c`OOomoo`0dOol002aoo`03
?1moogoo02eoo`8002ioo`03?1moogoo03Aoo`00;7oo00<l7gooOol0;Goo00<007ooOol0;Goo00<l
7gooOol0=7oo000/Ool00c`OOomoo`0]Ool00`00Oomoo`0]Ool00c`OOomoo`0dOol002eoo`03?1mo
ogoo02aoo`03001oogoo02eoo`03?1moogoo03Aoo`00;Goo00<l7gooOol0;7oo00<007ooOol0;Goo
00<l7gooOol0=7oo000]Ool00c`OOomoo`0/Ool2000^Ool00c`OOomoo`0dOol002eoo`03?1moogoo
02aoo`03001oogoo02eoo`03?1moogoo03Aoo`00;Woo00<l7gooOol0:goo00<007ooOol0;7oo00<l
7gooOol0=Goo000^Ool00c`OOomoo`0[Ool00`00Oomoo`0/Ool00c`OOomoo`0eOol002ioo`03?1mo
ogoo02]oo`8002eoo`03?1moogoo03Eoo`00;Woo00<l7gooOol0:goo00<007ooOol0;7oo00<l7goo
Ool0=Goo000^Ool00c`OOomoo`0[Ool00`00Oomoo`0[Ool00c`OOomoo`0fOol002moo`03?1moogoo
02Yoo`03001oogoo02]oo`03?1moogoo03Ioo`00;goo00<l7gooOol0:Woo0P00:goo00<l7gooOol0
=goo000_Ool00c`OOomoo`0ZOol00`00Oomoo`0ZOol00c`OOomoo`0gOol0031oo`03?1moogoo02Uo
o`03001oogoo02Uoo`03?1moogoo03Qoo`00<7oo00<l7gooOol05goo0P0017oo0P0017oo0P0017oo
00<007ooOol0:Goo00<l7gooOol0>7oo000aOol00c`OOomoo`0EOol01000Oomoo`0027oo00@007oo
Ool000=oo`03001oogoo02Qoo`03?1moogoo03Uoo`00<Goo00<l7gooOol05Goo00@007ooOol000]o
o`04001oogooOol2000YOol00c`OOomoo`0iOol0039oo`03?1moogoo01Aoo`04001oogoo0009Ool2
0004Ool00`00Oomoo`0WOol00c`OOomoo`0jOol0039oo`03?1moogoo01Aoo`04001oogoo0009Ool0
0`00Oomoo`03Ool00`00Oomoo`0WOol00c`OOomoo`0jOol003=oo`03?1moogoo01Aoo`8000Yoo`<0
00=oo`03001oogoo02Ioo`03?1moogoo03]oo`00<goo00<l7gooOol09Woo0P009goo00<l7gooOol0
>goo000dOol00c`OOomoo`0UOol00`00Oomoo`0UOol00c`OOomoo`0lOol003Eoo`03?1moogoo02Ao
o`03001oogoo02Eoo`03?1moogoo03aoo`00=Woo00<l7gooOol08goo00<007ooOol097oo00<l7goo
Ool0?Goo000gOol00c`OOomoo`0ROol2000TOol00c`OOomoo`0nOol003Qoo`03?1moogoo025oo`03
001oogoo029oo`03?1moogoo03moo`00>7oo00<l7gooOol08Goo00<007ooOol08Woo00<l7gooOol0
?goo000iOol00c`OOomoo`0POol00`00Oomoo`0QOol00c`OOomoo`10Ool003Yoo`03?1moogoo01mo
o`03001oogoo021oo`03?1moogoo045oo`00>goo00<l7gooOol07Woo0P0087oo00<l7gooOol0@Woo
000lOol00c`OOomoo`0MOol00`00Oomoo`0NOol00c`OOomoo`13Ool003eoo`03?1moogoo01aoo`03
001oogoo01eoo`03?1moogoo04Aoo`00?Woo00<l7gooOol06goo00<007ooOol06goo0S`OAgoo000o
Ool00c`OOomoo`0JOol2000KOol00c`OOomoo`17Ool0041oo`8l7aYoo`03001oogoo01Qoo`8l7dYo
o`00@Woo0S`O4Goo1@000Woo00<007ooOol05goo00<l7gooOol0BWoo0014Ool2?1lAOol00`00Oomo
o`02Ool00`00Oomoo`0EOol2?1m=Ool004Ioo`8l7`moo`03001oogoo009oo`8001Aoo`8l7dmoo`00
B7oo0S`O3Goo00<007ooOol00Woo00<007ooOol04Goo0S`ODGoo001:Ool3?1l:Ool00`00Oomoo`02
Ool00`00Oomoo`0>Ool3?1mCOol004eoo`<l7`Ioo`8000Aoo`03001oogoo00Yoo`@l7eIoo`00D7oo
0S`O2Woo00<007ooOol027oo0S`OFWoo001BOolE?1mLOol005aoo`03001oogoo06Aoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo0019Ool50002Ool20004Ool20004Ool00`00Oomoo`1TOol004]oo`03001o
ogoo00Moo`04001oogoo0003Ool00`00Oomoo`1TOol004]oo`03001oogoo00Yoo`04001oogooOol2
001UOol004]oo`03001oogoo00Qoo`8000Aoo`03001oogoo06Aoo`00Bgoo00<007ooOol027oo00<0
07ooOol00goo00<007ooOol0I7oo001:Ool2000:Ool30003Ool00`00Oomoo`1TOol005aoo`8006Eo
o`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00
IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005Eoo`@000=oo`03001oogoo
06Aoo`00EGoo00<007ooOol017oo00<007ooOol0I7oo001FOol00`00Oomoo`03Ool2001UOol005Mo
o`03001oogoo06Uoo`00EGoo00@007ooOol006Yoo`00EWoo0P00Jgoo0033Ool00<=oo`00`goo001c
Ool20003Ool40003Ool20004Ool20005Ool00`00Oomoo`02Ool2000`Ool0079oo`04001oogoo0008
Ool01000Oomoo`002Woo00D007ooOomoo`00009oo`03001oogoo02eoo`00Fgoo10004goo00<007oo
Ool00goo10000Woo00@007ooOol000Yoo`03001oogoo00Aoo`03001oogoo02eoo`00FWoo00@007oo
Ool001=oo`D000Qoo`04001oogoo000;Ool01000Oomoogoo0P00<7oo001JOol01000Oomoo`0057oo
00<007ooOol02Goo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`0_Ool005Uoo`800003
Ool00000025oo`8000Uoo`@000=oo`<002moo`00`goo0033Ool00<=oo`00`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.7) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

.2 0 1 r

.5 Mabswid

.2378 .49993 m

.23892 .47581 L

.24226 .45182 L

.24781 .42824 L

.2555 .40528 L

.26529 .38313 L

.27707 .36197 L

.29076 .34199 L

.30623 .32336 L

.32336 .30623 L

.34199 .29076 L

.36197 .27707 L

.38313 .26529 L

.40528 .2555 L

.42824 .24781 L

.45182 .24226 L

.47581 .23892 L

.5 .2378 L

.52419 .23892 L

.54818 .24226 L

.57176 .24781 L

.59472 .2555 L

.61687 .26529 L

.63803 .27707 L

.65801 .29076 L

.67664 .30623 L

.69377 .32336 L

.70924 .34199 L

.72293 .36197 L

.73471 .38313 L

.7445 .40528 L

.75219 .42824 L

.75774 .45182 L

.76108 .47581 L

.7622 .49993 L

s

.2378 .50007 m

.23892 .52419 L

.24226 .54818 L

.24781 .57176 L

.2555 .59472 L

.26529 .61687 L

.27707 .63803 L

.29076 .65801 L

.30623 .67664 L

.32336 .69377 L

.34199 .70924 L

.36197 .72293 L

.38313 .73471 L

.40528 .7445 L

.42824 .75219 L

.45182 .75774 L

.47581 .76108 L

.5 .7622 L

.52419 .76108 L

.54818 .75774 L

.57176 .75219 L

.59472 .7445 L

.61687 .73471 L

.63803 .72293 L

.65801 .70924 L

.67664 .69377 L

.69377 .67664 L

.70924 .65801 L

.72293 .63803 L

.73471 .61687 L

.7445 .59472 L

.75219 .57176 L

.75774 .54818 L

.76108 .52419 L

.7622 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol2000<51mPOol005=oo`@D7`03001oogoo009oo`03001oogoo00Aoo`@D7eaoo`00Cgoo11@O
17oo00<007ooOol00Woo0P002Goo11@OF7oo001<Ool351l40004Ool00`00Oomoo`02Ool00`00Oomo
o`0<Ool351mEOol004Yoo`8D7`]oo`03001oogoo009oo`03001oogoo00moo`8D7e=oo`00B7oo0Q@O
37oo0P0017oo00<007ooOol04Goo00<D7gooOol0D7oo0016Ool251lDOol2000COol251m@Ool004Eo
o`0351moogoo01Aoo`03001oogoo01Aoo`8D7dioo`00@goo0Q@O5goo00<007ooOol05Woo0Q@OC7oo
0011Ool251lIOol00`00Oomoo`0HOol251m:Ool0041oo`0351moogoo01Uoo`03001oogoo01Yoo`03
51moogoo04Moo`00?goo00<D7gooOol06Woo0P0077oo00<D7gooOol0AWoo000nOol00a@OOomoo`0K
Ool00`00Oomoo`0LOol00a@OOomoo`15Ool003eoo`0351moogoo01aoo`03001oogoo01eoo`0351mo
ogoo04Aoo`00?7oo00<D7gooOol07Goo00<007ooOol07Woo00<D7gooOol0@goo000kOol00a@OOomo
o`0NOol2000POol00a@OOomoo`12Ool003Yoo`0351moogoo01moo`03001oogoo021oo`0351moogoo
045oo`00>Goo00<D7gooOol087oo00<007ooOol087oo00<D7gooOol0@Goo000hOol00a@OOomoo`0Q
Ool00`00Oomoo`0QOol00a@OOomoo`10Ool003Moo`0351moogoo029oo`8002=oo`0351moogoo03mo
o`00=goo00<D7gooOol08Woo00<007ooOol08goo00<D7gooOol0?Woo000fOol00a@OOomoo`0SOol0
0`00Oomoo`0TOol00a@OOomoo`0mOol003Eoo`0351moogoo019oo`8000Aoo`8000Aoo`8000Aoo`03
001oogoo02Eoo`0351moogoo03aoo`00=Goo00<D7gooOol04Goo00@007ooOol000Qoo`04001oogoo
0003Ool00`00Oomoo`0UOol00a@OOomoo`0lOol003Aoo`0351moogoo019oo`04001oogoo000;Ool0
1000Oomoogoo0P009goo00<D7gooOol0>goo000dOol00a@OOomoo`0<Ool40002Ool01000Oomoo`00
2Goo0P0017oo00<007ooOol09Woo00<D7gooOol0>goo000cOol00a@OOomoo`0COol01000Oomoo`00
2Goo00<007ooOol00goo00<007ooOol09Woo00<D7gooOol0>goo000cOol00a@OOomoo`0DOol2000:
Ool30003Ool00`00Oomoo`0WOol00a@OOomoo`0jOol0039oo`0351moogoo02Moo`8002Qoo`0351mo
ogoo03Yoo`00<Woo00<D7gooOol09goo00<007ooOol09goo00<D7gooOol0>Woo000bOol00a@OOomo
o`0WOol00`00Oomoo`0XOol00a@OOomoo`0iOol0035oo`0351moogoo02Qoo`03001oogoo02Qoo`03
51moogoo03Uoo`00<Goo00<D7gooOol0:7oo0P00:Woo00<D7gooOol0>7oo000aOol00a@OOomoo`0X
Ool00`00Oomoo`0YOol00a@OOomoo`0hOol0035oo`0351moogoo02Qoo`03001oogoo02Uoo`0351mo
ogoo03Qoo`001goo100037oo1@000Woo0P0017oo0P002Woo00<D7goo0000100037oo0P0017oo0P00
17oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo100000<D7gooOol02Goo1@000Woo
0P0017oo0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool00`00Oomoo`07Ool01000Oomoo`002Goo
00DD7gooOomoo`0000eoo`04001oogoo0008Ool01000Oomoo`002Woo00<007ooOol02goo00@007oo
Ool000Qoo`04001oogoo000=Ool00`00OolD7`0=Ool00`00Oomoo`07Ool01000Oomoo`0037oo00<0
07ooOol03goo0008Ool00`00Oomoo`0>Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool01A@OOomoogoo
00003Goo00@007ooOol000]oo`03001oogoo00Qoo`8000aoo`04001oogoo000;Ool00`00Oomoo`0;
Ool00`00OolD7`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0>Ool00003Ool00000
008000Aoo`03001oogoo00Eoo`@000Aoo`03001oogoo00Qoo`8000Ioo`@0000551moogooOol00007
Ool40002Ool01000Oomoo`002Goo0P002goo00<007ooOol02goo00@007ooOol000Uoo`8000ioo`03
001ooa@O00eoo`03001oogoo00Qoo`8000moo`03001oogoo00eoo`001goo00@007ooOol000ioo`03
001oogoo00Qoo`03001oogoo00Qoo`0351moogoo009oo`03001oogoo00]oo`04001oogoo0009Ool0
0`00Oomoo`0:Ool00`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol03Goo00<007oo51l03Goo
00<007ooOol027oo00<007ooOol037oo00@007ooOol000ioo`0027oo0P003Woo0P002Woo0`0027oo
00@D7gooOomoo`8000ioo`8000Yoo`<000Yoo`03001oogoo00aoo`8000Yoo`<000aoo`800003OolD
7goo00]oo`8000Yoo`<000eoo`8000moo`00;goo00<D7gooOol0:Woo0P00:goo00<D7gooOol0=goo
000_Ool00a@OOomoo`0ZOol00`00Oomoo`0ZOol00a@OOomoo`0gOol002moo`0351moogoo02Yoo`03
001oogoo02]oo`0351moogoo03Ioo`00;goo00<D7gooOol0:Woo00<007ooOol0:goo00<D7gooOol0
;7oo0P0000=oo`0000001Goo0006OolY00000a@O0000001H00000a@O0000000W0006Ool00`00Ool0
0006Ool000Ioo`05001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007oo
Oomoo`0000=oo`03001oogoo009oo`09001oogooOol007oo51moo`0000Aoo`05001oogooOol00003
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`0000Aoo`05001oogooOol00003
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03
001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo00000Woo00<D7goo00000goo00D007oo
Oomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007oo
Ool00Woo00<007ooOol01Goo00<007ooOol01Goo000_Ool00a@OOomoo`0ZOol00`00Oomoo`0ZOol0
0a@OOomoo`0]Ool200000goo00000005Ool002moo`0351moogoo02Yoo`03001oogoo02Yoo`0351mo
ogoo03Moo`00;goo00<D7gooOol0:Woo0P00:goo00<D7gooOol0=goo000_Ool00a@OOomoo`0ZOol0
0`00Oomoo`0ZOol00a@OOomoo`0gOol0031oo`0351moogoo02Uoo`03001oogoo02Yoo`0351moogoo
03Moo`00<7oo00<D7gooOol0:Goo00<007ooOol0:Woo00<D7gooOol0=goo000`Ool00a@OOomoo`0Y
Ool00`00Oomoo`0ZOol00a@OOomoo`0gOol0031oo`0351moogoo02Uoo`8002]oo`0351moogoo03Mo
o`00<7oo00<D7gooOol0:Goo00<007ooOol0:Woo00<D7gooOol0=goo000aOol00a@OOomoo`0XOol0
0`00Oomoo`0YOol00a@OOomoo`0hOol0035oo`0351moogoo02Qoo`03001oogoo02Uoo`0351moogoo
03Qoo`00<Goo00<D7gooOol0:7oo0P00:Woo00<D7gooOol0>7oo000aOol00a@OOomoo`0XOol00`00
Oomoo`0XOol00a@OOomoo`0iOol0039oo`0351moogoo02Moo`03001oogoo02Qoo`0351moogoo03Uo
o`00<Woo00<D7gooOol09goo00<007ooOol09goo00<D7gooOol0>Woo000cOol00a@OOomoo`0VOol2
000XOol00a@OOomoo`0jOol003=oo`0351moogoo02Ioo`03001oogoo02Ioo`0351moogoo03]oo`00
=7oo00<D7gooOol09Goo00<007ooOol09Woo00<D7gooOol0>goo000dOol00a@OOomoo`0COol20004
Ool20004Ool20004Ool00`00Oomoo`0VOol00a@OOomoo`0kOol003Eoo`0351moogoo015oo`04001o
ogoo0008Ool01000Oomoo`000goo00<007ooOol09Goo00<D7gooOol0?7oo000eOol00a@OOomoo`0A
Ool01000Oomoo`002goo00@007ooOomoo`8002Ioo`0351moogoo03aoo`00=Woo00<D7gooOol047oo
00@007ooOol000Uoo`8000Aoo`03001oogoo02Aoo`0351moogoo03eoo`00=Woo00<D7gooOol047oo
00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo02Aoo`0351moogoo03eoo`00=goo00<D7goo
Ool047oo0P002Woo0`000goo00<007ooOol08goo00<D7gooOol0?Woo000gOol00a@OOomoo`0ROol2
000SOol00a@OOomoo`0oOol003Qoo`0351moogoo025oo`03001oogoo025oo`0351moogoo041oo`00
>Goo00<D7gooOol087oo00<007ooOol087oo00<D7gooOol0@Goo000jOol00a@OOomoo`0OOol00`00
Oomoo`0POol00a@OOomoo`11Ool003Yoo`0351moogoo01moo`80021oo`0351moogoo049oo`00>goo
00<D7gooOol07Woo00<007ooOol07goo00<D7gooOol0@Woo000lOol00a@OOomoo`0MOol00`00Oomo
o`0NOol00a@OOomoo`13Ool003eoo`0351moogoo01aoo`03001oogoo01eoo`0351moogoo04Aoo`00
?Woo00<D7gooOol06goo00<007ooOol077oo00<D7gooOol0AGoo000oOol251lKOol2000KOol251m8
Ool0045oo`0351moogoo01Qoo`03001oogoo01Uoo`0351moogoo04Qoo`00@Woo00<D7gooOol05goo
00<007ooOol067oo00<D7gooOol0BGoo0013Ool251lGOol00`00Oomoo`0FOol251m<Ool004Eoo`03
51moogoo01Aoo`8001Ioo`0351moogoo04aoo`00AWoo0Q@O57oo00<007ooOol04goo0Q@OCgoo0018
Ool251l;Ool50002Ool00`00Oomoo`0@Ool351mAOol004Yoo`<D7`Yoo`03001oogoo009oo`03001o
ogoo00ioo`8D7eAoo`00CGoo0Q@O27oo00<007ooOol00Woo0P003Goo0Q@OEWoo001?Ool351l5Ool0
0`00Oomoo`02Ool00`00Oomoo`09Ool351mHOol0059ooaHD7e]oo`00EWoo0P0017oo00<007ooOol0
I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol004Uoo`D0009oo`8000Aoo`8000Aoo`03001oogoo06Aoo`00Bgoo00<007ooOol0
1goo00@007ooOol000=oo`03001oogoo06Aoo`00Bgoo00<007ooOol02Woo00@007ooOomoo`8006Eo
o`00Bgoo00<007ooOol027oo0P0017oo00<007ooOol0I7oo001;Ool00`00Oomoo`08Ool00`00Oomo
o`03Ool00`00Oomoo`1TOol004Yoo`8000Yoo`<000=oo`03001oogoo06Aoo`00G7oo0P00IGoo001L
Ool00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol0
05aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001o
ogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo10000goo00<007ooOol0I7oo
001EOol00`00Oomoo`04Ool00`00Oomoo`1TOol005Ioo`03001oogoo00=oo`8006Eoo`00Egoo00<0
07ooOol0JGoo001EOol01000Oomoo`00JWoo001FOol2001[Ool00<=oo`00`goo0033Ool007Ioo`80
00=oo`@000=oo`8000Aoo`8000Eoo`03001oogoo035oo`00MGoo00@007ooOol000Qoo`04001oogoo
000:Ool00`00Oomoo`0aOol005]oo`@001Ioo`03001oogoo00=oo`@0009oo`04001oogoo000:Ool0
0`00Oomoo`0aOol005Yoo`04001oogoo000FOol50008Ool01000Oomoo`002goo00<007ooOol0<7oo
001JOol01000Oomoo`005goo00<007ooOol02Goo00@007ooOol000Qoo`04001oogoo000bOol005Uo
o`800003Ool0000002Aoo`8000Uoo`@0039oo`00`goo0033Ool00<=oo`00`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.65) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 .1 1 r

.5 Mabswid

.25633 .49993 m

.25737 .47752 L

.26048 .45523 L

.26563 .43332 L

.27278 .41198 L

.28188 .39139 L

.29283 .37172 L

.30555 .35316 L

.31993 .33584 L

.33584 .31993 L

.35316 .30555 L

.37172 .29283 L

.39139 .28188 L

.41198 .27278 L

.43332 .26563 L

.45523 .26048 L

.47752 .25737 L

.5 .25633 L

.52248 .25737 L

.54477 .26048 L

.56668 .26563 L

.58802 .27278 L

.60861 .28188 L

.62828 .29283 L

.64684 .30555 L

.66416 .31993 L

.68007 .33584 L

.69445 .35316 L

.70717 .37172 L

.71812 .39139 L

.72722 .41198 L

.73437 .43332 L

.73952 .45523 L

.74263 .47752 L

.74367 .49993 L

s

.25633 .50007 m

.25737 .52248 L

.26048 .54477 L

.26563 .56668 L

.27278 .58802 L

.28188 .60861 L

.29283 .62828 L

.30555 .64684 L

.31993 .66416 L

.33584 .68007 L

.35316 .69445 L

.37172 .70717 L

.39139 .71812 L

.41198 .72722 L

.43332 .73437 L

.45523 .73952 L

.47752 .74263 L

.5 .74367 L

.52248 .74263 L

.54477 .73952 L

.56668 .73437 L

.58802 .72722 L

.60861 .71812 L

.62828 .70717 L

.64684 .69445 L

.66416 .68007 L

.68007 .66416 L

.69445 .64684 L

.70717 .62828 L

.71812 .60861 L

.72722 .58802 L

.73437 .56668 L

.73952 .54477 L

.74263 .52248 L

.74367 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool;05mQOol005Aoo`<0G`03001oogoo009oo`03001oogoo
00=oo`@0Geeoo`00D7oo101O0Woo0P0017oo00<007ooOol01goo101OFGoo001=Ool305l<Ool2000<
Ool305mFOol004]oo`80G`moo`03001oogoo00ioo`80GeAoo`00BGoo0P1O4Goo00<007ooOol047oo
0P1ODWoo0016Ool305lCOol00`00Oomoo`0BOol205m@Ool004Eoo`0305moogoo01Aoo`03001oogoo
01Aoo`0305moogoo04eoo`00A7oo00<0GgooOol05Goo0P005Woo0P1OCGoo0013Ool00`1OOomoo`0F
Ool00`00Oomoo`0GOol00`1OOomoo`1:Ool0045oo`80GaUoo`03001oogoo01Qoo`80GdYoo`00@7oo
00<0GgooOol06Goo00<007ooOol06Woo00<0GgooOol0Agoo000oOol00`1OOomoo`0JOol2000LOol0
0`1OOomoo`16Ool003ioo`0305moogoo01]oo`03001oogoo01]oo`0305moogoo04Ioo`00?Goo00<0
GgooOol077oo00<007ooOol077oo00<0GgooOol0AGoo000lOol00`1OOomoo`0MOol00`00Oomoo`0M
Ool00`1OOomoo`14Ool003aoo`0305moogoo01eoo`8001moo`0305moogoo04=oo`00>goo00<0Ggoo
Ool07Woo00<007ooOol07goo00<0GgooOol0@Woo000jOol00`1OOomoo`0OOol00`00Oomoo`0POol0
0`1OOomoo`11Ool003Yoo`0305moogoo00eoo`8000Aoo`8000Aoo`8000Aoo`03001oogoo021oo`03
05moogoo045oo`00>Goo00<0GgooOol03Goo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomo
o`0QOol00`1OOomoo`10Ool003Qoo`0305moogoo00ioo`04001oogoo000;Ool01000Oomoogoo0P00
8goo00<0GgooOol0?goo000hOol00`1OOomoo`08Ool40002Ool01000Oomoo`002Goo0P0017oo00<0
07ooOol08Woo00<0GgooOol0?goo000gOol00`1OOomoo`0?Ool01000Oomoo`002Goo00<007ooOol0
0goo00<007ooOol08goo00<0GgooOol0?Woo000fOol00`1OOomoo`0AOol2000:Ool30003Ool00`00
Oomoo`0TOol00`1OOomoo`0mOol003Ioo`0305moogoo02=oo`8002Eoo`0305moogoo03eoo`00=Goo
00<0GgooOol097oo00<007ooOol09Goo00<0GgooOol0?7oo000eOol00`1OOomoo`0TOol00`00Oomo
o`0UOol00`1OOomoo`0lOol003Eoo`0305moogoo02Aoo`03001oogoo02Eoo`0305moogoo03aoo`00
=7oo00<0GgooOol09Goo0P009goo00<0GgooOol0>goo000dOol00`1OOomoo`0UOol00`00Oomoo`0V
Ool00`1OOomoo`0kOol003Aoo`0305moogoo02Eoo`03001oogoo02Ioo`0305moogoo03]oo`001goo
100037oo1@000Woo0P0017oo0P0037oo0P0000<0G`00000037oo0P0017oo0P0017oo0P002goo00<0
07ooOol037oo0P0017oo0P0017oo0P0037oo00<0G`0000000P002goo1@000Woo0P0017oo0P003Goo
10003Woo0007Ool00`00Oomoo`0?Ool00`00Oomoo`07Ool01000Oomoo`0037oo00<0G`00Ool037oo
00@007ooOol000Qoo`04001oogoo000:Ool00`00Oomoo`0;Ool01000Oomoo`0027oo00@007ooOol0
00aoo`0305l007oo00ioo`03001oogoo00Moo`04001oogoo000<Ool00`00Oomoo`0?Ool000Qoo`03
001oogoo00ioo`03001oogoo00Yoo`03001oogoo00Yoo`0305l007oo00aoo`04001oogoo000;Ool0
0`00Oomoo`08Ool2000<Ool01000Oomoo`002goo00<007ooOol02Woo00<0G`00Ool03Woo00<007oo
Ool02Woo00<007ooOol02goo00<007ooOol03Woo00000goo000000020004Ool00`00Oomoo`05Ool4
0004Ool00`00Oomoo`08Ool20006Ool40003Ool00`1O001oo`06Ool40002Ool01000Oomoo`002Goo
0P002goo00<007ooOol02goo00@007ooOol000Uoo`8000eoo`0305l007oo00ioo`03001oogoo00Qo
o`8000moo`03001oogoo00eoo`001goo00@007ooOol000ioo`03001oogoo00Qoo`03001oogoo00ao
o`0305l007oo00aoo`04001oogoo0009Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool01000Oomoo`00
2Goo00<007ooOol037oo00<0G`00Ool03Woo00<007ooOol027oo00<007ooOol037oo00@007ooOol0
00ioo`0027oo0P003Woo0P002Woo0`0037oo00<0G`00Ool03Goo0P002Woo0`002Woo00<007ooOol0
37oo0P002Woo0`0037oo00<0G`00Ool03Goo0P002Woo0`003Goo0P003goo000cOol00`1OOomoo`0V
Ool2000XOol00`1OOomoo`0jOol003=oo`0305moogoo02Ioo`03001oogoo02Moo`0305moogoo03Yo
o`00<Woo00<0GgooOol09goo00<007ooOol09goo00<0GgooOol0>Woo000bOol00`1OOomoo`0WOol0
0`00Oomoo`0WOol00`1OOomoo`0`Ool200000goo00000005Ool000Ioob`0000305l0000005400003
05l0000002/000Ioo`03001oo`0000Ioo`001Woo00D007ooOomoo`0000Aoo`05001oogooOol00003
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03
0000Ggoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007oo
Oomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007oo
Ool00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoo`1O
000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02
Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo000cOol0
0`1OOomoo`0VOol00`00Oomoo`0WOol00`1OOomoo`0`Ool200000goo00000005Ool003=oo`0305mo
ogoo02Ioo`03001oogoo02Moo`0305moogoo03Yoo`00<goo00<0GgooOol09Woo0P00:7oo00<0Ggoo
Ool0>Woo000cOol00`1OOomoo`0VOol00`00Oomoo`0WOol00`1OOomoo`0jOol003=oo`0305moogoo
02Ioo`03001oogoo02Moo`0305moogoo03Yoo`00<goo00<0GgooOol09Woo00<007ooOol09goo00<0
GgooOol0>Woo000cOol00`1OOomoo`0VOol00`00Oomoo`0WOol00`1OOomoo`0jOol003=oo`0305mo
ogoo02Ioo`8002Qoo`0305moogoo03Yoo`00=7oo00<0GgooOol09Goo00<007ooOol09Woo00<0Ggoo
Ool0>goo000dOol00`1OOomoo`0UOol00`00Oomoo`0VOol00`1OOomoo`0kOol003Aoo`0305moogoo
02Eoo`03001oogoo02Ioo`0305moogoo03]oo`00=7oo00<0GgooOol09Goo0P009goo00<0GgooOol0
>goo000eOol00`1OOomoo`0TOol00`00Oomoo`0UOol00`1OOomoo`0lOol003Eoo`0305moogoo02Ao
o`03001oogoo02Eoo`0305moogoo03aoo`00=Woo00<0GgooOol08goo00<007ooOol097oo00<0Ggoo
Ool0?Goo000fOol00`1OOomoo`0SOol2000UOol00`1OOomoo`0mOol003Moo`0305moogoo029oo`03
001oogoo02=oo`0305moogoo03ioo`00=goo00<0GgooOol08Woo00<007ooOol08goo00<0GgooOol0
?Woo000hOol00`1OOomoo`0?Ool20004Ool20004Ool20004Ool00`00Oomoo`0ROol00`1OOomoo`0o
Ool003Qoo`0305moogoo00ioo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol08Woo00<0
GgooOol0?goo000iOol00`1OOomoo`0=Ool01000Oomoo`002goo00@007ooOomoo`80029oo`0305mo
ogoo041oo`00>Woo00<0GgooOol037oo00@007ooOol000Uoo`8000Aoo`03001oogoo021oo`0305mo
ogoo045oo`00>Woo00<0GgooOol037oo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo021o
o`0305moogoo045oo`00>goo00<0GgooOol037oo0P002Woo0`000goo00<007ooOol07goo00<0Ggoo
Ool0@Woo000lOol00`1OOomoo`0MOol2000OOol00`1OOomoo`13Ool003aoo`0305moogoo01eoo`03
001oogoo01eoo`0305moogoo04Aoo`00?Goo00<0GgooOol077oo00<007ooOol077oo00<0GgooOol0
AGoo000nOol00`1OOomoo`0KOol00`00Oomoo`0KOol00`1OOomoo`16Ool003moo`0305moogoo01Yo
o`8001aoo`0305moogoo04Ioo`00@7oo00<0GgooOol06Goo00<007ooOol06Woo00<0GgooOol0Agoo
0011Ool00`1OOomoo`0HOol00`00Oomoo`0IOol00`1OOomoo`18Ool0049oo`0305moogoo01Moo`03
001oogoo01Qoo`0305moogoo04Uoo`00@goo00<0GgooOol05Woo00<007ooOol05goo00<0GgooOol0
BWoo0014Ool205lFOol2000FOol205m=Ool004Ioo`0305moogoo01=oo`03001oogoo01=oo`80Gdmo
o`00Agoo0P1O4goo00<007ooOol04Goo0P1ODGoo0019Ool305l@Ool00`00Oomoo`0?Ool205mCOol0
04aoo`80G`ioo`8000ioo`80GeEoo`00CWoo0P1O37oo00<007ooOol02goo0P1OEgoo001@Ool705l3
0002Ool00`00Oomoo`04Ool705mIOol005Moo``0Gf1oo`00Egoo00<007ooOol00Woo0P00IGoo001G
Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00EWoo
0P0017oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0
I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol004Uoo`D0009oo`8000Aoo`8000Aoo`03001oogoo06Ao
o`00Bgoo00<007ooOol01goo00@007ooOol000=oo`03001oogoo06Aoo`00Bgoo00<007ooOol02Woo
00@007ooOomoo`8006Eoo`00Bgoo00<007ooOol027oo0P0017oo00<007ooOol0I7oo001;Ool00`00
Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`1TOol004Yoo`8000Yoo`<000=oo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo1000
0goo00<007ooOol0I7oo001EOol00`00Oomoo`04Ool00`00Oomoo`1TOol005Ioo`03001oogoo00=o
o`8006Eoo`00Egoo00<007ooOol0JGoo001EOol01000Oomoo`00JWoo001FOol2001[Ool00<=oo`00
`goo0033Ool007=oo`8000=oo`@000=oo`8000Aoo`8000=oo`<000Aoo`80031oo`00LWoo00@007oo
Ool000Qoo`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol002moo`00Fgoo10004goo00<0
07ooOol00goo10000Woo00@007ooOol000Qoo`04001oogoo0005Ool00`00Oomoo`0]Ool005Yoo`04
001oogoo000COol50008Ool01000Oomoo`0027oo0`0017oo0P00<7oo001JOol01000Oomoo`0057oo
00<007ooOol02Goo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo02moo`00FGoo0P0000=o
o`0000008Goo0P002Woo0`000goo0`00;goo0033Ool00<=oo`00`goo0033Ool00<=oo`00\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.6) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 .4 1 r

.5 Mabswid

.27639 .49993 m

.27735 .47937 L

.2802 .45891 L

.28493 .43881 L

.29149 .41922 L

.29984 .40033 L

.30989 .38229 L

.32156 .36525 L

.33475 .34936 L

.34936 .33475 L

.36525 .32156 L

.38229 .30989 L

.40033 .29984 L

.41922 .29149 L

.43881 .28493 L

.45891 .2802 L

.47937 .27735 L

.5 .27639 L

.52063 .27735 L

.54109 .2802 L

.56119 .28493 L

.58078 .29149 L

.59967 .29984 L

.61771 .30989 L

.63475 .32156 L

.65064 .33475 L

.66525 .34936 L

.67844 .36525 L

.69011 .38229 L

.70016 .40033 L

.70851 .41922 L

.71507 .43881 L

.7198 .45891 L

.72265 .47937 L

.72361 .49993 L

s

.27639 .50007 m

.27735 .52063 L

.2802 .54109 L

.28493 .56119 L

.29149 .58078 L

.29984 .59967 L

.30989 .61771 L

.32156 .63475 L

.33475 .65064 L

.34936 .66525 L

.36525 .67844 L

.38229 .69011 L

.40033 .70016 L

.41922 .70851 L

.43881 .71507 L

.45891 .7198 L

.47937 .72265 L

.5 .72361 L

.52063 .72265 L

.54109 .7198 L

.56119 .71507 L

.58078 .70851 L

.59967 .70016 L

.61771 .69011 L

.63475 .67844 L

.65064 .66525 L

.66525 .65064 L

.67844 .63475 L

.69011 .61771 L

.70016 .59967 L

.70851 .58078 L

.71507 .56119 L

.7198 .54109 L

.72265 .52063 L

.72361 .50007 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001o
ogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol2001UOol005Aooa41
Weioo`00DGoo0`6O27oo00<007ooOol01Woo106OFWoo001>Ool30Il;Ool00`00Oomoo`0:Ool20ImH
Ool004aoo`81W`ioo`03001oogoo00aoo`81WeIoo`00BWoo0P6O47oo0P003goo0`6ODgoo0018Ool2
0IlBOol00`00Oomoo`0AOol20ImAOol004Ioo`81WaAoo`03001oogoo01=oo`81Wdmoo`00AGoo00<1
WgooOol057oo00<007ooOol05Goo00<1WgooOol0C7oo0014Ool00`6OOomoo`0EOol2000GOol00`6O
Oomoo`1;Ool004=oo`030Imoogoo01Ioo`03001oogoo01Ioo`030Imoogoo04]oo`00@Woo00<1Wgoo
Ool05goo00<007ooOol05goo00<1WgooOol0BWoo0011Ool00`6OOomoo`0HOol00`00Oomoo`0HOol2
0Im:Ool0041oo`030Imoogoo01Uoo`8001]oo`030Imoogoo04Moo`00?goo00<1WgooOol06Woo00<0
07ooOol06goo00<1WgooOol0AWoo000oOol00`6OOomoo`0JOol00`00Oomoo`0KOol00`6OOomoo`16
Ool003ioo`030Imoogoo00Uoo`8000Aoo`8000Aoo`8000Aoo`03001oogoo01aoo`030Imoogoo04Eo
o`00?Goo00<1WgooOol02Goo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`0MOol00`6O
Oomoo`14Ool003eoo`030Imoogoo00Uoo`04001oogoo000;Ool01000Oomoogoo0P007Woo00<1Wgoo
Ool0A7oo000lOol00`6OOomoo`04Ool40002Ool01000Oomoo`002Goo0P0017oo00<007ooOol07Woo
00<1WgooOol0@goo000kOol00`6OOomoo`0;Ool01000Oomoo`002Goo00<007ooOol00goo00<007oo
Ool07goo00<1WgooOol0@Woo000kOol00`6OOomoo`0<Ool2000:Ool30003Ool00`00Oomoo`0OOol0
0`6OOomoo`12Ool003Yoo`030Imoogoo01moo`80025oo`030Imoogoo045oo`00>Goo00<1WgooOol0
87oo00<007ooOol087oo00<1WgooOol0@Goo000iOol00`6OOomoo`0POol00`00Oomoo`0QOol00`6O
Oomoo`10Ool003Qoo`030Imoogoo025oo`03001oogoo025oo`030Imoogoo041oo`00>7oo00<1Wgoo
Ool08Goo0P008Woo00<1WgooOol0@7oo000gOol00`6OOomoo`0ROol00`00Oomoo`0ROol00`6OOomo
o`0oOol003Moo`030Imoogoo029oo`03001oogoo029oo`030Imoogoo03moo`001goo100037oo1@00
0Woo0P0017oo0P0037oo1@0000<1WgooOol02Goo0P0017oo0P0017oo0P002goo00<007ooOol037oo
0P0017oo0P0017oo0P0027oo00@1WgooOomoo`D000]oo`D0009oo`8000Aoo`8000eoo`@000ioo`00
1goo00<007ooOol03goo00<007ooOol01goo00@007ooOol000eoo`04001oogoo0Il:Ool01000Oomo
o`0027oo00@007ooOol000Yoo`03001oogoo00]oo`04001oogoo0008Ool01000Oomoo`001goo00<1
WgooOol00goo00<007ooOol03Goo00<007ooOol01goo00@007ooOol000aoo`03001oogoo00moo`00
27oo00<007ooOol03Woo00<007ooOol02Woo00<007ooOol02goo00<007oo0Il02goo00@007ooOol0
00]oo`03001oogoo00Qoo`8000aoo`04001oogoo000;Ool00`00Oomoo`06Ool00`6OOomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0>Ool00003Ool000000080
00Aoo`03001oogoo00Eoo`@000Aoo`03001oogoo00Qoo`8000Ioo`@000Aoo`03001oo`6O00Eoo`@0
009oo`04001oogoo0009Ool2000;Ool00`00Oomoo`0;Ool01000Oomoo`002Goo0P002Goo00<1Wgoo
Ool00Woo00<007ooOol03Goo00<007ooOol027oo0P003goo00<007ooOol03Goo0007Ool01000Oomo
o`003Woo00<007ooOol027oo00<007ooOol03Goo00<007oo0Il02goo00@007ooOol000Uoo`03001o
ogoo00Yoo`03001oogoo00]oo`04001oogoo0009Ool00`00Oomoo`08Ool00`6OOomoo`02Ool00`00
Oomoo`0=Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool01000Oomoo`003Woo0008Ool2000>Ool2000:
Ool3000<Ool200000goo0Imoo`0;Ool2000:Ool3000:Ool00`00Oomoo`0<Ool2000:Ool30009Ool0
0`6OOomoo`02000>Ool2000:Ool3000=Ool2000?Ool003Ioo`030Imoogoo02=oo`8002Eoo`030Imo
ogoo03eoo`00=Woo00<1WgooOol08goo00<007ooOol097oo00<1WgooOol0?Goo000fOol00`6OOomo
o`0SOol00`00Oomoo`0TOol00`6OOomoo`0mOol003Ioo`030Imoogoo02=oo`03001oogoo02Aoo`03
0Imoogoo03=oo`800003Ool0000000Eoo`001Woo<00000<1W`000000BP0000<1W`000000;P001Woo
00<007oo00001Woo0006Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001oogoo009o
o`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D1
WgooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo000017oo00D0
07ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomo
ogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`050ImoogooOol00004Ool01@00Oomo
ogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol0
0003Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`05Ool003Ioo`030Imoogoo02=oo`03
001oogoo02Aoo`030Imoogoo03=oo`800003Ool0000000Eoo`00=Woo00<1WgooOol08goo00<007oo
Ool097oo00<1WgooOol0?Goo000fOol00`6OOomoo`0SOol2000UOol00`6OOomoo`0mOol003Ioo`03
0Imoogoo02=oo`03001oogoo02Aoo`030Imoogoo03eoo`00=Woo00<1WgooOol08goo00<007ooOol0
8goo00<1WgooOol0?Woo000fOol00`6OOomoo`0SOol00`00Oomoo`0SOol00`6OOomoo`0nOol003Io
o`030Imoogoo02=oo`03001oogoo02=oo`030Imoogoo03ioo`00=goo00<1WgooOol08Woo0P008goo
00<1WgooOol0?goo000gOol00`6OOomoo`0ROol00`00Oomoo`0ROol00`6OOomoo`0oOol003Moo`03
0Imoogoo029oo`03001oogoo029oo`030Imoogoo03moo`00=goo00<1WgooOol08Woo00<007ooOol0
8Woo00<1WgooOol0?goo000hOol00`6OOomoo`0QOol2000ROol00`6OOomoo`10Ool003Qoo`030Imo
ogoo025oo`03001oogoo025oo`030Imoogoo041oo`00>Goo00<1WgooOol087oo00<007ooOol08Goo
00<1WgooOol0@7oo000iOol00`6OOomoo`0POol00`00Oomoo`0POol00`6OOomoo`11Ool003Yoo`03
0Imoogoo01moo`80025oo`030Imoogoo045oo`00>goo00<1WgooOol07Woo00<007ooOol07goo00<1
WgooOol0@Woo000kOol00`6OOomoo`0NOol00`00Oomoo`0OOol00`6OOomoo`12Ool003aoo`030Imo
ogoo00]oo`8000Aoo`8000Aoo`8000Aoo`03001oogoo01ioo`030Imoogoo04=oo`00?Goo00<1Wgoo
Ool02Goo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`0MOol00`6OOomoo`14Ool003eo
o`030Imoogoo00Uoo`04001oogoo000;Ool01000Oomoogoo0P007Woo00<1WgooOol0A7oo000nOol0
0`6OOomoo`08Ool01000Oomoo`002Goo0P0017oo00<007ooOol077oo00<1WgooOol0AGoo000oOol0
0`6OOomoo`07Ool01000Oomoo`002Goo00<007ooOol00goo00<007ooOol06goo00<1WgooOol0AWoo
000oOol00`6OOomoo`08Ool2000:Ool30003Ool00`00Oomoo`0KOol00`6OOomoo`16Ool0041oo`03
0Imoogoo01Uoo`8001]oo`030Imoogoo04Moo`00@Goo00<1WgooOol067oo00<007ooOol06Goo00<1
WgooOol0B7oo0011Ool00`6OOomoo`0HOol00`00Oomoo`0HOol00`6OOomoo`19Ool0049oo`030Imo
ogoo01Moo`03001oogoo01Moo`030Imoogoo04Yoo`00@goo0P6O5goo0P005goo00<1WgooOol0Bgoo
0015Ool00`6OOomoo`0DOol00`00Oomoo`0EOol00`6OOomoo`1<Ool004Ioo`81WaAoo`03001oogoo
01=oo`81Wdmoo`00B7oo00<1WgooOol04Goo00<007ooOol04Woo00<1WgooOol0Cgoo0019Ool20IlA
Ool00`00Oomoo`0@Ool20ImBOol004]oo`81W`moo`8000moo`81WeAoo`00CGoo0`6O37oo00<007oo
Ool02Woo106OEWoo001@Ool40Il8Ool00`00Oomoo`07Ool30ImJOol005Aoo`<1W`Eoo`03001oogoo
00=oo`@1Weeoo`00Egoo2`6OHGoo001LOol00`00Oomoo`1TOol005Eoo`D0009oo`03001oogoo06Ao
o`00Egoo00<007ooOol00Woo00<007ooOol0I7oo001GOol00`00Oomoo`02Ool2001UOol005Moo`03
001oogoo009oo`03001oogoo06Aoo`00Egoo00<007ooOol00Woo00<007ooOol0I7oo001FOol20004
Ool00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol0
05aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Ao
o`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0
I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0I7oo001;
Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:Ool01000
Oomoogoo0P00IGoo001;Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol004]oo`03001oogoo
00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<007ooOol0I7oo001L
Ool2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol0
05aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001EOol40003Ool0
0`00Oomoo`1TOol005Eoo`03001oogoo00Aoo`03001oogoo06Aoo`00EWoo00<007ooOol00goo0P00
IGoo001GOol00`00Oomoo`1YOol005Eoo`04001oogoo001ZOol005Ioo`8006]oo`00`goo0033Ool0
0<=oo`00MWoo0P000goo10000goo0P0017oo0P000goo0`00<goo001eOol01000Oomoo`0027oo00@0
07ooOol000Qoo`04001oogoo000bOol005]oo`@001Ioo`03001oogoo00=oo`@0009oo`04001oogoo
0008Ool01000Oomoo`00<Woo001JOol01000Oomoo`005Woo1@0027oo00@007ooOol000Qoo`<003=o
o`00FWoo00@007ooOol001Moo`03001oogoo00Uoo`04001oogoo0009Ool00`00Oomoo`0bOol005Uo
o`800003Ool0000002Aoo`8000Yoo`<0039oo`00`goo0033Ool00<=oo`00`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.55) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 .7 1 r

.5 Mabswid

.29844 .49994 m

.2993 .4814 L

.30188 .46296 L

.30614 .44484 L

.31205 .42719 L

.31957 .41016 L

.32863 .39389 L

.33915 .37854 L

.35105 .36421 L

.36421 .35105 L

.37854 .33915 L

.39389 .32863 L

.41016 .31957 L

.42719 .31205 L

.44484 .30614 L

.46296 .30188 L

.4814 .2993 L

.5 .29844 L

.5186 .2993 L

.53704 .30188 L

.55516 .30614 L

.57281 .31205 L

.58984 .31957 L

.60611 .32863 L

.62146 .33915 L

.63579 .35105 L

.64895 .36421 L

.66085 .37854 L

.67137 .39389 L

.68043 .41016 L

.68795 .42719 L

.69386 .44484 L

.69812 .46296 L

.7007 .4814 L

.70156 .49994 L

s

.29844 .50006 m

.2993 .5186 L

.30188 .53704 L

.30614 .55516 L

.31205 .57281 L

.31957 .58984 L

.32863 .60611 L

.33915 .62146 L

.35105 .63579 L

.36421 .64895 L

.37854 .66085 L

.39389 .67137 L

.41016 .68043 L

.42719 .68795 L

.44484 .69386 L

.46296 .69812 L

.4814 .7007 L

.5 .70156 L

.5186 .7007 L

.53704 .69812 L

.55516 .69386 L

.57281 .68795 L

.58984 .68043 L

.60611 .67137 L

.62146 .66085 L

.63579 .64895 L

.64895 .63579 L

.66085 .62146 L

.67137 .60611 L

.68043 .58984 L

.68795 .57281 L

.69386 .55516 L

.69812 .53704 L

.7007 .5186 L

.70156 .50006 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001o
ogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol2001UOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005]oo`<2_fEoo`00EGoo
1P:o00=oo`0000001`:oGWoo001BOol30[l7Ool00`00Oomoo`06Ool30[mKOol004moo`<2_`Yoo`03
001oogoo00Uoo`<2_eQoo`00CGoo0P:o3Goo00<007ooOol037oo0P:oEWoo001;Ool20[l?Ool2000?
Ool20[mDOol004Uoo`82_a5oo`03001oogoo011oo`030[moogoo055oo`00Agoo0P:o4goo00<007oo
Ool04Goo0P:oDGoo0016Ool00`:oOomoo`0COol00`00Oomoo`0COol20[m?Ool004Eoo`030[moogoo
01Aoo`8001Ioo`030[moogoo04aoo`00A7oo00<2_gooOol05Goo00<007ooOol05Woo00<2_gooOol0
Bgoo0014Ool00`:oOomoo`0EOol00`00Oomoo`0FOol00`:oOomoo`1;Ool004=oo`030[moogoo00Ao
o`8000Aoo`8000Aoo`8000Aoo`03001oogoo01Moo`030[moogoo04Yoo`00@Woo00<2_gooOol017oo
00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`0HOol00`:oOomoo`19Ool0045oo`030[mo
ogoo00Eoo`04001oogoo000;Ool01000Oomoogoo0P006Woo00<2_gooOol0B7oo0010Ool00`:oOomo
o`040002Ool01000Oomoo`002Goo0P0017oo00<007ooOol06Woo00<2_gooOol0Agoo0010Ool00`:o
Oomoo`06Ool01000Oomoo`002Goo00<007ooOol00goo00<007ooOol06Woo00<2_gooOol0Agoo000o
Ool00`:oOomoo`08Ool2000:Ool30003Ool00`00Oomoo`0KOol00`:oOomoo`16Ool003ioo`030[mo
ogoo01]oo`8001aoo`030[moogoo04Ioo`00?Woo00<2_gooOol06goo00<007ooOol077oo00<2_goo
Ool0AGoo000mOol00`:oOomoo`0LOol00`00Oomoo`0LOol00`:oOomoo`15Ool003eoo`030[moogoo
01aoo`03001oogoo01eoo`030[moogoo04Aoo`00?7oo00<2_gooOol07Goo0P007Woo00<2_gooOol0
A7oo000lOol00`:oOomoo`0MOol00`00Oomoo`0NOol00`:oOomoo`13Ool003aoo`030[moogoo01eo
o`03001oogoo01ioo`030[moogoo04=oo`001goo100037oo1@000Woo0P0017oo0P0037oo1@0017oo
00<2_gooOol01Goo0P0017oo0P0017oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P001Goo
00<2_gooOol017oo1@002goo1@000Woo0P0017oo0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool0
0`00Oomoo`07Ool01000Oomoo`003Goo00<007ooOol017oo00<2_gooOol017oo00@007ooOol000Qo
o`04001oogoo000:Ool00`00Oomoo`0;Ool01000Oomoo`0027oo00@007ooOol000Aoo`030[moogoo
00Ioo`03001oogoo00eoo`03001oogoo00Moo`04001oogoo000<Ool00`00Oomoo`0?Ool000Qoo`03
001oogoo00ioo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Aoo`030[moogoo00Aoo`04
001oogoo000;Ool00`00Oomoo`08Ool2000<Ool01000Oomoo`002goo00<007ooOol00Woo00<2_goo
Ool01Woo00<007ooOol03Goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol03Woo00000goo
000000020004Ool00`00Oomoo`05Ool40004Ool00`00Oomoo`08Ool20006Ool40004Ool00`00Oomo
o`03Ool00`:oOol000030002Ool01000Oomoo`002Goo0P002goo00<007ooOol02goo00@007ooOol0
00Uoo`8000Eoo`030[moogoo00Ioo`03001oogoo00eoo`03001oogoo00Qoo`8000moo`03001oogoo
00eoo`001goo00@007ooOol000ioo`03001oogoo00Qoo`03001oogoo00eoo`03001oogoo00=oo`03
0[moogoo00Eoo`04001oogoo0009Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool01000Oomoo`002Goo
00<007ooOol017oo00<2_gooOol01Woo00<007ooOol03Goo00<007ooOol027oo00<007ooOol037oo
00@007ooOol000ioo`0027oo0P003Woo0P002Woo0`0037oo0P001Goo00<2_gooOol01Woo0P002Woo
0`002Woo00<007ooOol037oo0P002Woo0`0017oo00<2_gooOol01Goo0P003Woo0P002Woo0`003Goo
0P003goo000jOol00`:oOomoo`0OOol2000QOol00`:oOomoo`11Ool003Yoo`030[moogoo01moo`03
001oogoo021oo`030[moogoo045oo`00>Woo00<2_gooOol07goo00<007ooOol087oo00<2_gooOol0
@Goo000jOol00`:oOomoo`0OOol00`00Oomoo`0POol00`:oOomoo`0gOol200000goo00000005Ool0
00Iooc@000030[l00000048000030[l00000038000Ioo`03001oo`0000Ioo`001Woo00D007ooOomo
o`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol2_`03Ool00`00Oomoo`02Ool0
1@00Oomoogoo00000goo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool0
1@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001o
ogooOol2_`03Ool01@00Oomoogoo000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001o
ogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol0
1Goo00<007ooOol01Goo000jOol00`:oOomoo`0OOol00`00Oomoo`0POol00`:oOomoo`0gOol20000
0goo00000005Ool003Yoo`030[moogoo01moo`03001oogoo021oo`030[moogoo045oo`00>Woo00<2
_gooOol07goo0P008Goo00<2_gooOol0@Goo000jOol00`:oOomoo`0OOol00`00Oomoo`0OOol00`:o
Oomoo`12Ool003Yoo`030[moogoo01moo`03001oogoo01moo`030[moogoo049oo`00>Woo00<2_goo
Ool07goo00<007ooOol07goo00<2_gooOol0@Woo000jOol00`:oOomoo`0OOol00`00Oomoo`0OOol0
0`:oOomoo`12Ool003]oo`030[moogoo01ioo`80021oo`030[moogoo049oo`00>goo00<2_gooOol0
7Woo00<007ooOol07goo00<2_gooOol0@Woo000kOol00`:oOomoo`0NOol00`00Oomoo`0OOol00`:o
Oomoo`12Ool003aoo`030[moogoo01eoo`03001oogoo01ioo`030[moogoo04=oo`00?7oo00<2_goo
Ool07Goo0P007goo00<2_gooOol0@goo000lOol00`:oOomoo`0MOol00`00Oomoo`0MOol00`:oOomo
o`14Ool003eoo`030[moogoo01aoo`03001oogoo01eoo`030[moogoo04Aoo`00?Goo00<2_gooOol0
77oo00<007ooOol077oo00<2_gooOol0AGoo000nOol00`:oOomoo`0KOol2000LOol00`:oOomoo`16
Ool003moo`030[moogoo01Yoo`03001oogoo01]oo`030[moogoo04Ioo`00@7oo00<2_gooOol06Goo
00<007ooOol06Woo00<2_gooOol0Agoo0010Ool00`:oOomoo`07Ool20004Ool20004Ool20004Ool0
0`00Oomoo`0JOol00`:oOomoo`17Ool0045oo`030[moogoo00Eoo`04001oogoo0008Ool01000Oomo
o`000goo00<007ooOol06Goo00<2_gooOol0B7oo0012Ool00`:oOomoo`04Ool01000Oomoo`002goo
00@007ooOomoo`8001Uoo`030[moogoo04Uoo`00@Woo00<2_gooOol017oo00@007ooOol000Uoo`80
00Aoo`03001oogoo01Qoo`030[moogoo04Uoo`00@goo00<2_gooOol00goo00@007ooOol000Uoo`03
001oogoo00=oo`03001oogoo01Moo`030[moogoo04Yoo`00A7oo00<2_gooOol00goo0P002Woo0`00
0goo00<007ooOol05Woo00<2_gooOol0Bgoo0015Ool00`:oOomoo`0DOol2000FOol00`:oOomoo`1<
Ool004Ioo`030[moogoo01=oo`03001oogoo01=oo`82_dmoo`00Agoo00<2_gooOol04Woo00<007oo
Ool04Woo00<2_gooOol0Cgoo0018Ool20[lBOol00`00Oomoo`0AOol00`:oOomoo`1@Ool004Yoo`82
_a1oo`80011oo`82_e=oo`00C7oo0P:o3Woo00<007ooOol03Goo0P:oEGoo001>Ool20[l<Ool00`00
Oomoo`0;Ool20[mGOol0051oo`82_`Yoo`03001oogoo00Uoo`82_eUoo`00DWoo1P:o17oo00<007oo
Ool00goo1P:oFgoo001HOol:0[mQOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001L
Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001EOol50002Ool00`00Oomo
o`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<007ooOol00Woo0P00IGoo001G
Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00EWoo
0P0017oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0
I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol004Uoo`D0009oo`8000Aoo`8000Aoo`03001oogoo06Ao
o`00Bgoo00<007ooOol01goo00@007ooOol000=oo`03001oogoo06Aoo`00Bgoo00<007ooOol02Woo
00@007ooOomoo`8006Eoo`00Bgoo00<007ooOol027oo0P0017oo00<007ooOol0I7oo001;Ool00`00
Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`1TOol004Yoo`8000Yoo`<000=oo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo1000
0goo00<007ooOol0I7oo001EOol00`00Oomoo`04Ool00`00Oomoo`1TOol005Ioo`03001oogoo00=o
o`8006Eoo`00Egoo00<007ooOol0JGoo001EOol01000Oomoo`00JWoo001FOol2001[Ool00<=oo`00
`goo0033Ool007=oo`8000=oo`@000=oo`8000Aoo`8000Aoo`8000Aoo`80031oo`00LWoo00@007oo
Ool000Qoo`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol002moo`00Fgoo10004goo00<0
07ooOol00goo10000Woo00@007ooOol000]oo`03001oogoo00=oo`03001oogoo02eoo`00FWoo00@0
07ooOol001=oo`D000Qoo`04001oogoo0009Ool20004Ool2000`Ool005Yoo`04001oogoo000DOol0
0`00Oomoo`09Ool01000Oomoo`002Goo00<007ooOol00goo00<007ooOol0;goo001IOol200000goo
0000000QOol2000:Ool30003Ool3000_Ool00<=oo`00`goo0033Ool00<=oo`00`goo0000\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.5) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 1 r

.5 Mabswid

.32322 .49994 m

.32398 .48369 L

.32623 .46752 L

.32997 .45162 L

.33516 .43614 L

.34176 .4212 L

.3497 .40694 L

.35893 .39347 L

.36936 .38091 L

.38091 .36936 L

.39347 .35893 L

.40694 .3497 L

.4212 .34176 L

.43614 .33516 L

.45162 .32997 L

.46752 .32623 L

.48369 .32398 L

.5 .32322 L

.51631 .32398 L

.53248 .32623 L

.54838 .32997 L

.56386 .33516 L

.5788 .34176 L

.59306 .3497 L

.60653 .35893 L

.61909 .36936 L

.63064 .38091 L

.64107 .39347 L

.6503 .40694 L

.65824 .4212 L

.66484 .43614 L

.67003 .45162 L

.67377 .46752 L

.67602 .48369 L

.67678 .49994 L

s

.32322 .50006 m

.32398 .51631 L

.32623 .53248 L

.32997 .54838 L

.33516 .56386 L

.34176 .5788 L

.3497 .59306 L

.35893 .60653 L

.36936 .61909 L

.38091 .63064 L

.39347 .64107 L

.40694 .6503 L

.4212 .65824 L

.43614 .66484 L

.45162 .67003 L

.46752 .67377 L

.48369 .67602 L

.5 .67678 L

.51631 .67602 L

.53248 .67377 L

.54838 .67003 L

.56386 .66484 L

.5788 .65824 L

.59306 .6503 L

.60653 .64107 L

.61909 .63064 L

.63064 .61909 L

.64107 .60653 L

.6503 .59306 L

.65824 .5788 L

.66484 .56386 L

.67003 .54838 L

.67377 .53248 L

.67602 .51631 L

.67678 .50006 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001o
ogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol2001UOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001FOol>0omOOol005=oo`<3o`Ioo`03001oogoo00Eoo`83oeeoo`00DGoo0P?o2Goo00<007oo
Ool01goo0`?oFWoo001>Ool30ol;Ool00`00Oomoo`0:Ool20omHOol004aoo`83o`ioo`8000eoo`83
oeIoo`00Bgoo00<3ogooOol03Woo00<007ooOol03Woo0P?oE7oo001:Ool00`?oOomoo`0?Ool00`00
Oomoo`0@Ool00`?oOomoo`1AOol004Uoo`030ol0000000Aoo`8000Aoo`8000Aoo`03001oogoo015o
o`030omoogoo051oo`00B7oo00D3o`00Oomoo`0000Qoo`04001oogoo0003Ool00`00Oomoo`0BOol0
0`?oOomoo`1?Ool004Moo`030omoo`00009oo`03001oogoo00Uoo`04001oogooOol2000DOol00`?o
Oomoo`1>Ool004=oo`<000040omoogoo0002Ool00`00Oomoo`07Ool20004Ool00`00Oomoo`0DOol0
0`?oOomoo`1=Ool004Eoo`050omoogooOol00002Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00
Oomoo`0EOol00`?oOomoo`1<Ool004Aoo`030omoogoo00=oo`8000Yoo`<000=oo`03001oogoo01Io
o`030omoogoo04]oo`00@goo00<3ogooOol05Woo0P0067oo00<3ogooOol0BWoo0012Ool00`?oOomo
o`0GOol00`00Oomoo`0GOol00`?oOomoo`1:Ool0049oo`030omoogoo01Moo`03001oogoo01Qoo`03
0omoogoo04Uoo`00@Goo00<3ogooOol067oo00<007ooOol067oo00<3ogooOol0BGoo0011Ool00`?o
Oomoo`0HOol2000JOol00`?oOomoo`18Ool0041oo`030omoogoo01Uoo`03001oogoo01Yoo`030omo
ogoo04Moo`00@7oo00<3ogooOol06Goo00<007ooOol06Woo00<3ogooOol0Agoo0007Ool4000<Ool5
0002Ool20004Ool2000<Ool50009Ool00`?oOomoo`020004Ool20004Ool2000;Ool00`00Oomoo`0<
Ool20004Ool20004Ool200000`?oOomoo`09Ool5000;Ool50002Ool20004Ool2000=Ool4000>Ool0
00Moo`03001oogoo00moo`03001oogoo00Moo`04001oogoo000=Ool00`00Oomoo`08Ool010?oOomo
o`000Woo00<007ooOol01Woo00@007ooOol000Yoo`03001oogoo00]oo`04001oogoo0008Ool01@00
Oomoo`000ol037oo00<007ooOol03Goo00<007ooOol01goo00@007ooOol000aoo`03001oogoo00mo
o`0027oo00<007ooOol03Woo00<007ooOol02Woo00<007ooOol02goo00<007ooOol027oo00@3ogoo
Ool0009oo`03001oogoo00Uoo`03001oogoo00Qoo`8000aoo`04001oogoo000;Ool00`000omoo`0;
Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0>Ool00003Ool00000
008000Aoo`03001oogoo00Eoo`@000Aoo`03001oogoo00Qoo`8000Ioo`@000Aoo`03001oogoo00Eo
o`<000040omoogoo0002Ool00`00Oomoo`07Ool2000;Ool00`00Oomoo`0;Ool01000Oomoo`002Goo
0P0000=oo`?oOol02goo00<007ooOol03Goo00<007ooOol027oo0P003goo00<007ooOol03Goo0007
Ool01000Oomoo`003Woo00<007ooOol027oo00<007ooOol03Goo00<007ooOol01goo00D3ogooOomo
o`00009oo`03001oogoo00Moo`03001oogoo00Yoo`03001oogoo00]oo`04001oogoo0009Ool01000
Oomoo`?o37oo00<007ooOol03Goo00<007ooOol027oo00<007ooOol037oo00@007ooOol000ioo`00
27oo0P003Woo0P002Woo0`0037oo0P002Goo00<3ogooOol00Woo0P002Woo0`002Woo00<007ooOol0
37oo0P002Woo0`0000<3ogooOol02Goo0P003Woo0P002Woo0`003Goo0P003goo000nOol00`?oOomo
o`0KOol2000MOol00`?oOomoo`15Ool003ioo`030omoogoo01]oo`03001oogoo01aoo`030omoogoo
04Eoo`00?Woo00<3ogooOol06goo00<007ooOol077oo00<3ogooOol0AGoo000nOol00`?oOomoo`0K
Ool00`00Oomoo`0LOol00`?oOomoo`0kOol200000goo00000005Ool000IoocP000030ol0000003X0
00030ol0000003H000Ioo`03001oo`0000Ioo`001Woo00D007ooOomoo`0000Aoo`05001oogooOol0
0003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=o
o`03001oogoo009oo`05001oogooOol00003Ool00`?oOomoo`02Ool01@00Oomoogoo00000goo00D0
07ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<0
07ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`050omoogooOol00003Ool01@00Oomo
ogoo000017oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomo
o`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo000n
Ool00`?oOomoo`0KOol00`00Oomoo`0LOol00`?oOomoo`0kOol200000goo00000005Ool003ioo`03
0omoogoo01]oo`03001oogoo01aoo`030omoogoo04Eoo`00?Woo00<3ogooOol06goo0P007Goo00<3
ogooOol0AGoo000nOol00`?oOomoo`0KOol00`00Oomoo`0KOol00`?oOomoo`16Ool003ioo`030omo
ogoo01]oo`03001oogoo01]oo`030omoogoo04Ioo`00?goo00<3ogooOol06Woo00<007ooOol06goo
00<3ogooOol0AWoo000oOol00`?oOomoo`0JOol00`00Oomoo`0KOol00`?oOomoo`16Ool003moo`03
0omoogoo01Yoo`8001aoo`030omoogoo04Ioo`00@7oo00<3ogooOol06Goo00<007ooOol06Woo00<3
ogooOol0Agoo0010Ool00`?oOomoo`0IOol00`00Oomoo`0JOol00`?oOomoo`17Ool0041oo`030omo
ogoo01Uoo`03001oogoo01Yoo`030omoogoo04Moo`00@Goo00<3ogooOol067oo0P006Woo00<3ogoo
Ool0B7oo0011Ool00`?oOomoo`0HOol00`00Oomoo`0IOol00`?oOomoo`18Ool0049oo`030omoogoo
01Moo`03001oogoo01Qoo`030omoogoo04Uoo`00@Woo00<3ogooOol05goo00<007ooOol05goo00<3
ogooOol0BWoo0013Ool00`?oOomoo`0FOol2000HOol00`?oOomoo`1:Ool004=oo`030omoogoo01Io
o`03001oogoo01Ioo`030omoogoo04]oo`00A7oo00<3ogooOol05Goo00<007ooOol05Woo00<3ogoo
Ool0Bgoo0015Ool00`?oOomoo`02Ool20004Ool20004Ool20004Ool00`00Oomoo`0EOol00`?oOomo
o`1<Ool004Ioo`040omoogoo0002Ool00`00Oomoo`06Ool01000Oomoo`000goo00<007ooOol057oo
00<3ogooOol0CGoo0017Ool00`?oOol00002Ool00`00Oomoo`09Ool01000Oomoogoo0P0057oo00<3
ogooOol0CWoo0018Ool01@?o001oogoo00002Goo0P0017oo00<007ooOol04Woo00<3ogooOol0Cgoo
0019Ool20ol00goo001oo`08Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool20omBOol004Yoo`030003
ogoo00Uoo`<000=oo`03001oogoo00ioo`83oeAoo`00C7oo0P?o3Woo0P003Woo00<3ogooOol0E7oo
001>Ool20ol<Ool00`00Oomoo`0;Ool20omGOol0051oo`030omoogoo00Uoo`03001oogoo00Uoo`83
oeUoo`00DGoo1@?o1Woo00<007ooOol01Goo10?oFgoo001FOol50ol00goo000000060omOOol005]o
o`<3ofEoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo
001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo1@000Woo00<007ooOol0I7oo001GOol00`00
Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`8006Eoo`00Egoo00<007ooOol00Woo
00<007ooOol0I7oo001GOol00`00Oomoo`02Ool00`00Oomoo`1TOol005Ioo`8000Aoo`03001oogoo
06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007oo
Ool0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00
Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo
00<007ooOol0I7oo0019Ool50002Ool20004Ool20004Ool00`00Oomoo`1TOol004]oo`03001oogoo
00Moo`04001oogoo0003Ool00`00Oomoo`1TOol004]oo`03001oogoo00Yoo`04001oogooOol2001U
Ool004]oo`03001oogoo00Qoo`8000Aoo`03001oogoo06Aoo`00Bgoo00<007ooOol027oo00<007oo
Ool00goo00<007ooOol0I7oo001:Ool2000:Ool30003Ool00`00Oomoo`1TOol005aoo`8006Eoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo
001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00
Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03
001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005Eoo`@000=oo`03001oogoo06Ao
o`00EGoo00<007ooOol017oo00<007ooOol0I7oo001FOol00`00Oomoo`03Ool2001UOol005Moo`03
001oogoo06Uoo`00EGoo00@007ooOol006Yoo`00EWoo0P00Jgoo0033Ool00<=oo`00`goo001fOol2
0003Ool40003Ool20004Ool20004Ool2000cOol007Eoo`04001oogoo0008Ool01000Oomoo`0027oo
00@007ooOol0039oo`00Fgoo10005Woo00<007ooOol00goo10000Woo00@007ooOol000]oo`03001o
ogoo031oo`00FWoo00@007ooOol001Ioo`D000Qoo`04001oogoo0009Ool2000cOol005Yoo`04001o
ogoo000GOol00`00Oomoo`09Ool01000Oomoo`002Goo00<007ooOol0<Woo001IOol200000goo0000
000TOol2000:Ool3000bOol00<=oo`00`goo0033Ool00<=oo`00`goo0000\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.45) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .7 r

.5 Mabswid

.3521 .49995 m

.35273 .48635 L

.35462 .47282 L

.35774 .45952 L

.36209 .44657 L

.3676 .43407 L

.37425 .42214 L

.38197 .41087 L

.3907 .40036 L

.40036 .3907 L

.41087 .38197 L

.42214 .37425 L

.43407 .3676 L

.44657 .36209 L

.45952 .35774 L

.47282 .35462 L

.48635 .35273 L

.5 .3521 L

.51365 .35273 L

.52718 .35462 L

.54048 .35774 L

.55343 .36209 L

.56593 .3676 L

.57786 .37425 L

.58913 .38197 L

.59964 .3907 L

.6093 .40036 L

.61803 .41087 L

.62575 .42214 L

.6324 .43407 L

.63791 .44657 L

.64226 .45952 L

.64538 .47282 L

.64727 .48635 L

.6479 .49995 L

s

.3521 .50005 m

.35273 .51365 L

.35462 .52718 L

.35774 .54048 L

.36209 .55343 L

.3676 .56593 L

.37425 .57786 L

.38197 .58913 L

.3907 .59964 L

.40036 .6093 L

.41087 .61803 L

.42214 .62575 L

.43407 .6324 L

.44657 .63791 L

.45952 .64226 L

.47282 .64538 L

.48635 .64727 L

.5 .6479 L

.51365 .64727 L

.52718 .64538 L

.54048 .64226 L

.55343 .63791 L

.56593 .6324 L

.57786 .62575 L

.58913 .61803 L

.59964 .6093 L

.6093 .59964 L

.61803 .58913 L

.62575 .57786 L

.6324 .56593 L

.63791 .55343 L

.64226 .54048 L

.64538 .52718 L

.64727 .51365 L

.6479 .50005 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001o
ogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol2001UOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`8006Eoo`00Egoo2`?eHGoo001COol40oD5Ool00`00Oomoo`03Ool50oELOol004Yo
o`8000Aoo`030003m@?e00=oo`8000Aoo`03001oogoo00Qoo`83mEYoo`00BGoo00@007ooOol0009o
o`83m@Aoo`04001oogoo0003Ool00`00Oomoo`0:Ool20oEHOol004Uoo`06001oogoo001oo`?e2Goo
00@007ooOomoo`8000eoo`030oEoogoo05Eoo`00@goo10000Woo00D007ooOol000?e00Qoo`8000Ao
o`03001oogoo00eoo`030oEoogoo05Aoo`00BGoo00@007oo0oD3m@Uoo`03001oogoo00=oo`03001o
ogoo00ioo`83mEAoo`00BWoo00<3m@00Ool02Goo0`000goo00<007ooOol047oo00<3mGooOol0DGoo
001:Ool00`?eOomoo`0?Ool2000AOol00`?eOomoo`1AOol004Uoo`030oEoogoo011oo`03001oogoo
015oo`030oEoogoo051oo`00B7oo00<3mGooOol04Goo00<007ooOol04Woo00<3mGooOol0Cgoo0017
Ool00`?eOomoo`0BOol00`00Oomoo`0COol00`?eOomoo`1>Ool004Moo`030oEoogoo019oo`8001Ao
o`030oEoogoo04ioo`00AWoo00<3mGooOol04goo00<007ooOol057oo00<3mGooOol0CGoo0016Ool0
0`?eOomoo`0COol00`00Oomoo`0DOol00`?eOomoo`1=Ool000Moo`@000aoo`D0009oo`8000Aoo`80
00aoo`D000aoo`8000040oEoogooOol20004Ool2000;Ool00`00Oomoo`0<Ool20004Ool2000017oo
0oEoogoo0P0037oo1@002goo1@000Woo0P0017oo0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool0
0`00Oomoo`07Ool01000Oomoo`003Goo00<007ooOol02goo00@007ooOol3m@Qoo`04001oogoo000:
Ool00`00Oomoo`0;Ool01000Oomoo`001Woo00<3mGoo00000Woo00<007ooOol02goo00<007ooOol0
3Goo00<007ooOol01goo00@007ooOol000aoo`03001oogoo00moo`0027oo00<007ooOol03Woo00<0
07ooOol02Woo00<007ooOol02goo00<007ooOol02goo00@007oo0oD000]oo`03001oogoo00Qoo`80
00aoo`04001oogoo0007Ool01@?eOomoogoo00003Goo00<007ooOol03Goo00<007ooOol02Woo00<0
07ooOol02goo00<007ooOol03Woo00000goo000000020004Ool00`00Oomoo`05Ool40004Ool00`00
Oomoo`08Ool20006Ool40004Ool00`00Oomoo`05Ool40002Ool01000Ool3m@002Goo0P002goo00<0
07ooOol02goo00@007ooOol000Moo`040oEoo`00000>Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool2
000?Ool00`00Oomoo`0=Ool000Moo`04001oogoo000>Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool0
0`00Oomoo`0;Ool010000oEoo`002Goo00<007ooOol02Woo00<007ooOol02goo00@007ooOol000Mo
o`030oEoo`0000moo`03001oogoo00eoo`03001oogoo00Qoo`03001oogoo00aoo`04001oogoo000>
Ool000Qoo`8000ioo`8000Yoo`<000aoo`8000ioo`030oD007oo00Uoo`<000Yoo`03001oogoo00ao
o`8000Qoo`030oEoo`00008000aoo`8000ioo`8000Yoo`<000eoo`8000moo`00@goo00<3mGooOol0
5Woo0P005goo00<3mGooOol0Bgoo0013Ool00`?eOomoo`0FOol00`00Oomoo`0GOol00`?eOomoo`1:
Ool004=oo`030oEoogoo01Ioo`03001oogoo01Moo`030oEoogoo04Yoo`00@goo00<3mGooOol05Woo
00<007ooOol05goo00<3mGooOol0@7oo0P0000=oo`0000001Goo0006Oolm00000`?e0000000`0000
0`?e0000000k0006Ool00`00Ool00006Ool000Ioo`05001oogooOol00004Ool01@00Oomoogoo0000
0goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D3mGooOomoo`0000=oo`05001o
ogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001o
ogoo009oo`05001oogooOol00003Ool00`?eOomoo`02Ool01@00Oomoogoo00000goo00D007ooOomo
o`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`00@goo
00<3mGooOol05Woo00<007ooOol05goo00<3mGooOol0@7oo0P0000=oo`0000001Goo0013Ool00`?e
Oomoo`0FOol00`00Oomoo`0GOol00`?eOomoo`1:Ool004=oo`030oEoogoo01Ioo`8001Moo`030oEo
ogoo04]oo`00@goo00<3mGooOol05Woo00<007ooOol05Woo00<3mGooOol0Bgoo0014Ool00`?eOomo
o`0EOol00`00Oomoo`0FOol00`?eOomoo`1;Ool004Aoo`030oEoogoo01Eoo`03001oogoo01Ioo`03
0oEoogoo04]oo`00AGoo00<3mGooOol057oo00<007ooOol05Goo00<3mGooOol0C7oo0015Ool00`?e
Oomoo`0DOol2000FOol00`?eOomoo`1<Ool004Eoo`030oEoogoo01Aoo`03001oogoo01Eoo`030oEo
ogoo04aoo`00AWoo00<3mGooOol04goo00<007ooOol057oo00<3mGooOol0CGoo0016Ool00`?eOomo
o`0COol00`00Oomoo`0DOol00`?eOomoo`1=Ool004Moo`030oEoogoo019oo`8001Aoo`030oEoogoo
04ioo`00Agoo00<3mGooOol04Woo00<007ooOol04goo00<3mGooOol0CWoo0018Ool00`?eOomoo`0A
Ool00`00Oomoo`0BOol00`?eOomoo`1?Ool004Qoo`030oEoogoo015oo`03001oogoo019oo`030oEo
ogoo04moo`00BGoo0P?e4Goo0P004Goo0P?eDWoo001;Ool00`?eOomoo`0>Ool00`00Oomoo`0?Ool0
0`?eOomoo`1BOol004]oo`030oEoogoo00ioo`03001oogoo00moo`030oEoogoo059oo`00BWoo0P00
0P?e0Woo0P0017oo0P0017oo00<007ooOol03Goo0P?eEGoo0019Ool01P00Oomoo`00Ool3m@Ioo`04
001oogoo0003Ool00`00Oomoo`0<Ool00`?eOomoo`1EOol004Uoo`04001oogoo0002Ool00`?eOomo
o`06Ool01000Oomoogoo0P0037oo00<3mGooOol0EWoo0019Ool01000Oomoo`000goo0P?e17oo0P00
17oo00<007ooOol02Goo0P?eFGoo0019Ool01000Oomoo`001Goo0P?e0Woo00<007ooOol00goo00<0
07ooOol01Woo0`?eFgoo001:Ool20008Ool50oD3Ool00`00Oomoo`02Ool40oENOol005Uoo`P3mF9o
o`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00
IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005Eoo`D0009oo`03001oogoo
06Aoo`00Egoo00<007ooOol00Woo00<007ooOol0I7oo001GOol00`00Oomoo`02Ool2001UOol005Mo
o`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<007ooOol00Woo00<007ooOol0I7oo001FOol2
0004Ool00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1T
Ool005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo
06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007oo
Ool0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00
Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0I7oo
001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:Ool0
1000Oomoogoo0P00IGoo001;Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol004]oo`03001o
ogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<007ooOol0I7oo
001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1T
Ool005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo
06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007oo
Ool0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001EOol40003
Ool00`00Oomoo`1TOol005Eoo`03001oogoo00Aoo`03001oogoo06Aoo`00EWoo00<007ooOol00goo
0P00IGoo001GOol00`00Oomoo`1YOol005Eoo`04001oogoo001ZOol005Ioo`8006]oo`00`goo0033
Ool00<=oo`00Lgoo0P000goo10000goo0P0017oo0P001Goo0`000Woo0P00<7oo001bOol01000Oomo
o`0027oo00@007ooOol000]oo`04001oogoo0002Ool00`00Oomoo`0]Ool005]oo`@001=oo`03001o
ogoo00=oo`@0009oo`04001oogoo0008Ool50004Ool00`00Oomoo`0]Ool005Yoo`04001oogoo000C
Ool50008Ool01000Oomoo`0027oo00@007ooOol000=oo`80031oo`00FWoo00@007ooOol001Aoo`03
001oogoo00Uoo`04001oogoo0009Ool00`00Ool00003Ool00`00Oomoo`0_Ool005Uoo`800003Ool0
0000025oo`8000]oo`8000=oo`<002moo`00`goo0033Ool00<=oo`00`goo0033Ool00001\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.4) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .4 r

.5 Mabswid

.3882 .49995 m

.38867 .48968 L

.3901 .47946 L

.39246 .4694 L

.39575 .45961 L

.39992 .45016 L

.40494 .44114 L

.41078 .43262 L

.41738 .42468 L

.42468 .41738 L

.43262 .41078 L

.44114 .40494 L

.45016 .39992 L

.45961 .39575 L

.4694 .39246 L

.47946 .3901 L

.48968 .38867 L

.5 .3882 L

.51032 .38867 L

.52054 .3901 L

.5306 .39246 L

.54039 .39575 L

.54984 .39992 L

.55886 .40494 L

.56738 .41078 L

.57532 .41738 L

.58262 .42468 L

.58922 .43262 L

.59506 .44114 L

.60008 .45016 L

.60425 .45961 L

.60754 .4694 L

.6099 .47946 L

.61133 .48968 L

.6118 .49995 L

s

.3882 .50005 m

.38867 .51032 L

.3901 .52054 L

.39246 .5306 L

.39575 .54039 L

.39992 .54984 L

.40494 .55886 L

.41078 .56738 L

.41738 .57532 L

.42468 .58262 L

.43262 .58922 L

.44114 .59506 L

.45016 .60008 L

.45961 .60425 L

.4694 .60754 L

.47946 .6099 L

.48968 .61133 L

.5 .6118 L

.51032 .61133 L

.52054 .6099 L

.5306 .60754 L

.54039 .60425 L

.54984 .60008 L

.55886 .59506 L

.56738 .58922 L

.57532 .58262 L

.58262 .57532 L

.58922 .56738 L

.59506 .55886 L

.60008 .54984 L

.60425 .54039 L

.60754 .5306 L

.6099 .52054 L

.61133 .51032 L

.6118 .50005 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001o
ogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol2001UOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol004Yoo`8000Ao
o`8000Aoo`8000Aoo`03001oogoo06Aoo`00BGoo00@007ooOol000Qoo`04001oogoo0003Ool00`00
Oomoo`1TOol004Uoo`04001oogoo000;Ool01000Oomoogoo0P00IGoo0013Ool40002Ool01000Oomo
o`002Goo0P0017oo00<007ooOol0I7oo0019Ool01000Oomoo`002Goo00<007ooOol020?/HWoo001:
Ool20009Ool40n`3Ool00`00Oomoo`02Ool30naOOol005Aoo`030naoogoo00Eoo`8000Ioo`83k5eo
o`00DWoo0P?/27oo00<007ooOol01goo00<3k7ooOol0FWoo001AOol00`?/Oomoo`08Ool00`00Oomo
o`08Ool20naJOol004moo`83k0]oo`03001oogoo00Yoo`030naoogoo05Moo`00CWoo00<3k7ooOol0
2goo0P0037oo0P?/Egoo001=Ool00`?/Oomoo`0<Ool00`00Oomoo`0=Ool00`?/Oomoo`1DOol004eo
o`030naoogoo00aoo`03001oogoo00eoo`030naoogoo05Aoo`001goo100037oo1@000Woo0P0017oo
0P0037oo1@0037oo0P0017oo0P0000Aoo`?/Oomoo`8000]oo`03001oogoo00aoo`8000040naoogoo
Ool20004Ool2000<Ool5000;Ool50002Ool20004Ool2000=Ool4000>Ool000Moo`03001oogoo00mo
o`03001oogoo00Moo`04001oogoo000=Ool00`00Oomoo`0;Ool01000Oomoo`001Goo00@3k7ooOol0
009oo`03001oogoo00Qoo`03001oogoo00]oo`05001oogoo0003k007Ool01000Oomoo`003Goo00<0
07ooOol03Goo00<007ooOol01goo00@007ooOol000aoo`03001oogoo00moo`0027oo00<007ooOol0
3Woo00<007ooOol02Woo00<007ooOol02goo00<007ooOol02goo00@007ooOol000Eoo`030naoogoo
00=oo`03001oogoo00Qoo`8000aoo`05001oogoo0003k00:Ool00`00Oomoo`0;Ool00`00Oomoo`0=
Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0>Ool00003Ool00000008000Aoo`03001o
ogoo00Eoo`@000Aoo`03001oogoo00Qoo`8000Ioo`@000Aoo`03001oogoo00Eoo`@0009oo`04001o
ogoo0004Ool00`?/Oomoo`02Ool2000;Ool00`00Oomoo`0;Ool01@00Oomoo`000n`027oo0P003Woo
00<007ooOol03Goo00<007ooOol027oo0P003goo00<007ooOol03Goo0007Ool01000Oomoo`003Woo
00<007ooOol027oo00<007ooOol03Goo00<007ooOol02goo00@007ooOol000Aoo`030naoogoo009o
o`03001oogoo00Yoo`03001oogoo00]oo`06001oogoo001oo`?/1goo00<007ooOol03Goo00<007oo
Ool03Goo00<007ooOol027oo00<007ooOol037oo00@007ooOol000ioo`0027oo0P003Woo0P002Woo
0`0037oo0P003Woo0P001Goo00<3k7ooOol00Woo0`002Woo00<007ooOol037oo0P000Woo00<3k7oo
Ool01Goo0`0037oo0P003Woo0P002Woo0`003Goo0P003goo0019Ool00`?/Oomoo`0@Ool2000AOol0
0`?/Oomoo`1AOol004Uoo`030naoogoo011oo`03001oogoo011oo`030naoogoo055oo`00BGoo00<3
k7ooOol047oo00<007ooOol04Goo00<3k7ooOol0D7oo0019Ool00`?/Oomoo`0@Ool00`00Oomoo`0A
Ool00`?/Oomoo`16Ool200000goo00000005Ool000Iood<000030n`0000002@000030n`000000440
00Ioo`03001oo`0000Ioo`001Woo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomo
o`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009o
o`05001oogooOol00003Ool00`00Oomoo`02Ool02@00Oomoogoo001oo`?/Ool00003Ool00`00Oomo
o`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009o
o`05001oo`?/Ool00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomoo`0000Ao
o`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D0
07ooOomoo`0000=oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`00BGoo00<3k7oo
Ool047oo00<007ooOol04Goo00<3k7ooOol0AWoo0P0000=oo`0000001Goo0019Ool00`?/Oomoo`0@
Ool00`00Oomoo`0@Ool00`?/Oomoo`1AOol004Uoo`030naoogoo011oo`80015oo`030naoogoo055o
o`00BWoo00<3k7ooOol03goo00<007ooOol047oo00<3k7ooOol0DGoo001:Ool00`?/Oomoo`0?Ool0
0`00Oomoo`0?Ool00`?/Oomoo`1BOol004Yoo`030naoogoo00moo`03001oogoo00moo`030naoogoo
059oo`00Bgoo00<3k7ooOol03Woo00<007ooOol03goo00<3k7ooOol0DWoo001;Ool00`?/Oomoo`0>
Ool2000@Ool00`?/Oomoo`1BOol004aoo`030naoogoo00eoo`03001oogoo00ioo`030naoogoo05=o
o`00CGoo00<3k7ooOol037oo00<007ooOol03Goo00<3k7ooOol0E7oo001=Ool00`?/Oomoo`0<Ool0
0`00Oomoo`0=Ool00`?/Oomoo`1DOol004ioo`030naoogoo00]oo`8000eoo`030naoogoo05Eoo`00
Cgoo00<3k7ooOol02Woo00<007ooOol02Woo0P?/F7oo001@Ool00`?/Oomoo`09Ool00`00Oomoo`09
Ool00`?/Oomoo`1HOol0055oo`030naoogoo00Qoo`03001oogoo00Uoo`030naoogoo05Qoo`00DWoo
0`?/1goo0P001goo0`?/Fgoo001EOol00`?/Oomoo`04Ool00`00Oomoo`04Ool20naNOol005Ioo`d3
k61oo`00BWoo0P0017oo0P0017oo0P0017oo00<007ooOol0I7oo0019Ool01000Oomoo`0027oo00@0
07ooOol000=oo`03001oogoo06Aoo`00BGoo00@007ooOol000]oo`04001oogooOol2001UOol004Uo
o`04001oogoo0009Ool20004Ool00`00Oomoo`1TOol004Uoo`04001oogoo0009Ool00`00Oomoo`03
Ool00`00Oomoo`1TOol004Yoo`8000Yoo`<000=oo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005ao
o`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo
06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007oo
Ool0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo1@000Woo00<007ooOol0I7oo001G
Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`8006Eoo`00Egoo00<007oo
Ool00Woo00<007ooOol0I7oo001GOol00`00Oomoo`02Ool00`00Oomoo`1TOol005Ioo`8000Aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo
00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001L
Ool00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol0
05aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Ao
o`00G7oo00<007ooOol0I7oo0019Ool50002Ool20004Ool20004Ool00`00Oomoo`1TOol004]oo`03
001oogoo00Moo`04001oogoo0003Ool00`00Oomoo`1TOol004]oo`03001oogoo00Yoo`04001oogoo
Ool2001UOol004]oo`03001oogoo00Qoo`8000Aoo`03001oogoo06Aoo`00Bgoo00<007ooOol027oo
00<007ooOol00goo00<007ooOol0I7oo001:Ool2000:Ool30003Ool00`00Oomoo`1TOol005aoo`80
06Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo
0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001L
Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol0
05aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005Eoo`@000=oo`03001o
ogoo06Aoo`00EGoo00<007ooOol017oo00<007ooOol0I7oo001FOol00`00Oomoo`03Ool2001UOol0
05Moo`03001oogoo06Uoo`00EGoo00@007ooOol006Yoo`00EWoo0P00Jgoo0033Ool00<=oo`00`goo
001fOol20003Ool40003Ool20004Ool20005Ool3000aOol007Eoo`04001oogoo0008Ool01000Oomo
o`002goo00<007ooOol0<7oo001KOol4000FOol00`00Oomoo`03Ool40002Ool01000Oomoo`0027oo
1@00<Goo001JOol01000Oomoo`005Woo1@0027oo00@007ooOol000Qoo`04001oogoo000bOol005Yo
o`04001oogoo000GOol00`00Oomoo`09Ool01000Oomoo`002Goo00<007oo0000<Woo001IOol20000
0goo0000000TOol2000;Ool2000bOol00<=oo`00`goo0033Ool00<=oo`00`goo0000\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -59 0 ]

[.5 1.0125 59 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -120 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.35) show

177.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

0 1 .1 r

.5 Mabswid

.4441 .49997 m

.44434 .49484 L

.44505 .48973 L

.44623 .4847 L

.44787 .47981 L

.44996 .47508 L

.45247 .47057 L

.45539 .46631 L

.45869 .46234 L

.46234 .45869 L

.46631 .45539 L

.47057 .45247 L

.47508 .44996 L

.47981 .44787 L

.4847 .44623 L

.48973 .44505 L

.49484 .44434 L

.5 .4441 L

.50516 .44434 L

.51027 .44505 L

.5153 .44623 L

.52019 .44787 L

.52492 .44996 L

.52943 .45247 L

.53369 .45539 L

.53766 .45869 L

.54131 .46234 L

.54461 .46631 L

.54753 .47057 L

.55004 .47508 L

.55213 .47981 L

.55377 .4847 L

.55495 .48973 L

.55566 .49484 L

.5559 .49997 L

s

.4441 .50003 m

.44434 .50516 L

.44505 .51027 L

.44623 .5153 L

.44787 .52019 L

.44996 .52492 L

.45247 .52943 L

.45539 .53369 L

.45869 .53766 L

.46234 .54131 L

.46631 .54461 L

.47057 .54753 L

.47508 .55004 L

.47981 .55213 L

.4847 .55377 L

.48973 .55495 L

.49484 .55566 L

.5 .5559 L

.50516 .55566 L

.51027 .55495 L

.5153 .55377 L

.52019 .55213 L

.52492 .55004 L

.52943 .54753 L

.53369 .54461 L

.53766 .54131 L

.54131 .53766 L

.54461 .53369 L

.54753 .52943 L

.55004 .52492 L

.55213 .52019 L

.55377 .5153 L

.55495 .51027 L

.55566 .50516 L

.5559 .50003 L

s

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->0,
  AnimationCycleRepetitions->0,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001o
ogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol2001UOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol004Yoo`8000Ao
o`8000Aoo`8000Aoo`03001oogoo06Aoo`00BGoo00@007ooOol000Qoo`04001oogoo0003Ool00`00
Oomoo`1TOol004Uoo`04001oogoo000;Ool01000Oomoogoo0P00IGoo0013Ool40002Ool01000Oomo
o`002Goo0P0017oo00<007ooOol0I7oo0019Ool01000Oomoo`002Goo00<007ooOol00goo00<007oo
Ool0I7oo001:Ool2000:Ool30003Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0
I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`001goo100037oo1@000Woo0P0017oo0P0037oo1@0037oo0P00
17oo0P0017oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo1@002goo1@000Woo0P00
17oo0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool00`00Oomoo`07Ool01000Oomoo`003Goo00<0
07ooOol02goo00@007ooOol000Qoo`04001oogoo0007Ool80n89Ool01000Oomoo`0027oo00@007oo
Ool000eoo`03001oogoo00eoo`03001oogoo00Moo`04001oogoo000<Ool00`00Oomoo`0?Ool000Qo
o`03001oogoo00ioo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`04001oogoo000;
Ool00`00Oomoo`03Ool20n83Ool20003Ool20n87Ool01000Oomoo`002goo00<007ooOol02goo00<0
07ooOol03Goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol03Woo00000goo000000020004
Ool00`00Oomoo`05Ool40004Ool00`00Oomoo`08Ool20006Ool40004Ool00`00Oomoo`05Ool40002
Ool01000Oomoo`002Goo0P001Goo00<3hWooOol00goo00<007ooOol017oo00<3hWooOol017oo00@0
07ooOol000Uoo`8000ioo`03001oogoo00eoo`03001oogoo00Qoo`8000moo`03001oogoo00eoo`00
1goo00@007ooOol000ioo`03001oogoo00Qoo`03001oogoo00eoo`03001oogoo00]oo`04001oogoo
0009Ool00`00Oomoo`03Ool00`?ROomoo`04Ool00`00Oomoo`04Ool20n85Ool01000Oomoo`002Goo
00<007ooOol03Goo00<007ooOol03Goo00<007ooOol027oo00<007ooOol037oo00@007ooOol000io
o`0027oo0P003Woo0P002Woo0`0037oo0P003Woo0P002Woo0`000Woo00<3hWooOol01Goo00<007oo
Ool01Woo00<3hWooOol00goo0P002Woo0`0037oo0P003Woo0P002Woo0`003Goo0P003goo001DOol0
0`?ROomoo`05Ool20007Ool00`?ROomoo`1KOol005=oo`030n9oogoo00Ioo`03001oogoo00Ioo`03
0n9oogoo05]oo`00Dgoo00<3hWooOol01Woo00<007ooOol01goo00<3hWooOol0FWoo001COol00`?R
Oomoo`06Ool00`00Oomoo`07Ool00`?ROomoo`1@Ool200000goo00000005Ool000Ioodd000030n80
0000010000030n80000004/000Ioo`03001oo`0000Ioo`001Woo00D007ooOomoo`0000Aoo`05001o
ogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomo
o`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo0000
0goo00D007ooOomoo`0000=oo`030n8007oo009oo`05001oogooOol00004Ool01P00Oomoogoo0003
hP9oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo
00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo
00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo
00Eoo`00Dgoo00<3hWooOol01Woo00<007ooOol01goo00<3hWooOol0D7oo0P0000=oo`0000001Goo
001COol00`?ROomoo`06Ool00`00Oomoo`07Ool00`?ROomoo`1JOol005=oo`83hPMoo`8000Moo`03
0n9oogoo05]oo`00E7oo00<3hWooOol01Goo00<007ooOol01Woo00<3hWooOol0Fgoo001EOol00`?R
Oomoo`04Ool00`00Oomoo`05Ool00`?ROomoo`1LOol005Eoo`83hPEoo`03001oogoo00Aoo`030n9o
ogoo05eoo`00Egoo00<3hWooOol00Woo00<007ooOol00Woo0P?RH7oo001HOol30n8017oo000007oo
0`?RHGoo001KOol40n9TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001U
Ool005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`80
06Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol004Yoo`8000Aoo`8000Aoo`8000Ao
o`03001oogoo06Aoo`00BGoo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`1TOol004Uo
o`04001oogoo000;Ool01000Oomoogoo0P00IGoo0019Ool01000Oomoo`002Goo0P0017oo00<007oo
Ool0I7oo0019Ool01000Oomoo`002Goo00<007ooOol00goo00<007ooOol0I7oo001:Ool2000:Ool3
0003Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1T
Ool005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo
06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007oo
Ool0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00
Oomoo`1TOol005Eoo`D0009oo`03001oogoo06Aoo`00Egoo00<007ooOol00Woo00<007ooOol0I7oo
001GOol00`00Oomoo`02Ool2001UOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo00<007ooOol0I7oo001FOol20004Ool00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001o
ogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@00
0Woo0P0017oo0P0017oo00<007ooOol0I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<0
07ooOol0I7oo001;Ool00`00Oomoo`0:Ool01000Oomoogoo0P00IGoo001;Ool00`00Oomoo`08Ool2
0004Ool00`00Oomoo`1TOol004]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00
BWoo0P002Woo0`000goo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo
00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001L
Ool00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol0
05aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eo
o`00G7oo00<007ooOol0I7oo001EOol40003Ool00`00Oomoo`1TOol005Eoo`03001oogoo00Aoo`03
001oogoo06Aoo`00EWoo00<007ooOol00goo0P00IGoo001GOol00`00Oomoo`1YOol005Eoo`04001o
ogoo001ZOol005Ioo`8006]oo`00`goo0033Ool00<=oo`00Lgoo0P000goo10000goo0P0017oo0P00
17oo0P0017oo0P00<7oo001bOol01000Oomoo`0027oo00@007ooOol000Qoo`04001oogoo0002Ool0
1000Oomoo`00;goo001KOol4000COol00`00Oomoo`03Ool40002Ool01000Oomoo`002Woo00<007oo
Ool017oo00<007ooOol0;Goo001JOol01000Oomoo`004goo1@0027oo00@007ooOol000]oo`04001o
ogooOol2000`Ool005Yoo`04001oogoo000DOol00`00Oomoo`09Ool01000Oomoo`0027oo00@007oo
Ool000=oo`03001oogoo02moo`00FGoo0P0000=oo`0000008Goo0P002Woo0P0017oo0`00;goo0033
Ool00<=oo`00`goo0033Ool00<=oo`00\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.5 0.25 0.5 0.25 [

[0 .4875 -6 -9 ]

[0 .4875 6 0 ]

[.125 .4875 -12 -9 ]

[.125 .4875 12 0 ]

[.25 .4875 -6 -9 ]

[.25 .4875 6 0 ]

[.375 .4875 -12 -9 ]

[.375 .4875 12 0 ]

[.625 .4875 -9 -9 ]

[.625 .4875 9 0 ]

[.75 .4875 -3 -9 ]

[.75 .4875 3 0 ]

[.875 .4875 -9 -9 ]

[.875 .4875 9 0 ]

[1 .4875 -3 -9 ]

[1 .4875 3 0 ]

[1.025 .5 0 -6.4375 ]

[1.025 .5 10 6.4375 ]

[.4875 0 -12 -4.5 ]

[.4875 0 0 4.5 ]

[.4875 .125 -24 -4.5 ]

[.4875 .125 0 4.5 ]

[.4875 .25 -12 -4.5 ]

[.4875 .25 0 4.5 ]

[.4875 .375 -24 -4.5 ]

[.4875 .375 0 4.5 ]

[.4875 .625 -18 -4.5 ]

[.4875 .625 0 4.5 ]

[.4875 .75 -6 -4.5 ]

[.4875 .75 0 4.5 ]

[.4875 .875 -18 -4.5 ]

[.4875 .875 0 4.5 ]

[.4875 1 -6 -4.5 ]

[.4875 1 0 4.5 ]

[.5 1.025 -5 0 ]

[.5 1.025 5 12.875 ]

[.5 1.0125 -56 0 ]

[.5 1.0125 56 12.875 ]

[ 0 0 0 0 ]

[ 1 1 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 g

.25 Mabswid

0 .5 m

0 .50625 L

s

[(-2)] 0 .4875 0 1 Mshowa

.125 .5 m

.125 .50625 L

s

[(-1.5)] .125 .4875 0 1 Mshowa

.25 .5 m

.25 .50625 L

s

[(-1)] .25 .4875 0 1 Mshowa

.375 .5 m

.375 .50625 L

s

[(-0.5)] .375 .4875 0 1 Mshowa

.625 .5 m

.625 .50625 L

s

[(0.5)] .625 .4875 0 1 Mshowa

.75 .5 m

.75 .50625 L

s

[(1)] .75 .4875 0 1 Mshowa

.875 .5 m

.875 .50625 L

s

[(1.5)] .875 .4875 0 1 Mshowa

1 .5 m

1 .50625 L

s

[(2)] 1 .4875 0 1 Mshowa

.125 Mabswid

.025 .5 m

.025 .50375 L

s

.05 .5 m

.05 .50375 L

s

.075 .5 m

.075 .50375 L

s

.1 .5 m

.1 .50375 L

s

.15 .5 m

.15 .50375 L

s

.175 .5 m

.175 .50375 L

s

.2 .5 m

.2 .50375 L

s

.225 .5 m

.225 .50375 L

s

.275 .5 m

.275 .50375 L

s

.3 .5 m

.3 .50375 L

s

.325 .5 m

.325 .50375 L

s

.35 .5 m

.35 .50375 L

s

.4 .5 m

.4 .50375 L

s

.425 .5 m

.425 .50375 L

s

.45 .5 m

.45 .50375 L

s

.475 .5 m

.475 .50375 L

s

.525 .5 m

.525 .50375 L

s

.55 .5 m

.55 .50375 L

s

.575 .5 m

.575 .50375 L

s

.6 .5 m

.6 .50375 L

s

.65 .5 m

.65 .50375 L

s

.675 .5 m

.675 .50375 L

s

.7 .5 m

.7 .50375 L

s

.725 .5 m

.725 .50375 L

s

.775 .5 m

.775 .50375 L

s

.8 .5 m

.8 .50375 L

s

.825 .5 m

.825 .50375 L

s

.85 .5 m

.85 .50375 L

s

.9 .5 m

.9 .50375 L

s

.925 .5 m

.925 .50375 L

s

.95 .5 m

.95 .50375 L

s

.975 .5 m

.975 .50375 L

s

.25 Mabswid

0 .5 m

1 .5 L

s

gsave

1.025 .5 -61 -10.4375 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(x) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

.5 0 m

.50625 0 L

s

[(-2)] .4875 0 1 0 Mshowa

.5 .125 m

.50625 .125 L

s

[(-1.5)] .4875 .125 1 0 Mshowa

.5 .25 m

.50625 .25 L

s

[(-1)] .4875 .25 1 0 Mshowa

.5 .375 m

.50625 .375 L

s

[(-0.5)] .4875 .375 1 0 Mshowa

.5 .625 m

.50625 .625 L

s

[(0.5)] .4875 .625 1 0 Mshowa

.5 .75 m

.50625 .75 L

s

[(1)] .4875 .75 1 0 Mshowa

.5 .875 m

.50625 .875 L

s

[(1.5)] .4875 .875 1 0 Mshowa

.5 1 m

.50625 1 L

s

[(2)] .4875 1 1 0 Mshowa

.125 Mabswid

.5 .025 m

.50375 .025 L

s

.5 .05 m

.50375 .05 L

s

.5 .075 m

.50375 .075 L

s

.5 .1 m

.50375 .1 L

s

.5 .15 m

.50375 .15 L

s

.5 .175 m

.50375 .175 L

s

.5 .2 m

.50375 .2 L

s

.5 .225 m

.50375 .225 L

s

.5 .275 m

.50375 .275 L

s

.5 .3 m

.50375 .3 L

s

.5 .325 m

.50375 .325 L

s

.5 .35 m

.50375 .35 L

s

.5 .4 m

.50375 .4 L

s

.5 .425 m

.50375 .425 L

s

.5 .45 m

.50375 .45 L

s

.5 .475 m

.50375 .475 L

s

.5 .525 m

.50375 .525 L

s

.5 .55 m

.50375 .55 L

s

.5 .575 m

.50375 .575 L

s

.5 .6 m

.50375 .6 L

s

.5 .65 m

.50375 .65 L

s

.5 .675 m

.50375 .675 L

s

.5 .7 m

.50375 .7 L

s

.5 .725 m

.50375 .725 L

s

.5 .775 m

.50375 .775 L

s

.5 .8 m

.50375 .8 L

s

.5 .825 m

.50375 .825 L

s

.5 .85 m

.50375 .85 L

s

.5 .9 m

.50375 .9 L

s

.5 .925 m

.50375 .925 L

s

.5 .95 m

.50375 .95 L

s

.5 .975 m

.50375 .975 L

s

.25 Mabswid

.5 0 m

.5 1 L

s

gsave

.5 1.025 -66 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(u) show

69.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Courier

grestore

gsave

.5 1.0125 -117 -4 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 20.875 translate 1 -1 scale

gsave

0.000000 0.000000 0.000000 setrgbcolor

1.000000 setlinewidth

gsave

newpath

 61.000000 16.875000 moveto

 460.000000 16.875000 lineto

 460.000000 4.000000 lineto

 61.000000 4.000000 lineto

 61.000000 16.875000 lineto

closepath

clip newpath

63.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

141.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

147.000000 13.000000 moveto

%%IncludeResource: font Math1Mono

%%IncludeFont: Math1Mono

/Math1Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(=) show

153.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(0.3) show

171.000000 13.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

grestore

grestore

%%DocumentNeededResources: font Math1Mono

%%+ font Courier

%%DocumentSuppliedResources:

%%DocumentNeededFonts: Math1Mono

%%+ Courier

%%DocumentSuppliedFonts:

%%DocumentFonts: font Math1Mono

%%+ font Courier

grestore

0 0 m

1 0 L

1 1 L

0 1 L

closepath

clip

newpath

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  ImageSize->{195, 195},
  ImageMargins->{{75, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.161038,
  AnimationCycleOffset->-1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000330000`a000`40O003h00O`goo0033Ool00<=o
o`00EGoo1000JWoo001EOol00`00Oomoo`1[Ool005Ioo`03001oogoo00=oo`8006Eoo`00Cgoo1000
17oo00<007ooOol00Woo00<007ooOol0I7oo001EOol01000Oomoo`000goo00<007ooOol0I7oo001F
Ool20004Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<0
07ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol0
0`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00BGoo1@000Woo0P0017oo0P0017oo00<007ooOol0
I7oo001;Ool00`00Oomoo`07Ool01000Oomoo`000goo00<007ooOol0I7oo001;Ool00`00Oomoo`0:
Ool01000Oomoogoo0P00IGoo0013Ool40004Ool00`00Oomoo`08Ool20004Ool00`00Oomoo`1TOol0
04]oo`03001oogoo00Qoo`03001oogoo00=oo`03001oogoo06Aoo`00BWoo0P002Woo0`000goo00<0
07ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo
001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03001oogoo06Aoo`00Egoo00<0
07ooOol00Woo0P00IGoo001?Ool40004Ool00`00Oomoo`02Ool00`00Oomoo`1TOol005Moo`03001o
ogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol2001UOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomo
o`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol004Yoo`8000Ao
o`8000Aoo`8000Aoo`03001oogoo06Aoo`00BGoo00@007ooOol000Qoo`04001oogoo0003Ool00`00
Oomoo`1TOol004Uoo`04001oogoo000;Ool01000Oomoogoo0P00IGoo0013Ool40002Ool01000Oomo
o`002Goo0P0017oo00<007ooOol0I7oo0019Ool01000Oomoo`002Goo00<007ooOol00goo00<007oo
Ool0I7oo001:Ool2000:Ool30003Ool00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0
I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`001goo100037oo1@000Woo0P0017oo0P0037oo1@0037oo0P00
17oo0P0017oo0P002goo00<007ooOol037oo0P0017oo0P0017oo0P0037oo1@002goo1@000Woo0P00
17oo0P003Goo10003Woo0007Ool00`00Oomoo`0?Ool00`00Oomoo`07Ool01000Oomoo`003Goo00<0
07ooOol02goo00@007ooOol000Qoo`04001oogoo000:Ool00`00Oomoo`0;Ool01000Oomoo`0027oo
00@007ooOol000eoo`03001oogoo00eoo`03001oogoo00Moo`04001oogoo000<Ool00`00Oomoo`0?
Ool000Qoo`03001oogoo00ioo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`04001o
ogoo000;Ool00`00Oomoo`08Ool2000<Ool01000Oomoo`002goo00<007ooOol02goo00<007ooOol0
3Goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol03Woo00000goo000000020004Ool00`00
Oomoo`05Ool40004Ool00`00Oomoo`08Ool20006Ool40004Ool00`00Oomoo`05Ool40002Ool01000
Oomoo`002Goo0P002goo00<007ooOol02goo00@007ooOol000Uoo`8000ioo`03001oogoo00eoo`03
001oogoo00Qoo`8000moo`03001oogoo00eoo`001goo00@007ooOol000ioo`03001oogoo00Qoo`03
001oogoo00eoo`03001oogoo00]oo`04001oogoo0009Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool0
1000Oomoo`002Goo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol027oo00<007ooOol037oo
00@007ooOol000ioo`0027oo0P003Woo0P002Woo0`0037oo0P003Woo0P002Woo0`002Woo00<007oo
Ool037oo0P002Woo0`0037oo0P003Woo0P002Woo0`003Goo0P003goo001LOol2001UOol005aoo`03
001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1JOol200000goo00000005Ool0
00Ioojh000Ioo`03001oo`0000Ioo`001Woo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool0
0`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001o
ogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00D007ooOomo
o`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool01@00Oomoogoo0000
17oo00D007ooOomoo`0000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomoo`02Ool0
1@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo001LOol00`00
Oomoo`1JOol200000goo00000005Ool005aoo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00
Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol0
05aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Ao
o`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0
I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001:Ool20004Ool2
0004Ool20004Ool00`00Oomoo`1TOol004Uoo`04001oogoo0008Ool01000Oomoo`000goo00<007oo
Ool0I7oo0019Ool01000Oomoo`002goo00@007ooOomoo`8006Eoo`00BGoo00@007ooOol000Uoo`80
00Aoo`03001oogoo06Aoo`00BGoo00@007ooOol000Uoo`03001oogoo00=oo`03001oogoo06Aoo`00
BWoo0P002Woo0`000goo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo
00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001L
Ool00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol0
05aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`8006Eo
o`00G7oo00<007ooOol0I7oo001EOol50002Ool00`00Oomoo`1TOol005Moo`03001oogoo009oo`03
001oogoo06Aoo`00Egoo00<007ooOol00Woo0P00IGoo001GOol00`00Oomoo`02Ool00`00Oomoo`1T
Ool005Moo`03001oogoo009oo`03001oogoo06Aoo`00EWoo0P0017oo00<007ooOol0I7oo001LOol0
0`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005ao
o`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo
001LOol00`00Oomoo`1TOol005aoo`8006Eoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1T
Ool004Uoo`D0009oo`8000Aoo`8000Aoo`03001oogoo06Aoo`00Bgoo00<007ooOol01goo00@007oo
Ool000=oo`03001oogoo06Aoo`00Bgoo00<007ooOol02Woo00@007ooOomoo`8006Eoo`00Bgoo00<0
07ooOol027oo0P0017oo00<007ooOol0I7oo001;Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00
Oomoo`1TOol004Yoo`8000Yoo`<000=oo`03001oogoo06Aoo`00G7oo0P00IGoo001LOol00`00Oomo
o`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol2001UOol005aoo`03001o
ogoo06Aoo`00G7oo00<007ooOol0I7oo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00
G7oo0P00IGoo001LOol00`00Oomoo`1TOol005aoo`03001oogoo06Aoo`00G7oo00<007ooOol0I7oo
001LOol2001UOol005aoo`03001oogoo06Aoo`00EGoo10000goo00<007ooOol0I7oo001EOol00`00
Oomoo`04Ool00`00Oomoo`1TOol005Ioo`03001oogoo00=oo`8006Eoo`00Egoo00<007ooOol0JGoo
001EOol01000Oomoo`00JWoo001FOol2001[Ool00<=oo`00`goo0033Ool007Ioo`8000=oo`@000=o
o`8000Aoo`8000Aoo`8003=oo`00MGoo00@007ooOol000Qoo`04001oogoo0008Ool01000Oomoo`00
<Woo001KOol4000FOol00`00Oomoo`03Ool40002Ool01000Oomoo`002Woo00<007ooOol0<Goo001J
Ool01000Oomoo`005Woo1@0027oo00@007ooOol000]oo`03001oogoo031oo`00FWoo00@007ooOol0
01Moo`03001oogoo00Uoo`04001oogoo0008Ool01000Oomoo`00<Woo001IOol200000goo0000000T
Ool2000:Ool2000cOol00<=oo`00`goo0033Ool00<=oo`00`goo0000\
\>"],
  ImageRangeCache->{{{0, 194}, {194, 0}} -> {-2.15526, -2.10448, 0.0232133, \
0.0232133}}]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "The solution of this quadratic equation in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " yields the final representation of the solution of Tang's equation to be"
}], "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol11 = Solve[sol1\[LeftDoubleBracket]1\[RightDoubleBracket], u]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{u \[Rule] \(-\@\(\(-2\)\ k\ t - x\^2 - 2\ C[1]\)\)}, {
        u \[Rule] \@\(\(-2\)\ k\ t - x\^2 - 2\ C[1]\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "containing the parameter ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " of the original equation and one constant of integration ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  ". The graphical representation of the second solution for parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k = \(-2\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`C[1] = 1/2\)]],
  " gives us the impression that the solution has a smooth behavior:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[
      \(u /. sol11\[LeftDoubleBracket]2\[RightDoubleBracket]\) /. {
          k \[Rule] \(-2\), C[1] \[Rule] 1\/2}, {x, 0, 2}, {t, 2, 4}, 
      ColorFunction \[Rule] Hue, Axes \[Rule] True, 
      AxesLabel \[Rule] {"\<x\>", "\<t\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.480769 -0.942308 0.480769 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -9 -9 ]
[.25962 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -18 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(3)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(3.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(4)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .4 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 1 r
.01923 .0543 m
.08791 .05676 L
.15659 .06412 L
.22527 .07638 L
.274 .08791 L
.29396 .09355 L
.36264 .11563 L
.43132 .14261 L
.46285 .15659 L
.5 .1745 L
.56868 .21129 L
.59268 .22527 L
.63736 .25299 L
.69812 .29396 L
.70604 .2996 L
.77473 .35111 L
.78928 .36264 L
.84341 .40752 L
.87073 .43132 L
.91209 .46885 L
.945 .5 L
.98077 .53507 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .0543 m
.08791 .05676 L
.15659 .06412 L
.22527 .07638 L
.274 .08791 L
.29396 .09355 L
.36264 .11563 L
.43132 .14261 L
.46285 .15659 L
.5 .1745 L
.56868 .21129 L
.59268 .22527 L
.63736 .25299 L
.69812 .29396 L
.70604 .2996 L
.77473 .35111 L
.78928 .36264 L
.84341 .40752 L
.87073 .43132 L
.91209 .46885 L
.945 .5 L
.98077 .53507 L
s
0 .4 1 r
.01923 .19198 m
.08791 .19443 L
.15659 .20179 L
.22527 .21406 L
.27283 .22527 L
.29396 .23123 L
.36264 .2533 L
.43132 .28028 L
.46217 .29396 L
.5 .31217 L
.56868 .34897 L
.59215 .36264 L
.63736 .39066 L
.69768 .43132 L
.70604 .43727 L
.77473 .48878 L
.78889 .5 L
.84341 .5452 L
.87038 .56868 L
.91209 .60652 L
.94467 .63736 L
.98077 .67275 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .19198 m
.08791 .19443 L
.15659 .20179 L
.22527 .21406 L
.27283 .22527 L
.29396 .23123 L
.36264 .2533 L
.43132 .28028 L
.46217 .29396 L
.5 .31217 L
.56868 .34897 L
.59215 .36264 L
.63736 .39066 L
.69768 .43132 L
.70604 .43727 L
.77473 .48878 L
.78889 .5 L
.84341 .5452 L
.87038 .56868 L
.91209 .60652 L
.94467 .63736 L
.98077 .67275 L
s
.2 0 1 r
.01923 .33969 m
.08791 .34215 L
.15659 .34951 L
.22527 .36177 L
.2294 .36264 L
.29396 .37894 L
.36264 .40102 L
.43132 .428 L
.43903 .43132 L
.5 .45989 L
.56868 .49668 L
.57447 .5 L
.63736 .53838 L
.68286 .56868 L
.70604 .58498 L
.77473 .6365 L
.77583 .63736 L
.84341 .69291 L
.8586 .70604 L
.91209 .75423 L
.93387 .77473 L
.98077 .82046 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .33969 m
.08791 .34215 L
.15659 .34951 L
.22527 .36177 L
.2294 .36264 L
.29396 .37894 L
.36264 .40102 L
.43132 .428 L
.43903 .43132 L
.5 .45989 L
.56868 .49668 L
.57447 .5 L
.63736 .53838 L
.68286 .56868 L
.70604 .58498 L
.77473 .6365 L
.77583 .63736 L
.84341 .69291 L
.8586 .70604 L
.91209 .75423 L
.93387 .77473 L
.98077 .82046 L
s
.8 0 1 r
.01923 .49745 m
.08791 .4999 L
.0893 .5 L
.15659 .50726 L
.22527 .51952 L
.29396 .53669 L
.36264 .55877 L
.3895 .56868 L
.43132 .58575 L
.5 .61764 L
.53801 .63736 L
.56868 .65443 L
.63736 .69613 L
.65262 .70604 L
.70604 .74274 L
.74948 .77473 L
.77473 .79425 L
.8349 .84341 L
.84341 .85067 L
.91209 .91199 L
.9122 .91209 L
.98077 .97822 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49745 m
.08791 .4999 L
.0893 .5 L
.15659 .50726 L
.22527 .51952 L
.29396 .53669 L
.36264 .55877 L
.3895 .56868 L
.43132 .58575 L
.5 .61764 L
.53801 .63736 L
.56868 .65443 L
.63736 .69613 L
.65262 .70604 L
.70604 .74274 L
.74948 .77473 L
.77473 .79425 L
.8349 .84341 L
.84341 .85067 L
.91209 .91199 L
.9122 .91209 L
.98077 .97822 L
s
1 0 .6 r
.01923 .66524 m
.08791 .66769 L
.15659 .67505 L
.22527 .68732 L
.29396 .70449 L
.29943 .70604 L
.36264 .72656 L
.43132 .75354 L
.47817 .77473 L
.5 .78543 L
.56868 .82223 L
.60462 .84341 L
.63736 .86393 L
.70604 .91053 L
.70822 .91209 L
.77473 .96204 L
.79821 .98077 L
.01923 .98077 L
F
0 g
.01923 .66524 m
.08791 .66769 L
.15659 .67505 L
.22527 .68732 L
.29396 .70449 L
.29943 .70604 L
.36264 .72656 L
.43132 .75354 L
.47817 .77473 L
.5 .78543 L
.56868 .82223 L
.60462 .84341 L
.63736 .86393 L
.70604 .91053 L
.70822 .91209 L
.77473 .96204 L
.79821 .98077 L
s
1 0 0 r
.01923 .84307 m
.04455 .84341 L
.08791 .84553 L
.15659 .85288 L
.22527 .86515 L
.29396 .88232 L
.36264 .9044 L
.38367 .91209 L
.43132 .93138 L
.5 .96326 L
.53388 .98077 L
.01923 .98077 L
F
0 g
.01923 .84307 m
.04455 .84341 L
.08791 .84553 L
.15659 .85288 L
.22527 .86515 L
.29396 .88232 L
.36264 .9044 L
.38367 .91209 L
.43132 .93138 L
.5 .96326 L
.53388 .98077 L
s
.2 1 0 r
.98077 .40744 m
.93485 .36264 L
.91209 .34121 L
.85967 .29396 L
.84341 .27989 L
.77702 .22527 L
.77473 .22347 L
.70604 .17196 L
.68422 .15659 L
.63736 .12535 L
.5761 .08791 L
.56868 .08366 L
.5 .04686 L
.44118 .01923 L
.98077 .01923 L
F
0 g
.98077 .40744 m
.93485 .36264 L
.91209 .34121 L
.85967 .29396 L
.84341 .27989 L
.77702 .22527 L
.77473 .22347 L
.70604 .17196 L
.68422 .15659 L
.63736 .12535 L
.5761 .08791 L
.56868 .08366 L
.5 .04686 L
.44118 .01923 L
s
.8 1 0 r
.98077 .28984 m
.91387 .22527 L
.91209 .22361 L
.84341 .16229 L
.83674 .15659 L
.77473 .10587 L
.75154 .08791 L
.70604 .05436 L
.65499 .01923 L
.98077 .01923 L
F
0 g
.98077 .28984 m
.91387 .22527 L
.91209 .22361 L
.84341 .16229 L
.83674 .15659 L
.77473 .10587 L
.75154 .08791 L
.70604 .05436 L
.65499 .01923 L
s
1 .6 0 r
.98077 .18229 m
.95468 .15659 L
.91209 .11606 L
.88127 .08791 L
.84341 .05473 L
.80092 .01923 L
.98077 .01923 L
F
0 g
.98077 .18229 m
.95468 .15659 L
.91209 .11606 L
.88127 .08791 L
.84341 .05473 L
.80092 .01923 L
s
1 0 0 r
.98077 .08477 m
.91283 .01923 L
.98077 .01923 L
F
0 g
.98077 .08477 m
.91283 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{213, 213},
  ImageMargins->{{71.3125, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003E0000eA000`40O003h00OeGoo003EOol00=Eo
o`005Woo0P008goo0P0017oo0P0017oo0P008Goo1@0087oo1@000Woo0P0017oo0P008Woo10004Goo
000EOol01000Oomoo`008Goo00@007ooOol000Qoo`04001oogoo000ROol00`00Oomoo`0ROol00`00
Oomoo`07Ool01000Oomoo`008Goo00<007ooOol04Woo000EOol01000Oomoo`008Goo00@007ooOol0
00]oo`03001oogoo021oo`03001oogoo029oo`03001oogoo00Yoo`03001oogoo021oo`03001oogoo
015oo`005Goo00@007ooOol0025oo`04001oogoo0009Ool2000SOol00`00Oomoo`0ROol00`00Oomo
o`08Ool2000TOol00`00Oomoo`0@Ool001Eoo`04001oogoo000QOol01000Oomoo`002Goo00<007oo
Ool08Woo00<007ooOol08Woo00<007ooOol027oo00<007ooOol08Goo00@007ooOol0015oo`005Woo
0P008goo0P002Woo0`008Goo0P008goo0P002Woo0`008Woo0P004Woo003EOol00=Eoo`00eGoo003<
Ool200000goo00000004Ool00<eoo`03001oo`0000Eoo`0057oo/P0027oo00<007ooOol017oo000=
Ool40003Ool01000Oomoo`00:Woo00<007ooOol09goo00<007ooOol0:7oo00<007ooOol0:7oo00@0
07ooOol000Ioo`800003Ool0000000Aoo`003Goo00<007ooOol017oo00<007ooOol0[Woo00<007oo
Ool03Goo000>Ool00`00Oomoo`03Ool2001<Ool00`00Oomoo`0SOol00`00Oomoo`0GOol00`00Oomo
o`0AOol00`00Oomoo`0;Ool2000?Ool000moo`03001oogoo009oo`1?001oogoo0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`00P0002@Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0200006F?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh000009n@005OV1n@7i0OT1nH003OT001GiPOT1n
@7i0OV000gi000=nH000O0002G`00goo00<007ooOol03Goo000=Ool01000Oomoo`000goo00<007oo
Ool0CP?/0P000QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh00L6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OP000COT000`00O01l0007O003Ool00`00Oomoo`0=Ool000ioo`8000Aoo`1C001o
ogoo0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00200008aOP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n00
0P0001MWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00800003OT1n
H7i0009n@005OV1n@7i0OT1nH003OT001WiPOT1n@7i0OV0000Ql00=oo`03001oogoo00eoo`0057oo
00<007ooOol0DP?/0P0000DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh00M6n0Gh1OP001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn00000BOT000`00O01l0005O003Ool00`00Oomoo`0=Ool001Aoo`1G001o
ogoo0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080000R5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0200006V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0007i0
OV03OT001GiPOT1n@7i0OV000gi000InH7i0OT1n@7iP0006O003Ool00`00Oomoo`0=Ool001Aoo`03
001oogoo00H00503k080008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n006@00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh000019n@003001l07`000=l00=oo`03001oogoo00eoo`0057oo00<007ooOol0
1P?o300004H3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k080000l5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P001n@7iP0gi000EnH7i0OT1n@7iP00=n@006OV1n@7i0
OT1nH00017`00goo00<007ooOol03Goo000DOol00`00Oomoo`0B0ol:000n0n`200001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP0P0001MW
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh000019n@004001l07`0O003
Ool00`00Oomoo`0=Ool001Aoo`03001oogoo01`3o`H0000j0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`20000=aOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0006OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00800005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV00
0gi000AnH000O01l009oo`8000moo`0057oo00<007ooOol08P?o1@00=`?/0P000QOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP01hKh1OP5n0Gh1_P001Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000AOT000`00O01oo`02Ool00`00
Oomoo`0=Ool001Aoo`03001oogoo02L3o`@0000e0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k00200007QOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh080000HHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn0007iP0gi000EnH7i0OT1n@7iP00=n@006OV1n@7i0OT1nH0000goo00<007ooOol0
3Goo000DOol00`00Oomoo`0[0ol4000c0n`200001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n007Q_P5n0Gh1OP6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn00015n@004001oogoo000?Ool001Aoo`03001oogoo02l3o`@0000a0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P0003HGh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh000OV03OT001GiPOT1n@7i0OV000gi000AnH7i0OT1n@0=o
o`03001oogoo00eoo`0057oo00<007ooOol0<`?o0`00<0?/00D001OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00HKh1OP5n0Gh1_P5n0200005VOPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0003gi00goo00<007ooOol03Goo000DOol00`00Oomoo`0f
0ol30000;P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0P0003DKh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P001Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0007iP00=n@005OV1n@7i0OT1nH003OT000giPOT1oo`02
Ool00`00Oomoo`0=Ool001Aoo`03001oogoo03T3o`<002d3k08000035n0Kh1OP008Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P008Gh00G001Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00000=OT03Ool00`00Oomoo`0=Ool001Aoo`03001oogoo
03`3o`<000190n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n000P0001ISh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP001nH0=n@005OV1n@7i0OT1nH003OT02Ool2000?Ool001Aoo`03
001oogoo03l3o`8002/3k08000056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh00J6n0Gh1OP5n0006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00
00]n@0=oo`03001oogoo00eoo`0057oo00<007ooOol0@@?o0P0005l3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0007iP00=n@006OV1n
@7i0OT1nH7i00goo00<007ooOol03Goo000DOol00`00Oomoo`130ol3000Y0n`200035n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n005P00Hn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0002Gi00goo00<007ooOol03Goo000DOol00`00Oomoo`16
0ol20000FP?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh08000=n@004OV1n@7i0OT03Ool00`00Oomoo`0=Ool001Aoo`03001oogoo04P3o`<002L3
k080008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh080000E
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00000In@0=oo`03001oogoo00eo
o`0057oo00<007ooOol0B`?o0`0002H3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0P00030Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?P0003OT000giPOT1oo`02Ool00`00Oomoo`0=Ool001Aoo`03001oogoo
04h3o`8002H3k003000Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP01/Kh1OP
5n0Gh1_P001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000017i00goo00<0
07ooOol03Goo000DOol00`00Oomoo`1@0ol20000EP?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[000Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P001Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P0003OT03Ool00`00Oomoo`0=Ool001Aoo`03001oogoo0583o`03
0003k0?/02<3k08000056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<G
h00G6n0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000002OT02Ool2000?
Ool001Aoo`03001oogoo05<3o`80001F0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?P001n@0=oo`03001oogoo00eoo`0057oo00<007ooOol0E@?o0P0090?/00<001_P
5n000QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n006a_P5n0Gh1OP6n0006OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000003Ool00`00Oomoo`0=Ool001Aoo`03001o
ogoo05L3o`80000S0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0020000;QOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh000
0Woo00<007ooOol03Goo000DOol00`00Oomoo`1I0ol2000S0n`01@005n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n005A_P001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh003Ool00`00Oomoo`0=Ool001Aoo`03001oogoo00l004`3o`80000k0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
01OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh00200004F?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000goo00<007ooOol03Goo000DOol00`00Oomoo`0?
0Il600180ol2000Q0n`200025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh00G6n0Gh1OP
5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh003Ool00`00Oomoo`0=Ool001Ao
o`0H001oogoo0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o1`00@`?o0P00
04X3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh000
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P0goo00<007ooOol03Goo000DOol00`00Oomoo`0L
0Il6000o0ol2000P0n`010005n0Gh1_P0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
4A_P5n0006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn000Woo0P003goo000DOol09@00Oomoo`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O00D003`3o`0Q0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080000U5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000goo00<007ooOol03Goo000D
Ool00`00Oomoo`0W0Il4000i0ol2000P0n`00`005n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh00?6n0Gh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00=oo`03001oogoo00eoo`00
57oo02h007ooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`@003L3o`150003k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[000Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?P00=oo`03001oogoo00eoo`0057oo00<007ooOol0;`6O1000=0?o0P007`?/00<001OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n003A_P5n0006?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
00=oo`03001oogoo00eoo`0057oo03H007ooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl3000c0ol080000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/2000081_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OPHn03Ool00`00Oomoo`0=Ool001Aoo`03001oogoo
03H1W`<00343o`8001l3k003000Kh1OP008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00/Kh1OP001Sh6OPHn1Wh6?PIn1Sh6OP00=oo`03001oogoo00eoo`0000=oo`0000000P000goo0P00
17oo0P0017oo03`007ooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl3000`0ol20000?@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0006?PIn1Sh6OPHn1Wh6?P00=oo`03001oogoo00eoo`0000=oo`00Ool02Woo00@007oo
Ool000=oo`03001oogoo03`1W`<002l3o`030003k0?/01`3k003000Kh1OP008Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000aOP00TKh1OP001Sh6OPHn1Wh6?PIn000goo00<007ooOol03Goo0002
Ool00`00Oomoo`0;Ool01000Oomoogoo0P00041oo`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`<002d3o`80000d0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0006n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n02000016OPHn1Wh6?P0Woo0P003goo0003Ool0
0`00Oomoo`08Ool20004Ool00`00Oomoo`120Il3000/0ol00`000n`3k00K0n`200035n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0076n0Gh1OP001Wh6?PIn000goo00<007ooOol03Goo0000
1Goo001oogoo00002Goo00<007ooOol00goo04P007ooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl3000Z0ol2
0000=`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P001Wh6?P00=oo`03
001oogoo00eoo`000Woo0P002Woo0`000goo00<007ooOol0B06O0P00:P?o0P0070?/00D001OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000QOP00<006OPOol00Woo00<007ooOol0
3Goo000DOol0C@00Oomoo`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00P00:P?o03D000?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[000Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh00000=oo`03001oogoo00eoo`0057oo
00<007ooOol0C06O0P00:@?o0P006`?/00D001OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P
5n0Gh1OP6n000QOP00@007ooOol000moo`0057oo054007ooOol1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il00P00:@?o038000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP0goo00<007ooOol03Goo000DOol00`00Oomoo`1@0Il2000X0ol00`000n`3k00I0n`01@005n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003Ool00`00Oomoo`0=Ool001Aoo`1E
001oogoo0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00P009`?o0300
00?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`005n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n02Ool2000?Ool001Aoo`03001oogoo05@1
W`8002H3o`8001X3k005000Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh1OP5n000goo00<0
07ooOol03Goo000DOol0F@00Oomoo`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il00P009P?o01/000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/00P00010Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0=oo`03
001oogoo00eoo`0057oo00<007ooOol0F06O0P009@?o00<000?/0n`06@?/00@001OP5n0Kh0<Gh005
6n0Gh1OP5n0Kh0035n001A_POomoogoo00003goo000DOol0G@00Oomoo`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02000T0ol20000:@?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`001_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n000goo00<007ooOol03Goo000DOol00`00Oomoo`1L0Il2000T0ol00`00
0n`3k00H0n`010005n0Gh1_P0aOP00DKh1OP5n0Gh1_P008Gh0=oo`03001oogoo00eoo`0057oo00<0
07ooOol03`0004l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02000S0ol0:000
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0006n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP0goo00<007ooOol03Goo000DOol00`00Oomoo`0251l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00H004/1W`800283o`8001T3k004000Gh1OP6n035n001A_P5n0Gh1OP
6n000goo00<007ooOol03Goo000DOol06000Oomooa@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7`L000170Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000S0ol06P000n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`200002AOP6n0Gh1_P5n0Kh1OP6n0G
h003Ool00`00Oomoo`0=Ool001Aoo`04001oogoo61l351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l600110Il2000R0ol2000I0n`00`005n0Kh0035n000a_P5n0G
h002Ool2000?Ool001Aoo`0U001oogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l01@0003h1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0P008P?o028000?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[000Gh1_P5n0Kh1OP6n0Gh0=o
o`03001oogoo00eoo`0057oo00<007ooOol00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`04000l0Il2000Q0ol0
0`000n`3k00G0n`00`005n0Kh0035n001A_POomoogoo00003goo000DOol0;P00Oomooa@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O100003/1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`000243o`0P0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`005n0Kh1OP6n0Gh0=oo`03001oogoo00eoo`0057oo00@007ooOolH
7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O51l01000=`6O0P0080?o00<000?/0n`05`?/00<0
01OP6n000QOP0goo00<007ooOol03Goo000DOol0=P00Oomooa@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7`<0000f0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0P007`?o0P0001`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/001OP6n0Gh0=oo`03001oogoo00eoo`0057oo00<007ooOol00Q@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7`<003D1W`030003o`?o01h3o`030003
k0?/01H3k003000Gh1_P00=oo`03001oogoo00eoo`0057oo03`007ooOolD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l30000<`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`02000O0ol06`000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[000Gh003Ool00`00Oomoo`0=Ool001Aoo`04001oogoo61l3
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O0`00<P6O
00<000?o0ol07@?o00<000?/0n`05P?/00<007ooOol00P003goo000DOol0@P00Oomooa@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`80
000b0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il001l3o`0J0003k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0009oo`03001oogoo00eoo`0057oo
00<007ooOol00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0251l2000`0Il2000N0ol00`000n`3k00E0n`3Ool00`00Oomoo`0=Ool0
01Aoo`16001oogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l30000<05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl001h3o`80000E0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00=o
o`03001oogoo00eoo`0057oo00@007ooOolH7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O000002h1W`8001h3o`03
0003k0?/0183k0=oo`03001oogoo00eoo`0057oo04/007ooOolD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61l0100002d1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00007P?o01@000?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0goo00<007ooOol03Goo000DOol00`00Oomoo`0251l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l011PO51l00000:`6O0P007@?o00<000?/0n`040?/0goo00<007oo
Ool03Goo000DOol0D@00Oomooa@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`020000
;05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o000M0ol04P000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`=oo`03001oogoo00eoo`0057oo00@007ooOolH7`<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0461lD7a@O51l2000Z0Il2000L0ol00`000n`3k00>0n`3Ool00`00Oomoo`0=Ool001Ao
o`1E001oogoo51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00P0002/1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000L0ol040000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0Woo0P003goo000DOol00`00Oomoo`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00@H7a@O000002T1W`030003o`?o01X3o`030003k0?/00`3k0=oo`03001oogoo00eo
o`0057oo05T007ooOolD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO0080000X0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il2000K0ol03P000n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3Ool00`00Oomoo`0=Ool001Aoo`04001oogoo61l351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7`8002P1W`030003o`?o01T3o`030003k0?/00X3
k0=oo`03001oogoo00eoo`0057oo05d007ooOolD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00P0002P1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl001/3o`0<
0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0goo00<007ooOol03Goo000DOol00`00Oomoo`0251l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0461lD7`00
000V0Il2000J0ol00`000n`3k0080n`3Ool00`00Oomoo`0=Ool000ioo`8000Aoo`1Q001oogoo51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61l00P0002L1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00006P?o0P0000P3k0?[0n`3j`?/0n/3k0?[0goo00<0
07ooOol03Goo000=Ool01000Oomoo`000goo00@007ooOolH7`<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7`8002D1W`8001X3o`03
0003k0?/00D3k0=oo`03001oogoo00eoo`003goo00<007ooOol00Woo0P0000=oo`0000003P00058D
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`80000V0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl001X3o`070003k0?[0n`3j`?/0n/00Woo0P003goo000@Ool01@00Oomoogoo00000Woo011T7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`H0000561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD
7a@O51lH7a@O0P00906O00<000?o0ol060?o00<000?/0n`00`?/0goo00<007ooOol03Goo000=Ool0
1000Oomoo`000goo01T007ooOomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7`060000L1@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`006P?o00D0
00?/0n/3k0?[00=oo`03001oogoo00eoo`003Woo0P0017oo01l007ooOomT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`06000251l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD
7a@O008002<1W`030003o`?o01P3o`040003k0?/0n`3Ool00`00Oomoo`0=Ool001Aoo`0U001oogoo
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1l01@00048H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l200008P6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0P006@?o00<000?/0n/00goo00<0
07ooOol03Goo000DOol0:P00Oomoof@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`@000<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61l002<1W`030003
o`?o01L3o`030003k7oo009oo`03001oogoo00eoo`0057oo02h007ooOomP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7`@0000m61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61l00P0002<1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0001T3o`05001oogooOol0000?Ool001Aoo`0b
001oogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`@0000351lH7a@O008D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0761lD7a@O51lH7a@O00008P6O00<000?o0ol0
5`?o00@007ooOol000moo`0057oo03H007ooOomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l30000GA@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0000H0ol3Ool00`00Oomoo`0=Ool001Aoo`0i001oogooI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00<0000351lH7a@O008D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0461lD7`00000Q0Il00`000ol3o`0E0ol2
Ool2000?Ool001Aoo`0l001oogooH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0O0`0005TD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`0001H3o`=oo`03001oogoo00eoo`0057oo03l007ooOomT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00`0000<D7aPO
51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00Q@O00<0006O0Il07`6O00<000?o
0ol04`?o0goo00<007ooOol03Goo000DOol0@P00Oomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`80000c61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0080000Q0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0001@3o`=oo`03001oogoo00eoo`00
57oo04@007ooOomT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O0`000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00<0006O0Il07P6O00<000?o0ol04@?o0goo00<007ooOol03Goo000DOol0A`00Oomoof0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1l00P00034D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`020000
806O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O000B0ol3Ool00`00Oomoo`0=Ool001Aoo`19001oogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00P00
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7`0000007P6O00<000?o0ol03`?o
0goo00<007ooOol03Goo000DOol0B`00Oomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`030000CaPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O008000l3o`=oo`03001oogoo00eoo`00
57oo04h007ooOomT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l200000a@O61lD7`0251l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0361lD7`0001l1W`030003o`?o00`3o`9oo`8000moo`0057oo050007oo
OomP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0P0002hH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7`80000O0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o00003@?o0goo00<007ooOol03Goo000DOol0DP00Oomoof@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0`000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l011PO
51lD7`007P6O00<000?o0ol02P?o0goo00<007ooOol03Goo000DOol0E@00Oomoof0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0080001<51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o000;0ol3Ool00`00Oomoo`0=Ool001Aoo`1G001oogooI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0080000561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O
51l001h1W`030003o`?o00P3o`=oo`03001oogoo00eoo`0057oo05T007ooOomP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0080001:51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl000T3o`=oo`03001oogoo00eoo`0057oo05/007ooOomT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`02000251l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO008D7`8001d1W`030003o`?o00H3o`=oo`03001oogoo00eoo`0057oo05d007ooOomP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l00P0004PD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00070ol3Ool00`00Oomoo`0=Ool001Aoo`1R001oogooI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`00
51lH7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O00007@6O00<000?o0ol010?o0goo00<007ooOol03Goo000DOol0
H000Oomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`80001761lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000050ol2Ool2000?Ool001Aoo`1R
001oogooI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7`8000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O00007@6O00<000?o0ol00P?o0goo00<0
07ooOol03Goo000DOol0I000Oomoof0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0P0002HH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0P00
01`1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`80
0083o`=oo`03001oogoo00eoo`0057oo06H007ooOomT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l200000a@O61lD
7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00<H7`000Il0706O00<000?oOol00Woo00<007ooOol03Goo000DOol00`00Oomoo`0B
0000Df0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l00P0004@H7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`000goo00<007ooOol03Goo000DOol00`00Oomoo`0BO1890000CV0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO0001W`0L0Il01000Oomoo`003goo000D
Ool00`00Oomoo`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1840000BF@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0080001151lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0001W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`03Ool00`00Oomo
o`0=Ool001Aoo`03001oogoo01ml4P@00017H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`02000251l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00<H7`0000006P6O0goo00<007ooOol03Goo000DOol01@00Oomoog`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO1840000AF@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7`020000?A@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o009oo`8000moo`0057oo00<007ooOol09g`B100004IP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7`0051lH7`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0761lD7a@O51lH7a@O0000606O0goo00<007ooOol03Goo000DOol00`00Oomoo`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P@0001TI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l200005P6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0goo00<007ooOol03Goo000DOol00`00Oomoo`0_
O1850000?f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7`0051lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00Q@O00<0006O0Il04`6O0goo00<007ooOol03Goo000DOol01@00Oomo
og`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00W`B0`0003YT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`80000h61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`=oo`03001oogoo00eoo`00
57oo00<007ooOol0=g`B0P0003YP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7`8000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0251l00`000Il1W`0A0Il3Ool00`00Oomoo`0=Ool001Aoo`03
001oogoo00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P06O1=l4W`BO19l4g`B
0`0006mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0
01@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00goo00<007ooOol0
3Goo0002Ool20004Ool20004Ool20004Ool00`00Oomoo`0lO1830000=f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0080008D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251l2000@0Il3Ool00`00Oomo
o`0=Ool00005Ool007ooOol00008Ool01000Oomoo`000goo00D007ooOoml4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO18000020000=V0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`80000a51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00goo00<007ooOol03Goo0003Ool00`00Oomoo`0:
Ool01000Oomoogoo0P0000=oog`BO180@7`B0`0003QP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O000D7aPO0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7`0000h1W`9oo`8000moo`0017oo00<007ooOol01goo0P00
17oo00<007ooOol00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO18000020000Hf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`03Ool0
0`00Oomoo`0=Ool00005Ool007ooOol00009Ool00`00Oomoo`03Ool00`00Oomoo`18O1830000<F0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0080000561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00`000Il1W`0:0Il3Ool0
0`00Oomoo`0=Ool0009oo`8000Yoo`<000=oo`05001oogooO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P06O1=l4W`B
O19l4g`B0P0005iT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`000Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`=oo`03001oogoo00eoo`0057oo00<007ooOol0CG`B0P00039P7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l001PO0a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7`0000X1W`=oo`03001oogoo00eoo`00
57oo00<007ooOol00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Al4g`BO19l4P80000_I1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`020000:A@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`6O0Gl00goo
00<007ooOol03Goo000DOol00`00Oomoo`1AO1820000<60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1l000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51l000080Il3Ool00`00Oomoo`0=Ool001Aoo`05001oogooO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801W`CO19l4W`BO1=l4P80001FI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O0001O`6O0Gl1W`5o0Il1O`=oo`03001oogoo00eoo`0057oo00<007ooOol0EG`B
030006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O00001P6O0goo00<007ooOol03Goo
000DOol00`00Oomoo`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l
4g`BO1800P0005=P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0001O`6O0Gl1W`5o009o
o`8000moo`0057oo00<007ooOol0F7`B0P0002eT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O0000
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD
7`8000<1W`=oo`03001oogoo00eoo`0057oo00D007ooOoml4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00P0002]P7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7`0200008QPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO0001W`5o0goo00<007ooOol03Goo000DOol00`00Oomoo`1LO1820000;6@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01aPO51lD7a@O61l0006O00=oo`03001oogoo00eoo`0057oo00<007oo
Ool00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1800g`CO19l4P020000Bf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l00003Ool00`00Oomoo`0=
Ool001Aoo`03001oogoo061l4P80000YI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0200000a@O61lD7`02
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO001oogoo
00003goo000DOol01@00Oomoog`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O180CW`CO19l4W`BO1<006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7`=oo`03001oogoo00eoo`0057oo00<007ooOol0Hg`B0P0002aP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
000D7aPO0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00Q@O0goo
00<007ooOol03Goo000DOol00`00Oomoo`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180;7`CO1800000I1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l200006QPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51l2Ool2000?Ool001Aoo`03001oogoo00T005il4P80000ZH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1l001PO0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00goo00<0
07ooOol03Goo000DOol00`00Oomoo`09O0090003O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00Al4g`BO19l4P800010I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l3Ool00`00Oomoo`0=Ool001Aoo`03001o
ogoo019l00X004ml4P0Z001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO0a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l00aPO51lD7`03Ool00`00Oomoo`0=Ool001Aoo`03001oogoo01al00H00003
O19l4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C0080000mH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l00goo00<007ooOol03Goo000DOol0
0`00Oomoo`0RO0050017O180:@00H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APOOomoogoo00003goo000DOol00`00Oomoo`0WO0040002O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P0XO1=l4P00001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l2000051PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51l3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo02]l00@0049l4P0X001T7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7`0061l351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7`=oo`03001oogoo00eo
o`0057oo00<007ooOol0;g`0100000El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`02O1820000=f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0061lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O00=oo`03001oogoo00eoo`0057oo00<007ooOol0<g`00`00
?W`B02L0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`0061l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`02Ool2
000?Ool001Aoo`03001oogoo03Il00<00005O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O18017`CO19l4W`B0P0003AT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7`=oo`03001oogoo00eoo`0057oo00<007ooOol0>G`00`00>g`B02@006@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1l2000351l01APO51lD7a@O61l00a@O00<H7a@O51l00goo00<007ooOol03Goo000DOol0
0`00Oomoo`0lO00300001G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B03Al4`00001P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`=oo`03001o
ogoo00eoo`0057oo00<007ooOol0?g`00`00>7`B02@0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l2000251l01APO51lD7a@O
61l00a@O00DH7gooOomoo`0000moo`0057oo00<007ooOol0@W`00P0000=l4W`CO1800W`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B039l4g`B001P7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D7aPO51lH7a@O
61lD7aPO51lH7a@O0goo00<007ooOol03Goo000DOol00`00Oomoo`14O002000fO18200008f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0O00000a@O00DH7a@O51lD7aPO008D7`=oo`03001oogoo00eoo`0057oo00<007ooOol0AW`00P00
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B031l4g`BO18006@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000D
7aPO51lH7a@O61lD7aPO51l3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo04Ql008003El4P0T001T
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7`000a@O00DH7a@O51lD7aPO009oo`8000moo`0057oo00<007ooOol0BW`00P0000=l4W`C
O1800W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00W`B0P0002UP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l001@O61lD
7aPO51lH7a@O00=oo`03001oogoo00eoo`0057oo00<007ooOol0C7`00P00=7`B0280060OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`80
008D7`0361lD7a@O00=oo`03001oogoo00eoo`0057oo00<007ooOol0CW`00P000g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B02P0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O000H7a@O61lD7`=oo`03001oogoo
00eoo`0057oo00<007ooOol0D7`00P00<W`B0P00029T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0008D7`0561moogooOol0000?Ool0
01Aoo`03001oogoo059l00800003O19l4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B02Yl4g`BO19l
4W`C001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1l001PO51l3Ool00`00Oomoo`0=Ool001Aoo`03001oogoo05Al0080035l4P0T001T
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1l001@O0goo00<007ooOol03Goo000?Ool30002Ool00`00Oomoo`1FO0020003O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P0XO1=l4W`BO19l4`00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O0003Ool00`00Oomoo`0=Ool0011oo`05001o
ogooOol00002OomHO002000_O1808`00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O00000Woo00<007ooOol03Goo000=Ool50002Ool2
00000gooO01l001HO00200000g`BO1=l4P02O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P0RO1<006@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l2
Ool2000?Ool000eoo`04001oogoo0003Ool00`00Oomoo`2^Ool00`00Oomoo`0=Ool000ioo`03001o
o`0000=oo`04001oogoo0008Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Oomoo`06Ool01000Oomoo`003goo000?Ool20003Oonb000?Ool00=Eoo`00eGoo003EOol00=Eoo`00
eGoo003EOol00=Eoo`00eGoo003EOol001=oo`800<1oo`004Woo00@007ooOol00;moo`004Woo00<0
07ooOol0`7oo000AOol5002oOol0019oo`03001oogoo0<1oo`00eGoo003EOol00=Eoo`00eGoo003E
Ool00=Eoo`00eGoo0000\
\>"],
  ImageRangeCache->{{{0, 212}, {212, 0}} -> {-0.277122, 1.80498, 0.0117284, \
0.0117284}}]
}, Open  ]],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"KdVEquation.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{676, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->287,
PrintingPageRange->{2, 2},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageFooters->{{Inherited, None, Inherited}, {Inherited, None, Inherited}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Working examples"->{
    Cell[1739, 51, 349, 5, 43, "Section",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 47}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Working examples"]},
  "solve physical and mathematical problems"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "diffusion equation"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}],
    Cell[3407, 87, 1335, 23, 163, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}]},
  "thermal oscillations"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "single flux line in a superconductor"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "hydrodynamics"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "first atomic explosion"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "symmetry analysis"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}],
    Cell[23090, 615, 1871, 38, 218, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}],
    Cell[210746, 5663, 284, 8, 46, "Text",
      CellTags->"symmetry analysis"]},
  "formation of droplets"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "industrial applications"->{
    Cell[2091, 58, 1200, 22, 129, "Text",
      CellTags->{
      "solve physical and mathematical problems", "diffusion equation", 
        "thermal oscillations", "single flux line in a superconductor", 
        "hydrodynamics", "first atomic explosion", "symmetry analysis", 
        "formation of droplets", "industrial applications"}]},
  "The diffusion equation"->{
    Cell[3316, 84, 88, 1, 41, "Subsection",
      CellTags->"The diffusion equation"]},
  "derive the symmetries"->{
    Cell[3407, 87, 1335, 23, 163, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}]},
  "boundary value problem"->{
    Cell[3407, 87, 1335, 23, 163, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}],
    Cell[31620, 837, 395, 6, 61, "Text",
      CellTags->"boundary value problem"]},
  "seasonal oscillations of the temperature"->{
    Cell[3407, 87, 1335, 23, 163, "Text",
      CellTags->{
      "diffusion equation", "derive the symmetries", "boundary value problem",
         "seasonal oscillations of the temperature"}]},
  "The earthworm's New Year problem"->{
    Cell[4779, 115, 136, 2, 41, "Subsection",
      CellTags->"The earthworm's New Year problem"]},
  "damped temperature waves"->{
    Cell[4918, 119, 815, 14, 112, "Text",
      CellTags->{"damped temperature waves", "New Year problem"}]},
  "New Year problem"->{
    Cell[4918, 119, 815, 14, 112, "Text",
      CellTags->{"damped temperature waves", "New Year problem"}]},
  "temperature variation"->{
    Cell[5789, 138, 413, 12, 44, "Text",
      CellTags->"temperature variation"],
    Cell[40463, 1178, 951, 27, 79, "Text",
      CellTags->"temperature variation"],
    Cell[153795, 3906, 587, 9, 95, "Text",
      CellTags->{"temperature variation", "contour plot"}]},
  "temperature on the surface"->{
    Cell[23090, 615, 1871, 38, 218, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}]},
  "radiation changes"->{
    Cell[23090, 615, 1871, 38, 218, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}]},
  "LieEquations[]"->{
    Cell[23090, 615, 1871, 38, 218, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}],
    Cell[26621, 692, 344, 9, 48, "Text",
      CellTags->"LieEquations[]"]},
  "LieSolve[]"->{
    Cell[23090, 615, 1871, 38, 218, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}],
    Cell[27756, 728, 1408, 27, 169, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}],
    Cell[209256, 5616, 1014, 30, 84, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}],
    Cell[211850, 5705, 1037, 26, 97, "Text",
      CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],
    Cell[212890, 5733, 931, 21, 120, "Text",
      CellTags->{"LieSolve[]", "FinalResult"}]},
  "boundary values"->{
    Cell[23090, 615, 1871, 38, 218, "Text",
      CellTags->{
      "temperature on the surface", "radiation changes", "LieEquations[]", 
        "LieSolve[]", "symmetry analysis", "boundary values"}]},
  "automatic symmetry analysis"->{
    Cell[25039, 659, 1248, 24, 152, "Text",
      CellTags->{
      "automatic symmetry analysis", "pencil and paper", 
        "equation parameters"}]},
  "pencil and paper"->{
    Cell[25039, 659, 1248, 24, 152, "Text",
      CellTags->{
      "automatic symmetry analysis", "pencil and paper", 
        "equation parameters"}]},
  "equation parameters"->{
    Cell[25039, 659, 1248, 24, 152, "Text",
      CellTags->{
      "automatic symmetry analysis", "pencil and paper", 
        "equation parameters"}]},
  "prolongation formalism"->{
    Cell[27756, 728, 1408, 27, 169, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "invariance condition"->{
    Cell[27756, 728, 1408, 27, 169, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "system of determining equations"->{
    Cell[27756, 728, 1408, 27, 169, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "general canonical form"->{
    Cell[27756, 728, 1408, 27, 169, "Text",
      CellTags->{
      "LieSolve[]", "prolongation formalism", "invariance condition", 
        "system of determining equations", "general canonical form"}]},
  "infinite-dimensional Lie group"->{
    Cell[31137, 821, 390, 9, 44, "Text",
      CellTags->{
      "infinite-dimensional Lie group", "discrete subgroup", 
        "similarity solution"}]},
  "discrete subgroup"->{
    Cell[31137, 821, 390, 9, 44, "Text",
      CellTags->{
      "infinite-dimensional Lie group", "discrete subgroup", 
        "similarity solution"}]},
  "similarity solution"->{
    Cell[31137, 821, 390, 9, 44, "Text",
      CellTags->{
      "infinite-dimensional Lie group", "discrete subgroup", 
        "similarity solution"}],
    Cell[36694, 1031, 134, 4, 27, "Text",
      CellTags->"similarity solution"],
    Cell[232340, 6326, 178, 5, 27, "Text",
      Evaluatable->False,
      CellTags->"similarity solution"]},
  "invariance of the boundary conditions"->{
    Cell[32493, 867, 406, 10, 44, "Text",
      CellTags->{
      "invariance of the boundary conditions", "infinitesimals"}]},
  "infinitesimals"->{
    Cell[32493, 867, 406, 10, 44, "Text",
      CellTags->{"invariance of the boundary conditions", "infinitesimals"}],
    Cell[34799, 961, 147, 4, 27, "Text",
      CellTags->"infinitesimals"],
    Cell[209256, 5616, 1014, 30, 84, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}],
    Cell[211850, 5705, 1037, 26, 97, "Text",
      CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],
    Cell[224767, 6097, 532, 14, 65, "Text",
      CellTags->{"symbolic names", "Result2", "infinitesimals"}],
    Cell[226435, 6147, 228, 5, 44, "Text",
      CellTags->"infinitesimals"]},
  "group constants"->{
    Cell[34399, 945, 149, 4, 27, "Text",
      CellTags->"group constants"]},
  "LieRedunction[]"->{
    Cell[35205, 978, 247, 6, 46, "Text",
      Evaluatable->False,
      CellTags->"LieRedunction[]"]},
  "similarity form"->{
    Cell[36250, 1012, 187, 6, 27, "Text",
      CellTags->"similarity form"]},
  "LieReduction[]"->{
    Cell[37332, 1056, 240, 6, 48, "Text",
      CellTags->"LieReduction[]"]},
  "contour plot"->{
    Cell[153795, 3906, 587, 9, 95, "Text",
      CellTags->{"temperature variation", "contour plot"}]},
  "symmetries of PDEs"->{
    Cell[204428, 5458, 307, 8, 44, "Text",
      Evaluatable->False,
      CellTags->"symmetries of PDEs"]},
  "Single Flux Line in Superconductors"->{
    Cell[204784, 5472, 114, 1, 41, "Subsection",
      CellTags->"Single Flux Line in Superconductors"]},
  "single flux line in superconductors"->{
    Cell[204901, 5475, 775, 14, 95, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "low temperature dynamics"->{
    Cell[204901, 5475, 775, 14, 95, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "type-II superconductor"->{
    Cell[204901, 5475, 775, 14, 95, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "Lorentz force"->{
    Cell[204901, 5475, 775, 14, 95, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "depinning threshold"->{
    Cell[204901, 5475, 775, 14, 95, "Text",
      CellTags->{
      "single flux line in superconductors", "low temperature dynamics", 
        "type-II superconductor", "Lorentz force", "depinning threshold"}]},
  "flux line"->{
    Cell[206297, 5514, 939, 21, 114, "Text",
      CellTags->{"flux line", "Lie[]"}]},
  "Lie[]"->{
    Cell[206297, 5514, 939, 21, 114, "Text",
      CellTags->{"flux line", "Lie[]"}],
    Cell[209256, 5616, 1014, 30, 84, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "parameters of the equation"->{
    Cell[207561, 5557, 115, 1, 27, "Text",
      CellTags->"parameters of the equation"]},
  "Ginzburg-Landau"->{
    Cell[207805, 5569, 607, 16, 61, "Text",
      CellTags->{
      "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}]},
  "damping coefficient"->{
    Cell[207805, 5569, 607, 16, 61, "Text",
      CellTags->{
      "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}]},
  "Bardeen-Stephen model"->{
    Cell[207805, 5569, 607, 16, 61, "Text",
      CellTags->{
      "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}]},
  "LieEquation[]"->{
    Cell[209256, 5616, 1014, 30, 84, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "determining equation"->{
    Cell[209256, 5616, 1014, 30, 84, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "LieStructureForm[]"->{
    Cell[209256, 5616, 1014, 30, 84, "Text",
      CellTags->{
      "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
        "LieSolve[]", "LieStructureForm[]"}]},
  "data basis"->{
    Cell[210428, 5652, 247, 5, 44, "Text",
      CellTags->{"data basis", "determination of the symmetries"}]},
  "determination of the symmetries"->{
    Cell[210428, 5652, 247, 5, 44, "Text",
      CellTags->{"data basis", "determination of the symmetries"}]},
  "finite point group"->{
    Cell[211850, 5705, 1037, 26, 97, "Text",
      CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}]},
  "FinalResult"->{
    Cell[212890, 5733, 931, 21, 120, "Text",
      CellTags->{"LieSolve[]", "FinalResult"}]},
  "symbolic names"->{
    Cell[224767, 6097, 532, 14, 65, "Text",
      CellTags->{"symbolic names", "Result2", "infinitesimals"}]},
  "Result2"->{
    Cell[224767, 6097, 532, 14, 65, "Text",
      CellTags->{"symbolic names", "Result2", "infinitesimals"}]},
  "remaining equations"->{
    Cell[225604, 6125, 828, 20, 101, "Text",
      CellTags->{"remaining equations", "PDESolve[]"}]},
  "PDESolve[]"->{
    Cell[225604, 6125, 828, 20, 101, "Text",
      CellTags->{"remaining equations", "PDESolve[]"}]},
  "moving wave solution"->{
    Cell[227081, 6168, 245, 5, 44, "Text",
      Evaluatable->False,
      CellTags->"moving wave solution"]},
  "solution of Tang's equation"->{
    Cell[230397, 6258, 347, 10, 44, "Text",
      Evaluatable->False,
      CellTags->"solution of Tang's equation"],
    Cell[736077, 38453, 326, 10, 44, "Text",
      Evaluatable->False,
      CellTags->"solution of Tang's equation"]},
  "similarity representation"->{
    Cell[232762, 6344, 332, 9, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "similarity representation", 
        "implicit representation of the solution"}]},
  "implicit representation of the solution"->{
    Cell[232762, 6344, 332, 9, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "similarity representation", 
        "implicit representation of the solution"}]},
  "circle"->{
    Cell[233354, 6367, 1706, 55, 114, "Text",
      Evaluatable->False,
      CellTags->{"circle", "animation"}]},
  "animation"->{
    Cell[233354, 6367, 1706, 55, 114, "Text",
      Evaluatable->False,
      CellTags->{"circle", "animation"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Working examples", 809446, 40068},
  {"solve physical and mathematical problems", 809814, 40075},
  {"diffusion equation", 810182, 40082},
  {"thermal oscillations", 810746, 40093},
  {"single flux line in a superconductor", 811132, 40100},
  {"hydrodynamics", 811495, 40107},
  {"first atomic explosion", 811867, 40114},
  {"symmetry analysis", 812234, 40121},
  {"formation of droplets", 812888, 40134},
  {"industrial applications", 813261, 40141},
  {"The diffusion equation", 813633, 40148},
  {"derive the symmetries", 813750, 40151},
  {"boundary value problem", 813975, 40156},
  {"seasonal oscillations of the temperature", 814302, 40163},
  {"The earthworm's New Year problem", 814537, 40168},
  {"damped temperature waves", 814669, 40171},
  {"New Year problem", 814803, 40174},
  {"temperature variation", 814942, 40177},
  {"temperature on the surface", 815248, 40184},
  {"radiation changes", 815476, 40189},
  {"LieEquations[]", 815701, 40194},
  {"LieSolve[]", 815998, 40201},
  {"boundary values", 816823, 40218},
  {"automatic symmetry analysis", 817061, 40223},
  {"pencil and paper", 817239, 40228},
  {"equation parameters", 817420, 40233},
  {"prolongation formalism", 817604, 40238},
  {"invariance condition", 817837, 40243},
  {"system of determining equations", 818081, 40248},
  {"general canonical form", 818316, 40253},
  {"infinite-dimensional Lie group", 818559, 40258},
  {"discrete subgroup", 818739, 40263},
  {"similarity solution", 818921, 40268},
  {"invariance of the boundary conditions", 819312, 40278},
  {"infinitesimals", 819462, 40282},
  {"group constants", 820172, 40297},
  {"LieRedunction[]", 820273, 40300},
  {"similarity form", 820400, 40304},
  {"LieReduction[]", 820501, 40307},
  {"contour plot", 820599, 40310},
  {"symmetries of PDEs", 820729, 40313},
  {"Single Flux Line in Superconductors", 820881, 40317},
  {"single flux line in superconductors", 821030, 40320},
  {"low temperature dynamics", 821275, 40325},
  {"type-II superconductor", 821518, 40330},
  {"Lorentz force", 821752, 40335},
  {"depinning threshold", 821992, 40340},
  {"flux line", 822222, 40345},
  {"Lie[]", 822322, 40348},
  {"parameters of the equation", 822627, 40355},
  {"Ginzburg-Landau", 822741, 40358},
  {"damping coefficient", 822906, 40362},
  {"Bardeen-Stephen model", 823073, 40366},
  {"LieEquation[]", 823232, 40370},
  {"determining equation", 823445, 40375},
  {"LieStructureForm[]", 823656, 40380},
  {"data basis", 823859, 40385},
  {"determination of the symmetries", 824010, 40388},
  {"finite point group", 824148, 40391},
  {"FinalResult", 824286, 40394},
  {"symbolic names", 824402, 40397},
  {"Result2", 824528, 40400},
  {"remaining equations", 824666, 40403},
  {"PDESolve[]", 824786, 40406},
  {"moving wave solution", 824916, 40409},
  {"solution of Tang's equation", 825062, 40413},
  {"similarity representation", 825333, 40420},
  {"implicit representation of the solution", 825557, 40426},
  {"circle", 825748, 40432},
  {"animation", 825880, 40436}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 349, 5, 43, "Section",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 47}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Working examples"],
Cell[2091, 58, 1200, 22, 129, "Text",
  CellTags->{
  "solve physical and mathematical problems", "diffusion equation", 
    "thermal oscillations", "single flux line in a superconductor", 
    "hydrodynamics", "first atomic explosion", "symmetry analysis", 
    "formation of droplets", "industrial applications"}],

Cell[CellGroupData[{
Cell[3316, 84, 88, 1, 41, "Subsection",
  CellTags->"The diffusion equation"],
Cell[3407, 87, 1335, 23, 163, "Text",
  CellTags->{
  "diffusion equation", "derive the symmetries", "boundary value problem", 
    "seasonal oscillations of the temperature"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4779, 115, 136, 2, 41, "Subsection",
  CellTags->"The earthworm's New Year problem"],
Cell[4918, 119, 815, 14, 112, "Text",
  CellTags->{"damped temperature waves", "New Year problem"}],
Cell[5736, 135, 50, 1, 23, "Input"],
Cell[5789, 138, 413, 12, 44, "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{
Cell[6227, 154, 109, 2, 23, "Input"],
Cell[6339, 158, 242, 8, 23, "Output"]
}, Open  ]],
Cell[6596, 169, 160, 4, 27, "Text"],
Cell[6759, 175, 16328, 438, 162, 7461, 323, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False],
Cell[23090, 615, 1871, 38, 218, "Text",
  CellTags->{
  "temperature on the surface", "radiation changes", "LieEquations[]", 
    "LieSolve[]", "symmetry analysis", "boundary values"}],

Cell[CellGroupData[{
Cell[24986, 657, 50, 0, 31, "Subsubsection"],
Cell[25039, 659, 1248, 24, 152, "Text",
  CellTags->{
  "automatic symmetry analysis", "pencil and paper", "equation parameters"}],
Cell[26290, 685, 328, 5, 87, "Input"],
Cell[26621, 692, 344, 9, 48, "Text",
  CellTags->"LieEquations[]"],

Cell[CellGroupData[{
Cell[26990, 705, 57, 1, 23, "Input"],
Cell[27050, 708, 691, 17, 173, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[27756, 728, 1408, 27, 169, "Text",
  CellTags->{
  "LieSolve[]", "prolongation formalism", "invariance condition", 
    "system of determining equations", "general canonical form"}],

Cell[CellGroupData[{
Cell[29189, 759, 89, 2, 23, "Input"],
Cell[29281, 763, 1841, 55, 74, "Output"]
}, Open  ]],
Cell[31137, 821, 390, 9, 44, "Text",
  CellTags->{
  "infinite-dimensional Lie group", "discrete subgroup", 
    "similarity solution"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[31564, 835, 53, 0, 31, "Subsubsection"],
Cell[31620, 837, 395, 6, 61, "Text",
  CellTags->"boundary value problem"],

Cell[CellGroupData[{
Cell[32040, 847, 74, 1, 23, "Input"],
Cell[32117, 850, 72, 1, 23, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32226, 856, 60, 1, 23, "Input"],
Cell[32289, 859, 189, 5, 23, "Output"]
}, Open  ]],
Cell[32493, 867, 406, 10, 44, "Text",
  CellTags->{"invariance of the boundary conditions", "infinitesimals"}],

Cell[CellGroupData[{
Cell[32924, 881, 116, 2, 23, "Input"],
Cell[33043, 885, 52, 1, 23, "Output"]
}, Open  ]],
Cell[33110, 889, 299, 11, 44, "Text"],

Cell[CellGroupData[{
Cell[33434, 904, 68, 1, 23, "Input"],
Cell[33505, 907, 62, 1, 23, "Output"]
}, Open  ]],
Cell[33582, 911, 168, 5, 27, "Text"],

Cell[CellGroupData[{
Cell[33775, 920, 184, 5, 34, "Input"],
Cell[33962, 927, 104, 2, 34, "Output"]
}, Open  ]],
Cell[34081, 932, 47, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[34153, 936, 151, 3, 39, "Input"],
Cell[34307, 941, 77, 1, 23, "Output"]
}, Open  ]],
Cell[34399, 945, 149, 4, 27, "Text",
  CellTags->"group constants"],

Cell[CellGroupData[{
Cell[34573, 953, 83, 1, 23, "Input"],
Cell[34659, 956, 125, 2, 23, "Output"]
}, Open  ]],
Cell[34799, 961, 147, 4, 27, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[34971, 969, 151, 3, 39, "Input"],
Cell[35125, 974, 65, 1, 23, "Output"]
}, Open  ]],
Cell[35205, 978, 247, 6, 46, "Text",
  Evaluatable->False,
  CellTags->"LieRedunction[]"],

Cell[CellGroupData[{
Cell[35477, 988, 296, 6, 39, "Input"],
Cell[35776, 996, 459, 13, 48, "Output"]
}, Open  ]],
Cell[36250, 1012, 187, 6, 27, "Text",
  CellTags->"similarity form"],

Cell[CellGroupData[{
Cell[36462, 1022, 126, 3, 39, "Input"],
Cell[36591, 1027, 88, 1, 23, "Output"]
}, Open  ]],
Cell[36694, 1031, 134, 4, 27, "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[36853, 1039, 197, 4, 36, "Input"],
Cell[37053, 1045, 264, 8, 24, "Output"]
}, Open  ]],
Cell[37332, 1056, 240, 6, 48, "Text",
  CellTags->"LieReduction[]"],

Cell[CellGroupData[{
Cell[37597, 1066, 71, 1, 23, "Input"],
Cell[37671, 1069, 166, 3, 29, "Output"]
}, Open  ]],
Cell[37852, 1075, 333, 10, 44, "Text"],

Cell[CellGroupData[{
Cell[38210, 1089, 172, 4, 55, "Input"],
Cell[38385, 1095, 77, 1, 27, "Output"]
}, Open  ]],
Cell[38477, 1099, 245, 9, 27, "Text"],

Cell[CellGroupData[{
Cell[38747, 1112, 125, 3, 23, "Input"],
Cell[38875, 1117, 75, 1, 26, "Output"]
}, Open  ]],
Cell[38965, 1121, 54, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[39044, 1125, 80, 1, 23, "Input"],
Cell[39127, 1128, 155, 4, 29, "Output"]
}, Open  ]],
Cell[39297, 1135, 63, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[39385, 1139, 218, 4, 55, "Input"],
Cell[39606, 1145, 101, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39744, 1152, 40, 1, 23, "Input"],
Cell[39787, 1155, 109, 2, 28, "Output"]
}, Open  ]],
Cell[39911, 1160, 63, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[39999, 1164, 74, 1, 23, "Input"],
Cell[40076, 1167, 372, 8, 61, "Output"]
}, Open  ]],
Cell[40463, 1178, 951, 27, 79, "Text",
  CellTags->"temperature variation"],

Cell[CellGroupData[{
Cell[41439, 1209, 266, 4, 71, "Input"],
Cell[41708, 1215, 112072, 2688, 182, 76445, 2242, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[153795, 3906, 587, 9, 95, "Text",
  CellTags->{"temperature variation", "contour plot"}],

Cell[CellGroupData[{
Cell[154407, 3919, 257, 4, 71, "Input"],
Cell[154667, 3925, 49746, 1530, 206, 16040, 1109, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[204428, 5458, 307, 8, 44, "Text",
  Evaluatable->False,
  CellTags->"symmetries of PDEs"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[204784, 5472, 114, 1, 41, "Subsection",
  CellTags->"Single Flux Line in Superconductors"],
Cell[204901, 5475, 775, 14, 95, "Text",
  CellTags->{
  "single flux line in superconductors", "low temperature dynamics", 
    "type-II superconductor", "Lorentz force", "depinning threshold"}],

Cell[CellGroupData[{
Cell[205701, 5493, 189, 4, 38, "Input"],
Cell[205893, 5499, 389, 12, 36, "Output"]
}, Open  ]],
Cell[206297, 5514, 939, 21, 114, "Text",
  CellTags->{"flux line", "Lie[]"}],

Cell[CellGroupData[{
Cell[207261, 5539, 62, 1, 23, "Input"],
Cell[207326, 5542, 40, 1, 23, "Output"]
}, Open  ]],
Cell[207381, 5546, 43, 0, 27, "Text"],

Cell[CellGroupData[{
Cell[207449, 5550, 57, 1, 23, "Input"],
Cell[207509, 5553, 37, 1, 23, "Output"]
}, Open  ]],
Cell[207561, 5557, 115, 1, 27, "Text",
  CellTags->"parameters of the equation"],

Cell[CellGroupData[{
Cell[207701, 5562, 49, 1, 23, "Input"],
Cell[207753, 5565, 37, 1, 23, "Output"]
}, Open  ]],
Cell[207805, 5569, 607, 16, 61, "Text",
  CellTags->{
  "Ginzburg-Landau", "damping coefficient", "Bardeen-Stephen model"}],

Cell[CellGroupData[{
Cell[208437, 5589, 84, 1, 23, "Input"],
Cell[208524, 5592, 73, 1, 23, "Output"]
}, Open  ]],
Cell[208612, 5596, 93, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[208730, 5603, 276, 4, 71, "Input"],
Cell[209009, 5609, 232, 4, 53, "Output"]
}, Open  ]],
Cell[209256, 5616, 1014, 30, 84, "Text",
  CellTags->{
  "LieEquation[]", "determining equation", "infinitesimals", "Lie[]", 
    "LieSolve[]", "LieStructureForm[]"}],
Cell[210273, 5648, 152, 2, 55, "Input"],
Cell[210428, 5652, 247, 5, 44, "Text",
  CellTags->{"data basis", "determination of the symmetries"}],

Cell[CellGroupData[{
Cell[210700, 5661, 43, 0, 31, "Subsubsection"],
Cell[210746, 5663, 284, 8, 46, "Text",
  CellTags->"symmetry analysis"],

Cell[CellGroupData[{
Cell[211055, 5675, 65, 1, 23, "Input"],
Cell[211123, 5678, 712, 24, 44, "Output"]
}, Open  ]],
Cell[211850, 5705, 1037, 26, 97, "Text",
  CellTags->{"LieSolve[]", "finite point group", "infinitesimals"}],
Cell[212890, 5733, 931, 21, 120, "Text",
  CellTags->{"LieSolve[]", "FinalResult"}],

Cell[CellGroupData[{
Cell[213846, 5758, 103, 2, 23, "Input"],
Cell[213952, 5762, 10800, 332, 440, "Output"]
}, Open  ]],
Cell[224767, 6097, 532, 14, 65, "Text",
  CellTags->{"symbolic names", "Result2", "infinitesimals"}],

Cell[CellGroupData[{
Cell[225324, 6115, 40, 1, 23, "Input"],
Cell[225367, 6118, 222, 4, 38, "Output"]
}, Open  ]],
Cell[225604, 6125, 828, 20, 101, "Text",
  CellTags->{"remaining equations", "PDESolve[]"}],
Cell[226435, 6147, 228, 5, 44, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[226688, 6156, 328, 6, 39, "Input"],
Cell[227019, 6164, 47, 1, 23, "Output"]
}, Open  ]],
Cell[227081, 6168, 245, 5, 44, "Text",
  Evaluatable->False,
  CellTags->"moving wave solution"],

Cell[CellGroupData[{
Cell[227351, 6177, 251, 5, 39, "Input"],
Cell[227605, 6184, 465, 13, 48, "Output"]
}, Open  ]],
Cell[228085, 6200, 71, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[228181, 6205, 155, 4, 23, "Input"],
Cell[228339, 6211, 2043, 44, 78, "Output"]
}, Open  ]],
Cell[230397, 6258, 347, 10, 44, "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],
Cell[230747, 6270, 170, 6, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[230942, 6280, 342, 6, 55, "Input"],
Cell[231287, 6288, 58, 1, 23, "Output"]
}, Open  ]],
Cell[231360, 6292, 62, 1, 27, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[231447, 6297, 251, 5, 39, "Input"],
Cell[231701, 6304, 624, 19, 60, "Output"]
}, Open  ]],
Cell[232340, 6326, 178, 5, 27, "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[232543, 6335, 133, 3, 23, "Input"],
Cell[232679, 6340, 68, 1, 23, "Output"]
}, Open  ]],
Cell[232762, 6344, 332, 9, 44, "Text",
  Evaluatable->False,
  CellTags->{
  "similarity representation", "implicit representation of the solution"}],

Cell[CellGroupData[{
Cell[233119, 6357, 140, 4, 23, "Input"],
Cell[233262, 6363, 77, 1, 35, "Output"]
}, Open  ]],
Cell[233354, 6367, 1706, 55, 114, "Text",
  Evaluatable->False,
  CellTags->{"circle", "animation"}],
Cell[235063, 6424, 58, 1, 23, "Input"],

Cell[CellGroupData[{
Cell[235146, 6429, 444, 8, 86, "Input"],

Cell[CellGroupData[{
Cell[235615, 6441, 21275, 1299, 203, 9540, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[256893, 7742, 21269, 1299, 203, 9526, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[278165, 9043, 21118, 1297, 203, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[299286, 10342, 25319, 1349, 203, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False],
Cell[324608, 11693, 20859, 1294, 203, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[345470, 12989, 24955, 1345, 203, 9538, 1148, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False],
Cell[370428, 14336, 24658, 1341, 203, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False],
Cell[395089, 15679, 20423, 1289, 203, 9514, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[415515, 16970, 20256, 1287, 203, 9521, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[435774, 18259, 20241, 1287, 203, 9530, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[456018, 19548, 19987, 1284, 203, 9535, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[476008, 20834, 19953, 1283, 203, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[495964, 22119, 19726, 1281, 203, 9513, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[515693, 23402, 19388, 1276, 203, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[535084, 24680, 19525, 1278, 203, 9523, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[554612, 25960, 19499, 1277, 203, 9538, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[574114, 27239, 19087, 1272, 203, 9531, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[593204, 28513, 18936, 1270, 203, 9546, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[612143, 29785, 18769, 1268, 203, 9537, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[630915, 31055, 18677, 1267, 203, 9530, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[649595, 32324, 18258, 1262, 203, 9528, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[667856, 33588, 17942, 1258, 203, 9524, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[685801, 34848, 17613, 1254, 203, 9523, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[703417, 36104, 17181, 1249, 203, 9532, 1148, "GraphicsData", \
"PostScript", "Graphics"],
Cell[720601, 37355, 15449, 1094, 203, 8335, 1000, "GraphicsData", \
"PostScript", "Graphics"]
}, Closed]]
}, Open  ]],
Cell[736077, 38453, 326, 10, 44, "Text",
  Evaluatable->False,
  CellTags->"solution of Tang's equation"],

Cell[CellGroupData[{
Cell[736428, 38467, 123, 3, 23, "Input"],
Cell[736554, 38472, 146, 2, 26, "Output"]
}, Open  ]],
Cell[736715, 38477, 545, 16, 63, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[737285, 38497, 281, 5, 52, "Input"],
Cell[737569, 38504, 69917, 1505, 221, 10852, 771, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[807501, 40012, 151, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

