(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     61055,       1694]*)
(*NotebookOutlinePosition[     80954,       2174]*)
(*  CellTagsIndexPosition[     77941,       2101]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["7", "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True,
  CellTags->"Potential Symmetries of Partial Differential Equations"],

Cell["\<\
Potential Symmetries of Partial
Differential Equations\
\>", "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  "7.",
  CounterBox["Section"],
  ".",
  " Introduction"
}], "Section",
  CounterAssignments->{{"Title", 7}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],

Cell[TextData[{
  "The last two chapters discussed point symmetries and non-classical \
symmetries. These types of symmetry are local symmetries because the \
coordinates are involved in the local transformations in a direct way. This \
chapter discusses a completely different type of symmetry. We not only  \
consider the original PDEs ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " but also derived systems of PDEs whose solutions are solutions of the \
original equations. The new associated system of PDEs is treated by the \
methods discussed in the previous sections. The result of this treatment are \
symmetries not only depending on the local variables of the original equation \
but also on variables of the affiliated system of PDEs. Thus, we get a new \
type of symmetry depending on an extended set of variables. Such symmetries \
are generally called non-local symmetries. A special type of non-local \
symmetry is a potential symmetry. Our interest in this chapter are potential \
symmetries of PDEs."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{
  "point symmetries", "non-classical symmetries", "local symmetries", 
    "local transformation", "derived systems of PDEs", 
    "affiliated system of PDEs", "non-local symmetries", 
    "potential symmetries"}],

Cell["\<\
The following sections discuss how the associated PDEs are \
derivable in a systematic way. For this reason, we need to introduce some new \
terminology. The new terms have the advantage that a generalization to other \
kinds of symmetry are possible.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.",
  CounterBox["Section"],
  ".",
  " Basics of Potential Symmetries"
}], "Section",
  CellTags->"Basics of Potential Symmetries"],

Cell[TextData[{
  "In C",
  ButtonBox["hapter 6,",
    ButtonData:>{"symmet6.nb", "Non-classical method"},
    ButtonStyle->"Hyperlink"],
  " we distinguished weak and strong symmetries. If we have a strong \
symmetry, solutions of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " are transformed into solutions of this equation, and a reduction of the \
original PDEs are possible. In case of weak symmetries, only a reduction is \
possible. Based on strong symmetries, we can generalize the meaning of a \
symmetry."
}], "Text",
  CellTags->{"weak symmetries", "strong symmetries", "reduction"}],

Cell["Definition: Topological symmetry", "Definition",
  CellTags->"Definition: Topological Symmetry"],

Cell[TextData[{
  "A symmetry of a system of PDEs \[CapitalDelta] = 0 is a transformation \
which transforms solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " into other solutions of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  ".\[ThickSpace]\[EmptyCircle]"
}], "Text"],

Cell["\<\
The symmetry of the PDE given above is of a topological nature \
because it is completely free of any coordinates. We see that a symmetry \
primarily is not connected to a system of coordinates. However, if we need to \
carry out practical calculations, we have to consider the coordinates of the \
problem.\
\>", "Text",
  CellTags->"topological"],

Cell["\<\
The classical symmetries of a PDE are point transformations which \
guarantee the invariance of the solution space. These kinds of symmetry are \
point symmetries as we know them. Point symmetries are created by \
infinitesimal transformations\
\>", "Text",
  CellTags->{
  "classical symmetries", "point transformations", 
    "infinitesimal transformation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(x\_i\%\[Prime]\  = \ 
      x\_i\  + \ \[Epsilon]\ \(\(\[Xi]\_i\)(x, u)\)\  + \ O(\[Epsilon]\^2)\ , 
    \ \ \ \ \ \ i = 1, 2, \[Ellipsis], p, \ \)\)], "NumberedEquation",
  CellTags->"eq-7"],

Cell[BoxData[
    \(TraditionalForm
    \`u\^\[Prime]\[Alpha]\  = \ 
      u\^\[Alpha]\  + \ \[Epsilon]\ \(\(\[Phi]\_\[Alpha]\)(x, u)\)\  + \ 
        O(\[Epsilon]\^2)\ , \ \ \ \ \ \[Alpha] = 1, 2, \[Ellipsis], 
    \(q . \)\)], "NumberedEquation",
  CellTags->"eq-8"],

Cell[TextData[{
  "The vector field of the infinitesimal transformation is not uniquely \
defined. Contrary to C",
  ButtonBox["hapter 5,",
    ButtonData:>{"symmet5.nb", 
      "Point Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]],
  "we can represent the vector field by"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(v\&\[RightVector]\), " ", "=", " ", 
        RowBox[{
          StyleBox[\(\[Sum]\+\(\[Alpha] = 1\)\%q\),
            ScriptLevel->0], 
          \(\(\(\[Eta]\_\[Alpha]\)(x, u, u\_\((1)\))\)\ 
            \[PartialD]\_\(u\^\[Alpha]\) . \)}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "The infinitesimal components \[Eta] of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " are given by"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(\[Eta]\_\[Alpha]\  = \ 
          \(\[Phi]\_\[Alpha]\)(x, u)\  - \ 
            \[Sum]\+\(i = 1\)\%p\(\( \[Xi]\_i\)(x, u)\)\ u\_i\%\[Alpha]\), 
        " ", ",", "     ", 
        FormBox[\(\ \[Alpha] = 1, 2, \[Ellipsis], q\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "which are equivalent to the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\)]],
  " introduced in C",
  ButtonBox["hapter 6",
    ButtonData:>{"symmet6.nb", "Non-classical method"},
    ButtonStyle->"Hyperlink"],
  " in connection with non-classical symmetries. Based on the \
characteristics, the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th prolongation of the vector field simplifies to"
}], "Text",
  CellTags->{
  "characteristics", "non-classical symmetries", "prolongation", 
    "vector field"}],

Cell[BoxData[
    \(TraditionalForm\`pr\^\((k)\)\ v\&\[RightVector]\ \  = \ 
      v\&\[RightVector]\  + \ \[Sum]\+\(\[Alpha] = 1\)\[NegativeThinSpace]\(\
\[Sum]\+J\((\(D\_J\) \[Eta]\_\[Alpha])\)\ \[PartialD]\_\(u\_J\%\[Alpha]\) . \
\)\)], "NumberedEquation"],

Cell[TextData[{
  "We call a transformation local if the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`\[Eta]\_\[Alpha]\)]],
  " depend on derivatives of the dependent variables. The invariance \
condition from which solutions for the characteristics follow is given by"
}], "Text",
  CellTags->"invariance condition"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\(\[GothicCapitalD]\_\[CapitalDelta]\)(\[Eta])\) |
        \_\(\[CapitalDelta] = 0\)\ \( = 0\), \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\)]],
  " denotes the ",
  ButtonBox["Fr\[EAcute]chet derivative.",
    ButtonData:>{"derivat.nb", "The Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  " Relation (7.6) is nothing more than the ",
  ButtonBox["invariance condition",
    ButtonData:>{"symmet5.nb", "Invariance condition for point symmetry"},
    ButtonStyle->"Hyperlink"],
  " discussed in C",
  ButtonBox["hapter 5",
    ButtonData:>{"symmet5.nb", "Invariance Based on Frechet Derivatives"},
    ButtonStyle->"Hyperlink"],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]],
  "for point symmetries. We note that this type of invariance condition does \
not change if the characteristics depend on higher derivatives. This \
situation occurs if we consider generalized symmetries. In C",
  ButtonBox["hapter 9,",
    ButtonData:>{"Symmet75.nb", 
      "Generalized Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " we will discuss this type of symmetry. The Fr\[EAcute]chet derivative, on \
the other hand, is the basic tool for the systematic calculation of potential \
symmetries. How we access the potential symmetry will be discussed next."
}], "Text",
  CellTags->{
  "Fr\[EAcute]chet derivative", "point symmetries", "generalized symmetries", 
    "potential symmetries"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.",
  CounterBox["Section"],
  ".",
  " Calculation of Potential Symmetries"
}], "Section",
  CellTags->"Calculation of Potential Symmetries"],

Cell[TextData[{
  "When describing non-local symmetries, it is convenient to introduce new \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`v(x)\)]],
  " by additional equations which are connected with the original equations \
in the variables ",
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  ". One condition on the new system of PDEs is that the original system must \
be derivable from the new. In other words, if ",
  Cell[BoxData[
      \(TraditionalForm\`\((u(x), v(x))\)\)]],
  " satisfy the extended equations, ",
  Cell[BoxData[
      \(TraditionalForm\`u(x)\)]],
  " also has to be a solution of the original system,"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"non-local symmetries", "extended equations"}],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \[CapitalDelta](x, u\_\((k)\))\  = \ 0. \)\)], "NumberedEquation"],

Cell[TextData[{
  "An auxiliary system with new variables can be introduced if at least one \
PDE, say ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_m = 0\)]],
  ", of the system ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " can be written as a conservation law (cf. ",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"auxiliary system", "conservation law"}],

Cell[TextData[{
  "Suppose one PDE of the system \[CapitalDelta] = 0, without loss of \
generality ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\[CapitalDelta]\_m\),
            "TraditionalForm"], "=", "0"}], TraditionalForm]]],
  ", can be expressed as a conservation law"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \[Sum]\+\(i = 1\)\%n\( D\_i\) \(\(f\^i\)(x, u\_\((k - 1)\))\)\  = \ 0. 
      \)\)], "NumberedEquation"],

Cell[TextData[{
  "Then, the system ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " can be written in the form"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    FormBox[
      RowBox[{"                             ", 
        RowBox[{
        \(\(\[CapitalDelta]\_\[Nu]\)(x, u\_\((k)\))\  = \ 0\), ",", 
          "          ", 
          FormBox[\(\[Nu] = 1, 2, \[Ellipsis], m - 1\),
            "TraditionalForm"], ","}]}], TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ 
    \[Sum]\+\(i = 1\)\%n\( D\_i\) \(\(f\^i\)(x, u\_\((k - 1)\))\)\  = \ 0. 
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)], "NumberedEquation"],

Cell[TextData[{
  "Relation (7.10) allows us to introduce ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  " new variables ",
  Cell[BoxData[
      \(TraditionalForm\`v = \((v\^1, v\^2, \[Ellipsis], v\^\(n - 1\))\)\)]],
  ". These ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  " variables have to satisfy ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  " equations. In connection with the remaining equations (7.9), they built \
up a new system of equations ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalPsi](x, u\_\((k)\), v\_\((1)\))\  = \ 0\)]],
  ", which is the potential system. Explicitly, we find"
}], "Text",
  CellTags->{"new variables", "potential system"}],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(f\^1\)(x, u\_\((k - 1)\))\  = \ v\_x\_2\%1, 
    \)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{"   ", 
        RowBox[{
        \(\(f\^l\)(x, u\_\((k - 1)\))\  = \ 
            \(\((\(-1\))\)\^\(l - 1\)\) {\ 
                v\_x\_\(l + 1\)\%l + v\_x\_\(l - 1\)\%\(l - 1\)}\), ",", 
          "       ", 
          FormBox[\(1 < l < n\),
            "TraditionalForm"], ","}]}], TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(\(\[CapitalDelta]\_\[Nu]\)(x, u\_\((k)\))\  = \ 0\), ",", 
          "          ", 
          FormBox[\(\[Nu] = 1, 2, \[Ellipsis], m - \(1 . \)\),
            "TraditionalForm"]}], "           "}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "The original system \[CapitalDelta] is closely connected to the potential \
system \[CapitalPsi], meaning that some properties of \[CapitalDelta] are \
still contained in \[CapitalPsi]. One of these properties is that if ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\)\)]],
  " are solutions of \[CapitalPsi] then ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is also a unique solution of \[CapitalDelta]. On the other hand if ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is a solution of \[CapitalDelta] then there exists a ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " so that ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\)\)]],
  " is also a solution of \[CapitalPsi]. However, ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " in this case is not unique. These properties of the solutions are also \
present in the symmetries of both systems. A symmetry of \[CapitalPsi] is \
connected with a symmetry of \[CapitalDelta] and vice versa. The symmetries, \
however, have different meanings for the two systems. For example, a point \
symmetry of \[CapitalPsi] may be a non-local symmetry of \[CapitalDelta]. \
This kind of symmetry is called potential symmetry."
}], "Text",
  CellTags->{"potential system", "point symmetry", "non-local symmetry"}],

Cell["Definition: Potential symmetry", "Definition",
  CellTags->"Definition: Potential symmetry"],

Cell[TextData[
"Let us assume that \[CapitalPsi] is a potential system of \[CapitalDelta]. A \
point symmetry of \[CapitalPsi] given by"], "Text",
  CellTags->"potential system"],

Cell[BoxData[
    \(TraditionalForm\`v\&\[RightVector]\_\[CapitalPsi]\  = \ \[Sum]\+\(\
\[Alpha] = 1\){\(\[Phi]\_\[Alpha]\)(x, u, 
                v)\  - \ \[Sum]\+\(i = 1\)\%p\(\( \[Xi]\_i\)(x, u, 
                    v)\)\ u\_i\%\[Alpha]}\ \[PartialD]\_\(u\^\[Alpha]\)\ \n\ \
\ \ \ \ \ \ \ \ \ \ \ \ \(+\ \[Sum]\+\(\[Beta] = 1\)\%\(n - 1\)\) \((\(\[Chi]\
\_\[Beta]\)(x, u, 
                v)\  - \[Sum]\+\(i = 1\)\%n\(\( \[Xi]\_i\)(x, u, 
                    v)\)\ v\_i\%\[Beta])\)\ \[PartialD]\_\(v\^\[Beta]\)\)], \
"NumberedEquation"],

Cell[TextData[{
  "with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Chi]\_\[Beta]\)]],
  " the infinitesimals of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ", respectively, is a potential symmetry of \[CapitalDelta], if the \
infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " depend on the new variables ",
  Cell[BoxData[
      \(TraditionalForm\`v\^\[Beta]\)]],
  " and are not reducible to a point symmetry of \[CapitalDelta]. \
\[EmptyCircle]"
}], "Text"],

Cell[TextData[{
  "This definition introduces a potential symmetry as a point symmetry of an \
auxiliary system, the potential system. We already know how point symmetries \
of a PDE are determined. In ",
  ButtonBox["Chapter 5,",
    ButtonData:>{"symmet5.nb", 
      "Point Symmetries of Partial Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " we discussed the procedure for different examples. Thus, we face the \
problem of finding the potential system for which we can calculate the point \
symmetries."
}], "Text",
  CellTags->{"potential symmetry", "potential system"}],

Cell[TextData[{
  "The main problem in determining potential symmetries is to find useful \
potential systems \[CapitalPsi]. To express one PDE of the system (7.7), ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalDelta]\_i\  = \ \[Sum]\+\(i = 1\)\%n\( D\_i\) f\^i\)]],
  " in a conserved form is not the only possibility to rewrite a system of \
PDEs. Additionally, a number of PDEs of the system (7.7) can be multiplied by \
integrating factors to become conserved quantities, as ",
  ButtonBox["Bluman [1993]",
    ButtonData:>{"Literat.nb", "Blu-93"},
    ButtonStyle->"Hyperlink"],
  " remarks. There exists a set of integrating multipliers"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"potential system", "integrating multipliers"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\({\(\[Lambda]\^\[Nu]\)(x, u\_\((p)\))\),
          "TraditionalForm"], "}"}], TextForm]], "NumberedEquation"],

Cell["which allows the representation", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Sum]\+\(\[Nu] = 1\)\%m\(\( \[Lambda]\^\[Nu]\)(x, u\_\((p)\))\)\ 
          \(\(\[CapitalDelta]\_\[Nu]\)(x, u\_\((k)\))\)\  = \ 
      \[Sum]\+\(i = 1\)\%n\( D\_i\) \(\(f\^i\)(x, u\_\((k)\)) . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "In replacing the PDE ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\[Nu]\)]],
  " by relation (7.16), we must be cautious. The resulting new system \
\[CapitalPsi] may gain a solution which is not a solution of the original \
system \[CapitalDelta]. However, every solution of \[CapitalDelta] is a \
solution of \[CapitalPsi], but each solution of the system"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"               ", 
        RowBox[{
          RowBox[{\(\[CapitalDelta]\_\[Nu]\), " ", "=", " ", 
            RowBox[{"0", "     ", 
              
              FormBox[\(\[Nu] = \ 1, \[Ellipsis], \[Mu] - 1, \[Mu] + 1, 
                \[Ellipsis], m\),
                "TraditionalForm"]}]}], ","}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[Lambda]\^\[Mu]\)(x, u\_\((p)\))\  = \ 0
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)], 
  "NumberedEquation"],

Cell[TextData[
"satisfies the potential system \[CapitalPsi]. So there may exist solutions \
of \[CapitalPsi] which do not solve the original system. In fact, we have to \
exclude such solutions to prevent trouble in the calculation. So let us \
define the following:"], "Text"],

Cell["Definition: Equivalence of conserved representations", "Definition",
  CellTags->"Definition: Equivalence of conserved representations"],

Cell[TextData[{
  "A set of integrating factors ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Lambda]\^\[Nu]}\)]],
  " creates an equivalent conserved representation of \[CapitalDelta] if for \
a single \[Mu], 1 \[LessEqual] \[Mu] \[LessEqual] ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", the systems \[CapitalDelta] and \[CapitalPsi] allow a common space of \
solutions. Potential symmetries exist only for equivalent conserved \
representations. \[EmptyCircle]"
}], "Text",
  CellTags->{
  "common space of solutions", "equivalent conserved representation"}],

Cell[TextData[
"Experience shows that integrating multipliers \[Lambda] depending on \
derivatives do not create equivalent conserved representations. Thus, we \
restrict our considerations to multipliers depending only on the independent \
and dependent variables"], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        RowBox[{\(\[Lambda] \((x, u)\)\), " ", "=", " ", 
          RowBox[{
            FormBox[
              
              StyleBox[
                \({\(\[Lambda]\^1\)(x, u), \(\[Lambda]\^2\)(x, u), 
                  \[Ellipsis], \(\[Lambda]\^m\)(x, u)}\),
                FontFamily->"Times"],
              "TraditionalForm"], "."}]}],
        FontFamily->"Times"], TextForm]], "NumberedEquation"],

Cell[TextData[{
  "The last step in our theoretical considerations is the determination of \
the integrating multipliers. So we need a formula allowing us the systematic \
determination of the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\^\[Nu]\)]],
  "'s. If we apply the invariance criterion (7.6) to the potential system \
(7.11)\[Dash](7.13) in connection with relation (7.16), we end up with the \
condition"
}], "Text",
  CellTags->{"integrating multiplier", "invariance criterion"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\(\[GothicCapitalD]\_\[CapitalDelta]\%*\)(\[Lambda])\) |
        \_\(\[CapitalDelta] = 0\)\ \( = 0\), \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[GothicCapitalD]\^*\)\)]],
  " denotes the ",
  ButtonBox["adjoint Fr\[EAcute]chet derivative",
    ButtonData:>{"derivat.nb", "adjoint Frechet derivative"},
    ButtonStyle->"Hyperlink"],
  ". The solutions for the \[Lambda]\[CloseCurlyQuote]s follow by calculating \
the invariance condition with the adjoint Fr\[EAcute]chet derivative and \
replacing the characteristics \[Eta] in (7.6) by the integrating multipliers. \
Since ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is able to treat such a system of equations, we have a tool providing the \
solutions."
}], "Text",
  CellTags->{
  "adjoint Fr\[EAcute]chet derivative", "invariance condition", 
    "characteristics"}],

Cell[TextData[
"The solutions of (7.20) may be either a finite set of solutions or a \
continuous set, meaning that for the finite set, a finite number of solutions \
exists, whereas in the continuous case, arbitrary functions occur in the \
integrating multipliers \[Lambda]. Both cases are useful in classifying the \
point symmetries of the related potential system \[CapitalPsi]."], "Text"],

Cell[TextData[
"The theory so far discussed can again be applied to a derived potential \
system \[CapitalPsi]. This recursive application of the procedure delivers a \
tree of the potential system if the integrating multipliers are chosen in an \
appropriate way."], "Text",
  CellTags->"tree of potential system"],

Cell[TextData[{
  "Thus, we are able to construct new solutions by means of the potential \
symmetries. These new solutions are quite different from the solutions \
derived from point symmetries because the non-local properties of the \
equation are the key for this construction. Solution ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\)\)]],
  " of the potential system allows us to find solutions of the original \
system \[CapitalDelta]. These solutions are new solutions, different from the \
solutions derived via the classical or non-classical method of Lie. \
Completely new solutions may be expected if we analyze the potential system \
by means of the non-classical method."
}], "Text",
  CellTags->{
  "point symmetries", "non-local properties", "potential system", 
    "non-classical method"}],

Cell[TextData[{
  "We use the procedure of integrating factors extensively in our package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " to derive the potential systems. The algorithmic procedure to derive \
potential symmetries is summarized in the following four steps:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"integrating factor", "algorithm for potential symmetries"}],

Cell["Determine the integrating multipliers from relation (7.20).", "ListItem",
  CellDingbat->"1.",
  CellTags->"integrating multipliers"],

Cell["\<\
Extract these integrating multipliers which allow an equivalent \
conservation law.\
\>", "ListItem",
  CellDingbat->"2.",
  CellTags->"equivalent conservation law"],

Cell[TextData[
"Create for each integrating factor from step 3 the potential representation \
\[CapitalPsi]."], "ListItem",
  CellDingbat->"3.",
  CellTags->"potential representation"],

Cell["\<\
Examine the potential system either with the classical or the \
non-classical method.\
\>", "ListItem",
  CellDingbat->"4."],

Cell[TextData[{
  "These four steps are the basis of the following examples demonstrating the \
automatic determination of potential symmetries. The calculations are \
supported by the function ",
  StyleBox["PotentialSymmetries[], ", "MmaText"],
  "which is part of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The function ",
  StyleBox["PotentialSymmetries[]", "MmaText"],
  " allows us to derive the possible potential systems and calculate the \
point symmetries of these systems."
}], "Text",
  CellTags->"PotentialSymmetries[]"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.",
  CounterBox["Section"],
  ".",
  " Applications of Potential Symmetries"
}], "Section",
  CellTags->"Applications for Potential Symmetries"],

Cell[TextData[{
  "In the following sections, we apply the theory to several examples. The \
discussed theory allows us to derive new solutions for a scalar PDE as well \
as for systems of PDEs. The program ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " calculates automatically all potential systems and determines the \
corresponding point symmetries of the potential system. The application of \
the non-classical method to potential systems is novel. As we will see, there \
are a lot of problems when non-classical symmetries are used to find \
solutions. "
}], "Text",
  CellTags->{"potential systems", "point symmetries of the potential system"}],

Cell[TextData[{
  "Let us demonstrate some of the possible calculations carried out by ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " in connection with potential symmetries. The following examples \
demonstrate the application of the function ",
  StyleBox["PotentialSymmetries[]", "MmaText"],
  "."
}], "Text",
  CellTags->"PotentialSymmetries[]"],

Cell[CellGroupData[{

Cell["7.4.1 A Non-linear Reaction Diffusion Equation", "Subsection",
  CellTags->{
  "The Diffusion Equation", "A Nonlinear Reaction Diffusion Equation"}],

Cell[TextData[{
  "The first example demonstrated how the potential systems are derived by ",
  StyleBox["MathLie. ",
    FontSlant->"Italic"],
  "We examine a non-linear reaction diffusion equation of the type"
}], "Text",
  CellTags->"nonlinear reaction diffusion equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(reaktionDiffusion\  = \ 
      \[PartialD]\_t u[x, t]\  + \ 
          \[PartialD]\_\(x, x\)\((1\/u[x, t] + \ \[Beta]\ x\^2)\) == 0; 
    reaktionDiffusion // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(2\ \[Beta]\), "+", \(u\_t\), "+", 
                StyleBox[\(\(2\ u\_x\%2\)\/u\^3\),
                  ScriptLevel->0], "-", 
                StyleBox[\(u\_\(x, x\)\/u\^2\),
                  ScriptLevel->0]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where \[Beta] is a real constant. Our primary interest is to detect a \
potential representation of the equation. The function ",
  StyleBox["PotentialSymmetries[]", "MmaText"],
  " in connection with the option ",
  StyleBox["PotentialSystemsOnly\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "allows us to derive these systems. The function needs the equation, the \
dependent and independent variables, and the parameters as input quantities."
}], "Text",
  CellTags->{"potential representation", "PotentialSystemsOnly"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(pSystemOfReaktionDiffusion\  = 
      PotentialSymmetries[\ reaktionDiffusion, u, {x, t}, {\[Beta]}, 
        PotentialSystemsOnly \[Rule] True]; 
    pSystemOfReaktionDiffusion\  // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({{{1\/u + x\^2\ \[Beta] + V10\_t, \(-V\_8\) - V10\_x, 
          \(-u\) - \((V\_8)\)\_x}, {u, V\_8, V10}, {x, t}}, {{
          1\/\(u\ x\) + x\ \[Beta] + V11\_t, \(-\(V\_9\/x\^2\)\) - V11\_x, 
          \(-u\)\ x - \((V\_9)\)\_x}, {u, V\_9, V11}, {x, t}}, {{
          \(-\(E\^\(\(-\[Beta]\)\ V\_9\)\/\(u\ x\ \[Beta]\)\)\) + V12\_t, 
          \(-\(E\^\(\(-\[Beta]\)\ V\_9\)\/\(x\^2\ \[Beta]\^2\)\)\) - V12\_x, 
          \(-u\)\ x - \((V\_9)\)\_x}, {u, V\_9, V12}, {x, t}}, {{
          1\/\(u\ x\) + x\ \[Beta] + V14\_t, \(-\(V\_9\/x\^2\)\) - V14\_x, 
          \(-\(E\^\(\(-\[Beta]\)\ V\_9\)\/\(u\ x\ \[Beta]\)\)\) + V13\_t, 
          \(-\(E\^\(\(-\[Beta]\)\ V\_9\)\/\(x\^2\ \[Beta]\^2\)\)\) - 
            V13\_x}, {u, V\_9, V13, V14}, {x, t}}}\)], "Output"]
}, Open  ]],

Cell["\<\
The result is a nested list containing four lists. Each of these \
sub-lists contains information on a specific potential system. Added to each \
potential system are lists containing the dependent and independent variables \
of the system. We observe that three of the potential systems are formulated \
for three dependent variables and that one of the potential systems contains \
four dependent variables. This behavior indicates that the fourth potential \
system is a second-stage potential system derived from a precursor. We learn \
that not only the original equation is checked on a possible potential \
representation but also all potential systems derived from the original \
one.\
\>", "Text",
  CellTags->"potential system"]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.4.2 Cylindrical Korteweg-de Vries Equation", "Subsection",
  CellTags->"Cylindrical Korteweg-de Vries Equation"],

Cell[TextData[{
  "The second example examines the symmetries of the potential systems for \
the ",
  ButtonBox["cylindrical KdV equation",
    ButtonData:>{"KdVEquation.nb", "cylindrical KdV equation"},
    ButtonStyle->"Hyperlink"],
  ". The cylindrical KdV (cKdV) equation is given by"
}], "Text",
  CellTags->{"cylindrical KdV equation", "cKdV equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(cKdV\  = \ 
      \[PartialD]\_t u[x, t]\  + \ u[x, t]\/\(2\ t\) + 
          u[x, t]\ \[PartialD]\_x u[x, t]\  + 
          \[PartialD]\_\(x, x, x\)u[x, t] == 0; cKdV // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(u\/\(2\ t\)\),
                  ScriptLevel->0], "+", \(u\_t\), "+", \(u\ u\_x\), "+", 
                \(u\_\(x, x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The potential systems of the cKdV equation are calculated by", "Text",
  CellTags->"potential systems of the cKdV equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pcKdV\  = \ 
      PotentialSymmetries[cKdV\ , u, {x, t}, 
        PotentialSystemsOnly \[Rule] True, OrderReduce \[Rule] False]; 
    pcKdV // TableForm[LieTraditionalForm[#], TableSpacing -> {1, 1}]&\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {
                  RowBox[{
                    RowBox[{
                      RowBox[{"-", 
                        StyleBox[\(1\/2\),
                          ScriptLevel->0]}], " ", \(\@t\), " ", \(u\^2\)}], 
                    "+", \(V14\_t\), "-", \(\@t\ u\_\(x, x\)\)}]},
                {\(\(-\@t\)\ u - V14\_x\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"u"},
                {"V14"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"x"},
                {"t"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {
                  RowBox[{
                    RowBox[{"-", 
                      StyleBox[\(\(t\ u\^3\)\/3\),
                        ScriptLevel->0]}], "+", 
                    StyleBox[\(\(t\ u\_x\%2\)\/2\),
                      ScriptLevel->0], "+", \(V15\_t\), "-", 
                    \(t\ u\ u\_\(x, x\)\)}]},
                {
                  RowBox[{
                    RowBox[{"-", 
                      StyleBox[\(\(t\ u\^2\)\/2\),
                        ScriptLevel->0]}], "-", \(V15\_x\)}]}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"u"},
                {"V15"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"x"},
                {"t"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {
                  RowBox[{
                    RowBox[{
                      RowBox[{"-", 
                        StyleBox[\(1\/3\),
                          ScriptLevel->0]}], " ", \(t\^\(3/2\)\), " ", 
                      \(u\^3\)}], "+", 
                    RowBox[{
                      StyleBox[\(1\/4\),
                        ScriptLevel->0], " ", \(\@t\), " ", \(u\^2\), " ", 
                      "x"}], "-", 
                    StyleBox[\(\(\@t\ u\_x\)\/2\),
                      ScriptLevel->0], "+", 
                    RowBox[{
                      StyleBox[\(1\/2\),
                        ScriptLevel->0], " ", \(t\^\(3/2\)\), " ", 
                      \(u\_x\%2\)}], "\n", "+", \(V16\_t\), "-", 
                    RowBox[{
                      RowBox[{"(", 
                        RowBox[{\(t\^\(3/2\)\ u\), "-", 
                          StyleBox[\(\(\@t\ x\)\/2\),
                            ScriptLevel->0]}], ")"}], " ", 
                      \(u\_\(x, x\)\)}]}]},
                {
                  RowBox[{
                    RowBox[{
                      RowBox[{"-", 
                        StyleBox[\(1\/2\),
                          ScriptLevel->0]}], 
                      StyleBox[" ",
                        ScriptLevel->0], \(t\^\(3/2\)\), " ", \(u\^2\)}], 
                    "+", 
                    RowBox[{
                      StyleBox[\(1\/2\),
                        ScriptLevel->0], " ", \(\@t\), " ", "u", " ", "x"}], 
                    "-", \(V16\_x\)}]}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"u"},
                {"V16"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"x"},
                {"t"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Power[ t, 
              Rational[ 1, 2]], 
            Power[ u, 2]], 
          Subscript[ V14, t], 
          Times[ -1, 
            Power[ t, 
              Rational[ 1, 2]], 
            Subscript[ u, x, x]]], 
        Plus[ 
          Times[ -1, 
            Power[ t, 
              Rational[ 1, 2]], u], 
          Times[ -1, 
            Subscript[ V14, x]]]}, {u, V14}, {x, t}}, {{
        Plus[ 
          Times[ 
            Rational[ -1, 3], t, 
            Power[ u, 3]], 
          Times[ 
            Rational[ 1, 2], t, 
            Power[ 
              Subscript[ u, x], 2]], 
          Subscript[ V15, t], 
          Times[ -1, t, u, 
            Subscript[ u, x, x]]], 
        Plus[ 
          Times[ 
            Rational[ -1, 2], t, 
            Power[ u, 2]], 
          Times[ -1, 
            Subscript[ V15, x]]]}, {u, V15}, {x, t}}, {{
        Plus[ 
          Times[ 
            Rational[ -1, 3], 
            Power[ t, 
              Rational[ 3, 2]], 
            Power[ u, 3]], 
          Times[ 
            Rational[ 1, 4], 
            Power[ t, 
              Rational[ 1, 2]], 
            Power[ u, 2], x], 
          Times[ 
            Rational[ -1, 2], 
            Power[ t, 
              Rational[ 1, 2]], 
            Subscript[ u, x]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ t, 
              Rational[ 3, 2]], 
            Power[ 
              Subscript[ u, x], 2]], 
          Subscript[ V16, t], 
          Times[ -1, 
            Plus[ 
              Times[ 
                Power[ t, 
                  Rational[ 3, 2]], u], 
              Times[ 
                Rational[ -1, 2], 
                Power[ t, 
                  Rational[ 1, 2]], x]], 
            Subscript[ u, x, x]]], 
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Power[ t, 
              Rational[ 3, 2]], 
            Power[ u, 2]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ t, 
              Rational[ 1, 2]], u, x], 
          Times[ -1, 
            Subscript[ V16, x]]]}, {u, V16}, {x, t}}}, TableSpacing -> {1, 
        1}]]], "Output",
  TextAlignment->Left,
  TextJustification->0]
}, Open  ]],

Cell[TextData[{
  "The result is a set of three potential systems of first stage. For this \
equation ",
  StyleBox["PotentialSymmetries[]", "MmaText"],
  " does not find derived potential systems of higher order. We used the \
option ",
  StyleBox["OrderReduce\[Rule]False", "MmaText",
    FontSlant->"Italic"],
  " for the above calculation to find all reductions of the original \
equation. The function ",
  StyleBox["PotentialSymmetries[] ", "MmaText"],
  "assumes by default that the auxiliary system is reduced in order and thus \
only returns a special class of potential systems. However, we can control \
this behavior by the option ",
  StyleBox["OrderReduce", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ", "MmaText"],
  "and can choose the suitable method."
}], "Text",
  CellTags->{"PotentialSymmetries[]", "OrderReduce", "auxiliary system"}],

Cell[TextData[{
  "The next step is the solution of the potential systems to find the related \
potential symmetries. Let us start with the first potential system. We \
calculate the infinitesimal transformations of this system by selecting the \
first argument of ",
  StyleBox["pcKdV", "MmaText",
    FontSlant->"Italic"],
  " and feed them into the function ",
  StyleBox["Infinitesimals[]:", "MmaText"]
}], "Text",
  CellTags->{"infinitesimal transformation", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infpcKdV\  = \ 
      Infinitesimals[pcKdV\[LeftDoubleBracket]1, 1\[RightDoubleBracket], 
        pcKdV\[LeftDoubleBracket]1, 2\[RightDoubleBracket], 
        pcKdV\[LeftDoubleBracket]1, 3\[RightDoubleBracket]]; 
    infpcKdV\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(\(-k3\) - 4\ k1\ \@t\ u + 8\ k4\ t\ u - 2\ k4\ x\)\/\@t
                      \),
                ScriptLevel->0]}]},
          {\(\[Phi]\_2 == k2 + k1\ V1 + x\ \((k3 + k4\ x)\)\)},
          {\(\[Xi]\_1 == k5 - 2\ k3\ \@t + 2\ \((k1 - 2\ k4\ \@t)\)\ x\)},
          {\(\[Xi]\_2 == 6\ k1\ t - 8\ k4\ t\^\(3/2\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ t, 
              Rational[ -1, 2]], 
            Plus[ 
              Times[ -1, k3], 
              Times[ -4, k1, 
                Power[ t, 
                  Rational[ 1, 2]], u], 
              Times[ 8, k4, t, u], 
              Times[ -2, k4, x]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Plus[ k2, 
            Times[ k1, V1], 
            Times[ x, 
              Plus[ k3, 
                Times[ k4, x]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k5, 
            Times[ -2, k3, 
              Power[ t, 
                Rational[ 1, 2]]], 
            Times[ 2, 
              Plus[ k1, 
                Times[ -2, k4, 
                  Power[ t, 
                    Rational[ 1, 2]]]], x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 6, k1, t], 
            Times[ -8, k4, 
              Power[ t, 
                Rational[ 3, 2]]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result represents a five-dimensional finite symmetry group which is \
similar to the ",
  ButtonBox["point symmetries of the cKdV",
    ButtonData:>{"KdVEquation.nb", 
      "symmetry group of the cylindrical KdV equation"},
    ButtonStyle->"Hyperlink"],
  " equation. The difference exists in the dimension of the group and in the \
number of elements. The point symmetry of the cKdV equation consists of three \
expressions and the potential symmetries of four. Recalling the ",
  ButtonBox["definition of a potential symmetry",
    ButtonData:>"Definition: Potential symmetry",
    ButtonStyle->"Hyperlink"],
  ", we have to check the dependence of the infinitesimals for the original \
equation on variables introduced in the derivation of the potential system. \
If we examine the infinitesimals ",
  StyleBox["xi[1]",
    FontSlant->"Italic"],
  ", ",
  StyleBox["xi[2]",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["phi[1]",
    FontSlant->"Italic"],
  " on the dependence of variables starting with capital letter",
  StyleBox[" V",
    FontSlant->"Italic"],
  ", we quickly realize that these infinitesimals are independent of the new \
potential variables. In conclusion, the first potential system of the cKdV \
equation does not contribute to potential symmetries. In order to check all \
possibilities for the above potential system, we carry out the calculation \
by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(allInfPcKdV = \ 
      Map[Infinitesimals[#\[LeftDoubleBracket]1\[RightDoubleBracket], #
              \[LeftDoubleBracket]2\[RightDoubleBracket], #
              \[LeftDoubleBracket]3\[RightDoubleBracket]]&, pcKdV]; 
    \(\(allInfPcKdV /. {Rule \[Rule] Equal, 
              HoldPattern[Function[x_, y_]] \[Rule] y}\) /. 
          TraditionalLieForm // Flatten\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(\(-k3\) - 4\ k1\ \@t\ u + 8\ k4\ t\ u - 2\ k4\ x\)\/\@t
                      \),
                ScriptLevel->0]}]},
          {\(\[Xi]\_1 == k5 - 2\ k3\ \@t + 2\ \((k1 - 2\ k4\ \@t)\)\ x\)},
          {\(\[Xi]\_2 == 6\ k1\ t - 8\ k4\ t\^\(3/2\)\)},
          {\(\[Phi]\_2 == k2 + k1\ V1 + x\ \((k3 + k4\ x)\)\)},
          {\(\[Phi]\_1 == \(-2\)\ k3\ u\)},
          {\(\[Phi]\_2 == k1\)},
          {\(\[Xi]\_1 == k2 + k3\ x\)},
          {\(\[Xi]\_2 == 3\ k3\ t\)},
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_1 == 0\)},
          {\(\[Xi]\_2 == 0\)},
          {\(\[Phi]\_2 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ t, 
              Rational[ -1, 2]], 
            Plus[ 
              Times[ -1, k3], 
              Times[ -4, k1, 
                Power[ t, 
                  Rational[ 1, 2]], u], 
              Times[ 8, k4, t, u], 
              Times[ -2, k4, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k5, 
            Times[ -2, k3, 
              Power[ t, 
                Rational[ 1, 2]]], 
            Times[ 2, 
              Plus[ k1, 
                Times[ -2, k4, 
                  Power[ t, 
                    Rational[ 1, 2]]]], x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 6, k1, t], 
            Times[ -8, k4, 
              Power[ t, 
                Rational[ 3, 2]]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Plus[ k2, 
            Times[ k1, V1], 
            Times[ x, 
              Plus[ k3, 
                Times[ k4, x]]]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ -2, k3, u]], 
        Equal[ 
          Subscript[ \[Phi], 2], k1], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k3, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Times[ 3, k3, t]], 
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 2], 0], 
        Equal[ 
          Subscript[ \[Phi], 2], k1]}]]], "Output",
  GridBoxOptions->{RowSpacings->1,
  RowLines->False}]
}, Open  ]],

Cell[TextData[{
  "Checking the dependencies of the infinitesimals on the potential \
variables, we realize that none of the infinitesimals satisfies the criterion \
for potential symmetries. However, the function ",
  StyleBox["PotentialSymmetries[]", "MmaText"],
  " makes it easy to verify the definition and to decide whether a given \
equation allows potential symmetries or not. Experience with this function \
tells us that potential symmetries are rare symmetries but occur in \
connection with some equations. The above two-step calculation can be done in \
one step by suppressing the option ",
  StyleBox["PotentialSystemsOnly\[Rule]True", "MmaText",
    FontSlant->"Italic"],
  StyleBox[":", "MmaText"]
}], "Text",
  CellTags->"potential symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PotentialSymmetries[cKdV, u, {x, t}, OrderReduce \[Rule] False]\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{\(\(-\(1\/2\)\)\ \@t\ u[x, t]\^2\), "+", 
                  RowBox[{
                    SuperscriptBox["V17", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}], "-", 
                  RowBox[{\(\@t\), " ", 
                    RowBox[{
                      SuperscriptBox["u", 
                        TagBox[\((2, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
                ",", 
                RowBox[{\(\(-\@t\)\ u[x, t]\), "-", 
                  RowBox[{
                    SuperscriptBox["V17", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
              "}"}], ",", \({u, V17}\), ",", \({x, t}\), ",", 
            \({phi[1] \[Rule] 
                Function[{x, t, u, V17}, 
                  \(\(-k3\) - 4\ k1\ \@t\ u + 8\ k4\ t\ u - 2\ k4\ x\)\/\@t], 
              xi[1] \[Rule] 
                Function[{x, t, u, V17}, 
                  k5 - 2\ k3\ \@t + 2\ \((k1 - 2\ k4\ \@t)\)\ x], 
              xi[2] \[Rule] 
                Function[{x, t, u, V17}, 6\ k1\ t - 8\ k4\ t\^\(3/2\)], 
              phi[2] \[Rule] 
                Function[{x, t, u, V17}, k2 + k1\ V17 + x\ \((k3 + k4\ x)\)]}
              \)}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{\(\(-\(1\/3\)\)\ t\ u[x, t]\^3\), "+", 
                  RowBox[{
                    SuperscriptBox["V18", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}], "+", 
                  RowBox[{\(1\/2\), " ", "t", " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, t\), "]"}], 
                      "2"]}], "-", 
                  RowBox[{"t", " ", \(u[x, t]\), " ", 
                    RowBox[{
                      SuperscriptBox["u", 
                        TagBox[\((2, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
                ",", 
                RowBox[{\(\(-\(1\/2\)\)\ t\ u[x, t]\^2\), "-", 
                  RowBox[{
                    SuperscriptBox["V18", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
              "}"}], ",", \({u, V18}\), ",", \({x, t}\), ",", 
            \({phi[1] \[Rule] Function[{x, t, u, V18}, \(-2\)\ k3\ u], 
              phi[2] \[Rule] Function[{x, t, u, V18}, k1], 
              xi[1] \[Rule] Function[{x, t, u, V18}, k2 + k3\ x], 
              xi[2] \[Rule] Function[{x, t, u, V18}, 3\ k3\ t]}\)}], "}"}], 
        ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                \(1\/4\ \@t\ x\ u[x, t]\^2\), "-", 
                  \(1\/3\ t\^\(3/2\)\ u[x, t]\^3\), "+", 
                  RowBox[{
                    SuperscriptBox["V19", 
                      TagBox[\((0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}], "-", 
                  RowBox[{\(1\/2\), " ", \(\@t\), " ", 
                    RowBox[{
                      SuperscriptBox["u", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, t\), "]"}]}], 
                  "+", 
                  RowBox[{\(1\/2\), " ", \(t\^\(3/2\)\), " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["u", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, t\), "]"}], 
                      "2"]}], "-", 
                  RowBox[{
                  \((\(-\(\(\@t\ x\)\/2\)\) + t\^\(3/2\)\ u[x, t])\), " ", 
                    RowBox[{
                      SuperscriptBox["u", 
                        TagBox[\((2, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
                ",", 
                RowBox[{
                \(1\/2\ \@t\ x\ u[x, t]\), "-", 
                  \(1\/2\ t\^\(3/2\)\ u[x, t]\^2\), "-", 
                  RowBox[{
                    SuperscriptBox["V19", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
              "}"}], ",", \({u, V19}\), ",", \({x, t}\), ",", 
            \({phi[1] \[Rule] 
                Function[{x, t, u, V19}, 
                  \(-\(\(2\ 
                          \((\(-6\)\ k2 + k4\ \@t\ u + 36\ k3\ t\ u - 
                              9\ k3\ x)\)\)\/\(3\ \@t\)\)\)], 
              xi[1] \[Rule] 
                Function[{x, t, u, V19}, 
                  \(k4\ x\)\/3 + 4\ \@t\ \((2\ k2 + 3\ k3\ x)\)], 
              xi[2] \[Rule] 
                Function[{x, t, u, V19}, \((k4 + 24\ k3\ \@t)\)\ t], 
              phi[2] \[Rule] 
                Function[{x, t, u, V19}, 
                  k1 + k5 + 3\ k3\ t + \(k4\ V19\)\/2 + k2\ x\^2 + k3\ x\^3]}
              \)}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The resulting list now contains the information on the potential \
systems extended by the infinitesimals. The outcome is the same as before. No \
potential symmetries are present.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["7.4.3 The Burgers Equation", "Subsection",
  CellTags->"The Burgers Equation"],

Cell["\<\
Another example which allows potential symmetries is the Burgers \
equation:\
\>", "Text",
  CellTags->"Burgers equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Burgers\  = \ 
      \[PartialD]\_t u[x, t]\  + u[x, t]\ \[PartialD]\_x u[x, t]\  + \ 
          \[Gamma]\ \[PartialD]\_\(x, x\)u[x, t] == 0; Burgers // LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t + u\ u\_x + \[Gamma]\ u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[Gamma] is a real constant and measures the strength of second-order \
dispersion effects. The potential system and the potential symmetries are \
calculated with"], "Text",
  CellTags->{"second-order dispersion effect", "potential system"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(pBurgers\  = 
      PotentialSymmetries[Burgers, u, {x, t}, {\[Gamma]}, 
        OrderReduce \[Rule] False]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{\(\(-\(1\/2\)\)\ u[x, t]\^2\), "+", 
                RowBox[{
                  SuperscriptBox["V24", 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}], "-", 
                RowBox[{"\[Gamma]", " ", 
                  RowBox[{
                    SuperscriptBox["u", 
                      TagBox[\((1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
              ",", 
              RowBox[{\(-u[x, t]\), "-", 
                RowBox[{
                  SuperscriptBox["V24", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
            "}"}], ",", \({u, V24}\), ",", \({x, t}\), ",", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                \(xi[1] \[Rule] 
                    Function[{x, t, u, V24}, 
                      k3 - k6\ t + 1\/2\ \((k2 - 4\ k7\ t)\)\ x]\), ",", 
                  \(xi[2] \[Rule] 
                    Function[{x, t, u, V24}, k1 + t\ \((k2 - 2\ k7\ t)\)]\), 
                  ",", \(phi[2] \[Rule] 
                    Function[{x, t, u, V24}, 
                      k4 + k5 + k6\ x + k7\ x\^2 - 2\ k7\ t\ \[Gamma] + 
                        2\ E\^\(V24\/\(2\ \[Gamma]\)\)\ \[Gamma]\ 
                          \(free[1]\)[x, t]]\), ",", 
                  RowBox[{\(phi[1]\), "\[Rule]", 
                    RowBox[{"Function", "[", 
                      RowBox[{\({x, t, u, V24}\), ",", 
                        RowBox[{
                        \(-k6\), "-", \(\(k2\ u\)\/2\), "+", \(2\ k7\ t\ u\), 
                          "-", \(2\ k7\ x\), "+", 
                          \(E\^\(V24\/\(2\ \[Gamma]\)\)\ u\ 
                            \(free[1]\)[x, t]\), "-", 
                          RowBox[{
                          "2", " ", \(E\^\(V24\/\(2\ \[Gamma]\)\)\), " ", 
                            "\[Gamma]", " ", 
                            RowBox[{
                              SuperscriptBox[\(free[1]\), 
                                TagBox[\((1, 0)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(x, t\), 
                              "]"}]}]}]}], "]"}]}]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[\(free[1]\), 
                        TagBox[\((0, 1)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, t\), "]"}], 
                    "\[Gamma]"], "+", 
                  RowBox[{
                    SuperscriptBox[\(free[1]\), 
                      TagBox[\((2, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x, t\), "]"}]}], 
                "}"}]}], "}"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "For the potential system of the Burgers equation, we find a \
seven-dimensional finite group and an infinite group. The infinite part of \
the group was derived by ",
  ButtonBox["Vinogradov and Krasil",
    ButtonData:>{"Literat.nb", "Vinogradov-1984"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[CloseCurlyQuote]",
    ButtonData:>{"Literat.nb", "Vinogradov-1984"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["shchik [1984]",
    ButtonData:>{"Literat.nb", "Vinogradov-1984"},
    ButtonStyle->"Hyperlink"],
  ". In addition, the auxiliary function ",
  StyleBox["free[1]", "MmaText",
    FontSlant->"Italic"],
  " of this continuous group has to satisfy the diffusion equation."
}], "Text",
  CellTags->"Burgers equation"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet7.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{693, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->392,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Potential Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Introduction", "Basics of Potential Symmetries", 
                "Calculation of Potential Symmetries", 
                "Applications of Potential Symmetries"}, #]&)], FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Potential Symmetries of Partial Differential Equations"->{
    Cell[1739, 51, 419, 7, 94, "ChapterLine",
      Evaluatable->False,
      CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Potential Symmetries of Partial Differential Equations"]},
  "Introduction"->{
    Cell[2590, 73, 332, 9, 43, "Section",
      CounterAssignments->{{"Title", 7}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Introduction"]},
  "point symmetries"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}],
    Cell[9600, 269, 1370, 31, 95, "Text",
      CellTags->{
      "Fr\[EAcute]chet derivative", "point symmetries", 
        "generalized symmetries", "potential symmetries"}],
    Cell[25408, 702, 812, 15, 95, "Text",
      CellTags->{
      "point symmetries", "non-local properties", "potential system", 
        "non-classical method"}]},
  "non-classical symmetries"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}],
    Cell[8276, 231, 553, 16, 44, "Text",
      CellTags->{
      "characteristics", "non-classical symmetries", "prolongation", 
        "vector field"}]},
  "local symmetries"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}]},
  "local transformation"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}]},
  "derived systems of PDEs"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}]},
  "affiliated system of PDEs"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}]},
  "non-local symmetries"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}],
    Cell[11172, 313, 762, 20, 78, "Text",
      Evaluatable->False,
      CellTags->{"non-local symmetries", "extended equations"}]},
  "potential symmetries"->{
    Cell[2925, 84, 1331, 24, 163, "Text",
      Evaluatable->False,
      CellTags->{
      "point symmetries", "non-classical symmetries", "local symmetries", 
        "local transformation", "derived systems of PDEs", 
        "affiliated system of PDEs", "non-local symmetries", 
        "potential symmetries"}],
    Cell[9600, 269, 1370, 31, 95, "Text",
      CellTags->{
      "Fr\[EAcute]chet derivative", "point symmetries", 
        "generalized symmetries", "potential symmetries"}],
    Cell[48761, 1385, 762, 14, 99, "Text",
      CellTags->"potential symmetries"]},
  "Basics of Potential Symmetries"->{
    Cell[4571, 120, 152, 6, 43, "Section",
      CellTags->"Basics of Potential Symmetries"]},
  "weak symmetries"->{
    Cell[4726, 128, 634, 14, 61, "Text",
      CellTags->{"weak symmetries", "strong symmetries", "reduction"}]},
  "strong symmetries"->{
    Cell[4726, 128, 634, 14, 61, "Text",
      CellTags->{"weak symmetries", "strong symmetries", "reduction"}]},
  "reduction"->{
    Cell[4726, 128, 634, 14, 61, "Text",
      CellTags->{"weak symmetries", "strong symmetries", "reduction"}]},
  "Definition: Topological Symmetry"->{
    Cell[5363, 144, 102, 1, 33, "Definition",
      CellTags->"Definition: Topological Symmetry"]},
  "topological"->{
    Cell[5803, 158, 358, 7, 61, "Text",
      CellTags->"topological"]},
  "classical symmetries"->{
    Cell[6164, 167, 370, 8, 61, "Text",
      CellTags->{
      "classical symmetries", "point transformations", 
        "infinitesimal transformation"}]},
  "point transformations"->{
    Cell[6164, 167, 370, 8, 61, "Text",
      CellTags->{
      "classical symmetries", "point transformations", 
        "infinitesimal transformation"}]},
  "infinitesimal transformation"->{
    Cell[6164, 167, 370, 8, 61, "Text",
      CellTags->{
      "classical symmetries", "point transformations", 
        "infinitesimal transformation"}],
    Cell[41886, 1175, 484, 10, 65, "Text",
      CellTags->{"infinitesimal transformation", "Infinitesimals[]"}]},
  "eq-7"->{
    Cell[6537, 177, 235, 5, 23, "NumberedEquation",
      CellTags->"eq-7"]},
  "eq-8"->{
    Cell[6775, 184, 268, 6, 22, "NumberedEquation",
      CellTags->"eq-8"]},
  "characteristics"->{
    Cell[8276, 231, 553, 16, 44, "Text",
      CellTags->{
      "characteristics", "non-classical symmetries", "prolongation", 
        "vector field"}],
    Cell[23931, 667, 759, 19, 61, "Text",
      CellTags->{
      "adjoint Fr\[EAcute]chet derivative", "invariance condition", 
        "characteristics"}]},
  "prolongation"->{
    Cell[8276, 231, 553, 16, 44, "Text",
      CellTags->{
      "characteristics", "non-classical symmetries", "prolongation", 
        "vector field"}]},
  "vector field"->{
    Cell[8276, 231, 553, 16, 44, "Text",
      CellTags->{
      "characteristics", "non-classical symmetries", "prolongation", 
        "vector field"}]},
  "invariance condition"->{
    Cell[9094, 255, 332, 7, 44, "Text",
      CellTags->"invariance condition"],
    Cell[23931, 667, 759, 19, 61, "Text",
      CellTags->{
      "adjoint Fr\[EAcute]chet derivative", "invariance condition", 
        "characteristics"}]},
  "Fr\[EAcute]chet derivative"->{
    Cell[9600, 269, 1370, 31, 95, "Text",
      CellTags->{
      "Fr\[EAcute]chet derivative", "point symmetries", 
        "generalized symmetries", "potential symmetries"}]},
  "generalized symmetries"->{
    Cell[9600, 269, 1370, 31, 95, "Text",
      CellTags->{
      "Fr\[EAcute]chet derivative", "point symmetries", 
        "generalized symmetries", "potential symmetries"}]},
  "Calculation of Potential Symmetries"->{
    Cell[11007, 305, 162, 6, 43, "Section",
      CellTags->"Calculation of Potential Symmetries"]},
  "extended equations"->{
    Cell[11172, 313, 762, 20, 78, "Text",
      Evaluatable->False,
      CellTags->{"non-local symmetries", "extended equations"}]},
  "auxiliary system"->{
    Cell[12078, 339, 545, 16, 44, "Text",
      Evaluatable->False,
      CellTags->{"auxiliary system", "conservation law"}],
    Cell[41021, 1154, 862, 19, 103, "Text",
      CellTags->{
      "PotentialSymmetries[]", "OrderReduce", "auxiliary system"}]},
  "conservation law"->{
    Cell[12078, 339, 545, 16, 44, "Text",
      Evaluatable->False,
      CellTags->{"auxiliary system", "conservation law"}]},
  "new variables"->{
    Cell[13976, 399, 710, 20, 63, "Text",
      CellTags->{"new variables", "potential system"}]},
  "potential system"->{
    Cell[13976, 399, 710, 20, 63, "Text",
      CellTags->{"new variables", "potential system"}],
    Cell[15626, 448, 1317, 28, 129, "Text",
      CellTags->{"potential system", "point symmetry", "non-local symmetry"}],
    
    Cell[17047, 481, 178, 3, 27, "Text",
      CellTags->"potential system"],
    Cell[18599, 530, 589, 12, 61, "Text",
      CellTags->{"potential symmetry", "potential system"}],
    Cell[19191, 544, 778, 16, 81, "Text",
      Evaluatable->False,
      CellTags->{"potential system", "integrating multipliers"}],
    Cell[25408, 702, 812, 15, 95, "Text",
      CellTags->{
      "point symmetries", "non-local properties", "potential system", 
        "non-classical method"}],
    Cell[31888, 879, 748, 12, 112, "Text",
      CellTags->"potential system"],
    Cell[56475, 1579, 264, 4, 44, "Text",
      CellTags->{"second-order dispersion effect", "potential system"}]},
  "point symmetry"->{
    Cell[15626, 448, 1317, 28, 129, "Text",
      CellTags->{
      "potential system", "point symmetry", "non-local symmetry"}]},
  "non-local symmetry"->{
    Cell[15626, 448, 1317, 28, 129, "Text",
      CellTags->{
      "potential system", "point symmetry", "non-local symmetry"}]},
  "Definition: Potential symmetry"->{
    Cell[16946, 478, 98, 1, 33, "Definition",
      CellTags->"Definition: Potential symmetry"]},
  "potential symmetry"->{
    Cell[18599, 530, 589, 12, 61, "Text",
      CellTags->{"potential symmetry", "potential system"}]},
  "integrating multipliers"->{
    Cell[19191, 544, 778, 16, 81, "Text",
      Evaluatable->False,
      CellTags->{"potential system", "integrating multipliers"}],
    Cell[26640, 730, 139, 2, 20, "ListItem",
      CellTags->"integrating multipliers"]},
  "Definition: Equivalence of conserved representations"->{
    Cell[21810, 612, 142, 1, 33, "Definition",
      CellTags->"Definition: Equivalence of conserved representations"]},
  "common space of solutions"->{
    Cell[21955, 615, 566, 13, 61, "Text",
      CellTags->{
      "common space of solutions", "equivalent conserved representation"}]},
  "equivalent conserved representation"->{
    Cell[21955, 615, 566, 13, 61, "Text",
      CellTags->{
      "common space of solutions", "equivalent conserved representation"}]},
  "integrating multiplier"->{
    Cell[23253, 650, 498, 10, 61, "Text",
      CellTags->{"integrating multiplier", "invariance criterion"}]},
  "invariance criterion"->{
    Cell[23253, 650, 498, 10, 61, "Text",
      CellTags->{"integrating multiplier", "invariance criterion"}]},
  "adjoint Fr\[EAcute]chet derivative"->{
    Cell[23931, 667, 759, 19, 61, "Text",
      CellTags->{
      "adjoint Fr\[EAcute]chet derivative", "invariance condition", 
        "characteristics"}]},
  "tree of potential system"->{
    Cell[25090, 695, 315, 5, 44, "Text",
      CellTags->"tree of potential system"]},
  "non-local properties"->{
    Cell[25408, 702, 812, 15, 95, "Text",
      CellTags->{
      "point symmetries", "non-local properties", "potential system", 
        "non-classical method"}]},
  "non-classical method"->{
    Cell[25408, 702, 812, 15, 95, "Text",
      CellTags->{
      "point symmetries", "non-local properties", "potential system", 
        "non-classical method"}]},
  "integrating factor"->{
    Cell[26223, 719, 414, 9, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "integrating factor", "algorithm for potential symmetries"}]},
  "algorithm for potential symmetries"->{
    Cell[26223, 719, 414, 9, 44, "Text",
      Evaluatable->False,
      CellTags->{
      "integrating factor", "algorithm for potential symmetries"}]},
  "equivalent conservation law"->{
    Cell[26782, 734, 175, 5, 20, "ListItem",
      CellTags->"equivalent conservation law"]},
  "potential representation"->{
    Cell[26960, 741, 184, 4, 20, "ListItem",
      CellTags->"potential representation"],
    Cell[30236, 843, 591, 12, 65, "Text",
      CellTags->{"potential representation", "PotentialSystemsOnly"}]},
  "PotentialSymmetries[]"->{
    Cell[27284, 753, 546, 13, 82, "Text",
      CellTags->"PotentialSymmetries[]"],
    Cell[28699, 793, 357, 9, 46, "Text",
      CellTags->"PotentialSymmetries[]"],
    Cell[41021, 1154, 862, 19, 103, "Text",
      CellTags->{
      "PotentialSymmetries[]", "OrderReduce", "auxiliary system"}]},
  "Applications for Potential Symmetries"->{
    Cell[27867, 771, 165, 6, 43, "Section",
      CellTags->"Applications for Potential Symmetries"]},
  "potential systems"->{
    Cell[28035, 779, 661, 12, 95, "Text",
      CellTags->{
      "potential systems", "point symmetries of the potential system"}]},
  "point symmetries of the potential system"->{
    Cell[28035, 779, 661, 12, 95, "Text",
      CellTags->{
      "potential systems", "point symmetries of the potential system"}]},
  "The Diffusion Equation"->{
    Cell[29081, 806, 154, 2, 41, "Subsection",
      CellTags->{
      "The Diffusion Equation", "A Nonlinear Reaction Diffusion Equation"}]},
  "A Nonlinear Reaction Diffusion Equation"->{
    Cell[29081, 806, 154, 2, 41, "Subsection",
      CellTags->{
      "The Diffusion Equation", "A Nonlinear Reaction Diffusion Equation"}]},
  "nonlinear reaction diffusion equation"->{
    Cell[29238, 810, 276, 6, 44, "Text",
      CellTags->"nonlinear reaction diffusion equation"]},
  "PotentialSystemsOnly"->{
    Cell[30236, 843, 591, 12, 65, "Text",
      CellTags->{"potential representation", "PotentialSystemsOnly"}]},
  "Cylindrical Korteweg-de Vries Equation"->{
    Cell[32673, 896, 120, 1, 41, "Subsection",
      CellTags->"Cylindrical Korteweg-de Vries Equation"]},
  "cylindrical KdV equation"->{
    Cell[32796, 899, 359, 8, 44, "Text",
      CellTags->{"cylindrical KdV equation", "cKdV equation"}]},
  "cKdV equation"->{
    Cell[32796, 899, 359, 8, 44, "Text",
      CellTags->{"cylindrical KdV equation", "cKdV equation"}]},
  "potential systems of the cKdV equation"->{
    Cell[33830, 933, 130, 1, 27, "Text",
      CellTags->"potential systems of the cKdV equation"]},
  "OrderReduce"->{
    Cell[41021, 1154, 862, 19, 103, "Text",
      CellTags->{
      "PotentialSymmetries[]", "OrderReduce", "auxiliary system"}]},
  "Infinitesimals[]"->{
    Cell[41886, 1175, 484, 10, 65, "Text",
      CellTags->{"infinitesimal transformation", "Infinitesimals[]"}]},
  "The Burgers Equation"->{
    Cell[55759, 1551, 84, 1, 41, "Subsection",
      CellTags->"The Burgers Equation"]},
  "Burgers equation"->{
    Cell[55846, 1554, 132, 4, 27, "Text",
      CellTags->"Burgers equation"],
    Cell[60118, 1666, 747, 18, 65, "Text",
      CellTags->"Burgers equation"]},
  "second-order dispersion effect"->{
    Cell[56475, 1579, 264, 4, 44, "Text",
      CellTags->{"second-order dispersion effect", "potential system"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Potential Symmetries of Partial Differential Equations", 62872, 1742},
  {"Introduction", 63279, 1750},
  {"point symmetries", 63618, 1757},
  {"non-classical symmetries", 64310, 1773},
  {"local symmetries", 64807, 1785},
  {"local transformation", 65153, 1793},
  {"derived systems of PDEs", 65502, 1801},
  {"affiliated system of PDEs", 65853, 1809},
  {"non-local symmetries", 66199, 1817},
  {"potential symmetries", 66678, 1828},
  {"Basics of Potential Symmetries", 67295, 1842},
  {"weak symmetries", 67413, 1845},
  {"strong symmetries", 67552, 1848},
  {"reduction", 67683, 1851},
  {"Definition: Topological Symmetry", 67837, 1854},
  {"topological", 67956, 1857},
  {"classical symmetries", 68057, 1860},
  {"point transformations", 68243, 1865},
  {"infinitesimal transformation", 68436, 1870},
  {"eq-7", 68719, 1877},
  {"eq-8", 68809, 1880},
  {"characteristics", 68910, 1883},
  {"prolongation", 69244, 1892},
  {"vector field", 69420, 1897},
  {"invariance condition", 69604, 1902},
  {"Fr\[EAcute]chet derivative", 69878, 1909},
  {"generalized symmetries", 70086, 1914},
  {"Calculation of Potential Symmetries", 70307, 1919},
  {"extended equations", 70434, 1922},
  {"auxiliary system", 70592, 1926},
  {"conservation law", 70874, 1933},
  {"new variables", 71023, 1937},
  {"potential system", 71146, 1940},
  {"point symmetry", 72070, 1961},
  {"non-local symmetry", 72227, 1965},
  {"Definition: Potential symmetry", 72396, 1969},
  {"potential symmetry", 72520, 1972},
  {"integrating multipliers", 72655, 1975},
  {"Definition: Equivalence of conserved representations", 72939, 1981},
  {"common space of solutions", 73093, 1984},
  {"equivalent conserved representation", 73273, 1988},
  {"integrating multiplier", 73440, 1992},
  {"invariance criterion", 73580, 1995},
  {"adjoint Fr\[EAcute]chet derivative", 73734, 1998},
  {"tree of potential system", 73925, 2003},
  {"non-local properties", 74040, 2006},
  {"non-classical method", 74234, 2011},
  {"integrating factor", 74426, 2016},
  {"algorithm for potential symmetries", 74622, 2021},
  {"equivalent conservation law", 74811, 2026},
  {"potential representation", 74937, 2029},
  {"PotentialSymmetries[]", 75170, 2034},
  {"Applications for Potential Symmetries", 75513, 2042},
  {"potential systems", 75641, 2045},
  {"point symmetries of the potential system", 75823, 2049},
  {"The Diffusion Equation", 75987, 2053},
  {"A Nonlinear Reaction Diffusion Equation", 76177, 2057},
  {"nonlinear reaction diffusion equation", 76365, 2061},
  {"PotentialSystemsOnly", 76493, 2064},
  {"Cylindrical Korteweg-de Vries Equation", 76653, 2067},
  {"cylindrical KdV equation", 76792, 2070},
  {"cKdV equation", 76919, 2073},
  {"potential systems of the cKdV equation", 77071, 2076},
  {"OrderReduce", 77191, 2079},
  {"Infinitesimals[]", 77346, 2083},
  {"The Burgers Equation", 77489, 2086},
  {"Burgers equation", 77602, 2089},
  {"second-order dispersion effect", 77800, 2094}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 419, 7, 94, "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Potential Symmetries of Partial Differential Equations"],
Cell[2161, 60, 404, 9, 184, "Title",
  Evaluatable->False,
  CounterAssignments->{{"Title", 6}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2590, 73, 332, 9, 43, "Section",
  CounterAssignments->{{"Title", 7}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],
Cell[2925, 84, 1331, 24, 163, "Text",
  Evaluatable->False,
  CellTags->{
  "point symmetries", "non-classical symmetries", "local symmetries", 
    "local transformation", "derived systems of PDEs", 
    "affiliated system of PDEs", "non-local symmetries", 
    "potential symmetries"}],
Cell[4259, 110, 275, 5, 61, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4571, 120, 152, 6, 43, "Section",
  CellTags->"Basics of Potential Symmetries"],
Cell[4726, 128, 634, 14, 61, "Text",
  CellTags->{"weak symmetries", "strong symmetries", "reduction"}],
Cell[5363, 144, 102, 1, 33, "Definition",
  CellTags->"Definition: Topological Symmetry"],
Cell[5468, 147, 332, 9, 44, "Text"],
Cell[5803, 158, 358, 7, 61, "Text",
  CellTags->"topological"],
Cell[6164, 167, 370, 8, 61, "Text",
  CellTags->{
  "classical symmetries", "point transformations", 
    "infinitesimal transformation"}],
Cell[6537, 177, 235, 5, 23, "NumberedEquation",
  CellTags->"eq-7"],
Cell[6775, 184, 268, 6, 22, "NumberedEquation",
  CellTags->"eq-8"],
Cell[7046, 192, 367, 10, 44, "Text"],
Cell[7416, 204, 328, 8, 40, "NumberedEquation"],
Cell[7747, 214, 171, 5, 27, "Text"],
Cell[7921, 221, 352, 8, 40, "NumberedEquation"],
Cell[8276, 231, 553, 16, 44, "Text",
  CellTags->{
  "characteristics", "non-classical symmetries", "prolongation", 
    "vector field"}],
Cell[8832, 249, 259, 4, 33, "NumberedEquation"],
Cell[9094, 255, 332, 7, 44, "Text",
  CellTags->"invariance condition"],
Cell[9429, 264, 168, 3, 22, "NumberedEquation"],
Cell[9600, 269, 1370, 31, 95, "Text",
  CellTags->{
  "Fr\[EAcute]chet derivative", "point symmetries", "generalized symmetries", 
    "potential symmetries"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11007, 305, 162, 6, 43, "Section",
  CellTags->"Calculation of Potential Symmetries"],
Cell[11172, 313, 762, 20, 78, "Text",
  Evaluatable->False,
  CellTags->{"non-local symmetries", "extended equations"}],
Cell[11937, 335, 138, 2, 23, "NumberedEquation"],
Cell[12078, 339, 545, 16, 44, "Text",
  Evaluatable->False,
  CellTags->{"auxiliary system", "conservation law"}],
Cell[12626, 357, 360, 11, 27, "Text",
  Evaluatable->False],
Cell[12989, 370, 176, 3, 39, "NumberedEquation"],
Cell[13168, 375, 196, 7, 27, "Text",
  Evaluatable->False],
Cell[13367, 384, 321, 7, 23, "NumberedEquation"],
Cell[13691, 393, 282, 4, 39, "NumberedEquation"],
Cell[13976, 399, 710, 20, 63, "Text",
  CellTags->{"new variables", "potential system"}],
Cell[14689, 421, 257, 4, 24, "NumberedEquation"],
Cell[14949, 427, 363, 9, 25, "NumberedEquation"],
Cell[15315, 438, 308, 8, 23, "NumberedEquation"],
Cell[15626, 448, 1317, 28, 129, "Text",
  CellTags->{"potential system", "point symmetry", "non-local symmetry"}],
Cell[16946, 478, 98, 1, 33, "Definition",
  CellTags->"Definition: Potential symmetry"],
Cell[17047, 481, 178, 3, 27, "Text",
  CellTags->"potential system"],
Cell[17228, 486, 539, 9, 84, "NumberedEquation"],
Cell[17770, 497, 826, 31, 45, "Text"],
Cell[18599, 530, 589, 12, 61, "Text",
  CellTags->{"potential symmetry", "potential system"}],
Cell[19191, 544, 778, 16, 81, "Text",
  Evaluatable->False,
  CellTags->{"potential system", "integrating multipliers"}],
Cell[19972, 562, 168, 4, 24, "NumberedEquation"],
Cell[20143, 568, 47, 0, 27, "Text"],
Cell[20193, 570, 265, 5, 39, "NumberedEquation"],
Cell[20461, 577, 405, 8, 61, "Text"],
Cell[20869, 587, 387, 10, 22, "NumberedEquation"],
Cell[21259, 599, 267, 5, 24, "NumberedEquation"],
Cell[21529, 606, 278, 4, 44, "Text"],
Cell[21810, 612, 142, 1, 33, "Definition",
  CellTags->"Definition: Equivalence of conserved representations"],
Cell[21955, 615, 566, 13, 61, "Text",
  CellTags->{
  "common space of solutions", "equivalent conserved representation"}],
Cell[22524, 630, 275, 4, 61, "Text"],
Cell[22802, 636, 448, 12, 22, "NumberedEquation"],
Cell[23253, 650, 498, 10, 61, "Text",
  CellTags->{"integrating multiplier", "invariance criterion"}],
Cell[23754, 662, 174, 3, 23, "NumberedEquation"],
Cell[23931, 667, 759, 19, 61, "Text",
  CellTags->{
  "adjoint Fr\[EAcute]chet derivative", "invariance condition", 
    "characteristics"}],
Cell[24693, 688, 394, 5, 61, "Text"],
Cell[25090, 695, 315, 5, 44, "Text",
  CellTags->"tree of potential system"],
Cell[25408, 702, 812, 15, 95, "Text",
  CellTags->{
  "point symmetries", "non-local properties", "potential system", 
    "non-classical method"}],
Cell[26223, 719, 414, 9, 44, "Text",
  Evaluatable->False,
  CellTags->{"integrating factor", "algorithm for potential symmetries"}],
Cell[26640, 730, 139, 2, 20, "ListItem",
  CellTags->"integrating multipliers"],
Cell[26782, 734, 175, 5, 20, "ListItem",
  CellTags->"equivalent conservation law"],
Cell[26960, 741, 184, 4, 20, "ListItem",
  CellTags->"potential representation"],
Cell[27147, 747, 134, 4, 20, "ListItem"],
Cell[27284, 753, 546, 13, 82, "Text",
  CellTags->"PotentialSymmetries[]"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27867, 771, 165, 6, 43, "Section",
  CellTags->"Applications for Potential Symmetries"],
Cell[28035, 779, 661, 12, 95, "Text",
  CellTags->{
  "potential systems", "point symmetries of the potential system"}],
Cell[28699, 793, 357, 9, 46, "Text",
  CellTags->"PotentialSymmetries[]"],

Cell[CellGroupData[{
Cell[29081, 806, 154, 2, 41, "Subsection",
  CellTags->{
  "The Diffusion Equation", "A Nonlinear Reaction Diffusion Equation"}],
Cell[29238, 810, 276, 6, 44, "Text",
  CellTags->"nonlinear reaction diffusion equation"],

Cell[CellGroupData[{
Cell[29539, 820, 195, 4, 36, "Input"],
Cell[29737, 826, 484, 14, 34, "Output"]
}, Open  ]],
Cell[30236, 843, 591, 12, 65, "Text",
  CellTags->{"potential representation", "PotentialSystemsOnly"}],

Cell[CellGroupData[{
Cell[30852, 859, 234, 4, 55, "Input"],
Cell[31089, 865, 784, 11, 121, "Output"]
}, Open  ]],
Cell[31888, 879, 748, 12, 112, "Text",
  CellTags->"potential system"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32673, 896, 120, 1, 41, "Subsection",
  CellTags->"Cylindrical Korteweg-de Vries Equation"],
Cell[32796, 899, 359, 8, 44, "Text",
  CellTags->{"cylindrical KdV equation", "cKdV equation"}],

Cell[CellGroupData[{
Cell[33180, 911, 207, 4, 34, "Input"],
Cell[33390, 917, 425, 13, 32, "Output"]
}, Open  ]],
Cell[33830, 933, 130, 1, 27, "Text",
  CellTags->"potential systems of the cKdV equation"],

Cell[CellGroupData[{
Cell[33985, 938, 237, 5, 39, "Input"],
Cell[34225, 945, 6781, 206, 192, "Output"]
}, Open  ]],
Cell[41021, 1154, 862, 19, 103, "Text",
  CellTags->{"PotentialSymmetries[]", "OrderReduce", "auxiliary system"}],
Cell[41886, 1175, 484, 10, 65, "Text",
  CellTags->{"infinitesimal transformation", "Infinitesimals[]"}],

Cell[CellGroupData[{
Cell[42395, 1189, 267, 5, 23, "Input"],
Cell[42665, 1196, 1669, 54, 88, "Output"]
}, Open  ]],
Cell[44349, 1253, 1422, 32, 146, "Text"],

Cell[CellGroupData[{
Cell[45796, 1289, 411, 7, 55, "Input"],
Cell[46210, 1298, 2536, 84, 184, "Output"]
}, Open  ]],
Cell[48761, 1385, 762, 14, 99, "Text",
  CellTags->"potential symmetries"],

Cell[CellGroupData[{
Cell[49548, 1403, 99, 2, 23, "Input"],
Cell[49650, 1407, 5853, 132, 390, "Output"]
}, Open  ]],
Cell[55518, 1542, 204, 4, 44, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55759, 1551, 84, 1, 41, "Subsection",
  CellTags->"The Burgers Equation"],
Cell[55846, 1554, 132, 4, 27, "Text",
  CellTags->"Burgers equation"],

Cell[CellGroupData[{
Cell[56003, 1562, 192, 4, 23, "Input"],
Cell[56198, 1568, 262, 8, 23, "Output"]
}, Open  ]],
Cell[56475, 1579, 264, 4, 44, "Text",
  CellTags->{"second-order dispersion effect", "potential system"}],

Cell[CellGroupData[{
Cell[56764, 1587, 140, 3, 23, "Input"],
Cell[56907, 1592, 3196, 71, 155, "Output"]
}, Open  ]],
Cell[60118, 1666, 747, 18, 65, "Text",
  CellTags->"Burgers equation"],
Cell[60868, 1686, 147, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

