(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21565,        510]*)
(*NotebookOutlinePosition[     22262,        535]*)
(*  CellTagsIndexPosition[     22218,        531]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    RowBox[{
      RowBox[{"If", "[", 
        RowBox[{
          RowBox[{
            StyleBox["TrueQ",
              "MR"], 
            StyleBox["[",
              "MR"], 
            RowBox[{
              StyleBox["$VersionNumber",
                "MR"], " ", 
              StyleBox[">=",
                "MR"], " ", 
              StyleBox["3.0",
                "MR"]}], 
            StyleBox["]",
              "MR"]}], 
          StyleBox[",",
            "MR"], "\n", 
          RowBox[{
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox["\[ScriptCapitalD]",
                        FontSize->18], \(u_, x_\), "w_"], "[", "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(FrechetD[eqs_, u_, x_, w_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      TagBox[
                        StyleBox[
                          RowBox[{
                            StyleBox["ad",
                              FontSlant->"Italic"], 
                            StyleBox["\[ScriptCapitalD]",
                              FontSize->18]}]],
                        NotationBoxTag,
                        Editable->True], \(u_, x_\), "w_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(AFrechetD[eqs_, u_, x_, w_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox["\[ScriptCapitalE]",
                        FontSize->18], "u_", "x_"], "[", "den_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(EulerLagrange[den_, u_, x_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      RowBox[{"(", 
                        TagBox[
                          RowBox[{
                            StyleBox[
                              SuperscriptBox[
                                StyleBox["pr",
                                  FontSize->18,
                                  FontSlant->"Italic"], "k"],
                              FontSize->14], 
                            StyleBox[\(v\&\[RightVector]\),
                              FontSize->18,
                              FontSlant->"Italic"]}],
                          NotationBoxTag,
                          Editable->True], ")"}], \(u_, x_\), "para_"], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(Prolongation[eqs_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalD]\[ScriptE]\[ScriptT]Eq",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(sub_, par_\)], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(DeterminingEquations[eqs_, u_, x_, sub_, par_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "par_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(Infinitesimals[eqs_, u_, x_, par_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          
                          StyleBox[
                            "\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "para_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(NonClassicalPointSymmetries[eqs_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          
                          StyleBox[
                            "\[ScriptP]\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "para_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(PotentialSymmetries[eqs_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          
                          StyleBox[
                            "\[ScriptA]\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(para_, ap_\)], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(ApproximateSymmetries[eqs_, u_, x_, para_, ap_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalG]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(para_, ord_, sub_\)], 
                    "[", "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(Baecklund[eqs_, u_, x_, sub_, ord_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalR]\[ScriptD]\[ScriptC]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(\[Phi]_, \[Xi]_\)], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(LieReduction[eqs_, u_, x_, \[Xi]_, \[Phi]_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalC]\[ScriptO]\[ScriptM]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "para_"], "[", "inf_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLongLeftRightArrow]", " ", 
                TagBox[\(LieCommutatorTable[inf_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}]}], ",", "\n", "\n", 
          RowBox[{
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox["\[ScriptCapitalD]",
                        FontSize->18], \(u_, x_\), "w_"], "[", "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(FrechetD[eqs_, u_, x_, w_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      TagBox[
                        StyleBox[
                          RowBox[{
                            StyleBox["ad",
                              FontSlant->"Italic"], 
                            StyleBox["\[ScriptCapitalD]",
                              FontSize->18]}]],
                        NotationBoxTag,
                        Editable->True], \(u_, x_\), "w_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(AFrechetD[eqs_, u_, x_, w_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox["\[ScriptCapitalE]",
                        FontSize->18], "u_", "x_"], "[", "den_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(EulerLagrange[den_, u_, x_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      RowBox[{"(", 
                        TagBox[
                          RowBox[{
                            StyleBox[
                              SuperscriptBox[
                                StyleBox["pr",
                                  FontSize->18,
                                  FontSlant->"Italic"], "k"],
                              FontSize->14], 
                            StyleBox[\(v\&\[RightVector]\),
                              FontSize->18,
                              FontSlant->"Italic"]}],
                          NotationBoxTag,
                          Editable->True], ")"}], \(u_, x_\), "para_"], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(Prolongation[eqs_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalD]\[ScriptE]\[ScriptT]Eq",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(sub_, par_\)], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(DeterminingEquations[eqs_, u_, x_, sub_, par_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "par_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(Infinitesimals[eqs_, u_, x_, par_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox[
                            "\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "para_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(NonClassicalPointSymmetries[eqs_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          
                          StyleBox[
                            "\[ScriptP]\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "para_"], "[", "eqs_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(PotentialSymmetries[eqs_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          
                          StyleBox[
                            "\[ScriptA]\[ScriptCapitalP]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(para_, ap_\)], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(ApproximateSymmetries[eqs_, u_, x_, para_, ap_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalG]\[ScriptCapitalS]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(para_, ord_, sub_\)], 
                    "[", "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(Baecklund[eqs_, u_, x_, sub_, ord_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalR]\[ScriptD]\[ScriptC]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), \(\[Phi]_, \[Xi]_\)], "[", 
                    "eqs_", "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(LieReduction[eqs_, u_, x_, \[Xi]_, \[Phi]_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}], ";", "\n", "\n", 
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox[
                  RowBox[{
                    SubsuperscriptBox[
                      StyleBox[
                        TagBox[
                          StyleBox["\[ScriptCapitalC]\[ScriptO]\[ScriptM]",
                            FontSize->18],
                          NotationBoxTag,
                          Editable->True],
                        FontSize->18], \(u_, x_\), "para_"], "[", "inf_", 
                    "]"}],
                  NotationBoxTag,
                  Editable->True], " ", "\[DoubleLeftRightArrow]", " ", 
                TagBox[\(LieCommutatorTable[inf_, u_, x_, para_]\),
                  NotationBoxTag,
                  Editable->True]}], "]"}]}]}], "\n", "\t", "]"}], "\n", 
      "\t"}]], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 640}, {0, 424}},
AutoGeneratedPackage->Automatic,
WindowSize->{432, 252},
WindowMargins->{{7, Automatic}, {Automatic, 17}},
Visible->True
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 19852, 459, 1548, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

