(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    107348,       2886]*)
(*NotebookOutlinePosition[    108607,       2930]*)
(*  CellTagsIndexPosition[    108563,       2926]*)
(*WindowFrame->Palette*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Notation Templates for ",
  StyleBox["MathLie",
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]]
}], NotebookDefault,
  CellDingbat->None,
  CellMargins->{{Inherited, Inherited}, {10, Inherited}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakAbove->True,
  PageBreakBelow->False,
  ScriptMinSize->9,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24,
  FontWeight->"Plain",
  FontSlant->"Plain",
  FontColor->RGBColor[0, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[CellGroupData[{

Cell[TextData[{
  "Pallets for ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " "
}], NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0, 0.500008, 0],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[CellGroupData[{

Cell["Interactive functions", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[CellGroupData[{

Cell["Operators", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            
            ButtonBox[
              \(AFrechetD[\ \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"AFrechetD",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(DeterminingEquations[\ \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\ \ ]\ 
              \)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"DeterminingEquations",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(FrechetD[\ \[Placeholder], \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ \ \ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"FrechetD",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(FrechetProlong[\ \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ \ , \[Placeholder]\ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"FrechetProlong",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(Prolongation[\ \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"Prolongation",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
      FontColor->GrayLevel[0]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            
            ButtonBox[
              \(LieCommutatorTable[\ \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"LieCommutatorTable",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(SecondOrderAlgeras[\ \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"SecondOrderAlgeras",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(SolvableAlgebrasOfOrderN[\ \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ \ ]\)], 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        GridBox[ {{
                          ButtonBox[ 
                            StyleBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"VectorFieldRepresentation", 
                                  "\[Rule]", "True"}]}], FontColor -> 
                              GrayLevel[ 0]]]}}, RowSpacings -> 0, 
                          ColumnSpacings -> 0, GridDefaultElement :> 
                          ButtonBox[ "\\[Placeholder]"]]], NotebookDefault, 
                      FontWeight -> "Bold"]}, Editable -> False, 
                    WindowSize -> {244, 44}, WindowMargins -> {{Automatic, 
                    150}, {Automatic, 105}}, WindowFrame -> "Palette", 
                    WindowElements -> {}, WindowFrameElements -> "CloseBox", 
                    WindowClickSelect -> False, ShowCellBracket -> False, 
                    CellMargins -> {{0, 0}, {0, 0}}, Active -> True, 
                    CellOpen -> True, ShowCellLabel -> False, ShowCellTags -> 
                    False]]&),
              ButtonNote->"options"], 
            ButtonBox[\(\ ?\),
              ButtonData:>"SolvableAlgebrasOfOrderN",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
      FontColor->GrayLevel[0]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symmetry Calculation", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            
            ButtonBox[
              \(ApproximateSymmetries[\[Placeholder], \[Placeholder], 
                \[Placeholder], \[Placeholder], \[Placeholder]\)], "", 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        StyleBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"ApproximationOrder", "\[Rule]", 
                                  "\[Placeholder]"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"ScreenPrint", "\[Rule]", 
                                  "True"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                RowBox[ {"SubstitutionRules", "\[Rule]", 
                                  RowBox[ {"{", 
                                    
                                    RowBox[ {"\[Placeholder]", ",", 
                                      "\[Placeholder]"}], "}"}]}]}]]}}, 
                            RowSpacings -> 0, ColumnSpacings -> 0, 
                            GridDefaultElement :> ButtonBox[ 
                            "\\[Placeholder]"]], FontColor -> GrayLevel[ 
                          0]]], NotebookDefault, FontWeight -> "Bold"]}, 
                    Editable -> False, WindowSize -> {198, 74}, 
                    WindowMargins -> {{Automatic, 150}, {Automatic, 105}}, 
                    WindowFrame -> "Palette", WindowElements -> {}, 
                    WindowFrameElements -> "CloseBox", WindowClickSelect -> 
                    False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {
                    0, 0}}, Active -> True, CellOpen -> True, 
                    ShowCellLabel -> False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox[\(\ ?\),
              ButtonData:>"ApproximateSymmetries",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(ContactSymmetries[\[Placeholder], \[Placeholder], 
                \[Placeholder], \[Placeholder], \[Placeholder]]\)], "", 
            ButtonBox["\[Placeholder]"], 
            ButtonBox["\[Placeholder]"]},
          {
            ButtonBox[
              RowBox[{"Infinitesimals", 
                StyleBox["[",
                  FontColor->GrayLevel[0]], 
                StyleBox[" ",
                  FontColor->GrayLevel[0]], 
                
                StyleBox[\(\[Placeholder], \[Placeholder], \[Placeholder]\ , 
                  \[Placeholder], \[Placeholder]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[" ",
                  FontColor->GrayLevel[0]], 
                StyleBox["]",
                  FontColor->GrayLevel[0]]}]], "", 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        ButtonBox[ 
                          RowBox[ {",", 
                            RowBox[ {"SubstitutionRules", "\[Rule]", 
                              RowBox[ {"{", 
                                
                                RowBox[ {"\[Placeholder]", ",", 
                                  "\[Placeholder]"}], "}"}]}]}]]], 
                      NotebookDefault, FontWeight -> "Bold"]}, Editable -> 
                    False, WindowSize -> {196, 45}, WindowMargins -> {{
                    Automatic, 150}, {Automatic, 105}}, WindowFrame -> 
                    "Palette", WindowElements -> {}, WindowFrameElements -> 
                    "CloseBox", WindowClickSelect -> False, 
                    ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 
                    0}}, Active -> True, CellOpen -> True, ShowCellLabel -> 
                    False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox[\(\ ?\),
              ButtonData:>"Infinitesimals",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(LieBaecklundSymmetries[\[Placeholder], \[Placeholder], 
                \[Placeholder], \[Placeholder], \[Placeholder]]\)], "", 
            ButtonBox[""], 
            ButtonBox["\[Placeholder]"]},
          {
            ButtonBox[
              RowBox[{"NonClassicalPointSymmetries", "[", 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                
                StyleBox[\(\[Placeholder], \[Placeholder]\ , 
                  \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\),
                  FontWeight->"Plain"], 
                StyleBox[
                  RowBox[{
                    StyleBox[" ",
                      FontSlant->"Italic"], " "}]], "]"}]], "", 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        StyleBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                              RowBox[ {",", 
                                RowBox[ {"NonclassicalCases", "\[Rule]", 
                                  RowBox[ {"{", 
                                    
                                    RowBox[ {"\[Placeholder]", ",", 
                                      "\[Placeholder]"}], "}"}]}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"NonclassicalInfo", "\[Rule]", 
                                  "True"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"ScreenPrint", "\[Rule]", 
                                  "True"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                RowBox[ {"SubstitutionRules", "\[Rule]", 
                                  RowBox[ {"{", 
                                    
                                    RowBox[ {"\[Placeholder]", ",", 
                                      "\[Placeholder]"}], "}"}]}]}]]}}, 
                            RowSpacings -> 0, ColumnSpacings -> 0, 
                            GridDefaultElement :> ButtonBox[ 
                            "\\[Placeholder]"]], FontColor -> GrayLevel[ 
                          0]]], NotebookDefault, FontWeight -> "Bold"]}, 
                    Editable -> False, WindowSize -> {199, 90}, 
                    WindowMargins -> {{Automatic, 150}, {Automatic, 105}}, 
                    WindowFrame -> "Palette", WindowElements -> {}, 
                    WindowFrameElements -> "CloseBox", WindowClickSelect -> 
                    False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {
                    0, 0}}, Active -> True, CellOpen -> True, 
                    ShowCellLabel -> False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox[\(\ ?\),
              ButtonData:>"NonClassicalPointSymmetries",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            ButtonBox[
              RowBox[{"PointSymmetries", 
                StyleBox["[",
                  FontColor->GrayLevel[0]], 
                StyleBox[" ",
                  FontColor->GrayLevel[0]], 
                
                StyleBox[\(\[Placeholder], \[Placeholder], \[Placeholder]\ , 
                  \[Placeholder], \[Placeholder]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[" ",
                  FontColor->GrayLevel[0]], 
                StyleBox["]",
                  FontColor->GrayLevel[0]]}]], "", 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        ButtonBox[ 
                          RowBox[ {",", 
                            RowBox[ {"SubstitutionRules", "\[Rule]", 
                              RowBox[ {"{", 
                                
                                RowBox[ {"\[Placeholder]", ",", 
                                  "\[Placeholder]"}], "}"}]}]}]]], 
                      NotebookDefault, FontWeight -> "Bold"]}, Editable -> 
                    False, WindowSize -> {196, 45}, WindowMargins -> {{
                    Automatic, 150}, {Automatic, 105}}, WindowFrame -> 
                    "Palette", WindowElements -> {}, WindowFrameElements -> 
                    "CloseBox", WindowClickSelect -> False, 
                    ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 
                    0}}, Active -> True, CellOpen -> True, ShowCellLabel -> 
                    False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox[\(\ ?\),
              ButtonData:>"Infinitesimals",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(PotentialSymmetries[\ \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            "", 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        StyleBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"OrderReduce", "\[Rule]", 
                                  "True"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"PotentialSystemsOnly", "\[Rule]", 
                                  "True"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                
                                RowBox[ {"ScreenPrint", "\[Rule]", 
                                  "True"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", 
                                RowBox[ {"SubstitutionRules", "\[Rule]", 
                                  RowBox[ {"{", 
                                    
                                    RowBox[ {"\[Placeholder]", ",", 
                                      "\[Placeholder]"}], "}"}]}]}]]}}, 
                            RowSpacings -> 0, ColumnSpacings -> 0, 
                            GridDefaultElement :> ButtonBox[ 
                            "\\[Placeholder]"]], FontColor -> GrayLevel[ 
                          0]]], NotebookDefault, FontWeight -> "Bold"]}, 
                    Editable -> False, WindowSize -> {208, 89}, 
                    WindowMargins -> {{Automatic, 150}, {Automatic, 105}}, 
                    WindowFrame -> "Palette", WindowElements -> {}, 
                    WindowFrameElements -> "CloseBox", WindowClickSelect -> 
                    False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {
                    0, 0}}, Active -> True, CellOpen -> True, 
                    ShowCellLabel -> False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox[\(\ ?\),
              ButtonData:>"PotentialSymmetries",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        ColumnAlignments->{Left, Center},
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
      FontColor->GrayLevel[0]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution Steps", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            
            ButtonBox[
              \(BackTrafoCanonical[\[Placeholder], \[Placeholder], 
                \[Placeholder], \[Placeholder], \[Placeholder], 
                \[Placeholder]]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"BackTrafoCanonical",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(CanonicalRepresentation[\ \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ \ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"CanonicalRepresentation",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(CanonicalVariables[\ \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"CanonicalVariables",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(LieReduction[\ \[Placeholder], \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"LieReduction",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(SubGroupForReductions[\[Placeholder], \[Placeholder]]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"SubGroupForReductions",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(SecondOrderIntegrate[\ \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ \ ]\ \)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"SecondOrderIntegrate",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
      FontColor->GrayLevel[0]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Miscellaneous", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            ButtonBox[\(LTF[\[Placeholder]]\)], 
            ButtonBox["",
              ButtonFunction:>(#&)], 
            ButtonBox[\(\ ?\),
              ButtonData:>"LTF",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
      FontColor->GrayLevel[0]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Batch functions", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            ButtonBox[\(Lie[\ \[Placeholder]\ , \[Placeholder]\ \ ]\ \)], 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        StyleBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                              
                              RowBox[ {",", "AdjointAlgebra", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "Ansatz", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "CommonDivisor", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "CommutatorTable", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "DerivativeSubstitution", 
                                "\[Rule]", 
                                RowBox[ {"{", 
                                  
                                  RowBox[ {"\[Placeholder]", ",", 
                                    "\[Placeholder]"}], "}"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "EquationS", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "FirstCanonical", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "FrechetProlongation", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "Info", "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "LaTeX", "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "NonclassicalCases", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "NonclassicalInfo", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "NonclassicalSymmetries", 
                                "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "OrderReduce", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "PotSymmetry", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "ProlongationOrder", "\[Rule]", 
                                "\[Placeholder]"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "ScreenPrint", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SolveGeneral", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Statistics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "StructureConstants", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SymmetryGraphics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SymmetryGroup", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "TraceSteps", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Tresse", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "UsePreviousCalculations", 
                                "\[Rule]", "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "VectorGraphics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Warning", "\[Rule]", 
                                "True"}]]}}, RowSpacings -> 0, 
                            ColumnSpacings -> 0, GridDefaultElement :> 
                            ButtonBox[ "\\[Placeholder]"]], FontColor -> 
                          GrayLevel[ 0]]], NotebookDefault, FontWeight -> 
                      "Bold"]}, Editable -> False, WindowSize -> {237, 453}, 
                    WindowMargins -> {{Automatic, 150}, {Automatic, 105}}, 
                    WindowFrame -> "Palette", WindowElements -> {}, 
                    WindowFrameElements -> "CloseBox", WindowClickSelect -> 
                    False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {
                    0, 0}}, Active -> True, CellOpen -> True, 
                    ShowCellLabel -> False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox["?",
              ButtonData:>"Lie",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(LieApproximation[\ \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ \ ]\)], 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        StyleBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                              
                              RowBox[ {",", " ", "ApproximationOrder", 
                                "\[Rule]", "\[Placeholder]"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "ScreenPrint", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "SubstitutionRules", "\[Rule]", 
                                RowBox[ {"{", 
                                  
                                  RowBox[ {"\[Placeholder]", ",", 
                                    "\[Placeholder]"}], "}"}]}]]}}, 
                            RowSpacings -> 0, ColumnSpacings -> 0, 
                            GridDefaultElement :> ButtonBox[ 
                            "\\[Placeholder]"]], FontColor -> GrayLevel[ 
                          0]]], NotebookDefault, FontWeight -> "Bold"]}, 
                    Editable -> False, WindowSize -> {198, 74}, 
                    WindowMargins -> {{Automatic, 150}, {Automatic, 105}}, 
                    WindowFrame -> "Palette", WindowElements -> {}, 
                    WindowFrameElements -> "CloseBox", WindowClickSelect -> 
                    False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {
                    0, 0}}, Active -> True, CellOpen -> True, 
                    ShowCellLabel -> False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox["?",
              ButtonData:>"LieApproximation",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            
            ButtonBox[
              \(LieEquations[\ \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\ , 
                \[Placeholder]\ , \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        GridBox[ {{
                          ButtonBox[ 
                            StyleBox[ 
                              RowBox[ {"SubstitutionRules", "\[Rule]", 
                                RowBox[ {"{", 
                                  
                                  RowBox[ {"\[Placeholder]", ",", 
                                    "\[Placeholder]"}], "}"}]}], FontColor -> 
                              GrayLevel[ 0]]]}}, RowSpacings -> 0, 
                          ColumnSpacings -> 0, GridDefaultElement :> 
                          ButtonBox[ "\\[Placeholder]"]]], NotebookDefault, 
                      FontWeight -> "Bold"]}, Editable -> False, 
                    WindowSize -> {185, 42}, WindowMargins -> {{Automatic, 
                    150}, {Automatic, 105}}, WindowFrame -> "Palette", 
                    WindowElements -> {}, WindowFrameElements -> "CloseBox", 
                    WindowClickSelect -> False, ShowCellBracket -> False, 
                    CellMargins -> {{0, 0}, {0, 0}}, Active -> True, 
                    CellOpen -> True, ShowCellLabel -> False, ShowCellTags -> 
                    False]]&),
              ButtonNote->"options"], 
            ButtonBox["?",
              ButtonData:>"LieEquations",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            ButtonBox[\(LieSolve[\ \[Placeholder]\ , \[Placeholder]\ \ ]\)], 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        StyleBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                              
                              RowBox[ {",", "AdjointAlgebra", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "Ansatz", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "CommonDivisor", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "CommutatorTable", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "DerivativeSubstitution", 
                                "\[Rule]", 
                                RowBox[ {"{", 
                                  RowBox[ {"\[Placeholder]", ",", 
                                    "\[Placeholder]"}], "}"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "EquationS", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "FirstCanonical", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "FrechetProlongation", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "Info", "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "LaTeX", "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "NonclassicalCases", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "NonclassicalInfo", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "NonclassicalSymmetries", 
                                "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "OrderReduce", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "PotSymmetry", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "ProlongationOrder", "\[Rule]", 
                                "\[Placeholder]"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "ScreenPrint", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SolveGeneral", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Statistics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "StructureConstants", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SymmetryGraphics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SymmetryGroup", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "TraceSteps", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Tresse", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "UsePreviousCalculations", 
                                "\[Rule]", "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "VectorGraphics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Warning", "\[Rule]", 
                                "True"}]]}}, RowSpacings -> 0, 
                            ColumnSpacings -> 0, GridDefaultElement :> 
                            ButtonBox[ "\\[Placeholder]"]], FontColor -> 
                          GrayLevel[ 0]]], NotebookDefault, FontWeight -> 
                      "Bold"]}, Editable -> False, WindowSize -> {237, 453}, 
                    WindowMargins -> {{Automatic, 150}, {Automatic, 105}}, 
                    WindowFrame -> "Palette", WindowElements -> {}, 
                    WindowFrameElements -> "CloseBox", WindowClickSelect -> 
                    False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {
                    0, 0}}, Active -> True, CellOpen -> True, 
                    ShowCellLabel -> False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox["?",
              ButtonData:>"LieSolve",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]},
          {
            ButtonBox[
              RowBox[{
                StyleBox["LieStructureForm",
                  FontColor->GrayLevel[0]], 
                StyleBox["[",
                  FontColor->GrayLevel[0]], 
                StyleBox[\(\[Placeholder]\ , \[Placeholder]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[
                  RowBox[{
                    StyleBox[" ",
                      FontColor->GrayLevel[0]], 
                    StyleBox[" ",
                      FontSlant->"Italic",
                      FontColor->GrayLevel[0]]}]], 
                StyleBox["]",
                  FontColor->GrayLevel[0]]}]], 
            ButtonBox[
              StyleBox["options",
                "SmallText",
                FontWeight->"Plain"],
              ButtonFunction:>(NotebookPut[ 
                  Notebook[ {
                    Cell[ 
                      BoxData[ 
                        StyleBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                              
                              RowBox[ {",", "AdjointAlgebra", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "Ansatz", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "CommonDivisor", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "CommutatorTable", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "DerivativeSubstitution", 
                                "\[Rule]", 
                                RowBox[ {"{", 
                                  
                                  RowBox[ {"\[Placeholder]", ",", 
                                    "\[Placeholder]"}], "}"}]}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "EquationS", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "FirstCanonical", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "FrechetProlongation", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "Info", "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "LaTeX", "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              RowBox[ {",", "NonclassicalCases", "\[Rule]", 
                                RowBox[ {"{", "\[Placeholder]", "}"}]}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "NonclassicalInfo", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "NonclassicalSymmetries", 
                                "\[Rule]", "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "OrderReduce", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "PotSymmetry", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "ProlongationOrder", "\[Rule]", 
                                "\[Placeholder]"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "ScreenPrint", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SolveGeneral", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Statistics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "StructureConstants", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SymmetryGraphics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "SymmetryGroup", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "TraceSteps", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Tresse", "\[Rule]", 
                                "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "UsePreviousCalculations", 
                                "\[Rule]", "False"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "VectorGraphics", "\[Rule]", 
                                "True"}]]}, {
                            ButtonBox[ 
                              
                              RowBox[ {",", "Warning", "\[Rule]", 
                                "True"}]]}}, RowSpacings -> 0, 
                            ColumnSpacings -> 0, GridDefaultElement :> 
                            ButtonBox[ "\\[Placeholder]"]], FontColor -> 
                          GrayLevel[ 0]]], NotebookDefault, FontWeight -> 
                      "Bold"]}, Editable -> False, WindowSize -> {237, 453}, 
                    WindowMargins -> {{Automatic, 150}, {Automatic, 105}}, 
                    WindowFrame -> "Palette", WindowElements -> {}, 
                    WindowFrameElements -> "CloseBox", WindowClickSelect -> 
                    False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {
                    0, 0}}, Active -> True, CellOpen -> True, 
                    ShowCellLabel -> False, ShowCellTags -> False]]&),
              ButtonNote->"options"], 
            ButtonBox["?",
              ButtonData:>"LieStructureForm",
              ButtonStyle->"AddOnsLink",
              ButtonFrame->"Palette"]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
      FontColor->GrayLevel[0]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolic pallet", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox["\[ScriptCapitalD]",
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  "\[Placeholder]"], "[", "\[Placeholder]", "]"}],
              ButtonNote->"Fr\[EGrave]chet derivative"], 
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  TagBox[
                    StyleBox[
                      RowBox[{
                        StyleBox["ad",
                          FontSlant->"Italic"], 
                        StyleBox["\[ScriptCapitalD]",
                          FontSize->18]}]],
                    NotationBoxTag,
                    Editable->True], \(\[Placeholder], \[Placeholder]\), 
                  "\[Placeholder]"], "[", "\[Placeholder]", "]"}],
              ButtonNote->"adjoint Fr\[EGrave]chet derivative"]},
          {
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox["\[ScriptCapitalE]",
                    FontSize->18], "\[Placeholder]", "\[Placeholder]"], "[", 
                "\[Placeholder]", "]"}],
              ButtonNote->"Euler derivative"], 
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      StyleBox["\[ScriptCapitalC]\[ScriptO]\[ScriptM]",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  "\[Placeholder]"], "[", "\[Placeholder]", "]"}],
              ButtonNote->"Commutator"]},
          {
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  RowBox[{"(", 
                    TagBox[
                      RowBox[{
                        StyleBox[
                          SuperscriptBox[
                            StyleBox["pr",
                              FontSize->18,
                              FontSlant->"Italic"], "k"],
                          FontSize->14], 
                        StyleBox[\(v\&\[RightVector]\),
                          FontSize->18,
                          FontSlant->"Italic"]}],
                      NotationBoxTag,
                      Editable->True], ")"}], \(\[Placeholder], 
                  \[Placeholder]\), "\[Placeholder]"], "[", "\[Placeholder]", 
                "]"}],
              ButtonNote->"Prolongation of a vector field"], 
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      StyleBox["\[ScriptCapitalD]\[ScriptE]\[ScriptT]Eq",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  \(\[Placeholder], \[Placeholder]\)], "[", "\[Placeholder]", 
                "]"}],
              ButtonNote->"Determining equations"]},
          {
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  "\[Placeholder]"], "[", "\[Placeholder]", "]"}],
              ButtonNote->"Point symmetries"], 
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      
                      StyleBox[
                        "\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  "\[Placeholder]"], "[", "\[Placeholder]", "]"}],
              ButtonNote->"non-classical Point symmetries"]},
          {
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      
                      StyleBox[
                        "\[ScriptP]\[ScriptCapitalP]\[ScriptCapitalS]",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  "\[Placeholder]"], "[", "\[Placeholder]", "]"}],
              ButtonNote->"Potential symmetries"], 
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      
                      StyleBox[
                        "\[ScriptA]\[ScriptCapitalP]\[ScriptCapitalS]",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  \(\[Placeholder], \[Placeholder]\)], "[", "\[Placeholder]", 
                "]"}],
              ButtonNote->"Approximate symmetries"]},
          {
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      StyleBox["\[ScriptCapitalG]\[ScriptCapitalS]",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  \(\[Placeholder], \[Placeholder], \[Placeholder]\)], "[", 
                "\[Placeholder]", "]"}],
              ButtonNote->"Generalized symmetries"], 
            ButtonBox[
              RowBox[{
                SubsuperscriptBox[
                  StyleBox[
                    TagBox[
                      StyleBox["\[ScriptCapitalR]\[ScriptD]\[ScriptC]",
                        FontSize->18],
                      NotationBoxTag,
                      Editable->True],
                    FontSize->18], \(\[Placeholder], \[Placeholder]\), 
                  \(\[Placeholder], \[Placeholder]\)], "[", "\[Placeholder]", 
                "]"}],
              ButtonNote->"Reduction"]}
          },
        RowSpacings->0,
        ColumnSpacings->0,
        GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
      FontColor->GrayLevel[0]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell["\<\
Put your pointer over the symbol to see
its meaning.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  TextJustification->1,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text",
  FontFamily->"Arial"]
}, Closed]],

Cell[CellGroupData[{

Cell["Notation help", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[CellGroupData[{

Cell["Symbols", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[TextData[
"Symbols in the template represent a single variable or a list of variables:\n\
x: independent variables\nu: dependent variables\nw: test functions\n\
\[Gamma]: parameters of the equations\n\[CapitalDelta]: differential \
equations\n\[Delta]: substitution terms\n\[Xi], \[Phi]: infinitesimals"], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  TextJustification->1,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text",
  FontFamily->"Arial"]
}, Closed]],

Cell[CellGroupData[{

Cell["Notation", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[TextData[{
  "Fr\[EAcute]chet derivative  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["\[ScriptCapitalD]",
              FontSize->18], \(u, x\), "w"], "[", "\[CapitalDelta]", "]"}], 
        TraditionalForm]]],
  "\nadjoint Fr\[EAcute]chet derivative ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            TagBox[
              StyleBox[
                RowBox[{
                  StyleBox["ad",
                    FontSlant->"Italic"], 
                  StyleBox["\[ScriptCapitalD]",
                    FontSize->18]}]],
              NotationBoxTag,
              Editable->True], \(u, x\), "w"], "[", "\[CapitalDelta]", "]"}], 
        TraditionalForm]]],
  "\nEuler derivative ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox["\[ScriptCapitalE]",
              FontSize->18], "u", "x"], "[", "\[CapitalDelta]", "]"}], 
        TraditionalForm]]],
  "\nCommutator ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalC]\[ScriptO]\[ScriptM]",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), "\[Gamma]"], "[", "\[Xi]", "]"}], 
        TraditionalForm]]],
  "\nProlongation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            RowBox[{"(", 
              TagBox[
                RowBox[{
                  StyleBox[
                    SuperscriptBox[
                      StyleBox["pr",
                        FontSize->18,
                        FontSlant->"Italic"], "k"],
                    FontSize->14], 
                  StyleBox[\(v\&\[RightVector]\),
                    FontSize->18,
                    FontSlant->"Italic"]}],
                NotationBoxTag,
                Editable->True], ")"}], \(u, x\), "\[Gamma]"], "[", 
          "\[CapitalDelta]", "]"}], TraditionalForm]]],
  "\nDetermining equations ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalD]\[ScriptE]\[ScriptT]Eq",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), \(\[Delta], \[Gamma]\)], "[", 
          "\[CapitalDelta]", "]"}], TraditionalForm]]],
  "\nPoint symmetries ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), "\[Gamma]"], "[", "\[CapitalDelta]", 
          "]"}], TraditionalForm]]],
  "\nNon-classical point symmetries ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), "\[Gamma]"], "[", "\[CapitalDelta]", 
          "]"}], TraditionalForm]]],
  "\nPotential symmetries ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptP]\[ScriptCapitalP]\[ScriptCapitalS]",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), "\[Gamma]"], "[", "\[CapitalDelta]", 
          "]"}], TraditionalForm]]],
  "\nApproximate symmetries ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptA]\[ScriptCapitalP]\[ScriptCapitalS]",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), \(\[Gamma], \[Epsilon]\)], "[", 
          "\[CapitalDelta]", "]"}], TraditionalForm]]],
  "\nGeneralized symmetries ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalG]\[ScriptCapitalS]",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), \(\[Gamma], n, \[Delta]\)], "[", 
          "\[CapitalDelta]", "]"}], TraditionalForm]]],
  "\nSimilarity reduction ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalR]\[ScriptD]\[ScriptC]",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \(u, x\), \(\[Phi], \[Xi]\)], "[", 
          "\[CapitalDelta]", "]"}], TraditionalForm]]]
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  TextJustification->1,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text",
  FontFamily->"Arial"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", NotebookDefault,
  CellDingbat->None,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{Inherited, Inherited}, {8, Inherited}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  ScriptMinSize->9,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold",
  FontSlant->"Plain",
  FontColor->RGBColor[0, 0.500008, 0],
  FontVariations->{"Underline"->False,
  "StrikeThrough"->False}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox["\[ScriptCapitalD]",
          FontSize->18], \({u, v}, {x, t}\), \({w, z}\)], "[", 
      \({\[PartialD]\_t u[x, t], \[PartialD]\_t v[x, t]}\), "]"}]], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["w", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}], ",", "0"}], 
          "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            RowBox[{
              SuperscriptBox["z", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}]}], "}"}]}], 
      "}"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        TagBox[
          StyleBox[
            RowBox[{
              StyleBox["ad",
                FontSlant->"Italic"], 
              StyleBox["\[ScriptCapitalD]",
                FontSize->18]}]],
          NotationBoxTag,
          Editable->True], \({u, v}, {x, t}\), \({w, z}\)], "[", 
      \({\[PartialD]\_t u[x, t], \[PartialD]\_t v[x, t]}\), "]"}]], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                SuperscriptBox["w", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], ",", 
            "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            RowBox[{"-", 
              RowBox[{
                SuperscriptBox["z", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}]}], 
          "}"}]}], "}"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox["\[ScriptCapitalE]",
          FontSize->18], \({u}\), \({x, t}\)], "[", 
      \(\((\[PartialD]\_t u[x, t])\)\^2\), "]"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(-2\), " ", 
        RowBox[{
          SuperscriptBox["u", 
            TagBox[\((0, 2)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t\), "]"}]}], "}"}]], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SubsuperscriptBox[
          RowBox[{"(", 
            TagBox[
              RowBox[{
                StyleBox[
                  SuperscriptBox[
                    StyleBox["pr",
                      FontSize->18,
                      FontSlant->"Italic"], "k"],
                  FontSize->14], 
                StyleBox[\(v\&\[RightVector]\),
                  FontSize->18,
                  FontSlant->"Italic"]}],
              NotationBoxTag,
              Editable->True], ")"}], \({u}, {x, t}\), \({}\)], "[", 
        \({\[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)u[x, t]}\), "]"}], 
      "//", "LieTraditionalForm"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    \({\(-u\_x\)\ \((\[Xi]\_1)\)\_t - u\_t\ u\_x\ \((\[Xi]\_1)\)\_u - 
        u\_t\ \((\[Xi]\_2)\)\_t - u\_t\%2\ \((\[Xi]\_2)\)\_u + 
        \((\[Phi]\_1)\)\_t + u\_t\ \((\[Phi]\_1)\)\_u + 
        2\ u\_x\ \((\[Xi]\_2)\)\_u\ u\_\(x, t\) + 
        2\ \((\[Xi]\_2)\)\_x\ u\_\(x, t\) + 
        3\ u\_x\ \((\[Xi]\_1)\)\_u\ u\_\(x, x\) + 
        2\ \((\[Xi]\_1)\)\_x\ u\_\(x, x\) + 
        u\_t\ \((\[Xi]\_2)\)\_u\ u\_\(x, x\) - 
        \((\[Phi]\_1)\)\_u\ u\_\(x, x\) + u\_x\%3\ \((\[Xi]\_1)\)\_\(u, u\) + 
        2\ u\_x\%2\ \((\[Xi]\_1)\)\_\(x, u\) + 
        u\_x\ \((\[Xi]\_1)\)\_\(x, x\) + 
        u\_t\ u\_x\%2\ \((\[Xi]\_2)\)\_\(u, u\) + 
        2\ u\_t\ u\_x\ \((\[Xi]\_2)\)\_\(x, u\) + 
        u\_t\ \((\[Xi]\_2)\)\_\(x, x\) - u\_x\%2\ \((\[Phi]\_1)\)\_\(u, u\) - 
        2\ u\_x\ \((\[Phi]\_1)\)\_\(x, u\) - \((\[Phi]\_1)\)\_\(x, x\)}\)], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          SubsuperscriptBox[
            StyleBox[
              TagBox[
                StyleBox["\[ScriptCapitalD]\[ScriptE]\[ScriptT]Eq",
                  FontSize->18],
                NotationBoxTag,
                Editable->True],
              FontSize->18], \({u}, {x, t}\), 
            \({\[PartialD]\_t u[x, t]}, {}\)], "[", 
          \({\[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)u[x, t]}\), "]"}], 
        "//", "LieTraditionalForm"}], "//", "TableForm"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\((\[Xi]\_1)\)\_u\)},
          {\(\((\[Xi]\_2)\)\_u\)},
          {\(\((\[Phi]\_1)\)\_\(u, u\)\)},
          {\(\((\[Xi]\_2)\)\_x\)},
          {
            \(\(-\((\[Xi]\_1)\)\_t\) + \((\[Xi]\_1)\)\_\(x, x\) - 
              2\ \((\[Phi]\_1)\)\_\(x, u\)\)},
          {\(\((\[Phi]\_1)\)\_t - \((\[Phi]\_1)\)\_\(x, x\)\)},
          {\(2\ \((\[Xi]\_1)\)\_x - \((\[Xi]\_2)\)\_t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Subscript[ 
          Subscript[ \[Xi], 1], u], 
        Subscript[ 
          Subscript[ \[Xi], 2], u], 
        Subscript[ 
          Subscript[ \[Phi], 1], u, u], 
        Subscript[ 
          Subscript[ \[Xi], 2], x], 
        Plus[ 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 1], t]], 
          Subscript[ 
            Subscript[ \[Xi], 1], x, x], 
          Times[ -2, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, u]]], 
        Plus[ 
          Subscript[ 
            Subscript[ \[Phi], 1], t], 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Phi], 1], x, x]]], 
        Plus[ 
          Times[ 2, 
            Subscript[ 
              Subscript[ \[Xi], 1], x]], 
          Times[ -1, 
            Subscript[ 
              Subscript[ \[Xi], 2], t]]]}]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox[
          TagBox[
            StyleBox["\[ScriptCapitalP]\[ScriptCapitalS]",
              FontSize->18],
            NotationBoxTag,
            Editable->True],
          FontSize->18], \({u}, {x, t}\), \({\[Alpha]}\)], "[", 
      \(\[PartialD]\_t u[x, t] - \[Alpha] \[PartialD]\_\(x, x\)u[x, t] == 0
        \), "]"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({xi[1] \[Rule] 
            Function[{x, t, u}, k5 + k6\ x + k4\ t\ x - 2\ k2\ t\ \[Alpha]], 
          xi[2] \[Rule] Function[{x, t, u}, k3 + t\ \((2\ k6 + k4\ t)\)], 
          phi[1] \[Rule] 
            Function[{x, t, u}, 
              u\ \((k1 - \(k4\ t\)\/2 + k2\ x - \(k4\ x\^2\)\/\(4\ \[Alpha]\))
                    \) + \(free[1]\)[x, t]]}\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"-", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[\(free[1]\), 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}], 
                "\[Alpha]"]}], "+", 
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t\), "]"}]}], "}"}]}], 
      "}"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox[
          TagBox[
            StyleBox["\[ScriptN]\[ScriptCapitalP]\[ScriptCapitalS]",
              FontSize->18],
            NotationBoxTag,
            Editable->True],
          FontSize->18], \(u, {x, t}\), \({\[Alpha]}\)], "[", 
      \(\[PartialD]\_t u[x, t] - \[Alpha]\ \[PartialD]\_\(x, x\)u[x, t] == 0
        \), "]"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[1]\), 
            TagBox[\((0, 0, 2)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((0, 0, 2)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          SuperscriptBox[\(xi[2]\), 
            TagBox[\((1, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}], ",", 
        RowBox[{
          RowBox[{\(\(phi[1]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{\(\(xi[1]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{"\[Alpha]", " ", \(\(xi[2]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((2, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}]}], 
        ",", 
        RowBox[{
          RowBox[{
          "2", " ", \(\(phi[1]\)[x, t, u[x, t]]\), " ", 
            \(\(xi[2]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{
          \(\(phi[1]\)[x, t, u[x, t]]\), " ", \(\(xi[1]\)[x, t, u[x, t]]\), 
            " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "-", 
          RowBox[{\(\(xi[2]\)[x, t, u[x, t]]\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{
          \(\(xi[1]\)[x, t, u[x, t]]\), " ", \(\(xi[2]\)[x, t, u[x, t]]\), 
            " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "-", 
          RowBox[{
          "2", " ", \(\(xi[1]\)[x, t, u[x, t]]\), " ", 
            \(\(xi[2]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{\(\(xi[1]\)[x, t, u[x, t]]\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "-", 
          RowBox[{
          "2", " ", "\[Alpha]", " ", \(\(xi[2]\)[x, t, u[x, t]]\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(phi[1]\), 
                TagBox[\((1, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{"\[Alpha]", " ", \(\(xi[2]\)[x, t, u[x, t]]\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((2, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}]}], 
        ",", 
        RowBox[{
          RowBox[{\(\(phi[1]\)[x, t, u[x, t]]\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "-", 
          RowBox[{\(\(xi[2]\)[x, t, u[x, t]]\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(phi[1]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{
          \(\(phi[1]\)[x, t, u[x, t]]\), " ", \(\(xi[2]\)[x, t, u[x, t]]\), 
            " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "-", 
          RowBox[{
          "2", " ", \(\(phi[1]\)[x, t, u[x, t]]\), " ", 
            \(\(xi[2]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{
          \(\(phi[1]\)[x, t, u[x, t]]\), " ", \(\(xi[1]\)[x, t, u[x, t]]\), 
            " ", 
            RowBox[{
              SuperscriptBox[\(xi[2]\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{"\[Alpha]", " ", \(\(xi[2]\)[x, t, u[x, t]]\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(phi[1]\), 
                TagBox[\((2, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}]}], 
        ",", 
        RowBox[{
          RowBox[{"2", " ", \(\(xi[1]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "+", 
          RowBox[{"\[Alpha]", " ", \(\(xi[2]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(phi[1]\), 
                TagBox[\((0, 0, 2)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), "]"}]}], 
          "-", 
          RowBox[{
          "2", " ", "\[Alpha]", " ", \(\(xi[2]\)[x, t, u[x, t]]\), " ", 
            RowBox[{
              SuperscriptBox[\(xi[1]\), 
                TagBox[\((1, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, t, u[x, t]\), 
              "]"}]}]}]}], "}"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox[
          TagBox[
            StyleBox["\[ScriptA]\[ScriptCapitalP]\[ScriptCapitalS]",
              FontSize->18],
            NotationBoxTag,
            Editable->True],
          FontSize->18], \(u, {x, t}\), \({\[Alpha], \[Epsilon]}, 
        \[Epsilon]\)], "[", 
      \(\[PartialD]\_t u[x, t] - \[Alpha] \[PartialD]\_\(x, x\)u[x, t] + 
          \[Epsilon]u[x, t] \[PartialD]\_x u[x, t] == 0\), "]"}]], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox[
          TagBox[
            StyleBox["\[ScriptCapitalR]\[ScriptD]\[ScriptC]",
              FontSize->18],
            NotationBoxTag,
            Editable->True],
          FontSize->18], \({u}, {x, t}\), \({1}, {x, 2  t}\)], "[", 
      \({\[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)u[x, t]}\), "]"}]], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({t\/x\^2 == zeta1}\), ",", \({u - Log[x] == F1[t\/x\^2]}\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"1", "+", 
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}], "-", 
              RowBox[{"6", " ", "zeta1", " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
              RowBox[{"4", " ", \(zeta1\^2\), " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[DoublePrime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
            "0"}], "}"}]}], "}"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        SubsuperscriptBox[
          StyleBox[
            TagBox[
              StyleBox["\[ScriptCapitalC]\[ScriptO]\[ScriptM]",
                FontSize->18],
              NotationBoxTag,
              Editable->True],
            FontSize->18], \({u}, {x, t}\), \({\[Alpha]}\)], "[", 
        \({xi[1] \[Rule] 
            Function[{x, t, u}, k5 + k6\ x + k4\ t\ x - 2\ k2\ t\ \[Alpha]], 
          xi[2] \[Rule] Function[{x, t, u}, k3 + t\ \((2\ k6 + k4\ t)\)], 
          phi[1] \[Rule] 
            Function[{x, t, u}, 
              u\ \((k1 - \(k4\ t\)\/2 + k2\ x - \(k4\ x\^2\)\/\(4\ \[Alpha]\))
                  \)]}\), "]"}], "//", "TableForm"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    TagBox[GridBox[{
          {"0", "0", "0", "0", "0", "0"},
          {"0", "0", \(\(-2\)\ \[Alpha]\ V[5]\), "0", \(V[1]\), \(V[2]\)},
          {"0", \(2\ \[Alpha]\ V[5]\), "0", \(V[1]\/2 - V[6]\), "0", 
            \(\(-2\)\ V[3]\)},
          {"0", "0", \(\(-\(V[1]\/2\)\) + V[6]\), "0", 
            \(-\(V[2]\/\(2\ \[Alpha]\)\)\), \(2\ V[4]\)},
          {"0", \(-V[1]\), "0", \(V[2]\/\(2\ \[Alpha]\)\), "0", \(-V[5]\)},
          {"0", \(-V[2]\), \(2\ V[3]\), \(\(-2\)\ V[4]\), \(V[5]\), "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubsuperscriptBox[
        StyleBox[
          TagBox[
            StyleBox["\[ScriptCapitalG]\[ScriptCapitalS]",
              FontSize->18],
            NotationBoxTag,
            Editable->True],
          FontSize->18], \({u}, {x, t}\), \({}, 
        2, {\[PartialD]\_t u[x, t]}\)], "[", 
      \({\[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)u[x, t]}\), "]"}]], 
  NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{\(QC[1]\), "[", 
              RowBox[{"t", ",", "x", ",", \(u[x, t]\), ",", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((0, 2)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((1, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((2, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}], 
            "\[Rule]", 
            RowBox[{
            \(1\/4\ \((4\ k1 - 4\ k7 + 2\ k6\ t + 2\ k3\ x + k6\ x\^2)\)\ 
                u[x, t]\), "+", \(\(free[1]\)[t, x]\), "+", 
              RowBox[{\((k2 + \(k5\ x\)\/2 + t\ \((k3 + k6\ x)\))\), " ", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}]}], "+", 
              RowBox[{\((k4 + t\ \((k5 + k6\ t)\))\), " ", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((2, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, t\), "]"}]}]}]}], 
          "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((0, 2)\),
                  Derivative],
                MultilineFunction->None], "[", \(t, x\), "]"}], "-", 
            RowBox[{
              SuperscriptBox[\(free[1]\), 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(t, x\), "]"}]}], "}"}]}], 
      "}"}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  CounterIncrements->"Output",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
AutoGeneratedPackage->Automatic,
Editable->False,
WindowToolbars->{},
InitializationCellLoading->True,
PageWidth->619,
WindowSize->{374, 610},
WindowMargins->{{Automatic, 47}, {Automatic, 4}},
WindowFrame->"Palette",
WindowElements->{
  "StatusArea", "MemoryMonitor", "MagnificationPopUp", "HorizontalScrollBar", 
    "VerticalScrollBar", "MenuBar"},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowTitle->None,
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Background->RGBColor[0.996109, 0.996109, 0.500008],
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1732, 51, 714, 23, 40, NotebookDefault,
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],

Cell[CellGroupData[{
Cell[2471, 78, 650, 22, 29, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],

Cell[CellGroupData[{
Cell[3146, 104, 568, 17, 27, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],

Cell[CellGroupData[{
Cell[3739, 125, 520, 16, 25, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection"],
Cell[4262, 143, 2843, 82, 90, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7142, 230, 518, 16, 25, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection"],
Cell[7663, 248, 3415, 85, 58, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11115, 338, 531, 16, 25, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection"],
Cell[11649, 356, 13390, 292, 122, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25076, 653, 525, 16, 25, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection"],
Cell[25604, 671, 3357, 94, 106, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28998, 770, 524, 16, 25, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection"],
Cell[29525, 788, 1097, 34, 26, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30671, 828, 562, 17, 31, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[31236, 847, 25179, 519, 90, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[56452, 1371, 562, 17, 31, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[57017, 1390, 7401, 186, 154, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[64421, 1578, 285, 10, 45, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[64743, 1593, 560, 17, 31, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],

Cell[CellGroupData[{
Cell[65328, 1614, 518, 16, 25, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection"],
Cell[65849, 1632, 530, 12, 163, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[66416, 1649, 519, 16, 29, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection"],
Cell[66938, 1667, 5386, 163, 246, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72385, 1837, 575, 17, 33, NotebookDefault,
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],

Cell[CellGroupData[{
Cell[72985, 1858, 859, 26, 25, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[73847, 1886, 1193, 37, 28, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75077, 1928, 1052, 33, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[76132, 1963, 1275, 39, 28, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77444, 2007, 828, 25, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[78275, 2034, 859, 27, 28, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79171, 2066, 1321, 39, 38, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[80495, 2107, 1495, 35, 67, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82027, 2147, 1171, 34, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[83201, 2183, 2068, 65, 129, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85306, 2253, 1028, 31, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[86337, 2286, 1602, 44, 126, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87976, 2335, 1037, 31, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[89016, 2368, 7864, 206, 427, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],
Cell[96895, 2577, 1117, 33, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[98037, 2614, 1017, 31, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[99057, 2647, 1402, 37, 65, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100496, 2689, 1338, 37, 107, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[101837, 2728, 1294, 34, 133, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[103168, 2767, 1040, 32, 29, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[104211, 2801, 3097, 80, 125, NotebookDefault,
  CellGroupingRules->"OutputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

