(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3794,        131]*)
(*NotebookOutlinePosition[     42565,       1437]*)
(*  CellTagsIndexPosition[     42521,       1433]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["MathLie StartUp", "Subsubsection"],

Cell[TextData[{
  "Adjust the path names in the following lines in such a way that the \
package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is loaded correctly. The following lines contain the names of a  standard \
installation."
}], "Text"],

Cell[BoxData[
    \(Off[General::spell]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "Here follows the path where you have installed ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " on your computer."
}], "Text"],

Cell[BoxData[
    \(\(If[$OperatingSystem\  == "\<Windows95\>", $MathLiePath = \
$TopDirectory <> "\</AddOns/Applications/MathLie/\>"; 
        AppendTo[$Path, $MathLiePath], $MathLiePath = 
          StringJoin[$HomeDirectory, \
"\</.Mathematica/3.0/AddOns/Applications/MathLie\>", "\</\>"]; 
        AppendTo[$Path, $MathLiePath]];\)\)], "Input",
  InitializationCell->True],

Cell["The next line loades the package.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Needs["\<MathLie`\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \("Loading MathLie for DOS/Windows . . . "\)], "Print"],

Cell[BoxData[
    \(". . . . . . . . . . . . . . . . . . . "\)], "Print"],

Cell[BoxData[
    \(" "\)], "Print"],

Cell[BoxData[
    \("================================================="\)], "Print"],

Cell[BoxData[
    \("MathLie\[Trademark] 3.0 (Dos/Windows\[RegisteredTrademark])"\)], \
"Print"],

Cell[BoxData[
    \("\[Copyright] 1992-1999 Dr. Gerd Baumann"\)], "Print"],

Cell[BoxData[
    \("Runs with Mathematica\[RegisteredTrademark] Version 3.0 or later"\)], \
"Print"],

Cell[BoxData[
    \("Licensed to one machine only, copying prohibited"\)], "Print"],

Cell[BoxData[
    \("================================================="\)], "Print"],

Cell[BoxData[
    \("Program loaded."\)], "Print"],

Cell[BoxData[
    \("================================================="\)], "Print"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
AutoGeneratedPackage->Automatic,
Evaluator->"Local",
WindowSize->{637, 428},
WindowMargins->{{4, Automatic}, {Automatic, 5}},
Visible->True,
InputAliases->{"notation"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", " ",
           
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation>"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation<"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "symb"->RowBox[ {"Symbolize", "[", 
        TagBox[ 
        "\[Placeholder]", NotationBoxTag, TagStyle -> 
          "NotationTemplateStyle"], "]"}], 
    "infixnotation"->RowBox[ {"InfixNotation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "addia"->RowBox[ {"AddInputAlias", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "pattwraper"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswraper"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"]},
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style.  Make modifications to any definition using commands in the \
Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->12],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{8, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->8],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-.35999999999999999, \
-.10000000000000001}, {0, 0}}, BoxBaselineShift -> -.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica"},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-.35999999999999999, \
-.10000000000000001}, {0, 0}}, BoxBaselineShift -> -.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica"},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-.35999999999999999, \
-.10000000000000001}, {0, 0}}, BoxBaselineShift -> -.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica"},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-.35999999999999999, \
-.10000000000000001}, {0, 0}}, BoxBaselineShift -> -.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica"},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-.35999999999999999, \
-.10000000000000001}, {0, 0}}, BoxBaselineShift -> -.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica"},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Times",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-.35999999999999999, \
-.10000000000000001}, {0, 0}}, BoxBaselineShift -> -.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica"},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-.35999999999999999, \
-.10000000000000001}, {0, 0}}, BoxBaselineShift -> -.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-.074999999999999997, \
-.085000000000000006}, {0, 0}}, BoxBaselineShift -> .5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica"},
    Hyphenation->True,
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    DefaultNewInlineCellStyle->"None",
    Hyphenation->True,
    LineSpacing->{1, 3},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->0.5,
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names. \
Some attributes for these styles are actually set in FormatType Styles (in \
the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}},
    FontSize->11],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}},
    FontSize->11],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontSize->11,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Futura",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LanguageCategory->"Formula",
    ScriptLevel->1,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Program", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["Hyperlink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line help \
system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["MainBookLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["AddOnsLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["RefGuideLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["GettingStartedLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["OtherInformationLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder objects in \
palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Condensed"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles of most \
cells.  If a cell's FormatType matches the name of one of the styles defined \
below, then that style is applied between the cell's style and its own \
options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an inline cell \
within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display of certain \
types of objects in typeset expressions.  For example, \"UnmatchedBracket\" \
style defines how unmatched bracket, curly bracket, and parenthesis \
characters are displayed (typically by coloring them to make them stand out).\
\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.760006, 0.330007, 0.8]]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Notation Package Styles", "Section",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell["\<\
The cells below define certain styles needed by the Notation package. These \
styles serve to make visible otherwise invisible tagboxes.\
\>", "Text",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationTemplateStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 1, 0.850004],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationPatternWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.900008, 0.979995],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationMadeBoxesWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[0.900008, 0.889998, 1],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"]
  }, Closed]]
  }]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 40, 0, 43, "Subsubsection"],
Cell[1782, 53, 254, 7, 52, "Text"],
Cell[2039, 62, 80, 2, 44, "Input",
  InitializationCell->True],
Cell[2122, 66, 81, 2, 44, "Input",
  InitializationCell->True],
Cell[2206, 70, 151, 5, 33, "Text"],
Cell[2360, 77, 376, 7, 144, "Input",
  InitializationCell->True],
Cell[2739, 86, 49, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[2813, 90, 82, 2, 44, "Input",
  InitializationCell->True],
Cell[2898, 94, 73, 1, 25, "Print"],
Cell[2974, 97, 73, 1, 25, "Print"],
Cell[3050, 100, 36, 1, 25, "Print"],
Cell[3089, 103, 84, 1, 25, "Print"],
Cell[3176, 106, 96, 2, 25, "Print"],
Cell[3275, 110, 74, 1, 25, "Print"],
Cell[3352, 113, 101, 2, 25, "Print"],
Cell[3456, 117, 83, 1, 25, "Print"],
Cell[3542, 120, 84, 1, 25, "Print"],
Cell[3629, 123, 50, 1, 25, "Print"],
Cell[3682, 126, 84, 1, 25, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

