(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    120742,       3686]*)
(*NotebookOutlinePosition[    155701,       4606]*)
(*  CellTagsIndexPosition[    151110,       4481]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["2.2 Lie Algebras", "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>Identity},
  CellTags->"Lie algebras"],

Cell[TextData[{
  "In this section, we show how the study of a Lie group \[GothicCapitalG] \
may be greatly simplified by considering the so-called tangent space ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " of \[GothicCapitalG] around the identity of the group. We shall show how \
a multiplication may be introduced in ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " and that the resulting algebraic structure\[LongDash]called a Lie algebra\
\[LongDash]determines the local structure of a group. Thus, two groups will \
be locally isomorphic if and only if their Lie algebras are isomorphic. The \
Lie algebra is a finite dimensional algebra. Therefore, the local study of \
Lie groups is entirely equivalent to the study of certain finite dimensional \
linear algebraic structures."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "tangent space", "Lie algebra", "locally isomorphic", 
    "finite dimensional algebra", "linear algebraic structure"}],

Cell[TextData[{
  "We defined a ",
  ButtonBox["Lie group",
    ButtonData:>{"Group.nb", "Definition: Lie group"},
    ButtonStyle->"Hyperlink"],
  " as a group connected with an analytic manifold. In this connection, it \
makes sense to talk about the tangent space ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " to that manifold and, in particular, the tangent space at the identity of \
a group. The tangent space itself is called a Lie algebra. To be more \
precise, let us consider a Lie group depending on ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " parameters ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(k\_1\),
              "TraditionalForm"], ",", " ", 
            FormBox[\(k\_2\),
              "TraditionalForm"], ",", " ", "\[Ellipsis]", ",", " ", 
            FormBox[\(k\_r\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". The group under consideration is also known as a continuous group with \
an infinite number of group elements. However, the properties of the group  \
may be deduced from a finite number ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " of operators, called the infinitesimal operators. It will be convenient \
to use the symbol ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " for the set of parameters ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(k\_1\),
            "TraditionalForm"], ",", " ", 
          FormBox[\(k\_2\),
            "TraditionalForm"], ",", " ", "\[Ellipsis]", ",", " ", 
          FormBox[\(k\_r\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Consider a representation ",
  Cell[BoxData[
      \(TraditionalForm\`T(k)\)]],
  " of the group \[GothicCapitalG]. By convention, the parameters are chosen \
such that the identity element has all ",
  Cell[BoxData[
      \(TraditionalForm\`k\_q\  = \ 0\)]],
  ", so that"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "Lie algebra", "analytic manifold", "tangent space", "parameters", 
    "infinitesimal operator"}],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`T(0)\  = \ 1\)]]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "If all parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k\_q\)]],
  " are small, then to first order in these parameters,"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(T(k)\), " ", "=", " ", 
            RowBox[{"1", " ", "+", " ", 
              RowBox[{
                StyleBox[
                  FormBox[
                    StyleBox[\(\[Sum]\+\(q = 1\)\%r\),
                      ScriptLevel->0],
                    "TraditionalForm"],
                  ScriptLevel->1], " ", 
                FormBox[\(k\_q\),
                  "TraditionalForm"], " ", 
                FormBox[\(v\&\[RightVector]\_q\),
                  "TraditionalForm"]}]}]}], " "}], TraditionalForm]]],
  ","
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where the ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_q\)]],
  " are some fixed linear operators, independent of the parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k\_q\)]],
  ". These operators are called infinitesimal operators of the representation \
",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " and are given explicitly as partial derivatives"
}], "Text",
  Evaluatable->False,
  CellTags->"linear operator"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{\(v\&\[RightVector]\_q\), " ", "=", " ", 
          RowBox[{
            RowBox[{\(lim\+\(\[Epsilon] \[Rule] 0\)\), 
              
              StyleBox[
                \(\(T(0, 0, \[Ellipsis], k\_q, \[Ellipsis], 0, 0) - 
                      T(0, 0, \[Ellipsis], k\_q + \[Epsilon], \[Ellipsis], 0, 
                        0)\)\/k\_q\),
                ScriptLevel->0]}], " ", "=", " ", 
            RowBox[{
              StyleBox[\(\[PartialD]\(T(k)\)\/\[PartialD]k\_q\),
                ScriptLevel->0], \( | \_\(\[Epsilon] = 0\)\)}]}]}], 
        TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  FontSize->9],

Cell["\<\
These linear operators form the basis of a Lie algebra defined as \
follows.\
\>", "Text",
  Evaluatable->False,
  CellTags->"Lie algebra"],

Cell["Definition: Lie algebra", "Definition",
  CellTags->"Definition: Lie algebra"],

Cell[TextData[{
  "Let us consider a finite dimensional vector space ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " over a field ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " of real or complex numbers. The vector space ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is called a Lie algebra over ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " if there is a rule of composition ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\((v\&\[RightVector], w\&\[RightVector])\)\  \[Rule] \ 
        \([v\&\[RightVector], w\&\[RightVector]]\)\ \)\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " which satisfies the following axioms:"
}], "Text",
  CellTags->{"finite-dimensional vector space", "axioms"}],

Cell["Antisymmetry:", "ListItem",
  CellDingbat->"(i)",
  CellMargins->{{94, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->"antisymmetry"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\ \([\(v\& \[RightVector] \), \(w\& \[RightVector] \)]\)\ 
          \),
          "TraditionalForm"], " ", "=", " ", 
        RowBox[{
          
          FormBox[\(\(-\ \([\(w\& \[RightVector] \), \(v\& \[RightVector] \)]
              \)\)\ \ \),
            "TraditionalForm"], " ", "for", " ", "all", "  ", 
          RowBox[{
            
            FormBox[\(\(v\& \[RightVector] \), \ 
              \(w\& \[RightVector] \)\  \[Element] \ V\),
              "TraditionalForm"], "."}]}]}], TextForm]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell["Linearity:", "ListItem",
  CellDingbat->"(ii)",
  CellMargins->{{94, Inherited}, {Inherited, Inherited}},
  CellTags->"linearity"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                RowBox[{
                  RowBox[{"\[Alpha]", " ", 
                    FormBox[\(v\&\[RightVector]\),
                      "TraditionalForm"]}], " ", "+", " ", 
                  RowBox[{"\[Beta]", " ", 
                    FormBox[\(w\&\[RightVector]\),
                      "TraditionalForm"]}]}], ",", 
                FormBox[\(u\&\[RightVector]\),
                  "TraditionalForm"]}], "]"}], " ", "=", 
            RowBox[{
              RowBox[{"\[Alpha]", " ", "[", 
                RowBox[{
                  FormBox[\(v\&\[RightVector]\),
                    "TraditionalForm"], ",", 
                  FormBox[\(u\&\[RightVector]\),
                    "TraditionalForm"]}], "]"}], " ", "+", " ", 
              RowBox[{"\[Beta]", " ", "[", 
                RowBox[{
                  FormBox[\(w\&\[RightVector]\),
                    "TraditionalForm"], ",", 
                  FormBox[\(u\&\[RightVector]\),
                    "TraditionalForm"]}], "]"}]}]}],
          "TraditionalForm"], "  ", "for", "  ", 
        FormBox[\(\[Alpha], \ \[Beta]\ \  \[Element] \ K\),
          "TraditionalForm"], " ", "and", " ", 
        RowBox[{"\[ForAll]", " ", 
          
          FormBox[\(u\&\[RightVector], \ v\&\[RightVector], 
            w\&\[RightVector]\  \[Element] \ \(V . \)\),
            "TraditionalForm"]}]}], TextForm]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell["Jacobi identity:", "ListItem",
  CellDingbat->"(iii)",
  CellMargins->{{94, Inherited}, {Inherited, Inherited}},
  CellTags->"Jacobi-identity"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"[", 
            RowBox[{
              FormBox[\(v\&\[RightVector]\),
                "TraditionalForm"], ",", 
              RowBox[{"[", 
                RowBox[{
                  FormBox[\(w\&\[RightVector]\),
                    "TraditionalForm"], ",", 
                  FormBox[\(u\&\[RightVector]\),
                    "TraditionalForm"]}], "]"}]}], "]"}], " ", "+", " ", 
          RowBox[{"[", 
            RowBox[{
              FormBox[\(w\&\[RightVector]\),
                "TraditionalForm"], ",", 
              RowBox[{"[", 
                RowBox[{
                  FormBox[\(u\&\[RightVector]\),
                    "TraditionalForm"], ",", 
                  FormBox[\(v\&\[RightVector]\),
                    "TraditionalForm"]}], "]"}]}], "]"}], " ", "+", " ", 
          RowBox[{"[", 
            RowBox[{
              FormBox[\(u\&\[RightVector]\),
                "TraditionalForm"], ",", 
              RowBox[{"[", 
                RowBox[{
                  FormBox[\(v\&\[RightVector]\),
                    "TraditionalForm"], ",", 
                  FormBox[\(w\&\[RightVector]\),
                    "TraditionalForm"]}], "]"}]}], "]"}]}], "  ", "=", " ", 
        RowBox[{"0", "  ", "for", " ", "all", " ", 
          
          FormBox[\(v\&\[RightVector], \ u\&\[RightVector], \ 
            w\&\[RightVector]\  \[Element] \ \(V . \)\),
            "TraditionalForm"], "\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\[EmptyCircle]"}]}], TextForm]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell[TextData[{
  "The operator ",
  Cell[BoxData[
      \(TraditionalForm\`\([\ , ]\)\)]],
  " is the multiplication relation of the algebra and is known as Lie product \
or Lie bracket. From axiom (iii) it follows that the Lie product is, in \
general, non-associative. If ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " is the field of real numbers, then ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is called a real Lie algebra; otherwise, if ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " is complex, ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is a complex Lie algebra. A Lie algebra is said to be Abelian or \
commutative if for any ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector], \ 
      w\&\[RightVector]\  \[Element] \ V\)]],
  " we have ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"[", 
            RowBox[{
              FormBox[\(v\&\[RightVector]\),
                "TraditionalForm"], ",", 
              FormBox[\(w\&\[RightVector]\),
                "TraditionalForm"]}], "]"}], "=", "0"}], TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "Lie product", "Lie bracket", "commutative algebra", "non-associative"}],

Cell[TextData[{
  "A subspace ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " of a Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is a subalgebra, if ",
  Cell[BoxData[
      \(TraditionalForm\`\([N, N]\)\  \[Union] \ N\)]],
  ", and is an ideal if ",
  Cell[BoxData[
      \(TraditionalForm\`\([V, N]\)\  \[Union] \ N\)]],
  ". Clearly, an ideal is automatically a subalgebra. A maximal ideal ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  ", which satisfies the condition ",
  Cell[BoxData[
      \(TraditionalForm\`\([V, N]\) = 0\)]],
  ", is called the center of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ", and because ",
  Cell[BoxData[
      \(TraditionalForm\`\([N, N]\) = 0\)]],
  ", the center is always commutative."
}], "Text",
  Evaluatable->False,
  CellTags->{"subalgebra", "ideal", "maximal ideal", "center"}],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_1, \ e\&\[RightVector]\_2, 
      \[Ellipsis], \ e\&\[RightVector]\_n\)]],
  " be a basis of the vector space ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ". Then the commutator ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(u\&\[RightVector]\),
              "TraditionalForm"], " ", "=", " ", 
            RowBox[{"[", 
              RowBox[{
                FormBox[\(v\&\[RightVector]\),
                  "TraditionalForm"], ",", 
                FormBox[\(w\&\[RightVector]\),
                  "TraditionalForm"]}], "]"}]}]}], TraditionalForm]]],
  ", when expressed in terms of the coordinates via ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " = ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(i = 1\)\%n v\^i\ e\&\[RightVector]\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`w\&\[RightVector]\ \  = 
        \[Sum]\+\(i = 1\)\%n w\^i\ e\&\[RightVector]\_i\)]],
  ", takes the form"
}], "Text",
  Evaluatable->False,
  CellTags->{"commutator", "coordinates"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(u\^i\), " ", "=", " ", 
          RowBox[{\(\[Sum]\+\(i, k = 1\)\%n\), 
            RowBox[{
              SubsuperscriptBox["c", 
                StyleBox["jk",
                  FontSlant->"Italic"], "i"], " ", \(v\^\(\[ThinSpace]j\)\), 
              " ", \(w\^k\)}]}]}], ",", "      ", \(i\  = \ 1\), ",", "2", 
        ",", " ", "\[Ellipsis]", ",", " ", "n", ","}], TraditionalForm]], 
  "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell[TextData[{
  "where [",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_j\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_k\)]],
  "] = ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Sum]\+\(i = 1\)\%n\), 
          RowBox[{
            StyleBox[
              SubsuperscriptBox["c", 
                StyleBox[
                  RowBox[{"j", 
                    StyleBox["k",
                      FontSlant->"Italic"]}]], "i"],
              FontSlant->"Italic"], " ", \(e\&\[RightVector]\_i\)}]}], 
        TraditionalForm]]],
  ". The numbers ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["c", 
          StyleBox["jk",
            FontSlant->"Italic"], "i"], TraditionalForm]]],
  " are called the structure constants, and ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " denotes the dimension of the Lie algebra."
}], "Text",
  Evaluatable->False,
  CellTags->"structure constant"],

Cell[TextData[{
  "Taking axioms (i) and (iii) into account, it is clear that the structure \
constants ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(c\_jk\%i\),
          FontSlant->"Italic"], TraditionalForm]]],
  " satisfy the conditions"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      StyleBox[\(c\_jk\%i\  = \ \(-c\_kj\%i\), \),
        FontSlant->"Italic"], TraditionalForm]], "DisplayFormula",
  TextAlignment->Center],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Sum]\+\(m = 1\)\%n\), 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["(",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox[\(c\_im\%l\ c\_jk\%m\),
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["+",
                    FontSlant->"Plain"], 
                  StyleBox[" ",
                    FontSlant->"Italic"]}], 
                StyleBox[\(c\_jm\%l\ c\_ki\%m\),
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"]}], "+", 
              StyleBox[" ",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox[\(c\_km\%l\ c\_ij\%m\),
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox[")",
                  FontSlant->"Plain"]}]}], 
            StyleBox[" ",
              FontSlant->"Italic"]}]}], "=", " ", "0."}], TraditionalForm]], 
  "DisplayFormula",
  TextAlignment->Center],

Cell[TextData[{
  "The existence of subalgebras or ideals of a Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is reflected in certain definite restrictions on the structure constants. \
If ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_1, \ e\&\[RightVector]\_2, \ 
      \[Ellipsis], \ e\&\[RightVector]\_k\)]],
  " are the basis elements of a subalgebra, then the structure constants must \
satisfy the relations"
}], "Text",
  Evaluatable->False,
  CellTags->{"subalgebra", "restrictions on structure constants"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{
              SubsuperscriptBox["c", 
                StyleBox["ij",
                  FontSlant->"Italic"], "m"], " ", "=", " ", "0"}], " "}],
          "TraditionalForm"], "    ", "for", "  ", 
        FormBox[\(\ i, j\  \[LessEqual] \ k\ , \ m > k\),
          "TraditionalForm"]}], TextForm]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell["and, if they are the basis elements of an ideal, then", "Text",
  Evaluatable->False,
  CellTags->"ideal"],

Cell[BoxData[
    FormBox[
      RowBox[{"\t\t\t", 
        RowBox[{
          FormBox[
            RowBox[{
              SubsuperscriptBox["c", 
                StyleBox["ij",
                  FontSlant->"Italic"], "m"], " ", "=", " ", "0"}],
            "TraditionalForm"], "  ", "for", " ", 
          FormBox[\(\ i\  \[LessEqual] \ k, \ m > k\),
            "TraditionalForm"], "  ", "and", " ", "an", " ", "arbitrary", 
          " ", 
          RowBox[{
            FormBox["j",
              "TraditionalForm"], "."}]}]}], TextForm]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell["\<\
So far, we defined some basic properties of a Lie algebra. These \
relations are useful when applied to physical problems. One of these problems \
is related to the algebra of Pauli matrices widely used in quantum mechanics. \
In the following example, we discuss the algebraic properties of the Pauli \
spin matrices.\
\>", "Text",
  Evaluatable->False,
  CellTags->{"Pauli matrices", "spin matrices"}],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " be the set of all skew-Hermitian 2 \[Times] 2 matrices with vanishing \
trace. From quantum mechanics, we know that ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is three dimensional. We choose the basis in ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " by the three matrices"
}], "Text",
  Evaluatable->False,
  CellTags->{"skew-Hermitian matrices", "quantum mechanics"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{\(e\&\[RightVector]\_1\), " ", "=", 
          RowBox[{\(1\/2\), " ", 
            RowBox[{
              StyleBox["(",
                FontSize->12], GridBox[{
                  {"0", \(-i\)},
                  {\(-i\), "0"}
                  }], 
              StyleBox[")",
                FontSize->12]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(e\&\[RightVector]\_2\), " ", "=", " ", 
          RowBox[{\(1\/2\), 
            RowBox[{
              StyleBox["(",
                FontSize->12], GridBox[{
                  {"0", \(-1\)},
                  {"1", "0"}
                  }], 
              StyleBox[")",
                FontSize->12]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(e\&\[RightVector]\_3\), " ", "=", " ", 
          RowBox[{\(1\/2\), 
            RowBox[{
              StyleBox["(",
                FontSize->12], GridBox[{
                  {\(-i\), "0"},
                  {"0", "i"}
                  }], 
              StyleBox[")",
                FontSize->12]}]}]}], TraditionalForm]]],
  "."
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "These matrices are represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by "
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(e\_1 = 1\/2\ {{0, \(-I\)}, {\(-I\), 0}}; MatrixForm[e\_1]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", \(-\(I\/2\)\)},
            {\(-\(I\/2\)\), "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(e\_2 = 1\/2\ {{0, \(-1\)}, {1, 0}}; MatrixForm[e\_2]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", \(-\(1\/2\)\)},
            {\(1\/2\), "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(e\_3 = 1\/2\ {{\(-I\), 0}, {0, I}}; MatrixForm[e\_3]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-\(I\/2\)\), "0"},
            {"0", \(I\/2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The Lie product [",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`w\&\[RightVector]\)]],
  "] of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is defined in quantum mechanics by the commutator"
}], "Text",
  Evaluatable->False,
  CellTags->{"Lie product", "commutator"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"[", 
          RowBox[{
            FormBox[\(v\&\[RightVector]\),
              "TraditionalForm"], ",", 
            FormBox[\(w\&\[RightVector]\),
              "TraditionalForm"]}], "]"}], " ", "=", " ", 
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], " ", 
          FormBox[\(w\&\[RightVector]\),
            "TraditionalForm"], "  ", "\[Dash]", " ", 
          FormBox[\(w\&\[RightVector]\),
            "TraditionalForm"], " ", 
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], "   ", "with", "  ", 
          RowBox[{
            
            FormBox[\(v\&\[RightVector], \ 
              w\&\[RightVector]\  \[Element] \ V\),
              "TraditionalForm"], "."}]}]}], TextForm]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell[TextData[{
  "For our specific system of two-dimensional matrices, we replace the \
right-hand side of this relation by the difference of two matrix products. \
The Lie bracket in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can be expressed by"
}], "Text",
  Evaluatable->False,
  CellTags->"matrix product"],

Cell[BoxData[
    \(LieProduct[v_List, w_List] := v . w - w . v\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Knowing the Lie bracket, it is easy to check axioms (i) to (iii) of a Lie \
algebra. We first demonstrate the antisymmetric behavior of the Lie product \
using the relation ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                FormBox[\(v\& \[RightVector] \),
                  "TraditionalForm"], ",", 
                FormBox[\(u\& \[RightVector] \),
                  "TraditionalForm"]}], "]"}], "+"}]}], TraditionalForm]]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"[", 
            RowBox[{
              FormBox[\(u\& \[RightVector] \),
                "TraditionalForm"], ",", 
              FormBox[\(v\& \[RightVector] \),
                "TraditionalForm"]}], "]"}], " ", "=", " ", "0"}], 
        TraditionalForm]]],
  ". In ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " we get"
}], "Text",
  Evaluatable->False,
  CellTags->"antisymmetric"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[LieProduct[e\_1, e\_2] + \n\t\tLieProduct[e\_2, e\_1]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The linearity of the Lie brackets is shown by", "Text",
  Evaluatable->False,
  CellTags->"Lie bracket"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      Simplify[LieProduct[a\ e\_1 + b\ e\_2, e\_3] - \n\t\t\t
          \((a\ LieProduct[e\_1, e\_3] + b\ LieProduct[e\_2, e\_3])\)]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The Jacobi identity is checked with", "Text",
  Evaluatable->False,
  CellTags->"Jacobi-identity"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      LieProduct[e\_1, LieProduct[e\_2, e\_3]] + \n\t\t
        LieProduct[e\_2, LieProduct[e\_3, e\_1]] + \n\t\t
        LieProduct[e\_3, LieProduct[e\_1, e\_2]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Carrying out some experiments with ",
  StyleBox["LieProduct[]", "MmaText"],
  " by interchanging the basis elements ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_k\)]],
  " in the Lie bracket, we observe that the following relation holds:"
}], "Text",
  Evaluatable->False,
  CellTags->{"LieProduct[]", "Lie bracket"}],

Cell[TextData[{
  "[",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_k\)]],
  "] = ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[CapitalSigma]\_\(l = 1\)\%3\), 
            SubsuperscriptBox["\[Epsilon]", 
              StyleBox["ik",
                FontFamily->"I Times Italic"], "l"], " ", 
            \(e\&\[RightVector]\_l\), "      ", "i"}], ",", \(k = 1\), ",", 
          "2", ",", "3"}], TraditionalForm]]],
  ","
}], "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["\[Epsilon]", 
          StyleBox["ik",
            FontSlant->"Italic"], "l"], TraditionalForm]]],
  " is the totally antisymmetric tensor in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " (Levi-Civita density). The elements of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " are linear combinations of ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_i\)]],
  " with real coefficients. In physics, the matrices ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\_k\  = \ 2  i\ e\&\[RightVector]\_k\)]],
  " are known as Pauli matrices and satisfy the relations ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[
                  RowBox[{"[", 
                    SubscriptBox["\[Sigma]", 
                      StyleBox["i",
                        FontSlant->"Italic"]]}],
                  "TraditionalForm"], ",", \(\[Sigma]\_k\)}],
              "TraditionalForm"], "]"}], "=", 
          RowBox[{"2", "i", 
            FormBox[
              RowBox[{\(\[Sum]\_\(l = 1\)\%3\), " ", 
                RowBox[{
                  SubsuperscriptBox["\[Epsilon]", 
                    StyleBox["ik",
                      FontSlant->"Italic"], "l"], " ", \(\[Sigma]\_l\)}]}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". Hence, ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is the three-dimensional, real Lie algebra with structure constants ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["c", 
            StyleBox["ik",
              FontSlant->"Italic"], "l"], " ", "=", " ", 
          SubsuperscriptBox["\[Epsilon]", 
            StyleBox["ik",
              FontSlant->"Italic"], "l"]}], TraditionalForm]]],
  ". If we want to check this relation for the structure constants, we first \
have to define a representation of the Levi-Civita density in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The function ",
  StyleBox["LeviCivita[]", "MmaText"],
  " has to satisfy the following properties:"
}], "Text",
  CellTags->{
  "Levi-Civita density", "Pauli matrices", "real Lie algebra", 
    "LeviCivita[]"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Epsilon]", 
            StyleBox["ik",
              FontSlant->"Italic"], "l"], " ", "=", 
          RowBox[{
            StyleBox[
              AdjustmentBox[
                StyleBox[
                  AdjustmentBox[
                    StyleBox[
                      AdjustmentBox[
                        StyleBox[
                          AdjustmentBox[
                            StyleBox[
                              AdjustmentBox[
                                StyleBox[
                                  AdjustmentBox[
                                    StyleBox[
                                      AdjustmentBox[
                                        StyleBox["{",
                                        FontSize->27],
                                        BoxMargins->{{0, 0}, {-0.054983, 
                                        0.054983}},
                                        BoxBaselineShift->0.054983],
                                      FontSize->27],
                                    BoxMargins->{{0, 0}, {-0.054983, 
                                    0.054983}},
                                    BoxBaselineShift->0.054983],
                                  FontSize->27],
                                BoxMargins->{{0, 0}, {-0.054983, 0.054983}},
                                BoxBaselineShift->0.054983],
                              FontSize->27],
                            BoxMargins->{{0, 0}, {-0.054983, 0.054983}},
                            BoxBaselineShift->0.054983],
                          FontSize->27],
                        BoxMargins->{{0, 0}, {-0.054983, 0.054983}},
                        BoxBaselineShift->0.054983],
                      FontSize->27],
                    BoxMargins->{{0, 0}, {-0.054983, 0.054983}},
                    BoxBaselineShift->0.054983],
                  FontSize->27],
                BoxMargins->{{0, 0}, {-0.054983, 0.054983}},
                BoxBaselineShift->0.054983],
              FontSize->27], " ", GridBox[{
                {\(\ \ \ 0\), 
                  
                  StyleBox[
                    \(if\ any\ index\ is\ equal\ to\ any\ other\ index
                      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \),
                    FontFamily->"Times"]},
                {\(+1\), 
                  RowBox[{"   ", 
                    RowBox[{
                      RowBox[{
                        StyleBox["if",
                          FontFamily->"Times"], " ", "i"}], ",", "j", ",", 
                      "k", ",", " ", 
                      RowBox[{
                        StyleBox["form",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["an",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["even",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["permutation",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["of",
                          FontFamily->"Times"], "  ", "1"}], ",", "2", ",", 
                      "3"}]}]},
                {\(-1\), 
                  RowBox[{"  ", 
                    RowBox[{
                      RowBox[{
                        StyleBox["if",
                          FontFamily->"Times"], " ", "i"}], ",", "j", ",", 
                      "k", ",", " ", 
                      RowBox[{
                        StyleBox["form",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["an",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["odd",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["permutation",
                          FontFamily->"Times"], 
                        StyleBox[" ",
                          FontFamily->"Times"], 
                        StyleBox["of",
                          FontFamily->"Times"], "  ", "1"}], ",", "2", ",", 
                      "3"}], " "}]}
                }]}]}], TraditionalForm]]],
  ". "
}], "NumberedEquation"],

Cell[TextData[{
  StyleBox["The sequence of instructions in "],
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  StyleBox["to simulate this behavior is given by"]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(LeviCivita[i_, j_, k_] := 
      Block[{out, list, l1}, \n\t\tlist = {i, j, k}; \n\t\t
        l1 = Union[list, {1, 2, 3}]; \n\t\t
        If[Length[l1] < 3 || Length[l1] > 3, \n\t\t\tout = 0, \n\t\t\t
          out = Signature[list]]; \n\t\tout]\)], "Input"],

Cell[TextData[{
  "This function makes use of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions ",
  StyleBox["Union[]", "MmaText"],
  ", ",
  StyleBox["Length[]", "MmaText"],
  ", and ",
  StyleBox["Signature[]", "MmaText"],
  " to implement the properties of the Levi-Civita density. The first step of \
the function is the collection of the numeric indices ",
  Cell[BoxData[
      FormBox[
        RowBox[{"i", ",", "j", ",", 
          RowBox[{
            StyleBox["and",
              FontSlant->"Plain"], "  ", "k"}]}], TraditionalForm]],
    FontSlant->"Italic"],
  " in a list. Then, the condition of uniqueness is checked by using the \
function ",
  StyleBox["Union[],", "MmaText"],
  " verifying that only the integers 1",
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Italic"],
  "2",
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Italic"],
  "and 3 occur. Checking the length of the result allows us to distinguish \
two cases. First, are there two or three indices equal, and second, are there \
indices different from the numbers 1",
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Italic"],
  "2",
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Italic"],
  "and 3",
  StyleBox["?",
    FontVariations->{"CompatibilityType"->0}],
  " If this happens, the function is terminated with a return value 0. If the \
indices ",
  StyleBox["i",
    FontFamily->"I Times Italic"],
  ", ",
  StyleBox["j",
    FontFamily->"I Times Italic"],
  ", and ",
  StyleBox["k",
    FontFamily->"I Times Italic"],
  " are contained in the set {1",
  StyleBox[",\[NonBreakingSpace]\[NoBreak]",
    FontVariations->{"CompatibilityType"->0}],
  "2",
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  " 3}",
  StyleBox[",",
    FontSlant->"Italic"],
  " then the signature of the permutation is calculated. The return value is  \
",
  StyleBox["+",
    FontSlant->"Italic"],
  "1 if the permutation of 1, 2",
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontSlant->"Italic"],
  "and 3 is even and \[Dash]1 if the permutation is odd."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "Union[]", "Length[]", "Signature[]", "Levi-Civita density", "signature", 
    "permutation"}],

Cell[TextData[{
  "The function ",
  StyleBox["LeviCivita[]", "MmaText"],
  " allows us to verify relation ",
  ButtonBox["(2.5)",
    ButtonData:>"eq-5",
    ButtonStyle->"Hyperlink"],
  " connecting the structure constants ",
  Cell[BoxData[
      \(TraditionalForm\`c\_ik\%l\)],
    FontSlant->"Italic"],
  " and the \[Epsilon]-tensor. Checking the relations with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we need to define two additional functions generating the right-hand \
side of relation ",
  ButtonBox["(2.5)",
    ButtonData:>"eq-5",
    ButtonStyle->"Hyperlink"],
  " and verifying the equality of both sides. We call these functions ",
  StyleBox["rhs[]", "MmaText"],
  " and ",
  StyleBox["CommutativeQ[]", "MmaText"],
  ". We also collect the three matrices ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_1, \ e\&\[RightVector]\_2, \ 
      and\ \ e\&\[RightVector]\_3\)]],
  " in a common list."
}], "Text",
  Evaluatable->False,
  CellTags->"CommutativeQ[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eList = {e\_1, e\_2, e\_3}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{{0, \(-\(I\/2\)\)}, {\(-\(I\/2\)\), 0}}, {{0, \(-\(1\/2\)\)}, {1\/2, 
          0}}, {{\(-\(I\/2\)\), 0}, {0, I\/2}}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(rhs[i_, j_] := 
      \[Sum]\+\(k = 1\)\%3 LeviCivita[i, j, k]\ 
          eList\[LeftDoubleBracket]k\[RightDoubleBracket]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(CommutativeQ[i_, j_] := 
      LieProduct[eList\[LeftDoubleBracket]i\[RightDoubleBracket], 
          eList\[LeftDoubleBracket]j\[RightDoubleBracket]] == \n\t\t
        rhs[i, j]\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The check of the relation ",
  ButtonBox["(2.5)",
    ButtonData:>"eq-5",
    ButtonStyle->"Hyperlink"],
  " between the structure constants and the \[Epsilon]-tensor is carried out \
by"
}], "Text",
  Evaluatable->False,
  CellTags->{"structure constants", "tensor"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[CommutativeQ[i, k], {i, 1, 3}, {k, 1, 3}]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{True, True, True}, {True, True, True}, {True, True, True}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the relation is satisfied for all combinations of ",
  StyleBox["i",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k ",
    FontSlant->"Italic"],
  "in the range ",
  Cell[BoxData[
      \(TraditionalForm\`i, k = 1, 2, 3\)]],
  ". This example demonstrates that the structure of a Lie algebra can be \
realized by matrices or tensors. On the other hand, in symmetry analysis Lie \
algebras are represented by differential operators. These operators are the \
basic elements of the vector space whose Lie product is defined by the \
commutator of differential operators.\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "commutator", "Lie product", "vector space", "differential operator"}],

Cell[CellGroupData[{

Cell["2.2.1 Representation of a Lie Algebra", "Subsection",
  CellTags->"Representation of a Lie Algebra"],

Cell["\<\
In this section, we briefly discuss the representation of an algebra. Before \
we discuss the theoretical definition, let us continue with another example. \
In the previous example, we became familiar with a matrix representation of a \
Lie algebra. The following example shows how a Lie algebra is represented in \
connection with differential operators. We will find that the two different \
representations are isomorphic to each other.\
\>", "Text",
  CellTags->{
  "representation", "matrix representation of Lie algebras", 
    "differential operator"}],

Cell["Example 2 ", "Example"],

Cell[TextData[{
  "Another example for the representation of a Lie algebra are the three \
differential operators generating the Lie algebra of rotations in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". This kind of algebra is connected with the symmetry of rotations. Assume \
we know the three operators given by"
}], "Text",
  CellTags->{"rotation", "symmetry of rotation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(R\_1\  = \ 
      x\^3\ \[PartialD]\/\[PartialD]x\^2\  - \ 
        x\^2\ \[PartialD]\/\[PartialD]x\^3, \)\)], "DisplayFormula",
  Evaluatable->False,
  TextAlignment->Center],

Cell[BoxData[
    \(TraditionalForm
    \`\(R\_2\  = \ 
      x\^1\ \[PartialD]\/\[PartialD]x\^3\  - \ 
        x\^3\ \[PartialD]\/\[PartialD]x\^1, \)\)], "DisplayFormula",
  Evaluatable->False,
  TextAlignment->Center],

Cell[BoxData[
    \(TraditionalForm
    \`R\_3\  = \ 
      x\^2\ \[PartialD]\/\[PartialD]x\^1\  - \ 
        x\^1\ \[PartialD]\/\[PartialD]x\^2\)], "DisplayFormula",
  Evaluatable->False,
  TextAlignment->Center],

Cell[TextData[{
  "acting in ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalR]\^3\ \)\)]],
  "with Cartesian coordinates ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(x\^1\), ",", " ", \(x\^2\), ",", 
          StyleBox[" ",
            FontSlant->"Italic"], \(and\ \ x\^3\)}], TraditionalForm]]],
  ". The three operators allow a unique formula if we make use of the \
Levi-Civita density ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Epsilon]\_ik\%l\),
          FontSlant->"Italic"], TraditionalForm]]],
  ":"
}], "Text",
  Evaluatable->False,
  CellTags->{"Cartesian", "Levi-Civita density"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(R\_i\), " ", "=", " ", 
        RowBox[{\(\[Sum]\+\(k = 1\)\%3\), \(\[Sum]\+\(j = 1\)\%3\), 
          RowBox[{
            RowBox[{"-", 
              StyleBox[
                SubsuperscriptBox["\[Epsilon]", 
                  StyleBox[
                    RowBox[{
                      StyleBox["i",
                        FontSlant->"Italic"], "j"}]], "k"],
                FontSlant->"Italic"]}], 
            SuperscriptBox[
              StyleBox["x",
                FontSlant->"Italic"], "j"], " ", 
            \(\[PartialD]\_\(x\^k\) . \)}]}]}], TraditionalForm]], 
  "DisplayFormula",
  TextAlignment->Center],

Cell[TextData[{
  "This formula is used to define the three differential operators in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(R[i_, f_] := 
      Block[{variables = {x1, x2, x3}}, \n\t\t\t
        \[Sum]\+\(k = 1\)\%3\ 
          \[Sum]\+\(j = 1\)\%3\(-LeviCivita[i, j, k]\)\ 
            variables\[LeftDoubleBracket]j\[RightDoubleBracket]\ 
            \[PartialD]\_\(variables\[LeftDoubleBracket]k
                  \[RightDoubleBracket]\)f]\)], "Input"],

Cell["The Lie bracket in the related vector space is defined by", "Text",
  Evaluatable->False,
  CellTags->"Lie bracket"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`\([R\_i, R\_j]\) \((f)\)\  = \ 
        \(R\_i\)(\(R\_j\) f)\  - \ \(R\_j\)(\(R\_i\) f)\)]],
  ","
}], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is an arbitrary function. The definition in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks quite similar:"
}], "Text"],

Cell[BoxData[
    \(LieBracket[i_, j_, f_] := R[i, R[j, f]] - \n\t\tR[j, R[i, f]]\)], 
  "Input",
  PageWidth->Infinity],

Cell["\<\
The right-hand side of the commutator (2.7) can be again expressed by the \
Levi-Civita symbol\
\>", "Text",
  CellTags->{"commutator", "Levi-Civita"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\([R\_i\),
                  "TraditionalForm"], ",", \(R\_k\)}],
              "TraditionalForm"], "]"}], " ", "=", " ", 
          FormBox[
            RowBox[{
              StyleBox[
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{
                    StyleBox["l",
                      ScriptLevel->0], "=", "1"}], "3"],
                ScriptLevel->0], " ", 
              RowBox[{
                SubsuperscriptBox["\[Epsilon]", 
                  StyleBox["jk",
                    FontSlant->"Italic"], "l"], " ", \(R\_\(l\ \)\)}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  "."
}], "NumberedEquation"],

Cell[TextData[{
  "We define the right-hand side of the commutator ",
  ButtonBox["(2.8)",
    ButtonData:>"eq-7",
    ButtonStyle->"Hyperlink"],
  " as"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(rhs[i_, j_, f_] := 
      \[Sum]\+\(k = 1\)\%3 LeviCivita[i, j, k]\ R[k, f]\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The check of the commutation relation for arbitrary ",
  StyleBox["i",
    FontSlant->"Italic"],
  " is calculated by"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Clear[CommutativeQ]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(CommutativeQ[i_, j_, f_] := 
      Simplify[\n\t\tLieBracket[i, j, f]] == Simplify[rhs[i, j, f]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Using these definitions, we can verify that relation (2.8) holds. The use \
of the function ",
  StyleBox["CommutativeQ[]", "MmaText"],
  " in connection with ",
  StyleBox["Table[] ", "MmaText"],
  "allows us to verify this proposition:"
}], "Text",
  Evaluatable->False,
  CellTags->{"CommutativeQ[]", "Table[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[CommutativeQ[i, j, f[x1, x2, x3]], \n\t{i, 1, 3}, {j, 1, 3}]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{True, True, True}, {True, True, True}, {True, True, True}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The arbitrary function ",
  StyleBox["f[x1, x2, x3]", "MmaText"],
  " in ",
  StyleBox["CommutativeQ[]", "MmaText"],
  " is used as an argument for the three operators ",
  Cell[BoxData[
      \(TraditionalForm\`R\_j\)]],
  ". These differential operators act, for example, on the infinite \
dimensional vector space ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^\[Infinity]\)(\[DoubleStruckCapitalR]\^3)\)]],
  ", thus providing an infinite dimensional representation of the Lie algebra \
",
  StyleBox["so",
    FontSlant->"Italic"],
  "(3) related to the special orthogonal group ",
  StyleBox[ButtonBox["SO",
    ButtonData:>{"Group.nb", "SO(3)"},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox["(3)",
    ButtonData:>{"Group.nb", "SO(3)"},
    ButtonStyle->"Hyperlink"],
  ". The result is that the rotation operators in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " possess the same structure constants as the Lie algebra of the Pauli \
matrices. Thus, we can state that the two representations are isomorphic. The \
conclusion is that two different representations of a Lie algebra may result \
into the same structure and especially possess the same structure constants. \
So we face the problem of representation of a Lie algebra.\[ThickSpace]\
\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
    "Pauli matrices", "isomorphic", "representations of Lie algebras", 
    "structure constants", "representation"}],

Cell[TextData[{
  "Generally, a representation of a Lie algebra \[GothicG] on a vector space \
",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is a mapping \[Rho] from \[GothicG] to a linear transformation of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " such that"
}], "Text",
  Evaluatable->False,
  CellTags->"representation of a Lie algebra"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Rho]", "(", 
          RowBox[{
            RowBox[{"\[Alpha]", " ", 
              FormBox[\(v\&\[RightVector]\ \),
                "TraditionalForm"]}], "+", \(\[Beta]\ w\&\[RightVector]\)}], 
          ")"}], " ", "=", " ", 
        \(\[Alpha]\ \(\[Rho](v\&\[RightVector])\)\  + \ 
          \[Beta]\ \(\[Rho](w\&\[RightVector])\)\)}], TraditionalForm]]]], 
  "NumberedEquation"],

Cell["and", "Text"],

Cell[TextData[{
  "\[Rho]([",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\(v\&\[RightVector], w\&\[RightVector]]\))\)\  = \ 
        \([\[Rho]\ \((v\&\[RightVector])\), \[Rho](w\&\[RightVector])]\)\)]],
  ","
}], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\([\ , ]\)\)]],
  " is the Lie product of the algebra \[GothicG]. The dimension of the \
representation is equal to the dimension of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->"Lie product"],

Cell[TextData[{
  "In C",
  ButtonBox["hapter 5, ",
    ButtonData:>{"symmet5.nb", None},
    ButtonStyle->"Hyperlink"],
  "we shall discuss procedures to find the differential operators that  \
represent the symmetries of differential equations. For example, the \
symmetries or respectively the basis of the Lie algebra for the heat equation \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(u\_t\), "-", 
            SubscriptBox["u", 
              StyleBox["xx",
                FontSlant->"Italic"]]}], "=", "0"}], TraditionalForm]]],
  " are given by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "differential operator", "symmetries of differential equations", 
    "heat equation"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\  = \ \[PartialD]\_x, \ 
      v\&\[RightVector]\_2\  = \ \[PartialD]\_t, \ 
      v\&\[RightVector]\_3\  = \ u \[PartialD]\_u\)]],
  ","
}], "NumberedEquation"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`v\&\[RightVector]\_4\  = \ 
        x \[PartialD]\_x\ \(+\ 2\)\ t\ \[PartialD]\_t, \ 
      v\&\[RightVector]\_5\  = \ 
        2\ t\ \[PartialD]\_x\ \(-\ x\)\ u\ \[PartialD]\_u\)]],
  ","
}], "NumberedEquation"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`v\&\[RightVector]\_6\  = \ 
      4  t\ x\ \[PartialD]\_x\ \(+\ 4\) t\^2\ 
        \[PartialD]\_t\ \(-\((x\^2 + 2  t)\)\)\ u\ \[PartialD]\_u . \)]]], 
  "NumberedEquation"],

Cell[TextData[{
  "The basis elements of the Lie algebra are also called vector fields. This \
notion will become clear in S",
  ButtonBox["ection 3.2",
    ButtonData:>{"derivat.nb", "Tangent vector"},
    ButtonStyle->"Hyperlink"],
  " where we discuss tangent vectors. For the moment, let us call the \
elements in (2.11), (2.12), and (2.13) vector fields. These operators form a \
six-dimensional Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ". A convenient way to display the structure of such an assembly of \
operators is to write it in tabular form. For the six-dimensional Lie algebra \
",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          
          FormBox[\(v\&\[RightVector]\_1, v\&\[RightVector]\_2, \ 
              \[Ellipsis], v\&\[RightVector]\_6}\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", the commutator table for ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " will be the 6\[Times]6 table whose ",
  StyleBox["(i,\[NonBreakingSpace]\[NoBreak]",
    FontSlant->"Italic"],
  StyleBox["j",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[")",
    FontSlant->"Italic"],
  "th entry expresses the Lie bracket [",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i, \ v\&\[RightVector]\_j\)]],
  "]. From axiom",
  ButtonBox[" (i),",
    ButtonData:>"antisymmetry",
    ButtonStyle->"Hyperlink"],
  " it is clear that the table is always skew-symmetric, and the diagonal \
elements are all zero. The structure constants can be easily read off the \
commutator table. The coefficient ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(c\_jk\%i\),
          FontSlant->"Italic"], TraditionalForm]]],
  " is the coefficient of ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_i\)]],
  " in the ",
  StyleBox["(j, k)",
    FontSlant->"Italic"],
  "th entry of the table. For the above set of operators, we find the \
commutator table"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "commutator table", "vector field", "structure constants", "Lie algebra", 
    "skew-symmetric", "Lie bracket"}],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          RowBox[{"[", 
            FormBox[",",
              "TraditionalForm"], "]"}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox["v", 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "1"]}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox["v", 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "2"]}], 
          SubscriptBox[
            OverscriptBox[
              StyleBox["v",
                FontSlant->"Italic"], 
              AdjustmentBox["\[RightVector]",
                BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                BoxBaselineShift->-0.173913]], "3"], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "4"]}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "5"]}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "6"]}]},
        {
          StyleBox[
            RowBox[{" ", 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                    BoxBaselineShift->-0.26087]], 
                StyleBox["1",
                  FontSlant->"Plain"]]}],
            FontSlant->"Italic"], "0", "0", "0", 
          RowBox[{"-", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                  BoxBaselineShift->-0.26087]], "1"]}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                  BoxBaselineShift->-0.26087]], "3"]}], 
          RowBox[{\(-2\), 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                  BoxBaselineShift->-0.26087]], "5"]}]},
        {
          StyleBox[
            RowBox[{" ", 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                    BoxBaselineShift->-0.26087]], 
                StyleBox["2",
                  FontSlant->"Plain"]]}],
            FontSlant->"Italic"], "0", "0", "0", 
          RowBox[{\(-2\), 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "2"]}], 
          RowBox[{\(-2\), 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "1"]}], 
          RowBox[{
            RowBox[{"2", 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                    BoxBaselineShift->-0.173913]], "3"]}], "-", 
            RowBox[{"4", 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                    BoxBaselineShift->-0.173913]], "4"]}]}]},
        {
          StyleBox[
            RowBox[{" ", 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                    BoxBaselineShift->-0.26087]], 
                StyleBox["3",
                  FontSlant->"Plain"]]}],
            FontSlant->"Italic"], "0", "0", "0", "0", "0", "0"},
        {
          StyleBox[
            RowBox[{" ", 
              SubscriptBox[
                OverscriptBox["v", 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                    BoxBaselineShift->-0.26087]], 
                StyleBox["4",
                  FontSlant->"Plain"]]}],
            FontSlant->"Italic"], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "1"]}], 
          RowBox[{"2", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "2"]}], "0", "0", 
          RowBox[{"-", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "5"]}], 
          RowBox[{\(-2\), 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "6"]}]},
        {
          StyleBox[
            RowBox[{" ", 
              SubscriptBox[
                OverscriptBox["v", 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                    BoxBaselineShift->-0.26087]], 
                StyleBox["5",
                  FontSlant->"Plain"]]}],
            FontSlant->"Italic"], 
          RowBox[{"-", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.434783, -0.434783}},
                  BoxBaselineShift->-0.434783]], "3"]}], 
          RowBox[{"2", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                  BoxBaselineShift->-0.26087]], "1"]}], "0", 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                  BoxBaselineShift->-0.26087]], "5"]}], "0", "0"},
        {
          StyleBox[
            RowBox[{" ", 
              SubscriptBox[
                OverscriptBox["v", 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.26087, -0.26087}},
                    BoxBaselineShift->-0.26087]], 
                StyleBox["6",
                  FontSlant->"Plain"]]}],
            FontSlant->"Italic"], 
          RowBox[{"2", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "5"]}], 
          RowBox[{
            RowBox[{\(-2\), 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                    BoxBaselineShift->-0.173913]], "3"]}], "+", 
            RowBox[{"4", 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                    BoxBaselineShift->-0.173913]], "4"]}]}], "0", 
          RowBox[{"2", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.173913, -0.173913}},
                  BoxBaselineShift->-0.173913]], "6"]}], "0", "0"}
        },
      RowLines->True,
      ColumnLines->True]]]], "NumberedTable",
  CellMargins->{{Inherited, Inherited}, {Inherited, 9}},
  CellTags->"Table-1"],

Cell["The entry (2,6), for example, is given by", "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"[", 
            RowBox[{
              FormBox[\(v\&\[RightVector]\_2, \),
                "TraditionalForm"], 
              FormBox[\(v\&\[RightVector]\_6\),
                "TraditionalForm"]}], "]"}], "  ", "=", " ", 
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox[\(v\&\[RightVector]\_2\),
                  "TraditionalForm"], 
                FormBox[\(v\&\[RightVector]\_6\),
                  "TraditionalForm"]}], " ", "-", " ", 
              RowBox[{
                FormBox[\(v\&\[RightVector]\_6\),
                  "TraditionalForm"], " ", 
                FormBox[\(v\&\[RightVector]\_2\),
                  "TraditionalForm"]}]}], " ", "=", " ", 
            RowBox[{
              RowBox[{"2", " ", 
                FormBox[\(v\&\[RightVector]\_3\),
                  "TraditionalForm"]}], " ", "-", " ", 
              RowBox[{"4", "  ", 
                FormBox[\(v\&\[RightVector]\_4\),
                  "TraditionalForm"]}]}]}]}], TraditionalForm]]],
  ","
}], "NumberedEquation"],

Cell["\<\
the other entries can be calculated in a similar way. The related structure \
constants are\
\>", "Text",
  Evaluatable->False,
  CellTags->"structure constants"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`c\_16\%5\  = \ 
        \(c\_24\%2\  = \ 
          \(c\_25\%1\  = \ \ 
            \(c\_46\%6\  = \ \(c\_62\%3\  = \ \(-2\)\)\)\)\)\)]],
  ","
}], "NumberedEquation"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`\(c\_61\%5\  = \ 
      \(c\_42\%2\  = \ 
        \(c\_52\%1\  = \ \(c\_64\%6\  = \ \(c\_26\%3\  = \ 2\)\)\)\), 
    \)\)]]], "NumberedEquation"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`c\_41\%1\  = \ \(c\_45\%5\  = \ \(c\_51\%3\  = \ \(-1\)\)\), \ \ 
    c\_41\%1\  = \ \(c\_55\%5\  = \ \(c\_15\%3\  = \ 1\)\), \)]]], 
  "NumberedEquation"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\(c\_26\%4\  = \ \(-4\), \)\)]],
  "  and  ",
  Cell[BoxData[
      \(TraditionalForm\`c\_62\%4\  = \ 4\)]]
}], "NumberedEquation"],

Cell[TextData[{
  "with all other ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox["c", 
          StyleBox["jk",
            FontSlant->"Italic"], "i"], TraditionalForm]]],
  "\[CloseCurlyQuote]s being zero.\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[EmptySquare]"
}], "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.2 Properties of Lie Algebras", "Subsection",
  CellTags->"Properties of Lie Algebras"],

Cell[TextData[{
  "This section discusses a few properties of Lie algebras useful in the \
classification of the solutions of differential equations. We introduce the \
notion of a ",
  ButtonBox["derived algebra",
    ButtonData:>"derived Lie algebra",
    ButtonStyle->"Hyperlink"],
  ", the ",
  ButtonBox["derivation of an algebra",
    ButtonData:>"derivation of a Lie algebra",
    ButtonStyle->"Hyperlink"],
  ", the ",
  ButtonBox["adjoint algebra",
    ButtonData:>"adjoint Lie algebra",
    ButtonStyle->"Hyperlink"],
  ", the ",
  ButtonBox["Killing form",
    ButtonData:>"Killing form",
    ButtonStyle->"Hyperlink"],
  " of a Lie algebra, and some definitions related to the solvability of a \
Lie algebra."
}], "Text",
  CellTags->{
  "derived algebra", "adjoint algebra", "Killing form", "solvability"}],

Cell[TextData[{
  "If the commutator table or the structure constants are known, it is \
straightforward to calculate the so-called derived Lie algebras. These \
algebras are useful for classifying the Lie algebra. The Lie algebra ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(V\^\((1)\)\  = \)\ \),
            "TraditionalForm"], "[", \(V, V\), "]"}], TraditionalForm]]],
  " is called the first derived algebra of the Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ". By construction, ",
  Cell[BoxData[
      \(TraditionalForm\`V\^\((1)\)\)]],
  " is an ideal. The higher-order derived algebras are recursively defined \
by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "derived Lie algebra", "commutator table", "classify a Lie algebra", 
    "ideal"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(\(V\^\((n + 1)\)\  = \)\ \),
                "TraditionalForm"], " ", 
              FormBox[\([V\^\((n)\)\),
                "TraditionalForm"]}], ",", " ", 
            FormBox[\(V\^\((n)\)\),
              "TraditionalForm"]}], "]"}], " ", ",", "   ", \(n = 1\), ",", 
        "2", ",", "3", ",", \(\[Ellipsis] . \)}], TraditionalForm]]]], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "The derived Lie algebras can be used to classify the original algebra. One \
of the central terms in connection with derived Lie algebras is solvability. \
If a Lie algebra can be classified as solvable, we know that the related \
differential equation can be solved. This observation of Lie is central for \
the solution procedures discussed in C",
  ButtonBox["hapter 4",
    ButtonData:>{"symmet1.nb", None},
    ButtonStyle->"Hyperlink"],
  ". A Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is called solvable if ",
  Cell[BoxData[
      \(TraditionalForm\`V\^\((n)\) = 0\)]],
  " for some ",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontFamily->"I Times Italic"],
  "> 0. The simplest examples are the commutative Lie algebras. With this \
remark, all one- and two-dimensional Lie algebras are solvable. This \
observation will be of importance in S",
  ButtonBox["ection 4.4.2",
    ButtonData:>{"symmet3.nb", "classification of second order algebras"},
    ButtonStyle->"Hyperlink"],
  " where we will use this criterion to integrate second-order and \
higher-order ordinary differential equations. A few examples will illustrate \
the term solvability for partial differential equations."
}], "Text",
  Evaluatable->False,
  CellTags->{"solvability", "solvable", "commutative Lie algebra"}],

Cell["Example 3", "Example"],

Cell[TextData[{
  "The six-dimensional Lie algebra of the diffusion equation with its basis \
",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1, \[Ellipsis], 
      v\&\[RightVector]\_6\)]],
  " is not solvable because the first derived Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\^\((1)\)\)]],
  " contains all operators of the six-dimensional Lie algebra and, thus, \
cannot vanish (cf. ",
  ButtonBox["Table 1",
    ButtonData:>"Table-1",
    ButtonStyle->"Hyperlink"],
  ").\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->"diffusion equation"],

Cell["Example 4", "Example"],

Cell[TextData[{
  "An example of a solvable Lie algebra is given by the vector fields for the \
Korteweg-de Vries (KdV) equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(u\_t\), " ", "+", " ", \(u\ u\_x\), " ", "+", " ", 
            SubscriptBox["u", 
              StyleBox["xxx",
                FontSlant->"Italic"]]}], " ", "=", " ", "0"}], 
        TraditionalForm]]],
  ". The basis of the Lie algebra calculated in C",
  ButtonBox["hapter 5",
    ButtonData:>{"KdVEquation.nb", 
      "The Korteweg-de Vries equation and some Generalizations"},
    ButtonStyle->"Hyperlink"],
  " reads"
}], "Text",
  Evaluatable->False,
  CellTags->{"Korteweg-de Vries equation", "KdV equation"}],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`v\&\[RightVector]\_1\  = \ \[PartialD]\_x, \ 
    v\&\[RightVector]\_2\  = \ \[PartialD]\_t, \ 
    v\&\[RightVector]\_3\  = \ 
      x\ \[PartialD]\_x\ \(+\ 3\) t\ \[PartialD]\_t\ \(-\ 2\) u\ 
        \[PartialD]\_u, \)]]], "NumberedEquation"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`v\&\[RightVector]\_4\  = \ 
      t \[PartialD]\_x\ \(+\ \[PartialD]\_u . \)\)]]], "NumberedEquation"],

Cell["For this equation the commutator table is given by", "Text",
  Evaluatable->False,
  CellTags->"commutator table"],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          RowBox[{"[", 
            FormBox[",",
              "TraditionalForm"], "]"}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "1"]}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "2"]}], 
          RowBox[{
            StyleBox[" ",
              FontSlant->"Italic"], 
            SubscriptBox[
              StyleBox[\(v\&\[RightVector]\),
                FontSlant->"Italic"], "3"]}], 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "4"]}]},
        {
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "1"]}], "0", "0", 
          FractionBox[
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], 
                AdjustmentBox["\[RightVector]",
                  BoxMargins->{{0, 0}, {0.22069, -0.22069}},
                  BoxBaselineShift->-0.22069]], "1"], "2"], "0"},
        {
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "2"]}], "0", "0", 
          FractionBox[
            RowBox[{"3", 
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.22069, -0.22069}},
                    BoxBaselineShift->-0.22069]], "2"]}], "2"], 
          RowBox[{"-", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "1"]}]},
        {
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "3"]}], 
          RowBox[{"-", 
            FractionBox[
              SubscriptBox[
                OverscriptBox[
                  StyleBox["v",
                    FontSlant->"Italic"], 
                  AdjustmentBox["\[RightVector]",
                    BoxMargins->{{0, 0}, {0.22069, -0.22069}},
                    BoxBaselineShift->-0.22069]], "1"], "2"]}], 
          RowBox[{"-", 
            FractionBox[
              RowBox[{"3", 
                SubscriptBox[
                  OverscriptBox[
                    StyleBox["v",
                      FontSlant->"Italic"], 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.22069, -0.22069}},
                      BoxBaselineShift->-0.22069]], "2"]}], "2"]}], "0", 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "4"]}]},
        {
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "4"]}], "0", 
          RowBox[{" ", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "1"]}], 
          RowBox[{"-", 
            SubscriptBox[
              OverscriptBox[
                StyleBox["v",
                  FontSlant->"Italic"], "\[RightVector]"], "4"]}], "0"}
        },
      RowLines->True,
      ColumnLines->True]]]], "NumberedTable",
  CellMargins->{{Inherited, Inherited}, {Inherited, 9}}],

Cell[TextData[{
  "Examining this table, we recognize that the first derived Lie algebra \
contains only the operators ",
  Cell[BoxData[
      \(TraditionalForm
      \`V\^\((1)\)\  = {\ v\&\[RightVector]\_1, v\&\[RightVector]\_2, \ 
          v\&\[RightVector]\_4}\)]],
  ". ",
  Cell[BoxData[
      \(TraditionalForm\`V\^\((1)\)\)]],
  " is just given by the entries in the commutator table. The second derived \
Lie algebra consists only of ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_1\)]],
  ", i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`V\^\((2)\)\  = \ {v\&\[RightVector]\_1}\)]],
  ", thus, the third step gives ",
  Cell[BoxData[
      \(TraditionalForm\`\(V\^\((3)\)\  = {}\ \)\)]],
  ". Thus, the Lie algebra of the KdV equation is solvable. In fact, it is \
known that the KdV equation belongs to the equations, which are completely \
integrable. So far, we manually calculated the Lie algebra and its \
properties. The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " offers a way to do the calculation completely automatically."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "derived Lie algebra", "commutator table", "KdV equation", "MathLie", 
    "infinitesimal symmetries"}],

Cell["\<\
The determination of the solvability was based on a representation \
of the Lie algebra by vector fields. Vector fields in symmetry analysis are, \
on the other hand, based on infinitesimal symmetries. The infinitesimal \
symmetry of the KdV equation is given by\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(infKdV\  = 
      \ {xi[1] \[Rule] Function[{x, t, u}, k3 + k2\ t + k4\ x], 
        xi[2] \[Rule] Function[{x, t, u}, k1 + 3\ k4\ t], 
        phi[1] \[Rule] Function[{x, t, u}, k2 - 2\ k4\ u]}; \)\)], "Input"],

Cell[TextData[{
  "where the constants ",
  Cell[BoxData[
      \(TraditionalForm\`k\_i\)]],
  " represent the group constants connected with the vector field given \
above. How these infinitesimal symmetries are calculated is the subject of C",
  
  ButtonBox["hapter 5",
    ButtonData:>{"KdVEquation.nb", 
      "The Korteweg-de Vries equation and some Generalizations"},
    ButtonStyle->"Hyperlink"],
  ". For the moment, we assume that the infinitesimal symmetries are known. \
This information can be used to apply the function"
}], "Text",
  CellTags->{"vector field", "group constants"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SolvableAlgebrasOfOrderN[infKdV, {u}, {x, t}, 4, 
      VectorFieldRepresentation \[Rule] True]\)], "Input",
  CellTags->"SolvableAlgebrasOfOrderN[]"],

Cell[BoxData[
    \({{V[1], V[2], V[3], V[4]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "to the infinitesimals. The above ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " function also needs the dependent and independent variables and the \
number of elements in the algebra or subalgebra. The option ",
  StyleBox["VectorFieldRepresentation\[Rule]True", "MmaText"],
  " creates the output in the symbols of the vector fields. For the KdV \
equation, we find that the largest solvable Lie algebra is given by the total \
Lie algebra. We also can use this function to create all solvable subalgebras \
for the KdV equation by"
}], "Text",
  CellTags->"KdV equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      SolvableAlgebrasOfOrderN\n\ \ [
          infKdV, {u}, {x, t}, #\n\ \ \ VectorFieldRepresentation \[Rule] 
            True] &, {2, 3, 4}]\)], "Input",
  ShowCellBracket->True,
  CellMargins->{{Inherited, Inherited}, {0, Inherited}},
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{{V[1], V[3]}, {V[1], V[4]}, {V[2], V[3]}, {V[2], V[4]}, {V[3], 
          V[4]}}, {{V[1], V[2], V[3]}, {V[1], V[3], V[4]}, {V[2], V[3], 
          V[4]}}, {{V[1], V[2], V[3], V[4]}}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a list containing all subalgebras of second, third, and \
fourth order. The function ",
  StyleBox["SolvableAlgebrasOfOrderN[]", "MmaText"],
  " is extensively applied in connection with the integration of ordinary \
differential equations.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  CellTags->{"SolvableAlgebrasOfOrderN[]", "subalgebras"}],

Cell[TextData[{
  "Another important property of a Lie algebra useful in the study of \
differential equations is the derivation \[GothicCapitalD] or its \
infinitesimal automorphism. A derivation \[GothicCapitalD] of a Lie algebra ",
  
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is a linear mapping of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " into itself, satisfying"
}], "Text",
  Evaluatable->False,
  CellTags->{"derivation of a Lie algebra", "automorphism", "linear mapping"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[GothicCapitalD]", "(", 
          RowBox[{"[", 
            RowBox[{
              FormBox[\(v\&\[RightVector]\),
                "TraditionalForm"], ",", 
              FormBox[\(w\&\[RightVector]\),
                "TraditionalForm"]}], "]"}], ")"}], " ", "=", " ", 
        RowBox[{
          RowBox[{"[", 
            RowBox[{
              RowBox[{"\[GothicCapitalD]", "(", 
                FormBox[\(v\&\[RightVector]\),
                  "TraditionalForm"], ")"}], ",", 
              FormBox[\(w\&\[RightVector]\),
                "TraditionalForm"]}], "]"}], " ", "+", " ", 
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                FormBox[\(v\&\[RightVector]\),
                  "TraditionalForm"], ",", 
                RowBox[{"\[GothicCapitalD]", "(", 
                  FormBox[\(w\&\[RightVector]\),
                    "TraditionalForm"], ")"}]}], "]"}], "       ", 
            RowBox[{"\[ForAll]", " ", 
              
              FormBox[\(v\&\[RightVector], \ 
                w\&\[RightVector]\ \  \[Element] \ \(V . \)\),
                "TraditionalForm"]}]}]}]}], TraditionalForm]]]], 
  "NumberedEquation"],

Cell[TextData[{
  "It is evident that for two derivations ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_2\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ", the sum \[Alpha] ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_1\)]],
  " + \[Beta] ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_2\)]],
  " is also a derivation. Moreover, if ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalD]\_2\)]],
  " are derivations, then"
}], "Text",
  Evaluatable->False,
  CellTags->"derivation"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[GothicCapitalD]\_1\) 
        \(\(\[GothicCapitalD]\_2\)(\([v\&\[RightVector], w\&\[RightVector]]\))
          \)\  = \ \(\[GothicCapitalD]\_1\)(\ 
        \([\(\[GothicCapitalD]\_2\)(v\&\[RightVector]), w\&\[RightVector]]
            \)\  + \([v\&\[RightVector], 
            \(\[GothicCapitalD]\_2\)(w\&\[RightVector])]\))\ \)\)]]], 
  "NumberedEquation"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{"=", 
                          RowBox[{
                            FormBox[
                              RowBox[{
                                FormBox[\([\[GothicCapitalD]\_1\),
                                  "TraditionalForm"], 
                                \(\[GothicCapitalD]\_2\)}],
                              "TraditionalForm"], 
                            FormBox[\(v\&\[RightVector]\),
                              "TraditionalForm"]}]}], " ", ",", 
                        FormBox[\(w\&\[RightVector]\),
                          "TraditionalForm"]}], "]"}], " ", "+", " ", 
                    RowBox[{
                      FormBox[
                        RowBox[{
                          RowBox[{
                            FormBox[\([\[GothicCapitalD]\_2\),
                              "TraditionalForm"], 
                            FormBox[\(v\&\[RightVector]\),
                              "TraditionalForm"]}], ",", 
                          \(\[GothicCapitalD]\_1\)}],
                        "TraditionalForm"], 
                      FormBox[\(w\&\[RightVector]\),
                        "TraditionalForm"]}]}], "]"}], " ", 
                FormBox[
                  RowBox[{
                    RowBox[{
                      FormBox[\(+\([\[GothicCapitalD]\_1\)\),
                        "TraditionalForm"], 
                      FormBox[\(v\&\[RightVector]\),
                        "TraditionalForm"]}], ",", 
                    \(\[GothicCapitalD]\_2\)}],
                  "TraditionalForm"], 
                FormBox[\(w\&\[RightVector]\),
                  "TraditionalForm"]}], "]"}], " ", "+", " ", 
            RowBox[{
              FormBox[
                RowBox[{
                  FormBox[
                    RowBox[{"[", 
                      RowBox[{
                        FormBox[\(v\&\[RightVector]\),
                          "TraditionalForm"], ",", 
                        \(\[GothicCapitalD]\_1\)}]}],
                    "TraditionalForm"], \(\[GothicCapitalD]\_2\)}],
                "TraditionalForm"], 
              FormBox[\(w\&\[RightVector]\),
                "TraditionalForm"]}]}], "]"}], "."}], TraditionalForm]]]], 
  "NumberedEquation"],

Cell[TextData[{
  "Interchanging the indices 1 and 2",
  StyleBox[" ",
    FontSlant->"Italic"],
  "and subtracting both formulas from each other, we get "
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              FormBox[
                                RowBox[{
                                  FormBox[\([\[GothicCapitalD]\_1\),
                                    "TraditionalForm"], ",", 
                                  \(\[GothicCapitalD]\_2\)}],
                                "TraditionalForm"], "]"}], 
                            RowBox[{"(", 
                              RowBox[{"[", 
                                RowBox[{
                                  FormBox[\(v\&\[RightVector]\),
                                    "TraditionalForm"], ",", 
                                  FormBox[\(w\&\[RightVector]\),
                                    "TraditionalForm"]}], "]"}], ")"}]}], 
                          " ", "=", " ", 
                          FormBox[
                            RowBox[{
                              FormBox[\([\([\[GothicCapitalD]\_1\)\),
                                "TraditionalForm"], ",", 
                              \(\[GothicCapitalD]\_2\)}],
                            "TraditionalForm"]}], "]"}], " ", 
                      FormBox[\(v\&\[RightVector]\),
                        "TraditionalForm"]}], ",", 
                    FormBox[\(w\&\[RightVector]\),
                      "TraditionalForm"]}], "]"}], " ", "+", " ", 
                FormBox[
                  RowBox[{
                    FormBox[
                      RowBox[{"[", 
                        RowBox[{
                          FormBox[\(v\&\[RightVector]\),
                            "TraditionalForm"], ",", 
                          \([\[GothicCapitalD]\_1\)}]}],
                      "TraditionalForm"], ",", \(\[GothicCapitalD]\_2\)}],
                  "TraditionalForm"]}], "]"}], " ", 
            FormBox[\(w\&\[RightVector]\),
              "TraditionalForm"]}], "]"}], TraditionalForm]]],
  ","
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "meaning that the commutator of two derivations is again a derivation. Let \
",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " now be a Lie algebra over the real numbers ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " or the complex numbers \[DoubleStruckCapitalC]. Using the above general \
definitions, we introduce an operation for the classification of Lie \
algebras. "
}], "Text",
  CellTags->{"complex number", "classification of Lie algebras"}],

Cell[TextData[{
  "Consider the linear map ",
  Cell[BoxData[
      FormBox[
        RowBox[{"ad", 
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " into itself defined by"
}], "Text",
  CellTags->"adjoint Lie algebra"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"ad", 
              FormBox[\(v\&\[RightVector]\),
                "TraditionalForm"], 
              RowBox[{"(", 
                FormBox[\(w\&\[RightVector]\),
                  "TraditionalForm"], ")"}]}], " ", ":=", " ", 
            RowBox[{"[", 
              RowBox[{
                FormBox[\(v\&\[RightVector]\),
                  "TraditionalForm"], ",", 
                FormBox[\(w\&\[RightVector]\),
                  "TraditionalForm"]}], "]"}]}], " "}], TraditionalForm]]],
  "    with  ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector], \ 
      w\&\[RightVector]\  \[Element] \ V\)]],
  "."
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Using the Jacobi identity (",
  ButtonBox["iii)",
    ButtonData:>"Jacobi-identity",
    ButtonStyle->"Hyperlink"],
  " in connection with the definition of the derivation, we can write"
}], "Text",
  Evaluatable->False,
  CellTags->"Jacobi-identity"],

Cell[TextData[{
  "ad ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  "([",
  Cell[BoxData[
      \(TraditionalForm\`w\&\[RightVector]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\&\[RightVector]\)]],
  "]) = [ad ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`w\&\[RightVector]\)]],
  "), ",
  Cell[BoxData[
      \(TraditionalForm\`u\&\[RightVector]\)]],
  "] + [",
  Cell[BoxData[
      \(TraditionalForm\`w\&\[RightVector]\)]],
  ", ad ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`u\&\[RightVector]\)]],
  ")];"
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "i.e., the map ",
  Cell[BoxData[
      FormBox[
        RowBox[{"ad", 
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " represents a derivation of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ". Furthermore, from the Jacobi identity and the definition of ad",
  Cell[BoxData[
      \(TraditionalForm\`\(\ v\&\[RightVector]\)\)]],
  ", we obtain"
}], "Text",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"ad", "[", 
            RowBox[{
              FormBox[\(v\&\[RightVector]\),
                "TraditionalForm"], ",", 
              FormBox[\(w\&\[RightVector]\),
                "TraditionalForm"]}], "]"}], 
          RowBox[{"(", 
            FormBox[\(u\&\[RightVector]\),
              "TraditionalForm"], ")"}]}], " ", "=", " ", 
        FormBox[
          RowBox[{
            RowBox[{"[", 
              RowBox[{
                RowBox[{"ad", 
                  FormBox[\(v\&\[RightVector]\),
                    "TraditionalForm"]}], ",", 
                RowBox[{"ad", 
                  FormBox[\(w\&\[RightVector]\),
                    "TraditionalForm"]}]}], "]"}], 
            RowBox[{
              RowBox[{"(", 
                FormBox[\(u\&\[RightVector]\),
                  "TraditionalForm"], ")"}], "."}]}],
          "TraditionalForm"]}], TraditionalForm]]]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Hence, the set ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(V\_a\),
            "TraditionalForm"], " ", "=", " ", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"ad", 
                FormBox[\(v\&\[RightVector]\),
                  "TraditionalForm"]}], "|", " ", 
              RowBox[{
                FormBox[\(v\&\[RightVector]\),
                  "TraditionalForm"], " ", "\[Element]", " ", "V"}]}], 
            "}"}]}], TraditionalForm]]],
  " is a linear Lie algebra and a subset of the Lie algebra of all \
derivations and is called the adjoint algebra. The map ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[CapitalPhi]", " ", ":", " ", 
            FormBox[\(v\&\[RightVector]\),
              "TraditionalForm"]}], " ", "\[Rule]", " ", 
          RowBox[{"ad", 
            FormBox[\(v\&\[RightVector]\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  " is the homomorphism of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " onto ",
  Cell[BoxData[
      \(TraditionalForm\`V\_a\)]],
  ". In addition, the kernel of the homomorphism \[CapitalPhi] is the center \
of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"adjoint algebra", "homomorphism"}],

Cell[TextData[{
  "The representation of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"ad", " ", 
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", called the adjoint representation of the Lie algebra, always provides a \
matrix representation of the algebra. If ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"{", 
            FormBox[\(v\&\[RightVector]\_i\),
              "TraditionalForm"], "}"}]}], TraditionalForm]]],
  " is a ",
  StyleBox["n",
    FontSlant->"Italic"],
  "-dimensional basis for ",
  StyleBox["V",
    FontSlant->"Italic"],
  ", then"
}], "Text",
  Evaluatable->False,
  CellTags->"matrix representation"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`ad  v\&\[RightVector]\_i\)]],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`ad  v\&\[RightVector]\_j\)]],
  ") = ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Sum]\+\(k = 1\)\%n\),
            ScriptLevel->0], " ", 
          RowBox[{
            SubsuperscriptBox["c", 
              StyleBox["ij",
                FontSlant->"Italic"], \(k\ \)], 
            \(v\&\[RightVector]\_k . \)}]}], TraditionalForm]]]
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Therefore, the matrix ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " associated with the transformation ",
  Cell[BoxData[
      \(TraditionalForm\`ad  v\&\[RightVector]\_i\)]],
  " is given by the structure constants"
}], "Text",
  Evaluatable->False,
  CellTags->"structure constants"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubsuperscriptBox[
            RowBox[{
              FormBox[\((A\_i\),
                "TraditionalForm"], ")"}], 
            StyleBox["k",
              FontSlant->"Italic"], "j"],
          "TraditionalForm"], " ", "=", " ", 
        RowBox[{
          FormBox[
            SubsuperscriptBox["c", 
              StyleBox["ik",
                FontSlant->"Italic"], "j"],
            "TraditionalForm"], "."}]}], TraditionalForm]]]], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        SubsuperscriptBox[\((A\_i)\), 
          StyleBox["k",
            FontSlant->"Italic"], "j"], TraditionalForm]]],
  " represents the ",
  Cell[BoxData[
      \(TraditionalForm\`\((j, k)\)\)]],
  StyleBox["th",
    FontVariations->{"CompatibilityType"->0}],
  " entry for the ",
  StyleBox["i",
    FontSlant->"Italic"],
  "th matrix. Note the transposition of the indices",
  StyleBox[" j",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k",
    FontSlant->"Italic"],
  ". So if we know the structure constants of a Lie algebra, we also know the \
matrix representation of the adjoint Lie algebra."
}], "Text",
  Evaluatable->False,
  CellTags->"matrix representation"],

Cell["Example 5", "Example"],

Cell["\<\
As an example, let us examine the rotations about the three \
coordinate axes X, Y, and\[NonBreakingSpace]\[NoBreak]Z. The group of the \
rotation can be represented by the three matrices \
\>", "Text",
  CellTags->"rotation"],

Cell[BoxData[
    \(Rx[\[Alpha]_] := {{1, 0, 0}, \n
        \t\t{0, Cos[\[Alpha]], \(-Sin[\[Alpha]]\)}, \n
        \t\t{0, Sin[\[Alpha]], Cos[\[Alpha]]}}\)], "Input"],

Cell[BoxData[
    \(Ry[\[Beta]_] := {{Cos[\[Beta]], 0, Sin[\[Beta]]}, \n
        \t\t{0, 1, 0}, {\(-Sin[\[Beta]]\), 0, Cos[\[Beta]]}}\)], "Input"],

Cell[BoxData[
    \(Rz[\[Gamma]_] := {{Cos[\[Gamma]], \(-Sin[\[Gamma]]\), 0}, \n
        \t\t{Sin[\[Gamma]], Cos[\[Gamma]], 0}, {0, 0, 1}}\)], "Input"],

Cell["\<\
A representation of the corresponding Lie algebra follows if we \
calculate the first coefficient of a Taylor expansion around the identity, \
meaning that the representation of the Lie algebra is given by the first \
derivatives with respect to the parameter around the identical rotation.\
\>",
   "Text",
  Evaluatable->False,
  CellTags->{"Taylor expansion", "representation of Lie algebras"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(e\_1 = \[PartialD]\_\[Alpha] Rx[\[Alpha]] /. \[Alpha] \[Rule] 0; 
    MatrixForm[e\_1]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "0"},
            {"0", "0", \(-1\)},
            {"0", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(e\_2 = \[PartialD]\_\[Beta] Ry[\[Beta]] /. \[Beta] \[Rule] 0; 
    MatrixForm[e\_2]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "1"},
            {"0", "0", "0"},
            {\(-1\), "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["and", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(e\_3 = \[PartialD]\_\[Gamma] Rz[\[Gamma]] /. \[Gamma] \[Rule] 0; 
    MatrixForm[e\_3]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", \(-1\), "0"},
            {"1", "0", "0"},
            {"0", "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "These three matrices also build the basis for the Lie algebra ",
  StyleBox["so",
    FontSlant->"Italic"],
  "(3). We will see in C",
  ButtonBox["hapter 4",
    ButtonData:>{"symmet1.nb", "Infinitesimal transformations"},
    ButtonStyle->"Hyperlink"],
  " that the matrices ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`e\&\[RightVector]\_3\)]],
  " are the infinitesimal generators of the Lie group. At the other hand, we \
know from our examinations above that the structure constants of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["so",
            FontSlant->"Italic"], "(", "3", ")"}], TraditionalForm]]],
  " are given by the Levi-Civita tensor. Knowing the structure constants, we \
also know a representation of the adjoint Lie algebra. The structure \
constants of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["so",
            FontSlant->"Italic"], "(", "3", ")"}], TraditionalForm]]],
  " are",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[
              SubsuperscriptBox["c", 
                StyleBox[\(i j\),
                  FontSlant->"Italic"], "k"],
              "TraditionalForm"], "=", 
            FormBox[
              SubsuperscriptBox["\[Epsilon]", 
                StyleBox["ij",
                  FontSlant->"Italic"], "k"],
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". Applying relation (2.30), we can represent the adjoint Lie algebra by"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "so(3)", "Levi-Civita tensor", "Lie group", "adjoint Lie algebra"}],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          SubsuperscriptBox[
            RowBox[{
              FormBox[\((A\_i\),
                "TraditionalForm"], ")"}], 
            StyleBox["k",
              FontSlant->"Italic"], "j"],
          "TraditionalForm"], " ", "=", " ", 
        RowBox[{
          FormBox[
            SubsuperscriptBox["c", 
              StyleBox["ik",
                FontSlant->"Italic"], "j"],
            "TraditionalForm"], " ", "=", " ", 
          RowBox[{
            FormBox[
              SubsuperscriptBox["\[Epsilon]", 
                StyleBox["ik",
                  FontSlant->"Italic"], "j"],
              "TraditionalForm"], " ", "=", " ", 
            RowBox[{
              FormBox[
                RowBox[{"-", 
                  SubsuperscriptBox["\[Epsilon]", 
                    StyleBox["ij",
                      FontSlant->"Italic"], "k"]}],
                "TraditionalForm"], "."}]}]}]}], TraditionalForm]]]], 
  "NumberedEquation"],

Cell["So the matrices", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ae\_1 = 
      MatrixForm[Array[\(-LeviCivita[1, #1, #2]\)&, \n\t\t\t{3, 3}]]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "0"},
            {"0", "0", \(-1\)},
            {"0", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ae\_2 = 
      MatrixForm[Array[\(-LeviCivita[2, #1, #2]\)&, \n\t\t\t{3, 3}]]\)], 
  "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "1"},
            {"0", "0", "0"},
            {\(-1\), "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["and", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ae\_3 = 
      MatrixForm[Array[\(-LeviCivita[3, #1, #2]\) &, \n\t\t\t{3, 3}]]\)], 
  "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", \(-1\), "0"},
            {"1", "0", "0"},
            {"0", "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "are the adjoint representation of the Lie algebra ",
  StyleBox["so",
    FontSlant->"Italic"],
  "(3)",
  StyleBox[".",
    FontSlant->"Italic"],
  " In fact, these matrices are identical with the original matrices of ",
  StyleBox["so",
    FontSlant->"Italic"],
  "(3)",
  StyleBox[". ",
    FontSlant->"Italic"],
  "In the above input lines, we used as argument of ",
  StyleBox["Array[]", "MmaText"],
  " a pure function. A pure function in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is terminated by ",
  StyleBox["&", "MmaText"],
  " and allows so-called slots (",
  StyleBox["#1", "MmaText"],
  ", ",
  StyleBox["#2", "MmaText"],
  ") as input channels. In the above lines, the function ",
  StyleBox["LeviCivita[]", "MmaText"],
  " with two slots and one fixed argument was used as a pure function.\
\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"Array[]", "slot", "LeviCivita[]"}],

Cell[TextData[{
  "With the definition of the adjoint algebra, we introduced the homomorphism \
",
  Cell[BoxData[
      \(TraditionalForm
      \`v\&\[RightVector]\  \[Rule] \ ad  v\&\[RightVector]\)]],
  ". In terms of coordinates, we have"
}], "Text",
  Evaluatable->False,
  CellTags->{"homomorphism", "adjoined algebra"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            SuperscriptBox[
              RowBox[{"{", 
                RowBox[{
                  FormBox[\(ad\ v\&\[RightVector]\),
                    "TraditionalForm"], 
                  RowBox[{"(", 
                    FormBox[\(ad\ w\&\[RightVector]\),
                      "TraditionalForm"], ")"}]}], "}"}], "i"],
            "TraditionalForm"], " ", "=", " ", 
          RowBox[{
            FormBox[
              SuperscriptBox[
                RowBox[{"[", 
                  RowBox[{
                    FormBox[\(v\&\[RightVector]\),
                      "TraditionalForm"], ",", 
                    FormBox[\(w\&\[RightVector]\),
                      "TraditionalForm"]}], "]"}], "i"],
              "TraditionalForm"], " ", "=", " ", 
            FormBox[
              RowBox[{
                RowBox[{
                  RowBox[{"ad", 
                    RowBox[{\(\(v\& \[RightVector] \)\_i\), "(", 
                      FormBox[\(ad \( v\& \[RightVector] \)\_j\),
                        "TraditionalForm"], ")"}]}], " ", "=", " ", 
                  RowBox[{
                    FormBox[
                      RowBox[{
                        StyleBox[\(\[Sum]\+\(k, l = 1\)\%n\),
                          ScriptLevel->0], " "}],
                      "TraditionalForm"], " ", 
                    SubsuperscriptBox["c", 
                      StyleBox["lk",
                        FontSlant->"Italic"], \(i\ \)], " ", \(v\^l\), " ", 
                    \(w\^k\)}]}], " "}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  ","
}], "NumberedEquation",
  Evaluatable->False],

Cell["i.e.,", "Text",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{
              SubsuperscriptBox[
                RowBox[{"(", 
                  FormBox[\(ad\ v\&\[RightVector]\),
                    "TraditionalForm"], ")"}], "k", "i"], " ", "="}], " "}],
          "TraditionalForm"], " ", 
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{"ad", 
                  RowBox[{\(\(v\& \[RightVector] \)\_i\), "(", 
                    FormBox[\(ad \( v\& \[RightVector] \)\_j\),
                      "TraditionalForm"], ")"}]}], " ", "=", " ", 
                RowBox[{
                  FormBox[
                    StyleBox[\(\[Sum]\+\(l = 1\)\%n\),
                      ScriptLevel->0],
                    "TraditionalForm"], " ", 
                  SubsuperscriptBox["c", 
                    StyleBox["lk",
                      FontSlant->"Italic"], "i"], " ", \(v\^l\)}]}], " "}],
            "TraditionalForm"], "."}]}], TraditionalForm]]]], 
  "NumberedEquation",
  Evaluatable->False],

Cell["\<\
Using these relations, we are able to define a scalar product in a \
Lie algebra by the following relation,\
\>", "Text",
  Evaluatable->False,
  CellTags->"scalar product"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{"\[LeftAngleBracket]", 
          
          FormBox[\(\(v\&\[RightVector], \ 
                w\&\[RightVector]\[RightAngleBracket]\)\  = \ 
              \(Tr(ad  v\&\[RightVector]\ ad  w\&\[RightVector]) . \)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " "
}], "NumberedEquation",
  Evaluatable->False],

Cell["This product satisfies the following properties:", "Text",
  Evaluatable->False],

Cell["Symmetry", "ListItem",
  CellDingbat->"(i)",
  CellTags->"symmetry"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`\(\[LeftAngleBracket]v\&\[RightVector], 
        w\&\[RightVector]\[RightAngleBracket]\  = \ 
      \[LeftAngleBracket]w\&\[RightVector], 
        v\&\[RightVector]\[RightAngleBracket]\ \)\)]]], "NumberedEquation",
  Evaluatable->False],

Cell["Bilinearity", "ListItem",
  CellDingbat->"(ii)",
  CellTags->"bilinearity"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[LeftAngleBracket]\[Alpha]  v\&\[RightVector]\  + \ 
            \[Beta]\ w\&\[RightVector], u\&\[RightVector]\ 
          \[RightAngleBracket]\  = \ 
        \[Alpha]\ 
            \[LeftAngleBracket]v\&\[RightVector], 
              u\&\[RightVector]\[RightAngleBracket]\  + \ 
          \[Beta]\ \[LeftAngleBracket]w\&\[RightVector], 
              u\&\[RightVector]\[RightAngleBracket]\ \)\)]],
  " "
}], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "for all ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector], \ w\&\[RightVector]\ , 
      u\&\[RightVector]\ \  \[Element] \ V\)]],
  " and \[Alpha], \[Beta] \[Element] \[DoubleStruckCapitalR] or \
\[DoubleStruckCapitalC]. And, the relation"
}], "ListItem",
  Evaluatable->False],

Cell["", "ListItem",
  CellDingbat->"(iii)",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{"\[LeftAngleBracket]", 
        FormBox[
          \(\(ad \(\( v\&\[RightVector]\)(w\&\[RightVector])\), 
                u\&\[RightVector]\[RightAngleBracket]\)\ \  + \ 
              \[LeftAngleBracket]w\&\[RightVector], 
                ad \(\( v\&\[RightVector]\)(u\&\[RightVector])
                    \)\[RightAngleBracket]\  = \ 0\),
          "TraditionalForm"]}], TraditionalForm]]]], "NumberedEquation",
  Evaluatable->False],

Cell["or", "ListItem",
  Evaluatable->False],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{"[", 
                RowBox[{
                  FormBox[\(v\&\[RightVector]\),
                    "TraditionalForm"], ",", 
                  FormBox[\(w\&\[RightVector]\),
                    "TraditionalForm"]}], "]"}], ",", 
              FormBox[\(u\&\[RightVector]\),
                "TraditionalForm"]}], "\[RightAngleBracket]"}], " ", "+", 
          " ", 
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              FormBox[\(w\&\[RightVector]\),
                "TraditionalForm"], ",", 
              RowBox[{"[", 
                RowBox[{
                  FormBox[\(v\&\[RightVector]\),
                    "TraditionalForm"], ",", 
                  FormBox[\(u\&\[RightVector]\),
                    "TraditionalForm"]}], "]"}]}], 
            "\[RightAngleBracket]"}]}], " ", "=", " ", "0."}], 
      TraditionalForm]]]], "NumberedEquation",
  Evaluatable->False],

Cell["\<\
These properties are immediately derived from the properties of the \
trace.\
\>", "Text",
  Evaluatable->False,
  CellTags->"trace"],

Cell[TextData[{
  "The symmetric bilinear form",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"\[LeftAngleBracket]", 
            
            FormBox[\(v\&\[RightVector], \ 
                w\&\[RightVector]\[RightAngleBracket]\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`V\ \[Times]\ V\)]],
  " is called the Killing form of the Lie algebra. In terms of the \
coordinates, this expression is given by"
}], "Text",
  Evaluatable->False,
  CellTags->"Killing form"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(\[LeftAngleBracket]v\&\[RightVector], \ 
            w\&\[RightVector]\[RightAngleBracket]\), " ", "=", " ", 
          RowBox[{
          \(Tr(\((ad  v\&\[RightVector])\)\_k\%i\ 
                \((ad  w\&\[RightVector])\)\_i\%l)\), " ", "=", " ", 
            RowBox[{
              StyleBox[
                UnderoverscriptBox["\[Sum]", 
                  RowBox[{
                    StyleBox["l",
                      ScriptLevel->0], 
                    StyleBox[",",
                      ScriptLevel->0], 
                    RowBox[{
                      StyleBox["k",
                        ScriptLevel->0], "=", "1"}]}], "n"],
                ScriptLevel->0], " ", 
              RowBox[{
                SubsuperscriptBox["c", 
                  StyleBox["lk",
                    FontSlant->"Italic"], "i"], " ", \(v\^l\), " ", 
                SubsuperscriptBox["c", 
                  StyleBox["mi",
                    FontSlant->"Italic"], "k"], " ", \(w\^m\)}]}]}]}], " "}], 
      TraditionalForm]]]], "DisplayFormula",
  Evaluatable->False],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"=", " ", 
          RowBox[{
            StyleBox[
              UnderoverscriptBox["\[Sum]", 
                RowBox[{
                  StyleBox["l",
                    ScriptLevel->0], 
                  StyleBox[",",
                    ScriptLevel->0], 
                  RowBox[{
                    StyleBox["m",
                      ScriptLevel->0], "=", "1"}]}], "n"],
              ScriptLevel->0], " ", 
            RowBox[{
              SubscriptBox["g", 
                StyleBox["lm",
                  FontSlant->"Italic"]], \(v\^l\), " ", \(w\^m\)}]}]}], 
        ","}], TraditionalForm]], "NumberedEquation",
  FormatType->TraditionalForm],

Cell["where the symmetric second-rank tensor", "Text",
  Evaluatable->False,
  CellTags->"second rank tensor"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["g", 
            StyleBox["lm",
              FontSlant->"Italic"]], " ", "=", " ", 
          RowBox[{
            StyleBox[
              UnderoverscriptBox["\[Sum]", 
                RowBox[{
                  StyleBox["i",
                    ScriptLevel->0], 
                  StyleBox[",",
                    ScriptLevel->0], 
                  RowBox[{
                    StyleBox["k",
                      ScriptLevel->0], "=", "1"}]}], "n"],
              ScriptLevel->0], " ", 
            RowBox[{
              SubsuperscriptBox["c", 
                StyleBox["lk",
                  FontSlant->"Italic"], "i"], " ", 
              SubsuperscriptBox["c", 
                StyleBox["mi",
                  FontSlant->"Italic"], "k"]}]}]}], " "}], 
      TraditionalForm]]]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "is called the Cartan metric tensor of the Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ". Note that for some algebras the Killing form can be degenerate. \
Especially for commutative algebras we find degeneration; i.e., ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"det", " ", 
              FormBox[
                RowBox[{"(", 
                  SubscriptBox["g", 
                    StyleBox["ik",
                      FontSlant->"Italic"]]}],
                "TraditionalForm"]}], ")"}], " ", "=", " ", "0."}], 
        TraditionalForm]]]
}], "Text",
  Evaluatable->False,
  CellTags->{"Cartan metric tensor", "commutative algebra", "degeneration"}],

Cell[TextData[{
  "The Killing form and the Cartan metric tensor play a fundamental role in \
the theory of Lie algebras and their representations. For example, a simple \
criterion for the solvability of a Lie algebra in terms of the Killing form \
is: if ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]v\&\[RightVector], 
          v\&\[RightVector]\[RightAngleBracket]\  = 0\)]],
  " for each ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\  \[Element] \ V\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is called a solvable Lie algebra, or if an algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is nilpotent, then ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]v\&\[RightVector], 
          v\&\[RightVector]\[RightAngleBracket]\  = 0\)]],
  " for all ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\  \[Element] \ V\)]],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "solvable Lie algebra", "nilpotent", "solvability of a Lie algebra"}],

Cell["\<\
We have separated the type of solvable and nilpotent algebras from \
the set of all Lie algebras by the above criteria. However, we do not know \
much about the terms simple and semisimple Lie algebras. In the following, we \
define the class of simple and semisimple Lie algebras, which are important \
in the study of the structure and classification of Lie algebras\
\>", "Text",\

  Evaluatable->False,
  CellTags->{
  "simple Lie algebra", "semisimple Lie algebra", "nilpotent algebra"}],

Cell["Definition: Semisimple Lie algebra", "Definition",
  CellTags->"Definition: Semisimple Lie algebra"],

Cell[TextData[{
  "A Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is semisimple if it has a non-zero commutative ideal.\[ThickSpace]\
\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "Text",
  CellTags->"commutative ideal"],

Cell["\<\
The criterion for semisimplicity is given by the following theorem:\
\>", "Text",
  Evaluatable->False],

Cell[TextData["Theorem: Cartan\[CloseCurlyQuote]s theorem"], "Theorem",
  CellTags->"Theorem: Cartans theorem"],

Cell[TextData[{
  "A Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is semisimple if and only if its Killing form is non-degenerate.\
\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "Text",
  CellTags->{"semisimple", "Killing form"}],

Cell["\<\
This theorem of Cartan is useful for classifying the algebras \
obtained in the symmetry analysis as semisimple or not. A simple Lie algebra \
is defined as follows:\
\>", "Text",
  CellTags->"Cartan"],

Cell["Definition: Simple Lie algebra", "Definition",
  CellTags->"Definition: Simple Lie algebra"],

Cell[TextData[{
  "A Lie algebra ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is simple if it has no ideals other than {0} and ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " and if ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(V\^\((1)\)\),
            "TraditionalForm"], " ", "=", " ", 
          \(\([V, V]\)\  \[NotEqual] \ 0\)}], TraditionalForm]]],
  ".\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "Text"],

Cell["\<\
The discussed terms are useful for expressing some relations of differential \
equations in the following sections. All are the basis for a theory which is \
general in its settings and can be used in different applications of physics \
and mathematics.\
\>", "Text",
  Evaluatable->False],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"derivat.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{802, 649},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingStartingPageNumber->22,
PrintingPageRange->{33, 33},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Elements of Symmetry Analysis", FontSlant -> "Italic"]}],
         "Header"], Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Lie Algebras"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Hyperlinks"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Lie algebras"->{
    Cell[1739, 51, 351, 6, 52, "Section",
      Evaluatable->False,
      CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Lie algebras"]},
  "tangent space"->{
    Cell[2093, 59, 971, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent space", "Lie algebra", "locally isomorphic", 
        "finite dimensional algebra", "linear algebraic structure"}],
    Cell[3067, 80, 2071, 56, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie algebra", "analytic manifold", "tangent space", "parameters", 
        "infinitesimal operator"}]},
  "Lie algebra"->{
    Cell[2093, 59, 971, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent space", "Lie algebra", "locally isomorphic", 
        "finite dimensional algebra", "linear algebraic structure"}],
    Cell[3067, 80, 2071, 56, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie algebra", "analytic manifold", "tangent space", "parameters", 
        "infinitesimal operator"}],
    Cell[7320, 210, 149, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"Lie algebra"],
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}],
    Cell[53325, 1669, 2130, 58, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "structure constants", 
        "Lie algebra", "skew-symmetric", "Lie bracket"}]},
  "locally isomorphic"->{
    Cell[2093, 59, 971, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent space", "Lie algebra", "locally isomorphic", 
        "finite dimensional algebra", "linear algebraic structure"}]},
  "finite dimensional algebra"->{
    Cell[2093, 59, 971, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent space", "Lie algebra", "locally isomorphic", 
        "finite dimensional algebra", "linear algebraic structure"}]},
  "linear algebraic structure"->{
    Cell[2093, 59, 971, 19, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "tangent space", "Lie algebra", "locally isomorphic", 
        "finite dimensional algebra", "linear algebraic structure"}]},
  "analytic manifold"->{
    Cell[3067, 80, 2071, 56, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie algebra", "analytic manifold", "tangent space", "parameters", 
        "infinitesimal operator"}]},
  "parameters"->{
    Cell[3067, 80, 2071, 56, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie algebra", "analytic manifold", "tangent space", "parameters", 
        "infinitesimal operator"}]},
  "infinitesimal operator"->{
    Cell[3067, 80, 2071, 56, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie algebra", "analytic manifold", "tangent space", "parameters", 
        "infinitesimal operator"}]},
  "linear operator"->{
    Cell[6092, 171, 468, 14, 54, "Text",
      Evaluatable->False,
      CellTags->"linear operator"]},
  "Definition: Lie algebra"->{
    Cell[7472, 217, 84, 1, 38, "Definition",
      CellTags->"Definition: Lie algebra"]},
  "finite-dimensional vector space"->{
    Cell[7559, 220, 750, 23, 75, "Text",
      CellTags->{"finite-dimensional vector space", "axioms"}]},
  "axioms"->{
    Cell[7559, 220, 750, 23, 75, "Text",
      CellTags->{"finite-dimensional vector space", "axioms"}]},
  "antisymmetry"->{
    Cell[8312, 245, 163, 4, 26, "ListItem",
      Evaluatable->False,
      CellTags->"antisymmetry"]},
  "linearity"->{
    Cell[9114, 270, 136, 3, 26, "ListItem",
      CellTags->"linearity"]},
  "Jacobi-identity"->{
    Cell[10812, 315, 149, 3, 26, "ListItem",
      CellTags->"Jacobi-identity"],
    Cell[27631, 877, 104, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"Jacobi-identity"],
    Cell[91853, 2736, 270, 8, 33, "Text",
      Evaluatable->False,
      CellTags->"Jacobi-identity"]},
  "Lie product"->{
    Cell[12603, 363, 1233, 37, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie product", "Lie bracket", "commutative algebra", 
        "non-associative"}],
    Cell[24096, 750, 365, 13, 33, "Text",
      Evaluatable->False,
      CellTags->{"Lie product", "commutator"}],
    Cell[41406, 1284, 790, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator", "Lie product", "vector space", "differential operator"}],
    Cell[51529, 1608, 319, 11, 33, "Text",
      Evaluatable->False,
      CellTags->"Lie product"]},
  "Lie bracket"->{
    Cell[12603, 363, 1233, 37, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie product", "Lie bracket", "commutative algebra", 
        "non-associative"}],
    Cell[27113, 855, 110, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"Lie bracket"],
    Cell[28170, 899, 355, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"LieProduct[]", "Lie bracket"}],
    Cell[45850, 1416, 122, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"Lie bracket"],
    Cell[53325, 1669, 2130, 58, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "structure constants", 
        "Lie algebra", "skew-symmetric", "Lie bracket"}]},
  "commutative algebra"->{
    Cell[12603, 363, 1233, 37, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie product", "Lie bracket", "commutative algebra", 
        "non-associative"}],
    Cell[116314, 3549, 740, 20, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "Cartan metric tensor", "commutative algebra", "degeneration"}]},
  "non-associative"->{
    Cell[12603, 363, 1233, 37, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "Lie product", "Lie bracket", "commutative algebra", 
        "non-associative"}]},
  "subalgebra"->{
    Cell[13839, 402, 869, 28, 75, "Text",
      Evaluatable->False,
      CellTags->{"subalgebra", "ideal", "maximal ideal", "center"}],
    Cell[19078, 573, 552, 13, 75, "Text",
      Evaluatable->False,
      CellTags->{"subalgebra", "restrictions on structure constants"}]},
  "ideal"->{
    Cell[13839, 402, 869, 28, 75, "Text",
      Evaluatable->False,
      CellTags->{"subalgebra", "ideal", "maximal ideal", "center"}],
    Cell[20095, 603, 112, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"ideal"],
    Cell[69510, 2117, 807, 21, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "classify a Lie algebra", 
        "ideal"}]},
  "maximal ideal"->{
    Cell[13839, 402, 869, 28, 75, "Text",
      Evaluatable->False,
      CellTags->{"subalgebra", "ideal", "maximal ideal", "center"}]},
  "center"->{
    Cell[13839, 402, 869, 28, 75, "Text",
      Evaluatable->False,
      CellTags->{"subalgebra", "ideal", "maximal ideal", "center"}]},
  "commutator"->{
    Cell[14711, 432, 1159, 35, 54, "Text",
      Evaluatable->False,
      CellTags->{"commutator", "coordinates"}],
    Cell[24096, 750, 365, 13, 33, "Text",
      Evaluatable->False,
      CellTags->{"Lie product", "commutator"}],
    Cell[41406, 1284, 790, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator", "Lie product", "vector space", "differential operator"}],
    Cell[46531, 1444, 161, 4, 33, "Text",
      CellTags->{"commutator", "Levi-Civita"}]},
  "coordinates"->{
    Cell[14711, 432, 1159, 35, 54, "Text",
      Evaluatable->False,
      CellTags->{"commutator", "coordinates"}]},
  "structure constant"->{
    Cell[16391, 484, 956, 32, 55, "Text",
      Evaluatable->False,
      CellTags->"structure constant"]},
  "restrictions on structure constants"->{
    Cell[19078, 573, 552, 13, 75, "Text",
      Evaluatable->False,
      CellTags->{"subalgebra", "restrictions on structure constants"}]},
  "Pauli matrices"->{
    Cell[20819, 626, 413, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{"Pauli matrices", "spin matrices"}],
    Cell[29136, 932, 2315, 64, 117, "Text",
      CellTags->{
      "Levi-Civita density", "Pauli matrices", "real Lie algebra", 
        "LeviCivita[]"}],
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}]},
  "spin matrices"->{
    Cell[20819, 626, 413, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{"Pauli matrices", "spin matrices"}]},
  "skew-Hermitian matrices"->{
    Cell[21266, 638, 467, 14, 54, "Text",
      Evaluatable->False,
      CellTags->{"skew-Hermitian matrices", "quantum mechanics"}]},
  "quantum mechanics"->{
    Cell[21266, 638, 467, 14, 54, "Text",
      Evaluatable->False,
      CellTags->{"skew-Hermitian matrices", "quantum mechanics"}]},
  "matrix product"->{
    Cell[25348, 791, 328, 9, 54, "Text",
      Evaluatable->False,
      CellTags->"matrix product"]},
  "antisymmetric"->{
    Cell[25781, 806, 1004, 31, 54, "Text",
      Evaluatable->False,
      CellTags->"antisymmetric"]},
  "LieProduct[]"->{
    Cell[28170, 899, 355, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"LieProduct[]", "Lie bracket"}]},
  "eq-5"->{
    Cell[28528, 910, 605, 20, 27, "NumberedEquation",
      Evaluatable->False,
      CellTags->"eq-5"]},
  "Levi-Civita density"->{
    Cell[29136, 932, 2315, 64, 117, "Text",
      CellTags->{
      "Levi-Civita density", "Pauli matrices", "real Lie algebra", 
        "LeviCivita[]"}],
    Cell[36728, 1124, 2440, 80, 183, "Text",
      Evaluatable->False,
      CellTags->{
      "Union[]", "Length[]", "Signature[]", "Levi-Civita density", 
        "signature", "permutation"}],
    Cell[44010, 1358, 631, 19, 54, "Text",
      Evaluatable->False,
      CellTags->{"Cartesian", "Levi-Civita density"}]},
  "real Lie algebra"->{
    Cell[29136, 932, 2315, 64, 117, "Text",
      CellTags->{
      "Levi-Civita density", "Pauli matrices", "real Lie algebra", 
        "LeviCivita[]"}]},
  "LeviCivita[]"->{
    Cell[29136, 932, 2315, 64, 117, "Text",
      CellTags->{
      "Levi-Civita density", "Pauli matrices", "real Lie algebra", 
        "LeviCivita[]"}],
    Cell[104912, 3201, 981, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{"Array[]", "slot", "LeviCivita[]"}]},
  "Union[]"->{
    Cell[36728, 1124, 2440, 80, 183, "Text",
      Evaluatable->False,
      CellTags->{
      "Union[]", "Length[]", "Signature[]", "Levi-Civita density", 
        "signature", "permutation"}]},
  "Length[]"->{
    Cell[36728, 1124, 2440, 80, 183, "Text",
      Evaluatable->False,
      CellTags->{
      "Union[]", "Length[]", "Signature[]", "Levi-Civita density", 
        "signature", "permutation"}]},
  "Signature[]"->{
    Cell[36728, 1124, 2440, 80, 183, "Text",
      Evaluatable->False,
      CellTags->{
      "Union[]", "Length[]", "Signature[]", "Levi-Civita density", 
        "signature", "permutation"}]},
  "signature"->{
    Cell[36728, 1124, 2440, 80, 183, "Text",
      Evaluatable->False,
      CellTags->{
      "Union[]", "Length[]", "Signature[]", "Levi-Civita density", 
        "signature", "permutation"}]},
  "permutation"->{
    Cell[36728, 1124, 2440, 80, 183, "Text",
      Evaluatable->False,
      CellTags->{
      "Union[]", "Length[]", "Signature[]", "Levi-Civita density", 
        "signature", "permutation"}]},
  "CommutativeQ[]"->{
    Cell[39171, 1206, 1009, 30, 96, "Text",
      Evaluatable->False,
      CellTags->"CommutativeQ[]"],
    Cell[48234, 1508, 334, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"CommutativeQ[]", "Table[]"}],
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}]},
  "structure constants"->{
    Cell[40876, 1262, 287, 9, 33, "Text",
      Evaluatable->False,
      CellTags->{"structure constants", "tensor"}],
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}],
    Cell[53325, 1669, 2130, 58, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "structure constants", 
        "Lie algebra", "skew-symmetric", "Lie bracket"}],
    Cell[67225, 2036, 172, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"structure constants"],
    Cell[96936, 2913, 314, 10, 33, "Text",
      Evaluatable->False,
      CellTags->"structure constants"]},
  "tensor"->{
    Cell[40876, 1262, 287, 9, 33, "Text",
      Evaluatable->False,
      CellTags->{"structure constants", "tensor"}]},
  "vector space"->{
    Cell[41406, 1284, 790, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator", "Lie product", "vector space", 
        "differential operator"}]},
  "differential operator"->{
    Cell[41406, 1284, 790, 19, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator", "Lie product", "vector space", "differential operator"}],
    Cell[42330, 1310, 570, 10, 96, "Text",
      CellTags->{
      "representation", "matrix representation of Lie algebras", 
        "differential operator"}],
    Cell[51851, 1621, 719, 21, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "differential operator", "symmetries of differential equations", 
        "heat equation"}]},
  "Representation of a Lie Algebra"->{
    Cell[42221, 1307, 106, 1, 49, "Subsection",
      CellTags->"Representation of a Lie Algebra"]},
  "representation"->{
    Cell[42330, 1310, 570, 10, 96, "Text",
      CellTags->{
      "representation", "matrix representation of Lie algebras", 
        "differential operator"}],
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}]},
  "matrix representation of Lie algebras"->{
    Cell[42330, 1310, 570, 10, 96, "Text",
      CellTags->{
      "representation", "matrix representation of Lie algebras", 
        "differential operator"}]},
  "rotation"->{
    Cell[42935, 1324, 412, 8, 75, "Text",
      CellTags->{"rotation", "symmetry of rotation"}],
    Cell[98594, 2974, 236, 5, 54, "Text",
      CellTags->"rotation"]},
  "symmetry of rotation"->{
    Cell[42935, 1324, 412, 8, 75, "Text",
      CellTags->{"rotation", "symmetry of rotation"}]},
  "Cartesian"->{
    Cell[44010, 1358, 631, 19, 54, "Text",
      Evaluatable->False,
      CellTags->{"Cartesian", "Levi-Civita density"}]},
  "Levi-Civita"->{
    Cell[46531, 1444, 161, 4, 33, "Text",
      CellTags->{"commutator", "Levi-Civita"}]},
  "Table[]"->{
    Cell[48234, 1508, 334, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"CommutativeQ[]", "Table[]"}]},
  "so(3)"->{
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}],
    Cell[100911, 3058, 1778, 51, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "so(3)", "Levi-Civita tensor", "Lie group", "adjoint Lie algebra"}]},
  "orthogonal group"->{
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}]},
  "isomorphic"->{
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}]},
  "representations of Lie algebras"->{
    Cell[48833, 1531, 1604, 38, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
        "Pauli matrices", "isomorphic", "representations of Lie algebras", 
        "structure constants", "representation"}]},
  "representation of a Lie algebra"->{
    Cell[50440, 1571, 362, 11, 54, "Text",
      Evaluatable->False,
      CellTags->"representation of a Lie algebra"]},
  "symmetries of differential equations"->{
    Cell[51851, 1621, 719, 21, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "differential operator", "symmetries of differential equations", 
        "heat equation"}]},
  "heat equation"->{
    Cell[51851, 1621, 719, 21, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "differential operator", "symmetries of differential equations", 
        "heat equation"}]},
  "commutator table"->{
    Cell[53325, 1669, 2130, 58, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "structure constants", 
        "Lie algebra", "skew-symmetric", "Lie bracket"}],
    Cell[69510, 2117, 807, 21, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "classify a Lie algebra", 
        "ideal"}],
    Cell[74084, 2245, 120, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"commutator table"],
    Cell[78156, 2360, 1237, 31, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "KdV equation", "MathLie", 
        "infinitesimal symmetries"}]},
  "vector field"->{
    Cell[53325, 1669, 2130, 58, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "structure constants", 
        "Lie algebra", "skew-symmetric", "Lie bracket"}],
    Cell[79943, 2407, 596, 14, 75, "Text",
      CellTags->{"vector field", "group constants"}]},
  "skew-symmetric"->{
    Cell[53325, 1669, 2130, 58, 181, "Text",
      Evaluatable->False,
      CellTags->{
      "commutator table", "vector field", "structure constants", 
        "Lie algebra", "skew-symmetric", "Lie bracket"}]},
  "Table-1"->{
    Cell[55458, 1729, 10551, 270, 181, "NumberedTable",
      CellTags->"Table-1"]},
  "Properties of Lie Algebras"->{
    Cell[68589, 2089, 96, 1, 49, "Subsection",
      CellTags->"Properties of Lie Algebras"]},
  "derived algebra"->{
    Cell[68688, 2092, 819, 23, 75, "Text",
      CellTags->{
      "derived algebra", "adjoint algebra", "Killing form", "solvability"}]},
  "adjoint algebra"->{
    Cell[68688, 2092, 819, 23, 75, "Text",
      CellTags->{
      "derived algebra", "adjoint algebra", "Killing form", "solvability"}],
    Cell[94338, 2825, 1331, 40, 75, "Text",
      Evaluatable->False,
      CellTags->{"adjoint algebra", "homomorphism"}]},
  "Killing form"->{
    Cell[68688, 2092, 819, 23, 75, "Text",
      CellTags->{
      "derived algebra", "adjoint algebra", "Killing form", "solvability"}],
    Cell[112837, 3443, 559, 17, 54, "Text",
      Evaluatable->False,
      CellTags->"Killing form"],
    Cell[119212, 3635, 264, 7, 33, "Text",
      CellTags->{"semisimple", "Killing form"}]},
  "solvability"->{
    Cell[68688, 2092, 819, 23, 75, "Text",
      CellTags->{
      "derived algebra", "adjoint algebra", "Killing form", "solvability"}],
    Cell[70847, 2156, 1360, 31, 183, "Text",
      Evaluatable->False,
      CellTags->{"solvability", "solvable", "commutative Lie algebra"}]},
  "derived Lie algebra"->{
    Cell[69510, 2117, 807, 21, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "classify a Lie algebra", 
        "ideal"}],
    Cell[78156, 2360, 1237, 31, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "KdV equation", "MathLie", 
        "infinitesimal symmetries"}]},
  "classify a Lie algebra"->{
    Cell[69510, 2117, 807, 21, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "classify a Lie algebra", 
        "ideal"}]},
  "solvable"->{
    Cell[70847, 2156, 1360, 31, 183, "Text",
      Evaluatable->False,
      CellTags->{"solvability", "solvable", "commutative Lie algebra"}]},
  "commutative Lie algebra"->{
    Cell[70847, 2156, 1360, 31, 183, "Text",
      Evaluatable->False,
      CellTags->{"solvability", "solvable", "commutative Lie algebra"}]},
  "diffusion equation"->{
    Cell[72241, 2191, 629, 17, 75, "Text",
      Evaluatable->False,
      CellTags->"diffusion equation"]},
  "Korteweg-de Vries equation"->{
    Cell[72904, 2212, 718, 19, 54, "Text",
      Evaluatable->False,
      CellTags->{"Korteweg-de Vries equation", "KdV equation"}]},
  "KdV equation"->{
    Cell[72904, 2212, 718, 19, 54, "Text",
      Evaluatable->False,
      CellTags->{"Korteweg-de Vries equation", "KdV equation"}],
    Cell[78156, 2360, 1237, 31, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "KdV equation", "MathLie", 
        "infinitesimal symmetries"}],
    Cell[80812, 2434, 601, 12, 96, "Text",
      CellTags->"KdV equation"]},
  "MathLie"->{
    Cell[78156, 2360, 1237, 31, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "KdV equation", "MathLie", 
        "infinitesimal symmetries"}]},
  "infinitesimal symmetries"->{
    Cell[78156, 2360, 1237, 31, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "derived Lie algebra", "commutator table", "KdV equation", "MathLie", 
        "infinitesimal symmetries"}]},
  "group constants"->{
    Cell[79943, 2407, 596, 14, 75, "Text",
      CellTags->{"vector field", "group constants"}]},
  "SolvableAlgebrasOfOrderN[]"->{
    Cell[80564, 2425, 170, 3, 27, "Input",
      CellTags->"SolvableAlgebrasOfOrderN[]"],
    Cell[81985, 2466, 398, 7, 75, "Text",
      CellTags->{"SolvableAlgebrasOfOrderN[]", "subalgebras"}]},
  "subalgebras"->{
    Cell[81985, 2466, 398, 7, 75, "Text",
      CellTags->{"SolvableAlgebrasOfOrderN[]", "subalgebras"}]},
  "derivation of a Lie algebra"->{
    Cell[82386, 2475, 505, 13, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "derivation of a Lie algebra", "automorphism", "linear mapping"}]},
  "automorphism"->{
    Cell[82386, 2475, 505, 13, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "derivation of a Lie algebra", "automorphism", "linear mapping"}]},
  "linear mapping"->{
    Cell[82386, 2475, 505, 13, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "derivation of a Lie algebra", "automorphism", "linear mapping"}]},
  "derivation"->{
    Cell[84133, 2523, 713, 25, 54, "Text",
      Evaluatable->False,
      CellTags->"derivation"]},
  "complex number"->{
    Cell[90240, 2683, 507, 12, 75, "Text",
      CellTags->{"complex number", "classification of Lie algebras"}]},
  "classification of Lie algebras"->{
    Cell[90240, 2683, 507, 12, 75, "Text",
      CellTags->{"complex number", "classification of Lie algebras"}]},
  "adjoint Lie algebra"->{
    Cell[90750, 2697, 327, 12, 33, "Text",
      CellTags->"adjoint Lie algebra"],
    Cell[100911, 3058, 1778, 51, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "so(3)", "Levi-Civita tensor", "Lie group", "adjoint Lie algebra"}]},
  "homomorphism"->{
    Cell[94338, 2825, 1331, 40, 75, "Text",
      Evaluatable->False,
      CellTags->{"adjoint algebra", "homomorphism"}],
    Cell[105896, 3233, 326, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"homomorphism", "adjoined algebra"}]},
  "matrix representation"->{
    Cell[95672, 2867, 713, 24, 54, "Text",
      Evaluatable->False,
      CellTags->"matrix representation"],
    Cell[97821, 2945, 739, 25, 54, "Text",
      Evaluatable->False,
      CellTags->"matrix representation"]},
  "Taylor expansion"->{
    Cell[99305, 2994, 407, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{"Taylor expansion", "representation of Lie algebras"}]},
  "representation of Lie algebras"->{
    Cell[99305, 2994, 407, 8, 75, "Text",
      Evaluatable->False,
      CellTags->{"Taylor expansion", "representation of Lie algebras"}]},
  "Levi-Civita tensor"->{
    Cell[100911, 3058, 1778, 51, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "so(3)", "Levi-Civita tensor", "Lie group", "adjoint Lie algebra"}]},
  "Lie group"->{
    Cell[100911, 3058, 1778, 51, 117, "Text",
      Evaluatable->False,
      CellTags->{
      "so(3)", "Levi-Civita tensor", "Lie group", "adjoint Lie algebra"}]},
  "Array[]"->{
    Cell[104912, 3201, 981, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{"Array[]", "slot", "LeviCivita[]"}]},
  "slot"->{
    Cell[104912, 3201, 981, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{"Array[]", "slot", "LeviCivita[]"}]},
  "adjoined algebra"->{
    Cell[105896, 3233, 326, 9, 54, "Text",
      Evaluatable->False,
      CellTags->{"homomorphism", "adjoined algebra"}]},
  "scalar product"->{
    Cell[109075, 3324, 183, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"scalar product"]},
  "symmetry"->{
    Cell[109736, 3347, 74, 2, 26, "ListItem",
      CellTags->"symmetry"]},
  "bilinearity"->{
    Cell[110108, 3359, 81, 2, 26, "ListItem",
      CellTags->"bilinearity"]},
  "trace"->{
    Cell[112691, 3436, 143, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"trace"]},
  "second rank tensor"->{
    Cell[115270, 3516, 110, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"second rank tensor"]},
  "Cartan metric tensor"->{
    Cell[116314, 3549, 740, 20, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "Cartan metric tensor", "commutative algebra", "degeneration"}]},
  "degeneration"->{
    Cell[116314, 3549, 740, 20, 54, "Text",
      Evaluatable->False,
      CellTags->{
      "Cartan metric tensor", "commutative algebra", "degeneration"}]},
  "solvable Lie algebra"->{
    Cell[117057, 3571, 1063, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "solvable Lie algebra", "nilpotent", "solvability of a Lie algebra"}]},
  "nilpotent"->{
    Cell[117057, 3571, 1063, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "solvable Lie algebra", "nilpotent", "solvability of a Lie algebra"}]},
  "solvability of a Lie algebra"->{
    Cell[117057, 3571, 1063, 30, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "solvable Lie algebra", "nilpotent", "solvability of a Lie algebra"}]},
  "simple Lie algebra"->{
    Cell[118123, 3603, 502, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "simple Lie algebra", "semisimple Lie algebra", "nilpotent algebra"}]},
  "semisimple Lie algebra"->{
    Cell[118123, 3603, 502, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "simple Lie algebra", "semisimple Lie algebra", "nilpotent algebra"}]},
  "nilpotent algebra"->{
    Cell[118123, 3603, 502, 10, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "simple Lie algebra", "semisimple Lie algebra", "nilpotent algebra"}]},
  "Definition: Semisimple Lie algebra"->{
    Cell[118628, 3615, 106, 1, 38, "Definition",
      CellTags->"Definition: Semisimple Lie algebra"]},
  "commutative ideal"->{
    Cell[118737, 3618, 242, 7, 33, "Text",
      CellTags->"commutative ideal"]},
  "Theorem: Cartans theorem"->{
    Cell[119098, 3632, 111, 1, 38, "Theorem",
      CellTags->"Theorem: Cartans theorem"]},
  "semisimple"->{
    Cell[119212, 3635, 264, 7, 33, "Text",
      CellTags->{"semisimple", "Killing form"}]},
  "Cartan"->{
    Cell[119479, 3644, 211, 5, 54, "Text",
      CellTags->"Cartan"]},
  "Definition: Simple Lie algebra"->{
    Cell[119693, 3651, 98, 1, 38, "Definition",
      CellTags->"Definition: Simple Lie algebra"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Lie algebras", 122595, 3737},
  {"tangent space", 122957, 3745},
  {"Lie algebra", 123389, 3756},
  {"locally isomorphic", 124424, 3781},
  {"finite dimensional algebra", 124675, 3787},
  {"linear algebraic structure", 124926, 3793},
  {"analytic manifold", 125168, 3799},
  {"parameters", 125383, 3805},
  {"infinitesimal operator", 125610, 3811},
  {"linear operator", 125830, 3817},
  {"Definition: Lie algebra", 125965, 3821},
  {"finite-dimensional vector space", 126094, 3824},
  {"axioms", 126214, 3827},
  {"antisymmetry", 126340, 3830},
  {"linearity", 126461, 3834},
  {"Jacobi-identity", 126559, 3837},
  {"Lie product", 126867, 3846},
  {"Lie bracket", 127445, 3862},
  {"commutative algebra", 128178, 3882},
  {"non-associative", 128537, 3892},
  {"subalgebra", 128732, 3898},
  {"ideal", 129023, 3905},
  {"maximal ideal", 129457, 3917},
  {"center", 129609, 3921},
  {"commutator", 129765, 3925},
  {"coordinates", 130273, 3938},
  {"structure constant", 130417, 3942},
  {"restrictions on structure constants", 130568, 3946},
  {"Pauli matrices", 130731, 3950},
  {"spin matrices", 131315, 3964},
  {"skew-Hermitian matrices", 131468, 3968},
  {"quantum mechanics", 131629, 3972},
  {"matrix product", 131787, 3976},
  {"antisymmetric", 131911, 3980},
  {"LieProduct[]", 132035, 3984},
  {"eq-5", 132165, 3988},
  {"Levi-Civita density", 132298, 3992},
  {"real Lie algebra", 132798, 4005},
  {"LeviCivita[]", 132975, 4010},
  {"Union[]", 133271, 4018},
  {"Length[]", 133483, 4024},
  {"Signature[]", 133698, 4030},
  {"signature", 133911, 4036},
  {"permutation", 134126, 4042},
  {"CommutativeQ[]", 134344, 4048},
  {"structure constants", 134878, 4061},
  {"tensor", 135728, 4082},
  {"vector space", 135869, 4086},
  {"differential operator", 136073, 4092},
  {"Representation of a Lie Algebra", 136626, 4106},
  {"representation", 136749, 4109},
  {"matrix representation of Lie algebras", 137242, 4120},
  {"rotation", 137421, 4125},
  {"symmetry of rotation", 137618, 4130},
  {"Cartesian", 137733, 4133},
  {"Levi-Civita", 137877, 4137},
  {"Table[]", 137983, 4140},
  {"so(3)", 138113, 4144},
  {"orthogonal group", 138588, 4155},
  {"isomorphic", 138892, 4162},
  {"representations of Lie algebras", 139217, 4169},
  {"representation of a Lie algebra", 139542, 4176},
  {"symmetries of differential equations", 139708, 4180},
  {"heat equation", 139916, 4186},
  {"commutator table", 140127, 4192},
  {"vector field", 140852, 4211},
  {"skew-symmetric", 141185, 4219},
  {"Table-1", 141414, 4225},
  {"Properties of Lie Algebras", 141533, 4228},
  {"derived algebra", 141651, 4231},
  {"adjoint algebra", 141813, 4235},
  {"Killing form", 142096, 4242},
  {"solvability", 142449, 4251},
  {"derived Lie algebra", 142759, 4258},
  {"classify a Lie algebra", 143176, 4269},
  {"solvable", 143375, 4275},
  {"commutative Lie algebra", 143551, 4279},
  {"diffusion equation", 143722, 4283},
  {"Korteweg-de Vries equation", 143865, 4287},
  {"KdV equation", 144020, 4291},
  {"MathLie", 144450, 4302},
  {"infinitesimal symmetries", 144687, 4308},
  {"group constants", 144915, 4314},
  {"SolvableAlgebrasOfOrderN[]", 145047, 4317},
  {"subalgebras", 145263, 4322},
  {"derivation of a Lie algebra", 145405, 4325},
  {"automorphism", 145586, 4330},
  {"linear mapping", 145769, 4335},
  {"derivation", 145948, 4340},
  {"complex number", 146071, 4344},
  {"classification of Lie algebras", 146224, 4347},
  {"adjoint Lie algebra", 146366, 4350},
  {"homomorphism", 146635, 4357},
  {"matrix representation", 146913, 4364},
  {"Taylor expansion", 147160, 4371},
  {"representation of Lie algebras", 147340, 4375},
  {"Levi-Civita tensor", 147508, 4379},
  {"Lie group", 147691, 4384},
  {"Array[]", 147872, 4389},
  {"slot", 148009, 4393},
  {"adjoined algebra", 148158, 4397},
  {"scalar product", 148305, 4401},
  {"symmetry", 148426, 4405},
  {"bilinearity", 148521, 4408},
  {"trace", 148613, 4411},
  {"second rank tensor", 148735, 4415},
  {"Cartan metric tensor", 148872, 4419},
  {"degeneration", 149052, 4424},
  {"solvable Lie algebra", 149240, 4429},
  {"nilpotent", 149424, 4434},
  {"solvability of a Lie algebra", 149627, 4439},
  {"simple Lie algebra", 149820, 4444},
  {"semisimple Lie algebra", 150016, 4449},
  {"nilpotent algebra", 150207, 4454},
  {"Definition: Semisimple Lie algebra", 150415, 4459},
  {"commutative ideal", 150545, 4462},
  {"Theorem: Cartans theorem", 150659, 4465},
  {"semisimple", 150769, 4468},
  {"Cartan", 150876, 4471},
  {"Definition: Simple Lie algebra", 150985, 4474}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 351, 6, 52, "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 2}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Lie algebras"],
Cell[2093, 59, 971, 19, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "tangent space", "Lie algebra", "locally isomorphic", 
    "finite dimensional algebra", "linear algebraic structure"}],
Cell[3067, 80, 2071, 56, 180, "Text",
  Evaluatable->False,
  CellTags->{
  "Lie algebra", "analytic manifold", "tangent space", "parameters", 
    "infinitesimal operator"}],
Cell[5141, 138, 111, 2, 25, "NumberedEquation",
  Evaluatable->False],
Cell[5255, 142, 181, 6, 33, "Text",
  Evaluatable->False],
Cell[5439, 150, 650, 19, 53, "NumberedEquation",
  Evaluatable->False],
Cell[6092, 171, 468, 14, 54, "Text",
  Evaluatable->False,
  CellTags->"linear operator"],
Cell[6563, 187, 754, 21, 42, "NumberedEquation",
  Evaluatable->False],
Cell[7320, 210, 149, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"Lie algebra"],
Cell[7472, 217, 84, 1, 38, "Definition",
  CellTags->"Definition: Lie algebra"],
Cell[7559, 220, 750, 23, 75, "Text",
  CellTags->{"finite-dimensional vector space", "axioms"}],
Cell[8312, 245, 163, 4, 26, "ListItem",
  Evaluatable->False,
  CellTags->"antisymmetry"],
Cell[8478, 251, 633, 17, 28, "DisplayFormula",
  Evaluatable->False],
Cell[9114, 270, 136, 3, 26, "ListItem",
  CellTags->"linearity"],
Cell[9253, 275, 1556, 38, 28, "DisplayFormula",
  Evaluatable->False],
Cell[10812, 315, 149, 3, 26, "ListItem",
  CellTags->"Jacobi-identity"],
Cell[10964, 320, 1636, 41, 28, "DisplayFormula",
  Evaluatable->False],
Cell[12603, 363, 1233, 37, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "Lie product", "Lie bracket", "commutative algebra", "non-associative"}],
Cell[13839, 402, 869, 28, 75, "Text",
  Evaluatable->False,
  CellTags->{"subalgebra", "ideal", "maximal ideal", "center"}],
Cell[14711, 432, 1159, 35, 54, "Text",
  Evaluatable->False,
  CellTags->{"commutator", "coordinates"}],
Cell[15873, 469, 515, 13, 55, "DisplayFormula",
  Evaluatable->False],
Cell[16391, 484, 956, 32, 55, "Text",
  Evaluatable->False,
  CellTags->"structure constant"],
Cell[17350, 518, 282, 9, 34, "Text",
  Evaluatable->False],
Cell[17635, 529, 169, 4, 32, "DisplayFormula"],
Cell[17807, 535, 1268, 36, 54, "DisplayFormula"],
Cell[19078, 573, 552, 13, 75, "Text",
  Evaluatable->False,
  CellTags->{"subalgebra", "restrictions on structure constants"}],
Cell[19633, 588, 459, 13, 31, "DisplayFormula",
  Evaluatable->False],
Cell[20095, 603, 112, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"ideal"],
Cell[20210, 607, 606, 17, 31, "DisplayFormula",
  Evaluatable->False],
Cell[20819, 626, 413, 8, 75, "Text",
  Evaluatable->False,
  CellTags->{"Pauli matrices", "spin matrices"}],
Cell[21235, 636, 28, 0, 33, "Example"],
Cell[21266, 638, 467, 14, 54, "Text",
  Evaluatable->False,
  CellTags->{"skew-Hermitian matrices", "quantum mechanics"}],
Cell[21736, 654, 1222, 41, 41, "NumberedEquation",
  Evaluatable->False],
Cell[22961, 697, 150, 6, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[23136, 707, 113, 2, 38, "Input"],
Cell[23252, 711, 181, 6, 55, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23470, 722, 108, 2, 38, "Input"],
Cell[23581, 726, 176, 6, 55, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23794, 737, 108, 2, 38, "Input"],
Cell[23905, 741, 176, 6, 55, "Output"]
}, Open  ]],
Cell[24096, 750, 365, 13, 33, "Text",
  Evaluatable->False,
  CellTags->{"Lie product", "commutator"}],
Cell[24464, 765, 881, 24, 28, "DisplayFormula",
  Evaluatable->False],
Cell[25348, 791, 328, 9, 54, "Text",
  Evaluatable->False,
  CellTags->"matrix product"],
Cell[25679, 802, 99, 2, 27, "Input"],
Cell[25781, 806, 1004, 31, 54, "Text",
  Evaluatable->False,
  CellTags->"antisymmetric"],

Cell[CellGroupData[{
Cell[26810, 841, 124, 3, 45, "Input"],
Cell[26937, 846, 161, 6, 41, "Output"]
}, Open  ]],
Cell[27113, 855, 110, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"Lie bracket"],

Cell[CellGroupData[{
Cell[27248, 861, 204, 5, 45, "Input"],
Cell[27455, 868, 161, 6, 41, "Output"]
}, Open  ]],
Cell[27631, 877, 104, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"Jacobi-identity"],

Cell[CellGroupData[{
Cell[27760, 883, 231, 5, 63, "Input"],
Cell[27994, 890, 161, 6, 41, "Output"]
}, Open  ]],
Cell[28170, 899, 355, 9, 54, "Text",
  Evaluatable->False,
  CellTags->{"LieProduct[]", "Lie bracket"}],
Cell[28528, 910, 605, 20, 27, "NumberedEquation",
  Evaluatable->False,
  CellTags->"eq-5"],
Cell[29136, 932, 2315, 64, 117, "Text",
  CellTags->{
  "Levi-Civita density", "Pauli matrices", "real Lie algebra", 
    "LeviCivita[]"}],
Cell[31454, 998, 4784, 109, 59, "NumberedEquation"],
Cell[36241, 1109, 202, 6, 33, "Text",
  Evaluatable->False],
Cell[36446, 1117, 279, 5, 135, "Input"],
Cell[36728, 1124, 2440, 80, 183, "Text",
  Evaluatable->False,
  CellTags->{
  "Union[]", "Length[]", "Signature[]", "Levi-Civita density", "signature", 
    "permutation"}],
Cell[39171, 1206, 1009, 30, 96, "Text",
  Evaluatable->False,
  CellTags->"CommutativeQ[]"],

Cell[CellGroupData[{
Cell[40205, 1240, 82, 2, 27, "Input"],
Cell[40290, 1244, 153, 2, 42, "Output"]
}, Open  ]],
Cell[40458, 1249, 178, 4, 48, "Input"],
Cell[40639, 1255, 234, 5, 45, "Input"],
Cell[40876, 1262, 287, 9, 33, "Text",
  Evaluatable->False,
  CellTags->{"structure constants", "tensor"}],

Cell[CellGroupData[{
Cell[41188, 1275, 103, 2, 27, "Input"],
Cell[41294, 1279, 97, 2, 30, "Output"]
}, Open  ]],
Cell[41406, 1284, 790, 19, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "commutator", "Lie product", "vector space", "differential operator"}],

Cell[CellGroupData[{
Cell[42221, 1307, 106, 1, 49, "Subsection",
  CellTags->"Representation of a Lie Algebra"],
Cell[42330, 1310, 570, 10, 96, "Text",
  CellTags->{
  "representation", "matrix representation of Lie algebras", 
    "differential operator"}],
Cell[42903, 1322, 29, 0, 33, "Example"],
Cell[42935, 1324, 412, 8, 75, "Text",
  CellTags->{"rotation", "symmetry of rotation"}],
Cell[43350, 1334, 219, 6, 44, "DisplayFormula",
  Evaluatable->False],
Cell[43572, 1342, 219, 6, 44, "DisplayFormula",
  Evaluatable->False],
Cell[43794, 1350, 213, 6, 44, "DisplayFormula",
  Evaluatable->False],
Cell[44010, 1358, 631, 19, 54, "Text",
  Evaluatable->False,
  CellTags->{"Cartesian", "Levi-Civita density"}],
Cell[44644, 1379, 666, 18, 58, "DisplayFormula"],
Cell[45313, 1399, 180, 6, 33, "Text",
  Evaluatable->False],
Cell[45496, 1407, 351, 7, 72, "Input"],
Cell[45850, 1416, 122, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"Lie bracket"],
Cell[45975, 1420, 211, 7, 28, "NumberedEquation"],
Cell[46189, 1429, 216, 8, 33, "Text"],
Cell[46408, 1439, 120, 3, 45, "Input"],
Cell[46531, 1444, 161, 4, 33, "Text",
  CellTags->{"commutator", "Levi-Civita"}],
Cell[46695, 1450, 802, 24, 53, "NumberedEquation"],
Cell[47500, 1476, 187, 7, 33, "Text",
  Evaluatable->False],
Cell[47690, 1485, 131, 3, 48, "Input"],
Cell[47824, 1490, 171, 6, 33, "Text",
  Evaluatable->False],
Cell[47998, 1498, 75, 2, 27, "Input"],
Cell[48076, 1502, 155, 4, 45, "Input"],
Cell[48234, 1508, 334, 9, 54, "Text",
  Evaluatable->False,
  CellTags->{"CommutativeQ[]", "Table[]"}],

Cell[CellGroupData[{
Cell[48593, 1521, 125, 3, 45, "Input"],
Cell[48721, 1526, 97, 2, 30, "Output"]
}, Open  ]],
Cell[48833, 1531, 1604, 38, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "CommutativeQ[]", "Lie algebra", "so(3)", "orthogonal group", 
    "Pauli matrices", "isomorphic", "representations of Lie algebras", 
    "structure constants", "representation"}],
Cell[50440, 1571, 362, 11, 54, "Text",
  Evaluatable->False,
  CellTags->"representation of a Lie algebra"],
Cell[50805, 1584, 457, 11, 31, "NumberedEquation"],
Cell[51265, 1597, 19, 0, 33, "Text"],
Cell[51287, 1599, 239, 7, 27, "NumberedEquation"],
Cell[51529, 1608, 319, 11, 33, "Text",
  Evaluatable->False,
  CellTags->"Lie product"],
Cell[51851, 1621, 719, 21, 75, "Text",
  Evaluatable->False,
  CellTags->{
  "differential operator", "symmetries of differential equations", 
    "heat equation"}],
Cell[52573, 1644, 239, 6, 27, "NumberedEquation"],
Cell[52815, 1652, 276, 8, 27, "NumberedEquation"],
Cell[53094, 1662, 228, 5, 25, "NumberedEquation"],
Cell[53325, 1669, 2130, 58, 181, "Text",
  Evaluatable->False,
  CellTags->{
  "commutator table", "vector field", "structure constants", "Lie algebra", 
    "skew-symmetric", "Lie bracket"}],
Cell[55458, 1729, 10551, 270, 181, "NumberedTable",
  CellTags->"Table-1"],
Cell[66012, 2001, 79, 1, 33, "Text",
  Evaluatable->False],
Cell[66094, 2004, 1128, 30, 27, "NumberedEquation"],
Cell[67225, 2036, 172, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"structure constants"],
Cell[67400, 2043, 231, 8, 27, "NumberedEquation"],
Cell[67634, 2053, 201, 5, 26, "NumberedEquation"],
Cell[67838, 2060, 211, 4, 26, "NumberedEquation"],
Cell[68052, 2066, 188, 6, 27, "NumberedEquation"],
Cell[68243, 2074, 309, 10, 34, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[68589, 2089, 96, 1, 49, "Subsection",
  CellTags->"Properties of Lie Algebras"],
Cell[68688, 2092, 819, 23, 75, "Text",
  CellTags->{
  "derived algebra", "adjoint algebra", "Killing form", "solvability"}],
Cell[69510, 2117, 807, 21, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "derived Lie algebra", "commutator table", "classify a Lie algebra", 
    "ideal"}],
Cell[70320, 2140, 524, 14, 25, "NumberedEquation",
  Evaluatable->False],
Cell[70847, 2156, 1360, 31, 183, "Text",
  Evaluatable->False,
  CellTags->{"solvability", "solvable", "commutative Lie algebra"}],
Cell[72210, 2189, 28, 0, 33, "Example"],
Cell[72241, 2191, 629, 17, 75, "Text",
  Evaluatable->False,
  CellTags->"diffusion equation"],
Cell[72873, 2210, 28, 0, 33, "Example"],
Cell[72904, 2212, 718, 19, 54, "Text",
  Evaluatable->False,
  CellTags->{"Korteweg-de Vries equation", "KdV equation"}],
Cell[73625, 2233, 295, 5, 25, "NumberedEquation"],
Cell[73923, 2240, 158, 3, 25, "NumberedEquation"],
Cell[74084, 2245, 120, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"commutator table"],
Cell[74207, 2249, 3946, 109, 157, "NumberedTable"],
Cell[78156, 2360, 1237, 31, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "derived Lie algebra", "commutator table", "KdV equation", "MathLie", 
    "infinitesimal symmetries"}],
Cell[79396, 2393, 308, 6, 75, "Text",
  Evaluatable->False],
Cell[79707, 2401, 233, 4, 45, "Input"],
Cell[79943, 2407, 596, 14, 75, "Text",
  CellTags->{"vector field", "group constants"}],

Cell[CellGroupData[{
Cell[80564, 2425, 170, 3, 27, "Input",
  CellTags->"SolvableAlgebrasOfOrderN[]"],
Cell[80737, 2430, 60, 1, 30, "Output"]
}, Open  ]],
Cell[80812, 2434, 601, 12, 96, "Text",
  CellTags->"KdV equation"],

Cell[CellGroupData[{
Cell[81438, 2450, 311, 8, 58, "Input"],
Cell[81752, 2460, 218, 3, 70, "Output"]
}, Open  ]],
Cell[81985, 2466, 398, 7, 75, "Text",
  CellTags->{"SolvableAlgebrasOfOrderN[]", "subalgebras"}],
Cell[82386, 2475, 505, 13, 54, "Text",
  Evaluatable->False,
  CellTags->{
  "derivation of a Lie algebra", "automorphism", "linear mapping"}],
Cell[82894, 2490, 1236, 31, 25, "NumberedEquation"],
Cell[84133, 2523, 713, 25, 54, "Text",
  Evaluatable->False,
  CellTags->"derivation"],
Cell[84849, 2550, 419, 8, 25, "NumberedEquation"],
Cell[85271, 2560, 2511, 59, 25, "NumberedEquation"],
Cell[87785, 2621, 189, 6, 33, "Text",
  Evaluatable->False],
Cell[87977, 2629, 2260, 52, 27, "NumberedEquation",
  Evaluatable->False],
Cell[90240, 2683, 507, 12, 75, "Text",
  CellTags->{"complex number", "classification of Lie algebras"}],
Cell[90750, 2697, 327, 12, 33, "Text",
  CellTags->"adjoint Lie algebra"],
Cell[91080, 2711, 770, 23, 27, "NumberedEquation",
  Evaluatable->False],
Cell[91853, 2736, 270, 8, 33, "Text",
  Evaluatable->False,
  CellTags->"Jacobi-identity"],
Cell[92126, 2746, 730, 30, 27, "NumberedEquation",
  Evaluatable->False],
Cell[92859, 2778, 456, 15, 54, "Text",
  Evaluatable->False],
Cell[93318, 2795, 1017, 28, 25, "NumberedEquation",
  Evaluatable->False],
Cell[94338, 2825, 1331, 40, 75, "Text",
  Evaluatable->False,
  CellTags->{"adjoint algebra", "homomorphism"}],
Cell[95672, 2867, 713, 24, 54, "Text",
  Evaluatable->False,
  CellTags->"matrix representation"],
Cell[96388, 2893, 545, 18, 51, "NumberedEquation",
  Evaluatable->False],
Cell[96936, 2913, 314, 10, 33, "Text",
  Evaluatable->False,
  CellTags->"structure constants"],
Cell[97253, 2925, 565, 18, 29, "NumberedEquation",
  Evaluatable->False],
Cell[97821, 2945, 739, 25, 54, "Text",
  Evaluatable->False,
  CellTags->"matrix representation"],
Cell[98563, 2972, 28, 0, 33, "Example"],
Cell[98594, 2974, 236, 5, 54, "Text",
  CellTags->"rotation"],
Cell[98833, 2981, 166, 3, 63, "Input"],
Cell[99002, 2986, 146, 2, 45, "Input"],
Cell[99151, 2990, 151, 2, 45, "Input"],
Cell[99305, 2994, 407, 8, 75, "Text",
  Evaluatable->False,
  CellTags->{"Taylor expansion", "representation of Lie algebras"}],

Cell[CellGroupData[{
Cell[99737, 3006, 142, 3, 27, "Input"],
Cell[99882, 3011, 203, 7, 57, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100122, 3023, 139, 3, 27, "Input"],
Cell[100264, 3028, 203, 7, 57, "Output"]
}, Open  ]],
Cell[100482, 3038, 41, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[100548, 3043, 142, 3, 27, "Input"],
Cell[100693, 3048, 203, 7, 57, "Output"]
}, Open  ]],
Cell[100911, 3058, 1778, 51, 117, "Text",
  Evaluatable->False,
  CellTags->{
  "so(3)", "Levi-Civita tensor", "Lie group", "adjoint Lie algebra"}],
Cell[102692, 3111, 1025, 30, 31, "NumberedEquation"],
Cell[103720, 3143, 53, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[103798, 3148, 136, 4, 45, "Input"],
Cell[103937, 3154, 203, 7, 57, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[104177, 3166, 113, 3, 45, "Input"],
Cell[104293, 3171, 203, 7, 57, "Output"]
}, Open  ]],
Cell[104511, 3181, 41, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[104577, 3186, 114, 3, 45, "Input"],
Cell[104694, 3191, 203, 7, 57, "Output"]
}, Open  ]],
Cell[104912, 3201, 981, 30, 96, "Text",
  Evaluatable->False,
  CellTags->{"Array[]", "slot", "LeviCivita[]"}],
Cell[105896, 3233, 326, 9, 54, "Text",
  Evaluatable->False,
  CellTags->{"homomorphism", "adjoined algebra"}],
Cell[106225, 3244, 1699, 44, 52, "NumberedEquation",
  Evaluatable->False],
Cell[107927, 3290, 43, 1, 33, "Text",
  Evaluatable->False],
Cell[107973, 3293, 1099, 29, 51, "NumberedEquation",
  Evaluatable->False],
Cell[109075, 3324, 183, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"scalar product"],
Cell[109261, 3331, 383, 11, 27, "NumberedEquation",
  Evaluatable->False],
Cell[109647, 3344, 86, 1, 33, "Text",
  Evaluatable->False],
Cell[109736, 3347, 74, 2, 26, "ListItem",
  CellTags->"symmetry"],
Cell[109813, 3351, 292, 6, 25, "NumberedEquation",
  Evaluatable->False],
Cell[110108, 3359, 81, 2, 26, "ListItem",
  CellTags->"bilinearity"],
Cell[110192, 3363, 517, 13, 27, "NumberedEquation",
  Evaluatable->False],
Cell[110712, 3378, 309, 8, 26, "ListItem",
  Evaluatable->False],
Cell[111024, 3388, 66, 2, 26, "ListItem",
  Evaluatable->False],
Cell[111093, 3392, 490, 10, 25, "NumberedEquation",
  Evaluatable->False],
Cell[111586, 3404, 44, 1, 26, "ListItem",
  Evaluatable->False],
Cell[111633, 3407, 1055, 27, 25, "NumberedEquation",
  Evaluatable->False],
Cell[112691, 3436, 143, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"trace"],
Cell[112837, 3443, 559, 17, 54, "Text",
  Evaluatable->False,
  CellTags->"Killing form"],
Cell[113399, 3462, 1147, 29, 52, "DisplayFormula",
  Evaluatable->False],
Cell[114549, 3493, 718, 21, 55, "NumberedEquation"],
Cell[115270, 3516, 110, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"second rank tensor"],
Cell[115383, 3520, 928, 27, 52, "NumberedEquation",
  Evaluatable->False],
Cell[116314, 3549, 740, 20, 54, "Text",
  Evaluatable->False,
  CellTags->{"Cartan metric tensor", "commutative algebra", "degeneration"}],
Cell[117057, 3571, 1063, 30, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "solvable Lie algebra", "nilpotent", "solvability of a Lie algebra"}],
Cell[118123, 3603, 502, 10, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "simple Lie algebra", "semisimple Lie algebra", "nilpotent algebra"}],
Cell[118628, 3615, 106, 1, 38, "Definition",
  CellTags->"Definition: Semisimple Lie algebra"],
Cell[118737, 3618, 242, 7, 33, "Text",
  CellTags->"commutative ideal"],
Cell[118982, 3627, 113, 3, 33, "Text",
  Evaluatable->False],
Cell[119098, 3632, 111, 1, 38, "Theorem",
  CellTags->"Theorem: Cartans theorem"],
Cell[119212, 3635, 264, 7, 33, "Text",
  CellTags->{"semisimple", "Killing form"}],
Cell[119479, 3644, 211, 5, 54, "Text",
  CellTags->"Cartan"],
Cell[119693, 3651, 98, 1, 38, "Definition",
  CellTags->"Definition: Simple Lie algebra"],
Cell[119794, 3654, 468, 15, 33, "Text"],
Cell[120265, 3671, 299, 6, 75, "Text",
  Evaluatable->False],
Cell[120567, 3679, 147, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

