(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     29637,       1171]*)
(*NotebookOutlinePosition[     30778,       1207]*)
(*  CellTagsIndexPosition[     30734,       1203]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->5,
  FontSize->12,
  PrivateFontOptions->{"FontType"->"Bitmap"}],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->5,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            StyleBox[ 
              CounterBox[ "Page"], "PageNumber"], "     ", 
            StyleBox[ "Symmetry Analysis", FontSlant -> "Italic"]}], 
          "Header"], None, None}, {None, None, Cell[ 
          TextData[ {
            StyleBox[ "Symmetry Analysis", FontSlant -> "Italic"], "     ", 
            StyleBox[ 
              CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
  PageFooters->{{None, None, None}, {None, None, None}},
  PageHeaderLines->{False, False},
  PageFooterLines->{False, False},
  PrintingOptions->{"PrintingMargins"->{{99, 99}, {180, 59}},
  "FirstPageHeader"->False,
  "FirstPageFooter"->False,
  "FacingPages"->True},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{2, 2}, {96, 30}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  TextAlignment->Left,
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontWeight->"Plain"],

Cell[StyleData["Title", "Printout"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{2, 10}, {12, 8}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Subtitle", "Printout"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{2, 10}, {12, 8}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellMargins->{{2, 2}, {0, 22}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  TextAlignment->Left,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
  ShowGroupOpenCloseIcon->False,
  FontSize->14,
  FontWeight->"Plain"]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellMargins->{{74, 0}, {0, 22}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->14,
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["Subsection", "Printout"],
  ShowGroupOpenCloseIcon->False,
  FontSize->12,
  FontWeight->"Plain"]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{74, 0}, {0, 14}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["Subsubsection", "Printout"],
  ShowGroupOpenCloseIcon->False,
  FontSize->11,
  FontWeight->"Plain"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{74, 0}, {5, 5}},
  PageBreakWithin->Automatic,
  TextJustification->1,
  LineSpacing->{1, 2},
  CounterIncrements->"Text"],

Cell[RawData["\<\
Cell[StyleData[\"Text\", \"Printout\"],
  TextJustification->1,
  FontSize->10]\
\>"],
  TextJustification->1,
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["TextNoIndent"],
  CellMargins->{{74, 0}, {5, 5}},
  PageBreakWithin->Automatic,
  LineSpacing->{1, 2},
  CounterIncrements->"Text"],

Cell[StyleData["TextNoIndent", "Printout"],
  TextJustification->1,
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{74, 0}, {5, 5}},
  LineSpacing->{1, 3},
  CounterIncrements->"SmallText",
  FontFamily->"Times",
  FontSize->9],

Cell[StyleData["SmallText", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Definition"],
  CellMargins->{{12, 10}, {7, 7}},
  PageBreakBelow->False,
  TextJustification->1,
  LineSpacing->{1, 3},
  CounterIncrements->"Definition",
  FontFamily->"Times",
  FontSize->12,
  FontSlant->"Italic"],

Cell[StyleData["Definition", "Presentation"],
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontSize->18,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Definition", "Condensed"],
  CellMargins->{{17, Inherited}, {6, 12}},
  FontSize->10,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Definition", "Printout"],
  CellMargins->{{2, 2}, {7, 14}},
  FontSize->11,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Example"],
  CellMargins->{{74, 0}, {5, 5}},
  PageBreakBelow->False,
  TextJustification->1,
  LineSpacing->{1, 3},
  CounterIncrements->"Example",
  FontFamily->"Times",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Example", "Presentation"],
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontSize->18,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Example", "Condensed"],
  CellMargins->{{17, Inherited}, {6, 12}},
  FontSize->10,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Example", "Printout"],
  CellMargins->{{74, 0}, {5, 5}},
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Theorem"],
  CellMargins->{{12, 10}, {7, 7}},
  PageBreakBelow->False,
  TextJustification->1,
  LineSpacing->{1, 3},
  CounterIncrements->"Theorem",
  FontFamily->"Times",
  FontSize->12,
  FontSlant->"Italic"],

Cell[StyleData["Theorem", "Presentation"],
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontSize->18,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Theorem", "Condensed"],
  CellMargins->{{17, Inherited}, {6, 12}},
  FontSize->10,
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Theorem", "Printout"],
  CellMargins->{{2, 2}, {7, 14}},
  FontSize->11,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{85, 0}, {4, 4}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->True,
  GroupPageBreakWithin->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontFamily->"Courier",
  FontSize->9,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1],
  Background->None],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{85, Inherited}, {Inherited, Inherited}},
  FontSize->9,
  FontColor->RGBColor[0, 0, 1],
  Background->None]
}, Open  ]],

Cell[StyleData["InputOnly"],
  CellMargins->{{85, Inherited}, {Inherited, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontSize->9,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1],
  Background->None],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{85, 0}, {6, 3}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->True,
  GroupPageBreakWithin->True,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output",
  FontSize->10,
  FontColor->RGBColor[1, 0, 0],
  Background->None],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{85, Inherited}, {Inherited, Inherited}},
  FontSize->9,
  FontColor->RGBColor[1, 0, 0],
  Background->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{85, 0}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontSize->10,
  FontColor->RGBColor[0, 0.500008, 0.250004],
  Background->None],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{85, Inherited}, {Inherited, Inherited}},
  FontSize->9,
  FontColor->RGBColor[0, 0.500008, 0.250004],
  Background->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{85, 0}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None,
  FontSize->10,
  Background->None],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{85, Inherited}, {Inherited, Inherited}},
  FontSize->9,
  FontSlant->"Italic",
  Background->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{74, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Center,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{30, Inherited}, {Inherited, 0}},
  FontSize->10],

Cell[StyleData["Graphics", "Printout"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  CellMargins->{{12, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Printout"],
  CellMargins->{{7, Inherited}, {Inherited, Inherited}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["MmaText"],
  CellMargins->{{12, 10}, {7, 7}},
  TextJustification->1,
  LineSpacing->{1, 3},
  CounterIncrements->"MmaText",
  FontFamily->"Times"],

Cell[StyleData["MmaText", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5},
  FontFamily->"Times",
  FontColor->RGBColor[0.500008, 0, 0]],

Cell[StyleData["MmaText", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1},
  FontFamily->"Times",
  FontColor->RGBColor[0.500008, 0, 0]],

Cell[StyleData["MmaText", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontFamily->"Times",
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MmaSmallText"],
  CellMargins->{{12, 10}, {6, 6}},
  LineSpacing->{1, 3},
  CounterIncrements->"MmaSmallText",
  FontFamily->"Times",
  FontSize->9,
  FontColor->RGBColor[0.500008, 0, 0]],

Cell[StyleData["MmaSmallText", "Presentation"],
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontFamily->"Times",
  FontSize->12,
  FontColor->RGBColor[0.500008, 0, 0]],

Cell[StyleData["MmaSmallText", "Condensed"],
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontFamily->"Times",
  FontSize->9,
  FontColor->RGBColor[0.500008, 0, 0]],

Cell[StyleData["MmaSmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  FontFamily->"Times",
  FontSize->7,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  CellMargins->{{2, 0}, {6, 6}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True,
  FontSize->10],

Cell[StyleData["InlineFormula", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{74, 0}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  TextAlignment->Center,
  TextJustification->0,
  ScriptLevel->0,
  SingleLetterItalics->True,
  FontFamily->"Times",
  FontSize->10,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[RawData["\<\
Cell[StyleData[\"DisplayFormula\", \"Printout\"],
  TextAlignment->Center,
  TextJustification->0]\
\>"],
  TextAlignment->Center,
  TextJustification->0]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\

The following styles are useful for numbered equations, figures, etc.  They 
automatically give the cell a FrameLabel containing a reference to a 
particular counter, and also increment that counter.
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{74, 0}, {Inherited, Inherited}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "Title"], ".", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  TextAlignment->Center,
  TextJustification->0,
  SingleLetterItalics->True,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False,
  FontFamily->"Times",
  FontSize->10],

Cell[RawData["\<\
Cell[StyleData[\"NumberedEquation\", \"Presentation\"],
  TextAlignment->Center,
  TextJustification->0]\
\>"],
  TextAlignment->Center,
  TextJustification->0],

Cell[RawData["\<\
Cell[StyleData[\"NumberedEquation\", \"Condensed\"],
  TextAlignment->Center,
  TextJustification->0]\
\>"],
  TextAlignment->Center,
  TextJustification->0],

Cell[StyleData["NumberedEquation", "Printout"],
  TextAlignment->Center,
  TextJustification->0]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{74, Inherited}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "Title"], ".", 
            CounterBox[ "NumberedFigure"]}]], None}},
  CounterIncrements->"NumberedFigure",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  FormatTypeAutoConvert->False,
  FontSize->9],

Cell[StyleData["NumberedFigure", "Presentation"]],

Cell[StyleData["NumberedFigure", "Condensed"]],

Cell[StyleData["NumberedFigure", "Printout"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{74, Inherited}, {Inherited, Inherited}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "Title"], ".", 
            CounterBox[ "NumberedTable"]}]], None}},
  TextAlignment->Center,
  TextJustification->0,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False,
  FontSize->10],

Cell[StyleData["NumberedTable", "Presentation"]],

Cell[StyleData["NumberedTable", "Condensed"]],

Cell[StyleData["NumberedTable", "Printout"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->10,
  FontSlant->"Plain"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->6,
  FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->10,
  FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0.500008, 0.242191, 0.00781262],
  FontVariations->{"Underline"->False},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->RGBColor[0.500008, 0.242191, 0.00781262],
  FontVariations->{"Underline"->False}]
}, Open  ]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->True,
  StyleMenuListing->None],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SelectionPlaceholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->Primary,
  StyleMenuListing->None,
  DrawHighlighted->True],

Cell[StyleData["SelectionPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  AllowInlineCells->False,
  StyleMenuListing->None],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{0.600000, 1},
  StyleMenuListing->None,
  FontFamily->"Times"],

Cell[StyleData["StandardForm"],
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  TextAlignment->Left,
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[1, 0.749996, 0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell["Other Book Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Note"],
  CellMargins->{{74, 0}, {5, 5}},
  PageBreakWithin->True,
  LineSpacing->{1, 2},
  CounterIncrements->"Text",
  StyleMenuListing->None],

Cell[StyleData["Note", "Printout"],
  TextJustification->1,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Project"],
  CellMargins->{{74, 2}, {5, 5}},
  PageBreakWithin->True,
  LineSpacing->{1, 2},
  CounterIncrements->"Project",
  CounterBoxOptions->{CounterFunction:>Identity},
  StyleMenuListing->None],

Cell[StyleData["Project", "Printout"],
  TextJustification->1,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListItem"],
  CellMargins->{{88, 2}, {3, 3}},
  PageBreakWithin->True,
  LineSpacing->{1, 2},
  ParagraphIndent->0,
  CounterIncrements->"ListItem",
  FontFamily->"Times",
  FontSize->10],

Cell[StyleData["ListItem", "Printout"],
  TextJustification->1,
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["BulletListItem"],
  CellDingbat->"\[Bullet]",
  CellMargins->{{88, 2}, {3, 3}},
  PageBreakWithin->True,
  LineSpacing->{1, 2},
  CounterIncrements->"BulletListItem",
  StyleMenuListing->None],

Cell[StyleData["BulletListItem", "Printout"],
  TextJustification->1,
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[RawData["\<\
Cell[StyleData[\"Reference\"],
  CellMargins->{{80, 2}, {4, 4}},
  LineSpacing->{1, 2},
  ParagraphIndent->-20,
  CounterIncrements->\"Reference\",
  StyleMenuListing->None]\
\>"],
  CellMargins->{{80, 2}, {4, 4}},
  LineSpacing->{1, 2},
  ParagraphIndent->-20,
  CounterIncrements->"Reference",
  StyleMenuListing->None],

Cell[StyleData["Reference", "Printout"],
  TextJustification->1,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Quote"],
  CellMargins->{{94, 22}, {2, 6}},
  TextAlignment->Left,
  TextJustification->1,
  LineSpacing->{1, 2},
  CounterIncrements->"Quote",
  StyleMenuListing->None,
  FontSize->12],

Cell[StyleData["Quote", "Printout"],
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["QuoteAttribution"],
  CellMargins->{{74, 2}, {6, 2}},
  TextAlignment->Right,
  TextJustification->1,
  LineSpacing->{1, 2},
  CounterIncrements->"Quote",
  StyleMenuListing->None,
  FontSize->12],

Cell[StyleData["QuoteAttribution", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["IT", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChapterLine"],
  CellFrame->{{0, 0}, {1, 0}},
  CellMargins->{{Inherited, Inherited}, {50, 6}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  TextAlignment->Left,
  CounterIncrements->"ChapterLine",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontWeight->"Plain"],

Cell[StyleData["ChapterLine", "Printout"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceNote"],
  CellMargins->{{100, 0}, {5, 5}},
  PageBreakWithin->Automatic,
  LineSpacing->{1, 2},
  CounterIncrements->"Text",
  StyleMenuListing->None,
  FontSize->10],

Cell[StyleData["ReferenceNote", "Printout"],
  TextJustification->1,
  FontSize->9]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
WindowSize->{791, 635},
WindowMargins->{{Automatic, 99}, {Automatic, 16}},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"FacingPages"->True},
CharacterEncoding->"$SystemCharacterEncoding"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 37, 0, 64, "Subtitle"],
Cell[1779, 53, 193, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[1997, 61, 42, 0, 53, "Section"],
Cell[2042, 63, 139, 4, 40, 31, 0, "StyleData", "All", "Working"],
Cell[2184, 69, 124, 3, 38, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2345, 77, 35, 0, 33, "Section"],
Cell[2383, 79, 101, 3, 33, "Text"],
Cell[2487, 84, 790, 19, 40, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3314, 108, 38, 0, 33, "Section"],

Cell[CellGroupData[{
Cell[3377, 112, 358, 10, 170, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3738, 124, 36, 0, 170, 36, 0, "StyleData", "Title", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3811, 129, 324, 9, 56, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4138, 140, 39, 0, 56, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4214, 145, 329, 9, 53, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4546, 156, 42, 0, 50, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4625, 161, 312, 9, 40, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4940, 172, 110, 3, 55, 38, 0, "StyleData", "Section", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5087, 180, 299, 9, 56, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5389, 191, 113, 3, 54, 41, 0, "StyleData", "Subsection", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5539, 199, 260, 8, 46, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[5802, 209, 116, 3, 45, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[5967, 218, 39, 0, 33, "Section"],

Cell[CellGroupData[{
Cell[6031, 222, 163, 5, 42, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[6197, 229, 144, 6, 39, 104, 4, "StyleData", "Text", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6378, 240, 147, 4, 42, 31, 0, "StyleData", "TextNoIndent", "All",
  CounterIncrements->"Text"],
Cell[6528, 246, 83, 2, 39, 43, 0, "StyleData", "TextNoIndent", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6648, 253, 157, 5, 39, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[6808, 260, 40, 0, 36, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6885, 265, 233, 8, 43, 29, 0, "StyleData", "Definition", "All",
  CounterIncrements->"Definition"],
Cell[7121, 275, 153, 4, 68, 45, 0, "StyleData", "Definition", \
"Presentation"],
Cell[7277, 281, 133, 3, 42, 42, 0, "StyleData", "Definition", "Condensed"],
Cell[7413, 286, 118, 3, 47, 41, 0, "StyleData", "Definition", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7568, 294, 225, 8, 41, 26, 0, "StyleData", "Example", "All",
  CounterIncrements->"Example"],
Cell[7796, 304, 150, 4, 74, 42, 0, "StyleData", "Example", "Presentation"],
Cell[7949, 310, 130, 3, 47, 39, 0, "StyleData", "Example", "Condensed"],
Cell[8082, 315, 99, 2, 42, 38, 0, "StyleData", "Example", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8218, 322, 227, 8, 46, 26, 0, "StyleData", "Theorem", "All",
  CounterIncrements->"Theorem"],
Cell[8448, 332, 150, 4, 68, 42, 0, "StyleData", "Theorem", "Presentation"],
Cell[8601, 338, 130, 3, 42, 39, 0, "StyleData", "Theorem", "Condensed"],
Cell[8734, 343, 115, 3, 47, 38, 0, "StyleData", "Theorem", "Printout"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8898, 352, 42, 0, 53, "Section"],
Cell[8943, 354, 364, 6, 71, "Text"],

Cell[CellGroupData[{
Cell[9332, 364, 523, 17, 37, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[9858, 383, 161, 4, 37, 36, 0, "StyleData", "Input", "Printout"]
}, Open  ]],
Cell[10034, 390, 434, 14, 37, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[10493, 408, 542, 17, 38, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[11038, 427, 162, 4, 38, 37, 0, "StyleData", "Output", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11237, 436, 543, 16, 37, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[11783, 454, 177, 4, 37, 38, 0, "StyleData", "Message", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11997, 463, 493, 15, 37, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[12493, 480, 152, 4, 35, 36, 0, "StyleData", "Print", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12682, 489, 455, 13, 37, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics"],
Cell[13140, 504, 39, 0, 37, 39, 0, "StyleData", "Graphics", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13216, 509, 186, 5, 37, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[13405, 516, 97, 1, 37, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13539, 522, 163, 5, 46, 26, 0, "StyleData", "MmaText", "All",
  CounterIncrements->"MmaText"],
Cell[13705, 529, 164, 4, 46, 42, 0, "StyleData", "MmaText", "Presentation"],
Cell[13872, 535, 158, 4, 38, 39, 0, "StyleData", "MmaText", "Condensed"],
Cell[14033, 541, 121, 3, 38, 38, 0, "StyleData", "MmaText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14191, 549, 203, 6, 39, 31, 0, "StyleData", "MmaSmallText", "All",
  CounterIncrements->"MmaSmallText"],
Cell[14397, 557, 183, 5, 42, 47, 0, "StyleData", "MmaSmallText", \
"Presentation"],
Cell[14583, 564, 178, 5, 33, 44, 0, "StyleData", "MmaSmallText", \
"Condensed"],
Cell[14764, 571, 141, 4, 31, 43, 0, "StyleData", "MmaSmallText", "Printout"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14954, 581, 43, 0, 53, "Section"],

Cell[CellGroupData[{
Cell[15022, 585, 161, 5, 41, 32, 0, "StyleData", "InlineFormula", "All"],
Cell[15186, 592, 44, 0, 39, 44, 0, "StyleData", "InlineFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15267, 597, 352, 10, 37, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[15622, 609, 172, 6, 35, 123, 4, "StyleData", "DisplayFormula", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15843, 621, 49, 0, 33, "Section"],
Cell[15895, 623, 225, 6, 109, "Text"],

Cell[CellGroupData[{
Cell[16145, 633, 490, 13, 37, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[16638, 648, 178, 6, 37, 129, 4, "StyleData", "NumberedEquation", \
"Presentation"],
Cell[16819, 656, 175, 6, 37, 126, 4, "StyleData", "NumberedEquation", \
"Condensed"],
Cell[16997, 664, 96, 2, 37, 47, 0, "StyleData", "NumberedEquation", \
"Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17130, 671, 397, 9, 57, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[17530, 682, 49, 0, 57, 49, 0, "StyleData", "NumberedFigure", \
"Presentation"],
Cell[17582, 684, 46, 0, 57, 46, 0, "StyleData", "NumberedFigure", \
"Condensed"],
Cell[17631, 686, 45, 0, 57, 45, 0, "StyleData", "NumberedFigure", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17713, 691, 392, 10, 57, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[18108, 703, 48, 0, 57, 48, 0, "StyleData", "NumberedTable", \
"Presentation"],
Cell[18159, 705, 45, 0, 57, 45, 0, "StyleData", "NumberedTable", \
"Condensed"],
Cell[18207, 707, 44, 0, 57, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[18300, 713, 49, 0, 33, "Section"],
Cell[18352, 715, 145, 5, 32, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[18500, 722, 145, 5, 26, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[18648, 729, 150, 5, 32, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[18835, 739, 33, 0, 33, "Section"],
Cell[18871, 741, 121, 3, 30, "Text"],
Cell[18995, 746, 226, 5, 36, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19224, 753, 295, 7, 36, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19522, 762, 400, 9, 36, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19925, 773, 387, 9, 36, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20315, 784, 401, 9, 36, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[20753, 798, 35, 0, 33, "Section"],
Cell[20791, 800, 184, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[21000, 808, 326, 8, 40, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[21329, 818, 135, 2, 40, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Open  ]],
Cell[21479, 823, 104, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[21608, 830, 316, 8, 40, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[21927, 840, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22074, 847, 337, 9, 40, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22414, 858, 107, 2, 70, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22558, 865, 345, 9, 40, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22906, 876, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23053, 883, 328, 8, 40, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[23384, 893, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23537, 900, 332, 8, 40, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[23872, 910, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24039, 918, 37, 0, 33, "Section"],
Cell[24079, 920, 115, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[24219, 927, 145, 5, 40, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[24367, 934, 42, 0, 70, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[24446, 939, 182, 6, 40, 39, 0, "StyleData", "SelectionPlaceholder", \
"All",
  StyleMenuListing->None],
Cell[24631, 947, 51, 0, 70, 51, 0, "StyleData", "SelectionPlaceholder", \
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24731, 953, 36, 0, 33, "Section"],
Cell[24770, 955, 305, 5, 52, "Text"],
Cell[25078, 962, 314, 10, 56, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[25395, 974, 81, 2, 40, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[25479, 978, 154, 5, 40, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[25636, 985, 108, 3, 40, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[25747, 990, 179, 5, 40, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[25929, 997, 115, 3, 33, "Text"],
Cell[26047, 1002, 96, 3, 40, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[26146, 1007, 104, 2, 56, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[26287, 1014, 36, 0, 33, "Section"],

Cell[CellGroupData[{
Cell[26348, 1018, 160, 5, 42, 23, 0, "StyleData", "Note", "All",
  CounterIncrements->"Text",
  StyleMenuListing->None],
Cell[26511, 1025, 75, 2, 70, 35, 0, "StyleData", "Note", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26623, 1032, 216, 6, 41, 26, 0, "StyleData", "Project", "All",
  CounterIncrements->"Project",
  StyleMenuListing->None],
Cell[26842, 1040, 78, 2, 70, 38, 0, "StyleData", "Project", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[26957, 1047, 203, 7, 36, 27, 0, "StyleData", "ListItem", "All",
  CounterIncrements->"ListItem"],
Cell[27163, 1056, 79, 2, 35, 39, 0, "StyleData", "ListItem", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27279, 1063, 208, 6, 38, 33, 0, "StyleData", "BulletListItem", "All",
  CounterIncrements->"BulletListItem",
  StyleMenuListing->None],
Cell[27490, 1071, 85, 2, 35, 45, 0, "StyleData", "BulletListItem", \
"Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27612, 1078, 339, 12, 40, 198, 7, "StyleData", "Reference", "All",
  CounterIncrements->"Reference",
  StyleMenuListing->None],
Cell[27954, 1092, 80, 2, 70, 40, 0, "StyleData", "Reference", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28071, 1099, 201, 7, 38, 24, 0, "StyleData", "Quote", "All",
  CounterIncrements->"Quote",
  StyleMenuListing->None],
Cell[28275, 1108, 52, 1, 37, 36, 0, "StyleData", "Quote", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28364, 1114, 212, 7, 40, 35, 0, "StyleData", "QuoteAttribution", "All",
  CounterIncrements->"Quote",
  StyleMenuListing->None],
Cell[28579, 1123, 63, 1, 35, 47, 0, "StyleData", "QuoteAttribution", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28679, 1129, 70, 2, 40, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[28752, 1133, 33, 0, 38, 33, 0, "StyleData", "IT", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[28822, 1138, 416, 11, 107, 30, 0, "StyleData", "ChapterLine", "All",
  CounterIncrements->"ChapterLine",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[29241, 1151, 42, 0, 109, 42, 0, "StyleData", "ChapterLine", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29320, 1156, 191, 6, 39, 32, 0, "StyleData", "ReferenceNote", "All",
  CounterIncrements->"Text",
  StyleMenuListing->None],
Cell[29514, 1164, 83, 2, 36, 44, 0, "StyleData", "ReferenceNote", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

