(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    772573,      20988]*)
(*NotebookOutlinePosition[    784048,      21278]*)
(*  CellTagsIndexPosition[    782411,      21233]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.8 Drop Formation", "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 66}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Drop formation"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002f0000L@P10`40000100000000E@00ZP00o`0T
000TE@0TZP0To`190019E@19ZP19o`1]001]E@1]ZP1]o`2B002BE@2BZP2Bo`2f002fE@2fZP2fo`3K
003KE@3KZP3Ko`3o003oE@3oZP3oob@002@0EB@0ZR@0ob@T02@TEB@TZR@TobA902A9EBA9ZRA9obA]
02A]EBA]ZRA]obBB02BBEBBBZRBBobBf02BfEBBfZRBfobCK02CKEBCKZRCKobCo02CoEBCoZRCoodT0
04T0EDT0ZTT0odTT04TTEDTTZTTTodU904U9EDU9ZTU9odU]04U]EDU]ZTU]odVB04VBEDVBZTVBodVf
04VfEDVfZTVfodWK04WKEDWKZTWKodWo04WoEDWoZTWoofd006d0EFd0ZVd0ofdT06dTEFdTZVdTofe9
06e9EFe9ZVe9ofe]06e]EFe]ZVe]offB06fBEFfBZVfBofff06ffEFffZVffofgK06gKEFgKZVgKofgo
06goEFgoZVgooi800980EI80ZY80oi8T098TEI8TZY8Toi990999EI99ZY99oi9]099]EI9]ZY9]oi:B
09:BEI:BZY:Boi:f09:fEI:fZY:foi;K09;KEI;KZY;Koi;o09;oEI;oZY;ookH00;H0EKH0Z[H0okHT
0;HTEKHTZ[HTokI90;I9EKI9Z[I9okI]0;I]EKI]Z[I]okJB0;JBEKJBZ[JBokJf0;JfEKJfZ[JfokKK
0;KKEKKKZ[KKokKo0;KoEKKoZ[Koom/00=/0EM/0Z]/0om/T0=/TEM/TZ]/Tom]90=]9EM]9Z]]9om]]
0=]]EM]]Z]]]om^B0=^BEM^BZ]^Bom^f0=^fEM^fZ]^fom_K0=_KEM_KZ]_Kom_o0=_oEM_oZ]_oool0
0?l0EOl0Z_l0oolT0?lTEOlTZ_lToom90?m9EOm9Z_m9oom]0?m]EOm]Z_m]oonB0?nBEOnBZ_nBoonf
0?nfEOnfZ_nfoooK0?oKEOoKZ_oKoooo0?ooEOooZ_ooo`0:QHBYZHF9ZHV5R@>500B4QHB40XD018BU
QH@2Q@0;RJV5Q:V4ZHB5Q:D00X@03JV4QHVUQJV5ZJF4QH@00XD02HV5ZHV5ZHFYY@02Q003RHF500:5
00>YQHT00XD02XV5QHB5Q8F4ZHD2Z@0:Q:V9ZHFYYJV4Z@>U00>5ZHD00jT2Y@0<ZHBYQHV4QHB5YHBU
0hD01ZV5ZHF4Z@:40XD01hBUQJF5Q:T00ZD01JVUZJFY00:U1:T00jFYZ@02Z@:U00BYQHB40jD01JBY
YJVU00>Y1JD1Y06U0H@00003QJV500:400>9QHD00XD04JV5RHFYRJF5YJV5Q8F9Q8F400F500jUQ8V5
ZHB5RHBUQJF5Y@B500>YQJD02XD01ZV5ZHF9Y@J500>4ZJT00XD2Z@03QJFU00:U00ZTYHB5RJF5ZHBU
0jT2Y@03RJV500>500>YQJD00jD02JVUZJF5YHFYQ002Q@09RJF5ZJF9Q:V500>Y0XD00jF4Y@02Q004
YHBUY@:Y0ZD2Z@03YJVT00:U00F9ZJFUZ@03Y@06Y:FYYJB52:D1Z@000X@2Z@05QJF9QJT018D2Q0:5
00>UQJD018D01XVYQJV4R@B500B4YHFU0hD02:V5ZHBYQ8FU1hD00jV5Q@0<Q@03Q:VY00:Y00^9QHF9
Q8FUQHVUR@03Y@03ZHFY00>U00J5Q8BUQ:D2R@09ZHFYQJV4RHBU00:40jD00hFYQ@03Q@04RHFUY@B5
00>4QH@00ZD01ZV5ZHFYQ@:Y00>5ZJD00ZD00jVUZ@05Z@07RJV5YJVUY005Y@:Y00V5YJFYYJVUZJ@0
0JD000:Y00R4QJVYQJF9Q0:500JYQJV9QJT2Q@:Y0XD01XB5QHBYQ0:500J9YHF5Q:T3Q@:400>5Q:T0
2hD00jV5Q@02R@>500B9ZJV90XD01JV4QHFY00>500>YQHT00hD018BUQH@2Y@03ZJFU00BU00J4ZJB9
YHT6Q@08YHB4ZJBUQ:T2Y@03Q8F500>500ZUQHF5Q:V5ZHFY0ZD00jV5Y@09Y@:Y00>TZJD00jD01XVY
YHVYY0:Y00>UZJD01:D00hVUY@05Y@6Y0003Q005ZHFYZHD00jT028V4RHF4YHV40ZT00hF4Q@03Q@0:
RHF5ZHB5Q8F4Q@>400>9QHD00hD00jV5Q@06Q@08Q8F5QHV4QHT3Q@03Q8F500:500N4RHF5ZHF900:5
00>9QH@00hD5Y@03QJVU00:Y1HD00hV4Q@03Z@:500BURHBY0ZD02JVTZHBUQJV5Z@02Q@06YHFYQJVU
1H@01:F4QH@3Y@04ZJFUQ0:U00BTYJFY0ZD01:BUZJT4Y@03ZJG=00:U00BTRJV50ZT6Y@6T00001XFY
RHFYQ@:400R5Q8F4RHFYQ@:Y00V5ZJVYQJV4ZH@00hD028B5ZHFUQJV90ZT4Q@07Q8F4QJVUZ@03Q@:9
00>5ZHD00XD01hV4RHV5RHD00ZT018V5RH@2Q@03Q8F500>500Z4QHF9QHVUZJF40XD028B5ZJF9ZHVY
0ZD01XF4ZHBUQ0:U00bYY:VYYJB4RJFYQJD3Q@07Q:V4ZHVYQ@02Z@08YJV5ZHB5YHD2Q00<QJFYZHVY
YJVUZHVY0ZD018BUZJD3Z@:U00RYQHBUZHBYQ0:U0J@1Y@6U0005Q@:Y0hD00hB9Q@03Q@03Q8F500:5
00>9QHD00hD018V5RJT2Q@:400J9QJF5RJD5Q@:Y0hD00hB5Q@05Q@05RHF9QHT00X@018V4QHD2R@:5
00>9QHD00XT01:V4QJD2Q@03Q:F500:400n9ZHFYRJF4RHFUQ8F4QJT00jD01:V4YJD2Y0:Y00nUY:FU
QHVUQJF4YHFUQJD00hD00hB5Q002Q@05Q:FUZHD00jT00hF9Y@04Y@04Y:VUZ@:U00BTRJVY1:D01JVT
YJF400:U00>4YJD01:D00005Q:VYZHT00hD01XV4QHF9Q0:50hT02:V5ZJV9QHV40hD00hB5R@02Q@04
YHF5Q0F500N4QHF4QHB900:500FURHF5Z@04Q@03Q8F500>41hD00hV5Q@06Q@03YHBY00:Y00BUZHB9
1X@018VUQJD2Z@04YJRUY0>400BUQ:RY0ZD02ZBUZJV9YJV5ZHD5Y@FY00>4ZHD00ZD01:VUQ8D3Y@04
RJF9Z@BU0ZT2Y@06ZHBUYJVU0jT02ZFYZJFYYJBUQ:D1Y0000XD00hB5Q002Q@04RHF5R@:50XT028F9
Q8F9Q8F91HD02ZV5ZHFUQHV4QH@4Q@04Q8F9Z@N500^4QHB5RHF9QJV5R@02Q@03ZHF500J500BYQJV4
0jT028B5Q:F5Y:F40ZD03:BYZJV9Q8FUQJF5Y@:400RUQ8V5ZHF9Y@:Y00>4ZJD00jD00hF4Q@02Y@03
QJVY00:U00N9YJFYQ:F500:U00n4YJFUQ:VURJF9YHB9YJT00jD2Z@07YJV4ZHBYQ003Y@05RJBYYJT0
1:D1Z@6U000038B5RHFYQ8V4RHB5Q0B500>4QH@00hD4R@04ZHF5Z@B500B4QHFU1XD00hV4Q@05Q@03
Q8F400F500B9QHF50X@01XF4Q8V5Z@:500JURHF4QJT3Q@07Q:V4ZHF9Z@02Q@0;YJV4YHBTQJF5YHD0
0ZT2Y@09Q:V5QJV4YJBY00>U00NYYJVYQJF500:U00V4ZHBYQ:V4ZHD00ZT018BYYJT3Y@0<ZHFUZJFY
YJVUZJFY0jD01XBYY:V5Y0BU0ZT2Y@05RJFUYHD00ZD000:50XT7Q@06RHF9QHV50XT2Q@05Q8F5RH@0
0XD02jV5ZJV5ZHFYQ8F400:500>4RHD038D018B5QHD2Q0:500FYQHF5R@04Q@08Q8F4QJV5ZHT2Z@:5
00B9QHF90X@00jV5Y@03Y@08ZJF5ZHFYQ:D2Q@06Q8F4QHBY0ZD01:VUZH@2Y@03Q:F900:400ZYQ8FY
YJVUZJFY0ZD01ZVUQHFUZ@:U1:T2Q@05Q8FUYJT01JD01JVUYJV500:U00N4YJFUQHB500:400>YYHD0
0H@000:400^9QHF9QHV5Q8F4R@03Q@05Q8F4RH@00hD01hV5RHB9QHT00hD00hB5Q@04Q@03ZHBY00B5
00>4QH@00XD01HV5Q8VY00:50XT2Q@04Q8F5Q0:500F9QHFYQ@02Z@:500BUQJVY0XD02hVYZHFYYHBY
QJFY00>500RUQ8BYQ:V5Z@:50XT048B5ZJVUQ:V5ZHBUQHBYYH@2Y@04QJF9Y@:50jD00hB5Y@02Y@04
QJFUZ@>U00B5ZHFY0ZD00jVUZ@02Y@03Y:V400:U00B5YJF50jD01ZV5YJVUZ@:U0J@00003RHFY00>5
00>4QHT00XD02HV5QHFYQJV9Z@03R@0=QHV5QHV5RHB9Q8V5R@02Q0:500B4QHF40hD00hB9Q@06Q@04
Q8F5Q@:400N5RHV5RHF900B500J4QHF4QH@2Q@03Q8F500B500>YYH@00XD2Y@04QHBYQ0>Y00VUZHF4
QJF5YJ@00X@00jV4Y@02Z@05YHBUQ8T00ZD01HFUQJF500:U00R4YJFUZHFUZ@:500FUQ8V4Y@02Q@06
YHFYQJV40jD00jBUY@03Z@04Q:V4Y@:Y0ZD028VYYHB5Q:F40ZD00004Q8F5Q0:500B9QHV50XT3Q@03
RHF500>50h@5Q@06RHF9ZHF40XD028V5QHF4RHB91HD00hB5Q@03Q@07RHF9QHV5R@02Q@03Q8V500F5
00>9Q8D00X@2R@03QHBY00:400F5Q8B4Y@02Z@:U00>TZJD00ZD01HB5Q:F500BU012TZJVYQ:V9Y8V4
YHF4QJF91:T2Y@03RJV500:U00>5YHD00ZT01JF4YHFU00:400JUQJV5Q8D2Y@05Q:VUZJD01:T018B5
QJT2Q003QJFU00:Y00BUZJFY0jD000B500F9Q8F4R@03Q@03RHF500B500FYQJV5R@02Q@03ZHB500>5
00>4QHD00XD01XB5QHF9Q0:500B4QHB918D01hV5RHF9QHT01XD00hV5Q@02R@:50XT00hF4Q005Q005
R:V4Z:@00jT01:BYZHT2Z@04RJVYZ@R900FYQ8BXR002Q005RJB9Q:D00ZT018FYQHD3Y@0IQJV5YHBU
ZHFUQ8VURJFYYHB5Q:V5ZHFUQ@03Y@0=ZJFYYJVTZHB5RJVUZ@02Y@04QJF4Y@:40JD1Z@6U000:Q@:9
00j5RHFYQHB5Q8V4QHB5Q0:500B9QHF91HD01hB5Q8V5RH@00XD00hV5R@02Q@0;RHF5Q8F4QFF9Q8T0
0XD00hV4Q@03Q@05Q8F4QH@00hT00jV9R002Z0?=017BeMGfn_kfo_[fo_[Foo_jo`02nP04m][Fd@:]
00>9R:T00ZT01:B4RJ@2Q0>500B4ZJFY1JD038F9YJFYQ8F4YHVUQ@:901B5ZHFUQ:V4QHBYYJBUZJFY
Q:V5Y@:400F5YJFUR@04Z@690JD1Y@000hT2Q@04RHF5R@V50XT01JV5RHF900N500>4QHD01HD2RA65
00EUQFETI@08Q@05Q8F9RH@00ZT00jg=[@02e@0:mOKEe_kfo_onnP;n3ol2n`06n];BSHVY0XT01jV9
QJV5Q:D00X@2Y@04ZHF4Y@>Y0ZD00jVUZ@02Q@05YHF4ZH@00XD2Z@>U00>YYJT00jD01XB5QHFYY@:Y
0ZD00hFUY@03Q06U0HD00009QHV4Q8F4QHV400:900>5ZHD00hD2R@:500V4RHF4QHB5RHD00XT00hF9
Q@02Q@05Q8F9QH@00XT01XF9QHUUR@B500N9IHETRFAU009Y00]UI8ETQHB5Q8F4R@02R005cJg=mM40
0_H02MKEn_Kjoo[on`0Jo`03nmKB00>900J4YJBUY:D3Z@03QJV500:500>UQ8@00jD00hB9Q@02Z@04
QJV9Z@:U00V5ZHBUQ:V5ZHT00hD02:V4YJV5RHBY0XD01:FYYJT1Y@0000>4QHT00XT4Q@06RHB5Q8F4
0XD00hB5Q002R@05Q8F9Q8T02HD00hV5Q@03Q@06RHF5QFF50fD018UUIFD2J@=U00MTIFEURFF900:5
0XT5Z@0<Z8g=[OGE]OKjm_ko0_X2o`04f_oona_o00?FZHT00ZT01XR9RJF5Z@:500FYQJVUZ@03Y@09
RJVYQHV4RHB900:Y00FUZJFUZ@05Q@07ZHFYYHF9Z@02Q@05ZHF5ZJD00hD000:900N5Q8F4QHV400>9
00>5RHT00XD3R@0=QHB5Q8F9I8V4RHF9Q@03R@B50V@01HEUI8UT009U00B5IFV90VT016ETI6@2I@:5
00>9QHT00XT00hFYQ004Z@0?Z:g=dOGEm_kj]Okff_of00;o00?jool07_l01O[BJHV500:Y00BUQ:V5
0ZT018FTQ:T2R@03QJV400JY00>5ZHD00XD01ZF5ZJV5Z@>500Z9QHF5Q:V4YJV40hD2Y@0000>4QHT0
0hT2Q@:90XD00hV5Q@02Q@06Q8F4QHV40hT00hF9Q@02Q@04Q8UTI09U0XD016F5QHT2I@04JFEUI09U
0V@00dAUI002J@>900F5RHF5I@02R@03QJV900BY016]dM7=m]GfmMKEn]KjnokknP02o`03nooo023o
00Z=RHBXQ8V4QJVT0ZD02jV5RHFYRHFYQ:V500>Y00^5ZJV4YHFYQ:V5Y@03Z@03QHVU00B500>URJD0
0hD00003QHV500B500>9QHD00XD016F9RHD2R@05QHV5QHT018D028ATQFF9JFF90VD00fB9Q@03I@03
JFEY00=U00=YI6D00V@4I@J500V4RHF4RJV4ZHT00ZT2S@>]00CAeJgf0oX2oP07n_kon_koeP0Ro`05
nZf9ZJP00ZT2Q@09YJVUQJV4YHBY00:500BYQJV40ZT00hFYY@02Q@08RHBUQHVYYHD2Z@03QJV900J5
0ZD00003Q8F500:500B9QHV90XD2R@AT00f4QHEUQFB9QFV5RFF5009U00AYIFET16D01hEYIFUUJF@0
0VD2A005I6EURHD00hT2Q@09RHF9QHV4RHBY00:90ZT03jfY[Hf]dJg=d]F]m]FenP02eP05o_KjooX0
1?l00o_on`0Mo`0=njV8Q8V5ZHF4RJVUQ@02Z@07YJV5ZHF9Z@02Q@08YHF4ZHFUQHT5Q@09Q:V5ZHFY
QJVU00>50HT000:918D02hB5QHB5I8ETRHF900:500B9QFV90V@3I@04QFF5I0AU00AYIFEY16D2I094
0V@00fUUR@03R@B500F4RFF9I002Q@03Q:V500>900n4RJV=[HV]cHgEcJgEdK400_H02o[Fo_[FooZf
f_oJ00;o00?jool07?l01?Z=RJP2Z@05Q:FUQH@00hD00hBYY@05Z@04QJF5Y@F500>YQJT00ZT028F9
Q:V5YHB50X@1Q@6U00000hB5Q@02Q@07Q8F5QHV5R@02Q@04IHETQ@9U00=TIFD00VD02FAUIFUUJFEY
I003I@03JFEU00=U00=TIF@00V@00fUTR@03R@05QHV5RHD00XT02HF9RHV5Q8V5Q002R@03Q:V400:Y
01R]SJR9[HfY/JgEmJgEn]Kfo]Knf_kJo]X2o`08f_oJoo[koo/Io`06cHR9RJV40jT028FYQHFYQJV4
0XD028V5ZHF4ZHFY28D00jV4R@02Q@03ZJFU00>500000hB9Q@02Q@03RHF400:500N4QHV5RFB9009U
00AYIFUY16D016AUI6T3I@06I6UUJFEY16D4I0F900YTRHV5RHF9QHUT0XD2Q003QHV900F900NYR8VY
RJV800>]00K=[JSfeJd2d@08d_KFn]KnomD3fP;o00?jool07?l00oJ9Z@02Q007ZHF5ZHBYR@03Q@03
ZHFY00:500BYQHF50ZT01HBYQJV500>Y0XD00jV5Q@03Q@6U0HD1Q@0000F4QHATQ003Q@03RHF900:5
0VD00hEUI003I@05I6E4A4D00T@016E4JFD2J@AU00=TIFD016@00fF9S@02R@03ZHUT00:900B4QHUT
0XD00hV5R@02Q@:900B4QHV40XT01hB9ZLf4[Ld00ZT01JfY[LfY00:]00GEdMGEmP02nP;E1mX5o`03
nook01So00GjRJV5R@02Y@0:QJV4ZJFYRHFYQ0:500N4ZHF5ZHVU00:Y00>5ZH@00ZT4Q@03YHB500>5
0JT00009QHV9QHUUQFB5009T0VD00hUUI002I@9Y0VD01VU5AFE5I@950VD2I007IFUUIFUUJ@02I@04
I6QXS@:900F=R:V9Q002R@03Q8F500:500EUQ8F9Q@02Q004RHB8Z@:500B9ZHB40XT2Z@09Z:W=RJgA
Z:gB00;A00CEcMGf2=X01M7oo][o00;J0_l00o_oo`04o`03nooo013o0XT04ZBYQ:F4ZHFYRHF9ZHB9
Q8FYQ0:500N4QJVYQJV900>Y00B5ZHFY18D2Q00000J5IFETIF@3I@03I8UU00=U00=YIFT00VD5A@06
A4E4JDEY0VD01FUUIFEY00=U00ETA6R=c@02S@03[HV900>90X@00hF9I004Q@R900V5RHF5RHFYQHT0
0ZT01jS=R:WBZ=800jd03<f]eOGFeM7JdOGJd@;J00GAf][JoP05o`03nooo01Ko00J8RJFUQJT2Q@03
ZHFY00:500>4QH@00XD028BYQJV9ZHV50ZT5Q@07Q8F5QJF5Z@01Q@000VD00hF9R@05I@03I6UU009U
00ATA4E42TD016E5AFT2I@05JFEUJF@00VD00fB8[@02[@03SHUX00:900ETQ6B9Q003Q@04RHF9I@B5
00R4QHVYQHVYR@:500R9ZHV4ZHVYZ0>]00NXcJf]mJge00;E00?Af]401mX02_Gof][oo]Koe_h5o`03
nooo00oo00GfZJF5Z@03Q@:90XD03:V5ZHV5ZHFYQJV5R@:500>9ZJT00XD01JVURJVU00:Y0HD1Y@65
00001HUUIFET00EU00=YIFD00fD7A@03BDE5009500EYADEUA004J@03AFEU009T00=YSJd00Zd00jR8
Z@02R@05R8V9Q6@01XD3R@08QHV9RHF9QH@2R@03Q:V500:900BYRJV90ZT01Jf8Z:R]00:X0jd00m7J
d@02fP04dM[Jd@;J00?ef]X00mX02ooJookfn_oFoo[J017o0XT2Q@:900>4ZHD00XT00hF9Q@02Q@0:
RHF9ZHFYQJV9Z@:500^9QHF5YJV9ZJF9Z@01Y@001VD016UUIFT5A@05A4E4AD@01dD2I@03JDAU00EU
00MTJFATJHW=00>]1HT00fB9Q@02R@07IHUURHF9I003Q@:400f5RHF9ZHV5RHB9I8R900:400b9ZHVY
R:fXR:f8SJd2Z00=mJgAdJgedM[AeM[AmP04fP05e_onn_h01?l00o_on`02o`03f_oo00[o00GjRHV9
Q@02R@0BQJV5ZHFYQHVYQJV5ZHFYQ8F40XD2Z@07QJV4ZJFYY@04Q@0000^9IFUUJFAYI6E5I@02A@03
JDE500E500=9ADT00dD00dA5I@03A@04IDAYJ@9U00ATJHVe0jd02Xf8RHV4RHF9QHT2I@04RFEUI@B5
0hT2Q006RHF4RHF40XT018BYZJT2R@04SJgBdP:]00?f[OH00_H2fP;E00Ge[Jf]d@03[@0>SMFe[KGF
]OkFf_onooh2o`04n_oofP;o00?kool02_l02Hf5RHB9QHV5R@02Q@:900>YQJT00XD00hV5Z@02Q@:Y
00F4YHF5Z@03Q@03YHB500:50JD0009T0fT00fAUI@02J@Q500A4ADE414D2I@03AFE500=U00i5IFEU
JFB9SJgF[HV]R0:41HD01HV5RHUT00:900R5IHUTQHATR@>800jYQ8BYRM7FeOJ]Z8SEmPWo0_/01_oF
f_F]d@;J2ol02?[FT_oFn_on0_l00o_oo`02o`03o_[J00Wo0hT02:VUQHV5RHBY18D00jV5Q@02Z@08
RHF5Q8F4QJT2Q@05ZHBYYHD00ZT1Q@0000AUJFET0fD00fAUA@08A@04BDE5A0I500=4ID@014D00fEY
I@02I@04SMF][@J900Z5RHV5RFF9I6V50V@00hF9I@02R@0CSHV=m]:a[JV8cMGfo_[F[Hf]nP07o`;k
0_l02?_on_Ke[M[n3_l01?Jef_l2fP05ooKoomH00_l01O[oo_[n00Oo012=RHF5ZHB5RHF4QHV5ZHF9
28D00jV5Q@02Z@03QHV500:500>4QHD00HD0009U00=TIFD00VD01FU5ADE900=500=9ADT01TD2I@09
AFE5IDEUJDEY009500I4I6SB]Jd3R@:Y00>9I8P00f@01HUTRHET00:800N4R8f=n_ok00Go00cFmM:e
e_[Jn]K=R8d7o`05m__oe_/00_H01KKB[Hgf017o0]H02M[FT_jfm_kjoP05o`;n1_l018V5QHD2R@07
QJV5Q8F4Q@02R@08QHV5RHF9ZHT5Q@03Q8F500:Y00>5ZHT00H@00005IFUYIF@00fD8A@04BDE5B@M5
00=UAFD00dD01dAYBDE4I8d00]83R@05QHV9Q8T00V@03FV9RFR9JHV8[JR=/OH01ol01O_FSHV]00;F
00Ojm]:YRJgf00Co0fT01FEYJFUU00:900B4RHWj4_l00okoo`06o`05nm[JnmX00_l01?kJo_h3o`03
RHB900F900N5ZJVYQHV400>50XT2Q@04Q8FYZ@>500>9QHD00XD1Y@650HD0009U00=TJFD01TD2B@03
ADU500=500=9ADT00dD00fE5I@05I@0:JDE4JFET[HV8Q0>900=YRHT00XT01VR8SK7B/@?B00Fed_J]
n`06o`05eXUUI8P00VD00hUYJ@03R@03J=Ko00?o00KFJHV5RF@2R@03QHV500:91_l2J@03e_oo00Wo
0]X:o`03nooo00;o00?Jo]400_h00oJ9Q@02R@07Q8V5ZHB5Q002Q@:900ZYRJVYRJV5Q8V50X@4Q@04
ZHF5R@650004I@03AFUU00A500Q4ADE9A4U5B@A500AYADE40TD4I@0=A6U5ADB9cHV8QHUTR@03R004
Q8F9[@;j0_l01MGfmXgB00:=1_l00o]UR@02Q@05Q8F5QHT00VD016B9ROX4o`03nfB900>500ETRFF9
Q@02R@03nooo00?o00AYRFF90Xd01_KFSHf>S@;f0]H00o[oo`09o`03n_on00;n00KfeM[nZH@2R@09
QHV5ZHB9QHV400N500ZYRJVUQJV5ZHFY1HD1Q0000TD00dA5A002A0I500M9ADU5BDE9009500AUADE5
0fD00dEUI@02I@0>JDE5JHeURHf8RFV9I8T2R003RK7j00?o00?f/Xd00VD016AXJO/4o`0:nfV9RFF5
IHUUQ@>900B5RHWk1Ol01HR9QHB500:900MTRHF5IHgk00?o00>=I6D00XT00hF9S@05R@04R8WAePko
00GnoooJm@02d@03R:R400:900>5ZHD01hD028V5QHF9ZHFY0XD01JV5QHB900:500>4QJT00HD00005
A4E4AD@014D00dU4A@03A@04BDA5B@I516D01DEUIDAU009500=UA6D00hT01XR9R6B9Z0;j00>]e_l0
0ol2S@07IHF5RFB9eP04o`04JHUUR@:500N9QHBYRFB900>500?Fool00_l00hf8R@02Q@06RHR9I8AT
0XD016EYSXd3R@06ZHB5RJV40XT2Q@05Q8VXRJd04Ol2oP08f/f]Q:R4QHT3Q@05ZHF9QJT018D01hB5
QHF9QHT00hD01:V5ZHT4Q@0000E4JDE5A002A@04A4E5B@E500=9ADD01dD00dA5I@02A@05IDEUIDD0
0fD02Hf8J6R8JHV]nP04o`0<noofSFV9QHV4I8B50XT03=:=RFF9QHUTQFB4R@:400B9Q8F50XT01OKk
oheU00>418T00hR5Q@02R@07QFEUQFF5Q002Q@06RJV5ZHV50hT01JV4RHWF017o00CFeMZX18T3Q@03
Q:V900:90X@028F9Q8V5RHFY0XD01JV5ZHFU00B50HT1Q@0000E5A4AYA002J@9500AYADE91DD00dU5
B@02A@03JDE5009500EUAFE5J@03A@0<IFB9I8SBm]KB/[Gk1Ol01MJ9IHF900>50hT7Q@03IHF500:5
0h@00jV4R@02Q@9U0hT01FF9RHF900:Y00N9ZHF9Q8ET00:500F9I8FYQ002R@07ZHFYRHB9Q002Q@05
Q:V4RJd01?l01VV9JHVaePSo00CF[MJ80XT018F9RHD2Q0:900>5RHD00XT2Q@04Q8F5R@B500>YQ8T0
1XD00003A6UU00=Y0dD00dA5A@02A@05BDE5ADT00dD00dU5A@04A@03A4E5009500eUI6F9R:gjm]Ko
]I;f00Go00J=JHV9Q8T2Q@03IHF500>500Z9Q8V4RHBYIHUU0XD028V8RHV4RHF90XD02hV4QFF4QHB5
Q:V900:500>9QHT00XD018V5QHD2R@08QJV5RHR9QJT2Q@0:Q8F9RFV9SHF9I@:900AYRFV=2Ol01_J9
RHV8R@>800>9QHD00hT00hF9Q@03Q@:900R5RHF9QJV5R@B50002I@08JFE5A4U5JDT3A@9400<TADD0
0TD00dU5A@04A@9U00A5IFE50VT01VEYJJgonP?o00?fRKH01Ol2R@>40XT2Q@03RHF500:500F9QJV4
c@02R@09ZHFYZHV5RHB900F500F4RFB4Q@02R@03ZHVY00:500>YQ8D00hD00jVUQ@04Z@08QJV9RHB9
Q8T2Q@:90XD2R@>50XT02HF9I6EYRO_on`0:o`0:o]J8RHBYQHV5R@F500>9QHT00hD00jV9Z@06Q@00
0VD01FUUJDEU00A500M9ADE5A4E400A500=4AFT01TD01dATRMKjoo/00_l00o_oo`02eP:900Gfoook
eP02Q@04YHV5R@:500B4QHAT0hD02hB9QHVYQ8FYYFF500:900>5R8@01HT00hB5R@02Q@:90ZT01hV5
QJV9ZHD00jT018V4ZHT2Q003YHB400:400V9QHV5RHB9Q8T00XD01XV5RHF9Q@:900EURHWfoP02nP03
f_oo00So00>9Q8@00XD01HV5RHB900>50ZT01HF9QHF400:500B4QHF50H@00003IFUU009500=4ADD0
14D024U5BDU5BDE91TD026U5IFUUAFWF2?l01=Kke[42R@07/Hf]RHF=Y@02Q007R8F9Q8V5R@02Q@:9
00F5Q8F4R@03Q003ZHF500:500^9QHF4QJV4RJV5Q002Z@06QHB5RHBY18D01HB9Q:RY00:50ZT01HVY
ZHB900B500F4QHF4Q@02Z@05QHVYQH@00XD01fB5Q8V8SJd00]H:o`05mXBYQ8T00XD00hV4R@03Q@06
Q8F5RHF90ZT00hF9Q@02R@65000014EUAFD4A@03JDE9009914D01DU5BDE900=500E4ADE4A@02A003
RMKk00Go00NfnooFnoZ]00:900F4RHV9Z@02R@04ZHV4Q0B500>9I8T00X@2R@:50X@02HUTQ8B9QHB9
Z@02R@04ZHV9R@:500RYQHFYI:V9Q0:500>YQJT00XT00hBYR@05Q@03RHF400:500n4ZJV5ZHVYYJR9
Q8V4QF@00XD3R@05Z8V]dOX02_l01O^9QHV400:500B9QHV90XD2R@03QJV500F500>4QHD00H@00003
AFE500M500A9ADE50TT01TDTADU5B@=500U4ADE5A6U][O/01Ol01?^fnol2n`03e_Za00V900BYRHB4
0hD00hV5R@02Q@04Q8F9Q0:500=TQH@00XD01ZV5QHBYQ0>900B5YJF40ZT02hF9Q8B9QHB9Q8F400>5
00>9QJT00XD3R@04QHB4R@:40hT01hfYZHV4RH@018D2R@03R:V800;=00?jool02?l00oJ9Q003R@04
QHV5R@:500F9QHF4R@03Q@05RHF5QHT00XD000=500=YADD01DD00dA5A@029006BDE5ADTT0TD03TA5
ADE4JMKke[Kkoo_o0_/2o`;k00Wono_onZf=RHP00XT2R006ZHVYRJV90XD3Q0>50hT00hB9R@05Q@04
Q8F9I0:Y00b9Q8F5ZHV4ZHF9Q8T3Q@06Q8VYQHBY0XD018V5QHT3Q005R:V9RHd00jT02hFYQ8B5RFAU
QHV500:900N8RJVYcMGf00Wo00IYRJV9QHT5Q@03RHF500:500FYQHF9Q005Q@64000016U5JFT7A@08
A2A594DTBDD3B@A40TD00fWkeP02o`Ck0[H03OoF]_oFf_oJnoojdXd00hT00jV9Z@04Z@:900>YQ8T0
0hD00hB9Q002Q@07RHF9QHB9Q@04R@>500JYQLf5ZHT2Q0:Y0XT02XFYRHF4RHF4QH@2Q@07RHF4RJRY
R@05Z@06RHB9Q8UT0XD00hUUR@03R@0<R:VXZJg=[MKfeZgf1Ol01Jf5RHF900:500>9QHT00XT00hF9
Q004Q@:90hD1R@650008A@940dD012A9AB@2A@05A4DTA6P00fT00mKko`03o`0@eVeY][:B]]_kom[o
fo_on`?F00?ERHT00XT018B]ZHT3Z@05RJVYQ8T00ZT00hB5Q@02Q@08ZHF9QHV5RFD3Q@03RHF500:Y
0hD2Z@07Q8V9QHB5Q002Z@07Q8V9RJV9Q002Z@04Q:V4R@>Y00Z9ZHBYQ8V4I8F91HD048B9RJVXd/fY
dHR=cJfYe_X4o`06nhV9RHF90X@00hV4Q002Q006QJV5QHV50XT00hF9Q@01Q@001DD2A003ADA50095
00=4ADT00TT00dE9A@02A@05KMKjoo/00_l01__ooi9YTP:=00>Be[H00_/01=KknmH2o`03nook00?k
00?fSHT01HT018R]RJd2R@:Y00>4RHT00XT00hB5Q@04Q@:Y00^9ZHBYQHV4RJV5R@02Q0:Y00>4QHD0
0XT2Q004QHB9R@:800>YQ:T01:T02HVYRHB9QFB9Q002I009QHV5QHV5RHB900FY00F]Z:V]Z@03c@03
d__o00Co0XT01ZV5RHV5R@:400JYQHBUQH@3Q@03Q8V4006900000dE9A@05A@9900Q5BDE9ADA5B@95
00=4JI801ol01][kSI:9J@>=00WF]Y;oe__oe_/01?l2n`08e__fSK6]RHP2R@08SHVY[JVXZHT2Z@0<
R:V9Q:V9ZHVYQ:VT0XT00hB9R@02Z@03R:V900:900B4ZHV41JT00hVYZ@02Z@06RJV9R:V90X@018F4
RH@6R@04QHV9R@:50X@01HV8ZJV]00BY00BX[JV]0/d00hgoo`03o`03nXR400B900B4R8B418D2R@03
QHV900:50H@000=40TD014U5ADD2B@9500Y9ADE4BDE4AFWk0ol04O_ooi;J]Ff]KFVaSFffnmKK00;k
00CKoo^f0_/02=Kkno_onmKj0]H04hf9RHV8SHVXcHVY[JV9ZHVYcJD00ZP2Z@03RJV800>Y00B4ZJVX
0ZT00jRYZ@03Z@:91ZT028fYZHR9R8B528T01XR9I6ETQ@:90XD01JV5RJV900BY00J9Y8RYY:d3c@03
[Ooo00?o00?fn_l00_l01?J9ZH@2R@04QJV5Q0B50HT1Q@690002A@06BDE5BDE914D014U5JFT2A@06
A4E5JMKK0_l05__oe]KJTZeY[HeYRHeY]]JfnmOkeol5n`04oo_keP;k00GFnmKfnP02[@>900B4QHVY
0XT00hB]mP02e@03cJW=00FY00>XRJT00jT018W=ZJP4Z@04RJVYR@:Y00J8RHR8RHP2R@03R8V800B9
00B4RHfY1XT02hB9Q6B9R8V4ZHBY00:90jT00jS=Y@02c@03[Ooo00;o00?nool01?l00oZ5R@02Q0>5
00N9Q8V9QHV500690002A@03JDAY00E500=9ADD00dD00dU4A@03A@08T__ooo_onmH2TP05SFV9JHd0
0VT00ffB]P02eP05nmKknkH00_/01m^fokKkoo/00_l02o_ooo_je_KBSOJ]00:=0XT00hf9R@02[@:Y
00>9Z8T00ZT02HV]ZJV]RJV]Z@04R@07ZHV9Q8VYQ002R@07ZJf9R8f9R004R@05ZHV8[HP00hT01fB9
I8V4RH@00XT01HB9RJV400:900N5ZJF5ZJR]00C=00Kkoooon_/6o`B900J5RHF9QHT2Q@640HT1Q000
0VD2A@03JFE500=50154ADE5BFU9ADA5BDA5A9;oeP02o`08eY;FKFQYSHT3J@07SI:f/[KFf`02n`09
]__koo_onmKo00:f00Ooe]KonmKo00?k00KFm]KfeXd2eP05RHf]R:T00XT00jf8R@02R@04R8V9R0:Y
0hT00hR9Z@03R@03SHR=00:=00^9SM:9]Jf=[M9X[@02R@05SHQYRHP01hT038B5RHF9Q8V5RHBUQ@FY
0/d00mGfo`0:o`09JHV9RFF9QJV400B50XT0009U00A5IDEU0TD00fEYA005A@03A4E5009500AYA;;J
0ol02=KoeVf]JFB90VT00heUJ@02J@08T[;Fe[KFem/2n`07fooofo_on`02o`?k00Goe__keP02n`So
0_X00jgEmP02[@06mZgBdZgB0Zd00m:]S@04[@05SMF]SM800Zd01=J=/Jd3S@04[Hf=S@:900R]RHR]
R8f9I0>900F4RHBYQ@02R@04QHV5R@:Y00Z4ZJV4ZJRYcOJ]2_l01M:9ZHB900:500B9QHV50XT3Q@00
0VD02TEYAFE4IDE4ID@2A@06A4E4ADA50T@046WkomKJnmKoe[I]JHeUJHT4J@06IFUYSVVf0]/00mKk
n`02n`07fo^fnonfn`02o`03nooK00;o00?koo/01Ol01KKke]Kk00;F00?ke]H01]H02;KjT[Kfn];f
0mH019:=/Hd3/@06]Hfe[HRB0hd01FR=RHV800:900F8RHV9R004R@05QHV4QH@00XT03XF9QHV4ZHBY
[LgAm[7k1?l019;Foo/4R@07Q8F5QHV5Q002Q@03RHF500650003I@03JFEU00AU0TD01DA5ADE4009Y
0]H01kKjnfU9e_/00_l02MKJTXe]IFUUJ@02I@EY00]]e[JffkKkeo_KeP02n`04]_okf`;k00?Kno/0
0o/01Ooknonf00;o00OFnooFnooF00?k0]H4n`03f__o00:B017F]Y:fT[FfT]JBmY:=/Fff[@02S@03
TXf=00:]0Xd2[@03SJfY00>900B5RHB91XD02XV5RHV4RJW=YJd2oP03ohgo00Co0XT3Q@05RHB4QJT0
0XD01JV5QHF900>50005I@=500=4AD@014D014AYm]H3o`04fbA5J@?k00CofY:B0VT00heYJ@02J@9X
00A5JDEU0VT01hjfT]KK/]/00]H00o^fn`05n`08oo_koo_Foo/2o`03nook00?k00GonmKkeP02n`;F
00Cke][J1=H03?_FomZff]J=e[E]]P:a00CF]Hfa0hd01:f=SJd2S@07[Hf9SHF9Q@04R@06QHV5RFFY
0hD018V5QH@2Z@;=00GnoomYS@04o`04]XF9Q0>900RYQHFYQHB9Q@:40HT1Q@650003A@03JDEY009U
00=YAFD00dD014A5SMH4o`09BB@TA?_onook00;F00>B]FT00Xd01FEYJFU5009Y00=UJFD00VT02i:b
]]^b]]_F]_nf00?o1o/5o`;k0_l01[KonmKkfP?k0]H01__G]][FTP;F00Ffe][F]P03eP0<T]Z=n]Ja
m[J8]Jf80Xd01:f=SJd6R@04QHV5Q@:90XD2R@0=QHV9RHFYRHBYcM;=n`03o`9Y1?l2R@04R8V8R@:5
00RYQHV9QHV5Q0>50003A@03JDEY009U00AYIDE414D00kKofP02o`0>]TE5ADVBe__onkKJeVT2TP03
J6eY00AY00AUJFU416T01[:>]]^fn`:f0_/00kKk]P04n`03omKk00?o00Oke_^ffmKG00Gk00Cof]Ko
0]X02__Jnm_F]__FnmX2n`0?T_ZfSOJeSMJ=[KJ9SKF]00B=0hT016B9Q8D2I00<IHF5QHV5RHB9Q8FU
0XD2Q004Z?KEc@Go00=XRFT00ol01?J][Hd4R@:500>4QHD01HD00003AFUY00950fD2A@03JDE500=5
00>fno/00_l2A@04BDE4A@?k00Cof][F0i82S@=Y00EXJFEYI@05J@05SFVfTXd00[H00o^f]P02n`08
]_oknonfe_/5o`07noooe_ok/P02eP04]__F]P;k00KJno_F]_/2eP04f]KFfP?F00NfT]KJ]]Jf00:]
00JfSHV9SHP5R@04IHV9I@J500F9Q8F5Q004R@09YHBYdO[nnXWk00?o00GFQHV5S@06o`04SHF9R@:5
00F9QHV5Q002Q@0000EUAFEUJ@02I@03AFU500A50T@01DFBomIY00E500a4BOokoo_JnokJT]H2TP05
SFUYJFP00VT01FEXJ6UU00EY0Vd01[:ffmNfeP:f00KGno_k]_/7o`03e]OJ00Ok00?FT_/00[H01O^B
f_^f00?F00[Je[FfT_J=/MJB0Zd00fV=R@02R@:=0hT00fB9I@03I@:500B9I8V90hD3R@0<Q8V4QHB=
n_komXUU1?l01Hf9Q8Wf00Ko00N9QHVYQHBY00F50002J@=U0TD014A5AFT2A@03A4E900=500=9ADD0
0dD2A005JOoJnol00_/2o`;k00?F]Xd00VT03XUYKFU]SFQYBFEYIFUU0fT2TP07][;K][;JS@02eP03
em_o00?o0_/02=Kk][KKnmKk0]H01Onf][KJ00;F013JnkKkeY;kTVWFTZfBSK6]0Xd00fV9R@05R@03
R6AU00AU00>9QHT00hD028V4Q8V4ZHBY0XT01HBUZM7j00;o0hT00fGFo`02o`04mXf9R@Ko00>9QHD0
0XT00hF9Q@02Q@640HD00003A4EU00AU1TD00dU5A@02A@03A4E500990TD00dAYo`03o`03nook00Co
00Kkf[KFKHd2J@03]FUY00EY00EUJFUYA@04J@0:SFfbnk;J]Y:f/PCo00gJfo^fnmJfT]Jfe[Jb00CF
00VbeY:B]XffeVT00]H01i:aTXf]SFT00XT00fEYR@03I@05JFB9I6T00VD2R@05I8F4QHT00h@01HV5
ZHB500>Y00B4ZHSj0_l01hV5ZFF9JHT03?l2R@04QHV5R@:500>9QH@00HD00008IDEYA6U4AD@7A@03
JDUY009Y00Q5JDE5A6WFn`;o00Ckfm_K0_l00o_oo`02o`08eXkF]Y9YSI82J@03SFV=009Y00M4J4AY
J6U900EY00>BSVT00VT01[KooooF]P;F0[H2eP03/]KF00;F00>BSI800Y804K:=T[:fSI;BSHUYSFV9
J6B=00>900=YIF@00VD02HETI6B9IHEUQ@03R@03Q8V900:500>4ZHD00ZT00hVYZ@02Z@05d_ooohd0
0hD2R@03IDGo00Wo00R=RHF9I8V5Q0B50HT00006A6E4ADAU1DD01fE5IDEUAD@014D3A003S__F00;o
0TD01?_Koo/3o`?k00GoTY;F/@02eP:B00>>JFT00fT00fQYR@03J@06A6UYJO^>16T01Vf=oookTP>=
00=YSHd00Xd00kIYeP02S@03SXV900:=00F9JHVaJ@04R@03I6F9009U00MYIFUUI6ET00=U00F5RHV9
I002R@B500B4RHF41JT01hR][Lf]RMH01?l3R@05QHV9RMH01_l00fV9R@02Q0:900R4RHF9QHV5Q065
0002A@03JDEY00A500=UADD01DD00fU5A@02A@05JDE4e]/00_l2A@05BDGkoo/00ol03?_ono_onmKo
e[KkeP:B0hd2J@03RFV900=Y00EXKOI4J@02A09U0fT01=KfJHT5J@03SFUY009Y00EURHUYJ007J@06
IFUYIFUT0VD3I003JFAU009U00V9I8UURFB5RH@00XD01ZV5RHR4R0>400B9ZJf]0oH00mFYmP05o`:9
00F5RFB5I@06o`:900J5RHV4RH@3Q@:40hD00004JDE5A0950VD014EYIFD3A@03IDA5009514@01Hgo
no]]009900Y5BDUYokKonmKk1?l00o_Kn`03n`0;okKF][6=SXeYTVd00fT01]IYJ4AUJ@9U00]YIFF9
JHUUJFEYA@02I@9Y00MUJFEYIFUU00=Y1VD00fUUI003I@04I6UTJ@=U00=TIFD00VD6R@03QHV900:9
00ZYQ:VYR:V8[O[f0_X01=5YRKH4o`03dVV400B500=5ool00ol4Q@:400N9QJV5RHF900>50002A@EU
00Q5IFE5IDEUA0=500a9A4A5A4Ffoo]YAFT3A@0394E400A500^fnookffU5BDFff`03o`0?nooke_^b
SMJ=BFV=]VQY009U0VT01VEYJ6UUJ@AU00YYIFEUJFEYIFAY0VD01VAUIFUUJ@9U00>9IFD01VD01VUU
RFB9I@B900B5RJV90hP02HfYSJfY[LfYR@02[@03m_oo00;o00F9JFF=n`04o`>90XD01hV5SO_onhT0
18D00hV5R@02Q@05RHF5QH@00XD00005JFEUIDD00VD00fUUA@03A@04A4E4J@95019YADE4e_KkBDE4
ADA5BDE9ADT3A@06/__oofU91DD00mKon`02n`08oo_onmJfTZd2J@04nVUXJ@9U00>9JFD00VT00hgo
]P02I@03JFET009U00AXIFAU0VT016F9IHT2I@0DJFF9I6QTRFETRFF9IHUTRFETRH@3R@08SJf]SJfX
SJd2S@>]00NYRJV]m_ok00;o00KjRHV9QJd4o`07SHR9RHB9Q@02R@03JHV900:90VD2R@:500N9QHV9
QHV4006900001FETJFEY009U0fT2I@A50T@01dE4A4A]foX00dD014A5A4@8A@05e__oJD@00TD014U5
ADT4o`03JDFf00;k00KonmJ=nkH2S@04KFQYR@AY00>Bool00VT03fE4I6EXIHUUJHUURFETR@02I@04
I6F9I0:900UYI8V9I8UUI8d00hT05jV8SJf9SK6=[M6]e_KEm[F]SJgAeJgf00;j0_l00o^9R@02I@:5
00J=oooonXT2Q0:900N5RHF9Q8V500:900=YRHD00XD01hV5QHV4QH@00HD000=U00AYIFE41dD026U5
IFAUJKKk0_l00dU5A002A@03A4E500E500=4AFT00mH2A@990dD01fWkoomUADT00TD01kKkoooF]]H0
0Y800fVeJ@02S@06KHeYnooJ0VT048UYJFAYI6R9I6V9JFF9I6T7R@06J8f=[Hf90Zd01hRaSHf]RHd0
0Zd03_KEm][jo_[fooKFf_KF0oX00oKjnP02n`03SHF900J900Ofnon8Q:V400:500B9QHVY0hD01XV5
RFBYQ@:91XD00008A6E4JDEYAFD3J@950T@01DEUIKKf00?o00AYADA40TD01TU5BDE9A@9400MYA9;k
eVE5009414D2eP09omI4BDE9A4GF00?o00Gk]_^eeP02fP05SKF=T_/00_l3S@08RHeYJ8eYRJd2R@0G
SFV=JHUXIFV=RJeYSJgBSJfaSM:a[M400jd01_KFe_koeP;o00Wjooojnoojm]X00ol01?^=RF@2R@04
IHV9R@:500QURHEUSMKj[@>90hD01HB9QHB500:91HD00hV5Q@04Q@0000=UJFD00fD9A@03A6Ve00;k
0_l01?]5ADT2A@03A4E5009500Q4JDEYA6Wfn`940dD01DA5AFGk00;o00A5BDA40dD00fWoo`0<o`0I
noojeXeYeHV=[Ff=]Zff]Jf=JK6=]K6eS@02eP04n_ofeP;j00Gfe]GF]P03eP05noKFomH00o/6o`05
noKfn_/00ol01fUTIHUUQFD01HD01XUURFF9n`?o00?kQHT00XT2Q@:900F4RHUTR@02Q@03RHF900B5
00000dAUA003I@03JFEU00=500QUADE4JJgkeP;o00OFBDE5A4EY00A500UUA4EUJMKoeT@01dD028go
nkI5BDE414D@o`05nmKF]MH00Y801;Kjn_X2o`05e_[f][D00Xd2eP03f__o00;k0_l00o_oo`03n`09
f_ooe__je__F00;k0_l2n`08omJBRFEY[O/3o`03JHR500:500V9QHV9QHV5IHT00XD00hWko`03o`05
nhV5RHD00XT00hB5Q@02Q@03RHF500:500>9Q8T00XD00007AFU5JDEYI@02A@0:A6E4IDA5A4Fbn`;o
00GkAFU5J@05A@9400E5IFEYn`02o`04TTA5A@9400I5A6FbomH5A@05IDE5e_/00ol01=_ooo/:o`06
e_^Bnook0_l01?_ooo/2o`03nooo00?k00Goe__oeP02o`04noooePKo00OFm]:=m__F00;k0]H018UY
IFD2Q@03JO_o00;o00baRFB9QFF9IHV4RHD4R@03IJgo00Co18T00fF9R@03R@03QHV500R5000014A5
AD@2A@03JDEU009U00]5IDE5IDA]e_okJ@02A@07IDAUAFU4J@04A@0:JK;koo_FADA5J@9400E5JO_k
S@04A@04IDA5J@Co00>bII800ol00o_oo`08o`03nooo00Co00Gkoooon`05o`03nook00?k00Konooo
m_l2n`Co00=YRFD00VT00fAYI@02J@05RFV9IHT00XD00hU5o`03o`04J8UUR@:500=URHP00XT01XB9
QHUUR@Co00KkRHV4QHT4Q@04Q8F5R@>50XT1Q@690HD00006A4EYJFEY0VD01DE4IDEU00M500=4ADD0
34D00fWFo`02o`0;mTU4ADA5A4E4AFT00dD2I@9500MUT__onfeU009500=Y/_l04Ol02;KonhfffmKk
0ol00o]YI@03J@>=00EYIFF=n`03o`04eVUUR@9U00>9JFP016D028ETJFEYRFF=0ol00hUYR@08Q@03
RHF500:500F9JO_on`02R@>500N4RHF9QHV500:90hD018V5QHT1Q@001FD00fUUJ@05A@03IDE500=5
00=4ADD02DD02TA5ADEUe_KonfT2A@05A4E5AFD01DD01fE5ADE4IMH00_l2J@03ADA5009500=Ynol0
0_/01Onbfook00Go0VT6I@03AHgo00?o00=YI6P00V@4I@05I6UUJHT00ol00o]XR@02I@9Y00ATJHUT
0XD018V5IFT2I003IHWF00;o00WkJFAURHEURHD00XT00hF9Q@02Q@06RFB9QFF90hD01XV4RHV5R@>5
00F9QHV5R@02Q@690HD0009U00=5IFD01FD00dEUA@03A@03A6E500U500EUADE5A003A@06JKKoeVU5
0T@2A@9400I5A6EUJD@2I@9500IYnon=AD@4A@03JDEY009Y0TD00fU9A@05o`04AFUUJ@=U00E5IFUU
eP03o`08JFETIFUUJF@6I@07/__omVETJ@02Q@03IHAT009U00MYQFF5I6F9009U00>9JO/00ol01MJ9
RHUU00:900>5RHT00XD01hV5RHV5IHT00hD00hB9Q@03R@07QHV9Q8V5Q002R@:50HT1Q00000=5JDD0
0VT3I@03ADA500E500EUJFU5I@03A@06IDE5AFE40TD00dAUJ@04A@03JDE4009500M4JDE4ADAU0095
00aUAFE5A8gfJDEUJDD4I@U500F=oookeP03I@06JFB9IFU40VD018goool:I@05I6EUIFT00_l01oYX
JFUUQHT00V@03XUTRFF9QHUYIHUURFGk1?l02=J9I6ETIHV50XT02XF9QHUUQHUUQH@2Q@04RHF9Q@>9
00>4QHT01XD1R@6400000dAUA@03I@0;AFEYAFEYIDEYAD@02DD00fE5A@02A@03IDE400=500QUADE5
JDA5TP;k00N>IDA4AFU400=U00>9eVT00TD01fU4IDEYAFT00fD02dEUIFEYAFWkomIY009U00=TIFD0
0VD3J@9U00BfooI41FD02VUURFF9IHUYIHd2nP04RFETR@:500B9QFEU0XT2I0=U00F9IHV5mP05o`0:
SHV5RHETRFB5I0:500>9QHD00XT00hF4Q@05Q@05RHF5RH@00hT00hF9Q@03Q@0000EYIFEUJ@02I@05
JDE5A6T01DD2I@06AFE5IDEU0dD00fE5I@04A@03JDE500=500Y4AFWFm_okJFAU0dD01FF9S__f00=4
00=5JFD00VD2J@9U0V@01VE4IFE4J@?o00QYI6UUJFAUI0=U00MYIOKk/FEY009U00>9IFD00V@016ET
IHT3I@06ooYYJ8UT0XT02FEYRFB5IFB9I@03R@04QHUUJ@Go00?jRF@00XT2Q@03RHF900F500>9QHT0
0XD01hV5RHF9QHT01HD00hV5Q@04Q@0000AUA6EU0TD2I@9Y00AUJDEU1dD01TA5A6E5I@E500YUADE5
IDAUAFU40VT01_KooooFA09U0TD01FGFnooF009U00A4IFEU0T@01FE4IFU500AU00=TJFD00_/00oIU
I@03I@05JFEYIHT00fD00jgjS@06I@0HJFEURFF9JFETJMKkSFQYI8ETRFEYIHF90VD01VB9IHF9Q0:9
1_l01VF9IHV5R@:500F4RHF5R@07Q@:900f5RHF4RHF9Q8V5RHF900>5000016E5JFT2I@04JDA5I@=5
00EUADE5I@02A@=U0TD01FEYADEU00E500]YADE5JDEYA4Ffn`02o`08JDE5IDEYe_/2o`03nfE40095
00I4IFAUA6T2I@05JFEUIFT00f@02OKoIFUUJFEYI@02J@AU00ETSOojJ@05I@04JFF9I0AU00=YIHd0
0_l00o^9I002I@03RFF900=U00MTIFB5IHUT00:500>9SOl00ol2R@04IHF5Q@>900B5RHB90XD018V5
RH@5Q@>91XD018V4QH@2Q@0000EYADE4A@03I@9500EUAFEUA@02I@04AFEUA0A500A4IFE40TD00fEY
I@02A@0<A4E5ADA5IDEUSMIY0T@016EYAFD2n`;o00WFIDA5JDEYIF@02fD01VWknfUUA@YU00=Xn_l0
0_/2I@=T0fD00fAUR@02J@03IHWk00?o00?jRFD00fD016UUIHD2R@03QHUU00:500ETR6B9S@02n`04
/FF5Q@:90XD01HB9Q8F400:50XT00hF9R@02R@03QHV500>500>4QH@00XD01XV5RHV5R@640003I@04
JFEUJ@EU00Q5IDEUA4EUA@9U00=5IFT01DD00dA5A002A@07IDEUADAYA007A@03A4E5009500[F]_oo
SDEYA6E41FD01VUUJFU5J@9U00ITSOoo/FD4J@9U00IYIFETIHT4o`03SFUX009U00AYRFB90V@3I@03
JOoo00?o00F=RHUUR@07I@03QFF500>900=TRFD00VD00fV9R@05Q@03Q8V500>900R5Q8V5RHB5R@:5
00B4RHF50hT00hF9Q006Q@000VD01FUUJFE4009U00A4ADAU0TD2I@03AFEY009500=UA6T014D00fU5
A@02I@A50fD00dE4J@02A@04IDAYI@9500=YAFD00]H00fU5J@02A@04JFEUJ@IU00=4JD@00VD01fWk
oookJFD00V@016UUIF@3I@03JHVf00?o00CFIFEY0VD016AUI6T2I@04JFEUmPCo00>9JFD01FD026UU
RFF9I8EU0V@01fF9RHEUQFD01HD00hV5R@02Q@03Q8F900>50hT2Q@06RHF5Q8V40XD00hV5R@05Q@69
00000fE5I@03I@05JFEYIDD00fD2A@04IDEUA@9U00=5JFD00TD00fE4I@03A@03IDA500=500=4IDD0
0fD2A@=U00A5IDA50VD2A@04JDEUA@MU00=YIFD00VD01FUUAHgk00?o00=YI6P016D01VUTJFETR@;o
00OkoheUJ6ET009Y00UUJFAYIHUTIMH00ol01?]YRFD3J@09IHV5IHUTQFB5009T00b9I8F4RHF9IHF9
QHT2Q@:400N9QHF5RHF900:500>4QHT01HD02XB9QHV5RHB9QHT3Q@000VT02FE5IFE5IDA5A002A@09
IDEUA4E4AFE5009U0dD01FE4IDAU00950fD00dEUA@02A@07JDA5ADAYB@03I@04AFU5I@9500IYIDEU
AFT6I@08I6EUI6ETJHd4o`04RFEUJ@9U0f@01FUUIFF=00;o00ZfRHUTJFETIFAU0V@2I@07JHUYe_ok
S@03I@04I6UTI@9T0XD01HUURFF900:500R9QFF5Q6B9I0B50XT00hF9Q@03R@:50XT2Q@:90XD01hV5
QHF4RH@01hD1R@0000=UA6D01FD01FUUJDEU009500=4AD@00VD00dEUA008A@05IDE5AD@00TD00fE5
A@02A@04JDE5J@9U00U5IDAUAFE5JD@00VD2J@=U00=YIFD00fD016AUIF@3I@04nkKon`=U00QTIFET
IFUTJ@=U00=YIFT01fD00fUUI@02I@03I6ET00IU00MYI6B9I8UU00:5015UQFF9IHUTRFF5RHB9QHV5
R@08Q@03RHF900B50XT00hF4Q@02Q@05RHF9RHD00hT00hF4Q@03Q@000VD026UUIFE5IDEU1dD016U5
AFT2A@03JFEY00Y500=UADD014D056E5ADA5A6E4JFEYIFU4IFQUJDAY1VD01FUTJDAY00AU00F9e]IU
J@02I@03JFEU00AU00AYIFAU0fT01VF9IHUUI0=U00MTRFEUJFB900=U00N9IFEURFF5009U00j5I6F5
JHUURHF9IHUUR@=T00B5RHF918D01HV5RHF900>500B9QHB90XD2R@:500B9QHV428D00004IDEUA0UU
00A5IFUU1TD00fE4A@02A@07IDEUIDA5A005A@03A4EY009500UUAFUUI6E4JD@00fD01DAUIFEY009U
00ETIDAUI004I@03I6UU00AU00ETJFEYI@02I0AU00>9IF@016D00fUUI@07I@08RFEYIFB9IF@4I@=T
0XD01XUUIHEUR@9U00=TQF@018D026B9I8UURHF92hD00hV5R@03Q@05RHF4RH@00XD00hB5Q@03R@03
QHV50065000016EYIFT5I@04JDE4I@9500I4IDEUAFT2A@04JDEUI@9500M4IDE5IDEY00A500=UADD0
0TD00fE5A002I@0;AFEUIFUUA6ETID@00VD01fUUIFE4JF@00VD00fUUI003I@03I6EU009U00=YIFD0
0VD00fUUI@02I003IFAU009T0fD01HUUJFET009U00EYIFEUR@04I@03RFAU00:900=TQFD01fD016V9
QHT2Q@04IHUUQ@9U1hD00hV5R@03Q@03RHF500:500N9Q8V5RHF900B500B9QHV41HD00004IFUUA@9U
00Q5JFEUAFEYA@9U14D026U5AFE4IDEU0TD2I@07AFE5IFU5I@02A@06IDEUAFE516D02dEUAFE5IDEU
A6E400=U00=YIFD00VD2A0=U00A4JFEY0VD01FUUIFAY009U00ATIFB90fD01fAUJFEYIF@00fD038UU
JFETJFEYIFUUR@9U00=TJFD00VD00hUUR@03I@0CJFF9IHUUI8UTQFB4I8UUQHV5R@02Q@04Q8V5R@:5
00>9I8D00XT3Q@03RHF500>500IURHF5RHD5R@0000A5IFEY1fD014EUAFD4A@09A4E4AFUUAFEY0095
0fD01TEUAFE5J@950VD016U4ADD3I@07AFEUAFE4J@03I@04JDEUJ@QU00=YAFT00VD01FAUI6AY009U
00=YI6T01FD00fUTI@06I@05JFEYRFT00VD2J@EU00ATIFF90VD01XUURFAUI09U00=TIF@00VD01hF9
RHUURF@00XT02fB9IHV5RHF9QHV500:900B5RHF918D01hV5RHF9QHT00hD018V5RHT4Q@0000aUJFET
IDE4IDAUAD@2I@07JDE5IFUUJ@03I@05A6E5A6T014D00fU4A@02A@05A6E4AD@00TD6I@03AFEU00AU
00i4AFEUAFEYIFUTIDEUA@9U00ITIFEYIFT2I@03JFET00EU00=YIF@00fD016V9IFT3I@=T00=UI6D0
0VD01FUUIFEY00=U00=YIF@00fD2R@04IHUUR@9U00N9IHUTRHEU00=T00V9QFB5I8V5RHD00X@00fB5
Q@06Q@03RHF500>500>9QH@00XD018B9QHT2Q@690HD000950VD02DEUIFEYAFE5I@07A@08IDE5AFE5
IFT2I@07JFE5A4EUA@02I@I50VD00dEUA@02A@=U0TD026E4IFEYIFU50VD014AYIFT5I@05A6EUI6D0
0V@01FUUI8UY00=U00QTIFETJFETI@9T00=YIFD016D016UUIF@5I@0;JFAUI6V9I8V5IHT016D01HUT
IHF900:500j9QHF9IHETQFF9QHV5R@:500B9QHF90hD01hV5QHB9QHT018D00hV5Q@04Q@690HD00003
AFUY00=U00A4IDE40TD016E5IFD2J@03AFE5009U0TD00fE5A@08A@04IDE5I@Q51VD01FUUA6E400IU
00=YIFD02VD02fAUI6UUJFAYI6EY00AU00ETJFEUJ@06I@05I6EUIF@00fD01hUUIFAURFD00XT026UU
RFF9QFB90fD01XUUJHUUR@>50V@2R@>500>9IHD00XT4Q@03RHF900:500B4RHF90XD3R@07QHV5QHV5
R@04Q@0000IUAFEUA4D3I@03AFE5009500]UA4A4AFE5JFE5A002A@06IDAUIDEY24D016E5JFD3J@03
IDE500A500=4IFT016D00fAUI@05I@03JFEY009U0VT5I@9T00QUI6EYI6UUR@=U00=YIFD00VD3I005
IFV9IFT00VD01FUUIFEY00=U0f@2I@03I8UT009U00N9IHUUQFET00=U00=TJFD00XT01HF9QHEU00:5
0XT5Q@08RHF9RHF9QHT2Q@04Q8F5R@B500>9QHD00hT1Q@0000A5JFUY16D00dE4A@02I@=50VD00dEU
A@02I@950VD3A@03IDA500=500AUJDEU0dD02FE5ADE4IDEUA@03I@0:AFEUA6ETIDEUJ@AU00=5JFD0
0VD01FAUI6ET009U00=TJFD00VD00fUUR@04I@05JFEUI6T00VD00fAUI@03I@03JFAU009U00=TIFT0
0VD02fAYIFETJFEYRFF5009U00>9IFD00VD01HF9IHV500=U00B5I8EU0XD2R@05QHUURHD00XT2Q@06
RHF5RHF90XD2R@B500F9QHF5R@03Q@64000024EUAFE5IDEU0TD01fE5IDEUAFD00TD00fU5A@02A@05
A4E5JDD00fD00fUUA@05A@03A4E5009U0TD6I@04AFE5J@=U00=5IFT00VD00fUUI@08I@03JFEU00EU
00ITIFATIF@2I@03JFEU00=U00ETJFEUI007I@04JFEUR@IU00=TIF@00VD02HUUIHUURFEYI002I@03
I6ET00:900AUQHF50XT00hF9I002R@>500N9QHUURHF900:500F9QHV5R@06Q@05RHF9QH@00XD0009U
00A5JDEY0VD01FU5IDEY009500=UADD00TD01VE5AFE5J@9500=4ADD00dD2I@=500=4AFD00dD2I@E5
0fD00dEUJ@04I@03A6EU009U00A4IFAY0VD00fUTI@06I@9Y00=TIFD00fD00fUUR@04I@05I6EUIFT0
26D01FUUIFAY009U00R9IHUUI8UUR@QU00>9IHT00fD00hF9R@03I@07I6ETRFF9Q@02R@>500>9QHT0
0hD016B9IHT4Q@03RHF900>500B4QHB90HD000=U00=5IDD014D01VU5IDEUJ@=500EUADE5A003A@05
JDEUAFD00VT2A@9U0TD00dA5A@05A@04JDEUI@A500MUAFEYA6EY00QU00=TIFD01FD00fUUI@02I@9T
0fD2I003JFEY009U00MTIFATJFB9009U00=TIFD02FD01FAUIFET009U00>9IFD00VD00hUUR@04I@0B
I6ETJHEUQFF5IHF9QHV5RHF90XD018B5RHD2R@03QHV900>900EURHF5R@03Q@05RHF9QHT00HD00003
JDEU009U00I5IDEYAFT2A@05IDE5AFD00dD3I@9500AYADEU0TD00dA5A@04A@03A4E500=U00E5IFE5
J@03A@07JDEYIFUUA@02I@03A6AU00YU00=TID@00V@9I@03RFEU009Y00ETIFETJ@09I@9Y0fD00fAU
I@02I@04RFEYI@:9011UI8V5IHUURFETJFF9IFUU0XT036F5IFF5RFB9I8F9Q@>900f5RHF9QHB9Q8F4
RHF400B500N9QHF5Q8V400690004I@04JFE5I@950VD3A@05JDE5IFT00dD014AUAFD5A@08A6E5AFUU
AFD2A@06IDAUAFE40TD01FE5A6UU009500=4AFD01FD00dAUI006I@03I6ET00AU00ATIFEY0fD00fAU
I@05I@04I6ETJ@9U00=YIFD00V@5I@03RFF900IU00ITJFB9IHD3I@08JHUYRFF9I8T2I@0=QFB5RFAU
I8V5RHF9I@05Q@03RFB900>500N9QHF9Q8UT00:500F9QHF5I002Q@690FD00003IDA5009U00I5IDEY
AFD2A@05IDE5AFD00TD026E5AFE5A4EU0dD00fEYA@02A@04A4E5A09500=UAFD01DD01TA5IFE5J@9U
00=YIFD04VD2I0MU00ATJFEY16D026AUIFETJFET26D00fAUI006I@03I8UU009U0XT01FEYIFET00=U
00B9IHUU0XT00fF9Q@02Q@03RFB5009T00N5RHF5RHF900B500>9QHD01HD01HV5QHV500:900>5RHD0
0HD000AU00=YAFD00TD2I@950fD014EUIFT2I@A500=4AD@01DD3I@A500=4ADD014D4I@08ADAUAFE5
IDD6I@03I6E400=U0V@3I@04I6ETI0MU00MTIFETJFEY00=U00=YIFD00fD00fAYI@07I@06JFF9IHUU
0XT01FAUI6ET009U00J9JHUYIHT8I@07QFAURHF9Q@03R@04IHF5Q@:400F9QHV5R@06Q@03RHF900N5
0H@1R@000VD01TEUAFE5A09U00=5IFD00TD2A003ADA5009500I4ADE5A6T5A@9400E5A4E5A003A@05
IDEYAFD00dD3A005IDEUA4D016D00dAUI@02I@03I4AU00AU00EYIFEUI002I@=T00=UI6D016D00fUT
I@02I@06I6EUI6ET0VD016UUIFT2I@05I6ETIF@00fD03VUTIFEYIHUUJFETRFAU0f@00fUTI002I@0;
RFB5I6ETIHEURF@018D2R@09QHV5RHF4QHB900V500>9QHD00hD00001\
\>"], "Graphics",
  ImageSize->{141.938, 88},
  ImageMargins->{{70, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
In this section we discuss the formation of drops by an \
axisymmetric model. A typical example of drop formation is shown in the \
pictures below.\
\>", "Text",
  CellTags->"formation of drops"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004e0001/PP10`40000100000000E@00ZP00o`0T
000TE@0TZP0To`190019E@19ZP19o`1]001]E@1]ZP1]o`2B002BE@2BZP2Bo`2f002fE@2fZP2fo`3K
003KE@3KZP3Ko`3o003oE@3oZP3oob@002@0EB@0ZR@0ob@T02@TEB@TZR@TobA902A9EBA9ZRA9obA]
02A]EBA]ZRA]obBB02BBEBBBZRBBobBf02BfEBBfZRBfobCK02CKEBCKZRCKobCo02CoEBCoZRCoodT0
04T0EDT0ZTT0odTT04TTEDTTZTTTodU904U9EDU9ZTU9odU]04U]EDU]ZTU]odVB04VBEDVBZTVBodVf
04VfEDVfZTVfodWK04WKEDWKZTWKodWo04WoEDWoZTWoofd006d0EFd0ZVd0ofdT06dTEFdTZVdTofe9
06e9EFe9ZVe9ofe]06e]EFe]ZVe]offB06fBEFfBZVfBofff06ffEFffZVffofgK06gKEFgKZVgKofgo
06goEFgoZVgooi800980EI80ZY80oi8T098TEI8TZY8Toi990999EI99ZY99oi9]099]EI9]ZY9]oi:B
09:BEI:BZY:Boi:f09:fEI:fZY:foi;K09;KEI;KZY;Koi;o09;oEI;oZY;ookH00;H0EKH0Z[H0okHT
0;HTEKHTZ[HTokI90;I9EKI9Z[I9okI]0;I]EKI]Z[I]okJB0;JBEKJBZ[JBokJf0;JfEKJfZ[JfokKK
0;KKEKKKZ[KKokKo0;KoEKKoZ[Koom/00=/0EM/0Z]/0om/T0=/TEM/TZ]/Tom]90=]9EM]9Z]]9om]]
0=]]EM]]Z]]]om^B0=^BEM^BZ]^Bom^f0=^fEM^fZ]^fom_K0=_KEM_KZ]_Kom_o0=_oEM_oZ]_oool0
0?l0EOl0Z_l0oolT0?lTEOlTZ_lToom90?m9EOm9Z_m9oom]0?m]EOm]Z_m]oonB0?nBEOnBZ_nBoonf
0?nfEOnfZ_nfoooK0?oKEOoKZ_oKoooo0?ooEOooZ_oooooj=_X000[X00?/j>P04^P01NcXj>S/04cX
00?/b>P00nP2b0?X00C8j>S/0/P2j0C800?Xb>P00^`00nS8j002k13800?Xb<P00lP00nS8b002b0KX
3lP00lC8b002b003a<S800;800?4b<P00lP00nc8b00Ob003Z<S800?800>Xb:P00jP01<RXb<P2Z004
SJRXZ0:=0ZP5S@04Z8f=Z0B=0XP00hAYS@02SAAY001Qj003b>CX00KX0/P9j003i<CX00SX00?8j<P0
0^P00lSXj004b0?X0lP2j0;800?Xb<P01LP2j0;800?4b<P00/P01nS4b<C8i>P00lP00nC8b002b007
a<S8b<C8a007b0;400?8a<@00/@3b003a<S800;800K4b<S4b<@2b0?41lP00lC8b004b003a<S800;8
00?4b<P00ZP5b0:X00BTZ:RX0/P01:S8Y<P3Z004Y:RXb0>X00>8SJP00ZP018RXZ8P2Q005Z8BXJHP0
0X@03fR8J6QTJFAYI6V=JFA4I003J@009NP00nCXj00Qj003b>SX00KX00?Tj>P01nP00nCXj008j005
b>SXa<P00^P00nC8j003j0C800?Tb>P00nP01<SXj>P2b0;X00G8j<S8j002b003j<S800?800?Xb<P0
0/P01<C8b>P4b003j<S400?800WXb<C8a>S8a<P00/@4b004a<S8b0G41LP2a004b<C4a0;800?4b<P0
0/P00lC8b003b003a<S800;800>Tb<P00/P01<C8b<@4b003a<S800O800?4b<P01<P01<C8Y:P6b0:T
1jP00lRXZ007Z004R:RXR0:X00>4R8P00X@2R009SHB4JHQXI6QT009X0V@016UXJD@1I000?^P00nCX
j006j003i>SX00GX00CTj>CT0^P01nCXj>STj>@02NP00lSXj002j0;81NP00lSXj002j003a<SX00;X
00K4j>cXb<@3b004j<SXk0?80^P2b0;X0lP01>S8b<@2b005j<S4b<@00lP01>S8b<@2b0?400KXb<S4
b>P2b004a<STb0?40/P00lC8b002b004a<S8b0;40lP01<C8b<P2a0?80/@3b0;40lP2a004b<C4b0;4
0/P2a0;80/@2b0;400C8a<S41<P00lC8a002b003Z<S800;800JXb:RTZ<P2Z003Y:RX00:X00>TZ:P0
1jP02:BXZ8BTQ8R<0X@3R003J8B800:80V@00hQYJ@02I05X0F@001kX00?Tj>P03>P00nCXj007j003
i>SX00;X00CTj>SX0^@3j003i>SX00;T0nP00nCXi007j0;T0nP2i0?X00?Tj>P00^P01NC4j<S400;8
00?Xb>@00nP00lS4j002j004b<CXk0;X00C8j<S40/P2j003b<C800C800CTb<ST1/P01lC8b>S8a<P0
0/@01<STa<@2j003b<C800;400?8a>P00/P2a0?80/@3b0?400?8a<@02/@00lS4a002a0;80/@00nS4
b007a0;80l@00lS4b002a003b<C400C800?4b<P00l@00lRTb003b003Z<C400;400FTb<C4b002Y003
b:BT00>T0ZP01JBXZ:BX00:T00>XY:P00jP3Y006Z8R4Y8B80X@01:B4R8d3Q0:80V@00fUTJ001I000
7^P00nCXj007j004i>SXj0?T00?Xi>P02>P2i0?X0^@01>STi>@3j0;T00KXi>SXi>P4i0?X00OTj>SX
i>S400KX0n@01^S8b<S4b0C400C8a<C40/P00nC8i002j004i>SXa0;X00C8j<S41<P00nC8b006b006
j<C4b<C81L@2b0;400G8a<S4b00:a003b<C400;400?8a<@01/@00lS4a007a003b<C400;400?8a<@0
0/@01/S4a<S4b0C400K8a<C8a>`4a003b<C400;800?Xa<P01<@4b008a<S4a:C8a<P2a0?800^Tb<S8
a:S4Z<S4Y003a008Y:RTY:RTZ:@2Z003Y:RT00:T0ZP02ZB4Z8B8Y8B8Q8`3Q004I8R4J05T00001<SX
j>@<j0;T0nP2i0?X0^@4j0;T0nP00nCXj002j0;T00?Xi>P00^@2j0?T0^P00nCXi002j0?T00KXi>CX
a>P2i005a>CXi>P00^@01>STj>P3i0?X00WTa>CXi<CTb>P00^@00lCTi007a0;800C4b<C40/P2a008
b>C4b>S8j<@4b004a<S8b0;400CXb>S40/P01LC8b<S400?800?4b<@00l@01LS4a<C800?400?8a<@0
1l@00lS4a00Ia004b<C4a0?800C4b<C84L@2b0?400?8a<@00/@2b003a<S800;800?4b<@02<@00lS4
Y002a005b<C4b<@00/P02JC4Z<RXY<RTb005Z0:T00BXY:RT0ZP02:B8Z:RTI8B80X@016B4R8@1I000
6NP2i0KX00CTj>CT2>P00nCXj002i003j>CX00CT00?Xi>P00nP2i003a>CT00;T00c8j<STa<SXa>C4
b>P2a003i>SX00;T0^P02LSXi>S8j<S4j003a003b>C800;40/P3a0;80/@01>S8b<@2b0?41<P00lC8
b004b0;X0/@00lSXb002b004a<S4a0;80/@2b0C40/P3a003b<C400;40/P7a003b<C4017400C8a<C8
0/@00jC8b003a003b<C400;40/P;a003b<C400;40/P4a003b:C400?800?4Y<@00/@00jC4a004a005
b<C4a:@00/P2a004b:RTa0;80ZP2b003Y<RT00;80jP00jBXZ003Y0JX0X@2Z003R8B400:40HP1I064
0003j003i>ST00gX00?Tj>P02nP00nCXj003j004i>SXj0;40^P00lCXj002j0?T0nP00nCXj002i009
j>CXi<CTj<S400;T0/P01^CXj>S8i0?X00CTa<SX0^@01<SXj>P3i005b>S8j<@00n@01^S4a<CTj0;4
00?8a<P00l@3b005a<SXb<@01LP00nS8b002b004a<S8b0;40/P01LC8a<C800?40/P01<C8a<P7a003
b<C400;400?8a<@01<@01<S4b<P4a006b<C4b<BT2l@00lRTa00=a004b<C4b0C40/P3a0?81/@5b0C4
00S8a:C4b<C8Z0;40lP2a007Y<C8a<S4b002a0;800?4b:@00/P2a0:T00BXY:BT0ZP2Y0:X00NTZ:R8
Z:BX00:400>XQ8@00H@000CX00?Tj>@02NP00nCXb002j003a>CX00OX0n@2j0;T0nP00nCXj007j003
i>S800;X0^@3j0;T00GXi>CXb002i006a>C4b<CT0/P2j006a<SXa>C40/P01^CXi>C8j0;T00?Xi>@0
0^@01NS4a>ST00;X00O4b<CXa>C800;400OXa<S4j<CT00;X00GTa>S8j002a0;80/@3b003i<C800;8
0/@00lS4a003a0;81L@00nS8a002a006b<C4b<C81<@00lS4a002a0;82<@00lS4Y002a003b<C400G4
00?8a<@05L@00lS4a004a0C80l@2b004a<S4b0;400C8a<S80/@2b0;400G8a<C4Y002b0?400C8a<C4
0lP00lC8b002b0;40/P00lBTY002b0BT00>XY:P00jP00jB4Z002Z003Y:RX006400000lSXb003b0?X
0lP00lC8j005j005i<S8j>@01>P01>CXj<@3j005i>SXj>@00nP2i0?X00CTa>SX0n@01>S4i>@4j007
b>SXj<CXb002j006i<CXb>C40nP01nC4j>STa>@00^P2i003j<SX00GX00KTb>SXb>@2a0;X0/P02>CX
b<CXa>S40^P2i004a>SXj0?800?Xb<@00lP2a004b>S8a0C80l@01LS4a<C800;40/P01>S8a<@2b0O4
0lP2a0;82/@00lS4a00?a004b<C4b0;400>Tb<P02L@00lS4a005a004b<C4a0?80/@2b0:T00?4b<P0
0/P01<C8b<P2a0;80l@2b0?400C8Y:C40lP01LC8b<S400?800?4b<P00/P01JC4b:S400:T00G8Z:RX
Y003Z004Q:RXZ0:T0002b004a<SXb0?X1LP01nS8i<CXa<P01>P01>CXj<P3j0;T0nP3i005j>CTj>@0
0^P01NC4j<S400;T0^P00nC4j003j00:i>S4b>S4i>S4b0?X00GTb>CTj003i0?X00?Tj>P00^P00nCX
i002i0;X00CTa<CT0^P01NCXj>ST00?X0/P01LCXa>ST00;X00?Tj>P01>P00lSTj002b0;X0lP00nS8
b003a0;80/@2b0;40/P4a0;80/@00nS8a002a004b<C4a0?81l@2b1G400?8a<@00/@00lS4a002a003
b<C400O400?8a<@01l@00lS4b002b0;400O8a<C8a<S400;800G4b<C8a002b003a<S400;800G4b<C4
b002a0C800?4b<P00/P00lC8b006b004a<S4b0;400>XY:P00Z@00jRTZ002Y0>X0Z@1Z0001<P01NS8
b<SX00?800KXb<S8a>P2b0?400CXa<BX0nP00lSTj003j003i>ST00;X0^@01^S8j>C4b0;400CTj>CX
0^@4j0GT0^P01LCTa>C800;T0^P02>C8i>STj<CT0nP00nCXj002j003i>SX00;X00?Ta>P00^@01^ST
b>STa0GX00O4i<CTb<CX00;T1>P01NC4b>S400?800?Xa>@00/P01<CXj<P4a003b<C400;400C8a<C8
0/@3b005j<C4a<P00l@2b1;400C8a<BT1L@01JC4a<C800S40/P3a003b<C400;400FTa<C4Y002a004
b<C4Y0;400?8a<@00l@2b0C40/P00lC8a006a0?800C4b<C81<@2b0;43<P00lC8a003a00;b:C4Y<BT
a<S4Y<P00ZP2Y0:X0J@000;800?4b<P02<P00nS8b002b00:j<C4j<CXa>C8a0CX00?8j>P00^P00nCX
j002j008b>STj<S4j>@3j003i>ST00;X0^@01>STj>@4j0;T0^P3i0;X00KTa>SXi>P2i0KX0n@3j003
i>SX00KX00G4i>SXi002j003i>ST00?X0^@:j005b>SXb>@00/P2j005a>SXi<@00^P2i004b<C4a0;8
1<@01/S4j>S4b0C400?8a<P00/@01<S4a<@2b0K40Z@3a003b<C400O400G8a<C4Y004a0;81<@00lS4
a006a003Y<C400G400?8a<P00/@4b003a<S400?40lP2a0?800G4b<C8a003b0C400?8a<@03<P2a0;8
0/@3b003a:C800;80/@3b006a:BXb:RT0L@000;800?4b<P02<P00lC8a002b0?400G8a<C8j002i0;X
00?Tj<P02NP01NCXj>ST00[X00?Tj>P00^P01>CXj>@6j0OT1>P01^CXj>CXi0CX0^@3j0;T0^P2i0;X
0^@2j004i>SXi0GX00?Tj>@03NP00nC4j002j005a>SXj>@01nP3a0;80/@01NS8b>S400;80/@3b0;4
00?Ta<P00/@3b003i<S400W400?8a<@03<@00lS4a002b0C40/P<a009b<C8a<S4b>S400;80/@00lS4
a005a007b<C8b<C8j006b0;41/P00lC8b002b003i>S400?800?Xa<P00/P7a0;800?4b<P00/P3a078
0L@1a0000/P00lC8b00:b006a<S4a<S40/P2a003j<SX00OX00GTj>SXi002j003i>SX00;X00?Tj>@0
0^P00nCXj003j003i>ST00;X00?Tj>@00^P00nCXj004j0CT00CXi>ST1>P00nCXj002j003i>SX00?T
00?Xi>@01NP01NCXj>ST00?X0^@4j003i>SX00;T1>P01NCXj>ST00?X0^@00nS8j007j003i<SX00C4
00KTa<SXb>@2a003b<CT00?400G8a<C4b005a004b<C8b0_400?8a<@00l@00lS4a002a003b<C400?8
0l@2b0?40/P2a003b<C400?400K8a<C8a<P2a003b<C400;40/P01<C8b<P3a005b>S4i<@00/P2a0C8
0/@2j0C800[Xb<S8a>S4b>S81>P6b0;400C8j<C40/P2a0?80l@000;80/@4b003a<S800?40/P3a00:
b<C4b<C8a>CXi0;X00?Tj>@00nP2i0?X0^@3j005i>SXj>@02NP01NCXj>ST00CX00GTj>STj003i0OX
00?Tj>P01NP3i003j>CX00CX0^@2j003i>ST00CX00?Tj>P00^@4j005i>SXj>@02>P00nCXj003j005
i>SXj>@00nP00lCXj002i003a>CT00;T00G4j>SXi002a005j<C4a>P01L@00lS4j002b17400?8a<@0
1/@00lS4a002a0;81<@01<S4a<P5a005b<C4a<P01<@00lS4a002a0;800C4b<S80/@01<S4b<P3a003
b<C400C800?4b<@00/P00nS8a003a0;800C4j>SX0lP00nCXi002b003a<S400;80/@00nC8b005a004
b<C4a07800001<C8b<@3b003a<S800?81L@3b0;40/P2a0CX00CTj>SX0^@3j005i>SXi>P00n@7j003
i>SX00;X00?Tj>P01^P00nCXj007j003i>ST00;X00CTj>ST1NP01nCXj>STj>@01nP01NCXj>ST00GX
00CTj>SX0^@2j005i>SXj>@01NP00nCXj008j0;T00?Xi>P00^P02NCXj>STb>C8a002i0;X00?Ta<@0
0/@01>S4i<P3a003i>S8013400G8a<C4i00:a003b<C400;400?8a<@00/@00lS4a007a009b<C4j<S4
b<C800;40lP01LC8b<C800?40/P01<CTb<P2a006j<S8b<CX0lP01NS4a<SX00;80^P00nCXb005j003
b>C400;800C4i>C80/@01<STj<P3i0;80L@00003b<C800W82<@3b0?40^P01LC8j>CX00;T2NP5i0GX
00?Tj>P00^@Aj005i>SXi>P00^@00nSTi002i0;X0n@2j0?T0^P01NCXj>ST00CX0^@3j004i>SXi1SX
00?Tj>P01>P00nCXj004j004i>SXi0GX0^@03/S4a<CTb>C4i<C8a>C40/P4a003b<C401C400?8a<@0
2L@2b0K40/P4a003b<C800C40/P3a003b<C400;400?8a<@00/P2j003a<SX00?80^P2i005j<S4j<@0
0/P01NSTj>S800;X00GTb>SXa002j003b<C400;X0^@2b005j>CXj<P00^P1a07T0005a004Z<C8a0;8
1/@00lS4a002b0G400CTa<CX0^@5j003i>S800;T0nP2i0?X00?Tj>P00nP00nCXj002j004i>SXj0;T
0nP00nCXj002i003j>CX00?T00?Xi>@01>P00nCXi002j0;T00?Xi>P00^@2j003i>ST00CX00?Tj>@0
1>P00nCXj00Dj003i>SX00gX00CTj>CT1>P00nC8a002a007i<S4j>C4b003i003a<S400;T00?4b<@0
0l@00nC4i002a003b<CT00;400?Ta<@01L@00lS4a002a003b<C401C400?8j<@00/P5a004b<C4a0;8
1<@02>S8b<S4j<S40/P00nS4i003j0;40^P00nCXj002j0;80nP00nCXj002i004a<SXj0;T0nP00nCX
j002j0;T0^P00004Y<C4b0C400?8a<@00/@2b0?400K8a<S8a<P2a003b>SX00;400G8j>SXi003j003
i>SX00OX00?Tj>P00^P01NCXj>ST00GX00GTj>SXi003j0;T00?Xi>P01>P00nCXi004j003i>ST00?T
0nP01>CXi>P2i0GX00GTj>CXi002j0;T0nP00nCXj00@j0;T3>P00nCXj002j0;T0^P4i0;40/P2i003
a>SX00;T00G4i>CTa002i006a>C4i>S80/@00nCXa007a003i<C400;400OTb<CTj<C800;400C8a<C4
0/P9a003b<C400?40lP3a0;80l@2b0;400?8a<P00/@3b0;41<P01>CXb<P2j0;800?4b>P01nP01LSX
i>ST00;X00C8j>C41>P00nCXj002i0?X0N@1j00000>Ta:@00l@00lS4a002Y0;40lP6a0K800?Xa<@0
1>P00lSTi004j003i>SX00;T00C8j<ST0^P01>CXj>@4j004i>SXj0?T1NP00lCXi002j0;T1^P00nCX
j002i005j>CTj>@00^P2i0;X0^@00nSTi006j004i>STi0GX00?Tj>P01nP00nC8j005j0;T0nP00nCX
a004j007i>STi>STj002i003b>CT00;400?8i<@00^@01>STi>@2j006i<C4a<SX0l@01>S4i<@2i0S4
00?Ta<@01l@00nC4b002b0;400?8a<@00/@2b0G400CXa<C81<@01^S8a<S4b0;400K8a>S8a<P2a004
b<C8a0C800?Tj<@01lP2a003b<CX00KX00?8j>P01>P00nC4j008j003i>SX00;X00?Tj>P00NP000FT
00?8Z<@01<P2a0;800?4b<P00lP01LC8a<S400?800?Xb>P03NP01nC4j>C4i>P00^@3j0?T00?Xi>@0
0n@00nSTj002j003i>SX00?X00?Tj>P00^@3j0;T1>P2i004j>CTi0;X00?Tj>P00nP01NCXj>ST00CX
00?Tj>P04>P00lCXj00:j003i>SX00;X00CTj<ST1>P01NCXi>S800;X00?4i>@00n@01nS8i>S4b>@0
0/@2i006b<C4a>C85/@00nC4a002b005a>C4a>P00/@00lSXa002a0?80l@00lS4b003b0?400?8a<@0
0/@2b008a<S8a<S4b>P2b0;400CXb<S41/P00lC8b002j003b>SX00OX0^@2b0;T2>P00nCXj004j000
0jP02:BXa<S4Z<S40/P2a003b<C400;40lP2a003b<C400?400CTb<CT0nP01NC4j>ST00CX00STa>C8
j>CXi0;X00?4i<@00nP7i003j>CX00?X0^@3j003i>SX00?T0nP2i003j>CT00CX0^@3j0;T0^P00nCX
j002j0;T0nP00nCXj00;j003i>SX00GX00?Tj>@01>P01>CXj>P2i0?X00?Tj>P00n@00nSTi003i003
a>CT00;T0/@01^C4i<CTa0;X00G4i>C8a002i003j<C800;400?8a<@00/@01^C4a>C4b0C400C8a<C4
0/P2a003b<C400;40/P8a0;80/@00lS4a006a004b<C8a0?800?4b<P00lP00nS4b003b003a<S800G8
0^@2b004i>SXb0KX0^@00nS8i003j0;T0^P3i0CX0N@1j07X00001ZRTY:C8Z0;80Z@2b003Y<C400S4
0/P00lC8a002b0?400OXb<SXi>S800;X00C4j<ST0/@00nS8a002i0;X0^@01/CXj>CXi0;X00?4i>@0
0^@01>STi>P2i0SX1N@8j003i>SX00;X0^@3j003i>SX00;X00GTj>SXi00Gj0;T0^P2i0GX00CTj>CT
0nP2i0CX0/@00lS4i004i003a>ST00G40^@00nSTa007a004b>C4i0K400?8a<@00^@01/S4a<CTb0K4
00CTa<C80/@01LS4a<C800G400C8a<C40/P7a0;800C4b<C81<@00nS8a002a0K800G4b<C4b003j003
i>SX00;X00?Tj>@00^P00lCXi003j003i>SX00GX0n@4j00000BXY:BT1<@01/RTa<S4b0?40/P3a005
b<C8a<P01L@01/SXi>CXa0;X00G4j<SXa002j005a>S4a<P01>@2j0?T00?Xi>@01N@3j0;T0nP7i0;X
0^@00nSTj002i004j>CTi0;X0n@2j003i>SX00CX00?Tj>P00n@7j003i>SX00;X00GTj>SXi004j0;T
1nP2i0?X00CTj>SX0^@01/SXj>CXb0G40^@;a003i<C400G40/P4a003b<C400O400?8a<@00/@00lS4
a002a003b<C400O400C8a<C82/@01^C4a<S4b0G40lP3a004b>S4a0C80/@2b0;40lP00nS8b002j003
i>SX00?X00CTj>C40nP00lSTi003j005i>SXj>@01>P1i07X0006Y004a:BTY0?400>Ta<P00/@5b004
a<S8b0C400G8i<C8a004j003b>ST00CX1<@01>STa>P3i005j>CTi<@00^P2i0?X0^@00lSXi003i0;X
0n@00nSTi002j0GT00GXi>STj002i0?X0^@01>STj>@2j0?T0^P00nCXi002j003i>SX00gX00?Tj>P0
1^P3i0;X00?Tj>P00n@2j003i<CT00;X0/@2j009a>CXi>S8a>CX00C40^P;a003j<C801340/P8a003
b<C400[400G8a<S4b005a0;80/@3b0;41<P01<C8a<P2a0O800?4j>P00/P00nS8i002j004a>SXb0;4
00GXi>STa003j0;T00C8i>ST1nP000NT00>XY:@00Z@3a003Y<C400;40Z@01<C8b<@4b0;40lP3a005
b>S8i<@00^P02NC4b>C8a>CXb003i0;X0n@3j004i>SXj0;T00CXi>CT1>P7i004j>CTi0;X00?4j>P0
0^P3i003j>CT00;X00?Tj>P00nP01>CXj>P2i0?X00?Tj>P04NP01^CXj>STa0;X0^@2j003b>SX00;X
1^@00lCTi002i003a>ST00?T00KXi<C4i<P2a003i<C400;400?Ta<@02l@00nC4a007a003j<C400_4
00?Tj<P00/@00lS4a002a004b<C4a0;81<@00lS4a002a003b<C400?80/@3b003a<S400;80/@6b0;X
0/P01^CXb>S8j0;40lP2i0;X00S4j<C8j<C8i0OX0N@00003Z:BT00NT00C4Y<C42J@7a004b<C8a0;8
0l@2b0;400?Tb<P00/@00nC4a005j004i>STj0;T00O4j>SXi>ST00GX00?Tb>P00nP01>CXj>P2i0?X
0^@01>STj>@4j0;T0^P00nCXj002j003i>ST00;X00?Tb>P00^P00nCXi002i0kX00C8j>ST1>P00nCX
j002j003i<CX00?T0^P01LSTi<CX00;T00S4i>STa>CXa0;T00K8j>CTa>P6i004a>C4j0W400?Ta<@0
0/@01nSTa<CTa>@01L@00nC8a009a004b<C4a0;800?4i<@00/@00lS4a004b0;40lP00lC8b003b0;4
0lP01<C8j<P3a0;800K4i>SXa<P2j003b<C800;X00KTa<CXa>P3b006a>S4j<SX0^@7j00000>XY:@0
0Z@01ZRTY:RTZ0fT00G4Y<C4b003a0C80/@2j0;400?Tj>P00/@01<SXb<@3j003i<CX00;T0/@01NCX
j>ST00SX00GTj>SXi004j004i>SXj0;T00GXi>CXi002j003i>SX00;X0n@2j0;T1nP00nCXj003j005
i>SXj>@03NP00lCXj006j0;T1>P00nCXi003i003j>CT00OT00S8i<CXi>S4i0?X1>@02>S4i>S4b<CX
0l@00nSTa004a005b<C4a>@00/@2i006j<C4i>S80l@00nC4a003a003b<C400C400?8a<@00l@01>C4
b<@2b004a<S8b0?40/P2a0;X0/P00lC8a002a0;800?4b<@00/P02NC8b<C8j>CXi002j004a>CXb0C4
00O8i>C4i>S800;X00?4j>P00^P1i07X0NP00003Z:BT00BT0ZP@Y0C400C8a<C40/P2a008i<S4a>S8
a>P2a005b<CXa>P00^@3j0;T0nP2i004j>CTi0OX0^@01^STj>STj0;T00?Xi>@00nP00nCXj002j003
i>SX00GX0^@4j004i>SXj0;T1nP2i0_X00?8i>P00^@00nSTj003j003i>ST00;X00?Tj>@00^P6i004
j<CTi0;X00?4i>@00^P4i006b>CTi<CX0n@2a003i>S400;400?Tj<P03/@01/S4a<CXb0[400?Ta<@0
2/@01LS4a<C800;40/P2a0;81<@2j003i<S800?400?8a<P00/@3b0;X00_8a<SXi<SXi>STb002i0;4
00?Xa<@00/@01<STi<P2j003i>SX00;X0N@1j07X00000jBXY006Y003Z:BT00:T00>XY:@01j@00jRT
b002a0;80l@2b0?40/P01LCTi>S800;X00?Tj<@00n@6j003i>SX00;X00CTj>SX0^@7j0?T0nP01>CX
j>P3i0;X00CTj>ST0^P00nCXj005j0;T0nP01NCXj>ST00CX00?Tj>@00^P00nCXj003j006i>SXj>C4
0^P3i0KX0^@00nSTj005i0?X0^@00lCTj003i003a>ST00;T00OXa>C4i<CT00;40^@2j003i<CT00;4
00?Tj>P00/@00nC4a008a003i<C400G400?8a<@00/@00lSTa007a003b<CT00;400?8a<@01/@01lST
i<C8a<P01<@01^C4a<STb0;400?8a<@00/P02>S8j<S4i>S40^P01/STb<SXi0;40^P3b003j<CX00;8
00?Xi>@02>P00005Z:B4Y8@02:@2Z0:T0ZP4Y004Z:BTa0;81<@00lS4a002a008b>S4a>C8j<@4j0;T
0^P00nCXj002j003i>SX00CX0^@2j0;T00?Xi>P01^P3i0;X0n@00nSTj005j003i>SX00GX0n@2j003
i>SX00;X0^@6j0?T1>P00nCXj002j003i>S800;T00C4b>SX0/P7j003i>SX00CT0^P02<CTj<CTa>CX
0n@01>STi<@2i003j>CT00?T0l@01NC4a<C800?400?Ta>@00/@00lSTa002a0;X00G8a<CTb002a005
b>S8i<@00^@00nS4a004a003b<C400?400?Xi<@00/@01<S4a<@2b0;40lP00lC8b002b003i<SX00;8
0/@2b0?X0lP00nS4b003j008a>CXb>STj<@3j0;400K8j<C4i>P2b004i>SXj0;T0nP2i00000>4Y:P0
0j@00hBXY00<Y004Z:BTY0?400?8a<P01/@01/S4a<SXa0?X00CTa>C42>P00nCXj003j003i>ST00GX
00?Tj>P00^P00nCXj003i0gX00?Tj>P01^P01NCXj>ST00CX0n@00nSTj003j0;T0nP01>CXj>P2i003
j>CX00;T00GXa<CXi002j003b>CX00;X00G8j>SXa002i003j>CT00CT00C4i>SX1>@00lCTi002i005
a>CXi>P00n@00lCTa002i005a>C4b>@02L@01^S4a>S4j0?40/P2a007i<C4a>C8j004a003b<CT00;4
00?8a>P02L@02<SXb<CTb<C80/@2b005a>C4b>P00/@01NS8j<CX00;80^P01>C4b>@2j003a>ST00;X
00CTj>C80^P00lCXb002a003i>S800SX0/P00003Y8BT00>T00>4Y8@01:@00jRTZ002Y003Z:BT00>T
00G8a:C4b004a0;80/@01/SXi>C4i0?X0^@2j003i>SX00;T1^P00nCXj003i0;X0^@4j005i>SXj>@0
0^P00nCXj002i0CX00?Tj>@00nP00nCXi006j003i>ST00?X0^@01>STi>@8j004i>STj0;T0^P00lSX
i002i0;X00GTj<C8i003j003i>SX00?X0^@01LCTj>C800?T00OXb<C4i<C800?T00?8a<@00/@00nS4
i002a003i<C400;400?Ta<@01l@00nC4a005a005b<C4a<P00/@01>STb<P4a003b<C400;400?Ta>@0
1/@00lSTi002a004b<C8j0?400C8a<CT0/@01lSXa<CXb>P00lP2j0;400SXi>SXb>S8a0;800GXi>SX
b002i0?X00?8a<@00nP2i0?X00?4j>P00^P00lSXa001j00018@01JB4Y8BX00nT0/@00lS4a002a003
b<C400;400KXi<CXb>P2i0;X0l@00nCXj002i003j>CT00;T0^P01^CXi>CXi0CX0^@3j003i>SX00KX
00?Tj>P00nP00nCXj002i0;X0n@3j003i<CT00;X0n@6j003i>SX00CT00CXa<CT0nP01<C8j>P2a0?8
0/@01/S4j>C4i0;80^@2j004i<CTi0;400GTj>C4i002j0?T00?Xa>@01/@2i1_400?8j<@01/@00nC4
a002a003b<C400;400OTb<CTb<C800;40/P3a005b<C4a>P00/P01<CTa>P2a0?X00O4j>SXb>C400?X
00?Tj>P00nP00nCXi005j0?T00KXi>SXi>P2i003j>CT00;T2^P1k0001X@00jB4Z007Y0>X1J@4a0?8
0/@2b0;40nP2i005a>SXj<@00nP00nCXj003j004i>SXa0CX00?Tj>@00^P01^CXj>S4i0?X00?Tj>P0
4NP2i0CX00CTj<CT0nP01^CXj>CXi0CX00?Tj>P00/@01^S8j>S8a0?800?Xa<@00l@01>S8a<@2j0;8
0/@01>cXb>@2j0;400KTa>CXi<@2b0?T00OXb<CTb<C801[400?8a<@00/@00lS4a006a0;800?4b<@0
1L@01LS4a<CT00G400C8a<C81<@00lS4a007a004b<C4j0;800O4i>S4b>C800;X00?8j>P00nP01NC8
j>ST00CX00CTj>SX0^@01LSXj>ST00;X00?Tj>@02>P000>400FTQ8B4Z00:Y003Z:BT00:T2L@01<S4
i<@4j003i>SX00[X00CTj>S40n@01>STj>@2j003i>ST00?X0^@3j003i>SX00;X00?Tj>P00^P00nCX
j002j003i>SX00;X00?Tj>@00^@2j0CT0nP00nCXj002i0?X00?Tj>@00^P2i003j<CX00;X00G8i>C4
j002b0;T0/P01NS4b>S800;X00C8a>SX0/@2i0;400GXa<CXi004a0;X00GTa<CXb006a003i<C401O4
00?Ta<@02<@00lS4a005a005i<CXa<P00l@2j0;400?8a>P00/@3b0;400C8i<C40/P3a003b>SX00?8
00?Xa<@00nP00nCXj002j003i>SX00KX00KTj>SXi<@3j0;T2>P01NCXj>S800;X00002:B4Z:B4Y8BX
3J@2a006Y<C4a<S40/P01^C4i<S4j0;T0nP01NCXj>ST00;X00?Ta>@00^@2j0GT0/@5i0;X0n@9j003
a>SX00GX00CTj>CX0^@2j0;T0^P2i0WX00CTj>CX0^@01NSTj>ST00?X00?Tj>P00nP00nC8b002b0;T
00O8i<C8i>ST00;X00CTa<S/1<@01LS4a<CT00;X00G4b<SXi002a0?T0/@00nC4a005a003i<CT01;4
00?8a<@02L@00lSXa008a003j<C400;400?8a>@00lP2a003b>C400;400?Xa<P00/P4a003b<C800G8
00KXa<CXa<P8j004i>SXj0;T0nP01>CXj>P2i17X0004Q003Y8B400:X0Z@00jRTZ004Y007Z<BTY<BT
b003a005b>C4b>@00nP00nCXj002j003i>SX00GX0/@00nSTi002i0;X0^@2j004a>CTi0CX00?Tj<P0
0^@3j0;T0^P3i0;X00CTj>CT0^P3i004j>CXi0;X0^@3j003i>SX00;T1>P01^CXj>S4i0SX00?Tj>P0
0^P01nC4j>STb>@00^P01nC8a<SXa>P00^`00nSTb003a004i>STi0;X00C8i>CT0/P01/CTi>C4i1W4
00?8a<@01/@3b0;40lP3a005b<C4a<P01L@00lS4a004a003b<C800?400?8a<@00/P01>S4a>@3a00:
j<SXa>C8j<S4i0;X00?8j>@01NP00nCXi00=j0;T3^P00004Q:BTQ0>T0ZP8Y0C41LP3a005j>CXj>@0
2>P00lSXj003j0?T0^P3i003b>ST00;T00CXi<CT1NP01>CXi<@2j0;T0nP01>CXj>P2i003j>CX00?T
00GXi>STa005i0;X00?Tj>P00nP00nCXj002i0?X00?Tj>P00^P00nCXj003j005b>STj>@00^P01lCT
i>STj>@00^P01LS4j<CX00;/00?Xi>P00^@2a0;T00?Xi>@00^@01>STa>@:a0;T7l@00lS4a004a003
b<C400G400K8a<C8a<P5a004b<C4b0C400?8a>@01<@3b0;X0/@2j004i<CXb0?X00?4j>P00^P01>CX
j>@=j004b>SXi0cX0007Y003Z:BT00>T0/@00jC4a006a004b<CTi0;40nP00nCXj005j004i>STi0GX
00?4i>P00^@01NSTj<CX00CT00O8j>CXi>ST00;X00?8i>@01>P01>CXj>P2i0?X00CTj>SX0^@3j0?T
00?Xi>@00^@2j0;T0^P00nCXi002i0GX00GTj>SXi003j0?T0nP2a0?X0^@2j003i<C400?X00C/b>ST
0/@2j0;T00?Xi<P00^@2j0?T00?4j>@00^@01<CTi<@2i0S400?Xi<@04<@00lS4a002a0;80/@00lS4
a003a009b<C4a<S4Y<C800W400?8a<@02/@00lSXb002a005b<C4i<P00^P2b0SX00?Tj>P03nP00nCX
j00;j0003J@2a003Y<S800?40/P2a0;800?4j>@00^P2i0CX0^@00nSTj002i0?X0^@2j0;T0nP01<CT
j>P3i0;X0n@2j0?T2>P00nCXj006j006i>SXi>ST1>P00nCXj002i005j>CTj>@01nP01^CXj>STj0;T
0^P00nCXj002j004i>SXj0;T0^P2i0CX00CTj>S80^`01>CXi>@4j005i>SXi<@00nP:i003a>C400?T
00K4i<C4i>P3i006a<S4i<CT0l@00nC4b003a003b<C400;400?Xa<@01l@01/STa<CXb0?400C8a>S4
0lP00lC8b002b0?400?8a>@00/P00nS4j002b004j>C4b0?X00?8j<P01NP2i0;X00?Tj>P07NP000RT
00C4Y:BT1L@02<S4Y<S4b<C80/@00nCXj002j005i>STj>@00^P00nCXi004j003i>SX00;T00SXi>SX
i>S8a0?T0nP2i004b>STi0;X00?Tj>P01NP01NCXj>ST00_X0^@7j005i>SXj>@02^P00nCXj003j005
i>SXj>@00nP00nC4j003j004i>SXj0?T00GXi>SEk006j0;T0^P2i003j<CX00;T00?Xa>@00^@00lC8
i002i003b>CT00;T00?8i>@00^@01nSTi>C4j>@00/@01>C4j<@2i003j<S400C400CTb<C40n@4a003
b<C400;80^P02<S4b<C8j<C80l@01<SXa<@2b0;40lP2a0;800?Xa<P00/P01NS4a<SX00;T00?8j>P0
0^P00nCXj00Qj0001J@01:RTY:@2a0:T0/@02JC4a<S4b:C4b004a003j>CT00?X0n@2j0;T0nP2i003
j<CX00;T00CXi>ST0nP00nCXj003j0;T00GXi>CTj003i0?X0^@3j003i>SX01GX00?Tj>P02NP00nCX
j003j003i>SX00KX0^@3j0;T0nP01>CXj>P2i0;X00?`k>P01NP6i004j>CXj0OT00C4i>CX0n@00nST
i002i006j>CTj>CX1>@01>S8a>P3i0;400?Ta<@01L@00nCXa003a005i<S4b>@00/@00lSXb003a0;8
0l@01LS4b<S400;800C4b<C80/@01<S4j>@2a004j<S4a0?X0^@2j003i>SX00;X00?Tj>P02nP00nCX
j00@j0780NP000NT00?4Y:@00/@00jC8a006a003b<C800C80^P00nCXi002i0OX0^@00nSTj003i0?X
00?Tj>P00^P02NCXi>STj>CXi002j004a>STi0;X0^@3j0;T1>P00nCXj00>j003i>SX00cX00CTj>ST
2^P2i0?X00GTj>SXi004j0?T0^P00ncXj003j003i>ST00;T0^P2i003j>CX00;T00?Xi>P00^@01^ST
i<CTj0CT00?Xi<@00^@00nS4a002i006j>C4a>C41n@2j0;40^@2b003a>S400?400C8a<C40nP2a0S8
00G4b>S8a003b0;40lP2a0;80/@01>S8b>P2i0;800?Tj>@00nP00nCXj00Ij003i>SX00GX0004Y006
Z:BTY<C80/@01:C8Y:@2a0;80/@3b0;40^P01lS4i>CXb>P00n@01>STi>@2j0?T1>P01>CXi>@2j004
i>STi0;X00?Tj>@00^P00lCTi002j003i>SX00OX00GTj>SXi005j003i>SX00;X00?Tj>P00n@2j003
i>SX00KX00?Tj>P01nP00nCXj006j0;T2NP01nCXj>CXk>P00^@3j0;T0nP2i0?X00CTj>CX0^@00nST
j005i0;X0/@2i005a>CTi<@00^@01>STi<@4i003j>CT00;T00G4i>CTa003i0;40138a<CTb<CTj>CX
i>STa<S40/P00lC8b002b003a>C800;800?4b<P00/P00lCXb002b003a<S400;80^@01/C8j>C4i1GX
00?Tj>P04>P000VT00BXb<BT2L@00lS4a002a0;X00C8i<SX0/@00nS8a002a0;X00STa>CXb>CXa0?X
00CTa>C40^@4j007i>SXi>STa003i0CX00?Tj>@01^P00nCXj003j003i>SX00_X00?Tj>P01nP00nCX
j00Hj004i>SXj0;T0nP00nCXj002i003j>CX00CT00CXi>CT0^P01NCXj>CX00kT00?4i>@00^@00nST
i008i003a>ST00?T00?Xi<@00/@01>S4a>@2j003a<S400;X00STa>CXb<C8a0C800G4b<S8j005b003
a<S800;80/@2b0;X0lP2j0;T1nP00nCXj00Ij003i>SX00CX000:Y004a:BTY0G400?8a<@01<@2b0;4
00?8i<@00/P00nSTi002b006j<C4i<CX1<@00lS4b002a006j<C4a>S80/@00lSTj004j0;T0nP00nCX
j004j003i>SX00gX0n@8j003i>SX00oX00?Tj>P00nP2i0SX00?Tj>P01NP01>CXi>P2i003j>CX00CX
0n@00nSTi003j0CT00?Xi>@00^@00nS4i008i0;X1N@2j0?T00KXi>CTj<P2i006j>C4i<CX1>@00nS8
a002i0;X0n@02NS8a<SXb<C8j004b0?X1/P00lC8b002a0;X00?4j>P01^P00nCXj00Sj00000FXY:BT
Z004Y007b<C4a:C4b002a003b<C400K400C8a<C81L@2b0O400>Ta<@00l@01ZC4a<BTb0;400?8a<@0
1l@01NS8a>S400?X00?Tj>P01nP00nCXj002j003i>SX00GX00?Tj>P02>P00nCXj00Cj004i>SXi0;X
00CTj>SX0^@2j0?T00CXi>S80^P00nCXb009i004j>CTa0KT00?Xi>@03>@01LCTi>S400?T0/@01>C4
a<@2i0;40n@2a007j>C4i<CXi003a003b<C400;X00?Ta<P00/P00nS4b004b004k<S8j0C800O4b<ST
b<C800;X0/P4j004i>SXi0;X00?Tj>@08^P000BT00?4Y<@00Z@00lRTa003Y003Z:C400;400>Ta<P0
1/@00lS4b00;a0>T00K4Y:BTZ<P6a0;80l@01JC8a<C800;400G8a<C4j002a0?X00?Tj>P00^P00nC8
j005j0;T1>P00nCXj00Dj0;T0nP01NCXj>ST00CX00GTj>S4j002i007j>CXj<CXa003i00;j>CTj<C8
i<C8i>P00l@2i0;41>@00nSTi009i005a>CTa>P00/@00nC8a004a003i<C400;400?Ta<@00l@00lST
a004a005i<CTa>P00/@01>CXa<P2a005i<S8a>P01<P00nS8k002b0;/1LP01nS4b<S4i>P00/P3a003
j<C400CX00?Tj>@00^P00nCXj006j003i>SX01CX0004Y003Z:BT00:T00?8Y<@01Z@01LBTY:C800C4
00>Tb<@00/@00lS4a002Y0;40Z@00lBTa004Y003a:BT00>T00?4Y<@00/P00lBTa005a003b<C400?8
00K4i<S4j>@4j004i>SXi0GX0^@2j0;T0^P4i0;X0^@3j0;T0^P00nCXj003j005i>SXj>@01>P00nCX
j002j005i>SXj<@00/P2a004b>CXj0;400?8j<P00^@00nSTa007a008j<S4i<S4i<@3i0;400CXi>ST
0^P2a004i>STi0O400KXa<C4i<P3a003j<ST00O400?8a<@00l@00lS4a002a003b<C400?44/P2a0C8
00C4b<S40/P01NCXi>ST02;X0^@4j07T000:Y003b:BT00RT00C4Z:BT0/@00jC8a002b1:T00BXY:BT
0l@01ZC4a<S4Y0;400?8a<@00/@01<S4a>@2b0;42NP01NCXb>ST00SX00?Tj>P00n@01>STj>P3i0GX
0^@3j006i>STj>cT1^P01<SXa>P2b0?400G8j<C4b002a0;T3L@01>C4b>@4a0?T00O4i>CXi>ST00?4
00?Xi>@01L@00lS4a004a003i<C400?400?Ta<@01l@00lS4a003a004b<CTa0;80l@2b004a<S8j1G8
00G4b<S8i002b004j<STi17X00CTj>SX0^@?j00000FXY:BTZ004Y003Z:BT00jT00G4Y:C4Z004Y003
Z:BT00ZT00>XY:P00j@00jS8a003Y005a<RTZ<P00/@6b008j<S4b<CTj>@4j003i>S800;X0^@01>ST
j>@4j006i>SXi>ST1>P3i0_X00?8j<P00^P4a0;80l@00lS4a002a0?800G4b<C4b008a004i<S4b0;4
0lP3a005b<C4i>P00/@2i003j>CT00?T1<@00lSTi002a003j<C400;400CXi<C80/@00nC4a00=a003
b<C400C400O8a<S8a<S400[800?Xb<P00lP2a003b>S800C800C4b>S80^P00lS4j00;j003i>SX00OX
00?Tj>P01^P00nCXj006j0001j@00jRTY008Y003Z:BT00ZT00>XY:P01:@01ZRTQ8BTZ0:T00>4Y:@0
0Z@01ZRTY:C8Z0?400>Ta<P00/@02LS4a<S4b<CTa002b0;400GTj>SXi004j004i<SXj0;T1>P2i005
j>CTj>@00^P2i0;X0^@6j003i>ST00O800GTb<C4b004a0;800?4b<@00/@3b0C400GXa<S4b003a0;8
0/@2b0W400GXa<C4j002i003a>CX00;T1L@00jCTb004a005i<S4a>@00l@00lS4a00:a003i<C400;4
00?8a<P00/@2b003a<S/00K800?4b<P00/P01nS8b<S/b<@00lP01^S8b<SXa0?800CXb>S81^P00nCX
j007j005i>SXj>@00nP00lCTi00>j00000BXY:BT0ZP5Y003Z:BT00NT00>XY:@01j@01:RTY:P4Y003
Q:BT00:400>TZ:@00Z@00jRTY002Y003Z:BT00:T00>XY<@00l@3b003j<C800;400CXb<S40nP2i0?X
00O4i>C8i>ST00CX00?Tj>P00n@01^STj>STj0?T0^P4i0;X00CTj<C80/@2b0?40lP2a003b<C400;4
00?8a<@00/P3a003b<C800?400?8a<@00/PEa0?T0l@00nS4a003a003i<C400C400G8a<C4i003b0c4
00?8a<@00/@00lS4a002a003j<C400;800?Xa<P00/P2a004b>STb0;X00C8j>SX0lP01NCXj<S400;8
00GXb<STj003b004a<SXi0?X00?8j>P02>P01>CXj>P2i0?X00CTj>S82NP000FT00>XY:@02:@4Q003
Y8B400VT00B4Y:BT0X@3Y0:41J@01JRTY<BT00;800>TZ<@00/@00jBXa002a0;80l@2b0;400STb>C4
i<CXi0;X00?4j>P01nP01^CXj>CXa0;X0^@00nSTi002j0;T00C4i<CT0/@01<S4a<@2b0?40/P2a003
b<C800?800?4b>P00l@00lS4a004a006b<C8b<C80/@3b0C400?8a<@01l@00lS4a002a003b>C400_4
00?Ta>@02l@00lS4a005a003b<C400?400K8a<C4j<P3a003b<C400;80^P01LC8i>S401KX00C8j>S4
0^P2b0;X00?8j<P03^P00ncTa003j003b>SX00;X00?Tj>P00^P1i07X00000jRTZ004Y003Z:B400:T
1H@00jB4Q005Q0>T00F4Y:BTZ002Q0>T0X@2Y003Z:BT00FT00G4Y:BXb002a007Y<C4a:C4Y004a003
b<C800C80/@3j004i>SXj0;T0nP2i004j>CXa0CX0^@02>S4a<CXi<CX0^@00lCXa002a0;80/@2b0;4
1<P01<C8b<P2a007b>S4i<C8j003a003b<C400;400G8a<C8a002b003a<S400?400?8a<@00/@2b0:T
0/@00jC4a00?a005i<C4a>@00l@01nC4a<C8a<P01<@01/S4a<S4b0;400?8a<@00/@00lS4a002a0;8
0l@2b004a>S4b0;400?8j>P06>P00lSXb002b0SX0/P2j005k<SXj>`00lP01>cXj>P2b0GX00?8i>P0
0^P000:41:@018BTY:@3Q0:T00B8Q8B80X@00hRTZ002Y004Q:B4Y0:400>TQ:P00X@4Y003Q:BX00BT
00K8Z<C8a:P4a003b<C400C400>Xb<@00/P00lC8b002a0?X00C4i>SX0/@01NCXj>ST00;X00C8i<C8
0^P2i0?X0/@01NC4a<CT00?41lP00lC8a003b0;40lP00lC8b002b0;40/P2a0?80/@2b007Y<C4a<S4
b005a003b<C400G400?8a:@01<@00lRTa005a003b<C400;400?8a<@00/@00lS4a002a003b<C400;4
00C8a<C40/P9a005b<C4a<P02<@2b004i<S4i0;X00?8j<P00^@Ij005b>SXj<@00nP01>cXj>P3b005
j<SXj>@00lP01Nc8b<SX00;80nP01<SXj<P3j0000X@01JB4Q8BT01B400>TQ:@00Z@00hBXQ006Y003
Z:BX00FT1l@01<S4a<@2b0C400?8a<@00/@01LSXj>ST00GX00?Tj<P01nP00nCXb002a005i<CXa>@0
0^P02<CXi>S8j>C40/P3a0;800C4b<C80l@2b0?40/P3a003b>S400;41/P01LC8a<C800C400G8a<C4
j00Ya003b<C400;400?8a>P00/@01<S4a<@2b17400CXb<C40nP00nCXj006j003i>SX00gX00?4j>P0
0^@4j005b>SXj<P00nP2b0;X00?4i<P01<P2k0G800?Xb>P00/P3j0002h@00fB4I002Q003R8AT00Z4
00>TQ:@00Z@2Z0RT00?8Y<@00Z@2b004a:C4b0?400>Ta<@00/@00jC8b003b0;X00CTb<CT1NP01>CX
b>P2i003j<ST00;X00?4j>P00nP2i00:a>CXj>CXa<S4i0;400?Xa<P01<@4b0;40/P2a0;800?4b<@0
0lP01LC8b>S800;400K/j<CTa<P3a0?80l@00lS4a00[a003b<C400;400G8a<C4b00>a00>b<C4a<SX
b<CTj<S4i<@7j0;T0^P00nCXj00=j003i>SX00CX00C8j>SX0lP2j0;800G4b<S8a003b0;/00?8k<P0
1/P1k07X0NP000R400>8I8@01h@00hR4Q007Q003Y8B400:40ZP3Y0:X2J@01<RTa:P2a003Z<C800C4
0/P2a0?800KTj>SXa>@3j008a>SXj<S4i>P3b0?X00?4b<@00^P00nC4j002j0?80l@00lSTa002a005
b<C4b<@00^P2a0;80/@01<SXb<@2b004j<S4i0?800S4j<S8j>C4b0?400G8j>SXb002j005b<CTj>@0
0l@00lS4a002i005b<CTi>P00l@5i1?400?Ta<@03<@00lS4a002a005b<C4a<P00l@00lS4b003j0;4
00?Ta>P00^@8j0;T3NP00nCXj008j0;81^P2b003a<S800G800OXk>c/b>c<00G80NP1k0000X@00hR4
Q002Q004R6ATI0V400>8Q8@018@3Y0:X1J@01:RTY<@3Y003a:BT00:T1l@01JC4a<C800C40/P00nST
j002j0;T00GXb<STb004a005j<S8b>@01<P02>C8a<C8a<S40^@01LC8a<CX00C400WXa<C4i<STb<@0
0^P01lS4i<C8a>@00nP2a003b>SX00;T00O4j>CXi<SX00?400?8j>@00^@2b003i>ST00;400WTa<C4
i<C8j<@00n@2a004i<CXa0?T00GXa>CTb006i003j>C400?40^@01/CTi<CXa0;T0/@00nC4a00>a003
b<C400;400O8a>STa>ST00;X00CTj<ST1>P2i1WX1LP2j0?80/@4b003a<S/00C800?/b<P01<P1j078
00002XATQ6B4R6B4I8@4I0^42j@3a0>T00G4Y:BTa002Y003Z<C400;400>Ta<@00/P5a004b>SXj0;8
00?Xi<@00l@00nC8a002a0;800C4i<C40/P2a0;80l@2b003i<C400;800_Ta<CXb>S8i>S4j002a00<
j>C8b<CXi>S8j<S40/P00nSTj005j006b>STi>S80^P01lCXj>STj<P00nP2a0;T0/@00nSTi002a004
i<C4a0?T00?4i<@00n@01nSTi>C4j<@00n@01>STi>@2a003i<C400CT00GXa>STa004i0;X0^@3a003
i>S400O400?8a<@00/@2b006j>CXa>CX0^@01<CXj>@4j0;T1>P01NCXj>ST00CX00?Tj>P02nP2b0;X
1<P00lC8a006b005k<S8b>`00/P00nc8k001k0000V@01XATQ6B4I0Z400>8Q8@00X@00jRTY007Y003
Z:BT00>T00G4Y:BTb007Y0;80/@00jC8b003a009i>SXb>S4j>C400;X00?Ta<@00/@00lS4a002b0?4
00?8a<@00lP2a003i<SX00?40^@3a0;X0/@01>CXi<@2i006a>CTi>S80/@00nSTj002a0KX00?Tb>P0
0^P00lS4j002j008a>SXi>S8a>P2i0;400OXi<CTa>S800;41>@02^STi>C4i>STa>@3j003a>CT00G4
00GTa<CTj007a0?T00?4i>@01>@00nS4a002a005i<S4a>@00^P5a005b<C4b<@00/P2i006a>CXa>C4
0nP2i0;X0n@3j003i>SX00[X00?Tj>@00^P00lSXj006j0K800O4b<S8a<SX00G800?/b<P00^`3b000
16@018QTQ6@>Q003Y8BT00JT00?8Z:@00Z@00jRTZ004Y003Z:BT00BT00C8a<S40/P2a0;800CXi>ST
0^P01LS4j<C800C400?8a>P00/P4a005j<C4b>P01L@00lSTb002j006a>CTj>CX0n@2a004i<C4i0;4
00OTj<C4b<C800?T00?Xb>@00^P01<SXi<P2a004i<C8j0;80^P3a006b>S4a>CX0/@00nC4b00:a003
j<C400G40^@;a003i<S400;400GTa<C4i002a0;T0/@01>C4a>P4a003i<C400O400?8a<P00/@00lS4
a002a0;800?4i<@00^@00lSXi002i0;X00?Tj>P00nP00nCXj003j003i>SX00cX00C8j>CX0lP00nS8
b002b003a<S800K800?4b<P01/P00nc8b001b0000f@018ATI8P2Q09T28@00hR4Y00AY003Z:BT00:T
00>XY:@00/@01ZC8a<S4b0;400?Ta<P00nP01>C8i>@4a0;80l@2b0C400K8a>C4b>P2i0?400GTj>S4
j004i003j>CT00KT00OXi>C8a>ST00;800CXa>SX0/@3j00;b>SXi>S8a>C4b<@00^P01NC4j>C800?4
00?Xa<@00^P3a004b<C4b0;40^@2a0;T00C4b>C40^@01<CTi>@8a004i<C4i0;400K8i<C4b>@2a004
j<C4i0;400O8a<CTa<ST00O400?8a<@00/@2b0?400?8a<@01<@01>CXa>@2a004j>CXi0GX00CTj>CT
2>P00nCXj00<j0;80^`?b003a<S800?80N`1b07/0004I003Q6AT00=T0X@00fB4Q005Q0BT0ZP3Y004
Z:BTZ0:T00?4Y:@01J@00jRTY002Y004a:C4b0;400CTb>SX0^@2j003i>ST00;T0l@3b0;400?8a<P0
0lP2a003b<C800;400G8a<CTa003j003b>CX00?T00?4i>P00^@01>STi<@2b004j>C4b0?X00?4j>P0
0^P01^CXj>STa0;800CXb<C40^P01/CXj<S4i0;X00[8a<C4j<CTb<CX0^@00nSTa002a006b>C4a>CX
0/@2i0C40^P01NC4a<CT00;400?8a>@00/@2i009a>C4a>CXi<C800?40^@2a003j>CT00;400CTj>S4
0^P4a0;80l@01<S4a<@2b005i<C4a>P01<@01<S4i>@5j004b>STi0;X00?Tj>P05nP01>c8b<@3b003
a<S800O800G4b<S8a001b0000V@00fQTI002I003R6B400J400BTZ8B40Z@2Z004Y:RTZ0:T00>XY:P0
1:@01:RTZ:P4Y005a:BTa:@00/@01^C4a<CTa0;T00OXi>CXi>ST00?400C8a<C81<@00lS4j002a003
b<C400;400?8a<@00lP2a0?X0n@3j00;i>SXa>C4b>C4i<@00^P02<C8b>S4i>S80^P01^CXj<S4i0?8
00?Xb>P00/P01<CXj>P2i003a<ST00G40^P2i0;400?Ta<P00/@00lS4i002i005b<C4a>P01^@01LCT
i<C800;400K8a<C4i>P3a005i>S4a>@01L@00lSTa002a007i>STi<S4b002a003b<C400O40/P3a005
b<CTi>P00l@00nS4a004i003j>CT00;X0^@01NS8j>ST00GX00?Tj>P03>P8b003Z<S800O800?/b<P0
0lP00006J6ATI8AT2h@4Y004Q:BXZ0>T0ZP3Y004Z:BTQ0JT00NXY:BTa<S400;80/@01/S4j>CXi0CX
00?8i<@01<@01LS4a<C800;41/P00nC8a003a0;80/@01<SXb<@2i0;800?4i>P00^P01>CXj>@2a007
i<C4b>C4b003a005j<S4j<P00^P02nC8j>S8a>CXb>C400;X00G8j<S4j002a003j>C800C400?Ta>@0
0/@01>C4j>P3a004i>STi0?40^@01<CTa<@2i0;400?Ta<@01<@01<STj>@3a004i<C4b0g400?8a<@0
1l@00lS4a002a003b<C800?400CTa<SX1l@2b0CT0nP2i003j>CX00;T00?Xi>P03^P2b003j<S800C8
00>Xb<@00/@=b00016@00hATQ009Q0FT00>XY:@01:@01:RTY:P2Y003Z:BT00:X0Z@00jRTY003Y004
b<C4a0;800?4b>@00^P2i0;X0n@2a003i<C400C40/P2a0C82L@02nC4i>STa>S8j<CT00KX00?8j>@0
0l@01>C4a<P2a003b>ST00;T00K8a<SXi<@2b00;i<C4i>S4i<SXb<@00^P4a005b>S4i<@00^@01/CT
i>CXi0;400?Xi<@00/@2i003a<S400C400?Ta<@00^@00nSTi002a0?T0/@00nC4j002a0;T1L@00lS4
a006a003b<C400[400>Ta<@00l@00lSXa003a0;T00C4b<C40/P00lC8j002i004b>CTi0CX00CTj>ST
4^P3b003k<S800W800>Xb<P00/P01JS8b<RX0078000018ATI8P4Q004Z8B4Y0B40j@00jRTY006Y003
Z:BT00:40ZP3Y003Z:BT00:T00?8Y:@00/@01<S4a<@2b0?40^P00lCTj002j0?T00?Xa<@00/P4a0?8
00C4b<S80l@2b0G400?Xa>@00^@01^STj<SXi0;X00?Ta<@00l@2b004i<STj0;800K4j>SXa<P4j005
a>SXj>@00/@2j004a>CTb0;X00?Ta<P00^@01>S4b<@3i003a>CX00;X00CTa>SX0n@00nS4i002i005
j<C4i>`00l@2i0;X0/@2j0GT00G4i<C4b005a003j<C800O400CTb<C82<@01<S4b<P4a004b<C4a0;8
1<@00lS4a002a003j>CT00;400?8i>@00nP2i0CX00?Tj>P00^@=j0;800>Xb<P04lP00003Q6B400N4
00>TQ:@00X@00jB4Y002Y003Z:BT00FT00>XQ:@01j@00lBTY002Z005Y<BTb:@00/@2b0;400CTa<SX
0^@2j0;T1>P2i0S400?8a<P00/@3b009j<C4a<STa>S400?T0^P2i0;X00CTj>C40^@3a007i>STj<CX
i003j0;T0^P00nC8j003j003i>SX00KX0^@2j0?T00?Xi<@00^@00lCTi006i005a<STi>P02>@2j0;T
00?4b<P00^@02>STa>STj>CX1>@01<CTi<@2b0;T00?4i<P00/@01NC4a>C400;800?Xb<@01/@00lS4
b004a003b<C400;400?8a<@00/@00lS4a003b0;T0/@01NSTi>ST00;X00GTj>SXi004j0;T3^P00lSX
j00?b003Z<S800?80007Q003Y8B400N400FTQ:BTQ004Y004Q:B4Y0:40j@00jRTY002Y003Z:BT00BT
1<@01<S4a<P4a0;X0^@3j006i<CTi<C80Z@01<S4a<P3a0C800?4b<@00/P00lC8a002a003i>SX00;T
00C4j>SX0^@01^STa<CTj0;T00?Xa>P00^@3j006i>SXa>ST1>P01^CXj>CXi0CX00?Tj>P02N@00lCT
i008i007j>CXi<CTj004i005j>CTi>P01^@2a003i>ST00?T00CXa<CX0^@2a003j>C400;400?8i>@0
0/@2j004i<CTb0O400?8a<P00l@01LS4a<C800?400?8a<@00l@01<S4a>@2b0;400C8j>ST1>P2i0?X
00?Tj>P00^@>j003a>SX00;800?4b<P00/P00lC8b006b0:X0/P000>400Z8Y8B4Y8RTQ:B41j@2Q003
Y:RT00:400BTZ:B40j@00jRTY006Y004a:BTY0;80l@01<SXa<@2j003b>CT00;X0n@3j0;800C4b<C4
0/P2a0?80/@3b0;40/P00nC4i002j003a<SX00;X0n@2j004i<CTb0?T0^P00nCXj003j003i>SX00CX
00?Tj>@01>P00lSXj003j005a>STa>@00^P2i0;X1>@00lCTa006i003j>CT00;T00?Xi>@01^@00nST
i002i004j>CTa0;T00G4i>CTj004i003a>CT00;T00C4i<CX0/@01NC4j>ST00;X00G4b<C4j003a0;8
1L@01lS4a<C8a<P01<@2b0?400?Tb<@01/@3j0;T00?Xi>P00^@3j0?T0^P00nCXj002j004i>SXj0;T
0^P00nCXb002b003a<S800?800?4b:P01<P1Z0780LP000Z40Z@00hBTZ003Y004Z8B4Y0:45Z@01<BT
a:@4a003j>CT00;T0nP01>CXj>P2i005j>C8a>P00lP3a003b<C400;80l@3b0;40nP01/CTj<CXa0?X
00?Tj>@00^P2i003j>CX00;T0^P4i003j>CX00CX00?Tj>P02^P01>CXj>P2i003j>CT00?T00GXi<CT
j002i004a>SXa0;T00CXb<CT0^P4i004j>CTi0;X0n@2j0;T00?Xi>@00^P3i003a>S400CT0/P01NS4
a<C800;T00?Xa>@00^@00lS4a002a003b<C400;400?8a<@00/@01LS4j<C800[400CXa<BT0l@01<ST
j>@3j0;T1>P01>CXj>P2i0OX0^@3j009i<SXj>C4b<CX00g800000hB8Q005Q0:T00>4Y8@00Z@018BT
Y:@2Q004Y8BTZ0>40Z@01HBTY:BX00BT00>XY:@01J@00lBTa002a008b<CXj>CXi<@2j0;T00?Xi>@0
0^P2i004j<S8a0;800BXa<C40/P2a0?80l@01>S4i>@3j003i>SX00?X00?Tj>P01>@01>STj>P4i003
j>CX00gX00?Tj>P02>P00nC4j002i003j>CT00;T00?Xi>@00^@01>STi<@2j0_T00?Xi>P01n@00nST
j002i003j>CX00;T00C8j>CT0/@2i0S400KTa>CTb>@2a003b<C400;40/P3a003b>S400;T00CXi<S8
1<@02lS4a<S4j<CXa<ST00OX00?Tj>P00nP00nCXj002j003i>SX00?X0^@3j003i>SX00?X00C8j<S4
3/P000F400BTQ8B41j@3Q0>T0X@3Y003Q:BT00>T00>XY:@01:@00jRTY005Y003b<C400;40/P2a0?T
00?Xi>P00^@3j005i>SXi>P00/@00lS4a002a006b<C4b<C81<@01/STa>C4j0;T00CXi>C40nP01nC4
a>CXa>@00nP01NCXj>CX00;T0^P00nCXj002j005i>SXj>@01>P2i0?X1^@00nSTj007i003j>CT00;T
00?Xi>@01n@00nSTi004i003a>CT01;T00CXa<C40^P2a003i>ST00;40^P2a003i<S800S400C8a<C4
1>@00lCTa003a0;81<@01LSXb<S400;T00KXi>SXb>@Gj003k<CX00;X00?8j<@00lP00nS4b003b004
a<S8b0;400000jR4Q002Q0JT00>4Y:@02H@00jBXY002Q1>T00C4b<C80/@2b006a>STj<ST1>P2i0;X
00?Tj>@00^P01<CXb<@2b006a<S4b<C81<@01/S4a>CXa0;80^@3j005i>SXi<@00n@01nSTi<STj>@0
0nP01NCXi>S400WX0^@3j0;T00OXi>STj>CX00OT0^P3i0;X0^@3j0?T0^P2i0;X00CTj>SX2N@01>ST
i>P9i003a>CT00KT00K4b>CTb>P5a005b>CTa<P00l@2j003a>C400;400CTa<CT1l@00lS4b002a006
b<C8j<C81>P00ncXj003j003b>SX01CX00?4j<P00/P00nS8b008b0000X@4Y003Q:BT00>T0X@00jB4
Q007Q0:T00>4Y:@00Z@00hBTZ002Y003Z:BT00BT00BXY:BT1<@2b0?400C8i>ST0^P4i0?X00?Tj>P0
0^P01NCXj<C800K400C8a<C40/P00lC8a002b003j<S800;400?Tj>@00^P00nCXi004i004j>CTi0;X
0^@3j004i>SXj0?T0^P00nCXi002j003i>SX00;X0^@01>STi>@2j0ST0^P3i003j>CT00OT00CXi>C4
0^P2i0;X1>@00nSTi005i004b>CTa0GT00?4j>@00n@00nSTa002a0;T00?4i<P00^P00lCXj004a005
j>CTb>@01L@01<S4a<P3a0?80/@01<S4j<P6j0;/1NP00lSXj007j003i>SX00OX00?Tj>P00/P01LC8
a<S400[80004Y005Z:BTY8@00j@:Q003Y8B400>T00>4Y:@02J@01jRTY:BXY<@00j@00lS4a003b0;4
00OXb>SXi<CT00KX00?4j>P00^@01<CXa<P6a003b<C400?400?8i<@00/@00lS4a002a0?T00?Xi<P0
0/@00nSTi002i0;X0^@2j003a>CT00;X00CTj>C80^P01>CXj>P3i004j>CXi0;X00?Ta>@00^P7i0;X
0^@00nSTa002i003a>ST00;T0^P3i003j>CT00;T0^P2i003a>ST00CT00K4i>STb<@2i0C400?8a<@0
0/@01NC4i<C800C400?8a<@00/@00lSTa003a005b<C4j>@00/@00lS4a004a004b<C8a0;800G4j<S8
a002j004i<S8b0;X00G8j>SXb002j003b>cX00cX00O/j>STk>S800;T0lP01<C8j<@9b00000BTZ:BX
1J@00jR4Q004Q005Y8BXQ:@00h@00jB4Y002Y0:400JTQ:BTQ:@2Z0RT00?4Y:@00l@01<SXb>@2j007
i>SXj<SXi002j003b>CX00;80^@01LCXj<S400;80l@3b003Y<C400C400O8a<C4i>S400?T0^P3i003
j<CT00;T0^P2i003j>C400;X0n@2j003i>ST00;X00?Tj>P00^P2i0;X1>@2j0kT00?4i>P01N@00nST
i003j0;T00?Xi>@00^@2a0?T00?4i>@00^@00nSTa002i0?400GXa<C4i002a006j>CTb<CT0l@00nC4
a002a003b>C400?400CTb<CX0/@01/S4a>C4b0?40/P3a0;80/@3b005a>S8b<@00^P2b003j<C800;X
00?4j>P02^P01LCXi>S800;T0/@01<SXi<@3b0;41lP1a0000Z@00jRTQ006Y0V400BTQ8B42:@00hBT
Y006Y003Z:BT00JT00?4b<@00/@3b003i>SX00CX0/P01NC4j<ST00;X0/@2i006j<C8b<C80/@01<S4
a<P6a005i<CXa>@00/@00lS4j002i003j>CT00GT0^P2i0cX0^@3j0;T0nP3i0CX1N@2j003a>CT00CT
00?4i>@00n@01/CTi<CTj0;T0^P3i003j>C400?T0/@00nC4i002i0;40^@3a005j>C4a>P00l@3i0S4
00G8a<C4b007a003b<CX00;400CXi<S40/P2a0?800K4b<S4b<@2b003j<S800GX00STb>SXi<SXi0[X
0^@01>S8i>@2b0?40/P3a0;80/@4b0740LP00003Y8BX00>T00>4Z8@00h@00jB4Q002Q003Y8B400J4
1:@01:RTY8@5Y0:X0j@00jRTY002Y003Z<S400;400G8a<CXb003j00=b>CXi<CXa<STa<SXb002a005
j<S4a<P01<@2b0?400?8Y<@00/P00nS8i002i006a>C4j>CX0n@00lC8i003i004b>STi0OX00?4j>P0
0^P00nCXj003i003j>CT00;T00?Xi>@01^@01^STi>C4j0CT00?Xi>@00^@00nSTa00:i0;X0n@2j0?4
1n@01<CTi<@3i0C41>@00lCTa007a0;81<@00lS4b002a0;X0/P01<CXa<@6b0?40/P00lCXb002b007
j<S8a>S4i002j003a>CX00CX00CTj>ST1>P2i0?X00GTj>S4b002a0;80/@2b0?41lP00006Q:RTQ:BX
0h@00jB4Q002Q003Y8B400N400JTQ:BTZ:@2Q0FT0ZP4Y006Z:BTY<C81L@01>S4a>P2i0;X0^@00lC8
a009a0?T00?8a<P00/@2b0;400>Ta<P00/@01<S4b<P2a005b>SXa>@00^P01<CTi>P6i004a>CTj0;T
0^P2i0;X00OTj>STj>CX00GT00?4j>@01n@2j0?T00?Xi>@02>@00lCTi002j0CT00?Xi>@00^P9i0;4
2>@2a0;X00?Ta<@00n@00lCTi002a003i<C400?400?Tj<@00l@00lS4a003a0;800GTa<S4j002a003
b<C400;400CTa<S80/@3b0;400SXb<S4i>S8j0;40^P00lS4j004j004b>SXj0;T00C8j>ST0^P01nC4
a<CXa>@00/@00lS4b002a004b<C4a0;80L@00003Q:BT00:T00B4Y8BT0X@01:B4Q:@3Q003Y8B400F4
00BTZ:BT0X@3Y003Q:BT00^T00G8Z<C8a002b003i<ST00;X00KTj>C8j>@2j003a>C400?400K8a<S4
i<@2b003a<S400;80l@01<S4a<@2b0G400?Xa>@01>@00lCTj007i0;X0n@01nSTi>CXi>P00^@2j0?T
00?Xi>@00^@2j0OT00?Xi>P01N@00nSTi004i003j>CT00;T00?Xi>@00^P;i003j>C800GT00?4i>@0
0^@00lCTi003a004i>STi0K400?8i<@00/@3b004a<SXb0?40^P2b0K400?Ta<@00lP01<C8i>@4a0;8
0/@01>S4a<@2j008a<STj<SXa<P2j003i>SX00;X00GTj>SXi003j0C400?8i<P00lP2a004b>S8a0;8
0NP1b00000JTQ8BXY8@3Y005Q:B4Q:@02h@00jB4Q003Y0:42Z@00jRTY002Y004Z<C4a0;800CXa>S8
0^@4j005i>STj>@01>P00nC4b002i006a<S8b<C80^P2a003b<C800C40/P2a005i>STa<P00^P01/CT
i>STa0?X2>@2j003i>SX00?T0nP3i004j>CTi0;X0n@01>STi>P4i0;X0n@00nSTi00Di0;X00CTa>CX
1n@01<CTi>@2a0CT00?4i>@00^@2a004i<C4a0;X0/@3b0;400G8j>S8a002b0;T0^P01<S4j>P3a003
b>SX00;40lP01<CXb>P3a0?X0/@01<STa>@:j003i>ST00;X00?Tj>P00^P2i006a>C8i<CX0/P00lC8
b003b003a<S800;80L@00003Y8BX00>40j@00hBTQ005Q003Y8B400:T0h@4Y006Q:B4Q:B43J@7a004
b<C4i0;80^@00nSTj002i0?X0^@01>S8j<P2j003b<CX00;X0/P00lC8a003a0;80/@2b0;400G8i>ST
a005i0;X00?Tj>P01^@01>STi>@2j0;T00?Xi>P00^@00nSTi002i0;X0n@3j0;T00?Xi>@00^@00nST
i002j0ST00?Xi>@00n@00nSTi009i003j>CT00?T00?4i>@00^@01<CTi>@2a0?T0/@3i0C400?Tb>@0
0^P00lSXa002i004j<STi0;X00?Ta>@01/@2i0?400[Xa<S8a>C4b<C80/@2j005a>SXj<@00n@02<S4
j<STj<CT0nP00nCXj003b003i>SX00;X0/P01^C4j<CXb0;41/P3a0;80002Y0:40Z@018BTY:@2Q0:T
0h@00jB8Q006Q0>T00>4Y:@00Z@00hBTQ00:Y0K400?8a<@00l@01<STi>@2j003i>SX00;T00GXi>CX
i004j0;T00GXb>C4j002b003j>C400C40/P4a003i<CT00WT0nP2i003j>CT00?T0^P3i0;X0^@2j0;T
00?Xi>@00^@3j0CT00CXi>CX0n@00nSTi006i0;X4N@00lCTi006i003a>CT00;T00?4i<@01/@3i004
a>CXb0;T0nP4a0;T00?4i>@00^@00lCTj002i008b<C4a>S8i>P2a004b<C4a0;T00?Xa<@00/@01/S4
a>S8j0;T00GXi>CXi002j003i>S400?X00?8j>P00n@2j006i>S8a>CX0/P02LCXa<C8j<S4b004a078
0L@1a0000Z@018BTY:@2Q003Z8B400:T18@00jBXY004Q0:T00B4Y:B40Z@2Q0:T00>4Y8@02:@01LC8
Y<BT00K40n@00lCTi002i003j>CX00?X00?Tj>P00nP00nCXj002j007a>SXi>S4j009a003i>ST00;4
00?Xi>@01N@00nSTi002i004j>CTi0?X00CTj>CX0^@3j0;T00?Xi>P01>@00nSTj003j0;T0^P2i003
j>CT00;T00?Xi>@02n@00nSTi002i003j>CT00;T00?Xi>@01n@00nSTi004i003a>ST00;T00O4i>C4
i<CT00;400KTj>STa<P6i008j>C4i<CXa>@3j004a>CXj0;400G8a>C4i002j0;T00?8j>P00/@3j0;4
0nP01^CXj>S8i0?X0^@2j003i>SX00;X0^@2j009i<STj>CXa>CX00;800CXa>SX1LP2a00000>XY:@0
1:@01HBTQ8BT00B400>TQ8@01X@01JB4Q8BX00:T0h@9Y0:X1Z@6a006i<S4a>C40^P01^CXi>CXi0CX
00GTj>SXi005j007i>SXb>C4j002a004i<CTj0?400?Ta<@00/@00nSTi002i003j>CT00;X00GTj>SX
i002j004i>SXj0;T1nP2i004j>CTi0CX00?Tj>P00n@00nSTi002i003j>CT00?T00?Xi>@03N@00nST
i003i003j>CT00KT0^P4i005j>CTi<@00^@01<CTi>P3i0;400?Xa>@01>@01NS4i>ST00;400STj>C4
i>STj0;400?Tb<@00n@00nSTi002i003b>C400KX00CTb>CT0^P01LCXj>S800;T0nP00nCXj002j003
i>S400?T0^P00lSTi005j0;800?Xi>@00/P2a07X0LP000>400>TQ8@00X@01ZB4Y:B4Y0:40Z@00jR4
Q004Q0:T0X@00jR4Q002Y003Q:BT00:T00>4Y:@02Z@01lS4Y<C8a<P00l@01>C8a>@7j003i>SX00;X
0^@3j005i>STj>@00nP3i003j>C400CT00K8i>CXb<@2i006j>CTi>ST1NP00nCXj002j0;T1>P00nCX
j003i0;X0^@3j0?T00?Xi>@00^@00nSTi002i005j>CTi>P01>@00nSTi002i004j>CTj0gT0^P3i003
j>CX00OT00?4i<@00^@01NS4j>CX00CT0^P2i007a>CTi>S4b002j0GT0^P3i003j>CT00;400KXi>SX
a>P2i00;a>S8a>CXb>STj>@02NP00lCXi004j004i>SXj0;T00SXb<SXi>S8j0;T1>P02>CXb<CTa<SX
0N@00006Z:BTQ:BX0Z@2Q0:T00>XY:@00X@2Y0:400BTZ8B40j@3Q0:T0X@2Y003Z:BT00jT00?4b<@0
0/@01/S4j<CXi0;41>P00nCXj003i0?X0n@01NSTj>ST00;X0n@00nSTi003j0;T00?Xi>@00^@01nS8
a<CTj>@02>P4i0;X0^@4j003i>SX00;T00?Xi>P00^@2j0;T00?Xi>@00^P5i004j>CTi0;X0n@2j0ST
0^PNi0?X00?Ta<@01^@01/CTi>STa0;T0^P01LCTi>S400?T00GXi<CXi003a0;X00?Ta>@00^P01/C8
j>STb0;X00?Tj>P02>P2i003j>C800CX00?Tj>@00^P01NCXj>ST00CX00?Ta>P00^P01NCXi>S800;X
0/P000>T00FXY:BTQ008Y0:400NTQ8B8Y:RT00:400>TZ:@00X@00jBXY002Q0BT00>4Y:@03J@2a00:
b<C4a<S4i<CXa0;T00?Xi>@01>P2i0OX00CTj>CX0n@2j0CT0^P2i005j>CTj>@00l@01^CXi>STj0CT
0^P3i0;X0n@00nSTi002i0?X0^@01>STj>@3j0?T00?Xi>@01N@00nSTi002i003j>CT00;T00CXi>CT
0^P3i0;X2>@00nSTi009i005a>CTi<@00^P2i005a>C4i<@00^@01>S4a>@2j003i<CT00GT00CXi>S4
0^P01LSXj<CX00;400?Xa>P00^P00nC4i002j003a>S400;X00?Tb<@01^P00lSXi003j003i>SX00?X
00KTj>STj>@2j003a>CT00CX00C4j<S80nP2i004j<SXj07T0003Y003Q:BT00:T00B4Y:BT0X@3Y0:4
00>TQ8@00X@4Y004Q:BTY0:40j@2Q0>T0X@<Y0?400G8a<C4b002a004b>C4a0?T0nP01>CXj>P3i0;X
00CTj>SX1N@00nS4i002j0?T0/@01NS4i>CX00G40^@00nS4i006i003j>CT00?T00CXi>CT0^P5i004
j>CTj0cT00?Xi>@04>@00nSTi006i003j>CT00KT00CXi>CT0/@3i003j<C400;T0/@00nC4a003a006
i<C8a>ST1<@00nC4j002a0GT00C4j>ST0/@01NS4a>CX00;80^@3j005b<CTj>@00/P2j003i>SX00;X
0/P00nSTi004j005i>SXi>P00^@00lSTi002j003b>CT00;400C8i<C80^P00lCTa002b07T0LP1a000
1J@00hBTY002Y003Q:B400:T00>4Y:@00Z@00hBTQ002Y0J400FTQ8BTQ004Y003Q:BT00jT00C4Y<S8
0/@00lS4a003a004b>C4b0?T0^P3i0?X00?Tj>P00^P00nCXi002j003i>ST00;X00?Tj>P01N@00nST
j002b003j<C400;X00?Tj>P01>@3j003i>SX00?T0nP00nCXj004i0;X1>@01NSTi>CX00CT00?Xi>@0
1>@00nSTi002i003a>CT00gT00?Xi>@01^@00nSTa004a004i>SXa0;T00?4j<@01/@2b0?400?Ta<@0
1L@00nSTa002a003j>CT00?T00G8i>C4Y002j005a>C8j>@00/@2b003a<S400;800_4j<C8j<SXa>S8
i004j0;800?Xb>@01NP00lSXj003j004b<C4a0?X0/@01NS8a<C800;X0008Y003Z:BT00:400BXY8BT
0X@01JB4Y8BX00>T00B4Y8BT0X@01ZRTQ8BTZ0>T00>4Z:@00Z@00hBTY007Y0G400?8a:@00/@01/S4
a<S4j0;40^P2i0?X00?Ta>P00^P02^CXi>CXi>STj>@4j0;T0nP4i0?400K8a>SXa>P7i0?X0^@3j0;T
00?Xi>@00^@2j0?T00?Xi>@00^@00nSTi003j0?T00C4i>CT0^PQi005a>CTi>P00^@2j003i<C400C4
0nP01NC4a<CX00C40n@2j0;T00?Xi>@00^@01>STi>@3j0;T0nP00lCTj002b004i<S8b0?40^P02LCT
j<C8j>C8a004j003b>SX00?X00?Tj>P00^@01NS8j>S800;T0^P01>C4b<P2i0?80NP1i0001j@00jRT
Y002Y003Q:B400J40Z@4Q0:T18@00jB4Y004Q0:T00>4Y8@00Z@018BTY:P8Y003a<RT00?400K8a<C4
i>P2a005i<CXj>@00^P00nC4i005j003i>ST00GT0nP3i003j>CT00GT00?4i<@00l@00nS8i007i004
j>CTi0;X0^@01>STi>P2i0;X1^@00nSTi007i006j<C4j>C41>@2j1?T0^P5i006a>CTi>S40^@3a005
i>S4a>@00/@01>STi>P3i003a>C400;T00?4i>@00^P2i003a>SX00;T0^P2i004a>CTi0?X0^@01LCT
b<ST00;X0^@00lC8j002j008b>SXa<SXb<@4j004i<STi0CX00KTj>CXa>P3a0;X0/@3b0;40lP1i074
0LP00003Z:BT00NT0ZP4Y0:400>TQ8@018@2Y003Q:B400:40Z@00hBTQ002Y004Q:BTY0:43J@00jRT
a002a003b<C400?400G8i<C4i002a0CX00CTa>ST1NP2i0;X0^@2j005i>STi>P01n@01NS4a<CT00;4
0^@00lCXa002i0;X00GTj>STj003i0;X0^@3j0CT00GXi>STj002i003j>CT00GT0/@01<STi>@4j13T
00?Xi>@00^@00nSTi003i005a>CTi>P00^@2a005j<CTi<@00^@01<CXa<@5i003j>CT00;T0/@2i003
j>CX00?T00?Xi>@00^@01LCTi>C400;X00C4j>C80^@01nSTj<S4j>@01NP01>CXa<P7j003i>SX00;T
0^P2i003a>SX00?X1L@2j0;T00C4j<S40/P1j07800001JBXY:B400NT0X@3Y003Q:R400B41:@00hBT
Q003Y008Q:BTQ:B4Z:@3Q0VT0ZP3Y004Z<C4Y0;400>Ta<@01L@01<S4a>@3j0?T00CXi<CT0^P00lSX
i002j0?T0^P3i003j>CT00;T0^P3i004j>C4i0?40^P3i0?X1>@00nSTi002j0;T0nP00nCXj002j0;T
0^P:i003b>c400?T00?Xi>@04N@00nSTi008i006a>CXj<S40^@00nSTi005i003a>CX00KT00?Xi>@0
1>@01NSTi>C400?T00OXi>SXi>ST00GX00KTj>SXa>@3j0;T00S4j>C4i>S4j0;T00C8j>ST0nP00nCX
j002j003i>SX00;X00OTj>S4i>S400;X0^@01/STj>C4j0;40^@1b00000BTZ:BX1:@2Z0VT0h@01:BX
Y8@3Y0:40Z@01:R4Q8@2Y0J41:@3Q003Y:RX00JT00?4b<P00/@00jC4a006a0;T00OXb>CXi>ST00CX
00G4i>STj002i0CX00?Tj>@00n@2j0?T00CXi>CX0n@2a004j>CTi0;X1N@4j003i>SX00?X0^@8j0KT
0nP01>CXb<@Ri0?X0^@2a0?T00?Xi>@00^@00nSTi006i0;X0n@2j0OT00?Xi>P00nP00nCXi005j004
b>SXi0CX00?Tj>P01^P2i0GX00?8i>P00^P2a0;X00?4j>P01>P2i005j<CTj>@00nP00nC8b002i0;4
0^P1i00000>XY:@01Z@00jRTY005Y0Z41J@018BTY:@3Q0:T0h@2Y0:400BTQ:B41Z@01lC8Y:C4b:@0
2/@00lS4i003j004i>SXi0;X00?Tj>P00^P2i003j>CT00?T00?Xi>P00nP7i003j>CT00OT00?Xi>@0
0^P3i0?X0^@00nSTj004j003i>SX00;X0^@01>STi>@2j0;T0nP4i003j>CT00;X4N@00nSTi006i003
j>CT00OT00?Xi>@00^@01>STi>@2j0?T00GXi>SXi002j003i>ST00GT00GXi>CXi002j005i>STj>@0
1>P01^CXj>CXi0?X00OTj>SXi>S800?X0/P3j008a>SXj>C4j<P2a0?X00CTj>SX0^@02LSTj<C8j<C8
i002a003b>ST007800000jRTZ002Y007Z:BXY:RTQ002Y003Q:BT00:T00>4Y:@01j@2Q0>T00>4Y:@0
0Z@01HBTY:RT00>40j@00hBTY006Y0;800JTa<BTa:@6a004b<C4a0?X0^@2j0;T0nP2i003j>CX00;T
0^P4i003j>CX00kT00C4i>CX0^@2j0;T0nP2i0?X00GTj>SXi005j0GT00?Xi>P00^@01^STi>STj1;T
00?Xi>@01^@00nSTi003j0KT00?4i>@01>@01NSTi>CX00CT0^P3i0?X00STk?[/i>STj0?T3>P00nCX
j002j003i>SX00kX00?4b>P00^P01/CXj<S4i0?X0n@00nS8a003i003j<ST00?X0/@4j07T0NP1j000
0Z@2Z0BT00BXY:B40Z@01HBTQ:BX00FT00JXY8BTZ:@2Q008Y:RTY8BTZ:@2Q003Y:RT00:41Z@00jRT
Y005Y0?400>Ta:@00l@00lS4a002a0;80n@2j003i>SX00;X0^@3j0;T00CXi>CT0nP01>CXj>P?i004
a>CXj0CT0nP00nCXj002j003i>SX00;T1NP01nCXi>CXi>P01>@00nSTi005i005j>CTi>P01>@00nST
i00>i004a>CXj0?T00?Xi>@00^@01NSTi>CX00GT00KXi>CXi>P4i0GX00?jj>@01>@2j0;T0nP2i0SX
0^@2j003i>SX00OX00?Tj>P00nP00lSXj002j005b<CXj>@00nP01>CXj<@3j003b<CT00?X0^@01>ST
j>P2i0;X0N@0009Y00>TZ:P01J@00hBTY003Y003Q:BT00:40Z@00hBTY007Y003Q:BT00NT00N4Y:B4
Y8BX00FT0ZP2Y003b:RT00:T00?8a:@01<@01<S4a>P2a003i>ST00?T0^P00nCXj002j0;T00?Xi>P0
0n@00nSTi002i0;X0^@00nSTi002i0;X2N@01NSTj>S400GX0^@3j0;T1nP01>CXi>P2i003j>CT00;T
00?Xi>@05N@00nSTi006i0;X2>@00nSTi002i003j>CT00;T00?Xi>@01^@2j0?T00CXi>CX1N@2j0?T
0^P2i0?X00CTj>SX0^@2j0?T0^P2i0?X00?Tj>P00^P00nCXi003j003b<CX00;400?8a>P00^P01LSX
j<C800;X00G4i<CXi004j0;T1^P000=Y1j@2Q003Y8BT00FT00>4Z:@00Z@00hBTY002Y006Q:BTY:R4
0Z@018BTQ:@2Q005Z:BTY8@01J@00jRTY002Y003Z:BT00JT0/@2Y003b<C400;400?8j>P00nP3i004
j>CTj0;T00CXi<CT0^P3i0;X1>@01>STj>@2j003i>ST00CT00?Xi>@01N@5j003i>SX00;T0^P2i0?X
0n@00nSTi002i005j>CTi>P01N@00nSTi00Di003j>CT00;T00?Xi>@01N@00nSTi002i005j>CTi>P0
2N@00nSTi002i003j>CT00;T00CXi>CX1N@2j004i>STj0;T1>P01>CXj>P3i003j>CX00GX00CTj>ST
1>P01>CXi>P2i005j>CXj<@00^P01<CTj>P2a0;80^@3j003i<CT00?X0^@3j0000VT01:RTY:P2Y003
Q:BT00:T00>4Y:P00Z@2Q0:T00>4Y:@01:@00hBTY00?Y0:41Z@00jRTY00:Y0;400?8a<@00/@01<S4
a>@2a0OT00?Xi>@01N@6j0CT0nP01NCXi>CX00;T00?Xi>@01>@01<CTj>P3i0?X00CTj>SX0n@00nST
j003j0?T00?Xi>P00nP8i003j>CT00CT00?4i>@02N@00nSTi004i0;X4n@00nSTi007i005j>CTi>P0
1>@01>STi>@2j0?T0^P3i0;X0^@3j0;T0^P4i0;X00CTj>SX0^@3j003i>SX00;X00KTb<STj<@3b0;X
00?8i>P01l@02NSTb<S4b>C8a002j07T0NP1j00000=YQ:@00Z@00jRTY003Y005Q:B4Y:P01j@00hBT
Y002Y003Q:BX00>T00>XY:@01Z@018BTQ8@2Y003Z:BT00:T00>XY:@02:@00lBTY002a003b<C800K4
00CTa<C40n@2j003i>SX00?X00CTj>SX0^@2j004i>STi0;X00CTj>SX0^@3j0WT1NP00nCXj006j0;T
0nP3i004j>CTi0;X1>@00nSTi002i003j>CX00CT0^P3i003j>CT00;T00?Xi>@01N@3j1GT00?Xi>@0
0^@00lCTi004i0GX1n@00nSTi004j0?T0^P01>CXj>P3i003j>CT00[X00G8j>SXi003j0;400_8a>S8
a<SXi<C8i003a0;80l@01>S4i<@2b004j<CTa0;X00001:BXZ:P4Y003Z:BT00:T00B4Y:B40ZP2Y003
Q:BT00JT00>4Y:@00ZP6Y003Q:BX00:T0X@4Y005Q:BTY8@01j@01JRTY:C400:T00C8Y:BT2/@01nCX
i<CXi>P00^@2j0CT00?Xi>P01^@00nSTi003j003i>ST00CT00?Xi>@00^@2j0;T0^P00nCXi002j0ST
00KXi>CXk>P3i003j>CT00;T00OXi>CTj>C401?T00?4i>P05n@00nSTi005i0;X1>@2j003i>ST00?T
0^P3i003j>CT00;T00CXi>CT0nP7i0?X00GTj>SXi003j0;T0^P00lCXj003j0;T00CXa<C40lP2a003
b<C800;40/P2a006b>S8a>C40lP1j00000>XY:P00Z@5Z0RT0X@2Y003Q:BT00BT00F4Y:BTQ003Y006
Q:BTY:R40j@2Q0>T00BXQ8BX0Z@00hBTY004Y003Z<RT00JT0/@2Y0c400GXi>CXi002j003i>ST00?T
0^P3i003j>CX00;T00GXi>CTj007i0;X00?Tj>@00^P2i0?X1n@2j0?T00K/n_[/i>P2i005a>CTa>P0
0n@3a0CT00?Xi>@01>@00lCTi003i004a>CXa0?T00?Xi>@07^@00nSTi002i003j>CT00;T00CXi>SX
1>@01>STj>@3j0;T00CXa>C40^P01>CXi>@7j0;T1NP2b0?X0/P01/C8a<S4j0;400K8a<C8a<P2a0?8
00?4i>P00/P1a0780LP000VT00>XY:@00Z@00hBTY003Y003Q:B400>T00FXY:BTQ004Y006Q:BTZ:B4
0j@4Q0FT0h@?Y003a:C400?40Z@8a007b<CTj<SXi002j004i>STi0CX00?Tj>P00^@2j0?T00?Xi>P0
0^@2j0CT00?Xi>@01>P2i003j>CT00CT00?Xi>@00n@00lBBnP02nP03k>ST00;T00?4i<@01>@00lCT
i003i003j>CT00GT0l@2i0?40n@00nSTi00Ei003j>CT00;T00G4i>CTj004i003j>CT00GT00?Xi>@0
0^@01>STi>@2j0WT00CXi>ST0^P01NCXj<SX00;T00?Xi>P00n@01/S4i<C8j0;400?8a<@00lP8a003
b<C400;400?8a>P00/@3b0001:@00jRTY00>Y0:42j@2Z0:41:@018BTY:@2Q0BT00>4Y:@01:@00hBT
Y003Y003Z:BT00JT00?4Y<@00l@00lS4a005a004b<C8a0;T0^P5i0;X0^@2j0;T00?Xi>P00^P8i003
j>CT00KT0nP2i003a>S400;T00CXi>CT0nP5nP;X0^@2a0CT0/@4i003j>CT00CT00?4i<@01<@00nC8
i00Ri003j>CT00?T0^P3i005j>CTi>P01>@01>STi>P4i003j>CT00;T00?Xi>@01>@00lCXj005i003
j<C400;X0^@01^STi>S4b0;400CTa<CX0l@00lS4a002a004b<C4a0;80l@01<S4b<P1a00000>XY:@0
1:@00jRTQ00<Y0:41j@00jRTY005Y004Q:BTY0:40Z@3Q0:T00>4Y:@01J@00jRTY008Y003Z:BT00;4
0Z@>a005i>S4i>P01N@01>STi>P4i004j>CTi0;X1>@00nSTi005i0;41>@00nSTi007i0CX1OX00ncX
j002j005i>STi>P01>@00nSTi008i0O42^@00nSTi00Ni003j>CT00;T00?Xi>@01n@00nSTi005i003
j>CT00;T00?Xi>@00^@01NSTi>ST00;X0^@01lC8i>C8i<@00nP2b004a>S8b0;400?Xb<@00/@01<S4
b<@3b0?40/P00lC8b001b0001:@00jRTY006Y003Q:BT00:T00J4Y:BXY8@4Y003Q:BT00:T00B4Y:BX
1Z@00hBTY004Q0:X0j@00hBTY00CY0;40Z@2a003Y<C400S40/P2i003a>CT00;T00?Xi>@00^@00lST
i002i003j<CT00WT0^P3i0;X0n@3j0CT00?Xi>@00^@00nSjnP03nP03k>SX00?T0^P00nCXi004i003
j>CT00ST1L@3i003j>CT00_T00GXi>CTj00:i003j>CT00_T00?Xi>@01N@00nSTj002i0;X0^@2j0CT
00?4i>@00^P4i0;X0n@2j003i<S400;X00STb<CXi<C8i0?400CXa<S40/P2a003i<C800;400?8j<P0
0l@2b0;40LP000>T0ZP?Y003Q:BT00:T00>XY:@00j@00jRTY00;Y006Q:BTY8B82:@00jRTY00<Y003
b:BT00FT1<@00jC8a007a0;X00?4i<@03>@00nSTj002i003a>CT00CT0^P01>CXi>P3i0;X0^@3j003
a<SX00;X00?Tk=D01?X00oCXi003j0?T0^P3i003j>CT00WT0l@00lSTi005i004j>CTi0;X0n@00nST
i002i0;X0n@00nSTi002i005j>CTi>P02^@01NSTi>CX00?T00?Xi>@01n@01>STi>P4i0;X00?4i>@0
0^P00nCXi002j0;T0^P01lS4j>CXa>@00nP01/CTj>S8i0;40/P01<C8b<@2b003a<S400;81l@000>T
00>XQ8@00Z@01JRTY:B400NT00>4Y:@01J@00jRTY002Y0:X1:@01jR4Y:BXY8@00j@2Q005Y8BTY8@0
0Z@00jRTY00GY0?400>Ta<P01L@01<S4a<@2i003j>CT00GT00GXi>CTj003i0;X00GTj>CTj003i0?X
00?Tj>P00^P3i004j>CTb0;X00GTj>SXk004nP04m>SXj0?T00?Xi>@04>@4a0cT00?Xi>P02>@00nST
i002i003j>CT00;T00?Xi>@01n@00nSTi002i004j>CTj0[T00CXi>CT0^P2i003j>C400;T00?Xi>@0
0^@01NSTj>CX00?T0^P01<CXi>@2j0?T00CXa>C40/P3a0;80l@01LS4b<S400;800G4b<C8a001i000
0Z@00jRTY002Y003Z:BT00JT00B4Y:B40Z@00hBTY007Y003Z:BT00:T00>4Y:@01J@00jRTQ002Y003
Z:B400:T00>4Y:@00Z@00jRTY002Y003Z:BT00NT00>XY:@01:@8a003Y<C400;800?4j<@00/@01>ST
i<@=i005a>CTi>P00n@01>STj>@3j0;T0nP3i0;X0^@2j003i>S/00Cj00?Ek>P02N@01LCTj<CT00c4
00?Xi>@01n@00nSTi007i003j>CT00KT00GXi>CTj00<i0;X0n@2j0GT00CXi>CX0n@2j005i>STi>P0
0n@2j0OT0^P2i003j>CT00;T00CXi>C40^@01LCXi>C800C400?8a<@00/@00lSXa004b0;400C8a<S8
0L@000RT00>4Y:@00X@5Y0:40j@00hBTY008Y005Q:BTY8@02Z@00hBXY004Y004Q:BTZ0BT00>XY:@0
3j@01JS4a<C800?40Z@:a0;T0/@01^STi>STj0GT00[Xi>STj>CXi>ST1>P2i0;X0^@01LCXi>ST00?X
00CTj>c/1?X00mG/j002j0CT00CXi<C81L@00jC4Y003Y0?400?8Y>@02>@01>STi>P3i0;X5N@00nST
j005i003j>CX00?X00?Tj>@02>@3j003i>ST00?T0^P01>CXj>P3i003a>SX00;X00WTj>STj>CXa<P0
0^P00nC4i002j003a>C800;X0l@01lS4a<SXb<@00lP01<C8a<@2b00000B4Y:BX1:@00hBTY002Q003
Z:BT00NT00>XY8@00Z@00jRTY009Y0:400BTZ:B41:@3Q003Z:BX00NT00>XY:@01:@2Z0RT00BXY<BT
0lP01:C4Y<P3a0;80l@00lS4a002a008j>CTa>CXi<@3i006j>CTi>ST0^P01>CXi>@3j003i>SX00?T
00CXi>CT0nP2i0?X00?/n_X00_X01MGXj>ST00;400?Xa<@01L@4Y004Q6B4Q0:T00?4b<@02>@01>ST
i>@2j0?T0^P@i003j>CT00;T00?Xi>@00^@01NSTi>ST00GX0^@4j0;T00CXi>CT0nP2i0;X0^@2j0?T
0nP00nCXj004j004i>STi0;X00?4j>P00^P01>C4j>@3a0?80/@01NS8b<CT00;80/@2j0780L@1a000
1:@01JRTY:B400>T0h@5Y003Q:BT00ZT00>4Y:@01Z@00hBTY002Y0:40j@00hBTZ003Y003Q:RT00>T
00>XY:@00Z@2Z0fT00?8Y<@00/@2Y004a:C4b0?400?8a>@01<@2i0;41^@3j0?T0^P01NCXj>ST00CX
00C4i>CX0n@4j003i>SX00;X00?/n_X00_X01]GXa>C4b0G41:@5Q09T00EPI8BTa00;i004j>CTi0?X
0^@2j0OT00?Xi>@00n@00nSTi006i003j>CT00;T00?Xi>@00^@2j004i>SXj0;T00CXi>CT0^P3i006
j>CXj>CX2>@3j0;T0^P01>CXi>P3i003a>ST00;T00O4j>STj<C800?400GXb<CTj002b007j<S8a>S8
a001b0002Z@00hBTY004Y003Q:BT016T00>XY:@01J@01HBTY:B400:T00>4Y:@01j@00hBTZ006Y003
Z:BT00FT00?4Y:@00Z@00lBTY003Y0;400>Ta:@02l@00lS4i002j0?T0^P2i0;X0n@2j0?T0^P01^CX
a>C8i0CX0^@6j003k?[j00;j00GEb<S8Y002a0BT18@00fAPI002I007H4ATI62Tj00;i003j>CT00;X
00CTj>CX0^@00nSTi002i0?X1n@00nSTi003i003j>CT00ST1>P2i0CX00CTj>SX0^@00nSTi007i0?X
00GTj>SXi002j0?T0^P00nCXi002j005a>S4j<@00^@00lSXi002a004j<C4a0;80^P4b0;40LP1a078
0007Y003Q:BT00:T00>4Y:@00Z@2Q0>T00>4Y:@01j@00hBTY003Y003Z:B400^T00J4Y:BXY:P5Y003
Z:BX00BT00>XY:@00Z@00jRTY008Y005a:BTY:P00l@01:C4a:@7a004b>C8a0?T00?Xi>@00n@00nST
i002j0?T0^P3i0;X0l@2j003i>SX00;X00?Tj<@00lP4nP06d:S4Y:R40Z@2Q008H8QPH6API604I004
H6ATY17T0^P3i0;X3^@00nSTi002j0?T00CXi>CT0^P4i003j>CT00?X0n@00nSTi002i007j>CTj>CX
i003j0GT00?Xi>P00^P2i0?X0^@2j0;T0nP01>C4j>P3i003j<S400?80^P01LCXb<S400C80/@000^T
00>4Y:@04Z@01ZRTY:RTZ0VT00J4Y:BXY8@2Y003Z:BT00NT00>XY:@02Z@00lBTY00;Y0;40Z@5a003
b<C400;400?Xi<@00/@2j003i<CT00?X0n@00nSTi002j0;T00?Xi>P00^@01<SXi>@4j0;400C8a:C8
1OX00o2XY002Y003Q8R400:400IPI6API4@2I004A6A4A09T00>4Y>@02^@00nSTj003i003j>CT00?X
00CTj>SX1>@00nSTi005i003j>CT00?T00?Xi>@00^@00nSTi00<i003j>CT00;X0^@3j0;T00?Xi>@0
0^@01>STi>@2j0?T0^P01^CXi>CXa0?X0^@2j005a>SXi>P00l@01lS4a>CXb>@00/@4b0;40LP000JT
00>4Y:@00Z@2Q0>T00>4Y:@02J@00jRTY004Y003Z:BT00FT00>XY:@01j@00jRTY003Y003Q:BT01FT
00?4Y:@01:@00lBTa002Y003a:BT00?40Z@;a005b<CTi<@00n@3j0?T0^P2i0;X0/@01>CXj>P2a003
Y:RT00:T00?8n_X00oX00nc8a003a003Y:R400AT00Q4I4ATA41TA0=T00>4a>@02^@00nSTj004i0?X
00CTj>SX1>@00nSTi007i005j>CTi>P05^@2j0OT00?Xi>@00^@00nSTi002i003j>CX00;T0^P01>CX
i>P2i0?X0^@00nSTj002a003j>C400;400?8i<@00lP4a003b>SX00;80N@1a00000J4Y:B4Y8@2Y004
Q:B4Q0>T0X@8Y003Q:BT01>T00>4Y:@01Z@018BTY:@2Q1BT00?4Y:@03Z@01<BTa<@2Y0o40^@01<S4
i<@4i0CX0l@00nS4a005Y004Z<C8TPCj0/P2i0C40Z@3I008H410I41T@203I003Y<CT00;T00?4j>@0
1N@2j006i>STi>ST1^P7i003j>CT00KT00?Xi>@00^@2j0;T0^P3i0;X2N@00nSTi004i0;X0^@3j003
a>CT00KT0^P2i0;X00KTb>SXi<P2j004b>CXb0;X0/@00lS4a002a0;X0/@01>S4b>@5b07X0002Q008
Y8B4Q:BXQ:P3Q0:T00>4Y8@01:@2Q0bT00JXY:BXY:PHY004Q:BTZ0NT00>XY:@02j@00hC4Y003Y004
a:BTY0?400>Ta:@00l@00lS4a008a004i<C4a0CT0nP2i0;X00W4i<BTZ6B4Z<P00/@00lRBnP03nP03
k>S400;T00oXi<CTb:R4H6A4J4A0I4@00V@01D24b>C400[T0nP6i005j>CTi>P01>@00nSTi00<i0;X
2^@00nSTi009i005j>CTi>P00^@00nSTj002i0;X00GTj>C4j002i006j>CTi<CT0nP01^CXj<SXa0?8
00CXb>S81l@2b004j<C4a0C80L@1b0000h@00jB4Y003Y004R8B4Q0BT00J4Y8B4Y8@<Y003Q:BT00:X
1j@00jR4Y007Y0:X1Z@00jRTY00KY003Z:BT00JT0/@00jC4a00=a00=i<CTa>STj<CTa>S4j003a008
Y8B4Q:S8a>P2a005b?[jn_000/P00nS4a003i006j<CTa:R40V03I006@61XI8C43>@00nSTi00:i0;X
0^@00nSTi007i0;X0^@00nSTi007i005j>CTi>P01>@00nSTi002i003j>CT00[T0^P3i004j>C4i0?X
00[Tj>SXi>STj<C80^@01<SXi>@2b0?400?8a<@00/@00lS4a002a0;800?4b>P00/P1a0001X@00jB4
Y002Y003Q:BT00>T0h@2Y003Q:BT00NT00>XY:@03j@00jRTQ00MY003a:BT00RT00>XY:@00j@00lBT
Y002Y0;40j@3a0:T00?4Y<@02L@00lS4i005a003i<RT00:T0ZP01HBTa<SX00;400OXn_[jb<C800K4
00OTj>STa:B4009400QPA4ATA6BTa1?T00?Xi>@00^P00nCXi002i003j>CT01GT00GXi>CTj00;i003
j>CT00cT0nP2i0;X00?4i>P00^P02^CXj>S4j>C4b>@3j003b>C800?400CTb<SX0/@2b0;41LP1a000
18@01jB4Q:BXY8@01J@00hBTY002Y003Q:BT00BT00FXY:B4Y002Z0RT0ZP=Y003Z:BT01>T00>XY:@0
6J@00lBTY002Y007a<RTa:C4Y002a003b<CT00;40/P7a0:T0h@03:C8i>C8a<S4b>cXa0;T00?8a<@0
0/@02lS4i<CXa>C4Q6A4009T00APJ8S40^@00nS4i003i003a>CT00[T0^P01>CXj>P=i005j>CTi>P0
2N@01NSTi>CX00?T00?Xi>@01n@01lCTi>CXi<@00^@00lCTi002i004j<CTi0;X00G8a<CXa002i0;X
0/@01^CXb<S4i0;80l@2b0;40lP2a0?80^P4b0000X@00jATQ002Y005Q8R4Q:@00X@01JB4Y:B400BT
00>4Y:@01:@00jRTQ008Y0:X9:@00jRTY00AY004a:BTZ0ZT00C4Y:C40j@2a004Z<C4b0G400S8a<C4
b:B4Y0:400>Xi>P00^P00lC8j002j004a<S8j0[400OTa<BTI4AP00=T00FTa>CTk00:i0;42N@2j0;T
00?4j>@00^P01>CXi>@2j0OT00?Xi<@00n@01^STi>C4j0gT00GXi>CTa003i003a>CT00C400?Xa>P0
0/@00nS4a002a003j>C800C400?8a<@00/@01<S4a<@2b0?40/P00lC8b005b0;/0lP000R40Z@4Q003
Y8B400:T0X@BY0:X4J@00hBTY003Y003Z:BT01>T00?4Y:@00Z@00jRTY008Y0;42J@00lBTY003a003
Y<C400c400?8a:@00h@00jC4j002j003i<C400;X00CTj>S80n@01lCTa<S4i<@00^@3a003Q6AP00=T
00BXa>CT0/@5i003j<CT00GT00?Xi>@00^@00lCXa007i003j>CT00;T00GXi>CTb00Ni003a>CT00;T
00?4j>@00l@01nSTi<CTj<P00^P2a005b<C8a<P01<@00lS4b002b0?400?8a<P02lP01>c8b<P2k07<
00001:B4Q8@2Y0:400BTZ:BT0X@8Y003Q:BT00>T00>XY:@00Z@00jRTY002Y003Z:BT00:T00>XY:@0
1j@00jRTY00HY003Z:BT01BT00?4Y:@00Z@00jRTY002Y003Z:BT00>T4L@01/RXQ8BTb0?T00?4j>P0
0n@01>STa<@2i0?400OTj<C4i>ST00;400BXI61T0X@5a003i<CT00CT00G4i>CTa005i006j<CTa>CX
1>@01NSTi>CX00;400KTj>CTa>@2j0CT00CXi<C40n@00lCXj008i0?41>@2a003j<CT00O400?Xb<@0
0/@2b003a<S400;40lP00lC8a003b005a<S8b<@02lP01Nc<b<S/00;<0LP1c0000X@01ZR4Q8BTZ0:4
00>TQ8@00h@00jB4Y002Y0:41:@00jRTY002Y004Z:BTZ0VT00>XY8@00j@01JRTY:C800^T00>XY:P0
3J@00lBTY002Y004a:BTZ0ZT00?4Y:@03j@00lBTY003a003b<C400S40X@01:RTa>@2j005b>CXi>P0
0^@2j003i<CT00;X00CTj>cX1>@01<BTQ8@3I004Z<C4i0C400?8a<@00^@2a003i<C400?400?Xi<@0
0^@2j0;T00GXa>S4j004i0;X0^@02<CXj<CTa>CX0/@01>C4a>P2i0;800CXi>C80n@00lCTa003i003
a>C400;400GTa>C8j002a005b>S4j<@00/P01LC8j<C800;40lP01LC8a<RX013800?<Z>`00^`4c0;@
000018R4Q8@2Z0>400B8Y8B40j@2Q004Y8BTQ0ZT0jP4Y0:X0j@00jRTY002Y003Z:BT022T0/@2Y0;4
0Z@00jS4Y003Y003a:BT00:T00?4Y<@01j@01LBTY:C400:T4L@01JB4Q:C400;T0^P01>CXi>P6i007
j>CTi>Sdj003i006j>C4Y8QT0X@00jC8b008a003i<C400O400CTa<C80/@01>STi<@7i003b<CT00?T
00C4i>C41>@00lCTi007i004a>C4a0OT0l@3i005a>CTa>@00/@01<S4a<@2b0?40lP00lC8b00Ab003
k<S/00C<00?/c<`00]000lc@d002d00000>4R8@02X@00jB4Q004Q004Y8B4Q0BT00BXY:BT0ZP4Y003
Z:BT02FT00C4Y:RT0/@01JC4a:C400jT00?4Y<@01Z@00jS4Y004Y0;400FTa<C4Y003a005Y<C4Y<@0
0Z@00lRXQ002Q003b>ST00;T0^P2i003j>CT00?T00?Xi>P00^@2k004i>STi0;400>TQ8@00X@01<S4
a<@2b1W400[Xi>CXi<CXi<CT1L@2i0;400?Tb<@00/@01NC4a>C400;X00C4i<C41N@3a0;800G4i<ST
j002a003b<C400;40lP00lC8b00Ab003c>c800;81L`2d0;<1=001<c@e=@2d0000X@00hR4Q00BQ0:X
0j@01:RTY:@2Z0>T00>XY:P00j@2Z0BT00>XY:@00Z@00jRTY00:Y003a:BT00VT00?4Y:@00Z@2a0>T
00?4Y:@01j@00lBTY005Y0;42:@00lBTY002Y0;40j@4a003b<C400C400B8Q:C81NP00nCXi006i003
j>CT00?T00G/i>CTj002a003Y8AT00:T00?4b<@05L@00lS4a002a004b<C8a0;80l@00lS4a002a0;8
2L@2j0;400?Ta<@00/@2i0?400KTa<C8a>@3b0?400?Xb<P03lP01>c8c<P3c0?/00K<d=3/d;02d003
c=3@00S@0]@3d0;D0O@00003Q6B4016400BTQ8B40Z@018BTY8@3Y003Q:BT00FT00>XY:@02Z@01LBT
Y:C400JT00>XY:@03:@00jRTa004Y008a<RTa:C4Y<@5Y003b<BT00jT00?4Y<@00Z@00jRTa002Y0C4
00BTa<C80/@01LR4R8C400GX0n@00nSTi006i0;X00CTj>SX0^@01<BTY:@2Q003Z<S400g400?8a<@0
3<@00lS4b008a003b>S400O40/P8a003b>S400G400?8a<P00lP2a0_80^`3b0;/00C8k<c/1<`00m3<
d006d003l=3<00;@00GDd=3@e003d003e=GD00;@00CDm=C@0M@00003Q6B8009T18@00fB4Q005Q003
Y8B400B41Z@00jRTY002Q003Z:BX00JT00>4Y:@03:@00jRTY00AY003a:BT00JT0/@2Y0;40Z@01:S4
a:@2a0FT00G4Y:BTb004Y003a:BT00:T0/@3Y003b:BT00C400FTb<C4Y002Q004Y<CXi0;X00?Tj>@0
2>@01>STj>@2j0;T00?4i<P00j@00hBTZ005a003Y<C400G400>Ta<@02<@00jC4b003a004b<C4Y0?8
0l@2b0O400?8a<@00/@2b0?40/P01<C8a<P2a1;800?/c>`00n`00m38c002d003k<c@00?@0/`?d005
e=3@l?@01]@01=GDe=@1f0000VP2R003Q6B4012400>XY8@01J@00hBTZ002Y0>X0Z@01HBTZ:B400:T
00>XY:@05:@00jRTY00;Y003b:C400>T00FXY<C4Z003Y003Z<BT00ZT0/@5Y003a:C400;40Z@2a0>T
00C4b:C80l@02:B4Q<C8j>CX1>@00nSTi004i005j>CTi>P00n@01^S4b:BXY0:400>Ta<P00l@00lRT
a003a003Y<C401?400C8Y<C40/P01JC4a<BT00?400?8a<@00/@2b0;40lP01<C8b<P2a13800S<b<S<
k<c8c0?@00?<d=000/`2d003l=3@00K@00?Ed=000]001=C@d=03e003d=CD00;D0_@5e07E0M@1m000
0X@2I005Q6ATQ8P02H@00hR4Q008Q003Z:BX00:40Z@00jR4Q003Y003Q:BT00FT00>4Y:@06:@00lBT
Y002Y003a:BT00>T00?4Y:@01J@01LBTY:C400JT00>XY:@00Z@00lBTY004Y005a:BTY<@00Z@01lRX
a:BXa:P00/@01:RTa:@2Q004Y<C4i0;X0^@3j0?T00?Xi>@00^P3i004j<C4a0BT00R4Z:RTa:C4Y0C4
00BTa<C40Z@2a0:T00?4Y:@01Z@01LBTY:C800BT00?8a<@01l@01<S4a:P2b003a<S800;800?4b<P0
0/P00lC8b007b003k<c800;800>Xc<P00l`2d0;<0]000lc@d003d003e=3@00C@00?Dd=000]@2d0;D
00?@e=002]@02OSie=GDf?CDe@01n@0000ETJ6ATQ003I004Q8QTI0>400ITQ8B4R6@3Q00;R8B4R8BX
Q:B4Y:P01:@2Z0>T00>XQ:@01j@01JRTY:B400:X0j@2Z0ZT00>XY:@02J@2a003Y:RT00>T00>Xb<@0
0Z@00jS4a002Y003a:BT00FT00?4Y:@01Z@00lBTa002a005Z:C4a:@00/P02jC4a:ATY<CTb>CX00?T
00?Xi>@02n@00nS4a002a0:T0X@01:S8Y:@4a003Y<C400C400BTa<S41J@01<BTY:@3a004Y<C4a0?8
00?4Y<@00/P00lBTb002b003a:BT00g800G/b<S8c002b003c<S<00C<0]03c0;@00?<d=001M001]C@
d=C@e0;@00Wdd=3@e?CDm=@01?@3e005eMCDe?@00m@00oWde002m0;h0]@1m07h0OT00003I6QT00AT
00=XQ8@00X@016B4I6@6Q0B80X@01ZR4Y:B4Z0B400>XY8@02J@018BTY:P3Y003Z:BT00:T00>XY:@0
1J@00jRTY008Y004a:B4Y0:X3J@01<BTY:P5Y005a:BTY:P01:@00jRTa006Y0;400BTa<C80Z@3b004
a6B4a0CT0^P2i0?X2n@02LS4a:BXTZbXR002b005Y<C4a<P00/@00jC8a002a004Y<BXY0?400BTa:C8
0Z@2a004b<BTa0?800?4b<P00/P01ZC8b<RXa0o800G/b<S8c002b0;<0]000lc@d002d003c=3@00;@
00?<d=002M03e003m=CD00?D00?de=@00_@01MCdm=Cd00CD00Khe=Cde=P3e005m=CDe?@00_T2e000
00EXI6ATJ003I09X2F@018R4I8@3R0>400>XQ8@00h@00hR4Y004Q005Y8B8Q:@018@3Y003R:B400:T
00>XY:P00jP00jBXY004Z004Y:RXY0:X0Z@00lBTQ002Q003Y:RT00NT00?4Z:P00j@00jRTY004Y005
a:BTb:@00ZP01:BXY:P2Y004a<RTZ0:T00>Xb<P00/P00jBXb002Y006b:RTI:CT0^P00nCXi002j003
i>SX00;T1>P5i003a:C400:T00J4R6BTb:@2b003a<RT00;800?4b:@00/P00lBTZ002b003Z<RX00;8
00ZTZ:BXY<RXY<S41LP00jS8b002b003c<S800;800?<k<P00/P01>c<b<P7c003d<c@00?@00>`d=@0
0m000mC@d003d004e=3@m0?@0]@01?CDd=@2m0?D0_@2e0?d0]@03oSdm=CEn=GDeMShnMCEn@02n0;D
0oT00oSEn001n@0016P4I003J6AT009T00=XI6@00V@00fQTI002I008R8B4R8B8Q6@2Q003R8B400:4
00>8Y8@00X@00hR4Q002Q006Z:B4Z:BX0Z@2Z008Y8B4Z:BXY:P4Y0:X0j@2Z0>T00FXY:B4H004Y003
Z:BT00:T00>XY:@00j@00lRTZ004Y004Z:BXZ0:T00?4Z:@00j@01ZRTY<RXb0:T00BXb<RT0/P2a009
Y:S8a8ATY>C400CX00CTj>SX0n@00nSTj002i003j>C400;400S8Y:B4Z8ATZ0S800>Tb<P00/P00lC8
b005b003Z<S800?800FXb<S8Z002b003k<S800O800G<b<S8c002k0?<00?@c<`01<`3d005c=3@d;00
1m02e004d=CDe0;@00?Dm=@00]000oCDe006e007nOCDe?CDn@03e004m=CEm0;i00_heMCHnOSDn?WD
e@04n@03e?Wh00?i0MD0009X0V@01VQTJ4ATJ0AT00=XI6P00V@2J0=T00B8I8B40XP01fB4I8B8Q8P0
0X@2R005Z8B4R:P00h@00jB4Y002Q003Z:B400:400>XY8@00Z@2Z003Y:RT00:X0j@2Z004Y:RXZ0:T
0ZP00hRTY003Z003Y:RX00:X00fTZ:S8Y<RTb:RTZ:BX00:T00S4Y:BXY<S4Z0:T0lP01:C8b<P2Z0;8
0ZP02jC8b<RXb:R4Z<S400OX00?Tj>P00n@4j0;T00?8a:@00Z@2Q004H8S<Z0W800>Xb<P00/P00jS8
b008b003c<S800S800C<[<S/1/`00lS<c002d006c>c@c=3<1=000o3@d006d004e=3De0;@4=@01?WD
m=@2n005e?Cdm=@00_@01?Sin?@4n@07e?Wie?SHn@02n006e?Win?Wh0_T00oSEn002n@0000=TJ6@0
0VP01FAXI6Q800=T0VP2I0=X0f@01hQXQ8ATR8@00f@00jQXQ002Q0:80X@01ZR8R8BTQ0:800>4Y8P0
1:P2Q006R:RTZ8BT0jP2Q0:X0j@3Z003Y:RX00:X0Z@01:RTY:@4Z0:T1:P01ZBXZ:C4b0:X0Z@3Z005
a:RXZ:@00/P7Z0;80ZP00lC8b002Z0;800NXb:R4Z>S800KX00?Tj>@01n@2j0?40Z@00hBTQ002Q003
Z<S800?800>Xb<`00/P00jS8c003b003c<S800;800RXc<S8c<S<b0;<0/P2c004d<c<b0;@00S/c<c<
d<c@c0k@0]@4d003e=3D00?D00?@e=@00]@00m3De003e004m=CDm0;D00Cde=CD0o@3e0;d00GDn?Wi
m003n004nOSDn@;D0_T01OSDnOSi00Gh00?in?T00oP000=X00ATJ6A80f@00fQTI003I003J6AT00AT
00F8J6B4I003Q09T00J4I8R4J8P3Q004I8B8R0N400>TQ:P00X@2Y006Z:BTZ:BX0j@01XB8Y8BXQ0:X
00JTZ:R/Z:@3Z0:T2:P01ZBXZ:BXY0>X00O8Y:RXb:RT00>X00C8Z<RX0/P01:S8b<P2Z0C800>Xb<P0
0/P02:S8b<R4Z>ST1^P00nCXj002j0?T0^P2i0?40j@01HB8I8B/00;<0/P3c003b<c800;<00?8[<`0
0/`01:S<b<`2b0?<00G8c<c/b003c004d<c<c0?@00?<d=002=001=C@d=02e0?@00?Dm=@01=@2d0CD
0o@2e003m=CD00?D0_@2e0;h00Cde=CH0_@00mCHn003m0Ci0_P2n@06n?Whn=CH0oT00oSin003n0;i
00OheMChnOSD007E00000fQTJ004I006J6ATJ6AX0V@00fQTJ002I003J6AT009X00=TQ8P00V@00hR4
R002I009R8B8I8B8Q8R400:80X@016B4R:@3Q003Z8B400:400NXQ8BXQ:RT00>X00B8Z:RX0Z@AZ003
b:RX00FX00K8Z:RTZ<P4Z004b:RXZ0C800BXb<S80ZP01<RXZ:P5b003c<RX00:X00?<R:@01>P2i0;X
0^@01>STi>@2j003i>ST00?41Z@00fBXc005c006b<c<d<b/1l`00m3<b005c0;@0l`3d003c=3@00;@
00?<d=001m001O3Dd=3`00?D0]02e003m=3D00;D0]05e0;d0]@00oCDe003e003m=CD00;i00[hm?Cd
nOSEe?Ci0]@5n@03n?Wi00?i00?hnOP00_T02=Ghn?WheOSi0oP5n@;h0OT1e0000VP00fAXJ002J003
I6QX009X00=TJ6@00f@01FQTJ6QT00AX18P01VB4J6QTQ0:80X@00fB4R003R003Q8R800>40XP00hB8
Q002R0:X00>4R:P00ZP01JB8Z8RX00:T0ZP00hRTY002Z005[:RTZ<P03ZP01<bXZ:P2b0:X0/P3Z0;8
00BXb<S80jP3b0:X00?8[:P00lP2[008Z<c<c<R4Y>P3i0?X00CTj>SX1>@01>STi>P3a003Y:RT00>T
00>8Z<`00/`01=3<c<`2d0?<0]02c004d<c<c0;@0/`00m3<d002c0?@00?<d=002M03e004d?3De0;@
0]@00m3De004e003m=CD00;D00O@e?CDm=CE00?d1]@01?WDm?@2n@;d0]@00mGde002n@;d00CDn?Wh
1?T01?SieMD3n@09eMCin=Gin?Wh00Gi00?hnOT00_T1n07i0O@0009X0V@00fQ4I002I006J6AXJ6AX
16@00fQTI002I006R6B4J6B80VP2I006R6ATQ6AX0hP016B8J8P2Q003S6B400:400>XR8@00X@00jR4
Q002Q003R8B800:800FXR8RXY004Z004Y:bXR0nX00?8Z:`00Z`4Z003[:S800:/00BXb<R/0lP2Z005
b<c8b:`00/`00jS<[006c008b:c<d:S4b>@9j0?T0l@01>C4a<@2Y006Q:BTZ:B40m02c1;@00GDd=3<
/006d005e=3@e?@01=@01?CDe=02e006d=CDe?C@0o@00mC@e005e0;d0]@00mSdm002e004f?Cde0;h
00kdnMCdf=GdnOSde?CEn0;D0_P00mSDe004n005f?Whn?T01?P02OWhnOWhe?Sif002n@?h1oT1n07E
00000dATI002J003I6QX00=X00ETJ6QXI003J0AT0fP018ATR6P2I003J8QX009T0XP016R8Q6P2R005
I8B8S8P00X@00hRXR006R003Z8R800:800>XR8P00jP2R007Z8RXZ8RX[002Z009R:R/[:R8Z:c<00:X
1j`02JR/[:c<[:R`Z002[0?<00>/Z<`01:`2c007b:c<c=38[004c007[<c<d<bXY007j005i>SXj>@0
0nP4a003b:BT00JT00>X/=000m000lc@d009d004e=3@d0?D0]002]C@d=3Dm=C@e?02e0;@00Ode=C@
e?CD00;@0_@01=Cde?@2e0;d0m@00mGDe002e003m=Cd00;D0_@00oWEe002m004n=Cdn0;i00?Dm?P0
0_T01oCin=SdnM@00_T01?Cin?@2n005nMGin?@00_P2n@06n?Whn?Wh0oT01OSin=Gi00;h0_T2n0;i
0OP1n@000TP016QTI4@2J0AT00=XI4@00V@2J004I6QTJ09T00EXI6QXI003J005Q6B8J8P00f@2J006
Q6B8I8R41XP018b4Z8@3R0:400BXS8R40ZP2R003Q:R800:80jP2R004Z:bX[0BX0Z`01JR/Z:bX00B/
00K<[:b/Z<`2[003Z:c<00:/00>Xc<`00Z`01:R/c:`2c004d:b/b0;<00F/c:c</002[0;<00>`Z>@0
0nP3i0;X00?Ta>@00^P2i0C40j@01ZRTZ:B4Z0g@00?Dd=002]000mC@d003e0?@0]@00oCDe003e005
eMCde?@01m@3m0OD00?de?@00m@01_Sie?CEm0;D00GdeOChn@02e0;i00KhnOWhnOP2n@05m?WdnM@0
0_T3n0Gi00?hnOP00]D00oSin@02n0;i00SEnOShnOSEm0Ci0OP1n@7i000016QTI6@2J09T00=4J4@0
16@00fQTI003J09T0VP3I09X00UTJ6ATJ8R4J6@00VP00fB4J002J0:40hP00hB8R003R006Q8R8R:R4
0hP02JR8R:R4Z6R<R002Z0:80jP01HbXZ:R/00:X00J/Z:b<[:P?[003Z:b/00>/00?<Z:`00Z`01<b/
[;02c0:/1<`00jb`[002[003/<cE00;800C4j>ST0^P00nC4a002b0G40j@00jRTY004Y003Q:c@00S@
00?Dd=000]000mC@d002d004e=3@d0;D0m0<e004eMCDe0;d00?Dm?@00m@3m003e?Cd00CD00_de=Cd
e?SDm?Sdn@02e009nOSde?WhnOSi00;h00CDnOWi0_@2n007nOSdnOSin004n@03e?Si00;i00CDnOWh
0_T01OSinOWd00;h00?ieM@01?T01OSEnOWE00?h000016AXJ6P2I003J6AX009T00=XI6P00V@00fQT
J002I003J6AX009T0fP2I09X0XP01FB8Q8b8009X00V8S8ATJ8R<R6P01hP018b8S:P2R004Q8R<Z0:8
00>/S8@00XP01hb/Z8B8Z:`00ZP018b/Z8P4[0:X0j`00jR/[00B[003c:b/00>/0l`01k3<c:b`[<`0
0j`02M3<c=FXb<CTb002j003i<BT00C400?8a<@01Z@00jRTY002Y0:X00[@/=3@e;3@e=3D0]03e004
d=CDd0CD00C@e=CD0]04e004d=CDm0CD0_@00mCdm003e003m=CD00;D00?de?@00]@00oSDe002e008
m=CDn?Whm=@2n004m=CDn@;d00GDm?Whe@02e0;h00OEn?SEf?WH00;h00?DeOT00oP4n@04n?Chn0?i
00ChnOSh0oT01OSieOSE00;i00GEn=Gin003n@7h0002J09T00=XI6P00V@2J09T0VP3I09X0f@016UX
I6@4J004R6QXK0:800=TJ8@00XP2J006R6B8Q8R<0XP00hB8S004R007[8R8Q8R<Z003R004S8R4R0><
00F8Z:R<R002Z004[8b<R0:/00><Z8P01j`00hb/[009[0;<2J`01;2/[=02/0;<0k001<b`/:`4/003
R>S800;X0^@00lS4a003a005b<C4Y:P00j@00jRTZ004Y004Q:cDd0:`0]000mC@d002e0?@0m@00m3D
d008e003m=CD00GD00Gde=CDm002e008m=CDe?CDeOP6e007f?WDe?CDf003e003n=CD00;d00[DnOCd
e?SDm=Ch0_@01_WDn=GDe@;h0m@01?Wdm=P2n@;D0_P3m00Fn?Whn?CheOSDn?Whe=GieOWhnOSEn@?h
00Cif?SE0OT00003A6QT00=T00QXI6QXI6QTJ09T00AXI6QX0f@2J004I6QTI09X00B4I8QX0V@01VR4
R6B8Q0:800=TQ8P00XP00fB8R006R003S8R800F800B<R8RX1HP2S005R:RX[8`00XP3[003S:R<01:/
00B`[:c<0j`00hb/[003[003c;2/00;<0k03c006[;2/[<b`0Z`00hC8j002j0W400?8a:@00j@00jRT
Y002Y006Z:BTQ;2d1m03e0?@00Rde=3@e;3Dd0cD00?@e=@02M@01?SDe?@3e004m=CHe0;d1M@01OCh
e?Ch00;D00Kde=CEe?@2e0;h0]@02MGie=GhnMChm002e008m=CdeMSdn?@3n003m?Sh00Ki00?hnOT0
1OT00oCif003n@03n?Wh00?i00?DnOP00OP00003I4AX009T00=XI6P00V@01FQTJ6A400=X00UTJ6QX
R6A4J6@016P01VB8I6AXR09X00F8S8R8J002R004Q8R4J0:800AXR8R<18P01Xb8R:R8Z0:800><R8P0
0XP01:b8S8P2[006S:R8S:bX1J`01:R/[;07[003/:b/00:/00>`[:`00Z`2/0>/00?</:`00Z`2/0:/
00C@/;2`0]02/003[;2`00;@0k001HS4a<C800?400?8Y<@01<P2a0FT0ZP2Y003b:BX00;@00?Dd=00
0m@00m3De002e005d=CDm=@00]03e006d=CDe;3@2]@00mSDe006e003m=CD00;D0_@2e003m?Wd00;D
00Wdf?WDm?WHe=P00]@2n006e?CDe?Sd0_T01=Cdm?P2e003nMCi00;D00Cin?WE0]@2n00;m?SinOSD
n?WEnO@00_P4n@06eMCin?WD1?T01MCEnOWE00?i0OP1n@0000UTA6ATJ6AXI6P00V@014ATJ6@2J003
I6QX009X00=TJ6P00VP016AXJ6P2I0AX00=TJ8P00XP03fAXS8B8Q8QXR6QTR8b8Q004R003S8B<00B8
00V<R:R<R8b8[8`00hP3[005Z:b/[8P02Z`00hb/[00<[0:`0j`2/0>/0[001jc</;3@/:`01k000m2`
I002b0?42/P2Z0VT00>X[=000m02e0;@1]@01=2`d=06e003d=CD00SD00G@e=CHe002m0GD00?de=@0
0_@7e003m=CD00?D00Sde?SdeMSDf0?D00Che=Cd0]@01OCHnOSE00;D00[he?CDn?WDnMCE1?T00oSD
m003n@;h0oT03?SinOWhnMCin?Wdn0?i00GDnOWhe@05n@0000=TJ6@00VP3I003A6AT00=T0VP00fAX
I002I007J6AXJ6AXI002J006I6QXJ6B40fP02XR4R8QXR8AXR6P;R003J8R400>800><Z8`00XP00hb/
R003R004Z8b8R0f/00><[:`00Z`018b/[;09[0:`0Z`2/0B/00>`[:`01k000mB`/002/007d;2`/8S8
a002b003a<S800;80^`00lS<c002b0ZT00>Xc=@00m02e006d;3De=2`1=@01M3De=C@01?D0o@3e0;d
1m@01?CDe=@2m0?D0_P3e003n?CD00;H00Kde=CHe?P2e004n=Cdm0;D0_P02]Cin?Whe?SdnM@3n@03
m?SH00;i00?dnOT00_P2n@05eOWie?P00_T00mChn@03n007nMGin=Cin004n@000VP2I003J4AX00ET
00Y4I6QXI6QTJ6AX0V@00fQTJ002I005J6ATJ6@00VP01HQXI8aX00:800MTR6R8Q6B<00B400N<J8R8
I8aX00>800>/R8P00X`01jbXR:R8Z8`00hP00jb8[003[003Z8b/01>/00J`[:b`c;02[003/:c<00J/
1[001=2`d;02d0>`00K@e8S4b<@2b005k=3@k<`00]001<c8b<P2Z0>T00>XY:@00Z@00jS<d003e003
d=CD00[D00?@e=@00]@01]3De?CDd0CD00?@e=@00m@01?Sie?@2e004m=CDn0;d0]@01?Chm=@2m006
n=Cdm=Sh0_@00oSdn@02e00=m?She?SDm?Sde?Whn@03n0;D0_T01OSDn?Si00;D0_P00mSde@02n003
nOSh00Ki00?hnOT01?T2e006n?WEm=Gh0_T00oSEn@02n@?h0002J006I6QXI6QT0VP00fAXA002J0=T
16P2I0=X00=TJ6@00f@2J09T00B4R6QT0VP2R005I8R8R6P00X@00hR<R007R0:<0XP01hb8R8R<Z8`0
0XP2[003S8RX00>/00>8Z:`00Z`00hb/[00=[003c:b/00J/00N`[:b//:b`00:/0[02[003/=3D00:`
0]03/0?@00F`d8S8j002b004k=3`d0;`1=000lbXZ002Z0>T0jP01ZBXd=C@/0?D00>`e=000]@2d0;D
00?@e=@02=@00oCDe00;e003m=CD00;D0_@02?SEe=Cim?WD0_P3m005e?SDnO@00_P01MCinOCi00?d
00Che?Ci0_P01=Cde?T2e004m?Wie@;i0_P2e003n?WE00;i00KhnOWim?T2n0?i00KEnMGhnMD3n@;D
00?dnOP00_T01=GinMD3n@7h0OT1m00000AXI6Q40f@2J0=T00=XI6@00V@016QTI6P4I003J6AT00=T
0VP2I006R6QXQ6B80VP016B4R6P2R003I8b800F800B4Z8R<0hP00jR<R002Z00:[8b8R:bXS:b8[0:<
00>8Z:`03J`01<b`[8`3[003c:b/00F/00G</:b//003[0:`00>/c<`01K000m2`/002d003/=2`00;@
00f`S:C4b<c@l?CDl=3`00?@0/P2Z0BT00>XY:@00ZP01M3Dd=C@00;D00?@e=@01=07e003d=CD00KD
00?@e=@01]@01?CDe?T4e0?d00Che=Cd0m@2m0;i0_@00mCdn002m0;h00Gim?Chn@02m003e?Si00;d
00Cin?Ch0_T01MGhn?Wh00Ci0oP00mCie@02n@05n?WinOP01_T01MGin?Wh00?i00?DnOT00oT01=Gi
nMD4n@7E0OT00006J6AXI4AX0V@014ATI6@2A0AT00=4J6P00f@00fQTI003I005A6B4I8P00VP00hAX
J002R006Q8QXR8AT0VP3R003J8R800F800>XR8P00XP01JR8R8bX00:800J/Z:R/R:P2R0B/00>X[:`0
0Z`00jR/S002[004R:b/c0:/0[03[003/:b/00:/00>`c:`00Z`00k2/[003/0:/0k001Lc@/;3<00B`
0]02/003d:bX00;800?@e?@00_@01M3Dm=C@00;<00>/Z:@00ZP5Y0:X00C@e=3D0m02e003d=CD00;D
00?@e=@00]@01=3De?@<e003m=CD00;D0_@2e003f=Cd00;D0o@2e0;H00CDm?Ch0]@00oSDn002e0?h
0]@00oSdn002e0;h0_@2n007e?Sdn?WDn@02e@04nOCdn@;h00?Dn?P00_P4n@;d00GhnOWie@02n@03
n=Ci00;i00ChnOSh1?T02?SinOSieOWD0_T1e@000V@00dATI002I09400EXI6ATJ@03J09T00AXI6QT
0fP01FAXJ6QT009X00ITJ6R8J6@4R005J8R8I6P018P018ATS8P2Q003R8b800>800NXR8R4R:b<00>8
0X`02HRX[:b8Z:b<[002Z0B/00>X[:`01Z`00lb//002[0;<0j`00lb`/002[003c;2`00J/0[001=2`
d;02d0>`00?@/;000m001;2Xb<`2m0?h0_@01=Cde=02c003[:RX00:T00JXY:BTZ<`2d0?D00?@e=00
0]@00m2`e00>e003f=CD00WD00?de?@01=@00oCDe004e003m=Ch00;D00Cde?SD0_@01mChnOCDm?P0
0_@00oWhn003m005n=Gdm?P00]@01?Sie?@2e0;h00Sdn?Win=Cin0?i0_@02?Wdm?WheOSd0oT02]Ci
n?Si]?Sin?T2n003eOWi00;i00ChnOWh0MD00005I6QTI6P00V@014ATJ4@3I003J4AX009T00=XI6P0
26P016AXI6@2J003R6QT009X0XP00hB<J004R006J8R8Q8QX0XP00hB8R003R003S8R800B80X`00hRX
R002[006R:RX[8bX0Z`2S003[:R/01B/00>`[:`00j`00lb//002/005c;2`/=002K03d0>`00F4b=3D
m002n0?d0]@2d003c:S800>X1:@01:RTc=02e0?@0]@00oC@e007e003d=CD01CD00?de=@00]@00oCD
e@02m0?D00?Hm=@00]P2m0;D00Che?WD0_T00oCDe002n004m?Win@;h00KDm?Sdn=D2n003m=SE00;i
00Kdn?WhnO@2n@;h00?ie?P00_T01MChn?SD00;i00chnMCDeMCheMChnMP2n@;h00Sie=GieOWEn07i
00000fQTI005I003J6AT009T0VP016AXI6P3I09X1F@016QTI6@2J008Q6ATR6R8I6P3R003I6R800:8
00J4R8R4R8@4R003Q8R800J800F<R8R8S002[0:X00B<[:bX1:`00jR/[00:[005c:b/[<`01:`00k2/
[003[003/:b/00:`0Z`00k3@c002/003d;3<00R`0m001;2<b=03m0;h0_@01]Cdd=3<[0BX00>4Y:P0
0Z@00jS@e002e0;@0]@00m3De002e003d=CD00CD00?de=@02m@00oCDe002f006m=CDf?CH0]@2m003
n?CE00;D00Gde=Cdn002e0;d00?Dm=@00_P01]Cdm?Cie0;d0_P01mChn?Sdn?@00oT00mChn002n004
nOSin@;D00ChnOSd0oT01OCinOWD00;i0_P01OWheOWh00;D0oT01MCin?SD00;i00KEnOShf=D3n@00
00=XA6P016@016QTI6@2J003I4AX009X0V@016QTJ6P2I004J8QTI09X00>8I6@00VP01XQXI6R8J09T
00J8J8QTR8`:R003I8R800B800>XR8`018P018b8Z:`2S0F/00F<[:b/S004[008R:b/[:R/c;03[0:`
0j`00k2/[002[008/<b/c;3@/:`4/006[<b`/:b`0]02/009d=C@d8S8e?Wd00;h00?in=@00_@01MC@
[<b/00:X00BTZ:BX0Z@00jS@e004e003d=CD01SD00GHe=Cdn003e005n=CDe?@01=@00oCDe003e006
f=CDm?Sd0]@2m003f=Cd00;h00Gde?Wdn002m00<nOSDe?Cin=CdnOSi0_@00oSHm002n003e?SD00;d
1_T00oSDn@05n@09n?Win=GDeOWd00?i00ChnOSh0_T01=Gie=D3n@000V@2J005I4A4I6P016@2J006
I4AXJ6AX0V@4J004I6QTJ09T0fP016B4J6P3I006S8QXJ8B<0XP00fR4R002R003Q8R800>800B4R8RX
18P00jR8R003R0:<0XP00jR<S004[005S:R/[8`04J`00k2/[002[003/:b/00:/00N`[:b/d;3<00B`
00N//:b`d;3<00;@0[001M28[=3d00?h00Oim?Sde=3<00:/0jP01jBXY:B8Q:@00]001=Bdd=04e003
d=CD00GD00?de=@04=@00oCDe006e005eMCdnMP01]@01?Cim?@3e005m=CDm=P00_@3e0;d00ODeOWd
nMCh00;i00ShnOWHe?SDn0;d00Gin=CDn002n@06n=Cdn?Ci1?P00oWhn@02n004nMSin0;i00GDnOSh
n@02n004eOSin0Oi0003I003J6AT009T00=XI6@00V@00fQTI002I003J6AT00=X0V@00fQTJ002I003
J6AX009T00QXR6R4I8QXR0:40hP2Q003J8B800F800>4R8P00XP018B8R:P7R0:<0hP2S003Z8b<00B/
00><[:`06J`01K2/c;2/00N`00>//;000k001:b`/=02/005d:bXd?P00_T01?SEn?P2e006d;3<[8R/
0j@00hBXQ002Z003/=C@00;@00?DeM@00]03e003d=CD00[D00?@e=@01M@01MSDe=CH00CD00CHe=CD
0o@3e0;d0]@00oWde005e004m=CHe0?d00Gim=Cim002e0?h00?de?P00_P2e@03e?Wd00;D00?in?P0
0]@3n007e?She?SDn004n@09n?WEn?WheMCH00;h0_T3n006nMCieOWD0_P00mGie@01n@0000EXI4AT
J002I003J6AX009T00EXI6QTJ002I0=X0V@00fQTJ002I0=X0V@3J09T0VP018QTI6P3R006Q8R8R6B4
0hP01HB8S8R400:800><Q8@00XP00hb8R002R005[8R8Z8P00Z`01XR<[:b<Z0B/00>8[:`04Z`00k2/
[002/0>/0[02[004/=2`[0Z`0m001k2<[?ChnOP00_T00oSdm002e005/<b/[:P00Z@2Z0:400FT[=3D
d003e0;@1m@01=3de=P6e007d=CDe;3Dm008e004n=SDe0?d0m@00oSde@02m0CD00Odf=CEe?Ch00;D
0_@00oSDe002m003n=CD00;h00?im?T00_P01_Wdn?SEe0;i0]@3n0CD00?Hn=D00oT00oSin003n@03
e?Si00;h00WDnOWDm?WhnMD00_T01?SEnOP4n@;h0MD00004J4AXA09T00=4J6@00V@2J005I4AXI6P0
0V@00fQTJ002I0QX00B8I8QT0XP01fB8R8QTQ8P00VP3R003J6B400>800F4Z8R<Q005R007Q8R8S:R8
Z002S003[:R/00:<00b8Z:b/S:bX[:R<[8`8[003Z:b/00R/00B`[<c<1Z`2/003c;2`00:`00C</;3@
1[000m2`/002[003m=Gh00Ch00[de=CD/<b/R:bX0Z@01hB8Q8B/d=@01=02e003d=CD00;D00F`e=CD
d005e003]=CD00kD00?de=@01]@2m0;D0_@01MCHe=CH00GD00GHeMCDm002e003m=Ch00;h0]@04oSi
nOCDn?CEm?WEm?SDm?Sim=@00_P00mCEe002n@05e?WhnOP01OT00mCin@02n@05e?ShnM@00_T01_Si
nOSie@?i00ChnOWD0MD0009T00=XI6@00f@01TATI6AXA0=T00=XA6@00V@01FQTI6QT00AX00=TR6@0
0VP01fB8J6R8Q8P00VP3R09X00B8I8QX0XP2Q0>800B4R8R<28P00hb8R002R006S8R8[8b/0XP4[003
S:b<00J/00><[;002J`2/0>/00F`[;2`[005/003d;2`00:`00G@/;2`d002/0C@0Z`00mCin@04n007
m=CDd;3<[003Z0B400J8Q:cDd;02e0C@00?Dd=@00m@01]3De?CDd0SD00?@e=@00]@00m3De009e004
n=CDe0;d00CDm=Ch0]@01?SDe=P2e005n?CDe?@00_T2e005f?SheM@00_P2e006m?Whn=Ch0]@01OCD
e?SD00?h00?ie?P00_P3e003eOSh00Gh00Kin?Whe=P2n@03f=GH00;i00GhnOWie003n005eOSinOP0
0OT00004A6QTJ0AT00=XI6@00V@00fQTJ002I003J6AX009T00EXR6AXI003J09T00AXR6AX18P02FQT
J8QTJ8B8Q002J0F800R4R8R<R:R<R0><0XP2S0>80X`00jR8S002[0>80Z`2Z0>/0ZP00jb`[00<[004
c:b/[0:`00>//;000[02[003/=2`00>`00?@/:`01[001=C@/:`2d004[=CEe@;h00?in?P00]@01=2`
c:`2Z008R:B4R8B8Q:`2d003e=3@00?D0]03e003d=CD01;D00?He=000m@00mSDe005e003n=SD00?D
00?He=@02=@00oWhe002e003m=Sh00?D00Che?Wd0_T02OSDm?WhnMShf005e009f=CEm?Whe?WH00;h
00Gin?Wim002n0Gi00Ohe=CieOWE00;h00KieOWHnOP2e0;i0MD1n@7h000016QTA6P3I09400IXI6A4
I6P3I003A6QT009T0VP00fAXI002J007I6QTJ8QTR002J003R6AX009T00>8Q6@00VP00hb4Q003R005
I8R4R8`018P2S005R:R8[8`00hP2S003R:b<00:<00B8Z8b/0ZP2[003S:RX00n/00>`[:`01:`2c0B/
1;000lc@/007/003d;2`00:`00g@/=3@c?CieOWEnMSd00?D00C@[:bX0X@00jB4R002Q003Z;3D00;D
00?@e=@00]@01=2`d=05e003m=CD00GD00?@e=@01m@00oCDe008e004m=CDm0;D00?Ee?@00m@00oCD
e003e004m=CDe0;d0_P01MCde?Si00?d0oT03]GhnOWde=GDn=Che?Wh0]D01MChe=Ch00;i0oP01=Ch
nOT2n004e?Win@;E00?Dn?T00]@00oWhf003n@08eMCDeMSim=@1n00000ETA6ATJ004I003J6AT00QT
00I4J6ATJ6@2J004I6QXJ09T0fP01HATJ6R8009T0VP01hQXI8QTR8@00XP01VR8Q8R<Q0N800>4Z6P0
0X`01hR/R8b/R:P00h`2Z003R:b/00:X00><[8`00Z`00hb/[00>[0:`0Z`00k2//002[003/<b`00>`
00?</;001K001=2`/;02d0>`00GdnOSEn@03n0;D00?@/:`00Z`01JR8R8BX00:400B8c=3@0m@01=3D
e=@2d0CD00?@e=@06M@01MGDm?Sd00;D0_@2e003m=CD00?D00Kdn=CHe?@3e0;i00CDm?Cd0oT2n003
nOSi00Ci00Che=Ch0_T01?SDn=@2n@03e?WH00;i00OdnOWie=Gh00Oi00KEe?WEnM@2n@;D00KhnOWh
eOP2n@03e?Wi00;i00001FAXI6A400MT00=4J4@00f@00fQTJ002I004J6AXI0=X0f@00haXI002I00D
R6QTI6R8I8R4J8QXR8B8S8QXR8@2R009S:R8S8R<R6R800:<18P018b/R8`3[0:82:`00hR<[00>[003
/:b/00B/0k03[0>`00B//;3@0k02d004[;3@d0:`0m000jcDe@02n004nOShn0;D0]02[004Z8RXZ0:4
00N8Q:R`d=GD00;@0m@2d0SD00?@e=@03=@00oCDe006e003m?SD00;D0o@2e003n=Sd00;D00Che=SD
0_@4e004m=Cdn0;i00?Dn?T01?P01oWhm?Cin?T00oP00oChe@03n@03f?Wh00;i00WhnOWhf=ChnMD0
0oT00oSin@03n@03n=CD00?i0]D00oSHn@02n@04eOWEf0;h0M@1n@7D0002I008J6ATI4AXI4@2I006
J6A4J6AX0V@00fQTI002I003J6AX009T00>8I6P00V@00hQXJ002I003J8R<009T18P018B<Q6P2R003
S8QX00B800B4R8R<18P01Xb8R:b8S0:80Z`018b/[:P2S0>/0X`3[004S:b/c0:/00B<[:b`0j`01K2/
[:b`00>/0k02[0>`0Z`3/003c;3@00>`0]001;3@d;03d006/?SieOSi0_P01OCDm=C@00:/00>XR:P0
0h@00hR4Y002d003e=3D00KD00?@e=@01m@00m3Dm002e003d=CD00gD00Kde=CDm?P4e004f=CDm0CD
0_@00mSDm003e004m=Cdn0?D0_T01OSin?SD00;d00SEnOSdn=Cin0;i0]P01MGDnMGi00;d00?ie=@0
0_P00oWhe005n@;h00?in?P00_T01=SDnOT2e@03n?WD00Ki00?He?T00OT000QT00=XI6P016@2J004
I6QTJ09T16P016AXI6P2I0=X0V@2J003R6B4009X00>8Q6@00hP00fR4R002R003Q8R800>800=XR8P0
0ZP3R003Z8b800:800BXS8bX0j`01hbXZ:b<[:P00j`00hb/[009[003/:b/00Z/00?</;000Z`3/005
[;2`/=000[000m2`/003/00;d;3</=2/n?WEn?T00_P00oWde002d0>/00VXR8R4I8B8Z=000m@00mG@
e003e003d=CD00OD00G@e=CDd007e003eMCD00OD00Ode=CDf=Cd00?D0_@2e003f=CD00;D0o@02?SD
n=Cdf?Sd0]@01=Sin?P4n@04m?Sim0;i00ODn?WieMCi00;D00gHnMGEnOSDn=Cin=Ci00?h00Cin?Wi
0_P2n@06eOWie?SH0]@00mGin002n0Ci00?hnOP00M@000=T00=XI6@00V@00fQTI004I004A6AXJ0AT
0VP016AXI6P2I0=X0f@2J0:400ITQ8R8Q6PHR004S8R8R0:/0ZP01Xb/[:bXS0>/00FX[:b/Z00=[004
S:b//0:/0[001<b/[;02[004c;2`/0:/00G@/=2//003d0:`0m02/005[=C<m?T00_P01MGhn?Wd00;D
00g@/:b8S8BXR6AXQ:S@00CD00?@e=@00]@01M3De=C@00OD00?de=D01m@01=3De?@6e004d=CDm0CD
00Khe=Ghe?@4e003m=Cd00;D00?ieOP00m@02OCinMCim?Sie003n@06e=GinOSE0_T01OSieMCE00;h
0]@01?WhnM@2n0?D1?T2n0Gi00?he?T00_T2e@03e?Sh00?h00CieMCD0_P1n@7D0MD00005J6ATI6P0
0f@2J0AT00=XI6@00V@00fQTI002I003J6AX009T00>8I8P00V@3J09T0VP018QXQ8`2R0:400J<R8QX
R8`2R005J8R<R6P00XP2S0:800><[8P00hP00jb<R003[003S8R/00:/0X`4[003Z:b/00:/00><[:`0
4:`00k2/[002[0>`0Z`00m2`/002/0K@00>`d=001=000jchn002n003eOSh00;d0]@01[2//:b8I0:8
00IYI6BXd=@2d0CD00C@e=C@1=@00m3De007e003d=CD00SD00Gde=CDm004e003m=CD00;D00Gdn=CH
e002m0;D0_@00oSDe002n0;D0_T01]She=Cin0;i0_P2n@06m?Win?Wd0_T01_Cin?Sim0;i00?Em?P0
0_T01MCEnOWh00?d00?ieOT00_@3n@07m?Wie?WDn002e@08n=Cie=GieOT2n07i0MP1e00000=TJ6@0
1fP3I09X0V@3J0=T0VP00fAXJ002J0=T00N8J6R8I8QX009T0VP01XaTI8R<J0R800><R8P018P2Z0B8
00B/S8R80j`2Z0:/0XP00jR/[002Z0B/00><[:`04:`00lb//002[003c;2`00:/0[000jb`/002d0>`
0]03/004d;2`/0;@00>/m?T00_P01?Whn?P2e0;@00>`[8P00hP2I003J8S800;@0m@2d0?D00G@e=CD
m005e003d=CD00cD00?He=@02m@01?Cie?@5e004f?SDm0CD0_@01OSDn=Cd00;H0_@02OWDe?CDnOSD
n@02n0;i00Gdn?Wie003n@?d0_T2m003e?WD00Ci00KhnOShnOP2n@0;f?WDe=GDn?Chf?P00_T01=Ci
n=D2e07h0MP1e@0000=TJ6P00V@00fQ4I003I003A6AT00IT00=XI6@00V@026QTJ6AXI6QT0VP00hAX
J@02I005R6QXI8@00XP00fB8R004R003Q8R800>80X`3R008S8R4Z8R<R8@2R0:<00B8[:b<0ZP00jbX
[002Z0B/00>X[:`00j`00hb/[007[004/<b/[0:`00?<[:`00[001lb/[;2/c:`00k001M2`/;3@00>`
00C@/;2`0]001:cdn?T4n0;d0]@00m2/[002S008R6ATA6R4b=02e003d=C@00?D00?@e=@01]@2d1kD
00?He=@00]@01_CDe=SDm0OD00Gde=Cdn002e004nMChf0;D00GEn=CDn@02n0;D00CHn?SD1?P01]Ch
n?Whe@;h00?de=@00_T2e@0:nOSieOSin?CEe0;h00ODn?Win=SD00?i00?EnMP00_P1m07i00001VQT
J4ATJ09T0T@2I003J6AT009T00IXI6AXI8P2I00:J6AXJ6AXR6QTA09T00=XI6@00f@00hQTJ002I003
J8R800:800=XR8P01HP01hB8R8R4R8`01HP028b8R8R<[:R80X`01:bXZ8`2[003Z8R/00>/00>X[:`0
2:`00k2/[002[0:`0j`00k2/[002[003/<b/00:/00>`[:`00]03/003d;2`00:`0]02/005[?CheOP0
0_T00oSdf002e005/:b/S8P00fP0141TI:`2e0;@1m@00m3De007e003d=CD00CD00?de=@01=@00m3D
m009e005f=CDe=P01=@00oCDe002e004n=CDm0;h0]@00oSDn002e00;n?Wie?WDf?SDnMD00]@01OSi
n=CH00;i00?he?@00oP2e003n?Wi00;D00CHnMSD0oT03OSinOSie?Sie?SDnOP00]D2n@;h00CDn?Wi
0]@1f07h0OP0009X00e4J6A8J6AXI4AXI4AT009X00ITJ6QTJ6@3J09T00=XI6@00V@00hb8I002I0:8
0V@00hB8R002J007I6b8Q8R4J002R003S8B800N800AXR8R80X`01HR<R8b/00:80Z`00hb8Z002[008
S8RXS:b<Z8`7[003S:b/00B/00?<[:`00j`00k2/[002/0>/0k000jb`/002/003[;2`00:`00>//=00
0k002M2d[=CieOWhn@02n0?D00O@[8b<R6QT00940VP00hB`d002e0;@0m@00k3@m002e003d=CD00;D
00?@e=@01M@00kCDe00<e003eMCD00?D00Gde=CDd00=e006m=CDf=Ci0m@2m008f=GDeOWDnO@3e004
nMCDf0?D0]D3e00:n=CHn?CHnMCin0;i00SdnOChnOCin0?D00Gie?Whn@02e008eOSinOSEe?P2n@;D
0002J004A6ATA0=T00=XI6P00T@016QTJ6@2J003A6AT009X0f@3J09T00AXI6B80VP2Q008R6QXR6AX
I6P8R003Q6R800:800=XR8P018P2S004R:R8S0>80X`2R005Z:b/S:P00j`00hRX[002[003S:b/00Z/
00G<[:b//002[003c:b`00:/00B`[;2`0Z`2/003[<b`00:`00?</;001K02d003[=Ch00?h00WEn?Cd
e;C@c:P00XP2J005I4ATI:P00[03d003e=3D00;@0[@01=3De=@2d0CD00?@e=D03=@00m3De00Je003
n=CD00GD00Che?SH0]@01]Gie?Cin0;D00Cde=Gd1=@01OSdeOWd00;D0oP01=Cde?P3e0;i00Whe?Si
n=CEnOP00_T02MCinOWEn=Ghn@02e004n?Che07i00000fQTI002J004I6QTJ0=T00=4I6P00V@00dAX
J002J005I6QTJ6@00VP3I003J8QX009T00IXR8QXI6P2R09T00AXR6QT0XP01Hb8I8QT009X1hP2S003
R8bX00>800>/Z8P00XP2[003S8RX00:/0XP3[003R8b/00B/00?<[:`01:`00hb//004[003/:b/00:/
00>`[:`00k02[0B`0Z`00k3@[008/003S=3i00;h00Cin?Sh0]@00m2`[004S003JDA4009X00>//=@0
0]@00m2`d002e003/=3D00KD00>dd=@01M@00m3De006e003f=CD00[D00SHm=CDd=Cdf0;D00?de=@0
1m@03?SDe=Che=GDm=CEe0?h00OHeOCDn?WD00;h00Gie=CDn003e0;h00?En=@00_P4n@09n=Chn?WH
m=Gi00;D00CEn=Gi1=@01?WHnOT2n005m=ShnM@00OT00003I4AX009T00=XI6P02F@01VQTI6QTJ09T
00=XI6P00V@3J09T0VP00faTI003J003I6R8009T00>8I6P00hP01HB<J6R400V800><J6`018P00hb8
R003R003Z8b<00:800>/Z:`00X`3[0:<2j`01Hb/[8b`00B/00B`[:b/0k02[0:`0Z`01/c@/;3<d0:`
0Z`4/005R=3hnOP00_T01?Sdm=@2/0:/0X`00fQTI002A004J:c@e0?@00>`e;000]02e003d=CD00CD
00>`e=001=@00m3De002e003d=CE00GD00?Ee=@03M@00mSDe008e003n?WD00;D00OHn?CDn?WH00;D
00CHn=Gd0_T00mCim002e@03e?CD00?D00Che=Ch2=@01?Sdn?P2n@06n?Cie?WD0]D03]Cim=CEe?Si
n=ChnMCi0]P1n07D0MD00004J6AXA09T00=4I4@016@00dATI007I003J6AT00=T0VP2I09X00B8I6AT
0VP2I003R6QX009T0VP016B8I6P3R003I8R<00:800AXR8b41XP01Hb8R8R<00B80h`01:R8S8`4[004
S:R/Z0B/00><[:`00Z`00hb/S00:[003/:b/00>/00>`[:`00Z`01;2/[:`2/003[;2`00F`00>/d?@0
1OP00oChe002/0><00>8J4@00d@01fV/d=2`d;000]001;2de=@2d0CD00Bde=C@0m@00m3De00>e003
m=CD01KD00?He=@00]@01mGDe=Cde?T01=@01=GheMD2e004n=CDe0?E0]@01?SDeM@2n@04f=GDn0?i
00Gdn?Wie002n@06n?CDe=Gi0]@01OWDnOSD00;i00Chf?SH0m@2n07i000014ATI4@3I004A4QTA09T
00=XI4@00V@01VQTI6QTJ0AT0VP2I09X0V@01VQTK8AXI09X00>8I6@00fP01fAXR8R4R6P02XP01JR8
R8R<00>800B/S:RX0X`01:bXR8P2[003Z8R<00B/00><[:`04:`01K2/[:b@00V/00F`c;2//002d006
/:b`d;2/0m001:c@n=D5n004m=C@/0:/00J8S6QTA2@2J003[=3D00;D00J`d=CD]=04e003d=CD00;D
00>`e=@00]@00m3De005e005d=CDm=D00m@01_CDe=CEm0CD00?de=@02m@01MGDe=CE00?D00WheMCD
f?SHeOP00oT01]Chn?WDe@;h0_T00mGie002e0;h0_T01=SDn?P2e0Ci00GhnOWEn002n@05f=Gif?T0
0]D00oWhn002e@?h0m@00oWDe001e@0000EXI4ATJ002I003A6AT009T00A0I6AX0f@3J003I6QX00AT
0VP2I09X00=TR8@00fP018QXI6P2R003I8R<00:800ETR8b8I002R003S8R800:80X`3R0:<0XP2[0:8
0ZP01:b8R:P3[003R:b/00:/00B8[:b<2j`00hb/[003[003/:b/00:/00B`[:b`1J`2/0F/00B`d=2/
0]001[3@/;2<e0Kh00KDm?CD/:`2S008R6ATA4Q4I<`3e003d=CD00;@0m@00m3De002e003/=CD00OD
00?@e=@02M@00oCDe006e003f=CD00oD00?de=@00]@01oCDn=Cde=D00]@01_SHnOWhe@?D00Odn=CD
n?Wh00?D0_T2e0?h0]@2n005nMCieM@00_T2n0;i0]@01OSDe=SD00;i0m@02?SEm=Chf=Cd0]@00003
I6QT009X00UTJ6AXA6AXA6@00T@2I004J6ATJ0IT0VP3I09X0V@01FR8J6B400:80VP01HQTR6R400:8
0VP<R003S8R800><0XP00jR/S003R0:/00>8Z:`00Z`2Z003[8b/00:80j`00hbX[00@[003/:b`00:/
0k02[0:`0Z`01lb`/;3</=000[03d003S=3h00Kh00Ode=3@[:R800=X00E0I4AX/003d003e;B`00;@
00?D/=001=@00m3De002e003d=CD00SD00?@e=@02M@00m3De006e003m=CD00[D00?Ee=@00]@03OWD
n=Cde?CDn=SDeO@00_P00mChe004e005f?WDe=D01=@00oSim002e003eOSi00;D00?ie?T00oT4n006
nOSDe?SH0m@02oSie=ChnOSEe=Sd007D000016A4I4@2I005A6ATA6@00T@5I004J6ATJ09T0VP3I007
J6ATI6QTJ002I003R6QX009X00Z8J8QXI8QTJ8QX0hP01fR8R8R<R8@00XP00hb8R002R003S8R800:8
00><Z8P00XP00hbXQ003[0:X0j`2R003S:b/00:X4j`00k2/c002[0:`0Z`2/004d;2//0;@0k000m2`
/002/005d8c@n?T00_P00oWhn002e0;@0Z`01HQXI4AX009400=T[;000]@4d0;D0]03e003d=CD00;D
00>`e=D04]@00oCDe003e005d=CDm=P00]@2m004nMCdm0?D0o@2e006m=CDf=Ci0m@2n004nMChn@;h
0]@01OSie?Si00;h00SDeOWie=GDn0;d0_T00oSDe002n0Ci00GheMChn@02n0?D00Khe=Cin=P3e004
nOSDf0?h0]@00003B4AT00=T00AXI4AX0f@00fQTA002I09X0f@00fQTI002I003J6AX009T00=XI6@0
0V@3J004I8AXR09T00B4J6QT4HP00hb8S002R004S8RX[0:80h`01HRX[:b<00:80j`00hbX[003[005
Z:b/[:P03j`01;2/[:`3/003[<b`00:`00C</=3@0[000jc@/003/003d8c@00Kh00_de=C@/:b<J8QX
I002A003J8b`00;@0m@2d0?D00>`e=@01]@00m3De00Se00;m=CDm=Sde?CDf?P00m@02_CDnMCEm?Si
e?@3n007eOWie=GDe@02n0;D00?EnM@00]@3n@;D00She=CDnOSDn@;d1?T00mCie002n003eOWD00;D
00SHnMCDn=Cim0?D0OP1e0000V@00dA8I003I003A6AT00AT00A4I6A416@00dATI002I004A6QTJ0UT
0VP00fB4I002J003I8QX00B800ITR8QXR6P2R003I8R8012800BXR:b<0ZP2S0:X00>/S8`01:`00hR/
[007[003S:b/00F/0[03[003/:c<00:/00F`c<b`[002/0:/0k001]2`d;2<d0Kh0m@01=2`[8`2R09T
00e0A6V`c=2`d=C@e;3@00WD00C@e=Bd0]03e005d=CDe=D00]0<e003m=CD00OD00Sde=Cde?CDf0CD
00OEe=CEn=Cd00?D0_P00oCDe002n@;D00CHnMCD0_T01OSDf=Ci00;D0_P01_CDe?SDm0;h00Cim=Ci
0oP00oChn@02n003e?WH00;i0m@01_SDe=Sim0;D00Chf?SD0OT00006A6A4I6Q40f@00fQTI002I003
J4AT009T00=XI6@00V@01fQTI6QTR6P00f@00fQTJ002I003R6B8009T00N8J6AXI8QX00:800ITS6R4
R8@:R003S8B800:800B/R8R80ZP2R005S:R/R8`00j`01JR<[8RX00:<5:`00k2/[002[003c:b`00:`
00B//:b`0Z`6/0;@0[000hcdn004n005f=CDe=000Z`00hR/J002I006A6AYn]3D0]001[3@e=3D/0;D
00?@e=@00]@00m3De002e005d=CDf=002M@00m3De004e003m=CD00KD0_@2e003m=CD00;D00Cdf=Gd
0]@02?SDe=Sdn=GD0_P03MCde?WhnMCHn=GDn=P00m@01_Whf=Chf0;h0_@2n0;D0_T02?SDe?ChnOSi
0_P01=SEn?T4e006nMChf=Ch0]@2n004eMCDn@;h00001FAXI6A800=T0VP2I003A6AX00AT00AXI6A4
0VP3I004J6ATI0=X0V@2R009J6ATJ8QXI8AX00:800=TR8P00XP01VB8R8b8J0:800><R8P018P00hb/
R002R0:<0hP3S0:81j`2R004S:b/Z0n/00>`[:`00Z`01;2/[:`2/0>/00C@/:b/0k02[003/=2`00:`
0]000fS@n003n005m=Sde=000[000jb8Q003J09400EYn[2`d002e003d;3@00;D0m02e0;@00CDd=C@
4M@00m3De008e003m=CD00OD0_@01=Cdm?@4e005f=CDn?T00m@00oChf002e007nOSde?Sie@02e003
f?SD00CD00?hm=@00_P01]Ghe=Che0;d0_P2e003n?Wi00;d00?he=@01]@2n0?D00Oie=SDn=CE00;D
0002A006J6A4I4AX0V@2A09T00A4I6AX0V@00dATI002I003J6AT009T00=XI6P00V@00hQYJ002I0=X
00R4I6QTJ6B4R09X00>8Q8P00XP2Q003S8R800J800B4S8b41hP018b8R:P2S003Z8R/00:<00>8Z8`0
0X`3[003Z:b/00>/00><[:`02J`00hb/[005[004/:b/[0>`0Z`00m2`/003/005d;3@S=@01?P00oWD
e002e003/:b800:800QXI6ATA6Wj/0;@00Bdd=3@0[02d003/=3@00;@2m@00m3De004e003d=CD00kD
00?de=@02M@00mSDe002e005eMSEe?P01=@04?Sde=GDn?CDeMCin=CHe?P3e008n?WDm=CHe?T3e0;d
0oP01=Cie?P2m007n=Cie=GDn@02e009eMChn=Che=GH00;D0]P3e00000A8A6A40V@01DATA6AX00=T
00=XI6@00V@2J0UT00=XI8@00V@01VQTI6AXR09T0fP01FB4I8QX009T0VP018R4R8@3R003Q6R800>8
0V@00jQYR002R003Q8R800B800B<R8RX0X`2Z003R8b800>800>/S:`02j`00hb/[008[003/:b/00V/
0k02[0:`00J//;2<e=P4n0?D0]02[003S6R400=T00E0JO[@e002/004d;3@d0>`0m02e0;@00Fde=CD
d003e003d=CD00cD00Fde=CD/002e005m=CDe?@02=@2m0CD00CHe=CH0m@00mGhe007e007n=CDeMCH
n003e004eMCEe0;i0m@01MShe=Gh00;i00ODf?SdnMCi00;h01Oie=Cie?SDf?SEf=Cin=Cie?SEe?WH
n001e0000f@04VQTA6A4J614J6AXI4AXI6QTA09T00=/I6P00V@00fQTI002I006J6ATI6R80f@00hB8
I003I003R6QT009X0XP016R8R8`2J003R8B800:800=XQ8P00XP018b8R8P2S0:80X`01JR8Q8R/00B8
00J/S8R8S:`3S0>/00><[:`04Z`01;2/[:`2/0>/0[001Jb</=2`00:/00G@/8SDn@04n0;H00?Dd;00
0Z`01HQXS6UX009400=Yn[000[001=3Dd;03e0;@0m@01[3@e;CDd0CD00>`e=@01M@00m3De002e003
/=CD00KD00>de=@06m@00oSDe002e003n?WD00;D00[EnMCDn?WDeMCi1=@02?SDeMGdn=SD0_T00oSD
m002n003nMCd00?h0]@01]SheMGDn0CD00Kif=CDn?T2e07E0004I0940f@00dATJ002I09416@00dAT
I002I003JFAT009T00E4I6B8J004I003J4AT009T00=XI6@00fP00fAXI002R003I8R800:800=TR8P0
18P01Hb8R8bX00>800N<R6b8Z8R<00:800J4Z8b/R:P3S003R:R<00:/00R8[:b<[:R/S0N/00><[:`0
3:`00k2/[002[0:`00B//;3@0[001:b`S=@4n006m=CD/=2`0Z`2R0=X00DTI6Wj/003d0:`0m000mBd
d002d0;D00>`d=@01m@00m2`]006e003d=CD00;D00?@e=D03]@00kCDe00He005f?WEeOT00]P01MGD
e=Cd00?D00?ie=@00m@01OCEe=Cd00;D00GHnMSDf002e004n=SDn@SD00Khe=CDnOP6e0001V@2A0=T
0T@01fA4I6A4I6P00V@00dATI004I004J6ATI0:80f@2J0=T00=XI6@00V@026QTJ6QTJ8QX0V@2R005
J8B8R6@00XP01XB8S8b8J0:800B<R8B80X`4R00;S:b8R:b<[8R<R:`00h`3[003S:b/00>/00><[:`0
1Z`00hb/[002[0:`0Z`01;2/[;02[0>`00B//;2`0Z`2/004S=Chn@;h0]P01MB`/;2/00:<0VP01Xe8
A4AYnPB`00K@/;3@e=02/0?D00V`]=C@];3@e=001=@00m2de007e003]=CD00;D00F`e=CDd003e003
m=CD00?D00>`e=@00m@00oCDe003e006m=CDe?WD0]D00mShe002e0;i00[He?WheMCEf?SE0]@00mGD
f002e006m=CDe?Si0]@01?Cin=D3n005e=Gin=P00m@00oSie003e006f=CDe?WH0]@00oSDe@02e000
00=4I6P00T@00fA4J002A003I4AX00940V@00fQTA002I003J6AT009T0VP02DAXI6QTA8QTJ002I008
R6AXJ6AXI6P2I09X00F8I8QXI003J003R6R400J800=XS8P01HP2S003R8b800>800J<R8b<R8`3[003
R8b/00F/00>8[8P00j`00hb/[002/0F/00><[:`01:`2/0:/0[03[0:`00>//;000k001Jb<m?Si00;h
0m@01[C@/8aXR0=X00QTA4AYn[3@]0B`00?@/;000]@01k3@e;3Dd;000m@2d0;D00>`d=@00m@01=3D
e=09e003d=CD00_D00>de=@01=@00mSDe002e003eMCD00;D00?ie?T01=@01MGDeMGH00;D00GieMGE
n@02e007eOCie?CDe@03e007nMCDeMCie002n@04e?Whn0?D00?Ee=D00]@02=GDe=Chf=Ch1]@1n@00
14@2I004A6AXJ0=400=8I6@00V@03FQTI4ATJ6AXA6AXI6P00V@2J0=T0fP2I003R6Q4009T00F8I6AX
Q002R09X00>4J8P00XP01FB8R8QX00:800=XS8P00hP01hb8R8R<R8`00hP01ZR<S8RX[0:<00J8[:b/
S:P3[005S:b/[8`01j`01hb/[:b<[8`01j`00k2/[002[0:`0Z`4/004d;2/e0?h1=@3/006S8QXJ6AX
0d@01FWj/;3@00B`00?@/;000[02d003e;3@00;@1]@2d0_D0]09e003d=CE00gD00?Ee=@02M@00mSD
e007e0;E00CDeMGD0mD5e003eMCD00KD00CEe=Ch0_@00mGim002e006f?SDe=GD0]P3e004n=CDn0?D
00?he=@00MD000=T00=8I6@016@01TATA4ATA09T00IXI4AXI6P7I005J6ATI6000V@00fR4I002J006
Q6ATJ6AX0V@01FR8J8QX00>800EXR6B8I002R004J8R8J0F800><R8P00XP018b8Z8P2S0:X00F8S:b<
[002S003[:R<00:<0j`00hb/[002[0:<0j`00hb/[002[003S:b/00J/00>`[:`00Z`2/0:/0k001Zb`
d;2/m0;i00?hf=@00]@02=2`/:b<R6AX0V@01D14JO[@00>`00G@/;2`e003/004]=CDe0:`1M@00m3D
e003e003]=CD00KD00?@e=@01m@00m3De006e003/=CD00SD00?Ee=@00]@01]SDeMCin0?D00?EnM@0
1]@2n@08f=CDf?SdeMP4e003n=CD00;D00_he=Cif?SieMCEn@04e003n=CD00?h0]@01OWEn=Ch00;H
0OP1e07E00001VA4A6AXA0AT0d@00fAXA003I003J6AT009T00=XI6@00V@00fQTJ002I004J6ATR09T
00AXI6AT0VP3I003R6B8009T0XP02fB8R8b8Q8QXS8QX00:800J/R8B<R8`2R003S8R800B800JXR8R<
R:`2R0B/00J<[8b<[8`2[0:<0Z`2S003[8b/016/0[001Jb`d;2/00>`00G@[:b`m005n006e;CDd;2<
0XP02VaTI6A4J6Wj/=@2/003[;3D00?@0]@2/0?D00?@/=000]@01M3De=C@00;D00>`e=006M@00oSD
e002e006f=CDf=CH0]@00oSde002e003m=CD00;D00?he=@00]@01?SDe=@2f0;E00?in=@00]@02?CE
e=CHm=CH0]@01OWhe=CH00;h00CDm?Sh0m@00oSEe003e006eMCDe=SE0m@00mSDe003e00000=XI4@0
0VP2I003A6A400=T0VP3I003J4AT009T0VP3I09X0f@2J0=T0VP3I09X0V@01FR8R6B400:800=XR8P0
3XP01jR<R8R/R8`00XP2S0>800F<[8R8S002[003R8bX00>/00><[:`00X`7[003S:b/00n/00B`[:b/
0k000jb`/002/005c=2`[=@00oP00mSde002e005d;2/S6P00V@01VQ4A4AXe0>`00KDd;2`d=@4d0;D
00O@/=CD]=C@00;D00G@e=CD]003e005]=CDe;@01]@00m3De00>e003eMCD00WD00?de=P01=@00oSD
e005e0;E00Gie=CDn002e003n?WD00?D00?he?@00m@03=Gde=Chf?SDnMCdn1OD00001FA4J4AX009T
00EXA6ATA002I005J4ATI4@016@00dATI004I003J6AT009T00=XI6@00V@016QTR6@2J09T0fP3I004
J8R8R09X0hP00fR8R007R003S8R800B800B4S8b<0XP2S00=R8b8[8b/S8R<[8bXR002[003S:b/00R/
00><[:`02J`01;2/[;04[0>`00></;000[000jb`e005n0?D0[001Jb<R6QT00=400@TI;3@0[001=2`
e;03d0;D00>`d=@00]@01m3De;CDd;@00]@00m3De007e003d=CD00;D00?@e=@03M@00oSDe002e003
m=CD00;D00KHe=CdnMP4e004nMCDn0CD00CheMCD0_P01MGhe?SH00;D00OHn?CEf?Sd00;D00Oif=SD
eOCi00?D00?he=P01M@00mGDe004e005n=CDe?P01=@1n07D00001TAXA4QTA09T00=4I6@00V@026QT
A4ATJ6A40V@00fQTA002I003J6AT009T00>8J6P00V@01fQTJ6QTR6P00f@00hQTI002J003R6QX009X
0XP016R8R6P2R004S8R8R0:<18P018b8R8P2S0:800><[:`00XP00hb/[002R0:/0X`01Jb<[:b<00B/
00F<[:b/S006[003c;2/00:/00>`[:`00Z`00k2/[004/003[;2`00>`00G@/:cDn@02n0;d0m@01k2/
[8b8I6P00d@01BAX/=2`00;@00?Dd=000m@2d004/=CDd0cD00>`e;000]@00m3De002e003d=CD00;D
00?@e=@00]@00k3De008e003m=CD00GD00?hm=P00]@00oCDe002e003f=Ci00?D00?he=@00]@02MGD
e?WHe?SDe@03e003m=Si00;D00Oie?CDm=CE00;D00Odn=Sim=CH00SD00Ghe=CEf006e07E0M@1e000
00A4I6AX0f@00dA8J002I003B6QX00=T00A4J4AT0T@5I004J6B8A09X01ATJ6ATR6AXI6R8I6QTJ8QT
R6B4S0:400ETJ8R8Q002R006S8R8R6R<0hP2S0B800B<R8BX0X`00jR8R002S003Z8R/00><00N/S8b8
[:R/00><00>/S8`04:`00k2/[002[004/:b/[0>`00B//;3@0Z`01[3dnOWdn0;H0]02/005S8QXJ6@0
0T@01RA4J;3<d0:`0]001k3@d=G@];000]001=Bdd=03e003d=CD00;D0]001mB`e=3Ee;@01=@00kCD
e00De003eMCD00;D00?He=@00]@00oSDe002e003m?WD00[D00?He=@00m@01MGDe=Cd00?D00Ghe?SD
f005e003n?CD00;h0m@01=GHe=P2e0;H0]@00oSin007e0000T@8I009A6ATI6Q4I4AT009400ATA6A4
1F@01DATI6AX00AT00=XA6@00V@2J0=T00YXI8AXI8QXQ6R40VP2R004J8R8J0B80X`2R004J8b<Q0:8
0X`3R0:<0XP2S005[8R8R8`00Z`01JR<[:b<00:/00B<[:b<1J`00hb/[00:[003/:b/00B/00>`[:`0
0k03[003e?Wh00;h0]@2d007/:b<R8AXI002A00394AX00:`0]001;3@/;02d0;D0]000k3@e002d0CD
00O@e=C@e=3D00;@1=@01M3De=C@00gD00?de=@01M@00oSDe003e007m=CDn?CDe@05e003eMCD00GD
0]D03?SDe?SEn?CDf=Che@;D00Cdn=CD0oP01MGDn=Ch00;D00?im=@00]@00mGDf002e003f=CD00;D
00Whe=CDn=CEe?P00]@000MT0T@6I0=400=TA4@00V@00fQTI002I003J6AT009T00MXI6ATA6AX00=T
0fP2I009R6QXI6R8Q8R400:800ATJ8QT0XP01hb8R8R4J:P00XP00fR<Z003R008S8R8R8b/Z8P2S008
[:R<S8R<Z8`4[0:<0j`01Hb/[:b<00B/00><[:`00j`2/003[8b<00:`2:`2/006[;2`/:cD1OP2e00:
d;2/[8QXI6QT909400><d;000[001MC@/;3@00;D00?@/=000]@2d004e=3Dd0;D00?@e=000]@00m3D
e002e003d=CD00;D00>`e=@00]@00m3De00;e004d=CDe@OD00?he=@01]@01=She=D2e003n=CE00;h
00?Ee=D01M@01_SDe?CDm0;D00?hnOT00m@01?WDe=@2f003n=GD00;i00GDeMCDe@07e003n?WD00?D
00?he=@00M@00004I4AXA09T00A4J6A40f@00dATA003I004A6ATJ0AT00]XI6AXI6QTA6QTJ002I003
R6AX009T00=XI6@00V@03HQXJ8QTS6QTJ8R<R6@00hP016R8S6@2R004Q8R8S0J80ZP2R004S8R/R0J<
0Z`018b8S:`2S004R:b/[0><00F/S:b<[002/12/0[002Jb`[;3@[;2/e004n004f=CDd0:`00Z<R8QT
B4A0I2280[000kB`/005/0;@0[02d0;D0]03e006d=CDe;C@0m@2d0;D00B`e=2d1M@00kCDe00<e003
d=CD00gD00?dnM@02=@00oSDe002e003eMCD00?D00?EnM@01]@01=GDe=P5e004n?WDn0CD00?Ee=@0
1M@00mGDe009e00014@2I005A6A4J6@00T@00fAXI002I003J6AT009T00=XI6@00V@01FQTI4AT009X
00=TA6@00fP2I003J6AT009T0VP01HQTI8QX00:800ATJ8R416P6R004S8R8J0J80X`3R003S8R800:X
00B<R8b/0h`00jR<[002S0:/00B<[8b/0h`2[003/:b/00:/00><[:`00Z`00k2/[006[0:`00F//;2/
/003[003S=CD00?h0m@2/004[8aXJ09T00E094A0[005/006d;2`/=3D0[001M2`/;3@00>`0]@00m3D
e002d005e=3Dd=@00[02d0:d00B`d=2d0m@00kCDe002d1CD00?He=@00]@00mSDe00:e0;E2=@00mSD
e004e003m=CD00CD00CHm=CD0_P2e003f=CD00SD00?Ee=@00]@01_SHe?WDf07D00001FA4A6A4009T
00Y4I4A4J4ATJ4AT0T@4I003A6AT00=T00=XI6P00V@00fQTI002I003R6AT009T00=XI6P00V@01Fb8
I6QT00:800F4I6R<R002I004J8b8Q0:800><R6@00XP00haXJ002R00;S8R8S:R/R8b/R8`00XP2[0B<
00B/S8b<0Z`00hb/[002[005S:b/[8`01j`01Hb=[:b`00B/00F`S:b//002[0:`00S@/:b`S=Chn@?h
00GDd;2`[002R09X00ITA4@TB8`2/004e;2`/0;D00B`e=3D0[001=2`]=@2d0;D0[001M3De;3@00?D
00>`d=@00]@2d0OD00B`e=CE1M@00mGDe002e0:d0m@00kCDm002e004eMSHn0;D00Gde=CDe@05e003
f=GD00;D00?He=@00]@00mSDe@05e006n=ChnMCd0m@00oChe002e004m=SDe0;E1M@2e@GD00?de=@0
1=@1f00000=TB6@00TP2A09T00i8I6A4J4Q4I4ATA6AXI09X0f@00fQTI002I09X00=TA6@00VP2I0=X
0V@01VR8J6AXR09X00ATR6AX0hP00hb8J002R003S8R800:800=XR8P00XP00haTR002R005S8R8S:`0
0XP01Jb<S8b800><00>8S8`00X`00jb<S003[004S:b<S0>/00><[:`00Z`00hb/[004[003/:b/00:/
0[02[0>`00N//8b`S=Cd00Ch0]@01K2/S8b8009T0T@29003A:b`00>`00?@/;000[02e0:`0]000kC@
d002d003/=B`00;D00B`d=Bd0]04e005d=CDe;000]06e003]=3D013D00?Ee=@00m@00oCDe@04e006
]=CDe=GH0]@2e@SD00CEe=CD0_P7e00:nMCDe?CHeOSDf0GD0]D6e003eMCh00;D00?Ee=@00]@00004
I4AX@09T00@TI6AT0T@BI004J6ATA09X2F@00hQXI002I003R6QX00:80VP02VB4R8QXQ8R4R6@2R004
Q6R8Q0>800J4R8R8S8@3R008S8R8S8R<[8P3S00:R8b<R8b/R8b/S0:/00><[8`00X`3[0><3:`00hb/
[006[005/:b`S=@01?P2f00;e;2/[8b8J6@T@2000T@6/003d;2`00:`00G@/;3@/003d0:`00_@e=3D
d=Bdd=C@/003e003d;2d00;D00>`]=@00m@01[C@e=2`]0;D00>d/=@03M@2e@03e=GD00WD0]D00mCE
e003e004eMCDn@GD00SEe=CDm=Chn@CD00Che=CD0_P2e0;i00?He=@02m@00oSDe005e00000ATA4Q0
0V@00d1TA002A09T00A4I4A03f@00fQ4A002I003R6AX009T00QXI6AXI8ATJ0AT0VP00fAXJ002R006
I6R8J8QX0hP00hAXJ005R004S8R4R0:<0XP3S004R8B<S0>800J/S8b8S:`2S007Z8b/S:b<R002[005
S:b/[8P00Z`00hb/[003[003/:b<00Z/0[02[004S=Chm0;h00?de=@00[0018b8J6P3A00494A4[0>`
00G@/;3Dd003/003];3@00:`00SDd;2`d=B`d0?D0[04e005d=CDe=001=@01K3De=B`00;D00?Ee=@0
0m@00kCDe002e003]=CD00[D00CHe=Cd0]@00kCHe004e003n=CD00;D00Gie=CDn003e003m=SD00;D
00Chm=Cd0_P01MSDe?Ch00?D00?He=@01m@01]SDe=Cin0;D0oT2e07H0M@1e00000E4I6AXI003A09T
00E4I4A4I002A003@6QT00=T00=XI6@00V@2J0AT00F4I6ATJ004I007R8ATJ6AXR003I00:J8QXJ8B8
I8QXI0B800=XR6P00X`3R0:<0XP00jR<S003R0:<0XP3S003R:R<00:<00>8Z:`00h`00jR/[003[004
S:b/S0:/00B<[:b`1:`00k2/[002[003/:b/00B/00B`[;3@0Z`2/004S=Cin@;h0m@2/004[8b8J09T
00M4@4A4/=C@00:`00J/e=2`e=02/004d=C@]0:`0]001[3@d=3Dd0;D00Bd/=3d0m@01]3De=B`]0?D
00?@e=@00]@00m3De002e003d=CD00GD00>de=@01]@01MGDe=CE00CD00CEe=Ch5]@2m0CD00?he=@0
0]@01?SEe?@<e005eMCEe=P01]@0009T00=4J6@00V@2A004I4ATA09T00A4I4AX16@2J003I6QT009X
0f@00dAXI005I004J6AXR0=T00AXR6B40V@00hQTR002I0:800=XQ6@03hP00hb8R002R005S8R8[8`0
0hP4S005R8b<S8P01H`2[004S8R/S0Z/00>`[:`00Z`00hb/[007[0:`00J//:b/S=@3n009nMSHd=C@
[8b8009T0d@012A4[=04/0;@0[03d0>`0]000k3@d002d006e=3@d=Bd0]03e003d=C@01?D00?Ee=@0
3=@01=GDe=D3e0;E0]@00mGDe004e003n?WD00;D00Cin=CD0]D2e004n=CDe0;i00KDeMCin=@2e@04
e?SDe0;h00?ie=@01M@02mGDe=CEe?Sie=GH00?D0OP000=40V@00dATI002I003A6A400=40f@00fQ4
I007I09X00ITJ6AXA6P2I003J4AT009T00=XA6@00V@02VQTJ6QTR6B4J8@3R007J6B8Q8R<I003R003
J8R800>800F4R6B8S003R0:<00>8Z8P00X`00hR<S002S0:/0X`00jbX[004[003S:b<00N/00><[:`0
4:`2/005[;2`[=@00_P00oWhm003e00<d:b<R6AXI4@T@6R/0k02d004/;C@d0:`0m000k3@d003d0;D
0]03e003/=3D00?D00?@e=@01]@00kCEe005e003d=CD00[D00?he=@02]@01=SDe=@2n@?D00GhnMCh
e002n0?D00?ie=@01m@02=SdeOSdnMGD0_P01_WDnOWdn0;D00CieMBd0]@01=GDe?T2e004eMCDn@GD
0002I008J4ATI4AXI4@2I003J6A400ET00AXI6QX0f@00fQTI003J005I61XI6P00V@00fQTJ002I003
J6AX009T00^8J6B8I6R8I8QTR002I003Q6R<00B800J<R8R4I6P2R003Z8R<00:800J/R8b8S:`2S005
R8b/R8`00Z`2S0B/0X`3[003S:b/00R/00></:`01j`01;2/[:`3/0:/0[02[004S=Chn@?h0]@2d006
/8b8R4AY14@00hb`/002d005/=3@e;000]02e0;@00CDd=C@1=@00m3De002e003d=CD00OD00C@/=C@
0m@00k3De00Me003f?WD00?D00?Ee=@01]@01?Wde?T3e003m=Ch00;D00Odf=CDm=Ch00;D00?de=@0
0_@01=Che?T2e003eMCD00;E0]@00oSEe002e003f=GD00CD0MD00004J6ATA0AT00I4I6A4I4P2I094
0V@00fQTI002I003J6AT00=X0V@00fQTJ002I0=X0V@3J09T00]8J8R8Q6QTR6QTJ003R003Q8R800:8
00IXR8R<R8`3R003S6R800:80X`01XRXZ8b8S0:800B<R:R80h`2[003R8b/00:/00><[:`01j`00hb/
[00:[003/:b/00>/00B`[:b/0[001lb//8cDn?T00_P01OCDe=B`00:/00V8J6QTA2A4I:`01K000m2d
d002d0:`00S@e=3Dd=C@e0;@00ODd=3Dd;3@00KD00CEe=Bd0]@01K3De=C@00SD00G@e=CDm003e003
m?SD00;D00GHe=CDf00=e00;n=CDeMCin?CDn?@01M@01OCDn?Wd00OD00Ohe?CDn?Wd00cD00?ie=@0
0]@01_Sie=Chf07E00001dATI6QTA6@00T@01fA4I6AXI4@00V@00dATA002I004J6ATI09X16@00fQT
I002I004J6ATI09X0V@3J09T0hP026AXR8QXQ8QX0XP00fR8R003R005S8R8Q8P00X`01HB8S8R<00>8
00>/S8P00XP00jb8S002S004[:R<R0:<00>XS8`00Z`01Xb/[8b/S0Z/00N`c:b<[;3<00:/0k03[0:`
00J//;2`[;04n0?D00k@/:b<R6QTJ4A0A4R`d0>`0]@3d0;D00>`d=@00]@01=3De=@2d005e;C@/=00
1m@00m3De00<e003d=CD00gD00She=CDeOSDm0KD00Chm=CD0_T4e003nMGD00?h0m@03]GDe=Chm=CE
nOSHn=Ci1=@01?CHeMD2n@OD00?ie=@00]@00oSHn002e004n=Cie07E00000fQTI002I003J4A000AT
00=0I6P00V@00d14J004I003J6AT009T0fP2I003J6AX009T0VP01HQTI8QX00=T00B<J8AT0hP2Q003
R8b8009T00J8S8R8Q8P2S0:80Z`4R003S8QT00:800F<R8R/S002[003R8b/00><0Z`3S003[8b<00>/
0X`:[003/:b/00F/0k04[003/:b/00>`00>//8`00]@4n0?D00K@[8b8J6`4A003J;2`00C@00>`e=@0
0m02e003/=3@00;D0]03e003/=3@00;D00G@e=CDd00Me003m=CE00;D00?hf=D00]@00oSDe@03e008
eOSDm=SDnMD5e003n=GD00;d00GDm=Cin002e004m=CDe0;d1=@2m003e?Wd00;d00?DeM@00]D4e0;E
0]@01]SDe?SDe@CD0MD00008I4A4I4ATJ6@2J0=T0VP2I003@6AT00AT00A8J6AT0VP4I006J6ATI8QX
0f@2J0=T0XP01VR4R8R<J0:800=XR8P02XP00hb8R007R0:<0XP3S0:800>/S:`00XP01Jb<S8bX00J/
00><[:`00Z`00hb/[006[003S:b/00B/0[03[003c;2/00:/0k001/b/d8cDm0;h00?Dn?@00]@01K2/
[8aX009T00IXA21T/=02/0?@0[001=3De;03d003e=3@00G@00CDd=3@1]@01;3@d=02e003d=CD00;D
00?@e=@04]@01OCDe=CE00_D00Che?Ch1m@00oCDn003e003eMSd00;i0]@2m0GD00?Ee=@00_@2e0?i
2M@00mGDe@02e0;h00GEe=Gif001e@0000ITA6ATA6@2A0=T0T@3I0941f@00fQTI007I09X00E4I8R8
J003I09X0V@4J006Q6B8R6QT0XP016R4Q6@2R004Q8QTS0V80X`3R005S8R8S:P00X`018R<S8`2R0B/
0X`2[003R8b/00>/00><[:`02Z`00hb/[003[0J`0Z`4/003[=3h00;h00Gin?SDd002/006[8R8I6QT
0T@00fB`/006/0?@0[05d003e=3@00;@0]@00k3@d007e003d=CD00;D00?@e=@00]@00m3De00Fe005
f=Cdn?@01M@00mSDe002f0CD00Ghe=CEf003e004n?Cin0;D00Odn=CheMCd00;D00Whe=GDnOSdeMP0
0_P01_CDe=SDe@?D00CHe=CD0_P2e003f=CD00;D000016QTJ4@2I004A6ATA09T00AXA4A40f@00dAT
I003I003J6AX009T00=XI6P016@028QTI6QTJ6AX1F@01XQXJ6QTR09X0hP2I004J8R8I0B800AXR8QT
0XP2S0:40X`00jb8R002S0>800><[8`00XP00hb/S002S0:/00><[:`00Z`00hb/S002[0:<00B//:b<
1:`00hb/[008[0:`0Z`3/004[;2/e0Gh00?de=@00[001Jb<J6AX009400=YI;001k000m2`/002/003
e;3@00;D0[03e003/=3D00;D0m02e003/=2d00;D00?@e;@00]@01M3De=C@00?D00?Ee=@01M@00oSD
d002e004nMGDe0;H0m@00oCHe006e003n=CE00;D00?ieM@00]@00mSEe002e005n=CDm?P00m@02MSD
e=Chf?SDm003n0;D0]P01=Cdf=P4e005f=CDe?P00m@00oCEn@02e07d0M@1f00000A4I6AX0f@014AX
I4@2I004A6ATI09416@00dQXI002I007A6QTJ6AXR003I00>J6ATJ6AXR41TJ6B8I6P2I005J6B8Q6P0
0hP01HB8R8QX00^800Z<R8R8[8R<R:R/0X`2R006[8b<S8R/0X`2R0:/00><[:`00Z`00hb/[002S0:/
00><[:`00Z`00hb/[002[003S:b/00F/00?</:`00Z`4/004Z=3Dm0?h0m@2/009[8QTI6aXI2AY00b`
00?@/=000[001M2`d=3D00:`0m02e0;@0]@2d0CD00?@e=@01=@00k3De00?e003eMCD00?D00?dn=@0
1]@00mGhm005e003eMCD00?D00?En=@00]@01=GDm=D5e003f?SD00;D0_P2e007nOCim=Gin002e@03
n=SD00GD00GEe?SDn005e07E0M@000ET00=4I4@00V@01DATA6AX00ET00=4I6@01V@00fQTI002I003
J4AT009T00=XA8P00V@00fQ4I002I003R6B4009T00N8J8AXI8QT00:800QTR6B4R6B8J0>800JXR8R<
R8`2R003S8RX00F800AXS:b818`01:R8S8`3[007S:b/[8b/S003[0:<1J`00hb/[009[004/:b/[0:`
1:`00m3dn002n005nOCDe=000Z`018QTK6P3A004T]F`/0;@0[02d0>`00K@/;3@/=@2d003e;3D00;@
0m@00m2`e002e0;@0m@01]3De;CD]0cD00K@e=Cde=03e004]=CHf0GD00Gde=CDn@02e003m=CD00?D
00Cie=CD0]P02MGDe?SDeMCdn004e004n=CDe0;h0]@01?SDn=@2n0;i00CDn?WE0m@00mSDe002e003
f=CE00?D00?Ee=@00]@0000:I4ATI4ATA6AXA09T00A4I6A40f@01FQTI6AX009T00=XJHP00f@00fR8
J002I003J8QX009T00=XR6P00V@02TAXJ6B8J8QXI8@4J004R8b8J0B800AXS8QX0XP01Hb/S8b800:<
0hP00hb8R002R003S:b<00:<00>/S8P00X`00jb<[003[003S:b<00N/00><[:`00j`2/003[8b/00:`
0Z`3/0>/0[02[0:`00B</?Si0_P01?Whm=@2/006[8aXJ8aX0R@00i;Ee004/006d;2`/=3D0k02e00>
d;3De;C@];3@e=3Dd;03e003d;3D00?D00>`]=@01m@00m3De00Ae003f=CD00KD00?He=P00m@01MSD
d=CH00?D00?df=@00m@01MSDe=Ch00;D00?he=P00]@00oCEn002e003m=Sh00;D00?hnOP00]@00mSE
e@07e003f=CD00?D0MD1e07D00000fQ4J003I00AA6QTA6A0J4A0A6AXI4AXA6P016@01VQTI6QTJ0=T
0VP2I008J6AXI6R8I6P2I006J6AXR6AX0V@2R004K8R8R09X00R8Q8R8S6R4R09X18P00hb8R004R0:<
00J8S8b/S8P3S003[8b/00:/0X`3[0:<0Z`2S003[8b/00F/00><[:`01J`01;2/[:`2/0:/0k001:b`
S=03n0;i00?hm=@00[000hb8I003J004A6WjTP:`00?@/;001K02d0>`0]001[C@d=3D]0:`00?@e=@0
0]02e004eM3@e0:`00?D/=@01M@01;3De=D4e003eMCD00SD00K@e=Che=D?e003eMCD00?D00?ie=@0
2m@01_SDe=Chn@;D00Cin?Sd0m@2nACD0OT0009400ATA6AT0d@2I004A6A4J0IT00=4I6@01V@01FQT
I4AX00AT0VP2I0=X0V@2J006I6QTJ6AX0V@3R006J8QXJ8QX2HP2S0>800J<R8R<R8`4R0><0XP2S0:/
00B8[8bX0j`02:R/S:R/S:b<2Z`00hb/[006[005/:b/[;001:`00hf`e004n005m=CD/:`00X`3J006
B4AYnY:=0k000jb`/005/004d;2`e@>`0]001MC@/;3D00?@0]@01m2`/=3Dd;000[@7e003eMCD00WD
00?Ee=@02=@01OCDe=CE01?D00?Ee=P01m@01oSDe=ChnOP00]@3n004eOSin@?D00Gie=CEf003e005
eOSDe=P02=@00006A6QTJ6AX0V@024QTI6QTA6A40V@00fQTI002I008J6ATJ6AXI4@2I003J6AT009T
00>8I6@00fP4I007J8QTJ8QXI002J0:800=TJ6P00XP00fB8R002R003J8b800R80X`2Q004S:b<S0:8
0X`00hR<S003S0B/00><[:`01Z`018b/[:`2S0B/00><[:`00j`00k2/[002[0:`0j`2/0:/0[001Jb`
n?Si00Ch00GD/;2`R002J006K6U4JO[E0[000jb`d004/004d=B`d0?D00>`d=@00]@00m3De003e003
d=CD00CD00?@e=@00]@00m3De002e003d=CD00OD0mD<e003nOSD00?D00SHeMCDf=CEf0GD00Cdn=CE
0_T01=SDe=P4e006m=CEe?CH0]@01_Cin=Cde0;i00KEm?Win=D2e005eMCDe?P00]@00mGDn@02e003
eMSD00;D0MD00003I4A400AT00I4I6ATA402I008A6A4A6QTJ6@2J0AT00=XI6P00V@01FQTJ4AT009X
00B8I6QX16@2R003J6AT009X0V@00fR8R002R003I8R800>800R<J6B8J8b8Q0:800><R6@00XP00hb8
Q002[004S8R8[0B<00>/S8`01:`00hb/S004[003S:b/00:/00N<[8b<[8b`00V/00B</;2`0Z`3/005
[;3</?@01OP2e004];2/R0=X00EYA6Wjd002/005d;2`/=000k001=3Dd;02d0;D0m02e0;@0m@00m3D
e002e006d=CD]=C@7M@2n0OD00Ohe=CDf=CE00;D00?he=@00_@00mCEe002e004n?WEe0;i00[de=CE
f=Cdn=Ch0]@00oWDe002e005m=CDe=D01M@01=GDe?T4e004eMCDe@?D00002VA4A6A4@6AXI4@2I003
A6QX009400ETJ4ATJ006I003J6AT00=T00EXI6QTR002I004J6AXJ09T00Z8J6QXQ6R4R6B80VP01HR4
R8R400N80X`01VR8R:b8Q0:800B<R8B80h`3R004S:b/Z0:<00>/S:P00X`2[0><1:`01Hb/[:b<00>/
00><[8`00Z`018b/[<`4[003c:b<00N/00B`[:cd0oP01?Wdf=@2/004[8aTR09X00A4JO[@1[001=2`
d;02e004/=3@e0;@00>`e=@01m03e0;@00Rdd=3@e=GDd0CD00?@e=@06=@00oCDe002f006e?CDe=Sd
1M@00oSHm002e003n=Ci00;D0_P2m0?D00ghm?CdnOSDeOSDm=Ci00KD00CieMCE0]@01=GDnOP4e003
m=CD00?D00001VQ4I6A4I09400EXA6ATA002I006A6A4I4AX16@00fQTI003I003A6AT00=T0VP00fAX
J002J0ET00EXR6AXR002J09T0hP2Q0:800=XR8P00XP00fb8J002R003S:R400:800J<R8R<R8`3R0:<
0XP2S0:/00F8S:b/Z005[003S:b/00:<1:`00hb/[002[003S:b/00R/00>`[:`01j`01;2/[?@3n004
nOCDe0:`00B/R8QT0VP012AYn]04/003d;2`00;@00CDd=2`0m@00m3Dd005e003d=CD00;D0]001MC@
d=2d00OD00CE/=CE1]@00mGDe002e003eMCD00SD00[Hm=CDm?Sde=Si0_@00mChe003e0;d0m@00oSd
n002e0;i00KDeMShf=@2n003nMCD00?D00?Hm?T00_T01=GDe?T2e004f=CDe0;E0_P3e004n=SEe0;H
0m@00004J6AXA09T00A4J6A40V@00fQTA004I003A6AT00=T00=XI6@00V@02VQTJ6A4J6AXI4@4J004
I6QTJ09T00N8I6R8J8QX00:800aTS6R4R6R8J8R<R8`7R003[6R800:800J/S:R<[8`2R003S:b<00:<
0Z`3S0:/00>8S:`00Z`00jR/S002[0:<0j`00hb/[005[003/:b/00:`0j`2/0>/00>`[:`00j`00mCh
n002n007m=CDe;2<R003J006B2AYn]2`0]05/006d;3@e=2`1=@2d0?D0]02e003/=3@00;D0]03e003
d=CD00cD00Cde=CE1m@00oSDe002m004f?CDm0;i00Gde=CDn007e003nOSD00;D00OheMChnOCD00;d
00[hnMGDm=Che?Ci0m@02oCie?Sdf?SDn=Ci00;D00?Ee=@01=@00oSDe@02e005nMGDn=P00M@00004
I4ATJ09T00=4I6@00V@2A09T0T@01fAXI6A4I6P016@00fQTI002I003J6AT009T00=XI6P00V@2R004
A6ATJ09T00=XQ6P00fP01HB8R8QX00B800AXR8QX0X`3R003Z8b800:800N/K8B8S:b<00:80Z`00hb8
S005[005S:b<S:P00X`4[0:<0j`00hb/[003[003S:b/00B/00>`[8`00Z`01;2/[:`2/0:/0[02[005
e?SheOP00]P01MC@/:b<00=X0T@00fVB/00</0S@00V`d=3Ed=B`d=@01=001=C@e=02e003d=CD00;D
00C@e=CE0]@00mGDe004e003eMCD00GD00CEm=CH1]@00oWde002m0GD00?he=@02]@00oSdm003n@;d
00Whe?CEm=Cie?@01M@01oChe=CEe=D00]@01=GDe=@2e@;D00KHe=CEe?P1e00000aTJ6A8I4ATA4QX
A6@2A0UT00AXI6AX16@00fQTJ002I0=X0V@3J003R6AX00AT00aXI6B8I6R4I8QTR8@2R09X2XP00jR<
S006R003Z8R800:<00B8S8b<0Z`2S0:/00><[8`01Z`01:R<[:`2Z12/00>`[:`00Z`00k2/[004/005
[=Chn?T00_P01_CDd;2<R09X0VT01FAYT[3@00>`0]02/0C@0[02d003/=3@00;@00>`e=000]000mC@
d003d003e=3@00;D0m0Me003nMGD00;D00?hm=@00]@00oCDe002e003m=CD00KD0_@2e004n?Wde0;i
0m@00oWDe002e007n=CDe=Shm002e0;i00KDeMCDnMD3e00<nMCDe=Gie=Ghe?WD0MD00006A6ATI6Q4
26@01VQ4A4ATJ0AT00=XI6@00V@00fQ8I002I0=X0V@2J005R6QTR6P00f@02fR8R6QTS6R8I6R<00:8
00EXI8R8J002R003S8R800:800J<R8R<R:`4R00;[8R8S:R/R6R/R:`00X`01jb8Z:b<[8`01j`3S0^/
00B`[:b/0[07[003/:b/00:/00B`[=Ci0oP4e003d8b800=X0T@016W@/:`2/003d;2`00?@0[000mC@
d002d003e=2`00;@00KD/=3Dd=@2d003e=3D00;@0]@3d0GD00?de=@02m@00oCDe007e006f=CDn?Ch
1=@01OSDe?Sd00;D00?dn=@00]@01_Che=Cdn0CD00?hm=@00]@01_SDe=CHn0;D00?dnO@00]@00oCD
m002e003n=GD00;D00CHeMCi0_P01MCHe=CE00;D0OP1f07i00002VAXI6Q8A6A4I6P2I004A6ATI094
00=TA6@00V@2J0=T0VP3I004R6QTI0AX00ATJ6QX0V@01VR8J6B4J0>800F4R6R8J002R09X1HP3S0:8
00><R8P00XP01HbXR8B800:/0XP00jR/S002R0>/0X`2[005S:b<[8`00Z`00hb/[004[003S:b/00F/
00B`[8b/0[03[0:`00><[;000[02[0>`00B/e?Si0oP01]SDd;2/S0=X00ETA6V//002d0:`00O@/;2`
d=C@00:`00?@e=@00m000mB`d003e003/=3D00?@0m@3d0;D00?@e=@00]@00m3De003e003m=CD013D
00?de=@01]@2f0;D00?de?@00]@2m003e?SD00CD00?de?@00m@00oCDe002m0?D0_@00mGDe002m004
e=Gdn@gD00?EnM@00]@01=SDe=P1e@0000=TA6P00T@00fA4I002A00:I4AX@4ATA6QTA09T00IXI6AT
A6P2I0=X0V@00fQYJ002I003J6AX009T00=XI6P00V@01XQXR6QTR09X0XP2J0=T00>8J8P00XP01Xb8
R8b8S0:41hP018b8R8`2R0J<00V/S:R<[8b/R8`01:`028b/S8bXS:b<1:`018b/[8`:[003S:b/00:/
00Z`[;2//?Cin?WH0]@00m2`[002R09X0T@01Hb//;2/00J`1M001K3@d=3D00C@00ODd=3@/=2`00;@
00>`e=000]03e0:`2]@00mGDe00De0;E3=@00mGDe002e@kD017he=CDn=CEe?Whm=GDnOCDe@02e004
f=CDn0?D0mD01]CEn?SDf0;D00001dATA6QTA6@00T@01VA4A4AXI0=400=XI4@00V@00fQTI002I003
J6A4009T00IXI6AXI6P3I006A6R4I6QT0fP02HQTJ8QTJ8B8Q002R003Q6R800:<0hP2S003Q8R800:<
00>8J8`00X`3R004[8b8R0><0XP2[0:800F/S:b/S003[0:<0Z`3S0>/00F<[:b/S004[008S:b`/:b<
[;04[003/:b/00:/00B`[:b`0_P04OWhn?SDd;2/R6Q4J2A4J;3@00:`00>//=000[001:c@e;@3/003
d=B`00;D0]001;3@d=@2d006/=B`/=3D0[001]3De=B`d0?D00C@/=CD0]0=e003d=CD00gD00?He=D0
1m@00oSEe003e004eMCDe@CD00?He=D01=@00oCin@02e003nOCE00;D00?in?T00]@00oSEe@02e004
eMCEe@OD0MD1e07D00000fAXA002I003A6A4009T00M4I414J4AT009400AXI6A41F@2J09T00E4I6QT
J002I09X0f@00hQTJ002I003J8R8009X00Z<J8QTQ8aTQ6AX0XP01XATR8b8J0:800><R8@00XP00hb8
Q002R003S8R800><0XP2S003[8bX00B<00FX[8b<[003S0:/18`01:b<[8`3[0:<0j`00hb/[004[003
/:b/00:/00><[8`00Z`01;3<e?T3n0?D00>`[8P00VP0120TA6P6/004[;3@d0:`0]03/0;@00CD/=3@
0]@3/004e;3@d0B`00O@e;CDd=B`00;D00C@e;2`0]06e003d=CD00;D00>`e=@00]@2d1CD00?Ee?@0
1M@00mGDe008e003f=CD00SD00?de=@00]@00oCD]002e008eMCDeMCEe?P3e003eMCD00?D0004I094
0f@01D14I4AT00940V@00fQTA007I004J6ATJ0]T0VP2I09X00F8I8QXR002J003R6R8009X00>8Q6P0
0hP016R4I8P2S0:400AXS8b40XP2S0>80X`2R0:<00>=R:P00h`00hR/S003[0><0j`2S008[8b<[8b8
[8`6[003S:b/00Z/00><[:`00j`00jSdn003n00>nMC@[8b8I6PTA2B8/:`;/004d;2`/0;@00B`d;3D
0m02/0K@0[03d0;D0m03e003d;2`00;D0]001=GDe=04e003d=CD00?D00?Ee=@02m@00mGDe002e003
m=CD00;D00?He=D03=@00oCDe@02e004m=CDf0CD00CHe?Cd0]@00mGDe005e003nMCD00CD00?Ef=@0
0]@0009T00A4I4AT0d@2I09400=TA6@00T@026A4I6A4I4AX1V@014AXA6P4I009J6A4J6AXI6R8009X
0V@00hQTR002I008Q6AXR6R8I6P2Q003R6R<00>800=XS8P00hP00hb8R002R008[8R4R8b/Z8P2S003
[8R<00><00>/S8`00Z`2S003[8b/00:/00><[:`00X`7[0:<1:`00k2/[008[007/:b/[?Chn@03n007
e;B`S8QXI002A003JJb`00:`00F<[;2`d002[0J`00C@/;2`0]@00m2`d003d003/=3@00:`00CDd;2`
0]@02K3D/;2de=2`]002e003d;3D00;D00?@e=@00]@00m2de00Be003f=CD00gD00?Ee=@00m@00oCD
e003e004nMCDe0;i0]@01=She=@3n006m=CDn=CE1]@00mGDe002e004f=CDe07E0002I003J4A40094
00]XA41TA6A4@6A4J002@005I4ATI40016@02DATI6QTA6QTJ002I003J6AX009T00=XI6@00fP02fAX
J6B8I6R4J8QT00:800ATR6B40VP4R005J8R8R8`018P018b8R8`3R0R<00B/R8b`0h`01Zb<S8b8S0:/
0X`3[003S:b/00:/00>8[8`01J`00k2<S005[0:`0Z`01Xb/[=3he@;h00GHe=B`S002J005I2A4J<`0
1[000jb`/005/003d;2`00?@00B`d=CD0[02d003e=3@00B`00?@/=D00]02e003/=3@00?D0]07e0;@
0m@2d0?D00G@e=CDe@02e003n=CD013D00CEe=Cd4m@00oWEe002e005n=Cie=D01=@2e@KD00?de=D0
1=@1e@000T@016A4I6@4A004I414B09T0d@3I003H6AT00=T00AXI4A40V@00fQTI006I09X0f@2J003
I6R4009X0XP00fAXJ002R007Q8QXR6B4J002R003S8R800R800F4R8R/S002R003[8b<00:800B<[8R8
0X`01jb=[:b<[8`00Z`3S0:/0X`2[004S:b<Z0:/0X`00jb<[004[003S:b/00F/0[03[003d?Si00;i
00Ghe=2`S002J006JD@TI<b/0[03[0Z`1m000k3@e003/003d;2`00B`00?@e=000]@3d003/=C@00;@
00B`e=3@0m@2d0?D00?@e=@04m@00mGDe005e003eMCD00KD00?Ee=@00]@01=GDeO@<e006m=CEm=GD
0]D00mSDe@02e003eMCD00GD0]D2e00000A4I6U80f@4A00<I4A4I41T@4AT@4AP1f@00f1XI005I004
J6ATJ0AT00=XI6P00V@00fQTJ002I003R6B8009T00>8Q6P00X@01FR4I8B<012800JXR8R<R:P2R004
S8R/S0B/0X`3[004S:b/S0:/00><[8`00Z`01Xb/S:b8S0>/00BX[:b<3j`00oSEe@02n0;D00B`[8QT
0T@016BXc:`2/0:/0[001=2`/;02d003/=2`00;@0[02d0:`00C@/=3@0[02d0>`00C@/;CD0m03e0;@
00GD]=3Dd003e003d=CD00GD00?@e=@03=@00mGDe00;e003eMCd00cD00?Ee=@00m@00oCDe002e005
m=CDf=D01]@01MG@eMCH00;D00CEnMCE0]@00oSDe001e0000f@01VQ4A6A4I0A400=XI4@014@01FA4
I6Q4009T00=4J6@00f@2J0=T0VP3I09X0f@00hQXI002I09X0hP018b8Q8@2J0F800>4S:`00hP02Xb/
R6R8S8R<R:P2S0:800JX[:b<R8`3[007S:b<[:R<Z002S0B/00><[:`01Z`2S0F/0[03[004/:b/[0>`
0Z`2/0>/00>8e=D00mD01_SD/:b8J09400AYZ:b/2;000jb`/003/006d;2`d;3@0[001=2`d=@8d003
/=3@00?D0]03e006/=3De;3@1=@00m3De002e005d=CEe=D02m@2e@?D00?Ee=@00m@00m3De@04e003
f=CE00;d3=@2e@CD00?deMD02=@00mGDe002e004eMCDe@SD000026A4J6A4I4AX0V@00dA0A002A003
I4A4009400ETA6QTA004I004A6QTJ0AT00IXI6AXI6P2I003R6AT009T0VP3I0>800V4R8R8I8ATR8`0
0hP00fb8Q002R003S8R400:800><R8@00XP01XbXZ8b8S0:80X`01XR/[8b8S0>/00NXS:b/S8R<00:/
00><[:`01J`2S1F/00J`[6R`n=D2n@;D00R`[6QXA4QTR0:/00>`c:`01k02d0B`00C@/;2`0m000k3@
d007d003e=3@00?D00C@]=3D0]02/003d=C@00_D00?@e=@01=@00m3De003e003m=CD00?D00Gde=CD
e@03e003eMCD00;D00CEe?CE1=@00mGDe003e003n?WD00;D00?heM@00]D;e003eMCD00;D00?Ee=D0
2M@00005I41TA6@00T@016A4I6@5A09T00=0A6@00T@3I005A6ATI6P02F@01FQTI6AX00AT0VP3I003
Q8QT00=T00B4R6B40XP00fB8R005R003I8R800>800>4S8P00hP2S006Z8R8S8RX0XP00jb<Z002S0:/
00>XS8`00j`2S0:/00><[:`00Z`2S0>/00><[:`01j`2/0>/00>`[:`00Z`2/004[8R/n@?E00Cie;2/
0VP3A004S;2/[0F`0]05/003d;2`00?@00>`d=@00m001MC@d;3@00?D0]02e0;@0m@2/0SD0]02e003
d=Bd00;D00?@e=@00]@00mGDe004e0;d00?@e=@01=@00oCDe003e003eMCD00;D00CEe=Ch0]@00oCD
e009e005nMCDf?@00m@01OCDm=CE00GD00Gde=CDe@08e07E0MP1e00024@01FQTA6A0009T00=4I6@0
0V@00dATI008I003A6AX00AT00=XI6@00V@00fQTI002I006R6ATJ6B80V@00fR4R002I00<J8B8I8AX
R6R8S8R41HP01HB8R8b800:400B<[8R80h`2R006S:b/R:b80Z`00hb/[003S0b/0X`2[0:<3:`00k2/
[002[007/:b/[8cDn@03e@03e;2<009T00<TA6T00Z`3/0:/00>`d=@00k001=3D/;05d003e;2`00?@
00CDd=3D1=001=C@/=03e0;@0]@00m2`d002e0?@0m@01M3De=C@00gD00C@e=CE4M@00mSDm006e003
m=CD00;D00CHe=Cd0_T01MGde=CH00;D00Gin=GDd002e005n=CDe=D00]@00mGDe004e07E0M@1e000
0T@00d14A002A005@4A4A6@00T@3I0940f@00dATI002I008A6ATA6A0I6P4I003R6AT009T00=XI6@0
0V@028QTI6AXR6B40V@018QTI6@6R007S8R4Q8R<Q003R003S8R800:800><R8P00h`2R0B<00B8[8R8
18`018RXS:`2S005[8b/[8`04J`00hb/[002[004S:b/S0J/00>8e?T00_X01MGD[8aT009400=0J<`0
0[001:b`/:`6/003[=3@00;@00B`d=3@0[001=3D/;02d0:`0m000k3@d006d003/;C@00;@00CDd=3@
1m@01M3De=C@00CD00?@e=@00]@00oCDe002e006d=CDeMCd0m@00oCDe@07e003m=CD00gD00?He=@0
0m@01MGde=Ch00;D00?@eM@02=@01MGDe=CE00GD0003A003I4A0009400=TA4@01D@01FA4I6A000=T
0T@4I003A6AT00]T00=XI6@00V@00fQTI002I008J6B4J6AXI8P2I005R6B8J6@018P01XB8R8b8Q0:8
0X`3R0:<00>8Z8P00X`2R0:<18P00hb8R003S0:/0h`2[003S:b<00:/0X`8[005S:b/[;001:`00k2/
[002[00B/8b/[8B`n=GjeMB`S6A0B4B<1[02[0B`00?@[;000m001[3@d;3@/0?@1;000m2`d002d004
/=3@e0;@00?Dd=000]02e0;@0m@00m3De002e003d=CD00;D00?@e=@00]@00m3De004e003m=CD00_D
00GEe=CDf002e003eMCD00[D00CEe=Ci0m@00oCDe002e003n?CD00?D00?Ee=@01M@00mGDe002e003
f=CD00CD00001VA4A6A4I0=40V@2A003I4A4009400MTA4APA6A4009T00=4I6@00V@00dATI003I003
J6AX009T00=XI6@00V@00hQXJ002I003J6AT009T0X@01VR4J8QTJ0:40XP00hb8I002J003S8QT00B8
00B<R8R<18P01Xb8R8b8[0:80X`00jbXS003S003R8b<00:/00J8[:b/Z8`3[0:<0j`2S0:/0h`6[004
S:b//0>/00F`[8b8n002nP0:eKB`S6A496RX/0:/0[02[0F`00G@/;2//003d0:`0m02/0;@0[05d003
e=3@00;D00>dd;000m@00k3@e002e0;@0m@2d0?D00?@e=@01M@00m3De00?e003m=C@00OD00Gde=CD
e@05e003eMCh00KD00WEm=Cde=Gde?P01=@2e@03d=CE00gD00001DQ4I4AT00I400A0A4AT0T@00d14
I002A003I4AT009T00MPI6A4H6AX009T00=4I6@01f@00dAPJ005I004J6ATI09X00B4J6AX0XP00fQT
R002R005I8QXQ:P02XP00hb8R002R004S8R8R0:<0XP00hb/S002Z006[8R<R:b<0XP018b/S8P2S003
[8b/00:/18`2[003S:R/00B/00><[8`02J`00fR`e@02nP07e;2<I4ATR005[0:`0j`@/0C@0[001=2`
d=04/0?@00>`d;000[000kB`d002/004e;3@/0;D0m000mC@e00Me004eMCDd0;D00?Ee=003]@00mGD
e003e003eMCD00;D00?Ee=D01M@00kCDe002e@CD00?Ee=@00M@000A400U0A4A0I4A0A6@00T@00d14
A002A003@4AT009T00=0I6@00V@0161TI4@3I004A6QTA0YT00=XI6P00V@00fQTI002I003J8AX00:4
00EXQ6ATJ003R003I8b800:800=XR8P018P01HB8R8R<00>800><[8P00hP01JR8S8b800><00>/S8P0
1X`2[003S:b<00:/00><[8`00Z`00hR/S002[004S:b</0Z/00>8S?T00_X01=F`S6@2A004S:b/[0>`
0Z`3/003[;2`00J`00C@/;3@0[000m2`/003/0;@0k001[B`/;3@e0>`00?Dd;000[001mBd/;3Dd=@0
0k001MC@/=C@00CD0]001;3D]=@2d0?D00?@e=@00]@01]3DeMB`d1WD0]D3e007eMCDe?SD/003e003
eMCE00GD00?Ee=D01]@0009400=0A6@00T@2@0=400E0A4A0A002@00?A414@4ATA6A0I6Q4I4AT009X
0f@00fQTI002I008J6ATI61XI6P2I003J6AT009T00=XI6@00V@2R0=T00R<J6B8Q8b8I0B800MTR8R<
J8B<00>800B4S8b<0XP018b8R8P2S0:80X`01:b<S:`3S0:/0h`2[006S:b<S:b<1J`2S0:/00B<[:b`
1J`01Xb/S8b8e@;j00KE/8QXI6P3[0>`00>//=000[000jb`/008/003d;2`00:`00?D/:`00[000kB`
/004/0;@00F`d;2`d002/004d=C@/0G@0[02e0:`0]@01;C@d=@2]004/;CDe0;@1=@00m3De004e008
];3@e=GD]=03e005d=CEe;001=@00m3De002e003d=CE00_D00CEe=CE1M@00m3De002e005eKCDe=D0
1=@0009T2d@00fA4A002A003I4A0009400EXA4ATA002I0940V@016QTI6@2J09T0VP4I003J6AT009T
0VP016B4J6P2I003Q6Q/009X0XP00fQTR004R003S8R<00:400F8S8R4R002S0:800B4S8b<0XP01Jb<
R8b800:<0hP00hb/Z003S003R:b<00:/00><[8`00h`01:b<[8`3[005S:b/[8`01J`00hb/S006[003
S8S@00;j00OE[8aXI8R/00:`0Z`3/0:/0k000jb`/002/003[;2`00V`00?@/=001;001=2`/;03d0>`
0m02/00<d;2`/=3D];3@/=2d0]002;3@/=2`e;3@1=@01=3De=D;e005d=Bde=000m@00mG@d003e003
d=CD00SD0]D4e0;E0m@2e@03e=Fd00_D00?@e=@00]@0000>I4AT@4ATA6A0A6@TA404A004@4ATA0AT
0T@016A4I4@6I004H6ATA0=T00=XI6@00V@01VQTI8ATR0AT0fP00hR4R002I0>800F4I8B8S004R003
S8B400N800><R8P00h`2R003S8R<00:800><R8P00XP00hb/R003S006Z:b<R8b/18`4[003S:b<00:<
0j`018b/[:`2S0B/00F<[:b//002nP07eK28Q:R//004[004/:c<[0:`0Z`4/003[;2`00V`00?@/;00
1[001=2`d;02d0>`00CDd=3@1[03d003/=3D00;@00CDd=3@0m@2/0;D0]001[3De=C@]0?D00?@e=@0
0]@01M3De=G@00CD00K@e=CDeM05e003eMCE00cD00?Ee=000]@00mGD/003e003]=CD00;E00>de=@0
0]@1/07D00002FA0A41TA41T@002A004@4A0A09T0d@01D14I41400UT00M4I6AT@4AX00IT00AXI6AX
16@00hATI002J0:80V@018ATJ6P2R007Q8R8R6B4J002R0:400=XR8P00XP00hb8R002R0><0XP3S0:8
18`018R<S8P2S0:/00J8S8b/S8P2S004[8b<S0>/00B<[:b/0X`4[003S:b/00J/00B<[:S80_X01MF/
Z:BX00:/00></;000j`2/0:/1[000m2`[002/00;d;2/[=2`[;3@/=000[001]2`/:c@]0>`00K@/;3@
/;@6/003d;3@00;D00>`d=@00]@00k3@/002e006d=CDe;3@0m@2d0?D00?@e=@00]@00m3De00:e003
/=CD00;D00>`e=@00m@00mGDe003e003eMCD00KD00?Ee=@01=@01k3De=Bde=D01m@000940f@4A005
I4A4A6@00d@00fA4I002A003@4AT009400=TJ6@00d@3I003A6AX009T00I4I6QTA6P4I004J6AXI09X
0f@048QXQ8QTR6QTJ8AXS8QXI8`2R003Q8R<00:800AXR8R<0hP00jb<R002R0:<0XP2[004S8R/[0><
00BX[8b<0j`3S0:/00J<[:b<[8`4[003S:b/00:/00><[:`00Z`01Hb/[:b<00:/00B`[:c/0_X00mF/
Z002b006[;2`[8b/0[03[004d;2/[0j`00?@/=000[001=2`/;03d0>`0]02/004d;B`/0;@1;02]003
e=3@00?D0]001=Bd/=02e003/=C@00;D00C@e=CD0]06e003eMC@00CD00?@]=@00]@00m3De00He003
d=CD00;D00?@e=@03M@000=000ATA4A40V@00dA0@003A004@6A0@0A40V@01D14@4AT009400UTH6A4
I61TJ4@03F@00fQTI002I003J8QT009T00N8I8QXQ8QT00:800=TR8P018P00hB8R004R005S8RXR8`0
18P028b8R8R<R8bX0h`2[0><00J/S:b/S:P4S0J/0X`5[003S:b<00R/0X`2[009b?3jm8bXb<b`00>/
0[002:b</:c<[;3@1K000m2`/003/004d;2`d0N`0m02/005e=3@/=000[001M2`e;3@00:`1=000kCD
d002/007e=3@/=3D]002d0CD00G@e=CDd009e003/=CD00SD00?Ee=@02=@00m3De002e003d;CD00?D
00?Ee=@03=@01=GDe=D8e00000IT@4ATA6@3A005I4A0A6@00T@01D0PI4AT009400=TA6@00f@014AT
@4@4I003A6AT00=T0VP2I003A6AT00=T015XI6QTJ8AXR6AXR6AXQ6B8I002R004I8R8S0F800FXR8R8
S004R0:<0XP2S0:800B<R8b80X`00jb8Z002S0:/00B8[:bX18`9[003/:b<00f/00><[:`00j`01LS@
n]B/00;800>//:`00[02[0:`00><[;001k001:b`/=03/0;@0[02d0:`2=000k3@d004/003d=C@00:`
0]@2/00:d=Bdd;3@/=B`d0;D0[001=C@e;04e003d=CD00;D00OEe=CDd=CE00;D00?@e=@00]@01M3D
e=CE00;D00?Ee=@01m@01;3De=@2e@WD00?@e=@00]D7e003eKCD00?D0K@1e07D000024A0J4A0I4AT
0T@01FA4I4A000=40T001FA0I4A000=T00=4@6@00V@2A008J6ATI4AXI6P2I003J6AT00MT0VP016B8
I6P2I003Q6B8009T00>8I6P01XP018B8R8`7R003[8R800:<00>/R8P00X`2R0:<00Z8[8RX[8b/Z8b/
18`01:b<R8`2[0:<0j`2S0n/00J`[8b<[;02[005eMR/b<`00k02[0>`0Z`3/003[;2`00:`00C@/;2`
0]02/004[;3@d0:`0]03/0;@0[03d003/=2`00:`0m000mB`/002d004]=2`d0;D0]02e006/=3@d=Bd
0]02e003/=3@00?D00?@e=@00]@00m3De002e003d=CD00CD00Cde=CE2m@2d0KD00?Ee=@00]@00mGD
d002e005]=CDe;@02=@01MFdd=3D007E0002A006I4ATI4AT0d@2@0=40T0014ATI4@3I0E400aTA614
I6Q4I6QTJ4@2I004J6ATH0IT00=XQ6@00V@01fR8J6AXI8@016@00hQXR003R09X00B8Q8R<1HP00fR8
R005R0><0hP01Hb8Z8b800:<00BXS8R<0Z`01Xb8S8R/S0B/00><[:`01:`00hR<[004[003/:b/00J/
00><[:`00Z`01?WDZ<P2[005/<b`/:`02K000jb`[007/005d;2`/=000[000m2`/003/004d;2`/0?@
00>`d;001;001MC@d=B`00;@00>`e;@00m001kCDe=2d/=000k000mC@e004e003d=CD00GD0]000mC@
e002d0?D00?@e=@03]@00mGDe004e003d=CD00GD00>`]=@00]@2d0OD00?Ee;@00m@00003@6A400=4
00MTA4A0A6A0009400I0A414I404A007@6ATA6A0A003I004A6ATJ0AT00=XI6@016@014ATI6P6I09X
00f4I6QTJ8AXI8QXR8AX00>800B4J8R<0X@6R004S8R4R0><0hP01Hb8R:b<00:X0Z`01hb/S8b/S8P0
0X`01:b<S8`3[004S:b<[0><1j`00hb/[003[00;S;2/[;2/c?R`Z<P01:`01;2/[:`2/0:/00B`d;B/
0[001]2`/=2`d0:`00?@/=001k02d0>`00KD/;2`d=@2/003e=3@00?@00CDd;3@0m@00k3@e003d0:`
00?D/=000]@00k3De003e003d=CD00KD00K@e=CD/=03e003d=CD00CD00CEe=C@1=@00m3De00?e003
/=CD00;E00>`e=@00]@01K3De=C@00KD00001DA0@41T009400<PA4@00T@01T14I214@09T00=4I400
0V@4A003J6AT00940fP4I004J6ATJ0AT00AXI6AT0VP016AXI6@2R003J6B800:800=TR6@00XP01VAX
R8b4I0Z800><R8`00XP2S0>800J<[8R<R:`3S004R:b<R0:<00J/S8b/S:`3S0Z/0X`3[003S:b/00F/
00F`[:b//003[003n=BX00>/00B`[:b/0[02[0:`0Z`3/0>/00O@/;2`d;3@00:`00C@];2`0]001;3@
/=03/0;@0[001=2`d=02/0;@0[02d009e=3@/=3D/=3D00;@0[03e003d;3D00;D00?@e=@00]@00m3D
e005e003/=C@00;D00?@e=@01]@2d0;D00?Ee=@04M@01=G@e;05e003]=CD00;D00>de=@01M@1e@00
1D@01414A6@4A006I4A0I4AT0T@3I003J4AT009T00=XI6@00V@00dATI003J09T00>8J6P00V@01FQT
I4AT00AX16@3J0=T0XP2J0:800=XI6P00hP00fB4R002R004I8B8S0>80h`2R0><0XP3S007R8b<S:b<
R003S0:/0X`00jR<S002S0:/0X`3[0:<1J`00hb/[00;[0:`00Sd/:b//:b`[0:`0j`3/0:/0[02[0J`
00?@/;000k000m2`/006/003d;2`00N`00C@/;2`0]001;2d/;03d005/=3@/=000k02e0;@00>`];00
0]03e006d=Bdd;3@1=@02M3De=C@e=F`d00=e003d=CD00?D00?@e=@02M@01kB`d=Fde=001=@00m3D
e004e07E0M@1e00000=4@6@00d@00d1TA003A006I4A0I41T0T02A003I4A400=T0T@00fA4I002A09T
00=XI6@03V@00dATI002J0AT00]XI8R4J8QTQ6AXR002Q0B800ETR8R8I003R003J8R800:800><R8P0
0h`018R<[8`2R0><0hP2[004R8b/[0:800>/S:`00h`2[0:<1:`00hb/[003[006/:b/[8b/0X`01Zb`
/:b`e0V/00B`[;2/0[02[0>`00>//:`01k000jb`/004/003];2`00B`0Z`5/007d;2`/=C@/002d003
e;3@00B`0]000k3D]003/003];2`00;@00?Dd=000m@2/0?D00?@e=@00[001M3De=2`00CD00?@e;@0
1]@00m3De002e005d=CDeK002M@01M3DeMB`00;D00Fde=CDe@06e003d;3D00;D0004A003I4A000E4
00A0A4A40T000dATA003A005I4A4I4@00V@014ATJ6@2A003I6QT00=T00IXI6ATH6P4I004J6ATJ0=T
0T@3I0:800>4I6@00XP016AXR8`4R0:<00>4I6@00X`00hB8S002S003Q8R<00:<00F8Z8b/S002R0:<
00N8S8R/S8R/00F<0Z`018bX[:`2S005[8b<[8P00j`2S0J/00>`S:`00Z`2S0>/00C@[:b`0j`2/0>/
0[02[0>`0Z`3/0:/1K000m2`/002/0;@0k000m2//009/007[=2`/:b`e008/0;@0k001]2`/;3@/0?@
0]@2d0;D00?@/=000m@3d0?D00G@e=CEd003e0;@00GDeK3Dd002e0;@0m@00m3De003e003d=CE00;D
00W@e=B`d=BdeM000[000kCEd002e0:d1]@0009400i0A6A0A414I41484AT@0=400ATA4A40V@01dAT
I4AXA6@00T@3I003A6AT00AT00MXI6ATB6A4009T00A4J6AX16@02FQTI8ATJ8QTR002I003R6R800>8
00=XR6@00hP2J0:800N<R8R8S8R<00:80X`3R003S8R800:800B<R8RX0h`2R0><00>8[:`00X`018R/
S8`2[0><0Z`4S0:/00><[:`00X`6[003/:b<00F/00V`[:b<[;2//:`00[000jb`[004/0:/0k000jb`
/005/004d;2`[0N`00?@/;000[001M2`/;3@00B`00CD/;2`0]03/005d;2`/=000k000m3Dd002d0;D
0[02e003d=C@00:d00oDd=3Dd;3@e=3Dd;3DeM001M@01m2de=C@e=D00]@00m3De002e003d=CD00;D
00V`]=CDd;3@e;@01M@2]0GD0003A09T00<PA4001D@00d14@002@005A6A4A4000V@0341TA6AXA6A4
H6A4I09400=XA6@00V@02fQTI4APJ4ATA61X00AT0fP2I008J6ATJ6B8Q6P4R005J8b4R6@00XP00hBX
I009R003S8R<00:80X`3R0><0XP2S006Z8R<[8bX0X`00jb<Z002S004[8b<S0B/00V<[:b/S:b<[8`0
1J`00hb`[006S003TZb`00:/00>`[;000j`2/003[;2`00J`00B//;3@2;001M2`/;3@00:`00>//;00
2;000m3D/002/006d;2`d;3D0[002m2`/=2`d;3Dd;3@00;D0]03e003d;3D00;D00B`e=CD0[02e005
d;2`]=@00]05e005eMBd/=000]@2d004e=GDd17D00?@/=@00]@00k3De007e00000=TA6@00T@01414
A6@2A003@2A4009400=094@014@01VA4A6A4I0A400=TA4@00T@01FQTI6A4009X0V@01DATI61T009X
00=TJ6@026@00fR8J002I0>800IXI8R8J6@4R003I8R800B800><R6P00h`00hQXR002S0:80h`00jR<
S002S006R8b/Z8b80Z`3S0:/00><R8`00Z`3S0:/00J<[8b<[8`3[0:<00>/S8`00fP2A004I6R=TP:<
0[000jb<[002/0:/0k000hb//00</003[;2`00B`00C@[=3@0[000jb`]004/003e;2`00:`00_@/;2/
d=B`d;3@e003d005e=2`/=@00[02d0;D0]03e0:`00?@];@00[000mC@e002d0?D00J`e=Bde=02e003
]=C@00CD00C@e=3@0m@01M3De=Bd00;@00?DeM@00]001=CEeM03e009/;CDe;CDd=C@00?D00000fA0
A002@009A418A41496A000=400ATA41T14@026A4I6A0I4AT0T@01VQ4I614J09T00=PI6P02F@00fQT
I002I003J6AT009T00EXI6B4I002J009I8QXJ8QTR8AX00:800F4J6R8Q002R0:<00>8S8P00X`02hR<
R6R<R:b8S:b<00:800B<[8R<0XP7S003R:b/00:<0Z`4S0:/00><R:`00Z`01hb/[:b<J6@01D@29004
JHeXJ0:<00>//:`00j`2/003[;2`00:`00>//;001[02[0>`00>//;000[000jb`/00</004d;2`/0;@
0k02d006e;3@d;2d0[000m2`e002/003d=CD00?@00?Dd=001k000m2`d002d004e=3@e@C@00?D/=00
0m@3d0;D00?@e=000]@2d0;D00GEe=Bde@02e006eK2`e=2d1=@2]0?D00GEe=3D]001e00000=TA4@0
0T000dA0A002A003I4AT00A400MTA6ATA6A4009T00E4I6ATJ002I009A6QTA6A4I6Q4009T00=XI6@0
0V@00fQTI002I003J6AT009T0fP3I003Q6QT009T00R4I8R4R8B8J0:800V4R6R8Q8R<R:P00XP00haX
R002R0:<00BXR8R<0hP00jR/R002S007R:b8[8b8[002S0:/00>XS:`00j`00hR/S003S0B/0X`3[0:<
00>8J4@00T@00fQTJ002A00;I6U494AXK8b/S:`01;000jb`/002/003S;2`00J`00>/d;002K000m2/
/00;/006d;2/d;3@0k001kC@/;3@/=000k02d0:`00GDd;3@e003d006]=C@d;3D0]02/003e=3@00;@
0]@2d0?D0]02e003eM3D00?D00G@e=CDd004e007/=CDe=3D]002e@03]=CD00;D00>`e=D00]@2]0CD
0MD1e07@00000dA08003A003I41400=400I0A6A0A403A004I414I0A400=TA6@00T@02fA4I4ATJ6AX
I4AX00AT00AXI6AT16P2I003R6QT009T00B8I6B40XP01fQTR8R<R8@00XP018b4I6P4R003S8R<00:8
00F<R8R8Q003S0:80X`018R<S8`2R0B<00>8S8`00h`01:b<S8`2[0><0Z`2S0>/0X`3[004S6aTA09T
00=4J6P00VP014QXJF@2A007R6QTJI;jTP03/003[;2/00>`00>//;001k000jb`/003/004d;2`[0F`
00?@/;001K02d0>`00C@/=3@0[000m2`/003d003];3@00:`00O@/;3@/=2`00;@00>`d=001M02e0;@
0]@3d003e;B`00;@0]@01M2`d;CE00;@1=@01M3De=C@00CD00S@e=2d/=3Ed0:`00?@]=000]002;2d
]=B`e=F`0]02e0000T002DATA414@6A4@004A004@4A4I09400=TA6@00T@3I09400ETA6AXA002I09X
00=4I6@00VP2I003J6AT00=T1VP2I09X0V@3J004R6B8R09X00ATR8R80V@01XQ/R6B4R0:<0hP2S0B8
00><R8P018`018R<S:P2S008R8b/[8b8S:`3S0:/0h`2[0:<00FXS:b/S002[003S:b<00:<0f@00fQT
I002J004S6QXJ09400<TA8P00i83nP06T[2/[;3@0k000jb`/004/003d;2`00J`0m0</003[;3@00R`
0]05/0;@00>`d=000]02/0?@0[001=2`d=02/0;@00GDd=3@]002e0;@0]@2d003/=CD00;@0m@2d0SD
00?@eM@00]@01M3EeMC@00;D00>d/;@00m@01m2`]=3Dd;000k@00k2de002e00000a4@410A6A0A414
I404A00:@4A4A6A4@6A4I0940f@2A0=T0T@3I004A6ATJ0=T00R8I6QTJ8ATJ09T00B4I8R40f@03hQT
Q8ATS8QXQ6Q/R6AXI002R004Q6R8S0:800><R8`00XP00hb8S002R005S8R<[8P00h`2R003S8R<00><
00>XR8`00X`00jR/S002S003[8b<00>/0X`2[008S:b<S:b<R6P2I0IX00N8J6QTJ4@T009Y00>Bn_X0
0oX019:</:`2/0:/0[02[0:`00G@/;2`d004/003d;2`00:`00G@/;2`e005/006d;2`/=C@0[02d0>`
0]02/003]=3@00>`00W@/;3@e;3@]=@00m000k3@d002/0;D00?@/;@00]@00m2`/002e004d=CDe0;@
00F`e=C@/003e003d=CD00;D00?@e=@01]@00k3De@02e006/;CD]=B`0m@02=Fdd=Fd/=3D0[@1/07D
00001DA0A2A0009400IT941T@6@2@0M400ATA4A40V@00dA0I002I003A41T009T0T@00fQTI002I005
J6ATI4@00VP016AXI6P2I003J6B8009T00UXR6QTQ8QTR6@00XP00fR8R002R008I8R8R6B4R8`4R0><
00F8S:bXS002R0><00>8S:`00X`01XR<[8b8S0:/00><[8`00j`00hb/S004S0:/0X`2[009S:b<S6QT
Q6R<009X00>8J8`01FP00d@TTP08nP03/=2`00>`00?@[:`00k001Zc@/=2`[0V`00>//;000k001M2`
/;3@00B`0]04/003d;2`00:`00?@/;001K001m2dd;3@e;@00[03d006/=3Dd;C@0]@2/006d;3Dd;3@
0]@00m2`e002e003/=3D00;D0]03e006d=CDe=G@1m@02=3Dd=GD/;CD0[@02K3De=Bd/=3E]002/0>d
0007A003@4AT00Q400M8I4A4I4AT009400EPA6A4@004I004A6AXJ0=T00=XI6@00V@2J0=T00EXI6QT
Q004J00<I6QTR6QTJ6B8J8QT0XP00hb8J003R003J6B800:<00J4R8R/S8P4S0:80h`00hR<S002S004
R8b<R0:<00F/S8R8S002[004S:b/[0:<00F8[:b/R004[009S:b/[8a4I8Q/00:81H`01hQXJ6PTJI80
2?X00i:`[004/005[;2`/:`02[000m2`/00:/007[;2`/:b`d008/003d;2`00F`1=03/005d=C@d;00
2=001kCD/=2`d;000m000mBdd002d004e=3@d0;D0]03e003d=CD00;@00?DeM@01]@2d005e;C@/=00
1=@02K3DeM2dd;CDe@02e07E0M@1e0000T@02R10A41T@4ATA6@2A008I41T@4ATA6@2A004I4A4A09T
00A4J40T0V@01VQTI6A4J0AT00=XI6@01f@2J004I6QXJ0ET00R4I8AXI8R4I0:800B4R6R42hP2S0>8
00>/S8P00XP2S003R:R800:<00>8Z8P00X`00hR<R002S0:/00F8S8b8[002S004[8R<[0:<00>/S8`0
0Z`3J0:81h`01hQXJ6Q4JI802?X00i:`/006/0:/0[001:b`/=06/003c;2`00b`00B//;3@0k02d0>`
0]03/005d;2`d=@00]03/0;@00J`]=3@/=03/003d=CD00;@00F`e=C@/002e003]=3@00?D0]000kCD
e005e005d=GDd;000m@00m3De002e007/=CDe;C@/003e00:d=GDe;2de=3D/0?D0M01e07E0002A090
00A4@6A00V@4A004I414@0A40T001FQ4I4A0009400AT@4AX16@01FQ4I4AT009X0f@00fQTI002I003
K6AT009T00J8I6AXI8P4I007S6AXJ6B8I002J006R8b4J8R40XP016R8R8`2R0:<0hP2S005R8b<[8P0
18`01hR<S8b/S:`00h`01HR<[:R800:<00N/S8b/S:b800:<0Z`3S0=X00><[8`00h`01:b<J6P2S004
K6UYTPSj00FB/;2`[008/003[;2`00J`00N//;3@[;3@00:`00>//=000[000jb`/003/006d;2`[;3@
1;001=C@/=05/003d=C@00:`00?Dd;001[000m3D/002d004e;C@/0;D00_@/=3D];3@e;CD/003e003
eM3D00?D00C@e=CD0]03e003/=CD00GD00N`]=C@eK3@00?D00N`eMBde;3D00:d0M@0009400QT8410
A6A4@0U400A0A41T0T@01VA4A6A0I0940V@00fQTI002I003J6AT00QT00E4I6ATJ004I09X0V@2J09T
00=XI8P00V@01HQTSFQT00>800N4R8R4J8R400F800J<R8R<R8`2R0><00>8S8`00X`01XR<R8R<Z0B<
00>8S8`00X`00jb<S002S003[8b<00J<0fP2S003[8b<00><00>/S8P00X`00heYTP05nP>B00GjTXf<
/002[003/:b`00:/1[02[0>`00>//;002k000m3</003/003d;2/00F`00?@/;000[000jb`/002/0;@
00>`e=000[000kB`/003/0;@0[001;C@d;03d004/=2`/0;@00>`d=001;001=2`e=D3d0?D0]02e0?@
0]@3d0?D00K@];CDd;03e0:`00Fde=B`]003e06d0MD000=400E0I4A0I003A0900d@00d14A002A003
@6A4009T1D@3I005J6ATI4@02f@02FQTI6QTR6AXI003J09T00>8I8P00VP2I005J6B8Q6@00VP00hR4
Q002J00:R8ATR6R4R8B<J0>800><R8P00XP4S009R8b<R6R8[:R800:<00N/R:b<R:b800:<00>8[8`0
0X`02JR/S8b/S:b<J002R0:/00>`[8`00X`3[0B<00=/T_X01?X00i9YTP02nP03TZb/00>`0Z`3/0:/
0k000jb`/006/003[;2`00:`00>//;001K001=2`/=03/003[;2`00:`00>/d;000k02d0F`1=002;3@
d=3D/=3D0[001]3De;3@/0;D0[03e008/=2`e=2`d;02e007d=CDe;3@e@02e0;@00GDeMC@e@02e003
d=CD00;D00>de=@00]@01]2deMBdd0:d0m@1]07D0K00000694A0A60P1T@01414A408A0IT00E4I6AX
I002A007I6QTJ4ATJ004I006J6ATJ6AX0V@016QTJ6@2J003I6QT009X0f@2J09T00=XR8P00V@01FR8
I6AX00:800QXI6AXS8R4R0:<0hP00hb/S002R00:S:b<S8R<R8b8[0B<00B/S8b80Z`4S003[8b<00:<
00F/S8b/S002R003S;2`00:`00J<[:b//:`4S003K8fB00Gj0Y82nP04JK2`/0:/0k000hb//00?/0:/
2;000jb`/002d0:/0k000jb`/004/003d;2`00>`00C@/=3D1;001]2`/=2`d0:`0]@01=2`d=@3/007
d=Bdd;3@e002/003d=CD00:`0]@2d0?D0m002MCEeM3D]=F`d002e004eK2`]0;D0[001]Bde;3De@;D
00F`]=CD]001/0000T@00b14A005A003@4A000=400]T@4A4@6A0A6A4I002A0AT00=8I6@00V@014AX
J6P2A0AT00=4J6@00f@00fQTI002I09X0f@016QTI6@3J006I6QTJ6B40hP01FQTR6R<009T2XP2S0:8
0h`00hR<R002S003J8b<00:<00>8Z8`00X`2R0><0Z`3S0:/0X`01:b<S8`2J003S:b/00F`00>//;00
18`00fR8S@02TPGj0i800fV</003/0>/0[02[0>`00J//;2d/:`4/003[;2`00:`00>//;000k000m2/
/00K/003];2`00B`00G@/;3Dd004/004d;3D/0;@00F`d=2`d004/0?D0]000mBdd002d003e;3@00CD
0]02e0C@00SDd=3D/=B`d0>`00C@/;Bd1;000004@4A4A09014@02414A6A484@P0T@01414A6@2A0=T
0T@3I007J4ATI6QTA003I008A6ATJ6AXI6P2I00:J6B<J6AXI8QXI09X00ATJ6B80fP2I006Q6R8I8AX
0XP01VB4I6R8Q0:800><R8P00hP01Hb8R8R<00:80X`01hRXR8Q/S8P028`2R0><00N8Z8b<[8b800B<
00>8J8`00[000m3D/005/00:[8b<S6R8SFV=TP;j00>BJFT00fT018b//;02[003/:b`00:/0[000jb`
[004/003d;2`00>/0k000jb`/005/0:/1;000jb`/003[0>`00B//;3@0k03d005/=3@/=000[000m2`
/002d005/=3@e=000k002kC@d;3@e;3@/=C@00:`00?@e;000m03e005d=CDe=001=@00k3De003d003
e=3@00:`00CD];2d0m@2/0:d0[03]06`000016A4@402A005@4A4A6@01T@00bA4A003A0=T0T@3I094
16@01TAXI6QTA0=T00=4I6@016@00fQTJ002J09T00IXI6ATJ6`3I09X0V@2J009R8ATI6R8I8AX00:8
00N4I8R8S8QT00:800><R8P00X`4R003[:R800:<0hP7S0>800F<[8b8S003[0:<00>/S8`00h`00fR/
/002e0:d00OETY:=T;2/00B<00EYJ6R=TP03J@05A6UYJH`00[03[0N`00></;002[001:b`/;02[0>`
00F//;3@/002[0>`00>//;000[000jb`/004/0;@0[02d0>`00?@/;000[02d0:`0]02/0;@00SDd;3D
d=G@/0?D0[02e003d;C@00;D00C@e=CD0]03e0;@0m@02M3De=Bd/=3De@02d007e;Bd];2de002/0;D
00>de=000K@00003I41800A400QTA4ATA6A0809400=TA2000T@02FA4@6A0I4A0J003I004A6QTJ09T
00IXI6QTA6P3I003A6QT00IT00>8I8P016@018QXJ8P2J09T00>8I6P00X@018QTJ6P2R008Q6R8S8QT
R8`4R0:<00>8J8P00X`016B8S:`2S007R8b<S8R<[002S004R8b<[0:800F<[:b<R002[003S:b<00><
00B8J;3@1=@4nP04T[2/[0:<16P016aYK6T39004A6Q/S0:/00>`[:`00[000m2//008/004[;2`/0:/
1;000jb`/00C/0:/1K000m2`d004/003d;2`00:`00K@/;2`]=03/0?@00?D/;000]001[3@/=C@]0?@
00?DeK000]000kCD/003d004e=3D/0;D00G@e;3@e003d003/=2`00?@0]@02KB`d=2`eMB`e002]000
0d@2I0A400ATA4A02D@01FA4I6A400=T00U4@61TJ6A4I6P00V@014ATJ6P2I003H6QX00=T00EXI6AX
I002J003R6QT009T00J8J6AXI8@2J007R8B8R6AXI003J005I8R8K6P00hP00hb8R002R003S6R800:8
0X`01HR<R8b800:<00F8S8b<[002R0><0XP3S003Z:b<00:<00>8S8`00X`2[004R8b`d0;d0]D5nP06
/:b/S:b<0VP00fAXJ@02A00804@T04B<[;02[0>`00R//;2//:b`[0R`00G@/;2`[003/003[;2`00:`
00B//;2`0Z`3/0:/0k000lb`/003/005d;2`/=001[02d0B`0m000kB`d002/0;@00B`d=CD0k000mC@
d002/003]=3@00C@00CD/=3D0]02e0;@00>de=@00m@01;CEd;04d004/;CEe0;@0]@01MFd/=3D007@
0002A003@4A000E400I0A4A4@2@2A00394A4009400<TA4000V@2A004H4ATA0AT00=4I6@00f@01FQT
J6A4009T00AXI6AT0VP3I09X0f@2J0=T0VP01XQTI6R8Q0AX00ATJ6R<0hP00fR<R005R0:<0XP2S0B8
0X`3R0:<0hP2S007R8b8S:b<R003[003R8b/00N<00J`e?Sdn?T5nP03SK2/00><00J8I4AXJD@49094
00J<[;2/SH`4[0N`00>//;001[02[0N`0Z`2/003d;2`00J`00?@/;001[03d003/;C@00>`00ODd=2`
]=C@00:`00Fde;3@]002e0:`0m@01;2de=@2/0:d00?@/;001]@02;B`/=3E]=2`0]@01kC@e=GD]=00
0m@01M2`e=Bd00:`00BdeMB`0]@00kB`/001d0000T@00d1TI002A003@4A4009400A0I4@T0T@01214
A4@2@008I4ATI4ATA6P3I009A6QTA6Q4I4AT009X0f@00fQTI002I003R6AT009T00>8J6@00V@00hQT
I002J006R6QTJ8R<0V@01XQXR6AXR0:<00=XI8`00XP00fR4S003R003J8b800:80X`2R004S8R<R0B<
00V8S8b8S8R<[8P00h`2[0N<0Z`2S004[=CDm0;h00?En_X00oX01M2`[;2/00:80VP5A08T0T@00hb/
S003/0:/00?@/;001;001:b`/=@7/003d;2`00:`0]0=/003d;2`00J`00?@/;000]001MBd/=3D00>`
00CDd=2`0]03/003d;Bd00?@0k001]3De;3@/0;D0[03e003d;3@00;D00K@e=3E]=02e009d=C@e=3D
/;CE00:`0[@01]C@/=3Ee0:`00>de=D00[03]0000T@01VA4A41480=400=TA4@00T@00fA4A002A003
I4A4009400MTA6A4H6A4009X0V@00fQTJ002I003A6QX00=T0VP3I09X00=TR6P00fP00hQTJ002I09X
0V@2R004J6B4R09X0V@01HR<R6R400>800=XR8`00XP00fR8S003R0F<00>XS8`00X`028R<S8aXS8R<
0Z`2S005R8b<S8P00Z`2S003R:b/00:<0Z`018b/d=@2n0;i1OX00mB`/002[0:<0V@2J008A2A094@T
A8`3/003[;2`00:`00>//:`01[000m2`d007/004d;2`[0:`00C@/:b/0k001Jb`d;3@00:`00?@/;00
2K03d0:`0]000k3@/004d005/=2`];000]02e0;@00Z`e;2`d;2de;3@0[03d005/=C@d;@00m02e0?@
00>`eM000]000k2de002/003]=B`00>`0m001=Bde=02/0;D0M0000=400A0A4@T0T@0141TA4@2@0=4
0T02A004I4A4A0ET0T@2I006J6ATH6AX16@2J004I4ATA0AT0VP016B4I6P2I003Q6AX00=T0fP016B8
J6`2Q0:800=/R8@00XP00fR8R002R003J8R800F81X`00hR<R002S0>80X`2R0><00>/S8`00X`00jb<
S002S004[8b<S0:/18`00k3Dn@02n0;E0oX00mGDd002[003S8R8009T00AXI2140R@01414J:`2/004
[;2//0:/0[02[12`0]07/0;@00>`[:`01K02d0R`00G@/=3Dd005/004d;3@/0;@00N`eM3@/=3D00?@
00Rde=3@/=B`d0:`0]@2d0;D0]02e003eM2`00?D00?@e=D00]@2d009eM3@d;CDeMB`00?D00S@/=GE
]=GD]0;D0M01e0000d@022A4A41TA6AX1D@01d14A4ATA6@00T@3I0A400ATA6AX0f@00dAXI003I003
J6AT009T00AXI6AX1F@016QTI6@3J006I6QTI6QT0VP2R09X0XP01fAXJ8R4R6`018P01Hb8R8B800:<
0hP2S0>800>/S8P00XP00jb<S002S003[8R800:<00J/S8b/S:`3S0:/00><[:`00h`00fb/e002n@04
eOShn@CE00GD/:b/R002J09T00E494@P@002A003J:b/00J`00C@[:b/1;001jc@d;2//=001;000mB`
[002/005d;2//=002;001m2`/;3@/=001;001M2`/;3@00:`00C@/=2`0]002=C@/;3D/=2`0m001;3@
e=03/0;D0]02e0?@0m@01[3De=B`d0?D00C@e=CD0]02e@06e;2`eMCE0[001;B`d=02e003d;2`00;D
00?E/=000]@1]00000<TJ4@014@00d14A005A0=000=4I4@01d@2I09416@014ATJ6@2A007I6QTI4AT
J002I003J6AX00=X00=TJ6@00VP00fAXI002J09T0fP2I006J8QXR6AX18P00fR<S003R0:<00IXR8b<
R6P2R003[8b800J<00J/S8b<[8`2R0F<0Z`00hb8S002[0B<00>/S8`00Z`2S00=]?SheOWEnOSie?Sd
d002[003S6QX009X00Q8A2@TA2A4S0>`00><[;003K000m2`/006/003d;2`00F`00>//;000[02[004
T;2`[0V`0m03/003e;2`00:`00G@/=3@e002/003d=C@00:`0]000mBd/002d007/=3@/=2`d002/004
e;3@d0;D0m001]C@d=3Ee0?@0]@2d005e=Fdd;000]001]B`/;2de0?@00OD]=2`e=F`007@000<A005
94ATA6@00T@026A4I414I4AT0T@4I003A6Q4009T00A4I6AT0T@01VQTI6A4J0AT00>8J6@00V@3J09T
00IXI6ATJ8P2I0AX00=TR6P00VP016B8S6P2Q003R6R800:80X`3R003S6b800:800><R8P018`00hR<
S002S0:80h`018R<S8`2R0F<00>/S8`00j`2S007[8c@e?WEn002e@;h00[ie=3@/:b<R6QY0d@49005
J:b/[<`00[02[003d;2`00:/2;001Jb`/;2/00F`00>//;000[000jb`/009/006d;2`/=2/3[02d003
/=3@00>`0m02/0?@0[04d006/=3@d;CE0]02e0?@00>`e=@00[000mB`d004d003/=3E00;E00B`d=2d
0m001;B`d;02]008e;3@d;B`d;01e@0000=494000d@00d14A003A00994@TA414I4AT00940f@01D@T
I4AT009400=XI6@01V@00bAXI002I003A6AT00ET00QXI6QXI6QTJ09T0fP00fAXJ003I003J8R800AX
00>8J6@00hP2J005R8b8J8`00hP016R<R8`2R0:<0XP4S005R8b<[8P00h`2R0><0XP3S003R8b<00F<
0Z`00hb//002[0;D00?Hm=@00m@01;2/[:`2J09400IT920TJFP2S003[;2`00:/0k03[0:`00>//;00
0[000jb`/00:/003[;2`00:`00>//;000[02[0:`00>//;001;001m2`/;3@/=000[02d0B`0]000k3@
e003/004d=B`/0;@00?D/:`00[03d003/;B`00:`0]000k3@d002e009d=CDe;3@e=GD00;@0m@2d008
e=Fdd;2deM@2d0:d0]02e0:`00Fd/=C@e001/00000=TA4@00T@01FA4A4@T009400=TA20014@02414
A6A4@6A40V@00d1XI002I007A6QTJ6A0J002I09400IXI6ATA6P3I09X0V@00fR8J004I006R6ATJ6AX
0V@018QTJ6P2R005Q6QXR8`01HP3J0:80VP4R0B<00>8S8`00X`00hR<S006S003R8b<00:<00>8S:`0
0X`00hR/S002S003R:b/00><00F/S:bXb002c0;@0]@04]2//:b<R8B8I4QTA6@TA8R//0:<0Z`00k2/
[003/003[;2`00:`0Z`3/003[;2`00J`0Z`:/003S:b/00:`00G@/:b`d003/003[;2`00:`00G@/;2/
/002d0:`00?@/;000[001=2`d;02d0:`0]03/0?@0[000m2`d002d005/=C@d=@00]001=C@d=02e003
d=C@00?@00B`d=3D0]02/0;@00>`d=001=02/0;D00C@/=2d0M000007A414A6A4@004A0900d@2@0M4
00=TA4@00f@01f14A6QTA6@00VP6I004A6ATA0AT00IXI6ATJ6@2J00>I6QTQ6QTJ6B4R6QTJ8@2J003
Q6QT009X00>8Q8P00VP01XQXI8aXQ0:800=/J8P00h`02HR<R8R<R:a/R004S0>80h`01hR<S8b8Z8P0
0X`00hR<S008S0:/1<P00nc`k003c0>X00J8Q8B4R6@2A003R:b`00R/0[02[0:`00R//;2//:b`[0:`
00B//;2/0k02[0J`00>//;000j`4/003[;2`00>`00>//;000[02d0f`00?@/;000]02/0;@0k000mB`
/003/003d;2`00:`00?Dd=000]001=B`d=@2d0;D00K@e=2`d=D2d004/=3@d0:`00OD/;3@/=F`00;@
00N`e=2`];3D006`00001T14A4Q4@09400<T@4000T001BA4A4A000I400=TA6@014@2I006A6A4J6AX
0V@00dATI006I004A6ATJ09T00EXI6ATA002J09T0VP00hQTI002J004Q6AXR0=T0VP3R003J8aX00:8
00=XR6P00XP02Vb<R6R<J8b8S8P2S004R8b8S0:80X`3R004S:R<R0><00B8S:b/18`00jb<S007S003
[:S800;800?/j>P01lP00jB4R002I004A6R//0N/0[02[0B`00>//;000Z`6/003d;2`00B`00>//;00
0[001Jb`/;2/00R`0]06/003d;2`00:`00K@/=2`]=04/006d;2`d;C@0[000m2d/003/003d;2`00B`
00?@e;000[02e0:`0]@2d004/=3De0?@00?Dd;000]002=Bd/;3D]=2`0[@03=C@/=3Ee=2`]=Bdd06d
0002A00386A400A400=0A4@00d@00bA4@004A00384AT00=400ITJ4AT@4@2J09T00=4J6P00f@2J004
I414J0AT00MXI6ATJ8QX009T0VP018QTJ6@2J00<I6QXR6QTJ8R<J6B80VP01FAXS6R8009X00J<R8R8
J8`2R0B<00B8S8R<0XP01Xb8S8b8[0:<00B8S:aX0X`00hR/S002S0:/18`00jb<S002[0:<0j`2c005
k>SXa>@00/@02^S4a:BXI4AYJ8`2[0>`1:`00k2//002/003S:b`01F`00>//;001K02[0^`00G@/;2`
d004/005d;2`/=004K02d007];2`/=C@/007d0;D0m001=F`/=@2d009/=3@d=C@/=C@00B`00GD/;3@
]004/005e;2`d;000M@000E400=0A4@00T@00d14A00>A09T00I4@6A4I4P3I09X16@00fQTI003J0AT
00=XI6P00V@016QTR6P2I0=X0V@3J005I8B8S6P00V@01XQXR6B8J0:800ITR6b<R6P2R004J8b8R0:<
0hP2S003R8b800F<0hP3S003R:b<00><00B/S8b81X`01:b<S8`2[004S:b//0;80/@2i00:a>C8b:B4
96UXS0:/0[000hb//004[0:`0j`2/003[;3@00N`00B//;2/1K001:b`/;03[003/:b`00:/5;001=2`
d;02d0R`00?@/;001[000mC@/002/0G@0[04d003/=3@00K@00>`e=000m02e004/=2`d0F`0]@00m2`
]003/003d=B`006`000014@PA402A005@4A0A6@00T@00d14A002A004@4A4@09400=0A4000d@00fA4
A003I0940V@026QTA4ATJ6A40V@2J004A6ATJ0AT0VP3I09X0f@00fQTI002I008S8QTJ6AXI8@2J003
K8R4009X00><R8P00fP00hR<R004R003S8R800><0XP3S0>80X`00jR<R002S003[8b<00Z<0Z`3S0:/
00J<SHf/Y:P2a003i<BX00:T0V@00fR8[002[006/:b/[8b`0j`2/0:/1;000jb`/002[0>`00N//;2`
[;2/00R`00F//;2`[00E/006d;2`d=C@1;000m2`/005/003d=B`00:`00C@/;3@0]@5/005d;3De;00
0]02e@04d;2`e@?@00J`e=2`d=D2d003/=3@00?@00^`e;B`d=C@e;3@]002d06`0M0000A400=T92@0
0T@00fA4A004A00394A400=400=0A4@00T@00fA4I002A006I4ATI4AT0fP01dATJ6QTB6@00VP016AX
I6P2I004J6ATI09X00ETJ6AXR002I0IX0XP2I0>80VP00hR<S004R003S8R800:800><R8`04H`00hR<
S009S005[8b8S:`018`5[0:<0j`2S005[8b/Z8P018`2[007/8b<[;2/S002[0:`00B<[:b`0j`3/003
[;2`00:/0k03[0:`0Z`6/004d;2/[0>`00>//;000[02[0>`00F//;2`d007/003d;3@00:`0m02/004
d;3@e0>`00S@/;2`d;3@/0?@00N`d=2`d=C@00B`0m03/003d=C@00;@00>`e;000]000mBdd002/004
d;C@d0:`0m05/0;@0M@1d00000=4@40014@02414A41T@4AT0d0024AT@4A094A00d@00fA0I002A004
I4ATA09X00aTJ6ATJ61XA6AXI6P2I003J6AT009T00B8A6QT0VP01FAXI6AX009T00>4J6P00V@3J004
I8R8K0:800=XS6P00hP00haXR002R0:<0hP2S003R8b<00:<00>8S8`00X`00hR<S002S0:80X`2R0:<
00>/Z:P00h`00jb<S002S005[8b<[8`01J`3S0:/0h`01:b<S8`3[003S:b/00:/00F<[:b/S003[0:`
00>//:`00[000jb`[002/0>/0[02[004S;2/[0>`0Z`00k2//005/0:/2;000jb`/005/003d;2`00:`
00?@/;000m000k3@/002/003d;2`00B`00CDd;2`0]001;3@/;03d003/=3@00:`00KDd=3@/=@3d005
e=2`d;000]@3/003];2`00;@00?D/;000[000mB`/002/003];2`007D0003A007I4A0A41TA002@005
94A494@00T000dQ4A002@09400YTA61TA6A4I6Q40f@00fQ4I002I003J4AT009T00=XI6@00V@01VQT
I6APR0UT00J8I6AXI8P2J0>80VP00hR4R002J005K6B8J8`028P2S003R6R<00:<00>/R8`00X`018R<
S8`2R0B<0XP2S0:80X`00jb8S004S004R:b/[0:<1Z`00hb/[004[003S;2/00b/00>`[:`00Z`00k2/
[002[0:`00B//;3@0Z`00k2//005/003[;2`00:`00J//;2</:`2/0:/0k001Zb`/=2`[0:`00?Dd;00
1[000m2`/002/005d=B`/=000k03d0:`0]@3/006d;3@d;3D0[02d007eM3@e;3D/002d00:e=2`/=C@
e;3@e0?@00>`eK000k001]C@d=CEe0>`0]@00m2`/002/0002T@00d149003A003@2AT00=400QYA4A4
I4ATA09T00=4J6P00V@00dAXI002I003A6QT009T00=8J6P00V@014ATI4@6I09X00=TJ6@00f@02fR8
I6QTJ8QTJ8R<00:800AXR8b80VP00hR<R002J006S8R8R8b818`00hR<S007S005R8b8[8`00XP3S0:8
00F<[8b<R002[004S8R<S0:/00><[8`00Z`018b/S:`2S0:/00><[:`01:`2/0>/00B`[;2<0Z`01;2/
[:`2/0B/00>`[9001K001M2`/=2`00:/0k03[0>`0Z`3/003[;2`00:`00>//;000[000jc@/003/0C@
00B`d;3@0[000m2`/002d0:`0]04/005d;2`/=001;001M3D/=2`00G@00?D/;000]000mB`d003d005
/=3@e=000[001=3D/=05/0;@00>`d=000]02/004d;3@d0:`00000fA0A005A09000=TA4@01T@00d1X
A005A09T00A4J6AT0T@00fQ4J002I003J6AT009T00=4I6@00V@00fUTA002I003J4AT009T00]XI6B8
I6QTJ8ATJ002I008J6AXJ6B8J8P2J003R6QX00>800=XR8`00XP01VR8S8R<R0:<00IXS6R8[8`3R005
S8R<R6P00X`2R0><00J8S8b<R:P5S003[8b<00:<0Z`018b/[:`2S003[8b<00:<0Z`018f/[:`2S0B/
00><[:`00Z`018b/[;04[004/:b/[0:`0Z`9/0:/1;000jb`/003/0:/0[03[0>`00>//;004K000m2`
d002/003d;3@00R`0]04/004d;3@]0?@00B`e=3@0[000mC@d002d0>`00W@/=3@/=2`e=001K02d003
/=3@00:`00C@/=3D0]01/07D0M@00005A41496@02d@00d14A002A005I4A4A6@00d@2I005A61TB6P0
0f@2J0=T00=XI6@00V@00fQTI007I0=X00ATJ6B416@2J0=T00J4J6QTR8@2J0:800=TJ6P00XP00hB<
J003R0:<0hP00hb8R002R0B<00>8S8P00X`00fR<R002S0>80X`00hR<S003S006R8b<S:b80X`3[0:<
00B/S8b/18`01Jb<[:b<00B/00J<[:b<[8`4[005/:b/[;001:`00k2/[002[006/:b`/:b`0j`2/003
S:b`00:`00B//;2/0[001:b`/:`4/0:/1[000mC@/002/005d;2`/=001k02d0Z`00?@/;000]04/0;@
00B`e=C@1[000m3Dd002/005d;3@/=@01=000mC@d004/005d;2`eK@00k000mC@/002/07D0K000003
96A400m400M8@4ATA6QT009400ATB4A40V@00fQT@002I003J6AT009T00=XI6@00V@016QTI6P4I003
J6AX009T00MXI6QTJ6B4009T0VP3I09X0V@00fR<J002R003J8b800:800=XS6P00XP2S0:800><K8`0
0hP00fb<R008S0:800><R8P00XP01Hb8S8R<00:/0h`2[0J<1:`01Hb/[8b/00:<00F/S8b<[002S0F/
00><[:`00h`3[003S:b`00>/00B`[:b/2K001:b`/:`4/003[;2`00:`00N//;2`[;2/00:`00>//;00
1;03d0N`00?@/=000[001M2`/=3D00B`00Rd/;2`d;C@/0?@0[000m2`d002/004e=3@d0;D00>`d;00
0]@00m2`e002e0?@0]@01;3@d=@9/005];2`d=D01K01d06`0M000006@4A4I4A00T@00f@T@004A004
@6A4I0A400ITA4ATA6@4A003I6Q400=T0T@3I003A6AT009T00QXI6AXI6QTJ0QT00=XR6P00V@2J0=T
0fP2I09X00>8I8@00fP016AXR8`4R004K8QXR0:<00>8S8P01HP01Hb8S8a/00:800><R8P00hP2S0:8
18`01HRXS8b800B<00J8S:b/S:`3S0:/18`00jb<S003[0:<00B/S8b<0Z`00hb`S003[004/:b/[0:`
1:`00hb/[002[003/:b`00B/0[000hb/[002/0:/00?</:`00j`01;2//:`4/003[;3@00>`00>//;00
1;001Jb`/;3@00Z`00>//=000k000m2`/003/003d;3@00:`00[@/=2`d;3@/=2`0m000k3@d003d0:`
00?@/=001;001M2`/;3D00?@0[03d07E0M01d00000A494A01T@00fA4A005A003I4A4009400=TA6@0
0T@00fA4I002A09T00=XA4@00V@00fQ4A002I003J6A4009T00=XA6@00V@00fQTA002I003J6AT009T
00=XI6@00V@016aTI6@2J003R6AX00=X00ATJ6R<0XP00fR8S002R003J8R<00>800F4S8R8S003R0><
0XP00ha/R002R005K8b8R6P00h`016R<S8`2R003S:b<00:<00M/S8b<R8b/00:<00>/S:`00X`01:b<
S8`2[005S:b<S:`00X`9[003S:b/00:/00F`[;2/S002/0B/00F<[:b//002[006S;2`[8b/0[02[0>`
0j`3/003[;3@00Z`00>//;001k000m2`d00>/003d;3@00N`00C@/;3@0k02d005/=2`e=000[02e0;@
00>`d=D01;001=2`/;02]0:`00>deM001[01e00000A4@6@P0d@01FA4A6A000A400M0A4A0A41T0094
00=TA6@00T@01FA4I6A4009T00EXI4AXA002I004@6QTI0941F@01VQTI6A4J0IT0VP2I004J6AXI09X
00=TR6@00VP2R09T0fP00fB8S002R008J8R<S8QXR8`4R0:<00>8S8`00X`01XQXS6b<I0><00F8J8b<
[002J0><00>8S8`018`00jb<S002S003[8b<00>/00F<[8b<[002S004[8b/S0:/0X`3[006S:b</:b<
0j`00k2<[002/0:/0k03[0:`0Z`3/003[;2/00:`0Z`2/0:/0[000hb/[005/003d;2/00B`00>//;00
2K02d0N`00G@/;2/d008/0;@2[02d003/=CD00:`00G@/;2`d002/0;@2[001]2d/=2`e0B`0[@00003
94A400a400=094002T@00fQTA003A004J4A4I09X0T@01fAXI6A4I6P00V@01TATJ6AXA0AT00=XI6P0
0V@01TATJ6B8J0=T00B<J6AT0VP038aXI6B8K6QTR:b<I0:800F<K8R8K002S0:80X`2R0B<00>8S8P0
0XP3S003J8R<00:<00>8S6`00X`2R0><0XP4S0:/0h`01:b<S:`4S0:/0h`3[003S:b/00B<0Z`2S003
[;2<00J/0[02[004/:b`/0:/0[04[004/:b/[0:`0j`2/0>/0[02[0>`00>//;000[000jb`/00</003
d;2`00j`00N//;2`d;3@00>`0m001;3@d=04/003d;2`00:`1=0;/003d;2`00V`0002A003@4A40094
010PA4A0A40TA414@2A4@4AT1T@3I09400IXA6QTA6@2A004I4ATA0=T00=XA6@01V@01TATI6QTJ09T
00=XI6@00fP016AXI6@2J003I6QT00:800=XI8P00XP2J0>800AXR8R80X`016R8R8`4R0:<0hP2S0>8
00><R8P00XP018b8R:`2S003R8b<00N<00B8S8b/0h`3[0R<0Z`2S0:/0X`00jb<[002S0B/00F<[:b/
/008[0:`0j`00k2/[002S003/:b/00:/00F`[:b/S002/0:/0[001Zb`/;3@[0B`00>//;000[000jb`
/002/003[;2`00>`00?@/;001;001=2//=04/005d;2`/=001;02d0>`0]001[3@d=2`d0:`00?@/=00
0m001;3Dd=06/005d;3@/=000[001M2`/;2d00B`00000dA0@003A0=00T@0240P@4@TA2100T@2I003
A6A4009400APJ4AT0T@03FQ4I6API4ATA61XA6P00V@00fQ4I002I003J6AT009T0VP3I003J6AT009T
00B8I6QX0XP2I09X00F8I6B8I002R003J8QX00:800><R8P00XP00fR<R003R003S8R<00>800><R8`0
18P016R8R8P2S003J8R800:<00>8S8`01H`2[003R8b<00V<0Z`3S003[8b<00:<00J/S8b/S:`3S0F/
00><[:`01J`01K2/[8b/00:`0Z`00k2//002[006/:b`[;2/0[02[004/:b`[0:`0Z`3/004[;2`d0F`
0Z`3/003[;2`00>`00C@/=C@1K001Jb`/;2/00>`00?@/;000[001=2`d=@3/008d=C@/=2`];04d0:`
0m000k3@d002/003d=CD00J`00>=/=001K001MB`/;3D006`0006A004@2A4A0=00d@00d0TA002A003
I4AT00I40V@00dAXJ002I003B6Q8009T00=4J6P00V@00dAXJ003I003J6AX009X0V@026R8J6QTJ8QX
0V@3J09T00=XR6P00V@2R005J6B4S8P00VP01XR<R8QXR0:<0hP01Hb8S8b800:<00B8S8R80h`00hQX
R002S09X00>8S8`00hP01jb<R8R<[8`00XP5S0:/1X`3[0:<0j`3S003/8b<00:<00>/S8`00j`2S0J/
0[000jb</003[004/:b/[0>`00B=[;2`0j`2/003[8b/00:`00F/S:b//002[0R`00>//;002K000m2/
/002/003d:b/00>`00>//=000[001Zb`/=B`[0V`00?@/=000]04/0?@1;000m2`/002d0B`00?@/;00
1[000m2`/005/07@000014A0A202A003841000940T03A003@4A400=400ATA4AT1T@00fA4J002A004
I4AXJ09T00E4I6A4I002A09T00EXI6ATJ003I0=X0V@2J09T00AXI6QX0f@2J0=T0VP01XQXI6aXR09X
00><J8P00VP026aXR8QXS6R80VP02haXR8b8S8R<J8R<00:800A/R8b80X`00hR<J002S003R:R800:<
00>8S8`00X`01Jb<S8b/00B<00>/S8`02H`>[004/:b`S0>`0j`00k2/[002[006/:b//:b`0Z`4/004
S:b`/0:/00B`[:b/1k000jb`/00</003[;3@00j`00?@/;000m001jb`d=B`[;000m001;3@d=02/003
d;2`00>`00G@/;2`d004/003d;2`00b`00?@/;000k00000394A4009400DTA414@002A004@4A4@0I4
00=0A4@01T@2I006J6A4A6A80V@00dATJ004I005J6A4A6P00V@2J0=T0fP01FAXJ6QT009X00>8J6@0
0V@2R006J6ATR6QT0VP01XaXQ6AXS0>800=XS6P00XP2S003J8R<00><00>8S8`00XP4S003R8b800>8
0X`00hR<K002S003R6R<00F<00F/S8b<[004S0:/0X`2[0B<00F/S8b<[002S0B/00F<[:b/S002[0:`
00><[;001:`01K2/[:b`00B/0[02[0>`00N//;2`[8b/00:`00F/S:c@/003[0>`00F//;2`[00C/005
d;2`[=001K03d003/=2`00B`00G@/=3@/002d003/=2`00:`00[@e;3@/=B`d8f`0]04/003d;2`00F`
0]08/00000=4I4000T@014148403A00<@4A4@4@PA6A4I4140f@2A003J6AX00A400=TA6@00f@00d14
J004I003J6AX009T00AXI6AT0VP4I003R6AT009X00>8I6@00fP2I0=X0V@00hQXJ002I006S8R8R6R<
18P00hb=R002R005S8QXR6P00X`018R/R8`2R00=S8R<J8R<R8b8S:b8S004R0><00>/R8`01H`01Zb<
S8R<[0><0Z`018b/[:`3S0:/00><[:`00Z`02Xb/[:b`[8b//=03[003/:b/00:/00>`[:`00j`01K2/
[:b`00:/00>`[;000Z`00k2//002[007/:b//:b`[002/003[;2`00V`0Z`8/005c;2`/=000[000m2`
[002d0>`00K@/;2`[=04/0;@2;001]2`/=2`d0B`0]02/009d;2`/=2`d;3@00:`00?@/;001[0000=4
00ET94A4@004A004@6@T90E400=TA4@00T@00fA4I004A09T0T@2I003J6AT00=T00I4I4ATJ4@2I00:
J6ATI6QTJ6AXR0AT00I4I6AXI6P2I0=X0f@01VR8I6AXK0>800=XK8P00XP00fR<S002R003K8b800:8
0X`6R003S6R800>800B<R8R818`00hR<K007S004R8b<[0:<00J/S:b<R:`4S003[8b/00:<00B/S8b<
2J`00hb/[005[003S:b/00>/00>`[:`00[07[0>`0Z`00k2/[007[0>`0Z`2/0>/3;02[0F`00G@/:b`
d002/003[;2`00V`00?@/=000[001=2`/=06/003d;3@00;@0[02d0>`00>d/;001k000mG@/009/000
00=T94@00d@290=40R@3A003@2A400940T03A09000=TA6@00T@3I005A2ATA6P00T@01FA4I6A4009T
00=XI4@00V@00fQTI002I003J6AT009T00=XI4@00V@00fQTI002I004J6ATI09X0f@01fQ/Q6AXR6`0
18P00hb8R006R004S8R8R0:<0XP3S0:80X`00hQXR002S0:80h`2R0V<00>8S:`00X`00jb<[007S003
[8b<00:<00>/S8`00j`3S0:/00><[:`00[06[0B`00F</:b`[003/0>/00B`[:b<0[02[003S;2`00>/
0[02[0>`00><[;001k001Jb`/;2/00>`0Z`3/007[;2`d;2//002d0N`0]03/0;@1;001]2`/;3@/0;@
00Bdd;3@0[001=2`/=04/003];2`00J`0]@8/0000T@03fA084@TA2A0A418A414@002A004@4Q4I090
00ET@6A4@003I003A41T00=T00A0J4AT0T@01VQTI6A4J0AT00=XI6@00VP00hQTI002I007J6AXR6AX
I002J004I6QTJ09T0fP028QXJ6R8J8QX0X`3J0F80X`3R0:<0XP00fR/S003R004S6R8R0:<0XP3S0:8
0h`2R006[8b<R8b/0X`2R003[8b800Z<00F/S8b/S002[007S:b<[8b/S002[003S:b`00F/00B`[:b/
0k02[0:`0j`00k2/[002[003/:b/00:/00>`[:`00[03[0:`00>//:`00[02[0>`0Z`3/003[;2`00:`
00>//;002;000m2//007/003e;3@00F`00K@/;2//=03/003d;2`00>`1=05/003d;2`00B`00>//;00
2k00009400=0A4@00T@01414A4@2@0A400I0A6A49402A004I4A0A09T00M0H6Q4I4AT009X00=TA6@0
0f@00dAPI002I004A6AXJ0=T16P01FAXJ8QX00AT00IXI6ATJ4@2I0:800F<I6B8S002J003I6R8009X
00V8S8R<J8R<R6`00XP00hb8R002R004K8b8R0:<0VP01HR<R6R800><0XP3S0:80h`2R0><00>8S8`0
2h`2[0><00B/S8b<0Z`2S0>/0X`8[004/:b`/0>/00>`[:`00Z`2/004S:b//0V/00J`[:b<[;04[0:`
0j`3/003[;2`00F/1;02[0:`00>//;000k000jb`/008/003T]2`00Z`00O@/;3@/=2`00;@0k000m2`
/00G/0000T@3@09400M0A2@TA210008T0d0014@T@403A00?I4A4I4ATA418A6A0I4Q400=T00AXA6A4
0V@01DATA6AX009T00=4I6P00V@00dATR002A008I4B8J6AXI6P2I09X00J8I6B8J8P2I005R6R8J6@0
0hP00fQTR003R008J8R8R8b8S6P4S003R8b<00:800=XR8`00hP00hb8R002R0:<0XP3S0:80h`00hR<
[002S004R8b<S0>80X`01XR<S:b<R0>/0X`2[003S:b<00:`0h`00k2/S002[003/8b/00:/00>`[:`0
0Z`02K2/S;2</8b//002[003S;2/00:/0k000jb<[002/005S:b`S;000X`2/0>/0k000jb`/00;/005
[;3D/:`01[000m2`/004/0:/00?@/;001[000m2`/003/005d;2`/=001;001]2`/:b`d0n`00003DA0
A4@T@4A0I2A4@2@00T@00b14A002A003@4A400Q40V@026Q4A6A4J4Q40V@2J09T0fP00dAXJ003I004
J6ATI0=X0V@00fQTJ002I008J8QXI8AXK6P2I0AX00>8S6`00VP00fAXR002J003R8b800>800><J8P0
0XP01Xb8S6b<J0:<00A/S8R80X`00fR8R002S0>80X`00fR8S002S0:81H`00fR<S009S003R8b/00B<
00B/S8R/0h`00hR/[003S0B/0X`4[007/:b<[8b/S002[004/8b<S0:`0h`2[0:<0j`01Hb/[:b<00>/
00>`[:`01Z`01K2/[:b`00:/1;0018b/[=02[003/:b`00B/0[02[0>`00>//;002K000jb`d006/003
d;2`00V`00>//;000k000jb`/007/003d;2`006`00002D@TI40P@2A4@002A00484A0@0A400=0A400
0T@01414A4@2@003I4A4009400]TA4AT@6A4I41TJ003I003A6QT009400=TJ4@00f@00fQTI002I003
J6AT009T00IXI6AXI6P2I003J6AX009T00IXI6QXI8P2J09T00EXQ6R8J002R004J8QXJ0B800B<R6R8
0h`00fR8R003R005J8R8R6P00XP01FR<R6R800><0XP8S003R8b<00:<00>8S8P00X`00hR<S003S004
[8b/S0:/1H`4[003S:b/00J/00B<[:b/0X`01k2<[:b</:`00h`2[0><1Z`01;2//;02[005/8b/[;00
1:`2/0>/0[03[0:`0Z`2/0B/00>`[;000k02[0>`00>//;001K000m2`/004/003[;2`00V`00?@/;00
0k000jb`/005/003d;2`00J`00000dA0I002A009@2108414841400=014@3@09400=0A4@00d@01F@T
B6A4009T00A0A4AT0d@01VA4A4ATJ09426@00fQTI006I003A6QT009T0fP2I0AX00ATJ6B80V@01VR8
J6AXS0=X00b4S8R8J8R<J8QXR8`2R004S8R/R09X0XP026R8R8R<R6R<0hP01FR<R8aX00N<00>8S8`0
1H`00hR<K003S005R8b<S8P00h`03:b<S:b<[8b//8b/S0:/00><[:`01:`01Hb/[:b<00:/00>`S8`0
1:`00hb//003S003[;2/00:<0[03[0:`00B/S:b`0X`02Jb</8b//:b`S002/003[;2/00:`00>//:`0
0[02[0>`00>//;001K000mB`[002/005e;2`/=002K000m2`/00?/003d;2`00:`00?@/;001;000007
84A0A40TA00290=400I0A40TA404A004@4A490M400=8I6@00T@026APA4ATA6A416@2B003I6QT009X
00=TJ6@00VP00fAXI002J0=T0VP3I0=X00ATJ6R80V@3J09T00MXR8QTR6Q/009X00>8J8`00VP01XQ/
S6R<R09X00B8S8R<0XP2S09X00B8S8b<0XP2S09X00>8S8`00VP00hR<S009S003R8b<00:818`00hR<
S004S005[8b<S:`01H`00jb<S004[004S:b/[0:<00>//:`00X`2/004S:b/[0><0Z`01;2<[;02[008
S:b`/:b<[;03[003/:b<00:/00B`S:b`0Z`2S0>`00><[;000[02[0>`00>//;000[000jb`/00:/003
d;2`00N`00>//;000[001jb`/=2//=000[02[004/=3@[0B`00J//;3@/:`5/00014@2@007A2A4A210
8002A003@4A000940d02A00786A4@4A0I002A008I4AT@4ATA6@2A006J4AT@6AX0T@016A8I4@3I003
J6AT009T00=XI6@00V@016QTI6@2J09T00=XI6P00V@00hQXJ002I006R6QXI8B80VP016AXK6P5R005
J8R8S6P00hP01Xb8R8R<K0B8012<R8R<J6aXR8b8J8b8S8B80h`01XR<S8R<R0B<00B8S8b<0XP8S0:/
0X`01HR/[:b<00B/00><[:`00Z`01Xb/[:b<[0F<0Z`3S003[8b<00>/00></8`00Z`2S0>/00F<[:b/
S004[003S:b<00R/00F`[:b//005[003/:b/00>/0[04[0F`0j`3/0:/3K000jb`/002[0>`00>//;00
1k000jb`/002/06/0K01/00000A0A4A00R03A00<9210@4@T84@P@4@T14@00bA4A003A005I4ATA200
0T@016A4A6@2A003I41T00=400=0A4@00d@01FA8I6A4009X00=4I6@00V@01DATI6AX00=T0VP4I006
J6ATI6R80X@3J003Q8QX00=X00=TJ6`00XP2J0:800=XR6P00XP2J003R6R8009/0hP3S004R8B<J0>8
0h`00fR8S002S003R8b<00:800R<J8b8S6R8S0:800B<R:b818`00hR<S003S003[8b/00:<00>/S:`0
1J`3S0J/0X`3[0J<0Z`00hb/S002[0:<00>`[;000Z`00k2/[003[003/:b<00>`1Z`01K2//;2<00F/
0k02[004/:b`[0:`00>//:`00k001Jb`/;2/00B`00>//;005;02[0R`00>//;000[00009000=4@200
0d@28008A2A4@21484@2@005I4A4A20014@00b1TA002A00786A4I414I003A003@6A4009400=0J6@0
0V@01dAXI6API6P00f@00d1XI006I003R4AT00=X00ITJ6QXR6@3J003R6QX00:80fP00faXR002J0:<
00J8I8R<R6P2R009S6QXR6R<R6R800:<0hP2S0:800><R6`00XP3S004R6B<S0>80X`00hR<R004S004
R8b8R0B<0Z`3S007[8b8S:b<[002S0:/00J`S8b/S:`2S005/:b/S:`00h`01jb<[8b/S:`00X`3[0><
00>/S8`00j`2S0:/00>`[:`01j`2/004S:b//0:/00>`[;001:`2/003[;2/00:/0[02[0>`00>//;00
0[02[0>`00>//:`03;000jb`[002/003[;2`00F`00F//;2`S@09/00000=484000T@00d0PA003A005
9414@4@00T001DATA21000=400<P@4@00T@2@004I4A4@0940V@00dATA002I00394A400AT00I8A6AX
I4@2I003J6A400=T00E4I6ATJ002I007A6QXJ6AXR003J0:800E/J6QXQ004J004Q6QXR0AX00N8J6R8
J8Q/009X00B8S8aX0XP01Ha/I8AX00:<0hP018b8R8P3S0:80VP2S003R8b<00:<0hP2S0>800JXS8b8
S8P3S004[8b<S0:80h`2[003S:b<00><1:`01Hb/S:b<00:/00N<[8b<[8b/00:<00>/S;001X`8[003
/:b/00>/00B<[:b<0Z`00k2/[002[0:`00B<[:b`1:`3/0:/00>`[;000Z`3/0:/5K001Zb`/=2`[0B`
00>/S;000[0018b`/;02[0F`0M01/06`0003@0069410A20T0T003DA0940PA40T@2A4@4@014000bA4
@003A003I41400=400=0I4@00V@01D1TI4AT00940f@01TATI4ATA09T00=4@6@026@014AXJ6P2I003
J6B8009T0XP5J0:800EXR6Q/R003J004K6QTR09X00F8J8QXS003R09X18P018b8J6P2S003R6QX00:<
00>/R8P00X`2R0><00J8S8b8S8P2S0>80h`01HR<S8b/00:<00>/S8P00X`2[0J<1j`01Hb/[:b<00>/
00B`S8b<1:`00hb/[003S0:/0X`00jb`[002S0R/00><[;000j`01[2/[8b//0B/00B`[:b/0[03[0:`
0Z`7/0:/0k001:b`e=06/003[;2`00:`00></;000[002:b`/:b</:b`0Z`?/00000=492000T000bA0
8002@004840P@0=400<PA4@00T@00d14A002A003841400940T02A006J4A4J4AT0T@00fQ4I002A003
J6AT00MT00=XI6@00V@02fQT@6QTR6A4J6AX009T0fP00fA4J002J09T1FP2R004J8QXS0=X00=TS6P0
0XP3J0B80VP2R00;S6R<S6R8J8R<I8P00VP3R003[8b/00:80h`00hR<[002S0:800>/S8P018`01hR<
S:b<R8`00Z`8S006[8b<S:b<0j`00k2<S002[007/8b<[8b/S007[0><0Z`2S004[8b/S0B/0X`5[003
/:b/00>/0[02[005/:b/[;001:`2/0:/00>`[:`00Z`2/0>/1k02[006/=3@[;2/0[000jb`/002/003
[=2`00B`00>//;000[02S0>`00>=/;000[02[0>`0Z`3/00014@01R@P@214909000HPA2A4@2@2A005
@4A0A2@00T06A009I4A4I4ATB4AT009400=TA6@00T@6I004A6QXA0IT0VP01VA4I6QTJ09T16P00fAX
J002J005Q6aXR6@01FP01hQXR8QXR6P00hP01XaXR8QXR09X00B8S8QX0XP018aXR8P2S004J8R8R09X
00F8S8b<J002R0:<00>8S8`018`00fb8S003S0:800><[8`00XP2[003S8R800><00>8S:`00X`2R0><
0Z`2S003[8b/00:<00>/S8`00X`01:b<S8`3[0><00>/S8`00X`2[004S:b<[0B<00>/S:`01:`028b/
[:b`[;2/0X`00fb/[003[0:`0j`2/0>/00>`[:`00Z`2/0>/2[001Jb`[;2/00>`1:`3/0:/00>`S;00
0Z`2/0:/0[001hf`[:b`[;001:`1/00000=494@00T0024@TA40P@2140T0034A0A40PA2A4@2A480=4
00IT94APA6@3A09T14@01VQ4A414I09400=T@6@00f@014AXI4@2I003J6AT009T00=XI6@00V@00fQT
I003J09T0XP00fR8R003J006I6R8R6R40VP02XQXJ6aXR6AXR6P2R09X0hP016R8R8P2J0B800EXR8R<
J003R006S8R8R6R<0XP00hb8S003R007J8b8R8b8S002R0><00>/S8P01h`00jb<S005S0:/00>XS8`0
0Z`3S0:/0X`2[0><00>/S8`00h`00jb<S003[0:<1:`00hb/[007[003/:b<00:`0j`018b/[:`2/0>/
0[04[004/:b/[0:`0Z`3/0:/0k000jb`/002/005[;2`/:`01;001:b</;02[0B`00B<[;2`0Z`8/0:/
00B`[:b<0K00009000I48414@4@29004A214909400dTA4A0A414@214@4@T009400=0I4@00T@00d1T
A002A005@6A0A6@014@4I004@6A0A0AT00=XI6@02f@3J09T0fP01FAXJ8QX009T0VP00hQTJ002R09X
00B8S8R80VP00haXR002R00>S6R8R6R<R6B<J8b8J8`3R009J8b8S8QXS8R<00:80X`3R007S8R8S8R<
R004S003R8b/00><00B/S8b80h`01HR<S8b/00:<00>/S:`00X`3[004S:b/[0:<0Z`3S0>/0X`2[0:<
1:`01Hb/[:b<00B/0X`01k2/S8b//8`00j`00k2//002[004/:b/[0:`0Z`01;2/[:`2/0>/0[000jb`
[002/0:/0[000jb<[002/0:/1;000jb`[003[0:`0Z`3/0:/0[000jb<[002/003S:b`00:`0j`2/0:/
0k000003A40T009400`PA20TA21082A484028004@214809400]0A4@TI4ATA2AT@002A00>96ATI414
I4ATA41TA6@2A007J6A4I41T@002I003A6QT009T00A4I6A41F@01fQTI6AXR6@00fP02HQXJ6QTR6aX
R003J004I6QXJ0B800><J6P00XP01Hb8R8B8009X0XP2J0>80VP2R004S8R8R0:<18P00hb8R002R007
S8R8S8R<R009S003[8b<00N<00>/S8`01h`01:b<S:`4S006[8b/[8b/18`01Jb<[8b/00:<0j`3S0:/
0X`2[003S:b/00J/0h`3[0:`1j`00hb/S00;[0:`0Z`00k2/S003[004S:b/[0B`00>//;000Z`00hb`
/003[004/:b`[0:`0Z`00hb/[004[004S:b<S0:`0X`1/00000@P@2101B0022A0@21092100R003B@0
A210A2A4841T96@00T02900?A40PB4ATA414@6A4@4A0009T00=0J4@00V@00dATA003I005J6ATI600
1F@01FQTJ6A4009T00=XI6@00V@2J09T00AXI6AT0fP00hQXR002J004R8AXJ0>81VP2R006Q6QXR8B8
0fP2R003S6b800:80h`028QXS8b8J8R<0fP02HR<S8b8S:b<R007S004[8b<S0:/0X`00jb<S009S0:/
1X`01:b<S:`4S003[8b/00F<0j`4S005[8b<[8`00Z`00hb`[002S0:/00F`[8b//002[004S;2/[0:<
0j`00hb/[003[0:`0j`00k2/[002[0:`0j`00k2/[002[008/:b`/:b`S;02[007/:b`/:b`[002/006
S:b//:b<0Z`00k2/S002S004/8f<S0:`0J`00009A20T82A082A0008T00LP940TA40T00=400=084@0
0d@00bA4A002A00694A4@4@T1D@01fA4I6A4I4@00V@00dATI004I004A6ATA0UT00A4I6AX0V@014AT
J6P2I09X0V@;J007R6QXJ8R4R002J006K8QXJ6b<0fP00hR<Q003R004J8R8R0:<00>8J8`00X`2R0><
0hP00hb8S005S003[8aX00B<00B8S8b/0h`00jb<R002S0:/2H`01:b<S:`3S0>/00B<[8b/0X`00jb<
S003S003[8b<00>/1X`4[003S:b/00B/00B`[:b<0Z`01Hb/[;2/00:<0j`00hb/[002[003S:b/00:/
00N<[:b`[8b/00:`00><[:`00j`3/003S;2`00:`00B//;2`0Z`4/003[;2`00:<0Z`3S004[;2<S0:/
00N`S:b//:b<00:/00000d@PA0028003@214008P00=484@00R001d0PA400A2000T@00b14A002A007
84A4A40PJ002I09000ET@4AP@002I009A6A4J6A4I41X009400=T@6@00T@00fA0A002A003I4A400AT
00=XI6@00V@01FQ4J6QT00=X00B8I6R80VP01VAXJ8QXI0AX00UTJ6QXI8QXR6P00XP016R<J8P2J005
S6QTR6P00XP00fR<J003R003S6R800:800><J6P00XP00hb8R002R003S8R800:80X`018R<R6`6S003
Z8b<00R<00B/S8b/38`01Zb<S6b<[0><00>/S8`00X`3[0:<00B//8b<0j`2S0B/00F<[:b/S002[003
S:b/00:/00><T:`00j`01[2/[8b/S0:/00F<[:b/S005[005S:b/[;001:`00hb/[003/0:/00B`S;2`
0Z`018b`S:`4S003[8b<00>/0X`00jb<[005[06<00001D@P@21000<P00<082@00R029005A2@P9200
0R@01T14A4@P@0=400<T@4@00T@01T14A6QT80940V@3A0AT00=4I6@00T@6I004A6AXA0AT00A4I6AT
0T@7I0=X00QTJ6AXI8QXI09X00F8J6QXI002J007I6QTR6QTJ002R008J6B8J8a/I8@3J0:800ATK6b4
0XP00hb8R005R09X0X`3R006J8b<S6R80X`016b<S8P8S003R8b<00><00>8S8`01H`01Zb<S:b<[0N<
0Z`3S003[8b<00:<00B/S8b<0j`00hb/[002S0:/0h`01Jb`[:b<00:/18`6[003S;2/00R/00><[:`0
0Z`01k2/S8b//:`00X`01;2/[8`2/003[8b/00:`0j`01;2/[8`2/0>/00>`[:`00X`3[0:<1:`00hb/
[002[06<0J`1S00000/P@4@T@21482A48002@003940P008P00HT8214@2@28005940TA4001T@00fA4
A002A004I4APA0=T0T@3I003@6AT00=T00=XI6@00f@014QTI403I003A6AX00=T16P00fAXJ002I0=X
00=TJ6P016P01hQXJ6AXI6P00V@00fQTJ002J003K8AX00=X00R8J6QXK8QTJ0:<00N8J6R8S8QX00:8
00N<R6R<R8b800B<00B8S8b<0XP2S0:80h`2R0B<00>8S8`038`00jb<S002S0:/18`01Jb<S8b/00B<
00B/S8b<0Z`3S003/:b<00><00>/S8`00Z`2S0B/00><[:`00Z`00hb`[002S0:/0X`01Zb`[8b/S0:/
00B<[;2`0X`2[005/8b<[8`01:`01;2/S:`2/003[8b/00:`00><[;000[02[0>`0X`2/0:<0j`01k2/
/:b`[8`00Z`2S06/00001bA4841484000R000d0T80028003920T008P00<T84000T000d@T@005A003
841400940T0016A4A402I005A6PPA6P00T@00fA4I002I09400IXI41TA6P4I003J6A0009T00AXI6AX
0f@00dAXI002I003A6QX009T16P00fAXJ005J0=T0fP01FAXI6QT00:816P02HQXJ8R<R8aXS002R09X
00F<J8b8J003S004J8R<S0>800F<K8R8J002S003R8b<00:<00B8S8b<0XP4S003R:b<00><00>/S8`0
2X`00jb<S004[0R<00>/S8`00j`2S0>/0X`00jb<S003S003/:b<00B/00><[:`01:`3S0>/00><[:`0
1j`01Xb/[;2=S0N/00B`[:b/0[02[004S;2/S0>`0Z`00k2/S003[0:<00>/S:`00X`2[0><00>/S8`0
0j`1S06/00001D1484@T00<P00M492A0840T008P00LTA2@P@210008T00E4@4A4@004A00584A4I4@0
0d0016A4A6@2A006I414A6A40V@014ATI4@7I003A6AX009X00IPI6AXI4@2I007J6A4I6QTJ002I0AX
00=TJ8P00f@2J003R6QT00=T0fP00fB4J002J003I8AX00=X00R8S6R8J8Q/I0>800><J8`00XP01haX
R8b8K8P00X`3R0:<0hP2S0>80X`3R0:<0XP8S003R8b<00^<0Z`3S0:/0X`00jb<S002S0:/18`2[007
S:b/S92<[004S006[8b/[8b/0X`3[0:<0j`01Hb/[8b`00>/0X`3[003S;2/00:/00><[:`00j`00hb/
[002S0>/0[03[003S;2/00:/00B`[8b<0j`018b//8`2[004S:b<[0:<00>/S:`00X`1/06/0H`00004
A210809000L0840T@20T008P00=082000R000d@P80028005A410A4000T@00bATA003A008I4ATA2AT
A6P4A007I4ATH41XA005I003@6AT009T00A4I6AX16@00fQTI002I006J6ATJ6AX0V@4J005I6QXJ6@0
0VP3I09X0f@2J006R6QTI6R816P01XQTJ8QXR09X0X`2R004J8R8S09X00B<R8QX18P02VR<R8R<R8b8
J8`3R0><00A/R8b<0XP7S003[8b<00><00>/S8`00Z`3S003[8b<00:<00>/S8`00Z`8S0>/0X`2[0:<
0j`2S0>/00><[:`00Z`01Hb/S:b<00:/0h`2[003S:b/00B/00F<[:b/S002[004/8b/S0:/00><[:`0
0j`01;2/[:`3/004S:b//0:/00F`[;2/S002[003/:b<00:/0h`4[0:<0[03S003[8b<006`000024@P
A20T@21412002d0084@PA200@214008P00DT84A48007A00;I414I41T@4AT@4@00T002FA0I6A0I4A0
A002I004@4AXA0IT00=XI6P00V@00dATI002I003J6AT009T0VP3I0=X00=TJ6P00VP00fAXR002J005
I6R<J6@00VP00hQXJ002J004S6QXR0:<00EXI8b<R002J0B800=XS6P00XP00fR<J002R003J8aX00:<
00QXS8R8S6R8K0:<00>8S8`00X`00hR<S002S003R8b<00F<00F/S8R<[004S003[8b<00N<00>/S8P0
1H`01Zb<S8b8[0><0Z`2S0:/00>`S8`00Z`00k2<[002[006/8b<[8b/0X`01:b<S8`2[003S:b/00J/
00>`S8`00j`00hb/[002[005S:b/[8`00Z`01;2//:`2/0>/00J`[:b`[;02[003S:b<00><00B/S8b<
0Z`02;2<S:b`SHb/0X`1[0000b@2A08T0R039008@20P@2A09202900482A0908P0d@012A4A6@9A004
I4A4@09400MTA6ATA6A400AT00U4I4A0I4API4@00VP3I003J4AT009T00=XI6@00V@2J0=T0VP00fAX
K008J003R6QX00YX00>8J8P00VP00fB8R002J0:800B<J6B80X`00hQXR002S005R6R8K6P00X`00hQ/
J002S005J6aXR8`00XP3S004K8R8[0:<00>8S8`00X`00hR<S005S003[8b/00R<0Z`01ha/S8b`T8P0
28`00jb8S004S005[8b<[8`00Z`00hb/S002S0B/1X`3[0><0Z`018b/[:`2S0>/00>`S:`00Z`00k2/
[005[003/:b/00J/0[000hb/[002/0:/00></:`00h`00hf/S002S006[8b/S8f/18`1[06<0J`0000B
A40P94@P@20TA21482A4840P0R@2A00:@214@21084A0A090015T@4A096A0A414I414@4AT@003A007
I4A4I4ATA002I004A6ATA0=T00=4I6@00T@00fA4I004I003R6QT009T00=XI6@00V@3J09T0VP2I0AX
00ATJ6aX0V@2J003R6AX009X00>4J6P00VP00hR4S002J005R6R<J8`00XP00hb8R002R004K8B8J0B8
00AXK8b80VP00faXR003R0><00=/S8P00X`00fb8S004S003[8b<00:800>/S8`02X`00hR<R00:S003
[8b<00><00>/S8`00X`01Jb<[8b/00><1:`00k2/S003S0:/0X`2[0:<0j`3S0:/0X`3[003S:b/00J/
00J<[:b`S;08[004S;2/[0:<00>`[:`00X`00jb<S002S0:/00B<T:b/0X`00jb<S003S00000TT8210
921484000R@0340T82@0@2109214809000LP@410A2AT009000=494@00T0016A0I6@2A00@84A0@6A4
I4A0I4ATA61XA09T00A4J4A40f@01DATI6AX00UT00B4I6QX0V@016QTJ8@3J003R6AT009X00>8J6@0
0VP01XQTJ6QTQ09X00>8I6P00fP00hR4R002S0:800F<K8QTJ002S0>800><R8P00XP00hb8S002R004
S6QXR0:<0XP00haXS002R0:<00>/R6P00h`00hR<S003S003R:b800N<0Z`018R<S:`3S003[8R<00:<
00F/S8b<[005S005[8b<[;000j`2S007[8b<[;2/S002[004/8b<S0:/0X`3[003S:b/00:/00B</:b/
0X`3[0:<0Z`018b/S;04[003/:b/00:/00J`[:b`[;03[0:<00B//;2/0X`2[0B<00J`S8b//:`3S005
/:b<S:`00X`0009400<P@2@00T002`10940P040T840P008T00A4@2140R00140PA4@2@00396A400m4
1f@2A004I4ATA09T00=4I4@00T@5I005J6ATJ6@00VP00fA4I003J003I6QX00QX00>8J6P00VP00hQT
J004J004I6Q/R0=X00A/R6B80X`01HQXR8Q/00>80X`3R0:<0hP00haXR002S0=X0h`01XR<S8aXR0><
0XP3S003K8b<00R<00J/S8b/S:`7S003[8b<00:<00>/S8`00X`2[0><00>/S8`00X`01:b<S8`2[003
/:b/00N/00J<[:b<[8`3[004S:b/[0:<1Z`018b/S8`3[0:<0j`018b//8`3[003/8b<00:/00F`S:b/
/003S0:/00N`S:b/S:b<00:/0X`00jb<[002S0>/0X`00jb<S002S06/0003A00?@21094@T82@P9400
A2A4008P00e484A084A0A400A41400900d@00b10A006A003@4AT009T00=4I4@00d@00fA0A003I094
16@00fQTI002I008J6ATJ6AXI4@3I0=X00ITA8QTJ6@3J09T00AXR6QX0V@018QXJ6@2J003I6R800=X
00=TR8P00fP028aXJ8R4S6R<0XP00haXR002R003S6R800:800Z<J6R8J6b<R8b80X`018R<J8`2R003
S8R<00:800B<K8b80X`018R<S8P3S003[8b<00F<00>8S8`00X`00jb<S007S003[8b<00:<00>/S8`0
0X`00jb<S002S003/8b<00J/00></8`00Z`01Xb/S8b/S0B/00></:`01:`00hb/S002[0><1:`00hb/
[002S0:/0X`4[004S:b`[0><0j`018b/[:`4S0:/2h`00jb<S001S00000HT@40TA2@28006940P@20T
0b00340T921482A49210908P0d@2@0Q400QTA4ATA414I0A416@01FQTI6A400=T00E0A6Q4I002A0IT
00AXI6AT0VP2I0=X0V@00fR8J002J005I6QTJ8P00VP00fAXR006J004I6R8R0AX00N8J6R8S8QX00:8
00B<R6QX0X`2R003K8R<00:800J<R8b8J8`2R006J8b<R6R80X`3R0><00EXS8b<R008S003[8b<00V<
00>/S8`00X`00jb<S002S003[8b<00:<00>/S8`00Z`00k2<S002S004[8b<S0:/0X`01jb<[:b<[8`0
0Z`4S0:/0h`2[0:<0j`00hb/[002[003S:b/00Z/0X`01:b`/8`3[004/8b/[0:`0h`00k2/S008S003
[8b<00B<00>/S8`00X`00003@4@P009400DPA00P@0048003A20P008P00Q4940P@4@PA08P0d@00b10
A002A005@2A4A6@00R02A003I4A000=400Q0A6A4@4ATJ09T00=4I6P00T@2I006J6A4J6AX0T@01FQ4
J6A400=X00=PI6P00VP2I003J6AX009T0VP026AXJ8aXI8QT0VP00fB8I002J003I8QX00=X00J8I6QT
J8P2J0>800=XR8`00XP2J0>80VP3S003R6R<009X0XP01XaXR8Q/S0:800><K8`00XP3S0:80X`00hR<
R002S0:80h`00hR<S003S003R8b<00n<0j`00ha/S004S004[8b/R0:/00F<[8b<[004S003[8b/00F<
00>/S8`01J`00hb/[002[003S:b/00:<0Z`3S0>/00B`[:b/0[001:b<[;03[0:<0j`2S0:/5H`00003
@4A000940R@01b10920T84000R000d0PA0029008A2A09210A402A0901d@00b14A002A003@4A40094
00=0A4000d@026A4A6A4J4A00T@2I006@6A4J6A40f@026QTI6AXI4AT0fP2I09X16@016QTJ6@2J004
R6QTI0=X00A8I6R80fP02FB8J6QTQ8Q/I002R003I8aX00>80VP01XQXR6aXS0:800N<R8b<J8aX00:<
0XP00fR<S002R006J6b<R6R80h`2R0:<0XP3S003R8b<00:<00>8S8`01X`02:b<S8aXR8a/1X`2R0><
00>/S8`01X`01:b<S:`7S003R8b/00B<00B/S8b<0Z`3S0:/00><[8`00Z`4S003[8b<00>/0X`01:b<
[8`3[0:`00F<[8b</004S003[8b<00F<00>=[:`018`00jb<S005S06/0H`1S00000A0820P0T@29005
@2A402@00R001D0T940T009400@T@2140R02A00:I2@T@2AT9214@09400LTA4A4@2AT009400=T@4@0
0T@02d14I414I4AP@4AT00=400IXI41TA6P4I003J6AT009T00IXI6AXI6P3I09X00ITJ6QTJ6@2J003
R6QT009X00B8I6AX0XP2J003R6QX009X0XP3J0B800AXR6QX1XP01fR8R6b<K8`00fP2R004J8b<R09X
00F<R8QXR002S0:80X`2R0><00>8S8`00Z`5S003R8b<00Z<0XP3S0:838`01Jb<[8b/00b<00>/S8`0
0X`00jb<S002S003[8b<00>/0h`01Jb<S8b/00B<00V/S8b/S:b<[8`00Z`2S0:/00J<SJb//:`2S003
/8b<00:<0Z`3S003[8b/00B<00>8S8`00h`1[00000<T@4@012001T@P84@PA08P00=084@00R000d@T
A0028006A20P921T0T@28003A2A000=400HP@4A0I407A008@6Q0A6A4I4@2I0A400=TA6@00f@01414
I4P5I007J6ATJ6AXI002J0=T16P01FAXJ6QT00=X00ATJ6QT0VP01fAXJ8aXI8`00fP01fB<S6R8J8`0
0VP018QXS6P2R0:<0hP00fR<J003R003S6QX00:800N<R8b<J8QX00:<00=XR8P00X`2J0:<00>/R8`0
28`00hR<S002S003R8b<00J<00>8S8`028`01Zb<S8R<[0B<00>/S8`00X`01:b<S:`3S003R:b<00N<
0Z`4S004[8b<S0:/0h`2[0:<00F//8b/S003[0N<00>/S8`00j`2S004[8b<S0:/00>`S8`00X`01I2<
S8b`00V<0J`1S00000/T820T@20T@2A4900280<T00@P@2100R@01T0P94@T@0940R@00d14A00290=4
00=084@00d@00b14A002A003B6A4009T00=4H4@00V@00dATA002I007A6A4I6Q8A002I007J2@TI4AT
J003I003R6Q4009T0VP00fAXJ002J003I6QX009X00ATR6QX0V@018QXI6@2J003K6AT00=X0V@3J009
I8R8J8QXR6R<009X0XP01Hb8J8Q/00F800UXR8b<J8R<K8`00hP016aXR8P2S0:80h`00fR8R00:S003
R8b<00N<00>8S8P00X`2R0><0XP3S0:82h`00jb<S003S003[8b<00N<00B/S8b/18`00jb<[002S006
[8b<[8b/18`01:b<S8`2[0B<00B/S8b/0X`00jb<[002S004SHb/R0:<0Z`2S003[8b<00:<00>=[8`0
1h`1[06<00002b1482A0840P94@P00<T01U082@P040T@20TA2A4@2A4@4A0840PA40P00=400A084AT
0T@00bA4A002A00394A4009400E0A414H004A003I4A400=T0T@3I00:A6ATI8Q8I6QTJ0UT0VP3I09X
0V@3J09T0VP4I003J6B4009X00=/J6@00XP026aTR6R8K8AX0XP00fR8J002R004J8R8J0:800QTJ8aX
R6R<J0:800AXS8b<0VP2S003R6QX00><00>8K8`01h`018R<R6P2S003K8b<00><00J8S8b<J8P3S003
R8a/00:<00F8S8b<R00LS003[8b<00F<00>/S8`00X`01Jb<S8b/00N<00>/S:`00X`01Zb<S:b</0B<
00>/S8`00X`00jb<S002S004[8b<S0:/00F<T8b<[003S003[8b<006<00001R1494@T@08T00Y4920P
94@PA40T0T@00d148002909000<TA2@00T000bA49002@00994A4A40TI2@P00E400]TA4A4@6@TA6A4
I004A004I4A4A09T0T@01FAXI6A4009T00AXI6QT0VP2I0=X00=TA6@00VP00fAXI002J003I6QX00AX
00ATJ6B816P00hQXR002J003R6aX009X00Z<K6QTR8a/R6R80fP2R005K8b<R8`00VP3S00<J8R<S8QX
R8a/S6R80X`00faXR002S003J8R800B<00B8S8b83H`018R<S8`2R0:<00=/S8`018`00jb<S006S003
[8b<00N<00>/K8`00X`00jb<R002S005/8f<S:`01H`00k2/S002S004T:b<[0N<00>/S8`00X`01:b<
S8`2[0B<00F/S8b<[00GS06/00002D@PA4@TA2148002900584@P82@012000d@T90028006A214A214
0R@2@0=400E0A4Q49002@0=400QTA4A494A0A09000=TA4@00T@01FA0A6A4009T00=4I6@00V@014AT
I6@2A09T00=XI6P00fP00fA8R004I005J6AXJ6@00fP016A4J6@2J09T00=XA8P00fP00hAXJ003J0:8
0VP2R09X0XP00hb8J003R006K6R8R6aX0XP01fR<J6R8J6`00hP00fQ/R002R00:J8b8R8b8S8QXS0B8
00><R8`00h`00hQ/K002S0:80X`01Jb<S6b800:<00>8K8`01X`00jb<K007S003[8b<00R<00>/S8`0
1h`00jb<S002S003[8b<00:<00>/S8`00h`01:b<S:`8S0:/0h`01:b<S8`3[0><00>/S8`018`00fb<
S00=S003[8b<006<000012@PA00290<P0R@3800@920P800PA2109214840T808T00M494A4@4@P0094
00I082@TA202@003A6A4009000=4I4@00T@00d1TI002A003@4A400940V@2A0=T00=XA6@00V@2J0=T
00=XI8P00V@00fQTJ002I004J6ATI0AX0V@01fQTI6QTJ6@00fP01hQTJ6QTJ6@00fP00hQXJ005J003
S8R8009X00B8J6QX0XP2J006R6R8S6R<0XP2J008S6R8J8b8J8P3S0:800=/J8`00XP3S004R8b<S0:8
0X`2K0R<00=/S8`00X`00hR<S002S003R8b/00:<00>8S:`018`00jb<S002S003[8b/00:<00>/S8`0
0X`01Zb<S8f<[0:<00B/S8b<0Z`3S003/:b<00><00>/S8`00Z`3S003[8b<00:<00>/S8`00X`01;2<
S8`2[0B<00J/S8b/S8d2S003[8b<00><00>=S8`00X`00hf<S003S00000D0@2@T@0069009A20PA00T
A2A0008T00=084000R@01d149214@2@00R001BA4A4@T009400DT@4A0I003A003B6A0009T0d@01414
B6@2A003J6AT009400ITJ6ATA6P4I09X0f@2J003I6QX00IX00=TJ8P01fP01FB8J6QT009X00>8J6@0
0VP01XQXI6A/R09X00>8S8`00fP02HR<I6R8S6R8J003R004K8b8J0:800V<R6R8S6b8J8P00X`00hQX
R002S003R6R800:<00=XR8`00X`00hR<S006S005R8b<S6`00X`00jb<S004S003K8R<00:<0XP3S004
R8b<[0F<00F/S:b<[005S003[8b<00:<00>/S:`00X`00jb=S002S0:/0h`00jb<S002S003[8b<00>/
0X`00jb=S002S003[8b<00:<0j`2S006/8b<[8b/18`00jb<S007S003[8b<00B<00>8S:`00h`00008
94@P940P9202900582@P84@00b002bA484@P94@TA20T00=40R@3A003@2A400940R02A09000<TI4@0
0d@00fA0I002A003J414009400QTA41TA6A4@09T00IXI6AXI6P2I003R6QX009T0fP2I09X0f@01FaX
I8QT009X00ETJ6QXI003J004K6QTR0=X00>8J6P00VP01hR<J6R<J8P00VP00haXR002J007R8aXR6R8
S002R003J8Q/00>800J<J8R8S8P2J004S6a/J0:800AXS8R80X`3R0:<0hP=S003[8b<00F<00>8S8`0
58`00jb<S00AS004[8b<S0:/1h`01:b<[8`2[0B<0Z`01;2<S:`7S003[8b<00N<00>8S8`03h`00004
82A0@08T00=494000R@3800>9014940T84@P@2@PA2@2800504A4@2@00d@04414A414@4@P@4A0I41T
A402A00;I4A0I21TA41TA6@00T@01FA4I6A4009T0VP00dATI002J0=T0VP2I0=X00ITJ6ATJ6@6J003
I6R8009X00ATJ8R<0fP00fAXJ002I007R6QXR6R4K004J00:S6R<R6R<J8R<R09X00>8J6P00VP01HR<
R8aX009/0XP00fR<R003R005K6R8R6P00V`2R003J8b<00>80h`00fR<S00<S004R8b8R0:<00>/R8P0
38`01:b<S:`4S0:/0h`00jb<S@02S003[8b<00:<00>/S8`01H`00k2/S004S003[8b<00:/0h`00jb<
S002S004[8b/[0F<00>/S8`01h`00hR<S00?S0:/00000d@P80028003A2@P008T1202908000<T84@0
0R001b@PA40T@2@00T@012A4A4@2900:A414A2A4@4A090E400AT84AT0d@016QTA6@2A005I4ATA4P0
16@00fQTI002I004J6ATI09X0V@2J0AT0VP2I0=X00=TJ6P00f@2J003R6AT00=X00=TJ6P00XP2J003
S6QX009X0hP2J005R6QXR6P018P02VR8J6R8J8QXR8`3J0:<00B8J6R<0fP3S008J8b<S8QXS6P2S003
J8b<00J<00>8S8`00X`018R<S:`5S006R6b<[8b81X`00jb<S006S004[8b<R0F<0j`4S004R8b<[0B<
00>/S8`02h`2[00=S:b<S:b<[;2/S;2<[004S004[8b<[0B<00B/S8aX2h`00hf<S005S06/000022@0
82@P90100b@00`0P80029004040TA08T00M09214940T009400<P@2@00T@00bA09002A003941400Q4
00ITA4ATA6@2A003I4A4009400=TJ6@00V@00fQTA003I007J6ATJ6A8A003I004J6ATI09X0V@3J003
A6QX009X00=TJ6P00f@018QXI6@3J003I6QX009X0V@01XQ/J6B4J0:<00EXR6Q/J002I09X0hP00fR8
R003J0:80VP02XQXR6aXR6R8S6P2R0:<00I/R8R8K6P3R005S8R8J8P018`00hR<S002S003R8b800:<
00>8S8`00X`3R0:<00>8S8P09h`00jb<[002S0:/0h`00jb<S002S003[8b<00><00>/S:`018`00hf<
S002S003[8b<00R<00>8SH`048`00004920P90@P00<TA0000T001RA40210908P00<T82@00T000b10
00028003A20T009000=4@2@00d@0140PA404A004@4AT@0940V@00d149002I0=40V@2A0=T00=4I6@0
0f@00dAXJ005I003J6AX00=T00=XI6@00fP3I09X0V@3J004I6QXK09T0VP00fb8J002J004K6QTI0=X
00=TJ6P00XP2J003R6R8009X00>8J6P00VP02hQXJ8a/S8QXR8b8009X00=/S8P00XP2S0:800=XS6P0
0XP00fb8J002S003K8b<00b<00M/S8b<R6b800><00=/S8`01H`00jb<S00;S0:/38`00jb<S002S003
[8b<00:<00B/S8f/18`01Jb`S8b/00F<00F/S8f<[004S003[8b<00:<00>/S8`00X`00jb<J003S003
J6b<00V<00>/S8`00X`000@P0R@01B0082@0008P00=0A2@00R02@00782@084@TA0028004A2189094
00/PA20PA21484149002A003@6A4009400=0I4@00T@00d1XA002A0=T00U4I4ATA41TA6@00T@3I007
A41XI6QTA003J09T16P00fAXI002J003I8QT00AX00QTJ6QTJ6AXR0AX00>8J6P00VP02HQXJ8QXR6AX
S002R00=J6A/S6QTJ8b8J8QXK003J0:<0VP02VaXS8QXS6b<R6P3S003R6R<00:<00>8J8`00h`018R<
S8`2R0B<00>8S8P018`00hR<S005S003K8b<00:<00>8S8`00X`018R<S:`9S0:/1X`3[0J<00>/S8`0
0X`2[003SHb<00R<00>/S:`00X`00jb<S002S003[8b<00:<00>/S8`00X`01jb<S:b<SF`018`00fQ/
S00;S06=00001B0T840T00<P0R@01B108400008P22@0141492@28003@2A4009400ET94@T@00:A003
I4A4009400ETA4ATA002I0940V@3A005I6Q4A6@00fP00d1TJ002I004A6AXJ0=T0VP00fA4J005J003
I6QX00AX00R8J6QXI8QXI0EX0hP3J0:800=/J6P00XP00fb8R003J004R6QXR09X00Z8S6QXR8a/I6R8
0X`2R0:<00B8J8R80X`2R003K8b800:818`00hR<S003S003K8b<00><0XP2S003J8R800:<0XP3S006
R8b<S6b818`00hR<S006S003J8b<00><00>/S8`01h`00jb<S004S005R8b<S:`02H`00hf<S005S003
SHb/00f<00AXS8a/1X`2R0><00>8S8`018`1S@6<0H`00008A214801002@28003@00P008P010T04A0
84@PA40P94@P@2140R@2@0=400<P@4@00R@2@005I4A4A40024@00fA0A002I0M400I8I4ATA6P4I006
A6ATJ6A40V@00fQTI003I09X00ATJ6QX0V@3J00<I6QTJ6A4J6AXI6QT0VP00hQXJ002I004R6QXJ0>8
00EXR6R8J002I004J8a/J0:800J<J6QTJ6`4J003K8QX009X00I/R6QXR8`2R006S8Q/R6R<0hP4S003
R8b<00:<00>8S8`00XP00fR<R003R0><00F8S8b<R006S003K8b801:<00>8S8`02X`01jb<S8b/S:`0
2h`2[0:<00>=[8`00h`00jb<S007S003[8b<01R<00038003020T008P00<094@00b02900302@T0094
00HP@2@P@202900684@PA40T0d@29005A210A2@00T02A00396A000I400MTA6ATA6A4009T00A4I41T
0T@01VAPI6A4I09400IXI6QTA6P4I004J6ATI0=X00UTJ6B<J6AXI6P00f@00dAXI004J005I6QXI8P0
16P00hQXJ003R003J6B800=X00=TJ6P00VP01FB8J6R800AX00>8J8P016P01hQXS8b8J6`00X`2R005
K8R<J8P00h`01XR<[8b8J0B<00F8S8b8J004S003J8b<00:<00IXS8b<J8P4S003K8b<00:<00=X[8`0
6X`01jb<S8b/S8P00h`00jb<S005S004[8b=S@:<00N/S8b<[8aX00:<00B/S8R=28`00fR<S002S003
J:b<00><00B/S8b80h`00004920P90@P00<T@2000b@00d000002908P00<T@2@00R002bA4A40P9414
@20T00=400A094140T03A003@4A400940T001dAPA4ATA6@00T@4I004A6A4I09400MTJ6API6QT00=4
00ETA6AXI002J09T00AXI6QT1FP018QXJ6@3J09T0VP2I09X00>8J6P00VP00hQXI002J006S6QXR8a/
0VP01XQXJ6Q/R09X00>8J8P00VP03ha/R6QTR6b8J8R<K8QXR002S005R6R<S6`00XP3S003J8b<00F<
0XP3S0:80h`00fR8S002S0:80h`00fR<S002S003R8b<00:<00>8S8`05H`01:b<S8P2[0V<00>/S8`0
2h`00jb<S00<S003SHb<00><0XP3S003R8b<00:<00>8SH`028`0000382@P008P00<080000R00100T
84020008@20P90140402800EA2A09210840T84@P@4@PA2A0A214009000M4@6@T@4A0009400I0A41X
I403A00?I41PA6A4@6A4J6A0I4AX009T00EPA4ATA002I09X0V@014ATR6@5J0=T0fP3I0QX0V@00faX
J002I09X00J8J6R<J8P2I003R6QX009X00><J6P00VP2R0=X00>8J6`00VP00hQXJ002J006R6QXJ6B8
0VP018aXR6P2S0:800B<J8R818`00hR<S002S003R6b<00:80h`2R0><0XP3S0:80h`00hR<S002S004
K8R<R0Z<00E/S8b/R009S003R6b<00><00=XS8`018`01Jb<S8b/00Z<00>8S8`00h`00hf<R004S003
R6b<00N<00>8S8`01h`00003A20P00<P0P000b0T8002000=@2@P801082@P040P90028008@210A214
94@2809000E492A4@002A005@6A4J6@00T@01D14A41T009400]TA6A0A6A0A41XI002A0=T0T@02VAX
I6A4I6QPI4@2J09T00AXI6AT16P016AXJ6P2I09X00=TJ6@00VP3I007S6QXR6R8J003I005R6b8I6P0
0XP2I0IX00F8J6R<J002R003J8aX00=X00Z<J6QXR8b8J8R<0XP00fR8R002R003J8b<00:80h`00hQ/
S002S003R8b<00N<00EXS8b<J003S0:818`01HR<S8b800V<00>8[8`01X`00fb<S006S003K8b<00:<
00=/S8`00X`00fb/S004S005K8b<S:`02H`01:b<S:`9S005[8b8K6P048`1S@6<0H`00003A20T00HP
00H0900T8002800>A200A214800T84@P04@2@00B8014921096A0A20TA414@21T0d@02b14@4AT@6A0
A6A000940V@01d14A4AXA4P00f@01TATI6AXA0=T00=XI4@01F@00fQTJ002I0=X00ATJ6QX0f@2J003
I6QX009X00=TJ6P01FP016aTJ8`2J09T0fP00hATJ002J006R6R<J6B816P00hQXJ002J003R6QX00:8
0fP00hQXJ002J003R6R<009X00><R6`00XP00ha/J002R004S6R<R0:<00=/R8P00X`2R0><00=XR8`0
0h`01HR<K8b800R<00=/S8P01X`018f8S8P2S003R8aX00B<00>8S8`00X`00hR<[008S003K8b<00Z<
00B=S8b/0X`00jb<S002S003[6R<00B<00EXS8b<K006S006R8b<K8b80h`00003800P00<P00@0820P
0R@01R0T920080<T00`0800T@210921484029003A2A4009400=084000d@01B14A41T00=400=0I4@0
0T002DAT9414@6A4@002A003I4A400=T0T@3I0940f@01fQ4I4ATJ4@00V@2J006I6QTI6QT0VP00fAX
J002J0=T0VP3I09X0V@3J09T00EXS6aXI006J003K6R800=X0XP=J003R8aX00>800=/J8P00XP03haX
R6R8S6R8S8R<R8aXR004S0:800IXS6aXR6P2S003R8b800:<0hP01Fb<R8QX00N<00>8S8`028`016R<
S8P3S003R8b<00^<00>/S8P00h`2R0><00>8S8`018`01Zb<S8b=[0R<00B=[6Q/0h`016aXR6P2S003
K8b<00J<00=/S8`00H`0000482@P90@P00DT800T8002900402A4008P00<T@2@00R0022A092@PA40T
0T@00bA09002@004A40T@0=400<T@4@00T@01D14@4AT00900T@01F14A6A4009T00=4I6@01D@2I003
A6AT009T00=4I6@00V@01TATI6QTJ09T0fP2I09X0f@2J09T0fP2I0=X0f@00faTI003J006R6QXJ8QT
16P00hQXJ002R003I8QX009X00ATJ6R80fP2R0=X00B<R8QX0X`2R006J8aXR8aX0X`00hR<S004S0>8
0h`01hQXK8Q/R6`00X`2R0><00MXS8R<[8b800><00=XS8`02X`00fR<S003S005R6b<S8P028`00jb<
S002S003R8b<00:<00>=S8`00h`2[0f<00>/S8`01X`016b<K6P3S003J8b<00f<0F`0008T00<08200
0R@01P0P800P00@T0R0290<P00=494@00R002T@T@20TA21482@3A08P0T@3@006A214@4AT0d@01414
@402A009J410I4AX@4AX009T00=0A6@00V@2A006J6AXI4AX0f@034AXI6AXA6Q4I6QTJ0=T00I4J4AT
J6@4J003I6QT00AX00=TJ6P00V@3J006I6QXK6QT0VP01XQXI6R<R0IX00N8J8R8J6b<009X00N8S8b<
R6R<00=X00J8S8aXR6P2S0:81X`01Xf<S8aXS09X00><K6`00h`01hR<R8R<J6`00h`00hQ/S002S003
R8b<00:<00IXS8b/K8PBS003R:b<022<00=XS8`00X`00hQ/S002S003J8b<00:<00=XK8`00X`00hR<
S007S0000b02908P00<080000R001@0T921000<T0b004T@0940T82@P@210941494@T@0=400<TA4@0
14@00fA4A002A008I4A0A41TA403A09000=PI6@00T@01V14J6A0I09X00ATA6AX0V@024ATJ6AXA6AX
0V@014AXJ6@4J003I6QX00EX00=TJFP016P01fB8J6QTJ8P00VP3R0AX00B8J6R816P00hQXJ005J008
I6QXS6QTJ8`2J0:800><J6P00XP018aXJ8P2S0>800N<J8b<R6b800N<0VP7S003K8b<00:80X`01HR<
S8a/00:<00>8S8`02H`01VR<S6R<R0:<0XP3S003R8b<00:<00>8S8`00X`00hR<S00IS005R8b<SH`0
0XP00haXS002R0><00AXS8aX0X`00fb<J006S00000@T84@P0R@00`0T0002908P00DT82@P9002800D
9214921482@P04@T@20TA2A49203A005@214A2@00T@01FA4@4A000Y400ATA4AX0V@2A003I41T0094
00YXI6ATA6A4I6Q40f@00fQTI002I09X0f@016QTI6@3J004A6QXK09T00=XI8P00V@2J003R6QX00MX
00>8I6P01FP01XQXJ6aXR09X00B<J6QT0fP018QXJ8`2J003R6b<00:800><K8`00VP00hb8S002R0:<
0XP4S005J8b<S8P018`01VR<S8b8J0B<00J8S8b<R6P3S0:800>/S8`01X`01XR<S6R<J0J<00A/S8b8
18`01XR<S8b/R0:<00>/S8P01X`00jb<S002S003[8b<00:<00>/S8`018`00hR<S006S0:80h`00fR8
S002S0:80X`01VR8K8f<R0B<0002908P00]002@P920T020T8002900384@P008T00Y4920P940T800T
0T@28005940PA2@00d@00d14A00<A003@4A400A400E8A4A4J004A004J4A4A09T00=4I6@016@2J004
I6QTI09X0V@7J09T16P016AXR6P2I0=X0V@3J007B6QXJ6AXR006J004R6QXR09X00>8K6P01fP00hQX
J005J004I6QXS09X00F8S8aXR003S003R8b<00:<00B8K8aX1X`02XR<S6R8K8b8J8P3S0:80h`00fR8
S002S003R8b<00Z<00F8S8b<R009S004R8b<T0J<00F8S8b<J00:S003[8b<00F<00B8S8f=1H`00fR8
K002S0:80h`00fR8S003S003R8b<00:<00A/S8b<0HP00004840080<T0P000b@P8002008T00HP0210
82@2000=A00P900T84A084@PA002800<A214921T84A094@T0d@01fA4A4@TI40014@2@003I4AX0094
00QTA6AT@6A4I09000EXA6QPA002J0=T0VP3I003J6AT009T00=XI6@00V@00fQTI007J006B6QXJ6AX
0V@01FQTJ6R800=X00J8J6QTJ8P3J007I6QXJ8AXR002J003Q6QX009X00>8J6P00VP03HQ/J6AXR6aX
I6R<K6P00XP00ha/J002R006S6aXR6R<0VP2R003S8QX00:800=/S8P00XP00hb8R002J005S8R<S8P0
1X`00hR<S002S003R6b<00:<00J8S8b<R6P8S003R6R<00><00M/S8R<J6b801B<00A/S8a/0h`00hR<
S002S003R6R=00><00F8J8f<R009S0680H`1S00000PPA2A0900P008P00L0800P9010008P0P001b@P
82@0@2@00R001`14821404@00R001b@PA2@PA2@00T@0241486A4I4@T0T@00d1T@002A009@4A0I4Q0
I41X009400=TA6@00T@2I007A6A4I4AYJ003I09X0V@026Q4I6AXI6QT0fP2I003J4AT009T0VP00fUX
I003J09T00=XI6P00V@00fQTJ005J003I6R800UX00>8I6P00VP00hQXJ002J004R6QXR09X00ETJ6QX
R002J0>80VP00hb8R002J006R6aXR6R80VP2K003R6QX00B80X`00fR8J002S0:80h`00fR8S002S004
R6b<S0:818`00fR<S002S005J8b<S6P018`00fb<S002S005J8b<S8P018`018QXS8`2R003J8b<00:<
00=/S8`01h`026R<K6b<J8a/0X`3R0:<00=XS8`00X`00fR8S002S003R8b<00:<00=XS8`00X`00004
A20P@08P0P001B@08200008P00`T801082@P02A094@2900582@P94000R001400@402A00394@T0094
00PT@40TA2A4@09400<TA4@00T@02RA4A4APA414I6P3A09T0T@3I09400ETJ6ATA004I09X0V@4J003
A6QX00=T00=YJ6@00V@4J004I6QXJ09T0VP00fAXJ002J004Q6QXR0=X00=8J6P02fP01XQXJ6Q/R0AX
00>8J6P00VP01XaXJ6R<R09X00N8K6aXK8a/009X00=/S6`00VP016b<J6P2S003R6R800:<0XP3S003
R6Q/00:<0XP8S0:80h`016R<S6`4S003J8b<00:<00>8S8`00X`2R0><00>8S8`00X`00fR<S002S003
K8b<00B<00>=S8`00X`00hf<S@02S004J8b<K0>80h`00fR<S002S003R8b8009/1h`00hf<S006S000
00/T84@P020092009003800802@PA2009002900<02@T9200A20T801412000d@T90028007A410@214
@002A00794A0A6@PA002@004I214@09T00E4B6A4I002A005I4AT@4@016@01DATI6A400=T00=XA6@0
0VP3I005J6ATA6@00VP2I007A6QTI6Q8J002I0=X0V@3J09T00F<I6QXI003J09T16P00fA/J009J003
R6AX009X00>8J6`00VP2R003S6QX009X00J<I6R8S6`2J003R6Q/009X00N<J8b8K8aX00:800EXS6QX
R002S003J8R<00:<00AXR8b<0fP2S0:80h`00hR<S002S0>80X`00fR<R002S003R8b<00><00B8S8b8
18`01HR<S8aX00:818`00hR<S00;S003R8b<00><00E/S8b<J004S005J8R8S6`00hP01XaXJ8b8S@:<
00>8S8`00H`00009900P82@P0200008T00<082@00R@02`0P920T020T84@T00@P00<0@2000T02808T
00=484000R@00d@P@0029003I2@P00=414000fA4A002@003I4A4009400=TA4@00T@00fA4A002A09T
00A4I6AT0T@4I006A6ATI6Q40VP2I006A6AXI6QY0VP3I09X0f@2J09T0VP016aXI6@2J0=T2fP00hQX
J002J003I6QY00=X00J<JFQTJ6`3J007I6aXR6AXK004J003S6b<009X00F8J8a/J002R005S6QXS8P0
0X`016R<J6`2S004R6R<K0:80h`2R003J6b<00:<00>8S8`00h`02Vb<S8a/J8b8S6`3S004K8b8R0B<
00B8S8b<0XP3S0:80h`00hR<S002S003R6b<00Z<00>=S8`00X`2R0B<00aXS8b<K6R<R8a/J8d2S007
K6R<S6R<J002S0000R@01@0P900P008000XP02@082@P900P0R@01B0084@000<P00=494@00R0014@T
@202@08T0R000d@PA002@0M400A0A4AT0T02A003I4@P00=T00e4@6Q4I414I4ATA21X009T0T@01VQT
I4A0J0=T00M4J4A4J6AX00AT00=XI6@016P016AXI6@8J006I6QXJ8QT0VP01XaXI6Q/J09T00=XS6P0
1FP01VAXR8aXI09X00=/R6@00fP018QTK6`3J09/0fP038a/J8aXS6aXS6R<J0:80VP026b8R6Q/J8R<
0VP02XR<S6Q/S6b<J6`3S003J8b<00:<00QXS8aXS8QXR0:<00B8K8a/0XP3S003R8b<00B<00A/S6R8
0X`00hQXR003S004J8b<K0:<00J8S8aXS8P5S003K8b<00B<00>8S8P00h`016aXJ8P2K09X00>8K6`0
0VP01hR<S8QXR6P00F`000@P0P001200800280070200920080020003800P008P00E082@T8003@005
920P84000R001D0T@2@P00=400HTA6PT8403A09000E4I4@PA002I003A41T00=400=0A4@00d@00f14
I002A09T00=XI6@01F@01F14A6A4009T0VP01FA4I6AX00ET0VP2I003J4A4009T0VP4I004J4B8R0QX
00F8J6QXI002J0=T00N8J6QTJ6aX009T00=XK6P00V@00fQ/J002I003J6b800=X0V`028QXJ6R8J6b8
1VP00hQXJ002J00>R6aXR6R8S6R<J8QXK6P2R003S6R800:800N<J8Q/R8aX00:<0fP01ha/R8b8S6P0
0XP00fR<K002R006J8b<J8QX0X`2R003J8b<00:82H`01fR<S8b8S8P00h`016b<J8P3S005R6R<K8d0
0VP2K008R6AXS6R<J8P3S09X0H`1J06<00000b00900280<00R001R@00200808T0R029006020P920T
0R0290<P00<T80000T002D@T840PA2@P@003A0068410940P0T000dA0A003A004@214@09400=0A200
1T@01FA4A6A400=T00AYI6A40VP01TATI6QTA09T00EXI4ATJ003I004A6QXJ09T0VP3I004J6AXI0AX
00=TJ6P00fP00fAXJ003J09T1FP00faXJ008J006I6QXJ6b816P018QXR8P3J003K8aX00=X00F8J6Q/
R004J009S8QXJ8R<J8QX00B800]/S8f8J6b<J8QXK003S009R8b<J8aXK8QX00:<00=/S6P00X`00fb8
S002S0:800=XS8`00VP01Fb<S8Q/00><00>8S8`00X`016b<S8`2R0><00B8S8b80VP2S003R6QX00:<
00F8J6Q/S004J007K6QXJ6b<R002K003R8b800><0VP1S00000@P02@012001@0T900T00800b020004
800P908P00L082@TA210008P00=082000R02A004@2@TA0<P00E4I4109003@09400<PA4000T@01bA4
A21TA4000T@00fA0A002A007I414I4ATA002I006B6U4I6Q40f@00fQ4I002I004J6ATI0=X0V@2J094
00=XI6P00T@3J003I6QX009X0V@8J09T16P00fAXJ006J003R6AX009X00J8J6QXK8P7J0><00AXK8a/
0VP00fb<J002J0:<00>8J6P00X`028QXJ6R<R6Q/0X`00hQXS002S09X00b<R8R8J8aXK8QXS6`2R007
J8aXJ8b8S003R005J8b<R:`00X`018R<S6P4S005J8R<R8`00VP3S003J8b<00:<00>8S8`00X`00fR<
S004S005SHaXR6`00X`018R<K8`2J003S6aX009X00><K6P00VP00ha/J002J005S6QXR6P00X`00080
00<P02000P004B0T800T02@P02@P920T020T008P00L084A0800P008T00dP040T840T@214@2A00094
00]094@P94@TA40P@002A003841T00A400=TJ4000T000fA4A002A003I4A400=T0T@01FA4I6A400ET
00EXI6AXI004J003I6Q400=T0VP02DATJ6AXA6AXK003I0MX00=TJ6@00fP01fAXJ6R8J8P02fP2R09X
00>8J8P00VP3R09X0hP00faXS002J004S8R8S0:800=XS8`00VP00hR<S002R004J8b<I0:800><J6P0
0XP2S00=J8Q/K8QXR6R<R6R8K002S003J8R800:800B<R6QX0X`016b8S8P2K005R6R8S6`00XP3S0>8
0V`2S003R8b800:<00R8S6b<K8R<R0:<0hP00he/J002R003S6aX009X00B<J6R80fP2R004S6b8S09X
00M/R6QXS6b<006800001b0T000P02000P000b@08002000:@00P800P020090@P01L0920T801082@P
040PA20TA20T82A4I002A00<84@PA40TA210A4140T0016A0I402I0940T02I004A414I0940V@02VQ4
A4ATJ4ATA6@2J09T0fP3I003J6AT009T0VP3I003J6AT009T00=XI6@016P016AXJ4@2I003J6A400AX
00MTJ6QXI6QT009X00>8J6P00fP01FAXJ6R800AX0XP2J003R8aX009X00V8K6QXR6R<K6P00XP2S0=X
00I/R6R8J6`4J003K8QX00:800><R6P00XP016R8J6P3R09X0X`01XQ/K8QXR0><0VP00fb<S003J005
R8aXJ6`00XP2J0R<0V`4S00?K8b8K8a/R6R<R8b8J6b<009X0X`01XQXR6R<R09X00a/J8QXK8R<R6Q/
R8`2R005K8b<J8`00F`0000482@P808000XT020T020082@012000`0P8002800302@T008P00<0@000
0R000`148003800<@20PA210941494@P0T@01R1TA414809400A0I4140T0016A094@2I09000ETA6A0
A003I09400MXI6ATA6A400IT00IXI6ATJ6T2I0=X0f@00fUXI002I004J6ATI0=X0V@3J09T0fP00dAT
J006J004I6QXJ09T0VP01XQTJ6QTR09X00R8J8aXJFaXR09X00J<R8R8J8`4J006S6R8R6R80VP00haX
R003J0:800IXS8QTJ8P2S003R6R<00:<0XP3S09X0X`2R0><0VP3S006J8aXS8QX18`01VR<S8b8J0><
00=XR8`00X`2J0><00Z8S8b<K8b8S6Q/18`02XR<J8aXS8QXS6P2S09X0h`00fAXJ002S006J8R<SHaX
0V`2S003J8b<00:<000012@09203000B8000800T800T02@P02@092000R02@003020T008P00`0A20P
@214921084@28003@214008P00=004@00T000d@PA002@004A214@09T00<P94@00V@00b14@002I003
A2AT009T0T@01FA4I6A400=T00=PI6P016@01VQTI6A4J0AT0VP2I003J6AT009T00A4I6AT0fP2I003
R6QX009T0VP3I09X00MTJ6Q/J6AX009Y00QXI6QXK6QTR0UX00F<R6R8K002R00<J8QXJ8QXR8a/R6R8
0VP00hQXJ002J006R6QXR6R80fP2R0=X0XP3J004R8aXJ0:800><J8P00XP01HaXR8QX00:<0XP01fR<
R6R8J8`00hP01fb<R8R<J6`00XP01Hb8J6R800><0XP3S006R6a/S6R80X`3R09X00>8J6P00VP01XaX
J8QXR09X0hP2J003R8a/009X00>8J6`016P1K05X00001B@0800P00<00b@30007920002@P90020004
82@P00@P00`0@20PA00P921494@2800;A20P921084@T@4@00R@2@006A414A21T0T@00fA0A002@094
00QPB4ATA6A4@09T00IPJ4ATA6@2A004I4ATJ0AT00AXA6Q40V@00dATJ004I004B6ATI09X00=4J6@0
16P016AXJ6@4J006I6QXJ8QT0fP018QTJ6P2I0=X0V@6J003K6QX00=X00^8I6Q/J8QXR8aXR002J003
S8QX009X00J<J8Q/J8`4J006R6QXK8R<16P01XQXJ8QXR09X0XP3J00DS6QXJ8a/J8QXR8aXR8aXS8R<
K6@2R003SHaX00:80X`00fR8S002S09X0X`2R0B<00EXS8b<R004S004R8a/S09X00B<J6b80VP01Hb8
J6R<00AX00><J6P00VP00haXJ002J003S6QX009X0V`00005020P0200100012000204000382@00080
00<P02000b00100T92@4800694@P@20T0d001B0TA2@P00A400A0A2AT0R03A005@2ATA6@01T@00bAT
A003A0=T0T@2I004A6A4J09400=TB6@00f@00dATI002J006A6ATA6A40V@01FQTA6A4009T00A8A6QX
0f@7J003R6QX00UX00I/I6QTJ6`2J003I6aX00EX0V@3J003I8QX00=X00>8J8P00VP01XQXR8QXK0=X
00>8S6`00fP01XaXJ6R8S0AX00^<J6R8J8b8J8QXR002J004R8b8R0=X00B8J6R80fP02Hb8K6b<K8QX
R002S0>80X`00hQXR002S0:80X`016R8S6P7S005R8b<S6P00h`016R8S8`2J004R8b<K09X00M/S6aX
R6b=009X00>8J6`00VP00hQXK002J004S6Q/R05X00001@0P000P00<00R001`0P020T02000P001200
8004800:920T840084@PA08P00M484@084@000<P00=482000T02A09000TPA2@PA414@2000d@0140P
I402A00386AT009400=0I4@00V@00d1XI002I003A6Q4009T00M4J6A4I4AX00=T0T@4I007J6A4I4A8
I002J006I4ATI6QT16P2I0=X00=TJ6P00VP016AXJ4@2I0=X00=TJ6P00VP016AXJ6P2I0=X0V@00fQ/
J002I0=X00R8I8a/J8QXK09X00J8J6a/J8P3J0:800EXK8QXR002J0>80fP01hR<J6R8J6`00VP2R0=X
00J8J6QTJ8P2J004R6QXJ0:800F<J6QXS004R00<S6QXJ8R<J8QXR8a/0VP018R<S6P2R007K6QXR6Q/
R003J004S6R8R09X00F8J6R8J002R006JFQXR6Q/0VP016AXK8P4J004R6R8K05X00028005020002@0
0R020003800P00800R00200T020082@00R@3800=921082A484A084@TA0028003A2A400900T@00b14
@002A09000@PA4@P14@03210A6A484A0A6A0A0=T00I0I6AXI404I003A6AT009T00EXI4ATJ002A0=T
00aXI4ATJ6A4I4ATJ4@3I09X0f@2J003R6R400=X0V@2J005R6QTJ6@00VP00fAXI002J0=T0VP2I09X
00A/I6AT0fP00fAXS005J008R6QXJ6b8J8P3J006R6QXJ8B80fP01XQ/J8QXI0=X00ETJ6aXR002J003
K6QX00AX0XP00fR<J005J006R6QXR6R80VP2R003J6b800>800=/J8`00VP3R09X00N<J8a/J8b8009X
00M/R6R8K6R800AX00N8J6Q/I8R<00EX00A/J6B80VP02XaXJ6Q/R6R8S6`3J05/0FP1R00000<P0200
0b0400069000800P0P0280039000008P00HT001084020005@21492000T0014A00402A00<@21082A0
940PA40P0T000bA08002@003A40P00=40T02A00394@P00A400M0A4AXH41400=T00=4I6@00f@01FQT
I6A400AT0VP2I004A6Q4I0940VP2I005A6QXJ6@00VP016AXI6@2J09T1fP016AXI6@5J004I4QXJ0=T
00=XR6@00fP2I003J6a/00=X00F8K6QXK002R09X00M/S8QTJ6b800UX00>8J6P00VP00fAXJ003J003
I6R<00:80VP016aXJ8P3J003R6a/00AX00E/J6R8S002J003R8b<00=X0X`3J0:<0VP00hR<J002J004
S6b<R0=X00J8S8b8K8`2K003R6QX00:<00>8J6P00X`016R8J8`4J09/0fP018aXJ8`2K09X00><J6`0
0VP1S0000R000d@0000200068000800P10001B@00200008P00<080000R000`0T8002800304A0008P
00<0@2000R000`148002900704@094@0A0028004@214@09400/P@214I214@4AT8003A003I4140094
00IT@4ATA6@2@004I4ATA09T00A4I4AT0VP2I003A6QT00=T00EXI4ATA003I003J6AX00940fP2I09X
0V@01dAXI6AXI6P00V@3J09T00=XI6P00VP018QXJ6@2J003I6QX00:800MTJ6QXR6AX009/0fP00faX
J002J003R6QX009X00>8J6P00VP00haXJ002J004K6QTK0=X00ATJ6QX0V@3J09T00=/J6P00V@01Vb8
J6AXS09X00>8J6P016P02FaXR8QXK6R8S003J0:<00EXK8R8K002J003R8b<009X00>8S6P00VP00hQX
J002J009S6QXJ6UXK6R800AX00><K6P00VP00faXJ002J003S6aX00EX00>8J6P016P1K05X00001B@0
800T00<000LT020082@P008000DP920P00048008020T9200@2@28003020T008P01X082@P@00P9210
920T84@T@4@P@2A0A414909000=4I2@00d@00fA4@002A003I4AT009T00aXA4ATA6A4@6AXI4@;I09X
0V@014AXJ4@2I004J4Q4I0=X00=4I6P00fP00fAXJ00:J003I6QX009X00B8I6UX0V@2J0=T1VP00fUX
J00=J004R6QXR0QX00MTQ6R<K6QT00=X00MTQ6Q/J6B800=X0V@4J004R6QXR0AX00>8J6P01fP01HQX
J8QT009X00MYR8R8K6R8009X00><K8P00VP00faXR002J003K6R8009X00>8J8P016P00haXJ002J003
S6UX009X0V`00fR8J002J004R6QXK0=X00=/J6P00fP1K05X0FP0000782@0020080070003800P0080
00DP02@0900480030200008P00d08214@01082@P0200008P00L0@20P@2@P00=000LT@20PA20T0090
00M4@2A4@6A4009014@2@005I4A0A4000V@014AT@6@2A003I4AX00AT00=XI6@00V@00fQTA002I003
J6AT009T00=YI4@00V@014QTI6@2J0AT00AXI6QX0f@4J004I6QXR0IX00ETJ6B8I002J003I6QT00]X
00>8J6`02FP00faXJ002J003S8QX009X00><J6P00VP00faTJ007J003R6QT009X00>8J6P00VP018eX
J6P2R09X00=/J6P00fP00haXJ002S0=X00J<J8R8K8P4J0:80fP02hQXJ8QXR6Q/R6b8009X00>8J6P0
0VP01XaXJ6Q/S0AX00><J6P00VP01XQXJ8R<J09Y2VP00003920000P000HP000P02040005900P9000
0R002@0T020082@0A0028003@00T008P00HT020084@28008A214840P@4@28003@21T008P00E4@6A4
8004A007@4A4I40PA002I09400=TA4@00T@01FA4I6A400=T00=XI6P00V@00fQTI002I004J6ATA0ET
00AXI4AT0fP2I09X00=TA6@00fP2I0=X00ITJ6QXA6@5J003K6QT00AX0V@3J09T2VP018aXJ8P:J005
B6QXJ8P00VP016AXR6@3J003R6QX009X00J<J8R8J6@2J003S6aX009X00><J6P016P018QXR8P2J006
K6R8J6B80fP01fB<S6aXI6`016P00ha/J002J003S6QX009X00I/J6R8J6`2J003R6QX009X00F<J6R8
S@04J003R6QX00AX00=YJ6P00VP00dAXJ004J06<0FP1J0000R020005900P02000P00120002@28003
0200008P00<080000R000`0P90028006020P840T1200200P8210920T0T001B@P821000<P00=4I4@0
0T0014AT8203A08T00=TB6@00T@00fA4I002A0AT00=4I4@00V@00dATI007I004A6ATI09X0f@2J003
I4A4009X0V@2A003J6AT00=X00=TJ6@00VP00fAXJ00?J003B6QX009X00=TJ6P00VP00fAXK00:J004
K8QXR0MX00>8K6P00VP00hQ/J002J007R6aXJ6B8K003J003R6aX009X00>8K6P00VP00hQXJ005J003
R6QX009X00><K6P00VP00ha/I002R0:<00=TJ6P00X`02VB8K6b8J8QXK8P4J003R6R8009X00>8K8`0
0VP00hQXJ002J004R6QXR0=X00=YI6P01VP00fUXJ003J004JFQXR09X00B8J6QY0VP00003800P00L0
00HP020P02@200048000008P00<082000R000`0T9002800302@P00<P00=482000R005R@P820082@P
@20T@210JBA0A6A0A402A08T0T06A003@4A4009400E0JFU4I002A008I414I4ATA6@2A0AT00A4J6A4
0f@00dATI002A09T0VP3I003J4A4009T00=XI4@00V@2J0=T00=XB4@00V@2J0=T0VP2I0=X00=TJ6P0
0VP00fAXI006J003I6QX00=X00>8J6@016P01XQXJ6aXR0AX00>8J6P00VP01XQXJ6R4R0AX00>8J6P0
2VP00hQXJ002J0:800=/J6P00VP00faXJ002J004S6QXI0YX00>8J6P016P01FAXJ6b800QX00>8J6P0
0VP00haXJ007J003R6QX00]X00EYJ6QXR003J00000<T02001`000b@00003908P0P001R00800P908P
00<084@00R000`0T80028003021400@P00=084000R000d@PA0028005A20PA4000T@012A4@4029006
A410A2140T001B@PI4A0009400=TJFT00VT04FA4A6Q4J6A4J41TA6AX@6A4009T0d@2J0=40V@00d14
J002J003I6QX00=T0VP3I003J6AT009T0VP016AXJ6P2I0EX00ATJ6AT0fP2I0=X0V@3J005I6QXJ8P0
0VP00haXJ@02J003S6QX009X00><J6P00VP00hQXJ003J09T0fP00dAXR008J004I8QXR09X00><R8P0
0VP01XQXJ6QTR0=X00=TR6P00VP00fB8J002J004R6QXK0:80VP01Vb<I6R<K0AX00Z<J6QXS8QXJFR<
16P02XaXJFQ/S6QTJ6T2J003I6aY009X00M8K6QXI4A/00=X00=4J6T01FP00005020P92000P002B00
800T800P00028009900T920T020T00<P00H082@T80029005020094@00R000`0T@002808T00=48200
0R@3@0940T03A003841400940T000bA4A003A006I4A4A6UT0VT00fA4A002A007I4A4I4AXA002I003
A6AT00ET00I4I6QXA6@2A09T00M4J6QXI6QT009X00=TA6@016P016AXJ6@7J004I6QXK09T00=4J6P0
0f@6J003K6QT00AX00>8J6P00VP00hQXJ002J006S6QXJ8R<0VP00hQXJ004J003R6QX009X00><J6@0
0VP00faTJ004J003I8Q/00=X00J8J6QTJ8P3J006K8QXJ8Q/0fP00hQYJ002J003R6QX009X0V`4J003
K6R<00EX00E/J6QXS004J003S6aY009X00><K6P00VP00haXI002J004S6aXR0=X00ATJ6Q/16P00fUX
J004J05Y00001b0T000P02000P000b0080020003800P008000<P00000P0022@P820090100P048007
040P9200A003800494@P908P00M4@21494@P009000<PI2000T002R14@21T@4A086@3A004@6A4I09Y
00MXA4AT@6A4009T00A4I6A00V@01VQ4A6A4J0=T00=4J6@00f@00fQTI002I004A6ATJ09400=TJ6@0
0T@2I00:J6ATJ6AXI6R8J09T00A4J6QT0VP2I0AX00QTJ6QXJFAXR09X00=TJ6P00VP026B8K6QTR6Q/
0VP00fAXK004J004K6QXI0aX00>8I8P00VP00fAXJ009J006K6QXI6UX0XP3J003R6QX00IX0XP3J003
I6QX00=X00=/J6P00VP01faXJ8QXK6T00fP01VaXI6UXK0AX00=/J6P00VP00faTJ003J006R6QXJFQT
0fP00fUXJ006J00000<T00000P00120002040003800T008000<P02000P0022008200800T0P048006
020P92000b02000:@20TA01082A0809000TT@21084A084000d@01D14@4Q4009000=TA4@014@2I004
A6ATA0=T00AXA6A40V@00d1TI006I0940f@2A006J6ATI4AX0f@00dAXI002I003B6QT009T00Q8J6AX
I4AXI0=X0V@016QTJ6@5J004I6aXI09X00=/J6@00fP00hQXJ009J003K8aX009X00><J6P01VP016b8
I6@7J003K6QX00UX00>8J8P00VP00hQYJ003J005S6QXJ8P016P00haXJ002J003K6QX009X00J<J6QX
K8P2J006S6R8J6b<0VP00haXJ003J006K6QXJ8Q/0fP2K0=X00><K6P00VP00haXJ002J004K6QXK0EX
00=/J6P00VP00003020P008000<P00000P000b0090020008900P900T02020007800T800P00028003
02@0008P00<092000R001`14820T84@00R0024@PA210A2140T003D@P@210I210I41T84000T@00fA0
A002A003I41400AT00E4J4ATA006I006J6A4I4AX0T@2I006J6A4I4AT0T@00fQTJ002A003J6AX009T
00=XI6@00V@01fQTI6A4J4@00f@3J09T00EXI6AXA007J003K6Q400EX00=TK6P00fP00faXJ002J003
R6QX009X00>8J6P00VP026aXJ8QXS6QT0fP2I0=X0V@00hQXJ002I004R6QXR0IX00F8J6B8I009J003
JFQX00AX00>8S8P00VP2R0=X00>8J6`00VP018QXJ8P8J004I6QXI0AX00=YI6P016P016AXJ6P2I003
K6QX009X0V`8J05/0FP00005900P02002@001b@0020082@00`028007020T020080029004800P908P
00<082000R0042@P9210940T840T@2@P@2@38003@2A0009000=TA4000T@01FA4@6A4009T00HTI4AT
A403I004A41TA09T00=4I6@016@2A005I4AXI4@00V@03VQ8@6A4J6A0A6AYI4AT0fP2I003A6QX00=T
2VP00fAXJ004I003J6AT00EX0V@4J003I6Q800AX00=TJ6P01fP00fAXJ005J005I8QXK6P00f@00faX
I002I09X0f@3J003I6QX00YX00=TJ6P00VP00hQXJ008J003K6UX009T00E/J8QXI005J003K6QX00AX
00F<J6QXJ@04J003I6QY009X00ETJ6QXI00;J003K6QX00YX0002808000<P02001`000b0090020006
800T800P0P003200800T801002@P00@P00D082@T@0038005940P@2000T029004@4A000<P00A082A4
0d04A005@214A6@00T0026A4I4A0I4AT0T@00fA4I003I005A6A4A6@00T@3I009A4QTA6A4B6A4009T
00A4I4AT0VP01FA4I6AX009T0VP3I003J6AT009T00=4J6@00T@4I09X00=TA6@00fP01fA4J6QTJ4P0
16P00dQXJ002J003A6QT00QX00ATJ8b81FP01VAXJ6R8I0=X00>8J6P00VP018QTJ6P2R003I6QX00IX
00ITJ6R8J6@4J005JFQXR6@046P00faXJ003J004JFQXJ@9X00AYR6QY0VP00hQYI008J09Y0VP00hQX
J@06J004JFQXJ@=X0FT1J00000<P00000R000`0P00060003800P008000HP020P02040003A00P008P
00HT020082@28004020T00<P00=482000R001V@P82@PA08P00=484@00R000d0PI0028005A414@200
0d@01d0PI4ATA4000f@02DA0I414I4ATA002I003@6A4009T00=4I4@00V@01TATI4AT@0AT00=4I4@0
0V@01TATA6AXI0=X00ITA6AXI6P2I004J6ATI0=X00A4I6QX0T@3J09T00=XA6P00V@3J09T16P00fAX
J006J004R6AXJ0:816P00hQXJ002J003S6AX00AX00ETJ6QXI004J003I6QX00AX00B8J6QT2fP00haX
I003J09T00>8J6P00V@00faXJ005J09T00I/J6R8J6`8J003I6QX009X00=TJF@00fP01FUXJ6UT00AX
00=TJ6P00fP024AXJ6QTJHQX0FT00003920000D000<P00000P001R000200808000<P02000P000b00
00020006800P02100P00120080038003@00P008P00I082A094029003@20P008P00=094@00R02A005
I20P@4@00T0022A4A4A0961T24@01fAXA6A4I4@00V@024ATI4ATJFA40V@4A004I4A4A09T00A8A4AT
0VP01TAXI6AXI09X00=YJ4@00fP2A0=X0V@01FQ4A6A4009X0V@3J003A6AX009X00A4I6QX0f@2J003
I6QT009X00>8J6@03FP016UTI4@3J004I6R8J0=T00=XK6@016P016AXJ6@9J003JFAX00AX00MTK6QX
I6Q/009X00ITJ6aXI8P3J003I8QX00UX00=YJ6P00fP00fAXJ002J@AX0V@3J09T0VP00dQXI002J008
B6QXI6Q8J4P2J0540FP00003800T00@000<P00000`000b0000040006900P800P0P000b0090020003
800P008000M092@T020000<P00U082A0840P92000T028005@21082@014000b108002@00694A0A40T
1D@01FA0A4@T00=400=TA6@00f@3A0AT00=4J6@00V@01DATI6A400=T0T@016A4I4@3I09X0f@00fQT
A002I004J6ATI0A40V@01TQTI6A8J0AT00A8I6AT0VP01FAXJ6AX009T0fP00fAXJ003I09X0f@2J003
R6QT00AX00AYJ6QX0V@2J003R4A800=X00=4J6P00V@016Q4J6@2J005B8QTJ6@02VP2I0=X00=TJ6P0
1VP00fAXJ002J0=T00>8J6P00fP00fUXJ006J003R6Q400AX00E8J6QXJ@04J005I6UXJ6@016P026AX
J6QYI6Q40VP1A05X00020003800000P000DT00008002908000<P90000P02908000hT82@09010800P
920T808T00PP92A4840P008T00I0821094028007@2A0@2149002@00384A0009400@P@4A00T@016A4
A6@2A003@4AT009T0T@4I003A6A400=400ITA4ATA6@2A003I4AT009416@014ATJ6P2A008I6QXI4AT
J6@2J006I6QTI6QT0T@2J003I4AT009X0V@2J003JFAT00=X0f@2J003I6QX009X00=TJ6P01VP00fAX
R006J003A6QX009X00MTJ6QXI4AT00=X0V@2J004I6QTI0UX00=4I6P01fP2I0=X00=TJ8P01VP01FAX
J6Q800EX00=TJ6P00fP00faXJ009J006A6AXJ6UT0VP026aXA6AYJ6U40fP01VU4JFUXI0EX0D@00003
920000P000<P00001@000b@0000200089000800T82@2008P00@T02100R020006@20P80140b003014
001082@P0400A08P00]492A084@TA40PA004@006A2A4I41T0d@01D1TA41T009400ETA6A4B002A006
I4A4I4AT0d@2I09400ETA6A0A003I0940V@01FQ4I6Q4009T00=4J6@00V@00fQTA003A09T00=4I4P0
16@014Q4I6@3J09T0VP014ATA6`2J005I4AXA6P00V@7J004I6QTB09T00AXI6QT0VP00fA8J004J006
I6QTI6QT0VP00fAXJ002J003I4AT009X00=TJ6@01VP00fAXI002I003J8QX00IX0V@2J003I6QT009X
00=TJ6P00VP00fUTJ@07J006I6QYJFQT0fP00fAXI002J003I6QX009X00ITJFQYJ6@3J09T00E8J6QX
I002J0000`00120T02@40003800000P000@P00000b020003900P008000HT020P040200098010900P
04@T00<P0R@2800704@T840090028007@210A2108002A0038414009400<TA4@01T@00fA4A002A006
I4A4I4AT0T@03FU4I6A4I4ATA2ATA6000T@01FA4I4Q400=T00AXA6A40V@032ATA6AXA6AXI6Q4I094
00MTA6AXA6A0009X0V@00dA8J003I003B6QT009T1FP024QXI6QTA6Q40VP2I003J6AX009T00=XI6P0
0V@3J09T0fP2I0=X0V@3J004A6QXA0IX00=TJ6P00VP016UXJ6T2J003I6QX00EX00ATJ6R80V@3J003
B6UX00MX00=/A6P00VT00faXJ003J003I6QT009X00MTJ6QYJ4AT00=X00=TJ6P00VP02DATJFUXI4AX
B006J00000<P000030000b00000200098000800T800P00@000<P02000P02800402@0808000LP0200
9400008P00<T@2000R001RA0041490<P00PTA40P9414@08P0T@02D0PA4A0A414I004A003I4A40094
00=TA4@00f@2A009J6UTI41TJ6A400ET00A4I6QT0T@01VAXI6A4J09400=TA6P00f@01VQTA6QTA09T
00YXI2A4I4AXI4AT0fP00dATJ006J003I6aX009X00ETB6QXI003J005A6AXK6P00V@2J0=T0VP2I0=X
0V@3J09T1fP00fUXJ@02J003B6Q/00EX00M8I6AYS6QT009X00A/J6AT0fP2I09X00=TA6P00fP00fUX
J007J003B6QX00EX00I4J6UXA6@3J003JDQX00EX00=YI6P00VP2A09X00=TJ4P01VP00003800P00L0
00<P00000P000b0T00020003900P008000PP000P02@080800R0012@P02@200048010008P00`0A20P
@00T021002@28004@00T@09400LPA40PA20T009000=484000T@00fA4A003A00:@4AYA6A0A6Q0I094
00ITA414JF@4A006J6A4I4AX0T@00fA4I002A09T00A4I4AT0VP016A4J6P2I003A6Q400=T00UXI6AT
A6QTA6P00T@01VAXI4A8J09T00=4B6@00VP00dAXJ006J008JFAYJ4QXI6T3J003I6QX009T00=XB6P0
0V@8J09T00=XJFP00V@<J09T0VP016UTI6@3J003I6QX009X0V@5J004JFAXJ@9X00ITJ6UXJF@3J00:
JFAXJFQYI6QYJ09Y0fP00fUTA002J005B6ATJFP00VT00fQ4J002A09T0fP2I006J6UYI4QX0FT00004
900P008P00@0800P1`00120T02040003800P00<P00<080000R00100P0002900:8000800P02A0008T
00<P@0000b000d0T8002800D@20PA4149214840T84@PA2@PA402A00386A4009400=0I4@00T@00d1X
A003A005I4A4A4000T@01D1TI6A4009T00A0J6Q40f@2A007I4AXI4ATA005I003J6AT009T0VP026AX
A4ATB6A40V@00dA8I002I0=X0f@024AXI6A/A6QT0VP01TQXJ6AXI0AX00=TJ6P00VP01VA/J6AXI0AX
00=TJ6P00V@01TATJ6AXA09X00ITJ6UTJ6@4J003I6QX00EX00ITJ6QXJF@4J003I6QX009X0V@02FUX
J6AYJ6AXI004J09Y00AXB6QT0fP00fUXJ002J005JFQXJ4@016P01DATJ6UX009Y16P01TAXJFQYB0=X
00=YA6P00FP00005020002003P000b@000050003800P008000<P02000P000b008002900880000210
02029009A00P02A40200008P00D0820PA00280=40R02@003A20T00=40T000fA4A003A00794A496A0
J002A09T00=4I6@00d@026A4A4AXI4AT14@2I003A6AT009T00I8I4A4I6P4I004J6ATJ0=T00AXA6Q8
0T@01VQTA4AXA09T00M8J6QXI4AX009T00=XA6P026P014QXI6@3J003I6QX00AX00=TJ6@00fP00dQX
J002J006I6QXJ6A40VP01VAXI6AXI09X00A8J6QT0fP016U4J6T2J003I6QY009X00=TJ6P00V@00dAX
J002J006B6QXI6QY36P00dAXJ002J004I6QYI0=X00=8J6P00VP00dQTJ002J005B4AXJFP00VT3J094
0VT4J09Y0FP1J@0000@T800T1`000b00000200038000008000<P00000P0012000002800:020002@0
9200@08000<P940012@01T@T820T808T00=0A4@00R001T0TA2@P@09400=084000d@01b10A2A486@0
0d@01bA4A4ATA6@00T@01fA4I4A0I4P00T@0141TA6@7A004I4A4A09T00=8A6@00V@01VQTJ4ATA09T
14@00fQ8I002I004J4QXI09X00=8A6@00fP00dATJ002J003A6AX009X00=4I6P00VP00dAXJ00:J003
I6QX00=T0fP034ATJ6QYJ4ATJ6UXI09X00=4J6P03VP016UTI6@2J005I4ATK6P00V@00fU/J002I09X
00=YI6@00fP00fAXJ@02J003I6QX00=X00=YJ6P00VP3J@9X00M4J6ATJ6UX009T00=XJFP00V@00fQ4
J002J00:JDAXB6Q/JFQ8I09X00E/J6QXB001J00000<P00000P000b00000200069000800T0P000b00
00020006800002@P0P029003800P008000<P02@012001R@P040P908P00=000000R001T@T940T@08P
00=084000R02@09400/TA414@2A4@4A09003A003@2AT009400=PA6@00T@01VA4A4Q4I0900T@016A4
A4@2I0=40V@2A0=T0T@2I006J4A4I4AX0d@01fAXJ4ATA6`00f@01dAXI4ATA6P01f@2J004B6ATJ0AT
0VP2I0=X0V@2J@=T00=4J6P00V@4J003A6QX009X00Q8J6AXI4AYI09X00=YJ6@016P02VAXJ6UXI6UX
JF@2J@03J4AT009X00ETA6QTJ002I004J6U/I09Y00EXJFQTB002J09T1fP00fUTJ004J006JFQXI6QY
0VP00fAYJ002J004I6UXJ@EX00=YJ6T016P2J@05B6QXB6P00T@1J00000HT02@092040003900000L0
00@T000T0P003200000T020T0200808000HT820084@200039010008000PT840T04@P@08P00M08410
94@P0090014PA4A0A2A4841494@P@4@TI002A006I4A4A41T14@01VQ4A6Q4I0900T@016Q4A6P2I094
00=TA6@00T@00fQTA002A005J6AXB4@00f@2A09X0V@00dAXA002J00:I4A4A6A4I4A8J0940fP2I0=X
00I4I6UYJ6@4J003I6QX009X00ETJ6QTA004J003I6QX009X00ATJ6aX0T@3J003I4AX00=X00QTJ6QY
J6UXI09X00M4J6QYJ4AX009Y00=XA6P00VP01hQTJ6QYJ4P016P00dAXJ002J006I6QXJFQT26P01FAY
JHaY009X00AYJ6U416P044AYJ6QTA6QYJ6U4K6QYI4P3J003I4AX009X00=TA6P00FT000P000<T8000
3P000b@08004000382@P008000LP920P0200008P00<080000R@00`1090028006940T840T0b000d@T
@0028009A2A0@21494A0009400DT@4@TI005A003@4AT00A400=XA4@00T@01fA8A4A8J4@00T0014AT
I4@2I008J4A4I4AXI4@2I006J4A4I4QT0T@2I003J6A8009X00ETJ4QTB002A005B4A4A6@00d@00fAX
J002I0=X00=8J6P01fP00fAXJ002J006I6QXJ6A40VP01DQXJ6aX009T00=XK6P00V@3J0=T00A/J6AT
0VP00fA4I002J09T16P02FUXJ6UTA6Q8I002J006B6QTJ6UX0f@016QYJ6@4J004I6UXJ@AX00=TR6P0
0VP016UXJ6P2J@=X0V@00fQYJ002A005K6Q4J6@00VT00fQTI002J@9T00A4J6QX0fT01TATJ6QYI05X
00000`0P000300068000800P0P000b@000020003800P008000PP020P02@0908000Q402@P02009080
1200201482@P04@00R@01b1402@P04@00R001T0T@210A08T00D0@20TA002@0A400<TA4@00T@00fA4
A003A004B4A4I0A400=TA4P014@012ATA6@2A09T00I4I4ATA6@2A09T00=XI4@00f@2A00>I4AYI4AT
J4AT96A4J6@4A003I4A4009T00=XJD@00V@01fQYA6A4J6T00VP016UXB4@2I003J6A4009T00A8J4AT
0fP3I004B6QTJ@9X00YTJ6AXJFAXI6Q80V@02FUXJ6AXI6Q8I004J004I6QYJ09T00EXJFQXI003J094
00IXJFQTA6P2I003J6UX00=X00AYJ6AT0fP00fUXJ006J005JDAXJ4P00VT5J003JFA8009Y00=4J6T0
0fT00fQYJ@02J09800EYK6QXA001J@0000<P92@00`001R0002@080@000PP02@T0200808000<T0000
0P001R@082@0908P00LT04@082@0008P01P0901094@T04@T84@0A2009010921484@29006A214A214
0T02A003I2A400A400=0A4@01D@016A4A6@2A003JDAT00A400ATB4AX14@00fUTA002A0=T00=XA6@0
0V@00fQ4I002A003J4AY009400UYA6QTA6A4J4@00VP2A0=X0f@2J09T0VP01VA4A6QTJ0940fP016UT
J6P2I09X00ATB6QT0VP014QXA6@2J003JFAT00=X0V@2J007JFATI6QYI004J09T00=XJFP016P00fUX
J@02J003A6QY009X00=TJ6P00VP01VAXJFQTJ@=X00=TA6`00VP016A4J6T2J003B6QY009X00a8K6QX
JDAXA4QXB6P2J@03J6AX009X00AYA6UY0VP01dA8JFUXA6T00VP00fU4J@02J05Y0000\
\>"], "Graphics",
  ImageSize->{142.5, 194.813},
  ImageMargins->{{70.625, 0}, {0, 0}},
  ImageRegion->{{-0.136901, 1.11918}, {-0.065549, 1.22459}}],

Cell[TextData[{
  "The figure of a single drop was taken from ",
  ButtonBox["Eggers [1997]",
    ButtonData:>{"Literat.nb", "Eggers-1997"},
    ButtonStyle->"Hyperlink"],
  ". Such a picture is observed if a drop hits a fluid surface. Drop \
formation is a common phenomenon in our daily world. Everybody knows the \
kinetics of rain drops if they hit the surface of a pond. An ",
  ButtonBox["animation available in the notebook version of this book for a \
falling milk drop",
    ButtonData:>{"dropMovie.nb", None},
    ButtonStyle->"Hyperlink"],
  " demonstrates the dynamic behind drop formation. Another animation showing \
",
  ButtonBox["the formation of a water drop ",
    ButtonData:>{"H2ODrop.nb", None},
    ButtonStyle->"Hyperlink"],
  "illustrates that not only the drop itself is created but also secondary \
droplets. The pictures are taken from Perigrin et al. The laws behind this \
interaction has been the topic of research for the last 300 years. The \
interest in drop formation is still growing because of its potential \
industrial application in technologies like ink jet printers, chemical mixing \
processes, fuel injection in engines, etc. The formation of a drop is mainly \
governed by two non-linear equations derived from the three-dimensional \
Navier-Stokes equation. "
}], "Text",
  CellTags->{
  "single drop", "rain drops", "drops", "animation for a falling milk drop", 
    "animation of the formation of a water drop", "drop formation", 
    "ink jet printer", "chemical mixing processes", "fuel injection", 
    "Navier-Stokes equation"}],

Cell[TextData[
"We assume that the Navier-Stokes equation is a reasonable model to describe \
the drop formation. The Navier-Stokes equation for an axisymmetric column of \
fluid with kinematic viscosity \[Eta], density \[Rho], and surface tension \
\[Gamma] are given in cylindrical coordinates by"], "Text",
  CellTags->{"kinematic viscosity", "surface tension"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_t + \ u\ u\_\(r\ \) + \ v\ v\_r = \ 
      \(-\(p\_r\/\[Rho]\)\)\  + \ 
        \[Eta]\ \((u\_\(r, r\)\  + \ u\_\(z, z\) + u\_r\/r - u\/r\^2)\), 
    \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(v\_t + \ u\ v\_r + v\ v\_z = \ 
      \(-\(p\_z\/\[Rho]\)\) + \ 
        \[Eta]\ \((v\_\(r, r\) + v\_\(z, z\)\  + v\_r\/r)\)\  - g, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is the velocity in the radial direction, ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " is the velocity along the axis, and ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " is the pressure. The equations are given by ",
  ButtonBox["Landau and Lifshitz [1987]",
    ButtonData:>{"Literat.nb", "Landau and Lifshitz-1984"},
    ButtonStyle->"Hyperlink"],
  " in the volume on fluid mechanics. The continuity equation in cylindrical \
coordinates reads"
}], "Text",
  CellTags->{"velocity", "pressure"}],

Cell[BoxData[
    \(TraditionalForm\`u\_r\  + v\_z + u\/r\  = \ 0. \)], "NumberedEquation"],

Cell["\<\
In addition to these three equations, we have to satisfy boundary \
conditions controlling the free surface of the fluid:\
\>", "Text",
  CellTags->"boundary conditions"],

Cell[BoxData[
    \(TraditionalForm
    \`n\&\[RightVector]\ \[Sigma]  n\&\[RightVector]\  = \ 
      \(-\[Gamma]\)\ \((1\/R\_1 + \ 1\/R\_2)\)\)], "NumberedEquation"],

Cell["and", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(v\&\[RightVector]\) \[Sigma]\ t\&\[RightVector]\  = \ 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  "Here, \[Sigma] is the stress tensor, ",
  Cell[BoxData[
      \(TraditionalForm\`n\&\[RightVector]\)]],
  " the outward normal, and ",
  Cell[BoxData[
      \(TraditionalForm\`R\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`R\_2\)]],
  " are the principal radii of curvature (cf. figure below). The equation of \
motion for the height of the fluid neck ",
  Cell[BoxData[
      \(TraditionalForm\`h = h(z, t)\)]],
  " is"
}], "Text",
  CellTags->"curvature"],

Cell[BoxData[
    \(TraditionalForm
    \`h\_t\  + \ v\ h\_z\  = \ u \( \[VerticalSeparator]\_\(r = h\) . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "In all the equations, subscripts refer to a partial differentiation with \
respect to the independent variables ",
  StyleBox["t",
    FontSlant->"Italic"],
  ", ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["z",
    FontSlant->"Italic"],
  ". The formula for the mean curvature ",
  Cell[BoxData[
      \(TraditionalForm\`\((1/R\_1 + \)\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(1/R\_2)\)/2\)]],
  " of a body of revolution is known from differential geometry (cf. ",
  ButtonBox["Gray [1993]",
    ButtonData:>{"Literat.nb", "Gray-1993"},
    ButtonStyle->"Hyperlink"],
  "). The geometrical relations are  shown in the following figure:"
}], "Text",
  CellTags->"differential geometry"],

Cell[GraphicsData["PostScript", "\<\

%!

%%Creator: Mathematica

%%AspectRatio: 1.3125 

MathPictureStart

/Mabs {

Mgmatrix idtransform

Mtmatrix dtransform

} bind def

/Mabsadd { Mabs

3 -1 roll add

3 1 roll add

exch } bind def

%% Graphics

/Courier findfont 10  scalefont  setfont

% Scaling calculations

0.380952 0.119048 0.864583 0.119048 [

[ 0 0 0 0 ]

[ 1 1.3125 0 0 ]

] MathScale

% Start of Graphics

1 setlinecap

1 setlinejoin

newpath

0 0 m

1 0 L

1 1.3125 L

0 1.3125 L

closepath

clip

newpath

% Start of user PostScript

/mathtops {

gsave

MBeginOrig

moveto

MEndOrig

currentpoint

grestore

} bind def

/MAtocoords {

mathtops 4 2 roll mathtops

4 copy pop pop

3 -1 roll sub

/arry exch def

exch sub

/arrx exch def

arrx dup mul

arry dup mul

add sqrt

/arrl exch def

translate

} bind def

/MAarrowhead1 {

gsave

MAtocoords

arrl 0. eq

{ 0 0 Mdot }

{

[ arrx arrl div

arry arrl div

-1 arry mul arrl div

arrx arrl div

0 0 ]

concat

-0.05 0.0125 moveto 0 0 lineto

-0.05 -0.0125 lineto fill

-0.05 0.0125 moveto 0 0 lineto

-0.05 -0.0125 lineto

-0.05 0.0125 lineto stroke

} ifelse

grestore

} def

% End of user PostScript

0 g

.5 Mabswid

[ ] 0 setdash

newpath

matrix currentmatrix

0.238095 0.0595238 scale

1.59999 14.5249 1 0 365.73 arc

setmatrix s

1 0 0 r

.38095 .86458 m

.14286 .86458 L

s

% Start of user PostScript

0 0 -2. 0 MAarrowhead1

% End of user PostScript

0 g

gsave

.32143 .88839 -68.5 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(R) show

69.000000 16.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 7.125000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(1) show

73.562500 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

newpath

.7381 .49058 .2381 0 365.73 arc

s

1 0 0 r

.7381 .49058 m

.5 .49058 L

s

% Start of user PostScript

3. -3.14159 1. -3.14159 MAarrowhead1

% End of user PostScript

0 g

gsave

.61905 .53125 -68.5 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(R) show

69.000000 16.000000 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 7.125000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(2) show

73.562500 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

.38095 .03125 m

.38095 1.28125 L

s

% Start of user PostScript

0 -7. 0 3.5 MAarrowhead1

% End of user PostScript

gsave

.42857 1.28125 -66 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(z) show

69.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

.55952 1.11458 m

.71429 1.11458 L

s

% Start of user PostScript

1.5 2.1 2.8 2.1 MAarrowhead1

% End of user PostScript

.55952 1.11458 m

.38095 1.11458 L

s

% Start of user PostScript

1.5 2.1 0 2.1 MAarrowhead1

% End of user PostScript

gsave

.55952 1.13839 -81 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(h) show

%%IncludeResource: font Math2Mono

%%IncludeFont: Math2Mono

/Math2Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

69.000000 14.437500 moveto

(H) show

75.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(z) show

81.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(,) show

87.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

%%IncludeResource: font Math2Mono

%%IncludeFont: Math2Mono

/Math2Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

93.000000 14.437500 moveto

(L) show

99.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Math2Mono

%%DocumentNeededResources: + font Courier

%%DocumentNeededFonts: Math2Mono

%%DocumentNeededFont: + Courier

%%DocumentFonts: font Math2Mono

%%DocumentFonts: + font Courier

grestore

0 0 1 r

.2619 .11659 m

.2619 .32887 L

s

% Start of user PostScript

-1. -6.28319 -1. -4.5 MAarrowhead1

% End of user PostScript

.32143 .11659 m

.32143 .32887 L

s

% Start of user PostScript

-0.5 -6.28319 -0.5 -4.5 MAarrowhead1

% End of user PostScript

.38095 .11659 m

.38095 .32887 L

s

% Start of user PostScript

0 -6.28319 0 -4.5 MAarrowhead1

% End of user PostScript

.44048 .11659 m

.44048 .32887 L

s

% Start of user PostScript

0.5 -6.28319 0.5 -4.5 MAarrowhead1

% End of user PostScript

.5 .11659 m

.5 .32887 L

s

% Start of user PostScript

1. -6.28319 1. -4.5 MAarrowhead1

% End of user PostScript

0 g

gsave

.46429 .09077 -81.5 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(v) show

%%IncludeResource: font Math2Mono

%%IncludeFont: Math2Mono

/Math2Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

69.062500 14.437500 moveto

(H) show

75.062500 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(z) show

81.062500 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(,) show

87.062500 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(t) show

%%IncludeResource: font Math2Mono

%%IncludeFont: Math2Mono

/Math2Mono findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

93.062500 14.437500 moveto

(L) show

99.062500 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Math2Mono

%%DocumentNeededResources: + font Courier

%%DocumentNeededFonts: Math2Mono

%%DocumentNeededFont: + Courier

%%DocumentFonts: font Math2Mono

%%DocumentFonts: + font Courier

grestore

.38095 .86458 m

.71429 .86458 L

s

% Start of user PostScript

0 0 2.8 0 MAarrowhead1

% End of user PostScript

gsave

.7381 .88839 -66 -11.5 Mabsadd m

1 1 Mabs scale

currentpoint translate

0 23 translate 1 -1 scale

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

63.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

(r) show

69.000000 14.437500 moveto

%%IncludeResource: font Courier

%%IncludeFont: Courier

/Courier findfont 10.000000 scalefont

[1 0 0 -1 0 0 ] makefont setfont

0.000000 0.000000 0.000000 setrgbcolor

0.000000 0.000000 rmoveto

1.000000 setlinewidth

%%DocumentNeededResources: font Courier

%%DocumentNeededFonts: Courier

%%DocumentFonts: font Courier

grestore

.61905 .11659 m

.59643 .1621 L

.57273 .21174 L

.55228 .25836 L

.53501 .30319 L

.5199 .35092 L

.50911 .39685 L

.50491 .42195 L

.50341 .43347 L

.50211 .44568 L

.50119 .45688 L

.50078 .46325 L

.50048 .46921 L

.50027 .47468 L

.50012 .47968 L

.50007 .48244 L

.50005 .484 L

.50003 .48545 L

.50001 .48684 L

.50001 .48811 L

.5 .48956 L

.5 .49094 L

.5 .49231 L

.50001 .49377 L

.50002 .49516 L

.50004 .49642 L

.50008 .49951 L

.50015 .50244 L

.50033 .50826 L

.5006 .51459 L

.50131 .52589 L

.50219 .53635 L

.50479 .55834 L

.50878 .58261 L

.51983 .62998 L

.53415 .67555 L

.55278 .72402 L

.57331 .7707 L

.59473 .8156 L

.61845 .86338 L

.64131 .90938 L

.66469 .95827 L

.68541 1.00537 L

.70291 1.05069 L

.71819 1.0989 L

.72431 1.12288 L

.72908 1.14532 L

.73273 1.16683 L

.73562 1.18995 L

.73668 1.20189 L

Mistroke

.73713 1.20819 L

.73751 1.2149 L

.73766 1.21822 L

.73778 1.22135 L

.73788 1.22439 L

.73796 1.22719 L

.73802 1.22985 L

.73806 1.23266 L

.73807 1.23412 L

.73809 1.23548 L

.73809 1.23698 L

.73809 1.23782 L

.7381 1.23858 L

.7381 1.23858 L

Mfstroke

.14286 .11659 m

.16548 .1621 L

.18918 .21174 L

.20963 .25836 L

.2269 .30319 L

.242 .35092 L

.2528 .39685 L

.25699 .42195 L

.2585 .43347 L

.25979 .44568 L

.26071 .45688 L

.26112 .46325 L

.26143 .46921 L

.26164 .47468 L

.26178 .47968 L

.26184 .48244 L

.26186 .484 L

.26188 .48545 L

.26189 .48684 L

.2619 .48811 L

.2619 .48956 L

.2619 .49094 L

.2619 .49231 L

.26189 .49377 L

.26188 .49516 L

.26187 .49642 L

.26182 .49951 L

.26176 .50244 L

.26158 .50826 L

.2613 .51459 L

.2606 .52589 L

.25971 .53635 L

.25712 .55834 L

.25312 .58261 L

.24208 .62998 L

.22775 .67555 L

.20913 .72402 L

.18859 .7707 L

.16718 .8156 L

.14346 .86338 L

.12059 .90938 L

.09721 .95827 L

.07649 1.00537 L

.05899 1.05069 L

.04372 1.0989 L

.03759 1.12288 L

.03283 1.14532 L

.02917 1.16683 L

.02628 1.18995 L

.02522 1.20189 L

Mistroke

.02478 1.20819 L

.0244 1.2149 L

.02424 1.21822 L

.02412 1.22135 L

.02402 1.22439 L

.02395 1.22719 L

.02389 1.22985 L

.02385 1.23266 L

.02383 1.23412 L

.02382 1.23548 L

.02381 1.23698 L

.02381 1.23782 L

.02381 1.23858 L

.02381 1.23858 L

Mfstroke

% End of Graphics

MathPictureEnd


\
\>"], "Graphics",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{216, 216},
  ImageMargins->{{69.3125, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>00013Q000`40O003h00Oogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo003oOol?Ool00?moo`moo`00ogoo3goo001^Ool00`00Oomoo`2MOol0
06ioo`03001oogoo09eoo`00KWoo00<007ooOol0WGoo001^Ool00`00Oomoo`2MOol006ioo`03001o
ogoo09eoo`00KWoo00<007ooOol0WGoo001^Ool00`00Oomoo`2MOol006ioo`03001oogoo00Aoo`03
001oogoo00Qoo`03001oogoo00]oo`03001oogoo07eoo`00KWoo00<007ooOol00goo00<007ooOol0
2Goo0P003Goo00<007ooOol0O7oo001[Ool200000goo001oo`03Ool00`00Oomoo`03Ool50003Ool0
0`00Oomoo`05Ool30004Ool00`00Oomoo`1kOol006]oo`800003Ool007oo00=oo`03001oogoo00=o
o`05001oogooOol00003Ool20005Ool01@00Oomoogoo00000goo00<007ooOol0Ngoo001ZOol00`00
Oomoo`020004Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`1kOol0
06Yoo`03001oogoo008000Aoo`03001oogoo00Eoo`03001oogoo00Yoo`03001oogoo00Eoo`03001o
ogoo07]oo`00JGoo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00goo00@007ooOol000]o
o`03001oogoo00Eoo`03001oogoo07]oo`00J7oo0`000Woo0`000goo00<007ooOol00goo1@002Goo
1@0017oo00<007ooOol0Ngoo001^Ool00`00Oomoo`03Ool00`00Oomoo`0AOol00`00Oomoo`04Ool0
0`00Oomoo`1lOol006ioo`03001oogoo00Aoo`03001oogoo01Ioo`03001oogoo07eoo`00?Goo00<0
07ooOol05Goo00<07gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo00<0
7gooOol05Goo00<007ooOol0KGoo000mOol00`00Oomoo`0EOol00`0OOomoo`09Ool00`0OOomoo`0:
Ool00`0OOomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`0EOol00`00Oomoo`1]Ool003ioo`03001o
ogoo01Aoo`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`0301moogoo00Uoo`0301mo
ogoo01Aoo`03001oogoo06ioo`00?Woo00<007ooOol057oo00<07gooOol02Goo00<07gooOol02Woo
00<07gooOol02Goo00<07gooOol02Goo00<07gooOol057oo00<007ooOol0KWoo000oOol00`00Oomo
o`0COol00`0OOomoo`09Ool00`0OOomoo`0:Ool00`0OOomoo`09Ool00`0OOomoo`09Ool00`0OOomo
o`0COol00`00Oomoo`1_Ool003moo`03001oogoo01=oo`0301moogoo00Uoo`0301moogoo00Yoo`03
01moogoo00Uoo`0301moogoo00Uoo`0301moogoo01=oo`03001oogoo06moo`00?goo00<007ooOol0
4goo00<07gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo00<07gooOol0
4goo00<007ooOol0Kgoo0010Ool00`00Oomoo`0BOol00`0OOomoo`09Ool00`0OOomoo`0:Ool00`0O
Oomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`0BOol00`00Oomoo`1`Ool0041oo`03001oogoo019o
o`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`0301moogoo00Uoo`0301moogoo019o
o`03001oogoo071oo`00@Goo00<007ooOol04Goo00<07gooOol02Goo00<07gooOol02Woo00<07goo
Ool02Goo00<07gooOol02Goo00<07gooOol04Goo00<007ooOol0LGoo0011Ool00`00Oomoo`0AOol0
0`0OOomoo`09Ool00`0OOomoo`0:Ool00`0OOomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`0AOol0
0`00Oomoo`1aOol0049oo`03001oogoo011oo`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo
00Uoo`0301moogoo00Uoo`0301moogoo011oo`03001oogoo079oo`00@Woo00<007ooOol047oo00<0
7gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo00<07gooOol047oo00<0
07ooOol0LWoo0013Ool00`00Oomoo`0?Ool00`0OOomoo`09Ool00`0OOomoo`0:Ool00`0OOomoo`09
Ool00`0OOomoo`09Ool00`0OOomoo`0?Ool00`00Oomoo`1cOol004=oo`03001oogoo00moo`0301mo
ogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`0301moogoo00Uoo`0301moogoo00moo`03001o
ogoo07=oo`00A7oo00<007ooOol03Woo00<07gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo
00<07gooOol02Goo00<07gooOol03Woo00<007ooOol0M7oo0014Ool00`00Oomoo`0>Ool00`0OOomo
o`09Ool00`0OOomoo`0:Ool00`0OOomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`0>Ool00`00Oomo
o`1dOol004Eoo`03001oogoo00eoo`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`03
01moogoo00Uoo`0301moogoo00eoo`03001oogoo07Eoo`00AGoo00<007ooOol03Goo00<07gooOol0
2Goo00<07gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo00<07gooOol03Goo00<007ooOol0
MGoo0016Ool00`00Oomoo`0<Ool00`0OOomoo`09Ool00`0OOomoo`0:Ool00`0OOomoo`09Ool00`0O
Oomoo`09Ool00`0OOomoo`0<Ool00`00Oomoo`1fOol004Ioo`03001oogoo00aoo`0301moogoo00Uo
o`0301moogoo00Yoo`0301moogoo00Uoo`0301moogoo00Uoo`0301moogoo00aoo`03001oogoo07Io
o`00AWoo00<007ooOol037oo00<07gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo00<07goo
Ool02Goo00<07gooOol037oo00<007ooOol0MWoo0017Ool00`00Oomoo`0;Ool00`0OOomoo`09Ool0
0`0OOomoo`0:Ool00`0OOomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`0;Ool00`00Oomoo`1gOol0
04Moo`03001oogoo00]oo`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`0301moogoo
00Uoo`0301moogoo00]oo`03001oogoo07Moo`00B7oo00<007ooOol02Woo00<07gooOol02Goo00<0
7gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo00<07gooOol02Woo00<007ooOol0N7oo0018
Ool00`00Oomoo`0:Ool00`0OOomoo`09Ool00`0OOomoo`0:Ool00`0OOomoo`09Ool00`0OOomoo`09
Ool00`0OOomoo`0:Ool00`00Oomoo`1hOol004Uoo`03001oogoo00Uoo`0301moogoo00Uoo`0301mo
ogoo00Yoo`0301moogoo00Uoo`0301moogoo00Uoo`0301moogoo00Uoo`03001oogoo07Uoo`00BGoo
00<007ooOol02Goo00<07gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo
00<07gooOol02Goo00<007ooOol0NGoo001:Ool00`00Oomoo`08Ool00`0OOomoo`09Ool00`0OOomo
o`0:Ool00`0OOomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`08Ool00`00Oomoo`0OOol9001BOol0
04Yoo`03001oogoo00Qoo`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`0301moogoo
00Uoo`0301moogoo00Qoo`03001oogoo01Qoo`L000Uoo`L004]oo`00BWoo00<007ooOol027oo00<0
7gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo00<07gooOol027oo00<0
07ooOol05Goo0`005goo0P00BGoo001;Ool00`00Oomoo`07Ool00`0OOomoo`09Ool00`0OOomoo`0:
Ool00`0OOomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`07Ool00`00Oomoo`0DOol2000LOol30016
Ool004]oo`03001oogoo00Moo`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`0301mo
ogoo00Uoo`0301moogoo00Moo`03001oogoo019oo`80025oo`8004Aoo`00C7oo00<007ooOol01Woo
00<07gooOol02Goo00<07gooOol02Woo00<07gooOol02Goo00<07gooOol02Goo00<07gooOol01Woo
00<007ooOol04Goo0P009Goo0P00@Woo001<Ool00`00Oomoo`04Ool601l6Ool601l6Ool601l6Ool6
01l6Ool701l5Ool00`00Oomoo`0>Ool3000YOol20010Ool004aoo`03001oogoo00Aoo`H07`Ioo`H0
7`Ioo`H07`Ioo`H07`Ioo`L07`Eoo`03001oogoo00aoo`8002ioo`8003ioo`00CGoo00<007ooOol0
0goo1@0O1goo1@0O27oo1@0O1goo1@0O1goo1@0O1Goo00<007ooOol02goo0P00<Woo0P00?7oo001=
Ool00`00Oomoo`04Ool401l8Ool401l8Ool401l8Ool401l8Ool501l5Ool00`00Oomoo`09Ool2000f
Ool2000jOol004ioo`03001oogoo00=oo`@07`Qoo`@07`Qoo`@07`Qoo`@07`Qoo`D07`Aoo`03001o
ogoo00Uoo`03001oogoo03Qoo`03001oogoo03Moo`00CWoo00<007ooOol00goo0`0O2Goo0`0O2Woo
0`0O2Goo0`0O2Goo0`0O1Goo00<007ooOol027oo00<007ooOol0>Woo00<007ooOol0=Woo001>Ool0
0`00Oomoo`03Ool301l9Ool301l:Ool301l9Ool301l9Ool301l5Ool00`00Oomoo`07Ool00`00Oomo
o`0lOol2000fOol004moo`03001oogoo009oo`<07`Uoo`<07`Yoo`<07`Uoo`<07`Uoo`<07`Aoo`03
001oogoo00Moo`03001oogoo03moo`03001oogoo03=oo`00Cgoo00<007ooOol00goo0P0O2Woo0P0O
2Woo0P0O2Woo0P0O2Woo0`0O17oo00<007ooOol01Woo00<007ooOol0@Goo00<007ooOol0<Woo001?
Ool00`00Oomoo`03Ool00`0OOomoo`09Ool00`0OOomoo`0:Ool00`0OOomoo`09Ool00`0OOomoo`09
Ool00`0OOomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`13Ool00`00Oomoo`0aOol0051oo`03001o
ogoo009oo`0301moogoo00Uoo`0301moogoo00Yoo`0301moogoo00Uoo`0301moogoo00Uoo`0301mo
ogoo009oo`03001oogoo00Eoo`03001oogoo04Eoo`03001oogoo031oo`00D7oo00<007ooOol06goo
00<007ooOol06Woo00<007ooOol017oo00<007ooOol0Agoo00<007ooOol0;goo001@Ool00`00Oomo
o`0KOol00`00Oomoo`0JOol00`00Oomoo`03Ool00`00Oomoo`18Ool00`00Oomoo`0_Ool0055oo`03
001oogoo01Yoo`03001oogoo01Uoo`03001oogoo00=oo`03001oogoo04Yoo`03001oogoo02ioo`00
DGoo00<007ooOol06Woo00<007ooOol06Goo00<007ooOol00goo00<007ooOol0Bgoo00<007ooOol0
;Goo001AOol00`00Oomoo`0JOol00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`1=Ool00`00
Oomoo`0/Ool0055oo`03001oogoo01Yoo`03001oogoo01Uoo`05001oogooOol0001@Ool00`00Oomo
o`0/Ool0059oo`03001oogoo01Uoo`03001oogoo01Qoo`05001oogooOol0001BOol00`00Oomoo`0[
Ool0059oo`03001oogoo01Uoo`03001oogoo01Qoo`05001oogooOol0001BOol00`00Oomoo`0[Ool0
059oo`03001oogoo01Uoo`03001oogoo01Qoo`04001oogoo001DOol00`00Oomoo`0ZOol0059oo`03
001oogoo01Uoo`03001oogoo01Qoo`04001oogoo001EOol00`00Oomoo`0YOol0059oo`03001oogoo
01Uoo`03001oogoo01Qoo`03001oo`0005Moo`03001oogoo02Qoo`00Dgoo00<007ooOol067oo00<0
07ooOol05goo00@007ooOol005Moo`03001oogoo02Qoo`00Dgoo00<007ooOol067oo00<007ooOol0
5goo00<007oo0000FGoo00<007ooOol09goo001COol00`00Oomoo`0HOol00`00Oomoo`0GOol00`00
Ool0001IOol00`00Oomoo`0WOol005=oo`03001oogoo01Qoo`03001oogoo01Moo`8005]oo`03001o
ogoo02Ioo`00Dgoo00<007ooOol067oo00<007ooOol05goo0P00Fgoo00<007ooOol09Woo001DOol0
0`00Oomoo`0GOol00`00Oomoo`0FOol00`00Ool0001KOol00`00Oomoo`0VOol005Aoo`03001oogoo
01Moo`03001oogoo01Ioo`8005aoo`03001oogoo02Ioo`00E7oo00<007ooOol05goo00<007ooOol0
5Woo0P00G7oo00<007ooOol09Woo001EOol00`00Oomoo`0FOol00`00Oomoo`0FOol2001MOol00`00
Oomoo`0UOol005Eoo`03001oogoo01Ioo`03001oogoo01Ioo`8005eoo`03001oogoo02Eoo`00EGoo
00<007ooOol05Woo00<007ooOol05Woo00<007ooOol0GGoo00<007ooOol097oo001EOol00`00Oomo
o`0FOol00`00Oomoo`0EOol2001OOol00`00Oomoo`0TOol005Eoo`03001oogoo01Ioo`03001oogoo
01Eoo`8005moo`03001oogoo02Aoo`00EGoo00<007ooOol05Woo00<007ooOol05Goo0P00Ggoo00<0
07ooOol097oo001EOol00`00Oomoo`0FOol00`00Oomoo`0EOol2001OOol00`00Oomoo`0TOol005Eo
o`03001oogoo01Ioo`03001oogoo01Eoo`03001oogoo05ioo`03001oogoo02Aoo`00EGoo00<007oo
Ool05Woo00<007ooOol05Goo00<007ooOol0GWoo00<007ooOol097oo001EOol00`00Oomoo`0FOol0
0`00Oomoo`0EOol00`00Oomoo`1NOol00`00Oomoo`0TOol005Eoo`03001oogoo01Ioo`03001oogoo
01Eoo`03001oogoo00Ioo`9l05Moo`03001oogoo02=oo`00EGoo00<007ooOol05Woo00<007ooOol0
5Goo00<007ooOol00goo1G`0Egoo00<007ooOol08goo001EOol00`00Oomoo`0FOol00`00Oomoo`0E
Ool00`00Ooml0008O01GOol00`00Oomoo`0SOol005Eoo`03001oogoo01Ioo`03001oogoo01Eoo`03
001l07`002ml031oo`03001oogoo02=oo`00EGoo00<007ooOol05Woo00<007ooOol05Goo00<007oo
O00027`0Egoo00<007ooOol08goo001EOol00`00Oomoo`0FOol00`00Oomoo`0EOol00`00Oomoo`02
Ool6O01GOol00`00Oomoo`0SOol005Eoo`03001oogoo01Ioo`03001oogoo01Eoo`03001oogoo00Io
o`9l05Moo`03001oogoo02=oo`00EGoo00<007ooOol05Woo00<007ooOol05Goo00<007ooOol05goo
0`00A7oo00<007ooOol097oo001EOol00`00Oomoo`0FOol00`00Oomoo`0EOol00`00Oomoo`0GOol0
0`00Oomoo`14Ool00`00Oomoo`0TOol005Eoo`03001oogoo01Ioo`03001oogoo01Eoo`80015oo`<0
00=oo`03001oo`0004Eoo`03001oogoo02Aoo`00EGoo00<007ooOol05Woo00<007ooOol05Goo0P00
4Woo00D007ooOomoo`00009oo`03001oogoo04=oo`03001oogoo02Aoo`00EGoo00<007ooOol05Woo
00<007ooOol05Goo0P004Woo00@007ooOol0009oo`03001oo`0004Aoo`03001oogoo02Aoo`00EGoo
00<007ooOol05Woo00<007ooOol05Goo0P004Woo10000goo00<007ooOol0@goo00<007ooOol097oo
001EOol00`00Oomoo`0FOol00`00Oomoo`0EOol2000BOol01@00Oomoogoo0000B7oo00<007ooOol0
97oo001EOol00`00Oomoo`0FOol00`00Oomoo`0EOol00`00Ool0000AOol01@00Oomoogoo0000Agoo
00<007ooOol09Goo001DOol00`00Oomoo`0GOol00`00Oomoo`0FOol2000AOol01@00Oomoogoo0000
Agoo00<007ooOol09Goo001DOol00`00Oomoo`0GOol00`00Oomoo`0FOol2000@Ool50017Ool00`00
Oomoo`0VOol005Aoo`03001oogoo01Moo`03001oogoo01Ioo`8005aoo`03001oogoo02Ioo`00E7oo
00<007ooOol05goo00<007ooOol05Woo0P00G7oo00<007ooOol09Woo001DOol00`00Oomoo`0GOol0
0`00Oomoo`0FOol00`00Ool0001KOol00`00Oomoo`0VOol005=oo`03001oogoo01Qoo`03001oogoo
01Moo`8005]oo`03001oogoo02Ioo`00Dgoo00<007ooOol067oo00<007ooOol05goo00<007oo0000
FGoo00<007ooOol09goo001COol00`00Oomoo`0HOol00`00Oomoo`0GOol00`00Ool0001IOol00`00
Oomoo`0WOol005=oo`03001oogoo01Qoo`03001oogoo01Moo`04001oogoo001GOol00`00Oomoo`0X
Ool005=oo`03001oogoo01Qoo`03001oogoo01Moo`04001oogoo001GOol00`00Oomoo`0XOol0059o
o`03001oogoo01Uoo`03001oogoo01Qoo`04001oogoo001EOol00`00Oomoo`0YOol0059oo`03001o
ogoo01Uoo`03001oogoo01Qoo`04001oogoo001EOol00`00Oomoo`0YOol0059oo`03001oogoo01Uo
o`03001oogoo01Qoo`05001oogooOol0001COol00`00Oomoo`0ZOol0059oo`03001oogoo01Uoo`03
001oogoo01Qoo`05001oogooOol0001BOol00`00Oomoo`0[Ool0059oo`03001oogoo01Uoo`03001o
ogoo01Qoo`05001oogooOol0001BOol00`00Oomoo`0[Ool0055oo`03001oogoo01Yoo`03001oogoo
01Uoo`05001oogooOol0001@Ool00`00Oomoo`0/Ool0055oo`03001oogoo01Yoo`03001oogoo01Uo
o`05001oogooOol0001@Ool00`00Oomoo`0/Ool0055oo`03001oogoo01Yoo`03001oogoo01Uoo`03
001oogoo009oo`03001oogoo04aoo`03001oogoo02eoo`00DGoo00<007ooOol06Woo00<007ooOol0
6Goo00<007ooOol00goo00<007ooOol0Bgoo00<007ooOol0;Goo001@Ool00`00Oomoo`0KOol00`00
Oomoo`0JOol00`00Oomoo`03Ool00`00Oomoo`18Ool2000`Ool0051oo`03001oogoo01]oo`03001o
ogoo01Yoo`03001oogoo00Aoo`03001oogoo04Ioo`03001oogoo031oo`00D7oo00<007ooOol06goo
00<007ooOol06Woo00<007ooOol01Goo00<007ooOol0AGoo00<007ooOol0<7oo001?Ool00`00Oomo
o`0LOol00`00Oomoo`0KOol00`00Oomoo`05Ool00`00Oomoo`13Ool00`00Oomoo`0aOol004moo`03
001oogoo01aoo`03001oogoo01]oo`03001oogoo00Ioo`03001oogoo045oo`03001oogoo039oo`00
Cgoo00<007ooOol077oo00<007ooOol06goo00<007ooOol01goo00<007ooOol0?goo00<007ooOol0
<goo001>Ool00`00Oomoo`0MOol00`00Oomoo`0LOol00`00Oomoo`07Ool00`00Oomoo`0mOol00`00
Oomoo`0dOol004ioo`03001oogoo01eoo`03001oogoo01aoo`03001oogoo00Qoo`03001oogoo03Yo
o`8003Moo`00CWoo00<007ooOol07Goo00<007ooOol077oo00<007ooOol02Goo00<007ooOol0>7oo
00<007ooOol0=goo001=Ool00`00Oomoo`0NOol00`00Oomoo`0MOol00`00Oomoo`09Ool00`00Oomo
o`0fOol00`00Oomoo`0hOol004eoo`03001oogoo01ioo`03001oogoo01eoo`03001oogoo00Yoo`80
03Aoo`8003]oo`00C7oo00<007ooOol07goo00<007ooOol07Woo00<007ooOol02goo0`00;goo0P00
?Goo001<Ool00`00Oomoo`0OOol00`00Oomoo`0NOol00`00Oomoo`0>Ool2000[Ool2000oOol004ao
o`03001oogoo01moo`03001oogoo01ioo`03001oogoo011oo`03001oogoo02Moo`03001oogoo03mo
o`00Bgoo00<007ooOol087oo00<007ooOol07goo00<007ooOol047oo0`008Woo1000@Woo001;Ool0
0`00Oomoo`0POol00`00Oomoo`0OOol00`00Oomoo`0COol3000MOol20016Ool004Yoo`03001oogoo
025oo`03001oogoo021oo`03001oogoo01Eoo`8001Uoo`8004Qoo`00BWoo00<007ooOol08Goo00<0
07ooOol087oo00<007ooOol05goo1`002Woo2000BWoo001:Ool00`00Oomoo`0QOol00`00Oomoo`0P
Ool00`00Oomoo`0NOol:001BOol004Uoo`03001oogoo029oo`03001oogoo025oo`03001oogoo07Uo
o`00BGoo00<007ooOol08Woo00<007ooOol08Goo00<007ooOol0NGoo0018Ool00`00Oomoo`0SOol0
0`00Oomoo`0ROol00`00Oomoo`1hOol004Qoo`03001oogoo02=oo`03001oogoo029oo`03001oogoo
07Qoo`00Agoo00<007ooOol097oo00<007ooOol08goo00<007ooOol0Mgoo0017Ool00`00Oomoo`0T
Ool00`00Oomoo`0SOol00`00Oomoo`1gOol004Ioo`03001oogoo02Eoo`03001oogoo02Aoo`03001o
ogoo07Ioo`00AWoo00<007ooOol09Goo00<007ooOol097oo00<007ooOol0MWoo0016Ool00`00Oomo
o`0UOol00`00Oomoo`0TOol00`00Oomoo`1fOol004Eoo`03001oogoo02Ioo`03001oogoo02Eoo`03
001oogoo07Eoo`00AGoo00<007ooOol09Woo00<007ooOol09Goo00<007ooOol0MGoo0014Ool00`00
Oomoo`0WOol00`00Oomoo`0VOol00`00Oomoo`1dOol004Aoo`03001oogoo02Moo`03001oogoo02Io
o`03001oogoo07Aoo`00A7oo00<007ooOol09goo00<007ooOol09Woo00<007ooOol0M7oo0013Ool0
0`00Oomoo`0VOol4000XOol00`00Oomoo`1cOol004=oo`03001oogoo01Iooa00009oo`03001oo`00
010001Moo`03001oogoo07=oo`00@Woo00<007ooOol03Woo2@004Woo00<007ooOol047oo200047oo
00<007ooOol0LWoo0012Ool00`00Oomoo`0:Ool4000KOol00`00Oomoo`0HOol4000<Ool00`00Oomo
o`1bOol0045oo`03001oogoo00Ioo`D001moo`03001oogoo01aoo`D000Qoo`03001oogoo075oo`00
@Goo00<007ooOol00Woo100097oo00<007ooOol08Goo0`001Goo00<007ooOol0LGoo0010Ool01000
Oomoogoo0P00:7oo00<007ooOol097oo0P0017oo00<007ooOol0L7oo0010Ool01000Ool00000:Woo
00<007ooOol09Woo0`0000=oo`00Ool0LGoo000oOol00`00Ool0000/Ool00`00Oomoo`0YOol3001a
Ool003moo`8002eoo`03001oogoo02]oo`03001oogoo06moo`00?Woo0P001Woo0W`09Woo00<007oo
Ool0;7oo00<007ooOol027oo0P00I7oo000mOol20004Ool5O00VOol00`00Oomoo`0/Ool20009Ool5
001QOol003eoo`03001oog`000Ql02Ioo`03001oogoo02eoo`03001oogoo00Moo`T005eoo`00?7oo
00<007`0O0008g`01@001g`0A@00Fgoo000lOol20002Ool8O00LOol00`00Oomoo`07Ool00`00Oomo
o`0/Ool30008Ool8001NOol003]oo`03001oo`0000Moo`=l01Aoo`<000=oo`03001oo`0000Uoo`03
001oogoo02aoo`04001oogoo0007Ool30009Ool5001EOol003]oo`03001oogoo008001eoo`05001o
ogooOol00002Ool00`00Oomoo`07Ool00`00Oomoo`0[Ool01@00Oomoogoo000057oo00<007ooOol0
EWoo000jOol00`00Oomoo`03Ool00`00Oomoo`0JOol01000Oomoo`000goo00<007ooOol01goo00<0
07ooOol0:Woo00<007ooOol00goo00<007ooOol04Goo00<007ooOol0EWoo000jOol00`00Oomoo`04
Ool2000JOol40002Ool20009Ool00`00Oomoo`0XOol20006Ool00`00Oomoo`0AOol00`00Oomoo`1F
Ool003Uoo`03001oogoo00Moo`<001Moo`05001oogooOol0000<Ool00`00Oomoo`0WOol00`00Oomo
o`07Ool00`00Oomoo`0@Ool2001GOol003Uoo`03001oogoo00Yoo`8001Eoo`05001oogooOol0000<
Ool00`00Oomoo`0TOol3000:Ool00`00Oomoo`0?Ool2000017oo00000000E7oo000hOol00`00Oomo
o`0=Ool5000@Ool01@00Oomoogoo000037oo00<007ooOol07goo1@003Woo00<007ooOol0J7oo000h
Ool00`00Oomoo`0BOol3000<Ool5000=Ool00`00Oomoo`0KOol4000COol00`00Oomoo`1XOol003Mo
o`03001oogoo01Ioo`H001Qoo`03001oogoo01Eoo`H001Qoo`03001oogoo06Moo`00=goo00<007oo
Ool077oo300037oo00<007ooOol02Goo30007Woo00<007ooOol0Igoo000fOol00`00Oomoo`0YOolH
000[Ool00`00Oomoo`1VOol003Ioo`03001oogoo03Eoo`03001oogoo03Aoo`03001oogoo06Ioo`00
=Goo00<007ooOol0=Woo00<007ooOol0=Goo00<007ooOol0IGoo000eOol00`00Oomoo`0fOol00`00
Oomoo`0eOol00`00Oomoo`1UOol003Aoo`03001oogoo03Moo`03001oogoo03Ioo`03001oogoo06Ao
o`00=7oo00<007ooOol0=goo00<007ooOol0=Woo00<007ooOol0I7oo000cOol00`00Oomoo`0hOol0
0`00Oomoo`0gOol00`00Oomoo`1SOol003=oo`03001oogoo03Qoo`03001oogoo03Moo`03001oogoo
06=oo`00<goo00<007ooOol0>7oo00<007ooOol0=goo00<007ooOol0Hgoo000bOol00`00Oomoo`0i
Ool00`00Oomoo`0hOol00`00Oomoo`1ROol0039oo`03001oogoo03Uoo`03001oogoo03Qoo`03001o
ogoo069oo`00<Goo00<007ooOol0>Woo00<007ooOol0>Goo00<007ooOol0HGoo000aOol00`00Oomo
o`0jOol00`00Oomoo`0iOol00`00Oomoo`1QOol0035oo`03001oogoo03Yoo`03001oogoo03Uoo`03
001oogoo065oo`00<7oo00<007ooOol0>goo00<007ooOol0>Woo00<007ooOol0H7oo000`Ool00`00
Oomoo`0kOol00`00Oomoo`0jOol00`00Oomoo`1POol002moo`03001oogoo03aoo`03001oogoo03]o
o`03001oogoo05moo`00;goo00<007ooOol0?7oo00<007ooOol0>goo00<007ooOol0Ggoo000_Ool0
0`00Oomoo`0lOol00`00Oomoo`0kOol00`00Oomoo`1OOol002ioo`03001oogoo03eoo`03001oogoo
03aoo`03001oogoo05ioo`00;Woo00<007ooOol0?Goo00<007ooOol0?7oo00<007ooOol0GWoo000^
Ool00`00Oomoo`0mOol00`00Oomoo`0mOol00`00Oomoo`1MOol002eoo`03001oogoo03ioo`03001o
ogoo03eoo`03001oogoo05eoo`00;Goo00<007ooOol0?Woo00<007ooOol0?Woo00<007ooOol0G7oo
000]Ool00`00Oomoo`0nOol00`00Oomoo`0nOol00`00Oomoo`1LOol002aoo`03001oogoo03moo`03
001oogoo03moo`03001oogoo05]oo`00;7oo00<007ooOol0?goo00<007ooOol0?goo00<007ooOol0
Fgoo000/Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`1KOol002]oo`03001oogoo041o
o`03001oogoo041oo`03001oogoo05Yoo`00:goo00<007ooOol0@7oo00<007ooOol0@7oo00<007oo
Ool0FWoo000ZOol00`00Oomoo`11Ool00`00Oomoo`10Ool00`00Oomoo`1JOol002Yoo`03001oogoo
045oo`03001oogoo045oo`03001oogoo05Uoo`00:Woo00<007ooOol0@Goo00<007ooOol0@Goo00<0
07ooOol0FGoo000YOol00`00Oomoo`12Ool00`00Oomoo`11Ool00`00Oomoo`1IOol002Uoo`03001o
ogoo049oo`03001oogoo045oo`03001oogoo05Uoo`00:7oo00<007ooOol0@goo00<007ooOol0@Woo
00<007ooOol0F7oo000XOol00`00Oomoo`13Ool00`00Oomoo`06Ool2000_Ool20009Ool00`00Oomo
o`1HOol002Qoo`03001oogoo04=oo`03001oogoo00=oo`D002moo`D000Ioo`03001oogoo05Qoo`00
:7oo00<007ooOol0@goo00<007oo00002000;goo2@000Woo00<007ooOol0F7oo000WOol00`00Oomo
o`14Oom500000goo001oo`1HOol002Moo`03001oogoo04Aoo`03001oogoo00P000moo`03001oogoo
00Uoo`8000eoo`03001oogoo009oo`P000Aoo`03001oogoo05Moo`009goo00<007ooOol0A7oo00<0
07ooOol01Goo0`0017oo0`0000Aoo`00000000=oo`03001oogoo00=oo`D000=oo`03001oogoo00Eo
o`<000Aoo`04001oogooOol30009Ool00`00Oomoo`1GOol002Moo`03001oogoo04Aoo`03001oogoo
00eoo`05001oogooOol00004Ool00`00Oomoo`03Ool01@00Oomoogoo00000goo0P001Goo00D007oo
Oomoo`0000=oo`03001oogoo00eoo`03001oogoo05Moo`009Woo00<007ooOol0AGoo00<007ooOol0
3Goo00D007ooOomoo`0000Aoo`03001oogoo00Aoo`03001oogoo00]oo`03001oogoo00Eoo`03001o
ogoo00ioo`03001oogoo05Ioo`009Woo00<007ooOol0AGoo00<007ooOol03Goo00D007ooOomoo`00
00Aoo`03001oogoo00Eoo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo00ioo`03001oogoo
05Ioo`009Woo00<007ooOol0AGoo00<007ooOol03Goo0P000Woo00<007ooOol00Woo00<007ooOol0
0goo00@007ooOol000]oo`03001oogoo00Eoo`03001oogoo00ioo`03001oogoo05Ioo`009Woo00<0
07ooOol0AGoo00<007ooOol03Goo00@007oo000000Eoo`03001oogoo00=oo`D000Uoo`D000Aoo`03
001oogoo00ioo`03001oogoo05Ioo`009Woo00<007ooOol0AGoo00<007ooOol03Goo00<007ooOol0
1goo00<007ooOol04Goo00<007ooOol017oo00<007ooOol03goo00<007ooOol0EWoo000VOol00`00
Oomoo`15Ool00`00Oomoo`0<Ool2000:Ool00`00Oomoo`0FOol00`00Oomoo`0AOol00`00Oomoo`1E
Ool002Ioo`03001oogoo04Eoo`03001oogoo04Eoo`03001oogoo05Eoo`009Woo00<007ooOol0AGoo
00<007ooOol0AGoo00<007ooOol0EGoo000VOol00`00Oomoo`15Ool00`00Oomoo`15Ool00`00Oomo
o`1EOol002Eoo`03001oogoo04Ioo`03001oogoo04Eoo`03001oogoo05Eoo`009Goo00<007ooOol0
AWoo00<007ooOol0AGoo00<007ooOol0EGoo000UOol00`00Oomoo`16Ool00`00Oomoo`15Ool00`00
Oomoo`1EOol002Eoo`03001oogoo04Ioo`03001oogoo04Eoo`03001oogoo05Eoo`009Goo00<007oo
Ool0AWoo00<007ooOol0AWoo00<007ooOol0E7oo000UOol00`00Oomoo`16Ool00`00Oomoo`16Ool0
0`00Oomoo`1DOol002Eoo`03001oogoo04Ioo`03001oogoo04Ioo`03001oogoo05Aoo`009Goo00<0
07ooOol0AWoo00<007ooOol0AWoo00<007ooOol0E7oo000TOol00`00Oomoo`17Ool00`00Oomoo`16
Ool00`00Oomoo`1DOol002Aoo`03001oogoo04Moo`03001oogoo04Ioo`03001oogoo05Aoo`0097oo
00<007ooOol0Agoo00<007ooOol0AWoo00<007ooOol0E7oo000TOol00`00Oomoo`14Ool60016Ool0
0`00Oomoo`1DOol002Aoo`8004Eoo`H004Ioo`03001oogoo05Aoo`00K7oo1@00WGoo001/Ool4002N
Ool006aoo`@009ioo`00KGoo0`00WWoo001]Ool3002NOol006eoo`<000Ioo`D009=oo`00KGoo0P00
1goo00D007ooOomoo`0009=oo`00KWoo00<007ooOol01Woo00<007ooOol0U7oo001^Ool00`00Oomo
o`07Ool00`00Oomoo`2COol007Ioo`04001oogoo002DOol007Ioo`D009=oo`00ogoo3goo003oOol?
Ool00?moo`moo`00ogoo3goo0000\
\>"],
  ImageRangeCache->{{{0, 269}, {269, 0}} -> {-4.51254, -7.26253, 0.0512318, \
0.0512318}}],

Cell[TextData[{
  "The mean curvature which is responsible for the capillary pressure is \
given by the relation (",
  ButtonBox["Garcia and Castellanos [1994]",
    ButtonData:>{"Literat.nb", "Garcia and Castellanos-1994"},
    ButtonStyle->"Hyperlink"],
  ")"
}], "Text",
  CellTags->"capillary pressure"],

Cell[BoxData[
    \(TraditionalForm
    \`p\  = \ \(\[Gamma]\/\((1\  + \ \ \[Epsilon]\ h\_z\%2)\)\^\(1/2\)\) 
        \((1\/\(1\  + \ \ \[Epsilon]\ h\) - 
            \(\[Epsilon]\ h\_\(z, z\)\)\/\(1\  + \ \[Epsilon]\ h\_z\%2\))
          \)\)], "NumberedEquation"],

Cell[TextData[
"where \[Epsilon] is a small parameter. The model equations \
(5.67)\[Dash](5.69) simplify considerably by expanding the velocity fields \
and the pressure into a power series in the radial direction. This expansion \
additionally allows the reduction from a two-dimesnional to a one-dimensional \
model. Keeping only the lowest-order radial dependence, we end up with the \
equations"], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(v\_t\  + \ v\ v\_z\  = \ 
      \(-\(p\_z\/\[Rho]\)\)\  + \ 3\ \((\[Eta](\(h\^2\) v\_z))\)\_z\/h\^2 - 
        g, \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`h\_t + \ v\ h\_z = \(-\(1\/2\)\) \(v\_z\) h\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where the pressure is given by (5.73) with \[Epsilon] = 1. The detailed \
calculation of the approximation can be found in the paper by ",
  ButtonBox["Eggers [1993]",
    ButtonData:>{"Literat.nb", "Eggers-1993"},
    ButtonStyle->"Hyperlink"],
  ". Our interest here is the derivation of a solution for the velocity field \
",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and the height of the fluid neck ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " in terms of similarity solutions. We first examine the model equations by \
Eggers with the complete pressure expression. Equations (5.74) and (5.75) are \
the starting point for our symmetry analysis. We first define the variables \
and the pressure by"
}], "Text",
  CellTags->{"velocity field", "similarity solutions"}],

Cell[BoxData[
    \(V = v[z, t]; H = h[z, t]; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(P\  = \ 
      \[Gamma] \((
          1\/\(H \((1 + \((\[PartialD]\_z\ H)\)\^2)\)\^\(1/2\)\) - 
            \[PartialD]\_\(z, z\)H
                \/\((1 + \((\[PartialD]\_z\ H)\)\^2)\)\^\(3/2\))\); 
    P // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\[Gamma]\ 
      \((1\/\(h\ \@\(1 + h\_z\%2\)\) - 
          h\_\(z, z\)\/\((1 + h\_z\%2)\)\^\(3/2\))\)\)], "Output"]
}, Open  ]],

Cell["The equations of motion for the liquid jet are given by", "Text",
  CellTags->"liquid jet"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eggers\  = 
      \({\[PartialD]\_t\ V + V \[PartialD]\_z\ V + 
              \[PartialD]\_z\ \(P\/\[Rho]\) - 
              3  \[Eta] 
                \[PartialD]\_z\ \((\(H\^2\) \[PartialD]\_z\ V)\)\/H\^2 + 
              \[Psi], \[PartialD]\_t\ H + V \[PartialD]\_z\ H + 
              \(H \[PartialD]\_z\ V\)\/2} // Together\) // Numerator; 
    eggers // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Gamma]\)\ h\_z - 2\ \[Gamma]\ h\_z\%3 - 
                \[Gamma]\ h\_z\%5 + h\^2\ \[Rho]\ \[Psi]\ \@\(1 + h\_z\%2\) + 
                2\ h\^2\ \[Rho]\ \[Psi]\ h\_z\%2\ \@\(1 + h\_z\%2\) + 
                h\^2\ \[Rho]\ \[Psi]\ h\_z\%4\ \@\(1 + h\_z\%2\) + 
                h\^2\ \[Rho]\ \@\(1 + h\_z\%2\)\ v\_t + 
                2\ h\^2\ \[Rho]\ h\_z\%2\ \@\(1 + h\_z\%2\)\ v\_t + 
                h\^2\ \[Rho]\ h\_z\%4\ \@\(1 + h\_z\%2\)\ v\_t + 
                h\^2\ v\ \[Rho]\ \@\(1 + h\_z\%2\)\ v\_z - 
                6\ h\ \[Eta]\ \[Rho]\ h\_z\ \@\(1 + h\_z\%2\)\ v\_z + 
                2\ h\^2\ v\ \[Rho]\ h\_z\%2\ \@\(1 + h\_z\%2\)\ v\_z - 
                12\ h\ \[Eta]\ \[Rho]\ h\_z\%3\ \@\(1 + h\_z\%2\)\ v\_z + 
                h\^2\ v\ \[Rho]\ h\_z\%4\ \@\(1 + h\_z\%2\)\ v\_z - 
                6\ h\ \[Eta]\ \[Rho]\ h\_z\%5\ \@\(1 + h\_z\%2\)\ v\_z - 
                h\ \[Gamma]\ h\_z\ h\_\(z, z\) - 
                h\ \[Gamma]\ h\_z\%3\ h\_\(z, z\) + 
                3\ h\^2\ \[Gamma]\ h\_z\ h\_\(z, z\)\%2 - 
                3\ h\^2\ \[Eta]\ \[Rho]\ \@\(1 + h\_z\%2\)\ v\_\(z, z\) - 
                6\ h\^2\ \[Eta]\ \[Rho]\ h\_z\%2\ \@\(1 + h\_z\%2\)\ 
                  v\_\(z, z\) - 
                3\ h\^2\ \[Eta]\ \[Rho]\ h\_z\%4\ \@\(1 + h\_z\%2\)\ 
                  v\_\(z, z\) - h\^2\ \[Gamma]\ h\_\(z, z, z\) - 
                h\^2\ \[Gamma]\ h\_z\%2\ h\_\(z, z, z\) == 0\)},
          {\(2\ h\_t + 2\ v\ h\_z + h\ v\_z == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "where \[Rho], \[Gamma], \[Eta], and \[Psi] denote the constant density, \
the surface tension, the kinematic viscosity, and the acceleration due to \
gravity, respectively. The infinitesimals of the equation follows by applying \
",
  StyleBox["Infinitesimals[]", "MmaText"],
  " to the equations:"
}], "Text",
  CellTags->{
  "density", "surface tension", "kinematic viscosity", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infiEggers\  = 
      Infinitesimals[
        eggers, {v, h}, {z, t}, {\[Rho], \[Gamma], \[Eta], \[Psi]}, 
        SubstitutionRules 
          \[Rule] {\[PartialD]\_{z, 3}\ H, \[PartialD]\_t\ H}]; 
    infiEggers // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k3\)},
          {\(\[Phi]\_2 == 0\)},
          {\(\[Xi]\_1 == k2 + k3\ t\)},
          {\(\[Xi]\_2 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], k3], 
        Equal[ 
          Subscript[ \[Phi], 2], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k3, t]]], 
        Equal[ 
          Subscript[ \[Xi], 2], k1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the calculation is a finite three-dimensional point group. \
The symmetries of the group are translations in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", and a special subgroup denoted by ",
  Cell[BoxData[
      FormBox[
        StyleBox["k3",
          FontSlant->"Italic"], TraditionalForm]]],
  " allowing a translation in ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and a transformation of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " connected with ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". These symmetries do not allow a scaling solution of the original \
equations. The scaling solutions are today used to discuss the pinch of the \
drop. However, we can find such solutions by changing the representation of \
the pressure."
}], "Text",
  CellTags->{"point group", "pinch of a drop"}],

Cell[TextData[{
  "The following calculations are based on the capillary pressure given by ",
  ButtonBox["Garcia and Castellanos [1994]",
    ButtonData:>{"Literat.nb", "Garcia and Castellanos-1994"},
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"capillary pressure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(P1\  = \ 
      \[Gamma] \((
          1\/\(\((1 + \[Epsilon]\ H)\) 
                \((1 + \[Epsilon] \((\[PartialD]\_z\ H)\)\^2)\)\^\(1/2\)\) - 
            \(\[Epsilon] 
                \[PartialD]\_\(z, z\)H\)\/\((
                  1 + \[Epsilon] \((\[PartialD]\_z\ H)\)\^2)\)\^\(3/2\))\); 
    P1 // \ LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\[Gamma]\ 
      \((1\/\(\((1 + h\ \[Epsilon])\)\ \@\(1 + \[Epsilon]\ h\_z\%2\)\) - 
          \(\[Epsilon]\ h\_\(z, z\)\)\/\((1 + \[Epsilon]\ h\_z\%2)\)\^\(3/2\))
        \)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Following the considerations by Garcia and Castellanos, we assume first \
that the parameter \[Epsilon] is a small quantity. This property recommends a \
Taylor expansion of the pressure around ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ". So we get an approximation of the capillary pressure for small \
\[Epsilon]\[CloseCurlyQuote]s up to first order. To identify any \
correspondence of the following calculations with those carried out above, we \
set ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 1\)]],
  " in the expansion:"
}], "Text",
  CellTags->"Taylor expansion"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p1\  = 
      \((Series[P1, {\[Epsilon], 0, 1}] // Normal)\)\  /. \ 
        \[Epsilon] \[Rule] 1\)], "Input"],

Cell[BoxData[
    RowBox[{"\[Gamma]", "+", 
      RowBox[{"\[Gamma]", " ", 
        RowBox[{"(", 
          RowBox[{\(-h[z, t]\), "-", 
            RowBox[{\(1\/2\), " ", 
              SuperscriptBox[
                RowBox[{
                  SuperscriptBox["h", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(z, t\), "]"}], "2"]}], 
            "-", 
            RowBox[{
              SuperscriptBox["h", 
                TagBox[\((2, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(z, t\), "]"}]}], ")"}]}]}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The pressure in this approximation is given mainly by a constant altered \
by geometrical terms linear in ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  ", quadratic in the gradient of the height of the fluid neck ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  ", and linear in the second derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  ". Inserting this result into the equations of motion (5.74) and (5.75), we \
find the reduced set"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(model1\  = 
      \({\[PartialD]\_t\ V + V \[PartialD]\_z\ V + 
              \[PartialD]\_z\ \(p1\/\[Rho]\) - 
              3  \[Eta] 
                \[PartialD]\_z\ \((\(H\^2\) \[PartialD]\_z\ V)\)\/H\^2 + 
              \[Psi], \[PartialD]\_t\ H + V \[PartialD]\_z\ H + 
              \(H \[PartialD]\_z\ V\)\/2} // Together\) // Numerator; 
    model1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(h\ \[Rho]\ \[Psi] - h\ \[Gamma]\ h\_z + h\ \[Rho]\ v\_t + 
                h\ v\ \[Rho]\ v\_z - 6\ \[Eta]\ \[Rho]\ h\_z\ v\_z - 
                h\ \[Gamma]\ h\_z\ h\_\(z, z\) - 
                3\ h\ \[Eta]\ \[Rho]\ v\_\(z, z\)\n\t - 
                h\ \[Gamma]\ h\_\(z, z, z\) == 0\)},
          {\(2\ h\_t + 2\ v\ h\_z + h\ v\_z == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
which are much simpler than the original model. Surprisingly, the \
infinitesimals of this reduced model are the same as in the original model:\
\
\>", "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1\  = 
      Infinitesimals[
        model1, {v, h}, {z, t}, {\[Rho], \[Gamma], \[Eta], \[Psi]}, 
        SubstitutionRules 
          \[Rule] {\[PartialD]\_{z, 3}\ H, \[PartialD]\_t\ H}]; 
    inf1 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k3\)},
          {\(\[Phi]\_2 == 0\)},
          {\(\[Xi]\_1 == k2 + k3\ t\)},
          {\(\[Xi]\_2 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], k3], 
        Equal[ 
          Subscript[ \[Phi], 2], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k3, t]]], 
        Equal[ 
          Subscript[ \[Xi], 2], k1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, we observe that the change of the pressure for small values of \
\[Epsilon] does not affect the symmetries of the original model. This is also \
true for higher-order approximations in \[Epsilon] of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ". The calculation is left as an exercise for the reader."
}], "Text"],

Cell[TextData[{
  "Another expression for the capillary pressure follows if we assume that \
the parameter \[Epsilon] is large. This limit can be achieved by replacing \
\[Epsilon] with 1/\[Lambda] in formula (5.73). In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we substitute 1/\[Lambda] for \[Epsilon] and expand the resulting \
pressure formula around ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 0\)]],
  ":"
}], "Text",
  CellTags->"capillary pressure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(P1\  = \ 
      \[Gamma] \((
          1\/\(\((1 + 1/\[Lambda]\ H)\) 
                \((1 + 1/\[Lambda] \((\[PartialD]\_z\ H)\)\^2)\)\^\(1/2\)\) - 
            \(1/\[Lambda] 
                \[PartialD]\_\(z, z\)H\)\/\((
                  1 + 1/\[Lambda] \((\[PartialD]\_z\ H)\)\^2)\)\^\(3/2\))\); 
    P1 // \ LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\[Gamma]\ 
      \((1\/\(\((1 + h\/\[Lambda])\)\ \@\(1 + h\_z\%2\/\[Lambda]\)\) - 
          h\_\(z, z\)\/\(\[Lambda]\ \((1 + h\_z\%2\/\[Lambda])\)\^\(3/2\)\))
        \)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The Taylor expansion of the pressure in the limit ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] \[Infinity]\)]],
  " follows by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p3\  = 
      \((Series[P1, {\[Lambda], 0, 1}] // Normal)\)\  /. \ 
        \[Lambda] \[Rule] 1; p3 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-\(\(\[Gamma]\ h\_\(z, z\)\)\/\((h\_z\%2)\)\^\(3/2\)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In this approximation, the pressure is given by a pure geometric term \
determined only by derivatives. This kind of approximation is similar to the \
",
  ButtonBox["Saffman-Taylor [1958]",
    ButtonData:>{"Literat.nb", "Saffman and Taylor-1958"},
    ButtonStyle->"Hyperlink"],
  " approximation and is also known as lubrication approximation. The \
equations of motion (5.74) and (5.75) in connection with the lubrication \
approximation are thus given by"
}], "Text",
  CellTags->{"Saffman-Taylor approximation", "lubrication approximation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(model2\  = 
      \(\({\[PartialD]\_t\ V + V \[PartialD]\_z\ V + 
                \[PartialD]\_z\ \(p3\/\[Rho]\) - 
                3  \[Eta] 
                  \[PartialD]\_z\ \((\(H\^2\) \[PartialD]\_z\ V)\)\/H\^2 + 
                \[Psi], 
              \[PartialD]\_t\ H + V \[PartialD]\_z\ H + 
                \(H \[PartialD]\_z\ V\)\/2} // Together\) // Numerator\) // 
        PowerExpand; model2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(h\ \[Rho]\ \[Psi]\ h\_z\%4 + h\ \[Rho]\ h\_z\%4\ v\_t + 
                h\ v\ \[Rho]\ h\_z\%4\ v\_z - 
                6\ \[Eta]\ \[Rho]\ h\_z\%5\ v\_z + 
                3\ h\ \[Gamma]\ h\_\(z, z\)\%2 - 
                3\ h\ \[Eta]\ \[Rho]\ h\_z\%4\ v\_\(z, z\)\n\t - 
                h\ \[Gamma]\ h\_z\ h\_\(z, z, z\) == 0\)},
          {\(2\ h\_t + 2\ v\ h\_z + h\ v\_z == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The corresponding infinitesimals for this kind of model follows \
by\
\>", "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf3 = 
      Infinitesimals[
        model2, {v, h}, {z, t}, {\[Rho], \[Gamma], \[Eta], \[Psi]}, 
        SubstitutionRules 
          \[Rule] {\[PartialD]\_{z, 3}\ H, \[PartialD]\_t\ H}]; 
    inf3 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"k4", "+", 
                
                StyleBox[
                  \(\(2\ k5\ \((v + 3\ t\ \[Psi])\)\)\/\(3\ \[Psi]\)\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{"-", 
                StyleBox[\(\(h\ k5\)\/\[Psi]\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{
              "k2", "+", "k3", "+", \(k4\ t\), "+", \(k5\ t\^2\), "-", 
                StyleBox[\(\(2\ k5\ z\)\/\(3\ \[Psi]\)\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{"k1", "-", 
                StyleBox[\(\(4\ k5\ t\)\/\(3\ \[Psi]\)\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k4, 
            Times[ 
              Rational[ 2, 3], k5, 
              Power[ \[Psi], -1], 
              Plus[ v, 
                Times[ 3, t, \[Psi]]]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Times[ -1, h, k5, 
            Power[ \[Psi], -1]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, k3, 
            Times[ k4, t], 
            Times[ k5, 
              Power[ t, 2]], 
            Times[ 
              Rational[ -2, 3], k5, z, 
              Power[ \[Psi], -1]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 
              Rational[ -4, 3], k5, t, 
              Power[ \[Psi], -1]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We clearly observe that the structure of the symmetries changed. The \
number of group parameters increased. The additional symmetries now allow a \
scaling solution of the equations. We also observe that the constant of \
gravity \[Psi] determines the symmetry properties of the scaling \
transformation. The related group parameter of the scaling group is ",
  Cell[BoxData[
      \(TraditionalForm\`k5\)],
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"scaling solution", "scaling transformation"}],

Cell[TextData[{
  "Another method of approximating the capillary pressure taken from Eggers \
is the assumption that the spatial derivatives in ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " are small compared with the horizontal elongation ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " itself. This assumption can be realized in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by the following replacement:"
}], "Text",
  CellTags->"capillary pressure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p4\  = \ P\  /. \ \(\(Derivative[___]\)[h]\)[___] \[Rule] 0\)], "Input"],

Cell[BoxData[
    \(\[Gamma]\/h[z, t]\)], "Output"]
}, Open  ]],

Cell["The two equations of motion simplify to", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(simplifiedEggers\  = 
      \({\[PartialD]\_t\ V + V \[PartialD]\_z\ V + 
              \[PartialD]\_z\ \(p4\/\[Rho]\) - 
              3  \[Eta] 
                \[PartialD]\_z\ \((\(H\^2\) \[PartialD]\_z\ V)\)\/H\^2 + 
              \[Psi], \[PartialD]\_t\ H + V \[PartialD]\_z\ H + 
              \(H \[PartialD]\_z\ V\)\/2} // Together\) // Numerator; 
    simplifiedEggers // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(h\^2\ \[Rho]\ \[Psi] - \[Gamma]\ h\_z + h\^2\ \[Rho]\ v\_t + 
                h\^2\ v\ \[Rho]\ v\_z - 6\ h\ \[Eta]\ \[Rho]\ h\_z\ v\_z - 
                3\ h\^2\ \[Eta]\ \[Rho]\ v\_\(z, z\) == 0\)},
          {\(2\ h\_t + 2\ v\ h\_z + h\ v\_z == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The symmetries of this set of equations follow by", "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf4 = 
      Infinitesimals[
        simplifiedEggers, {v, h}, {z, t}, {\[Rho], \[Gamma], \[Eta], \[Psi]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_t V, \[PartialD]\_t\ H}]; 
    inf4 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"k4", "+", 
                
                StyleBox[
                  \(\(2\ k5\ \((v + 3\ t\ \[Psi])\)\)\/\(3\ \[Psi]\)\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{"-", 
                StyleBox[\(\(4\ h\ k5\)\/\(3\ \[Psi]\)\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{
              "k2", "+", "k3", "+", \(k4\ t\), "+", \(k5\ t\^2\), "-", 
                StyleBox[\(\(2\ k5\ z\)\/\(3\ \[Psi]\)\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{"k1", "-", 
                StyleBox[\(\(4\ k5\ t\)\/\(3\ \[Psi]\)\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k4, 
            Times[ 
              Rational[ 2, 3], k5, 
              Power[ \[Psi], -1], 
              Plus[ v, 
                Times[ 3, t, \[Psi]]]]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Times[ 
            Rational[ -4, 3], h, k5, 
            Power[ \[Psi], -1]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, k3, 
            Times[ k4, t], 
            Times[ k5, 
              Power[ t, 2]], 
            Times[ 
              Rational[ -2, 3], k5, z, 
              Power[ \[Psi], -1]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 
              Rational[ -4, 3], k5, t, 
              Power[ \[Psi], -1]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is again a five-dimensional finite group containing \
translations ",
  StyleBox["k1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k3",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k4",
    FontSlant->"Italic"],
  ", and a scaling symmetry given by ",
  Cell[BoxData[
      FormBox[
        StyleBox["k5",
          FontSlant->"Italic"], TraditionalForm]]],
  ". The scaling symmetry depends on the gravity acceleration \[Psi]. This \
set of symmetries is isomorphic to the infinitesimals ",
  StyleBox["inf3",
    FontSlant->"Italic"],
  ". The difference between the two models however is the pressure in the \
equations. Let us first examine the solution of the equations connected with \
the symmetry of translation. A subgroup of translations is given by the \
infinitesimals"
}], "Text",
  CellTags->"finite group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1\  = \ 
      \({{\(xi[1]\)[z, t, v, h], \(xi[2]\)[z, t, v, h]}, {
              \(phi[1]\)[z, t, v, h], \(phi[2]\)[z, t, v, h]}}\  /. inf4
          \)\  /. {k1 \[Rule] 1, k2 \[Rule] c, k3 \[Rule] 0, k4 \[Rule] 0, 
          k5 \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{c, 1}, {0, 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
The corresponding similarity reduction of the original equations \
follows with\
\>", "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ 
      LieReduction[simplifiedEggers\ , {v, h}, {z, t}, infi1[\([1]\)], 
        infi1[\([2]\)]]; LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(\(-c\)\ t + z\)\/c\),
                    ScriptLevel->0]}], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(v - F\_1 == 0\)},
          {\(h - F\_2 == 0\)},
          {
            \(c\^2\ \[Rho]\ \[Psi]\ F\_2\%2 + 
                c\^2\ \[Rho]\ F\_2\%2\ \((F\_1)\)\_\(\[Zeta]\_1\) - 
                c\ \[Rho]\ F\_1\ F\_2\%2\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                c\ \[Gamma]\ \((F\_2)\)\_\(\[Zeta]\_1\) - 
                6\ \[Eta]\ \[Rho]\ F\_2\ \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_2)\)\_\(\[Zeta]\_1\) - 
                3\ \[Eta]\ \[Rho]\ F\_2\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {
            \(\(-F\_2\)\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                2\ c\ \((F\_2)\)\_\(\[Zeta]\_1\) - 
                2\ F\_1\ \((F\_2)\)\_\(\[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The similarity solution of the equations including gravity is given \
by a moving wave solution. Examining the second equation of the reduction, we \
realize that a special solution of this equation is a constant. Inserting \
this kind of solution into the reduced equations, we get\
\>", "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rode\  = 
      red1\[LeftDoubleBracket]3\[RightDoubleBracket] /. 
        F1 \[Rule] Function[zeta1, c]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(c\^2\ \[Rho]\ \[Psi]\ F2[zeta1]\^2\), "+", 
            RowBox[{"c", " ", "\[Gamma]", " ", 
              RowBox[{
                SuperscriptBox["F2", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
          "0"}], ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The two equations simplify to a single first-order ODE which allows \
the solution\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1\  = 
      DSolve[rode\[LeftDoubleBracket]1\[RightDoubleBracket], F2, zeta1] // 
        Flatten\)], "Input"],

Cell[BoxData[
    \({F2 \[Rule] \((\[Gamma]\/\(c\ #1\ \[Rho]\ \[Psi] - C[1]\)&)\)}\)], 
  "Output"]
}, Open  ]],

Cell["A special set of solutions is thus", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[s1, F1 \[Rule] Function[zeta1, c]]; s1\)], "Input"],

Cell[BoxData[
    \({F2 \[Rule] \((\[Gamma]\/\(c\ #1\ \[Rho]\ \[Psi] - C[1]\)&)\), 
      F1 \[Rule] Function[zeta1, c]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "It is obvious from the formula above that the fluid neck becomes infinite \
if ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Zeta]", "=", 
          RowBox[{\(C[1]\), "/", 
            RowBox[{"(", 
              StyleBox[
                RowBox[{
                  StyleBox["c",
                    FontSlant->"Italic"], "\[Rho]\[Psi]"}]], ")"}]}]}], 
        TraditionalForm]]],
  ". In the original variables, the solution reads"
}], "Text",
  CellTags->"fluid neck"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ 
      red1\[LeftDoubleBracket]2\[RightDoubleBracket]\  /. s1 // Simplify\)], 
  "Input"],

Cell[BoxData[
    \({v == c, 
      h + \[Gamma]\/\(\(-c\)\ t\ \[Rho]\ \[Psi] + z\ \[Rho]\ \[Psi] + 
              C[1]\) == 0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] is a constant of integration. If we insert for the parameters \
\[Gamma], c, \[Rho], \[Psi], and ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] numeric values, we are able to plot the solution. The following \
animation shows the movement of the singularity of ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " along the",
  StyleBox[" z-",
    FontSlant->"Italic"],
  "axis while the time is changed from 0 to 2.5 in steps of 0.1."
}], "Text",
  CellTags->{"animation", "animation of the singularity movement"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Plot[
        \(-\(\[Gamma]\/\(\(-c\)\ t\ \[Rho]\ \[Psi] + z\ \[Rho]\ \[Psi] + 
                  C[1]\)\)\) /. {\[Gamma] \[Rule] 1, c \[Rule] 2, 
            \[Rho] \[Rule] 1, \[Psi] \[Rule] 9.81, C[1] \[Rule] 10, 
            t \[Rule] ti}, {z, \(-3\), 5}, 
        PlotStyle \[Rule] RGBColor[0, 0, 1], 
        PlotRange \[Rule] {{\(-3\), 5}, {\(-3\), 3}}, 
        AxesLabel \[Rule] {"\<z\>", "\<h\>"}], {ti, 0, 2.5,  .1}]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31432 m
.01975 .31478 L
.04057 .31536 L
.06347 .31615 L
.08481 .31708 L
.10412 .31817 L
.12477 .3197 L
.13549 .32073 L
.14714 .32208 L
.1572 .32354 L
.16829 .32557 L
.17904 .32817 L
.18911 .33147 L
.19467 .33382 L
.19975 .33646 L
.20562 .3403 L
.2112 .34509 L
.21647 .35121 L
.22126 .35889 L
.22392 .36448 L
.22679 .37214 L
.2295 .3816 L
.23199 .39322 L
.23431 .4079 L
.23647 .42713 L
.23771 .44197 L
.23884 .45917 L
.24014 .48553 L
.24138 .52073 L
.24258 .57137 L
s
.24258 .57137 m
.24324 .61803 L
s
.24858 .61803 m
.24868 0 L
s
.25193 0 m
.25264 .04964 L
.25391 .10156 L
.25504 .13316 L
.25627 .15808 L
.25762 .17828 L
.25904 .19451 L
.26027 .2056 L
.26159 .21535 L
.26395 .22883 L
.26615 .23835 L
.26877 .24709 L
.27117 .25338 L
.2765 .26364 L
.27952 .26793 L
.28232 .27124 L
.28783 .27641 L
.2929 .28006 L
.29825 .28311 L
.30403 .28577 L
.31449 .2894 L
.32401 .29184 L
.33404 .29384 L
.34402 .29541 L
.35471 .29677 L
.37397 .29863 L
.39631 .30019 L
.41745 .30129 L
.45775 .30277 L
.47856 .30333 L
.50063 .30383 L
.54032 .30453 L
.58259 .3051 L
.62327 .30552 L
.66652 .30588 L
.70818 .30617 L
.74825 .3064 L
.79089 .3066 L
.83194 .30677 L
.87557 .30693 L
.91761 .30706 L
.95805 .30717 L
1 .30727 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
05eoo`807aEoo`H000Ioo`03001oogoo00Aoo`<00=ioo`00GGoo0P0O7goo0P001goo00<007ooOol0
gWoo001MOol201lQOol00`00Oomoo`04Ool00`00Oomoo`3NOol005eoo`807aeoo`05001oogooOol0
0006Ool00`00Oomoo`3NOol005eoo`807aioo`<000Moo`03001oogoo0=ioo`00GGoo0P0O:7oo00<0
07ooOol0gWoo001MOol201lXOol00`00Oomoo`3NOol005eoo`807bQoo`800=moo`00GGoo0P0O:7oo
00<007ooOol0gWoo001MOol201lXOol00`00Oomoo`3NOol005eoo`807bQoo`03001oogoo0=ioo`00
GGoo0P0O:7oo00<007ooOol0gWoo001MOol201lXOol00`00Oomoo`3NOol005eoo`807bQoo`800=mo
o`00GGoo0P0O:7oo00<007ooOol0gWoo001MOol201lXOol00`00Oomoo`3NOol005eoo`807bQoo`03
001oogoo0=ioo`00GGoo0P0O:7oo00<007ooOol0gWoo001MOol201lXOol00`00Oomoo`3NOol005eo
o`807bQoo`03001oogoo0=ioo`00GGoo0P0O:7oo0P00ggoo001MOol201lXOol00`00Oomoo`3NOol0
05eoo`807bQoo`03001oogoo0=ioo`00GGoo0P0O:7oo00<007ooOol0gWoo001MOol201lXOol00`00
Oomoo`3NOol005eoo`807bQoo`03001oogoo0=ioo`00GGoo0P0O:7oo00<007ooOol0gWoo001MOol2
01lXOol2003OOol005eoo`807bQoo`03001oogoo0=ioo`00GGoo0P0O:7oo00<007ooOol0gWoo001M
Ool201lXOol00`00Oomoo`3NOol005eoo`807aeoo`D000Ioo`03001oogoo0=ioo`00GGoo0P0O7Goo
00D007ooOomoo`0000Ioo`03001oogoo0=ioo`00GGoo0P0O7Woo00<007ooOol01goo00<007ooOol0
gWoo001MOol201lEOol60004Ool00`00Oomoo`06Ool3003NOol005eoo`807b1oo`03001oogoo00Eo
o`03001oogoo0=ioo`00GGoo0P0O8Goo00<007ooOol017oo00<007ooOol0gWoo001MOol201lMOol0
1@00Oomoogoo00001Woo00<007ooOol0gWoo001MOol201lNOol30007Ool00`00Oomoo`3NOol005eo
o`0301moo`0O02Moo`03001oogoo0=ioo`00GGoo00<07goo01l09goo00<007ooOol0gWoo001MOol0
0`0OOol07`0WOol2003OOol005eoo`0301moo`0O02Moo`03001oogoo0=ioo`00GGoo00<07goo01l0
9goo00<007ooOol0gWoo001MOol00`0OOol07`0WOol00`00Oomoo`3NOol005eoo`0301moo`0O02Mo
o`03001oogoo0=ioo`00GGoo00<07goo01l09goo00<007ooOol0gWoo001MOol00`0OOol07`0WOol0
0`00Oomoo`3NOol005eoo`0301moo`0O02Moo`800=moo`00GGoo00<07goo01l09goo00<007ooOol0
gWoo001MOol00`0OOol07`0WOol00`00Oomoo`3NOol005eoo`0301moo`0O02Moo`03001oogoo0=io
o`00GGoo00<07goo01l09goo00<007ooOol0gWoo001MOol00`0OOol07`0WOol00`00Oomoo`3NOol0
05eoo`0301moo`0O02Moo`800=moo`00GGoo00<07goo01l09goo00<007ooOol0gWoo001MOol0100O
Oomoo`0O9Woo00<007ooOol0gWoo001MOol0100OOomoo`0O9Woo00<007ooOol0gWoo001MOol0100O
Oomoo`0O9Woo00<007ooOol0gWoo001MOol0100OOomoo`0O9Woo00<007ooOol0gWoo001MOol0100O
Oomoo`0O9Woo00<007ooOol0gWoo001MOol0100OOomoo`0O9Woo0P00ggoo001MOol0100OOomoo`0O
9Woo00<007ooOol0gWoo001MOol0100OOomoo`0O9Woo00<007ooOol0gWoo001MOol0100OOomoo`0O
9Woo00<007ooOol0gWoo001MOol0100OOomoo`0O77oo1@001Goo00<007ooOol0gWoo001MOol01@0O
Oomoogoo01l07Goo00<007ooOol01Goo00<007ooOol0gWoo001MOol01@0OOomoogoo01l07Goo00<0
07ooOol01Goo00<007ooOol0gWoo001MOol01@0OOomoogoo01l04Woo1P001Goo00<007ooOol01Goo
0`00gWoo001MOol01@0OOomoogoo01l07Goo00<007ooOol01Goo00<007ooOol0gWoo001MOol01@0O
Oomoogoo01l07Goo00<007ooOol01Goo00<007ooOol0gWoo001MOol01@0OOomoogoo01l06goo0`00
1goo00<007ooOol0gWoo001MOol01@0OOomoogoo01l07Goo00<007ooOol01Goo00<007ooOol0gWoo
001MOol01@0OOomoogoo01l09Goo00<007ooOol0gWoo001MOol00`0OOomoo`02Ool00`0OOomoo`0R
Ool00`00Oomoo`3NOol005eoo`0301moogoo009oo`0301moogoo029oo`800=moo`00GGoo00<07goo
Ool00Woo00<07gooOol08Woo00<007ooOol0gWoo001MOol00`0OOomoo`02Ool00`0OOomoo`0ROol0
0`00Oomoo`3NOol005eoo`0301moogoo00=oo`0301moogoo025oo`03001oogoo0=ioo`00GGoo00<0
7gooOol00goo00<07gooOol08Goo00<007ooOol0gWoo001MOol00`0OOomoo`03Ool00`0OOomoo`0Q
Ool00`00Oomoo`3NOol005eoo`0301moogoo00=oo`0301moogoo025oo`03001oogoo0=ioo`00GGoo
00<07gooOol00goo00<07gooOol08Goo0P00ggoo001MOol00`0OOomoo`04Ool00`0OOomoo`0POol0
0`00Oomoo`3NOol005eoo`0301moogoo00Aoo`0301moogoo021oo`03001oogoo0=ioo`00GGoo00<0
7gooOol01Goo00<07gooOol07goo00<007ooOol0gWoo001MOol00`0OOomoo`05Ool00`0OOomoo`0O
Ool00`00Oomoo`3NOol000aoo`<002Ioo`D002=oo`0301moo`0000@0009oo`0301moogoo01ioo`03
001oogoo02Aoo`D002Aoo`D002Eoo`<002Qoo`<002Eoo`@0011oo`002goo00D007ooOomoo`0002Eo
o`05001oogooOol0000SOol01@0OOomoogoo00001Goo00<07gooOol07Goo00<007ooOol09Woo00<0
07ooOol097oo00D007ooOomoo`0002Aoo`05001oogooOol0000XOol00`00Oomoo`0SOol00`00Oomo
o`02Ool00`00Oomoo`0=Ool000moo`03001oogoo02Aoo`03001oogoo02Aoo`0501moogooOol00005
Ool00`0OOomoo`0MOol2000WOol00`00Oomoo`0UOol00`00Oomoo`0YOol00`00Oomoo`0VOol00`00
Oomoo`0XOol00`00Oomoo`0=Ool000=oo`H000Ioo`03001oogoo01]oo`H000Aoo`03001oogoo01ao
o`H00003Ool07goo009oo`03001oogoo00Aoo`0301moogoo01aoo`03001oogoo02Ioo`03001oogoo
02Ioo`03001oogoo02Qoo`03001oogoo029oo`H002Uoo`03001oogoo00eoo`003Goo0P00:Goo00<0
07ooOol08Woo00D07gooOomoo`0000Moo`807aaoo`03001oogoo02Ioo`03001oogoo02Moo`03001o
ogoo02Eoo`8002Ioo`04001oogoo000VOol4000@Ool000moo`03001oogoo02Moo`03001oogoo025o
o`0501moogooOol00009Ool00`0OOomoo`0IOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomo
o`0VOol00`00Oomoo`0SOol01000Oomoo`009Woo00<007ooOol04Goo000;Ool01@00Oomoogoo0000
9Goo00D007ooOomoo`0002=oo`0301moo`00008000Uoo`0301moogoo01Uoo`03001oogoo02Aoo`<0
02Ioo`05001oogooOol0000TOol01@00Oomoogoo00009Woo00<007oo00009Woo00<007ooOol04Goo
000<Ool3000WOol3000TOol01@0OOomoogoo00002Woo0P0O6Goo00<007ooOol09Woo00<007ooOol0
9Goo0`009Woo0`00:7oo0P009Woo1@003goo001MOol00`0OOomoo`0>Ool301lFOol2003OOol005eo
o`0301moogoo015oo`@07a9oo`03001oogoo0=ioo`00GGoo00<07gooOol05Goo1P0O37oo00<007oo
Ool0gWoo001MOol00`0OOomoo`0KOol801l4Ool00`00Oomoo`3NOol005eoo`0301moogoo02=oo`l0
7mIoo`00GGoo00<07gooOol09goo00<007ooOol027oo6`0O^goo001MOol00`0OOomoo`0WOol00`00
Oomoo`0SOomi01m2Ool000Yooe<0000301l000000<H003407a5oo`002Woo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<07gooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol02Woo1@00
000:OolB01lHOol00`00Oomoo`0VOol00`0OOomoo`0WOol00`00Oomoo`0VOol00`00Oomoo`0WOol0
0`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0:Ool01000Oomoogoo0@00
000LOolE01l/Ool00`0OOomoo`0WOol00`00Oomoo`3JOol00`00Oomoo`01Ool0035oo`P07bAoo`03
01moogoo02Moo`03001oogoo0=]oo`40005oo`5oo`00>Goo1`0O7Goo00<07gooOol09goo00<007oo
Ool0fGoo00@007ooOol0005oo`00@7oo100O6Goo00<07gooOol09goo00<007ooOol0fGoo1@000014
Ool401lEOol00`0OOomoo`0WOol2003OOol004Qoo`@07a5oo`0301moogoo02Moo`03001oogoo0=io
o`00C7oo0P0O3goo00<07gooOol09goo00<007ooOol0gWoo001>Ool00`0OOomoo`0<Ool00`0OOomo
o`0WOol00`00Oomoo`3NOol004ioo`0301moogoo00aoo`0301moogoo02Moo`03001oogoo0=ioo`00
Cgoo0P0O37oo00<07gooOol09goo00<007ooOol0gWoo001AOol00`0OOomoo`09Ool00`0OOomoo`0W
Ool00`00Oomoo`3NOol0059oo`0301moogoo00Qoo`0301moogoo02Moo`800=moo`00Dgoo00<07goo
Ool01goo00<07gooOol09goo00<007ooOol0gWoo001COol00`0OOomoo`07Ool00`0OOomoo`0WOol0
0`00Oomoo`3NOol005Aoo`0301moogoo00Ioo`0301moogoo02Moo`03001oogoo0=ioo`00EGoo00<0
7gooOol01Goo00<07gooOol09goo00<007ooOol0gWoo001EOol00`0OOomoo`05Ool00`0OOomoo`0W
Ool00`00Oomoo`3NOol005Ioo`0301moogoo00Aoo`0301moogoo02Moo`03001oogoo0=ioo`00EWoo
00<07gooOol017oo00<07gooOol09goo0P00ggoo001FOol00`0OOomoo`04Ool00`0OOomoo`0WOol0
0`00Oomoo`3NOol005Ioo`0301moogoo00Aoo`0301moogoo02Moo`03001oogoo0=ioo`00EWoo00<0
7gooOol017oo00<07gooOol09goo00<007ooOol0gWoo001FOol00`0OOomoo`04Ool00`0OOomoo`0W
Ool00`00Oomoo`3NOol005Moo`0301moogoo00=oo`0301moogoo02Moo`03001oogoo0=ioo`00Egoo
00<07gooOol00goo00<07gooOol09goo00<007ooOol0gWoo001GOol00`0OOomoo`03Ool00`0OOomo
o`0WOol2003OOol005Moo`0301moogoo00=oo`0301moogoo02Moo`03001oogoo0=ioo`00Egoo00<0
7gooOol00goo00<07gooOol09goo00<007ooOol0gWoo001HOol00`0OOomoo`02Ool00`0OOomoo`0M
Ool50005Ool00`00Oomoo`3NOol005Qoo`0301moogoo009oo`0301moogoo01moo`03001oogoo00Eo
o`03001oogoo0=ioo`00F7oo00<07gooOol00Woo00<07gooOol07goo00<007ooOol01Goo00<007oo
Ool0gWoo001HOol00`0OOomoo`02Ool00`0OOomoo`0OOol00`00Oomoo`05Ool3003NOol005Qoo`03
01moogoo009oo`0301moogoo01moo`03001oogoo00Eoo`03001oogoo0=ioo`00FGoo00D07gooOomo
o`0O025oo`03001oogoo00Eoo`03001oogoo0=ioo`00FGoo00D07gooOomoo`0O01moo`<000Moo`03
001oogoo0=ioo`00FGoo00D07gooOomoo`0O025oo`03001oogoo00Eoo`03001oogoo0=ioo`00FGoo
00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=io
o`00FGoo00D07gooOomoo`0O02Uoo`800=moo`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=io
o`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00FGoo00D07gooOomoo`0O02Uoo`03001o
ogoo0=ioo`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00FGoo00D07gooOomoo`0O02Uo
o`03001oogoo0=ioo`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00FGoo00D07gooOomo
o`0O02Uoo`800=moo`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00FGoo00D07gooOomo
o`0O02Uoo`03001oogoo0=ioo`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00FGoo00D0
7gooOomoo`0O02Uoo`03001oogoo0=ioo`00FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00
FGoo00D07gooOomoo`0O02Uoo`03001oogoo0=ioo`00FWoo00@07gooOol07bUoo`800=moo`00FWoo
00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo
00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo
00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo
00@07gooOol07bUoo`800=moo`00FWoo00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo00@07goo
Ool07bUoo`03001oogoo0=ioo`00FWoo00@07gooOol07bUoo`03001oogoo0=ioo`00FWoo00@07goo
Ool07aioo`D000Ioo`03001oogoo0=ioo`00FWoo00@07gooOol07aioo`05001oogooOol00006Ool0
0`00Oomoo`3NOol005Yoo`0401moogoo01lOOol00`00Oomoo`07Ool00`00Oomoo`3NOol005Yoo`04
01moogoo01lPOol00`00Oomoo`06Ool3003NOol005Yoo`0401moogoo01lQOol00`00Oomoo`05Ool0
0`00Oomoo`3NOol005Yoo`0401moogoo01lROol00`00Oomoo`04Ool00`00Oomoo`3NOol005Yoo`04
01moogoo01lNOol01@00Oomoogoo00001Woo00<007ooOol0gWoo001JOol0100OOomoo`0O7goo0`00
1goo00<007ooOol0gWoo001JOol0100OOomoo`0O:Goo00<007ooOol0gWoo001JOol0100OOomoo`0O
:Goo0P00ggoo001JOol0100OOomoo`0O:Goo00<007ooOol0gWoo001JOol0100OOomoo`0O:Goo00<0
07ooOol0gWoo001JOol0100OOomoo`0O:Goo00<007ooOol0gWoo001KOol00`0OOol07`0YOol00`00
Oomoo`3NOol005]oo`0301moo`0O02Uoo`03001oogoo0=ioo`00Fgoo00<07goo01l0:Goo00<007oo
Ool0gWoo001KOol00`0OOol07`0YOol2003OOol005]oo`0301moo`0O02Uoo`03001oogoo0=ioo`00
Fgoo00<07goo01l0:Goo00<007ooOol0gWoo001KOol00`0OOol07`0YOol00`00Oomoo`3NOol005]o
o`0301moo`0O02Uoo`03001oogoo0=ioo`00Fgoo00<07goo01l0:Goo00<007ooOol0gWoo001KOol0
0`0OOol07`0YOol00`00Oomoo`3NOol005]oo`0301moo`0O02Uoo`800=moo`00Fgoo00<07goo01l0
:Goo00<007ooOol0gWoo001KOol00`0OOol07`0YOol00`00Oomoo`3NOol005]oo`0301moo`0O02Uo
o`03001oogoo0=ioo`00Fgoo00<07goo01l0:Goo00<007ooOol0gWoo001KOol00`0OOol07`0YOol0
0`00Oomoo`3NOol005]oo`0301moo`0O02Uoo`03001oogoo0=ioo`00Fgoo00<07goo01l0:Goo0P00
ggoo001KOol00`0OOol07`0YOol00`00Oomoo`3NOol005]oo`0301moo`0O02Uoo`03001oogoo0=io
o`00Fgoo00<07goo01l0:Goo00<007ooOol0gWoo001KOol00`0OOol07`0OOol30007Ool00`00Oomo
o`3NOol005]oo`0301moo`0O01ioo`05001oogooOol00006Ool00`00Oomoo`3NOol005]oo`0301mo
o`0O029oo`03001oogoo00Aoo`03001oogoo0=ioo`00Fgoo00<07goo01l08Woo00<007ooOol017oo
0`00gWoo001nOol2003XOol0081oo`03001oogoo0>Eoo`00O7oo00D007ooOomoo`000>Moo`00OGoo
0`00j7oo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00R7oo0`0000Aoo`00
00000=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31383 m
.01975 .31421 L
.04057 .31467 L
.06347 .31529 L
.08481 .31601 L
.10535 .31687 L
.12477 .3179 L
.14621 .3194 L
.16571 .3213 L
.17589 .32259 L
.18668 .3243 L
.1959 .32613 L
.20605 .32874 L
.2115 .33051 L
.21669 .3325 L
.22642 .33745 L
.23186 .34125 L
.23691 .34581 L
.24244 .35257 L
.24554 .35756 L
.24835 .36318 L
.25099 .36982 L
.25347 .37769 L
.25604 .38839 L
.2575 .39604 L
.25887 .40478 L
.26004 .41372 L
.26132 .42556 L
.26238 .43766 L
.26355 .45432 L
.26481 .47791 L
.26615 .51312 L
.26739 .56198 L
s
.26739 .56198 m
.26828 .61803 L
s
.27124 .61803 m
.27124 0 L
s
.27688 0 m
.2779 .06254 L
.27908 .10701 L
.28043 .14187 L
.2817 .16511 L
.28309 .18415 L
.28458 .1997 L
.28615 .21229 L
.28763 .22183 L
.29042 .23544 L
.29315 .2452 L
.29571 .25228 L
.30051 .26203 L
.3032 .26616 L
.30567 .26936 L
.31125 .27508 L
.31574 .27861 L
.32066 .28172 L
.33057 .28639 L
.33609 .28835 L
.34132 .28992 L
.3511 .2923 L
.36163 .29428 L
.37307 .29596 L
.39388 .2982 L
.40438 .29906 L
.41595 .29986 L
.43802 .30108 L
.45822 .30195 L
.4989 .30322 L
.51881 .30369 L
.54056 .30412 L
.5832 .30479 L
.62425 .30528 L
.66788 .3057 L
.70992 .30602 L
.75036 .30627 L
.79338 .3065 L
.83481 .30668 L
.87464 .30684 L
.91705 .30698 L
.95788 .3071 L
1 .30721 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
06Aoo`0301moo`0O00eoo`H000Ioo`03001oogoo00Aoo`<00=ioo`00I7oo00<07goo01l05goo0P00
1goo00<007ooOol0gWoo001TOol00`0OOol07`0IOol00`00Oomoo`04Ool00`00Oomoo`3NOol006Ao
o`0301moo`0O01Eoo`05001oogooOol00006Ool00`00Oomoo`3NOol006Aoo`0301moo`0O01Ioo`<0
00Moo`03001oogoo0=ioo`00I7oo00<07goo01l087oo00<007ooOol0gWoo001TOol00`0OOol07`0P
Ool00`00Oomoo`3NOol006Aoo`0301moo`0O021oo`800=moo`00I7oo00<07goo01l087oo00<007oo
Ool0gWoo001TOol00`0OOol07`0POol00`00Oomoo`3NOol006Aoo`0301moo`0O021oo`03001oogoo
0=ioo`00I7oo00<07goo01l087oo00<007ooOol0gWoo001TOol00`0OOol07`0POol00`00Oomoo`3N
Ool006Aoo`0301moo`0O021oo`800=moo`00I7oo00<07goo01l087oo00<007ooOol0gWoo001TOol0
0`0OOol07`0POol00`00Oomoo`3NOol006Aoo`0301moo`0O021oo`03001oogoo0=ioo`00I7oo00<0
7goo01l087oo00<007ooOol0gWoo001TOol00`0OOol07`0POol00`00Oomoo`3NOol006Aoo`0301mo
o`0O021oo`03001oogoo0=ioo`00I7oo00<07goo01l087oo0P00ggoo001TOol00`0OOol07`0POol0
0`00Oomoo`3NOol006Aoo`0301moo`0O021oo`03001oogoo0=ioo`00I7oo00<07goo01l087oo00<0
07ooOol0gWoo001TOol00`0OOol07`0POol00`00Oomoo`3NOol006Aoo`0301moo`0O021oo`03001o
ogoo0=ioo`00I7oo00<07goo01l087oo00<007ooOol0gWoo001TOol00`0OOol07`0POol2003OOol0
06Aoo`0401moogoo01lOOol00`00Oomoo`3NOol006Aoo`0401moogoo01lOOol00`00Oomoo`3NOol0
06Aoo`0401moogoo01lOOol00`00Oomoo`3NOol006Aoo`0401moogoo01lDOol50006Ool00`00Oomo
o`3NOol006Aoo`0401moogoo01lDOol01@00Oomoogoo00001Woo00<007ooOol0gWoo001TOol0100O
Oomoo`0O5Goo00<007ooOol01goo00<007ooOol0gWoo001TOol0100OOomoo`0O37oo1P0017oo00<0
07ooOol01Woo0`00gWoo001TOol0100OOomoo`0O5goo00<007ooOol01Goo00<007ooOol0gWoo001T
Ool0100OOomoo`0O67oo00<007ooOol017oo00<007ooOol0gWoo001TOol0100OOomoo`0O57oo00D0
07ooOomoo`0000Ioo`03001oogoo0=ioo`00I7oo00@07gooOol07aEoo`<000Moo`03001oogoo0=io
o`00I7oo00@07gooOol07amoo`03001oogoo0=ioo`00I7oo00@07gooOol07amoo`03001oogoo0=io
o`00I7oo00@07gooOol07amoo`800=moo`00I7oo00@07gooOol07amoo`03001oogoo0=ioo`00I7oo
00@07gooOol07amoo`03001oogoo0=ioo`00I7oo00@07gooOol07amoo`03001oogoo0=ioo`00I7oo
00@07gooOol07amoo`03001oogoo0=ioo`00I7oo00@07gooOol07amoo`03001oogoo0=ioo`00I7oo
00@07gooOol07amoo`03001oogoo0=ioo`00I7oo00@07gooOol07amoo`800=moo`00I7oo00@07goo
Ool07amoo`03001oogoo0=ioo`00I7oo00@07gooOol07amoo`03001oogoo0=ioo`00I7oo00D07goo
Oomoo`0O01ioo`03001oogoo0=ioo`00I7oo00D07gooOomoo`0O01ioo`03001oogoo0=ioo`00I7oo
00D07gooOomoo`0O01ioo`03001oogoo0=ioo`00I7oo00D07gooOomoo`0O01ioo`800=moo`00I7oo
00D07gooOomoo`0O01ioo`03001oogoo0=ioo`00I7oo00D07gooOomoo`0O01ioo`03001oogoo0=io
o`00I7oo00D07gooOomoo`0O01ioo`03001oogoo0=ioo`00I7oo00D07gooOomoo`0O01ioo`03001o
ogoo0=ioo`00I7oo00D07gooOomoo`0O01ioo`03001oogoo0=ioo`00I7oo00D07gooOomoo`0O01io
o`03001oogoo0=ioo`00I7oo00D07gooOomoo`0O01ioo`800=moo`00I7oo00D07gooOomoo`0O01io
o`03001oogoo0=ioo`00I7oo00D07gooOomoo`0O01ioo`03001oogoo0=ioo`00I7oo00<07gooOol0
0Woo00<07gooOol06goo00<007ooOol0gWoo001TOol00`0OOomoo`02Ool00`0OOomoo`0AOol50005
Ool00`00Oomoo`3NOol006Aoo`0301moogoo009oo`0301moogoo01=oo`03001oogoo00Eoo`03001o
ogoo0=ioo`00I7oo00<07gooOol00Woo00<07gooOol04goo00<007ooOol01Goo00<007ooOol0gWoo
001TOol00`0OOomoo`02Ool00`0OOomoo`08Ool60005Ool00`00Oomoo`05Ool3003NOol006Aoo`03
01moogoo009oo`0301moogoo01=oo`03001oogoo00Eoo`03001oogoo0=ioo`00I7oo00<07gooOol0
0Woo00<07gooOol04goo00<007ooOol01Goo00<007ooOol0gWoo001TOol00`0OOomoo`02Ool00`0O
Oomoo`0AOol30007Ool00`00Oomoo`3NOol006Aoo`0301moogoo00=oo`0301moogoo019oo`03001o
ogoo00Eoo`03001oogoo0=ioo`00I7oo00<07gooOol00goo00<07gooOol06Woo00<007ooOol0gWoo
001TOol00`0OOomoo`03Ool00`0OOomoo`0JOol00`00Oomoo`3NOol006Aoo`0301moogoo00=oo`03
01moogoo01Yoo`800=moo`00I7oo00<07gooOol017oo00<07gooOol06Goo00<007ooOol0gWoo001T
Ool00`0OOomoo`04Ool00`0OOomoo`0IOol00`00Oomoo`3NOol006Aoo`0301moogoo00Aoo`0301mo
ogoo01Uoo`03001oogoo0=ioo`00I7oo00<07gooOol017oo00<07gooOol06Goo00<007ooOol0gWoo
001TOol00`0OOomoo`05Ool00`0OOomoo`0HOol00`00Oomoo`3NOol006Aoo`0301moogoo00Eoo`03
01moogoo01Qoo`03001oogoo0=ioo`00I7oo00<07gooOol01Goo00<07gooOol067oo0P00ggoo001T
Ool00`0OOomoo`05Ool00`0OOomoo`0HOol00`00Oomoo`3NOol006Aoo`0301moogoo00Ioo`0301mo
ogoo01Moo`03001oogoo0=ioo`00I7oo00<07gooOol01Woo00<07gooOol05goo00<007ooOol0gWoo
001TOol00`0OOomoo`07Ool00`0OOomoo`0FOol00`00Oomoo`3NOol000aoo`<002Ioo`D002Eoo`D0
000301moogoo00Moo`0301moogoo01Ioo`03001oogoo02Aoo`D002Aoo`D002Eoo`<002Qoo`<002Eo
o`@0011oo`002goo00D007ooOomoo`0002Eoo`05001oogooOol0000WOol01000Oomoo`0O2Woo00<0
7gooOol05Goo00<007ooOol09Woo00<007ooOol097oo00D007ooOomoo`0002Aoo`05001oogooOol0
000XOol00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000moo`03001oogoo02Aoo`03
001oogoo02Qoo`04001oogoo01l;Ool00`0OOomoo`0DOol2000WOol00`00Oomoo`0UOol00`00Oomo
o`0YOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0=Ool000=oo`H000Ioo`03001oogoo
01]oo`H000Aoo`03001oogoo01aoo`H000Eoo`04001oogoo01l<Ool00`0OOomoo`0COol00`00Oomo
o`0VOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0ROol6000YOol00`00Oomoo`0=Ool0
00eoo`8002Uoo`03001oogoo02Ioo`04001oogoo01l=Ool00`0OOomoo`0BOol00`00Oomoo`0VOol0
0`00Oomoo`0WOol00`00Oomoo`0UOol2000VOol01000Oomoo`009Woo100047oo000?Ool00`00Oomo
o`0WOol00`00Oomoo`0UOol01000Oomoo`0O3Woo00<07gooOol04Goo00<007ooOol09Woo00<007oo
Ool0:7oo00<007ooOol09Woo00<007ooOol08goo00@007ooOol002Ioo`03001oogoo015oo`002goo
00D007ooOomoo`0002Eoo`05001oogooOol0000UOol30002Ool00`0OOomoo`0=Ool201lAOol00`00
Oomoo`0TOol3000VOol01@00Oomoogoo000097oo00D007ooOomoo`0002Ioo`03001oo`0002Ioo`03
001oogoo015oo`0037oo0`009goo0`00:7oo00@007ooOol07a5oo`807`moo`03001oogoo02Ioo`03
001oogoo02Eoo`<002Ioo`<002Qoo`8002Ioo`D000moo`00I7oo00<07gooOol04Goo0`0O37oo0P00
ggoo001TOol00`0OOomoo`0DOol201l:Ool00`00Oomoo`3NOol006Aoo`0301moogoo01Ioo`L07`=o
o`03001oogoo0=ioo`00I7oo00<07gooOol07Goo1P0OgWoo001TOol00`0OOomoo`0POol00`00Oomo
o`0>01o@Ool006Aoo`0301moogoo021oo`03001oogoo00ioob807jioo`00I7oo00<07gooOol087oo
00<007ooOol0<7ooK00O@Woo000:OomJ00000`0O0000002o000a01lAOol000Yoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`0301l007oo00Moo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Yo
o`D000002Woo6@0O4Goo00<007ooOol09Woo00<007ooOol017oo00<07gooOol087oo00<007ooOol0
9Woo00<007ooOol09goo00<007ooOol09Woo00<007ooOol09Woo00<007ooOol09goo00<007ooOol0
2Woo00@007ooOomoo`4000008goo5@0O;7oo00<07gooOol087oo00<007ooOol0fWoo00<007ooOol0
0Goo000hOol;01lQOol00`0OOomoo`0POol00`00Oomoo`3KOol10001Ool1Ool004=oo`L07aYoo`03
01moogoo021oo`03001oogoo0=Uoo`04001oogoo0001Ool004Yoo`<07aMoo`0301moogoo021oo`03
001oogoo0=Uoo`D00000CGoo100O4goo00<07gooOol087oo0P00ggoo001AOol201lAOol00`0OOomo
o`0POol00`00Oomoo`3NOol005=oo`807`moo`0301moogoo021oo`03001oogoo0=ioo`00EGoo00<0
7gooOol037oo00<07gooOol087oo00<007ooOol0gWoo001FOol201l<Ool00`0OOomoo`0POol00`00
Oomoo`3NOol005Qoo`807`Yoo`0301moogoo021oo`03001oogoo0=ioo`00FWoo00<07gooOol01goo
00<07gooOol087oo00<007ooOol0gWoo001JOol00`0OOomoo`07Ool00`0OOomoo`0POol2003OOol0
05]oo`0301moogoo00Ioo`0301moogoo021oo`03001oogoo0=ioo`00G7oo00<07gooOol01Goo00<0
7gooOol087oo00<007ooOol0gWoo001MOol00`0OOomoo`04Ool00`0OOomoo`0POol00`00Oomoo`3N
Ool005eoo`0301moogoo00Aoo`0301moogoo021oo`03001oogoo0=ioo`00GWoo00<07gooOol00goo
00<07gooOol087oo00<007ooOol0gWoo001NOol00`0OOomoo`03Ool00`0OOomoo`0POol00`00Oomo
o`3NOol005ioo`0301moogoo00=oo`0301moogoo021oo`800=moo`00GWoo00<07gooOol00goo00<0
7gooOol087oo00<007ooOol0gWoo001NOol00`0OOomoo`03Ool00`0OOomoo`0POol00`00Oomoo`3N
Ool005ioo`0301moogoo00=oo`0301moogoo021oo`03001oogoo0=ioo`00Ggoo00<07gooOol00Woo
00<07gooOol087oo00<007ooOol0gWoo001OOol00`0OOomoo`02Ool00`0OOomoo`0POol00`00Oomo
o`3NOol005moo`0301moogoo009oo`0301moogoo021oo`03001oogoo0=ioo`00H7oo00D07gooOomo
o`0O029oo`800=moo`00H7oo00D07gooOomoo`0O029oo`03001oogoo0=ioo`00H7oo00D07gooOomo
o`0O029oo`03001oogoo0=ioo`00H7oo00D07gooOomoo`0O01Qoo`D000Eoo`03001oogoo0=ioo`00
H7oo00D07gooOomoo`0O01Yoo`03001oogoo00Eoo`03001oogoo0=ioo`00H7oo00D07gooOomoo`0O
01Yoo`03001oogoo00Eoo`03001oogoo0=ioo`00HGoo00@07gooOol07aYoo`03001oogoo00Eoo`<0
0=ioo`00HGoo00@07gooOol07aYoo`03001oogoo00Eoo`03001oogoo0=ioo`00HGoo00@07gooOol0
7aYoo`03001oogoo00Eoo`03001oogoo0=ioo`00HGoo00@07gooOol07aQoo`<000Moo`03001oogoo
0=ioo`00HGoo00@07gooOol07aYoo`03001oogoo00Eoo`03001oogoo0=ioo`00HGoo00@07gooOol0
7b9oo`03001oogoo0=ioo`00HGoo00@07gooOol07b9oo`03001oogoo0=ioo`00HGoo00@07gooOol0
7b9oo`800=moo`00HGoo00@07gooOol07b9oo`03001oogoo0=ioo`00HGoo00@07gooOol07b9oo`03
001oogoo0=ioo`00HGoo00@07gooOol07b9oo`03001oogoo0=ioo`00HGoo00@07gooOol07b9oo`03
001oogoo0=ioo`00HWoo00<07goo01l08Woo00<007ooOol0gWoo001ROol00`0OOol07`0ROol00`00
Oomoo`3NOol0069oo`0301moo`0O029oo`800=moo`00HWoo00<07goo01l08Woo00<007ooOol0gWoo
001ROol00`0OOol07`0ROol00`00Oomoo`3NOol0069oo`0301moo`0O029oo`03001oogoo0=ioo`00
HWoo00<07goo01l08Woo00<007ooOol0gWoo001ROol00`0OOol07`0ROol00`00Oomoo`3NOol0069o
o`0301moo`0O029oo`03001oogoo0=ioo`00HWoo00<07goo01l08Woo0P00ggoo001ROol00`0OOol0
7`0ROol00`00Oomoo`3NOol0069oo`0301moo`0O029oo`03001oogoo0=ioo`00HWoo00<07goo01l0
8Woo00<007ooOol0gWoo001ROol00`0OOol07`0ROol00`00Oomoo`3NOol0069oo`0301moo`0O029o
o`03001oogoo0=ioo`00HWoo00<07goo01l08Woo00<007ooOol0gWoo001SOol201lROol2003OOol0
06=oo`807b9oo`03001oogoo0=ioo`00Hgoo0P0O8Woo00<007ooOol0gWoo001SOol201lROol00`00
Oomoo`3NOol006=oo`807aMoo`D000Ioo`03001oogoo0=ioo`00Hgoo0P0O5goo00D007ooOomoo`00
00Ioo`03001oogoo0=ioo`00Hgoo0P0O67oo00<007ooOol01goo00<007ooOol0gWoo001SOol201lI
Ool00`00Oomoo`06Ool3003NOol006=oo`807aYoo`03001oogoo00Eoo`03001oogoo0=ioo`00Hgoo
0P0O6goo00<007ooOol017oo00<007ooOol0gWoo001SOol201lGOol01@00Oomoogoo00001Woo00<0
07ooOol0gWoo001SOol201lHOol30007Ool00`00Oomoo`3NOol006=oo`807b9oo`03001oogoo0=io
o`00Hgoo0P0O8Woo0P00ggoo001SOol201lROol00`00Oomoo`3NOol006=oo`807b9oo`03001oogoo
0=ioo`00Hgoo0P0O8Woo00<007ooOol0gWoo001SOol201lROol00`00Oomoo`3NOol006=oo`807b9o
o`03001oogoo0=ioo`00Hgoo0P0O8Woo00<007ooOol0gWoo001SOol201lROol2003OOol006=oo`80
7b9oo`03001oogoo0=ioo`00Hgoo0P0O8Woo00<007ooOol0gWoo001SOol201lROol00`00Oomoo`3N
Ool006=oo`807b9oo`03001oogoo0=ioo`00Hgoo0P0O8Woo00<007ooOol0gWoo001SOol201lROol0
0`00Oomoo`3NOol006=oo`807b9oo`800=moo`00Hgoo0P0O8Woo00<007ooOol0gWoo001SOol201lR
Ool00`00Oomoo`3NOol006=oo`807b9oo`03001oogoo0=ioo`00Hgoo0P0O8Woo00<007ooOol0gWoo
001SOol201lROol00`00Oomoo`3NOol006=oo`807b9oo`03001oogoo0=ioo`00Hgoo0P0O8Woo0P00
ggoo001SOol201lROol00`00Oomoo`3NOol006=oo`807b9oo`03001oogoo0=ioo`00Hgoo0P0O8Woo
00<007ooOol0gWoo001SOol201lHOol30007Ool00`00Oomoo`3NOol006=oo`807aMoo`05001oogoo
Ool00006Ool00`00Oomoo`3NOol006=oo`807a]oo`03001oogoo00Aoo`03001oogoo0=ioo`00Hgoo
0P0O6goo00<007ooOol017oo0`00gWoo001nOol2003XOol0081oo`03001oogoo0>Eoo`00O7oo00D0
07ooOomoo`000>Moo`00OGoo0`00j7oo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?mo
ofUoo`00R7oo0`0000Aoo`0000000=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31343 m
.04057 .31412 L
.06168 .31458 L
.08481 .31519 L
.12636 .31668 L
.14691 .31773 L
.16889 .31922 L
.17962 .32014 L
.19126 .32136 L
.20133 .32265 L
.21241 .32443 L
.22317 .32666 L
.23324 .32942 L
.24388 .33346 L
.24985 .33652 L
.25532 .34008 L
.26032 .34425 L
.26566 .35014 L
.26825 .35377 L
.27069 .35783 L
.27526 .36781 L
.2779 .37572 L
.2807 .38678 L
.28309 .39959 L
.28444 .40893 L
.28571 .41959 L
.28717 .43516 L
.28856 .45459 L
.28981 .47795 L
.29117 .51366 L
.29187 .53875 L
.29264 .57469 L
s
.29264 .57469 m
.29331 .61803 L
s
.29769 .61803 m
.2979 0 L
s
.30187 0 m
.30199 .0116 L
.30334 .08102 L
.30401 .10502 L
.30476 .1262 L
.30608 .15455 L
.30731 .17412 L
.30855 .18934 L
.30972 .20092 L
.31193 .21753 L
.3143 .23052 L
.31689 .24103 L
.31975 .24982 L
.32235 .25603 L
.32514 .2614 L
.32816 .2661 L
.33355 .27253 L
.33862 .27704 L
.34863 .28331 L
.3543 .28588 L
.3596 .28785 L
.37029 .29096 L
.38173 .29342 L
.39244 .29518 L
.40407 .29669 L
.42521 .29873 L
.44602 .30017 L
.46809 .30132 L
.50778 .30277 L
.52814 .30332 L
.55005 .30382 L
.5933 .30458 L
.63496 .30513 L
.67503 .30554 L
.71767 .30589 L
.75873 .30617 L
.80235 .30642 L
.84439 .30662 L
.88483 .30678 L
.92785 .30693 L
.96928 .30706 L
1 .30715 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
06eoo`807`Eoo`H000Ioo`03001oogoo00Aoo`<00=ioo`00KGoo0P0O3goo0P001goo00<007ooOol0
gWoo001]Ool201lAOol00`00Oomoo`04Ool00`00Oomoo`3NOol006eoo`807`eoo`05001oogooOol0
0006Ool00`00Oomoo`3NOol006eoo`807`ioo`<000Moo`03001oogoo0=ioo`00KGoo0P0O67oo00<0
07ooOol0gWoo001]Ool201lHOol00`00Oomoo`3NOol006eoo`807aQoo`800=moo`00KGoo0P0O67oo
00<007ooOol0gWoo001]Ool201lHOol00`00Oomoo`3NOol006eoo`807aQoo`03001oogoo0=ioo`00
KGoo0P0O67oo00<007ooOol0gWoo001]Ool201lHOol00`00Oomoo`3NOol006eoo`807aQoo`800=mo
o`00KGoo0P0O67oo00<007ooOol0gWoo001]Ool201lHOol00`00Oomoo`3NOol006eoo`0301moo`0O
01Moo`03001oogoo0=ioo`00KGoo00<07goo01l05goo00<007ooOol0gWoo001]Ool00`0OOol07`0G
Ool00`00Oomoo`3NOol006eoo`0301moo`0O01Moo`03001oogoo0=ioo`00KGoo00<07goo01l05goo
0P00ggoo001]Ool00`0OOol07`0GOol00`00Oomoo`3NOol006eoo`0301moo`0O01Moo`03001oogoo
0=ioo`00KGoo00<07goo01l05goo00<007ooOol0gWoo001]Ool00`0OOol07`0GOol00`00Oomoo`3N
Ool006eoo`0301moo`0O01Moo`03001oogoo0=ioo`00KGoo00<07goo01l05goo00<007ooOol0gWoo
001]Ool00`0OOol07`0GOol2003OOol006eoo`0301moo`0O01Moo`03001oogoo0=ioo`00KGoo00<0
7goo01l05goo00<007ooOol0gWoo001]Ool00`0OOol07`0GOol00`00Oomoo`3NOol006eoo`0301mo
o`0O00aoo`D000Ioo`03001oogoo0=ioo`00KGoo00<07goo01l037oo00D007ooOomoo`0000Ioo`03
001oogoo0=ioo`00KGoo00<07goo01l03Goo00<007ooOol01goo00<007ooOol0gWoo001]Ool00`0O
Ool07`04Ool60004Ool00`00Oomoo`06Ool3003NOol006eoo`0301moo`0O00moo`03001oogoo00Eo
o`03001oogoo0=ioo`00KGoo00<07goo01l047oo00<007ooOol017oo00<007ooOol0gWoo001]Ool0
0`0OOol07`0<Ool01@00Oomoogoo00001Woo00<007ooOol0gWoo001]Ool00`0OOol07`0=Ool30007
Ool00`00Oomoo`3NOol006eoo`0301moo`0O01Moo`03001oogoo0=ioo`00KGoo00<07goo01l05goo
00<007ooOol0gWoo001]Ool00`0OOol07`0GOol2003OOol006eoo`0301moo`0O01Moo`03001oogoo
0=ioo`00KGoo00<07goo01l05goo00<007ooOol0gWoo001]Ool00`0OOol07`0GOol00`00Oomoo`3N
Ool006eoo`0301moo`0O01Moo`03001oogoo0=ioo`00KGoo00<07goo01l05goo00<007ooOol0gWoo
001]Ool0100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0100OOomoo`0O5Woo0P00ggoo001]Ool0
100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0
100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0
100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0100OOomoo`0O5Woo0P00ggoo001]Ool0100OOomo
o`0O5Woo00<007ooOol0gWoo001]Ool0100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0100OOomo
o`0O5Woo00<007ooOol0gWoo001]Ool0100OOomoo`0O5Woo00<007ooOol0gWoo001]Ool0100OOomo
o`0O5Woo00<007ooOol0gWoo001]Ool01@0OOomoogoo01l05Goo00<007ooOol0gWoo001]Ool01@0O
Oomoogoo01l05Goo0P00ggoo001]Ool01@0OOomoogoo01l05Goo00<007ooOol0gWoo001]Ool01@0O
Oomoogoo01l05Goo00<007ooOol0gWoo001]Ool01@0OOomoogoo01l05Goo00<007ooOol0gWoo001]
Ool01@0OOomoogoo01l02goo1@001Goo00<007ooOol0gWoo001]Ool01@0OOomoogoo01l03Goo00<0
07ooOol01Goo00<007ooOol0gWoo001]Ool01@0OOomoogoo01l03Goo00<007ooOol01Goo00<007oo
Ool0gWoo001]Ool01@0OOomoogoo01l00Woo1P001Goo00<007ooOol01Goo0`00gWoo001]Ool00`0O
Oomoo`02Ool00`0OOomoo`0:Ool00`00Oomoo`05Ool00`00Oomoo`3NOol006eoo`0301moogoo009o
o`0301moogoo00Yoo`03001oogoo00Eoo`03001oogoo0=ioo`00KGoo00<07gooOol00Woo00<07goo
Ool027oo0`001goo00<007ooOol0gWoo001]Ool00`0OOomoo`02Ool00`0OOomoo`0:Ool00`00Oomo
o`05Ool00`00Oomoo`3NOol006eoo`0301moogoo009oo`0301moogoo019oo`03001oogoo0=ioo`00
KGoo00<07gooOol00goo00<07gooOol04Goo00<007ooOol0gWoo001]Ool00`0OOomoo`03Ool00`0O
Oomoo`0AOol2003OOol006eoo`0301moogoo00=oo`0301moogoo015oo`03001oogoo0=ioo`00KGoo
00<07gooOol00goo00<07gooOol04Goo00<007ooOol0gWoo001]Ool00`0OOomoo`03Ool00`0OOomo
o`0AOol00`00Oomoo`3NOol006eoo`0301moogoo00=oo`0301moogoo015oo`03001oogoo0=ioo`00
KGoo00<07gooOol00goo00<07gooOol04Goo00<007ooOol0gWoo001]Ool00`0OOomoo`03Ool00`0O
Oomoo`0AOol00`00Oomoo`3NOol006eoo`0301moogoo00Aoo`0301moogoo011oo`800=moo`00KGoo
00<07gooOol017oo00<07gooOol047oo00<007ooOol0gWoo001]Ool00`0OOomoo`05Ool00`0OOomo
o`0?Ool00`00Oomoo`3NOol006eoo`0301moogoo00Eoo`0301moogoo00moo`03001oogoo0=ioo`00
KGoo00<07gooOol01Woo00<07gooOol03Woo00<007ooOol0gWoo000<Ool3000VOol5000UOol50009
Ool00`0OOomoo`07Ool00`0OOomoo`0=Ool00`00Oomoo`0TOol5000TOol5000UOol3000XOol3000U
Ool4000@Ool000]oo`05001oogooOol0000UOol01@00Oomoogoo00009goo00<007ooOol02Goo00<0
7gooOol01goo00<07gooOol03Goo00<007ooOol09Woo00<007ooOol097oo00D007ooOomoo`0002Ao
o`05001oogooOol0000XOol00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000moo`03
001oogoo02Aoo`03001oogoo02Qoo`03001oogoo00Uoo`0301moogoo00Qoo`0301moogoo00aoo`80
02Moo`03001oogoo02Eoo`03001oogoo02Uoo`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo
00eoo`000goo1P001Woo00<007ooOol06goo1P0017oo00<007ooOol077oo1P001Goo00<007ooOol0
2Goo00<07gooOol02Goo00<07gooOol02goo00<007ooOol09Woo00<007ooOol09Woo00<007ooOol0
:7oo00<007ooOol08Woo1P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomoo`0VOol00`00
Oomoo`09Ool00`0OOomoo`0:Ool00`0OOomoo`0:Ool00`00Oomoo`0VOol00`00Oomoo`0WOol00`00
Oomoo`0UOol2000VOol01000Oomoo`009Woo100047oo000?Ool00`00Oomoo`0WOol00`00Oomoo`0U
Ool00`00Oomoo`09Ool00`0OOomoo`0;Ool00`0OOomoo`09Ool00`00Oomoo`0VOol00`00Oomoo`0X
Ool00`00Oomoo`0VOol00`00Oomoo`0SOol01000Oomoo`009Woo00<007ooOol04Goo000;Ool01@00
Oomoogoo00009Goo00D007ooOomoo`0002Eoo`<000]oo`0301moogoo00aoo`807`Uoo`03001oogoo
02Aoo`<002Ioo`05001oogooOol0000TOol01@00Oomoogoo00009Woo00<007oo00009Woo00<007oo
Ool04Goo000<Ool3000WOol3000XOol00`00Oomoo`09Ool00`0OOomoo`0>Ool00`0OOomoo`06Ool0
0`00Oomoo`0VOol00`00Oomoo`0UOol3000VOol3000XOol2000VOol5000?Ool006eoo`0301moogoo
00moo`D07`=oo`800=moo`00KGoo00<07gooOol057oo0`0O00<007ooOol0gWoo001]Ool00`0OOomo
o`0GOol401oMOol006eoo`0301moogoo01Moo`04001oogooOol901oDOol006eoo`0301moogoo01Mo
o`03001oogoo00Yoo`h07lIoo`00KGoo00<07gooOol05goo00<007ooOol067oo6`0OZgoo001]Ool0
0`0OOomoo`0GOol00`00Oomoo`0cOomj01laOol000Yoof<0000301l000000<L002007a5oo`002Woo
00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo
00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Goo00<07`00Ool01Woo00<007ooOol01Goo00<007ooOol01Woo
00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo
00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo
00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo
00<007ooOol02Woo1@00000:OolS01l7Ool00`00Oomoo`0VOol00`00Oomoo`0=Ool00`0OOomoo`0G
Ool00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0W
Ool00`00Oomoo`0:Ool01000Oomoogoo0@00000]OolB01l^Ool00`0OOomoo`0GOol00`00Oomoo`3J
Ool00`00Oomoo`01Ool003moo`d07b5oo`0301moogoo01Moo`03001oogoo0=]oo`40005oo`5oo`00
C7oo1`0O6Woo00<07gooOol05goo00<007ooOol0fGoo00@007ooOol0005oo`00Dgoo0`0O5goo00<0
7gooOol05goo00<007ooOol0fGoo1@00001FOol401lCOol00`0OOomoo`0GOol2003OOol005Yoo`80
7a5oo`0301moogoo01Moo`03001oogoo0=ioo`00G7oo0P0O3goo00<07gooOol05goo00<007ooOol0
gWoo001NOol00`0OOomoo`0<Ool00`0OOomoo`0GOol00`00Oomoo`3NOol005moo`0301moogoo00]o
o`0301moogoo01Moo`03001oogoo0=ioo`00H7oo0P0O2goo00<07gooOol05goo00<007ooOol0gWoo
001ROol00`0OOomoo`08Ool00`0OOomoo`0GOol00`00Oomoo`3NOol0069oo`0301moogoo00Qoo`03
01moogoo01Moo`800=moo`00Hgoo00<07gooOol01goo00<07gooOol05goo00<007ooOol0gWoo001T
Ool00`0OOomoo`06Ool00`0OOomoo`0GOol00`00Oomoo`3NOol006Eoo`0301moogoo00Eoo`0301mo
ogoo01Moo`03001oogoo0=ioo`00IGoo00<07gooOol01Goo00<07gooOol05goo00<007ooOol0gWoo
001VOol00`0OOomoo`04Ool00`0OOomoo`0GOol00`00Oomoo`3NOol006Ioo`0301moogoo00Aoo`03
01moogoo01Moo`03001oogoo0=ioo`00IWoo00<07gooOol017oo00<07gooOol05goo0P00ggoo001V
Ool00`0OOomoo`04Ool00`0OOomoo`0GOol00`00Oomoo`3NOol006Ioo`0301moogoo00Aoo`0301mo
ogoo01Moo`03001oogoo0=ioo`00Igoo00<07gooOol00goo00<07gooOol05goo00<007ooOol0gWoo
001WOol00`0OOomoo`03Ool00`0OOomoo`0GOol00`00Oomoo`3NOol006Moo`0301moogoo00=oo`03
01moogoo01Moo`03001oogoo0=ioo`00Igoo00<07gooOol00goo00<07gooOol05goo00<007ooOol0
gWoo001XOol00`0OOomoo`02Ool00`0OOomoo`0GOol2003OOol006Qoo`0301moogoo009oo`0301mo
ogoo01Moo`03001oogoo0=ioo`00J7oo00<07gooOol00Woo00<07gooOol05goo00<007ooOol0gWoo
001XOol00`0OOomoo`02Ool00`0OOomoo`0=Ool50005Ool00`00Oomoo`3NOol006Uoo`0501moogoo
Ool07`0AOol00`00Oomoo`05Ool00`00Oomoo`3NOol006Uoo`0501moogooOol07`0AOol00`00Oomo
o`05Ool00`00Oomoo`3NOol006Uoo`0501moogooOol07`0AOol00`00Oomoo`05Ool3003NOol006Uo
o`0501moogooOol07`0AOol00`00Oomoo`05Ool00`00Oomoo`3NOol006Uoo`0501moogooOol07`0A
Ool00`00Oomoo`05Ool00`00Oomoo`3NOol006Uoo`0501moogooOol07`0?Ool30007Ool00`00Oomo
o`3NOol006Uoo`0501moogooOol07`0AOol00`00Oomoo`05Ool00`00Oomoo`3NOol006Uoo`0501mo
ogooOol07`0IOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`04
01moogoo01lIOol2003OOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo
01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo
01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo
01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol2003OOol006Yoo`0401moogoo01lIOol0
0`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol0
0`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol0
0`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol2
003OOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomo
o`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomo
o`3NOol006Yoo`0401moogoo01lIOol00`00Oomoo`3NOol006Yoo`0401moogoo01lIOol00`00Oomo
o`3NOol006]oo`0301moo`0O01Uoo`800=moo`00Jgoo00<07goo01l06Goo00<007ooOol0gWoo001[
Ool00`0OOol07`0IOol00`00Oomoo`3NOol006]oo`0301moo`0O01Uoo`03001oogoo0=ioo`00Jgoo
00<07goo01l03Woo1@001Woo00<007ooOol0gWoo001[Ool00`0OOol07`0>Ool01@00Oomoogoo0000
1Woo00<007ooOol0gWoo001[Ool00`0OOol07`0?Ool00`00Oomoo`07Ool00`00Oomoo`3NOol006]o
o`0301moo`0O011oo`03001oogoo00Ioo`<00=ioo`00Jgoo00<07goo01l04Goo00<007ooOol01Goo
00<007ooOol0gWoo001[Ool00`0OOol07`0BOol00`00Oomoo`04Ool00`00Oomoo`3NOol006]oo`03
01moo`0O00ioo`05001oogooOol00006Ool00`00Oomoo`3NOol006]oo`0301moo`0O00moo`<000Mo
o`03001oogoo0=ioo`00Jgoo00<07goo01l06Goo00<007ooOol0gWoo001[Ool00`0OOol07`0IOol2
003OOol006]oo`0301moo`0O01Uoo`03001oogoo0=ioo`00Jgoo00<07goo01l06Goo00<007ooOol0
gWoo001[Ool00`0OOol07`0IOol00`00Oomoo`3NOol006]oo`0301moo`0O01Uoo`03001oogoo0=io
o`00Jgoo00<07goo01l06Goo00<007ooOol0gWoo001[Ool00`0OOol07`0IOol00`00Oomoo`3NOol0
06]oo`0301moo`0O01Uoo`800=moo`00Jgoo00<07goo01l06Goo00<007ooOol0gWoo001[Ool00`0O
Ool07`0IOol00`00Oomoo`3NOol006]oo`0301moo`0O01Uoo`03001oogoo0=ioo`00Jgoo00<07goo
01l06Goo00<007ooOol0gWoo001[Ool00`0OOol07`0IOol00`00Oomoo`3NOol006]oo`0301moo`0O
01Uoo`03001oogoo0=ioo`00Jgoo00<07goo01l06Goo0P00ggoo001[Ool00`0OOol07`0IOol00`00
Oomoo`3NOol006]oo`0301moo`0O01Uoo`03001oogoo0=ioo`00Jgoo00<07goo01l06Goo00<007oo
Ool0gWoo001[Ool00`0OOol07`0IOol00`00Oomoo`3NOol006]oo`0301moo`0O01Uoo`03001oogoo
0=ioo`00Jgoo00<07goo01l06Goo00<007ooOol0gWoo001/Ool201lIOol2003OOol006aoo`807aUo
o`03001oogoo0=ioo`00K7oo0P0O6Goo00<007ooOol0gWoo001/Ool201lIOol00`00Oomoo`3NOol0
06aoo`807`moo`<000Moo`03001oogoo0=ioo`00K7oo0P0O3Woo00D007ooOomoo`0000Ioo`03001o
ogoo0=ioo`00K7oo0P0O4Woo00<007ooOol017oo00<007ooOol0gWoo001/Ool201lBOol00`00Oomo
o`04Ool3003NOol007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo0000igoo
001mOol3003XOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028Ool30000
17oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31309 m
.04057 .31367 L
.06168 .31405 L
.08481 .31454 L
.12636 .31571 L
.14691 .31649 L
.16889 .31756 L
.19126 .31901 L
.20153 .31986 L
.21241 .32093 L
.22239 .32212 L
.23338 .32373 L
.24338 .32559 L
.25275 .32781 L
.25796 .32933 L
.26365 .33129 L
.26866 .33336 L
.27401 .33604 L
.2793 .33934 L
.28409 .34312 L
.28891 .348 L
.29346 .35409 L
.29834 .36317 L
.30112 .37017 L
.30371 .37857 L
.30644 .39035 L
.30894 .40521 L
.31031 .41602 L
.31181 .43092 L
.31323 .44938 L
.31454 .47225 L
.31565 .49839 L
.31684 .53788 L
.31797 .594 L
s
.31797 .594 m
.31827 .61803 L
s
.32152 .61803 m
.3216 0 L
s
.32689 0 m
.32758 .04645 L
.32877 .09715 L
.33008 .134 L
.33146 .16121 L
.33264 .17854 L
.33393 .19344 L
.33655 .2151 L
.33804 .2241 L
.33941 .23103 L
.34193 .24117 L
.34461 .24943 L
.34724 .2558 L
.34972 .26066 L
.35435 .26771 L
.35985 .2738 L
.3649 .278 L
.37044 .2816 L
.37629 .28458 L
.38627 .28841 L
.39695 .29137 L
.40704 .29348 L
.41622 .295 L
.4363 .29748 L
.44763 .29852 L
.45811 .29933 L
.47942 .30065 L
.49939 .30159 L
.53909 .30295 L
.56032 .3035 L
.57976 .30391 L
.62142 .30463 L
.66149 .30514 L
.70414 .30558 L
.74519 .30591 L
.78882 .3062 L
.83085 .30643 L
.8713 .30663 L
.91432 .3068 L
.95574 .30694 L
.99558 .30707 L
1 .30708 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`0400007`0001l20006Ool00`00Oomoo`04Ool3003NOol007Eoo`0301moo`0O00Ioo`8000Mo
o`03001oogoo0=ioo`00MGoo00<07goo01l027oo00<007ooOol017oo00<007ooOol0gWoo001eOol0
0`0OOol07`04Ool01@00Oomoogoo00001Woo00<007ooOol0gWoo001eOol00`0OOol07`05Ool30007
Ool00`00Oomoo`3NOol007Eoo`0301moo`0O00moo`03001oogoo0=ioo`00MGoo00<07goo01l03goo
00<007ooOol0gWoo001eOol00`0OOol07`0?Ool2003OOol007Eoo`0301moo`0O00moo`03001oogoo
0=ioo`00MGoo00<07goo01l03goo00<007ooOol0gWoo001eOol00`0OOol07`0?Ool00`00Oomoo`3N
Ool007Eoo`0301moo`0O00moo`03001oogoo0=ioo`00MGoo00<07goo01l03goo00<007ooOol0gWoo
001eOol00`0OOol07`0?Ool2003OOol007Eoo`0301moo`0O00moo`03001oogoo0=ioo`00MGoo00<0
7goo01l03goo00<007ooOol0gWoo001eOol00`0OOol07`0?Ool00`00Oomoo`3NOol007Eoo`0301mo
o`0O00moo`03001oogoo0=ioo`00MGoo00<07goo01l03goo00<007ooOol0gWoo001eOol00`0OOol0
7`0?Ool00`00Oomoo`3NOol007Eoo`0301moo`0O00moo`800=moo`00MGoo00<07goo01l03goo00<0
07ooOol0gWoo001eOol00`0OOol07`0?Ool00`00Oomoo`3NOol007Eoo`0301moo`0O00moo`03001o
ogoo0=ioo`00MGoo00<07goo01l03goo00<007ooOol0gWoo001eOol00`0OOol07`0?Ool00`00Oomo
o`3NOol007Eoo`0301moo`0O00moo`03001oogoo0=ioo`00MGoo00<07goo01l03goo0P00ggoo001e
Ool00`0OOol07`0?Ool00`00Oomoo`3NOol007Eoo`0301moo`0O00moo`03001oogoo0=ioo`00MGoo
00<07goo01l03goo00<007ooOol0gWoo001eOol00`0OOol07`04Ool50006Ool00`00Oomoo`3NOol0
07Eoo`0301moo`0O00Aoo`05001oogooOol00006Ool00`00Oomoo`3NOol007Eoo`0301moo`0O00Eo
o`03001oogoo00Moo`03001oogoo0=ioo`00M7oo00@0000O00007`8000Aoo`03001oogoo00Ioo`<0
0=ioo`00MGoo00<07goo01l01goo00<007ooOol01Goo00<007ooOol0gWoo001eOol00`0OOol07`08
Ool00`00Oomoo`04Ool00`00Oomoo`3NOol007Eoo`0301moo`0O00Aoo`05001oogooOol00006Ool0
0`00Oomoo`3NOol007Eoo`0401moogoo01l4Ool30007Ool00`00Oomoo`3NOol007Eoo`0401moogoo
01l>Ool00`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool00`00Oomoo`3NOol007Eoo`0401moogoo
01l>Ool2003OOol007Eoo`0401moogoo01l>Ool00`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool0
0`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool00`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool0
0`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool00`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool0
0`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool2003OOol007Eoo`0401moogoo01l>Ool00`00Oomo
o`3NOol007Eoo`0401moogoo01l>Ool00`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool00`00Oomo
o`3NOol007Eoo`0401moogoo01l>Ool00`00Oomoo`3NOol007Eoo`0401moogoo01l>Ool00`00Oomo
o`3NOol007Eoo`0401moogoo01l>Ool2003OOol007Eoo`0401moogoo01l>Ool00`00Oomoo`3NOol0
07Eoo`0501moogooOol07`0=Ool00`00Oomoo`3NOol007Eoo`0501moogooOol07`0=Ool00`00Oomo
o`3NOol007Eoo`0501moogooOol07`0=Ool00`00Oomoo`3NOol007Eoo`0501moogooOol07`0=Ool0
0`00Oomoo`3NOol007Eoo`0501moogooOol07`0=Ool00`00Oomoo`3NOol007Eoo`0501moogooOol0
7`0=Ool2003OOol007Eoo`0501moogooOol07`0=Ool00`00Oomoo`3NOol007Eoo`0501moogooOol0
7`0=Ool00`00Oomoo`3NOol007Eoo`0501moogooOol07`0=Ool00`00Oomoo`3NOol007Eoo`0501mo
ogooOol07`03Ool50005Ool00`00Oomoo`3NOol007Eoo`0501moogooOol07`05Ool00`00Oomoo`05
Ool00`00Oomoo`3NOol007Eoo`0501moogooOol07`05Ool00`00Oomoo`05Ool00`00Oomoo`3NOol0
07Aoo`0300007`0000<0000301moogoo009oo`03001oogoo00Eoo`<00=ioo`00MGoo00<07gooOol0
0Woo00<07gooOol00Woo00<007ooOol01Goo00<007ooOol0gWoo001eOol00`0OOomoo`02Ool00`0O
Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`3NOol007Eoo`0301moogoo009oo`0301moogoo00<0
00Moo`03001oogoo0=ioo`00MGoo00<07gooOol00Woo00<07gooOol00Woo00<007ooOol01Goo00<0
07ooOol0gWoo001eOol00`0OOomoo`02Ool00`0OOomoo`0:Ool00`00Oomoo`3NOol007Eoo`0301mo
ogoo009oo`0301moogoo00Yoo`03001oogoo0=ioo`00MGoo00<07gooOol00goo00<07gooOol02Goo
0P00ggoo001eOol00`0OOomoo`03Ool00`0OOomoo`09Ool00`00Oomoo`3NOol007Eoo`0301moogoo
00=oo`0301moogoo00Uoo`03001oogoo0=ioo`00MGoo00<07gooOol017oo00<07gooOol027oo00<0
07ooOol0gWoo001eOol00`0OOomoo`04Ool00`0OOomoo`08Ool00`00Oomoo`3NOol007Eoo`0301mo
ogoo00Aoo`0301moogoo00Qoo`03001oogoo0=ioo`00MGoo00<07gooOol01Goo00<07gooOol01goo
00<007ooOol0gWoo001eOol00`0OOomoo`05Ool00`0OOomoo`07Ool2003OOol007Eoo`0301moogoo
00Eoo`0301moogoo00Moo`03001oogoo0=ioo`00MGoo00<07gooOol01Goo00<07gooOol01goo00<0
07ooOol0gWoo001eOol00`0OOomoo`05Ool00`0OOomoo`07Ool00`00Oomoo`3NOol007Eoo`0301mo
ogoo00Ioo`0301moogoo00Ioo`03001oogoo0=ioo`0037oo0`009Woo1@009Goo1@004Goo00<07goo
Ool01goo00<07gooOol01Goo00<007ooOol097oo1@0097oo1@009Goo0`00:7oo0`009Goo100047oo
000;Ool01@00Oomoogoo00009Goo00D007ooOomoo`0002Moo`03001oogoo015oo`0301moogoo00Mo
o`0301moogoo00Eoo`03001oogoo02Ioo`03001oogoo02Aoo`05001oogooOol0000TOol01@00Oomo
ogoo0000:7oo00<007ooOol08goo00<007ooOol00Woo00<007ooOol03Goo000?Ool00`00Oomoo`0T
Ool00`00Oomoo`0XOol00`00Oomoo`0AOol00`0OOomoo`08Ool00`0OOomoo`04Ool2000WOol00`00
Oomoo`0UOol00`00Oomoo`0YOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0=Ool000=o
o`H000Ioo`03001oogoo01]oo`H000Aoo`03001oogoo01aoo`H000Eoo`03001oogoo015oo`0301mo
ogoo00Uoo`0301moogoo00=oo`03001oogoo02Ioo`03001oogoo02Ioo`03001oogoo02Qoo`03001o
ogoo029oo`H002Uoo`03001oogoo00eoo`003Goo0P00:Goo00<007ooOol09Woo00<007ooOol04Goo
00<07gooOol02Woo00<07gooOol00Woo00<007ooOol09Woo00<007ooOol09goo00<007ooOol09Goo
0P009Woo00@007ooOol002Ioo`@0011oo`003goo00<007ooOol09goo00<007ooOol09Goo00<007oo
Ool04Goo00<07gooOol02goo00D07gooOomoo`0002Qoo`03001oogoo02Qoo`03001oogoo02Ioo`03
001oogoo02=oo`04001oogoo000VOol00`00Oomoo`0AOol000]oo`05001oogooOol0000UOol01@00
Oomoogoo00009Goo0`004goo00<07gooOol037oo0P0O00=oo`00Ool09Goo0`009Woo00D007ooOomo
o`0002Aoo`05001oogooOol0000VOol00`00Ool0000VOol00`00Oomoo`0AOol000aoo`<002Moo`<0
02Qoo`03001oogoo015oo`0301moogoo00ioo`<07bMoo`03001oogoo02Eoo`<002Ioo`<002Qoo`80
02Ioo`D000moo`00MGoo00<07gooOol03goo0P000`0Og7oo001eOol00`0OOomoo`0?Ool00`00Oomo
o`02Ool401oHOol007Eoo`0301moogoo00moo`03001oogoo00Ioo`<07mEoo`00MGoo00<07gooOol0
3goo00<007ooOol02Goo2P0Obgoo001eOol00`0OOomoo`0?Ool00`00Oomoo`0COol@01nkOol007Eo
o`0301moogoo00moo`03001oogoo02=ooa/07j1oo`00MGoo00<07gooOol03goo00<007ooOol0?Woo
N@0O9goo000:Oom[00000`0O00000039000F01lAOol000Yoo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Aoo`0301l007oo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D000002Woo;P0O
9Goo00<007ooOol05Goo00<07gooOol03goo00<007ooOol09Woo00<007ooOol09goo00<007ooOol0
9Woo00<007ooOol09Woo00<007ooOol09goo00<007ooOol02Woo00@007ooOomoo`400000>7oo3P0O
;goo00<07gooOol03goo00<007ooOol0fWoo00<007ooOol00Goo0016Ool=01lROol00`0OOomoo`0?
Ool00`00Oomoo`3KOol10001Ool1Ool005=oo`L07a]oo`0301moogoo00moo`03001oogoo0=Uoo`04
001oogoo0001Ool005Yoo`D07aIoo`0301moogoo00moo`03001oogoo0=Uoo`D00000Ggoo0P0O57oo
00<07gooOol03goo0P00ggoo001QOol301lAOol00`0OOomoo`0?Ool00`00Oomoo`3NOol006Aoo`80
7`moo`0301moogoo00moo`03001oogoo0=ioo`00IWoo0P0O3Goo00<07gooOol03goo00<007ooOol0
gWoo001XOol00`0OOomoo`0:Ool00`0OOomoo`0?Ool00`00Oomoo`3NOol006Uoo`0301moogoo00Uo
o`0301moogoo00moo`03001oogoo0=ioo`00JWoo00<07gooOol027oo00<07gooOol03goo00<007oo
Ool0gWoo001[Ool00`0OOomoo`07Ool00`0OOomoo`0?Ool2003OOol006aoo`0301moogoo00Ioo`03
01moogoo00moo`03001oogoo0=ioo`00K7oo00<07gooOol01Woo00<07gooOol03goo00<007ooOol0
gWoo001]Ool00`0OOomoo`05Ool00`0OOomoo`0?Ool00`00Oomoo`3NOol006eoo`0301moogoo00Eo
o`0301moogoo00moo`03001oogoo0=ioo`00KGoo00<07gooOol01Goo00<07gooOol03goo00<007oo
Ool0gWoo001^Ool00`0OOomoo`04Ool00`0OOomoo`0?Ool00`00Oomoo`3NOol006ioo`0301moogoo
00Aoo`0301moogoo00moo`800=moo`00Kgoo00<07gooOol00goo00<07gooOol03goo00<007ooOol0
gWoo001_Ool00`0OOomoo`03Ool00`0OOomoo`0?Ool00`00Oomoo`3NOol006moo`0301moogoo00=o
o`0301moogoo00moo`03001oogoo0=ioo`00L7oo00<07gooOol00Woo00<07gooOol03goo00<007oo
Ool0gWoo001`Ool00`0OOomoo`02Ool00`0OOomoo`0?Ool00`00Oomoo`3NOol0071oo`0301moogoo
009oo`0301moogoo00moo`03001oogoo0=ioo`00L7oo00<07gooOol00Woo00<07gooOol03goo0P00
ggoo001`Ool00`0OOomoo`02Ool00`0OOomoo`0?Ool00`00Oomoo`3NOol0075oo`0501moogooOol0
7`0AOol00`00Oomoo`3NOol0075oo`0501moogooOol07`07Ool50005Ool00`00Oomoo`3NOol0075o
o`0501moogooOol07`09Ool00`00Oomoo`05Ool00`00Oomoo`3NOol0075oo`0501moogooOol07`09
Ool00`00Oomoo`05Ool00`00Oomoo`3NOol0075oo`0501moogooOol07`09Ool00`00Oomoo`05Ool3
003NOol0075oo`0501moogooOol07`09Ool00`00Oomoo`05Ool00`00Oomoo`3NOol0075oo`0501mo
ogooOol07`09Ool00`00Oomoo`05Ool00`00Oomoo`3NOol0075oo`0501moogooOol07`07Ool30007
Ool00`00Oomoo`3NOol0075oo`0501moogooOol07`09Ool00`00Oomoo`05Ool00`00Oomoo`3NOol0
079oo`0401moogoo01lAOol00`00Oomoo`3NOol0079oo`0401moogoo01lAOol00`00Oomoo`3NOol0
079oo`0401moogoo01lAOol2003OOol0079oo`0401moogoo01lAOol00`00Oomoo`3NOol0079oo`04
01moogoo01lAOol00`00Oomoo`3NOol0079oo`0401moogoo01lAOol00`00Oomoo`3NOol0079oo`04
01moogoo01lAOol00`00Oomoo`3NOol0079oo`0401moogoo01lAOol00`00Oomoo`3NOol0079oo`04
01moogoo01lAOol00`00Oomoo`3NOol0079oo`0401moogoo01lAOol2003OOol0079oo`0401moogoo
01lAOol00`00Oomoo`3NOol0079oo`0401moogoo01lAOol00`00Oomoo`3NOol007=oo`0301moo`0O
015oo`03001oogoo0=ioo`00Lgoo00<07goo01l04Goo00<007ooOol0gWoo001cOol00`0OOol07`0A
Ool00`00Oomoo`3NOol007=oo`0301moo`0O015oo`03001oogoo0=ioo`00Lgoo00<07goo01l04Goo
0P00ggoo001cOol00`0OOol07`0AOol00`00Oomoo`3NOol007=oo`0301moo`0O015oo`03001oogoo
0=ioo`00Lgoo00<07goo01l04Goo00<007ooOol0gWoo001cOol00`0OOol07`0AOol00`00Oomoo`3N
Ool007=oo`0301moo`0O015oo`03001oogoo0=ioo`00Lgoo00<07goo01l04Goo00<007ooOol0gWoo
001cOol00`0OOol07`0AOol2003OOol007=oo`0301moo`0O015oo`03001oogoo0=ioo`00Lgoo00<0
7goo01l04Goo00<007ooOol0gWoo001cOol00`0OOol07`0AOol00`00Oomoo`3NOol007=oo`0301mo
o`0O00Ioo`D000Ioo`03001oogoo0=ioo`00Lgoo00<07goo01l01Woo00D007ooOomoo`0000Ioo`03
001oogoo0=ioo`00Lgoo00<07goo01l01goo00<007ooOol01goo00<007ooOol0gWoo001cOol00`0O
Ool07`08Ool00`00Oomoo`06Ool3003NOol007=oo`0301moo`0O00Uoo`03001oogoo00Eoo`03001o
ogoo0=ioo`00Lgoo00<07goo01l02Woo00<007ooOol017oo00<007ooOol0gWoo001cOol00`0OOol0
7`06Ool01@00Oomoogoo00001Woo00<007ooOol0gWoo001cOol00`0OOol07`07Ool30007Ool00`00
Oomoo`3NOol007=oo`0301moo`0O015oo`03001oogoo0=ioo`00Lgoo00<07goo01l04Goo0P00ggoo
001cOol00`0OOol07`0AOol00`00Oomoo`3NOol007=oo`0301moo`0O015oo`03001oogoo0=ioo`00
Lgoo00<07goo01l04Goo00<007ooOol0gWoo001cOol00`0OOol07`0AOol00`00Oomoo`3NOol007=o
o`0301moo`0O015oo`03001oogoo0=ioo`00Lgoo00<07goo01l04Goo00<007ooOol0gWoo001cOol0
0`0OOol07`0AOol2003OOol007=oo`0301moo`0O015oo`03001oogoo0=ioo`00Lgoo00<07goo01l0
4Goo00<007ooOol0gWoo001cOol00`0OOol07`0AOol00`00Oomoo`3NOol007Aoo`807a5oo`03001o
ogoo0=ioo`00M7oo0P0O4Goo00<007ooOol0gWoo001dOol201lAOol00`00Oomoo`3NOol007Aoo`80
7a5oo`800=moo`00M7oo0P0O4Goo00<007ooOol0gWoo001dOol201lAOol00`00Oomoo`3NOol007Ao
o`807a5oo`03001oogoo0=ioo`00M7oo0P0O4Goo00<007ooOol0gWoo001dOol201lAOol00`00Oomo
o`3NOol007Aoo`807a5oo`03001oogoo0=ioo`00M7oo0P0O4Goo0P00ggoo001dOol201lAOol00`00
Oomoo`3NOol007Aoo`807a5oo`03001oogoo0=ioo`00M7oo0P0O4Goo00<007ooOol0gWoo001dOol2
01l7Ool30007Ool00`00Oomoo`3NOol007Aoo`807`Ioo`05001oogooOol00006Ool00`00Oomoo`3N
Ool007Aoo`807`Yoo`03001oogoo00Aoo`03001oogoo0=ioo`00M7oo0P0O2Woo00<007ooOol017oo
0`00gWoo001nOol2003XOol0081oo`03001oogoo0>Eoo`00O7oo00D007ooOomoo`000>Moo`00OGoo
0`00j7oo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00R7oo0`0000Aoo`00
00000=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31279 m
.04057 .31329 L
.08481 .31401 L
.10632 .31446 L
.12636 .31495 L
.16632 .31626 L
.18776 .31723 L
.20726 .31837 L
.22737 .31994 L
.23871 .32107 L
.24919 .32236 L
.25866 .32378 L
.26885 .32569 L
.28003 .32845 L
.29051 .33201 L
.29601 .33447 L
.30112 .33727 L
.30672 .34114 L
.3127 .34664 L
.31543 .34985 L
.31839 .35399 L
.321 .3584 L
.32376 .36412 L
.32625 .37056 L
.32898 .3796 L
.33147 .3905 L
.33379 .40421 L
.33512 .41432 L
.33652 .42772 L
.33772 .44217 L
.33905 .46286 L
.34047 .49356 L
.34126 .51688 L
.342 .54413 L
s
.342 .54413 m
.34333 .61803 L
s
.34782 .61803 m
.34787 0 L
s
.35192 0 m
.35276 .05556 L
.3539 .10144 L
.35516 .13591 L
.35646 .16126 L
.3577 .17929 L
.36001 .20347 L
.36131 .21342 L
.36251 .2211 L
.36523 .23465 L
.36762 .24353 L
.36979 .24992 L
.37465 .26052 L
.37709 .26455 L
.37978 .26826 L
.3852 .27413 L
.39022 .27823 L
.39489 .28128 L
.40546 .28634 L
.41138 .28844 L
.41677 .29005 L
.42651 .29239 L
.43685 .29431 L
.44819 .29597 L
.45866 .2972 L
.47915 .29904 L
.49836 .30031 L
.51959 .30139 L
.53903 .30216 L
.56063 .30286 L
.58069 .30339 L
.62076 .30421 L
.66181 .30484 L
.70544 .30535 L
.74748 .30573 L
.78792 .30604 L
.83094 .3063 L
.87237 .30652 L
.9122 .30669 L
.95462 .30685 L
.99544 .30699 L
1 .30701 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Aoo`807`03001oogoo00Aoo`<00=ioo`00OWoo0P0O1goo00<007ooOol0gWoo001nOol2
01l00`00Oomoo`04Ool00`00Oomoo`3NOol007aoo`05001oo`0O01l00006Ool00`00Oomoo`3NOol0
07eoo`0300007`0O00Moo`03001oogoo0=ioo`00OWoo0P0O1goo00<007ooOol0gWoo001nOol201l7
Ool00`00Oomoo`3NOol007ioo`807`Moo`800=moo`00OWoo0P0O1goo00<007ooOol0gWoo001nOol2
01l7Ool00`00Oomoo`3NOol007ioo`807`Moo`03001oogoo0=ioo`00OWoo0P0O1goo00<007ooOol0
gWoo001nOol201l7Ool00`00Oomoo`3NOol007ioo`807`Moo`800=moo`00OWoo0P0O1goo00<007oo
Ool0gWoo001nOol201l7Ool00`00Oomoo`3NOol007ioo`807`Moo`03001oogoo0=ioo`00OWoo0P0O
1goo00<007ooOol0gWoo001nOol201l7Ool00`00Oomoo`3NOol007ioo`807`Moo`03001oogoo0=io
o`00OWoo0P0O1goo0P00ggoo001nOol201l7Ool00`00Oomoo`3NOol007ioo`807`Moo`03001oogoo
0=ioo`00OWoo0P0O1goo00<007ooOol0gWoo001nOol201l7Ool00`00Oomoo`3NOol007ioo`807`Mo
o`03001oogoo0=ioo`00OWoo00<07goo01l01Woo00<007ooOol0gWoo001nOol00`0OOol07`06Ool2
003OOol007ioo`0301moo`0O00Ioo`03001oogoo0=ioo`00OWoo00<07goo01l01Woo00<007ooOol0
gWoo001nOol00`0OOol07`06Ool00`00Oomoo`3NOol007aoo`80000301l0000O00Ioo`03001oogoo
0=ioo`00O7oo00D007oo01moo`0O00Ioo`03001oogoo0=ioo`00OGoo00@0000OOol07`Ioo`03001o
ogoo0=ioo`00M7oo1P0017oo00<07goo01l01Woo0`00gWoo001nOol00`0O00007`06Ool00`00Oomo
o`3NOol007ioo`0301moo`0O00Ioo`03001oogoo0=ioo`00O7oo00D007oo01moo`0O00Ioo`03001o
ogoo0=ioo`00OGoo00@0000O00007`Ioo`03001oogoo0=ioo`00OWoo00<07goo01l01Woo00<007oo
Ool0gWoo001nOol00`0OOol07`06Ool00`00Oomoo`3NOol007ioo`0301moo`0O00Ioo`800=moo`00
OWoo00<07goo01l01Woo00<007ooOol0gWoo001nOol00`0OOol07`06Ool00`00Oomoo`3NOol007io
o`0301moo`0O00Ioo`03001oogoo0=ioo`00OWoo00<07goo01l01Woo00<007ooOol0gWoo001nOol0
0`0OOol07`06Ool00`00Oomoo`3NOol007ioo`0301moo`0O00Ioo`03001oogoo0=ioo`00OWoo00<0
7goo01l01Woo0P00ggoo001nOol0100OOomoo`0O1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O
1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O
1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O
1Goo0P00ggoo001nOol0100OOomoo`0O1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O1Goo00<0
07ooOol0gWoo001nOol0100OOomoo`0O1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O1Goo00<0
07ooOol0gWoo001nOol0100OOomoo`0O1Goo00<007ooOol0gWoo001nOol0100OOomoo`0O1Goo00<0
07ooOol0gWoo001nOol0100OOomoo`0O1Goo0P00ggoo001nOol0100OOomoo`0O1Goo00<007ooOol0
gWoo001nOol01@0OOomoogoo01l017oo00<007ooOol0gWoo001nOol01@0OOomoogoo01l017oo00<0
07ooOol0gWoo001mOol00`0001l0000200000`0OOomoo`02Ool00`00Oomoo`3NOol007ioo`0501l0
07ooOol07`04Ool00`00Oomoo`3NOol007ioo`0501l007ooOol07`04Ool00`00Oomoo`3NOol007Ao
o`H000Aoo`0501l007ooOol07`04Ool3003NOol007ioo`0501l007ooOol07`04Ool00`00Oomoo`3N
Ool007ioo`0501l007ooOol07`04Ool00`00Oomoo`3NOol007eoo`0300007`00009oo`0301moogoo
009oo`03001oogoo0=ioo`00OWoo00<07`00Ool00Woo00D07gooOomoo`000>1oo`00OWoo00<07goo
Ool00Woo00D07gooOomoo`000>1oo`00OWoo00<07gooOol00Woo00D07gooOomoo`000>1oo`00OWoo
00<07gooOol00Woo00@07gooOomoo`800=moo`00OWoo00<07gooOol00Woo00D07gooOomoo`000>1o
o`00OWoo00<07gooOol00Woo00D07gooOomoo`000>1oo`00OWoo00<07gooOol00Woo00D07gooOomo
o`000>1oo`00OWoo00<07gooOol00Woo00D07gooOomoo`000>1oo`00OWoo00<07gooOol00goo00@0
7gooOol00>1oo`00OWoo00<07gooOol00goo00@07gooOol00>1oo`00OWoo00<07gooOol017oo00@0
7goo00000=moo`00OWoo00<07gooOol017oo00<07goo0000h7oo001nOol00`0OOomoo`05Ool00`0O
001oo`3OOol007ioo`0301moogoo00Eoo`0301l007oo0=moo`00OWoo00<07gooOol01Woo00<07goo
Ool0gWoo000<Ool3000VOol5000UOol5000JOol00`0OOomoo`06Ool00`0OOomoo`0TOol5000TOol5
000UOol3000XOol3000UOol4000@Ool000]oo`05001oogooOol0000UOol01@00Oomoogoo00009goo
00<007ooOol06Woo00<07gooOol01Woo00<0000OOol09Woo00<007ooOol097oo00D007ooOomoo`00
02Aoo`05001oogooOol0000XOol00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000mo
o`03001oogoo02Aoo`03001oogoo02Qoo`03001oogoo01Yoo`0301moogoo00Ioo`0300007goo02Io
o`03001oogoo02Eoo`03001oogoo02Uoo`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo00eo
o`000goo1P001Woo00<007ooOol06goo1P0017oo00<007ooOol077oo1P001Goo00<007ooOol06Woo
00<07gooOol01Woo00<007oo01l09Woo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol08Woo
1P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomoo`0VOol00`00Oomoo`0JOol00`0OOomo
o`06Ool01000Oomoo`0O9Goo00<007ooOol09goo00<007ooOol09Goo0P009Woo00@007ooOol002Io
o`@0011oo`003goo00<007ooOol09goo00<007ooOol09Goo00<007ooOol06Woo00<07gooOol01Woo
00@007ooOomoo`807b=oo`03001oogoo02Qoo`03001oogoo02Ioo`03001oogoo02=oo`04001oogoo
000VOol00`00Oomoo`0AOol000]oo`05001oogooOol0000UOol01@00Oomoogoo00009Goo0`0077oo
00<07gooOol01Woo00<007ooOol00goo00<07gooOol07Woo0`009Woo00D007ooOomoo`0002Aoo`05
001oogooOol0000VOol00`00Ool0000VOol00`00Oomoo`0AOol000aoo`<002Moo`<002Qoo`03001o
ogoo01Yoo`0301moogoo00Ioo`03001oogoo00Aoo`807b1oo`03001oogoo02Eoo`<002Ioo`<002Qo
o`8002Ioo`D000moo`00OWoo00<07gooOol01Woo0P001goo100Oe7oo001nOol00`0OOomoo`06Ool0
0`00Oomoo`0:Ool301oAOol007ioo`0301moogoo00Ioo`03001oogoo00eoo`H07l]oo`00OWoo00<0
7gooOol01Woo00<007ooOol04goo2@0O`Woo001nOol00`0OOomoo`06Ool00`00Oomoo`0LOol>01nd
Ool007ioo`0301moogoo00Ioo`03001oogoo02Yooah07iIoo`00OWoo00<07gooOol01Woo00<007oo
Ool0B7ooKP0O:7oo000:Oomd00000`0O0000002o000G01lAOol000Yoo`L07`9oo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`0301moogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D000002Woo00<0
07ooOol017oo:P0O8Woo00<007ooOol07Woo00<07gooOol01Woo00<007ooOol09Woo00<007ooOol0
9goo00<007ooOol09Woo00<007ooOol09Woo00<007ooOol09goo00<007ooOol02Woo00@007ooOomo
o`400000>goo600O:goo00<07gooOol01Woo00<007ooOol0fWoo00<007ooOol00Goo001COol801lS
Ool00`0OOomoo`06Ool00`00Oomoo`3KOol10001Ool1Ool005]oo`L07aaoo`0301moogoo00Ioo`03
001oogoo0=Uoo`04001oogoo0001Ool0069oo`<07aUoo`0301moogoo00Ioo`03001oogoo0=Uoo`D0
0000IGoo100O5Goo00<07gooOol01Woo0P00ggoo001YOol301lBOol00`0OOomoo`06Ool00`00Oomo
o`3NOol006aoo`0301moogoo00moo`0301moogoo00Ioo`03001oogoo0=ioo`00KGoo0P0O3goo00<0
7gooOol01Woo00<007ooOol0gWoo001_Ool201l=Ool00`0OOomoo`06Ool00`00Oomoo`3NOol0075o
o`0301moogoo00Yoo`0301moogoo00Ioo`03001oogoo0=ioo`00LWoo00<07gooOol02Goo00<07goo
Ool01Woo00<007ooOol0gWoo001cOol00`0OOomoo`08Ool00`0OOomoo`06Ool2003OOol007Aoo`03
01moogoo00Moo`0301moogoo00Ioo`03001oogoo0=ioo`00MGoo00<07gooOol01Woo00<07gooOol0
1Woo00<007ooOol0gWoo001eOol00`0OOomoo`06Ool00`0OOomoo`06Ool00`00Oomoo`3NOol007Io
o`0301moogoo00Eoo`0301moogoo00Ioo`03001oogoo0=ioo`00MWoo00<07gooOol01Goo00<07goo
Ool01Woo00<007ooOol0gWoo001fOol00`0OOomoo`05Ool00`0OOomoo`06Ool00`00Oomoo`3NOol0
07Ioo`0301moogoo00Eoo`0301moogoo00Ioo`800=moo`00MWoo00<07gooOol01Goo00<07gooOol0
1Woo00<007ooOol0gWoo001gOol00`0OOomoo`04Ool00`0OOomoo`06Ool00`00Oomoo`3NOol007Mo
o`0301moogoo00Aoo`0301moogoo00Ioo`03001oogoo0=ioo`00Mgoo00<07gooOol017oo00<07goo
Ool01Woo00<007ooOol0gWoo001hOol00`0OOomoo`03Ool00`0OOomoo`06Ool00`00Oomoo`3NOol0
07Qoo`0301moogoo00=oo`0301moogoo00Ioo`03001oogoo0=ioo`00N7oo00<07gooOol00goo00<0
7gooOol01Woo0P00ggoo001hOol00`0OOomoo`03Ool00`0OOomoo`06Ool00`00Oomoo`3NOol007Uo
o`0301moogoo009oo`0301moogoo00Ioo`03001oogoo0=ioo`00NGoo00H07gooOomoo`0001l30005
Ool00`00Oomoo`3NOol007Uoo`0301moogoo009oo`0301l007oo00Ioo`03001oogoo0=ioo`00NGoo
00<07gooOol00Woo00<07`00Ool01Woo00<007ooOol0gWoo001iOol00`0OOomoo`02Ool00`0O001o
o`06Ool3003NOol007Uoo`0301moogoo009oo`0301l007oo00Ioo`03001oogoo0=ioo`00NGoo00<0
7gooOol00Woo00<07`00Ool01Woo00<007ooOol0gWoo001iOol01`0OOomoogoo00007`0000Moo`03
001oogoo0=ioo`00NWoo00H07gooOomoo`0O0007Ool00`00Oomoo`3NOol007Yoo`0501moogooOol0
7`08Ool00`00Oomoo`3NOol007Yoo`0501moogooOol07`08Ool00`00Oomoo`3NOol007Yoo`0501mo
ogooOol07`08Ool2003OOol007Yoo`0501moogooOol07`08Ool00`00Oomoo`3NOol007Yoo`0501mo
ogooOol07`08Ool00`00Oomoo`3NOol007Yoo`0501moogooOol07`08Ool00`00Oomoo`3NOol007Yo
o`0501moogooOol07`08Ool00`00Oomoo`3NOol007Yoo`0501moogooOol07`08Ool00`00Oomoo`3N
Ool007Yoo`0501moogooOol07`08Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool2003OOol0
07]oo`0401moogoo01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool00`00Oomoo`3NOol0
07]oo`0401moogoo01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool00`00Oomoo`3NOol0
07]oo`0401moogoo01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool00`00Oomoo`3NOol0
07]oo`0401moogoo01l8Ool2003OOol007]oo`0401moogoo01l8Ool00`00Oomoo`3NOol007]oo`04
01moogoo01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool00`00Oomoo`3NOol007]oo`04
01moogoo01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool00`00Oomoo`3NOol007]oo`04
01moogoo01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool2003OOol007]oo`0401moogoo
01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo01l8Ool00`00Oomoo`3NOol007]oo`0401moogoo
01l8Ool00`00Oomoo`3NOol007]oo`0401l0000001l20006Ool00`00Oomoo`3NOol007]oo`0601l0
07oo01moo`001Woo00<007ooOol0gWoo001kOol0100OOol0000O27oo00<007ooOol0gWoo001kOol0
100OOomoo`0O27oo0`00gWoo001kOol01@0OOomoo`0O00001goo00<007ooOol0gWoo001kOol01P0O
Oomoo`0OOol000Ioo`03001oogoo0=ioo`00Ngoo00H07`00Ool07goo0006Ool00`00Oomoo`3NOol0
07]oo`0501moo`0001l00007Ool00`00Oomoo`3NOol007aoo`0301moo`0O00Qoo`03001oogoo0=io
o`00O7oo00<07goo01l027oo0P00ggoo001lOol00`0OOol07`08Ool00`00Oomoo`3NOol007aoo`03
01moo`0O00Qoo`03001oogoo0=ioo`00O7oo00<07goo01l027oo00<007ooOol0gWoo001lOol00`0O
Ool07`08Ool00`00Oomoo`3NOol007aoo`0301moo`0O00Qoo`03001oogoo0=ioo`00O7oo00<07goo
01l027oo00<007ooOol0gWoo001lOol00`0OOol07`08Ool2003OOol007aoo`0301moo`0O00Qoo`03
001oogoo0=ioo`00O7oo00<07goo01l027oo00<007ooOol0gWoo001lOol00`0OOol07`08Ool00`00
Oomoo`3NOol007aoo`0301moo`0O00Qoo`03001oogoo0=ioo`00O7oo00<07goo01l027oo00<007oo
Ool0gWoo001lOol00`0OOol07`08Ool00`00Oomoo`3NOol007aoo`0301moo`0O00Qoo`800=moo`00
O7oo00<07goo01l027oo00<007ooOol0gWoo001lOol00`0OOol07`08Ool00`00Oomoo`3NOol007ao
o`0301moo`0O00Qoo`03001oogoo0=ioo`00O7oo00<07goo01l027oo00<007ooOol0gWoo001lOol0
0`0OOol07`08Ool00`00Oomoo`3NOol007aoo`0301moo`0O00Qoo`03001oogoo0=ioo`00O7oo00<0
7goo01l027oo0P00ggoo001lOol00`0OOol07`08Ool00`00Oomoo`3NOol007aoo`0301moo`0O00Qo
o`03001oogoo0=ioo`00O7oo00<07goo01l027oo00<007ooOol0gWoo001lOol0100O00007`001goo
00<007ooOol0gWoo001lOol01@0OOol07goo00001Woo00<007ooOol0gWoo001lOol01@0OOol07goo
00001Woo00<007ooOol0gWoo001lOol01@0OOol07goo00001Woo0`00gWoo001nOol2003XOol0081o
o`03001oogoo0>Eoo`00O7oo00D007ooOomoo`000>Moo`00OGoo0`00j7oo003oOomYOol00?moofUo
o`00ogooJGoo003oOomYOol00?moofUoo`00R7oo0`0000Aoo`0000000=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31254 m
.04057 .31297 L
.08481 .31358 L
.12636 .31435 L
.16632 .31538 L
.18687 .31608 L
.20885 .31703 L
.23122 .3183 L
.24149 .31903 L
.25237 .31994 L
.26235 .32092 L
.27334 .32224 L
.28327 .32371 L
.29271 .32545 L
.30335 .32798 L
.31308 .33108 L
.32357 .3358 L
.3295 .33948 L
.33501 .34395 L
.34034 .34973 L
.34314 .3536 L
.3461 .35859 L
.3487 .36398 L
.35155 .37142 L
.35414 .38019 L
.35656 .39093 L
.35777 .39764 L
.35909 .40631 L
.36025 .41549 L
.36149 .42735 L
.3626 .44052 L
.36382 .45893 L
.36494 .4808 L
.36598 .50806 L
.36722 .55398 L
s
.36722 .55398 m
.36828 .61803 L
s
.37245 .61803 m
.37251 0 L
s
.37691 0 m
.3773 .03123 L
.3786 .09119 L
.37983 .12806 L
.38095 .1523 L
.38227 .17353 L
.3837 .19096 L
.3863 .21337 L
.38773 .22237 L
.38902 .22917 L
.39191 .24111 L
.39459 .24938 L
.39711 .25551 L
.40196 .26435 L
.40642 .27023 L
.41132 .27514 L
.41648 .27912 L
.42646 .28466 L
.43205 .28695 L
.43714 .28869 L
.44649 .29126 L
.45641 .29336 L
.46684 .29509 L
.47649 .29639 L
.4983 .29858 L
.51879 .30004 L
.53799 .30108 L
.57867 .30265 L
.59975 .30324 L
.62192 .30375 L
.66199 .30448 L
.70463 .30506 L
.74569 .3055 L
.78931 .30587 L
.83135 .30616 L
.87179 .30639 L
.91481 .3066 L
.95624 .30677 L
.99608 .30691 L
1 .30693 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00=oo`807`800=ioo`00OWoo0P001Woo0P0Oh7oo0020Ool00`00Oomo
o`03Ool201oPOol007aoo`05001oogooOol00005Ool201oPOol007eoo`<000Ioo`807n1oo`00QWoo
0P0Oh7oo0026Ool201oPOol008Ioo`807`03001oogoo0=eoo`00QWoo0P0Oh7oo0026Ool201oPOol0
08Ioo`807n1oo`00QWoo0P0Oh7oo0026Ool201oPOol008Ioo`807`03001oogoo0=eoo`00QWoo0P0O
h7oo0026Ool201oPOol008Ioo`807n1oo`00QWoo0P0Oh7oo0026Ool201oPOol008Ioo`807n1oo`00
QWoo00<07`0001l0ggoo0026Ool00`0O00007`3OOol008Ioo`0301l0000O0=moo`00QWoo00<07`00
01l0ggoo0026Ool00`0O00007`3OOol008Ioo`0301l0000O0=moo`00QWoo00<07`0001l0ggoo0026
Ool00`0O00007`3OOol008Ioo`0301l0000O0=moo`00QWoo00<07`0001l0ggoo0026Ool00`0O0000
7`3OOol007aoo`D000Eoo`0301l0000O0=moo`00O7oo00D007ooOomoo`0000Eoo`0301l0000O0=mo
o`00OGoo00<007ooOol01Woo00<07`0001l0ggoo001dOol60004Ool00`00Oomoo`05Ool0100O0000
7`00gWoo001oOol00`00Oomoo`04Ool00`0O00007`3OOol0081oo`03001oogoo00=oo`0301l0000O
0=moo`00O7oo00D007ooOomoo`0000Eoo`0301l0000O0=moo`00OGoo0`001Woo00<07`0001l0ggoo
0026Ool00`0O00007`3OOol008Ioo`0301l0000O0=moo`00QWoo00<07`0001l0ggoo0026Ool00`0O
00007`3OOol008Ioo`0301l0000O0=moo`00QWoo00<07`0001l0ggoo0026Ool00`0O00007`3OOol0
08Ioo`0401l007oo01oNOol008Ioo`0401l007oo01oNOol008Ioo`0401l0000001oNOol008Ioo`04
01l007oo01oNOol008Ioo`0401l007oo01oNOol008Ioo`0401l007oo01oNOol008Ioo`0401l007oo
01oNOol008Ioo`0401l007oo01oNOol008Ioo`0401l0000001oNOol008Ioo`0401l007oo01oNOol0
08Ioo`0401l007oo01oNOol008Ioo`0401l007oo01oNOol008Ioo`0401l007oo01oNOol008Ioo`04
01l007oo01oNOol008Ioo`0501l007ooOol07`3MOol008Ioo`0501l00000Ool07`3MOol008Ioo`05
01l007ooOol07`3MOol008Ioo`0501l007ooOol07`3MOol008Ioo`0501l007ooOol07`3MOol007eo
o`D000Aoo`0501l007ooOol07`3MOol007moo`03001oogoo00Aoo`0501l007ooOol07`3MOol007mo
o`03001oogoo00Aoo`0501l007ooOol07`3MOol007Aoo`H000Eoo`03001oogoo00Aoo`0501l00000
00007`3MOol007moo`03001oogoo00Aoo`0501l007ooOol07`3MOol007moo`03001oogoo00Aoo`05
01l007ooOol07`3MOol007eoo`<000Ioo`0501l007ooOol07`3MOol007moo`03001oogoo00Aoo`03
01l007oo009oo`0301moogoo0=Yoo`00QWoo00<07`00Ool00Woo00<07gooOol0fWoo0026Ool00`0O
001oo`02Ool00`0OOomoo`3JOol008Ioo`0301l00000009oo`0301moogoo0=Yoo`00QWoo00<07`00
Ool00Woo00<07gooOol0fWoo0026Ool00`0O001oo`02Ool00`0OOomoo`3JOol008Ioo`0301l007oo
00=oo`0301moogoo0=Uoo`00QWoo00<07`00Ool00goo00<07gooOol0fGoo0026Ool00`0O001oo`03
Ool00`0OOomoo`3IOol008Ioo`0301l007oo00Aoo`0301moogoo0=Qoo`00QWoo00<07`00000017oo
00<07gooOol0f7oo0026Ool00`0O001oo`05Ool00`0OOomoo`3GOol008Ioo`0301l007oo00Eoo`03
01moogoo0=Moo`00QWoo00<07`00Ool01Woo00<07gooOol0eWoo0026Ool00`0O001oo`06Ool00`0O
Oomoo`3FOol000aoo`<002Ioo`D002Eoo`D0029oo`0301l007oo00Moo`0301moogoo01]oo`D002Ao
o`D002Eoo`<002Qoo`<002Eoo`@0011oo`002goo00D007ooOomoo`0002Eoo`05001oogooOol0000W
Ool00`00Oomoo`0ROol00`0O001oo`08Ool00`0OOomoo`0LOol00`00Oomoo`0TOol01@00Oomoogoo
000097oo00D007ooOomoo`0002Qoo`03001oogoo02=oo`03001oogoo009oo`03001oogoo00eoo`00
3goo00<007ooOol097oo00<007ooOol0:7oo00<007ooOol08Woo00<07`00000027oo00<07gooOol0
77oo00<007ooOol09Goo00<007ooOol0:Goo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol0
3Goo0003Ool60006Ool00`00Oomoo`0KOol60004Ool00`00Oomoo`0LOol60005Ool00`00Oomoo`0R
Ool00`0O001oo`09Ool00`0OOomoo`0KOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0R
Ool6000YOol00`00Oomoo`0=Ool000eoo`8002Uoo`03001oogoo02Ioo`03001oogoo029oo`0301l0
07oo00Yoo`0301moogoo01Yoo`03001oogoo02Moo`03001oogoo02Eoo`8002Ioo`04001oogoo000V
Ool4000@Ool000moo`03001oogoo02Moo`03001oogoo02Eoo`03001oogoo029oo`0301l007oo00]o
o`0301moogoo01Uoo`03001oogoo02Qoo`03001oogoo02Ioo`03001oogoo02=oo`04001oogoo000V
Ool00`00Oomoo`0AOol000]oo`05001oogooOol0000UOol01@00Oomoogoo00009Goo0`0097oo00<0
7`00Ool037oo0P0O5goo0`009Woo00D007ooOomoo`0002Aoo`05001oogooOol0000VOol00`00Ool0
000VOol00`00Oomoo`0AOol000aoo`<002Moo`<002Qoo`03001oogoo029oo`0301l007oo00ioo`80
7aMoo`03001oogoo02Eoo`<002Ioo`<002Qoo`8002Ioo`D000moo`00QWoo00<07`00000047oo100O
bgoo0026Ool00`0O001oo`0DOol301o8Ool008Ioo`0301l007oo01Moo`@07lAoo`00QWoo00<07`00
Ool06goo200O_7oo0026Ool00`0O001oo`0SOol>01n^Ool008Ioo`0301l007oo035oobH07hQoo`00
QWoo00<07`00Ool0EgooKP0O6Woo000:Ooml00000`0O00000035000901lAOol000Yoo`L07`9oo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`0301l007oo00Ioo`03
001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D0
00002Woo00<007ooOol017oo=00O67oo00<007ooOol09Woo00<07`00Ool09goo00<007ooOol09goo
00<007ooOol09Woo00<007ooOol09Woo00<007ooOol09goo00<007ooOol02Woo00@007ooOomoo`40
0000AGoo500O;Goo00<07`00Ool0fgoo00<007ooOol00Goo001IOol:01lSOol00`0O001oo`3LOol1
0001Ool1Ool006=oo`L07aaoo`0301l007oo0=Yoo`04001oogoo0001Ool006Yoo`<07aUoo`0301l0
07oo0=Yoo`D00000KGoo100O5Goo00<07`000000ggoo001aOol301lBOol00`0O001oo`3OOol007Ao
o`<07`moo`0301l007oo0=moo`00Mgoo0P0O3Goo00<07`00Ool0ggoo001iOol00`0OOomoo`0:Ool0
0`0O001oo`3OOol007Uoo`0301moogoo00Yoo`0301l007oo0=moo`00NWoo00<07gooOol02Goo00<0
7`00Ool0ggoo001kOol00`0OOomoo`08Ool00`0O0000003OOol007aoo`0301moogoo00Moo`0301l0
07oo0=moo`00OGoo00<07gooOol01Woo00<07`00Ool0ggoo001mOol00`0OOomoo`06Ool00`0O001o
o`3OOol007ioo`0301moogoo00Eoo`0301l007oo0=moo`00OWoo00<07gooOol01Goo00<07`00Ool0
ggoo001oOol00`0OOomoo`04Ool00`0O001oo`3OOol007moo`0301moogoo00Aoo`0301l000000=mo
o`00Ogoo00<07gooOol017oo00<07`00Ool0ggoo0020Ool00`0OOomoo`03Ool00`0O001oo`3OOol0
081oo`0301moogoo00=oo`0301l007oo0=moo`00P7oo00<07gooOol00goo00<07`00Ool0ggoo0021
Ool00`0OOomoo`02Ool00`0O001oo`3OOol0085oo`0301moogoo009oo`0301l007oo0=moo`00PGoo
00<07gooOol00Woo00<07`000000ggoo0021Ool00`0OOomoo`02Ool00`0O001oo`3OOol0085oo`03
01moogoo009oo`0301l007oo0=moo`00OGoo100000<07gooOol00Woo00<07`00Ool0ggoo001oOol0
0`00Ool07`04Ool00`0O001oo`3OOol007moo`03001oo`0O00Aoo`0301l007oo0=moo`00Ogoo00@0
07ooOol07`=oo`0401l00000003NOol007moo`04001oogoo01l3Ool00`0O001oo`3OOol007moo`04
001oogoo01l3Ool00`0O001oo`3OOol007eoo`<0009oo`0601moogooOol07`00h7oo001oOol01000
Oomoo`0O0goo00<07`00Ool0ggoo0022Ool01P0OOomoogoo01l00>1oo`00PWoo00H07gooOomoo`0O
003POol0089oo`0501moogooOol07`02003OOol008=oo`0501moogoo01l0003POol008=oo`0501mo
ogoo01l0003POol008=oo`0501moogoo01l0003POol008=oo`0501moogoo01l0003POol008=oo`05
01moogoo01l0003POol008=oo`0501moogoo01l0003POol008=oo`0401moogoo01l2003OOol008=o
o`0501moogoo01l0003POol008=oo`0501moogoo01l0003POol008=oo`0501moogoo01l0003POol0
08=oo`0501moogoo01l0003POol008=oo`0501moogoo01l0003POol008=oo`0501moogoo01l0003P
Ool008=oo`0401moogoo01l2003OOol008=oo`0501moogoo01l0003POol008=oo`0501moogoo01l0
003POol008=oo`0501moogoo01l0003POol008=oo`0501moogoo01l0003POol008=oo`0501moogoo
01l0003POol008=oo`0501moogoo01l0003POol008Aoo`0301moo`0O00800=moo`00Q7oo00@07goo
01l00>1oo`00Q7oo00@07goo01l00>1oo`00Q7oo00@07goo01l00>1oo`00O7oo1@000goo00@07goo
01l00>1oo`00O7oo00D007ooOomoo`0000=oo`0401moo`0O003POol007eoo`03001oogoo00Aoo`04
01moo`0O003POol007ioo`03001oogoo00=oo`0301moo`0O00<00=ioo`00Ogoo00<007ooOol00Woo
00@07goo01l00>1oo`00P7oo00P007ooOomoo`0OOol07`00h7oo001lOol01@00Oomoogoo00000goo
00@07goo01l00>1oo`00OGoo0`0017oo00@07goo01l00>1oo`00Q7oo00@07goo01l00>1oo`00Q7oo
00<07goo01l00P00ggoo0024Ool0100OOol07`00h7oo0024Ool0100OOol07`00h7oo0024Ool0100O
Ool07`00h7oo0024Ool0100OOol07`00h7oo0024Ool0100OOol07`00h7oo0024Ool0100OOol07`00
h7oo0024Ool00`0OOol07`02003OOol008Aoo`0401moo`0O003POol008Aoo`0401moo`0O003POol0
08Aoo`0401moo`0O003POol008Aoo`0401moo`0O003POol008Aoo`0401moo`0O003POol008Aoo`04
01moo`0O003POol008Aoo`0301moo`0O00800=moo`00Q7oo00@07goo01l00>1oo`00Q7oo00@07goo
01l00>1oo`00Q7oo00@07goo01l00>1oo`00Q7oo00@07goo01l00>1oo`00Q7oo00@07goo01l00>1o
o`00Q7oo00@07goo01l00>1oo`00Q7oo00<07goo01l00P00ggoo0024Ool0100OOol07`00h7oo0024
Ool0100OOol07`00h7oo0024Ool0100OOol07`00h7oo001mOol30004Ool0100OOol07`00h7oo001l
Ool01@00Oomoogoo00000goo00@07goo01l00>1oo`00P7oo00P007ooOomoo`0OOol07`00h7oo0020
Ool01`00Oomoogoo01moo`0O00<00=ioo`00OWoo0P00j7oo0020Ool00`00Oomoo`3UOol007aoo`05
001oogooOol0003WOol007eoo`<00>Qoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003o
OomYOol008Qoo`<00004Ool00000003IOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31232 m
.04057 .31269 L
.08481 .31321 L
.12636 .31386 L
.16632 .31469 L
.18687 .31525 L
.20885 .31597 L
.23122 .31691 L
.25237 .31806 L
.27334 .31958 L
.29271 .32153 L
.30286 .32287 L
.31237 .32442 L
.3228 .32657 L
.33402 .32967 L
.34463 .33381 L
.35064 .33698 L
.35621 .34075 L
.36157 .34547 L
.36642 .35115 L
.36912 .35513 L
.37203 .36039 L
.37458 .36608 L
.37731 .37377 L
.38001 .38372 L
.38247 .39589 L
.38366 .40329 L
.38495 .41291 L
.38729 .43658 L
.3886 .45521 L
.39005 .48331 L
.39078 .50196 L
.39156 .5271 L
.3923 .5577 L
.39298 .59441 L
s
.39298 .59441 m
.39326 .61803 L
s
.39751 .61803 m
.39771 0 L
s
.40183 0 m
.40187 .00298 L
.40258 .04664 L
.40336 .08215 L
.40421 .11095 L
.40493 .1304 L
.40571 .14768 L
.40715 .17183 L
.40854 .18928 L
.40983 .20191 L
.41251 .22111 L
.41493 .23339 L
.41773 .24388 L
.42036 .25141 L
.42527 .26161 L
.42805 .26594 L
.43064 .26932 L
.43588 .27475 L
.44149 .27912 L
.44671 .2823 L
.45165 .28474 L
.4609 .28829 L
.47106 .29115 L
.48184 .29344 L
.5012 .29635 L
.51106 .29745 L
.52168 .29844 L
.54089 .29986 L
.56197 .30103 L
.58414 .30198 L
.62421 .30323 L
.64484 .30371 L
.66685 .30414 L
.71048 .30482 L
.75252 .30532 L
.79296 .3057 L
.83598 .30602 L
.87741 .30628 L
.91725 .30649 L
.95966 .30668 L
1 .30684 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<000Aoo`0301moo`0O0=Moo`00OWoo0P001goo00<007ooOol0
17oo00<07goo01l0egoo0020Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`0OOol07`3GOol007ao
o`05001oogooOol00006Ool00`00Oomoo`04Ool00`0OOol07`3GOol007eoo`<000Moo`03001oogoo
00Aoo`0301moo`0O0=Moo`00Qgoo00<007ooOol017oo00<07goo01l0egoo0027Ool00`00Oomoo`04
Ool00`0OOol07`3GOol008Moo`8000Eoo`0301moo`0O0=Moo`00Qgoo00<007ooOol017oo00<07goo
01l0egoo0027Ool00`00Oomoo`04Ool00`0OOol07`3GOol008Moo`03001oogoo00Aoo`0301moo`0O
0=Moo`00Qgoo00<007ooOol017oo00<07goo01l0egoo0027Ool00`00Oomoo`04Ool00`0OOol07`3G
Ool008Moo`8000Eoo`0301moo`0O0=Moo`00Qgoo00<007ooOol017oo00<07goo01l0egoo0027Ool0
0`00Oomoo`04Ool00`0OOol07`3GOol008Moo`03001oogoo00Aoo`0301moo`0O0=Moo`00Qgoo00<0
07ooOol017oo00<07goo01l0egoo0027Ool00`00Oomoo`04Ool00`0OOol07`3GOol008Moo`03001o
ogoo00Aoo`0301moo`0O0=Moo`00Qgoo0P001Goo00<07goo01l0egoo0027Ool00`00Oomoo`04Ool0
0`0OOol07`3GOol008Moo`03001oogoo00Aoo`0301moo`0O0=Moo`00Qgoo00<007ooOol017oo00<0
7goo01l0egoo0027Ool00`00Oomoo`04Ool00`0OOol07`3GOol008Moo`03001oogoo00Aoo`0301mo
o`0O0=Moo`00Qgoo00<007ooOol017oo00<07goo01l0egoo0027Ool20005Ool00`0OOol07`3GOol0
08Moo`03001oogoo00Aoo`0301moo`0O0=Moo`00Qgoo00<007ooOol017oo00<07goo01l0egoo0027
Ool00`00Oomoo`04Ool00`0OOol07`3GOol007aoo`D000Ioo`03001oogoo00Aoo`0301moo`0O0=Mo
o`00O7oo00D007ooOomoo`0000Ioo`03001oogoo00Aoo`0301moo`0O0=Moo`00OGoo00<007ooOol0
1goo00<007ooOol017oo00<07goo01l0egoo001dOol60004Ool00`00Oomoo`06Ool30004Ool00`0O
Ool07`3GOol007moo`03001oogoo00Eoo`03001oogoo00Aoo`0301moo`0O0=Moo`00P7oo00<007oo
Ool017oo00<007ooOol017oo00<07goo01l0egoo001lOol01@00Oomoogoo00001Woo00<007ooOol0
17oo00<07goo01l0egoo001mOol30007Ool00`00Oomoo`04Ool00`0OOol07`3GOol008Moo`03001o
ogoo00Aoo`0301moo`0O0=Moo`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo0P001Goo
00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo
00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo
00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo
00@07gooOol07mIoo`00Qgoo0P001Goo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07goo
Ool07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07goo
Ool07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07goo
Ool07mIoo`00Qgoo0P001Goo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIo
o`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIo
o`00Qgoo00<007ooOol017oo00@07gooOol07mIoo`00Qgoo00<007ooOol017oo00@07gooOol07mIo
o`00Qgoo00<007ooOol017oo00D07gooOomoo`0O0=Eoo`00Qgoo0P001Goo00D07gooOomoo`0O0=Eo
o`00Qgoo00<007ooOol017oo00D07gooOomoo`0O0=Eoo`00Qgoo00<007ooOol017oo00D07gooOomo
o`0O0=Eoo`00Qgoo00<007ooOol017oo00D07gooOomoo`0O0=Eoo`00OGoo1@001Goo00<007ooOol0
17oo00D07gooOomoo`0O0=Eoo`00Ogoo00<007ooOol01Goo00<007ooOol017oo00D07gooOomoo`0O
0=Eoo`00Ogoo00<007ooOol01Goo00<007ooOol017oo00D07gooOomoo`0O0=Eoo`00M7oo1P001Goo
00<007ooOol01Goo0`0017oo00D07gooOomoo`0O0=Eoo`00Ogoo00<007ooOol01Goo00<007ooOol0
17oo00D07gooOomoo`0O0=Eoo`00Ogoo00<007ooOol01Goo00<007ooOol017oo00<07gooOol00Woo
00<07gooOol0dWoo001mOol30007Ool00`00Oomoo`04Ool00`0OOomoo`02Ool00`0OOomoo`3BOol0
07moo`03001oogoo00Eoo`03001oogoo00Aoo`0301moogoo009oo`0301moogoo0=9oo`00Qgoo00<0
07ooOol017oo00<07gooOol00Woo00<07gooOol0dWoo0027Ool00`00Oomoo`04Ool00`0OOomoo`02
Ool00`0OOomoo`3BOol008Moo`8000Eoo`0301moogoo00=oo`0301moogoo0=5oo`00Qgoo00<007oo
Ool017oo00<07gooOol00goo00<07gooOol0dGoo0027Ool00`00Oomoo`04Ool00`0OOomoo`03Ool0
0`0OOomoo`3AOol008Moo`03001oogoo00Aoo`0301moogoo00=oo`0301moogoo0=5oo`00Qgoo00<0
07ooOol017oo00<07gooOol017oo00<07gooOol0d7oo0027Ool00`00Oomoo`04Ool00`0OOomoo`04
Ool00`0OOomoo`3@Ool008Moo`03001oogoo00Aoo`0301moogoo00Aoo`0301moogoo0=1oo`00Qgoo
0P001Goo00<07gooOol01Goo00<07gooOol0cgoo0027Ool00`00Oomoo`04Ool00`0OOomoo`05Ool0
0`0OOomoo`3?Ool008Moo`03001oogoo00Aoo`0301moogoo00Eoo`0301moogoo0<moo`00Qgoo00<0
07ooOol017oo00<07gooOol01Woo00<07gooOol0cWoo0027Ool00`00Oomoo`04Ool00`0OOomoo`06
Ool00`0OOomoo`3>Ool000aoo`<002Ioo`D002Eoo`D002=oo`03001oogoo00Aoo`0301moogoo00Io
o`0301moogoo01Aoo`D002Aoo`D002Eoo`<002Qoo`<002Eoo`@0011oo`002goo00D007ooOomoo`00
02Eoo`05001oogooOol0000WOol00`00Oomoo`0SOol00`00Oomoo`04Ool00`0OOomoo`07Ool00`0O
Oomoo`0EOol00`00Oomoo`0TOol01@00Oomoogoo000097oo00D007ooOomoo`0002Qoo`03001oogoo
02=oo`03001oogoo009oo`03001oogoo00eoo`003goo00<007ooOol097oo00<007ooOol0:7oo00<0
07ooOol08goo0P001Goo00<07gooOol027oo00<07gooOol057oo00<007ooOol09Goo00<007ooOol0
:Goo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol03Goo0003Ool60006Ool00`00Oomoo`0K
Ool60004Ool00`00Oomoo`0LOol60005Ool00`00Oomoo`0SOol00`00Oomoo`04Ool00`0OOomoo`09
Ool00`0OOomoo`0COol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0ROol6000YOol00`00
Oomoo`0=Ool000eoo`8002Uoo`03001oogoo02Ioo`03001oogoo02=oo`03001oogoo00Aoo`0301mo
ogoo00Yoo`0301moogoo019oo`03001oogoo02Moo`03001oogoo02Eoo`8002Ioo`04001oogoo000V
Ool4000@Ool000moo`03001oogoo02Moo`03001oogoo02Eoo`03001oogoo02=oo`03001oogoo00Ao
o`0301moogoo00]oo`807a9oo`03001oogoo02Qoo`03001oogoo02Ioo`03001oogoo02=oo`04001o
ogoo000VOol00`00Oomoo`0AOol000]oo`05001oogooOol0000UOol01@00Oomoogoo00009Goo0`00
9Goo00<007ooOol017oo00<07gooOol03Goo00<07gooOol03Goo0`009Woo00D007ooOomoo`0002Ao
o`05001oogooOol0000VOol00`00Ool0000VOol00`00Oomoo`0AOol000aoo`<002Moo`<002Qoo`03
001oogoo02=oo`03001oogoo00Aoo`0301moogoo00ioo`<07`ioo`03001oogoo02Eoo`<002Ioo`<0
02Qoo`8002Ioo`D000moo`00Qgoo0P001Goo00<07gooOol04Goo0`0O`goo0027Ool00`00Oomoo`04
Ool00`0OOomoo`0DOol401noOol008Moo`03001oogoo00Aoo`0301moogoo01Qoo`D07kYoo`00Qgoo
00<007ooOol017oo00<07gooOol07Goo200O/Woo0027Ool00`00Oomoo`04Ool00`0OOomoo`0UOol<
01nVOol008Moo`03001oogoo00Aoo`0301moogoo035oob807hAoo`00Qgoo00<007ooOol017oo00<0
7gooOol0DgooK00O67oo000:Oon400000`0O0000002o000701lAOol000YooaD07`Aoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Aoo`0301l007oo00Ioo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D000002Woo00<007ooOol04Woo;@0O4Goo00<007oo
Ool09goo00<007ooOol017oo00<07gooOol07goo00<007ooOol09goo00<007ooOol09Woo00<007oo
Ool09Woo00<007ooOol09goo00<007ooOol02Woo00@007ooOomoo`400000C7oo5P0O9Goo00<007oo
Ool017oo00<07gooOol0dgoo00<007ooOol00Goo001ROol;01lJOol00`00Oomoo`04Ool00`0OOomo
o`3DOol10001Ool1Ool006eoo`L07a=oo`03001oogoo00Aoo`0301moogoo0=9oo`04001oogoo0001
Ool007Aoo`<07a1oo`03001oogoo00Aoo`0301moogoo0=9oo`D00000Mgoo100O37oo0P001Goo00<0
7gooOol0egoo001kOol301l9Ool00`00Oomoo`04Ool00`0OOomoo`3GOol007ioo`0301moogoo00Io
o`03001oogoo00Aoo`0301moogoo0=Moo`00Ogoo00<07gooOol01Goo00<007ooOol017oo00<07goo
Ool0egoo0020Ool00`0OOomoo`04Ool00`00Oomoo`04Ool00`0OOomoo`3GOol0085oo`807`Aoo`03
001oogoo00Aoo`0301moogoo0=Moo`00Pgoo00D07gooOomoo`0000Ioo`0301moogoo0=Moo`00Q7oo
00<07gooOol00P001Goo00<07gooOol0egoo0025Ool00`0OOol00006Ool00`0OOomoo`3GOol008Eo
o`0301moo`0000Ioo`0301moogoo0=Moo`00QWoo00<07`00Ool01Goo00<07gooOol0egoo0027Ool0
0`0OOomoo`04Ool00`0OOomoo`3GOol008Moo`0301moogoo00Aoo`0301moogoo0=Moo`00Qgoo00<0
7gooOol017oo00<07gooOol0egoo0027Ool00`0O001oo`04Ool00`0OOomoo`3GOol008Moo`0301mo
ogoo00Aoo`0301moogoo0=Moo`00Qgoo00<07gooOol017oo00<07gooOol0egoo0027Ool00`0001mo
o`04Ool00`0OOomoo`3GOol008Moo`0300007goo00Aoo`0301moogoo0=Moo`00Qgoo00<0000OOol0
17oo00<07gooOol0egoo0027Ool00`00Ool07`04Ool00`0OOomoo`3GOol008Moo`80000301moogoo
009oo`0301moogoo0=Moo`00Qgoo00<007oo01l017oo00<07gooOol0egoo0027Ool01000Oomoo`0O
0goo00<07gooOol0egoo001mOol50005Ool01000Oomoo`0O0goo00<07gooOol0egoo001oOol00`00
Oomoo`05Ool01000Oomoo`0O0goo00<07gooOol0egoo001oOol00`00Oomoo`05Ool01000Oomoo`0O
0goo00<07gooOol0egoo001oOol00`00Oomoo`05Ool300001@0OOomoogoo01l0fGoo001oOol00`00
Oomoo`05Ool01000Oomoo`0O0goo00<07gooOol0egoo001oOol00`00Oomoo`05Ool01000Oomoo`0O
0goo00<07gooOol0egoo001mOol30007Ool01000Oomoo`0O0goo00<07gooOol0egoo001oOol00`00
Oomoo`05Ool01000Oomoo`0O0goo00<07gooOol0egoo0027Ool01@00Oomoogoo01l00Woo00<07goo
Ool0egoo0027Ool01@00Oomoogoo01l00Woo00<07gooOol0egoo0027Ool20002Ool0100OOomoo`0O
fGoo0027Ool01@00Oomoogoo01l00Woo00<07gooOol0egoo0027Ool01@00Oomoogoo01l00Woo00<0
7gooOol0egoo0027Ool01@00Oomoogoo01l00Woo00<07gooOol0egoo0027Ool01@00Oomoogoo01l0
0Woo00<07gooOol0egoo0027Ool01@00Oomoogoo01l00Woo00<07gooOol0egoo0027Ool01@00Oomo
ogoo01l00Woo00<07gooOol0egoo0027Ool20002Ool0100OOomoo`0OfGoo0027Ool01@00Oomoogoo
01l00Woo00<07gooOol0egoo0027Ool01@00Oomoogoo01l00Woo00<07gooOol0egoo0027Ool01@00
Oomoogoo01l00Woo00<07gooOol0egoo0027Ool01@00Oomoogoo01l00Woo00<07gooOol0egoo0027
Ool01@00Oomoogoo01l00Woo00<07gooOol0egoo0027Ool00`00Oomoo`02Ool00`0OOol07`3IOol0
08Moo`8000=oo`0301moo`0O0=Uoo`00Qgoo00<007ooOol00Woo00<07goo01l0fGoo0027Ool00`00
Oomoo`02Ool00`0OOol07`3IOol008Moo`03001oogoo009oo`0301moo`0O0=Uoo`00Qgoo00<007oo
Ool00Woo00<07goo01l0fGoo0027Ool00`00Oomoo`02Ool00`0OOol07`3IOol008Moo`03001oogoo
009oo`0301moo`0O0=Uoo`00Qgoo0P000goo00<07goo01l0fGoo0027Ool00`00Oomoo`02Ool00`0O
Ool07`3IOol008Moo`03001oogoo009oo`0301moo`0O0=Uoo`00Qgoo00<007ooOol00Woo00<07goo
01l0fGoo001lOol50006Ool00`00Oomoo`02Ool00`0OOol07`3IOol007aoo`05001oogooOol00006
Ool00`00Oomoo`02Ool00`0OOol07`3IOol007eoo`03001oogoo00Moo`03001oogoo009oo`0301mo
o`0O0=Uoo`00OWoo00<007ooOol01Woo0`000Woo00<07goo01l0fGoo001oOol00`00Oomoo`05Ool0
0`00Oomoo`02Ool00`0OOol07`3IOol0081oo`03001oogoo00Aoo`03001oogoo009oo`0301moo`0O
0=Uoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo009oo`0301moo`0O0=Uoo`00OGoo0`001goo
00<007ooOol00Woo00<07goo01l0fGoo0027Ool00`00Oomoo`02Ool00`0OOol07`3IOol008Moo`80
00=oo`0301moo`0O0=Uoo`00Qgoo00<007ooOol00Woo00<07goo01l0fGoo0027Ool00`00Oomoo`02
Ool00`0OOol07`3IOol008Moo`03001oogoo009oo`0301moo`0O0=Uoo`00Qgoo00<007ooOol00Woo
00<07goo01l0fGoo0027Ool00`00Oomoo`02Ool00`0OOol07`3IOol008Moo`03001oogoo009oo`03
01moo`0O0=Uoo`00Qgoo0P000goo00<07goo01l0fGoo0027Ool00`00Oomoo`02Ool00`0OOol07`3I
Ool008Moo`03001oogoo009oo`0301moo`0O0=Uoo`00Qgoo00<007ooOol00Woo00<07goo01l0fGoo
0027Ool00`00Oomoo`02Ool00`0OOol07`3IOol008Moo`03001oogoo009oo`0301moo`0O0=Uoo`00
Qgoo00<007ooOol00Woo00<07goo01l0fGoo0027Ool20004Ool201oIOol008Moo`03001oogoo00=o
o`807mUoo`00Qgoo00<007ooOol00goo0P0OfGoo0027Ool00`00Oomoo`03Ool201oIOol008Moo`03
001oogoo00=oo`807mUoo`00Qgoo00<007ooOol00goo0P0OfGoo0027Ool00`00Oomoo`03Ool201oI
Ool008Moo`8000Aoo`807mUoo`00Qgoo00<007ooOol00goo0P0OfGoo0027Ool00`00Oomoo`03Ool2
01oIOol008Moo`03001oogoo00=oo`807mUoo`00OGoo0`001goo00<007ooOol00goo0P0OfGoo001l
Ool01@00Oomoogoo00001Woo00<007ooOol00goo0P0OfGoo0020Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool201oIOol0081oo`03001oogoo00Aoo`<000=oo`807mUoo`00OWoo0P00j7oo0020Ool00`00
Oomoo`3UOol007aoo`05001oogooOol0003WOol007eoo`<00>Qoo`00ogooJGoo003oOomYOol00?mo
ofUoo`00ogooJGoo003oOomYOol008Qoo`<00004Ool00000003IOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31212 m
.04057 .31245 L
.08481 .3129 L
.12636 .31345 L
.16632 .31414 L
.18859 .31463 L
.20885 .31516 L
.2498 .31661 L
.2699 .31761 L
.29172 .31905 L
.31255 .32095 L
.32306 .32221 L
.33463 .32394 L
.34527 .326 L
.35501 .32844 L
.36038 .33012 L
.36625 .33232 L
.37693 .33777 L
.38251 .34177 L
.38777 .34672 L
.39249 .35263 L
.39759 .36154 L
.40025 .36779 L
.40317 .37663 L
.40464 .38217 L
.40621 .38922 L
.40758 .39651 L
.40906 .4061 L
.41053 .41796 L
.41189 .43185 L
.4132 .44889 L
.41458 .47307 L
.41581 .50298 L
.41697 .54305 L
.41824 .6116 L
s
.41824 .6116 m
.4183 .61803 L
s
.42296 .61803 m
.42316 0 L
s
.42689 0 m
.42714 .02133 L
.42837 .08218 L
.42966 .12368 L
.43096 .1525 L
.43237 .1749 L
.43369 .19086 L
.4349 .20245 L
.43631 .21342 L
.43785 .22307 L
.44065 .2364 L
.44358 .24651 L
.44622 .2535 L
.44907 .25947 L
.45215 .26463 L
.45764 .27158 L
.46281 .27639 L
.46799 .28011 L
.47281 .28289 L
.47856 .28557 L
.48378 .28757 L
.49447 .29076 L
.50592 .29327 L
.51635 .29502 L
.526 .29633 L
.54781 .29854 L
.56745 .29996 L
.58909 .30113 L
.60945 .30199 L
.63136 .30273 L
.67461 .30381 L
.71627 .30455 L
.75634 .30508 L
.79899 .30553 L
.84004 .30587 L
.88367 .30617 L
.9257 .30641 L
.96615 .3066 L
1 .30674 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<000eoo`807lmoo`00OWoo0P001goo00<007ooOol03Goo0P0O
cgoo0020Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool201o?Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`0=Ool201o?Ool007eoo`<000Moo`03001oogoo00eoo`807lmoo`00Qgoo00<007ooOol0
3Goo0P0Ocgoo0027Ool00`00Oomoo`0=Ool201o?Ool008Moo`8000ioo`807lmoo`00Qgoo00<007oo
Ool03Goo0P0Ocgoo0027Ool00`00Oomoo`0=Ool201o?Ool008Moo`03001oogoo00eoo`807lmoo`00
Qgoo00<007ooOol03Goo0P0Ocgoo0027Ool00`00Oomoo`0=Ool201o?Ool008Moo`8000ioo`807lmo
o`00Qgoo00<007ooOol03Goo0P0Ocgoo0027Ool00`00Oomoo`0=Ool201o?Ool008Moo`03001oogoo
00eoo`807lmoo`00Qgoo00<007ooOol03Goo0P0Ocgoo0027Ool00`00Oomoo`0=Ool201o?Ool008Mo
o`03001oogoo00eoo`807lmoo`00Qgoo0P003Woo0P0Ocgoo0027Ool00`00Oomoo`0=Ool201o?Ool0
08Moo`03001oogoo00eoo`807lmoo`00Qgoo00<007ooOol03Goo0P0Ocgoo0027Ool00`00Oomoo`0=
Ool201o?Ool008Moo`03001oogoo00eoo`807lmoo`00Qgoo00<007ooOol03Goo0P0Ocgoo0027Ool2
000>Ool201o?Ool008Moo`03001oogoo00eoo`807lmoo`00Qgoo00<007ooOol03Goo0P0Ocgoo0027
Ool00`00Oomoo`0=Ool201o?Ool007aoo`D000Ioo`03001oogoo00eoo`807lmoo`00O7oo00D007oo
Oomoo`0000Ioo`03001oogoo00eoo`807lmoo`00OGoo00<007ooOol01goo00<007ooOol03Goo0P0O
cgoo001dOol60004Ool00`00Oomoo`06Ool3000=Ool00`0OOol07`3>Ool007moo`03001oogoo00Eo
o`03001oogoo00eoo`0301moo`0O0<ioo`00P7oo00<007ooOol017oo00<007ooOol03Goo00<07goo
01l0cWoo001lOol01@00Oomoogoo00001Woo00<007ooOol03Goo00<07goo01l0cWoo001mOol30007
Ool00`00Oomoo`0=Ool00`0OOol07`3>Ool008Moo`03001oogoo00eoo`0301moo`0O0<ioo`00Qgoo
00<007ooOol03Goo00<07goo01l0cWoo0027Ool2000>Ool00`0OOol07`3>Ool008Moo`03001oogoo
00eoo`0301moo`0O0<ioo`00Qgoo00<007ooOol03Goo00<07goo01l0cWoo0027Ool00`00Oomoo`0=
Ool00`0OOol07`3>Ool008Moo`03001oogoo00eoo`0301moo`0O0<ioo`00Qgoo00<007ooOol03Goo
00<07goo01l0cWoo0027Ool00`00Oomoo`0=Ool00`0OOol07`3>Ool008Moo`8000ioo`0301moo`0O
0<ioo`00Qgoo00<007ooOol03Goo00<07goo01l0cWoo0027Ool00`00Oomoo`0=Ool00`0OOol07`3>
Ool008Moo`03001oogoo00eoo`0301moo`0O0<ioo`00Qgoo00<007ooOol03Goo00<07goo01l0cWoo
0027Ool00`00Oomoo`0=Ool00`0OOol07`3>Ool008Moo`8000ioo`0401moogoo01o=Ool008Moo`03
001oogoo00eoo`0401moogoo01o=Ool008Moo`03001oogoo00eoo`0401moogoo01o=Ool008Moo`03
001oogoo00eoo`0401moogoo01o=Ool008Moo`03001oogoo00eoo`0401moogoo01o=Ool008Moo`03
001oogoo00eoo`0401moogoo01o=Ool008Moo`03001oogoo00eoo`0401moogoo01o=Ool008Moo`80
00ioo`0401moogoo01o=Ool008Moo`03001oogoo00eoo`0401moogoo01o=Ool008Moo`03001oogoo
00eoo`0401moogoo01o=Ool008Moo`03001oogoo00eoo`0401moogoo01o=Ool007eoo`D000Eoo`03
001oogoo00eoo`0501moogooOol07`3<Ool007moo`03001oogoo00Eoo`03001oogoo00eoo`0501mo
ogooOol07`3<Ool007moo`03001oogoo00Eoo`03001oogoo00eoo`0501moogooOol07`3<Ool007Ao
o`H000Eoo`03001oogoo00Eoo`<000eoo`0501moogooOol07`3<Ool007moo`03001oogoo00Eoo`03
001oogoo00eoo`0501moogooOol07`3<Ool007moo`03001oogoo00Eoo`03001oogoo00eoo`0501mo
ogooOol07`3<Ool007eoo`<000Moo`03001oogoo00eoo`0501moogooOol07`3<Ool007moo`03001o
ogoo00Eoo`03001oogoo00eoo`0501moogooOol07`3<Ool008Moo`03001oogoo00eoo`0501moogoo
Ool07`3<Ool008Moo`03001oogoo00eoo`0501moogooOol07`3<Ool008Moo`8000ioo`0501moogoo
Ool07`3<Ool008Moo`03001oogoo00eoo`0301moogoo009oo`0301moogoo0<Uoo`00Qgoo00<007oo
Ool03Goo00<07gooOol00Woo00<07gooOol0bGoo0027Ool00`00Oomoo`0=Ool00`0OOomoo`02Ool0
0`0OOomoo`39Ool008Moo`03001oogoo00eoo`0301moogoo009oo`0301moogoo0<Uoo`00Qgoo00<0
07ooOol03Goo00<07gooOol00goo00<07gooOol0b7oo0027Ool00`00Oomoo`0=Ool00`0OOomoo`03
Ool00`0OOomoo`38Ool008Moo`8000ioo`0301moogoo00=oo`0301moogoo0<Qoo`00Qgoo00<007oo
Ool03Goo00<07gooOol017oo00<07gooOol0agoo0027Ool00`00Oomoo`0=Ool00`0OOomoo`04Ool0
0`0OOomoo`37Ool008Moo`03001oogoo00eoo`0301moogoo00Eoo`0301moogoo0<Ioo`00Qgoo00<0
07ooOol03Goo00<07gooOol01Goo00<07gooOol0aWoo000<Ool3000VOol5000UOol5000SOol00`00
Oomoo`0=Ool00`0OOomoo`06Ool00`0OOomoo`0;Ool5000TOol5000UOol3000XOol3000UOol4000@
Ool000]oo`05001oogooOol0000UOol01@00Oomoogoo00009goo00<007ooOol08goo00<007ooOol0
3Goo00<07gooOol01Woo00<07gooOol03Goo00<007ooOol097oo00D007ooOomoo`0002Aoo`05001o
ogooOol0000XOol00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000moo`03001oogoo
02Aoo`03001oogoo02Qoo`03001oogoo02=oo`8000ioo`0301moogoo00Moo`0301moogoo00aoo`03
001oogoo02Eoo`03001oogoo02Uoo`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo00eoo`00
0goo1P001Woo00<007ooOol06goo1P0017oo00<007ooOol077oo1P001Goo00<007ooOol08goo00<0
07ooOol03Goo00<07gooOol027oo00<07gooOol02goo00<007ooOol09Woo00<007ooOol0:7oo00<0
07ooOol08Woo1P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomoo`0VOol00`00Oomoo`0S
Ool00`00Oomoo`0=Ool00`0OOomoo`09Ool201l;Ool00`00Oomoo`0WOol00`00Oomoo`0UOol2000V
Ool01000Oomoo`009Woo100047oo000?Ool00`00Oomoo`0WOol00`00Oomoo`0UOol00`00Oomoo`0S
Ool00`00Oomoo`0=Ool00`0OOomoo`0;Ool00`0OOomoo`08Ool00`00Oomoo`0XOol00`00Oomoo`0V
Ool00`00Oomoo`0SOol01000Oomoo`009Woo00<007ooOol04Goo000;Ool01@00Oomoogoo00009Goo
00D007ooOomoo`0002Eoo`<002Eoo`03001oogoo00eoo`0301moogoo00]oo`0301moogoo00Ioo`<0
02Ioo`05001oogooOol0000TOol01@00Oomoogoo00009Woo00<007oo00009Woo00<007ooOol04Goo
000<Ool3000WOol3000XOol00`00Oomoo`0SOol00`00Oomoo`0=Ool00`0OOomoo`0<Ool401l6Ool0
0`00Oomoo`0UOol3000VOol3000XOol2000VOol5000?Ool008Moo`8000ioo`0301moogoo011oo`<0
7k]oo`00Qgoo00<007ooOol03Goo00<07gooOol04goo0`0O^7oo0027Ool00`00Oomoo`0=Ool00`0O
Oomoo`0FOol401ndOol008Moo`03001oogoo00eoo`0301moogoo01Yoo`T07j]oo`00Qgoo00<007oo
Ool03Goo00<07gooOol08goo3@0OWWoo0027Ool00`00Oomoo`0=Ool00`0OOomoo`0`OolI01n5Ool0
08Moo`03001oogoo00eoo`0301moogoo04Uoog@07a5oo`002WooS@0000<07`000000_@004Goo000:
OolE01l4Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00
Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`0O
Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool5000000Yoo`03001oogoo
019oocP07`Ioo`03001oogoo02Moo`03001oogoo00eoo`0301moogoo01Ioo`03001oogoo02Moo`03
001oogoo02Ioo`03001oogoo02Ioo`03001oogoo02Moo`03001oogoo00Yoo`04001oogooOol10000
05Mooa407amoo`03001oogoo00eoo`0301moogoo0<Yoo`03001oogoo005oo`00J7oo300O4goo00<0
07ooOol03Goo00<07gooOol0bgoo0@000Goo0Goo001dOol701l<Ool00`00Oomoo`0=Ool00`0OOomo
o`39Ool01000Oomoo`000Goo001kOol401l8Ool00`00Oomoo`0=Ool00`0OOomoo`39Ool5000007mo
o`@07`Aoo`8000ioo`0301moogoo0<ioo`00Pgoo0P0O0Woo00<007ooOol03Goo00<07gooOol0cWoo
0025Ool201l00`00Oomoo`0=Ool00`0OOomoo`3>Ool008Moo`0301moogoo00eoo`0301moogoo0<io
o`00Qgoo00<0000O01l03Goo00<07gooOol0cWoo0027Ool01000Oomoo`0O37oo00<07gooOol0cWoo
0027Ool01@00Oomoogoo01l02goo00<07gooOol0cWoo0027Ool20003Ool00`0OOomoo`08Ool00`0O
Oomoo`3>Ool008Moo`03001oogoo009oo`0301moogoo00Qoo`0301moogoo0<ioo`00Qgoo00<007oo
Ool00goo00<07gooOol01goo00<07gooOol0cWoo0027Ool00`00Oomoo`03Ool00`0OOomoo`07Ool0
0`0OOomoo`3>Ool008Moo`03001oogoo00Aoo`0301moogoo00Ioo`0301moogoo0<ioo`00Qgoo00<0
07ooOol01Goo00<07gooOol01Goo00<07gooOol0cWoo0027Ool00`00Oomoo`05Ool00`0OOomoo`05
Ool00`0OOomoo`3>Ool008Moo`8000Ioo`0301moogoo00Eoo`0301moogoo0<ioo`00Qgoo00<007oo
Ool01Woo00<07gooOol017oo00<07gooOol0cWoo0027Ool00`00Oomoo`06Ool00`0OOomoo`04Ool0
0`0OOomoo`3>Ool008Moo`03001oogoo00Ioo`0301moogoo00Aoo`0301moogoo0<ioo`00Qgoo00<0
07ooOol01Woo00<07gooOol017oo00<07gooOol0cWoo0027Ool00`00Oomoo`07Ool00`0OOomoo`03
Ool00`0OOomoo`3>Ool008Moo`03001oogoo00Moo`0301moogoo00=oo`0301moogoo0<ioo`00Qgoo
0P0027oo00<07gooOol00goo00<07gooOol0cWoo0027Ool00`00Oomoo`07Ool00`0OOomoo`03Ool0
0`0OOomoo`3>Ool008Moo`03001oogoo00Moo`0301moogoo00=oo`0301moogoo0<ioo`00OGoo1@00
1Goo00<007ooOol027oo00<07gooOol00Woo00<07gooOol0cWoo001oOol00`00Oomoo`05Ool00`00
Oomoo`08Ool00`0OOomoo`02Ool00`0OOomoo`3>Ool007moo`03001oogoo00Eoo`03001oogoo00Qo
o`0301moogoo009oo`0301moogoo0<ioo`00Ogoo00<007ooOol01Goo0`0027oo00<07gooOol00Woo
00<07gooOol0cWoo001oOol00`00Oomoo`05Ool00`00Oomoo`08Ool00`0OOomoo`02Ool00`0OOomo
o`3>Ool007moo`03001oogoo00Eoo`03001oogoo00Qoo`0301moogoo009oo`0301moogoo0<ioo`00
OGoo0`001goo00<007ooOol027oo00<07gooOol00Woo00<07gooOol0cWoo001oOol00`00Oomoo`05
Ool00`00Oomoo`08Ool00`0OOomoo`02Ool00`0OOomoo`3>Ool008Moo`03001oogoo00Uoo`0501mo
ogooOol07`3@Ool008Moo`03001oogoo00Uoo`0501moogooOol07`3@Ool008Moo`8000Yoo`0501mo
ogooOol07`3@Ool008Moo`03001oogoo00Uoo`0501moogooOol07`3@Ool008Moo`03001oogoo00Uo
o`0501moogooOol07`3@Ool008Moo`03001oogoo00Uoo`0501moogooOol07`3@Ool008Moo`03001o
ogoo00Uoo`0501moogooOol07`3@Ool008Moo`03001oogoo00Uoo`0501moogooOol07`3@Ool008Mo
o`03001oogoo00Uoo`0501moogooOol07`3@Ool008Moo`8000Yoo`0501moogooOol07`3@Ool008Mo
o`03001oogoo00Uoo`0501moogooOol07`3@Ool008Moo`03001oogoo00Uoo`0501moogooOol07`3@
Ool008Moo`03001oogoo00Yoo`0401moogoo01o@Ool008Moo`03001oogoo00Yoo`0401moogoo01o@
Ool008Moo`03001oogoo00Yoo`0401moogoo01o@Ool008Moo`03001oogoo00Yoo`0401moogoo01o@
Ool008Moo`8000]oo`0401moogoo01o@Ool008Moo`03001oogoo00Yoo`0401moogoo01o@Ool008Mo
o`03001oogoo00Yoo`0401moogoo01o@Ool008Moo`03001oogoo00Yoo`0401moogoo01o@Ool008Mo
o`03001oogoo00Yoo`0401moogoo01o@Ool008Moo`03001oogoo00Yoo`0401moogoo01o@Ool008Mo
o`03001oogoo00Yoo`0401moogoo01o@Ool008Moo`8000]oo`0401moogoo01o@Ool008Moo`03001o
ogoo00Yoo`0401moogoo01o@Ool008Moo`03001oogoo00Yoo`0401moogoo01o@Ool008Moo`03001o
ogoo00Yoo`0401moogoo01o@Ool007aoo`D000Ioo`03001oogoo00Yoo`0401moogoo01o@Ool007ao
o`05001oogooOol00006Ool00`00Oomoo`0:Ool0100OOomoo`0Od7oo001mOol00`00Oomoo`07Ool0
0`00Oomoo`0:Ool0100OOomoo`0Od7oo001nOol00`00Oomoo`06Ool3000:Ool0100OOomoo`0Od7oo
001oOol00`00Oomoo`05Ool00`00Oomoo`0:Ool0100OOomoo`0Od7oo0020Ool00`00Oomoo`04Ool0
0`00Oomoo`0:Ool0100OOomoo`0Od7oo001lOol01@00Oomoogoo00001Woo00<007ooOol02goo00<0
7goo01l0d7oo001mOol30007Ool00`00Oomoo`0;Ool00`0OOol07`3@Ool008Moo`03001oogoo00]o
o`0301moo`0O0=1oo`00Qgoo0P0037oo00<07goo01l0d7oo0027Ool00`00Oomoo`0;Ool00`0OOol0
7`3@Ool008Moo`03001oogoo00]oo`0301moo`0O0=1oo`00Qgoo00<007ooOol02goo00<07goo01l0
d7oo0027Ool00`00Oomoo`0;Ool00`0OOol07`3@Ool008Moo`03001oogoo00]oo`0301moo`0O0=1o
o`00Qgoo00<007ooOol02goo00<07goo01l0d7oo0027Ool2000<Ool00`0OOol07`3@Ool008Moo`03
001oogoo00]oo`0301moo`0O0=1oo`00Qgoo00<007ooOol02goo00<07goo01l0d7oo0027Ool00`00
Oomoo`0;Ool00`0OOol07`3@Ool008Moo`03001oogoo00]oo`0301moo`0O0=1oo`00Qgoo00<007oo
Ool02goo00<07goo01l0d7oo0027Ool00`00Oomoo`0;Ool00`0OOol07`3@Ool008Moo`8000aoo`03
01moo`0O0=1oo`00Qgoo00<007ooOol02goo00<07goo01l0d7oo0027Ool00`00Oomoo`0;Ool00`0O
Ool07`3@Ool008Moo`03001oogoo00]oo`0301moo`0O0=1oo`00Qgoo00<007ooOol02goo00<07goo
01l0d7oo0027Ool00`00Oomoo`0;Ool00`0OOol07`3@Ool008Moo`03001oogoo00]oo`0301moo`0O
0=1oo`00Qgoo0P0037oo00<07goo01l0d7oo0027Ool00`00Oomoo`0;Ool00`0OOol07`3@Ool008Mo
o`03001oogoo00]oo`0301moo`0O0=1oo`00Qgoo00<007ooOol02goo00<07goo01l0d7oo001mOol3
0007Ool00`00Oomoo`0;Ool00`0OOol07`3@Ool007aoo`05001oogooOol00006Ool00`00Oomoo`0;
Ool00`0OOol07`3@Ool0081oo`03001oogoo00Aoo`03001oogoo00]oo`0301moo`0O0=1oo`00P7oo
00<007ooOol017oo0`002goo00<07goo01l0d7oo001nOol2003XOol0081oo`03001oogoo0>Eoo`00
O7oo00D007ooOomoo`000>Moo`00OGoo0`00j7oo003oOomYOol00?moofUoo`00ogooJGoo003oOomY
Ool00?moofUoo`00R7oo0`0000Aoo`0000000=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31195 m
.04057 .31224 L
.08481 .31264 L
.12636 .3131 L
.16632 .31368 L
.18859 .31408 L
.20885 .31451 L
.2498 .31565 L
.2699 .3164 L
.29172 .31744 L
.31255 .31874 L
.32319 .31957 L
.33463 .32064 L
.34534 .32185 L
.35514 .32322 L
.36444 .3248 L
.37436 .32694 L
.3847 .32989 L
.39429 .33365 L
.40017 .3367 L
.4057 .34036 L
.41068 .34458 L
.41605 .35065 L
.41854 .35422 L
.42121 .3588 L
.42603 .36993 L
.42898 .37957 L
.43176 .392 L
.43427 .4076 L
.43568 .41932 L
.43699 .43294 L
.43825 .44976 L
.43962 .47387 L
.4409 .50567 L
.44209 .54794 L
s
.44209 .54794 m
.44331 .61803 L
s
.4471 .61803 m
.44714 0 L
s
.45185 0 m
.45191 .00609 L
.45318 .07465 L
.45395 .10285 L
.45467 .12398 L
.45604 .15383 L
.4575 .17679 L
.45911 .19515 L
.46051 .2075 L
.4618 .2167 L
.4647 .23237 L
.46726 .24234 L
.46997 .25039 L
.47466 .26055 L
.47732 .26489 L
.4798 .26829 L
.48537 .27429 L
.49044 .2784 L
.4963 .28208 L
.50184 .28483 L
.512 .28864 L
.52278 .29156 L
.53199 .29347 L
.54214 .29514 L
.56249 .2976 L
.57393 .29863 L
.58441 .29942 L
.606 .30073 L
.62607 .30166 L
.66614 .30301 L
.68766 .30355 L
.70719 .30396 L
.74922 .30467 L
.78967 .30518 L
.83269 .30561 L
.87412 .30594 L
.91395 .3062 L
.95636 .30644 L
.99718 .30663 L
1 .30664 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<001Eoo`807lMoo`00OWoo0P001goo00<007ooOol05Goo0P0O
agoo0020Ool00`00Oomoo`04Ool00`00Oomoo`0EOol201o7Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`0EOol201o7Ool007eoo`<000Moo`03001oogoo01Eoo`807lMoo`00Qgoo00<007ooOol0
5Goo0P0Oagoo0027Ool00`00Oomoo`0EOol201o7Ool008Moo`8001Ioo`807lMoo`00Qgoo00<007oo
Ool05Goo0P0Oagoo0027Ool00`00Oomoo`0EOol201o7Ool008Moo`03001oogoo01Eoo`807lMoo`00
Qgoo00<007ooOol05Goo0P0Oagoo0027Ool00`00Oomoo`0EOol201o7Ool008Moo`8001Ioo`807lMo
o`00Qgoo00<007ooOol05Goo00<07goo01l0aWoo0027Ool00`00Oomoo`0EOol00`0OOol07`36Ool0
08Moo`03001oogoo01Eoo`0301moo`0O0<Ioo`00Qgoo00<007ooOol05Goo00<07goo01l0aWoo0027
Ool00`00Oomoo`0EOol00`0OOol07`36Ool008Moo`03001oogoo01Eoo`0301moo`0O0<Ioo`00Qgoo
0P005Woo00<07goo01l0aWoo0027Ool00`00Oomoo`0EOol00`0OOol07`36Ool008Moo`03001oogoo
01Eoo`0301moo`0O0<Ioo`00Qgoo00<007ooOol05Goo00<07goo01l0aWoo0027Ool00`00Oomoo`0E
Ool00`0OOol07`36Ool008Moo`03001oogoo01Eoo`0301moo`0O0<Ioo`00Qgoo00<007ooOol05Goo
00<07goo01l0aWoo0027Ool2000FOol00`0OOol07`36Ool008Moo`03001oogoo01Eoo`0301moo`0O
0<Ioo`00Qgoo00<007ooOol05Goo00<07goo01l0aWoo0027Ool00`00Oomoo`0EOol00`0OOol07`36
Ool007aoo`D000Ioo`03001oogoo01Eoo`0301moo`0O0<Ioo`00O7oo00D007ooOomoo`0000Ioo`03
001oogoo01Eoo`0301moo`0O0<Ioo`00OGoo00<007ooOol01goo00<007ooOol05Goo00<07goo01l0
aWoo001dOol60004Ool00`00Oomoo`06Ool3000EOol00`0OOol07`36Ool007moo`03001oogoo00Eo
o`03001oogoo01Eoo`0301moo`0O0<Ioo`00P7oo00<007ooOol017oo00<007ooOol05Goo00<07goo
01l0aWoo001lOol01@00Oomoogoo00001Woo00<007ooOol05Goo00<07goo01l0aWoo001mOol30007
Ool00`00Oomoo`0EOol00`0OOol07`36Ool008Moo`03001oogoo01Eoo`0301moo`0O0<Ioo`00Qgoo
00<007ooOol05Goo00<07goo01l0aWoo0027Ool2000FOol00`0OOol07`36Ool008Moo`03001oogoo
01Eoo`0301moo`0O0<Ioo`00Qgoo00<007ooOol05Goo00<07goo01l0aWoo0027Ool00`00Oomoo`0E
Ool00`0OOol07`36Ool008Moo`03001oogoo01Eoo`0301moo`0O0<Ioo`00Qgoo00<007ooOol05Goo
00@07gooOol07lEoo`00Qgoo00<007ooOol05Goo00@07gooOol07lEoo`00Qgoo0P005Woo00@07goo
Ool07lEoo`00Qgoo00<007ooOol05Goo00@07gooOol07lEoo`00Qgoo00<007ooOol05Goo00@07goo
Ool07lEoo`00Qgoo00<007ooOol05Goo00@07gooOol07lEoo`00Qgoo00<007ooOol05Goo00@07goo
Ool07lEoo`00Qgoo00<007ooOol05Goo00@07gooOol07lEoo`00Qgoo0P005Woo00@07gooOol07lEo
o`00Qgoo00<007ooOol05Goo00@07gooOol07lEoo`00Qgoo00<007ooOol05Goo00@07gooOol07lEo
o`00Qgoo00<007ooOol05Goo00@07gooOol07lEoo`00Qgoo00<007ooOol05Goo00@07gooOol07lEo
o`00Qgoo00<007ooOol05Goo00@07gooOol07lEoo`00Qgoo00<007ooOol05Goo00@07gooOol07lEo
o`00Qgoo0P005Woo00D07gooOomoo`0O0<Aoo`00Qgoo00<007ooOol05Goo00D07gooOomoo`0O0<Ao
o`00Qgoo00<007ooOol05Goo00D07gooOomoo`0O0<Aoo`00Qgoo00<007ooOol05Goo00D07gooOomo
o`0O0<Aoo`00OGoo1@001Goo00<007ooOol05Goo00D07gooOomoo`0O0<Aoo`00Ogoo00<007ooOol0
1Goo00<007ooOol05Goo00D07gooOomoo`0O0<Aoo`00Ogoo00<007ooOol01Goo00<007ooOol05Goo
00D07gooOomoo`0O0<Aoo`00M7oo1P001Goo00<007ooOol01Goo0`005Goo00D07gooOomoo`0O0<Ao
o`00Ogoo00<007ooOol01Goo00<007ooOol05Goo00D07gooOomoo`0O0<Aoo`00Ogoo00<007ooOol0
1Goo00<007ooOol05Goo00D07gooOomoo`0O0<Aoo`00OGoo0`001goo00<007ooOol05Goo00D07goo
Oomoo`0O0<Aoo`00Ogoo00<007ooOol01Goo00<007ooOol05Goo00D07gooOomoo`0O0<Aoo`00Qgoo
00<007ooOol05Goo00D07gooOomoo`0O0<Aoo`00Qgoo00<007ooOol05Goo00D07gooOomoo`0O0<Ao
o`00Qgoo0P005Woo00<07gooOol00Woo00<07gooOol0`Goo0027Ool00`00Oomoo`0EOol00`0OOomo
o`02Ool00`0OOomoo`31Ool008Moo`03001oogoo01Eoo`0301moogoo009oo`0301moogoo0<5oo`00
Qgoo00<007ooOol05Goo00<07gooOol00Woo00<07gooOol0`Goo0027Ool00`00Oomoo`0EOol00`0O
Oomoo`03Ool00`0OOomoo`30Ool008Moo`03001oogoo01Eoo`0301moogoo00=oo`0301moogoo0<1o
o`00Qgoo00<007ooOol05Goo00<07gooOol00goo00<07gooOol0`7oo0027Ool2000FOol00`0OOomo
o`04Ool00`0OOomoo`2oOol008Moo`03001oogoo01Eoo`0301moogoo00Aoo`0301moogoo0;moo`00
Qgoo00<007ooOol05Goo00<07gooOol01Goo00<07gooOol0_Woo0027Ool00`00Oomoo`0EOol00`0O
Oomoo`05Ool00`0OOomoo`2nOol008Moo`03001oogoo01Eoo`0301moogoo00Ioo`0301moogoo0;eo
o`0037oo0`009Woo1@009Goo1@008goo00<007ooOol05Goo00<07gooOol01goo00<07gooOol00Woo
1@0097oo1@009Goo0`00:7oo0`009Goo100047oo000;Ool01@00Oomoogoo00009Goo00D007ooOomo
o`0002Moo`03001oogoo02=oo`03001oogoo01Eoo`0301moogoo00Moo`0301moogoo00Aoo`03001o
ogoo02Aoo`05001oogooOol0000TOol01@00Oomoogoo0000:7oo00<007ooOol08goo00<007ooOol0
0Woo00<007ooOol03Goo000?Ool00`00Oomoo`0TOol00`00Oomoo`0XOol00`00Oomoo`0SOol2000F
Ool00`0OOomoo`07Ool00`0OOomoo`04Ool00`00Oomoo`0UOol00`00Oomoo`0YOol00`00Oomoo`0V
Ool00`00Oomoo`0XOol00`00Oomoo`0=Ool000=oo`H000Ioo`03001oogoo01]oo`H000Aoo`03001o
ogoo01aoo`H000Eoo`03001oogoo02=oo`03001oogoo01Eoo`0301moogoo00Qoo`0301moogoo00=o
o`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo029oo`H002Uoo`03001oogoo00eoo`003Goo
0P00:Goo00<007ooOol09Woo00<007ooOol08goo00<007ooOol05Goo00<07gooOol02Goo00<07goo
Ool00Woo00<007ooOol09goo00<007ooOol09Goo0P009Woo00@007ooOol002Ioo`@0011oo`003goo
00<007ooOol09goo00<007ooOol09Goo00<007ooOol08goo00<007ooOol05Goo00<07gooOol02Woo
0P0O0Woo00<007ooOol0:7oo00<007ooOol09Woo00<007ooOol08goo00@007ooOol002Ioo`03001o
ogoo015oo`002goo00D007ooOomoo`0002Eoo`05001oogooOol0000UOol3000UOol00`00Oomoo`0E
Ool00`0OOomoo`0<Ool201l00`00Oomoo`0TOol01@00Oomoogoo000097oo00D007ooOomoo`0002Io
o`03001oo`0002Ioo`03001oogoo015oo`0037oo0`009goo0`00:7oo00<007ooOol08goo00<007oo
Ool05Goo00<07gooOol03Woo0`0O9Goo0`009Woo0`00:7oo0P009Woo1@003goo0027Ool2000FOol0
0`0OOomoo`0AOol301nbOol008Moo`03001oogoo01Eoo`0301moogoo01Aoo`@07jioo`00Qgoo00<0
07ooOol05Goo00<07gooOol067oo0`0OZgoo0027Ool00`00Oomoo`0EOol00`0OOomoo`0KOol:01nQ
Ool008Moo`03001oogoo01Eoo`0301moogoo02Eooa007i5oo`00Qgoo00<007ooOol05Goo00<07goo
Ool0=Goo6`0OMWoo0027Ool00`00Oomoo`0EOol00`0OOomoo`1@OomU01lAOol000YooiD0000301l0
00000;D0015oo`002Woo8`0O1goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<0
7`00Ool01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol02Woo1@00000:Ool00`00Oomoo`0POold01lVOol0
0`00Oomoo`0EOol00`0OOomoo`0>Ool00`00Oomoo`0WOol00`00Oomoo`0VOol00`00Oomoo`0VOol0
0`00Oomoo`0WOol00`00Oomoo`0:Ool01000Oomoogoo0@00001QOolC01lCOol00`00Oomoo`0EOol0
0`0OOomoo`32Ool00`00Oomoo`01Ool007Aoo`/07`Qoo`03001oogoo01Eoo`0301moogoo0<=oo`40
005oo`5oo`00Ogoo1P0O0Woo00<007ooOol05Goo00<07gooOol0`Goo00@007ooOol0005oo`00QGoo
0`0O5goo00<07gooOol0`Goo1@000027Ool00`0001l07`0201lCOol00`0OOomoo`36Ool008Moo`03
001oogoo009oo`807a5oo`0301moogoo0<Ioo`00Qgoo00<007ooOol017oo0P0O3goo00<07gooOol0
aWoo0027Ool00`00Oomoo`06Ool00`0OOomoo`0<Ool00`0OOomoo`36Ool008Moo`03001oogoo00Mo
o`0301moogoo00]oo`0301moogoo0<Ioo`00Qgoo00<007ooOol027oo00<07gooOol02Woo00<07goo
Ool0aWoo0027Ool00`00Oomoo`09Ool00`0OOomoo`09Ool00`0OOomoo`36Ool008Moo`8000]oo`03
01moogoo00Qoo`0301moogoo0<Ioo`00Qgoo00<007ooOol02goo00<07gooOol01goo00<07gooOol0
aWoo0027Ool00`00Oomoo`0<Ool00`0OOomoo`06Ool00`0OOomoo`36Ool008Moo`03001oogoo00ao
o`0301moogoo00Ioo`0301moogoo0<Ioo`00Qgoo00<007ooOol03Goo00<07gooOol01Goo00<07goo
Ool0aWoo0027Ool00`00Oomoo`0=Ool00`0OOomoo`05Ool00`0OOomoo`36Ool008Moo`03001oogoo
00ioo`0301moogoo00Aoo`0301moogoo0<Ioo`00Qgoo0P003goo00<07gooOol017oo00<07gooOol0
aWoo0027Ool00`00Oomoo`0?Ool00`0OOomoo`03Ool00`0OOomoo`36Ool008Moo`03001oogoo00mo
o`0301moogoo00=oo`0301moogoo0<Ioo`00Qgoo00<007ooOol03goo00<07gooOol00goo00<07goo
Ool0aWoo0027Ool00`00Oomoo`0?Ool00`0OOomoo`03Ool00`0OOomoo`36Ool008Moo`03001oogoo
00moo`0301moogoo00=oo`0301moogoo0<Ioo`00Qgoo00<007ooOol03goo00<07gooOol00goo00<0
7gooOol0aWoo0027Ool2000@Ool00`0OOomoo`03Ool00`0OOomoo`36Ool008Moo`03001oogoo00mo
o`0301moogoo00=oo`0301moogoo0<Ioo`00Qgoo00<007ooOol03goo00<07gooOol00goo00<07goo
Ool0aWoo001mOol50005Ool00`00Oomoo`0@Ool00`0OOomoo`02Ool00`0OOomoo`36Ool007moo`03
001oogoo00Eoo`03001oogoo011oo`0301moogoo009oo`0301moogoo0<Ioo`00Ogoo00<007ooOol0
1Goo00<007ooOol047oo00<07gooOol00Woo00<07gooOol0aWoo001oOol00`00Oomoo`05Ool3000@
Ool00`0OOomoo`02Ool00`0OOomoo`36Ool007moo`03001oogoo00Eoo`03001oogoo015oo`0501mo
ogooOol07`38Ool007moo`03001oogoo00Eoo`03001oogoo015oo`0501moogooOol07`38Ool007eo
o`<000Moo`03001oogoo015oo`0501moogooOol07`38Ool007moo`03001oogoo00Eoo`03001oogoo
015oo`0501moogooOol07`38Ool008Moo`03001oogoo015oo`0501moogooOol07`38Ool008Moo`03
001oogoo015oo`0501moogooOol07`38Ool008Moo`80019oo`0501moogooOol07`38Ool008Moo`03
001oogoo015oo`0501moogooOol07`38Ool008Moo`03001oogoo015oo`0501moogooOol07`38Ool0
08Moo`03001oogoo019oo`0401moogoo01o8Ool008Moo`03001oogoo019oo`0401moogoo01o8Ool0
08Moo`03001oogoo019oo`0401moogoo01o8Ool008Moo`03001oogoo019oo`0401moogoo01o8Ool0
08Moo`8001=oo`0401moogoo01o8Ool008Moo`03001oogoo019oo`0401moogoo01o8Ool008Moo`03
001oogoo019oo`0401moogoo01o8Ool008Moo`03001oogoo019oo`0401moogoo01o8Ool008Moo`03
001oogoo019oo`0401moogoo01o8Ool008Moo`03001oogoo019oo`0401moogoo01o8Ool008Moo`03
001oogoo019oo`0401moogoo01o8Ool008Moo`8001=oo`0401moogoo01o8Ool008Moo`03001oogoo
019oo`0401moogoo01o8Ool008Moo`03001oogoo019oo`0401moogoo01o8Ool008Moo`03001oogoo
019oo`0401moogoo01o8Ool008Moo`03001oogoo019oo`0401moogoo01o8Ool008Moo`03001oogoo
01=oo`0301moo`0O0<Qoo`00Qgoo00<007ooOol04goo00<07goo01l0b7oo0027Ool2000DOol00`0O
Ool07`38Ool008Moo`03001oogoo01=oo`0301moo`0O0<Qoo`00Qgoo00<007ooOol04goo00<07goo
01l0b7oo0027Ool00`00Oomoo`0COol00`0OOol07`38Ool007aoo`D000Ioo`03001oogoo01=oo`03
01moo`0O0<Qoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo01=oo`0301moo`0O0<Qoo`00OGoo
00<007ooOol01goo00<007ooOol04goo00<07goo01l0b7oo001nOol00`00Oomoo`06Ool3000COol0
0`0OOol07`38Ool007moo`03001oogoo00Eoo`03001oogoo01=oo`0301moo`0O0<Qoo`00P7oo00<0
07ooOol017oo00<007ooOol04goo00<07goo01l0b7oo001lOol01@00Oomoogoo00001Woo00<007oo
Ool04goo00<07goo01l0b7oo001mOol30007Ool00`00Oomoo`0COol00`0OOol07`38Ool008Moo`03
001oogoo01=oo`0301moo`0O0<Qoo`00Qgoo0P0057oo00<07goo01l0b7oo0027Ool00`00Oomoo`0C
Ool00`0OOol07`38Ool008Moo`03001oogoo01=oo`0301moo`0O0<Qoo`00Qgoo00<007ooOol04goo
00<07goo01l0b7oo0027Ool00`00Oomoo`0COol00`0OOol07`38Ool008Moo`03001oogoo01=oo`03
01moo`0O0<Qoo`00Qgoo00<007ooOol04goo00<07goo01l0b7oo0027Ool2000DOol00`0OOol07`38
Ool008Moo`03001oogoo01=oo`0301moo`0O0<Qoo`00Qgoo00<007ooOol04goo00<07goo01l0b7oo
0027Ool00`00Oomoo`0COol00`0OOol07`38Ool008Moo`03001oogoo01=oo`0301moo`0O0<Qoo`00
Qgoo00<007ooOol04goo00<07goo01l0b7oo0027Ool00`00Oomoo`0COol00`0OOol07`38Ool008Mo
o`8001Aoo`0301moo`0O0<Qoo`00Qgoo00<007ooOol04goo00<07goo01l0b7oo0027Ool00`00Oomo
o`0COol00`0OOol07`38Ool008Moo`03001oogoo01=oo`0301moo`0O0<Qoo`00Qgoo00<007ooOol0
4goo00<07goo01l0b7oo0027Ool00`00Oomoo`0COol00`0OOol07`38Ool008Moo`03001oogoo01=o
o`0301moo`0O0<Qoo`00Qgoo0P0057oo00<07goo01l0b7oo0027Ool00`00Oomoo`0COol00`0OOol0
7`38Ool008Moo`03001oogoo01=oo`0301moo`0O0<Qoo`00Qgoo00<007ooOol04goo00<07goo01l0
b7oo001mOol30007Ool00`00Oomoo`0COol00`0OOol07`38Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`0COol00`0OOol07`38Ool0081oo`03001oogoo00Aoo`03001oogoo01=oo`0301moo`0O
0<Qoo`00P7oo00<007ooOol017oo0`004goo00<07goo01l0b7oo001nOol2003XOol0081oo`03001o
ogoo0>Eoo`00O7oo00D007ooOomoo`000>Moo`00OGoo0`00j7oo003oOomYOol00?moofUoo`00ogoo
JGoo003oOomYOol00?moofUoo`00R7oo0`0000Aoo`0000000=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31179 m
.04057 .31206 L
.08481 .3124 L
.12636 .31281 L
.16632 .3133 L
.20885 .31399 L
.2498 .31491 L
.27217 .31557 L
.29331 .31634 L
.31429 .31731 L
.33365 .31846 L
.35331 .32002 L
.36449 .32116 L
.37497 .32246 L
.38587 .32415 L
.39623 .32621 L
.40553 .32859 L
.41568 .33208 L
.42126 .33459 L
.42651 .33751 L
.43129 .3408 L
.43633 .34523 L
.44184 .35172 L
.44691 .36015 L
.44973 .36647 L
.45237 .37395 L
.45526 .38479 L
.45688 .3926 L
.45835 .40129 L
.46075 .42 L
.46212 .4345 L
.4634 .45203 L
.46475 .47661 L
.46598 .50796 L
.46734 .55938 L
.46802 .59678 L
s
.46802 .59678 m
.4683 .61803 L
s
.47365 .61803 m
.4737 0 L
s
.47689 0 m
.47715 .022 L
.47839 .08329 L
.47974 .12585 L
.48098 .15276 L
.4824 .17542 L
.48376 .19159 L
.48616 .21235 L
.48751 .22114 L
.48877 .22797 L
.49168 .24029 L
.4943 .2486 L
.49734 .25601 L
.50019 .26148 L
.5051 .26865 L
.51047 .27438 L
.51608 .27885 L
.52132 .28209 L
.53069 .28643 L
.54072 .28976 L
.55143 .29237 L
.56307 .29451 L
.57312 .29596 L
.58421 .29726 L
.60501 .29911 L
.62708 .30052 L
.64744 .30151 L
.66935 .30235 L
.69002 .30298 L
.7126 .30355 L
.75426 .30436 L
.79691 .30497 L
.83796 .30542 L
.88159 .30581 L
.92362 .30611 L
.96407 .30635 L
1 .30653 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<001eoo`807kmoo`00OWoo0P001goo00<007ooOol07Goo0P0O
_goo0020Ool00`00Oomoo`04Ool00`00Oomoo`0MOol201noOol007aoo`05001oogooOol00006Ool0
0`00Oomoo`0MOol201noOol007eoo`<000Moo`03001oogoo01eoo`0301moo`0O0;ioo`00Qgoo00<0
07ooOol07Goo00<07goo01l0_Woo0027Ool00`00Oomoo`0MOol00`0OOol07`2nOol008Moo`8001io
o`0301moo`0O0;ioo`00Qgoo00<007ooOol07Goo00<07goo01l0_Woo0027Ool00`00Oomoo`0MOol0
0`0OOol07`2nOol008Moo`03001oogoo01eoo`0301moo`0O0;ioo`00Qgoo00<007ooOol07Goo00<0
7goo01l0_Woo0027Ool00`00Oomoo`0MOol00`0OOol07`2nOol008Moo`8001ioo`0301moo`0O0;io
o`00Qgoo00<007ooOol07Goo00<07goo01l0_Woo0027Ool00`00Oomoo`0MOol00`0OOol07`2nOol0
08Moo`03001oogoo01eoo`0301moo`0O0;ioo`00Qgoo00<007ooOol07Goo00<07goo01l0_Woo0027
Ool00`00Oomoo`0MOol00`0OOol07`2nOol008Moo`03001oogoo01eoo`0301moo`0O0;ioo`00Qgoo
0P007Woo00<07goo01l0_Woo0027Ool00`00Oomoo`0MOol00`0OOol07`2nOol008Moo`03001oogoo
01eoo`0301moo`0O0;ioo`00Qgoo00<007ooOol07Goo00<07goo01l0_Woo0027Ool00`00Oomoo`0M
Ool00`0OOol07`2nOol008Moo`03001oogoo01eoo`0301moo`0O0;ioo`00Qgoo00<007ooOol07Goo
00<07goo01l0_Woo0027Ool2000NOol00`0OOol07`2nOol008Moo`03001oogoo01eoo`0301moo`0O
0;ioo`00Qgoo00<007ooOol07Goo00<07goo01l0_Woo0027Ool00`00Oomoo`0MOol00`0OOol07`2n
Ool007aoo`D000Ioo`03001oogoo01eoo`0301moo`0O0;ioo`00O7oo00D007ooOomoo`0000Ioo`03
001oogoo01eoo`0301moo`0O0;ioo`00OGoo00<007ooOol01goo00<007ooOol07Goo00<07goo01l0
_Woo001dOol60004Ool00`00Oomoo`06Ool3000MOol00`0OOol07`2nOol007moo`03001oogoo00Eo
o`03001oogoo01eoo`0301moo`0O0;ioo`00P7oo00<007ooOol017oo00<007ooOol07Goo00<07goo
01l0_Woo001lOol01@00Oomoogoo00001Woo00<007ooOol07Goo00<07goo01l0_Woo001mOol30007
Ool00`00Oomoo`0MOol00`0OOol07`2nOol008Moo`03001oogoo01eoo`0301moo`0O0;ioo`00Qgoo
00<007ooOol07Goo00<07goo01l0_Woo0027Ool2000NOol00`0OOol07`2nOol008Moo`03001oogoo
01eoo`0301moo`0O0;ioo`00Qgoo00<007ooOol07Goo00<07goo01l0_Woo0027Ool00`00Oomoo`0M
Ool00`0OOol07`2nOol008Moo`03001oogoo01eoo`0301moo`0O0;ioo`00Qgoo00<007ooOol07Goo
00@07gooOol07keoo`00Qgoo00<007ooOol07Goo00@07gooOol07keoo`00Qgoo0P007Woo00@07goo
Ool07keoo`00Qgoo00<007ooOol07Goo00@07gooOol07keoo`00Qgoo00<007ooOol07Goo00@07goo
Ool07keoo`00Qgoo00<007ooOol07Goo00@07gooOol07keoo`00Qgoo00<007ooOol07Goo00@07goo
Ool07keoo`00Qgoo00<007ooOol07Goo00@07gooOol07keoo`00Qgoo0P007Woo00@07gooOol07keo
o`00Qgoo00<007ooOol07Goo00@07gooOol07keoo`00Qgoo00<007ooOol07Goo00@07gooOol07keo
o`00Qgoo00<007ooOol07Goo00@07gooOol07keoo`00Qgoo00<007ooOol07Goo00@07gooOol07keo
o`00Qgoo00<007ooOol07Goo00@07gooOol07keoo`00Qgoo00<007ooOol07Goo00@07gooOol07keo
o`00Qgoo0P007Woo00D07gooOomoo`0O0;aoo`00Qgoo00<007ooOol07Goo00D07gooOomoo`0O0;ao
o`00Qgoo00<007ooOol07Goo00D07gooOomoo`0O0;aoo`00Qgoo00<007ooOol07Goo00D07gooOomo
o`0O0;aoo`00OGoo1@001Goo00<007ooOol07Goo00D07gooOomoo`0O0;aoo`00Ogoo00<007ooOol0
1Goo00<007ooOol07Goo00D07gooOomoo`0O0;aoo`00Ogoo00<007ooOol01Goo00<007ooOol07Goo
00<07gooOol00Woo00<07gooOol0^Goo001dOol60005Ool00`00Oomoo`05Ool3000MOol00`0OOomo
o`02Ool00`0OOomoo`2iOol007moo`03001oogoo00Eoo`03001oogoo01eoo`0301moogoo009oo`03
01moogoo0;Uoo`00Ogoo00<007ooOol01Goo00<007ooOol07Goo00<07gooOol00Woo00<07gooOol0
^Goo001mOol30007Ool00`00Oomoo`0MOol00`0OOomoo`02Ool00`0OOomoo`2iOol007moo`03001o
ogoo00Eoo`03001oogoo01eoo`0301moogoo009oo`0301moogoo0;Uoo`00Qgoo00<007ooOol07Goo
00<07gooOol00Woo00<07gooOol0^Goo0027Ool00`00Oomoo`0MOol00`0OOomoo`02Ool00`0OOomo
o`2iOol008Moo`8001ioo`0301moogoo009oo`0301moogoo0;Uoo`00Qgoo00<007ooOol07Goo00<0
7gooOol00Woo00<07gooOol0^Goo0027Ool00`00Oomoo`0MOol00`0OOomoo`03Ool00`0OOomoo`2h
Ool008Moo`03001oogoo01eoo`0301moogoo00=oo`0301moogoo0;Qoo`00Qgoo00<007ooOol07Goo
00<07gooOol00goo00<07gooOol0^7oo0027Ool00`00Oomoo`0MOol00`0OOomoo`03Ool00`0OOomo
o`2hOol008Moo`03001oogoo01eoo`0301moogoo00Aoo`0301moogoo0;Moo`00Qgoo0P007Woo00<0
7gooOol017oo00<07gooOol0]goo0027Ool00`00Oomoo`0MOol00`0OOomoo`04Ool00`0OOomoo`2g
Ool008Moo`03001oogoo01eoo`0301moogoo00Eoo`0301moogoo0;Ioo`00Qgoo00<007ooOol07Goo
00<07gooOol01Goo00<07gooOol0]Woo0027Ool00`00Oomoo`0MOol00`0OOomoo`06Ool00`0OOomo
o`2eOol000aoo`<002Ioo`D002Eoo`D002=oo`03001oogoo01eoo`0301moogoo00Aoo`<0000301l0
07oo02=oo`D002Eoo`<002Qoo`<002Eoo`@0011oo`002goo00D007ooOomoo`0002Eoo`05001oogoo
Ool0000WOol00`00Oomoo`0SOol00`00Oomoo`0MOol00`0OOomoo`06Ool00`0001moo`0TOol01@00
Oomoogoo000097oo00D007ooOomoo`0002Qoo`03001oogoo02=oo`03001oogoo009oo`03001oogoo
00eoo`003goo00<007ooOol097oo00<007ooOol0:7oo00<007ooOol08goo0P007Woo00<07gooOol0
1Woo00<007oo01l09Goo00<007ooOol0:Goo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol0
3Goo0003Ool60006Ool00`00Oomoo`0KOol60004Ool00`00Oomoo`0LOol60005Ool00`00Oomoo`0S
Ool00`00Oomoo`0MOol00`0OOomoo`06Ool01000Oomoo`0O9Goo00<007ooOol0:7oo00<007ooOol0
8Woo1P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomoo`0VOol00`00Oomoo`0SOol00`00
Oomoo`0MOol00`0OOomoo`06Ool01@00Oomoogoo01l09Goo00<007ooOol09Goo0P009Woo00@007oo
Ool002Ioo`@0011oo`003goo00<007ooOol09goo00<007ooOol09Goo00<007ooOol08goo00<007oo
Ool07Goo00<07gooOol01Woo00<007ooOol00Woo00<07gooOol08goo00<007ooOol09Woo00<007oo
Ool08goo00@007ooOol002Ioo`03001oogoo015oo`002goo00D007ooOomoo`0002Eoo`05001oogoo
Ool0000UOol3000UOol00`00Oomoo`0MOol00`0OOomoo`04Ool30005Ool201lOOol01@00Oomoogoo
000097oo00D007ooOomoo`0002Ioo`03001oo`0002Ioo`03001oogoo015oo`0037oo0`009goo0`00
:7oo00<007ooOol08goo00<007ooOol07Goo00<07gooOol01Woo00<007ooOol01Goo0P0O7Woo0`00
9Woo0`00:7oo0P009Woo1@003goo0027Ool2000NOol00`0OOomoo`0@Ool201n/Ool008Moo`03001o
ogoo01eoo`0301moogoo019oo`@07jQoo`00Qgoo00<007ooOol07Goo00<07gooOol05Woo1`0OXGoo
0027Ool00`00Oomoo`0MOol00`0OOomoo`0MOol901nHOol008Moo`03001oogoo01eoo`0301moogoo
02Ioo`h07hYoo`00Qgoo00<007ooOol07Goo00<07gooOol0=7oo800OJWoo0027Ool00`00Oomoo`0M
Ool00`0OOomoo`1DOomI01lAOol000Yooid0000301l000000:d0015oo`002Woo<@0O00=oo`00Ool0
1Woo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
1Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Woo00<007ooOol017oo00<07`00Ool01Woo00<007ooOol01Goo00<007ooOol0
1Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
1Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol02Woo1@00000:Ool0
0`00Oomoo`0WOol00`00Oomoo`04Ool^01lNOol00`00Oomoo`0MOol00`0OOomoo`06Ool00`00Oomo
o`0WOol00`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0:Ool01000Oomo
ogoo0@00001YOolC01l;Ool00`00Oomoo`0MOol00`0OOomoo`2jOol00`00Oomoo`01Ool007aoo`T0
7`9oo`03001oogoo01eoo`0301moogoo0;]oo`40005oo`5oo`00QGoo1`0O6goo00<07gooOol0^Goo
00@007ooOol0005oo`00Qgoo00<007ooOol00Woo100O5goo00<07gooOol0^Goo1@000027Ool20007
Ool301lDOol00`0OOomoo`2nOol008Moo`03001oogoo00Uoo`807a9oo`0301moogoo0;ioo`00Qgoo
00<007ooOol02goo0P0O47oo00<07gooOol0_Woo0027Ool00`00Oomoo`0=Ool201l>Ool00`0OOomo
o`2nOol008Moo`03001oogoo00moo`0301moogoo00]oo`0301moogoo0;ioo`00Qgoo00<007ooOol0
47oo0P0O2goo00<07gooOol0_Woo0027Ool00`00Oomoo`0BOol00`0OOomoo`08Ool00`0OOomoo`2n
Ool008Moo`8001Aoo`0301moogoo00Moo`0301moogoo0;ioo`00Qgoo00<007ooOol057oo00<07goo
Ool01Woo00<07gooOol0_Woo0027Ool00`00Oomoo`0DOol00`0OOomoo`06Ool00`0OOomoo`2nOol0
08Moo`03001oogoo01Eoo`0301moogoo00Eoo`0301moogoo0;ioo`00Qgoo00<007ooOol05Goo00<0
7gooOol01Goo00<07gooOol0_Woo0027Ool00`00Oomoo`0EOol00`0OOomoo`05Ool00`0OOomoo`2n
Ool008Moo`03001oogoo01Eoo`0301moogoo00Eoo`0301moogoo0;ioo`00Qgoo0P005goo00<07goo
Ool017oo00<07gooOol0_Woo0027Ool00`00Oomoo`0FOol00`0OOomoo`04Ool00`0OOomoo`2nOol0
08Moo`03001oogoo01Ioo`0301moogoo00Aoo`0301moogoo0;ioo`00Qgoo00<007ooOol05goo00<0
7gooOol00goo00<07gooOol0_Woo0027Ool00`00Oomoo`0GOol00`0OOomoo`03Ool00`0OOomoo`2n
Ool008Moo`03001oogoo01Moo`0301moogoo00=oo`0301moogoo0;ioo`00Qgoo00<007ooOol067oo
00<07gooOol00Woo00<07gooOol0_Woo0027Ool2000IOol00`0OOomoo`02Ool00`0OOomoo`2nOol0
08Moo`03001oogoo01Qoo`0301moogoo009oo`0301moogoo0;ioo`00Qgoo00<007ooOol067oo00<0
7gooOol00Woo00<07gooOol0_Woo001mOol50005Ool00`00Oomoo`0HOol00`0OOomoo`02Ool00`0O
Oomoo`2nOol007moo`03001oogoo00Eoo`03001oogoo01Qoo`0301moogoo009oo`0301moogoo0;io
o`00Ogoo00<007ooOol01Goo00<007ooOol067oo00<07gooOol00Woo00<07gooOol0_Woo001oOol0
0`00Oomoo`05Ool3000IOol01@0OOomoogoo01l0`7oo001oOol00`00Oomoo`05Ool00`00Oomoo`0I
Ool01@0OOomoogoo01l0`7oo001oOol00`00Oomoo`05Ool00`00Oomoo`0IOol01@0OOomoogoo01l0
`7oo001mOol30007Ool00`00Oomoo`0IOol01@0OOomoogoo01l0`7oo001oOol00`00Oomoo`05Ool0
0`00Oomoo`0IOol01@0OOomoogoo01l0`7oo0027Ool00`00Oomoo`0IOol01@0OOomoogoo01l0`7oo
0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool2000KOol0100OOomoo`0O`7oo0027Ool0
0`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool0
0`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool0
0`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool2
000KOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomo
o`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomo
o`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomo
o`0JOol0100OOomoo`0O`7oo0027Ool2000KOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0
100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0
100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0100OOomoo`0O`7oo0027Ool00`00Oomoo`0JOol0
100OOomoo`0O`7oo0027Ool00`00Oomoo`0KOol00`0OOol07`30Ool008Moo`8001aoo`0301moo`0O
0<1oo`00Qgoo00<007ooOol06goo00<07goo01l0`7oo0027Ool00`00Oomoo`0KOol00`0OOol07`30
Ool008Moo`03001oogoo01]oo`0301moo`0O0<1oo`00O7oo1@001Woo00<007ooOol06goo00<07goo
01l0`7oo001lOol01@00Oomoogoo00001Woo00<007ooOol06goo00<07goo01l0`7oo001mOol00`00
Oomoo`07Ool00`00Oomoo`0KOol00`0OOol07`30Ool007ioo`03001oogoo00Ioo`<001]oo`0301mo
o`0O0<1oo`00Ogoo00<007ooOol01Goo00<007ooOol06goo00<07goo01l0`7oo0020Ool00`00Oomo
o`04Ool00`00Oomoo`0KOol00`0OOol07`30Ool007aoo`05001oogooOol00006Ool00`00Oomoo`0K
Ool00`0OOol07`30Ool007eoo`<000Moo`03001oogoo01]oo`0301moo`0O0<1oo`00Qgoo00<007oo
Ool06goo00<07goo01l0`7oo0027Ool2000LOol00`0OOol07`30Ool008Moo`03001oogoo01]oo`03
01moo`0O0<1oo`00Qgoo00<007ooOol06goo00<07goo01l0`7oo0027Ool00`00Oomoo`0KOol00`0O
Ool07`30Ool008Moo`03001oogoo01]oo`0301moo`0O0<1oo`00Qgoo00<007ooOol06goo00<07goo
01l0`7oo0027Ool00`00Oomoo`0KOol00`0OOol07`30Ool008Moo`8001aoo`0301moo`0O0<1oo`00
Qgoo00<007ooOol06goo00<07goo01l0`7oo0027Ool00`00Oomoo`0KOol00`0OOol07`30Ool008Mo
o`03001oogoo01]oo`0301moo`0O0<1oo`00Qgoo00<007ooOol06goo00<07goo01l0`7oo0027Ool0
0`00Oomoo`0KOol00`0OOol07`30Ool008Moo`03001oogoo01]oo`0301moo`0O0<1oo`00Qgoo0P00
77oo00<07goo01l0`7oo0027Ool00`00Oomoo`0LOol201o0Ool008Moo`03001oogoo01aoo`807l1o
o`00Qgoo00<007ooOol077oo0P0O`7oo0027Ool00`00Oomoo`0LOol201o0Ool008Moo`03001oogoo
01aoo`807l1oo`00Qgoo00<007ooOol077oo0P0O`7oo0027Ool2000MOol201o0Ool008Moo`03001o
ogoo01aoo`807l1oo`00Qgoo00<007ooOol077oo0P0O`7oo0027Ool00`00Oomoo`0LOol201o0Ool0
07eoo`<000Moo`03001oogoo01aoo`807l1oo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo01ao
o`807l1oo`00P7oo00<007ooOol017oo00<007ooOol077oo0P0O`7oo0020Ool00`00Oomoo`04Ool3
000LOol201o0Ool007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo0000igoo
001mOol3003XOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028Ool30000
17oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31165 m
.04057 .31189 L
.08481 .3122 L
.12636 .31255 L
.16632 .31298 L
.20885 .31356 L
.2498 .31431 L
.27066 .3148 L
.29331 .31544 L
.31326 .31614 L
.33524 .3171 L
.35607 .31829 L
.3676 .31911 L
.37815 .32001 L
.39853 .32227 L
.40977 .32396 L
.42045 .32603 L
.43052 .32859 L
.43604 .33035 L
.44125 .33232 L
.44611 .33452 L
.45137 .33742 L
.4558 .34044 L
.46055 .34447 L
.46572 .35021 L
.47053 .35755 L
.47348 .36347 L
.47626 .3706 L
.47877 .37879 L
.48149 .39059 L
.48414 .40666 L
.48564 .41899 L
.48706 .43379 L
.48855 .45431 L
.48991 .48011 L
.49062 .49768 L
.4914 .52155 L
.49222 .55389 L
.49298 .59428 L
s
.49298 .59428 m
.49325 .61803 L
s
.49729 .61803 m
.49748 0 L
s
.50193 0 m
.50233 .033 L
.50361 .09129 L
.50492 .13025 L
.50566 .1465 L
.50632 .15886 L
.50763 .17844 L
.50884 .19242 L
.51025 .20541 L
.51177 .21654 L
.51453 .23161 L
.51694 .24124 L
.51958 .24937 L
.52237 .25607 L
.52491 .26099 L
.52977 .26825 L
.53498 .27393 L
.53981 .27794 L
.54437 .28097 L
.55454 .28597 L
.55966 .28788 L
.56532 .28964 L
.57475 .29201 L
.58467 .29395 L
.5953 .29559 L
.60503 .2968 L
.62694 .29887 L
.64771 .30027 L
.66701 .30127 L
.70806 .30278 L
.73052 .30338 L
.75169 .30385 L
.79213 .30456 L
.83515 .30513 L
.87658 .30555 L
.91642 .30588 L
.95883 .30617 L
.99965 .3064 L
1 .3064 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<002Eoo`0301moo`0O0;Ioo`00OWoo0P001goo00<007ooOol0
9Goo00<07goo01l0]Woo0020Ool00`00Oomoo`04Ool00`00Oomoo`0UOol00`0OOol07`2fOol007ao
o`05001oogooOol00006Ool00`00Oomoo`0UOol00`0OOol07`2fOol007eoo`<000Moo`03001oogoo
02Eoo`0301moo`0O0;Ioo`00Qgoo00<007ooOol09Goo00<07goo01l0]Woo0027Ool00`00Oomoo`0U
Ool00`0OOol07`2fOol008Moo`8002Ioo`0301moo`0O0;Ioo`00Qgoo00<007ooOol09Goo00<07goo
01l0]Woo0027Ool00`00Oomoo`0UOol00`0OOol07`2fOol008Moo`03001oogoo02Eoo`0301moo`0O
0;Ioo`00Qgoo00<007ooOol09Goo00<07goo01l0]Woo0027Ool00`00Oomoo`0UOol00`0OOol07`2f
Ool008Moo`8002Ioo`0301moo`0O0;Ioo`00Qgoo00<007ooOol09Goo00<07goo01l0]Woo0027Ool0
0`00Oomoo`0UOol00`0OOol07`2fOol008Moo`03001oogoo02Eoo`0301moo`0O0;Ioo`00Qgoo00<0
07ooOol09Goo00<07goo01l0]Woo0027Ool00`00Oomoo`0UOol00`0OOol07`2fOol008Moo`03001o
ogoo02Eoo`0301moo`0O0;Ioo`00Qgoo0P009Woo00<07goo01l0]Woo0027Ool00`00Oomoo`0UOol0
0`0OOol07`2fOol008Moo`03001oogoo02Eoo`0301moo`0O0;Ioo`00Qgoo00<007ooOol09Goo00<0
7goo01l0]Woo0027Ool00`00Oomoo`0UOol00`0OOol07`2fOol008Moo`03001oogoo02Eoo`0301mo
o`0O0;Ioo`00Qgoo00<007ooOol09Goo00<07goo01l0]Woo0027Ool2000VOol00`0OOol07`2fOol0
08Moo`03001oogoo02Eoo`0301moo`0O0;Ioo`00Qgoo00<007ooOol09Goo00<07goo01l0]Woo0027
Ool00`00Oomoo`0UOol00`0OOol07`2fOol007aoo`D000Ioo`03001oogoo02Eoo`0301moo`0O0;Io
o`00O7oo00D007ooOomoo`0000Ioo`03001oogoo02Eoo`0301moo`0O0;Ioo`00OGoo00<007ooOol0
1goo00<007ooOol09Goo00<07goo01l0]Woo001dOol60004Ool00`00Oomoo`06Ool3000UOol00`0O
Ool07`2fOol007moo`03001oogoo00Eoo`03001oogoo02Eoo`0301moo`0O0;Ioo`00P7oo00<007oo
Ool017oo00<007ooOol09Goo00<07goo01l0]Woo001lOol01@00Oomoogoo00001Woo00<007ooOol0
9Goo00@07gooOol07kEoo`00OGoo0`001goo00<007ooOol09Goo00@07gooOol07kEoo`00Qgoo00<0
07ooOol09Goo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@07gooOol07kEoo`00Qgoo0P00
9Woo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@07gooOol07kEoo`00Qgoo00<007ooOol0
9Goo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@07gooOol07kEoo`00Qgoo00<007ooOol0
9Goo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@07gooOol07kEoo`00Qgoo00<007ooOol0
9Goo00@07gooOol07kEoo`00Qgoo0P009Woo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@0
7gooOol07kEoo`00Qgoo00<007ooOol09Goo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@0
7gooOol07kEoo`00Qgoo00<007ooOol09Goo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@0
7gooOol07kEoo`00Qgoo0P009Woo00@07gooOol07kEoo`00Qgoo00<007ooOol09Goo00@07gooOol0
7kEoo`00Qgoo00<007ooOol09Goo00D07gooOomoo`0O0;Aoo`00Qgoo00<007ooOol09Goo00D07goo
Oomoo`0O0;Aoo`00Qgoo00<007ooOol09Goo00D07gooOomoo`0O0;Aoo`00Qgoo00<007ooOol09Goo
00D07gooOomoo`0O0;Aoo`00Qgoo00<007ooOol09Goo00D07gooOomoo`0O0;Aoo`00Qgoo0P009Woo
00D07gooOomoo`0O0;Aoo`00Qgoo00<007ooOol09Goo00D07gooOomoo`0O0;Aoo`00Qgoo00<007oo
Ool09Goo00D07gooOomoo`0O0;Aoo`00Qgoo00<007ooOol09Goo00D07gooOomoo`0O0;Aoo`00OGoo
1@001Goo00<007ooOol09Goo00D07gooOomoo`0O0;Aoo`00Ogoo00<007ooOol01Goo00<007ooOol0
9Goo00<07gooOol00Woo00<07gooOol0/Goo001oOol00`00Oomoo`05Ool00`00Oomoo`0UOol00`0O
Oomoo`02Ool00`0OOomoo`2aOol007Aoo`H000Eoo`03001oogoo00Eoo`<002Eoo`0301moogoo009o
o`0301moogoo0;5oo`00Ogoo00<007ooOol01Goo00<007ooOol09Goo00<07gooOol00Woo00<07goo
Ool0/Goo001oOol00`00Oomoo`05Ool00`00Oomoo`0UOol00`0OOomoo`02Ool00`0OOomoo`2aOol0
07eoo`<000Moo`03001oogoo02Eoo`0301moogoo009oo`0301moogoo0;5oo`00Ogoo00<007ooOol0
1Goo00<007ooOol09Goo00<07gooOol00Woo00<07gooOol0/Goo0027Ool00`00Oomoo`0UOol00`0O
Oomoo`02Ool00`0OOomoo`2aOol008Moo`03001oogoo02Eoo`0301moogoo009oo`0301moogoo0;5o
o`00Qgoo0P009Woo00<07gooOol00goo00<07gooOol0/7oo0027Ool00`00Oomoo`0UOol00`0OOomo
o`03Ool00`0OOomoo`2`Ool008Moo`03001oogoo02Eoo`0301moogoo00=oo`0301moogoo0;1oo`00
Qgoo00<007ooOol09Goo00<07gooOol00goo00<07gooOol0/7oo0027Ool00`00Oomoo`0UOol00`0O
Oomoo`04Ool00`0OOomoo`2_Ool008Moo`03001oogoo02Eoo`0301moogoo00Aoo`0301moogoo0:mo
o`00Qgoo00<007ooOol09Goo00<07gooOol01Goo00<07gooOol0[Woo0027Ool2000VOol00`0OOomo
o`05Ool00`0OOomoo`2^Ool008Moo`03001oogoo02Eoo`0301moogoo00Eoo`0301moogoo0:ioo`00
Qgoo00<007ooOol09Goo00<07gooOol01Woo00<07gooOol0[Goo0027Ool00`00Oomoo`0UOol00`0O
Oomoo`06Ool00`0OOomoo`2]Ool008Moo`03001oogoo02Eoo`0301moogoo00Ioo`0301moogoo0:eo
o`0037oo0`009Woo1@009Goo1@008goo00<007ooOol097oo00<0000O00000P001Woo00<07gooOol0
6goo1@009Goo0`00:7oo0`009Goo100047oo000;Ool01@00Oomoogoo00009Goo00D007ooOomoo`00
02Moo`03001oogoo02=oo`03001oogoo02Eoo`0301l007oo00Moo`0301moogoo01]oo`05001oogoo
Ool0000TOol01@00Oomoogoo0000:7oo00<007ooOol08goo00<007ooOol00Woo00<007ooOol03Goo
000?Ool00`00Oomoo`0TOol00`00Oomoo`0XOol00`00Oomoo`0SOol2000VOol00`0O001oo`08Ool0
0`0OOomoo`0KOol00`00Oomoo`0YOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0=Ool0
00=oo`H000Ioo`03001oogoo01]oo`H000Aoo`03001oogoo01aoo`H000Eoo`03001oogoo02=oo`03
001oogoo02Eoo`0301l007oo00Uoo`0301moogoo01]oo`03001oogoo02Qoo`03001oogoo029oo`H0
02Uoo`03001oogoo00eoo`003Goo0P00:Goo00<007ooOol09Woo00<007ooOol08goo00<007ooOol0
9Goo00<07`00Ool02Woo00<07gooOol06goo00<007ooOol09Goo0P009Woo00@007ooOol002Ioo`@0
011oo`003goo00<007ooOol09goo00<007ooOol09Goo00<007ooOol08goo00<007ooOol09Goo00<0
7`00Ool02goo00<07gooOol06goo00<007ooOol09Woo00<007ooOol08goo00@007ooOol002Ioo`03
001oogoo015oo`002goo00D007ooOomoo`0002Eoo`05001oogooOol0000UOol3000UOol00`00Oomo
o`0TOol00`0001l0000=Ool201lGOol01@00Oomoogoo000097oo00D007ooOomoo`0002Ioo`03001o
o`0002Ioo`03001oogoo015oo`0037oo0`009goo0`00:7oo00<007ooOol08goo00<007ooOol09Goo
00<07`00Ool03Woo0P0O5Woo0`009Woo0`00:7oo0P009Woo1@003goo0027Ool2000VOol00`0OOomo
o`0@Ool301nSOol008Moo`03001oogoo02Eoo`0301moogoo01=oo`<07j1oo`00Qgoo00<007ooOol0
9Goo00<07gooOol05Woo1P0OVWoo0027Ool00`00Oomoo`0UOol00`0OOomoo`0LOol901nAOol008Mo
o`03001oogoo02Eoo`0301moogoo02Eoo`d07hAoo`00Qgoo00<007ooOol09Goo00<07gooOol0<Woo
7@0OIgoo0027Ool00`00Oomoo`0UOol00`0OOomoo`1?OomF01lAOol000YoojD0000301l000000:D0
015oo`002Woo<@0O00=oo`00Ool01Woo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo
00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol017oo
00<07`00Ool01Woo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo
00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo
00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo
00<007ooOol02Woo1@00000:Ool00`00Oomoo`0WOol00`00Oomoo`04Oold01lHOol00`00Oomoo`0U
Ool00`0O001oo`0XOol00`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0:
Ool01000Oomoogoo0@00001_OolC01l5Ool00`00Oomoo`0UOol00`0OOomoo`2bOol00`00Oomoo`01
Ool0089oo`T07bAoo`0301moogoo0;=oo`40005oo`5oo`00Qgoo00@007ooOomoo`T07a]oo`0301mo
ogoo0;5oo`04001oogoo0001Ool008Moo`03001oogoo00Yoo`@07aMoo`0301moogoo0;5oo`D00000
Qgoo0P003goo100O4goo00<07gooOol0]Woo0027Ool00`00Oomoo`0BOol201lAOol00`0OOomoo`2f
Ool008Moo`03001oogoo01Aoo`0301moogoo00ioo`0301moogoo0;Ioo`00Qgoo00<007ooOol05Goo
0P0O3Woo00<07gooOol0]Woo0027Ool00`00Oomoo`0GOol00`0OOomoo`0;Ool00`0OOomoo`2fOol0
08Moo`03001oogoo01Qoo`807`]oo`0301moogoo0;Ioo`00Qgoo00<007ooOol06Woo00<07gooOol0
27oo00<07gooOol0]Woo0027Ool2000LOol00`0OOomoo`07Ool00`0OOomoo`2fOol008Moo`03001o
ogoo01aoo`0301moogoo00Ioo`0301moogoo0;Ioo`00Qgoo00<007ooOol077oo00<07gooOol01Woo
00<07gooOol0]Woo0027Ool00`00Oomoo`0MOol00`0OOomoo`05Ool00`0OOomoo`2fOol008Moo`03
001oogoo01eoo`0301moogoo00Eoo`0301moogoo0;Ioo`00Qgoo00<007ooOol07Goo00<07gooOol0
1Goo00<07gooOol0]Woo0027Ool00`00Oomoo`0NOol00`0OOomoo`04Ool00`0OOomoo`2fOol008Mo
o`8001moo`0301moogoo00Aoo`0301moogoo0;Ioo`00Qgoo00<007ooOol07goo00<07gooOol00goo
00<07gooOol0]Woo0027Ool00`00Oomoo`0OOol00`0OOomoo`03Ool00`0OOomoo`2fOol008Moo`03
001oogoo01moo`0301moogoo00=oo`0301moogoo0;Ioo`00Qgoo00<007ooOol087oo00<07gooOol0
0Woo00<07gooOol0]Woo0027Ool00`00Oomoo`0POol00`0OOomoo`02Ool00`0OOomoo`2fOol008Mo
o`03001oogoo021oo`0301moogoo009oo`0301moogoo0;Ioo`00Qgoo0P008Goo00<07gooOol00Woo
00<07gooOol0]Woo0027Ool00`00Oomoo`0POol00`0OOomoo`02Ool00`0OOomoo`2fOol008Moo`03
001oogoo025oo`0501moogooOol07`2hOol007eoo`D000Eoo`03001oogoo025oo`0501moogooOol0
7`2hOol007moo`03001oogoo00Eoo`03001oogoo025oo`0501moogooOol07`2hOol007moo`03001o
ogoo00Eoo`03001oogoo025oo`0501moogooOol07`2hOol007moo`03001oogoo00Eoo`<0025oo`05
01moogooOol07`2hOol007moo`03001oogoo00Eoo`03001oogoo025oo`0501moogooOol07`2hOol0
07moo`03001oogoo00Eoo`03001oogoo025oo`0501moogooOol07`2hOol007eoo`<000Moo`03001o
ogoo025oo`0501moogooOol07`2hOol007moo`03001oogoo00Eoo`03001oogoo025oo`0501moogoo
Ool07`2hOol008Moo`03001oogoo025oo`0501moogooOol07`2hOol008Moo`03001oogoo029oo`04
01moogoo01nhOol008Moo`8002=oo`0401moogoo01nhOol008Moo`03001oogoo029oo`0401moogoo
01nhOol008Moo`03001oogoo029oo`0401moogoo01nhOol008Moo`03001oogoo029oo`0401moogoo
01nhOol008Moo`03001oogoo029oo`0401moogoo01nhOol008Moo`03001oogoo029oo`0401moogoo
01nhOol008Moo`03001oogoo029oo`0401moogoo01nhOol008Moo`8002=oo`0401moogoo01nhOol0
08Moo`03001oogoo029oo`0401moogoo01nhOol008Moo`03001oogoo029oo`0401moogoo01nhOol0
08Moo`03001oogoo029oo`0401moogoo01nhOol008Moo`03001oogoo029oo`0401moogoo01nhOol0
08Moo`03001oogoo02=oo`0301moo`0O0;Qoo`00Qgoo00<007ooOol08goo00<07goo01l0^7oo0027
Ool2000TOol00`0OOol07`2hOol008Moo`03001oogoo02=oo`0301moo`0O0;Qoo`00Qgoo00<007oo
Ool08goo00<07goo01l0^7oo0027Ool00`00Oomoo`0SOol00`0OOol07`2hOol008Moo`03001oogoo
02=oo`0301moo`0O0;Qoo`00Qgoo00<007ooOol08goo00<07goo01l0^7oo0027Ool00`00Oomoo`0S
Ool00`0OOol07`2hOol008Moo`8002Aoo`0301moo`0O0;Qoo`00Qgoo00<007ooOol08goo00<07goo
01l0^7oo0027Ool00`00Oomoo`0SOol00`0OOol07`2hOol008Moo`03001oogoo02=oo`0301moo`0O
0;Qoo`00O7oo1@001Woo00<007ooOol08goo00<07goo01l0^7oo001lOol01@00Oomoogoo00001Woo
00<007ooOol08goo00<07goo01l0^7oo001mOol00`00Oomoo`07Ool00`00Oomoo`0SOol00`0OOol0
7`2hOol007ioo`03001oogoo00Ioo`<002=oo`0301moo`0O0;Qoo`00Ogoo00<007ooOol01Goo00<0
07ooOol08goo00<07goo01l0^7oo0020Ool00`00Oomoo`04Ool00`00Oomoo`0SOol00`0OOol07`2h
Ool007aoo`05001oogooOol00006Ool00`00Oomoo`0SOol00`0OOol07`2hOol007eoo`<000Moo`03
001oogoo02=oo`0301moo`0O0;Qoo`00Qgoo00<007ooOol08goo00<07goo01l0^7oo0027Ool2000T
Ool00`0OOol07`2hOol008Moo`03001oogoo02Aoo`807kQoo`00Qgoo00<007ooOol097oo0P0O^7oo
0027Ool00`00Oomoo`0TOol201nhOol008Moo`03001oogoo02Aoo`807kQoo`00Qgoo00<007ooOol0
97oo0P0O^7oo0027Ool00`00Oomoo`0TOol201nhOol008Moo`8002Eoo`807kQoo`00Qgoo00<007oo
Ool097oo0P0O^7oo0027Ool00`00Oomoo`0TOol201nhOol008Moo`03001oogoo02Aoo`807kQoo`00
Qgoo00<007ooOol097oo0P0O^7oo0027Ool00`00Oomoo`0TOol201nhOol008Moo`03001oogoo02Ao
o`807kQoo`00Qgoo0P009Goo0P0O^7oo0027Ool00`00Oomoo`0TOol201nhOol008Moo`03001oogoo
02Aoo`807kQoo`00Qgoo00<007ooOol097oo0P0O^7oo0027Ool00`00Oomoo`0TOol201nhOol008Mo
o`03001oogoo02Aoo`807kQoo`00Qgoo00<007ooOol097oo0P0O^7oo0027Ool2000UOol201nhOol0
08Moo`03001oogoo02Aoo`807kQoo`00Qgoo00<007ooOol097oo0P0O^7oo0027Ool00`00Oomoo`0T
Ool201nhOol007eoo`<000Moo`03001oogoo02Aoo`807kQoo`00O7oo00D007ooOomoo`0000Ioo`03
001oogoo02Aoo`807kQoo`00P7oo00<007ooOol017oo00<007ooOol097oo0P0O^7oo0020Ool00`00
Oomoo`04Ool3000TOol201nhOol007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomo
ogoo0000igoo001mOol3003XOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo
0028Ool3000017oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31153 m
.04057 .31174 L
.08481 .31202 L
.12636 .31233 L
.16632 .3127 L
.20885 .3132 L
.2498 .31383 L
.27066 .31423 L
.29331 .31474 L
.33524 .31602 L
.35607 .3169 L
.37815 .3181 L
.39866 .31961 L
.41788 .32155 L
.42878 .32301 L
.43914 .32475 L
.44844 .32672 L
.45859 .32953 L
.46417 .33149 L
.46942 .33371 L
.47924 .3393 L
.48475 .34372 L
.48982 .34908 L
.49539 .35728 L
.49819 .36283 L
.50126 .37059 L
.5039 .37928 L
.50529 .38493 L
.50677 .39202 L
.50805 .39938 L
.50947 .40917 L
.51078 .42027 L
.51198 .43284 L
.51316 .44838 L
.5144 .46958 L
.51565 .49852 L
.51702 .54506 L
.5182 .60898 L
s
.5182 .60898 m
.5183 .61803 L
s
.52218 .61803 m
.5224 0 L
s
.5269 0 m
.52717 .02311 L
.52793 .06369 L
.52865 .09282 L
.53 .13221 L
.53076 .14854 L
.53146 .1612 L
.53305 .18362 L
.53444 .19838 L
.53576 .20941 L
.53821 .22505 L
.54085 .2372 L
.54371 .2469 L
.54621 .25348 L
.54889 .25913 L
.55372 .26687 L
.55946 .27343 L
.56469 .27785 L
.57014 .28142 L
.57606 .28447 L
.58682 .28859 L
.59671 .29131 L
.60762 .29358 L
.61901 .29541 L
.62969 .29676 L
.65093 .29879 L
.67037 .30014 L
.69028 .30119 L
.71203 .30209 L
.73439 .30282 L
.75467 .30336 L
.79573 .30421 L
.83776 .30485 L
.87821 .30533 L
.92123 .30572 L
.96265 .30603 L
1 .30627 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<002ioo`807jioo`00OWoo0P001goo00<007ooOol0;Woo0P0O
[Woo0020Ool00`00Oomoo`04Ool00`00Oomoo`0^Ool201n^Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`0^Ool201n^Ool007eoo`<000Moo`03001oogoo02ioo`807jioo`00Qgoo00<007ooOol0
;Woo0P0O[Woo0027Ool00`00Oomoo`0^Ool201n^Ool008Moo`8002moo`807jioo`00Qgoo00<007oo
Ool0;Woo0P0O[Woo0027Ool00`00Oomoo`0^Ool201n^Ool008Moo`03001oogoo02ioo`807jioo`00
Qgoo00<007ooOol0;Woo0P0O[Woo0027Ool00`00Oomoo`0^Ool201n^Ool008Moo`8002moo`807jio
o`00Qgoo00<007ooOol0;Woo0P0O[Woo0027Ool00`00Oomoo`0^Ool201n^Ool008Moo`03001oogoo
02ioo`807jioo`00Qgoo00<007ooOol0;Woo0P0O[Woo0027Ool00`00Oomoo`0^Ool201n^Ool008Mo
o`03001oogoo02ioo`807jioo`00Qgoo0P00;goo0P0O[Woo0027Ool00`00Oomoo`0^Ool201n^Ool0
08Moo`03001oogoo02ioo`807jioo`00Qgoo00<007ooOol0;Woo0P0O[Woo0027Ool00`00Oomoo`0^
Ool201n^Ool008Moo`03001oogoo02ioo`807jioo`00Qgoo00<007ooOol0;Woo00<07goo01l0[Goo
0027Ool2000_Ool00`0OOol07`2]Ool008Moo`03001oogoo02ioo`0301moo`0O0:eoo`00Qgoo00<0
07ooOol0;Woo00<07goo01l0[Goo0027Ool00`00Oomoo`0^Ool00`0OOol07`2]Ool007aoo`D000Io
o`03001oogoo02ioo`0301moo`0O0:eoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo02ioo`03
01moo`0O0:eoo`00OGoo00<007ooOol01goo00<007ooOol0;Woo00<07goo01l0[Goo001dOol60004
Ool00`00Oomoo`06Ool3000^Ool00`0OOol07`2]Ool007moo`03001oogoo00Eoo`03001oogoo02io
o`0301moo`0O0:eoo`00P7oo00<007ooOol017oo00<007ooOol0;Woo00<07goo01l0[Goo001lOol0
1@00Oomoogoo00001Woo00<007ooOol0;Woo00<07goo01l0[Goo001mOol30007Ool00`00Oomoo`0^
Ool00`0OOol07`2]Ool008Moo`03001oogoo02ioo`0301moo`0O0:eoo`00Qgoo00<007ooOol0;Woo
00<07goo01l0[Goo0027Ool2000_Ool00`0OOol07`2]Ool008Moo`03001oogoo02ioo`0301moo`0O
0:eoo`00Qgoo00<007ooOol0;Woo00<07goo01l0[Goo0027Ool00`00Oomoo`0^Ool00`0OOol07`2]
Ool008Moo`03001oogoo02ioo`0301moo`0O0:eoo`00Qgoo00<007ooOol0;Woo00<07goo01l0[Goo
0027Ool00`00Oomoo`0^Ool00`0OOol07`2]Ool008Moo`8002moo`0301moo`0O0:eoo`00Qgoo00<0
07ooOol0;Woo00<07goo01l0[Goo0027Ool00`00Oomoo`0^Ool00`0OOol07`2]Ool008Moo`03001o
ogoo02ioo`0401moogoo01n/Ool008Moo`03001oogoo02ioo`0401moogoo01n/Ool008Moo`03001o
ogoo02ioo`0401moogoo01n/Ool008Moo`8002moo`0401moogoo01n/Ool008Moo`03001oogoo02io
o`0401moogoo01n/Ool008Moo`03001oogoo02ioo`0401moogoo01n/Ool008Moo`03001oogoo02io
o`0401moogoo01n/Ool008Moo`03001oogoo02ioo`0401moogoo01n/Ool008Moo`03001oogoo02io
o`0401moogoo01n/Ool008Moo`03001oogoo02ioo`0401moogoo01n/Ool008Moo`8002moo`0401mo
ogoo01n/Ool008Moo`03001oogoo02ioo`0401moogoo01n/Ool008Moo`03001oogoo02ioo`0401mo
ogoo01n/Ool008Moo`03001oogoo02ioo`0501moogooOol07`2[Ool007eoo`D000Eoo`03001oogoo
02ioo`0501moogooOol07`2[Ool007moo`03001oogoo00Eoo`03001oogoo02ioo`0501moogooOol0
7`2[Ool007moo`03001oogoo00Eoo`03001oogoo02ioo`0501moogooOol07`2[Ool007Aoo`H000Eo
o`03001oogoo00Eoo`<002ioo`0501moogooOol07`2[Ool007moo`03001oogoo00Eoo`03001oogoo
02ioo`0501moogooOol07`2[Ool007moo`03001oogoo00Eoo`03001oogoo02ioo`0501moogooOol0
7`2[Ool007eoo`<000Moo`03001oogoo02ioo`0501moogooOol07`2[Ool007moo`03001oogoo00Eo
o`03001oogoo02ioo`0301moogoo009oo`0301moogoo0:Qoo`00Qgoo00<007ooOol0;Woo00<07goo
Ool00Woo00<07gooOol0Z7oo0027Ool00`00Oomoo`0^Ool00`0OOomoo`02Ool00`0OOomoo`2XOol0
08Moo`8002moo`0301moogoo009oo`0301moogoo0:Qoo`00Qgoo00<007ooOol0;Woo00<07gooOol0
0goo00<07gooOol0Ygoo0027Ool00`00Oomoo`0^Ool00`0OOomoo`03Ool00`0OOomoo`2WOol008Mo
o`03001oogoo02ioo`0301moogoo00=oo`0301moogoo0:Moo`00Qgoo00<007ooOol0;Woo00<07goo
Ool00goo00<07gooOol0Ygoo0027Ool00`00Oomoo`0^Ool00`0OOomoo`04Ool00`0OOomoo`2VOol0
08Moo`03001oogoo02ioo`0301moogoo00Aoo`0301moogoo0:Ioo`00Qgoo0P00;goo00<07gooOol0
17oo00<07gooOol0YWoo0027Ool00`00Oomoo`0^Ool00`0OOomoo`04Ool00`0OOomoo`2VOol008Mo
o`03001oogoo02ioo`0301moogoo00Aoo`0301moogoo0:Ioo`00Qgoo00<007ooOol0;Woo00<07goo
Ool01Goo00<07gooOol0YGoo0027Ool00`00Oomoo`0^Ool00`0OOomoo`05Ool00`0OOomoo`2UOol0
00aoo`<002Ioo`D002Eoo`D002=oo`03001oogoo02Aoo`D000Eoo`0301moogoo00Ioo`0301moogoo
01=oo`D002Eoo`<002Qoo`<002Eoo`@0011oo`002goo00D007ooOomoo`0002Eoo`05001oogooOol0
000WOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`05Ool00`0OOomoo`07Ool00`0OOomo
o`0BOol01@00Oomoogoo000097oo00D007ooOomoo`0002Qoo`03001oogoo02=oo`03001oogoo009o
o`03001oogoo00eoo`003goo00<007ooOol097oo00<007ooOol0:7oo00<007ooOol08goo0P009goo
00<007ooOol01Goo00<07gooOol027oo00<07gooOol04Woo00<007ooOol0:Goo00<007ooOol09Woo
00<007ooOol0:7oo00<007ooOol03Goo0003Ool60006Ool00`00Oomoo`0KOol60004Ool00`00Oomo
o`0LOol60005Ool00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`05Ool00`0OOomoo`09Ool0
0`0OOomoo`0BOol00`00Oomoo`0XOol00`00Oomoo`0ROol6000YOol00`00Oomoo`0=Ool000eoo`80
02Uoo`03001oogoo02Ioo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo00Eoo`0301moogoo
00Yoo`0301moogoo019oo`03001oogoo02Eoo`8002Ioo`04001oogoo000VOol4000@Ool000moo`03
001oogoo02Moo`03001oogoo02Eoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo00Eoo`03
01moogoo00]oo`0301moogoo019oo`03001oogoo02Ioo`03001oogoo02=oo`04001oogoo000VOol0
0`00Oomoo`0AOol000]oo`05001oogooOol0000UOol01@00Oomoogoo00009Goo0`009Goo00<007oo
Ool097oo0`001goo00<07gooOol037oo00<07gooOol03Goo00D007ooOomoo`0002Aoo`05001oogoo
Ool0000VOol00`00Ool0000VOol00`00Oomoo`0AOol000aoo`<002Moo`<002Qoo`03001oogoo02=o
o`03001oogoo02Ioo`03001oogoo00Eoo`0301moogoo00eoo`<07`eoo`<002Ioo`<002Qoo`8002Io
o`D000moo`00Qgoo0P00;goo00<07gooOol047oo100OVGoo0027Ool00`00Oomoo`0^Ool00`0OOomo
o`0DOol301nFOol008Moo`03001oogoo02ioo`0301moogoo01Moo`@07i9oo`00Qgoo00<007ooOol0
;Woo00<07gooOol06goo2@0ORGoo0027Ool00`00Oomoo`0^Ool00`0OOomoo`0TOol=01mlOol008Mo
o`03001oogoo02ioo`0301moogoo035oob007eaoo`00Qgoo00<007ooOol0;Woo00<07gooOol0DGoo
B`0O4Goo000:Oon^00000`0O0000002L000AOol000Yoocl07`Aoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Aoo`0301l007oo00Moo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Yoo`D000002Woo00<007ooOol09goo00<007ooOol04Woo:P0O57oo00<007oo
Ool09Woo00<007ooOol017oo00<07gooOol087oo00<007ooOol09Woo00<007ooOol09Woo00<007oo
Ool09goo00<007ooOol02Woo00@007ooOomoo`400000Lgoo600O;7oo00<07gooOol0ZWoo00<007oo
Ool00Goo0027Ool01000Oomoogoo300O87oo00<07gooOol0Zgoo0@000Goo0Goo0027Ool00`00Oomo
o`0=Ool701lIOol00`0OOomoo`2YOol01000Oomoo`000Goo0027Ool00`00Oomoo`0DOol301lFOol0
0`0OOomoo`2YOol5000008Moo`8001Qoo`807aAoo`0301moogoo0:ioo`00Qgoo00<007ooOol06Goo
100O47oo00<07gooOol0[Woo0027Ool00`00Oomoo`0MOol201l>Ool00`0OOomoo`2^Ool008Moo`03
001oogoo01moo`0301moogoo00]oo`0301moogoo0:ioo`00Qgoo00<007ooOol087oo00<07gooOol0
2Woo00<07gooOol0[Woo0027Ool00`00Oomoo`0QOol00`0OOomoo`09Ool00`0OOomoo`2^Ool008Mo
o`03001oogoo029oo`0301moogoo00Qoo`0301moogoo0:ioo`00Qgoo0P0097oo00<07gooOol01goo
00<07gooOol0[Woo0027Ool00`00Oomoo`0TOol00`0OOomoo`06Ool00`0OOomoo`2^Ool008Moo`03
001oogoo02Eoo`0301moogoo00Eoo`0301moogoo0:ioo`00Qgoo00<007ooOol09Woo00<07gooOol0
17oo00<07gooOol0[Woo0027Ool00`00Oomoo`0VOol00`0OOomoo`04Ool00`0OOomoo`2^Ool008Mo
o`03001oogoo02Ioo`0301moogoo00Aoo`0301moogoo0:ioo`00Qgoo00<007ooOol09goo00<07goo
Ool00goo00<07gooOol0[Woo0027Ool2000XOol00`0OOomoo`03Ool00`0OOomoo`2^Ool008Moo`03
001oogoo02Moo`0301moogoo00=oo`0301moogoo0:ioo`00Qgoo00<007ooOol09goo00<07gooOol0
0goo00<07gooOol0[Woo0027Ool00`00Oomoo`0WOol00`0OOomoo`03Ool00`0OOomoo`2^Ool008Mo
o`03001oogoo02Qoo`0301moogoo009oo`0301moogoo0:ioo`00Qgoo00<007ooOol0:7oo00<07goo
Ool00Woo00<07gooOol0[Woo0027Ool00`00Oomoo`0XOol00`0OOomoo`02Ool00`0OOomoo`2^Ool0
08Moo`8002Uoo`0301moogoo009oo`0301moogoo0:ioo`00Qgoo00<007ooOol0:Goo00D07gooOomo
o`0O0;1oo`00Qgoo00<007ooOol0:Goo00D07gooOomoo`0O0;1oo`00OGoo1@001Goo00<007ooOol0
:Goo00D07gooOomoo`0O0;1oo`00Ogoo00<007ooOol01Goo00<007ooOol0:Goo00D07gooOomoo`0O
0;1oo`00Ogoo00<007ooOol01Goo00<007ooOol0:Goo00D07gooOomoo`0O0;1oo`00Ogoo00<007oo
Ool01Goo0`00:Goo00D07gooOomoo`0O0;1oo`00Ogoo00<007ooOol01Goo00<007ooOol0:Woo00@0
7gooOol07k1oo`00Ogoo00<007ooOol01Goo00<007ooOol0:Woo00@07gooOol07k1oo`00OGoo0`00
1goo00<007ooOol0:Woo00@07gooOol07k1oo`00Ogoo00<007ooOol01Goo00<007ooOol0:Woo00@0
7gooOol07k1oo`00Qgoo00<007ooOol0:Woo00@07gooOol07k1oo`00Qgoo00<007ooOol0:Woo00@0
7gooOol07k1oo`00Qgoo0P00:goo00@07gooOol07k1oo`00Qgoo00<007ooOol0:Woo00@07gooOol0
7k1oo`00Qgoo00<007ooOol0:Woo00@07gooOol07k1oo`00Qgoo00<007ooOol0:Woo00@07gooOol0
7k1oo`00Qgoo00<007ooOol0:Woo00@07gooOol07k1oo`00Qgoo00<007ooOol0:Woo00@07gooOol0
7k1oo`00Qgoo00<007ooOol0:Woo00@07gooOol07k1oo`00Qgoo0P00:goo00@07gooOol07k1oo`00
Qgoo00<007ooOol0:Woo00@07gooOol07k1oo`00Qgoo00<007ooOol0:goo00<07goo01l0/7oo0027
Ool00`00Oomoo`0[Ool00`0OOol07`2`Ool008Moo`03001oogoo02]oo`0301moo`0O0;1oo`00Qgoo
00<007ooOol0:goo00<07goo01l0/7oo0027Ool00`00Oomoo`0[Ool00`0OOol07`2`Ool008Moo`80
02aoo`0301moo`0O0;1oo`00Qgoo00<007ooOol0:goo00<07goo01l0/7oo0027Ool00`00Oomoo`0[
Ool00`0OOol07`2`Ool008Moo`03001oogoo02]oo`0301moo`0O0;1oo`00Qgoo00<007ooOol0:goo
00<07goo01l0/7oo0027Ool00`00Oomoo`0[Ool00`0OOol07`2`Ool008Moo`03001oogoo02]oo`03
01moo`0O0;1oo`00Qgoo0P00;7oo00<07goo01l0/7oo0027Ool00`00Oomoo`0[Ool00`0OOol07`2`
Ool008Moo`03001oogoo02]oo`0301moo`0O0;1oo`00Qgoo00<007ooOol0:goo00<07goo01l0/7oo
001lOol50006Ool00`00Oomoo`0[Ool00`0OOol07`2`Ool007aoo`05001oogooOol00006Ool00`00
Oomoo`0[Ool00`0OOol07`2`Ool007eoo`03001oogoo00Moo`03001oogoo02]oo`0301moo`0O0;1o
o`00OWoo00<007ooOol01Woo0`00:goo00<07goo01l0/7oo001oOol00`00Oomoo`05Ool00`00Oomo
o`0[Ool00`0OOol07`2`Ool0081oo`03001oogoo00Aoo`03001oogoo02aoo`807k1oo`00O7oo00D0
07ooOomoo`0000Ioo`03001oogoo02aoo`807k1oo`00OGoo0`001goo00<007ooOol0;7oo0P0O/7oo
0027Ool00`00Oomoo`0/Ool201n`Ool008Moo`8002eoo`807k1oo`00Qgoo00<007ooOol0;7oo0P0O
/7oo0027Ool00`00Oomoo`0/Ool201n`Ool008Moo`03001oogoo02aoo`807k1oo`00Qgoo00<007oo
Ool0;7oo0P0O/7oo0027Ool00`00Oomoo`0/Ool201n`Ool008Moo`03001oogoo02aoo`807k1oo`00
Qgoo0P00;Goo0P0O/7oo0027Ool00`00Oomoo`0/Ool201n`Ool008Moo`03001oogoo02aoo`807k1o
o`00Qgoo00<007ooOol0;7oo0P0O/7oo0027Ool00`00Oomoo`0/Ool201n`Ool008Moo`03001oogoo
02aoo`807k1oo`00Qgoo00<007ooOol0;7oo0P0O/7oo0027Ool2000]Ool201n`Ool008Moo`03001o
ogoo02aoo`807k1oo`00Qgoo00<007ooOol0;7oo0P0O/7oo0027Ool00`00Oomoo`0/Ool201n`Ool0
08Moo`03001oogoo02aoo`807k1oo`00Qgoo00<007ooOol0;7oo0P0O/7oo0027Ool00`00Oomoo`0/
Ool201n`Ool008Moo`8002eoo`807k1oo`00Qgoo00<007ooOol0;7oo0P0O/7oo0027Ool00`00Oomo
o`0/Ool201n`Ool008Moo`03001oogoo02aoo`807k1oo`00OGoo0`001goo00<007ooOol0;7oo0P0O
/7oo001lOol01@00Oomoogoo00001Woo00<007ooOol0;7oo0P0O/7oo0020Ool00`00Oomoo`04Ool0
0`00Oomoo`0/Ool201n`Ool0081oo`03001oogoo00Aoo`<002aoo`807k1oo`00OWoo0P00j7oo0020
Ool00`00Oomoo`3UOol007aoo`05001oogooOol0003WOol007eoo`<00>Qoo`00ogooJGoo003oOomY
Ool00?moofUoo`00ogooJGoo003oOomYOol008Qoo`<00004Ool00000003IOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31141 m
.04057 .31161 L
.08481 .31185 L
.12636 .31213 L
.16632 .31246 L
.20885 .31289 L
.2498 .31342 L
.29331 .31418 L
.31511 .31466 L
.33524 .3152 L
.37557 .31665 L
.39524 .31763 L
.41689 .31906 L
.43727 .32092 L
.44872 .32229 L
.45919 .32387 L
.46953 .32583 L
.47913 .32819 L
.48966 .33168 L
.49555 .33424 L
.50089 .33713 L
.50601 .34059 L
.51141 .34531 L
.51603 .35062 L
.5211 .35858 L
.52395 .36457 L
.52655 .37144 L
.52956 .38185 L
.53094 .38789 L
.5324 .3955 L
.53365 .40326 L
.53503 .4136 L
.5363 .42535 L
.53746 .43871 L
.53882 .45893 L
.53953 .47201 L
.5403 .48922 L
.54159 .52826 L
.54296 .59307 L
s
.54296 .59307 m
.54324 .61803 L
s
.54721 .61803 m
.54726 0 L
s
.55184 0 m
.55243 .03819 L
.55375 .09621 L
.55504 .13309 L
.55621 .15695 L
.55756 .17754 L
.55883 .19239 L
.5611 .21195 L
.56355 .22683 L
.56621 .23857 L
.56913 .24811 L
.57217 .25565 L
.57501 .26118 L
.5801 .26866 L
.58555 .27445 L
.59111 .27887 L
.59626 .28205 L
.60179 .28481 L
.60789 .28726 L
.61815 .29042 L
.62903 .2929 L
.63966 .29476 L
.64939 .29612 L
.6713 .29841 L
.69121 .29988 L
.71296 .30108 L
.73359 .30196 L
.7556 .30271 L
.79923 .3038 L
.84127 .30455 L
.88171 .30509 L
.92473 .30554 L
.96616 .30588 L
1 .30612 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<003Ioo`807jIoo`00OWoo0P001goo00<007ooOol0=Woo0P0O
YWoo0020Ool00`00Oomoo`04Ool00`00Oomoo`0fOol201nVOol007aoo`05001oogooOol00006Ool0
0`00Oomoo`0fOol201nVOol007eoo`<000Moo`03001oogoo03Ioo`807jIoo`00Qgoo00<007ooOol0
=Woo0P0OYWoo0027Ool00`00Oomoo`0fOol201nVOol008Moo`8003Moo`807jIoo`00Qgoo00<007oo
Ool0=Woo0P0OYWoo0027Ool00`00Oomoo`0fOol201nVOol008Moo`03001oogoo03Ioo`807jIoo`00
Qgoo00<007ooOol0=Woo0P0OYWoo0027Ool00`00Oomoo`0fOol201nVOol008Moo`8003Moo`807jIo
o`00Qgoo00<007ooOol0=Woo0P0OYWoo0027Ool00`00Oomoo`0fOol201nVOol008Moo`03001oogoo
03Ioo`807jIoo`00Qgoo00<007ooOol0=Woo0P0OYWoo0027Ool00`00Oomoo`0fOol201nVOol008Mo
o`03001oogoo03Ioo`807jIoo`00Qgoo0P00=goo0P0OYWoo0027Ool00`00Oomoo`0fOol201nVOol0
08Moo`03001oogoo03Ioo`0301moo`0O0:Eoo`00Qgoo00<007ooOol0=Woo00<07goo01l0YGoo0027
Ool00`00Oomoo`0fOol00`0OOol07`2UOol008Moo`03001oogoo03Ioo`0301moo`0O0:Eoo`00Qgoo
00<007ooOol0=Woo00<07goo01l0YGoo0027Ool2000gOol00`0OOol07`2UOol008Moo`03001oogoo
03Ioo`0301moo`0O0:Eoo`00Qgoo00<007ooOol0=Woo00<07goo01l0YGoo0027Ool00`00Oomoo`0f
Ool00`0OOol07`2UOol007aoo`D000Ioo`03001oogoo03Ioo`0301moo`0O0:Eoo`00O7oo00D007oo
Oomoo`0000Ioo`03001oogoo03Ioo`0301moo`0O0:Eoo`00OGoo00<007ooOol01goo00<007ooOol0
=Woo00<07goo01l0YGoo001dOol60004Ool00`00Oomoo`06Ool3000fOol00`0OOol07`2UOol007mo
o`03001oogoo00Eoo`03001oogoo03Ioo`0301moo`0O0:Eoo`00P7oo00<007ooOol017oo00<007oo
Ool0=Woo00<07goo01l0YGoo001lOol01@00Oomoogoo00001Woo00<007ooOol0=Woo00<07goo01l0
YGoo001mOol30007Ool00`00Oomoo`0fOol00`0OOol07`2UOol008Moo`03001oogoo03Ioo`0301mo
o`0O0:Eoo`00Qgoo00<007ooOol0=Woo00<07goo01l0YGoo0027Ool2000gOol00`0OOol07`2UOol0
08Moo`03001oogoo03Ioo`0301moo`0O0:Eoo`00Qgoo00<007ooOol0=Woo00<07goo01l0YGoo0027
Ool00`00Oomoo`0fOol00`0OOol07`2UOol008Moo`03001oogoo03Ioo`0301moo`0O0:Eoo`00Qgoo
00<007ooOol0=Woo00<07goo01l0YGoo0027Ool00`00Oomoo`0fOol00`0OOol07`2UOol008Moo`80
03Moo`0401moogoo01nTOol008Moo`03001oogoo03Ioo`0401moogoo01nTOol008Moo`03001oogoo
03Ioo`0401moogoo01nTOol008Moo`03001oogoo03Ioo`0401moogoo01nTOol008Moo`03001oogoo
03Ioo`0401moogoo01nTOol008Moo`03001oogoo03Ioo`0401moogoo01nTOol008Moo`8003Moo`04
01moogoo01nTOol008Moo`03001oogoo03Ioo`0401moogoo01nTOol008Moo`03001oogoo03Ioo`04
01moogoo01nTOol008Moo`03001oogoo03Ioo`0401moogoo01nTOol008Moo`03001oogoo03Ioo`04
01moogoo01nTOol008Moo`03001oogoo03Ioo`0401moogoo01nTOol008Moo`03001oogoo03Ioo`04
01moogoo01nTOol008Moo`8003Moo`0401moogoo01nTOol008Moo`03001oogoo03Ioo`0501moogoo
Ool07`2SOol008Moo`03001oogoo03Ioo`0501moogooOol07`2SOol008Moo`03001oogoo03Ioo`05
01moogooOol07`2SOol007eoo`D000Eoo`03001oogoo03Ioo`0501moogooOol07`2SOol007moo`03
001oogoo00Eoo`03001oogoo03Ioo`0501moogooOol07`2SOol007moo`03001oogoo00Eoo`03001o
ogoo03Ioo`0501moogooOol07`2SOol007Aoo`H000Eoo`03001oogoo00Eoo`<003Ioo`0501moogoo
Ool07`2SOol007moo`03001oogoo00Eoo`03001oogoo03Ioo`0501moogooOol07`2SOol007moo`03
001oogoo00Eoo`03001oogoo03Ioo`0501moogooOol07`2SOol007eoo`<000Moo`03001oogoo03Io
o`0501moogooOol07`2SOol007moo`03001oogoo00Eoo`03001oogoo03Ioo`0501moogooOol07`2S
Ool008Moo`03001oogoo03Ioo`0301moogoo009oo`0301moogoo0:1oo`00Qgoo00<007ooOol0=Woo
00<07gooOol00Woo00<07gooOol0X7oo0027Ool2000gOol00`0OOomoo`02Ool00`0OOomoo`2POol0
08Moo`03001oogoo03Ioo`0301moogoo009oo`0301moogoo0:1oo`00Qgoo00<007ooOol0=Woo00<0
7gooOol00goo00<07gooOol0Wgoo0027Ool00`00Oomoo`0fOol00`0OOomoo`03Ool00`0OOomoo`2O
Ool008Moo`03001oogoo03Ioo`0301moogoo00=oo`0301moogoo09moo`00Qgoo00<007ooOol0=Woo
00<07gooOol00goo00<07gooOol0Wgoo0027Ool00`00Oomoo`0fOol00`0OOomoo`04Ool00`0OOomo
o`2NOol008Moo`8003Moo`0301moogoo00Aoo`0301moogoo09ioo`00Qgoo00<007ooOol0=Woo00<0
7gooOol017oo00<07gooOol0WWoo0027Ool00`00Oomoo`0fOol00`0OOomoo`05Ool00`0OOomoo`2M
Ool008Moo`03001oogoo03Ioo`0301moogoo00Eoo`0301moogoo09eoo`00Qgoo00<007ooOol0=Woo
00<07gooOol01Woo00<07gooOol0W7oo000<Ool3000VOol5000UOol5000SOol00`00Oomoo`0TOol5
000=Ool00`0OOomoo`07Ool00`0OOomoo`0:Ool5000UOol3000XOol3000UOol4000@Ool000]oo`05
001oogooOol0000UOol01@00Oomoogoo00009goo00<007ooOol08goo00<007ooOol09Woo00<007oo
Ool03Goo00<07gooOol01goo00<07gooOol02Woo00D007ooOomoo`0002Aoo`05001oogooOol0000X
Ool00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000moo`03001oogoo02Aoo`03001o
ogoo02Qoo`03001oogoo02=oo`8002Moo`03001oogoo00eoo`0301moogoo00Qoo`0301moogoo00Yo
o`03001oogoo02Uoo`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo00eoo`000goo1P001Woo
00<007ooOol06goo1P0017oo00<007ooOol077oo1P001Goo00<007ooOol08goo00<007ooOol09Woo
00<007ooOol03Goo00<07gooOol02Goo00<07gooOol02Woo00<007ooOol0:7oo00<007ooOol08Woo
1P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomoo`0VOol00`00Oomoo`0SOol00`00Oomo
o`0VOol00`00Oomoo`0=Ool00`0OOomoo`09Ool00`0OOomoo`0;Ool00`00Oomoo`0UOol2000VOol0
1000Oomoo`009Woo100047oo000?Ool00`00Oomoo`0WOol00`00Oomoo`0UOol00`00Oomoo`0SOol0
0`00Oomoo`0VOol00`00Oomoo`0=Ool00`0OOomoo`0:Ool201l<Ool00`00Oomoo`0VOol00`00Oomo
o`0SOol01000Oomoo`009Woo00<007ooOol04Goo000;Ool01@00Oomoogoo00009Goo00D007ooOomo
o`0002Eoo`<002Eoo`03001oogoo02Aoo`<000moo`0301moogoo00aoo`807`Ioo`05001oogooOol0
000TOol01@00Oomoogoo00009Woo00<007oo00009Woo00<007ooOol04Goo000<Ool3000WOol3000X
Ool00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0=Ool00`0OOomoo`0>Ool201l5Ool3000V
Ool3000XOol2000VOol5000?Ool008Moo`8003Moo`0301moogoo011oo`<07i9oo`00Qgoo00<007oo
Ool0=Woo00<07gooOol04goo0`0OSgoo0027Ool00`00Oomoo`0fOol00`0OOomoo`0FOol401n;Ool0
08Moo`03001oogoo03Ioo`0301moogoo01Yoo`T07h9oo`00Qgoo00<007ooOol0=Woo00<07gooOol0
8goo3P0OM7oo0027Ool00`00Oomoo`0fOol00`0OOomoo`0aOolV01m>Ool008Moo`03001oogoo03Io
o`0301moogoo05Moocd07a5oo`002Woo]P0000<07`000000U0004Goo000:Oolo01l4Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`0O001oo`06Ool00`00Oomo
o`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`06Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool5000000Yoo`03001oogoo02Moo`03001oogoo019o
ocL07`Moo`03001oogoo02Ioo`03001oogoo00eoo`0301moogoo01Moo`03001oogoo02Ioo`03001o
ogoo02Ioo`03001oogoo02Moo`03001oogoo00Yoo`04001oogooOol10000081ooa407bmoo`0301mo
ogoo0:5oo`03001oogoo005oo`00Qgoo00<007ooOol01goo300O8goo00<07gooOol0XWoo0@000Goo
0Goo0027Ool00`00Oomoo`0COol801lKOol00`0OOomoo`2POol01000Oomoo`000Goo0027Ool00`00
Oomoo`0KOol301lHOol00`0OOomoo`2POol5000008Moo`8001moo`<07aEoo`0301moogoo0:Eoo`00
Qgoo00<007ooOol08Goo0`0O4Woo00<07gooOol0YGoo0027Ool00`00Oomoo`0TOol201l@Ool00`0O
Oomoo`2UOol008Moo`03001oogoo02Ioo`0301moogoo00eoo`0301moogoo0:Eoo`00Qgoo00<007oo
Ool09goo0P0O3Goo00<07gooOol0YGoo0027Ool00`00Oomoo`0YOol201l;Ool00`0OOomoo`2UOol0
08Moo`03001oogoo02]oo`0301moogoo00Qoo`0301moogoo0:Eoo`00Qgoo0P00;7oo00<07gooOol0
27oo00<07gooOol0YGoo0027Ool00`00Oomoo`0/Ool00`0OOomoo`07Ool00`0OOomoo`2UOol008Mo
o`03001oogoo02aoo`0301moogoo00Moo`0301moogoo0:Eoo`00Qgoo00<007ooOol0;Goo00<07goo
Ool01Woo00<07gooOol0YGoo0027Ool00`00Oomoo`0^Ool00`0OOomoo`05Ool00`0OOomoo`2UOol0
08Moo`03001oogoo02ioo`0301moogoo00Eoo`0301moogoo0:Eoo`00Qgoo00<007ooOol0;goo00<0
7gooOol017oo00<07gooOol0YGoo0027Ool2000`Ool00`0OOomoo`04Ool00`0OOomoo`2UOol008Mo
o`03001oogoo02moo`0301moogoo00Aoo`0301moogoo0:Eoo`00Qgoo00<007ooOol0<7oo00<07goo
Ool00goo00<07gooOol0YGoo0027Ool00`00Oomoo`0`Ool00`0OOomoo`03Ool00`0OOomoo`2UOol0
08Moo`03001oogoo031oo`0301moogoo00=oo`0301moogoo0:Eoo`00Qgoo00<007ooOol0<7oo00<0
7gooOol00goo00<07gooOol0YGoo0027Ool00`00Oomoo`0`Ool00`0OOomoo`03Ool00`0OOomoo`2U
Ool008Moo`80039oo`0301moogoo009oo`0301moogoo0:Eoo`00Qgoo00<007ooOol0<Goo00<07goo
Ool00Woo00<07gooOol0YGoo0027Ool00`00Oomoo`0aOol00`0OOomoo`02Ool00`0OOomoo`2UOol0
07eoo`D000Eoo`03001oogoo035oo`0301moogoo009oo`0301moogoo0:Eoo`00Ogoo00<007ooOol0
1Goo00<007ooOol0<Goo00<07gooOol00Woo00<07gooOol0YGoo001oOol00`00Oomoo`05Ool00`00
Oomoo`0bOol01@0OOomoogoo01l0Ygoo001oOol00`00Oomoo`05Ool3000bOol01@0OOomoogoo01l0
Ygoo001oOol00`00Oomoo`05Ool00`00Oomoo`0bOol01@0OOomoogoo01l0Ygoo001oOol00`00Oomo
o`05Ool00`00Oomoo`0bOol01@0OOomoogoo01l0Ygoo001mOol30007Ool00`00Oomoo`0bOol01@0O
Oomoogoo01l0Ygoo001oOol00`00Oomoo`05Ool00`00Oomoo`0bOol01@0OOomoogoo01l0Ygoo0027
Ool00`00Oomoo`0bOol01@0OOomoogoo01l0Ygoo0027Ool00`00Oomoo`0bOol01@0OOomoogoo01l0
Ygoo0027Ool2000dOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027
Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027
Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027
Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool2000dOol0100OOomoo`0OYgoo0027Ool00`00
Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00
Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00
Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool2000d
Ool0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0c
Ool0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0c
Ool0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0c
Ool0100OOomoo`0OYgoo0027Ool2000dOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100O
Oomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo0027Ool00`00Oomoo`0cOol0100O
Oomoo`0OYgoo001lOol50006Ool00`00Oomoo`0cOol0100OOomoo`0OYgoo001lOol01@00Oomoogoo
00001Woo00<007ooOol0=7oo00<07goo01l0Ygoo001mOol00`00Oomoo`07Ool00`00Oomoo`0dOol0
0`0OOol07`2WOol007ioo`03001oogoo00Ioo`<003Aoo`0301moo`0O0:Moo`00Ogoo00<007ooOol0
1Goo00<007ooOol0=7oo00<07goo01l0Ygoo0020Ool00`00Oomoo`04Ool00`00Oomoo`0dOol00`0O
Ool07`2WOol007aoo`05001oogooOol00006Ool00`00Oomoo`0dOol00`0OOol07`2WOol007eoo`<0
00Moo`03001oogoo03Aoo`0301moo`0O0:Moo`00Qgoo00<007ooOol0=7oo00<07goo01l0Ygoo0027
Ool2000eOol00`0OOol07`2WOol008Moo`03001oogoo03Aoo`0301moo`0O0:Moo`00Qgoo00<007oo
Ool0=7oo00<07goo01l0Ygoo0027Ool00`00Oomoo`0dOol00`0OOol07`2WOol008Moo`03001oogoo
03Aoo`0301moo`0O0:Moo`00Qgoo00<007ooOol0=7oo00<07goo01l0Ygoo0027Ool00`00Oomoo`0d
Ool00`0OOol07`2WOol008Moo`8003Eoo`0301moo`0O0:Moo`00Qgoo00<007ooOol0=7oo00<07goo
01l0Ygoo0027Ool00`00Oomoo`0dOol00`0OOol07`2WOol008Moo`03001oogoo03Aoo`0301moo`0O
0:Moo`00Qgoo00<007ooOol0=7oo00<07goo01l0Ygoo0027Ool00`00Oomoo`0dOol00`0OOol07`2W
Ool008Moo`03001oogoo03Aoo`0301moo`0O0:Moo`00Qgoo0P00=Goo00<07goo01l0Ygoo0027Ool0
0`00Oomoo`0dOol00`0OOol07`2WOol008Moo`03001oogoo03Aoo`0301moo`0O0:Moo`00Qgoo00<0
07ooOol0=7oo00<07goo01l0Ygoo0027Ool00`00Oomoo`0dOol00`0OOol07`2WOol008Moo`03001o
ogoo03Aoo`0301moo`0O0:Moo`00Qgoo00<007ooOol0=7oo00<07goo01l0Ygoo0027Ool2000eOol0
0`0OOol07`2WOol008Moo`03001oogoo03Aoo`0301moo`0O0:Moo`00Qgoo00<007ooOol0=7oo00<0
7goo01l0Ygoo0027Ool00`00Oomoo`0dOol00`0OOol07`2WOol007eoo`<000Moo`03001oogoo03Ao
o`0301moo`0O0:Moo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo03Aoo`0301moo`0O0:Moo`00
P7oo00<007ooOol017oo00<007ooOol0=7oo00<07goo01l0Ygoo0020Ool00`00Oomoo`04Ool3000d
Ool00`0OOol07`2WOol007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo0000
igoo001mOol3003XOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028Ool3
000017oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31131 m
.04057 .31148 L
.08481 .31171 L
.12636 .31196 L
.16632 .31225 L
.20885 .31263 L
.2498 .31308 L
.29331 .31372 L
.33524 .31455 L
.37557 .31568 L
.3964 .31647 L
.41848 .31753 L
.439 .31884 L
.45821 .32049 L
.46911 .3217 L
.47947 .32311 L
.48967 .32485 L
.49892 .32684 L
.50899 .32966 L
.51414 .33148 L
.51972 .33385 L
.52489 .33654 L
.52966 .3396 L
.53456 .34354 L
.53902 .34813 L
.54396 .35487 L
.54667 .35968 L
.54925 .36527 L
.55146 .37117 L
.55382 .37897 L
.5564 .39014 L
.55879 .4042 L
.56012 .41441 L
.56135 .4259 L
.56269 .44179 L
.56411 .46397 L
.56534 .49043 L
.56649 .5247 L
.56775 .58109 L
s
.56775 .58109 m
.56823 .61803 L
s
.57305 .61803 m
.57323 0 L
s
.57691 0 m
.57768 .05166 L
.57837 .08229 L
.57912 .10832 L
.58049 .14302 L
.58117 .1562 L
.58189 .16802 L
.58318 .18516 L
.58456 .19949 L
.58608 .21182 L
.58881 .22814 L
.59135 .23909 L
.59383 .24727 L
.5961 .25321 L
.60118 .26313 L
.604 .26725 L
.60661 .27045 L
.61251 .27614 L
.6177 .27993 L
.62322 .2831 L
.63308 .28732 L
.6437 .29056 L
.65373 .29284 L
.66291 .29449 L
.68282 .29711 L
.6941 .29822 L
.70457 .29907 L
.72609 .30047 L
.74562 .30143 L
.76751 .30228 L
.78766 .30291 L
.8281 .30388 L
.86953 .3046 L
.90937 .30512 L
.95178 .30556 L
.9926 .30589 L
1 .30595 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<003ioo`0301moo`0O09eoo`00OWoo0P001goo00<007ooOol0
?Woo00<07goo01l0WGoo0020Ool00`00Oomoo`04Ool00`00Oomoo`0nOol00`0OOol07`2MOol007ao
o`05001oogooOol00006Ool00`00Oomoo`0nOol00`0OOol07`2MOol007eoo`<000Moo`03001oogoo
03ioo`0301moo`0O09eoo`00Qgoo00<007ooOol0?Woo00<07goo01l0WGoo0027Ool00`00Oomoo`0n
Ool00`0OOol07`2MOol008Moo`8003moo`0301moo`0O09eoo`00Qgoo00<007ooOol0?Woo00<07goo
01l0WGoo0027Ool00`00Oomoo`0nOol00`0OOol07`2MOol008Moo`03001oogoo03ioo`0301moo`0O
09eoo`00Qgoo00<007ooOol0?Woo00<07goo01l0WGoo0027Ool00`00Oomoo`0nOol00`0OOol07`2M
Ool008Moo`8003moo`0301moo`0O09eoo`00Qgoo00<007ooOol0?Woo00<07goo01l0WGoo0027Ool0
0`00Oomoo`0nOol00`0OOol07`2MOol008Moo`03001oogoo03ioo`0301moo`0O09eoo`00Qgoo00<0
07ooOol0?Woo00<07goo01l0WGoo0027Ool00`00Oomoo`0nOol00`0OOol07`2MOol008Moo`03001o
ogoo03ioo`0301moo`0O09eoo`00Qgoo0P00?goo00<07goo01l0WGoo0027Ool00`00Oomoo`0nOol0
0`0OOol07`2MOol008Moo`03001oogoo03ioo`0301moo`0O09eoo`00Qgoo00<007ooOol0?Woo00<0
7goo01l0WGoo0027Ool00`00Oomoo`0nOol00`0OOol07`2MOol008Moo`03001oogoo03ioo`0301mo
o`0O09eoo`00Qgoo00<007ooOol0?Woo00<07goo01l0WGoo0027Ool2000oOol00`0OOol07`2MOol0
08Moo`03001oogoo03ioo`0301moo`0O09eoo`00Qgoo00<007ooOol0?Woo00<07goo01l0WGoo0027
Ool00`00Oomoo`0nOol00`0OOol07`2MOol007aoo`D000Ioo`03001oogoo03ioo`0301moo`0O09eo
o`00O7oo00D007ooOomoo`0000Ioo`03001oogoo03ioo`0301moo`0O09eoo`00OGoo00<007ooOol0
1goo00<007ooOol0?Woo00<07goo01l0WGoo001dOol60004Ool00`00Oomoo`06Ool3000nOol00`0O
Ool07`2MOol007moo`03001oogoo00Eoo`03001oogoo03ioo`0301moo`0O09eoo`00P7oo00<007oo
Ool017oo00<007ooOol0?Woo00<07goo01l0WGoo001lOol01@00Oomoogoo00001Woo00<007ooOol0
?Woo00<07goo01l0WGoo001mOol30007Ool00`00Oomoo`0nOol00`0OOol07`2MOol008Moo`03001o
ogoo03ioo`0301moo`0O09eoo`00Qgoo00<007ooOol0?Woo00<07goo01l0WGoo0027Ool2000oOol0
0`0OOol07`2MOol008Moo`03001oogoo03ioo`0401moogoo01nLOol008Moo`03001oogoo03ioo`04
01moogoo01nLOol008Moo`03001oogoo03ioo`0401moogoo01nLOol008Moo`03001oogoo03ioo`04
01moogoo01nLOol008Moo`03001oogoo03ioo`0401moogoo01nLOol008Moo`03001oogoo03ioo`04
01moogoo01nLOol008Moo`8003moo`0401moogoo01nLOol008Moo`03001oogoo03ioo`0401moogoo
01nLOol008Moo`03001oogoo03ioo`0401moogoo01nLOol008Moo`03001oogoo03ioo`0401moogoo
01nLOol008Moo`03001oogoo03ioo`0401moogoo01nLOol008Moo`03001oogoo03ioo`0401moogoo
01nLOol008Moo`8003moo`0401moogoo01nLOol008Moo`03001oogoo03ioo`0401moogoo01nLOol0
08Moo`03001oogoo03ioo`0401moogoo01nLOol008Moo`03001oogoo03ioo`0401moogoo01nLOol0
08Moo`03001oogoo03ioo`0501moogooOol07`2KOol008Moo`03001oogoo03ioo`0501moogooOol0
7`2KOol008Moo`03001oogoo03ioo`0501moogooOol07`2KOol008Moo`8003moo`0501moogooOol0
7`2KOol008Moo`03001oogoo03ioo`0501moogooOol07`2KOol008Moo`03001oogoo03ioo`0501mo
ogooOol07`2KOol008Moo`03001oogoo03ioo`0501moogooOol07`2KOol007eoo`D000Eoo`03001o
ogoo03ioo`0501moogooOol07`2KOol007moo`03001oogoo00Eoo`03001oogoo03ioo`0501moogoo
Ool07`2KOol007moo`03001oogoo00Eoo`03001oogoo03ioo`0501moogooOol07`2KOol007Aoo`H0
00Eoo`03001oogoo00Eoo`<003ioo`0301moogoo009oo`0301moogoo09Qoo`00Ogoo00<007ooOol0
1Goo00<007ooOol0?Woo00<07gooOol00Woo00<07gooOol0V7oo001oOol00`00Oomoo`05Ool00`00
Oomoo`0nOol00`0OOomoo`02Ool00`0OOomoo`2HOol007eoo`<000Moo`03001oogoo03ioo`0301mo
ogoo009oo`0301moogoo09Qoo`00Ogoo00<007ooOol01Goo00<007ooOol0?Woo00<07gooOol00Woo
00<07gooOol0V7oo0027Ool00`00Oomoo`0nOol00`0OOomoo`03Ool00`0OOomoo`2GOol008Moo`03
001oogoo03ioo`0301moogoo00=oo`0301moogoo09Moo`00Qgoo0P00?goo00<07gooOol00goo00<0
7gooOol0Ugoo0027Ool00`00Oomoo`0nOol00`0OOomoo`03Ool00`0OOomoo`2GOol008Moo`03001o
ogoo03ioo`0301moogoo00=oo`0301moogoo09Moo`00Qgoo00<007ooOol0?Woo00<07gooOol00goo
00<07gooOol0Ugoo0027Ool00`00Oomoo`0nOol00`0OOomoo`03Ool00`0OOomoo`2GOol008Moo`03
001oogoo03ioo`0301moogoo00=oo`0301moogoo09Moo`00Qgoo00<007ooOol0?Woo00<07gooOol0
17oo00<07gooOol0UWoo0027Ool2000oOol00`0OOomoo`04Ool00`0OOomoo`2FOol008Moo`03001o
ogoo03ioo`0301moogoo00Eoo`0301moogoo09Eoo`00Qgoo00<007ooOol0?Woo00<07gooOol01Goo
00<07gooOol0UGoo0027Ool00`00Oomoo`0nOol00`0OOomoo`06Ool00`0OOomoo`2DOol008Moo`03
001oogoo03ioo`0301moogoo00Ioo`0301moogoo09Aoo`0037oo0`009Woo1@009Goo1@008goo00<0
07ooOol097oo1@005Goo00<07gooOol01goo00<07gooOol00Woo1@009Goo0`00:7oo0`009Goo1000
47oo000;Ool01@00Oomoogoo00009Goo00D007ooOomoo`0002Moo`03001oogoo02=oo`03001oogoo
02Ioo`03001oogoo01Eoo`0301moogoo00Qoo`0501moogooOol00003Ool00`00Oomoo`0ROol01@00
Oomoogoo0000:7oo00<007ooOol08goo00<007ooOol00Woo00<007ooOol03Goo000?Ool00`00Oomo
o`0TOol00`00Oomoo`0XOol00`00Oomoo`0SOol2000WOol00`00Oomoo`0EOol00`0OOomoo`08Ool0
0`0OOomoo`02Ool00`00Oomoo`0YOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0=Ool0
00=oo`H000Ioo`03001oogoo01]oo`H000Aoo`03001oogoo01aoo`H000Eoo`03001oogoo02=oo`03
001oogoo02Ioo`03001oogoo01Eoo`0301moogoo00Uoo`0301moogoo009oo`03001oogoo02Qoo`03
001oogoo029oo`H002Uoo`03001oogoo00eoo`003Goo0P00:Goo00<007ooOol09Woo00<007ooOol0
8goo00<007ooOol09Woo00<007ooOol05Goo00<07gooOol02Woo00<07gooOol00Woo00<007ooOol0
9Goo0P009Woo00@007ooOol002Ioo`@0011oo`003goo00<007ooOol09goo00<007ooOol09Goo00<0
07ooOol08goo00<007ooOol09Woo00<007ooOol05Goo00<07gooOol02goo00<07gooOol00Woo00<0
07ooOol09Woo00<007ooOol08goo00@007ooOol002Ioo`03001oogoo015oo`002goo00D007ooOomo
o`0002Eoo`05001oogooOol0000UOol3000UOol00`00Oomoo`0TOol3000GOol00`0OOomoo`0<Ool0
1@0OOomoogoo000097oo00D007ooOomoo`0002Ioo`03001oo`0002Ioo`03001oogoo015oo`0037oo
0`009goo0`00:7oo00<007ooOol08goo00<007ooOol09Woo00<007ooOol05Goo00<07gooOol03Goo
0`0O9Woo0`00:7oo0P009Woo1@003goo0027Ool2000oOol00`0OOomoo`0@Ool301n:Ool008Moo`03
001oogoo03ioo`0301moogoo01=oo`@07hIoo`00Qgoo00<007ooOol0?Woo00<07gooOol05goo200O
OWoo0027Ool00`00Oomoo`0nOol00`0OOomoo`0OOol501miOol008Moo`03001oogoo03ioo`0301mo
ogoo02Aooa007fUoo`00Qgoo00<007ooOol0?Woo00<07gooOol0=7oo600ODGoo0027Ool00`00Oomo
o`0nOol00`0OOomoo`1<Oom001lAOol000Yookh0000301l0000008`0015oo`002WooC@0O1Woo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol017oo00<07`00Ool01Woo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol02Woo1@00000:Ool00`00Oomoo`0WOol00`00Oomoo`0POold01lUOol00`00Oomoo`0EOol0
0`0OOomoo`0?Ool00`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0:Ool0
1000Oomoogoo0@000027Ool01000Oomoogoo500O:Goo00<07gooOol0VGoo00<007ooOol00Goo0027
Ool00`00Oomoo`0EOol901lPOol00`0OOomoo`2JOol10001Ool1Ool008Moo`03001oogoo01ioo`L0
7aUoo`0301moogoo09Qoo`04001oogoo0001Ool008Moo`03001oogoo02Eoo`<07aIoo`0301moogoo
09Qoo`D00000Qgoo0P00:Goo0P0O57oo00<07gooOol0WGoo0027Ool00`00Oomoo`0ZOol401l@Ool0
0`0OOomoo`2MOol008Moo`03001oogoo02ioo`0301moogoo00eoo`0301moogoo09eoo`00Qgoo00<0
07ooOol0;goo0P0O3Goo00<07gooOol0WGoo0027Ool00`00Oomoo`0aOol00`0OOomoo`0:Ool00`0O
Oomoo`2MOol008Moo`03001oogoo039oo`0301moogoo00Uoo`0301moogoo09eoo`00Qgoo00<007oo
Ool0<goo00<07gooOol027oo00<07gooOol0WGoo0027Ool2000eOol00`0OOomoo`07Ool00`0OOomo
o`2MOol008Moo`03001oogoo03Eoo`0301moogoo00Ioo`0301moogoo09eoo`00Qgoo00<007ooOol0
=Woo00<07gooOol01Goo00<07gooOol0WGoo0027Ool00`00Oomoo`0fOol00`0OOomoo`05Ool00`0O
Oomoo`2MOol008Moo`03001oogoo03Ioo`0301moogoo00Eoo`0301moogoo09eoo`00Qgoo00<007oo
Ool0=Woo00<07gooOol01Goo00<07gooOol0WGoo0027Ool00`00Oomoo`0gOol00`0OOomoo`04Ool0
0`0OOomoo`2MOol008Moo`8003Qoo`0301moogoo00Aoo`0301moogoo09eoo`00Qgoo00<007ooOol0
>7oo00<07gooOol00goo00<07gooOol0WGoo0027Ool00`00Oomoo`0hOol00`0OOomoo`03Ool00`0O
Oomoo`2MOol008Moo`03001oogoo03Qoo`0301moogoo00=oo`0301moogoo09eoo`00Qgoo00<007oo
Ool0>Goo00<07gooOol00Woo00<07gooOol0WGoo0027Ool00`00Oomoo`0iOol00`0OOomoo`02Ool0
0`0OOomoo`2MOol008Moo`03001oogoo03Uoo`0301moogoo009oo`0301moogoo09eoo`00Qgoo0P00
>Woo00<07gooOol00Woo00<07gooOol0WGoo0027Ool00`00Oomoo`0iOol00`0OOomoo`02Ool00`0O
Oomoo`2MOol008Moo`03001oogoo03Yoo`0501moogooOol07`2OOol007eoo`D000Eoo`03001oogoo
03Yoo`0501moogooOol07`2OOol007moo`03001oogoo00Eoo`03001oogoo03Yoo`0501moogooOol0
7`2OOol007moo`03001oogoo00Eoo`03001oogoo03Yoo`0501moogooOol07`2OOol007moo`03001o
ogoo00Eoo`<003Yoo`0501moogooOol07`2OOol007moo`03001oogoo00Eoo`03001oogoo03Yoo`05
01moogooOol07`2OOol007moo`03001oogoo00Eoo`03001oogoo03Yoo`0501moogooOol07`2OOol0
07eoo`<000Moo`03001oogoo03Yoo`0501moogooOol07`2OOol007moo`03001oogoo00Eoo`03001o
ogoo03Yoo`0501moogooOol07`2OOol008Moo`03001oogoo03Yoo`0501moogooOol07`2OOol008Mo
o`03001oogoo03Yoo`0501moogooOol07`2OOol008Moo`8003]oo`0501moogooOol07`2OOol008Mo
o`03001oogoo03]oo`0401moogoo01nOOol008Moo`03001oogoo03]oo`0401moogoo01nOOol008Mo
o`03001oogoo03]oo`0401moogoo01nOOol008Moo`03001oogoo03]oo`0401moogoo01nOOol008Mo
o`03001oogoo03]oo`0401moogoo01nOOol008Moo`03001oogoo03]oo`0401moogoo01nOOol008Mo
o`8003aoo`0401moogoo01nOOol008Moo`03001oogoo03]oo`0401moogoo01nOOol008Moo`03001o
ogoo03]oo`0401moogoo01nOOol008Moo`03001oogoo03]oo`0401moogoo01nOOol008Moo`03001o
ogoo03]oo`0401moogoo01nOOol008Moo`03001oogoo03]oo`0401moogoo01nOOol008Moo`03001o
ogoo03]oo`0401moogoo01nOOol008Moo`8003aoo`0401moogoo01nOOol008Moo`03001oogoo03ao
o`0301moo`0O09moo`00Qgoo00<007ooOol0?7oo00<07goo01l0Wgoo0027Ool00`00Oomoo`0lOol0
0`0OOol07`2OOol008Moo`03001oogoo03aoo`0301moo`0O09moo`00Qgoo00<007ooOol0?7oo00<0
7goo01l0Wgoo0027Ool00`00Oomoo`0lOol00`0OOol07`2OOol008Moo`8003eoo`0301moo`0O09mo
o`00Qgoo00<007ooOol0?7oo00<07goo01l0Wgoo0027Ool00`00Oomoo`0lOol00`0OOol07`2OOol0
08Moo`03001oogoo03aoo`0301moo`0O09moo`00O7oo1@001Woo00<007ooOol0?7oo00<07goo01l0
Wgoo001lOol01@00Oomoogoo00001Woo00<007ooOol0?7oo00<07goo01l0Wgoo001mOol00`00Oomo
o`07Ool00`00Oomoo`0lOol00`0OOol07`2OOol007ioo`03001oogoo00Ioo`<003aoo`0301moo`0O
09moo`00Ogoo00<007ooOol01Goo00<007ooOol0?7oo00<07goo01l0Wgoo0020Ool00`00Oomoo`04
Ool00`00Oomoo`0lOol00`0OOol07`2OOol007aoo`05001oogooOol00006Ool00`00Oomoo`0lOol0
0`0OOol07`2OOol007eoo`<000Moo`03001oogoo03aoo`0301moo`0O09moo`00Qgoo00<007ooOol0
?7oo00<07goo01l0Wgoo0027Ool2000mOol00`0OOol07`2OOol008Moo`03001oogoo03aoo`0301mo
o`0O09moo`00Qgoo00<007ooOol0?7oo00<07goo01l0Wgoo0027Ool00`00Oomoo`0lOol00`0OOol0
7`2OOol008Moo`03001oogoo03aoo`0301moo`0O09moo`00Qgoo00<007ooOol0?7oo00<07goo01l0
Wgoo0027Ool00`00Oomoo`0mOol201nOOol008Moo`8003ioo`807imoo`00Qgoo00<007ooOol0?Goo
0P0OWgoo0027Ool00`00Oomoo`0mOol201nOOol008Moo`03001oogoo03eoo`807imoo`00Qgoo00<0
07ooOol0?Goo0P0OWgoo0027Ool00`00Oomoo`0mOol201nOOol008Moo`03001oogoo03eoo`807imo
o`00Qgoo0P00?Woo0P0OWgoo0027Ool00`00Oomoo`0mOol201nOOol008Moo`03001oogoo03eoo`80
7imoo`00Qgoo00<007ooOol0?Goo0P0OWgoo0027Ool00`00Oomoo`0mOol201nOOol008Moo`03001o
ogoo03eoo`807imoo`00Qgoo00<007ooOol0?Goo0P0OWgoo0027Ool2000nOol201nOOol008Moo`03
001oogoo03eoo`807imoo`00Qgoo00<007ooOol0?Goo0P0OWgoo0027Ool00`00Oomoo`0mOol201nO
Ool007eoo`<000Moo`03001oogoo03eoo`807imoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo
03eoo`807imoo`00P7oo00<007ooOol017oo00<007ooOol0?Goo0P0OWgoo0020Ool00`00Oomoo`04
Ool3000mOol201nOOol007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo0000
igoo001mOol3003XOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028Ool3
000017oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31121 m
.04057 .31137 L
.08481 .31158 L
.12636 .3118 L
.16632 .31206 L
.20885 .31239 L
.2498 .31279 L
.29331 .31333 L
.33524 .31402 L
.37557 .31493 L
.3964 .31554 L
.41848 .31635 L
.439 .31729 L
.45821 .31843 L
.47947 .32013 L
.49892 .32232 L
.50926 .32388 L
.51886 .32569 L
.52939 .32826 L
.53524 .33007 L
.54062 .33206 L
.55142 .33745 L
.5571 .34144 L
.5631 .34708 L
.56832 .35387 L
.57319 .36284 L
.57599 .36982 L
.57854 .37796 L
.57995 .38348 L
.58149 .39058 L
.58294 .39869 L
.58428 .40768 L
.58673 .42996 L
.58801 .44622 L
.58937 .46885 L
.59055 .49573 L
.59165 .53036 L
.59286 .58694 L
s
.59286 .58694 m
.59324 .61803 L
s
.59781 .61803 m
.598 0 L
s
.60191 0 m
.60235 .03413 L
.60373 .09569 L
.60504 .13309 L
.60576 .14852 L
.60643 .16076 L
.60769 .17923 L
.60905 .19459 L
.61052 .20756 L
.61316 .22479 L
.61559 .23616 L
.61826 .24556 L
.62119 .25343 L
.62425 .2598 L
.6271 .26455 L
.63237 .27129 L
.6381 .27663 L
.64351 .28044 L
.64851 .28325 L
.65797 .28728 L
.66801 .29038 L
.67787 .29267 L
.68849 .29458 L
.7077 .2971 L
.71778 .2981 L
.72878 .29901 L
.75095 .30046 L
.77158 .30147 L
.7936 .30232 L
.81454 .30297 L
.83722 .30354 L
.87926 .30436 L
.92228 .30497 L
.96371 .30543 L
1 .30576 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<004Moo`807iEoo`00OWoo0P001goo00<007ooOol0Agoo0P0O
UGoo0020Ool00`00Oomoo`04Ool00`00Oomoo`17Ool201nEOol007aoo`05001oogooOol00006Ool0
0`00Oomoo`17Ool201nEOol007eoo`<000Moo`03001oogoo04Moo`807iEoo`00Qgoo00<007ooOol0
Agoo0P0OUGoo0027Ool00`00Oomoo`17Ool201nEOol008Moo`8004Qoo`807iEoo`00Qgoo00<007oo
Ool0Agoo0P0OUGoo0027Ool00`00Oomoo`17Ool201nEOol008Moo`03001oogoo04Moo`807iEoo`00
Qgoo00<007ooOol0Agoo0P0OUGoo0027Ool00`00Oomoo`17Ool201nEOol008Moo`8004Qoo`807iEo
o`00Qgoo00<007ooOol0Agoo0P0OUGoo0027Ool00`00Oomoo`17Ool201nEOol008Moo`03001oogoo
04Moo`807iEoo`00Qgoo00<007ooOol0Agoo0P0OUGoo0027Ool00`00Oomoo`17Ool201nEOol008Mo
o`03001oogoo04Moo`807iEoo`00Qgoo0P00B7oo0P0OUGoo0027Ool00`00Oomoo`17Ool00`0OOol0
7`2DOol008Moo`03001oogoo04Moo`0301moo`0O09Aoo`00Qgoo00<007ooOol0Agoo00<07goo01l0
U7oo0027Ool00`00Oomoo`17Ool00`0OOol07`2DOol008Moo`03001oogoo04Moo`0301moo`0O09Ao
o`00Qgoo00<007ooOol0Agoo00<07goo01l0U7oo0027Ool20018Ool00`0OOol07`2DOol008Moo`03
001oogoo04Moo`0301moo`0O09Aoo`00Qgoo00<007ooOol0Agoo00<07goo01l0U7oo0027Ool00`00
Oomoo`17Ool00`0OOol07`2DOol007aoo`D000Ioo`03001oogoo04Moo`0301moo`0O09Aoo`00O7oo
00D007ooOomoo`0000Ioo`03001oogoo04Moo`0301moo`0O09Aoo`00OGoo00<007ooOol01goo00<0
07ooOol0Agoo00<07goo01l0U7oo001dOol60004Ool00`00Oomoo`06Ool30017Ool00`0OOol07`2D
Ool007moo`03001oogoo00Eoo`03001oogoo04Moo`0301moo`0O09Aoo`00P7oo00<007ooOol017oo
00<007ooOol0Agoo00<07goo01l0U7oo001lOol01@00Oomoogoo00001Woo00<007ooOol0Agoo00<0
7goo01l0U7oo001mOol30007Ool00`00Oomoo`17Ool00`0OOol07`2DOol008Moo`03001oogoo04Mo
o`0301moo`0O09Aoo`00Qgoo00<007ooOol0Agoo00<07goo01l0U7oo0027Ool20018Ool00`0OOol0
7`2DOol008Moo`03001oogoo04Moo`0301moo`0O09Aoo`00Qgoo00<007ooOol0Agoo00<07goo01l0
U7oo0027Ool00`00Oomoo`17Ool00`0OOol07`2DOol008Moo`03001oogoo04Moo`0301moo`0O09Ao
o`00Qgoo00<007ooOol0Agoo00<07goo01l0U7oo0027Ool00`00Oomoo`17Ool00`0OOol07`2DOol0
08Moo`8004Qoo`0301moo`0O09Aoo`00Qgoo00<007ooOol0Agoo00<07goo01l0U7oo0027Ool00`00
Oomoo`17Ool00`0OOol07`2DOol008Moo`03001oogoo04Moo`0301moo`0O09Aoo`00Qgoo00<007oo
Ool0Agoo00<07goo01l0U7oo0027Ool00`00Oomoo`17Ool00`0OOol07`2DOol008Moo`8004Qoo`03
01moo`0O09Aoo`00Qgoo00<007ooOol0Agoo00<07goo01l0U7oo0027Ool00`00Oomoo`17Ool0100O
Oomoo`0OTgoo0027Ool00`00Oomoo`17Ool0100OOomoo`0OTgoo0027Ool00`00Oomoo`17Ool0100O
Oomoo`0OTgoo0027Ool00`00Oomoo`17Ool0100OOomoo`0OTgoo0027Ool00`00Oomoo`17Ool0100O
Oomoo`0OTgoo0027Ool20018Ool0100OOomoo`0OTgoo0027Ool00`00Oomoo`17Ool0100OOomoo`0O
Tgoo0027Ool00`00Oomoo`17Ool0100OOomoo`0OTgoo0027Ool00`00Oomoo`17Ool0100OOomoo`0O
Tgoo001mOol50005Ool00`00Oomoo`17Ool0100OOomoo`0OTgoo001oOol00`00Oomoo`05Ool00`00
Oomoo`17Ool0100OOomoo`0OTgoo001oOol00`00Oomoo`05Ool00`00Oomoo`17Ool01@0OOomoogoo
01l0TWoo001dOol60005Ool00`00Oomoo`05Ool30017Ool01@0OOomoogoo01l0TWoo001oOol00`00
Oomoo`05Ool00`00Oomoo`17Ool01@0OOomoogoo01l0TWoo001oOol00`00Oomoo`05Ool00`00Oomo
o`17Ool01@0OOomoogoo01l0TWoo001mOol30007Ool00`00Oomoo`17Ool01@0OOomoogoo01l0TWoo
001oOol00`00Oomoo`05Ool00`00Oomoo`17Ool00`0OOomoo`02Ool00`0OOomoo`2?Ool008Moo`03
001oogoo04Moo`0301moogoo009oo`0301moogoo08moo`00Qgoo00<007ooOol0Agoo00<07gooOol0
0Woo00<07gooOol0Sgoo0027Ool20018Ool00`0OOomoo`02Ool00`0OOomoo`2?Ool008Moo`03001o
ogoo04Moo`0301moogoo009oo`0301moogoo08moo`00Qgoo00<007ooOol0Agoo00<07gooOol00Woo
00<07gooOol0Sgoo0027Ool00`00Oomoo`17Ool00`0OOomoo`02Ool00`0OOomoo`2?Ool008Moo`03
001oogoo04Moo`0301moogoo009oo`0301moogoo08moo`00Qgoo00<007ooOol0Agoo00<07gooOol0
0goo00<07gooOol0SWoo0027Ool00`00Oomoo`17Ool00`0OOomoo`03Ool00`0OOomoo`2>Ool008Mo
o`8004Qoo`0301moogoo00=oo`0301moogoo08ioo`00Qgoo00<007ooOol0Agoo00<07gooOol017oo
00<07gooOol0SGoo0027Ool00`00Oomoo`17Ool00`0OOomoo`04Ool00`0OOomoo`2=Ool008Moo`03
001oogoo04Moo`0301moogoo00Eoo`0301moogoo08aoo`00Qgoo00<007ooOol0Agoo00<07gooOol0
1Goo00<07gooOol0S7oo000<Ool3000VOol5000UOol5000SOol00`00Oomoo`0TOol5000NOol00`0O
Oomoo`03Ool300000`0O001oo`0TOol3000XOol3000UOol4000@Ool000]oo`05001oogooOol0000U
Ool01@00Oomoogoo00009goo00<007ooOol08goo00<007ooOol09Woo00<007ooOol07Woo00<07goo
Ool00goo00D007ooOomoo`0O02Aoo`05001oogooOol0000XOol00`00Oomoo`0SOol00`00Oomoo`02
Ool00`00Oomoo`0=Ool000moo`03001oogoo02Aoo`03001oogoo02Qoo`03001oogoo02=oo`8002Mo
o`03001oogoo01ioo`0301moogoo00Aoo`04001oogoo01lXOol00`00Oomoo`0VOol00`00Oomoo`0X
Ool00`00Oomoo`0=Ool000=oo`H000Ioo`03001oogoo01]oo`H000Aoo`03001oogoo01aoo`H000Eo
o`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo01ioo`0301moogoo00Eoo`04001oogoo01lW
Ool00`00Oomoo`0ROol6000YOol00`00Oomoo`0=Ool000eoo`8002Uoo`03001oogoo02Ioo`03001o
ogoo02=oo`03001oogoo02Ioo`03001oogoo01ioo`0301moogoo00Ioo`03001oogoo00807b=oo`80
02Ioo`04001oogoo000VOol4000@Ool000moo`03001oogoo02Moo`03001oogoo02Eoo`03001oogoo
02=oo`03001oogoo02Ioo`03001oogoo01ioo`0301moogoo00Moo`05001oogooOol07`0TOol00`00
Oomoo`0SOol01000Oomoo`009Woo00<007ooOol04Goo000;Ool01@00Oomoogoo00009Goo00D007oo
Oomoo`0002Eoo`<002Eoo`03001oogoo02Aoo`<0021oo`0301moogoo00=oo`05001oogooOol00004
Ool00`0OOomoo`0MOol01@00Oomoogoo00009Woo00<007oo00009Woo00<007ooOol04Goo000<Ool3
000WOol3000XOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0NOol00`0OOomoo`04Ool3
0006Ool201lNOol3000XOol2000VOol5000?Ool008Moo`8004Qoo`0301moogoo00moo`<07h9oo`00
Qgoo00<007ooOol0Agoo00<07gooOol04Woo100OOWoo0027Ool00`00Oomoo`17Ool00`0OOomoo`0F
Ool801mfOol008Moo`03001oogoo04Moo`0301moogoo01ioo`D07g5oo`00Qgoo00<007ooOol0Agoo
00<07gooOol08goo400OHGoo0027Ool00`00Oomoo`17Ool00`0OOomoo`0cOolP01m1Ool008Moo`03
001oogoo04Moo`0301moogoo05=ooc007a5oo`002Wooa`0000<07`000000P`004Goo000:OomK01l0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`0OOomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool5
000000Yoo`03001oogoo02Moo`03001oogoo02Ioo`03001oogoo00Eoobd07aioo`03001oogoo01io
o`0301moogoo00Ioo`03001oogoo02Ioo`03001oogoo02Ioo`03001oogoo02Moo`03001oogoo00Yo
o`04001oogooOol1000008Moo`03001oogoo00Qooa@07b]oo`0301moogoo091oo`03001oogoo005o
o`00Qgoo00<007ooOol077oo1`0O97oo00<07gooOol0TGoo0@000Goo0Goo0027Ool00`00Oomoo`0S
Ool801lLOol00`0OOomoo`2?Ool01000Oomoo`000Goo0027Ool00`00Oomoo`0[Ool301lIOol00`0O
Oomoo`2?Ool5000008Moo`8002moo`D07aAoo`0301moogoo09Aoo`00Qgoo00<007ooOol0<goo0P0O
4Woo00<07gooOol0U7oo0027Ool00`00Oomoo`0eOol201l@Ool00`0OOomoo`2DOol008Moo`03001o
ogoo03Moo`0301moogoo00eoo`0301moogoo09Aoo`00Qgoo00<007ooOol0>7oo0P0O3Goo00<07goo
Ool0U7oo0027Ool00`00Oomoo`0jOol00`0OOomoo`0:Ool00`0OOomoo`2DOol008Moo`03001oogoo
03]oo`0301moogoo00Uoo`0301moogoo09Aoo`00Qgoo0P00?Goo00<07gooOol027oo00<07gooOol0
U7oo0027Ool00`00Oomoo`0mOol00`0OOomoo`07Ool00`0OOomoo`2DOol008Moo`03001oogoo03eo
o`0301moogoo00Moo`0301moogoo09Aoo`00Qgoo00<007ooOol0?Woo00<07gooOol01Woo00<07goo
Ool0U7oo0027Ool00`00Oomoo`0nOol00`0OOomoo`06Ool00`0OOomoo`2DOol008Moo`03001oogoo
03moo`0301moogoo00Eoo`0301moogoo09Aoo`00Qgoo00<007ooOol0?goo00<07gooOol01Goo00<0
7gooOol0U7oo0027Ool20010Ool00`0OOomoo`05Ool00`0OOomoo`2DOol008Moo`03001oogoo041o
o`0301moogoo00Aoo`0301moogoo09Aoo`00Qgoo00<007ooOol0@7oo00<07gooOol017oo00<07goo
Ool0U7oo0027Ool00`00Oomoo`11Ool00`0OOomoo`03Ool00`0OOomoo`2DOol008Moo`03001oogoo
045oo`0301moogoo00=oo`0301moogoo09Aoo`00Qgoo00<007ooOol0@Goo00<07gooOol00goo00<0
7gooOol0U7oo0027Ool00`00Oomoo`11Ool00`0OOomoo`03Ool00`0OOomoo`2DOol008Moo`80049o
o`0301moogoo00=oo`0301moogoo09Aoo`00Qgoo00<007ooOol0@Woo00<07gooOol00Woo00<07goo
Ool0U7oo0027Ool00`00Oomoo`12Ool00`0OOomoo`02Ool00`0OOomoo`2DOol007eoo`D000Eoo`03
001oogoo049oo`0301moogoo009oo`0301moogoo09Aoo`00Ogoo00<007ooOol01Goo00<007ooOol0
@Woo00<07gooOol00Woo00<07gooOol0U7oo001oOol00`00Oomoo`05Ool00`00Oomoo`12Ool00`0O
Oomoo`02Ool00`0OOomoo`2DOol007moo`03001oogoo00Eoo`<0049oo`0301moogoo009oo`0301mo
ogoo09Aoo`00Ogoo00<007ooOol01Goo00<007ooOol0@Woo00<07gooOol00Woo00<07gooOol0U7oo
001oOol00`00Oomoo`05Ool00`00Oomoo`12Ool00`0OOomoo`02Ool00`0OOomoo`2DOol007eoo`<0
00Moo`03001oogoo04=oo`0501moogooOol07`2FOol007moo`03001oogoo00Eoo`03001oogoo04=o
o`0501moogooOol07`2FOol008Moo`03001oogoo04=oo`0501moogooOol07`2FOol008Moo`03001o
ogoo04=oo`0501moogooOol07`2FOol008Moo`8004Aoo`0501moogooOol07`2FOol008Moo`03001o
ogoo04=oo`0501moogooOol07`2FOol008Moo`03001oogoo04=oo`0501moogooOol07`2FOol008Mo
o`03001oogoo04=oo`0501moogooOol07`2FOol008Moo`03001oogoo04=oo`0501moogooOol07`2F
Ool008Moo`03001oogoo04=oo`0501moogooOol07`2FOol008Moo`03001oogoo04=oo`0501moogoo
Ool07`2FOol008Moo`8004Aoo`0501moogooOol07`2FOol008Moo`03001oogoo04=oo`0501moogoo
Ool07`2FOol008Moo`03001oogoo04Aoo`0401moogoo01nFOol008Moo`03001oogoo04Aoo`0401mo
ogoo01nFOol008Moo`03001oogoo04Aoo`0401moogoo01nFOol008Moo`03001oogoo04Aoo`0401mo
ogoo01nFOol008Moo`03001oogoo04Aoo`0401moogoo01nFOol008Moo`8004Eoo`0401moogoo01nF
Ool008Moo`03001oogoo04Aoo`0401moogoo01nFOol008Moo`03001oogoo04Aoo`0401moogoo01nF
Ool008Moo`03001oogoo04Aoo`0401moogoo01nFOol008Moo`03001oogoo04Aoo`0401moogoo01nF
Ool008Moo`03001oogoo04Aoo`0401moogoo01nFOol008Moo`03001oogoo04Aoo`0401moogoo01nF
Ool008Moo`8004Eoo`0401moogoo01nFOol008Moo`03001oogoo04Aoo`0401moogoo01nFOol008Mo
o`03001oogoo04Aoo`0401moogoo01nFOol008Moo`03001oogoo04Aoo`0401moogoo01nFOol007ao
o`D000Ioo`03001oogoo04Aoo`0401moogoo01nFOol007aoo`05001oogooOol00006Ool00`00Oomo
o`14Ool0100OOomoo`0OUWoo001mOol00`00Oomoo`07Ool00`00Oomoo`15Ool00`0OOol07`2FOol0
07ioo`03001oogoo00Ioo`<004Eoo`0301moo`0O09Ioo`00Ogoo00<007ooOol01Goo00<007ooOol0
AGoo00<07goo01l0UWoo0020Ool00`00Oomoo`04Ool00`00Oomoo`15Ool00`0OOol07`2FOol007ao
o`05001oogooOol00006Ool00`00Oomoo`15Ool00`0OOol07`2FOol007eoo`<000Moo`03001oogoo
04Eoo`0301moo`0O09Ioo`00Qgoo00<007ooOol0AGoo00<07goo01l0UWoo0027Ool20016Ool00`0O
Ool07`2FOol008Moo`03001oogoo04Eoo`0301moo`0O09Ioo`00Qgoo00<007ooOol0AGoo00<07goo
01l0UWoo0027Ool00`00Oomoo`15Ool00`0OOol07`2FOol008Moo`03001oogoo04Eoo`0301moo`0O
09Ioo`00Qgoo00<007ooOol0AGoo00<07goo01l0UWoo0027Ool00`00Oomoo`15Ool00`0OOol07`2F
Ool008Moo`8004Ioo`0301moo`0O09Ioo`00Qgoo00<007ooOol0AGoo00<07goo01l0UWoo0027Ool0
0`00Oomoo`15Ool00`0OOol07`2FOol008Moo`03001oogoo04Eoo`0301moo`0O09Ioo`00Qgoo00<0
07ooOol0AGoo00<07goo01l0UWoo0027Ool00`00Oomoo`15Ool00`0OOol07`2FOol008Moo`03001o
ogoo04Eoo`0301moo`0O09Ioo`00Qgoo0P00AWoo00<07goo01l0UWoo0027Ool00`00Oomoo`15Ool0
0`0OOol07`2FOol008Moo`03001oogoo04Eoo`0301moo`0O09Ioo`00Qgoo00<007ooOol0AGoo00<0
7goo01l0UWoo0027Ool00`00Oomoo`15Ool00`0OOol07`2FOol008Moo`03001oogoo04Eoo`0301mo
o`0O09Ioo`00Qgoo00<007ooOol0AGoo00<07goo01l0UWoo0027Ool20016Ool00`0OOol07`2FOol0
08Moo`03001oogoo04Eoo`0301moo`0O09Ioo`00Qgoo00<007ooOol0AGoo00<07goo01l0UWoo0027
Ool00`00Oomoo`15Ool00`0OOol07`2FOol007eoo`<000Moo`03001oogoo04Eoo`0301moo`0O09Io
o`00O7oo00D007ooOomoo`0000Ioo`03001oogoo04Eoo`0301moo`0O09Ioo`00P7oo00<007ooOol0
17oo00<007ooOol0AGoo00<07goo01l0UWoo0020Ool00`00Oomoo`04Ool30015Ool00`0OOol07`2F
Ool007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo0000igoo001mOol3003X
Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028Ool3000017oo00000000
fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31113 m
.04057 .31127 L
.08481 .31146 L
.12636 .31166 L
.16632 .31189 L
.20885 .31219 L
.2498 .31254 L
.29331 .313 L
.33524 .31358 L
.37557 .31433 L
.39599 .31481 L
.41848 .31545 L
.44006 .31621 L
.4598 .31708 L
.48018 .31823 L
.5021 .31991 L
.52204 .32207 L
.53332 .32372 L
.5438 .32568 L
.55489 .32841 L
.56535 .33195 L
.57473 .33645 L
.58002 .33986 L
.58488 .34384 L
.58982 .34908 L
.59253 .3527 L
.59511 .35679 L
.5975 .36135 L
.6001 .3674 L
.60245 .37421 L
.60465 .38222 L
.60725 .39463 L
.60863 .40309 L
.61011 .41432 L
.61159 .42845 L
.61314 .44812 L
.61447 .47086 L
.61522 .48726 L
.61592 .50612 L
.61729 .55709 L
s
.61729 .55709 m
.61828 .61803 L
s
.62364 .61803 m
.62369 0 L
s
.62692 0 m
.62766 .05072 L
.62839 .08333 L
.62906 .10648 L
.63036 .14023 L
.63157 .16311 L
.633 .1831 L
.63431 .19717 L
.63585 .21009 L
.63727 .2197 L
.63968 .23228 L
.64232 .24254 L
.64489 .2502 L
.64765 .25666 L
.65288 .26571 L
.65784 .27179 L
.66228 .27596 L
.66711 .27954 L
.67701 .2849 L
.68264 .28716 L
.68792 .28893 L
.69854 .29174 L
.70999 .294 L
.72006 .29555 L
.73107 .29692 L
.75324 .29897 L
.77387 .30034 L
.79588 .30144 L
.81834 .30231 L
.83951 .30297 L
.87996 .30392 L
.92297 .30465 L
.9644 .30518 L
1 .30554 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<004moo`807heoo`00OWoo0P001goo00<007ooOol0Cgoo0P0O
SGoo0020Ool00`00Oomoo`04Ool00`00Oomoo`1?Ool201n=Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`1?Ool201n=Ool007eoo`<000Moo`03001oogoo04moo`807heoo`00Qgoo00<007ooOol0
Cgoo0P0OSGoo0027Ool00`00Oomoo`1?Ool201n=Ool008Moo`80051oo`807heoo`00Qgoo00<007oo
Ool0Cgoo0P0OSGoo0027Ool00`00Oomoo`1?Ool201n=Ool008Moo`03001oogoo04moo`807heoo`00
Qgoo00<007ooOol0Cgoo0P0OSGoo0027Ool00`00Oomoo`1?Ool201n=Ool008Moo`80051oo`807heo
o`00Qgoo00<007ooOol0Cgoo0P0OSGoo0027Ool00`00Oomoo`1?Ool201n=Ool008Moo`03001oogoo
04moo`807heoo`00Qgoo00<007ooOol0Cgoo0P0OSGoo0027Ool00`00Oomoo`1?Ool201n=Ool008Mo
o`03001oogoo04moo`807heoo`00Qgoo0P00D7oo0P0OSGoo0027Ool00`00Oomoo`1?Ool201n=Ool0
08Moo`03001oogoo04moo`0301moo`0O08aoo`00Qgoo00<007ooOol0Cgoo00<07goo01l0S7oo0027
Ool00`00Oomoo`1?Ool00`0OOol07`2<Ool008Moo`03001oogoo04moo`0301moo`0O08aoo`00Qgoo
00<007ooOol0Cgoo00<07goo01l0S7oo0027Ool2001@Ool00`0OOol07`2<Ool008Moo`03001oogoo
04moo`0301moo`0O08aoo`00Qgoo00<007ooOol0Cgoo00<07goo01l0S7oo0027Ool00`00Oomoo`1?
Ool00`0OOol07`2<Ool007aoo`D000Ioo`03001oogoo04moo`0301moo`0O08aoo`00O7oo00D007oo
Oomoo`0000Ioo`03001oogoo04moo`0301moo`0O08aoo`00OGoo00<007ooOol01goo00<007ooOol0
Cgoo00<07goo01l0S7oo001dOol60004Ool00`00Oomoo`06Ool3001?Ool00`0OOol07`2<Ool007mo
o`03001oogoo00Eoo`03001oogoo04moo`0301moo`0O08aoo`00P7oo00<007ooOol017oo00<007oo
Ool0Cgoo00<07goo01l0S7oo001lOol01@00Oomoogoo00001Woo00<007ooOol0Cgoo00<07goo01l0
S7oo001mOol30007Ool00`00Oomoo`1?Ool00`0OOol07`2<Ool008Moo`03001oogoo04moo`0301mo
o`0O08aoo`00Qgoo00<007ooOol0Cgoo00<07goo01l0S7oo0027Ool2001@Ool00`0OOol07`2<Ool0
08Moo`03001oogoo04moo`0301moo`0O08aoo`00Qgoo00<007ooOol0Cgoo00<07goo01l0S7oo0027
Ool00`00Oomoo`1?Ool00`0OOol07`2<Ool008Moo`03001oogoo04moo`0301moo`0O08aoo`00Qgoo
00<007ooOol0Cgoo00<07goo01l0S7oo0027Ool00`00Oomoo`1?Ool00`0OOol07`2<Ool008Moo`80
051oo`0301moo`0O08aoo`00Qgoo00<007ooOol0Cgoo00<07goo01l0S7oo0027Ool00`00Oomoo`1?
Ool0100OOomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100OOomoo`0ORgoo0027Ool00`00Oomoo`1?
Ool0100OOomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100OOomoo`0ORgoo0027Ool2001@Ool0100O
Oomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100OOomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100O
Oomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100OOomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100O
Oomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100OOomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100O
Oomoo`0ORgoo0027Ool2001@Ool0100OOomoo`0ORgoo0027Ool00`00Oomoo`1?Ool0100OOomoo`0O
Rgoo0027Ool00`00Oomoo`1?Ool01@0OOomoogoo01l0RWoo0027Ool00`00Oomoo`1?Ool01@0OOomo
ogoo01l0RWoo001mOol50005Ool00`00Oomoo`1?Ool01@0OOomoogoo01l0RWoo001oOol00`00Oomo
o`05Ool00`00Oomoo`1?Ool01@0OOomoogoo01l0RWoo001oOol00`00Oomoo`05Ool00`00Oomoo`1?
Ool01@0OOomoogoo01l0RWoo001dOol60005Ool00`00Oomoo`05Ool3001?Ool01@0OOomoogoo01l0
RWoo001oOol00`00Oomoo`05Ool00`00Oomoo`1?Ool01@0OOomoogoo01l0RWoo001oOol00`00Oomo
o`05Ool00`00Oomoo`1?Ool01@0OOomoogoo01l0RWoo001mOol30007Ool00`00Oomoo`1?Ool00`0O
Oomoo`02Ool00`0OOomoo`27Ool007moo`03001oogoo00Eoo`03001oogoo04moo`0301moogoo009o
o`0301moogoo08Moo`00Qgoo00<007ooOol0Cgoo00<07gooOol00Woo00<07gooOol0Qgoo0027Ool0
0`00Oomoo`1?Ool00`0OOomoo`02Ool00`0OOomoo`27Ool008Moo`80051oo`0301moogoo009oo`03
01moogoo08Moo`00Qgoo00<007ooOol0Cgoo00<07gooOol00Woo00<07gooOol0Qgoo0027Ool00`00
Oomoo`1?Ool00`0OOomoo`02Ool00`0OOomoo`27Ool008Moo`03001oogoo04moo`0301moogoo009o
o`0301moogoo08Moo`00Qgoo00<007ooOol0Cgoo00<07gooOol00goo00<07gooOol0QWoo0027Ool0
0`00Oomoo`1?Ool00`0OOomoo`03Ool00`0OOomoo`26Ool008Moo`03001oogoo04moo`0301moogoo
00=oo`0301moogoo08Ioo`00Qgoo0P00D7oo00<07gooOol017oo00<07gooOol0QGoo0027Ool00`00
Oomoo`1?Ool00`0OOomoo`04Ool00`0OOomoo`25Ool008Moo`03001oogoo04moo`0301moogoo00Eo
o`0301moogoo08Aoo`00Qgoo00<007ooOol0Cgoo00<07gooOol01Goo00<07gooOol0Q7oo0027Ool0
0`00Oomoo`1?Ool00`0OOomoo`06Ool00`0OOomoo`23Ool000aoo`<002Ioo`D002Eoo`D002=oo`03
001oogoo02Aoo`D002Aoo`80000301l0000000Ioo`0301moogoo01aoo`<002Qoo`<002Eoo`@0011o
o`002goo00D007ooOomoo`0002Eoo`05001oogooOol0000WOol00`00Oomoo`0SOol00`00Oomoo`0V
Ool00`00Oomoo`0TOol01@00Ool07goo00001goo00<07gooOol06Woo00D007ooOomoo`0002Qoo`03
001oogoo02=oo`03001oogoo009oo`03001oogoo00eoo`003goo00<007ooOol097oo00<007ooOol0
:7oo00<007ooOol08goo0P009goo00<007ooOol09Goo00<0000OOol02Goo00<07gooOol07Goo00<0
07ooOol09Woo00<007ooOol0:7oo00<007ooOol03Goo0003Ool60006Ool00`00Oomoo`0KOol60004
Ool00`00Oomoo`0LOol60005Ool00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0VOol00`0O
Oomoo`08Ool00`0OOomoo`0MOol00`00Oomoo`0ROol6000YOol00`00Oomoo`0=Ool000eoo`8002Uo
o`03001oogoo02Ioo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Ioo`0301l007oo00Uo
o`807a]oo`8002Ioo`04001oogoo000VOol4000@Ool000moo`03001oogoo02Moo`03001oogoo02Eo
o`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Ioo`0301moo`0000]oo`807a]oo`03001o
ogoo02=oo`04001oogoo000VOol00`00Oomoo`0AOol000]oo`05001oogooOol0000UOol01@00Oomo
ogoo00009Goo0`009Goo00<007ooOol097oo0`009Woo00D007oo01moo`0000eoo`807aEoo`05001o
ogooOol0000VOol00`00Ool0000VOol00`00Oomoo`0AOol000aoo`<002Moo`<002Qoo`03001oogoo
02=oo`03001oogoo02Ioo`03001oogoo02Eoo`0300007`00011oo`0301moogoo01=oo`<002Qoo`80
02Ioo`D000moo`00Qgoo0P00D7oo00<07gooOol047oo0P0ONWoo0027Ool00`00Oomoo`1?Ool00`0O
Oomoo`0BOol601mdOol008Moo`03001oogoo04moo`0301moogoo01Qoo`@07g1oo`00Qgoo00<007oo
Ool0Cgoo00<07gooOol077oo2@0OIgoo0027Ool00`00Oomoo`1?Ool00`0OOomoo`0UOol>01mIOol0
08Moo`03001oogoo04moo`0301moogoo03=ooaT07d1oo`00Qgoo00<007ooOol0Cgoo00<07gooOol0
C7oo;`0O4Goo000:Ooo?00000`0O0000001k000AOol000Yooe/07`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`0301l007oo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D000002Woo00<007ooOol09goo
00<007ooOol09Woo00<007ooOol01Goo=00O5goo00<007ooOol09Woo00<07`00Ool09goo00<007oo
Ool09Woo00<007ooOol09goo00<007ooOol02Woo00@007ooOomoo`400000Qgoo00<007ooOol03goo
5@0O:goo00<07gooOol0R7oo00<007ooOol00Goo0027Ool00`00Oomoo`0TOol601lUOol00`0OOomo
o`29Ool10001Ool1Ool008Moo`03001oogoo02Yoo`T07aaoo`0301moogoo08Moo`04001oogoo0001
Ool008Moo`03001oogoo03=oo`@07aQoo`0301moogoo08Moo`D00000Qgoo0P00>7oo0`0O5Goo00<0
7gooOol0S7oo0027Ool00`00Oomoo`0jOol401lAOol00`0OOomoo`2<Ool008Moo`03001oogoo03io
o`807`moo`0301moogoo08aoo`00Qgoo00<007ooOol0@7oo0P0O3Goo00<07gooOol0S7oo0027Ool0
0`00Oomoo`12Ool00`0OOomoo`0:Ool00`0OOomoo`2<Ool008Moo`03001oogoo049oo`0301moogoo
00Yoo`0301moogoo08aoo`00Qgoo00<007ooOol0@goo00<07gooOol02Goo00<07gooOol0S7oo0027
Ool20015Ool00`0OOomoo`08Ool00`0OOomoo`2<Ool008Moo`03001oogoo04Eoo`0301moogoo00Mo
o`0301moogoo08aoo`00Qgoo00<007ooOol0AWoo00<07gooOol01Woo00<07gooOol0S7oo0027Ool0
0`00Oomoo`16Ool00`0OOomoo`06Ool00`0OOomoo`2<Ool008Moo`03001oogoo04Ioo`0301moogoo
00Ioo`0301moogoo08aoo`00Qgoo00<007ooOol0Agoo00<07gooOol01Goo00<07gooOol0S7oo0027
Ool00`00Oomoo`17Ool00`0OOomoo`05Ool00`0OOomoo`2<Ool008Moo`8004Uoo`0301moogoo00Ao
o`0301moogoo08aoo`00Qgoo00<007ooOol0B7oo00<07gooOol017oo00<07gooOol0S7oo0027Ool0
0`00Oomoo`18Ool00`0OOomoo`04Ool00`0OOomoo`2<Ool008Moo`03001oogoo04Uoo`0301moogoo
00=oo`0301moogoo08aoo`00Qgoo00<007ooOol0BGoo00<07gooOol00goo00<07gooOol0S7oo0027
Ool00`00Oomoo`19Ool00`0OOomoo`03Ool00`0OOomoo`2<Ool008Moo`03001oogoo04Yoo`0301mo
ogoo009oo`0301moogoo08aoo`00Qgoo0P00Bgoo00<07gooOol00Woo00<07gooOol0S7oo0027Ool0
0`00Oomoo`1:Ool00`0OOomoo`02Ool00`0OOomoo`2<Ool008Moo`03001oogoo04Yoo`0301moogoo
009oo`0301moogoo08aoo`00OGoo1@001Goo00<007ooOol0BWoo00<07gooOol00Woo00<07gooOol0
S7oo001oOol00`00Oomoo`05Ool00`00Oomoo`1:Ool00`0OOomoo`02Ool00`0OOomoo`2<Ool007mo
o`03001oogoo00Eoo`03001oogoo04]oo`0501moogooOol07`2>Ool007moo`03001oogoo00Eoo`<0
04]oo`0501moogooOol07`2>Ool007moo`03001oogoo00Eoo`03001oogoo04]oo`0501moogooOol0
7`2>Ool007moo`03001oogoo00Eoo`03001oogoo04]oo`0501moogooOol07`2>Ool007eoo`<000Mo
o`03001oogoo04]oo`0501moogooOol07`2>Ool007moo`03001oogoo00Eoo`03001oogoo04]oo`05
01moogooOol07`2>Ool008Moo`03001oogoo04]oo`0501moogooOol07`2>Ool008Moo`03001oogoo
04]oo`0501moogooOol07`2>Ool008Moo`8004aoo`0501moogooOol07`2>Ool008Moo`03001oogoo
04]oo`0501moogooOol07`2>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`03001o
ogoo04aoo`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`03001o
ogoo04aoo`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`8004eo
o`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`03001oogoo04ao
o`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`03001oogoo04ao
o`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`03001oogoo04ao
o`0401moogoo01n>Ool008Moo`8004eoo`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401mo
ogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401mo
ogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`03001oogoo04aoo`0401mo
ogoo01n>Ool008Moo`03001oogoo04aoo`0401moogoo01n>Ool008Moo`8004eoo`0401moogoo01n>
Ool008Moo`03001oogoo04eoo`0301moo`0O08ioo`00Qgoo00<007ooOol0CGoo00<07goo01l0SWoo
0027Ool00`00Oomoo`1=Ool00`0OOol07`2>Ool007aoo`D000Ioo`03001oogoo04eoo`0301moo`0O
08ioo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo04eoo`0301moo`0O08ioo`00OGoo00<007oo
Ool01goo00<007ooOol0CGoo00<07goo01l0SWoo001nOol00`00Oomoo`06Ool3001=Ool00`0OOol0
7`2>Ool007moo`03001oogoo00Eoo`03001oogoo04eoo`0301moo`0O08ioo`00P7oo00<007ooOol0
17oo00<007ooOol0CGoo00<07goo01l0SWoo001lOol01@00Oomoogoo00001Woo00<007ooOol0CGoo
00<07goo01l0SWoo001mOol30007Ool00`00Oomoo`1=Ool00`0OOol07`2>Ool008Moo`03001oogoo
04eoo`0301moo`0O08ioo`00Qgoo0P00CWoo00<07goo01l0SWoo0027Ool00`00Oomoo`1=Ool00`0O
Ool07`2>Ool008Moo`03001oogoo04eoo`0301moo`0O08ioo`00Qgoo00<007ooOol0CGoo00<07goo
01l0SWoo0027Ool00`00Oomoo`1=Ool00`0OOol07`2>Ool008Moo`03001oogoo04eoo`0301moo`0O
08ioo`00Qgoo00<007ooOol0CGoo00<07goo01l0SWoo0027Ool2001>Ool00`0OOol07`2>Ool008Mo
o`03001oogoo04eoo`0301moo`0O08ioo`00Qgoo00<007ooOol0CGoo00<07goo01l0SWoo0027Ool0
0`00Oomoo`1=Ool00`0OOol07`2>Ool008Moo`03001oogoo04eoo`0301moo`0O08ioo`00Qgoo00<0
07ooOol0CGoo00<07goo01l0SWoo0027Ool00`00Oomoo`1=Ool00`0OOol07`2>Ool008Moo`8004io
o`0301moo`0O08ioo`00Qgoo00<007ooOol0CGoo00<07goo01l0SWoo0027Ool00`00Oomoo`1=Ool0
0`0OOol07`2>Ool008Moo`03001oogoo04eoo`0301moo`0O08ioo`00Qgoo00<007ooOol0CGoo00<0
7goo01l0SWoo0027Ool00`00Oomoo`1=Ool00`0OOol07`2>Ool008Moo`03001oogoo04eoo`0301mo
o`0O08ioo`00Qgoo0P00CWoo00<07goo01l0SWoo0027Ool00`00Oomoo`1=Ool00`0OOol07`2>Ool0
08Moo`03001oogoo04eoo`0301moo`0O08ioo`00Qgoo00<007ooOol0CGoo00<07goo01l0SWoo001m
Ool30007Ool00`00Oomoo`1=Ool00`0OOol07`2>Ool007aoo`05001oogooOol00006Ool00`00Oomo
o`1=Ool00`0OOol07`2>Ool0081oo`03001oogoo00Aoo`03001oogoo04eoo`0301moo`0O08ioo`00
P7oo00<007ooOol017oo0`00CGoo00<07goo01l0SWoo001nOol2003XOol0081oo`03001oogoo0>Eo
o`00O7oo00D007ooOomoo`000>Moo`00OGoo0`00j7oo003oOomYOol00?moofUoo`00ogooJGoo003o
OomYOol00?moofUoo`00R7oo0`0000Aoo`0000000=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31104 m
.04057 .31118 L
.08481 .31135 L
.12636 .31154 L
.16632 .31174 L
.20885 .31201 L
.2498 .31232 L
.29331 .31272 L
.33524 .31322 L
.37557 .31384 L
.39599 .31423 L
.41848 .31475 L
.4598 .31601 L
.48018 .31686 L
.5021 .31804 L
.51271 .31875 L
.5243 .31966 L
.53536 .32071 L
.54539 .32186 L
.55531 .32324 L
.56605 .32512 L
.57739 .32772 L
.58807 .33107 L
.59805 .33552 L
.60371 .33894 L
.609 .34304 L
.61459 .3488 L
.61968 .35606 L
.62249 .36134 L
.62555 .36861 L
.62845 .37762 L
.63112 .38877 L
.63366 .4033 L
.63599 .42223 L
.63721 .43554 L
.63854 .45422 L
.63921 .46591 L
.63993 .48067 L
.64123 .51571 L
.64246 .56523 L
s
.64246 .56523 m
.64324 .61803 L
s
.648 .61803 m
.64813 0 L
s
.65189 0 m
.65206 .01586 L
.65281 .05824 L
.65351 .08788 L
.6548 .12724 L
.65617 .15621 L
.65751 .17691 L
.65878 .19185 L
.66115 .21228 L
.66251 .22113 L
.66395 .22886 L
.66653 .23977 L
.66931 .24861 L
.67235 .25603 L
.675 .26115 L
.67787 .26569 L
.68309 .27206 L
.68818 .27669 L
.69288 .28004 L
.70354 .28556 L
.70892 .28762 L
.71485 .28951 L
.72548 .29217 L
.73521 .29404 L
.74656 .29576 L
.75712 .29704 L
.77703 .29888 L
.79878 .30034 L
.8203 .30142 L
.83983 .30219 L
.86172 .30289 L
.88187 .30341 L
.92231 .30424 L
.96374 .30487 L
1 .30529 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<005Moo`807hEoo`00OWoo0P001goo00<007ooOol0Egoo0P0O
QGoo0020Ool00`00Oomoo`04Ool00`00Oomoo`1GOol201n5Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`1GOol00`0OOol07`24Ool007eoo`<000Moo`03001oogoo05Moo`0301moo`0O08Aoo`00
Qgoo00<007ooOol0Egoo00<07goo01l0Q7oo0027Ool00`00Oomoo`1GOol00`0OOol07`24Ool008Mo
o`8005Qoo`0301moo`0O08Aoo`00Qgoo00<007ooOol0Egoo00<07goo01l0Q7oo0027Ool00`00Oomo
o`1GOol00`0OOol07`24Ool008Moo`03001oogoo05Moo`0301moo`0O08Aoo`00Qgoo00<007ooOol0
Egoo00<07goo01l0Q7oo0027Ool00`00Oomoo`1GOol00`0OOol07`24Ool008Moo`8005Qoo`0301mo
o`0O08Aoo`00Qgoo00<007ooOol0Egoo00<07goo01l0Q7oo0027Ool00`00Oomoo`1GOol00`0OOol0
7`24Ool008Moo`03001oogoo05Moo`0301moo`0O08Aoo`00Qgoo00<007ooOol0Egoo00<07goo01l0
Q7oo0027Ool00`00Oomoo`1GOol00`0OOol07`24Ool008Moo`03001oogoo05Moo`0301moo`0O08Ao
o`00Qgoo0P00F7oo00<07goo01l0Q7oo0027Ool00`00Oomoo`1GOol00`0OOol07`24Ool008Moo`03
001oogoo05Moo`0301moo`0O08Aoo`00Qgoo00<007ooOol0Egoo00<07goo01l0Q7oo0027Ool00`00
Oomoo`1GOol00`0OOol07`24Ool008Moo`03001oogoo05Moo`0301moo`0O08Aoo`00Qgoo00<007oo
Ool0Egoo00<07goo01l0Q7oo0027Ool2001HOol00`0OOol07`24Ool008Moo`03001oogoo05Moo`03
01moo`0O08Aoo`00Qgoo00<007ooOol0Egoo00<07goo01l0Q7oo0027Ool00`00Oomoo`1GOol00`0O
Ool07`24Ool007aoo`D000Ioo`03001oogoo05Moo`0301moo`0O08Aoo`00O7oo00D007ooOomoo`00
00Ioo`03001oogoo05Moo`0301moo`0O08Aoo`00OGoo00<007ooOol01goo00<007ooOol0Egoo00<0
7goo01l0Q7oo001dOol60004Ool00`00Oomoo`06Ool3001GOol00`0OOol07`24Ool007moo`03001o
ogoo00Eoo`03001oogoo05Moo`0301moo`0O08Aoo`00P7oo00<007ooOol017oo00<007ooOol0Egoo
00<07goo01l0Q7oo001lOol01@00Oomoogoo00001Woo00<007ooOol0Egoo00<07goo01l0Q7oo001m
Ool30007Ool00`00Oomoo`1GOol00`0OOol07`24Ool008Moo`03001oogoo05Moo`0301moo`0O08Ao
o`00Qgoo00<007ooOol0Egoo00<07goo01l0Q7oo0027Ool2001HOol00`0OOol07`24Ool008Moo`03
001oogoo05Moo`0301moo`0O08Aoo`00Qgoo00<007ooOol0Egoo00<07goo01l0Q7oo0027Ool00`00
Oomoo`1GOol00`0OOol07`24Ool008Moo`03001oogoo05Moo`0301moo`0O08Aoo`00Qgoo00<007oo
Ool0Egoo00<07goo01l0Q7oo0027Ool00`00Oomoo`1GOol0100OOomoo`0OPgoo0027Ool2001HOol0
100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0
100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0
100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomoo`0OPgoo0027Ool2001HOol0100OOomo
o`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomo
o`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomo
o`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomoo`0OPgoo0027Ool00`00Oomoo`1GOol0100OOomo
o`0OPgoo0027Ool2001HOol01@0OOomoogoo01l0PWoo0027Ool00`00Oomoo`1GOol01@0OOomoogoo
01l0PWoo0027Ool00`00Oomoo`1GOol01@0OOomoogoo01l0PWoo0027Ool00`00Oomoo`1GOol01@0O
Oomoogoo01l0PWoo001mOol50005Ool00`00Oomoo`1GOol01@0OOomoogoo01l0PWoo001oOol00`00
Oomoo`05Ool00`00Oomoo`1GOol01@0OOomoogoo01l0PWoo001oOol00`00Oomoo`05Ool00`00Oomo
o`1GOol00`0OOomoo`02Ool00`0OOomoo`1oOol007Aoo`H000Eoo`03001oogoo00Eoo`<005Moo`03
01moogoo009oo`0301moogoo07moo`00Ogoo00<007ooOol01Goo00<007ooOol0Egoo00<07gooOol0
0Woo00<07gooOol0Ogoo001oOol00`00Oomoo`05Ool00`00Oomoo`1GOol00`0OOomoo`02Ool00`0O
Oomoo`1oOol007eoo`<000Moo`03001oogoo05Moo`0301moogoo009oo`0301moogoo07moo`00Ogoo
00<007ooOol01Goo00<007ooOol0Egoo00<07gooOol00Woo00<07gooOol0Ogoo0027Ool00`00Oomo
o`1GOol00`0OOomoo`02Ool00`0OOomoo`1oOol008Moo`03001oogoo05Moo`0301moogoo009oo`03
01moogoo07moo`00Qgoo0P00F7oo00<07gooOol00Woo00<07gooOol0Ogoo0027Ool00`00Oomoo`1G
Ool00`0OOomoo`02Ool00`0OOomoo`1oOol008Moo`03001oogoo05Moo`0301moogoo009oo`0301mo
ogoo07moo`00Qgoo00<007ooOol0Egoo00<07gooOol00goo00<07gooOol0OWoo0027Ool00`00Oomo
o`1GOol00`0OOomoo`03Ool00`0OOomoo`1nOol008Moo`03001oogoo05Moo`0301moogoo00=oo`03
01moogoo07ioo`00Qgoo00<007ooOol0Egoo00<07gooOol017oo00<07gooOol0OGoo0027Ool2001H
Ool00`0OOomoo`04Ool00`0OOomoo`1mOol008Moo`03001oogoo05Moo`0301moogoo00Aoo`0301mo
ogoo07eoo`00Qgoo00<007ooOol0Egoo00<07gooOol01Goo00<07gooOol0O7oo0027Ool00`00Oomo
o`1GOol00`0OOomoo`05Ool00`0OOomoo`1lOol008Moo`03001oogoo05Moo`0301moogoo00Ioo`03
01moogoo07]oo`0037oo0`009Woo1@009Goo1@008goo00<007ooOol097oo1@0097oo1@001Goo00<0
7gooOol01goo00<07gooOol04goo0`00:7oo0`009Goo100047oo000;Ool01@00Oomoogoo00009Goo
00D007ooOomoo`0002Moo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Aoo`05001oogoo
Ool00005Ool00`0OOomoo`07Ool00`0OOomoo`0BOol01@00Oomoogoo0000:7oo00<007ooOol08goo
00<007ooOol00Woo00<007ooOol03Goo000?Ool00`00Oomoo`0TOol00`00Oomoo`0XOol00`00Oomo
o`0SOol2000WOol00`00Oomoo`0UOol00`00Oomoo`06Ool00`0OOomoo`08Ool00`0OOomoo`0EOol0
0`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0=Ool000=oo`H000Ioo`03001oogoo01]oo`H0
00Aoo`03001oogoo01aoo`H000Eoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Ioo`03
001oogoo00Eoo`0301moogoo00Uoo`0301moogoo01Aoo`03001oogoo029oo`H002Uoo`03001oogoo
00eoo`003Goo0P00:Goo00<007ooOol09Woo00<007ooOol08goo00<007ooOol09Woo00<007ooOol0
9goo00<007ooOol017oo00<07gooOol02Woo00<07gooOol04Goo0P009Woo00@007ooOol002Ioo`@0
011oo`003goo00<007ooOol09goo00<007ooOol09Goo00<007ooOol08goo00<007ooOol09Woo00<0
07ooOol0:7oo00<007ooOol00goo00<07gooOol02goo00<07gooOol04Woo00<007ooOol08goo00@0
07ooOol002Ioo`03001oogoo015oo`002goo00D007ooOomoo`0002Eoo`05001oogooOol0000UOol3
000UOol00`00Oomoo`0TOol3000VOol01@00Oomoogoo00001Goo00<07gooOol037oo0P0O3Woo00D0
07ooOomoo`0002Ioo`03001oo`0002Ioo`03001oogoo015oo`0037oo0`009goo0`00:7oo00<007oo
Ool08goo00<007ooOol09Woo00<007ooOol09Goo0`001Woo00<07gooOol03Woo0`0O37oo0`00:7oo
0P009Woo1@003goo0027Ool2001HOol00`0OOomoo`0AOol00`0OOomoo`1`Ool008Moo`03001oogoo
05Moo`0301moogoo019oo`<07fmoo`00Qgoo00<007ooOol0Egoo00<07gooOol05Goo1`0OJ7oo0027
Ool00`00Oomoo`1GOol00`0OOomoo`0LOol901mOOol008Moo`03001oogoo05Moo`0301moogoo02Eo
o`h07e5oo`00Qgoo00<007ooOol0Egoo00<07gooOol0<goo7`0O<Woo0027Ool00`00Oomoo`1GOol0
0`0OOomoo`1BOolQ01lAOol000YoomL0000301l0000007<0015oo`002WooJ@0O0goo00<007ooOol0
1Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Woo00<007ooOol017oo00<07`00Ool01Woo00<007ooOol01Goo00<007ooOol0
1Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
1Woo00<007ooOol01Goo00<007ooOol02Woo1@00000:Ool00`00Oomoo`0WOol00`00Oomoo`0VOol0
0`00Oomoo`0COolY01lDOol00`00Oomoo`0WOol00`00Oomoo`04Ool00`0OOomoo`0OOol00`00Oomo
o`0VOol00`00Oomoo`0WOol00`00Oomoo`0:Ool01000Oomoogoo0@000027Ool00`00Oomoo`0BOolJ
01l[Ool00`0OOomoo`20Ool00`00Oomoo`01Ool008Moo`03001oogoo02aoo`/07b1oo`0301moogoo
085oo`40005oo`5oo`00Qgoo00<007ooOol0=goo0`0O7Goo00<07gooOol0Ogoo00@007ooOol0005o
o`00Qgoo00<007ooOol0>Woo1`0O5Woo00<07gooOol0Ogoo1@000027Ool20012Ool201lDOol00`0O
Oomoo`24Ool008Moo`03001oogoo04=oo`807a9oo`0301moogoo08Aoo`00Qgoo00<007ooOol0AGoo
0`0O3goo00<07gooOol0Q7oo0027Ool00`00Oomoo`18Ool00`0OOomoo`0<Ool00`0OOomoo`24Ool0
08Moo`03001oogoo04Uoo`0301moogoo00]oo`0301moogoo08Aoo`00Qgoo00<007ooOol0BWoo00<0
7gooOol02Woo00<07gooOol0Q7oo0027Ool00`00Oomoo`1;Ool201l:Ool00`0OOomoo`24Ool008Mo
o`8004ioo`0301moogoo00Moo`0301moogoo08Aoo`00Qgoo00<007ooOol0CGoo00<07gooOol01goo
00<07gooOol0Q7oo0027Ool00`00Oomoo`1>Ool00`0OOomoo`06Ool00`0OOomoo`24Ool008Moo`03
001oogoo04moo`0301moogoo00Eoo`0301moogoo08Aoo`00Qgoo00<007ooOol0Cgoo00<07gooOol0
1Goo00<07gooOol0Q7oo0027Ool00`00Oomoo`1@Ool00`0OOomoo`04Ool00`0OOomoo`24Ool008Mo
o`03001oogoo051oo`0301moogoo00Aoo`0301moogoo08Aoo`00Qgoo0P00DGoo00<07gooOol017oo
00<07gooOol0Q7oo0027Ool00`00Oomoo`1AOol00`0OOomoo`03Ool00`0OOomoo`24Ool008Moo`03
001oogoo055oo`0301moogoo00=oo`0301moogoo08Aoo`00Qgoo00<007ooOol0DGoo00<07gooOol0
0goo00<07gooOol0Q7oo0027Ool00`00Oomoo`1BOol00`0OOomoo`02Ool00`0OOomoo`24Ool008Mo
o`03001oogoo059oo`0301moogoo009oo`0301moogoo08Aoo`00Qgoo00<007ooOol0DWoo00<07goo
Ool00Woo00<07gooOol0Q7oo0027Ool2001COol00`0OOomoo`02Ool00`0OOomoo`24Ool008Moo`03
001oogoo059oo`0301moogoo009oo`0301moogoo08Aoo`00Qgoo00<007ooOol0DWoo00<07gooOol0
0Woo00<07gooOol0Q7oo001mOol50005Ool00`00Oomoo`1BOol00`0OOomoo`02Ool00`0OOomoo`24
Ool007moo`03001oogoo00Eoo`03001oogoo059oo`0301moogoo009oo`0301moogoo08Aoo`00Ogoo
00<007ooOol01Goo00<007ooOol0DWoo00<07gooOol00Woo00<07gooOol0Q7oo001oOol00`00Oomo
o`05Ool3001BOol00`0OOomoo`02Ool00`0OOomoo`24Ool007moo`03001oogoo00Eoo`03001oogoo
05=oo`0501moogooOol07`26Ool007moo`03001oogoo00Eoo`03001oogoo05=oo`0501moogooOol0
7`26Ool007eoo`<000Moo`03001oogoo05=oo`0501moogooOol07`26Ool007moo`03001oogoo00Eo
o`03001oogoo05=oo`0501moogooOol07`26Ool008Moo`03001oogoo05=oo`0501moogooOol07`26
Ool008Moo`03001oogoo05Aoo`0401moogoo01n6Ool008Moo`8005Eoo`0401moogoo01n6Ool008Mo
o`03001oogoo05Aoo`0401moogoo01n6Ool008Moo`03001oogoo05Aoo`0401moogoo01n6Ool008Mo
o`03001oogoo05Aoo`0401moogoo01n6Ool008Moo`03001oogoo05Aoo`0401moogoo01n6Ool008Mo
o`03001oogoo05Aoo`0401moogoo01n6Ool008Moo`03001oogoo05Aoo`0401moogoo01n6Ool008Mo
o`8005Eoo`0401moogoo01n6Ool008Moo`03001oogoo05Aoo`0401moogoo01n6Ool008Moo`03001o
ogoo05Aoo`0401moogoo01n6Ool008Moo`03001oogoo05Aoo`0401moogoo01n6Ool008Moo`03001o
ogoo05Aoo`0401moogoo01n6Ool008Moo`03001oogoo05Aoo`0401moogoo01n6Ool008Moo`03001o
ogoo05Aoo`0401moogoo01n6Ool008Moo`8005Ioo`0301moo`0O08Ioo`00Qgoo00<007ooOol0EGoo
00<07goo01l0QWoo0027Ool00`00Oomoo`1EOol00`0OOol07`26Ool008Moo`03001oogoo05Eoo`03
01moo`0O08Ioo`00Qgoo00<007ooOol0EGoo00<07goo01l0QWoo0027Ool00`00Oomoo`1EOol00`0O
Ool07`26Ool008Moo`03001oogoo05Eoo`0301moo`0O08Ioo`00Qgoo0P00EWoo00<07goo01l0QWoo
0027Ool00`00Oomoo`1EOol00`0OOol07`26Ool008Moo`03001oogoo05Eoo`0301moo`0O08Ioo`00
Qgoo00<007ooOol0EGoo00<07goo01l0QWoo001lOol50006Ool00`00Oomoo`1EOol00`0OOol07`26
Ool007aoo`05001oogooOol00006Ool00`00Oomoo`1EOol00`0OOol07`26Ool007eoo`03001oogoo
00Moo`03001oogoo05Eoo`0301moo`0O08Ioo`00OWoo00<007ooOol01Woo0`00EGoo00<07goo01l0
QWoo001oOol00`00Oomoo`05Ool00`00Oomoo`1EOol00`0OOol07`26Ool0081oo`03001oogoo00Ao
o`03001oogoo05Eoo`0301moo`0O08Ioo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo05Eoo`03
01moo`0O08Ioo`00OGoo0`001goo00<007ooOol0EGoo00<07goo01l0QWoo0027Ool00`00Oomoo`1E
Ool00`0OOol07`26Ool008Moo`8005Ioo`0301moo`0O08Ioo`00Qgoo00<007ooOol0EGoo00<07goo
01l0QWoo0027Ool00`00Oomoo`1EOol00`0OOol07`26Ool008Moo`03001oogoo05Eoo`0301moo`0O
08Ioo`00Qgoo00<007ooOol0EGoo00<07goo01l0QWoo0027Ool00`00Oomoo`1EOol00`0OOol07`26
Ool008Moo`03001oogoo05Eoo`0301moo`0O08Ioo`00Qgoo0P00EWoo00<07goo01l0QWoo0027Ool0
0`00Oomoo`1EOol00`0OOol07`26Ool008Moo`03001oogoo05Eoo`0301moo`0O08Ioo`00Qgoo00<0
07ooOol0EGoo00<07goo01l0QWoo0027Ool00`00Oomoo`1EOol00`0OOol07`26Ool008Moo`03001o
ogoo05Eoo`0301moo`0O08Ioo`00Qgoo00<007ooOol0EGoo00<07goo01l0QWoo0027Ool2001FOol0
0`0OOol07`26Ool008Moo`03001oogoo05Eoo`0301moo`0O08Ioo`00Qgoo00<007ooOol0EGoo00<0
7goo01l0QWoo0027Ool00`00Oomoo`1EOol00`0OOol07`26Ool008Moo`03001oogoo05Eoo`0301mo
o`0O08Ioo`00Qgoo00<007ooOol0EWoo0P0OQWoo0027Ool00`00Oomoo`1FOol201n6Ool008Moo`80
05Moo`807hIoo`00Qgoo00<007ooOol0EWoo0P0OQWoo0027Ool00`00Oomoo`1FOol201n6Ool008Mo
o`03001oogoo05Ioo`807hIoo`00OGoo0`001goo00<007ooOol0EWoo0P0OQWoo001lOol01@00Oomo
ogoo00001Woo00<007ooOol0EWoo0P0OQWoo0020Ool00`00Oomoo`04Ool00`00Oomoo`1FOol201n6
Ool0081oo`03001oogoo00Aoo`<005Ioo`807hIoo`00OWoo0P00j7oo0020Ool00`00Oomoo`3UOol0
07aoo`05001oogooOol0003WOol007eoo`<00>Qoo`00ogooJGoo003oOomYOol00?moofUoo`00ogoo
JGoo003oOomYOol008Qoo`<00004Ool00000003IOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31097 m
.04057 .31109 L
.08481 .31125 L
.12636 .31142 L
.16632 .31161 L
.20885 .31185 L
.2498 .31212 L
.29331 .31248 L
.33524 .31291 L
.37557 .31344 L
.41848 .31418 L
.43982 .31466 L
.4598 .31519 L
.49953 .3166 L
.52079 .31766 L
.54024 .31893 L
.56017 .32069 L
.57146 .322 L
.58193 .3235 L
.59303 .32552 L
.60348 .32801 L
.61287 .331 L
.61812 .33312 L
.62302 .3355 L
.62824 .33862 L
.633 .34218 L
.63829 .34729 L
.64123 .35089 L
.64396 .35487 L
.6494 .36563 L
.65227 .37363 L
.65531 .38504 L
.65658 .39107 L
.65795 .39875 L
.66043 .41703 L
.66186 .43149 L
.66337 .45159 L
.66466 .47481 L
.66535 .49052 L
.66607 .51076 L
.66746 .56535 L
s
.66746 .56535 m
.66825 .61803 L
s
.6719 .61803 m
.67207 0 L
s
.67684 0 m
.67686 .00255 L
.67815 .07362 L
.67933 .11447 L
.68068 .14694 L
.68195 .16893 L
.68313 .18462 L
.68422 .19622 L
.68666 .21583 L
.68794 .22358 L
.68931 .23056 L
.69177 .24063 L
.6947 .24969 L
.69737 .25607 L
.70015 .26141 L
.70317 .26611 L
.70866 .27264 L
.71377 .27715 L
.71856 .28047 L
.72425 .28362 L
.72947 .28594 L
.7401 .28958 L
.75154 .29239 L
.76186 .29432 L
.77145 .29574 L
.78264 .29709 L
.7932 .29814 L
.81472 .29978 L
.83425 .3009 L
.85531 .30183 L
.8747 .30252 L
.91612 .30363 L
.95596 .30439 L
.99837 .30499 L
1 .30501 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<005moo`0301moo`0O07aoo`00OWoo0P001goo00<007ooOol0
Ggoo00<07goo01l0O7oo0020Ool00`00Oomoo`04Ool00`00Oomoo`1OOol00`0OOol07`1lOol007ao
o`05001oogooOol00006Ool00`00Oomoo`1OOol00`0OOol07`1lOol007eoo`<000Moo`03001oogoo
05moo`0301moo`0O07aoo`00Qgoo00<007ooOol0Ggoo00<07goo01l0O7oo0027Ool00`00Oomoo`1O
Ool00`0OOol07`1lOol008Moo`80061oo`0301moo`0O07aoo`00Qgoo00<007ooOol0Ggoo00<07goo
01l0O7oo0027Ool00`00Oomoo`1OOol00`0OOol07`1lOol008Moo`03001oogoo05moo`0301moo`0O
07aoo`00Qgoo00<007ooOol0Ggoo00<07goo01l0O7oo0027Ool00`00Oomoo`1OOol00`0OOol07`1l
Ool008Moo`80061oo`0301moo`0O07aoo`00Qgoo00<007ooOol0Ggoo00<07goo01l0O7oo0027Ool0
0`00Oomoo`1OOol00`0OOol07`1lOol008Moo`03001oogoo05moo`0301moo`0O07aoo`00Qgoo00<0
07ooOol0Ggoo00<07goo01l0O7oo0027Ool00`00Oomoo`1OOol00`0OOol07`1lOol008Moo`03001o
ogoo05moo`0301moo`0O07aoo`00Qgoo0P00H7oo00<07goo01l0O7oo0027Ool00`00Oomoo`1OOol0
0`0OOol07`1lOol008Moo`03001oogoo05moo`0301moo`0O07aoo`00Qgoo00<007ooOol0Ggoo00<0
7goo01l0O7oo0027Ool00`00Oomoo`1OOol00`0OOol07`1lOol008Moo`03001oogoo05moo`0301mo
o`0O07aoo`00Qgoo00<007ooOol0Ggoo00<07goo01l0O7oo0027Ool2001POol00`0OOol07`1lOol0
08Moo`03001oogoo05moo`0301moo`0O07aoo`00Qgoo00<007ooOol0Ggoo00<07goo01l0O7oo0027
Ool00`00Oomoo`1OOol00`0OOol07`1lOol007aoo`D000Ioo`03001oogoo05moo`0401moogoo01mk
Ool007aoo`05001oogooOol00006Ool00`00Oomoo`1OOol0100OOomoo`0ONgoo001mOol00`00Oomo
o`07Ool00`00Oomoo`1OOol0100OOomoo`0ONgoo001dOol60004Ool00`00Oomoo`06Ool3001OOol0
100OOomoo`0ONgoo001oOol00`00Oomoo`05Ool00`00Oomoo`1OOol0100OOomoo`0ONgoo0020Ool0
0`00Oomoo`04Ool00`00Oomoo`1OOol0100OOomoo`0ONgoo001lOol01@00Oomoogoo00001Woo00<0
07ooOol0Ggoo00@07gooOol07g]oo`00OGoo0`001goo00<007ooOol0Ggoo00@07gooOol07g]oo`00
Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00
Qgoo0P00H7oo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<0
07ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<0
07ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<0
07ooOol0Ggoo00@07gooOol07g]oo`00Qgoo0P00H7oo00@07gooOol07g]oo`00Qgoo00<007ooOol0
Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0
Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0
Ggoo00@07gooOol07g]oo`00Qgoo0P00H7oo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@0
7gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@0
7gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00@07gooOol07g]oo`00Qgoo00<007ooOol0Ggoo00D0
7gooOomoo`0O07Yoo`00Qgoo00<007ooOol0Ggoo00D07gooOomoo`0O07Yoo`00Qgoo0P00H7oo00D0
7gooOomoo`0O07Yoo`00Qgoo00<007ooOol0Ggoo00D07gooOomoo`0O07Yoo`00Qgoo00<007ooOol0
Ggoo00D07gooOomoo`0O07Yoo`00Qgoo00<007ooOol0Ggoo00D07gooOomoo`0O07Yoo`00OGoo1@00
1Goo00<007ooOol0Ggoo00D07gooOomoo`0O07Yoo`00Ogoo00<007ooOol01Goo00<007ooOol0Ggoo
00D07gooOomoo`0O07Yoo`00Ogoo00<007ooOol01Goo00<007ooOol0Ggoo00D07gooOomoo`0O07Yo
o`00M7oo1P001Goo00<007ooOol01Goo0`00Ggoo00<07gooOol00Woo00<07gooOol0Mgoo001oOol0
0`00Oomoo`05Ool00`00Oomoo`1OOol00`0OOomoo`02Ool00`0OOomoo`1gOol007moo`03001oogoo
00Eoo`03001oogoo05moo`0301moogoo009oo`0301moogoo07Moo`00OGoo0`001goo00<007ooOol0
Ggoo00<07gooOol00Woo00<07gooOol0Mgoo001oOol00`00Oomoo`05Ool00`00Oomoo`1OOol00`0O
Oomoo`02Ool00`0OOomoo`1gOol008Moo`03001oogoo05moo`0301moogoo009oo`0301moogoo07Mo
o`00Qgoo00<007ooOol0Ggoo00<07gooOol00Woo00<07gooOol0Mgoo0027Ool2001POol00`0OOomo
o`03Ool00`0OOomoo`1fOol008Moo`03001oogoo05moo`0301moogoo00=oo`0301moogoo07Ioo`00
Qgoo00<007ooOol0Ggoo00<07gooOol00goo00<07gooOol0MWoo0027Ool00`00Oomoo`1OOol00`0O
Oomoo`04Ool00`0OOomoo`1eOol008Moo`03001oogoo05moo`0301moogoo00Aoo`0301moogoo07Eo
o`00Qgoo00<007ooOol0Ggoo00<07gooOol017oo00<07gooOol0MGoo0027Ool00`00Oomoo`1OOol0
0`0OOomoo`04Ool00`0OOomoo`1eOol008Moo`80061oo`0301moogoo00Eoo`0301moogoo07Aoo`00
Qgoo00<007ooOol0Ggoo00<07gooOol01Goo00<07gooOol0M7oo0027Ool00`00Oomoo`1OOol00`0O
Oomoo`06Ool00`0OOomoo`1cOol008Moo`03001oogoo05moo`0301moogoo00Ioo`0301moogoo07=o
o`00Qgoo00<007ooOol0Ggoo00<07gooOol01Woo00<07gooOol0Lgoo000<Ool3000VOol5000UOol5
000SOol00`00Oomoo`0TOol5000TOol5000=Ool00`0OOomoo`07Ool00`0OOomoo`0;Ool3000XOol3
000UOol4000@Ool000]oo`05001oogooOol0000UOol01@00Oomoogoo00009goo00<007ooOol08goo
00<007ooOol09Woo00<007ooOol097oo00D007ooOomoo`0000eoo`0301moogoo00Moo`0301moogoo
00Yoo`05001oogooOol0000XOol00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000mo
o`03001oogoo02Aoo`03001oogoo02Qoo`03001oogoo02=oo`8002Moo`03001oogoo02Eoo`03001o
ogoo00ioo`0301moogoo00Qoo`0301moogoo00eoo`03001oogoo02Ioo`03001oogoo02Qoo`03001o
ogoo00eoo`000goo1P001Woo00<007ooOol06goo1P0017oo00<007ooOol077oo1P001Goo00<007oo
Ool08goo00<007ooOol09Woo00<007ooOol09Woo00<007ooOol03Goo00<07gooOol02Goo00<07goo
Ool037oo00<007ooOol08Woo1P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomoo`0VOol0
0`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0<Ool00`0OOomoo`0:Ool0
0`0OOomoo`09Ool2000VOol01000Oomoo`009Woo100047oo000?Ool00`00Oomoo`0WOol00`00Oomo
o`0UOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0;Ool00`0OOomo
o`0;Ool00`0OOomoo`0:Ool00`00Oomoo`0SOol01000Oomoo`009Woo00<007ooOol04Goo000;Ool0
1@00Oomoogoo00009Goo00D007ooOomoo`0002Eoo`<002Eoo`03001oogoo02Aoo`<002Ioo`05001o
ogooOol0000=Ool00`0OOomoo`0<Ool201l6Ool01@00Oomoogoo00009Woo00<007oo00009Woo00<0
07ooOol04Goo000<Ool3000WOol3000XOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0U
Ool3000>Ool00`0OOomoo`0>Ool00`0OOomoo`04Ool3000XOol2000VOol5000?Ool008Moo`80061o
o`0301moogoo00moo`<07fYoo`00Qgoo00<007ooOol0Ggoo00<07gooOol04Woo100OIWoo0027Ool0
0`00Oomoo`1OOol00`0OOomoo`0FOol701mOOol008Moo`03001oogoo05moo`0301moogoo01eoo`L0
7eQoo`00Qgoo00<007ooOol0Ggoo00<07gooOol097oo300OC7oo0027Ool00`00Oomoo`1OOol00`0O
Oomoo`0`OolU01lWOol008Moo`03001oogoo05moo`0301moogoo05EooaH07a5oo`002Woog`0000<0
7`000000J`004Goo000:OomY01l3Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`04Ool00`0O001oo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool5
000000Yoo`03001oogoo02Moo`03001oogoo02Ioo`03001oogoo01=oocL07`Ioo`03001oogoo02Mo
o`03001oogoo00aoo`0301moogoo01Moo`03001oogoo02Ioo`03001oogoo02Moo`03001oogoo00Yo
o`04001oogooOol1000008Moo`03001oogoo021ooa007bmoo`0301moogoo07Qoo`03001oogoo005o
o`00Qgoo00<007ooOol0<7oo300O8goo00<07gooOol0NGoo0@000Goo0Goo0027Ool00`00Oomoo`0l
Ool701lLOol00`0OOomoo`1gOol01000Oomoo`000Goo0027Ool00`00Oomoo`13Ool401lHOol00`0O
Oomoo`1gOol5000008Moo`8004Qoo`<07aEoo`0301moogoo07aoo`00Qgoo00<007ooOol0BWoo100O
4Goo00<07gooOol0O7oo0027Ool00`00Oomoo`1>Ool201l?Ool00`0OOomoo`1lOol008Moo`03001o
ogoo051oo`807`eoo`0301moogoo07aoo`00Qgoo00<007ooOol0DWoo00<07gooOol02Woo00<07goo
Ool0O7oo0027Ool00`00Oomoo`1COol00`0OOomoo`09Ool00`0OOomoo`1lOol008Moo`03001oogoo
05Aoo`0301moogoo00Qoo`0301moogoo07aoo`00Qgoo0P00EWoo00<07gooOol01goo00<07gooOol0
O7oo0027Ool00`00Oomoo`1FOol00`0OOomoo`06Ool00`0OOomoo`1lOol008Moo`03001oogoo05Mo
o`0301moogoo00Eoo`0301moogoo07aoo`00Qgoo00<007ooOol0Egoo00<07gooOol01Goo00<07goo
Ool0O7oo0027Ool00`00Oomoo`1HOol00`0OOomoo`04Ool00`0OOomoo`1lOol008Moo`03001oogoo
05Qoo`0301moogoo00Aoo`0301moogoo07aoo`00Qgoo00<007ooOol0F7oo00<07gooOol017oo00<0
7gooOol0O7oo0027Ool2001JOol00`0OOomoo`03Ool00`0OOomoo`1lOol008Moo`03001oogoo05Uo
o`0301moogoo00=oo`0301moogoo07aoo`00Qgoo00<007ooOol0FGoo00<07gooOol00goo00<07goo
Ool0O7oo0027Ool00`00Oomoo`1JOol00`0OOomoo`02Ool00`0OOomoo`1lOol008Moo`03001oogoo
05Yoo`0301moogoo009oo`0301moogoo07aoo`00Qgoo00<007ooOol0FWoo00<07gooOol00Woo00<0
7gooOol0O7oo0027Ool00`00Oomoo`1JOol00`0OOomoo`02Ool00`0OOomoo`1lOol008Moo`8005]o
o`0301moogoo009oo`0301moogoo07aoo`00Qgoo00<007ooOol0FWoo00<07gooOol00Woo00<07goo
Ool0O7oo0027Ool00`00Oomoo`1JOol00`0OOomoo`02Ool00`0OOomoo`1lOol007eoo`D000Eoo`03
001oogoo05Yoo`0301moogoo009oo`0301moogoo07aoo`00Ogoo00<007ooOol01Goo00<007ooOol0
FWoo00<07gooOol00Woo00<07gooOol0O7oo001oOol00`00Oomoo`05Ool00`00Oomoo`1KOol01@0O
Oomoogoo01l0OWoo001oOol00`00Oomoo`05Ool3001KOol01@0OOomoogoo01l0OWoo001oOol00`00
Oomoo`05Ool00`00Oomoo`1KOol01@0OOomoogoo01l0OWoo001oOol00`00Oomoo`05Ool00`00Oomo
o`1KOol01@0OOomoogoo01l0OWoo001mOol30007Ool00`00Oomoo`1KOol01@0OOomoogoo01l0OWoo
001oOol00`00Oomoo`05Ool00`00Oomoo`1KOol01@0OOomoogoo01l0OWoo0027Ool00`00Oomoo`1L
Ool0100OOomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100OOomoo`0OOWoo0027Ool2001MOol0100O
Oomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100OOomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100O
Oomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100OOomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100O
Oomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100OOomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100O
Oomoo`0OOWoo0027Ool2001MOol0100OOomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100OOomoo`0O
OWoo0027Ool00`00Oomoo`1LOol0100OOomoo`0OOWoo0027Ool00`00Oomoo`1LOol0100OOomoo`0O
OWoo0027Ool00`00Oomoo`1MOol00`0OOol07`1nOol008Moo`03001oogoo05eoo`0301moo`0O07io
o`00Qgoo00<007ooOol0GGoo00<07goo01l0OWoo0027Ool2001NOol00`0OOol07`1nOol008Moo`03
001oogoo05eoo`0301moo`0O07ioo`00Qgoo00<007ooOol0GGoo00<07goo01l0OWoo0027Ool00`00
Oomoo`1MOol00`0OOol07`1nOol008Moo`03001oogoo05eoo`0301moo`0O07ioo`00Qgoo00<007oo
Ool0GGoo00<07goo01l0OWoo0027Ool00`00Oomoo`1MOol00`0OOol07`1nOol008Moo`8005ioo`03
01moo`0O07ioo`00Qgoo00<007ooOol0GGoo00<07goo01l0OWoo0027Ool00`00Oomoo`1MOol00`0O
Ool07`1nOol008Moo`03001oogoo05eoo`0301moo`0O07ioo`00O7oo1@001Woo00<007ooOol0GGoo
00<07goo01l0OWoo001lOol01@00Oomoogoo00001Woo00<007ooOol0GGoo00<07goo01l0OWoo001m
Ool00`00Oomoo`07Ool00`00Oomoo`1MOol00`0OOol07`1nOol007ioo`03001oogoo00Ioo`<005eo
o`0301moo`0O07ioo`00Ogoo00<007ooOol01Goo00<007ooOol0GGoo00<07goo01l0OWoo0020Ool0
0`00Oomoo`04Ool00`00Oomoo`1MOol00`0OOol07`1nOol007aoo`05001oogooOol00006Ool00`00
Oomoo`1MOol00`0OOol07`1nOol007eoo`<000Moo`03001oogoo05eoo`0301moo`0O07ioo`00Qgoo
00<007ooOol0GGoo00<07goo01l0OWoo0027Ool2001NOol00`0OOol07`1nOol008Moo`03001oogoo
05ioo`807gioo`00Qgoo00<007ooOol0GWoo0P0OOWoo0027Ool00`00Oomoo`1NOol201mnOol008Mo
o`03001oogoo05ioo`807gioo`00Qgoo00<007ooOol0GWoo0P0OOWoo0027Ool00`00Oomoo`1NOol2
01mnOol008Moo`8005moo`807gioo`00Qgoo00<007ooOol0GWoo0P0OOWoo0027Ool00`00Oomoo`1N
Ool201mnOol008Moo`03001oogoo05ioo`807gioo`00Qgoo00<007ooOol0GWoo0P0OOWoo0027Ool0
0`00Oomoo`1NOol201mnOol008Moo`03001oogoo05ioo`807gioo`00Qgoo0P00Ggoo0P0OOWoo0027
Ool00`00Oomoo`1NOol201mnOol008Moo`03001oogoo05ioo`807gioo`00Qgoo00<007ooOol0GWoo
0P0OOWoo0027Ool00`00Oomoo`1NOol201mnOol008Moo`03001oogoo05ioo`807gioo`00Qgoo00<0
07ooOol0GWoo0P0OOWoo0027Ool2001OOol201mnOol008Moo`03001oogoo05ioo`807gioo`00Qgoo
00<007ooOol0GWoo0P0OOWoo0027Ool00`00Oomoo`1NOol201mnOol007eoo`<000Moo`03001oogoo
05ioo`807gioo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo05ioo`807gioo`00P7oo00<007oo
Ool017oo00<007ooOol0GWoo0P0OOWoo0020Ool00`00Oomoo`04Ool3001NOol201mnOol007ioo`80
0>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo0000igoo001mOol3003XOol00?moofUo
o`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028Ool3000017oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .3109 m
.04057 .31101 L
.08481 .31116 L
.12636 .31131 L
.16632 .31149 L
.20885 .3117 L
.2498 .31195 L
.29331 .31226 L
.33524 .31264 L
.37557 .31309 L
.41848 .31372 L
.4598 .31454 L
.49953 .31564 L
.51991 .3164 L
.54183 .31744 L
.56402 .31884 L
.57423 .31966 L
.58512 .32069 L
.59602 .32194 L
.60591 .32334 L
.6153 .32497 L
.62522 .32716 L
.63574 .33024 L
.64543 .33418 L
.65082 .33709 L
.65585 .34047 L
.66137 .34527 L
.66424 .34839 L
.66729 .35235 L
.66993 .35648 L
.67284 .36207 L
.67552 .36851 L
.67797 .37596 L
.68086 .3875 L
.68237 .39531 L
.68396 .40542 L
.68526 .41559 L
.68665 .42913 L
.68817 .44858 L
.68959 .47333 L
.69028 .48887 L
.69101 .5089 L
.69232 .55874 L
.69305 .59893 L
s
.69305 .59893 m
.69331 .61803 L
s
.69714 .61803 m
.69734 0 L
s
.70187 0 m
.70198 .01062 L
.70322 .07621 L
.70433 .11459 L
.70553 .14398 L
.70685 .1674 L
.70823 .18584 L
.71072 .20912 L
.712 .21803 L
.7134 .22607 L
.71594 .23754 L
.71841 .24602 L
.7207 .25224 L
.72588 .26264 L
.7285 .26656 L
.73138 .27019 L
.73617 .275 L
.74132 .27901 L
.75064 .28428 L
.75587 .2865 L
.76072 .28823 L
.77173 .29132 L
.78245 .29355 L
.7939 .29539 L
.80468 .29676 L
.81635 .29797 L
.83752 .29964 L
.85843 .30086 L
.88054 .30184 L
.92038 .30313 L
.94084 .30362 L
.96279 .30407 L
1 .30468 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<006Qoo`807gAoo`00OWoo0P001goo00<007ooOol0J7oo0P0O
M7oo0020Ool00`00Oomoo`04Ool00`00Oomoo`1XOol201mdOol007aoo`05001oogooOol00006Ool0
0`00Oomoo`1XOol201mdOol007eoo`<000Moo`03001oogoo06Qoo`807gAoo`00Qgoo00<007ooOol0
J7oo0P0OM7oo0027Ool00`00Oomoo`1XOol201mdOol008Moo`8006Uoo`807gAoo`00Qgoo00<007oo
Ool0J7oo0P0OM7oo0027Ool00`00Oomoo`1XOol201mdOol008Moo`03001oogoo06Qoo`807gAoo`00
Qgoo00<007ooOol0J7oo0P0OM7oo0027Ool00`00Oomoo`1XOol201mdOol008Moo`8006Uoo`807gAo
o`00Qgoo00<007ooOol0J7oo00<07goo01l0Lgoo0027Ool00`00Oomoo`1XOol00`0OOol07`1cOol0
08Moo`03001oogoo06Qoo`0301moo`0O07=oo`00Qgoo00<007ooOol0J7oo00<07goo01l0Lgoo0027
Ool00`00Oomoo`1XOol00`0OOol07`1cOol008Moo`03001oogoo06Qoo`0301moo`0O07=oo`00Qgoo
0P00JGoo00<07goo01l0Lgoo0027Ool00`00Oomoo`1XOol00`0OOol07`1cOol008Moo`03001oogoo
06Qoo`0301moo`0O07=oo`00Qgoo00<007ooOol0J7oo00<07goo01l0Lgoo0027Ool00`00Oomoo`1X
Ool00`0OOol07`1cOol008Moo`03001oogoo06Qoo`0301moo`0O07=oo`00Qgoo00<007ooOol0J7oo
00<07goo01l0Lgoo0027Ool2001YOol00`0OOol07`1cOol008Moo`03001oogoo06Qoo`0301moo`0O
07=oo`00Qgoo00<007ooOol0J7oo00<07goo01l0Lgoo0027Ool00`00Oomoo`1XOol00`0OOol07`1c
Ool007aoo`D000Ioo`03001oogoo06Qoo`0301moo`0O07=oo`00O7oo00D007ooOomoo`0000Ioo`03
001oogoo06Qoo`0301moo`0O07=oo`00OGoo00<007ooOol01goo00<007ooOol0J7oo00<07goo01l0
Lgoo001dOol60004Ool00`00Oomoo`06Ool3001XOol00`0OOol07`1cOol007moo`03001oogoo00Eo
o`03001oogoo06Qoo`0301moo`0O07=oo`00P7oo00<007ooOol017oo00<007ooOol0J7oo00<07goo
01l0Lgoo001lOol01@00Oomoogoo00001Woo00<007ooOol0J7oo00<07goo01l0Lgoo001mOol30007
Ool00`00Oomoo`1XOol00`0OOol07`1cOol008Moo`03001oogoo06Qoo`0301moo`0O07=oo`00Qgoo
00<007ooOol0J7oo00<07goo01l0Lgoo0027Ool2001YOol00`0OOol07`1cOol008Moo`03001oogoo
06Qoo`0301moo`0O07=oo`00Qgoo00<007ooOol0J7oo00<07goo01l0Lgoo0027Ool00`00Oomoo`1X
Ool00`0OOol07`1cOol008Moo`03001oogoo06Qoo`0301moo`0O07=oo`00Qgoo00<007ooOol0J7oo
00<07goo01l0Lgoo0027Ool00`00Oomoo`1XOol00`0OOol07`1cOol008Moo`8006Uoo`0301moo`0O
07=oo`00Qgoo00<007ooOol0J7oo00<07goo01l0Lgoo0027Ool00`00Oomoo`1XOol00`0OOol07`1c
Ool008Moo`03001oogoo06Qoo`0401moogoo01mbOol008Moo`03001oogoo06Qoo`0401moogoo01mb
Ool008Moo`03001oogoo06Qoo`0401moogoo01mbOol008Moo`8006Uoo`0401moogoo01mbOol008Mo
o`03001oogoo06Qoo`0401moogoo01mbOol008Moo`03001oogoo06Qoo`0401moogoo01mbOol008Mo
o`03001oogoo06Qoo`0401moogoo01mbOol008Moo`03001oogoo06Qoo`0401moogoo01mbOol008Mo
o`03001oogoo06Qoo`0401moogoo01mbOol008Moo`03001oogoo06Qoo`0401moogoo01mbOol008Mo
o`8006Uoo`0401moogoo01mbOol008Moo`03001oogoo06Qoo`0401moogoo01mbOol008Moo`03001o
ogoo06Qoo`0401moogoo01mbOol008Moo`03001oogoo06Qoo`0401moogoo01mbOol007eoo`D000Eo
o`03001oogoo06Qoo`0501moogooOol07`1aOol007moo`03001oogoo00Eoo`03001oogoo06Qoo`05
01moogooOol07`1aOol007moo`03001oogoo00Eoo`03001oogoo06Qoo`0501moogooOol07`1aOol0
07Aoo`H000Eoo`03001oogoo00Eoo`<006Qoo`0501moogooOol07`1aOol007moo`03001oogoo00Eo
o`03001oogoo06Qoo`0501moogooOol07`1aOol007moo`03001oogoo00Eoo`03001oogoo06Qoo`05
01moogooOol07`1aOol007eoo`<000Moo`03001oogoo06Qoo`0501moogooOol07`1aOol007moo`03
001oogoo00Eoo`03001oogoo06Qoo`0501moogooOol07`1aOol008Moo`03001oogoo06Qoo`0501mo
ogooOol07`1aOol008Moo`03001oogoo06Qoo`0301moogoo009oo`0301moogoo06ioo`00Qgoo0P00
JGoo00<07gooOol00Woo00<07gooOol0KWoo0027Ool00`00Oomoo`1XOol00`0OOomoo`02Ool00`0O
Oomoo`1^Ool008Moo`03001oogoo06Qoo`0301moogoo00=oo`0301moogoo06eoo`00Qgoo00<007oo
Ool0J7oo00<07gooOol00goo00<07gooOol0KGoo0027Ool00`00Oomoo`1XOol00`0OOomoo`03Ool0
0`0OOomoo`1]Ool008Moo`03001oogoo06Qoo`0301moogoo00Aoo`0301moogoo06aoo`00Qgoo00<0
07ooOol0J7oo00<07gooOol017oo00<07gooOol0K7oo0027Ool2001YOol00`0OOomoo`04Ool00`0O
Oomoo`1/Ool008Moo`03001oogoo06Qoo`0301moogoo00Aoo`0301moogoo06aoo`00Qgoo00<007oo
Ool0J7oo00<07gooOol01Goo00<07gooOol0Jgoo0027Ool00`00Oomoo`1XOol00`0OOomoo`05Ool0
0`0OOomoo`1[Ool008Moo`03001oogoo06Qoo`0301moogoo00Ioo`0301moogoo06Yoo`0037oo0`00
9Woo1@009Goo1@008goo00<007ooOol097oo1@0097oo1@005Woo00<07gooOol01Woo00<07gooOol0
0goo0`00:7oo0`009Goo100047oo000;Ool01@00Oomoogoo00009Goo00D007ooOomoo`0002Moo`03
001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Aoo`05001oogooOol0000FOol00`0OOomoo`07
Ool01@0OOomoogoo00000goo00<007ooOol09Woo00<007ooOol08goo00<007ooOol00Woo00<007oo
Ool03Goo000?Ool00`00Oomoo`0TOol00`00Oomoo`0XOol00`00Oomoo`0SOol2000WOol00`00Oomo
o`0UOol00`00Oomoo`0GOol00`0OOomoo`08Ool00`0OOomoo`04Ool00`00Oomoo`0VOol00`00Oomo
o`0XOol00`00Oomoo`0=Ool000=oo`H000Ioo`03001oogoo01]oo`H000Aoo`03001oogoo01aoo`H0
00Eoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Ioo`03001oogoo01Ioo`0301moogoo
00Uoo`0301moogoo00=oo`03001oogoo029oo`H002Uoo`03001oogoo00eoo`003Goo0P00:Goo00<0
07ooOol09Woo00<007ooOol08goo00<007ooOol09Woo00<007ooOol09goo00<007ooOol05Goo00<0
7gooOol02Goo00@07gooOomoo`8002Ioo`04001oogoo000VOol4000@Ool000moo`03001oogoo02Mo
o`03001oogoo02Eoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo01Ao
o`0301moogoo00Yoo`807`=oo`03001oogoo02=oo`04001oogoo000VOol00`00Oomoo`0AOol000]o
o`05001oogooOol0000UOol01@00Oomoogoo00009Goo0`009Goo00<007ooOol097oo0`009Woo00D0
07ooOomoo`0001Ioo`0301moogoo00]oo`0500007`0OOol0000VOol00`00Ool0000VOol00`00Oomo
o`0AOol000aoo`<002Moo`<002Qoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Eoo`<0
01Moo`0301moogoo00aoo`80000301moogoo02Ioo`8002Ioo`D000moo`00Qgoo0P00JGoo00<07goo
Ool03goo1@0OGgoo0027Ool00`00Oomoo`1XOol00`0OOomoo`0DOol301mLOol008Moo`03001oogoo
06Qoo`0301moogoo01Moo`@07eQoo`00Qgoo00<007ooOol0J7oo00<07gooOol06goo1`0ODGoo0027
Ool00`00Oomoo`1XOol00`0OOomoo`0ROol=01m4Ool008Moo`03001oogoo06Qoo`0301moogoo02mo
ob807b9oo`00Qgoo00<007ooOol0J7oo00<07gooOol0DGoo4@0O4Goo000:OooX00000`0O0000001R
000AOol000YoogH07`Moo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`0301l007oo
00Moo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D000002Woo00<007ooOol09goo00<007ooOol09Woo
00<007ooOol087oo=00O9Woo00<007ooOol057oo00<07gooOol03goo00<007ooOol09Woo00<007oo
Ool09goo00<007ooOol02Woo00@007ooOomoo`400000Qgoo00<007ooOol0:Woo4`0O:Woo00<07goo
Ool0L7oo00<007ooOol00Goo0027Ool00`00Oomoo`0mOol701lSOol00`0OOomoo`1aOol10001Ool1
Ool008Moo`03001oogoo04Aoo`L07aaoo`0301moogoo06moo`04001oogoo0001Ool008Moo`03001o
ogoo04]oo`L07aEoo`0301moogoo06moo`D00000Qgoo0P00Dgoo0P0O4goo00<07gooOol0M7oo0027
Ool00`00Oomoo`1DOol201lAOol00`0OOomoo`1dOol008Moo`03001oogoo05Ioo`0301moogoo00io
o`0301moogoo07Aoo`00Qgoo00<007ooOol0Egoo0P0O3Woo00<07gooOol0M7oo0027Ool00`00Oomo
o`1IOol201l<Ool00`0OOomoo`1dOol008Moo`03001oogoo05]oo`807`Yoo`0301moogoo07Aoo`00
Qgoo00<007ooOol0GGoo00<07gooOol01goo00<07gooOol0M7oo0027Ool2001OOol00`0OOomoo`06
Ool00`0OOomoo`1dOol008Moo`03001oogoo05ioo`0301moogoo00Ioo`0301moogoo07Aoo`00Qgoo
00<007ooOol0GWoo00<07gooOol01Woo00<07gooOol0M7oo0027Ool00`00Oomoo`1OOol00`0OOomo
o`05Ool00`0OOomoo`1dOol008Moo`03001oogoo05moo`0301moogoo00Eoo`0301moogoo07Aoo`00
Qgoo00<007ooOol0H7oo00<07gooOol017oo00<07gooOol0M7oo0027Ool00`00Oomoo`1POol00`0O
Oomoo`04Ool00`0OOomoo`1dOol008Moo`80069oo`0301moogoo00=oo`0301moogoo07Aoo`00Qgoo
00<007ooOol0HGoo00<07gooOol00goo00<07gooOol0M7oo0027Ool00`00Oomoo`1QOol00`0OOomo
o`03Ool00`0OOomoo`1dOol008Moo`03001oogoo069oo`0301moogoo009oo`0301moogoo07Aoo`00
Qgoo00<007ooOol0HWoo00<07gooOol00Woo00<07gooOol0M7oo0027Ool00`00Oomoo`1ROol00`0O
Oomoo`02Ool00`0OOomoo`1dOol008Moo`03001oogoo069oo`0301moogoo009oo`0301moogoo07Ao
o`00Qgoo0P00I7oo00D07gooOomoo`0O07Ioo`00Qgoo00<007ooOol0Hgoo00D07gooOomoo`0O07Io
o`00Qgoo00<007ooOol0Hgoo00D07gooOomoo`0O07Ioo`00OGoo1@001Goo00<007ooOol0Hgoo00D0
7gooOomoo`0O07Ioo`00Ogoo00<007ooOol01Goo00<007ooOol0Hgoo00D07gooOomoo`0O07Ioo`00
Ogoo00<007ooOol01Goo00<007ooOol0Hgoo00D07gooOomoo`0O07Ioo`00Ogoo00<007ooOol01Goo
0`00I7oo00@07gooOol07gIoo`00Ogoo00<007ooOol01Goo00<007ooOol0I7oo00@07gooOol07gIo
o`00Ogoo00<007ooOol01Goo00<007ooOol0I7oo00@07gooOol07gIoo`00OGoo0`001goo00<007oo
Ool0I7oo00@07gooOol07gIoo`00Ogoo00<007ooOol01Goo00<007ooOol0I7oo00@07gooOol07gIo
o`00Qgoo00<007ooOol0I7oo00@07gooOol07gIoo`00Qgoo00<007ooOol0I7oo00@07gooOol07gIo
o`00Qgoo0P00IGoo00@07gooOol07gIoo`00Qgoo00<007ooOol0I7oo00@07gooOol07gIoo`00Qgoo
00<007ooOol0I7oo00@07gooOol07gIoo`00Qgoo00<007ooOol0IGoo00<07goo01l0MWoo0027Ool0
0`00Oomoo`1UOol00`0OOol07`1fOol008Moo`03001oogoo06Eoo`0301moo`0O07Ioo`00Qgoo00<0
07ooOol0IGoo00<07goo01l0MWoo0027Ool2001VOol00`0OOol07`1fOol008Moo`03001oogoo06Eo
o`0301moo`0O07Ioo`00Qgoo00<007ooOol0IGoo00<07goo01l0MWoo0027Ool00`00Oomoo`1UOol0
0`0OOol07`1fOol008Moo`03001oogoo06Eoo`0301moo`0O07Ioo`00Qgoo00<007ooOol0IGoo00<0
7goo01l0MWoo0027Ool00`00Oomoo`1UOol00`0OOol07`1fOol008Moo`8006Ioo`0301moo`0O07Io
o`00Qgoo00<007ooOol0IGoo00<07goo01l0MWoo0027Ool00`00Oomoo`1UOol00`0OOol07`1fOol0
08Moo`03001oogoo06Eoo`0301moo`0O07Ioo`00Qgoo00<007ooOol0IGoo00<07goo01l0MWoo0027
Ool00`00Oomoo`1UOol00`0OOol07`1fOol008Moo`03001oogoo06Eoo`0301moo`0O07Ioo`00Qgoo
0P00IWoo00<07goo01l0MWoo0027Ool00`00Oomoo`1UOol00`0OOol07`1fOol008Moo`03001oogoo
06Eoo`0301moo`0O07Ioo`00Qgoo00<007ooOol0IGoo00<07goo01l0MWoo001lOol50006Ool00`00
Oomoo`1UOol00`0OOol07`1fOol007aoo`05001oogooOol00006Ool00`00Oomoo`1UOol00`0OOol0
7`1fOol007eoo`03001oogoo00Moo`03001oogoo06Eoo`0301moo`0O07Ioo`00OWoo00<007ooOol0
1Woo0`00IGoo00<07goo01l0MWoo001oOol00`00Oomoo`05Ool00`00Oomoo`1UOol00`0OOol07`1f
Ool0081oo`03001oogoo00Aoo`03001oogoo06Eoo`0301moo`0O07Ioo`00O7oo00D007ooOomoo`00
00Ioo`03001oogoo06Eoo`0301moo`0O07Ioo`00OGoo0`001goo00<007ooOol0IGoo00<07goo01l0
MWoo0027Ool00`00Oomoo`1UOol00`0OOol07`1fOol008Moo`8006Moo`807gIoo`00Qgoo00<007oo
Ool0IWoo0P0OMWoo0027Ool00`00Oomoo`1VOol201mfOol008Moo`03001oogoo06Ioo`807gIoo`00
Qgoo00<007ooOol0IWoo0P0OMWoo0027Ool00`00Oomoo`1VOol201mfOol008Moo`03001oogoo06Io
o`807gIoo`00Qgoo0P00Igoo0P0OMWoo0027Ool00`00Oomoo`1VOol201mfOol008Moo`03001oogoo
06Ioo`807gIoo`00Qgoo00<007ooOol0IWoo0P0OMWoo0027Ool00`00Oomoo`1VOol201mfOol008Mo
o`03001oogoo06Ioo`807gIoo`00Qgoo00<007ooOol0IWoo0P0OMWoo0027Ool2001WOol201mfOol0
08Moo`03001oogoo06Ioo`807gIoo`00Qgoo00<007ooOol0IWoo0P0OMWoo0027Ool00`00Oomoo`1V
Ool201mfOol008Moo`03001oogoo06Ioo`807gIoo`00Qgoo00<007ooOol0IWoo0P0OMWoo0027Ool0
0`00Oomoo`1VOol201mfOol008Moo`8006Moo`807gIoo`00Qgoo00<007ooOol0IWoo0P0OMWoo0027
Ool00`00Oomoo`1VOol201mfOol008Moo`03001oogoo06Ioo`807gIoo`00OGoo0`001goo00<007oo
Ool0IWoo0P0OMWoo001lOol01@00Oomoogoo00001Woo00<007ooOol0IWoo0P0OMWoo0020Ool00`00
Oomoo`04Ool00`00Oomoo`1VOol201mfOol0081oo`03001oogoo00Aoo`<006Ioo`807gIoo`00OWoo
0P00j7oo0020Ool00`00Oomoo`3UOol007aoo`05001oogooOol0003WOol007eoo`<00>Qoo`00ogoo
JGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol008Qoo`<00004Ool00000003IOol00001
\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31083 m
.04057 .31094 L
.08481 .31107 L
.12636 .31122 L
.16632 .31138 L
.20885 .31157 L
.2498 .31179 L
.29331 .31207 L
.33524 .31241 L
.37557 .3128 L
.41848 .31333 L
.4598 .31401 L
.49953 .3149 L
.51991 .31549 L
.54183 .31628 L
.56402 .31729 L
.58512 .31857 L
.60591 .32027 L
.62522 .3225 L
.63631 .32423 L
.64677 .32633 L
.65615 .32878 L
.6614 .33047 L
.66631 .33234 L
.67629 .33737 L
.68157 .34102 L
.68724 .34616 L
.69009 .34941 L
.69318 .35366 L
.69591 .35823 L
.69881 .36424 L
.70141 .37103 L
.70429 .38078 L
.7069 .39275 L
.70936 .4083 L
.71059 .41853 L
.71191 .43207 L
.71316 .44833 L
.71429 .46734 L
.71562 .49763 L
.71637 .52043 L
.71706 .54697 L
s
.71706 .54697 m
.71833 .61803 L
s
.72338 .61803 m
.7235 0 L
s
.72685 0 m
.72699 .01163 L
.72778 .05656 L
.72853 .08838 L
.72923 .11176 L
.73055 .14437 L
.73168 .16481 L
.73292 .18208 L
.73413 .19535 L
.73542 .20679 L
.73773 .2224 L
.73989 .2332 L
.7426 .24347 L
.74517 .25092 L
.74998 .26112 L
.75248 .26512 L
.75481 .2683 L
.76014 .27408 L
.76534 .27832 L
.77093 .28187 L
.78103 .28656 L
.79028 .28963 L
.8006 .29219 L
.81019 .29404 L
.82139 .29573 L
.83194 .29702 L
.85346 .29899 L
.87299 .30029 L
.89405 .30136 L
.91344 .30214 L
.93486 .30283 L
.95487 .30337 L
.9947 .30419 L
1 .30429 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<0071oo`807faoo`00OWoo0P001goo00<007ooOol0L7oo0P0O
K7oo0020Ool00`00Oomoo`04Ool00`00Oomoo`1`Ool201m/Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`1`Ool201m/Ool007eoo`<000Moo`03001oogoo071oo`807faoo`00Qgoo00<007ooOol0
L7oo0P0OK7oo0027Ool00`00Oomoo`1`Ool201m/Ool008Moo`80075oo`807faoo`00Qgoo00<007oo
Ool0L7oo0P0OK7oo0027Ool00`00Oomoo`1`Ool201m/Ool008Moo`03001oogoo071oo`807faoo`00
Qgoo00<007ooOol0L7oo0P0OK7oo0027Ool00`00Oomoo`1`Ool00`0OOol07`1[Ool008Moo`80075o
o`0301moo`0O06]oo`00Qgoo00<007ooOol0L7oo00<07goo01l0Jgoo0027Ool00`00Oomoo`1`Ool0
0`0OOol07`1[Ool008Moo`03001oogoo071oo`0301moo`0O06]oo`00Qgoo00<007ooOol0L7oo00<0
7goo01l0Jgoo0027Ool00`00Oomoo`1`Ool00`0OOol07`1[Ool008Moo`03001oogoo071oo`0301mo
o`0O06]oo`00Qgoo0P00LGoo00<07goo01l0Jgoo0027Ool00`00Oomoo`1`Ool00`0OOol07`1[Ool0
08Moo`03001oogoo071oo`0301moo`0O06]oo`00Qgoo00<007ooOol0L7oo00<07goo01l0Jgoo0027
Ool00`00Oomoo`1`Ool00`0OOol07`1[Ool008Moo`03001oogoo071oo`0301moo`0O06]oo`00Qgoo
00<007ooOol0L7oo00<07goo01l0Jgoo0027Ool2001aOol00`0OOol07`1[Ool008Moo`03001oogoo
071oo`0301moo`0O06]oo`00Qgoo00<007ooOol0L7oo00<07goo01l0Jgoo0027Ool00`00Oomoo`1`
Ool00`0OOol07`1[Ool007aoo`D000Ioo`03001oogoo071oo`0301moo`0O06]oo`00O7oo00D007oo
Oomoo`0000Ioo`03001oogoo071oo`0301moo`0O06]oo`00OGoo00<007ooOol01goo00<007ooOol0
L7oo00<07goo01l0Jgoo001dOol60004Ool00`00Oomoo`06Ool3001`Ool00`0OOol07`1[Ool007mo
o`03001oogoo00Eoo`03001oogoo071oo`0301moo`0O06]oo`00P7oo00<007ooOol017oo00<007oo
Ool0L7oo00<07goo01l0Jgoo001lOol01@00Oomoogoo00001Woo00<007ooOol0L7oo00<07goo01l0
Jgoo001mOol30007Ool00`00Oomoo`1`Ool00`0OOol07`1[Ool008Moo`03001oogoo071oo`0301mo
o`0O06]oo`00Qgoo00<007ooOol0L7oo00<07goo01l0Jgoo0027Ool2001aOol00`0OOol07`1[Ool0
08Moo`03001oogoo071oo`0301moo`0O06]oo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00
Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00
Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00
Qgoo0P00LGoo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<0
07ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<0
07ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo0P00
LGoo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0
L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0
L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@07gooOol07fYoo`00Qgoo00<007ooOol0
L7oo00@07gooOol07fYoo`00Qgoo0P00LGoo00@07gooOol07fYoo`00Qgoo00<007ooOol0L7oo00@0
7gooOol07fYoo`00Qgoo00<007ooOol0L7oo00D07gooOomoo`0O06Uoo`00Qgoo00<007ooOol0L7oo
00D07gooOomoo`0O06Uoo`00OGoo1@001Goo00<007ooOol0L7oo00D07gooOomoo`0O06Uoo`00Ogoo
00<007ooOol01Goo00<007ooOol0L7oo00D07gooOomoo`0O06Uoo`00Ogoo00<007ooOol01Goo00<0
07ooOol0L7oo00D07gooOomoo`0O06Uoo`00M7oo1P001Goo00<007ooOol01Goo0`00L7oo00D07goo
Oomoo`0O06Uoo`00Ogoo00<007ooOol01Goo00<007ooOol0L7oo00D07gooOomoo`0O06Uoo`00Ogoo
00<007ooOol01Goo00<007ooOol0L7oo00D07gooOomoo`0O06Uoo`00OGoo0`001goo00<007ooOol0
L7oo00<07gooOol00Woo00<07gooOol0IWoo001oOol00`00Oomoo`05Ool00`00Oomoo`1`Ool00`0O
Oomoo`02Ool00`0OOomoo`1VOol008Moo`03001oogoo071oo`0301moogoo009oo`0301moogoo06Io
o`00Qgoo00<007ooOol0L7oo00<07gooOol00Woo00<07gooOol0IWoo0027Ool2001aOol00`0OOomo
o`02Ool00`0OOomoo`1VOol008Moo`03001oogoo071oo`0301moogoo00=oo`0301moogoo06Eoo`00
Qgoo00<007ooOol0L7oo00<07gooOol00goo00<07gooOol0IGoo0027Ool00`00Oomoo`1`Ool00`0O
Oomoo`03Ool00`0OOomoo`1UOol008Moo`03001oogoo071oo`0301moogoo00Aoo`0301moogoo06Ao
o`00Qgoo00<007ooOol0L7oo00<07gooOol017oo00<07gooOol0I7oo0027Ool00`00Oomoo`1`Ool0
0`0OOomoo`04Ool00`0OOomoo`1TOol008Moo`80075oo`0301moogoo00Aoo`0301moogoo06Aoo`00
Qgoo00<007ooOol0L7oo00<07gooOol017oo00<07gooOol0I7oo0027Ool00`00Oomoo`1`Ool00`0O
Oomoo`05Ool00`0OOomoo`1SOol008Moo`03001oogoo071oo`0301moogoo00Eoo`0301moogoo06=o
o`00Qgoo00<007ooOol0L7oo00<07gooOol01Woo00<07gooOol0HWoo000<Ool3000VOol5000UOol5
000SOol00`00Oomoo`0TOol5000TOol5000NOol00`0OOomoo`04Ool300000`0OOomoo`0UOol3000U
Ool4000@Ool000]oo`05001oogooOol0000UOol01@00Oomoogoo00009goo00<007ooOol08goo00<0
07ooOol09Woo00<007ooOol097oo00D007ooOomoo`0001ioo`0301moogoo00=oo`05001oogooOol0
7`0XOol00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000moo`03001oogoo02Aoo`03
001oogoo02Qoo`03001oogoo02=oo`8002Moo`03001oogoo02Eoo`03001oogoo01moo`0301moogoo
00Moo`0300007goo02Ioo`03001oogoo02Qoo`03001oogoo00eoo`000goo1P001Woo00<007ooOol0
6goo1P0017oo00<007ooOol077oo1P001Goo00<007ooOol08goo00<007ooOol09Woo00<007ooOol0
9Woo00<007ooOol07Woo00<07gooOol01goo00<007oo01l08Woo1P00:Goo00<007ooOol03Goo000=
Ool2000YOol00`00Oomoo`0VOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00
Oomoo`0MOol00`0OOomoo`05Ool20002Ool00`0OOomoo`0QOol01000Oomoo`009Woo100047oo000?
Ool00`00Oomoo`0WOol00`00Oomoo`0UOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0X
Ool00`00Oomoo`0LOol00`0OOomoo`07Ool00`00Oomoo`0201lQOol01000Oomoo`009Woo00<007oo
Ool04Goo000;Ool01@00Oomoogoo00009Goo00D007ooOomoo`0002Eoo`<002Eoo`03001oogoo02Ao
o`<002Ioo`05001oogooOol0000NOol00`0OOomoo`03Ool01@00Oomoogoo000017oo0P0O87oo00<0
07oo00009Woo00<007ooOol04Goo000<Ool3000WOol3000XOol00`00Oomoo`0SOol00`00Oomoo`0V
Ool00`00Oomoo`0UOol3000OOol00`0OOomoo`04Ool30007Ool201lOOol2000VOol5000?Ool008Mo
o`80075oo`0301moogoo011oo`807eUoo`00Qgoo00<007ooOol0L7oo00<07gooOol04Woo0`0OEWoo
0027Ool00`00Oomoo`1`Ool00`0OOomoo`0EOol701m?Ool008Moo`03001oogoo071oo`0301moogoo
01aoo`T07dIoo`00Qgoo00<007ooOol0L7oo00<07gooOol09Goo3P0O>7oo0027Ool00`00Oomoo`1`
Ool00`0OOomoo`0cOolN01lJOol008Moo`03001oogoo071oo`0301moogoo055oo`T07a5oo`002Woo
l00000<07`000000FP004Goo000:Oon401l00goo001oo`06Ool00`00Oomoo`06Ool00`00Oomoo`05
Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`0O001oo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06
Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool5000000Yoo`03001oogoo02Moo`03001oogoo02Ioo`03
001oogoo02Moo`03001oogoo00Aoobd07amoo`03001oogoo01eoo`0301moogoo00Ioo`03001oogoo
02Ioo`03001oogoo02Moo`03001oogoo00Yoo`04001oogooOol1000008Moo`03001oogoo035ooaD0
7bYoo`0301moogoo06Moo`03001oogoo005oo`00Qgoo00<007ooOol0AWoo1`0O8goo00<07gooOol0
J7oo0@000Goo0Goo0027Ool00`00Oomoo`1=Ool801lKOol00`0OOomoo`1VOol01000Oomoo`000Goo
0027Ool00`00Oomoo`1EOol401lGOol00`0OOomoo`1VOol5000008Moo`8005Yoo`@07a=oo`0301mo
ogoo06]oo`00Qgoo00<007ooOol0GGoo00<07gooOol047oo00<07gooOol0Jgoo0027Ool00`00Oomo
o`1NOol201l@Ool00`0OOomoo`1[Ool008Moo`03001oogoo061oo`807`ioo`0301moogoo06]oo`00
Qgoo00<007ooOol0HWoo00<07gooOol02goo00<07gooOol0Jgoo0027Ool00`00Oomoo`1SOol00`0O
Oomoo`0:Ool00`0OOomoo`1[Ool008Moo`03001oogoo06Aoo`0301moogoo00Uoo`0301moogoo06]o
o`00Qgoo0P00IWoo00<07gooOol027oo00<07gooOol0Jgoo0027Ool00`00Oomoo`1VOol00`0OOomo
o`07Ool00`0OOomoo`1[Ool008Moo`03001oogoo06Moo`0301moogoo00Ioo`0301moogoo06]oo`00
Qgoo00<007ooOol0Igoo00<07gooOol01Woo00<07gooOol0Jgoo0027Ool00`00Oomoo`1XOol00`0O
Oomoo`05Ool00`0OOomoo`1[Ool008Moo`03001oogoo06Qoo`0301moogoo00Eoo`0301moogoo06]o
o`00Qgoo00<007ooOol0JGoo00<07gooOol017oo00<07gooOol0Jgoo0027Ool2001ZOol00`0OOomo
o`04Ool00`0OOomoo`1[Ool008Moo`03001oogoo06Uoo`0301moogoo00Aoo`0301moogoo06]oo`00
Qgoo00<007ooOol0JWoo00<07gooOol00goo00<07gooOol0Jgoo0027Ool00`00Oomoo`1ZOol00`0O
Oomoo`03Ool00`0OOomoo`1[Ool008Moo`03001oogoo06Yoo`0301moogoo00=oo`0301moogoo06]o
o`00Qgoo00<007ooOol0Jgoo00<07gooOol00Woo00<07gooOol0Jgoo0027Ool00`00Oomoo`1[Ool0
0`0OOomoo`02Ool00`0OOomoo`1[Ool008Moo`8006aoo`0301moogoo009oo`0301moogoo06]oo`00
Qgoo00<007ooOol0Jgoo00<07gooOol00Woo00<07gooOol0Jgoo0027Ool00`00Oomoo`1[Ool00`0O
Oomoo`02Ool00`0OOomoo`1[Ool007eoo`D000Eoo`03001oogoo06aoo`0501moogooOol07`1]Ool0
07moo`03001oogoo00Eoo`03001oogoo06aoo`0501moogooOol07`1]Ool007moo`03001oogoo00Eo
o`03001oogoo06aoo`0501moogooOol07`1]Ool007moo`03001oogoo00Eoo`<006aoo`0501moogoo
Ool07`1]Ool007moo`03001oogoo00Eoo`03001oogoo06aoo`0501moogooOol07`1]Ool007moo`03
001oogoo00Eoo`03001oogoo06aoo`0501moogooOol07`1]Ool007eoo`<000Moo`03001oogoo06ao
o`0501moogooOol07`1]Ool007moo`03001oogoo00Eoo`03001oogoo06aoo`0501moogooOol07`1]
Ool008Moo`03001oogoo06aoo`0501moogooOol07`1]Ool008Moo`03001oogoo06aoo`0501moogoo
Ool07`1]Ool008Moo`8006eoo`0501moogooOol07`1]Ool008Moo`03001oogoo06aoo`0501moogoo
Ool07`1]Ool008Moo`03001oogoo06aoo`0501moogooOol07`1]Ool008Moo`03001oogoo06eoo`04
01moogoo01m]Ool008Moo`03001oogoo06eoo`0401moogoo01m]Ool008Moo`03001oogoo06eoo`04
01moogoo01m]Ool008Moo`03001oogoo06eoo`0401moogoo01m]Ool008Moo`8006ioo`0401moogoo
01m]Ool008Moo`03001oogoo06eoo`0401moogoo01m]Ool008Moo`03001oogoo06eoo`0401moogoo
01m]Ool008Moo`03001oogoo06eoo`0401moogoo01m]Ool008Moo`03001oogoo06eoo`0401moogoo
01m]Ool008Moo`03001oogoo06eoo`0401moogoo01m]Ool008Moo`03001oogoo06eoo`0401moogoo
01m]Ool008Moo`8006ioo`0401moogoo01m]Ool008Moo`03001oogoo06eoo`0401moogoo01m]Ool0
08Moo`03001oogoo06eoo`0401moogoo01m]Ool008Moo`03001oogoo06ioo`0301moo`0O06eoo`00
Qgoo00<007ooOol0KWoo00<07goo01l0KGoo0027Ool00`00Oomoo`1^Ool00`0OOol07`1]Ool008Mo
o`03001oogoo06ioo`0301moo`0O06eoo`00Qgoo0P00Kgoo00<07goo01l0KGoo0027Ool00`00Oomo
o`1^Ool00`0OOol07`1]Ool008Moo`03001oogoo06ioo`0301moo`0O06eoo`00Qgoo00<007ooOol0
KWoo00<07goo01l0KGoo001lOol50006Ool00`00Oomoo`1^Ool00`0OOol07`1]Ool007aoo`05001o
ogooOol00006Ool00`00Oomoo`1^Ool00`0OOol07`1]Ool007eoo`03001oogoo00Moo`03001oogoo
06ioo`0301moo`0O06eoo`00OWoo00<007ooOol01Woo0`00KWoo00<07goo01l0KGoo001oOol00`00
Oomoo`05Ool00`00Oomoo`1^Ool00`0OOol07`1]Ool0081oo`03001oogoo00Aoo`03001oogoo06io
o`0301moo`0O06eoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo06ioo`0301moo`0O06eoo`00
OGoo0`001goo00<007ooOol0KWoo00<07goo01l0KGoo0027Ool00`00Oomoo`1^Ool00`0OOol07`1]
Ool008Moo`8006moo`0301moo`0O06eoo`00Qgoo00<007ooOol0KWoo00<07goo01l0KGoo0027Ool0
0`00Oomoo`1^Ool00`0OOol07`1]Ool008Moo`03001oogoo06ioo`0301moo`0O06eoo`00Qgoo00<0
07ooOol0KWoo00<07goo01l0KGoo0027Ool00`00Oomoo`1^Ool00`0OOol07`1]Ool008Moo`03001o
ogoo06ioo`0301moo`0O06eoo`00Qgoo0P00Kgoo00<07goo01l0KGoo0027Ool00`00Oomoo`1^Ool0
0`0OOol07`1]Ool008Moo`03001oogoo06ioo`0301moo`0O06eoo`00Qgoo00<007ooOol0KWoo00<0
7goo01l0KGoo0027Ool00`00Oomoo`1^Ool00`0OOol07`1]Ool008Moo`03001oogoo06ioo`0301mo
o`0O06eoo`00Qgoo00<007ooOol0KWoo00<07goo01l0KGoo0027Ool2001_Ool00`0OOol07`1]Ool0
08Moo`03001oogoo06ioo`0301moo`0O06eoo`00Qgoo00<007ooOol0Kgoo0P0OKGoo0027Ool00`00
Oomoo`1_Ool201m]Ool008Moo`03001oogoo06moo`807feoo`00Qgoo00<007ooOol0Kgoo0P0OKGoo
0027Ool00`00Oomoo`1_Ool201m]Ool008Moo`80071oo`807feoo`00Qgoo00<007ooOol0Kgoo0P0O
KGoo0027Ool00`00Oomoo`1_Ool201m]Ool008Moo`03001oogoo06moo`807feoo`00OGoo0`001goo
00<007ooOol0Kgoo0P0OKGoo001lOol01@00Oomoogoo00001Woo00<007ooOol0Kgoo0P0OKGoo0020
Ool00`00Oomoo`04Ool00`00Oomoo`1_Ool201m]Ool0081oo`03001oogoo00Aoo`<006moo`807feo
o`00OWoo0P00j7oo0020Ool00`00Oomoo`3UOol007aoo`05001oogooOol0003WOol007eoo`<00>Qo
o`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol008Qoo`<00004Ool00000003I
Ool00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31077 m
.04057 .31087 L
.08481 .311 L
.12636 .31113 L
.16632 .31128 L
.20885 .31145 L
.2498 .31165 L
.29331 .31191 L
.33524 .3122 L
.37557 .31255 L
.41848 .31301 L
.4598 .31358 L
.49953 .31431 L
.52162 .31483 L
.54183 .3154 L
.58254 .31697 L
.60248 .31806 L
.62424 .31966 L
.64489 .3218 L
.65644 .32342 L
.66691 .32529 L
.67744 .32773 L
.68712 .33073 L
.69775 .33536 L
.70311 .33853 L
.70898 .34302 L
.71449 .34868 L
.71719 .35221 L
.7197 .35609 L
.72438 .36559 L
.72685 .37232 L
.72947 .38149 L
.73206 .39359 L
.73352 .40235 L
.73485 .41215 L
.73731 .43689 L
.73855 .45442 L
.73991 .48009 L
.74068 .49939 L
.74142 .52208 L
.74279 .58323 L
s
.74279 .58323 m
.7433 .61803 L
s
.74811 .61803 m
.74826 0 L
s
.75191 0 m
.75274 .05473 L
.75348 .08656 L
.75416 .10951 L
.75541 .14135 L
.75673 .16551 L
.75791 .18196 L
.75901 .19423 L
.76152 .21488 L
.76292 .22344 L
.76424 .23023 L
.76671 .24041 L
.76937 .24879 L
.77227 .25585 L
.77714 .26461 L
.78231 .27122 L
.78672 .27549 L
.79159 .27919 L
.79677 .28233 L
.80221 .28499 L
.81194 .28862 L
.82241 .29148 L
.83385 .2938 L
.84467 .2955 L
.85449 .29674 L
.8765 .29884 L
.89668 .30021 L
.91853 .30134 L
.93944 .30218 L
.96155 .30288 L
1 .30382 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<007Qoo`0301moo`0O06=oo`00OWoo0P001goo00<007ooOol0
N7oo00<07goo01l0Hgoo0020Ool00`00Oomoo`04Ool00`00Oomoo`1hOol00`0OOol07`1SOol007ao
o`05001oogooOol00006Ool00`00Oomoo`1hOol00`0OOol07`1SOol007eoo`<000Moo`03001oogoo
07Qoo`0301moo`0O06=oo`00Qgoo00<007ooOol0N7oo00<07goo01l0Hgoo0027Ool00`00Oomoo`1h
Ool00`0OOol07`1SOol008Moo`8007Uoo`0301moo`0O06=oo`00Qgoo00<007ooOol0N7oo00<07goo
01l0Hgoo0027Ool00`00Oomoo`1hOol00`0OOol07`1SOol008Moo`03001oogoo07Qoo`0301moo`0O
06=oo`00Qgoo00<007ooOol0N7oo00<07goo01l0Hgoo0027Ool00`00Oomoo`1hOol00`0OOol07`1S
Ool008Moo`8007Uoo`0301moo`0O06=oo`00Qgoo00<007ooOol0N7oo00<07goo01l0Hgoo0027Ool0
0`00Oomoo`1hOol00`0OOol07`1SOol008Moo`03001oogoo07Qoo`0301moo`0O06=oo`00Qgoo00<0
07ooOol0N7oo00<07goo01l0Hgoo0027Ool00`00Oomoo`1hOol00`0OOol07`1SOol008Moo`03001o
ogoo07Qoo`0301moo`0O06=oo`00Qgoo0P00NGoo00<07goo01l0Hgoo0027Ool00`00Oomoo`1hOol0
0`0OOol07`1SOol008Moo`03001oogoo07Qoo`0301moo`0O06=oo`00Qgoo00<007ooOol0N7oo00<0
7goo01l0Hgoo0027Ool00`00Oomoo`1hOol00`0OOol07`1SOol008Moo`03001oogoo07Qoo`0301mo
o`0O06=oo`00Qgoo00<007ooOol0N7oo00<07goo01l0Hgoo0027Ool2001iOol00`0OOol07`1SOol0
08Moo`03001oogoo07Qoo`0301moo`0O06=oo`00Qgoo00<007ooOol0N7oo00<07goo01l0Hgoo0027
Ool00`00Oomoo`1hOol00`0OOol07`1SOol007aoo`D000Ioo`03001oogoo07Qoo`0301moo`0O06=o
o`00O7oo00D007ooOomoo`0000Ioo`03001oogoo07Qoo`0301moo`0O06=oo`00OGoo00<007ooOol0
1goo00<007ooOol0N7oo00<07goo01l0Hgoo001dOol60004Ool00`00Oomoo`06Ool3001hOol00`0O
Ool07`1SOol007moo`03001oogoo00Eoo`03001oogoo07Qoo`0301moo`0O06=oo`00P7oo00<007oo
Ool017oo00<007ooOol0N7oo00<07goo01l0Hgoo001lOol01@00Oomoogoo00001Woo00<007ooOol0
N7oo00<07goo01l0Hgoo001mOol30007Ool00`00Oomoo`1hOol00`0OOol07`1SOol008Moo`03001o
ogoo07Qoo`0301moo`0O06=oo`00Qgoo00<007ooOol0N7oo00<07goo01l0Hgoo0027Ool2001iOol0
0`0OOol07`1SOol008Moo`03001oogoo07Qoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`04
01moogoo01mROol008Moo`03001oogoo07Qoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`04
01moogoo01mROol008Moo`03001oogoo07Qoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`04
01moogoo01mROol008Moo`8007Uoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`0401moogoo
01mROol008Moo`03001oogoo07Qoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`0401moogoo
01mROol008Moo`03001oogoo07Qoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`0401moogoo
01mROol008Moo`8007Uoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`0401moogoo01mROol0
08Moo`03001oogoo07Qoo`0401moogoo01mROol008Moo`03001oogoo07Qoo`0401moogoo01mROol0
08Moo`03001oogoo07Qoo`0501moogooOol07`1QOol008Moo`03001oogoo07Qoo`0501moogooOol0
7`1QOol008Moo`03001oogoo07Qoo`0501moogooOol07`1QOol008Moo`8007Uoo`0501moogooOol0
7`1QOol008Moo`03001oogoo07Qoo`0501moogooOol07`1QOol008Moo`03001oogoo07Qoo`0501mo
ogooOol07`1QOol008Moo`03001oogoo07Qoo`0501moogooOol07`1QOol007eoo`D000Eoo`03001o
ogoo07Qoo`0501moogooOol07`1QOol007moo`03001oogoo00Eoo`03001oogoo07Qoo`0501moogoo
Ool07`1QOol007moo`03001oogoo00Eoo`03001oogoo07Qoo`0501moogooOol07`1QOol007Aoo`H0
00Eoo`03001oogoo00Eoo`<007Qoo`0301moogoo009oo`0301moogoo05ioo`00Ogoo00<007ooOol0
1Goo00<007ooOol0N7oo00<07gooOol00Woo00<07gooOol0GWoo001oOol00`00Oomoo`05Ool00`00
Oomoo`1hOol00`0OOomoo`02Ool00`0OOomoo`1NOol007eoo`<000Moo`03001oogoo07Qoo`0301mo
ogoo009oo`0301moogoo05ioo`00Ogoo00<007ooOol01Goo00<007ooOol0N7oo00<07gooOol00Woo
00<07gooOol0GWoo0027Ool00`00Oomoo`1hOol00`0OOomoo`02Ool00`0OOomoo`1NOol008Moo`03
001oogoo07Qoo`0301moogoo009oo`0301moogoo05ioo`00Qgoo0P00NGoo00<07gooOol00goo00<0
7gooOol0GGoo0027Ool00`00Oomoo`1hOol00`0OOomoo`03Ool00`0OOomoo`1MOol008Moo`03001o
ogoo07Qoo`0301moogoo00=oo`0301moogoo05eoo`00Qgoo00<007ooOol0N7oo00<07gooOol017oo
00<07gooOol0G7oo0027Ool00`00Oomoo`1hOol00`0OOomoo`04Ool00`0OOomoo`1LOol008Moo`03
001oogoo07Qoo`0301moogoo00Aoo`0301moogoo05aoo`00Qgoo00<007ooOol0N7oo00<07gooOol0
17oo00<07gooOol0G7oo0027Ool2001iOol00`0OOomoo`04Ool00`0OOomoo`1LOol008Moo`03001o
ogoo07Qoo`0301moogoo00Aoo`0301moogoo05aoo`00Qgoo00<007ooOol0N7oo00<07gooOol01Goo
00<07gooOol0Fgoo0027Ool00`00Oomoo`1hOol00`0OOomoo`05Ool00`0OOomoo`1KOol008Moo`03
001oogoo07Qoo`0301moogoo00Ioo`0301moogoo05Yoo`0037oo0`009Woo1@009Goo1@008goo00<0
07ooOol097oo1@0097oo1@009Goo00<0000O00001goo00<07gooOol07Woo0`009Goo100047oo000;
Ool01@00Oomoogoo00009Goo00D007ooOomoo`0002Moo`03001oogoo02=oo`03001oogoo02Ioo`03
001oogoo02Aoo`05001oogooOol0000TOol01@00Ool07goo00001goo00<07gooOol07Woo00<007oo
Ool08goo00<007ooOol00Woo00<007ooOol03Goo000?Ool00`00Oomoo`0TOol00`00Oomoo`0XOol0
0`00Oomoo`0SOol2000WOol00`00Oomoo`0UOol00`00Oomoo`0WOol00`0OOol00008Ool00`0OOomo
o`0MOol00`00Oomoo`0XOol00`00Oomoo`0=Ool000=oo`H000Ioo`03001oogoo01]oo`H000Aoo`03
001oogoo01aoo`H000Eoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Ioo`03001oogoo
02Ioo`0301moo`0000Uoo`0301moogoo01Qoo`H002Uoo`03001oogoo00eoo`003Goo0P00:Goo00<0
07ooOol09Woo00<007ooOol08goo00<007ooOol09Woo00<007ooOol09goo00<007ooOol09Goo00<0
7`00Ool02Woo00<07gooOol067oo00@007ooOol002Ioo`@0011oo`003goo00<007ooOol09goo00<0
07ooOol09Goo00<007ooOol08goo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol097oo00<0
7goo00002goo0P0O67oo00@007ooOol002Ioo`03001oogoo015oo`002goo00D007ooOomoo`0002Eo
o`05001oogooOol0000UOol3000UOol00`00Oomoo`0TOol3000VOol01@00Oomoogoo000097oo00D0
07oo01moo`0000eoo`807aMoo`03001oo`0002Ioo`03001oogoo015oo`0037oo0`009goo0`00:7oo
00<007ooOol08goo00<007ooOol09Woo00<007ooOol09Goo0`009Woo00<0000O000047oo0P0O5Woo
0P009Woo1@003goo0027Ool2001iOol00`0OOomoo`0AOol401m>Ool008Moo`03001oogoo07Qoo`03
01moogoo01Eoo`<07d]oo`00Qgoo00<007ooOol0N7oo00<07gooOol067oo100OAgoo0027Ool00`00
Oomoo`1hOol00`0OOomoo`0LOol901lnOol008Moo`03001oogoo07Qoo`0301moogoo02Eoo`h07c1o
o`00Qgoo00<007ooOol0N7oo00<07gooOol0<goo600O67oo0027Ool00`00Oomoo`1hOol00`0OOomo
o`1;Ool701lAOol000YoooP0000301l000000580015oo`002WooQ00O00=oo`00Ool01Woo00<007oo
Ool01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007oo
Ool01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007oo
Ool01Goo00<007ooOol01Woo00<007ooOol017oo00<07`00Ool01Woo00<007ooOol01Woo00<007oo
Ool01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007oo
Ool01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol02Woo1@00000:Ool00`00Oomoo`0W
Ool00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`04Oolg01lEOol00`00Oomoo`0UOol00`0O
001oo`0WOol00`00Oomoo`0WOol00`00Oomoo`0:Ool01000Oomoogoo0@000027Ool00`00Oomoo`0k
OolA01l/Ool00`0OOomoo`1OOol00`00Oomoo`01Ool008Moo`03001oogoo04aoo``07b1oo`0301mo
ogoo061oo`40005oo`5oo`00Qgoo00<007ooOol0F7oo100O77oo00<07gooOol0GWoo00@007ooOol0
005oo`00Qgoo00<007ooOol0G7oo1`0O5Goo00<07gooOol0GWoo1@000027Ool2001TOol201lCOol0
0`0OOomoo`1SOol008Moo`03001oogoo06Eoo`807a5oo`0301moogoo06=oo`00Qgoo00<007ooOol0
Igoo0P0O3goo00<07gooOol0Hgoo0027Ool00`00Oomoo`1YOol00`0OOomoo`0<Ool00`0OOomoo`1S
Ool008Moo`03001oogoo06Yoo`0301moogoo00]oo`0301moogoo06=oo`00Qgoo00<007ooOol0Jgoo
00<07gooOol02Woo00<07gooOol0Hgoo0027Ool00`00Oomoo`1/Ool201l:Ool00`0OOomoo`1SOol0
08Moo`8006moo`0301moogoo00Moo`0301moogoo06=oo`00Qgoo00<007ooOol0KWoo00<07gooOol0
1goo00<07gooOol0Hgoo0027Ool00`00Oomoo`1_Ool00`0OOomoo`06Ool00`0OOomoo`1SOol008Mo
o`03001oogoo071oo`0301moogoo00Eoo`0301moogoo06=oo`00Qgoo00<007ooOol0L7oo00<07goo
Ool01Goo00<07gooOol0Hgoo0027Ool00`00Oomoo`1aOol00`0OOomoo`04Ool00`0OOomoo`1SOol0
08Moo`03001oogoo075oo`0301moogoo00Aoo`0301moogoo06=oo`00Qgoo0P00LWoo00<07gooOol0
17oo00<07gooOol0Hgoo0027Ool00`00Oomoo`1aOol00`0OOomoo`04Ool00`0OOomoo`1SOol008Mo
o`03001oogoo079oo`0301moogoo00=oo`0301moogoo06=oo`00Qgoo00<007ooOol0LWoo00<07goo
Ool00goo00<07gooOol0Hgoo0027Ool00`00Oomoo`1bOol00`0OOomoo`03Ool00`0OOomoo`1SOol0
08Moo`03001oogoo07=oo`0301moogoo009oo`0301moogoo06=oo`00Qgoo00<007ooOol0Lgoo00<0
7gooOol00Woo00<07gooOol0Hgoo0027Ool2001dOol00`0OOomoo`02Ool00`0OOomoo`1SOol008Mo
o`03001oogoo07=oo`0301moogoo009oo`0301moogoo06=oo`00Qgoo00<007ooOol0M7oo00D07goo
Oomoo`0O06Eoo`00OGoo1@001Goo00<007ooOol0M7oo00D07gooOomoo`0O06Eoo`00Ogoo00<007oo
Ool01Goo00<007ooOol0M7oo00D07gooOomoo`0O06Eoo`00Ogoo00<007ooOol01Goo00<007ooOol0
M7oo00D07gooOomoo`0O06Eoo`00Ogoo00<007ooOol01Goo0`00M7oo00D07gooOomoo`0O06Eoo`00
Ogoo00<007ooOol01Goo00<007ooOol0M7oo00D07gooOomoo`0O06Eoo`00Ogoo00<007ooOol01Goo
00<007ooOol0M7oo00D07gooOomoo`0O06Eoo`00OGoo0`001goo00<007ooOol0M7oo00D07gooOomo
o`0O06Eoo`00Ogoo00<007ooOol01Goo00<007ooOol0M7oo00D07gooOomoo`0O06Eoo`00Qgoo00<0
07ooOol0MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@07gooOol07fEoo`00Qgoo0P00
MWoo00@07gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0
MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0
MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0
MGoo00@07gooOol07fEoo`00Qgoo0P00MWoo00@07gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@0
7gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@0
7gooOol07fEoo`00Qgoo00<007ooOol0MGoo00@07gooOol07fEoo`00Qgoo00<007ooOol0MWoo00<0
7goo01l0IGoo0027Ool00`00Oomoo`1fOol00`0OOol07`1UOol008Moo`8007Moo`0301moo`0O06Eo
o`00Qgoo00<007ooOol0MWoo00<07goo01l0IGoo0027Ool00`00Oomoo`1fOol00`0OOol07`1UOol0
08Moo`03001oogoo07Ioo`0301moo`0O06Eoo`00Qgoo00<007ooOol0MWoo00<07goo01l0IGoo0027
Ool00`00Oomoo`1fOol00`0OOol07`1UOol008Moo`03001oogoo07Ioo`0301moo`0O06Eoo`00Qgoo
0P00Mgoo00<07goo01l0IGoo0027Ool00`00Oomoo`1fOol00`0OOol07`1UOol008Moo`03001oogoo
07Ioo`0301moo`0O06Eoo`00Qgoo00<007ooOol0MWoo00<07goo01l0IGoo001lOol50006Ool00`00
Oomoo`1fOol00`0OOol07`1UOol007aoo`05001oogooOol00006Ool00`00Oomoo`1fOol00`0OOol0
7`1UOol007eoo`03001oogoo00Moo`03001oogoo07Ioo`0301moo`0O06Eoo`00OWoo00<007ooOol0
1Woo0`00MWoo00<07goo01l0IGoo001oOol00`00Oomoo`05Ool00`00Oomoo`1fOol00`0OOol07`1U
Ool0081oo`03001oogoo00Aoo`03001oogoo07Ioo`0301moo`0O06Eoo`00O7oo00D007ooOomoo`00
00Ioo`03001oogoo07Ioo`0301moo`0O06Eoo`00OGoo0`001goo00<007ooOol0MWoo00<07goo01l0
IGoo0027Ool00`00Oomoo`1fOol00`0OOol07`1UOol008Moo`8007Moo`0301moo`0O06Eoo`00Qgoo
00<007ooOol0MWoo00<07goo01l0IGoo0027Ool00`00Oomoo`1fOol00`0OOol07`1UOol008Moo`03
001oogoo07Ioo`0301moo`0O06Eoo`00Qgoo00<007ooOol0MWoo00<07goo01l0IGoo0027Ool00`00
Oomoo`1fOol00`0OOol07`1UOol008Moo`03001oogoo07Moo`807fEoo`00Qgoo0P00N7oo0P0OIGoo
0027Ool00`00Oomoo`1gOol201mUOol008Moo`03001oogoo07Moo`807fEoo`00Qgoo00<007ooOol0
Mgoo0P0OIGoo0027Ool00`00Oomoo`1gOol201mUOol008Moo`03001oogoo07Moo`807fEoo`00Qgoo
00<007ooOol0Mgoo0P0OIGoo0027Ool2001hOol201mUOol008Moo`03001oogoo07Moo`807fEoo`00
Qgoo00<007ooOol0Mgoo0P0OIGoo0027Ool00`00Oomoo`1gOol201mUOol008Moo`03001oogoo07Mo
o`807fEoo`00Qgoo00<007ooOol0Mgoo0P0OIGoo0027Ool00`00Oomoo`1gOol201mUOol008Moo`80
07Qoo`807fEoo`00Qgoo00<007ooOol0Mgoo0P0OIGoo0027Ool00`00Oomoo`1gOol201mUOol008Mo
o`03001oogoo07Moo`807fEoo`00OGoo0`001goo00<007ooOol0Mgoo0P0OIGoo001lOol01@00Oomo
ogoo00001Woo00<007ooOol0Mgoo0P0OIGoo0020Ool00`00Oomoo`04Ool00`00Oomoo`1gOol201mU
Ool0081oo`03001oogoo00Aoo`<007Moo`807fEoo`00OWoo0P00j7oo0020Ool00`00Oomoo`3UOol0
07aoo`05001oogooOol0003WOol007eoo`<00>Qoo`00ogooJGoo003oOomYOol00?moofUoo`00ogoo
JGoo003oOomYOol008Qoo`<00004Ool00000003IOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31072 m
.04057 .31081 L
.08481 .31093 L
.12636 .31105 L
.16632 .31118 L
.20885 .31135 L
.2498 .31153 L
.29331 .31176 L
.33524 .31202 L
.37557 .31232 L
.41848 .31272 L
.4598 .31321 L
.49953 .31382 L
.52162 .31425 L
.54183 .31471 L
.58254 .31592 L
.60248 .31673 L
.62424 .31786 L
.64489 .3193 L
.66691 .32144 L
.67771 .32285 L
.6894 .3248 L
.70043 .32721 L
.71057 .33019 L
.71551 .33201 L
.7208 .33436 L
.72537 .33682 L
.73034 .34009 L
.73617 .34506 L
.73885 .34792 L
.74169 .35151 L
.74424 .35534 L
.74706 .36046 L
.75204 .37291 L
.7545 .38162 L
.7572 .39436 L
.75856 .40264 L
.76001 .41348 L
.76127 .42509 L
.76263 .441 L
.764 .46195 L
.76525 .48817 L
.76645 .52329 L
.76773 .57942 L
s
.76773 .57942 m
.76826 .61803 L
s
.7728 .61803 m
.77285 0 L
s
.77684 0 m
.77747 .04042 L
.77822 .07639 L
.7789 .10122 L
.77963 .12299 L
.78113 .15544 L
.78251 .17681 L
.78379 .19199 L
.78515 .20463 L
.78644 .21431 L
.78884 .22832 L
.79143 .23941 L
.79425 .24845 L
.79671 .25462 L
.79936 .26 L
.80415 .26744 L
.80984 .27379 L
.81505 .27812 L
.8202 .28145 L
.82581 .28436 L
.83713 .28868 L
.84794 .2916 L
.85776 .29361 L
.86909 .29542 L
.87977 .29677 L
.90083 .29878 L
.92021 .30013 L
.93996 .30118 L
.96164 .30207 L
1 .30325 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<0085oo`807e]oo`00OWoo0P001goo00<007ooOol0PGoo0P0O
Fgoo0020Ool00`00Oomoo`04Ool00`00Oomoo`21Ool201mKOol007aoo`05001oogooOol00006Ool0
0`00Oomoo`21Ool201mKOol007eoo`<000Moo`03001oogoo085oo`807e]oo`00Qgoo00<007ooOol0
PGoo0P0OFgoo0027Ool00`00Oomoo`21Ool201mKOol008Moo`80089oo`807e]oo`00Qgoo00<007oo
Ool0PGoo0P0OFgoo0027Ool00`00Oomoo`21Ool201mKOol008Moo`03001oogoo085oo`807e]oo`00
Qgoo00<007ooOol0PGoo0P0OFgoo0027Ool00`00Oomoo`21Ool201mKOol008Moo`80089oo`807e]o
o`00Qgoo00<007ooOol0PGoo0P0OFgoo0027Ool00`00Oomoo`21Ool201mKOol008Moo`03001oogoo
085oo`807e]oo`00Qgoo00<007ooOol0PGoo0P0OFgoo0027Ool00`00Oomoo`21Ool201mKOol008Mo
o`03001oogoo085oo`807e]oo`00Qgoo0P00PWoo0P0OFgoo0027Ool00`00Oomoo`21Ool201mKOol0
08Moo`03001oogoo085oo`807e]oo`00Qgoo00<007ooOol0PGoo0P0OFgoo0027Ool00`00Oomoo`21
Ool201mKOol008Moo`03001oogoo085oo`807e]oo`00Qgoo00<007ooOol0PGoo0P0OFgoo0027Ool2
0022Ool201mKOol008Moo`03001oogoo085oo`807e]oo`00Qgoo00<007ooOol0PGoo00<07goo01l0
FWoo0027Ool00`00Oomoo`21Ool00`0OOol07`1JOol007aoo`D000Ioo`03001oogoo085oo`0301mo
o`0O05Yoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo085oo`0301moo`0O05Yoo`00OGoo00<0
07ooOol01goo00<007ooOol0PGoo00<07goo01l0FWoo001dOol60004Ool00`00Oomoo`06Ool30021
Ool00`0OOol07`1JOol007moo`03001oogoo00Eoo`03001oogoo085oo`0301moo`0O05Yoo`00P7oo
00<007ooOol017oo00<007ooOol0PGoo00<07goo01l0FWoo001lOol01@00Oomoogoo00001Woo00<0
07ooOol0PGoo00<07goo01l0FWoo001mOol30007Ool00`00Oomoo`21Ool00`0OOol07`1JOol008Mo
o`03001oogoo085oo`0301moo`0O05Yoo`00Qgoo00<007ooOol0PGoo00<07goo01l0FWoo0027Ool2
0022Ool00`0OOol07`1JOol008Moo`03001oogoo085oo`0301moo`0O05Yoo`00Qgoo00<007ooOol0
PGoo00<07goo01l0FWoo0027Ool00`00Oomoo`21Ool00`0OOol07`1JOol008Moo`03001oogoo085o
o`0301moo`0O05Yoo`00Qgoo00<007ooOol0PGoo00<07goo01l0FWoo0027Ool00`00Oomoo`21Ool0
0`0OOol07`1JOol008Moo`80089oo`0301moo`0O05Yoo`00Qgoo00<007ooOol0PGoo00<07goo01l0
FWoo0027Ool00`00Oomoo`21Ool00`0OOol07`1JOol008Moo`03001oogoo085oo`0301moo`0O05Yo
o`00Qgoo00<007ooOol0PGoo00<07goo01l0FWoo0027Ool00`00Oomoo`21Ool00`0OOol07`1JOol0
08Moo`80089oo`0301moo`0O05Yoo`00Qgoo00<007ooOol0PGoo00@07gooOol07eUoo`00Qgoo00<0
07ooOol0PGoo00@07gooOol07eUoo`00Qgoo00<007ooOol0PGoo00@07gooOol07eUoo`00Qgoo00<0
07ooOol0PGoo00@07gooOol07eUoo`00Qgoo00<007ooOol0PGoo00@07gooOol07eUoo`00Qgoo00<0
07ooOol0PGoo00@07gooOol07eUoo`00Qgoo0P00PWoo00@07gooOol07eUoo`00Qgoo00<007ooOol0
PGoo00@07gooOol07eUoo`00Qgoo00<007ooOol0PGoo00@07gooOol07eUoo`00Qgoo00<007ooOol0
PGoo00@07gooOol07eUoo`00OGoo1@001Goo00<007ooOol0PGoo00@07gooOol07eUoo`00Ogoo00<0
07ooOol01Goo00<007ooOol0PGoo00D07gooOomoo`0O05Qoo`00Ogoo00<007ooOol01Goo00<007oo
Ool0PGoo00D07gooOomoo`0O05Qoo`00M7oo1P001Goo00<007ooOol01Goo0`00PGoo00D07gooOomo
o`0O05Qoo`00Ogoo00<007ooOol01Goo00<007ooOol0PGoo00D07gooOomoo`0O05Qoo`00Ogoo00<0
07ooOol01Goo00<007ooOol0PGoo00D07gooOomoo`0O05Qoo`00OGoo0`001goo00<007ooOol0PGoo
00D07gooOomoo`0O05Qoo`00Ogoo00<007ooOol01Goo00<007ooOol0PGoo00D07gooOomoo`0O05Qo
o`00Qgoo00<007ooOol0PGoo00<07gooOol00Woo00<07gooOol0EGoo0027Ool00`00Oomoo`21Ool0
0`0OOomoo`02Ool00`0OOomoo`1EOol008Moo`80089oo`0301moogoo009oo`0301moogoo05Eoo`00
Qgoo00<007ooOol0PGoo00<07gooOol00Woo00<07gooOol0EGoo0027Ool00`00Oomoo`21Ool00`0O
Oomoo`03Ool00`0OOomoo`1DOol008Moo`03001oogoo085oo`0301moogoo00=oo`0301moogoo05Ao
o`00Qgoo00<007ooOol0PGoo00<07gooOol00goo00<07gooOol0E7oo0027Ool00`00Oomoo`21Ool0
0`0OOomoo`03Ool00`0OOomoo`1DOol008Moo`03001oogoo085oo`0301moogoo00Aoo`0301moogoo
05=oo`00Qgoo0P00PWoo00<07gooOol017oo00<07gooOol0Dgoo0027Ool00`00Oomoo`21Ool00`0O
Oomoo`05Ool00`0OOomoo`1BOol008Moo`03001oogoo085oo`0301moogoo00Eoo`0301moogoo059o
o`00Qgoo00<007ooOol0PGoo00<07gooOol01Goo00<07gooOol0DWoo0027Ool00`00Oomoo`21Ool0
0`0OOomoo`05Ool00`0OOomoo`1BOol000aoo`<002Ioo`D002Eoo`D002=oo`03001oogoo02Aoo`D0
02Aoo`D002Eoo`<000Moo`0301moogoo00Ioo`0301moogoo01Eoo`<002Eoo`@0011oo`002goo00D0
07ooOomoo`0002Eoo`05001oogooOol0000WOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomo
o`0TOol01@00Oomoogoo000097oo00D007ooOomoo`0000Ioo`0301moogoo00Moo`0301moogoo01Eo
o`03001oogoo02=oo`03001oogoo009oo`03001oogoo00eoo`003goo00<007ooOol097oo00<007oo
Ool0:7oo00<007ooOol08goo0P009goo00<007ooOol09Goo00<007ooOol0:Goo00<007ooOol017oo
00<07gooOol027oo00<07gooOol057oo00<007ooOol0:7oo00<007ooOol03Goo0003Ool60006Ool0
0`00Oomoo`0KOol60004Ool00`00Oomoo`0LOol60005Ool00`00Oomoo`0SOol00`00Oomoo`0VOol0
0`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`04Ool00`0OOomoo`08Ool00`0OOomoo`0@Ool6
000YOol00`00Oomoo`0=Ool000eoo`8002Uoo`03001oogoo02Ioo`03001oogoo02=oo`03001oogoo
02Ioo`03001oogoo02Moo`03001oogoo02Eoo`8000Moo`0301moogoo00Uoo`0301moogoo011oo`04
001oogoo000VOol4000@Ool000moo`03001oogoo02Moo`03001oogoo02Eoo`03001oogoo02=oo`03
001oogoo02Ioo`03001oogoo02Qoo`03001oogoo02Ioo`03001oogoo00Aoo`0301moogoo00Yoo`80
7a1oo`04001oogoo000VOol00`00Oomoo`0AOol000]oo`05001oogooOol0000UOol01@00Oomoogoo
00009Goo0`009Goo00<007ooOol097oo0`009Woo00D007ooOomoo`0002Aoo`05001oogooOol00006
Ool00`0OOomoo`0<Ool00`0OOomoo`0>Ool00`00Ool0000VOol00`00Oomoo`0AOol000aoo`<002Mo
o`<002Qoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Eoo`<002Ioo`<000Moo`0301mo
ogoo00eoo`<07`ioo`8002Ioo`D000moo`00Qgoo0P00PWoo00<07gooOol047oo100OAWoo0027Ool0
0`00Oomoo`21Ool00`0OOomoo`0DOol301m3Ool008Moo`03001oogoo085oo`0301moogoo01Moo`@0
7cmoo`00Qgoo00<007ooOol0PGoo00<07gooOol06goo2@0O=Woo0027Ool00`00Oomoo`21Ool00`0O
Oomoo`0TOol=01lYOol008Moo`03001oogoo085oo`0301moogoo035ooaP07a5oo`00Qgoo00<007oo
Ool0PGoo00<07gooOol0FWoo000:Oooo000200000`0O00000019000AOol000Yooi807`Aoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`0301moogoo00Ioo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D000002Woo00<007ooOol09goo00<007ooOol0
9Woo00<007ooOol09goo00<007ooOol04Woo:@0O5Goo00<007ooOol09Woo00<007ooOol01Goo00<0
7gooOol07Woo00<007ooOol09goo00<007ooOol02Woo00@007ooOomoo`400000Qgoo00<007ooOol0
>goo600O;Woo00<07gooOol0EWoo00<007ooOol00Goo0027Ool00`00Oomoo`1COol<01lROol00`0O
Oomoo`1GOol10001Ool1Ool008Moo`03001oogoo05moo`P07aYoo`0301moogoo05Eoo`04001oogoo
0001Ool008Moo`03001oogoo06Moo`@07aIoo`0301moogoo05Eoo`D00000Qgoo0P00K7oo0P0O57oo
00<07gooOol0FWoo0027Ool00`00Oomoo`1]Ool201lBOol00`0OOomoo`1JOol008Moo`03001oogoo
06moo`<07`moo`0301moogoo05Yoo`00Qgoo00<007ooOol0LWoo00<07gooOol037oo00<07gooOol0
FWoo0027Ool00`00Oomoo`1bOol00`0OOomoo`0<Ool00`0OOomoo`1JOol008Moo`03001oogoo07=o
o`807`aoo`0301moogoo05Yoo`00Qgoo00<007ooOol0MGoo00<07gooOol02Goo00<07gooOol0FWoo
0027Ool2001gOol00`0OOomoo`08Ool00`0OOomoo`1JOol008Moo`03001oogoo07Moo`0301moogoo
00Moo`0301moogoo05Yoo`00Qgoo00<007ooOol0Mgoo00<07gooOol01goo00<07gooOol0FWoo0027
Ool00`00Oomoo`1hOol00`0OOomoo`06Ool00`0OOomoo`1JOol008Moo`03001oogoo07Uoo`0301mo
ogoo00Eoo`0301moogoo05Yoo`00Qgoo00<007ooOol0NGoo00<07gooOol01Goo00<07gooOol0FWoo
0027Ool00`00Oomoo`1jOol00`0OOomoo`04Ool00`0OOomoo`1JOol008Moo`8007]oo`0301moogoo
00Aoo`0301moogoo05Yoo`00Qgoo00<007ooOol0NWoo00<07gooOol017oo00<07gooOol0FWoo0027
Ool00`00Oomoo`1kOol00`0OOomoo`03Ool00`0OOomoo`1JOol008Moo`03001oogoo07]oo`0301mo
ogoo00=oo`0301moogoo05Yoo`00Qgoo00<007ooOol0Ngoo00<07gooOol00goo00<07gooOol0FWoo
0027Ool00`00Oomoo`1kOol00`0OOomoo`03Ool00`0OOomoo`1JOol008Moo`03001oogoo07]oo`03
01moogoo00=oo`0301moogoo05Yoo`00Qgoo0P00O7oo00<07gooOol00goo00<07gooOol0FWoo0027
Ool00`00Oomoo`1kOol00`0OOomoo`03Ool00`0OOomoo`1JOol008Moo`03001oogoo07aoo`0301mo
ogoo009oo`0301moogoo05Yoo`00OGoo1@001Goo00<007ooOol0O7oo00<07gooOol00Woo00<07goo
Ool0FWoo001oOol00`00Oomoo`05Ool00`00Oomoo`1lOol00`0OOomoo`02Ool00`0OOomoo`1JOol0
07moo`03001oogoo00Eoo`03001oogoo07aoo`0301moogoo009oo`0301moogoo05Yoo`00Ogoo00<0
07ooOol01Goo0`00O7oo00<07gooOol00Woo00<07gooOol0FWoo001oOol00`00Oomoo`05Ool00`00
Oomoo`1lOol00`0OOomoo`02Ool00`0OOomoo`1JOol007moo`03001oogoo00Eoo`03001oogoo07ao
o`0301moogoo009oo`0301moogoo05Yoo`00OGoo0`001goo00<007ooOol0OGoo00D07gooOomoo`0O
05aoo`00Ogoo00<007ooOol01Goo00<007ooOol0OGoo00D07gooOomoo`0O05aoo`00Qgoo00<007oo
Ool0OGoo00D07gooOomoo`0O05aoo`00Qgoo00<007ooOol0OGoo00D07gooOomoo`0O05aoo`00Qgoo
0P00OWoo00D07gooOomoo`0O05aoo`00Qgoo00<007ooOol0OGoo00D07gooOomoo`0O05aoo`00Qgoo
00<007ooOol0OGoo00D07gooOomoo`0O05aoo`00Qgoo00<007ooOol0OGoo00D07gooOomoo`0O05ao
o`00Qgoo00<007ooOol0OGoo00D07gooOomoo`0O05aoo`00Qgoo00<007ooOol0OGoo00D07gooOomo
o`0O05aoo`00Qgoo00<007ooOol0OGoo00D07gooOomoo`0O05aoo`00Qgoo0P00Ogoo00@07gooOol0
7eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol0
7eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol0
7eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol0
7eaoo`00Qgoo0P00Ogoo00@07gooOol07eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00
Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00
Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00
Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00Qgoo0P00Ogoo00@07gooOol07eaoo`00Qgoo00<0
07ooOol0OWoo00@07gooOol07eaoo`00Qgoo00<007ooOol0OWoo00@07gooOol07eaoo`00Qgoo00<0
07ooOol0OWoo00@07gooOol07eaoo`00O7oo1@001Woo00<007ooOol0OWoo00@07gooOol07eaoo`00
O7oo00D007ooOomoo`0000Ioo`03001oogoo07ioo`0401moogoo01mLOol007eoo`03001oogoo00Mo
o`03001oogoo07ioo`0401moogoo01mLOol007ioo`03001oogoo00Ioo`<007ioo`0401moogoo01mL
Ool007moo`03001oogoo00Eoo`03001oogoo07ioo`0401moogoo01mLOol0081oo`03001oogoo00Ao
o`03001oogoo07ioo`0401moogoo01mLOol007aoo`05001oogooOol00006Ool00`00Oomoo`1nOol0
100OOomoo`0OG7oo001mOol30007Ool00`00Oomoo`1nOol0100OOomoo`0OG7oo0027Ool00`00Oomo
o`1nOol0100OOomoo`0OG7oo0027Ool2001oOol0100OOomoo`0OG7oo0027Ool00`00Oomoo`1nOol0
100OOomoo`0OG7oo0027Ool00`00Oomoo`1nOol0100OOomoo`0OG7oo0027Ool00`00Oomoo`1nOol0
100OOomoo`0OG7oo0027Ool00`00Oomoo`1nOol0100OOomoo`0OG7oo0027Ool00`00Oomoo`1nOol0
100OOomoo`0OG7oo0027Ool00`00Oomoo`1oOol00`0OOol07`1LOol008Moo`80081oo`0301moo`0O
05aoo`00Qgoo00<007ooOol0Ogoo00<07goo01l0G7oo0027Ool00`00Oomoo`1oOol00`0OOol07`1L
Ool008Moo`03001oogoo07moo`0301moo`0O05aoo`00Qgoo00<007ooOol0Ogoo00<07goo01l0G7oo
0027Ool00`00Oomoo`1oOol00`0OOol07`1LOol008Moo`03001oogoo07moo`0301moo`0O05aoo`00
Qgoo0P00P7oo00<07goo01l0G7oo0027Ool00`00Oomoo`1oOol00`0OOol07`1LOol008Moo`03001o
ogoo07moo`0301moo`0O05aoo`00Qgoo00<007ooOol0Ogoo00<07goo01l0G7oo0027Ool00`00Oomo
o`1oOol00`0OOol07`1LOol008Moo`03001oogoo07moo`0301moo`0O05aoo`00Qgoo00<007ooOol0
Ogoo00<07goo01l0G7oo0027Ool20020Ool00`0OOol07`1LOol008Moo`03001oogoo07moo`0301mo
o`0O05aoo`00Qgoo00<007ooOol0Ogoo00<07goo01l0G7oo0027Ool00`00Oomoo`1oOol00`0OOol0
7`1LOol007eoo`<000Moo`03001oogoo07moo`0301moo`0O05aoo`00O7oo00D007ooOomoo`0000Io
o`03001oogoo07moo`0301moo`0O05aoo`00P7oo00<007ooOol017oo00<007ooOol0Ogoo00<07goo
01l0G7oo0020Ool00`00Oomoo`04Ool3001oOol00`0OOol07`1LOol007ioo`800>Qoo`00P7oo00<0
07ooOol0iGoo001lOol01@00Oomoogoo0000igoo001mOol3003XOol00?moofUoo`00ogooJGoo003o
OomYOol00?moofUoo`00ogooJGoo0028Ool3000017oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31066 m
.04057 .31075 L
.08481 .31086 L
.12636 .31097 L
.16632 .3111 L
.20885 .31125 L
.2498 .31141 L
.29331 .31162 L
.33524 .31186 L
.37557 .31213 L
.41848 .31248 L
.4598 .3129 L
.49953 .31342 L
.54183 .31415 L
.58254 .31512 L
.60473 .31582 L
.62583 .31666 L
.64662 .31771 L
.66593 .31899 L
.67703 .3199 L
.68748 .32094 L
.70702 .32351 L
.71727 .32536 L
.7281 .32791 L
.73734 .33081 L
.74749 .33522 L
.753 .33846 L
.75821 .34236 L
.76289 .34685 L
.76798 .35336 L
.77061 .35768 L
.77351 .36355 L
.77654 .3714 L
.77939 .38116 L
.78204 .39346 L
.78446 .4091 L
.78574 .41987 L
.78713 .43465 L
.78859 .45497 L
.78994 .48083 L
.79128 .51737 L
.79196 .5424 L
.7927 .57792 L
s
.7927 .57792 m
.79323 .61803 L
s
.79703 .61803 m
.79721 0 L
s
.80193 0 m
.80234 .0336 L
.80311 .07163 L
.80381 .09835 L
.8051 .13452 L
.80646 .16128 L
.80769 .17916 L
.80883 .19233 L
.81007 .20394 L
.81142 .21419 L
.81395 .22887 L
.81635 .23911 L
.81869 .24684 L
.82085 .25261 L
.82574 .26241 L
.82821 .26617 L
.83094 .26967 L
.83612 .27496 L
.84156 .27918 L
.85129 .28458 L
.85672 .28682 L
.86176 .28857 L
.87321 .29166 L
.88428 .29388 L
.89473 .29551 L
.91426 .29777 L
.93531 .29949 L
.9547 .30066 L
.97444 .3016 L
.99613 .30241 L
1 .30253 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<008Uoo`807e=oo`00OWoo0P001goo00<007ooOol0RGoo0P0O
Dgoo0020Ool00`00Oomoo`04Ool00`00Oomoo`29Ool201mCOol007aoo`05001oogooOol00006Ool0
0`00Oomoo`29Ool201mCOol007eoo`<000Moo`03001oogoo08Uoo`807e=oo`00Qgoo00<007ooOol0
RGoo0P0ODgoo0027Ool00`00Oomoo`29Ool201mCOol008Moo`8008Yoo`807e=oo`00Qgoo00<007oo
Ool0RGoo0P0ODgoo0027Ool00`00Oomoo`29Ool201mCOol008Moo`03001oogoo08Uoo`807e=oo`00
Qgoo00<007ooOol0RGoo0P0ODgoo0027Ool00`00Oomoo`29Ool201mCOol008Moo`8008Yoo`807e=o
o`00Qgoo00<007ooOol0RGoo0P0ODgoo0027Ool00`00Oomoo`29Ool201mCOol008Moo`03001oogoo
08Uoo`807e=oo`00Qgoo00<007ooOol0RGoo0P0ODgoo0027Ool00`00Oomoo`29Ool00`0OOol07`1B
Ool008Moo`03001oogoo08Uoo`0301moo`0O059oo`00Qgoo0P00RWoo00<07goo01l0DWoo0027Ool0
0`00Oomoo`29Ool00`0OOol07`1BOol008Moo`03001oogoo08Uoo`0301moo`0O059oo`00Qgoo00<0
07ooOol0RGoo00<07goo01l0DWoo0027Ool00`00Oomoo`29Ool00`0OOol07`1BOol008Moo`03001o
ogoo08Uoo`0301moo`0O059oo`00Qgoo00<007ooOol0RGoo00<07goo01l0DWoo0027Ool2002:Ool0
0`0OOol07`1BOol008Moo`03001oogoo08Uoo`0301moo`0O059oo`00Qgoo00<007ooOol0RGoo00<0
7goo01l0DWoo0027Ool00`00Oomoo`29Ool00`0OOol07`1BOol007aoo`D000Ioo`03001oogoo08Uo
o`0301moo`0O059oo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo08Uoo`0301moo`0O059oo`00
OGoo00<007ooOol01goo00<007ooOol0RGoo00<07goo01l0DWoo001dOol60004Ool00`00Oomoo`06
Ool30029Ool00`0OOol07`1BOol007moo`03001oogoo00Eoo`03001oogoo08Uoo`0301moo`0O059o
o`00P7oo00<007ooOol017oo00<007ooOol0RGoo00<07goo01l0DWoo001lOol01@00Oomoogoo0000
1Woo00<007ooOol0RGoo00<07goo01l0DWoo001mOol30007Ool00`00Oomoo`29Ool00`0OOol07`1B
Ool008Moo`03001oogoo08Uoo`0301moo`0O059oo`00Qgoo00<007ooOol0RGoo00<07goo01l0DWoo
0027Ool2002:Ool00`0OOol07`1BOol008Moo`03001oogoo08Uoo`0301moo`0O059oo`00Qgoo00<0
07ooOol0RGoo00<07goo01l0DWoo0027Ool00`00Oomoo`29Ool00`0OOol07`1BOol008Moo`03001o
ogoo08Uoo`0301moo`0O059oo`00Qgoo00<007ooOol0RGoo00<07goo01l0DWoo0027Ool00`00Oomo
o`29Ool00`0OOol07`1BOol008Moo`8008Yoo`0301moo`0O059oo`00Qgoo00<007ooOol0RGoo00@0
7gooOol07e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol07e5oo`00Qgoo00<007ooOol0RGoo00@0
7gooOol07e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol07e5oo`00Qgoo00<007ooOol0RGoo00@0
7gooOol07e5oo`00Qgoo0P00RWoo00@07gooOol07e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol0
7e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol07e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol0
7e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol07e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol0
7e5oo`00Qgoo00<007ooOol0RGoo00@07gooOol07e5oo`00Qgoo0P00RWoo00@07gooOol07e5oo`00
Qgoo00<007ooOol0RGoo00D07gooOomoo`0O051oo`00Qgoo00<007ooOol0RGoo00D07gooOomoo`0O
051oo`00Qgoo00<007ooOol0RGoo00D07gooOomoo`0O051oo`00OGoo1@001Goo00<007ooOol0RGoo
00D07gooOomoo`0O051oo`00Ogoo00<007ooOol01Goo00<007ooOol0RGoo00D07gooOomoo`0O051o
o`00Ogoo00<007ooOol01Goo00<007ooOol0RGoo00D07gooOomoo`0O051oo`00M7oo1P001Goo00<0
07ooOol01Goo0`00RGoo00D07gooOomoo`0O051oo`00Ogoo00<007ooOol01Goo00<007ooOol0RGoo
00D07gooOomoo`0O051oo`00Ogoo00<007ooOol01Goo00<007ooOol0RGoo00D07gooOomoo`0O051o
o`00OGoo0`001goo00<007ooOol0RGoo00D07gooOomoo`0O051oo`00Ogoo00<007ooOol01Goo00<0
07ooOol0RGoo00D07gooOomoo`0O051oo`00Qgoo00<007ooOol0RGoo00D07gooOomoo`0O051oo`00
Qgoo00<007ooOol0RGoo00<07gooOol00Woo00<07gooOol0CGoo0027Ool2002:Ool00`0OOomoo`02
Ool00`0OOomoo`1=Ool008Moo`03001oogoo08Uoo`0301moogoo009oo`0301moogoo04eoo`00Qgoo
00<007ooOol0RGoo00<07gooOol00Woo00<07gooOol0CGoo0027Ool00`00Oomoo`29Ool00`0OOomo
o`03Ool00`0OOomoo`1<Ool008Moo`03001oogoo08Uoo`0301moogoo00=oo`0301moogoo04aoo`00
Qgoo00<007ooOol0RGoo00<07gooOol00goo00<07gooOol0C7oo0027Ool00`00Oomoo`29Ool00`0O
Oomoo`04Ool00`0OOomoo`1;Ool008Moo`8008Yoo`0301moogoo00Aoo`0301moogoo04]oo`00Qgoo
00<007ooOol0RGoo00<07gooOol01Goo00<07gooOol0BWoo0027Ool00`00Oomoo`29Ool00`0OOomo
o`05Ool00`0OOomoo`1:Ool008Moo`03001oogoo08Uoo`0301moogoo00Eoo`0301moogoo04Yoo`00
Qgoo00<007ooOol0RGoo00<07gooOol01Woo00<07gooOol0BGoo000<Ool3000VOol5000UOol5000S
Ool00`00Oomoo`0TOol5000TOol5000UOol3000?Ool00`0OOomoo`06Ool00`0OOomoo`0=Ool3000U
Ool4000@Ool000]oo`05001oogooOol0000UOol01@00Oomoogoo00009goo00<007ooOol08goo00<0
07ooOol09Woo00<007ooOol097oo00D007ooOomoo`0002Aoo`05001oogooOol0000>Ool00`0OOomo
o`07Ool00`0OOomoo`0=Ool00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000moo`03
001oogoo02Aoo`03001oogoo02Qoo`03001oogoo02=oo`8002Moo`03001oogoo02Eoo`03001oogoo
02Uoo`03001oogoo00aoo`0301moogoo00Qoo`0301moogoo00aoo`03001oogoo02Qoo`03001oogoo
00eoo`000goo1P001Woo00<007ooOol06goo1P0017oo00<007ooOol077oo1P001Goo00<007ooOol0
8goo00<007ooOol09Woo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol037oo00<07gooOol0
2Goo00<07gooOol01goo1P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomoo`0VOol00`00
Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0UOol2000?Ool00`0OOomoo`0:
Ool00`0OOomoo`07Ool01000Oomoo`009Woo100047oo000?Ool00`00Oomoo`0WOol00`00Oomoo`0U
Ool00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0VOol00`00Oomoo`0<
Ool00`0OOomoo`0;Ool00`0OOomoo`06Ool01000Oomoo`009Woo00<007ooOol04Goo000;Ool01@00
Oomoogoo00009Goo00D007ooOomoo`0002Eoo`<002Eoo`03001oogoo02Aoo`<002Ioo`05001oogoo
Ool0000TOol01@00Oomoogoo00003Woo00<07gooOol037oo0P0O1goo00<007oo00009Woo00<007oo
Ool04Goo000<Ool3000WOol3000XOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0UOol3
000VOol3000?Ool00`0OOomoo`0>Ool201l6Ool2000VOol5000?Ool008Moo`8008Yoo`0301moogoo
011oo`@07cioo`00Qgoo00<007ooOol0RGoo00<07gooOol057oo100O>Woo0027Ool00`00Oomoo`29
Ool00`0OOomoo`0HOol401lfOol008Moo`03001oogoo08Uoo`0301moogoo01aoo`/07b]oo`00Qgoo
00<007ooOol0RGoo00<07gooOol09goo3@0O7Woo0027Ool00`00Oomoo`29Ool00`0OOomoo`0dOol=
01lAOol008Moo`03001oogoo08Uoo`0301moogoo059oo`002Wooo`002P0000<07`000000@@004Goo
000:OonB01l4Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`0O001oo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool5000000Yoo`03001o
ogoo02Moo`03001oogoo02Ioo`03001oogoo02Moo`03001oogoo019ooc/07`=oo`03001oogoo02Io
o`03001oogoo00eoo`0301moogoo01Ioo`03001oogoo02Moo`03001oogoo00Yoo`04001oogooOol1
000008Moo`03001oogoo04eoo`d07bmoo`0301moogoo04ioo`03001oogoo005oo`00Qgoo00<007oo
Ool0FWoo3P0O8Goo00<07gooOol0Cgoo0@000Goo0Goo0027Ool00`00Oomoo`1XOol501lLOol00`0O
Oomoo`1=Ool01000Oomoo`000Goo0027Ool00`00Oomoo`1]Ool701lEOol00`0OOomoo`1=Ool50000
08Moo`8007Eoo`807a=oo`0301moogoo059oo`00Qgoo00<007ooOol0MWoo0P0O4Goo00<07gooOol0
DWoo0027Ool00`00Oomoo`1hOol00`0OOomoo`0>Ool00`0OOomoo`1BOol008Moo`03001oogoo07Uo
o`807`ioo`0301moogoo059oo`00Qgoo00<007ooOol0Ngoo0P0O37oo00<07gooOol0DWoo0027Ool0
0`00Oomoo`1mOol00`0OOomoo`09Ool00`0OOomoo`1BOol008Moo`03001oogoo07eoo`0301moogoo
00Uoo`0301moogoo059oo`00Qgoo0P00Ogoo00<07gooOol027oo00<07gooOol0DWoo0027Ool00`00
Oomoo`1oOol00`0OOomoo`07Ool00`0OOomoo`1BOol008Moo`03001oogoo081oo`0301moogoo00Io
o`0301moogoo059oo`00Qgoo00<007ooOol0PGoo00<07gooOol01Goo00<07gooOol0DWoo0027Ool0
0`00Oomoo`21Ool00`0OOomoo`05Ool00`0OOomoo`1BOol008Moo`03001oogoo085oo`0301moogoo
00Eoo`0301moogoo059oo`00Qgoo00<007ooOol0PWoo00<07gooOol017oo00<07gooOol0DWoo0027
Ool20023Ool00`0OOomoo`04Ool00`0OOomoo`1BOol008Moo`03001oogoo089oo`0301moogoo00Ao
o`0301moogoo059oo`00Qgoo00<007ooOol0Pgoo00<07gooOol00goo00<07gooOol0DWoo0027Ool0
0`00Oomoo`23Ool00`0OOomoo`03Ool00`0OOomoo`1BOol008Moo`03001oogoo08=oo`0301moogoo
00=oo`0301moogoo059oo`00Qgoo00<007ooOol0Q7oo00<07gooOol00Woo00<07gooOol0DWoo0027
Ool00`00Oomoo`24Ool00`0OOomoo`02Ool00`0OOomoo`1BOol008Moo`8008Eoo`0301moogoo009o
o`0301moogoo059oo`00Qgoo00<007ooOol0Q7oo00<07gooOol00Woo00<07gooOol0DWoo0027Ool0
0`00Oomoo`24Ool00`0OOomoo`02Ool00`0OOomoo`1BOol007eoo`D000Eoo`03001oogoo08Aoo`03
01moogoo009oo`0301moogoo059oo`00Ogoo00<007ooOol01Goo00<007ooOol0Q7oo00<07gooOol0
0Woo00<07gooOol0DWoo001oOol00`00Oomoo`05Ool00`00Oomoo`24Ool00`0OOomoo`02Ool00`0O
Oomoo`1BOol007moo`03001oogoo00Eoo`<008Aoo`0301moogoo009oo`0301moogoo059oo`00Ogoo
00<007ooOol01Goo00<007ooOol0QGoo00D07gooOomoo`0O05Aoo`00Ogoo00<007ooOol01Goo00<0
07ooOol0QGoo00D07gooOomoo`0O05Aoo`00OGoo0`001goo00<007ooOol0QGoo00D07gooOomoo`0O
05Aoo`00Ogoo00<007ooOol01Goo00<007ooOol0QGoo00D07gooOomoo`0O05Aoo`00Qgoo00<007oo
Ool0QGoo00D07gooOomoo`0O05Aoo`00Qgoo00<007ooOol0QGoo00D07gooOomoo`0O05Aoo`00Qgoo
0P00QWoo00D07gooOomoo`0O05Aoo`00Qgoo00<007ooOol0QGoo00D07gooOomoo`0O05Aoo`00Qgoo
00<007ooOol0QGoo00D07gooOomoo`0O05Aoo`00Qgoo00<007ooOol0QGoo00D07gooOomoo`0O05Ao
o`00Qgoo00<007ooOol0QGoo00D07gooOomoo`0O05Aoo`00Qgoo00<007ooOol0QWoo00@07gooOol0
7eAoo`00Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00Qgoo0P00Qgoo00@07gooOol07eAoo`00
Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00
Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00
Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00
Qgoo0P00Qgoo00@07gooOol07eAoo`00Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<0
07ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<0
07ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<007ooOol0QWoo00@07gooOol07eAoo`00Qgoo00<0
07ooOol0QWoo00@07gooOol07eAoo`00Qgoo0P00Qgoo00@07gooOol07eAoo`00Qgoo00<007ooOol0
Qgoo00<07goo01l0E7oo0027Ool00`00Oomoo`27Ool00`0OOol07`1DOol008Moo`03001oogoo08Mo
o`0301moo`0O05Aoo`00O7oo1@001Woo00<007ooOol0Qgoo00<07goo01l0E7oo001lOol01@00Oomo
ogoo00001Woo00<007ooOol0Qgoo00<07goo01l0E7oo001mOol00`00Oomoo`07Ool00`00Oomoo`27
Ool00`0OOol07`1DOol007ioo`03001oogoo00Ioo`<008Moo`0301moo`0O05Aoo`00Ogoo00<007oo
Ool01Goo00<007ooOol0Qgoo00<07goo01l0E7oo0020Ool00`00Oomoo`04Ool00`00Oomoo`27Ool0
0`0OOol07`1DOol007aoo`05001oogooOol00006Ool00`00Oomoo`27Ool00`0OOol07`1DOol007eo
o`<000Moo`03001oogoo08Moo`0301moo`0O05Aoo`00Qgoo00<007ooOol0Qgoo00<07goo01l0E7oo
0027Ool20028Ool00`0OOol07`1DOol008Moo`03001oogoo08Moo`0301moo`0O05Aoo`00Qgoo00<0
07ooOol0Qgoo00<07goo01l0E7oo0027Ool00`00Oomoo`27Ool00`0OOol07`1DOol008Moo`03001o
ogoo08Moo`0301moo`0O05Aoo`00Qgoo00<007ooOol0Qgoo00<07goo01l0E7oo0027Ool00`00Oomo
o`27Ool00`0OOol07`1DOol008Moo`8008Qoo`0301moo`0O05Aoo`00Qgoo00<007ooOol0Qgoo00<0
7goo01l0E7oo0027Ool00`00Oomoo`27Ool00`0OOol07`1DOol008Moo`03001oogoo08Moo`0301mo
o`0O05Aoo`00Qgoo00<007ooOol0Qgoo00<07goo01l0E7oo0027Ool00`00Oomoo`27Ool00`0OOol0
7`1DOol008Moo`03001oogoo08Moo`0301moo`0O05Aoo`00Qgoo0P00R7oo00<07goo01l0E7oo0027
Ool00`00Oomoo`27Ool00`0OOol07`1DOol008Moo`03001oogoo08Moo`0301moo`0O05Aoo`00Qgoo
00<007ooOol0Qgoo00<07goo01l0E7oo0027Ool00`00Oomoo`27Ool00`0OOol07`1DOol008Moo`03
001oogoo08Moo`0301moo`0O05Aoo`00Qgoo00<007ooOol0Qgoo00<07goo01l0E7oo0027Ool20028
Ool00`0OOol07`1DOol008Moo`03001oogoo08Moo`0301moo`0O05Aoo`00Qgoo00<007ooOol0Qgoo
00<07goo01l0E7oo0027Ool00`00Oomoo`27Ool00`0OOol07`1DOol007eoo`<000Moo`03001oogoo
08Moo`0301moo`0O05Aoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo08Moo`0301moo`0O05Ao
o`00P7oo00<007ooOol017oo00<007ooOol0Qgoo00<07goo01l0E7oo0020Ool00`00Oomoo`04Ool3
0027Ool00`0OOol07`1DOol007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo
0000igoo001mOol3003XOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028
Ool3000017oo00000000fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31061 m
.04057 .3107 L
.08481 .3108 L
.12636 .3109 L
.16632 .31102 L
.20885 .31116 L
.2498 .31131 L
.29331 .3115 L
.33524 .31171 L
.37557 .31195 L
.41848 .31227 L
.4598 .31263 L
.49953 .31308 L
.54183 .31369 L
.58254 .31448 L
.60473 .31504 L
.62583 .31569 L
.64686 .31649 L
.66593 .3174 L
.68659 .31867 L
.69806 .31956 L
.70861 .32053 L
.72882 .32302 L
.73945 .32481 L
.75068 .32727 L
.76063 .3302 L
.76611 .33226 L
.7713 .33461 L
.77612 .33727 L
.78137 .34086 L
.78614 .34503 L
.79055 .34999 L
.79541 .35733 L
.79815 .36274 L
.80066 .36889 L
.80305 .37623 L
.80528 .38488 L
.8076 .39666 L
.81015 .41458 L
.8115 .42746 L
.81296 .44552 L
.81435 .46848 L
.81562 .49776 L
.81678 .53522 L
.81804 .5984 L
s
.81804 .5984 m
.81826 .61803 L
s
.82278 .61803 m
.82299 0 L
s
.82684 0 m
.82746 .04019 L
.82879 .09781 L
.82954 .12049 L
.83023 .13742 L
.83178 .16633 L
.83311 .18437 L
.83437 .19768 L
.83673 .21625 L
.83927 .23037 L
.84203 .24153 L
.84444 .24897 L
.84699 .25526 L
.85158 .26376 L
.85691 .27079 L
.86191 .27565 L
.86739 .27973 L
.87329 .28314 L
.88337 .28743 L
.89438 .29074 L
.90587 .29326 L
.91655 .29505 L
.92762 .29652 L
.93807 .29765 L
.9576 .2993 L
.97865 .30061 L
.99804 .30154 L
1 .30162 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<0095oo`807d]oo`00OWoo0P001goo00<007ooOol0TGoo0P0O
Bgoo0020Ool00`00Oomoo`04Ool00`00Oomoo`2AOol201m;Ool007aoo`05001oogooOol00006Ool0
0`00Oomoo`2AOol201m;Ool007eoo`<000Moo`03001oogoo095oo`807d]oo`00Qgoo00<007ooOol0
TGoo0P0OBgoo0027Ool00`00Oomoo`2AOol201m;Ool008Moo`80099oo`0301moo`0O04Yoo`00Qgoo
00<007ooOol0TGoo00<07goo01l0BWoo0027Ool00`00Oomoo`2AOol00`0OOol07`1:Ool008Moo`03
001oogoo095oo`0301moo`0O04Yoo`00Qgoo00<007ooOol0TGoo00<07goo01l0BWoo0027Ool00`00
Oomoo`2AOol00`0OOol07`1:Ool008Moo`80099oo`0301moo`0O04Yoo`00Qgoo00<007ooOol0TGoo
00<07goo01l0BWoo0027Ool00`00Oomoo`2AOol00`0OOol07`1:Ool008Moo`03001oogoo095oo`03
01moo`0O04Yoo`00Qgoo00<007ooOol0TGoo00<07goo01l0BWoo0027Ool00`00Oomoo`2AOol00`0O
Ool07`1:Ool008Moo`03001oogoo095oo`0301moo`0O04Yoo`00Qgoo0P00TWoo00<07goo01l0BWoo
0027Ool00`00Oomoo`2AOol00`0OOol07`1:Ool008Moo`03001oogoo095oo`0301moo`0O04Yoo`00
Qgoo00<007ooOol0TGoo00<07goo01l0BWoo0027Ool00`00Oomoo`2AOol00`0OOol07`1:Ool008Mo
o`03001oogoo095oo`0301moo`0O04Yoo`00Qgoo00<007ooOol0TGoo00<07goo01l0BWoo0027Ool2
002BOol00`0OOol07`1:Ool008Moo`03001oogoo095oo`0301moo`0O04Yoo`00Qgoo00<007ooOol0
TGoo00<07goo01l0BWoo0027Ool00`00Oomoo`2AOol00`0OOol07`1:Ool007aoo`D000Ioo`03001o
ogoo095oo`0301moo`0O04Yoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo095oo`0301moo`0O
04Yoo`00OGoo00<007ooOol01goo00<007ooOol0TGoo00<07goo01l0BWoo001dOol60004Ool00`00
Oomoo`06Ool3002AOol00`0OOol07`1:Ool007moo`03001oogoo00Eoo`03001oogoo095oo`0301mo
o`0O04Yoo`00P7oo00<007ooOol017oo00<007ooOol0TGoo00<07goo01l0BWoo001lOol01@00Oomo
ogoo00001Woo00<007ooOol0TGoo00<07goo01l0BWoo001mOol30007Ool00`00Oomoo`2AOol00`0O
Ool07`1:Ool008Moo`03001oogoo095oo`0301moo`0O04Yoo`00Qgoo00<007ooOol0TGoo00<07goo
01l0BWoo0027Ool2002BOol00`0OOol07`1:Ool008Moo`03001oogoo095oo`0301moo`0O04Yoo`00
Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00
Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00
Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00Qgoo0P00TWoo00@07gooOol07dUoo`00Qgoo00<0
07ooOol0TGoo00@07gooOol07dUoo`00Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00Qgoo00<0
07ooOol0TGoo00@07gooOol07dUoo`00Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00Qgoo00<0
07ooOol0TGoo00@07gooOol07dUoo`00Qgoo0P00TWoo00@07gooOol07dUoo`00Qgoo00<007ooOol0
TGoo00@07gooOol07dUoo`00Qgoo00<007ooOol0TGoo00@07gooOol07dUoo`00Qgoo00<007ooOol0
TGoo00@07gooOol07dUoo`00Qgoo00<007ooOol0TGoo00D07gooOomoo`0O04Qoo`00Qgoo00<007oo
Ool0TGoo00D07gooOomoo`0O04Qoo`00Qgoo00<007ooOol0TGoo00D07gooOomoo`0O04Qoo`00Qgoo
0P00TWoo00D07gooOomoo`0O04Qoo`00Qgoo00<007ooOol0TGoo00D07gooOomoo`0O04Qoo`00Qgoo
00<007ooOol0TGoo00D07gooOomoo`0O04Qoo`00Qgoo00<007ooOol0TGoo00D07gooOomoo`0O04Qo
o`00OGoo1@001Goo00<007ooOol0TGoo00D07gooOomoo`0O04Qoo`00Ogoo00<007ooOol01Goo00<0
07ooOol0TGoo00D07gooOomoo`0O04Qoo`00Ogoo00<007ooOol01Goo00<007ooOol0TGoo00D07goo
Oomoo`0O04Qoo`00M7oo1P001Goo00<007ooOol01Goo0`00TGoo00<07gooOol00Woo00<07gooOol0
AGoo001oOol00`00Oomoo`05Ool00`00Oomoo`2AOol00`0OOomoo`02Ool00`0OOomoo`15Ool007mo
o`03001oogoo00Eoo`03001oogoo095oo`0301moogoo009oo`0301moogoo04Eoo`00OGoo0`001goo
00<007ooOol0TGoo00<07gooOol00Woo00<07gooOol0AGoo001oOol00`00Oomoo`05Ool00`00Oomo
o`2AOol00`0OOomoo`02Ool00`0OOomoo`15Ool008Moo`03001oogoo095oo`0301moogoo009oo`03
01moogoo04Eoo`00Qgoo00<007ooOol0TGoo00<07gooOol00goo00<07gooOol0A7oo0027Ool2002B
Ool00`0OOomoo`03Ool00`0OOomoo`14Ool008Moo`03001oogoo095oo`0301moogoo00=oo`0301mo
ogoo04Aoo`00Qgoo00<007ooOol0TGoo00<07gooOol00goo00<07gooOol0A7oo0027Ool00`00Oomo
o`2AOol00`0OOomoo`04Ool00`0OOomoo`13Ool008Moo`03001oogoo095oo`0301moogoo00Aoo`03
01moogoo04=oo`00Qgoo00<007ooOol0TGoo00<07gooOol017oo00<07gooOol0@goo0027Ool00`00
Oomoo`2AOol00`0OOomoo`04Ool00`0OOomoo`13Ool008Moo`80099oo`0301moogoo00Aoo`0301mo
ogoo04=oo`00Qgoo00<007ooOol0TGoo00<07gooOol01Goo00<07gooOol0@Woo0027Ool00`00Oomo
o`2AOol00`0OOomoo`05Ool00`0OOomoo`12Ool008Moo`03001oogoo095oo`0301moogoo00Ioo`03
01moogoo045oo`00Qgoo00<007ooOol0TGoo00<07gooOol01Woo00<07gooOol0@Goo000<Ool3000V
Ool5000UOol5000SOol00`00Oomoo`0TOol5000TOol5000UOol3000GOol00`0OOomoo`07Ool00`0O
Oomoo`04Ool3000UOol4000@Ool000]oo`05001oogooOol0000UOol01@00Oomoogoo00009goo00<0
07ooOol08goo00<007ooOol09Woo00<007ooOol097oo00D007ooOomoo`0002Aoo`05001oogooOol0
000FOol00`0OOomoo`07Ool00`0OOomoo`05Ool00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomo
o`0=Ool000moo`03001oogoo02Aoo`03001oogoo02Qoo`03001oogoo02=oo`8002Moo`03001oogoo
02Eoo`03001oogoo02Uoo`03001oogoo01Aoo`0301moogoo00Qoo`0301moogoo00Aoo`03001oogoo
02Qoo`03001oogoo00eoo`000goo1P001Woo00<007ooOol06goo1P0017oo00<007ooOol077oo1P00
1Goo00<007ooOol08goo00<007ooOol09Woo00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol0
57oo00<07gooOol027oo00<07gooOol01P00:Goo00<007ooOol03Goo000=Ool2000YOol00`00Oomo
o`0VOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0UOol2000GOol0
0`0OOomoo`09Ool201l01Goo001oogoo00009Woo100047oo000?Ool00`00Oomoo`0WOol00`00Oomo
o`0UOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0XOol00`00Oomoo`0VOol00`00Oomo
o`0DOol00`0OOomoo`0;Ool01@0O001oogoo00009Woo00<007ooOol04Goo000;Ool01@00Oomoogoo
00009Goo00D007ooOomoo`0002Eoo`<002Eoo`03001oogoo02Aoo`<002Ioo`05001oogooOol0000T
Ool01@00Oomoogoo00005Woo00<07gooOol037oo00@07`00Ool002Ioo`03001oogoo015oo`0037oo
0`009goo0`00:7oo00<007ooOol08goo00<007ooOol09Woo00<007ooOol09Goo0`009Woo0`005goo
00<07gooOol03Goo0`0O9Woo1@003goo0027Ool2002BOol00`0OOomoo`0@Ool301lgOol008Moo`03
001oogoo095oo`0301moogoo01=oo`@07c=oo`00Qgoo00<007ooOol0TGoo00<07gooOol05goo100O
;goo0027Ool00`00Oomoo`2AOol00`0OOomoo`0KOol<01lSOol008Moo`03001oogoo095oo`0301mo
ogoo02Moo`d07aIoo`00Qgoo00<007ooOol0TGoo00<07gooOol0=7oo1@0O4Goo0027Ool00`00Oomo
o`2AOol00`0OOomoo`1:Ool000Yoool00180000301l0000003T0015oo`002WooX00O1Woo00<007oo
Ool01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007oo
Ool01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007oo
Ool01Goo00<007ooOol01Woo00<007ooOol017oo00<07`00Ool01Woo00<007ooOol01Goo00<007oo
Ool01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007oo
Ool02Woo1@00000:Ool00`00Oomoo`0WOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0P
Oold01lUOol00`00Oomoo`0EOol00`0OOomoo`0>Ool00`00Oomoo`0WOol00`00Oomoo`0:Ool01000
Oomoogoo0@000027Ool00`00Oomoo`1DOolB01l[Ool00`0OOomoo`16Ool00`00Oomoo`01Ool008Mo
o`03001oogoo06Ioo`T07b9oo`0301moogoo04Moo`40005oo`5oo`00Qgoo00<007ooOol0Kgoo2@0O
6Goo00<07gooOol0AGoo00@007ooOol0005oo`00Qgoo00<007ooOol0N7oo0`0O5Woo00<07gooOol0
AGoo1@000027Ool2001lOol301lCOol00`0OOomoo`1:Ool008Moo`03001oogoo07ioo`0301moogoo
011oo`0301moogoo04Yoo`00Qgoo00<007ooOol0Ogoo0P0O47oo00<07gooOol0BWoo0027Ool00`00
Oomoo`21Ool201l>Ool00`0OOomoo`1:Ool008Moo`03001oogoo08=oo`0301moogoo00]oo`0301mo
ogoo04Yoo`00Qgoo00<007ooOol0Q7oo0P0O2goo00<07gooOol0BWoo0027Ool00`00Oomoo`26Ool0
0`0OOomoo`08Ool00`0OOomoo`1:Ool008Moo`8008Moo`0301moogoo00Qoo`0301moogoo04Yoo`00
Qgoo00<007ooOol0Qgoo00<07gooOol01goo00<07gooOol0BWoo0027Ool00`00Oomoo`28Ool00`0O
Oomoo`06Ool00`0OOomoo`1:Ool008Moo`03001oogoo08Uoo`0301moogoo00Eoo`0301moogoo04Yo
o`00Qgoo00<007ooOol0RGoo00<07gooOol01Goo00<07gooOol0BWoo0027Ool00`00Oomoo`2:Ool0
0`0OOomoo`04Ool00`0OOomoo`1:Ool008Moo`03001oogoo08Yoo`0301moogoo00Aoo`0301moogoo
04Yoo`00Qgoo0P00Rgoo00<07gooOol017oo00<07gooOol0BWoo0027Ool00`00Oomoo`2;Ool00`0O
Oomoo`03Ool00`0OOomoo`1:Ool008Moo`03001oogoo08]oo`0301moogoo00=oo`0301moogoo04Yo
o`00Qgoo00<007ooOol0Rgoo00<07gooOol00goo00<07gooOol0BWoo0027Ool00`00Oomoo`2;Ool0
0`0OOomoo`03Ool00`0OOomoo`1:Ool008Moo`03001oogoo08]oo`0301moogoo00=oo`0301moogoo
04Yoo`00Qgoo00<007ooOol0S7oo00<07gooOol00Woo00<07gooOol0BWoo0027Ool2002=Ool00`0O
Oomoo`02Ool00`0OOomoo`1:Ool008Moo`03001oogoo08aoo`0301moogoo009oo`0301moogoo04Yo
o`00Qgoo00<007ooOol0S7oo00<07gooOol00Woo00<07gooOol0BWoo001mOol50005Ool00`00Oomo
o`2<Ool00`0OOomoo`02Ool00`0OOomoo`1:Ool007moo`03001oogoo00Eoo`03001oogoo08eoo`05
01moogooOol07`1<Ool007moo`03001oogoo00Eoo`03001oogoo08eoo`0501moogooOol07`1<Ool0
07moo`03001oogoo00Eoo`<008eoo`0501moogooOol07`1<Ool007moo`03001oogoo00Eoo`03001o
ogoo08eoo`0501moogooOol07`1<Ool007moo`03001oogoo00Eoo`03001oogoo08eoo`0501moogoo
Ool07`1<Ool007eoo`<000Moo`03001oogoo08eoo`0501moogooOol07`1<Ool007moo`03001oogoo
00Eoo`03001oogoo08eoo`0501moogooOol07`1<Ool008Moo`03001oogoo08eoo`0501moogooOol0
7`1<Ool008Moo`03001oogoo08eoo`0501moogooOol07`1<Ool008Moo`8008ioo`0501moogooOol0
7`1<Ool008Moo`03001oogoo08eoo`0501moogooOol07`1<Ool008Moo`03001oogoo08ioo`0401mo
ogoo01m<Ool008Moo`03001oogoo08ioo`0401moogoo01m<Ool008Moo`03001oogoo08ioo`0401mo
ogoo01m<Ool008Moo`03001oogoo08ioo`0401moogoo01m<Ool008Moo`03001oogoo08ioo`0401mo
ogoo01m<Ool008Moo`8008moo`0401moogoo01m<Ool008Moo`03001oogoo08ioo`0401moogoo01m<
Ool008Moo`03001oogoo08ioo`0401moogoo01m<Ool008Moo`03001oogoo08ioo`0401moogoo01m<
Ool008Moo`03001oogoo08ioo`0401moogoo01m<Ool008Moo`03001oogoo08ioo`0401moogoo01m<
Ool008Moo`03001oogoo08ioo`0401moogoo01m<Ool008Moo`8008moo`0401moogoo01m<Ool008Mo
o`03001oogoo08ioo`0401moogoo01m<Ool008Moo`03001oogoo08ioo`0401moogoo01m<Ool008Mo
o`03001oogoo08moo`0301moo`0O04aoo`00Qgoo00<007ooOol0Sgoo00<07goo01l0C7oo0027Ool0
0`00Oomoo`2?Ool00`0OOol07`1<Ool008Moo`03001oogoo08moo`0301moo`0O04aoo`00Qgoo0P00
T7oo00<07goo01l0C7oo0027Ool00`00Oomoo`2?Ool00`0OOol07`1<Ool008Moo`03001oogoo08mo
o`0301moo`0O04aoo`00Qgoo00<007ooOol0Sgoo00<07goo01l0C7oo001lOol50006Ool00`00Oomo
o`2?Ool00`0OOol07`1<Ool007aoo`05001oogooOol00006Ool00`00Oomoo`2?Ool00`0OOol07`1<
Ool007eoo`03001oogoo00Moo`03001oogoo08moo`0301moo`0O04aoo`00OWoo00<007ooOol01Woo
0`00Sgoo00<07goo01l0C7oo001oOol00`00Oomoo`05Ool00`00Oomoo`2?Ool00`0OOol07`1<Ool0
081oo`03001oogoo00Aoo`03001oogoo08moo`0301moo`0O04aoo`00O7oo00D007ooOomoo`0000Io
o`03001oogoo08moo`0301moo`0O04aoo`00OGoo0`001goo00<007ooOol0Sgoo00<07goo01l0C7oo
0027Ool00`00Oomoo`2?Ool00`0OOol07`1<Ool008Moo`80091oo`0301moo`0O04aoo`00Qgoo00<0
07ooOol0Sgoo00<07goo01l0C7oo0027Ool00`00Oomoo`2?Ool00`0OOol07`1<Ool008Moo`03001o
ogoo08moo`0301moo`0O04aoo`00Qgoo00<007ooOol0Sgoo00<07goo01l0C7oo0027Ool00`00Oomo
o`2?Ool00`0OOol07`1<Ool008Moo`03001oogoo08moo`0301moo`0O04aoo`00Qgoo0P00T7oo00<0
7goo01l0C7oo0027Ool00`00Oomoo`2?Ool00`0OOol07`1<Ool008Moo`03001oogoo08moo`0301mo
o`0O04aoo`00Qgoo00<007ooOol0Sgoo00<07goo01l0C7oo0027Ool00`00Oomoo`2@Ool201m<Ool0
08Moo`03001oogoo091oo`807daoo`00Qgoo00<007ooOol0T7oo0P0OC7oo0027Ool2002AOol201m<
Ool008Moo`03001oogoo091oo`807daoo`00Qgoo00<007ooOol0T7oo0P0OC7oo0027Ool00`00Oomo
o`2@Ool201m<Ool008Moo`03001oogoo091oo`807daoo`00Qgoo00<007ooOol0T7oo0P0OC7oo0027
Ool00`00Oomoo`2@Ool201m<Ool008Moo`80095oo`807daoo`00Qgoo00<007ooOol0T7oo0P0OC7oo
0027Ool00`00Oomoo`2@Ool201m<Ool008Moo`03001oogoo091oo`807daoo`00OGoo0`001goo00<0
07ooOol0T7oo0P0OC7oo001lOol01@00Oomoogoo00001Woo00<007ooOol0T7oo0P0OC7oo0020Ool0
0`00Oomoo`04Ool00`00Oomoo`2@Ool201m<Ool0081oo`03001oogoo00Aoo`<0091oo`807daoo`00
OWoo0P00j7oo0020Ool00`00Oomoo`3UOol007aoo`05001oogooOol0003WOol007eoo`<00>Qoo`00
ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol008Qoo`<00004Ool00000003IOol0
0001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31057 m
.04057 .31064 L
.08481 .31074 L
.12636 .31084 L
.16632 .31094 L
.20885 .31107 L
.2498 .31121 L
.29331 .31139 L
.33524 .31158 L
.37557 .3118 L
.41848 .31208 L
.4598 .3124 L
.49953 .31279 L
.54183 .31331 L
.58254 .31397 L
.60324 .31439 L
.62583 .31494 L
.66752 .31631 L
.68818 .31725 L
.7102 .31857 L
.721 .31939 L
.73268 .32044 L
.74278 .32154 L
.75386 .32302 L
.76469 .32485 L
.7748 .32705 L
.78547 .33015 L
.79146 .3324 L
.79691 .33492 L
.80196 .33779 L
.80732 .34162 L
.8119 .3458 L
.81695 .35187 L
.82236 .36107 L
.82541 .36821 L
.8282 .37673 L
.83065 .38655 L
.83334 .40118 L
.83469 .41088 L
.83614 .42378 L
.83751 .43936 L
.83875 .4577 L
.84 .48228 L
.84118 .51398 L
.84246 .56547 L
s
.84246 .56547 m
.84323 .61803 L
s
.84698 .61803 m
.84716 0 L
s
.85186 0 m
.85276 .05556 L
.85391 .10178 L
.85518 .13625 L
.85651 .16204 L
.85765 .17866 L
.8589 .19303 L
.86036 .20635 L
.86175 .21641 L
.86435 .23077 L
.86715 .24197 L
.8702 .25099 L
.87285 .25709 L
.87567 .2623 L
.88073 .26943 L
.88588 .27475 L
.8906 .27851 L
.89567 .28173 L
.90122 .28455 L
.91058 .28818 L
.92043 .291 L
.93124 .29333 L
.94106 .29498 L
.95252 .29651 L
.96307 .29765 L
.9808 .29917 L
1 .30041 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<009Uoo`0301moo`0O049oo`00OWoo0P001goo00<007ooOol0
VGoo00<07goo01l0@Woo0020Ool00`00Oomoo`04Ool00`00Oomoo`2IOol00`0OOol07`12Ool007ao
o`05001oogooOol00006Ool00`00Oomoo`2IOol00`0OOol07`12Ool007eoo`<000Moo`03001oogoo
09Uoo`0301moo`0O049oo`00Qgoo00<007ooOol0VGoo00<07goo01l0@Woo0027Ool00`00Oomoo`2I
Ool00`0OOol07`12Ool008Moo`8009Yoo`0301moo`0O049oo`00Qgoo00<007ooOol0VGoo00<07goo
01l0@Woo0027Ool00`00Oomoo`2IOol00`0OOol07`12Ool008Moo`03001oogoo09Uoo`0301moo`0O
049oo`00Qgoo00<007ooOol0VGoo00<07goo01l0@Woo0027Ool00`00Oomoo`2IOol00`0OOol07`12
Ool008Moo`8009Yoo`0301moo`0O049oo`00Qgoo00<007ooOol0VGoo00<07goo01l0@Woo0027Ool0
0`00Oomoo`2IOol00`0OOol07`12Ool008Moo`03001oogoo09Uoo`0301moo`0O049oo`00Qgoo00<0
07ooOol0VGoo00<07goo01l0@Woo0027Ool00`00Oomoo`2IOol00`0OOol07`12Ool008Moo`03001o
ogoo09Uoo`0301moo`0O049oo`00Qgoo0P00VWoo00<07goo01l0@Woo0027Ool00`00Oomoo`2IOol0
0`0OOol07`12Ool008Moo`03001oogoo09Uoo`0301moo`0O049oo`00Qgoo00<007ooOol0VGoo00<0
7goo01l0@Woo0027Ool00`00Oomoo`2IOol00`0OOol07`12Ool008Moo`03001oogoo09Uoo`0301mo
o`0O049oo`00Qgoo00<007ooOol0VGoo00<07goo01l0@Woo0027Ool2002JOol00`0OOol07`12Ool0
08Moo`03001oogoo09Uoo`0301moo`0O049oo`00Qgoo00<007ooOol0VGoo00<07goo01l0@Woo0027
Ool00`00Oomoo`2IOol00`0OOol07`12Ool007aoo`D000Ioo`03001oogoo09Uoo`0301moo`0O049o
o`00O7oo00D007ooOomoo`0000Ioo`03001oogoo09Uoo`0301moo`0O049oo`00OGoo00<007ooOol0
1goo00<007ooOol0VGoo00<07goo01l0@Woo001dOol60004Ool00`00Oomoo`06Ool3002IOol00`0O
Ool07`12Ool007moo`03001oogoo00Eoo`03001oogoo09Uoo`0301moo`0O049oo`00P7oo00<007oo
Ool017oo00<007ooOol0VGoo00<07goo01l0@Woo001lOol01@00Oomoogoo00001Woo00<007ooOol0
VGoo00<07goo01l0@Woo001mOol30007Ool00`00Oomoo`2IOol00`0OOol07`12Ool008Moo`03001o
ogoo09Uoo`0301moo`0O049oo`00Qgoo00<007ooOol0VGoo00@07gooOol07d5oo`00Qgoo0P00VWoo
00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo
00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo
00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo
00@07gooOol07d5oo`00Qgoo0P00VWoo00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo00@07goo
Ool07d5oo`00Qgoo00<007ooOol0VGoo00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo00@07goo
Ool07d5oo`00Qgoo00<007ooOol0VGoo00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo00@07goo
Ool07d5oo`00Qgoo0P00VWoo00@07gooOol07d5oo`00Qgoo00<007ooOol0VGoo00@07gooOol07d5o
o`00Qgoo00<007ooOol0VGoo00D07gooOomoo`0O041oo`00Qgoo00<007ooOol0VGoo00D07gooOomo
o`0O041oo`00Qgoo00<007ooOol0VGoo00D07gooOomoo`0O041oo`00Qgoo00<007ooOol0VGoo00D0
7gooOomoo`0O041oo`00Qgoo00<007ooOol0VGoo00D07gooOomoo`0O041oo`00Qgoo0P00VWoo00D0
7gooOomoo`0O041oo`00Qgoo00<007ooOol0VGoo00D07gooOomoo`0O041oo`00Qgoo00<007ooOol0
VGoo00D07gooOomoo`0O041oo`00Qgoo00<007ooOol0VGoo00D07gooOomoo`0O041oo`00OGoo1@00
1Goo00<007ooOol0VGoo00D07gooOomoo`0O041oo`00Ogoo00<007ooOol01Goo00<007ooOol0VGoo
00<07gooOol00Woo00<07gooOol0?Goo001oOol00`00Oomoo`05Ool00`00Oomoo`2IOol00`0OOomo
o`02Ool00`0OOomoo`0mOol007Aoo`H000Eoo`03001oogoo00Eoo`<009Uoo`0301moogoo009oo`03
01moogoo03eoo`00Ogoo00<007ooOol01Goo00<007ooOol0VGoo00<07gooOol00Woo00<07gooOol0
?Goo001oOol00`00Oomoo`05Ool00`00Oomoo`2IOol00`0OOomoo`02Ool00`0OOomoo`0mOol007eo
o`<000Moo`03001oogoo09Uoo`0301moogoo009oo`0301moogoo03eoo`00Ogoo00<007ooOol01Goo
00<007ooOol0VGoo00<07gooOol00Woo00<07gooOol0?Goo0027Ool00`00Oomoo`2IOol00`0OOomo
o`02Ool00`0OOomoo`0mOol008Moo`03001oogoo09Uoo`0301moogoo00=oo`0301moogoo03aoo`00
Qgoo0P00VWoo00<07gooOol00goo00<07gooOol0?7oo0027Ool00`00Oomoo`2IOol00`0OOomoo`03
Ool00`0OOomoo`0lOol008Moo`03001oogoo09Uoo`0301moogoo00=oo`0301moogoo03aoo`00Qgoo
00<007ooOol0VGoo00<07gooOol017oo00<07gooOol0>goo0027Ool00`00Oomoo`2IOol00`0OOomo
o`04Ool00`0OOomoo`0kOol008Moo`03001oogoo09Uoo`0301moogoo00Aoo`0301moogoo03]oo`00
Qgoo00<007ooOol0VGoo00<07gooOol017oo00<07gooOol0>goo0027Ool2002JOol00`0OOomoo`05
Ool00`0OOomoo`0jOol008Moo`03001oogoo09Uoo`0301moogoo00Eoo`0301moogoo03Yoo`00Qgoo
00<007ooOol0VGoo00<07gooOol01Woo00<07gooOol0>Goo0027Ool00`00Oomoo`2IOol00`0OOomo
o`06Ool00`0OOomoo`0iOol008Moo`03001oogoo09Uoo`0301moogoo00Moo`0301moogoo03Qoo`00
37oo0`009Woo1@009Goo1@008goo00<007ooOol097oo1@0097oo1@009Goo0`007goo00<07gooOol0
1Woo00<0000O00009Goo100047oo000;Ool01@00Oomoogoo00009Goo00D007ooOomoo`0002Moo`03
001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Aoo`05001oogooOol0000TOol01@00Oomoogoo
00007Woo00<07gooOol01goo00<0000OOol08goo00<007ooOol00Woo00<007ooOol03Goo000?Ool0
0`00Oomoo`0TOol00`00Oomoo`0XOol00`00Oomoo`0SOol2000WOol00`00Oomoo`0UOol00`00Oomo
o`0YOol00`00Oomoo`0LOol00`0OOomoo`07Ool00`0001moo`0XOol00`00Oomoo`0=Ool000=oo`H0
00Ioo`03001oogoo01]oo`H000Aoo`03001oogoo01aoo`H000Eoo`03001oogoo02=oo`03001oogoo
02Ioo`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo01aoo`0301moogoo00=oo`H0000301mo
ogoo02Ioo`03001oogoo00eoo`003Goo0P00:Goo00<007ooOol09Woo00<007ooOol08goo00<007oo
Ool09Woo00<007ooOol09goo00<007ooOol09Goo0P007goo00<07gooOol017oo00@007ooOol0009o
o`0301moogoo025oo`@0011oo`003goo00<007ooOol09goo00<007ooOol09Goo00<007ooOol08goo
00<007ooOol09Woo00<007ooOol0:7oo00<007ooOol09Woo00<007ooOol077oo00<07gooOol017oo
00@007ooOol000=oo`807b5oo`03001oogoo015oo`002goo00D007ooOomoo`0002Eoo`05001oogoo
Ool0000UOol3000UOol00`00Oomoo`0TOol3000VOol01@00Oomoogoo000097oo00D007ooOomoo`00
01ioo`0301moogoo00Eoo`03001oo`0000Eoo`0301moogoo01ioo`03001oogoo015oo`0037oo0`00
9goo0`00:7oo00<007ooOol08goo00<007ooOol09Woo00<007ooOol09Goo0`009Woo0`007goo00<0
7gooOol01Woo0P001Woo0`0O7Goo1@003goo0027Ool2002JOol00`0OOomoo`0AOol301l^Ool008Mo
o`03001oogoo09Uoo`0301moogoo01Aoo`@07bYoo`00Qgoo00<007ooOol0VGoo00<07gooOol067oo
0`0O9goo0027Ool00`00Oomoo`2IOol00`0OOomoo`0KOol<01lKOol008Moo`03001oogoo09Uoo`03
01moogoo02Moo`X07a5oo`00Qgoo00<007ooOol0VGoo00<07gooOol0@Woo0027Ool00`00Oomoo`2I
Ool00`0OOomoo`12Ool000Yoool001X0000301l000000340015oo`002Woo[@0O00=oo`00Ool01goo
00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo
00<007ooOol01Goo00<007ooOol017oo00<07`00Ool01Woo00<007ooOol01Woo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol02Woo1@00000:Ool00`00
Oomoo`0WOol00`00Oomoo`0VOol00`00Oomoo`0WOol00`00Oomoo`0VOol00`00Oomoo`04OolZ01lR
Ool00`00Oomoo`0MOol00`0OOomoo`06Ool00`00Oomoo`0WOol00`00Oomoo`0:Ool01000Oomoogoo
0@000027Ool00`00Oomoo`1GOolG01l[Ool00`0OOomoo`0nOol00`00Oomoo`01Ool008Moo`03001o
ogoo06ioo`/07b1oo`0301moogoo03moo`40005oo`5oo`00Qgoo00<007ooOol0NGoo1`0O6Goo00<0
7gooOol0?Goo00@007ooOol0005oo`00Qgoo00<007ooOol0P7oo0`0O5Woo00<07gooOol0?Goo1@00
0027Ool20024Ool301lCOol00`0OOomoo`12Ool008Moo`03001oogoo08Ioo`807a5oo`0301moogoo
049oo`00Qgoo00<007ooOol0R7oo0P0O3goo00<07gooOol0@Woo0027Ool00`00Oomoo`2:Ool00`0O
Oomoo`0<Ool00`0OOomoo`12Ool008Moo`03001oogoo08]oo`807`aoo`0301moogoo049oo`00Qgoo
00<007ooOol0SGoo0P0O2Woo00<07gooOol0@Woo0027Ool00`00Oomoo`2?Ool00`0OOomoo`07Ool0
0`0OOomoo`12Ool008Moo`80091oo`0301moogoo00Moo`0301moogoo049oo`00Qgoo00<007ooOol0
T7oo00<07gooOol01Woo00<07gooOol0@Woo0027Ool00`00Oomoo`2@Ool00`0OOomoo`06Ool00`0O
Oomoo`12Ool008Moo`03001oogoo095oo`0301moogoo00Eoo`0301moogoo049oo`00Qgoo00<007oo
Ool0TGoo00<07gooOol01Goo00<07gooOol0@Woo0027Ool00`00Oomoo`2BOol00`0OOomoo`04Ool0
0`0OOomoo`12Ool008Moo`03001oogoo099oo`0301moogoo00Aoo`0301moogoo049oo`00Qgoo0P00
Tgoo00<07gooOol017oo00<07gooOol0@Woo0027Ool00`00Oomoo`2COol00`0OOomoo`03Ool00`0O
Oomoo`12Ool008Moo`03001oogoo09=oo`0301moogoo00=oo`0301moogoo049oo`00Qgoo00<007oo
Ool0Tgoo00<07gooOol00goo00<07gooOol0@Woo0027Ool00`00Oomoo`2DOol00`0OOomoo`02Ool0
0`0OOomoo`12Ool008Moo`03001oogoo09Aoo`0301moogoo009oo`0301moogoo049oo`00Qgoo00<0
07ooOol0U7oo00<07gooOol00Woo00<07gooOol0@Woo0027Ool2002EOol00`0OOomoo`02Ool00`0O
Oomoo`12Ool008Moo`03001oogoo09Eoo`0501moogooOol07`14Ool008Moo`03001oogoo09Eoo`05
01moogooOol07`14Ool007eoo`D000Eoo`03001oogoo09Eoo`0501moogooOol07`14Ool007moo`03
001oogoo00Eoo`03001oogoo09Eoo`0501moogooOol07`14Ool007moo`03001oogoo00Eoo`03001o
ogoo09Eoo`0501moogooOol07`14Ool007moo`03001oogoo00Eoo`<009Eoo`0501moogooOol07`14
Ool007moo`03001oogoo00Eoo`03001oogoo09Eoo`0501moogooOol07`14Ool007moo`03001oogoo
00Eoo`03001oogoo09Ioo`0401moogoo01m4Ool007eoo`<000Moo`03001oogoo09Ioo`0401moogoo
01m4Ool007moo`03001oogoo00Eoo`03001oogoo09Ioo`0401moogoo01m4Ool008Moo`03001oogoo
09Ioo`0401moogoo01m4Ool008Moo`03001oogoo09Ioo`0401moogoo01m4Ool008Moo`8009Moo`04
01moogoo01m4Ool008Moo`03001oogoo09Ioo`0401moogoo01m4Ool008Moo`03001oogoo09Ioo`04
01moogoo01m4Ool008Moo`03001oogoo09Ioo`0401moogoo01m4Ool008Moo`03001oogoo09Ioo`04
01moogoo01m4Ool008Moo`03001oogoo09Ioo`0401moogoo01m4Ool008Moo`03001oogoo09Ioo`04
01moogoo01m4Ool008Moo`8009Moo`0401moogoo01m4Ool008Moo`03001oogoo09Ioo`0401moogoo
01m4Ool008Moo`03001oogoo09Ioo`0401moogoo01m4Ool008Moo`03001oogoo09Ioo`0401moogoo
01m4Ool008Moo`03001oogoo09Ioo`0401moogoo01m4Ool008Moo`03001oogoo09Ioo`0401moogoo
01m4Ool008Moo`03001oogoo09Moo`0301moo`0O04Aoo`00Qgoo0P00V7oo00<07goo01l0A7oo0027
Ool00`00Oomoo`2GOol00`0OOol07`14Ool008Moo`03001oogoo09Moo`0301moo`0O04Aoo`00Qgoo
00<007ooOol0Ugoo00<07goo01l0A7oo0027Ool00`00Oomoo`2GOol00`0OOol07`14Ool008Moo`03
001oogoo09Moo`0301moo`0O04Aoo`00Qgoo00<007ooOol0Ugoo00<07goo01l0A7oo0027Ool2002H
Ool00`0OOol07`14Ool008Moo`03001oogoo09Moo`0301moo`0O04Aoo`00Qgoo00<007ooOol0Ugoo
00<07goo01l0A7oo0027Ool00`00Oomoo`2GOol00`0OOol07`14Ool007aoo`D000Ioo`03001oogoo
09Moo`0301moo`0O04Aoo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo09Moo`0301moo`0O04Ao
o`00OGoo00<007ooOol01goo00<007ooOol0Ugoo00<07goo01l0A7oo001nOol00`00Oomoo`06Ool3
002GOol00`0OOol07`14Ool007moo`03001oogoo00Eoo`03001oogoo09Moo`0301moo`0O04Aoo`00
P7oo00<007ooOol017oo00<007ooOol0Ugoo00<07goo01l0A7oo001lOol01@00Oomoogoo00001Woo
00<007ooOol0Ugoo00<07goo01l0A7oo001mOol30007Ool00`00Oomoo`2GOol00`0OOol07`14Ool0
08Moo`03001oogoo09Moo`0301moo`0O04Aoo`00Qgoo0P00V7oo00<07goo01l0A7oo0027Ool00`00
Oomoo`2GOol00`0OOol07`14Ool008Moo`03001oogoo09Qoo`807dAoo`00Qgoo00<007ooOol0V7oo
0P0OA7oo0027Ool00`00Oomoo`2HOol201m4Ool008Moo`03001oogoo09Qoo`807dAoo`00Qgoo00<0
07ooOol0V7oo0P0OA7oo0027Ool2002IOol201m4Ool008Moo`03001oogoo09Qoo`807dAoo`00Qgoo
00<007ooOol0V7oo0P0OA7oo0027Ool00`00Oomoo`2HOol201m4Ool008Moo`03001oogoo09Qoo`80
7dAoo`00Qgoo00<007ooOol0V7oo0P0OA7oo0027Ool00`00Oomoo`2HOol201m4Ool008Moo`8009Uo
o`807dAoo`00Qgoo00<007ooOol0V7oo0P0OA7oo0027Ool00`00Oomoo`2HOol201m4Ool008Moo`03
001oogoo09Qoo`807dAoo`00Qgoo00<007ooOol0V7oo0P0OA7oo0027Ool00`00Oomoo`2HOol201m4
Ool008Moo`03001oogoo09Qoo`807dAoo`00Qgoo0P00VGoo0P0OA7oo0027Ool00`00Oomoo`2HOol2
01m4Ool008Moo`03001oogoo09Qoo`807dAoo`00Qgoo00<007ooOol0V7oo0P0OA7oo001mOol30007
Ool00`00Oomoo`2HOol201m4Ool007aoo`05001oogooOol00006Ool00`00Oomoo`2HOol201m4Ool0
081oo`03001oogoo00Aoo`03001oogoo09Qoo`807dAoo`00P7oo00<007ooOol017oo0`00V7oo0P0O
A7oo001nOol2003XOol0081oo`03001oogoo0>Eoo`00O7oo00D007ooOomoo`000>Moo`00OGoo0`00
j7oo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00R7oo0`0000Aoo`000000
0=Uoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.125 0.309017 0.103006 [
[0 .29652 -6 -9 ]
[0 .29652 6 0 ]
[.125 .29652 -6 -9 ]
[.125 .29652 6 0 ]
[.25 .29652 -6 -9 ]
[.25 .29652 6 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.625 .29652 -3 -9 ]
[.625 .29652 3 0 ]
[.75 .29652 -3 -9 ]
[.75 .29652 3 0 ]
[.875 .29652 -3 -9 ]
[.875 .29652 3 0 ]
[1 .29652 -3 -9 ]
[1 .29652 3 0 ]
[1.025 .30902 0 -1 ]
[1.025 .30902 4 1 ]
[.3625 0 -12 -4.5 ]
[.3625 0 0 4.5 ]
[.3625 .10301 -12 -4.5 ]
[.3625 .10301 0 4.5 ]
[.3625 .20601 -12 -4.5 ]
[.3625 .20601 0 4.5 ]
[.3625 .41202 -6 -4.5 ]
[.3625 .41202 0 4.5 ]
[.3625 .51503 -6 -4.5 ]
[.3625 .51503 0 4.5 ]
[.3625 .61803 -6 -4.5 ]
[.3625 .61803 0 4.5 ]
[.375 .64303 -2 0 ]
[.375 .64303 2 2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-3)] 0 .29652 0 1 Mshowa
.125 .30902 m
.125 .31527 L
s
[(-2)] .125 .29652 0 1 Mshowa
.25 .30902 m
.25 .31527 L
s
[(-1)] .25 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.625 .30902 m
.625 .31527 L
s
[(2)] .625 .29652 0 1 Mshowa
.75 .30902 m
.75 .31527 L
s
[(3)] .75 .29652 0 1 Mshowa
.875 .30902 m
.875 .31527 L
s
[(4)] .875 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.025 .30902 m
.025 .31277 L
s
.05 .30902 m
.05 .31277 L
s
.075 .30902 m
.075 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.15 .30902 m
.15 .31277 L
s
.175 .30902 m
.175 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.225 .30902 m
.225 .31277 L
s
.275 .30902 m
.275 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.325 .30902 m
.325 .31277 L
s
.35 .30902 m
.35 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.425 .30902 m
.425 .31277 L
s
.45 .30902 m
.45 .31277 L
s
.475 .30902 m
.475 .31277 L
s
.525 .30902 m
.525 .31277 L
s
.55 .30902 m
.55 .31277 L
s
.575 .30902 m
.575 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.65 .30902 m
.65 .31277 L
s
.675 .30902 m
.675 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.725 .30902 m
.725 .31277 L
s
.775 .30902 m
.775 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.825 .30902 m
.825 .31277 L
s
.85 .30902 m
.85 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.925 .30902 m
.925 .31277 L
s
.95 .30902 m
.95 .31277 L
s
.975 .30902 m
.975 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.375 0 m
.38125 0 L
s
[(-3)] .3625 0 1 0 Mshowa
.375 .10301 m
.38125 .10301 L
s
[(-2)] .3625 .10301 1 0 Mshowa
.375 .20601 m
.38125 .20601 L
s
[(-1)] .3625 .20601 1 0 Mshowa
.375 .41202 m
.38125 .41202 L
s
[(1)] .3625 .41202 1 0 Mshowa
.375 .51503 m
.38125 .51503 L
s
[(2)] .3625 .51503 1 0 Mshowa
.375 .61803 m
.38125 .61803 L
s
[(3)] .3625 .61803 1 0 Mshowa
.125 Mabswid
.375 .0206 m
.37875 .0206 L
s
.375 .0412 m
.37875 .0412 L
s
.375 .0618 m
.37875 .0618 L
s
.375 .0824 m
.37875 .0824 L
s
.375 .12361 m
.37875 .12361 L
s
.375 .14421 m
.37875 .14421 L
s
.375 .16481 m
.37875 .16481 L
s
.375 .18541 m
.37875 .18541 L
s
.375 .22661 m
.37875 .22661 L
s
.375 .24721 m
.37875 .24721 L
s
.375 .26781 m
.37875 .26781 L
s
.375 .28842 m
.37875 .28842 L
s
.375 .32962 m
.37875 .32962 L
s
.375 .35022 m
.37875 .35022 L
s
.375 .37082 m
.37875 .37082 L
s
.375 .39142 m
.37875 .39142 L
s
.375 .43262 m
.37875 .43262 L
s
.375 .45322 m
.37875 .45322 L
s
.375 .47383 m
.37875 .47383 L
s
.375 .49443 m
.37875 .49443 L
s
.375 .53563 m
.37875 .53563 L
s
.375 .55623 m
.37875 .55623 L
s
.375 .57683 m
.37875 .57683 L
s
.375 .59743 m
.37875 .59743 L
s
.25 Mabswid
.375 0 m
.375 .61803 L
s
gsave
.375 .64303 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 10 translate 1 -1 scale
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(h) show
63.000000 5.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
0 .31052 m
.04057 .31059 L
.08481 .31068 L
.12636 .31078 L
.16632 .31088 L
.20885 .31099 L
.2498 .31112 L
.29331 .31128 L
.33524 .31146 L
.37557 .31166 L
.41848 .31191 L
.4598 .3122 L
.49953 .31254 L
.54183 .31299 L
.58254 .31354 L
.62583 .31434 L
.64745 .31485 L
.66752 .31542 L
.68817 .31613 L
.70762 .31697 L
.72917 .31817 L
.74871 .31961 L
.75896 .32057 L
.76979 .32179 L
.78919 .32476 L
.79914 .32689 L
.80981 .32993 L
.81498 .3318 L
.81988 .33392 L
.82906 .33918 L
.83388 .34293 L
.83919 .34833 L
.84187 .35175 L
.84475 .35618 L
.84724 .36081 L
.84996 .36705 L
.85251 .37442 L
.85488 .38317 L
.85738 .39538 L
.85866 .40333 L
.86005 .4138 L
.86135 .42591 L
.86255 .43985 L
.86369 .45667 L
.8649 .47995 L
.86598 .50803 L
.867 .54418 L
.86811 .6027 L
s
.86811 .6027 m
.86828 .61803 L
s
.87264 .61803 m
.87285 0 L
s
.87692 0 m
.87731 .03186 L
.87867 .09369 L
.87994 .13076 L
.88066 .14668 L
.88145 .16103 L
.88287 .18152 L
.88426 .19666 L
.88554 .20777 L
.88845 .22633 L
.88992 .23333 L
.89154 .23979 L
.8941 .24802 L
.89678 .25479 L
.89973 .26068 L
.90243 .26505 L
.90731 .27123 L
.91265 .27626 L
.91821 .28026 L
.92346 .28322 L
.93328 .28739 L
.94385 .2906 L
.95529 .29315 L
.96525 .29485 L
.9762 .29635 L
.99831 .29858 L
1 .29872 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.160878,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00OGoo0`00j7oo001lOol01@00Oomoogoo0000igoo0020Ool00`00Oomoo`3UOol0
07Aoo`H000Ioo`03001oogoo00Aoo`<00:9oo`807cYoo`00OWoo0P001goo00<007ooOol0XWoo0P0O
>Woo0020Ool00`00Oomoo`04Ool00`00Oomoo`2ROol201ljOol007aoo`05001oogooOol00006Ool0
0`00Oomoo`2ROol201ljOol007eoo`<000Moo`03001oogoo0:9oo`807cYoo`00Qgoo00<007ooOol0
XWoo0P0O>Woo0027Ool00`00Oomoo`2ROol201ljOol008Moo`800:=oo`807cYoo`00Qgoo00<007oo
Ool0XWoo0P0O>Woo0027Ool00`00Oomoo`2ROol201ljOol008Moo`03001oogoo0:9oo`807cYoo`00
Qgoo00<007ooOol0XWoo0P0O>Woo0027Ool00`00Oomoo`2ROol201ljOol008Moo`800:=oo`807cYo
o`00Qgoo00<007ooOol0XWoo0P0O>Woo0027Ool00`00Oomoo`2ROol201ljOol008Moo`03001oogoo
0:9oo`807cYoo`00Qgoo00<007ooOol0XWoo0P0O>Woo0027Ool00`00Oomoo`2ROol201ljOol008Mo
o`03001oogoo0:9oo`807cYoo`00Qgoo0P00Xgoo0P0O>Woo0027Ool00`00Oomoo`2ROol00`0OOol0
7`0iOol008Moo`03001oogoo0:9oo`0301moo`0O03Uoo`00Qgoo00<007ooOol0XWoo00<07goo01l0
>Goo0027Ool00`00Oomoo`2ROol00`0OOol07`0iOol008Moo`03001oogoo0:9oo`0301moo`0O03Uo
o`00Qgoo00<007ooOol0XWoo00<07goo01l0>Goo0027Ool2002SOol00`0OOol07`0iOol008Moo`03
001oogoo0:9oo`0301moo`0O03Uoo`00Qgoo00<007ooOol0XWoo00<07goo01l0>Goo0027Ool00`00
Oomoo`2ROol00`0OOol07`0iOol007aoo`D000Ioo`03001oogoo0:9oo`0301moo`0O03Uoo`00O7oo
00D007ooOomoo`0000Ioo`03001oogoo0:9oo`0301moo`0O03Uoo`00OGoo00<007ooOol01goo00<0
07ooOol0XWoo00<07goo01l0>Goo001dOol60004Ool00`00Oomoo`06Ool3002ROol00`0OOol07`0i
Ool007moo`03001oogoo00Eoo`03001oogoo0:9oo`0301moo`0O03Uoo`00P7oo00<007ooOol017oo
00<007ooOol0XWoo00<07goo01l0>Goo001lOol01@00Oomoogoo00001Woo00<007ooOol0XWoo00<0
7goo01l0>Goo001mOol30007Ool00`00Oomoo`2ROol00`0OOol07`0iOol008Moo`03001oogoo0:9o
o`0301moo`0O03Uoo`00Qgoo00<007ooOol0XWoo00<07goo01l0>Goo0027Ool2002SOol00`0OOol0
7`0iOol008Moo`03001oogoo0:9oo`0301moo`0O03Uoo`00Qgoo00<007ooOol0XWoo00<07goo01l0
>Goo0027Ool00`00Oomoo`2ROol00`0OOol07`0iOol008Moo`03001oogoo0:9oo`0301moo`0O03Uo
o`00Qgoo00<007ooOol0XWoo00<07goo01l0>Goo0027Ool00`00Oomoo`2ROol00`0OOol07`0iOol0
08Moo`800:=oo`0301moo`0O03Uoo`00Qgoo00<007ooOol0XWoo00<07goo01l0>Goo0027Ool00`00
Oomoo`2ROol00`0OOol07`0iOol008Moo`03001oogoo0:9oo`0401moogoo01lhOol008Moo`03001o
ogoo0:9oo`0401moogoo01lhOol008Moo`03001oogoo0:9oo`0401moogoo01lhOol008Moo`800:=o
o`0401moogoo01lhOol008Moo`03001oogoo0:9oo`0401moogoo01lhOol008Moo`03001oogoo0:9o
o`0401moogoo01lhOol008Moo`03001oogoo0:9oo`0401moogoo01lhOol008Moo`03001oogoo0:9o
o`0401moogoo01lhOol008Moo`03001oogoo0:9oo`0401moogoo01lhOol008Moo`03001oogoo0:9o
o`0401moogoo01lhOol008Moo`800:=oo`0401moogoo01lhOol008Moo`03001oogoo0:9oo`0401mo
ogoo01lhOol008Moo`03001oogoo0:9oo`0501moogooOol07`0gOol008Moo`03001oogoo0:9oo`05
01moogooOol07`0gOol007eoo`D000Eoo`03001oogoo0:9oo`0501moogooOol07`0gOol007moo`03
001oogoo00Eoo`03001oogoo0:9oo`0501moogooOol07`0gOol007moo`03001oogoo00Eoo`03001o
ogoo0:9oo`0501moogooOol07`0gOol007Aoo`H000Eoo`03001oogoo00Eoo`<00:9oo`0501moogoo
Ool07`0gOol007moo`03001oogoo00Eoo`03001oogoo0:9oo`0501moogooOol07`0gOol007moo`03
001oogoo00Eoo`03001oogoo0:9oo`0501moogooOol07`0gOol007eoo`<000Moo`03001oogoo0:9o
o`0501moogooOol07`0gOol007moo`03001oogoo00Eoo`03001oogoo0:9oo`0301moogoo009oo`03
01moogoo03Aoo`00Qgoo00<007ooOol0XWoo00<07gooOol00Woo00<07gooOol0=7oo0027Ool00`00
Oomoo`2ROol00`0OOomoo`02Ool00`0OOomoo`0dOol008Moo`800:=oo`0301moogoo009oo`0301mo
ogoo03Aoo`00Qgoo00<007ooOol0XWoo00<07gooOol00Woo00<07gooOol0=7oo0027Ool00`00Oomo
o`2ROol00`0OOomoo`02Ool00`0OOomoo`0dOol008Moo`03001oogoo0:9oo`0301moogoo00=oo`03
01moogoo03=oo`00Qgoo00<007ooOol0XWoo00<07gooOol00goo00<07gooOol0<goo0027Ool00`00
Oomoo`2ROol00`0OOomoo`03Ool00`0OOomoo`0cOol008Moo`03001oogoo0:9oo`0301moogoo00Ao
o`0301moogoo039oo`00Qgoo0P00Xgoo00<07gooOol017oo00<07gooOol0<Woo0027Ool00`00Oomo
o`2ROol00`0OOomoo`05Ool00`0OOomoo`0aOol008Moo`03001oogoo0:9oo`0301moogoo00Eoo`03
01moogoo035oo`00Qgoo00<007ooOol0XWoo00<07gooOol01Woo00<07gooOol0<7oo0027Ool00`00
Oomoo`2ROol00`0OOomoo`06Ool00`0OOomoo`0`Ool000aoo`<002Ioo`D002Eoo`D002=oo`03001o
ogoo02Aoo`D002Aoo`D002Eoo`<002Qoo`0301l0000000Moo`0301moogoo01]oo`@0011oo`002goo
00D007ooOomoo`0002Eoo`05001oogooOol0000WOol00`00Oomoo`0SOol00`00Oomoo`0VOol00`00
Oomoo`0TOol01@00Oomoogoo000097oo00D007ooOomoo`0002Moo`0301l007oo00Moo`0301moogoo
01Yoo`03001oogoo009oo`03001oogoo00eoo`003goo00<007ooOol097oo00<007ooOol0:7oo00<0
07ooOol08goo0P009goo00<007ooOol09Goo00<007ooOol0:Goo00<007ooOol09Goo00<07`00Ool0
27oo00<07gooOol07Woo00<007ooOol03Goo0003Ool60006Ool00`00Oomoo`0KOol60004Ool00`00
Oomoo`0LOol60005Ool00`00Oomoo`0SOol00`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0X
Ool00`00Oomoo`0ROol300000`0O00000008Ool00`0OOomoo`0NOol00`00Oomoo`0=Ool000eoo`80
02Uoo`03001oogoo02Ioo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Moo`03001oogoo
02Eoo`8002Ioo`04001oo`0O000:Ool201lJOol4000@Ool000moo`03001oogoo02Moo`03001oogoo
02Eoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Qoo`03001oogoo02Ioo`03001oogoo
02=oo`04001oo`0O000<Ool00`0OOomoo`0GOol00`00Oomoo`0AOol000]oo`05001oogooOol0000U
Ool01@00Oomoogoo00009Goo0`009Goo00<007ooOol097oo0`009Woo00D007ooOomoo`0002Aoo`05
001oogooOol0000VOol00`0001l0000=Ool00`0OOomoo`0FOol00`00Oomoo`0AOol000aoo`<002Mo
o`<002Qoo`03001oogoo02=oo`03001oogoo02Ioo`03001oogoo02Eoo`<002Ioo`<002Qoo`0301l0
07oo00eoo`<07aEoo`D000moo`00Qgoo0P00Xgoo00<07gooOol047oo0`0O9Woo0027Ool00`00Oomo
o`2ROol00`0OOomoo`0COol301lSOol008Moo`03001oogoo0:9oo`0301moogoo01Ioo`@07amoo`00
Qgoo00<007ooOol0XWoo00<07gooOol06Woo2@0O5Woo0027Ool00`00Oomoo`2ROol00`0OOomoo`0S
Ool501lAOol008Moo`03001oogoo0:9oo`0301moogoo03Uoo`00Qgoo00<007ooOol0XWoo00<07goo
Ool0>Goo000:Oooo000S00000`0O0000000X000AOol000Yoojd07`03Ool007oo00Moo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`0301moogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Yoo`D000002Woo00<007ooOol09goo
00<007ooOol09Woo00<007ooOol09goo00<007ooOol09Woo00<007ooOol017oo=@0O5goo00<007oo
Ool09Woo00<07gooOol09goo00<007ooOol02Woo00@007ooOomoo`400000Qgoo00<007ooOol0HWoo
500O;7oo00<07gooOol0=Goo00<007ooOol00Goo0027Ool00`00Oomoo`1fOol=01lOOol00`0OOomo
o`0fOol10001Ool1Ool008Moo`03001oogoo08=oo`D07aYoo`0301moogoo03Aoo`04001oogoo0001
Ool008Moo`03001oogoo08Qoo`<07aMoo`0301moogoo03Aoo`D00000Qgoo0P00S7oo0`0O57oo00<0
7gooOol0>Goo0027Ool00`00Oomoo`2>Ool301lAOol00`0OOomoo`0iOol008Moo`03001oogoo095o
o`807`moo`0301moogoo03Uoo`00Qgoo00<007ooOol0Tgoo00<07gooOol037oo00<07gooOol0>Goo
0027Ool00`00Oomoo`2DOol201l<Ool00`0OOomoo`0iOol008Moo`03001oogoo09Ioo`0301moogoo
00Uoo`0301moogoo03Uoo`00Qgoo00<007ooOol0Ugoo00<07gooOol027oo00<07gooOol0>Goo0027
Ool2002HOol00`0OOomoo`08Ool00`0OOomoo`0iOol008Moo`03001oogoo09Qoo`0301moogoo00Mo
o`0301moogoo03Uoo`00Qgoo00<007ooOol0V7oo00<07gooOol01goo00<07gooOol0>Goo0027Ool0
0`00Oomoo`2IOol00`0OOomoo`06Ool00`0OOomoo`0iOol008Moo`03001oogoo09Yoo`0301moogoo
00Eoo`0301moogoo03Uoo`00Qgoo00<007ooOol0VWoo00<07gooOol01Goo00<07gooOol0>Goo0027
Ool00`00Oomoo`2JOol00`0OOomoo`05Ool00`0OOomoo`0iOol008Moo`8009aoo`0301moogoo00Ao
o`0301moogoo03Uoo`00Qgoo00<007ooOol0Vgoo00<07gooOol017oo00<07gooOol0>Goo0027Ool0
0`00Oomoo`2KOol00`0OOomoo`04Ool00`0OOomoo`0iOol008Moo`03001oogoo09aoo`0301moogoo
00=oo`0301moogoo03Uoo`00Qgoo00<007ooOol0W7oo00<07gooOol00goo00<07gooOol0>Goo0027
Ool00`00Oomoo`2LOol00`0OOomoo`03Ool00`0OOomoo`0iOol008Moo`03001oogoo09eoo`0301mo
ogoo009oo`0301moogoo03Uoo`00Qgoo0P00WWoo00<07gooOol00Woo00<07gooOol0>Goo0027Ool0
0`00Oomoo`2MOol00`0OOomoo`02Ool00`0OOomoo`0iOol008Moo`03001oogoo09eoo`0301moogoo
009oo`0301moogoo03Uoo`00OGoo1@001Goo00<007ooOol0WGoo00<07gooOol00Woo00<07gooOol0
>Goo001oOol00`00Oomoo`05Ool00`00Oomoo`2MOol00`0OOomoo`02Ool00`0OOomoo`0iOol007mo
o`03001oogoo00Eoo`03001oogoo09eoo`0301moogoo009oo`0301moogoo03Uoo`00Ogoo00<007oo
Ool01Goo0`00WWoo00D07gooOomoo`0O03]oo`00Ogoo00<007ooOol01Goo00<007ooOol0WWoo00D0
7gooOomoo`0O03]oo`00Ogoo00<007ooOol01Goo00<007ooOol0WWoo00D07gooOomoo`0O03]oo`00
OGoo0`001goo00<007ooOol0WWoo00D07gooOomoo`0O03]oo`00Ogoo00<007ooOol01Goo00<007oo
Ool0WWoo00D07gooOomoo`0O03]oo`00Qgoo00<007ooOol0WWoo00D07gooOomoo`0O03]oo`00Qgoo
00<007ooOol0WWoo00D07gooOomoo`0O03]oo`00Qgoo0P00Wgoo00D07gooOomoo`0O03]oo`00Qgoo
00<007ooOol0WWoo00D07gooOomoo`0O03]oo`00Qgoo00<007ooOol0WWoo00D07gooOomoo`0O03]o
o`00Qgoo00<007ooOol0WWoo00D07gooOomoo`0O03]oo`00Qgoo00<007ooOol0WWoo00D07gooOomo
o`0O03]oo`00Qgoo00<007ooOol0WWoo00D07gooOomoo`0O03]oo`00Qgoo00<007ooOol0Wgoo00@0
7gooOol07c]oo`00Qgoo0P00X7oo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol0
7c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol0
7c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol0
7c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00Qgoo0P00X7oo00@07gooOol07c]oo`00
Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00
Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00
Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00
Qgoo0P00X7oo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00Qgoo00<0
07ooOol0Wgoo00@07gooOol07c]oo`00Qgoo00<007ooOol0Wgoo00@07gooOol07c]oo`00O7oo1@00
1Woo00<007ooOol0Wgoo00@07gooOol07c]oo`00O7oo00D007ooOomoo`0000Ioo`03001oogoo09mo
o`0401moogoo01lkOol007eoo`03001oogoo00Moo`03001oogoo09moo`0401moogoo01lkOol007io
o`03001oogoo00Ioo`<009moo`0401moogoo01lkOol007moo`03001oogoo00Eoo`03001oogoo09mo
o`0401moogoo01lkOol0081oo`03001oogoo00Aoo`03001oogoo09moo`0401moogoo01lkOol007ao
o`05001oogooOol00006Ool00`00Oomoo`2POol00`0OOol07`0kOol007eoo`<000Moo`03001oogoo
0:1oo`0301moo`0O03]oo`00Qgoo00<007ooOol0X7oo00<07goo01l0>goo0027Ool2002QOol00`0O
Ool07`0kOol008Moo`03001oogoo0:1oo`0301moo`0O03]oo`00Qgoo00<007ooOol0X7oo00<07goo
01l0>goo0027Ool00`00Oomoo`2POol00`0OOol07`0kOol008Moo`03001oogoo0:1oo`0301moo`0O
03]oo`00Qgoo00<007ooOol0X7oo00<07goo01l0>goo0027Ool00`00Oomoo`2POol00`0OOol07`0k
Ool008Moo`800:5oo`0301moo`0O03]oo`00Qgoo00<007ooOol0X7oo00<07goo01l0>goo0027Ool0
0`00Oomoo`2POol00`0OOol07`0kOol008Moo`03001oogoo0:1oo`0301moo`0O03]oo`00Qgoo00<0
07ooOol0X7oo00<07goo01l0>goo0027Ool00`00Oomoo`2POol00`0OOol07`0kOol008Moo`03001o
ogoo0:1oo`0301moo`0O03]oo`00Qgoo0P00XGoo00<07goo01l0>goo0027Ool00`00Oomoo`2POol0
0`0OOol07`0kOol008Moo`03001oogoo0:1oo`0301moo`0O03]oo`00Qgoo00<007ooOol0X7oo00<0
7goo01l0>goo0027Ool00`00Oomoo`2POol00`0OOol07`0kOol008Moo`03001oogoo0:1oo`0301mo
o`0O03]oo`00Qgoo00<007ooOol0X7oo00<07goo01l0>goo0027Ool2002QOol00`0OOol07`0kOol0
08Moo`03001oogoo0:1oo`0301moo`0O03]oo`00Qgoo00<007ooOol0X7oo00<07goo01l0>goo0027
Ool00`00Oomoo`2POol00`0OOol07`0kOol007eoo`<000Moo`03001oogoo0:1oo`0301moo`0O03]o
o`00O7oo00D007ooOomoo`0000Ioo`03001oogoo0:1oo`0301moo`0O03]oo`00P7oo00<007ooOol0
17oo00<007ooOol0X7oo00<07goo01l0>goo0020Ool00`00Oomoo`04Ool3002POol00`0OOol07`0k
Ool007ioo`800>Qoo`00P7oo00<007ooOol0iGoo001lOol01@00Oomoogoo0000igoo001mOol3003X
Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo0028Ool3000017oo00000000
fGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-3.26028, -3.16469, \
0.0301541, 0.0365927}}]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "This sequence of pictures shows us that under a translation invariance of \
equations (5.74) and (5.75), a singularity of the height ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " of the fluid neck moves from the left to the right. It is essential that \
the singularity in ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " exist from the beginning to the end. The structure of the solution is not \
changed during the evolution in time. If we look at the analytic expression \
of the solution, we realize that gravity seems to be an essential component \
to create the singularity. To study the influence of the gravity constant \
\[Psi] on the solution, let us examine the simplified equations of motion \
without gravity. The reduced equations of motion are"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(modelWithoutGravity\  = \ simplifiedEggers\  /. \[Psi] \[Rule] 0; 
    modelWithoutGravity // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[Gamma]\)\ h\_z + h\^2\ \[Rho]\ v\_t + 
                h\^2\ v\ \[Rho]\ v\_z - 6\ h\ \[Eta]\ \[Rho]\ h\_z\ v\_z - 
                3\ h\^2\ \[Eta]\ \[Rho]\ v\_\(z, z\) == 0\)},
          {\(2\ h\_t + 2\ v\ h\_z + h\ v\_z == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The infinitesimals of this simplified model follow from", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf5 = 
      Infinitesimals[
        modelWithoutGravity, {v, h}, {z, t}, {\[Rho], \[Gamma], \[Eta]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_t V, \[PartialD]\_t\ H}]; 
    inf5 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k2 - k4\ v\)},
          {\(\[Phi]\_2 == 2\ h\ k4\)},
          {\(\[Xi]\_1 == k3 + k2\ t + k4\ z\)},
          {\(\[Xi]\_2 == k1 + 2\ k4\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k2, 
            Times[ -1, k4, v]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Times[ 2, h, k4]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k3, 
            Times[ k2, t], 
            Times[ k4, z]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 2, k4, t]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The four-dimensional symmetry transformation contains a scaling symmetry, \
translations in ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", and a special symmetry related to ",
  Cell[BoxData[
      FormBox[
        StyleBox["k2",
          FontSlant->"Italic"], TraditionalForm]]],
  ". Let us first examine the moving wave solution corresponding to the \
translational invariance. The related infinitesimals of the symmetry group \
are"
}], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi2\  = \ 
      \({{\(xi[1]\)[z, t, v, h], \(xi[2]\)[z, t, v, h]}, {
              \(phi[1]\)[z, t, v, h], \(phi[2]\)[z, t, v, h]}}\  /. inf5
          \)\  /. {k1 \[Rule] 1, k2 \[Rule] 0, k3 \[Rule] c, k4 \[Rule] 0}
          \)], "Input"],

Cell[BoxData[
    \({{c, 1}, {0, 0}}\)], "Output"]
}, Open  ]],

Cell["\<\
The reduction of the equations of motion without gravity follows \
from\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red2\  = \ 
      LieReduction[modelWithoutGravity, {v, h}, {z, t}, infi2[\([1]\)], 
        infi2[\([2]\)]]; 
    \((\(red2 // Flatten\) // LTF)\) /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(\(-c\)\ t + z\)\/c\),
                    ScriptLevel->0]}], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(v - F\_1 == 0\)},
          {\(h - F\_2 == 0\)},
          {
            \(c\^2\ \[Rho]\ F\_2\%2\ \((F\_1)\)\_\(\[Zeta]\_1\) - 
                c\ \[Rho]\ F\_1\ F\_2\%2\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                c\ \[Gamma]\ \((F\_2)\)\_\(\[Zeta]\_1\) - 
                6\ \[Eta]\ \[Rho]\ F\_2\ \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_2)\)\_\(\[Zeta]\_1\) - 
                3\ \[Eta]\ \[Rho]\ F\_2\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)},
          {
            \(\(-F\_2\)\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                2\ c\ \((F\_2)\)\_\(\[Zeta]\_1\) - 
                2\ F\_1\ \((F\_2)\)\_\(\[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We again realize that the second equation is solved with ",
  Cell[BoxData[
      \(TraditionalForm\`F1 = c\)]],
  ", meaning that the velocity field ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " is a constant. Inserting this solution into similarity reduction, we \
find"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red3\  = \ 
      red2\[LeftDoubleBracket]3\[RightDoubleBracket] /. 
        F1 \[Rule] Function[zeta1, c]; 
    \((red3 // LieTraditionalForm)\) /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \({c\ \[Gamma]\ F2\_\(\[Zeta]\_1\) == 0, True}\)], "Output"]
}, Open  ]],

Cell["The remaining first-order ODE is solved by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1\  = \ 
      DSolve[red3\[LeftDoubleBracket]1\[RightDoubleBracket], F2, zeta1]\)], 
  "Input"],

Cell[BoxData[
    \({{F2 \[Rule] \((C[1]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, the height of the fluid neck remains a constant during the \
evolution. The mathematical result in physical terms means that a column of \
fluid of height ",
  StyleBox["h ",
    FontSlant->"Italic"],
  "moving with a constant velocity ",
  StyleBox["a",
    FontSlant->"Italic"],
  " without any influence of gravity remains in the same initial state \
forever. Thus, the shape of the fluid column does not change. In conclusion, \
the singularity of ",
  StyleBox["h",
    FontSlant->"Italic"],
  " in the previous model is, in fact, generated by gravity. The examination \
of the other symmetry reductions are left as exercises for the reader."
}], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"RayleighParticle.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{657, 668},
WindowMargins->{{25, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->337,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Drop formation"->{
    Cell[1739, 51, 350, 5, 49, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 66}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Drop formation"]},
  "formation of drops"->{
    Cell[34942, 468, 205, 5, 54, "Text",
      CellTags->"formation of drops"]},
  "single drop"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "rain drops"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "drops"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "animation for a falling milk drop"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "animation of the formation of a water drop"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "drop formation"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "ink jet printer"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "chemical mixing processes"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "fuel injection"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "Navier-Stokes equation"->{
    Cell[229642, 2880, 1580, 30, 243, "Text",
      CellTags->{
      "single drop", "rain drops", "drops", 
        "animation for a falling milk drop", 
        "animation of the formation of a water drop", "drop formation", 
        "ink jet printer", "chemical mixing processes", "fuel injection", 
        "Navier-Stokes equation"}]},
  "kinematic viscosity"->{
    Cell[231225, 2912, 365, 5, 75, "Text",
      CellTags->{"kinematic viscosity", "surface tension"}],
    Cell[273053, 4541, 419, 9, 75, "Text",
      CellTags->{
      "density", "surface tension", "kinematic viscosity", 
        "Infinitesimals[]"}]},
  "surface tension"->{
    Cell[231225, 2912, 365, 5, 75, "Text",
      CellTags->{"kinematic viscosity", "surface tension"}],
    Cell[273053, 4541, 419, 9, 75, "Text",
      CellTags->{
      "density", "surface tension", "kinematic viscosity", 
        "Infinitesimals[]"}]},
  "velocity"->{
    Cell[232027, 2933, 594, 17, 75, "Text",
      CellTags->{"velocity", "pressure"}]},
  "pressure"->{
    Cell[232027, 2933, 594, 17, 75, "Text",
      CellTags->{"velocity", "pressure"}]},
  "boundary conditions"->{
    Cell[232718, 2955, 180, 4, 54, "Text",
      CellTags->"boundary conditions"]},
  "curvature"->{
    Cell[233223, 2973, 491, 16, 75, "Text",
      CellTags->"curvature"]},
  "differential geometry"->{
    Cell[233855, 2996, 743, 23, 96, "Text",
      CellTags->"differential geometry"]},
  "capillary pressure"->{
    Cell[268191, 4417, 307, 8, 54, "Text",
      CellTags->"capillary pressure"],
    Cell[275311, 4615, 277, 6, 54, "Text",
      CellTags->"capillary pressure"],
    Cell[280594, 4780, 486, 12, 96, "Text",
      CellTags->"capillary pressure"],
    Cell[286575, 4964, 482, 13, 96, "Text",
      CellTags->"capillary pressure"]},
  "velocity field"->{
    Cell[269479, 4452, 810, 18, 138, "Text",
      CellTags->{"velocity field", "similarity solutions"}]},
  "similarity solutions"->{
    Cell[269479, 4452, 810, 18, 138, "Text",
      CellTags->{"velocity field", "similarity solutions"}]},
  "liquid jet"->{
    Cell[270791, 4491, 97, 1, 33, "Text",
      CellTags->"liquid jet"]},
  "density"->{
    Cell[273053, 4541, 419, 9, 75, "Text",
      CellTags->{
      "density", "surface tension", "kinematic viscosity", 
        "Infinitesimals[]"}]},
  "Infinitesimals[]"->{
    Cell[273053, 4541, 419, 9, 75, "Text",
      CellTags->{
      "density", "surface tension", "kinematic viscosity", 
        "Infinitesimals[]"}]},
  "point group"->{
    Cell[274376, 4586, 932, 27, 138, "Text",
      CellTags->{"point group", "pinch of a drop"}]},
  "pinch of a drop"->{
    Cell[274376, 4586, 932, 27, 138, "Text",
      CellTags->{"point group", "pinch of a drop"}]},
  "Taylor expansion"->{
    Cell[276198, 4642, 628, 14, 117, "Text",
      CellTags->"Taylor expansion"]},
  "infinitesimals"->{
    Cell[279153, 4730, 199, 5, 54, "Text",
      CellTags->"infinitesimals"],
    Cell[283820, 4875, 122, 4, 33, "Text",
      CellTags->"infinitesimals"],
    Cell[768404, 20852, 566, 17, 96, "Text",
      CellTags->"infinitesimals"]},
  "Saffman-Taylor approximation"->{
    Cell[282155, 4831, 566, 11, 96, "Text",
      CellTags->{
      "Saffman-Taylor approximation", "lubrication approximation"}]},
  "lubrication approximation"->{
    Cell[282155, 4831, 566, 11, 96, "Text",
      CellTags->{
      "Saffman-Taylor approximation", "lubrication approximation"}]},
  "scaling solution"->{
    Cell[286041, 4951, 531, 11, 117, "Text",
      CellTags->{"scaling solution", "scaling transformation"}]},
  "scaling transformation"->{
    Cell[286041, 4951, 531, 11, 117, "Text",
      CellTags->{"scaling solution", "scaling transformation"}]},
  "symmetries"->{
    Cell[288238, 5017, 91, 1, 33, "Text",
      CellTags->"symmetries"]},
  "finite group"->{
    Cell[290458, 5090, 909, 28, 138, "Text",
      CellTags->"finite group"]},
  "similarity reduction"->{
    Cell[291737, 5133, 139, 4, 33, "Text",
      CellTags->"similarity reduction"]},
  "similarity solution"->{
    Cell[293284, 5179, 341, 6, 96, "Text",
      CellTags->"similarity solution"]},
  "fluid neck"->{
    Cell[294865, 5235, 496, 15, 54, "Text",
      CellTags->"fluid neck"]},
  "animation"->{
    Cell[295665, 5265, 599, 17, 96, "Text",
      CellTags->{"animation", "animation of the singularity movement"}]},
  "animation of the singularity movement"->{
    Cell[295665, 5265, 599, 17, 96, "Text",
      CellTags->{"animation", "animation of the singularity movement"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Drop formation", 774120, 21031},
  {"formation of drops", 774467, 21038},
  {"single drop", 774567, 21041},
  {"rain drops", 774925, 21049},
  {"drops", 775278, 21057},
  {"animation for a falling milk drop", 775659, 21065},
  {"animation of the formation of a water drop", 776049, 21073},
  {"drop formation", 776411, 21081},
  {"ink jet printer", 776774, 21089},
  {"chemical mixing processes", 777147, 21097},
  {"fuel injection", 777509, 21105},
  {"Navier-Stokes equation", 777879, 21113},
  {"kinematic viscosity", 778246, 21121},
  {"surface tension", 778525, 21128},
  {"velocity", 778797, 21135},
  {"pressure", 778901, 21138},
  {"boundary conditions", 779016, 21141},
  {"curvature", 779117, 21144},
  {"differential geometry", 779221, 21147},
  {"capillary pressure", 779334, 21150},
  {"velocity field", 779687, 21159},
  {"similarity solutions", 779822, 21162},
  {"liquid jet", 779947, 21165},
  {"density", 780036, 21168},
  {"Infinitesimals[]", 780212, 21173},
  {"point group", 780383, 21178},
  {"pinch of a drop", 780505, 21181},
  {"Taylor expansion", 780628, 21184},
  {"infinitesimals", 780733, 21187},
  {"Saffman-Taylor approximation", 781006, 21194},
  {"lubrication approximation", 781171, 21198},
  {"scaling solution", 781327, 21202},
  {"scaling transformation", 781468, 21205},
  {"symmetries", 781597, 21208},
  {"finite group", 781691, 21211},
  {"similarity reduction", 781798, 21214},
  {"similarity solution", 781910, 21217},
  {"fluid neck", 782012, 21220},
  {"animation", 782105, 21223},
  {"animation of the singularity movement", 782268, 21226}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 350, 5, 49, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 66}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Drop formation"],
Cell[2092, 58, 32847, 408, 120, 32751, 405, "GraphicsData", "Bitmap", \
"Graphics"],
Cell[34942, 468, 205, 5, 54, "Text",
  CellTags->"formation of drops"],
Cell[35150, 475, 194489, 2403, 254, 194358, 2400, "GraphicsData", "Bitmap", \
"Graphics"],
Cell[229642, 2880, 1580, 30, 243, "Text",
  CellTags->{
  "single drop", "rain drops", "drops", "animation for a falling milk drop", 
    "animation of the formation of a water drop", "drop formation", 
    "ink jet printer", "chemical mixing processes", "fuel injection", 
    "Navier-Stokes equation"}],
Cell[231225, 2912, 365, 5, 75, "Text",
  CellTags->{"kinematic viscosity", "surface tension"}],
Cell[231593, 2919, 223, 5, 44, "NumberedEquation"],
Cell[231819, 2926, 205, 5, 44, "NumberedEquation"],
Cell[232027, 2933, 594, 17, 75, "Text",
  CellTags->{"velocity", "pressure"}],
Cell[232624, 2952, 91, 1, 41, "NumberedEquation"],
Cell[232718, 2955, 180, 4, 54, "Text",
  CellTags->"boundary conditions"],
Cell[232901, 2961, 166, 3, 47, "NumberedEquation"],
Cell[233070, 2966, 19, 0, 33, "Text"],
Cell[233092, 2968, 128, 3, 30, "NumberedEquation"],
Cell[233223, 2973, 491, 16, 75, "Text",
  CellTags->"curvature"],
Cell[233717, 2991, 135, 3, 28, "NumberedEquation"],
Cell[233855, 2996, 743, 23, 96, "Text",
  CellTags->"differential geometry"],
Cell[234601, 3021, 33587, 1394, 280, 13180, 1136, "GraphicsData", \
"PostScript", "Graphics"],
Cell[268191, 4417, 307, 8, 54, "Text",
  CellTags->"capillary pressure"],
Cell[268501, 4427, 265, 5, 51, "NumberedEquation"],
Cell[268769, 4434, 410, 6, 117, "Text"],
Cell[269182, 4442, 184, 4, 50, "NumberedEquation"],
Cell[269369, 4448, 107, 2, 44, "NumberedEquation"],
Cell[269479, 4452, 810, 18, 138, "Text",
  CellTags->{"velocity field", "similarity solutions"}],
Cell[270292, 4472, 59, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[270376, 4477, 260, 6, 47, "Input"],
Cell[270639, 4485, 137, 3, 63, "Output"]
}, Open  ]],
Cell[270791, 4491, 97, 1, 33, "Text",
  CellTags->"liquid jet"],

Cell[CellGroupData[{
Cell[270913, 4496, 396, 8, 80, "Input"],
Cell[271312, 4506, 1726, 32, 221, "Output"]
}, Open  ]],
Cell[273053, 4541, 419, 9, 75, "Text",
  CellTags->{
  "density", "surface tension", "kinematic viscosity", "Infinitesimals[]"}],

Cell[CellGroupData[{
Cell[273497, 4554, 253, 6, 46, "Input"],
Cell[273753, 4562, 608, 21, 73, "Output"]
}, Open  ]],
Cell[274376, 4586, 932, 27, 138, "Text",
  CellTags->{"point group", "pinch of a drop"}],
Cell[275311, 4615, 277, 6, 54, "Text",
  CellTags->"capillary pressure"],

Cell[CellGroupData[{
Cell[275613, 4625, 359, 8, 67, "Input"],
Cell[275975, 4635, 208, 4, 63, "Output"]
}, Open  ]],
Cell[276198, 4642, 628, 14, 117, "Text",
  CellTags->"Taylor expansion"],

Cell[CellGroupData[{
Cell[276851, 4660, 130, 3, 27, "Input"],
Cell[276984, 4665, 647, 18, 42, "Output"]
}, Open  ]],
Cell[277646, 4686, 498, 13, 96, "Text"],

Cell[CellGroupData[{
Cell[278169, 4703, 397, 8, 80, "Input"],
Cell[278569, 4713, 569, 14, 67, "Output"]
}, Open  ]],
Cell[279153, 4730, 199, 5, 54, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[279377, 4739, 241, 6, 46, "Input"],
Cell[279621, 4747, 608, 21, 73, "Output"]
}, Open  ]],
Cell[280244, 4771, 347, 7, 75, "Text"],
Cell[280594, 4780, 486, 12, 96, "Text",
  CellTags->"capillary pressure"],

Cell[CellGroupData[{
Cell[281105, 4796, 363, 8, 67, "Input"],
Cell[281471, 4806, 204, 4, 63, "Output"]
}, Open  ]],
Cell[281690, 4813, 176, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[281891, 4822, 154, 3, 27, "Input"],
Cell[282048, 4827, 92, 1, 48, "Output"]
}, Open  ]],
Cell[282155, 4831, 566, 11, 96, "Text",
  CellTags->{"Saffman-Taylor approximation", "lubrication approximation"}],

Cell[CellGroupData[{
Cell[282746, 4846, 445, 9, 80, "Input"],
Cell[283194, 4857, 611, 15, 67, "Output"]
}, Open  ]],
Cell[283820, 4875, 122, 4, 33, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[283967, 4883, 239, 6, 46, "Input"],
Cell[284209, 4891, 1817, 57, 153, "Output"]
}, Open  ]],
Cell[286041, 4951, 531, 11, 117, "Text",
  CellTags->{"scaling solution", "scaling transformation"}],
Cell[286575, 4964, 482, 13, 96, "Text",
  CellTags->"capillary pressure"],

Cell[CellGroupData[{
Cell[287082, 4981, 92, 1, 27, "Input"],
Cell[287177, 4984, 51, 1, 42, "Output"]
}, Open  ]],
Cell[287243, 4988, 55, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[287323, 4992, 417, 8, 80, "Input"],
Cell[287743, 5002, 480, 12, 45, "Output"]
}, Open  ]],
Cell[288238, 5017, 91, 1, 33, "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{
Cell[288354, 5022, 232, 5, 45, "Input"],
Cell[288589, 5029, 1854, 58, 153, "Output"]
}, Open  ]],
Cell[290458, 5090, 909, 28, 138, "Text",
  CellTags->"finite group"],

Cell[CellGroupData[{
Cell[291392, 5122, 277, 5, 63, "Input"],
Cell[291672, 5129, 50, 1, 30, "Output"]
}, Open  ]],
Cell[291737, 5133, 139, 4, 33, "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{
Cell[291901, 5141, 191, 4, 63, "Input"],
Cell[292095, 5147, 1174, 29, 135, "Output"]
}, Open  ]],
Cell[293284, 5179, 341, 6, 96, "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[293650, 5189, 137, 3, 27, "Input"],
Cell[293790, 5194, 373, 9, 30, "Output"]
}, Open  ]],
Cell[294178, 5206, 106, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[294309, 5213, 132, 3, 27, "Input"],
Cell[294444, 5218, 99, 2, 42, "Output"]
}, Open  ]],
Cell[294558, 5223, 50, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[294633, 5227, 80, 1, 27, "Input"],
Cell[294716, 5230, 134, 2, 42, "Output"]
}, Open  ]],
Cell[294865, 5235, 496, 15, 54, "Text",
  CellTags->"fluid neck"],

Cell[CellGroupData[{
Cell[295386, 5254, 120, 3, 27, "Input"],
Cell[295509, 5259, 141, 3, 42, "Output"]
}, Open  ]],
Cell[295665, 5265, 599, 17, 96, "Text",
  CellTags->{"animation", "animation of the singularity movement"}],

Cell[CellGroupData[{
Cell[296289, 5286, 462, 8, 98, "Input"],

Cell[CellGroupData[{
Cell[296776, 5298, 18198, 594, 233, 6732, 447, "GraphicsData", "PostScript", \
"Graphics"],
Cell[314977, 5894, 18182, 596, 233, 6773, 450, "GraphicsData", "PostScript", \
"Graphics"],
Cell[333162, 6492, 18387, 597, 233, 6751, 448, "GraphicsData", "PostScript", \
"Graphics"],
Cell[351552, 7091, 18397, 599, 233, 6769, 450, "GraphicsData", "PostScript", \
"Graphics"],
Cell[369952, 7692, 17728, 590, 233, 6777, 450, "GraphicsData", "PostScript", \
"Graphics"],
Cell[387683, 8284, 15502, 562, 233, 6762, 449, "GraphicsData", "PostScript", \
"Graphics"],
Cell[403188, 8848, 18217, 596, 233, 6784, 450, "GraphicsData", "PostScript", \
"Graphics"],
Cell[421408, 9446, 18241, 595, 233, 6743, 448, "GraphicsData", "PostScript", \
"Graphics"],
Cell[439652, 10043, 18341, 597, 233, 6750, 449, "GraphicsData", "PostScript", \
"Graphics"],
Cell[457996, 10642, 18282, 595, 233, 6727, 447, "GraphicsData", "PostScript", \
"Graphics"],
Cell[476281, 11239, 18216, 598, 233, 6811, 452, "GraphicsData", "PostScript", \
"Graphics"],
Cell[494500, 11839, 17876, 591, 233, 6759, 449, "GraphicsData", "PostScript", \
"Graphics"],
Cell[512379, 12432, 18210, 594, 233, 6732, 447, "GraphicsData", "PostScript", \
"Graphics"],
Cell[530592, 13028, 18251, 597, 233, 6773, 450, "GraphicsData", "PostScript", \
"Graphics"],
Cell[548846, 13627, 18192, 594, 233, 6730, 447, "GraphicsData", "PostScript", \
"Graphics"],
Cell[567041, 14223, 18083, 593, 233, 6743, 448, "GraphicsData", "PostScript", \
"Graphics"],
Cell[585127, 14818, 18347, 597, 233, 6764, 449, "GraphicsData", "PostScript", \
"Graphics"],
Cell[603477, 15417, 18225, 596, 233, 6776, 450, "GraphicsData", "PostScript", \
"Graphics"],
Cell[621705, 16015, 17841, 593, 233, 6792, 451, "GraphicsData", "PostScript", \
"Graphics"],
Cell[639549, 16610, 18079, 595, 233, 6779, 450, "GraphicsData", "PostScript", \
"Graphics"],
Cell[657631, 17207, 17977, 590, 233, 6718, 446, "GraphicsData", "PostScript", \
"Graphics"],
Cell[675611, 17799, 18095, 593, 233, 6743, 448, "GraphicsData", "PostScript", \
"Graphics"],
Cell[693709, 18394, 18146, 594, 233, 6745, 448, "GraphicsData", "PostScript", \
"Graphics"],
Cell[711858, 18990, 18027, 592, 233, 6731, 447, "GraphicsData", "PostScript", \
"Graphics"],
Cell[729888, 19584, 17926, 590, 233, 6707, 446, "GraphicsData", "PostScript", \
"Graphics"],
Cell[747817, 20176, 17984, 593, 233, 6765, 449, "GraphicsData", "PostScript", \
"Graphics"]
}, Closed]]
}, Open  ]],
Cell[765828, 20773, 805, 15, 180, "Text"],

Cell[CellGroupData[{
Cell[766658, 20792, 130, 2, 27, "Input"],
Cell[766791, 20796, 462, 12, 45, "Output"]
}, Open  ]],
Cell[767268, 20811, 71, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[767364, 20815, 227, 5, 45, "Input"],
Cell[767594, 20822, 795, 27, 73, "Output"]
}, Open  ]],
Cell[768404, 20852, 566, 17, 96, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[768995, 20873, 263, 5, 63, "Input"],
Cell[769261, 20880, 50, 1, 30, "Output"]
}, Open  ]],
Cell[769326, 20884, 95, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[769446, 20891, 208, 4, 45, "Input"],
Cell[769657, 20897, 1125, 28, 135, "Output"]
}, Open  ]],
Cell[770797, 20928, 312, 9, 54, "Text"],

Cell[CellGroupData[{
Cell[771134, 20941, 206, 4, 45, "Input"],
Cell[771343, 20947, 78, 1, 30, "Output"]
}, Open  ]],
Cell[771436, 20951, 58, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[771519, 20955, 117, 3, 27, "Input"],
Cell[771639, 20960, 60, 1, 30, "Output"]
}, Open  ]],
Cell[771714, 20964, 684, 16, 138, "Text"],
Cell[772401, 20982, 156, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

