(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25678,       1055]*)
(*NotebookOutlinePosition[     29477,       1187]*)
(*  CellTagsIndexPosition[     28971,       1163]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[" ", "ChapterLine"],

Cell[TextData[{
  "Index for",
  StyleBox[" MathLie",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Functions"
}], "Title",
  CellTags->"Index for MathLie and Mathematica Functions"],

Cell[TextData[{
  ButtonBox["A,",
    ButtonData:>"A",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["B,",
    ButtonData:>"B",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["C,",
    ButtonData:>"C",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["D,",
    ButtonData:>"D",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["E,",
    ButtonData:>"E",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["F,",
    ButtonData:>"F",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["G,",
    ButtonData:>"G",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["H,",
    ButtonData:>"H",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["I,",
    ButtonData:>"I",
    ButtonStyle->"Hyperlink"],
  " J, K, ",
  ButtonBox["L,",
    ButtonData:>"L",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["M,",
    ButtonData:>"M",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["N,",
    ButtonData:>"N",
    ButtonStyle->"Hyperlink"],
  " O, ",
  ButtonBox["P,",
    ButtonData:>"P",
    ButtonStyle->"Hyperlink"],
  " Q, ",
  ButtonBox["R,",
    ButtonData:>"R",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["S,",
    ButtonData:>"S",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["T,",
    ButtonData:>"T",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["U,",
    ButtonData:>"U",
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["V,",
    ButtonData:>"V",
    ButtonStyle->"Hyperlink"],
  " W, X, Y, Z"
}], "Text",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],

Cell["\<\
The index is organized as follows: 
The above hyperlinks allow direct access  to the letters of the alphabet.
There are no entries under J, K, W,  X, Y, and Z.
Numbers followed by a term indicate a second, third,    \[Ellipsis] entry for \
that term. 
\
\>", "Text"],

Cell[TextData[{
  StyleBox["A",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["AdjointFrechetD[]",
    ButtonData:>{"derivat.nb", "AdjointFrechetD[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["AiryAi[]",
    ButtonData:>{"Reductio.nb", "AiryAi[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["AiryAiPrime[]",
    ButtonData:>{"Reductio.nb", "AiryAiPrime[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["AiryBi[]",
    ButtonData:>{"Reductio.nb", "AiryBi[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["AiryBiPrime[]",
    ButtonData:>{"Reductio.nb", "AiryBiPrime[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["ApproximateSymmetries[]",
    ButtonData:>{"symmet7.nb", "ApproximateSymmetries[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Array[]",
    ButtonData:>{"Algebra.nb", "Array[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"A"],

Cell[TextData[{
  StyleBox["B",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["BackTrafoCanonical[]",
    ButtonData:>{"symmet3.nb", "BackTrafoCanonical[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Baecklund[]",
    ButtonData:>{"Symmet75.nb", "Baecklund[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"B"],

Cell[TextData[{
  StyleBox["C",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["CanonicalRepresentation[],",
    ButtonData:>{"symmet2.nb", "CanonicalRepresentation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet3.nb", "CanonicalRepresentation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["CanonicalVariables[],",
    ButtonData:>{"symmet11.nb", "CanonicalVariables[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet2.nb", "CanonicalVariables[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3",
    ButtonData:>{"symmet3.nb", "CanonicalVariables[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["CommutativeQ[]",
    ButtonData:>{"Algebra.nb", "CommutativeQ[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"C"],

Cell[TextData[{
  StyleBox["D",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["D[]",
    ButtonData:>{"derivat.nb", "D[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["DeltaMatrix[],",
    ButtonData:>{"symmet3.nb", "DeltaMatrix[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet4.nb", "DeltaMatrix[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["derivativeOrder[]",
    ButtonData:>{"derivat.nb", "derivativeOrder[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["DeterminingEquations[],",
    ButtonData:>{"Layer.nb", "DeterminingEquations[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet2.nb", "DeterminingEquations[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3",
    ButtonData:>{"symmet5.nb", "DeterminingEquations[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Do[],",
    ButtonData:>{"Group.nb", "Do[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "Do[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["DSolve[],",
    ButtonData:>{"Jet.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"Layer.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"MolecularBeamEpitaxy.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4,",
    ButtonData:>{"RayleighParticle.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["5,",
    ButtonData:>{"Reductio.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["6,",
    ButtonData:>{"symmet11.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["7,",
    ButtonData:>{"symmet1.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["8,",
    ButtonData:>{"symmet2.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["9,",
    ButtonData:>{"symmet3.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["10,",
    ButtonData:>{"symmet4.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["11,",
    ButtonData:>{"symmet52.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["12,",
    ButtonData:>{"symmet5.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["13,",
    ButtonData:>{"symmet6.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["14,",
    ButtonData:>{"symmet7.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["15",
    ButtonData:>{"symmet8.nb", "DSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"D"],

Cell[TextData[{
  StyleBox["E",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["Erfi[],",
    ButtonData:>{"RayleighParticle.nb", "Erfi[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet6.nb", "Erfi[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["EulerD[]",
    ButtonData:>{"derivat1.nb", "EulerD[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"E"],

Cell[TextData[{
  StyleBox["F",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["FirstIntegral[],",
    ButtonData:>{"symmet3.nb", "FirstIntegral[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet4.nb", "FirstIntegral[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["FrechetD[],",
    ButtonData:>{"derivat.nb", "FrechetD[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet11.nb", "FrechetD[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3",
    ButtonData:>{"symmet1.nb", "FrechetD[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["FrechetProlong[]",
    ButtonData:>{"symmet5.nb", "FrechetProlong[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"F"],

Cell[TextData[{
  StyleBox["G",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["GeneralCanonicalForm[]",
    ButtonData:>{"symmet8.nb", "GeneralCanonicalForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["GlobalSymmetryTransformation[],",
    ButtonData:>{"symmet1.nb", "GlobalSymmetryTransformation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet1.nb", "GlobalSymmetyTransformation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["GroebnerBasis[]",
    ButtonData:>{"symmet8.nb", "GroebnerBasis[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"G"],

Cell[TextData[{
  StyleBox["H",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["Hold[]",
    ButtonData:>{"derivat1.nb", "Hold[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"H"],

Cell[TextData[{
  StyleBox["I",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["ImplicitPlot[]",
    ButtonData:>{"symmet2.nb", "ImplicitPlot[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Infinitesimals[],",
    ButtonData:>{"DropFormation.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"Jet.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"Layer.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4,",
    ButtonData:>{"Reductio.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["5,",
    ButtonData:>{"symmet3.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["6,",
    ButtonData:>{"symmet4.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["7,",
    ButtonData:>{"symmet5.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["8",
    ButtonData:>{"symmet65.nb", "Infinitesimals[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Integrate[]",
    ButtonData:>{"symmet4.nb", "Integrate[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["IntegratingFactor[]",
    ButtonData:>{"symmet2.nb", "IntegratingFactor[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Inverse[],",
    ButtonData:>{"Group.nb", "Inverse[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "Inverse[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["InverseFunction[]",
    ButtonData:>{"symmet7.nb", "InverseFunction[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"I"],

Cell[TextData[{
  StyleBox["L",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["Length[]",
    ButtonData:>{"Algebra.nb", "Length[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LeviCivita[]",
    ButtonData:>{"Algebra.nb", "LeviCivita[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Lie[],",
    ButtonData:>{"Layer.nb", "Lie[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet51.nb", "Lie[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"symmet5.nb", "Lie[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4",
    ButtonData:>{"symmet6.nb", "Lie[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LieCommutatorTable[]",
    ButtonData:>{"symmet3.nb", "LieCommutatorTable[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LieEquations[],",
    ButtonData:>{"symmet51.nb", "LieEquation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet51.nb", "LieEquations[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"symmet52.nb", "LieEquations[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4,",
    ButtonData:>{"symmet5.nb", "LieEquations[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["5",
    ButtonData:>{"symmet6.nb", "LieEquations[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LieProduct[]",
    ButtonData:>{"Algebra.nb", "LieProduct[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LieReduction[],",
    ButtonData:>{"Layer.nb", "LieReduction[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"Reductio.nb", "LieReduction[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"symmet51.nb", "LieReduction[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4,",
    ButtonData:>{"symmet52.nb", "LieReduction[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["5,",
    ButtonData:>{"symmet6.nb", "LieReduction[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["6",
    ButtonData:>{"symmet51.nb", "LieRedunction[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LieSolve[],",
    ButtonData:>{"Layer.nb", "LieSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet51.nb", "LieSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3",
    ButtonData:>{"symmet5.nb", "LieSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LieStructureForm[],",
    ButtonData:>{"symmet51.nb", "LieStructureForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet5.nb", "LieStructureForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"derivat1.nb", "LieTraditionalForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4,",
    ButtonData:>{"derivat.nb", "LieTraditionalForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LieTraditionalForm[]",
    ButtonData:>{"symmet5.nb", "LieTraditionalForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["LTF[],",
    ButtonData:>{"derivat1.nb", "LTF[]"},
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet5.nb", "LTF[]"},
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3 ",
    ButtonData:>{"symmet11.nb", "LTF[]"},
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Limit[]",
    ButtonData:>{"derivat.nb", "Limit[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Line[]",
    ButtonData:>{"derivat1.nb", "Line[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Log[],",
    ButtonData:>{"symmet11.nb", "Log[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet2.nb", "Log[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"L"],

Cell[TextData[{
  StyleBox["M",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["MatrixForm[],",
    ButtonData:>{"Group.nb", "MatrixForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "MatrixForm[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"M"],

Cell[TextData[{
  StyleBox["N",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["N[],",
    ButtonData:>{"Group.nb", "N[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "N[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["NDSolve[],",
    ButtonData:>{"Atomic.nb", "NDSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Reductio.nb", "NDSolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["NonClassicalPointSymmetries[]",
    ButtonData:>{"symmet6.nb", "NonClassicalPointSymmetries[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["NonCommutativeMultiply[]",
    ButtonData:>{"symmet7.nb", "NonCommutativeMultiply[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"N"],

Cell[TextData[{
  StyleBox["P",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["PDESolve[],",
    ButtonData:>{"Layer.nb", "PDESolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet51.nb", "PDESolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"symmet6.nb", "PDESolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4,",
    ButtonData:>{"Symmet75.nb", "PDESolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["5",
    ButtonData:>{"symmet8.nb", "PDESolve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Plot[],",
    ButtonData:>{"Atomic.nb", "Plot[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"derivat1.nb", "Plot[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3,",
    ButtonData:>{"Group.nb", "Plot[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["4",
    ButtonData:>{"Group.nb", "Plot[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["PlotVectorField[]",
    ButtonData:>{"symmet1.nb", "PlotVectorField[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["PotentialSymmetries[]",
    ButtonData:>{"symmet65.nb", "PotentialSymmetries[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["PrintDf[]",
    ButtonData:>{"symmet5.nb", "PrintDf[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["ProductLog[]",
    ButtonData:>{"symmet3.nb", "ProductLog[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["prolongation[]",
    ButtonData:>{"derivat.nb", "prolongation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Prolongation[],",
    ButtonData:>{"derivat1.nb", "Prolongation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2,",
    ButtonData:>{"symmet1.nb", "Prolongation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["3",
    ButtonData:>{"symmet5.nb", "Prolongation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["ProlongationODE[]",
    ButtonData:>{"symmet11.nb", "ProlongationODE[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"P"],

Cell[TextData[{
  StyleBox["R",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["Rotation[],",
    ButtonData:>{"Group.nb", "Rotation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "Rotation[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["RotationX[].",
    ButtonData:>{"Group.nb", "RotationX[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "RotationX[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["RotationY[],",
    ButtonData:>{"Group.nb", "RotationY[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "RotationY[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["RotationZ[],",
    ButtonData:>{"Group.nb", "RotationZ[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"Group.nb", "RotationZ[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"R"],

Cell[TextData[{
  StyleBox["S",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["Save[]",
    ButtonData:>{"symmet6.nb", "Save[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["scaling[]",
    ButtonData:>{"symmet2.nb", "scaling[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["SecondOrderAlgebras[],",
    ButtonData:>{"symmet3.nb", "SecondOrderAlgebras[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet3.nb", "SecondOrderIntegrate[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Series[]",
    ButtonData:>{"symmet1.nb", "Series[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Signature[]",
    ButtonData:>{"Algebra.nb", "Signature[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Sin[]",
    ButtonData:>{"Reductio.nb", "Sin[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["SolvableAlgebrasOfOrderN[],",
    ButtonData:>{"Algebra.nb", "SolvableAlgebrasOfOrderN[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet4.nb", "SolvableAlgebrasOfOrderN[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Solve[],",
    ButtonData:>{"Symmet75.nb", "Solve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet7.nb", "Solve[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Sort[]",
    ButtonData:>{"derivat.nb", "Sort[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"S"],

Cell[TextData[{
  StyleBox["T",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["Table[]",
    ButtonData:>{"Algebra.nb", "Table[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Tan[]",
    ButtonData:>{"Reductio.nb", "Tan[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["TangentSurface[]",
    ButtonData:>{"derivat.nb", "TangentSurface[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["TangentVector[],",
    ButtonData:>{"derivat.nb", "TangentVector[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  " ",
  ButtonBox["2",
    ButtonData:>{"symmet1.nb", "TangentVector[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Tanh[]",
    ButtonData:>{"Jet.nb", "Tanh[]"},
    Active->True,
    ButtonStyle->"Hyperlink"],
  "\n",
  ButtonBox["Trot[]",
    ButtonData:>{"symmet1.nb", "Trot[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"T"],

Cell[TextData[{
  StyleBox["U",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["Union[]",
    ButtonData:>{"Algebra.nb", "Union[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"U"],

Cell[TextData[{
  StyleBox["V",
    FontSize->16,
    FontWeight->"Bold"],
  "\n",
  ButtonBox["VectorField[]",
    ButtonData:>{"derivat1.nb", "VectorField[]"},
    Active->True,
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"V"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{673, 668},
WindowMargins->{{149, Automatic}, {Automatic, 25}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Introduction", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Introduction", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"SectionReferences"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1.25,
CounterBoxOptions->{CounterFunction:>Identity},
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Index for MathLie and Mathematica Functions"->{
    Cell[1766, 53, 229, 9, 194, "Title",
      CellTags->"Index for MathLie and Mathematica Functions"]},
  "A"->{
    Cell[3784, 151, 1047, 40, 186, "Text",
      CellTags->"A"]},
  "B"->{
    Cell[4834, 193, 383, 15, 70, "Text",
      CellTags->"B"]},
  "C"->{
    Cell[5220, 210, 943, 35, 87, "Text",
      CellTags->"C"]},
  "D"->{
    Cell[6166, 247, 3062, 125, 137, "Text",
      CellTags->"D"]},
  "E"->{
    Cell[9231, 374, 474, 20, 70, "Text",
      CellTags->"E"]},
  "F"->{
    Cell[9708, 396, 877, 35, 87, "Text",
      CellTags->"F"]},
  "G"->{
    Cell[10588, 433, 702, 25, 87, "Text",
      CellTags->"G"]},
  "H"->{
    Cell[11293, 460, 224, 10, 54, "Text",
      CellTags->"H"]},
  "I"->{
    Cell[11520, 472, 1927, 75, 137, "Text",
      CellTags->"I"]},
  "L"->{
    Cell[13450, 549, 4331, 172, 270, "Text",
      CellTags->"L"]},
  "M"->{
    Cell[17784, 723, 353, 15, 54, "Text",
      CellTags->"M"]},
  "N"->{
    Cell[18140, 740, 896, 35, 104, "Text",
      CellTags->"N"]},
  "P"->{
    Cell[19039, 777, 2398, 95, 187, "Text",
      CellTags->"P"]},
  "R"->{
    Cell[21440, 874, 1091, 45, 104, "Text",
      CellTags->"R"]},
  "S"->{
    Cell[22534, 921, 1668, 65, 187, "Text",
      CellTags->"S"]},
  "T"->{
    Cell[24205, 988, 988, 40, 137, "Text",
      CellTags->"T"]},
  "U"->{
    Cell[25196, 1030, 225, 10, 54, "Text",
      CellTags->"U"]},
  "V"->{
    Cell[25424, 1042, 238, 10, 54, "Text",
      CellTags->"V"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Index for MathLie and Mathematica Functions", 27494, 1102},
  {"A", 27609, 1105},
  {"B", 27684, 1108},
  {"C", 27757, 1111},
  {"D", 27830, 1114},
  {"E", 27906, 1117},
  {"F", 27979, 1120},
  {"G", 28052, 1123},
  {"H", 28126, 1126},
  {"I", 28200, 1129},
  {"L", 28276, 1132},
  {"M", 28353, 1135},
  {"N", 28427, 1138},
  {"P", 28502, 1141},
  {"R", 28578, 1144},
  {"S", 28654, 1147},
  {"T", 28730, 1150},
  {"U", 28805, 1153},
  {"V", 28880, 1156}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 24, 0, 117, "ChapterLine"],
Cell[1766, 53, 229, 9, 194, "Title",
  CellTags->"Index for MathLie and Mathematica Functions"],
Cell[1998, 64, 1504, 76, 66, "Text"],
Cell[3505, 142, 276, 7, 117, "Text"],
Cell[3784, 151, 1047, 40, 186, "Text",
  CellTags->"A"],
Cell[4834, 193, 383, 15, 70, "Text",
  CellTags->"B"],
Cell[5220, 210, 943, 35, 87, "Text",
  CellTags->"C"],
Cell[6166, 247, 3062, 125, 137, "Text",
  CellTags->"D"],
Cell[9231, 374, 474, 20, 70, "Text",
  CellTags->"E"],
Cell[9708, 396, 877, 35, 87, "Text",
  CellTags->"F"],
Cell[10588, 433, 702, 25, 87, "Text",
  CellTags->"G"],
Cell[11293, 460, 224, 10, 54, "Text",
  CellTags->"H"],
Cell[11520, 472, 1927, 75, 137, "Text",
  CellTags->"I"],
Cell[13450, 549, 4331, 172, 270, "Text",
  CellTags->"L"],
Cell[17784, 723, 353, 15, 54, "Text",
  CellTags->"M"],
Cell[18140, 740, 896, 35, 104, "Text",
  CellTags->"N"],
Cell[19039, 777, 2398, 95, 187, "Text",
  CellTags->"P"],
Cell[21440, 874, 1091, 45, 104, "Text",
  CellTags->"R"],
Cell[22534, 921, 1668, 65, 187, "Text",
  CellTags->"S"],
Cell[24205, 988, 988, 40, 137, "Text",
  CellTags->"T"],
Cell[25196, 1030, 225, 10, 54, "Text",
  CellTags->"U"],
Cell[25424, 1042, 238, 10, 54, "Text",
  CellTags->"V"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

