(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    416770,       7813]*)
(*NotebookOutlinePosition[    437984,       8390]*)
(*  CellTagsIndexPosition[    435196,       8308]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["2", "ChapterLine",
  CellTags->"1.1"],

Cell["Elements of Symmetry Analysis", "Title",
  CellTags->"1.1"],

Cell[TextData[{
  "At the beginning we will introduce some basic concepts which will be \
important throughout the whole book. First, we define the general properties \
of a group. These group properties are extended to Lie groups in the next \
step. The related Lie algebra connected with the Lie group is then \
introduced. We also introduce the notion of a vector field which is closely \
related to Lie algebras. We present all these highly abstract terms in \
connection with ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " Different examples serve to vitalize the mathematical expressions. This \
chapter serves also to describe the first steps in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and introduce its notation. The elementary representation of mathematical \
expressions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides the connection between mathematics and computer algebra."
}], "Text",
  Evaluatable->False,
  CellTags->{"general properties of a group", "computer algebra"}],

Cell[CellGroupData[{

Cell[TextData[{
  "2.",
  CounterBox["Section"],
  ".",
  " Groups and Lie Groups"
}], "Section",
  Evaluatable->False,
  CellTags->"Groups and Lie Groups"],

Cell["\<\
It is the purpose of this section to record, for later reference, \
some of the results from group theory which will be needed in the text. The \
notation of a group is introduced in this chapter and the most important \
properties of group elements are deduced. Illustrations are given from a few \
very simple groups. Proofs will be minimal or omitted.\
\>", "Text",
  Evaluatable->False,
  CellTags->"group theory"],

Cell[CellGroupData[{

Cell[TextData[{
  "2.1.",
  CounterBox["Subsection"],
  " ",
  "Groups"
}], "Subsection",
  Evaluatable->False,
  CellTags->"Groups"],

Cell["\<\
Although we shall soon come to some illustrative examples, it is \
worth beginning with the abstract definition of a group which is very simple \
and yet leads to many important consequences.\
\>", "Text",
  Evaluatable->False],

Cell["Definition: Group", "Definition",
  CellTags->"Definition: Group"],

Cell[TextData[{
  "A set \[GothicCapitalG] of elements ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox[\({G\_1\),
                "TraditionalForm"], ",", \(G\_2\)}],
            "TraditionalForm"], ",", \(G\_3\)}], TraditionalForm]]],
  ",\[Ellipsis]} is said to form a group if a rule of composition is defined \
for the elements satisfying certain conditions. The result of a  \
multiplication involving two elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_k\)]],
  " is called the product or composition of the two elements and is written ",
  
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_k\)]],
  ". The conditions which such a product has to satisfy are as follows:"
}], "Text",
  Evaluatable->False,
  CellTags->{"composition", "group multiplication", "group"}],

Cell["(i) Closure relation: ", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times",
  CellTags->{"closure relation", "group properties"}],

Cell[TextData[{
  "The product ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_k\)]],
  " of any two elements is itself an element in the set, i.e.,"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubscriptBox["G", 
                StyleBox["i",
                  FontFamily->"Times"]],
              FontFamily->"Times"], " ", "\[CirclePlus]", " ", 
            StyleBox[\(G\_k\),
              FontFamily->"Times"]}], " ", "=", " ", 
          StyleBox[\(G\_j\),
            FontFamily->"Times"]}],
        "TraditionalForm"], "  ", "with", "  ", 
      FormBox[
        RowBox[{
          StyleBox[\(G\_j\),
            FontFamily->"Times"], " ", "\[Element]", " ", 
          "\[GothicCapitalG]"}],
        "TraditionalForm"]}]], "DisplayFormula",
  Evaluatable->False,
  FontFamily->"Times"],

Cell["(ii) Associativity:", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times",
  CellTags->"associativity"],

Cell[TextData[{
  "If three elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i, G\_k\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_j\)]],
  " are multiplied, it does not matter which product is carried out first, \
i.e.,"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "\t\t",
  Cell[BoxData[
      \(TraditionalForm
      \`G\_i\ \[CirclePlus]\ \((G\_k\ \[CirclePlus]\ G\_j)\)\  = \ 
        \(\((G\_i\ \[CirclePlus]\ G\_k)\)\ \[CirclePlus]\ G\_j\  = \ 
          G\_i\ \[CirclePlus]\ G\_k\ \[CirclePlus]\ \(G\_j . \)\)\)]]
}], "DisplayFormula",
  Evaluatable->False],

Cell["\<\
This equality shows that the use of brackets is not necessary.\
\>",
   "Text",
  Evaluatable->False],

Cell["(iii) Identity element:", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times",
  CellTags->"identity element"],

Cell[TextData[{
  "One element of the set \[GothicCapitalG], denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`E\)]],
  " and called the identity element, must have the properties"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`E\ \[CirclePlus]\ G\_i\  = \ G\_i\)]],
  "  and   ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ E\  = \ G\_i\)]]
}], "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "for all ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\  \[Element] \ \[GothicCapitalG]\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell["(iv) Inverse:", "ListItem",
  PageWidth->Infinity,
  Evaluatable->False,
  CellHorizontalScrolling->False,
  FontFamily->"Times"],

Cell[TextData[{
  "To each element ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " in the set \[GothicCapitalG], there corresponds another element in the \
set, denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\%\(-1\)\)]],
  " and called the inverse, which has the properties"
}], "Text",
  Evaluatable->False,
  CellTags->"inverse element"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`G\_i\ \[CirclePlus]\ G\_i\%\(-1\)\  = \ 
        \(E\  = \ G\_i\%\(-1\)\ \[CirclePlus]\ G\_i\)\)]],
  ".\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "In general, it is not permissible to change the order of multiplication of \
group elements; i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`\(G\_i\ \[CirclePlus]\ G\_j\ \ \)\)]],
  "is not, in general, the same element as ",
  Cell[BoxData[
      \(TraditionalForm\`G\_j\ \[CirclePlus]\ G\_i\)]],
  ". A group which satisfies this exception, ",
  Cell[BoxData[
      \(TraditionalForm
      \`G\_i\ \[CirclePlus]\ G\_j\  = \ G\_j\ \[CirclePlus]\ G\_i\)]],
  ", is called an Abelian group. Its elements are said to commute. The axioms \
(i)\[Dash](iv) stated above are the main ingredients of group theory. \
However, these properties are abstract entities which need a practical \
realization. A convenient method of recording the multiplication, ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_j\  = \ G\_k\)]],
  ", of elements of a particular group \[GothicCapitalG] is to build the \
multiplication table in which the rows and columns are labeled by the group \
elements and the result ",
  Cell[BoxData[
      \(TraditionalForm\`G\_k\)]],
  " of the multiplication is entered at the intersection of the row ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["G", 
          StyleBox["i",
            FontSlant->"Italic"]], TraditionalForm]]],
  " and the column ",
  Cell[BoxData[
      \(TraditionalForm\`G\_j\)]],
  ". The definition of a group implies that every group element must appear \
once and only once in each row and in each column."
}], "Text",
  Evaluatable->False,
  CellTags->{"Abelian group", "multiplication table"}],

Cell[TextData[{
  "Deliberately, we did not specify the number of elements in the group. In \
fact, the number may be finite or it may be infinite. Correspondingly, the \
group is called a finite or an infinite group. In this book, we shall \
encounter both groups since they both are of importance in symmetry analysis. \
If we find a finite group order, we will denote the number of elements ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " as the order of the group."
}], "Text",
  Evaluatable->False,
  CellTags->{"finite group", "infinite group"}],

Cell["\<\
The simplest examples of group elements are natural numbers with \
ordinary multiplication. We will discuss two examples.\
\>", "Text",
  Evaluatable->False],

Cell["Example 1", "Example"],

Cell[TextData[{
  "Let us assume we only know the two numbers 1 and \[Dash]1 and the ordinary \
multiplication as group operation. The identity of this group is clearly 1. \
The inverse of the identity is again the identity. The inverse of \[Dash]1 is \
\[Dash]1 itself. The properties of this group are contained in the group  \
multiplication table ",
  StyleBox["tab1 ",
    FontSlant->"Italic"],
  "below. We can create the group table in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by defining the group \[GothicCapitalG] as  the set"
}], "Text",
  Evaluatable->False,
  CellTags->{"multiplication", "multiplication table"}],

Cell[BoxData[
    \(\(G = {\(-1\), 1}; \)\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "Using all combinations of the elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " in the group table, we get"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab1 = 
      MatrixForm[
        Table[G\[LeftDoubleBracket]i\[RightDoubleBracket]\ 
            G\[LeftDoubleBracket]j\[RightDoubleBracket], {i, 1, 2}, {j, 1, 
            2}]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-1\)},
            {\(-1\), "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"representing the core of the multiplication table.\[ThickSpace]\[ThickSpace]\
\[ThickSpace]\[EmptySquare]"], "Text",
  Evaluatable->False,
  CellTags->"multiplication table"],

Cell["Example 2", "Example"],

Cell["\<\
A slightly larger group of the same kind is the set of numbers\
\>",
   "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(G2 = {\(-1\), 1, \(-I\), I}; \)\)], "Input",
  PageWidth->Infinity],

Cell["which possesses the multiplication table ", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(tab2 = 
      MatrixForm[
        Table[G2\[LeftDoubleBracket]i\[RightDoubleBracket]\ 
            G2\[LeftDoubleBracket]j\[RightDoubleBracket], {i, 1, 4}, \n
          \t\t\t{j, 1, 4}]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-1\), "I", \(-I\)},
            {\(-1\), "1", \(-I\), "I"},
            {"I", \(-I\), \(-1\), "1"},
            {\(-I\), "I", "1", \(-1\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Because ordinary multiplication is used in both examples, these groups \
must be Abelian since it does not matter in which order the elements of the \
sets are used. To demonstrate this, let us exchange the ",
  StyleBox["j",
    FontSlant->"Italic"],
  "th element by the ",
  StyleBox["i",
    FontSlant->"Italic"],
  "th element in the table above."
}], "Text",
  Evaluatable->False,
  CellTags->"Abelian group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      Table[G2\[LeftDoubleBracket]j\[RightDoubleBracket]\ 
          G2\[LeftDoubleBracket]i\[RightDoubleBracket], {i, 1, 4}, {j, 1, 4}]]
      \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-1\), "I", \(-I\)},
            {\(-1\), "1", \(-I\), "I"},
            {"I", \(-I\), \(-1\), "1"},
            {\(-I\), "I", "1", \(-1\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Comparing both group tables of ",
  StyleBox["G2",
    FontSlant->"Italic"],
  " demonstrates that the order of the group elements in the multiplication \
does not matter.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->"group element"],

Cell[TextData[{
  "For physical systems, rotations are of considerable importance. It is well \
known that various sets of rotations form groups. The rotations were one of \
the favorite groups used by Lie to demonstrate the action of his \
examinations. In reminiscence of this historical note, let us examine a few \
examples related to that topic. The law of multiplication in this case is \
defined by transition from one location to another\[LongDash]if a rotation ",
  Cell[BoxData[
      \(TraditionalForm\`R\_1\)]],
  " carries a system from position A to position B and if ",
  Cell[BoxData[
      \(TraditionalForm\`R\_2\)]],
  " carries it from B to C, then the product ",
  Cell[BoxData[
      \(TraditionalForm\`R\_1\ \[CirclePlus]\ R\_2\)]],
  " carries it from A to C. It is obvious that this definition of \
multiplication can, in general, not create an Abelian group. Of course, \
rotations about a common axis are Abelian. However, rotations in \
higher-dimensional spaces in general do not commute. Let us demonstrate these \
two statements by simple examples."
}], "Text",
  Evaluatable->False,
  CellTags->{"rotations", "Abelian group"}],

Cell["Example 3", "Example"],

Cell[TextData[{
  "To illustrate the commutative and non-commutative properties of rotations, \
let us define a function which carries out a two- and a three-dimensional \
rotation of an object. The function ",
  StyleBox["Rotation[]", "MmaText"],
  " uses the standard package ",
  StyleBox["Geometry`Rotation`", "MmaText"],
  " to represent the rotation matrices in two and three dimensions. The \
function ",
  StyleBox["Rotation[]", "MmaText"],
  " will take a polygon and an angle as input parameters. This function \
generates the geometrical shape of the object and carries out a rotation.  \
First, let us define the geometrical object by a polygon"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],

Cell[BoxData[
    \(\(hexagon = 
      Polygon[Table[{Cos[i], Sin[i]}, \n
          \t\t\t{i, 0, 2\ \[Pi], \(2\ \[Pi]\)\/6}]]; \)\)], "Input",
  PageWidth->Infinity],

Cell["\<\
Our favorite object is a hexagon which can be graphically displayed \
by the following lines:\
\>", "Text",
  Evaluatable->False,
  CellTags->"display"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{RGBColor[1, 0, 0], \n\t\t\thexagon}], 
      AspectRatio \[Rule] Automatic]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .86603 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.433013 0.47619 [
[ 0 0 0 0 ]
[ 1 .86603 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .86603 L
0 .86603 L
closepath
clip
newpath
1 0 0 r
.97619 .43301 m
.7381 .84541 L
.2619 .84541 L
.02381 .43301 L
.2619 .02062 L
.7381 .02062 L
.97619 .43301 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{120.5, 108},
  ImageMargins->{{92, 0}, {0, 0}},
  ImageRegion->{{-0.427984, 1.42387}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002F0000Qa000`40O003h00OUWoo002FOol009Io
o`00UWoo002FOol002Aoodal02Ioo`0097ooC7`09Woo000SOom>O00UOol002=oodil02Eoo`008Woo
D7`097oo000QOomBO00SOol0025ooe9l02=oo`0087ooE7`08Woo000POomDO00ROol001mooeIl025o
o`007gooEW`08Goo000NOomHO00POol001eooeYl01moo`007GooFW`07goo000LOomLO00NOol001ao
oeal01ioo`006gooGW`07Goo000JOomPO00LOol001Yoof1l01aoo`006GooHW`06goo000IOomRO00K
Ool001QoofAl01Yoo`005gooIW`06Goo000GOomVO00IOol001IoofQl01Qoo`005WooJ7`067oo000E
OomZO00GOol001EoofYl01Moo`0057ooK7`05Woo000COom^O00EOol001=oofil01Eoo`004WooL7`0
57oo000BOom`O00DOol0015oog9l01=oo`0047ooM7`04Woo000@OomdO00BOol000moogIl015oo`00
3gooMW`04Goo000>OomhO00@Ool000ioogQl011oo`003GooNW`03goo000<OomlO00>Ool000aoogal
00ioo`002gooOW`03Goo000;OomnO00=Ool000Yooh1l00aoo`002GooPW`02goo0009Oon2O00;Ool0
00QoohAl00Yoo`0027ooQ7`02Woo0007Oon6O009Ool000IoohQl00Qoo`001WooR7`027oo0005Oon:
O007Ool000EoohYl00Moo`0017ooS7`01Woo0004Oon<O006Ool000=oohil00Eoo`000WooT7`017oo
0002Oon@O004Ool00003Ooml07`0091l00=oo`0000=oog`0O000T7`00goo002DO002Ool00003Ooml
07`0091l00=oo`0000=oog`0O000T7`00goo0002Oon@O004Ool0009ooi1l00Aoo`000gooSW`01Goo
0003Oon>O005Ool000Aoohal00Ioo`001GooRW`01goo0005Oon:O007Ool000IoohQl00Qoo`001Woo
R7`027oo0007Oon6O009Ool000QoohAl00Yoo`0027ooQ7`02Woo0009Oon2O00;Ool000Uooh9l00]o
o`002WooP7`037oo000:Oon0O00<Ool000]oogil00eoo`0037ooO7`03Woo000<OomlO00>Ool000eo
ogYl00moo`003GooNW`03goo000>OomhO00@Ool000ioogQl011oo`003gooMW`04Goo000@OomdO00B
Ool0011oogAl019oo`004GooLW`04goo000AOombO00COol0019oog1l01Aoo`004gooKg`057oo000C
Oom^O00EOol001Aoofal01Ioo`0057ooK7`05Woo000EOomZO00GOol001EoofYl01Moo`005WooJ7`0
67oo000GOomVO00IOol001MoofIl01Uoo`0067ooI7`06Woo000HOomTO00JOol001Uoof9l01]oo`00
6GooHW`06goo000JOomPO00LOol001]ooeil01eoo`006gooGW`07Goo000LOomLO00NOol001aooeal
01ioo`007GooFW`07goo000MOomJO00OOol001iooeQl021oo`007gooEW`08Goo000OOomFO00QOol0
021ooeAl029oo`0087ooE7`08Woo000QOomBO00SOol0029ooe1l02Aoo`008WooD7`097oo000SOom>
O00UOol002=oodil02Eoo`0097ooC7`09Woo000TOom<O00VOol002EoodYl02Moo`00UWoo002FOol0
09Ioo`00\
\>"],
  ImageRangeCache->{{{-64.4375, 213.438}, {134, 0}} -> {-1.01113, -0.909337, \
0.0169653, 0.0169653}}]
}, Open  ]],

Cell[TextData[{
  "This object will be rotated by our function ",
  StyleBox["Rotation[]", "MmaText"],
  ". In a two-dimensional space, the function is defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " terms by  "
}], "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],

Cell[BoxData[
    \(<< "\<Geometry`Rotations`\>"\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[{
    \(\(Clear[Rotation]; \)\), 
    \(Rotation[polygon_Polygon, angle_] := \n\t
      Block[{points}, \n\t\tpoints = polygon /. Polygon[x___] \[Rule] x; \n
        \t\tPolygon[\((Rotate2D[#1, angle]&)\)/@points]]\)}], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The function ",
  StyleBox["Rotation[]", "MmaText"],
  " needs a polygon and the angle of rotation as input quantities. It returns \
a clockwise-rotated polygon. The application of the function ",
  StyleBox["Rotation[]", "MmaText"],
  " on our hexagon gives us"
}], "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{RGBColor[0.000, 0.000, 1.000], \n\t\t\t
          Rotation[hexagon, \[Pi]\/5]}], AspectRatio \[Rule] Automatic]\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08864 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.521255 0.54432 0.521255 [
[ 0 0 0 0 ]
[ 1 1.08864 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08864 L
0 1.08864 L
closepath
clip
newpath
0 0 1 r
.9217 .23793 m
.97619 .75633 L
.55449 1.06272 L
.0783 .85071 L
.02381 .33231 L
.44551 .02592 L
.9217 .23793 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{109.813, 128.188},
  ImageMargins->{{86, 0}, {0, 0}},
  ImageRegion->{{-0.679842, 1.6917}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000290000X1000`40O003h00ORGoo0029Ool008Uo
o`00RGoo0029Ool003]oo`<07d]oo`00>Goo1`0OBGoo000hOol:01m7Ool003Moo`d07dEoo`00=Goo
4P0O@Woo000dOolE01m0Ool003=ooaP07cioo`00<Goo700O?7oo000`OolP01liOol002moob<07cMo
o`00;Goo9`0O=Goo000/OolZ01lcOol002]oobh07c1oo`00:Goo<P0O;Woo000XOole01l/Ool002Io
ocX07bUoo`009Goo?@0O9goo000TOom001lUOol0029ood@07b=oo`008GooB00O87oo000POom;01lN
Ool001ioodl07aaoo`007GooDP0O6Woo000LOomF01lGOol001YooeX07aEoo`006GooG@0O4goo000H
OomP01lAOol001IoofD07`ioo`005GooJ00O37oo000DOom[01l:Ool0019oog007`Moo`004GooL@0O
1goo000?Oomc01l7Ool000ioog@07`Moo`003GooM@0O1goo000;Oomh01l6Ool000YoogT07`Ioo`00
2GooNP0O1Woo0007Ooml01l6Ool000Ioogd07`Ioo`001GooOP0O1Woo0003Oon001l6Ool0009ooh40
7`Ioo`0000=oo`0O01l0P00O1Woo002301l6Ool008@07`Eoo`00Q00O1Goo002401l5Ool008@07`Eo
o`00Q00O1Goo002401l5Ool008@07`Eoo`00Q00O1Goo002401l5Ool008D07`Aoo`00Q@0O17oo0025
01l4Ool008D07`Aoo`00Q@0O17oo00000goo01l07`2201l4Ool00003Ool07`0O08807`Aoo`0000=o
o`0O01l0PP0O17oo00000goo01l07`2201l4Ool00003Ool07`0O08807`Aoo`0000=oo`0O01l0P`0O
0goo00000goo01l07`2301l3Ool00003Ool07`0O08<07`=oo`0000=oo`0O01l0P`0O0goo0002Oon4
01l3Ool0009ooh@07`=oo`000WooQ00O0goo0002Oon401l3Ool0009ooh@07`=oo`000WooQ@0O0Woo
0002Oon501l2Ool0009oohD07`9oo`000WooQ@0O0Woo0002Oon501l2Ool000=ooh@07`9oo`000goo
Q00O0Woo0003Oon401l2Ool000=ooh@07`9oo`000gooQ00O0Woo0003Oon501l1Ool000=oohD07`5o
o`000gooQ@0O0Goo0003Oon501l1Ool000Aooh@07`5oo`0017ooQ00O0Goo0004Oon401l1Ool000Ao
oh@07`5oo`0017ooQ00O0Goo0004Oon501l000AoohD07`0017ooQ@0O0004Oon501l000AoohD07`00
1GooQ00O0005Oon401l000Eooh@07`001GooQ00O0005Oon401l000Eooh@07`001GooQ00O0005Oon4
01l000Eooh@07`001WooP`0O0006Oon301l000Iooh407`9oo`001WooP00O0goo0006Oomo01l4Ool0
00Ioogd07`Ioo`001WooO00O1goo0006Oomk01l8Ool000IoogT07`Yoo`001WooN00O2goo0007Oome
01l=Ool000Moog@07`ioo`001gooL`0O3goo0007Ooma01lAOol000Moog007a9oo`002GooK@0O4goo
000;OomY01lEOol000eoofH07aIoo`003gooHP0O67oo000BOomN01lIOol001Aooe/07aYoo`005Woo
E`0O77oo000HOomD01lMOol001Yooe007amoo`007GooC00O87oo000OOom901lQOol0025oodD07b=o
o`008goo@P0O97oo000VOoln01lUOol002QoocX07bMoo`00:Woo=`0O:7oo000/Oolc01lZOol002io
oc007b]oo`00<Goo;00O;7oo000cOolX01l^Ool003EoobD07bmoo`00=goo8P0O<7oo000jOolM01lb
Ool003aooaX07c=oo`00?Woo5P0O=Goo0010OolC01lfOol0049ooa007cMoo`00AGoo2`0O>Goo0017
Ool801ljOol004Uoo`D07c]oo`00RGoo0029Ool008Uoo`00RGoo0000\
\>"],
  ImageRangeCache->{{{-93.3125, 231.188}, {159.188, 0}} -> {-0.904451, \
-1.04426, 0.0163998, 0.0163998}}]
}, Open  ]],

Cell[TextData[{
  "The result shows that the original hexagon is rotated by an angle of \
\[Pi]/5. Having the function ",
  StyleBox["Rotation[]", "MmaText"],
  " available, we are able to check the group properties of a group. Let us \
start by testing if the two rotations commute. If we assume that the first \
rotation ",
  Cell[BoxData[
      \(TraditionalForm\`R\_1\)]],
  " rotates the hexagon through an angle \[Dash]\[Pi]/3 and the second ",
  Cell[BoxData[
      \(TraditionalForm\`R\_2\)]],
  " through an angle \[Dash]\[Pi]/4, we can combine the rotations either by ",
  
  Cell[BoxData[
      \(TraditionalForm\`\(R\_1\ \[CirclePlus]\ R\_2\ \)\)]],
  "or ",
  Cell[BoxData[
      \(TraditionalForm\`R\_2\ \[CirclePlus]\ R\_1\)]],
  ". These two mathematical relations are realized in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by the following lines. The result of the two different sequences of \
rotations is shown in the following:"
}], "Text",
  Evaluatable->False,
  CellTags->"hexagon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\n
        \t\t{Graphics[{RGBColor[0, 0, 1], \n\t\t\t\t\t
              Rotation[Rotation[hexagon, \[Pi]\/3], \(-\(\[Pi]\/4\)\)]}, \n
            \t\t\t\tAspectRatio \[Rule] Automatic], \n\t\t\t
          Graphics[{RGBColor[1, 0, 0], \n\t\t\t\t\t
              Rotation[Rotation[hexagon, \(-\(\[Pi]\/4\)\)], \[Pi]\/3]}, \n
            \t\t\t\tAspectRatio \[Rule] Automatic]}]]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.492989 0.5 0.492989 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.97619 .37241 m
.8486 .8486 L
.37241 .97619 L
.02381 .62759 L
.1514 .1514 L
.62759 .02381 L
.97619 .37241 L
F
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.492989 0.5 0.492989 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.97619 .37241 m
.8486 .8486 L
.37241 .97619 L
.02381 .62759 L
.1514 .1514 L
.62759 .02381 L
.97619 .37241 L
F
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{207, 108},
  ImageMargins->{{56.5, 0}, {0, 0}},
  ImageRegion->{{-0.030588, 1.02823}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000420000Qa000`40O003h00Oogoo0goo003oOol3
Ool00?moo`=oo`00ogoo0goo003oOol3Ool00?moo`=oo`00ogoo0goo003oOol3Ool00?moo`=oo`00
ogoo0goo001:Ool301n5Ool3O00]Ool004Ioo`P07h1oo`Ql02aoo`00@Woo3@0ONgoo3G`0:goo000n
OolB01mfOolBO00ZOol003YooaL07g5ooaMl02Uoo`00=Woo700OK7oo77`0:7oo000bOolQ01mWOolQ
O00WOol002ioobH07f9oobIl02Ioo`00:Woo:`0OGGoo:g`09Goo000VOol`01mHOol`O00TOol0029o
ocD07e=oocEl02=oo`007Woo>P0OCWoo>W`08Woo000JOolo01m9OoloO00QOol001Iood@07dAoodAl
021oo`004GooBP0O?WooBW`07goo000AOom;01lmOom;O00NOol0011oodd07c]oodel01eoo`0047oo
CP0O>WooCW`077oo000@Oom?01liOom?O00KOol0011ooe007cQooe1l01Yoo`003gooDP0O=WooDW`0
6Goo000?OomC01leOomCO00HOol000mooe@07cAooeAl01Moo`003gooE@0O<gooEG`05Woo000>OomG
01laOomGO00EOol000iooeP07c1ooeQl01Aoo`003WooF@0O;gooFG`04goo000=OomK01l]OomKO00B
Ool000eooe`07baooeal015oo`003GooG@0O:gooGG`047oo000=OomN01lZOomNO00?Ool000aoof00
7bQoof1l00ioo`0037ooH@0O9gooHG`03Goo000<OomR01lVOomRO00<Ool000aoof<07bEoof=l00]o
o`002gooI@0O8gooIG`02Woo000;OomV01lROomVO009Ool000]oofL07b5oofMl00Qoo`002WooJ@0O
7gooJG`01goo000:OomZ01lNOomZO006Ool000Yoof/07aeoof]l00Eoo`002WooK00O77ooK7`017oo
0009Oom^01lJOom^O003Ool000Uoofh07aYoofil00=oo`002GooK@0O6gooKG`017oo0009Oom]01lK
Oom]O004Ool000Qoofh07aYoofil00Aoo`0027ooKP0O6WooKW`017oo0008Oom]01lKOom]O005Ool0
00Qoofd07a]oofel00Eoo`001gooKP0O6WooKW`01Goo0007Oom^01lJOom^O005Ool000Moofd07a]o
ofel00Ioo`001WooKP0O6WooKW`01Woo0006Oom^01lJOom^O006Ool000Ioofd07a]oofel00Moo`00
1WooK@0O6gooKG`01goo0005Oom^01lJOom^O007Ool000Eoofh07aYoofil00Moo`001GooK@0O6goo
KG`027oo0005Oom]01lKOom]O008Ool000Aoofh07aYoofil00Qoo`0017ooKP0O6WooKW`027oo0004
Oom]01lKOom]O009Ool000=oofh07aYoofil00Uoo`000gooKP0O6WooKW`02Goo0003Oom]01lKOom]
O00:Ool000=oofd07a]oofel00Yoo`000WooKP0O6WooKW`02Woo0002Oom^01lJOom^O00:Ool0009o
ofd07a]oofel00]oo`000WooK@0O6gooKG`02goo00000goo01l07`1/01lJOom^O00;Ool00003Ool0
7`0O06`07aYoofil00]oo`000WooK00O77ooK7`037oo0003Oom[01lMOom[O00<Ool000AoofX07aio
ofYl00aoo`001GooJ@0O7gooJG`037oo0006OomW01lQOomWO00=Ool000MoofH07b9oofIl00eoo`00
27ooI@0O8gooIG`03Goo0009OomS01lUOomSO00>Ool000Yoof807bIoof9l00ioo`002gooH@0O9goo
HG`03Woo000<OomP01lXOomPO00>Ool000eooeh07bYooeil00moo`003WooG@0O:gooGG`03goo000?
OomL01l/OomLO00?Ool0011ooe/07beooe]l00moo`004GooF@0O;gooFG`047oo000BOomH01l`OomH
O00@Ool001=ooeL07c5ooeMl011oo`0057ooE@0O<gooEG`04Goo000EOomD01ldOomDO00AOol001Io
oe<07cEooe=l015oo`005gooDP0O=WooDW`04Goo000HOom@01lhOom@O00BOol001Uoodl07cUoodml
019oo`006WooCP0O>WooCW`04Woo000KOom=01lkOom=O00BOol001aood/07ceood]l01=oo`007Goo
BP0O?WooBW`04goo000NOom701m1Oom7O00EOol001mood807dIood9l01Uoo`0087oo?@0OBgoo?G`0
7Goo000QOolh01m@OolhO00QOol0029ooc<07eEooc=l02Eoo`008goo;P0OFWoo;W`0:Goo000TOolY
01mOOolYO00]Ool002Eoob@07fAoobAl035oo`009Woo7`0OJGoo7g`0=Goo000WOolJ01m^OolJO00i
Ool002QooaD07g=ooaEl03eoo`00:Goo400ON7oo47`0@Goo000ZOol;01mmOol;O015Ool002]oo`H0
7h9oo`Il04Uoo`00ogoo0goo003oOol3Ool00?moo`=oo`00ogoo0goo003oOol3Ool00?moo`=oo`00
ogoo0goo003oOol3Ool00?moo`=oo`00\
\>"],
  ImageRangeCache->{{{-7.875, 265}, {134, 0}} -> {0.0105948, -0.039436, \
0.0096199, 0.0096199}, {{-1.375, 122.375}, {128.875, 5.125}} -> {-0.991693, \
-1.09824, 0.0204895, 0.0204895}, {{134.75, 258.5}, {128.875, 5.125}} -> \
{-3.223, -1.09824, 0.0204895, 0.0204895}}]
}, Open  ]],

Cell[TextData[{
  "The result of the two sequences of rotations is the same. Thus, we \
conclude  from this graphical experiment that these two rotations in the \
plane commute. The net effect of the two rotations is a total rotation \
through an angle of \[Pi]/12. To illustrate the non-commutative property of \
rotations in higher dimensions, let us examine rotations in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". For example, let ",
  Cell[BoxData[
      \(TraditionalForm\`R\_Z\)]],
  " be a rotation through an angle \[Pi]/5 about the ",
  StyleBox["z",
    FontSlant->"Italic"],
  "-axis and ",
  Cell[BoxData[
      \(TraditionalForm\`R\_X\)]],
  " a rotation through \[Pi]/7 about the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axis. The geometrical object we will rotate is again a hexagon located in \
the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  "-plane. The polygon in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is represented in three dimensions by"
}], "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],

Cell[BoxData[
    \(\(hexagon = 
      Polygon[Table[{Cos[i], Sin[i], 0}, \n
          \t\t\t{i, 0, 2\ \[Pi], \(2\ \[Pi]\)\/6}]]; \)\)], "Input"],

Cell[TextData[{
  "with its ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " coordinate set equal to zero. The hexagon is displayed in three \
dimensions by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics3D[{RGBColor[1.000, 0.000, 0.000], \n\t\t\thexagon}], 
      AspectRatio \[Rule] Automatic]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08923 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0587749 1.1548 0 1.1548 [
[ 0 0 0 0 ]
[ 1 1.08923 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.086 .2508 m
0 .83357 L
s
0 .83357 m
.36329 1.08923 L
s
.36329 1.08923 m
.38526 .55596 L
s
.38526 .55596 m
.086 .2508 L
s
.69385 0 m
.92501 .37666 L
s
.92501 .37666 m
1 .94081 L
s
1 .94081 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.086 .2508 m
0 .83357 L
s
0 .83357 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.69385 0 m
.086 .2508 L
s
.38526 .55596 m
.92501 .37666 L
s
.92501 .37666 m
1 .94081 L
s
1 .94081 m
.36329 1.08923 L
s
.36329 1.08923 m
.38526 .55596 L
s
0 0 m
1 0 L
1 1.08923 L
0 1.08923 L
closepath
clip
newpath
.5 Mabswid
.51042 .75567 m .23836 .66713 L p .83093 .47741 L .656 .751 .92 r
F P
0 g
s
.83093 .47741 m .78886 .6755 L .51042 .75567 L p .656 .751 .92 r
F P
0 g
s
.23836 .66713 m .21425 .46691 L p .83093 .47741 L .656 .751 .92 r
F P
0 g
s
.21425 .46691 m .52892 .35349 L .83093 .47741 L p .656 .751 .92 r
F P
0 g
s
.25 Mabswid
.69385 0 m
.92501 .37666 L
s
.92501 .37666 m
1 .94081 L
s
1 .94081 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.086 .2508 m
0 .83357 L
s
0 .83357 m
.73385 .612 L
s
.73385 .612 m
.69385 0 L
s
.69385 0 m
.086 .2508 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{300, 143},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000/Q000`40O003h00OfGoo0P00W7oo003G
Ool200000goo0000002KOol00=Aoo`<000=oo`8009]oo`00dWoo0P001Woo00<007oo0000VWoo003@
Ool20008Ool00`00Ool0002JOol00<eoo`<000Yoo`04001oogoo002IOol00<]oo`8000eoo`05001o
ogooOol0002HOol00<Qoo`<000moo`05001oogooOol0002HOol00<Ioo`8001=oo`05001oogooOol0
002GOol00<Aoo`8001Eoo`03001oogoo009oo`03001oogoo09Aoo`00`Goo0`005goo00<007ooOol0
0Woo00<007ooOol0U7oo002oOol2000JOol00`00Oomoo`03Ool00`00Oomoo`2COol00;aoo`<001ao
o`03001oogoo00=oo`03001oogoo09=oo`00^Woo0P007goo00<007ooOol017oo00<007ooOol0TWoo
002gOol3000QOol00`00Oomoo`05Ool00`00Oomoo`2AOol00;Eoo`8002Aoo`03001oogoo00Eoo`03
001oogoo095oo`00/goo0P009Woo00<007ooOol01Woo00<007ooOol0T7oo002`Ool3000XOol00`00
Oomoo`07Ool00`00Oomoo`2?Ool00:ioo`8002]oo`03001oogoo00Moo`03001oogoo08moo`00Zgoo
0`00;Goo00<007ooOol027oo00<007ooOol0SWoo002YOol2000`Ool00`00Oomoo`08Ool00`00Oomo
o`2>Ool00:Moo`80039oo`03001oogoo00Uoo`03001oogoo08eoo`00Y7oo0`00=Goo00<007ooOol0
2Goo00<007ooOol0S7oo002ROol2000hOol00`00Oomoo`09Ool00`00Oomoo`2<Ool009moo`<003Yo
o`03001oogoo00Yoo`03001oogoo08]oo`00WGoo0P00?Goo00<007ooOol02goo00<007ooOol0RWoo
002KOol2000oOol00`00Oomoo`0;Ool00`00Oomoo`2:Ool009Qoo`<0045oo`03001oogoo00aoo`03
001oogoo08Uoo`00UWoo0P00A7oo00<007ooOol037oo00<007ooOol0RGoo002COol30016Ool00`00
Oomoo`0=Ool00`00Oomoo`28Ool0095oo`8004Uoo`03001oogoo00ioo`03001oogoo08Moo`00SWoo
0`00Bgoo00<007ooOol03Woo00<007ooOol0Qgoo002<Ool2001>Ool00`00Oomoo`0?Ool00`00Oomo
o`26Ool008Yoo`80051oo`03001oogoo011oo`03001oogoo08Eoo`00Qgoo0`00DWoo00<007ooOol0
47oo00<007ooOol0QGoo0025Ool2001EOol00`00Oomoo`0AOol00`00Oomoo`24Ool0089oo`<005Qo
o`03001oogoo011oo`03001oogoo08Aoo`00P7oo0P00Fgoo00<007ooOol04Goo00<007ooOol0Pgoo
001nOol2001MOol00`00Oomoo`0BOol00`00Oomoo`22Ool007]oo`<005moo`03001oogoo019oo`03
001oogoo089oo`00NGoo0P00HWoo00<007ooOol04goo00<007ooOol0PGoo001gOol2001TOol00`00
Oomoo`0DOol00`00Oomoo`20Ool007Moo`8006Aoo`03001oogoo01Aoo`03001oogoo081oo`00Mgoo
00<007oo0000Hgoo00<007ooOol05Goo00<007ooOol0Ogoo001gOol01000Oomoo`00HWoo00<007oo
Ool05Goo00<007ooOol0Ogoo001fOol00`00Oomoo`02Ool00`00Oomoo`1OOol00`00Oomoo`0FOol0
0`00Oomoo`1nOol007Ioo`03001oogoo00=oo`03001oogoo05ioo`03001oogoo01Moo`03001oogoo
07eoo`00MWoo00<007ooOol017oo00<007ooOol0GGoo00<007ooOol05goo00<007ooOol0OGoo001f
Ool00`00Oomoo`05Ool00`00Oomoo`1LOol00`00Oomoo`0HOol00`00Oomoo`1lOol007Ioo`03001o
ogoo00Ioo`03001oogoo05]oo`03001oogoo01Uoo`03001oogoo07]oo`00MWoo00<007ooOol01goo
00<007ooOol0FWoo00<007ooOol06Goo00<007ooOol0Ngoo001fOol00`00Oomoo`08Ool00`00Oomo
o`1JOol00`00Oomoo`0IOol00`00Oomoo`1jOol007Eoo`03001oogoo00Yoo`03001oogoo05Uoo`03
001oogoo01Uoo`03001oogoo07Yoo`00MGoo00<007ooOol02goo00<007ooOol0F7oo00<007ooOol0
6Woo00<007ooOol0NGoo001eOol00`00Oomoo`0<Ool00`00Oomoo`1GOol00`00Oomoo`0KOol00`00
Oomoo`1hOol007Eoo`03001oogoo00eoo`03001oogoo05Ioo`03001oogoo01]oo`03001oogoo07Qo
o`00MGoo00<007ooOol03Woo00<007ooOol0EGoo00<007ooOol077oo00<007ooOol0Mgoo001eOol0
0`00Oomoo`0?Ool00`00Oomoo`0dOol3000MOol00`00Oomoo`0MOol00`00Oomoo`1fOol007Aoo`03
001oogoo015oo`03001oogoo031oo`<00003D_aBoE;l008001]oo`03001oogoo01eoo`03001oogoo
07Ioo`00M7oo00<007ooOol04Woo00<007ooOol0;Goo0P0000QBo5;mC_aBoE;lD_e>o5;m0P006Goo
00<007ooOol07Woo00<007ooOol0MGoo001dOol00`00Oomoo`0COol00`00Oomoo`0YOol300001E;m
D_aBo5;lD_d00e;l00ABoE;lD_aBo0<001Ioo`03001oogoo01ioo`03001oogoo07Eoo`00M7oo00<0
07ooOol057oo00<007ooOol09Goo0`00019BoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_`2000DOol00`00Oomoo`0NOol2001fOol007Aoo`03001oogoo01Eoo`03001oogoo029oo`800005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009Bo0<0015oo`03001oogoo
01]oo`<00003Ool007oo07Eoo`00M7oo00<007ooOol05Woo00<007ooOol07Woo0`0001a>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBo@8000moo`03001o
ogoo01Qoo`<000Aoo`03001oogoo07Aoo`00M7oo00<007ooOol05goo00<007ooOol06Woo0`000e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00IBoE;lD_aBo5;m
D_`2000=Ool00`00Oomoo`0EOol30007Ool00`00Oomoo`1dOol007=oo`03001oogoo01Uoo`03001o
ogoo01Moo`80000VC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBo@<000]oo`03001oogoo015oo`<000]oo`03001oogoo
07=oo`00Lgoo00<007ooOol06Woo00<007ooOol04goo0`000U;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
0e;m00000009Ool00`00Oomoo`0>Ool3000>Ool00`00Oomoo`1cOol007=oo`03001oogoo01]oo`03
001oogoo00moo`<0000`D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl0P001goo00<0
07ooOol02goo0`004Goo00<007ooOol0Lgoo001cOol00`00Oomoo`0LOol00`00Oomoo`0<Ool20002
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mD_aBo0030004Ool00`00Oomo
o`08Ool3000DOol00`00Oomoo`1cOol007=oo`03001oogoo01eoo`03001oogoo00Qoo`<0000jD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_d20002Ool0
0`00Oomoo`05Ool3000GOol00`00Oomoo`1cOol007=oo`03001oogoo01ioo`03001oogoo00Aoo`<0
0003D_aBoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`00e;mD_`000020004Ool3000JOol00`00Oomoo`1cOol007=oo`03001oogoo01moo`04001o
ogooOol20000A5;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_d5000MOol00`00Oomoo`1cOol0079oo`03001oogoo025o
o`<00005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00UBoE;lD_aBo5;mD_`005;lD_d00P007Goo00<007ooOol0Lgoo001bOol00`00
Oomoo`0NOol30000CU;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m001BoE;lD_e>o0<001]oo`03001o
ogoo079oo`00LWoo00<007ooOol077oo0P0000EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o00000=Bo004D_eBo5;lD_`2000IOol00`00Oomoo`1bOol0079oo`03001oogoo01Uoo`<0001HC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m001BoDklD_eBo5;mC_aBoE;lD_d3000FOol0
0`00Oomoo`1bOol0079oo`03001oogoo01Moo`8000=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo009
D_eBo5;lD_aBoE;l001Bo5;m00=Bo005D_eBo5;lD_aBo@02D_`2000DOol00`00Oomoo`1bOol0079o
o`03001oogoo01Moo`1R001Bo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
o@00D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo080019oo`03001oogoo079oo`00LWoo00<007oo
Ool05goo00@005;lD_aBo@=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_`00003D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m0080011oo`03001oogoo079oo`00LGoo00<007ooOol0
67oo06H004klD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_`004klD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m000@Ool00`00Oomoo`1bOol0075oo`03001oogoo01Qo
o`03001BoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@02D_`00`00D_eB
o002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo000011oo`03001oogoo079oo`00LGoo00<007oo
Ool06Goo06@005;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl001Bo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_`0019oo`03001oogoo075oo`00LGoo00<007ooOol06Goo
00<005;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00IBoE;lD_aBo5;m0002D_`01E;mD_aB
o5;lD_d00e;l00IBoE;lD_aBo5;m000BOol00`00Oomoo`1aOol0075oo`03001oogoo01Uoo`1T001B
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo000C_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;l000BOol00`00Oomoo`1aOol0075oo`03001oogoo01Uoo`05001Bo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo000D_d00e;l00EBoE;lD_aBo5;m00=B
o004D_eBo5;l000BOol00`00Oomoo`1aOol0075oo`03001oogoo01Uoo`1S001BoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o000D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
o@0001=oo`03001oogoo075oo`00L7oo00<007ooOol06Woo00<005;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00IBoE;lD_aBo5;m0002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo00001=o
o`03001oogoo075oo`00L7oo00<007ooOol06Woo06<005;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;l001>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m00004goo00<007oo
Ool0LGoo001`Ool00`00Oomoo`0JOol01@00D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_`005;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mD_`0000DOol00`00Oomoo`1`Ool0
071oo`03001oogoo01]oo`1R001>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_`005;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_d001Aoo`03001oogoo071oo`00L7oo00<007oo
Ool06goo00<005;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00IBoE;lD_aBo5;m0002D_`0
1E;mD_aBo5;lD_d00e;l00ABoE;lD_`001Eoo`03001oogoo071oo`00L7oo00<007ooOol06goo0640
05;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo000C_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_`0000EOol00`00Oomoo`1`Ool006moo`03001oogoo01aoo`04001Bo5;lD_d3D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo000D_d00e;l00EBoE;lD_aBo5;m00=Bo003D_d0
07oo01Aoo`03001oogoo071oo`00Kgoo00<007ooOol077oo064004klD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m001BoDklD_eBo5;mC_aBoE;lD_e>o5;mD_`0000EOol00`00
Oomoo`1`Ool006moo`03001oogoo01aoo`03001BoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o009D_eBo5;lD_aBoE;l001Bo5;m00=Bo007D_eBo5;lD_aBoE;l00005Woo00<007ooOol0L7oo001_
Ool00`00Oomoo`0LOol0H000D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_d005;mD_aBoDklD_eBo5;mC_aBoE;lD_d001Ioo`03001oogoo071oo`00Kgoo00<007ooOol077oo
00@005;lD_aBo@=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_`00003D_`01E;mD_aB
o5;lD_d00e;l00<007ooOol05Goo00<007ooOol0Kgoo001_Ool00`00Oomoo`0MOol0G`00D_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m001BoDklD_eBo5;mC_aBoE;lD_e>o5;m
00005goo00<007ooOol0Kgoo001_Ool00`00Oomoo`0MOol01@00D_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;l001Bo5;m00=Bo007D_eBo5;lD_aBoE;l00005goo00<007ooOol0
Kgoo001^Ool00`00Oomoo`0NOol0GP00D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;m001BoE;lD_e>o5;mD_aBoDklD_eBo00067oo00<007ooOol0Kgoo001^Ool00`00Oomoo`0N
Ool00`00D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mD_aBo0020003D_`01E;mD_aB
o5;lD_d00U;l00<007ooOol05Woo00<007ooOol0Kgoo001^Ool00`00Oomoo`0NOol0C@00D_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_`0100000eBoE;l001>o5;mD_aBoDklD_eBo5;mC_`0000H
Ool00`00Oomoo`1_Ool006ioo`03001oogoo01ioo`05001Bo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo003D_eB
o000008000=Bo005D_eBo5;lD_`00003D_`01U;mD_aBo5;lD_d001Qoo`03001oogoo06moo`00KWoo
00<007ooOol07Woo04L005;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl00<0000DC_aBoE;lD_e>o5;mD_aBoDkl
D_d005;mC_aBoE;lD_e>o5;mD_`001Qoo`03001oogoo06moo`00KWoo00<007ooOol07Woo00<005;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@040003D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_`005;m00=Bo003D_eBo00001Yo
o`03001oogoo06ioo`00KWoo00<007ooOol07goo03l005;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_d00`0001YBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBo@00D_e>o5;mD_aBo@006Woo00<007ooOol0KWoo001]Ool00`00
Oomoo`0POol01000D_aBo5;m0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00<00005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009B
o003001BoE;l009Bo003001oogoo01Qoo`03001oogoo06ioo`00KGoo00<007ooOol087oo03P004kl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l1000021BoDklD_eB
o5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_d005;mC_aBo@006Woo
00<007ooOol0KWoo001]Ool00`00Oomoo`0POol00`00D_eBo002D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`300000e;lD_eBo002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01U;mD_`005;lD_d001]oo`03001oogoo06ioo`00KGoo00<007oo
Ool087oo0P00031BoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aB
oDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_`300009U;lD_e>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_`005;l000KOol00`00Oomoo`1^Ool006eoo`03001oogoo029oo`<0009Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00U;l100000=Bo5;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo004D_eBo000000KOol00`00Oomoo`1^Ool006eoo`03001o
ogoo02Eoo`<0000SD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBo@0300009e;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBo@0400000goo001oo`0K
Ool00`00Oomoo`1]Ool006eoo`03001oogoo02Qoo`@00003D_aBoE;l009Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009Bo0<0009Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00`00
1Woo00<007ooOol06Goo00<007ooOol0KGoo001/Ool00`00Oomoo`0]Ool300005DklD_eBo5;mC_aB
oE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o00400009U;mD_aBoDklD_eBo5;mC_aBoE;lD_e>
o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_`4000:Ool0
0`00Oomoo`0HOol00`00Oomoo`1]Ool006aoo`03001oogoo031oo`<00003D_aBoE;l009Bo005D_eB
o5;lD_aBo@03D_`00e;mD_`000020003D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00ABoE;lD_aBo0<000ioo`03001oogoo01Qoo`03
001oogoo06eoo`00K7oo00<007ooOol0<goo0`0000U>o5;mD_aBoDklD_eBo5;mC_`00`0002I>o5;m
D_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;m
C_aBoE;lD_e>o5;m10004Woo00<007ooOol05goo00<007ooOol0KGoo001/Ool00`00Oomoo`0fOol3
00000e;lD_d000030003D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lD_`00`005goo00<007ooOol05Woo00<007ooOol0KGoo
001/Ool00`00Oomoo`0hOol400009DklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;l
D_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_e>o5;mD_aBoDkl00@001]oo`03001oogoo01Eoo`03001o
ogoo06eoo`00K7oo00<007ooOol0=Goo10000goo0`0000=Bo5;mD_`00U;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=Bo@0000000P0087oo00<007ooOol057oo
00<007ooOol0KGoo001/Ool00`00Oomoo`0aOol40003Ool00`00Oomoo`04Ool400005e;mD_aBoDkl
D_eBo5;mC_aBoE;lD_e>o5;mD_aBoDklD_eBo5;mC_aBoE;lD_d00`0097oo00<007ooOol05Goo00<0
07ooOol0K7oo001[Ool00`00Oomoo`0_Ool30007Ool00`00Oomoo`08Ool300001E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo0@002Qoo`03001oogoo01Aoo`03001oogoo06aoo`00Jgoo00<007oo
Ool0;7oo0`002Woo00<007ooOol02goo0`0000YBoE;lD_e>o5;mD_aBoDklD_eBo0<002eoo`03001o
ogoo01=oo`03001oogoo06aoo`00Jgoo00<007ooOol0:7oo10003Goo00<007ooOol03Woo0`0000=B
oE;lD_`01000<Goo00<007ooOol04Woo00<007ooOol0K7oo001[Ool00`00Oomoo`0UOol3000@Ool0
0`00Oomoo`0BOol3000fOol00`00Oomoo`0AOol00`00Oomoo`1/Ool006]oo`03001oogoo029oo`<0
01=oo`03001oogoo04]oo`03001oogoo015oo`03001oogoo06aoo`00Jgoo00<007ooOol07Woo1000
5Woo00<007ooOol0C7oo00<007ooOol047oo00<007ooOol0K7oo001ZOol00`00Oomoo`0LOol3000J
Ool00`00Oomoo`1=Ool00`00Oomoo`0?Ool00`00Oomoo`1/Ool006Yoo`03001oogoo01Uoo`<001eo
o`03001oogoo04ioo`03001oogoo00moo`03001oogoo06]oo`00JWoo00<007ooOol05Goo100087oo
00<007ooOol0Cgoo00<007ooOol03Woo00<007ooOol0Jgoo001ZOol00`00Oomoo`0BOol3000TOol0
0`00Oomoo`1@Ool00`00Oomoo`0=Ool00`00Oomoo`1[Ool006Yoo`03001oogoo00moo`<002Moo`03
001oogoo051oo`03001oogoo00eoo`03001oogoo06]oo`00JWoo00<007ooOol02goo1000:Woo00<0
07ooOol0DGoo00<007ooOol037oo00<007ooOol0Jgoo001ZOol00`00Oomoo`08Ool3000^Ool00`00
Oomoo`1BOol00`00Oomoo`0;Ool00`00Oomoo`1[Ool006Uoo`03001oogoo00Ioo`<0035oo`03001o
ogoo05=oo`03001oogoo00Yoo`03001oogoo06]oo`00JGoo00<007ooOol00Woo1000=7oo00<007oo
Ool0E7oo00<007ooOol02Woo00<007ooOol0JWoo001YOol00`00Ool00002000hOol00`00Oomoo`1D
Ool00`00Oomoo`0:Ool00`00Oomoo`1ZOol006Uoo`8003]oo`03001oogoo05Eoo`03001oogoo00Uo
o`03001oogoo06Yoo`00JWoo0P00>Woo00<007ooOol0EWoo00<007ooOol027oo00<007ooOol0JWoo
001/Ool00`00Oomoo`0gOol00`00Oomoo`1GOol00`00Oomoo`07Ool00`00Oomoo`1ZOol006eoo`80
03Moo`03001oogoo05Qoo`03001oogoo00Ioo`03001oogoo06Yoo`00Kgoo00<007ooOol0=7oo00<0
07ooOol0F7oo00<007ooOol01Woo00<007ooOol0JWoo001`Ool00`00Oomoo`0cOol00`00Oomoo`1I
Ool00`00Oomoo`05Ool00`00Oomoo`1ZOol0075oo`8003=oo`03001oogoo05Yoo`03001oogoo00Eo
o`03001oogoo06Uoo`00Lgoo00<007ooOol0<7oo00<007ooOol0Fgoo00<007ooOol017oo00<007oo
Ool0JGoo001dOol2000`Ool00`00Oomoo`1LOol00`00Oomoo`03Ool00`00Oomoo`1YOol007Ioo`03
001oogoo02aoo`03001oogoo05ioo`03001oogoo009oo`03001oogoo06Uoo`00Mgoo0P00;7oo00<0
07ooOol0GWoo00<007ooOol00Woo00<007ooOol0JGoo001iOol00`00Oomoo`0YOol00`00Oomoo`1O
Ool01@00Oomoogoo0000Jgoo001jOol00`00Oomoo`0XOol00`00Oomoo`1POol01000Oomoo`00Jgoo
001kOol2000XOol00`00Oomoo`1QOol00`00Ool0001[Ool007eoo`03001oogoo02Eoo`03001oogoo
069oo`03001oo`0006Yoo`00OWoo0P009Goo00<007ooOol0HWoo00<007oo0000JWoo0020Ool00`00
Oomoo`0ROol00`00Oomoo`1SOol2001ZOol0085oo`80029oo`03001oogoo069oo`<006Yoo`00Pgoo
00<007ooOol07goo00<007ooOol0GWoo1000KGoo0024Ool2000OOol00`00Oomoo`1JOol4001aOol0
08Ioo`03001oogoo01aoo`03001oogoo05Eoo`D007Eoo`00Qgoo00<007ooOol06goo00<007ooOol0
DGoo1000NWoo0028Ool2000KOol00`00Oomoo`1=Ool4001nOol008Yoo`03001oogoo01Qoo`03001o
ogoo04Qoo`D0089oo`00Rgoo0P0067oo00<007ooOol0A7oo1000Qgoo002=Ool00`00Oomoo`0EOol0
0`00Oomoo`10Ool4002;Ool008ioo`8001Eoo`03001oogoo03]oo`D008moo`00T7oo00<007ooOol0
4Woo00<007ooOol0=goo1000U7oo002AOol2000BOol00`00Oomoo`0cOol4002HOol009=oo`03001o
ogoo00moo`03001oogoo02ioo`D009aoo`00U7oo00<007ooOol03Woo00<007ooOol0:Woo1000XGoo
002EOol2000=Ool00`00Oomoo`0WOol4002UOol009Moo`03001oogoo00Yoo`03001oogoo029oo`D0
0:Uoo`00V7oo0P002Woo00<007ooOol07Woo1000[Woo002JOol00`00Oomoo`07Ool00`00Oomoo`0J
Ool4002bOol009]oo`8000Moo`03001oogoo01Eoo`D00;Ioo`00WGoo00<007ooOol017oo00<007oo
Ool04Goo1000^goo002NOol00`00Oomoo`03Ool00`00Oomoo`0=Ool4002oOol009moo`8000=oo`03
001oogoo00Qoo`D00<=oo`00XGoo00@007ooOol000Ioo`@00<Qoo`00XWoo0`000Woo1000c7oo002T
Ool3003@Ool00001\
\>"],
  ImageRangeCache->{{{0, 374}, {177.75, 0}} -> {-0.508433, -1.50818*^-16, \
0.00663305, 0.00663305}}]
}, Open  ]],

Cell[TextData[{
  "To carry out the rotations about the three coordinate axes, we define \
three functions, ",
  StyleBox["RotationX[]", "MmaText"],
  ", ",
  StyleBox["RotationY[]", "MmaText"],
  ", and ",
  StyleBox["RotationZ[], ", "MmaText"],
  "in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The arguments are again the geometrical object and the angle of rotation \
with respect to the denoted axis."
}], "Text",
  Evaluatable->False,
  CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}],

Cell[BoxData[{
    \(\(Clear[RotationX, RotationY, RotationZ]; \)\), 
    \(RotationZ[polygon_Polygon, angle_] := \n\t
      Block[{points, mat1, mat2}, \n\t\t
        points = polygon /. Polygon[x___] \[Rule] x; \n\t\t
        mat1 = RotationMatrix2D[angle]; \n\t\tmat2 = IdentityMatrix[3]; \n\t\t
        mat2\[LeftDoubleBracket]1, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]2, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]1, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 2\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]2, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 2\[RightDoubleBracket]; \n\t\t
        Polygon[\((mat2 . #1&)\)/@points]]; \n\n
    RotationX[polygon_Polygon, angle_] := \n\t
      Block[{points, mat1, mat2}, \n\t\t
        points = polygon /. Polygon[x___] \[Rule] x; \n\t\t
        mat1 = RotationMatrix2D[angle]; \n\t\tmat2 = IdentityMatrix[3]; \n\t\t
        mat2\[LeftDoubleBracket]2, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]2, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 2\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 2\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 2\[RightDoubleBracket]; \n\t\t
        Polygon[\((mat2 . #1&)\)/@points]]; \n\n
    RotationY[polygon_Polygon, angle_] := \n\t
      Block[{points, mat1, mat2}, \n\t\t
        points = polygon /. Polygon[x___] \[Rule] x; \n\t\t
        mat1 = RotationMatrix2D[angle]; \n\t\tmat2 = IdentityMatrix[3]; \n\t\t
        mat2\[LeftDoubleBracket]1, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]1, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]1, 2\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 1\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 1\[RightDoubleBracket]; \n\t\t
        mat2\[LeftDoubleBracket]3, 3\[RightDoubleBracket] = 
          mat1\[LeftDoubleBracket]2, 2\[RightDoubleBracket]; \n\t\t
        Polygon[\((mat2 . #1&)\)/@points]]\)}], "Input"],

Cell[TextData[{
  "The two rotations about the ",
  StyleBox["z",
    FontSlant->"Italic"],
  "- and ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axes mentioned above are graphically represented by the following lines:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\n
        \t\t{Graphics3D[\n\t\t\t\t
            RotationX[RotationZ[hexagon, \[Pi]\/5], \[Pi]\/7], \n\t\t\t\t
            AspectRatio \[Rule] Automatic, \n\t\t\t\t
            ViewPoint \[Rule] {1.300, \(-2.400\), 2.000}], \n\t\t\t
          Graphics3D[\n\t\t\t\t
            RotationZ[RotationX[hexagon, \[Pi]\/7], \[Pi]\/5], \n\t\t\t\t
            AspectRatio \[Rule] Automatic, \n\t\t\t\t
            ViewPoint \[Rule] {1.300, \(-2.400\), 2.000}]}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .4022 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00957617 0.47619 [
[ 0 0 0 0 ]
[ 1 .4022 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .4022 L
0 .4022 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00957617 0.477324 0.392623 MathSubStart
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.04801 -0.0517306 1.04801 [
[ 0 0 0 0 ]
[ 1 .84462 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04344 .25483 m
0 .53173 L
s
0 .53173 m
.3931 .84462 L
s
.3931 .84462 m
.40209 .59363 L
s
.40209 .59363 m
.04344 .25483 L
s
.69004 0 m
.96388 .42236 L
s
.96388 .42236 m
1 .68765 L
s
1 .68765 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.04344 .25483 m
0 .53173 L
s
0 .53173 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.69004 0 m
.04344 .25483 L
s
.40209 .59363 m
.96388 .42236 L
s
.96388 .42236 m
1 .68765 L
s
1 .68765 m
.3931 .84462 L
s
.3931 .84462 m
.40209 .59363 L
s
0 0 m
1 0 L
1 .84462 L
0 .84462 L
closepath
clip
newpath
.5 Mabswid
.69383 .50115 m .3734 .56977 L p .7192 .3459 L .553 .897 .98 r
F P
0 g
s
.7192 .3459 m .88536 .39501 L .69383 .50115 L p .553 .897 .98 r
F P
0 g
s
.3734 .56977 m .16117 .54985 L p .7192 .3459 L .553 .897 .98 r
F P
0 g
s
.16117 .54985 m .30298 .43469 L .7192 .3459 L p .553 .897 .98 r
F P
0 g
s
.25 Mabswid
.69004 0 m
.96388 .42236 L
s
.96388 .42236 m
1 .68765 L
s
1 .68765 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.04344 .25483 m
0 .53173 L
s
0 .53173 m
.70718 .28993 L
s
.70718 .28993 m
.69004 0 L
s
.69004 0 m
.04344 .25483 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00957617 0.97619 0.392623 MathSubStart
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.05375 -0.0578748 1.05375 [
[ 0 0 0 0 ]
[ 1 .83578 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.038 .24855 m
0 .49767 L
s
0 .49767 m
.41317 .83578 L
s
.41317 .83578 m
.41993 .61033 L
s
.41993 .61033 m
.038 .24855 L
s
.67226 0 m
.96913 .44493 L
s
.96913 .44493 m
1 .68234 L
s
1 .68234 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.038 .24855 m
0 .49767 L
s
0 .49767 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.67226 0 m
.038 .24855 L
s
.41993 .61033 m
.96913 .44493 L
s
.96913 .44493 m
1 .68234 L
s
1 .68234 m
.41317 .83578 L
s
.41317 .83578 m
.41993 .61033 L
s
0 0 m
1 0 L
1 .83578 L
0 .83578 L
closepath
clip
newpath
.5 Mabswid
.69176 .52387 m .37858 .65228 L p .71208 .24009 L .749 .916 .948 r
F P
0 g
s
.71208 .24009 m .87117 .33019 L .69176 .52387 L p .749 .916 .948 r
F P
0 g
s
.37858 .65228 m .16871 .61339 L p .71208 .24009 L .749 .916 .948 r
F P
0 g
s
.16871 .61339 m .31253 .39767 L .71208 .24009 L p .749 .916 .948 r
F P
0 g
s
.25 Mabswid
.67226 0 m
.96913 .44493 L
s
.96913 .44493 m
1 .68234 L
s
1 .68234 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.038 .24855 m
0 .49767 L
s
0 .49767 m
.68504 .25996 L
s
.68504 .25996 m
.67226 0 L
s
.67226 0 m
.038 .24855 L
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{300, 143},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000/Q000`40O003h00OogooN7oo003oOomh
Ool00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00
ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomh
Ool007aoo`800?Uoo`00NWoo0P0000=oo`000000]Goo0P00@Goo001gOol30003Ool2002cOol20000
0goo00000010Ool007Eoo`8000Ioo`03001oo`000:moo`<000=oo`80041oo`00LWoo0`0027oo00@0
07ooOol00:aoo`8000Ioo`03001oo`0003moo`00L7oo0P002goo00@007ooOol00:Uoo`<000Qoo`04
001oogoo000nOol006eoo`<000eoo`05001oogooOol0002UOol3000;Ool01000Oomoo`00?Woo001Z
Ool3000@Ool00`00Oomoo`02Ool00`00Oomoo`2POol2000>Ool01@00Oomoogoo0000?Goo001XOol2
000COol00`00Oomoo`02Ool00`00Oomoo`2MOol3000@Ool00`00Oomoo`02Ool00`00Oomoo`0jOol0
06Eoo`<001Ioo`03001oogoo009oo`03001oogoo09Yoo`8001=oo`03001oogoo009oo`03001oogoo
03Yoo`00Hgoo0P006Goo00<007ooOol00goo00<007ooOol0UWoo0`005Goo00<007ooOol00goo00<0
07ooOol0>Goo001POol3000KOol00`00Oomoo`03Ool00`00Oomoo`2DOol2000HOol00`00Oomoo`04
Ool00`00Oomoo`0hOol005ioo`8001ioo`03001oogoo00Aoo`03001oogoo091oo`<001Yoo`03001o
ogoo00Aoo`03001oogoo03Qoo`00Fgoo0`0087oo00<007ooOol017oo00<007ooOol0SGoo0`007Woo
00<007ooOol017oo00<007ooOol0=goo001IOol2000SOol00`00Oomoo`05Ool00`00Oomoo`2:Ool2
000QOol00`00Oomoo`05Ool00`00Oomoo`0fOol005Ioo`<002Eoo`03001oogoo00Ioo`03001oogoo
08Ioo`<002=oo`03001oogoo00Eoo`03001oogoo03Ioo`00E7oo0P00:7oo00<007ooOol01Woo00<0
07ooOol0Q7oo0P009Woo00<007ooOol01Woo00<007ooOol0=Goo001AOol3000ZOol00`00Oomoo`07
Ool00`00Oomoo`20Ool3000XOol00`00Oomoo`07Ool00`00Oomoo`0dOol004moo`8002eoo`03001o
ogoo00Qoo`03001oogoo07eoo`8002]oo`03001oogoo00Moo`03001oogoo03Aoo`00C7oo0`00;goo
00<007ooOol027oo00<007ooOol0NWoo0`00;Goo00<007ooOol027oo00<007ooOol0<goo001:Ool2
000bOol00`00Oomoo`09Ool00`00Oomoo`1fOol3000`Ool00`00Oomoo`09Ool00`00Oomoo`0bOol0
04Moo`<003Aoo`03001oogoo00Yoo`03001oogoo07=oo`8003=oo`03001oogoo00Uoo`03001oogoo
039oo`00A7oo0`00=goo00<007ooOol02Woo00<007ooOol0L7oo0`00=Goo00<007ooOol02Woo00<0
07ooOol0<Goo0012Ool2000jOol00`00Oomoo`0;Ool00`00Oomoo`1]Ool2000hOol00`00Oomoo`0;
Ool00`00Oomoo`0`Ool003moo`<003aoo`03001oogoo00aoo`03001oogoo06Uoo`<003Yoo`03001o
ogoo00]oo`03001oogoo031oo`00?Goo0P00@7oo00<007ooOol02goo00<007ooOol0Igoo0P00?Goo
00<007ooOol037oo00<007ooOol0;goo000jOol30012Ool00`00Oomoo`0<Ool00`00Oomoo`1SOol3
000oOol00`00Oomoo`0=Ool00`00Oomoo`0^Ool003Qoo`8004Eoo`03001oogoo00eoo`03001oogoo
05moo`<0049oo`03001oogoo00eoo`03001oogoo02ioo`00=Goo0`00Agoo00<007ooOol03Goo00<0
07ooOol0GGoo0P00AGoo00<007ooOol03Woo00<007ooOol0;Goo000cOol2001:Ool00`00Oomoo`0>
Ool00`00Oomoo`1IOol30017Ool00`00Oomoo`0?Ool00`00Oomoo`0/Ool0031oo`<004aoo`03001o
ogoo00moo`03001oogoo05Ioo`8004Yoo`03001oogoo00moo`03001oogoo02aoo`00;Woo0P00Cgoo
00<007ooOol03goo00<007ooOol0Dgoo0`00C7oo00<007ooOol047oo00<007ooOol0:goo000[Ool3
001AOol00`00Oomoo`0@Ool00`00Oomoo`1@Ool2001?Ool00`00Oomoo`0AOol00`00Oomoo`0ZOol0
02Uoo`8005Aoo`03001oogoo015oo`03001oogoo04aoo`<0055oo`03001oogoo015oo`03001oogoo
02Yoo`009Woo0`00EWoo00<007ooOol04Goo00<007ooOol0BGoo0`00E7oo00<007ooOol04Woo00<0
07ooOol0:Goo000TOol2001IOol00`00Oomoo`0BOol00`00Oomoo`16Ool2001HOol00`00Oomoo`0B
Ool00`00Oomoo`0XOol0025oo`<005]oo`03001oogoo01=oo`03001oogoo049oo`<005Yoo`03001o
ogoo019oo`03001oogoo02Qoo`007Woo0`00GWoo00<007ooOol04goo00<007ooOol0@7oo0P00GGoo
00<007ooOol04goo00<007ooOol09goo000LOol2001QOol00`00Oomoo`0DOol00`00Oomoo`0lOol3
001OOol00`00Oomoo`0DOol00`00Oomoo`0VOol001Uoo`<006=oo`03001oogoo01Aoo`03001oogoo
03Yoo`80069oo`03001oogoo01Aoo`03001oogoo02Ioo`005goo0P00IWoo00<007ooOol05Goo00<0
07ooOol0=Woo0`00I7oo00<007ooOol05Goo00<007ooOol09Goo000DOol3001YOol00`00Oomoo`0E
Ool00`00Oomoo`0bOol3001WOol01000Oomoogoo0P004goo00<007ooOol097oo000BOol2001/Ool0
0`00Oomoo`0EOol00`00Oomoo`0`Ool2001ZOol01P00Ool00000GieO_P80015oo`03001oogoo02Ao
o`0047oo0P00KWoo00<007ooOol05Woo00<007ooOol0;Goo0P00Jgoo0`001UnM0P0047oo00<007oo
Ool08goo000@Ool2001^Ool00`00Oomoo`0GOol00`00Oomoo`0/Ool2001YOol2000035nn001O_UnM
GkiKWEnnGieO_U^MGkh0011oo`03001oogoo029oo`0047oo00<007oo0000KGoo00<007ooOol05goo
00<007ooOol0;7oo00<007oo0000IGoo0`000UnM0P002UnM0P003Woo00<007ooOol08Woo000?Ool0
1@00Oomoogoo0000K7oo00<007ooOol067oo00<007ooOol0:goo00@007ooOol0069oo`800003FieO
_P000080000>GkiOW@00FieO_UnMGkiKWEnnGieO_U^MGkiOW@8000eoo`03001oogoo025oo`003goo
00<007ooOol00Woo00<007ooOol0JGoo00<007ooOol06Goo00<007ooOol0:Goo00<007ooOol00Woo
00<007ooOol0G7oo0`0000AOW@00000000EOW@03001OWEnM00]OW@03001oogoo00]oo`03001oogoo
021oo`003goo00<007ooOol00goo00<007ooOol0J7oo00<007ooOol06Goo00<007ooOol0:Goo00<0
07ooOol00goo00<007ooOol0FGoo0P0001]O_P00000005nnGieO_U^MGkiOWEnnFieO_P00GkiKWEnn
GieO_U^MGkiOWEnnFieO_UnMGkh00P002goo00<007ooOol087oo000?Ool00`00Oomoo`04Ool00`00
Oomoo`1VOol2000LOol00`00Oomoo`0XOol00`00Oomoo`04Ool00`00Oomoo`1EOol6000=Gid00`00
GieOW@0<Gid2000:Ool00`00Oomoo`0OOol000moo`03001oogoo00Eoo`03001oogoo069oo`<0009o
o`03001oogoo01Yoo`03001oogoo02Moo`03001oogoo00Eoo`03001oogoo059oo`80000TGid00000
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_P00GkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnn0P002Goo00<007ooOol07Woo000?Ool00`00Oomoo`06Ool00`00Oomoo`1NOol30005Ool0
0`00Oomoo`0JOol00`00Oomoo`0WOol00`00Oomoo`06Ool2001?Ool6000CGid00`00GieOW@0?Gid0
0`00Oomoo`06Ool00`00Oomoo`0NOol000ioo`03001oogoo00Qoo`03001oogoo05Yoo`<000Uoo`03
001oogoo01Yoo`03001oogoo02Ioo`03001oogoo00Qoo`03001oogoo04Yoo`D0000YGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKW@00GieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOW@020007Ool00`00Oomoo`0MOol000ioo`03001oogoo00Uoo`8005Moo`<000eo
o`03001oogoo01Yoo`03001oogoo02Eoo`03001oogoo00Uoo`03001oogoo04Ioo`D001]OW@03001O
WEnM011OW@8000Ioo`03001oogoo01aoo`003Woo00<007ooOol02goo00<007ooOol0DGoo0`004Goo
00<007ooOol06Goo00<007ooOol097oo00<007ooOol02goo00<007ooOol0@Woo1@0003AOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKW@00GieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFid000Eoo`03001oogoo01aoo`003Woo00<0
07ooOol037oo00<007ooOol0CGoo0`0057oo00<007ooOol06Woo00<007ooOol08goo00<007ooOol0
37oo00<007ooOol0?goo10008UnM00<005nMGid04UnM0P0017oo00<007ooOol06goo000>Ool00`00
Oomoo`0=Ool00`00Oomoo`1:Ool2000HOol00`00Oomoo`0JOol00`00Oomoo`0ROol00`00Oomoo`0=
Ool00`00Oomoo`0kOol40000?5nMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkh005nnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_P8000=oo`03001oogoo01Yoo`003Woo00<007ooOol03Woo00<007oo
Ool0AWoo0`006goo00<007ooOol06Goo00<007ooOol08Woo00<007ooOol03Woo00<007ooOol0>7oo
0`00:UnM00<005nMGid055nM00@007ooOol001aoo`003Goo00<007ooOol047oo00<007ooOol0@Woo
0`007goo00<007ooOol06Goo00<007ooOol08Goo00<007ooOol03goo00<007ooOol0=7oo0`0004AO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_P00GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKW@0017oo00<007ooOol06Goo000=Ool00`00Oomoo`0AOol00`00Oomoo`0nOol3
000KOol40003Ool00`00Oomoo`0JOol00`00Oomoo`0POol00`00Oomoo`0@Ool00`00Oomoo`0`Ool3
000aGid00`00GieOW@0AGid00`00Oomoo`04Ool00`00Oomoo`0HOol000eoo`03001oogoo019oo`03
001oogoo03Yoo`<001Uoo`D00004Aim3OTNO@gh5000KOol00`00Oomoo`0POol00`00Oomoo`0AOol0
0`00Oomoo`0]Ool30000AennFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
001KWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M00001goo00<007ooOol067oo000=Ool0
0`00Oomoo`0COol00`00Oomoo`0fOol3000HOol400000dNN@gi7WP02Aih01D=nAii7WTNN@gh00dNN
10006Goo00<007ooOol07Woo00<007ooOol04goo00<007ooOol0:Goo0`00>5nM00<005nMGid03EnM
00<007ooOol01goo00<007ooOol05goo000=Ool00`00Oomoo`0DOol00`00Oomoo`0bOol3000FOol5
00005D=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n0013OP03000FOol00`00Oomo
o`0NOol00`00Oomoo`0DOol00`00Oomoo`0UOol40000BU^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid005^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
000;Ool00`00Oomoo`0FOol000eoo`03001oogoo01Eoo`03001oogoo02ioo`<001Aoo`D00005@gi7
WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP050017WTNNAii3OP04000C
Ool00`00Oomoo`0MOol00`00Oomoo`0EOol00`00Oomoo`0QOol4000nGid00`00GieOW@0:Gid00`00
Oomoo`0:Ool00`00Oomoo`0FOol000aoo`03001oogoo01Moo`03001oogoo02Yoo`<001=oo`@0000V
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
0017Wd=nAim3OTNO@gi7W`<0015oo`03001oogoo01aoo`03001oogoo01Ioo`03001oogoo01eoo`D0
001=GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_P00GkiKWEnnGieO_U^MGkiOWEnnFid0000>Ool00`00Oomoo`0EOol000aoo`03
001oogoo01Qoo`03001oogoo02Ioo`<0015oo`D000=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN
@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01@00Aii7WTNN@gh00dNN00=3OTNN
00000`003Goo00<007ooOol077oo00<007ooOol05goo00<007ooOol06Goo1@00AEnM00<005nMGid0
1UnM00<007ooOol03Woo00<007ooOol057oo000<Ool00`00Oomoo`0IOol00`00Oomoo`0ROol3000?
Ool50000=TNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n0013OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OP@000Yo
o`03001oogoo01]oo`03001oogoo01Qoo`8001Ioo`H0001AGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn
GieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnn
FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn
001O_U^MGkiOWEnnFieO_P00011oo`03001oogoo01Aoo`0037oo00<007ooOol06Woo00<007ooOol0
7Woo0`003Woo10000dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh0
0dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WP00@gh00dNN00E3OTNNAii7
WT=n00=7WP04@gi7WTNNAih20009Ool00`00Oomoo`0JOol00`00Oomoo`0JOol00`00Oomoo`0@Ool3
00000goo0000001;Gid00`00GieOW@04Gid00`00Oomoo`0@Ool00`00Oomoo`0COol000aoo`03001o
ogoo01]oo`03001oogoo01Yoo`<000aoo`D00012@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=n0013OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO0P002Woo00<007ooOol06Goo
00<007ooOol077oo00<007ooOol037oo0`000Woo0P0005AO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFid005nMGkiKWEnn000DOol00`00Oomoo`0BOol000aoo`03001oogoo01aoo`03001o
ogoo01Ioo`<000Yoo`D00097WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7
WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7
WTNNAii3OP02Aih00`00@gi7WP02Aih01D=nAii7WTNN@gh00TNN0P003Goo00<007ooOol067oo00<0
07ooOol07Goo00<007ooOol027oo0`0017oo00<005nMGid0CenM00@005nMGid001Eoo`03001oogoo
019oo`002goo00<007ooOol07Woo00<007ooOol04goo0P002Goo100004Q3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO0017Wd=nAim3OTNO
@gi7Wd=nAil2000@Ool00`00Oomoo`0GOol00`00Oomoo`0NOol00`00Oomoo`05Ool20007Ool0D`00
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFid00P005goo00<007ooOol0
4Goo000;Ool00`00Oomoo`0OOol00`00Oomoo`0?Ool30006Ool500000dNN@gi7WP02Aih01D=nAii7
WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3
OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00U3OTNNAii7WT=nAih0
04NN@gh00dNN00=3OP0000004Woo00<007ooOol05goo00<007ooOol07goo00@007ooOomoo`<000Qo
o`03001OWEnM055OW@03001oogoo01Moo`03001oogoo011oo`002goo00<007ooOol087oo0P0037oo
0`0017oo1@0004e7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7W`00Aim3OTNO008001Aoo`8001Qoo`03
001oogoo021oo`<000Yoo`1G001O_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnn001oo`0001Qoo`03001oogoo011oo`002goo00<007ooOol08Woo00<007ooOol01Woo0`00
0goo100000=7WT=nAih00TNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN
@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNN
Aii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNN0017WP0001=oo`<0
0003Ool007oo01Moo`03001oogoo01eoo`<00003Ool007oo00Yoo`03001OWEnM051OW@05001oogoo
Ool0000HOol00`00Oomoo`0?Ool000]oo`03001oogoo02=oo`03001oogoo009oo`<000=oo`<0001C
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OP02000@Ool40004Ool0
0`00Oomoo`0FOol00`00Oomoo`0JOol30005Ool00`00Oomoo`07Ool0E000FieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkh000Eoo`03001oogoo01Ioo`03001oogoo00ioo`00
2goo00<007ooOol097oo10001Goo00@004NNAii3OP=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN
@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNN
Aii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP06
@gi7WTNNAii3OTNN0P0000=oo`00Ool037oo0`0027oo00<007ooOol05Goo00<007ooOol067oo0`00
2Goo00<007ooOol01Goo00<005nMGid0D5nM00<007ooOol017oo00<007ooOol05Woo00<007ooOol0
3Woo000:Ool00`00Oomoo`0SOol40005Ool20000Dd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gh00P0017oo00<007ooOol01goo0`0037oo00<007ooOol057oo00<007oo
Ool05Goo0`003Goo00<007ooOol017oo05<005nnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_P0000Qoo`03001oogoo01Eoo`8000moo`002Woo00<007ooOol087oo0`0017oo00D0
07ooOomoo`0000=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7
WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3
OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih20007Ool0
0`00Oomoo`02Ool4000?Ool00`00Oomoo`0DOol00`00Oomoo`0BOol3000AOol00`00Oomoo`02Ool0
0`00GieOW@1?Gid00`00Oomoo`08Ool00`00Oomoo`0AOol300000goo001oo`0>Ool000Yoo`03001o
ogoo01eoo`<000Qoo`1E001oo`00Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gh00P002Goo00<007oo00000P004goo00<007ooOol057oo00<007ooOol03goo0`005Goo05H0
07ooOomoo`00GieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_P0037oo00<007oo
Ool037oo100017oo00<007ooOol03Goo000:Ool00`00Oomoo`0JOol3000<Ool01@00Aii7WTNN@gh0
0dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7
WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7
WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00A3OTNNAih000Yoo`<001Ioo`03001oogoo01Aoo`03
001oogoo00aoo`<001Uoo`03001oo`00051OW@03001oogoo00]oo`03001oogoo00Uoo`<000Qoo`03
001oogoo00eoo`002Woo00<007ooOol05goo0`003Goo0P000557Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAil00P0027oo0`000goo00<007ooOol04goo00<007ooOol057oo00<0
07ooOol02Woo0P007Goo058005nMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkh0
00moo`03001oogoo00Eoo`<000aoo`03001oogoo00aoo`002Woo00<007ooOol057oo0`003goo00<0
04=nAih00TNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3
OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7
WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n008000Ioo`@000Moo`03
001oogoo019oo`03001oogoo01Aoo`03001oogoo00Moo`<001moo`03001OWEnM04eOW@03001oogoo
00moo`03001oogoo00@000moo`03001oogoo00aoo`002Goo00<007ooOol04Woo0`004Goo054004=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAil00P001Goo0`002goo00<007ooOol0
4Woo00<007ooOol04goo00<007ooOol01Goo0`008Goo058005nnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGid0015oo`<001=oo`03001oogoo00aoo`002Goo00<007ooOol047oo0P00
4Woo0P0000E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNN
Aii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05
@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n0097WP8000Aoo`<000moo`03
001oogoo015oo`03001oogoo01=oo`03001oogoo009oo`<002=oo`03001OWEnM04iOW@03001oogoo
00eoo`<00003Ool007oo01=oo`03001oogoo00aoo`002Goo00<007ooOol03Goo0`004goo050004NO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO
@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO0P000goo0`004goo00<007ooOol04Goo
00<007ooOol04Woo00<007oo00000P009Woo054005^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnM000037oo10001Goo00<007ooOol04Goo00<007ooOol037oo0009Ool00`00Oomoo`0:
Ool3000EOol00`00Aii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNN
Aii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=n
Aii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih300000goo00000002000F
Ool00`00Oomoo`0AOol00`00Oomoo`0BOol2000XOol00`00GieOW@1=Gid00`00Oomoo`08Ool3000:
Ool00`00Oomoo`0@Ool00`00Oomoo`0<Ool000Uoo`03001oogoo00Moo`<001Moo`1;0017Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OTNO@gi7Wd=nAim3OTNO@gi7Wd=n00@00004Ool00000000KOol00`00Oomoo`0@Ool00`00Oomoo`0C
Ool00`00Oomoo`0UOol0D@00FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid00008
Ool3000>Ool00`00Oomoo`0?Ool00`00Oomoo`0<Ool000Uoo`03001oogoo00Aoo`<001Qoo`800003
Aii3OTNN0097WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05
@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03
Aih01D=nAii7WTNN@gh00dNN00=3OP0000000`000Woo0`007goo00<007ooOol03goo00<007ooOol0
57oo0P009Goo00<005nMGid0C5nM00<007ooOol00goo10004Goo00<007ooOol047oo00<007ooOol0
2goo0008Ool00`00Oomoo`02Ool3000JOol0A@00@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7W`040003Ool4000SOol0
0`00Oomoo`0>Ool00`00Oomoo`0FOol00`00Oomoo`0QOol0D000GkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnM0003Ool3000FOol00`00Oomoo`0?Ool00`00Oomoo`0;Ool000Qoo`03001o
o`00008001aoo`040017WTNN@gh3Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7
WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05@gi7WTNNAii3OP03Aih0
1D=nAii7WTNN@gh00dNN00=3OTNN0000100017oo0`009goo00<007ooOol03Woo00<007ooOol05goo
00<007ooOol07goo00<005nMGid0C5nM00<007oo00000P006Woo00<007ooOol03Woo00<007ooOol0
2goo0008Ool2000NOol0?P00@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gh40006Ool3000[Ool00`00Oomoo`0=Ool00`00Oomoo`0HOol00`00
Oomoo`0NOol0C@00GieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnn
GieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnn
FieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkh010007Woo00<007ooOol0
3Goo00<007ooOol02goo0009Ool00`00Oomoo`0JOol20002Aih01D=nAii7WTNN@gh00dNN00E3OTNN
Aii7WT=n00=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05
@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00TNN1@001goo0`00;goo00<007ooOol03Goo00<007oo
Ool067oo00<007ooOol077oo00<005nMGid0BEnM0P008Woo00<007ooOol03Goo00<007ooOol02goo
000:Ool2000IOol0>000Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7
Wd=nAil40008Ool4000cOol00`00Oomoo`0<Ool00`00Oomoo`0IOol2000KOol0BP00GieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGid3000UOol00`00Oomoo`0<Ool00`00Oomoo`0;Ool000aoo`03001oogoo
01Eoo`D000=7WP05@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00E3OTNNAii7WT=n00=7WP05
@gi7WTNNAii3OP03Aih01D=nAii7WTNN@gh00dNN00A3OTNNAii7WPD000Uoo`<003Moo`03001oogoo
00aoo`03001oogoo01]oo`03001oogoo01Qoo`03001OWEnM04EOW@8002Uoo`03001oogoo00]oo`03
001oogoo00]oo`003Goo00<007ooOol06Goo2@000297Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=n
Aim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OP@000]oo`<003]oo`03001oogoo
00]oo`03001oogoo01aoo`03001oogoo01Ioo`16001O_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkh3000/Ool00`00
Oomoo`0;Ool00`00Oomoo`0:Ool000ioo`03001oogoo025oo`T000=7WP05@gi7WTNNAii3OP03Aih0
1D=nAii7WTNN@gh00dNN00=3OP0000000`0037oo0`00?goo00<007ooOol02Woo00<007ooOol07Goo
00<007ooOol057oo00<005nMGid0@UnM0P00;goo00<007ooOol02goo00<007ooOol02Woo000?Ool2
000ZOol900001dNO@gi7Wd=nAim3OTNO00@000eoo`@004=oo`03001oogoo00Uoo`03001oogoo01io
o`03001oogoo01=oo`12001KWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO
_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO
_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M0`00<Woo00<007ooOol02Woo00<007ooOol02Woo000A
Ool00`00Oomoo`0`Ool7000>Ool30017Ool00`00Oomoo`09Ool00`00Oomoo`0OOol2000BOol00`00
GieOW@0nGid2000fOol00`00Oomoo`09Ool00`00Oomoo`0:Ool0019oo`03001oogoo03Eoo`03001o
ogoo00Uoo`<004]oo`03001oogoo00Qoo`03001oogoo025oo`03001oogoo00moo`0n001O_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_P<003Uo
o`03001oogoo00Qoo`03001oogoo00Yoo`004goo0P00=Woo00<007ooOol017oo1000Cgoo00<007oo
Ool027oo00<007ooOol08Goo00<007ooOol03Goo00<005nMGid0>UnM0P00?7oo00<007ooOol027oo
00<007ooOol02Woo000EOol00`00Oomoo`0dOol00`00Oomoo`03001COol00`00Oomoo`08Ool00`00
Oomoo`0ROol00`00Oomoo`0;Ool0>`00GkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGid00`00?goo00<007ooOol027oo00<007ooOol02Goo000FOol00`00
Oomoo`0dOol2001GOol00`00Oomoo`07Ool00`00Oomoo`0SOol00`00Oomoo`0:Ool00`00GieOW@0e
Gid30013Ool00`00Oomoo`07Ool00`00Oomoo`09Ool001Moo`03001oogoo03=oo`03001oogoo05Mo
o`03001oogoo00Ioo`03001oogoo02Aoo`8000Uoo`0g001OWEnnFieO_UnMGkiKWEnnGieO_U^MGkiO
WEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiK
WEnnGieO_U^MGkiOWEnnFieO_UnMGkh00P00Agoo00<007ooOol01Woo00<007ooOol02Goo000HOol2
000cOol00`00Oomoo`1HOol00`00Oomoo`05Ool00`00Oomoo`0VOol00`00Oomoo`05Ool00`00GieO
W@0bGid30019Ool00`00Oomoo`06Ool00`00Oomoo`09Ool001Yoo`03001oogoo031oo`03001oogoo
05Qoo`03001oogoo00Eoo`03001oogoo02Moo`03001oogoo00Aoo`0c001O_U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
GkiOWEnnFieO_UnMGkiKWEnnGieO_U^M008004eoo`03001oogoo00Eoo`03001oogoo00Uoo`006goo
00<007ooOol0;goo00<007ooOol0FGoo00<007ooOol017oo00<007ooOol0:7oo00<007ooOol00Woo
0`00;UnM0`00D7oo00<007ooOol017oo00<007ooOol02Goo000LOol00`00Oomoo`0^Ool00`00Oomo
o`1JOol00`00Oomoo`04Ool00`00Oomoo`0XOol00`00Oomoo`04Ool600009U^MGkiOWEnnFieO_UnM
GkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGieO_U^M
Gkh2001DOol00`00Oomoo`03Ool00`00Oomoo`09Ool001eoo`8002ioo`03001oogoo05]oo`03001o
ogoo00=oo`03001oogoo02Uoo`8000Yoo`H001eOW@<005Ioo`03001oogoo00Aoo`03001oogoo00Qo
o`007goo00<007ooOol0:goo00<007ooOol0Fgoo00<007ooOol00goo00<007ooOol0:goo00<007oo
Ool03Goo1P0001EOWEnnFieO_UnMGkiKWEnnGieO_U^MGkiOWEnnFieO_UnMGkiKWEnnGid00P00FWoo
00<007ooOol00goo00<007ooOol027oo000POol00`00Oomoo`0ZOol00`00Oomoo`1LOol00`00Oomo
o`02Ool00`00Oomoo`0/Ool00`00Oomoo`0BOol6000<Gid4001LOol00`00Oomoo`02Ool00`00Oomo
o`08Ool0025oo`03001oogoo02Uoo`03001oogoo05eoo`05001oogooOol0000_Ool00`00Oomoo`0G
Ool6000015^MGkiOWEnn0P000goo00<007ooOol0Fgoo00D007ooOomoo`0000Yoo`008Woo0P00:Goo
00<007ooOol0GWoo00@007ooOol0031oo`03001oogoo01aoo`@000Eoo`03001oogoo05]oo`05001o
ogooOol0000:Ool002Aoo`03001oogoo02Eoo`03001oogoo05moo`04001oogoo000aOol2000UOol0
0`00Oomoo`1LOol01000Oomoo`002Woo000UOol00`00Oomoo`0TOol00`00Oomoo`1POol00`00Ool0
000cOol00`00Oomoo`0ROol00`00Oomoo`1MOol00`00Ool0000:Ool002Ioo`03001oogoo02=oo`03
001oogoo065oo`03001oo`0003=oo`03001oogoo025oo`03001oogoo05ioo`03001oo`0000Uoo`00
9goo0P008goo00<007ooOol0HWoo0P00=7oo00<007ooOol087oo00<007ooOol0GWoo00<007oo0000
2Goo000YOol00`00Oomoo`0POol00`00Oomoo`1ROol2000eOol2000POol00`00Oomoo`1OOol20009
Ool002Yoo`03001oogoo01moo`03001oogoo069oo`8003Moo`03001oogoo01eoo`03001oogoo05mo
o`8000Uoo`00:goo0P007goo00<007ooOol0GWoo1000>Woo00<007ooOol077oo00<007ooOol0Fgoo
10002goo000]Ool00`00Oomoo`0LOol00`00Oomoo`1JOol4000oOol00`00Oomoo`0KOol00`00Oomo
o`1GOol4000?Ool002ioo`03001oogoo01]oo`03001oogoo05Ioo`@004Aoo`03001oogoo01Yoo`03
001oogoo05=oo`@001=oo`00;goo00<007ooOol06Woo00<007ooOol0DWoo1000BGoo0P006Woo00<0
07ooOol0Cgoo10005goo000`Ool2000JOol00`00Oomoo`1>Ool4001?Ool00`00Oomoo`0GOol00`00
Oomoo`1;Ool4000KOol0039oo`03001oogoo01Moo`03001oogoo04Yoo`@005Aoo`03001oogoo01Io
o`03001oogoo04Qoo`<001moo`00<goo00<007ooOol05Woo00<007ooOol0AWoo1000FGoo00<007oo
Ool057oo00<007ooOol0AGoo10008Woo000dOol00`00Oomoo`0EOol00`00Oomoo`12Ool4001NOol0
0`00Oomoo`0COol00`00Oomoo`11Ool4000VOol003Eoo`8001Eoo`03001oogoo03ioo`@006=oo`80
01=oo`03001oogoo03eoo`@002Yoo`00=goo00<007ooOol04Woo00<007ooOol0>Woo1000JGoo00<0
07ooOol047oo00<007ooOol0>Goo1000;Woo000hOol00`00Oomoo`0AOol00`00Oomoo`0fOol4001^
Ool00`00Oomoo`0?Ool00`00Oomoo`0eOol4000bOol003Uoo`03001oogoo011oo`03001oogoo039o
o`@007=oo`03001oogoo00ioo`03001oogoo035oo`@003Ioo`00>Woo0P0047oo00<007ooOol0;Woo
1000N7oo00<007ooOol03Goo00<007ooOol0;Woo0`00>Woo000lOol00`00Oomoo`0=Ool00`00Oomo
o`0ZOol4001mOol2000=Ool00`00Oomoo`0ZOol4000mOol003eoo`03001oogoo00aoo`03001oogoo
02Ioo`@008=oo`03001oogoo00Yoo`03001oogoo02Ioo`@0045oo`00?Woo00<007ooOol02Woo00<0
07ooOol08goo1000R7oo00<007ooOol02Goo00<007ooOol08Woo1000AGoo000oOol2000:Ool00`00
Oomoo`0OOol4002=Ool00`00Oomoo`08Ool00`00Oomoo`0NOol40019Ool0045oo`03001oogoo00Mo
o`03001oogoo01]oo`@0099oo`03001oogoo00Moo`03001oogoo01Yoo`@004eoo`00@Woo00<007oo
Ool01Woo00<007ooOol05goo1000Ugoo0P001goo00<007ooOol05goo0`00DGoo0013Ool20006Ool0
0`00Oomoo`0COol4002MOol00`00Oomoo`04Ool00`00Oomoo`0COol4001DOol004Eoo`03001oogoo
00=oo`03001oogoo00moo`@00:9oo`03001oogoo00=oo`03001oogoo00moo`@005Qoo`00AWoo00<0
07ooOol00Woo00<007ooOol02goo1000Ygoo00<007ooOol00Woo00<007ooOol02goo1000G7oo0017
Ool01@00Oomoogoo00002Goo1000[7oo00D007ooOomoo`0000Uoo`@0061oo`00B7oo0P0000=oo`00
Ool017oo1000/Goo0P0000=oo`00Ool017oo1000I7oo001:Ool200000goo00000002002gOol20000
0goo00000002001XOol004]oo`800;aoo`8006aoo`00ogooN7oo003oOomhOol00?moogQoo`00ogoo
N7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol0
0?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol00001\
\>"],
  ImageRangeCache->{{{0, 374}, {177.75, 0}} -> {-0.0500105, -0.0968358, \
0.00701879, 0.00701879}, {{8.875, 178.5}, {160.5, 17.1875}} -> {-0.0499297, \
-0.0478037, 0.00703168, 0.00703168}, {{195.438, 365.063}, {160.5, 17.1875}} -> \
{-1.09342, -0.0459071, 0.00699338, 0.00699338}}]
}, Open  ]],

Cell[TextData[
"The graphic shows that the two rotations applied to the same object in a \
different order results in two different states of the hexagon. Thus, by a \
simple example, we graphically verified that two rotations in a \
three-dimensional space are non-commutative. The reader may check this result \
by different rotations about different axes using different angles of \
rotation.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"], "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],

Cell["\<\
Another important term in group theory governing the relations \
between two groups is the notion of isomorphism.\
\>", "Text",
  CellTags->"isomorphism"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.2 Isomorphism", "Subsection",
  Evaluatable->False,
  CellTags->"Isomorphism"],

Cell["\<\
The given definition of a group is very abstract, yet general. With \
respect to this generality, it sometimes happens that two groups whose \
elements are defined in very different ways may nevertheless be related so \
closely that they may be regarded as the same group. This fact is expressed \
in the following definition.\
\>", "Text",
  Evaluatable->False],

Cell["Definition: Isomorphic groups", "Definition",
  CellTags->"Definition: Isomorphic groups"],

Cell[TextData[{
  "We say that two groups \[GothicCapitalG] and \[GothicCapitalH] are \
isomorphic if a one-to-one correspondence ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\  \[LeftRightArrow] \ H\_i\)]],
  " may be set up between the elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " of the group \[GothicCapitalG] and the elements ",
  Cell[BoxData[
      \(TraditionalForm\`H\_i\)]],
  " of \[GothicCapitalH], in such a way that if ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\ \[CirclePlus]\ G\_k\  = \ G\_j\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`H\_i\ \[CirclePlus]\ H\_k\  = \ H\_j\)]],
  ".\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "Text"],

Cell["\<\
Closely related to the term isomorphism is the subject of \
homomorphism. The word homomorphism is used for such a relationship if the \
one-to-one correspondence is absent. Due to the definition of isomorphism, \
two isomorphic groups have the same group multiplication table with possible \
re-ordering of the group elements. Thus, the knowledge of the isomorphism of \
two groups helps to avoid repetitions and to draw useful analogies between \
the groups.\
\>", "Text",
  Evaluatable->False,
  CellTags->{"homomorphism", "isomorphic group"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.1.",
  CounterBox["Subsection"],
  " Lie Groups"
}], "Subsection",
  CellTags->"Lie Groups"],

Cell[TextData[{
  "Lie groups are special groups which have an additional property apart from \
the group properties. In addition to the basic group properties, a Lie group \
carries the structure of a manifold, where a manifold is a topological space \
which resembles Euclidean space locally. A differentiable manifold is a \
manifold for which this resemblance is sharp enough to allow partial \
differentiation and, consequently, all the features of differential calculus \
on the manifold. In studying Lie groups, we may, therefore, combine calculus, \
algebra, and topology. The present section aims at showing the sense in which \
the global study of a Lie group may be reduced to its local study. In the \
next section, we shall go even further, showing that the study of the local \
structure can be reduced to the study of the infinitesimal structure. Lie \
groups are extremely useful in the theory of transformation and in the \
examination of differential equations. The notion of a Lie group was \
introduced by ",
  ButtonBox["Weyl [1928]",
    ButtonData:>{"Literat.nb", "Weyl-28"},
    ButtonStyle->"Hyperlink"],
  " at the beginning of this century. Weyl used the following definition to \
distinguish Lie groups from classical groups."
}], "Text",
  CellTags->{
  "manifold", "calculus", "partial differentiation", "algebra", "topology", 
    "Lie group"}],

Cell["Definition: Lie group", "Definition",
  CellTags->"Definition: Lie group"],

Cell[TextData[{
  "A Lie group is a group which, in addition to the group properties, carries \
the structure of a differentiable manifold. More precisely, we require that a \
Lie group \[GothicCapitalG] be ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\[Infinity]\)]],
  " manifold endowed with a group structure in which multiplication and the  \
inversion are ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\[Infinity]\)]],
  " operations.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptyCircle]"
}], "Text",
  CellTags->"manifold"],

Cell[TextData[{
  "The essential feature of a Lie group is that it satisfies the properties \
(i)\[Dash](iv) and carries the structure of a smooth manifold. This means \
that the group elements ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " can be continuously varied. Thus, a Lie group is a group \
\[GothicCapitalG] which also carries the structure of a manifold in such a \
way that both the group operation \[GothicCapitalG] \[CirclePlus] \
\[GothicCapitalG] \[Rule] \[GothicCapitalG] and the inversion are smooth maps \
between manifolds. In the following, we will demonstrate these descriptions \
by a few examples."
}], "Text",
  Evaluatable->False],

Cell["Example 1", "Example"],

Cell[TextData[{
  "The first simple example of a Lie group is the real line ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " with ordinary addition as the group multiplication. Let us denote this  \
group by \[DoubleStruckCapitalA]. If we add two real numbers, we get a real \
number as a result. We all know that we can add three real numbers in any \
order to get the same result. The identity element of this group in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " is zero and the inverse are all the negative real numbers. Thus, we can \
map ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalR]\^1\[Times]\ \[DoubleStruckCapitalR]\^1 
        \[Rule] \ \[DoubleStruckCapitalR]\^1\)]],
  ", and the inversion as a smooth map also exists. These properties of \
addition for the real numbers are actually implemented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and are accessible by the function ",
  StyleBox["N[]", "MmaText"],
  " converting rational numbers to real numbers. The + sign represents the \
multiplication of the group \[DoubleStruckCapitalA]. The manifold on which \
all these operations are possible are the set of real numbers ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  ". \[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"addition", "inverse", "N[]", "rational numbers"}],

Cell["Example 2", "Example"],

Cell[TextData[{
  "A more sophisticated example for a Lie group is given by continuous matrix \
groups, or, more generally, continuous groups of linear transformations of a \
vector space, called linear Lie groups. The set of all non-singular ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Times]\ n\)]],
  " matrices form the group known as general linear group ",
  StyleBox["GL(n,\[DoubleStruckCapitalR])",
    FontSlant->"Italic"],
  ". A subset of all ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Times]\ n\)]],
  " matrices with determinant 1 form a group called the unimodular group \
which is denoted by ",
  StyleBox["SL(n,\[DoubleStruckCapitalR])",
    FontSlant->"Italic"],
  ". The orthogonal group ",
  StyleBox["O(n)",
    FontSlant->"Italic"],
  " is the group of ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Times]\ n\)]],
  " matrices that satisfy ",
  Cell[BoxData[
      \(TraditionalForm\`M\ \[CirclePlus]\ M\^T\  = \ 1\)]],
  ". A special orthogonal group ",
  StyleBox["SO",
    FontSlant->"Italic"],
  "(3) is connected with rotations."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "special orthogonal group", "SO(3)", "GL(n", "\\[DoubleStruckCapitalR])", 
    "SL(n", "continuous matrix group", "unimodular group", "linear group", 
    "vector space", "\[DoubleStruckCapitalR])"}],

Cell["\<\
Studying the properties of continuous matrix groups, we start with \
the two-dimensional matrices\
\>", "Text",
  Evaluatable->False,
  CellTags->"matrix group"],

Cell[BoxData[
    FormBox[
      RowBox[{\(M\_a\), " ", "=", " ", 
        RowBox[{
          RowBox[{"(", GridBox[{
                {"1", "a"},
                {"0", "1"}
                }], ")"}], "."}]}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "This representation of a linear group S",
  StyleBox["L(",
    FontSlant->"Italic"],
  StyleBox["2,",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\[DoubleStruckCapitalR])",
    FontSlant->"Italic"],
  " immediately shows  the property"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(TraditionalForm\`\(M\_a\ \[CirclePlus]\ M\_b\  = \ M\_\(a + b\), \)\)], 
  "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "from which we can conclude that the group of two-dimensional matrices is \
isomorphic to the group \[DoubleStruckCapitalA] of our first example. To \
support this conclusion, let us examine the properties of the two-dimensional \
matrix group by using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". First, let us define a function allowing us the representation of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  ". Afterward, we use this function to check the group axioms (i)\[Dash](iv) \
for this representation of a group. Since ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " depends on one continuous parameter ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", we define the matrix ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " by"
}], "Text",
  Evaluatable->False,
  CellTags->{"representation", "group axioms"}],

Cell[BoxData[
    \(M[a_] := {{1, a}, {0, 1}}\)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "The matrix function ",
  StyleBox["M[]", "MmaText"],
  " uses two nested lists to represent the two-dimensional matrices needed. \
We check the axioms by using the matrix product for the group multiplication. \
This type of product is denoted by a lower dot in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In the sequel, we use the function ",
  StyleBox["MatrixForm[]", "MmaText"],
  " to represent the resulting matrices in a two-dimensional table. \
Multiplying two different matrices ",
  StyleBox["M[a]", "MmaText"],
  " and ",
  StyleBox["M[b]", "MmaText"],
  ", we find"
}], "Text",
  Evaluatable->False,
  CellTags->{"group multiplication", "MatrixForm[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[M[a] . M[b]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(a + b\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
We immediately verified that axiom (i) is satisfied. The property \
of associativity is checked by interchanging the multiplication order\
\>", 
  "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[\((M[a] . M[b])\) . M[c]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(a + b + c\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[M[a] . \((M[c] . M[b])\)]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(a + b + c\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The inverse element of the group corresponds to the inversion of the \
matrix. Matrices are inverted in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with the help of the function ",
  StyleBox["Inverse[]", "MmaText"],
  ". ",
  StyleBox["Inverse[]", "MmaText"],
  " returns the inverse of a square matrix. The application of this function \
shows us"
}], "Text",
  Evaluatable->False,
  CellTags->{"Inverse[]", "inverse element"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(mi = Inverse[M[a]]; mi // MatrixForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-a\)},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "which is the inverse of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " stored in the variable ",
  StyleBox["mi",
    FontSlant->"Italic"],
  ". Next, we can check axiom (iv) by"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ident = mi . M[a]; \ ident\  // MatrixForm\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "0"},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, we find the identity element of the two-dimensional matrices ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  " as the identity matrix in two dimensions. It is obvious from the \
calculations that the set ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[GothicCapitalM]\  = {\ 
          M\_a | \ \ a \[Element] \ \[DoubleStruckCapitalR]}\)]],
  " is a representation of addition in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  ", thus the two Lie groups \[DoubleStruckCapitalA] and \[GothicCapitalM] \
are isomorphic.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{"identity element", "isomorphic"}],

Cell[TextData[{
  "Generally speaking, a representation of a group \[GothicCapitalG] on a \
vector space ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is a homomorphism from the group \[GothicCapitalG] into an invertible  \
linear transformation of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  ". These ",
  "representations",
  " must not be matrix representations but can be defined on the infinite \
dimensional vector space ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^\[Infinity]\)(\[DoubleStruckCapitalR])\)]],
  ", which represents the space of infinitely differentiable functions in one \
dimension."
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{
  "vector space", "homomorphism", "invertible linear transformation", 
    "representation", "infinite dimensional vector space"}],

Cell[TextData[StyleBox["Example 3",
  FontVariations->{"CompatibilityType"->0}]], "Example"],

Cell[TextData[{
  "The addition in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " can also be represented by a translation in the space of  ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\^\[Infinity]\)(\[DoubleStruckCapitalR])\)]],
  " functions. Let us assume that we can define an operator ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  ", which acts on a function defined on ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " in the following way:"
}], "Text",
  Evaluatable->False,
  CellTags->"translation"],

Cell[BoxData[
    \(TraditionalForm\`\(\(T\_a\) \(f(x)\)\  = \ \(f(x + a) . \)\ \)\)], 
  "DisplayFormula",
  Evaluatable->False],

Cell[TextData[{
  "The shift ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " translates the argument of the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " by a step ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " to the left. The definition of a shift operator ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks like"
}], "Text",
  Evaluatable->False,
  CellTags->"shift operator"],

Cell[BoxData[
    \(T\_a_[f_] := f /. x \[Rule] x + a\)], "Input"],

Cell[TextData[{
  "This simple definition assumes that the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " depends exclusively on ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The sequence of instructions on the right-hand side of the definition \
sign ( :=) means that the argument ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ", if any, is replaced by ",
  Cell[BoxData[
      \(TraditionalForm\`x + a\)]],
  ". The properties of the group are now checked by applying the operator ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " on functions ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  "). The identity element of the Lie group is given by ",
  Cell[BoxData[
      \(TraditionalForm\`a = 0\)]],
  ","
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_0[f[x]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The inverse element is represented by a negative shift ",
  Cell[BoxData[
      \(TraditionalForm\`\(-a\)\)]],
  ". We check the inverse behavior of the transformation by applying the \
inverse element to a regular element of the group. The expected result is the \
identity"
}], "Text",
  Evaluatable->False,
  CellTags->"inverse element"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_\(-a\)[T\_a[f[x]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The property of associativity is expressed by the iterated application of \
the translation operator",
  StyleBox[" ", "MmaText"],
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)], "MmaText"],
  StyleBox["[]", "MmaText"],
  " for different translations ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c",
    FontSlant->"Italic"],
  " and the interchange of two parameters"
}], "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_c[T\_b[T\_a[f[x]]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[a + b + c + x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(T\_b[T\_c[T\_a[f[x]]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(f[a + b + c + x]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, we observe that the Lie group of translations in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " is isomorphic to the group of addition \[DoubleStruckCapitalA]. In \
conclusion, we can say that the same Lie group can be represented by \
different tools like addition of real numbers, matrix multiplication, and \
translations of functions. These different tools for representing the \
behavior are known as representations of the group. The idea of a \
representation of a Lie group helps to clarify the subtle distinction between \
an abstract group and a  variety of its realizations. Thus, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalA]", " ", "=", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^1\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", the set of matrices ",
  Cell[BoxData[
      \(TraditionalForm\`M\_a\)]],
  ", and the translations ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " are all distinct but isomorphic representations of the same abstract \
group.\[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "group representation", "isomorphic", "representation of a Lie group"}],

Cell[TextData[
"Apart from an isomorphism which is invertible, the term homomorphism is an \
important quantity in group theory. A Lie group homomorphism is a smooth map \
\[CapitalPhi] : \[GothicCapitalG] \[Rule] \[GothicCapitalH] between two Lie \
groups respecting the group operations. If \[CapitalPhi] has a smooth \
inverse, it determines an isomorphism between \[GothicCapitalG] and \
\[GothicCapitalH], otherwise it is a homomorphism. "], "Text",
  Evaluatable->False,
  CellTags->{"isomorphism", "homomorphism"}],

Cell["\<\
Understanding the action of the group clearly, we discuss the \
example of a translation a second time. This kind of symmetry is a symmetry \
frequently recognized in the analysis of differential equations. To \
illustrate the action of such a group, we will realize it by a graphical \
representation.\
\>", "Text",
  Evaluatable->False,
  CellTags->"translation"],

Cell["Example 4", "Example"],

Cell[TextData[{
  "For example, let us study the group properties of a parabola ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x)\), "=", 
          FormBox[\(x\^2\),
            "TraditionalForm"]}], TraditionalForm]]],
  " under the action of our function ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  ". Applying ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  ", we mathematically get the expression ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(x\^2\), "+", 
          RowBox[{"2", 
            StyleBox["ax",
              FontSlant->"Italic"]}], " ", "+", " ", \(a\^2\)}], 
        TraditionalForm]]],
  ". The expanded result represents the translation ",
  Cell[BoxData[
      \(TraditionalForm\`T\_a\)]],
  " in a more or less mixed form containing products of ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". However, the action of the group is much simpler to grasp if we present \
it graphically. The shift ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " along the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis is clearly shown in the figure below."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[\n\tEvaluate[{x\^2, T\_\(-2\)[x\^2]}], {x, \(-2\), 4}, \n\t
      PlotStyle 
        \[Rule] {RGBColor[1.000, 0.000, 0.000], \n\t\t\t
          RGBColor[0.000, 0.000, 1.000]}, 
      AxesLabel \[Rule] {"\<x\>", "\<f\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.15873 0.0147151 0.0595487 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.18254 .00222 -6 -9 ]
[.18254 .00222 6 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.65873 .00222 -3 -9 ]
[.65873 .00222 3 0 ]
[.81746 .00222 -3 -9 ]
[.81746 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.4375 ]
[1.025 .01472 10 6.4375 ]
[.32877 .13381 -6 -4.5 ]
[.32877 .13381 0 4.5 ]
[.32877 .25291 -6 -4.5 ]
[.32877 .25291 0 4.5 ]
[.32877 .37201 -6 -4.5 ]
[.32877 .37201 0 4.5 ]
[.32877 .4911 -6 -4.5 ]
[.32877 .4911 0 4.5 ]
[.32877 .6102 -12 -4.5 ]
[.32877 .6102 0 4.5 ]
[.34127 .64303 -5 0 ]
[.34127 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 .01472 m
.02381 .02097 L
s
[(-2)] .02381 .00222 0 1 Mshowa
.18254 .01472 m
.18254 .02097 L
s
[(-1)] .18254 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(2)] .65873 .00222 0 1 Mshowa
.81746 .01472 m
.81746 .02097 L
s
[(3)] .81746 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(4)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.34127 .13381 m
.34752 .13381 L
s
[(2)] .32877 .13381 1 0 Mshowa
.34127 .25291 m
.34752 .25291 L
s
[(4)] .32877 .25291 1 0 Mshowa
.34127 .37201 m
.34752 .37201 L
s
[(6)] .32877 .37201 1 0 Mshowa
.34127 .4911 m
.34752 .4911 L
s
[(8)] .32877 .4911 1 0 Mshowa
.34127 .6102 m
.34752 .6102 L
s
[(10)] .32877 .6102 1 0 Mshowa
.125 Mabswid
.34127 .04449 m
.34502 .04449 L
s
.34127 .07426 m
.34502 .07426 L
s
.34127 .10404 m
.34502 .10404 L
s
.34127 .16359 m
.34502 .16359 L
s
.34127 .19336 m
.34502 .19336 L
s
.34127 .22314 m
.34502 .22314 L
s
.34127 .28268 m
.34502 .28268 L
s
.34127 .31246 m
.34502 .31246 L
s
.34127 .34223 m
.34502 .34223 L
s
.34127 .40178 m
.34502 .40178 L
s
.34127 .43156 m
.34502 .43156 L
s
.34127 .46133 m
.34502 .46133 L
s
.34127 .52088 m
.34502 .52088 L
s
.34127 .55065 m
.34502 .55065 L
s
.34127 .58043 m
.34502 .58043 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.34127 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(f) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .25291 m
.06244 .19846 L
.10458 .14712 L
.14415 .10655 L
.18221 .07451 L
.22272 .04793 L
.24141 .03828 L
.26171 .02968 L
.27279 .0258 L
.28302 .02274 L
.29341 .02013 L
.30316 .01815 L
.31218 .01672 L
.31682 .01613 L
.32188 .0156 L
.32474 .01536 L
.3274 .01517 L
.33016 .01501 L
.33265 .01489 L
.33383 .01485 L
.33511 .0148 L
.33621 .01478 L
.33742 .01475 L
.33871 .01473 L
.33941 .01472 L
.34007 .01472 L
.34125 .01472 L
.34251 .01472 L
.34372 .01473 L
.34442 .01474 L
.34507 .01475 L
.34638 .01478 L
.34779 .01482 L
.35034 .01491 L
.35268 .01502 L
.35807 .01538 L
.36375 .01591 L
.37336 .01715 L
.38387 .019 L
.40348 .02386 L
.42443 .03106 L
.44577 .04053 L
.46593 .05144 L
.50439 .0776 L
.54531 .11311 L
.58471 .15479 L
.6226 .20178 L
.66294 .25927 L
.70177 .32187 L
.74304 .39623 L
Mistroke
.7828 .47548 L
.82105 .55876 L
Mfstroke
.82105 .55876 m
.84612 .61803 L
s
0 0 1 r
.15376 .61803 m
.18221 .5514 L
.22272 .46403 L
.26171 .38726 L
.30316 .31354 L
.34309 .25019 L
.3815 .19637 L
.42237 .14676 L
.46172 .10645 L
.49955 .0746 L
.53984 .04812 L
.55838 .03852 L
.57861 .02989 L
.58957 .02602 L
.59975 .02294 L
.6094 .02047 L
.61984 .01829 L
.62534 .01735 L
.6304 .01661 L
.63515 .01603 L
.64036 .01551 L
.64504 .01516 L
.64941 .01492 L
.65182 .01483 L
.65402 .01477 L
.65524 .01474 L
.65592 .01473 L
.65656 .01473 L
.65773 .01472 L
.65897 .01472 L
.6601 .01472 L
.66135 .01473 L
.66265 .01475 L
.66385 .01478 L
.66602 .01484 L
.66834 .01493 L
.67106 .01507 L
.67363 .01524 L
.67844 .01563 L
.68721 .01663 L
.69672 .01813 L
.70618 .02004 L
.71659 .02263 L
.73763 .02943 L
.75708 .03758 L
.77797 .04832 L
.81925 .07561 L
.85901 .10952 L
.89726 .14919 L
.93795 .19899 L
Mistroke
.97619 .25291 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 143},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005g0000/Q000`40O003h00OA7oo1@008Goo1@00
@Goo1@0087oo1@008Goo0`0097oo0`00DWoo0014Ool01@00Oomoogoo00008goo00<007ooOol0@goo
00<007ooOol087oo00D007ooOomoo`00021oo`05001oogooOol0000TOol00`00Oomoo`1AOol004Eo
o`03001oogoo02Aoo`03001oogoo04=oo`03001oogoo025oo`03001oogoo02Eoo`03001oogoo029o
o`03001oogoo055oo`00?7oo1P0017oo00<007ooOol067oo1P001Goo00<007ooOol0@goo00<007oo
Ool08Woo00<007ooOol097oo00<007ooOol07Woo1P00DWoo0017Ool00`00Oomoo`0ROol00`00Oomo
o`13Ool00`00Oomoo`0SOol00`00Oomoo`0QOol2000ROol01000Oomoo`00Dgoo0018Ool00`00Oomo
o`0QOol00`00Oomoo`13Ool00`00Oomoo`0TOol00`00Oomoo`0ROol00`00Oomoo`0OOol01000Oomo
o`00Dgoo0014Ool01@00Oomoogoo00008Goo0`00@goo0`008Woo00D007ooOomoo`00021oo`05001o
ogooOol0000ROol00`00Ool0001COol004Eoo`<002Aoo`03001oogoo04=oo`03001oogoo025oo`<0
029oo`<002Aoo`8005=oo`00ogooN7oo003oOomhOol008eoo`03001oogoo0>Moo`00SGoo00<007oo
Ool0igoo002=Ool00`00Oomoo`2QOol20002Ool20010Ool008eoo`03001oogoo0:9oo`04001oogoo
0011Ool003eoodP000ml03d000h07dX000Yoo`80049oo`00@goo00<007ooOol017oo00<007ooOol0
17oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol017`000=oo`00Ool01Goo00<007ooOol017oo1W`00Woo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol01Goo00<007oo01l01@0O1goo00<007ooOol017oo1@0O0Woo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool01Goo00<007ooOol017oo00<007ooOol03Woo0P00@Woo001nOol3O00<Ool00`00Oomoo`0:Ool4
O00[Ool201lIOol401m:Ool01000Oomoo`00@Goo001iOol5O00?Ool00`00Oomoo`0>Ool2O00UOol4
01lOOol401m5Ool20002Ool20010Ool007Moo`9l01Aoo`03001oogoo011oo`=l021oo`807bMoo`80
7hUoo`00MWoo00=l07ooOol057oo00<007ooOol04goo0W`077oo0P0O:goo0P0OQgoo001dOol2O00G
Ool00`00Oomoo`0EOol2O00HOol201l_Ool201n5Ool0079oo`9l01Uoo`8001Qoo`03O01oogoo01=o
o`807c=oo`807h=oo`00LGoo00=l07ooOol06Goo00<007ooOol067oo0W`04Woo00<07gooOol0=Goo
00<07gooOol0P7oo001_Ool2O00LOol00`00Oomoo`0JOol00g`0Oomoo`0=Ool201liOol201n0Ool0
06ioo`03O01oogoo01aoo`03001oogoo01]oo`9l00]oo`807ceoo`0301moogoo07eoo`00K7oo0W`0
7goo00<007ooOol07Goo00=l07ooOol01goo00<07gooOol0?Woo0P0OOGoo001[Ool00g`0Oomoo`0O
Ool00`00Oomoo`0NOol2O005Ool201m3Ool00`0OOomoo`1jOol006Uoo`9l029oo`03001oogoo021o
o`03O01oogoo00807dIoo`807gYoo`00J7oo00=l07ooOol08Woo0P008Woo00=l000OOol0BGoo00<0
7gooOol0Mgoo001WOol00g`0Oomoo`0SOol00`00Oomoo`0QOol00`0OOoml001:Ool00`0OOomoo`1f
Ool006Eoo`9l02Ioo`03001oogoo01moo`807`=oo`03O01oogoo04Qoo`807gIoo`00I7oo00=l07oo
Ool09Woo00<007ooOol07Woo00<07gooOol017oo0W`0BWoo00<07gooOol0Lgoo001SOol00g`0Oomo
o`0WOol00`00Oomoo`0MOol00`0OOomoo`07Ool00g`0Oomoo`18Ool00`0OOomoo`1bOol0065oo`9l
02Yoo`03001oogoo01]oo`807`]oo`03O01oogoo04Qoo`0301moogoo075oo`00H7oo00=l07ooOol0
:Woo00<007ooOol06Woo00<07gooOol037oo00=l07ooOol0B7oo0P0OLGoo001OOol00g`0Oomoo`0[
Ool2000JOol00`0OOomoo`0>Ool2O01:Ool00`0OOomoo`1^Ool005ioo`03O01oogoo02aoo`03001o
ogoo01Qoo`0301moogoo015oo`03O01oogoo04Qoo`0301moogoo06eoo`00GGoo00=l07ooOol0;Goo
00<007ooOol05goo00<07gooOol04goo00=l07ooOol0B7oo00<07gooOol0K7oo001LOol00g`0Oomo
o`0^Ool00`00Oomoo`0FOol00`0OOomoo`0EOol00g`0Oomoo`18Ool00`0OOomoo`1[Ool005]oo`03
O01oogoo02Eoo`D000Eoo`03001oogoo01Eoo`0301moogoo01Moo`03O01oogoo04Qoo`0301moogoo
06Yoo`00FWoo00=l07ooOol09Woo00D007ooOomoo`0000Eoo`03001oogoo01Eoo`0301moogoo01Qo
o`03O01oogoo04Qoo`0301moogoo06Uoo`00FGoo00=l07ooOol0:7oo00<007ooOol01Woo00<007oo
Ool057oo00<07gooOol06Woo00=l07ooOol0B7oo00<07gooOol0J7oo001HOol00g`0Oomoo`0ZOol0
0`00Oomoo`05Ool2000DOol00`0OOomoo`0LOol00g`0Oomoo`18Ool00`0OOomoo`1WOol005Moo`03
O01oogoo02aoo`03001oogoo00Aoo`03001oogoo019oo`0301moogoo01eoo`03O01oogoo04Uoo`03
01moogoo06Ioo`00EWoo00=l07ooOol0;Woo00<007ooOol00goo00<007ooOol04Goo00<07gooOol0
7goo00=l07ooOol0BGoo00<07gooOol0IGoo001EOol00g`0Oomoo`0[Ool01@00Oomoogoo00001Goo
00<007ooOol047oo00<07gooOol08Goo00=l07ooOol0BGoo00<07gooOol0I7oo001DOol00g`0Oomo
o`0]Ool30006Ool00`00Oomoo`0?Ool00`0OOomoo`0SOol00g`0Oomoo`19Ool00`0OOomoo`1SOol0
05Aoo`03O01oogoo03Ioo`03001oogoo00ioo`0301moogoo02Eoo`03O01oogoo04Uoo`0301moogoo
069oo`00Dgoo00=l07ooOol0=goo00<007ooOol03Woo00<07gooOol09Woo00=l07ooOol0B7oo00<0
7gooOol0HWoo001BOol00g`0Oomoo`0hOol2000>Ool00`0OOomoo`0XOol00g`0Oomoo`18Ool00`0O
Oomoo`1QOol0055oo`03O01oogoo03Uoo`03001oogoo00aoo`0301moogoo02Uoo`03O01oogoo04Uo
o`0301moogoo061oo`00DGoo00=l07ooOol0>Goo00<007ooOol02goo00<07gooOol0:goo00=l07oo
Ool0BGoo00<07gooOol0Ggoo001@Ool00g`0Oomoo`0jOol00`00Oomoo`0:Ool00`0OOomoo`0]Ool0
0g`0Oomoo`18Ool00`0OOomoo`1OOol004moo`03O01oogoo03]oo`03001oogoo00Uoo`0301moogoo
02moo`03O01oogoo04Qoo`0301moogoo05ioo`00CWoo00=l07ooOol0?7oo00<007ooOol02Goo00<0
7gooOol0<7oo00=l07ooOol0B7oo00<07gooOol0GGoo001>Ool00g`0Oomoo`0lOol00`00Oomoo`08
Ool00`0OOomoo`0bOol00g`0Oomoo`18Ool00`0OOomoo`1LOol004eoo`03O01oogoo03eoo`8000Qo
o`0301moogoo03=oo`03O01oogoo04Qoo`0301moogoo05aoo`00C7oo00=l07ooOol0?Woo00<007oo
Ool01Woo00<07gooOol0=Goo00=l07ooOol0B7oo00<07gooOol0Fgoo001;Ool00g`0Oomoo`0oOol0
0`00Oomoo`05Ool00`0OOomoo`0gOol00g`0Oomoo`18Ool00`0OOomoo`1JOol004]oo`03O01oogoo
03moo`03001oogoo00Eoo`0301moogoo03Qoo`03O01oogoo04Moo`0301moogoo05Yoo`00BWoo00=l
07ooOol0@7oo00<007ooOol017oo00<07gooOol0>Woo00=l07ooOol0Agoo00<07gooOol0FGoo0019
Ool00g`0Oomoo`11Ool00`00Oomoo`03Ool00`0OOomoo`0kOol00g`0Oomoo`18Ool00`0OOomoo`1H
Ool004Uoo`03O01oogoo045oo`03001oogoo009oo`0301moogoo03eoo`03O01oogoo04Moo`0301mo
ogoo05Qoo`00B7oo00=l07ooOol0@Woo0P000goo00<07gooOol0?Woo00=l07ooOol0Agoo00<07goo
Ool0Egoo0017Ool00g`0Oomoo`13Ool01@00Oomoogoo01l0@Woo00=l07ooOol0Agoo00<07gooOol0
EWoo0016Ool00g`0Oomoo`14Ool01000Oomoo`0O@goo00=l07ooOol0B7oo00<07gooOol0EGoo0016
Ool00g`0Oomoo`14Ool00`00Ool07`15Ool00g`0Oomoo`17Ool00`0OOomoo`1EOol004Eoo`03O01o
ogoo03ioo`<000Aoo`03001oo`0O04Ioo`03O01oogoo04Moo`0301moogoo05Aoo`00A7oo00=l07oo
Ool0@7oo00<007ooOol00goo00<0000OOol0Agoo00=l07ooOol0Agoo00<07gooOol0Dgoo0014Ool0
0g`0Oomoo`10Ool00`00Oomoo`03Ool00`0OOomoo`17Ool00g`0Oomoo`17Ool00`0OOomoo`1COol0
04=oo`03O01oogoo03eoo`H000=oo`0301l0000004Uoo`03O01oogoo04Moo`0301moogoo059oo`00
Q7oo00@007ooOol000Aoo`0301l007oo04Yoo`03O01oogoo09]oo`00Q7oo00@007ooOol000=oo`03
01moo`0004aoo`03O01oogoo09Yoo`00QGoo00<007oo00000goo00<07goo0000C7oo00=l07ooOol0
VWoo0026Ool20002Ool0100OOomoo`00CGoo00=l07ooOol0VGoo0029Ool01@0OOomoogoo0000CGoo
00=l07ooOol0VGoo0029Ool01@0OOomoogoo0000CWoo00=l07ooOol0V7oo0028Ool00`0OOomoo`02
Ool2001>Ool00g`0Oomoo`2GOol008Qoo`0301moogoo009oo`03001oogoo04eoo`03O01oogoo09Mo
o`00Qgoo00<07gooOol00goo00<007ooOol0CWoo00=l07ooOol0UWoo0026Ool00`0OOomoo`04Ool0
0`00Oomoo`1>Ool00g`0Oomoo`2FOol008Ioo`0301moogoo00Aoo`03001oogoo04moo`03O01oogoo
09Eoo`00QGoo00<07gooOol01Goo00<007ooOol0D7oo00=l07ooOol0U7oo0025Ool00`0OOomoo`05
Ool00`00Oomoo`1@Ool00g`0Oomoo`2DOol008Aoo`0301moogoo00Ioo`80059oo`03O01oogoo09=o
o`00Pgoo00<07gooOol01goo00<007ooOol0DGoo00=l07ooOol0Tgoo0023Ool00`0OOomoo`07Ool0
0`00Oomoo`1BOol00g`0Oomoo`2BOol0089oo`0301moogoo00Qoo`03001oogoo05=oo`03O01oogoo
095oo`00PWoo00<07gooOol027oo00<007ooOol0Dgoo00=l07ooOol0TGoo0021Ool00`0OOomoo`09
Ool00`00Oomoo`1DOol00g`0Oomoo`2@Ool0081oo`0301moogoo00Yoo`03001oogoo05Aoo`03O01o
ogoo091oo`00P7oo00<07gooOol02Woo0P00EWoo00=l07ooOol0Sgoo001oOol00`0OOomoo`0;Ool0
0`00Oomoo`1EOol00g`0Oomoo`2?Ool007moo`0301moogoo00]oo`03001oogoo05Ioo`03O01oogoo
08ioo`00OWoo00<07gooOol037oo00<007ooOol0EWoo00=l07ooOol0SWoo001nOol00`0OOomoo`04
Ool30005Ool00`00Oomoo`1GOol00g`0Oomoo`2=Ool007eoo`0301moogoo00Aoo`05001oogooOol0
0004Ool00`00Oomoo`1GOol00g`0Oomoo`2=Ool007aoo`0301moogoo00Eoo`05001oogooOol00004
Ool00`00Oomoo`1HOol00g`0Oomoo`2<Ool007aoo`0301moogoo00Eoo`05001oogooOol00004Ool2
001IOol00g`0Oomoo`2<Ool007]oo`0301moogoo00Ioo`@000Eoo`03001oogoo05Uoo`03O01oogoo
08]oo`00Ngoo00<07gooOol01Woo00<007ooOol01Woo00<007ooOol0FGoo00=l07ooOol0Rgoo001j
Ool00`0OOomoo`08Ool00`00Oomoo`05Ool00`00Oomoo`1JOol00g`0Oomoo`2:Ool007Yoo`0301mo
ogoo00Uoo`<000Aoo`03001oogoo05Yoo`03O01oogoo08Yoo`00NGoo00<07gooOol04Goo00<007oo
Ool0Fgoo00=l07ooOol0RGoo001iOol00`0OOomoo`0AOol00`00Oomoo`1LOol00g`0Oomoo`28Ool0
07Qoo`0301moogoo019oo`8005eoo`03O01oogoo08Qoo`00N7oo00<07gooOol04Woo00<007ooOol0
GGoo00=l07ooOol0Qgoo001gOol00`0OOomoo`0COol00`00Oomoo`1MOol00g`0Oomoo`27Ool007Mo
o`0301moogoo01=oo`03001oogoo05ioo`03O01oogoo08Ioo`00MWoo00<07gooOol057oo00<007oo
Ool0GWoo00=l07ooOol0QWoo001fOol00`0OOomoo`0DOol00`00Oomoo`1OOol00g`0Oomoo`25Ool0
07Eoo`0301moogoo01Eoo`03001oogoo05moo`03O01oogoo08Eoo`00MGoo00<07gooOol05Goo0P00
HGoo00=l07ooOol0Q7oo001dOol00`0OOomoo`0FOol00`00Oomoo`1POol00g`0Oomoo`24Ool007Ao
o`0301moogoo01Ioo`03001oogoo065oo`03O01oogoo08=oo`00Lgoo00<07gooOol05goo00<007oo
Ool0HGoo00=l07ooOol0Pgoo001cOol00`0OOomoo`0GOol00`00Oomoo`1ROol00g`0Oomoo`22Ool0
079oo`0301moogoo01Qoo`03001oogoo069oo`03O01oogoo089oo`00LWoo00<07gooOol067oo00<0
07ooOol0Hgoo00=l07ooOol0PGoo001aOol00`0OOomoo`0IOol2001TOol00g`0Oomoo`21Ool0075o
o`0301moogoo01Uoo`03001oogoo06Aoo`03O01oogoo081oo`00L7oo00<07gooOol06Woo00<007oo
Ool0I7oo00=l07ooOol0P7oo001`Ool00`0OOomoo`0JOol00`00Oomoo`1UOol00g`0Oomoo`1oOol0
06moo`0301moogoo019oo`@000Eoo`03001oogoo06Eoo`03O01oogoo07moo`00Kgoo00<07gooOol0
4Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0IWoo00=l07ooOol0OWoo001^Ool00`0O
Oomoo`0BOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1VOol00g`0Oomoo`1nOol006io
o`0301moogoo019oo`03001oogoo009oo`03001oogoo009oo`8006Qoo`03O01oogoo07eoo`00KWoo
00<07gooOol04goo10001Goo00<007ooOol0Igoo00=l07ooOol0OGoo001]Ool00`0OOomoo`0COol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1XOol00g`0Oomoo`1lOol006eoo`0301moogoo
01=oo`03001oogoo009oo`03001oogoo009oo`03001oogoo06Qoo`03O01oogoo07aoo`00K7oo00<0
7gooOol05Goo10001Goo00<007ooOol0JGoo00=l07ooOol0Ngoo001/Ool00`0OOomoo`0NOol00`00
Oomoo`1YOol00g`0Oomoo`1kOol006]oo`0301moogoo01moo`03001oogoo06Yoo`03O01oogoo07Yo
o`00Jgoo00<07gooOol07goo0P00Jgoo00=l07ooOol0NWoo001[Ool00`0OOomoo`0OOol00`00Oomo
o`1ZOol00g`0Oomoo`1jOol006Yoo`0301moogoo021oo`03001oogoo06]oo`03O01oogoo07Uoo`00
JWoo00<07gooOol087oo00<007ooOol0Jgoo00=l07ooOol0NGoo001YOol00`0OOomoo`0QOol00`00
Oomoo`1/Ool00g`0Oomoo`1hOol006Uoo`0301moogoo025oo`03001oogoo06aoo`03O01oogoo07Qo
o`00J7oo00<07gooOol08Woo00<007ooOol0KGoo00=l07ooOol0Mgoo001XOol00`0OOomoo`0ROol2
001^Ool00g`0Oomoo`1gOol006Qoo`0301moogoo029oo`03001oogoo06ioo`03O01oogoo07Ioo`00
Igoo00<07gooOol08goo00<007ooOol0KWoo00=l07ooOol0MWoo001WOol00`0OOomoo`0SOol00`00
Oomoo`1^Ool00g`0Oomoo`1fOol006Ioo`0301moogoo02Aoo`03001oogoo06moo`03O01oogoo07Eo
o`00IWoo00<07gooOol097oo00<007ooOol0Kgoo00=l07ooOol0MGoo001UOol00`0OOomoo`0UOol0
0`00Oomoo`1`Ool00g`0Oomoo`1dOol006Eoo`0301moogoo02Eoo`80075oo`03O01oogoo07Aoo`00
IGoo00<07gooOol09Goo00<007ooOol0LGoo00=l07ooOol0Lgoo001TOol00`0OOomoo`0VOol00`00
Oomoo`1aOol00g`0Oomoo`1cOol006Aoo`0301moogoo02Ioo`03001oogoo075oo`03O01oogoo07=o
o`00Hgoo00<07gooOol05Woo1@000goo10001Goo00<007ooOol0LWoo00=l07ooOol0LWoo001SOol0
0`0OOomoo`0HOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1bOol0
0g`0Oomoo`1bOol0069oo`0301moogoo01Uoo`03001oogoo009oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo07=oo`03O01oogoo075oo`00HWoo00<07gooOol06Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol00Woo0P00M7oo00=l07ooOol0LGoo001QOol00`0OOomoo`0JOol00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1dOol00g`0Oomoo`1`Ool0065o
o`0301moogoo01Yoo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo07Ao
o`03O01oogoo071oo`00O7oo0`0017oo00<007ooOol00Woo00<007ooOol0k7oo001nOol00`00Oomo
o`03Ool4003_Ool00?moogQoo`00ogooN7oo003oOomhOol00?moogQoo`00ogooN7oo003oOomhOol0
0?moogQoo`00ogooN7oo002:Ool6003WOol008aoo`03001oogoo0>Qoo`00S7oo00<007ooOol0j7oo
002<Ool00`00Oomoo`3XOol008aoo`03001oogoo0>Qoo`00RWoo1P00igoo002<Ool00`00Oomoo`3X
Ool008eoo`<00>Moo`00ogooN7oo003oOomhOol00?moogQoo`00\
\>"],
  ImageRangeCache->{{{0, 374}, {177.75, 0}} -> {-3.79853, -1.01479, 0.033552, \
0.0894346}}]
}, Open  ]],

Cell[TextData[{
  "The command ",
  StyleBox["Evaluate[] ", "MmaText"],
  "used in the function ",
  StyleBox["Plot[] ", "MmaText"],
  "forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to do the calculations first and then display the results. The shift of \
translation in the example is set to ",
  Cell[BoxData[
      \(TraditionalForm\`a = \(-2\)\)]],
  ". We clearly observe that the parabola is translated to the right by the \
length ",
  StyleBox["a",
    FontSlant->"Italic"],
  ". \[ThickSpace]\[ThickSpace]\[ThickSpace]\[EmptySquare]"
}], "Text",
  CellTags->"Plot[]"],

Cell["Example 5", "Example"],

Cell[TextData[{
  "Another example frequently encountered in symmetry analysis of \
differential equations is the scaling group. A scaling transformation reduces \
or enlarges an object depending on the amount of the scaling factor. A \
scaling of a geometrical object is carried out practically by multiplying the \
coordinates of the object by the scaling factor. A function allowing this \
operation can be defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  by"
}], "Text",
  Evaluatable->False,
  CellTags->{"coordinates", "scaling group"}],

Cell[BoxData[{
    \(\(Clear[Scaling]; \)\), 
    \(Scaling[object_Polygon, factor_] := \n\t\t
      \(points = object /. Polygon[X___] \[Rule] Polygon[factor\ X]\)\)}], 
  "Input"],

Cell["\<\
This definition assumes that the geometric object is given by a \
polygon. Applying this function to an object, for example, a pentagon, we can \
reduce or enlarge the figure depending on the second argument of the \
function. Choosing the factor greater than 1, we stretch the object; taking a \
factor smaller than 1, we shrink it. The pentagon is generated by\
\>", "Text",\

  Evaluatable->False,
  CellTags->{"polygon", "pentagon"}],

Cell[BoxData[
    \(\(pentagon = 
      Polygon[Table[{Cos[i], Sin[i]}, \n
          \t\t\t{i, 0, 2\ \[Pi], \(2\ \[Pi]\)\/5}]]; \)\)], "Input"],

Cell[TextData[{
  "Let us now examine how the shape of the pentagon changes when the scaling \
factor is changed. An animation of this change of scaling factors helps us to \
recognize the meaning of scaling. The following ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code contains a ",
  StyleBox["Do[]", "MmaText"],
  " loop which allows the decrease of the scaling factor. For the animation, \
we choose the scaling factor in the range from 1 to 0.1 in steps of 0.05. The \
action of the scaling is boosted by changing the color of the pentagon."
}], "Text",
  Evaluatable->False,
  CellTags->{"Do[]", "scaling factor"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[\n\t
      Show[Graphics[{Hue[i], Scaling[pentagon, i]}, \n\t\t\t
          AspectRatio \[Rule] Automatic], \n\t\t
        PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {i, 1,  .1, \(- .05\)}]
      \)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
1 .5 m
.65451 .97553 L
.09549 .79389 L
.09549 .20611 L
.65451 .02447 L
1 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Center,
  TextJustification->0,
  ImageSize->{144.313, 144.313},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00Lgoo0g`0?Woo001`Ool6O00nOol006eoo`Yl03eoo`00JWoo3W`0?7oo
001VOolCO00kOol006=ooaIl03]oo`00H7oo6W`0>Woo001MOolNO00iOol005Yoob9l03Qoo`00Egoo
9G`0>7oo001DOolYO00gOol0055oobel03Ioo`00CGoo<G`0=Woo001:OoleO00eOol004MoocUl03Ao
o`00A7oo?G`0<goo0011Oom0O00cOol003ioodAl039oo`00>gooB7`0<Goo000hOom<O00`Ool003Ao
oe1l031oo`00<GooE7`0;goo000^OomHO00^Ool002]ooeal02eoo`00:7ooGg`0;Goo000UOomSO00/
Ool0029oofMl02]oo`007gooJW`0:goo000KOom_O00ZOol001Qoog=l02Uoo`005GooMg`0:7oo000A
OomkO00XOol0015oogal02Moo`004GooOG`09Woo000AOomnO00UOol0015oogil02Eoo`004GooOg`0
97oo000AOon0O00SOol0015ooh1l02=oo`004GooPG`08Woo000AOon2O00QOol0015ooh=l021oo`00
4GooPg`087oo000AOon4O00OOol0015oohEl01ioo`004GooQW`07Goo000AOon6O00MOol0015oohMl
01aoo`004GooR7`06goo000AOon8O00KOol0015oohUl01Yoo`004GooRW`06Goo000AOon;O00HOol0
015ooh]l01Qoo`004GooS7`05goo000AOon=O00FOol0015oohil01Eoo`004GooSW`05Goo000AOon?
O00DOol0015ooi1l01=oo`004GooT7`04goo000AOonAO00BOol0015ooi9l015oo`004GooTg`047oo
000AOonCO00@Ool0015ooiAl00moo`004GooUG`03Woo000AOonFO00=Ool0015ooiIl00eoo`004Goo
Ug`037oo000AOonHO00;Ool0015ooiUl00Yoo`004GooVG`02Woo000AOonJO009Ool0015ooi]l00Qo
o`004GooVg`027oo000AOonLO007Ool0015ooiel00Ioo`004GooWW`01Goo000AOonNO005Ool0015o
oiml00Aoo`004GooX7`00goo000AOonQO002Ool0015ooj5l009oo`004GooXW`00Goo000AOonQO002
Ool0015ooj5l009oo`004GooX7`00goo000AOonOO004Ool0015ooiil00Eoo`004GooWW`01Goo000A
OonMO006Ool0015ooial00Moo`004GooVg`027oo000AOonKO008Ool0015ooiYl00Uoo`004GooVG`0
2Woo000AOonIO00:Ool0015ooiQl00]oo`004GooUg`037oo000AOonFO00=Ool0015ooiIl00eoo`00
4GooUG`03Woo000AOonDO00?Ool0015ooi=l011oo`004GooTg`047oo000AOonBO00AOol0015ooi5l
019oo`004GooT7`04goo000AOon@O00COol0015oohml01Aoo`004GooSW`05Goo000AOon>O00EOol0
015oohel01Ioo`004GooS7`05goo000AOon;O00HOol0015ooh]l01Qoo`004GooRW`06Goo000AOon9
O00JOol0015oohQl01]oo`004GooR7`06goo000AOon7O00LOol0015oohIl01eoo`004GooQW`07Goo
000AOon5O00NOol0015oohAl01moo`004GooPg`087oo000AOon3O00POol0015ooh9l025oo`004Goo
PG`08Woo000AOon0O00SOol0015ooh1l02=oo`004GooOg`097oo000AOomnO00UOol0015oogil02Eo
o`004GooOG`09Woo000AOomlO00WOol0015oog]l02Qoo`004gooNG`0:7oo000FOomeO00YOol001Uo
og5l02Yoo`0077ooKG`0:goo000POomYO00[Ool002=oofEl02aoo`009WooHG`0;Goo000YOomNO00]
Ool002aooeYl02ioo`00;gooEW`0;goo000bOomBO00`Ool003Eoodml031oo`00>GooBW`0<Goo000l
Oom6O00bOol003mood9l03=oo`00@Woo?g`0<goo0015OolkO00dOol004QoocMl03Eoo`00Bgoo<g`0
=Woo001>Ool`O00fOol0059oob]l03Moo`00EGoo9g`0>7oo001HOolTO00hOol005]oob1l03Uoo`00
GWoo77`0>Woo001QOolHO00kOol006AooaEl03]oo`00Igoo4G`0?7oo001[Ool<O00mOol006ioo`Ql
03ioo`00LGoo1G`0?Woo002dOol00;Aoo`00]7oo002dOol00;Aoo`00\
\>"],
  ImageRangeCache->{{{0, 179.375}, {179.375, 0}} -> {-1.00001, -1.00001, \
0.0139374, 0.0139374}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 .3 r
.975 .5 m
.64678 .95175 L
.11572 .7792 L
.11572 .2208 L
.64678 .04825 L
.975 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00LGoo00=l2G`8O0T0?goo001^Ool01W`9O0Ql
2G`8O0Ul23moo`00Jgoo00Yl2G`8O0Ul27`9O0Ql2G`8O0Ul23ioo`00J7oo00il2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8?Goo001UOol04W`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
23aoo`00HWoo01El2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T0?7oo001O
Ool06G`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`903]oo`00
G7oo01el2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`903Yoo`00F7oo029l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CUoo`00EGoo02El27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200iOol0059oo`0YO0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul200hOol004moo`0]O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
03Moo`00C7oo031l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TgOol004Uoo`0dO0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TfOol004Ioo`0hO0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CEoo`00@goo03al27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TdOol0041o
o`0oO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`803Aoo`00?Goo04=l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200cOol003Yoo`17O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul200bOol003Moo`1;O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8035oo`00=7oo04il
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TaOol0035oo`1BO0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T`Ool002ioo`1FO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2Bmoo`00:Woo05Yl2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P_Ool002Moo`1NO0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P^
Ool002Aoo`1RO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul22eoo`008Goo06Il2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P/
Ool001ioo`1YO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`902aoo`006goo06el2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0[Ool001Qoo`1aO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0ZOol001Aoo`1fO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TYOol001Aoo`1fO0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PYOol001Aoo`1gO0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200XOol001Aoo`1hO0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`89goo
000DOol0N7`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2BMoo`0057oo07Ul2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2@0VOol001Aoo`1jO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2BEoo`0057oo07]l2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T097oo000DOol0
Ng`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul200TOol001Aoo`1lO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PSOol001Aoo`1mO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200ROol001Aoo`1nO0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`88Goo000DOol0OW`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2B5oo`0057oo07ml2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0POol0
01Aoo`20O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2Amoo`0057oo085l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T07Woo000DOol0
PG`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul200NOol001Aoo`22O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PMOol001Aoo`23
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200LOol001Aoo`23O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0LOol0
01Aoo`24O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`96goo000DOol0QG`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`901Yoo`0057oo08Il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`96Goo000DOol0QW`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PIOol001Aoo`27O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`801Qoo`0057oo08Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul21Moo`0057oo08Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`801Ioo`0057oo08Ul2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`901Ioo`0057oo08Yl27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0TEOol001Aoo`2;O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T057oo000DOol0
Rg`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`801Aoo`0057oo08al2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`84goo000DOol0SG`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200BOol001Aoo`2>O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0PAOol001Aoo`2>O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0TAOol001Aoo`2?O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2@0@Ool001Aoo`2@O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`93goo000DOol0TG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`900ioo`0057oo095l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul200>Ool001Aoo`2BO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul20eoo`0057oo09=l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0P037oo000DOol0Tg`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2@0<Ool001Aoo`2DO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T;Ool001Aoo`2EO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0:Ool001Aoo`2FO0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`92Goo000DOol0UW`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20Uoo`00
57oo09Ml27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul2008Ool001Aoo`2HO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20Moo`0057oo09Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P01Woo000DOol0VG`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@06Ool0
01Aoo`2JO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0T5Ool001Aoo`2IO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900Ioo`0057oo09Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P01Woo000DOol0V7`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0P7Ool001Aoo`2GO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0P027oo000DOol0UW`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20Uoo`0057oo09Il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T9Ool001Aoo`2EO0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0:Ool001Aoo`2DO0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T;Ool001Aoo`2C
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900aoo`00
57oo09=l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P0
37oo000DOol0TW`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0P=Ool001Aoo`2AO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0P03Woo000DOol0TG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`900ioo`0057oo091l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0T?Ool001Aoo`2?O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0@
Ool001Aoo`2>O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TAOol001Ao
o`2>O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PAOol001Aoo`2=O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8019oo`0057oo08al2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`84goo000DOol0Rg`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`801Aoo`0057oo08]l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2@0DOol001Aoo`2:O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`95Goo000D
Ool0RG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T05Woo000DOol0RG`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P05Woo000DOol0R7`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`85goo000DOol0Qg`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200HOol001Aoo`26O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul21Uoo`0057oo08Il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`96Goo000DOol0QG`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`901Yoo`0057oo08Al27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0TKOol001Aoo`23O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0LOol001Aoo`23O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul200LOol001Aoo`22O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PMOol001Aoo`21
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`801ioo`0057oo085l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T07Woo000DOol0P7`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0TOOol001Aoo`1oO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T087oo000DOol0OW`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2B5oo`0057oo07il2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PQOol001Aoo`1mO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200ROol001Aoo`1lO0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0PSOol001Aoo`1kO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`802Aoo`0057oo07]l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T097oo000DOol0NW`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TUOol001Aoo`1i
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0T09Woo000DOol0N7`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2BMoo`0057oo07Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PWOol001Aoo`1gO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200XOol001Aoo`1fO0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0PYOol001Aoo`1fO0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0TYOol001Ioo`1cO0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T0:Woo000IOol0Kg`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0[Ool001aoo`1[O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0/Ool001moo`1XO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
22aoo`008Woo06Al2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul22eoo`009Goo061l2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P^Ool002Qo
o`1LO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul22moo`00:goo05Ul2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`902moo`00;goo05Al27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0T`Ool0039oo`1@O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2C5oo`00=Goo04el27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8035oo`00>7oo04Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul200bOol003]oo`15O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`803=oo`00
?Woo045l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`803Aoo`00@Goo03il27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9=7oo0014Ool0>W`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9=Goo0017Ool0=W`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CIoo`00BWoo039l27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9=goo001=Ool0;g`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0P0=goo001@Ool0:g`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`803Qoo`00Dgoo02Ml27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0P0>Goo001FOol097`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2CUoo`00FGoo021l27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9>Woo001MOol0
6g`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0kOol0
061oo`0GO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0lOol006=o
o`0DO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul23aoo`00IWoo011l2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul23eoo`00JGoo00al2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Pn
Ool006aoo`08O0Ul27`9O0Ql2G`8O0Ul23moo`00Kgoo00El2G`8O0Ul27`903moo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 .6 r
.95 .5 m
.63906 .92798 L
.13594 .7645 L
.13594 .2355 L
.63906 .07202 L
.95 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0071o
o`03O1=l4W`B041oo`00KGoo1W`B@7oo001ZOol01G`CO19l4W`BO1<00g`B00=l4g`BOol0?Woo001W
Ool>O18nOol006Aoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`BOol0?7oo001P
OolFO18mOol005eoo`03O19l4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C03aoo`00FWoo7W`B>goo001GOol00g`BO1=l4P02O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0>Woo001DOolUO18jOol0055o
o`03O19l4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O18017`CO19l4W`B>Goo001>Ool]O18hOol004]oo`03O19l4g`B009l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00=l4g`BO180>7oo0018OoldO18gOol004Aoo`9l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`02O18fOol0045oocel4SEoo`00?Woo
0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P06O1=l
4W`BO19l4g`B=Goo000kOom4O18dOol003Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO18cOol003Eo
od]l4S=oo`00<Woo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C039oo`00;goo
Dg`B<Goo000/Ool2O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C031oo`00:GooFW`B<7oo000UOol3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P04O1=l4W`BO18_Ool0029oof=l4Rioo`007goo0g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00Al4g`BO19l4Reoo`0077ooJW`B;Goo000HOol01G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C009l4Raoo`0067ooL7`B:goo000HOol2O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00Il4g`BO19l4W`CO18[Ool001Qoog5l4RYoo`0067oo00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19oo`0XOol001Qoog=l4RQoo`0067oo0W`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`COomoo`0VOol001Qo
ogAl4RMoo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<09Woo000HOomfO18UOol001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00Al4g`BO19l4REoo`0067ooMg`B97oo000HOol01G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18SOol001QoogQl4R=oo`00
67oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00W`B8Woo000HOomjO18QOol001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P03O1=l4W`B021oo`0067ooNg`B87oo000HOol2O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`C
O19oo`0NOol001Qoogel4Qioo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C01ioo`0067ooOW`B7Goo000HOol2O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<077oo000HOon0O18KOol001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18KOol001Qooh5l4QYo
o`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4QUoo`0067ooPg`B67oo000HOol01G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00=l4g`BO18067oo000HOon4O18GOol001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P0FOol0
01QoohEl4QIoo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P06O1=l4W`BO19l4g`B5Goo000HOon7O18DOol0
01Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801W`CO19l4W`BO1=l4Q=oo`0067ooR7`B4goo000HOol01G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P03O1=oogoo011oo`0067ooRW`B4Goo000HOol2O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4Q5oo`0067ooRg`B47oo000HOol01G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P04O1=l4W`BO18?Ool001Qoohel4Pioo`0067oo0W`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P0>Ool001Qoohil4Peoo`0067oo00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00W`B37oo000HOon@O18;Ool001Qo
o`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO18;Ool001Qooi5l
4PYoo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B2goo
000HOon@O18;Ool001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00aoo`0067ooSW`B3Goo000HOol01G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`0>Ool001Qoohel4Pioo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1800g`CO19oo`0>Ool001Qooh]l4Q1oo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1800g`CO19l4P0@Ool001QoohYl4Q5oo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`02O18BOol001QoohQl4Q=oo`0067oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18COol0
01QoohMl4QAoo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P04O1=l4W`BO18EOol001QoohIl4QEoo`00
67oo00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`0FOol001QoohAl4QMoo`0067oo0W`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P03O1=oogoo01Ioo`0067ooPg`B67oo000HOol01G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`B
Ool067oo000HOon1O18JOol001Qoo`9l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`02O18JOol001Qooh1l4Q]oo`0067oo
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C009l4Qaoo`0067ooOW`B7Goo000HOol2O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18017`CO19l4W`B7Goo000HOommO18N
Ool001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P04O1=l4W`BO18OOol001Qoogal4Qmoo`0067oo0W`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4gooOol07Woo000HOomjO18Q
Ool001Qoo`05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P03O1=oogoo021oo`0067ooNG`B8Woo000HOol2O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P06O1=l4W`BO19l4g`B8goo000HOomgO18TOol001Qoo`05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C009l4RAoo`00
67ooMW`B9Goo000HOol2O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P03O1=l4W`B02Ioo`0067ooM7`B9goo000HOol01G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P04O1=l4W`BO18WOol001Qoog=l4RQoo`0067oo0W`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18YOol001Qoog9l4RUoo`0067oo00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`COomoo`0XOol001Qoog1l4R]oo`0067oo
0W`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`0/Ool001Yoofel4Raoo`00
7Goo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00Il4g`BO19l4W`CO18]Ool0021oofEl4Rioo`008goo0g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00W`B;Woo000VOomNO18_Ool002Uoo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00W`B<7oo000/OomFO18aOol002moo`=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O18aOol0039oodml4S9oo`00=Goo0g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B<goo000hOom8O18cOol003]oo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4gooOol0<Woo000nOom0
O18eOol0045oo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1800g`COomoo`0dOol004AoocUl4SIoo`00Agoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00=l4g`BOol0=Woo001:OolaO18hOol004eoo`=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00=l4g`BO180>7oo001@OolZO18iOol005=oo`=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P0jOol005Ioob9l4S]o
o`00FGoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00Al
4g`BO19l4S]oo`00G7oo6g`B?7oo001OOol3O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P04O1=l4W`BO18mOol0069ooaAl4Seoo`00IGoo0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`0nOol006Qoo`al4Smoo`00Jgoo0g`B00El4g`BO19l4W`C041oo`00KWoo1G`B@7oo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00001
\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 .9 r
.925 .5 m
.63133 .9042 L
.15617 .74981 L
.15617 .25019 L
.63133 .0958 L
.925 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00KWoo00=l77`KO1`0@Woo001[Ool6O1a2Ool006Qoo`0:O1al6g`LO1]l
77`KO1al6g`LO1]1Ool006Eoo`il741oo`00HWoo019l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1/oOol005mooaEl73moo`00G7oo01Ul77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l700nOol005Uooael73eoo`00EWoo025l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`0?7oo001COolTO1`l
Ool0051oo`0XO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/kOol004eoobal73Yoo`00BWoo031l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/iOol004Mooc=l73Uoo`00@goo03Ql6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L>7oo0010OollO1`gOol003eoo`10
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1`fOol003Yood=l73Ioo`00=goo04Ml6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K03Eoo`00=7oo
Bg`L=7oo000aOol0CW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l73Aoo`00;WooDW`L
<goo000[Ool0EW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1`bOol002QooeYl735oo`009Goo05el6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/0<Goo000ROomQO1``Ool001moo`1UO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6`0_Ool001]oofYl72ioo`006goo06Yl6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l72ioo`006gooJg`L;Goo000KOol0K7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l72aoo`006gooKG`L:goo000KOol0KG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`K02]oo`006gooKW`L:Woo000KOol0Kg`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6`0YOol001]oog1l72Qoo`006goo071l6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l72Qoo`006gooLG`L9goo000KOol0LW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l72Ioo`006gooLW`L9Woo000KOol0Lg`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02Eoo`006gooM7`L97oo000KOol0MG`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0SOol001]oogEl
72=oo`006goo07Il6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l729oo`006gooMg`L8Goo000KOol0N7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l721oo`006gooN7`L87oo000KOol0NG`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K01moo`006goo
NW`L7Woo000KOol0Ng`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6`0MOol001]oog]l71eoo`006goo07al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l71aoo`006gooOG`L
6goo000KOol0OG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1/06goo000KOomnO1`JOol001]oo`1oO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/06Goo
000KOon0O1`HOol001]oo`20O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l71Qoo`006gooPG`L5goo000KOol0PW`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`L5Woo000KOon3O1`EOol001]oo`23O1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0E
Ool001]oohAl71Aoo`006goo08El6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0COol001]oohIl719o
o`006goo08Il6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L4Woo000KOon7O1`AOol001]oo`28O1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`@Ool001]oohUl70moo`006goo08Ul6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`K00moo`006gooRW`L3Woo000KOol0RG`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1/03goo000KOon9O1`?Ool001]oo`28O1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1`@Ool001]oohMl715oo`006goo08Il6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`L4Woo000KOon6O1`BOol001]oo`25O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/04goo000KOon4
O1`DOol001]oo`23O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0EOol001]ooh=l71Eoo`006goo089l6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l71Ioo`006gooPG`L5goo000KOol0P7`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`HOol001]o
oh1l71Qoo`006goo07ml6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`0IOol001]oogil71Yoo`006goo07el6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
01]oo`006gooOG`L6goo000KOol0O7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L77oo000KOomkO1`MOol001]oo`1kO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K01eo
o`006gooNW`L7Woo000KOol0NG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`K01moo`006gooN7`L87oo000KOol0N7`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l721oo`006gooMg`L8Goo000K
Ool0MW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
8Woo000KOomeO1`SOol001]oo`1eO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`K02=oo`006gooM7`L97oo000KOol0Lg`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02Eoo`006gooLW`L9Woo000KOol0LW`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l72Ioo`006gooLG`L9goo000KOol0L7`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L:7oo000KOom`O1`XOol001]o
o`1_O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02Uoo`006gooKW`L:Woo
000KOol0KG`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02]oo`006gooKG`L:goo
000KOol0K7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l72aoo`006gooJg`L;Goo000K
Ool0JW`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L;Woo000KOomZO1`^Ool001]oo`1YO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K02moo`007GooIW`L<7oo000POol0HW`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1/aOol002=ooeml735oo`009goo05Yl6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`bOol002YooeIl73=oo`00;Goo059l6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l73Aoo`00<7ooCg`L=7oo000cOol0Bg`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6`0eOol003IoodMl73Ioo`00>Goo04Al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
=Woo000mOoloO1`gOol0041oo`0kO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l700hOol004=oocMl73Uoo`00AWoo03Al77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6cUoo`00BGoo<7`L>Woo001<Ool0;7`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1/kOol004moobQl73aoo`00Dgoo02Al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`lOol005Ioob1l73eo
o`00FGoo01al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l73ioo`00G7oo67`L?goo001OOol05G`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6`0oOol0069ooa5l741oo`00IGoo00el6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`11Ool0
06Uoo`Ql749oo`00K7oo00El77`KO1al6g`L049oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 0 1 r
.9 .5 m
.62361 .88042 L
.17639 .73511 L
.17639 .26489 L
.62361 .11958 L
.9 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo001]Ool00f0OI1mP7`13Ool006Yoo`06
H1mT7f0OI1mP7f@O@goo001WOol02V0OI1mP7f@OH1mT7f0OI1mP7f@O@Woo001TOol03V0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1m1Ool0065oo`0BH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@O@7oo001NOol05F0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`10
Ool005Yoo`0JI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7cmoo`00Egoo01iT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1lnOol005Aoo`0QI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O03ioo`00DGoo02ET7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0mOol004io
o`0YI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0lOol004]oo`0]I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@O03]oo`00B7oo031T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lkOol004Eo
o`0dI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1ljOol0049oo`0hI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7cUoo`00?goo03aT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lh
Ool003aoo`0oI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@O03Qoo`00>Goo04=T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0gOol003Ioo`17I1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7`0fOol0039oo`1;H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03Ioo`00
;goo04mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0eOol002aoo`1CH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0dOol002Uoo`1GH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03=oo`009Woo05YP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lcOol0
02=oo`1NH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1lbOol001moo`1SI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O035oo`007goo06=P7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l0<Goo000OOol0I6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O<7oo000OOol0IF0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1l0;goo000OOol0IV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7bioo`007goo06IP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l^Ool001moo`1WI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0
;Goo000OOol0J60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l/Ool001moo`1YI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@O02]oo`007goo06UP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0
:goo000OOol0JV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O:Woo000OOol0Jf0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0:Goo000OOol0Jf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1l0:Goo000OOol0K60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7bQo
o`007goo06eT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0WOol001moo`1^H1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7bIoo`007goo06iT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O9Woo000OOol0Kf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7`0UOol001moo`1`I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1lTOol001moo`1`H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1lTOol001moo`1aI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7`0SOol001moo`1bH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@O8Woo000OOol0Lf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@O025oo`007goo07=P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`0QOol001moo`1dI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7b1oo`007goo07EP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l07goo000OOol0MF@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7`0OOol001moo`1fH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lNOol001moo`1gI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0MOol001moo`1hH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O77oo000OOol0N6@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7aaoo`007goo
07UP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`0KOol001moo`1jI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7aYoo`007goo07]P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l06Goo000OOol0Nf@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0IOol001mo
o`1lH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1lHOol001moo`1mI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0GOol001moo`1mH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0GOol001mo
o`1nI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0O5Woo000OOol0Of0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O01Eoo`007goo081T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0O57oo000OOol0P60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lDOol001moo`21I1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
01=oo`007goo081P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O57oo000OOol0P6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lDOol001mo
o`1oH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1l05Goo000OOol0OV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7aIoo`007goo07eP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
01Moo`007goo07eT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O01Moo`007goo07aP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7aQoo`007goo07]T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l06Goo
000OOol0Nf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`0IOol001moo`1jI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7aYoo`007goo07UP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0KOol001moo`1hI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O77oo000OOol0
N60OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7aaoo`007goo07MT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O01eoo`007goo07IP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7aioo`007goo07ET7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l07goo000OOol0MF0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0OOol001moo`1dI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7b1oo`007goo07=P7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0QOol001moo`1cI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l08Goo000OOol0LV0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7b9oo`007goo075T7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O02=oo`007goo071P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7bAoo`007goo071T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7bAoo`007goo06mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1l09Goo000OOol0KV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lVOol0
01moo`1^H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7bIoo`007goo06eT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`0WOol001moo`1/H1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O:7oo000OOol0Jf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1l0:Goo000OOol0Jf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0:Goo000OOol0
JV@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O:Woo000OOol0JF0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7`0[Ool001moo`1YI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O02]oo`00
7goo06QP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O;7oo000OOol0If@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O02eoo`007goo06IP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l^Ool001moo`1VI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O;Woo000OOol0IF0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l0;goo000OOol0
I6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0O<7oo000OOol0Hf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0aOol001moo`1S
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@O035oo`008Goo061P7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1lbOol002Aoo`1LH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7c=oo`00
9goo05UP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0O03=oo`00:Woo05EP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7`0dOol002eoo`1AH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03Eo
o`00<7oo04eP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O03Ioo`00=7oo04UT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`0fOol003Moo`15I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O03Moo`00>Woo045T
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@O03Qoo`00?Goo03iT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O>7oo0010Ool0>V@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O>Goo0013Ool0=V@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7cYoo`00AWoo039T7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0O>goo0019Ool0;f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1l0>goo001<Ool0:f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O03aoo`00Cgoo02MT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1l0?Goo001BOol08f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0?Woo001EOol086@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1lnOol005Qoo`0LI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1loOol005aoo`0G
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`10Ool005moo`0DH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7d1oo`00HWoo011P7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7d5oo`00IGoo00aP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1m2Ool006Qo
o`08H1mT7f0OI1mP7f@OH1mT7d=oo`00Jgoo00EP7f@OH1mT7f0O04=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo0000\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 0 1 r
.875 .5 m
.61588 .85665 L
.19662 .72042 L
.19662 .27958 L
.61588 .14335 L
.875 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol006ao
o`<l7dAoo`00JGoo1S`OA7oo001VOol3?1l01CPO?1ll7c`O>1l00S`O@goo001SOol>?1m2Ool0061o
o`<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00S`O@Goo001MOolE?1m1Ool005Yoo`<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Hh7c`O?1ll7cPO?1m0Ool005Mooadl7cmoo`00
E7oo0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO03moo`00DGoo93`O?Woo001>Ool3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO03eoo`00Bgoo;3`O?7oo
0018Ool3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`04>1ll7c`O?1llOol004Eooc<l7c]oo`00@Woo0c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00@h7c`O?1ll7cYoo`00?goo>c`O>Goo
000lOol3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00<h7c`O?1l0>Goo000iOom2?1lhOol003Ioo`<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7c`O?1l0=goo000cOom9?1lg
Ool0031oo`<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`03>1ll7goo03Eoo`00;GooDC`O=Goo000Z
Ool3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7c`OOol0<goo000W
OomH?1ldOol002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO03=oo`008gooGS`O<Woo000SOol2?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`04>1ll7c`O?1lbOol002=ooell
7c5oo`008goo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O<7oo000SOomQ?1l_Ool002=oo`8l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO008l7bmoo`00
8gooHS`O;Woo000SOol01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l00cPO?1ll7`0]Ool002=oof<l7beoo`008goo0S`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00<h7c`OOol0:goo000SOomU?1l[Ool002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`06>1ll7c`O?1lh
7c`O:Woo000SOomV?1lZOol002=oo`8l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`0YOol002=oofPl
7bQoo`008goo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7bQoo`008gooJC`O9goo000SOol2?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O9Woo000SOom[?1lUOol002=oo`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l00cPO?1ll7`0UOol002=oof`l7bAoo`008goo0S`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`03>1ll7c`O02=oo`008gooKS`O8Woo000SOol01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Hh7c`O?1ll7cPO?1lROol002=oofll7b5oo`008goo0S`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`06>1ll7c`O?1lh7c`O87oo000SOom`?1lPOol002=oo`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7gooOol07Goo000SOomb?1lNOol002=oo`8l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7gooOol06goo000S
Oomc?1lMOol002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00@h
7c`O?1ll7aaoo`008gooMC`O6goo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`03>1ll7c`O01]oo`008gooMS`O6Woo000SOol01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`02?1lIOol002=oogPl7aQoo`008goo
0S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01SPO?1ll7c`O>1ll
7aQoo`008gooNC`O5goo000SOol01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1lHOol002=oogPl7aQoo`008goo0S`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l06Goo000SOomf?1lJOol002=oo`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO01]oo`00
8gooMC`O6goo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`03>1ll7goo01]oo`008gooLc`O7Goo000SOol01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`03>1ll7c`O01eoo`008gooLS`O7Woo000SOol2?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO008l7amoo`008gooL3`O87oo000SOol01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7b1oo`008gooKc`O8Goo000SOol2?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00@h7c`O?1ll7b9oo`008gooKS`O8Woo000SOol01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO02=oo`008gooK3`O97oo000SOol2?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00<h7gooOol08goo000SOom[?1lUOol002=oo`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l00cPO?1moo`0UOol002=oofTl7bMoo`008goo0S`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Hh7c`O?1ll7cPO?1lXOol002=oofPl7bQoo`008goo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO008l
7bUoo`008gooIS`O:Woo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l013PO?1ll7c`O:Woo000SOomU?1l[Ool0
02=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`04>1ll7c`O?1l/Ool002=oof<l7beoo`008goo0S`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00<h7gooOol0:goo000SOomR?1l^Ool002=oo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`03>1moogoo02eoo`008gooHC`O
;goo000SOol2?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`06>1ll7c`O?1lh7c`O<7oo000SOomO?1laOol002=oo`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Hh7c`O?1ll7cPO?1lbOol002=ooehl
7c9oo`008goo0S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l00cPO?1ll7`0cOol002=ooe`l7cAoo`009Goo0S`O00Dh7c`O?1ll7cPO00<l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1ldOol002QooeHl7cEoo`00:goo0S`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7cIoo`00;WooCS`O=goo000bOol00c`O
>1ll7`02?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`0gOol003EoodHl7cQoo`00>7oo00<l7cPO?1l00S`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`0iOol003]oocll7cUoo`00?Woo00<l7cPO?1l00S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Hh7c`O?1ll7cPO?1ljOol0045oocLl7c]oo`00A7oo00<l7cPO?1l00S`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01SPO?1ll7c`O>1ll7caoo`00Agoo<3`O?7oo001;Ool01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`03>1ll7c`O03eoo`00CWoo9c`O?Woo001AOol01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00<h7c`O?1l0?goo001DOolP
?1loOol005Moo`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`04
>1ll7c`O?1m0Ool005YooaPl7d5oo`00GGoo00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l0@Goo001POolA?1m2Ool006Aoo`<l7`05>1ll7c`O?1lh7`03?1l00cPOOomoo`11
Ool006Moo`Pl7dAoo`00JWoo0c`O00<h7c`OOol0@goo002cOol00;=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00
/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.2 0 1 r
.85 .5 m
.60816 .83287 L
.21684 .70572 L
.21684 .29428 L
.60816 .16713 L
.85 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo001[Ool00a@O61lD7`16Ool006Qoo`<D7`0361lD7a@O04Ioo`00
IGoo00XD7aPO51lH7a@O61lD7aPO51lH7dEoo`00HWoo0a@O00DH7a@O51lD7aPO00<D7`0361lD7a@O
04Aoo`00Ggoo018D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61m3Ool005aoo`<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@OOol0@Woo001HOol06QPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51m2Ool005Eoo`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O@Goo001BOol0
8APO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7`11Ool004moo`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0@7oo001<Ool0:APO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61l0?goo0019Ool01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0nOol004Ioo`0`61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O?Woo0013Ool01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l011PO51lD7a@O?Goo0010Ool0>1PO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51llOol003eoo`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51lD7`0lOol003Yoo`0o61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO03]oo`00
=Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0251ljOol003=oo`1851lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO>Goo
000`Ool00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O>Goo000]Ool0Ca@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O03Qoo`00:Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00HH7a@O51lD7aPO51lgOol002Ioo`1G61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO03Moo`009Woo0a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0fOol002Ioo`1I61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0eOol002Ioo`0351lH7a@O
008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0=7oo
000VOol0FQPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7cAoo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351lcOol002Ioo`1L61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7c9oo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351laOol002Ioo`1M61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
035oo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l00aPO51lD7`0`Ool002Ioo`1O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0_Ool002Ioo`0351lH7a@O008D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O
Ool0;Woo000VOol0H1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7bioo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7beoo`009Woo068H7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O;7oo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0/Ool002Ioo`1S61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO02]oo`009Woo0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7gooOol0:7oo000VOol0I1PO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O:Woo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351lYOol002Ioo`1V61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O:7oo000VOol351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7a@O9goo000VOol0
IaPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO02Moo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00<H7a@O51l09Woo000VOol0JAPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0UOol002Ioo`<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O9Goo000VOol0JQPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O97oo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO51lD7a@O61lD7b=oo`00
9Woo06`H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lROol002Ioo`<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l00aPOOomoo`0POol002Ioo`1]61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61l08Goo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00<H7gooOol07Woo000VOol0KQPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lPOol002Ioo`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7a@O7goo000V
Ool0L1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O7Woo000VOol00a@O
61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51lD7aeoo`009Woo074H7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO01eoo`009Woo0a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251lLOol002Ioo`1a61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0MOol002Ioo`0351lH7a@O008D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l011PO51lD7a@O7Goo000VOol0L1PO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O7Woo000VOol351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00@H7a@O51lD7amoo`009Woo06hH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O87oo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7goo
Ool07Woo000VOol0KAPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO025oo`009Woo
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361moogoo021oo`009Woo06/H7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO02=oo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH
7a@O51lD7aPO51lSOol002Ioo`1Z61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lTOol002Io
o`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O9Goo000VOol0JAPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7`0UOol002Ioo`0351lH7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7a@O02Ioo`009Woo
06LH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0WOol002Ioo`<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7a@O
02Qoo`009Woo06HH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lXOol002Ioo`0351lH7a@O008D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7bUoo`009Woo06@H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7bYoo`009Woo0a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
:goo000VOol0HaPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0[Ool002Ioo`0351lH7a@O008D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO02ao
o`009Woo064H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7`0]Ool002Ioo`<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO51l]Ool002Ioo`1P61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O;Woo000VOol00a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7goo02ioo`009Woo05hH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7c1oo`009Woo0a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO
51lD7`0`Ool002Ioo`1M61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO035oo`009Woo00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0251lbOol002Ioo`1K61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0<goo000VOol3
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7c=o
o`009Woo05XH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51ldOol002Ioo`0351lH7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l011PO51lD7a@O=Goo000VOol0F1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O=Woo000VOol351l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO03Ioo`009Woo05LH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0=goo000XOol351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00<H7gooOol0=Woo000[Ool0DA@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`0hOol002moo`8D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0361lD7goo03Qoo`00<Woo04PH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51ljOol003Eoo`8D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0
0a@O00<H7a@OOol0>Woo000hOol0@APO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0>goo000kOol251l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O51l0?7oo000oOol0>1@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lmOol0049oo`0351lH
7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7cioo`00AGoo034D7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`0nOol004Qoo`0351lH7a@O008D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O?goo001<Ool0:1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O@7oo001?Ool01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO041oo`00DWoo024H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61l0@Goo001EOol01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l0@Woo001IOol061@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7d=oo`00G7oo0a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l00aPO51moo`12Ool005moo`0A51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7`14Ool0069oo`<D7`0561lD7a@O51lH7`0351l00aPO51moo`14Ool006Eoo`0951lH7a@O
61lD7aPO51lH7a@O04Ioo`00JGoo0Q@O00<H7a@O51l0AWoo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00001\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .1 1 r
.825 .5 m
.60043 .80909 L
.23707 .69103 L
.23707 .30897 L
.60043 .19091 L
.825 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol006Uoo`<0GdQoo`00IWoo1P1O
B7oo001SOol305l01@1o05l0G`1O07l00P1OAgoo001POol>05m6Ool005eoo`<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00P1OAGoo001IOolF05m5Ool005Ioo`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0Ggoo04=oo`00Dgoo7P1O@goo001@Ool01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00<0O`1OOol0@Goo001=OolU05m2Ool004Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0OgooOol0?goo
0017Ool]05m0Ool004Aoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307moogoo
03eoo`00@Goo=01O?goo000nOol01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O?Woo000kOoll05lmOol003Moo`0305l0O`1O0080G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l00`1o05l0G`0mOol003Aood@0Gcaoo`00
<Goo00<0G`1o05l00P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l00`1o05l0G`0kOol002iood`0GcYoo`00:Woo0P1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00H0O`1O05l0G`1o05ljOol002Yooe40GcUoo`00:Woo00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0Ggoo03Moo`00:WooD`1O=goo000ZOol2
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0OgooOol0=Goo000ZOomD
05lfOol002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l0=Goo000ZOomF05ldOol002Yoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l0101o05l0G`1O=7oo000ZOomG05lcOol002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O<Woo000ZOomH05lbOol002Yoo`80G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O<Goo000ZOomJ05l`
Ool002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00<0O`1O05l0;goo000ZOomK05l_Ool002Yoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0O`1OOol0;Goo000ZOomM05l]Ool002Yoo`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00H0O`1O
05l0G`1o05l/Ool002Yooeh0Gbaoo`00:Woo0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0:goo000ZOomP05lZOol002Yoo`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0GbYoo`00:WooH@1O:Goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305lXOol002Yoof<0GbMoo`00
:Woo00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00<0O`1O05l09goo000ZOomT05lVOol002Yoo`80G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`03
07l0G`1O02Eoo`00:WooIP1O97oo000ZOol01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01P1o05l0G`1O07l0GbAoo`00:Woo
I`1O8goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01P1o05l0G`1O07l0Gb9oo`00:WooJ@1O8Goo000ZOol0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0OgooOol07goo000ZOomZ05lPOol002Yoo`80G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0205lQOol002YoofT0Gb5oo`00:Woo00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0Gb9oo`00:WooI`1O8goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0101o05l0G`1O97oo
000ZOomV05lTOol002Yoo`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0UOol002Yoof@0GbIoo`00:Woo
0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00<0OgooOol09Goo000ZOomS05lWOol002Yoo`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0
Ggoo02Moo`00:WooH@1O:Goo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0607l0G`1O05l0O`1O:Woo000ZOomP05lZOol002Yoo`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o0080Gb]oo`00:WooGP1O;7oo000ZOol205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O02eoo`00:WooG@1O;Goo000ZOol01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0407l0G`1O05l^
Ool002Yooe/0Gbmoo`00:Woo0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l`Ool002YooeX0Gc1oo`00:Woo00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l00`1oOomoo`0_Ool002YooeP0Gc9oo`00:Woo
0P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0cOol0
02YooeL0Gc=oo`00:Woo00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0607l0
G`1O05l0O`1O=7oo000ZOomE05leOol002Yoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l00`1o05moo`0eOol002Yooe@0GcIoo`00:Woo00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O03Moo`00:WooDP1O>7oo000ZOol205l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O>Goo000ZOomA05liOol002aoo`80G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0407l0G`1O05ljOol002moodX0Gc]oo`00<Woo0P1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0101o
05l0G`1O?7oo000eOom305llOol003Qoo`80G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0?Goo000lOolj05lnOol003moo`0305l0O`1O
0080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307moogoo03eoo`00@Woo<`1O
?goo0015Ool00`1O07l0G`0205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0Ggoo03moo`00B7oo:`1O
@Goo001;Ool00`1O07l0G`0205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00<0O`1OOol0@Goo001>OolT05m2Ool0055oo`0305l0O`1O
0080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O
04=oo`00E7oo701OA7oo001GOol00`1O07l0G`0205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0307l0G`1O04Eoo`00FWoo5@1OAGoo001NOol01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0GdIoo`00HGoo301OAgoo001TOol01@1o05l0G`1O07l00`1OB7oo001WOol505m8Ool00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .4 1 r
.8 .5 m
.59271 .78532 L
.25729 .67634 L
.25729 .32366 L
.59271 .21468 L
.8 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo001XOol30Im9Ool006Eoo`060Gl1W`5o0Il1O`6OBGoo001ROol:0Im8Ool005ioo`0?0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O04Moo`00Fgoo4`6OAWoo001HOol05P6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5oAWoo001EOolJ0Im5Ool0059oo`0N0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5oA7oo001?
OolR0Im3Ool004]oo`0V0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1Wd=oo`00B7oo:P6O@Woo0015Ool0;P5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O@Goo0012Oola0Im1Ool003moo`0e0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`10Ool003aoocT1Wcmoo`00>Goo03d1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`0nOol0
03Eood41Wcioo`00<Woo04D1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0?Goo000^Oom:0IllOol002ioo`1;0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O03]oo`00;WooB`6O>goo000^Ool0C06O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o>Woo000^Oom=0IliOol002ioo`1=0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`0iOol002ioodh1WcQoo`00;Woo04l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`0gOol002iooe01WcIoo`00;Woo0501W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o=Woo000^OomA0IleOol002ioo`1B0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0GldOol002iooe81WcAoo`00;Woo05<1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O03=oo`00;WooE06O<Woo000^Ool0E@6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O035oo`00;WooE@6O<Goo000^
Ool0EP6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl`Ool0
02iooeL1Wbmoo`00;Woo05P1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1Obioo`00;WooF06O;Woo000^Ool0F@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0;Goo000^OomJ0Il/Ool002ioo`1J0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o;7oo000^
OomK0Il[Ool002ioo`1L0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1ObYoo`00;WooG@6O:Goo000^Ool0G@6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0YOol002iooeh1WbQo
o`00;Woo05l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O02Moo`00;WooH06O9Woo000^Ool0H06O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1ObIoo`00;Woo
H@6O9Goo000^Ool0H06O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1ObIoo`00;WooH06O9Woo000^Ool0G`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il09goo
000^OomN0IlXOol002ioo`1M0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O02Uoo`00;WooG@6O:Goo000^Ool0G06O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0GlZOol002iooe/1
Wb]oo`00;Woo05X1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl/Ool002iooeX1Wbaoo`00;Woo05T1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O02eoo`00;WooF06O;Woo000^Ool0F06O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o;Woo000^OomG0Il_
Ool002ioo`1F0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
Oc1oo`00;WooE@6O<Goo000^Ool0E@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O035oo`00;WooE06O<Woo000^Ool0D`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0<goo000^OomB0IldOol002ioo`1B0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0GldOol002iooe41WcEoo`00;Woo0501W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o=Woo000^Oom@0IlfOol002ioo`1?0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il0=goo000^Oom>0IlhOol002ioo`1=0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`0iOol002ioodd1WcUoo`00;Woo04`1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1OcYoo`00;WooB`6O>goo000^Ool0B`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`0kOol0031oodP1Wcaoo`00<goo04@1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O?Goo000fOom00IlnOol0
03Uoo`0m0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl0?Woo000lOoli0IloOol003moo`0e0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`10Ool0049ooc41Wd5oo`00AGoo02h1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1Wd5oo`00B7oo:P6O@Woo001;Ool09P5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Im3Ool004ioob<1Wd=o
o`00DGoo01l1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`14Ool005Aooa/1WdEoo`00Egoo01L1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o04Ioo`00FWoo506OAWoo001MOol0405o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6OAgoo001POol<0Im8Ool006=oo`080Gl1W`5o0Il1O`6O0Gl1WdUoo`00IWoo1@6O
BGoo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00
]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 .7 1 r
.775 .5 m
.58498 .76154 L
.27752 .66164 L
.27752 .33836 L
.58498 .23846 L
.775 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo001VOol00`:o0]l2_`1:Ool006=oo`060[l2g`:o0]l2_`;OBWoo
001POol00`:o0]l2_`020[l01@;O0[l2_`:o0]l0BGoo001MOol03P:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]m8Ool005Yoo`030[l2g`:o0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0Agoo
001GOol05@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`17Ool005Aoo`03
0[l2g`:o0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2_dIoo`00DGoo
01d2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
04Eoo`00CWoo00<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00@2g`:o0[l2_dAoo`00BWoo02D2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`14Ool004Moo`82_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00P:o@goo0014Ool0;@;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`12Ool0
045oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O0[m2Ool003ioo`0d0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[m1Ool003]oo`82_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o@7oo000hOol0?0;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_cmoo`00=Goo0P:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`0oOol0035oo`140[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gcioo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0?Goo
000aOol0A@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0mOol0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2_caoo`00
<Goo04L2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o03]oo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
>Woo000aOol0B0:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gcYoo`00<Goo0P:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00P:o>Goo000aOol0BP:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]lhOol0035oo`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`030]l2_`:o03Moo`00<Goo04/2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l0=goo000aOol20[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`0eOol0035o
o`1=0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0eOol0035oo`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`0eOol0035oo`1>0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O=7oo000aOol20[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0<goo
000aOol0D0:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]lbOol0035oo`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[lbOol0035oo`1A0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o035oo`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_c1oo`00<Goo0582_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2gc1oo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`030]l2_`:o02moo`00<Goo05@2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l^Ool0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
0`;O0[l2_`0]Ool0035oo`1E0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l0;Goo000aOol01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2
g`:o0[l2_`;O0[l/Ool0035oo`1G0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o02]oo`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`060]l2_`:o0[l2g`:o:Woo000aOol0F0:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O:Woo000aOol01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]moogoo02Moo`00<Goo05P2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gbYoo`00<Goo0P:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o:Woo000aOol0
E`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0[Ool0
035oo`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01P;O0[l2_`:o0]l2_bao
o`00<Goo05D2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0]
Ool0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[l2_`0]
Ool0035oo`1D0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O;Woo
000aOol01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`:o0[l0;goo000a
Ool0DP:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O<7oo000aOol20[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o<7oo000aOol0D@:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0aOol0035oo`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[lbOol0035oo`1@0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2gc9oo`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O03=o
o`00<Goo04h2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]ldOol0035oo`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`0eOol0035oo`1=0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`0eOol0035oo`82_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]l2_goo03Eo
o`00<Goo04/2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0=goo000aOol01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l00`;O0[l2_`0gOol0035oo`1:0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gcQo
o`00<Goo0P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00P:o>Goo000aOol0B0:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2gcYoo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o>Woo000aOol0A`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l0>goo000aOol20[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`:o0[llOol0035oo`150[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o03eoo`00<Goo00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0?Goo000aOol0A0:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]lnOol003=oo`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00<2ggooOol0?Goo000fOol0?P;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[loOol003Uoo`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`0oOol003ao
o`0f0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o@Goo000oOol0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`11Ool0049oo`0_0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`12Ool004Eoo`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2
g`:o0[l0@goo0018Ool09`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`14Ool004]oo`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`:oA7oo
001?Ool07`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o04Eoo`00DWoo0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:oAWoo001EOol05`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l0Agoo001HOol30[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]moogoo04Eo
o`00Fgoo0102_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2gdQoo`00GWoo0`:o00D2g`:o0[l2
_`;O00<2_`030]moogoo04Moo`00HGoo00P2_`;O0[l2g`:o0]l2_`;OBWoo001TOol30[l00`;O0[mo
o`19Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 1 r
.75 .5 m
.57725 .73776 L
.29775 .64695 L
.29775 .35305 L
.57725 .26224 L
.75 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00IGoo0`?oC7oo001R
Ool60om<Ool005moo`X3od]oo`00G7oo3P?oBWoo001HOolC0om9Ool005EooaH3odUoo`00DWoo6P?o
B7oo001?OolN0om7Ool004aoob43odMoo`00BGoo9@?oAWoo0016OolY0om5Ool004=oobd3odAoo`00
?goo<@?oA7oo000lOole0om3Ool003UoocT3od9oo`00=Goo?P?o@Goo000eOoln0om1Ool003Eoocl3
od1oo`00=Goo@0?o?goo000eOom00oloOol003Eood43ocioo`00=Goo@P?o?Goo000eOom30ollOol0
03Eood<3ocaoo`00=GooA0?o>goo000eOom50oljOol003EoodD3ocYoo`00=GooAP?o>Goo000eOom7
0olhOol003EoodP3ocMoo`00=GooB0?o=goo000eOom90olfOol003EoodX3ocEoo`00=GooB`?o=7oo
000eOom;0oldOol003Eood`3oc=oo`00=GooC@?o<Woo000eOom=0olbOol003Eoodh3oc5oo`00=Goo
C`?o<7oo000eOom@0ol_Ool003Eooe03obmoo`00=GooD@?o;Woo000eOom@0ol_Ool003Eooe03obmo
o`00=GooC`?o<7oo000eOom>0olaOol003Eoodd3oc9oo`00=GooC@?o<Woo000eOom<0olcOol003Eo
od/3ocAoo`00=GooBP?o=Goo000eOom:0oleOol003EoodT3ocIoo`00=GooB0?o=goo000eOom70olh
Ool003EoodL3ocQoo`00=GooAP?o>Goo000eOom50oljOol003Eood@3oc]oo`00=GooA0?o>goo000e
Oom30ollOol003Eood83oceoo`00=Goo@P?o?Goo000eOom10olnOol003Eood03ocmoo`00=Goo?`?o
@7oo000eOolo0om0Ool003Eooch3od5oo`00=goo>`?o@Woo000jOolg0om3Ool003eooc@3od=oo`00
@7oo<0?oA7oo0014Ool[0om5Ool004MoobL3odIoo`00BWoo90?oAWoo001=OolP0om7Ool0051ooa`3
odQoo`00Dgoo60?oBGoo001FOolE0om9Ool005Uooa43odYoo`00GGoo30?oBgoo001POol80om<Ool0
06=oo`D3odaoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo
002dOol00;Aoo`00\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .7 r
.725 .5 m
.56953 .71399 L
.31797 .63225 L
.31797 .36775 L
.56953 .28601 L
.725 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo001TOol30oE=Ool0065oo`060oD3mP?e0oH3m@?fCGoo001NOol30oD01@?f0oD3m@?e0oH0
0P?eC7oo001KOol03P?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oI;Ool005Qoo`<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00P?eBWoo001EOol05@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@1:Ool0059oo`<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00H3mP?e0oD3m@?f0oE9Ool004moo`0M0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@18Ool004aoo`<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP18Ool004Uoo`0T0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?fAgoo
0016Ool30oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f04Ioo`00@goo02`3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?fAGoo0010Ool30oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3m@?e0oE5Ool003eoo`0c0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e04Aoo`00>Goo00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3mD=oo`00>Goo03P3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f@goo000iOol20oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00P?e@Woo000iOol0>P?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f@Goo000iOol01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?e0oD0@7oo
000iOol0>`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD0@7oo000iOol20oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00<3mP?eOol0?Woo000iOol0?@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e03ioo`00>Goo00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@060oH3m@?e0oD3mP?e?Goo000iOol0?P?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oHm
Ool003Uoo`83m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH0?7oo000iOol0@0?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f>goo000iOol01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3mC]oo`00>Goo0443
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e03Yoo`00>Goo0P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oDiOol003Uoo`130oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0>7oo000i
Ool01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@030oH3m@?e03Qoo`00>Goo04@3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f=goo000iOol20oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@030oH3m@?e03Ioo`00>Goo04D3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0=Woo000iOol01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@06
0oH3m@?e0oD3mP?e=Goo000iOol0A`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0=7oo000iOol20oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@060oH3m@?e0oD3mP?e<goo000iOol0B0?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mS=oo`00>Goo
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mWooOol0<7oo000iOol0B0?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mS=oo`00>Goo0P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3mC=oo`00>Goo04L3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e03Aoo`00>Goo00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3mCEoo`00>Goo04D3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD0=Woo000iOol20oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3m@?e03Ioo`00>Goo04@3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f=goo000iOol01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3m@?e03Qoo`00>Goo0483m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oHiOol003Uo
o`83m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e>Goo000iOol0@@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0>Woo000iOol01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3mC]oo`00>Goo03l3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD0?7oo000iOol20oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f03aoo`00>Goo03h3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f?Goo000iOol01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f03ioo`00>Goo03`3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oHo
Ool003Uoo`83m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD00`?f0oEoo`0nOol003Uoo`0k0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@10Ool003Uoo`050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD00`?f0oEoo`10Ool003Uoo`0j0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oI1Ool003Uoo`83m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP020oE2Ool003Uoo`0h0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mT=oo`00>goo0P?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?e0oD0A7oo000nOol0<P?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oE4Ool0045oo`83m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00@3
mP?e0oD3mDEoo`00A7oo02X3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oE6Ool004Moo`83m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD010?f
0oD3m@?eAgoo001:Ool08`?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH0Agoo001=Ool20oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0B7oo001@Ool06`?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP19Ool005=oo`83m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f04Yoo`00EWoo01@3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?eBWoo001IOol20oD01@?f0oD3m@?e0oH00`?e00H3
mP?e0oD3m@?f0oE;Ool005aoo`0<0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?eC7oo001OOol20oD01P?f
0oD3m@?e0oH3mDeoo`00HWoo00D3mP?e0oH3m@?f04eoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .4 r
.7 .5 m
.5618 .69021 L
.3382 .61756 L
.3382 .38244 L
.5618 .30979 L
.7 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00HWoo00<3k0?[0n`0Cgoo001OOol60na?Ool0
05aoo`0:0n`3j`?/0n/3k0?[0n`3j`?/0n]>Ool005Uoo`h3k4eoo`00EWoo0183k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n]<Ool005=ooaD3k4aoo`00Cgoo01X3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/Bgoo001<OolN0na:Ool004Uoo`0R0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0na9Ool004IoobD3k4Uoo`00@goo02T3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[04Qoo`00@7oo;@?/
Agoo000lOol0<P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n]6Ool003aooc83
k4Ioo`00?7oo03<3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0AGoo000l
Oold0na4Ool003aoo`0e0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k013Ool003aoocD3k4=oo`00?7oo03H3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n]2Ool003aoocL3k45oo`00?7oo03L3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k011Ool003aoocP3k41oo`00?7oo03T3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`0?goo000lOolj0n`nOol003aoo`0j
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/nOol0
03aooc/3k3eoo`00?7oo03`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/lOol003aoocd3k3]oo`00?7oo03d3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00kOol003aooch3k3Yoo`00?7oo
03l3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`0>Goo000lOom00n`hOol003aoo`100n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/hOol003aood43k3Moo`00?7oo0403
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3jcQoo`00?7oo@0?/>7oo000lOol0?`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00iOol003aooch3k3Yoo`00?7oo03d3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00k
Ool003aoocd3k3]oo`00?7oo03`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/lOol003aooc/3k3eoo`00?7oo03X3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3jcioo`00?7oo>P?/?Woo000lOol0>@?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k00oOol003ao
ocP3k41oo`00?7oo03L3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k011Ool003aoocL3k45oo`00?7oo03H3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n]2Ool003aoocD3k4=oo`00?7oo03D3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/04=oo`00?7oo=0?/A7oo000lOol0<`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k015Ool003aooc83k4Ioo`00?7oo0383k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[AWoo000nOol_0na7Ool0045oo`0[0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/0B7oo0014OolW0na9Ool004Moo`0T0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/BGoo001:OolP0na:
Ool004eoo`0L0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0na;Ool0055ooaL3k4aoo`00E7oo01@3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[C7oo001GOol@0na=Ool005Yoo`0<0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[CWoo001MOol8
0na?Ool0061oo`050n`3j`?/0n/3k01?Ool00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .1 r
.675 .5 m
.55408 .66643 L
.35842 .60286 L
.35842 .39714 L
.55408 .33357 L
.675 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00HGoo00<3hP?S0n80
Cgoo001NOol60n9?Ool005]oo`030n83h`?R0083hP050n<3hP?R0n83h`1>Ool005Qoo`h3hTeoo`00
EGoo00<3hP?S0n800P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`1<Ool0059ooaD3hTaoo`00
D7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?RBgoo001=OolL
0n9:Ool004Yoo`050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`020n9:Ool004Moob<3hTUoo`00A7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`020n98Ool0041o
ob/3hTQoo`00@7oo0P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n9oo`16Ool0041oobd3hTIoo`00
@7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801P?S0n83hP?R0n<3hTEoo`00@7oo;P?RAGoo0010Ool20n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`14Ool0041ooc03hT=oo`00@7oo00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R@goo0010Oola0n92Ool0041oo`83hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hT5oo`00@7oo<P?R@Goo0010Ool01@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n800`?S0n83hP10Ool0041ooc@3hSmoo`00@7oo0P?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?R0n80?Woo0010Oole0n8nOol0041oo`050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP060n<3hP?R0n83h`?R?Goo0010Oolg0n8lOol0
041oo`83hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`0lOol0
041oocP3hS]oo`00@7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S0083hSaoo`00@7oo=`?R?7oo0010Ool20n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n8010?S0n83hP?R?Goo0010Oole0n8nOol0041oo`050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`0nOol0041ooc@3hSmoo`00@7oo0P?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00<3hgooOol0?Woo0010Oolb0n91Ool0041oo`050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP030n<3hWoo041oo`00@7oo<@?R@Woo0010Ool20n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP060n<3hP?R0n83h`?R@goo0010Ool`0n93Ool0041oo`050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S0083hTAoo`00@7oo;P?RAGoo0010Ool20n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP040n<3hP?R0n95Ool0041oobd3hTIoo`00@7oo00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n8010?S
0n83hP?RAgoo0010Ool[0n98Ool0041oo`83hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3hgooOol0AWoo
0012OolX0n99Ool004Eoo`<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n800`?SOomoo`18Ool004Qoob43hTYoo`00C7oo0P?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?ROol0BWoo001?OolH
0n9<Ool0059oo`83hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?R0n80C7oo001E
OolA0n9=Ool005Qoo`83hP050n<3hP?R0n83h`030n800`?S0n83hP1>Ool005aoo`P3hTmoo`00Ggoo
00<3hP?S0n800P?RCgoo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo
002cOol00;=oo`00/goo0000\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.2 1 0 r
.65 .5 m
.54635 .64266 L
.37865 .58817 L
.37865 .41183 L
.54635 .35734 L
.65 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol005moo`8Gh0036n1oogoo04moo`00Fgoo00PGh1_P5n0Kh1OP6n0Gh1_PD7oo001H
Ool35n001A_P5n0Gh1OP6n000aOPD7oo001EOol03aOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h01?Ool0055oo`056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh4ioo`00CWoo
01PKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n1=Ool004]oo`05
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP04eoo`00
Agoo020Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_PC7oo0013Ool25n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh1OP5n00Bgoo0013Ool09QOP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n1:
Ool004=oo`056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001Q_P5n0Gh1OP6n0Gh4Yoo`00@goo02LGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n00BGoo0013
Ool25n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00HKh1OP5n0Gh1_P5n18Ool004=oo`0Y5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh017Ool0
04=oo`056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh7ooOol0AGoo0013Ool0:QOP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh4Ioo`00@goo0QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000a_POomoo`13Ool004=oo`0/5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Aoo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n0011_P5n0G
h1OPA7oo0013Ool0;AOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh013Ool004=oo`8Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh49oo`00@goo02lGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP045oo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000QOP@Goo0013
Ool0<1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh41oo`00@goo0QOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000QOP?goo0013Ool0<1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh41oo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP@7oo
0013Ool0;aOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n00@Goo0013Ool25n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DK
h1OP5n0Gh1_P00<Gh0046n0Gh1OP5n12Ool004=oo`0]5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP04=oo`00@goo00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00@goo0013Ool0;1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n14Ool004=oo`8Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh7oo
Ool0@goo0013Ool0:QOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Ioo`00@goo00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n000a_P5n1oo`15Ool004=oo`0Y5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh017Ool004=oo`8Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001Q_P5n0Gh1OP6n0Gh4Qoo`00@goo02PGh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Qoo`00@goo00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0025n19Ool004=oo`0V5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4Yoo`00@goo0QOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0G
h1OP04]oo`00AGoo02<Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP04]oo`00B7oo0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP5n0Gh4aoo`00Bgoo01/Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n00CGoo001>Ool35n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh1OP5n1>Ool0055oo`0D5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh4ioo`00E7oo0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h01?Ool005Moo`0<5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_PD7oo001JOol35n001A_P5n0Gh1OP6n00
DGoo001MOol01AOP6n0Gh1_P5n00DGoo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol0
0;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00001\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 1 0 r
.625 .5 m
.53863 .61888 L
.39887 .57347 L
.39887 .42653 L
.53863 .38112 L
.625 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00GWoo0coPDgoo001KOol6?n1COol005Uoo`8o
h005>n0oh3oP?n0kh002?n1BOol005Ioo`doh55oo`00Dgoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0o
h3oP?n0kh002?n1@Ool0051ooa@oh51oo`00CGoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h003?n001S_P?n0oh3oP>n0oh4moo`00Bgoo6coPCWoo0017Ool2?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001S_P?n0oh3oP>n0oh4eoo`00Agoo83oPCGoo0017
Ool01C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP
>n000coP00<kh7ooOol0BWoo0017OolR?n1;Ool004Moo`8oh005>n0oh3oP?n0kh003?n001C_P?n0o
h3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n1;Ool004Moob<oh4Yoo`00Agoo
00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P
00<oh004>n0oh3oP?n19Ool004MoobDoh4Qoo`00Agoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP
?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh003>n0oh3oP04Qoo`00Agoo9SoP
Agoo0017Ool01C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P008oh4Ioo`00Agoo:3oPAGoo0017Ool2?n001C_P?n0oh3oP
>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Hkh3oP
?n0oh3_P?n15Ool004MoobToh4Aoo`00Agoo00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n00
1C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n15Ool004MoobLoh4Io
o`00Agoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh016Ool004MoobHoh4Moo`00Agoo00Dkh3oP?n0oh3_P00<o
h005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h018Ool004Moob@oh4Uoo`00Agoo0SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh003>n0oh7oo04Qoo`00Agoo8coPBWoo0017Ool01C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP
00<kh3oPOol0BWoo0017OolQ?n1<Ool004Moo`8oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n00
0coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh002?n1<Ool004Moob0oh4eoo`00Agoo00Dkh3oP
?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P008oh4io
o`00BGoo73oPCgoo001<Ool00coP>n0oh002?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<o
h004>n0oh3oP?n1?Ool004mooaDoh51oo`00DWoo00<oh3_P?n000SoP00Dkh3oP?n0oh3_P00<oh004
>n0oh3oP?n1AOol005Ioo``oh59oo`00FGoo00Dkh3oP?n0oh3_P00<oh003>n1oogoo051oo`00G7oo
1CoPDgoo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo0000\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 1 0 r
.6 .5 m
.5309 .59511 L
.4191 .55878 L
.4191 .44122 L
.5309 .40489 L
.6 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{143.75, 143.75},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000/a000`40O003h00O/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=o
o`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo001LOol00f?P
In1Sh01DOol005Uoo`07Hn1Wh6?PIn1Sh6OPHn00Dgoo001FOol02V?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Dgoo001COol03V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1BOol0055oo`0AIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh01AOol004ioo`0EIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OP051oo`00BWoo01USh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh01@Ool004Yoo`0JIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh4moo`00BWoo01]Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00CWoo001:Ool076OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PCGoo001:Ool076?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPCGoo001:Ool07FOPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00C7oo001:Ool07V?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh4]oo`00
BWoo01mWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh01:Ool004Yoo`0OHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn00BWoo001:Ool086OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn19Ool004Yoo`0QHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P04Qoo`00BWoo
021Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PBGoo001:Ool07f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?P04Yoo`00BWoo01mWh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh01:Ool004Yoo`0NHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPBgoo001:Ool07FOPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00C7oo001:Ool0
76?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPCGoo
001:Ool076OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PCGoo001:Ool06f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh01>Ool004Yoo`0JIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh4moo`00BWoo01USh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh01@Ool004Yoo`0IIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn00D7oo001<Ool05V?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPDGoo001@Ool04FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00DWoo001COol0
3FOPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP05=oo`00EWoo00YWh6?PIn1Sh6OPHn1Wh6?PIn1Sh5=o
o`00FWoo00ESh6OPHn1Wh6?P05Aoo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002cOol00;=oo`00/goo002c
Ool00;=oo`00/goo002cOol00;=oo`00/goo0000\
\>"],
  ImageRangeCache->{{{0, 178.688}, {178.688, 0}} -> {-1.00001, -1.00001, \
0.013991, 0.013991}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 .9 0 r
.575 .5 m
.52318 .57133 L
.43932 .54408 L
.43932 .45592 L
.52318 .42867 L
.575 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00Fgoo0gn0EWoo001HOol01gn0Of1oP7mPOh1oH7n005Eoo`00EGoo2Wn0
EGoo001BOol03Wn0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1DOol004iooa=oP5=oo`00CWoo01Ao
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPDWoo001>OolDOh1BOol004ioo`0E
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0055oo`00CWoo5Wn0D7oo001>
Ool05gn0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh00Cgoo001>OolG
Oh1?Ool004ioo`0HOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
CWoo001>OolIOh1=Ool004ioo`0HOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPCWoo001>OolGOh1?Ool004ioo`0GOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP01?Ool004iooaIoP51oo`00CWoo01EoP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh00DGoo001>OolDOh1BOol004ioo`0DOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH59oo`00CWoo4gn0Dgoo001@Ool047n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPE7oo001COol<Oh1EOol005Ioo`09Oh1oH7n0Of1oP7mPOh1oH7n005Eoo`00
FGoo1Gn0EWoo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol0
0;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 .6 0 r
.55 .5 m
.51545 .54755 L
.45955 .52939 L
.45955 .47061 L
.51545 .45245 L
.55 .5 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144.438, 144.438},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.03333,
  AnimationCycleOffset->1,
  AnimationCycleRepetitions->Infinity,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002d0000]1000`40O003h00O]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo001JOol3OT1GOol005Ioo`9n@005OV1n
@7i0OT1nH01GOol0059oo`an@5Ioo`00DWoo00EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH01EOol0
059oo`en@5Eoo`00DWoo0Wi000EnH7i0OT1n@7iP00=n@004OV1n@7i0OT1DOol0059oo`mn@5=oo`00
DWoo00EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH002OT1COol0059ooa1n@59oo`00DWoo0Wi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH01COol0059oo`mn@5=oo`00DWoo00EnH7i0OT1n@7iP00=n
@006OV1n@7i0OT1nH7i0E7oo001BOol=OT1EOol0059oo`9n@005OV1n@7i0OT1nH003OT000giPOT1o
o`1EOol005Aoo`Yn@5Ioo`00F7oo0Wi000=nH7i0OT00Egoo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Aoo`00]7oo002dOol00;Ao
o`00]7oo002dOol00;Aoo`00]7oo002dOol00001\
\>"],
  ImageRangeCache->{{{0, 179.5}, {179.5, 0}} -> {-1.00001, -1.00001, \
0.0139277, 0.0139277}}]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "The animation of the scaling transformation shows us the action of the \
group. Every time we reduce the scaling factor, the pentagon is reduced but \
keeps its shape, meaning that we create self-similar objects of the same \
type. This kind of symmetry transformation satisfies all the properties \
stated in properties ",
  ButtonBox["(i)",
    ButtonData:>"group properties",
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[Dash]",
    ButtonData:>"group properties",
    ButtonStyle->"Hyperlink"],
  ButtonBox["(iv)",
    ButtonData:>"group properties",
    ButtonStyle->"Hyperlink"],
  " of a group. The reader may verify this easily.\[ThickSpace]\[ThickSpace]\
\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False,
  CellTags->"self-similar objects"],

Cell["\<\
So far we discussed the essentials of group theory including Lie \
groups. The discussed topics are all relevant for the examination of \
differential equations. In the following section, we will discuss a related \
term, the so-called Lie algebra, representing the algebraic properties of a \
Lie group.\
\>", "Text",
  Evaluatable->False],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Algebra.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{695, 668},
WindowMargins->{{17, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->6,
PrintingPageRange->{9, 9},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Elements of Symmetry Analysis", FontSlant -> "Italic"]}],
         "Header"], Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Groups and Lie Groups"}, #]&)], FontSlant -> "Italic"], 
          "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Text"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1.25,
CounterBoxOptions->{CounterFunction:>Identity,
CounterData:>2},
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "1.1"->{
    Cell[1739, 51, 43, 1, 117, "ChapterLine",
      CellTags->"1.1"],
    Cell[1785, 54, 65, 1, 193, "Title",
      CellTags->"1.1"]},
  "general properties of a group"->{
    Cell[1853, 57, 1042, 21, 201, "Text",
      Evaluatable->False,
      CellTags->{"general properties of a group", "computer algebra"}]},
  "computer algebra"->{
    Cell[1853, 57, 1042, 21, 201, "Text",
      Evaluatable->False,
      CellTags->{"general properties of a group", "computer algebra"}]},
  "Groups and Lie Groups"->{
    Cell[2920, 82, 156, 7, 52, "Section",
      Evaluatable->False,
      CellTags->"Groups and Lie Groups"]},
  "group theory"->{
    Cell[3079, 91, 428, 8, 96, "Text",
      Evaluatable->False,
      CellTags->"group theory"]},
  "Groups"->{
    Cell[3532, 103, 133, 7, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Groups"]},
  "Definition: Group"->{
    Cell[3908, 119, 72, 1, 38, "Definition",
      CellTags->"Definition: Group"]},
  "composition"->{
    Cell[3983, 122, 923, 25, 96, "Text",
      Evaluatable->False,
      CellTags->{"composition", "group multiplication", "group"}]},
  "group multiplication"->{
    Cell[3983, 122, 923, 25, 96, "Text",
      Evaluatable->False,
      CellTags->{"composition", "group multiplication", "group"}],
    Cell[103372, 2395, 699, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{"group multiplication", "MatrixForm[]"}]},
  "group"->{
    Cell[3983, 122, 923, 25, 96, "Text",
      Evaluatable->False,
      CellTags->{"composition", "group multiplication", "group"}]},
  "closure relation"->{
    Cell[4909, 149, 198, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->{"closure relation", "group properties"}]},
  "group properties"->{
    Cell[4909, 149, 198, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->{"closure relation", "group properties"}]},
  "associativity"->{
    Cell[6032, 188, 170, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->"associativity"],
    Cell[104360, 2430, 215, 6, 54, "Text",
      Evaluatable->False,
      CellTags->"associativity"],
    Cell[110957, 2680, 526, 19, 54, "Text",
      Evaluatable->False,
      CellTags->"associativity"]},
  "identity element"->{
    Cell[6919, 223, 177, 5, 26, "ListItem",
      Evaluatable->False,
      CellTags->"identity element"],
    Cell[106490, 2524, 723, 17, 75, "Text",
      Evaluatable->False,
      CellTags->{"identity element", "isomorphic"}]},
  "inverse element"->{
    Cell[7850, 261, 362, 11, 54, "Text",
      Evaluatable->False,
      CellTags->"inverse element"],
    Cell[105184, 2468, 463, 13, 75, "Text",
      Evaluatable->False,
      CellTags->{"Inverse[]", "inverse element"}],
    Cell[110440, 2659, 359, 9, 75, "Text",
      Evaluatable->False,
      CellTags->"inverse element"]},
  "Abelian group"->{
    Cell[8484, 283, 1585, 36, 222, "Text",
      Evaluatable->False,
      CellTags->{"Abelian group", "multiplication table"}],
    Cell[13249, 431, 434, 12, 75, "Text",
      Evaluatable->False,
      CellTags->"Abelian group"],
    Cell[14521, 475, 1158, 22, 222, "Text",
      Evaluatable->False,
      CellTags->{"rotations", "Abelian group"}]},
  "multiplication table"->{
    Cell[8484, 283, 1585, 36, 222, "Text",
      Evaluatable->False,
      CellTags->{"Abelian group", "multiplication table"}],
    Cell[10834, 342, 644, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{"multiplication", "multiplication table"}],
    Cell[12182, 389, 190, 4, 33, "Text",
      Evaluatable->False,
      CellTags->"multiplication table"]},
  "finite group"->{
    Cell[10072, 321, 558, 11, 117, "Text",
      Evaluatable->False,
      CellTags->{"finite group", "infinite group"}]},
  "infinite group"->{
    Cell[10072, 321, 558, 11, 117, "Text",
      Evaluatable->False,
      CellTags->{"finite group", "infinite group"}]},
  "multiplication"->{
    Cell[10834, 342, 644, 14, 117, "Text",
      Evaluatable->False,
      CellTags->{"multiplication", "multiplication table"}]},
  "group element"->{
    Cell[14211, 465, 307, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"group element"]},
  "rotations"->{
    Cell[14521, 475, 1158, 22, 222, "Text",
      Evaluatable->False,
      CellTags->{"rotations", "Abelian group"}]},
  "non-commutative"->{
    Cell[15713, 501, 774, 16, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
    Cell[30951, 938, 1109, 30, 159, "Text",
      Evaluatable->False,
      CellTags->"non-commutative"],
    Cell[93294, 2127, 512, 8, 96, "Text",
      Evaluatable->False,
      CellTags->"non-commutative"]},
  "Rotation[]"->{
    Cell[15713, 501, 774, 16, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
    Cell[20027, 621, 293, 9, 54, "Text",
      Evaluatable->False,
      CellTags->"Rotation[]"],
    Cell[20677, 643, 341, 9, 75, "Text",
      Evaluatable->False,
      CellTags->"Rotation[]"]},
  "Geometry`Rotation`"->{
    Cell[15713, 501, 774, 16, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}]},
  "polygon"->{
    Cell[15713, 501, 774, 16, 138, "Text",
      Evaluatable->False,
      CellTags->{
      "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
    Cell[136213, 3462, 447, 9, 96, "Text",
      Evaluatable->False,
      CellTags->{"polygon", "pentagon"}]},
  "display"->{
    Cell[16658, 525, 162, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"display"]},
  "hexagon"->{
    Cell[24529, 746, 1021, 26, 159, "Text",
      Evaluatable->False,
      CellTags->"hexagon"]},
  "RotationX[]"->{
    Cell[57212, 1410, 515, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}]},
  "RotationY[]"->{
    Cell[57212, 1410, 515, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}]},
  "RotationZ[]"->{
    Cell[57212, 1410, 515, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}]},
  "isomorphism"->{
    Cell[93809, 2137, 164, 4, 54, "Text",
      CellTags->"isomorphism"],
    Cell[113089, 2750, 521, 8, 96, "Text",
      Evaluatable->False,
      CellTags->{"isomorphism", "homomorphism"}]},
  "Isomorphism"->{
    Cell[94010, 2146, 88, 2, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Isomorphism"]},
  "Definition: Isomorphic groups"->{
    Cell[94476, 2159, 96, 1, 38, "Definition",
      CellTags->"Definition: Isomorphic groups"]},
  "homomorphism"->{
    Cell[95288, 2182, 556, 10, 117, "Text",
      Evaluatable->False,
      CellTags->{"homomorphism", "isomorphic group"}],
    Cell[107216, 2543, 833, 22, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}],
    Cell[113089, 2750, 521, 8, 96, "Text",
      Evaluatable->False,
      CellTags->{"isomorphism", "homomorphism"}]},
  "isomorphic group"->{
    Cell[95288, 2182, 556, 10, 117, "Text",
      Evaluatable->False,
      CellTags->{"homomorphism", "isomorphic group"}]},
  "Lie Groups"->{
    Cell[95881, 2197, 113, 5, 49, "Subsection",
      CellTags->"Lie Groups"]},
  "manifold"->{
    Cell[95997, 2204, 1375, 23, 285, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}],
    Cell[97458, 2232, 533, 12, 96, "Text",
      CellTags->"manifold"]},
  "calculus"->{
    Cell[95997, 2204, 1375, 23, 285, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "partial differentiation"->{
    Cell[95997, 2204, 1375, 23, 285, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "algebra"->{
    Cell[95997, 2204, 1375, 23, 285, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "topology"->{
    Cell[95997, 2204, 1375, 23, 285, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "Lie group"->{
    Cell[95997, 2204, 1375, 23, 285, "Text",
      CellTags->{
      "manifold", "calculus", "partial differentiation", "algebra", 
        "topology", "Lie group"}]},
  "Definition: Lie group"->{
    Cell[97375, 2229, 80, 1, 38, "Definition",
      CellTags->"Definition: Lie group"]},
  "addition"->{
    Cell[98695, 2263, 1483, 30, 201, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "inverse"->{
    Cell[98695, 2263, 1483, 30, 201, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "N[]"->{
    Cell[98695, 2263, 1483, 30, 201, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "rational numbers"->{
    Cell[98695, 2263, 1483, 30, 201, "Text",
      Evaluatable->False,
      CellTags->{"addition", "inverse", "N[]", "rational numbers"}]},
  "special orthogonal group"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "SO(3)"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "GL(n"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "\\[DoubleStruckCapitalR])"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "SL(n"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "continuous matrix group"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "unimodular group"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "linear group"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "vector space"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}],
    Cell[107216, 2543, 833, 22, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "\[DoubleStruckCapitalR])"->{
    Cell[100212, 2297, 1319, 34, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "special orthogonal group", "SO(3)", "GL(n", 
        "\\[DoubleStruckCapitalR])", "SL(n", "continuous matrix group", 
        "unimodular group", "linear group", "vector space", 
        "\[DoubleStruckCapitalR])"}]},
  "matrix group"->{
    Cell[101534, 2333, 171, 5, 54, "Text",
      Evaluatable->False,
      CellTags->"matrix group"]},
  "representation"->{
    Cell[102398, 2366, 887, 23, 138, "Text",
      Evaluatable->False,
      CellTags->{"representation", "group axioms"}],
    Cell[107216, 2543, 833, 22, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "group axioms"->{
    Cell[102398, 2366, 887, 23, 138, "Text",
      Evaluatable->False,
      CellTags->{"representation", "group axioms"}]},
  "MatrixForm[]"->{
    Cell[103372, 2395, 699, 18, 117, "Text",
      Evaluatable->False,
      CellTags->{"group multiplication", "MatrixForm[]"}]},
  "Inverse[]"->{
    Cell[105184, 2468, 463, 13, 75, "Text",
      Evaluatable->False,
      CellTags->{"Inverse[]", "inverse element"}]},
  "isomorphic"->{
    Cell[106490, 2524, 723, 17, 75, "Text",
      Evaluatable->False,
      CellTags->{"identity element", "isomorphic"}],
    Cell[111822, 2721, 1264, 27, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "group representation", "isomorphic", 
        "representation of a Lie group"}]},
  "invertible linear transformation"->{
    Cell[107216, 2543, 833, 22, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "infinite dimensional vector space"->{
    Cell[107216, 2543, 833, 22, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "vector space", "homomorphism", "invertible linear transformation", 
        "representation", "infinite dimensional vector space"}]},
  "translation"->{
    Cell[108147, 2570, 584, 16, 75, "Text",
      Evaluatable->False,
      CellTags->"translation"],
    Cell[113613, 2760, 375, 8, 96, "Text",
      Evaluatable->False,
      CellTags->"translation"]},
  "shift operator"->{
    Cell[108866, 2593, 487, 19, 54, "Text",
      Evaluatable->False,
      CellTags->"shift operator"]},
  "group representation"->{
    Cell[111822, 2721, 1264, 27, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "group representation", "isomorphic", 
        "representation of a Lie group"}]},
  "representation of a Lie group"->{
    Cell[111822, 2721, 1264, 27, 180, "Text",
      Evaluatable->False,
      CellTags->{
      "group representation", "isomorphic", 
        "representation of a Lie group"}]},
  "Plot[]"->{
    Cell[134832, 3420, 596, 18, 75, "Text",
      CellTags->"Plot[]"]},
  "coordinates"->{
    Cell[135462, 3442, 564, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{"coordinates", "scaling group"}]},
  "scaling group"->{
    Cell[135462, 3442, 564, 12, 117, "Text",
      Evaluatable->False,
      CellTags->{"coordinates", "scaling group"}]},
  "pentagon"->{
    Cell[136213, 3462, 447, 9, 96, "Text",
      Evaluatable->False,
      CellTags->{"polygon", "pentagon"}]},
  "Do[]"->{
    Cell[136809, 3478, 637, 13, 117, "Text",
      Evaluatable->False,
      CellTags->{"Do[]", "scaling factor"}]},
  "scaling factor"->{
    Cell[136809, 3478, 637, 13, 117, "Text",
      Evaluatable->False,
      CellTags->{"Do[]", "scaling factor"}]},
  "self-similar objects"->{
    Cell[415445, 7775, 782, 19, 96, "Text",
      Evaluatable->False,
      CellTags->"self-similar objects"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"1.1", 418732, 7867},
  {"general properties of a group", 418904, 7872},
  {"computer algebra", 419069, 7876},
  {"Groups and Lie Groups", 419239, 7880},
  {"group theory", 419370, 7884},
  {"Groups", 419483, 7888},
  {"Definition: Group", 419608, 7892},
  {"composition", 419711, 7895},
  {"group multiplication", 419874, 7899},
  {"group", 420152, 7906},
  {"closure relation", 420311, 7910},
  {"group properties", 420465, 7914},
  {"associativity", 420616, 7918},
  {"identity element", 420952, 7928},
  {"inverse element", 421206, 7935},
  {"Abelian group", 421557, 7945},
  {"multiplication table", 421936, 7955},
  {"finite group", 422324, 7965},
  {"infinite group", 422469, 7969},
  {"multiplication", 422614, 7973},
  {"group element", 422766, 7977},
  {"rotations", 422885, 7981},
  {"non-commutative", 423028, 7985},
  {"Rotation[]", 423418, 7996},
  {"Geometry`Rotation`", 423802, 8007},
  {"polygon", 423979, 8012},
  {"display", 424267, 8020},
  {"hexagon", 424378, 8024},
  {"RotationX[]", 424496, 8028},
  {"RotationY[]", 424649, 8032},
  {"RotationZ[]", 424802, 8036},
  {"isomorphism", 424955, 8040},
  {"Isomorphism", 425168, 8046},
  {"Definition: Isomorphic groups", 425311, 8050},
  {"homomorphism", 425429, 8053},
  {"isomorphic group", 425926, 8065},
  {"Lie Groups", 426070, 8069},
  {"manifold", 426166, 8072},
  {"calculus", 426422, 8079},
  {"partial differentiation", 426621, 8084},
  {"algebra", 426804, 8089},
  {"topology", 426988, 8094},
  {"Lie group", 427173, 8099},
  {"Definition: Lie group", 427370, 8104},
  {"addition", 427476, 8107},
  {"inverse", 427632, 8111},
  {"N[]", 427784, 8115},
  {"rational numbers", 427949, 8119},
  {"special orthogonal group", 428122, 8123},
  {"SO(3)", 428450, 8131},
  {"GL(n", 428777, 8139},
  {"\\[DoubleStruckCapitalR])", 429125, 8147},
  {"SL(n", 429452, 8155},
  {"continuous matrix group", 429798, 8163},
  {"unimodular group", 430137, 8171},
  {"linear group", 430472, 8179},
  {"vector space", 430807, 8187},
  {"\[DoubleStruckCapitalR])", 431382, 8200},
  {"matrix group", 431717, 8208},
  {"representation", 431842, 8212},
  {"group axioms", 432215, 8221},
  {"MatrixForm[]", 432360, 8225},
  {"Inverse[]", 432508, 8229},
  {"isomorphic", 432648, 8233},
  {"invertible linear transformation", 432990, 8242},
  {"infinite dimensional vector space", 433260, 8248},
  {"translation", 433508, 8254},
  {"shift operator", 433734, 8261},
  {"group representation", 433868, 8265},
  {"representation of a Lie group", 434084, 8271},
  {"Plot[]", 434277, 8277},
  {"coordinates", 434368, 8280},
  {"scaling group", 434512, 8284},
  {"pentagon", 434651, 8288},
  {"Do[]", 434775, 8292},
  {"scaling factor", 434914, 8296},
  {"self-similar objects", 435059, 8300}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 43, 1, 117, "ChapterLine",
  CellTags->"1.1"],
Cell[1785, 54, 65, 1, 193, "Title",
  CellTags->"1.1"],
Cell[1853, 57, 1042, 21, 201, "Text",
  Evaluatable->False,
  CellTags->{"general properties of a group", "computer algebra"}],

Cell[CellGroupData[{
Cell[2920, 82, 156, 7, 52, "Section",
  Evaluatable->False,
  CellTags->"Groups and Lie Groups"],
Cell[3079, 91, 428, 8, 96, "Text",
  Evaluatable->False,
  CellTags->"group theory"],

Cell[CellGroupData[{
Cell[3532, 103, 133, 7, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Groups"],
Cell[3668, 112, 237, 5, 75, "Text",
  Evaluatable->False],
Cell[3908, 119, 72, 1, 38, "Definition",
  CellTags->"Definition: Group"],
Cell[3983, 122, 923, 25, 96, "Text",
  Evaluatable->False,
  CellTags->{"composition", "group multiplication", "group"}],
Cell[4909, 149, 198, 5, 26, "ListItem",
  Evaluatable->False,
  CellTags->{"closure relation", "group properties"}],
Cell[5110, 156, 203, 6, 33, "Text",
  Evaluatable->False],
Cell[5316, 164, 713, 22, 30, "DisplayFormula",
  Evaluatable->False],
Cell[6032, 188, 170, 5, 26, "ListItem",
  Evaluatable->False,
  CellTags->"associativity"],
Cell[6205, 195, 277, 10, 54, "Text",
  Evaluatable->False],
Cell[6485, 207, 317, 8, 28, "DisplayFormula",
  Evaluatable->False],
Cell[6805, 217, 111, 4, 33, "Text",
  Evaluatable->False],
Cell[6919, 223, 177, 5, 26, "ListItem",
  Evaluatable->False,
  CellTags->"identity element"],
Cell[7099, 230, 219, 6, 54, "Text",
  Evaluatable->False],
Cell[7321, 238, 232, 7, 27, "DisplayFormula",
  Evaluatable->False],
Cell[7556, 247, 153, 6, 33, "Text",
  Evaluatable->False],
Cell[7712, 255, 135, 4, 26, "ListItem",
  Evaluatable->False],
Cell[7850, 261, 362, 11, 54, "Text",
  Evaluatable->False,
  CellTags->"inverse element"],
Cell[8215, 274, 266, 7, 27, "DisplayFormula",
  Evaluatable->False],
Cell[8484, 283, 1585, 36, 222, "Text",
  Evaluatable->False,
  CellTags->{"Abelian group", "multiplication table"}],
Cell[10072, 321, 558, 11, 117, "Text",
  Evaluatable->False,
  CellTags->{"finite group", "infinite group"}],
Cell[10633, 334, 167, 4, 54, "Text",
  Evaluatable->False],
Cell[10803, 340, 28, 0, 33, "Example"],
Cell[10834, 342, 644, 14, 117, "Text",
  Evaluatable->False,
  CellTags->{"multiplication", "multiplication table"}],
Cell[11481, 358, 77, 2, 27, "Input"],
Cell[11561, 362, 177, 6, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11763, 372, 234, 6, 27, "Input"],
Cell[12000, 380, 167, 6, 41, "Output"]
}, Open  ]],
Cell[12182, 389, 190, 4, 33, "Text",
  Evaluatable->False,
  CellTags->"multiplication table"],
Cell[12375, 395, 28, 0, 33, "Example"],
Cell[12406, 397, 111, 4, 33, "Text",
  Evaluatable->False],
Cell[12520, 403, 89, 2, 27, "Input"],
Cell[12612, 407, 79, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12716, 412, 242, 6, 45, "Input"],
Cell[12961, 420, 273, 8, 73, "Output"]
}, Open  ]],
Cell[13249, 431, 434, 12, 75, "Text",
  Evaluatable->False,
  CellTags->"Abelian group"],

Cell[CellGroupData[{
Cell[13708, 447, 212, 5, 27, "Input"],
Cell[13923, 454, 273, 8, 73, "Output"]
}, Open  ]],
Cell[14211, 465, 307, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"group element"],
Cell[14521, 475, 1158, 22, 222, "Text",
  Evaluatable->False,
  CellTags->{"rotations", "Abelian group"}],
Cell[15682, 499, 28, 0, 33, "Example"],
Cell[15713, 501, 774, 16, 138, "Text",
  Evaluatable->False,
  CellTags->{
  "non-commutative", "Rotation[]", "Geometry`Rotation`", "polygon"}],
Cell[16490, 519, 165, 4, 59, "Input"],
Cell[16658, 525, 162, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"display"],

Cell[CellGroupData[{
Cell[16845, 534, 146, 3, 45, "Input"],
Cell[16994, 539, 3018, 79, 145, 652, 43, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[20027, 621, 293, 9, 54, "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],
Cell[20323, 632, 84, 2, 27, "Input"],
Cell[20410, 636, 264, 5, 99, "Input"],
Cell[20677, 643, 341, 9, 75, "Text",
  Evaluatable->False,
  CellTags->"Rotation[]"],

Cell[CellGroupData[{
Cell[21043, 656, 169, 4, 57, "Input"],
Cell[21215, 662, 3299, 81, 171, 659, 43, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[24529, 746, 1021, 26, 159, "Text",
  Evaluatable->False,
  CellTags->"hexagon"],

Cell[CellGroupData[{
Cell[25575, 776, 458, 9, 167, "Input"],
Cell[26036, 787, 4900, 148, 145, 1479, 100, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[30951, 938, 1109, 30, 159, "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],
Cell[32063, 970, 145, 3, 59, "Input"],
Cell[32211, 975, 175, 6, 33, "Text"],

Cell[CellGroupData[{
Cell[32411, 985, 137, 2, 45, "Input"],
Cell[32551, 989, 24646, 418, 189, 1580, 127, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[57212, 1410, 515, 15, 75, "Text",
  Evaluatable->False,
  CellTags->{"RotationX[]", "RotationY[]", "RotationZ[]"}],
Cell[57730, 1427, 2455, 40, 603, "Input"],
Cell[60188, 1469, 257, 9, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[60470, 1482, 513, 10, 203, "Input"],
Cell[60986, 1494, 32293, 630, 189, 3406, 268, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[93294, 2127, 512, 8, 96, "Text",
  Evaluatable->False,
  CellTags->"non-commutative"],
Cell[93809, 2137, 164, 4, 54, "Text",
  CellTags->"isomorphism"]
}, Open  ]],

Cell[CellGroupData[{
Cell[94010, 2146, 88, 2, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Isomorphism"],
Cell[94101, 2150, 372, 7, 96, "Text",
  Evaluatable->False],
Cell[94476, 2159, 96, 1, 38, "Definition",
  CellTags->"Definition: Isomorphic groups"],
Cell[94575, 2162, 710, 18, 75, "Text"],
Cell[95288, 2182, 556, 10, 117, "Text",
  Evaluatable->False,
  CellTags->{"homomorphism", "isomorphic group"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[95881, 2197, 113, 5, 49, "Subsection",
  CellTags->"Lie Groups"],
Cell[95997, 2204, 1375, 23, 285, "Text",
  CellTags->{
  "manifold", "calculus", "partial differentiation", "algebra", "topology", 
    "Lie group"}],
Cell[97375, 2229, 80, 1, 38, "Definition",
  CellTags->"Definition: Lie group"],
Cell[97458, 2232, 533, 12, 96, "Text",
  CellTags->"manifold"],
Cell[97994, 2246, 667, 13, 117, "Text",
  Evaluatable->False],
Cell[98664, 2261, 28, 0, 33, "Example"],
Cell[98695, 2263, 1483, 30, 201, "Text",
  Evaluatable->False,
  CellTags->{"addition", "inverse", "N[]", "rational numbers"}],
Cell[100181, 2295, 28, 0, 33, "Example"],
Cell[100212, 2297, 1319, 34, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "special orthogonal group", "SO(3)", "GL(n", "\\[DoubleStruckCapitalR])", 
    "SL(n", "continuous matrix group", "unimodular group", "linear group", 
    "vector space", "\[DoubleStruckCapitalR])"}],
Cell[101534, 2333, 171, 5, 54, "Text",
  Evaluatable->False,
  CellTags->"matrix group"],
Cell[101708, 2340, 244, 7, 44, "DisplayFormula"],
Cell[101955, 2349, 303, 10, 33, "Text",
  Evaluatable->False],
Cell[102261, 2361, 134, 3, 28, "DisplayFormula",
  Evaluatable->False],
Cell[102398, 2366, 887, 23, 138, "Text",
  Evaluatable->False,
  CellTags->{"representation", "group axioms"}],
Cell[103288, 2391, 81, 2, 27, "Input"],
Cell[103372, 2395, 699, 18, 117, "Text",
  Evaluatable->False,
  CellTags->{"group multiplication", "MatrixForm[]"}],

Cell[CellGroupData[{
Cell[104096, 2417, 79, 2, 27, "Input"],
Cell[104178, 2421, 167, 6, 41, "Output"]
}, Open  ]],
Cell[104360, 2430, 215, 6, 54, "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{
Cell[104600, 2440, 92, 2, 27, "Input"],
Cell[104695, 2444, 171, 6, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[104903, 2455, 92, 2, 27, "Input"],
Cell[104998, 2459, 171, 6, 41, "Output"]
}, Open  ]],
Cell[105184, 2468, 463, 13, 75, "Text",
  Evaluatable->False,
  CellTags->{"Inverse[]", "inverse element"}],

Cell[CellGroupData[{
Cell[105672, 2485, 92, 2, 27, "Input"],
Cell[105767, 2489, 164, 6, 41, "Output"]
}, Open  ]],
Cell[105946, 2498, 242, 9, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[106213, 2511, 98, 2, 27, "Input"],
Cell[106314, 2515, 161, 6, 41, "Output"]
}, Open  ]],
Cell[106490, 2524, 723, 17, 75, "Text",
  Evaluatable->False,
  CellTags->{"identity element", "isomorphic"}],
Cell[107216, 2543, 833, 22, 96, "Text",
  Evaluatable->False,
  CellTags->{
  "vector space", "homomorphism", "invertible linear transformation", 
    "representation", "infinite dimensional vector space"}],
Cell[108052, 2567, 92, 1, 33, "Example"],
Cell[108147, 2570, 584, 16, 75, "Text",
  Evaluatable->False,
  CellTags->"translation"],
Cell[108734, 2588, 129, 3, 28, "DisplayFormula",
  Evaluatable->False],
Cell[108866, 2593, 487, 19, 54, "Text",
  Evaluatable->False,
  CellTags->"shift operator"],
Cell[109356, 2614, 66, 1, 28, "Input"],
Cell[109425, 2617, 868, 30, 96, "Text"],

Cell[CellGroupData[{
Cell[110318, 2651, 66, 2, 27, "Input"],
Cell[110387, 2655, 38, 1, 30, "Output"]
}, Open  ]],
Cell[110440, 2659, 359, 9, 75, "Text",
  Evaluatable->False,
  CellTags->"inverse element"],

Cell[CellGroupData[{
Cell[110824, 2672, 77, 2, 27, "Input"],
Cell[110904, 2676, 38, 1, 30, "Output"]
}, Open  ]],
Cell[110957, 2680, 526, 19, 54, "Text",
  Evaluatable->False,
  CellTags->"associativity"],

Cell[CellGroupData[{
Cell[111508, 2703, 78, 2, 27, "Input"],
Cell[111589, 2707, 50, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111676, 2713, 78, 2, 27, "Input"],
Cell[111757, 2717, 50, 1, 30, "Output"]
}, Open  ]],
Cell[111822, 2721, 1264, 27, 180, "Text",
  Evaluatable->False,
  CellTags->{
  "group representation", "isomorphic", "representation of a Lie group"}],
Cell[113089, 2750, 521, 8, 96, "Text",
  Evaluatable->False,
  CellTags->{"isomorphism", "homomorphism"}],
Cell[113613, 2760, 375, 8, 96, "Text",
  Evaluatable->False,
  CellTags->"translation"],
Cell[113991, 2770, 28, 0, 33, "Example"],
Cell[114022, 2772, 1275, 42, 117, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[115322, 2818, 258, 5, 81, "Input"],
Cell[115583, 2825, 19234, 592, 189, 7445, 442, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[134832, 3420, 596, 18, 75, "Text",
  CellTags->"Plot[]"],
Cell[135431, 3440, 28, 0, 33, "Example"],
Cell[135462, 3442, 564, 12, 117, "Text",
  Evaluatable->False,
  CellTags->{"coordinates", "scaling group"}],
Cell[136029, 3456, 181, 4, 63, "Input"],
Cell[136213, 3462, 447, 9, 96, "Text",
  Evaluatable->False,
  CellTags->{"polygon", "pentagon"}],
Cell[136663, 3473, 143, 3, 59, "Input"],
Cell[136809, 3478, 637, 13, 117, "Text",
  Evaluatable->False,
  CellTags->{"Do[]", "scaling factor"}],

Cell[CellGroupData[{
Cell[137471, 3495, 236, 5, 81, "Input"],

Cell[CellGroupData[{
Cell[137732, 3504, 3691, 89, 191, 644, 44, "GraphicsData", "PostScript", \
"Graphics"],
Cell[141426, 3595, 49967, 659, 190, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[191396, 4256, 24078, 340, 190, 647, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[215477, 4598, 21897, 313, 189, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[237377, 4913, 36033, 487, 189, 647, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[273413, 5402, 17662, 260, 189, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[291078, 5664, 28555, 395, 190, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[319636, 6061, 14106, 216, 190, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[333745, 6279, 12280, 194, 190, 647, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[346028, 6475, 18549, 271, 189, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[364580, 6748, 2954, 79, 190, 648, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[367537, 6829, 13223, 205, 190, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[380763, 7036, 6914, 128, 190, 643, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[387680, 7166, 5881, 115, 189, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[393564, 7283, 7296, 132, 190, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[400863, 7417, 4228, 94, 191, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[405094, 7513, 4593, 99, 190, 643, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[409690, 7614, 3070, 80, 191, 651, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False],
Cell[412763, 7696, 2655, 75, 191, 649, 44, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False]
}, Closed]]
}, Open  ]],
Cell[415445, 7775, 782, 19, 96, "Text",
  Evaluatable->False,
  CellTags->"self-similar objects"],
Cell[416230, 7796, 350, 7, 96, "Text",
  Evaluatable->False],
Cell[416583, 7805, 147, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

