(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    491715,      15870]*)
(*NotebookOutlinePosition[    497622,      16043]*)
(*  CellTagsIndexPosition[    496797,      16018]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.7 The Plane Jet", "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"The plane jet"],

Cell[TextData[{
  "The plane jet is an example for ",
  ButtonBox["Prandtl's boundary layer equations.",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  " We consider the steady two-dimensional motion of an incompressible \
viscous fluid due to a jet issuing from a long narrow orifice. We use \
Cartesian coordinates in the plane of motion. The origin of our coordinate \
system is located in the orifice and the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis lies in the plane of symmetry of the jet. The velocities in the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " directions are denoted by ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ", respectively. If we assume that the Prandtl boundary layer equations \
give a sufficiently good approximation and that the pressure is a constant, \
then the equations of the stationary problem read "
}], "Text",
  Evaluatable->False,
  CellTags->{
  "plane jet", "Prandtl's boundary-layer equations", 
    "incompressible viscous fluid"}],

Cell[BoxData[
    \(TraditionalForm\`\(u\_x + v\_y = 0, \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\ u\_x\  + \ v\ u\_y\  = \ \[Eta]\ \(u\_\(y, y\) . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notation, we find"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(jet = {
        u[x, y]\ \[PartialD]\_x u[x, y] + v[x, y]\ \[PartialD]\_y u[x, y] == 
          \[Eta]\ \[PartialD]\_{y, 2}u[x, y], 
        \[PartialD]\_x u[x, y] + \[PartialD]\_y v[x, y] == 0}; 
    jet // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\ u\_x + v\ u\_y - \[Eta]\ u\_\(y, y\) == 0\)},
          {\(u\_x + v\_y == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[Eta] is the kinematic viscosity. The equations of motion are \
accompanied with the boundary conditions"], "Text",
  Evaluatable->False,
  CellTags->"kinematic viscosity"],

Cell[CellGroupData[{

Cell[BoxData[
    \(bound = {\[PartialD]\_y u[x, y] == 0, v[x, y] == 0} /. y \[Rule] 0\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, 0\), "]"}], "==", "0"}], 
        ",", \(v[x, 0] == 0\)}], "}"}]], "Output"]
}, Open  ]],

Cell["and the asymptotic behavior", "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],

Cell["asympt = {u[x,y]->0 /; y->Infinity}", "Input",
  PageWidth->Infinity,
  Evaluatable->False],

Cell[TextData[{
  "An additional relation for the total ",
  StyleBox["x-",
    FontSlant->"Italic"],
  "component of the fluid momentum must be satisfied"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(M = 
      2\ \[Rho]\ 
          \(\[Integral]\_\(-\[Infinity]\)\%\[Infinity]\( u[x, y]\^2\) 
              \[DifferentialD]y\) == constant; \)\)], "Input"],

Cell[TextData[{
  "This sort of model was first discussed by ",
  ButtonBox["Schlichting",
    ButtonData:>{"Literat.nb", "Schl-33"},
    ButtonStyle->"Hyperlink"],
  " in 1933. We will use this model to discuss the analytic solution by means \
of a symmetry analysis. First, we transform ",
  ButtonBox["Prandtl",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[CloseCurlyQuote]",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["s boundary layer equations",
    ButtonData:>{"Layer.nb", "Prandtl's boundary layer equations"},
    ButtonStyle->"Hyperlink"],
  " to a single equation by introducing the stream function representation:"
}], "Text",
  Evaluatable->False,
  CellTags->{"Schlichting", "stream function"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(stream = {
        u \[Rule] Function[{x, y}, \[PartialD]\_y \[CapitalPsi][x, y]], 
        v \[Rule] Function[{x, y}, \(-\[PartialD]\_x \[CapitalPsi][x, y]\)]}
        \)], "Input"],

Cell[BoxData[
    \({u \[Rule] Function[{x, y}, \[PartialD]\_y \[CapitalPsi][x, y]], 
      v \[Rule] Function[{x, y}, \(-\[PartialD]\_x \[CapitalPsi][x, y]\)]}
      \)], "Output"]
}, Open  ]],

Cell["Applying this transformation to the jet equations, we find", "Text",
  Evaluatable->False,
  CellTags->"jet equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sjet = jet /. stream; sjet // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\[CapitalPsi]\_y\ \[CapitalPsi]\_\(x, y\) - 
                \[CapitalPsi]\_x\ \[CapitalPsi]\_\(y, y\) - 
                \[Eta]\ \[CapitalPsi]\_\(y, y, y\) == 0\)},
          {\(True == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"The original two equations reduce to a single equation for the stream \
function \[CapitalPsi] which is a non-linear partial differential equation of \
third order:"], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(jet = sjet\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{"-", 
            RowBox[{
              SuperscriptBox["\[CapitalPsi]", 
                TagBox[\((0, 2)\),
                  Derivative],
                MultilineFunction->None], "[", \(x, y\), "]"}]}], " ", 
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}], "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}], " ", 
          RowBox[{
            SuperscriptBox["\[CapitalPsi]", 
              TagBox[\((1, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x, y\), "]"}]}]}], "==", 
      RowBox[{"\[Eta]", " ", 
        RowBox[{
          SuperscriptBox["\[CapitalPsi]", 
            TagBox[\((0, 3)\),
              Derivative],
            MultilineFunction->None], "[", \(x, y\), "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We determine the symmetries of this equation by applying the function ",
  StyleBox["Infinitesimals[]", "MmaText"]
}], "Text",
  Evaluatable->False,
  CellTags->"Infinitesimals[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(symm = Infinitesimals[jet, \[CapitalPsi], {x, y}, {\[Eta]}]; 
    symm // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1 + k2\ \[CapitalPsi]\)},
          {\(\[Xi]\_1 == k3 + k4\ x\)},
          {\(\[Xi]\_2 == \((\(-k2\) + k4)\)\ y + \[ScriptCapitalF]\_1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k1, 
            Times[ k2, \[CapitalPsi]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k3, 
            Times[ k4, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Plus[ 
                Times[ -1, k2], k4], y], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a four-parameter group allowing translations and scalings as \
symmetries. Let us first discuss the translation symmetries and afterward use \
the scaling symmetry in our calculations. The related reduction of the \
original PDE follows by selecting the subgroups with ",
  StyleBox["k3=1", "MmaText",
    FontSlant->"Italic"],
  ", ",
  StyleBox["free[1][x]=c", "MmaText",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k1=1", "MmaText",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, y, \[CapitalPsi]], \(xi[2]\)[x, y, \[CapitalPsi]]}, {
              \(phi[1]\)[x, y, \[CapitalPsi]]}} /. symm\) /. {k1 \[Rule] 1, 
          k2 \[Rule] 0, k3 \[Rule] 1, k4 \[Rule] 0, \(free[1]\)[x] \[Rule] c}
          \)], "Input"],

Cell[BoxData[
    \({{1, c}, {1}}\)], "Output"]
}, Open  ]],

Cell["The reduction follows by", "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1 = 
      LieReduction[jet, {\[CapitalPsi]}, {x, y}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-c\)\ x + y - \[Zeta]\_1 == 0\)},
          {\(\(-x\) + \[CapitalPsi] - F\_1 == 0\)},
          {
            \(\(-F1\_\(\[Zeta]\_1, \[Zeta]\_1\)\) - 
                \[Eta]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The solution of the reduced equation follows by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ssol = 
      DSolve[red1\[LeftDoubleBracket]3\[RightDoubleBracket], F1, zeta1]\)], 
  "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(-\(#1\/\[Eta]\)\)\ \[Eta]\^2\ C[1] + C[2] + C[3]\ #1&)\)}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where #1 represents the variable ",
  StyleBox["zeta",
    FontSlant->"Italic"],
  "1. The similarity solution in the original variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is "
}], "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      Flatten[Solve[
          Flatten[red1\[LeftDoubleBracket]2\[RightDoubleBracket] /. ssol], 
          \[CapitalPsi]]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\[CapitalPsi] \[Rule] 
        x + E\^\(-\(\(\(-c\)\ x + y\)\/\[Eta]\)\)\ \[Eta]\^2\ C[1] + C[2] + 
          \((\(-c\)\ x + y)\)\ C[3]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This solution contains three constants of integration ",
  StyleBox["C[i]",
    FontSlant->"Italic"],
  ", ",
  StyleBox["i ",
    FontSlant->"Italic"],
  "= 1, 2, 3. The constants must be chosen in such a way that the boundary \
conditions are satisfied. The first boundary condition requires"
}], "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
        \[PartialD]\_{y, 2}\((\[CapitalPsi] /. sol)\) /. y \[Rule] 0] == 0
      \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(E\^\(\(c\ x\)\/\[Eta]\)\ C[1] == 0\)], "Output"]
}, Open  ]],

Cell["which can only be satisfied by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(rule = {C[1] \[Rule] 0}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({C[1] \[Rule] 0}\)], "Output"]
}, Open  ]],

Cell["The second boundary condition requires", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
          \[PartialD]\_{x, 1}\((\[CapitalPsi] /. sol)\) /. y \[Rule] 0] == 
        0 /. rule\)], "Input"],

Cell[BoxData[
    \(1 - c\ C[3] == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which allows a special choice ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[3]=1/",
  StyleBox["c",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[rule, C[3] \[Rule] 1\/c]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({C[1] \[Rule] 0, C[3] \[Rule] 1\/c}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Using the asymptotic behavior of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " results in "
}], "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\[PartialD]\_{y, 1}\((\[CapitalPsi] /. sol)\) /. rule]\)], 
  "Input"],

Cell[BoxData[
    \(1\/c\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result shows that the requirement that ",
  Cell[BoxData[
      \(TraditionalForm\`u \[Rule] 0\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`y \[Rule] \[Infinity]\)]],
  " can only be satisfied if we set ",
  Cell[BoxData[
      \(TraditionalForm\`c \[Rule] \[Infinity]\)]],
  ". In conclusion, the symmetry of translation is not compatible with the \
boundary conditions."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "The second type of symmetry under which the third-order PDE is invariant \
is given by a scaling. The related subgroup is extracted by setting ",
  StyleBox["k2=c",
    FontSlant->"Italic"],
  " and ",
  StyleBox["k4=1",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi1 = 
      \({{\(xi[1]\)[x, y, \[CapitalPsi]], \(xi[2]\)[x, y, \[CapitalPsi]]}, {
              \(phi[1]\)[x, y, \[CapitalPsi]]}} /. symm\) /. {k1 \[Rule] 0, 
          k2 \[Rule] c, k3 \[Rule] 0, k4 \[Rule] 1, \(free[1]\)[x] \[Rule] 0}
          \)], "Input"],

Cell[BoxData[
    \({{x, \((1 - c)\)\ y}, {c\ \[CapitalPsi]}}\)], "Output"]
}, Open  ]],

Cell["The similarity reduction for the scaling group follows by", "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red2 = 
      LieReduction[jet, {\[CapitalPsi]}, {x, y}, 
        infi1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red2]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x\^\(\(-1\) + c\)\ y - \[Zeta]\_1 == 0\)},
          {\(x\^\(-c\)\ \[CapitalPsi] - F\_1 == 0\)},
          {
            \(y\^\(-\(\(4\ c\)\/\(\(-1\) + c\)\)\)\ 
                \[Zeta]\_1\%\(\(4\ c\)\/\(\(-1\) + c\)\)\ 
                \((\(-\((F\_1)\)\_\[Zeta]\_1\%2\) + 
                    2\ c\ \((F\_1)\)\_\[Zeta]\_1\%2 - 
                    c\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                    \[Eta]\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, 
                        \[Zeta]\_1\))\)\n\t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The left-hand side of the equation is without any common \
coefficients\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq2\  = \ 
      red2\[LeftDoubleBracket]3, 1, 1\[RightDoubleBracket]/
        \((y\^\(-\(\(4\ c\)\/\(\(-1\) + c\)\)\)\ 
            zeta1\^\(\(4\ c\)\/\(\(-1\) + c\)\))\); 
    LTF[eq2] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\((F\_1)\)\_\[Zeta]\_1\%2\) + 
                2\ c\ \((F\_1)\)\_\[Zeta]\_1\%2 - 
                c\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                \[Eta]\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 
              0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This third-order ODE is not solved by ",
  StyleBox["DSolve[]", "MmaText"],
  ". However, a first integration with respect to ",
  StyleBox["zeta1",
    FontSlant->"Italic"],
  " shows us that the equation is integrable if we choose a special value for \
",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ". If we set ",
  Cell[BoxData[
      \(TraditionalForm\`c \[Rule] 1/3\)]],
  ", we get a second-order ODE which is equal to a first constant of \
integration:"
}], "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((eq2 /. c \[Rule] 1\/3)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-\(1\/3\)\), " ", 
        SuperscriptBox[
          RowBox[{
            SuperscriptBox["F1", "\[Prime]",
              MultilineFunction->None], "[", "zeta1", "]"}], "2"]}], "-", 
      RowBox[{\(1\/3\), " ", \(F1[zeta1]\), " ", 
        RowBox[{
          SuperscriptBox["F1", "\[DoublePrime]",
            MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
      RowBox[{"\[Eta]", " ", 
        RowBox[{
          SuperscriptBox["F1", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "zeta1", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(int1 = 
      \[Integral]\((eq2 /. c \[Rule] 1\/3)\) \[DifferentialD]zeta1 == K1\)], 
  "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(-\(1\/3\)\), " ", \(F1[zeta1]\), " ", 
          RowBox[{
            SuperscriptBox["F1", "\[Prime]",
              MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
        RowBox[{"\[Eta]", " ", 
          RowBox[{
            SuperscriptBox["F1", "\[DoublePrime]",
              MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
      "K1"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Taking the boundary conditions into account, we realize that ",
  StyleBox["K",
    FontSlant->"Italic"],
  "1 = 0. This follows since ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["F",
                    FontSlant->"Italic"], "1"}]], "'"}], \((0)\)}], "=", 
          "0"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["F",
                      FontSlant->"Italic"], "1"}]], "'"}], "'"}], \((0)\)}], 
          "=", "0"}], TraditionalForm]]],
  ". Thus, the result simplifies and we can integrate the relation a second \
time:"
}], "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(int2 = 
      \[Integral]int1\[LeftDoubleBracket]1\[RightDoubleBracket] 
            \[DifferentialD]zeta1 == \(-K2\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\(-\(1\/6\)\)\ F1[zeta1]\^2\), "-", 
        RowBox[{"\[Eta]", " ", 
          RowBox[{
            SuperscriptBox["F1", "\[Prime]",
              MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
      \(-K2\)}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Now using ",
  StyleBox["DSolve[]", "MmaText"],
  " to integrate the first-order ordinary differential equation, we get the \
solution"
}], "Text",
  Evaluatable->False,
  CellTags->"jet solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sols = Flatten[DSolve[int2, F1, zeta1]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({F1 \[Rule] 
        \((\@6\ \@K2\ 
              Tanh[1\/6\ 
                  \((\(\@6\ \@K2\ #1\)\/\[Eta] - 6\ \@6\ \@K2\ C[1])\)]&)\)}
      \)], "Output"]
}, Open  ]],

Cell["The corresponding similarity representation follows by", "Text",
  Evaluatable->False,
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ssol = 
      Solve[\(red2\[LeftDoubleBracket]2\[RightDoubleBracket] /. sols\) /. 
          c \[Rule] 1\/3, \[CapitalPsi]]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{\[CapitalPsi] \[Rule] 
          \@6\ \@K2\ x\^\(1/3\)\ 
            Tanh[1\/6\ 
                \((\(\@6\ \@K2\ y\)\/\(x\^\(2/3\)\ \[Eta]\) - 
                    6\ \@6\ \@K2\ C[1])\)]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This solution contains three parameters \[Eta], ",
  StyleBox["K",
    FontSlant->"Italic"],
  "2, and ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  ". \[Eta] is the kinematic viscosity which we set to unity in the \
following. The integration constant ",
  StyleBox["K",
    FontSlant->"Italic"],
  "2 changes the amplitude as well as the argument of the ",
  StyleBox["Tanh[]", "MmaText"],
  " function. ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  " determines the location of the orifice which we set to the origin. The \
following contour plot of the stream function gives us a representation of \
the stream lines in the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  "-plane:"
}], "Text",
  Evaluatable->False,
  CellTags->{"Tanh[]", "contour plot"}],

Cell[BoxData[
    \(\(so1 = 
      \((\(\[CapitalPsi] /. ssol\) /. {K2 \[Rule] 1, \[Eta] \[Rule] 1, 
              C[1] \[Rule] 0})\)\[LeftDoubleBracket]1\[RightDoubleBracket]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[so1, {x,  .01, 3}, {y, \(-3\), 3}, PlotPoints \[Rule] 50, 
      Contours \[Rule] 20, ColorFunction \[Rule] Hue, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0160149 0.321585 0.5 0.160256 [
[.01601 -0.0125 -3 -9 ]
[.01601 -0.0125 3 0 ]
[.17681 -0.0125 -9 -9 ]
[.17681 -0.0125 9 0 ]
[.3376 -0.0125 -3 -9 ]
[.3376 -0.0125 3 0 ]
[.49839 -0.0125 -9 -9 ]
[.49839 -0.0125 9 0 ]
[.65918 -0.0125 -3 -9 ]
[.65918 -0.0125 3 0 ]
[.81998 -0.0125 -9 -9 ]
[.81998 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .17949 -12 -4.5 ]
[-0.0125 .17949 0 4.5 ]
[-0.0125 .33974 -12 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .66026 -6 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .82051 -6 -4.5 ]
[-0.0125 .82051 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01601 0 m
.01601 .00625 L
s
[(0)] .01601 -0.0125 0 1 Mshowa
.17681 0 m
.17681 .00625 L
s
[(0.5)] .17681 -0.0125 0 1 Mshowa
.3376 0 m
.3376 .00625 L
s
[(1)] .3376 -0.0125 0 1 Mshowa
.49839 0 m
.49839 .00625 L
s
[(1.5)] .49839 -0.0125 0 1 Mshowa
.65918 0 m
.65918 .00625 L
s
[(2)] .65918 -0.0125 0 1 Mshowa
.81998 0 m
.81998 .00625 L
s
[(2.5)] .81998 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(3)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.04817 0 m
.04817 .00375 L
s
.08033 0 m
.08033 .00375 L
s
.11249 0 m
.11249 .00375 L
s
.14465 0 m
.14465 .00375 L
s
.20897 0 m
.20897 .00375 L
s
.24112 0 m
.24112 .00375 L
s
.27328 0 m
.27328 .00375 L
s
.30544 0 m
.30544 .00375 L
s
.36976 0 m
.36976 .00375 L
s
.40192 0 m
.40192 .00375 L
s
.43408 0 m
.43408 .00375 L
s
.46623 0 m
.46623 .00375 L
s
.53055 0 m
.53055 .00375 L
s
.56271 0 m
.56271 .00375 L
s
.59487 0 m
.59487 .00375 L
s
.62703 0 m
.62703 .00375 L
s
.69134 0 m
.69134 .00375 L
s
.7235 0 m
.7235 .00375 L
s
.75566 0 m
.75566 .00375 L
s
.78782 0 m
.78782 .00375 L
s
.85214 0 m
.85214 .00375 L
s
.88429 0 m
.88429 .00375 L
s
.91645 0 m
.91645 .00375 L
s
.94861 0 m
.94861 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-3)] -0.0125 .01923 1 0 Mshowa
0 .17949 m
.00625 .17949 L
s
[(-2)] -0.0125 .17949 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(-1)] -0.0125 .33974 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(1)] -0.0125 .66026 1 0 Mshowa
0 .82051 m
.00625 .82051 L
s
[(2)] -0.0125 .82051 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(3)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05128 m
.00375 .05128 L
s
0 .08333 m
.00375 .08333 L
s
0 .11538 m
.00375 .11538 L
s
0 .14744 m
.00375 .14744 L
s
0 .21154 m
.00375 .21154 L
s
0 .24359 m
.00375 .24359 L
s
0 .27564 m
.00375 .27564 L
s
0 .30769 m
.00375 .30769 L
s
0 .37179 m
.00375 .37179 L
s
0 .40385 m
.00375 .40385 L
s
0 .4359 m
.00375 .4359 L
s
0 .46795 m
.00375 .46795 L
s
0 .53205 m
.00375 .53205 L
s
0 .5641 m
.00375 .5641 L
s
0 .59615 m
.00375 .59615 L
s
0 .62821 m
.00375 .62821 L
s
0 .69231 m
.00375 .69231 L
s
0 .72436 m
.00375 .72436 L
s
0 .75641 m
.00375 .75641 L
s
0 .78846 m
.00375 .78846 L
s
0 .85256 m
.00375 .85256 L
s
0 .88462 m
.00375 .88462 L
s
0 .91667 m
.00375 .91667 L
s
0 .94872 m
.00375 .94872 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01601 .99375 m
.01601 1 L
s
.17681 .99375 m
.17681 1 L
s
.3376 .99375 m
.3376 1 L
s
.49839 .99375 m
.49839 1 L
s
.65918 .99375 m
.65918 1 L
s
.81998 .99375 m
.81998 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.04817 .99625 m
.04817 1 L
s
.08033 .99625 m
.08033 1 L
s
.11249 .99625 m
.11249 1 L
s
.14465 .99625 m
.14465 1 L
s
.20897 .99625 m
.20897 1 L
s
.24112 .99625 m
.24112 1 L
s
.27328 .99625 m
.27328 1 L
s
.30544 .99625 m
.30544 1 L
s
.36976 .99625 m
.36976 1 L
s
.40192 .99625 m
.40192 1 L
s
.43408 .99625 m
.43408 1 L
s
.46623 .99625 m
.46623 1 L
s
.53055 .99625 m
.53055 1 L
s
.56271 .99625 m
.56271 1 L
s
.59487 .99625 m
.59487 1 L
s
.62703 .99625 m
.62703 1 L
s
.69134 .99625 m
.69134 1 L
s
.7235 .99625 m
.7235 1 L
s
.75566 .99625 m
.75566 1 L
s
.78782 .99625 m
.78782 1 L
s
.85214 .99625 m
.85214 1 L
s
.88429 .99625 m
.88429 1 L
s
.91645 .99625 m
.91645 1 L
s
.94861 .99625 m
.94861 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .17949 m
1 .17949 L
s
.99375 .33974 m
1 .33974 L
s
.99375 .5 m
1 .5 L
s
.99375 .66026 m
1 .66026 L
s
.99375 .82051 m
1 .82051 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05128 m
1 .05128 L
s
.99625 .08333 m
1 .08333 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .14744 m
1 .14744 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .24359 m
1 .24359 L
s
.99625 .27564 m
1 .27564 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .37179 m
1 .37179 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .4359 m
1 .4359 L
s
.99625 .46795 m
1 .46795 L
s
.99625 .53205 m
1 .53205 L
s
.99625 .5641 m
1 .5641 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .62821 m
1 .62821 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .72436 m
1 .72436 L
s
.99625 .75641 m
1 .75641 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .85256 m
1 .85256 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .91667 m
1 .91667 L
s
.99625 .94872 m
1 .94872 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .4 r
.01923 .46197 m
.03885 .4623 L
.05848 .45511 L
.07337 .45094 L
.0781 .44978 L
.09772 .44542 L
.11735 .44168 L
.13697 .43837 L
.15659 .43539 L
.17622 .43267 L
.18655 .43132 L
.19584 .43015 L
.21546 .42781 L
.23509 .42561 L
.25471 .42354 L
.27433 .42158 L
.29396 .41971 L
.31358 .41793 L
.3332 .41622 L
.35283 .41458 L
.37245 .413 L
.38915 .4117 L
.39207 .41147 L
.4117 .41 L
.43132 .40857 L
.45094 .40719 L
.47057 .40585 L
.49019 .40455 L
.50981 .40328 L
.52943 .40204 L
.54906 .40084 L
.56868 .39966 L
.5883 .39851 L
.60793 .39739 L
.62755 .39629 L
.64717 .39522 L
.6668 .39416 L
.68642 .39313 L
.70604 .39212 L
.70689 .39207 L
.72567 .39112 L
.74529 .39014 L
.76491 .38918 L
.78454 .38824 L
.80416 .38731 L
.82378 .3864 L
.84341 .3855 L
.86303 .38462 L
.88265 .38375 L
.90228 .38289 L
.9219 .38205 L
.94152 .38122 L
.96115 .38039 L
.98077 .37958 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .46197 m
.03885 .4623 L
.05848 .45511 L
.07337 .45094 L
.0781 .44978 L
.09772 .44542 L
.11735 .44168 L
.13697 .43837 L
.15659 .43539 L
.17622 .43267 L
.18655 .43132 L
.19584 .43015 L
.21546 .42781 L
.23509 .42561 L
.25471 .42354 L
.27433 .42158 L
.29396 .41971 L
.31358 .41793 L
.3332 .41622 L
.35283 .41458 L
.37245 .413 L
.38915 .4117 L
.39207 .41147 L
.4117 .41 L
.43132 .40857 L
.45094 .40719 L
.47057 .40585 L
.49019 .40455 L
.50981 .40328 L
.52943 .40204 L
.54906 .40084 L
.56868 .39966 L
.5883 .39851 L
.60793 .39739 L
.62755 .39629 L
.64717 .39522 L
.6668 .39416 L
.68642 .39313 L
.70604 .39212 L
.70689 .39207 L
.72567 .39112 L
.74529 .39014 L
.76491 .38918 L
.78454 .38824 L
.80416 .38731 L
.82378 .3864 L
.84341 .3855 L
.86303 .38462 L
.88265 .38375 L
.90228 .38289 L
Mistroke
.9219 .38205 L
.94152 .38122 L
.96115 .38039 L
.98077 .37958 L
Mfstroke
0 1 .7 r
.01923 .48722 m
.03885 .4788 L
.05848 .47414 L
.0781 .47078 L
.07952 .47057 L
.09772 .46807 L
.11735 .46576 L
.13697 .46373 L
.15659 .4619 L
.17622 .46023 L
.19584 .4587 L
.21546 .45727 L
.23509 .45593 L
.25471 .45467 L
.27433 .45348 L
.29396 .45234 L
.31358 .45126 L
.31951 .45094 L
.3332 .45022 L
.35283 .44923 L
.37245 .44827 L
.39207 .44735 L
.4117 .44646 L
.43132 .44559 L
.45094 .44476 L
.47057 .44395 L
.49019 .44316 L
.50981 .44239 L
.52943 .44164 L
.54906 .44091 L
.56868 .4402 L
.5883 .43951 L
.60793 .43883 L
.62755 .43817 L
.64717 .43752 L
.6668 .43688 L
.68642 .43626 L
.70604 .43564 L
.72567 .43504 L
.74529 .43445 L
.76491 .43388 L
.78454 .43331 L
.80416 .43275 L
.82378 .4322 L
.84341 .43165 L
.85575 .43132 L
.86303 .43112 L
.88265 .4306 L
.90228 .43008 L
.9219 .42957 L
.94152 .42907 L
.96115 .42857 L
.98077 .42808 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .48722 m
.03885 .4788 L
.05848 .47414 L
.0781 .47078 L
.07952 .47057 L
.09772 .46807 L
.11735 .46576 L
.13697 .46373 L
.15659 .4619 L
.17622 .46023 L
.19584 .4587 L
.21546 .45727 L
.23509 .45593 L
.25471 .45467 L
.27433 .45348 L
.29396 .45234 L
.31358 .45126 L
.31951 .45094 L
.3332 .45022 L
.35283 .44923 L
.37245 .44827 L
.39207 .44735 L
.4117 .44646 L
.43132 .44559 L
.45094 .44476 L
.47057 .44395 L
.49019 .44316 L
.50981 .44239 L
.52943 .44164 L
.54906 .44091 L
.56868 .4402 L
.5883 .43951 L
.60793 .43883 L
.62755 .43817 L
.64717 .43752 L
.6668 .43688 L
.68642 .43626 L
.70604 .43564 L
.72567 .43504 L
.74529 .43445 L
.76491 .43388 L
.78454 .43331 L
.80416 .43275 L
.82378 .4322 L
.84341 .43165 L
.85575 .43132 L
.86303 .43112 L
.88265 .4306 L
.90228 .43008 L
.9219 .42957 L
Mistroke
.94152 .42907 L
.96115 .42857 L
.98077 .42808 L
Mfstroke
0 1 1 r
.01923 .49687 m
.03885 .49311 L
.05848 .49154 L
.0781 .4904 L
.08231 .49019 L
.09772 .48948 L
.11735 .4887 L
.13697 .48802 L
.15659 .48741 L
.17622 .48685 L
.19584 .48633 L
.21546 .48585 L
.23509 .4854 L
.25471 .48498 L
.27433 .48458 L
.29396 .4842 L
.31358 .48384 L
.3332 .48349 L
.35283 .48315 L
.37245 .48283 L
.39207 .48252 L
.4117 .48223 L
.43132 .48194 L
.45094 .48166 L
.47057 .48139 L
.49019 .48112 L
.50981 .48087 L
.52943 .48062 L
.54906 .48037 L
.56868 .48013 L
.5883 .4799 L
.60793 .47967 L
.62755 .47945 L
.64717 .47924 L
.6668 .47902 L
.68642 .47881 L
.70604 .47861 L
.72567 .47841 L
.74529 .47821 L
.76491 .47802 L
.78454 .47783 L
.80416 .47764 L
.82378 .47746 L
.84341 .47728 L
.86303 .4771 L
.88265 .47692 L
.90228 .47675 L
.9219 .47658 L
.94152 .47641 L
.96115 .47625 L
.98077 .47608 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49687 m
.03885 .49311 L
.05848 .49154 L
.0781 .4904 L
.08231 .49019 L
.09772 .48948 L
.11735 .4887 L
.13697 .48802 L
.15659 .48741 L
.17622 .48685 L
.19584 .48633 L
.21546 .48585 L
.23509 .4854 L
.25471 .48498 L
.27433 .48458 L
.29396 .4842 L
.31358 .48384 L
.3332 .48349 L
.35283 .48315 L
.37245 .48283 L
.39207 .48252 L
.4117 .48223 L
.43132 .48194 L
.45094 .48166 L
.47057 .48139 L
.49019 .48112 L
.50981 .48087 L
.52943 .48062 L
.54906 .48037 L
.56868 .48013 L
.5883 .4799 L
.60793 .47967 L
.62755 .47945 L
.64717 .47924 L
.6668 .47902 L
.68642 .47881 L
.70604 .47861 L
.72567 .47841 L
.74529 .47821 L
.76491 .47802 L
.78454 .47783 L
.80416 .47764 L
.82378 .47746 L
.84341 .47728 L
.86303 .4771 L
.88265 .47692 L
.90228 .47675 L
.9219 .47658 L
.94152 .47641 L
.96115 .47625 L
Mistroke
.98077 .47608 L
Mfstroke
0 .7 1 r
.01923 .50313 m
.03885 .50689 L
.05848 .50846 L
.0781 .5096 L
.08231 .50981 L
.09772 .51052 L
.11735 .5113 L
.13697 .51198 L
.15659 .51259 L
.17622 .51315 L
.19584 .51367 L
.21546 .51415 L
.23509 .5146 L
.25471 .51502 L
.27433 .51542 L
.29396 .5158 L
.31358 .51616 L
.3332 .51651 L
.35283 .51685 L
.37245 .51717 L
.39207 .51748 L
.4117 .51777 L
.43132 .51806 L
.45094 .51834 L
.47057 .51861 L
.49019 .51888 L
.50981 .51913 L
.52943 .51938 L
.54906 .51963 L
.56868 .51987 L
.5883 .5201 L
.60793 .52033 L
.62755 .52055 L
.64717 .52076 L
.6668 .52098 L
.68642 .52119 L
.70604 .52139 L
.72567 .52159 L
.74529 .52179 L
.76491 .52198 L
.78454 .52217 L
.80416 .52236 L
.82378 .52254 L
.84341 .52272 L
.86303 .5229 L
.88265 .52308 L
.90228 .52325 L
.9219 .52342 L
.94152 .52359 L
.96115 .52375 L
.98077 .52392 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .50313 m
.03885 .50689 L
.05848 .50846 L
.0781 .5096 L
.08231 .50981 L
.09772 .51052 L
.11735 .5113 L
.13697 .51198 L
.15659 .51259 L
.17622 .51315 L
.19584 .51367 L
.21546 .51415 L
.23509 .5146 L
.25471 .51502 L
.27433 .51542 L
.29396 .5158 L
.31358 .51616 L
.3332 .51651 L
.35283 .51685 L
.37245 .51717 L
.39207 .51748 L
.4117 .51777 L
.43132 .51806 L
.45094 .51834 L
.47057 .51861 L
.49019 .51888 L
.50981 .51913 L
.52943 .51938 L
.54906 .51963 L
.56868 .51987 L
.5883 .5201 L
.60793 .52033 L
.62755 .52055 L
.64717 .52076 L
.6668 .52098 L
.68642 .52119 L
.70604 .52139 L
.72567 .52159 L
.74529 .52179 L
.76491 .52198 L
.78454 .52217 L
.80416 .52236 L
.82378 .52254 L
.84341 .52272 L
.86303 .5229 L
.88265 .52308 L
.90228 .52325 L
.9219 .52342 L
.94152 .52359 L
.96115 .52375 L
Mistroke
.98077 .52392 L
Mfstroke
0 .4 1 r
.01923 .51278 m
.03885 .5212 L
.05848 .52586 L
.0781 .52922 L
.07952 .52943 L
.09772 .53193 L
.11735 .53424 L
.13697 .53627 L
.15659 .5381 L
.17622 .53977 L
.19584 .5413 L
.21546 .54273 L
.23509 .54407 L
.25471 .54533 L
.27433 .54652 L
.29396 .54766 L
.31358 .54874 L
.31951 .54906 L
.3332 .54978 L
.35283 .55077 L
.37245 .55173 L
.39207 .55265 L
.4117 .55354 L
.43132 .55441 L
.45094 .55524 L
.47057 .55605 L
.49019 .55684 L
.50981 .55761 L
.52943 .55836 L
.54906 .55909 L
.56868 .5598 L
.5883 .56049 L
.60793 .56117 L
.62755 .56183 L
.64717 .56248 L
.6668 .56312 L
.68642 .56374 L
.70604 .56436 L
.72567 .56496 L
.74529 .56555 L
.76491 .56612 L
.78454 .56669 L
.80416 .56725 L
.82378 .5678 L
.84341 .56835 L
.85575 .56868 L
.86303 .56888 L
.88265 .5694 L
.90228 .56992 L
.9219 .57043 L
.94152 .57093 L
.96115 .57143 L
.98077 .57192 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .51278 m
.03885 .5212 L
.05848 .52586 L
.0781 .52922 L
.07952 .52943 L
.09772 .53193 L
.11735 .53424 L
.13697 .53627 L
.15659 .5381 L
.17622 .53977 L
.19584 .5413 L
.21546 .54273 L
.23509 .54407 L
.25471 .54533 L
.27433 .54652 L
.29396 .54766 L
.31358 .54874 L
.31951 .54906 L
.3332 .54978 L
.35283 .55077 L
.37245 .55173 L
.39207 .55265 L
.4117 .55354 L
.43132 .55441 L
.45094 .55524 L
.47057 .55605 L
.49019 .55684 L
.50981 .55761 L
.52943 .55836 L
.54906 .55909 L
.56868 .5598 L
.5883 .56049 L
.60793 .56117 L
.62755 .56183 L
.64717 .56248 L
.6668 .56312 L
.68642 .56374 L
.70604 .56436 L
.72567 .56496 L
.74529 .56555 L
.76491 .56612 L
.78454 .56669 L
.80416 .56725 L
.82378 .5678 L
.84341 .56835 L
.85575 .56868 L
.86303 .56888 L
.88265 .5694 L
.90228 .56992 L
.9219 .57043 L
Mistroke
.94152 .57093 L
.96115 .57143 L
.98077 .57192 L
Mfstroke
0 .1 1 r
.01923 .53803 m
.03885 .5377 L
.05848 .54489 L
.07337 .54906 L
.0781 .55022 L
.09772 .55458 L
.11735 .55832 L
.13697 .56163 L
.15659 .56461 L
.17622 .56733 L
.18655 .56868 L
.19584 .56985 L
.21546 .57219 L
.23509 .57439 L
.25471 .57646 L
.27433 .57842 L
.29396 .58029 L
.31358 .58207 L
.3332 .58378 L
.35283 .58542 L
.37245 .587 L
.38915 .5883 L
.39207 .58853 L
.4117 .59 L
.43132 .59143 L
.45094 .59281 L
.47057 .59415 L
.49019 .59545 L
.50981 .59672 L
.52943 .59796 L
.54906 .59916 L
.56868 .60034 L
.5883 .60149 L
.60793 .60261 L
.62755 .60371 L
.64717 .60478 L
.6668 .60584 L
.68642 .60687 L
.70604 .60788 L
.70689 .60793 L
.72567 .60888 L
.74529 .60986 L
.76491 .61082 L
.78454 .61176 L
.80416 .61269 L
.82378 .6136 L
.84341 .6145 L
.86303 .61538 L
.88265 .61625 L
.90228 .61711 L
.9219 .61795 L
.94152 .61878 L
.96115 .61961 L
.98077 .62042 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .53803 m
.03885 .5377 L
.05848 .54489 L
.07337 .54906 L
.0781 .55022 L
.09772 .55458 L
.11735 .55832 L
.13697 .56163 L
.15659 .56461 L
.17622 .56733 L
.18655 .56868 L
.19584 .56985 L
.21546 .57219 L
.23509 .57439 L
.25471 .57646 L
.27433 .57842 L
.29396 .58029 L
.31358 .58207 L
.3332 .58378 L
.35283 .58542 L
.37245 .587 L
.38915 .5883 L
.39207 .58853 L
.4117 .59 L
.43132 .59143 L
.45094 .59281 L
.47057 .59415 L
.49019 .59545 L
.50981 .59672 L
.52943 .59796 L
.54906 .59916 L
.56868 .60034 L
.5883 .60149 L
.60793 .60261 L
.62755 .60371 L
.64717 .60478 L
.6668 .60584 L
.68642 .60687 L
.70604 .60788 L
.70689 .60793 L
.72567 .60888 L
.74529 .60986 L
.76491 .61082 L
.78454 .61176 L
.80416 .61269 L
.82378 .6136 L
.84341 .6145 L
.86303 .61538 L
.88265 .61625 L
.90228 .61711 L
Mistroke
.9219 .61795 L
.94152 .61878 L
.96115 .61961 L
.98077 .62042 L
Mfstroke
.2 0 1 r
.98077 .66977 m
.96115 .66865 L
.94152 .66751 L
.92942 .6668 L
.9219 .66635 L
.90228 .66518 L
.88265 .66399 L
.86303 .66278 L
.84341 .66155 L
.82378 .66031 L
.80416 .65904 L
.78454 .65776 L
.76491 .65645 L
.74529 .65512 L
.72567 .65376 L
.70604 .65239 L
.68642 .65098 L
.6668 .64955 L
.64717 .64809 L
.63507 .64717 L
.62755 .6466 L
.60793 .64508 L
.5883 .64352 L
.56868 .64193 L
.54906 .64031 L
.52943 .63864 L
.50981 .63693 L
.49019 .63518 L
.47057 .63338 L
.45094 .63153 L
.43132 .62962 L
.4117 .62766 L
.41063 .62755 L
.39207 .62563 L
.37245 .62353 L
.35283 .62136 L
.3332 .6191 L
.31358 .61676 L
.29396 .61431 L
.27433 .61175 L
.25471 .60906 L
.2467 .60793 L
.23509 .60623 L
.21546 .60324 L
.19584 .60006 L
.17622 .59665 L
.15659 .59298 L
.13697 .58899 L
.13379 .5883 L
.11735 .58458 L
.09772 .57966 L
.0781 .57403 L
.06192 .56868 L
.05848 .56751 L
.03885 .55999 L
.03024 .56868 L
.02679 .5883 L
.02585 .60793 L
.02553 .62755 L
.02544 .64717 L
.02543 .6668 L
.02546 .68642 L
.03221 .70604 L
.02917 .72567 L
.02753 .74529 L
.02655 .76491 L
.02592 .78454 L
.0255 .80416 L
.0252 .82378 L
.02498 .84341 L
.02482 .86303 L
.0247 .88265 L
.02461 .90228 L
.02454 .9219 L
.02449 .94152 L
.02445 .96115 L
.02442 .98077 L
.98077 .98077 L
F
0 g
.98077 .66977 m
.96115 .66865 L
.94152 .66751 L
.92942 .6668 L
.9219 .66635 L
.90228 .66518 L
.88265 .66399 L
.86303 .66278 L
.84341 .66155 L
.82378 .66031 L
.80416 .65904 L
.78454 .65776 L
.76491 .65645 L
.74529 .65512 L
.72567 .65376 L
.70604 .65239 L
.68642 .65098 L
.6668 .64955 L
.64717 .64809 L
.63507 .64717 L
.62755 .6466 L
.60793 .64508 L
.5883 .64352 L
.56868 .64193 L
.54906 .64031 L
.52943 .63864 L
.50981 .63693 L
.49019 .63518 L
.47057 .63338 L
.45094 .63153 L
.43132 .62962 L
.4117 .62766 L
.41063 .62755 L
.39207 .62563 L
.37245 .62353 L
.35283 .62136 L
.3332 .6191 L
.31358 .61676 L
.29396 .61431 L
.27433 .61175 L
.25471 .60906 L
.2467 .60793 L
.23509 .60623 L
.21546 .60324 L
.19584 .60006 L
.17622 .59665 L
.15659 .59298 L
.13697 .58899 L
.13379 .5883 L
.11735 .58458 L
Mistroke
.09772 .57966 L
.0781 .57403 L
.06192 .56868 L
.05848 .56751 L
.03885 .55999 L
.03024 .56868 L
.02679 .5883 L
.02585 .60793 L
.02553 .62755 L
.02544 .64717 L
.02543 .6668 L
.02546 .68642 L
.03221 .70604 L
.02917 .72567 L
.02753 .74529 L
.02655 .76491 L
.02592 .78454 L
.0255 .80416 L
.0252 .82378 L
.02498 .84341 L
.02482 .86303 L
.0247 .88265 L
.02461 .90228 L
.02454 .9219 L
.02449 .94152 L
.02445 .96115 L
.02442 .98077 L
Mfstroke
.2 1 0 r
.98077 .33023 m
.96115 .33135 L
.94152 .33249 L
.92942 .3332 L
.9219 .33365 L
.90228 .33482 L
.88265 .33601 L
.86303 .33722 L
.84341 .33845 L
.82378 .33969 L
.80416 .34096 L
.78454 .34224 L
.76491 .34355 L
.74529 .34488 L
.72567 .34624 L
.70604 .34761 L
.68642 .34902 L
.6668 .35045 L
.64717 .35191 L
.63507 .35283 L
.62755 .3534 L
.60793 .35492 L
.5883 .35648 L
.56868 .35807 L
.54906 .35969 L
.52943 .36136 L
.50981 .36307 L
.49019 .36482 L
.47057 .36662 L
.45094 .36847 L
.43132 .37038 L
.4117 .37234 L
.41063 .37245 L
.39207 .37437 L
.37245 .37647 L
.35283 .37864 L
.3332 .3809 L
.31358 .38324 L
.29396 .38569 L
.27433 .38825 L
.25471 .39094 L
.2467 .39207 L
.23509 .39377 L
.21546 .39676 L
.19584 .39994 L
.17622 .40335 L
.15659 .40702 L
.13697 .41101 L
.13379 .4117 L
.11735 .41542 L
.09772 .42034 L
.0781 .42597 L
.06192 .43132 L
.05848 .43249 L
.03885 .44001 L
.03024 .43132 L
.02679 .4117 L
.02585 .39207 L
.02553 .37245 L
.02544 .35283 L
.02543 .3332 L
.02546 .31358 L
.03221 .29396 L
.02917 .27433 L
.02753 .25471 L
.02655 .23509 L
.02592 .21546 L
.0255 .19584 L
.0252 .17622 L
.02498 .15659 L
.02482 .13697 L
.0247 .11735 L
.02461 .09772 L
.02454 .0781 L
.02449 .05848 L
.02445 .03885 L
.02442 .01923 L
.98077 .01923 L
F
0 g
.98077 .33023 m
.96115 .33135 L
.94152 .33249 L
.92942 .3332 L
.9219 .33365 L
.90228 .33482 L
.88265 .33601 L
.86303 .33722 L
.84341 .33845 L
.82378 .33969 L
.80416 .34096 L
.78454 .34224 L
.76491 .34355 L
.74529 .34488 L
.72567 .34624 L
.70604 .34761 L
.68642 .34902 L
.6668 .35045 L
.64717 .35191 L
.63507 .35283 L
.62755 .3534 L
.60793 .35492 L
.5883 .35648 L
.56868 .35807 L
.54906 .35969 L
.52943 .36136 L
.50981 .36307 L
.49019 .36482 L
.47057 .36662 L
.45094 .36847 L
.43132 .37038 L
.4117 .37234 L
.41063 .37245 L
.39207 .37437 L
.37245 .37647 L
.35283 .37864 L
.3332 .3809 L
.31358 .38324 L
.29396 .38569 L
.27433 .38825 L
.25471 .39094 L
.2467 .39207 L
.23509 .39377 L
.21546 .39676 L
.19584 .39994 L
.17622 .40335 L
.15659 .40702 L
.13697 .41101 L
.13379 .4117 L
.11735 .41542 L
Mistroke
.09772 .42034 L
.0781 .42597 L
.06192 .43132 L
.05848 .43249 L
.03885 .44001 L
.03024 .43132 L
.02679 .4117 L
.02585 .39207 L
.02553 .37245 L
.02544 .35283 L
.02543 .3332 L
.02546 .31358 L
.03221 .29396 L
.02917 .27433 L
.02753 .25471 L
.02655 .23509 L
.02592 .21546 L
.0255 .19584 L
.0252 .17622 L
.02498 .15659 L
.02482 .13697 L
.0247 .11735 L
.02461 .09772 L
.02454 .0781 L
.02449 .05848 L
.02445 .03885 L
.02442 .01923 L
Mfstroke
.5 0 1 r
.98077 .72039 m
.96115 .71896 L
.94152 .71751 L
.9219 .71604 L
.90228 .71455 L
.88265 .71304 L
.86303 .71151 L
.84341 .70995 L
.82378 .70837 L
.80416 .70676 L
.79547 .70604 L
.78454 .70513 L
.76491 .70347 L
.74529 .70179 L
.72567 .70007 L
.70604 .69832 L
.68642 .69655 L
.6668 .69473 L
.64717 .69289 L
.62755 .691 L
.60793 .68908 L
.5883 .68712 L
.58147 .68642 L
.56868 .68511 L
.54906 .68306 L
.52943 .68095 L
.50981 .6788 L
.49019 .67659 L
.47057 .67433 L
.45094 .672 L
.43132 .66961 L
.4117 .66714 L
.40899 .6668 L
.39207 .6646 L
.37245 .66198 L
.35283 .65926 L
.3332 .65644 L
.31358 .65352 L
.29396 .65048 L
.27433 .64731 L
.27352 .64717 L
.25471 .64399 L
.23509 .64051 L
.21546 .63684 L
.19584 .63296 L
.17622 .62884 L
.17031 .62755 L
.15659 .62445 L
.13697 .61973 L
.11735 .61464 L
.09772 .60918 L
.09386 .60793 L
.0781 .60339 L
.05848 .59812 L
.03885 .60593 L
.03838 .60793 L
.03583 .62755 L
.03493 .64717 L
.03455 .6668 L
.03439 .68642 L
.03603 .70604 L
.03516 .72567 L
.03467 .74529 L
.03437 .76491 L
.03418 .78454 L
.03405 .80416 L
.03396 .82378 L
.03389 .84341 L
.03384 .86303 L
.0338 .88265 L
.03377 .90228 L
.03375 .9219 L
.03373 .94152 L
.03372 .96115 L
.03371 .98077 L
.98077 .98077 L
F
0 g
.98077 .72039 m
.96115 .71896 L
.94152 .71751 L
.9219 .71604 L
.90228 .71455 L
.88265 .71304 L
.86303 .71151 L
.84341 .70995 L
.82378 .70837 L
.80416 .70676 L
.79547 .70604 L
.78454 .70513 L
.76491 .70347 L
.74529 .70179 L
.72567 .70007 L
.70604 .69832 L
.68642 .69655 L
.6668 .69473 L
.64717 .69289 L
.62755 .691 L
.60793 .68908 L
.5883 .68712 L
.58147 .68642 L
.56868 .68511 L
.54906 .68306 L
.52943 .68095 L
.50981 .6788 L
.49019 .67659 L
.47057 .67433 L
.45094 .672 L
.43132 .66961 L
.4117 .66714 L
.40899 .6668 L
.39207 .6646 L
.37245 .66198 L
.35283 .65926 L
.3332 .65644 L
.31358 .65352 L
.29396 .65048 L
.27433 .64731 L
.27352 .64717 L
.25471 .64399 L
.23509 .64051 L
.21546 .63684 L
.19584 .63296 L
.17622 .62884 L
.17031 .62755 L
.15659 .62445 L
.13697 .61973 L
.11735 .61464 L
Mistroke
.09772 .60918 L
.09386 .60793 L
.0781 .60339 L
.05848 .59812 L
.03885 .60593 L
.03838 .60793 L
.03583 .62755 L
.03493 .64717 L
.03455 .6668 L
.03439 .68642 L
.03603 .70604 L
.03516 .72567 L
.03467 .74529 L
.03437 .76491 L
.03418 .78454 L
.03405 .80416 L
.03396 .82378 L
.03389 .84341 L
.03384 .86303 L
.0338 .88265 L
.03377 .90228 L
.03375 .9219 L
.03373 .94152 L
.03372 .96115 L
.03371 .98077 L
Mfstroke
.5 1 0 r
.98077 .27961 m
.96115 .28104 L
.94152 .28249 L
.9219 .28396 L
.90228 .28545 L
.88265 .28696 L
.86303 .28849 L
.84341 .29005 L
.82378 .29163 L
.80416 .29324 L
.79547 .29396 L
.78454 .29487 L
.76491 .29653 L
.74529 .29821 L
.72567 .29993 L
.70604 .30168 L
.68642 .30345 L
.6668 .30527 L
.64717 .30711 L
.62755 .309 L
.60793 .31092 L
.5883 .31288 L
.58147 .31358 L
.56868 .31489 L
.54906 .31694 L
.52943 .31905 L
.50981 .3212 L
.49019 .32341 L
.47057 .32567 L
.45094 .328 L
.43132 .33039 L
.4117 .33286 L
.40899 .3332 L
.39207 .3354 L
.37245 .33802 L
.35283 .34074 L
.3332 .34356 L
.31358 .34648 L
.29396 .34952 L
.27433 .35269 L
.27352 .35283 L
.25471 .35601 L
.23509 .35949 L
.21546 .36316 L
.19584 .36704 L
.17622 .37116 L
.17031 .37245 L
.15659 .37555 L
.13697 .38027 L
.11735 .38536 L
.09772 .39082 L
.09386 .39207 L
.0781 .39661 L
.05848 .40188 L
.03885 .39407 L
.03838 .39207 L
.03583 .37245 L
.03493 .35283 L
.03455 .3332 L
.03439 .31358 L
.03603 .29396 L
.03516 .27433 L
.03467 .25471 L
.03437 .23509 L
.03418 .21546 L
.03405 .19584 L
.03396 .17622 L
.03389 .15659 L
.03384 .13697 L
.0338 .11735 L
.03377 .09772 L
.03375 .0781 L
.03373 .05848 L
.03372 .03885 L
.03371 .01923 L
.98077 .01923 L
F
0 g
.98077 .27961 m
.96115 .28104 L
.94152 .28249 L
.9219 .28396 L
.90228 .28545 L
.88265 .28696 L
.86303 .28849 L
.84341 .29005 L
.82378 .29163 L
.80416 .29324 L
.79547 .29396 L
.78454 .29487 L
.76491 .29653 L
.74529 .29821 L
.72567 .29993 L
.70604 .30168 L
.68642 .30345 L
.6668 .30527 L
.64717 .30711 L
.62755 .309 L
.60793 .31092 L
.5883 .31288 L
.58147 .31358 L
.56868 .31489 L
.54906 .31694 L
.52943 .31905 L
.50981 .3212 L
.49019 .32341 L
.47057 .32567 L
.45094 .328 L
.43132 .33039 L
.4117 .33286 L
.40899 .3332 L
.39207 .3354 L
.37245 .33802 L
.35283 .34074 L
.3332 .34356 L
.31358 .34648 L
.29396 .34952 L
.27433 .35269 L
.27352 .35283 L
.25471 .35601 L
.23509 .35949 L
.21546 .36316 L
.19584 .36704 L
.17622 .37116 L
.17031 .37245 L
.15659 .37555 L
.13697 .38027 L
.11735 .38536 L
Mistroke
.09772 .39082 L
.09386 .39207 L
.0781 .39661 L
.05848 .40188 L
.03885 .39407 L
.03838 .39207 L
.03583 .37245 L
.03493 .35283 L
.03455 .3332 L
.03439 .31358 L
.03603 .29396 L
.03516 .27433 L
.03467 .25471 L
.03437 .23509 L
.03418 .21546 L
.03405 .19584 L
.03396 .17622 L
.03389 .15659 L
.03384 .13697 L
.0338 .11735 L
.03377 .09772 L
.03375 .0781 L
.03373 .05848 L
.03372 .03885 L
.03371 .01923 L
Mfstroke
.8 0 1 r
.98077 .77272 m
.96115 .771 L
.94152 .76926 L
.9219 .76749 L
.90228 .7657 L
.89374 .76491 L
.88265 .76389 L
.86303 .76204 L
.84341 .76018 L
.82378 .75828 L
.80416 .75636 L
.78454 .7544 L
.76491 .75241 L
.74529 .7504 L
.72567 .74834 L
.70604 .74625 L
.6971 .74529 L
.68642 .74413 L
.6668 .74196 L
.64717 .73976 L
.62755 .73751 L
.60793 .73522 L
.5883 .73288 L
.56868 .73049 L
.54906 .72806 L
.53026 .72567 L
.52943 .72556 L
.50981 .72301 L
.49019 .7204 L
.47057 .71772 L
.45094 .71497 L
.43132 .71215 L
.4117 .70925 L
.39207 .70627 L
.39062 .70604 L
.37245 .70319 L
.35283 .70002 L
.3332 .69675 L
.31358 .69336 L
.29396 .68985 L
.27542 .68642 L
.27433 .68622 L
.25471 .68243 L
.23509 .6785 L
.21546 .67439 L
.19584 .67012 L
.18112 .6668 L
.17622 .66567 L
.15659 .66105 L
.13697 .65631 L
.11735 .65161 L
.09772 .64742 L
.09645 .64717 L
.0781 .64544 L
.06768 .64717 L
.05848 .65673 L
.05404 .6668 L
.05075 .68642 L
.04908 .70604 L
.04863 .72567 L
.0484 .74529 L
.04828 .76491 L
.04823 .78454 L
.0482 .80416 L
.04819 .82378 L
.04819 .84341 L
.0482 .86303 L
.0482 .88265 L
.04821 .90228 L
.04822 .9219 L
.04823 .94152 L
.04823 .96115 L
.04824 .98077 L
.98077 .98077 L
F
0 g
.98077 .77272 m
.96115 .771 L
.94152 .76926 L
.9219 .76749 L
.90228 .7657 L
.89374 .76491 L
.88265 .76389 L
.86303 .76204 L
.84341 .76018 L
.82378 .75828 L
.80416 .75636 L
.78454 .7544 L
.76491 .75241 L
.74529 .7504 L
.72567 .74834 L
.70604 .74625 L
.6971 .74529 L
.68642 .74413 L
.6668 .74196 L
.64717 .73976 L
.62755 .73751 L
.60793 .73522 L
.5883 .73288 L
.56868 .73049 L
.54906 .72806 L
.53026 .72567 L
.52943 .72556 L
.50981 .72301 L
.49019 .7204 L
.47057 .71772 L
.45094 .71497 L
.43132 .71215 L
.4117 .70925 L
.39207 .70627 L
.39062 .70604 L
.37245 .70319 L
.35283 .70002 L
.3332 .69675 L
.31358 .69336 L
.29396 .68985 L
.27542 .68642 L
.27433 .68622 L
.25471 .68243 L
.23509 .6785 L
.21546 .67439 L
.19584 .67012 L
.18112 .6668 L
.17622 .66567 L
.15659 .66105 L
.13697 .65631 L
Mistroke
.11735 .65161 L
.09772 .64742 L
.09645 .64717 L
.0781 .64544 L
.06768 .64717 L
.05848 .65673 L
.05404 .6668 L
.05075 .68642 L
.04908 .70604 L
.04863 .72567 L
.0484 .74529 L
.04828 .76491 L
.04823 .78454 L
.0482 .80416 L
.04819 .82378 L
.04819 .84341 L
.0482 .86303 L
.0482 .88265 L
.04821 .90228 L
.04822 .9219 L
.04823 .94152 L
.04823 .96115 L
.04824 .98077 L
Mfstroke
.8 1 0 r
.98077 .22728 m
.96115 .229 L
.94152 .23074 L
.9219 .23251 L
.90228 .2343 L
.89374 .23509 L
.88265 .23611 L
.86303 .23796 L
.84341 .23982 L
.82378 .24172 L
.80416 .24364 L
.78454 .2456 L
.76491 .24759 L
.74529 .2496 L
.72567 .25166 L
.70604 .25375 L
.6971 .25471 L
.68642 .25587 L
.6668 .25804 L
.64717 .26024 L
.62755 .26249 L
.60793 .26478 L
.5883 .26712 L
.56868 .26951 L
.54906 .27194 L
.53026 .27433 L
.52943 .27444 L
.50981 .27699 L
.49019 .2796 L
.47057 .28228 L
.45094 .28503 L
.43132 .28785 L
.4117 .29075 L
.39207 .29373 L
.39062 .29396 L
.37245 .29681 L
.35283 .29998 L
.3332 .30325 L
.31358 .30664 L
.29396 .31015 L
.27542 .31358 L
.27433 .31378 L
.25471 .31757 L
.23509 .3215 L
.21546 .32561 L
.19584 .32988 L
.18112 .3332 L
.17622 .33433 L
.15659 .33895 L
.13697 .34369 L
.11735 .34839 L
.09772 .35258 L
.09645 .35283 L
.0781 .35456 L
.06768 .35283 L
.05848 .34327 L
.05404 .3332 L
.05075 .31358 L
.04908 .29396 L
.04863 .27433 L
.0484 .25471 L
.04828 .23509 L
.04823 .21546 L
.0482 .19584 L
.04819 .17622 L
.04819 .15659 L
.0482 .13697 L
.0482 .11735 L
.04821 .09772 L
.04822 .0781 L
.04823 .05848 L
.04823 .03885 L
.04824 .01923 L
.98077 .01923 L
F
0 g
.98077 .22728 m
.96115 .229 L
.94152 .23074 L
.9219 .23251 L
.90228 .2343 L
.89374 .23509 L
.88265 .23611 L
.86303 .23796 L
.84341 .23982 L
.82378 .24172 L
.80416 .24364 L
.78454 .2456 L
.76491 .24759 L
.74529 .2496 L
.72567 .25166 L
.70604 .25375 L
.6971 .25471 L
.68642 .25587 L
.6668 .25804 L
.64717 .26024 L
.62755 .26249 L
.60793 .26478 L
.5883 .26712 L
.56868 .26951 L
.54906 .27194 L
.53026 .27433 L
.52943 .27444 L
.50981 .27699 L
.49019 .2796 L
.47057 .28228 L
.45094 .28503 L
.43132 .28785 L
.4117 .29075 L
.39207 .29373 L
.39062 .29396 L
.37245 .29681 L
.35283 .29998 L
.3332 .30325 L
.31358 .30664 L
.29396 .31015 L
.27542 .31358 L
.27433 .31378 L
.25471 .31757 L
.23509 .3215 L
.21546 .32561 L
.19584 .32988 L
.18112 .3332 L
.17622 .33433 L
.15659 .33895 L
.13697 .34369 L
Mistroke
.11735 .34839 L
.09772 .35258 L
.09645 .35283 L
.0781 .35456 L
.06768 .35283 L
.05848 .34327 L
.05404 .3332 L
.05075 .31358 L
.04908 .29396 L
.04863 .27433 L
.0484 .25471 L
.04828 .23509 L
.04823 .21546 L
.0482 .19584 L
.04819 .17622 L
.04819 .15659 L
.0482 .13697 L
.0482 .11735 L
.04821 .09772 L
.04822 .0781 L
.04823 .05848 L
.04823 .03885 L
.04824 .01923 L
Mfstroke
1 0 .9 r
.98077 .8273 m
.96115 .82532 L
.94617 .82378 L
.94152 .8233 L
.9219 .82127 L
.90228 .8192 L
.88265 .81711 L
.86303 .81499 L
.84341 .81284 L
.82378 .81066 L
.80416 .80845 L
.78454 .8062 L
.76695 .80416 L
.76491 .80392 L
.74529 .80161 L
.72567 .79925 L
.70604 .79686 L
.68642 .79443 L
.6668 .79196 L
.64717 .78945 L
.62755 .78689 L
.60985 .78454 L
.60793 .78428 L
.5883 .78162 L
.56868 .77892 L
.54906 .77615 L
.52943 .77334 L
.50981 .77046 L
.49019 .76752 L
.47313 .76491 L
.47057 .76452 L
.45094 .76144 L
.43132 .7583 L
.4117 .75508 L
.39207 .75179 L
.37245 .74841 L
.35477 .74529 L
.35283 .74494 L
.3332 .74139 L
.31358 .73775 L
.29396 .73401 L
.27433 .73019 L
.25471 .72628 L
.25166 .72567 L
.23509 .7223 L
.21546 .71828 L
.19584 .71428 L
.17622 .71039 L
.15659 .70683 L
.15181 .70604 L
.13697 .70405 L
.11735 .70318 L
.10166 .70604 L
.09772 .70788 L
.0815 .72567 L
.0781 .74006 L
.07691 .74529 L
.07394 .76491 L
.07228 .78454 L
.07127 .80416 L
.07062 .82378 L
.07019 .84341 L
.06989 .86303 L
.06969 .88265 L
.06955 .90228 L
.06945 .9219 L
.06939 .94152 L
.06934 .96115 L
.0693 .98077 L
.98077 .98077 L
F
0 g
.98077 .8273 m
.96115 .82532 L
.94617 .82378 L
.94152 .8233 L
.9219 .82127 L
.90228 .8192 L
.88265 .81711 L
.86303 .81499 L
.84341 .81284 L
.82378 .81066 L
.80416 .80845 L
.78454 .8062 L
.76695 .80416 L
.76491 .80392 L
.74529 .80161 L
.72567 .79925 L
.70604 .79686 L
.68642 .79443 L
.6668 .79196 L
.64717 .78945 L
.62755 .78689 L
.60985 .78454 L
.60793 .78428 L
.5883 .78162 L
.56868 .77892 L
.54906 .77615 L
.52943 .77334 L
.50981 .77046 L
.49019 .76752 L
.47313 .76491 L
.47057 .76452 L
.45094 .76144 L
.43132 .7583 L
.4117 .75508 L
.39207 .75179 L
.37245 .74841 L
.35477 .74529 L
.35283 .74494 L
.3332 .74139 L
.31358 .73775 L
.29396 .73401 L
.27433 .73019 L
.25471 .72628 L
.25166 .72567 L
.23509 .7223 L
.21546 .71828 L
.19584 .71428 L
.17622 .71039 L
.15659 .70683 L
.15181 .70604 L
Mistroke
.13697 .70405 L
.11735 .70318 L
.10166 .70604 L
.09772 .70788 L
.0815 .72567 L
.0781 .74006 L
.07691 .74529 L
.07394 .76491 L
.07228 .78454 L
.07127 .80416 L
.07062 .82378 L
.07019 .84341 L
.06989 .86303 L
.06969 .88265 L
.06955 .90228 L
.06945 .9219 L
.06939 .94152 L
.06934 .96115 L
.0693 .98077 L
Mfstroke
1 .9 0 r
.98077 .1727 m
.96115 .17468 L
.94617 .17622 L
.94152 .1767 L
.9219 .17873 L
.90228 .1808 L
.88265 .18289 L
.86303 .18501 L
.84341 .18716 L
.82378 .18934 L
.80416 .19155 L
.78454 .1938 L
.76695 .19584 L
.76491 .19608 L
.74529 .19839 L
.72567 .20075 L
.70604 .20314 L
.68642 .20557 L
.6668 .20804 L
.64717 .21055 L
.62755 .21311 L
.60985 .21546 L
.60793 .21572 L
.5883 .21838 L
.56868 .22108 L
.54906 .22385 L
.52943 .22666 L
.50981 .22954 L
.49019 .23248 L
.47313 .23509 L
.47057 .23548 L
.45094 .23856 L
.43132 .2417 L
.4117 .24492 L
.39207 .24821 L
.37245 .25159 L
.35477 .25471 L
.35283 .25506 L
.3332 .25861 L
.31358 .26225 L
.29396 .26599 L
.27433 .26981 L
.25471 .27372 L
.25166 .27433 L
.23509 .2777 L
.21546 .28172 L
.19584 .28572 L
.17622 .28961 L
.15659 .29317 L
.15181 .29396 L
.13697 .29595 L
.11735 .29682 L
.10166 .29396 L
.09772 .29212 L
.0815 .27433 L
.0781 .25994 L
.07691 .25471 L
.07394 .23509 L
.07228 .21546 L
.07127 .19584 L
.07062 .17622 L
.07019 .15659 L
.06989 .13697 L
.06969 .11735 L
.06955 .09772 L
.06945 .0781 L
.06939 .05848 L
.06934 .03885 L
.0693 .01923 L
.98077 .01923 L
F
0 g
.98077 .1727 m
.96115 .17468 L
.94617 .17622 L
.94152 .1767 L
.9219 .17873 L
.90228 .1808 L
.88265 .18289 L
.86303 .18501 L
.84341 .18716 L
.82378 .18934 L
.80416 .19155 L
.78454 .1938 L
.76695 .19584 L
.76491 .19608 L
.74529 .19839 L
.72567 .20075 L
.70604 .20314 L
.68642 .20557 L
.6668 .20804 L
.64717 .21055 L
.62755 .21311 L
.60985 .21546 L
.60793 .21572 L
.5883 .21838 L
.56868 .22108 L
.54906 .22385 L
.52943 .22666 L
.50981 .22954 L
.49019 .23248 L
.47313 .23509 L
.47057 .23548 L
.45094 .23856 L
.43132 .2417 L
.4117 .24492 L
.39207 .24821 L
.37245 .25159 L
.35477 .25471 L
.35283 .25506 L
.3332 .25861 L
.31358 .26225 L
.29396 .26599 L
.27433 .26981 L
.25471 .27372 L
.25166 .27433 L
.23509 .2777 L
.21546 .28172 L
.19584 .28572 L
.17622 .28961 L
.15659 .29317 L
.15181 .29396 L
Mistroke
.13697 .29595 L
.11735 .29682 L
.10166 .29396 L
.09772 .29212 L
.0815 .27433 L
.0781 .25994 L
.07691 .25471 L
.07394 .23509 L
.07228 .21546 L
.07127 .19584 L
.07062 .17622 L
.07019 .15659 L
.06989 .13697 L
.06969 .11735 L
.06955 .09772 L
.06945 .0781 L
.06939 .05848 L
.06934 .03885 L
.0693 .01923 L
Mfstroke
1 0 .6 r
.98077 .88482 m
.96162 .88265 L
.96115 .8826 L
.94152 .88035 L
.9219 .87808 L
.90228 .87578 L
.88265 .87346 L
.86303 .8711 L
.84341 .86871 L
.82378 .86629 L
.80416 .86384 L
.79775 .86303 L
.78454 .86135 L
.76491 .85883 L
.74529 .85628 L
.72567 .85369 L
.70604 .85106 L
.68642 .84839 L
.6668 .84568 L
.65055 .84341 L
.64717 .84293 L
.62755 .84014 L
.60793 .8373 L
.5883 .83442 L
.56868 .83149 L
.54906 .82851 L
.52943 .82549 L
.51851 .82378 L
.50981 .82241 L
.49019 .81929 L
.47057 .81611 L
.45094 .81288 L
.43132 .8096 L
.4117 .80627 L
.39941 .80416 L
.39207 .80289 L
.37245 .79947 L
.35283 .79602 L
.3332 .79254 L
.31358 .78905 L
.29396 .78558 L
.28799 .78454 L
.27433 .78217 L
.25471 .77889 L
.23509 .77582 L
.21546 .77314 L
.19584 .77115 L
.17622 .7704 L
.15659 .77209 L
.13697 .77923 L
.12946 .78454 L
.11735 .80271 L
.11668 .80416 L
.11019 .82378 L
.10645 .84341 L
.10404 .86303 L
.10239 .88265 L
.10123 .90228 L
.10038 .9219 L
.09975 .94152 L
.09929 .96115 L
.09893 .98077 L
.98077 .98077 L
F
0 g
.98077 .88482 m
.96162 .88265 L
.96115 .8826 L
.94152 .88035 L
.9219 .87808 L
.90228 .87578 L
.88265 .87346 L
.86303 .8711 L
.84341 .86871 L
.82378 .86629 L
.80416 .86384 L
.79775 .86303 L
.78454 .86135 L
.76491 .85883 L
.74529 .85628 L
.72567 .85369 L
.70604 .85106 L
.68642 .84839 L
.6668 .84568 L
.65055 .84341 L
.64717 .84293 L
.62755 .84014 L
.60793 .8373 L
.5883 .83442 L
.56868 .83149 L
.54906 .82851 L
.52943 .82549 L
.51851 .82378 L
.50981 .82241 L
.49019 .81929 L
.47057 .81611 L
.45094 .81288 L
.43132 .8096 L
.4117 .80627 L
.39941 .80416 L
.39207 .80289 L
.37245 .79947 L
.35283 .79602 L
.3332 .79254 L
.31358 .78905 L
.29396 .78558 L
.28799 .78454 L
.27433 .78217 L
.25471 .77889 L
.23509 .77582 L
.21546 .77314 L
.19584 .77115 L
.17622 .7704 L
.15659 .77209 L
.13697 .77923 L
Mistroke
.12946 .78454 L
.11735 .80271 L
.11668 .80416 L
.11019 .82378 L
.10645 .84341 L
.10404 .86303 L
.10239 .88265 L
.10123 .90228 L
.10038 .9219 L
.09975 .94152 L
.09929 .96115 L
.09893 .98077 L
Mfstroke
1 .6 0 r
.98077 .11518 m
.96162 .11735 L
.96115 .1174 L
.94152 .11965 L
.9219 .12192 L
.90228 .12422 L
.88265 .12654 L
.86303 .1289 L
.84341 .13129 L
.82378 .13371 L
.80416 .13616 L
.79775 .13697 L
.78454 .13865 L
.76491 .14117 L
.74529 .14372 L
.72567 .14631 L
.70604 .14894 L
.68642 .15161 L
.6668 .15432 L
.65055 .15659 L
.64717 .15707 L
.62755 .15986 L
.60793 .1627 L
.5883 .16558 L
.56868 .16851 L
.54906 .17149 L
.52943 .17451 L
.51851 .17622 L
.50981 .17759 L
.49019 .18071 L
.47057 .18389 L
.45094 .18712 L
.43132 .1904 L
.4117 .19373 L
.39941 .19584 L
.39207 .19711 L
.37245 .20053 L
.35283 .20398 L
.3332 .20746 L
.31358 .21095 L
.29396 .21442 L
.28799 .21546 L
.27433 .21783 L
.25471 .22111 L
.23509 .22418 L
.21546 .22686 L
.19584 .22885 L
.17622 .2296 L
.15659 .22791 L
.13697 .22077 L
.12946 .21546 L
.11735 .19729 L
.11668 .19584 L
.11019 .17622 L
.10645 .15659 L
.10404 .13697 L
.10239 .11735 L
.10123 .09772 L
.10038 .0781 L
.09975 .05848 L
.09929 .03885 L
.09893 .01923 L
.98077 .01923 L
F
0 g
.98077 .11518 m
.96162 .11735 L
.96115 .1174 L
.94152 .11965 L
.9219 .12192 L
.90228 .12422 L
.88265 .12654 L
.86303 .1289 L
.84341 .13129 L
.82378 .13371 L
.80416 .13616 L
.79775 .13697 L
.78454 .13865 L
.76491 .14117 L
.74529 .14372 L
.72567 .14631 L
.70604 .14894 L
.68642 .15161 L
.6668 .15432 L
.65055 .15659 L
.64717 .15707 L
.62755 .15986 L
.60793 .1627 L
.5883 .16558 L
.56868 .16851 L
.54906 .17149 L
.52943 .17451 L
.51851 .17622 L
.50981 .17759 L
.49019 .18071 L
.47057 .18389 L
.45094 .18712 L
.43132 .1904 L
.4117 .19373 L
.39941 .19584 L
.39207 .19711 L
.37245 .20053 L
.35283 .20398 L
.3332 .20746 L
.31358 .21095 L
.29396 .21442 L
.28799 .21546 L
.27433 .21783 L
.25471 .22111 L
.23509 .22418 L
.21546 .22686 L
.19584 .22885 L
.17622 .2296 L
.15659 .22791 L
.13697 .22077 L
Mistroke
.12946 .21546 L
.11735 .19729 L
.11668 .19584 L
.11019 .17622 L
.10645 .15659 L
.10404 .13697 L
.10239 .11735 L
.10123 .09772 L
.10038 .0781 L
.09975 .05848 L
.09929 .03885 L
.09893 .01923 L
Mfstroke
1 0 .3 r
.98077 .94613 m
.96115 .94374 L
.94322 .94152 L
.94152 .94131 L
.9219 .93886 L
.90228 .93639 L
.88265 .93389 L
.86303 .93136 L
.84341 .9288 L
.82378 .92621 L
.80416 .9236 L
.79153 .9219 L
.78454 .92095 L
.76491 .91828 L
.74529 .91558 L
.72567 .91284 L
.70604 .91007 L
.68642 .90728 L
.6668 .90445 L
.65188 .90228 L
.64717 .90159 L
.62755 .8987 L
.60793 .89578 L
.5883 .89283 L
.56868 .88985 L
.54906 .88684 L
.52943 .88381 L
.52196 .88265 L
.50981 .88076 L
.49019 .8777 L
.47057 .87462 L
.45094 .87155 L
.43132 .86848 L
.4117 .86544 L
.39596 .86303 L
.39207 .86244 L
.37245 .85952 L
.35283 .8567 L
.3332 .85405 L
.31358 .85164 L
.29396 .84959 L
.27433 .84806 L
.25471 .84733 L
.23509 .84786 L
.21546 .85046 L
.19584 .85678 L
.18485 .86303 L
.17622 .87074 L
.16693 .88265 L
.15763 .90228 L
.15659 .90522 L
.15173 .9219 L
.14772 .94152 L
.14486 .96115 L
.14274 .98077 L
.98077 .98077 L
F
0 g
.98077 .94613 m
.96115 .94374 L
.94322 .94152 L
.94152 .94131 L
.9219 .93886 L
.90228 .93639 L
.88265 .93389 L
.86303 .93136 L
.84341 .9288 L
.82378 .92621 L
.80416 .9236 L
.79153 .9219 L
.78454 .92095 L
.76491 .91828 L
.74529 .91558 L
.72567 .91284 L
.70604 .91007 L
.68642 .90728 L
.6668 .90445 L
.65188 .90228 L
.64717 .90159 L
.62755 .8987 L
.60793 .89578 L
.5883 .89283 L
.56868 .88985 L
.54906 .88684 L
.52943 .88381 L
.52196 .88265 L
.50981 .88076 L
.49019 .8777 L
.47057 .87462 L
.45094 .87155 L
.43132 .86848 L
.4117 .86544 L
.39596 .86303 L
.39207 .86244 L
.37245 .85952 L
.35283 .8567 L
.3332 .85405 L
.31358 .85164 L
.29396 .84959 L
.27433 .84806 L
.25471 .84733 L
.23509 .84786 L
.21546 .85046 L
.19584 .85678 L
.18485 .86303 L
.17622 .87074 L
.16693 .88265 L
.15763 .90228 L
Mistroke
.15659 .90522 L
.15173 .9219 L
.14772 .94152 L
.14486 .96115 L
.14274 .98077 L
Mfstroke
1 .3 0 r
.98077 .05387 m
.96115 .05626 L
.94322 .05848 L
.94152 .05869 L
.9219 .06114 L
.90228 .06361 L
.88265 .06611 L
.86303 .06864 L
.84341 .0712 L
.82378 .07379 L
.80416 .0764 L
.79153 .0781 L
.78454 .07905 L
.76491 .08172 L
.74529 .08442 L
.72567 .08716 L
.70604 .08993 L
.68642 .09272 L
.6668 .09555 L
.65188 .09772 L
.64717 .09841 L
.62755 .1013 L
.60793 .10422 L
.5883 .10717 L
.56868 .11015 L
.54906 .11316 L
.52943 .11619 L
.52196 .11735 L
.50981 .11924 L
.49019 .1223 L
.47057 .12538 L
.45094 .12845 L
.43132 .13152 L
.4117 .13456 L
.39596 .13697 L
.39207 .13756 L
.37245 .14048 L
.35283 .1433 L
.3332 .14595 L
.31358 .14836 L
.29396 .15041 L
.27433 .15194 L
.25471 .15267 L
.23509 .15214 L
.21546 .14954 L
.19584 .14322 L
.18485 .13697 L
.17622 .12926 L
.16693 .11735 L
.15763 .09772 L
.15659 .09478 L
.15173 .0781 L
.14772 .05848 L
.14486 .03885 L
.14274 .01923 L
.98077 .01923 L
F
0 g
.98077 .05387 m
.96115 .05626 L
.94322 .05848 L
.94152 .05869 L
.9219 .06114 L
.90228 .06361 L
.88265 .06611 L
.86303 .06864 L
.84341 .0712 L
.82378 .07379 L
.80416 .0764 L
.79153 .0781 L
.78454 .07905 L
.76491 .08172 L
.74529 .08442 L
.72567 .08716 L
.70604 .08993 L
.68642 .09272 L
.6668 .09555 L
.65188 .09772 L
.64717 .09841 L
.62755 .1013 L
.60793 .10422 L
.5883 .10717 L
.56868 .11015 L
.54906 .11316 L
.52943 .11619 L
.52196 .11735 L
.50981 .11924 L
.49019 .1223 L
.47057 .12538 L
.45094 .12845 L
.43132 .13152 L
.4117 .13456 L
.39596 .13697 L
.39207 .13756 L
.37245 .14048 L
.35283 .1433 L
.3332 .14595 L
.31358 .14836 L
.29396 .15041 L
.27433 .15194 L
.25471 .15267 L
.23509 .15214 L
.21546 .14954 L
.19584 .14322 L
.18485 .13697 L
.17622 .12926 L
.16693 .11735 L
.15763 .09772 L
Mistroke
.15659 .09478 L
.15173 .0781 L
.14772 .05848 L
.14486 .03885 L
.14274 .01923 L
Mfstroke
1 0 0 r
.74244 .98077 m
.72567 .97845 L
.70604 .97571 L
.68642 .97297 L
.6668 .97023 L
.64717 .96747 L
.62755 .96472 L
.60793 .96197 L
.60201 .96115 L
.5883 .95924 L
.56868 .95652 L
.54906 .95383 L
.52943 .95118 L
.50981 .94859 L
.49019 .94607 L
.47057 .94365 L
.45241 .94152 L
.45094 .94136 L
.43132 .93924 L
.4117 .93735 L
.39207 .93575 L
.37245 .93456 L
.35283 .93391 L
.3332 .93401 L
.31358 .93516 L
.29396 .93787 L
.27854 .94152 L
.27433 .94293 L
.25471 .95185 L
.24179 .96115 L
.23509 .96773 L
.22494 .98077 L
F
0 g
.74244 .98077 m
.72567 .97845 L
.70604 .97571 L
.68642 .97297 L
.6668 .97023 L
.64717 .96747 L
.62755 .96472 L
.60793 .96197 L
.60201 .96115 L
.5883 .95924 L
.56868 .95652 L
.54906 .95383 L
.52943 .95118 L
.50981 .94859 L
.49019 .94607 L
.47057 .94365 L
.45241 .94152 L
.45094 .94136 L
.43132 .93924 L
.4117 .93735 L
.39207 .93575 L
.37245 .93456 L
.35283 .93391 L
.3332 .93401 L
.31358 .93516 L
.29396 .93787 L
.27854 .94152 L
.27433 .94293 L
.25471 .95185 L
.24179 .96115 L
.23509 .96773 L
.22494 .98077 L
s
1 0 0 r
.74244 .01923 m
.72567 .02155 L
.70604 .02429 L
.68642 .02703 L
.6668 .02977 L
.64717 .03253 L
.62755 .03528 L
.60793 .03803 L
.60201 .03885 L
.5883 .04076 L
.56868 .04348 L
.54906 .04617 L
.52943 .04882 L
.50981 .05141 L
.49019 .05393 L
.47057 .05635 L
.45241 .05848 L
.45094 .05864 L
.43132 .06076 L
.4117 .06265 L
.39207 .06425 L
.37245 .06544 L
.35283 .06609 L
.3332 .06599 L
.31358 .06484 L
.29396 .06213 L
.27854 .05848 L
.27433 .05707 L
.25471 .04815 L
.24179 .03885 L
.23509 .03227 L
.22494 .01923 L
F
0 g
.74244 .01923 m
.72567 .02155 L
.70604 .02429 L
.68642 .02703 L
.6668 .02977 L
.64717 .03253 L
.62755 .03528 L
.60793 .03803 L
.60201 .03885 L
.5883 .04076 L
.56868 .04348 L
.54906 .04617 L
.52943 .04882 L
.50981 .05141 L
.49019 .05393 L
.47057 .05635 L
.45241 .05848 L
.45094 .05864 L
.43132 .06076 L
.4117 .06265 L
.39207 .06425 L
.37245 .06544 L
.35283 .06609 L
.3332 .06599 L
.31358 .06484 L
.29396 .06213 L
.27854 .05848 L
.27433 .05707 L
.25471 .04815 L
.24179 .03885 L
.23509 .03227 L
.22494 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{218, 218},
  ImageMargins->{{68.625, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@000141000`40O003h00O57oo10006Woo1000
1Goo0P001Goo10006Goo1@006Goo1@0017oo0P001Goo100067oo1@006Goo1@001Goo0P001Goo1000
6Goo0`0067oo000COol00`00Oomoo`02Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02
Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0HOol00`00Oomoo`0KOol00`00Oomoo`04Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0EOol01@00Oomoogoo00006Goo00D007ooOomoo`0000Eoo`80
00Aoo`03001oogoo009oo`03001oogoo01Eoo`05001oogooOol0000GOol001=oo`03001oogoo009o
o`03001oogoo01Ioo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01Qoo`03001oogoo01]o
o`03001oogoo00moo`03001oogoo01Ioo`03001oogoo01]oo`03001oogoo015oo`03001oogoo01Uo
o`03001oogoo01Eoo`004goo00<007ooOol00Woo00<007ooOol05Woo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol067oo00<007ooOol06goo00<007ooOol03goo00<007ooOol05goo00<007oo
Ool06goo00<007ooOol047oo00<007ooOol06Goo00<007ooOol05Goo000COol00`00Oomoo`02Ool0
0`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`09Ool4000KOol00`00Oomoo`0KOol00`00Oomo
o`0;Ool4000KOol00`00Oomoo`0KOol00`00Oomoo`0;Ool4000JOol2000HOol001=oo`03001oogoo
009oo`03001oogoo01Ioo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01aoo`03001oogoo
01]oo`03001oogoo00]oo`03001oogoo01eoo`03001oogoo01]oo`03001oogoo00Yoo`03001oogoo
01eoo`03001oogoo01Eoo`004goo00<007ooOol00Woo00<007ooOol05Woo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol06Woo0`006goo0`003Goo00<007ooOol06Goo00D007ooOomoo`0001Uo
o`05001oogooOol0000<Ool00`00Oomoo`0IOol01@00Oomoogoo00005goo000DOol4000JOol4000<
Ool5000JOol00`00Oomoo`0KOol00`00Oomoo`0;Ool5000HOol3000KOol3000=Ool5000HOol3000H
Ool00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00ogoo1Woo0P000Woo0P001Goo003oOol7
Ool01000Oomoo`001Woo000COooY000;Ool20007Ool001=oo`04001oogoo0007Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool01@00Oomoogoo00002goo0P001goo
000:Ool30006Ool01000Oomoo`009Goo00<007ooOol08Woo00<007ooOol08goo00<007ooOol08Woo
00<007ooOol08goo00<007ooOol08Woo00D007ooOomoo`0000Yoo`04001oogoo0006Ool000Uoo`05
001oogooOol00005Ool00`00Oomoo`3UOol00`00Oomoo`07Ool20002Ool20005Ool000eoo`03001o
ogoo00=oo`03001oogoo0>Eoo`03001oogoo019oo`0000=oo`00000010001Woo00<007ooOol00goo
0P000goo00@007ooOol0009oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Moo`03001o
ogoo011oo`03001oogoo071oo`H003Yoo`8001Aoo`002goo0P001Woo00H007ooOomoo`?R00025n00
2@00?n0oh000In1Sh6OPHn000006Oh000`00OT1n@007OT005@00OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB00001XO0090000?Gd0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d000Aoo`03001oogoo019oo`003Goo00<007ooOol0
0goo01P007ooOomoo`?R000Gh1_P000oh3_P001Sh6OPHn1Wh000Oh1oH7n0Of1oP7mP0003OT006giP
OT1n@7i0OV1n@000O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@00001SO0050000
AWd0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dP17oo00<007ooOol04Woo0009Ool01@00Oomoogoo00001Goo00T0
07ooOomoo`?R000Kh1OP00000SoP00H006OPHn1Wh6?P0006Oh000`00OT1n@007OT005@00OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m0002001HO0090000Bgd0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m0004Ool00`00Oomoo`0BOol000Yoo`<000Ioo`09001oogooOol3hP005n0K
h000008oh00?001Sh6OPHn1Wh000Oh1oH7n0Of1oP7mP001n@7iP00=n@00LOV1n@7i0OT0007d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP001BO0050000E7d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m80Aoo`03001oogoo019oo`004goo00H0
07ooOomoo`?R00025n002@00?n0oh000In1Sh6OPHn000006Oh000`00OT1n@007OT006000OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m808004Ml00T0001IO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m0004Ool00`00Oomo
o`0BOol001=oo`0H001oogooOol3hP005n0Kh000?n0kh000Hn1Wh6?PIn0007n0Of1oP7mPOh1oH000
0gi0021nH7i0OT1n@7iPOT0007d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d00P00@G`01000069m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP17oo00<007ooOol04Woo000COol20002
Ool01@?R000Kh1OP00000SoP00H006OPHn1Wh6?P0006Oh000`00OT1n@008OT006`00O@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m8002000fO0090000IWdPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m00Aoo`03001oogoo019oo`004goo00T007ooOomoo`?R000Gh1_P0000
0SoP00l006?PIn1Sh6OP001oP7mPOh1oH7n0Of0007i0OV000gi0029nH7i0OT1n@7iP001m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m008002]l00T0001Y
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP00L000=oo`03001oogoo019oo`004goo00H007oo
Oomoo`?R00025n002@00?n0oh000In1Sh6OPHn000006Oh000`00OT1n@008OT007P00O@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m00<001ml00X0001Y
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP00T000In@0Aoo`03001oogoo019oo`004goo01P0
07ooOomoo`?R000Gh1_P000oh3_P001Sh6OPHn1Wh000Oh1oH7n0Of1oP7mP0003OT001GiPOT1n@7i0
OV000Wi0024007dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@002@002G`03@0006im07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dP1@000Wi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH004Ool00`00Oomoo`0BOol001=o
o`09001oogooOol3hP006n0Gh000008oh006001Wh6?PIn1Sh0001Wn000<007i0OT0027i002X007d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@090000LWd0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m80T001An@0Aoo`03001oogoo019oo`004goo00T007ooOomoo`?R000Gh1_P0000
0SoP00l006?PIn1Sh6OP001oP7mPOh1oH7n0Of0007i0OV000gi00:5nH7i0OT1n@7iPOT0007d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dP00T0009n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@003
OV1n@7i000Aoo`03001oogoo019oo`004goo00H007ooOomoo`?R00025n002@00?n0oh000In1Sh6OP
Hn000006Oh000`00OT1n@009OT00U@00OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@001P009Wi017oo00<007ooOol04Woo000COol06000Oomoogoo0n80
01OP6n0003oP>n0006?PIn1Sh6OP001oP7mPOh1oH7n0Of0000=n@005OV1n@7i0OT1nH003OT00S@00
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m80080003OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n
@7iP00=n@003OV1oogoo009oo`03001oogoo019oo`004goo0P000Woo00D3hP006n0Gh000008oh006
001Wh6?PIn1Sh0001Wn000<007i0OT002Gi008@007dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB09000dOT04
Ool00`00Oomoo`0BOol001=oo`09001oogooOol3hP005n0Kh000008oh00?001Sh6OPHn1Wh000Oh1o
H7n0Of1oP7mP001n@7iP00=n@005OV1n@7i0OT1nH002OT00OP00OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m80D0009n@005OV1n
@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT00
1GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT000giPOT1n@004Ool0
0`00Oomoo`0BOol001=oo`06001oogooOol3hP000QOP00T003oP?n0006OPHn1Wh6?P00001Wn000<0
07i0OT002Wi007H007d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m
87d0OB1m00P0049n@0Aoo`03001oogoo019oo`004goo01P007ooOomoo`?R000Gh1_P000oh3_P001S
h6OPHn1Wh000Oh1oH7n0Of1oP7mP0003OT001GiPOT1n@7i0OV000gi0079nH000OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@0500000gi0OV1n@002OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n
@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n
@7i0OT1nH004Ool00`00Oomoo`0BOol001=oo`09001oogooOol3hP006n0Gh000008oh006001Wh6?P
In1Sh0001Wn000<007i0OT002gi006L007dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m0009001?OT04Ool0
0`00Oomoo`0BOol001=oo`09001oogooOol3hP005n0Kh000008oh00?001Sh6OPHn1Wh000Oh1oH7n0
Of1oP7mP001n@7iP00=n@005OV1n@7i0OT1nH003OT00HP00O@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@0500000gi0OV1n
@002OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n
@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000=nH7i0OT0017oo00<0
07ooOol04Woo000COol01P00Oomoogoo0n80008Gh009000oh3oP001Wh6?PIn1Sh00000IoP003001n
@7i000an@01H001m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@09001MOT04Ool00`00Oomoo`0BOol001=oo`80009oo`0D0n8001OP6n0003oP>n0006?PIn1S
h6OP001oP7mPOh1oH7n0Of0000=n@005OV1n@7i0OT1nH003OT00EGiPOT1n@7i0001m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP00H00003OT1nH7i0009n@005OV1n@7i0OT1nH003
OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0
OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0
OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000=nH7i0OT001`000goo00<0
07ooOol04Woo000COol02@00Oomoogoo0n8001_P5n000002?n001P00In1Sh6OPHn0000IoP003001n
@7i000in@01=001m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m8003001QOT050006Oh04Ool0
0`00Oomoo`0BOol001=oo`09001oogooOol3hP005n0Kh000008oh00?001Sh6OPHn1Wh000Oh1oH7n0
Of1oP7mP001n@7iP00=n@005OV1n@7i0OT1nH003OT00AgiPOT1n@000OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB002@00
00EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP
00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0
OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT000giP
OT1n@00900002gn0Of1oP7mPOh1oH7n0Of1oP7mPOh0017oo00<007ooOol04Woo000COol01P00Oomo
ogoo0n80008Gh009000oh3oP001Wh6?PIn1Sh00000MoP003001n@7i000in@00n001m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP
O@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m80D005]n@0T0
01AoP0Aoo`03001oogoo019oo`004goo01T007ooOomoo`?R000Gh1_P000oh3_P001Sh6OPHn1Wh000
Oh1oH7n0Of1oP7mPOh000002OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP009n@00d001m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB0900001GiPOT1n@7i0OV000gi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n
@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1n
H003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP009n@0T0000MOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP004Ool00`00Oomoo`0BOol001=o
o`09001oogooOol3hP006n0Gh000008oh006001Wh6?PIn1Sh0001gn000<007i0OT0047i00P0002am
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dP1@00Egi02@009Wn017oo00<007ooOol04Woo000COol0
2@00Oomoogoo0n8001OP6n000002?n003`00Hn1Wh6?PIn0007n0Of1oP7mPOh1oH7n0001nH003OT00
1GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@080000VOB1m07dPO@1m87d0OB1m07dPO@1m87d0
OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m00@00005OV1n
@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT00
1GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000Wi01@0002moP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n000Aoo`03001oogoo019oo`004goo0P000Woo00D3
hP005n0Gh000008oh006001Wh6?PIn1Sh0001gn000<007i0OT0057i00P0001]m07dPO@1m87d0OB1m
07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@002@00DWi02@00=7n017oo00<0
07ooOol04Woo000COol06@00Oomoogoo0n8001OP6n0003oP>n0006?PIn1Sh6OP001oP7mPOh1oH7n0
Of1oP000009n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000InH7i0OT1n@7iPOT040000
3WdPO@1m87d0OB1m07dPO@1m87d0OB1m07dPO@090003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n
@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n
@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT00
1GiPOT1n@7i0OV000Wi02@0003eoP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP004Ool00`00Oomoo`0BOol001=oo`09001oogooOol3hP006n0G
h000008oh006001Wh6?PIn1Sh0001gn000<007i0OT006Wi03P00Egi01000AWn017oo00<007ooOol0
4Woo000COol02@00Oomoogoo0n8001OP6n000002?n003`00Hn1Wh6?PIn0007n0Of1oP7mPOh1oH7n0
001nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiP
OT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi0
00EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP
00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@003OV1n@7i0
00X0001:Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP0Aoo`03001oogoo019oo`004goo00H007oo
Oomoo`?R00025n002@00?n0oh000In1Sh6OPHn000007Oh000`00OT1n@01aOT04001DOh04Ool00`00
Oomoo`0BOol000Uoo`D000Eoo`0I001oogooOol3hP005n0Kh000?n0kh000Hn1Wh6?PIn0007n0Of1o
P7mPOh1oH7n000000Wi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n
@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n
@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP009n@0X0001HOf1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh04Ool00`00Oomoo`0BOol0
00Uoo`05001oogooOol00005Ool01000Oomoogoo0P?R00<001OP00000SoP00H006OPHn1Wh6?P0008
Oh000`00OT1n@01ROT04001POh030003Ool00`00Oomoo`0BOol000Yoo`03001oogoo00Ioo`09001o
ogooOol3hP?S000Kh000008oh00?001Sh6OPHn1Wh000Oh1oH7n0Of1oP7mPOh1oH00000=n@005OV1n
@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT00
1GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi02@0005]oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH009
00000f?PIn1oo`03Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Eoo`80009o
o`83hP03000Gh000008oh006001Wh6?PIn1Sh00027n000<007i0OT00E7i01@00Fgn02@0000]Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?P00=oo`8001Aoo`0037oo00<007ooOol017oo00@007ooOomoo`83hP0F
000Kh000?n0kh000Hn1Wh6?PIn0007n0Of1oP7mPOh1oH7n0Of1oP000OV03OT001GiPOT1n@7i0OV00
0gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n
@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n
@7i0OT1nH003OT001GiPOT1n@7i0OV00100005MoH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of002@0001ASh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OP17oo00<007ooOol04Woo000=Ool00`00Oomoo`03Ool01000Oomoogoo0P?R00<001OP
00000SoP00H006OPHn1Wh6?P0009Oh000`00OT1n@015OT0:001BOh0900007F?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0017oo00<007ooOol04Woo
0009Ool01@00Oomoogoo00001Goo00T007ooOomoo`?R0n<001_P00000SoP01<006?PIn1Sh6OP001o
P7mPOh1oH7n0Of1oP7mPOh1oH000OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n
@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1n
H003OT001GiPOT1n@7i0OV000gi000InH7i0OT1n@7iPOT030000DgmPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of002@0002ISh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP17oo00<007ooOol0
4Woo000:Ool30006Ool01000Oomoogoo0P?R00<001OP00000SoP00H006OPHn1Wh6?P000:Oh000`00
OT1n@00kOT06001=Oh090000;f?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0017oo00<0
07ooOol04Woo000COol01000Oomoogoo0P?R01L001_P000oh3_P001Sh6OPHn1Wh000Oh1oH7n0Of1o
P7mPOh1oH7n0Of1oP000009n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n
@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000EnH7i0OT1n@7iP00=n@006OV1n
@7i0OT1nH7i0100004UoP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP00:0000>6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn04Ool00`00Oomoo`0BOol001=oo`04
001oogooOol20n800`005n000002?n001P00In1Sh6OPHn0000]oP003001n@7i002en@0T004UoP0@0
0012In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?P17oo00<007ooOol04Woo000COol20002Ool01@?R0n<001_P00000SoP01<0
06?PIn1Sh6OP001oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of000003OT001GiPOT1n@7i0OV000gi000En
H7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003OT001GiPOT1n@7i0OV000gi000InH7i0OT1n@7iPOT05
0000BGmPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP00T00016Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn04Ool0
0`00Oomoo`0BOol001=oo`04001oogooOol20n800`005n000002?n001P00In1Sh6OPHn0000eoP003
001n@7i0025n@0D004EoP0T0001?Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00
17oo00<007ooOol04Woo000COol01000Oomoogoo0P?R01X001_P000oh3_P001Sh6OPHn1Wh000Oh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH0000gi000EnH7i0OT1n@7iP00=n@005OV1n@7i0OT1nH003
OT001GiPOT1n@7i0OV000gi000=nH7i0OT00100004EoH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of001@0005QSh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0Aoo`03001o
ogoo019oo`004goo00@007ooOomoo`83hP03000Gh000008oh006001Wh6?PIn1Sh0003gn00`004Wi0
2@00@7n02@0005eSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn0017oo00<007ooOol04Woo000COol02@00Oomoogoo0n83h`006n000002
?n006000Hn1Wh6?PIn1Sh000Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH0@0009n@003
OV1n@7i000T00014Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH0D0001PHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP1`000goo00<007ooOol0
4Woo000COol01000Oomoogoo0P?R00<001OP00000SoP00L006OPHn1Wh6?PIn00000EOh050015Oh08
0000G6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn090006?n04Ool00`00Oomoo`0BOol001=oo`04001oogooOol20n80IP006n0003oP>n00
06?PIn1Sh6OPHn0007mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1o
P7mPOh1oH7n0Of1oP0D0001KIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn002@0000<oh3_P?n000SoP00Dkh3oP?n0oh3_P00<oh003>n0oh7oo
00=oo`03001oogoo019oo`004goo00@007ooOomoo`83hP03000Gh000008oh007001Wh6?PIn1Sh6OP
0000D7n02P00059Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0h001Po
h0Aoo`03001oogoo019oo`004goo0P000Woo00D3hP?S000Kh000008oh01C001Sh6OPHn1Wh6?P001o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP0040000Df?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn002@000SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003
?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh004>n0oh3oP?n04Ool00`00Oomoo`0BOol0
01=oo`04001oogooOol20n800`005n000002?n002000In1Sh6OPHn1Wh6?P0016Oh050000CVOPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0T002loh0Aoo`03001oogoo019oo`004goo00@0
07ooOomoo`83hP1<000Kh000?n0kh000Hn1Wh6?PIn1Sh6OP001oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh070000B6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh0/0008oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0o
h3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh006>n0o
h3oP?n0kh3oP17oo00<007ooOol04Woo000COol01000Oomoogoo0P?R00<001OP00000SoP00P006OP
Hn1Wh6?PIn1Sh000>Gn01`0004ISh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0P004<oh0Aoo`03001oogoo019o
o`004goo00T007ooOomoo`?R0n<001_P00000SoP03`006?PIn1Sh6OPHn1Wh000Oh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of050000A6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn090003?n00
1C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n00
0coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0o
h3_P00<oh005>n0oh3oP?n0kh003?n04Ool00`00Oomoo`0BOol001=oo`04001oogooOol20n800`00
5n000002?n002000In1Sh6OPHn1Wh6?P000`Oh040000@6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP2@00E3oP17oo00<007ooOol0
4Woo000COol01000Oomoogoo0P?R03P001_P000oh3_P001Sh6OPHn1Wh6?PIn1Sh000Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n01@0003]Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OP00T000<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<o
h005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h003?n001C_P?n0oh3oP>n000coP00<kh3oPOol00goo00<007ooOol04Woo000COol20002Ool20n80
0`005n000002?n002@00In1Sh6OPHn1Wh6?PIn00000UOh050000>fOPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn001@00ISoP17oo00<007ooOol04Woo
000COol02@00Oomoogoo0n83h`006n000002?n00:P00Hn1Wh6?PIn1Sh6OPHn1Wh000Oh1oH7n0Of1o
P7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1oH0@0000g
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn002@000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<o
h005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0o
h3oP>n000coP00Hkh3oP?n0oh3_P?n030003Ool00`00Oomoo`0BOol001=oo`04001oogooOol20n80
0`005n000002?n002P00In1Sh6OPHn1Wh6?PIn1Sh0006gn01@0003MSh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh004001U?n0=00025n04Ool00`00Oomoo`0BOol0
01=oo`04001oogooOol30n8200008coP>n0006?PIn1Sh6OPHn1Wh6?PIn1Sh000Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh001000039Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OP2P000SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP
00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P
00<oh005>n0oh3oP?n0kh003?n000c_P0000000<00003a_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh004Ool00`00Oomoo`0BOol001=oo`04001oogooOol30n820002?n003000In1Sh6OPHn1Wh6?P
In1Sh6OPHn0000eoP0P0000bIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0@0
05Toh0`000<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh003
6n0Gh7oo00=oo`03001oogoo019oo`004goo00L007ooOomoo`?R0n<3hP020002?n003000Hn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh0d0000aHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00
2@000SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP
?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005
>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh0/0000Y6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh004Ool00`00Oomoo`0BOol001=oo`04001oogooOol30n820002?n00A@00In1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh005001=?n0>00001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
11_P5n0Gh1OP17oo00<007ooOol04Woo000COol01000Oomoogoo0`?R0P0004<oh3_P001Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h0040002?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P
?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP
00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh002?n090000@QOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0Aoo`03001oogoo
019oo`004goo0P000Woo0P?R00<001OP00000SoP03P006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP2@00A3oP2@0000<Gh1_P5n000QOP00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001Q_P5n0G
h1OP6n0Gh0Aoo`03001oogoo019oo`004goo00T007ooOomoo`?R0n<001_P00000SoP03<006?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn001@0000<oh3_P?n000SoP00Dkh3oP?n0o
h3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0o
h3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh003>n0oh00000d0001D5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P17oo00<007ooOol04Woo
000COol01000Oomoogoo0P?R00<001OP00000SoP02h006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP
Hn1Wh0D003/oh0T0008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P
5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0Aoo`03001oogoo019oo`004goo00@007ooOomoo`83
hP0_000Kh000?n0kh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00400000coP>n0oh002?n001C_P?n0o
h3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n000c_P?n0000080000Ja_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0017oo00<007ooOol04Woo000:Ool50004Ool01000Oomoogoo0P?R00<0
01OP00000coP02@006?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn05000g?n0400025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh7oo00=oo`03001oogoo019oo`0037oo00<007ooOol017oo
00T007ooOomoo`?R0n<001_P00000coP020006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP100000Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0k
h003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0o
h3oP>n000coP00<kh3oP00002@00078Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n070003Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`04001oogooOol20n80
0`005n000003?n006`00Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1S
h6OPHn1Wh005000]?n0900025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP
5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P
5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP4P001P?R17oo00<0
07ooOol04Woo00000goo000000040005Ool00`00Oomoo`04Ool20002Ool20n807@006n0003oP>n0o
h000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0010000coP00Dkh3oP
?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh006
>n0oh3oP?n0kh3oP2@0006DKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P00h000<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00=oo`8001Aoo`0037oo00<007ooOol017oo00@0
07ooOomoo`83hP03000Gh00000@oh00A001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh005
000Y?n0400025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh0036n0Gh000014002H3hPAoo`03001oogoo019oo`0037oo00<007ooOol017oo00T007oo
Oomoo`?R0n<001_P00000coP00dkh3oP001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh0050002?n001C_P?n0o
h3oP>n000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dk
h3oP?n0oh3_P008oh0D0001B5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0>00000`?R0n<3hP020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n83
hP04Ool00`00Oomoo`0BOol000Yoo`<000Ioo`04001oogooOol20n800`005n000006?n02000016?P
In1Sh6OP10009CoP2@0000<Gh1_P5n000QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n0011_P5n0Gh1OP3P00AP?R17oo00<007oo
Ool04Woo000<Ool00`00Oomoo`04Ool01000Oomoogoo0P?R00D001_P000oh3_P00<oh003>n0oh3oP
00@00003?n0kh3oP008oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P
00<oh005>n0oh3oP?n0kh002?n050000BAOP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP00T000<3hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?SOomoo`02Ool00`00Oomoo`0B
Ool001=oo`04001oogooOol20n800`005n00000/?n0400000aOP6n0Gh0025n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh1OP5n003P00G@?R17oo00<0
07ooOol04Woo000COol02@00Oomoogoo0n83h`006n000003?n001C_P?n0oh3oP>n000coP00Dkh3oP
?n0oh3_P00<oh005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP00@kh3oP?n0oh0D0000g6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n003@0000D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP030n<3hP?R00Aoo`03001oogoo019oo`004goo00@007ooOomoo`83
hP03000Gh00002<oh0@000056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh000
00T007P3hPAoo`03001oogoo019oo`004goo0P000Woo0P?R00D001_P000oh3_P00<oh005>n0oh3oP
?n0kh003?n001C_P?n0oh3oP>n000coP00Dkh3oP?n0oh3_P00<oh0H0000]5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP00T000030n83h`?R0083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`04Ool00`00Oomoo`0BOol0
01=oo`04001oogooOol20n800`005n00000J?n0300001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh000
00P008/3hPAoo`03001oogoo019oo`004goo00T007ooOomoo`?R0n<001_P00000coP00Dkh3oP?n0o
h3_P00<oh005>n0oh3oP?n0kh003?n000c_P?n000004000091_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0T000030n83h`?R
0083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00H3h`?R0n83hP?S
0n8J0003Ool00`00Oomoo`0BOol001=oo`04001oogooOol20n8010005n0Kh0003coP1@000QOP00DK
h1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<G
h0036n0Gh1OP00@00783hQ8001T3k0Aoo`03001oogoo019oo`004goo00@007ooOomoo`83hP05000K
h1OP000kh003?n001C_P?n0oh3oP>n000SoP100001lKh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh00;00001@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`020n8G0000:`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo019oo`004goo00@007ooOomoo`83hP03000G
h1OP008000Hoh0@000035n0Kh1OP008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DK
h1OP5n0Gh1_P00<Gh0036n0Gh1OP00<005P3hQ800483k0Aoo`03001oogoo019oo`004goo00/007oo
Oomoo`?R0n<001_P5n0Kh1OP0080008oh080000K6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P00T000050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hQ<0001D0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/17oo00<007ooOol04Woo
000COol20002Ool20n800`005n0Kh0035n001A_P000001OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n000a_P5n0Gh00500140n8=001W0n`4Ool00`00Oomoo`0BOol001=oo`04001o
ogooOol20n807@006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n00100000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP030n<3hP?R00h0001d0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0Aoo`03001oogoo019oo`004goo00@007ooOomoo`83hP05000Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0D00343hPh00883k0Aoo`03001oogoo019oo`00
4goo01T007ooOomoo`?R0n<001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0050003
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00H3h`?R0n83hP?S0n8=0000T0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0Aoo`03001oogoo019oo`004goo00@007ooOomoo`83hP03000Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n000a_P00000002000U0n89002M0n`4Ool00`00Oomoo`0BOol001=oo`04001o
ogooOol30n802`005n0Kh1OP6n0Gh1_P5n0Kh1OP6n000`000P?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00X0002V0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`4Ool00`00Oomoo`0BOol001=oo`04001oogooOol30n8010005n0Gh1_P
0aOP00@Kh1OP000001X3hPP009L3k1X000=oo`03001oogoo019oo`004goo00d007ooOomoo`?R0n<3
hP005n0Kh1OP6n0Gh00300000`?R0n<3hP020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP030n<3hP0000@0001k0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[02@0000I0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH017oo00<007ooOol04Woo000COol20002Ool40n800`005n0Gh002000A
0n89001P0n`P00000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e17oo00<007ooOol04Woo000COol01000Oomoogoo0`?R00D3h`?R000000?S
00<3hP050n<3hP?R0n83h`030n800`?S0n8000040000C@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/0700005d3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH017oo00<007ooOol04Woo000COol01000Oomoogoo40?R1@00@0?/
4P000`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e
0oH3m@Aoo`03001oogoo019oo`004goo00H007ooOomoo`?R0n<30n801P?S0n83hP?R0n<3hPD0000^
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`G0000R`?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f00Aoo`03001oogoo019oo`004goo00@007ooOomoo`P3hP<002D3k0h00083
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e17oo00<007ooOol04Woo000COol01000Oomoogoo0`?R00<3h`?R
0n800P0001/3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/03@000;03m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
17oo00<007ooOol04Woo000COol01000Oomoogoo1P0050?/2@000`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD00`?f0oEoo`03
Ool00`00Oomoo`0BOol001=oo`80009oo`0@0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`:
0000aP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mPAoo`03001oogoo019oo`004goo
00@007ooOomoo``3k0@000050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e17oo00<007ooOol04Woo000COol02`00Oomoogoo0n/3k0?[0n`3j`?/0n/01@00
09/3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e03X000=oo`03001oogoo019oo`004goo00@007ooOomoo`@3k0<000<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@030oH3m@?e058003T3o`Aoo`03001oogoo019oo`004goo00H007oo
Oomoo`?[0n`200007`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e038008/3o`Aoo`03001oogoo019oo`002Woo10001Goo00@007ooOomoo`80
0083m@050oH3m@?e0oD3mP030oDG002m0ol4Ool00`00Oomoo`0BOol000Uoo`03001oogoo009oo`03
001oogoo009oo`07001oogooOol3m@?f0oD02@00e0?o17oo00<007ooOol04Woo0009Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01000Oomoogoo0`00g@?o17oo00<007ooOol04Woo0009Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool20002Ool3003M0ol3Ool2000DOol000Uoo`03001oogoo009oo`03001o
ogoo009oo`05001oogooOol2g`020[l4003I0ol4Ool00`00Oomoo`0BOol000Uoo`03001oogoo009o
o`03001oogoo009oo`0;001oogooOol2_`;O0[l2g`:o0]l2_`0L002m0ol4Ool00`00Oomoo`0BOol0
00Uoo`03001oogoo009oo`03001oogoo009oo`04001oogooOol300030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0;@00T0?o17oo00<007oo
Ool04Woo000:Ool40005Ool01`00Oomoogoo0Gl1W`5o00<0001:0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2gdh00483o`Aoo`03001oogoo019oo`004goo00@007ooOomoo`H1W`8000050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o@`000goo00<0
07ooOol04Woo000COol03000Oomoogoo0Gl1W`5o0Il1O`6O0Gl1W`P0003@0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l4Ool00`00Oomoo`0BOol001=o
o`80009ooa01W`D000030[l2g`:o0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2
g`:o17oo00<007ooOol04Woo000COol01000Oomoogoo1P0000l1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl03P000;d2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l017oo00<007ooOol04Woo000COol01000Oomo
ogoo1P1O0P006`6O3@0000D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`Aoo`03001oogoo019oo`004goo00@007ooOomoo`<0G`0507l0G`1O05l0O`0300009@6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O00h0002R0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O17oo00<007ooOol04Woo000C
Ool01000Oomoogoo2`1O1@00;P6O4P000P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1P;O0[l2_`:o0]l2_`Aoo`03001oogoo019oo`004goo00H007ooOomoo`1O07l305l01@1o05l0G`1O
07l00`1O00<0O`1O05l01@0003/1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O01L0001i0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l017oo00<007ooOol04Woo000COol01000Oomoogoo5@1O
1@00C@6O700000<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l4Ool00`00Oomoo`0BOol001=oo`80009oo`<0G`0307l0G`00008000<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O100006D1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
01/000120[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O17oo00<007ooOol04Woo000COol01000Oomoogoo101O00@001@O61lD
7`8001@0G`P007P1Wb@000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`060]l2_`:o0[l2g`:o17oo00<007ooOol04Woo000COol03P00Oomoogoo05l0O`1O000D7aPO
51lH7a@O61l300001@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
0`1o000000080000TP5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0IlO0003Ool00`00Oomoo`0BOol001=oo`04001oogooOol305l00`0061lD7`0251l01APO51lD
7a@O61l010007`1O2P00YP6O17oo00<007ooOol04Woo000COol01000Oomoogoo0P1O00l001PO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51l010000P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O00T0002M0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il017oo00<007ooOol04Woo000COol01000Oomoogoo0P1O00D001@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l00aPO51lD7`05000Y05l=002@0Il4Ool00`00Oomoo`0BOol001=oo`0N001oogooOol0
G`1o000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO1@000P1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O3P000881O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`Ao
o`03001oogoo019oo`004goo00@007ooOomoo`80G`03000D7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7`@003/0G`h007@1W`Aoo`03001oogoo019oo`00
4goo0P000Woo0P1O00L001PO51lH7a@O61lD7`02000061PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7`D000<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0O`0000002`0006L1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00Oomoo`0BOol001=oo`04001oogooOol205l01@0051lD7a@O
61l00P000S`O0P0000<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01QPO
51lD7a@O61lD7`@004d0Ga<005@1W`Aoo`03001oogoo019oo`004goo00T007ooOomoo`1O07l001PO
51l00P0000<l7cPO?1l00S`O00<h7`0000000P0001/H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0200000<0G`1o05l00P1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O018000120Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O17oo00<007ooOol0
4Woo000COol01000Oomoogoo0P1O00@001@O61l000/l7`@000<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0461lD7a@O51l6001T05lB000`0Il4Ool00`00Oomo
o`0BOol001=oo`04001oogooOol205l01@0061lD7`00>1l00c`O00Dh7c`O?1ll7cPO00<l7`03>1ll
7c`O00D0000P51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7`T0000507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l05`00
01T1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00
Oomoo`0BOol001=oo`04001oogooOol205l00`0051l0000E?1l400001APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00T0
07/0GaL00081W`Aoo`03001oogoo019oo`004goo00T007ooOomoo`1O07l001PO00000c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01SPO?1ll7c`O>1ll7`80000/51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7`T0000507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00@0O`00000000=o
o`03001oogoo019oo`004goo0P000Woo0P1O00<001@O00006c`O1@000a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l01APO51lD7a@O61l02@00PP1O17oo00<007ooOol04Woo000COol01000Oomoogoo0P1O00D0
01PO000l7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`03>1ll7c`O00L0000b51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`X000<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00Ao
o`03001oogoo019oo`004goo00@007ooOomoo`80G`03000D7`0002Ll7`D0000351lH7a@O008D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0361lD7`0000`006/0G`Aoo`03001oogoo
019oo`004goo00T007ooOomoo`1O07l001PO00000c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l00cPO0000
00020000@1PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O2@000`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00P1O17oo00<007ooOol04Woo000COol01000Oomo
ogoo0P1O00<001@O000023`O100093`O1@000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51l0000=001D05l4Ool00`00
Oomoo`0BOol000Yoo`D000Aoo`04001oogooOol205l01@0061l003`O>1l00c`O00Lh7`00001T7f0O
I1mP7`0400000c`O>1ll7`02?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O1@0004dH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO00h0000305l0O`1O0080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0OgooOol00Woo00<007ooOol04Woo000<Ool00`00
Oomoo`04Ool01000Oomoogoo0P1O00<001@O00001C`O00/0060OI1mP7f@OH1mT7f0OI1mP7f@O00D0
02Dl7`T0008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l>000h05l4Ool0
0`00Oomoo`0BOol000aoo`03001oogoo00Aoo`09001oogooOol0G`1o000H7`0000<l7`0B>1l0060O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O1@0000<l7cPO?1l00S`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`04>1ll7c`O?1l4
0000G1@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61l=00001@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O00Aoo`03001oogoo019oo`0037oo
00<007ooOol017oo0P000Woo0P1O00<001@O00000c`O01L0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O00@002Tl7`T000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO01<001P0G`=oo`8001Aoo`00
37oo00<007ooOol017oo00@007ooOomoo`80G`0Q000H7`00?1lh7c`O001T7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00D0008l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00<h7c`O?1l02@0006XD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`h0000305l0O`1O
0080G`0507l0G`1O05l0O`04Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`04001oogooOol2
05l00`0051l00003?1l08000H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1l4000b?1l5000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`/000=oo`03001oogoo019oo`002Woo0`001Woo00T007ooOomoo`1O07l0
01PO00000c`O02@006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l50003?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`02?1l90000M1@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61l4Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`04001oogooOol205l00`0051l00002?1l0
:P00I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`@003Ll7`T000<D7`0561lD7a@O51lH7`0351l01APO51lD
7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH
7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D
7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH
7`0351l4Ool00`00Oomoo`0BOol001=oo`04001oogooOol205l0<`0061l003`O>1l0060OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7`0500001CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00<h7c`O?1l02@00068D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO17oo00<007ooOol0
4Woo000COol01000Oomoogoo0P1O00<001@O00000S`O03<006@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1l01@00?c`O2P000Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O
51lD7aPO00<D7`0661lD7a@O51lH7a@O17oo00<007ooOol04Woo000COol20002Ool01@1O07l001PO
00000S`O03P0060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
100000<l7cPO?1l00S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll
7cPO00<l7`05>1ll7c`O?1lh7`03?1l=0000BaPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`04
Ool00`00Oomoo`0BOol001=oo`04001oogooOol205l00`0051l00002?1l0?000I1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`T004Tl7`T0008D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O
61l00a@O17oo00<007ooOol04Woo000COol01000Oomoogoo0`1O0P0004Ll7cPO001P7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@O00D00003?1lh7c`O008l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`X0000h51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`Aoo`03001oogoo019oo`00
4goo00@007ooOomoo`<0G`80008l7`0?001T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00P0000c
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O00@005<l7``0008D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00<H7a@OOol00goo00<007ooOol04Woo000COol01`00Oomoogoo05l0O`1O
0080008l7`0;001P7f@OH1mT7f0OI1mP7f@OH1mT7`04000027`KO1al6g`LO1]l77`KO1`50000<V@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l90002?1l01CPO?1ll7c`O>1l00c`O
00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO
00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00@h7c`O?1ll7`l0000M61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`04Ool00`00Oomoo`0BOol001=oo`04
001oogooOol305l20002?1l02`00I1mP7f@OH1mT7f0OI1mP7f@O00004G`L2@00039T7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O1@00H3`O3P000a@O00DH7a@O51lD7aPO00<D7`04
61lD7a@O51l4Ool00`00Oomoo`0BOol001=oo`04001oogooOol205l0:P0061l003`O>1l0060OI1mP
7f@OH1mT7f0OI1l007`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l70D0000bI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`T0008l7`05
>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03
?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O
>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O
?1ll7cPO00<l7`03>1ll7c`O00T0000651lH7a@O61lD7aPO17oo00<007ooOol04Woo000COol01000
Oomoogoo0P1O00<001@O00000S`O00X006@OH1mT7f0OI1mP7f@OH1l0021l70@0000gH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l02@00IC`O1`000goo00<007oo
Ool04Woo000COol20002Ool01@1O07l001PO00000S`O02h0060OI1mP7f@OH1mT7f0O001l6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6`D0000kH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7`050002?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh
7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll
7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh
7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l013PO?1ll7c`O17oo00<007ooOol04Woo000COol0
1000Oomoogoo0P1O00<001@O00000S`O00T006@OH1mT7f0OI1mP7f@O0000:W`L1@0003]P7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00T005dl7`Ao
o`03001oogoo019oo`004goo00@007ooOomoo`80G`0m000H7`00?1lh7`00H1mT7f0OI1mP7f@O001l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1/01000041T7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`T0008l7`05>1ll
7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l00cPO?1moo`03Ool00`00Oomoo`0BOol0
01=oo`04001oogooOol205l00`0051l00002?1l02000I1mP7f@OH1mT7f0O000dO1`50000A6@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l9001;?1l4Ool00`00Oomoo`0BOol001=oo`09001oogooOol0G`1o000H7`00008l
7`11001P7f@OH1mT7f0OI1l007`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l70040000BF0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O00P000<l7`05>1ll7c`O
?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO
?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
17oo00<007ooOol04Woo000COol01000Oomoogoo0P1O00<001@O00000S`O00P006@OH1mT7f0OI1mP
7`00?G`L2@0004QP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l;000h?1l4Ool00`00Oomoo`0BOol001=o
o`04001oogooOol205l0D`0061l003`O>1l0060OI1mP7f@OH1mT7`00O1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1/01@0004iP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l900000c`O>1ll7`02?1l0
1CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l0
0c`O00Dh7c`O?1ll7cPO00<l7`03>1ll7goo00=oo`03001oogoo019oo`004goo0P000Woo0P1O00<0
01@O00000S`O00L006@OH1mT7f0OI1l0001<O1`40000Df@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1l02@009S`O17oo00<007ooOol04Woo000COol02@00Oomoogoo05l0
O`0061l00002?1l0E`00H1mT7f0OI1mP7`00O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l700:0000DV0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O2@00
00<l7cPO?1l00S`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O
17oo00<007ooOol04Woo000COol01000Oomoogoo0P1O00<001@O00000S`O00L006@OH1mT7f0OI1l0
001JO1`50000EV0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1l>000??1l4Ool00`00Oomoo`0BOol001=oo`04001oogooOol205l08@0061l003`O>1l0060OI1mP
7f@OH1l007`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6`050000AG`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6`080000G6@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1l900001SPO?1ll7c`O>1ll7`Aoo`03001oogoo019oo`004goo
00@007ooOomoo`80G`03000D7`00008l7`07001T7f0OI1mP7f@O00004W`L0`001G`B2@00A7`L1@00
061T7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1l70003Ool00`00Oomoo`0BOol001=oo`09001oogooOol0G`1o000H7`00008l
7`0G001P7f@OH1mT7`00O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l700200000g`BO1=l
4P02O1801G`CO19l4W`BO1<00g`B00Al4g`BO19l4PT00010O1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`90000GF@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7`04Ool0
0`00Oomoo`0BOol001=oo`04001oogooOol205l00`0051l00002?1l01P00I1mP7f@OH1l000ml7080
01al4P@004El70D0001HI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1l4Ool00`00Oomoo`0BOol001=oo`04001oogooOol205l0600061l003`O>1l0060O
I1mP7f@O001l77`KO1al6g`LO1]l77`KO1al6g`LO1]l708000=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`02O1850000AG`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l70090000Cf@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O00Aoo`03001o
ogoo019oo`004goo0P000Woo0P1O00<001@O00000S`O00H006@OH1mT7f0O000<O1`00`00O19l4P0W
O1850019O1`40000Bf0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`04Ool00`00Oomoo`0BOol0
01=oo`09001oogooOol0G`1o000H7`00008l7`0C001P7f@OH1mT7`00O1al6g`LO1]l77`KO1al6g`L
O1]l7000O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO19l4P090000A7`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1/90000@V0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7`Aoo`03001oogoo019oo`004goo00@007ooOomoo`80G`03000D7`00
008l7`06001T7f0OI1mP7`002g`L00<007`BO180=W`B1000BG`L2P0003QT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O17oo00<007ooOol04Woo000COol01000
Oomoogoo0P1O01H001PO000l7cPO001P7f@OH1mT7`00O1al6g`LO1]l77`KO1al6g`LO1/000=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`CO1800005
0000CG`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`02@0002mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O
I1mP7f@OH1mT7f0OI1mP7f@O00Aoo`03001oogoo019oo`002Goo1@001Goo00@007ooOomoo`80G`03
000D7`00008l7`06001T7f0OI1mP7`002W`L00<007`BO180@G`B0`00Dg`L2@0002IT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0O17oo00<007ooOol04Woo0009Ool01@00Oomoogoo00001Goo00T007ooOomoo`1O07l001PO
00000S`O0100060OI1mP7f@O001l77`KO1al6g`LO1]l77`KO1`0009l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00X0001BO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`900007F@O
H1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l017oo
00<007ooOol04Woo000:Ool00`00Oomoo`06Ool01000Oomoogoo0P1O00<001@O00000S`O00H006@O
H1mT7f0O0009O1`00`00O19l4P1?O184001GO1`9000056@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1l4Ool00`00Oomoo`0BOol000]oo`03001oogoo00Eoo`80009oo`80G`0F000H
7`00?1lh7`00H1mT7f0OI1l007`LO1]l77`KO1al6g`LO1/007`BO1<3O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00=l4`0000000`0005]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l700900002f@OH1mT7f0OI1mP7f@O
H1mT7f0OI1l00goo0P0057oo000<Ool00`00Oomoo`04Ool01000Oomoogoo0P1O00<001@O00000S`O
00H006@OH1mT7f0O0008O1`00`00O19l4P1IO189001KO1`900000f@OH1moo`03Ool00`00Oomoo`0B
Ool000eoo`03001oogoo00=oo`09001oogooOol0G`1o000H7`00008l7`0?001P7f@OH1mT7`00O1al
6g`LO1]l77`KO1al6`0000=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P03O1<000000080001PO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l
77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L0`00
0goo00<007ooOol04Woo0009Ool01@00Oomoogoo00001Goo00H007ooOomoo`1O000251l02@00?1ll
7`00I1mP7f@OH1l00007O1`00`00O19l4P1WO18:001HO1`4Ool00`00Oomoo`0BOol000Yoo`<000Io
o`0I001oogooOol0G`0051lH7`00?1lh7`00H1mT7f0OI1l007`LO1]l77`KO1al6g`L00000W`B00El
4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1800g`C000000020000E7`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l70Aoo`03001oogoo019oo`00
4goo00T007ooOomoo`1O000H7a@O00000S`O00H006@OH1mT7f0O0007O1`00`00O19l4P1eO18:001:
O1`4Ool00`00Oomoo`0BOol001=oo`09001oogooOol0G`0051lH7`00008l7`0?001P7f@OH1mT7`00
O1al6g`LO1]l77`KO1`007`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P04O1=l4W`BO1850003O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P03O1<0000000800016O1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`4Ool0
0`00Oomoo`0BOol001=oo`06001oogooOol0G`000Q@O00T003`O?1l006@OH1mT7f0O00001g`L00<0
07`BO1805W`B200000El27`9O0Ql2G`800h0059l4PT003el70Aoo`03001oogoo019oo`004goo0P00
0Woo01D0G`0051lH7`00?1lh7`00H1mT7f0OI1l007`LO1]l77`KO1al6g`L00000W`B00El4g`BO19l
4W`C00=l4P05O1=l4W`BO19l4`03O18017`CO19l4W`B0P0001]l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T010000g`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P04O1=l4W`BO1890000=7`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`K
O1al6g`LO1]l77`KO1al6g`L17oo00<007ooOol04Woo000COol02@00Oomoogoo05l001PO51l00002
?1l01P00I1mP7f@OH1l000Ml7003001l4W`B019l4P80000QO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`800T005Ml4PD002ml70Aoo`03
001oogoo019oo`004goo00T007ooOomoo`1O000D7aPO00000S`O00l0060OI1mP7f@O001l77`KO1al
6g`LO1]l7000O1<00g`B00El4g`BO19l4W`C00=l4P06O1=l4W`BO19l4g`B0P0002al2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`81@000g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P04O1=l4W`BO18900009W`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1al6g`LO1]l77`KO1`4Ool00`00Oomoo`0BOol001=oo`06001o
ogooOol0G`000Q@O00T003`O?1l006@OH1mT7f0O00001g`L00<007`BO1803g`B03@007`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20T005Ml4PT001el70Aoo`03001oogoo019o
o`004goo01T007ooOomoo`1O000D7aPO000l7cPO001P7f@OH1mT7`00O1al6g`LO1]l77`KO1`00002
O1801G`CO19l4W`BO1<00g`B04Al4g`BO19l4W`CO18007`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`81@000g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03
O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O189000057`KO1al6g`LO1]l77`KO1al
6g`LO1]l77`KO1al6g`LO1]l77`KO1`4Ool00`00Oomoo`0BOol001=oo`09001oogooOol0G`0061lD
7`00008l7`06001T7f0OI1mP7`001W`L00<007`BO1803W`B04@007`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`82@00Fg`B
1@003g`L17oo00<007ooOol04Woo000COol02@00Oomoogoo05l001@O61l00002?1l03`00H1mT7f0O
I1l007`LO1]l77`KO1al6`00O19l4`03O1801G`CO19l4W`BO1<00g`B051l4g`BO18007`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`80`0000=l4W`CO1800W`B00El4g`BO19l4W`C00=l4P05O1=l
4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O180
1G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<0
0g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O18900001W`KO1al6g`LO1]l70Aoo`03001o
ogoo019oo`004goo0P000Woo00D0G`0051lD7`00008l7`06001T7f0OI1mP7`001W`L00<007`BO180
3G`B054007`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P01P00H7`B1`000goo
00<007ooOol04Woo000COol06000Oomoogoo05l001@O61l003`O>1l0060OI1mP7f@O001l77`KO1al
6g`LO1/000=l4P05O1=l4W`BO19l4`03O180Fg`CO19l4P00O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900T00005O1=l4W`BO19l4`03O1801G`CO19l4W`B
O1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`B
O19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05
O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00Aoo`03001oogoo019oo`00
4goo00T007ooOomoo`1O000H7a@O00000S`O00H006@OH1mT7f0O0006O1`00`00O19l4P0;O180HP00
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0T5001HO184Ool00`00Oomoo`0BOol001=oo`09001oogooOol0G`0051lH7`00
008l7`0?001P7f@OH1mT7`00O1al6g`LO1]l77`K001l4W`C00=l4P05O1=l4W`BO19l4`03O180I`00
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900T00005O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B
00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C
00=l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`B
O19l4`02O184Ool00`00Oomoo`0BOol001=oo`06001oogooOol0G`000Q@O00T003`O?1l006@OH1mT
7f0O00001W`L00<007`BO1802W`B074007`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`900D004Yl4PAoo`03001oogoo019oo`004goo01P007ooOomoo`1O000D7aPO000l7cPO
001P7f@OH1mT7`00O1al6g`LO1]l77`K0003O1801G`CO19l4W`BO1<00g`B07Ml4`00O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`900P00003O19l4g`B009l
4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l
4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`CO19l
4W`BO1<017oo00<007ooOol04Woo000COol02@00Oomoogoo05l001PO51l00002?1l01P00I1mP7f@O
H1l000Il7003001l4W`B00Yl4P1n001l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`81@00?G`B17oo00<007ooOol04Woo000COol0
2@00Oomoogoo05l001@O61l00002?1l03`00H1mT7f0OI1l007`LO1]l77`KO1al6`00O19l4`03O180
RW`CO19l4W`BO1=l4P00O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20T00003O19l4g`B009l4P05O1=l4W`B
O19l4`03O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00El4g`BO19l4W`C009l4PAoo`03001oogoo019oo`004goo0P000Woo00D0G`00
51lD7`00008l7`06001T7f0OI1mP7`001W`L00<007`BO1802G`B08d007`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P01@00;g`B17oo00<007ooOol04Woo000COol06000Oomoogoo
05l001@O61l003`O>1l0060OI1mP7f@O001l77`KO1al6g`LO1/000=l4P05O1=l4W`BO19l4`03O180
TP00O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P900000g`B
O1=l4P02O1801G`CO19l4W`BO1<00g`B00El4g`BO19l4W`C00=l4P05O1=l4W`BO19l4`03O1801G`C
O19l4W`BO1<00g`B00=l4gooOol00Woo00<007ooOol04Woo000COol02@00Oomoogoo05l001PO51l0
0002?1l01P00I1mP7f@OH1l000Il7003001l4W`B00Ul4P2K001l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul2009000MO184Ool00`00
Oomoo`0BOol001=oo`09001oogooOol0G`0051lH7`00008l7`0?001P7f@OH1mT7`00O1al6g`LO1]l
77`K001l4W`C00=l4P2ZO1=l4W`BO19l4`00O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20D00003
O19l4g`B009l4P05O1=l4W`BO19l4`03O1801G`CO19l4W`BO1<00g`B00=l4g`BO18017oo00<007oo
Ool04Woo000COol01P00Oomoogoo05l0008D7`09000l7c`O001T7f0OI1mP7`0000Il7003001l4W`B
00Ql4P0Q001l27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`901l0001ZO0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P9000?O184Ool0
0`00Oomoo`0BOol001=oo`0H001oogooOol0G`0051lH7`00?1lh7`00H1mT7f0OI1l007`LO1]l77`K
O1al6`000g`B00El4g`BO19l4W`C009l4P0N001l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`90`007g`02P0006Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0P02@0000=l4W`CO1800W`B00=l4gooOol00Woo00<007ooOol04Woo000COol02@00Oomo
ogoo05l001PO51l00002?1l01P00I1mP7f@OH1l000Il7003001l4W`B00Ql4P0M001l27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@02000[O0090000JG`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20070003Ool00`00Oomoo`0BOol001=oo`80009oo`05
05l001@O61l00002?1l03`00H1mT7f0OI1l007`LO1]l77`KO1al6`00O19l4`03O18087`CO19l4W`B
O1<007`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P2000f
O0040000Jg`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0T017oo00<007ooOol04Woo000C
Ool01P00Oomoogoo05l0008D7`09000l7c`O001T7f0OI1mP7`0000Il7003001l4W`B00Ml4P0J001l
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@8003al00T0001R
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul20Aoo`03001oogoo019oo`004goo01P007ooOomoo`1O000D7aPO000l7cPO
001P7f@OH1mT7`00O1al6g`LO1]l77`K0003O1807W`CO19l4W`BO1=l4P00O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul208004Ml00T0001IO0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@04Ool00`00Oomoo`0BOol001=o
o`09001oogooOol0G`0061lD7`00008l7`06001T7f0OI1mP7`001W`L00<007`BO1801g`B01P007`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8001BO0050000E7`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8
O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul20Aoo`03001oogoo019oo`002Woo
0`001Woo00T007ooOomoo`1O000D7aPO00000S`O00l0060OI1mP7f@O001l77`KO1al6g`LO1/007`B
O1<00g`B01Ul4g`BO19l4P00O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@02
001HO0090000Bg`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9
O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@04Ool00`00Oomoo`0BOol000Uo
o`05001oogooOol00005Ool01P00Oomoogoo05l0008D7`09000l7c`O001T7f0OI1mP7`0000Il7003
001l4W`B00Ml4P0E001l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@0006=l00D0
0016O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P4Ool00`00Oomoo`0BOol000eoo`03001oogoo00=oo`0H001o
ogooOol0G`0051lH7`00?1lh7`00H1mT7f0OI1l007`LO1]l77`KO1al6`000g`B01]l4g`BO19l4W`C
O18007`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`80000J7`02@0003el2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul
27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2@04Ool0
0`00Oomoo`0BOol000eoo`03001oogoo00=oo`80009oo`0505l001PO51l00002?1l01P00I1mP7f@O
H1l000Il7003001l4W`B00Ml4P0D001l2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P0
079l00H0000gO0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql
2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0Ql2G`8O0Ul27`9O0P0
0goo0P0057oo000;Ool20006Ool00`00Oomoo`3UOol00`00Oomoo`0BOol000eoo`03001oogoo00=o
o`03001oogoo0>Eoo`03001oogoo019oo`002Goo00D007ooOomoo`0000Eoo`04001oogoo000UOol0
0`00Oomoo`0ROol00`00Oomoo`0SOol00`00Oomoo`0ROol00`00Oomoo`0SOol00`00Oomoo`0ROol0
1@00Oomoogoo000057oo000:Ool30006Ool01000Oomoo`001goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
17oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
17oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00D007ooOomoo`0001Aoo`004gooj@0057oo003oOolA
Ool00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00ogoo4Goo003oOolAOol00?mooa5oo`00
ogoo4Goo000AOol3003lOol001=oo`03001oogoo0?Yoo`004goo00<007ooOol0nWoo000BOol00`00
Ool0003kOol0019oo`03001oo`000?]oo`004Goo00D007ooOomoo`000?Yoo`004Goo00D007ooOomo
o`000?Yoo`0047oo0`0000Aoo`0000000?Uoo`00ogoo4Goo003oOolAOol00?mooa5oo`00ogoo4Goo
003oOolAOol00?mooa5oo`00ogoo4Goo0000\
\>"],
  ImageRangeCache->{{{0, 271.5}, {271.5, 0}} -> {-0.305773, -3.49963, \
0.016699, 0.0335097}}]
}, Open  ]],

Cell[TextData[{
  "The representation of the stream lines shows that the jet fans out and \
that the velocity decreases for larger values of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". This behavior is obvious in a graphical representation of the velocity \
for the two components"
}], "Text",
  Evaluatable->False,
  CellTags->"stream lines"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u = \[PartialD]\_y so1\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(Sech[y\/\(\@6\ x\^\(2/3\)\)]\^2\/x\^\(1/3\)\)], "Output"]
}, Open  ]],

Cell["and", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(v = \(-\[PartialD]\_x so1\)\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \(\(2\ y\ Sech[y\/\(\@6\ x\^\(2/3\)\)]\^2\)\/\(3\ x\^\(4/3\)\) - 
      \(\@\(2\/3\)\ Tanh[y\/\(\@6\ x\^\(2/3\)\)]\)\/x\^\(2/3\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "which both follow as derivatives from the stream function. We represent \
the two solutions by a contour plot. The velocity in the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " direction is"
}], "Text",
  Evaluatable->False,
  CellTags->"stream function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[u, {x,  .01, 3}, {y, \(-3\), 3}, PlotPoints \[Rule] 50, 
      Contours \[Rule] 20, ColorFunction \[Rule] Hue, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0160149 0.321585 0.5 0.160256 [
[.01601 -0.0125 -3 -9 ]
[.01601 -0.0125 3 0 ]
[.17681 -0.0125 -9 -9 ]
[.17681 -0.0125 9 0 ]
[.3376 -0.0125 -3 -9 ]
[.3376 -0.0125 3 0 ]
[.49839 -0.0125 -9 -9 ]
[.49839 -0.0125 9 0 ]
[.65918 -0.0125 -3 -9 ]
[.65918 -0.0125 3 0 ]
[.81998 -0.0125 -9 -9 ]
[.81998 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .17949 -12 -4.5 ]
[-0.0125 .17949 0 4.5 ]
[-0.0125 .33974 -12 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .66026 -6 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .82051 -6 -4.5 ]
[-0.0125 .82051 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01601 0 m
.01601 .00625 L
s
[(0)] .01601 -0.0125 0 1 Mshowa
.17681 0 m
.17681 .00625 L
s
[(0.5)] .17681 -0.0125 0 1 Mshowa
.3376 0 m
.3376 .00625 L
s
[(1)] .3376 -0.0125 0 1 Mshowa
.49839 0 m
.49839 .00625 L
s
[(1.5)] .49839 -0.0125 0 1 Mshowa
.65918 0 m
.65918 .00625 L
s
[(2)] .65918 -0.0125 0 1 Mshowa
.81998 0 m
.81998 .00625 L
s
[(2.5)] .81998 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(3)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.04817 0 m
.04817 .00375 L
s
.08033 0 m
.08033 .00375 L
s
.11249 0 m
.11249 .00375 L
s
.14465 0 m
.14465 .00375 L
s
.20897 0 m
.20897 .00375 L
s
.24112 0 m
.24112 .00375 L
s
.27328 0 m
.27328 .00375 L
s
.30544 0 m
.30544 .00375 L
s
.36976 0 m
.36976 .00375 L
s
.40192 0 m
.40192 .00375 L
s
.43408 0 m
.43408 .00375 L
s
.46623 0 m
.46623 .00375 L
s
.53055 0 m
.53055 .00375 L
s
.56271 0 m
.56271 .00375 L
s
.59487 0 m
.59487 .00375 L
s
.62703 0 m
.62703 .00375 L
s
.69134 0 m
.69134 .00375 L
s
.7235 0 m
.7235 .00375 L
s
.75566 0 m
.75566 .00375 L
s
.78782 0 m
.78782 .00375 L
s
.85214 0 m
.85214 .00375 L
s
.88429 0 m
.88429 .00375 L
s
.91645 0 m
.91645 .00375 L
s
.94861 0 m
.94861 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-3)] -0.0125 .01923 1 0 Mshowa
0 .17949 m
.00625 .17949 L
s
[(-2)] -0.0125 .17949 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(-1)] -0.0125 .33974 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(1)] -0.0125 .66026 1 0 Mshowa
0 .82051 m
.00625 .82051 L
s
[(2)] -0.0125 .82051 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(3)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05128 m
.00375 .05128 L
s
0 .08333 m
.00375 .08333 L
s
0 .11538 m
.00375 .11538 L
s
0 .14744 m
.00375 .14744 L
s
0 .21154 m
.00375 .21154 L
s
0 .24359 m
.00375 .24359 L
s
0 .27564 m
.00375 .27564 L
s
0 .30769 m
.00375 .30769 L
s
0 .37179 m
.00375 .37179 L
s
0 .40385 m
.00375 .40385 L
s
0 .4359 m
.00375 .4359 L
s
0 .46795 m
.00375 .46795 L
s
0 .53205 m
.00375 .53205 L
s
0 .5641 m
.00375 .5641 L
s
0 .59615 m
.00375 .59615 L
s
0 .62821 m
.00375 .62821 L
s
0 .69231 m
.00375 .69231 L
s
0 .72436 m
.00375 .72436 L
s
0 .75641 m
.00375 .75641 L
s
0 .78846 m
.00375 .78846 L
s
0 .85256 m
.00375 .85256 L
s
0 .88462 m
.00375 .88462 L
s
0 .91667 m
.00375 .91667 L
s
0 .94872 m
.00375 .94872 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01601 .99375 m
.01601 1 L
s
.17681 .99375 m
.17681 1 L
s
.3376 .99375 m
.3376 1 L
s
.49839 .99375 m
.49839 1 L
s
.65918 .99375 m
.65918 1 L
s
.81998 .99375 m
.81998 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.04817 .99625 m
.04817 1 L
s
.08033 .99625 m
.08033 1 L
s
.11249 .99625 m
.11249 1 L
s
.14465 .99625 m
.14465 1 L
s
.20897 .99625 m
.20897 1 L
s
.24112 .99625 m
.24112 1 L
s
.27328 .99625 m
.27328 1 L
s
.30544 .99625 m
.30544 1 L
s
.36976 .99625 m
.36976 1 L
s
.40192 .99625 m
.40192 1 L
s
.43408 .99625 m
.43408 1 L
s
.46623 .99625 m
.46623 1 L
s
.53055 .99625 m
.53055 1 L
s
.56271 .99625 m
.56271 1 L
s
.59487 .99625 m
.59487 1 L
s
.62703 .99625 m
.62703 1 L
s
.69134 .99625 m
.69134 1 L
s
.7235 .99625 m
.7235 1 L
s
.75566 .99625 m
.75566 1 L
s
.78782 .99625 m
.78782 1 L
s
.85214 .99625 m
.85214 1 L
s
.88429 .99625 m
.88429 1 L
s
.91645 .99625 m
.91645 1 L
s
.94861 .99625 m
.94861 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .17949 m
1 .17949 L
s
.99375 .33974 m
1 .33974 L
s
.99375 .5 m
1 .5 L
s
.99375 .66026 m
1 .66026 L
s
.99375 .82051 m
1 .82051 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05128 m
1 .05128 L
s
.99625 .08333 m
1 .08333 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .14744 m
1 .14744 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .24359 m
1 .24359 L
s
.99625 .27564 m
1 .27564 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .37179 m
1 .37179 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .4359 m
1 .4359 L
s
.99625 .46795 m
1 .46795 L
s
.99625 .53205 m
1 .53205 L
s
.99625 .5641 m
1 .5641 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .62821 m
1 .62821 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .72436 m
1 .72436 L
s
.99625 .75641 m
1 .75641 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .85256 m
1 .85256 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .91667 m
1 .91667 L
s
.99625 .94872 m
1 .94872 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .4 r
.01923 .46835 m
.02324 .45094 L
.02755 .43132 L
.03851 .4117 L
.03885 .40673 L
.04549 .39207 L
.0574 .37245 L
.05848 .37068 L
.07051 .35283 L
.0781 .34324 L
.08615 .3332 L
.09772 .32047 L
.10419 .31358 L
.11735 .30084 L
.12479 .29396 L
.13697 .28351 L
.14825 .27433 L
.15659 .26796 L
.17494 .25471 L
.17622 .25384 L
.19584 .24092 L
.20524 .23509 L
.21546 .22902 L
.23509 .21799 L
.23979 .21546 L
.25471 .20774 L
.27433 .19817 L
.27932 .19584 L
.29396 .18922 L
.31358 .18083 L
.3249 .17622 L
.3332 .17295 L
.35283 .16553 L
.37245 .15854 L
.37813 .15659 L
.39207 .15196 L
.4117 .14574 L
.43132 .13988 L
.44149 .13697 L
.45094 .13435 L
.47057 .12912 L
.49019 .12419 L
.50981 .11954 L
.51948 .11735 L
.52943 .11516 L
.54906 .11102 L
.56868 .10714 L
.5883 .10348 L
.60793 .10005 L
.62198 .09772 L
.62755 .09683 L
.64717 .09383 L
.6668 .09102 L
.68642 .08841 L
.70604 .08598 L
.72567 .08375 L
.74529 .08169 L
.76491 .0798 L
.78435 .0781 L
.78454 .07808 L
.80416 .07654 L
.82378 .07515 L
.84341 .07392 L
.86303 .07285 L
.88265 .07194 L
.90228 .07117 L
.9219 .07056 L
.94152 .07009 L
.96115 .06977 L
.98077 .06959 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .46835 m
.02324 .45094 L
.02755 .43132 L
.03851 .4117 L
.03885 .40673 L
.04549 .39207 L
.0574 .37245 L
.05848 .37068 L
.07051 .35283 L
.0781 .34324 L
.08615 .3332 L
.09772 .32047 L
.10419 .31358 L
.11735 .30084 L
.12479 .29396 L
.13697 .28351 L
.14825 .27433 L
.15659 .26796 L
.17494 .25471 L
.17622 .25384 L
.19584 .24092 L
.20524 .23509 L
.21546 .22902 L
.23509 .21799 L
.23979 .21546 L
.25471 .20774 L
.27433 .19817 L
.27932 .19584 L
.29396 .18922 L
.31358 .18083 L
.3249 .17622 L
.3332 .17295 L
.35283 .16553 L
.37245 .15854 L
.37813 .15659 L
.39207 .15196 L
.4117 .14574 L
.43132 .13988 L
.44149 .13697 L
.45094 .13435 L
.47057 .12912 L
.49019 .12419 L
.50981 .11954 L
.51948 .11735 L
.52943 .11516 L
.54906 .11102 L
.56868 .10714 L
.5883 .10348 L
.60793 .10005 L
.62198 .09772 L
Mistroke
.62755 .09683 L
.64717 .09383 L
.6668 .09102 L
.68642 .08841 L
.70604 .08598 L
.72567 .08375 L
.74529 .08169 L
.76491 .0798 L
.78435 .0781 L
.78454 .07808 L
.80416 .07654 L
.82378 .07515 L
.84341 .07392 L
.86303 .07285 L
.88265 .07194 L
.90228 .07117 L
.9219 .07056 L
.94152 .07009 L
.96115 .06977 L
.98077 .06959 L
Mfstroke
0 1 .7 r
.01923 .46947 m
.02397 .45094 L
.02896 .43132 L
.03881 .4117 L
.03885 .41129 L
.04886 .39207 L
.05848 .37825 L
.06214 .37245 L
.0781 .35321 L
.07841 .35283 L
.09725 .3332 L
.09772 .33276 L
.11735 .31534 L
.11944 .31358 L
.13697 .30016 L
.14564 .29396 L
.15659 .2867 L
.17622 .27464 L
.17674 .27433 L
.19584 .26376 L
.21371 .25471 L
.21546 .25387 L
.23509 .24486 L
.25471 .2366 L
.25849 .23509 L
.27433 .22904 L
.29396 .22209 L
.31358 .2157 L
.31433 .21546 L
.3332 .20982 L
.35283 .20443 L
.37245 .19947 L
.38798 .19584 L
.39207 .19493 L
.4117 .19077 L
.43132 .18699 L
.45094 .18355 L
.47057 .18044 L
.49019 .17765 L
.50116 .17622 L
.50981 .17516 L
.52943 .17296 L
.54906 .17105 L
.56868 .1694 L
.5883 .16802 L
.60793 .1669 L
.62755 .16603 L
.64717 .16541 L
.6668 .16502 L
.68642 .16487 L
.70604 .16496 L
.72567 .16528 L
.74529 .16582 L
.76491 .16659 L
.78454 .16759 L
.80416 .16881 L
.82378 .17026 L
.84341 .17193 L
.86303 .17383 L
.88265 .17595 L
.88494 .17622 L
.90228 .17831 L
.9219 .1809 L
.94152 .18373 L
.96115 .18679 L
.98077 .19011 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .46947 m
.02397 .45094 L
.02896 .43132 L
.03881 .4117 L
.03885 .41129 L
.04886 .39207 L
.05848 .37825 L
.06214 .37245 L
.0781 .35321 L
.07841 .35283 L
.09725 .3332 L
.09772 .33276 L
.11735 .31534 L
.11944 .31358 L
.13697 .30016 L
.14564 .29396 L
.15659 .2867 L
.17622 .27464 L
.17674 .27433 L
.19584 .26376 L
.21371 .25471 L
.21546 .25387 L
.23509 .24486 L
.25471 .2366 L
.25849 .23509 L
.27433 .22904 L
.29396 .22209 L
.31358 .2157 L
.31433 .21546 L
.3332 .20982 L
.35283 .20443 L
.37245 .19947 L
.38798 .19584 L
.39207 .19493 L
.4117 .19077 L
.43132 .18699 L
.45094 .18355 L
.47057 .18044 L
.49019 .17765 L
.50116 .17622 L
.50981 .17516 L
.52943 .17296 L
.54906 .17105 L
.56868 .1694 L
.5883 .16802 L
.60793 .1669 L
.62755 .16603 L
.64717 .16541 L
.6668 .16502 L
.68642 .16487 L
Mistroke
.70604 .16496 L
.72567 .16528 L
.74529 .16582 L
.76491 .16659 L
.78454 .16759 L
.80416 .16881 L
.82378 .17026 L
.84341 .17193 L
.86303 .17383 L
.88265 .17595 L
.88494 .17622 L
.90228 .17831 L
.9219 .1809 L
.94152 .18373 L
.96115 .18679 L
.98077 .19011 L
Mfstroke
0 1 1 r
.01923 .47049 m
.02472 .45094 L
.03046 .43132 L
.03885 .41575 L
.03957 .4117 L
.05293 .39207 L
.05848 .38515 L
.06822 .37245 L
.0781 .36241 L
.08755 .35283 L
.09772 .34411 L
.11119 .3332 L
.11735 .32878 L
.13697 .31563 L
.14022 .31358 L
.15659 .3042 L
.17622 .29415 L
.17661 .29396 L
.19584 .28526 L
.21546 .27738 L
.22364 .27433 L
.23509 .27037 L
.25471 .26414 L
.27433 .2586 L
.2897 .25471 L
.29396 .25371 L
.31358 .2494 L
.3332 .24563 L
.35283 .24237 L
.37245 .23959 L
.39207 .23726 L
.4117 .23536 L
.41471 .23509 L
.43132 .23387 L
.45094 .23278 L
.47057 .23207 L
.49019 .23174 L
.50981 .23178 L
.52943 .23217 L
.54906 .23292 L
.56868 .23403 L
.58345 .23509 L
.5883 .23548 L
.60793 .23729 L
.62755 .23944 L
.64717 .24196 L
.6668 .24484 L
.68642 .24809 L
.70604 .25172 L
.72083 .25471 L
.72567 .25574 L
.74529 .26016 L
.76491 .26502 L
.78454 .27032 L
.79832 .27433 L
.80416 .2761 L
.82378 .28239 L
.84341 .28923 L
.85605 .29396 L
.86303 .29667 L
.88265 .30478 L
.90213 .31358 L
.90228 .31365 L
.9219 .32336 L
.93998 .3332 L
.94152 .33408 L
.96115 .346 L
.9714 .35283 L
.98077 .35944 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .47049 m
.02472 .45094 L
.03046 .43132 L
.03885 .41575 L
.03957 .4117 L
.05293 .39207 L
.05848 .38515 L
.06822 .37245 L
.0781 .36241 L
.08755 .35283 L
.09772 .34411 L
.11119 .3332 L
.11735 .32878 L
.13697 .31563 L
.14022 .31358 L
.15659 .3042 L
.17622 .29415 L
.17661 .29396 L
.19584 .28526 L
.21546 .27738 L
.22364 .27433 L
.23509 .27037 L
.25471 .26414 L
.27433 .2586 L
.2897 .25471 L
.29396 .25371 L
.31358 .2494 L
.3332 .24563 L
.35283 .24237 L
.37245 .23959 L
.39207 .23726 L
.4117 .23536 L
.41471 .23509 L
.43132 .23387 L
.45094 .23278 L
.47057 .23207 L
.49019 .23174 L
.50981 .23178 L
.52943 .23217 L
.54906 .23292 L
.56868 .23403 L
.58345 .23509 L
.5883 .23548 L
.60793 .23729 L
.62755 .23944 L
.64717 .24196 L
.6668 .24484 L
.68642 .24809 L
.70604 .25172 L
.72083 .25471 L
Mistroke
.72567 .25574 L
.74529 .26016 L
.76491 .26502 L
.78454 .27032 L
.79832 .27433 L
.80416 .2761 L
.82378 .28239 L
.84341 .28923 L
.85605 .29396 L
.86303 .29667 L
.88265 .30478 L
.90213 .31358 L
.90228 .31365 L
.9219 .32336 L
.93998 .3332 L
.94152 .33408 L
.96115 .346 L
.9714 .35283 L
.98077 .35944 L
Mfstroke
0 1 .7 r
.01923 .52951 m
.02472 .54906 L
.03046 .56868 L
.03885 .58425 L
.03957 .5883 L
.05293 .60793 L
.05848 .61485 L
.06822 .62755 L
.0781 .63759 L
.08755 .64717 L
.09772 .65589 L
.11119 .6668 L
.11735 .67122 L
.13697 .68437 L
.14022 .68642 L
.15659 .6958 L
.17622 .70585 L
.17661 .70604 L
.19584 .71474 L
.21546 .72262 L
.22364 .72567 L
.23509 .72963 L
.25471 .73586 L
.27433 .7414 L
.2897 .74529 L
.29396 .74629 L
.31358 .7506 L
.3332 .75437 L
.35283 .75763 L
.37245 .76041 L
.39207 .76274 L
.4117 .76464 L
.41471 .76491 L
.43132 .76613 L
.45094 .76722 L
.47057 .76793 L
.49019 .76826 L
.50981 .76822 L
.52943 .76783 L
.54906 .76708 L
.56868 .76597 L
.58345 .76491 L
.5883 .76452 L
.60793 .76271 L
.62755 .76056 L
.64717 .75804 L
.6668 .75516 L
.68642 .75191 L
.70604 .74828 L
.72083 .74529 L
.72567 .74426 L
.74529 .73984 L
.76491 .73498 L
.78454 .72968 L
.79832 .72567 L
.80416 .7239 L
.82378 .71761 L
.84341 .71077 L
.85605 .70604 L
.86303 .70333 L
.88265 .69522 L
.90213 .68642 L
.90228 .68635 L
.9219 .67664 L
.93998 .6668 L
.94152 .66592 L
.96115 .654 L
.9714 .64717 L
.98077 .64056 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .52951 m
.02472 .54906 L
.03046 .56868 L
.03885 .58425 L
.03957 .5883 L
.05293 .60793 L
.05848 .61485 L
.06822 .62755 L
.0781 .63759 L
.08755 .64717 L
.09772 .65589 L
.11119 .6668 L
.11735 .67122 L
.13697 .68437 L
.14022 .68642 L
.15659 .6958 L
.17622 .70585 L
.17661 .70604 L
.19584 .71474 L
.21546 .72262 L
.22364 .72567 L
.23509 .72963 L
.25471 .73586 L
.27433 .7414 L
.2897 .74529 L
.29396 .74629 L
.31358 .7506 L
.3332 .75437 L
.35283 .75763 L
.37245 .76041 L
.39207 .76274 L
.4117 .76464 L
.41471 .76491 L
.43132 .76613 L
.45094 .76722 L
.47057 .76793 L
.49019 .76826 L
.50981 .76822 L
.52943 .76783 L
.54906 .76708 L
.56868 .76597 L
.58345 .76491 L
.5883 .76452 L
.60793 .76271 L
.62755 .76056 L
.64717 .75804 L
.6668 .75516 L
.68642 .75191 L
.70604 .74828 L
.72083 .74529 L
Mistroke
.72567 .74426 L
.74529 .73984 L
.76491 .73498 L
.78454 .72968 L
.79832 .72567 L
.80416 .7239 L
.82378 .71761 L
.84341 .71077 L
.85605 .70604 L
.86303 .70333 L
.88265 .69522 L
.90213 .68642 L
.90228 .68635 L
.9219 .67664 L
.93998 .6668 L
.94152 .66592 L
.96115 .654 L
.9714 .64717 L
.98077 .64056 L
Mfstroke
0 1 .4 r
.01923 .53053 m
.02397 .54906 L
.02896 .56868 L
.03881 .5883 L
.03885 .58871 L
.04886 .60793 L
.05848 .62175 L
.06214 .62755 L
.0781 .64679 L
.07841 .64717 L
.09725 .6668 L
.09772 .66724 L
.11735 .68466 L
.11944 .68642 L
.13697 .69984 L
.14564 .70604 L
.15659 .7133 L
.17622 .72536 L
.17674 .72567 L
.19584 .73624 L
.21371 .74529 L
.21546 .74613 L
.23509 .75514 L
.25471 .7634 L
.25849 .76491 L
.27433 .77096 L
.29396 .77791 L
.31358 .7843 L
.31433 .78454 L
.3332 .79018 L
.35283 .79557 L
.37245 .80053 L
.38798 .80416 L
.39207 .80507 L
.4117 .80923 L
.43132 .81301 L
.45094 .81645 L
.47057 .81956 L
.49019 .82235 L
.50116 .82378 L
.50981 .82484 L
.52943 .82704 L
.54906 .82895 L
.56868 .8306 L
.5883 .83198 L
.60793 .8331 L
.62755 .83397 L
.64717 .83459 L
.6668 .83498 L
.68642 .83513 L
.70604 .83504 L
.72567 .83472 L
.74529 .83418 L
.76491 .83341 L
.78454 .83241 L
.80416 .83119 L
.82378 .82974 L
.84341 .82807 L
.86303 .82617 L
.88265 .82405 L
.88494 .82378 L
.90228 .82169 L
.9219 .8191 L
.94152 .81627 L
.96115 .81321 L
.98077 .80989 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .53053 m
.02397 .54906 L
.02896 .56868 L
.03881 .5883 L
.03885 .58871 L
.04886 .60793 L
.05848 .62175 L
.06214 .62755 L
.0781 .64679 L
.07841 .64717 L
.09725 .6668 L
.09772 .66724 L
.11735 .68466 L
.11944 .68642 L
.13697 .69984 L
.14564 .70604 L
.15659 .7133 L
.17622 .72536 L
.17674 .72567 L
.19584 .73624 L
.21371 .74529 L
.21546 .74613 L
.23509 .75514 L
.25471 .7634 L
.25849 .76491 L
.27433 .77096 L
.29396 .77791 L
.31358 .7843 L
.31433 .78454 L
.3332 .79018 L
.35283 .79557 L
.37245 .80053 L
.38798 .80416 L
.39207 .80507 L
.4117 .80923 L
.43132 .81301 L
.45094 .81645 L
.47057 .81956 L
.49019 .82235 L
.50116 .82378 L
.50981 .82484 L
.52943 .82704 L
.54906 .82895 L
.56868 .8306 L
.5883 .83198 L
.60793 .8331 L
.62755 .83397 L
.64717 .83459 L
.6668 .83498 L
.68642 .83513 L
Mistroke
.70604 .83504 L
.72567 .83472 L
.74529 .83418 L
.76491 .83341 L
.78454 .83241 L
.80416 .83119 L
.82378 .82974 L
.84341 .82807 L
.86303 .82617 L
.88265 .82405 L
.88494 .82378 L
.90228 .82169 L
.9219 .8191 L
.94152 .81627 L
.96115 .81321 L
.98077 .80989 L
Mfstroke
0 1 .1 r
.01923 .53165 m
.02324 .54906 L
.02755 .56868 L
.03851 .5883 L
.03885 .59327 L
.04549 .60793 L
.0574 .62755 L
.05848 .62932 L
.07051 .64717 L
.0781 .65676 L
.08615 .6668 L
.09772 .67953 L
.10419 .68642 L
.11735 .69916 L
.12479 .70604 L
.13697 .71649 L
.14825 .72567 L
.15659 .73204 L
.17494 .74529 L
.17622 .74616 L
.19584 .75908 L
.20524 .76491 L
.21546 .77098 L
.23509 .78201 L
.23979 .78454 L
.25471 .79226 L
.27433 .80183 L
.27932 .80416 L
.29396 .81078 L
.31358 .81917 L
.3249 .82378 L
.3332 .82705 L
.35283 .83447 L
.37245 .84146 L
.37813 .84341 L
.39207 .84804 L
.4117 .85426 L
.43132 .86012 L
.44149 .86303 L
.45094 .86565 L
.47057 .87088 L
.49019 .87581 L
.50981 .88046 L
.51948 .88265 L
.52943 .88484 L
.54906 .88898 L
.56868 .89286 L
.5883 .89652 L
.60793 .89995 L
.62198 .90228 L
.62755 .90317 L
.64717 .90617 L
.6668 .90898 L
.68642 .91159 L
.70604 .91402 L
.72567 .91625 L
.74529 .91831 L
.76491 .9202 L
.78435 .9219 L
.78454 .92192 L
.80416 .92346 L
.82378 .92485 L
.84341 .92608 L
.86303 .92715 L
.88265 .92806 L
.90228 .92883 L
.9219 .92944 L
.94152 .92991 L
.96115 .93023 L
.98077 .93041 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .53165 m
.02324 .54906 L
.02755 .56868 L
.03851 .5883 L
.03885 .59327 L
.04549 .60793 L
.0574 .62755 L
.05848 .62932 L
.07051 .64717 L
.0781 .65676 L
.08615 .6668 L
.09772 .67953 L
.10419 .68642 L
.11735 .69916 L
.12479 .70604 L
.13697 .71649 L
.14825 .72567 L
.15659 .73204 L
.17494 .74529 L
.17622 .74616 L
.19584 .75908 L
.20524 .76491 L
.21546 .77098 L
.23509 .78201 L
.23979 .78454 L
.25471 .79226 L
.27433 .80183 L
.27932 .80416 L
.29396 .81078 L
.31358 .81917 L
.3249 .82378 L
.3332 .82705 L
.35283 .83447 L
.37245 .84146 L
.37813 .84341 L
.39207 .84804 L
.4117 .85426 L
.43132 .86012 L
.44149 .86303 L
.45094 .86565 L
.47057 .87088 L
.49019 .87581 L
.50981 .88046 L
.51948 .88265 L
.52943 .88484 L
.54906 .88898 L
.56868 .89286 L
.5883 .89652 L
.60793 .89995 L
.62198 .90228 L
Mistroke
.62755 .90317 L
.64717 .90617 L
.6668 .90898 L
.68642 .91159 L
.70604 .91402 L
.72567 .91625 L
.74529 .91831 L
.76491 .9202 L
.78435 .9219 L
.78454 .92192 L
.80416 .92346 L
.82378 .92485 L
.84341 .92608 L
.86303 .92715 L
.88265 .92806 L
.90228 .92883 L
.9219 .92944 L
.94152 .92991 L
.96115 .93023 L
.98077 .93041 L
Mfstroke
0 .7 1 r
.01923 .52894 m
.01973 .52943 L
.02552 .54906 L
.03208 .56868 L
.03885 .58015 L
.04113 .5883 L
.05791 .60793 L
.05848 .60854 L
.07633 .62755 L
.0781 .62907 L
.09772 .64528 L
.10009 .64717 L
.11735 .65858 L
.13133 .6668 L
.13697 .66972 L
.15659 .67916 L
.17411 .68642 L
.17622 .68721 L
.19584 .69407 L
.21546 .69991 L
.23509 .70484 L
.24029 .70604 L
.25471 .70896 L
.27433 .71233 L
.29396 .71501 L
.31358 .71705 L
.3332 .71848 L
.35283 .71933 L
.37245 .71962 L
.39207 .71937 L
.4117 .71858 L
.43132 .71727 L
.45094 .71544 L
.47057 .71307 L
.49019 .71018 L
.50981 .70674 L
.51341 .70604 L
.52943 .70273 L
.54906 .69814 L
.56868 .69292 L
.5883 .68704 L
.59023 .68642 L
.60793 .68044 L
.62755 .67304 L
.64252 .6668 L
.64717 .66475 L
.6668 .65544 L
.68238 .64717 L
.68642 .6449 L
.70604 .63288 L
.71388 .62755 L
.72567 .61893 L
.73901 .60793 L
.74529 .60226 L
.75886 .5883 L
.76491 .58128 L
.77414 .56868 L
.78454 .55069 L
.78528 .54906 L
.79257 .52943 L
.79617 .50981 L
.79617 .49019 L
.79257 .47057 L
.78528 .45094 L
.78454 .44931 L
.77414 .43132 L
.76491 .41872 L
.75886 .4117 L
.74529 .39774 L
.73901 .39207 L
.72567 .38107 L
.71388 .37245 L
.70604 .36712 L
.68642 .3551 L
.68238 .35283 L
.6668 .34456 L
.64717 .33525 L
.64252 .3332 L
.62755 .32696 L
.60793 .31956 L
.59023 .31358 L
.5883 .31296 L
.56868 .30708 L
.54906 .30186 L
.52943 .29727 L
.51341 .29396 L
.50981 .29326 L
.49019 .28982 L
.47057 .28693 L
.45094 .28456 L
.43132 .28273 L
.4117 .28142 L
.39207 .28063 L
.37245 .28038 L
.35283 .28067 L
.3332 .28152 L
.31358 .28295 L
.29396 .28499 L
.27433 .28767 L
.25471 .29104 L
.24029 .29396 L
.23509 .29516 L
.21546 .30009 L
.19584 .30593 L
.17622 .31279 L
.17411 .31358 L
.15659 .32084 L
.13697 .33028 L
.13133 .3332 L
.11735 .34142 L
.10009 .35283 L
.09772 .35472 L
.0781 .37093 L
.07633 .37245 L
.05848 .39146 L
.05791 .39207 L
.04113 .4117 L
.03885 .41985 L
.03208 .43132 L
.02552 .45094 L
.01973 .47057 L
.01923 .47106 L
F
0 g
.01923 .52894 m
.01973 .52943 L
.02552 .54906 L
.03208 .56868 L
.03885 .58015 L
.04113 .5883 L
.05791 .60793 L
.05848 .60854 L
.07633 .62755 L
.0781 .62907 L
.09772 .64528 L
.10009 .64717 L
.11735 .65858 L
.13133 .6668 L
.13697 .66972 L
.15659 .67916 L
.17411 .68642 L
.17622 .68721 L
.19584 .69407 L
.21546 .69991 L
.23509 .70484 L
.24029 .70604 L
.25471 .70896 L
.27433 .71233 L
.29396 .71501 L
.31358 .71705 L
.3332 .71848 L
.35283 .71933 L
.37245 .71962 L
.39207 .71937 L
.4117 .71858 L
.43132 .71727 L
.45094 .71544 L
.47057 .71307 L
.49019 .71018 L
.50981 .70674 L
.51341 .70604 L
.52943 .70273 L
.54906 .69814 L
.56868 .69292 L
.5883 .68704 L
.59023 .68642 L
.60793 .68044 L
.62755 .67304 L
.64252 .6668 L
.64717 .66475 L
.6668 .65544 L
.68238 .64717 L
.68642 .6449 L
.70604 .63288 L
Mistroke
.71388 .62755 L
.72567 .61893 L
.73901 .60793 L
.74529 .60226 L
.75886 .5883 L
.76491 .58128 L
.77414 .56868 L
.78454 .55069 L
.78528 .54906 L
.79257 .52943 L
.79617 .50981 L
.79617 .49019 L
.79257 .47057 L
.78528 .45094 L
.78454 .44931 L
.77414 .43132 L
.76491 .41872 L
.75886 .4117 L
.74529 .39774 L
.73901 .39207 L
.72567 .38107 L
.71388 .37245 L
.70604 .36712 L
.68642 .3551 L
.68238 .35283 L
.6668 .34456 L
.64717 .33525 L
.64252 .3332 L
.62755 .32696 L
.60793 .31956 L
.59023 .31358 L
.5883 .31296 L
.56868 .30708 L
.54906 .30186 L
.52943 .29727 L
.51341 .29396 L
.50981 .29326 L
.49019 .28982 L
.47057 .28693 L
.45094 .28456 L
.43132 .28273 L
.4117 .28142 L
.39207 .28063 L
.37245 .28038 L
.35283 .28067 L
.3332 .28152 L
.31358 .28295 L
.29396 .28499 L
.27433 .28767 L
.25471 .29104 L
Mistroke
.24029 .29396 L
.23509 .29516 L
.21546 .30009 L
.19584 .30593 L
.17622 .31279 L
.17411 .31358 L
.15659 .32084 L
.13697 .33028 L
.13133 .3332 L
.11735 .34142 L
.10009 .35283 L
.09772 .35472 L
.0781 .37093 L
.07633 .37245 L
.05848 .39146 L
.05791 .39207 L
.04113 .4117 L
.03885 .41985 L
.03208 .43132 L
.02552 .45094 L
.01973 .47057 L
.01923 .47106 L
Mfstroke
.2 1 0 r
.01923 .46711 m
.02254 .45094 L
.02624 .43132 L
.03837 .4117 L
.03885 .40137 L
.04258 .39207 L
.05313 .37245 L
.05848 .36231 L
.06395 .35283 L
.0773 .3332 L
.0781 .33211 L
.09213 .31358 L
.09772 .30687 L
.10887 .29396 L
.11735 .28487 L
.12757 .27433 L
.13697 .26525 L
.14835 .25471 L
.15659 .24747 L
.17135 .23509 L
.17622 .23119 L
.19584 .21614 L
.19675 .21546 L
.21546 .20213 L
.22472 .19584 L
.23509 .18904 L
.25471 .17673 L
.25555 .17622 L
.27433 .16512 L
.28948 .15659 L
.29396 .15414 L
.31358 .14373 L
.32688 .13697 L
.3332 .13384 L
.35283 .12442 L
.36818 .11735 L
.37245 .11543 L
.39207 .10684 L
.4117 .09863 L
.41391 .09772 L
.43132 .09076 L
.45094 .08323 L
.46476 .0781 L
.47057 .07599 L
.49019 .06905 L
.50981 .06238 L
.52166 .05848 L
.52943 .05597 L
.54906 .0498 L
.56868 .04387 L
.58588 .03885 L
.5883 .03816 L
.60793 .03267 L
.62755 .02737 L
.64717 .02228 L
.65927 .01923 L
.01923 .01923 L
F
0 g
.01923 .46711 m
.02254 .45094 L
.02624 .43132 L
.03837 .4117 L
.03885 .40137 L
.04258 .39207 L
.05313 .37245 L
.05848 .36231 L
.06395 .35283 L
.0773 .3332 L
.0781 .33211 L
.09213 .31358 L
.09772 .30687 L
.10887 .29396 L
.11735 .28487 L
.12757 .27433 L
.13697 .26525 L
.14835 .25471 L
.15659 .24747 L
.17135 .23509 L
.17622 .23119 L
.19584 .21614 L
.19675 .21546 L
.21546 .20213 L
.22472 .19584 L
.23509 .18904 L
.25471 .17673 L
.25555 .17622 L
.27433 .16512 L
.28948 .15659 L
.29396 .15414 L
.31358 .14373 L
.32688 .13697 L
.3332 .13384 L
.35283 .12442 L
.36818 .11735 L
.37245 .11543 L
.39207 .10684 L
.4117 .09863 L
.41391 .09772 L
.43132 .09076 L
.45094 .08323 L
.46476 .0781 L
.47057 .07599 L
.49019 .06905 L
.50981 .06238 L
.52166 .05848 L
.52943 .05597 L
.54906 .0498 L
.56868 .04387 L
Mistroke
.58588 .03885 L
.5883 .03816 L
.60793 .03267 L
.62755 .02737 L
.64717 .02228 L
.65927 .01923 L
Mfstroke
.2 1 0 r
.01923 .53289 m
.02254 .54906 L
.02624 .56868 L
.03837 .5883 L
.03885 .59863 L
.04258 .60793 L
.05313 .62755 L
.05848 .63769 L
.06395 .64717 L
.0773 .6668 L
.0781 .66789 L
.09213 .68642 L
.09772 .69313 L
.10887 .70604 L
.11735 .71513 L
.12757 .72567 L
.13697 .73475 L
.14835 .74529 L
.15659 .75253 L
.17135 .76491 L
.17622 .76881 L
.19584 .78386 L
.19675 .78454 L
.21546 .79787 L
.22472 .80416 L
.23509 .81096 L
.25471 .82327 L
.25555 .82378 L
.27433 .83488 L
.28948 .84341 L
.29396 .84586 L
.31358 .85627 L
.32688 .86303 L
.3332 .86616 L
.35283 .87558 L
.36818 .88265 L
.37245 .88457 L
.39207 .89316 L
.4117 .90137 L
.41391 .90228 L
.43132 .90924 L
.45094 .91677 L
.46476 .9219 L
.47057 .92401 L
.49019 .93095 L
.50981 .93762 L
.52166 .94152 L
.52943 .94403 L
.54906 .9502 L
.56868 .95613 L
.58588 .96115 L
.5883 .96184 L
.60793 .96733 L
.62755 .97263 L
.64717 .97772 L
.65927 .98077 L
.01923 .98077 L
F
0 g
.01923 .53289 m
.02254 .54906 L
.02624 .56868 L
.03837 .5883 L
.03885 .59863 L
.04258 .60793 L
.05313 .62755 L
.05848 .63769 L
.06395 .64717 L
.0773 .6668 L
.0781 .66789 L
.09213 .68642 L
.09772 .69313 L
.10887 .70604 L
.11735 .71513 L
.12757 .72567 L
.13697 .73475 L
.14835 .74529 L
.15659 .75253 L
.17135 .76491 L
.17622 .76881 L
.19584 .78386 L
.19675 .78454 L
.21546 .79787 L
.22472 .80416 L
.23509 .81096 L
.25471 .82327 L
.25555 .82378 L
.27433 .83488 L
.28948 .84341 L
.29396 .84586 L
.31358 .85627 L
.32688 .86303 L
.3332 .86616 L
.35283 .87558 L
.36818 .88265 L
.37245 .88457 L
.39207 .89316 L
.4117 .90137 L
.41391 .90228 L
.43132 .90924 L
.45094 .91677 L
.46476 .9219 L
.47057 .92401 L
.49019 .93095 L
.50981 .93762 L
.52166 .94152 L
.52943 .94403 L
.54906 .9502 L
.56868 .95613 L
Mistroke
.58588 .96115 L
.5883 .96184 L
.60793 .96733 L
.62755 .97263 L
.64717 .97772 L
.65927 .98077 L
Mfstroke
0 .4 1 r
.01923 .52842 m
.02029 .52943 L
.02636 .54906 L
.03384 .56868 L
.03885 .57642 L
.0438 .5883 L
.05848 .60255 L
.06226 .60793 L
.0781 .62102 L
.0858 .62755 L
.09772 .63521 L
.11735 .64652 L
.11849 .64717 L
.13697 .65565 L
.15659 .66307 L
.168 .6668 L
.17622 .66905 L
.19584 .67381 L
.21546 .67748 L
.23509 .68017 L
.25471 .68196 L
.27433 .6829 L
.29396 .68305 L
.31358 .68242 L
.3332 .68103 L
.35283 .67889 L
.37245 .67599 L
.39207 .67231 L
.4117 .66781 L
.41566 .6668 L
.43132 .66246 L
.45094 .65617 L
.47057 .64883 L
.47462 .64717 L
.49019 .64034 L
.50981 .63043 L
.51497 .62755 L
.52943 .61883 L
.5451 .60793 L
.54906 .60492 L
.56804 .5883 L
.56868 .58768 L
.58529 .56868 L
.5883 .56472 L
.59769 .54906 L
.60573 .52943 L
.60793 .52096 L
.60969 .50981 L
.60969 .49019 L
.60793 .47904 L
.60573 .47057 L
.59769 .45094 L
.5883 .43528 L
.58529 .43132 L
.56868 .41232 L
.56804 .4117 L
.54906 .39508 L
.5451 .39207 L
.52943 .38117 L
.51497 .37245 L
.50981 .36957 L
.49019 .35966 L
.47462 .35283 L
.47057 .35117 L
.45094 .34383 L
.43132 .33754 L
.41566 .3332 L
.4117 .33219 L
.39207 .32769 L
.37245 .32401 L
.35283 .32111 L
.3332 .31897 L
.31358 .31758 L
.29396 .31695 L
.27433 .3171 L
.25471 .31804 L
.23509 .31983 L
.21546 .32252 L
.19584 .32619 L
.17622 .33095 L
.168 .3332 L
.15659 .33693 L
.13697 .34435 L
.11849 .35283 L
.11735 .35348 L
.09772 .36479 L
.0858 .37245 L
.0781 .37898 L
.06226 .39207 L
.05848 .39745 L
.0438 .4117 L
.03885 .42358 L
.03384 .43132 L
.02636 .45094 L
.02029 .47057 L
.01923 .47158 L
F
0 g
.01923 .52842 m
.02029 .52943 L
.02636 .54906 L
.03384 .56868 L
.03885 .57642 L
.0438 .5883 L
.05848 .60255 L
.06226 .60793 L
.0781 .62102 L
.0858 .62755 L
.09772 .63521 L
.11735 .64652 L
.11849 .64717 L
.13697 .65565 L
.15659 .66307 L
.168 .6668 L
.17622 .66905 L
.19584 .67381 L
.21546 .67748 L
.23509 .68017 L
.25471 .68196 L
.27433 .6829 L
.29396 .68305 L
.31358 .68242 L
.3332 .68103 L
.35283 .67889 L
.37245 .67599 L
.39207 .67231 L
.4117 .66781 L
.41566 .6668 L
.43132 .66246 L
.45094 .65617 L
.47057 .64883 L
.47462 .64717 L
.49019 .64034 L
.50981 .63043 L
.51497 .62755 L
.52943 .61883 L
.5451 .60793 L
.54906 .60492 L
.56804 .5883 L
.56868 .58768 L
.58529 .56868 L
.5883 .56472 L
.59769 .54906 L
.60573 .52943 L
.60793 .52096 L
.60969 .50981 L
.60969 .49019 L
.60793 .47904 L
Mistroke
.60573 .47057 L
.59769 .45094 L
.5883 .43528 L
.58529 .43132 L
.56868 .41232 L
.56804 .4117 L
.54906 .39508 L
.5451 .39207 L
.52943 .38117 L
.51497 .37245 L
.50981 .36957 L
.49019 .35966 L
.47462 .35283 L
.47057 .35117 L
.45094 .34383 L
.43132 .33754 L
.41566 .3332 L
.4117 .33219 L
.39207 .32769 L
.37245 .32401 L
.35283 .32111 L
.3332 .31897 L
.31358 .31758 L
.29396 .31695 L
.27433 .3171 L
.25471 .31804 L
.23509 .31983 L
.21546 .32252 L
.19584 .32619 L
.17622 .33095 L
.168 .3332 L
.15659 .33693 L
.13697 .34435 L
.11849 .35283 L
.11735 .35348 L
.09772 .36479 L
.0858 .37245 L
.0781 .37898 L
.06226 .39207 L
.05848 .39745 L
.0438 .4117 L
.03885 .42358 L
.03384 .43132 L
.02636 .45094 L
.02029 .47057 L
.01923 .47158 L
Mfstroke
0 .1 1 r
.01923 .5279 m
.02087 .52943 L
.02725 .54906 L
.03578 .56868 L
.03885 .57299 L
.04791 .5883 L
.05848 .59691 L
.06972 .60793 L
.0781 .61335 L
.09772 .62556 L
.10082 .62755 L
.11735 .63484 L
.13697 .64193 L
.1563 .64717 L
.15659 .64724 L
.17622 .65103 L
.19584 .6535 L
.21546 .65476 L
.23509 .65489 L
.25471 .65395 L
.27433 .65195 L
.29396 .64889 L
.30271 .64717 L
.31358 .64474 L
.3332 .63944 L
.35283 .63288 L
.36628 .62755 L
.37245 .62488 L
.39207 .61521 L
.40459 .60793 L
.4117 .6034 L
.43132 .58859 L
.43165 .5883 L
.45094 .56904 L
.45124 .56868 L
.46502 .54906 L
.47057 .53912 L
.47384 .52943 L
.47815 .50981 L
.47815 .49019 L
.47384 .47057 L
.47057 .46088 L
.46502 .45094 L
.45124 .43132 L
.45094 .43096 L
.43165 .4117 L
.43132 .41141 L
.4117 .3966 L
.40459 .39207 L
.39207 .38479 L
.37245 .37512 L
.36628 .37245 L
.35283 .36712 L
.3332 .36056 L
.31358 .35526 L
.30271 .35283 L
.29396 .35111 L
.27433 .34805 L
.25471 .34605 L
.23509 .34511 L
.21546 .34524 L
.19584 .3465 L
.17622 .34897 L
.15659 .35276 L
.1563 .35283 L
.13697 .35807 L
.11735 .36516 L
.10082 .37245 L
.09772 .37444 L
.0781 .38665 L
.06972 .39207 L
.05848 .40309 L
.04791 .4117 L
.03885 .42701 L
.03578 .43132 L
.02725 .45094 L
.02087 .47057 L
.01923 .4721 L
F
0 g
.01923 .5279 m
.02087 .52943 L
.02725 .54906 L
.03578 .56868 L
.03885 .57299 L
.04791 .5883 L
.05848 .59691 L
.06972 .60793 L
.0781 .61335 L
.09772 .62556 L
.10082 .62755 L
.11735 .63484 L
.13697 .64193 L
.1563 .64717 L
.15659 .64724 L
.17622 .65103 L
.19584 .6535 L
.21546 .65476 L
.23509 .65489 L
.25471 .65395 L
.27433 .65195 L
.29396 .64889 L
.30271 .64717 L
.31358 .64474 L
.3332 .63944 L
.35283 .63288 L
.36628 .62755 L
.37245 .62488 L
.39207 .61521 L
.40459 .60793 L
.4117 .6034 L
.43132 .58859 L
.43165 .5883 L
.45094 .56904 L
.45124 .56868 L
.46502 .54906 L
.47057 .53912 L
.47384 .52943 L
.47815 .50981 L
.47815 .49019 L
.47384 .47057 L
.47057 .46088 L
.46502 .45094 L
.45124 .43132 L
.45094 .43096 L
.43165 .4117 L
.43132 .41141 L
.4117 .3966 L
.40459 .39207 L
.39207 .38479 L
Mistroke
.37245 .37512 L
.36628 .37245 L
.35283 .36712 L
.3332 .36056 L
.31358 .35526 L
.30271 .35283 L
.29396 .35111 L
.27433 .34805 L
.25471 .34605 L
.23509 .34511 L
.21546 .34524 L
.19584 .3465 L
.17622 .34897 L
.15659 .35276 L
.1563 .35283 L
.13697 .35807 L
.11735 .36516 L
.10082 .37245 L
.09772 .37444 L
.0781 .38665 L
.06972 .39207 L
.05848 .40309 L
.04791 .4117 L
.03885 .42701 L
.03578 .43132 L
.02725 .45094 L
.02087 .47057 L
.01923 .4721 L
Mfstroke
.5 1 0 r
.01923 .46571 m
.02187 .45094 L
.02499 .43132 L
.03806 .4117 L
.03885 .39497 L
.03991 .39207 L
.04928 .37245 L
.0584 .35283 L
.05848 .35262 L
.06946 .3332 L
.0781 .31952 L
.08195 .31358 L
.09585 .29396 L
.09772 .29148 L
.11111 .27433 L
.11735 .26686 L
.12785 .25471 L
.13697 .24473 L
.14611 .23509 L
.15659 .22454 L
.16594 .21546 L
.17622 .20589 L
.18741 .19584 L
.19584 .18854 L
.21059 .17622 L
.21546 .17228 L
.23509 .15696 L
.23557 .15659 L
.25471 .14247 L
.26242 .13697 L
.27433 .1287 L
.29127 .11735 L
.29396 .11559 L
.31358 .10307 L
.32222 .09772 L
.3332 .09108 L
.35283 .07957 L
.3554 .0781 L
.37245 .06852 L
.39095 .05848 L
.39207 .05788 L
.4117 .04762 L
.42904 .03885 L
.43132 .03772 L
.45094 .02815 L
.46985 .01923 L
.01923 .01923 L
F
0 g
.01923 .46571 m
.02187 .45094 L
.02499 .43132 L
.03806 .4117 L
.03885 .39497 L
.03991 .39207 L
.04928 .37245 L
.0584 .35283 L
.05848 .35262 L
.06946 .3332 L
.0781 .31952 L
.08195 .31358 L
.09585 .29396 L
.09772 .29148 L
.11111 .27433 L
.11735 .26686 L
.12785 .25471 L
.13697 .24473 L
.14611 .23509 L
.15659 .22454 L
.16594 .21546 L
.17622 .20589 L
.18741 .19584 L
.19584 .18854 L
.21059 .17622 L
.21546 .17228 L
.23509 .15696 L
.23557 .15659 L
.25471 .14247 L
.26242 .13697 L
.27433 .1287 L
.29127 .11735 L
.29396 .11559 L
.31358 .10307 L
.32222 .09772 L
.3332 .09108 L
.35283 .07957 L
.3554 .0781 L
.37245 .06852 L
.39095 .05848 L
.39207 .05788 L
.4117 .04762 L
.42904 .03885 L
.43132 .03772 L
.45094 .02815 L
.46985 .01923 L
s
.5 1 0 r
.01923 .53429 m
.02187 .54906 L
.02499 .56868 L
.03806 .5883 L
.03885 .60503 L
.03991 .60793 L
.04928 .62755 L
.0584 .64717 L
.05848 .64738 L
.06946 .6668 L
.0781 .68048 L
.08195 .68642 L
.09585 .70604 L
.09772 .70852 L
.11111 .72567 L
.11735 .73314 L
.12785 .74529 L
.13697 .75527 L
.14611 .76491 L
.15659 .77546 L
.16594 .78454 L
.17622 .79411 L
.18741 .80416 L
.19584 .81146 L
.21059 .82378 L
.21546 .82772 L
.23509 .84304 L
.23557 .84341 L
.25471 .85753 L
.26242 .86303 L
.27433 .8713 L
.29127 .88265 L
.29396 .88441 L
.31358 .89693 L
.32222 .90228 L
.3332 .90892 L
.35283 .92043 L
.3554 .9219 L
.37245 .93148 L
.39095 .94152 L
.39207 .94212 L
.4117 .95238 L
.42904 .96115 L
.43132 .96228 L
.45094 .97185 L
.46985 .98077 L
.01923 .98077 L
F
0 g
.01923 .53429 m
.02187 .54906 L
.02499 .56868 L
.03806 .5883 L
.03885 .60503 L
.03991 .60793 L
.04928 .62755 L
.0584 .64717 L
.05848 .64738 L
.06946 .6668 L
.0781 .68048 L
.08195 .68642 L
.09585 .70604 L
.09772 .70852 L
.11111 .72567 L
.11735 .73314 L
.12785 .74529 L
.13697 .75527 L
.14611 .76491 L
.15659 .77546 L
.16594 .78454 L
.17622 .79411 L
.18741 .80416 L
.19584 .81146 L
.21059 .82378 L
.21546 .82772 L
.23509 .84304 L
.23557 .84341 L
.25471 .85753 L
.26242 .86303 L
.27433 .8713 L
.29127 .88265 L
.29396 .88441 L
.31358 .89693 L
.32222 .90228 L
.3332 .90892 L
.35283 .92043 L
.3554 .9219 L
.37245 .93148 L
.39095 .94152 L
.39207 .94212 L
.4117 .95238 L
.42904 .96115 L
.43132 .96228 L
.45094 .97185 L
.46985 .98077 L
s
.2 0 1 r
.01923 .5274 m
.02147 .52943 L
.02819 .54906 L
.03796 .56868 L
.03885 .56982 L
.05376 .5883 L
.05848 .59155 L
.0781 .60599 L
.08127 .60793 L
.09772 .61617 L
.11735 .6234 L
.13245 .62755 L
.13697 .62833 L
.15659 .63137 L
.17622 .63274 L
.19584 .63259 L
.21546 .63099 L
.23509 .62795 L
.23713 .62755 L
.25471 .62344 L
.27433 .61734 L
.29396 .60941 L
.29714 .60793 L
.31358 .59936 L
.33055 .5883 L
.3332 .58638 L
.35283 .56896 L
.35308 .56868 L
.36841 .54906 L
.37245 .54316 L
.37805 .52943 L
.38272 .50981 L
.38272 .49019 L
.37805 .47057 L
.37245 .45684 L
.36841 .45094 L
.35308 .43132 L
.35283 .43104 L
.3332 .41362 L
.33055 .4117 L
.31358 .40064 L
.29714 .39207 L
.29396 .39059 L
.27433 .38266 L
.25471 .37656 L
.23713 .37245 L
.23509 .37205 L
.21546 .36901 L
.19584 .36741 L
.17622 .36726 L
.15659 .36863 L
.13697 .37167 L
.13245 .37245 L
.11735 .3766 L
.09772 .38383 L
.08127 .39207 L
.0781 .39401 L
.05848 .40845 L
.05376 .4117 L
.03885 .43018 L
.03796 .43132 L
.02819 .45094 L
.02147 .47057 L
.01923 .4726 L
F
0 g
.01923 .5274 m
.02147 .52943 L
.02819 .54906 L
.03796 .56868 L
.03885 .56982 L
.05376 .5883 L
.05848 .59155 L
.0781 .60599 L
.08127 .60793 L
.09772 .61617 L
.11735 .6234 L
.13245 .62755 L
.13697 .62833 L
.15659 .63137 L
.17622 .63274 L
.19584 .63259 L
.21546 .63099 L
.23509 .62795 L
.23713 .62755 L
.25471 .62344 L
.27433 .61734 L
.29396 .60941 L
.29714 .60793 L
.31358 .59936 L
.33055 .5883 L
.3332 .58638 L
.35283 .56896 L
.35308 .56868 L
.36841 .54906 L
.37245 .54316 L
.37805 .52943 L
.38272 .50981 L
.38272 .49019 L
.37805 .47057 L
.37245 .45684 L
.36841 .45094 L
.35308 .43132 L
.35283 .43104 L
.3332 .41362 L
.33055 .4117 L
.31358 .40064 L
.29714 .39207 L
.29396 .39059 L
.27433 .38266 L
.25471 .37656 L
.23713 .37245 L
.23509 .37205 L
.21546 .36901 L
.19584 .36741 L
.17622 .36726 L
Mistroke
.15659 .36863 L
.13697 .37167 L
.13245 .37245 L
.11735 .3766 L
.09772 .38383 L
.08127 .39207 L
.0781 .39401 L
.05848 .40845 L
.05376 .4117 L
.03885 .43018 L
.03796 .43132 L
.02819 .45094 L
.02147 .47057 L
.01923 .4726 L
Mfstroke
.8 1 0 r
.01923 .46408 m
.02122 .45094 L
.02381 .43132 L
.03727 .4117 L
.03725 .39207 L
.03885 .38787 L
.04549 .37245 L
.05452 .35283 L
.05848 .34144 L
.0625 .3332 L
.07308 .31358 L
.0781 .30479 L
.08455 .29396 L
.09719 .27433 L
.09772 .27354 L
.11086 .25471 L
.11735 .24594 L
.12562 .23509 L
.13697 .22095 L
.14151 .21546 L
.15659 .19801 L
.15853 .19584 L
.17622 .17671 L
.17669 .17622 L
.19584 .15678 L
.19603 .15659 L
.21546 .138 L
.21657 .13697 L
.23509 .12022 L
.23835 .11735 L
.25471 .10331 L
.26139 .09772 L
.27433 .08717 L
.28574 .0781 L
.29396 .07171 L
.31142 .05848 L
.31358 .05687 L
.3332 .0426 L
.33847 .03885 L
.35283 .02883 L
.36693 .01923 L
.01923 .01923 L
F
0 g
.01923 .46408 m
.02122 .45094 L
.02381 .43132 L
.03727 .4117 L
.03725 .39207 L
.03885 .38787 L
.04549 .37245 L
.05452 .35283 L
.05848 .34144 L
.0625 .3332 L
.07308 .31358 L
.0781 .30479 L
.08455 .29396 L
.09719 .27433 L
.09772 .27354 L
.11086 .25471 L
.11735 .24594 L
.12562 .23509 L
.13697 .22095 L
.14151 .21546 L
.15659 .19801 L
.15853 .19584 L
.17622 .17671 L
.17669 .17622 L
.19584 .15678 L
.19603 .15659 L
.21546 .138 L
.21657 .13697 L
.23509 .12022 L
.23835 .11735 L
.25471 .10331 L
.26139 .09772 L
.27433 .08717 L
.28574 .0781 L
.29396 .07171 L
.31142 .05848 L
.31358 .05687 L
.3332 .0426 L
.33847 .03885 L
.35283 .02883 L
.36693 .01923 L
s
.8 1 0 r
.01923 .53592 m
.02122 .54906 L
.02381 .56868 L
.03727 .5883 L
.03725 .60793 L
.03885 .61213 L
.04549 .62755 L
.05452 .64717 L
.05848 .65856 L
.0625 .6668 L
.07308 .68642 L
.0781 .69521 L
.08455 .70604 L
.09719 .72567 L
.09772 .72646 L
.11086 .74529 L
.11735 .75406 L
.12562 .76491 L
.13697 .77905 L
.14151 .78454 L
.15659 .80199 L
.15853 .80416 L
.17622 .82329 L
.17669 .82378 L
.19584 .84322 L
.19603 .84341 L
.21546 .862 L
.21657 .86303 L
.23509 .87978 L
.23835 .88265 L
.25471 .89669 L
.26139 .90228 L
.27433 .91283 L
.28574 .9219 L
.29396 .92829 L
.31142 .94152 L
.31358 .94313 L
.3332 .9574 L
.33847 .96115 L
.35283 .97117 L
.36693 .98077 L
.01923 .98077 L
F
0 g
.01923 .53592 m
.02122 .54906 L
.02381 .56868 L
.03727 .5883 L
.03725 .60793 L
.03885 .61213 L
.04549 .62755 L
.05452 .64717 L
.05848 .65856 L
.0625 .6668 L
.07308 .68642 L
.0781 .69521 L
.08455 .70604 L
.09719 .72567 L
.09772 .72646 L
.11086 .74529 L
.11735 .75406 L
.12562 .76491 L
.13697 .77905 L
.14151 .78454 L
.15659 .80199 L
.15853 .80416 L
.17622 .82329 L
.17669 .82378 L
.19584 .84322 L
.19603 .84341 L
.21546 .862 L
.21657 .86303 L
.23509 .87978 L
.23835 .88265 L
.25471 .89669 L
.26139 .90228 L
.27433 .91283 L
.28574 .9219 L
.29396 .92829 L
.31142 .94152 L
.31358 .94313 L
.3332 .9574 L
.33847 .96115 L
.35283 .97117 L
.36693 .98077 L
s
.5 0 1 r
.01923 .5269 m
.02209 .52943 L
.02919 .54906 L
.03885 .56671 L
.04046 .56868 L
.05848 .5864 L
.06083 .5883 L
.0781 .59881 L
.09772 .60694 L
.10075 .60793 L
.11735 .612 L
.13697 .61462 L
.15659 .61511 L
.17622 .61365 L
.19584 .61027 L
.20536 .60793 L
.21546 .60491 L
.23509 .59734 L
.2525 .5883 L
.25471 .58701 L
.27433 .57298 L
.27911 .56868 L
.29396 .55238 L
.29625 .54906 L
.30677 .52943 L
.31181 .50981 L
.31181 .49019 L
.30677 .47057 L
.29625 .45094 L
.29396 .44762 L
.27911 .43132 L
.27433 .42702 L
.25471 .41299 L
.2525 .4117 L
.23509 .40266 L
.21546 .39509 L
.20536 .39207 L
.19584 .38973 L
.17622 .38635 L
.15659 .38489 L
.13697 .38538 L
.11735 .388 L
.10075 .39207 L
.09772 .39306 L
.0781 .40119 L
.06083 .4117 L
.05848 .4136 L
.04046 .43132 L
.03885 .43329 L
.02919 .45094 L
.02209 .47057 L
.01923 .4731 L
F
0 g
.01923 .5269 m
.02209 .52943 L
.02919 .54906 L
.03885 .56671 L
.04046 .56868 L
.05848 .5864 L
.06083 .5883 L
.0781 .59881 L
.09772 .60694 L
.10075 .60793 L
.11735 .612 L
.13697 .61462 L
.15659 .61511 L
.17622 .61365 L
.19584 .61027 L
.20536 .60793 L
.21546 .60491 L
.23509 .59734 L
.2525 .5883 L
.25471 .58701 L
.27433 .57298 L
.27911 .56868 L
.29396 .55238 L
.29625 .54906 L
.30677 .52943 L
.31181 .50981 L
.31181 .49019 L
.30677 .47057 L
.29625 .45094 L
.29396 .44762 L
.27911 .43132 L
.27433 .42702 L
.25471 .41299 L
.2525 .4117 L
.23509 .40266 L
.21546 .39509 L
.20536 .39207 L
.19584 .38973 L
.17622 .38635 L
.15659 .38489 L
.13697 .38538 L
.11735 .388 L
.10075 .39207 L
.09772 .39306 L
.0781 .40119 L
.06083 .4117 L
.05848 .4136 L
.04046 .43132 L
.03885 .43329 L
.02919 .45094 L
Mistroke
.02209 .47057 L
.01923 .4731 L
Mfstroke
1 .9 0 r
.01923 .4621 m
.0206 .45094 L
.02268 .43132 L
.03566 .4117 L
.03436 .39207 L
.03885 .37884 L
.04139 .37245 L
.05038 .35283 L
.05752 .3332 L
.05848 .32763 L
.0649 .31358 L
.07451 .29396 L
.0781 .28678 L
.08477 .27433 L
.09595 .25471 L
.09772 .25171 L
.10793 .23509 L
.11735 .22052 L
.12071 .21546 L
.13432 .19584 L
.13697 .19215 L
.14873 .17622 L
.15659 .16597 L
.16396 .15659 L
.17622 .14154 L
.18002 .13697 L
.19584 .11856 L
.19691 .11735 L
.21464 .09772 L
.21546 .09683 L
.23321 .0781 L
.23509 .07617 L
.25264 .05848 L
.25471 .05644 L
.27293 .03885 L
.27433 .03753 L
.29396 .01936 L
.2941 .01923 L
.01923 .01923 L
F
0 g
.01923 .4621 m
.0206 .45094 L
.02268 .43132 L
.03566 .4117 L
.03436 .39207 L
.03885 .37884 L
.04139 .37245 L
.05038 .35283 L
.05752 .3332 L
.05848 .32763 L
.0649 .31358 L
.07451 .29396 L
.0781 .28678 L
.08477 .27433 L
.09595 .25471 L
.09772 .25171 L
.10793 .23509 L
.11735 .22052 L
.12071 .21546 L
.13432 .19584 L
.13697 .19215 L
.14873 .17622 L
.15659 .16597 L
.16396 .15659 L
.17622 .14154 L
.18002 .13697 L
.19584 .11856 L
.19691 .11735 L
.21464 .09772 L
.21546 .09683 L
.23321 .0781 L
.23509 .07617 L
.25264 .05848 L
.25471 .05644 L
.27293 .03885 L
.27433 .03753 L
.29396 .01936 L
.2941 .01923 L
s
1 .9 0 r
.01923 .5379 m
.0206 .54906 L
.02268 .56868 L
.03566 .5883 L
.03436 .60793 L
.03885 .62116 L
.04139 .62755 L
.05038 .64717 L
.05752 .6668 L
.05848 .67237 L
.0649 .68642 L
.07451 .70604 L
.0781 .71322 L
.08477 .72567 L
.09595 .74529 L
.09772 .74829 L
.10793 .76491 L
.11735 .77948 L
.12071 .78454 L
.13432 .80416 L
.13697 .80785 L
.14873 .82378 L
.15659 .83403 L
.16396 .84341 L
.17622 .85846 L
.18002 .86303 L
.19584 .88144 L
.19691 .88265 L
.21464 .90228 L
.21546 .90317 L
.23321 .9219 L
.23509 .92383 L
.25264 .94152 L
.25471 .94356 L
.27293 .96115 L
.27433 .96247 L
.29396 .98064 L
.2941 .98077 L
.01923 .98077 L
F
0 g
.01923 .5379 m
.0206 .54906 L
.02268 .56868 L
.03566 .5883 L
.03436 .60793 L
.03885 .62116 L
.04139 .62755 L
.05038 .64717 L
.05752 .6668 L
.05848 .67237 L
.0649 .68642 L
.07451 .70604 L
.0781 .71322 L
.08477 .72567 L
.09595 .74529 L
.09772 .74829 L
.10793 .76491 L
.11735 .77948 L
.12071 .78454 L
.13432 .80416 L
.13697 .80785 L
.14873 .82378 L
.15659 .83403 L
.16396 .84341 L
.17622 .85846 L
.18002 .86303 L
.19584 .88144 L
.19691 .88265 L
.21464 .90228 L
.21546 .90317 L
.23321 .9219 L
.23509 .92383 L
.25264 .94152 L
.25471 .94356 L
.27293 .96115 L
.27433 .96247 L
.29396 .98064 L
.2941 .98077 L
s
.8 0 1 r
.01923 .52641 m
.02275 .52943 L
.03028 .54906 L
.03885 .56367 L
.04344 .56868 L
.05848 .58139 L
.06974 .5883 L
.0781 .59177 L
.09772 .59776 L
.11735 .60049 L
.13697 .60048 L
.15659 .59795 L
.17622 .59286 L
.18837 .5883 L
.19584 .58496 L
.21546 .57346 L
.22175 .56868 L
.23509 .55651 L
.24113 .54906 L
.2526 .52943 L
.25471 .52386 L
.25801 .50981 L
.25801 .49019 L
.25471 .47614 L
.2526 .47057 L
.24113 .45094 L
.23509 .44349 L
.22175 .43132 L
.21546 .42654 L
.19584 .41504 L
.18837 .4117 L
.17622 .40714 L
.15659 .40205 L
.13697 .39952 L
.11735 .39951 L
.09772 .40224 L
.0781 .40823 L
.06974 .4117 L
.05848 .41861 L
.04344 .43132 L
.03885 .43633 L
.03028 .45094 L
.02275 .47057 L
.01923 .47359 L
F
0 g
.01923 .52641 m
.02275 .52943 L
.03028 .54906 L
.03885 .56367 L
.04344 .56868 L
.05848 .58139 L
.06974 .5883 L
.0781 .59177 L
.09772 .59776 L
.11735 .60049 L
.13697 .60048 L
.15659 .59795 L
.17622 .59286 L
.18837 .5883 L
.19584 .58496 L
.21546 .57346 L
.22175 .56868 L
.23509 .55651 L
.24113 .54906 L
.2526 .52943 L
.25471 .52386 L
.25801 .50981 L
.25801 .49019 L
.25471 .47614 L
.2526 .47057 L
.24113 .45094 L
.23509 .44349 L
.22175 .43132 L
.21546 .42654 L
.19584 .41504 L
.18837 .4117 L
.17622 .40714 L
.15659 .40205 L
.13697 .39952 L
.11735 .39951 L
.09772 .40224 L
.0781 .40823 L
.06974 .4117 L
.05848 .41861 L
.04344 .43132 L
.03885 .43633 L
.03028 .45094 L
.02275 .47057 L
.01923 .47359 L
s
1 .6 0 r
.01923 .45945 m
.01999 .45094 L
.0216 .43132 L
.03294 .4117 L
.03103 .39207 L
.03661 .37245 L
.03885 .3671 L
.04497 .35283 L
.05397 .3332 L
.05688 .31358 L
.05848 .30949 L
.06493 .29396 L
.07341 .27433 L
.0781 .26325 L
.0821 .25471 L
.09173 .23509 L
.09772 .22327 L
.10184 .21546 L
.11261 .19584 L
.11735 .18749 L
.12393 .17622 L
.13584 .15659 L
.13697 .15477 L
.14833 .13697 L
.15659 .12446 L
.16139 .11735 L
.17503 .09772 L
.17622 .09606 L
.18924 .0781 L
.19584 .06926 L
.20403 .05848 L
.21546 .0438 L
.21939 .03885 L
.23509 .01951 L
.23532 .01923 L
.01923 .01923 L
F
0 g
.01923 .45945 m
.01999 .45094 L
.0216 .43132 L
.03294 .4117 L
.03103 .39207 L
.03661 .37245 L
.03885 .3671 L
.04497 .35283 L
.05397 .3332 L
.05688 .31358 L
.05848 .30949 L
.06493 .29396 L
.07341 .27433 L
.0781 .26325 L
.0821 .25471 L
.09173 .23509 L
.09772 .22327 L
.10184 .21546 L
.11261 .19584 L
.11735 .18749 L
.12393 .17622 L
.13584 .15659 L
.13697 .15477 L
.14833 .13697 L
.15659 .12446 L
.16139 .11735 L
.17503 .09772 L
.17622 .09606 L
.18924 .0781 L
.19584 .06926 L
.20403 .05848 L
.21546 .0438 L
.21939 .03885 L
.23509 .01951 L
.23532 .01923 L
s
1 .6 0 r
.01923 .54055 m
.01999 .54906 L
.0216 .56868 L
.03294 .5883 L
.03103 .60793 L
.03661 .62755 L
.03885 .6329 L
.04497 .64717 L
.05397 .6668 L
.05688 .68642 L
.05848 .69051 L
.06493 .70604 L
.07341 .72567 L
.0781 .73675 L
.0821 .74529 L
.09173 .76491 L
.09772 .77673 L
.10184 .78454 L
.11261 .80416 L
.11735 .81251 L
.12393 .82378 L
.13584 .84341 L
.13697 .84523 L
.14833 .86303 L
.15659 .87554 L
.16139 .88265 L
.17503 .90228 L
.17622 .90394 L
.18924 .9219 L
.19584 .93074 L
.20403 .94152 L
.21546 .9562 L
.21939 .96115 L
.23509 .98049 L
.23532 .98077 L
.01923 .98077 L
F
0 g
.01923 .54055 m
.01999 .54906 L
.0216 .56868 L
.03294 .5883 L
.03103 .60793 L
.03661 .62755 L
.03885 .6329 L
.04497 .64717 L
.05397 .6668 L
.05688 .68642 L
.05848 .69051 L
.06493 .70604 L
.07341 .72567 L
.0781 .73675 L
.0821 .74529 L
.09173 .76491 L
.09772 .77673 L
.10184 .78454 L
.11261 .80416 L
.11735 .81251 L
.12393 .82378 L
.13584 .84341 L
.13697 .84523 L
.14833 .86303 L
.15659 .87554 L
.16139 .88265 L
.17503 .90228 L
.17622 .90394 L
.18924 .9219 L
.19584 .93074 L
.20403 .94152 L
.21546 .9562 L
.21939 .96115 L
.23509 .98049 L
.23532 .98077 L
s
1 0 .9 r
.01923 .52592 m
.02343 .52943 L
.03146 .54906 L
.03885 .56076 L
.0472 .56868 L
.05848 .57649 L
.0781 .58481 L
.09548 .5883 L
.09772 .58847 L
.11735 .58857 L
.1204 .5883 L
.13697 .58546 L
.15659 .579 L
.17577 .56868 L
.17622 .5684 L
.19584 .55177 L
.19813 .54906 L
.21067 .52943 L
.21546 .51524 L
.21647 .50981 L
.21647 .49019 L
.21546 .48476 L
.21067 .47057 L
.19813 .45094 L
.19584 .44823 L
.17622 .4316 L
.17577 .43132 L
.15659 .421 L
.13697 .41454 L
.1204 .4117 L
.11735 .41143 L
.09772 .41153 L
.09548 .4117 L
.0781 .41519 L
.05848 .42351 L
.0472 .43132 L
.03885 .43924 L
.03146 .45094 L
.02343 .47057 L
.01923 .47408 L
F
0 g
.01923 .52592 m
.02343 .52943 L
.03146 .54906 L
.03885 .56076 L
.0472 .56868 L
.05848 .57649 L
.0781 .58481 L
.09548 .5883 L
.09772 .58847 L
.11735 .58857 L
.1204 .5883 L
.13697 .58546 L
.15659 .579 L
.17577 .56868 L
.17622 .5684 L
.19584 .55177 L
.19813 .54906 L
.21067 .52943 L
.21546 .51524 L
.21647 .50981 L
.21647 .49019 L
.21546 .48476 L
.21067 .47057 L
.19813 .45094 L
.19584 .44823 L
.17622 .4316 L
.17577 .43132 L
.15659 .421 L
.13697 .41454 L
.1204 .4117 L
.11735 .41143 L
.09772 .41153 L
.09548 .4117 L
.0781 .41519 L
.05848 .42351 L
.0472 .43132 L
.03885 .43924 L
.03146 .45094 L
.02343 .47057 L
.01923 .47408 L
s
1 0 .6 r
.01923 .52544 m
.02415 .52943 L
.03276 .54906 L
.03885 .55796 L
.05261 .56868 L
.05848 .57168 L
.0781 .57782 L
.09772 .579 L
.11735 .57601 L
.13697 .56869 L
.13699 .56868 L
.15659 .55616 L
.16392 .54906 L
.17622 .53273 L
.17767 .52943 L
.18387 .50981 L
.18387 .49019 L
.17767 .47057 L
.17622 .46727 L
.16392 .45094 L
.15659 .44384 L
.13699 .43132 L
.13697 .43131 L
.11735 .42399 L
.09772 .421 L
.0781 .42218 L
.05848 .42832 L
.05261 .43132 L
.03885 .44204 L
.03276 .45094 L
.02415 .47057 L
.01923 .47456 L
F
0 g
.01923 .52544 m
.02415 .52943 L
.03276 .54906 L
.03885 .55796 L
.05261 .56868 L
.05848 .57168 L
.0781 .57782 L
.09772 .579 L
.11735 .57601 L
.13697 .56869 L
.13699 .56868 L
.15659 .55616 L
.16392 .54906 L
.17622 .53273 L
.17767 .52943 L
.18387 .50981 L
.18387 .49019 L
.17767 .47057 L
.17622 .46727 L
.16392 .45094 L
.15659 .44384 L
.13699 .43132 L
.13697 .43131 L
.11735 .42399 L
.09772 .421 L
.0781 .42218 L
.05848 .42832 L
.05261 .43132 L
.03885 .44204 L
.03276 .45094 L
.02415 .47057 L
.01923 .47456 L
s
1 .3 0 r
.01923 .45485 m
.01941 .45094 L
.02057 .43132 L
.02877 .4117 L
.02701 .39207 L
.03077 .37245 L
.03727 .35283 L
.03885 .34933 L
.0462 .3332 L
.04864 .31358 L
.05463 .29396 L
.05848 .28255 L
.06147 .27433 L
.06895 .25471 L
.07598 .23509 L
.0781 .22833 L
.08334 .21546 L
.09156 .19584 L
.09772 .18114 L
.09992 .17622 L
.10892 .15659 L
.11735 .13868 L
.11818 .13697 L
.12794 .11735 L
.13697 .0997 L
.138 .09772 L
.14851 .0781 L
.15659 .0634 L
.15935 .05848 L
.1706 .03885 L
.17622 .02925 L
.1822 .01923 L
.01923 .01923 L
F
0 g
.01923 .45485 m
.01941 .45094 L
.02057 .43132 L
.02877 .4117 L
.02701 .39207 L
.03077 .37245 L
.03727 .35283 L
.03885 .34933 L
.0462 .3332 L
.04864 .31358 L
.05463 .29396 L
.05848 .28255 L
.06147 .27433 L
.06895 .25471 L
.07598 .23509 L
.0781 .22833 L
.08334 .21546 L
.09156 .19584 L
.09772 .18114 L
.09992 .17622 L
.10892 .15659 L
.11735 .13868 L
.11818 .13697 L
.12794 .11735 L
.13697 .0997 L
.138 .09772 L
.14851 .0781 L
.15659 .0634 L
.15935 .05848 L
.1706 .03885 L
.17622 .02925 L
.1822 .01923 L
s
1 .3 0 r
.01923 .54515 m
.01941 .54906 L
.02057 .56868 L
.02877 .5883 L
.02701 .60793 L
.03077 .62755 L
.03727 .64717 L
.03885 .65067 L
.0462 .6668 L
.04864 .68642 L
.05463 .70604 L
.05848 .71745 L
.06147 .72567 L
.06895 .74529 L
.07598 .76491 L
.0781 .77167 L
.08334 .78454 L
.09156 .80416 L
.09772 .81886 L
.09992 .82378 L
.10892 .84341 L
.11735 .86132 L
.11818 .86303 L
.12794 .88265 L
.13697 .9003 L
.138 .90228 L
.14851 .9219 L
.15659 .9366 L
.15935 .94152 L
.1706 .96115 L
.17622 .97075 L
.1822 .98077 L
.01923 .98077 L
F
0 g
.01923 .54515 m
.01941 .54906 L
.02057 .56868 L
.02877 .5883 L
.02701 .60793 L
.03077 .62755 L
.03727 .64717 L
.03885 .65067 L
.0462 .6668 L
.04864 .68642 L
.05463 .70604 L
.05848 .71745 L
.06147 .72567 L
.06895 .74529 L
.07598 .76491 L
.0781 .77167 L
.08334 .78454 L
.09156 .80416 L
.09772 .81886 L
.09992 .82378 L
.10892 .84341 L
.11735 .86132 L
.11818 .86303 L
.12794 .88265 L
.13697 .9003 L
.138 .90228 L
.14851 .9219 L
.15659 .9366 L
.15935 .94152 L
.1706 .96115 L
.17622 .97075 L
.1822 .98077 L
s
1 0 .3 r
.01923 .52497 m
.02491 .52943 L
.03423 .54906 L
.03885 .55525 L
.05848 .56693 L
.06303 .56868 L
.0781 .57069 L
.09772 .56896 L
.09929 .56868 L
.11735 .56219 L
.13611 .54906 L
.13697 .54842 L
.15132 .52943 L
.15659 .51603 L
.15794 .50981 L
.15794 .49019 L
.15659 .48397 L
.15132 .47057 L
.13697 .45158 L
.13611 .45094 L
.11735 .43781 L
.09929 .43132 L
.09772 .43104 L
.0781 .42931 L
.06303 .43132 L
.05848 .43307 L
.03885 .44475 L
.03423 .45094 L
.02491 .47057 L
.01923 .47503 L
F
0 g
.01923 .52497 m
.02491 .52943 L
.03423 .54906 L
.03885 .55525 L
.05848 .56693 L
.06303 .56868 L
.0781 .57069 L
.09772 .56896 L
.09929 .56868 L
.11735 .56219 L
.13611 .54906 L
.13697 .54842 L
.15132 .52943 L
.15659 .51603 L
.15794 .50981 L
.15794 .49019 L
.15659 .48397 L
.15132 .47057 L
.13697 .45158 L
.13611 .45094 L
.11735 .43781 L
.09929 .43132 L
.09772 .43104 L
.0781 .42931 L
.06303 .43132 L
.05848 .43307 L
.03885 .44475 L
.03423 .45094 L
.02491 .47057 L
.01923 .47503 L
s
1 0 0 r
.01923 .5245 m
.02571 .52943 L
.03591 .54906 L
.03885 .55262 L
.05848 .56221 L
.0781 .56346 L
.09772 .55832 L
.11296 .54906 L
.11735 .54597 L
.12998 .52943 L
.13697 .51025 L
.13705 .50981 L
.13705 .49019 L
.13697 .48975 L
.12998 .47057 L
.11735 .45403 L
.11296 .45094 L
.09772 .44168 L
.0781 .43654 L
.05848 .43779 L
.03885 .44738 L
.03591 .45094 L
.02571 .47057 L
.01923 .4755 L
F
0 g
.01923 .5245 m
.02571 .52943 L
.03591 .54906 L
.03885 .55262 L
.05848 .56221 L
.0781 .56346 L
.09772 .55832 L
.11296 .54906 L
.11735 .54597 L
.12998 .52943 L
.13697 .51025 L
.13705 .50981 L
.13705 .49019 L
.13697 .48975 L
.12998 .47057 L
.11735 .45403 L
.11296 .45094 L
.09772 .44168 L
.0781 .43654 L
.05848 .43779 L
.03885 .44738 L
.03591 .45094 L
.02571 .47057 L
.01923 .4755 L
s
1 0 0 r
.01923 .44613 m
.01958 .43132 L
.02283 .4117 L
.02209 .39207 L
.02351 .37245 L
.02628 .35283 L
.03083 .3332 L
.03846 .31358 L
.03885 .31172 L
.04222 .29396 L
.04627 .27433 L
.05082 .25471 L
.05588 .23509 L
.05848 .22572 L
.06183 .21546 L
.0686 .19584 L
.0747 .17622 L
.07757 .15659 L
.0781 .15488 L
.08401 .13697 L
.09048 .11735 L
.09639 .09772 L
.09772 .09282 L
.10287 .0781 L
.10981 .05848 L
.11657 .03885 L
.11735 .03655 L
.12385 .01923 L
.01923 .01923 L
F
0 g
.01923 .44613 m
.01958 .43132 L
.02283 .4117 L
.02209 .39207 L
.02351 .37245 L
.02628 .35283 L
.03083 .3332 L
.03846 .31358 L
.03885 .31172 L
.04222 .29396 L
.04627 .27433 L
.05082 .25471 L
.05588 .23509 L
.05848 .22572 L
.06183 .21546 L
.0686 .19584 L
.0747 .17622 L
.07757 .15659 L
.0781 .15488 L
.08401 .13697 L
.09048 .11735 L
.09639 .09772 L
.09772 .09282 L
.10287 .0781 L
.10981 .05848 L
.11657 .03885 L
.11735 .03655 L
.12385 .01923 L
s
1 0 0 r
.01923 .55387 m
.01958 .56868 L
.02283 .5883 L
.02209 .60793 L
.02351 .62755 L
.02628 .64717 L
.03083 .6668 L
.03846 .68642 L
.03885 .68828 L
.04222 .70604 L
.04627 .72567 L
.05082 .74529 L
.05588 .76491 L
.05848 .77428 L
.06183 .78454 L
.0686 .80416 L
.0747 .82378 L
.07757 .84341 L
.0781 .84512 L
.08401 .86303 L
.09048 .88265 L
.09639 .90228 L
.09772 .90718 L
.10287 .9219 L
.10981 .94152 L
.11657 .96115 L
.11735 .96345 L
.12385 .98077 L
.01923 .98077 L
F
0 g
.01923 .55387 m
.01958 .56868 L
.02283 .5883 L
.02209 .60793 L
.02351 .62755 L
.02628 .64717 L
.03083 .6668 L
.03846 .68642 L
.03885 .68828 L
.04222 .70604 L
.04627 .72567 L
.05082 .74529 L
.05588 .76491 L
.05848 .77428 L
.06183 .78454 L
.0686 .80416 L
.0747 .82378 L
.07757 .84341 L
.0781 .84512 L
.08401 .86303 L
.09048 .88265 L
.09639 .90228 L
.09772 .90718 L
.10287 .9219 L
.10981 .94152 L
.11657 .96115 L
.11735 .96345 L
.12385 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{Inherited, Inherited}, {Inherited, 0}},
  ImageSize->{217, 217},
  ImageMargins->{{70, 0}, {0, 8.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004?00013a000`40O003h00O57oo10006Woo1000
1Goo0P001Goo10006Goo1@0067oo1@0017oo0P001Goo100067oo1@006Goo1@001Goo0P001Goo1000
6Goo0`0067oo000COol00`00Oomoo`02Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02
Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0HOol00`00Oomoo`0JOol00`00Oomoo`04Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0EOol01@00Oomoogoo00006Goo00D007ooOomoo`0000Eoo`80
00Aoo`03001oogoo009oo`03001oogoo01Eoo`05001oogooOol0000GOol001=oo`03001oogoo009o
o`03001oogoo01Ioo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01Qoo`03001oogoo01Yo
o`03001oogoo00moo`03001oogoo01Ioo`03001oogoo01]oo`03001oogoo015oo`03001oogoo01Uo
o`03001oogoo01Eoo`004goo00<007ooOol00Woo00<007ooOol05Woo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol067oo00<007ooOol06Woo00<007ooOol03goo00<007ooOol05goo00<007oo
Ool06goo00<007ooOol047oo00<007ooOol06Goo00<007ooOol05Goo000COol00`00Oomoo`02Ool0
0`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`09Ool4000KOol00`00Oomoo`0JOol00`00Oomo
o`0;Ool4000KOol00`00Oomoo`0KOol00`00Oomoo`0;Ool4000JOol2000HOol001=oo`03001oogoo
009oo`03001oogoo01Ioo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01aoo`03001oogoo
01Yoo`03001oogoo00]oo`03001oogoo01eoo`03001oogoo01]oo`03001oogoo00Yoo`03001oogoo
01eoo`03001oogoo01Eoo`004goo00<007ooOol00Woo00<007ooOol05Woo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol06Woo0`006Woo0`003Goo00<007ooOol06Goo00D007ooOomoo`0001Uo
o`05001oogooOol0000<Ool00`00Oomoo`0IOol01@00Oomoogoo00005goo000DOol4000JOol4000<
Ool5000JOol00`00Oomoo`0JOol00`00Oomoo`0;Ool5000HOol3000KOol3000=Ool5000HOol3000H
Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo1Goo0P000Woo0P001Goo003oOol6
Ool01000Oomoo`001Woo000COooX000;Ool20007Ool001=oo`04001oogoo0007Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool01@00Oomoogoo00002goo0P001goo
000:Ool30006Ool01000Oomoo`009Goo00<007ooOol08Woo00<007ooOol08Woo00<007ooOol08Woo
00<007ooOol08goo00<007ooOol08Woo00D007ooOomoo`0000Yoo`04001oogoo0006Ool000Uoo`05
001oogooOol00005Ool00`00Oomoo`3TOol00`00Oomoo`07Ool20002Ool20005Ool000eoo`03001o
ogoo00=oo`03001oogoo0>Aoo`03001oogoo019oo`0000=oo`00000010001Woo00<007ooOol00goo
0P006Woo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02goo00<007ooOol03Goo0P005Goo
0P00:Woo0P00CGoo0P0057oo000;Ool20006Ool01000Oomoogoo67`0010007dPO@1m87d0OB1m07dP
O@1m87d0OB1m0000OT1nH0=n@00SOV1n@7i0OT1nH7i0001oH7n0Of1oP7mPOh1oH7n0Of1oP7mPOh1o
H000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0020002?n001C_P?n0oh3oP>n000coP00Dkh3oP
?n0oh3_P00<oh003>n0oh3oP0080000Y6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh00300001@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`030n8010?S0n83hP?R17oo00<007ooOol04Woo000=Ool00`00Oomoo`03Ool01000
Oomoogoo67`000d007d0OB1m07dPO@1m87d0OB1m07dPO@00000;OT000`00Oh1oP00:Oh0200003f?P
In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn00000E?n0200000aOP6n0Gh0025n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh0000000
0`00C`?R17oo00<007ooOol04Woo0009Ool01@00Oomoogoo00001Goo00@007ooOomooaMl000?001m
07dPO@1m87d0OB1m07dPO@1m87d0OB0007iP00=n@00ROV1n@7i0OT1nH7i0001oH7n0Of1oP7mPOh1o
H7n0Of1oP7mPOh0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn020003?n001C_P?n0oh3oP>n00
0coP00Dkh3oP?n0oh3_P00<oh00V>n0000006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0D00083hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n9oo`03Ool00`00Oomoo`0BOol000Yoo`<000Ioo`04
001oogooOolGO0003@00OB1m07dPO@1m87d0OB1m07dPO@1m800000Yn@003001oP7n000YoP00@001W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000C?n0300035n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001Q_P5n0Gh1OP6n0Gh0@005T3hPAoo`03001oogoo019o
o`004goo00@007ooOomooaMl000=001m07dPO@1m87d0OB1m07dPO@1m87d000000gi000EnH7i0OT1n
@7iP009n@00M001oP7mPOh1oH7n0Of1oP7mPOh1oH7n0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?P000kh003?n001C_P?n0oh3oP>n000coP00Hkh3oP?n0oh3_P?n0200008QOP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0P0000<3
hP?S0n800P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n84Ool00`00Oomoo`0BOol001=oo`04001oogooOolFO0003@00O@1m87d0OB1m07dPO@1m87d0
OB1m000000]n@003001oP7n000QoP00@001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000B?n00
10005n0Gh1_P0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00<Kh1OP5n000`00G`?R17oo00<007ooOol04Woo000COol20002OolFO0003@00OB1m07dPO@1m87d0
OB1m07dPO@1m8000009n@005OV1n@7i0OT1nH003OT006@00Of1oP7mPOh1oH7n0Of1oP7mPOh0006OP
Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00800005>n0oh3oP?n0kh003?n001C_P?n0oh3oP>n000coP
024kh000000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n00100000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?ROol00Woo0P0057oo000COol01000Oomoogoo5G`0
00d007dPO@1m87d0OB1m07dPO@1m87d0OB00000:OT000`00Oh1oP008Oh003`00In1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn00000A?n0200035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n000a_P00000002001V0n84Ool00`00Oomoo`0BOol001=oo`04001oogooOolE
O0003`00O@1m87d0OB1m07dPO@1m87d0OB1m0000OT1nH003OT0087iPOT1n@7i0001oH7n0Of1oP7mP
Oh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn0003oP>n03?n001C_P?n0oh3oP>n00
0coP00<kh3oP?n000P0001`Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh0800083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n84Ool00`00Oomoo`0B
Ool001=oo`04001oogooOolEO0003000OB1m07dPO@1m87d0OB1m07dPO@0000Un@003001oP7n000Qo
P00=001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000P003coP0P0000<Gh1_P5n000QOP00DKh1OP5n0G
h1_P00<Gh0056n0Gh1OP5n0Kh0035n001Q_P5n0Gh1OP6n0Gh0<006`3hPAoo`03001oogoo019oo`00
4goo00@007ooOomooaAl000>001m87d0OB1m07dPO@1m87d0OB1m0000OT1nH0=n@00MOV1n@7i0OT00
07mPOh1oH7n0Of1oP7mPOh1oH7n0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000002?n001C_P?n0o
h3oP>n000coP00Dkh3oP?n0oh3_P0080000I6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n00100000<3hP?S0n800P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP030n<3hWoo00=oo`03001oogoo019oo`004goo00@007ooOomooaAl000<001m07dPO@1m87d0OB1m
07dPO@1m800027i000<007n0Oh0027n000`006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn02000>?n020003
5n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0066n0Gh1OP5n0Kh1OP0P00E@?R7`000goo
00<007ooOol04Woo000COol01000Oomoogoo4g`000d007d0OB1m07dPO@1m87d0OB1m07dP001nH003
OT0077iPOT1n@7i0001oH7n0Of1oP7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh000
0coP00Dkh3oP?n0oh3_P00<oh00M>n0oh3oP?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh00300000`?R0n<3hP020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hQ80000N0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[17oo00<007ooOol0
4Woo000COol01000Oomoogoo4g`000`007dPO@1m87d0OB1m07dPO@1m87d00007OT000`00Oh1oP008
Oh003@00In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh00000hoh08000056n0Gh1OP5n0Kh0035n001A_P5n0G
h1OP6n000aOP00DKh1OP5n0Gh1_P008Gh08003l3hPT00303k0Aoo`03001oogoo019oo`004goo0P00
0Woo4g`000/007d0OB1m07dPO@1m87d0OB1m000000=n@00LOV1n@7i0OT1nH000Oh1oH7n0Of1oP7mP
Oh1oH7n0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP0003?n001C_P?n0oh3oP>n000coP01Xkh3oP0000
01OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0`0000D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hPT0000i0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00=oo`8001Aoo`004goo00@007oo
Oomooa9l000<001m07dPO@1m87d0OB1m07dPO@1m80001gi000<007n0Oh0027n000`006?PIn1Sh6OP
Hn1Wh6?PIn1Sh6OP000=?n0010005n0Gh1_P0aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh002
5n03000b0n8900120n`4Ool00`00Oomoo`0BOol001=oo`04001oogooOolBO0002`00OB1m07dPO@1m
87d0OB1m07dP00000Wi001YnH7i0OT1n@7iPOT0007mPOh1oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1S
h6OPHn1Wh6?P0P000coP00Dkh3oP?n0oh3_P00<oh00G>n0000006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh00200001@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
0`?S000000020000B`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`04Ool00`00Oomoo`0BOol0
01=oo`04001oogooOolBO0002@00O@1m87d0OB1m07dPO@1m80020007OT000`00Oh1oP006Oh020000
2V?PIn1Sh6OPHn1Wh6?PIn1Sh00033oP0P000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n03000]0n86001?0n`4Ool00`00Oomoo`0BOol001=oo`04001oogooOolBO0003000OB1m07dPO@1m
87d0OB1m0000OT1nH0=n@00HOV1n@000Of1oP7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OP
Hn0003_P0coP00Dkh3oP?n0oh3_P00<oh00D000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh08000<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0200005D3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`04Ool00`00Oomoo`0BOol001=oo`04001oogooOolBO000
2@00O@1m87d0OB1m07dPO@000008OT000`00Oh1oP005Oh003000In1Sh6OPHn1Wh6?PIn1Sh6OPHn00
00/oh08000056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh000000002D3hPD005d3k0Ao
o`03001oogoo019oo`004goo00@007ooOomooa5l000;001m07dPO@1m87d0OB1m07dP001nH003OT00
67iPOT1n@000Oh1oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OPHn1Wh6?P000kh0<oh005>n0oh3oP
?n0kh002?n004P005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0800083hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S
0n8000030000HP?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/4Ool00`00Oomoo`0BOol001=oo`80009ooa5l0009001m
87d0OB1m07dPO@1m800000Qn@003001oP7n000EoP00;001Sh6OPHn1Wh6?PIn1Sh6OPHn00000;?n00
0`005n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh0000283hP@006H3k0=oo`8001Aoo`00
4goo00@007ooOomooa5l0009001m07dPO@1m87d0OB1m000000=n@00EOV1n@7i0OT0007mPOh1oH7n0
Of1oP7mP001Sh6OPHn1Wh6?PIn1Sh6OP00800005>n0oh3oP?n0kh003?n004c_P?n0000005n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP00<000<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP030n<3hP?R00D0001Z0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/4Ool00`00Oomoo`0BOol001=oo`04001oogooOolAO0002@00OB1m07dPO@1m87d0OB000006
OT000`00Oh1oP005Oh002P00Hn1Wh6?PIn1Sh6OPHn1Wh0002SoP0P000QOP00DKh1OP5n0Gh1_P00<G
h0046n0Gh1OP5n03000L0n85001_0n`4Ool00`00Oomoo`0BOol001=oo`04001oogooOol@O0002@00
OB1m07dPO@1m87d0OB000002OT0067iPOT1n@7i0001oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OP
Hn1Wh000?n0kh0<oh00D>n0oh3oP?n0kh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh08000<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP1h0n<000000003
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[17oo00<007oo
Ool04Woo000COol01000Oomoogoo47`000T007d0OB1m07dPO@1m87d000001Wi000<007n0Oh0017n0
00X006?PIn1Sh6OPHn1Wh6?PIn0000Toh08000<Gh0056n0Gh1OP5n0Kh0035n0011_P5n00000070?R
0P00M`?/17oo00<007ooOol04Woo000COol01000Oomoogoo3g`000/007d0OB1m07dPO@1m87d0001n
@7iP00=n@00DOV0007n0Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OPHn1Wh000?n0kh0<oh00F>n0oh3oP
?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000?R0n<30n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP040n<3hP?R0n850000N@?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Aoo`03001oogoo019oo`004goo00@007ooOomo
o`ml0009001m87d0OB1m07dPO@1m800000En@003001oP7n000AoP00:001Sh6OPHn1Wh6?PIn1Sh6OP
0009?n000`006n0Gh0025n001A_P5n0Gh1OP6n000aOP00<Kh00000005`?R0`00OP?/17oo00<007oo
Ool04Woo000COol01000Oomoogoo3g`000T007d0OB1m07dPO@1m87d000000gi001AnH7i0001oH7n0
Of1oP7mPOh0006OPHn1Wh6?PIn1Sh6OP000oh3_P0coP014kh3oP?n0oh0006n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP00800083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?R0n801000
0843j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/017oo00<007ooOol04Woo000COol20002Ool>O0002@00O@1m87d0
OB1m07dPO@000005OT000`00Oh1oP004Oh002@00In1Sh6OPHn1Wh6?PIn000008?n0200001A_P5n0G
h1OP6n000aOP00<Kh1OP5n000P005@?R0P00Q@?/0goo0P0057oo000COol01000Oomoogoo3W`000T0
07dPO@1m87d0OB1m07dP00000Wi001AnH7i0001oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OP000o
h3_P0coP018kh3oP?n0001OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n<30n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP<000270n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Aoo`03
001oogoo019oo`004goo00@007ooOomoo`il0008001m07dPO@1m87d0OB0000En@003001oP7n000Ao
P008001Sh6OPHn1Wh6?PIn0000Poh003000Gh1_P00<Gh0066n0Gh1OP5n0Kh1OP0P004@?R1000RP?/
17oo00<007ooOol04Woo000COol01000Oomoogoo3W`000X007dPO@1m87d0OB1m0000OT1nH09n@00A
001oP7mPOh1oH7n0Of0006?PIn1Sh6OPHn1Wh000?n0kh003?n003S_P?n0000005n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0200000`?R0n<3hP020n801@?S0n83hP?R0n<00`?R00@3h`?R0n83hP80002>0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/4Ool00`00Oomoo`0BOol000Uoo`D0
00Eoo`04001oogooOol>O0001`00O@1m87d0OB1m000000En@003001oP7n000=oP008001Sh6OPHn1W
h6?PIn0000Loh004000Gh1OP6n035n0011_P5n0Gh1OP0P003`?R1000<`?/=P009`?/17oo00<007oo
Ool04Woo0009Ool01@00Oomoogoo00001Goo00@007ooOomoo`el0009001m07dPO@1m87d0OB0007iP
00=n@00@001oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn0003oP>n03?n0033_P000001_P5n0Kh1OP6n0G
h1_P5n0Kh08000<3hP050n<3hP?R0n83h`030n800`?S0n83hP030000:@?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`03P0003H3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH9
00007P?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`Aoo`03001oogoo019oo`002Woo00<007ooOol01Woo00@007ooOomoo`el0007001m87d0OB1m
07dP000017i000<007n0Oh000gn000H006?PIn1Sh6OPHn020006?n001@005n0Gh1OP6n000aOP00@K
h1OP5n0000h3hP8002L3k0D000050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP0:000D
0n`4Ool00`00Oomoo`0BOol00003Ool0000000@000Aoo`03001oogoo00Eoo`80009oo`el0007001m
07dPO@1m8000OV000gi000enH000Oh1oH7n0Of0006?PIn1Sh6OPHn000002?n003c_P?n0oh3oP>n00
01OP6n0Gh1_P5n0Kh1OP6n0Gh00200001@?S0n83hP?R0n<00`?R00@3h`?R0n83hP<0000Q0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
00P0001L0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@T0000;0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`03Ool2000DOol000aoo`03001oogoo
00Aoo`04001oogooOol=O0001P00OB1m07dPO@0000An@003001oP7n000=oP006001Wh6?PIn1Sh000
1coP00D001OP5n0Gh1_P00<Gh0036n00000000`3hP8001l3k0D000<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD00`?f0oD0000300070n`4Ool00`00Oomoo`0BOol000eoo`03001oogoo00=oo`04
001oogooOol<O0001`00OB1m07dPO@1m8000009n@00@OV1n@000Of1oP7mPOh0006OPHn1Wh6?PIn00
03oP>n03?n002c_P000Gh1_P5n0Kh1OP6n0Gh1_P00000P?R00D3h`?R0n83hP?S00<3hP0Q0n<3hP00
0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
00@0001f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH80003Ool00`00Oomoo`0BOol000Uoo`05001oogooOol00005Ool01000Oomoogoo37`000H007d0
OB1m07dP0005OT002`00Oh1oP7n0001Wh6?PIn1Sh6OP00001SoP00D001OP5n0Gh1_P00<Gh0036n00
00?R00X3hP8001X3k0D00083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP020oD4Ool00`00Oomoo`0BOol000Yoo`<000Io
o`04001oogooOol<O0002000OB1m07dPO@0007i0OV02OT003@00Oh1oH7n0Of0006?PIn1Sh6OP000o
h3_P00<oh009>n0001OP6n0Gh1_P5n0Kh1OP00800083hP050n<3hP?R0n83h`020n8300005`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`01@0008H3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e17oo00<007ooOol04Woo000COol01000Oomoogoo37`000H007d0OB1m07dP
0003OT000`00Oh1oP002Oh001P00Hn1Wh6?PIn0000Doh08000<Gh0056n0Gh1OP5n0000090n82000F
0n`400020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oIoogoo009oo`03001oogoo
019oo`004goo00@007ooOomoo`]l0007001m07dPO@1m8000OV000gi000`007mPOh1oH7n0001Wh6?P
In0003oP>n03?n0020006n0Gh1_P5n0Kh1OP6n0200030n801@?S0n83hP?R0n<00P0001<3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`050000S`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD017oo00<007ooOol04Woo000COol20002Ool;O0001P00OB1m
07dPO@0000=n@003001oP7n0009oP005001Wh6?PIn000005?n000`006n0Gh0025n0011_P5n000000
20?R0P004@?/100000<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00P?e0goo0P0057oo000COol01000Oomoogoo2W`000H007dPO@1m87d00003OT003000
Of1oP7mPOh0006OPHn1Wh000?n0kh0<oh00:000Kh1OP6n0Gh1_P5n0000?R0n<30n8050?S0n83hP?R
0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/40000V0?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD4Ool00`00Oomoo`0BOol001=o
o`04001oogooOol:O0001P00O@1m87d0OB0000=n@00:001oP7n0Oh0006OPHn1Wh6?P0004?n000`00
6n0Gh0025n000a_P5n0000080n82000>0n`200030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mWooOol00Woo00<007ooOol04Woo
000COol01000Oomoogoo2G`000H007d0OB1m07dP0002OT0037iP001oP7mPOh1oH000Hn1Wh6?P000k
h0<oh006000Kh1OP6n0Gh1_P0P0000<3hP?S0n800P?R0143h`?R000000?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/00<0002N0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@Aoo`03001oogoo019oo`004goo00@007ooOomo
o`Ul0006001m87d0OB1m00000gi000T007n0Oh1oP000Hn1Wh6?P000013oP00<001_P5n000QOP00<K
h0000n801`?R00<000?/0n`02P?/0`000P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP020oD4Ool00`00Oomoo`0B
Ool001=oo`04001oogooOol9O0004P00O@1m87d0OB0007iPOT0007mPOh1oH7n0001Wh6?PIn0000<o
h007000Kh1OP6n0Gh1_P00000P?R00D3h`?R0n83hP?S0080000;0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`0200009`?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP0K0000HP?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD4Ool00`00Oomoo`0B
Ool001=oo`04001oogooOol9O0001@00OB1m07dP00000gi000T007n0Oh1oP000In1Sh6OP00000coP
00<001_P5n000QOP00<Kh0000n801@?R0P002P?/0`0000<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3m@h001/3o`h000<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD00`?fOomoo`02Ool00`00Oomoo`0BOol001=oo`04001oogoo
Ool9O0001@00O@1m87d000000gi000P007mPOh0006OPHn1Wh0000coP00L001_P5n0Kh1OP6n000002
0n803`?S0n83hP?R0003j`?/0n/3k0?[0n`3j`?/0n/3k00200006P?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH4000g0ol90000B`?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@04Ool00`00Oomoo`0BOol001=oo`80009oo`Ql0006001m07dPO@1m80000Wi0
00P007n0Oh1oP000Hn1Wh0000coP00<001_P5n000QOP00<Kh0000n8010?R0P0020?/0`0000D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD00`?f0oD3m@0900140ol500030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3
m@?e00=oo`8001Aoo`004goo00@007ooOomoo`Ql0005001m87d0OB000002OT0027iP001oP7mP001S
h6OP0003?n001@006n0Gh1_P5n000P000P?R00`3h`?R000000?/0n/3k0?[0n`3j`?/0n/200004@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH01@00DP?o10000483mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD4Ool0
0`00Oomoo`0BOol001=oo`04001oogooOol7O0001P00OB1m07dPO@00009n@007001oP7n0001Sh6OP
00000coP00<001_P5n000QOP00<000?R0n800`?R00<000?/0n`01@?/0`000`?e00D3mP?e0oD3m@?f
00<3m@030oH3m@?e00D005/3o`L00083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD00`?fOomoo`02Ool00`00Oomoo`0BOol001=oo`04001oogooOol7O000
3P00O@1m87d0OB0007iPOT0007mP001Sh6OP0003?n001P006n0Gh1_P5n0000<3hP090n<000000n/3
k0?[0n`3j`?/0080000>0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP<006L3o`80000i0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e00Aoo`03001oogoo
019oo`004goo00@007ooOomoo`Ml0005001m87d0OB000002OT001`00Oh1oP000In1Sh00000<oh005
000Gh1OP5n0000040n800`000n`3k0050n`010000oD3m@?f0`?e00D3mP?e0oD3m@?f00<3m@8006`3
o`D000030oD3mP?e0083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f0083m@Aoo`03001o
ogoo019oo`004goo00@007ooOomoo`Il0006001m87d0OB1m00000Wi000H007n0001Wh6?P0002?n00
1S_P000Gh1_P5n0000<3hP080n<000?/0n/3k0?[0n`3j`80000<0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0`00L`?o10000303mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD4Ool00`00Oomo
o`0BOol001=oo`04001oogooOol6O0001@00O@1m87d000000Wi000L007n0Oh0006?PIn000002?n00
1@005n0Gh1OP000010?R00<000?/0n`010?/00D000?e0oD3m@?f00<3m@030oH3m@?e00@007X3o`@0
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mWooOol00Woo00<007ooOol04Woo000COol20002Ool6
O0001@00OB1m07dP00000Wi000d007mP001Sh6OP000oh3_P000Gh1_P5n0000030n801`?S0003k0?[
0n`3j`?/008000090oD3mP?e0oH3m@?f0oD3mP?e00800883o`@0000X0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3Ool2000DOol001=oo`04001oogooOol6O0001@00O@1m87d000000Wi000D007n0001Wh000008o
h005000Gh1OP5n0000030n8200040n`200001@?f0oD3m@?e0oH00`?e0`007@?o3@00GP?o0P000`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@030oH3m@?e00Aoo`03001oogoo019oo`004goo00@007ooOomoo`Il000B001m87d0001n@7iP
001oP000In1Sh000>n0oh0006n0Gh0000`?R00d000?[0n`3j`?/0n/000?e0oH3m@?f0oD3mP04000B
0ol>00003@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o00h00583o`@0000R0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD4Ool00`00
Oomoo`0BOol001=oo`04001oogooOol5O0001@00OB1m07dP00000Wi000D007n0001Sh000008oh004
000Gh1OP00030n800`000n`3k0020n`200000`?e0oH3m@020oD2000B0ol400001@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`030]l0000000<00543o`@000030oD3mP?e0083m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oIoogoo009oo`03001oogoo019oo`004goo00@007oo
Oomoo`El000A001m07dP001nH7i0001oH000Hn0003_P?n0001_P5n0000030n8010000n/3k0?[0P00
00L3mP?e0oH3m@?f0oD0000=0ol70000<P:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l9001<0ol2000070?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e17oo00<007ooOol04Woo000COol01000Oomoogoo1G`000@007dPO@00009n@007
001oP000In0003oP00000QOP00D000?R0n83hP0000<3k0050003m@?e0oD3mP020oD2000<0ol20000
0`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00@004X3o`8000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f0083m@Aoo`03001oogoo019oo`004goo00@007ooOomoo`El000:001m07dP001n
@000Oh0006OP0002?n000`005n0000030n802P000n/3k0?[0003m@?f0oD3mP?e0P002@?o1@0004P2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l400180ol2000060?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@Aoo`03001oogoo019oo`004goo00@007ooOomoo`El0003001m
8000009n@009001oP000Hn0003oP000Gh00000<3hP030003k0?/008000<3m@030oH0000000L3o`@0
0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`020[l200180ol300001@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP04Ool00`00Oomoo`0BOol001=oo`80
009oo`El000>001m0000OT0007mP001Sh6OP000oh0006n000083hP080003j`?/0003mP?e0oH3m@80
00L3o`80001G0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o00<004P3o`80000C0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD00goo0P00
57oo000COol01000Oomoogoo1G`000d007dP001n@000Oh0006OP000oh0006n0000020n801@000n`3
k0000oH00P?e0P001`?o0P000P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l00`;O0[l0000400150ol200020oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f0083m@Aoo`03001oogoo019oo`004goo00@007ooOomoo`El0004001m0000OT0200001VOP
000oh0006n000083hP080003j`?/0003mP?e0oH000L3o`80000=0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l06`0003/2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o00<004@3o`80000?0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e00Aoo`03001o
ogoo019oo`004goo00@007ooOomoo`Al0005001m07dP001n@00200002F?P000oh0005n0000?R0003
k002000010?f0oD3m@001@?o0`0000D2g`:o0[l2_`;O00<2_`030]l2_`0000@001/1W`T000030[l2
g`:o0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`8004@3o`8000050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH017oo00<007ooOol04Woo000:Ool50004Ool01000Oomoogoo17`0
00@007dP001n@080000?Hn0003_P000Gh0000n8000?[0003m@?f0oD3mP0000@3o`8000080]l2_`;O
0[l2g`:o0]l2_`D0000Y0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`040000<`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`0200140ol03@000oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
00Aoo`03001oogoo019oo`0037oo00<007ooOol017oo00@007ooOomoo`=l0005001m87d0001n@002
00000fOP000oh00200020n8200000`?e0oH3m@0200030ol200030[l010;O0[l2_`:o0`00<P6O0`00
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o000004<3o`8000<3m@050oH3
m@?e0oD3mP020oD4Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`04001oogooOol3O0001@00
O@1m8000OV000`0000/oh0006n0000?S0003k0000oH3m@0000<3o`8000040]l2_`;O0[l50000>05o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il30000<@;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O00@00443o`8000080oH3m@?f0oD3mP?e0oH3
m@Aoo`03001oogoo019oo`0000=oo`00000010001Goo00<007ooOol017oo0P000Woo0g`000D007dP
O@0007i000800009?n0001OP0003hP000n`000?f00800083o`8000040[l2g`:o0[l200100Il40003
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o0P00@@?o00@000?e0oD3mP<3m@040oIo
ogooOol2000DOol000aoo`03001oogoo00Aoo`04001oogooOol3O0001000O@0007i00`0000Toh000
0003h`000n`000?f00000`?o00D000;O0[l2g`:o0080000?0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O00T0000^0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl30000<0:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`800403o`8000050oD3mP?e0oH3m@04Ool00`00Oomoo`0B
Ool000aoo`03001oogoo00Aoo`04001oogooOol2O0001@00O@1m8000OT000P0000Toh0000003hP00
0n`000?f00000P?o0P000P:o00<2g`000000206O2@002@1O2@00:06O0P0000D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o0P00@0?o0P0000<3mP?e0oD017oo00<007ooOol04Woo000:Ool3
0006Ool01000Oomoogoo0W`000@007dP001n@0D000060n<000?/0003mP000P?o00@000:o0]l2_`80
00050Il1O`6O0Gl1W`0500001@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l00`1o05l0G`060000905o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`<0000`0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`00@@?o0P0000<3mGooOol00Woo00<007ooOol04Woo000<Ool00`00Oomoo`04Ool0
1000Oomoogoo0W`000@007d0001n@0H000040n`000?f00020ol00`000[l2_`0200040Il3000V05l3
000T0Il200000`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]l000000443o`03001oogoo
009oo`03001oogoo019oo`004goo00@007ooOomoo`9l0003001m800000D000050n8000000oH00002
0ol020000[l000000Il1O`6O0Gl2000205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`0000@0000Q
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0080000^0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l200100ol01@00Oomoogoo
000057oo000COol02@00OomoogooO00007dP001n@006000010?/000000?o0P0000<2_`000Il00`6O
0P002P1O2@00801O0P008@6O0P000`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`00?`?o17oo
00<007ooOol04Woo000COol20002Ool01G`0001m0000OT001@0000/3j`000003o`000]l2_`000Gl1
W`5o0080000407l0G`1O05l800002APO51lH7a@O61lD7aPO51lH7`05000205l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l00`1o05l0G`0200008@5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`020000
;P;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`00?P?o0goo0P0057oo000COol01`00Oomoogoo
O00007dP00T000060ol000;O0[l0006O0`00101O0P000a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l00aPO51lD7`05000J05l4000O0Il010000[l2_`;O0`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`02
0[l00`000ol3o`0k0ol4Ool00`00Oomoo`0BOol001=oo`07001oogooOoml0000O@00200000<3o`00
0]l00P0000<1O`0005l00P1O100001dH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO00@000<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o0080G`80000N0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0P0002`2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0P00>`?o
17oo00<007ooOol04Woo000COol01`00OomoogooO00007dP00H000060oD000000]l0006O0P0000@0
G`00000000<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l00aPO51l00002000I05l00`000Il1W`0M0Il200001@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l0000j0ol4Ool00`00Oomoo`0BOol001=oo`05001oogooOoml000<00000`6O
0000O`02000011@O61lD7aPO4@0001HH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7`80000507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`80
000O0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il00P0002/2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`02000h0ol4Ool00`00Oomoo`0BOol0
01=oo`05001oogooOoml000:00000`6O00000002000251l4000A?1l600000a@O61lD7`0251l01APO
51lD7a@O61l00a@O00DH7a@O51lD7aPO00<001L0G`8001l1W`050002_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2
g`:o0[l2_`;O000g0ol4Ool00`00Oomoo`0BOol001=oo`05001oogooOoml000900001P5o0000G`1o
000H7`80008l7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`0F
>1l00000000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l200000`1O07l0G`0205l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1@07l0G`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l003H3o`Aoo`03001oogoo019oo`004goo00D007ooOomoog`000P000030Il0001O
00@000Dl7`d000hl7`80008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00<0001O05l0
5@1O00<0006O0Il07@6O00D000:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01P;O0[l2_`:o0]l003D3o`Aoo`03001o
ogoo019oo`004goo0P000Woo00=l000000001@0000L1O`00000001@O000h7`02?1l400003F@OH1mT
7f0OI1mP7f@OH1mT7f0OI1mP7f@O0080008l7`05>1ll7c`O?1lh7`03?1l013PO?1ll7c`O0P00014D
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0080000507l0G`1O05l0O`0305l01@1o05l0
G`1O07l00`1O00H0O`1O05l0G`1o05l20000B`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`000[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0000e
0ol3Ool2000DOol001=oo`05001oogooOoml0009000011PO000003`O0`0001=P7f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`02000>?1l200001APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0361l0001O01H0G`030001W`6O01`1W`050002_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`0003@3o`Aoo`03001oogoo019oo`004goo00D007ooOomoog`000d00003H1mT7f0O00`00009I1mP
7f@OH1mT7f0OI1mP7f@O00<000<l7`05>1ll7c`O?1lh7`03?1l053PO?1l0000051lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61l2000305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1>
07l0G`1O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0P00<P?o17oo00<007ooOol04Woo000C
Ool01@00OomoogooO0002P0000=P7`0000000`0037`L0P0000YP7f@OH1mT7f0OI1mP7f@OH1mT7`80
00dl7`80008D7`0561lD7a@O51lH7`0351l01aPO51lD7a@O61lD7`0001H0G`030001W`6O01`1W`05
0002_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O000a0ol4Ool00`00Oomoo`0BOol001=oo`05001o
ogooOoml000;00000g`K0000000600002W`LO1]l77`KO1al6g`LO1]l77`K0`0000UP7f@OH1mT7f0O
I1mP7f@OH1l00P0000<l7cPO?1l00S`O00Dh7c`O?1ll7cPO00<l7`0B000H7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7`000`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0D01o05l0
G`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0002_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O000`0ol4Ool00`00Oomoo`0BOol001=oo`04
001oogooOol90002O1`20008O1850008O1`200002F@OH1mT7f0OI1mP7f@OH1mT7`02000<?1l01000
51lD7aPO0a@O00DH7a@O51lD7aPO00<D7`0361lD7`0001H0G`030001W`6O01`1W`050002_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`000303o`Aoo`03001oogoo019oo`004goo00@007ooOomooaD00005
O1=l4W`BO19l4`03000057`LO1]l77`KO1al6g`L001T7f0OI1mP7f@OH1mT7f0OI1mP7`00>1l3?1l0
1CPO?1ll7c`O>1l00c`O018001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O000305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1?07l0G`1O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0000;`?o17oo00<007ooOol04Woo000COol20002Ool8000017`B001l2G`8100000El2G`8
O0Ul27`9008000El4P8000Ml700<001T7f0OI1mP7f@OH1mT7f0OI1mP7`0033`O00@001@O51lH7`<D
7`0561lD7a@O51lH7`0351l00aPO51l0000F05l00`000Il1W`0L0Il01@000[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`040]l2_`:o000_0ol3Ool2000DOol001=oo`04001oogooOol<0004O00200001W`8O0Ul27`9O0P0
00=l4P03O1=l4W`B00800006O1]l77`KO1al6g`L0P0000]P7f@OH1mT7f0OI1mP7f@OH1l003PO00<l
7`05>1ll7c`O?1lh7`03?1l04P0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l000<0G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O04h0O`1O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O000^0ol4Ool00`00Oomoo`0BOol001=oo`04001oogooOol90009O002000017`9O0Ql2G`8
0P001W`B00<007`LO1`01G`L00/0060OI1mP7f@OH1mT7f0OI1mP7`0000`l7`04000D7a@O61l351l0
1APO51lD7a@O61l00a@O00<H7`0005l05@1O00<0006O0Il0706O00<000;O0[l00P:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`070]l2
_`:o0[l2g`:o0000;P?o17oo00<007ooOol04Woo000COol01000Oomoogoo1`003G`00P0000El27`9
O0Ql2@00009l4P0HO1=l4W`BO18007`KO1al6g`LO1]l77`K001P7f@OH1mT7f0OI1mP7f@O000l7cPO
0c`O00Dh7c`O?1ll7cPO00<l7`0B000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0001o0`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0C@1o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0000;@?o17oo00<007ooOol04Woo000COol01000Oomoogoo1@004G`000H007`8O0Ul27`9
0006O1800`00O1al7005O1`02P00H1mT7f0OI1mP7f@OH1mT7`0033`O00D001@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l00aPO0000G`0D05l00`000Il1W`0L0Il00`000[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2g`:o
0[l2_`;O000]0ol4Ool00`00Oomoo`0BOol001=oo`04001oogooOol4000CO0001P00O0Ql2G`8O0T0
009l4P0HO1=l4W`B001l77`KO1al6g`LO1]l7000I1mP7f@OH1mT7f0OI1mP7f@O000l7cPO0c`O00Dh
7c`O?1ll7cPO008l7`0C000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0007l00`1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0B`1o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0002g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0
000]0ol4Ool00`00Oomoo`0BOol001=oo`04001oogooOol4000DO0001P00O0Ql2G`8O0T000El4P03
001l77`L00El700:001T7f0OI1mP7f@OH1mT7f0O000<?1l00`0061lD7`0251l01APO51lD7a@O61l0
0a@O00DH7a@O51lD7`0001H0G`030001W`6O01/1W`040002_`:o0]l30[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`00
02`3o`Aoo`03001oogoo019oo`004goo00@007ooOomoo`<001Il0006001l27`9O0Ql2@000W`B01El
4g`B001l6g`LO1]l77`KO1al6`00H1mT7f0OI1mP7f@OH1mT7f0O00000S`O00Dh7c`O?1ll7cPO00<l
7`0F>1ll7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0001O07l305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`1:0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0002_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l002`3o`Aoo`03
001oogoo019oo`004goo0P000Woo0`005g`000H007`8O0Ul27`90004O1820006O1`02`00H1mT7f0O
I1mP7f@OH1mT7f0O000033`O00<001PO51l00Q@O00DH7a@O51lD7aPO00<D7`0461lD7a@O000E05l0
0`000Il1W`0L0Il01@000[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`:o000[0ol3Ool2000DOol001=oo`04
001oogooOol2000HO0001P00O0Ul27`9O0P000=l4P0DO1=l4P00O1]l77`KO1al6g`L001T7f0OI1mP
7f@OH1mT7f0OI1l000<l7`05>1ll7c`O?1lh7`03?1l04SPO000D7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51l000<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O04d0O`1O0001O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`0002/3o`Aoo`03001oogoo019oo`004goo00D007ooOomoo`0001Ul
0007001l27`9O0Ql2G`8000017`B00<007`LO1`01G`L00/006@OH1mT7f0OI1mP7f@OH1mT7`0000/l
7`04000D7a@O61l351l01APO51lD7a@O61l00a@O00<H7`0005l0501O00<0006O0Il0706O00<000:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`060]l2_`:o0[l2g`00:`?o17oo00<007ooOol04Woo000COol01000Oomoogoo6g`0
00L007`8O0Ul27`9001l4`03O18057`C001l77`KO1al6g`LO1/0060OI1mP7f@OH1mT7f0OI1mP7`00
>1l3?1l01CPO?1ll7c`O>1l00c`O018001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0007l3
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1<07l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O000Z0ol4Ool00`00Oomoo`0BOol000Yoo`@000Eoo`04001oogooOolKO0001P00O0Ul27`9
O0P000El4P03001l77`L00El700:001P7f@OH1mT7f0OI1mP7f@O000<?1l01@0051lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`030000G`1O01<0G`030001W`6O01`1W`040002_`:o0]l30[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`0002X3o`Aoo`03001oogoo019oo`002Goo00<007ooOol00Woo00<007ooOol00Woo00@0
07ooOomooa]l0006001l27`9O0Ql2@000W`B01El4g`BO18007`LO1]l77`KO1al6g`L001T7f0OI1mP
7f@OH1mT7f0O00000S`O00Dh7c`O?1ll7cPO00<l7`0C>1ll7`0061lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO00000P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0CP1o05l0G`000Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0002
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l002X3o`Aoo`03001oogoo019oo`002Goo00<007ooOol00Woo
00<007ooOol00Woo00@007ooOomooa]l0006001l2G`8O0Ul20001G`B00<007`LO1`01G`L00X0060O
I1mP7f@OH1mT7f0OI1l000`l7`03000D7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51l0000E05l0
0`000Il1W`0L0Il00`000]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00L2g`:o0[l2_`;O0[l0000Z0ol4Ool00`00Oomoo`0B
Ool000Uoo`03001oogoo009oo`03001oogoo009oo`80009ooa]l0007001l27`9O0Ql2@00O1<00g`B
01Al4`00O1al6g`LO1]l77`KO1`006@OH1mT7f0OI1mP7f@OH1l003PO0c`O00Dh7c`O?1ll7cPO00<l
7`0B000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0001o0`1O00D0O`1O05l0G`1o00<0G`05
07l0G`1O05l0O`0305l0C01o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`00:P?o0goo0P0057oo
0009Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoogoo6g`000H007`9O0Ql2G`80005O180
0`00O1al7005O1`02P00H1mT7f0OI1mP7f@OH1mT7`0033`O00D001@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l00`0005l0G`0C05l00`000Il1W`0L0Il010000[l2_`;O0`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l0
000Z0ol4Ool00`00Oomoo`0BOol000Uoo`03001oogoo009oo`03001oogoo009oo`04001oogooOolK
O0001P00O0Ql2G`8O0T0009l4P0EO1=l4W`B001l77`KO1al6g`LO1]l7000I1mP7f@OH1mT7f0OI1mP
7`00008l7`05>1ll7c`O?1lh7`03?1l04cPO?1l001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7`000080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O04h0O`1O05l0006O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`000[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O000Z0ol4Ool00`00Oomoo`0BOol000Uoo`03001oogoo009oo`03001oogoo
009oo`04001oogooOolKO0001P00O0Ul27`9O0P000El4P03001l77`L00El700:001P7f@OH1mT7f0O
I1mP7f@O000<?1l00`0051lH7`0351l01APO51lD7a@O61l00a@O00<H7a@O00005@1O00<0006O0Il0
706O00<000;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`070]l2_`:o0[l2g`:o0000:P?o17oo00<007ooOol04Woo000:Ool4
0005Ool01000Oomoogoo6g`000L007`8O0Ul27`9001l4`03O18057`C001l77`KO1al6g`LO1]l7000
I1mP7f@OH1mT7f0OI1mP7`00>1l3?1l01CPO?1ll7c`O>1l00c`O018001PO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7`0007l305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1<07l0006O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O000Z0ol4Ool00`00Oomoo`0BOol001=oo`04001oogooOolK
O0001P00O0Ul27`9O0P000Al4P03001l77`L00El700;001T7f0OI1mP7f@OH1mT7f0OI1l0000;?1l0
0`0061lD7`0251l01APO51lD7a@O61l00a@O00@H7a@O51l001D0G`030001W`6O01`1W`050002_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00@2g`:o0[l002/3o`Aoo`03001oogoo019oo`004goo00D007ooOomoo`0001Ul
0006001l2G`8O0Ul20000g`B01El4g`B001l6g`LO1]l77`KO1al6`00H1mT7f0OI1mP7f@OH1mT7f0O
00000S`O00Dh7c`O?1ll7cPO00<l7`0B>1l001@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`00
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0C@1o05l0005o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`000]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0000:`?o17oo00<007ooOol04Woo000COol01000Oomoogoo0`005g`000H007`8O0Ul
27`90005O1800`00O1al7004O1`02`00H1mT7f0OI1mP7f@OH1mT7f0O000033`O00@001@O51lH7`<D
7`0561lD7a@O51lH7`0351l00aPO0000G`0D05l00`000Il1W`0L0Il00`000[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2
g`:o0[l2_`;O000[0ol4Ool00`00Oomoo`0BOol001=oo`80009oo`<001Il0006001l27`9O0Ql2@00
0W`B01El4g`BO18007`LO1]l77`KO1al6g`L001T7f0OI1mP7f@OH1mT7f0O00000S`O00Dh7c`O?1ll
7cPO00<l7`0F>1ll7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0001O07l305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1;0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`00
02/3o`=oo`8001Aoo`004goo00@007ooOomoo`@001El0005001l2G`8O0T00006O1800`00O1al7004
O1`02`00I1mP7f@OH1mT7f0OI1mP7f@O000033`O00<001@O61l00a@O00DH7a@O51lD7aPO00<D7`03
61lD7`0001H0G`030001W`6O01/1W`030002g`:o0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01`;O0[l2_`:o0]l2_`0002`3o`Ao
o`03001oogoo019oo`004goo00@007ooOomoo`@001Al0005001l2G`8O0T00002O18067`CO19l4W`B
001l6g`LO1]l77`KO1al6`00H1mT7f0OI1mP7f@OH1mT7`00?1lh7`<l7`05>1ll7c`O?1lh7`02?1l0
4`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l0001o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O04`0O`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0002_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l002`3o`Aoo`03001o
ogoo019oo`004goo00@007ooOomoo`D0019l0005001l2G`8O0T00007O1800`00O1al7004O1`02`00
H1mT7f0OI1mP7f@OH1mT7f0O000033`O00<001PO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51l0000E05l00`000Il1W`0K0Il01@000[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`:o000]0ol4Ool00`00
Oomoo`0BOol001=oo`04001oogooOol6000?O00200001g`9O0Ql2G`8001l4W`C00=l4P800006O1al
6g`LO1]l77`K0P0000YT7f0OI1mP7f@OH1mT7f0O000h7`<l7`05>1ll7c`O?1lh7`03?1l04P0061lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l000<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O04d0O`1O0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0002d3o`Aoo`03001oogoo019o
o`004goo00@007ooOomoo`L000al00800004O0Ql2G`8O0T20005O1800`00O1al7005O1`02`00H1mT
7f0OI1mP7f@OH1mT7f0O000033`O00<001PO51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51l0
000E05l00`000Il1W`0L0Il010000[l2_`;O0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`00;@?o17oo00<007oo
Ool04Woo000COol01000Oomoogoo2@001g`00`0000Il2G`8O0Ul27`90002O1800g`CO19l4P020000
1W`KO1al6g`LO1]l7080000;H1mT7f0OI1mP7f@OH1mT7f0O000h7`03?1l01CPO?1ll7c`O>1l00c`O
018001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O000305l01@1o05l0G`1O07l00`1O00D0
O`1O05l0G`1o00<0G`1>07l0G`1O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`00;P?o17oo00<0
07ooOol04Woo000COol20002Ool@00001G`9O0Ql2G`8O0T00`0017`B0P001g`L00`006@OH1mT7f0O
I1mP7f@OH1mT7f0O000<?1l00`0061lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD7`0001H0
G`030001W`6O01`1W`030002_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01`;O0[l2_`:o0]l2_`0002h3o`=oo`8001Aoo`00
4goo00@007ooOomoo``00004O0Ql2G`8O0T500001G`CO19l4W`BO1<00`0000Il77`KO1al6g`LO1/2
000036@OH1mT7f0OI1mP7f@OH1mT7f0O000h7`<l7`05>1ll7c`O?1lh7`03?1l04P0061lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51l000<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
04l0O`1O05l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`000[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0000_0ol4Ool00`00Oomoo`0BOol0
01=oo`04001oogooOol@0008O1820007O1`20000360OI1mP7f@OH1mT7f0OI1mP7f@OH1l000`l7`03
000H7a@O008D7`0561lD7a@O51lH7`0351l01APO51lD7a@O00005P1O00<0006O0Il0706O00<000:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`070]l2_`:o0[l2g`:o0000<0?o17oo00<007ooOol04Woo000COol01000Oomoogoo
2`0000=l700000002P0000Ml6g`LO1]l77`KO1al6`0200002f@OH1mT7f0OI1mP7f@OH1mT7f0OI1l0
0P0000Dh7c`O?1ll7cPO00<l7`03>1ll7c`O0080000A61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD
7aPO51l0000305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1@07l0G`1O0001W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl000:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l00303o`Aoo`03001oogoo019oo`004goo00D007ooOomoog`0
00T00003I1l00000011l7080000;H1mT7f0OI1mP7f@OH1mT7f0OI1mP7`02000<?1l00`0051lH7`03
51l01APO51lD7a@O61l00a@O00DH7a@O51lD7`0001L0G`030001W`6O01/1W`030002_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00P:o00<000?o0ol0;`?o17oo00<007ooOol04Woo000COol01@00Oomoogoo
O0001`0000DD7`000000060O00<0000:O1]l77`KO1al6g`LO1]l77`KO1`300002f@OH1mT7f0OI1mP
7f@OH1mT7f0OI1l00P000S`O00Dh7c`O?1ll7cPO00<l7`0F>1ll7c`O000D7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O000305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1@07l0
G`1O05l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l00383o`Aoo`03001oogoo019oo`004goo
00D007ooOomoog`000X00005?1l00000001P7`0:000036@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7`80
00dl7`80000351lH7a@O008D7`0561lD7a@O51lH7`0351l00aPO51lD7`02000G05l00`000Il1W`0L
0Il00`000]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O0082_`030003o`?o0343o`Aoo`03001oogoo019o
o`004goo0P000Woo00=l000000001P0000H0G`00000003`O>1l200004F@OH1mT7f0OI1mP7f@OH1mT
7f0OI1mP7f@OH1mT7f0OI1l0100000Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`02000041PO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O0P0000D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00P1O0P0001d1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0080000/0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l003@3o`=o
o`8001Aoo`004goo00D007ooOomoog`000T0000305l000000080008l7a4000hl7`<000<D7`0561lD
7a@O51lH7`0351l01APO51lD7a@O61l00P005`1O0P007P6O00<000:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`020[l00`000ol3o`0c0ol4Ool00`00Oomoo`0BOol001=oo`05001oogooOoml000;00000`1O
000D7`020003?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l0
5CPO0000000051lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`02000205l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`020000C@5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0002_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0000=P?o17oo00<007ooOol04Woo000COol01@00OomoogooO0002P0000H1W`00
05l001@O61l4000E?1l3000351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`030000G`1O
01H0G`030001W`6O01h1W`030002_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00P:o00<000?o0ol0=@?o
17oo00<007ooOol04Woo000COol01@00OomoogooO0002`0000<1O`0000000P0000@H7a@O61lD7`@0
0003?1lh7c`O008l7`04>1ll7c`O?1l8000051@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61l3000205l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0407l0G`1O05l20000
7`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0080000]0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`0003P3o`Aoo`03001oogoo019oo`00
4goo00D007ooOomoog`000<00003Oh00000000<000070ol000000001W`0005l00`000Q@O00<H7a@O
51l02@0000DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O10005`1O
0P00806O00@000:o0[l2g`<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00P:o00<000?o0ol0=`?o17oo00<007oo
Ool04Woo000COol01`00OomoogooO00007d000T000040[l2g`000Il2000205l200008Q@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
0P000`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01P1o05l0G`1O07l0G`80001@0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0002g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l003X3o`Aoo`03001oogoo019oo`004goo
00L007ooOomoog`0001m8006000010?/0003o`000P:o00@0006O0Il000<0G`<000<D7`0561lD7a@O
51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0461l00000000I05l2000Q0Il2
00020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`00000k0ol4Ool00`00Oomoo`0BOol001=oo`80
009oo`03O00007d000T000070ol000000]l0006O0Gl00P000P1O00<0O`1O00001000018D7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61l5000205l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l200008@6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`020000;0:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2000m0ol3Ool2000DOol001=oo`09001oogooOoml0000OB0007i000T000030ol000:o
00800081W`<000H0Ga8001/0G`@00241W`8000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O
000o0ol4Ool00`00Oomoo`0BOol001=oo`04001oogooOol2O0000`00OB00000500002@?R000000?f
0003o`000]l2_`0200000`6O0Gl1W`02000305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0307l0G`1O00<0
000S0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`020000;@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0200100ol4Ool0
0`00Oomoo`0BOol001=oo`04001oogooOol2O0001000O@0007i01P0000H3k0000oD000?o00020[l0
0`;O000000030Il4000X05l2000T0Il200020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l0
00110ol20003Ool00`00Oomoo`0BOol000Yoo`D000Aoo`04001oogooOol2O0001000OB0007i01@00
00L3h`000n`000?f0003o`0200002P:o0]l2_`000Gl1W`5o0Il1O`6O100000<0G`1o05l00P1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00<0O`1O0000100002@1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il20000;@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`0300110ol00`000oEo
o`03Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`04001oogooOol2O0000`00O@1m80040000
2CoP000000?R0003k0000oD000020ol010000[l2g`:o0P00206O1@004P1O20009P6O0`0000D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00P00@P?o0P0000<3m@?fOol00goo00<007ooOol04Woo
000<Ool00`00Oomoo`04Ool01000Oomoogoo0W`000D007dPO@0007i000@000086n0000?S0003k000
0oH00083o`8000030]l2_`;O00<0000:0Il1O`6O0Gl1W`5o0Il1O`6O0GlB0000:P6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`@0000^0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l200130ol01@00
0oH3m@?f0oD017oo00<007ooOol04Woo000<Ool00`00Oomoo`04Ool20002Ool3O0000`00OB1m0004
00000coP000000020n8200020oD01P000ol3o`?o0002g`<2_`030]l000000481W`8000030[l2g`:o
0082_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`:o0[l00P00@`?o0P000P?e00<3mP?e0oD00goo0P00
57oo000<Ool00`00Oomoo`04Ool01000Oomoogoo0g`000D007d0OB0007iP00@000095n0000?R0003
j`000oD3mP0000<3o`8000050[l2g`:o0]l2_`030000?05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`<0000`0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0P00A0?o00P000?e0oH3m@?f0oD3mP?e17oo00<007ooOol04Woo000<Ool0
0`00Oomoo`04Ool01000Oomoogoo0g`000D007dPO@0007i000<00008?n0001OP0003hP000n`00083
m@030003o`?o0083o`800082_`040]l2_`:o0[l5000b0Il500001@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l00`;O000000130ol300030oD01@?f0oD3m@?e0oH017oo00<007ooOol04Woo
000:Ool30006Ool01000Oomoogoo17`000@007dP001n@080000<Hn0003_P000Gh0000n8000?[0003
m@?f0P0010?o0P0000T2_`;O0[l2g`:o0]l2_`;O0[l01@0002P1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`D0
000c0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O00<004<3o`80000;0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@04Ool00`00Oomoo`0BOol000aoo`03001oogoo00Aoo`04001oogoo
Ool4O0001@00O@1m8000OT000P0000=Sh00000000QOP0P000P?/0P000P?e00<000?o0ol00`?o0P00
00D2g`:o0[l2_`;O00<2_`040]l2_`:o0[l4000P0Il400001@;O0[l2_`:o0]l00`:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01P;O0[l2_`:o0]l2_`8004@3o`800083m@050oH3m@?e0oD3mP030oD00`?f0oD3
m@04Ool00`00Oomoo`0BOol001=oo`04001oogooOol5O0001000O@0007i00P0000iWh000?n0001_P
0003hP000n`3j`?/0003mP?e0P001@?o0P0000h2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O2@00
00T1W`5o0Il1O`6O0Gl1W`5o0Il03P0003H2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l400140ol200003`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@04Ool0
0`00Oomoo`0BOol001=oo`04001oogooOol5O0003P00OB0007i0001oP000In0003oP000Gh0000n82
00020n`010000oD3m@?f0P001@?o0`0000<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`020[l900001@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`040]l0000000160ol200001@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@030oIoogoo009oo`03001oogoo019oo`004goo00@007ooOomoo`El000>001m0000OT00
07mP001Sh6OP000oh0006n000083hP090003j`?/0003mP?e0oH3m@0000H3o`<0001J0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0P00A`?o0P00
01<3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@04Ool00`00Oomoo`0BOol001=o
o`80009oo`El0003001m8000009n@009001oP000Hn0003oP000Gh00000<3hP030003k0?/00800003
0oD3mP?e008000L3o`D000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O
0000000200160ol300020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3m@?e00=o
o`8001Aoo`004goo00@007ooOomoo`El000:001m07dP001n@000Oh0006OP0002?n000`005n000003
0n802P000n/3k0?[0003m@?f0oD3mP002`?o0`0004X2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
1000B0?o0P0001P3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD4
Ool00`00Oomoo`0BOol001=oo`04001oogooOol5O0001000OB1m00000Wi000X007n0001Wh000?n00
01_P5n0000<3hP070003k0?/0n`000?e0oH00P?e0P0030?o0P0000<2_`;O0[l00P:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`020[l4
001:0ol200000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP04Ool00`00Oomoo`0BOol001=oo`04001oogooOol5O0004@00O@1m8000OV1n@000Of0006?P
000kh3oP000Kh1OP00000`?R00X000?[0n`3j`000oD3mP?e0oH3m@<000/3o`@0000k0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`05001<0ol20000
70?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e17oo
00<007ooOol04Woo000COol01000Oomoogoo1G`000@007dPO@0000=n@005001oP000Hn000002?n00
10006n0Gh0000`?R00@000?/0n`3k08000060oH3m@?e0oD3mP?e0P003@?o2@000P:o00D2g`:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l00`;O0[l2_`05001>0ol300030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD00`?f0oD3m@04Ool00`00Oomoo`0BOol001=oo`04001oogooOol6
O0004P00OB1m0000OT1nH000Oh0006OPHn0003_P?n0001_P5n0000<3hP0=0003j`?/0n/3k0000oH3
m@?f0oD3mP?e0oH00`004`?o2@0001L2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O00d00543o`80000Q0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e00Aoo`03001oogoo019oo`004goo00@007ooOomoo`Il
0004001m07dP0003OT001@00Oh0006OP00000SoP00D001OP6n0Gh00000<3hP8000<3k08000<3m@05
0oH3m@?e0oD3mP02000J0olG001J0ol400020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mWooOol00Woo00<007ooOol04Woo000C
Ool20002Ool6O0001@00OB1m07dP00000Wi000d007mP001Sh6OP000oh3_P000Gh1_P5n0000030n80
1P?S0003k0?[0n`3j`<000070oD3mP?e0oH3m@?f0oD01000PP?o1@0002L3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD00goo0P0057oo000COol01000Oomoogoo1W`000D007d0OB1m0000009n@006001oP7n0001Sh000
0coP00D001OP6n0Gh00000@3hP030003k0?/00@3k0030003m@?f00<3m@050oH3m@?e0oD3mP03001l
0ol300000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f0083m@Aoo`03001oogoo019oo`004goo00@0
07ooOomoo`Il0006001m87d0OB1m00000Wi000H007n0001Wh6?P0002?n001S_P000Gh1_P0003h`<3
hP080n<000?/0n/3k0?[0n`3j`80000;0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP02001h0ol20000;`?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD017oo00<007ooOol04Woo000COol01000Oomo
ogoo1g`000D007dPO@1m8000009n@007001oP7n0001Wh6?P00000coP00@001OP6n0000D3hP030003
k0?/00D3k0030003mP?e0083m@050oH3m@?e0oD3mP030oD3001b0ol300001@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD00`?fOomoo`02Ool00`00Oomoo`0BOol001=oo`04001oogooOol7
O0003P00O@1m87d0OB0007iPOT0007mP001Sh6OP0003?n0010006n0Gh1_P0P000`?R00T3h`000003
j`?/0n/3k0?[0n`00P0000d3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@04001Y0ol50000=0?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e17oo00<007ooOol04Woo000COol0
1000Oomoogoo1g`000H007dPO@1m87d00002OT001`00Oh1oP000Hn1Wh00000<oh006000Gh1OP6n0G
h0001@?R00<000?/0n`01@?/0`0000<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3m@030oH0000000<0
05l3o`D00083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP02
0oD4Ool00`00Oomoo`0BOol001=oo`04001oogooOol7O0001P00O@1m87d0OB00009n@008001oH7n0
001Wh6?PIn0000<oh006000Kh1OP6n0Gh0000`?R00`3h`?R000000?/0n/3k0?[0n`3j`?/0n/20000
4@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH01@00EP?o100003h3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e17oo00<007oo
Ool04Woo000COol01000Oomoogoo27`000D007d0OB1m000000=n@008001oP7n0001Wh6?PIn0000<o
h006000Gh1OP6n0Gh0001P?R0P0020?/0`000P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD00`?f0000000200190ol900000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00Aoo`03001oogoo019oo`004goo0P00
0Woo27`000H007dPO@1m87d00002OT002@00Oh1oH7n0001Wh6?PIn000003?n001P006n0Gh1_P5n00
00<3hP0?0n<3hP?R0n8000?[0n`3j`?/0n/3k0?[0n`3j`?/0080000E0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e00T003`3o`@0001;0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e00=oo`8001Aoo`004goo00@007ooOomoo`Ul0005001m87d0OB000003OT002000Oh1oP000
Hn1Wh6?P0003?n001`005n0Gh1OP6n0Gh00000L3hP030003k0?/00T3k08000050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3m@?e0oD8000X0ol<00001@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00P?e17oo00<007ooOol04Woo000COol01000Oomo
ogoo2G`0018007d0OB1m0000OT1nH7i0001oH7n0Of0006?PIn1Sh000>n02?n001P005n0Kh1OP6n0G
h0800083hP040n<3hP?R0n8200002`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P000283m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mRP0
001K0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD017oo00<007ooOol04Woo000COol01000Oomoogoo2G`000H007dPO@1m87d00003OT002@00
Oh1oP7n0001Sh6OPHn000003?n0200025n0011_P5n0Gh0001`?R0P002`?/0`0000<3m@?f0oD00P?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP04Ool00`00Oomoo`0BOol001=oo`04001oogooOol9O0001P00O@1m87d0
OB00009n@00<OV0007n0Of1oP000In1Sh6OP000oh3_P0coP00H001_P5n0Kh1OP6n0200000`?R0n<3
hP020n8040?S0n8000000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0P000:03mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@Aoo`03001oogoo019oo`004goo00@007ooOomoo`Yl0006001m07dPO@1m80000gi000T007n0
Oh1oP000In1Sh6OP00001CoP00@001OP5n0Kh0<Gh0030003hP?R00H3hP8000`3k0<00083m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
0`?f0oD3m@04Ool00`00Oomoo`0BOol001=oo`04001oogooOol:O0001P00OB1m07dPO@0000=n@00<
001oH7n0Of1oP000In1Sh6OP000oh3_P0coP00X001_P5n0Kh1OP6n0Gh0000n83h`<3hP0C0n<3hP?R
0n8000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`01@0009P3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e17oo00<007ooOol04Woo000C
Ool20002Ool:O0001P00O@1m87d0OB0000An@003001oP7n0009oP005001Wh6?PIn000005?n001000
5n0Gh1_P0aOP0P0020?R0P004@?/0`0000D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00=oo`8001Aoo`004goo00@007ooOomoo`]l0007001m07dP
O@1m8000OV000Wi000d007n0Of1oP7mP001Sh6OPHn1Wh000?n0kh003?n0020006n0Gh1_P5n0Kh1OP
6n0200030n801@?S0n83hP?R0n<00P000183j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`20000T`?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@04Ool00`00Oomoo`0BOol001=oo`04001oogooOol;O0001P00OB1m07dPO@0000An@003001oP7n0
009oP006001Sh6OPHn1Wh0001CoP00@001OP5n0Kh0<Gh0036n0Gh00000T3hP800183k0@000050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f0083m@Aoo`03001oogoo019oo`00
4goo00@007ooOomoo`al000G001m87d0OB1m0000OT1nH7i0001oH7n0Of1oP000In1Sh6OPHn1Wh000
?n0kh003?n002P006n0Gh1_P5n0Kh1OP6n0Gh0000`?R00D3h`?R0n83hP?S0083hP80000D0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0@0002;0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD017oo00<007ooOol04Woo0009Ool50005Ool01000Oomoogoo37`000H0
07d0OB1m07dP0004OT000`00Oh1oP002Oh001P00In1Sh6OPHn0000Hoh004000Gh1OP6n035n000a_P
5n00000;0n82000F0n`500000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mWooOol00Woo00<0
07ooOol04Woo0009Ool01@00Oomoogoo00001Goo00@007ooOomoo`al0006001m87d0OB1m00000gi0
00enH7i0001oH7n0Of1oP000In1Sh6OPHn000002?n0013_P?n0oh3oP0P0000LGh1_P5n0Kh1OP6n0G
h00200020n801@?S0n83hP?R0n<00`?R01`3h`00000000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`D0001o0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD00`000goo00<007ooOol04Woo
000:Ool00`00Oomoo`06Ool01000Oomoogoo3G`000H007dPO@1m87d00004OT000`00Oh1oP003Oh00
1P00In1Sh6OPHn0000Loh003000Gh1_P00<Gh0036n0Gh1OP008000`3hP8001/3k0T000030oD3mP?e
0083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD900020n`4Ool00`00Oomoo`0BOol000]oo`03
001oogoo00Eoo`80009oo`el0007001m07dPO@1m8000OV000gi000enH000Oh1oH7n0Of0006?PIn1S
h6OPHn000002?n003c_P?n0oh3oP>n0001OP6n0Gh1_P5n0Kh1OP6n0Gh00200001@?S0n83hP?R0n<0
0`?R00@3h`?R0n83hP<0000Q0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00@0001T0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD500002`?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/00goo0P0057oo000<Ool00`00Oomoo`04Ool01000Oomoogoo3G`000L0
07dPO@1m87d0OB000004OT000`00Oh1oP003Oh001P00Hn1Wh6?PIn1Sh08000Hoh003000Gh1_P00<G
h0066n0Gh1OP5n0Kh0003P?R0P008`?/2@000P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@T00103k0Aoo`03001oogoo019oo`003Goo00<007ooOol00goo00@007ooOomoo`el
0009001m07dPO@1m87d0001n@7iP00=n@00@001oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn0003oP>n03
?n003S_P000001_P5n0Kh1OP6n0Gh1_P5n0Kh0000n<30n801@?S0n83hP?R0n<00`?R00<3h`?R0n80
0P0002X3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`90000@0?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e2@0001T3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`04Ool00`00Oomoo`0BOol000Uoo`05
001oogooOol00005Ool01000Oomoogoo3G`000P007dPO@1m87d0OB1m000017i000<007n0Oh000gn0
00T006OPHn1Wh6?PIn1Sh6OP00001coP00<001_P5n000QOP00DKh1OP5n0Gh1_P008000l3hP800343
k0h000030oD3mP?e0083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@030oH3m@?e01800283k0Aoo`03001oogoo019oo`002Woo0`001Woo00@007ooOomoo`il0007
001m87d0OB1m07dP00000Wi0015nH7i0OT0007n0Of1oP7mPOh0006OPHn1Wh6?PIn1Sh000008oh00B
>n0oh3oP?n0kh3oP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0000`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`040000>`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/0800003@3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`Aoo`03001oogoo019oo`004goo00@007ooOomoo`il0008001m07dPO@1m87d0OB0000An@003001o
P7n000AoP008001Wh6?PIn1Sh6OPHn0000Poh003000Kh1OP008Gh0066n0Gh1OP5n0Kh1OP0P004P?R
0`00S0?/17oo00<007ooOol04Woo000COol01000Oomoogoo3W`000P007dPO@1m87d0OB1m00000gi0
015nH7i0001oH7n0Of1oP7mPOh0006OPHn1Wh6?PIn1Sh000008oh00B>n0oh3oP?n0kh3oP000Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P0`0000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80SP?S0n80
00000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[17oo00<007ooOol04Woo000COol0
1000Oomoogoo3W`000T007d0OB1m07dPO@1m87d000001Gi000<007n0Oh0017n000P006OPHn1Wh6?P
In1Sh00023oP0P000aOP00DKh1OP5n0Gh1_P00<Gh0036n0000?R0183hP@008H3k0Aoo`03001oogoo
019oo`004goo0P000Woo3g`000T007d0OB1m07dPO@1m8000OV000gi0011nH7i0001oH7n0Of1oP7mP
001Sh6OPHn1Wh6?PIn1Sh0800003?n0kh3oP008oh003>n0oh3oP0080000;6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh00200030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP030n<3hP0000<00022
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3Ool2000DOol001=oo`04001oogooOol?O0002@00OB1m07dPO@1m
87d0OB000005OT000`00Oh1oP004Oh002P00Hn1Wh6?PIn1Sh6OPHn1Wh0002CoP00@001OP5n0Kh0<G
h0066n0Gh1OP5n0Kh1OP0P005`?R0P00P0?/17oo00<007ooOol04Woo000COol01000Oomoogoo3g`0
00/007d0OB1m07dPO@1m87d0001n@7iP00=n@00DOV0007n0Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OP
Hn1Wh000?n0kh0<oh00B>n0oh3oP?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0P0000<3hP?S
0n800P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n8000030000O0?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
17oo00<007ooOol04Woo000COol01000Oomoogoo3g`000T007dPO@1m87d0OB1m07dP00001gi000<0
07n0Oh0017n000X006?PIn1Sh6OPHn1Wh6?PIn0000Toh08000035n0Kh1OP008Gh0056n0Gh1OP5n0K
h0035n02000I0n84001h0n`4Ool00`00Oomoo`0BOol001=oo`04001oogooOol@O0002@00OB1m07dP
O@1m87d0OB000002OT0067iPOT1n@7i0001oH7n0Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OPHn1Wh000
?n0kh0<oh00D>n0oh3oP?n0kh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh08000<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP@0001d0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`Aoo`03001oogoo019oo`004goo
00@007ooOomooa1l0009001m07dPO@1m87d0OB1m000000Mn@003001oP7n000AoP00;001Wh6?PIn1S
h6OPHn1Wh6?PIn00000:?n000`005n0Kh0035n001A_P5n0Gh1OP6n000aOP00@Kh1OP000001d3hPD0
06l3k0Aoo`03001oogoo019oo`004goo00@007ooOomooa5l0009001m07dPO@1m87d0OB1m000000=n
@00HOV1n@7i0OT0007mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OP000oh3_P0coP00Dkh3oP
?n0oh3_P0080000?6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P008000030n83h`?R0083hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP030n<3hP?R00<0001/
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[17oo00<007ooOol04Woo000COol20002
OolAO0002@00OB1m07dPO@1m87d0OB000007OT000`00Oh1oP005Oh002`00In1Sh6OPHn1Wh6?PIn1S
h6OP00002coP0P000aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh1OP5n03000P0n86001V0n`3Ool2000D
Ool001=oo`04001oogooOolAO0002`00O@1m87d0OB1m07dPO@1m8000OV000gi001QnH7i0OT0007n0
Of1oP7mPOh1oH7n0001Wh6?PIn1Sh6OPHn1Wh6?PIn0003oP>n03?n001C_P?n0oh3oP>n000SoP0180
01OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0200020n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?R00000`000683
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[17oo00<007ooOol04Woo000COol01000Oomoogoo4W`000T007d0OB1m07dP
O@1m87d0000027i000<007n0Oh001Gn000X006OPHn1Wh6?PIn1Sh6OPHn1Wh08000/oh080008Gh005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000QOP0`009@?R1@00G@?/17oo00<007ooOol04Woo000C
Ool01000Oomoogoo4W`000`007dPO@1m87d0OB1m07dPO@0007i0OV03OT0067iPOT0007mPOh1oH7n0
Of1oP7mPOh0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?P000kh0<oh005>n0oh3oP?n0kh003?n0050006n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0200030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00@0
001I0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`04Ool00`00Oomoo`0BOol001=oo`04001oogooOolBO0002@00O@1m87d0OB1m07dPO@1m80020007
OT000`00Oh1oP006Oh003000In1Sh6OPHn1Wh6?PIn1Sh6OPHn0000`oh08000035n0Kh1OP008Gh005
6n0Gh1OP5n0Kh0035n001Q_P5n0Gh1OP6n0Gh0<002T3hPL00583k0Aoo`03001oogoo019oo`004goo
00@007ooOomooa9l000;001m87d0OB1m07dPO@1m87d0OB000002OT0077iPOT1n@7i0OV0007n0Of1o
P7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OPHn0003_P0coP00Dkh3oP?n0oh3_P00<oh00G
>n0000006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh00200001@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP060n<3hP?R0n83h`?R1`0004/3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/0
17oo00<007ooOol04Woo000COol01000Oomoogoo4W`000`007d0OB1m07dPO@1m87d0OB1m07dP0007
OT000`00Oh1oP007Oh003000In1Sh6OPHn1Wh6?PIn1Sh6OPHn0000hoh003000Kh1OP008Gh0056n0G
h1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh0000000<`?R2@00@P?/17oo00<007ooOol04Woo
000COol01000Oomoogoo4g`000/007d0OB1m07dPO@1m87d0OB1m000000=n@00LOV1n@7i0OT1nH000
Oh1oH7n0Of1oP7mPOh1oH7n0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh000>n03?n001C_P?n0oh3oP>n00
0coP01Tkh3oP000Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0020002
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R1@0003d3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`04Ool00`00Oomoo`0BOol001=oo`80009ooa=l000<001m87d0OB1m07dPO@1m87d0OB1m00001gi0
00<007n0Oh0027n000/006OPHn1Wh6?PIn1Sh6OPHn1Wh6?P008000doh08000<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000aOP00<Kh1OP5n000`00?0?R3@00<0?/0goo0P0057oo000COol01000
Oomoogoo4g`000d007d0OB1m07dPO@1m87d0OB1m07dP001nH003OT0077iPOT1n@7i0001oH7n0Of1o
P7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0000coP00Dkh3oP?n0oh3_P00<oh003
>n0oh3oP0080000G6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh004
00000`?R0n<3hP020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hPT0000W0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00Aoo`03001oogoo019o
o`004goo00@007ooOomooaAl000<001m07dPO@1m87d0OB1m07dPO@1m800027i000<007n0Oh0027n0
00`006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn02000>?n0200000aOP6n0Gh0025n001A_P5n0Gh1OP6n00
0aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh1OP5n02001<0n8G000@0n`4Ool00`00Oomoo`0BOol001=o
o`04001oogooOolDO0003P00OB1m07dPO@1m87d0OB1m07dPO@0007i0OV03OT007GiPOT1n@7i0001o
H7n0Of1oP7mPOh1oH7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P00000SoP00Dkh3oP?n0o
h3_P00<oh005>n0oh3oP?n0kh00200006A_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P00<00083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00H3h`?R0n83hP?S0n8A0003Ool00`00Oomoo`0BOol001=oo`04001o
ogooOolEO0003000OB1m07dPO@1m87d0OB1m07dPO@0000Un@003001oP7n000QoP00=001Wh6?PIn1S
h6OPHn1Wh6?PIn1Sh6OPHn000P003coP0P000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000QOP0P00KP?R17oo00<007ooOol04Woo000COol01000Oomoogoo5G`000l0
07d0OB1m07dPO@1m87d0OB1m07dPO@0007i0OV000gi0021nH7i0OT1n@000Of1oP7mPOh1oH7n0Of1o
P7mPOh0006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP000oh3_P0coP00Dkh3oP?n0oh3_P00<oh003
>n0oh3oP0080000J6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh0@00083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n84Ool00`00Oomoo`0BOol001=oo`04
001oogooOolEO0003@00OB1m07dPO@1m87d0OB1m07dPO@1m800000Yn@003001oP7n000QoP00>001W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn00014oh080008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP
6n000aOP00DKh1OP5n0Gh1_P00<Gh0036n0Gh1OP00@006H3hPAoo`03001oogoo019oo`004goo0P00
0Woo5W`000d007dPO@1m87d0OB1m07dPO@1m87d0OB000002OT001GiPOT1n@7i0OV000gi001P007mP
Oh1oH7n0Of1oP7mPOh1oH7n0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0200000coP>n0oh002?n00
1C_P?n0oh3oP>n000coP00@kh3oP?n0oh080000O5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n000`0000<3hP?S0n800P?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801P?S0n83hP?R0n<3hP=o
o`8001Aoo`004goo00@007ooOomooaIl000=001m07dPO@1m87d0OB1m07dPO@1m87d000002Wi000<0
07n0Oh002Gn000h006OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP0P004CoP0P0000DKh1OP5n0Gh1_P
00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0800643hPAo
o`03001oogoo019oo`004goo00@007ooOomooaMl000=001m07dPO@1m87d0OB1m07dPO@1m87d00000
0gi000EnH7i0OT1n@7iP009n@00M001oP7mPOh1oH7n0Of1oP7mPOh1oH7n0001Wh6?PIn1Sh6OPHn1W
h6?PIn1Sh6OPHn1Wh6?P000kh003?n001C_P?n0oh3oP>n000coP00Hkh3oP?n0oh3_P?n02000081OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0300020n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP040n<3hP?R0n84Ool00`00Oomoo`0BOol001=oo`04001oogooOolGO0003@00OB1m07dPO@1m
87d0OB1m07dPO@1m800000Yn@003001oP7n000YoP00@001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1W
h6?P000C?n0300000aOP6n0Gh0025n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0G
h1OP5n0Kh0035n000a_P5n0Gh005001I0n84Ool00`00Oomoo`0BOol001=oo`04001oogooOolGO000
3`00O@1m87d0OB1m07dPO@1m87d0OB1m07dP001nH003OT008WiPOT1n@7i0OV1n@000Of1oP7mPOh1o
H7n0Of1oP7mPOh1oH7n0001Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?P0P000coP00Dkh3oP?n0o
h3_P00<oh005>n0oh3oP?n0kh003?n009S_P000001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0400030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00<3h`?ROol00goo00<007ooOol04Woo000:Ool30006
Ool01000Oomoogoo5g`000h007dPO@1m87d0OB1m07dPO@1m87d0OB1m00002gi000<007n0Oh002Wn0
0P0000mSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OP00005CoP0P000aOP00DKh1OP5n0Gh1_P00<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh000001C
0n84Ool00`00Oomoo`0BOol000Uoo`05001oogooOol00005Ool01000Oomoogoo67`0010007dPO@1m
87d0OB1m07dPO@1m87d0OB1m0000OT1nH0=n@00TOV1n@7i0OT1nH7i0001oH7n0Of1oP7mPOh1oH7n0
Of1oP7mPOh1oH000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh0000coP00Dkh3oP?n0oh3_P00<o
h005>n0oh3oP?n0kh003?n00:S_P?n0oh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh0@000<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83
hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP040n<3hP?R0n84Ool00`00Oomoo`0BOol000eoo`03001oogoo00=oo`04001o
ogooOolHO0003P00O@1m87d0OB1m07dPO@1m87d0OB1m07dP000<OT000`00Oh1oP00;Oh003`00Hn1W
h6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh002000E?n0200025n001A_P5n0Gh1OP6n000aOP00DKh1OP
5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00HKh1OP5n0Gh1_P5n03001<
0n84Ool00`00Oomoo`0BOol000eoo`03001oogoo00=oo`80009ooaQl000?001m87d0OB1m07dPO@1m
87d0OB1m07dPO@1m8000009n@005OV1n@7i0OT1nH003OT008GiP001oP7mPOh1oH7n0Of1oP7mPOh1o
H7n0Of1oP000In1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn000002?n001C_P?n0oh3oP>n00
0coP00Dkh3oP?n0oh3_P00<oh00_>n0oh3oP?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh0020000
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n800`?S0n9oo`02Ool2000DOol000]oo`8000Ioo`03001oogoo
0>Aoo`03001oogoo019oo`003Goo00<007ooOol00goo00<007ooOol0i7oo00<007ooOol04Woo0009
Ool01@00Oomoogoo00001Goo00@007ooOol000Moo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`05001oogooOol0000DOol000Yoo`<000IoonP001Aoo`00ogoo47oo
003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mo
oa1oo`004Goo0`00ngoo000COol00`00Oomoo`3iOol001=oo`03001oogoo0?Uoo`004Woo00<007oo
0000nWoo000BOol00`00Ool0003jOol0015oo`05001oogooOol0003iOol0015oo`05001oogooOol0
003iOol0011oo`<00004Ool00000003hOol00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00
ogoo47oo003oOol@Ool00?mooa1oo`00\
\>"],
  ImageRangeCache->{{{0, 270.25}, {270.25, 0}} -> {-0.306902, -3.5012, \
0.0167858, 0.0336841}}]
}, Open  ]],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  "-component of the velocity looks like"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[v, {x,  .01, 3}, {y, \(-3\), 3}, PlotPoints \[Rule] 50, 
      Contours \[Rule] 20, ColorFunction \[Rule] Hue, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, Axes \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0160149 0.321585 0.5 0.160256 [
[.01601 -0.0125 -3 -9 ]
[.01601 -0.0125 3 0 ]
[.17681 -0.0125 -9 -9 ]
[.17681 -0.0125 9 0 ]
[.3376 -0.0125 -3 -9 ]
[.3376 -0.0125 3 0 ]
[.49839 -0.0125 -9 -9 ]
[.49839 -0.0125 9 0 ]
[.65918 -0.0125 -3 -9 ]
[.65918 -0.0125 3 0 ]
[.81998 -0.0125 -9 -9 ]
[.81998 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .17949 -12 -4.5 ]
[-0.0125 .17949 0 4.5 ]
[-0.0125 .33974 -12 -4.5 ]
[-0.0125 .33974 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .66026 -6 -4.5 ]
[-0.0125 .66026 0 4.5 ]
[-0.0125 .82051 -6 -4.5 ]
[-0.0125 .82051 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[1.025 0 0 -7.5 ]
[1.025 0 10 7.5 ]
[0 1.025 -5 0 ]
[0 1.025 5 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01601 0 m
.01601 .00625 L
s
[(0)] .01601 -0.0125 0 1 Mshowa
.17681 0 m
.17681 .00625 L
s
[(0.5)] .17681 -0.0125 0 1 Mshowa
.3376 0 m
.3376 .00625 L
s
[(1)] .3376 -0.0125 0 1 Mshowa
.49839 0 m
.49839 .00625 L
s
[(1.5)] .49839 -0.0125 0 1 Mshowa
.65918 0 m
.65918 .00625 L
s
[(2)] .65918 -0.0125 0 1 Mshowa
.81998 0 m
.81998 .00625 L
s
[(2.5)] .81998 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(3)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.04817 0 m
.04817 .00375 L
s
.08033 0 m
.08033 .00375 L
s
.11249 0 m
.11249 .00375 L
s
.14465 0 m
.14465 .00375 L
s
.20897 0 m
.20897 .00375 L
s
.24112 0 m
.24112 .00375 L
s
.27328 0 m
.27328 .00375 L
s
.30544 0 m
.30544 .00375 L
s
.36976 0 m
.36976 .00375 L
s
.40192 0 m
.40192 .00375 L
s
.43408 0 m
.43408 .00375 L
s
.46623 0 m
.46623 .00375 L
s
.53055 0 m
.53055 .00375 L
s
.56271 0 m
.56271 .00375 L
s
.59487 0 m
.59487 .00375 L
s
.62703 0 m
.62703 .00375 L
s
.69134 0 m
.69134 .00375 L
s
.7235 0 m
.7235 .00375 L
s
.75566 0 m
.75566 .00375 L
s
.78782 0 m
.78782 .00375 L
s
.85214 0 m
.85214 .00375 L
s
.88429 0 m
.88429 .00375 L
s
.91645 0 m
.91645 .00375 L
s
.94861 0 m
.94861 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-3)] -0.0125 .01923 1 0 Mshowa
0 .17949 m
.00625 .17949 L
s
[(-2)] -0.0125 .17949 1 0 Mshowa
0 .33974 m
.00625 .33974 L
s
[(-1)] -0.0125 .33974 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .66026 m
.00625 .66026 L
s
[(1)] -0.0125 .66026 1 0 Mshowa
0 .82051 m
.00625 .82051 L
s
[(2)] -0.0125 .82051 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(3)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .05128 m
.00375 .05128 L
s
0 .08333 m
.00375 .08333 L
s
0 .11538 m
.00375 .11538 L
s
0 .14744 m
.00375 .14744 L
s
0 .21154 m
.00375 .21154 L
s
0 .24359 m
.00375 .24359 L
s
0 .27564 m
.00375 .27564 L
s
0 .30769 m
.00375 .30769 L
s
0 .37179 m
.00375 .37179 L
s
0 .40385 m
.00375 .40385 L
s
0 .4359 m
.00375 .4359 L
s
0 .46795 m
.00375 .46795 L
s
0 .53205 m
.00375 .53205 L
s
0 .5641 m
.00375 .5641 L
s
0 .59615 m
.00375 .59615 L
s
0 .62821 m
.00375 .62821 L
s
0 .69231 m
.00375 .69231 L
s
0 .72436 m
.00375 .72436 L
s
0 .75641 m
.00375 .75641 L
s
0 .78846 m
.00375 .78846 L
s
0 .85256 m
.00375 .85256 L
s
0 .88462 m
.00375 .88462 L
s
0 .91667 m
.00375 .91667 L
s
0 .94872 m
.00375 .94872 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01601 .99375 m
.01601 1 L
s
.17681 .99375 m
.17681 1 L
s
.3376 .99375 m
.3376 1 L
s
.49839 .99375 m
.49839 1 L
s
.65918 .99375 m
.65918 1 L
s
.81998 .99375 m
.81998 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.04817 .99625 m
.04817 1 L
s
.08033 .99625 m
.08033 1 L
s
.11249 .99625 m
.11249 1 L
s
.14465 .99625 m
.14465 1 L
s
.20897 .99625 m
.20897 1 L
s
.24112 .99625 m
.24112 1 L
s
.27328 .99625 m
.27328 1 L
s
.30544 .99625 m
.30544 1 L
s
.36976 .99625 m
.36976 1 L
s
.40192 .99625 m
.40192 1 L
s
.43408 .99625 m
.43408 1 L
s
.46623 .99625 m
.46623 1 L
s
.53055 .99625 m
.53055 1 L
s
.56271 .99625 m
.56271 1 L
s
.59487 .99625 m
.59487 1 L
s
.62703 .99625 m
.62703 1 L
s
.69134 .99625 m
.69134 1 L
s
.7235 .99625 m
.7235 1 L
s
.75566 .99625 m
.75566 1 L
s
.78782 .99625 m
.78782 1 L
s
.85214 .99625 m
.85214 1 L
s
.88429 .99625 m
.88429 1 L
s
.91645 .99625 m
.91645 1 L
s
.94861 .99625 m
.94861 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .17949 m
1 .17949 L
s
.99375 .33974 m
1 .33974 L
s
.99375 .5 m
1 .5 L
s
.99375 .66026 m
1 .66026 L
s
.99375 .82051 m
1 .82051 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .05128 m
1 .05128 L
s
.99625 .08333 m
1 .08333 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .14744 m
1 .14744 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .24359 m
1 .24359 L
s
.99625 .27564 m
1 .27564 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .37179 m
1 .37179 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .4359 m
1 .4359 L
s
.99625 .46795 m
1 .46795 L
s
.99625 .53205 m
1 .53205 L
s
.99625 .5641 m
1 .5641 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .62821 m
1 .62821 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .72436 m
1 .72436 L
s
.99625 .75641 m
1 .75641 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .85256 m
1 .85256 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .91667 m
1 .91667 L
s
.99625 .94872 m
1 .94872 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
s
gsave
1.025 0 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
0 1 L
s
gsave
0 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 1 .4 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
0 1 .7 r
.01923 .49985 m
.03885 .49857 L
.05848 .49657 L
.0781 .49427 L
.09772 .49171 L
.1085 .49019 L
.11735 .48895 L
.13697 .486 L
.15659 .48285 L
.17622 .47954 L
.19584 .47607 L
.21546 .47246 L
.22548 .47057 L
.23509 .46873 L
.25471 .46486 L
.27433 .46087 L
.29396 .45675 L
.31358 .4525 L
.32066 .45094 L
.3332 .44815 L
.35283 .44369 L
.37245 .4391 L
.39207 .4344 L
.40469 .43132 L
.4117 .42959 L
.43132 .42468 L
.45094 .41965 L
.47057 .4145 L
.4811 .4117 L
.49019 .40925 L
.50981 .40389 L
.52943 .39842 L
.54906 .39282 L
.55166 .39207 L
.56868 .38712 L
.5883 .3813 L
.60793 .37536 L
.6174 .37245 L
.62755 .3693 L
.64717 .36313 L
.6668 .35682 L
.679 .35283 L
.68642 .35038 L
.70604 .34382 L
.72567 .33712 L
.73693 .3332 L
.74529 .33028 L
.76491 .3233 L
.78454 .31616 L
.79152 .31358 L
.80416 .30887 L
.82378 .30143 L
.84302 .29396 L
.84341 .2938 L
.86303 .28602 L
.88265 .27804 L
.89159 .27433 L
.90228 .26987 L
.9219 .26149 L
.93738 .25471 L
.94152 .25288 L
.96115 .24405 L
.98048 .23509 L
.98077 .23495 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49985 m
.03885 .49857 L
.05848 .49657 L
.0781 .49427 L
.09772 .49171 L
.1085 .49019 L
.11735 .48895 L
.13697 .486 L
.15659 .48285 L
.17622 .47954 L
.19584 .47607 L
.21546 .47246 L
.22548 .47057 L
.23509 .46873 L
.25471 .46486 L
.27433 .46087 L
.29396 .45675 L
.31358 .4525 L
.32066 .45094 L
.3332 .44815 L
.35283 .44369 L
.37245 .4391 L
.39207 .4344 L
.40469 .43132 L
.4117 .42959 L
.43132 .42468 L
.45094 .41965 L
.47057 .4145 L
.4811 .4117 L
.49019 .40925 L
.50981 .40389 L
.52943 .39842 L
.54906 .39282 L
.55166 .39207 L
.56868 .38712 L
.5883 .3813 L
.60793 .37536 L
.6174 .37245 L
.62755 .3693 L
.64717 .36313 L
.6668 .35682 L
.679 .35283 L
.68642 .35038 L
.70604 .34382 L
.72567 .33712 L
.73693 .3332 L
.74529 .33028 L
.76491 .3233 L
.78454 .31616 L
.79152 .31358 L
Mistroke
.80416 .30887 L
.82378 .30143 L
.84302 .29396 L
.84341 .2938 L
.86303 .28602 L
.88265 .27804 L
.89159 .27433 L
.90228 .26987 L
.9219 .26149 L
.93738 .25471 L
.94152 .25288 L
.96115 .24405 L
.98048 .23509 L
.98077 .23495 L
Mfstroke
0 1 1 r
.01923 .49995 m
.03885 .49952 L
.05848 .49886 L
.0781 .4981 L
.09772 .49725 L
.11735 .49633 L
.13697 .49536 L
.15659 .49433 L
.17622 .49324 L
.19584 .49212 L
.21546 .49095 L
.22782 .49019 L
.23509 .48974 L
.25471 .48849 L
.27433 .48721 L
.29396 .4859 L
.31358 .48455 L
.3332 .48317 L
.35283 .48176 L
.37245 .48033 L
.39207 .47886 L
.4117 .47737 L
.43132 .47586 L
.45094 .47432 L
.47057 .47275 L
.49019 .47117 L
.49753 .47057 L
.50981 .46955 L
.52943 .46792 L
.54906 .46627 L
.56868 .46459 L
.5883 .46289 L
.60793 .46117 L
.62755 .45943 L
.64717 .45767 L
.6668 .45589 L
.68642 .4541 L
.70604 .45228 L
.72037 .45094 L
.72567 .45045 L
.74529 .44859 L
.76491 .44672 L
.78454 .44483 L
.80416 .44293 L
.82378 .441 L
.84341 .43906 L
.86303 .4371 L
.88265 .43513 L
.90228 .43314 L
.92004 .43132 L
.9219 .43113 L
.94152 .4291 L
.96115 .42707 L
.98077 .42501 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49995 m
.03885 .49952 L
.05848 .49886 L
.0781 .4981 L
.09772 .49725 L
.11735 .49633 L
.13697 .49536 L
.15659 .49433 L
.17622 .49324 L
.19584 .49212 L
.21546 .49095 L
.22782 .49019 L
.23509 .48974 L
.25471 .48849 L
.27433 .48721 L
.29396 .4859 L
.31358 .48455 L
.3332 .48317 L
.35283 .48176 L
.37245 .48033 L
.39207 .47886 L
.4117 .47737 L
.43132 .47586 L
.45094 .47432 L
.47057 .47275 L
.49019 .47117 L
.49753 .47057 L
.50981 .46955 L
.52943 .46792 L
.54906 .46627 L
.56868 .46459 L
.5883 .46289 L
.60793 .46117 L
.62755 .45943 L
.64717 .45767 L
.6668 .45589 L
.68642 .4541 L
.70604 .45228 L
.72037 .45094 L
.72567 .45045 L
.74529 .44859 L
.76491 .44672 L
.78454 .44483 L
.80416 .44293 L
.82378 .441 L
.84341 .43906 L
.86303 .4371 L
.88265 .43513 L
.90228 .43314 L
.92004 .43132 L
Mistroke
.9219 .43113 L
.94152 .4291 L
.96115 .42707 L
.98077 .42501 L
Mfstroke
0 .7 1 r
.01923 .50005 m
.03885 .50048 L
.05848 .50114 L
.0781 .5019 L
.09772 .50275 L
.11735 .50367 L
.13697 .50464 L
.15659 .50567 L
.17622 .50676 L
.19584 .50788 L
.21546 .50905 L
.22782 .50981 L
.23509 .51026 L
.25471 .51151 L
.27433 .51279 L
.29396 .5141 L
.31358 .51545 L
.3332 .51683 L
.35283 .51824 L
.37245 .51967 L
.39207 .52114 L
.4117 .52263 L
.43132 .52414 L
.45094 .52568 L
.47057 .52725 L
.49019 .52883 L
.49753 .52943 L
.50981 .53045 L
.52943 .53208 L
.54906 .53373 L
.56868 .53541 L
.5883 .53711 L
.60793 .53883 L
.62755 .54057 L
.64717 .54233 L
.6668 .54411 L
.68642 .5459 L
.70604 .54772 L
.72037 .54906 L
.72567 .54955 L
.74529 .55141 L
.76491 .55328 L
.78454 .55517 L
.80416 .55707 L
.82378 .559 L
.84341 .56094 L
.86303 .5629 L
.88265 .56487 L
.90228 .56686 L
.92004 .56868 L
.9219 .56887 L
.94152 .5709 L
.96115 .57293 L
.98077 .57499 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .50005 m
.03885 .50048 L
.05848 .50114 L
.0781 .5019 L
.09772 .50275 L
.11735 .50367 L
.13697 .50464 L
.15659 .50567 L
.17622 .50676 L
.19584 .50788 L
.21546 .50905 L
.22782 .50981 L
.23509 .51026 L
.25471 .51151 L
.27433 .51279 L
.29396 .5141 L
.31358 .51545 L
.3332 .51683 L
.35283 .51824 L
.37245 .51967 L
.39207 .52114 L
.4117 .52263 L
.43132 .52414 L
.45094 .52568 L
.47057 .52725 L
.49019 .52883 L
.49753 .52943 L
.50981 .53045 L
.52943 .53208 L
.54906 .53373 L
.56868 .53541 L
.5883 .53711 L
.60793 .53883 L
.62755 .54057 L
.64717 .54233 L
.6668 .54411 L
.68642 .5459 L
.70604 .54772 L
.72037 .54906 L
.72567 .54955 L
.74529 .55141 L
.76491 .55328 L
.78454 .55517 L
.80416 .55707 L
.82378 .559 L
.84341 .56094 L
.86303 .5629 L
.88265 .56487 L
.90228 .56686 L
.92004 .56868 L
Mistroke
.9219 .56887 L
.94152 .5709 L
.96115 .57293 L
.98077 .57499 L
Mfstroke
0 .4 1 r
.01923 .50015 m
.03885 .50143 L
.05848 .50343 L
.0781 .50573 L
.09772 .50829 L
.1085 .50981 L
.11735 .51105 L
.13697 .514 L
.15659 .51715 L
.17622 .52046 L
.19584 .52393 L
.21546 .52754 L
.22548 .52943 L
.23509 .53127 L
.25471 .53514 L
.27433 .53913 L
.29396 .54325 L
.31358 .5475 L
.32066 .54906 L
.3332 .55185 L
.35283 .55631 L
.37245 .5609 L
.39207 .5656 L
.40469 .56868 L
.4117 .57041 L
.43132 .57532 L
.45094 .58035 L
.47057 .5855 L
.4811 .5883 L
.49019 .59075 L
.50981 .59611 L
.52943 .60158 L
.54906 .60718 L
.55166 .60793 L
.56868 .61288 L
.5883 .6187 L
.60793 .62464 L
.6174 .62755 L
.62755 .6307 L
.64717 .63687 L
.6668 .64318 L
.679 .64717 L
.68642 .64962 L
.70604 .65618 L
.72567 .66288 L
.73693 .6668 L
.74529 .66972 L
.76491 .6767 L
.78454 .68384 L
.79152 .68642 L
.80416 .69113 L
.82378 .69857 L
.84302 .70604 L
.84341 .7062 L
.86303 .71398 L
.88265 .72196 L
.89159 .72567 L
.90228 .73013 L
.9219 .73851 L
.93738 .74529 L
.94152 .74712 L
.96115 .75595 L
.98048 .76491 L
.98077 .76505 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .50015 m
.03885 .50143 L
.05848 .50343 L
.0781 .50573 L
.09772 .50829 L
.1085 .50981 L
.11735 .51105 L
.13697 .514 L
.15659 .51715 L
.17622 .52046 L
.19584 .52393 L
.21546 .52754 L
.22548 .52943 L
.23509 .53127 L
.25471 .53514 L
.27433 .53913 L
.29396 .54325 L
.31358 .5475 L
.32066 .54906 L
.3332 .55185 L
.35283 .55631 L
.37245 .5609 L
.39207 .5656 L
.40469 .56868 L
.4117 .57041 L
.43132 .57532 L
.45094 .58035 L
.47057 .5855 L
.4811 .5883 L
.49019 .59075 L
.50981 .59611 L
.52943 .60158 L
.54906 .60718 L
.55166 .60793 L
.56868 .61288 L
.5883 .6187 L
.60793 .62464 L
.6174 .62755 L
.62755 .6307 L
.64717 .63687 L
.6668 .64318 L
.679 .64717 L
.68642 .64962 L
.70604 .65618 L
.72567 .66288 L
.73693 .6668 L
.74529 .66972 L
.76491 .6767 L
.78454 .68384 L
.79152 .68642 L
Mistroke
.80416 .69113 L
.82378 .69857 L
.84302 .70604 L
.84341 .7062 L
.86303 .71398 L
.88265 .72196 L
.89159 .72567 L
.90228 .73013 L
.9219 .73851 L
.93738 .74529 L
.94152 .74712 L
.96115 .75595 L
.98048 .76491 L
.98077 .76505 L
Mfstroke
0 1 .1 r
.01923 .49974 m
.03885 .4976 L
.05848 .49425 L
.0781 .49038 L
.07892 .49019 L
.09772 .48616 L
.11735 .48142 L
.13697 .47631 L
.15659 .47085 L
.1576 .47057 L
.17622 .46515 L
.19584 .45908 L
.21546 .45269 L
.22065 .45094 L
.23509 .44603 L
.25471 .43905 L
.27433 .43172 L
.27537 .43132 L
.29396 .42412 L
.31358 .41614 L
.32414 .4117 L
.3332 .40784 L
.35283 .39916 L
.36815 .39207 L
.37245 .39006 L
.39207 .38057 L
.40804 .37245 L
.4117 .37057 L
.43132 .36009 L
.44423 .35283 L
.45094 .349 L
.47057 .33722 L
.47693 .3332 L
.49019 .32468 L
.50625 .31358 L
.50981 .31109 L
.52943 .29622 L
.53221 .29396 L
.54906 .27968 L
.55471 .27433 L
.56868 .26039 L
.57353 .25471 L
.5883 .23509 L
.5883 .23509 L
.59838 .21546 L
.60261 .19584 L
.59862 .17622 L
.5883 .16071 L
.57983 .15659 L
.56868 .15079 L
.54906 .14484 L
.52943 .14191 L
.50981 .14091 L
.49019 .14138 L
.47057 .14306 L
.45094 .1458 L
.43132 .14947 L
.4117 .15401 L
.40157 .15659 L
.39207 .15934 L
.37245 .16544 L
.35283 .17233 L
.3424 .17622 L
.3332 .17994 L
.31358 .18832 L
.29723 .19584 L
.29396 .19748 L
.27433 .2074 L
.25934 .21546 L
.25471 .21817 L
.23509 .2298 L
.22643 .23509 L
.21546 .24236 L
.19744 .25471 L
.19584 .25595 L
.17622 .27063 L
.17126 .27433 L
.15659 .28656 L
.14743 .29396 L
.13697 .30392 L
.1258 .31358 L
.11735 .32298 L
.10602 .3332 L
.09772 .34412 L
.08978 .35283 L
.0781 .36797 L
.07375 .37245 L
.06038 .39207 L
.05848 .39545 L
.04311 .4117 L
.03885 .42944 L
.03852 .43132 L
.03571 .45094 L
.03285 .47057 L
.01923 .4805 L
F
0 g
.01923 .49974 m
.03885 .4976 L
.05848 .49425 L
.0781 .49038 L
.07892 .49019 L
.09772 .48616 L
.11735 .48142 L
.13697 .47631 L
.15659 .47085 L
.1576 .47057 L
.17622 .46515 L
.19584 .45908 L
.21546 .45269 L
.22065 .45094 L
.23509 .44603 L
.25471 .43905 L
.27433 .43172 L
.27537 .43132 L
.29396 .42412 L
.31358 .41614 L
.32414 .4117 L
.3332 .40784 L
.35283 .39916 L
.36815 .39207 L
.37245 .39006 L
.39207 .38057 L
.40804 .37245 L
.4117 .37057 L
.43132 .36009 L
.44423 .35283 L
.45094 .349 L
.47057 .33722 L
.47693 .3332 L
.49019 .32468 L
.50625 .31358 L
.50981 .31109 L
.52943 .29622 L
.53221 .29396 L
.54906 .27968 L
.55471 .27433 L
.56868 .26039 L
.57353 .25471 L
.5883 .23509 L
.5883 .23509 L
.59838 .21546 L
.60261 .19584 L
.59862 .17622 L
.5883 .16071 L
.57983 .15659 L
.56868 .15079 L
Mistroke
.54906 .14484 L
.52943 .14191 L
.50981 .14091 L
.49019 .14138 L
.47057 .14306 L
.45094 .1458 L
.43132 .14947 L
.4117 .15401 L
.40157 .15659 L
.39207 .15934 L
.37245 .16544 L
.35283 .17233 L
.3424 .17622 L
.3332 .17994 L
.31358 .18832 L
.29723 .19584 L
.29396 .19748 L
.27433 .2074 L
.25934 .21546 L
.25471 .21817 L
.23509 .2298 L
.22643 .23509 L
.21546 .24236 L
.19744 .25471 L
.19584 .25595 L
.17622 .27063 L
.17126 .27433 L
.15659 .28656 L
.14743 .29396 L
.13697 .30392 L
.1258 .31358 L
.11735 .32298 L
.10602 .3332 L
.09772 .34412 L
.08978 .35283 L
.0781 .36797 L
.07375 .37245 L
.06038 .39207 L
.05848 .39545 L
.04311 .4117 L
.03885 .42944 L
.03852 .43132 L
.03571 .45094 L
.03285 .47057 L
.01923 .4805 L
Mfstroke
0 .1 1 r
.01923 .5195 m
.03285 .52943 L
.03571 .54906 L
.03852 .56868 L
.03885 .57056 L
.04311 .5883 L
.05848 .60455 L
.06038 .60793 L
.07375 .62755 L
.0781 .63203 L
.08978 .64717 L
.09772 .65588 L
.10602 .6668 L
.11735 .67702 L
.1258 .68642 L
.13697 .69608 L
.14743 .70604 L
.15659 .71344 L
.17126 .72567 L
.17622 .72937 L
.19584 .74405 L
.19744 .74529 L
.21546 .75764 L
.22643 .76491 L
.23509 .7702 L
.25471 .78183 L
.25934 .78454 L
.27433 .7926 L
.29396 .80252 L
.29723 .80416 L
.31358 .81168 L
.3332 .82006 L
.3424 .82378 L
.35283 .82767 L
.37245 .83456 L
.39207 .84066 L
.40157 .84341 L
.4117 .84599 L
.43132 .85053 L
.45094 .8542 L
.47057 .85694 L
.49019 .85862 L
.50981 .85909 L
.52943 .85809 L
.54906 .85516 L
.56868 .84921 L
.57983 .84341 L
.5883 .83929 L
.59862 .82378 L
.60261 .80416 L
.59838 .78454 L
.5883 .76491 L
.5883 .76491 L
.57353 .74529 L
.56868 .73961 L
.55471 .72567 L
.54906 .72032 L
.53221 .70604 L
.52943 .70378 L
.50981 .68891 L
.50625 .68642 L
.49019 .67532 L
.47693 .6668 L
.47057 .66278 L
.45094 .651 L
.44423 .64717 L
.43132 .63991 L
.4117 .62943 L
.40804 .62755 L
.39207 .61943 L
.37245 .60994 L
.36815 .60793 L
.35283 .60084 L
.3332 .59216 L
.32414 .5883 L
.31358 .58386 L
.29396 .57588 L
.27537 .56868 L
.27433 .56828 L
.25471 .56095 L
.23509 .55397 L
.22065 .54906 L
.21546 .54731 L
.19584 .54092 L
.17622 .53485 L
.1576 .52943 L
.15659 .52915 L
.13697 .52369 L
.11735 .51858 L
.09772 .51384 L
.07892 .50981 L
.0781 .50962 L
.05848 .50575 L
.03885 .5024 L
.01923 .50026 L
F
0 g
.01923 .5195 m
.03285 .52943 L
.03571 .54906 L
.03852 .56868 L
.03885 .57056 L
.04311 .5883 L
.05848 .60455 L
.06038 .60793 L
.07375 .62755 L
.0781 .63203 L
.08978 .64717 L
.09772 .65588 L
.10602 .6668 L
.11735 .67702 L
.1258 .68642 L
.13697 .69608 L
.14743 .70604 L
.15659 .71344 L
.17126 .72567 L
.17622 .72937 L
.19584 .74405 L
.19744 .74529 L
.21546 .75764 L
.22643 .76491 L
.23509 .7702 L
.25471 .78183 L
.25934 .78454 L
.27433 .7926 L
.29396 .80252 L
.29723 .80416 L
.31358 .81168 L
.3332 .82006 L
.3424 .82378 L
.35283 .82767 L
.37245 .83456 L
.39207 .84066 L
.40157 .84341 L
.4117 .84599 L
.43132 .85053 L
.45094 .8542 L
.47057 .85694 L
.49019 .85862 L
.50981 .85909 L
.52943 .85809 L
.54906 .85516 L
.56868 .84921 L
.57983 .84341 L
.5883 .83929 L
.59862 .82378 L
.60261 .80416 L
Mistroke
.59838 .78454 L
.5883 .76491 L
.5883 .76491 L
.57353 .74529 L
.56868 .73961 L
.55471 .72567 L
.54906 .72032 L
.53221 .70604 L
.52943 .70378 L
.50981 .68891 L
.50625 .68642 L
.49019 .67532 L
.47693 .6668 L
.47057 .66278 L
.45094 .651 L
.44423 .64717 L
.43132 .63991 L
.4117 .62943 L
.40804 .62755 L
.39207 .61943 L
.37245 .60994 L
.36815 .60793 L
.35283 .60084 L
.3332 .59216 L
.32414 .5883 L
.31358 .58386 L
.29396 .57588 L
.27537 .56868 L
.27433 .56828 L
.25471 .56095 L
.23509 .55397 L
.22065 .54906 L
.21546 .54731 L
.19584 .54092 L
.17622 .53485 L
.1576 .52943 L
.15659 .52915 L
.13697 .52369 L
.11735 .51858 L
.09772 .51384 L
.07892 .50981 L
.0781 .50962 L
.05848 .50575 L
.03885 .5024 L
.01923 .50026 L
Mfstroke
0 1 .7 r
.01923 .48041 m
.03263 .47057 L
.03555 .45094 L
.03831 .43132 L
.03885 .42828 L
.04276 .4117 L
.05848 .39298 L
.05896 .39207 L
.07073 .37245 L
.0781 .36359 L
.08562 .35283 L
.09772 .33778 L
.10018 .3332 L
.11735 .31447 L
.11793 .31358 L
.13602 .29396 L
.13697 .29302 L
.15525 .27433 L
.15659 .27307 L
.17585 .25471 L
.17622 .25439 L
.19584 .23677 L
.19769 .23509 L
.21546 .22008 L
.22095 .21546 L
.23509 .20422 L
.24575 .19584 L
.25471 .1891 L
.27214 .17622 L
.27433 .17465 L
.29396 .16081 L
.30005 .15659 L
.31358 .14754 L
.32978 .13697 L
.3332 .13479 L
.35283 .12253 L
.36132 .11735 L
.37245 .11073 L
.39207 .09937 L
.39496 .09772 L
.4117 .08842 L
.43086 .0781 L
.43132 .07786 L
.45094 .06767 L
.46927 .05848 L
.47057 .05784 L
.49019 .04835 L
.50981 .03921 L
.51058 .03885 L
.52943 .03039 L
.54906 .02187 L
.55526 .01923 L
.01923 .01923 L
F
0 g
.01923 .48041 m
.03263 .47057 L
.03555 .45094 L
.03831 .43132 L
.03885 .42828 L
.04276 .4117 L
.05848 .39298 L
.05896 .39207 L
.07073 .37245 L
.0781 .36359 L
.08562 .35283 L
.09772 .33778 L
.10018 .3332 L
.11735 .31447 L
.11793 .31358 L
.13602 .29396 L
.13697 .29302 L
.15525 .27433 L
.15659 .27307 L
.17585 .25471 L
.17622 .25439 L
.19584 .23677 L
.19769 .23509 L
.21546 .22008 L
.22095 .21546 L
.23509 .20422 L
.24575 .19584 L
.25471 .1891 L
.27214 .17622 L
.27433 .17465 L
.29396 .16081 L
.30005 .15659 L
.31358 .14754 L
.32978 .13697 L
.3332 .13479 L
.35283 .12253 L
.36132 .11735 L
.37245 .11073 L
.39207 .09937 L
.39496 .09772 L
.4117 .08842 L
.43086 .0781 L
.43132 .07786 L
.45094 .06767 L
.46927 .05848 L
.47057 .05784 L
.49019 .04835 L
.50981 .03921 L
.51058 .03885 L
.52943 .03039 L
Mistroke
.54906 .02187 L
.55526 .01923 L
Mfstroke
0 .7 1 r
.01923 .51959 m
.03263 .52943 L
.03555 .54906 L
.03831 .56868 L
.03885 .57172 L
.04276 .5883 L
.05848 .60702 L
.05896 .60793 L
.07073 .62755 L
.0781 .63641 L
.08562 .64717 L
.09772 .66222 L
.10018 .6668 L
.11735 .68553 L
.11793 .68642 L
.13602 .70604 L
.13697 .70698 L
.15525 .72567 L
.15659 .72693 L
.17585 .74529 L
.17622 .74561 L
.19584 .76323 L
.19769 .76491 L
.21546 .77992 L
.22095 .78454 L
.23509 .79578 L
.24575 .80416 L
.25471 .8109 L
.27214 .82378 L
.27433 .82535 L
.29396 .83919 L
.30005 .84341 L
.31358 .85246 L
.32978 .86303 L
.3332 .86521 L
.35283 .87747 L
.36132 .88265 L
.37245 .88927 L
.39207 .90063 L
.39496 .90228 L
.4117 .91158 L
.43086 .9219 L
.43132 .92214 L
.45094 .93233 L
.46927 .94152 L
.47057 .94216 L
.49019 .95165 L
.50981 .96079 L
.51058 .96115 L
.52943 .96961 L
.54906 .97813 L
.55526 .98077 L
.01923 .98077 L
F
0 g
.01923 .51959 m
.03263 .52943 L
.03555 .54906 L
.03831 .56868 L
.03885 .57172 L
.04276 .5883 L
.05848 .60702 L
.05896 .60793 L
.07073 .62755 L
.0781 .63641 L
.08562 .64717 L
.09772 .66222 L
.10018 .6668 L
.11735 .68553 L
.11793 .68642 L
.13602 .70604 L
.13697 .70698 L
.15525 .72567 L
.15659 .72693 L
.17585 .74529 L
.17622 .74561 L
.19584 .76323 L
.19769 .76491 L
.21546 .77992 L
.22095 .78454 L
.23509 .79578 L
.24575 .80416 L
.25471 .8109 L
.27214 .82378 L
.27433 .82535 L
.29396 .83919 L
.30005 .84341 L
.31358 .85246 L
.32978 .86303 L
.3332 .86521 L
.35283 .87747 L
.36132 .88265 L
.37245 .88927 L
.39207 .90063 L
.39496 .90228 L
.4117 .91158 L
.43086 .9219 L
.43132 .92214 L
.45094 .93233 L
.46927 .94152 L
.47057 .94216 L
.49019 .95165 L
.50981 .96079 L
.51058 .96115 L
.52943 .96961 L
Mistroke
.54906 .97813 L
.55526 .98077 L
Mfstroke
0 1 1 r
.01923 .48031 m
.03241 .47057 L
.03539 .45094 L
.03811 .43132 L
.03885 .42712 L
.04243 .4117 L
.05016 .39207 L
.05848 .39045 L
.06839 .37245 L
.0781 .35931 L
.08229 .35283 L
.09637 .3332 L
.09772 .33162 L
.11088 .31358 L
.11735 .30617 L
.12675 .29396 L
.13697 .28248 L
.14363 .27433 L
.15659 .26016 L
.16133 .25471 L
.17622 .23896 L
.17978 .23509 L
.19584 .21872 L
.19899 .21546 L
.21546 .19929 L
.21896 .19584 L
.23509 .18057 L
.2397 .17622 L
.25471 .16249 L
.2612 .15659 L
.27433 .14497 L
.28346 .13697 L
.29396 .12797 L
.30648 .11735 L
.31358 .11144 L
.33024 .09772 L
.3332 .09533 L
.35283 .07961 L
.35473 .0781 L
.37245 .06426 L
.37995 .05848 L
.39207 .04925 L
.40591 .03885 L
.4117 .03456 L
.43132 .02017 L
.4326 .01923 L
.01923 .01923 L
F
0 g
.01923 .48031 m
.03241 .47057 L
.03539 .45094 L
.03811 .43132 L
.03885 .42712 L
.04243 .4117 L
.05016 .39207 L
.05848 .39045 L
.06839 .37245 L
.0781 .35931 L
.08229 .35283 L
.09637 .3332 L
.09772 .33162 L
.11088 .31358 L
.11735 .30617 L
.12675 .29396 L
.13697 .28248 L
.14363 .27433 L
.15659 .26016 L
.16133 .25471 L
.17622 .23896 L
.17978 .23509 L
.19584 .21872 L
.19899 .21546 L
.21546 .19929 L
.21896 .19584 L
.23509 .18057 L
.2397 .17622 L
.25471 .16249 L
.2612 .15659 L
.27433 .14497 L
.28346 .13697 L
.29396 .12797 L
.30648 .11735 L
.31358 .11144 L
.33024 .09772 L
.3332 .09533 L
.35283 .07961 L
.35473 .0781 L
.37245 .06426 L
.37995 .05848 L
.39207 .04925 L
.40591 .03885 L
.4117 .03456 L
.43132 .02017 L
.4326 .01923 L
s
0 1 1 r
.01923 .51969 m
.03241 .52943 L
.03539 .54906 L
.03811 .56868 L
.03885 .57288 L
.04243 .5883 L
.05016 .60793 L
.05848 .60955 L
.06839 .62755 L
.0781 .64069 L
.08229 .64717 L
.09637 .6668 L
.09772 .66838 L
.11088 .68642 L
.11735 .69383 L
.12675 .70604 L
.13697 .71752 L
.14363 .72567 L
.15659 .73984 L
.16133 .74529 L
.17622 .76104 L
.17978 .76491 L
.19584 .78128 L
.19899 .78454 L
.21546 .80071 L
.21896 .80416 L
.23509 .81943 L
.2397 .82378 L
.25471 .83751 L
.2612 .84341 L
.27433 .85503 L
.28346 .86303 L
.29396 .87203 L
.30648 .88265 L
.31358 .88856 L
.33024 .90228 L
.3332 .90467 L
.35283 .92039 L
.35473 .9219 L
.37245 .93574 L
.37995 .94152 L
.39207 .95075 L
.40591 .96115 L
.4117 .96544 L
.43132 .97983 L
.4326 .98077 L
.01923 .98077 L
F
0 g
.01923 .51969 m
.03241 .52943 L
.03539 .54906 L
.03811 .56868 L
.03885 .57288 L
.04243 .5883 L
.05016 .60793 L
.05848 .60955 L
.06839 .62755 L
.0781 .64069 L
.08229 .64717 L
.09637 .6668 L
.09772 .66838 L
.11088 .68642 L
.11735 .69383 L
.12675 .70604 L
.13697 .71752 L
.14363 .72567 L
.15659 .73984 L
.16133 .74529 L
.17622 .76104 L
.17978 .76491 L
.19584 .78128 L
.19899 .78454 L
.21546 .80071 L
.21896 .80416 L
.23509 .81943 L
.2397 .82378 L
.25471 .83751 L
.2612 .84341 L
.27433 .85503 L
.28346 .86303 L
.29396 .87203 L
.30648 .88265 L
.31358 .88856 L
.33024 .90228 L
.3332 .90467 L
.35283 .92039 L
.35473 .9219 L
.37245 .93574 L
.37995 .94152 L
.39207 .95075 L
.40591 .96115 L
.4117 .96544 L
.43132 .97983 L
.4326 .98077 L
s
0 .7 1 r
.01923 .48022 m
.0322 .47057 L
.03523 .45094 L
.03792 .43132 L
.03885 .42599 L
.04211 .4117 L
.04913 .39207 L
.05848 .38788 L
.06645 .37245 L
.0781 .35512 L
.07948 .35283 L
.09162 .3332 L
.09772 .32551 L
.1052 .31358 L
.11735 .29806 L
.12003 .29396 L
.13523 .27433 L
.13697 .2722 L
.15064 .25471 L
.15659 .24759 L
.16672 .23509 L
.17622 .224 L
.18338 .21546 L
.19584 .20126 L
.20054 .19584 L
.21546 .17924 L
.21817 .17622 L
.23509 .15785 L
.23625 .15659 L
.25471 .13702 L
.25475 .13697 L
.27367 .11735 L
.27433 .11667 L
.29299 .09772 L
.29396 .09676 L
.31271 .0781 L
.31358 .07724 L
.3328 .05848 L
.3332 .05809 L
.35283 .03927 L
.35326 .03885 L
.37245 .02075 L
.37406 .01923 L
.01923 .01923 L
F
0 g
.01923 .48022 m
.0322 .47057 L
.03523 .45094 L
.03792 .43132 L
.03885 .42599 L
.04211 .4117 L
.04913 .39207 L
.05848 .38788 L
.06645 .37245 L
.0781 .35512 L
.07948 .35283 L
.09162 .3332 L
.09772 .32551 L
.1052 .31358 L
.11735 .29806 L
.12003 .29396 L
.13523 .27433 L
.13697 .2722 L
.15064 .25471 L
.15659 .24759 L
.16672 .23509 L
.17622 .224 L
.18338 .21546 L
.19584 .20126 L
.20054 .19584 L
.21546 .17924 L
.21817 .17622 L
.23509 .15785 L
.23625 .15659 L
.25471 .13702 L
.25475 .13697 L
.27367 .11735 L
.27433 .11667 L
.29299 .09772 L
.29396 .09676 L
.31271 .0781 L
.31358 .07724 L
.3328 .05848 L
.3332 .05809 L
.35283 .03927 L
.35326 .03885 L
.37245 .02075 L
.37406 .01923 L
s
0 1 .7 r
.01923 .51978 m
.0322 .52943 L
.03523 .54906 L
.03792 .56868 L
.03885 .57401 L
.04211 .5883 L
.04913 .60793 L
.05848 .61212 L
.06645 .62755 L
.0781 .64488 L
.07948 .64717 L
.09162 .6668 L
.09772 .67449 L
.1052 .68642 L
.11735 .70194 L
.12003 .70604 L
.13523 .72567 L
.13697 .7278 L
.15064 .74529 L
.15659 .75241 L
.16672 .76491 L
.17622 .776 L
.18338 .78454 L
.19584 .79874 L
.20054 .80416 L
.21546 .82076 L
.21817 .82378 L
.23509 .84215 L
.23625 .84341 L
.25471 .86298 L
.25475 .86303 L
.27367 .88265 L
.27433 .88333 L
.29299 .90228 L
.29396 .90324 L
.31271 .9219 L
.31358 .92276 L
.3328 .94152 L
.3332 .94191 L
.35283 .96073 L
.35326 .96115 L
.37245 .97925 L
.37406 .98077 L
.01923 .98077 L
F
0 g
.01923 .51978 m
.0322 .52943 L
.03523 .54906 L
.03792 .56868 L
.03885 .57401 L
.04211 .5883 L
.04913 .60793 L
.05848 .61212 L
.06645 .62755 L
.0781 .64488 L
.07948 .64717 L
.09162 .6668 L
.09772 .67449 L
.1052 .68642 L
.11735 .70194 L
.12003 .70604 L
.13523 .72567 L
.13697 .7278 L
.15064 .74529 L
.15659 .75241 L
.16672 .76491 L
.17622 .776 L
.18338 .78454 L
.19584 .79874 L
.20054 .80416 L
.21546 .82076 L
.21817 .82378 L
.23509 .84215 L
.23625 .84341 L
.25471 .86298 L
.25475 .86303 L
.27367 .88265 L
.27433 .88333 L
.29299 .90228 L
.29396 .90324 L
.31271 .9219 L
.31358 .92276 L
.3328 .94152 L
.3332 .94191 L
.35283 .96073 L
.35326 .96115 L
.37245 .97925 L
.37406 .98077 L
s
.2 0 1 r
.01923 .51941 m
.03308 .52943 L
.03588 .54906 L
.03873 .56868 L
.03885 .56937 L
.04349 .5883 L
.05848 .602 L
.06199 .60793 L
.0781 .62751 L
.07813 .62755 L
.09546 .64717 L
.09772 .64926 L
.11573 .6668 L
.11735 .66803 L
.13697 .68448 L
.1386 .68642 L
.15659 .69896 L
.1664 .70604 L
.17622 .71164 L
.19584 .72276 L
.2006 .72567 L
.21546 .73237 L
.23509 .74051 L
.24806 .74529 L
.25471 .74709 L
.27433 .75219 L
.29396 .7555 L
.31358 .75668 L
.3332 .75498 L
.35283 .74785 L
.3564 .74529 L
.36943 .72567 L
.3684 .70604 L
.35992 .68642 L
.35283 .67359 L
.34603 .6668 L
.3332 .6521 L
.32763 .64717 L
.31358 .63423 L
.30512 .62755 L
.29396 .61874 L
.27863 .60793 L
.27433 .60495 L
.25471 .59225 L
.24804 .5883 L
.23509 .58065 L
.21546 .56996 L
.21296 .56868 L
.19584 .55992 L
.17622 .55067 L
.17257 .54906 L
.15659 .54198 L
.13697 .53392 L
.12497 .52943 L
.11735 .52655 L
.09772 .51962 L
.0781 .51338 L
.06394 .50981 L
.05848 .50811 L
.03885 .50338 L
.01923 .50036 L
F
0 g
.01923 .51941 m
.03308 .52943 L
.03588 .54906 L
.03873 .56868 L
.03885 .56937 L
.04349 .5883 L
.05848 .602 L
.06199 .60793 L
.0781 .62751 L
.07813 .62755 L
.09546 .64717 L
.09772 .64926 L
.11573 .6668 L
.11735 .66803 L
.13697 .68448 L
.1386 .68642 L
.15659 .69896 L
.1664 .70604 L
.17622 .71164 L
.19584 .72276 L
.2006 .72567 L
.21546 .73237 L
.23509 .74051 L
.24806 .74529 L
.25471 .74709 L
.27433 .75219 L
.29396 .7555 L
.31358 .75668 L
.3332 .75498 L
.35283 .74785 L
.3564 .74529 L
.36943 .72567 L
.3684 .70604 L
.35992 .68642 L
.35283 .67359 L
.34603 .6668 L
.3332 .6521 L
.32763 .64717 L
.31358 .63423 L
.30512 .62755 L
.29396 .61874 L
.27863 .60793 L
.27433 .60495 L
.25471 .59225 L
.24804 .5883 L
.23509 .58065 L
.21546 .56996 L
.21296 .56868 L
.19584 .55992 L
.17622 .55067 L
Mistroke
.17257 .54906 L
.15659 .54198 L
.13697 .53392 L
.12497 .52943 L
.11735 .52655 L
.09772 .51962 L
.0781 .51338 L
.06394 .50981 L
.05848 .50811 L
.03885 .50338 L
.01923 .50036 L
Mfstroke
.2 1 0 r
.01923 .49964 m
.03885 .49662 L
.05848 .49189 L
.06394 .49019 L
.0781 .48662 L
.09772 .48038 L
.11735 .47345 L
.12497 .47057 L
.13697 .46608 L
.15659 .45802 L
.17257 .45094 L
.17622 .44933 L
.19584 .44008 L
.21296 .43132 L
.21546 .43004 L
.23509 .41935 L
.24804 .4117 L
.25471 .40775 L
.27433 .39505 L
.27863 .39207 L
.29396 .38126 L
.30512 .37245 L
.31358 .36577 L
.32763 .35283 L
.3332 .3479 L
.34603 .3332 L
.35283 .32641 L
.35992 .31358 L
.3684 .29396 L
.36943 .27433 L
.3564 .25471 L
.35283 .25215 L
.3332 .24502 L
.31358 .24332 L
.29396 .2445 L
.27433 .24781 L
.25471 .25291 L
.24806 .25471 L
.23509 .25949 L
.21546 .26763 L
.2006 .27433 L
.19584 .27724 L
.17622 .28836 L
.1664 .29396 L
.15659 .30104 L
.1386 .31358 L
.13697 .31552 L
.11735 .33197 L
.11573 .3332 L
.09772 .35074 L
.09546 .35283 L
.07813 .37245 L
.0781 .37249 L
.06199 .39207 L
.05848 .398 L
.04349 .4117 L
.03885 .43063 L
.03873 .43132 L
.03588 .45094 L
.03308 .47057 L
.01923 .48059 L
F
0 g
.01923 .49964 m
.03885 .49662 L
.05848 .49189 L
.06394 .49019 L
.0781 .48662 L
.09772 .48038 L
.11735 .47345 L
.12497 .47057 L
.13697 .46608 L
.15659 .45802 L
.17257 .45094 L
.17622 .44933 L
.19584 .44008 L
.21296 .43132 L
.21546 .43004 L
.23509 .41935 L
.24804 .4117 L
.25471 .40775 L
.27433 .39505 L
.27863 .39207 L
.29396 .38126 L
.30512 .37245 L
.31358 .36577 L
.32763 .35283 L
.3332 .3479 L
.34603 .3332 L
.35283 .32641 L
.35992 .31358 L
.3684 .29396 L
.36943 .27433 L
.3564 .25471 L
.35283 .25215 L
.3332 .24502 L
.31358 .24332 L
.29396 .2445 L
.27433 .24781 L
.25471 .25291 L
.24806 .25471 L
.23509 .25949 L
.21546 .26763 L
.2006 .27433 L
.19584 .27724 L
.17622 .28836 L
.1664 .29396 L
.15659 .30104 L
.1386 .31358 L
.13697 .31552 L
.11735 .33197 L
.11573 .3332 L
.09772 .35074 L
Mistroke
.09546 .35283 L
.07813 .37245 L
.0781 .37249 L
.06199 .39207 L
.05848 .398 L
.04349 .4117 L
.03885 .43063 L
.03873 .43132 L
.03588 .45094 L
.03308 .47057 L
.01923 .48059 L
Mfstroke
0 .4 1 r
.01923 .48013 m
.03199 .47057 L
.03508 .45094 L
.03773 .43132 L
.03885 .42486 L
.04181 .4117 L
.0483 .39207 L
.05848 .38534 L
.06478 .37245 L
.07678 .35283 L
.0781 .35095 L
.08768 .3332 L
.09772 .31948 L
.1009 .31358 L
.11448 .29396 L
.11735 .29003 L
.12789 .27433 L
.13697 .26204 L
.14203 .25471 L
.15659 .23519 L
.15667 .23509 L
.17137 .21546 L
.17622 .20924 L
.18649 .19584 L
.19584 .18404 L
.20198 .17622 L
.21546 .15948 L
.21778 .15659 L
.23384 .13697 L
.23509 .13547 L
.25013 .11735 L
.25471 .11192 L
.26668 .09772 L
.27433 .08878 L
.28348 .0781 L
.29396 .06601 L
.3005 .05848 L
.31358 .04357 L
.31772 .03885 L
.3332 .02142 L
.33515 .01923 L
.01923 .01923 L
F
0 g
.01923 .48013 m
.03199 .47057 L
.03508 .45094 L
.03773 .43132 L
.03885 .42486 L
.04181 .4117 L
.0483 .39207 L
.05848 .38534 L
.06478 .37245 L
.07678 .35283 L
.0781 .35095 L
.08768 .3332 L
.09772 .31948 L
.1009 .31358 L
.11448 .29396 L
.11735 .29003 L
.12789 .27433 L
.13697 .26204 L
.14203 .25471 L
.15659 .23519 L
.15667 .23509 L
.17137 .21546 L
.17622 .20924 L
.18649 .19584 L
.19584 .18404 L
.20198 .17622 L
.21546 .15948 L
.21778 .15659 L
.23384 .13697 L
.23509 .13547 L
.25013 .11735 L
.25471 .11192 L
.26668 .09772 L
.27433 .08878 L
.28348 .0781 L
.29396 .06601 L
.3005 .05848 L
.31358 .04357 L
.31772 .03885 L
.3332 .02142 L
.33515 .01923 L
s
0 1 .4 r
.01923 .51987 m
.03199 .52943 L
.03508 .54906 L
.03773 .56868 L
.03885 .57514 L
.04181 .5883 L
.0483 .60793 L
.05848 .61466 L
.06478 .62755 L
.07678 .64717 L
.0781 .64905 L
.08768 .6668 L
.09772 .68052 L
.1009 .68642 L
.11448 .70604 L
.11735 .70997 L
.12789 .72567 L
.13697 .73796 L
.14203 .74529 L
.15659 .76481 L
.15667 .76491 L
.17137 .78454 L
.17622 .79076 L
.18649 .80416 L
.19584 .81596 L
.20198 .82378 L
.21546 .84052 L
.21778 .84341 L
.23384 .86303 L
.23509 .86453 L
.25013 .88265 L
.25471 .88808 L
.26668 .90228 L
.27433 .91122 L
.28348 .9219 L
.29396 .93399 L
.3005 .94152 L
.31358 .95643 L
.31772 .96115 L
.3332 .97858 L
.33515 .98077 L
.01923 .98077 L
F
0 g
.01923 .51987 m
.03199 .52943 L
.03508 .54906 L
.03773 .56868 L
.03885 .57514 L
.04181 .5883 L
.0483 .60793 L
.05848 .61466 L
.06478 .62755 L
.07678 .64717 L
.0781 .64905 L
.08768 .6668 L
.09772 .68052 L
.1009 .68642 L
.11448 .70604 L
.11735 .70997 L
.12789 .72567 L
.13697 .73796 L
.14203 .74529 L
.15659 .76481 L
.15667 .76491 L
.17137 .78454 L
.17622 .79076 L
.18649 .80416 L
.19584 .81596 L
.20198 .82378 L
.21546 .84052 L
.21778 .84341 L
.23384 .86303 L
.23509 .86453 L
.25013 .88265 L
.25471 .88808 L
.26668 .90228 L
.27433 .91122 L
.28348 .9219 L
.29396 .93399 L
.3005 .94152 L
.31358 .95643 L
.31772 .96115 L
.3332 .97858 L
.33515 .98077 L
s
0 .1 1 r
.01923 .48003 m
.03179 .47057 L
.03493 .45094 L
.03754 .43132 L
.03885 .42375 L
.04151 .4117 L
.0476 .39207 L
.05848 .38283 L
.06331 .37245 L
.07421 .35283 L
.0781 .34677 L
.08447 .3332 L
.09766 .31358 L
.09772 .31349 L
.10932 .29396 L
.11735 .28203 L
.12198 .27433 L
.13505 .25471 L
.13697 .25191 L
.14807 .23509 L
.15659 .2228 L
.16152 .21546 L
.17525 .19584 L
.17622 .19448 L
.18906 .17622 L
.19584 .16681 L
.20313 .15659 L
.21546 .13967 L
.21741 .13697 L
.23183 .11735 L
.23509 .11297 L
.2464 .09772 L
.25471 .08665 L
.26112 .0781 L
.27433 .06066 L
.27598 .05848 L
.29095 .03885 L
.29396 .03494 L
.30602 .01923 L
.01923 .01923 L
F
0 g
.01923 .48003 m
.03179 .47057 L
.03493 .45094 L
.03754 .43132 L
.03885 .42375 L
.04151 .4117 L
.0476 .39207 L
.05848 .38283 L
.06331 .37245 L
.07421 .35283 L
.0781 .34677 L
.08447 .3332 L
.09766 .31358 L
.09772 .31349 L
.10932 .29396 L
.11735 .28203 L
.12198 .27433 L
.13505 .25471 L
.13697 .25191 L
.14807 .23509 L
.15659 .2228 L
.16152 .21546 L
.17525 .19584 L
.17622 .19448 L
.18906 .17622 L
.19584 .16681 L
.20313 .15659 L
.21546 .13967 L
.21741 .13697 L
.23183 .11735 L
.23509 .11297 L
.2464 .09772 L
.25471 .08665 L
.26112 .0781 L
.27433 .06066 L
.27598 .05848 L
.29095 .03885 L
.29396 .03494 L
.30602 .01923 L
s
0 1 .1 r
.01923 .51997 m
.03179 .52943 L
.03493 .54906 L
.03754 .56868 L
.03885 .57625 L
.04151 .5883 L
.0476 .60793 L
.05848 .61717 L
.06331 .62755 L
.07421 .64717 L
.0781 .65323 L
.08447 .6668 L
.09766 .68642 L
.09772 .68651 L
.10932 .70604 L
.11735 .71797 L
.12198 .72567 L
.13505 .74529 L
.13697 .74809 L
.14807 .76491 L
.15659 .7772 L
.16152 .78454 L
.17525 .80416 L
.17622 .80552 L
.18906 .82378 L
.19584 .83319 L
.20313 .84341 L
.21546 .86033 L
.21741 .86303 L
.23183 .88265 L
.23509 .88703 L
.2464 .90228 L
.25471 .91335 L
.26112 .9219 L
.27433 .93934 L
.27598 .94152 L
.29095 .96115 L
.29396 .96506 L
.30602 .98077 L
.01923 .98077 L
F
0 g
.01923 .51997 m
.03179 .52943 L
.03493 .54906 L
.03754 .56868 L
.03885 .57625 L
.04151 .5883 L
.0476 .60793 L
.05848 .61717 L
.06331 .62755 L
.07421 .64717 L
.0781 .65323 L
.08447 .6668 L
.09766 .68642 L
.09772 .68651 L
.10932 .70604 L
.11735 .71797 L
.12198 .72567 L
.13505 .74529 L
.13697 .74809 L
.14807 .76491 L
.15659 .7772 L
.16152 .78454 L
.17525 .80416 L
.17622 .80552 L
.18906 .82378 L
.19584 .83319 L
.20313 .84341 L
.21546 .86033 L
.21741 .86303 L
.23183 .88265 L
.23509 .88703 L
.2464 .90228 L
.25471 .91335 L
.26112 .9219 L
.27433 .93934 L
.27598 .94152 L
.29095 .96115 L
.29396 .96506 L
.30602 .98077 L
s
.2 0 1 r
.01923 .47994 m
.03159 .47057 L
.03478 .45094 L
.03736 .43132 L
.03885 .42264 L
.04123 .4117 L
.04698 .39207 L
.05848 .38032 L
.06199 .37245 L
.07202 .35283 L
.0781 .34261 L
.08191 .3332 L
.09387 .31358 L
.09772 .30747 L
.10499 .29396 L
.11714 .27433 L
.11735 .27401 L
.12877 .25471 L
.13697 .24172 L
.14094 .23509 L
.15328 .21546 L
.15659 .21031 L
.16568 .19584 L
.17622 .17956 L
.17834 .17622 L
.19106 .15659 L
.19584 .14932 L
.20389 .13697 L
.21546 .1195 L
.21688 .11735 L
.22991 .09772 L
.23509 .09 L
.24303 .0781 L
.25471 .06076 L
.25624 .05848 L
.2695 .03885 L
.27433 .03173 L
.2828 .01923 L
.01923 .01923 L
F
0 g
.01923 .47994 m
.03159 .47057 L
.03478 .45094 L
.03736 .43132 L
.03885 .42264 L
.04123 .4117 L
.04698 .39207 L
.05848 .38032 L
.06199 .37245 L
.07202 .35283 L
.0781 .34261 L
.08191 .3332 L
.09387 .31358 L
.09772 .30747 L
.10499 .29396 L
.11714 .27433 L
.11735 .27401 L
.12877 .25471 L
.13697 .24172 L
.14094 .23509 L
.15328 .21546 L
.15659 .21031 L
.16568 .19584 L
.17622 .17956 L
.17834 .17622 L
.19106 .15659 L
.19584 .14932 L
.20389 .13697 L
.21546 .1195 L
.21688 .11735 L
.22991 .09772 L
.23509 .09 L
.24303 .0781 L
.25471 .06076 L
.25624 .05848 L
.2695 .03885 L
.27433 .03173 L
.2828 .01923 L
s
.2 1 0 r
.01923 .52006 m
.03159 .52943 L
.03478 .54906 L
.03736 .56868 L
.03885 .57736 L
.04123 .5883 L
.04698 .60793 L
.05848 .61968 L
.06199 .62755 L
.07202 .64717 L
.0781 .65739 L
.08191 .6668 L
.09387 .68642 L
.09772 .69253 L
.10499 .70604 L
.11714 .72567 L
.11735 .72599 L
.12877 .74529 L
.13697 .75828 L
.14094 .76491 L
.15328 .78454 L
.15659 .78969 L
.16568 .80416 L
.17622 .82044 L
.17834 .82378 L
.19106 .84341 L
.19584 .85068 L
.20389 .86303 L
.21546 .8805 L
.21688 .88265 L
.22991 .90228 L
.23509 .91 L
.24303 .9219 L
.25471 .93924 L
.25624 .94152 L
.2695 .96115 L
.27433 .96827 L
.2828 .98077 L
.01923 .98077 L
F
0 g
.01923 .52006 m
.03159 .52943 L
.03478 .54906 L
.03736 .56868 L
.03885 .57736 L
.04123 .5883 L
.04698 .60793 L
.05848 .61968 L
.06199 .62755 L
.07202 .64717 L
.0781 .65739 L
.08191 .6668 L
.09387 .68642 L
.09772 .69253 L
.10499 .70604 L
.11714 .72567 L
.11735 .72599 L
.12877 .74529 L
.13697 .75828 L
.14094 .76491 L
.15328 .78454 L
.15659 .78969 L
.16568 .80416 L
.17622 .82044 L
.17834 .82378 L
.19106 .84341 L
.19584 .85068 L
.20389 .86303 L
.21546 .8805 L
.21688 .88265 L
.22991 .90228 L
.23509 .91 L
.24303 .9219 L
.25471 .93924 L
.25624 .94152 L
.2695 .96115 L
.27433 .96827 L
.2828 .98077 L
s
.5 0 1 r
.01923 .47985 m
.03139 .47057 L
.03463 .45094 L
.03718 .43132 L
.03885 .42155 L
.04096 .4117 L
.04643 .39207 L
.05848 .37782 L
.06078 .37245 L
.07012 .35283 L
.0781 .33844 L
.07992 .3332 L
.09052 .31358 L
.09772 .30143 L
.10136 .29396 L
.11241 .27433 L
.11735 .26592 L
.12342 .25471 L
.1348 .23509 L
.13697 .23141 L
.14605 .21546 L
.15659 .19761 L
.15761 .19584 L
.16911 .17622 L
.17622 .16432 L
.18076 .15659 L
.19248 .13697 L
.19584 .13139 L
.20422 .11735 L
.21546 .09871 L
.21605 .09772 L
.22787 .0781 L
.23509 .0662 L
.23975 .05848 L
.25164 .03885 L
.25471 .0338 L
.26353 .01923 L
.01923 .01923 L
F
0 g
.01923 .47985 m
.03139 .47057 L
.03463 .45094 L
.03718 .43132 L
.03885 .42155 L
.04096 .4117 L
.04643 .39207 L
.05848 .37782 L
.06078 .37245 L
.07012 .35283 L
.0781 .33844 L
.07992 .3332 L
.09052 .31358 L
.09772 .30143 L
.10136 .29396 L
.11241 .27433 L
.11735 .26592 L
.12342 .25471 L
.1348 .23509 L
.13697 .23141 L
.14605 .21546 L
.15659 .19761 L
.15761 .19584 L
.16911 .17622 L
.17622 .16432 L
.18076 .15659 L
.19248 .13697 L
.19584 .13139 L
.20422 .11735 L
.21546 .09871 L
.21605 .09772 L
.22787 .0781 L
.23509 .0662 L
.23975 .05848 L
.25164 .03885 L
.25471 .0338 L
.26353 .01923 L
s
.5 1 0 r
.01923 .52015 m
.03139 .52943 L
.03463 .54906 L
.03718 .56868 L
.03885 .57845 L
.04096 .5883 L
.04643 .60793 L
.05848 .62218 L
.06078 .62755 L
.07012 .64717 L
.0781 .66156 L
.07992 .6668 L
.09052 .68642 L
.09772 .69857 L
.10136 .70604 L
.11241 .72567 L
.11735 .73408 L
.12342 .74529 L
.1348 .76491 L
.13697 .76859 L
.14605 .78454 L
.15659 .80239 L
.15761 .80416 L
.16911 .82378 L
.17622 .83568 L
.18076 .84341 L
.19248 .86303 L
.19584 .86861 L
.20422 .88265 L
.21546 .90129 L
.21605 .90228 L
.22787 .9219 L
.23509 .9338 L
.23975 .94152 L
.25164 .96115 L
.25471 .9662 L
.26353 .98077 L
.01923 .98077 L
F
0 g
.01923 .52015 m
.03139 .52943 L
.03463 .54906 L
.03718 .56868 L
.03885 .57845 L
.04096 .5883 L
.04643 .60793 L
.05848 .62218 L
.06078 .62755 L
.07012 .64717 L
.0781 .66156 L
.07992 .6668 L
.09052 .68642 L
.09772 .69857 L
.10136 .70604 L
.11241 .72567 L
.11735 .73408 L
.12342 .74529 L
.1348 .76491 L
.13697 .76859 L
.14605 .78454 L
.15659 .80239 L
.15761 .80416 L
.16911 .82378 L
.17622 .83568 L
.18076 .84341 L
.19248 .86303 L
.19584 .86861 L
.20422 .88265 L
.21546 .90129 L
.21605 .90228 L
.22787 .9219 L
.23509 .9338 L
.23975 .94152 L
.25164 .96115 L
.25471 .9662 L
.26353 .98077 L
s
.5 0 1 r
.01923 .51931 m
.03331 .52943 L
.03605 .54906 L
.03885 .56819 L
.03895 .56868 L
.04389 .5883 L
.05848 .59935 L
.06391 .60793 L
.0781 .62309 L
.08205 .62755 L
.09772 .64249 L
.10295 .64717 L
.11735 .65859 L
.12892 .6668 L
.13697 .67185 L
.15659 .68271 L
.16475 .68642 L
.17622 .69102 L
.19584 .69695 L
.21546 .69986 L
.23509 .69892 L
.25374 .68642 L
.25471 .68499 L
.2588 .6668 L
.25471 .65104 L
.25299 .64717 L
.24076 .62755 L
.23509 .61959 L
.22348 .60793 L
.21546 .59982 L
.20162 .5883 L
.19584 .58353 L
.17622 .56933 L
.17517 .56868 L
.15659 .55648 L
.14356 .54906 L
.13697 .54526 L
.11735 .53487 L
.10535 .52943 L
.09772 .52581 L
.0781 .51735 L
.05848 .51031 L
.04359 .50981 L
.03885 .50438 L
.01923 .50046 L
F
0 g
.01923 .51931 m
.03331 .52943 L
.03605 .54906 L
.03885 .56819 L
.03895 .56868 L
.04389 .5883 L
.05848 .59935 L
.06391 .60793 L
.0781 .62309 L
.08205 .62755 L
.09772 .64249 L
.10295 .64717 L
.11735 .65859 L
.12892 .6668 L
.13697 .67185 L
.15659 .68271 L
.16475 .68642 L
.17622 .69102 L
.19584 .69695 L
.21546 .69986 L
.23509 .69892 L
.25374 .68642 L
.25471 .68499 L
.2588 .6668 L
.25471 .65104 L
.25299 .64717 L
.24076 .62755 L
.23509 .61959 L
.22348 .60793 L
.21546 .59982 L
.20162 .5883 L
.19584 .58353 L
.17622 .56933 L
.17517 .56868 L
.15659 .55648 L
.14356 .54906 L
.13697 .54526 L
.11735 .53487 L
.10535 .52943 L
.09772 .52581 L
.0781 .51735 L
.05848 .51031 L
.04359 .50981 L
.03885 .50438 L
.01923 .50046 L
s
.5 1 0 r
.01923 .49954 m
.03885 .49562 L
.04359 .49019 L
.05848 .48969 L
.0781 .48265 L
.09772 .47419 L
.10535 .47057 L
.11735 .46513 L
.13697 .45474 L
.14356 .45094 L
.15659 .44352 L
.17517 .43132 L
.17622 .43067 L
.19584 .41647 L
.20162 .4117 L
.21546 .40018 L
.22348 .39207 L
.23509 .38041 L
.24076 .37245 L
.25299 .35283 L
.25471 .34896 L
.2588 .3332 L
.25471 .31501 L
.25374 .31358 L
.23509 .30108 L
.21546 .30014 L
.19584 .30305 L
.17622 .30898 L
.16475 .31358 L
.15659 .31729 L
.13697 .32815 L
.12892 .3332 L
.11735 .34141 L
.10295 .35283 L
.09772 .35751 L
.08205 .37245 L
.0781 .37691 L
.06391 .39207 L
.05848 .40065 L
.04389 .4117 L
.03895 .43132 L
.03885 .43181 L
.03605 .45094 L
.03331 .47057 L
.01923 .48069 L
F
0 g
.01923 .49954 m
.03885 .49562 L
.04359 .49019 L
.05848 .48969 L
.0781 .48265 L
.09772 .47419 L
.10535 .47057 L
.11735 .46513 L
.13697 .45474 L
.14356 .45094 L
.15659 .44352 L
.17517 .43132 L
.17622 .43067 L
.19584 .41647 L
.20162 .4117 L
.21546 .40018 L
.22348 .39207 L
.23509 .38041 L
.24076 .37245 L
.25299 .35283 L
.25471 .34896 L
.2588 .3332 L
.25471 .31501 L
.25374 .31358 L
.23509 .30108 L
.21546 .30014 L
.19584 .30305 L
.17622 .30898 L
.16475 .31358 L
.15659 .31729 L
.13697 .32815 L
.12892 .3332 L
.11735 .34141 L
.10295 .35283 L
.09772 .35751 L
.08205 .37245 L
.0781 .37691 L
.06391 .39207 L
.05848 .40065 L
.04389 .4117 L
.03895 .43132 L
.03885 .43181 L
.03605 .45094 L
.03331 .47057 L
.01923 .48069 L
s
.8 0 1 r
.01923 .47976 m
.0312 .47057 L
.03449 .45094 L
.03701 .43132 L
.03885 .42046 L
.0407 .4117 L
.04592 .39207 L
.05848 .37532 L
.05966 .37245 L
.06844 .35283 L
.0781 .33425 L
.07841 .3332 L
.08758 .31358 L
.09772 .29533 L
.09833 .29396 L
.10825 .27433 L
.11735 .25771 L
.11884 .25471 L
.12919 .23509 L
.13697 .22089 L
.13981 .21546 L
.15041 .19584 L
.15659 .18459 L
.16109 .17622 L
.17181 .15659 L
.17622 .1486 L
.18254 .13697 L
.19332 .11735 L
.19584 .11277 L
.20406 .09772 L
.21486 .0781 L
.21546 .077 L
.2256 .05848 L
.23509 .04118 L
.23636 .03885 L
.24707 .01923 L
.01923 .01923 L
F
0 g
.01923 .47976 m
.0312 .47057 L
.03449 .45094 L
.03701 .43132 L
.03885 .42046 L
.0407 .4117 L
.04592 .39207 L
.05848 .37532 L
.05966 .37245 L
.06844 .35283 L
.0781 .33425 L
.07841 .3332 L
.08758 .31358 L
.09772 .29533 L
.09833 .29396 L
.10825 .27433 L
.11735 .25771 L
.11884 .25471 L
.12919 .23509 L
.13697 .22089 L
.13981 .21546 L
.15041 .19584 L
.15659 .18459 L
.16109 .17622 L
.17181 .15659 L
.17622 .1486 L
.18254 .13697 L
.19332 .11735 L
.19584 .11277 L
.20406 .09772 L
.21486 .0781 L
.21546 .077 L
.2256 .05848 L
.23509 .04118 L
.23636 .03885 L
.24707 .01923 L
s
.8 1 0 r
.01923 .52024 m
.0312 .52943 L
.03449 .54906 L
.03701 .56868 L
.03885 .57954 L
.0407 .5883 L
.04592 .60793 L
.05848 .62468 L
.05966 .62755 L
.06844 .64717 L
.0781 .66575 L
.07841 .6668 L
.08758 .68642 L
.09772 .70467 L
.09833 .70604 L
.10825 .72567 L
.11735 .74229 L
.11884 .74529 L
.12919 .76491 L
.13697 .77911 L
.13981 .78454 L
.15041 .80416 L
.15659 .81541 L
.16109 .82378 L
.17181 .84341 L
.17622 .8514 L
.18254 .86303 L
.19332 .88265 L
.19584 .88723 L
.20406 .90228 L
.21486 .9219 L
.21546 .923 L
.2256 .94152 L
.23509 .95882 L
.23636 .96115 L
.24707 .98077 L
.01923 .98077 L
F
0 g
.01923 .52024 m
.0312 .52943 L
.03449 .54906 L
.03701 .56868 L
.03885 .57954 L
.0407 .5883 L
.04592 .60793 L
.05848 .62468 L
.05966 .62755 L
.06844 .64717 L
.0781 .66575 L
.07841 .6668 L
.08758 .68642 L
.09772 .70467 L
.09833 .70604 L
.10825 .72567 L
.11735 .74229 L
.11884 .74529 L
.12919 .76491 L
.13697 .77911 L
.13981 .78454 L
.15041 .80416 L
.15659 .81541 L
.16109 .82378 L
.17181 .84341 L
.17622 .8514 L
.18254 .86303 L
.19332 .88265 L
.19584 .88723 L
.20406 .90228 L
.21486 .9219 L
.21546 .923 L
.2256 .94152 L
.23509 .95882 L
.23636 .96115 L
.24707 .98077 L
s
1 0 .9 r
.01923 .47967 m
.03101 .47057 L
.03435 .45094 L
.03684 .43132 L
.03885 .41937 L
.04045 .4117 L
.04545 .39207 L
.05848 .37282 L
.05862 .37245 L
.06692 .35283 L
.07636 .3332 L
.0781 .33003 L
.08501 .31358 L
.09521 .29396 L
.09772 .28915 L
.1046 .27433 L
.11458 .25471 L
.11735 .24934 L
.12426 .23509 L
.13422 .21546 L
.13697 .2101 L
.14404 .19584 L
.154 .17622 L
.15659 .17113 L
.16387 .15659 L
.17381 .13697 L
.17622 .13224 L
.18368 .11735 L
.19358 .09772 L
.19584 .09325 L
.20341 .0781 L
.21324 .05848 L
.21546 .05403 L
.223 .03885 L
.23274 .01923 L
.01923 .01923 L
F
0 g
.01923 .47967 m
.03101 .47057 L
.03435 .45094 L
.03684 .43132 L
.03885 .41937 L
.04045 .4117 L
.04545 .39207 L
.05848 .37282 L
.05862 .37245 L
.06692 .35283 L
.07636 .3332 L
.0781 .33003 L
.08501 .31358 L
.09521 .29396 L
.09772 .28915 L
.1046 .27433 L
.11458 .25471 L
.11735 .24934 L
.12426 .23509 L
.13422 .21546 L
.13697 .2101 L
.14404 .19584 L
.154 .17622 L
.15659 .17113 L
.16387 .15659 L
.17381 .13697 L
.17622 .13224 L
.18368 .11735 L
.19358 .09772 L
.19584 .09325 L
.20341 .0781 L
.21324 .05848 L
.21546 .05403 L
.223 .03885 L
.23274 .01923 L
s
1 .9 0 r
.01923 .52033 m
.03101 .52943 L
.03435 .54906 L
.03684 .56868 L
.03885 .58063 L
.04045 .5883 L
.04545 .60793 L
.05848 .62718 L
.05862 .62755 L
.06692 .64717 L
.07636 .6668 L
.0781 .66997 L
.08501 .68642 L
.09521 .70604 L
.09772 .71085 L
.1046 .72567 L
.11458 .74529 L
.11735 .75066 L
.12426 .76491 L
.13422 .78454 L
.13697 .7899 L
.14404 .80416 L
.154 .82378 L
.15659 .82887 L
.16387 .84341 L
.17381 .86303 L
.17622 .86776 L
.18368 .88265 L
.19358 .90228 L
.19584 .90675 L
.20341 .9219 L
.21324 .94152 L
.21546 .94597 L
.223 .96115 L
.23274 .98077 L
.01923 .98077 L
F
0 g
.01923 .52033 m
.03101 .52943 L
.03435 .54906 L
.03684 .56868 L
.03885 .58063 L
.04045 .5883 L
.04545 .60793 L
.05848 .62718 L
.05862 .62755 L
.06692 .64717 L
.07636 .6668 L
.0781 .66997 L
.08501 .68642 L
.09521 .70604 L
.09772 .71085 L
.1046 .72567 L
.11458 .74529 L
.11735 .75066 L
.12426 .76491 L
.13422 .78454 L
.13697 .7899 L
.14404 .80416 L
.154 .82378 L
.15659 .82887 L
.16387 .84341 L
.17381 .86303 L
.17622 .86776 L
.18368 .88265 L
.19358 .90228 L
.19584 .90675 L
.20341 .9219 L
.21324 .94152 L
.21546 .94597 L
.223 .96115 L
.23274 .98077 L
s
1 0 .6 r
.01923 .47958 m
.03083 .47057 L
.03421 .45094 L
.03667 .43132 L
.03885 .41829 L
.0402 .4117 L
.04501 .39207 L
.05353 .37245 L
.05848 .37029 L
.06554 .35283 L
.07418 .3332 L
.0781 .32575 L
.08278 .31358 L
.09223 .29396 L
.09772 .28286 L
.10139 .27433 L
.1106 .25471 L
.11735 .24076 L
.1199 .23509 L
.12908 .21546 L
.13697 .19895 L
.1384 .19584 L
.14756 .17622 L
.15659 .15712 L
.15684 .15659 L
.16596 .13697 L
.17514 .11735 L
.17622 .11504 L
.18421 .09772 L
.19327 .0781 L
.19584 .07252 L
.20225 .05848 L
.21118 .03885 L
.21546 .02939 L
.22003 .01923 L
.01923 .01923 L
F
0 g
.01923 .47958 m
.03083 .47057 L
.03421 .45094 L
.03667 .43132 L
.03885 .41829 L
.0402 .4117 L
.04501 .39207 L
.05353 .37245 L
.05848 .37029 L
.06554 .35283 L
.07418 .3332 L
.0781 .32575 L
.08278 .31358 L
.09223 .29396 L
.09772 .28286 L
.10139 .27433 L
.1106 .25471 L
.11735 .24076 L
.1199 .23509 L
.12908 .21546 L
.13697 .19895 L
.1384 .19584 L
.14756 .17622 L
.15659 .15712 L
.15684 .15659 L
.16596 .13697 L
.17514 .11735 L
.17622 .11504 L
.18421 .09772 L
.19327 .0781 L
.19584 .07252 L
.20225 .05848 L
.21118 .03885 L
.21546 .02939 L
.22003 .01923 L
s
1 .6 0 r
.01923 .52042 m
.03083 .52943 L
.03421 .54906 L
.03667 .56868 L
.03885 .58171 L
.0402 .5883 L
.04501 .60793 L
.05353 .62755 L
.05848 .62971 L
.06554 .64717 L
.07418 .6668 L
.0781 .67425 L
.08278 .68642 L
.09223 .70604 L
.09772 .71714 L
.10139 .72567 L
.1106 .74529 L
.11735 .75924 L
.1199 .76491 L
.12908 .78454 L
.13697 .80105 L
.1384 .80416 L
.14756 .82378 L
.15659 .84288 L
.15684 .84341 L
.16596 .86303 L
.17514 .88265 L
.17622 .88496 L
.18421 .90228 L
.19327 .9219 L
.19584 .92748 L
.20225 .94152 L
.21118 .96115 L
.21546 .97061 L
.22003 .98077 L
.01923 .98077 L
F
0 g
.01923 .52042 m
.03083 .52943 L
.03421 .54906 L
.03667 .56868 L
.03885 .58171 L
.0402 .5883 L
.04501 .60793 L
.05353 .62755 L
.05848 .62971 L
.06554 .64717 L
.07418 .6668 L
.0781 .67425 L
.08278 .68642 L
.09223 .70604 L
.09772 .71714 L
.10139 .72567 L
.1106 .74529 L
.11735 .75924 L
.1199 .76491 L
.12908 .78454 L
.13697 .80105 L
.1384 .80416 L
.14756 .82378 L
.15659 .84288 L
.15684 .84341 L
.16596 .86303 L
.17514 .88265 L
.17622 .88496 L
.18421 .90228 L
.19327 .9219 L
.19584 .92748 L
.20225 .94152 L
.21118 .96115 L
.21546 .97061 L
.22003 .98077 L
s
1 0 .3 r
.01923 .47948 m
.03065 .47057 L
.03407 .45094 L
.0365 .43132 L
.03885 .41721 L
.03997 .4117 L
.0446 .39207 L
.05193 .37245 L
.05848 .36774 L
.06426 .35283 L
.07218 .3332 L
.0781 .32142 L
.08086 .31358 L
.08953 .29396 L
.09772 .27643 L
.09856 .27433 L
.10701 .25471 L
.11591 .23509 L
.11735 .23192 L
.12446 .21546 L
.13319 .19584 L
.13697 .18736 L
.14179 .17622 L
.15037 .15659 L
.15659 .1424 L
.15892 .13697 L
.16737 .11735 L
.17581 .09772 L
.17622 .09677 L
.18412 .0781 L
.19239 .05848 L
.19584 .05024 L
.20056 .03885 L
.20864 .01923 L
.01923 .01923 L
F
0 g
.01923 .47948 m
.03065 .47057 L
.03407 .45094 L
.0365 .43132 L
.03885 .41721 L
.03997 .4117 L
.0446 .39207 L
.05193 .37245 L
.05848 .36774 L
.06426 .35283 L
.07218 .3332 L
.0781 .32142 L
.08086 .31358 L
.08953 .29396 L
.09772 .27643 L
.09856 .27433 L
.10701 .25471 L
.11591 .23509 L
.11735 .23192 L
.12446 .21546 L
.13319 .19584 L
.13697 .18736 L
.14179 .17622 L
.15037 .15659 L
.15659 .1424 L
.15892 .13697 L
.16737 .11735 L
.17581 .09772 L
.17622 .09677 L
.18412 .0781 L
.19239 .05848 L
.19584 .05024 L
.20056 .03885 L
.20864 .01923 L
s
1 .3 0 r
.01923 .52052 m
.03065 .52943 L
.03407 .54906 L
.0365 .56868 L
.03885 .58279 L
.03997 .5883 L
.0446 .60793 L
.05193 .62755 L
.05848 .63226 L
.06426 .64717 L
.07218 .6668 L
.0781 .67858 L
.08086 .68642 L
.08953 .70604 L
.09772 .72357 L
.09856 .72567 L
.10701 .74529 L
.11591 .76491 L
.11735 .76808 L
.12446 .78454 L
.13319 .80416 L
.13697 .81264 L
.14179 .82378 L
.15037 .84341 L
.15659 .8576 L
.15892 .86303 L
.16737 .88265 L
.17581 .90228 L
.17622 .90323 L
.18412 .9219 L
.19239 .94152 L
.19584 .94976 L
.20056 .96115 L
.20864 .98077 L
.01923 .98077 L
F
0 g
.01923 .52052 m
.03065 .52943 L
.03407 .54906 L
.0365 .56868 L
.03885 .58279 L
.03997 .5883 L
.0446 .60793 L
.05193 .62755 L
.05848 .63226 L
.06426 .64717 L
.07218 .6668 L
.0781 .67858 L
.08086 .68642 L
.08953 .70604 L
.09772 .72357 L
.09856 .72567 L
.10701 .74529 L
.11591 .76491 L
.11735 .76808 L
.12446 .78454 L
.13319 .80416 L
.13697 .81264 L
.14179 .82378 L
.15037 .84341 L
.15659 .8576 L
.15892 .86303 L
.16737 .88265 L
.17581 .90228 L
.17622 .90323 L
.18412 .9219 L
.19239 .94152 L
.19584 .94976 L
.20056 .96115 L
.20864 .98077 L
s
1 0 0 r
.01923 .47939 m
.03047 .47057 L
.03393 .45094 L
.03634 .43132 L
.03885 .41613 L
.03974 .4117 L
.04422 .39207 L
.0508 .37245 L
.05848 .36516 L
.06308 .35283 L
.07033 .3332 L
.0781 .31701 L
.07921 .31358 L
.08708 .29396 L
.09575 .27433 L
.09772 .26985 L
.10378 .25471 L
.11209 .23509 L
.11735 .22276 L
.12029 .21546 L
.12839 .19584 L
.13655 .17622 L
.13697 .17521 L
.1445 .15659 L
.15248 .13697 L
.15659 .1268 L
.16034 .11735 L
.16812 .09772 L
.17584 .0781 L
.17622 .07714 L
.18342 .05848 L
.19093 .03885 L
.19584 .0259 L
.19834 .01923 L
.01923 .01923 L
F
0 g
.01923 .47939 m
.03047 .47057 L
.03393 .45094 L
.03634 .43132 L
.03885 .41613 L
.03974 .4117 L
.04422 .39207 L
.0508 .37245 L
.05848 .36516 L
.06308 .35283 L
.07033 .3332 L
.0781 .31701 L
.07921 .31358 L
.08708 .29396 L
.09575 .27433 L
.09772 .26985 L
.10378 .25471 L
.11209 .23509 L
.11735 .22276 L
.12029 .21546 L
.12839 .19584 L
.13655 .17622 L
.13697 .17521 L
.1445 .15659 L
.15248 .13697 L
.15659 .1268 L
.16034 .11735 L
.16812 .09772 L
.17584 .0781 L
.17622 .07714 L
.18342 .05848 L
.19093 .03885 L
.19584 .0259 L
.19834 .01923 L
s
1 0 0 r
.01923 .52061 m
.03047 .52943 L
.03393 .54906 L
.03634 .56868 L
.03885 .58387 L
.03974 .5883 L
.04422 .60793 L
.0508 .62755 L
.05848 .63484 L
.06308 .64717 L
.07033 .6668 L
.0781 .68299 L
.07921 .68642 L
.08708 .70604 L
.09575 .72567 L
.09772 .73015 L
.10378 .74529 L
.11209 .76491 L
.11735 .77724 L
.12029 .78454 L
.12839 .80416 L
.13655 .82378 L
.13697 .82479 L
.1445 .84341 L
.15248 .86303 L
.15659 .8732 L
.16034 .88265 L
.16812 .90228 L
.17584 .9219 L
.17622 .92286 L
.18342 .94152 L
.19093 .96115 L
.19584 .9741 L
.19834 .98077 L
.01923 .98077 L
F
0 g
.01923 .52061 m
.03047 .52943 L
.03393 .54906 L
.03634 .56868 L
.03885 .58387 L
.03974 .5883 L
.04422 .60793 L
.0508 .62755 L
.05848 .63484 L
.06308 .64717 L
.07033 .6668 L
.0781 .68299 L
.07921 .68642 L
.08708 .70604 L
.09575 .72567 L
.09772 .73015 L
.10378 .74529 L
.11209 .76491 L
.11735 .77724 L
.12029 .78454 L
.12839 .80416 L
.13655 .82378 L
.13697 .82479 L
.1445 .84341 L
.15248 .86303 L
.15659 .8732 L
.16034 .88265 L
.16812 .90228 L
.17584 .9219 L
.17622 .92286 L
.18342 .94152 L
.19093 .96115 L
.19584 .9741 L
.19834 .98077 L
s
.8 1 0 r
.01923 .49943 m
.03885 .49459 L
.04231 .49019 L
.05848 .4879 L
.0781 .47836 L
.0921 .47057 L
.09772 .46789 L
.11735 .45559 L
.12386 .45094 L
.13697 .44193 L
.1493 .43132 L
.15659 .42584 L
.16954 .4117 L
.17622 .40713 L
.18469 .39207 L
.194 .37245 L
.19461 .35283 L
.17622 .3378 L
.15659 .33684 L
.13697 .34248 L
.11735 .35209 L
.11593 .35283 L
.09772 .36485 L
.08757 .37245 L
.0781 .38166 L
.06631 .39207 L
.05848 .40343 L
.04431 .4117 L
.03917 .43132 L
.03885 .43297 L
.03622 .45094 L
.03355 .47057 L
.01923 .48078 L
F
0 g
.01923 .49943 m
.03885 .49459 L
.04231 .49019 L
.05848 .4879 L
.0781 .47836 L
.0921 .47057 L
.09772 .46789 L
.11735 .45559 L
.12386 .45094 L
.13697 .44193 L
.1493 .43132 L
.15659 .42584 L
.16954 .4117 L
.17622 .40713 L
.18469 .39207 L
.194 .37245 L
.19461 .35283 L
.17622 .3378 L
.15659 .33684 L
.13697 .34248 L
.11735 .35209 L
.11593 .35283 L
.09772 .36485 L
.08757 .37245 L
.0781 .38166 L
.06631 .39207 L
.05848 .40343 L
.04431 .4117 L
.03917 .43132 L
.03885 .43297 L
.03622 .45094 L
.03355 .47057 L
.01923 .48078 L
s
.8 0 1 r
.01923 .51922 m
.03355 .52943 L
.03622 .54906 L
.03885 .56703 L
.03917 .56868 L
.04431 .5883 L
.05848 .59657 L
.06631 .60793 L
.0781 .61834 L
.08757 .62755 L
.09772 .63515 L
.11593 .64717 L
.11735 .64791 L
.13697 .65752 L
.15659 .66316 L
.17622 .6622 L
.19461 .64717 L
.194 .62755 L
.18469 .60793 L
.17622 .59287 L
.16954 .5883 L
.15659 .57416 L
.1493 .56868 L
.13697 .55807 L
.12386 .54906 L
.11735 .54441 L
.09772 .53211 L
.0921 .52943 L
.0781 .52164 L
.05848 .5121 L
.04231 .50981 L
.03885 .50541 L
.01923 .50057 L
F
0 g
.01923 .51922 m
.03355 .52943 L
.03622 .54906 L
.03885 .56703 L
.03917 .56868 L
.04431 .5883 L
.05848 .59657 L
.06631 .60793 L
.0781 .61834 L
.08757 .62755 L
.09772 .63515 L
.11593 .64717 L
.11735 .64791 L
.13697 .65752 L
.15659 .66316 L
.17622 .6622 L
.19461 .64717 L
.194 .62755 L
.18469 .60793 L
.17622 .59287 L
.16954 .5883 L
.15659 .57416 L
.1493 .56868 L
.13697 .55807 L
.12386 .54906 L
.11735 .54441 L
.09772 .53211 L
.0921 .52943 L
.0781 .52164 L
.05848 .5121 L
.04231 .50981 L
.03885 .50541 L
.01923 .50057 L
s
1 0 .9 r
.01923 .51912 m
.0338 .52943 L
.0364 .54906 L
.03885 .56585 L
.0394 .56868 L
.04478 .5883 L
.05848 .59363 L
.06974 .60793 L
.0781 .61315 L
.09772 .62702 L
.09887 .62755 L
.11735 .63618 L
.13697 .6408 L
.15502 .62755 L
.15456 .60793 L
.14546 .5883 L
.13697 .57651 L
.13021 .56868 L
.11735 .55439 L
.10942 .54906 L
.09772 .53907 L
.08241 .52943 L
.0781 .52638 L
.05848 .51414 L
.04126 .50981 L
.03885 .50647 L
.01923 .50067 L
F
0 g
.01923 .51912 m
.0338 .52943 L
.0364 .54906 L
.03885 .56585 L
.0394 .56868 L
.04478 .5883 L
.05848 .59363 L
.06974 .60793 L
.0781 .61315 L
.09772 .62702 L
.09887 .62755 L
.11735 .63618 L
.13697 .6408 L
.15502 .62755 L
.15456 .60793 L
.14546 .5883 L
.13697 .57651 L
.13021 .56868 L
.11735 .55439 L
.10942 .54906 L
.09772 .53907 L
.08241 .52943 L
.0781 .52638 L
.05848 .51414 L
.04126 .50981 L
.03885 .50647 L
.01923 .50067 L
s
1 .9 0 r
.01923 .49933 m
.03885 .49353 L
.04126 .49019 L
.05848 .48586 L
.0781 .47362 L
.08241 .47057 L
.09772 .46093 L
.10942 .45094 L
.11735 .44561 L
.13021 .43132 L
.13697 .42349 L
.14546 .4117 L
.15456 .39207 L
.15502 .37245 L
.13697 .3592 L
.11735 .36382 L
.09887 .37245 L
.09772 .37298 L
.0781 .38685 L
.06974 .39207 L
.05848 .40637 L
.04478 .4117 L
.0394 .43132 L
.03885 .43415 L
.0364 .45094 L
.0338 .47057 L
.01923 .48088 L
F
0 g
.01923 .49933 m
.03885 .49353 L
.04126 .49019 L
.05848 .48586 L
.0781 .47362 L
.08241 .47057 L
.09772 .46093 L
.10942 .45094 L
.11735 .44561 L
.13021 .43132 L
.13697 .42349 L
.14546 .4117 L
.15456 .39207 L
.15502 .37245 L
.13697 .3592 L
.11735 .36382 L
.09887 .37245 L
.09772 .37298 L
.0781 .38685 L
.06974 .39207 L
.05848 .40637 L
.04478 .4117 L
.0394 .43132 L
.03885 .43415 L
.0364 .45094 L
.0338 .47057 L
.01923 .48088 L
s
1 0 .6 r
.01923 .51903 m
.03405 .52943 L
.03658 .54906 L
.03885 .56465 L
.03964 .56868 L
.04529 .5883 L
.05848 .59051 L
.0781 .60771 L
.07873 .60793 L
.09772 .61882 L
.11735 .61873 L
.12909 .60793 L
.12615 .5883 L
.11735 .57158 L
.11534 .56868 L
.09841 .54906 L
.09772 .54829 L
.0781 .53002 L
.0751 .52943 L
.05848 .5165 L
.04035 .50981 L
.03885 .50757 L
.01923 .50078 L
F
0 g
.01923 .51903 m
.03405 .52943 L
.03658 .54906 L
.03885 .56465 L
.03964 .56868 L
.04529 .5883 L
.05848 .59051 L
.0781 .60771 L
.07873 .60793 L
.09772 .61882 L
.11735 .61873 L
.12909 .60793 L
.12615 .5883 L
.11735 .57158 L
.11534 .56868 L
.09841 .54906 L
.09772 .54829 L
.0781 .53002 L
.0751 .52943 L
.05848 .5165 L
.04035 .50981 L
.03885 .50757 L
.01923 .50078 L
s
1 .6 0 r
.01923 .49922 m
.03885 .49243 L
.04035 .49019 L
.05848 .4835 L
.0751 .47057 L
.0781 .46998 L
.09772 .45171 L
.09841 .45094 L
.11534 .43132 L
.11735 .42842 L
.12615 .4117 L
.12909 .39207 L
.11735 .38127 L
.09772 .38118 L
.07873 .39207 L
.0781 .39229 L
.05848 .40949 L
.04529 .4117 L
.03964 .43132 L
.03885 .43535 L
.03658 .45094 L
.03405 .47057 L
.01923 .48097 L
F
0 g
.01923 .49922 m
.03885 .49243 L
.04035 .49019 L
.05848 .4835 L
.0751 .47057 L
.0781 .46998 L
.09772 .45171 L
.09841 .45094 L
.11534 .43132 L
.11735 .42842 L
.12615 .4117 L
.12909 .39207 L
.11735 .38127 L
.09772 .38118 L
.07873 .39207 L
.0781 .39229 L
.05848 .40949 L
.04529 .4117 L
.03964 .43132 L
.03885 .43535 L
.03658 .45094 L
.03405 .47057 L
.01923 .48097 L
s
1 0 .3 r
.01923 .51893 m
.03431 .52943 L
.03677 .54906 L
.03885 .56343 L
.03989 .56868 L
.05848 .58725 L
.05922 .5883 L
.0781 .60405 L
.09772 .60531 L
.10995 .5883 L
.10317 .56868 L
.09772 .55974 L
.08937 .54906 L
.0781 .53337 L
.06883 .52943 L
.05848 .5193 L
.03953 .50981 L
.03885 .50871 L
.01923 .50088 L
F
0 g
.01923 .51893 m
.03431 .52943 L
.03677 .54906 L
.03885 .56343 L
.03989 .56868 L
.05848 .58725 L
.05922 .5883 L
.0781 .60405 L
.09772 .60531 L
.10995 .5883 L
.10317 .56868 L
.09772 .55974 L
.08937 .54906 L
.0781 .53337 L
.06883 .52943 L
.05848 .5193 L
.03953 .50981 L
.03885 .50871 L
.01923 .50088 L
s
1 .3 0 r
.01923 .49912 m
.03885 .49129 L
.03953 .49019 L
.05848 .4807 L
.06883 .47057 L
.0781 .46663 L
.08937 .45094 L
.09772 .44026 L
.10317 .43132 L
.10995 .4117 L
.09772 .39469 L
.0781 .39595 L
.05922 .4117 L
.05848 .41275 L
.03989 .43132 L
.03885 .43657 L
.03677 .45094 L
.03431 .47057 L
.01923 .48107 L
F
0 g
.01923 .49912 m
.03885 .49129 L
.03953 .49019 L
.05848 .4807 L
.06883 .47057 L
.0781 .46663 L
.08937 .45094 L
.09772 .44026 L
.10317 .43132 L
.10995 .4117 L
.09772 .39469 L
.0781 .39595 L
.05922 .4117 L
.05848 .41275 L
.03989 .43132 L
.03885 .43657 L
.03677 .45094 L
.03431 .47057 L
.01923 .48107 L
s
1 0 0 r
.01923 .51884 m
.03458 .52943 L
.03696 .54906 L
.03885 .56218 L
.04014 .56868 L
.05848 .58392 L
.06202 .5883 L
.0781 .59643 L
.09428 .5883 L
.09306 .56868 L
.08206 .54906 L
.0781 .541 L
.06396 .52943 L
.05848 .52264 L
.03885 .50991 L
.0388 .50981 L
.01923 .50098 L
F
0 g
.01923 .51884 m
.03458 .52943 L
.03696 .54906 L
.03885 .56218 L
.04014 .56868 L
.05848 .58392 L
.06202 .5883 L
.0781 .59643 L
.09428 .5883 L
.09306 .56868 L
.08206 .54906 L
.0781 .541 L
.06396 .52943 L
.05848 .52264 L
.03885 .50991 L
.0388 .50981 L
.01923 .50098 L
s
1 0 0 r
.01923 .49902 m
.0388 .49019 L
.01923 .48116 L
F
0 g
.01923 .49902 m
.0388 .49019 L
.01923 .48116 L
s
1 0 0 r
.0781 .40357 m
.09428 .4117 L
.09306 .43132 L
.08206 .45094 L
.0781 .459 L
.06396 .47057 L
.05848 .47736 L
.03885 .49009 L
.03458 .47057 L
.03696 .45094 L
.03885 .43782 L
.04014 .43132 L
.05848 .41608 L
.06202 .4117 L
F
0 g
.0781 .40357 m
.09428 .4117 L
.09306 .43132 L
.08206 .45094 L
.0781 .459 L
.06396 .47057 L
.05848 .47736 L
.03885 .49009 L
.03458 .47057 L
.03696 .45094 L
.03885 .43782 L
.04014 .43132 L
.05848 .41608 L
.06202 .4117 L
.0781 .40357 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{Inherited, Inherited}, {Inherited, 0}},
  ImageSize->{217, 216.875},
  ImageMargins->{{71.3125, 0}, {0, 7.5}},
  ImageRegion->{{0, 1}, {-0.000798, 1.00798}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004?00013a000`40O003h00O4goo10006Woo1000
1Goo0P001Goo10006Goo1@006Goo1@0017oo0P001Goo10006Goo1@0067oo1@001Goo0P001Goo1000
6Woo0`005goo000BOol00`00Oomoo`02Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02
Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0HOol00`00Oomoo`0KOol00`00Oomoo`04Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0FOol01@00Oomoogoo000067oo00D007ooOomoo`0000Eoo`80
00Aoo`03001oogoo009oo`03001oogoo01Ioo`05001oogooOol0000FOol0019oo`03001oogoo009o
o`03001oogoo01Ioo`03001oogoo009oo`03001oogoo00eoo`03001oogoo01Qoo`03001oogoo01]o
o`03001oogoo00moo`03001oogoo01Moo`03001oogoo01Yoo`03001oogoo015oo`03001oogoo01Yo
o`03001oogoo01Aoo`004Woo00<007ooOol00Woo00<007ooOol05Woo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol067oo00<007ooOol06goo00<007ooOol03goo00<007ooOol067oo00<007oo
Ool06Woo00<007ooOol047oo00<007ooOol06Woo00<007ooOol057oo000BOol00`00Oomoo`02Ool0
0`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`09Ool4000KOol00`00Oomoo`0KOol00`00Oomo
o`0;Ool4000LOol00`00Oomoo`0JOol00`00Oomoo`0;Ool4000KOol2000GOol0019oo`03001oogoo
009oo`03001oogoo01Ioo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo01aoo`03001oogoo
01]oo`03001oogoo00]oo`03001oogoo01ioo`03001oogoo01Yoo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo01Aoo`004Woo00<007ooOol00Woo00<007ooOol05Woo00<007ooOol00Woo00<0
07ooOol02Goo00<007ooOol06Woo0`006goo0`003Goo00<007ooOol06Woo00D007ooOomoo`0001Qo
o`05001oogooOol0000<Ool00`00Oomoo`0JOol01@00Oomoogoo00005Woo000COol4000JOol4000<
Ool5000JOol00`00Oomoo`0KOol00`00Oomoo`0;Ool5000IOol3000JOol3000=Ool5000IOol3000G
Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo1Woo0P000Woo0P0017oo003oOol7
Ool01000Oomoo`001Goo000BOooZ000;Ool20006Ool0019oo`04001oogoo0007Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool01@00Oomoogoo00002goo0P001Woo
0009Ool30006Ool01000Oomoo`009Goo00<007ooOol08Woo00<007ooOol08goo00<007ooOol08goo
00<007ooOol08Woo00<007ooOol08goo00D007ooOomoo`0000Yoo`04001oogoo0005Ool000Qoo`05
001oogooOol00005Ool00`00Oomoo`3VOol00`00Oomoo`07Ool20002Ool20004Ool000aoo`03001o
ogoo00=oo`03001oogoo0>Ioo`03001oogoo015oo`001P001Woo00<007ooOol00goo0P00;7oo00<0
07oo00000Woo00@007ooOol0009oo`05001oogooOol00004Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool20008Ool00`00Oomoo`0:Ool2000KOol00`00Oomoo`1TOol2000COol000Yoo`8000Ioo`04001o
ogooOolYO0001000O0Ul20000W`B00l007`LO1/0060OI1l003`O>1l001@O61lD7aPO00000P1O01<0
O`1O0001O`6O0Gl1W`5o0002_`;O0[l2g`:o0]l2_`;O0[l0000;0ol200006`?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP020000I0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/17oo00<007ooOol04Goo000<Ool00`00Oomoo`03Ool01000Oomoogoo:G`000<007`80000
0W`B00L007`LO1`0060OI1l00003?1l01P0051lD7aPO51l000@0G`030001W`6O00<1W`040002_`:o
0]l30[l00`;O0000000;0ol00`000oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@060oH3m@?e0oD3mP?e0P00IP?/17oo00<007ooOol04Goo0008Ool01@00Oomoogoo00001Goo00@0
07ooOomoobQl0004001l27`90002O1804@00O1]l7000I1mP7`00>1ll7`0061lD7aPO51l0001O07l0
0P1O00l0006O0Gl1W`5o0Il000;O0[l2g`:o0]l2_`;O00002`?o0P0001P3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH40000J0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`4Ool00`00Oomoo`0AOol000Uoo`<000Ioo`04001oogooOolXO0000`00O0T00002O1801`00
O1al7000I1mP7`00008l7`06000D7a@O61lD7`00101O00<0006O0Il00`6O00@000:o0[l2g`<2_`03
0]l000?o00X3o`040003m@?e0oH30oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3
m@00001/0n`4Ool00`00Oomoo`0AOol0019oo`04001oogooOolXO0003000O0P007`BO1<007`LO1/0
060OI1l0008l7`07000D7aPO51l0001O07l00P1O0100006O0Gl1W`5o0Il1O`000[l2g`:o0]l2_`;O
0[l000X3o`0I0003mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD0
0P0006d3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k004Ool00`00Oomoo`0AOol0
019oo`04001oogooOolWO0000`00O0P00002O1801`00O1al7000H1mT7`00008l7`05000D7aPO51l0
000405l00`000Il1W`040Il00`000[l2g`030[l00`;O0[l0000:0ol010000oD3m@?f0`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD00`?f0000001_0n`4Ool00`00Oomoo`0AOol0019oo`04
001oogooOolWO0003000O0T007`CO18007`KO1`006@OH1l0008l7`06000H7a@O61l0001o0`1O00d0
005o0Il1O`6O0Gl000:o0]l2_`;O0[l2g`02000:0ol05P000oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0`000743k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/00=oo`8001=oo`004Woo00@007ooOomoobIl0006001l2G`8001l4P000W`L00@006@O
H1l0008l7`05000H7a@O51l0000405l00`000Il1W`030Il00`000[l2g`030[l00`;O0003o`090ol2
00020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3m@00001d0n`4Ool00`00Oomo
o`0AOol0019oo`04001oogooOolVO0002`00O0Ql2@00O18007`L001T7f0O00000S`O00Hh7`0051lH
7`0007l305l03P000Gl1W`5o0Il1O`000[l2g`:o0]l2_`;O000:0ol050000oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD30000MP?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/17oo00<007ooOol04Goo000BOol01000Oomoogoo9W`000<0
07`9O0P00P000W`L00@0060OI1l000<l7`04000D7a@O000405l00`000Il1W`020Il00`000[l2g`03
0[l00`;O0003o`090ol01@000oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@030oH3m@?e008007T3
k0Aoo`03001oogoo015oo`004Woo00@007ooOomoobIl000A001l2000O18007`K001P7f@O000l7cPO
?1l001PO51l0000305l03P1o0001W`5o0Il1O`000[l2g`:o0]l2_`;O000:0ol0S`000oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol04Goo000BOol01000
Oomoogoo9G`000<007`8O0T00P000W`L00@006@OH1l0008l7`05000D7a@O61l0000405l01`000Il1
W`6O0002_`;O00<2_`030]l000?o00P3o`8000<3m@050oH3m@?e0oD3mP030oD01P?f0oD3m@?e0oH3
m@8007`3k0Aoo`03001oogoo015oo`004Woo00@007ooOomoobEl000;001l2@00O1<007`L001T7f0O
000h7`02?1l0100051lH7`000P1O00h0O`1O0001O`6O0Gl1W`000]l2_`;O0[l2g`002@?o018000?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH20000OP?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0Aoo`03001oogoo
015oo`004Woo00@007ooOomoobEl000:001l2000O18007`L001P7f@O0002?1l0100051lH7`00101O
00<0006O0Il00P6O00<000;O0[l00P:o00<2g`:o000020?o00<000?f0oD00P?e00D3mP?e0oD3m@?f
00<3m@040oH3m@?e0oD200200n`4Ool00`00Oomoo`0AOol0019oo`04001oogooOolUO0001000O0T0
07`B0P0000=P7f@O00000S`O01D001@O61lD7`0005l0O`1O0001O`6O0Gl1W`000]l2_`;O0[l2g`:o
000020?o010000?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP8000220n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3Ool2000COol0019oo`04001oogooOolTO0002P00O0T007`B001l7000I1mP7`000S`O00@0
01PO51l000<0G`030001W`6O0081W`030002g`:o0082_`030]l0000000L3o`8000050oH3m@?e0oD3
mP030oD01P?f0oD3m@?e0oH3m@8008@3k0Aoo`03001oogoo015oo`004Woo00@007ooOomoobAl0004
001l2000O18200000f@OH1l00002?1l04`0061lD7`0005l0O`1O0001O`6O0Gl1W`000]l2_`;O0[l2
g`0000P3o`0?0003m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f008000260n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0Aoo`03001oogoo015oo`004Woo00@007ooOomoob=l0009001l2000O18007`L
001P7`00008l7`04000H7a@O000305l00`000Il1W`020Il00`000]l2_`020[l00`;O0003o`070ol0
0`000oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP000n`0Q`?/17oo00<007ooOol04Goo000BOol0
1000Oomoogoo8g`0010007`9001l4`00O1`006@O000l7`0061lD7`0005l0O`80G`0;0001W`5o0Il0
00;O0[l2g`:o0]l000070ol200003@?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e008000290n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k004Ool00`00Oomoo`0AOol0019oo`04001oogooOolR
O0002@00O0T007`B001l7000I1l00002?1l0100051lD7`000`1O00<0006O0Il00P6O00H000:o0[l2
_`;O00070ol010000oD3m@?f0`?e00D3mP?e0oD3m@?f0083m@8008/3k0Aoo`03001oogoo015oo`00
4Woo00@007ooOomoob9l000?001l2000O18007`K001P7`00>1l001@O61l0001o00<0G`0;0001O`6O
0Gl000:o0]l2_`;O0[l000060ol0W0000oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH000?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0Aoo`03001oogoo015oo`004Woo00@007oo
Oomoob5l0009001l2000O18007`L001P7`00008l7`04000D7a@O000305l01@000Il1W`6O00000`:o
00<2g`:o00001P?o00@000?e0oD3mP<3m@060oH3m@?e0oD3mP?e0P00SP?/0goo0P004goo000BOol0
1000Oomoogoo8G`000h007`9001l4P00O1`006@O000l7`0061lD7`000`1O00/0005o0Il1O`000[l2
g`:o0]l2_`0000H3o`0<0003mP?e0oH3m@?f0oD3mP?e0oH3m@?f0P000903j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`4Ool00`00Oomoo`0AOol0019oo`04001oogoo
OolQO0002P00O0P00000O1`006@O000l7`000Q@O00D0001O05l0G`0000<1W`070002_`:o0[l2g`:o
00001@?o0P000P?e00D3mP?e0oD3m@?f00<3m@030oH000?/0943k0Aoo`03001oogoo015oo`004Woo
00@007ooOomoob1l000>001l2000O18007`K001P7`00?1l001@O61l00080G`090001O`6O0Gl1W`00
0]l2_`;O008000D3o`0<0003m@?f0oD3mP?e0oH3m@?f0oD3mP?e0P0009<3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol04Goo000BOol0
1000Oomoogoo87`000d007`9000007`L001P7`00?1l001@O61l0000205l00`000Il1W`020Il01@00
0[l2_`;O00001P?o00D000?e0oD3m@?f00<3m@030oH3m@?e008009D3k0Aoo`03001oogoo015oo`00
4Woo00@007ooOomooaml0008001l2@00001l6`00H1l0008l7`03000H7`000080G`040001O`6O0Gl2
000010;O0[l2g`001P?o0:<000?e0oH3m@?f0oD3mP?e0oH3m@?f0003k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k004Ool00`00Oomoo`0AOol0
019oo`04001oogooOolOO0003000O0P00000O1`006@O000l7`0061l000<0G`040001W`6O00030[l0
0`;O0003o`050ol01@000oD3m@?e0oH00`?e00@3mP?e000002@3k0T006/3k0Aoo`03001oogoo015o
o`004Woo00@007ooOomooail000H001l2000001l7000I1l003`O>1l001@O0000G`1o0001W`5o0002
_`;O0[l2g`001P?o02L000?e0oH3m@?f0oD3mP?e0oH3m@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`02P000`?R00H3h`?R0n83hP?S0n880000H`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k004Ool00`00Oomoo`0AOol0019oo`04001oogooOolNO0003000O0T00000
O1`0060O000l7`0051l000<0G`040001W`6O00020[l00`;O0[l000050ol01@000oD3m@?e0oH00`?e
00<3mP?e00006@?/10006`?R0P00H@?/0goo0P004goo000BOol01000Oomoogoo7G`001P007`90000
07`K001P7f@O000l7`0061l0001o05l0005o0Il000;O0[l2g`:o00050ol02@000oD3mP?e0oH3m@?f
0oD3mP0200005P?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/10000`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00H3h`?R0n83hP?S
0n820000G`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol04Goo000BOol01000Oomoogoo7G`000`007`80000
07`L001T7`00?1l001@O000205l010000Il1W`000P:o00<2g`:o000010?o0P000`?e00@3mP?e0oD3
m@8001H3k08002L3hP<005`3k0Aoo`03001oogoo015oo`004Woo00@007ooOomooael0003001l2@00
00800004I1l003`O?1l200002`1o05l0005o0Il1O`000[l2g`:o000010?o01l000?f0oD3mP?e0oH3
m@?f0oD000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`0300030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP1M0n<000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo015oo`0027oo1@001Goo00@007ooOomo
oael00<0000:O1`0060O000l7`0051l0001O00030Il01@000[l2g`:o000010?o00<000?f0oD00P?e
00<3mP?e0oD00P004P?/1000;`?R00<000?/0n`0F@?/17oo00<007ooOol04Goo0008Ool01@00Oomo
ogoo00001Goo00@007ooOomooaal0003001l200000800006H1l003`O000D7`000P1O00T0006O0Gl1
W`000]l2_`;O000010?o01X000?e0oH3m@?f0oD3mP000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0P0000D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R05l3h`?R0n83hP00
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
00Aoo`03001oogoo015oo`002Goo00<007ooOol01Woo00@007ooOomooaal00<0000:O1`006@O000l
7`0061l0001O00030Il01@000]l2_`:o000010?o00D000?e0oD3m@?f0083m@030003k0?/00l3k080
03H3hP030003k0?/05P3k0Aoo`03001oogoo015oo`001P0017oo00<007ooOol01Goo0P000Woo6g`0
00D007`9000007`K00800004?1l001PO000205l01P000Gl000000]l2_`8000@3o`0E0003m@?f0oD3
mP?e0oH000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00D00083hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`020n80FP000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0=oo`8001=oo`002goo00<007ooOol017oo
00@007ooOomooa]l0003001l200000800005H1l0000061l0000205l01`000Il000:o0]l2_`0000D3
o`060003m@?e0oD3mP?e0P0030?/0P00?P?R00<000?/0n`0E`?/17oo00<007ooOol04Goo000<Ool0
0`00Oomoo`03Ool01000Oomoogoo6g`00`0000Ul7000000h7`0051l0001O07l00P0000@2_`;O0[l0
00@3o`80000B0oD3mP?e0oH3m@000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0P000`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP1O0n<3hP?R0n83h`000n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k004Ool0
0`00Oomoo`0AOol000Qoo`05001oogooOol00005Ool01000Oomoogoo6W`000<007`900000P0000ET
7`00000D7`000080G`060001W`000]l2_`0010?o00<000?f0oD00P?e00<3mP0000002`?/0P00@`?R
00<000?/0n`0EP?/17oo00<007ooOol04Goo0009Ool30006Ool01000Oomoogoo6W`0100000eT7`00
000D7`0005l0O`000Il000;O0[l000040ol04P000oH3m@?f0oD3mP000n`3j`?/0n/3k0?[0n`3j`?/
0n/3k08000030n83h`?R0083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00`?R05T000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo015oo`004Woo00@007ooOomooaYl
00D0000;?1l001@O0000G`000Il000;O0[l000040ol00`000oH3m@020oD00`?f0003k00:0n`00`00
0n83hP150n800`000n`3k01F0n`4Ool00`00Oomoo`0AOol0019oo`04001oogooOolIO00200001G`B
00000000?1l00P0000L0O`000Il1O`000[l000040ol04@000oH3m@?f0oD3mP000n`3j`?/0n/3k0?[
0n`3j`?/0n/00P000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n80G`?S0n83hP?R0n<3hP000n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol04Goo000BOol01000
Oomoogoo6G`01@0000Pl7`0051l0001O0001W`000P:o00H000?o0ol3o`000oH30oD200090n`20019
0n800`000n`3k01G0n`4Ool00`00Oomoo`0AOol0019oo`04001oogooOolHO00200001G`B00000000
?1l00P0000L0G`000Gl1W`000]l000030ol03`000oH3m@?f0oD000?[0n`3j`?/0n/3k0?[0n`3j`02
00001@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R
0n83hP?S00<3hP050n<3hP?R0n83h`030n80G@?S0n83hP000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k003Ool2000COol0019oo`04001oogooOolH
O00500001C`O0000001O00000P6O00<000:o00000`?o00<000?f0oD00P?e00<000?/0n`01@?/0`00
C@?R00<000?/0n`0E`?/17oo00<007ooOol04Goo000BOol01000Oomoogoo5g`000<007`900001000
00TH7`000001O`6O0002g`:o00000P?o00h000?f0oD3mP?e0003j`?/0n/3k0?[0n`3j`000`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83
h`030n801@?S0n83hP?R0n<00`?R05l3h`?R0n83hP?S0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00Aoo`03001oogoo015oo`004Woo00@007oo
OomooaMl00D00004?1l0000000020Il010000[l2_`000P?o00@000?f0oD3m@8000H3k0800503hP03
0003k0?/05P3k0Aoo`03001oogoo015oo`004Woo00@007ooOomooaIl0003001l200000@0000851l0
00000Il000;O0[l00083o`0;0003mP?e0oH000?/0n/3k0?[0n`3j`0200001@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R
0n83h`030n801@?S0n83hP?R0n<00`?R05d3h`?R0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`017oo00<007ooOol04Goo000BOol01000Oomo
ogoo5W`01P0000DD7`000001W`000082_`050003o`?o0003mP020oD00`000n`3k0030n`2001C0n80
0`000n`3k01H0n`20003Ool00`00Oomoo`0AOol0019oo`04001oogooOolFO00500000a@O61l00002
00000`;O0[l000020ol02`000oH3m@?f0003k0?[0n`3j`?/00000P?R00D3h`?R0n83hP?S00<3hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP1L0n<3hP000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`8000030oIoogoo009oo`03001oogoo015oo`004Woo
00@007ooOomooaEl00H0000751l000000Il000:o00000P?o00D000?f0oD3m@0000D3k0030003hP?R
0183hPD003`3hP030003k0?/05D3k08000<3m@=oo`8001=oo`004Woo00@007ooOomooaEl00800006
O1/0000061l0001o0P0000l2_`000ol3o`000oH3m@?f0003k0?[0n`3j`?/00000P?R00D3h`?R0n83
hP?S00<3hP030n<3hP?R00P000055n0Kh1OP6n0Gh00400001@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`030n801@?S0n83hP?R0n<00P?R05L000?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00P0000D3mP?e0oH3m@?f00Aoo`03001oogoo015oo`004Woo
00@007ooOomooaAl00H0000:51l000000Il000;O0003o`000oH20oD00`000n`3k0020n`2000<0n82
00001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0046n000000000d0n800`000n`3k01C0n`0
0`000oD3mP030oD00`?f0oEoo`03Ool00`00Oomoo`0AOol0019oo`04001oogooOolDO005000041@O
0000006O0002g`000ol000?f0oD3mP000n`3j`?/0P000`?R00D3h`?R0n83hP?S0083hP@0000G5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000020n801@?S0n83hP?R0n<0
0`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP050n<3hP?R0n83h`020n820000D`?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/00`0000P3m@?f0oD3mP?e0oH3m@?f17oo00<007ooOol04Goo000BOol01000
Oomoogoo4g`000<007`800001@000P6O0P0000<3o`000oH00P?e00D000?/0n`3k00000T3hP<00005
6n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0046n0Gh1OP000_0n80
0`000n`3k01A0n`200030oD01@?f0oD3m@?e0oH00`?e17oo00<007ooOol04Goo000BOol01000Oomo
ogoo4g`00`0000=T7`0061l00P0000<1O`000[l00P0000T3mP?e000000?/0n/3k0000n<00`?R00@3
h`?R0n83hP80000O6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP00000`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R
0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80E@?S0n83hP000n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/00<0000=0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH017oo00<007ooOol04Goo000BOol01000Oomoogoo4W`000<007`900001@0000P1W`000[l000?o
0003m@0010?/00<000?R0n801@?R0P000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1A_P5n0Gh1OP6n000aOP00LKh1OP5n0Gh1_P5n00000]0n800`000n`3k01<0n`300020oD01@?f0oD3
m@?e0oH00`?e00H3mP?e0oD3m@?f0oD4Ool00`00Oomoo`0AOol0019oo`04001oogooOolBO0030000
160O0000001O0P0000`2_`000ol000?e0003j`?/0n/3k0000n<30n80:@?S0n8000006n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h0000n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3
h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80H`000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0003mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP04Ool00`00Oomo
o`0AOol0019oo`04001oogooOolBO008000010:o0003o`000P?e00D000?/0n`3k00000@3hP<00003
5n0Kh1OP008Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh005
6n0Gh1OP5n0Kh0035n000a_P0003hP0Y0n800`000n`3k0190n`400001@?f0oD3m@?e0oH00`?e00D3
mP?e0oD3m@?f00<3m@040oH3m@?e0oD3Ool2000COol0019oo`04001oogooOolBO00200000f@O0000
000200002@:o0003o`000oD3mP000n`3j`020000<@?S0n83hP?R000Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP0003hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP050n<3hP?R0n83h`030n80C`?S0n83hP?R0003j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080
000H0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f17oo00<007oo
Ool04Goo000BOol01000Oomoogoo4G`01P0000<1W`000[l00P000P?e00@000?/000000@3hP8000<G
h0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n001A_P5n0Gh1OP6n000QOP00<000?R0n809@?R0P00B0?/0`0000D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00<3mP?eOol00goo00<007ooOol04Goo000BOol0
1000Oomoogoo4G`00P0000=P7`0000000P0000P2g`000003m@?f0003k0000P?R0343h`?R000001_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S
00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R04`3h`?R0n8000?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`80000M0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP04Ool00`00Oomoo`0AOol0019oo`04001oogooOol@O007000010:o000000?e
0P0000<3k0000n800P?R0P0000<Gh1_P5n000QOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh003
5n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000a_P0003hP0T
0n800`000n`3k0150n`200030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD010?f0oD3m@?e17oo00<007ooOol04Goo000BOol01000Oomoogoo47`01P0000P2g`00
0003m@000n/3k0000P?R03D3h`006n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP0003
hP?S00<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3
hP?R0n83h`020n80A`000n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00P000243mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH017oo00<007ooOol0
4Goo000BOol01000Oomoogoo3g`0200000<3o`0000000P?/00D000?R0n83hP00008Gh0066n0Gh1OP
5n0Kh1OP2`000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP
00<Kh1OP00008`?R0P00A0?/0`0000<3m@?f0oD00P?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00H3mP?e0oD3m@?f0oD4Ool00`00Oomoo`0AOol0019oo`04001o
ogooOol?O00600001`:o000000?f0003k0000083hP090n<001_P5n0Kh1OP6n0Gh1_P00800005>n0o
h3oP?n0kh003?n000c_P?n0oh00200007A_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0G
h1_P5n0Kh1OP6n0Gh1_P5n0Kh0000n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80
1@?S0n83hP?R0n<00`?R04/3h`?R0n83hP?S0n8000?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00P0002H3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0goo0P004goo000BOol01000Oomoogoo3W`02@0000@3m@000n`00083hP80008Gh003
6n0Gh1OP00<000loh004000Gh1OP6n035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh004
6n0Gh1OP000R0n800`000n`3k0100n`300001@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@Aoo`03001oogoo015o
o`004Woo00@007ooOomoo`il00P000040oH000?/00020n801P005n0Kh1OP6n0Gh08000<oh005>n0o
h3oP?n0kh003?n001C_P?n0oh3oP>n000coP01X001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0K
h1OP6n0Gh1_P5n0Kh1OP6n0Gh0000`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S0080000o0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[00@0000[0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH017oo00<007ooOol04Goo000BOol01000Oomoogoo3W`01`0000@3m@000n`00083hP05
000Gh1OP5n0Kh002000E?n001@005n0Gh1OP6n000aOP00DKh1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0K
h0035n000`000n83hP0M0n82000o0n`200000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@03
0oH3mGoo00=oo`03001oogoo015oo`004Woo00@007ooOomoo`el00H000060ol000000n`000?R0P00
00<Gh1_P5n000P0000<oh3_P?n000SoP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP?n0kh003?n006c_P
?n0001_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000020n801@?S
0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`030n80@`?S0n83hP?R0003j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
00<0000a0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH017oo00<007ooOol04Goo
0009Ool50004Ool01000Oomoogoo3G`02P0000<3hP006n000QOP0P006SoP00<001_P5n000QOP00DK
h1OP5n0Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n02000M0n82000m0n`200001@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD010?f0oD3m@?e17oo00<007ooOol04Goo000;Ool00`00Oomoo`04
Ool01000Oomoogoo37`02@000P?R00<001_P5n000P000coP00Dkh3oP?n0oh3_P00<oh005>n0oh3oP
?n0kh003?n001C_P?n0oh3oP>n000coP01Hkh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0000<3hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3
hP0o0n<3hP?R0003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/00@0000f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f17oo00<007ooOol04Goo000;Ool00`00Oomoo`04Ool01000Oomoogoo37`020000P?R00@001_P
000000Doh0L0018oh004000Gh1OP6n035n001A_P5n0Gh1OP6n000aOP00DKh1OP5n0Gh00001h3hP03
0003k0?/03L3k0<000050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3
m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD00`?f0oEoo`03Ool00`00Oomoo`0AOol000H000Eoo`03001oogoo00Aoo`80009oo`]l0080
0003H1l0000000H000046n0003oP>n02?n03000026?PIn1Sh6OPHn1Wh6?P0002?n001C_P?n0oh3oP
>n000coP00Dkh3oP?n0oh3_P008oh00D000Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP
6n000083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP0l0n<3
hP000003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0P00
03d3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP03Ool2000COol000]oo`03001oogoo00Aoo`04001oogooOol;O00900000aOP6n000003?n02
000036?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn0000loh003000Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n00
1Q_P5n0Gh1OP6n0001/3hP8003L3k0<000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD010?f0oD3m@?e17oo00<007ooOol04Goo000;Ool00`00Oomoo`04
Ool01000Oomoogoo2W`00P0000=T7`000000100000DGh1_P000oh3_P0080000?In1Sh6OPHn1Wh6?P
In1Sh6OPHn1Wh6?PIn1Sh000008oh005>n0oh3oP?n0kh003?n005c_P?n0oh3oP000Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P00000P?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`03
0n801@?S0n83hP?R0n<00`?R0P0003D3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/00@000120oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f17oo00<007ooOol04Goo0009Ool30006Ool01000Oomo
ogoo2W`02@0001LKh000?n0oh000Hn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn1Sh00000do
h005000Gh1OP5n0Kh0035n001A_P5n0Gh1OP6n000aOP00<Kh0000n806@?R00<000?/0n`0<`?/0P00
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01P?f0oD3m@?e0oH3m@Aoo`03001oogoo015oo`002goo00<007ooOol017oo00@007oo
Oomoo`Yl00X00006?n000000Hn1Wh6?P0`0000eSh6OPHn1Wh6?PIn1Sh6OPHn1Wh6?PIn000003?n00
1C_P?n0oh3oP>n000coP01<kh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000020n80
1@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP050n<3hP?R0n83h`020n820000<P?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`40000B0?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mPAoo`03001oogoo015oo`004Woo00@007ooOomoo`Ul00T00005?n000000In1Sh0030003Oh020000
2fOPHn1Wh6?PIn1Sh6OPHn1Wh6?P000033oP00@001OP5n0Kh0<Gh0056n0Gh1OP5n0Kh0035n000a_P
0003hP0G0n82000a0n`300001@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3
mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3
m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD010?f0oD3m@?e17oo00<007oo
Ool04Goo000BOol01000Oomoogoo27`02@0000@oh000Hn1Wh080000EOf1oP7mPOh1oH7n0Of1oP000
In1Sh6OPHn1Wh6?PIn1Sh6OP000oh3_P00<oh00E>n0oh3oP?n0kh3oP000Kh1OP6n0Gh1_P5n0Kh1OP
6n0Gh1_P5n0Kh1OP00800083hP050n<3hP?R0n83h`030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S0080000a0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/00P0004l3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP04Ool00`00Oomoo`0AOol0019oo`04001oogoo
Ool7O00;00000f?P0000000;Oh002P00In1Sh6OPHn1Wh6?PIn1Sh0002SoP00@001OP5n0Kh0<Gh005
6n0Gh1OP5n0Kh0035n000`000n83hP0D0n83000^0n`500030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01P?f0oD3m@?e0oH3m@=oo`8001=oo`004Woo00@007ooOomoo`Ml00T0000JIn1Sh000Of1oP7mP
Oh1oH7n0Of1oP7mPOh1oH7n0Of0006?PIn1Sh6OPHn1Wh6?PIn0000<oh005>n0oh3oP?n0kh002?n00
3`005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83
hP?S00<3hP0c0n<3hP000003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0080001F0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mPAoo`03001oogoo
015oo`004Woo00@007ooOomoo`Ml00L00003?n0006?P00@000]oP009001Wh6?PIn1Sh6OPHn1Wh000
00Xoh003000Gh1_P00<Gh0056n0Gh1OP5n0Kh0035n000`000n83hP0C0n800`000n`3k00]0n`20000
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@Aoo`03
001oogoo015oo`004Woo00@007ooOomoo`Il00L00003?n0000000080009n@00EOV000000001oP7mP
Oh1oH7n0Of1oP7mP001Sh6OPHn1Wh6?PIn1Sh000008oh005>n0oh3oP?n0kh002?n003`005n0Kh1OP
6n0Gh1_P5n0Kh1OP6n0Gh1_P5n0000030n801@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP0_
0n<000000n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0040000FP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mPAoo`03001oogoo015oo`004Woo
00@007ooOomoo`Il00/000Mn@08000IoP008001Wh6?PIn1Sh6OPHn0000Toh003000Gh1_P00<Gh005
6n0Gh1OP5n0Kh0025n02000D0n800`000n`3k00W0n`500001@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@060oH3m@?e0oD3mP?e17oo00<007ooOol04Goo
000BOol01000Oomoogoo1W`02@000gi000EnH7i0OT1n@7iP00=n@00@001oH7n0Of1oP7mP001Sh6OP
Hn1Wh6?PIn0003oP>n03?n004S_P?n0oh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0Gh1_P0003h`<3hP05
0n<3hP?R0n83h`030n801@?S0n83hP?R0n<00P?R0`0002L3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`00`0006<3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH017oo00<007ooOol04Goo000BOol01000Oomoogoo1W`01P0000=oP000
000010001gi000<007n0Oh000gn000P006OPHn1Wh6?PIn1Sh0001coP00<001OP6n000aOP00DKh1OP
5n0Gh1_P008Gh0030003hP?R0103hP8002P3k0800083m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@040oH3m@?e0oD4Ool0
0`00Oomoo`0AOol0019oo`04001oogooOol6O0000`000oD0000500001gdPO@1m87d0OB0007iP00=n
@00@OV1n@000Of1oP7mPOh0006OPHn1Wh6?PIn1Sh000>n03?n003c_P?n0oh0005n0Kh1OP6n0Gh1_P
5n0Kh1OP6n0Gh00200001@?S0n83hP?R0n<00`?R00D3h`?R0n83hP?S00<3hP0Y0n<000000n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0040000J0?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH4Ool00`00Oomoo`0AOol0
019oo`04001oogooOol5O00:00001GdPO@1m87d000001Gi000<007n0Oh000gn000P006?PIn1Sh6OP
Hn1Wh0001SoP00<001OP6n000aOP00DKh1OP5n0Gh1_P00800143hP8002@3k0@00083m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD00`?f0oEoo`02Ool2000COol0019oo`04001oogooOol5O0000`00
0oH000050002O00200001Wd0OB1m0000OT1nH09n@00;001oP7mPOh1oH000Hn1Wh6?PIn1Sh0020003
?n003c_P?n0oh0005n0Kh1OP6n0Gh1_P5n0Kh1OP6n0000020n801@?S0n83hP?R0n<00`?R00H3h`?R
0n83hP?S0n8300008P?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3
k0?[0n`3j`?/0n/3k0?[0n`3j`?/10000703m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mPAoo`03001oogoo015oo`004Woo00@007ooOomoo`El00<00003OT00000000Il0080
0003OB1m000000=n@003001oP7n0009oP006001Wh6?PIn1Sh0001SoP0P0000<Gh1_P5n000QOP00@K
h1OP5n0Gh08000l3hP800203k0D000050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00@3mP?e0oD3m@Aoo`03001oogoo015oo`004Woo00@007ooOomoo`El00800003OT000000
00Ql0004001m07dP0002OT0037iP001oP7mPOh0006OPHn1Wh6?P000kh0<oh00<>n0oh0006n0Gh1_P
5n0Kh1OP6n0Gh1_P0P000`?R00D3h`?R0n83hP?S00<3hP040n<3hP?R0n8200007P?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`@0001i0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH017oo
00<007ooOol04Goo000BOol01000Oomoogoo1G`000@007i0000000Ql0005001m07dPO@000002OT00
2P00Oh1oP7n0001Wh6?PIn1Sh0001CoP0P000QOP00HKh1OP5n0Gh1_P5n02000?0n82000N0n`20003
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e
0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD00`?f0oEoo`03Ool00`00Oomoo`0AOol0019oo`04001oogooOol4O003000:O0003P00OB1m0000
OT1nH7i0001oH7n0001Wh6?PIn0200003S_P?n0oh3oP>n0001OP6n0Gh1_P5n0Kh1OP6n0200000`?R
0n<3hP020n801@?S0n83hP?R0n<00`?R100001`3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3
j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`@0001h0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e20000goo00<007ooOol04Goo000BOol01000Oomo
ogoo17`00P002g`000@007d0OB00009n@008001oP7n0001Wh6?PIn0000Hoh005000Gh1OP5n0Kh002
5n03000<0n83000K0n`500030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f
0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e
00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@T000L3o`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Al008000]l000?001m8000OV1n
@000Of1oP000In1Sh6OP000oh3_P00<oh08000055n0Kh1OP6n0Gh00200001@?S0n83hP?R0n<00`?R
00D3h`?R0n83hP?S0080000J0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0@0001_0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e00T0
0103o`=oo`8001=oo`004Woo00@007ooOomoo`Al008000Yl0003001m8000009n@009001oP7n0Oh00
06?PIn1Sh00000<oh08000056n0Gh1OP5n0Kh002000<0n83000H0n`400020oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
0`?f0oD3m@0>000I0ol4Ool00`00Oomoo`0AOol0019oo`04001oogooOol4O002000:O002000037iP
OT1n@000Oh1oH000Hn1Wh6?P000kh08oh006000Gh1_P5n0Kh1OP0P000P?R00D3h`?R0n83hP?S00<3
hP0J0n<3hP000003k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`D0001P
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f2@009`?o17oo00<007ooOol04Goo000BOol01000Oomoogoo17`000<007`0O000
27`000<007d000000Wi000H007n0000006?PIn020002?n0200000aOP6n0Gh0025n000`000n83hP09
0n83000D0n`400000`?e0oH3m@020oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3
m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD0
1@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f0083m@T00303o`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Al0003
001l07`000Ql00800007OT000000Oh0006OPHn000P0000Poh3_P?n0001_P5n0Kh1OP0`000`?R00D3
h`?R0n83hP?S00@0000B0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/0n/3k0?[0n`3j`?/1@0005L3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e
0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH02@00>@?o17oo
00<007ooOol04Goo000BOol01000Oomoogoo17`000<007`0O0001g`00P0000=n@000Oh000P0000=W
h6?P00000coP0P000QOP0`002@?R0P004@?/1@0000D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e
0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00H3mP?e
0oD3m@?f0oD>00120ol4Ool00`00Oomoo`0AOol0019oo`04001oogooOol3O0020009O003000017mP
001Sh6OP0P000SoP0P0000@Gh1_P000000<3hP050n<3hP?R0n83h`0400003`?[0n`3j`?/0n/3k0?[
0n`3j`?/0n/3k0?[0n`3j`040000BP?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f
0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD9001@0ol4Ool0
0`00Oomoo`0AOol0019oo`04001oogooOol3O0020007O006000016?P000003oP0`0000@Kh1OP0000
00H3hP@000h3k0D000<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f
00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e
0oD3mP030oD01@?f0oD3m@?e0oH03P00F@?o17oo00<007ooOol04Goo000BOol01000Oomoogoo0g`0
0P001W`01@0000=Wh00000000`0000<Kh1OP00000P0000@3hP?S0n83hP@0000<0n/3k0?[0n`3j`?/
0n/3k0?[0n`3j`?/1P0003X3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP/006L3o`=oo`8001=oo`004Woo00D007ooOomoog`000@000El00<00003Oh00
000000<000036n0Gh1OP008000D3hP8000d3k0<000050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH0
0`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3
m@?f00<3m@040oH3m@?e0oD<001b0ol4Ool00`00Oomoo`0AOol0019oo`04001oogooOol300000gd0
001l0003O00200000gmP0000000300000aOP6n0Gh002000010?S0n83hP?R0`0000H3j`?/0n/3k0?[
0n`90000:@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3
mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH03P00OP?o17oo00<007ooOol04Goo000BOol01000
Oomoogoo0P0000Am07dPO@00009l00L000035n000000008000030n80000000<000@3k0D00083m@05
0oH3m@?e0oD3mP030oD01@?f0oD3m@?e0oH00`?e00D3mP?e0oD3m@?f00<3m@050oH3m@?e0oD3mP03
0oD00`?f0oD0000=002<0ol4Ool00`00Oomoo`0AOol000Uoo`@000Eoo`04001oogooOol2O0020000
0gdP0000000>00001@?[0n`3j`?/0n/0100001`3mP?e0oH3m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3
m@?f0oD3mP?e0oH3m@?f0oD3mP?e0oH3m@d009X3o`Aoo`03001oogoo015oo`0027oo00<007ooOol0
0Woo00<007ooOol00Woo00@007ooOomoo`Al01H000030oD3mP?e0083m@050oH3m@?e0oD3mP030oDC
002W0ol4Ool00`00Oomoo`0AOol000Qoo`03001oogoo009oo`03001oogoo009oo`04001oogooOol2
O00>00001@?f0oD3mP?e0oH04P00^P?o17oo00<007ooOol04Goo0008Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool20002OolE003<0ol3Ool2000COol000Qoo`03001oogoo009oo`03001oogoo009oo`05
001oogooOoml000M00330ol4Ool00`00Oomoo`0AOol000Qoo`03001oogoo009oo`03001oogoo009o
o`04001oogooOol3O00300000a@O61l0000;00030[l01@;O0[l2_`:o0]l00P:o4P00/@?o17oo00<0
07ooOol04Goo0008Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoogoo1G`05@0001H2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`h00:<3o`Aoo`03001oogoo015o
o`002Goo10001Goo00@007ooOomoo`Il00`00080G`8000@1W`T00082_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]l0000000`009D3o`Aoo`03001oogoo015o
o`004Woo00D007ooOomoo`0000Ml00L00003>1l0000000<0000305l00000008000090Il1O`6O0Gl1
W`5o0Il1O`6O00@0000U0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l03P00Q`?o17oo00<007ooOol04Goo000BOol01@00
OomoogooO0000P001W`0200000@l7`00000D7`@0000305l0000000<000P1W`D000<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00<2g`:o0[l03P00N@?o17oo00<007ooOol04Goo000BOol01000Oomoogoo0g`0
0P001W`01@0000AT7`00?1ll7`80000361lD7aPO008000<0G`0307l00000008000090Gl1W`5o0Il1
O`6O0Gl1W`5o00H0000f0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o3@00K0?o17oo00<007ooOol04Goo000BOol01000Oomoogoo0g`00P001g`000<007`900001000
0c`O0P0000<D7aPO51l00`001@1O10002`6O20000`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`T006<3o`=oo`8001=oo`004Woo00@007ooOomoo`=l0080
00Ql00800003O18007`K00<0008l7`07>1l0000061lD7aPO51l00P0000D0O`1O05l0G`1o0080G`80
000A0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`040000@0;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o3P00E@?o17oo
00<007ooOol04Goo000BOol01000Oomoogoo17`000<007`0O0001g`00`000W`L00@0060O000000<l
7`8000<D7`0361l0000000L0G`<00181W`D000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`030]l00000
00L004`3o`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Al0003001l07`000Ml00800007O180
07`LO1/0060OI1l00P0000Th7c`O?1l001@O61lD7aPO51l00P000P1O00H0O`1O05l0G`1o05l30000
505o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il30000C`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O00h003h3o`Aoo`03001oogoo015oo`004Woo00@007ooOomo
o`Al0003001l07`000Ql00800004O1800000O1`200000f@OH1l00003?1l2000251l00aPO51lD7`03
000805l3000D0Il600000`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00<2g`:o00002000=@?o17oo00<007ooOol04Goo000BOol01000Oomoogoo17`000<007`0
O00027`000<007`900000W`B00H007`KO1`006@OH1l20003?1l200001Q@O61lD7aPO51lH7`8000<0
G`0607l0G`1O05l0O`1O100001H1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`D0001K0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l02@00;0?o17oo00<007ooOol04Goo000BOol01000Oomoogoo17`00P002W`000<0
07`900000W`B00P007`LO1`006@OH1mT7`0013`O0P0000HH7a@O51lD7aPO51l2000;05l3000H0Il3
00030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`060]l2_`:o0[l2g`:o3P007P?o17oo00<007ooOol04Goo000BOol01000Oomoogoo17`00P002W`0
00@007`8O0T0009l4P08001l6g`L001T7f0OI1l000<l7`0:>1ll7`00000D7aPO51lH7a@O61l20000
0`1O07l0G`0205l01@1o05l0G`1O07l00P1O0P0001T1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`020000K@;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O00T001D3o`=oo`8001=oo`004Woo00@007ooOomoo`Al008000]l0004001l27`90002O180
2000O1al7000I1mP7f@O0006?1l01@0051lD7a@O61l00a@O00<0001O05l02`1O0`00606O1@000P:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`020[l:000;0ol4Ool00`00Oomo
o`0AOol0019oo`04001oogooOol4O003000:O0001000O0Ul20000W`B00T007`LO1]l7000I1mP7f@O
00000c`O00/h7c`O?1l001@O61lD7aPO51lH7a@O0080000507l0G`1O05l0O`0305l01P1o05l0G`1O
07l0G`80000K0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O00<0001h0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o2@000P?o17oo00<007ooOol04Goo000BOol01000Oomoogoo1G`000<007`B00002G`0
00@007`8O0T0009l4P03001l77`L009l7005001T7f0OI1l00006?1l01@0051lD7a@O61l00a@O00<H
7`0000003P1O0P00706O1@0000D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2_`<000=oo`03001oogoo015oo`004Woo00@007ooOomo
o`El00@000Ul000@001l27`9001l4g`B001l6g`LO1]l7000I1mP7f@O0003?1l03CPO?1ll7`0051lH
7a@O61lD7aPO51lH7a@O00800080G`0507l0G`1O05l0O`0305l0101o05l0G`1O0P0001l1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`050000
N@;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O00Aoo`03001oogoo015oo`004Woo00@007ooOomoo`El00800003O180000000Ql0004001l2G`8
0002O1800`00O1al7002O1`01P00H1mT7f0OI1l000Hl7`80008D7`0561lD7a@O51lH7`0251l2000>
05l3000Q0Il300020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`04
0]l2_`:o0[l4Ool00`00Oomoo`0AOol0019oo`04001oogooOol5O0060006O00200000g`8O0T00002
O1802g`C001l77`KO1al6`00H1mT7f0OI1l00P000S`O018h7c`O?1ll7`0061lD7aPO51lH7a@O61lD
7aPO51l0001O07l305l01@1o05l0G`1O07l00`1O00<0O`1O05l00P000281O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`D0001a0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`04Ool00`00Oomoo`0AOol0
019oo`04001oogooOol5O0080002O002000017`9O0Ql2@0017`B00<007`LO1`00W`L00P006@OH1mT
7f0OI1mP7`001S`O00@001@O51lH7`<D7`0561lD7a@O51l0000A05l2000U0Il200000`:o0]l2_`02
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`:oOol00goo00<007ooOol04Goo000BOol0
1000Oomoogoo1W`000<000:o00001P0000Ql27`9O0Ql2G`8001l4W`C0W`B00h007`LO1]l77`KO1`0
06@OH1mT7f0OI1mP7`000S`O00lh7c`O?1ll7`0061lD7aPO51lH7a@O61lD7aPO51l00P0000D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l0:01o0000005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0`0006`2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l3Ool2000COol0019oo`04001oogooOol6O0060000
27`L001l27`9O0Ql2G`80006O1800`00O1al7002O1`02000H1mT7f0OI1mP7f@O0007?1l200000a@O
61lD7`0251l01APO51lD7a@O61l00P004@1O1000906O1@000`:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l0
0`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o0[l2
_`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Il008000030]l0000000800003O1/0000000<0
0003O19l4g`B009l4P0@O1=l4P00O1]l77`KO1al6`00H1mT7f0OI1mP7f@O0003?1l04CPO?1ll7c`O
>1l001@O61lD7aPO51lH7a@O61lD7aPO51l00P000P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l0:P1o0000005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`<0001T0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l4Ool0
0`00Oomoo`0AOol0019oo`04001oogooOol6O00800000g`L001l4P08O1800`00O1al7004O1`02000
I1mP7f@OH1mT7f0O0009?1l00`0051lH7`0351l01APO51lD7a@O61l00Q@O00<0001O05l04P1O0P00
:06O0P0000D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`05
0]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00<2g`:oOol00goo00<007ooOol04Goo000BOol01000Oomoogoo1W`0
2@0000Al6`00001l4`=l4P0DO1=l4P00O1]l77`KO1al6g`LO1/0060OI1mP7f@OH1mT7f0O000h7`<l
7`0C>1ll7c`O?1lh7`0051lH7a@O61lD7aPO51lH7a@O61lD7aPO00000P1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l00`1o05l0G`020000:05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O100005h2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Ml00T0009l70H000Ql7009001T7f0OI1mP
7f@OH1mT7`0000Xl7`03000D7aPO00<D7`0561lD7a@O51lH7`0251l00`0005l0G`0D05l2000Z0Il5
00000`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00@2g`:o
0[l2_`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Ml00/0000JO1al6g`LO1]l77`KO1al6g`L
O1]l77`KO1al6`00H1mT7f0OI1mP7f@OH1mT7`00?1lh7`<l7`0B>1ll7c`O?1l001PO51lH7a@O61lD
7aPO51lH7a@O61lD7aPO0P0000<0G`1o05l00P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l0<01o0000005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`<0001F0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`Aoo`03001oogoo015oo`004Woo00@0
07ooOomoo`Ml00X00003I1l0000000al700:001T7f0OI1mP7f@OH1mT7f0O000:?1l0100051lD7aPO
0a@O00DH7a@O51lD7aPO00<D7`030000G`1O01D0G`030001W`6O02d1W`800082_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[moo`02Ool2000COol0019oo`04001oogoo
Ool8O00:000036@OH1l00000O1al6g`LO1]l77`KO1al6`80000:I1mP7f@OH1mT7f0OI1mP7f@O0003
?1l01CPO?1ll7c`O>1l00c`O018001PO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0001O07l305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0c07l0G`000001W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O00@0001@0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Ul00X00003I1mP7f@O00@000=l700=001P7f@O
H1mT7f0OI1mP7f@OH1mT7f0O00002c`O00D001@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00`00
05l0G`0F05l2000a0Il300000`:o0]l2_`020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l4Ool00`00
Oomoo`0AOol0019oo`04001oogooOol9O009000023`O0000060OI1mP7f@OH1l300003f0OI1mP7f@O
H1mT7f0OI1mP7f@OH1mT7`00?1lh7`03?1l01CPO?1ll7c`O>1l00S`O01<001@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7`0005l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0h
07l0G`1O05l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`80001;0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O00Aoo`03001oogoo015oo`004Woo00@007ooOomoo`Yl
00T0008l7`80000CI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0O000033`O00<001PO
51l00Q@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51l0000I05l2000c0Il300020[l01@;O0[l2_`:o
0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o
0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`06
0]l2_`:o0[l2g`:o17oo00<007ooOol04Goo0009Ool50004Ool01000Oomoogoo2W`02`0001Dh7c`O
0000060OI1mP7f@OH1mT7f0OI1mP7f@OH1mT7f0OI1mP7f@O00000c`O00Dh7c`O?1ll7cPO00<l7`0F
>1ll7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0001O07l305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`020000=05o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O1@0004<2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`04Ool00`00Oomoo`0AOol000]o
o`03001oogoo00Aoo`04001oogooOol;O00900000a@O00000002?1l2000036@OH1mT7f0OI1mP7f@O
H1mT7f0OI1mP7`8000hl7`03000D7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O00006`1O
0P00=`6O0P0000<2_`;O0[l00P:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`040]l2_`:o0[l4Ool00`00Oomoo`0AOol000]oo`03001oogoo00Aoo`04001o
ogooOol;O00800001@1O000001PO00000c`O0`0000YT7f0OI1mP7f@OH1mT7f0O000h7`<l7`05>1ll
7c`O?1lh7`03?1l06SPO?1ll7c`O000H7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0
001O07l305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0205l20000
=`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o00<0000n0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`Aoo`03001oogoo015oo`002goo00<007ooOol017oo0P000Woo37`020000P1O00@001PO000000@l
7`P0018l7`04000D7a@O61l351l01APO51lD7a@O61l00a@O00DH7a@O51lD7`0001d0G`8003P1W`@0
00050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2
g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[mo
o`02Ool2000COol000]oo`03001oogoo00Aoo`04001oogooOol<O00900001P1O07l001PO51l0008l
7`05>1ll7c`O?1lh7`03?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`0J>1ll7c`O000D
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`0005l0O`<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0m07l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00P0003P2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O17oo00<007ooOol04Goo000;Ool00`00
Oomoo`04Ool01000Oomoogoo3G`01P0000P2_`000000G`0051lH7a@O0P006c`O00<001PO51l00Q@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00`0005l0G`0L05l2000k0Il200020[l01@;O
0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l010;O0[l2_`:o17oo00<007ooOol04Goo0009
Ool30006Ool01000Oomoogoo3G`01`0000@2g`000000G`80000661lD7aPO000l7cPO0c`O00Dh7c`O
?1ll7cPO00<l7`05>1ll7c`O?1lh7`03?1l07SPO?1ll7c`O>1l001@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7`0005l0O`<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0o07l0G`000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0080000d0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l4Ool00`00Oomoo`0AOol000]oo`03001oogoo00Aoo`04001oogooOol>
O0080000106O0000G`1O0P000Q@O0P005c`O00D001@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00<0001O05l07@1O0P00?06O10000P:o00D2g`:o0[l2_`;O00<2_`050]l2
_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l0
1P;O0[l2_`:o0]l2_`Aoo`03001oogoo015oo`004Woo00@007ooOomoo`il00@0000@0n`000000[l0
005o0000G`1o05l001@O61lD7`00>1l3?1l01CPO?1ll7c`O>1l00c`O00Dh7c`O?1ll7cPO00<l7`0K
>1ll7`0061lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`000080G`05
07l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`02
05l0@0000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0`0002d2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l017oo00<007ooOol0
4Goo000BOol01000Oomoogoo3W`0200000@2_`000Il00080G`03000H7a@O008D7`<001<l7`03000D
7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00@H7a@O51l00240G`800401W`80
00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`050]l2_`:o
0[l2g`030[l01@;O0[l2_`:o0]l00`:o17oo00<007ooOol04Goo000BOol01000Oomoogoo3g`02000
00<2_`000Gl00P0000P0O`0061lD7aPO51lH7a@O0`0000Dh7c`O?1ll7cPO00<l7`06>1ll7c`O?1lh
7c`O0P0001XD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`00
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`120001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0`0002P2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`=oo`8001=oo`004Woo
00@007ooOomoo`ml00T000060[l0006O0Il0001O0P000a@O00@H7a@O51lD7`D000Pl7`04000D7a@O
61l351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0761lD7a@O51lH7a@O00008`1O00<0
006O0Il0@@6O0P0000D2g`:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o
00D2g`:o0[l2_`;O00<2_`060]l2_`:o0[l2g`:o17oo00<007ooOol04Goo000BOol01000Oomoogoo
47`01P0001H3mP000002_`000Gl1W`0007l0G`0051lH7a@O61lD7aPO51lH7a@O61lD7`P0000O61lD
7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7`0007l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`150001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00@0000R0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l4Ool00`00Oomoo`0AOol0019o
o`04001oogooOol@O00700001@?e000000:o00000P6O00<0001O05l00P000Q@O00DH7a@O51lD7aPO
00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O
51lH7`0351l01QPO51lD7a@O61l002@0G`8004H1W`<000<2_`050]l2_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2_`:o0[l4Ool00`00Oomoo`0AOol0019oo`04001o
ogooOol@O00800002@?f000000:o0001O`6O0000O`0205l20000<1@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO
51lH7a@O61lD7`0005l0O`<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l0BP1o0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl200007@;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l017oo
00<007ooOol04Goo000BOol01000Oomoogoo4G`00P0000EWh000000000?/008000040ol000:o0002
0Il00`0005l0G`0205l00`0051lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`05
61lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00DH7a@O51lD7aPO008D7`030000G`1O02D0G`03
0001W`6O04L1W`<000050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2
_`030]l2_goo00=oo`03001oogoo015oo`004Woo00@007ooOomooa5l00P0000:0oD000?o0002_`00
0Gl1W`0007l305l20000:aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7`0000<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0D@1o05l0G`1O
07l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02000060:o0]l2_`;O0[l2g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`Aoo`03001oogoo015oo`004Woo00@007ooOomooa9l
00800004Hn0000000n8300020ol00`000[l000020Il2000405l2000351l01APO51lD7a@O61l00a@O
00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l01APO51lD7a@O61l00a@O00HH7a@O51lD7aPO
000Y05l00`000Il1W`1:0Il200020[l01@;O0[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`040]l2
_`:o0[l4Ool00`00Oomoo`0AOol0019oo`04001oogooOolBO00800002`?f000000000]l2_`000Gl1
W`5o00000`1O02d0O`1O000D7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0001O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1C07l0G`1O05l0
O`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`02000050:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l3Ool2000COol0019oo`04001oogooOolBO00300000fOP0000
000300001`?f0oD000000]l2_`0000<1W`030000G`1O00<0G`80008D7`0561lD7a@O51lH7`0351l0
1APO51lD7a@O61l00a@O00DH7a@O51lD7aPO00<D7`0561lD7a@O51lH7`0351l00aPO51l0000/05l0
0`000Il1W`1<0Il300030[l01@;O0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O0[l4Ool00`00Oomoo`0A
Ool0019oo`04001oogooOolCO00700003@?/0003mP000ol000;O0[l0005o0Il1O`0000<0G`0307l0
G`1O00@0000R51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH
7a@O61lD7aPO51lH7`0007l305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1B07l0006O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl200003`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2
g`04Ool00`00Oomoo`0AOol0019oo`04001oogooOolCO00300000f?P000Gh00200002@?/0003mP00
0ol000;O0[l000030Il2000805l300000a@O61lD7`0251l01APO51lD7a@O61l00a@O00DH7a@O51lD
7aPO00<D7`0561lD7a@O51lH7`0251l00`0005l0G`0]05l00`000Il1W`1?0Il200000`:o0]l2_`02
0[l01@;O0[l2_`:o0]l00`:o17oo00<007ooOol04Goo000BOol01000Oomoogoo57`01`0000@3j`?/
00000083o`090002g`:o0001O`6O0Gl1W`000080G`0507l0G`1O05l0O`0305l200006aPO51lH7a@O
61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51lH7a@O61lD7aPO51l0000305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`1H07l0G`1O05l0O`000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl200002`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l017oo00<007ooOol04Goo000BOol01000
Oomoogoo57`01@0000<Gh00000000P0000P3m@000ol000:o0]l2_`00106O00<0001O05l02@1O1000
00<D7aPO51l00Q@O00DH7a@O51lD7aPO00<D7`0661lD7a@O51lH7a@O0`00<P1O00<0006O0Il0D@6O
0`000P:o00H2g`:o0[l2_`;O0[l4Ool00`00Oomoo`0AOol0019oo`04001oogooOolEO00500000a_P
0003hP02000030?e0003o`000[l2g`:o0001O`6O0Gl1W`80000305l0O`1O0080G`0507l0G`1O05l0
O`0305l400003APO51lH7a@O61lD7aPO51lH7a@O61lD7aPO0080000305l0O`1O0080G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1G07l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O008000060[l2g`:o0]l2_`;O17oo00<007ooOol04Goo000B
Ool01000Oomoogoo5G`00P0000=oP00000000P0000L3hP000n`000?e0003o`0200000`;O0[l00005
0Il2000?05l=000h05l00`000Il1W`1E0Il300030[l3Ool2000COol0019oo`04001oogooOolFO005
00000aOP0003hP0200000`?f0oD000020ol030000]l2_`000Gl1W`5o0Il1O`6O0000O`<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0
1@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l0FP000Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`8000030]moogoo009oo`03001oogoo
015oo`004Woo00@007ooOomooaIl00H000055n0000000n`000020oD01P000ol3o`000]l2_`8000D1
W`8005<0G`030001W`6O05P1W`8000=oo`03001oogoo015oo`004Woo00@007ooOomooaIl00@0000;
In0000000003h`000n`000?f0oD000020ol02`000]l2_`;O0001W`5o0Il1O`6O0Gl00P000P1O00D0
O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o0080G`1L0001W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`Aoo`03001oogoo015oo`00
4Woo00@007ooOomooaMl00D00004?n00000000020n`00`000oD000030ol01@000]l2_`:o00001`6O
00<0001O05l0C`1O00<0006O0Il0F06O17oo00<007ooOol04Goo000BOol01000Oomoogoo5g`01000
00]Sh000000000?R0003j`000oD3mP000083o`0=0002_`;O0[l2g`000Il1O`6O0Gl1W`5o0Il00P00
00<0G`1o05l00P1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O
00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o
00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O05d0O`1O0001O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il017oo00<007ooOol04Goo
000BOol01000Oomoogoo67`01@0000Loh0000003hP000n`000020oD01P000ol3o`000[l2g`82_`03
0001W`6O00H1W`030000G`1O04d0G`030001W`6O05L1W`Aoo`03001oogoo015oo`004Woo00@007oo
OomooaQl00D0000:>n0000000n8000?/0n/000?e00030ol04@000[l2g`:o0]l0006O0Gl1W`5o0Il1
O`6O0Gl0001O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l0
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O05/0O`000Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00Oomoo`0AOol0
019oo`04001oogooOolIO00500001CoP000000?R00000P?/00<000?e00000`?o00<000:o0]l00P:o
0P001`6O0P00C01O00<0006O0Il0E`6O0goo0P004goo000BOol01000Oomoogoo6G`0100000aSh000
000Kh0000n8000?/0n/000?e00030ol01P000[l2g`:o0]l2_`8000070Il1O`6O0Gl1W`5o0Il00P00
0`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0
G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l01@1o05l0G`1O07l00P1O05X0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il4Ool00`00Oomoo`0AOol0019oo`04001oogooOolJ
O00500000coP000000020n801P000n`000?f0oD000<3o`030002_`;O00<2_`030]l0006O00L1W`80
04T0G`030001W`6O05H1W`Aoo`03001oogoo015oo`004Woo00@007ooOomooaYl00@00005In000000
5n0000020n801P000n`000?f0oD000<3o`80000?0]l2_`;O0[l2g`000Il1O`6O0Gl1W`5o0Il1O`6O
00<0000507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O
05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o
05l0G`1O07l00`1O05l0O`1O05l0G`1o05l0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo015oo`0027oo1@001Goo00@007ooOomo
oaYl0004001m8000Oh0200001SoP000Gh0000n800083k0040003mP?e00040ol00`000]l2_`020[l0
0`;O0001W`0:0Il2001405l00`000Il1W`1F0Il4Ool00`00Oomoo`0AOol000Qoo`05001oogooOol0
0005Ool01000Oomoogoo6W`000<007d000000P0000iSh000000Kh1OP0003hP000n/000?e0oH3m@00
10?o01<000;O0[l2g`:o0]l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`02000205l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O
05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1I
0001O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`04
Ool00`00Oomoo`0AOol000Uoo`03001oogoo00Ioo`04001oogooOolKO00300001gn0000003oP000K
h0000083hP070003k0000oD3mP?e000010?o00<000;O0[l00P:o00<2g`000Il0306O0P00?`1O00<0
006O0Il0E`6O17oo00<007ooOol04Goo000:Ool00`00Oomoo`05Ool20002OolKO0000`00OB000002
00003fOP000001OP6n0000?S0003k0?[0003m@?f0oD000040ol01P000]l2_`;O0[l2g`80000=0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00`000`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`03
05l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0O`0305l01@1o05l0G`1O
07l00`1O00D0O`1O05l0G`1o00<0G`1K07l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00goo0P004goo000;Ool00`00Oomoo`04Ool01000Oomo
ogoo6g`0100000MoP000000oh0005n0000020n8020000n`3k0000oD3mP?e00040ol00`000]l2_`02
0[l010;O0[l000003P6O0P00>P1O00<0006O0Il0E`6O17oo00<007ooOol04Goo000<Ool00`00Oomo
o`03Ool01000Oomoogoo77`00P0001=n@000001Sh000>n0001OP0003hP?S0003k0?[0003m@?f0oD0
00040ol060000]l2_`;O0[l2g`:o0]l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`@000<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`1M07l0G`1O0001W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo015o
o`0027oo00D007ooOomoo`0000Eoo`04001oogooOolLO0001@00OB000000Oh000P0000@oh0005n00
0083hP090003k0?/0n`000?e0oH3m@0000@3o`030002g`:o0082_`040]l2_`:o000B0Il3000b05l0
0`000Il1W`1H0Il4Ool00`00Oomoo`0AOol000Uoo`<000Ioo`04001oogooOolMO00200002Gi00000
06OP000oh0006n0000020n802@000n/3k0000oH3m@?f0oD000040ol07@000]l2_`;O0[l2g`:o0]l0
006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl00P0000D0O`1O05l0G`1o00<0
G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0G`1O05l0
O`0305l01@1o05l0G`1O07l00`1O05/0005o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00Oomoo`0AOol0019oo`04001oogooOolMO000
1@00O@000000Oh000P000SoP0P000P?R00D000?/0n`3k0000083m@030oH3m@0000@3o`030002g`:o
0082_`040]l2_`:o000E0Il2000/05l2001K0Il4Ool00`00Oomoo`0AOol0019oo`04001oogooOolM
O0003000OB000000Of0006?P000oh0005n000083hP090003k0?[0003m@?f0oD3mP0000D3o`080002
g`:o0]l2_`;O0[l2g`80000E0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
00H00080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O00D0O`1O05l0G`1o00<0G`0507l0
G`1O05l0O`0305l0H@1o05l000000Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo015oo`004Woo00@007ooOomooail
0080000:OT0007n0001Sh000?n0001OP00020n8010000n`3k0000`?e00<3mP000ol010?o0P000`:o
00@2g`:o0[l2_`8001T1W`D001/0G`@005l1W`Aoo`03001oogoo015oo`004Woo00@007ooOomooail
0008001m0000001oP000In00008oh003000Gh0000083hP090003k0?[0003m@?f0oD3mP0000H3o`0W
0002_`;O0[l2g`:o0]l2_`;O0001W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O00D00080G`0507l0G`1O05l0O`0305l01@1o05l0G`1O07l00`1O1000
06<1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il00goo0P004goo000BOol01000Oomoogoo7g`00P0000Yn@000Oh00
06OP000oh0006n0000<3hP040003k0?/00030oD00`?f0003o`050ol01@000[l2_`:o0]l00`:o00<2
g`000000806O4P00I`6O17oo00<007ooOol04Goo000BOol01000Oomoogoo7g`001<007dP000007mP
001Sh000>n0oh0006n0000?S0n8000?[0n`3j`02000010?f0oD3mP001P?o00X000:o0]l2_`;O0[l2
g`:o0]l2_`80002G0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il017oo00<007ooOol04Goo000BOol01000Oomoogoo87`00P0000]n@000Oh00
06?P000oh0005n0Kh0000083hP030003k0?/0083k0050003m@?e0oH000060ol01@000[l2_`:o0]l0
0`:o00@2g`:o000009H1W`Aoo`03001oogoo015oo`004Woo00@007ooOomoob1l0006001m0000001o
P7mP0P00018oh3_P000Gh1_P0003h`?R0003j`?/0n/000?e0oH3m@?f00060ol02`000[l2g`:o0]l2
_`;O0[l2g`:o0]l00P0009@1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`Aoo`03001oogoo015oo`004Woo00@007ooOomoob1l000;001m8000OT0007n0
001Wh000?n0000025n0010000n83hP0010?/00H000?e0oD3m@?f00060ol01@000[l2_`:o0]l00`:o
00@2g`:o0[l2_`800981W`Aoo`03001oogoo015oo`004Woo00@007ooOomoob5l0006001m8000001o
H7n00P000SoP014001_P5n0000?R0n<000?/0n/3k0000oH3m@?f0oD3mP0000H3o`2O0002_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O00Aoo`03001oogoo015oo`004Woo00@007ooOomoob5l000;001m0000OT0007n0001S
h000?n0000025n001@000n83hP?R00000`?/00<000?f0oD00P?e00<3mP000ol01@?o00D000:o0[l2
_`;O00<2_`050]l2_`:o0[l2g`02002?0Il3Ool2000COol0019oo`04001oogooOolRO0001P00O@00
07i0001oH080008oh004000Gh1_P00020n8030?S0003k0?[0n`000?f0oD3mP?e0oH000H3o`80000<
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0P0008d1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il017oo00<007ooOol04Goo000BOol01000Oomoogoo8W`000T007dP001n@000Oh00
06OP00000SoP00@001OP5n0000<3hP060003k0?/0n`000?f0`?e00<3mP000ol01P?o00@000:o0[l2
g`<2_`050]l2_`:o0[l2g`020[l00`000Il1W`2:0Il4Ool00`00Oomoo`0AOol0019oo`04001oogoo
OolSO0001P00OB0007i0001oP0800006>n0oh0006n0Gh0000`?R00`000?[0n`3j`?/0003mP?e0oH3
m@?f00070ol2000030:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`80002:0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O17oo00<007ooOol04Goo000BOol01000Oomoogoo8g`000T007d0001n
@000Oh0006?P00000SoP00@001_P5n0000<3hP030003k0?/0083k0030003mP?e0083m@030oH000?o
00L3o`030002_`;O00<2_`050]l2_`:o0[l2g`030[l200280Il4Ool00`00Oomoo`0AOol0019oo`04
001oogooOolSO0004000OB0007iP001oP000In1Sh000>n0oh0006n0Gh0000`?R00`000?[0n`3j`?/
0003mP?e0oH3m@?f00070ol040000]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0P0008H1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O17oo00<007ooOol04Goo000BOol01000Oomoogoo97`000T0
07dP001n@000Oh0006OP00000SoP00D001OP6n0Gh0000083hP030003k0?/00<3k0030003mP?e0083
m@030oH000?o00H3o`8000030[l2g`:o0082_`050]l2_`:o0[l2g`030[l010;O0[l00000Q06O17oo
00<007ooOol04Goo000BOol01000Oomoogoo97`0014007d0001n@000Of0006?PIn0003oP>n0001OP
6n0000?S0083hP0=0003k0?[0n`3j`?/0003mP?e0oH3m@?f000020?o0P0009<2g`:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l0006O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1
W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il017oo00<007ooOol04Goo000B
Ool01000Oomoogoo9G`000T007d0001n@000Oh0006?P00000SoP00D001OP5n0Kh00000<3hP030003
k0?/0083k0030003m@?f00<3m@030oH000?o00P3o`030002g`:o0082_`050]l2_`:o0[l2g`030[l0
0`;O0[l2_`0200210Il3Ool2000COol0019oo`04001oogooOolUO0002P00OB0007i0001oP000In1S
h0000SoP00H001_P5n0000?R0n<20n803@000n`3j`?/0n/000?e0oH3m@?f0oD3mP0000P3o`0B0002
_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0P0007l1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`04Ool00`00
Oomoo`0AOol0019oo`04001oogooOolUO0000`00O@1m80020002Oh001000In1Sh0000SoP00@001OP
5n0000@3hP030003k0?/0083k0030003m@?f00<3m@030oH000?o00L3o`8000050]l2_`:o0[l2g`03
0[l01@;O0[l2_`:o0]l00`:o00<2g`000000O@6O17oo00<007ooOol04Goo000BOol01000Oomoogoo
9W`000X007d0001n@000Of0006?PIn00008oh007000Gh1_P5n0000?R0n<00P?R00d000?/0n/3k000
0oH3m@?f0oD3mP?e0oH000090ol200004@:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l0
0P0007/1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il017oo00<007ooOol04Goo000BOol01000Oomoogoo9W`000<007dPO@000P000Wn0
00@006?PIn00008oh004000Gh1OP00040n800`000n`3k0020n`010000oD3m@?f0`?e00<3mP000ol0
2@?o00D000:o0[l2_`;O00<2_`050]l2_`:o0[l2g`030[l00`;O0[l2_`02001i0Il4Ool00`00Oomo
o`0AOol0019oo`04001oogooOolVO0003000O@1m8000OV0007n0001Wh6?P000kh08oh004000Gh1_P
00020n801`?S0n8000?[0n`3j`?/008000070oD3mP?e0oH3m@?f00002P?o01@000:o0]l2_`;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0P0007L1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o
0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo015oo`004Woo00@007ooOomo
obIl0006001m87d0001n@0000Wn000@006OPHn00008oh005000Kh1OP5n0000040n800`000n`3k003
0n`00`000oD3mP030oD00`000ol3o`090ol01@000[l2_`:o0]l00`:o00D2g`:o0[l2_`;O00<2_`06
0]l2_`:o0[l2g`00MP6O17oo00<007ooOol04Goo000BOol01000Oomoogoo9g`000<007dP00000Wi0
00h007mPOh0006OPHn0003_P?n0001_P5n0Kh0000P?R00l3h`?R0003j`?/0n/3k0?[0003m@?f0oD3
mP?e00002`?o01D000:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l00P0007@1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0goo0P004goo
000BOol01000Oomoogoo9g`000<007d000000Wi000L007n0Oh0006?PIn000002?n001@005n0Kh1OP
000010?R00<000?/0n`00`?/00@000?e0oD3mP<3m@8000X3o`050002_`:o0[l2g`030[l01@;O0[l2
_`:o0]l00`:o00H2g`:o0[l2_`;O0[l3001a0Il4Ool00`00Oomoo`0AOol0019oo`04001oogooOolX
O0000`00O@000002OT003P00Oh1oH000Hn1Wh000?n0kh0005n0Kh1OP00030n8040?S0003k0?[0n`3
j`?/0003mP?e0oH3m@?f0oD3mP002P?o0P0001H2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2
_`;O0[l2g`:o0]l2_`80001_0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
00Aoo`03001oogoo015oo`004Woo00@007ooOomoobQl0003001m8000009n@007001oP7n0001Wh6?P
00000SoP00H001OP5n0Kh1OP00040n800`000n`3k0030n`010000oD3m@?f0`?e00<3mP000ol02P?o
00@000:o0[l2g`<2_`050]l2_`:o0[l2g`030[l01@;O0[l2_`:o0]l00`:o00<2g`000000K@6O17oo
00<007ooOol04Goo000BOol01000Oomoogoo:7`000`007d0001n@7iPOT0007mP001Sh6OP0003?n00
1P006n0Gh1_P5n0000<3hP0@0003j`?/0n/3k0?[0n`000?f0oD3mP?e0oH3m@?f000;0ol200005`:o
0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l00P0006/1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O00Aoo`03001oogoo015oo`002Goo0`001Woo00@007ooOomo
obUl0003001m0000009n@007001oP7n0001Sh6OP00000coP00D001OP5n0Kh00000@3hP030003k0?/
00@3k0040003m@?e0oH30oD00`?f0000000;0ol00`000[l2g`030[l01@;O0[l2_`:o0]l00`:o00D2
g`:o0[l2_`;O00<2_`030]l2_`:o00<006P1W`Aoo`03001oogoo015oo`0027oo00D007ooOomoo`00
00Eoo`04001oogooOolYO0000`00OB000002OT002000Of1oP000In1Sh000>n02?n001`005n0Kh1OP
6n0000?S00<3hP0A0003j`?/0n/3k0?[0003m@?f0oD3mP?e0oH3m@?f0oD0000;0ol200006@;O0[l2
g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0080001V0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1
O`6O0Gl1W`5o0Il1O`6O17oo00<007ooOol04Goo000<Ool00`00Oomoo`03Ool01000Oomoogoo:W`0
00<007dP00000Wi000L007n0Oh0006OPHn000003?n001@005n0Gh1OP000010?R00<000?/0n`010?/
00D000?e0oD3m@?f00<3m@030oH3m@0000`3o`030002g`:o0082_`050]l2_`:o0[l2g`030[l01@;O
0[l2_`:o0]l00`:o00H2g`:o0[l2_`;O0[l2001T0Il4Ool00`00Oomoo`0AOol000aoo`03001oogoo
00=oo`80009oobYl0003001m0000009n@00B001oP7mP001Sh6OP000oh3_P?n0001_P5n0Kh1OP0003
hP?S0P?R014000?/0n/3k0?[0n`3j`000oD3mP?e0oH3m@?f0oD3mP0000d3o`200002g`:o0]l2_`;O
0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l2_`;O0[l2g`:o0]l0006O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O0Gl1W`5o0Il1O`6O
0Gl1W`=oo`8001=oo`002Woo0P001Woo00<007ooOol0iWoo00<007ooOol04Goo000<Ool00`00Oomo
o`03Ool00`00Oomoo`3VOol00`00Oomoo`0AOol000Qoo`05001oogooOol00005Ool01000Oomoo`00
1goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
17oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
17oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00D007ooOomo
o`0001=oo`002Goo0`001WoojP004goo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mo
oa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool0011oo`<00?aoo`004Woo
00<007ooOol0nWoo000BOol00`00Oomoo`3jOol0015oo`03001oo`000?]oo`004Goo00<007oo0000
ngoo000@Ool01@00Oomoogoo0000nWoo000@Ool01@00Oomoogoo0000nWoo000?Ool3000017oo0000
0000nGoo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00001\
\>"],
  ImageRangeCache->{{{0, 270.25}, {270.25, -2.1875}} -> {-0.290378, -3.55688, \
0.0166344, 0.0333802}}]
}, Open  ]],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"DropFormation.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{721, 668},
WindowMargins->{{5, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->330,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "The plane jet"->{
    Cell[1739, 51, 348, 5, 49, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 64}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"The plane jet"]},
  "plane jet"->{
    Cell[2090, 58, 1185, 30, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "plane jet", "Prandtl's boundary-layer equations", 
        "incompressible viscous fluid"}]},
  "Prandtl's boundary-layer equations"->{
    Cell[2090, 58, 1185, 30, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "plane jet", "Prandtl's boundary-layer equations", 
        "incompressible viscous fluid"}]},
  "incompressible viscous fluid"->{
    Cell[2090, 58, 1185, 30, 159, "Text",
      Evaluatable->False,
      CellTags->{
      "plane jet", "Prandtl's boundary-layer equations", 
        "incompressible viscous fluid"}]},
  "kinematic viscosity"->{
    Cell[4186, 126, 195, 4, 54, "Text",
      Evaluatable->False,
      CellTags->"kinematic viscosity"]},
  "asymptotic behavior"->{
    Cell[4853, 151, 100, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"asymptotic behavior"],
    Cell[14448, 497, 188, 7, 33, "Text",
      Evaluatable->False,
      CellTags->"asymptotic behavior"]},
  "Schlichting"->{
    Cell[5429, 173, 846, 19, 75, "Text",
      Evaluatable->False,
      CellTags->{"Schlichting", "stream function"}]},
  "stream function"->{
    Cell[5429, 173, 846, 19, 75, "Text",
      Evaluatable->False,
      CellTags->{"Schlichting", "stream function"}],
    Cell[174554, 5224, 283, 8, 54, "Text",
      Evaluatable->False,
      CellTags->"stream function"]},
  "jet equations"->{
    Cell[6701, 208, 125, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"jet equations"]},
  "Infinitesimals[]"->{
    Cell[8859, 279, 199, 5, 33, "Text",
      Evaluatable->False,
      CellTags->"Infinitesimals[]"]},
  "reduction"->{
    Cell[10934, 351, 65, 1, 33, "Text",
      CellTags->"reduction"]},
  "similarity solution"->{
    Cell[12140, 395, 343, 13, 33, "Text",
      Evaluatable->False,
      CellTags->"similarity solution"]},
  "boundary conditions"->{
    Cell[12882, 425, 382, 11, 54, "Text",
      Evaluatable->False,
      CellTags->"boundary conditions"],
    Cell[20058, 689, 919, 31, 54, "Text",
      Evaluatable->False,
      CellTags->"boundary conditions"]},
  "similarity reduction"->{
    Cell[15967, 556, 109, 1, 33, "Text",
      CellTags->"similarity reduction"]},
  "DSolve[]"->{
    Cell[18209, 625, 545, 17, 75, "Text",
      Evaluatable->False,
      CellTags->"DSolve[]"]},
  "jet solution"->{
    Cell[21445, 739, 216, 7, 33, "Text",
      Evaluatable->False,
      CellTags->"jet solution"]},
  "similarity representation"->{
    Cell[21978, 762, 133, 2, 33, "Text",
      Evaluatable->False,
      CellTags->"similarity representation"]},
  "Tanh[]"->{
    Cell[22557, 782, 876, 26, 117, "Text",
      Evaluatable->False,
      CellTags->{"Tanh[]", "contour plot"}]},
  "contour plot"->{
    Cell[22557, 782, 876, 26, 117, "Text",
      Evaluatable->False,
      CellTags->{"Tanh[]", "contour plot"}]},
  "stream lines"->{
    Cell[173674, 5189, 355, 9, 75, "Text",
      Evaluatable->False,
      CellTags->"stream lines"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"The plane jet", 493434, 15918},
  {"plane jet", 493771, 15925},
  {"Prandtl's boundary-layer equations", 494000, 15931},
  {"incompressible viscous fluid", 494223, 15937},
  {"kinematic viscosity", 494437, 15943},
  {"asymptotic behavior", 494571, 15947},
  {"Schlichting", 494804, 15954},
  {"stream function", 494948, 15958},
  {"jet equations", 495195, 15965},
  {"Infinitesimals[]", 495320, 15969},
  {"reduction", 495441, 15973},
  {"similarity solution", 495539, 15976},
  {"boundary conditions", 495675, 15980},
  {"similarity reduction", 495920, 15987},
  {"DSolve[]", 496019, 15990},
  {"jet solution", 496137, 15994},
  {"similarity representation", 496271, 15998},
  {"Tanh[]", 496399, 16002},
  {"contour plot", 496534, 16006},
  {"stream lines", 496669, 16010}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 348, 5, 49, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 64}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"The plane jet"],
Cell[2090, 58, 1185, 30, 159, "Text",
  Evaluatable->False,
  CellTags->{
  "plane jet", "Prandtl's boundary-layer equations", 
    "incompressible viscous fluid"}],
Cell[3278, 90, 82, 1, 30, "NumberedEquation"],
Cell[3363, 93, 123, 3, 30, "NumberedEquation"],
Cell[3489, 98, 111, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[3625, 107, 246, 5, 47, "Input"],
Cell[3874, 114, 297, 9, 45, "Output"]
}, Open  ]],
Cell[4186, 126, 195, 4, 54, "Text",
  Evaluatable->False,
  CellTags->"kinematic viscosity"],

Cell[CellGroupData[{
Cell[4406, 134, 125, 3, 28, "Input"],
Cell[4534, 139, 304, 9, 30, "Output"]
}, Open  ]],
Cell[4853, 151, 100, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],
Cell[4956, 155, 97, 2, 26, "Input",
  Evaluatable->False],
Cell[5056, 159, 189, 6, 33, "Text",
  Evaluatable->False],
Cell[5248, 167, 178, 4, 40, "Input"],
Cell[5429, 173, 846, 19, 75, "Text",
  Evaluatable->False,
  CellTags->{"Schlichting", "stream function"}],

Cell[CellGroupData[{
Cell[6300, 196, 202, 4, 28, "Input"],
Cell[6505, 202, 181, 3, 30, "Output"]
}, Open  ]],
Cell[6701, 208, 125, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"jet equations"],

Cell[CellGroupData[{
Cell[6851, 214, 89, 2, 27, "Input"],
Cell[6943, 218, 420, 12, 43, "Output"]
}, Open  ]],
Cell[7378, 233, 213, 4, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7616, 241, 108, 2, 27, "Input"],
Cell[7727, 245, 1117, 31, 30, "Output"]
}, Open  ]],
Cell[8859, 279, 199, 5, 33, "Text",
  Evaluatable->False,
  CellTags->"Infinitesimals[]"],

Cell[CellGroupData[{
Cell[9083, 288, 133, 3, 27, "Input"],
Cell[9219, 293, 786, 25, 57, "Output"]
}, Open  ]],
Cell[10020, 321, 540, 15, 96, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10585, 340, 284, 5, 45, "Input"],
Cell[10872, 347, 47, 1, 30, "Output"]
}, Open  ]],
Cell[10934, 351, 65, 1, 33, "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{
Cell[11024, 356, 258, 5, 45, "Input"],
Cell[11285, 363, 443, 12, 59, "Output"]
}, Open  ]],
Cell[11743, 378, 85, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11853, 383, 138, 4, 27, "Input"],
Cell[11994, 389, 131, 3, 34, "Output"]
}, Open  ]],
Cell[12140, 395, 343, 13, 33, "Text",
  Evaluatable->False,
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[12508, 412, 185, 5, 27, "Input"],
Cell[12696, 419, 171, 3, 33, "Output"]
}, Open  ]],
Cell[12882, 425, 382, 11, 54, "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{
Cell[13289, 440, 147, 4, 28, "Input"],
Cell[13439, 446, 68, 1, 32, "Output"]
}, Open  ]],
Cell[13522, 450, 68, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13615, 455, 79, 2, 27, "Input"],
Cell[13697, 459, 50, 1, 30, "Output"]
}, Open  ]],
Cell[13762, 463, 76, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13863, 468, 136, 3, 28, "Input"],
Cell[14002, 473, 50, 1, 30, "Output"]
}, Open  ]],
Cell[14067, 477, 180, 8, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14272, 489, 89, 2, 38, "Input"],
Cell[14364, 493, 69, 1, 42, "Output"]
}, Open  ]],
Cell[14448, 497, 188, 7, 33, "Text",
  Evaluatable->False,
  CellTags->"asymptotic behavior"],

Cell[CellGroupData[{
Cell[14661, 508, 99, 2, 28, "Input"],
Cell[14763, 512, 38, 1, 42, "Output"]
}, Open  ]],
Cell[14816, 516, 441, 13, 54, "Text",
  Evaluatable->False],
Cell[15260, 531, 305, 10, 54, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15590, 545, 284, 5, 45, "Input"],
Cell[15877, 552, 75, 1, 30, "Output"]
}, Open  ]],
Cell[15967, 556, 109, 1, 33, "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{
Cell[16101, 561, 258, 5, 45, "Input"],
Cell[16362, 568, 232, 5, 69, "Message"],
Cell[16597, 575, 734, 17, 93, "Output"]
}, Open  ]],
Cell[17346, 595, 95, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[17466, 602, 247, 5, 34, "Input"],
Cell[17716, 609, 478, 13, 32, "Output"]
}, Open  ]],
Cell[18209, 625, 545, 17, 75, "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{
Cell[18779, 646, 60, 1, 38, "Input"],
Cell[18842, 649, 615, 16, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19494, 670, 116, 3, 39, "Input"],
Cell[19613, 675, 430, 11, 42, "Output"]
}, Open  ]],
Cell[20058, 689, 919, 31, 54, "Text",
  Evaluatable->False,
  CellTags->"boundary conditions"],

Cell[CellGroupData[{
Cell[21002, 724, 150, 3, 38, "Input"],
Cell[21155, 729, 275, 7, 42, "Output"]
}, Open  ]],
Cell[21445, 739, 216, 7, 33, "Text",
  Evaluatable->False,
  CellTags->"jet solution"],

Cell[CellGroupData[{
Cell[21686, 750, 95, 2, 27, "Input"],
Cell[21784, 754, 179, 5, 54, "Output"]
}, Open  ]],
Cell[21978, 762, 133, 2, 33, "Text",
  Evaluatable->False,
  CellTags->"similarity representation"],

Cell[CellGroupData[{
Cell[22136, 768, 179, 4, 38, "Input"],
Cell[22318, 774, 224, 5, 54, "Output"]
}, Open  ]],
Cell[22557, 782, 876, 26, 117, "Text",
  Evaluatable->False,
  CellTags->{"Tanh[]", "contour plot"}],
Cell[23436, 810, 197, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[23658, 818, 221, 3, 45, "Input"],
Cell[23882, 823, 149777, 4363, 283, 46305, 3081, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[173674, 5189, 355, 9, 75, "Text",
  Evaluatable->False,
  CellTags->"stream lines"],

Cell[CellGroupData[{
Cell[174054, 5202, 78, 2, 28, "Input"],
Cell[174135, 5206, 77, 1, 61, "Output"]
}, Open  ]],
Cell[174227, 5210, 41, 1, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[174293, 5215, 83, 2, 27, "Input"],
Cell[174379, 5219, 160, 2, 63, "Output"]
}, Open  ]],
Cell[174554, 5224, 283, 8, 54, "Text",
  Evaluatable->False,
  CellTags->"stream function"],

Cell[CellGroupData[{
Cell[174862, 5236, 276, 4, 40, "Input"],
Cell[175141, 5242, 154213, 5005, 287, 57247, 3803, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[329369, 10250, 149, 6, 33, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[329543, 10260, 219, 3, 45, "Input"],
Cell[329765, 10265, 161766, 5596, 286, 66044, 4410, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[491546, 15864, 153, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

