(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63273,       1807]*)
(*NotebookOutlinePosition[     78423,       2155]*)
(*  CellTagsIndexPosition[     76244,       2103]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.4 The Korteweg-de Vries Equation and Its Generalizations", 
  "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 47}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"The Korteweg-de Vries equation and some Generalizations"],

Cell["\<\
The aim of this section is the determination of the point \
symmetries for different generalizations of the Korteweg-de Vries equation \
(gKdV). We first examine the original equation of Korteweg and de Vries \
(KdV). The generalizations of the KdV are based on additional terms, larger \
sets of independent coordinates, and changes in the non-linearity. The models \
examined are all taken from literature and describe different physical \
problems. At the end of this section, we collect the results in a table \
containing the equation and the symmetries.\
\>", "Text",
  CellTags->{
  "point symmetries", "generalizations of the Korteweg-de Vries equation", 
    "Korteweg de Vries equation", "KdV equation", 
    "generalized Korteweg de Vries equation", "gKdV equation"}],

Cell[TextData[{
  "The Korteweg-de Vries equation is one of the prominent equations in \
non-linear physics which describes a highly regular behavior. The KdV \
equation originally derived by ",
  ButtonBox["Korteweg",
    ButtonData:>{"Literat.nb", "KortewegDeVries-1895"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["de Vries [1895]",
    ButtonData:>{"Literat.nb", "KortewegDeVries-1895"},
    ButtonStyle->"Hyperlink"],
  " is used to describe shallow water waves in a narrow channel. The equation \
was originally designed to describe the experimental observations of John \
Scott ",
  ButtonBox["Russell [1844]",
    ButtonData:>{"Literat.nb", "Russel-1844"},
    ButtonStyle->"Hyperlink"],
  " that a heap of water travels along the Edinburgh to Glasgow channel \
without change of form and with a constant velocity."
}], "Text",
  CellTags->{"nonlinear physics", "KdV equation", "shallow water waves"}],

Cell[TextData[{
  "Today, the KdV equation is encountered in different physical systems such \
as in plasmas, in elastic strings, in lattice vibrations of a crystal at low \
temperatures, and in the description of a rotating liquid in a pipe. All \
these applications start from a more or less general physical model and end \
up in the KdV equation by considering a specific limit of the physical \
problem. In this sense, the KdV equation is universal. The universality is \
contained in the behavior that the dispersion of linear waves is \
counterbalanced by the non-linearity. The interaction of dispersion and \
non-linearity stabilizes the solution of the equation and results in the \
outstanding behavior of regularity. This kind of solution is called a soliton \
by ",
  ButtonBox["Zabusky and Kruskal [1965]",
    ButtonData:>{"Literat.nb", "Zabusky-1965"},
    ButtonStyle->"Hyperlink"],
  ". A soliton is a special kind of localized wave. More generally, a soliton \
is a solution of a non-linear equation or system which represents a wave of \
permanent shape, is localized, decaying or becoming constant at infinity, and \
may interact strongly with other solitons so that after the interaction, it \
retains its form (cf. ",
  ButtonBox["Drazin [1983]",
    ButtonData:>{"Literat.nb", "Drazin-1983"},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  CellTags->{
  "plasmas", "elastic strings", "lattice vibrations", 
    "rotating liquid in a pipe", "universality", "dispersion", "waves", 
    "interaction of dispersion and nonlinearity", "soliton", 
    "localized wave", "wave of permanent shape"}],

Cell["\<\
The KdV equation is a non-linear PDE which reads in its standard \
form\
\>", "Text",
  CellTags->{"KdV equation", "nonlinear PDE"}],

Cell[BoxData[
    \(TraditionalForm
    \`u\_t\  + \ 6  u\ u\_x\  + \ u\_\(x, x, x\)\  = \ 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  "The field ",
  Cell[BoxData[
      \(TraditionalForm\`u = u(x, t)\)]],
  " describes the deviation from the mean water depth in the shallow water \
channel application. Our intention here is to show that the KdV equation not \
only allows solitons but also other kinds of solutions. To derive these types \
of solutions, we first need to know the infinitesimal transformation of the \
KdV equation. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the KdV equation is given by"
}], "Text",
  CellTags->{
  "shallow water waves", "infinitesimal transformation of the KdV equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(KdV\  = \ 
      \[PartialD]\_t u[x, t]\  + \ 6\ u[x, t]\ \[PartialD]\_x u[x, t] + 
          \[PartialD]\_\(x, x, x\)u[x, t] == 0; KdV // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t + 6\ u\ u\_x + u\_\(x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The infinitesimals of the KdV follow by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InfinitesimalsKdV\  = \ Infinitesimals[KdV, u, {x, t}]; 
    InfinitesimalsKdV // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(k2\/6\),
                  ScriptLevel->0], "-", \(2\ k4\ u\)}]}]},
          {\(\[Xi]\_1 == k3 + k2\ t + k4\ x\)},
          {\(\[Xi]\_2 == k1 + 3\ k4\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Rational[ 1, 6], k2], 
            Times[ -2, k4, u]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k3, 
            Times[ k2, t], 
            Times[ k4, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 3, k4, t]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
The result is a four-dimensional finite group containing \
translation and scaling transformations.\
\>", "Text",
  CellTags->"finite group"],

Cell[TextData[{
  "The second model we examine is the cylindrical KdV equation. This kind of \
equation was discussed by ",
  ButtonBox["Calogero and Degasperis [1978]",
    ButtonData:>{"Literat.nb", "Calogero-1978"},
    ButtonStyle->"Hyperlink"],
  " in connection with the spectral transform method. The cylindrical form of \
the KdV equation reads"
}], "Text",
  CellTags->"cylindrical KdV equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_t\  + \ 6\ u\ u\_x\  + \ u\_\(x, x, x\)\  + \ \(1\/\(2  t\)\) u\  = 
      \ 0. \)], "NumberedEquation"],

Cell["The Infinitesimals for this equation follows from", "Text",
  CellTags->"symmetry group of the cylindrical KdV equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infCylibdicylKdV\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] + 6  u[x, t]\ \[PartialD]\_x u[x, t]\  + \ 
            \[PartialD]\_\(x, x, x\)u[x, t] + \(1\/\(2\ t\)\) u[x, t] == 0, 
        u, {x, t}]; infCylibdicylKdV // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(4\ k3 - 16\ k1\ \@t\ u - 24\ k2\ t\ u + k2\ x\)\/\(24\ 
                      \@t\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k4", "+", \(2\ k3\ \@t\), "+", 
                RowBox[{
                  StyleBox[\(1\/6\),
                    ScriptLevel->0], " ", \((2\ k1 + 3\ k2\ \@t)\), " ", 
                  "x"}]}]}]},
          {\(\[Xi]\_2 == \((k1 + k2\ \@t)\)\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 24], 
            Power[ t, 
              Rational[ -1, 2]], 
            Plus[ 
              Times[ 4, k3], 
              Times[ -16, k1, 
                Power[ t, 
                  Rational[ 1, 2]], u], 
              Times[ -24, k2, t, u], 
              Times[ k2, x]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k4, 
            Times[ 2, k3, 
              Power[ t, 
                Rational[ 1, 2]]], 
            Times[ 
              Rational[ 1, 6], 
              Plus[ 
                Times[ 2, k1], 
                Times[ 3, k2, 
                  Power[ t, 
                    Rational[ 1, 2]]]], x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Times[ 
            Plus[ k1, 
              Times[ k2, 
                Power[ t, 
                  Rational[ 1, 2]]]], t]]}]]], "Output"]
}, Open  ]],

Cell["\<\
We find a four-dimensional finite symmetry group containing \
translations, scaling, and two special symmetry transformations.\
\>", "Text",\

  CellTags->"finite symmetry group"],

Cell["\<\
Another KdV equation closely related to the cylindrical KdV \
equation is the spherical KdV equation given by\
\>", "Text",
  CellTags->"spherical KdV equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_t\  + \ 6\ u\ u\_x\  + \ u\_\(x, x, x\)\  + \ \(1\/t\) u\  = \ 0. 
      \)], "NumberedEquation"],

Cell["The infinitesimals of this equation are", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infsphericalKdV\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] + 6  u[x, t]\ \[PartialD]\_x u[x, t]\  + \ 
            \[PartialD]\_\(x, x, x\)u[x, t] + \(1\/\(\ t\)\) u[x, t] == 0, 
        u, {x, t}]; infsphericalKdV // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(k3\/\(6\ t\)\),
                  ScriptLevel->0], "-", \(2\ k2\ u\)}]}]},
          {\(\[Xi]\_1 == k1 + k4 + k2\ x + k3\ Log[t]\)},
          {\(\[Xi]\_2 == 3\ k2\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Rational[ 1, 6], k3, 
              Power[ t, -1]], 
            Times[ -2, k2, u]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, k4, 
            Times[ k2, x], 
            Times[ k3, 
              Log[ t]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Times[ 3, k2, t]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The symmetry group is a three-dimensional finite group. Compared with the \
cylindrical KdV in which the symmetries changed drastically, there is no \
longer a rational exponent of ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " present but logarithmic dependencies in ",
  StyleBox["t",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"finite group"],

Cell[TextData[{
  "Another kind of generalization of the KdV was given by ",
  ButtonBox["Ko and Kuehl [1978]",
    ButtonData:>{"Literat.nb", "Ko and Kuehl-1978"},
    ButtonStyle->"Hyperlink"],
  " in their discussion of ion acoustic solitons in a non-uniform plasma. The \
two authors assumed that the coefficients of the non-linear and dispersive \
term depend on time. The KdV for such a slowly varying medium is given by"
}], "Text",
  CellTags->{
  "ion acoustic solitons", "KdV equation for a slowly varying medium"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        \(u\_t\  + \ \(\[Alpha](\[Tau])\)\ u\ u\_x + \ 
            \(\[Beta](\[Tau])\)\ u\_\(x, x, x\)\), "=", " ", 
          RowBox[{"0", "  ", "and", " ", 
            FormBox[\(\[Alpha], \[Beta] > 0\),
              "TraditionalForm"]}]}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where the coefficients \[Alpha] and \[Beta] are arbitrary positive \
functions of a slow time variable ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Tau]", "=", 
          RowBox[{"\[Epsilon]", " ", 
            StyleBox["t",
              FontSlant->"Italic"]}]}], TraditionalForm]]],
  ". The infinitesimals for equation (5.51) are given by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infVaryingKdV\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] + 
            \[Alpha][\[Epsilon]\ t]\ u[x, t] \[PartialD]\_x u[x, t] + 
            \[Beta][\[Epsilon]\ t]\ \[PartialD]\_\(x, x, x\)u[x, t] == 0, 
        u, {x, t}, {\[Epsilon]}]; 
    \(\(infVaryingKdV //. TraditionalLieForm\) /. {Rule \[Rule] Equal, 
            HoldPattern[Function[x_, y_]] \[Rule] y} // Sort\) // TableForm
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\[Xi]\_1 == 
              k2 + k1\ \(\[Integral]\_0\%t \[Alpha][DSolve`t\ \[Epsilon]] 
                      \[DifferentialD]DSolve`t\)\)},
          {\(\[Xi]\_2 == 0\)},
          {\(\[Phi]\_1 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k1, 
              Integrate[ 
                \[Alpha][ 
                  Times[ DSolve`t, \[Epsilon]]], {DSolve`t, 0, t}]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 0], 
        Equal[ 
          Subscript[ \[Phi], 1], k1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals of equation (5.51) show that a discrete group of \
dimension two exists. Surprisingly, this symmetry group depends on an \
integral over the coefficient of the non-linearity ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Integral]\_0\%t\),
            "InlineFormula"], 
          RowBox[{
            RowBox[{
              StyleBox["\[Alpha]",
                "InlineFormula"], 
              StyleBox["(",
                "InlineFormula"], 
              StyleBox[
                SuperscriptBox[
                  StyleBox[
                    RowBox[{
                      StyleBox["\[Epsilon]",
                        "InlineFormula"], 
                      StyleBox["t",
                        FontSlant->"Italic"]}]], 
                  StyleBox["\[Prime]",
                    FontSlant->"Plain"]],
                FontSlant->"Italic"], 
              StyleBox[")",
                "InlineFormula"]}], 
            StyleBox[" ",
              "InlineFormula"], 
            StyleBox[\(\[DifferentialD]t\^\[Prime]\),
              "InlineFormula"]}]}], TraditionalForm]]],
  " and not on \[Beta]. A similar equation extended by linear derivatives was \
discussed by ",
  ButtonBox["Chan and Li [1994]",
    ButtonData:>{"Literat.nb", "Chan-1994"},
    ButtonStyle->"Hyperlink"],
  " in connection with the non-standard dynamics of solitons (oscillating or \
standing). The equation discussed by Chan and Li in connection with the \
inverse scattering theory is given by"
}], "Text",
  CellTags->"non-standard dynamics of solitons"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(u\_t\), " ", "+", " ", 
            RowBox[{\((6\ \(u\^2\) u\_x + u\_\(x, x, x\))\), " ", 
              
              FormBox[\(\(k\_0\)(t)\  - \((x\ u\_x + u)\)\ \(h(t)\)\  + \ 
                  u\_x\ \(\(k\_1\)(t)\)\),
                "TraditionalForm"]}]}], "=", "0"}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`k\_0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`k\_1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " are continuous functions of ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Equation (5.52) reduces to the modified KdV equation when ",
  Cell[BoxData[
      \(TraditionalForm\`k\_0 = 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`k\_1 = \(h = 0\)\)]],
  ". The symmetries of equation (5.52) are"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infNonPropagatingKdV\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] + 
            k0[t]\ \((
                6\ \(u[x, t]\^2\) \[PartialD]\_x u[x, t]\  + 
                  \[PartialD]\_\(x, x, x\)u[x, t])\)\  - 
            h[t] \((x \[PartialD]\_x u[x, t] + u[x, t])\) + 
            k1[t] \[PartialD]\_x u[x, t] == 0, u, {x, t}]; 
    infNonPropagatingKdV\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(3\ h\ k\_0\ \[ScriptCapitalF]\_2 + 
                k\_1\ \((
                    \[ScriptCapitalF]\_1\ \((k\_0)\)\_t - 
                      2\ k\_0\ \((\[ScriptCapitalF]\_1)\)\_t)\) + 
                3\ k\_0\ 
                  \((\(-\[ScriptCapitalF]\_1\)\ \((k\_1)\)\_t + 
                      \((\[ScriptCapitalF]\_2)\)\_t)\) == 0\)},
          {
            \(\(-\[ScriptCapitalF]\_1\)\ \((k\_0)\)\_t\%2 + 
                k\_0\ \((
                    \((k\_0)\)\_t\ \((\[ScriptCapitalF]\_1)\)\_t + 
                      \[ScriptCapitalF]\_1\ \((k\_0)\)\_\(t, t\))\) + 
                k\_0\%2\ 
                  \((3\ h\_t\ \[ScriptCapitalF]\_1 + 
                      3\ h\ \((\[ScriptCapitalF]\_1)\)\_t + 
                      \((\[ScriptCapitalF]\_1)\)\_\(t, t\))\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "+", 
                
                StyleBox[
                  \(\(x\ \((
                          \[ScriptCapitalF]\_1\ \((k\_0)\)\_t + 
                            k\_0\ \((\[ScriptCapitalF]\_1)\)\_t)\)\)\/\(3\ 
                        k\_0\)\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == \[ScriptCapitalF]\_1\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"-", 
                
                StyleBox[
                  \(\(u\ \((
                          \[ScriptCapitalF]\_1\ \((k\_0)\)\_t + 
                            k\_0\ \((\[ScriptCapitalF]\_1)\)\_t)\)\)\/\(3\ 
                        k\_0\)\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ 3, h, 
              Subscript[ k, 0], 
              Subscript[ \[ScriptCapitalF], 2]], 
            Times[ 
              Subscript[ k, 1], 
              Plus[ 
                Times[ 
                  Subscript[ \[ScriptCapitalF], 1], 
                  Subscript[ 
                    Subscript[ k, 0], t]], 
                Times[ -2, 
                  Subscript[ k, 0], 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 1], t]]]], 
            Times[ 3, 
              Subscript[ k, 0], 
              Plus[ 
                Times[ -1, 
                  Subscript[ \[ScriptCapitalF], 1], 
                  Subscript[ 
                    Subscript[ k, 1], t]], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t]]]], 0], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ \[ScriptCapitalF], 1], 
              Power[ 
                Subscript[ 
                  Subscript[ k, 0], t], 2]], 
            Times[ 
              Subscript[ k, 0], 
              Plus[ 
                Times[ 
                  Subscript[ 
                    Subscript[ k, 0], t], 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 1], t]], 
                Times[ 
                  Subscript[ \[ScriptCapitalF], 1], 
                  Subscript[ 
                    Subscript[ k, 0], t, t]]]], 
            Times[ 
              Power[ 
                Subscript[ k, 0], 2], 
              Plus[ 
                Times[ 3, 
                  Subscript[ h, t], 
                  Subscript[ \[ScriptCapitalF], 1]], 
                Times[ 3, h, 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 1], t]], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t, t]]]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ 1, 3], x, 
              Power[ 
                Subscript[ k, 0], -1], 
              Plus[ 
                Times[ 
                  Subscript[ \[ScriptCapitalF], 1], 
                  Subscript[ 
                    Subscript[ k, 0], t]], 
                Times[ 
                  Subscript[ k, 0], 
                  Subscript[ 
                    Subscript[ \[ScriptCapitalF], 1], t]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ -1, 3], u, 
            Power[ 
              Subscript[ k, 0], -1], 
            Plus[ 
              Times[ 
                Subscript[ \[ScriptCapitalF], 1], 
                Subscript[ 
                  Subscript[ k, 0], t]], 
              Times[ 
                Subscript[ k, 0], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t]]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The infinitesimals of Chan\[CloseCurlyQuote]s equation define an infinite \
dimensional symmetry group. The symmetries are defined by the two arbitrary \
functions",
  StyleBox[" ", "MmaText"],
  StyleBox["free[1]", "MmaText",
    FontSlant->"Italic"],
  " and ",
  StyleBox["free[2]", "MmaText",
    FontSlant->"Italic"],
  " and the coefficients ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(k\_0\),
            "TraditionalForm"], ",", \(k\_1\)}], TraditionalForm]]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  ". One of the arbitrary functions, ",
  StyleBox["free[1]", "MmaText",
    FontSlant->"Italic"],
  StyleBox[",", "MmaText"],
  " occurs in the infinitesimals, whereas the other is contained in the \
remaining determining equations. Equation (5.52) demonstrates that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is capable of handling equations with general analytic coefficients."
}], "Text",
  CellTags->{
  "infinite-dimensional symmetry group", "determining equations", 
    "equations with analytic coefficients"}],

Cell[TextData[{
  "A related model to Chan\[CloseCurlyQuote]s was discussed by ",
  ButtonBox["Fung and Au [1982]",
    ButtonData:>{"Literat.nb", "Fung-1982"},
    ButtonStyle->"Hyperlink"],
  " to bridge the solutions and vacuum states of the KdV equation and the  \
equation"
}], "Text",
  CellTags->"vacuum states of the KdV equation"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`u\_t\ \  - \ 6 \( u\^2\) u\_x\  + \ u\_\(x, x, x\) + \ 
        6  \[Lambda]u\_x = 0\)]]], "NumberedEquation"],

Cell[TextData[{
  "with \[Lambda] a real parameter. Equation (5.53), despite of the sign in \
the non-linearity, follows from Chan\[CloseCurlyQuote]s model by setting ",
  Cell[BoxData[
      \(TraditionalForm\`h = 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`k\_0 = 1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`k\_1 = 6\ \[Lambda]\)]],
  ". This \[Lambda]-dependent model allows the infinitesimals"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf\[Lambda]KdV\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] - 6 \( u[x, t]\^2\) \[PartialD]\_x u[x, t] + 
            \[PartialD]\_\(x, x, x\)u[x, t] + 
            6  \[Lambda]\ \[PartialD]\_x u[x, t] == 0, 
        u, {x, t}, {\[Lambda]}]; inf\[Lambda]KdV\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == \(-k3\)\ u\)},
          {\(\[Xi]\_1 == k2 + k3\ \((x + 12\ t\ \[Lambda])\)\)},
          {\(\[Xi]\_2 == k1 + 3\ k3\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ -1, k3, u]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k3, 
              Plus[ x, 
                Times[ 12, t, \[Lambda]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 3, k3, t]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
We realize that the restrictions on the Chan equation (5.52) lead \
to a three-dimensional symmetry group allowing translations and \
scalings.\
\>", "Text"],

Cell[TextData[{
  "In connection with traveling wave solutions, ",
  ButtonBox["Yang [1994]",
    ButtonData:>{"Literat.nb", "Yang-1994"},
    ButtonStyle->"Hyperlink"],
  " examined the generalized KdV equation"
}], "Text",
  CellTags->{"traveling wave solutions", "generalized KdV equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\_t + \ \[Beta]\ \(u\^\[Alpha]\) u\_x + u\_\(x, x, x\) = 0, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where \[Alpha] and \[Beta] are real numbers. This equation reduces to the \
original KdV equation and the modified KdV equation for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta] = 6\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 1, 2\)]],
  ", respectively. Other combinations of \[Alpha] and \[Beta] are known and \
discussed in connection with ion acoustic waves in cold-ion and \
multi-component plasma (cf. ",
  ButtonBox["Yang [1994]",
    ButtonData:>{"Literat.nb", "Yang-1994"},
    ButtonStyle->"Hyperlink"],
  "). The infinitesimals of this gKdV equation are"
}], "Text",
  CellTags->{
  "ion-acoustic waves", "multi-component plasma", "gKdV equation", 
    "infinitesimals of the gKdV equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(infGKdV\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] + 
            \[Beta]\ \(u[x, t]\^\[Alpha]\) \[PartialD]\_x u[x, t] + 
            \[PartialD]\_\(x, x, x\)u[x, t] == 0, 
        u, {x, t}, {\[Alpha], \[Beta]}]; infGKdV // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"-", 
                StyleBox[\(\(2\ k3\ u\)\/\(3\ \[Alpha]\)\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k1", "+", 
                StyleBox[\(\(k3\ x\)\/3\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == k2 + k3\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ -2, 3], k3, u, 
            Power[ \[Alpha], -1]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, 
            Times[ 
              Rational[ 1, 3], k3, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k2, 
            Times[ k3, t]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"a set of transformations depending on three group parameters and on the \
exponent \[Alpha]. We also observe that the symmetry group does not depend on \
the non-linearity factor \[Beta]."], "Text"],

Cell["\<\
Discussing weakly non-linear, long-wavelength waves propagating on \
the surface of an incompressible, inviscid, irrotational fluid, the following \
perturbed KdV equation arises:\
\>", "Text",
  CellTags->{"long waves", "perturbed KdV equation"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(u\_t\), " ", "+", " ", 
          RowBox[{"6", " ", 
            SubscriptBox[
              StyleBox["uu",
                FontSlant->"Italic"], "x"]}], "+", \(u\_\(x, x, x\)\), " ", 
          "+", " ", 
          RowBox[{"\[Epsilon]", "\[ThinSpace]", "(", 
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  SuperscriptBox[
                    StyleBox[
                      RowBox[{"\[Alpha]", 
                        StyleBox["u",
                          FontSlant->"Italic"]}]], "2"]}], \(u\_x\)}], "+", 
              SubscriptBox[
                StyleBox[
                  RowBox[{"\[Beta]", 
                    StyleBox["uu",
                      FontSlant->"Italic"]}]], \(x, x\)], "+", " ", 
              RowBox[{
                SubscriptBox[
                  StyleBox[
                    RowBox[{"\[Gamma]", 
                      StyleBox["u",
                        FontSlant->"Italic"]}]], "x"], \(u\_\(x, x\)\)}], 
              "+", 
              SubscriptBox[
                StyleBox[
                  RowBox[{"\[Delta]", 
                    StyleBox["u",
                      FontSlant->"Italic"]}]], \(x, x, x, x, x\)]}], ")"}]}], 
        "=", "0."}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "Here, \[Alpha], \[Beta], \[Gamma], \[Delta], and \[Epsilon] are constant \
parameters. \[Epsilon] is the amplitude-to-depth ratio and is assumed to be \
much smaller than unity; ",
  Cell[BoxData[
      \(TraditionalForm\`| \[Epsilon] | \( \[LessLess] 1\)\)]],
  ". This kind of KdV equation was examined by ",
  ButtonBox["Alexeyev [1994]",
    ButtonData:>{"Literat.nb", "Alexeyev-1994"},
    ButtonStyle->"Hyperlink"],
  " in connection with B\[ADoubleDot]cklund transformations and by ",
  ButtonBox["Porsezian and Lakshmanan [1993]",
    ButtonData:>{"Literat.nb", "Porsezian and Lakshmanan-1993"},
    ButtonStyle->"Hyperlink"],
  " in connection with higher-order integrable models. The infinitesimals of \
this higher-order PDE follow from"
}], "Text",
  CellTags->"B\[ADoubleDot]cklund transformations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infPKdV\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] + 6  u[x, t] \[PartialD]\_x u[x, t] + 
            \[PartialD]\_\(x, x, x\)u[x, t] + 
            \[Epsilon]\ 
              \((\(-\[Alpha]\)\ \(u[x, t]\^2\) \[PartialD]\_x u[x, t]\  + \ 
                  \[Beta]\ u[x, t] \[PartialD]\_\(x, x\)u[x, t]\  + \ 
                  \[Gamma]\ \[PartialD]\_x u[x, t] 
                    \[PartialD]\_\(x, x\)u[x, t] + 
                  \[Delta] \[PartialD]\_{x, 5}u[x, t])\) == 0, 
        u, {x, t}, {\[Alpha], \[Beta], \[Gamma], \[Delta], \[Epsilon]}]; 
    infPKdV // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_1 == k1\)},
          {\(\[Xi]\_2 == k2\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], k1], 
        Equal[ 
          Subscript[ \[Xi], 2], k2]}]]], "Output"]
}, Open  ]],

Cell["\<\
This equation allows only a two-dimensional finite symmetry group \
representing translations in the independent variables.\
\>", "Text"],

Cell[TextData[{
  "A model extending the KdV equation by an additional dispersive term of \
second order is discussed by ",
  ButtonBox["Parkes [1994]",
    ButtonData:>{"Literat.nb", "Parkes-1994"},
    ButtonStyle->"Hyperlink"],
  ". This so-called Korteweg-deVries-Burgers (KdVB) equation reads"
}], "Text",
  CellTags->"Korteweg de Vries-Burgers equation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(u\_t\), " ", "+", " ", 
            SubscriptBox[
              StyleBox["uu",
                FontSlant->"Italic"], "x"], " ", "+", " ", 
            \(\[Mu]\ u\_\(x, x, x\)\), "-", \(\[Nu]\ u\_\(x, x\)\)}], "=", 
          "0"}], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[
"where \[Mu] and \[Nu] are real constants. The infinitesimals of (5.56) are"],
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infKdVB\  = \ 
      Infinitesimals[
        \[PartialD]\_t u[x, t] + u[x, t] \[PartialD]\_x u[x, t] + 
            \[Mu]\ \[PartialD]\_\(x, x, x\)u[x, t] - 
            \[Nu]\ \[PartialD]\_\(x, x\)u[x, t] == 0, 
        u, {x, t}, {\[Mu], \[Nu]}]; infKdVB // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k3\)},
          {\(\[Xi]\_1 == k2 + k3\ t\)},
          {\(\[Xi]\_2 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], k3], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ k3, t]]], 
        Equal[ 
          Subscript[ \[Xi], 2], k1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting symmetries of the KdVB equation form a three-dimensional \
group independent of the model parameters. In connection with two-dimensional \
spatial solitons, ",
  ButtonBox["Parkes [1994]",
    ButtonData:>{"Literat.nb", "Parkes-1994"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Ma [1993]",
    ButtonData:>{"Literat.nb", "Ma-1993"},
    ButtonStyle->"Hyperlink"],
  " discussed a two-dimensional KdVB equation of the form"
}], "Text",
  CellTags->{
  "KdVB equation", "two-dimensional spatial solitons", 
    "two-dimensional KdVB equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\((u\_t + u\ u\_x\  + \ \[Mu]\ u\_\(x, x, x\) - \[Nu]\ u\_\(x, x\))\)\_x
          \  + \ \[Sigma]\ u\_\(y, y\) = 0. \)], "NumberedEquation"],

Cell[TextData[{
  "The infinitesimals of this (",
  Cell[BoxData[
      \(TraditionalForm\`2 + 1\)]],
  ")-dimensional equation follow by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf2KdVB\  = \ 
      Infinitesimals[
        \[PartialD]\_x\((
                \[PartialD]\_t u[x, y, t] + 
                  u[x, y, t] \[PartialD]\_x u[x, y, t] + 
                  \[Mu]\ \[PartialD]\_\(x, x, x\)u[x, y, t])\) + 
            \[Sigma]\ \[PartialD]\_\(y, y\)u[x, y, t] == 0, 
        u, {x, y, t}, {\[Mu], \[Nu], \[Sigma]}]; inf2KdVB // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"-", 
                
                StyleBox[
                  \(\(4\ u\ \[Sigma]\ \((\[ScriptCapitalF]\_1)\)\_t - 
                        6\ \[Sigma]\ \((\[ScriptCapitalF]\_3)\)\_t - 
                        2\ x\ \[Sigma]\ 
                          \((\[ScriptCapitalF]\_1)\)\_\(t, t\) + 
                        3\ y\ \((\[ScriptCapitalF]\_2)\)\_\(t, t\) + 
                        y\^2\ \((\[ScriptCapitalF]\_1)\)\_\(t, t, t\)\)\/\(6\ 
                        \[Sigma]\)\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              
              StyleBox[
                \(\(6\ \[Sigma]\ \[ScriptCapitalF]\_3 + 
                      2\ x\ \[Sigma]\ \((\[ScriptCapitalF]\_1)\)\_t - 
                      y\ \((3\ \((\[ScriptCapitalF]\_2)\)\_t + 
                            y\ \((\[ScriptCapitalF]\_1)\)\_\(t, t\))\)\)\/\(6
                      \ \[Sigma]\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "+", 
                RowBox[{
                  StyleBox[\(2\/3\),
                    ScriptLevel->0], " ", "y", " ", 
                  \(\((\[ScriptCapitalF]\_1)\)\_t\)}]}]}]},
          {\(\[Xi]\_3 == \[ScriptCapitalF]\_1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ -1, 6], 
            Power[ \[Sigma], -1], 
            Plus[ 
              Times[ 4, u, \[Sigma], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t]], 
              Times[ -6, \[Sigma], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 3], t]], 
              Times[ -2, x, \[Sigma], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t, t]], 
              Times[ 3, y, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t, t]], 
              Times[ 
                Power[ y, 2], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t, t, t]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Rational[ 1, 6], 
            Power[ \[Sigma], -1], 
            Plus[ 
              Times[ 6, \[Sigma], 
                Subscript[ \[ScriptCapitalF], 3]], 
              Times[ 2, x, \[Sigma], 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t]], 
              Times[ -1, y, 
                Plus[ 
                  Times[ 3, 
                    Subscript[ 
                      Subscript[ \[ScriptCapitalF], 2], t]], 
                  Times[ y, 
                    Subscript[ 
                      Subscript[ \[ScriptCapitalF], 1], t, t]]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ 2, 3], y, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]]]], 
        Equal[ 
          Subscript[ \[Xi], 3], 
          Subscript[ \[ScriptCapitalF], 1]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "By adding an independent variable to the field ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", the symmetry group of the one-dimensional (1D)-KdVB equation makes a \
transition to an infinite dimensional symmetry group. The two arbitrary \
functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["free",
              FontSlant->"Italic"], "[", "1", "]"}], "=", 
          \(\[ScriptCapitalF]\_1\)}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["free",
              FontSlant->"Italic"], "[", "2", "]"}], "=", 
          \(\[ScriptCapitalF]\_2\)}], TraditionalForm]]],
  " are not restricted by any equation. We note that the symmetry group \
depends on the parameter \[Sigma]."
}], "Text",
  CellTags->"infinite-dimensional symmetry group"],

Cell[TextData[{
  "A last example demonstrates the application to a complex field. In this \
case, the KdV equation finds its application in the asymptotic investigation \
of electrostatic waves of a magnetized plasma. This problem of elastostatic \
waves is discussed by ",
  ButtonBox["Mohammad and Can [1995]",
    ButtonData:>{"Literat.nb", "Mohammad-1995"},
    ButtonStyle->"Hyperlink"],
  ". The complex-valued KdV equation is given by"
}], "Text",
  CellTags->"electrostatic waves"],

Cell[BoxData[
    \(TraditionalForm
    \`\(w\_t\  + \ \[Alpha]\ \((\(\(( | w | )\)\^2\) w)\)\_x\  + \ 
        \[Beta]\ w\_\(x, x, x\) = 0, \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " is the complex field amplitude ",
  Cell[BoxData[
      FormBox[
        RowBox[{"w", "=", 
          RowBox[{"u", "+", 
            StyleBox["iv",
              FontSlant->"Italic"]}]}], TraditionalForm]]],
  ", and \[Alpha] and \[Beta] are real parameters. The representation in real \
field variables ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " is given by"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(u\_t\), "+", \(\[Alpha]\ \((u\^3)\)\_x\), "+", " ", 
        \(\[Beta]\ u\_\(x, x, x\)\), "+", " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SubscriptBox[
                RowBox[{"(", 
                  RowBox[{"\[Alpha]", "(", 
                    SuperscriptBox[
                      StyleBox["uv",
                        FontSlant->"Italic"], "2"], ")"}], ")"}], "x"], "=", 
              "0"}], ","}]}]}], TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(v\_t\), "+", \(\[Alpha]\ \((v\^3)\)\_x\), "+", " ", 
        \(\[Beta]\ v\_\(x, x, x\)\), "+", " ", 
        RowBox[{"(", 
          RowBox[{
            SubscriptBox[
              RowBox[{"(", 
                RowBox[{"\[Alpha]", "(", 
                  SuperscriptBox[
                    StyleBox["vu",
                      FontSlant->"Italic"], "2"], ")"}], ")"}], "x"], "=", 
            "0."}]}]}], TraditionalForm]], "NumberedEquation"],

Cell["The infinitesimals of this system of equations are ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infCKdV\  = \ 
      Infinitesimals[{
          \[PartialD]\_t u[x, t] + \[Alpha] \[PartialD]\_x\((u[x, t]\^3)\) + 
              \[Beta] \[PartialD]\_\(x, x, x\)u[x, t] + 
              \[Alpha] \[PartialD]\_x\((u[x, t]\ v[x, t]\^2)\) == 0, 
          \[PartialD]\_t v[x, t] + \[Alpha] \[PartialD]\_x\((v[x, t]\^3)\) + 
              \[Beta] \[PartialD]\_\(x, x, x\)v[x, t] + 
              \[Alpha] \[PartialD]\_x\((v[x, t]\ u[x, t]\^2)\) == 0}, {u, 
          v}, {x, t}, {\[Alpha], \[Beta]}]; infCKdV // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(k4\ u\)\/3\),
                    ScriptLevel->0]}], "+", \(k1\ v\)}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{
                StyleBox[\(1\/3\),
                  ScriptLevel->0], " ", \((\(-3\)\ k1\ u - k4\ v)\)}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k2", "+", 
                StyleBox[\(\(k4\ x\)\/3\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == k3 + k4\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Rational[ -1, 3], k4, u], 
            Times[ k1, v]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Times[ 
            Rational[ 1, 3], 
            Plus[ 
              Times[ -3, k1, u], 
              Times[ -1, k4, v]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ 
              Rational[ 1, 3], k4, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k3, 
            Times[ k4, t]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
The symmetry group is a four-dimensional discrete group containing \
translations, a rotation, and a scaling transformation.\
\>", "Text"],

Cell["\<\
All the calculations carried out above are collected in the \
following table containing the equation, the symmetries, and the dimension of \
the symmetry group.\
\>", "Text"],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          StyleBox[\(KdV\ type\ equation\),
            FontFamily->"Times"], 
          StyleBox["Infinitesimals",
            FontFamily->"Times"], 
          StyleBox["Dim",
            FontFamily->"Times"]},
        {
          TagBox[GridBox[{
                {\(u\_t + u\ u\_x + u\_\(x, x, x\) == 0\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #]&)], 
          InterpretationBox[GridBox[{
                {\(\[Phi]\_1 == k2\/6 - 2\ k4\ u\)},
                {\(\[Xi]\_1 == k3 + k2\ t + k4\ x\)},
                {\(\[Xi]\_2 == k1 + 3\ k4\ t\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Subscript[ \[Phi], 1], 
                Plus[ 
                  Times[ 
                    Rational[ 1, 6], k2], 
                  Times[ -2, k4, u]]], 
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ k3, 
                  Times[ k2, t], 
                  Times[ k4, x]]], 
              Equal[ 
                Subscript[ \[Xi], 2], 
                Plus[ k1, 
                  Times[ 3, k4, t]]]}]], "4"},
        {
          TagBox[GridBox[{
                {\(u\/\(2\ t\) + u\_t + 6\ u\ u\_x + u\_\(x, x, x\) == 0\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #]&)], 
          InterpretationBox[GridBox[{
                {\(\[Phi]\_1 == \(4\ k3 - 16\ k1\ \@t\ u - 24\ k2\ t\ u + k2\ \
x\)\/\(24\ \@t\)\)},
                {\(\[Xi]\_1 == 
                    k4 + 2\ k3\ \@t + 1\/6\ \((2\ k1 + 3\ k2\ \@t)\)\ x\)},
                {\(\[Xi]\_2 == \((k1 + k2\ \@t)\)\ t\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Subscript[ \[Phi], 1], 
                Times[ 
                  Rational[ 1, 24], 
                  Power[ t, 
                    Rational[ -1, 2]], 
                  Plus[ 
                    Times[ 4, k3], 
                    Times[ -16, k1, 
                      Power[ t, 
                        Rational[ 1, 2]], u], 
                    Times[ -24, k2, t, u], 
                    Times[ k2, x]]]], 
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ k4, 
                  Times[ 2, k3, 
                    Power[ t, 
                      Rational[ 1, 2]]], 
                  Times[ 
                    Rational[ 1, 6], 
                    Plus[ 
                      Times[ 2, k1], 
                      Times[ 3, k2, 
                        Power[ t, 
                          Rational[ 1, 2]]]], x]]], 
              Equal[ 
                Subscript[ \[Xi], 2], 
                Times[ 
                  Plus[ k1, 
                    Times[ k2, 
                      Power[ t, 
                        Rational[ 1, 2]]]], t]]}]], "4"},
        {
          TagBox[GridBox[{
                {\(u\/t + u\_t + 6\ u\ u\_x + u\_\(x, x, x\) == 0\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #]&)], 
          InterpretationBox[GridBox[{
                {\(\[Phi]\_1 == k3\/\(6\ t\) - 2\ k2\ u\)},
                {\(\[Xi]\_1 == k1 + k4 + k2\ x + k3\ Log[t]\)},
                {\(\[Xi]\_2 == 3\ k2\ t\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Subscript[ \[Phi], 1], 
                Plus[ 
                  Times[ 
                    Rational[ 1, 6], k3, 
                    Power[ t, -1]], 
                  Times[ -2, k2, u]]], 
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ k1, k4, 
                  Times[ k2, x], 
                  Times[ k3, 
                    Log[ t]]]], 
              Equal[ 
                Subscript[ \[Xi], 2], 
                Times[ 3, k2, t]]}]], "3"},
        {
          TagBox[GridBox[{
                {\(u\_t + u\ \[Alpha]\ u\_x + \[Beta]\ u\_\(x, x, x\) == 0\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #]&)], 
          InterpretationBox[GridBox[{
                {
                  RowBox[{\(\[Xi]\_1\), "==", 
                    RowBox[{"k2", "+", 
                      RowBox[{"k1", " ", 
                        RowBox[{\(\[Integral]\_0\%t\), 
                          RowBox[{
                            RowBox[{"\[Alpha]", "[", 
                              RowBox[{"\[Epsilon]", " ", 
                                SuperscriptBox["t", "\[Prime]",
                                  MultilineFunction->None]}], "]"}], 
                            RowBox[{"\[DifferentialD]", 
                              SuperscriptBox["t", "\[Prime]",
                                MultilineFunction->None]}]}]}]}]}]}]},
                {\(\[Xi]\_2 == 0\)},
                {\(\[Phi]\_1 == k1\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ k2, 
                  Times[ k1, 
                    Integrate[ 
                      \[Alpha][ 
                        Times[ \[Epsilon], 
                          Derivative[ 1][ t]]], {
                      Derivative[ 1][ t], 0, t}]]]], 
              Equal[ 
                Subscript[ \[Xi], 2], 0], 
              Equal[ 
                Subscript[ \[Phi], 1], k1]}]], "2"},
        {
          TagBox[GridBox[{
                {\(u\_t + k\_1\ u\_x - h\ \((u + x\ u\_x)\) + \n\t
                      k\_0\ \((6\ u\^2\ u\_x + u\_\(x, x, x\))\) == 0\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #]&)], 
          InterpretationBox[GridBox[{
                {\(3\ h\ k\_0\ \[ScriptCapitalF]\_2 + 
                      k\_1\ \((\[ScriptCapitalF]\_1\ \((k\_0)\)\_t - 
                            2\ k\_0\ \((\[ScriptCapitalF]\_1)\)\_t)\) + 
                      3\ k\_0\ \((\(\(\(-\)\(\n\)\) \[ScriptCapitalF]\_1\)\ \
\((k\_1)\)\_t + \((\[ScriptCapitalF]\_2)\)\_t)\) == 0\)},
                {\(\(-\[ScriptCapitalF]\_1\)\ \((k\_0)\)\_t\%2 + 
                      k\_0\ \((\((k\_0)\)\_t\ \((\[ScriptCapitalF]\_1)\)\_t + \
\[ScriptCapitalF]\_1\ \((k\_0)\)\_\(t, t\))\) + 
                      k\_0\%2\ \((\(3\ h\_t\ \[ScriptCapitalF]\_1\) \(\(+\)\(\
\n\)\) \(3\ h\ \((\[ScriptCapitalF]\_1)\)\_t\) + \((\[ScriptCapitalF]\_1)\)\_\
\(t, t\))\) == 0\)},
                {\(\[Xi]\_1 == \[ScriptCapitalF]\_2 + \(x\ \((\
\[ScriptCapitalF]\_1\ \((k\_0)\)\_t + k\_0\ \
\((\[ScriptCapitalF]\_1)\)\_t)\)\)\/\(3\ k\_0\)\)},
                {\(\[Xi]\_2 == \[ScriptCapitalF]\_1\)},
                {\(\[Phi]\_1 == \(-\(\(u\ \((\[ScriptCapitalF]\_1\ \((k\_0)\)\
\_t + k\_0\ \((\[ScriptCapitalF]\_1)\)\_t)\)\)\/\(3\ k\_0\)\)\)\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Plus[ 
                  Times[ 3, h, 
                    Subscript[ k, 0], 
                    Subscript[ \[ScriptCapitalF], 2]], 
                  Times[ 
                    Subscript[ k, 1], 
                    Plus[ 
                      Times[ 
                        Subscript[ \[ScriptCapitalF], 1], 
                        Subscript[ 
                          Subscript[ k, 0], t]], 
                      Times[ -2, 
                        Subscript[ k, 0], 
                        Subscript[ 
                          Subscript[ \[ScriptCapitalF], 1], t]]]], 
                  Times[ 3, 
                    Subscript[ k, 0], 
                    Plus[ 
                      Times[ -1, 
                        Subscript[ \[ScriptCapitalF], 1], 
                        Subscript[ 
                          Subscript[ k, 1], t]], 
                      Subscript[ 
                        Subscript[ \[ScriptCapitalF], 2], t]]]], 0], 
              Equal[ 
                Plus[ 
                  Times[ -1, 
                    Subscript[ \[ScriptCapitalF], 1], 
                    Power[ 
                      Subscript[ 
                        Subscript[ k, 0], t], 2]], 
                  Times[ 
                    Subscript[ k, 0], 
                    Plus[ 
                      Times[ 
                        Subscript[ 
                          Subscript[ k, 0], t], 
                        Subscript[ 
                          Subscript[ \[ScriptCapitalF], 1], t]], 
                      Times[ 
                        Subscript[ \[ScriptCapitalF], 1], 
                        Subscript[ 
                          Subscript[ k, 0], t, t]]]], 
                  Times[ 
                    Power[ 
                      Subscript[ k, 0], 2], 
                    Plus[ 
                      Times[ 3, 
                        Subscript[ h, t], 
                        Subscript[ \[ScriptCapitalF], 1]], 
                      Times[ 3, h, 
                        Subscript[ 
                          Subscript[ \[ScriptCapitalF], 1], t]], 
                      Subscript[ 
                        Subscript[ \[ScriptCapitalF], 1], t, t]]]], 0], 
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ 
                  Subscript[ \[ScriptCapitalF], 2], 
                  Times[ 
                    Rational[ 1, 3], x, 
                    Power[ 
                      Subscript[ k, 0], -1], 
                    Plus[ 
                      Times[ 
                        Subscript[ \[ScriptCapitalF], 1], 
                        Subscript[ 
                          Subscript[ k, 0], t]], 
                      Times[ 
                        Subscript[ k, 0], 
                        Subscript[ 
                          Subscript[ \[ScriptCapitalF], 1], t]]]]]], 
              Equal[ 
                Subscript[ \[Xi], 2], 
                Subscript[ \[ScriptCapitalF], 1]], 
              Equal[ 
                Subscript[ \[Phi], 1], 
                Times[ 
                  Rational[ -1, 3], u, 
                  Power[ 
                    Subscript[ k, 0], -1], 
                  Plus[ 
                    Times[ 
                      Subscript[ \[ScriptCapitalF], 1], 
                      Subscript[ 
                        Subscript[ k, 0], t]], 
                    Times[ 
                      Subscript[ k, 0], 
                      Subscript[ 
                        Subscript[ \[ScriptCapitalF], 1], t]]]]]}]], 
          "\[Infinity]"},
        {
          TagBox[GridBox[{
                {\(u\_t - 6\ u\^2\ u\_x + 6\ \[Lambda]\ u\_x + 
                      u\_\(x, x, x\) == 0\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #]&)], 
          InterpretationBox[GridBox[{
                {\(\[Phi]\_1 == \(-k3\)\ u\)},
                {\(\[Xi]\_1 == k2 + k3\ \((x + 12\ t\ \[Lambda])\)\)},
                {\(\[Xi]\_2 == k1 + 3\ k3\ t\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Subscript[ \[Phi], 1], 
                Times[ -1, k3, u]], 
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ k2, 
                  Times[ k3, 
                    Plus[ x, 
                      Times[ 12, t, \[Lambda]]]]]], 
              Equal[ 
                Subscript[ \[Xi], 2], 
                Plus[ k1, 
                  Times[ 3, k3, t]]]}]], "3"},
        {
          TagBox[GridBox[{
                {\(u\_t + u\^\[Alpha]\ \[Beta]\ u\_x + u\_\(x, x, x\) == 0\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #]&)], 
          InterpretationBox[GridBox[{
                {\(\[Phi]\_1 == \(-\(\(2\ k3\ u\)\/\(3\ \[Alpha]\)\)\)\)},
                {\(\[Xi]\_1 == k1 + \(k3\ x\)\/3\)},
                {\(\[Xi]\_2 == k2 + k3\ t\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Subscript[ \[Phi], 1], 
                Times[ 
                  Rational[ -2, 3], k3, u, 
                  Power[ \[Alpha], -1]]], 
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ k1, 
                  Times[ 
                    Rational[ 1, 3], k3, x]]], 
              Equal[ 
                Subscript[ \[Xi], 2], 
                Plus[ k2, 
                  Times[ k3, t]]]}]], "3"},
        {\(u\_t + 6\ u\ u\_x + 
              u\_\(x, x, x\) + \n\t\[Epsilon]\ \((\(-u\^2\)\ \[Alpha]\ u\_x + 
                    u\ \[Beta]\ u\_\(x, x\) + \n\t\[Gamma]\ u\_x\ u\_\(x, x\) \
+ \[Delta]\ u\_\(x, x, x, x, x\))\) == 0\), GridBox[{
              {\(\[Phi]\_1 == 0\)},
              {\(\[Xi]\_1 == k1\)},
              {\(\[Xi]\_2 == k2\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}], "2"},
        {\(u\_t + u\ u\_x - \[Nu]\ u\_\(x, x\) + \n\t\[Mu]\ u\_\(x, x, x\) == 
            0\), 
          InterpretationBox[GridBox[{
                {\(\[Phi]\_1 == k3\)},
                {\(\[Xi]\_1 == k2 + k3\ t\)},
                {\(\[Xi]\_2 == k1\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[ {
              Equal[ 
                Subscript[ \[Phi], 1], k3], 
              Equal[ 
                Subscript[ \[Xi], 1], 
                Plus[ k2, 
                  Times[ k3, t]]], 
              Equal[ 
                Subscript[ \[Xi], 2], k1]}]], "3"},
        {\(u\_x\%2 + u\_\(x, t\) + 
              u\ u\_\(x, x\) + \n\t\[Sigma]\ u\_\(y, y\) + \[Mu]\ u\_\(x, x, \
x, x\) == 0\), GridBox[{
              {\(\[Phi]\_1 == \(-\(\(4\ u\ \[Sigma]\ \((\[ScriptCapitalF]\_1)\
\)\_t - 6\ \[Sigma]\ \((\[ScriptCapitalF]\_3)\)\_t - 
                          2\ x\ \[Sigma]\ \((\[ScriptCapitalF]\_1)\)\_\(t, \
t\) + 3\ y\ \((\[ScriptCapitalF]\_2)\)\_\(t, t\) + 
                          y\^2\ \((\[ScriptCapitalF]\_1)\)\_\(t, t, \
t\)\)\/\(6\ \[Sigma]\)\)\)\)},
              {\(\[Xi]\_1 == \(6\ \[Sigma]\ \[ScriptCapitalF]\_3 + 2\ x\ \
\[Sigma]\ \((\[ScriptCapitalF]\_1)\)\_t - y\ \((3\ \((\[ScriptCapitalF]\_2)\)\
\_t + y\ \((\[ScriptCapitalF]\_1)\)\_\(t, t\))\)\)\/\(6\ \[Sigma]\)\)},
              {\(\[Xi]\_2 == \[ScriptCapitalF]\_2 + 
                    2\/3\ y\ \((\[ScriptCapitalF]\_1)\)\_t\)},
              {\(\[Xi]\_3 == \[ScriptCapitalF]\_1\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}], "\[Infinity]"},
        {GridBox[{
              {\(u\_t + 
                    3\ u\^2\ \[Alpha]\ u\_x + \[Alpha]\ \((v\^2\ u\_x + 
                          2\ u\ v\ v\_x)\) + \n\t\[Beta]\ u\_\(x, x, x\) == 
                  0\)},
              {\(v\_t + 
                    3\ v\^2\ \[Alpha]\ v\_x + \[Alpha]\ \((2\ u\ v\ u\_x + 
                          u\^2\ v\_x)\) + \n\t\[Beta]\ v\_\(x, x, x\) == 0\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}], GridBox[{
              {\(\[Phi]\_1 == \(-\(\(k4\ u\)\/3\)\) + k1\ v\)},
              {\(\[Phi]\_2 == 1\/3\ \((\(-3\)\ k1\ u - k4\ v)\)\)},
              {\(\[Xi]\_1 == k2 + \(k4\ x\)\/3\)},
              {\(\[Xi]\_2 == k3 + k4\ t\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}], "4"}
        },
      RowLines->True,
      ColumnLines->True]],
  TextAlignment->Left,
  TextJustification->0]], "NumberedTable",
  CellMargins->{{2, Inherited}, {Inherited, Inherited}},
  PageBreakWithin->True,
  TextAlignment->Left,
  TextJustification->0,
  FontSize->8,
  GridBoxOptions->{RowAlignments->Center,
  RowMinHeight->0}],

Cell["\<\
We note that the symmetries of the examined KdV-type equations can \
be quite different in their form. The order of the symmetry groups range from \
two to infinity and the symmetries are far from being always polynomial. The \
collection of these symmetry groups also illustrate that the access to \
symmetries is very simple and that a large number of models can be examined \
within a short period. This is the real power of computer algebra in \
connection with symmetry analysis that the information is available in split \
seconds and that variations of the equation can be checked very \
quickly.\
\>", "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet52.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{658, 668},
WindowMargins->{{11, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->302,
PrintingPageRange->{291, 291},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "The Korteweg-de Vries equation and some Generalizations"->{
    Cell[1739, 51, 434, 6, 49, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 47}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"The Korteweg-de Vries equation and some Generalizations"]},
  "point symmetries"->{
    Cell[2176, 59, 788, 13, 159, "Text",
      CellTags->{
      "point symmetries", "generalizations of the Korteweg-de Vries equation",
         "Korteweg de Vries equation", "KdV equation", 
        "generalized Korteweg de Vries equation", "gKdV equation"}]},
  "generalizations of the Korteweg-de Vries equation"->{
    Cell[2176, 59, 788, 13, 159, "Text",
      CellTags->{
      "point symmetries", "generalizations of the Korteweg-de Vries equation",
         "Korteweg de Vries equation", "KdV equation", 
        "generalized Korteweg de Vries equation", "gKdV equation"}]},
  "Korteweg de Vries equation"->{
    Cell[2176, 59, 788, 13, 159, "Text",
      CellTags->{
      "point symmetries", "generalizations of the Korteweg-de Vries equation",
         "Korteweg de Vries equation", "KdV equation", 
        "generalized Korteweg de Vries equation", "gKdV equation"}]},
  "KdV equation"->{
    Cell[2176, 59, 788, 13, 159, "Text",
      CellTags->{
      "point symmetries", "generalizations of the Korteweg-de Vries equation",
         "Korteweg de Vries equation", "KdV equation", 
        "generalized Korteweg de Vries equation", "gKdV equation"}],
    Cell[2967, 74, 921, 20, 138, "Text",
      CellTags->{"nonlinear physics", "KdV equation", "shallow water waves"}],
    
    Cell[5514, 127, 142, 4, 33, "Text",
      CellTags->{"KdV equation", "nonlinear PDE"}]},
  "generalized Korteweg de Vries equation"->{
    Cell[2176, 59, 788, 13, 159, "Text",
      CellTags->{
      "point symmetries", "generalizations of the Korteweg-de Vries equation",
         "Korteweg de Vries equation", "KdV equation", 
        "generalized Korteweg de Vries equation", "gKdV equation"}]},
  "gKdV equation"->{
    Cell[2176, 59, 788, 13, 159, "Text",
      CellTags->{
      "point symmetries", "generalizations of the Korteweg-de Vries equation",
         "Korteweg de Vries equation", "KdV equation", 
        "generalized Korteweg de Vries equation", "gKdV equation"}],
    Cell[27088, 801, 752, 18, 96, "Text",
      CellTags->{
      "ion-acoustic waves", "multi-component plasma", "gKdV equation", 
        "infinitesimals of the gKdV equation"}]},
  "nonlinear physics"->{
    Cell[2967, 74, 921, 20, 138, "Text",
      CellTags->{
      "nonlinear physics", "KdV equation", "shallow water waves"}]},
  "shallow water waves"->{
    Cell[2967, 74, 921, 20, 138, "Text",
      CellTags->{"nonlinear physics", "KdV equation", "shallow water waves"}],
    
    Cell[5783, 138, 614, 14, 117, "Text",
      CellTags->{
      "shallow water waves", 
        "infinitesimal transformation of the KdV equation"}]},
  "plasmas"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "elastic strings"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "lattice vibrations"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "rotating liquid in a pipe"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "universality"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "dispersion"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "waves"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "interaction of dispersion and nonlinearity"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "soliton"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "localized wave"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "wave of permanent shape"->{
    Cell[3891, 96, 1620, 29, 285, "Text",
      CellTags->{
      "plasmas", "elastic strings", "lattice vibrations", 
        "rotating liquid in a pipe", "universality", "dispersion", "waves", 
        "interaction of dispersion and nonlinearity", "soliton", 
        "localized wave", "wave of permanent shape"}]},
  "nonlinear PDE"->{
    Cell[5514, 127, 142, 4, 33, "Text",
      CellTags->{"KdV equation", "nonlinear PDE"}]},
  "infinitesimal transformation of the KdV equation"->{
    Cell[5783, 138, 614, 14, 117, "Text",
      CellTags->{
      "shallow water waves", 
        "infinitesimal transformation of the KdV equation"}]},
  "finite group"->{
    Cell[7949, 212, 151, 4, 54, "Text",
      CellTags->"finite group"],
    Cell[12591, 366, 385, 11, 75, "Text",
      CellTags->"finite group"]},
  "cylindrical KdV equation"->{
    Cell[8103, 218, 405, 9, 75, "Text",
      CellTags->"cylindrical KdV equation"]},
  "symmetry group of the cylindrical KdV equation"->{
    Cell[8663, 234, 127, 1, 33, "Text",
      CellTags->"symmetry group of the cylindrical KdV equation"]},
  "finite symmetry group"->{
    Cell[10808, 304, 189, 5, 54, "Text",
      CellTags->"finite symmetry group"]},
  "spherical KdV equation"->{
    Cell[11000, 311, 171, 4, 54, "Text",
      CellTags->"spherical KdV equation"]},
  "ion acoustic solitons"->{
    Cell[12979, 379, 525, 10, 96, "Text",
      CellTags->{
      "ion acoustic solitons", "KdV equation for a slowly varying medium"}]},
  "KdV equation for a slowly varying medium"->{
    Cell[12979, 379, 525, 10, 96, "Text",
      CellTags->{
      "ion acoustic solitons", "KdV equation for a slowly varying medium"}]},
  "non-standard dynamics of solitons"->{
    Cell[15497, 454, 1608, 41, 138, "Text",
      CellTags->"non-standard dynamics of solitons"]},
  "infinite-dimensional symmetry group"->{
    Cell[23364, 683, 1105, 31, 138, "Text",
      CellTags->{
      "infinite-dimensional symmetry group", "determining equations", 
        "equations with analytic coefficients"}],
    Cell[39488, 1164, 889, 25, 96, "Text",
      CellTags->"infinite-dimensional symmetry group"]},
  "determining equations"->{
    Cell[23364, 683, 1105, 31, 138, "Text",
      CellTags->{
      "infinite-dimensional symmetry group", "determining equations", 
        "equations with analytic coefficients"}]},
  "equations with analytic coefficients"->{
    Cell[23364, 683, 1105, 31, 138, "Text",
      CellTags->{
      "infinite-dimensional symmetry group", "determining equations", 
        "equations with analytic coefficients"}]},
  "vacuum states of the KdV equation"->{
    Cell[24472, 716, 339, 8, 54, "Text",
      CellTags->"vacuum states of the KdV equation"]},
  "traveling wave solutions"->{
    Cell[26654, 787, 294, 7, 54, "Text",
      CellTags->{"traveling wave solutions", "generalized KdV equation"}]},
  "generalized KdV equation"->{
    Cell[26654, 787, 294, 7, 54, "Text",
      CellTags->{"traveling wave solutions", "generalized KdV equation"}]},
  "ion-acoustic waves"->{
    Cell[27088, 801, 752, 18, 96, "Text",
      CellTags->{
      "ion-acoustic waves", "multi-component plasma", "gKdV equation", 
        "infinitesimals of the gKdV equation"}]},
  "multi-component plasma"->{
    Cell[27088, 801, 752, 18, 96, "Text",
      CellTags->{
      "ion-acoustic waves", "multi-component plasma", "gKdV equation", 
        "infinitesimals of the gKdV equation"}]},
  "infinitesimals of the gKdV equation"->{
    Cell[27088, 801, 752, 18, 96, "Text",
      CellTags->{
      "ion-acoustic waves", "multi-component plasma", "gKdV equation", 
        "infinitesimals of the gKdV equation"}]},
  "long waves"->{
    Cell[29354, 871, 257, 5, 54, "Text",
      CellTags->{"long waves", "perturbed KdV equation"}]},
  "perturbed KdV equation"->{
    Cell[29354, 871, 257, 5, 54, "Text",
      CellTags->{"long waves", "perturbed KdV equation"}]},
  "B\[ADoubleDot]cklund transformations"->{
    Cell[30947, 915, 831, 17, 117, "Text",
      CellTags->"B\[ADoubleDot]cklund transformations"]},
  "Korteweg de Vries-Burgers equation"->{
    Cell[33057, 974, 360, 8, 75, "Text",
      CellTags->"Korteweg de Vries-Burgers equation"]},
  "KdVB equation"->{
    Cell[34744, 1030, 588, 15, 75, "Text",
      CellTags->{
      "KdVB equation", "two-dimensional spatial solitons", 
        "two-dimensional KdVB equation"}]},
  "two-dimensional spatial solitons"->{
    Cell[34744, 1030, 588, 15, 75, "Text",
      CellTags->{
      "KdVB equation", "two-dimensional spatial solitons", 
        "two-dimensional KdVB equation"}]},
  "two-dimensional KdVB equation"->{
    Cell[34744, 1030, 588, 15, 75, "Text",
      CellTags->{
      "KdVB equation", "two-dimensional spatial solitons", 
        "two-dimensional KdVB equation"}]},
  "electrostatic waves"->{
    Cell[40380, 1191, 490, 10, 96, "Text",
      CellTags->"electrostatic waves"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"The Korteweg-de Vries equation and some Generalizations", 64873, 1851},
  {"point symmetries", 65259, 1858},
  {"generalizations of the Korteweg-de Vries equation", 65580, 1864},
  {"Korteweg de Vries equation", 65878, 1870},
  {"KdV equation", 66162, 1876},
  {"generalized Korteweg de Vries equation", 66689, 1887},
  {"gKdV equation", 66974, 1893},
  {"nonlinear physics", 67444, 1903},
  {"shallow water waves", 67599, 1907},
  {"plasmas", 67892, 1915},
  {"elastic strings", 68233, 1922},
  {"lattice vibrations", 68577, 1929},
  {"rotating liquid in a pipe", 68928, 1936},
  {"universality", 69266, 1943},
  {"dispersion", 69602, 1950},
  {"waves", 69933, 1957},
  {"interaction of dispersion and nonlinearity", 70301, 1964},
  {"soliton", 70634, 1971},
  {"localized wave", 70974, 1978},
  {"wave of permanent shape", 71323, 1985},
  {"nonlinear PDE", 71662, 1992},
  {"infinitesimal transformation of the KdV equation", 71811, 1995},
  {"finite group", 71984, 2000},
  {"cylindrical KdV equation", 72165, 2005},
  {"symmetry group of the cylindrical KdV equation", 72305, 2008},
  {"finite symmetry group", 72442, 2011},
  {"spherical KdV equation", 72556, 2014},
  {"ion acoustic solitons", 72670, 2017},
  {"KdV equation for a slowly varying medium", 72856, 2021},
  {"non-standard dynamics of solitons", 73035, 2025},
  {"infinite-dimensional symmetry group", 73177, 2028},
  {"determining equations", 73489, 2035},
  {"equations with analytic coefficients", 73717, 2040},
  {"vacuum states of the KdV equation", 73942, 2045},
  {"traveling wave solutions", 74070, 2048},
  {"generalized KdV equation", 74219, 2051},
  {"ion-acoustic waves", 74362, 2054},
  {"multi-component plasma", 74574, 2059},
  {"infinitesimals of the gKdV equation", 74799, 2064},
  {"long waves", 74999, 2069},
  {"perturbed KdV equation", 75130, 2072},
  {"B\[ADoubleDot]cklund transformations", 75275, 2075},
  {"Korteweg de Vries-Burgers equation", 75418, 2078},
  {"KdVB equation", 75536, 2081},
  {"two-dimensional spatial solitons", 75741, 2086},
  {"two-dimensional KdVB equation", 75943, 2091},
  {"electrostatic waves", 76135, 2096}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 434, 6, 49, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 47}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"The Korteweg-de Vries equation and some Generalizations"],
Cell[2176, 59, 788, 13, 159, "Text",
  CellTags->{
  "point symmetries", "generalizations of the Korteweg-de Vries equation", 
    "Korteweg de Vries equation", "KdV equation", 
    "generalized Korteweg de Vries equation", "gKdV equation"}],
Cell[2967, 74, 921, 20, 138, "Text",
  CellTags->{"nonlinear physics", "KdV equation", "shallow water waves"}],
Cell[3891, 96, 1620, 29, 285, "Text",
  CellTags->{
  "plasmas", "elastic strings", "lattice vibrations", 
    "rotating liquid in a pipe", "universality", "dispersion", "waves", 
    "interaction of dispersion and nonlinearity", "soliton", "localized wave",
     "wave of permanent shape"}],
Cell[5514, 127, 142, 4, 33, "Text",
  CellTags->{"KdV equation", "nonlinear PDE"}],
Cell[5659, 133, 121, 3, 29, "NumberedEquation"],
Cell[5783, 138, 614, 14, 117, "Text",
  CellTags->{
  "shallow water waves", 
    "infinitesimal transformation of the KdV equation"}],

Cell[CellGroupData[{
Cell[6422, 156, 175, 3, 27, "Input"],
Cell[6600, 161, 258, 8, 30, "Output"]
}, Open  ]],
Cell[6873, 172, 55, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[6953, 176, 118, 2, 45, "Input"],
Cell[7074, 180, 860, 29, 75, "Output"]
}, Open  ]],
Cell[7949, 212, 151, 4, 54, "Text",
  CellTags->"finite group"],
Cell[8103, 218, 405, 9, 75, "Text",
  CellTags->"cylindrical KdV equation"],
Cell[8511, 229, 149, 3, 44, "NumberedEquation"],
Cell[8663, 234, 127, 1, 33, "Text",
  CellTags->"symmetry group of the cylindrical KdV equation"],

Cell[CellGroupData[{
Cell[8815, 239, 274, 5, 80, "Input"],
Cell[9092, 246, 1701, 55, 111, "Output"]
}, Open  ]],
Cell[10808, 304, 189, 5, 54, "Text",
  CellTags->"finite symmetry group"],
Cell[11000, 311, 171, 4, 54, "Text",
  CellTags->"spherical KdV equation"],
Cell[11174, 317, 142, 3, 44, "NumberedEquation"],
Cell[11319, 322, 55, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[11399, 326, 271, 5, 80, "Input"],
Cell[11673, 333, 903, 30, 75, "Output"]
}, Open  ]],
Cell[12591, 366, 385, 11, 75, "Text",
  CellTags->"finite group"],
Cell[12979, 379, 525, 10, 96, "Text",
  CellTags->{
  "ion acoustic solitons", "KdV equation for a slowly varying medium"}],
Cell[13507, 391, 352, 9, 29, "NumberedEquation"],
Cell[13862, 402, 381, 10, 54, "Text"],

Cell[CellGroupData[{
Cell[14268, 416, 445, 9, 81, "Input"],
Cell[14716, 427, 766, 24, 65, "Output"]
}, Open  ]],
Cell[15497, 454, 1608, 41, 138, "Text",
  CellTags->"non-standard dynamics of solitons"],
Cell[17108, 497, 403, 10, 30, "NumberedEquation"],
Cell[17514, 509, 531, 20, 54, "Text"],

Cell[CellGroupData[{
Cell[18070, 533, 414, 9, 81, "Input"],
Cell[18487, 544, 4862, 136, 135, "Output"]
}, Open  ]],
Cell[23364, 683, 1105, 31, 138, "Text",
  CellTags->{
  "infinite-dimensional symmetry group", "determining equations", 
    "equations with analytic coefficients"}],
Cell[24472, 716, 339, 8, 54, "Text",
  CellTags->"vacuum states of the KdV equation"],
Cell[24814, 726, 166, 3, 26, "NumberedEquation"],
Cell[24983, 731, 437, 12, 75, "Text"],

Cell[CellGroupData[{
Cell[25445, 747, 315, 6, 63, "Input"],
Cell[25763, 755, 706, 23, 57, "Output"]
}, Open  ]],
Cell[26484, 781, 167, 4, 54, "Text"],
Cell[26654, 787, 294, 7, 54, "Text",
  CellTags->{"traveling wave solutions", "generalized KdV equation"}],
Cell[26951, 796, 134, 3, 29, "NumberedEquation"],
Cell[27088, 801, 752, 18, 96, "Text",
  CellTags->{
  "ion-acoustic waves", "multi-component plasma", "gKdV equation", 
    "infinitesimals of the gKdV equation"}],

Cell[CellGroupData[{
Cell[27865, 823, 279, 6, 45, "Input"],
Cell[28147, 831, 975, 32, 93, "Output"]
}, Open  ]],
Cell[29137, 866, 214, 3, 54, "Text"],
Cell[29354, 871, 257, 5, 54, "Text",
  CellTags->{"long waves", "perturbed KdV equation"}],
Cell[29614, 878, 1330, 35, 31, "NumberedEquation"],
Cell[30947, 915, 831, 17, 117, "Text",
  CellTags->"B\[ADoubleDot]cklund transformations"],

Cell[CellGroupData[{
Cell[31803, 936, 620, 12, 82, "Input"],
Cell[32426, 950, 466, 16, 57, "Output"]
}, Open  ]],
Cell[32907, 969, 147, 3, 54, "Text"],
Cell[33057, 974, 360, 8, 75, "Text",
  CellTags->"Korteweg de Vries-Burgers equation"],
Cell[33420, 984, 356, 9, 29, "NumberedEquation"],
Cell[33779, 995, 104, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[33908, 1001, 296, 6, 63, "Input"],
Cell[34207, 1009, 522, 18, 57, "Output"]
}, Open  ]],
Cell[34744, 1030, 588, 15, 75, "Text",
  CellTags->{
  "KdVB equation", "two-dimensional spatial solitons", 
    "two-dimensional KdVB equation"}],
Cell[35335, 1047, 183, 3, 30, "NumberedEquation"],
Cell[35521, 1052, 150, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[35696, 1061, 391, 8, 64, "Input"],
Cell[36090, 1071, 3383, 90, 131, "Output"]
}, Open  ]],
Cell[39488, 1164, 889, 25, 96, "Text",
  CellTags->"infinite-dimensional symmetry group"],
Cell[40380, 1191, 490, 10, 96, "Text",
  CellTags->"electrostatic waves"],
Cell[40873, 1203, 167, 3, 30, "NumberedEquation"],
Cell[41043, 1208, 522, 19, 54, "Text"],
Cell[41568, 1229, 536, 14, 30, "NumberedEquation"],
Cell[42107, 1245, 495, 13, 30, "NumberedEquation"],
Cell[42605, 1260, 67, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[42697, 1264, 544, 9, 81, "Input"],
Cell[43244, 1275, 1394, 46, 127, "Output"]
}, Open  ]],
Cell[44653, 1324, 148, 3, 54, "Text"],
Cell[44804, 1329, 185, 4, 54, "Text"],
Cell[44992, 1335, 17484, 452, 668, "NumberedTable",
  PageBreakWithin->True],
Cell[62479, 1789, 627, 10, 159, "Text"],
Cell[63109, 1801, 148, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

