(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5549,        150]*)
(*NotebookOutlinePosition[      7396,        204]*)
(*  CellTagsIndexPosition[      7292,        198]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  CounterBox["Section"],
  ".",
  " List of Key Symbols Used in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 1}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)},
  CellTags->"List of Key Symbols Used in Mathematica"],

Cell[TextData[{
  "This section summarizes some key symbols used in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The compiled list contains the main shortcuts for symbols used in the  \
text."
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        TagBox[
          StyleBox[GridBox[{
                {"Abbreviation", \(Function\ description\)},
                {"=", "assignment"},
                {"==", \(used\ in\ equations\)},
                {"===", \(equality\ testing\)},
                {":=", 
                  RowBox[{\(function\ definition\), "\n", 
                    RowBox[{
                      StyleBox["lhs",
                        "TI"], " ", 
                      StyleBox[":=",
                        "MR"], " ", 
                      RowBox[{
                        StyleBox["rhs",
                          "TI"], " ", "assigns", " ", 
                        StyleBox["rhs",
                          "TI"], " ", "to", " ", "be", " ", "the", " ", 
                        "delayed"}], "\n", 
                      RowBox[{"value", " ", "of", " ", 
                        RowBox[{
                          StyleBox["lhs",
                            "TI"], "."}]}]}]}]},
                {"/;", \(conditional\ \((provided\ that)\)\)},
                {"\[Rule]", \(rule\ assignment\)},
                {\( :> \ \(or\  \[RuleDelayed] \)\), 
                  \(delayed\ rule\ assignment\)},
                {"x_", 
                  RowBox[{
                  "pattern", " ", "matching", " ", "to", " ", "free", " ", 
                    "variable", " ", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]},
                {"x__", 
                  RowBox[{
                  "sequence", " ", "of", " ", "symbols", " ", "named", " ", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]},
                {"x___", 
                  RowBox[{
                  \(sequence\ of\ zero\ or\ more\ expressions\), "\n", 
                    RowBox[{"named", " ", 
                      StyleBox["x",
                        FontSlant->"Italic"]}]}]},
                {"/.", \(under\ the\ rule\ ReplaceAll\)},
                {\(#\ or\ \ #1\), \(slot\ in\ a\ pure\ function\)},
                {\(\((#)\)&\), \(pure\ function\ definition\)},
                {
                  StyleBox["**",
                    FontColor->RGBColor[0.250004, 0, 0.250004],
                    Background->RGBColor[0.996109, 0.996109, 0.500008]], 
                  \(non\[Hyphen]commutative\ multiply\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              ColumnWidths->{6, 20},
              RowAlignments->Baseline,
              ColumnAlignments->{Center, Left},
              RowLines->{True, False},
              ColumnLines->True,
              ColumnsEqual->False,
              MultilineFunction->Automatic],
            FontColor->RGBColor[0.250004, 0, 0.250004]],
          (TableForm[ #]&)],
        Background->None], TextForm]], "Text",
  TextAlignment->Left,
  TextJustification->0],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"ReadMeFirst.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
WindowSize->{657, 668},
WindowMargins->{{81, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->487,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Appendix", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Appendix", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "List of Key Symbols Used in Mathematica"->{
    Cell[1739, 51, 506, 12, 53, "Section",
      CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 1}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"List of Key Symbols Used in Mathematica"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"List of Key Symbols Used in Mathematica", 6924, 187}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 506, 12, 53, "Section",
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 1}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"List of Key Symbols Used in Mathematica"],
Cell[2248, 65, 219, 6, 54, "Text"],
Cell[2470, 73, 2909, 69, 390, "Text"],
Cell[5382, 144, 151, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

