(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    799794,       9983]*)
(*NotebookOutlinePosition[    806806,      10170]*)
(*  CellTagsIndexPosition[    805923,      10141]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["11", "ChapterLine",
  CounterAssignments->{{"Title", 10}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell["Appendix", "Title",
  CounterAssignments->{{"Title", 10}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[CellGroupData[{

Cell[TextData[{
  CounterBox["Section"],
  ". Marius Sophus Lie: A Mathematician\[CloseCurlyQuote]s Life"
}], "Section",
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)},
  CellTags->"Marius Sophus Lie: a mathematicians life"],

Cell["\<\
Born: Nordfjordeide, Norway, 17 December 1842
Died: Christiania (Oslo), Norway, 18 February 1899.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000;R000400P10`40000100000000E@00ZP00o`0T
000TE@0TZP0To`190019E@19ZP19o`1]001]E@1]ZP1]o`2B002BE@2BZP2Bo`2f002fE@2fZP2fo`3K
003KE@3KZP3Ko`3o003oE@3oZP3oob@002@0EB@0ZR@0ob@T02@TEB@TZR@TobA902A9EBA9ZRA9obA]
02A]EBA]ZRA]obBB02BBEBBBZRBBobBf02BfEBBfZRBfobCK02CKEBCKZRCKobCo02CoEBCoZRCoodT0
04T0EDT0ZTT0odTT04TTEDTTZTTTodU904U9EDU9ZTU9odU]04U]EDU]ZTU]odVB04VBEDVBZTVBodVf
04VfEDVfZTVfodWK04WKEDWKZTWKodWo04WoEDWoZTWoofd006d0EFd0ZVd0ofdT06dTEFdTZVdTofe9
06e9EFe9ZVe9ofe]06e]EFe]ZVe]offB06fBEFfBZVfBofff06ffEFffZVffofgK06gKEFgKZVgKofgo
06goEFgoZVgooi800980EI80ZY80oi8T098TEI8TZY8Toi990999EI99ZY99oi9]099]EI9]ZY9]oi:B
09:BEI:BZY:Boi:f09:fEI:fZY:foi;K09;KEI;KZY;Koi;o09;oEI;oZY;ookH00;H0EKH0Z[H0okHT
0;HTEKHTZ[HTokI90;I9EKI9Z[I9okI]0;I]EKI]Z[I]okJB0;JBEKJBZ[JBokJf0;JfEKJfZ[JfokKK
0;KKEKKKZ[KKokKo0;KoEKKoZ[Koom/00=/0EM/0Z]/0om/T0=/TEM/TZ]/Tom]90=]9EM]9Z]]9om]]
0=]]EM]]Z]]]om^B0=^BEM^BZ]^Bom^f0=^fEM^fZ]^fom_K0=_KEM_KZ]_Kom_o0=_oEM_oZ]_oool0
0?l0EOl0Z_l0oolT0?lTEOlTZ_lToom90?m9EOm9Z_m9oom]0?m]EOm]Z_m]oonB0?nBEOnBZ_nBoonf
0?nfEOnfZ_nfoooK0?oKEOoKZ_oKoooo0?ooEOooZ_oooa9400=XA6P00VP4A003J4A400E400=XA4@0
4d@00bA4A007A00594A4A2@024@00bA4A00QA00394A4009400<TA4@0:D@29003A2@T008T0d@39004
A2@T909400<TA2@00R@4A00494@T91940R@6A00494A490I400<TA4@044@00fQ4A006A004J4AXJ1U4
0VP3A004J4A4A09X0d@00fQ4A002A09X14@3J0A40VP018Q494@290M400<TA4@04d@590=400<TA2@0
5d@290E40b@<A0@T14@590U40R@00d@T9002A005J4A4A2@00d@00fQ4A003A004J4A4A08T1D@59094
00<TA2@052@00d@T900O9003A2@T008T00=494@052@00d@T900=90940R@00fQ49002A0hT00=492@0
1B@00d@TA0069003A2A400<T00=492@00T@29003A2@T00/T2d@018Q4J6P2A00494A490943R@2A003
94@T008T00=492@00T@012A4A2@2A00494@T90=40R@2A00394A400I400IXA2@TA2@3A00394A4008T
14@1900074@00fQ4A005A005J4A4A6P034@00fQ4A00;A08T1D@00bA4A009A003J4A400M40VPAA003
94A400=400<TA4@054@00bA4A00CA00394A400=40R@01D@T94@T00940R@00d@TA00290M400<TA4@0
0d@00bA49006A00594A4A2@014@00bA4A0039003A2@T00A40b@BA003J4A400A400=XA4@06d@00fQ4
J005A0=X0d@00fQ4A002A003J4A400A400=XA4@00fP00dAXJ002A00394A400U400=XA4@00T@01FQ4
A4AX00=400<TA4@01D@390=40R@;A00494@T90a400<TA4@00T@00bA4A007A004J4A490E400<TA4@0
24@01VQ4A4AXA08T1D@00fQ4A005A0AX0d@4J09400=XA4@00VP390E44B@01D@T92A400@T0T@690=4
32@00d@T900M90944R@2A0<T14@89005A2@T94@022@3A0@T0d@E90940R@4A003J4A400A400EXR6QX
R002J0A40b@00d@T900<9003A2@T00HT0T@490=40R@01d@T92A494@00R@9A08T0T@290=400<TA4@0
1D@002=40VPAA003J4@T00=400AXA4@T1T@012A4A2@2A003J4A400]400=XA4@01D@00fQ4A00;A003
J4A4021400<TA4@01T@016Q4A2@6A00394A400940R@2A00394@T009400@TA2@T1T@290M400@TA2@T
0T@00bA4A008A00394A400=40R@3A08T1D@00bA4A002A003J4A400=40R@6A005J4A4A2@00T@00fQ4
A004A003J4A400Y400=XA4@03D@3J003R6Q400E40VP00dAXA006A003R6R8009X00=4R6P02D@016Q4
A6P2A003J4AX009X0d@00fQ4A004A00394A400HT0T@00bA49003A003J8QX00=400<TA4@02d@00bA4
A008A00394A400940VP490A400<TA4@01d@00fQ4A0029003A2@T00U40VP2A003R4AX00=X0d@3R09X
00F8J4B8J00=A00494A4A0PT00=492@00d@39003A2@T01@T00=492@05B@00d@T90049003A2@T01HT
1D@:9005A2@T94@022@01D@T94@T00=45R@01D@T92AX00E40R@5A004J4A4R0E40b@00d@T90039005
A2A494@01R@2A0XT1D@01RA492A490M400AXA4A40R@2A00394A4008T00E494A49004A0008d@2J0E4
00>8A6P034@00bA4A004A08T1D@00bA4A00;A003J4A400=400=XA4@014@00fQ4A00;A003J4A400M4
0VPIA00394A400M400<TA2@03D@00bA49005A00394A400E400<TA4@024@00bA49002A00394A400a4
00<TA4@00T@00bA4A00>A08T24@00fQ4A003A004J4A4J0=40VP<A003J4A400Q40VP2A0EX0d@00fQ4
J002J09416P3A0:800IXA4AXA6P5A004J4A4A09X00=4J4@00T@3J0Y400<TA4@00d@390Q400IXA6QX
A2@DA003J4A400=400<TA4@014@490Y400<TA4@00d@690Q416P00dAXR002J003R6Q400EX0hP016Q4
J6P7A0<T00=492@00R@00d@T900;909400@TA4A40b@00d@T90069003A2@T02HT0T@29003A2@T014T
0T@2J00394@T01XT0T@00bA4900=90=41b@00d@TA006A00394A400A40fP00dAXJ003A0`T00E492@T
A00890=400<TA2@00R@014@TA2@2A08T1D@00fQ4A005A00394A400<T1d@00bA4A00190007T@00bA4
A003A003J4A400=400=XA4@01d@00fQ4A00:A00394A401i400=XA4@04D@00bA4A00IA0<T00=494@0
0T@290M40R@7A00494A490=400<TA4@014@00bA4A00?A00394A400Q400@TA4@T14@290Y40R@3A08T
00A492@T2d@00fQ4A003A004R4A4A0=X2D@2J0M400=XA4@00d@00fQ4A002A004J4AXJ0A40VP2A003
J4A400E400=XA4@00T@4J0=400=XA6P01d@3J0A400AXA4AX0T@00bA49002A00594A4A2@02T@2J006
A2A4A6R80fP3A004J4A4J0A40fP00d@TA007A00394A4008T2D@00bA4A004A0HT00=4J6P01D@026R8
J4AXA6R80VP018QXJ8`4J0>80VP2R003J4A400I41R@00d@T900690941R@3A00394@T00=41B@5A08T
0T@012A494@99003A2@T00lT00=494@00R@2A0PT00=492@022@2A003R6Q400LT0T@:9003A2@T00DT
0T@@909400<TA2@02b@00d@TA009A003J4AX00=X0d@;909400<TA2@02b@014@TA4@39003A2@T008T
00=494@014@00fQ4A006A00494@TA08T1d@290008d@2J1e400<TA4@00T@00bA4A00:A003J4A400i4
00=XA4@01T@00bA4A00IA003J4AX00I400<TA4@00T@00bA49004A00594A4A2@01T@00bA4A006A08T
2d@00fPTA006A00394A400e40b@5A08T1T@29003A2@T00<T5T@00fQ4A002A0EX1d@2J0Y400=XA4@0
0T@00fQ4A002J003R6Q4009400=XR6P00VP3A09X1d@2J0=400=XA4@01D@01fQ4A4AXA6P024@39003
A2@T008T1D@290=400>8A4@01T@2J003A6Q400AX0T@9J0A40VP7A003J4A400=400IXA4A4J2@=A09X
14@3J003A6QX00:800IXR8R8J:`2R003J8R<009X18P6A004J4A4A0TT1D@012A4A4@7909400=XA4@0
0T@590=41b@3A0@T00=492@03B@2A0LT1T@A9003A2A400=472@2A0hT14@49003A2@T00TT2d@2J0E4
00<TA4@012@2A10T00=492@01R@2A08T1D@00bA4A008A0PT0T@01BA4A2A4004T000TA003J4A400=4
00=XA6P034@00bA4A004A00394A401I40VP4A09X4T@00fQ4A00KA00394A4009400@TA4@T1D@29003
A2A400I40R@014@TA2@2A00494A490I400=XA4@02T@00bA4A00<A00394@T00@T0T@00bA4A003A005
94@T94@00R@00d@TA00<A09X24@2J0A40fP6A00394A400U400AXA4AX1d@2J003A6QX00AX00A4J4A4
16P00hQ4A008A09X64@39003A2A400M40VP00dB8R002J0=400MXR6Q4J4B800=X0T@4J006R6QXA6Q4
0fP2R003J4AX00=X00=4R6P00T@2J005R4A4A6P02D@00fQ4A003A003J4A400=40VP8R003S8R/00:8
0VP5R003S6Q400E400<TA4@00T@29003A2@T008T0d@69005A2@TA2@00T@00bA4A003A0DT00Q494A4
94@TA0@T0d@49004A2@TA0`T0T@890A46B@00d@T900@9003A2@T01LT0d@>90940R@8A003J4AX0094
0VP3A0`T00E492@TA00<9003A2@T008T1D@490A40b@3A0<T00Q494A494@TA08T0D@002140b@00dAX
A006A003J4A400i40VP:A00394A400i400=XA4@00T@2J0Y400=XA4@02d@00fQ4J00EA00494A4A08T
00=494@03T@00bA49002A0<T00=492@00d@00bA4A003A003J4A400M400<TA2@014@00bA4A006A0HT
00=492@01d@390E400<TA4@034@00fQ4A007A0AX0T@2J0M400<TA4@03D@2J0=400EXA4A4J002R0A4
1FP3A004R4A4A09X1D@00fQ490029003A6QX019400<TA2@01D@2J0=400B8J4A40hP5J0>800EXR8QX
A004J0:800J<A6QXR6P4R003S6QX00:800=XR4@00XP01FQ4A4AX00]400>8A4@01D@00fQ4A003A09X
0XP00hb8R002S004R8b<[0>800=XR:`00X`2R09X00A4R4A40R@00dAXA002A00394@T00E412@00d@T
900390941B@3A0@T00A492A40R@3A0<T0d@49003A2@T00940b@014@T94@49004A2@TA0PT14@H9003
A2@T010T0T@J9003A2@T00LT0T@39003A6Q4008T1T@5J005A6Q4A2@00T@L90940b@6A0<T00=4J4@0
0d@49004A2A490941R@1A04T000CA00394A404=400=XA4@024@00fQ4A00<A003J4AX01]400@TA4A4
0R@6A08T0T@00bA49006A00594A4A2@00d@2909400<TA4@00d@00fQ4A004A00794A4A2A49003A003
94@T00Q400<TA2@00d@00bA4A002A003J4A400Q400<TA4@00d@00bA4A007A003J4A400E41FP2A00:
J4A4J4@TA2A4909400=XA4@01D@01FQ4A4AX00A40VP3A003J8QX00=400B8J4A40VP3A005J4A4A6P0
0T@00bAXA003A0<T00E4J4A49008A00494A4J0E40R@00dAXJ002A007J4A4A6R8J002A005J8b8R6P0
18P2J006A6QXJ4AX0XP016R8S8P2J003A6QX00:<0hP00fR8R002R09X00B8J6Q41FP00dAXA004A09X
0T@01FQ4A4B800940VP3A003J8R800:800F/S:b/S004[007S8R8S<b<[002R0IX0R@014AXA6P3A08T
14@:90941R@5A00494A490M400<TA4@00d@39003A2@T00DT00=492@012@3A0/T0d@/9003A2@T01PT
0T@39003A2@T00HT14@490=40VP2A09X2D@00bA490039003A2@T00LT00E492@TA0029003A2@T00=4
0b@3A005J4A4A2@01T@290940R@01D@T94@T00=40R@1A04T000NA00394@T02I400<TA4@00T@290]4
00=XA4@00d@00bA4A00@A00494A4J0E40VP7A003J4A400Y400<TA4@05d@00bA49004A0<T44@012A4
A2@2A00394A400U40R@014@T92@3A00394A4009400=XA4@014@2J0Q40VP3A004J4A4J0I400AXA4A4
0fP00dAXJ002A00394A400e400AXA4A40fP4A005J8QXJ8P00VP014AXJ6P?A004J4A490940b@2A08T
1T@00bA4A002A003J4A400A40R@01DAXA2A400=X00B8J6R80VP5R003J8R8009X0XP016Q4A8P2J006
R6QXR4AX0T@2J0:800=XR6P00fP4A09X00A4R6QX0T@2J09416P3A004R4A4A0EX00R8J8R8S8R<[0:<
00>/J8P00Z`3S0:80h`01Jb<S8R<009X0XP016Q4A6P>A0<T0T@29003A2@T00=40R@5A08T00=494@0
1T@290I41b@2A0TT00=492@022@00d@T900W9003A2@T01PT00E492@TA00490E41B@7A08T00E494A4
J004A08T0T@00fQ4A002A08T00E492@TA00:9005A2@TA2@00T@29004A2A4909400<TA4@00d@00bA4
A006A00494@TA08T00=492@00R@2A00394@T004T000KA00394A4015400=XA4@03d@00bA4A00EA003
R4A400=400<TA4@01D@01FQ4A4@T02]412@?A00394A4009400PTA4@TA2A490Y400<TA4@01d@290a4
0R@6A00394A400940VPBA004J4A4J0E400EXA4A4J002A0>800=XA4@00d@00fQ4J002J0=400=XA4@0
16P3A09X1D@018QXJ4@4J003R4AX00=400<TA4@01D@00bA4A00;A08T0d@290940R@5A08T0T@490=4
0VP014B8J4@;J006R6QXJ8QX0T@00fR8J006J0=40VP01DAXR8QX00Q40VP5A004J4A4J0:80fP014B8
J6P3A003J4AX00B80X`018R<R8`2R003J:b<00F<18P01Hb8R8Q400AX0d@3J0U400<TA4@00b@2A003
94@T008T00=492@01b@2A0<T00A494A40b@4A0DT00=492@00T@69003A2@T03LT00=492@05b@00d@T
900790=41R@4A0<T0T@390e43R@00d@T900@90I40R@7A00394A400=40R@014@T94@390540B@1A000
7d@3J0e400>8J4@00d@012A4A2@8A00394@T01E400EXA4A4J009A003J4A402m400<TA4@03D@00bA4
A006A00394A403Q40VPDA003J4AX00=400EXR8R8J006A09X00E4J4AXA002J003A6R800=X2D@00fR8
J002J004A6QXJ2140R@4A00394A400Q40R@014@TA6P4A0EX0d@018QXA4@3J003A6Q400=X00R8J6R8
J4AXR0=400EXA4A4R002J003A6QX00A40VP6A005J4AXR8`00VP2R007J4B8J4AXA002J00:R6R8J8R/
S:b8S0:818`01Jb8S:b<00:800=XR8P00hP016Q4A:`4A09X14@00fQ4A007A00394@T00=412@3A0@T
00A492A41B@8A0DT1T@590941R@2A0TT00=492@092@3A1<T00=492@03B@2A0HT0T@490U400=XA4@0
2d@79003A2@T00A42B@2A00394@T00=41R@2A00394A400940R@2A0DT0T@490540B@1A0007D@00bA4
A00?A09X3D@00bA4A002A00494@T92A400=XA4@01T@00bA4A00;A003J4A401I400DTA4A49002A004
94A4A0@T4D@00bA4A00?A00394A400a400EXA4A4J007A005J4A4A6P03d@01RA4A6R8J0=400F8A6QX
A003J0A400=XA4@00T@2J0E40VP2R003J4A400=X1D@2J0=400AXA6QX4T@390A400<TA4@01B@4A0DT
0d@590M400AXA6R80fP014AXJ8P2J003A6QX009X1D@00fR8J003J003R6QX00=40VP4A0=X14@3J0=4
0fP00dB8R003R0AX0XP3J004R8b8R09X0XP00hb8R002J003R8b<00>80h`3R004J4B8R0AX00=4R6P0
3T@290=40b@4A0<T0T@<9004A2@T90I400<TA4@00R@2A08T1D@00bA4A00L90=46b@00d@T900T9003
A2@T00<T0T@890U400=XA4@014@01BA4A2A400<T00=492@00R@2A00494A4A0PT00I494@TA2@4A0<T
00=494@014@290=40R@00d@TA002A00394@T00940B@0031400=XA4@00T@290E400<TA4@014@00bA4
A00QA0=X3d@00fQ4A00OA08T2D@00bA4A010A09X00E4J6Q4J00<A00494A4J0:81FP4A0=X0d@2J0A4
0VP00dAXJ002J0B80fP2R0IX00>8J6P00VP00dAXJ002A00394A400a41B@3A08T00=492@00b@2A0<T
00E492@TA0029004A2@T90A40R@014AXA4@4J0M400=XR6P00T@00fQ4A002A09X00=4J6P016P3A0=X
00B8J4AX0d@2J0=400EXA4AXR003J005R6R8J8P00X`2R003J8aX009X0XP4J0:800IXR8QXR6P3R09X
00B8S8b<0XP014B8R8`2R0:<0VP00dAXA002J007A6Q4A2A49003A0<T00=492@00b@5A0lT0T@390=4
00<TA2@012@2A0DT00=492@05B@00d@T90069003A2@T00/T00=492@03B@00d@T900c9006A2A4A2A4
0R@3A00594A4J4@00R@2A08T0d@69004J4A4A0<T00=494@00R@4A0@T00=492@012@6A0<T00M492A4
94@T00E40R@1A0002T@00fQ4A007A005J4A4A6P05T@2J0]400<TA4@014@00bA4A006A00394A401U4
00=XA4@01T@00fQ4A004A003J4A401Q400EXA4A49005A00394A400E400<TA4@02T@00bA4A007A003
J4A400a400=XA4@04d@00bA4A006A0=X00B8J4AX0T@00fQ4A003A003J4A4009400AXA6QX0XP2A09X
14@00fQ4A002A09X0T@2J0:81FP00hR<J002J003A6R/00:80VP2R003J8R800MX2d@290A412@3A0dT
00E492@TA00:909400<TA4@02D@3J004A6Q4A09X0T@2J0:816P6A003J4A4009X0d@4J0E400=XR8P0
0fP01HQXJ6R<00:/0XP00hb/R002R005S:b/R8`01XP016R8J6P4R004S8R<[0:80VP00hR<S00:R003
A6QX00940b@6A0DT1D@490940b@3A08T14@00bA4J006A08T14@012A492@2A0PT00=492@00R@00d@T
900290=400@TA4A43B@00d@T90049003A2@T008T00=492@0@B@2A0<T00A494@T0T@00fQ490029003
A2@T00DT0d@00bA4A004A08T00=492@00R@2A0<T0d@00bA4900290]400@TA4A41B@00d@T9002A000
5D@00fQ4A007A003J4A401i400<TA2@01D@00bA4A00>A09X4T@00fQ4A003A003J4A400E400=XA4@0
2d@00bA4A00<A08T00=494@034@290I40R@3A00394A400E400=XA4@00d@00fQ4A004A003J4A40094
00=XA2@02D@00fQ4A007A00394AX00=400=XA4@02D@02bA4A4AXR6R8J8R/00=X2d@00fR8J003J0:<
1FP01HQXJ4AX00F800EXR8R<R002S0=X0XP00fQ4A00?A0DT0d@<90A400@TA2A41b@2A08T1D@2J094
00AXA6QX1D@2J09400EXR8b8J003R003J4A400941VP014AXJ8P3J003A6Q400940VP2R005J8R8J4@0
0VP2S0>800B/R6QX0XP2S00<R8b8R8c<[8QXA6Q40VP3S005R:b8R6P018P01:aXS:`5R0=400EXA4A4
9004A00394A400<T1d@01BA494AX009400<TA4@00d@290E400=XA4@01D@3909400<TA2@012@00d@T
900390940b@3A08T0d@29007A2@T94@TA00:909442@00d@T900;9003A2@T01dT00=492@01B@00d@T
900290940b@00d@T9003909400=XA2@02R@2A0<T00=4J6P00d@39003A2@T00LT00=492@00R@5A003
94@T00<T14@00bA4A00790540005A003J4A400a400=XA6P00T@00fQ4A00ZA003J4A400]400=XA4@0
0T@2J0I400=XA4@03d@00fQ4A003A003J4A400=400=XA4@01d@00bA4A00=A0@T14@00bA4A004A003
94@T00I40R@@A09X1D@00fQ4A00;A005J4A4A6P01T@01VQ4A2A4J09400AXA4A40VP2A0=X0T@012A4
A6P3R09X00>8[8P00fP;A09X0T@3J0A40fP00dAXA003J0J800=XR6P016P8A00494A490E41b@2A003
94@T00XT14@29003A2@T00@T1D@290=400=XA4@00T@2J0=400<TA4@00T@2J003A6QX00:800=XR8P0
0fP014AXJ6P2A09X1HP01FR8J4AX00941VP3R0=X00B8S8R<0Z`02XQXJ6R8S:b8J8`2R005[8b<J4@0
16P01hb8R8R<R6P00h`6R003[6R800:800=XA4@016P6A003J4A400U400@TA4A40VP6A00494@T90a4
1B@00d@TA00;9005A2@TA2@00d@01BA4A2A400/T00=492@012@3A0HT00=492@0;2@00d@T90059003
A2@T00<T00=492@00b@00d@TA00390941B@3A0HT0T@012A4A4@29003A2A400E40b@01D@T92A400@T
0T@290U400@TA2@T0T@00bA49002A08T0T@00bA4A00190004T@4J0=40VP3A0=X00>8J4@07T@00bA4
A003A003S8Q400i400=XA4@02d@00fQ4A009A003R6Q400a400=XA4@05d@290=40R@QA09X0T@3J0e4
00=XA4@01d@2J09400<TA6P00T@018Q4A4@2R0]40VP2R003A6Q400e40VP3A003J4A4009400=XA4@0
0d@2J0=40VP018b8A6P3A005R6QXA6P02T@390A44R@00d@T900390=400<TA2@012@7A00494A4A0=X
0T@00hQXA005A007J8Q4R4AXR005J003R6QX00AX0T@00hR<J002J006R6QXJ4AX0T@2J003S8QX00:8
0VP01XQXJ6R8[0B800YXR8R<[8R/R6R80VP028R/S6Q4R6R80X`3R006S8R8R8b80h`00fR<J002J0:8
00AXA4A416P=A08T14@00bA4900:A00394A400I400=XA4@00d@99003A2@T00DT0d@390M400<TA4@0
1R@5A0@T00=494@00T@00bA4A003A0<T00=492@062@00d@T900=9003A2@T008T00=492@03b@00d@T
90049004A2@T90=400<TA4@00R@5A0<T24@39003A2A4009400@TA2@T44@290940R@2A0@T0T@19054
000CA09X0T@2J004A6QXA0=X00=4J4@00T@00fQ4A00FA00394A400A400<TA4@01D@00bA4A009A003
J4A400I40VP3A0:81D@026Q4A6Q4J4AX0T@2J0M400=XA4@00d@00bA4A00AA00694@T94@T0T@59003
A2A400e400=XA4@024@2J0941FP4A003J4A4011400=XA4@014@00fQ4A002A003J8Q400]40fP8A003
94A400A400MXA4A4J4AX00Q40fP4A003J8QX00A400=XA6P00VP=A0@T0T@00bA4900E909400<TA2@0
22@00d@TA002A003J8QX009X00>8J4@00XP00fQ4A003J004R6QXR0AX0d@018QXA4@3J003R4A400=4
0fP8A003J8R<009X00B8J6R80VP01Xb8J6R8J0:80h`00fR8R002J0>800AXS6QX14@2J0:80j`01Xb8
R:b8J0>800AXR8R80VP8A09X2D@590A400<TA6P00VP<A00394@T00A400=XA4@012@4A0@T0d@890=4
00<TA4@00d@790E400<TA2@00T@00bA4A007A00394A4048T14@00bA4A00490941R@5A0<T0T@012A4
A2@4A00394A4009400@TA2@T0T@290E400=XA6P014@012A494@79003A2A4008T000CA003J4A400E4
00AXA4AX3D@00fQ4A002A00394A401A400=XA4@01d@00hQXA002A003J4AX00=400=XA4@01d@2R003
J4A400940VP00dAXA002A003J4A4009X0T@00fQ4A002A0=X0d@00bA4A00:A00394A400=40R@3A08T
14@00bA4A002A003J4A4009400<TA4@02T@00fQ4A004A0=X24@4J0Y40VPHA003J4A4011400<TA4@0
1d@00fQ4J002A003J4A400A40VP5A003J8QX00E400=XR6P01D@00fQ490089003A2@T01@T00A492@T
0T@;90A400=XA6P00XP00fR8J003J008R6QXJ8QXR6P3R004S6QXJ09400=XA4@00T@01VR8R6Q4J094
0fP00dAXA006A0:80VP00hQXJ002R0=X00E4J:b8[003S004J8QXA0B80VP2R003[8R800EX00V8[8b/
R6Q4J8P01FP018QXR4@2J006A2A4A2A40R@4A003J4A400A41B@9A003J4AX009400=XA4@014@390Q4
0b@014@T92@2A0`T00A494@T0T@012A494@69004A2A4A08T2D@016Q4A6P5A1HT00=492@06B@00d@T
90079003A2@T008T00A4J6Q40R@00d@TA003A0TT0T@2909400<TA4@01D@39003A2A4008T0d@00bA4
900290A400=XA4@00d@290940R@00d@T900490=40B@002a400=XA4@01d@2J0Q400<TA4@00d@29094
00<TA4@01D@00hQXA002A003J4A400940VP2A004J4A4A0AX00>8A4@014@2J0A40VP;A003R6Q400M4
00=XA4@00T@00bA4A006A00394A4009400<TA4@01D@00bA4A005A00494A4A09X3T@00fR8J006A09X
00A4J6QX0T@2J003A6Q400E400=XA4@00d@00fQ4A00;A003J4A400A400=XA4@014@39006A2A494@T
2d@2J0=400=XA4@01D@2J0=400=XA6P014@00hQ4A008A00394@T00HT00=492@052@014@T92@2A003
94@T00941B@4A09X0T@3J0:816P2R005J8R8J8P00VP018aXR6P3A003J4A400=400=XA4@00fP2A09X
00=4J4@014@01VQ4J6Q4R09X0XP02:aXA6R8J:b80X`00hR/R003J00:R:aXS8QXR8b8S0F80VP2S0:8
00=XA6P00hP00fR8R002R09X00R8J4A494AXA0<T2T@012A492@;A09X14@00fQ4J002A08T14@01BA4
A4AX00940b@6A0<T0d@00bA4900490=40R@014@T94@6909412@4A004J4AXJ0U400<TA4@01R@2A0@T
0T@690943b@00d@T90089003A2@T00<T0d@59004A2@T909400<TA2@00T@990940R@8A0DT14@00bA4
A00290940R@4A003J4A4009400@TA4A412@00d@T900390=40B@001M400=XA4@01d@00fQ4A009A003
J4A4011400DTA4A4J006A00394A400E400=XA4@034@5J0A40VP3A003J4A400940fP4A003J4A40094
00AXR8QX2D@2J0m400<TA4@014@29003A2A4019400<TA4@01T@00fQ4A007A0IX2T@00fQ4A004A003
94A400M40VP6A003J4A4009400AXA4@T4D@01VR8R6Q4J0M41FP00dAXA004J0a400<TA2@05R@00d@T
900;9004A2@TA08T00=494@00T@2J005A8QXJ8P00VP2R006J4AXS6R80VP00hR<J002J0B800=XA4@0
0VP7A003J8R800=416P4A09X00=4J6P00fP00dB8R002R09X00B8[8R80j`2S0>80VP7R003[8R800B8
00AXR8R<0VP00dB8S002R0><0XP00hb8J00?A09X0T@39006A2A4A2AX1T@00fQ4A005A003J4A400I4
0R@014AXJ4@29003A2A4009400<TA4@00b@2A08T00=492@012@5A08T00=492@012@3A08T0T@2J005
A6QXA6P01d@012A494@79003A2A4008T0d@69003A2@T01XT00E492A49002A08T00=492@01B@2A0HT
0T@49003A2@T00U41R@014@TA2@5A00494A4A08T0d@00fQ4A005A00394@T008T0T@39004A2A4A04T
000GA0=X3T@016Q4A4@2J0U400=XA4@03D@01fQ494@TA2@03D@00fQ4A00;A09X1T@00fQ4A002A004
J4AXR09X1D@3J0Y400=XA4@064@29004A2@TA08T0d@00fQ4A004A00394A400]400MXA4A4J4B800EX
0T@00bA4A005A003J8a400I400=XA4@01D@016Q4J6P2A09X54@00bA4A002J003A8QX00AX1T@016Q4
J4@9J003A6Q400a41B@00d@T900F90943R@3A003J4AX009X0XP6J003R6QX009X00A4J6Q41VP014AX
A4@2J0A40fP00hQXJ007A005J4AXA6P00T@2J0940fP2R004J8R<S0:/00?<[8`00X`2R003S8R<00>8
0X`2R003S8R800:<00>/J6P00hP016R8S8P3J004R6QXR0AX1d@01fQ4A4@TA2@00d@00bA4A006A09X
0d@2J09416P018QXA6P2A0:800=XA6P01T@00bA4A004A0<T14@:9004A2A4909400<TA2@00b@?A09X
00=4J6P01D@790=400<TA2@014@29003A2@T00DT00=492@082@00d@T900=9003A2@T00A400<TA2@0
1B@2A08T00=492@00d@00bA4A005A08T00=494@00d@016Q4A4@290Q40b@01D@T92A4004T0007A09X
1d@016Q4J6P4A09X14@00fQ4J009A004J4A4J0M400@TA6QX2D@00fQ4A00[A003J4A400E40fP7A004
J4A4A09X00M492A494AX01]412@<A08T0d@00bA4A00<A0=X0d@00fQ4A003A00594A4A2@00T@2J0=4
00=XA6P03T@2J0A40VP00d@TA006A00394A400=400=XA6P016P2A09X2T@01FQ4A6Q400=X00E4J6Q4
J007A00394A400TT00=492@01B@00d@T900<90942R@4A003R6QX00=X00>8J4@01FP00dAXJ003J0A4
16P00dAXA003J004R6QXA09X0hP5J005R4AXJ8P00fP3A003J4A4009X00A4R8b/18P018b8J6P3R004
J4B8S0:/00B8[:b<0XP2S0:800>/S8`00XP2J003R6R8009X00=4R8P00VP2A003J4AX00940VP3A003
J4AX00=400<TA4@01D@00bA4A003A003J4A400AX0T@4J0=400AXA6R80VP00hQXA009A00394@T00E4
1B@00d@T900390940R@2A00394@T00<T4T@00fQ4A006A0<T1D@290=40R@01D@TA2A400DT00=492@0
1B@2A10T00=492@03B@2A0LT00A492@T1d@39003A2@T00A40R@00d@TA00?A007J4A4A2A49003A0<T
1d@2905400000fQ4A004A09X1D@00fQ4J002A003J4A400=X4d@2J2940fP5A09X5T@00fQ4A002A003
J4A400i400>8J4@02d@00fQ4A00BA00394@T00=400<TA4@0;d@01FQ4A4AX00]400EXA6Q4J003A003
J4@T00A40R@2J0A40R@00dAXA005A09X14@2J0I400QXA4B8J4AXA09X00=4S8P01FP00dAXA004A003
94@T00lT00A494A40R@2A0`T14@290E416P2A006R4AXA6Q40fP014AXJ4@2J0=400=XR4@00d@5J005
R6QX[6P00XP3J09400F8J4B8J003R003S4A400IX0XP4S003c:b/00:800=XR8P00d@02VR8R8R/R<b<
J8`5R00;[8R8J4AXS6Q4J4@016P00dAXA002J0Q400=XA4@00d@00bA4A004A08T1d@2J004R6QXJ0A4
00=XA4@00VP3A09X0XP00dAXA006A08T1d@890E40R@3A0DT4T@00hQXA009A00394A400Q400HTA4A4
94@49003A2@T00HT00=492@00R@00d@T900F9004A2@TA0@T00=492@01B@3A0<T0T@390M40b@4A08T
44@00bA49009A00594@TA2@00D@00003J4A400A400=XA4@014@2J0=400EXA4A4J00@A003J4A40094
00=XA4@07d@3J0M416P:A003J4A4009400=XA4@01D@2J0m40fP:A0=X2T@390A400<TA2@00b@00d@T
900BA00394A4029400=XA4@02T@00fQ4A003A003J4A400=40R@2A003J4A4009400@TA2AX2D@29094
00=XA4@014@2J005[8R8J4@00fP01HQXR8QX00:800=XR6P01D@=9003A2@T00DT00=492@00R@00d@T
900990E40R@00d@TA002A09X00=4J6P00d@02FQ4A6Q4J4AXA004J005A6QXR6P01D@2J0=40VP018QX
J4@3J003A6QX009400EXR6QXA002J003A6Q400AX00>8J6P00XP01Jb<[8b8009X0XP2J0V800><R:`0
0X`00fR<R003J0>800=XR8P00XP2J0940fP8A003J4A401940VP014AXA6P4A003J4A400I40fP4A004
J4A4A0@T1D@:90I40R@00d@T9002A08T2d@00bA4A003A004J8R8J0Q400DTA4A49002A00394A400E4
0b@01D@T92A400DT00E492@TA00O9003A2@T00/T0T@390=40R@00d@TA004A0<T0d@390e400<TA4@0
1T@39003A2@T00I400000fQ4A006A09X24@016Q4A4@2J0M400=XA6P01D@2J0Y40fPIA09X0T@00bA4
A003A09X3d@3J003S4A400M400=XR4@01d@00fQ4A007A004J4A4J0=400=XA4@02D@29003A2A400=4
00<TA2@00d@00bA4900JA00494@T91A400MXA6Q4J4AX00I400EXA6Q4J005A003J4A400I41FP4A0=X
0T@690=400><A4@014@2J0>81FP00dAXR002J0A400=XA4@014@<90945B@00d@T9002A00394A400M4
16P6A0=X00A4J6R80VP2A003J8R800IX0T@00fR8J003J0940fP00hQ4J002A004J4AXA0IX00E4J6QX
A005J003S8R800IX00><R:`00hP3S0F80X`2J0>800=XR8P00XP016R8R8P4A003J4A400Q400=XA6P0
24@290A40R@BA09X1d@2J09400DTA4A49005A00594@T94@012@5A0@T00=494@01D@00fQ4A003A004
94AXJ0=40VP014AXR6P2A003J4A4009400@TA4@T0T@012A4A2@4A00594A4A6P02b@00d@T900Q9003
A2@T00@T00=492@012@4A08T1T@00bA4A003A00494@T90940R@014@TA2@2A00594@TA2@00T@00bA4
A005A08T00=494@014@390540002J1e416P7A003J4A4029400AXR4AX1d@00fQ4A00LA003J4A400I4
00=XA4@014@2J003A6QX00=X0d@00fQ4A004A00394@T009400<TA4@02T@012A4A2@=A003J4A400Y4
00<TA4@01T@01FQ4A4AX00]400AXA6Q40VP4A0IX1T@4J0E400=XA4@00fP3A09X0d@69003A6Q400E4
1fP02HQXJ4AXA6R8J009A1XT00=492@022@014@T96P2A00394A400I400=XA6P00VP4A0AX0T@4J094
0hP2J003R6Q400AX0XP01VR<R4AXR0=X00Q4J8QXR6R8A0IX00F8A6QXA005J004R6QXA0=X0d@2J004
R6QXJ0:800N<R8R8J8R<00=X0XP00fQ4R003J0:800=XA4@01D@00bA4A00>A09X00=494@01d@01BA4
A4@T00]40fP<A00394@T00<T00=492@00R@5A00394@T00@T0T@00bA49003A08T1T@01VQ4A4AXA0MX
1T@00bA4A003A00394A4008T0d@59003A6PT00<T00=492@01b@00d@T900N9003A2@T00PT0d@00bA4
A00590=40R@2A00394A400=400@TA2A40R@00d@T9006A00394@T00Q400<TA4@00b@5A08T0002J1I4
00=XA4@014@016Q4J6PJA00594A4A6P01d@00fQ4A003A003J8Q400M40fP@A09X1d@00fQ4A00BA003
J4AX00AX0T@2J0A400<TA4@00d@390]400DTA4A4J002A08T7T@00fQ4A003J0e400=XA4@00d@00fQ4
J002J003A6Q400941VP4A004R4AXJ09400=XA6P00T@2J0940R@5A003J4A400Q416P00dAXA002J004
A6R8J0M43B@00d@T900E9003A2@T00<T1D@00bA4A004J0A400=XA6P00T@2J0E400AXR6Q40fP00hb8
J004J003A6QX009X0XP5A0IX0XP2J005A6QXS8P016P018R/J6P2A007R4A4A6Q4R003A0=X0d@01HQX
J6Q400EX0T@2J09400J8J4AXS8P2J005A2A494@00R@AA003J4A400A40VP3A00394A400A40R@5A003
94A400I400<TA4@014@69004A2@T90E41R@2A004J4@T90A400<TA4@00T@2J0:81T@00fR8J003J0e4
00<TA4@014@29003A2A400U400<TA2@0:2@2A0HT0d@7909400<TA2@00R@2A004J4A4A08T14@290I4
0VP2A00394A400940R@00d@T9003A0<T0T@00bA4900190000VPFA003J4A400I400=XA4@03T@00bA4
A00HA0IX0d@2J003A6QX00I40fP9A005R4A4A2@01D@3J09400=XA4@03d@3J0=400=XA4@024@390M4
00<TA4@00R@2A00394A4008T00=494@05D@00bA4A006A0=X2T@00fQ4A006A0=X00=4J6P00T@00fQ4
J003J004R6Q4J0=400=XA4@00d@01FQ4J6R800]400=XA4@02D@2J005R4AXA6P00T@00fR8R003J004
A6Q4A0DT00=492@05R@2A0dT0d@29003A6QX009X14@00fQ4A003A003J4A400=400=XR6P00fP3R094
0VP5A0=X14@016Q4R8P3J0:80VP01TAXR8QXR09X0hP00fQ4A002A0MX0T@2J0:80fP00hQXA002A09X
00>8J6P00T@2J003A6QX009400>8J6P00T@00bA490039003A2A4009400=XA4@014@29003A6QX00a4
00<TA4@014@29003A2@T00940R@8A00394A400940b@3A0@T0T@290940b@7A08T1T@3J005R8b8R6P0
1D@2J005A6QXR6P02D@00bA4A007A00594@TA2@00d@290I40b@2A08T00=492@062@00d@T90079003
A2@T00XT00A494A40R@00d@T9003A08T1D@00bA49003A003J4A400Y40R@014@TA2@2A08T00I492@T
A2@1A0006d@00fQ4A003A09X6d@00bA4A007A003J4A400M400=XA4@02d@2J1E400=XR6P00T@2J114
0fP5A003J4A400M400=X94@014@00bA490049003A2@T009400<TA2@00R@6A00594A4A6P01d@00fQ4
A00;A09X14@2J0e400AXA4AX0T@02VR8J6Q4J:b<J4@2J003A6QX00I40fP018Q4A6P8A005J4A4A6P0
1T@2J003A6QX009X00>8J6P00T@00fR8S008A2HT00A494@T1T@01VR8A6R8J0E400=XA4@00fP2A0=X
14@2J0A400AXA6QX2T@00hQXJ002J0940VP00hQXJ002A09X00>8J8P00VP3A0eX00>8J6P00VP4A09X
00B8S6QX0T@2J003R4AX009400=XA6P00T@990Q40b@>A004J4A4A08T1D@4909400@TA4A41R@7A003
94@T008T0d@49003A2A4009400<TA4@012@6A0:800B/d:b<18P00fQ4J003J0940VP3A09X14@00bA4
A007A00394@T008T00=492@00R@5A08T14@59003A2@T02/T1D@490A400DTA4A49002A08T4T@012A4
A2@3A00394A400=40R@1A00064@4J0M400=XA4@06T@290U400=XA6P01D@00bA4A004A09X00=4J4@0
14@00fQ4A005A003J4A4009400<TA2@014@016R8A6P9A00394A400A400<TA4@02T@00fQ4A002A003
94A400=40R@5A08T0T@01RA494@TA0<T1T@00bA4A00HA0=X00=4J4@00VP2A003J4A400aX00I4J8R8
J4@2J003[8R800=X0T@016Q4J6P;A00494@T90E400AXA4@T0T@01FQ4A4B800=X00A4J6QX0T@016R8
J6P7A08T00=492@06B@00d@T90069004A2A490A40fP00hQXJ003J0=41fP2A0:816P6A0=X00=4R6P0
1FP2R005A6R8R6P00hP00haXJ002J004R6QXS0:80h`018QXJ8`2R0=400=XR8P00VP018QXA6P2R0=X
18P3S0>800EXA4AXA002J004A6Q4J0940R@4A0HT14@290A400@TA4A40VP2A003J4A400E40b@4A0HT
14@39004A2@T90I41b@00d@T900490=400DTA4A49003A00394A4009X0hP2[0B81FP00dAXJ00;A004
J4AXJ0Y40R@00d@T900290941B@4A08T00=492@0;b@2A00494@TA0<T1D@39003A2@T00A40R@<A08T
0T@39003A2@T009412@1A0002T@00fQ4A005A003J4A400=40VP2R0M400=XA4@00T@00fQ4J008A003
J4A400M400<TA4@01D@00bA4A00DA005J8aXJ4@00VP00dAXJ00AA003R6QX009X1T@00fQ4A00BA0:8
2d@290U422@4A00394A400=400<TA4@054@4J005R6QXJ4@00fP00hQXR002J003S6QX00>800=XA8P0
0VP3A09X00F8S8QXA002J0M400=XA6P01d@012A492@6A00694A4J4AX0T@3J0E40VP2R003A6QX00A4
00=XA2@01B@00d@T90029003A2@T00/T00=492@032@5A006J4AXR6R80fP00dAXJ002J006A6R<J8b/
0hP2J003R6R800A416P2R004J4AXA0AX00>8J4@00T@01VR8A6R8J0=40fP00jb8S002R0:<00F/J6R<
R002J0:80Z`00fR8J003J0>80fP2S004[8R8[0B<00>8J4@00T@2J0940VP00dAXA003A09X00A494A4
0R@00dAXA008A004J4AXR0=400>8J4@01D@390A400<TA2@034@390A40R@:A0<T0T@290E400<TA4@0
0T@4R006[8b/[8b81FP014AXJ6P3A0=X1D@00fQ4J002J0e40R@014@TA4@590=400DTA2@TA00290=4
0R@014@TA4@=9003A2@T00LT00A492@T0T@49003A2@T00940b@3A0<T0d@590I400<TA4@00T@00bA4
9007A00394A400I400@TA2A40R@00003J4A401540VP3A0AX5D@00fQ4A008A08T1T@00bA4A008A003
J4A400E400IXA4A4J8P4J003A6QX009X4D@016R8R6PJA09X00>8J4@02D@00bA4A004A08T00=492@0
0b@00d@T900290A400<TA4@00T@390E400<TA4@034@4J0:80VP00dAXJ003R0AX00>8J8P00XP01FQ4
A6R800A40XP5J0E400=XA4@00T@2J0=400<TA4@01T@016Q4J4@29004A6QXJ0940VP00hQXA003A0AX
00>8J4@00VP4A0/T0T@K90Q40VP00hQXJ003A0AX00A4R6QX18P016Q4R8P4J0=400N8J6R8J8QX0094
0VP00hQXJ00=J008R6R8R:b<R8`2[003R8b<00>800B/S8R80fP00hQXJ002R003J4AX00=X0XP2S0:/
00B<[8QX0T@00fQ4J00@A08T0d@00fQ4A007A09X0T@2J003R4A400A40R@2A0@T00=494@01d@00bA4
9003A00594@T94@00R@3A00394A400E40R@7A0<T14@016R8R8P2[003c:b<009X0d@00fQ4J003J003
A6QX00=X00A4J4AX0T@00fQ4A004J0a400DTA2@TA0049003A2A4008T00=492@00R@2A0DT00=492@0
52@2A0HT00=492@01B@01d@T92A494@00b@014@T92@2A08T0T@290M40R@6A08T00E494A49002A08T
00A492@T0D@000M400=XA4@02T@3J0=40VP;A003J4A400Q40VPLA004J4A4A09X00>8J4@014@5J003
R6QX009X2D@016R8J6P4A0=X0T@290A400<TA4@03T@00fQ4A003A09X34@49003A2@T00=40R@014@T
92@5A00394@T01Q400AXA6Q416P00hQXJ002A0EX00A4J8QX1d@00fQ4J003J003A6QX00A400AXA4A4
0VP5A0<T0d@2J0A400=XA2@00T@016R8A4@2J0=400EXA4A4J004A004J4A4J0A49R@4A00394A400I4
0fP00dAXA004J005A6QXJ4@00VP2A003J4AX00=X00A494A416P2R005J4A4J8P01FP2A003J4A400=4
00>8J8P00VP018R/[8`2R0B/00>8[:`00Z`6R004J8R<R09X00B8J6R80h`01=2/[:`2S003R4A400i4
00=XA4@00d@29003A6Q400940fP00dAXJ006A003R6Q400Q41R@2A00394A400A40b@5A0<T0d@00bA4
A005A0DT00=XA4@00T@290M418P01Zb<J8b8J0E400=XA4@00VP014AXJ6P3A0MX00=4J6P01D@00bA4
A006A0@T0d@01RA492A4909422@00d@T900N90941R@00d@T900490941B@5A0<T2D@00bA4A006A08T
1T@49054000JA003J4A402Q400=XA4@02T@01FQ4A4AX00=400=XA4@01D@3J005A6Q4A6P01T@00fR8
J002J1Q400<TA4@024@00fQ4J00;A00394@T00A400<TA2@01D@00bA4900OA09X00A4J4A40fP00hQX
J004A0=X00E4J6Q4J006A0IX0T@016Q4J4@2J0A400>8A4@00T@00bA4A003A09X2d@2J0I400IXA4AX
A2@4A003J4AX00A40R@00d@TA00J9006A2@T94@T14@29003A6R8009400AXA6QX0XP3J003A6QX0094
0VP00dAXJ009A00394A400A40VP2R003A6QX00=40VP3A003J4A400=400MXA6R8[6R/00;@0hP018b/
R8P4[0>800Z<R8R8J8QXA6R80VP00hR<[002[004S:b<R09X1d@00fQ4J004A00394A400=400DTA2A4
J003A006J8QXJ8QX14@016Q4A6P;A00394@T00<T14@01RA494@TA0TT00A492@T0T@29005A2A494@0
0R@5A00394@T00=400N8J4AXR8b800><00B8S8QX1d@016Q4A4@3J0940VP2A005J8QXJ4@00VP7A005
J4A4A6P02D@00bA4A00390=41R@00d@T900990=41B@2A0hT00A492A42R@3A08T00A494@T2D@00fQ4
A002A00594A4A6P014@00bA4A005A0<T0D@190002T@00fQ4A003A09X7T@00fQ4A002J0Y40VPOA005
J4A4J8P00fP00dAXJ003J0I40VPAA004J4AXJ0U400IXA4A4J4@2J0U40R@2A00394@T00<T0T@590Q4
00=XA4@00d@00fQ4J00;A003J4A400=400=XA6P00VP2A0EX0d@8J004A6Q4A0=X00B8J6QX1T@2J0Q4
0b@5A0=X00E4J6Q4J002A00394A400Q400AX94A40b@3A004J4A4J0940b@00d@TA0069003A2@T00DT
00=492@03R@9A003J4AX00=X00=4J8P01FP018Q4R6P>A00394A4008T00E4J6Q4J006A003J8Q400=4
00=XA6P00VP3A0:800EXS=2/S002R003S:b<00>80Z`01HR<R8QX00:800IXR6QXA6P3R005S:b/R:`0
0X`3J0E400=XA6P00VP7A003J4A400<T2d@390]400<TA4@00d@390M40R@5A0/T0d@00bA4A0029003
A2A400A41b@2A005J8R8S8P00X`01:b<R6P>A09X0T@00fQ4A002J0A40VP3A09X00=4J4@02d@290M4
00<TA2@00T@29004A2@T909400<TA2@00b@00d@T90099003A2@T00DT00=492@03R@00d@T9002A0<T
14@012A4A2@2A0:81d@2J0E400@TA2A40R@3A08T0D@0009416P4A003J4A400941VP01DAXA4AX0114
0VP4A003J4A4019400<TA4@06T@00fQ4J002J003A6QX009X00>8J4@01D@2J003A6Q400i400=XA6P0
2T@026Q4A6Q4J8QX2D@39004A2A490E41B@@A003J4A400E400AXA4A40VP2A003J4B800=400=XA6P0
1FP2A0=X00B8J6R80VP2A09X00F8J8QXA003J09400IXA6R8A6P7A08T1D@2J0940VP01HQXJ4@T00=4
00=XA4@03d@3J0=49B@:A09X0XP01fR8J6R8J8P00fP00dAXJ002J0M400<TA4@00T@00bA4A006A09X
1D@2J09400=XA6P00T@01FQ4A4AX00>81:`01Hb8R:b<00:/00F8c<b/S004R007J8QXR6Q4J004R0B/
00><R8P00XP00fQ4A005A003R4A400=40R@5A0<T0T@00fQ4A002A0HT44@290M400@TA2@T1D@00bA4
9002A0@T0T@00fQ4A006A08T1T@00bA4A004A004J8R8[0:800B<R6R80VP8A00494A4J09400=XA4@0
2T@00fQ4A003A003J4A400Y400<TA4@00R@3A08T0T@00bA4A00290a40R@01D@T92A400@T0T@79003
A2@T00@T00=492@00d@00bA49002A08T0T@390A400<TA4@00T@2J003R6Q400A400=XA4@02T@01RA4
A2A49054000@A003J4A400=400=XA4@01D@00fQ4A00[A00394A400m400=XA4@01D@00fQ4A004A003
J4A402Q40fP5A08T0T@49003A2A400<T00=494@012@6A00494A491E40VP00hQ4J004A0EX00E4J4A4
J003A003J8QX009X14@4J09400AXA4A41FP00hQXJ004A003J4A4009400EXA4A4J002A09X2D@3J0I4
00AXA4A40VP2A09X0d@69003A2@T01dT0T@39003A6QX00AX18P8J09400=XA4@02T@29005A2@TA2@0
14@2J0I400=XA4@024@00fR8R002R008S:c@d:b8S:`3S0:/00Z<[:b<R:aXR6R816P4R005[8c@c:`0
0X`3R0U400AXA4A412@3A0<T1T@012A4A2@3A08T1T@390E40R@3A003J4@T00HT0T@:90I400<TA4@0
0T@590=40b@4A09X00B8J8R80X`01Jb8R8b8009X1T@00bA4A00EA09X1D@00bA4A00>A08T0d@29003
A2A400E400DTA4A49002A08T0T@<9003A2@T00TT00=492@00R@2A00494A4A0<T00=492@024@2J094
00=XA4@00T@00fQ4A002A08T1d@29094000@A003J4A400940VP7A003J4A402E400<TA4@06D@016Q4
J6P3A003J4A401I400=XA4@00d@3J1E400<TA4@00d@590941B@2A00394A4008T14@290]40VP2A004
94A4J0A400=XA4@00d@3J005R6QXJ4@01FP00dAXJ003A09X00=4J6P00VP7A09X00=4J6P00VP5A0=X
1T@00fQ4A00<A005R6QXA6P00T@4J005A6QXA6P014@29004A2@TA0LT00=492@01R@00d@T900>9003
A2@T00940hP01fR8A6R8[6P00XP2J003R8b<009X0T@00fQ4A00;A08T0d@00bA4A006A09X34@2J003
R6QX009X00J/c=2<R8`4[003c:b/00>/00B8S8R80fP01HR/R8QX00:800><[<`00Z`2S0>800EXA4@T
A003J09400AXA4@T0T@00bA4A00490A40VP3A0=X3D@012A4A4@39004A6QXA08T0T@49004A2A4A0@T
00=492@00d@49004A2@TA0/T00I494A4J8P3J003[8R800><00>8S8P00fP<A003J8QX00=400<TA2@0
1d@2J09412@4A00394A400A400HTA4@TA2@4A00494A4A08T00=494@012@6A003J4A4009400HTA2@T
A6P29003A2@T00<T00=492@02R@4A08T14@290Q416P3A09X14@00bA4A002A00694A4A2A40R@00114
0VP2A0=X;d@290E40R@CA0=X6D@016Q4A6P7A09X1D@4J0=40VP8A00494A4A0LT0T@49006A2@T94@T
4D@00fQ4A005A0AX0T@<J0941FP00dAXA002A09X0d@00fQ4A00;A003J4AX00=X2D@01HQ4A4AX00]4
0fP00dAXJ003A0=X00A4J6QX14@00bA4A00G9005A2@T94@02b@4A003R6QX00940VP2R09X00I4R8R8
J4@3J0=400<TA4@03d@00fQ4A003A003J4A400]40fP2A09X00>8c8`00XP2S003[8c<00:/0XP01Zb8
J6R8J0:81FP00dAXJ003[0:<18P00fQ4J002A004J4A4J0940R@6A0DT14@2J0M40R@:A0HT1T@00bA4
A00:90=40b@00d@TA00290940b@014@T94@490M400>8S8P00XP7[0>80fP8A004J4AXA0=X14@00bA4
A002A09X0T@016Q4A2@3A0@T14@490940R@2A00594A4A2@00T@49003A2@T00DT2D@00bA49002A0LT
0d@7909400<TA4@034@390=400IXR6QXA6P6A003J4A400E400<TA4@012@000Q40fP5A0=X00A4R6QX
8D@012A4A4@290E400<TA4@00R@3A0<T00I494@TA2@?A003R6Q400I400=XA4@00T@00fQ4A005A003
J4A4009400=XA4@02D@00fQ4A003A004J4A4J0940fP4A09X0d@00bA4A003A0HT0T@790=40R@IA0=X
00B8J8R81fP3A09X00>8A4@02D@00fQ4A002A004J4A4J0=400=XA4@00fP018QXJ6P4A0=X00B8A6Q4
0fP8A0=X0T@2J0E40VP018QXR6P6A08T00=492@04B@2A0HT0T@59003A2A400A400>8J4@016P00dAX
R003J0B800=XA4@00T@00bA4J003J0E400=XA4@00d@2J003A6Q400I400=XA4@00T@00bA4A005A09X
00=4R6P00hP2S007R6R8S8R<J003R004J4A4J0:800AXR8Q40VP00dAXS002[0:800J/R8QXR4@4J0=4
00<TA2@01d@490Q400<TA4@00d@290Y41R@00d@T9002A08T0T@39003A2@T008T1T@6909412@4A0<T
00A494A40b@00dAXJ002J003S=2/00;@00V/c:b8[8b8A6P00d@290940VP014AXA4@2J0=40R@4A003
J4AX00Y400<TA4@01b@3A00594A4A2@01D@00bA49003A08T00=492@00T@00fQ4A004A0<T00=492@0
1b@016Q494@490940R@01T@TA2A4J0=400=XA2@014@00bA4A003A005R6QXJ8P00fP01DAXJ8QX00=4
0R@00d@T900290940B@000Q40VP9A004J8QXJ0A400=XA4@094@00bA4A006A0DT00=494@00R@2A004
94@TA0<T1D@00fQ4A00;A003J4A401940b@3A003J4A400Q40VP3A003J4AX00=400@TA2@T0d@29005
A2@T94@012@014@T94@590I400<TA4@01d@00bA4A005A09X14@00fR8J003J003A6Q400a400@TA4AX
24@00fQ4J002J003A6QX00=X00B8J6QX1D@00fR8A002A0=X00=4R4@00T@00fQ4J002J004A6Q4R09X
0T@01fQ4J8QXA6P014@39003A2@T02DT00E4J4A4J003A09X0T@00fR8R003J003A6QX009400=XA4@0
0T@016Q4J6P>A08T00=494@024@00bA4J002J0=416P00hR<R002S008R:b8J8b8J4@3J0A40VP01DAX
A6R8009X0XP01hb/S8b/S8P00fP00dAXA004A00494A4J0Y400<TA4@01D@00bA4A004A00394A40094
00=XA2@00d@890A40R@3A08T0T@390I41B@2A0<T1D@390A40b@3A0>800>/R:`00j`00hb8S002R09X
1T@5J0=400EXA4A4900<A00394A400=400<TA4@01R@3A08T0T@00bA4A002A005J8Q4A2@014@01BA4
A4@T00E40VP3A00394@T00/T00=492@00T@390=40b@01T@TA2A490A400<TA4@014@00fQ4J002J0:8
1FP00hQXA009A08T000CA003J8QX00=X=4@00bA49002A00494A4A08T0d@291540R@BA00394A400M4
00=XA4@03D@3J09400DTA2@TA0049003A2@T00XT0T@012A492@2A08T24@29004A2@TA08T2T@3J005
A6QXA6P044@00fQ4A005A0aX0T@018b8J6P8A003J4AX00:81D@2R003J4AX00AX00=4J4@00T@02VQ4
A4AXA6Q494@29003A2@T00PT00=492@04B@2A0HT1d@00bA4A002J004A6Q4A0=X0T@01FQ4A4AX00E4
00=XA4@00VP00d@TA006A0DT14@00fQ4A005A003J4A400=40VP01HQXR8b800:/00B<R6R80VP00dAX
S002J0E400IXA4A4J8P3J005R8b<R8`00fP00dB8R003A003J4A400]41B@5A0<T3D@29006A2@T94@T
0T@012A4A4@290A400@TA2@T0T@012A4A4@29003A2@T00<T00A494A41B@3A00394A4008T00=494@0
0d@2J0>81:`00hR<R003J003A6QX00A400=XA6P00VP:A0@T1T@390941R@2A08T0d@00bA4A002A08T
2d@290U400=XA4@00T@290940R@2A0hT00M492@TA2A4008T00E494A49006A004J4AXA0AX00>8J6P0
0VP01DB8R8QX00A400<TA4@00T@1900034@00fQ4A005A005J4AXA6P02T@00fQ4A00SA00394A4008T
0d@01BA494@T00e400<TA4@024@012A4A2@9A0=X6T@01fQ4A8QXA6P00d@00bA4A005909400<TA4@0
1R@00d@TA004A08T00E494@TA0029004A2@T90=412@<A09X00M4J4A4J4AX00]400EXA4AXA002J003
A6Q4009416P00hQXJ002J003A6QX00:80d@2J0A40VP3A09X1D@00fQ4J002J003A6QX00940VP014AX
R6P3A004J4A4A0<T00=492@00R@014@T94@D9003A2A400@T3T@00fQ4J004J005A6Q4A6P02T@012A4
J4@390M41b@=A09X0hP00fR8J006R09X00E4J6R8J005A003J4A400E40VP018QXA4@2J005R6QXJ4@0
16P3A00394A4008T0T@:91=400<TA2@01R@4A00394A400A40b@2A0@T0T@00fQ4900;90I40R@5A0IX
18P018b/S8P6J0=416P00hQXJ002J0I40b@014@T92@2A0<T00A494A412@5A0<T14@00bA490039094
0R@2A08T00=494@00b@4A09X1D@390A400IXA4@TA2@3A08T0d@39003A2@T008T00=492@00T@00bA4
A002A00394A4009400IXA4AXR6P2R003S8R8009X0XP2J0E40R@1A04T00000dAXA004A003J4A40094
00EXA4A4J005A0=X9D@00bA4A008A0<T00A494@T3D@00bA4A007A00494A490M400<TA4@01d@2J1a4
00=XA6P014@490A412@6A00394A400]412@:A00394A400I400=XA4@00T@00fQ4J002A003J4A40094
00=XA4@01T@2J003A6QX00:80VP014AXJ8P2J004R6Q4J09400EXA8R8J003A0>800=XA4@00fP3A004
J4A4A09X00E4J6R8J005A0AX00>8J4@014@00fQ490039003A2@T010T00=492@032@6A08T2D@2J1I4
1R@5A0<T4D@00fR/R002R0=X0hP2S003R8b<00:800=XA4@01D@00fQ4J003A0AX14@5J003A6Q400A4
3B@2A0@T14@290a41B@5A00494@T90I40R@00d@T900390943B@8A00394@T00I400UXR6R8J4B8J8`0
1HP2J003R6Q400940fP01HQXA4B800AX14@290940R@2A00394A400<T00=492@00b@4A0<T00=492@0
0R@014@T92@2A00394A400=41b@2A00494AXR0Y400<TA4@00b@4A08T34@49003A2A400=400<TA4@0
14@2J005R6QXR8`01HP2S003J4A400E40B@1A0001d@00fQ4A002A003J4A400A41FPTA00494A490]4
00<TA2@014@00bA49004A00394A4008T4d@290U400=XA4@03T@00bA4A00?A00394@T00@T14@690=4
00<TA4@00T@012A494@290=40b@7A08T0T@00bA49006A003J4A400940VP7A003J4A400M400AXA4A4
1fP00dB8R006J0=400=XR8P00d@3J003A6Q400=X0d@3J004A6QXJ09400>8A4@00T@2J0:800=XA6P0
2D@S91E400=XA4@03D@00bA4A005A0<T00=4J4@014@290i40VP00dAXJ003J0:800IXR8b<J8P3S09X
3T@2J0A40VP00dAXA003A004J4A4A08T00=494@02b@00d@T900390940b@5A08T1D@4909400<TA4@0
1B@6A0XT00=492@012@00d@T900290=400<TA4@014@00bA4A004A0IX00>8[8P00hP2J003R6QX009X
0d@5J0940VP00dAXJ003A00394@T00940R@2A00494@TA0@T00I492@TA2@2A0<T0T@39004A2@T90A4
00<TA4@00d@00bA4A00290E400=XA4@024@012A492@6A08T14@29005A2A494@01B@2A00394A400E4
1FP4R005S8R/[8P00X`00jb8J002J09400<TA4@00B@00003A6Q400U400=XA4@01T@2J29400=XA4@0
4d@01BA494@T00M400<TA4@00d@00bA4A004A08T4D@00fQ4A006A00394A400=400<TA4@034@00bA4
A004A08T00=494@01T@00bA4900290=400@TA4A42B@01D@T94@T00=40R@014@T94@690A400=XA4@0
0T@2J003A2A400I400<TA4@01d@00fQ4A009J09400IXR8QXA6P2A003J4A4009416P2A003J4AX00A4
00=XS6P00VP3A003J4A400A40VP4A003J4AX009400<TA4@08R@00d@T9008A09X14@016Q4A2@5A004
94A490Y400<TA2@02d@00fQ4A00>A003J4AX00A40VP00hQXJ002J0>800F<R8QXR006A0@T14@00fQ4
A002A00394A400e400<TA2@02b@2A0<T00=492@00R@00d@TA00G90=43R@00d@T90089003A2@T008T
0T@012A4A2@2A09X1D@4J003R6R800>816P00hQXJ004A003J4A400941FP5A00394@T00<T00I492A4
94@590=40R@3A0HT0T@3909400=XA4@01d@390i400<TA4@014@012A494@29005A2A494@012@00d@T
90029004A2@TA08T1D@3J0:800B<R8R80h`02XR<[8R<[<b/S6P6A000:D@2J0i40VPCA00494@T90A4
00<TA2@01D@29005A2A4A6P00d@290A40R@9A003J4A400]40b@3A00394A4015400<TA4@02D@290=4
00<TA4@00d@012A4A4@490=400<TA2@00T@290M400<TA4@07T@3J0A40fP00hQXA003J0:800=XA6P0
0VP00hQ4A003A0EX00=4J6P00T@2J004R6QXA0=X1D@00fQ4J007A004J4A490=472@2A0HT00A492@T
14@00fQ4A004A08T0T@00fQ4J0029003A2@T008T0d@290=400<TA4@00d@016Q4A6P4A003R6Q40114
00IXA4A4J:`3R005J8QXR8`00XP00fQ4A009A0<T00=494@01D@290U41B@014@TA4@A9003A2@T00@T
0T@39003A2@T008T00=492@01R@6A0hT00=492@03R@00d@TA0029003A6QX00940R@2A0=X00>8S6P0
0X`01hR<J4AXA6P00T@00fQ4A005A003J8QX00=X00B8A4A40R@00d@T90029003A2@T008T0T@490A4
00DTA2@TA002909400<TA4@00d@022A4A2A4J4@T1T@00bA4A00:A005J4A4A2@01T@01BA4A2A400DT
0d@29003A2@T00A40R@5A0AX0X`4R005J8b8R8`00Z`00hc@[002R09400<TA4@00D@003I400=XA4@0
0VPDA08T0T@00bA4A004A00394@T00<T1D@00bA49002A00394A4008T00=494@014@00bA4A007A003
94A400U40R@>A00394A4009400<TA4@00d@39003A2A400940R@6A00394A400E40R@3A08T4T@2J1=4
16P00hQXJ005J0:800=XS8P018P2J0F81VP2R0:<00F8J6R8J002R09X0T@00fQ4J008A004J4A4A08T
14@290=45B@00d@T900D90A41R@4A08T00A494A412@9A003R4A400I400AXA6QX14@00haXA009A003
J8Q400940XP00hb8R003R09X34@29003A2A400E400=XA4@014@390941b@00d@T90039003A2@T0094
1R@014@T94@@909422@2A00494@TA08T00=492@032@01D@T92A400<T0T@490a400R8S8QXR8b/S0:8
0VP00dAXA004A003J4A400E400AXA4AX0XP3J003A2A400dT00=492@00T@59003A2@T00A40b@00d@T
900390A40b@5A00394A400I400<TA4@01D@00bA4A005A08T0T@390941B@=A004R6R8S0>800=XR8P0
0XP01:b8[8`3[003S6Q400A400000dAXA005A003J4A400M400=XA4@08D@00fQ4A007A003J4A400A4
0VPHA00394A4008T00=494@01d@00bA4A005A003J4A401e400=XA4@00R@:A0<T1D@29003A2A400]4
00<TA4@00T@292940fP2A003R8aX00EX0XP3J0:800N/R:b/R8aX00:800N<R6R8S6R<00>80VP01Hb8
J8aX00:80VP7A00394A400E400=XA4@00b@4A00394A400=40b@2A0LT0T@6909400<TA2@00b@014@T
A4@5909412@5A08T0T@00bA4A002A00394A4009400DTA4A4900<A00394A401M400=XR6P00d@2J004
R6QXJ0M40VP6A00494A4909400EXA4A4J006A08T0d@690=41b@2A0TT00A492@T0T@69003A2@T00/T
1D@00bA49005A0dT14@290=412@8A0AX0hP01:b<[8P2J0=400=XA6P01T@4J003A6Q400IX1D@29094
0b@3A00394A400=40b@5A08T00=494@01T@390A400<TA4@00T@00bA4J006A003J4A400a40R@4A0HT
14@290U400YXA4AXA6R8[8QX1XP2[003S8S<00:/0hP4A0008T@00fQ4A00:A09X1D@016Q4A6P=A003
J4A400U40R@014@TA4@49005A2A4A2@00d@39003A2A400I400<TA4@01d@00bA4A007A08T34@00bA4
A002A003J4A400U400<TA4@00R@01d@T94@TA2@00T@00bA4900290=40R@MA00394A400=X0d@00fQ4
A007A09X00>8J6P00fP2R09X00E4J8R8[002R0:<00B8S8R/0X`2R0:<0XP01Jb8J4AX00:816P00hb8
J006A00394A400I400@TA2@T1D@A9003A2@T00/T0T@?915400<TA4@01D@2911400=XA4@04T@01VQ4
A4AXA0AX1T@3J0M41B@3A00394A400E40R@4A0PT0T@F9003A2@T00@T00A492A43b@00d@TA00B90=4
0b@4A00394@T00Q416P2R006J8b<S8Q40VP4A003R6QX00A400=XA4@00T@00fQ4J00;A00494A4A0@T
1T@490A412@3A00494@T90=400<TA4@00R@:A003J4A400=400<TA4@01D@00fQ4A002A00394A400E4
22@00d@TA002A003R4A400=400=XA4@00d@00fR8R003R006J8R8R8b81:`01Hb/[8QX00940B@004]4
00LTA4A494@T00=40b@014@T92@8A00394A400U40R@3A08T00=492@01T@012A4A4@290=400<TA4@0
6d@290940R@00d@T9003A00394@T00<T00=494@064@01FQ4A4@T00=40fP3A003J4A400E400=XR6P0
0VP2A09X18P2J0:800EXR8QXA004J008R6R8R8aXS:`3R0IX0T@2J003R6QX00I40R@7A0<T1D@?9004
A2@TA18T0T@990E400<TA4@00T@290E40b@5A08T6D@00hQ4A002A00394A400=X14@00fQ4J004J0A4
16P5A0<T0T@390a400@TA2@T0T@6909400<TA4@00b@00d@T90039003A2@T00<T00A492A41B@4A1<T
00=492@01R@00d@T90049003A2@T00@T0d@290=40R@014@T92@3A0AX28P00dAXA003A00494AXJ0E4
00=XA4@02T@00fQ4A008A0<T1D@490E400@TA4A40b@2A08T14@290E40b@3A003J4A400e40R@2A08T
1D@29003A2@T008T0T@29003A2A4009400=XA4@014@4J0B80fP3R003S:b/00>/00B<R6QX0T@004m4
0R@4A0@T1D@290=40b@3A00394@T00E400HTA4@TA2@5A00394A400Y40R@3A004J4A490Y400=XA4@0
24@00bA4A004A0<T00A492A412@00d@TA00290Y400@TA4AX7T@2J0941VP2R003S8R<00J80VP014AX
A4@2J0>800B/S4A416P8A003J4A400I40b@:A003J4A400=41b@3A0HT00=492@03b@00d@T900990e4
00@TA4@T2D@3J0A400=XA6P03d@00fQ4A002A00594A4A6P00T@00bA49004A004J4A4J0=40fP2A0=X
0b@2A08T00M492@TA2A4008T1T@=90A40R@00d@T90059003A2@T00@T14@290A41B@00d@T900?9003
A2@T00hT0T@00bA4A0049004A2A4A0<T00=4J4@01FP00hR/S003S004R6QXJ0I40VP2A004J4A4J0I4
0R@=A00494@T90940R@2A0@T0d@012A4A4@390941R@00d@T9002A004J4A4A08T1d@00fQ4A00=A08T
0T@290I40R@00d@TA002909400<TA4@01D@2J09416P00hQXR002R003S8R800:/00G@c:b/R002J094
000eA00394@T00Q400<TA4@02T@290I400<TA4@00d@00bA4A003909400@TA2@T0T@00bA4900:A08T
1D@290I400<TA4@00d@00bA4A00<A003J4A400e400<TA4@01D@39003A2@T00Y400=XA4@01T@00fQ4
A008A00394AX019400=XA4@00T@5J003S8R800F800UXR6QXA6Q4J4@00XP00dAXJ003A005J<b8R6P0
0T@00fQ4A003A003J4AX00=400DTA4@TA00290m41R@2A08T00=492@032@2A0DT00=492@00b@5A0<T
14@2909400TTA4A494@TA6P04d@01RA4A4AXR0I400EXA4A4J00<A004J4A4J0Q40fP2A003R6PT00@T
0d@012A4A4@690=43R@3A0/T00=494@012@014@TA4@290E412@00d@T900F90941b@2A0<T00A492@T
0T@2909400@TA4A41FP018R<S:`3S0>80fP5A0:800EXR6Q4J005A00394A400]400<TA2@00b@00d@T
90069003A2@T008T14@290942B@2A003J4A400940R@4A0=X3D@012A4A2@2A00394A400E400HTA4@T
A2@;A09X0T@00hQ4J005R0><00Z/S<c<d:b8S8QX0T@003]400<TA4@01D@00bA4A00LA00594A4A2@0
0T@022A4A4@TA2A40R@3A00694A4A2A40R@6A0@T0d@00bA4A00DA00394@T00=40b@7A0DT4T@00bA4
A004A005J4A4A6P00d@2J004A6QXJ09400=XA4@01d@00fQ4A008A0=X00>8J6P00XP00fR8R005J003
A8QX009X14@016R8R8P2J003A8Q400M400=XA4@03d@290A400LTA2@TA2A400@T0d@00bA490069003
A2@T009412@2A0HT00=494@024@290940R@01D@T94@T00a400<TA4@01D@00bA4A003A09X3d@00bA4
A00@A003J4A400E400<TA4@00R@00dB8A003A08T00=492@014@39003A2@T00PT00=492@03B@00d@T
90069006A2A4A2A40b@2A0`T00=492@04b@00d@T90049004A2@TA0<T00A494@T0T@4J0B800V/R:b8
S8Q4J4@00VP4A003J4A400E400=XA2@01d@00bA4A0029003A2@T00PT00=492@00b@01T@T92A490M4
1b@00d@T9007A00394A400A400=XA4@01d@00bA4A007A00494AXJ0M40b@:A006J8QXJ4B80VP2R003
J8R800><00>8S8`01Z`1R0540D@004=400<TA4@03D@00bA4A00:A00394@T00I400DTA4@TA00290Q4
0b@9A0DT0T@00bA4A00?A003J4A400I400<TA2@01B@3A00394@T00<T00E494A49007A00394A400Q4
00=XA4@00T@2J003A6Q400E400=XA4@00T@00fQ4A00:A003J4A400=40VP4A003J8Q400=416P2A004
J4AXJ0A400AXA6QX0T@2J003A6Q400a400<TA4@01d@390=400<TA2@06R@00d@T90049003A2@T00<T
0T@00bA4900290940R@3A00394A400=400<TA4@014@00fQ4A00?A00494AXJ0940R@:A0<T2d@00fQ4
9002A003J4A400Q400<TA4@00T@490940b@3A08T00=492@01B@00d@T90059003A2@T00PT00=492@0
22@00d@T900590941B@00d@T90039003A2@T00<T00=492@01b@00d@T90059003A2@T00HT00=492@0
1B@2A005J4AXJ8P00VP00hR/S002S006R6QXJ4AX1D@3J0A40VP00dAXA006A00394A400<T00A492A4
12@00d@T90029004A2@T909400@TA2@T1D@:90941R@2A0<T1d@390=40R@3A08T00AXA4AX2D@01BA4
94@T00M400MXA6QXA6R800=X00A4J6QX0XP00lb/S002S003[<b/00:/0HP1J054000oA00794A4A2A4
9004A00494A490A400<TA4@00d@00fQ4J005A00394A401I40R@3A08T0d@012A4A4@490I400<TA4@0
24@00fQ4A004A00394A400=40R@014@T92@2A0DT00=492@00R@<A00394A4009X1T@5J0M400=XA6P0
14@2J0940fP6A09X00=4J6P01D@018QXA6P3A008J8QXJ8QXA6P2A003J4AX00=X0T@01FQ4A4AX00I4
0VP4A0<T0T@00bA49002A1dT00=492@01b@2A00394A4008T00=494@00d@390e400<TA4@02D@00bA4
A002A08T14@490A412@00d@T9002909400AXA4@T1d@390]412@00d@TA002A0HT00=492@02R@014@T
94@X90=41R@6A1hT00=492@01B@014AXA4@5J006R8b<[8b816P6A003J8aX009X00A4J6QX0d@00fQ4
A006A0<T00=492@00b@00d@T900690=41B@2A00394@T008T00=494@02T@290=40R@2A08T0T@69005
A2@T94@00R@<A00394A400A400<TA4@01d@4J004R6Q4A09X0T@00hR<[003S004R8b/c0>/0HP1J000
ED@00bA4A00FA00394A400I400=XA2@03D@00bA4A009A003J4A400A40fP3A003J4A400=400=XA4@0
14@29005A2@T94@012@3A00394A4008T1d@012A4A6P7A0IX0T@00fQ4A002A09X0d@4J09400=XA4@0
1D@00hQXJ007J006R6QXJ8Q40VP00hQXR002J003A6R800940fP018aXA6P<A004J4A4A08T00=494@0
0T@012A4A4@29003A2@T01LT0T@990940R@014@TA4@29003A2A400<T2d@2909400=XA4@024@00bA4
A002A00394A4009400<TA2@00b@3A0<T00=494@00R@2A004J4A4A08T00I4J4@TA2@7A00394@T00=4
00<TA2@00T@290941B@2A0`T00=492@022@00d@T900:90E41b@3A0dT1D@290945B@00d@T900:9003
A2A4009X00E4J4A4J002R006J8R<[8b80T@00fQ4A004A0:80VP2A003R4A400940fP2A00394@T00A4
0R@00d@T90029007A2@T94@TA00590940R@3A08T0T@690=40b@8A00494A4909412@2A00494@T9094
00<TA4@04T@00bA4A004A003J4A400IX1D@2J0:<18P00jb<c003[07@0FP00003J4A402M400=XA4@0
8D@00bA4A00dA00394A401940VP00dAXA003A00394A400U40R@01T@TA4@TA0@T14@01BA4A4AX00M4
00=XA4@01T@2J005A6QXJ4@00VP4A003J4A400]400=XA6P00fP00hQXJ009J003R4AX00=X00=4J4@0
0d@3J0E400=XA4@03D@39003A2A400A400@TA2@T0T@H90=41R@00d@TA006A0<T00=494@00b@;A08T
2T@00fQ4A0029004J4@T90E400<TA2@012@00d@T9002A0<T00E494A49002A08T0d@590I40R@00d@T
900290=40b@00d@T900A90A41R@2A0@T00=492@01B@00d@TA002A08T00=492@00b@00d@T900<90E4
22@014@T92@2A1PT00A494A40VP014AXA6P2R006J8R8S8QX0d@00fQ4A003A0MX00=4J4@01d@29094
3B@00d@T90069004A2A490940b@00d@T900390A412@2A00494A4A08T0d@00bA4900290E400<TA4@0
0d@290a400=XA4@00T@00bA4A004A09X14@2J0I400AXR8R80X`01HR<[8b800>/0M01[0008T@00fQ4
A00LA003J4@T00M400<TA4@064@00bA4A00AA00394A400M400<TA4@044@012A4A6P2A003J4A400=4
00DTA4A4900:A00494A4A08T2T@00fQ4A00@A003J4A400=40fP;A09X0d@01FQ4J4B800=X1D@3J006
R6QXJ8QX0T@2J0I400=XA4@01d@2J003A6QX009400<TA4@00T@012A4A4@290A412@2A1TT00=492@0
1R@8A00594@TA2@014@390Q400<TA4@01T@01VQ4A6Q490E40R@00d@TA003A0lT00=492@00b@3A0HT
00=492@01b@00d@T90089003A2@T00lT00=492@04R@014@TA4@<9003A2@T00HT00=492@052@2A0hT
00=492@022@00d@TA002A003J4A400EX00E4J6QXA006J0940fP3R003J4A400I400<TA4@00d@79003
A2@T00<T0T@69003A2@T008T0T@89003A2A400=40b@00d@T900590A40R@00d@TA003A003J4A400=4
0R@IA005J4A4J4@00fP00dAXA003A008J8b8R6R8[8`3[0;@0M41d07@000RA003J4A402I400<TA4@0
7d@00bA4A002A00394A400=40R@MA00694A4J4AX2D@01RA4A2A490M400<TA4@02D@00fQ4A004J0m4
00AXA4AX14@00fQ4A003A0AX0d@2J09416P2R003J4A400=40VP00hQXR003J0:800=XA6P00VP2A003
J4A400=40VP4A0=X00E4R6Q49004A00394@T00Q412@2A0LT00=494@01B@00d@T90079003A2A400DT
00=494@01T@2909400@TA2A40b@2A003J4AX009400=XA4@024@016Q4A2@4A00394A400I41R@00d@T
900890940R@2A00494A4A0DT00=492@01b@00d@T90069003A2A4009412@00d@T900O9003A2@T00XT
0T@=9003A2@T02XT0T@00bA4A003A09X00B8J4A40VP00hQXJ006R09X00J8J6R8J8P2J003A2A400A4
00<TA2@00d@5909412@4A0DT0T@;9003A2@T00<T0d@00bA4A002A0<T2D@390M400<TA4@03T@016Q4
A6P2A00394A400I416P00dAXA002A0=X00>8J6P00h`2[0K@000@A0AXB4@00fQ4A00IA00394A400I4
00<TA4@02D@012A4A4@2J003A6Q4011400<TA4@00b@00d@TA00@A09X00=4J6P00VP00dAXA007A004
J4A4J0=400AXR8QX0T@2J0M400=XA4@00T@016Q4A4@6J0E40VP00hQXJ002J003R8b8009400=XR6P0
0fP5A0=X00=4J4@014@00fQ4A006A0<T1d@?909422@00d@T900390=412@7A08T00A494@T14@390M4
00=XA4@024@01FQ4A4@T00A40b@6A0@T00=492@04R@3A0PT00=492@00b@00d@T900K9003A2@T00LT
00=492@03B@00d@T900490=47b@00d@T900>9003A2@T00PT0T@390940VP01HQXJ6Q400AX0hP00fR8
R002R003J8aX00AX00B8J4@T1D@490A40b@2A0DT00=492@03B@2A0<T0d@290=40b@3A0<T2D@290=4
00<TA4@01d@00fQ4A003A0=X0T@016Q4A4@2J0M41fP4A005J4A4J4@00VP2R008S:b/c=2/c:`1d000
4D@2J0A40VP00dAXA003A003J4A400E400=XA4@0<D@00hQ4A00[A09X00=4J4@00d@00hQXJ00>A003
J4A401140VP2A003J4A400940VP00hQXJ005J0M400B8J6R80VP2A0>800=XA6P00VP7A004J4A490e4
0VP00dAXJ002A006R4B8J8QX0T@00fQ4A002A003J4A4009400=XA6P024@00fR<J006A08T24@012A4
92@2A0@T00=492@012@2A0HT00=492@012@3A08T00=492@00d@290940b@2A00394A400E400<TA4@0
24@01FQ4A4AX00Q400<TA4@00R@00fQ4A004A0LT00A492@T0T@2909400<TA4@00R@8A08T00=492@0
1B@2A0DT14@;9003A2@T00@T00=492@03b@2A0@T0d@39005A2@T94@00b@00d@T900D9003A2@T00@T
00=492@00b@00d@T90029003A2@T00<T00=492@01b@4A00594A4A6P00hP01fR8R8R<J4@00XP00dAX
J003R004J8QXR09X0T@00fQ4A007A08T0d@390=40R@00d@T9004A0@T00=494@00R@2A08T00=494@0
24@2909400=XA4@00R@RA004J4AXJ0940VP;A0=X00=4J6P00fP3A09X18P01Xc@d:c@[07a000AA09X
14@00fR8A00VA003J4A400E400=XA4@044@00fQ4A00[A003J4A401=400=XA4@03D@00hR<R003A006
R6QXJ4B81FP3R09X00B8J8QX0d@5J003A8R<00=X00B8[8R80fP018QXJ6P4A09X2D@00fQ49002A004
R6QXA09X00I4J8R8J4@2J0=400=XA4@00d@2J0Y400EXA6R8J003A09X2d@39003A2A400XT0T@890=4
0R@00d@T90049003A2@T00E41B@00d@TA006A00394A4009400=XA4@00d@016Q4A4@3J003R4A400Y4
0R@00d@T900B90i412@00d@T9002A0@T00=492@00T@;90947B@00d@T9002A0DT00=492@07b@2A0PT
00=492@03B@2A00494@T90A40VP00hQXR003R007J4A4J8Q4J003R004S6QXS0:81D@00fQ4A004A003
94@T00=400<TA4@014@390E41B@00d@T900490E400@TA4A41b@014@T92@OA0=X00=4R4@02T@290U4
0VP00dAXJ002J003A6QX00=X00B8S:b/0]02l@005d@00hQXA00MA003J4A400]400AXA4AX8T@00fQ4
A00BA00394A4015400=XA4@01D@3J003R8b800=X2T@01Zced8QXA09X00>8J4@01VP00hQXR006J094
0fP01XQ4J4AXR0AX00N8J6QXR6Q400=X1D@2J15400EXA4AXS003J0=416P00dAXA006J0I40VP014AX
J6P3A09X0T@00fQ4A004A00694A494AX0R@00d@T90049003A2@T00`T00A492A42R@2A00394A400@T
3T@016Q4A6P7A004J4AXJ0I400<TA4@01D@29004A2@T90943B@2A09X00=4J6P01T@390940R@2A1DT
00=492@09R@00d@T90069003A2@T010T00=492@00R@3A1PT0T@00bA4A003A0AX18P018b8J6P2R003
J8b<00>800AXR8QX1T@00fQ4A003A0<T00=494@024@3909400<TA2@00T@29003A2@T00@T0T@00bA4
A002A0LT00A494A40b@3A00394A401Y400=XA4@014@3J0i41VP018QXJ6P2R0=X00F8S:c<d003m@00
=D@3J0Y40VP4A003J4A4009X>T@00fQ4A003J0E400=XA6P00fP3A09X00F/d=7ad004[003J4A400A4
0VP01DAXA:b8009X0XP3J007R4A4J4AXR002S003R6R8009X0d@5J0:800=XR6P01FP00hR<J003J0=4
00EXA6QXA002J0E400=XA6P00d@01BA4A4AX00=40VP4A006J4AXA6R80VP5R003J8QX00>80VP00jb8
J004R003J8b8009X00>8J6P00fP8A08T0T@39003A2@T00@T0T@?9003A2@T008T0T@29003A2@T00<T
0d@02RA4A4AXA6R8J4@4J003A8Q400=400=XA6P00fP2A007J4A4A2A49004A0@T00A494A40b@5A0<T
1D@016Q4J6P4A003J4A400=40b@5A0lT00=492@04b@2A3HT0T@00bA4900;9003A2@T00DT00A492@T
0d@4J0940VP5R003S:b/00><00F8S:b<J005R0=X2T@012A4A2@4A00594A4A2@01d@00bA49002A0HT
1d@00bA4A0059003A2@T00DT0T@00bA4A00=A00394@T008T3d@2J0I400<TA4@01D@3J003R6QX00:8
1FP2R0:<00B8S=7e0_X00003J4A4019400=XA4@074@2J0=416P2A003J4A400=40VP00hQXA007A09X
00=4J4@034@00fQ4A008A003J4A400]40VP9A09X0T@00fR8J002A005J4A4J4@00VP00dAXJ003A003
R<ca00?e0_401?G@A6P3A003J4A400A400=XR4@00XP2J003A6QX009X0T@2J0:80d@00fR8A002A004
J4AXA0IX00>/J8P00T@3J003R6QX00AX00=4R6P00VP2A003J4AX00:800=XA4@02d@00fQ4A002A003
J4AX00=X00F8J:b8J003R003[8QX00F800=XR8P00XP00hb/R002R003S:aX00=X00>8J4@01D@49094
00<TA2@022@01D@T92A400TT00=492@00R@4A0DT00I492@TA2@3A003J8R800UX0d@00fQ4R002R003
A6Q4009X0d@390A40b@3A0DT00=494@00T@39003A2A400E40fP2A006J4A4A2A40b@5A0DT0d@79003
A2@T008T00=492@03B@00d@T900I9005A2@T94@00R@00d@T900B9005A2@T94@032@00d@T900490A4
0R@3A0=X0T@2J0>800QXR:b8[8R/S0>/0XP2J0B816P3A003J4A400940b@:A00394A400E40R@3A003
94@T008T0d@01BA4A4@T009400<TA2@01R@2A08T0d@00bA4A005A00494A4A08T0T@012A4A2@=A0EX
3d@00fR<J002R003J8QX00:800UXR:b8S8R/mOT00_X001I400=XA4@01T@2J0U40fP4A0QX0XP;J003
R8aX00I400=XA4@00T@00fQ4A00:A09X1d@00fQ4A003A003J4A4009400=XA4@014@016Q4J4@2J0E4
00=XR8P016P00dAXA004J003R6QX009X00E4J8R<[002m@06nM7@d:b80VP8A09X00>8J8P00XP5J0:8
0fP018R<A4@3J0E40fP00hQXJ002J0:81fP01hQXJ8QXA6P00XP3J004A6QXR0:/0VP9A003J4AX009X
0d@01FQ4J6R8009X00>8S8P00VP00hR/R002R005J8R<R:`00VP3R005[8R<J8P00Z`01HQXR8R<00=X
00=4J4@00d@00bA4A0039003A2@T00=400HTA2@TA2@2A00494@TA0@T0T@39004A2@T909412@00d@T
A00290A40VP2A003J4AX00A40VP4A005R6R8J4@00fP3A00494A4A08T0T@012A4A4@990=412@;A003
J4AX00E400<TA2@00d@490942B@00d@T90119003A2@T01lT0T@00bA4A003A0=X0T@2J0:800F<R8b/
S002[0:<00B/S:b<0hP00fR8R002R0=X0d@2J0a40R@2A0<T2D@29003A2@T008T0T@012A4A4@290=4
1B@014@TA4@2909400@TA4@T1d@00bA4A002A00394@T00i426P>A003R6QX00F800YXR8R8[8R/c?Gi
0_X0021400=XA4@00d@2J0940fP8A005J4A4J8P00VP00hQXJ003J004R8b8J0:800=XA4@00d@2J0I4
0VP4A003J4A400940VP01TAXA4AXR0=X14@00fQ4A002A004J4A4A09X00>8J8P00T@016R8J4@2J003
A8QX009X00B8J8Q40fP00hQXA005J0=400=XR8P00m001Lb/[8QX00A400EXR6Q4J002A005J8R<[8P0
18`018R<[6P4R004J4AXJ0=400AXA6QX0XP2J0942FP5R09X18P00fR8J002R005S8R<S8P00VP01DAX
A4AX009416P00hQ4A003A09X00E4J4AXR007J0=40VP4A0AX00J8J6QXR6P2R005A6QXJ8P02D@291A4
00=XA4@00T@00bA49002A08T00=492@00d@3909400<TA4@00T@016Q4J6P3A005J4A4A6P014@00fQ4
J002A003J4A4011400<TA4@00R@00d@T9004A08T2T@016Q4A2@=A08T0T@00bA4A0099003A2@T00<T
00=492@0Eb@01D@T92A4008T00=4J4@00T@00fQ4J002A0=X00N8S8R<R8b/00B<00>/S6P01FP00hQX
J003J0Y400<TA4@014@390=400<TA4@01T@29003A2A400Q400<TA2@00T@00bA4900290940R@014@T
92@=A00394A400U400<TA4@00d@016Q4A4@2J003A6QX009400=XA4@01D@012A4A6P2A0=X0XP018b8
R8P2J0>80Z`00oGjnP01nP00:d@00fQ4A004A003J4A4009X0T@3J003S8R800=X00>8S8P00XP2J0=4
00EXA4A4J005A003J8QX00Y40VP014AXJ6P:A004J4AXJ0A400B8J6QX0T@;J003S6QX00EX00B<J6R8
1VP7R0=X00=4J4@014@02fQ4J4AXR:b<R8c<00:/00B8[:b<0XP3S09X1HP4J005S8QXJ4@00fP00hQX
J004R00:J8b<S8QXR6R<R09X00><[8P00hP00hb/R003R003J8QX009X00>8S8`00XP00jaXR007J004
A8b8R09X0XP00fQ4J007A004J4A4J0U40fP00hQXA00;A09X00G@[6R<R003J004A6QXJ0940fP00hQX
A002A003J4A400a400=XA4@014@2J0E400=XA4@00T@00fQ4A002J0A400=XA4@00T@00bA4A008A09X
0d@00fQ4A005A09X0d@2J003A6QX00:81d@00fR8R004J0E400@TA4@T0d@790=45b@00d@T900I9003
A2@T02/T24@016Q4J4@4J0B800AXR8b<1:`2S0>826P00dAXA00@A00394@T00E41B@3A00394A400I4
0b@6A0@T1D@012A492@7A003J4A400E400<TA2@00T@290=40VP00dAXA005A003J4A400=40fP8A005
J4AXR6P01HP01fR8J6R8S8P00X`00oGin@01n@0074@00fQ4A00KA09X00><[8`00fP018R<[8`3R0=4
0VP2A006R4A4A6Q40VP018QXJ6P5A005J4A4J4@016P4A003J4A400A40VP4A003J4AX009X0d@5J003
S6R800>800=XA6P00fP00dAXJ002J003R6R800940fP2R09X00B8J6R816P00dAXJ003J004R8b<[0:8
0j`01HR/c<b<00B/0XP018b8[8`2R09X18P01DAXR6R800=X0hP02FR8R:b8J8b8J002R005J8R8S:`0
0VP018b8S8P2J0N800R<[8R<R6R8A09X00E4J6Q4J003R003A8R<00EX00=4J4@03d@00fR8J004J0U4
16P01:c@J8P2J004S6R8A0=X0d@02fQ4A4B8A6Q4J4B800E400AXA4A40fP4A0=X0T@00fR8J005J003
A6QX00:800EXA4A4J008A003J4AX00A400=XA6P00T@00fQ4A00;A007R6QXJ8R/R002A0EX0X`9J0M4
1R@3A0<T00=492@04R@00d@T900=9003A2@T00TT0d@4909400<TA4@00T@99005A2@T94@032@00d@T
90039003A6Q400E400AXR6Q40VP4R005S8R8J8`01J`01XaXR8b8S0>800=XR8P00VP>A004J4A4A08T
00=492@01D@590A400=XA4@00T@390I400@TA4A40R@01T@TA4@TA0<T44@01BA4A4@T00e400IXA4A4
J4@2J003A6Q400M41FP00hb/R003J005R6QXS8P00Z`3m@7i000PA005J4AXA6P00d@00fQ4A002A004
J4A4A0=X0T@00fQ4J002A09X0XP3J005R8b8S6P00XP4J0=40fP01HQXA4AX00:800EXA6QXA006J094
0fP00dAXJ004A09X1D@01FQ4A6Q400MX0XP7J003A6QX00UX00>8J6P01VP2R09X00=4J6P00VP00hQX
R004J003R8b/00:/0X`01Jb<R8R<00B/00C<S:b/18`00hR/[003R0>/00B8J8R<1hP01hb8S8QXR6P0
0XP2J0>800B<J8R80X`00jb8R003R003J8R<00:/0XP2S0:82VP2R005J8R8R6P00XP4J003A6Q400e4
00=XR6P00fP2A003J4A4009X0d@00fR8J004A004J4A4A09X00=4R6P014@01fQ4A6Q4J4@00VP8A0>8
16P2R0=X00E4J6QXR004J0:800EXR8QXA003J0U400=XA4@014@2J003R6Q400=X0T@4J0=40VP2R0=X
00=4J4@00d@2J0:800F/J6QXR003J0U41R@3A0<T0T@S9003A2@T00DT00=492@022@00d@T9005A08T
00M492@TA2A400<T00=492@02R@2A0<T24@01fR8R8QXR8`018P00hb8J002S005[8b<[8`00XP00hb/
R006R003J8QX00a400=XA4@00T@39004A2@T90E41B@00d@TA007A08T0d@01BA4A2A400<T14@29154
00<TA4@00d@00bA4A00<A003J4A4009X0XP2J0Q400IXR8R8S:`2S0:80fP2R004S:b/d0?e000OA003
J4AX00=X0d@2R004J4A4J0A40VP2A09X0XP4J003S8R<00:80fP00hQXJ002J003A6Q400=416P00dAX
J005R0=X0XP01FR8R8Q4009X00>8A8P00VP3A003J4A400A40XP00fQ4J002J0:82VP00hQXA003J0A4
0fP00hQXJ005J003R6R800AX00V<J6R/S:aXA8`00VP00hR<S002R0:<00C@[8R<0Z`2c003d:b/00:/
00B<[:c<0m06[005S8R<S8P00X`2R004[8b<S0:800QXR8b/S6R8J0>80fP3[008S8R<R8b8J8`2[008
S8R<[8b/R6P2R004S:aXJ0:800F/R8b<[002R004S8QXA09X0hP016Q4A4@3J0941VP018QXJ6P2A09X
1D@016R8J6P4A003R4A400IX00E4J6R<R005J0>80fP00hQXJ002J003S8R800>800>/R8`00hP01FR8
J8b800=X00>8[8`00XP01fR8J6R<R6P014@6J005A6QXJ8P00VP018aXA6P2R003J4AX00B80fP018QX
J8P5J005R6QXR6P00hP5J0:80VP5A00394@T00/T0T@;9003A2@T00TT00=492@01R@00d@T90099003
A2@T00/T00A494A40R@2A0TT0d@<90=400<TA2@00d@00fQ4J003J0B800=XR8`00VP2R003S8R<00:/
0XP01Hb8J8QX00:80VP018Q4A4@690U400<TA2@01b@4A00394@T00940R@9A0<T0d@490E400<TA4@0
4D@00bA4A002A08T14@2J0a40fP:A0B800>/S:`00XP3J007R6QX[8b/d002m@004T@00fR8J00:A0AX
00=4J4@00T@2J0M400=XA4@00fP3R0=X0XP00fR8R003J003R6QX00:80T@4J0941VP02hQXJ6R8J8QX
R6R800MX0T@3J0A40VP014AXJ4@5R004J8R8S0IX00V8J6QXR6R8J8P01fP2S0R80VP018QXJ4@3J007
R6R8J8QXA002R006S8QXS:c@18`00hR<d002c0:/00J<[<cAc:`2d004c:b/d0:/00B<R8R80X`2[006
c:b/[8b80X`3[0>800EXR8b8S002R00;[=2/c8b8S:b8J8`01Z`00lb/[002c005[8b/[8P01:`01m2/
[:b<[8P018`018R/[8`3J0>80VP018R<R8`3R006S6QXA6Q40VP2A0IX00F8J4AXR002J003R6R800EX
00Y4R:cA[=7@R6R80VP01hQXR8QXR6P00XP00haXR002R09X00><R8`00hP00hb8R005R003S8QX00:8
00B<[8R80VP018QXR6P3R003J8R800:800AXR8R80VP2R003S6QX00:800><[8P01hP2J0:800><R8P0
0X`00hQXJ002R09X00J8J8QXR6P5A0DT00=492@02B@00d@T90029003A2@T01TT00=492@032@00d@T
90089003A2@T00PT0T@29003A2A400@T1D@390=400<TA4@00T@00bA4A002A004J4AXR0AX0XP00fR8
R008R004J8R8R0=X00>8J4@00T@79004A2@T90I41B@00d@TA00290=400@TA4A40R@4A00394A4008T
0T@012A4A4@4909400=XA4@01D@00bA4A00AA00394A400=40VP:A003J4AX00E400=XA4@014@026R8
R:b<[<b/0XP2J007R6QXR:c@l@02m@004d@00fR8J009A09X14@00fQ4A002A003J4A400I41FP2R0AX
0XP02VR8J6R8S8QXS:`6J003A6QX00=X0XP4J007S8R8J8Q4R006J09400AXA6R80VP2A0EX00>8J8P0
1XP00haXJ006J003A6R8009X00I4S6R8J8P2J0B80VP018QXR:`2R003J8QX00AX00F<J6R<R005J004
R6R8R0:/0X`018R<R8P3[0:80X`01<b/S8`4[003S:b/00:800IXR8b8[<`2d004dJb/c0:/00F8S8b<
R002J0:80X`2R003J:b800B/18P2S0B/00K@[:c@c=02[0;@00F/d:c@[002c003[<b/00B/0/`2[0:<
0j`00hR/R003J003R8b800>800?<J6P00VP01DAXJ6R800=X00=4[4@00VP00dAXR003J005R=2<[8`0
0fP00hb/m@03m@05d:c@R:`00h`01:aXJ4@2J007R6R8S8QXR002S0B800N<[8b8S8QX00:800B<R8R<
0Z`4R005S:b<R:`00hP3S003R6QX00>800AXR8b/0XP3S004[8b8S0N800^<R8R8J:b8J8QXS002R004
S:b/R0EX00A492A43b@00d@T900O9003A2@T00<T00=492@01R@00d@T90039003A2@T008T00=492@0
1R@5A00394A4009412@5A08T00=492@034@4J006R6R8R6R<0hP2J0B800=4J6P016P01HQXA6Q400HT
0T@390M41b@00d@T9003A00394A4008T1T@390940b@2A00494@T90U40R@6A00394A4011400=XA4@0
2D@00fQ4A006A004J4A4A0=X00>/R8P00Z`00hb/R005J003R:cA00?e000CA09X7T@02FQ4J6Q4J8QX
R002J0B800F<R8R/R004J003A6QX00EX00>8J6P016P01hR<S6Q4J8P016P01XQXJ4AXA0EX00A4J6Q4
0VP2R004J4AXJ0>800AXR8R80fP01HQXJ6Q400=X0T@00fQ4J002J003R6QX00>800=XR8P016P2R0=X
00=4J6P01VP00hR/R004R006S:b/S:b<0XP00fR<[003R006S:b<S:b<0Z`01Xb/[=2/S0>/00J<R6R8
[=02c004S:b8S0:800N<[:b8S8R/00:800N/R8R8J8R<00:/0XP3[00:d:c@[=3<d:c@c0;@00?a[=00
1=000lc@[004[0?<00B/d<c@1j`2S004R8b/[0B800V<R:b8J:b8J8P00X`01XQXR:b<d0:/00?@lJ`0
0X`01=3ed8`3J003[=3@00Ge0_T2l@04mM7ed@:/1HP00hb8R002R005[8b/d:`00XP01Hb/[8b/00:<
00?@[:`00X`00jc<[003R0F/00><[8P00Z`018QXR6P3R003S8R800:<0j`01Hb8R8b/00:800=XR:`0
0j`01Hb8R8R<00:80X`01Zb8R:c<[0>80VP6A0`T00=494@01b@014@T94@M9003A2@T00dT00=492@0
2b@2A08T1T@49003A2@T00DT0d@590M40VP3R0:<00B8J8R<1XP5J006A6QXA6Q40b@00d@T900490E4
00<TA4@014@:9004A2@TA08T0T@00fQ4A002909400<TA2@00b@00d@TA005A00594A4A2@01T@39005
A2@T94@00R@014@TA2@5A09X2d@00fQ4A002A003J4A400I416P2S0>/1hP00jcam@02m@0000=XA4@0
3D@5J1=40VP2A003J4A400E40VP014AXJ4@2J003R6QX00=X0XP2J0:80VP2A003J4A4009X0hP4J00;
R6QXR8b8A6R8J8P01FP3A0QX00B8J8R80VP00dAXJ002R09X00J8[8R8J8P3J0:800=XR6P01fP02HQX
J8R/R6R<J002R003J8R800:816P4R0YX00>8J8P00hP5J0:81J`00lc@d004[003c:b/00B/00>8J8`0
1:`01HR<S8R<00:80X`2R003J8R/00:800B<R8R80X`01Jb<R8R<00:/00C@c:b/0m000lc@c002d005
dLc@d=400]000jc<d003c0:/0/`01jc@[:b<[=000Z`01<b/[=02c003[<c<00><0XP00hb/[002R004
[8b8R0:<00N/mM3@mM3j00;e00C<[8b/1XP01:b<d?42n@03lOGe00;e00?Ad=000]000hb/[005[0;@
00>/S8`00m03[003d<c@00;@00G<d:c<[003c003d<b/00O@00S<d=3Ad<c@c0;@00F/c=3<d002[003
d:b/00>/00?@c<`01:`00lc@c007[0?@00>/c<`00Z`3d0AX0d@01RA4A2A4909412@00d@T90039004
A2@T90=40b@00d@T90049003A2@T00/T00=492@01B@00d@T900H9003A2A400941b@3A0LT0T@012A4
A4@390Q400AXR6QX0hP01fR8S8R<R8`00hP018b8R6P2A004J4A4A08T14@290I40R@2A00394A400@T
0T@00bA4900290A40b@6A0/T1D@012A4A2@;A0<T00=494@02d@00fQ4A00=A003J4A400I416P3R0:/
00B<[8b80VP00hR/m@03m@0044@00fQ4J00=A003J4A400A400AXR4AX1T@00fQ4A002A09X0T@016R8
J6P2R0=X00N8J6QXR6R800AX00>8J6P018P3J007R6QXJ8Q4J002R003J8R800UX00>8J6P00hP00haX
J002R008J8R<S8R<[8P2S0:800=XR8P018P00hb8R002R003S8R800F80X`2J0:<0Z`2S003[8R800:8
0VP2R0><0hP01FR8R6R8009X00>8J6P00XP2J003R:b<00:<00>/c:`00j`00m2/[002[0;@00V/S:c<
d:b8S:`00X`00hR<R002S0:/0XP00jb8R004R007S8R/[8b/R002[004d:b/S0N/0]001Jc<[:c<00:/
00?<[:`01J`00m2/[002S0N/00G<[:b/S005[008S8R8R:b<R8`3[008d:c@[<b/dM03[0;@00_adM3A
c=2/d:c@c003d0;A00?@lM000_D01]7elO7ed@?a00O@mO7ed?7@00;a00[elOGAd?7elOGa7?D00oWe
m@0Jm@03lOGe00We00?amOD00_D01/b/S6Q490I400@TA4A40b@2A0DT00E492@TA00;9003A2@T00LT
00=492@012@00d@T900:9003A2@T00LT00=492@07b@3A0DT1D@012A4A4@2J0B80X`5R0IX1D@59005
A2A4A6P00d@5909412@3A0@T00=494@00d@290I40R@2A0<T00A492@T1D@012A4A2@IA003J4AX00I4
00<TA4@01d@00fQ4A006A003J4AX00=X00R<d:b/S8QXA0:800C@lOGe0O40011400EXA4A4J00:A0=X
1T@00fQ4J002J0A400=XA4@00T@5J003R6QX00:80fP3R003J8R800=X00R8J8R8J8R<R0IX00=4J6P0
1FP3R0=X00=4J6P01FP018R/R8`2R005S8R<R8`00XP01:b<R8`3R003S8R800:/00F<[8b8J002R004
S8R<c0:80j`4R003[=3A00>/00><R8`00Z`00hb8d004[004R8b/S0>/1XP01FR8R8S@00>82:`01Hc<
S:c@00N/00^8S8R<[8b/c=2/S003[0><0Z`2R004[8b/c0:/00>8[:`01:`2d0F/00?@[=002J`00hb/
c003[007S:b<S8R/S003[0><00>/R8`00hP02Hb8J8QXS<b/c003d003mM7e00;a00GAmOGel@0<m@?i
00CenOWi0_X00oWjnP06nP03nO[i00;j00Gin_GinP08n@04n_Wjn@Sj00?in_X0<_X3n@Cj1OT01oG@
[8aXA2@02d@00bA49004A0HT00=492@06R@00fPT90039005A2@T94@01R@00d@T90039003A2@T01DT
00=492@01b@2A0HT0d@290940R@2A003J4B800AX00B8J8b80VP;A0<T00=494@00d@39003A2A40094
12@3A00394A4008T00=492@01b@2A0DT00=492@00b@3A00394A400A40R@:A005J4A4A2@02D@7J1Q4
00AXR8R<0XP00jb<S003R003S<ca00;e0M00025400=XA4@00d@00fQ4J002J003R6QX00I40VP018QX
R8P2S0:80VP4R007S8R8R8b8J008R0AX0X`4J0:800AXR8b<18P2J003R6QX00>80X`01Zb8[8b/R0><
0XP01:b<R8`2R0:<1j`01HQXR8b/00?@00B/S<c@0Z`018b8[=02m@;@0Z`028b/d=3<d:c@0Z`00hb/
c003[003S:b800:80h`2R003S:b/00:80Z`01Hb/R8R<00:/00>8S8P00Z`028b8[8b8J:aX1HP02Hc@
lJb8S<b/R002[005dM3@c:`01=0:[0:<1J`00lb/c003[006S:b/[8R/0XP00hb/[003R004J:b/S0B/
0X`00jb<R002R003S8R<00:/00G@dM7ed006m@03nOGi00;e0oTAnP03no[k00;k00Kon_[on_l3nP03
no[j00Oj00?on_X00oX00o_jnP02nP05oo[jooX00_/4nP03oo[j00?j00?kn_/00_X01__jn__jn`;j
00Kkn_[on_/3nP06oo[ono[k0_X00oojo`02nP06oo[joo[k0_X01?ojn_/5nP03no[i00:/00>8J4@0
1T@00bA4A005A0<T00=494@02b@00d@T900=9003A2@T00dT0T@79003A2@T008T00=492@052@00d@T
90069004A2A4A0<T00I494A494@390a400=XR8P00fP;A0<T00=XA4@014@00bA4A005A00394@T00I4
0R@00d@T900790940R@3A0HT2T@00bA4900=A08T2D@3J0:800=XA4@00T@016Q4A6PAA004R:b<S0:/
18`00hR/c003l@7A000PA0AX00=4J4@026P4A005J4AXR:`00X`2R003[8b800B800AXR8aX0XP2S0R8
0X`2R0><0XP00fR8R003R003S8R800:800B<R6R<0XP4S004R:b<R0:<0Z`01Hb/S8R<00:/00F8S:b/
S003[003d:c<00:/00N<d:c@lOG@00:/00K@lM2/S<`2d004mO7Ad@;@00K<dM7amM42[004c:c<c0;@
00>/c:`00Z`2R0F/00?<d=000j`5R003[8b<00B<00>/S8P00hP01FR8R6R800=X0XP2[007R:c@dM3e
d@02l@Ge00?adM000]000jced@03[0:<0j`01Hb/c:c<00B/00B<R8R<0XP00fR8S003[003R:b<00:8
00EXR<c@[002S004R:b<S0:/00?<d=000]46m@03n_Wj01;j0_/2nP03no[j00;j00Okoo_kn_oj00?k
00kjoo[on__jno[kn__jn`?j00Skn__kn__onPCk00?jnol00oX01o_jn_[on_/00oX00o_jo`04n`03
n_oj00;k00?jooX00o/01_okno_onPCo0_/01_okoooko`?k00Gjnooon`02nP07no[jn_G@S002R09X
0d@2J0M400=XA2@01B@00d@T900W90=41B@014@TA4@29003A2@T01dT00=494@01R@00d@T90059003
A2A400<T1T@3J003R6Q400M400<TA2@00R@2A00394A4009400<TA4@00T@2909400@TA4@T1D@49003
A2@T00@T00=494@00T@00bA4A00590Q41B@LA0=X0T@00fQ4A00DA0B80Z`01Hb/S8b/00;@0_41d@7@
000NA0MX0T@00fQ4J00<J0F/00><[8`018P018b/[8`2R0:<00B/R8b<1Z`01HR/S8R/00:<00F/S:b/
d002[005R:b8R8`00j`01=2/[:`2S0:/00C<d:b/0/`2d004dM3@c0C@0m401M3adO7e00;@00GAd=7A
l@07m@;a0]000oGal@02l@08mO7AdO7AlM05d@;@00KAd?7ad?42d003lM3@00W@00>/c:`00Z`2d003
[=3@00;@00?ad=000]001Jb<[:b<00:/0m003?7edM3elOGjnOGim@Oj0_T01?GAdO42d0>/00?<[:`0
0j`00lb/S002[0><00AXR8R<18P00m2/[002[003R8b<00:/00G<d=3Ad005m@03lOGe00?e0_T<nP03
oo_j00?j00?kn_/00oX00o_jo`02n`?j00Gkn_oknP02n`04n_ojo`Gj00?kn_l00_X01__on_ojo`?j
00?on_l00_/2nP;k0_X3n`03oo_k00Gj00Cono_j1O/00o[knP03n`03n__j00;k0ol00o_oo`04n`04
oo_knPCk00?ono/01O/00oojn`02n`06n__jn]2<18P00fQ4A00=A0<T0T@00bA4900:90945b@2A08T
0d@490A400<TA2@012@00d@T90069003A2@T01DT00=492@02B@00d@T900290M416P2A003J4A400E4
0R@2A08T00=494@01d@01BA4A6Q4008T00A492A41b@00d@T90049003A2@T00@T0T@290Q41B@2A003
94A400Y400=XA4@04D@3J19400EXR8R/c003[003R:c@00;@00?ad=000M0001e416P018QXJ6P2A003
J4A400EX1hP01=3Ad=03d@03c:b/00>/0m002O7@d=7elM7@d@02l@05dM3@d=401M000lc@d@04m@05
lOGadO402OD00o7em@07m@03nOGe00;e0oT00o[in@03n@;e00?imOD01?D7nP;i00?enOD01OX2n@Ce
00KimOWimOT3m@;i00?jnOT06?D01?WemOT:m@gj00?in_X01?X00o_jo`03nP0:mOWemO7elOGAl@?@
00GAd=3<d@02d0B/00B<c:b/1=001=7elO44m@?i1_X00oWen@0:nP03no[j00?k00?jno/01?X00o_j
nP04nP03nook00Cj00?kn_/01?/01_[kn__jn`?j0o/02?[knookoo_o0oX00oojo`02n`?j00?kn_l0
0oX03?_jno[on__joo_on`;o00Gkooojn`05nP0<no[onookoo_onook0ol00o_on`05n`05n_oknol0
0_/01?ojnol2n`05oo[jdH`01HP:A00594A494@0:2@01D@T92A4008T14@49003A2A400=46b@00d@T
A00E91940b@6A08T14@290]400<TJ2@00T@:9003A2@T00`T0T@2909400<TA4@01b@?A003J4A400I4
00=XA4@014@2J003A6QX019400=XR=000Z`01Hb/[=3a00;@00?elM000J`000e40VP9A003J4A400=4
2VP2A0AX18P3[003d?Ge00Se00?Ad=400oD01?WemOD2n@oe00GimOWinP02n@05mOWenOD00_X3n@Oj
00?in_X00_X00oWjnP0SnP03no[j01[j00CenOWj1OT3nP03nO[j02Sj0ol2n`?j00?imOD01OD01O7e
dM7e00?a00?AmM000_400m7em@04m@03nO[i00;i2OX00oojnP08nP04oo_jo`;j00Kkn_okn_l2n`04
oo[knP?k00Kjoo_onoX2n`0:n_ojn_ojnoojo`;j00Kon_[on_l2nP?k00?onol00_/2o`0:n_okn_oj
noojo`;j00Cono_o1?X03?_onookoo_jnooko`;k00[ono[on_okn_ok0_l2n`08oo[ooo_onoX3n`06
oo_ono[o0_/00oojo`02nP03oo[o00;o0oX00oF<[004R003J4A400E400<TA2@01R@00d@T90089003
A2@T00PT00=492@01B@01D@T92@000LT00=492@00d@49003A2@T008T0T@M90941R@00d@T90039003
A2@T00DT24@00bA4A002A004J4A4A0@T00A492@T0T@39003A2A4008T0T@290I40R@3A0@T00=492@0
2R@3A0HT0T@290E422@8A00594A4A6P02T@00fQ4A005A005J4A4A6P044@2J007R=2/[8b/c002l@;@
00?AmL`00J`000i400=XA4@02T@2J0941fP018QXA4@3J0>80Z`01?7emOT5nP03no[j00Cj00?in_X0
6_X00o_jnP06nP03no[j00;j00Gkn_[jn`02nP03nooj00;j00?onoX01OX01O_jn_[k00Gj00?kn_/0
0o/00ookn`02o`09n__knookoo_o00;k2OX6n`Kj0_/inP0:nooooo_onoojn`Kj00?in_T01OT2nP04
nO[in@kj00Ckn_[k0oX2n`Gj00Kkn__jnol2n`09oo_joo_jno[o00;k0oX03?_jno_jno[koo_on`;j
00?kn_l00o/2nP06oo[on__j0_/00ookn`02n`;o00[koo_onookoo[o1?/00o[onP02o`;k00Cjnooj
1?/01?okoo/2o`08nooon_ojnol2n`05oo_onol00_/00o[on`03o`03n_oj00Co0_/01Oojoook00;o
00?koo/00ol2n`;j00?e[:`00XP2S004R4AXJ0E400<TA2@00T@F90=400DTA2@TA0049003A2@T00/T
00=492@00b@00d@TA0039003A2@T00DT00=492@0;2@;A003J4@T00940b@014@T92@2A0DT00E492@T
A0029004A2@T90940R@00d@TA003A00394A400dT0T@590940R@2A08T0T@590=400PTA4@TA2A490A4
0VP<A004J4A4A09X1D@00fQ4A003A003J4A400=400PTA6R<R<b/R0:<00C@lOF/0m02[0006D@00fQ4
A002A003J8QX00EX00>8J6P00VP028R<R8R/d?Gj0_/00o[ko`04o`03nook00;o00?kool00_l00o_o
o`02o`03nooo00Wo00?koo/01Ol02o_ooo_joo_onook00;j00Konooonol2n`So00Gkoo[on`03o`04
noojo`;k0_l01?_on_X2o`06nookoo_j1Ol01o_onoojnol00_/00ooko`02n`;o00?koo/00_/02O[k
no[ono[onP02n`03n__k00Gk00?jnoX00_X00o_jn`02nP03oo_j00?j00Okn_ojno[k00?j00Kkn_[k
n_l=nP[o00Gkoooko`05nP0;no[jn__ono[on_/00oX00o_jn`04n`07n_okoo_jo`02nP04oo[jn`Cj
0_/01_[kno_onP;o00Cjoo[k0_X01?okn_/2nP;k00Cjno_o0o/01?ojnoX5n`04n_ojnP;k00Kjno[o
noX2o`03n_ok00?k0_l00o_oo`02o`;k00Con_ok0_l00o[ko`03n`07oo[on_oko`03n`03oo[o00?k
00Kon_ojooX3o`04n_ojo`?k00?onol01O/01_okno_on`;o1?/01Ookoo_o00;k0_X00oG@[002J0>8
00=XA6P00VP3A0XT0d@=90A400<TA2@00T@4909442@2A0@T00=492@00b@2A0hT0T@?90E400<TA2@0
12@00d@T900390A40VP4A003J4A400A41R@4A0XT0d@59003A2@T00=400<TA2@052@014@T92@2A0<T
0T@2909400DTA4A49002A0@T1D@00fQ4A00:A004J4A4A09X0T@00fQ4A002A003J4A400U400=XR8P0
0X`00jb<c002d@;@00?Ad8`00XP001U40VP3A09X00A4J6Q41VP3R008J8b/d?Gkoo/bo`03nook00?k
1_l01O_ooook00;o00gkoo_onookoo_onook00;o00Ckn_oo0o/00ookn`04n`05oo_ooo/01?l02?_j
nookn_ok0_l3n`?o00Gkn__knP02n`04n__jnP?k00Cjno_o1?/7nP03no[j00_j00Ckn_[j0_/:nP03
nO[j00Cj00?onol00_l00o_oo`07o`08nookoo_onol5n`03oo[k00Kk00Gjoo_knP03n`07n__ono[k
nP03n`;j0_/00o[kn`02n`;j00Ckn_[k1?X2n`03n__j00Kj0ol2n`03n__k00Ck00Son__jno[knP;k
013ono[koo_on__joo[onook0_l2n`04oo[on`?o00ckoo_kn_ojoo_on_l3n`0:oo_kno[koo_onPCo
00Ckn_ok0_l2n`03oo_o00;o0o/3o`03nooo00?o00?kool01Ol2n`;j00Cid:aX18P4J003R4A40094
12@00d@T900290A42R@6A0<T0T@390940b@00d@T90029003A2@T00LT00=492@022@4A00394@T00DT
00=492@00T@00bA490079003A2@T00@T0d@00bA490059003A2A400@T1T@2J004R6QXJ0E400<TA2@0
1B@00d@T90049003A2A4009400<TA2@022@2A00394@T00<T0d@A90=400<TA2@00b@00d@T90059003
A2A400Y400=XA4@04d@01FQ4A4AX00]400B8[:b/0]001=7adL`2d06/0HP1J0006d@00fQ4A002J094
0fP00dAXJ006J005R<cenO/0;_l00o_jo`06o`03nooo00Oo00?kool01Ol01O_ooook00;o00Ckoooj
0ol01O_ooook00?o00Ckn_ok2Ol01?_on_/6o`;k00?onol01?l00o_on`02n`05n__jooX00_/2nP?o
00Ckoook0_X01O_jn__o00Sj00?kn_X01OX2n`03oo[k00?j00?kn_X02?X01O_onook00oo00[koooo
noojoo_o0_/2o`;j0_/01?[onol2nP06oo_joo_o0_/00oojn`03n`03oo[o00Gj00?kn_X00oX01_oj
oo_jo`Cj017on_[koo_on_okn__on_oknP04o`0;n_ojno[on__joo/00_X01Ookoo[o00;k00Cjoo[o
0_/01Ooknooj00;o00Kkoo_jooX2o`;j00?on_l00_/01_ojnoojo`;k00Gono_onP02o`05n_oonol0
0_/4o`09nooonoojnooj00;o00KkoookooX2o`;j00Gon_[jd@02R003J4AX009400IXA4AXA6P2A0<T
0d@29004A2@TA0XT0T@39003A2@T008T00A492@T0T@390A41B@5A00394A400@T00=492@00b@00d@T
90039003A2@T00HT00=492@01B@00d@TA00890=42R@00d@T9003A003J4A400940fP00hQXR002J0=4
1R@01T@T92A490940R@5A0DT00A492@T0d@00bA4900490=41B@00d@T90029006A2A494@T14@00bA4
9002A0<T00=492@00b@:A00594A4A6P01d@016Q4A6P;A09X0T@00fQ4A005A00:J8R/d<c@mO7Ad0:/
00?@c8P00D@001]40VP6A09X00A4J4A41FP00hS@m@02nRGo00?kool01_l2nPCo00Gkoo_on`03o`05
nooooo/00_l02o_ooookoo_onooj00Go00Skoooon_oko`;k0_l00o_onP03n`So0o/4o`03nook00?k
00Gjnooko`02n`05oo_onoX01?/01?oknol5n`Kj00Ckn__k1?X2n`04n__kn`?j00?kn_/00_X00o_j
n`0=nP06oo_on_ok0_l00o_oo`02o`07nookoo_on`03o`03nook00;k00Con_oo0_/00oojn`03n`03
oo_o00?k00Cjoo[j0o/01_ojno_jn`Gj00?kn_X01OX00o_jnP09nP03oo_j00?k00?jnoX01O/01?[o
nol2n`0:n_ojoo[kn_oknP;k00Sjoo[on_ojo`?k00Con_ok0ol00o_on`02n`03oo_o00;o00Kkoo[j
nol3n`?o00?kooX01Ol00o_on`05o`03nooo00;o0_/01?ojnoX2o`04nooon`Go00Ckoo_k0oX01?F/
J4@2J0I40VP2A0HT00=492@01R@00d@T90089005A2@T94@032@2A0HT0d@=90947R@014@T92@2A08T
0T@00bA490029003A2@T008T0T@3J003A6Q400EX1d@390941B@3A00394A400=41B@;A0DT00=492@0
2R@014@T92@4A00394@T00=400<TA4@00T@390=400<TA4@02d@00fQ4A005A003J4A400]400=XA4@0
1d@00fR8[002d0?e0]03[0:<0FP002=41FP014AXJ6P3R005c=7en_/0;Ol00o[oo`0:o`;k00Gono_o
n`07o`07nooooo_on`07o`03nooo00Ko00?kool01Ol00o_on`03o`;k0_l2n`03oo_o00;o00?kool0
1ol2n`04n__on`;o00Cjoook0_l01?_on_/3nP03no[k00;j00Kkn_[kn_/2nPCk00Gjno_jn`02nP04
no[jn`_j0_/00oojo`06o`03nook00Go00Wkoooonookoo/00ol03?_onookoo_onooknP;k00?jnol0
0o/01_ojno_jna3j00?kn_X01OX00o_jnP02n`04n__kn`?j00Kkn_ojnoX3n`03n__k00;k00?on_/0
0oX04?okno[onookoo_on_ojnoX3o`03nooo00;k00Gonoojo`09n`05oo_on_l00_/02O[on_ojoo_o
n`05o`Gk00Kon__jnoX3o`03nooj00Ck00_ono_koo[kn_W@R002J0I400=XA4@00T@I909422@00d@T
900J9003A2@T00TT00=492@01B@00d@T90029003A2@T00DT00=492@012@014@T94@490A400<TA2@0
0T@01VR8J4AXA0=X00=4J4@00T@00bA4A004909400<TA2@012@7A0HT0d@29005A2A4A2@00T@49094
00<TA2@02b@9A08T2T@01RA4A2A490Q400=XA4@04T@2J0U400EXR=3@d@02m@04lM3@[0:<0XP1J000
00=XA4@07T@:J005R6R8R8`00Z`00oGjnP0Xo`05nooooo/04?l2n`;o00?kool01Ol2n`Co00?kool0
0ol3n`03oo_o00;o00Kkoo_onoX2n`;o00?kool00_l01?_ooo/4o`03nook00;o1?/01Ookoo_o00Kk
00Kono_onol2n`?j00Cono_k1_X01?_jn_/@nP03no[j00[j00?koo/01ol3n`?o00_koooonookoo_o
n`03o`?k00_on__koo_on__onP03n`;j00?kn_X06?X01__jno[on`Cj1_/00oojn`06n`09n_ojoo_o
nook00;j0_/01oojoo[kn_/01?l00o_jnP02n`0:oo[onookoo_onP;k0_X01Ookno_o00?k00?on_l0
0_/01Oojn__j00Go00?koo/00_/00o[ko`03o`07nookn_ojo`02n`05oo_onoX00o/4o`;j00?aS8P0
3D@B9003A2@T00dT00=492@0:R@01D@T92A400PT1T@00bA490059003A2@T00@T00A492@T0d@3J003
A6QX009400=XA4@01d@00bA49002A00394@T009400<TA6P01T@00bA4A00490941B@2A00394A400@T
0d@=90941B@4A00394A4009400EXA4A4900IA006J4A4A6Q40fP7A009J4A4A6R8c=3A00;a0m001:b8
R6P2A0008T@2J09426P028R<S8b/mOWj8Ol00o_oo`05o`03nooo017o00Ckoook1ol00o_oo`03o`03
nooj00Go00Ckoo_o0o/>o`;k1_l01o_ooookoo/00_l01?_ooo/2o`03nook00;o00?kooX00_/2nP;k
00?on_/00_l01o_on_[kn_/00_X01?okn_/4nP04oo[jo`Cj00?kn_X03OX00o_oo`07o`;k00Conook
0ol00o_on`03o`03nooj00?o00Ckoo[o0_/2o`03n_oj00;k00?jnoX03?X01?_jn_/4nP06no[jno[k
0_X00o_jnP05n`05oo_knol01?X02Ookooojoo[ko`02n`0<oo_onoojno[onook1?X00ooko`02o`05
n_ojoo/00_l00o[ko`02o`;k00Sjoo_onooknP;k0_l02?_ooo[koo[o0_/01Ookoo_j00?k00Gjoo_o
n`03o`0;nookoo_joo_jooX00_l2n`?o00?joo/00oX00oF/R003J0A400EXA4AXA0029003A2@T04dT
00=4J2@022@014@T94@290=400<TA4@00b@3A0@T00=494@014@2J004A6R<J0Q400<TA4@02T@012A4
A2@5A0@T1D@2909412@2A0<T0T@00bA4A0049003A2@T00HT00A494@T0T@00bA4A00<A003J4A400m4
00=XA4@01d@00fQ4A004J0U400AXR:c@0_D01M7@c:b8009X0d@001a400=XA4@00d@3J0A426P01Xb/
d?Gjna?o00?kool01Ol01?_ooo/5o`03n_oo00;o00Ckoook0_l01O[ooo_o00;k00GonooonP02o`04
nooon`;o00?koo/00o/2o`03n_oo00;o00Cjnooj0_l00o[ko`04n`03oo_k00Co00Wjoo_koo[koo/0
0_l01O_on__o00;j00Kon_oon_l2nP0:oo_ooo[ono[onP;o00gjoo[joo[koo_joo[o00;j00Won_[o
n_okn_l00_X01_ojno_jo`;j00?kn_X00oX00o_jnP05nP06no[joo[o0_/2o`06nookoo_j0_/00o[o
o`02o`;k01Con_okn_ojnoojnoojnoojoo_jo`;j00Kon_[kn_l2nP03no[j00;j00Ckn_[k1OX00ooj
n`02nP04oo[jo`;j00?kn_l00_X01_ojn_ojo`;j00Ckoo[o0_X01_ojn_ojo`;j00Son__on__jn`?j
00?on_/00_X01?_on_l2nP08oo[joo[on_/2o`04noojo`?k00Conooj0_/01o[koo[on_/00_l02o_o
n_okn__on_ok00?o00?kool01?l01?[knoX2n`06n_ojnooj0_l2nP03oo[k00?j00?@R6P00fP9A004
94A4A08T00=492@00R@00d@T900V9006A2@T94@T0d@390946b@7A08T00A492@T0T@012A492@BA004
94A4A0DT0d@016Q492@4A00394@T00A40b@2A00394@T00/T0T@00bA4A003A0<T0d@8909400@TA2@T
0T@00fQ4A002A003J4A400=40VP00dAXA00GA0=X00=4J6P00VP5A09X00I4J6R<[=43m@;@0XP00fQ4
J002A00094@2J0U40fP01HR/d?Gj00[o00?kool04ol00o_oo`05o`03nooo00ko00?kool02ol00o_o
o`03o`03nooj00;o00?koo/00_l01?_oooX5o`06nooonook0_l01__ono[on`;o00?koo/00o/01_[o
no_on`;o00?jool01Ol01__on_[onP?k00Conooo0_/01?ojn_l2n`03oo[o00;k00Oon__kn_oj00;k
0_X00o_jn`02nP03no[j00_j0_l01?_onol3n`?o00?koo/00ol00o_on`02o`05nooon_l00o/01?ok
oo/3o`04nooko`Gj00Kkn_okn_/2nP04no[jn`Cj00Ckn_[k0_X01?_jn_/4nP04no[jo`;k0_X2o`;k
0_X01_ojn_ojn`;j0_/01?[kn_l5nP03no[j00Gj00?kn_/00_/01?[kn_l2nP0Dno[jno[kn__jno[o
n_ojno[kn_/2nP;k00Cjno_o0_/02ooknookoo_onook00?o00Okoooonook00Cj00Ckn_[j1?/01?ok
oo/4nP03dHb800:80VP7A0<T0T@690949b@00d@T90059004A2@TA08T00=492@06B@5A0@T00E492@T
A002909400<TA4@00b@=A00594A4A2@00T@290E40b@2A0@T0d@39004A2@T90941b@00d@T90029003
A2A400A40R@4A00394@T00@T0T@29003A2@T00a416P00hQXJ002J1=400AXA6QX2d@00fR8J002J005
S=7elM000/`00haXA003A04T000AA003J4A401]40fP01hR/[=3en_/0=Ol00o_onP0Go`Ck0_l02__o
nookoo_on_/4o`?k00Cono_k0_l00o_on`02nP08nookno[kn_l2n`04n__on`?o0o/2nP;k00Gonooo
n`02o`;k00Cono_j0_/01?oknol6n`Cj00?kn_X05?X01Ookno_o00Gk00[onoojoo_onook0ol01O_o
n_oj00;k00Wonoojoo_onol00_/5nP03no[j00_j00?kn_X00oX00o_jn`0:nP;k00Gon__jn`03nPGk
00?jnoX01_X00o_jnP03nP?k1OX00oojnP08nP06no[jno[k1?X01?_on_/3nP06no[ono[o0_/01_oj
oooko`;k00Son__joo_onPWo1O/00oojn`02n`05oo[joo/00_l02O_jn_[e[6R8J007A00394@T00TT
00=492@02b@00d@T90029003A2@T00PT00=492@05B@00d@T900J90=40R@3A08T14@99003A2A400=X
00>8J4@01T@490940b@8A00394@T00lT00=492@00b@2A00394@T00@T0d@290E41R@2A00494@T90]4
0VP2A0R800UXR6Q4J4AXA6P00d@4J0Y400=XA4@01D@02FR8J4AXS=7el@03[003J4A400A4000XA0=X
0d@5J007R8b<d?Gjn`0=o`03nooo00So00?kool01_l00o[oo`0=o`03nooo017o00ckoookoo_onooj
ooX9n`03oo[j00;k0_l00o_on`05n`;o0_/2o`04nooknP;k00Sono[on__on`;o00Gkoo_ko`02n`?o
0_/01?okool2n`03oo_o00;j00Gon_[onP02n`04n_okn`_j00?kn_X03OX01?okool2n`06oo[knook
0_X00ooko`02o`03nooj00Co00Gjnooko`03n`05oo_onol00_/6nP04no[jn`Sj00?kn_X00_X01__j
n__jn`;j00Kkn_[kn_l2nP06no[joo[k0oX00o_jn`02nP;k00Cjno[o1OX3n`;j0_/01_[kn__jo`Cj
00?kn_X00_X00o_jo`04nP03nook00?k00cjno[on_ojno[on_l3n`?o00Okoo_jnook00?o00Gkoooo
n`05o`05n_ojooX00ol00o[onP02n`03oo_o00;k0oX00oF<R004J0=400LTA2@TA2A401DT00=492@0
1B@2A0/T00=492@08R@00d@T900:9003A2@T00PT0T@29003A2@T008T0T@01BA4J6Q4009X00I4J6QX
R6P4A0@T2T@00bA4A0029003A2@T00DT00=492@00b@2A0<T00E492@TA00490940R@5A0DT00A492A4
0R@?A004J4B8J0:800AXA6QX0XP3J003A6Q400940fP6A003J4A4009X00E4J4A4J004A003R6QX0094
00IXS:cAd:`3J0I40008A003J4A401e400=XA6P00d@00fQ4J002J005R6R8R=000_X<o`04n__onP;o
00?kooX00_l01?_on_X2o`06n_oonook0_l00o[oo`09o`03nook00Go00?koo/00_l01?_ooo/2o`05
nookn_l00_/01_ojoo_jo`;j00Sono[on__onP;o00?jooX00_l02O[ooo[ono[onP02o`04n_oknP;o
00[joo_joo[ono[o0_/01_ojooojo`;j00Kon__on_l2nP;o00Gjoo[jo`02nP03no[k00;j00Kon__o
n_l2nP06no[jno[k0_X00o_jnP03nP05oo[jn_T01OX01?_oool3n`;j00?on_l00_X2o`06n_okn_oj
0_l01?[on_/2o`0:n_okoo_jnoojo`Gj00Kon_okn_/2nP04no[jn`;j00?on_X00_X01?_jn_l4nP04
oo[jo`;j00?kn_l00_X01?_jn_/2nP06oo[joo[o0_X01_ojn_ojo`;j00Oon__on_ok00;j0_/03?oj
n_ojnoojoo[ko`;j00Kon_okn_/3o`08n__kno[kn_l2n`05oo_kooX00_l02?_ooo_onook0ol00o_o
o`02o`03nooo00;o0_/02Ookooojnooko`02n`?o0_/01_[kn_F/R09X2d@39003A2@T028T00=492@0
82@00d@T900?9003A2@T00HT00A492A40R@00d@T90029004A2@TA0=X00=4J8P00XP3J0E40b@00d@T
A00:A0XT0T@29004A2@TA0LT00=492@00b@7A00494@T90=40R@2A00394A400Q400=XA4@00VP2A09X
00>8J4@00T@01FR8R8QX00=41FP2R09X0T@2J003A6QX009X24@00fQ4A002A09X0Z`01<b/R6P2A003
J4A40094000`A003J4AX00=X00>8[?D00_X?o`Cj00?kn_/00o/00o[ko`04o`03nooo00ko00?koo/0
1ol00o_oo`06o`04n_oonPCo0_/00oojo`04o`06nooonook1Ol01__ono_on`;o00Gkoo_ko`02n`09
oo_koo_ono[o00;k00GonooonP02o`03n_oo00;k00Ojoo_joo_o00;k00Cjoo_o0_/01Ookn__j00;k
1?X00oojnP08nP03no[j00gj0_/2o`05n__onol00_/2o`04nookn`Co00?joo/00_l2n`04oo_knP?o
00?koo/00_l00o[ko`02n`07n__ono[onP02n`05n__jn_/00_X02O_jn__jnoojo`05nP03oo_j00;j
00?kn_/01OX2n`?j0_/00o[kn`04nP06nookoo_o0_X02?_onoojoo_o0_/00o[onP02nP05oo_on_/0
0_X3n`0<oo_onookoo[on_oj0o/02_[on_[koo_onol3n`04oo_on`Oo00Okoo_kn_oj00;k00Kono[k
oo/3o`04n_okn`?j00Ke[8R8J8P9A0<T00=492@03B@2A0DT00=492@0:b@01D@T92A401hT00=492@0
1R@2A09X00=4J6P00hP00fR8J003A00394@T008T0T@291140b@2A08T00A492A41b@;A003J4A40094
00DTA4A49003A00394A400U416P2A0=X0T@2J0F80T@016Q4A4@2J0>800EXA6QXA004J0m400AXS:b/
0XP00fQ4A005A000<4@7J005S=3emOX01ol00o_oo`02n`;j00?imOT02OX00o_oo`0Oo`03n_ok00Wo
00Kkn_[onol;n`;o00?kool00_l2n`03oo_k00Gk00Conook0_l5n`;o2O/01?oknoX5n`03oo_k00?k
00Cjno_j0o/3nP07no[jn__jn`0LnP07oo_on_oko`03n`09oo_onookoo_o00;k00Wjoo_on_okooX0
0_/01Ookno_o00?k00Kono_jooX3n`03n__k00Oj1O/;nP04no[jnP?k1OX00o_jnP04nP;k00Cjno[j
0o/01?okooX4n`03oo[o00?j00?kn_l00_/01o[knoojnoX01?/01Ookoook00Co1?/01?[kn_/2nP?k
00?on_l00o/00ooko`03n`Ko00Kkoookoo/2o`06noojn_oj0ol01?[kn_l3nP03mJb<00:800=XA4@0
0d@29003A2@T01HT00=492@00b@014@T94@:9003A2@T00hT00=492@08R@00d@T900<9003A2@T008T
1T@3J0:800F<A4A49003A00394@T00m400<TA4@01d@01bA4A4@TA2@00T@290I400=XA4@07D@01FQ4
A6Q4009X14@026R8R6R8J4AX1D@2R0AX00=4J6P00fP2A003J4A400Y400IXR:b/R6P8A000:T@01VQ4
A4AXA0MX00F8S:cenP02n`?o00Gkoooon`02nP05nOGemOT02OX2n`_o00?kn_l04_l00o_oo`05o`03
nooo00;o00?kn_l01?l2n`Co00?koo/00_l01?[ono/4o`03nook00Go00?koo/00_l01__joo_jo`?k
00Gjno_ko`04n`04oo_ko`Ck00Oono_ono[k00;j0_/2o`06n_oknook0_l00o_onP06nP03oo[j00[j
00?in_X01?X3o`?k00Gonooko`02n`;o00Wjoo_koo_jooX00_l01o_ooo_onol00o/00ooko`02n`09
oo_joo[ono[o00Cj00Gkn_[jn`02nP03no[k00;j00?kn_X01OX01O_jn__j00;k00oono[joo_joo[k
oo[on_/00_l01_[onooknP;o00Kkoo_onoX2n`04n_oknP;o00Sjoo[ono[knP;k00?joo/00ol00o_o
n`02o`08no[knookn_l2nP05oo[on_/00_l01?_ooo/2o`03nooj00Go00?koo/01Ol01?_on_l2n`?o
00[kn_[jno[kn_G@0Z`018QXJ6P3A08T00=492@00T@69094C2@00d@T90069003A2@T01@T00=492@0
0d@2R09X0d@00bA4900290E400<TA2@01T@016Q4A2@2A08T2T@00bA4A008A005J8Q4A6P07D@016Q4
J6P2A004J4A4A09X00=4J4@00d@2J004A6Q4A09X0XP6A003J4A4009X2T@01VR8S:b<R09400=XA4@0
14@002i416P2A0AX00>8[=000_X3n`Co0oX01?GamO43m@Wj00GonooonP0=o`04nooon`;o00?kooX0
0_l01?_oooX2o`03nook00Go00Gjoooko`02n`0=oo[ooo[koo_ono[on`02o`09nooon_ojnooj00Co
0_X01?ojnol2nP06oo[kno[o0_X01_okooojo`;j00Kon_oonol2nP0@oo[ono[koo[ono[on__onP;o
00[joo[joo[ono[o0_X01?ojnol2nP05oo[jn_T02oX01_oknoojo`;k00Con__o0_X02_ojnoojoo_j
oo/2o`08nooon__on_l2nP09no[joo[ono[o00;j00?on_l00_X00oojnP06nP06oo[kno[k0_X01_oj
n__jo`;j00ckn_[on_okn__on_l2nP06oo[koo[o0_X01_oknoojo`;j0o/00oojn`02nP04noojo`;j
00Kon__kn_l5nP04oo[on`;j00Gonoojn`03nP03oo[k00;j00Kono[on_l3n`?o00?kool00_/3o`04
no[on`;o00?koo/00_l2n`04oo[oo`;j00Conook0_X01OG@d<b<009X14@00bA4A002A0@T0T@29094
=2@00d@T900;9003A2@T02XT14@016Q4A4@29003A2@T008T1d@00bA4A00:A08T0T@291140VP00hQ4
A004J0a40VP;A0QX0T@00fQ4J007A0AX0T@2J007R6Q4A6Q4J003A003J4A400940VP4A09X0Z`018QX
J4@2J0I4000VA0=X1T@8J0>800>/mOX00_X4o`;j00GelO7ad@03m@03nO[j00Sj7_l3n`04oo_on`Wo
00?jool00ol01O_ono_j00;k1?l00o[on`02o`;k1?l00o_on`03n`0:oo[ooo_joo[ko`;k00?on_l0
0_/00oojo`05n`04oo[ko`Ck00?onoX00o/04_okoookoo[koo[koo[ono[onP?k00?on_/04_X01?_o
ool2n`;o00Cjnook0_l01?[on_/2o`03nooj00Go00?koo/00_l01__ooo_on`;o00Skn_ojoo_jn`_j
00?kn_X00_X01__jn__jo`Gj00Ckn_oj0_/2nP04oo[ko`;k00?on_l00_/01_okn_oko`?k0_X01Ooj
oo[k00?j00Gon__on`03nP04no[jo`;j00?on_/01OX00o_jo`02n`03n_ok00Ck0_X01?_jooX3n`;o
00?kool00ol00o[kn`02o`;k00?onol00ol2n`03oo[o00?k0ol03?[knookoo[ed<b/S0=X1T@012A4
94@39003A2@T02TT0T@<9003A2@T01LT00=492@05B@2A0LT2D@59005A2@T94@00b@<A00594A4A2@0
4T@5J003R6QX009400=XA4@00d@290=400=XA4@014@00fQ4A002A0AX00B8J6QX1d@00fQ4A009A0=X
0d@2J0=40VP3A003J4AX00A400EXR8R8J00:A0009d@2J003A6Q400A41FP00hQXJ002R00;S=3emO[k
oo_jnO401=02l@;e2_X01O_ooook00oo00?koo/02?l01?_ooo/2o`09nookoo_onook00;o00Okoooj
oo_o00;k00?jno/01?l3n`?o00?kool01?/2o`04nooko`Ck00?joo/01?/01Ookoo_j00Ck00Kjno_k
ooX2n`?j3?/01?oknol3n`04n__ko`Ck00?jnoX04oX4n`03oo_o00Gk00oon_ojno[kn_okoo_onol0
0o/01Ookoo_o00;k00Cjno_k0oX3n`?j00Okn_[jno[k00[j00?kn_/01OX00o_jnP02n`?j00Ckn_[k
0_X2n`05oo_kn_l01oX00o_jn`0?nP03no[j00Wj00_kn_[jno[on_ojn`03nP05oo[jn_/00oX4n`06
oo[knook0_X01_okoo_on`Co00Ckn_oj0o/03_okoo_joo_onoojmM3<0X`3J003A6QX00=400<TA4@0
0T@C9003A2@T01PT0T@>9007A2@T94@TA00A9005A2@T94@01b@00d@T90099003A2@T00@T00=492@0
1d@01BA4A4@T00=40R@014@T92@3A09X0T@290E40b@2A0<T00=492@01T@2J0=40fP2R0I40fP00d@T
A007A08T1T@3J003A8Q400A40VP3A0=X1D@00fQ4J002A003J4A4009400=XA4@034@3J004S8R8J0Y4
000WA0=X0d@016Q4A4@3J0B800MXR8R/d=7e00;j00?imO400m02c004d=7Am@[j00?kool01ol00o_o
o`03o`07nooooo_on`0>o`03nook00?o1?/4o`;k1?l00o_on`05o`03nooo00Go00?koo/01_l00o_o
n`02o`03nook00;o1?/01?oknol2n`05oo_knol00o/00oojo`03n`04oo_on`;o0_/4o`09nooknooj
oo_j00;k00?onoX00_/@nP;i0_X01o_onookoo/00_l02?_jno_on_oj0ol3n`06oo_onook1Ol01__o
nooko`Oj00?kn_/00oX00o_jnP0;nP03no[k00Gj00Ckn_[o0oX3n`?j1?/2nP03oo[j00Gj00?on_X0
0oX00oojn`0;nP03no[j00Gj00?kn_X01OX00oojnP03nP03no[k00;k1OX00o_jn`02n`09n__koo_o
nooj00;k0ol01O_onook00?o00?koo/00ol00o_on`03o`06n_WAd:b<0XP2J004R:b/J0A4@b@00d@T
900=9003A2@T00dT00=492@02R@00d@T9004909400<TA4@00d@5909400<TA2@00R@9A00394@T00=4
00<TA2@022@00d@T9009A003J4AX00=400=XA6P00VP3A003J4A400a400<TA4@00fP018QXA6P5A09X
14@3J0I400AXA4AX2D@00fQ4A002J0I400AXR8b834@002Y400EXA4AXA002J003A6R800>800B<R6QX
0XP00jc@d007d0?<00G@lOWjn@08nPKo00Gkoooon`0No`03nooo00?o00Gkoooko`02n`;o00Cjno_k
1?l01_[kno_on`Co0_/01_okoooko`;k1?l00o_oo`03o`04nooon`;o0o/01Oojnooj00Go00Gkoo_j
o`02n`03oo_k00;j00Gono_on`02o`05n_ojn_/00_X00o_jo`0CnP;i00?jno/00o/3o`?k00Gon_oj
n`04o`03nooo00?o00_koo_onookoo_onP02n`Cj00?onoX00_/LnP03no[k00;k00Cjoo[k0_X2n`03
n__j00Cj00?kn_/00oX01O_jn_[o03Oj00?on_X01OX4n`04oo_oo`Ck00?onol01?l3n`05oo_jlJ`0
0X`5R004[=28J0A40R@2A2hT00=492@01R@00d@T900D9003A2@T014T0T@01RA492A490942B@016Q4
A4@990M400<TA2@00T@690A40R@2A00594@TA6P01d@016Q4J4@2J0A41FP7A09X1d@012A4A2@7A003
J4AX00A400IXA4A4R6P8A004J4A4J09400=XA4@01d@2J0E400EXR8b<J00:A08T000YA007J4A4A6Q4
J002A09X00B8J8R80fP2R004S<b/c0O@00B/c=7e2oX4o`03n_oj00;o00Ckoook0_l00o_oo`02o`;k
00GonooonP0>o`03nook00;o00Kjoo_jooX5o`03n_ok00;o00?kool00_X01oojoo[koo/01?l2n`03
oo[o00;k0_l01O[ooo[o00;k00Konooon_l2nP0:oo[joo_on__onP;o00Skn_ojoo_jo`;j00?on_/0
0_/01Ooknooj00;o00Kkoo[jooX2na3j0_T02?[in_ojoo[k1?l00o[ko`02n`03oo[o00;k1?l02__o
oookoo_on_l2n`;o00?jno/00_/2nP06oo[kno[k0_X01?ojn_/;nP;k1OX02Oojn__joo_jn`02nP03
no[j00;k00Cono[k0oX3n`04n_ojn`Gj00?kn_X05OX00o_jnP05nP03no[j00Oj00?kn_X00oX5n`Oj
00?kool01?l2n`03n_oo00;o0_/3o`;j0_l2nP03mLb/00:/1hP3J0M46R@00d@T900E9003A2@T00XT
00=492@032@00d@T900:9003A2@T00DT0d@>90A42B@5A00794A494@TA0069003A2@T008T44@00fQ4
A002A004J4AXA09X00B8J6QX2T@00fQ4A00?A09X14@2J004A6QXA09X00=4J6P00fP5A005J4A496P0
14@3J0E400EXR8b<J006A004J4A4A08T000>A003J4A401Q400=XA4@00d@5J0:800=XR6P00VP2R003
S:c<00?@0/`01Jc<c:c@00;e2oX8o`03nooo00?o00?kool00ol00o_oo`04o`;k4_l00o[on`09o`04
nooko`;k0_X00o_on`05o`03nook00Co00Kkoooon_l3n`05n__onol00_/00ookn`02n`04oo_ko`;k
00kono_onookn__jnooko`;j00Kkn_[on_l5n`04oo_knP;k4_X00oWjn@03nP03nook00?o0o/00ooj
o`02n`07oo_joo_on`02o`07no[on_ojn`02o`05n_ojn_/01?X01?okn_/2nP04no[jn`;j00?kn_X0
1OX00o_jnP03nP03no[j00Kj1O/00o[kn`04nP?k0oX01?_jnoX7n`oj00?kn_X03OX01O_jn_[k00Wj
00?on_/00oX00o_jo`04nP;k00?jnoX00_/3o`05nooknoX00_/01Ookoo_o00?j00?kn_/00_X01?G@
c:`8R0AX00A496R80d@R9003A2@T01<T0d@3909472@00d@T90059003A2@T00TT00=492@01D@99004
A2@TA0@T0d@29005A2@T94@012@4A00394A400e400=XA4@00d@4J003A6QX00]400<TA4@01D@00bA4
A007A005J4A4A6P014@00fQ4A002A09X00=4J4@03T@00fQ4A003A003J8QX009X2D@1J0540B@000a4
00=XA6P084@2R008J8R8J8QXR6P4R0:/00><c<`01L`00jc<l@02m@Wj0o/3o`03nooo00Wo00?kool0
2Ol00o[oo`05o`03nooo00;o00?kool00ol01?_ooo/2o`03nook00;o0_/00ookn`05n`04n__on`?o
00?koo/02?l01__ono_on`;o00Ckoooj1?/2o`;k00?onol01?/01?[kn_X4n`05n_oknol00_/00ooj
o`02n`04oo[jo`;k00?on_/00_/01?ojn_/=nP?i0_X02?okoookoo_o0_/01?[onol3n`04oo_on`Go
00?kooX00_/01Ookoo_o00;k00?jooX00_/01o[kno[on_/00oX01__jno_jo`;j00?kn_/01?X00o_j
nP03nP05no[joo/01?X00ookn`02nP09noojno[koo_o00;j00Kono_on_l5nP04no[jn`;j00?kn_/0
0_X01__jn__jn`?j00Skn_ojoo_jn`;j00Gono[onP02n`03n__k00;k00Kjno_joo/2nP;k0ol01o_o
nookoo/00_l2n`03oo[o00Ko00?jnoX00_X01ookn_Wad8`00hP02dAXJ4AXA6R8J4@T00A400<TA2@0
22@00d@T900D9003A2@T01<T00A494A40b@00d@T900E9003A2@T02<T00=492@00R@00d@TA0079003
A2@T00<T0T@390940R@=A00494A4J09400AXA4A40VP3A003J4AX00U400<TA2@02T@00fQ4A00=A0=X
00=4J6P00fP8A003J4A400Y40VP9A00494A49054000YA003J4A400=40fP00hQXJ005J008R8b<[8b8
[=02c005[<c<[=000oD8nP05oo[ooo/00_l00o_oo`0Ko`;k00?onol01?l01_[ooo_on`;o00?jool0
0_/00ooko`02n`0=oo_koo[ono[on__on`02o`06n_oknooj0_l00o_oo`02n`08oo[ooo_onol2nP;k
0_l2n`03oo_o00;k00?on_/00_/01?[onol2n`09oo[joo_ono[o00;k00Kon_oonol3n`08n__ono[k
n_/=nP03nOGj00;k00Oono[koo_o00;k00Son__on_oknP;o00?koo/00_l02?_ooo_onook0_X01_ok
oo_jn`;j00Kkn__kn_/2nP03oo[j00?j00Kon__kn_/2nP06oo[jno[k0_X01__jnoojn`;j0_/01O[k
n_[o00?k00?jooX01?X00ookn`05nP03no[k00?j00?kn_/00_X00o_jnP02nP03no[j00Gj00Ckn__j
0_/00ookn`02n`05n_ojooX00_/03_okoo[ono[koo_onooj0_/01?ojooX5o`04noooo`;j00?kool0
0ol2n`05n__jn_l00_X00oG<R003J0U412@3A0lT00=492@00R@00d@T900S9003A2@T00lT00A492A4
1B@00d@T900K9005A2@T94@01b@00d@T900890A412@2A0<T00I492A494@390Y400=XA6P014@2J004
A6Q4J0U40VP4A08T0d@2J003A6Q400=X24@016Q4A4@2J09400B8J6Q40fP=A003J4A4009400=XA4@0
1D@2J09400<TA4@00T@00003J4A401E400=XA4@04T@3J003R6R800IX0XP8[0;<0Z`00hc@d@02m@Kj
00Son_[koo[on`Go00?kool01Ol00o_oo`03o`03nooo00?o00?koo/01?l01__jn_[ko`;k00Kon__o
n_l2n`0<oo[joo_joo[koo[o0_/01?ojn_l4n`09oo[joo[koo[o00;j00Cono[o0_X02_ojooojoo_j
noX2o`0:n_okn_ojnooko`;k00Sono[ono[on`;o00Kjoo[kooX2o`03nook00;o00Sjoo_koo_jn`;j
00Ckn_[k2oX01?WjnOX2n`;o00?koo/00_X01_ojoo[ko`;k00Oon_ojno[k00;o00?koo/00_/00ook
o`03nP03oo[o00;j0o/2nP09oo[knoojoo[k00;j00Gkn_[knP02n`05n_okn_/00_X3n`;j00?kn_X0
0oX01__jn__jn`;j00Okn_[kn__j00?k0oX00oojnP06nP06no[jno[k0oX01O_jno[k00Cj0_/4o`?k
017onookoo[onookoo_onooko`02n`;o00?jno/00_l2n`Go0_/00ookn`03o`0;n_oooo[on__jnol0
0_X00oG<R002J0E40b@2A0@T0T@59003A2@T00PT00=492@00R@00d@T90059003A2@T01PT00=492@0
0b@00d@T900?90948R@2A0HT0T@:90942B@2A08T1D@390I400<TA4@014@00hQXA004A007J4A4A8Q4
J007A0:<00F8A2A4900@A00694A4A8QX0T@00fQ4J003A003J4AX009X4D@00fQ4J008A003J4A400A4
0002A003J4A402Q41fP3A004J8QXR0>/00?@[:`01Z`01Hc<mOGi00Gj00Kkn__koo/?o`;k0ol00o_o
o`0<o`;k0_X03__onookoo_onookoo_o0_/01?[oool3n`04n__on`;o00Gkoo_ko`03n`06n__joo_j
0_/2nP?k0_X00ookn`02o`03no[j00;j00Gkoo[ko`04n`05oo_koo/00_l4n`;o0o/00ookn`03n`03
oo_o00Co00?joo/00o/AnP03nO[j00;j0_l2n`03oo[k00;k00Gono_onP02o`;k00Con_oj0ol01O[o
n_oj00;k00Con__j0o/02O[kno_jno[onP02n`05oo_kn_/01_X2n`05n__kn_/00oX2n`;j00?kn_X0
1OX00o_jnP02n`03n__j00Cj00?kn_/00_/3nP04no[kn`Kj00?kn_X00oX00o_jn`08nP;k0_l01O[o
n__j00;k00?on_/00_/02_[onookoo[on_l3n`07oo[knoojn`04o`03nook00;k00?onol00_l00o[o
n`03o`05nookoo/00_X01?GAR6P3A08T00=492@00R@00d@T90079003A2A402hT00E492@TA00G90A4
7b@2A0HT14@:90941B@014@TA4@490A40R@5A00394@T015400AXA6QX1T@01:b8J2@4A00394@T00a4
00<TA4@00T@00hQ4A002A004J4A4A0=X2T@00fQ4A007A09X00=4J6P01T@01FQ4A4@T0054000/A09X
00>8J6P00fP01dAXJ6R8J8P00j`00lb/[004[0:<00>/d?D00_T7nP05no[jnoX03Ol00o_oo`07o`03
nooo00;k00?onol00_l01O_joo_o00;k00?jno/01?/01?okooX2n`06oo_onooj0_/2nP03oo_o00;o
0_/00oojn`02nP;k0oX3n`;j0o/2nP?k00?ono/00oX01?_ooo/2o`03nook00;k1_X6n`;j00?koo/0
0_/2o`Gk0_l2n`04n__kn`;j0_/BnP07oo_on__jo`02n`05oo_oooX01?/01Ookoo[o00;k00Ojoo[o
nook00;j0_/00ookn`02n`04n__jo`?k00?jnol01?/00o[knP02n`03n__j00;k1?X00o_jnP03nP03
no[o00?j0_/02Ooknookoo_jn`03nP05oo_onol00_/01_[on__jn`;j0_/01_[on_[onP;k00Cjoo[j
0o/00oojo`03n`;j00Cono_j0_/00oojo`05n`0<oo[onookoo[onooj0_/01?ojoo/5o`03nooo00;o
00Cjoooj1Ol00o_onP02n`?j00?aR6P01T@012A494@?9094;R@00d@T90059003A2@T00hT00=492@0
3b@00d@T900E90E412@00d@T90089004A2@TA0HT00=494@00b@5A0<T4T@2J09400=XA4@00VP3A08T
0T@290Y400=XA4@01T@01VR8A6Q4J0=40fP9A003J4A400M400=XA4@01FP8A04T000WA004J4A4A09X
0XP6J003R6QX00^/0X`3[003dOGj00Oj0_/01?[ooo/9o`03nooo00?o00?kool02?l01?_jooX2o`;k
0_X01?_onol2nP07oo[koo[on`02o`;k00?ono/00_l00o[on`02n`06n_oknook0_l01O_on_[o00;j
00?kn_l01OX02O_jnoojnoojo`02n`03oo_o00;k00Gono_knP02o`04n_ojnPKk00?onol00_/01Ook
nooj00Co0_/00oojo`02n`04oo[jn`;j00Ckn_[k3OX2n@?j00Gon_ojn`02o`05n_ojnol00_/01?oj
oo/2o`0:no[jn_okoo_on`?o0o/00oojo`02nP04oo[jo`?j00Kkn_okooX2n`;j00?on_l00_X01?_j
nol8nP;k0oX4o`05n_oknol00_X00o_jo`04n`04n_ojo`Gj00Wkn_[on_okn_l00_/01Oojnooj00;k
0_l2n`03oo[k00Kj0_/02Oojno_jno[ko`02nP04oo_on`;j00?onol00_/01O[ooook00Co0_/3o`05
no[ooo/01Ol01?[kn_/2nP03mJaX00A40b@00d@T9007909442@00d@T900/9094?2@00d@T90029094
0R@00d@T90029003A2@T00<T00=494@00T@790E40R@2A0DT0d@00bA49006A003J4A400=40VP014@T
92@4A00594A4A6P014@00fQ4A008A003J4A400=400AXA4A40VP014AXA6P5A00394A400M40VP01dAX
J6R8S6P014@00fQ4A002A00000=XA4@09D@6J0:81VP2R0:/00><[:`01J`01hb8R8b8[=000_D3nP08
no[joo[koo/5o`03n_oo00;o0_/4o`03n__o00Go00Skn_ojoo_jo`;j00ckn__kn_okn__on_l2nP0?
oo[koo[ono[koo[ono[k00;j00[on_okn_okn_oj0_/02?[on_[on__o0_X01_ojooojn`;j00Konooo
n_l2nP06oo[koo[o0_X01?ojnol2nP06oo_ooo[o0_X02_okoookoo[kooX2o`06nookn_oj0_l2nP06
no[ono[k2OX00oWjn@02nP03nO[j00;k00?jnol00_X01_ojooojo`;j00Kono_on_l5nP0<oo_ono[k
oo[ono[o0_X01_ojoo_jo`;j00?on_X00_/01?[on_/2nP05oo[jooX00_/00o[onP04nP03no[o00;j
0_/02_[ono[on_okn_/4nP04nooko`;j00Kkn_[kn_/3nP0;no[ono[on__on_l00_X01__jnooko`?j
00?kn_/01OX00oojn`02nP06oo[joo[o0_X02?_on__jnook0_l01O_ooook00?o00?joo/00ol00o[o
nP05o`03nooj00;k0oX01?F/J6P3A00494@TA0TT0T@49004A2@TA0<T14@00bA4901P9003A2@T00@T
00=492@00b@00d@T9002A08T00=492@00b@00d@T900490=40b@014@T92@5A00494A4A0DT0T@490i4
12@:A09X00=4J6P01D@00fQ4A008A005J4AXJ4@00VP2A003J4A400a400=XR6P00XP00fR8S003J003
A6Q400A4000WA0AX0T@016R8J8P5J0:81J`00lb/[002[003S8R800><00CamO[i1OX3n`go00?kool0
0ol00o_oo`05o`03nooo00;k00Gon__onP02o`05n_oonol00_X01Oojoooj00;o00Ckoo_j0_l01o_o
no_onol00_/01Ooknook00;o00Kjoo_jnoX2o`04nooknP;k00Gjoo[ko`02n`03oo_o00?o0_/00ooj
o`02nP03oo[j00Gk0_l01__ooo[on`;o00Sjoo_koo[on`;o0_/01_ojno_jo`;k00Con_[k0_X00o_j
nP09nP04nO[in@?j00Gono_jn`02o`06n_oknooj0_l01O[ono_o00Ck00Won__koo_on_/00_X2n`05
n__jn_/00_X00oojn`03nP04oo[onP;k0_X00o_jn`02nP05no[jooX01?/01?[kooX2n`;j0_l01?_o
n_l2nP03no[j00;j00Ckn__k0_X00o_jn`0;nP03oo[o00;j0_/3nP03no[j00?j00?kn_/02oX00o_j
n`02nP;k00Cjno[o1?X00o_on`03o`03nook00Co0_/00ooko`03n`08n_okn__joo/3o`;j00Cid8QX
1T@69003A2A4008T00=492@00b@2A0@T00=492@0;R@00d@T90069003A2@T010T00=492@01b@2A0XT
0T@?9005A2@T94@00b@00d@T90029003A2@T00<T1T@00bA4A00290I400<TA4@00T@3909412@3A003
94A400E41B@4A00394A400U400=XA4@04d@2J0M400=XA4@01d@2J003A8QX009X00><J6P00fP5A000
;D@9J0:<0j`01/b/[:b<R0:<00QXR:b8S=7en@Kj00?kn_/01ol00o_oo`03o`03nooo00Go00?kool0
0_l01?_ooo/4o`;k0ol2n`08oo_on_okoo/3o`03nook00?o00?kool01?l00o_jo`05o`;k00Gon_ok
o`02n`;o00Sjnoojnooko`;j00Kkoo_onol6n`04oo_ko`Gk00Wjnookoo_onoX00_/00o[kn`02n`06
oo_onooj0_/00ookn`06na?j0oT3nP05noojoo/00ol00o[kn`03n`04n_oko`;k0_X2n`?j00?kn_/0
1OX00o_jnP08nP06no[jno[k0_X01O_jn_[k00;j00Ckn__k0oX02?_jno_jnook0_X01?_jno/2nP03
no[j00gj00?kn_X0:_X00o_jn`04nP06no[kn__j0o/2o`03n_ok00;o00Kkn__jooX3n`04oo[oo`;k
00Kjnooonol2nP04mM2<J0I422@00d@T90079003A2A404lT00=492@01b@2A0/T00=492@042@014@T
94@29003A2@T00PT1D@490A412@5A0<T00=4J4@00T@490I40b@2A0<T0T@2911400HTA2@TA2@7A003
J4A400U41FP5A003J4AX00YX1D@002Y41fP00dAXJ002J0B/0/`2[003R8b800:800IXR8QXS=02m@Wj
1ol00o_on`0Go`03no[k00;o00[koooonookoo_o1?/2o`04nooon`;o00?kool00ol01?_oool2n`04
oo_ko`Ck00Gonooon`02o`;k0ol00o_jo`02n`03oo_k00;k00Gono_onP02o`05nooknol00_/02Ook
nookoo_jn`02nP0<no[kn__on__on_ok0ol00o_onP02n`;j00?on_/00_X01?_jn_/:nP;i0oX01Ooj
nook00Go00?joo/00_l01__ooo[onPCk00Con__k1?X01?oknol2nP03no[j00;j0_/01O[on_[k00;j
00?kn_X01oX2n`06n__jn__j0o/01?okn_/3nP03no[k00Cj00?kn_X00oX00o_jnP0@nP03no[j00;j
00?kn_X00oX00o_jnP0KnP03no[j00;j00Okoooonooj00;k00Gon_oknP04o`03nooo00?o00?jool0
0o/2nP04mM2/R0940R@2A2<T00=492@09R@00d@T90049003A2@T00hT00=492@02b@00d@T90039003
A2@T00/T14@490940R@4A0DT0d@012A4A4@39004A2@T90E400<TA4@014@490E40R@<A0DT00A492@T
24@290A400DTA4A49005A00394A400]40R@2A003J4A4009416P01hQXJ6R8J4@01FP4A000:T@3J003
R6QX00EX0Z`2S0>/00G<[8QXR007J007[=7imOWjn@03nP03oo[k00[o00Cjoo_k4_l01?[ooo/2o`05
noojnol00_/01_oknoojo`;k0_l03O_onookn__on_okn_l00_X01_ojoo_jo`;j00Son_oon_oknP;o
00[koo_koo_ono[o0_X01_ojoo_jo`;j00Kon__on_l2nP04oo_jn`;j00?on_/00_X01Oojn_oj00;k
00Ojoo_joo[o00;k00Con_[o0_X01_ojn_ojo`;j00Gkn_[jn@04nP?i00oen_[joo_jnoojoo_jooX0
0_l02_[on_[on__on_l2nP06no[joo[k0_X01?_on_l2nP06oo[jno[o0oX00oojo`05nP03oo[o00Gj
00?kn_X00_X01_ojn_ojn`?j00?on_/01OX00o_jnP02nP03oo[j00Gj00?kn_X00oX01?_jn_l4nP04
oo[joa;j00Ckn_[k2_X00o_jn`03nP03no[k00?k00Ojnoojoo[k00;o00?kooX00_l00o_oo`02o`04
noojn`;o00Wjno[jnM6/R6P00T@F9094Ab@00d@T90049003A2@T008T00=492@01b@00d@T90039003
A2@T00`T14@390=40R@4A00594A4A2@00T@00bA4A002A0PT2T@00bA4900?A003J4A400A400<TA2@0
0T@00bA4A00>A00394A400]40VP:A004J4A4A0IX00>8J6P00XP4J003R6QX00940FP1A0003T@00fQ4
A00FA003J4A400IX00E4J6QXS003[003S:b/00:/00F<R6QXA002J0940VP018R/d?D7nP03oo_o00Go
00?kool06Ol00o_oo`02o`08nooooo_on_l2n`05oo_kooX00_l2n`03oo_o00;j0_/00o[on`03nPCk
00Kjno_koo/2o`;k00?onol01?l02_[on__onookn_l2nP03oo_k00;j00Gon__onP02n`;j00?on_l0
0_/00oojnP02nP04nooko`;j00Con_ok0ol00o[onP02o`03no[o00;k0_X01?_jn_/8nP03nO[j00?i
00Kjnookoo/2o`05nooon_l00_/01_oknooko`;k00Gono_onP03o`03nooj00;o00Okoo_koo[o00;j
00Skn_[kn__jn`cj00?kn_X00_X00oojn`02n`03oo[j00_j00?kn_X02oX00o_jnP05nP09no[jnooj
no[k00Oj00?kn_X00oX00o_jnP03nP03no[k00Gj00?kn_X00oX00o_jo`02n`;j0_/00o[on`04n`04
oo_onP?o00?kooX00_l2n`05oo[onol00_/3nP04lJb8J0940b@00d@T90069003A2@T01DT00=492@0
>2@2A2PT0T@00bA4A0039005A2@TA2@01D@00bA49002A08T1D@890E400<TA4@00R@014@TA2@3A09X
00>8A4@00T@3J003R4AX00M400<TA4@02T@00fQ49003A08T34@00fQ4J00<A005J8QXJ4@016P4R0=X
0XP00fQ4A002A000:4@:J005R8b/[<`01:`01<b/S6P4A003J4A4009X00N8S:cAmO[i00?j00?kn_l0
3?l00o_oo`0?o`03nooo00So00Kkoo_onol2n`04n__jo`;k0_X6n`09n_oknoojnooj00;k00Kjno_k
oo/2o`03nook00?k1Ol4n`04oo[ko`?k00?onoX00_/3nP03no[j00Gj00?kn_/00o/01_[kn__onP;k
00Cono_j0_/2o`Gk00?jno/00_X00o_jnP0=nP?i0_X2n`?o00?koo/00_/01?okooX4n`05oo[jnol0
0o/02_ojno_onoojooX3n`04n__jn`?j00?kn_/02oX01?_jn_/=nP03no[j00Oj00?kn_X05_X00o_j
nP02nP03oo_j00?j00?kn_/00_X4n`03n__k00;k00_on_ojno[kn_ojn`02nP;k00Cjoo_o0_/01o[k
n_ojnol00_/01?ojooX2o`05n_oon_l00_/00o[on`02n`08oo_jn__jmJ`2J09400@TA4A41B@00d@T
90069003A2@T05hT00=492@00b@00d@T900:90=41B@014@TA4@49003A2A4009400DTA4A49007A0PT
1T@490i400AXA4AX14@390=400<TA4@014@3J09400=XA4@02D@2J0Q400=XA4@024@2J0:80VP3R09X
18P2J004R6QXJ0=40B@002Y40VP00dAXJ002J003R8b/00:/00?<[:`00j`00hb8J004A09X00Q4J6QX
R8c@m@;i0oX00ookn`0:o`03nooo017o00?koo/01?l00o_on`03n`03n__o00;j00?on_l01?/01O[k
n_ok00;j0_/3nP?k00?ono/00_/01ooknoojoo/00_l01O[kno_j00?k1?l01O[ono_o00Ck00Gono[k
nP02n`04n_ojn`Kj1?/03_[ono_on_ojnookn_oj0_l01O_ono_o00;j0_/00o[onP0=nP03nO[i00?j
00?kn_/00_l01__ooo_on`;o00Cjoo_j0_/2o`0:n_okoo_onoojo`?k00Gon_ojo`02n`04n__jnP?k
00?on_l01OX00oojnP02nP06oo[koo[k0_X01?_jn_/5nP03no[j00Gj00Kkn__kn_l@nP04no[jn`Cj
00Kon__on_l3n`05oo_onol01?/00o[on`02n`;j00?on_l01?X01?_on_l4n`03n_ok00?o00Gkoo_o
nP02o`06no[onook0ol01?_on_/2nP04nooko`;k00CjmJb81T@590942R@014@T94@?90949b@00d@T
900I9003A2@T00hT00=492@03R@014@TA4@590=412@00d@T900290A41b@014@TA2@3A0@T00=494@0
0T@016Q4A4@290M400=XA4@00T@012A4A2@9A09X0T@016Q4A6P3A003J4A400=40VPAA004J4AXJ0F8
00J/R8QXR8`3R003J4A400A40B@0029400=XA4@014@2J005A6QXA6P00XP01Hb/[:c<00B/00B<R8QX
14@01FQ4J6Q4009X00B8c?7e0_T00o[kn`0Ho`04nookn`;o00?jool00_l00o_oo`02nP09oo[on__j
no[o00;j00Kkn__on_/2nP05noojooX00_/4nP04oo[jn`;j00Won__kn_ojnol01O/01_ojno_jo`;j
00_onooon_okn_ojn`02nP05oo[jnoX00_/2nP03no[k00;k00Kon_[on_l2n`;o00Cjoo[o0_/01Ook
nooj00Ck00?on_/04OX01?WjnOT3nP?k0_l2n`05n_ojnol00oX01?_ono/2o`04nooko`;k00Cjno_o
0_X01_ojn_ojo`;j0o/00oojnP03nP06no[kno[k0_X01?ojn_X2n`[j00?kn_X00oX00o_jnP04nP;k
4?X00o_jnP07nP0;no[jnookoo_on_/00oX01O_joo_o00;k00Wjno_on__jnoX01?/01?ojno/3o`03
n_oo00Oo00Gkoo_on`03o`09nookoo_onook00?o0_/01_[e[6Q4J0E40R@014@T92@2A08T00=492@0
0R@014@T94@;9003A2@T008T00=492@0:b@00d@T90069003A2@T008T00=492@01b@00d@T90059003
A2@T00DT00=492@02B@2A1<T00E494@TA0039003A2@T00@T1d@690940R@4A0@T1d@00bA4A004A004
94@T90=400AXA6QX0T@2J0=40fP3A003J4A400U400=XA4@01T@3J0V800=XR6P00hP00fQ4A005A000
:4@2J006A6QXJ4AX0XP01Hc<[:c<00>/00G<[8b8J005A004J4AXA0=X00B<c?Ge0_X00o_on`0;o`03
n_oo00Wo00Gkoooon`02o`04n__on`;o00Ckoo[j0_l01O_on__o00;k00Won_ojnookn_l01?X01?_o
n_/2nP06no[joo[o0_/02Oojnoojnoojo`02n`04oo_kn`;j00Konooon_l2n`03oo_k00;k00Gon_[o
nP02n`03n_oj00?k00Cjoo_k0_l02?_on_okn_oj0_l00o_oo`02o`08n_oknoojnol2n`04oo[jn`kj
00Cin_[i1OX2o`0:nookn_ojnoojo`;j00Gkn__on`02o`03nooo00?k0_l01O_joo[o00;k00?ono/0
0_X3n`04n_ojn`;j00?kn_X00_l01?_jn_/4nP03no[j00Kj00Kkn_[kn_/2nP03no[j00?j00Ckn_ok
0_X01O_jno[o00;k1OX01O_jn_[k00Oj0_/02_okno[onoojnoX2n`0?oo_on_ojoo_onookoo[o00?k
0_l00o_oo`02o`03nooo00Oo00?joo/01Ol01O[ooook00Ko0_/01oojmJb8A6P014@012A4A4@<90A4
2b@00d@T90029004A2@TA2XT00A494A412@3A00494@TA1PT0T@00bA4A0089003A6PT00lT00=494@0
0T@69003A2@T00@T14@00fQ4A0079004A2@T90=412@3A00394@T008T24@00bA4A004A003J4A400=X
14@4J09400EXA4A4J008A09X0d@00fQ4J002J004R8b<S0>800><R6P00XP2S003R6Q400I4000WA0=X
00=4J6P00fP2R005[<c<[8`01:`018b8J6P5A0MX00J8S=3enOX4naKo00?kool00ol00o_on`02o`07
nooon__on`02o`;k00?on_l01_/01?[kn_/2nP?k00?onoX00o/00oojn`03n`03oo[k00;k0_X00o_o
n`02o`05nooknol01?/01?oknol4n`03n_oj00?k00Gon__knP06n`05oo_onoX00_/01O[kno_o00Ck
00?ono/00_l00o_onP03n`04n__jnaSj0_/00ooko`02n`03n__k00?k00Gjno[onP04n`03oo_o00?j
00?onol00_/3nP03no[k00Gj00?kn_/01oX2n`Cj00?kn_X01OX00o_jnP0;nP04no[jn`;j0_/01o[k
no_jnoX00o/00o[knP08nP03no[j00?j0_/6nP?k00Sjno[on_oknP?k00?on_/00_/01?[kno/2o`06
nookoo_o0o/;o`05noooooX01Ol03O_onookoo[kn_WAR6P01D@012A494@49003A2@T00DT00A492A4
0R@00d@T900O9003A2@T01XT00=492@03R@2A1DT00=492@04B@2A00394A400<T14@49003A2A400DT
24@79004A2@T90940R@00d@T900290=40b@2A00394A400]400=XA6P03D@00fQ4J00;A004J4A4A09X
00J<J8b<[8`2R005[8b8R8`018P016Q4A6P4A0005d@00fQ4A00=A0QX00>8S:`01Z`2S0:824@00fQ4
J005J004R:cAn@?j00?kool05Ol01O_ooook00?o00Kkoo_onol2n`04oo[knPCk00?ono/01?/00o[o
n`06n`04oo_onP;o0o/01_oknooko`Ok0_l4n`06oo_koo_o0_/00ookn`05n`05oo_oooX00_/00o[k
n`02n`03oo_o00;k00Kono_kn_l3n`04oo_onPGo0o/4o`?k00?jnoX04oX00oWjn`04o`04nooko`Kk
00?jooX01?/01_okoo[onP;k00Cono_j0_/00oojnP05nP07no[kn__jn`03nP?k00?jnoX00_X02?_j
n_[kn__j0_/2nP03no[k00;k00Cjno_k0_X2n`03n__k00?k00?ono/00o/01?okno/9nP;k00?joo/0
0_/01?okno/3o`07nookno[knP03n`0<n__koo[koo_joo[k1?l00o_oo`03o`03nooo00Go00?jool0
1Ol00o_on`03o`04nooko`Ck0_X00o68J005A0lT00=492@0Qb@3A0DT1D@00bA49003A00494A4A0`T
0d@29003A2A400940R@5A00394A400Y400=XA4@034@00fQ4A00<A0EX0XP2S0V/18`2R0AX14@000=4
00=XA4@04D@2J0e400AXR6Q416P3R0:/00C<[:b/0X`2R09X1d@00fQ4A002A0AX00>8d?D00_X2n`_o
00?kool03_l02o_ooo[on_okn__j00?k00Gjoo_ko`02n`03oo[o00;k00gjno_onookn__on_ok00;o
0_/3o`03nooo00;k00Konooonol2n`;o00Okoo_koo[o00;k0_l00o_onP03nP09oo[joo[koo[o00?j
00?kn_/00_X3n`07oo[on__onP03n`03oo_o00?o0_/00ooko`02o`;k0_X00o_jnP0AnP07nO[jn__o
nP02o`03n_oj00;k00Gjoo_ko`03n`0;n_okoo_on_ojoo/00ol00o[onP05n`Oj00?onoX00_X00o_o
nP02n`Cj00?on_X00_X01?_jn_/2nP06no[koo[k0_X01__jn__jn`;j00?ono/00o/00oojn`03n`;j
00?kn_X00o/00oojo`06n`;o0_X2n`05n__jnoX00o/01?[kn_/2nP;k00Cjoo_o0_/02O[knoojoo_o
n`03o`;k1?l00o[knP02n`03oo_o00?o0_/3o`08nooooo[kn_/2nP03lJaX009400<TA4@03R@2A0@T
0T@89003A2@T03dT00=492@08R@01D@T94@T009422@00d@T9002A08T0d@3909400<TA4@014@012A4
A4@79003A2@T008T00=492@00d@4909400@TA2@T0T@590U40VP6A09X1D@00fQ4J003A003J4A400A4
00=XA6P00VP6R005[8b/R:`00]001jc<[:b8[8`018P2J0E4000HA003J4A401140fP3R007[8c<c:b8
S003R003J4A400I400=XA4@00T@4J004R:c<m@;j2?l00o_on`0=o`03nooo00;k00?on_/00_/01Ook
nooj00;o00Cjoo[j0_l02O[ono[on__onP04n`0:oo_ono[kn__on`;o00Kjoo[jooX2o`06nooknooj
0_l01O_joo[o00;j00Gkn__onP02o`06n_ojn__j0_/01_[on_[onP;k0_X01_ojno_jn`;j00Kon__k
n_l2nP0:oo[ooo_ono[onP;o00?kn_l01?X01?_jn_/4nP03no[j00Wj00_in_[jnookoo_jo`02n`09
oo[koo_ono[k00;j00Conook0ol01O_ooo_o00;j00Kon_okn_/2nP03no[j00?j00?on_l00_X01_oj
n_ojn`;j00Con_[k1?X01oojn_[kn_/00_X01ookno_jooX00_/01_[ooo[on`Cj00Ckn__j0o/01?[o
no/2o`04nooko`?j00gonoojoo[kn__joo[o00;j00Kkoo[on_l2n`;o0_/2nP03nook00?o00?kool0
1ol00o[onP0=o`06nooooo_j0_l2nP03lJb8009400<TA2@022@00d@T9002A08T0T@01BA4A4@T00=4
0R@01D@T92A400HT00=492@022@00d@T90089003J2@T00<T00=492@0=b@00`0T90049003A2@T008T
0T@89004A2@T90940R@2A0<T1D@00fQ4A0029003A2@T00@T00A494A42B@3A00394A4008T0T@89094
00DTA4A4J003A003J4A400A400=XA4@014@00fQ4A00;A0=X00F8S8b/R002S0:/00V<[=2/d<c@c8`0
0Z`018b/R8P4J0A4000HA003J4A400]400=XA4@00d@01VR8S8b8S0:/00J<R8b/S8P2J0Q400EXA4AX
A004J005R:b/dOT00_XOo`03n_ok00;o00?joo/00ol00o_onP03o`07noojoo_on`02nP03no[k00;k
0oX2n`;o0_/2o`04nooko`;k00?on_/00_/00ooko`02o`03n_ok00?k00Wono_on__on_l00_/00ooj
n`03nP03no[k00;j0_/00o[knP06nP05no[knoX01?/2nP03no[k00;j00Ckn__o0o/2nP03no[j01;j
00Gin_[jn`02o`;k00?onol00_/01?ojool3n`03oo_j00;k0_X00ooko`02n`05oo_jnoX01O/3nP03
no[j00oj00?kn_/01_X00o_jnP02nP04no[jnPKk00Kjno[kn_/2nP;k00Cjno[j1O/02?[koo[kn_oj
0_/01?ojn_X2n`07n__on__jo`03nP03oo[k00;k00_jno_kn_okoo[knP02n`06oo_onook2Ol01O_o
nooj00Go00Okoooonook00?o0o/01oojn_F/S6P00d@012A4A4@990=400@TA2@T0T@00bA4A002A1LT
00=492@092@2A3`T0d@00bA4900390940b@3A08T00=492@014@29003A6PT00@T0T@5909400<TA4@0
0T@49004A2@T90]400=XA4@02T@016Q4A6P7A003J4A400>80X`00hR/[002[003d:c@00:/0]001<c@
[:`3S003[8b800AX14@001M400=XA4@034@00fQ4A002A09X00><[8P00XP2S0:/0X`00hQ4A00AA003
J8R/00:/00Cen_[j6_l02O_ooo_joo[on`06o`04noojn`Co00?joo/01?/01?[knoX2n`03oo_k00Gk
00?onol00_/02Ookn__jnooko`02n`04oo_ko`;k0_l01?_onol3n`04n__knP;k1_X00o_jnP02n`07
n__jn__jn`05nP03no[j00;j00Gkn_[knP03n`04oo[jo`;j00Kkn_[on_/CnP06nO[joo[o0_/4o`04
n_okn`;o00Kkoo_on_l3n`03oo[o00;k00gjoo[onookoo[kn_oj00?k00Gjno[jn`02nP03no[o00Gj
00?on_/00_X00o_jnP06nP?k0_X3n`09oo[koo[kn__o00;k00Konoojnol2n`03oo[k00Co00Gjoo[j
o`03n`03n__j00?j0_/00o[onP03o`0=n_ojn__jnoojoo[ko`02n`03oo_o00Co00?kool01ol00o_o
o`03o`03nooo00Oo00?kool00ol3n`05n_G<S6P014@00bA4A0029003A2@T014T00A494A40R@2A0LT
0d@69003A2@T03<T00=492@00b@00d@T900X9003A2@T00HT0d@59005A2@TA2@00d@89006A2@TA2A4
0b@6A00394A400e400=XA6P01d@3J0e400B8J6R80Z`018b/R:`2S004[=2/d0:/0]04[005S:b/c:`0
18P00fQ4A002A0009T@6J004R8b/S0:800B<R8R80X`00fQ4A00:A006J4A4J4AX0T@02FR8R8c@dOGj
n`0Io`04noojo`;k00Gon__on`02o`03nook00;k00?on_l00_/01_ojn_ojo`;k00Cjoo_o0_X3n`03
oo_o00;o0o/01oojno_jooX00_/00o[kn`02n`03oo_j00;j00Con__o0o/01_[on_[knPCk1?X01__o
n_[knP;k00Sjno_jno[ko`Kj00?onoX00_/00o[onP02n`;j00Cono_j0o/00o[knP0?nP?i0_X01Ook
nooj00Co0_/3o`;k1?l01O_onooj00?o0_/02Oojnoojoo[ko`02n`03oo[k00?j00?kn_/00_X00o_j
nP02n`04oo[jo`;j00Con__k1?X00o_jn`02n`07n__ooo_jn`05nP05oo_on_/00_l2n`;o0_X2n`03
n_ok00Kk00?on_/00_/01O[kn__j00;k0ol02O_ono[koo_onP04n`09oo[ono[koo_o00;j00?kn_/0
1ol02?_onookoo_o0o/5o`03nook00;o0o/2nP06mM2<J4@T14@00bA4900D9006A2@T94@T0T@39094
12@00d@T900A9003A2@T01/T00=492@07b@014@T92@3A0HT00=492@01B@2A00394@T008T00=492@0
3b@014@TA4@890941B@5A00394A400]400=XA4@00fP3A09X1T@00fQ4A007A00394A400940VP00hR<
[002[006S:b/S8R/0m02[005d<c<d<`00Z`2S0:/0hP00hb8J002J054000EA003J4A400Y400=XA4@0
0T@4J0>80X`01HR<S8QX00>800=XA4@024@01FQ4A6Q400IX0hP2[003mOWj00;k4_l00o_oo`02o`;k
00GonooonP04o`;k1?l2nP0=oo[ooo[on__on__on`02nP0<no[on_okn_okn_oj0_/04?[on_[on__o
n_okn_okn_l2nP06oo[ooo[k0_X04?ojnoojoo_joo[ono[on_/2o`0>n_ojn_ojoo_joo_jooX2n`06
n_okn_oj0_l01O_on_[o00;k00Won_[on_okn_/00_X00o_jnP0;nP;i0oX00ooknP04o`05n_oknol0
0_/01Ookoook00Co00?joo/00_/01_ojoo[ko`;k00Con_oj0_/00oojo`03n`08n__on_okn_l2n`04
oo[kn`;o00?kn_/00_X01O_jn_oj00;k00Gjno[jo`03n`06n_ojnook0_l01?_oooX2o`Ck00Gono_k
nP03n`;o0o/01?oknoX4n`Go0_/02?[kno_jno[o1?/01?[knol2n`07n_okoo_on`05o`08nookoo_o
nol2n`03n__o00Oo00Ckoo[k0_X00oW@R005A00394@T00943B@01D@T92A400LT00=492@00R@3A1TT
00=492@05R@01D@T92A4024T0T@<9003A2@T00hT0T@69003A2@T008T0d@012A494@390=40b@01D@T
94@T009412@3A0<T1d@016Q4A4@2J09400=XR8P04d@00hQXJ002R0:/00c<S:c@c:b<[=2/d<`2d003
c:c<00:/00><R8`00j`018b8S8`2R05X0D@000E40VPKA004J4A4A0AX00>8J8P00h`3R0EX2T@00fQ4
A003A0=X00A4J6QX0XP018b/d?D2nPCo00?kool04ol01?[oool2n`So00Kkoookoo/3o`;k00?joo/0
0_/01Ookoo_o00?k00?ono/00_/01Oojn__j00?k00?ono/00_X4n`05oo[onoX01?/2nP04no[on`?o
0_/01_[on_[onP;k0_X02?_joo_jnook0_l00o[ko`03n`05oo[knol00_/00o[onP04n`04oo_kn`;j
00?kn_/04oX01?Wjn_/2o`03n_oj00?o00ckoooonookoo_onol3n`06oo_onooj0_/00oojo`04n`04
n_oko`;k00Gjoo[onP03n`0<n__kno[kn__jno[k1oX00ookn`02n`Cj0_/00oojn`04n`05oo_oooX0
0ol00o[kn`02n`03oo[k00;j0_/01O[kno_o00?k00?jno/00_/01Ookno[o00;j0_/02?[kn__joo_o
1OX00ookn`05n`08oo_onoojooX3o`;k00?jool00_l2n`04oo_on`Go00?koo/00_X00m68A007A005
94@T94@022@00d@T90079003A2@T00LT00=492@01b@00d@T90179003A2@T01@T00=492@02b@2A0/T
0T@39003A2@T008T1T@69003A2@T00<T0T@39003A2A400I416P2A004J8QXJ1140VP2R003J:b/00>/
00J<[<c@c:`2d004c:b/[0:<00C<[:c<0Z`01<b/R8`5R09X0D@0019400=XA4@02T@00fQ4A005A004
J8R8S0B800><R:`01FP5A003R6Q400A40VP2A003J4A4009X00E4J4AXR003[003d?Gj00;k2_l00o_o
n`03o`03nooo00?o00?koo/01Ol5n`?o00kkoookoo_onookoo[onP;k00Cono_k0_l2n`03oo_k00?k
00Gjno_jn`03o`?k0oX2n`06oo_kno[o0_X3n`0<oo[koo_on__onooj1?/01Ookn__j00Kk00[ono_o
nookn__j0_l02?_ono_on__o0_/01?ojno/4nP?k5?X01__ooo[on`?o00Gkoo_on`03o`04nooko`?k
00Conook0ol01?_on_l2n`09oo_joo[onooj00?k00?jnoX00_X00o_jn`02nP06no[jno[k0_X01?_j
n_X2n`04oo_ko`;k0_X02O_jno_jnooko`02n`03oo[k00;o00?kn_/00_/00o[onP02n`04n__knP;k
00Ojoo_koo[o00;k0_l01O_onooj00;k00Oon_ojnook00;o00_jno_jnookoo_onP02n`03oo_o00;k
00Kjno_on_l2n`05oo_oooX00_l00o_oo`06o`07nooknoW@R005A00494A4A08T0T@79003A2@T00LT
0T@<9003A2@T02dT00=492@0;b@00d@T900H909400<TA4@014@39003A2A400=400<TA2@022@3A0<T
00A492@T2T@2J003A6QX00:80VP5A003J4A400E400IXA8R8S8P2S0>/00><[<`00]000m7<d004d0F/
0m02[003c:b/00:<00B/R8QX0d@002=400IXA4A4J8`5R004J8R8R09X00=4J4@044@2J0=400=XA6P0
0VP3R003[=3e00?j2ol00o_oo`0:o`;k00Sonooonooko`?k1Ol01O_on_ok00;o0_/00ooko`02n`04
n_ooo`;j00?on_/00ol2n`05oo_ooo/00_l01?[ono/2o`03nooj00;o00Gkoo_jo`02n`06oo[koo_o
0_X01__onooko`;k00?jnoX00_/01o[ono_on_l00_/01oojno[koo/00_l01O[koo_o00;k00?on_/0
1?/01O[kno_o01Kj0_/01_okn__jo`;k00Konooonol2n`;o00Ckoo[o0o/01?ojoo/3o`06noojno[o
0_X00o_onP03nP05noojnoX00_/2nP06oo[knook0_X01?ojn_X2n`09oo_knookoo[o00;k00?onol0
0_/01?okoo/2o`?k00?jno/00_X01__onoojo`Gk00?ono/01?/2o`03nooj00;k00?ono/00oX3n`03
n_ok00Ck00Wono_koo_onol00oX2n`0@oo_onoojoo_onoojoo_on`Go00Ckoo_o0o/2nP03lHQ400E4
00<TA4@03b@00d@T900E9003A2@T00<T00=492@04b@00d@T900a90942b@00d@T900A9004A2@T90=4
00@TA2@T1T@390=400@TA2@T14@00bA4900290E400<TA4@01T@00fQ4A003A0AX0T@2J0M400=XA4@0
0d@2J004S:b<S0B/00?<[:`00Z`01M3Ad=3A00S@00Z/c:b/d=7@c=2/1HP2J094000FA003J4A400]4
0VP00dAXR003S005R8aXJ8P00VP2A003J4A400m400=XR6P01D@3J0:800N<[=7enO[k00Oo00?kool0
0_l01O_ooook00Go00?kool00ol01O_onook00;o00?koo/00_/3o`04n_oko`?k00[onoojno[onooj
0_l2nP03nooo00?o00Gkoo_on`03o`;k00?on_/01?/2o`?k00?jnol00_/02?okno[koo_j1o/01_ok
no_onPOk0oX5n`;j0o/00o[ko`05n`03oo_o00;j00Ckn_[k5?X2n`05oo_on_l00_/00ookn`02n`0:
oo_onookoo[knP;o00?kn_l01O/2nP03no[k00?k00[on_[jno[on_oj1?/01_ojno[ko`;j00?kn_/0
0_/01?[on_X2n`04oo[oo`;k00?onol00_/01Ookoook00;o00?kooX00_l2nP07oo_ono[knP02n`07
n__onooko`02n`;o00Gjoo_ko`02nP09no[joo[koo[o00;k00Cono_o0o/01_okoo_onPGo00Wkoo_k
oo_jooX00o/2o`03nooo00Oo00SkooojnOF/J09400@TA4@T0d@39003A2@T00PT00=492@0:b@00d@T
900g9003A2@T00<T00=492@06B@014@T92@2A0@T2d@00bA49004909412@6A00494AXJ0A400IXA6Q4
J4@2J003A6QX00940VP<A0B800F<[:b/c003[006c:b<[=3A1M000m7@d006d003[=3@00?@00><R8P0
0hP4J0008T@4J003A6QX00><0XP2J0:800=XA4@03T@00fQ4J007A003J4A4009X00V8J6R<[=3en_/0
0_l00o_oo`08o`03nooo00;o00?kool02Ol00o_oo`06o`03nooo00?o00Wkoo[onookooX01Ol2n`04
oo_on`?o0o/00ooko`02n`03oo_k00Ko00?kn_/00_/2o`03nook00?k00?on_l00_/02_ojn_okoo_j
nol3n`05n_oknol00_/2nP09no[jno[ono[o00;j00Wkn_[kn__onol00_/01_okn_ojn`;j00?kn_X0
4OX01_ojoooko`;k00?onol00_/01Ooknook00?o0o/2o`03nook00;k00Gjoo_ko`02nP09oo_ooo_j
oo[o00;j00Kkn_[on_l2n`05oo_jooX00_l02?_on_[ono[o0_X02ookoookoo[koo[o00;k00Kon_[o
nol2n`08oo[joo_joo/3nP;o00Kjoo_kooX2o`0:n_okn_ojnooko`?j01;on_ojnoojnoojoo_joo[k
ooX2n`06n__onook0_l01__ooo[on`;o00Gjnoojo`03n`03oo_o00?o00Wjnookn_We[8P01d@00bA4
90029003A2@T00LT0T@>9003A2@T01/T00=492@07B@00d@T9005909442@2A0LT00E492@TA0089003
A2@T00XT0T@2909412@7A003J4A400DT5d@01VQ4J4AXA0AX0T@2J0Q400=XA4@00T@3R003S:c<00B/
00C@c=3<0Z`2d@03d=7@00;@00?<d=001]000m7@c003d0>/00B8S6QX0XP1J0009T@2J003R8b<00:/
00B8J8R80VP>A09X3D@00fR8J002J004R:c<d@;j1?l00o_oo`09o`03nooo00Oo00?koo/00_l2n`So
00Gkoo[onP04n`04oo[knP;k00Conook0_l2n`03oo_o00Ko00Kjnookoo/5o`Ck1?l00o[ko`02n`03
n_ok00?k1?X01?_jno/2nP;k0oX01?_jn_/2nP03no[k00Ck00Cjno[k0_X00o_jn`04n`05n__on_/0
0oX00o_jn`0EnP;o00Ckoo[o0_/01_oknooko`;k0_l01?_oool3n`04oo[onPGk00?joo/00_/3o`03
nooj00;j00Con__j1?/00oojo`05n`03oo[k00?k00?on_/00_/01Ooknook00;o00Gkoo_ko`02nP;k
0_l01o_onookn_/00ol2nP?k00?ono/00_/01?okn_/2nP03oo_o00;j00?on_X00oX01_oknoojo`;k
00Sono_onoojo`?k00?onol00_/2o`04nooon`Co00?jooX00ol01O_onook00So0_X00oWeR007A0DT
0T@99003A2@T05<T00=492@05b@00d@T900H9003A2@T00LT00=494@01d@00bA49002A00494@T9154
00=XA4@00T@00fQ4A002J09400=XR4@01T@00fR8J002J0>800F<R:b/c003[003d<b/00[@00G<d=3@
c004d004dM3@d0;<00G@[:b/S002R09X0HP1J0009D@01FR8R8R<00:800B<R8R80VP?A003J4A400U4
0VP2A09X00M4J6R<[=3e00;j2Ol00o_oo`09o`03n_oo00?o00?koo/02?l01?_ono/2o`05noojoo/0
0ol01_[ono_on`Co00?kn_l00_/01Oojoook00;o00Kkoo_koo/2o`04nooknP;o00[koo_koo[ono[o
2_X2n`04n_okn`Gj00?on_/00_/01_okno_jn`;j00Okn_[on__o00;j00?onol00_/01Oojn__j00;o
00?jnoX05?X00ookn`04o`04nookn`;o00Ckoooo0_X4o`;k00Wono_on_ojnol00_/4o`;k00?on_l0
0_/01Oojoooj00;k00Kjno[jooX2o`05noojn_l00_/2o`04nooko`;k00Gono_onP04n`;j00Ckn__k
0_l2nP0>noojoo_jno[koo[on_/3nP?k0_X2n`03n__j00Cj00Gkn__jn`02o`;k00gjoooonoojoo_o
nook00?o0o/3o`03n_ok00;k00Kon__joo/3o`03nooo00?o00Ckoo_k0_X00oF<J006A00494A490=4
00<TA4@0>b@00d@T900A9003A2@T01hT0T@<9003A2@T00<T00=494@01b@00d@T900:9004A2@T90=4
00<TA4@022@IA0AX2T@2J0>800>/S8`02:`3d003c=3@00?@00F/d:c<[003d008c:c<dO7AlM42d0;<
0X`01HR<S6Q4009X0D@000m400=XA4@04D@00fR8R002S003d8b800:816PSA0=X00J8[<cen_/:o`03
nooo00Go00Gkoo_onP0<o`0=nookoo_on__joo_on`03o`03nooo00;o1?/01?okool2n`?o00?koo/0
1Ol2n`03oo[o00;k00Oonookn__o00;k00Gon__on`03nP03no[k00Kj0o/7nP07nookoo_on`03nPSk
0_X01Ookn__o00;k0_X00o_on`0GnP03no[o00;o00?koo/00o/2o`08nookoo_jnol2n`03n__j00;j
00Ckn_oj1?/00ookn`03nP06oo[on_ok0_X3o`08n__jno[on_l4n`;o1O/00ooko`02n`04oo_ko`?j
0_/2nP05no[kn_l01O/00o[knP03nP;k00Kjoo[jooX3n`09oo[jn__joo[k00;j00Okoo[on__o00;k
00Gonoojn`02o`03n_ok00Oo00Wkoo_onoojoo/00_l2n`03oo[k00;o00?koo/01ol00o_onP02nP04
[6QXJ0=400<TA2@00T@490941b@00d@T90049003A2@T02@T0T@?9003A2@T00LT0T@O90=40R@00d@T
90029003A2@T00940b@00d@T9002A0`T14@690A400<TA4@00T@492U40hP2S004R:b/c0B/0]02[0S@
00F/c:c@c005d007[=3@d=7@d@02d004c8b<[0:<00=XA6P00T@000=400=XA4@074@2J0:800><[:`0
0VP01HQXJ4AX02E400=XA6P00XP00jcenP02o`03nook00;o00Ckoook0_l01?_ooo/4o`;k00[onooo
noojnooj0_l2n`09oo_ooo[on__o00;k00Gonooon`02o`05noojnol00_/00ooko`02n`;o00?kooX0
0_l02?[ono_ono[o0_X01_ojoo_jo`;k00Kon_okn_l2nP06no[kno[o0_X01?ojn_l2nP06oo[ono[k
0_X01_ojooojo`;j00Kon_oon_l2n`;o00[koo[koo_ono[k0_X00o_jn`02nP04oo[jn`Oj00?kn_T0
0oX02_ojn__joo_jooX2o`05n_ojn_l00_X01Ookoo_j00;k00Gjno[jo`02nP04no[on`Cj00?on_l0
0_X01o_on_okn_/00_X00oojo`02nP05oo_jooX00_l2n`03oo[o00;k00Wono[on_okn_l00_X01_oj
no_jo`;j00Con__o0_X00oojn`02nP09oo[joo[ono[o00;j00Kon__kn_l2nP04no[jn`;j00Kon_[k
n_l2nP03oo[j00;k00?on_X00_/01?[onol3n`03oo[o00;j00kon__on_okn_ojnooko`;k0_l01?_o
no/2o`?j00CaR6QX2D@99003A2@T008T00=492@08B@00d@T900O90948R@00d@T90079003A2A400<T
00E492@TA00690=40b@4A0LT0d@290E40R@CA09X2D@00bA4A006A004R6Q4J0:800><R:`00j`00lb/
[002d004[=2/d@?@00[ed=3Ad?7<[=2/0m002]7@d?7<d?F/S=02[004S:b8R0=X0HP002940VP014AX
R8`2R0AX9d@5J005S=7en_/01_l00o_oo`02n`?o0_/2o`03nook00Go00Gkoo_ko`03n`04oo_on`Go
00Cjoook0_l01?_onol3n`;o0_/00o[on`02o`05nooonol00_/02?okoookoo_o0_/00o[knP02n`03
oo_k00?j00Okoo_koo[k00;j0_/01O[kn_[o00?k00Kjoo_joo/5o`04nookn`Ko0_/01Ooknook00;o
00?koo/00_l01_[ono[on`cj00?kn_X01OX01O_jn_ok00;o00Gkoooko`05n`03n_ok00?o00?kn_/0
0_X01?ojooX3n`03n_oj00Cj00kon_ojoo_onookoo[ko`;j00?on_l00ol00o_jo`03n`;j0ol02?_j
oo_joo[o0o/2nP03no[o00;k00Con_[k1OX02Ookooojoo_jn`02nP04no[oo`?j00[koo[ono[koo[k
0_X01_ojn_ojo`;j0_l2n`09n__kn__onook00;o0_X01?ojno/2o`05no[on_/00_l00o_oo`05o`05
nooooo/00_X01=6/J6P8A00394@T00@T00=492@0:B@00d@T900i9003A2@T010T0T@39003A2@T0094
52@3A00394A400940R@4A08T54@2J003A6Q400I400<TA4@014@2J005R4AXJ8`00XP00hb8S005[0;@
00N/d=3@c=3A00;@00?<d=003m05[0:<00F/R6R8J001R0009T@00fR/S003J003A6Q401E400=XA4@0
2d@00fQ4A002A0=X00B<[=3i0_X2o`08nooknookoo/9o`03nook00Go00Kkoo_koo/3o`03nooj00Oo
1?/01O[onook00;o0_/00ooko`03o`04no[on`;o00cjoooonookoo_jooX2n`06n_ojn_oj0_/00o[k
n`02n`;j00Wonoojnookn_l00_/01ookooojoo/00_l2n`;o0o/00oojo`02n`03oo_o00Ok00?jno/0
0_/2nP06no[kno[k1oX00o_jnP09nP03no[o00;k0_l01?_onol2n`07oo_joo[onP02n`;j00Con_[k
1?X01o_jn_[kn_/01OX01?ojnoX2n`06oo[on__j0_l2n`04oo[knP;k00Won__on__on_l00_X01O_j
no_j00;k0oX01?okn_/7nP04no[jn`;j00?onoX00_X00o_jnP04n`04n__knP;k0oX00o_jn`03nP03
oo[k00?k00?onol00_X01O_jn__j00;k00Oonookoo_o00;j00Okoo_on_ok00;o0_/3o`08nooooo[o
nol2n`05n_F/R6P024@29003A2@T00PT00=492@00b@00d@T90059003A2@T00<T00=492@02R@00d@T
90069003A2@T03DT00=492@02R@2A00394A4008T0T@2909400<TA4@04R@JA00394@T01U400=XA6P0
0VP01HQXJ8R<00V/0/`01Jc@d=2/00;@00GAd<c<[005d005dM3@d=401]001<c@[:`2R003S8QX00=X
000UA0=X00><J4@01D@00fQ4A00VA006J8R8[=3i0oX6n`Oo0_/2o`03nooo00Co0_/4o`03nooo00?o
00?koo/01?l00o_jn`03n`04oo_on`;o0_/01_okoooko`?k00?jno/00_l02o[koookoo_jno[o00;k
00Gono_ko`02n`05oo_jnol02O/00o[on`03o`03nook00Co00?koo/00o/01O[on__o00Ck00?on_X0
0o/3nP08oo_ono[on_l2nP03oo[j017j00Conook0_l2n`04oo_on`?o00Gkoo[knP03n`Wj0o/01_[k
n__jn`?j0_/2nP;k00Sonoojoo[ko`;k00Con__o0_/02Oojnookoo_jo`02nP04no[jn`?j0_/00o[k
n`09nP;k00Kjno[joo/2o`05n_okn_l00_/01?ojoo/4nPCk00Gjno_jo`03n`;j00?kn_/00_X00o_j
nP02n`03oo_o00;o00?jool00_l00o_oo`02o`04no[on`Co00?kool00ol00o[ko`02n`05oo[e[8P0
3T@89003A2@T008T00=492@08b@00d@T90139003A2@T00<T00A494A40R@2A0LT00=492@01R@>A003
94A400Q40R@DA003J4A400A400=XR8P00XP00hb8J002R0R/00?<d<`00Z`4d0;<1M001:c<d=03d@[@
00>/c:`00Z`3R003J8R80068001AA09X1T@2J0:800><mOX00_X01?ojoo/;o`03nooo00Go00Ckoook
1Ol00o[oo`02o`;k00?on_l00_l01__ooooknP;o00?koo/00_l01__ono_onP;o00Kkoo_koo/2o`04
nooon`;o00?joo/00_l01O_ooo[o00;k00Wono_onoojnol00_X01Oojnook00;o00Kjoo[koo/2o`0:
nookn_ojnoojo`;j00Con_oo0_X01oojno_jooX00_l02O_ooo_ono[onP02n`03n_oj00oj00[on_oo
n_ojnooj0_l00o[onP03n`05n_ojn_/00_X00o_jn`02nP05oo[jooX00_l01_[kno_onP;k00Sjnook
oo_jo`;j00Kon_oon_l2nP;o00Ojno[koo[o00Cj00Ckoo[k0_X01Oojn_oj00;k00Gjoo[jo`02nP04
oo[jo`;j01?kn_okn_ojnoojoo_jno[koo[o00;j0_l02?[on_[on__o1?X01__jn__jo`?j00?kool0
0_l01O_jnooj00;o00Kkoo[kooX2o`05nooon_l00_/01oojn_okooX00_/01?G@R6P?A0`T0T@89003
A2@T008T00=492@0:2@00d@T900]90941B@4A0<T00A494A412@014@T94@590Q40fP2A08T0T@00bA4
A00KA003J4A400=400=XS8P01X`2[0;<00K@c<b/c=02c0:/0m000o6<[002d006c=3@d<b/0m001O7@
d=2/00G@00G<d:c<[002S0:80VP1S0680H`005Q41FP018S@mOT2nPKo00?koo/02Ol01?_ooo/2o`03
nooo00;o0_/2o`05noojoo/00ol00o_on`03o`03n_ok00;o1?/01Ookoo_j00Co00?jno/00_l02__o
ooojoo_joo/2o`05nooknol01?/02Ookno_onooko`02n`Co0_/01Ookoook00;o00?kool00_l01__o
no_on`Co00Okoo_kn_ok00;o00Gkoooko`02n`03oo[o00?k4oX01?_jooX2o`06n__onook0ol01O_o
nook00;j00Ckn__j0_l03?_joo[ono[koo_onP;k0_X01O_joook00;j00Ckoo[o0_/01Oojn__j00Ck
00?on_l00_X01?ojn_/2nP;k00Con_[k0_X2n`05oo_jooX00_/2nP0:oo_ono[kn__on`;o00Kkoo[j
oo/2o`04n_ojo`;k0ol00o_on`02n`05n_oknol00_X01?ojooX2n`05oo_kn_l00_/2o`04nookn`;o
00Ckoo[k0_X02o_jn_okoo_onook00Oo00CkmM281D@012A4A2@6A0@T00=492@05B@2A08T00=492@0
0T@89003A2@T05DT00E492@TA005909412@2A00394A400M40R@014@T94@290Y400<TA4@02D@00bA4
A005A00394A4009X00J8S8b<[8`4[0;<00>/d=001=000jc<d004d003c=3@00;@00?<d=000Z`;d003
c=3<00>/1H`2R0:<0HP005Q400=XA6P00VP01dB8S=3in_/00_l01?[kno/7o`03nooo00ko00?kool0
0_l2n`03oo[o00Co00?kooX00ol01__onoojn`?o0_/2o`05nooknol00_/02?oknookn__j0_l00o_o
n`02n`03n_ok00;o0_/3o`?k0ol00o_oo`02o`09nooooo_onook00;o00Ckoooj0_/00ooko`06o`;k
00Cjoooj0o/00ookn`04n`03n_oj00;k4_X00o_on`03o`04n__on`;o00?koo/01?/00oojnP03nP03
oo[o00?k00Konoojoo/4nP03oo[k00?j00?kn_/00_X02?_ono_jno[k0oX2n`04oo_knPGk00Kono_o
n_l5n`03oo_k00Ck00?jooX00_/00ookn`02nPCk00Cjno_j0_/01?okno/2nP03no[j00;j1_/01?[k
nol9n`07oo_kn__jn`02o`04noojnPCk00_jno_kn__joo_on`0;o`04n_G@R0M40b@01D@TA:a400@T
0T@00bA4900;90A40R@2A00494@T90E41b@00d@T900=9003A2@T01PT00=492@092@2A08T00=492@0
2R@2A0<T00A492@T1T@00bA4A00490A400<TA4@01d@00bA49006A00394A400=40R@5A0=X0XP00jb<
[002[005S:b/[=000/`00m3<c009d006dM3@c=2/0]02c0?@0]42d005dM3<d<`00Z`01HR/[:b<00>/
00>8J6P00XP001m400=XA4@014@00fQ4A00YA003J4A400=400=XA4@00d@2J003[=7j00;j00Ckoo_k
0_l00o_oo`07o`03nook00;k1Ol01__ooo_on`?o0_/01O[onooj00?o00?kooX00_/01?oknoX2n`05
oo_onol00_/00ookn`02o`;k00Conooo0o/2o`03nooo00;o00Gkoooko`02n`04oo_on`?o00Kkoo[k
oo/2o`04nooko`;k0_l4n`03oo_k00Co00?kooX00ol01O_on_ok00;j00Gkn__jn`02nP06no[joo[k
4oX9o`;k00Conooj0_/00ooko`05nP03oo[o00;k0_l02?_on_okoo_o0_/3nP07no[jn_oknP03n`03
oo[k00?j0o/4o`04n_oko`?k0ol01O[ono_o00?k00Gjoooko`02nP03oo_j00?k00Wonookn_okn_l0
0_/00ooko`03n`03n__k00;k0_X01O_on_ok00Go00?jooX00_/01O[koo_o00?k00Kjnoojoo/4nP03
no[k00;k00Gjoo[knP02n`03oo_o00;o00?koo/00ol01__on_G@R09X1D@590=400DTA2@TA0029003
A2@T00XT0T@016Q4A2@2A0@T0d@89094@B@2A08T00=492@02B@2A0DT0T@99003A2@T00DT00=492@0
0b@2A00594@TA2@00d@4911400@TA4@T1D@3J003R8b800>81:`018b/S:`2d0B/00?<d=002M000lc@
c004d003c=3e00;e0]02d@C@0Z`00hb/R003[0;<00B/R6QX0HP001i40fP00dAXA00gA09X00M4J6R<
c=7i00;j00?onol03?l00o[oo`02o`;k1?l00o_oo`03o`03nooo00;o00Gkn_ojo`02n`;o00?jooX0
0_l2n`?o0_/2o`;k00_joookoo_joo_jo`02n`03oo_o00Co00?koo/00_l00o_on`02o`05no[knol0
0_/00ookn`02o`03nook00;o00Kjoo_kooX2o`03nook00;o00Gjno_jo`02n`;o00gjoo[koo[ono[o
no[o00;j0_/00oojnP0CnPOo00[koo[koo_joo_o0_X2n`05n_okn_l00_/00oojo`02nP;k0_l00o_o
n`04nP03oo[j00?j00Kkn_ojnol5nP03no[k00?o0_/2o`05n_okoo/00_l01?_jooX3n`04oo[jn`?j
00?kn_/00o/00o[kn`02n`03n__k00;o00Gkoooko`02n`03oo[o00Ck00?jno/00o/00o[kn`02n`;j
0_/01?ojnoX2n`;j00Skn__jno[onP;k00Cjno_j0_/01?oknoX2n`0;oo_onookoo[on_l00_/01_[i
d8b8J0E400@TA4A43B@00d@T900:90941R@4A08T00=492@01B@2A0TT00=492@00d@c9003A2@T00DT
00=492@012@3A0@T00=492@01B@00d@T900;90A40b@2A00394A400940R@8A003J4AX00a40VP2R004
J8R8[0:<0XP7[003d:b/00>/00?@dM000]000m7@d008d003dO7@00;@0_D01_7@d=3Al@C@00?<[:`0
1j`00hR<R001S0003D@2J11416PdA003J4A4009416P2R003c?Gj00;j00?onol01?l01O_ooo[o00;k
00GonooonP02o`04n_oon`;o00Kjoo[koo/2o`04n_oknP?k00con__on__onookn_l2n`06oo[ooo[o
0_X01?_jn_l2n`06oo[ono[o0_X01_ojoo_jn`;j00Kon_oonol2nP04no[ko`;j00Kon_oonol2nP06
oo[joo[o0_X01_ojn__jo`;j00Con__o0_/01?ojno/4nP06oo_ono[o0_X00oojnP0CnP;k1?l2n`06
oo[joo_o0_X3n`05oo_jooX00_l02_[ono_on__on_l2nP04noojn`;j00Gkn_[knP02n`Cj00?on_/0
0_X01_ojn__jo`;k00GjoooonP02o`06n__on_ok0_l2nP0<oo[on__on__on__o0_/02_okooojnook
ooX4o`05nooonoX01?l01?[kn_X2n`0<n__kn__jno[onooj0ol4n`05n__joo/00_l00o_oo`02n`;j
0_/01?[knol3n`05oo_on_/00_l01?_onol2nP03dJaX009X14@290940R@2A0PT00=492@01B@2A0<T
0T@29003A2@T008T0d@;90A412@014@TA4@59003A2@T00dT00=492@05R@00d@T90079003A2@T00dT
0T@59003A2@T00<T0d@<9003A2A400941R@3A08T0d@00bA4A00:A003J4A400=400AXS8R80VP018R<
S:`2S0:/00><c:`01:`2R009[=3@d?G@c=7<00?@00GAd<c@d@03d0;a0]001OGAmO7@00;a00?edM00
0]001<b/S8`6[003R8b8006<000OA003R6QX03Q400=XA4@016P01hR/d?Gin_/02ol00o_on`04o`04
nooon`;o00?kool00ol01O[ono_j00;k00?on_l00o/00oojo`02o`04nooko`Ck00Kon__kn_/2nP04
oo[jo`?k0_X2n`06oo[jn__j1O/00oojn`03n`;j00?onol00_/01O[kn__o00;j00?kn_X00_X00ooj
nP02nP05no[jooX01?/01O[koo_o00Gk00Oono_on__o00?k00?jnoX05?X2n`;o00Ckoook0oX2o`06
n_okoo_o0_/01?[onol3n`03oo[k00;k0oX3n`?j00Gkn__jn`03nP03no[k00Gj00?kn_X01OX00o_j
o`02o`04n_oko`Ck00Kjoo_kn_l2n`08n__jn_okn_l4n`;o00?jno/01O/2o`Ck0_X5n`03oo[j00Cj
00Kkn__jnoX3n`06n_okoo_o0_/01O[ono_j00Ck00?on_X00_/00o[onP02n`04oo[jn`?o00gkoo_o
nookn__jmHb800=X00A4J4A40R@2A00494@T90=42B@00d@T90099003A2@T014T00=492@01R@00d@T
90059003A2@T02lT00=492@02B@00d@T90029003A2@T00TT00I494A494@990I40R@00d@T900590=4
0R@5A004J4AXJ09400=XA6P00d@2R005J8R<R8`00Z`00hb/[008[006c:b/S=3<1]02[0C@00?<d:`0
0]000o7Ad@02d@03mO7a00;a00OedM3@[=2<00:/00><[:`01:`00hR<S001R0004T@00fQ4A009A005
J8R<R6P09D@00fQ4A00>A0=X0d@3J004R:c@m@;j00?ono/02_l00o_oo`05o`03no[k00Ko00Gkoo_k
o`02n`03oo[k00?k1ol01?_onol2n`09oo[joo[koo[k00;j00Gono_onP02n`03n_oj00?k00?jno/0
0_l01_[on__on`;j00Ckoo_k1?l2n`05oo_oooX00o/04Oojoo[onookoo[kn__on__o00;k00?ono/0
1?l01O_ono_o00?k00?jnoX05OX00o_oo`02n`05oo_kn_/01_l3n`06oo[ooo_o0_X01?ojooX4n`04
oo[on`;j00Gkn_ojn`05nP04no[jn`;j00[on__jno[kn_ok0_l2nP03oo_o00;k00Gono[onP02n`05
n_ojn_l00_X2n`06n_oooo_j1?l01O_ooo_o00;k00Con_[k1?X2o`05nooknol00_/2nP;o00Kkoo_k
oo/4o`03nooo00;o00Kkoooonol2n`07oo_koo[onP02o`;k00?onol01?l01O[onook00;j00Okn_[e
[8b800A41B@00d@TA00D9003A2@T00<T00=492@03b@00d@T90059003A2@T01lT00=492@06b@01D@T
92A4008T00A494A44B@3A0TT2D@00bA49002909400<TA4@00R@8A0=X14@00fR8R002J0:800>/S:`0
2:`00m3<c003[0;<1M001Lc@c=3<00;@00_<d<b/d=7@dO7Al@02d004lM7el@;@00OAd=2/c:b800:<
00B/S:b<0j`1R06/0HP000=X2D@2J0m40VP018R<[6PmA0=X00B8[=3e0_X00o_oo`05o`03nooo00?o
00?kool01Ol01?_ooo/4o`05nooon_l00o/6o`03nooo00;o0_/02?okooojoo_j0_/00ooknP02nP;k
1?l01O[kn__o00?k00Gjoo_ko`02n`?o00Gjno_knP02o`07noojoo_jo`02n`;o00?kooX00_l00o_o
o`02o`03n_ok00;k00Kjnoojnol3n`05n__jn_l00_/2nP04no[jnaSj1?l01?_ono/3o`;k00?onol0
1?l3n`03n_ok00Kk00Oonookoo[o00?j00Ckn_oj0o/01_[kn_ojo`;j00Gkn_[onP04n`04oo_onP;k
00Oon_okoo[k00?j00?kn_X00_X01__jn_[knP;k00Cjoo_o1O/01?ojoo/3nP03no[j00?j00Gono_k
o`02nPGk013ono_koo_on_okn__onooj1O/01?[knol2n`;j00?kool00ol01_[knooko`?k00?ono/0
0_/2nP04mM28R0=400<TA4@01R@00d@T900F9003A2@T00hT00=492@022@00d@T900J909452@00d@T
90069003A2@T01XT00=492@02b@<A00394A400E400<TA4@01d@00fR<J002A09X0X`2J007R:b/R8b8
S004[003c:c<00>/00?<d=001=000lc@c003d006[<c<c=2/1=02d@03mM3@00;@00[adM7Ad=7@c:c@
0Z`00hb8R002[006S:b8R:b80FP000=X2D@00fQ4A00>A006J8R<d<aX74@00fQ4A00NA0=X0XP00jcA
m@03nPWo00?kn_l01?l00o_on`03o`03nooo00;o00?jool01Ol01?_oooX4o`0;nooooo_onookn_l0
0_/02?ojooojoo[k0_l01__ono_onP;o00Kjoo[koo/2o`03nook00;o00Gkoooko`02nP07no[joo_j
o`02n`?o00Ckoooj1?l00o_jo`03o`0;n_ojnookn_ojnol00_/2nP04no[jn`Oj00?kn_X03oX01_Wj
n_[onP;o00?kooX00ol00o[oo`02o`05nooonol00_/02?okooojoo[o0o/02Oojooojnooko`02nP07
no[koo[onP05o`04n_ooo`?k00Son_oono[onPCo00?kn_/00oX3n`Oj1?/00o[oo`04n`04oo_ko`?k
00Sjno_kn_ojo`;k00Kono[onol2n`03oo_j00;k00Gjno[on`03nP07no[kn_oko`02n`04n_ojo`;k
00Gon__onP02o`;k00?on_l00_l00o_on`03o`07no[kn_G@R002J0M40b@3A00394@T008T0T@00bA4
90049003A2A401/T00A492A40R@4A1XT0T@D90943B@00d@T900B90=40R@00d@T9002909412@=A003
94A400A40R@00d@TA002A004J4AXA0=X18P2S003R:b800:<00=XS:`00Z`01<c@[:`2c0;@0/`3[0?@
00>/d=000]001<c@d<`4d00:dM3alM7amM3ad0;a00GAd=2/c002d0>/00F<[8R8[002S003[8b<005X
000NA005J8S@S6P09d@00fQ4A00>A003J4A400A40fP018R/lOD2nP07nooooo_on`02o`03no[o00oo
0o/00ooko`04o`03nooo00;o0_/00ooko`02n`03oo_k00?k0ol2n`04oo[kn`Co00?koo/00o/03Ooj
n__joo[koo_onol01?/2nP03nooj00?o00?kn_X00_/2o`04n_okn`Co00Gjno_ko`04n`04oo_jnP?k
00?jnoX01OX00o_jnP0KnP;k00Gono_on`05o`03nook00;o00kkn__jno[onookoo[on`?o00Ckoo_o
0o/2nP03no[j00?k00Con_ok0_l01O_joo_o00;k00Cjno[o0_/01O[kn__j00?k1OX01Oojn_[k00?j
00Ckn_[j0o/00o[onP02nP03nooj00?k00?on_X00o/01O[kno_j00Ck00Gjno_ko`02n`04n__kn`;j
00?kn_/01?X00o_jnP04n`09n_okoo_on_ok00Go0o/00ooko`02o`04n_okn`;o00GjnoW@R002J005
A6Q4A2@00T@390941b@2A0dT00=492@052@00d@T900490=4DB@00d@TA002A0<T00=492@01B@00d@T
A00<A0<T1D@00bA4A009A09X1HP02:b8S8R<R:b<1:`01<b/[<`2d003[<b/00>/0]000lc@d003d005
c=3@d=401=02d@?a00Ked=7Ad=43d003[<b/00;<1:`00hQXS004S0680FP0009X00=4J4@00d@3J1E4
00=XA4@0@4@026Q4R8R/d?Gj1_l01?_ono/=o`03nooo00Go00?jool00ol00o_oo`02o`03nooo00;o
00?kool00_/00ooko`04o`;k00?jnol00ol3n`04n_ojnP;o0_/01_[knooknP;o00?joo/01_l01?_o
ool2n`;o00?kool00_l00o_on`02o`05n__onol00_X01?_jnol2nP03no[k00;j00?kn_X00_X2n`03
n__j00Kj00?on_X04oX00ooko`0:o`05nooonol00o/01?[on_/6o`03nook00;k00?on_/00oX01?oj
no/2o`;k00_on_oon_ojnooko`02n`06n__koo_o0o/02_ojoo_jno[kooX2o`05noojn_l00_X2n`04
n_oko`;j01;ono_on__onoojnookn__jooX2n`03oo[o00;j00Wkn_[kn_okn_/00_X01?ojnoX2n`03
oo_o00?o00Ckoook3?l2n`0<oo_kn__jno[onook0_X00m2<R002J0943B@00d@T900290944B@00d@T
900>9003A2@T00XT00=492@01b@00d@T9002A1PT00=494@022@00d@T900<9003A2@T00@T0d@490A4
0b@2A0HT3d@2911400=XR6P00fP014B8R8P2S005J8b<[8`01j`2c0F/0/`2d003c=7@00?@00?Ad=00
0m02d@05d=7adO400]47d005[<b/[=001J`2R005J8b<S8P00VP000MX0T@00fQ4A01FA003J4AX009X
00F<[=3enP02n`Oo00?jool00ol00o_on`02o`03nooo00?o00?kooX00ol00o_oo`02o`;k00Gonook
o`03n`co1?/4o`;j0_l2n`07n_oknooko`02n`0:n__koo_joo_on`;o0_/2o`03nook00;o00?kool0
0_l00o_oo`05o`05no[knol01OX01_okn__jn`?j00Gkn_ojn`02nP03no[j01Kj00?onol01?l4n`03
oo_o00?k0_X00o_jn`03n`?o00Kkoo[jnol2n`03n__j00Cj00Kkn_[jooX5o`0;noojoo_onookooX0
0o/01?[on_l4n`03n__j00Kk00Con__k0oX00o_onP02nP;k00?on_/00_l7n`;o0o/3nP03no[k00Gj
0o/00oojn`03n`?j0_/01?oknol5n`04oo[on`?o00Ckoo[o0_/01_[knooko`;k00Cjno[k1OX01M6/
R8QX00=400<TA2@02B@014@TA2@2A0HT00=492@01b@00d@T900H90944B@00d@T900D90U41b@00d@T
90069003A2@T00@T00=492@012@00d@T9004A0<T0T@00bA4A007A08T0d@2R0E400<TA4@01T@00fQ4
A002A09X18P4J0:800B<R8R80X`00jb8[006[003d:b/00B/0l`2d003dM3A00G@00O<d=3amO7A00;a
00?@lM400]001/c@[<c@c0J/0XP00hb8R003J003S8R8005X0005J003A6Q401e400=XA4@0=d@00fQ4
A002J0940VP01HR/mOWj00;o00?kool01?l01?_ooo/4o`05noooooX01?l01O_ooo[o00;k0_l00o[o
n`03o`05noojoo/00ol00o_on`05o`03nooj00;o0_/00ookn`02nP05oo_koo/00_l01_[ono_onP;o
00Kjoo[kooX2o`03nooo00;o0_/2o`03nooo00;o00?kooX00_l00o_oo`02o`09nookn__ono[o00Ck
00Gono[onP02o`03n_ok00;k1?X01?_jno/BnP;o00?kool01?l00o_oo`03o`04no[knP;k00?joo/0
0o/2o`04noojn`?j0_/02Oojno[kn__jn`02o`04noooo`;k00?ono/01Ol01o_onookooX00ol3nP?k
00Sjoooonooko`?k00Gono_jo`02n`06n__kno[o0_/00o[kn`02n`?o0_/3nP03no[j00Gj0_/3nP03
no[o00?j00?kn_l00_l02?[kno[koo[k0_l01__on_oknP;o00cjoo_ono[koo[on_/6nP05nM6<[8P0
0T@2909412@3A0DT0d@69005A6PT94@00R@2A0`T00=492@02R@00d@T90029009A2@T94@TA2A401TT
00A492@T24@012A4A4@690940b@2A08T0T@690941R@2A08T0d@290940b@5A00494A490=400>8d6P0
14@00bA4A002A09X0T@00fQ4A004A09X18P2J0:<00>8[8`00h`4[005S:b/[<`01Z`00lb/c003d003
dM3@00C@0/`2d004dO7@l@?A1=000lc@d002[003d:b/00>/00><R6P00XP01HaXJ6R8009X0HP002E4
00=XA4@0?D@3J006R8c<mOWj1Ol00o_oo`07o`05nooooo/00_l00o_on`03o`?k00?ono/00_/2o`03
nook00;k0ol00o_on`05o`06nooooo_j0_l02?_ooo_joo_o0_/02Ookno_onooko`04n`04n_oko`;k
00Conooo0_/4o`05nooonol00_/3o`04nooonPCo00Cjoook0_l00o_oo`03o`04nookn`;o0o/3nP;k
00Cjno[k4OX2n`03oo_o00?k00?ono/00_/00o[kn`02nP?k00Gjno[knP03n`03n_oj00;k0oX4n`Oj
00Sonooono[knP?k00Gjno_onP02o`03no[o00?k1?X01?_jn_X3n`09n__kno[kn_oj00Gk00?jno/0
0_/01?oknol2nPSk00?jno/00_X00o_jnP02nP;k00?jnoX01_X01__jno[knP?k0_X2n`03n_ok00?o
0_/00o[onP02n`Cj00Gon_[jo`06nP04nM2<R09X00A492@T0T@590941B@00d@TA00<9094@b@5A08T
00=494@00d@01BA492A4008T00=492@01R@2A0DT0d@01BA494@T00940b@00d@T900590A412@02D@T
A4AXc?F8J00BA004J4A4J0B800=XS8P00X`01:b8S8`3[0:<00B8S:b<1J`00lc@d003d003dM3@00G@
00KAd=3Ad=42l@;A2=02[006c:b/S8R/0XP2J0:81fP000I400=XA4@084@00fQ4A00jA09X00R8S:c@
mOWjn`;o0_/00ooko`02n`Co00?kool00_/01_oknoojo`;j00Con_[o0o/01_[koo_on`;o1?/02?ok
n_ojnooj0o/01?okn_l2n`03oo_j00;k0_l01O_ono_o00Ck00Cono[o0_X2n`03oo_o00;o00Kkoo[k
oo/2o`06nooknook1?l2n`03oo[o00Ko0_/00ooko`03o`;k00Kono_on_l2n`;o00Ojoo[jno[o01?j
00SonooonooknP?o0o/2nP05oo[jnoX00_/01?[on_/3nP0:no[kn__jno[onP;k00Gjnoojo`02n`05
oo_jooX00_/3o`04noojo`?k00con_ojnoojnoojoo/2o`;k00?on_/00oX00oojo`02nP05no[jooX0
0_l01O_ono[o00;k00Kon_okn_/2nP06oo[jno[o0_X3n`08oo[koo[on_/3nP03oo[j00;j00Kkoo[o
noX2o`04noojo`?k00Gjnoojn`03nP03oo[k00Sj00?ed8P016P01T@T94@TA0dT00=492@02b@00d@T
90059003A2@T00dT00=492@01B@2A0`T00=492@02b@3A0@T00=494@00d@290A40b@2A00394@T008T
00=492@01R@3A00394A400I40b@2A0HT0T@00bA4A003A0@T0T@01RA4A6R<J1941VP2R003S:b800:8
00><[8P00Z`2S008[8b/[8b/S8P4[003c=2/00;@00?Ad<`00Z`01<cAd?42d@05d=7@dO400m400lc@
d002d003c=3<00B/0h`5R003A8QX00:80VP1R05X001VA0=X0XP02Jc@mOWjno[knP02o`;k00?on_l0
0_/02?oknookn_oj0o/3nP03no[j00?j00?kn_/00oX00o_jn`03nP03no[k00Cj00Ckn_[k0oX01O_j
oo[o00Gk1?l2n`;j00?kn_/00o/2nP?k00Cono[o0_/01_okoo[ko`;k1ol01O_ooook00?o00Gkoook
o`04n`Co00Kkoo_koo/2o`Gk5_X2n`;o00Kjoo_on_/2o`03nooj00?o00Ckn_[k0_X2n`04n_ojo`Gj
00[on_ojoo_on_oj0_/02?okoo[ono[k0ol00o_on`02n`05oo_knol00oX00oojo`03n`05n__kn_l0
0o/2nP03no[j00;k0oX00o_jn`02n`05n__jnoX00_/5nP05no[kn_/02?X00o_onP02n`05n__kn_/0
0oX00o_jn`03n`03oo_o00;k0_l02?_on_okn__o0_/5nP03no[j00Sj00?idH`00VP2R003A2@T008T
00=492@00b@00d@T90199004A2A4A0@T00A494A412@3A00394B800M412@014@TA4@990E400DTA2@T
A0029003A2@T00DT00=492@014@012A4A2@3A00394A400U400DTA4A49008A003J4A400=X0XP00jb8
[004S006[8R<S8R<0j`018b/R8`3[003d<c@00;@00CAd=3A0]001/c@d=7@d@C@00?<d=001M02[0?@
00N/S8b/R8b/00><00F8J6Q4J002R06<0HP1J0009D@00bA4A00XA00394A4019400=XR4@00fP018b/
[?D6nP05no[kooX00_/00ookn`02n`03oo[o00;k1OX00o_jnP03nP09no[kn__jno[k01?j00?kn_l0
0_/01Ooknook00;o00Gkoo[on`02nP03oo_o00?k0_X01?_jnol2nP04no[knPCk00?onol00ol2n`04
oo_on`;o00?kool00_/01Ookoook00;o0o/00ookn`03n`06oo[ono[k5?X01?Wjn_/2o`06nookoo_j
0_l01?_ono/2o`04noojo`Cj00Ckoo[k0_X01_oknoojo`;k00Kjoo_on_/2o`04noojo`?k00?onol0
0_l2n`04n__ko`Ck00Cjoo[o1?/00o[onP02n`05n__jn_/00_X01O_jnooj00;k00Ojno_joo[o00;k
00Con_[o0_/00oojo`0:nP04noojo`?k0_X00o_jn`03n`0?oo_on_okn__on_okn__j00;k00Cjoo_k
0oX00o_jnP06nP03nO[j00;j00Oed8b<J4AX00941b@2A0<T00=494@0:B@00d@T90029003A2@T01hT
0d@4909400DTA4A49003A003J4@T00DT00=492@02R@3A0/T1T@00bA4A005A00394A4009400<TA4@0
1d@490=400<TA4@00T@3J0941fP2R00:S8R8R8b/R:b8S0F/00><[=000]000lc@d002d003dM3@00G@
00?Ac=001=000lc@d002d@;@00?<[:`01=02[0:80Z`2J0:800AXR6QX0XP1[0680FP000Y400=XA4@0
FD@01VQ4A4AXS0:800?<mOT00oX01__jn_[ko`;k00Son_okn__onP;o1?X01_ojn__jo`;j0_/00o[o
n`02o`Cj0_/02_[ono[on_okn_/2nP03no[j00?j00[on_oon_ojnook0_l02__on_[on__on_l2nP04
oo_jn`;j00Kon_okn_/2nP0:oo[koo_on__onP;o01Sjoo_koo_joo[koo[ono[ono[on_okn_l2nP04
no[jn`kj00?in_T00oD3nP05oo_jooX00_/00o[on`02n`06oo[on__o0_X03?_joo_jno[koo_on`;j
0_/00ooko`03n`03oo[o00;j00Kon_[on_l2n`;o00?koo/00_/02?[koo_ono[o0_X01_ojooojo`;j
00Con__k0_X01_ojoo_jo`;j00?on_/00_/02Oojn_ojnoojo`02nP04oo[jn`;j00?on_/00_X01O_j
n_oj00;k00Gjoo_jn`02nP06oo[ono[k0_X01?_jn_l2n`03oo[o00;j00Ckn__k2oX01?WjmOD2nP06
mM3<S8QX14@>9003A2@T00dT00=492@01B@00d@T90099003A2A400LT00=492@04R@014@TA4@69004
A2@TA0<T0d@290M400J8A4A494@29003A2@T00XT1D@59003A2@T00<T14@016Q4A6PCA08T0T@00bA4
A005A09X00><J4@016P3A00:R6R8R8b/S:b8[0:<0Z`01HR/[:c<00;@00?Ad?401m000lc@l@06d004
c=3@c0G@0/`00jc<d004[004R8b/S0>80VP6R06<0FP002Q40VPlA003R4A4009400N8J6R<c?7e00?j
00Ckn_[k1?X01?_jno/2nP04oo_kn`Cj1?/2nP;k00Con_[k0ol4n`03n__j00;k00Sjoo_joo[on`;j
00Kkn__kn_l2n`06oo[koo_o0o/00o[kn`02o`?k00?jno/00_X00o_jn`02nP;k0oX01O_onook00;o
0_/00oojo`02n`03oo_o00;o00?joo/00_l01?[kn_X2n`04oo_oo`?k00Gjno_jn`02nP03no[j00cj
00?edM000]000o7enP02nP03oo_o00;j0o/01?oknol2n`03oo[o00;j00Kkn__kn_l2n`;o00Gkoo[o
nP03o`03nook00?o00Gkoo[onP02n`;j00Wonookoo_on_l01O/02oojoo[koo[koo[k00;j00?kn_X0
1_X00o_jn`05nP06no[joo[k0_X00o_jnP02nP03no[j00?j00?kn_X00oX00o_jn`0;nP03no[j01Wj
0_T2m@03n_Ge00;e00KjmO7@[8P2J0=400DTA2@TA0049094<B@00d@T900E9003A2@T008T0d@00bA4
900390E400=XA4@01D@29003A2@T00=40b@3A08T0T@39004A2A4J0@T1T@00bA4A002A003J4A400M4
00<TA4@03D@290M40VP00hQXA002J006R6QXR4B80VP2S004[8b8R0><1Z`3d003dM3A00;@00KAd=3a
d<`7d006c=3@[=3<0]001<c@d:`3d0B/00B<[8b<18P016R8R8P2J0680FP1R000:D@00hQ4A00jA09X
14@2J004R:c<l@;e0_T4nP;i0_D00oWjn@0JnP03no[j00gj00?kn_X02_X01?_jno/2nP03no[j00Ck
00?jnoX01?X00o_jn`02nP;k00?joo/00_l00o_oo`05o`;k0ol02O_ooo_jno[ko`02n`03oo_k00?k
00Sjno_koo_jn`kj0_T2m@04lJb/S0:800B/d?Gi0_X04o_jno[kn__jno[kn__jno[kn_/00oX02?_j
no[on__j0_/00ookn`04n`04n__jn`;j00?kooX01?/00oojo`02n`04n_ojnckj0_T00oGim@02n@ge
00?imOD02oD2l@04mO7el@;A00GamOGel@02m@03lJb800=X00=492@0>R@2A1TT00=492@00d@29003
A2@T008T2T@012A4A2@2A00394A400Q412@014@T92@6A0<T1D@00bA4A007A0<T00=492@01B@@A003
J4A4009X00=4J4@00VP028QXJ6R8J8b80X`3[003R8b/00:<1:`3d003dM3@00O@00?<d=403=03c005
[<c<[<`00Z`2S0B/00><[8P00VP00hQXJ002J0:80H`000M400=XA4@04T@00bA4A01:A09X00A4J6QX
0hP3d004lM7Ad@?a0]401M3AlOGa00;e00KamO7elM47m@03lOGe01?e00?in_X00_X4n@03n_Wj01Sj
1_/2nP?k00?ono/01?l2n`03n__k00;k00Kjnooon_/2nP09no[kno[ono[k00Cj00?kn_X03?X00oWe
m@03m@06dLb<S8QX0XP00jc<d002m@Sj00?kn_/01?/03?[kn_ojno[kn_oko`;k0oX00oojo`04n`03
n__j00Cj00Ckn_[j0o/00o[knP0:nP03nO[j00Ce00?imOD08_D00o7em@02l@03mO7e00;a00CedM7@
0]42d003lM3<00;A00G@dM3@c002d0?A00?@dM401=000jc@[002[003S:b<00B<0XP00fR/R002S0:8
0X`00hQXA002A0@T00=494@00T@;90945b@00d@T90049003A2@T01dT00=492@00b@00d@TA00490=4
00<TA2@01D@2909400@TA4@T3D@790M400<TA4@03T@?90i40fP00dAXJ005R004[8R<[0B<0Z`00fR8
[003[004S<c@c0k@0]45d008c=3@d<c@c=02[004c:b/[0>80j`01Xb/[8b8J0B800AXR8R/0H`006a4
1VP01HR/c8b/00:<00C@[=3<0j`5d004[=3<d0?<0m000lc@[002c0?@0l`01Zc@d<c@c0;@00?AlOD0
0m42l@_e00?imOD00_D00oWen@0>nP06oo[kno[o0_X01_ojn_ojo`;j00Ckn_[o1oX01?_jn_l4nP04
no[jo`Cj00Con_[k1?X01O_jn_[i00;j00?enOX01OD02m7@dM2/R8b8S:b800:/00?@dM400_D00o[i
nP03nP06oo[koo[o0_X01_ojn_ojo`;j0_/01?[on_/2nP04noojo`;j00?on_X03oX01OWjnOGj00[e
00KAlM7Ad?D2d004dO7@m@;A00?edO400_43d00:[=3@[=3<[<b/d0:<00B/S:b/0X`3[004c:b/c0>/
00K@[<b/c:`2d0:/00[@[=3<d:c@[<b/0m02c0B/18P00hb8J002J0:800AXA4A40VP01TAXR6R/J094
1b@2A00494A4A0TT00I492@TJ4@69003A2@T00XT00=492@02R@00d@T900G9003A2@T00DT00A494@T
2T@016Q492@6A08T14@290=400>8A2@01b@2A00494A490M400<TA4@01T@00bA490049003A2@T00<T
00=494@02D@00fQ4A002A003R6QX00:800]XR8R8S:b8[8R<[002S009[<b/R6S<[8c<00:/00G<[=3<
d@07d006dM3@d<cA0]000o7@c003[005d<c@dL`01J`00hb8R002R003S8R800:800B/R6QX0XP01HaX
S=2<006/000JA00394A4051400=XA6P00VP2R003[8b800:800><[:`00Z`00hR/[003[003S:c<01:/
00B<[:b/0X`3[0;<0m001<b/d=03c0?@00>/c?400_400oGAl@03l@[e00KimOGin_TEnP05nO[in_T0
7OX6m@03lM7A00;@00>/c:`00Z`00hR/[003R003S<b/00;@00GAmOGen@06nP07no[jno[knP04n`03
oo_k00?j00?kn_X03OX01?WenOT;m@;a00?Ad=401=03[0;<2Z`00hb/[004[0B800N<[8R/S8R<00:8
00=XR:`01HP4[003S:b/00:<0j`01Xb/[=2/c0F/00?@[:`01J`01<b/S:`2S003J8QX009X00>8J6P0
16P7A0AX00>8J4@00b@00d@T90029004A2@T90941R@2A0@T00=492@06b@00d@T900C9003A2A40094
0b@2A0TT00A492@T1T@01BA4A4@T00Q400<TA2@00T@290=42R@3A08T1d@2909400@TA4A41b@2A0@T
1T@012A4A6P7A09X00A4J8R80VP3R0:<0XP01Xb8S8b/c0>/0]02[004S<c@c0S@00?Ac=002M000lb/
[005d0>/00>8S8`00X`01XR<[8R<R09X00B8S8QX0XP00haX[002[06<000DA00394A405Q40fP01HQX
S8b8009X0XP2[004R8b<S0:/0XP2S0J800>/S8`00XP2S003[8b8009X00J8S8b/S8P5[003S:b/00>/
00B8S8b80Z`00hb/[002[0C@00G<d:c@d@02d003dM3@00Ge0_4?m@03nOGe01[e0_T00oGin@02n@03
mOWe00Ge1=04[004d<b/[0;<0Z`00hb/J002R004S:b<S0:/00?<lOD01?D2nA?j00?in_T00_X2m@05
nOGemO400_D00m3ed003d0:/00?<dM000m02[005c=3@[<`00Z`3R006S:b/S8QX0XP00fR8R002J004
R:b<S0>800><J6P016P4R00?J8QXJ8b8J8QXR8b8S8R<00:/00J<R8b/R8`6[0;<00G@c:b/c003[004
R:b/[0:<00F8J4A4J002A003R4AX009400AXA4@T1T@2J0=400HTA4A494@@9003A2@T00XT0T@;9003
A2@T00HT00=492@04b@00d@T900590A42R@4A003J4A4008T1T@00bA4A003A08T1T@39003A2@T00DT
0T@590941R@014@T94@49003A2@T008T0d@29003A2@T008T0T@2J0U416P00hQXJ002J0:80VP01HR<
S8b800^/0/`00m3<d003d003c=3A00S@0/`5[004c=3@c0:/00><R8P01XP2S00=R6R8J8R<R8b8[8b/
S002R000=T@3J2a400<TA4@01T@02FQ4J6R8J8R<R002J0:800F/S8R/S002R0:/18P2J004R6R8S09X
0XP00fR8R002R09X0XP2[0:80X`01:c<S8P3S003R6QX00=X00F8J6R8S006[004c:b<[0?@00?A[=00
0]000m7ad@03d003mM7A00;e00G@dM7ad@03l@03dOGa00;e00GamO7Al@03d005dM3Ad?400]000m7a
l@04l@;e00?amO401?D2l@03dO7A00?A1:`00lb/[002[003c:b/00N/0hP2S003R8b<00:/00?@c=00
0o42m@03lOGe00ke1?401=3alOD3d007c:b/[<b/S003[0><0Z`01Hb/S:b<00:/00?@S8`00X`01:aX
R8P2S0:800IXA6R8J4@5J0:80fP00hQXJ002J003A6QX009X00A4J6QX0T@3J007R8b8R6R8S003[0:8
00>/S:`01J`00lc@[002[003S:b<00><00B/R:b/0X`3J006A6Q4A8QX1d@00bA4A008A08T00=492@0
4R@2A0PT00=492@02b@2A0TT00=492@02b@00d@T900:90E42b@5A003J4A400E400<TA2@00b@014@T
94@290=400EXA4@TA00I9003J4A400@T00=492@01R@014@TA2@2A09X1T@2J003A6QX009X0hP01FR8
J8Q4009X00>8S8`00Z`00hR/[002[005S:b/[8`00/`4d003c:b/00;@00?<d=001M0;[004S8R8S0B8
0X`018R/S8P2S0:800><[8`00j`2S0680H`001U40VPLA09X=D@4J004R6QX[0:800=XR8P00XP3[003
S8R800><0hP7J0:800=4R8P00fP4R009S8R8R6R8[8b/00><1FP01Zb8J4AXR0:<00R/S8b/lM2/S0:/
00?Ad<`01=000o7<d004d0:/0m02c007[=3@d<c@l@03d003dM3@00W@00SadM7edOGAd0;A00?@dM40
0_401M7alM3A00G@1J`00hc@d003[009d:b/[8b8[8b/00>800W<R:b/S:b<[<`00Z`01]3<d=3ed0;A
00?@lO400]401]3ad?7Al@;@00[<d=3Ac:c<dJc@0j`00hb/S002S005R8b/R8`00XP018b/d:`2R005
[8b<S6P00hP01XaXR:b8J0:800=XA6P016P2A09X0XP024AXA4AXA6Q40VP01DAXA4AX00A400=XA8P0
0fP01TAXJ8R<R09X0j`01Lb/c:b<00;@1j`01Hb/R:b<00:/00=XR8P00VP5A003J4AX00m400<TA4@0
12@01T@T94@TA1@T00A492@T0T@69003A2@T00DT00=492@01B@00d@T90049003A2A400hT14@<9005
A2A4A2@01T@290A40b@4A0<T14@00bA4A003909400<TA4@042@3A0LT24@01RA4A4AXA09X14@2J003
A6Q4009X18P00jb8R002R0:<00>/S:`01:`00hb/[003[003S<c<00G@0Z`3d005[<c@[=000Z`01=2/
d<`5[0><0hP018b8R:`4S006[8R<S:b<0Z`01/b/S8b/J0:/000CA00394A400940VP:A003J4A404I4
00=XR6P00VP6R004J8R<S0>80Z`3R005c8aXJ8P016P00haXJ002R003J8QX009X00B8[8QX0XP00haX
J002J0>80X`2R0AX00B8S8Q40VP01hb/[8b8S=001:`01HR/d:c<00:/0]001<b/[<`4[003d:b/00?<
00J/d=3@c=02[003d<c<00C@00?<d<`02]000o7@d002d0CA1]001<b/d<`6[003d:b/00F/00>8S:`0
0Z`01HR<[8b800b/00C<d<c@0/`4d003c=3<00?@00G<d:c<d002c003S:c@00>/0XP3S0>800EXR8R/
J002R007S8R8R6R8S003J0B80X`2R09X00>8A8P00VP018QXJ6P2A0AX0T@016Q4A4@2J005A6QXJ4@0
0VP2A09X00=4J6P00VP00dAXJ002R006S8R8S8R<1:`00hb/[002S0:/00><[8`00j`00hR/R002R0=X
00>8A4@00fP2A003J4A400e42R@00d@T900=9003A2@T00DT00I492@TJ4@3909400<TA2@04R@00d@T
900>9003A2A400940b@014@T92@2A00594A494@012@2A00394A400DT0T@3909400<TA4@00R@01T@T
94@TA1TT0d@690m40VP5A09X0T@01fR8R8R/R8`00hP2S0F/00G<[:b<c005[004d:c@c0_@0Z`01<b/
c<`6[003S:b/00:<1hP01Hb/S8R<00:800B<[:b<0j`018b/[8P1S00044@01BA4A4@T00Q400=XA4@0
14@00fQ4A002A003J4A400Y400<TA4@044@00bA4A00TA004J4AXJ0:800=XR6P018P2J006R6QXJ8R<
0fP01hQXJ8b8J4@00XP01Xb8S8QXA09X0hP3J003R4AX009X0XP01FQ4J6R800:<00>8[:`01HP2[005
J8R<[8`00Z`018b8[8`8[0:<00>/S:`01Z`01<b/[8`2c0F/0/`01Jc@d<b/00?<00?@[:`00Z`01Lc@
d=3<00W@00W<d=3@c=3<[<`01J`00m2/R00A[003d<c@00>/0/`00jc<[004c0>/00?<[:`00j`01Lb/
[<c@00V/00EXR6QXR003J003A6Q400=X0XP01VR8J6R8[0:800=XR8P00XP00hb8J005J003R6Q400EX
14@00fQ4A005A003J4AX00E400=XA6P016P4A09X00J8S8R8J4@2J004S:b<S0>/0h`2[0F<0Z`2R0EX
0d@2J0Q400@TA4A40b@3A0HT00I492A494@N90=400<TA2@08B@00d@T900990940R@2A0DT0d@012A4
92@5A0<T00=492@00R@2A08T00=494@00d@00bA4900=9005A2@T94@01B@4A0DT0T@29003A6QX00]4
0VP014AXJ6P4R003[8R800B800>/S:`00Z`2c0><00>/S:`00j`01Lb/c=2/00C@0/`00jc<d002d003
c:b/00B/00>8[:`01:`3R006[8R8R:b80Z`00hb8R002R0:<0Z`01Xb/[:b<[0:<000>A08T0d@00bA4
A00>A003J4A400m400<TA4@014@00bA4A005A00394A400E400<TA4@084@00fQ4A004J004R6R8J0:8
26P01dAXJ6R8J8P016P2R005J8R<R6P00T@3R0AX00A4R6Q416P01HQXJ4B8009X0XP00fR8R004R003
J8R<00><00B/S:b81Z`00hb/R002R003S:b800N/00><[:`01Z`01=3<c=0:[003c:b/00;<00>/c<`0
0j`00lb/[004[0;<00>/d:`01Z`01Hb/[:c<00:/00C<[:b<0Z`00hb/S003[0?<00S@[<c@c:c@c0>/
00?<[:`01:`2S0B/00><[:`01J`2R004J8QXJ0M400AXA4A416P7S0F800IXR8Q4J8P3J003R6QX009X
3D@2J0E40VP01DAXJ6Q4009X00E4J6QXR004S003R6R800:800N/S:b/S:b800:<00B/R8b80X`2R0:<
00B8S6R80fP01DAXA4AX00Y41R@014@T94@99003A2@T01dT0T@29004A2@T90941R@2A00394@T0094
72@00d@TA00790941R@3A0@T14@01bA4A4@TA2@00d@290941B@00d@T90059003A2@T00DT00=492@0
0d@690U400=XA4@01D@4J003A8QX009X00><[8`00hP018b8S8`6[004R8b<S0B/00?<[<`00Z`2d003
c=3@00>/0]02c0:/00B<[8b<0Z`01Hb/R8R/00:800><R8`00j`018R<S:`2S0:/00B<[8b<1j`1R000
54@00bA4A00mA00394A400e400<TA4@03D@7J004A6Q4A0QX00>8A4@00VP3R003[8QX009X00>8S6P0
0fP00haXJ004J005A6Q4J8P02FP00hQXR002R09X00>8J6P00XP00hb8J004[007S:b/S:b<d002[0:8
00B<[8b80X`01XR/[8b/S0N/00C<d<b/0]02[0:<0Z`00hc<c002[009S:c<S<b8S:b<00:/00><c<`0
2Z`00lb/[002[003S:b/00>/00>8S8`00Z`2R005[8R/[8`00/`3[003c:c@00><00V/d8b/d:c@c=00
0j`01hb/[:b<d8`00j`00ha4A002J0Y400=XA6P00fP4R00:S6QX[8QXR6R<J0:800AXR8QX0XP3J003
A6Q400U400AXA6QX3d@2J0:800R<[:b<[6R8[0:<00>/S8`00j`018b/[:`2R007[8b<R:b<J005R004
J4A4J09400>8A4@02D@390E41B@01D@T92A400DT00=492@00R@2A18T0d@00bA4A00>9003A2@T00hT
0T@29003A2@T00DT00A494A41R@00d@TA005A0<T14@39004A6Q4A08T1D@69003A2@T00LT00=492@0
12@00d@T900490A400<TA4@00T@290=400<TA4@034@3J0:80fP2R005J8R8R8`00XP01Jb8[8b800:/
00=XR8`02J`00lc@d003d004[=3<d0:/00G<[8b<R002S007[8R8[8R<R003S003R:b<00F/00><[:`0
2J`00hR/S001S0005T@00fQ4A00:A00394A401A400<TA4@05T@00bA4A002A00394A400a40R@5A0UX
00>8J6P00VP2A004J4AXJ0940VP00dAXJ002J003A6R800>80VP01DAXR6R800EX0XP00hb8J002A0AX
0d@00fR8J002J004A6QXR0=X00N8J6R8S<b<00:80j`00hb/[002S0:/00F<[:b<[006R0R/00?<[:`0
0Z`00lb/[003[003S:b<00:/00?<[:`01Z`4S0:82j`02<b/[:b<c8b81j`00hb/[003S005[8R/[8P0
2:`01Hb/[:c<00:/0/`00m2/[003[003c:c<00>/0hP6J003A6Q400I400=XA4@00fP00hb8J002R005
J8R8S6P018P00jaXR002R003S8R800EX0T@00fQ4A004A005R6Q4A6P00d@3J0I400AXA6QX1HP016R<
S8P3S0f/0h`00jb8[003S003R6QX00=40VP00dB8J008A00694A4A2A40R@2A08T0T@R9003A2@T0094
0R@00d@T900A9003A2@T00DT00=494@00d@39003A2@T00@T14@39005A2@TA2@01T@390A412@4A0@T
00=494@03R@2A0dT14@290A400<TA4@044@2J005A8R8R4@00fP4R004S:b/R0:<00J/S:b<[8P8[004
S:c<[0;<0j`01<b/d:`5S003[8b800><00B8S8b/0X`01XR<[:c<[0:<0Z`00hS@[004[0;<0X`00jb<
[001[0006d@016Q4A2@4A00394A402A400<TA4@08T@00fQ4A003J0=400=XR6P00fP02HQ4A6Q4J8QX
A004J003R6R8009X0d@7J0:80fP2R003S6Q400Q40fP2A0AX0XP00fR8J002R0:<0j`2S0>/00><R:`0
1Z`00hR/[002R003S:b<012/00N<[8b/S:b<00:/00><[:`01:`00hR<R003R0F/00C<J6R<1J`018b/
S:`2d0F/0XP00jaXR003R003[8b<00>/00B<R:b<0hP2[004S:b8S0J/00Z8[:b/S:b<J4AX0T@4J0e4
00=XA8P00XP018b8R8`4R008J8QXR6R8S:`2S003R6QX00EX14@3J004R4AXA09X0d@3J0A400=XA6P0
0XP018b8R8P4S004R8b<S0N/00><R8`00X`00hR<S002S006R6R/R8aX24@00fQ4A00>A0DT0T@69094
6R@3A0@T00=492@022@00d@T900:9004A2@T90=400<TA4@01b@00d@T90029004A2@T90i412@4A003
94A400TT00=492@02b@2A0hT0T@791I400=XA6P00T@01hQXR8R<R:`00h`4[003S:b<00R/00F<[<b/
d002c0:/00C<d<c<1J`00hR<[002S0>/0X`2[0;<00F/c:c@c003[0:<00C<dLc<0Z`00hb/[005[000
:d@00bA4A009A00394A403U40VP00hQXA005J003A6QX00A400=XA6P00d@2J09416P00dAXJ003J003
R4AX00EX3d@00fQ4J002J003A8R800:<00F/S8b8S003[0:800><[8`00XP7[003c:b/00>/00B<[:b<
3:`01<b/[:`2S0:/00><[8P00XP2[003S:b/00:/0X`00jb<[003S0:/0h`00jc<[003S003R:b/00;<
00><[:`00j`028R/R8R/R6R<0XP2S006[8b8[8R<0XP2[003R8b800:<00B8S:b/0X`3[006S:aXJ8QX
0T@2J0e416P00dB8R003R004S8R8J0:800><R8P018`00hR/R002J003A6QX009X1D@00fQ4A003A0AX
0d@016Q4A4@4J003R8b800:<00=XR:`00X`2R006[8b/[8b80j`00hb8R005R003S8R<00:800><R6P0
1T@00bA4A006A09X14@290E412@00d@T90049004A2A4A1LT00=492@032@2A00394@T00HT00=492@0
0R@2A0<T00A492A40R@014@T92@3A00394@T00=40R@6A00394A400Y412@00d@T900J9003A2@T00HT
00=492@01b@>A09X14@2J0E400AXA6QX0X`3R0><4J`01Hb/[:c<00F/00C<[=3<0j`018QX[<`3[003
S:c<00B/00K@[<c<[<`4[005d<b/[8P00X`3[07<0J`1[0001D@00fQ4A00bA00394A402M40b@3A003
94A400A400=XA4@00VP2A004J8QXA09X00=4J6P014@00fR8J005A09X00N8J6Q4J4AX009400QXA4A4
J8QXR0m400AXA6Q40VP01XQXR8R<[0:<0Z`01/b/[:b<c0F/00?<d:`00Z`01XR/[8b/S0:800B<[:b<
0j`01Lb/[:b<00B/0XP4S003R8b<00F800><[:`00j`01hb8S:b8S:`00X`2[003S:b/00J/00?<[8`0
0Z`4S0:80h`00hR<[002S003R8b/00:/0X`00fR8S002[006S:b/c8b/0X`00jb<[002[005S:b<R6P0
3T@016Q4A4@2J003R6R800AX0hP2J004R8b<R0>/0X`2[0:816P3A003J4A4009X00A4J6QX0d@016R8
A6P5A003J8QX00B800N/S6R8J8R<00R818`018R<S:`6R003J4A4009X3T@012A4A6P3A0<T14@390E4
12@3A0@T0T@F9003A2@T00HT00=492@02R@2A00394AX00@T0d@290=40R@01D@T94@T00]400<TA4@0
0T@012A4A4@99003A2@T00XT00=492@01R@2A0DT00=492@00b@2A00394@T00/T0T@00bA4A006A09X
0d@00fQ4J004A09X00>8J6P00hP00hb8R002S003[8b<00:/00><[:`02J`01Hb/[:c<00F/00?@[<`0
0/`2[0B<1j`01/b/[=2/c0F/00S<d<c<[8b/S0:/00B<[:b/0H`005Q400=XA4@05T@01FQ4J6Q400=X
0X`00hR/J002J0A400=XA4@01D@4J0E400F8A6Q4J002A09X1d@00fQ4A003A003J4A400=400AXA6QX
0XP2J008R=2/[8S<dM04[0;@1:`00lb/[002S003R8b/00:800F<J8R8S002R008[8c<[8b8[8`7[003
R8b/00:800>/R8P00hP2S0>/0XP04Zb8[:b<[8b/S:b<[8b/c:b<R0:/00><[:`00hP2S004J8R/S0B/
00><J:`01:`00hb/S002[003S:b/00>/00J<[:c@[8`2[005S:b/[6P054@2J0V800><R8P00X`5[005
d:b/S8P016P2A09X0T@3J007R6QXJ4AXS002J0E400UXR8R<R8aXR:`00XP01jb<R8b/S:`00X`018QX
R8`2R007S8R8R6R8S003R003J4A400i400=XA4@00T@00fQ4A002A00594@T94@00b@5A0@T0T@79003
A2@T00hT00=492@00b@2A0@T0T@00bA4900290=412@3A00494A4A0DT0T@290=400@TA2@T1T@290A4
12@2A00394A400945B@2A0LT0d@59003A2@T008T0T@99003A2@T008T0T@39003A6Q400A400QXA6Q4
J8Q4J0A400=XR8P00fP028R<R:b<R:b<0Z`3S005c:b/[<`02Z`00hc@[002[008d:c<c:c<[<`3[005
S:b/[<`01Z`01Lb/[:c@00:/00O<[:c@c:b800B/00><[:`00Z`001M400DTA4A4900TA08T44@00hQX
A00;A00394A400E400<TA4@01d@00fR8J002J005A8R8[8P00X`3R003J4A400A400=XA4@00T@2J004
R6QXA09X00B8J6QX0d@2J003A6Q4009400=XA4@03D@5R0:<00>/c8`00Z`2c006[=3@[=3A0/`2[003
d:b/00:<00F8S:b/S003R0:<0hP01Xb8[8b8[0:<1j`2S0:/0h`3R004S:b/[0:800B<[8R80Z`018b/
R6P2R003[8R<00B<00>/S:`018`018QXJ6P2R006S:b/[8R/0X`4[005R8b/S:`00X`9[005S:c<d:`0
0XP8A00394A400=400<TA4@00T@00fQ4A003J0>800B<R8R/0X`01Jb<[:b800>/00C@[8b/18P016Q4
A6P3A09X00=4R6P00T@2J006R6QXR4AX0T@3J004R6R8R0:/0h`2R0:/00B<R8R80VP4R004S8R<R0QX
1D@01BA4A4@T01540R@00d@TA00M9003A2@T00HT0d@79003A2@T00940b@2A0@T00=492@00R@2A0TT
00=492@00b@6A0@T00=492@0;2@00d@T900H9003A2@T008T0T@012A4A4@2J0A40VP014AXJ6P3R0=X
0XP01Hb/R8b800:<00>8S8P00X`00lb/[004[009S:b/S:c<[<b<00:/00C<[=3<0Z`00lb/[007[003
c:c<00B/00N<[:b/c:c<00:/00G<d<b<R002[003d:b<00><0J`001=400<TA4@0G4@01VR8J6Q4J0><
00>/R8P00VP00hQXA007A09X00E4J6R8J002A09X2D@2J1A400>8S8`00Z`00hc<d002[004S:b/[0;@
0j`00m3<c004d004c:b<S0:/00C<[8b80h`02:b<R:b<[8b80Z`01<b/[8`5[003S:b/00:/0X`00hR<
S002S0:800B/S:b<0Z`018R/R6P6R0:<00>8S8`00Z`00hb8R005R0><0Z`2S0:/00B<[:b/0X`00lb/
[008[003c:b/00>/00C@[8R83D@012A4A2@2A0EX00>8S8P00hP5[003c:b/00F/0X`3[0:<00B8J6Q4
16P3A003J4A400AX00=4J6P00VP2A003J8R800:80h`01Jb<[8b800:<0hP018b8R8P2J003R8b800:/
1HP2J0:800AXA4AX14@00bA4A002A09X2D@990=42b@2A0@T0d@00bA4A00390941R@2A0@T14@290A4
3B@2A00394@T00@T0T@590941B@2A0HT00=492@01b@00d@T900>90943B@00d@T900F9003A2@T008T
0d@290A40fP00dAXJ002R0IX00B8J8R80X`2R0><00>8S:`00X`00hR/S007[003c:b/00N/0X`2[0?<
1J`00hb/[007[003S:b/00F/00><c=002J`2S06/000GA00394A4009400<TA2@04D@00bA4A00;A003
94A400=400<TA4@04T@00fQ4A00GA0EX0XP2S0AX00F8J8R8J006A0EX0T@00fQ4A004A0=X0d@4J0e4
00EXA6R8J002R003S:b/00V/00?<d:`00j`00lb/d002[0;<1:`00lc@[002R0:/00B<[:b<0Z`00hR<
[005[003S:b/00:/00?<[:`01Z`01Hb/R:b<00:/00>8[:`00Z`2R003S:aX00:818`00hR/S004S004
R8b<R09X00F8S:b/c003[0:80Z`00hb/S002[003S=2/00n/00B8J4A40R@6A08T1d@3J004R6QXJ0:8
00F<d=3@c005d004[=3@d0:/0h`2R0=X00A4J6QX14@2J003A6R8009X00I4J6R8A6P3R003S8R/00F/
0X`4R0><00F8S6R8J002R004S:b/[0:800><R8P00VP00hQXA002A003J4@T008T3d@49003A2@T008T
1D@C90=40b@3A0<T0T@00bA4A00390U42b@3A08T00=492@012@00d@T900490945R@00d@T900C9003
A2@T028T00=492@00T@290I400=XR4@00fP018QXJ8P5J0:800B/R8R80X`018QXS8`2R0:<0Z`2S003
R:b<00>/00><[:`03:`00lb/[008[003S:b<00:/00B<[=3<0Z`00hb/[003c005[=3@d<`01J`004i4
00=XA6P00VP3A005J8QXR6P064@01fR8S8R<R6P00XP01VR8R6R<R0:/00=XA6P00VP2A008R6QXJ8QX
A6P4A0EX00M4J6QXA6Q4009X2T@026R8J8R/S:aX0j`2S0N/0]05[0:<0j`00m6/[002[004c=2/R0:<
00C@S8c<0j`018R<[8`3[003c:b/00>/00G<[:b/S004[004S<b/J0R/00><[:`00Z`018R<R8`2[003
R:b800B/00>8S8P00VP2S0:/00F8S:b/c006[003S:c<00:/00B<[:b<2:`01Xb/[:b<R0Y400<TA4@0
1T@7J003R:b/00:/1M02c0C@0j`3S006R6R8R6Q40VP2A005J4A4J4@00hP3J004A8QXJ0:/0X`00hR/
S002[00:S8R/S8R<R:b8S0>80X`2R0:<1Z`01Xb8J6R8J0I400<TA4@03d@49003A2A400940VP2A0<T
00E492@TA0069003A2@T008T0d@390M400<TA4@00T@3909400@TA4@T0d@2909400<TA2@00T@29003
A2@T010T00=X92@052@01D@TA2A4010T00=492@012@00d@T900790940b@2A0HT00=492@01B@00d@T
900490M400=XA4@01FP018aXJ6P2A0:800><[6P00hP00hb8S002S003R:b800:/00B<R8b<0j`3S006
[8b/[8c<0j`3c0:/00O<d:b/S:c<00F/00><d8`00Z`2d0J/0/`3[003c:b/00B/000NA08T3d@29003
A2A401U400AXA6Q40fP2A0IX34@2J0I400IXA4AXR6P2R09X0XP2J004S6R8J0:81VP00dB8J002A003
J4A400=400=XA4@00d@00fQ4A00=A0=X00B8J8R80Z`2S0R/00G<S:b/c002d0F/00N<R8c<[8b/00:<
00B8[:b/0h`01Zb<[:b<[0:<00>/S:`00Z`00lb/c002[009c=2/d:c@c:c<00:/00F<[<b/S002[003
c:b/00J/00><[8`00X`3[003S:b<00:/00J8[8b<[8P2[0;<00B<R:c<1J`00lb/S002[0><00B/S:b<
0j`00lb/[002R005S:b/R6P00d@00bA4A004A0<T00=494@00d@016Q4A4@3J0B<00?<d:`01=001<c@
d:`3d003[8R<00>800><R8P014@016R8A4@3J0:80fP00dB8R005R0:<00B8[8b/0XP4S003[8R800:8
00=XR8P00XP7[0F<00>8J6P00VP8A003J4@T00I400=XA4@00T@59003J4B800:800=XA4@00R@00d@T
A003A0DT00A492@T0T@590M400@TA4@T0T@59003A2@T00@T0T@00bA4A0029003A2@T01PT00=492@0
42@3A0@T00=492@03R@00d@TA0079003A2@T00940b@2A1DT0d@2J0I400=XR6P00VP00dAXJ002J0J8
00AXR8R81:`4S005[8R<S:`00X`00hR<S002[004S:b/d0N/0/`3[009S:b/[8b/S:b<00B/0]05[004
c=3@d0:/00?<[:`01:`0031400<TA4@03T@00bA4A003A003J4A400=416P2R0EX0hP2J09400=XA4@0
1D@2J003A6Q4009400AXA6QX0T@:J0:800>/R8P00VP01HQXJ6Q400=X0d@00fQ4A00:A004J4A4J0M4
00=XA6P00hP00hb/[006[0;@0Z`01/c@c:c@c0:/00?<d8`00X`3[003c:b/00V/00F<[:b/S002[003
d:b800:/00G<[:b/c006[005R:b/S<`01:`2S0;<0Z`00lb/[002[003c:b/00:/00J<[:b<[8`2[003
S:b/00>/00B<R:c<0Z`02<b<c:b<[<b<0Z`00lb/c003S0:/0X`3[003S:b/00B/0X`01HR/[:b800M4
00=XA2@00T@290A416P2A004J8R<S0>/00G<[=2/d002c0>/0/`00jb<[004R003S:b8009X00A4J6R8
1VP02XQXJ6Q4J8R<[8P2J006R:b8R8b80VP00hb8R002S003R8b<00B800B<R:b/0]001<b/S8`3R003
J8QX00AX0d@2J003A6Q400=X0T@016Q4A6P4A0<T0T@4R005S8QXJ4@00R@3A003R6Q400<T14@00bA4
A00290=400=XA4@01d@29004A2@TA0`T00=492@00T@Q9003A2@T00<T00=492@014@29003A2@T03DT
14@290]400AXR8QX14@01FQ4J8QX00J80h`01:b8R8`3R008S8R8S8R<R8`2R0N/0X`4[003d:b/00N/
00F<[8b/c002[0?<00F/c<c@c003d0F/00>8S8`00L`001Q400<TA4@00d@00bA4A00KA09X2T@5J006
S8R<R:c@0Z`4R00@c:b8R6R8S8Q4J8R<R6R8[0:80VP3R003S8QX009X0hP01hb8R8QXR8`00XP016R<
R8P3J003R6QX00=X00E4J6R8A003J004A6Q4A09X00=4J6P02T@3J008R:b/[8c@[8`2[003c:c@00:/
00C@[<c<1:`00lc@[004[003c:b<00:<0Z`01=2/[:`2S0:/0X`02Zb8[=3<[8b8d:`2S0>/00?@[8`0
0XP00jc@[004[003d:b800:<00>/S:`00X`2[003S:b<00F<1Z`01Xb/[8b/S0:/00><[:`00X`018R<
S8`:[0><1J`3d004[<b/c0>/0hP00fQ4A003A003J4A400U40VP01DB8R4AX00:800J/R8R<c:`2c005
d:b/[=000Z`2c0:/0X`2R004J8R8R09X00J8J8QXR6P5R003J8R800:800F<[8b<[004S003R8b800><
38P02hb/[<b/S8R/R:b800:<0hP01fR8J8R<R8`00XP2S0>800=XR8P01FP024@T94AXR:b<0XP2[0:8
00=XA4@00d@2J0<T1T@00bA4A003A09X24@39003A2@T00942b@00d@T900[9004A2A4A0/T0T@59094
1b@00d@T90049003A2@T01@T00=494@01D@290M40VP00dB8R003J0E40VP2R00;J4A4J8b8[8b8S8P0
0Z`01HR<S8R/00:80X`3[003R8b<00B/00B<[:c<0Z`01M2/c:b<00>/0X`01:b<[=02c004d:b/c0:/
00C<[=3<0Z`01<b/[:`2S06/0H`002Q400=XA4@00d@00bA4A00<A09X0d@00fQ4A002A0=X0XP00fR8
S003[004d<c@[0:800F/c8R<R004S09X00F/c:b8S002[004S:b/S0:80Z`2R008S8R8J8R/J8P2S004
[8b8R0><0hP2J0:80VP2A003R:aX009X0XP00fQ4A002R007A6R8A6Q4J004A003R4AX009X00>8[:`0
0hP3S004c8b<c0:/00><[:`00j`2S0:/0XP01hb/[:b8[8`00Z`00hb/[004[0>80h`02Jc<[:b<R=3<
[002S003[<c<00:/0X`03Lb/S:b<[<c@[8b/S:`00h`5[0:800F/J8R/S009[008S:b/S:b<[8`4R0:<
0j`00hb/[002[0:<2:`2d003c=3<00;@00B/S8R80fP3A0=X2d@2J0:800EXR8R8S003R0>/00K@c:c<
[=03[003c:b/00>/1hP3S00:J8R<R8b/R:b8[0F<00F/R8b<R007[003S8QX00=X0XP00fR8R004R003
[=3<00N/00?<[:`00j`00lb/c004[003d:b/00:/0X`01jb8S6R<R6P00R@01TAXR:b8[0:<0Z`2R09X
00=4J8P00T@39004J4A4J0940fP01dAXA4AXA6P01T@39004A2@T90A41b@2A0dT00=492@03R@00d@T
A00D909400<TA2@00R@3A08T00=492@00d@59003A2A400TT00=492@022@00d@TA0049004A2@TA08T
00=494@01d@00fQ4J002A0=X00A4J6QX0T@3J00<R4A4J8b8[8R/R6R80X`01:b<[8P6[0:<00B8[:c@
0Z`00hb/[002[005d:c<[<`01:`00lb/R003[003c:b/00B/00C<[:b<1j`00lb<S002R0008D@00bA4
A006A00394A400A400<TA4@01d@016R8J6P3A0EX0hP018b8S8P2[004d:c@c0:/00N<[:c@S:b<00:/
00R<[8b8S:c@S0B/00><[8P01J`00hR<[002R0:<00F8S8R/S002[0>800Z/S8R8J8QXR6R80VP00hR/
R002J003R8b800940XP4J003A6Q400A400>8J6P00XP01Xb/R8QXR0><00N/S:b/S:b800N/18`01Jb<
[8b/00:800B<[:b/0X`00hR/S003R0:<00>8[:`00X`01:b8[=03S004R8b/d0>/00>8[=002:`01Hb/
[8b/00:<0j`01HR<S6R800:/00J8S8b<[8`4[003d<b/00><00F/R8R8S006[003R:b/00B<00>/S:`0
0Z`00hb/[002[003S:b<00:<18P2J003A6QX00AX00E4J4A4J004A004J4AXJ0F800J<[8R8S:`3d003
[<b/00B/00[<[:b/S:b<[8R<0XP00fR8S002R004S8R/S0>/00><[8P00h`018R<S:`4R0:<00>/R8P0
0XP00fR8J007J0:800>/d=000/`00m3<c005d004c=3@c0G@00?<[=400]004Zc<[8b/R:b8[8aX94@T
J8R/c0:/00C<[:b816P00hQXJ007A003R6Q400EX00=4J6P00VP4A0/T0T@69094<b@014@T94@29003
A2@T00HT00=494@00d@99003A2@T00/T00A492@T0T@00bA4900290941B@4A0<T2T@5J0A40VP00dAX
J003S0:/00n8J6QXR8b/S8QXS:b<[8`00XP2S003[<b/00:<1J`00hb/[003[004c:b/[0:80Z`00lb<
[007[007d:b/d<b/c002S003[8R80068000[A00494A490U400=XA6P00VP8R0:/00C<[:c@1:`00lc@
[003d003dM3@00;@00F/c<b/c008[003c:b/00>/00B<[:b<0j`3S008[8R<[8R<[8P2[0J<00N8S8R8
S6R8009X00>8[8`01HP3J0>80VP014AXJ6P2R00:J8QXS8R<R:b8S0:800F<[:b/c003[0?<0Z`01M3<
[:b<00J/00B<R8R/1H`2[003S:b800:<0hP02jb<S:b<R6R8S:b<00:800><[:`00X`00jc<c003[006
S:b/[<c@2:`00m2/S002S003R:b/00:/00B8[:b<1:`00m3<[002R004[8b<R0F/00B<[:b80X`01XR/
R8b8[0:<0XP2S00:[8b8[8R<R8aXS0F80fP3R09X1d@2J0:800?<[<`00j`00m2/[004d003[=2<00V/
00F<[8b/S003R004S:b/S0>/00><[:`02:`2S004[8b8R0:<0XP018b/J8P4S006J4AXJ8QX0XP00jc<
d002d007c=3@dOGAl@02d@03lM3A00;@00?adM000]02d@?@0j`4R0940b@014B<c=02c0>/0hP00fR8
J002J003A6QX00A416P5R003J8QX009400=XA2@02b@2A1TT00=492@00R@00d@T900A90A41B@00d@T
900Z90E40b@5A0<T00=494@01B@6A09X00A4J6QX2T@2J0:<1hP00fR8S004R0:<00B8S8b<1:`2S003
[8b/00>/00><[:`01J`2S003J8R<00F/00><[:`00j`01=3<d<`4[004S:b8S068000@A00394@T00Y4
00<TA4@00R@3A00394AX00e400IXA4AXR6P4R0F/00><[=401M001<b/d<`4d005dO7adOD00]000m7@
d003d005[=3@[<`00]02[0;<00S@c=2/S=2/S0:/0h`01/b/[:b<c0N/0X`2R0>/00B8J8R80X`00jb8
R003R09X00F/R8b8J005R005S8QXR8`00Z`2S0F/00C@[:c<0m000lcAd@04d0V/00F8J8R/R002[0:<
0Z`00hb/S002[008R:b<S6R<R6P2R008S8R8S:b8S:`2S0:/00><[:`00]02[005c:cA[<`01J`3S006
R:b/R8b/0X`2[006S:b/[<c@1:`2R006S8R8R:b<1:`02Lcac8b/R8b8[002S003[8R<00:<0XP00jb8
J002J004R8b8S0>80X`01:b<R:`2S003R4A400=40VP3R0B/1M001<c@d?42d0;<1J`018b/c8`3[0F<
1J`02Hb/c<b/d:c@[002c0:/00B<[:b/0X`00jb<S002R0B<0j`01HQXJ8R<00>800B/d=3A1M02m@06
lOGemO7A0]001=7alM45d0>/00><R8P00VP3A00594@TA:`01=000hb/S002[003S8R800=X00E4J6Q4
J002A0AX0XP00hb8R003J09400=XA4@00T@39003A2@T01DT00A492A44R@00d@TA00690E40b@00d@T
9004909422@00d@TA0079003A2@T01@T0d@490A400@TA2A40R@2A0@T1T@3J09400=XA4@01D@016Q4
A6P2R003S8QX00:80h`018R/S8P2S003R:b<00>800J<[:b8S:`2S007c8b/[<b/S006[003S:aX00:<
1J`00hb/S002[003c=3@00;<0j`00hb/S002R054000BA00394A400=40R@4A00394A400A400<TA6P0
14@00bA4900:A0=X0hP00jb<S002[0:<0]02d@03d=7@00K@00_<dO7edO7@dO7ed@05l@;@00C<d=2/
2=000m7<d002[004c=7@c0?@00Ged=7@l@04d003lM3@00:/00GAd8b8S002R004S:b8[0><0XP01:b8
[8`4R007S8R8R6R8[003d006[<camM3A1=04d@;a00CelM3@1J`018c<c<`7[005S:b/[8`00j`01Hb/
S:b<00>80VP3R0><00B8S:c<0Z`01/b/[:c@d@;<0Z`01m2/c<c@dJ`00X`2[003S:b/00:/00B<[:b<
0j`03/c@d=3<d<c@[8b/S8R<1j`02<b/R8b8S8R<0XP00hb8S002R0AX14@00hR<[003R004J8R<[0:<
0hP4J003R6R800><0Z`7d0:/0m001<c@c=02[007d8b<c=2/d002[003c:b/00F/00><[8`00Z`02M3<
d<c@c=2/d007[005S:b<S8P01J`00m3<[007[003d?7e00?e00?Ad?401_D00o7ed003d007dM3@dM2/
d004[004R6QXJ09400XTA4A4J8R/c:c@1J`2S0IX00=4J4@00T@4J0:800B<R6R80VP2A004J4@TA0<T
0d@290944R@2A08T00A492A41R@00d@T9005909400<TA2@012@2A0dT00A492A49B@3A00394A400HT
00=494@00T@29003A2@T00<T1d@00fQ4J003J0M40VP014AXR6P4R0:<28P02jb<S8R/R:b<[8b800:<
00K<[8b<[8`2[005c:b/[<`00Z`00hR<S002[006S:b/S8R<0Z`3c005[<b/[8`00Z`00hb/R001J000
6D@00bA4A00:A00394A400Q400<TA4@01d@2J004S:b/S0>/00><[=000]44l@;@1=400m3Am@02l@06
mM3elOGa1OD01?7@dO43d@03d?7A00;A0o402]3AlM3AmM7ad?43m@;a00KedM7elM46d006c:b/R:b8
0X`2[007S:b/S<c@S002[003R8b<00J800O<d?7Ac?7A00Ge00?amOD01oD2l@;@0]402=3ad=3edM3a
0]000oG@[002[0?@00C<[=3<1:`2R00<J8R<[<b/R:b<d:c<0]000o7@d002d00:dO7<dO7AmM7@l@;A
0Z`2c003[<cA00;<00N/c=3@dM3<00;@0/`00m3Ad003d0;<0Z`2d009[=2/c=2/d:b<00:800EXR8QX
R002J0:800YXA4A4J4AXA8QX0XP00fQ4J002S0:/0fP01HQXR8R<00>800N/c:c@c=3A00;a00C@c=6/
0]001Jc<d<ca00;<00b/S8b<[<b/c:c<[<`:[004d:c@d0:/00?<[:`00l`01jb<[:b<[8`01J`01<c@
d?D3d007dOG@d<cAl@07m@04dOGel@?e00?ilOD00]401?GAdO42d004[=3@d0>/00=XA2@00R@2A003
J8b800R/00C<[8R/0XP3J004R4A4J09400AXA6QX1XP2J09400=XA4@00b@3A00394@T00944b@4A0@T
00=492@00R@00d@T900@9003A2@T00@T0T@012A494@Q9003A2@T008T00=492@01T@790=432@6A0AX
0T@012A4A4@3J00?A6R8J8R<R6R<R:b8J8R<00>800><[8`00X`3R005S8R8S:`00h`018R<[8P5[003
d:b/00:/0h`4[004S8R/c0:/00?<[=001:`2S0680J`1S00044@00bA4A006A08T00=494@034@00bA4
A00>A003J:b/00:/00>8[:`00Z`2c0;@00?adO400o44d@04d?7em@;a00CelOGa1OD00o7Am@02d@03
lM7A00?e0]400oGAd@03m@03lM7e00[e1?401?G@d=02c00:[8b/[8R<[8b/c0>/00C<[:c<0Z`00hb/
S002R004J:b/[0;@4oD00oWem@0Am@04lOGel@;e00CAmM7a0]001=7@c=02[004dLcad@;@00?edL`0
0]02m@04lOG@l@?e0_400oGam@04m@;a0m001=7emM42l@07d?7elOGAl@02d@04mO7Am@;A1]000lcA
l@02d@03mM3@00:/00IXA6Q4J4@4J0A41FP00dB8J003J006R:b/[8aX0X`016R<R8P2S0:/00C@c=3A
0]000m7<c003[009d<c@[=3Ad:c@00>/0/`2[003d:c@00F/00><[<`00Z`01<c@[=02c0f/0X`2[003
c:c@00;@00G<d=3@d@02m@03d=7@00?e00?jnOD00_D01?7elO42m@04nOGal@?A00O@lOGAd<b/00;@
00CA[8b80VP7A0:80h`2[004R8b/S0B800A4J6R80d@01VQ4J6Q4S0:800><R8`00XP3J09412@3A40T
0d@S90941b@3A00394@T008T00=492@014@39004A2A4A0HT1T@2J0E400EXA4AXA002J0:800N<R6R8
J8R<00F800B<J8b/0h`2R004S8R8S0:/00F<[8b<R002[003d<c@00:/00?@[:`01j`2c0V/00K<[:b/
S:`2S05X000DA00394A400M40R@LA0:/00B<R6R80j`00lb<[002d004dO7al@?e0o42d@;a00?AlO40
3?D01O7emO7e00?a00?elOD00oD00o7Am@08m@03lOGe00?a0m001<b/[<`2[0:<00B/d:c@0j`2c003
d<c<00J/0X`01Jc@d?GA00Oe0oT2m@05nOGinOD00oT01O[inOWe00;i00?enOT01?D00oWem@0Im@03
lOGe03[e00CamO7@0XP3A003J4AX00940VP9A0EX0XP018b/c:`3R009S8R8S:c@c=2/00?@00B/c<b/
0X`3[004c:c@[0?@00?<d=000m000lc@d003d0:/00B8[:c<1:`01/c@[:c@S0J/00G<[:b/S002[003
c=3@00G@0]42d004lOG@l@?e00Cin_[i2?D01?WemOD2l@04mO7em@;A00?@[=000]000lb/J002J003
A6QX00AX00>8S8`01:`00hR<[002S003R8b<00AX00A4J6QX1HP01Hb/S8R<00:/0fP00d@T900390E4
6B@00d@T90089003A2@T01<T00=492@012@00d@T90059003A2@T01PT0T@00bA4900290E41B@4A0LT
00=492@012@014@T92@3A09X14@00fQ4A002A003J8QX00=X1XP2J004R8b<R0:<00B/S8b<0Z`018b/
[8`3[007S:b<[8b/d002c003[<b/00>/00><[8`01:`02Hb/[<c@[<b/R006[003S:b/00:/000:A003
94A401=400<TA4@00T@00bA4A00;A00394A400I40VP018QXR8`4[004S<c@d0;A0o44m@04lM7Ad@;e
0_4:m@04lOGam@Sa1?D00o7em@0;m@04lM7Ad0;<0Z`2c0n/00C@[:b<0Z`00lb/[003[0;@2OD2n@03
mOWi00?e00CimOWj0oT00oGin@03n@;e00SimOWenO[im@;i00?enOD06OD00oWen@03m@03nOGi01;e
00?imOD06?D2l@03[8QX009400=XA4@034@026Q4A6R8J8R<1:`2c005[8R<[8`00j`01<cAd<`6[00;
S:b<[8R/S=2/d:`01m000lc@d003d006c=2/d:c@0/`01:c<[<`2[0;<00>/d:`01]02c0:/00?@[=00
0]001<c@d=42d006dM3@dM3a0_D2n@ge00?adO400_D01_7Ad=2/c0?@0Z`00hQXJ002A005J8QXS<`0
1J`00m2/S003[004R:b8S0B800MXR:b8S8R<00:/00><[8`018`3R003J4@T01/T0T@99004A2@T9094
00@TA4A41R@00d@T900390942b@014@TA4@P9003A2@T00@T00=492@01b@2A0LT0T@990A400>8J4@0
0d@2J0940VP3R09X0hP3S0B800B<R8b<0Z`00lb/[006[006c:b8[8R/0X`6[003c:b/00:/00B8S8b/
0X`3[006c:c<[8b/0/`2[0:<1:`003a40fP018R/[8P4[0;<00?ad=400_401OGAmOGa00;e00?AlO40
0_D2l@Oe00CamOGe0_42m@03lOGa00Se00?amOD02OD01?7ed=43d0B/00C<[:c<2Z`2d0;<00B/c:c<
1J`2d003lOGe00Ke1_T00oGim@03n@06n_GenOGi0_D2n@03mOWi00?i00KenOGin_D2n@03mOWe01Ce
00KimOWjmOT2m@03nOGe00Ge00?imOD01_D01_WenOWen@;e00KimOWimOT7m@03nOGe00Ge00OimO7a
dJaX009400=XA4@02T@00fQ4R002A003J8QX00:800><[8`00Z`01=2/J8`3[0;<1=03R0>/00>8[6P0
0X`00hR<c002[0;@00?<dM001M402=3Ad=2/d<c@0/`00jc<[002[003lJc@00?@00?Ad?D01]000lc@
d002d004lM7<c0C@00?Ad?D00]000o7@m@02m@03n_Ge00Se00OimO7edO7e00?a00F/S=3<d002[0:<
16P01dAXJ8R/d<`00X`02Jc@d:b8c8b/S002R0:<0XP2J007R6R/R8b8S002[005c:b<S8P00Z`3R003
A2@T00XT00=492@012@2A08T00=492@00R@2J0DT00=492@01R@5A0<T0T@890941b@014@T92@3A0DT
0d@590943R@00d@T900490942R@2A00394A400940R@5A0<T1D@00fQ4A002J0M40VP00hQXR006R003
S8R800:<00F8S:b8S003[007d:b/[8b/c004[006R8b/[6R80j`018b/c=04[007R6R<S:b<[003S0>/
00><[:`01:`00hb/c002[000;4@00bA49004A00394A400I40fP00jb<R002[0C<0m02d@04lM7Al@Ce
0_4<m@03lOGe00;a2_D2l@;A1_D00o7em@03m@04dO7ad@?@00B/S:c@0/`4d0N/00C<d=3<0Z`00m2/
S003[003R8b<00;@1_D00oWen@02m@Ci00GenOWinP03n@Ce00CjmOGi1?D00oWjn@04n@oe00?imOD0
1_D01OWenOWe00;i00?enOD00_T01oGimOGimOT00_D01oWemOGimOT00_D3n@;e00CimOWi1?D00oWe
m@05m@03nOGe00Ce00?Ac8P04D@2J09416P2[007S:b<c=3Ac003d003dLc@00C@0Z`00hb/[002[0B8
00F<R:b<R002[003d:c@00;@00?Ad=000m000m7<d002d008c:c<d<c@[<`2d005c=7AdJ`00m03c0;@
00>/c=001]002Lc@d=3ad?7el@03m@03nOGe00Se0_T8m@03lM3@00;@00[AlM2/S8QXR6Q40VP00hS@
[002[004S<c@d0:/00Z<R8b8S8R<[8QX0XP3S0:/00F<[<c<d002c0B/00><R8P00T@;90941R@2A0HT
0T@=9003A2@T00A482@5A0<T0d@U9003A2@T00<T0T@00bA4900290I400AXA6QX0d@01VQ4J6Q4J0:8
0VP2R0:<0XP00fR8J002R0:<1:`00hR/S00;[003c:b/00B/00B<[:c<0j`00hb/S006[005R8b/c:`0
0/`5[004S:b8R06<000?A00394A400A400<TA4@09D@3J003R:b/00:/0/`01=3<d=02d@03mO7e00;e
00?amO405OD00o7em@03m@06lOGalOGA0_4;m@03dO7A00?@0/`01M3<d<b/00;@00?<d:`00Z`2c0:/
00o@c:b/c:b<[8b/R6R8[=001?D00oWem@02m@Gi00KenOGenOD4n@Ge00GimOGim@02n@;e0oT00oGi
m@0>m@03nOGe00Oe0oT00oGin@03n@?e1OT9m@03nOGe00?i3OD00oWem@08m@04dJb<J0e400=XA4@0
1D@2R003S:b/00>/00?<d=000]001]7@dM7ad@?@00G<d:b/c002[003d:b/00:/00K@[:c<[=02c0C@
00C<d=7a0]000lc@d002d004dM3Ac0;@0/`6d003c:c@00;@00G<d=3@[00:d003dM3A00;a0_D00oWe
m@0;m@;i2?D00o7@d003d@03d:b<00F800=XR8P00Z`00hb/[003d003[8b<00:<0XP01VR<[8b8[0:8
0X`00hR<S003[005d:b/[=000/`00haXR002J0=42R@00d@T900390940b@00d@T9003A18T0T@A9003
A2@T00@T00=492@012@4A08T00A494A412@00d@T900M90940R@2A00494A4A0DT1T@00fQ4J004A003
J4AX009X0XP2J0:800=XR8P01HP3S004[8b<S0:/0h`4[0;<0j`3c007d<c@d<b/c003[005c:b/[<`0
1Z`01Hb8S:c<00:/00><[:`00Z`018b8R8P1J000;T@00bA4A00>A09X0XP01Hb/[=2/00;<00G@c=7A
l@04m@03lOGa01Ge00?amOD00_401oGamO7AmO403?D3l@05dM3@d<`00m002<b/[<c@S=3<0j`02/b/
[<b/c8c@[8P3[005S8R<[=002_D01?WemOT4m@06nOGinOGi4?D01_WenOWen@[e00?imOD01_D01?We
nOT4m@Ci0oD5n@05mOWemOT00_D00oWen@02m@?i00KjmOWimOT5m@03nOGi00;e00CimOWi1?D00m3<
[002J0E400=XA8P00T@01HQXR8QX009400N8J6QXR:b<00J/00G@dM3Am@02d@04mM7ad@;e00GAd<b/
c003d005c:c<d<`01M000oG@d@05d003lM3@00?@00[Ad=7@dM3ad<b/1]002_7<[:c@[=2/d<`2d004
dM3@c0K@00?Ad=404OD00oWem@05m@;@00?ad=400]402?6/R:b8S8QX0XP2S004R:b/[0?<00B<R6QX
0hP00fR8S003[0:<00B/S8R<1:`01=6/[:`2d0><00=XR4@014@B9003A2@T00<T0d@69004A2@TA0LT
0T@C9003A2@T00TT0T@00bA4A0039003A2@T008T00=492@07R@00d@T9007A08T14@01RA4A4AXR0I4
0VP2R0IX0hP016R8R8P3S0:80h`2[003S:c@00>/00?<[<`00/`01Jc@[:c<00;@0/`01M2/d:c<00;@
00C<[<c@0j`2S0;<0j`00lb/c004[004S8R/[0:8000^A08T24@00fQ4A005A004J8R8R0:/00?<S<`0
0]001<c@d=44m@;a5oD01=7alM43l@;e00CAmOGa1?D00o7em@06m@;A00C@dM3<0]000lc@d002d004
[=3@[0;<00C@c:c<1Z`00hb/R003R003S<ce00Ge00KimOWimOT2m@06nOGinOGj0oT01OGinOGi00?e
00?imOD00_D01?WemOTAm@04nOGen@Ge00CjmO[i1?D00oWem@02m@09nOGenOGjnOGj00;e0_T4m@06
n_GjnOGi0_D01_WenOWenP;e00?imOD00_D01O[emOGi00;e0]000jaXA004A0AX00E4J6QX[002S003
J4B800AX00R8[8R8c8b/S0?@00CedO7A1OD2d@?@00G<[=2/d002c0?@00Oec:cAc=3A00;@00?AmM00
0_400m7@d@05d005mM3adM000/`01Zced=7@[0;@0l`02=2/d=3Ad=7a1=002OG<c=7@c?7enP08m@03
nOGe00;e00CimOGj1_D01M7ad=7e00?A00R/R:b8J8Q4J0:800J<[8c<[=03[004R6QXJ0>800=XR:`0
0j`018R/R8P2S008[<c@c:c@[=43[004c8R8J0A44R@00d@TA003909412@2A00394@T00TT00=492@0
0d@79003A2@T00DT0T@:9003A2@T00946B@00d@T90039003A2@T00HT0T@290U400<TJ4@00T@012A4
A8P2J0M40fP01TB8R8QXR0EX00>8S8P00hP2S003[8b/00J/00C<[<b<1:`018c@c=02c007d:b/[=2/
d003[003c:b800>/00?<[:`00Z`00lc@[003[006S8R8[8R<0HP0041400IXS8R8[8`4[005c:c@d?40
1?D00o7em@0Bm@03lOGe00Ge00GAd=3el@0?m@09lOGalM7@c:c<00:/0/`4d003c:b/00:/00?<[:`0
2J`2R0:<00?@dOD01oD00oWem@08m@;i00?enOD00_T:m@05nOGinOD00_T00oGim@06m@03nOGe00?e
00?imOD00oD2n@03n_We00Ge00?imOD01OD2n@03mOWe00;i00CenOWe0_T00oGin@02n@05mOWimOT0
0_D00oWem@05m@05nOGinOD00_T2m@04lLb8J0E400=XA6P00VP2R004S6QXA0AX00E4J8R/R004[005
S:cad?400_D2l@Ce00C@c<c@0/`5[003d:c@00?@0Z`3d004c:c<d@S@00K<d=7@mO42d0:/0]000lc@
[002d004dM3@c0K@00?ad=001m000m7@l@02m@;i3?D2n@Se00CAlOGa0m000jb8S003R008J8R8S8QX
S:`2c005[8b<S8P016P018QXJ8`2[008S:c<S8R<R:`3d003c=2/00;<0Z`01<b8J6P4A18T00A494A4
1b@2A10T0T@?9005A2A494@02b@2A0@T00=492@022@01D@T92A400DT00=492@00b@00d@T90059005
A2@TA2@02D@00bA4A005A003J4A400=40VP3A09X00E4R8b8J003R09X0hP02VR8R8R/S:b8[8`2[003
S:b/00B/0/`02:c<d<c@c:c@1Z`00lb/[003[008S:b/S:c<d:`2c003d<b/00:<0Z`00hb/[002[000
54@00bA4A003A00394A400I400<TA4@034@00bA4A00<A0:800B/S8b<1:`018c@d?4Hm@;a1?D01?7e
mM42d006lM7AlOGa3oD00m7@d@03d0;<00S@c<b/c=2/S0:/0/`2[006R:b<[8b/0XP2S004R8b/d0Se
00?imOT00_D00oWem@02m@05n_WinOD00_T00oGim@07m@05nOGinOD01?T00oGim@0Bm@;i1_D00oWe
m@02m@06nOGenOGi0_D00o[in@02n@03mOWi00;i0_D00oWen@02m@03nOGi00;e00?imOD00oD01_We
nOWen@Ge00?<S6P01D@00fQ4R005J0=40VP01DAXA4B800:<00>/S8P00j`00m3am@08m@05c=3<d<`0
1:`2c004d:c<c0;@00W<[:b/c:c<[<`00Z`00lc@c005d006c=3@mO7e0m02d@03d<cA00;a1m001=7a
dM02d@C@00CAd=3@2oD00o7em@03m@03nOGe00Se0o42d003dJb800:800V<R8R8S:b8J8`00Z`01/b/
[:b<[0B80VP2R005[8R/[=000Z`028b/S=3<dLc@0Z`2c0:/00><J4@00R@4A14T00A494A41b@3A0`T
1D@49003A2@T008T14@00bA4A003A0<T00A492@T14@01BA4A2A402@T00=492@02T@290]400AXA8QX
14@2J004R6QXJ0B800=XR8`01hP00jb<[002[003c:c@00:/00?<[<`01Z`00lb/[002[003c:c<00F/
00B8S:b/0X`2[0:<00B/d<c<0Z`00hb/[003S0>/000iA00394A400I400=XR8`00X`2[0:<0Z`3d004
dOGelASe00?amO400_401_G@lO7elA7e0_42d@03d<b/00N/00?<[<`01:`2S0:/00^<[6QXR8b/S:b<
d007m@05nOGenOD00_T3m@?i00CenOGi0_D00oWem@06m@05nOGinOD01?TEm@Ci1?D00oWem@08m@?i
0_D6n@03n_We00?i0_D01_WenOWen@;e00GimOGim@04n@;e00KimM3<[6P6A004J8R8R0=X1D@012A4
A4@2J09400V8J8b<[<c@mO401_D00o7<d002d0:/00F<[:c<d002c003d<c@00;<0Z`00hb/[003[0:<
00J/d:c@[<`2d0:/00?@mO401=000oG@d@02d0;A1m001?7AlO42d@04d<cac0?@0_400oGjm@05m@?a
00?AlOD03OD00o7el@03d003[8b<00F800F<[8R8[002c005dJb/[8`00XP01:b8[8`2R0><00S<[<b/
S8QXS0:/0]000lb/d002[0><00>8A2@00b@00d@T900@909400DTA4@TA0099003A2@T00<T2d@79003
A2A4008T14@00bA4A00590A40b@00d@T90049004A2@TA1XT0T@390e400<TA4@014@2J09400=XA4@0
14@2J0^800><R8P00hP018b/[8`2c004d:b/[0G<00?@c:`00j`018b/[8`2[003c:c<00:/00>8S:`0
0Z`01m3<[:b8[<`01j`00hb/S002R06<0012A005J8R8R8`01Z`01<c@d=42l@05dO7amO402_D00o7e
m@03m@03lOGe00;e0_400oGAl@03l@04mO7el@?e00?amOD00oD00o7em@02m@04lOGed@;@0Z`00m3<
d00:[004S:b<S0>/00AXR:b<0hP00jc<l@0:m@;i00KenOWenOD2n@03mOWe00Oe00?imOT00_D01OWe
mOWe00;i00?enOD01_D00oWem@0;m@03nO[e00Ce00Oin_WenOGi00;e00CimOGi0_D01OWenOWe00;i
00GenOGen@02m@06nOGinOGi0_D00oWen@02m@03nOGi00;i1?D01=7@[6P7A004J8R8R09X00E4J6Q4
9005A09X00=4R:`00j`2d003lOGe00Ke00?AlM000]000m7@d003[005d<c@c=000j`01M2/[8c@00:/
0X`01Lc@d=2/00;@00S<[=3AmM7@[0;@00Gad=7@l@03d003dM3@00;@00CAd=3A0]02d@05d=7@lM00
0_4:m@;@00?Ad?404?D00m7@d002[0>800><R8`00Z`2S004c=3@d@;@00C<[8b80h`00jb<[002S003
c=3@00;@00B/S:b/0l`01Zc<d=3<[0:<00R8[4A494@TA0PT00=492@01R@2A0@T0T@3909400<TA2@0
0T@9909412@5A0PT0d@01BA492A4008T00=492@01R@2A0<T0d@00bA490049003A2@T00<T00=492@0
32@4A08T1d@00fQ4A003A00394A4008T24@01RA4A4AXA09X1hP00fR8R004R005S8R/[8`00Z`3c003
[<b/00>/00K@c=3<[<`2[005d:b/c:`00/`01=2/[8`4[004c:b/S0F/00S<[8b<[8b/S0:80H`001Q4
00<TA4@09d@016R8J8P2S0J/00K<d=3@mO42m@03dO7e00;e00?amOD00oD01?7emO47m@03dO7e00;a
00OelOGelOGa00;e00CamOGA1?D02?7emOGamO7A0_401]6/d=3<d0;<00>/d:`02J`01Hb/[8R/00:8
00N<R8b<d=7a00_e1?T01oGjnOGimOT00_D00oWem@03m@06nOGenOGi0_D01_WemOWen@;e00CimOGi
3OD01?Wen_T4m@06n_WjnOGj0_D00oWen@02m@04nOGem@Gi00KjnOGimOT4m@04nOGenP;e00KimOWi
mOT2m@;i1?D00m7@R006A0AX14@016Q4A2@5A004c8QXS0B/00K<d?7amM05m@03d?7@00C@00CA[:b/
0]02[003c:b/00J/00><[8`00Z`00m2/[002[007d8b/d=7ad@02c0;A00CedO7<1=001m7@dM7ad=40
2M000lc@d00;m@;@00?Ad?D00oD00oWem@0:m@03dM3@00:/00B<R8R<0j`3S003c=3@00?@00F/S<b8
J003S004[8R<[0?@00?Ad=000Z`028c<c=2/c=3<0]001HR<J8QX00E412@2A0DT00=492@00b@00d@T
900;9004A2@TA0XT0T@390M40R@00d@T900290940R@3A08T0d@:90E41R@00d@T90039003A2@T00TT
1D@490A400<TA4@064@02FQ4R8QXR6R8S003R00AS8R8R:b<R8b/S:c@c:c@c=000j`01Lb/d=3<00:/
0]02[0;<00CAd:c@1:`01Xb/S=2/S0F/00?@[:`00hP2[003S8R/006<000?A00394@T00i400<TA4@0
1d@00bA4A00FA0>800>/S:`00Z`00hb8[002[008d=7AdO7elM45m@03dO7A00?e00?amOD00_D2l@05
mM7AlM401o401M3amOGa00Oe00GamOGel@02m@?a1m000jc@[003[0C<00F/d:b/d002[0:800><R8`0
0X`00jcam@07m@03nOGi00?i0_D00oWen@03n@Se00CimOWi1?D01_WenOWenAOe00?imOD00_D4n@;e
0_T01oGinOGimOT00_D7nAOe0_T3m@03lM6800M40fP<A09X0XP4[004S<c@l@Ke00?ad=000]401M2/
d=3A00;@00J/dJc@[=02[003S=2/00>/00><[:`00Z`01<b/S8`2[008S:c@d=6/d:`2d0?A1M002O7A
d=3Ad=7@d@02d003dM3@00;@00?<d=402OD2l@;@00CamOGa3oD2d@04d:b/[0:80X`3[007S:c<d<c@
[004S003R8b<00:800J/S:b/c=44d0>/00g<[:b/d<cA[<b/R6R8009X14@590941B@00d@T90029003
A2@T00`T00=492@022@4A0<T0d@29004A2@T90940b@4A00394A4008T0d@79005A2A4A2@014@C9094
2R@;A004J4A490e400TTA4A4J8QXR8`00XP2S0:800AXR8b80h`01hR<[8c<[8`00j`00lb/S004[007
c:b/c=3<[003c0B/00><[8`00j`01Xb/[8b/c0:/00B<[:b/0hP2S003R:b<006<0008A00394A400i4
00<TA4@01D@00bA4A006A00594A4A2@054@02fR8S:b8S8R<R6R<00:/00G<d=3@d@02m@03lOGe00?e
00?AlM400_401OGAlM7a00GA00?ad=000m001]7adO7Al@;e00WAlM7elOGamO401oD2l@03dO7A00?@
0l`4[003d<b/00;@1Z`01HR/[8b/00:<00>/mOD02OD4n@;e00KimOWimOT2m@03nOGe00;e00CimOGi
1OD00oWem@02m@03nOGe01?e00CimOGi1?D01?[inOT2m@03nOGi00Ki0_D4n@03mOWe01Oe00OimOGe
dM2<00=400=XA4@00VP2R0]40fP00hR/S003c004[=3@d@Ke00K@dM3Ad=46d003c?6/00?@00?Ad:`0
0]000jb8[002[007S:b/[8R<[002S005R8b<[<`00j`01M2/d:c@00>/0m02c005[=3@d<`01m001<c@
d?42d@Oe0_400m7@m@02lA7e0]001Zb<R8R<R0:<00B/S:c<0Z`00m3<[003R09X18P4[0?@00?ad=00
0]03[004d<c@c0?@00>/R6P016P4A0<T0d@59003A2@T00dT00=492@032@3A00394A400=412@00d@T
900590E400<TA2@02B@3A0<T00=494@014@M9003A2A4008T24@3909400@TA4A40R@3A08T0d@5J0B8
00><R8P00hP00hb/S002R004S:b/S0>/00><[:`01:`00m2/[002[0C<00J/d:c<[<`6[003c:b/00>/
00K<[:b/R8`6R0>/0014A005J8b/R8`018P3S007[<c@d=7@l@07m@03lM7a00;a00?Ad=000]401O7@
d=3<00;@00b/c=3@lM7@dO7AmM45l@03dOGa00Oe00OAlO7adO7A00G@0j`00lb/[003[004c:c<[0J<
0j`2d@[e0_T01_GinOGim@;i00GenOGen@0@m@06nOGinOGi4_D00oWem@02m@;i0oX2n@;e00GimOWj
m@02n@;e00?imOT00oT00oGim@0Dm@03nOGe00Ce00?@S6P01d@00fQ4A00;A09X0XP4[0?@0_44m@06
d:calOGa0oD2d@?<0]000m7@d002d@05d?7@[8P01J`01Hb8R8b800><1j`2d006dM3<[<b<0/`00m2/
d003d003c=3@00G@00CAc=3@0o47m@05lM7AdOD00o4<m@04lOGem@;A00?@[:`00XP00hb/S002R004
[=3<d0>/00><R8P018P2S005[8R<S<`00]000m7@d@02d004[=3<d0;<00^/d=3<[8b8S8QXR002A0DT
1D@=9003A2@T00DT00=492@032@5A0hT1D@;90I400<TA4@00d@990944R@5A08T1T@290U40R@5A09X
0T@4J003R6QX00=X1HP018b8S8P6[003c:b/00>/0m001:c<[=02c0>/00K<[<b/d:`3d008c=3<d<b/
S8P5[0:<0hP00jb8R002S000;D@00bA4A00<A00394A4009400AXA4AX0Z`018b/S8`2R003S:b/00?<
1=000lcAm@03m@08lOG@mO7Ad=42d006dM3@c:c@0l`00m3<d004d004lM3Al@;A00?ed?D00oD01?7A
mO43m@03lOGA00;a00GAlM7@c003d0B/00J<d:b/d<`3[003R:b/00>80Z`00m3Am@07m@03nOGe00?e
0_T01_GinOGjm@;i00?enOD01?D00oWem@03m@03nOGi00;e00KimOGimOT2m@03nOGe00ke00?imOD0
0_T2nP03nO[e00?i00?jnOT01?T00oGin@03n@We00?imOD03_D00oWem@02m@03d:aX00A400=XA4@0
44@018R<S8`3[0;@3OD01?7edM02c004d=7@l@;@0_401=3ed=03[003c:b/00:/18`038R<[=2/d:c<
[=7@d@;@00R/d:b/c=2/c0;@0Z`4d009c=3<d:c@c=3A00Ke0o42d005dOGemM404OD2d@04d:c<R0:/
0X`00hR/[002d0B/00B8S8R80VP01jb8R8b8S:`01=001m7@dJc@dJ`00]001Lca[<c@00:800>/S:`0
0VP2A00394A400E442@00d@T900>9003A2@T00<T0d@590=412@5A08T0T@69003A2@T00@T0T@00bA4
A00<90940R@3A0LT00=492@012@4A0<T64@2J007A6Q4J8QXR002A0=X0hP2S003[8QX00J/00W<S:b/
c:c<[<`00Z`00lca[002d0:/00K<[<c<d<`3d004c=3<[0;<00><J:`00Z`01Xb/[8b/S0>/0HP1S06<
000BA00394A4011400<TA4@06d@2J003R8b/00:<18P01hb/[:c<[<`01=000m7em@03m@05dOGalM40
1]000jc@d008d006lM3@d?G@0]401?7AlO45m@03lOGe00Ga00CAlM3a1=000jc<c002c0>/00O<[8b/
d:b<00>/0XP2[003d=7a00_e0_T2m@Ci00GenOWen@0Em@03nOGe01Ge0_T3nP;i0_D7n@04mOWim@Ci
7_D00o6/R007A00394A4009400<TA4@024@00hS<[002S0:/0]000o7em@06m@08lOGemO7edM03c003
d=7e00;A0_42d@03d=7@00?@00?<d:`00j`01Hb/[8b/00?@00G<[<c@c003d006[8b/c=3<0Z`2d007
[<cAlM3<[002c0>/00?@mO401oD00m7@c002d0?a4OD01=3AdM02[004S:b/c0B/0m03[0:800><J6P0
0fP2R0:<00?<d=000]001o7Ac<c@c?D00]001:c<d<`2[0B80VP:A0HT00=492@07R@3A0HT0T@690A4
00@TA4A42R@01D@T94@T009412@00d@T900890=42B@00d@T900390A40b@00d@TA006A003J4@T00a4
0VP3A0EX00=4J8P00VP3R004[8b8S0?@00?<d8`00j`2c004d8b<d0:/00G@[:c<[004c0W@00B/c:b<
0XP01Xb/[8b/c0B/0X`1[06<0J`001]400<TA4@01T@00bA4A00DA00394A400E40VP018R<S8`2R0:<
00B8[:b/0X`2[003c=3A00;@00GelOGel@02m@05lOGAdL`00m04c005d<c@d<`00]000jc@d002d003
dM3@00;A00?adM401OD00o7ed@06d@04lM3Ad@?@00?<d<`01J`01M2/[:c@00:/00F<[:b<[002S003
d=7e00oe00GimOWim@02n@05mO[emOT00_D00oWem@0;m@03nOGi00;e00CimOWi4_D01_[in_[inP;i
0_D4n@?e0oT2m@03nOGi00;e00?imOD01OD00oWem@05m@03nOGe00Oe00?ad:`03d@00fQ4A005A003
J8b/00:/00?<d=002_D02=7elOGad=7e0/`00m3<d@04m@;a00S@lOGAmM7ad@?@00F/R:b/R002[003
dJb/00:/00?<d:`00Z`01Lb/[:cA00;@00B/d=7<0Z`01Lc@d<b/00;@00CAd=7a1?D00oWem@02m@09
lM3<d=7amO7A00;a3OD2d@;@00?<[:`00Z`2R0>/0m02[003S:b<00:80VP00dAXJ002R0:<00J/d=3@
c=02d@05d?7@dO400m001<c@[<`4R0AX2D@49003A2@T00lT00=492@02B@2A08T00=492@022@00d@T
900490Q442@3A0/T00=4J6P04B@:A004J4A4A09X1T@00bA4A004A004J4AXJ09400AXA4A41FP4R007
[8b8S:b<c002d0:/00F<[:c<d002[004d:b/c0:/00C<[=3<1M000lc@d003d0;<0hP2S0:/0XP00hb/
S003[0><0J`001M400<TA2@01T@00bA4900DA00394A400U40VP00hR<R003R0>/00><[8`00Z`00lb/
c002c0;@00?AlOD01OD2l@03mM3@00G@0/`01Jc<[=3<00:/00?<d=000]001:c@c?42d003dOGe00;a
00CedM7a0]401O7@dM7a00;A00?@lM000]001:c@[<`3[0?<0j`01M2/S8R<00:800><[=002OD2n@Oe
0oT4m@03nOGe01Ke00?imOD03_D00oWen@02n@03n_Wi00Ci00?enOT00_T2m@03nOGi00?i2_D2nA;e
00?imOD00]000fQ4A00DA005J8b/[<`00]02l@Se00KadOGamO48d0Ce00CadO7@0_D2l@07dM3Ad=6/
d002[0;<2=001:c@d=42[003d=7@00:/00CAd=2/0/`01M3<c:c@00;A00G<dO7el@05m@;a00CAd=3A
0_42d@;@00?AmOD02oD2d0;a00?@[:`00Z`2R0:/00N<[=3@c=2/00:<00F8J6QXA002J0>800><[<`0
1=001=7ad?44d@06d?7<d:c@0X`00hR/R004J0e442@2A0<T00=492@012@4A0HT00=492@02b@3A0<T
14@690941R@01D@T92A400@T00A492@T14@;9003A2@T008T5d@00bA4A003A0EX00=4J4@00fP014AX
A4@2J0>800><R8`00X`4[006c:b/[=3<0Z`01Lb/[:c<00:/0]03[0O@0/`01=2<[:`4S004[8aX[0:<
00J8S8b<[8P1S0005d@00bA4A007A00594A4A2@07D@2J006R8b8S8R<0Z`00hb8S006[0;<0]03l@Ke
0o400m7@d003d0;<0j`01M3<[<b/00O@00C<d=3@0_401_GalM7ad0GA00G@mM7@d@03d0;<00G@c=2/
c003[003d:b/00:/00N<R8R8S8R/00;<00?AmOD01OD00oWen@03m@04nOGim@;i00GenOWen@07m@03
nOGe00_e00?imOD02_D00o7em@06m@03nOGi00Gi00?jnOT00_D:n@05mOWimOT01_D2n@03mOWi00Ce
00?imOD02?D01OWemM7<009X2D@00fQ4A00:A004J8b/c0C@2OD4l@04dM3@c0?@00?ad?D00oD01=7@
dM42m@03lM7a00;a0]48d003c=7@00;@00O<[<c<d:c<00;@00?<d=000m000m7ad003d003c=2/00C@
00?elOD01?D00m7ed002d0?A00W@c=3@dO7@dO401OD01_7emO7Ad0;e0]000jb<[007[0;@00?<[8`0
0XP024AXJ6Q4J8QX1:`01/c@c:cad0;A00G@mM3@l@02d003dM3@00:/00B8[:b816P7A003J4A400`T
00=492@00b@2A0XT00=492@014@49003A2@T00TT1D@39003A2A400DT14@990940R@3A08T0d@59005
A2@TA2@00d@4919400EXA4A49006A09X0d@2J004A6QXA0EX1HP2S003R8b/00B/00><[:`00]06[003
c=3@00;@00>/c:`01m001<b/S:`2S0B/00F<[8R8S003R0F/000CA00394A400Y400<TA4@084@01HQ4
J8R<00:81X`00jb<[003[0C@00CAd=3a1OD01?7elM44d003c:b/00B/00?<[=001M000m7@d002d003
dM3a00Ga00CedO7A0_42d003lM7@00G@00B/c<c<0Z`01m2/d=7@c:`00X`01Jb<[:b<00>/00C@mOGa
1OD00oWem@0Rm@?i00CenOGi4OD01?WenOD2n@03n_Wj00;e1_T02OGinOGimOWen@08m@03nOGe00Oe
00?imOD02?D00m6/R00BA00494AXA0=X00B/c:c@0]400o7em@02m@04nOGem@;a00?@lO400m02[003
d=7A00Ce0o42m@04lOGAl@?e00?ad=401m001_7@d:c<[0C<0Z`2d004lM3@[0;@00KAd=3@c8`2[006
dM3AlM7@1OD02O7Ad=3<d:c@c002d003dM2/00?@1?D00o7el@03l@05mO7adL`01j`3c007d:b/[8b/
R002J005R6QXJ8P00X`01:b<[=03c006d=7@mO7@0]402]3ed=7ad:c@S:`2S004R6QXJ0U452@00d@T
900<90=41B@00d@T90059003A2@T00Q40b@2A0@T00=4J4@00R@00d@T90049003A2@T00@T0T@;9003
A2A400=40b@CA09X2D@00fQ4A002A0UX0XP3S004[8b8S0:80Z`00hb/S002[003d<c@00>/00?@[=40
2]000o7@c003c003S8R800F/1h`01FR<S8b8006/000JA08T1D@00bA4A00KA09X00=4J6P00fP2R005
S:b<[8`02J`2d003dM3@00;@1OD01=7elOD4d003c:b/00:/00?<d=001:`8d0GA00?@lM000_400oGa
m@02d003dM3@00K@00G<d=3<d002c0G@00B/d:b<0Z`2R0:/00?<d?403?D00oWem@02n@03mOWe00oe
00KimOWimOT7m@;i5?D00oWen@02n@;j0_T00oGin@02n@;e1?T=m@03nOGe00_e00?imOD00oD01=6/
R6P8A00394A400A400<TA4@00VP2A09X00J/d=7AmO46m@04nOGem@;a0m400m3<[002c0;@00?AmOD0
0_D00o7em@05m@03lOGA00;e0o401=3ad=02l@04d<c<c0>/00O@c=3<[=7@00>/00?@c=000]02[003
S:c<00;@00CAd=3A1OD01M7ac<b/00?@00F/c=3@S004J003S=7a00;e00GamO7am@03l@G@2:`00lb/
S002R0=X00F8J8b8S005[003c=3<00?@00KamM3Ad=43d0;a1M001Zb<R6R8J0Q42B@00d@T90089094
4R@3A0LT0T@012A492@7A0<T0T@390E40R@00d@T900=9003A2@T008T00=492@00b@00d@TA00TA003
J4B800=X00E4J6R8J002R009J8R8R8b/S8R<00>/00B8[:b81:`01lb/c:c<[=402=001/c@d=3<d0>/
00>8[<`00Z`01hb/[:b<[8P00j`018b/S8P1[0004d@00bA49003A00594@TA2@01T@00bA4A002A003
94A401E400=XA4@016P3R0:<00>/S:`01J`2c003d=7@00C@00?AmOD00_D3l@03mM3@00;@0Z`00lc@
[003d0;<0Z`2d003dM3A00?@00?Ad=000m002=7@dM7adO7A0]001M7@d=3<00?@00G<d=3@c008d004
c8b<[0>80Z`00hc@d@0;m@06nOGenOGi1OD00oWem@0@m@05nOGenOD00_TGm@_i00?jnOT00_T00oGi
m@02nAge00KimO7@S6P7A00394A400]400YXR8R8d=7elOGa2OD4l@06dM3@c:c<0]400oGam@05m@04
lOGel@?e0_43m@03lM7a00?@00CAd=3<1:`01=3<d<`3d0V/00C<S:b/1=000m7am@04m@c@00><A6P0
0fP00hS@d002d003lOGa00Ca00?AlM400]401=2/[<`2[0;<0j`02HR/R8R<R4AXS002[00>S:b<S=3A
c=3Ad=7ad?42d005dM3AmM401]000jb<R003J005A6Q4A2@00T@29003A2@T010T00=492@02B@00d@T
A002A0<T0d@=9005A2A4A2@00T@00bA4900590=40R@3A0PT0T@290=42B@ZA09X0XP3J005R6QXR6P0
0XP2S0>80h`01HR<S:b<00N/1<`00jc@c002c0;@0Z`01<c@d=02c0B/00><[:`01J`01XaXS8b/R0><
0J`001M400<TA4@09d@2J003A6QX00AX00>8S8`00X`00jc<d002d004[=3@d@;@0]401?7@dM43m@06
lOGelM3A0]001lb<[=2/d<`00]02c0O@00?Ad=401M000m7@d002d@03d?G@00S@00B/c:c<0m001=7@
dO42d@03d<c<00B/0X`3[003d?Ge00We00?imOD00_D01?WemOTCm@03nOGe00Ce0_T00oGim@03m@03
nOGe00_e00?imOD01OT01?GinOX6n@05mOWjnOD00_TLm@;i0_D00m2/J00DA0AX00><c?400_400m3a
m@07m@;a1=400m3Ac002d0;A0_49m@0:dO7amM7edOGam@C@0Z`3d004dJb/c0?@00G<d=3@c002[005
c:c<[<`00Z`00hR/[005d0Ke00?@c:`00Z`3d007dM3@dJaXA002J004A6R8R0>/00C@mM7e0m400m3e
l@02d0;<00g@[:c@c:c<[8QXR6R8009X00J8J8R/c8`2R0;@00G<d=3ed002d@08d?GAd?G@lOD2d007
dM3Ac:b8J002R09X0T@290=400<TA4@014@490=41B@014@T92@5A0HT0T@590940b@00d@T90059003
A2A400=400<TA4@00R@00d@T900390=40b@01D@T92A4008T00=492@00T@390942R@@A00394A400A4
00<TA4@014@00fQ4A004A004J4A4A09X0XP3J003R6QX009X00><R:`00Z`018b8[8`2[003R:b/00V/
00?<[=001J`00m2/S002[004d<b/c0:/00G@[:b8S004[004R8b/R0><00B8S8b80J`001E40b@6A005
94A4A2@054@00bA4A006A09X00=4J8P01FP00hb8[004[007c=2/[=3<d@02d003lM3a00?@00CamO7a
0_D00o7Ad@0<d003dM3A00;@00?<lM400]001]7@lM3Ad0;a00OAd=7AlM7a00C@00CAd=3<0Z`4d0;a
00G@dOGAc004[0:<00>/S:`00Z`00lcAm@0=m@03nOGe03;e00?imOD00_T00oGin@02m@Ci0_D01?[i
nOD2n@04mOWinAoe00?Ac8P03d@012A4A4@5J003[=3a00;a00C@lOGi1_D6d@?@0/`00oGAm@06m@;a
00cAmOGadM3AlM7adO44d0B/0]001<b/S=02[0;@00?<[:`00Z`01<b/c=03[003S:b/00C@1oD00m2<
[004[003c=3@00;A00>/R6P01FP01hQXR8S<lOD00_42d@;a00KAlM3@dM04[0;<00>/R6P00XP2J0B8
00B<c8c<0Z`00m3<d@02l@06mM7@lM3A0]001M7ad=7@00;A00G@c8b8J002R003J4A400<T0d@29003
A2A400941B@00d@T900:9003A2@T00=40b@2A18T00=494@00d@00bA4A0039003A2@T00<T0T@39094
00@TA2A40b@3A0<T0T@:909400DTA4A49008A0@T14@290]400=XA4@014@:J0B80X`6R003S8R<00:/
00><R:`01:`01Hb/[:b<00:/00G<S:b/d002c0>/00?<[=001J`00lb/[003R007S8R<S8R/R001S000
64@00bA49003A00394A401i416P2R09X00V8J8R/S:b<[<`01J`2d004dM3@d@;@00CAd=3A0_42d@?@
00?ad=000]02d@c@00WAd=3@dM3adO400m000m7@l@02l@;A0m000m7@d002d003[<c<00;@00>/d=40
1=03[004S:b8R0:<0j`00lc@l@0=m@03nOGe00Ge00?imOD04oD00oWem@05m@03nOGe00_e00KimOWi
mOT2m@05n_GinOD00_T01?GinOD4n@03mOWi00;i6?D00oWem@04m@03c6QX01=400IXR8R8c=02l@05
dO7emOT01?D01oWedM7@dO400]001Lb/d=3A00;a00C@mO7e0]42l@03dO7A00;a0m401M3AdOGA00;@
00?A[=000Z`00m2/[004[0;<00K@[:b8[<`:[003d<c@00;a1OD00m7@[002S00:R:b/[=3<d?GA[0AX
1D@01HR<c=3A00;@1=402=3Ad=7@c:b<1:`01Hb8J4AX00:800B<[8R80X`00jb<c002d0;A00?adM40
0]400m3ad002d0?A00K@dM3<S:`4R003J4A4008T14@00bA4A005A0DT00=492@00R@2A08T00=492@0
0b@4A0HT00=492@022@00d@T90029004A2A490E40b@4A0<T14@59003A2@T00<T00=494@04B@00d@T
9009A00394A400E40R@>A004J4A4A0IX1XP00fR<R002R09X0hP01VR8[8R<R0B/00><[:`00Z`018R<
R8`3[009c:c<d<b/c:c@00;<00B/S:b/0h`:R000;T@00bA4A00>A0=X0XP2J0B82:`018b/[<`;d004
dO7al@C@00GAd=3ad@03d005c=3@d=401M001]7@lM3Ad0?A00G@dM3ad@02m@03dM3a00G@0m402M3<
d=3AlM7@d@03d0:/00B8[:b80h`2[005d:c@d=402?D00oWem@03m@03nOGi00oe00?imOD00oD00oWe
m@05m@04nOGenA7e1OT01OGinOGi00?e0oT01oGinOWenOD00_T>m@03nOGe00ke00?@S6P04D@01fQ4
J6R8S:`00]001=7emOD3n@Ge00?ad<`01M001lc@lO7AlM400o402M3alOGamM3el@02d@08lOGAdO7@
dM02d@?@00?<d=000]001Jc<d=3A00>/00?<d=001:`3S0B/00?@lOD01?D02=2/S:b<c:c<0Z`01]3A
d?7Ad0:80VP6A09X00B/c<c<2]003/b/[:b<[8b/R6R8S8R<0hP016R8[:`2d0?a00CedM7@0]42d004
mM3Ad@;@00?Ad=000/`00hb8R002R0I400<TA4@00d@026Q4A4@TA2A412@3A0LT00=492@014@D9094
0b@5A0<T14@39003A2@T00HT00=492@01B@00d@T900>90940b@6A00494A490M400<TA4@02T@00bA4
A005A0=X00F8J6R8J004R0=X00=4J8`00XP016R8S8`4R004[8R<R0><0Z`3S0:/00S<[<b/d:c@[0?<
00B/d:b<28P3S0680H`001I400=XA4@02D@291]400MXR8R8S8QX00:800B<R8b<1Z`028b8S:c<[=3<
0Z`00lc@d004d003dOGA00;A0_400m7@d002d@03d=7@00;A00G@dM3Ad003d@05d?GAlM000_401]7@
dM7am@?a00K@dM7adO45d003c=7@00;@00?Ad=000]03[006R:b<S8R/0h`01:b<[=0Am@03nOGi01?e
00?imOD01OD00oWem@0Cm@03nOGe00Ki00GenOWen@02m@Ci0oD3n@ce00?imOD02_D00oWem@02m@03
[6Q400a400<TA4@00T@01FQ4J8R/00?@00CAmOGe0_T7m@C@00?Ad<`00Z`01m7edM7edO400]000oGA
m@04m@0;lOGamO7elOGAmO400m401=3e[<`7d006lJb/[=3<0j`01M2/[8b/00?<0]000o7im@03m@06
dJb<J8b/0]03[006d=7AdM2/0fP8A003J8b<00B/0m001Lc@c=3<00J/0hP01FR<R8QX00:<00B8J8R/
0m03m@04lM3@m@C@0_45d@;@00>/S:`00fP6A00394@T00A400LTA2@TA2A4008T0d@00hQ4900890=4
0R@00d@TA00A9003A2A400E40b@6A08T0T@39003A2@T00@T00A492A412@014@T92@3A0<T00=492@0
0b@2A0<T1d@490=400<TA4@054@:J0F800=XR8P00XP2J003R:b/00B80Z`018c@[8`3[005S:c@c:`0
0/`00jc@[002d005c=3<[<`00Z`01XaXJ8R<R0:/00B<[8b<0HP002E400<TA4@024@00bA4A002A003
94A400M400=XR6P00XP00hb8R003R0:/00K<[:b/S:`2R004S:b/d0;<1:`00lcAd002c0;A00Ked=3e
d=43d004dLcAd@;a0]001_7@d?GAm@;A00[ad=3ad=7@dO7e0_42d@;a00W@mM3ad<c@lM000]45d0;<
00>/S:`00Z`2R003[8R/00:/0X`018S<d?49m@04nOGenP;e00KimOWimOX8m@03nOGi00[e00KimOGi
mOT2m@03nOGe00Ce00?amOD00oD01o7emOGimOT00_D01O[emO[e00;j00?en_D00_T2m@05nOGenOD0
0_T00oGim@02m@05lOGemOT00_D00oWem@02m@03n_Ge00Ke00WimOGedM28A2@01D@00bA4A00:A003
J8R<00;@00?amM400oD01?WenOT4m@05lM3@lM400]02[008dM3adO7edOD2d0;a0_D00m7em@05m@06
dOGelM7e0]000m7@d002d005mM3amL`00]03[0;<00F/R:b/c002R003S:b/00;@0o43m@03nM3<00>8
00><[=000/`01:cAdO43d003[6Q400Y40XP01Zc<S=2/c0?@00?<[:`01:`3R003A6R800:<18P01FR8
[=2/00?a00?ed?400]001M7@d?G@00;e00[AmO7AlJc<S:b80VP4A0<T2T@29004A2A4909400?@A2@0
0T@590A400<TA4@00T@690942B@4A006J4@TA2A40b@4A00394A400=400<TA2@01b@3A08T0T@00bA4
A002A003[4@T00LT0d@590A41B@00d@T900>A00594A4A6P00T@01VQ4A6Q4R0AX18P018b8J8P2J0:8
00=XR:`00X`018R<[8`2[003c:b/00V/00?@c=000]02[0;@1:`2S0B800><[:`00Z`2S0007D@00bA4
A005A08T14@00bA4A005A00394@T00U40VP2R004[8aXR0F<1J`4R004S:c@S0F/00o<d=3<[=3Ad=7@
dM3Ad?401M02d@03lM3@00GA00C@lM3@0m42d0;A00KelO7@dM02d@07d?GAd?7@d@04d004[<c@d0;<
00R/S:b/S:b8S0R/00?AmOD03oD01_WemOWen@_e00?imOD00_D00oWem@05m@03nOGe01?e00GimOWi
m@03n@05n_WinOD00_T2m@03nOGi00;e00GimOWjn@0Mm@04d6Q490E400@TA4@T0T@00fQ4A004A005
R:c<d=401oD01?WemOT3m@07dO7@dO7@[005d009dOGamO7AmM7a00Ce00?amOD02?D01M7alM3e00;@
0]400o7ed002d009dJb/[=2/R8b800:/0h`01XR/[:cAd0Ke00N/R6R8[=3a00?@1?400jb<R004J0Y4
0hP2[003d:c@00;<00C@[<c<0Z`2R0AX00>8[:`00hP00fR8[003d008lOGalM7@lM04d@03mO7a00?e
00?Ad=000Z`2R003J4A400940b@:A08T0d@00bA4A004A0LT00=492@00R@00d@T90099003A2@T00TT
0T@2909412@2A08T14@<90=400<TA4@00R@00d@T9002A0PT0d@5909400<TA2@012@2A00394A40094
00=XA4@01d@012A4A4@2J006A6Q4A6Q40VP00hQXJ002J005R6R8R6P00hP018b8J8`4R006S:b<[8c<
0j`2c003d:b/00:/00C@c<cA0]02[004d<b/c0B/0X`00jb<[003S0:/0H`001]400<TA4@044@00bA4
A006A00394A400I400=XR8P018`00jb<S002S004c:b<[0:<00J8S8R8[8`3[003S8R<00?<00B/d=3A
0m001?7@dM02d@;@00?<lOD00]44d003lM3@00G@00Cad?7A0_42d@03lM3A00;A00G@mM3@d@03d005
c=3<d<`00]001<b/[:`2S005R:b8R:`00h`00jb<S002[0;@00?amOD02OD00oWem@02m@;i00?enOD0
1oD00oWen@02m@03nOGe01ke00OimOWimOWe00;i00GenOWen@05m@03nOGi00Ki6?D00oWem@02m@03
d8Q400M400<TA4@00T@00fQ4A003A006J8R<[?7@2?D00oWem@04m@;@00?AlM000m001M7@d=7a00Ke
0_401?GalO49m@07lM7@dO7Ad002d@03mM7e00;A00?@dM000m401Zb<[=2/S0B80j`00m3am@04m@03
d:b<00:800?<d?400]02d@04d=7@d0:/00F8S6R8J004A003J4A400=400IXR8b/d<`4d008c=2/c:b8
J4@3J0:800R<J6R8J8R<c0;A00?amM400_401]3ad=3Al@;e00?amO400oD2l@03c:b8009X1D@390U4
00<TA4@00R@6A00394@T01HT00=492@00R@00d@T90059003A2@T00LT00=492@01T@00bA490029094
12@2A0hT00A492A40R@2A08T00=492@02B@EA0AX00Q4J6QXA6R8J0:80VP2S005[8b8R8`01HP01FR8
R6R<00>/0]000lc@d002d@?@00?<d=000m000jc@[002[0:<00F/S:b<[002S0B/0hP001]400<TA4@0
7d@00hQ4A003J0B800><[:`00Z`00hb/[002[0><00F8[8b<[002S005[8b/[8`00j`02=3Ad?7AmM7a
0]401_7Ad=7@l@;A3=002=7@d=3Ad=7a0]002M7adM3ac=2/d004[0;@0j`02<b/[8R<R6R<0hP3S0F/
00C<d=7a2_D00oWem@02m@06nOGenOGi2?D2n@03mOWe01oe00WimOWimOWenOX01OT5m@Gi00CjnOWi
6?D01?WemOD2d@03[6Q400A40R@5A0:80d@3J005R:cad=401oD4n@?e0m000m7@d002d007lM3<d=7e
l@02m@;A0_400oGam@09m@;a00CedM7@0m400m3ed002l@05d=7ad=400]000hb/[002[003S:b/00:<
00B/dJc@1_D00m2/R002R003[<c@00?@00Gad=7Ad002[005S8R<R6P014@2J0E40VP00hb/d003d005
c:b/[=000Z`028QXJ8QXR8b816P02hR<d=7edO7edO7A00;@00CAlOGa2?D01?7@S8P2J003A6Q40094
0b@>A00394A400A452@00d@T9009909442@014@T94@29004A2A4A0HT0T@79003A2@T00DT00=494@0
0d@390942b@6A00394@T00E40b@6A003J8a400=X00=4R8P028P00fR8S004R003S8R800:800>/R:`0
1=000lc@c007d0;<0]000jb8[002[004S:b8[0:<00>/R8`00h`2R06<0HP0025400<TA4@01T@00bA4
A002A00594A4A2@00T@390A400B8J4A40VP00jb8R002R003[8b/00F/00>8[8`00X`01HR<S8b800B<
0Z`03lb/d=3Ad=7ad?Gad?GAl@03d@?@00CAd=3@0/`2d006lM3<d=7e0]002OG@lOGAd=7@d@04d003
[=7<00J/0X`01/b/S:b8S0=X0XP2S004[8b8S0>/00?@lO402OD01_WenOWen@Ce0_T00oGim@06m@;i
00GenOGen@07m@03nOGe01?e00GjmOGim@03n@05n_WenOD00_T2m@05nOGjnOD00_T01oGjmO[imOT0
1oD00oWem@06m@03nOGe00Ge00KadM1XA2@8A003J4A400E400IXA6R/d=42m@03nOGe00Ce00?in_D0
0_D2d@;@00OadM3ad=7a00;@00Oed?Gad?G@00?a2_D02_7emM7edM3ed?42d@06lOG@mM3e0m401/b/
d<b/c0N/00C@dOGj0oD02]7a[8QXR:c<d:`2d007mO7@mM6/c002S003R8aX009X00=4J6P01d@2J0:/
00G@[=2/c002d0>/0XP00hb8R003R09X00j8J8R/d?G@lOG@mM7@m@;@00Oed?GelOGa00Ge0Z`00hQX
J002J0e40R@7A003J8QX00E44B@00d@T90029003A2@T00941B@00d@T900@90I41B@3A0HT00I492A4
94@290Q400@TA4A40b@01T@TA2A490Q40b@5A0<T1D@3J003A6QX009X1XP2J0B800B<R8R80X`3R006
S:b<[=3A0]000jc<[006d004c:c<[0;<00><[:`00j`2R004[8R<R0>/00=X[:`00X`002Y400<TA4@0
1T@00bA4A00:A0=X00B8J8R82J`4S003R8b<00B800><R8P01:`4d0;A00Ged?7ad@02m@03dO7A00;@
00>/c<`00]02[003d<c@00?@0]401?7@dO42d@05lM3@d=401=001<c@[<`2[005S:b8R8`00Z`2S005
[8QXA6P00hP2S0:/0X`2[003d?Ge00[e00CimOWi1?D00oWem@06m@Ci3oD00oWen@0Bm@;i00OenOGi
n_Gi00;e00?imOD00oD5n@03n_We00Ci3?D00oWem@0<m@03c6Q401=400F8[=3@l@08m@03nOGe00?e
00?@dM400]401o7@d?GAlM400_D00m7em@02l@04dM3Ad0Oe00?amOD00_402oGAlOGAmO7AmM7a00;A
0_D01m3Ac=3<[8`02:`00oG@d@05m@07lM2/R8b/d@02d007c=3amM7@d@02d005c8b/S:`00XP00fR<
R002J0M400=XS8`00X`5d005c:b/R8`00hP016R8R6P4R005c=7alM400_401m3AlM3Ad=402OD02O7e
d<b/S6Q4J003A004J4A4A08T14@290E400EX[?Gim@02J0=41B@00d@T90049003A2@T00HT00A492@T
0T@790A43B@4A00394@T00dT00E494@TA0029003A2@T00DT00=494@00b@00d@TA002A00394@T00Q4
00<TA2@00T@012A4A4@29003A2A400940VP2A09X00=4J8P00XP00fR8J002J003R6QX00AX00J<R8R8
J8P2[00<S<c@d<c@c=2/dM3A1M000lb/c004[0:<0Z`2S0>80j`2R06<0J`1S00074@01BA4A4@T00A4
00<TA2@00T@00bA4A007A08T2T@3J0>80h`9[0B<18P00hb8[002R005S:b/[<`00m05d@Ga00?Ad<`0
0m04c0;@00_Ad=3@dO7Ad?7Al@05d007dM3<c=2/c004[0:<0XP2[0>816P3R004S:b/[0:<0Z`4d0ce
00GimOWen@0;m@04nOGin@Ce00?imOD01OD00oWem@0Cm@03nOGe00?e00?imOT00_D01?WenOT4m@Ci
00?enOX01OTJm@03d6Q4009400<TA4@03D@01FR8[=3A00We0_T3m@04lM7ed0?a0]400o7el@05l@06
dO7AlM7@0_48m@03lOGe00?a0_D00o7em@02m@;@00?edO400]000jc@d004[003d:b/00>/0]05m@03
dLb/00>/00C<dM7a0]001?7elM42d003c:b/00:/0h`01HR<R6R8009X1D@2R0:<00>/d=400m02c0:/
0hP2S003R6QX00=X00B8d?7e0m402_7AlM7@dM3amO47m@;A0Z`2S005J4A4A2@01D@390941B@2A008
J8cjn_Gjc8P2A1LT00=492@02R@00d@TA0099005A2A4A2@00T@:9005A2@T94@00b@2A0LT0d@89003
A2@T00A40R@@A00494@T90A41FP2A003R6QX00R80fP7R0:<0j`00m2/d003d003dLc@00;@00C<d<b/
0X`2[005R8b8J8`00XP00jb8R004S0>80H`1[00074@00bA4900@A00394A400M400<TA2@014@3J0B8
00=XS:`00j`00lb/[002[003S:b<00:<0XP018b8R8`2R0:/00><[:`01]001=7@lO42d@;a00CAd=3<
1=001Lc@d?7@00GA0m000m7@d004d003[<c<00;@00G<[8R8[004S0:/0X`2R0=X00F<R8R/S002[008
S:b/[=3<d=4@m@;i3?D00oWen@06m@03nOGe00;e00?imOD06OD00oWem@04m@?i00?enOD01_T01?[i
nOX2nA[e00?@R4@04d@01FR/c=3a00Se00?imOD00_D4d@;a00?AmOD00_D01=7amO42m@04dOGAl@;A
2_D02]7emO7AmO7edO43m@05lM3edO400]001/c@d<b/c0;@1J`01Lc@mOGi00;e00Ga[8b8[002d003
lM7A00?@0_D00m7@d@02d0:/0X`01Jb<R6R/00:800EXA6QXA002J0:80Z`00lc@d003d0;<0Z`00hb8
R002S003R:b800=X00B<dO7a0]400oG@d@02d@05mM3amM400_D00o7el@03m@04lM7<d0><0T@01RA4
A4@TA0DT00=492@00R@3A008J?Gjn_Gjd6P4A0<T00=492@012@2A00494@TA0XT0T@49003A2A400=4
00<TA2@012@2A00394A400=43R@00d@T90039003A2@T00@T0d@39004A2@T909400<TA4@00T@012A4
92@=A0<T0T@012A4A6P4A0=X00A4J8QX0XP00fR8R003J0:800><R8P01HP01fR/S:c<d:`00m001Lc@
d=3<00;@00?<[:`01J`018R<R8`2R006S6QXS8R<0j`2S06/000MA00394A401E400<TA4@02T@2J005
R6R8J8P00X`9[006c:b<[8R<0hP01FR8S:b<00>/0/`01:cAd=42d0;A00?@lM400]400m2/d003d00:
c=3@dO7Ad?7@d@;@0]43d004dM3@[0;<0]02[0>80X`01XR/S8b8S0>800=XR8P00XP2S0N/00?<d?D0
1?D00oWem@03m@03nOGi00?e00?imOT01OD00oWen@02m@Ci1OD00oWen@02m@03nOGe00;e00?imOD0
4oD4n@04mOWim@?i00CjmOGe0_T01?[inOX5n@ce00?imOD00oD00oWem@02m@06nOGemM2814@00bA4
A008A007J4A4J4B8[002d003lOGe00Ge0_T01_GimOGAd0;e00C@dOGa0_D2d@04d?7el@;e00K@mM7@
lM02m@03lOGe00;e00?AmM400oD01=7emM42m@06lOGAmO7A0_D00m7ed@02d@03d:c@00;@1J`00m7@
l@04m@04d<b/R0;<00C@lM3A0]002?7elO7@dM3<0]001:c@S8`2R09X00R8A6R8J8Q4R0F/00SAd?7@
dM2/d0:/00>8[:`00Z`00hQXJ002J00<[?Ged?7AlOG@mO7@1?D01?7emO42m@05lOG@dM000Z`00hQX
A005A08T00=494@01R@4A00:J?Gjn_Gj[6Q490942R@2A0<T14@69003A2@T00@T00A492@T14@490U4
2R@2A00494A4A0HT0T@390A41R@00d@T9003A08T3d@290=400<TA4@014@4J004A6QXS0>81VP01HR<
[8QX00J800J/R:b/d:`3d0:/00C<d=3@0/`4[003S8R<00:/0XP00hb8S002R0>/00><[:`00X`1[000
74@00bA4A00JA00394A400M40XP00hb8R002R007S:b/[=2/S005[003R8b800J800J<[:b<[8`3[005
d=7ad=400m001M7@dM3A00W@00?AlM400o42d@O@00?Ad=000]001/b/c:b8S0:800F<[:b/S004R003
J8R800:80X`00jb<[003[003c=3e00ce00KimOGimOT>m@03nOGi00;e00KimOGimOT2m@03nOGe01?e
00?imOD00_D2n@06mOWemOWe0_T01_[inOGinP;i00?enOT00_T00o[en@0:m@03nOGe00_e00GimO6<
J00>A0=X0T@00hR/d002l@Se0_T3m@;@0o401=7@dO42m@04dO7al@;e00KamM7adO44m@07lOGelOGa
d002m@03lOGe00;e00?amOD00oD01O7edOGa00;e00Cad=3@0]402=3<[:c<[=3A1OD00m2/R002[0K@
00?adOD00m400m2/[002c0:/0h`4R003J8R800:800EXR:c@c005d0;A00?@c<`00j`2R003[8b800=X
00J8c?7elM02m@;a0]400o7Am@04m@03lOGe00;e00?AlM000]000jb8J006A00394A400<T00=492@0
0R@5A007dO_jmOV8J003A0/T00=492@00b@014@TA4@99004A2@TA0<T1D@290M432@2A10T1D@790=4
0b@6A00394A400=400<TA2@00R@;A0MX00>8J8P00VP9R006J8R8R8b80j`02Hc@[=3<d<c@c004d0?<
0Z`00lb<S002[0J80X`01Zb<S:b<[0:<000=A00394A400U400@TA4A40R@00d@TA003A00394A400m4
00LTA4A494@T00A40VP3R0B<00>8S:`00j`3c0;@00J/d8b<R8`2R003S8R/00:<00G<[:c<[002d006
lM3<c=3<0m000o7Ad006d003dM3A00;@00?Ad=403=02c003[8b/00:<0hP3S0F80VP3R003S8R<00F<
00>8[=003?D00oWem@02m@;i00?enOD01oD01oWenOWenOD00_T4m@03nOGe00Ge00CimOGi4_D00oWe
n@02m@0;nOGenOGin_WenOD00_T00oGin@02n@05mOWimOT02_D00oWem@0;m@03nM6/00A400<TA4@0
1T@02FQ4J8QXA6R<[002d003lOGe00Ge0_T3m@04lOGam@;a0]42d005lOGedO400oD00o7em@02l@Oe
00?amOD01OD00o7em@02m@03lOGe00We00GadO7Al@03d0:/00C@c=3@1OD01Zb8[:c<d0>/0]000o7e
m@02m@;A0/`2d004S8R/[0><0XP00fR/R003R003S:c<00?@00SadO7ad<b/d0F/0X`00hQXJ002R003
d?7e00Ce00?amOD00_400m7am@08m@03lOG@00;@0Z`2J0A400@TA4A40R@2A0DT0d@00fSan`02nP03
lHQX00=40b@00d@TA00@9003A2@T00@T00A492@T0d@290A40b@2A00394@T00/T00A494A42R@00d@T
900390=42R@2A08T2T@00fQ4A002A00394@T00]40VP00dAXJ003J003R6R800:<00>8J6P018P2J0F8
00B/S8b80X`01]3<c<c@c0;@00?<[<`01J`00lb<[002[0:80h`00jb8[002R004S:b<S06/000MA003
94A400M400<TA4@02T@01BA4A4@T00]40VP6R0>/00?<[:`00Z`00lb/S004[004R8b<[0:<00>8[:`0
1:`00lc@d003d0;<2M000jc@d002d003c=3@00;@00S<d=3<d<c@c0C@00CAd=2/0X`3R007J8b/S8R<
R005J005A8R8R6P018P01Zb<[:c<d1oe00CimOWi9?D00oWen@02m@06nOGenOGj0_T4m@04nOGen@;j
1OT2m@03nOGe01Ge00?@J4@02d@00fQ4J003J003S:b/00?@2?D01_WemO7Am@;a00?elO400]03l@We
00?amOD02_D3l@03mO7e00?e00CamOGa2OD2l@04dO7Ad@G@00?edOD00oD02?6/S:c@[=3<0Z`2d005
lM7elOD00]43d0:/00C@S<b/0h`3R0:<00>8S8P00Z`3d0;a00CelM7@0l`01:c@[:`2S0B800>/d?40
1?42m@07dOGedO7el@03m@06lOGemO7A0m02c003S8QX00I412@2A0DT0d@01VR<n_GiR09400<TA2@0
1B@00d@T90039004A2A4A0XT0d@00bA4A00390Q43R@4A08T1D@99003A2@T00E432@@A08T1T@00fQ4
9004A0aX00>8S8P01HP01VR8R8QXS0>/00B<R:b<0m000lc@c002d0;<00?@c<`00j`01<b/d<`5[004
S:b/[0:800><[:`00XP001]400<TA4@014@01BA4A4@T01Y400=XA4@00fP00hR<R002R003[8b/00B/
00?<[:`01Z`00hR/S002S004R:b/S0F/0/`00m3<d003d003S:c@00F/00?@[:`00]001m7@c<b/c=00
0/`2[007c=3<d<c@c002[003c:b<00B<00C<S8R<18P018b8J:`2R003S6R800:80X`3[003dOGe00ge
00?imOD00_D00oWem@04m@04nOGem@;i00GenOWen@02m@03nOGe00;e00?imOD05_D00oWem@02m@03
nOGi00;i0_X00oGin@03m@Ci00?jnOT00_T00o[im@0@m@03nOGe00?e0_T2m@03[4A400Y400=XA6P0
0T@01FR8R8S<00;@1_D4n@;e00GadO7Ad002m@03d=7a00;e00CAmOGa4oD2l@03dOGe01Ce0]44d003
dO7e00Ce00?A[:`00/`00m3e[002[0?@00?AmOD00oD01O7Ad=2<00>/0X`01:c@[:`2S003[8R/00B/
00?<d=400]401OGAd=3<00>/0h`2R005S8R<c=000]400o7el@04m@03lM7a00;e00CamOGa0_D02_7A
d=3<[=3<[6P4A00494A4A08T34@2J003R6Q400942R@2A08T0T@00bA4900790=400<TA4@00T@39004
A2@T90A42b@>A08T00=494@01B@2A00394A4009412@014@TA4@390m40R@3A0<T1d@3J004R6QXJ0>8
00E4R6QXR002J0>800><R8P00XP026R<S:b<[8b80Z`3d004[=3<d0;<00K@c:c@[<`2[0;<00F/c:b/
c004[003S:b800><0Z`002140R@<A00394A400M400<TA2@01T@2J003A6QX009X00F<R8R8S002[003
c8b/00B/00><[:`00Z`018b8[8`3[004R:b/S0:/00CAc=7@0/`2d0B/00?<[:`00Z`01]7@d=3<d0;<
0j`01=3<d<`2[007c=3@c:cac003[004R8b/J0><00?<R8P00X`3R003J8R800B80fP01XR/[:c@d@_e
00KjmOGimOT2m@03n_Ge00Ke00KimOWimOT2m@03n_Gi00;e00KjmOGimOT2m@04n_Gen@Ge00?imOT0
1oD01?WemOX2m@03nOGi00;i00CjnOWi1OD01?WenOT3m@07nO[en_WenP02m@03nOGi00;e00CjmOGi
0_D01?WenOT4m@05n_Ge[8P03D@00fQ4A003J004R:b/l@Ge00CimOWj0_D00o7Al@03d0;e00Gad?Ge
l@0Gm@04lM7el@Ke00?imOD03?D2d@03[=3@00;@00Ced?Ge0_401<b/[:`3d0>/00C<d=3@0oD00o7e
m@03d003S=2/00B/00?@[:`00j`2S003c:b/00?<0]001]7amM2/c0:/0X`2[004S8R<R0:<00J/d=3A
mO44m@04lOGAm@;a1_D2d003c:b/00>/00=XA4@04T@00bA4A002A004J4A4A0XT00A492@T0T@29003
A2@T00<T00=494@00T@012A494@39003A2@T008T0d@<90E400@TA4AX14@29003A2A400LT00=492@0
0d@01BA494@T00A412@;A0<T0d@3909400<TA4@01D@01HR/R8QX00:800EXA6Q4R002J0^800J/S=2<
[8`2[0;@00GA[=3@[002d004c=3<d0;<00J/dJb/c:`2d004[=6/d0J/0H`1[06/000QA00394A400Y4
00<TA4@02D@00bA4A004A003J4AX009X00=4J8P00XP2S0B/1<`00m2/[002[0;<00N/c=3<d:b<00:/
00Z<d:c@c=2/d:c@0Z`00hb/[006[005d<c<d:`00]02[003c:c@00B/00?<[:`00]02c0B/0XP018b/
[8P2S005R8b/S6P00hP02XaXR8b8J8b8[8`2[003c=7e00We00?imOD00_D00oWem@07m@;i1?D4n@;e
00CjmOWi0_D00oWen@02m@03nOGi01?e00[imOWimOWenO[i0_X00oWem@06m@;i0_D3n@;e00?imOD0
0_D00oWen@02n@Oe00?imOD00_D3n@03mJaX00Q400=XA4@01D@016Q4J8P2[003d?Ge00We00[adM3a
dM3amM7a7?D00m7em@0Dm@03lM7@00C@00SAlOGelM3<[0C@00?A[:`01M000o7em@02m@;@00Z/d:b/
c=2/c:c<1Z`3c0:/00G@c=3<d002m@04d<c<c0><00>/S8P00XP018b/S:`3d0;a1OD2l@Se00KadM3<
[8`2[003S4AX00e400<TA2@00d@00bA4A006A14T00=492@00d@290A41R@3A0<T0d@590=412@8A003
J4A400=400DTA2@TA0069003A2A400=400DTA2A49004A0DT2T@012A4A2@2A00494A4A08T14@4J0B8
00=XA6P00fP4R006S8R8S8R<1XP2S0:/00><[=001=001:b8[<`6d0?<0Z`00m2/c002[003d<b/00>/
0X`1[06<0J`001e400DTA4A4900DA00394A400Y400AXR6QX18P4S004R:b/[0C@00?<[:`02=02[00<
S:c<d?6/c:c@c=3<1:`00hb/[002[0;<1:`00lb/d002d004[<c@d0B/00><d:`00/`2[0:<0XP00hb8
S002[004S6R<R0=X0hP01FR8A8QX00:800J<[8b/d?4Om@Ci1?D4n@Oe00?imOD01OD00oWem@0Am@03
nO[j00;j2?D8n@Ke00?imOT01oD5n@?e0_T00oG<J00CA004S:b/d0ce00[Ad?7Ad=7ad=7a6oD00o7e
m@09m@03nOGe00We00?adM000/`2d@05lOGemM000Z`00lcAd003[0;<00CAd=3@1=401OG@dLc@00:/
00c@[<cec:c@c:c@c=44d004[<b/S0:/00CAlM3@2:`01Xb8R:b<[0;@00?elOD01_D01?7elM44m@03
dOGa00?@1:`9A003J4A400M400<TA4@00d@29003A2@T014T00E494A49006A00394@T00LT0T@01BA4
A2A4008T14@2909400<TA4@01D@2J004[4AXA0<T1D@00bA4A00@A08T0T@00bA4A00;A00394A400=4
1B@2A09X00>8J6P016P2A003J8QX009X0XP01Xb8R8b8S0:800><J8`00X`03hR/[:b<d:c<d<b/c:c<
[009d0;<1J`01M3<[:b<00:/0H`1[06<000:A00394A400m400<TA2@02T@00bA4A005A08T0d@00bA4
A003A00394A400A400IXR8QXR8`3R0><1J`3c005d:c@d<`00m000o7Ad002d003c=3<00;@00?<d<`0
0/`02M3<c:c<[8b8S00:[004c:b/[0?<1J`00m2/d002[003R8b800>80j`2R003S8R800=X00J8S8R8
J4@3J0:<0j`00m3em@0:m@03nOGe00Ge00CimOGi1oD5n@04mOWen@;e00GjmOGim@02n@03mOWe01Ce
00GimOGim@02n@03mO[j00;j00?imOD01?D3n@;e0_T01OGjnOGj00;e00KimOWimOT2m@03nOGe00Ki
0_D01_[imM68J19400IXR:b/mM4:m@03dO7@00;a00CAmM7@0_D00o7em@0Km@03lOGe013e00GamM7a
c002d@09mO7elM3a[<ca00;@0Z`01hc<[=2/d=401M001]7ad=3<d@;<0]000lb/[002[0?@00?Ad<`0
0j`02HR<[8b/d=7@c004[0:<1XP01Jc@dM7a00We00?AmOD01OD01?7@d=02[0:<00>8A4@01D@5J0E4
0R@3A00394@T00PT0T@69007A2A4A2A49004A00494A4A0PT1T@291=400AXA6R80VP00d@T900;A003
94A400Y40b@8A003J4A400I400<TA4@01b@4A0EX0T@018QXJ8P2A0=X00>8J8`01HP01Hb8S8R/00:<
2:`02Lb/[:b<c:c<R002d006mM3<d:c<0Z`01?7<dL`3[004c:b<[06<000:A00394A400m400<TA4@0
0T@290i400<TA4@00d@00bA4A00290=400HTA4A4J8P3J003S8QX00:<00N8[:b<[8c<00:/0]001Lc@
c?F/00?@0_D2d003mM7@00K@00J/c=3@c=06[004S:b/c0:/00?<S8`00Z`01M2/[=2<00R/0hP00jb8
R003S0>800><R6P016P2R005S8QXA6P00XP01Jc<[:ca00Ge00?imOT00_D2n@Ce00KimOGimOT2m@06
nOGenOGi0_D3n@04n_GenP;e00?jmOX00_D01?[emOT7m@03nOGe00Ge00CimOGj0_D00oWen@02m@07
n_GinOGjn@0:m@07nOGinOGjm@02n@05mOWemOX00_D00oWem@05m@;i00cenOGen_WjmM2/S6P>A004
J4A4J0:800?@dO401?D00oWem@03m@08d=7ed?7edM0;m@03nOGi00;e00GimOGel@05m@03lOGe00ke
0_T00oGim@07m@03dM3a00Ce0_401<b/[:`2d0:/00>8[=000]02c0;@00GAd=3@l@06d003[=2/00;<
0j`01m3ad=3<[<`00Z`018b/R:`3d0>/00C<[8R816P00hR<d002d@03d?7e00Se00?amOD01OD01o7A
d=3<[8`00XP01FQ4A4AX00940fP:A00494A4A0XT00A492@T1T@5909412@00d@T90049003A2AX00A4
00<TA4@00R@4A00394A4008T0d@00bA4A004A09X0d@29003A2@T00e40R@3A00494@TA08T0d@016Q4
92@9A00594@T94@012@6A004J4AXJ09400=XA6P00fP00dAXJ002J0>80VP5R005J8QXJ8P00X`2[005
S:b/S=001J`01M2/d=6/00?@00W<[=3@c=3A[8P01j`001a400<TA2@00T@00bA4A00:A003J4@T00Q4
00<TA2@01d@4J0N800><[8`01:`01M2/c<c@00>/0]000m7al@02l@05dOG@d=400]000lb/c002c004
d<c@S0F/0X`00jc@[009[004c:b/S0J/00>8S8`01HP01Xb8[8R<R0EX00><J8P00fP028R<[8R/c=3A
2OD01?WemOT7m@03nOGe00Se0_T01_GimOGim@;i00CenOGi1OD01?WemOTBm@06nOGinOGi0_D01?[e
mOT3m@03lOGe00Ke0_T01OGinOGi00;e00?imOD00_D00oWem@03m@04nOGen@Ce00KjmOGed8PBA006
J8R<[?7A2OD01?7@mO42m@04lM7@lCOe00?amOD00oD2d003c8b/00:/00?@[8`01:`00lc@d00:d003
dLc@00;<00>/d<`00m02l@05d=7@[8`00Z`01=2/[8`3d0:/00C<d8b81FP018b/[=02d@03lOGe00oe
00Kad=3@c:`3R09X0T@00fQ4J003J0Y400@TA4A442@2A1HT0T@00bA4A002A0HT00=494@00T@012A4
A4@390Q40b@7A00394@T00M400<TA2@012@014@TA4@29004A2@T90=400<TA4@01D@290940R@6A0=X
0XP5J004A6Q4A0AX0hP2J004R6R8S09X00>8J8P00XP00jb<R003R0:/00F<c8c<[002c0?@00f/d=3<
d<b/d<c@c:c@00B/0/`000a400=XA4@03T@012A4A2@9A00394A400A400<TA4@00T@490U41VP3R003
[8R800>80X`00jb8R004[003S:b/00?@00CAlM7A0_400m3Ad005d004[=3<d0B/00?@c:`03:`00hb/
[002[003R8b<00:<00>8S:`00hP01Hb8R8QX00:800IXR8R8J8P6J008R8b/S:c@[=0Fm@03nOGe00Ke
1_T2m@;i00?enOD00_TLm@03nOGe01Ce1?T2m@;i3?D2n@Ke0_T2m@03dHQ4011400MXA6R8[=3a00[e
00?amOD01?D00m7em@0Ym@03nOGe00[e00?AlOD00_D01?7@d=43[005c=2/c8`00Z`02/c@d:c@c=3<
d:`3d003c=2/00?@00K<d<cAd=42d003dM2/00:/00?<[:`01:`01Lb/[:c<00:/00F<J8QXA002J006
R:c@dM3a4OD00o7@d002d003[8aX00=X0T@5J003R6QX00=X00=494@01D@A90944b@014@TA2@4A003
94@T008T0d@29003A2A400A412@00d@TA005A08T2T@00bA49005A00394@T008T1D@690A400<TA2@0
0T@390=40R@7A005R6R8R6P00XP2J09416P2A005J8R8J8P01fP4R004S8R8R09X00>8S8`00j`2c0:/
00?@c:`00/`01=3<c:`3c003[8c@00;@00?<[<`00L`001E400<TA4@00d@01RA492A4909400<TA4@0
1D@01BA494@T00940R@3A00394A400Y40VP018QXJ6P2R09X0XP00fR8R002S0:80X`00jb<c003[005
c=3@dO400]402?G@d<cAd?7@0/`00m2/[005[003c:b/00R/00><[:`00X`00hR<R006R005S8QXJ8P0
16P018QXJ6P3R003J8QX00940VP2R004[8b/[0;<00?AmOD05?D00oWem@06m@03nOGe00Ci00?enOT0
1OT01?GimOT9m@03nOGe00ge0_T00o[en@0<m@03lOGe00;e0_T01O[enOWe00;i3?D00oWem@05m@05
nOGemHP054@016R/c=47m@03nOGe00?e00CamOGe0_4?m@03nOGe01We00CimOWi1?D01_WemOGAd0;e
00OamM3Ac8b/00;<00?@c=001j`00lb/c004d00:c=3@d:c@c=2/c0:/00?<d=001M04c003d:b/00:/
0]001Lb/[8b8009X00E4J6QXR002[003d=7A00;e00?amOD01?D00o7em@05m@03lM3@00;<00O@[8QX
A8Q4009X00=4J6P01VP9A0hT00=494@00d@39003A2@T00<T0d@690940R@5A0@T0T@39003A2A400A4
12@6A00394A400Y400<TA4@00T@00bA4A002A00394@T008T0T@00bA4900590A40R@9A00394A400M4
1FP00hQXJ003J003R8b800940VP00hQXJ007J005R6R8J8P01FP00hb8R003R003S:b<00J/00EXS=3<
[003c003d<b/00?@0L`1[0002T@00bA4A006A00394A400E400<TA4@00d@00bA49003A00594A4A2@0
0T@00bA4A00390=400<TA4@02d@2J0B80VP00hQXJ007R0:/00F8[:b8S002[0C@00G<d=3@m@02d006
dLcAd:c@2:`00m2/[004[003c:b<00:/0X`6R009J8R8R8b8S6Q400IX0T@00fR8J002J0:800MXA6R8
[8R<00B/00?@mOD00_D00oWem@02m@;i0_D00o[em@05m@06n_GenOGi1OD00oWem@02m@;i00GenOGe
nP02m@03nOGi00;e00CjmOGi1oD00oWem@03m@03nOGe00;e00KjmOWjmOT2m@04n_Gen@We00GamOGe
n@02m@08nOGjmOWjmOT2m@03nOGe00oe00?A[6P044@01FQ4J4B800;@1?D01O7enOGi00We00GAmOGe
n@02m@03n_Ge00;e00CimOGi7OD00o[in@06m@03lOGa00?e00?AmM001:`00m2/d004d0>/00?<[:`0
0j`5d003[=2/00;@1j`00m3<d007d003[=2/00;<0m001jb<R8QXR4@00fP2R003[=3a00Ce00KamO7A
mO47m@04lM7@c0;@00?<[8P00VP01HQXJ6Q400UX2d@00bA4900;90E422@00d@T9002A0<T0T@00bA4
9005A0<T0T@290940R@4A0@T00=494@00T@012A4A2@;A08T0T@00bA4A005A00394A400M40R@4A08T
2D@00bA4A003A09X0T@01FQ4A6Q400EX00=4J8P016P00hQ4J004J004A6Q4A0=X0XP3J003R6QX009X
0XP3S004R:b/d0:<00J/R:c<[=02[004dM3Ad@C@0J`0025400<TA4@01D@00bA49004A08T0T@012A4
A2@=A003J4AX009X2XP018b8R8`3[0:<1:`00m2/c003[0?@00?Ad=400]000m7<[002[003c:b/00>/
00?@[:`01Z`2S005R8b8R:`00hP00hb8R002R005S8R8A6P00XP00fR8A002A0AX00N8J6R8A6R/00:8
00><[:`00Z`00m7em@06m@04nOGen@;e00CimOGi1?D01?WemOT7m@05nOGenOD00_T00oGin@04m@03
nOGe00Se00?imOD00_D00oWem@03m@03nOGe00;e1?T7m@03nOGe00Ce00?amOD01?D01OWenOWe00Ci
2_D2n@[e00C<J4@T44@2J004R:cal@Ke00?imOD01oD01_7AlOGim@;i00?enOD01_D00oWem@02m@03
nOGe01Ge0_T9m@03lOGe00;e00?Ad8P00j`01<b/d=03d@03d<b/00>/00R<[:c@c:c<d0:/00f<d<c@
c=2/R:c<[=3<00G@00S<d=3@c=3<d0:/00><R8P00XP02FQ4A6Q4J8b/d005m@03lOGe00Ce00?amOD0
0_D3l@?@00G<[8R8J002R0MX00=4J6P00VP;A14T00=492@042@5A00394A400=400<TA4@00T@01BA4
A4AX00E41B@CA00394@T00@T0T@290E400<TA4@00T@390M400=XA4@05D@3J09400AXR6R80VP00dAX
J003J0=40VP018QXJ8P4J003R6QX009X00>/S8`00XP018b8[8`2[005c:b/c:`00m001=7@d:`2d0;<
000:A00394A401e400<TA4@01T@290E400<TA4@02D@01FQ4A6R<00F800><R8P018P00hb/S004[004
S:b/[0:<0j`00m3<d002d003c=3@00;@00O<d=3<[<b/00;<1=000lb/d004[004S:b<R0:<00>8S8P0
0hP01FR8R6Q4009X0hP2J005A6Q4J8P016P01DAXR8R<00:/00><[=005_D01_WemOWen@Oe00?imOD0
0_T01OGimOGi00Ce00?imOD04OD00oWem@04m@;i1_D00oWem@06m@04lOGal@?e1_T00oGim@0Em@03
dM2801=400AXS=3a3_D00o7em@07m@03nOGe02oe00?amOD00_D01=2/S8`2[0C@00?ad=400]05[003
S:c<00N/00G@c=3<d005[004c:c@[0G@00Cad8c<0j`01Xb8R6R8J0940VP01TAX[:cAl@Oe0o400oGA
m@03m@03lOGa00?@00C<[6QX0hP2J00;R6QXR6R8J8QXA6P02D@D90=400<TA2@02R@>A00394A400a4
0b@01D@T92A400<T14@01BA4A2A400LT34@01BA4A4@T011400=XA4@03d@00fQ4A002A09X00=4J6P0
0T@3J0M40VP2R09X00B8J6QX0hP00hb8R002S003[<b/00:/00?@c<`00m000m7@d@02d0?<0Z`000i4
0R@5A08T0T@01BA4A4@T00Q40R@5A00394A4009400HTA4@TA2@=A0EX00>/R8P02hP00hb/S002[0:<
0j`01HR/S:b<00>/00C<[:c<1m001:c@[=02c004d<c@d@;@0Z`01/b/[:b8S0:80h`2R004S8R8[0B8
00>/R8P00fP00hQXJ003J005R6Q4J8P01Z`00m3em@03m@03nOGe00ke00?imOD00_D01?WemOT5m@06
nOGinOGi0_D00oWem@02m@04nOGen@Ce0_T01?GimOT6m@03nOGi00;e00KimOWimOT2m@04nOGin@Ge
00OamOGelOGa00Ce0_T01_[imOWen@;e00?imOD01OD00oWem@07m@;A00B/J4@T4D@01Hc@d?Ga00Ke
00?imOD03OD01?WemOT5m@03nOGi02;e00?amOD01OD01M7@[8R<00B/00?<dM400_44d003[<b/00?<
1J`00m3<d002[006c=2/S:c<0Z`01Lc@[:c<00C@00G<d=3<[002c0>80fP2A0:800EXS:cAl@03m@;a
0_D00o7el@02m@03lOGe00;e0_401]2/d=28J0>800IX[8R/R6P2S003[8R800AX0d@016Q4A4@D9094
32@014@TA6P2A003J2@T00E400DTA4A4900<A0@T00A492@T0T@29004A2@TA0hT2D@290I40b@LA003
J4AX00M400=XA4@02d@7J004R6QXJ0:80VP01jb<[=2/d<`00Z`2d009lM7AdM3<d:c<00;@0L`001a4
00<TA4@02D@00bA4A002A00394A401M400=XA4@00VP3R0F<1HP2[0:<00>8S:`00X`00jb8R002S003
[8b<00J/0/`00m3<d003[003d<c@00;@00?Ad<`00]001m7@d=2/c:`01X`02Jb8R8b8[8R<[009R09X
00>8J6P018P2[004S:c<d@Ke0_T:m@06nOGenOGi0_D01?WenOT=m@03nOGe00;e00?imOD01_D7n@03
mOWe00?e00?imOD00oD00oWen@04m@03nOGe00ge00CamOGe0oX00oWem@02m@03nOGe017e00?@c6P0
1D@00bA4A007A008J4A4A8S<d?4<m@;a1?D00m7em@0:m@04nOGenB7e00CadO7A1OD01M7@[8R/00;<
00G@c=3<d@02m@04dO7@d@;@0/`2d003c:c<00>/0]0018b/[=05[003d<c<00>/0]02[0G@0Z`2R003
J4A400940VP01XQXS:c@d@?e00[@dOGedOGAlOGa0_D03?7elM7@[=7@[8aXR09X0j`00hb8R002R0MX
00=4J4@00d@99003A2@T00DT00E492@TA00490941R@014@T94@59003A2A400I400<TA4@01d@00bA4
90059003A2A400=44b@6A00494A4909400@TA4@T14@00bA4A00?A003J4A4009X0d@00fQ4J002J0i4
0VP00dAXJ008J0:80fP2R006J8b/d:c<1]001?7AdM44d004c:b/c06/000KA003J4@T00=400<TA4@0
1D@00bA4A00@A00394A400e400F8J8R/R002S0F800B<[:b<0XP018b8R8P2S0:/1HP00hb/[002[003
c:b/00;<0Z`01<c@[:`2d0;A00?<d=000m001lc@[:b<R:`00h`01Zb<[:b<R0:<00F/S8R8S002R004
S8QXJ0:800AXS:b<0XP3[003R<cA00ke00?imOT01?D00oWjm@02n@05mOWimOT00_D01_WemOWen@;e
0_T00oGim@06m@03nOGi00?e00CimOGe0_T5m@08nOGenOGimOT5m@03nOGi00Se00OamO7ed?Ga00?e
00Cin_Wi0oD00oWen@08m@03nOGe00Ge00GimM7@J002A00394A400M400AXA4AX0d@01HS@d?7A00_e
00?AlOD00oD00m3el@03d0;A1oD01?WemOT9m@03dOGe013e00CamO7e0o44m@03lM7@00><00J/d<c<
d:`2l@Ge0]001lc@d=3<d:`00]000jc@c002[0:<00J8[8b/c=02[0K@00F/d=3@c002S003[6R800E4
0VP01HaXR:c@00Ce00?@mO400_D01]7emM3el@;e00K@mO7@mM02[0:800?@R8P00XP00jb<R003R007
J8R8A6Q4J005A0lT00=492@02B@01D@T92A400<T00A492@T0d@00bA4A009A003J4@T00Y40b@00d@T
90029004A2@TA08T00=492@03B@5A00494A490E400<TA4@00d@490e400EXA4A4J003A005J4AXA6P0
3D@5J003R6R800EX0XP00fR8J002R0><00[<d<cAd=7@[=3A0]000lc@d003d004c:c@c06/000AA003
94A400Q400DTA2A49009A00394@T00=40R@5A00794A4A2A49002A08T00=494@01D@00fQ4J002R004
S8R<R09X0hP00hb/S002[006R:b<R8b80h`00jb<R002R0B<0j`01Lb/c:c<00;@00G<d=3@d@02d003
dM3@00C@2J`00hR<S003[003S:b<00>80X`00jb8R004R0F<0j`00hc<l@0Gm@Ci00CenOWi1oD01oWe
mOGimOT00oD00oWem@06m@;i00?enOT00_T7m@03nOGe00;e0_T7m@03nOGe00Ge00?amO400]400oGa
m@03m@03nOGe01Ge0_T01?Ga[8PBA004J8R/d0;A2oD00o7em@04m@05d<b/[<`00]000m7em@03m@04
nOGin@[e00?amOD03OD2l@Ge00?AlM401OD01M7<S8b800F/00?<d?D00oD01?7elM44d0;<00N/d=3@
[=2/00B<1:`2c004d:c<[0;@00?<[=000]02S0>800=XA4@00fP02TAXJ6R<[=3AmO45m@05dOGalOD0
0]001?7AmO44d003c:b/00><0XP3[003S8R<009X00><J6P024@I909422@3A08T0d@00bA4A005A0<T
00=492@00T@490=40b@2A0LT00A492A43B@01D@TA4@T00I400<TA6P00T@012A4A2@3A08T00=494@0
4d@00fQ4J006A003J4A400E41VP3R0EX1hP01Jb<[:c<00S@00?Ad=001M02c06<0J`1[0004T@012A4
A2@>A00494A490U400HTA4A494@290I400@TA4@T1d@01FQ4J6R8009X0XP00fR8R002R004S:b<[0><
00B8[8R/0h`02HR<S8b8S<b/R002[005c:b/c:`00/`5d003c=3@00;@00Ced=3A0]02[0;<0j`00hb/
[006[006S:b<R8b/0hP2S004R:b/[0><00G<[:b/c007m@04nOGen@;e00?imOD00oD00oWen@02m@;i
00CenOGj0_T6m@06nOGenOGi0_D01OWemOWe00;i00KenOGenOD5n@05mOWimOT00_D01?[inOT4m@03
nOGe00;e00CimOGi1?D01O7edO7@00;A00?ad?D01?D01?WemOT2m@04nOGin@Oe00GimOWim@02nP06
nOGAd8QX44@2J0:80]001LcAdOGa00Oe0_42m@03lOGA00?@00G<d=3@c003d004lOGen@Ce00?imOD0
5OD01]7emO7el@;e0]45m@04d:b<R0:/00N<[:c@[?7A00Ge00CamO7a0]000lc@[002d003[=3@00V/
00?@c=000]001/c@d=3<d0:/00><R8P00XP3A0IX00F8S:c<d004l@;e00?amO400_400oGal@03d@04
lM3@d0?<0Z`00fR8R005[006S8R8J8R<0XP016Q4J6P4A0<T0T@B9003A2@T00PT0T@00bA4A004A003
94A400E412@2A0DT14@00bA49002A00494@TA08T0d@690941R@;A0<T00=494@01T@491A400=XA6P0
1D@2J0=40VP2A0=X00F8J6QXR002J0B800AXR8R<0XP5[003d<b/00K@00Oac=3<[=3<00;@00>/S<`0
0J`0029400<TA4@024@290M400<TA2@00T@00bA4A005A00394A400A400=XA4@01VP3R0B<00>8[8`0
0Z`01hR<S:b<R8`00XP01hb/S:b<[8`01j`00m3<d00?d003[<c@00;@00?<[8`00Z`01<b/[8`2[0><
18P01Xb/S8b8S0F/0X`01:b8c=0Fm@Gi0_X2n@04mOWim@;i00GenOWen@02m@03nOGe00Ce0_T2m@[i
0oD2n@06mOWimOWe0_T01_GinOGjm@?i1_D2d@?@0]45m@?i0oD2n@03mOWe00Ke1OT3nP07mO7AS6Q4
900=A004J8QXR0:/0]001M7@d=7a00Oe00?amOD00_D6d0;A00S@c8b/c?7enA7e00?amOD01oD01?7A
d?D2l@;A00?adO401?D03o7@[8b/c:b<c:c<d=7@l@04m@06lOGalM7e0]000jc<d002c003dLb/00>/
00><[=001]001/c@d=7ad@>/0hP016Q4A4@3J0:800AXR:b/0m001m7adO7elOD00o400m7el@02d@05
d?7@d?401J`00hR<[006[0><00B8S8R816P5A0<T00=492@01B@2A1/T1T@00bA49002A0`T0T@012A4
A4@290941R@00d@T900<90A400@TA2@T0T@00bA4900290U400<TA4@04d@2J006R6QXA6Q40VP3A003
J8QX00AX00>8J8P00XP00fR8R002S005[8b<[8`01J`01Lb/d:c<00;@0/`6d003c:b/00>/0H`1[06<
000MA003J4A400=412@EA00394A400e40VP01HQXA4AX00>80X`02hR<R8b/S:b8S:b<00>80h`01Zb<
S8R<R0:/00>8[8`00Z`01<c@[:`7d003[=3@00O@00k<[<b/d:c<[<c@[8R<[0><00R/S:b<[8R/R0><
2:`00o7Am@07m@04nOGen@Ge00?imOT00oT00oGin@03n@04mO[im@;i0_D3n@;e00?imOT00_D00oWe
n@04n@;e1OT6m@03nOGj00;i1OD4n@04mOWin@Oe0_45d0Ke00?imOT03?D3n@03n_We00;j0_T00o7@
S002A08T0T@00fQ4A00;A003J:b/00?@00?Ad=403?D2d004c=3Ad@?a00G<S8R/d003m@03nOGe00ce
00?amOD01OD00o7em@02d@03d=7@00C@00?AlOD01?D01M28R:c@00B/00?<d=000]400m3em@04m@05
lM7elM400m001]6/d=3<R0B/0m02d@08d=7@lM7adO42[0:80VP5A005R6QXJ4@00XP03Hc@d=7@lOGa
mO7AmO400_D02?7emM3edM3A0]02[007dJb8R=2/d002[006d:b/R:aX0XP00fR8J003J0E42R@00d@T
90089003A2@T00PT00=492@012@7A08T00=494@00b@00d@T900790A40R@2A1DT1d@00bA4A002A0HT
00=492@06D@2R004[8R8R0MX0XP00fR8R002J0J800>/S:`00j`2S0B/00B<[<c<1M03[0;@00G<d=2/
c002[004S:b/[06<000@A00494A490=400DTA2A4900EA00394A400A40R@BA0=X00=4J6P00VP018R<
S8P6S003[8R800:<00>/R:`00X`2[0:80X`01:b<[8`4[003d:b/00:/00?@dM000m02[004d<c@d@?@
00?<d:`00/`3d003[<b/00><00>/S8`00Z`018R/[8`4R003J8b800>/00F8S8c<d00Am@03nOGe00;e
0_T00oGin@02n@03mOWe00Oi3OD4n@;e0oT00oGim@02m@03nOGe00?i2?D5n@[e1=000o7el@06m@03
nOGe00We0_T00oGin@03n@06n_WelM280T@00bA4A00?A09X00><[=000]000lc@l@0;m@0@dM2/d=7a
dO7elM2/R=3en@Oe00?imOD01oD00o7em@05m@;A00G@dM7@c002d003dO7A00Ge00C@[8R<0/`01jb<
[8R/c?D01=001]7elOGam@;a00K@lM3Ad<`2d0F/00G<d=3@l@05d005dM3amO400Z`3R003J4A40094
00EXA4AXA002J006R:c<c=3A0_42m@03lOGa00;a00KAmOGAmM02l@07c=3<[<b/c002R003[<b/00F/
00>8[8P00hP01VR8J6R8J0I44b@00d@T900890940R@00d@TA002A0<T1D@39003A2@T00<T00=492@0
1b@4A1HT00=492@00T@290=422@;A003J4A400M416P2A09X0hP00fR8J005R09X00>8S8P018P01hb8
S:c<[=001J`00lb/[003[003d<c@00C@00C<d:c@0j`00m2/c006[06<000=A00394A400=400DTA4A4
9002A00394A4019400<TA4@014@2909400<TA4@014@290Y400>8J6P016P2R003S8R800>800J<R8b<
[8P2S0:/0X`2[004R8b/R0B/00?@[<`00j`00m2/c006d0;<1]000lb/[004[004c=3<[0><00>8S8`0
0Z`01Hb8[8R<00>800=XR8`00X`01jb<S:b8[=001OD00oWem@06m@04nOGen@Ce00?imOT01OT2m@Ci
2?D00o[em@05m@03nOGi00;i00?enOD00_T00oGim@04m@03nOGi00;e00?imOD00_D3n@03n_Ge00;i
2?D00m7ad002l@03dOGe00Ce00?imOD00_D01?WemOT4m@;i00?enOT00oT2nP05mO7@R6P00T@00bA4
A00?A09X00>8[=000Z`00m3Am@04m@;a0_D00o[im@02d0;A1?D01OWedJc<00;e0_T00oGim@0;m@;a
1?D2l@;e0]000m7@d@03d003dO7a00Ce00?ad:`00XP018b/[:`2R004[=3Ad@;@00CAd?G@1?401_GA
mM7@[0C@1:`3d004dM3@l@;A00S@mO7Ad=7@[0:800=XA4@024@016R8[:`2d003dM3a00Ke00?amO40
0_D2l@06mM7@c=3<0Z`2c006S:b<c=3<1:`00hb/S003R0IX14@00bA4900C9003A2@T00dT00=492@0
0b@4A0@T00=492@03B@4A0@T00=492@012@3A0@T14@79003A2@T00<T6D@3J003R6QX00940fP3R09X
00F8J8R8J004R003S8R800:<0Z`3c0:/00K<[:c<[8`2[003d<c@00C@1<`3[004d<c<c0B/0X`2[000
1d@00bA4A00:A00494A490940R@2A0<T00E494A49004A0<T00=492@02T@012A492@5A00394A400M4
16P00dAXJ002R0:<0XP00hb8S005R004S8R/S0>800B/R8b<1Z`00lb/c002[003d:c@00C@00GAd=3@
[002d006c:c@c:b<1:`3S004[8b8J0b800=XA6P00hP00fR8S002S003c=3e01Ke1?T4m@03nOGe00Ci
4_D7n@Ce00?imOD02?D01?WenOX2n@_e0_401=7alO47m@03nOGe00;e00?imOD01OD7n@09n_GemM6/
R6Q4008T0T@012A4A2@8A005J4AXJ8`00Z`01<b/d=48m@;j00KimM3@dO44m@;i00Ced<ca0_D00oWe
m@0;m@03lOGe00Ce00?amOD00]48d003lOGe00?e00?adL`00j`01XR/S=2<[0?@00GAd=7@l@02m@?a
0oD00o7@[003d003[8b/00:/00C@c=3@0]401?7AlM42m@03lM3@00:/0XP00fQ4A007A007J8R<S:c@
c002d003dOGe00We0_401?G@d<`3d008[=7@d=7@[<`2d0:/0XP01:b8R8P7J0A482@014@T94@69003
A2A400A40R@00d@T900990941B@014@T92@4A0DT14@39003A2A400HT00=494@00R@00d@T900>A005
J4A4A2@00T@2J0940XP6J005A6R8J8`00XP2J006A8R<S8R<0XP018b8S8P2S003R:c<00;<00>/c:`0
0/`2[0S@00?<[<`00j`01/b/[<b/S0:/00><R8P00X`1[00074@00bA4A00290E400@TA4A40R@2A003
94A401e400>8J8P00VP4R003[8b/00:<00j/R8R<[8R/S:b<[8b/S0F/00S@c:b/c:c<[0;@00?<[<`0
0m000m7@d002[007d<b/[<c@[002S003[8b/00><1HP2S004R6QXJ0:800F/S8QXA002J0=400=X[8P0
0Z`00m3em@0>m@04nOGem@;i00CenOWj0oT2m@03nOGi00Ci1?D00oWem@05m@03nOGi00;i00SenOWi
mOWen@?e0_T:m@07nOGin_Wen@0:m@07dO7alM7el@03m@03nOGe00Ce0_T8m@03nOGi00;i0oX01_We
mJb8J0I400<TA4@00T@00fQ4A004A09X0XP01Xb/c:c<l@Ce00GimOGen@02nP07lLc@dM3ad@02m@;j
00CimJca0oD00oWem@0?m@07dOGAdOG@l@06d004c=7Al@Ge00K@S8b<d8`4[005d<c@[=000]400o7A
d003m@;a0_D2d@C@00?<[:`00Z`02<c@d=3Ad?7e0_401_GamOG@c0:/0XP7A003J4A400:/00R<[=3A
d=7ed@Oe00?AmOD00_D01]3adM3ed0>/00K@dM3@dL`2d0:/00B<R:b<0XP01XaXJ6Q4J0=45b@00d@T
900B9003A2A4014T00=4J4@00R@014@T92@3A0XT00I492@TA2@2A08T00=492@012@00d@TA002A003
94A400M400<TA4@01d@012A4J6P2A003R6QX00IX00>8S8`018P01fQ4R:b8S8P00X`00hR<[002S004
[8b/[0C<00>/c=000Z`2c004d:b/[0;@00G<[=2/S006[003S:b/00><0j`000m400<TA4@00d@00bA4
A002A08T00=494@01T@00bA4A002A00594@TA2@01D@012A4A2@5A00394A400i400=XR8P00VP2R004
J8R<S0:800B<[8R80h`018R<R:`4S0>/00B<[=3@0Z`2c0C@0/`01jc@c=3Ad:`00m04[008d<b/[8b/
S:`2R007S8R8R6R8S003J003R6QX00=X0T@00fR8J002A006J8R8R<cA3_D01OWemOWe00;i00SenOGi
n_Wjn@Ce0oTBm@03nOGe00Ge0_T@m@Ci2oD2l@05dOGAdO401oD01?WemOT:m@?i00?jnOX00oT00o6/
J002A00394A4009400<TA4@00T@3J0=40VP01Hb8R8b800>/00?AmOD01OD01O7en_G@00:/00K@dO7a
mOT3nP03lJc@017e00?amO400_D01=7amM02d@K@00?edM401OD01M7<[8c@00:/00B<[:b80j`01Hc@
d=7@00?A00?amM401O42d005[=3<[8`00Z`3d006dM3AmM7a1?D01o7A[:b<R6P01T@2J004A6R8[0G@
00?AmOD03OD01?7Ad=42d004[8c@c0R/00B<R8R<0hP00haXJ003J003A2@T00TT00=492@03B@00d@T
9003900302@T00TT00=494@03R@00d@T900290940R@00d@T90029003A2A401DT00A492@T1T@00bA4
A003A0DT1d@00bA4A004A004J8R8J0:800=XR8P00X`2[0>80VP3R0:<00N/S8R8c:b<00>/00?<d=00
0l`4[006d<c@[<c@0/`00m2/c003[005S:b/[8`00Z`00haXR004[0005d@00bA4A007A08T0T@00bA4
A002A00394@T00E400LTA4@TA2A400<T14@00bA49006A00394A400941FP7R0><00B/R8R80Z`2S005
[8R<[8`00Z`01<b/c:`2d0;<00?@c=002]001<c@d=02c003d<b/00:/00><[8`01H`2R0=X00B8J6QX
0d@3J004A6QXA09X00Q4J6R8S:cAd0Ke00?imOT00_D01?WemOT2m@03nOGe00;e1OT00oGim@04n@03
mOWe00[e00?imOD00_D01?WemOT2m@;i00?enOT01_D00oWem@05m@06nOGinOGi0_D00oWem@08m@;a
00?@mO401_D00oWem@03m@03nOGe00Ce1?T00o[in@04n@03mHaX00=400DTA2A49008A004J4AXR09X
00J8[:b8S:`<m@05d<b/d=400_402?Gin_[ed8c@3oD3l@?e0_42m@04lM7ed@?@00CAd=7@0_D02oWe
mOGa[8S<d=7<00>/00N<[:c@S:cA00;@00GAd=7@l@02d@?@00KAd=2/c=02[0:<00O<d=3@lM3e00?A
00?edO400]42[003S8R800=400=XA6P01FP00hc@l@02d003dOGe00;e00?amOD02_D01M7@d=3A00?@
00C<d=3<1:`5S0B800AXA6QX0T@01BA492A400HT00=492@02b@00d@T900A9003A2@T00PT2T@69003
A2@T00@T0T@89004A2@TA0XT1T@00bA49003A00394@T008T44@00fR<R003R004[8b/R0F<00B8J8R8
0X`028R<[:b<[8R<0j`01]3<[8b/c0>/00G<d:b/R003[003c:b/00R/00J8[:b<R8`2[06<0J`001U4
00<TA4@07T@00bA4A00BA0AX28P018b/S8`2R003[8b<00:/00?<[8`01Z`01M2/c=2/00W@00>/c=00
2M05[004S:b8S0:800=XR8P00XP2J004A6QXJ0]400N8[8b/c=3A00Oe0_T5m@04nOGen@Ge00CimOWi
0_D4n@04mOWin@oe00?imOD00oD5nACe00?imOD02_D2l@03dOGe01?e00?in_X00oT00oGinP02nP04
lHaXA08T00A492@T3D@2J006R:b/R:c<1OD01?WemM04m@05d:c<d=400_D3nP04mHb/d0oe00GadM7e
l@02m@03lOGe00;a00CedM3@0]43d0Ke00CA[=2/0m000jc@d003[004S8R8[0K@00?Ad=000]000lcA
l@03d0>/00><[=000m000oGAl@02l@03dO7@00?@0Z`00hb8R002A0EX00M4R8R8S=3A00;e00KamOGa
mO4:m@09lOGelOG@dM3A00G@0/`3[0:<0XP01Hb8R6Q400AX00=492@01R@014@T94@29003A2@T00PT
00=492@02b@00d@T900?90E400@TA4A40b@2A00394@T00LT00A494@T1D@00bA490089003A2A400=4
1B@6A08T1d@290M400EXR8R8J005R0><00F8S8R8S002R004S8R<S0F/00C<[:b<0j`00lc@c002[0;<
0j`01m2/c:c<[<`00j`2S0B/00?@[:`00j`2S0003T@00fQ4A007A00394A4009400<TA4@01T@00bA4
A00DA00394A400A400<TA4@024@4J003R8b800:800B<R8R80h`00hR<[002R0>/00><[:`01j`2c0>/
1]000lb/c008d0;<0j`3S003[8b<00:<0hP00jb<J005J0M400V8A4A4J8R/S:`00]07m@;i1?D01?We
mOT2m@;i00?enOT00_T3m@06nOGimOWe0_T?m@05nOGenOD01OTAm@05nOGimOT03?D2l@03dOGa01?e
1_T00oGinP02nP07mJa4A2A49003A00594A4A2@01T@2J0:800J<c:b/S=48m@03d?7e00;a0j`01<cA
mOD2nP04nM2/d13e00GamM3ed@02m@04dOGad@;e0]400m3Al@02d003lOGi00?e00Cad=2/0]000lc@
d002d0B/00B8J:ca0Z`3d003dM3A00;@00?<dM000m02[00?S:b/[<c@dM3elM7elOGa00G@0Z`018Q4
J4@2R00=J8aXR8aXS<camO7ed@0=m@03lOGe00;e00KAlOG@mM43d003[<b/00N/00V8S8QXA8Q4J8P0
0T@<9003A2A400DT00=494@03R@3A0DT00=492@00R@00d@T90039003A2A400@T2D@59003A2@T00U4
00<TA2@01b@7A00394@T008T0d@012A4A2@7A0HT00A4J4A40VP00hQXR003J004S6R<[0><0VP2R0>/
0XP00jb<[005[006S:b/c:c@0Z`2c0F/00?<[:`01J`01HR<[:b<00F/0X`1[06<0J`0025400<TA4@0
4D@00bA4A002A00394@T00<T14@00bA4A007A0=X00F8J8R8S003R003S:b800>800J<[:b/R8`7[003
d<b/00>/00G<[:c@c006d003[=3@00;@00Kad=3@dM02c003d:b/00:/00_<[8b8S8R<R:b8J002R0AX
0T@00hQ4A003A0AX1:`00m3em@06m@03nOGe00Ke00?imOT02?D4n@Ce00CimOGi4?D00oWen@03n@;e
00?imOT00_D00oWem@05m@03nOGe00Ci3_D00m7em@06m@03nOGe00Se00GimOGim@06n@05n_Wa[6P0
0T@290i400B8J8R80j`00hS<d@05m@05nOGemM401=02[003d?7a00Ce00?@[=403_D01?7edO44m@09
lOGAlOGamO7@00;A00?@dM400oD01_WemO7@c0?@00?ec=001:`028c<R6R8c:c<0m02d@?@00J/d:b/
c:`2S004c:b/[0?@00OadOGAmO7e00;@1:`01Xb8R6Q4J0:81FP018R/[=03m@?a3?D02O7emO7ed=7a
m@02d0C<00?@[:`00Z`3S0B81FP2A0`T00=492@02B@00`0T90039003A2@T00@T00=492@02B@00d@T
900;90M41R@014@T92@3A0@T0T@00bA4A0089003A2A400=40b@00d@TA004A0<T1d@012A4A2@2A09X
0T@016Q4J6P2R09X00F8S8R8S004R003S:b<00N/0/`2[005R:b/R8`00Z`00m2/c009[0;<0j`00hR/
[002[004c=2/[0:<0j`0015400<TA2@014@00bA4A002A00394A400I40R@8A00394A400M400<TA2@0
2T@00bA4A006A0AX0X`01XQXS8b8[0:800B/R8b/0XP00hb/[003[005S:b/[<`01:`00lb/S002d009
dM3@c=2/c=3A00K@00C<[:c<0j`01=2/[8`5R009S8QXR8aXS8QX009426P018QX[8P2[003d?7e00;e
00?imOD02OD01_WenOWen@;e00?imOT00_D00oWem@02m@03nOGe00Ke00?imOD02?D01OWenOWe00Ci
2OD00o7em@03m@;i00Cen_Gi1OD00oWen@0@m@04nOGen@[e1?T2m@;i00Ged:b8J00AA0AX00>8S8`0
0]02m@03nOGe00Ce00?adM001=03d@Ce00?Ad?D02_D4l@;e00Cad?7a1_D02?7emO7Ad=7@0m46m@;A
00?adJ`00]03c003d:b/00:800B<J8R<0XP02:c@c=3<d<c@0/`01:b<R8`2R0:<0Z`01=3ad?42m@0:
lOGamO7@c=3<[0>800EXA6QXR002J0>800Z<c=3AlM7adOGa2oD00m7@m@05m@03lOG@00;@00N/d<c@
c:c<00B/00><R6P00XP2J005R4A4A2@00T@J900302@T014T00=492@012@00d@T90029003A2A400A4
00<TA2@00R@00d@T9006A00394A400940R@5A0HT00=494@00T@00bA4A00390E40b@3A003J4AX00i4
16P2R007S8R8R8b8J003R0><1:`02Xc<c=3<[8R<[8`2[0?<0Z`01m2/[=2/S<`00Z`00m2/[003[0;<
00K@[:c<S6P3[00044@01RA4A2A4909400<TA4@00d@012A4A2@5A00394A400E400<TA4@024@01RA4
A2A490M400<TA4@01d@2J0:80fP6R005S8R8[8`02:`018b/[<`5[003d:c@00K@00J/d=3Ad<`6d005
[=2/c:`00/`2S003J8R800:80X`00fR<R003J0=40VP5A0=X0XP00hb/d008m@03nOGe00Ke0oT2m@06
nOGinOGi7_D5n@[e00?amOD00_D2n@We0_T9m@03dOGa00Se00?imOD01?D2n@?j0_T3m@05n_WedJ`0
0XPAA0AX00F8S<cAl@02m@03nOGe00Ce00?ad=000]000m7@d@02d@03lM7@00;@2oD01O7AdM3A00;e
1?45m@05lOGemO400]401M3Ad=7a00Ge00GAd=3am@02d@08d:c@c=6/S:`2R0=X00>8J6P00X`3d004
[<b/c0>/0XP018b8[<`2d005dO7amO400m42l@03d:b/00:<0hP4J0B80Z`4d004lM3@d0Ge00?amO40
0_D01?7emM42l@Ge00?AlL`00]02c0C@1J`01XQXR8b8J09400AXA4A412@00d@T900A90941R@2A0hT
0T@59003A2@T00@T0T@49006A2@TA2A41B@2A00394@T00=40b@014@TA4@;9003A6Q400940R@MA0=X
0hP00hb/R002R007S:b8[8b8[002R003[8b/00V/00G<[:b/c002[003d:b/00;<00B/d=3@0l`5d0;<
00B/R8R80J`001U400DTA4A49003A00394A400E400HTA4@TA2@SA0=X00>8J6P00XP018b8R8P2S005
R:b/[<`02:`01<c@[<`3[003d:c<00G@0/`2d003dM3@00;@00GAd=3@[003c005[<b/[8`00hP018b8
S:`2S003R6Q4009X00>8J4@00d@5J0:80X`00jc@m@0@m@Ci1?D01?WenOT6m@;i0_D00oWen@05m@03
nOGe00;e0_T00oGim@05n@_e00CamOGe1?T4m@Gi2?D2d@03d?7e00Ce00?imOD00_D00oWem@02n@03
mO[i00Gi0_D02?Wjn_Ga[8aX4D@2J0>80Z`00m3Am@02m@;i00?enOD00_D01m7@d=3AmM400_42d0;<
0]000oGAd@07m@K@0]401?7elM43m@?a00CelO7@0_401?GadM45m@05dM3Ad=400m001/c@d=2/c0:/
00>8J6P00VP01HQXJ8R<00?@00?<R8P01XP3[003c=3e00;e0_401OGalO7@00?<18P01FQ4A4AX00:8
00O<[8c<d?7e00;@00?AlM400]400o7Am@02m@03lOGe00ge00?@dM001m03[003R8b800:800><R6P0
0VP00d@TA00490A462@3A0@T0d@6909400<TA2@01b@2A08T00=492@00R@4A0HT0T@00bA4A003A1<T
00=4J4@00T@29003A2A400E400<TA4@00T@00bA4A00<A0=X0XP016R8S6P2R0:<00>/R8P00XP00hb8
S003[0:<00^/c<c@dLc@c:c@[003c005[=3@[<`02=001M7@d:c@00:/0H`1[06/000>A08T1d@291=4
0b@3A00494A4A08T14@00bA49006A00394A400a416P028b8S8QXR:b<1j`00hb8[002d007[<b/[<b/
c002d003c=2/00C@00?<d=000m001LcAd=3a00C@1Z`01XR/S8R/S0:/00?<[:`016P00hQXA003A0AX
18P018b8d=47m@03lOGe00Ce00CimOGi0_D01_WemOWenP;e00KimOGimOT2m@04nOGen@;e00CjmOGi
1?D01_[emOWen@;e0_T00oGjm@05m@06dOGelOGA0oD3n@05n_GenOD00_T01OGinOGi00Ge0]001?7e
dOT4m@0:nOGen_Gin_Wen@;e00?imOX00_T3m@05n_WjdJ`00VP00d@TA00>A0:80Z`018b8[=03m@04
nOGin@?e0]401_7AmOGam@;a0m001m7@d<c@mO401OD00o7@c002d@;@00?ed?400]44m@05dO7ed?D0
0]001M7@lO7A00?e00CimOGa0]001=7@lM03[003c=2/00:/00><J6P00VP00hQXJ002J005R:c@c=00
18P3J0:/00B8[:c<1?D01o7AlM7ad<`00Z`2R004[8R8J09400=XR8P01:`02=3AlO7AlOG@0]400m3a
m@05m@03lOGe00[e00GadM3@[002d004dM3@d0;<00B/S8R<0XP3J0941B@4A1XT0d@5909432@00d@T
9004A08T00=492@01B@4A0<T00=494@014@D90940R@4A00394@T00A400<TA4@014@00bA4A009A004
J8QXJ0:800AXR8R<0VP00jb8[003R004S8R/J0:/0X`00jb8[002[005c=3@[<`00m001Lc@d=3<00C@
00C<d=3<0Z`2d003c=3<00:/0H`1[06<000AA00494A4909400<TA4@00T@00bA4A002A00394A400M4
00<TA2@014@01BA4A4@T00=400@TA2@T0T@2909400<TA2@02d@01FQ4J8QX00B800=XR:`00Z`00m2/
[009[003d:b/00F/00?@c=001m001/b/d:cAc0G@00?<d:`01Z`2S003[8b800><0Z`018b8J4@2J0=4
0fP02HQXS8R<[8b8c002l@;e00?amOD02_D01?WenOT6m@03nOGe00?e00CimOWi0_D00oWem@05m@03
nOGe00?e00?imOD00_D5n@Oe00GamO7Al@02m@06nOGjn_Gi0_D6n@Oe00C@lM3a2?D2n@03n_Wi00;e
0_T2m@Ci0oD01oWjmM6<R6P044@01VR8S=2/R0:/00?@dOD00_D2n@03mOWe00;e00?Ad?401OD02?7@
d=3AmM7@0_47m@05d:c@dL`01=02d@;e00?adO401=42l@04d=7@d0?e00OimOWelM7a00;@00OadM2/
d=7@00:/00><R8P00VP2R0EX00F/d:c@S003R09X0XP01Xb8S:c@l@Ke0]42d007[8QXJ8QXR004A0>8
00?<d=000_D00o7Am@04m@?a1OD2l@[e00?adO400m001<c@d?44d0:/00F<R8R8S002J0=41B@3A003
94@T01/T00=492@00b@2A0PT00=492@00b@3A0/T1T@012A492@2A08T0T@29003A2@T00/T0d@390E4
0R@;A00494A490940b@3A09X0T@3J003R8b800>800>/R8`00XP3S004J8R<[0:<0Z`01M2/c:c<00C@
0Z`02M2/d<b/c=3<d002c0>/00K<d=2/c:`2S0:/000KA00494A490U40R@5A00394A400=400<TA4@0
14@39004A2A490940R@5A00394A400E40VP3R0=X00F8[:b/S002[003c:b/00F/00?<[8`01Z`00m2/
c006d006c=2/c:c<1=03c0;@0/`00m2/[002[004S:b8S0>80h`01HQXR6Q4009X0d@2J003A6R800><
00B8[=7a4?D00oWen@08m@04nOGen@Ke0_T:m@03nOGe00;e2?T8m@03dOGe00Ce1oT00o[in@09m@?A
00KelOG@mO43m@;i1OD3n@04mOWinPCe00KjnOWeS6P2A004J4A490I40VP2A005J8QXR8`00Z`01<b/
d=4;m@03dOGe00Ge00GadM3am@02l@03mO7e00Ke0_42d@03d<c@00?@0_42m@03d=7a00;a00SAlO7@
lM7@l@;e00?imOD01?D01]7alM7@c0?@00><[:`00fP2R0AX00B8J8c<0Z`028b8R8QXR8b81:`01]3e
mOGam@;a1=000jb<J002J003A8QX00=X0XP01:c<d=43m@04d?Gal@;e00?amO400oD01?7Ad?42m@09
lM7emO7elOGa00;@00?ad=000]02l@G@00F/R8b/S003J09400<TA4@012@00d@TA00@9003A2@T01DT
00=492@00b@4A00394@T00941B@00d@T900790=40R@00d@T90029003A2@T00941R@00d@T90029003
A2A400@T00=494@00T@290E40b@01D@TA4@T00U416P3A0>800Z/S8R8J8R<R8b/0XP00fR8R002S0:/
0h`03Jb<[:c@[8c<d:b<[<`00m02c003[<b/00B/00B<[:b<1:`000e400<TA4@01D@00bA4A00;A003
94A400Q400@TA4@T1D@290941B@:A00394@T00U40VP5R0:<3:`2c0>/00?@c<`00]000m7@d002d005
dM3@c=000/`01M3<d<b/00O@0Z`00lb/[002[004S8R/R0F<00>8J8P016P00dAXJ003A09X0hP01Xc<
d=7el@Ce00?amOD01?D00oWem@08m@05nOGenOD00_T00oGim@04m@04nOGen@Oe00?imOD00_D2n@03
mOWi00Ci1oD00o7ed@04m@03nOGj00;i00GjnO[jn@03m@03nOGe00?e00KAd=7edOD4d004lOGen@;e
1?T01OGinOWj00;i0oD01O[in_6/00=X14@00bA4A005A0IX00>8S:`00Z`00m3em@04m@03nOGe00?e
00?@lOD01_D01?7emM43m@06lM7AlOGi0_D01?7@dO45d003dM3e00;A00Cad?7a0]401_GAlM3el@We
0_402=7ed:c@dM3<0Z`018b8R8P8J003R:b<00:<00>8J6P00hP00hb/[002[003c=7a00;a00?elM40
0]001:c@[8P3J003A6QX009X00R8[8b8d:c<l@Ge00?amOD01oD02=7<d?7@dO7A0oD01O7edM3A00;a
00KAd=7elM43d0B/00>8[8P01d@01BA492A401PT00=492@032@3A00394@T00@T0d@01BA4A2A400dT
1d@390=45b@6A0DT0T@89003A2@T00=40VP2R004J4AXJ0>800><R8P01hP2J0:800AXR8R80Z`4R004
S:b<S0B/00F<[:c@c003[003c:b<00B/00N<[8b<[8c<006/000RA00394@T00e400<TA2@00T@012A4
A4@390940R@3A00394A400i400=XR6P00XP00fR8S002[003R8c<00:/00>8[:`01:`01=3<[<`3d003
c:c<00;A00?@lO400]000lc@d002c004lM3<[0O@00?<d:`00j`018R/R:`2S006[8b8S8QX0hP01VQ4
A8Q4J09400AXR8R/0X`00m3<l@02m@06dOGelOGa1oD01_[enOWen@;e00KimOWimOX4m@;i0_D00oWe
m@05m@03nOGe00Ge00CimOWj0oT00oGin@03m@03lOWA00;e00GAmOGAn@02m@09n_GjnOGin_Wj00Oe
00gimM3ed?G@lM2/c?Ga00Oe0_T01?[in_X2n@0;n_GemOWjnOF/R6P02T@00fQ4A004J003S6R<00>/
0m06m@06n_GemM7@0oD00oWem@04m@03lOGa00;e00CAmM3A1?D01=3ed=42d007[=2/dO7@l@02d005
dM3amM000_D00o7ed@06m@03nOGe00;e00?@dM400]000lcam@02[003S8R800:80VP2A0=X00U4R:b/
J8b8J8P00VP00hb/[002R005S:c@d?D00]001?7@d<`4[0MX00J<J8b<R:`2d004dOGad@We0_401_Ga
d=7<d0?A0oD01M3adOGA00;a0]001]7amM7@c0>/0hP3J0I412@01D@T92A4008T00=492@03b@3A0TT
1T@290A400<TA4@00T@00bA4A003A08T00A492@T3D@00bA4J002A00394A400@T00=494@00T@012A4
A4@590U400<TA4@00d@49004A2@TA0<T1D@2J006A6QXA6R80fP01HR<[8QX00:80fP4R004S8R<R0:<
0hP2[006S:b<S:b<0Z`4c0F/00=XS:`00X`3[0680H`1c00034@00bA4A008A00494@T90=400<TA4@0
0d@00bA4A004A00594@TA2@01T@00bA49002A0@T00=492@02T@00bA4A007A0=X00>8J8P00XP01:b<
S8P3[006R8b/S8R/0]03c00<[<c@d<c@dM3adO7A0]02c003d<c@00;<00>/d:`01=001/b/[:c<[0>8
0j`01Xb/[:b<R0EX14@02FQ4A6R<J8R/R002[003lOGa00Ce00?amOD01OD00oWem@02m@03nOGe00;e
00CimOGi1?D01?WemOT2m@06nOGenOGi1OD00oWen@02m@;i00?enOT01OT6m@06dOGAmM7a0oD01?[i
nOX5n@;e00?imOD00oD2d004lM7@d@>/00C@lOGa0_D2n@;e0oT00o[inP03n@;e00KjnO[e[6P8A004
94A4J09400>8J4@00VP01DB8[<c@00;<00?@mO400oD01OWemOWe00;A1?D00oWem@04m@07dOGemO7A
l@05m@04dM3al@?@0Z`4d003c=3@00?A00O<dM7elM7a00Se00?adM001M02d@08d:b<R:b8[8`2J003
A6QX009400AXR8R80X`3J004R8b<S0>800B/d=7A0m002]6/[:c@[8b8J8P3J003R:a400>800><[=00
0_42d@03mM7a00Ke0_42d@03d=7@00?@00?AmO400]400m3Al@02l@;A00C@dOGA0]001lc@[:b<[8P0
0VP8A08T0T@69003A2@T01DT0T@590E400<TA4@03T@29004A2@T90Q400=XA4@00T@012A4A6P5A003
94A4008T0T@00bA4A002A00494@T90Y400<TA4@00d@390E40b@8A09X00A4J4A40VP01HR<R8b800AX
1XP00hb8S002S003[8R800:<00>8S8`01J`2c0B/0X`2R003[8R/00:/00B<[8b<0J`001=400<TA4@0
4d@290A40R@=A00394A400=400@TA4@T0d@00bA4A009A0AX0hP00jb<S005S0B/00><[:`00Z`01Lb/
c=3A00;@0]401?7AdM02d@03d<c@00;@00?<d=000l`02Jc@[=3<d<c@c004[003S:b/00:<00S<[8R8
A6Q4J0E400=XA6P00VP01HR/S:c@00Ke00?amOD03_D00oWem@08m@03nOGe00;e00?imOD03?D00oWe
m@02n@03mOWi00?i1_D01M7elOGa00Ce1oT2m@03nOGi00Ge0m001=7@dL`2[003d:cA00;e3OT3m@;i
0_D01Jb8J4@T00a41FP00hb/d004d0?a2?D01O7emOGi00Oe0_44m@;a0]400oGal@03l@;@0j`5d0CA
0m001]7edM7el@Se00CamM3A0]02l@08dO7@[8R/c:`2R0=X00B8A4A40VP2R003S8R800R800C<d=7A
0]000jc@[005[0>816P00dAXJ003R0:/2=44m@04lM3Ad0;A0m001Jc@d=3e00C@0]401M3ed=3e00;a
00WAd=2/S8R<[8`00fP6A0@T00=492@01R@4A00394A400@T0T@39003A2@T00/T0T@00bA4900?A003
94A400=40R@<A0<T0d@012A492@4A00394@T008T14@490=X0d@59004A2@T90I40R@9A005J4A4J4@0
0VP00dAXJ003R003J8QX00:80VP00hb8J002S004[8R8J0>80Z`00hb8S00;[003S:b/00>/00K<S:b<
[8`2[00024@00fQ4A008A00394A400=400<TA4@014@00bA49002A00394A400M40R@6A00394A40094
1B@FA003J4AX00:800R/J8R8J8R/R0:<0Z`00lb/[002[0;<00>/c=001=001=7@dO42d@07lM7Ad=7@
d@06d0:/00?<d=000Z`00m2/[006[007S8R8S:b8J002A0AX00A4J4A40XP2S0>/00?@lOD01?D00o7e
m@0:m@03nOGe00Ce0_T01?GinOD3n@?e00?imOT00oD01OWemOGi00Se00OimOWimOWe00;i0oD00o7e
d002d003mM7e00Ce0_T00oGin@03n@04n_Wen@Ce00?amL`00m001Zc<c8b/d0;e1_T3nP06nOGinOGi
0_D01OWemJaX01941HP2d004dM3al@;A0_D00oWem@02m@03dOGe00Ke00?imOD00_42m@03lOGa00;a
0]401o7AmO7Ad<`01:`8d005lM7Ad?402oD01=7elM03d@03lOGa00;a00>/S=000Z`00hb8R002R09X
00Y4J6QXR8b8S8QX0hP01fR8R8R/d<`00m06[003S8R800=X00>8J6P00T@01VR8S8S<d0?a0_D00o7@
m@03m@03lOG@00;@00?adM401=001M7alOGA00?@00?adM400]402OGAlM3Ad8b/R002[003R6QX0094
0R@3A0<T14@;90942B@00d@T90089004A2A490=40R@AA08T00=494@034@490A400DTA4@TA0059094
0R@00d@T9004A005J4A4A2@01D@590M400<TA4@02D@00fQ4J003J003A6QX009X0hP2J0>800>/S8`0
0XP016R8R8P4S0:/00><[8`00Z`00hR/[003[003R8b/00:/00><[:`00h`2[0003D@00bA4A00;A003
94@T00940b@;A00394A400E40b@00d@T90029005A2@TA2@01T@00bA4A005A00394A400E40XP02Hb8
R8b8J8R/R002S003[8b<00>/00J<[=2/c:`2d0;<00SAd?7@lOGAm@;@00?AlM000]400m3Ad002d004
[<c@d0V/00?<[:`00X`00hR/[002R09X0XP6J003R8aX00>/00C@dOGa1?D00o7em@0:m@03nOGi00;e
00?imOD00oD00oWenP02m@04nOGen@;e00?jmOT01OD01_[emOWen@;e00KimOGimOT4m@06d?GAd?G@
0_D02=7emOGjmOWj0oT00oGinP02n@Ke1=003?G@[:c<S=3an_GinP;i00KjnOWjmOX3n@;e00GimOWa
[006A08T2d@03FR8S6R8S:c<d?7@mM000oD2n@;e00?amOD00_D02_WemOWenOGamO42m@07d?7edOG@
l@02d0;a0]02[005c=2/d:`01=001m7@mM7@mM400_D01O7emOGi00?e0_401oGamO7@mO400_D2d0:/
00?<S8P00fP00hQXJ003J009R6QXJ8R<R6R800AX0XP01Xb/[=2/S0B/0X`4J003A8Q400=X0XP01Zb8
d=3el@Ce00G@dOGam@02l@05dM3@d=400m000lcAd@02l@04dM3@d0;A0]02l@0:mM7Ad=7@R:b8[0:<
0XP00fQ4A003A0<T00I4J4A494@59003A2@T008T0T@49003A2@T00`T1d@00bA4A008A00394AX00A4
1b@3A00394A400E40R@00d@TA005A00394@T00@T0T@00bA4900290A400<TA4@00d@290E40R@014@T
A6P4A0<T2T@5J0=40VP3R09X00M4J8QXR:b<00:80fP00hR<S003[003S:b/00B/00B<[:b<0Z`2S005
[8b<[8`00Z`2S06/000=A00394A400A400<TA4@01D@00bA4A006A00394A400E400@TA2@T1T@012A4
A4@2909400LTA4A494@T00Y400<TA4@01T@00fR8J004R005J8R/R8`00j`00hb/[002[007S:b/[=2/
c002d003dO7A00;a00?AmM400]42d003dM3@00G@0l`4d0B/00C<[:b80X`01:b<S8P3J003R6Q4009X
0XP02VR8R8R<[8c@c=02l@03dOGe00ce00?imOD01_D00oWen@08m@03nOGe00Ge00CimOWi1?D00oWe
m@05m@04nOGen@?e00OAmOG@dO7@00Ge0_T01?GinOD4n@;e00?imOT00oD3d0>/00C@[=3@0oD01?We
nOT2nPOi00SjnOGimO68J11400EXA6R8S002R004[<c@c0;@0]42m@03nOGe00Oe0oT8m@03dOGa00;e
00GamOGAm@03l@03d:b/00:/00S<[<c@[=3Al@;e00?ad=401OD2n@Ke1?45m@;@00B/d:c<18P4J003
A6QX00AX00B/R6QX0d@2J003R8b<00>/0X`3[0:<0VP2R003J8QX00:800MXR:b/S:c@00?e00?amOD0
1OD00o7Ad@02d@04lM3@S0;@00SadO7adM3Ad0;A00GadOGad@05d004S:b<[0:800><J4@02d@79094
4b@00d@T900490M400DTA4A4J007A09X0d@390940R@3A00394A400=41R@7A0DT14@49003A2A400Q4
0b@4A08T1d@590Q40fP01TAXJ4AXA0:800AXR6R816P00hb8[002R09X0XP01Xb/[=2/R0:<00>/S:`0
0X`4[003S:b800:<00AXS<b<0Z`1S06/000/A00394@T009400<TA4@00R@014@T92@6A00394A40094
00<TA4@014@00bA4A00=A003J8R<00B800EXR8R/S002[005S:b<[=001J`2d0;A0_401OGalO7A00W@
00?Ad?402=000lb/c002d009c:b/c:b<[8QX00:800=XA4@016P4R0>/00C<d=7a3oD01?WemOT5m@03
nOGe00Se00?imOD03OD00oWem@03m@03nOGi00;e00?imOD00_D3l@05d?7@mO401?D01OWemOWe00Ci
0_D2n@05n_WemO400]002<b/[8b/c=3A0_D00oWenP03nP03nOGi00?i0_D02?WemOGa[6Q40b@00d@T
A004A09X1D@00fR8R004[0?@00>/d=400_D00oWem@02m@03lOGe00ge00?AmM401?400oGAm@02l@06
dM2/d:b<0Z`01/c@[=7@d@?e00?Ad?D00oD3n@Ke00?amO400_D00m7al@02d0:/00C@[:b/18P3J003
A6QX009X0T@016Q4A4@2J0=400MXR8b8S:b800:<0j`018QXJ6P2R0=X0hP02Jb8S<cAd?Gad002l@04
mM3al@?e0m001=7@dL`4d003dM3A00;@00GAd=7ad002m@03dO7@00;@00>/R:`01H`00fQ4A008A003
J4@T00HT00=492@01R@01D@T92A400XT00=492@00R@5A0<T0T@00fQ4A003A003J4A400=40R@5A08T
1T@00bA490029004A2@T90M40R@3A00494A4A0HT0T@29003A2@T008T0T@4909400HTA2@TA2@2A003
94A4008T00=494@014@00fQ4A003A09X0XP2J0>816P8R004J8R<S0:/00>8S:`00j`00hb/S002[004
c:b/[0><00>8S:`00h`1[0004d@00bA4A00;A00394A400M400<TA4@01d@00bA4A003A00394A400A4
00@TA4@T3d@00bA49004A006J8R<R:b80fP2R003S8R/00Z/0m000m7ad@02l@;A00?<d=400/`5d004
dM3@d0;<1]0;[006R8b<R6Q40VP3R006J8R8J8R<0Z`00m3el@0Am@04nOGin@Se0_T8m@03nOGe00;e
00CimOGi1oD00oWen@09m@03lM3a00;A0_43m@03nOGi00Ci00?enOT01OT00oGim@02m@03d:b/00:/
00><[<`00]02m@;i0oX00oWjn@03n@05mOWemOT00_D01=68J6P=A004J8QXA09X00>8S8P00Z`01]3A
d:c@l@?e00CimO7a1OD00oWem@02m@03nOGe00?e00GadM7ad@03l@;A0_42d003c:b/00F/0]001?7A
lO42d@03lM3e00;e00?imOD03OD2d003c8b<00;@00F/R8R<R004J0=400=XA4@00d@01fQ4R8Q4J4@0
0XP00haXR003[003R8b<00B80VP4R004S8R8S0:/0m001=7ad=42m@06lM7AmO7A0m000m7@d@03d0;A
1=001]7@dO7@l@;e0_43d003[8R<00:<0hP<A1/T00=492@01B@014@TA2@4A08T1d@2J0=40R@00d@T
A005A08T2d@012A4A2@3A00394A4008T0T@00bA4A0049006A2@T94@T0T@590A412@3A00594A494@0
1R@3A00394A4009400AXA4A40VP2R005J4B8J8P00VP7R006J8R8R8b/0h`00hR<[005[003S:c@00:/
00G<[8R<c006[07<0002A003J4A4015400<TA4@01d@00bA4A006A00394A400E400<TA4@00d@012A4
92@4A004R4A490A400<TA2@00T@016PT92@7A00394A400940fP3R09X18P01FR8S8b/00:800><[:`0
0j`02=3AdO7elM7a1m000lc@d007d005dM3A[=000/`01:c<d=02[007c=2/[8b/R003J003R6R8009X
0XP4J004S=3@lASe00?imOD00oD00oWem@0;m@03nOGe01Ke00GamOGad@05m@;i00GenOWim@05n@?e
00GimOGed002[007S:b/S:c@d@03m@;i00?jnOT00_T01?GinOT6m@03d6Q400940R@;A005J4A4J4@0
0fP3[004d=7@d@Oe00?amOD00oD2n@03mOWe00Se00GAlO7ad@02d003lOGa00;@0Z`2c0:/0/`2d004
dM3@d@;a00OelO7enO[i00ke00S@[:c<d?7@c0:/00B8J6R80VP00dAXA004A004J4AXA0AX00A4J6QX
0T@00hR<J003J003R6QX009X00>8J8P00XP01FR8R:c<00?@00CAd=7@0]401O7AmM7a00;A00?@c<`0
1=000m7@d@04d006mO7@dM3A0_D2l@03dM3@00B/0X`3R0940fP3A004J4A4A08T0d@59003A2@T00LT
00=492@02b@4A00394A400=400<TA4@00T@00fQ4A005A0LT00=494@01B@;A0DT00A494A40R@00d@T
900490A40R@00d@T900490940b@8A00394@T00DT0d@016Q4A2@5A09X0T@2J003A6QX009X0XP00hb8
R004R003J8R800><00>8[:`01Z`02m2/[<c@[<b/R8c<00>/00?@c=000J`0009400><A4@024@00bA4
9007A00394A400A400<TA2@00R@:A00394A400A400HTA4A494@3909400AXA2@T6D@4J007S8QXJ:b8
J002S0:80X`016R8R:`3S0:/0]000m7@d@02d@C@0Z`01Lb/c=2/00G@00[<dM3@[=2/c:c<1Z`01/b/
S8b8J0N80X`02HQXJ6R<[=3ad@02m@03lOGe00ce00?imOD00_D00oWem@03m@?i0oD00oWem@0:m@03
nOGe00;e00?amOD00_D00oWem@03m@03nOGe00;e00CamM3a0]03m@?i00?enOD00_D5n@03mOWe00Ce
00?Ac<`00Z`01Hb/[<c@00;e0oT00oGin@02n@03mOWe00?e00KimOGedFP3A08T0d@01FQ4A4AX00E4
00AXR6Q40VP2S005[=3Ad=400_D01oWemOWelM401?D00oWem@0:m@03dO7e00;A0]002o7AdM3<[<b/
c8b/00?<00?adM000]001]7alOGAm@;i00?jnOD02_D00o7ed002[0;@00Ced=3<0Z`016R8J8P2J0=4
00=XA4@014@00fR8J003J003A6Q400EX00I4J6R8J4@2J00?A6QXJ8R<R:cac=7ed?7A00;@01;AlOGa
d?G@dM2/d=7@dM3AmM02d@09d?G@d?7@lOG@00;e00GamM3<[002S0:/00>8J8P00VP2A003J4A400E4
00=XA2@00T@490=43B@2A0HT00I492@TA2@6A0<T2D@390940b@014@T94@490A40R@5A0LT0T@29094
0R@02D@T94@TA2A49002A0/T0T@00bA4A004A0<T00E492A49004A00394A400A400J8A6QXA6P2R003
J8R800B800>/R8P00X`01XR<S:b<R0>/00R<[:b/c=2/d0:/00?<d:`01Z`00m3<c001[0000T@00fQ4
A00MA00394A400]400<TA4@00T@00bA49003A00394@T00A400DTA4A49004A00394A400E400<TA4@0
1T@01FR8R8R<00:800AXR8QX0XP2J003R6QX00B80X`2[0?@00G<d=3@c002d003[<b/00:/00?@[:`0
0Z`01]2/[:c@[0;<00O@c:c<d:c<00N/00>8S6P00VP2R007S8R8[8R<R002J005S:b/lM400oD00o7e
m@0Cm@;i00?enOT03oD3nACe00?amM000]02l@;e0oT00oGim@03m@;i0oD00oWem@03m@04lJb8[0:<
00F/c=3<d006m@Ci2OD01=2<J4@290Y400AXA4A40VP01HQXR8R<00:/0m02m@03nOGe00Ce00?AlOD0
3oD02_7edO7Ad=7@dM02c007[<b/c:c@[002d003dO7@00;@0]400oGam@02m@03n_We00ce00Cad=3<
0]02m@04lM2/[0:80VP014AXA6P6A009J4AXJ4AXA8QX00941VP014AXJ6P2A0IX00><J:`00]000oGA
m@03d003dM3a00;@00?AlM001=02d@;@00Kad?G<d?44d007lM7alOGam@02d003c:b<00B<00>8J6P0
14@00fQ4A006A0HT0T@@9003A2@T00<T0d@590U400=XA4@01D@5909400<TA2@022@3A00394A400=4
0b@00d@T900490=400<TA2@00T@022A4A4@TA2A42b@6A00494@T90I40R@9A004J4A4A0=X0hP01VR8
R6R8J0B80X`00hR/S004S0:/0/`01Zc@[:c@c0:/00C@c<c<0Z`01M3<d<b/007@000IA00394A400E4
00<TA4@02T@29003A2A400Q40R@014@TA4@29003A2A400A400<TA4@014@00bA4A009A004J8R8S0F8
00AXR8R80fP02XR<R8QXS8R/S:`3c0R/0/`01:c@[8`4[003c8b/00>/00><[=001:`2c0:/00C<[:b/
0XP2J0:800><R8P00Z`4R0:/00?<d=000_400oGAm@0Bm@;i00?enOD00_T2m@04nOGen@Oe00?imOT0
0_D00oWem@0>m@06nOGemO7A0]000oG@m@02m@03nOGi00;e00?imOT00_T9m@05lJb/S<`00j`01=3<
d?42m@03nOGi00;j1_D02_WemOWed8QXA2@4A00594A4A6P00T@00fQ4A003A09X00R8[:b/d:c<d0;e
00CimO[i0_D2lACe00G@dM7@d@04d00:c=2/c:c@[=3<d0;A00?elM400]42l@03mOWi00;i1OD00oWe
m@06m@03d=7@00;e00CamM6/0X`01HQXJ4B800AX00A4J4A40VP00hQXA002R0IX0hP2A0AX00=4J6P0
0T@02VR8R6R8[=3elM45d005dO7AdO401M000o7ed@02l@03dM3@00O@00CAlO7e0_43d0F/00>8J4@0
24@2J0E412@00d@T900;90942R@01D@T92A400@T3d@79003A2@T008T0T@590M400<TA2@02R@00d@T
A00290=400<TA4@00T@690940b@00d@TA003A0@T14@39003A2@T00Q400=XA4@00fP00hQXR002J0:8
00EXR6R8J003R004S8R/S0>/00G<[:b/d004[003d:b/00>/0/`01M2/[<c@00;<0J`001U400<TA4@0
14@290U400<TA2@00T@00bA49005A0@T0T@012A4A2@2A00594A4A2@01d@00bA4A00:A003J4A400=X
18P00fR8R003J0:<00B8J8R80h`2[0:81j`01Lb/[8c<00:/0X`3[003S:b/00:<00>/S:`00Z`00hb/
[003[006S:b/[8b80fP3R003S=28009X0hP2[004d<c@d@Ce0_4>m@03nOGe00;e0_T=m@03nOGe00;e
00?imOD02oD00oWem@06m@;A00?@dM005_D03?7@S:b<[8b/S=3ad0;e0_T00o[in@03n@We00>8J4@0
0T@290i400QXR8R/S:c@d@;@0oD2n@Ce00?amOD04_D00o7Al@02d004c=2/[0?<00B/c=2/0m001]7a
lM7ed@?a0_D3n@ge00CadM3@1?D00m2/S002R004J8R8R0=X0T@2J003A6Q400=400>8J4@00fP5R004
J4A4A0=X00R8J6Q4J8QXR0:<00C@lLcA0]02c0?@00GAd=7@d@03d003lOGe00;a1]001<c@lM45l@05
dM3@[=000Z`2S09X00=4J4@01D@3J0I40R@2A0HT00=492@00b@00d@TA00<90941B@4A003J4A400Q4
0b@014@T94@490A400@TA2A40R@7A0`T00I492@TA2@2A08T0T@590=41B@01T@TA4@TA08T00A494A4
1b@00d@TA007A0IX00F8J8R8S002R09X1XP01jb<S=3<[8`01J`00m3<c004[003d:c<00:/0/`1d06/
0L`002U400<TA4@00T@00bA4A0029003A2@T009400<TA4@00T@292=400B8S8b80VP00hb8R002J003
S8QX00:800Z<R8b/S:b<R8b/0X`:[005S:b/S:`00X`01jb8S:b8S:`00X`01hR/[<b/S:`00h`00jb8
R003R0><00>8J8P00hP5[004dOGam@;a4?D2n@03mOWe00Ce00CimOGi1oD00oWem@02m@03nOGe00Se
00CimOWi0_D02oWemOGadO7@lM3a00Ge00?imOD03?D00o7ed002[006S:b<[8b/0]02m@Gi00?enOD0
1_D01?WedHP2J0940R@>A003R8b<00:<00>/dM400]02m@03nOGe00?e00KAmOGamO43m@03lOGe00We
00?amOD01=05[007c:b/d<c@d@02d003mM7a00;A00?adOD00_D2n@03mOWe00Ce00?imOD01?D2d@06
d=7amOWe0]02[0F80fP014AXJ6P6A003R4AX00940hP4J0A400>8J6P00fP00hQXR002R006c=7ad?7@
1<`2d0;A1=002O7@lOGamO7@m@02d003dLc@00;A00GedO7ed@02d007c=3<c:b<[002R0AX14@3J0I4
0b@3A0@T0d@;909400<TA4@00R@2A0DT1D@01FQ4A4AX00I400@TA4A40b@2A08T00E492A49003A0<T
1T@59003A2@T008T1D@390A40b@3A08T1D@2909400<TA4@00d@29003A6PT008T00=494@00R@00d@T
A005A0MX1XP018b8J6P5R006[8b8[=2<0Z`00hb/[002[003d<b/00>/00G<[<b/S002[0;<0J`001Q4
00<TA4@00T@00bA4A002A08T3D@00bA490029003A2A400I400DTA4A49004A00394A400=400@TA4@T
14@29003A2A400M400EXR8b8J006R0:<0hP5S006[8b8S:b<3:`2S0:800J/R8aXR8`2R004S6QXJ0B<
00>8[8`00XP02Zb<R8R/S:b<[8P2J0:80j`01M3<[=7a00;e00?AlOD03_D00oWen@03m@03nOGe00_e
00?imOD00_D00oWem@09m@Ci1oD2l@?A00?amOD05?D01M2/[8b/00:<00B8[=2/0oD00oWen@02n@03
mOWe00Oe00GAR6QXA00390i400=X[8P00X`01:c@d=43m@?i3?D00o7em@0<m@03d:b<00>/00?@[<`0
0Z`01<c@d=43d006dO7@dM3A0_400oGin@02n@ge00Gad=7@d@03m@07c:b<[8b8J002R09X0T@2J0I4
0VP00dAXJ002J006[8R8J4AX14@018QXJ6P6R003[=7@00C@0Z`00lc@d003d004c:c@c0;@00?adOD0
0]400m3<d002d005dLcAmO400_D3d@?@00O<d:b/S8R<00=X00=494@00d@016Q4A4@89003A2@T01TT
00=492@00T@00bA4J002A09X0d@016Q492@2A08T00A494A40R@01D@TA2A400DT2T@69003A2@T00DT
00=492@00R@2A00394A400<T14@00bA4A002A0<T00=492@01D@29003A2@T00DT2D@2J0A400=XR6P0
0hP01FR8J8QX00>80j`00hb/[007[003S:b/00;<1J`2c005d<b/d<`00J`000m400<TA4@01d@01BA4
A4@T00I400<TA2@01T@00bA4A004A08T00=494@00T@012A4A2@4A0@T14@012A4A2@7A00494A490Y4
1FP00hQXS002R004[8b<S0>/00>8S:`00h`00jb<[002[003S:b/00:/00><R:`00j`028b8[:b<R:b<
0XP00haXR002R007J8QXR8aXR002S003[8R<00:<00>/S8`00h`3R006S:c@d?G@0]401=3AdO4<m@04
nOGjm@;i1oD2n@Ce00KimOGimOT2m@04n_Gen@Oe0_T00o[im@02n@Ge0_400m7@d002lACe00Oad=2/
S:c<00:800=XR:`01?D01?WenOX2n@Se00CAR4A412@6A00394A400E400=X[8P00j`00lc@m@04m@03
nOGi00_e0_4:m@04lOGad0J/00?@[:`00Z`01<c@dM45d0?A00K@lM3en_T>m@04dO7@d@?e00?Ac=00
0Z`2R003J8R8009X14@2J0M400=XR8P00hP00fQ4A005A003J4B800=X00F8J8R8S002[005d:c@c=00
0Z`018c@c=03[003d:c@00;a00KelM7Ad=45d0Ge0_401=3Ad=02c004[8b<R09X00=4J4@014@3J0A4
1R@00d@T900=9003A2@T00LT00=492@012@2A003J4A400Q400<TA2@012@2A08T00=494@00d@00bA4
900290I400<TA2@00R@00d@T900290941B@014@T92@5A00494A4A08T2d@00bA49003A00594@TA2@0
14@290Q416P3A003J8QX00AX1XP00hb8[00>[003c:b/00F/00B<c=3<0j`000Y400<TA4@014@00bA4
A00AA00394A400U400<TA2@00T@00bA49002A00394@T00<T0d@01BA494@T00e400<TA4@01D@00bA4
A005A0AX00B8S:b80h`01:b<S:`3S0>/00B<[:b<0Z`00hb/[003S0>/0h`8[0>80fP02hQXJ8R<R8b8
S:b<00>/00>8[8`00h`3R004S=3@d0;A00C@dM7a4OD00oWem@08m@03nOGe00Ge00CimOGi1?D00oWe
m@03m@03nOGi00;i0oD00oWen@04m@04dOGAd@We0o400m3em@05m@C@00>/S:`00X`018QXR:`6m@?i
1OD01_WemOG@S0=40b@6A00394A400I40XP01Zb8[<c@l@ce00?amO400oD3l@We00GamM3<[003d0B/
00?<d<`00]000o7Ad003d@06lM7AlM7a0_D2n@Ce0oT8m@?A00?@lM400m02[0>800=XR4@02D@2J0=4
00EXS8R8S002R003J4A400=400AXR6R80VP01TAXJ8QXR0:<00K<[8c<[8`3[009c:b<S:c@c=3A00;a
0m401M3Ac=3A00;@00CelOGA0o400m3ac003[004R8b<J0U400>8A4@014@390A44R@00d@TA0089094
00<TA6P00fP4A09X1D@390941b@4A0<T0T@39003A2@T00@T1d@690A400@TA4A412@014@TA2@4A0@T
00=492@00R@4A0<T1T@01BA4A4@T00=40fP00hQXJ007J0:80VP4R0J/00C<[<c<0j`02Lb/c:c<[=2/
S002[003d<b/00:/0H`00003J4A401i400TTA4A494@TA2@00d@00bA4A003A08T0d@00bA4A0059004
A2@T90A400<TA4@03d@290Y40VP00dAXR002[006S8R<S:b<0Z`2S003R:b/00>/00?<[:`00j`2S003
[8b/00>/00F<[8R/c002[005d:b<R8`00fP00hR/R003R0:<00>8S:`01:`01HR/[8aX00>800N/S=3@
lM3A00;@0_400m7em@0<m@03nOGe00?e00?imOT02?D01oWemOWenOD00_T2m@03nOGe00Ce1OT2m@03
nOGi00;e00SimOGadOGad@?e00?imOD00_D00o7<[002d003lOGa00;e00W@[:c@dLb/S8P016P00lcA
m@04m@03nO[i00;i1oD00m28A003A08T3T@01VR8[:b8S0:/3OD00m7ad@02l@04mM7ad@We0_400m3<
[002d0;<0Z`01=3<d<`2d003dM3@00;@0m401?GamM46m@;i00CenOWi1oD01M7adM3A00;@00Kad=2/
S8P4J0Q400=XA6P01VP01DB8R6R800M416P00dAXR004J003[8R/00:/00>8[:`00j`02lb/[:c<d=7e
lM3a00;@00?ac=000]001OG@dOGA00;e00CAlOGA0]000jc<S002R003J4A400Q40fP00hQXA0049003
A2@T00HT00=492@052@024@T92A4R6R81D@00fQ4J004A08T00=494@01R@4A0<T0T@39003A2@T0094
00LTA2@TA2A400`T0T@01BA4A2A400<T00E494A4J002A00794A494@TA0039004A2@T90Y400<TA4@0
0T@00fR8J002J003R6R800EX0hP01fR8[8R<[=003J`01<c@d<`2[003S:b/00:/00><[:`00J`00154
00<TA4@03D@00bA4A007A00494A490U400DTA4@TA0029003A2@T00I400<TA4@01D@290A40R@>A003
J4AX009X00><[8P00XP2S0B/00><[8`00j`01]3Ac:c<d0:/00J8[:b/c:`2S0>/00C<[=3<0Z`2S0:8
00=XR8P01HP018aXR8P2S0:/00N8[:b8J8QX00:800J/d=3Ad?42d003dO7a02?e00?imOD03?D4n@ce
00?amOD00_D02?Wjn_[imM6/0XP00jc@l@02m@;@00V/d?7Ad:b<R6P00XP00hb/d007m@04nOGin@Ge
00?ad8P01D@00bA4A00<A09X18`01:c@lO4=m@03lOGA00Ca00?elOD01_D01?7ed<`6d003c=3@00K@
00[AlO7Ad=7amM7a0_D00oWem@03m@03nOGe00Se00Cad=7A0]02d@05lM3<S8P00fP00dAXA006A0=X
00A4R6R80VP01DAXR8QX00E400AXA4AX0T@4J09400IXR6R<c8`3[003c:b/00>/00><d<`00o402=3a
lO7@lJc<0]001=7alOD3d@03mM7a00;@0Z`2S003R4AX00A400AXA4A40VP00hQXJ003A00494@TA0TT
00=492@04B@01D@TA4@T00940fP5A00394A400E412@014@T94@490940b@2A0HT00=492@01T@59003
A2@T00DT00A492@T0T@012A4A4@290E400<TA2@01D@00bA4900<A003J4A400=X0T@018QXJ6P3R005
J8QXJ8P00VP3S0N/00?<[:`00j`00lc@c004d0?<00F/c:b<[002S06/000NA00394A400A400HTA2@T
A2@9A0<T14@01BA4A4@T00=40R@5A00394A400@T00=494@04d@02fQ4A6R8J8QXR8b800B/00B8S:c@
0/`00m3Ad003[003S:b<00>/00S<[:b/d<c@c0:/00?@[:`00Z`00hb8[002R00;S8R8S8R<R8b/S:`0
0h`00jb<S002R00:J8R8[=3Ad?7A[0;@00?amOD03oD00oWem@02m@04nOGen@;e00?imOD04_D00oWe
m@04n@;e00?imOD00_D01OWemOGa00?e00?in_X01?X02oG@[:b8S:c@mM3A00:/0_401_F/R6R8S0>/
00?AlOD00oD5n@03n_Ge00?e0]02R0E400<TA4@02d@00fR8S002R006[<c@d?Ga0oD00oWem@06m@03
lOGe00;a00?edOD00oD00jcAm@03m@;A00?@c=000/`2d0:/0/`00m7<d002d00=dM3@lM3AlM7ed?7i
m@02n@05mOWemOT02OD02?7elM7ad?7e0m001:b8R8`4J0I40VP00hQ4A002R004J8QXJ0:800AXA4AX
1d@7J007A6QXR:b8S004[0;<1:`01=3AlO42d@03d=7@00?@00?<lM400_D01M7adM7e00;A0]000jb<
R002S003R4A400=400EXR8aXR002J0M45R@00d@T900890Q400AXA4A412@5A00394A4009400HTA4A4
94@590=42B@5A0LT00=492@022@5A0@T2d@29003A2A400]400AXA4AX0T@00fQ4J003J0>800EXR6R8
J003R003J8b/00>/00?<[:`01:`01Lc@d<b800>/00G@[:b<d004[06<0J`1[0004d@00bA4A00?A003
94@T009400@TA4@T1d@290E400<TA4@014@39003A2A4009400<TA4@00T@00bA4A008A00394A400M4
0fP014AXJ6P2R007J8b8R8b8S003[00:S:b/c=3Ac=2/c0F/00C<d=3<1]001Lc@d=3<00>/1H`00hR<
[002[003S8R/00>/00G<[:b<J005R005[=3ed<`00]000o7el@0>m@04nOGin@Ce00?imOD02?D00oWe
m@06m@03nOGi00Oe0_T7m@03nOGe00Oe1oX2m@03[6R800:/00?Ad<`00]000m7ed002[008R8b/[8R/
c=44m@03nO[j00;j00CimOGi0_D00m3<R002A08T00=494@00T@00bA4A003A003J4A4009400=XR8P0
0XP01jc@c=7amO403OD01O7edO7A00We00?amM000]001<c@d:`;d003dM3@00;@00GAlO7@l@0Gm@?a
0m03[0:800AXR6QX14@4J0940VP4R09X00A4J4AX1d@00fQ4A002A0IX0hP00jc<c002c004d:c@[0;@
0oD01M7edM3<00?@00?<dM000_D2d0;A00Gad=3<d002[003S8R8009X0d@01FR<R8QX00:800IXR4A4
J4@49003A2@T01HT00=492@00R@8A004J4A4A0DT1T@390=400<TA4@00T@69003A2@T00<T24@69094
00<TA4@01R@014@TA4@29003A2@T008T1d@012A4A2@4A00394A4009400=XA6P01d@2J005A6QXJ8P0
0VP3R0=X00B<R8R80X`01Zc@[=2/c0:/0]000lb/d002d003c:c<00:/00><[8`02J`002940R@CA003
94A4009400@TA2A40R@2A00594A4A2@00T@00bA4A005A00594A4A2@00d@00bA4A007A09X00A4J6R8
0VP2R004S8R<S0F/00B<[:c@0/`01Jc@d=3<00>/0/`3d003c=7@00;@00?Ad=401=001<b/[8P3S0:/
00B<[:b/0X`01jb8S<b<[8`00hP00hb8R002[003d<c@00;@00?AmO404OD00oWem@0=m@03nOGe013e
0_T@m@04nO[im@;i0oX01oW@R8R<[=000Z`01Lc@lOGA00B/00><[8P00Z`00m3em@02m@06nO[jn_Wj
0oT2m@03dJb800940b@5A00394A400M400=XR6P00XP018c@[?42m@03lOGe00[e00GAmOGel@02m@03
lOGe00Ge00?AmM000]000lc@d002d003dM3@00;@00Gac<cAd002d@?@0m400o7em@03m@03nOGe00ce
0_44m@C@00?Ad<`00X`3R004J4A4A09X1D@00fR8R002R0IX1d@00fQ4A002A003J4AX009X18P2S006
d:c@[=2/1=000oGAd@02m@05lM3<d:`00m001]7elOGAl@;e0]001:c<[:`3R003A6Q400M400AXR8QX
14@3909432@00d@T90079003A2@T00@T0T@390Q40b@5A0DT0T@012A492@4A0@T14@29008A2@TA2A4
94@69003A2@T00A40b@2A00394A4008T1T@00bA4A006A00394A400M40fP01HQXJ4AX00I40VP6R007
J8R8R8b/S002[003c=2/00;<1M002/b/c<c@c:c<d<`2[004S:b/S0:/00><[:`00J`002M400><R4@0
3T@2909400@TA2A40R@7A0<T2T@00bA4A00?A0>80fP00hR<R002R006S:b<[8b/0X`3c0;@00>/d=00
0]000lb/c003d005c=7Ad=402=02[0:<00B/S8b/0X`3[006S:b<R:b80X`3R00;S6QXR:c<[=3<lM40
3oD2n@04mOWin@Ge00?imOD01_D00oWen@0=m@?i00?enOT00_D00oWem@05m@03nOGe00;e0_X3m@03
nO[j00;j00Se[8b8S<b/S0;@00?elM400Z`01Xb/S8R<[0;@1?D01?Wjn_X3n@08n_WenO7@R6P5A003
94A400E400<TA4@00d@00fQ4A002R0>/00C@lOGa0_D00oWem@07m@06lOGed?Ga0_D00o7em@03m@07
lOG@dO7<d@03d006dM3Ac=3a0m001/cAd=3ed0;A00C@mM7a0_D2n@05mO[emOT01OD00oWem@03m@;A
1?D3d0>/00?<S8P00fP01DAXJ4AX00E400EXR6QXA002J003A6Q400=X1T@00fQ4A005A09X00>8[8P0
0X`00lb/c006d003dO7e00?e0]001m7<d=7@lM400_D01M7emM7e00C@00>/R8`016P6A006J4AXR6R8
14@59004A2@T008T0P049003A2@T00DT00=492@01R@014@TA2@5A0<T1T@29003A2@T00HT00=494@0
0T@29004A2@T90E412@014@TA2@2A0<T00=492@012@2A08T24@2J1A400AXA6Q40VP2R09X0XP2J005
R6R8J8P00fP00hb8R002R003S:b/00F/1<`2d0;<00_@[:b/c=3<[<c@c003[005S:b<[8`01:`002M4
0VP?A00994A4A2A494@T00Y400DTA4A49004A00494A4909400@TA2A40R@2A00394A400=41fP7R003
[8R/00:/00><[<`06]04[005S:b<[8P01J`2S0:/00F<R8aXS004R004S<c@c0;@0_4@m@04nOGen@ge
00?imOT03?D;n@Ce00?imOD01OD00oWjm@03m@Cj0_T01Jb<R8b800:<00B/d?Ge0]04[0:80Z`00m7e
m@02m@03nO[j00Gj0_T01?Ga[8P2J0A400DTA4A49002A00394A400M400UXR8b/c=3AmO402oD2l@04
dO7@l@;e00?AmO401OD01O7ed=7a00[@00CAc=3<1m001?7@dO4:m@03nOGe00Oe00?amOD00oD00m6/
d005[003S8QX00:800EXA6QXA002J0=400=XA6P00VP00hQXJ004J09400=XA4@02d@2R003S8R800:/
00G<[:b/c002d003dOGe00?e00GadLc@c002d007dO7elOGam@05d003c8R8009X1T@016Q4A4@2J003
R6QX00E462@014@TA4@290A412@5A00394A400E41B@2A08T0T@290=40b@2A00394A400A41B@5A003
94A400941R@00d@TA002A00394A400A400<TA4@01D@00bA4A002A00394A400940fP014AXJ8P7J0:8
0X`3R09X0hP00jb8[008[004d<c@c0;@00?<[=000/`01Jc<[=3<00;@00?<[:`01J`00hb/[002[000
7D@00bA4A005A00594A4A2@00d@00bA4A008A00394A400<T0d@00bA4A003A003J4A400M400<TA4@0
0T@00bA4A002A00394@T00]400=XA6P00VP2R006S8QXJ8R<0XP02Jb<[:c<[=2/c003d003[=3@017@
2Z`2S003R:b/00:/0X`00jb8R002S004[8R<S0;<0]000m7ed00Dm@04nOGen@Oe0_T2m@03nOGi00[e
00?imOT01oT00oGim@0;m@04n_Gem@Kj00kimM28J4AXA8R/lOGAd0B/0X`00jb<d003m@03nO[j00?j
00?in_X00_T01?[ac8P8A00594A4A2@02T@2J0:<00C<lM7a3OD01o7elM3adOD00_42m@04lOGem@;a
00C@lM3a0]000m7@c008d003c:c<00?@0]43d0Ge00?imOD02oD00o7em@04m@05lM3<d<`00Z`018b/
S8P3J003A6R800=X0d@2J0B816P4A00394AX00=400=XA4@00T@2J0B80X`5[004S:c@l@Ce00CamO7a
0m001?7@lO43m@04lOGAd@;@00?<[8P00fP;A004J8R/J0E45B@3A08T0T@690940R@2A003J4A400U4
00<TA2@00R@2A00494@T90E40R@3A003J4A4009X00=494@034@790i400@TA4@T0T@290Q41VP018QX
J6P3R003J8b/00><00>/R8P00XP01Jb<S:b<00>/0/`3[003d<b/00C@0l`00m2/c002[003d<c@00;<
1Z`00hb/[002[0007T@00bA4A004A00394A400I400<TA4@02d@290E400DTA2@TA00490=400<TA4@0
0T@2909400DTA2A49003A00794A4A2A49005A09X00B8J8b80VP4R0V/00?<d=001=02d@;@00N/d=3@
dM3A00K@00B/c=3<0j`00hc<S006[004S:b/[0:<00F8S8R8S002c005[<cAmM404?D00oWem@0>m@03
nOGe00[e00?jnOD00oD3n@04mOWin@ce0_T00oGam@02nP03nO[j00;j00[ed:aXA6Q4J:c@0_D01_7@
[:b<R0>/00C@lOGi1OX00oWjn@02nP05nOGA[8P01T@390a40VP2R006S8S<dO7e0o49m@04dO7am@;A
00?@lOD00oD00m7el@02m@;a00Ked?7AlM44d005lM7alM400]000jc@d@02d@G@1OD00oWem@0Bm@05
lM3@dM000j`01Xb8R8b8J09400F8J6R8A003R004J8R8R0=X1T@00bA4J002A003J4A400A41FP6[006
c:b/[=7a0_D01O7AmM7e00;@00?AlM401?D01?7emM42d0;<00N<R6R8J4AX00M40fP2R003J4A40094
00<TA4@02b@2A0LT00=494@00b@00d@TA0029003A2A400m40R@2A0@T00=492@00b@2A00394@T008T
1D@00fQ4900<A0DT00=494@044@290E400=XA4@01D@00fQ4A005R007J8b8[8R/c002[004S:b<[0B<
00>8S:`00j`02hc<[8R/d:c@[=3<00:/00><[<`00/`3[003d8b/00J/00?@[:`00X`1[000A4@390A4
00<TA4@014@00fQ4A00;A00394A400A400<TA4@00d@01fR8R8b/R6P01HP01Jb<[:b<00>/0/`00m3<
d002d005dM3@c:`00m000o7@d004d0C<0]03[003S:b/00N/00>8[8P00X`016R8R8P2[008d<c@dOGa
mO4>m@03nOGe00ke0_T;m@;i0oD01oWjnOGimOT02oD00oWem@02m@03lOGi00;i1OX01OG<R6Q4009X
00J/d?GamM42[008S:b<c:c<dOD2n@?j1?T2nP;e00GA[8Q4J006A00694A4J4AX2D@01HR/R:c@00;A
00CelOGa2OD01M7ed?GA00;@00?Ad?D00oD2d@07mM7edO7ed002l@0;d=7@d?GadO7@dM000/`01=7@
lM42d003c=3A00Ce00?imOD00oD00oWem@06m@04lOGel@Ce0]004:c@d:c<[<aXR8b8A6R8J8P2J003
R6R/00:80X`2R003J4A400M400<TA6P00T@00fQ4J003A005J4AXR8`00Z`01<b/c:`2c005[<celOD0
0]402?GAd?G@dOGA1?D2l@04mM3<d0:800EXR4AXR00:A004J8R8J0A400@TA4A44b@3A08T00=494@0
12@BA00394A400@T14@490940R@3A006J4A4J4@T0d@00fQ4A008A0<T2T@290I400<TA4@01D@00fQ4
A002A008J4A4J4AXR6P3R0:<00B8S8R80j`02hS<[:b<[8b/S:b<00>/00R<c8b8c:b<[0;<0j`01Hb/
c:c@00;<0Z`00hb/[002S0:/00?<[:`00j`1J0006D@00bA4A00290=400<TA4@01D@012A4A2@;A005
94A4A2@02D@01RA4A2A490Y400DTA4A49003A00394A400E400<TA4@01D@2J0:800=XR8P00hP01Hb8
R:b<00>/00><c=003M001=7@d<`7d0:/00><c:`00Z`01Xb/S:b<[0B<00B8S8Q40VP00hb/[002d003
dO7e00;e00?amOD07_D00oWem@0>m@Ci00GenOGen@0<m@04dOGem@?i1?X01?WedHP2J004A8R/d@?e
00Cad<b80j`00hc<d@02m@;i00?jnOT00oT2nP;e00?a[6P00T@5911400B<[:b<0]001OGAlO7A00We
00OamM7ad=7@00;A0oD00m7ed@02m@Ca00?elO400_42d003lOGe00;e00GA[=3<d004l@04c?7@d@Ge
00CjmOGi0_D00oWem@0>m@;@0/`01=3<S8`3R0=X00B8J4AX0XP01hb8R8aXS8P016P00dAXA00>A0=X
0XP00jb<[002[004d<c<[0;@00WelO7AlM3AlM000m47m@;@0Z`4R0E400<TA4@014@00fR8R002J0A4
00<TA4@012@00d@T900=9003A2@T008T00=494@01R@;A0=X00A492A432@<A00494A490E400AXA4@T
14@390E400=XA2@01T@2J0A400@TA4AX1T@016Q4A6P3R003J8QX00:800V<R8R8S8R<[8`00j`01Xb/
S8b8S0:/00J8[:c<S8P2[003S=3<00:/00?@[:`00Z`01Lb/c:b<00>/0X`9[05X000PA00394A400Y4
00<TA4@08d@00bA49004A08T0d@00bA4A00=A0:80VP2R004J8R8S0:80X`5[003c=2/00;@00B/d<b/
2=001<c@d=03[005c:c<[<`00Z`2d003c:b/00:/00N<R8b<[8R<00=X00B<[:c@0/`01M3emO7A00ke
00?imOD02oD00oWem@02m@03nOGe00_e00CimOWj0_T2m@;i0_D00oWen@02m@03nOGi00Ge00?amOT0
0_T4nP04nOGA[0=X00R8c=7elOGad0>/00K@[8b/d?D5n@03n_Wj00?j0oD00jaXA002A00494@T9114
00F/R8R<[002d005mM7ad?402?D01O7edO7A00C@0_401?GamO43m@04lOGal@;e0o42m@04lOGel@;A
0]02d@07mM7alM7el@04m@03nOGe01?e0]44d003c:b/00:800><R6P016P00hQXJ002J003S8R800:8
00B<R6QX0hP2J005A6QXA6P00d@2J0=40fP018R<[8P2[003d<b/00;@0]401OGadM3A00;a0]000m7a
l@05m@04lOGAd0:/00B<R6QX0T@01BA4A4AX00A40VP00hb8A008A0@T00A494A44B@3A08T0T@290I4
00EXA4AXA003J0I400@TA4A41R@:A003J4@T00E400<TA4@00T@290E40R@6A08T1d@00fQ4A00290Y4
16P8R003[8b800:800B<[8b/0X`:R005[8b/S8P00Z`01Hb/S:c@00N/00><[8`00j`01XR/[8b/S0:/
0XP1S06/000EA00394A400U400<TA4@024@00bA4900<A0@T00E492A4900KA00394@T00<T14@00bA4
A002A0AX00A4J6QX18P018b/S8`3[003c=3@00;@00?Ad=000Z`2d005c=3@dM000/`00m2/[002[0?<
00F/c<b/d003c003S:b/00:/0XP01jb<R8b8J8P00X`4[004d?Gel@Ge00?ad?405_D2n@03mOWi00ge
1OT00oGim@03n@;e00?imOD01oD01_WemO7en@Gj0oD01jaXJ6R<d?400oD2d@04c=2/S0:800B/c?7e
1_T4nP?e00>/J4@00T@012A4A2@6A003J4A400A40VP024B8S8b8[=3A0oD00m7em@07m@Ca0]42d003
dO7e00We00?amO400_400oGAm@02m@03lOG@00;@0]42l@04dM3@d0;A0o47m@;i1oD00oWem@05m@0:
lM3Ad<b/c:b<[0:80T@4J005R6QXJ4@00VP018R<R8P2J0>800><R6P014@2J0I400AXA6Q40XP018b/
[=02c008[=3@lM7elOD3d@05lM7edO402?D00m7<[003R09X2d@00fR8S003J0E400=XA2@042@00d@T
A00590=40b@014@T92@2A003J4A400AX00>8J6P00d@290Q412@6A09X0d@390A400<TA4@00d@00bA4
A008A00394A400A400<TA2@014@29003A6R800Q40VP00hQXJ002J0B800EXS8R<R004S0>800Z<R8b<
[8R<J8R/0X`01Lb/R:b<00F/00?<[:`00X`01Jb<S8b/00:<00b8[8b<R:b<[8b8J8`1[000<4@00bA4
A00>A0@T34@00bA4A008A00394@T009400@TA4A40R@5A003J4A4009X0d@00hQXR004R007S:b<[8b/
c002d0;<00S@c<b/d<c@d@C@00?<d<`02Z`01Xb/[:b8S0B/00><[8`01hP00hb/[002[005d?GemO40
1?D2d0;a3oD00oWem@02m@03nOGi00Gi3?D3n@;e1OT2m@;i1OD02OWemOGimM7en@05nP04nOGec0>8
00?@dOD00oD2d003c:b/00:/00B8c:ca0_D2n@03n_Wj00Cj0_D01=6/J4@291540VP01dB8S:b<c=00
0oD01O7@mOGi00Oe00OamOGAlM3A00;a0_D00o7ed@02m@08dOGelOGadO42d@04mM7Am@;a0]001]7@
dM7<[0;@00GAd=3el@03m@03nOGe00;i2OD01?WemOT3m@05dOGad=400Z`00lb/[002S005A6R<J8P0
26P00jb8S003J09400><J6P01D@00fQ4A008A004R6R8S0>/00?A[:`00]04m@08lM7ed=7adOD2l@07
nO7emM7el@02d003[8QX009X1T@00fQ4A003A004J8R8R09X0d@00bA4J002A1PT0T@2909400<TA2@0
2T@00hb/J002A0<T2D@29003A6Q4009X1D@00fQ4900290I400<TA4@00T@00bA4A00@A00394A40094
00DTA4A4J006A0=X0XP4J0R800>/R8P01hP01Hb/S8QX00:80X`6[003S:b/00>/0X`5[0B<00>8S8`0
0X`00jb<[002[06<0J`1S000<4@290a400DTA4A4900HA00394A400=40R@2A00594@TA2@01d@00fQ4
A003J0>80h`00hR/S003c0>/00G<[=2/c004d0C<0Z`00lb/[003[007S:b/c8b/S005[0B<00J8S8QX
R6P2R0B/00?@dOD01oD2lAKe00CimOGe0_T00oGin@0=m@Wi00?enOT01OD01OWemOGj00Ce1OX02?We
mM28S:c<0_43m@04dM2/[0><00AXS:c@0oD2n@Kj0_D00m2<J002A0<T0T@01BA4A4AX00A400MXA6Q4
J8QX00:80j`02?7emOGad=7e1?T8m@04lM7Ad@Oe00?AmO401?D01O7AmO7e00?A0o400m7@d002[004
S:c@[0;@00?Ad?401oD3n@Ke00?imOD01OD01=7@dO42d003c:b/00:/00><J8P00hP00fR8A002J094
0VP3R0AX00>8J4@01d@00fQ4A007A003J8R/00>/00_<d:c@lOGamO7el@02d@04lM3ed@;e00?AmOD0
0_D2d@03d<b/00:800=XA4@034@4R003J4A400<T0T@G9003A2A400@T0T@490Q416P2A0@T14@00bA4
A00290U400<TA4@03T@012A4A2@3A00394A400U400<TA4@00d@00bA4A002J0E40VP014AXJ6P7R003
J8R800:800B<R8QX0hP00hb8R004R003S8R<00B/00C<[:b/0/`7[004S:b/[0:<1XP00hb8[004[06<
000GA00394A401M400<TA4@00T@00bA4A004A00394A400U400<TA4@014@00bA4A003A00394A400E4
0R@024@TA2A494@T2T@3J0:800><R8P00XP018b8S8`4[003S:c<00B/00?<d=001=001<b/[8`2[003
S:b/00R/00><[:`00j`00hR<R002R00=J8aXR6R8S:c@lM3ed@0:m@03lM7e00Oe00?imOD00_D01_We
mOGim@;i0_D3n@Se00?amOD01?D00oWen@03n@06n_WjnOGi0_D00oWem@03m@;i00WelOGjnO[imOT0
0_D01Lb<S8S<00Ge00G@[:b/R002[004R8b/d0?e0_T6nP;e00G@R4A49002A08T3d@00hQXR003[003
c?Ge00?e00CAmO7e0_T8m@03dOGA00?A00KamOGimO46m@03lOGa00?e00?AlO400_401=2/[8`2J0F8
00C<d=3A0oD01oWemOGimOT00_D00oWem@08m@?a00?AlM400]001Lb/[:b<00:800B/J8QX0d@00fQ4
J002J004A8b8J0B80VP3A004J4A490=400<TA4@01D@00hR/[002[003d=7<00;@1OD2d@;a00OAmO7e
lOGa00;e0_401M7@d:b<00:834@2J0:800><R8P014@<909412@00d@T900390E412@3A08T00=494@0
24@2J0940b@2A0DT00=494@00T@00bA4J003A08T00=494@034@290Q40VP3A00394A400Y400=XA4@0
14@00fQ4J004J006R6R8J8QX0XP6S003R6R800>800><R8P018P028b8S8b/S:b<0Z`2c0:/00?@[:`0
0j`01HR<R8R/00B800><R8`00XP00jb<[002[00000=4J4@044@01BA4A4@T015400@TA4@T3d@29005
A2A4A2@01D@012A4A2@JA00494A490=400@TA4A41FP018R<S8P3S0:800><[:`02J`2c0;@00C<[=2<
0Z`2S003[8b/00B/18`00jb<[002[0><0Z`4R0=X00F8S:c@m@02l@;e00?amOD01OD00m7el@0<m@04
nOGen@;e00?imOT00oT2m@04nOGen@?e00?amOD01_D2n@03mOWj00;j00CimOWe0_T7m@03nOGe00;e
00CimOWi0oD01Jb8R8S@00Ge0]400lb/R002R0:<00F/c?GenP02n@Gj00GimOG<R002A00394@T008T
0T@01BA4A4@T00A40fP014B8J8`4[003dOGe00;e0o4;m@;a00GelM7el@05m@03lOGe00?e00?AlOD0
0oD2l@05d?7a[8P01FP00hQXJ002S003c=7e00ce00?imOD00_D00oWem@04m@05lOGemO400]400m2/
[002S0>800AXR4A416P3A003J8b<00>800B<R6QX0T@3J003A2A400U400AXR8R/0]02c004[<c@m@;a
00?elM401?401]7amO7el@;e00?amM000Z`2R003J4A400Q40R@01TAXJ8R<R0=X00=4J4@02B@00`0T
9008909400<TA2@02b@014@T92@:A005J2A494@00b@00d@T9003909400<TA2@014@690A400=XA4@0
1D@290E40R@CA003J4A400I40fP01DAXR8b800=X18P00jb<R002R003J8R800:800AXR8R/0hP02:b<
S8R/S:b<0Z`01]2/c<b/c0:/00><[:`00X`01Jb8R8QX00>800><R:`00j`2R00054@00bA4A00AA004
94@TA08T00=492@04D@39005A2@TA2@01D@290=40b@2A0<T3D@00bA4A003A003J8R800AX28P00jb<
S002[0;<1j`00lb/c003d007[8b/[8b/R004S005[8b<c8`00Z`01HR/[8b800J<00]XR8QXR8c@c=7@
l@0<m@03lOGe00[e00SimOGenOGim@Gi5?D00oWjnP02nP03mOWe00?e00CimOGi0_D00oWenP04m@;i
0oD2[003R:ca00Ge0]001:b<R6P2R003[8b/00;e0_X00oWjnP02n@;j00CimM280T@5909400<TA4@0
0T@2J09400EXA6Q4J003S007[<c@mO7el@02m@03d?Ge00ge00Gad?G@l@04m@03lOGa00?e0_401]7e
lO7el@;@00J/R8R8J4@3J0B80]45m@07nOGemOWen@02m@;i00CenOGi0_D00oWem@04m@04dOGad0:/
00><[8P00fP00hQXJ003J0A40VP2R006S8QXR8aX0d@3J0Q40VP00dAXS003[006d<c@c:c@0_400oGa
m@03m@04lM3ed0?e00CamO7e0_401M2/S8QX00i400EXR:b<R002J0=41R@00d@T900<90=422@3A005
94A4A2@034@39003A2@T008T00=492@00b@014AXA4@49004A2@T90=400<TA4@00d@290940R@4A0<T
0T@00bA4A002J0A400<TA4@00T@016Q4A6P8A09X00>8J6P01XP018b/S:`2S0B800^<[8R8S8QXR6R8
J005R003S:b<00F/00F8[8R<[002S003[8R800><00>/S:`00XP3[0:<0hP000E400=XA4@094@00bA4
A002A00394A400=400<TA4@02D@2909400<TA2@04T@00bA4A007A08T00E494A4J003A09X00F8J6R8
J002S005J:b<S:`00h`2[004d<c<c0:/00?<S:`00j`2c003d8R/00B/00J8S8b<[8P2S003R:b<00><
00B8S8R/0XP00fR<R003R09X00>8[=000]000oGam@0:m@03lOGa00Ke00KimOGimOT2m@;i00Cen_We
0_T00oGjm@02n@Ge00?amOD02OD01oWjnO[imOT00_D00oWem@02m@03nOGe00?i0oD00oWem@02m@>/
00?elOD00oD01=7@d:`2J007S8R<[6R<c002m@05nO[in_T00oX2m@03d8Q400940b@8A003J4A4009X
00E4J6R8S002R004d:c@l@Ce00GAmO7en@09m@03lOGA00?a0_D00o7im@02m@03dOGe00;e00SamOGa
d?G@d@:/00>8J8P00VP014AXR6P3R004[=7ed@?e00OimOGjnOGi00;e00KjmO[imOT2m@03n_Gi00;e
00[imOGedO7A[8b/0XP00fR8J004J003R4A4009400=XA6P01FP00hb8R002R09X34@2J0F/0]000lc@
d002l@?e00_amM7adM3amO7ed@02m@04dOG@[0>800=XA4@00d@2J0I400=XR8P00hP2J0941b@00d@T
9009909400<TA4@06D@00bA4A005A08T00=492@012@5A0LT0d@290E400@TA4@T1d@2909400@TA4AX
0d@290a400=XA4@00d@3J003A6QX00B800><[:`00Z`01Lb<S6R800><00F/S8aXR003J0>800EXR8b/
R007[003S:b/00B/0XP01Hb8S8b/00B<00B/R:aX0XP002Q400<TA2@01T@290e40b@014@T94@39003
A2@T00<T00=494@01D@2909400<TA2@01d@00bA4A003A004J4@TA0IX18P2S003[8R<00><00F/d:b/
c007[0;<0Z`00hb/[004[003R:b/00:/0X`2[00:S:b8[8b8[8b8S0:800J<J6R/S6P3[0;@00?amOD0
2_D00m7el@0:m@03nOGe00?e00KimOWimOT2m@03nOGe013e0_T01OGinOGi00ge00GjmOGen@03m@05
lLc@d=401_D00m2/S003R007[8b<R8b/l@02m@03nO[j00?j00KimOG@R6P2A00594A4A2@01d@00fQ4
J002J0B800F/S:c<d@05m@03lM7e00ge0_400m7el@0?m@06lOGed:b81FP00dAXJ003R0:<00?@dOD0
1OD2n@?e0_T01oGinOGimOT00_D2n@Ge00GamO7Ac002[0:800B<R8Q40VP2R003J4AX00IX0T@01fR8
R8R<[8P02D@00bA4A002A00AR8b8[<b/c=3<d=7elOGamO400oD00m7al@07m@07dM2/R6R8J003A003
J4AX009X14@3J0B800AXA4A412@00d@T900>909400<TA4@014@00bA4A004A0<T1d@01BA4A4AX00A4
22@2A0@T00E492@TA004909400<TA2@00T@00bA49002A00494A490A40R@9A00394A401540fP014AX
J8P3J006R6R<[8R/0X`00hQX[002R005[8R<R8`00hP00fR8J002R003[8b<00V/00F<[8b/S003R006
S8R8S8R<1HP1J0680J`000e400<TA4@03D@00bA4A004A00394A400m400<TA4@014@59003A2@T00=4
1b@:A0HT1d@29003A2A4009400@TA4A40VP00dAXJ002J0:80X`018R<S:`2S003[<b/00>/00><[8`0
0j`01<c@[<`3[007S:b<S:b<R002[008S:b/[8b/R8`2R005S:b/[8`018P3J0:/00C<d=7a0oD00o7e
m@04m@07lOGAmO7ed@04m@03nOGe00Oe1OT>m@03lOGe00oe00?imOD01oD00oWem@05m@03lM7a00Se
00GAc:b/S004[0:<00J/mOGin_T4nP?e00?@S4@00T@012A494@390M41FP3R003[<cA00Ke00?AmO40
3OD01=7adM0@m@05dOGA[8P00fP3A09X0hP2[003S=3A00Oe00CimOWe0_T2m@03nOGe00Oe00?imOD0
1?D01O7@[:b<00F800=XR6P014@3J005R8b8J4@00XP2J006R8aXR6PT14@490=400MXR:b/c=3<00C@
00CelOGa1OD00m7am@02m@?a00GAmM3@[002R0U400MXA4AXA6R800EX1D@00bA4900A909400<TA4@0
0d@290E40b@5A005J4A4A2@01D@00bA490049003A2@T00=412@2A00494A490A400<TA4@01D@29004
A2A490=400<TA4@00T@00fQ4A00?A003R8a400M41FP018QXJ6P9R0:<00B/R6R<0Z`3S0B800=XS:`0
1:`01hb8[8b/S:`00h`01jb<R8b/S:`00hP00hb8R004R06<0J`000a400<TA4@03D@00bA4900MA004
94A490940R@00d@T90029003A2A400@T1T@022A492A494@T0T@00bA49007A00494A490A40VP2A09X
0XP5[0:<00F/S<b/S002[005S:b/[<`00j`00lb/[004[003S:b/00:<00j/S8b/R:b8S6R8J8R<[0:8
0VP00hQ4R002J004R8b/d0;a00?elOD02?D3l@03mO7e00[e00CimOGe1OT01?[inOT>m@03lOGe00We
00CimOGi7?D00m3Ac006[005S:c<d?D00oT3nP;i0_D00m2<J002A0<T00A492@T0d@016Q4A4@3J004
A6QX[0:<00F/d?7el@03m@03dOGa00?e00?amO401oD00m3em@04m@03nOGe00Ge00?imOD00_D01=7e
c8`2R09X00M4J8R/R8b800B/00?<dOD00oD01?WemOT2m@05nOGinOD00_T4m@04nOGen@Se0]000lb/
R004R09X00=4J4@00d@4J004R6QX[0F80VP00d@T9004A08T0d@016R8[8`2c0G@00?amO401OD00o7e
m@03m@03lOGA00;e0m0018b8J6P8A004J4A4A09X00>8[8P00XP00fQ4A004A0HT00=492@02R@6A0@T
0T@00bA4900590M40R@6A08T0d@00bA4900;90E40R@5A00394A400U400@TA6R80VP4A003J4A400Y4
0fP6A0UX00>8J8P01XP018b8R8P2J00;R8b<R:b8[8R/S:`00X`2[0:<00B8S8b/18`3R003S8R<00:<
00B8S6R80h`01:b<S8P1S00024@00bA49005A00394A400Q40b@EA00394A400I40R@5A00394@T008T
00=494@012@2A00494A490E40R@01d@TA4@TA2@01T@290I416P01DAXJ8R<00:80Z`01hb/[8b/S:`0
0X`2[004R:b/d0>/00?<d:`00j`00lb/[003[005c:b/S:`00X`02ZaXJ8R<[8QXR6P3A09X0XP018b/
[=02d@Ce00?amOD00oD00o7ed@07m@03nOGe00;e00CjmOWi0_D02OWenOGin_Wen@02m@03nOGi00Ke
00CAmOGa1_D01?WemOT7m@03nOGe00;e0_X01OWemOGi00Ce00?imOD00oD01_WemO7@c0J/00C@[<c@
0_D3n@;j0_T01?G@d8`2A0DT00A494@T1D@3J0940VP00hR/[002d004lOGen@?e00?@lOD00_D00o7e
m@05m@03nOGe00Ge00?imOT00_D00o[em@06m@03lM7@00AX0T@00hR/d002[004S8R8[0;@00?AnOD0
1oD00o[en@02m@05nOGinOD00_T01_GimOGim@;i0oD2l@;@0h`2R0=X00A4J6Q40VP2R09X00J<R8b8
A8P6A08T14@00bA4A003A0:/00><c<`00/`3d005mO7AmO401OD00m7el@02m@09dO7ed?G<d:b8009X
1D@4J0=400B8J:b/0h`00hQXA003A1DT1D@00bA4900:90940R@<A08T0T@290940b@00d@TA00590=4
1B@4A00394A400I40R@014@TJ6P7A003J4A400E400<TA2@00d@2J0I40VP00hQXJ002J004R8b8J0>8
00>/S:`00XP00hb8R003R004S:b8S0N/00><[:`00X`018R/R8`2[003S8R800><0XP2S003R8aX00:<
00=XS:`00Z`1S06/000DA00394A400=400<TA4@024@00bA49009A00394A4009400<TA4@01d@00bA4
A002A08T00=492@00b@00d@TA002A00394@T009400LTA4A494@T009400<TA4@00R@;A003J4AX00EX
18P3S003d:b/00:/00><[:`02j`00hb/[003[003d:b/00B/0X`2[0:800B<R8QX0hP00fR8J003R003
S8R/00:/00C@dO7a2oD00o7em@0@m@?i00CenOWi0_D00oWem@07m@;a00?AlO401OD00oWem@0=m@?i
0_D00oWem@02m@03nOGe00Se00Cad<c<1J`01M3<[=3A00?e00Cin_[i0_D00o7<J002A00394@T00=4
00<TA2@01T@4J004A6R8S0;@0]45m@;a00GAmOGel@03m@03lOGe01;e00?imOD00_D00m2/R002A0AX
00F8d=3@[002R004[=2/d0_e00CimOGi0_D00oWem@02m@;i0oD00oWem@04m@;A00?@[8`00X`2R09X
0hP00dAXR002R0IX00A4J6QX14@390=40R@3A004J8R8S0:/00C@c=3@0]400o7Al@04m@03lOGe00?e
00GamM3el@02d003c:aX00=X1D@01VQ4A6Q4J0:800F<R8b<[002J0944R@00d@TA00390=40R@00d@T
90049004A2@T90=400<TA4@03d@790A40R@01d@T94AX94@00R@>A0<T00=4J4@01D@00fQ4A009A003
94A400EX0T@2J003A6QX009X2XP00hb8R004R004J8R/R0J/00G@[:b<R003[005S:b8S8P00Z`00hR<
[002[003S8R800:<0Z`6R0:<0Z`000Q400DTA4A49004A00394@T00a400<TA4@01d@01RA4A4@TA08T
00=492@02d@00bA4A004A08T0T@00bA4900290940R@014@TA2@4A08T14@00bA4900290e40VP018QX
J6P2R003[8b/00B/00>8[8`00Z`00hb/[006[003c:b<00B/00?<[:`01:`00hb/[002S003J8aX009X
00B8S8QX0hP2J008R8b8S:c@dO4<m@03lOGe00[e00?imOD00oD5n@03n_We00;e0_T00oGim@05m@Ca
4OD01?WemOD2nP03nOGi00;e00?jmOT02?D01oWemM7@[=000j`2c005dM3<[=000_D4n@06mOWelJaX
0T@3909400<TA4@01T@4J005R6R8R:`00]000m7@m@04m@03dO7a00ke00?ad=000]05m@03nOGe00Ge
00[@[8QXA6Q4J:b80j`2S003R8b/00:/00?amOD00_D00oWem@06m@04nOGen@;e00CimOGe0_T9m@03
lM3@00F/00><J6P00VP00hQXR002R09X00=4J6P00d@3J0A412@2A08T0d@3R0:/00?<d:`00]001=7a
lM43m@03lOGA00;a0oD03?7edOGAd<b/S8Q4J0=40VP014AXA4@3J003R8b/00>800F/J6QXA0049004
A2@TA0dT14@39003A2@T00<T34@00bA4A00<A0PT0d@29003A2@T00A40R@>A00394A400E400=XA4@0
0fP5A00394A400A426P3A005J8R8R8`00hP00fR8S005R00;S8R8J8QXS8R/R8`02J`01Lb/c8b/00:<
00B/S8b<0j`00hb/[004S004R:b/S0>80H`1R06<000?A00394A400=400<TA4@024@01BA4A4@T00Q4
00<TA4@014@012A4A2@3A00394A400A400<TA2@00T@690=40R@00d@TA00AA00394A400A40R@4A003
J8R800F80h`00jb8R002[0><00B/S:b<3:`4d0J/00F<[8R<J007R003A6R800:800UXR8R/S:c@dO40
6OD3n@?e0_T00oGin@03n@06mOWinOGi1_D2l@03dO7e00Ge00?imOD02?D00oWem@04m@;i0_D00oWe
n@0;m@;A00?<[:`00Z`00lcAl@02d007c=7emO[en@02m@07nOGA[8QXA00290A400=XA4@00d@00fQ4
J002J0>800><[<`00m02m@03lOGe00;e00?amOD02?D01_7edM2/c0>/0]001O7emOGi00;e00WimOGe
d:b8J4@00VP00hR<d002[0F80Z`01Lc@mOGi00;e00?jnOT01OD2n@;e0oT01?GinOD3n@We0]02c0>/
00R<J6QXA6Q4J0F80VP00dAXJ005J003R6Q400U40VP2S008[<c@d<c@[=02l@03d?7A00Ce00CadOGa
0_D02?7elM7ed:b80fP00dAXJ009J003R8b/00B/00B8A4AX0d@49003A2A400/T14@5909400<TA2@0
0T@00bA4A003A00494A490a40b@00d@T900490Q40R@00d@T9005A004J4@TA0<T14@490A400=XA8P0
0VP01DB8A4@T00A400<TA4@00d@01FR8J8QX009400=XA6P00hP01FR8R6R<00=X0hP00jb8R003R0>/
00>8S8`00XP2[005c:b/[=000Z`00hR/[008[0><00F/R:b<[004S0F8000VA003J4A402Y400<TA4@0
2d@390E400<TA4@01d@026R<[8R<R6R80h`01HR<S:b800:/00><c:`00h`2[003R:b<00F/00S@[<b/
c=2/c0>/00>8[8P01XP01Jb<J4B8009X00^8J8QXR:c<d=7el@05m@03lOGe00ce00KimOGimOT4m@03
nO[i00[i1_D00m3ed002l@Ge00?imOT01OD00oWen@0:m@03nOGe00;i00GenOGen@06m@03dOG@00>/
00B<[=3A0]000m7am@02m@04nOGin@;e00?<[6P00T@290Y416P2R005[8b/S:`00]001O7AmOGA00[e
00?amOD00_D00o7@d002S003[8b/00>/00GAmOWen@02m@05n_Ge[8P00VP00dAXR002S005d:c@[8P0
0j`01=2/[=04m@03nOGj00Ge00GimOGim@02n@0:mOWemO[enO[enP;e00_imOGelOG@c=2/d002[003
R4A400940VP2R0EX00A4J6Q40VP2A003J8QX009400AXA4A40VP014B8[8`5[0?<0]000o7@l@04m@04
lOGad@;e00WAmM7edM3A[8P00VP00hQXJ003J003A8R8009X00J8J8R8[8`2d003[4A400E412@3A0LT
00=492@00R@2A00394A400<T0T@390I40b@00d@TA00AA0<T1d@00bA4A004A00394A400A400EX94A4
9002A08T2T@00fR8J002A09X0d@00bA4A005A09X00=4R6P00fP2R007J8R8J8QXR002S0:800EXR:b8
[002R007J8R8S8R<R002S003J8R800F/0/`=[004S:b/[0:<0Z`4S003R6R8006<000FA00394A400M4
00<TA4@01D@00bA4A00GA00394@T00A400DTA4@TA0029004A2@T909400HTA4@TA2@3A00394@T008T
1D@012A4A2@6A003J8R/00:<0fP00jb<S002S006R8b8[8b80X`00jb<[002[0F<00>/S:`00Z`018b/
[<`7[004R8aXS0B800=XR6P00fP018QXJ6P2R003[=3A00Ge00CamOGa1?D00o7em@0:m@03nOGi00;e
0oT00o[in@04n@03mOWe00Oe0m400o7Am@08m@03nOGe00Ge00?imOD00_D00o[em@03m@?i0oD00oWe
m@02m@07nOGemM7@c004[003c=3@00;@1OD2n@05mOWa[8P00d@290=400>8J4@00d@7J0:800V<[=2/
c=3AmO402OD00m3am@04m@03lJb/00:800><R8`00j`00m3am@06m@0<lJb8R6Q4J8R<[=3<0]0018R/
R:`2d004c=7ed@;e0_T5m@03nOGi00;e00KimOWimOT4m@03nOGe00?e00CimOGe0]401m2/[<b<[8P0
0fP01HQXR8b800EX00=4J6P02T@01FR/A2AX00940VP00hR/[006[003d?7a00;a00?AlO400oD01=7e
mOD2d@;e00G@lM3<S003R003J4A400AX00>8A6P00hP4[003c8aX00=40R@00d@T900<9003A2@T00<T
00=494@00T@29003A2@T00@T00I4J4A494@29003A2@T008T3d@00bA4A004A00494@T90=40b@2A003
J4@T009412@3A08T24@3J0=400=XA4@00T@00bA4A006A09X14@6J0:800QXR8R8J8R/S0B816P3R003
S:b<00>800><[:`00Z`01Lb/d:c<00J/00?<[:`01:`01<b/S:`5S0:80J`1S00000=4J4@014@00bA4
A009A00394A400Y400<TA4@00d@491I400<TA4@01D@290A40R@2A08T1d@00bA4A003A00394A400<T
24@01FQ4A4AX00>800F<R8R8[002S006R:b<[8b/0XP2S0F/00><[:`00h`3[0:<1j`2S004[8b/[0>8
00=XR8P01FP00hQXJ002J004R8b/d1_e00?imOD00_T5nP?i00?enOD02?D01m7edM3adO402oD00oWe
m@07m@03nOGe00;i00?enOT00_T4m@;i00?enOD00_47[0;<00?@dOD00oD4n@05mM2/R6P00T@290E4
00=XA4@016P01HR<R6R<00J/00?@c=402OD01_7@dO7el@;e00C@S8R<0Z`01Xb8S:cAd0;<1=001?7<
c8`4R003S:c@00C@00B<J8R/0m001?7elO42m@03n_Wi00_e1?T3m@?i2OD02=7@[:c<[8b80VP00dB8
R006R0AX0T@2J006A6Q4A6Q40fP00bA4A002A004R8b<R0F/00C<d=3A0]000o7Am@09m@03lOGe00;A
00C@c8b81fP01HQXJ4AX00:800R<[:c@S:b8J0944R@3A0<T00=494@014@79003A2@T00M40b@6A003
J4A400I400=XA4@05D@390I400<TA4@01D@016Q4A6P9A00394A400=400=XA4@00d@00fQ4A002J003
R6QX009X00N8S6R8S8R/00>81fP3R0:<00=XR8`00Z`02m2/[<b/d:b<R:c<00>/00G<[<b/c003[005
S:b<[8`01Z`001i400LTA4@TA2A400@T0d@390A40R@2A00394A400I400<TA2@00d@00bA49002A0<T
00A494A40b@00d@TA002A00394A400E41R@5A00394A400=40VP6R003S8R800>800><[:`00Z`2S0>/
0h`2[008S:b/R8c<[8`5[003S:b/00:80X`00jb8R002R006S8R8R4AX0XP3J006R6R8c=3a7_D5n@06
n_WinOGi2OD00o7el@03d@03lM7e00Ke00CimOGi1?D00oWem@04m@?i1?D00oWem@03m@03nOGe00;e
00CAd<b/0X`3[003d?7A00Ce0_T01oGimM2<J4@012@<A00:R6R8R8b8S8R<R0>/00?AlOD02?D3l@08
mO7emO6/R8`2d0B/00_<d:b<[8R/S8S<d003[003c:c@00;@1:`018QX[:`2d005c=3Ad?403OD01OWe
nOWe00Ci00GenOGen@02m@03nOGe00?e0]000m6/[002[0>80fP01XQ4R8R<[0B80fP2A003J2@T00I4
0R@01DB8J6R800:<1:`02<c@d=3Ad?7e0_400oGAm@06m@03lOGe00;@00B/S8R81FP01XQXJ6Q4J0:8
0j`01/b<[8QXA0HT0T@;909422@3A00394A400@T0T@290Y400AXA4A40VP4A00394A400A400DTA2A4
9004A08T1D@00bA4A00490940b@9A006J4A4A6Q40VP014@TA2@;A09X14@3J0:80VP5R004S:b8J0:8
1fP00hQXR003R005S:b/d8`00Z`00lb/[002S0>/0m04c0F/0X`00hR<[004[000;4@00bA4A005A08T
0T@00bA4A008A00394A400E40b@5A08T00=494@00d@01BA492A400<T00M492A494@T00M400MXA6Q4
J8QX00B800F<J8R/R002S12/0XP3[003S:c<00J/0XP01Zb8[6R8[0B80VP01Xb8R6R8J0:800>/d=40
3?D00o7em@0:m@06nOGenOGj1?T01_[in_[im@;i2_D01O7@d=3A00Ke00?imOT01OD01_WenOWen@;e
00?imOT01oT01OGimOWj00?e00GadLb<R004[003d?GA00Ge0_T2m@03d:a400940b@:A0AX00A4J8R<
0XP02:b<[<b/d=7i2?D00o7em@05m@04[8b8[0;<00F<d=7@m@02[00=d8R/c:c@lJc@dO7el@02d003
[8b800:80Z`02<c@dM6/d?GA0oD01OWemOGa00?e00CimOGi0_D01OWen_We00;i00?enOD00_D00oWj
m@02m@03d=7a00;@0j`018R<J8P2J003R6QX00:800B/R6R/0hP2J0=40R@01FQ4A6Q4008T00A4J6QX
0h`2[007d:c<d?7ed@02l@05d?7AlOD00_401OGamOGA00;e00C@mM3<0XP5J003A6QX009X00M4R6R8
[8b/00><00AXR4A41B@2A0LT00<092@00d@89003A2A4008T00A492@T4T@3J003A2A400940R@3A003
J4@T00M400<TA4@014@29003A2A4008T0T@2909400DTA4A49002A003J8QX00A400=XR6P014@00fQ4
A002A00394AX00AX0d@00hQ4J002J006R8b8R6R80VP2R09X0XP016R8J4@6J008R8b8S:b8[8P2[003
c8b/00>80j`00lb/[002[003c:b/00:/00B<J8R<1Z`001a40R@EA08T0T@291940R@00d@TA008A006
94A494@T0d@29003A2@T00940R@3A00494A4909400B8A4AX0XP01VR8R8QXR0><00>/c:`00Z`01Hb/
S:b800:<1:`01hR<R8R<[8`00Z`4S004[8b/S0:/00C@S:b80Z`2R003J8R800>800=XR:`00Z`00m3a
l@0<m@;a3_D3n@03n_We00?i00CjnOWi2?D00o7ed@02d@03d=7a00Ge00?imOD01?D01?WemOT4m@04
nOGen@;e00?jnOT00oT01?[in_T5m@;@00><[:`00j`00lcam@06m@06nOGe[8QX0d@01BA4A4AX00E4
00=XA6P016P01HR/[:b800>/00B<c=3a2OD00m7ed@05m@03c8R/00?@00>/c=000_D02=6<[8cadOGa
1oD2d0>/00N8[8b/c=3A00?@00?amO400oD01?WelOD2d0?e0oT2m@;i00CenOGi0_D01_[imOWen@Ce
0m02[006c:b8J8QX18P00fR8R002J0>81D@00bA4A005A00394A4009X00>8[8`00Z`01<b/c=02l@;A
00?@lM400]401OGamOGa00;e00_amM7ad<c@[8R<R008J007A8R8S8R/S003[0>800=XA2@00R@2A0XT
14@4909412@2A0<T0T@00bA4A007A00394A400]40R@00d@T900490=40b@:A00694A4A2A41b@8A0EX
0T@2J003A6Q400I400@TA4A40fP2A09X00=4J6P016P01HQXR6R800EX0hP2A09X00B8J6QX0hP00hb/
R002R0>/00><R8`00X`00hR<[003[004S:b/[0><00>/R8P01:`1c06/0J`002Y400<TA4@00T@29094
00@TA4@T0T@00bA4A008A00394A400A41B@6A00794@TA2A49004A00394A4008T0d@01RA4A2A490E4
0fP00hQXJ002R0><00F8S8b<c004[004S8R8S0:/00><[8P00X`01jb<R:c<[8`01:`00hb8S002S003
[8b<00:800=XR8P00hP00hb8J002J0:800><[:`00]0<m@03lOGe00[e00GimOWim@05n@04mOWin@Se
00?imOD00]401o7edOG@dO403?D2n@05mOWemOT01OD01o[in_WenOD00oT00oGim@02m@03lM6/00>/
00G<[:c@d@06m@07n_WemJb<J004A00494A4J0Q40fP01Xb/[8b/R0>/0]000o7em@07m@04lM3Ad@Ce
00?@[<`00]02[003c=3a00?e00C<[:ca2oD02O7@c8R<[<b/c003d004lM7@l@Oe00?AlM000_D3n@03
mOWi00?i1_D01_WemOGjn@Ce1=03[004R:b<[0>800=XS8P01XP00dB8J002A005J4AXA2@01T@01FR8
J8b/00;<0Z`00lcAl@02d@03d=7A00;a00?edOD00oD2l@06mM7ad:b<0XP7J0>80VP2R0:<0Z`4S003
R6Q400`T00E492A49008A00394@T00HT00E494A49007A0@T1T@2J0A40R@00d@T9002A00394A400<T
2T@29003A2A400<T00=492@00b@5A008J4A4J4B8J4@2J0M400<TA4@00T@01RA494AXA09X00E4J6QX
A002J004A6QXR0=X0XP2J003R6QX00EX00B8J6QX0hP018b8R8P2S004c8R8S0:800=XR8P00XP00hb8
c002[003R:b800:80j`00hb/[002[0008D@00bA4A005A00594A4A2@024@00bA4A005A00394A40094
00<TA4@00R@4A00494@T919400HTA4@TA2@2A005J4A4A2@024@2J0:800><R8`00XP00hb/[004[0:<
0Z`01HR/S8R<00:800J<[8R8[<`5[0:<18P01FR8[4AX00B816P028Q4J6R8S8R/0]0Om@?i00?enOT0
1OD00oWen@05m@?a1=400o7Am@07m@;i0_D00oWem@05m@04nOGem@Ci00?jnOD00_T2m@07nOGemO7<
S003[005c:c<[=001oD00oWed002R005J4@TA2@00d@018Q492@3A0AX00N<[8b/R8aX00>/0/`4m@;i
1?D00m7<d002m@;i00?edL`00/`00m7<c002c008dOGemM6<[=0<m@;@0j`01=2/d=02d@;e00?amOD0
0_D01?WemOD2d003c?7i00;e00?imOT01?T01OGimOGi00Ce00?jnOD00_D00oWed@02d007c:b/[8b/
R002S0=X00>8S:`01HP016R8R6P2A00394AX00Q400IXR8b/c=02[0;@00OelM7@dM3a00;e00CamOGe
0_401m7adOG@[8`00hP6J0>80VP3R006[<b/[8b80VP2A18T1D@49003A2@T00=400<TA4@00T@00bA4
A005A0@T00=4J6P01FP3A0@T0T@01BA4A4@T009400DTA4A49007A00594A4A2@00d@390E400<TA4@0
14@2J09400AXA4A40b@<A003J4AX00AX00B8J4A41FP2R0YX00B8J6QX0XP01Hb8R8R<009X28P2J0:8
00IXS:b8[8`2R003J8b<00:<0j`1S0006d@290A400DTA4A49006A00394A400A40R@014@T92@3A0<T
24@012A4A4@39003A2A4009400<TA2@024@2909400DTA4A49003A003J4A400U40VP2R004S8R8[0:8
1:`00hb/[002[0:800><R8P00X`018R<S:`3S0>/00>8[8`00Z`018b8[8P3S007R8aXR8b8J002R004
S6QXJ0:800B<R:b/0]4Nm@Oi0_D4n@Se00CAlM3A0m02l@;e00CimOGe0_T01_GinOGim@;i0_D01?We
mOD2nP07nO[inOGim@02n@Ge00?@S8P00X`4[003c?Ge00?e00GimOGed003J004A2@T909400=XR4@0
1D@00fQ4J002R0>/00V<[:b<[<cAd?400_D2n@03mOWe00;e00CAd=7A0oD01?WAc=42d005[=2/dO40
0oD01_6/[?7en@;e00?imOD01OD00o7@[003[003c=7@00ce00GAc:b/d@03m@03nOGe00We00CimOGi
1oD01O7@d=3<00:/0X`2R003S8QX00=X00>8S8P00XP01FQ4R8QX00I400=XA2@00R@2A003J8R<00:/
0l`4d005lM7AdOD00_45m@;a00OelO7@c:b<00>81FP2R003S6R800:800><[:`00j`018QXJ6P5A0DT
0T@590E400@TA2A40R@2A00394A4009400<TA4@02T@290A400AXR6QX1T@290M40b@3A0@T00A494A4
0b@3A08T14@39003A2A400940VP2A006J4AXA6Q412@4A00594A4A2@024@2J0M40VP00hQXA002A09X
0d@01XQXR6R8J0B800AXR8R836P3R0><00>/S:`00XP3S003c8b/006/000<A00394A400A400<TA4@0
1D@00bA49005909400<TA4@02T@00bA4A005A08T00=492@01D@00bA4A004A00394@T00=40R@;A003
94A4009400<TA4@024@00fQ4A005A0=X00J<R6R8S8P3S004[8R8S0:/00><R8P018P00hb8R002[003
R8b800B<0XP02Jb<R8R<R8aXS004R0:<00>8[8`00XP01DAXR8b800:/00C<d?Ga1?D00oWen@03m@03
lOGe00;e00?imOD01OD00oWen@02m@;i00Gen_[inP03n@05mOWimOT00_D02O[emOGAmO7@l@02d0;A
00?@mOD00oD2n@06mOWemO[e0_T01OGimOGi00;e00GjnO[jn@02nP05mOWjnOX00oD2d005[8b<R8`0
0Z`00hS@m@02m@04nO[inP;e00?@J8P014@00bA4A002J0Q40VP2R003S:b/00B/00?<d=000]42m@04
nO[en@;e00Cad=7a1OD01m3A[=3<dM000_D01=7emM42[004mOWen@Ce00CimOGe0_402?G@d8c@[=7@
0oD00oWel@05m@03lLb/00:/00G@lOGen@0>m@;i1_D01m3AdM2/S:`00X`6R0=X18P00dAXR004J006
A2A4A6Q40R@01DAXJ6R800>/00?@c=000]003=7@d=3adOGamO7el@;e00GadOGAl@04[006R6R8R6Q4
16P3R008J8R<S:b<c8`3R006J4A4A2A412@01d@TA4@T02@00T@00bA49003909400<TA4@00d@01:a4
A4@2909400<TA4@014@39004A6Q4A0EX0T@00bA4A002909400<TA4@00T@59003A2@T00@T0T@012A4
A2@3A00494A490940b@6A003J4A400940VP2A0<T0d@00bA4A002A08T1T@4J0A40fP01XQXA6Q4J094
00MXA6QXR8aX00F80VP02XQXJ8Q4J4AXA6P2R007J4AXR8b/R002S006[8b8[8aX0X`2[06<0J`001i4
00<TA4@02d@00bA4A00290E400<TA4@00d@290M400@TA4@T24@491=400<TA4@00d@00fQ4A006A003
J4A4009X0hP2S006R:b8R8b/18`018R<S8`2R005S8R<S:`00X`4[0:<00F/S8R/S002R005S8R8R8`0
0XP016R8R8P4J003R8b<00:/00?@dOD02OD00o7em@0@m@?i0_X3n@03n_Wi00_e00?AlM000m000lcA
d@04m@04nOGinP;i0_D01?WemOT2m@04nOGim@?i00KjnO[in_T2nPCe00?ad:`00XP00hb/[002[003
d?Ge00;e00?in_T00_D01:b8R6P4A09X00E4J4A49003A0EX00B8S:c@0Z`00hR<c004d0;e0oT3m@04
lM3Al@?e00CimO7A0]000m7ed@02d006dO7ed:c<0_D00oWen@02m@;i0_D2l@;e00?Ad:`00Z`00lc@
d@0:m@03lM2/00:/00G<dOGen@0Gm@05lM3@d:`00X`2[00:S:b8R6R8J8R<[0>80fP00dAXJ003A003
J8Q400I400F8[:b/c002d0GA00C@dM7a1_D3l@;e00CA[=2/0X`2R0UX0hP018b/S:`2S003J8R800=4
00<TA2@00R@3A0LT0d@891E400<TA4@00T@5J0I400<TA4@01T@00bA4A004A0DT00=494@02D@00bA4
A004A003J4AX009X00=4J4@01D@490M400@TA4A40VP3A0AX00=4J6P00XP4J004R4AXR09X00=4J6P0
0hP018aXJ6P3R003J8QX00F816P2R005J8R8S8P00X`2R003[8R800>800>/S:`00J`001]400HTA4@T
A2@2A00494@TA0<T00=492@00T@00bA4A007A00394A4008T00=494@01d@29006A2A4A2A40b@4A003
94A4009400<TA2@00R@00d@TA003A00494A490Q400<TA4@00T@01FQ4J4AX00N800>/c:`00Z`3S003
R8b<00:800B<[:b80h`5[0B<1:`2R004[8aXJ0:800><R8P00XP2J005R8b<S:`00]000o7em@0Lm@Ki
00?jnOD02oD2l@G@00?adO400oD00oWen@04n@?e0_T4m@;i00?enOT00_X3n@03n_Wi00Ge00K@[8b<
[8`3[004d?7em@?i0oD00jb8R002J0I400=XA4@00d@5J003R8b/00>/00B<[:c<0m000o7em@03n@?e
00?ad=400_D00o7em@03m@04dOGam@?@00KAd?G<[?42m@03n_Ge00Ci1_D00o7@[002[005c=3amOT0
1oD01?WelJ`2R003S:cA00;e00?imOD01?D00o7em@0>m@04lM7@d0>/0h`02HQXJ6R8S:b<[003S004
R4AXJ0A400>8A4@00d@2J0:80j`02<c@d=7adM3A0]001M7amOGa00Ce0_401?GadM02[004S8R8R0=X
0XP00fR8R002J00:S8R/[8R<[8aXS09X00=492@00R@2A1HT0T@490E40R@6A0<T0d@4J0I412@6A003
94A4009400<TA2@00b@2A0DT00=494@014@00bA4A002A005J4A4A6P00d@00fQ4A002A00394A400e4
0VP4A0IX0XP2J0>80VP3R003J8R800=X00J8J8QXR6P2R004S8R8J0B800B<R8R<0hP018b/S8P3S0:8
00N/R8R<[8b/006<000JA00394A400i40R@:A00394A4009400<TA2@00R@;A00794@TA2A49003A003
94@T00=400@TA2@T0d@590=400<TA2@034@3J0:800F<R8R/R003[003S:b<00:<00F/S8b8S002R0:<
0XP00hb8S003S0:/00>8[:`00Z`2R0:<00>/J8P00XP01Hb8J8QX00B80X`2[005d=7emO403OD01?7e
mO48m@05nOGen_D01OT00oGim@02n@;e00?imOD00oD01=7@d<`6d0Ke0_T01?GimOD2n@05n_GenOD0
0oT4nP03nOGj00?i0oD01]7@[8b8[0:800B/S=3A0_D4n@;e00F/R8aXA002J0E400<TA4@01D@00fR8
R007[0C@00SAlOGenO[en@?e00?@lOD01?D00oWem@03m@04lLc@c0;@00C<[<ca0oD01?WemOT8m@;a
0]000lc@d003m@03nOGe00?e00KimOGa[8P2S003[=3e00;e00?imOD00_D2l@03dOGe00We00?imOD0
0oD02o7@[:c<[8b/R6Q400:80X`018R<[:`3R0=400AXA4AX0T@2909400B<[:b<0Z`01=3<d=02d@05
d=7Ad=400_45m@06lOGAmO7@0j`028b8J6Q4J8R<0VP01Hb8J8R<00>/00R8[:b<R8b8J0=400<TA2@0
4B@2A00394A400A400<TA4@01D@29003A2A400A400<TA4@00T@00fR8J00:A00394A400=40b@3A003
94@T00=40b@2A0<T1T@01BA4A4@T00=40VP3A003J4A401=400=XA6P00T@4J004R6QXJ0B800>/J6P0
0VP018R<R8P3J0>800AXR8QX0XP2S003J8R800><00B8S8b/0X`4[007R8b/R8b/J002S003R<b/006/
000MA00394A400E400<TA4@02d@00bA4A002A00394A400E400<TA4@034@290A400<TA2@02D@00bA4
A006A08T00=494@02d@00fR8R002R0><00B/R:b<1:`00hb/S002[003R:b<00>800IXR8R<[8P4S0:8
0X`01:b<R8`3R004S6R8R0AX0hP2S0>/00?@mOD01OD00o7em@03m@04lOGed@ge00Cin_Wi0_D4n@;e
00CimOGi1?D01oWamO7<d=400]02d@Ke01;imOWimO[enO[enO[in_Gin_T3nP07nO[in_Wen@03m@04
d:b<[0:800B<[:b/1OD02?WemOF<J8R/0fP5A00394@T00E40VP5[003d:c@00;<00Ged=7el@02m@03
nO[e00;e00KadOGamO47m@;A00S<[:c@[8b/d0?e00?jmOD00_D00oWem@06m@03lM3@00;@00CAlOGi
1oD01?[emJ`2S003[8b/00;e00?imOD01?D01=7alM48m@03n_Ge00;e00CamO7@1Z`01HQXJ6R800:<
0Z`00hb/R002R0AX1D@39003A6R/00B/00?<[<`01=04d@;a00?elOD00_D01O7AdOG@00>/0X`4J0:8
00B<J6R80VP2R0:/00R<R8b<[8b8J0I41R@2A0<T00=492@012@2A00394A400=400AXA4AX1D@590I4
00AXR6QX0XP00fQ4A00UA003J4A400U40fP3A00394A400U400=XA4@00T@00fQ4J008J0:80VP2R004
[8R<[0F800><J6P00VP2R00:[6R8S6R8J8R/S0B800J/S8R<[8`5[008S:b/[8b/R8`2[0680J`1S000
5D@00bA49005A08T1D@00bA4A004A00394A4009400<TA4@00R@7A08T3D@01BA4A2A400@T00=492@0
2T@290A400@TA2@T0T@290U40VP00dAXR002J0:80Z`00hR/S006[003S:b/00>/00Z<R8b8S:b8[8b8
0X`2R006S:b<[6R80X`01Jb<[8QX00:800=XR8P00hP00jb<S002[003dO7e00ce00?amOD03?D4n@04
mO[in@;j00CenOGi2_D00m7@c002d004dM3ad@Ke00?imOD01OT00o[en@05n@;j00Cin_We0_X00oGi
m@02m@03dM2/00:<00>/S8`00Z`01=3AmOD2n@06mOWed:aX0h`00fQ4A004A00394@T00A400=XR8`0
0h`6[003d?7a00Ge00?imOD00oD01M7emOGa00Oe0_401<b/S8`2[003d?Ge00?e00?imOD00_D2n@Ke
00Cad=7A0_4=m@:/00F<R:b/d004m@;i00?edO400]400o7em@0>m@05lJc<[8`00Z`4J0>800F<[8b8
S002R0AX1T@01BA4A4B800F/0l`01M3Ad=3A00;a1_D01o7AlM3ad<`00j`00haXJ007J0F800><[:`0
0X`01:b<S8P5A08T00=492@04b@4A003J4A400=400=XA4@00d@290I400F8S8b<R002J09400=XA4@0
24@01VQ4A4@TA08T5D@00fQ4A007A003J8Q400940R@<A0IX00=4J8P00fP2R003S6R800:800B<[8b<
18P018b8S8`2R00<S8R8R6R<R6R8J8b/0XP2S0:/00F<[8b/S003R005S:b/[8`00j`01Hb/S:b<00:/
000IA00394A400M400<TA4@00d@00bA4A00;A00794A4A2A49002A00394A400]400DTA4A49004A003
94A400Q400DTA4A49002A08T0T@290U400=XA4@00VP4R003S8R<00:800B<[8c@0j`01Lb<[8b/00:8
00><[8`00X`01XR<S8b/S0B/00B<R:b/0X`2[0>80VP2R004[8R8R0>/00?@dO407oD2n@03n_We00;i
00?enOT02oD00o7Ad002d004lM7al@Ke00KimOGenOX4n@06mOWenO[i0_X01OWjn_Wj00;i1?D01O7A
d:b<00J/00C@mOGi0_X01?Wed8`3R003[6Q400e400B8J8R80Z`00hb/[002[003d?7a00Ge00?imOD0
0oD00m7am@09m@06lM3@[<b/0/`00m7em@03m@;i1?D2n@Oe1?49m@06nOGemJb<0XP00hb/d005m@03
nOGe00Ce00CAlOGa1OD2n@Ke00K@c:b/d<`2R004S8R<R0>/00N8[8b/R6R800e41j`02/b/d=7@dO7A
lM45m@04d=7<c0B/00><J6P00fP00dAXJ002R004S8R8S0:/0X`2[004R:b<R0=412@00d@TA002A14T
00=492@01d@2J0Q400IXA6QXR8`3R0=X1d@00bA4A005A0DT00E4J4A49006A08T1d@00bA49006A004
J4A4J0=400<TA4@02T@2J007A6QXR6Q4J004R005S8R8R8`00hP00hb8[002S0:80X`2R0><00N/S:b8
S:b<00:800>/S8`02J`2S003J8R<00>/00><[8`00X`01Jb<[:b<006/000HA00394A400E40R@01T@T
A2A4909400<TA4@00T@00bA49002A00394A4009400@TA4@T0d@00bA4900:A00394A400I400<TA2@0
0d@01BA494@T00A40R@2A08T00=492@00R@8A005J4B8R6P01HP3S0>81j`2R0:<00>8S:`00X`02XR<
S8b8S:b8S:`2S0B/00B8S:b<0hP016R8R8`3R005S:b/d=400_D00o7em@0;m@03lOGa00ke0_T4m@03
nOGe00?e00?imOT00oD00o7em@02d005[<cAd?402?D01?WemOX2n@07n_GinOGim@02nP03mO[j00?j
0oT5m@;@00>/S:`01J`01=7enOT2nP;e00B/R8QX0XP>A09X0XP02hb/[8R/R:c<d?Ga00Ke00?imOD0
0_D00o7em@09m@09d?7amM7ed=7a00Ce00?imOT01?D00oWem@07m@03dO7A00;a0oD00o7em@02m@05
nOGe[8P00VP018R<[=42n@03mOWe00?e0_T2m@?A00?amOD00_D2n@Ke00?Ad=000m001Zb<R8b/R0:/
18P01:b<J6P5A003J4A400A400=XS:`01:`7d004dO7ad@Ge00O@dLc@S:b<00:80VP014AXR4@2J0B8
00><[:`01:`01Hb/[8b800E400<TA4@03b@5A00394A400=40b@00dAXJ002J0=400=XA4@00T@2J0>8
00><R8`016P4A00394@T00=400@TA4A40R@014@T92@6A0DT2T@290E400=XA4@034@00fQ4A003A0=X
00>8J6P00VP6R0:<0hP00fR8R002S005[8R<R8`018P00jb<R004S003[8R/00:800>/R8`00X`2[0><
00>8[8`01:`2S0B/00B<[:b/0X`001M400DTA4A49004A00494A4A08T14@00bA4A003A08T1T@01RA4
A4@TA0<T0T@290=400<TA4@02d@012A492@4A00394A4009400<TA4@00R@014@TA4@590M40fP01HR<
J8R<00:800=XR8`00hP018b/[:`2S006R:b8S:b81:`4R0:<00>/S:`00j`02hR/S8b/R:b<R:b8009X
00^<[8R8J8R<[<cad@02m@05dOGemOT00oD00m7em@0?m@03nOGe00;e0_T01OGimOGi00;e00CimOGj
1_D02M3ec<c@lM7ed006m@03nOGe00;i0_X02_WjmOGimOWjmOX2n@04n_WenP;e00CimOGe0_400jc<
R002[005S:b<d?400_D02?WjmOWA[6R80fP2A0=X14@00bA4A004A004R8b/S0>80Z`00m3ed@03m@06
nOGenOGi0oD00o7em@03m@03lOGe00Se00G<dO7an@0:m@03nOGe00?e00[amOGedO7@lOGa0_D00m7e
l@05m@03R6QX009X00F8[=3an@0;m@04lM3ed@?e0_T6m@;A1=02[0><18P2S0>800=XA4@02T@2J003
R8b/00>/1=001=7@d=42m@03dOGe00Ce00?Ad=000j`028QXJ8Q4R6Q40fP01Xb8[8b/S0J/0X`00fQ4
A003A00394@T00dT0T@00bA4A003A00394A400=40R@00dAXA00:A0=X0XP018b/S6P5A005J4@TA2@0
2T@490E40b@:A0DT4D@00fQ4J004A0IX0XP2S0:800V/R8b/S:b<R:`00hP2[004R:aXJ0B800J<R:b/
R8`2[0:<00>/S6P00XP00jb<S003S003[8R<00F/00><[:`00Z`01Hb/[<b<00:8000PA00594A4A2@0
0T@01RA4A2A490i40R@2A00394A4009400<TA4@02T@00bA4A006A00394A400E400<TA4@01D@00bA4
A00390I400@TA6QX0hP018b8S8`4R0><0j`2S003R:b/00>/0X`4[003R6R800:<00B/R8b/18`2[003
R:b800:800^/R6QXS8QXR8b8S002[004d?7el@[e0_42d@03mO7e00ge0_T00oGin@04n@?e00KimOWi
mOT2m@03lM3@00;@00?adM400_D00o7em@03m@;i00?enOT00_X01OGimOGj00;e00?jnOX01_T6m@;@
00?<[=001:`01=3emOD3n@04mM2/S0AX1T@00bA49006A004J8R8R0>/0XP01Jc<d?GA00Ke00?imOD0
0_D01O7emOGa00_e00?adM000_D01O7emOGi00ke00?AmM400_401=7amO49m@04S8QXA0>800F/mOWe
n@0:m@;a00GAmOGen@07m@04lM7ad@;<1X`00hR<S004S003R6Q400I400<TA4@00T@2J0:<0Z`00m3<
d006d004dOGel@Ke00?Ad=000j`018QXJ4@7J0:80Z`4S0:80Z`2S0=X14@>909400<TA4@02d@00bA4
A00:A0=X0XP2[006S8R8J4@T14@00bA4A007A0HT00=494@01d@290I40R@:A004J4A4A09X1T@3J0A4
00EXR6R8J003R005S8R<S:`018P01Zb<R8b8S0B800=XR8P00XP3S009R:b<S:b<R:b<00:/00><[8`0
3:`02Hb/R:c<[8b/S003[06<000JA003J4A400A400<TA4@00T@00bA49003A08T14@00bA4A003A004
94A490m400@TA4A40R@3A00494@T90Q400<TA4@00b@3A00394@T00A400<TA4@01d@3R004S6R<R0:<
0XP00hb/R002S004[8b<R0B/00><[:`00j`01Hb8R8R<00>/0h`5[003S:b800:800B<R8R80X`00jb<
[002R004[<c@d@ge1?4Am@Ci0oD6n@Ke00?ad=000m001=7amO47m@;i00?jnOX02?T3nP04nO[jnP;i
1?D2d@03d:c<00:/00B<[:cA0_D2n@05n_GAd:`00VP2A005R4A4A2@00T@290E416P00hR<[005[0;@
0_4:m@;a4OD00o7em@04m@03nOGe00[e00GAlM3ad002d@;a00GelOGel@03m@08nOGeR6R8J8P2J003
S=3e00Ke00?imOD00oD00oWem@0>m@03dLb/00B/0hP2S003R8b800:800=XA4@022@3A09X0Z`01Lb/
d=3<00?@00GAd?7ed@02m@06lOGemM7@1J`00haXR003J0=400EXR8b<[002S003R8b/00:<00F/S8R8
J003A00394@T014T1D@590=400DTA4A4J007A09X1XP018b8R6P6A00394A400E400=XA2@00b@014@T
A2@7A00394A4009400=XA4@00b@5A00394A400AX0d@00fQ4A005A09X0d@00fR8R002R004J8R8S0:8
00R<R8R8J4B8[0>80j`00hb8R004S004R:b8R0:<00J8S:b<R8`4[004R8b/S0^/00><[:`00j`01Hb/
[8b/006<000QA00694@T94@T0T@00bA4A004A00394A400E400<TA4@014@00bA4A00?A00394A40094
0b@00d@T9005A00494A4A08T14@490940R@5A0MX00B8J8R<0XP01Hb/R8b800B/00F<[8b/S005[006
R:b/S=3<1J`01=2/S6P2[0><0hP01hb8R:b8S:`00hP00lc@d00:m@07lOGelOGAl@02m@03lOGe00Ke
00CimOGi0_D2n@03n_Ge00;e00GimOGen@08m@C@00GAlM3el@04m@Ci0oX2n@04mOWim@?i00?jnOT0
1OT5m@06lOG@c:c<0Z`01<cAdOD2n@07n_WadM2/R003J005S6Q4A6P00d@00bA49003A09X00B8J8R/
0/`01m3<[:c@lM402?D01OWemOGa00Oe00?amOD05_D00o7em@02l@?@00SAd?7@dO7Al@Se00?@R6P0
0VP2A003J8R/00ke00?imOD03OD00o7@[005[0><0XP00jc@[002R09X1d@01BA4J4B<00B/00O@c=2/
d<c@00;A00?amOD01_D01=7@[<`3[003R6R800MX0X`00jb8S003S0:/00B<R8b<0XP2J003A2@T00<T
0d@79003A2@T008T0d@590Q40VP5A004J4AXJ0>800><R8P00XP01FQ4A4AX009400<TA4@01d@012A4
94@291=41B@2A00694A4A8QX2D@00hQXA003A009J4AXR6R8J8R<00>800>/R:`00hP026R8R8R/R8b8
0Z`00hQXR003R005[8b8R8`00XP02hb/S:b<[8R/R:b<00B/00>8S:`01:`02HS<c:b<d<b<[002J0:8
0H`0025400<TA4@00d@290=40R@00d@TA006A00594A4A6P01D@00bA4A00CA08T34@01BA492A400@T
00E494A49005A0:800N<J8R8J8QX00:<0hP018b/[8P3[0B<00>/S8`00Z`00hb8S002[004S:c<c0J/
0X`01:b<[:`3R0:/0XP016R8[8P4S004c=7el@We00OamOGadO7A00ce00?imOT00oT2m@03nOGi00;i
2_D02?7Ad=3Ad?7A1OD00oWjnP02n@05n_Win_D00oT2m@;j00?in_T01?T00o[im@05m@;@0/`2[005
d=7emOT00_X01?GAd=02[004R:c@[0M400<TA2@00d@3R003S:b/00:/00G<[:b/d003lBCe00?imOD0
1OD01?7AlM44d006lM7adO7A0_401OGalM7a00?e00CaR6QX0d@2J003[?7e00ce00?imOD02oD00oWe
l@02d0;<00>/c8P01HP2[003S8R800=X0d@016Q4A4@2J003R:b/00:<0j`7d003lM7e00Ke0]000lb/
[002[005J8R8J4@00VP4R0J/00><R:`00X`3R0=X0T@49003A2A4008T00=492@00b@01d@T92A494@0
0b@4A003J4A4009400=XA4@00d@01FQ4A4AX00:800><R8P00XP00fR8R002J004A6QXJ09400EXA4A4
9003A00494A4A0<T1d@00bA4A009A0@T1d@3J09400=XA4@00T@00fQ4A004A003R6R8009X00F8S:b/
S002[006R8b/J8QX18P018b8S:`7R0:<00>/S8`00hP01jb<S8b/S:`00X`2[003S:b/00><1:`018R<
[8P3[004R8b/[0><00000dAXA00EA003J4A400E400<TA4@00T@00bA4A003A08T14@00bA4A009A08T
0T@2915400<TA4@03T@00bA4A002A00394@T008T0d@00bA4A002A0=X0hP01JaXR6R<00>800IXR8b/
S:`4R005S8R<[6P00XP018b/[:`2S0B/00><R:`00X`00jb<[003[0:<00B8S8b/0XP018b/R8P3[0;@
1_D01_WemOGam@Ca0]43m@03lOGe00Ce00?imOD01?T6m@?i00?enOD01OD01O7ed=3<00;@00CadOGa
0oD00o[inP05nP03nO[i00;i00GenO[inP05n@04mO[jn@Ge00SAd=3@[<cAl@;e00Cin_[e0]001:b8
R8P3[0=X14@00bA4A003A0:800=XR:`00j`00m2/R002[003lM7e00Ge00?imOD03OD00o7el@0<m@03
nOGe00Ge00CAd?7A0/`00m2/l@02d@;@00GAlM7ad@03l@07mOWemHQ4J005A003S?GA00Ke00?imOT0
0_D00oWem@02m@03nOGe00Oe00?imOD00_42d006c:b8R:aX0hP01Jb<R8a4009X00=4J6P014@2J00:
S<b8[8b8[8c@c0?@00GAd?Gel@05m@08d?G@c=2/c8`2R09X00U4J4AXR6R8[8`01:`2S005R8b8[8P0
0VP4A0DT00=492@00R@00d@T9002A0@T00A492A40R@7A003J4A400A40fP2A09X0hP00hb8R003R004
J4A4J0A400=XA4@00T@012AXA4@690940R@00d@T9002909400<TA4@01D@290M400<TA6P014@00fQ4
A008A0EX0hP00hb8S002S003R8b800=X0hP4S0F800><R:`00X`00hR<S003S004[8R8R0>/00><R:`0
0X`4[006S:b/[<b<1Z`00fR/[003[06<000ZA00394@T00E400<TA2@00R@00d@TA004A08T0T@00bA4
A007A00494@TA08T0d@01bA4A4@TA2@01d@290I41B@00d@T9005A0=X0XP01Zb<R6R8S0:800IXR8b8
[8`2R0:<00F/R8R8[003S004[8b/S0B/0XP2[0:<00>/S:`00j`3S005R8b/[8`01HP018b/[=4=m@;a
00?@dO400_D2l@We1?T3m@04nOGim@;i2_D2l@04d=7@l@Ke00?imOX00_T01?[in_X8n@;e0oT01?[i
n_X6m@06lM7@d:c@0_400oGinP02n@04mM3@[0:<00B8[:b<0VP7A00894A4A8QXR6P9[003dOGe00Ge
00?imOD08oD01?7AdO43d00=lM3Ad?7AlM7adOGAm@02l@;e00?ilHP01d@00hS@l@0Dm@04nOGen@;e
00?imOD00_401]3<[=28S0:800B/R8b80Z`018b8R8P2J004A6Q4J09400AXR8b<0j`02M2/c:c<d=7@
d@03m@03lOGe00?e0_401M7<d:b<00:816P014B8J8`2R0N/00><[8`00XP3J0=40R@00d@T90099005
A2@TA2@00T@012A4A2@2A08T1D@016Q4A6P2A09X00=4J6P00XP2S0:/18P016Q4A6P9A00394A400DT
00=494@00R@3A00394@T00<T1T@29003A2A400e400=XA4@014@00fQ4J003J003A8R800:<1HP00hb8
J007R0:<0Z`4R003S:b/00:<00J8S8R/S8P2S003R8b<00>/00F<[8b<[003S0:/0XP00hb8[007[003
R8b<00:/000IA00394@T00i400<TA2@00d@00bA4A004A08T2d@012A4A2@7A08T14@00bA49002A005
94A4A2@00T@00bA4A003A0<T00=492@012@00d@TA004A09X0hP00jb8R003R008J8b8S8R<R8`2R006
S:b/R:b80j`018b/S8`3[004R:b8S0:/00><c:`01:`01lb/[8b/S8P00Z`02HR/R8b/R8b8c002l@03
mO7e00Ke0_42m@03d?7A00;e00?amOD01_D01?WemOT3m@Ci00?jnOT00_T00oGin@07m@04dM3Ad0Oe
1_T00oGjnP05nP?i00?enOT00oX00oWjn@06m@06lM7@d:c@0_401?Gjn_X2m@;@00B/S:b<0Z`01XQX
J6Q4J0Q40fP4R003S:c@00:/00?@dOD01oD00oWem@05m@04nOGen@_e00GamOGen@02m@03nOGe00Ce
0_402M3adM7@lM3ad@02l@07dM3ad?7Al@06m@03R6Q400E400>8c=000oD01_WenOWen@Oe00GimOGe
n@02m@Ci0_D00o7ed002d005[8R8R6P00XP01Hb8S8R<00:800=XA6P01d@2J004R:b/c0>/1M001=7a
mO46m@04lM7@d0:/00B<R8R/1FP018R<S8P3S007[<b/[8b/S002R003J8QX00A400<TA4@01b@00dAX
900290Q40R@00d@T9005A003J4A400I40VP2R005S:b8[8`00hP2J0e40b@6A08T1T@490A40b@6A003
94A400Q40VP4A003J4AX00AX00J8S8R8S:`:R00:S8R/[8b/S8R<R0:<00B/S8b80X`00hR<S003S003
R:b/00:/0h`00hR<S002S003R8b/00:80Z`00hb/S003[005S8R8[8`00Z`0021400<TA2@01d@00bA4
A002A08T00=494@00T@00bA4A006A00394A4009400@TA4@T14@01RA492A490A40b@4A00394A400=4
00<TA2@00R@4A0DT1d@01FR8R8b800><1HP2S003R8b800:/00><[:`00X`00jb<[002[0:<0j`01Hb/
[:b<00B/00><[:`01J`00hb8S002R006[8b8[8QX0X`3[003lOGa00[e0_401=3adOD2l@03dO7e00_e
00?in_T01oT9m@;a0m44l@?e1?T9nPOi0oX2n@Se00CamM7<0]401?Gin_X3m@03dM2/00J/0fP5A09X
0d@01VR8R8R/R0J/00?@lO402?D00oWem@0Sm@04lOGal@;A0o402_GadM3ad?7@mO45m@03S6Q400E4
00EX[=3Am@02n@04mOWinP;i0oD00oWem@03m@;i00?enOD01_D00o7@d002[003S8R800:800=XR8P0
0hP6J0A40XP2J004S:b/c0:/1]000m7el@07m@04lM7@d0:/00F8[8R<J002R09X00B8S8QX2:`01Xb8
[8QXR09X0T@39003A2@T00DT00=XA2@00R@014@TA2@3A08T0d@290I400AXA4AX0T@016R8R8P2[003
c8b<00:<00>8J6P02T@012A4A4@2909400<TA4@01d@00bA4A00690A400<TA4@014@012A4A6P<A09X
00E4J6QXR002J009R8b8S8R<R8b800:<0hP00hb8R003[0:800>/S:`00X`01Jb<S8R<00>/0X`00jb<
[002[0:80Z`6S003R8b<00F/00J<R8b<[8`2R0:/0HP1S000:T@00bA49006A00394A400I400<TA2@0
24@290=40R@8A0<T00E494A49004A00394A400<T14@00bA490029003A2A400A416P01XR<S:b<J0>8
00F<R:b<R002[003R8b<00:<00>/R:`00Z`01hb8[:b<[8P00Z`00hc@[007[003c:b/00:/0XP01hb/
R8b8S8P00h`01Zc<dM7el@We0_401=3ad?D2d@03lOGa00Se00GimOGjn@04nP;i00?jnOD00oD02OWe
mOGAmO7@l@02d004lM7Al@?e00?in_X02?X00oWjm@05n@03mOWi00?i2?D2d@04c=7em@;j00?imOD0
0_D01M2/[:b800:/00><J4@02T@3J003[8R/00:/00?<[:`00Z`00m3Ad@09m@03nOGe02?e00KamO7A
lM43l@07dO7@dOGAd002d@Ge00B/R6Q40VP2A007J8b/d?Gim@03n@03n_Wi00;e00CimOWi1?D4n@Oe
00G@dLc<[003S004J8R<J0B800=XA4@01T@01XR<J8R<[0;<0m001M7@lO7@00;e00?amO401OD01=3A
d8`4[003S6QX00J800F<R:b/d002[003S:b/00:/00B8S8QX0XP8A0DT00E494A4J00490e400=XA4@0
0T@00bA4J002J004R:b8S0:/00R<[8b<R6Q4J0A40R@3A00394@T00E400@TA2@T1d@012A494@490i4
00=XA4@01D@00bA4A002A09X00>8J6P00X`2R005J8b8S:`028P00jb<S002[0R<00F/S8b<[002S0:/
00>8S:`01:`01hb8[:b<R8`00hP4S0B/00?<[8P00Z`01Hb/S8b800:/000AA00394A401Q400TTA4A4
94@TA2@00d@01BA4A4@T00M400DTA4A49003A00394@T00M400@TA2@T0T@00bA4A007A00394A400A4
00<TA2@01D@016Q4A4@3J004R8b<[0J81J`2R004[8b/S0:/00?@[:`00j`3S0>/00>8[:`018`9[005
R8b/S8P00Z`018b8S8`2[003lM7e00[e00?amO400o401M3AlOGa00We0oT5nP?i2_D3l@06dM3AdO7A
1?D00oWjnP09nPKi0_D2nP;i1oD01o7elM7@lOD00_T00o[em@02m@05lM3<[8`00Z`00hb/R002A09X
00=4J4@01D@2J007S8R<S8S<S003[003d?Ge00Oe00?imOD01OD00oWem@0Lm@03lOGa00;a00CedO7A
0o401m7adM7@dM001OD01jaXJ6R8J4@00VP018b/d?43m@;i00?en_D00oD00oWem@04m@;i2OD01=3A
d:`2S0:/0X`01HQXJ8R<00>800=XA4@00d@016R8J8P4[0?@00CadOG@0]400o7em@06m@;A0m002:c<
[8b8J8QX1HP01:b8[:`2d0;<0Z`00lb/[002R09X00>8J4@00T@39003A2@T00LT0T@390e400=XA4@0
14@00fR8J004R004S:b<[0:81FP3A0<T0T@39003A2A400A40R@6A08T00I494@TA2@2A0<T0T@390E4
00=XA4@02d@4J006R8b8R:b<28P00hb8R002[003S:b<00>/0X`02hR<[:b8[8R<R:b800:<00F8[:b/
c002S004[8b/S0:80X`00hR/S003R0:<0Z`2S0:/00J<[8b8S:`1S000;D@012A492@6A00594A4A2@0
3d@00bA4A006A00594A4A2@024@290E400<TA4@01D@00bA49007A005J8R/S:`00VP4R0:/00B<[8R/
0X`2R004S:b/S0>/00B<[:b/0X`2[004S8R/c0f/0XP01FR<R8R<00:80X`2[003d?7a00[e00?AlM00
0]001M7@lM3a00Ge00?imOD00_D3n@Cj0oT=m@?a00CAd?GA1?D2n@[j00Cin_We0_X5n@03mOWe00Ge
00GAmO7Ad002m@03n_Wj00Ce0_401<b/[8`2[003R6QX009400=XA4@00T@01RA4A4AXA0=X00>8S8`0
0j`2c0;a2?D00oWem@05m@03nOGe01ge00?amM400o401=7ad?43d004c:c@d0Ge00G<J6R<R004A004
J8R<d@;e1?T01OGimOGi00Ce00CimOGi2OD2l@05d:b/S8P018`018Q4J6P2R003J8QX00A416P018R/
S<`2[003d<cA00;A0_400m3am@0:m@;@0j`3R09X1hP2S003[=3@00F/00B8S8R<0fP3A0<T00=492@0
1R@3A00394@T00Q400<TA4@01T@02FQ4A6R8J8R/S003[003S:b800B800=XA4@00d@290940R@3A003
94@T00=400<TA4@01T@79003A2@T00<T0T@491540VP2R004[8R8S0:800><R8P00XP2S0B800>/S8`0
0j`01hb/[8b/S8P01:`018R<R8P2S0:/00?<[8P00Z`01Hb/R8R<00:/0h`02HR<R8R<R8b8[002S003
[8b/00:<0Z`002]400DTA4A4900<A00394A400a400<TA4@01D@00bA4A007A00394A400]400DTA2@T
A00290U400B8S:b/0XP018b8S8P4S009R:b8S:b<R8b800>/0XP2S0>/00><[:`01J`00lb/[003[0:<
0Z`018b8R8P2[00>S:b<S8R/R8c@dOGamOT4m@05nOGemM400]000lcAd@02d@03lM7a00Ce00?imOD0
0oT01?[in_X5n@ce00CAlM7a0]42l@?e0oT8nP03nO[i00Ci00?jnOT00oT7m@08dO7@d=7enOD2n@Ge
0]400m2/[002S003R6QX00AX1d@3J005R8b8[<`00]000jc<d009m@?i1?D2nB3e0_401m7alOGAlM00
0]401=3<d:`2d003lOGe00;e00G@R8R<J005A003J8S@00;e0oT2m@03nOGe00Oe00?imOD02OD00o7A
[002R004J8b<S0:80fP00hb8J002J0A41FP00hb/[002[00:d:c@lM3AlM7el@[e00SAd=2/S8QXR0=X
00N/R8R8[8R<00:/00G<d<b/c002[0:800B<R8QX14@990I412@<A003J4A400=400UXR8QXS8R<[=00
1:`2S003R6QX009X0T@00fQ4A002A00894A4J4@TA2@4A005J4A4A6P00d@290940R@4A0@T00=492@0
3D@2J004A2A4A0=X00>8S8P00XP2S004J8R8J0>800>/R8P00X`01:b<[8`3[0:<0Z`2S0B800R<R8b<
[8b/S0B/0h`01HR<S8R<00B80X`01:b<R8P4[005S:b/R8`00J`000U400<TA4@044@390a40R@3A003
94A400A400<TA4@04D@00bA4A003A0<T0T@012A492@3A003J4A400E400<TA4@014@39004A2A490Q4
00F8S:b/J002R008S:b/S:b<[8P2S005[8b<S8P00Z`3S0:/00N8[8b/S:b<00B/0/`5[003S:b<00:/
00F8S6R8[002S0:80X`00hR/c002l@;e00?in_D01_D00o7@d002d0;A00C@lO7a0oD01OWemOWe00?i
00CjnOWj0oT=m@05lM7AlM000]44m@?i2OX01oWjn_WjnOX00_T2nP03nOGi00Ge00GadM7@d@02m@03
n_Wi00Ce0]400m2/[002[004J:aXR0=X0T@00bA4A003A00:J8R8S:b<[<c@d@:/00?@mO401oD4n@?e
00?imOD07oD02]7emOGadM3ac=42d003c=3<00;@1OD00o68R002J0E40VP01JcemOGi00;e00CimOWi
0oD00oWjn@04m@03nOGe00Ke00Gad=2/S002R006J8b/S8QX0XP6J003A6R800=X00F8[:b/d002c0?@
00GedO7ed@08m@05lOGad?D00/`00hb8R002R006J8R8S8QX0XP2[004d:b/c0>/18P016Q4A6P2A0XT
00=494@022@2A00394A400M400DTA4@TA003J00AR:b/[=2/dJc<[8b8J8QXR6P00d@00bA4A002A08T
00=492@02T@016Q4A4@290940R@4A08T0T@390M400=XA4@02T@00fR8R002R003S:b<00:800IXR8R8
J:`2S0F81Z`018b/[8P2S004R8b8R0F<0Z`01hb8S8b/S:`00XP01hb/S:b8S:`00h`01jb<S8b/c8`0
0Z`00lb/[001[0003T@00bA4A002A00394A400a400<TA4@034@00bA4A00AA00394A400A40b@2A08T
14@00bA4900;A00394A400U40R@7A006J8R8S8QX0hP3S0>/0XP2S00:R8b<R:b<[8b/S0J/00V<[:b/
d<b/c:`00X`018R/[8`3[0:<0VP6R005S8R/d=400oD2nPSe00?Ad=001=000o7Am@04m@Ci0_D3n@04
n_Wjn@ke00CadM7a0]45m@Ci1oX01?WjnOX2n@?j00?in_T00oT7m@;A0oD3n@Ce00OadM3@[8b/00>8
00=XA6P024@2J003R8b<00:800N<[<c<d<c@00We0oT4m@;i7OD01?7emO45m@;A00?@lM401]000o7e
m@03m@04[6QXJ0I400=XR=401_D01?WenOT2m@05nOGemOT02oD01?7@d:`4R003S:b8009X0XP02Hb8
R8b8J8QXR002J0:80X`2d007[=3@d?7@d@02l@;e00?amOD01_D01o7@d=2/S8P01FP3R003J8R/00:/
00?<[:`01J`00fR<S002R09400=XA2@02b@014@TA2@3A0<T14@01RA4A2A490E400IXA6QXR8`2[003
c:b/00B/00F<R8R8J005A00394A4009400<TA2@03T@012A494@290E41b@2A004J4A4A09X2D@016Q4
A4@3R004J8R8S0>80VP00hQXR003R004S6R<S0>/0h`2[004S8R/[0:800B<R:b<0Z`02hb/R8b/R:b<
[8b800:<0j`01XR<S8b/R0:<00>/R:`00X`01Jb<[8R/006<000PA00394A400]40R@3A08T1T@00bA4
A009A00794A494@TA0049003A2A400=400<TA4@07d@3J003[8R800><0XP3S004[8R8R0:<00B/S8b<
2:`00hb/S003[0;@1<`018b/S:`3S0F/0XP01Hb8[8QX00:800><d=003?D3d@03d=7A00;A00CadO7a
0oD2n@06mO[imOWe1?T?m@05lM7@dO400]000o7em@02m@;i1OX01OWjnOWj00Ci00?jnOT01_T5m@04
d?GAd@;e00?imOT00_D02_WemOGAlM2/c:`2R0MX0d@00bA4A002J003R8b/00B<1:`00m3em@05m@Gi
0oD2nAke00?AmO400oD02=7edO7elM7e0]001Jc<d=7a00Ce00B/R6QX0T@012A4A4@2J009[=3emOWe
nOGi00;e0_T01OGimOGi00Ce00?imOD01?D01=7@d<`4R003[8QX00=X0XP00fR8S002R004J8R8J0>8
0X`01m3<[:c@dM001O48m@07lOGAd=7@c002[0:800AXR8R80Z`018R/[=03c003d<b/00:/00B<R8b<
0fP01DAXA2A400dT0T@29006A2@T94AX2d@3J0:81:`2c0;@1J`2R004J4A4A09X0T@00bA4900=A003
94A4009400<TA4@024@69003A2A400940VP4A00394A400E400YXA6QXA6R<R8b80VP2R006S8R<R6R<
0hP4S0:/00R<R8b8S:b8S0B800>/R:`00X`01Jb8R8b800:/00F8J8b<R002S003[8b/00:/00><[8`0
0j`00lb/[003[07<0J`001Y400@TA4@T0d@01BA4A4@T009400<TA4@03D@00bA4A00;A00594A494@0
0R@2A00594A4A2@01D@012A4A2@DA08T2D@2J003[8R800>800>/S:`018P00jb<R002[003S:b/00>/
00B8[8b<0Z`00hb/[002[004c:c<c0:/00B<[:b<0Z`00lb/S003[003R8b/00:/00=XR8P00Z`00m3A
m@0;m@07lOGAdM3Ad002l@06dO7emOWe0_T01OGinOGi00;e00CimOWi3_D2l@04dM3ad@Ke00?in_T0
1?X2n@06n_Wjn_Wj0_T01_[in_Wen@Ke00SamO7amOWenPSe00?adJ`00j`00hb8R004J004R4A49094
00=XR6P00hP2[003R8b<00:/00C<d<cA1OD2n@03n_We00?e00?imOD06?D00oWem@04m@03lOGe00;e
0_401?GAmO42d@05d<c@d?401OD00m2/J008A003J:c@01;e00?imOD01OD01?7Ad<`2[0>800><R8P0
0fP00hQXR005R003J8QX00=X00F8S:b8c004d004lM7@l@We0o42d@03d<b<00:<1HP01Hb/[:c<00?@
00C<d=3@0Z`01haXR8QXA8P00d@29003A2@T00@T00=492@012@EA006J8R8S:c<0j`01LcAc<c@00:/
0X`00fQ4A004A08T0d@00bA4A002A00394A4009400DTA4A4J004A00394A400M412@2A0<T0T@01FQ4
A4AX00E400=XA4@01fP2R0EX0XP00jb<R003R0><00F/S8R<R002S0:800EXR8R8J007R003S8R800:<
00>8[8`00XP2[003S:b/00:81X`2[004S<b/S0>/0H`1[0006D@00bA4A00PA00594A4A2@01d@00bA4
A002A08T00=492@00T@00bA4A0029003A2A400m400HTA2@TA2@<A006J8R8R:b818`2R0:<0Z`2S0:8
00F<[8b<[002S004[8c<d0:/00N<[:c@[=3<00J/0X`2[003S:b<00:<0Z`3R003[8b/00:/00?@mOD0
3?D4d005c=3alM401?D2n@Ce00?imOD00_D2n@03mOWe00Se00OamOGAlM7@00;A1oD2n@Cj00Cin_[i
0_X01?WjnOX4n@oe0_T5m@04lOGad@F/1FP7A00<J8QXR:b<R6R<R6R81:`00m3am@03m@;i00?jmOD0
0oD3nAke0_43m@;a1OD01m7ed=3ed=400_43m@04dJaXJ0Q400B8[?7a0oD01OWemOWe00;i3oD01M7@
[8R/00B80h`4R004J8R8R09X00=4J6P00VP2R009S:b/c?7@dO7A00?a2?D00o7ed@02l@;@0Z`2R003
S8R800:800><[<`00]000lc@d002d003[=2/00;@0XP016Q4A6P5A14T1D@00bA4A003A08T0d@3J003
R8b/00>/00><d=000m001lc@[:b<R6P02T@00bA4A00:A08T00=494@02d@59004A2@T90940VP5A005
J8QXR6P00d@00fQ4J009J0J800EXR8R/R004[003S8R/00:<00B8J8R80VP7R006[8R8R:b<1HP01Xb8
R6R8[0:800><R8`00j`3S0:/0X`1[000;d@2911400<TA4@00T@00bA4A004A0@T0d@012A492@EA004
94A490a400AXR8R80Z`01Xb8[8b8[0><00F/S:b<R002[006c8b/[=2/0X`01Lb/[:c<00:/00><[:`0
1J`00hb/[003[007S:b8R:b<R002S009[8b/[<celOGA00Ce00?imOD00oD01_7@d=7@c0;A0]06m@05
nOGenOD00_T00oGin@03n@Se00CamOGA0]001=7edM42l@?e00CimOWi0oX00oWjnP02nP05nO[jnOX0
1_T=m@03n_Gi00;e00SimOGedOG@[0:<00>/R6P00fP4A004J4A4A0AX00F8S4A4R003J005S:b/[=00
0_D01_7emOWjn@?e00CimOGj1?D00oWem@0>m@03nOGe00;e00GimOGel@05m@03dOGe00?e00CamM7a
0]001O7edOWe00;i00?@R8P00fP6A003J:c@00?e00CjmOGi1?D00o[em@08m@06nOGemM3A0Z`018b8
R6P3R006S8QXR4AX0XP018aXA6P2A003J8QX00:<0Z`2d004dOGAm@;a00?edOD01_D2d0?A00Kec:c<
R8`2R008J8aXS:cAd<`2d004dO7@d0?<00O@S8R8J4AX00A400=X92@012@00d@T900690I40R@5A003
94A400=40VP018R/S<`2[003S<b/00;@0/`2[0:<00>8J4@00T@00bA4A003A00494A4909400DTA4A4
9003A00394@T008T34@49003A2@T00A400=XA4@014@2J003S4AX00=41FP014AXJ8P2J009R8b<S:b8
J8QX00>81:`7S0F80X`2R005[8b8R8`00Z`02HR/R8R<R8b8J003S005R:b8S8P00j`01Hb8R:b800:/
000JA00394A400]40b@3A00394A400i400LTA4A494@T00I400DTA2A49003A08T0T@00bA4A00:A003
94A4009400<TA2@00R@=A09X00B<R6R<0Z`018b8R8P2S004[6R8R0><0Z`2S004[8b/[0:<1J`2c003
S:b/00>/00>8[:`01:`00hc<S002R0:/0hP01Zb8[:c@l@;e00?amOD01oD2l@C@00G<d=3@l@0:m@03
nOGe00;e0oT<m@03lM7a00;a00?@dO401OD2n@Sj0_T00o[inP04n@oe0_T00o[im@06m@04lM2/S0>/
00=XA4@02T@3J003R8a4009400F8J8R/R002[003d=7e00?e00?imOX00_D00oWem@03nQ?e00?imOT0
5?D01]7edM3ad0?a00KenOWed:`2J0=400<TA4@00T@00hc@l@03m@04nOGenA;e00CAd<b/0X`02Zb8
[8R/d8R/S8P2J006R6QXJ4AX18P3S008[<c@d=7adOD2l@Se1=401O7@c:b<00>80VP3R003S=3@00;<
00O@dM3@c=2/00><0XP3J0E41R@00d@T900290A400<TA4@014@390940R@3A003J4AX009X1:`01<b/
[:`2d004c:c<S0>800=XA4@01D@29003A2@T00940R@3A00394A400A40b@2A08T1T@490m400=XA6P0
1T@2J003A6QX00=X0T@01FR8R8R<00F800B<R8b/18`3R0><18P00hb/R006R003J8b800>800><R8`0
0hP01:b<R8`2[0F<00F8S8b<[001S0006d@00bA49004A00394A400m400<TA4@024@00bA49008A003
94@T00E412@4A00394A400a400@TA4A41b@5A00394A4009X00F8J6R<[002S0:800><[8`00X`00hR<
S002[003S<b/00><0j`00hb/[004[003c8b/00:/0X`3[0><1:`2S0:/00EXR8R<R002[003d=7A00_e
00?@dM000]001jc@d=3ad?401OD00oWem@05m@03nOGi00;i2_D3l@05d=7ad?D00_401_GamOGinP?i
00?jnOX00oX00oWjnP03n@05mOWimOT03?D00oWjn@02n@03mOWe00Ce00C@[:b<0Z`00fQ4A004A0@T
0d@016R8A6P3A09X00><[<`00Z`01<c@mO45m@?i0_D00oWjnP03m@03nOGe00We00?amOD05oD01?7e
lO42d@03lM7A00;e00Oin_Gac8QX00940R@4A003R:ca01[e00?@[<`00Z`2S003[8R<00><0Z`02FR8
R6Q4J4AXS003R003S:c<00C@00?adOD00o49m@06lM3AdLc@0Z`2R003S8R800>800><d=400]000m7a
d002d003c:b<00B80fP00dAXA002A0HT00=492@00R@4A08T1d@290I40VP2R006[=3<c:c<0Z`01hR/
[:b<c:`00hP00dAXA005A08T1D@00bA4A00?A00394A400M400<TA4@02D@01HQXJ4AX00A40VP2A003
J4AX009X00B8J4A40fP01XR/R8R<[0><0Z`018R<S8P2S0>800>/R:`00hP00jb<R005R006S8R8R8b8
0X`2[003R8b<00><00F8S8b8S002R0><00>/R:`00H`0019400<TA4@01d@01BA494@T009400<TA4@0
0T@00bA4A00EA00394A400=400<TA4@00T@290940R@:A08T3D@012A4A2@3A08T24@2J0:80VP00jb8
S002[0B800>/S:`00X`00jb<[002S003R8b800>/00><[:`00Z`00hb/[004[003S:b/00F/00?<R8P0
0hP2[0:800=XS8`00j`00m3Am@09m@03lM7A00;@0Z`01Lc@d?7@00;a2_D3nA3e00Gad=7Al@07m@03
nO[i00;i1OX6n@;e1OT:m@03nO[j00?i1oD00m2/[003[003S6Q400I400<TA4@014@01XQXA6Q4R09X
00>8[8`00Z`00lc@d006m@04nOGim@;j0_T2m@03nOGe00Ce00?amOD06oD01M3amM7e00?a00CedOGe
0_T2m@03d8QX00Q400AXS=7a1?D01_WemOWen@;e0_T:m@04lM7<[0:<00V/R8R8S:b<R8`018P6J008
S8R8[8c<d:`2d007mM7edO7el@08m@03dM3@00;@0j`00hR/[003R004S8R/c0;@0]401_7AdM7@[0:<
00B8J8R80fP3A00394@T00HT00=4J4@01b@>A0=X00F<[=3@d@02d004c=2/d0>/00G<[8R8J009A003
94@T00E400@TA4@T34@2909412@:A003J4A400U400AXA6QX0d@2J003A6QX00EX1XP03Xb8S8b/S8R<
R8b/R8b80Z`4R003[8R800R800B<R8R/0h`018R<R6P3R006S8R<S8R/0XP2[06<0J`1[000@4@00bA4
A003A00694A4A2A40R@014@T92@3A00394A400=40R@00d@TA008A004J4A4A0HT2D@5J004R:b8R0B/
00B8[8R80Z`00hb/S002S0>800B<[8R<1J`00hb/c003[003c:b/00B/00F<[8b8[002R0:<00B/J6QX
0XP00hb8[002d0_e0m000lb/d002c003d?7A00;a2?D01?WenOTAm@06dO7adO7A1_D4n@Cj0_T01_Gi
nOWjm@?i00CjnOGi2OD3n@;j0_T4m@04lOG@d0>/0/`2R0=400=XA4@024@00fQ4J002J004R4A4J0:8
00Z/R:cAc?7enOGi0_D00oWem@03nP?i1?D00oWem@06m@03nOGe00Se00?imOT02OD03?7elM7adO7e
lOGad@;e0_T00oGaR003A00494A490=400EX[=3el@03m@06n_GenOGi0_D00oWem@09m@03d<b/00><
00>/R8P01:`3J005S8Q4J8P00fP00hR<S003[007d:c@d?7ed002m@03lOGe00;e00CamOGa0_D01M3a
dLc@00:/1HP02Hb/[:c@dO7Am@02d004dM3@c0:800=XR8P00fP00hQ4A004A0LT0T@012A492@3A003
94A400M400@TA4A40VP01HR/d=3A00?@00?<d<`00/`2[004d8b/J0a40R@4A00494@T90e400@TA4A4
12@3A00394A400=400=XA4@024@01FQ4A4AX009400AXA4A40VP00hQXJ008R0:<00>8S8`018P018b/
R:`3S0V800F/R8R8S002R004J8R/S0>/00B<R4AX0hP2[0><00>8S:`00j`1S00000=XA4@06d@00bA4
900>A08T1d@00bA490029003A2A400A40R@3A00394@T00HT0T@49003A2A400940R@;A00594@T94@0
0b@9A003J4AX009X18P01:c<d:`3S0:800B<[8b/0X`01Zb<S:c<[0:<00>/S:`03Z`3S004R:b/[0:<
00B8J6QX0hP2[0;@3?D01M7@d<c@00:/00?@lM000_4@m@03nOGe00[e00CadO7A0o44m@;i00CjnOWj
1?T00oGin@02n@03mOWj00;i00CjnOWi2?D3n@Cj00?imOT01?D00m7@[004[0:816P>A09X0d@2J0:8
00N<c:c<dOGi00Ce00?imOT00oX00oWen@0@m@03nOGe00ke0_401OGAdLc@00;a00CAmM7A0oD01_[e
mOF<J0940R@014@TA2@2A003R:c@00Se00GimOGen@0:m@04lM3<c0:<00>/d:`00XP01Hb/R8Q400=X
00=4J6P00fP3S004[=2/c0?@00CadOGa0_D00o7em@06m@03dOGA00;A00O@[:b<R6R800B<00K<d=3@
dO43d@04d:c<R0AX00>8A6P01D@00bA4A0049004A2A4A08T00=492@01T@00fQ49002A08T0d@00fR8
S002c0?@00O<d=3@c=3<00?@00B/S8QX3d@590=400<TA4@01d@00bA49002A0DT00A492@T54@00fQ4
J003A0MX00>8S8P00XP6S003R6R800:800J<R8b/S:`5R003S8R800>800=XR8`00XP00fR8R005S003
R6QX00:800><[:`00h`00hR<S002S06/0H`001a400<TA4@01T@00bA4A007A00394A400Q40R@01T@T
94@TA08T1T@29003A2@T00A400<TA2@00T@00bA4A002A00394@T00a400<TA2@00b@5A00394A40094
00AXA6QX1HP5[007R:b8R8b/R003S003R:b/00B/00?@[:`00Z`00lb/S009[004R:b<S0>/00f<[8b8
J8R<R:b<[<c@00ge00G@dM3@c003d003dO7a00Se00?imOD00_D01?WemOT<m@07lOG@dOGAl@05m@04
nO[inP;i00GjnOWim@02n@03mO[e00Ci00?jnOT02?D2n@;j00?in_T00_T00oGim@02m@03dM2/00>/
18P00fQ4J009A003J4AX00=400=XA4@00d@2J005R:b/[=002?D00oWjnP02n@Ge00?imOD07?D01?7e
lM42d0;A0_400oGAm@06m@03[8Q4009400<TA2@014@01FR<[=3a00Ge0oT>m@05dM3@[8`00XP00hb/
R004R005S6QXJ4@016P00hR<R003[0;<00G@dO7el@0;m@04lOGem@;a00SAd=2/S:b8S0:800><[:`0
0]001=7alO42d@;@00?<S8P00XP01FQ4A6R800941B@2A0DT0T@39005A2@TA6P00d@290=400@TA6QX
0XP00jc<d002d003dM3@00;@00K<d:c@c=02[003R4A400940VP6A00394@T00940R@2A00394A40094
00<TA4@03D@29003A2A400i40VP014AXJ4@3J004R6QXJ0:81fP00hR<R003S0>800F/R6QXR004S003
R8b/00:800EXR8R8J004R003J8R800:800><[8`00j`018b/R8P2S005R:b8S8P00X`00jb<[002[06<
000>A00394A401=40R@9A00394A400Q41B@4A08T1T@490=40b@00d@TA005A00394A401940R@4A003
94A400=40VP3R004S8R/S0:/0X`2[004R:b/[0:<00F/R8b/S007[0;@0j`01<c@[<`;[0:<00>/R8P0
0XP01fR8R:c@dO400_D00o7em@07m@07dM3@d:c<[002d0;a2?D3nA;e00SAlM7amO7el@?e0oT2nPCi
00CjnOWj0oT01OGinOWj00Ci1oD4n@?e0_T00oGim@02m@03lM6/00:/00?<R6P00VP3R0a400AXA4AX
1T@00fR8[003[0;a1_D2n@03n_We02Oe00?adM000]401?7AlO44m@05nOGed8P024@2909400>/d=00
0_D01?WenOT@m@03dM3@00:/0hP2[004R6QXR0:/0XP01FQ4J8QX00:800V/S:b/S<c@mM400o4=m@04
lOGAc0;@00>/R8P00X`2R003S<c<00;@00CamOGa0]42d005c8b8[8`00VP00dAXA003A08T00U492A4
94@TA2@01D@00fPTA005A00394A400=40VP3R003c=3@00;A00?ad=401=02c0>/00><R6P01T@00bA4
A004A00494@T90A40R@6A00394A400I400<TA2@00T@290m400EXA6QXA003J004A6QXR0IX28P00hb8
S003R003J8R800B80X`018QXR6P4R0:<0hP00fR8R003R004S:b/S0:/00>8J8P00X`2R009J8R<S8R<
R:b800:<000BA00394A401E400@TA4A40b@5A00394A4008T00=492@00R@2A00394A400M40b@4A08T
00=494@02T@00bA4A008A00394A4009400<TA4@02T@2J004R8b8R0><0j`2S0:/00N<[8R8S8R/00B8
1J`2c0B/00?@[<`00m000lc@[002[003R:b<00:/00>8S8P00XP00fR/[002[003d?Ga00_e00Oad=3A
d<b/00;@00?AmOD01_D01OWenOWe00?i3_D00o7Al@02l@03mM7a00?e0_T00o[inP02nPCi00GjnOWi
m@05n@;j0oT00oGim@02m@03nO[j00?i00GenOWinP04m@04lM2/c0:/00R8J6QXS6R8J0E400=XA4@0
0T@00fQ4A005A0AX00J8[8b<c=05m@0:n_Gin_WjnOGjm@;i4_D00oWem@05m@03n_Ge00Ke00Kad?7a
dOD2l@03nOGe00;e00CjmM280VP2A0@T00Q494AXS8S@d@;e00CimOGj2_D04oWemOGadLc@c8R<J8b8
[8aXR:`00X`01HR/J6Q400>800><R8`00h`01:cAd?D2l@Ce00KamOGamO43m@0:dOGAdM3<d:b<R0:/
00>8[8`00]001M7@dOGa00;e00?AlM000Z`00fR8S002J0=400<TA4@00T@690Y400=XA6P00T@00fPT
A004A0=X0XP01Jc@d=7@00;A00G@dM7@d@02[006c:b8S8Q40VPBA00394@T01E400<TA4@01D@4J0I4
00IXS6QXA6P2A09X00>8J6P00hP01FR8R6R8009X00R8S8b<R6R8J0:80VP4R006S8QXR8b/0XP00hb/
S003R09X0XP02fR<R8R<[8b8A8R/00B800><R8`00X`2[0680J`1[000:4@01BA494@T00940b@4A003
94@T00I40b@014@TA4@390A40R@2A00394A4009400@TA4@T0d@01BA494@T00]40R@3A0DT24@01FR8
R8R<00F/00><R:`00X`2[0:<0XP00jb8[003S0F/00S<[:b/c:c@[0;<0Z`00m2/[004[004S:b/S0:8
0fP01HR<[:c@00;a3?D2d@;@00?<[<`00]49m@03nOGi00;e0_T2m@03nOGe00We0_42d@;a00?AlO40
0oD2n@;j0_T00o[in@05n@05n_GinOD01?T2m@03nOGe00;e0oT02O[imOWenO[en@03m@03lM6/00:/
00?<[6P01FP8A00394A400Q40XP01:b8S8`3[003c=3e00Ge00Oin_[imOWe00;i00?enOD02oD00o7e
m@0Cm@03lOGa00?A00?elO400oD01O[imOF/009X0T@490A400EXS:c@l@02m@Ci3OD01?7Ad<`2[007
S8R8S:c@[003R007J8R/[8QXA003R0>/0X`01:c@lM42l@03dOGe00Ge00?amOD00oD2l@03dM3<00:/
0X`2[0:<1=001O7emOGa00;A0/`00jb<R002J0E40R@00d@TA00990M400IXA4AXA6P2A003J4A4009X
00F8J8c@[003d0;A00C@dM7A0m000lb/[002R09X2T@00bA49002A00394A400A400@TA4A40R@HA0=X
00=4J4@00d@2J004R6QXA09X00A4J6R80VP6R005J8R8J8P01H`5R005J8b8R6P01HP00hb8S003S0>8
00=XR8P00XP00jb8R002R006S8R/R8aX1HP016R8S8`2[06<0HP0015400<TA4@05T@00bA4900290A4
0R@9A00494@TA08T0T@290941B@2A00394A4008T0T@00bA4A007A00394A400Q400<TA2@01D@290A4
00@TA4A416P00hR<[005[0:800F<[:b/S002R003S:b/00:/0hP4[006S:b/[8c<1j`01M2/[:c<00><
0XP4J0><00F8c=7el@0:m@05lM7@dL`01=02l@Ce00?imOD00_D3n@03n_We00[e00?amOD00_D01M3a
lM3e00;A00?elOD00_T01O[imOWj00Ci00CjnO[j1oT00o[en@06m@;i00?jnOT00_D2n@;j1_D3d003
c:b8009X00>8A4@00d@01BA4A4@T00E400=XA4@00T@016R<R6P2R0F/0]001m7emOWenOX00oT00oGi
m@0Bm@?i1OD00oWem@02m@03nOGe00Ge00GadM7Al@04m@;i00KjmOGa[6P4A0DT0T@016R<c=43m@?i
3OD00o7Ac003d004S8R8S0>/00><R6P01HP3J0B800>/S8`00]001M7amOGa00ce1?401M7@d:b<00:/
00G@S8S<d002d@03lOGe00;e00?Ad:`00j`3R0940R@4A0DT00=492@00R@:A0AX1D@3J004R8c@[0;@
00GAlM7Al@03d0;<00C@c:b<0XP00fQ4A008A08T1d@490A400<TA4@014@00bA4A002A003J4A400]4
0VP024AXJ4AXA6Q41FP018QXJ8P2J0F80fP2R003J8R/00J800><R8P00hP016R8R6P4R003S8R800><
00>8S:`018P00hb8R002S003R8b800B800]XR8aXR6R<[8QXR001J000<T@01FQ4A4@T00A41B@01D@T
A2A400<T00=492@00b@3A00394@T008T00=492@054@00bA49005A00394A4008T1D@4J003R6R800:/
00><[:`01Z`01XR<S8b/S0:/00B8[8b<1:`00hb/S002[003c:b/00B/00C@c8b/0X`3[004S6QXJ0:8
0X`2[003d?Ge00_e00?Ad=401=000m7el@0:m@03n_Wj00;i3oD2l@03dO7a00;a1?D01oWjnOWjnOD0
0_T00o[in@0;n@?e00CimOGe1?T3m@;i00CjnOWj1?D01]7@[<b<R09X00=4J6P00d@012A4A4@3J094
00<TA4@00VP00dAXJ003J003R:b/00:/00B<c=3a0oD2n@03n_Wi00;e00?imOD06?D00oWem@02m@;i
2?D00o7Al@02l@Ce00?in_T00_D01=28J6P2A0DT0d@00hR/d003m@;j0_D00oWen@09m@;a0/`018c<
[8P2S0:/00F<[:c@S002R09X00b8J8R<[8R<[8b/d=42l@We00?amO400oD5l@06d<b/S:b<0j`00m3e
d@06m@04lM3<d0:/00=XR6P034@690Q400YXA6QXR6Q4J4AX1HP00lc@d002d@03lM3A00K@0/`2[004
R6R8J0U40R@8A0<T00=494@00T@491540R@7A09X0T@016Q4J8P4J0:800=XR6P00hP2J0>800=XR8P0
0hP016R8S8P2S0B800B<R8R80VP00hb8S002R0><0Z`3S0J800><R6P00hP2J006R6R8S8R/0hP3J068
000/A00394@T01940R@8A00394A400M400<TA2@012@5A0<T34@00bA4A005A08T1d@2J0>80h`2[003
c:c<00F/1H`00hR/R00?[0;@00C<d:b/0XP00jc<[002[09X0XP00jb8R002[003d?Ge00_e0]43d004
c=3al@;A00?amOD01?D01OWenOWe00;i00?enOT02oD00o7el@05l@Ce0oT00o[in@04n@06mOWinO[e
1OT00o[im@04m@04nOGin@;j00?enOX01?T2nP;e0_401_G@c:c@S0AX0T@00fQ4A003A003S6QX00U4
0fP00dB8S005[006c?7enOGj0_T01O[imOWe00;i00?enOD05oD01?WenOT;m@04lOGel@?e00?jnOX0
0oD00jaXA002A0@T14@00fR/c003m@03n_Gi00_e00CamOGA0]05[003S:b800:/0/`2[005R6QXJ8P0
0h`3[006S<c@d?GA0_D01=7emO44m@03lOGe00?e00?amO400m02[007S:b/S:c@d@02l@;e00?amOD0
0]401Lc@d8b8009X0T@00fQ4A002A003J4A400=40b@:A005J8QXS8P00VP01dAXR6R8J8P00Z`2d005
lM3amO400]001Lc@d<c@00:/00C<[8b80VP:A00494A490=41B@EA00394A400E400<TA4@00T@00fQ4
A003A0IX00>8J8P018P2J0>800><R8P01HP5S004R:b8[0R80X`00hR<R002S0F80X`00hR<R003R003
J8QX00=X1hP2J0:80H`002i400<TA4@01d@00bA49003A08T00A492@T1d@290=400@TA4A412@3A004
94@T90I400<TA4@024@29003A2A400=40b@6A005R6R8R8`00XP3[0;<1Z`3S003[8b800:<0j`00hb/
c008[003c:b/00>/00B<[8b<0Z`00hb/R003R0B<00>/d?D03?D00m7@d005d0;a00?AmOD01_D3n@03
mOWi00ke00?amO400_401?GalO44m@05n_WjnOD01_T00o[in@07n@Ke0oT00o[in@06n@04n_Win@;e
0_400m7@c002[004R6QXJ0=400<TA4@00T@00fQ4A009A003J4B800>80Z`01Xb/[<c@m@?i00?jnOT0
1_TXm@;a1_D01?WjnOT2m@04d6Q4A0<T0T@2909400EXR=3@l@02m@03nOGe00[e00KamO7@[<`3[003
d:b/00:/00?@[:`00Z`00hb8J002J003R8b800>/0X`01<b/d?D3l@03mO7e00Ke00GamOGel@02m@03
lM7@00;@00>/S:`00j`3d0Oe0]000lb/[003J0]40R@014@T92@4A00394A4009400EXA4AXA003J0=4
0VP00hR<c002d0;a00?elO402=000jc@S004R003J4A400I412@6A00394A401940b@=A003J4A400=4
0VP00hQXR002R09X0hP2J0^800><[8P00hP4S0:800F<R:b8S002R0B<0hP01FR8R8b800:<1XP5J0B8
0VP2R003J8R<0068000/A0<T1T@00bA49005A00494A490Y40R@00d@T90029004A2@T90U400<TA4@0
4D@49004A2A4909400@TA4A418P2S003R8b/00V/00F<[8b<[002R004[8R/S0>/00><[<`00Z`00hc<
c002[003c8b/00><00>/S:`01XP2S0:80Z`00m3am@0;m@03dO7@00?@0]400o7Am@07m@07nOGinOGj
n@0@m@05lM7AdOD00_43m@03nOGi00Gi0_X01oWjnOWjnOX00_T2nP;i1OD8n@03n_Wi00Cj0_D3l@?@
00F/S:b/J002A004J4A4J0i416P3R0:/00J<[<b/d?D2n@05n_Win_D01OT00oGim@0Dm@03nOGe00Ge
00?imOD01oD2l@Ge1?T2m@03d8Q400940R@2A08T0d@016R/d?4?m@0<lOGAd:c<[=2/R:b<0Z`2d007
[8b/S8QXR002J004R8b<S0>/0]001O7emOGa013e00KAd=3<d<`3[003d<c@00;A1oD00m7@d002[0MX
0d@00bA4A00390940b@3A00494A4A09X14@7J004R:b/[0;@0_401?GamM02d@G@00?<[8P018P2J003
R6Q400E40R@DA00494A4J0A40R@DA004J8R8R09X00B8J6QX0hP00fR<R002R09X18P3S004[8R8R0><
0j`5S003R:b800:800B<R6R<18P3S0>800>/R8P00XP01VR8J8b8J0:800IX[8b<[8P1J0004D@00bA4
A00PA00394A400A400<TA4@01D@012A4A2@7A00394@T00e400<TA2@03D@00bA4A003A00394@T00E4
0R@5A0=X00>8[:`00j`00m2/[006[006S:b/R8b/18`3[003S=3@00Z/1X`018R<[6P4R005J8b8c=40
3?D01_7@dM3Ad0;A0_4:m@04nO[jnA7e0o400oGam@03m@Si00CenO[j1_T01_[inOWjn@;e00?imOT0
0_T01O[inOWj00Ci0oX00oWem@02m@05lM3@c:`00hP00fQ4A008A09X14@00fQ4A003J004A6R8S0J/
00C<d?Ge2_TKm@03nOGe00;e00?imOD02OD00o7em@02m@03nOGi00?e00?AS4@014@01RA492A49094
00>/c=000oD00oWem@08m@;a00CedM3<0Z`2S0:/00B8S8R<1:`00hb/S002S003R8b<00J/00?<lOD0
0oD01O7emOGi00Ke00?AmM400_D00m7@d005[005c=3ad=401_D2l@05dM3<c8`018P016R8J6P2A0@T
00=494@00T@490I400AXA4A41fP00hR<S002[004lM3ad@?e00?AlM000]001Lc@d=2/00:<0XP5J094
0VP2A0HT24@00fQ49005A00394A400=400<TA2@00R@6A003J4A400Q400=XA6P00XP8J003R6QX009X
00>8J6P00VP2R004J8R8R0:<00b/S8b8S8R<[8b/R:`3S003R:b<00:<00=XR8P00hP00fR8R004S0B8
0X`3R005[8QXJ8`00XP1S0680HP001A400<TA4@01d@01BA494@T00Q40R@:A00494@T90940R@2A005
94@TA2@01d@00bA49008A08T14@00bA4A00290a400<TA2@01D@59004A2A4J09400=XA6P00hP00jb<
[006[003c:b/00>/00><[8P00X`01HR/[:b<00V/00?@c:`00Z`03HR/[8b8[8b/S8R<R6P00hP2[003
d?7e00We00?adM401=401_7@mOGad@;e00?imOD06?D2l@04d?GAl@Ge00CjnOWj0_T01?GinOX3n@05
mOWinOX00_T00o[in@03n@0;mOWinO[imO[imOT01?X2n@;e00?ad?D00]001<b8J4@2J0E40R@6A003
94A4009X0T@3J003R:c<00B/00J8[:cAmOT4m@;i00?enOD06oD2n@ke00CadOGa0oD2n@Ce00>/J4@0
0d@290E400EXR8c<l@06m@03nOGe00Ce00KamOGAd:`2S0:/00N<[:b/S8R<00>/1HP00jb<S006[003
d?Ge00Ce00?amO401?D01?7AmM42l@;e00?adM001:`2d003c=3A00Oe00?amM000]000lb/S004R003
J8QX00940b@00d@TA003A08T14@00fQ4A005A0MX00B<[:b/0m000o7em@02m@03dO7A00;A0m001Jb<
[8b800=X1D@390941B@9A003J4A400E400<TA4@00b@2A00494A490A400<TA4@024@016Q4J6P2R004
J8R8J0B816P00hQXR002R006J8b8R8b80X`00jb8S002[003S:b<00>/0h`01:b8[8`3R004S8QXJ0J8
00F<R8R8J002S0:800EXR8R8J002R004S8R8S05X000^A00394A400M400<TA4@014@29003A2A400U4
0R@00d@TA003A08T00=494@024@00bA4A006A00394A400A400<TA2@01R@00d@T9005A09X0Z`4R006
S:b/R:c<0Z`00m3<c003[0B<00F8[:b/S009[00:d:b/[8R/S:b8J0B80VP028QXJ6R8[=3a2?D01O7e
mM7e00;@00?Ad?400_D00o7ed@06m@03nO7e01?e00?idM400]000oGal@03m@04nOGjn@;e00KjmOWi
mOT2m@06n_Gin_Wj0_T02_[enO[enOGin_D3n@03mO[e00;j00cin_GenO7elOG@[<`2R09X1D@00fQ4
A005A006J4A4A6Q416P2R0;@0Z`00hc<[002[003d?Ge00?e00CjmOGi1?D00oWem@0?m@05lOGemOT0
0_D01_WenOWen@;e00?imOD00oD2d@;e00KAmOGenOD2n@05mOWe[8P00T@3909400HTA2@TA8P2[003
lOGe00[e0_400m7ad@02c0:/00?<[:`00X`00jc@[002S004[8aXJ0>800F<[:c<S002[003c:cA00Ke
00?amO400oD01o7edO7AmO400_D2d@03d:b/00>/0/`2d0?e00?amOD00_D01?7@d=02[0B80VP01hQ4
A4@TA2@00T@3909400<TA4@02T@4J09400EXR:b/c003d007lOGelOGAl@02d@07d=7@d8b/R002S09X
00=4J6P00d@390941R@9A09X1D@49003A2@T00=400DTA4A49002A00394A400M400AXA4AX0hP3J003
R:b800:81FP3R003J8R800><00>8S8`01H`2R004[8b/[0:<0Z`2R003S8QX00:816P00jb8S004R005
J8R<R6P00hP4J0:<0hP1J00084@00bA4A00<A00394A400E40b@4A00494@T90940R@7A0@T0d@490A4
00<TA4@02T@00bA4A005A00394@T00<T00A492@T0T@00bA4A003A003J8R/00B800><R:`00Z`00lb/
[008[0:81X`2[004S:b/c0:<00B/d:b80j`3S003J4B800:81fP00hc@d00<m@;A0]03d@04mO7Ad@[e
00?imOD04OD01M7@lM7a00Ge00GjmOWinP02n@04mOWim@Ci00CenO[i0_X5n@03mOWj00?i00CenOWe
1?X00oWem@02m@04lM7ad0;<00B8J6QX44@01FQ4A6R8009X00><[:`00Z`02Xb/[:b<[=7amM42l@Se
00C@lM3@0]401?7emO4@m@04nOGenA;e1?T2m@04d8Q4A0TT00E4J8b/d00=m@;a00Ced=3@0j`01Lb/
[:b<00:/00B<[8b/18P3S0>/0/`00jc<l@07m@03lOGe00?e0o401=7elOD2l@;@00>/c:`00/`2d003
dM3A00Oe0]42d0:/00N8J8R8J4AX00E400<TA4@00b@<A09X00=4J6P01FP2R003[=3<00;@0_43m@;a
00?@dM400m000haXR004R09X1T@00bA490029003A2@T00<T1T@3J0A400@TA2@T0T@00bA4A008A08T
1D@01fQ4J6R8A8P00VP014AXR6P3R004S8QXR0=X0hP3J0>800><R8`00j`3S0:80j`4S005R:b/S:`0
0XP00fR8J004R004S8R8J0:80X`00hQXR003R0=X0XP00hb8S001J0005D@00bA4900YA00394@T00]4
00<TA4@01T@00bA4A002A00394A400a400@TA2A40R@2A00494@T90=40b@5A004J8R<S0F80X`7[003
c:b/00>/1H`00jb<c004[00<c:b/[<b/R:b8[8b/0X`00fR8R002R003J8QX00=X0Z`00m3em@0;m@;a
1=400o7Al@02lAge1?45m@;i0_D00oWjnP04n@03mOWi00Ci00OjnOWjnOGi00;j0_T2nP?e0oT5nP03
nOGe00;e0_42d005c8R8A6P01D@00bA4A00:A0EX00B/S:b/0X`01Zb<[:b<[0?@00CAmM7A0]000m7@
d004[005c:b/d<`00]400oGam@0Bm@03nOGe00ke1?T2m@05lJaXJ4@01B@00d@TA002A004J8S@l@We
00CAmO7a0_D2d@?@00?<[=000Z`00hb/[002[003S<b800:<0hP2S0:/00G@c:c@l@04m@04lOGel@Ce
00C@mM7a0_D01=7elO44d004c=2/[0?@0]400oGam@03m@06dM3@d<b/0hP3J0I41B@@A09X00=4J8P0
0VP2R006[=3@d=7a1?D00o7ed@02d005lM3<[8`01HP00fQ4A005A0DT0d@012A494@290E400DTA4@T
A0049007A2A4A2A49002A00494@TA08T1T@5J004R6QXA0R80fP3R09X18P00hb8S003R0><00>8[8P0
0h`018R<S:`2R0><00F/R8QXR002J005R6R<[8`01XP00jb8R004R0><0XP1S06/0HP002E400=XA4@0
0d@00bA4A00<A08T1T@390]40b@=A08T1d@00bA4A002A00394@T00M412@7A09X0XP00fR<S002R003
S8R<00>/00Z<[:c<[<b/S:b80X`2[003S:b/00>/00J<c:c<[<`2[005R8b<R8`00XP01:b<R8P2J009
R6QXR6R<[=3a00ge0_400m3Ad@02d@03lM3a00Ge00?imOD05?D01O7elM7a00Ce0_T01?GimOD5n@07
mOWenO[enP02n@09n_WinOGin_Wj00?i0_D5n@;j00?in_T00_D01o7emO7@c:`00VP9A00394A40094
00<TA4@014@018QXA8P3[003S8R800><0Z`6d004mM3@d@;@00?<[8`00Z`00hb/S003[0;@00?<mOD0
4?D2n@_e00?amOD00oD01?WjnOT2m@03[8Q400=40R@00d@T9004A004J8c@l@[e00KAmOGelM42d007
c=2/d:c<S002[0:<00B8S8b/0XP018b8S8`3[003S:cA00ge0]400o7em@02l@;e0o42d005c=3AdM00
0m42m@03lOGe00?e00?ad=000Z`3R0=X00=4J4@01D@012A4A4@290a400AXR8Q416P2R005S=3@dO40
1OD2l@06dM3@dM3<0Z`3R0AX1d@390Q40R@8A00494A4A08T00I494A494@290a416P01HQ4J6Q400>8
00B<R8R<0XP2J0F80VP018R<S8P2S0B800B/R8R/0h`00hR/R002S0:800><R8P01HP2J0:800B<R8b8
0fP2R005S8R8R6P00hP01Jb8J8R/00:<000WA08T24@00bA49002A00394A400=400@TA4A41B@<A003
94A400U40R@3A00494A490A400PTA4A494@TA08T0d@490M416P01DAXR8R/00:<1:`018b/[8`2[003
d<c@00:/00F<[:b/d006[006S=3@S:c<0Z`038b/[8b8[8R/J8R<R0=X00F8A6S<d008m@03nOGe00?e
00cadOGadOGadO7AmOT7m@03n_Ge00oe00gAmO7@mM7amO7enOGi00;e00CimOGi0_D01_[enO[enP?i
00Wen_[enOGin_T00_X01?GimOD2n@08mO[jnO[in_T5m@04d<b<R0IX0d@290A40R@4A007J4A4A6R/
R002S00=[8R/S:b<[=3<d<c@d@04d003mM3@00V/00G<[=2/d002m@;i1OD00m7em@06m@;i1_D00o7e
m@02m@05lOGemOX00_T01o[inOG@[6P00T@00fPT9002A0@T0T@018R/mO49m@04lOGel@;A0/`3[003
d:b/00:80h`018R<[<`4R0F/00>8[=002OD01?7emO43d0Ca0_D03O7@lM3<[<cAlM3edO401oD2l@;@
00><[:`00XP2J003R4AX00M400<TA4@01D@016Q4J8P2J0=400AXR6R80VP2A003R8aX00;@00?AlOD0
1?D2l@05d=7@c=400Z`2R09X00>8A4@00T@00fQ4A004A00594A4A2@01T@00bA4A002A00494A4A0DT
1D@29005A2A4A2@02D@00hQ4A002J0=40fP2R003J:aX00>800><R8P00hP026R8R8b8[8R<0XP00hb8
R003S006[8b<S6R<0XP01Jb8R8R<00:800]XR8aXS8R<[8QXR004J0:<00>8J4@00XP01VR8[8b8S0:8
0H`002=400DTA4A49009A00394A400=400<TA4@014@00bA49002A08T2D@01BA492A4008T1T@00bA4
A006A00394A400M40R@2A00394A400940b@3A00394A4009400=XR6P00fP01XR/R8b8S0F/00><[:`0
0Z`00m2/[003[003S:b<00:/00?<[8`01:`00lc@[004[004S:b<S0:/0hP6J004R:c<d0ge00[AlM3a
d=7@lM7a1OD00oWem@0Dm@?A0]000o7em@05m@04nOGen@;e00?imOT00_T00o[in@02n@06n_WinOGi
0oX3n@03mOWi00?i0oX01?WjnOT4m@07dM3<[8R<R003J003R6Q400E400<TA4@00d@02VQ4A4AXA6R8
S:`2S0:/00B<[:c<0]001M7@dM7a00;@00?adM000j`00m3ad@02[003c=3@00;@00>/c=000_D00oWe
m@0Hm@03lOGa00?e1OT2m@03[6Q400A400<TA2@00R@3A004J:c@d@[e00?adOD00_42d003[<b/00:/
00C<S6R/0X`028R<[:b8S:b<1Z`01<c@mO43m@03lOGe00Ce00Cad=3A0_401oGamOGad=400]000jc<
d002d@Ca1_D2l@04dLb<[0B80VP9A0@T1T@2J003A6Q400=400=XR8P016P01Xb/R<c@d@Ce00CAmO7e
0]401M3Ad<b/00:800=XR6P016PKA08T00=492@012@5A08T24@2J004A6QXR09X0T@00hQXR002R005
J8R<R8`00hP01FR8R8QX00B800F<R8b8S002R006J8R<[8R/0h`018R<R6P2R0:<0XP016R8R6P2R003
[8b/00B80fP00haXJ002R003S8R800><00>8S8`00J`002M400<TA4@02T@00bA4A007A00394A400=4
00<TA4@00d@00bA4A00490=400<TA4@01D@00bA4A006A00394A400A400<TA4@014@3909400<TA4@0
0d@00bA4A002A005J4B8J8P00X`00hR<S002S004R8c<[0:<00B/c:c<0]03[009S:b/[=2/c:b800>/
00?@[:`00Z`01Hb/[:b<00:800F<R8R<R003J006R6QX[<c@3_D2l@GA00?adO406oD2d@03d?7@00Ce
2?T01?GimOD2n@09n_WinO[in_Wj00;i00?enOX00_X6n@04mOWjnPGi1?D01?7@d:`2R003J4A40094
00=XA4@014@00bA4A007A0=X00J8[8R8J8P2S0>/0]003m7@dM7ed=7<dM3<dOGAl@03d003dO7e00;a
00B/c<c@2_D00o7el@03l@ce00?amO400oD6n@04mM6/J0A412@4A005J8R/[=402OD01o7@lOGadM00
1Z`00hQXS004S004[8b8[0:<00>8[8`00j`01/c@d=3el@Se00KadM7@mM44m@04lM7@[0C@0]401?Ga
mO43m@03lOGA00;A0]0018R<S8P2J0]40b@8A003R6QX009X0d@00hQXR003J003S<c<00;@0_42m@03
lM3e00;a00?AlM400]000jb<R003R09X0XPHA00394AX009400@TA4A412@5A0<T00=494@014@3J0>8
0fP014AXJ6P3R003S8R800R80VP00hR<R004R0:<0XP01Hb8S8R<00:800>/R8P00XP018b8S8`5R007
J8R<[8b8S003R007J8R8R4B8S002R0:<00B8S8R80j`00003R4A402M400DTA4A49004A00594A4A2@0
14@012A494@490I40R@014@TA4@690A400@TA4@T4T@00bA4A0029003A2A400Q40fP00dAXR006R0:<
0XP028b/S:b8[<c@0Z`00lb/c003[007S:c@[<b/S003[004S:b/S0F/0XP00hb/S002[00;R6QXJ8b8
J:c@c=403OD00m3ad@06d007dOGemOWen@02m@03nOGe00oe00OadM3@lM3a00?e1oT3m@?i00CjnOGj
0oT01?Gin_D3n@07n_WjnOGim@03n@03mO[j00;j00?in_T01OD2d0:<0XP8A00394A400Y40VP00hR<
S002R09X0X`3[006d=7edO7A1=001OG@lOWe00?@00?ad?D01?D01=3<c<`3m@03nOGe00Ke0_42d@ge
00KamOGenOD2n@03mOWi00;e00G@R4A49003A00394A400<T00EXR8R/d@0;m@?a0]001:c<c<`2[0>8
18`00hR<R002R0:<00>8S:`00Z`01]3<d?7ed@Se00?adO400m401o7emM3Ad=401]001O7emOGa00Ge
00GadM3ad002R003J4AX00A400@TA4A41R@014@T92@=A008R8aXR6R8S:`2d003dM3a00Oe0]401]3A
d:b8J0:800EXA4A4J00:A00394@T00Q400=XA4@034@390=412@8A004J8R8R0=X00=4J8P00hP2S005
J8R8R8`00XP018b8R6P5R0:<00J8S:b/R:`4S0F80h`4R005J8R8R6P00h`4R003J8R800:80VP4R0><
0XP00hb/[001[000@4@290M400<TA2@014@490A40R@3A00494A490i400DTA4A49004A00394A400I4
00=XA4@00T@4R005J8b<R8`00XP00jb<R002[003c:c<00:/00?<[<`00Z`00hR/S004[004S:b/[0:<
00F/S<b/J002S005R:b8S:`00hP5J008S=3<lOGamO48m@05lM7AlM000/`01M7@lO7A00?e00?imOD0
0_D00oWem@0?m@;A00Gad?7ed@03m@04nOGin@;e00[imOWimOWenO[e0_X00oWjn@02n@04mOWjn@;j
0oD01_WjnOGjm@;j00Gin_WenP03m@;a00?<S8P00XP7A08T00A494A40b@014AXA4@4J0>800B<R8R<
0Z`03<b/d?GAmM7@dLc@m@;@0oD3d006dO7enOGi0_D01=2/c?43m@04nOGen@?e00GamO7Am@02d@;e
00?AmOD01OD00o7em@03m@Oi0_D00ha4A007A08T00M4J8R8[=3A00_e0_42d003[=2/00>/00>8J6P0
0hP018b8R8P3S003[6R800B/00G<d=7ad@09m@03dOGA00;A00CamO7@0m46d0?e0_401?GamO42d@04
lJc<[0>80fP6A00594@T94@01b@4A0=X14@5J003R:b800;<0m000o7em@06m@;@00KAc:b8S8P2J003
A6Q400U400AXA4A40b@6A09X2D@012A494@390=412@2A004J4A4J0E40VP02DB8R6R<R6R8J003R005
J8b8R6P00hP00fR8R003R003J8R800:<0Z`01hb/[8R/R8`00Z`018R/R8`4R09X1XP016R8J6P5R09X
00F8[8R8[002S0:80Z`2S0003D@00bA4A00AA00394A401Y400<TA4@02D@00bA4A002A08T00E492@T
A0039003A2A400A40b@<A00494A490A40b@5A00394AX009X00=4J6P00hP2S003[8R800B81Z`00m3<
d002c0>/0X`7[003S:b/00:<00>/S8P00X`01Jb<[8R/00F80fP018R/c=09m@?a00GAd=7@d@05d003
dO7e00?e00CimOGi4_D2d@05d?7@mO401?D01?WemOT4m@Gi00CenOWj0oT01?[in_T2nP06nO[imOWe
1OT3nP?i1OD01=3<S8P4J0a400<TA4@014@00fQ4J002J004R8b8R0>/00J<c=7amO44d0;A00KadOGe
d:`2d0;e00?in_T00_T01?Ga[:`@m@03lM3@00;@00?AmOD01?D2l@Ge0_T00oGin@02n@03mJaX00]4
0fP018R<d?4:m@04lOG@d@;<1:`4R003[8b800>800B/R8b/0XP00jb<[003d004dOGam@?a1?D2l@CA
0oD01]7alOG@c0C@00?amO400oD4l@;@00G<[8R8S004J0E412@2A0DT0T@012A4A4@4J0=40XP00fR8
R003R004S:c@d0;a1OD01?7ed=43d004[8R8R09X00=4J4@024@01RA4A2A490M400DTA4A49009A0@T
0d@490U40fP4A09X00F<R8R8J004R003S8R800:800AXR8QX0X`01HR<R8b800><00>/S:`00h`018R<
R:`5R004S8R8R0=X0XP00hb8R002R09X0XP2S003R6R<00>80h`00hR<[002[06<0009A00494A492A4
00<TA4@02T@00bA4A00DA0DT1T@590M400<TA4@024@490M400=XA4@00hP016R8R8`2[09X0XP02:b<
[:c<[<b/0]001Lc@c:b<00b/0XP018b/S8`2R004J8R8[0>81FP01XR<[=3el@_e00?AlO400]401]3A
d=3AlA[e0]401=3edO44m@03nO[e00Oe1OT00o[in@03nP;i00?jnOX00_X00oWen@06n@?j0oT6m@06
dM2/[8Q40VP4A00594A4A2@024@016Q4J4@4J0>800B/S:b/0]001=7emM44d007dO7AmM7@S002[0;e
0_X2n@;e00C@[:ca3OD2l@?@00CAd=3@3?D01OWjnOWe00;i00Ged8b<J003A08T00=494@014@01FR8
R<cA00We0_42d003c:b<00><0XP00hb8[003S003R8b800:<00B/S:b<0Z`00lc@d004m@03lOGa00Ge
00?amM000]401oGamM7amM400j`2d0;a1OD01O7edM7<00:/00C@[8R<0VP00hQ4A004A08T0d@39003
A2A400E41FP2A0AX1HP2[003d=7a00;e00CamO7e0_42d@?@00><R8P01FP3A00494@T90942B@7A08T
0d@01RA4A4@TA0@T3D@01VQ4A6R8J09400AXA4B81fP5R004J8QXJ0:80h`00fR8S003R004S8R<S0>8
0X`00jb8R005R006J8b8R6R80X`4R003J8R800:800><R8P00XP2J006S8R8S8R/0X`2[0009d@00bA4
A00EA00394A400M400DTA2A49005A00494A4909400<TA4@014@01BA4A2A4008T00=492@03T@490=4
00<TA4@00T@2J009[8QXR6R/S:b<00:800>/S:`00Z`00m2/[002[004d:c@d0B/00><[8`01Z`3S0:/
00F8[:aXR002S003[8b800=X00B8J6R80Z`00m3al@03m@03nOGe00Ge00CadO7a0]43d003dM3e00;e
00?imOD04_D00o7ed002d@;@0]43m@04nOGin@Ce00?imOD00oT01?[in_T3nP03nO[i00Cj2?T00o[i
nP03nP;i00[jmOGed=7@[8b80VP00d@TA003A0<T0T@01BA4A4@T00Y400=XR:`00j`00hb/d@02l@08
mM3@mM3AmM02d@07c:b<R<cam@02n@Ce00CA[<ca3OD00o7ed003d004c=3@d@ce0oT01OGimOWe00>/
00=XA4@00b@2A00594A4J4@00VP00hR/d@09m@03lM7@00>/0XP00jb8R00:R0:<0XP4[003d?7e00?e
00?amOD01_D01?7@dM43l@05dO7edL`00Z`2d003lOGe00Ce00CadM3A0]001jb<[8b8J8P00fP8A003
94@T008T0d@012A4A4@2J0940fP6R003J8R/00?@00?AlO401OD3l@;@00F/c8R8J004A003J4A400A4
0R@00d@T900990E40R@2A0<T00=4J4@00d@29003A2A400U40VP4A006J4AXJ4AX0hP00fR8J002J003
R6R800F800AXR8R/0X`2R004S8QXJ0:800V<R:b<[8R<R8`00hP2S0B800><R8P00X`01fR8R8QXR8`0
0XP01Hb8R8QX00:80Z`01fR8S8b/S:`00H`003A400<TA4@04d@00bA4A003A0DT14@00bA4A005A003
94A400m40R@3A08T00=494@024@2J0F80h`01HR<R8R<00:81j`02=3<d?7@[8b/0X`5[00:S:b<S:b<
[8b/R0><0hP2J0>800IX[=3@mO43m@03nOGe00Oe00?adO400]400o7Ad@02d@Se00?imOD03?D01?7e
d=43d0;A00?amOD03?D01?Wjn_X4n@Oj2oT3nP04nO[in@Ke00B<R8QX1D@3909400B8A2@T1d@00fQ4
A003J005A8R8R8`00j`02m3AlO7Ad?7@lM7a00;A00C<[:b/0]000o7em@04m@03d:c@00ke00?amM00
0m001Jc@d=3a00_e00?in_T00_T01oGimM2/S8P00T@690I400F8[<cAl@07m@03dM2/00>/18P00fR8
R002R003J8R800:80Z`2R005S8R<S:`00]000m7ed@02m@;a00?elOD00_D01]7alO7@m@;a00?Ad=00
0]02[003c=7e00Ce00SadO7Ad=7@c0:/00B8S8R80fP6A00394A400=412@00d@TA002A0=X00=4R6P0
0VP2R004S8R8S0:800>/d=000m400oGam@04l@03d=7@00:/0XP2A005J4A4A6P00d@490=40R@014@T
92@5A00494A4A08T0T@290I400@TA4@T2T@01FQ4A4AX00A40VP3R003J8R800:800EXR8R8S003R09X
1HP00fR8R003R0><00>8S:`00h`2R0B<00F8S8b/R002S0>800AXR8QX1HP01VR8R8QXR0:<0XP2S004
[8R8[06<000mA00494A490Q400@TA2@T0d@490M400<TA4@00d@290I400<TA4@02d@490I40VP01TAX
J6R8J0B800><[8`00X`018R<R8P5[004c:c@[0;@00?<[:`00Z`01hb/[:b<c8`00hP01Xb8R8R/R0:<
0hP01FR8R6R8009X00B/c<ca1?D00oWem@02m@03nOGe00?e0o43d@03lM7A00Se00?imOD00_T<m@?@
00C<[=3a1?D00oWem@05m@Gi00?jnOT02_X4n@03n_Wi00;j0_T3nP04mO[jn@Ce00CadJb<0fP5A0<T
0T@290Y400AXA6Q40fP00hR/[002[006d=7adO7A1=002OG@lM3<[=2/S002[004d=7<l@;@00>/d?D0
2OD00o7el@02m@03dOG@00;@00F/d=3ad007m@06dOGemO[i0_X00oGim@02m@;@00>8A6P00T@39094
0R@02D@TA6R8[<ced@07m@07d:b8R8b/R002J0B80VP2R003S6R800:/00F<R8R<R002d003lOGA00;e
00?amM400_D01o7elM7ed?400_D2l@0;d=7AdOG<[=3AmOT00oD00m7ed005d004[<b<R09X00>8J6P0
2T@29003A2@T008T14@00fQ4J002J005A6R8R8`018P01Zb<[<cad0Ge00KadM7elM42d003[6QX00AX
0T@016Q4A4@590E400<TA2@014@00bA4A002A00394A400<T14@490E400<TA4@01d@2J008A6QXA6R/
R8`2R003J8R800B800=XR8P01hP2S004R8b8R0>/00B<c8R<0XP00hb/S002[009R8b<[8b/S8R/00><
00>/R6P01XP2J003R6R800:800F/S8R8S002[003S:b/006/000nA00394@T00M400DTA2A49002A08T
2d@00bA49003A00394A400A400<TA2@00T@00bA4A005A08T00=494@00d@01bA4A6Q4J8P01FP4R0:/
00f<[8b/S:b<[8b/d<c@00;<0m000lb/c005[003S:b800:800F<[8b<R002[004S8R8S0J800=XS:`0
0/`00oGam@0=m@?a00?@dM000]000m7em@05m@03nOGe00oe0]03c003dO7e00?e0_T8m@;i0_X00oWj
n@08nPGi00?enOT00_X2n@;j00?enOT00_T3m@04lM7@[0:800=XA4@00T@2J003A2@T00I40R@8A0EX
00>8[:`00Z`02=3AmO7Ad:c<0]001OGalM3<00:/00B<[:b<0j`01M2/c<ca00ke00KamO7Ad<`2[004
c=3Al@Ce00?amOD01?D01?[inOT4m@04lJb8R09400<TA4@00d@4909400AXR:cA1?D01_7emM3<[0:8
0fP2R004S8QXJ0J800^<[:b/R:b8[<c@l@02m@04dOGel@;e00camOGelM3AlM3Ad=42d003dM3@00;<
00?@mOD01OD01M7ad=3A00?<00>/S:`00hP3J0A400<TA2@02B@5A0=X00F8J6R8S003R0><00F/d=3@
l@03m@03lOGe00Ga00C@c8b816P5A00394A400DT0T@00bA49005A08T1d@01RA492A490940b@5A003
94A400A40R@2A006J4AXJ4AX0XP00hb8J002J0:800AXR8QX0XP00fR8R003R006S:b/R8b80X`02hR<
S:b<[8b/S8R/00B<0hP2S004R:b<[0F80VP3R09X00>8J6P00XP2S0:80h`00hR<[001[0003d@00bA4
A00GA00394A4009400<TA4@03T@01RA4A4@TA08T1D@00bA4A002A0DT1T@012A4A4@29004A2A49094
00<TA2@00T@00bA4A002A0<T00=494@00R@;A0EX18P2S0>800F/S:b<R002[003c:c<00;<00?@c:`0
1:`00hb/[002[007S:b8[8R<[003R005J:aXR8`00hP2S0>80Z`00m3am@04m@03nOGe00Oe0_45d0;A
1_D00oWem@05m@03nOGe00Oe00?AmO400]001:c@lO43m@04nOGen@Ke00Cin_[j0_T:nP03mOWi00;i
00?enOT01OT01?[in_X4m@07dLb<[8b8J00:A00894A494@TA2@3A005J4A4A6P00XP016R8R8P3[003
d=7e00;A0m02d@05mM3adM000Z`02Hb/[8b/c:c<d002l@_e00?amO400_D3l@07c=2/[<cAl@07m@03
lOGe00?e0_T00oGim@03m@;@00>8A4@01T@390A400AXR=3a1?D2l@05d:b/[8P01FP3R003J8R800B8
0X`2[004R8b/S0;@00?amOD02OD2d@03lM7A00;A00?@dM000_44d003lOGe00Ke0m001<c@d=02[003
S8QX009X1T@00bA490069003A2A400=41FP00hQXR006R003[=2/00?@1oD3l@;A00G@c:b<R003J0=4
0b@3A0LT00E494A49009A00394A400940b@014@T92@6A0<T3D@00fR8R005R0:<00MXR8R8[8QX00J8
00EXR8R<R002S0:/00R8[8b/S:b<R0><0XP2S0:800B/S8b<0XP00hb8R003R005S8R8R6P01HP018b8
S8P3S0:80X`000e400<TA4@01D@00bA4A00HA00394A400I400<TA4@00T@00bA4A00290U400DTA4@T
A00490U400<TA4@024@290U400@TA2A412@7A004J4AXJ0>800=4J8`00XP01Zb<R8R<R0B<0Z`02Xb/
c=3<[<b/c:`2S004[8b<[0:<0Z`018b8R8`2R005J:b8J8P00VP01Jb8S6R800><00?<lOD03oD00m7@
d003l@03dO7e00ce00?imOD02OD2l@;A0]000m7em@0:m@;i0_X4n@03n_Wj00Kj00?elOD00_T00oGi
n@02n@?j00CimOGi1OD01=2<c:`2S003R6Q400=400AXA2A41B@7A004J4AXJ0>800iX[:aXS8S@[=7a
dO6/c0;@00CAlM3e0_42d005[<b/c=000]400o7Am@0>m@03lOGa00;a00?Ac<`00j`01=7amO44m@;a
1OD2n@03mOWe00Ce00?@[8P01D@290Q400AX[=3A0_42m@04d<b/[0:80fP6R003J8R800>800>/S:`0
0Z`00hR/[002d003lOGa00We00CadOGA0o43d@07mO7AmO7Al@08m@;@00G<[<c@[002R003[8QX009X
00F8J4A4J003A0<T1D@00bA4A003J003R4AX00=X0XP2S004R8b<c0:/0]000o7em@06m@03dO7A00;@
00>/S6P00XP2J0A400LTA2A494@T00A412@014@T92@6A00894A4A2A494@4909412@00d@T900290A4
0VP3A0=X00=4J8P00XP00hb8R006R003S8R800=X0XP00hb8S003S00=R8b/R6R<[8b/S:b<[002S004
R:b<S0>800=XR8`01HP016R8S8`3R09X1XP00hb8S004S06/0H`002U400@TA4@T5D@00bA4A006A003
94A4009400DTA2@TA002919400DTA4A4J006A00394A400@T00=494@01d@2J007S8QXA6R8[004R009
J8b8R8b/S:b<00:/00?@[:`01:`2S0>/00MXR:b/S:b<00>80X`00jb<S002J0:800>/R8P00VP01HR/
[:cA013e00Cad=3A1O4Gm@?a0]42d003dOGa00?e00?imOD01?D4n@?j0oT7nP;i00GenOGen@07nP03
mOWe00Ge00?@[:`00Z`018QXA6P2A09X00A492A412@4A005J4A4J4@00VP018b8R6P3R00;S6R/d?GA
mLb/d:`00]401]3alO7ed0;a0]001=7@lM4Bm@06lM7ed=7<1:`00m7al@04m@04dOGed@?e00KjnOGi
mOT2m@05n_GA[8`00fP00d@T900:A0:80]001?7AmM02[003S8R800:80VP5R005S8R8R6P01H`4[003
d?7a00Ge00?AmOD00_D02M7amM3amM3ad004m@;A0_D01O7emO7e00;@00Kad?G@c=42[0:<0XP3J003
R6Q400E40R@01D@T94@T009400<TA4@026P2R004[8b<R0>/0m000o7em@06m@03lOGa00;A00?@S8P0
0fP00hQXA002A00494A4A0DT0d@59007A2A4A2A49002A00394A4009432@00d@T900390M400>8J6P0
0VP<R003S8R800>800IXR8R8[8P2S0:/00N<R8b/R:b<00J/00J8S8b<R8`5R0:<0XP016R8R8P3S005
R6R8R8`01HP2S005[8b<S<`00Z`002a400<TA4@074@290I400<TA2@014@00bA4A00;A00394@T00I4
00<TA4@00T@590]400=XR8P00VP2R003S8R800:800=XR8P00X`3[0:<00>/d:`00Z`2c004[8R/c0:/
0X`4[0:<0XP00jb<S002[0B800><R:`00hP3[003dOGe00oe00CadM7a0_D00o7em@09m@03nOGe00_e
0o401?G@d=02l@[e0_T4nP?i00?jnOX01_X2n@Ce00Cin_Wi0_X2n@Oe00G@c:b<[003J0I40R@4A003
94A400=40fP2A0>80fP2R004[8b/d0;a0]03[005lM7elOD00_42m@03lOGa00;e0_4Cm@04lOGad0>/
00B<[?7a1_D2l@Ge0_T00oGjm@05m@05d:aXJ4@00b@2A00394@T00I40X`2d007lM2/[8R/S002J004
R8aXJ0F800><J8P00XP00jb8S005[0;@1oD00m7em@02m@04lM7ed@?a00C@mOGe0_47m@08dO7AdOG@
dM02[0:<00=XR6P00fP00hQXA005A0<T00M492A4J4@T00940fP018QXR6P2R0:<0Z`01HR<[=2/00;@
00?AmOD01oD00o7el@02d004[8R8J0]412@3A0DT00A494A40b@01T@T94@TA08T0d@7909412@8A09X
00=4J6P00fP018R<R6P4R003S:b800:800=XR6P00hP00hb/[002S0B800><R8`00h`018R<[=05S0b8
00>/S8P01HP018b8R8`3R003S:b/00><0J`1S06/001FA0@T1d@00bA4A005A00394A400A400<TA4@0
0T@49004A2A490=40R@4A09X00J8J6QXR8`2R0:<1HP3[0:<1j`01<b/c:`2S0:/00><[:`00j`00hR<
R002R0:/00>8J8P00hP01Hb8R8c@00:/00?AmOD00_D00oWem@02m@;i1_D02?7AdM7adOGA2oD01?We
mOT3m@03lOGe00?e00?amOD00m400m3el@09m@03nOGe00Ki2OX00oWjn@03m@?i00CenOWj0_T7m@?@
00B/R6R80fP5A00494@T90E400DTA6R8A003J0:80VP01TAXJ8b/c0?@00?Ad:`00/`3l@;e00[amO7A
lOGamM7a5?D01]7ed=2/S0:/00?<lO404_D00oWem@03m@03[8QX009412@6A08T00=4J8`01J`018QX
R8P2J0B800>/S8`00X`00hQXR002J003[8R/00>/00C<d=7a3OD01m7edO7AlM400_D3l@Ke0_401]7a
lO7Al@;@0Z`00hQXJ002J0:80fP5A0DT0T@01RA494AXA0AX0hP016R8R:`2S0B/00?<d=402oD2d@03
d:b/009X0d@2J0Q400DTA4@TA0029003A2@T008T0d@00bA4A007909400@TA2@T0T@2909400@TA2@T
1D@016Q4A4@4J003R6QX00>800=XR8P00hP00hb/R008R0:/0X`4R0:<00B8S:b80X`00jc@[003R003
S8R800V800F<[8b<J003R09X1XP7S0680H`001Y400<TA4@08T@00bA4A00DA08T2T@00bA4900@A08T
00A492@T0T@00bA4A004A00;J4A4A6R<R6R8S8P00X`4R0B<00G<S8b/S006[005c:c<[8`00j`018b8
[:`2S0B800><R8P00hP00fR8R002R0B/00?@dOD03oD00o7Ad@05lASe00GamM7ec002d003lOGe00Ce
00KimOGenOD7n@Sj1_T00oGin@03m@Ci1oD4d003S8R/00=400=XA4@00T@012A492@2A00494A490=4
0VP3R003S8R8009X00B8[:b/1M000jb8c002l@Ge0o43m@03dO7A01;e00?ad=400]000lb/[002d003
lM7e00ke00?imOT00oT2m@04lM2/J0=40b@6A08T0T@00fR/[003[0F80VP2R003S8R/00J80VP4R0><
00?<dO400_4;m@;a00?elM400]43m@03lOGa00Ge00CAd=3A0]001=7ad=42[0N800=XR6P01T@49003
A2A400940VP00dAXJ003J003R6R800:800B<[8b/1M000o7em@07m@04lOGAd0:/00><J6P00d@2J0e4
00<TA2@01B@4A0DT00=494@00b@00d@TA002A00394A400=40R@5A004J4A4A0=X0XP018b8R8`2R003
J8QX009X0X`3R003S8R800>800><R:`01HP00hb/R002S006[8b8[=2/18P2[0:<00F8S8b8J004R003
S8QX00>80VP01XQXR6R8[0><00B8S8b80Z`004]400@TA4@T54@00bA4A00>A00394@T00e400EXA4A4
R003S0>80Z`00hb8[002S005[8b8c=003J`00hb/S002[003S<b/00>/0XP01Hc<[:b<00:800EX[:b<
R004[0;@4OD2d@04d<cal@ce00?imOD02?D01o7emOGAlL`00m001M7emOWe00?i0_D6n@03n_Wi00;i
1_X00oGin@04n@03mOWe00;e0_T00o[im@06m@04d:b/[0>80T@2J0940R@4A00394A400I40fP2R0:/
00V8J8R8[8c<[<`00]04[003lOGe00?e0_400oGam@03m@;A00?edOD01oD2l@03dOGe00;e0_400m3<
d003d003c=3A00;a00?edOD01?D00m7em@06m@07n_Gin_Gim@02l@03[6Q4011400B8[:b/0XP00jb<
S004J007R:b/R6R8J002[0:800EXR:b8S002R004[8cAd0;e00?AmOD02?D00m3ed@02m@03lOGe00;e
00?AmOD01_D01M3Ad=3e00;@00Ced=2/0hP016R8J8P3J0A400=XA4@01B@3A0EX00>8J6P018P01FR<
[=3<00;@00B/dM3@1OD01?WemOD3l@04d<c@S0:800=XA4@01D@00fQ4A007A0PT0d@690E400<TA4@0
24@00bA4A005A09X0d@01FR8R8S<00:800J/S8QXR6P2R004[8QXS0b800AXR8b/0XP2S003R8b/00:/
00>8J8P018`00jb<R003S004R8b8[0N800EXR8R8J003R007[8b8S8R<R002[000;T@00bA4A00FA006
94@T94@T14@290I400<TA4@01d@012A4A2@2A00394A400Q400<TA4@00d@490Y400=XR8`00XP01fR<
[8R/R:`00X`:[003S:b<00:/00K<[:b/S:`2S005[8b<[8`01Z`3S003R6R800>80VP018R/d=4:m@07
nOGemM3am@02d@03d=7a00;a6_D00o7@d002d003dO7e00?e0_T00oGjm@03m@04nOGin@?e0_T5nP03
nOGi00?i2?D00oWem@06m@06c:b<[8QX14@00fQ4900290A400@TA4@T1D@00hQXJ002J003R:b800:8
00><[8`00Z`00m2/[003[004d?7el@Ce00?amO400oD01o7AdM7amO401OD3l@03mO7e00Ce0]001jc@
d=7@dM003_D00oWem@02m@Ci1?D00m28A003A00394A400=412@3A004J8R/[0:<0hP2J005S6R8S6P0
1HP018b8R6P2R0:<00B8S8R/0]0;m@04lOGel@;e00?amOD00oD01O7elOGA00;e00?Ad=401M002=7@
lLb/R:b<0VP00dAXJ003J0I41B@014@T94@7J0>800=XR8`00Z`01m3<c=3<d?402_D01_7Ad:b<R09X
1D@290=400<TA2@01D@59004A2@TA0DT0T@29003A2@T00<T1T@00bA4A00<A003J8R800N800>/J6P0
0XP01FR8R8R/00:<00B8S8b<0hP01:b8R6P6R0:/0h`01ZaXJ8b/S0:800F/S6R8[006S0:800=XR8P0
1XP00fR8R004R0B<0J`001Q400<TA4@014@00bA4A00?A00394A400=400<TA4@03D@01BA4A4@T01E4
00HTA4A494@3911400LTA4A494@T009400HTA4A4J4@2J0:800F<[:b8[002R0:<00>8S:`02J`00hb/
[00;[0><0Z`018b/S8`2[0:80T@2J003A6R<00:/00?@lOD01?D00oWem@04n@07mO7elM7ad003d@03
lOGe01;e00CamOGe0_42d@;@00?AlO400_D01?WemOD3n@05mOWemOT01?D4n@Cj0_T01OGinOGi00Oe
00?imOD01_D01M3<[:b800AX1D@290E40R@3A005J4AXJ8P00fP2R003S8R800J/0/`00jc@[002l@05
mO7elM400_42m@03lOGA00;A00CadOGa0_D2l@05mO7emO401?D01O7edM3<00G@00?<lOD02OD00o7e
m@04m@?i00?jnOT00oD00m2<J002A0<T14@79004A8R8S0J80VP2R00<S:b<R8b8[8b8S6R80VP3R004
S:c<d0ge00CamO7a2?D00o7em@02m@03lJc@00?@00?Ad=400]001M7@S:b<00:800E4J6R8J003A003
94A400LT00=494@00VP2R006A6QXJ8b80Z`5c0C@2OD02_7@dM7@c8QXA6P;A08T00=494@00d@390E4
1B@8A00394A4008T14@00bA4A00:A0>800=XR6P00X`018R/S:`7R005S8R<S8P00VP4R006S:b8R8b8
1H`01Jb8S8R<00:800J/S8R8S:`2R003J:b<00:/00B8[8R<2HP2J0V80X`002m40R@EA00394A400E4
00<TA4@05d@012A4A2@?A08T0d@00bA4A004A0=X00A4J8R80X`01fR<J6R8[8P02J`01Lb/[:b<00:/
00F<[:b/S002[003S:b/00:/0hP2S0B/00J8J6QXR6P2R003S:c@013e00SAd=7@dM3Ad0ge0oT8m@03
lM7@00C@0_4<m@03nOGe00Ge00Cin_[j1_T9m@03nOGe00Oe00?AlL`00X`00fR8J007A00694A4A2AX
2D@01hQXJ6R8J8`00j`00hb/[002[0?@00?adM400o400oGam@03m@;a00WedM7@lM7elOD00o4;m@;a
1]000jc@m@0Am@;i00?jnOT00oD00m3<R003A08T14@49004A2@TA09X00>8J8P018P016R8R8P3[0:<
00F8S8R8S002R0=X0XP01Jc<d=3a00ce00?amOD00oD01?7emOD2l@0;dOGemO7@[=3ad<`00]02d@;@
00C<S8b<0XP3J004R6Q4A08T0d@690=40fP3R09X0X`3[004d<c@c0?@00?AmOD00_D00oWem@03m@03
dM3@00:/00>8J4@02D@29004A2A4A08T24@012A4A4@590Q400@TA4@T14@39003A2A400=400EXA4A4
R004J003R:b/00:<1HP00hb8R004S0:80VP4R004[8b<S0>/0X`028R<S:b8[8b/0X`01Jb<R6R/00:<
00>8S8`01:`018R<R6P3R09X00>8J8P018P00jb<R004R06<000cA00394A400=400=XA4@06D@00bA4
A004A08T1d@2915400DTA4A49007A00594A4J4@016P02XR<[8R<R6R8[8`3[008S:b<S=2/S:`2S005
[<b/[8`00Z`00hR<S005[004S:b8R0:/0X`00hQXJ004R005S8R<[=003oD00o7Ad002d@04lM3Ad0ke
00?jnOD01OD2l@04d=7@c0?@0]4:m@;i1?D2n@03mOWj00?j00GenOWinP02nA;e00?@mJ`00X`018QX
J6P5A08T00=492@024@01FQ4A8QX00:80h`01<b/S8`4[009c=3<mM7amM7e00;a00OelOGelOGa00;A
00C@dO7a0m42m@04lOGAd0Ke00?Ad=000m02[003d<ca00ge00GimOGim@03n@03n_We00;e0]401:a4
A4@290I40b@00d@T9002A003J8R<00J800IXS8c<[8`6R003S8QX00>80h`01:c@dO47m@03lOGe00Ge
0o401_GamOGAd0Ce1=002M7@d=3Ad?7@[002S003[8R<00>800=XA4@014@890=400=XR6P00hP2J004
R:b/c0S@00?amOD00_D00oWem@04m@06dM3<[8QX0T@00fQ4A004A00494A490=40R@00d@TA0029094
0R@3A0PT00=494@022@2A0<T0d@01VQ4J4AXA09X00>8J6P018P3S003R8b800B80X`2R003J8b<00:8
00B/S8R/18`00jb8R002R009[8b/[8b/R:b800:<00>8J8`00X`018R<R8P2[003S8R<00:800><J6P0
0VP3R09X0hP4S0>8000YA08T3T@00fQ4A00GA00394A400I400<TA4@01d@00bA4A002A08T0T@00bA4
A009A08T2T@2J09400=XR8P00XP2S0>800G<S:b/S002[003c:b/00:/0X`00jc<[002[006S:b/S:b<
0j`01/b8R:b8[0:<00>/R8P00VP3R005[8b8S:`00]43m@03nOGe00Ge00CimOGe0]000m7@d002d0;A
00?@mOD01_D00o[em@02n@04n_Wen@Ce00GamM7@d@02[003c=3a00;e00KjmOGimOT2m@04nOGen@;e
00GimOWjn@02nP03nO[e00;i00Gen_WenP0@m@07lM3@R8aXR003J0=400DTA2A49008A006J4AXA6R8
0VP2R0><00?<[:`00Z`2c008d=7@lOGamM42m@08dOGelOGAmO43d@03d?7@00;e0_401OWemOGA00Ce
00CAlM7<0m001<b/[=42l@Ge00CimO7i0_D01_WenOWenP;e00CjmO[i0oD00o7@J006A08T0d@012A4
A4@2909400B8J6QX0hP2J0>800f/S:aXR6R8S6R8[8b/00><00>8[=000_D01O7emOGi00?e00?amOD0
0_D02O7elM7amO7el@02d@04lOGed@C@00KAc=3@lM42d007c8R8R6R8J002R003J4A400A40b@2A08T
1D@00fR8R003R004S8R/[0;@00G<d=3@d@02d003lOGe00?i1?D2l@05dLb/S8P014@00fQ4A002A003
94A400=40R@5A0DT14@390=40R@2A0@T0T@49003A2A400E400MXR6QXA6R800=X0X`00hR<S002R0:/
1HP01Hb8S8R<00:/0XP4S007[8R8R:b8S003R00?S8R8R6R8S8R<R:aX[8R<00B800F<[8R<[002S003
R8aX009X0XP00fQ4J002R005S8R8R8`00hP001i400<TA4@02D@00bA4A006A00394A4009X4T@290a4
00<TA2@01T@012A494@390=400<TA2@00T@00bA4A004A004J4A4A0@T00=494@00T@03BA4A4B8J4B8
S8R/R8`00Z`01Hb8[:b<00b/00?<[:`01:`3S0:/00B<[:b<0j`02Hb8J8R<J8Q4J002R007S8R8[<cA
l@06m@03nOGe00Ce00?Ad=001]02l@ce00?jnOT01oD00m7ad002d0;<0]09m@03nOGe00;e00?imOT0
0_T5nP?i00?enOD04oD2d003[<b800:800=XR6P00d@39003A2@T00A40VP014AXA6P2A005J8aXR8`0
1Z`01=3<[:`2d0;a1OD00o7el@05m@05dO7@lM400]02d@[e00KamO7@mL`2d006[8c@d?7A3?D01OWe
nOWe00;i00GenOWjn@03m@03d6Q400A41R@2A0@T0T@2J006A6QXJ8R/1XP018b8R8P2S0:/00?<[:`0
1J`00lcem@0?m@;a00?AmOD00_D00o7Al@03m@06d:c@d=7<1M001Jc<[:b800=X0XP00fQ4A004A0HT
24@01XQXJ8R<[0C@00?<d=000m001?7emOD3n@Ce0_42d004[8b8J0]400<TA2@00R@4A0@T00=492@0
0d@00bA4A003A0<T00=492@01B@2A0<T1d@8J0:800=XR8`028P00fR8R003R0:/00F<R8b/R003[0:<
0Z`01hb/S8R<c8P01H`018R/R:`5R003J8R800:<00>8S8`01hP5J0:800F/S8QXR002S06/000]A08T
00=494@09T@01BA4A4@T00Q40b@2A00494@T909400<TA4@02T@490Y400=XR8P00hP2[003S:b/00:<
00F/R:b/R00;[004d<b/[0:<00B/S:c<0j`3R0:<0XP00fR8J003J0>800>/c=000oD01?WemOT8m@;@
00?Ad=400]02l@03d?Ge00?e00CimOGi0_D4n@Ge0_42d@;@00F/d:c@d@04m@03nOGe00?e00CimOGi
1?D00oWjnP02nP03nO[e00;i5OD00o7@[002S006A6QXJ8QX0d@39006A6PT94AX0d@00fQ4J003J0>8
00>/S:`00Z`01Lb/d=2/00C@1_D00o7em@05m@;a00WAlM3adO7AmO402?D00o7Al@03d008c=3@[=3A
mO4>m@03nOGe00Ci0oX3m@03d8a4009X00=492@01B@2A0@T1D@2J0:818`018QXR8`2J003S8R<00><
1j`00m3am@0Am@03dOGe00;e00CadOGa0_D01M2/d=3A00;@00B/d:c@1:`01haXJ6R8S6P014@99004
A8Q4J09400=XA8P01:`9d0;A0oD00o[im@04m@;a00K@c:b8S8P7A08T00=494@01D@00bA4A0039003
A2@T00@T14@59003A2@T008T1D@490A40VP00dAXJ006J0B800F<R8R8J003R0AX0XP3S004R8b<S0:8
00><[8`00hP4S003[8b/00>/1H`5R003S8R800>800F/R8R8[002S003R8b800AX0XP00fR8S005S000
8d@00bA4A00;A00394A400Q400<TA4@04d@00bA4A003A00394A4019400<TA4@014@00bA49006A0<T
1D@01VQ4A4AXA0=X00F8[8R<R003S003R:b/00:<00>/S8`00j`00lb/[004[003d:b/00B/0X`4[0B8
00>/S:`00VP00hQXR004R0:/00?@lOD01?D00oWem@06m@;A00CadM7@0]400o7@m@07m@04nOGen@;e
00?imOD00oD3l@03dM3@00>/0]42m@03nOGi00ge00?in_X00_X00oWjm@02nAGe00OAc8b8S4AX0094
00AXA4A40R@00d@T9002A00394A400940VP014B8J6P3R0F/0/`00jc<d005d0ce0_401oGAlO7@mM40
1?400oGAm@04m@04lOG@m@O@0m400o7em@0;m@;i00?en_D00_X01_Wjn_[inP;e00>/R6P00T@29006
A2@TA2A412@2A08T0T@00fQ4J004J004R8b8R09X0hP3[003S:b/00:/0/`2d0oe00CamO7A0_D00o7e
m@03m@04lOGed0:/00K@dM3@[<`3d003[8b/00:816P018QXJ6P2A08T14@290I40VP01HR<[:c<00O@
00?Ad=001OD2n@Ce00Cad=2/0XP3J09400<TA4@014@390=40R@5A0@T0T@00bA490099003A2A400E4
0R@3A003J4A400=400=XA6P00fP6R0:<00B8S8R<0XP4J0B80h`00hR<[002S004[8b8S0:80h`4[005
S:b<S:`00h`02XQXJ8b/S:b<[8P2S007R8b8S8R<R006J0>80X`00hR<S001S0001T@00bA4A00=A003
J4@T01E400<TA4@054@00bA4A008A08T34@00bA4A00EA08T0d@490a400AXA6R<0XP01:b8[8P5[006
S:b/R8b/0/`2[003c:b/00R/00J<d:b/S8P6S005[8R<J8P00VP3R0:/00?AlOD01OD01?WenOT4m@04
lM7@l@;A00?elOD00]4;m@04nOGen@Ke0]400m3<[002[003lM7e00;e0_T01oGimOGimOT01OD2n@Gj
00GenOWen@0Dm@;@0Z`00fR8J007A0@T0T@290M40fP2R006S:b8R:b80Z`3d005lJb/c=401oD00o7e
m@03m@03lOG@00;a0oD03=7emM3elM7edOGad0;A00?<mM000]42d003dM3e00Ge00GimOGel@03m@0:
n_GenOGin_Wjn@Cj00CimO680T@39004A2@TA0HT0T@290I400B8A6R<0XP2J0F80h`2c0:/00?@c=00
0o48m@03nOGe00Ce00C@lOGe0_401OGad?Ga00;e00C@S=3<0]02c0?@0j`01Hb8R8QX00:80VP6A003
94A400Q40VP2R0:/00C@c=3@0]42d0;A0_401=7enOD3n@?e00Cad=7@0Z`2J09400EX92A4J004A08T
34@3909400<TA2@012@00d@TA0029003A2A400E40R@7A0=X00A4J6Q418P018b8R8P2S0:800F/J8QX
R002J0B80X`2R005[8b8R6P00XP2[0:800><[<`00Z`00hb8R006R0:<00=XR8P00h`2R003[8R800B8
0X`2R005J8QXR8`01XP1S0680014A00394A402m412@2A00594A4A2@01d@00fQ4A002J0:80X`00jaX
S004[0><2:`01<c@[<`2[003c:b/00F/0h`018R<S8P3S005[8b<R8`00VP2R0>/00?@lOD01_D2n@03
mOWe00?e00CAlM3e0]000o7Ad002l@ke00?imOD00_D2l@;@1:`01M3amOGi00Ce0_T00oGim@02n@07
mOWemOWjn@02nP04nO[inAGe00?ad=000Z`00hQXJ002A003J4A400940R@00d@T9002A00394A40094
00J8A6Q4J8P2J004[8R8S0F/0m001<b/c?4>m@;a0]400oGam@02m@05lOGAdM000]401O7@d=3A00;@
00O<lM3@[=3A00oe0_T00oGjm@02nP03nO[j00;j0_T01?Ga[6P3A0DT0d@390940R@4A0=X0T@016R<
R8P3J0:80X`00jb<d002[003c=3@00;@00?amM403_D01O7emO7A00?a00CAmM7A0]002XR/c=2/d:c<
d<`3[004R6R8R0EX1T@00bA4A007A003J8R800:<0Z`02<c@dM3elM3a0]401O7@lOGi00;j0_T4m@05
dM3<[8`00XP00fQ4J003A003J4A400m412@00d@T9003A0HT00=494@014@012A4A2@:A0MX0hP2J004
R:b/R0:/18P00fR8R005R006S8R/[8b80fP00jc<R002R0>/0X`01VR8R6R8J0:800B/R6R<18P00hb8
[003R005J8R8R8`00hP00fR8R005R003J8R<006<000VA00394A401U400<TA4@03T@00bA4900CA003
94A400A400@TA2@T0T@00bA4900290A40R@00d@TA003A0AX18P01:b<S8P2S0:/0XP3[005c:b/[<`0
0j`01Hb/c:b<00>/0XP3[006S:b<R:b<0Z`5R007A6QXJ8QXS002[003dO7e00Ge00CimOGi1OD02]7a
d=7@lM3Ad?4;m@04nOGin@Ke00CadM3<0j`00lc@l@08m@06nOGinOGi0_D3n@;j0_T00oGim@0Em@05
lM3@c:`00VP01DAXJ4AX00940R@6A00394A400=X0d@026Q4J8QXR6R80Z`00hb/c004d003[<cA00Oe
00?amOD01OD01_7emOGam@;a00KelM7Ad=42d004[<c<d@?@00?ad=000m0>m@03nOGi00?i0oX01?Wj
n_X2n@;e00K@R6Q4J4@69003A2@T00DT00A492A416P01DB8R8R<00:800=XR6P00XP00hb8S003[0;<
0]001?GalO4<m@Ga00?AlO401=401?7@d8`4[007S:b/[<b/c002[0B800A4J8R80VP3A00394A400Q4
0fP018R/S:`2d0?A1?43d@03lOGi00?j00GimOGel@03d003[8R800:80VP;A0<T1T@99003A2A400DT
1D@00bA4A003A00394A400U41fP3R0F<00>/S8`028P01:b8S8P2S0J800V<R8R8S6R<R8`01hP2S0N8
00B<R:b<2HP016R8J8P2J003R8b800>80H`002m400<TA4@02d@01BA4A4@T00=40R@=A00394@T00m4
00<TA4@03D@39003A2A400=40b@6A0=X00=4J6P00hP01:b8S8P2S0:80j`00lb/[005[005c:b<[8`0
1:`01hb/S:b<[8P018`01JaXR8QX00940fP00hQXR002[003d?Ge00Se00?imOD00oD01_7ed?7@m@?@
00?AlOD02?D5n@Ge00?@lM400]02c003[=3@00_e0_T5m@03nO[j00;i0_D00oWem@0Dm@04lM7e[0:<
00>8J6P00T@00fQ4A009A0=X00A4J6QX0XP00fR8R003J003R8b<00;<00?@dM000/`00jc<l@05m@03
lOGa00Ge00CadM7a1_D02o7AdM3<d<b/S:b<00;@00Ged=7A[002c003d?Ge00ce00KimOWimOT3nP03
nO[j00?i0oD01:aXJ6P4A0<T14@00bA4900390A41FP00hR<R002R006S8R<[8R<1Z`00m3<d@03d0;e
00CamOGa0oD2l@05d?7AmM400_D02]7emM3Ad?7Ad:`2S005R8b<[=000j`2d006c:b<S8Q40VP01HQX
J4@T00=400DTA4A49003A005J4AXR8`00Z`00lc@d004m@04lM3Ad@Ce1?X01oWemOGadM000Z`01Xb8
R6Q4J11400<TA2@01b@2A0DT0T@490940R@=A003J4AX009400AXR8R80VP3R0:<0Z`2S005[8b/R:`0
0XP01Hb8R8QX00:800F/S8b<[002R0:<0XP00fR<S002R004J8R8R0:<00B8S:b<0hP016R8R:`2S004
R8b8J0B800=XR6P00fP00dAXR002R09X0hP0049400<TA4@01T@00bA4A005A0<T0T@290a400<TA4@0
3d@00bA49002909400DTA4A49004A003J4A4009400MXS6QX[8R<00:800F<[8b/S003[004S:b/S0:/
00O@[:b/S:b800:/00><[8`01:`018b/R:`4R004J4AXR09X00N<R8R<[=7a00Se0oT5m@03lM3a00;a
00F/d<c@d@06m@03nOGi00Ci1_D2d004dM3@d0:/00?<d?D02OD00oWen@05m@03nO[i00;i00?en_D0
5OD00o7Am@02d0:<0fP2A005J4A4A6P01d@00fQ4J003J003R8b800:80fP2R003J8b800;@00OAlM2/
c=3a00Ke00?AmOD00_D01M7emO7e00;a00celOGelM7ed=7@c:`2S003R:c@00?@00?Ad=000]000o7e
m@05m@05nOGemO400oD2n@03mO[e00;j00?en_X00_T3nP04nOGAS0I41B@2A0DT1d@3J004A8R8J0:8
00QX[6R<[8R/c0:/00F8[=3am@02d@?e00C@lOGA0_D00o7ed@02m@05lOGedOD00_402OG@dO7AmO7<
[002R003c:c@00:/00O@c:c@[8b800=X00B8J6QX0d@590A40fP3R007c=3@dO7el@02m@06lOGAlOGa
0_D2nP06nO[jmOWe0_400jc@[002S003R6Q400a400@TA4A40b@3A0DT0d@00bA490029005A2@T94@0
0b@5A003J4A400U400AXR8QX18P00hb8J002R0N/00^8S8R<R8b8S8QXR002[005S:b<[8P00h`2R003
S:b800>800AXR8R<2XP01Xb8R8R/J0:80Z`01Hb8R8Q400=X00>8J8P01XP001A400<TA4@084@00bA4
A006A00394A4009400<TA4@01D@00bA4A004A08T0T@29003A2A400I400<TA2@04D@00bA4A00290=4
00<TA4@01T@01FQ4A4AX00>800QXR8R<J8R<[0><00>/c:`00j`00hb/[006[0:<1Z`01Xb/J6R8[0B8
00f<J6QXA6R8J8R/c=3a00_e00?imOD00oD2d@;a00G<d=3@d@0:m@03n_Wi00;e00CimOGe1?42d005
c:c<d?402?D01?WenOT4m@03nOGj00;j0_T4m@03nOGe017e0]000o7<[004R003J4A400Y400@TA4A4
16P00hQXJ002J0:80X`00hQX[002d0;e00G@c=2/d007m@03lOGe00;e0_401?GAlOD2l@04mO7al@?@
00?<d:`00X`01hR/c<cad?400]02d@oe00KimOWjmOT3nP03nO[j00Cj00Gin_F/R006A08T0d@79005
A6Q4A2@00T@00hQ4A004R0:<1XP018b/[:`2d004dO7Ad@;e0_400m3Am@03m@03dOGa00;a00K@lOGA
mO43d006dO7edM2/0XP00hb/[003[0:<00B/c8b80T@2J0M412@5A003J:b800:<00>/d=000_45m@;a
00G@mOGen@05nP08nOGemM7@[8`3R003J4AX00]40b@2A08T14@012A492@2A0HT0T@690E40R@3A003
94A400A40fP014B8S8P2S0:800F<[:b<[003S0:80X`2[004J8R<J0:<00J8S:b/S:`3R006[8b8S:b<
1HP00hb8R002R006S8R8R:b<18P3[0:800B/d:b<0hP01FR8R8QX00:800B<[:b<0J`005U400<TA4@0
1d@00bA4900FA08T0T@00bA4A005A09X00M4J6R8S8QX00:80X`2R0:<0hP2S004R:b/S0:/00><[8`0
1:`018R/[:`2c0>/1HP01:b8R8P2J0=400IXR8b/c=0:m@;i1_D01=3Ad?42d@03d=7@00Ke00?imOD0
0_D2n@03mOWi00?e00?AlM400]42d004[<c@l@Ce00?imOD01OD01?WemOD2n@06n_WjnOGj5?D01o7e
dM3Ac8`00hP00haXJ004A00394@T00A40R@4A004R6QXJ0>800AXR8R80X`01jb<c:c@mO400m000m7e
m@04m@03lOGe00;e00KamOGamO42m@05lOGalOD00m001/b/[8R<R0:/00G<d=3@c002d003lOGe00[e
00CamOGe1?T01?Gjn_T2nP03nO[j00;j0_T01?Ga[6P2A0DT00><dD@00b@00d@T90029003A6Q400M4
00IXR8b<R8`7R003[=3@00Ga0oD2l@Se00GadM7Am@02l@;A0m001=7edM02[007S:b<S:b8[002R0:/
00B8J6QX24@490=400EXR4A4R002S0:/00?<d?401_D2l@04dO7em@Gj00CimOGe0_400m2/[002J0=4
00=XA4@00T@00fQ4A004A08T00=494@00T@00bA4A003A08T0d@390A400@TA2@T0d@29003A2@T00U4
0VP01hQ4R6R8[8P00Z`00hb8S002S004[8b/S0B800J<[:b<R:`4R0:<00>/S8`00hP00jb<R002S0N8
00J<R8b8S8P2S003[8b800>800>/R8`00XP00jc@[002[003S8QX00:800><[8P00Z`00hb/S001[000
AD@012A4A4@290a40b@<A00494A491E400<TA4@01d@00fR8R003R0:<00>/S:`00XP00jb<R002S003
R8b800:<00B8S8b<1:`018R/[8`4[00;S:b<R:b<[8R<[8`00XP2J0A400EX[:c@d@0@m@0;lOGAd?7A
d?7@dM002_D2n@Ke00?ad=400_401=7@[8`2d003lOGe00;e00?imOD00oD01OWemOWe00?i00?jnOT0
6OD01O7@c:b<00>800><R6P00T@290E400@TA2AX0T@3J003A6QX009X00><R8P00XP00jb<[002[008
c=3@d:c<d?4@m@03lOGe00?e00OamOGAlM3<00:/0X`00jc<d003l@03d=7@01?e00Gin_WinP04n@Cj
0oT01OG@S6Q4008T0T@29005A2@T94@01R@3A005J4A4A6P00T@01fR8R8S<dJ`00hP01fR8S:c@dO40
0]44m@03lOGe00;e0_401?GamO42d008dO7edO7Ad<`5d0;<00>/R8`00j`01HR<[=2<009X0XP2J094
00=XA4@00T@290E400EXA4AXR003[003d=7a00Ke00?adM400oD5nPCe00_ad=3@S8QXA6Q4J00;A0<T
0d@290E41B@4A00394@T00I40R@:A09X00A4J6QX1HP2S0:/0XP00hb/S002S0:80X`3R003S:b<00:<
0hP2[0><0hP2S0J80X`2R007J8R<R8b8S003[0:<0XP2S005[8b8[8`00j`00haXJ002R006[8R<S:b<
0j`0019400EXA4A49010A00394A400M40R@2A0<T8D@028R/R8R<R8b/0X`00jb8S002[00;R:b<R8b8
[8R<R:`00X`00jb8S002[003S:b<00N/0X`03:b<R:b<[6Q4J4AXA09X0j`00o7em@09m@03nOGe00?e
00Gad=7@d@02l@04dM3@l@Ge00?imOD00_D2n@03mOWe00;e00cad=7@dOG@c8c<d=44m@03nOGi00Ce
1_T00o[im@02n@03mOWe01Ge00CAd:b/18P01:b<R8P6A006J4@T94B80T@2J09400AXR6Q40hP00fR8
R002[005R:b/d<`00Z`00lc@d@0Cm@04lOGel@Ce00CAc:b/0XP00jc@c002d@05lM3@d=404OD3n@04
mOWjnP;i00?jnOX00oX01oWjnOF<J4@00R@3A00394A4008T00=494@00d@290=400AXA4AX0T@2J00=
R8b/d8b8[8R<[8b/c002d003dOGa00;e00?amOD00_D01=7amM02l@08dM2/d?GamO42d003[=3@00;@
00Kad=3@[8`2c005d8R8[8`00hP01FR8R6Q4009X14@29003A2A400=400UXA6R8[8b/d?401oD00m7a
d@03m@Cj00CimOGa0_D2d003[8b8009X00=4J4@02T@00bA4900290940R@5A00494A490941R@CA0AX
2HP3S005R8b/R8`00XP01Jb<J8b800:/00>8S8`00hP2S006[8b8S8QX2HP00jb8R002R0F<0j`00hR/
R003S005[8b8S8P00Z`2R09X00><R:`00X`00hR/S003S0004T@00fQ4A00AA00394@T01U400<TA4@0
2d@00bA4A0029003A2A400=40R@5A0DT54@00bA4A00:A003J8R800B80Z`01Hb/[:b<00:800=XS:`0
0X`00hR<S002S004c8b<R0:<00>8[8`01:`00hb/[002[006R8b/S8R/0X`00hQ4A004A005J8R/d=40
4?D2l@09d=7AmM7ad=7@00[e00CimOWi1OD01M7@d=7a00;@00B/c=3A1?D01?WemOT5m@_i5_D01]7a
[8b8[09X00B<R8QX1d@290U40XP01FQ4J6R<00B80Z`00hb/d003d003c=3@01?e00?amOD00oD01O7e
mM3<00:/00b<[=2/d=7ac=3<d=4Bm@05nOGin_T00_X2n@Cj00Sin_[ed:aXA0DT0T@00bA4900290=4
0R@00dAXA007A004J8R8[0><0Z`00hR<[003d003dO7A00Ce00oamOG@mO7AmM3elLc@lM401?D01=3<
d:`2d004c=3@d0:/0]03[003S8R800=X00=4J6P00T@00hQ4A009A004J8Q4A0:80Z`2d@Oe0]401O7e
mOGi00?j00_imOGelM7@c=2/R003J0Q400<TA4@00d@29003A2@T008T1D@012A4A2@2A0TT3D@00fQ4
A002J0:80X`7R005[8R<S8P00h`01HR<R8R<00:800R<[8R8S8R<R09X0h`01Jb<R8R<00:80X`2R0><
0XP2S004R8b/R0:<00>/S8`00Z`00hb/[002[0F<00>8S8P00X`2[003S8R<00B8001CA00394@T00E4
00<TA4@00d@290=400DTA4A4900?A00394A400Q426P2R003[8R<00><00>/R8`00XP02Hb8S8b/S:b<
[002S0:/00><R8`00j`00hR/[002S004[8b<R0:<00N8[8b/R6Q4009X0T@00fR8d002d@[e00?imOD0
0oD01_7edO7Al@;A00?@dM002?D5n@03n_Gi00?e00?ad<`01=001:c@dO47m@04nOGen@;e0_T00o[i
n@02nP;i1OD00oWem@0@m@05dM2/R:`00XP01FR/R8Q400=X24@012A4A6P2A006J8R8J4AX18P00hb/
c004[0K@5?D01?7emOD4l@08d<b/[<b/d<`2d003lM3@00?A2_D00o7em@04m@03nOGi00;i00GjnO[j
n@07nP05mO7<R4@01B@2A00394@T00LT1T@00fQ4A002A0B800N<[:c<S8R<00;@00GedO7ed@02m@;a
00?elO400_42d@;a0]02m@05d?GemO400m001Lc@d:c<00G@00K<d=3<[8`4R09X0T@2J0M400<TA4@0
0T@026Q4J8QXS=3a2?D00m7al@03m@04n_WinPCe00cadM3Ad8b8J4AXR6P=A00394@T00<T00=494@0
1T@69003A2@T008T34@016Q4J4@2J0B800=XR8P018P01jb<S:b<R8`00XP018b/S8`2[004S:b<R0:<
0XP2J003S:b/00:/00B<R8QX1HP00fR8R004R005S8R<R8`00Z`01HR/S8R<00:/0/`01Zb<S8b/S0:/
0XP02:b<[8b8[8b80J`001=400<TA4@09T@00bA4A009A00394@T00E40b@3A00394A400M400HTA4A4
J2@5A00394A400i400AXA4A40VP2A003R6QX00=X0hP2S003[8R/00><00>/S8`018P01:b<S8`7[0N<
00R/S8R8S:b<R0:<00=XR6P00X`4J007A8R8[<c@l@0Bm@0;dO7@lOGAd=7@dO401oD00oWen@02n@03
n_Ge00?e0]42d006c:b/[=3A1_D01_WemOWen@;e1?T00o[in@02m@03n_Ge00;e00CimOGi3_D01M7@
c=2<00:800=X[8P01D@00bA4A004A00394A400EX00><R8P00VP01HR<R:b800:/0/`00m3al@02d004
dM3Al@ge00?amOD00_D00o7em@04m@0>lOGed<b/c:c@[<b/dM02c003dO7e013e0oT00o[in@02n@Wj
00WimM68A2A494@01B@3A0@T34@2J003A6R<00:<00K<R8R8S=03d@03d?7e00;e00?amOD00_D00o7A
l@02m@06dO7alM3A0_D00o7Ad002d006c:b/[<b<0/`00m3<d003d003[8R<00:/00F8J4A4J003A005
J4A4A8P00d@016Q4A6P3R003[=3a00Se00?AlOD00oD2n@03mO[e00;e0o42d0:/0XP00fQ4A00@A08T
2T@00bA4A003A00494@TA08T4T@01FQ4J4AX00:800R<R8R/R8b/S0:/00><[8`00X`018R/[8`4[0><
0XP4S0:/00J<R8R8S:`7R0:<00R8S8b/S:b<[0:<00>8S8`00X`00jc<[003S0:/0X`00hQXR002R004
S8R8S0:/000iA00494A490a400@TA4@T2d@00bA4A004A08T1d@00bA4A002A00394@T00e40R@2A003
J4AX00EX1HP2S003R:b800:/0h`018R<R8P3S006R<b/S:b<0Z`2R004S:b<[0B<1:`018b/S8P4J094
0VP014B8R:`2d003lOGe013e0_401=3adM42d003c=3a00Ke0_X2n@;j0_T3m@05lOGad<`00j`2d0[e
00?imOT00_D6n@;e00Cin_Gi0_D00oWem@0=m@;a00G@dO7@[003R003[8QX009X1D@290A400DTA6QX
A004J0:80Z`00hR/[003[003c:ca00?@00>/c=003_D00o7em@08m@04lOGad@;@00>/c8`00Z`2c0?@
00>/d?D02oD00o7em@03m@03nO[i00;i00?enOT00_T7nP05nOGa[6P00T@00bA49006A08T00A492AX
14@00fQ4A007A003J8R800F/0m001Lc@d=3A00Ge00KAmM7amM42m@04d=7Ad@;a0_D01=7@d:`2d0J/
00?<[:`00m02[004S:b/S09X1D@016Q4A4@2J0940fP2R004[8c@d0We00?amOD00_D01?WjnOT3m@03
lM7a00;A00?@c8`00hP016Q4A6P2A003J4A400U40R@00d@TA002A0<T0T@012A492@3A0<T24@00fQ4
A009A0IX00><J6P00XP3S003[8b<00F/00>8[8`00h`00jb<R004R006[8b8R:b<0Z`4R0:<0XP018b/
R8P2S006[8b/S:b80h`2[0:<0Z`01M3<[:b<00>/00><[6P00VP00hR/[003S06/0014A00394A40094
00<TA4@02T@00bA4A007A00394AX019400=XA4@01T@012A4A6P3A004R6QXJ0>800QXR8b8S:b8[0:<
00>8J8`00h`2R004S8R<S0>/00B<R8b<0Z`01Xb8S8b/S0:/0X`3[003S6QX00A400=XA4@00XP01Hc@
c=3a00?e00?amOD01OD01OWemOGA00;a00KAd=3@dL`3d003dOGe00Ce0oX01OWjn_Gi00?e00SAlO7<
d:b<[0;@00?AmOD01_D00oWenP02n@;e00Kin_Win_D2n@05mOWemOT03_D00o7em@02l@?@0X`01hR/
R8aXA6P01D@29003A6Q400=400=XA6P01FP2[004R:b<d0B/00S@lM3@c=2/d0[e00?anOD00_D00m7e
m@06m@03dOGa00;e00?@[8`00XP01:c@lL`3[0;@00?amO402?D01O7emOGi00;e00WjmO[imO[enOX0
0_T01o[in_[in_T00_D01=1XA4@290E412@2A00394@T00U40fP00dAXR003R0:/00g@[=7@c=3ad?7e
dOGa00;e00CAmOGA0oD01O7@mOGa00;e00GAlM3Ad002c003d:c<00:/00F<[:b/c002d0F/00><R6P0
0VP5A003J4AX009400EXA6Q4R002S004[<cAd@ke00CjnOGi0_D01?7AlO42d005[8R8[8`00VP4A003
R6Q401140b@00dAXA008A0<T0T@29003A6Q400E400=XA6P00d@00fQ4J003J003S6R800>800F<[:b/
S003[0:<00V8S8b/R8b/S8P00X`3R009S:b<[8R<[8R<00B80h`01:b<c8P3S0:/0X`00jb8S003[004
S8R/d0>/00B8[8b/0X`01HR<J8R/00:<0j`004A400<TA4@03T@00bA4A00<A08T5D@00bA4A003A004
J4AXA0=X0XP01HaXR:b800:<00F/R8b<[007R0><00>/S:`00Z`3S0:/00>8[8`00h`02Jb<S:b<R8b8
S003R0=X0d@00fR8R002[003c?7e00;e00?AlOD02?D01_7edM7ac0K@0_46m@04nO[inP;i00?jnOD0
0_D2l@07dM3<c:b<c003d0Ge00KimOWimOT2m@?i00OjnOGimOWj00Ce0_T00oGim@0<m@05lM7Ad<`0
0h`2R003S6QX00I400DTA4A49005A00:J4B8J8QXS8R<R0>/0]001Lb/lOGa00;@00?<d?403OD00o7e
m@0;m@05lM6/c8`00Z`2d008[<b/[<cAmM4:m@03lOGe00Ce00GjmOWjn@02nP;i00CjnOWi0_X2n@05
n_Wa[8P00d@01BA4A2A400<T0d@5909400<TA4@01D@018QXR8P2J004S<b/[0?@00CadO7a0_D01?7e
mM43l@05mM7amM400_402M7emOGamO7@c002d005c=2/[=001J`01Lc@d=3<00:/0hP3J0A41VP2A003
J8R800:/0]06m@03nOGe00Ge0_T00oGim@04m@05dO7@c:`00hP3J0=40VP3A00394A400M400<TA4@0
0T@290=400@TA4A40R@4A0HT00=4J4@02D@016Q4A4@3J004R8aXS0:/0XP00hb/[002S005[8b<R8`0
0Z`2S004[8b8R0:<00b8S8b<[8R<R8b/R:`2S0:80h`01:b<[8`3[003S:b/00>80j`01Lb/[:c@00:/
00n<[:b<[8R/S8R<R8b/R8`00Z`000i400=XA4@0=T@00bA4A00;A00394A400E400<TA4@01D@00bA4
A00GA00494AXA0=X0XP01Hb/S8aX00:<00>8S8`018P00hb8R003R00<S8R<[8R<[8b/S:b<0hP00hb/
[002S003[8b<00:800F<R6R8J004R09X0T@01fR8[:c@c=000_D00o7em@04m@06nOGemO7e0]400o7A
d002d004dM3@d0;A2?D01o[inO[en_T00_D00m7ad@07[003lOGe00Ge0_T00oGim@02n@07mOWjnOGi
m@02n@06mOWemOWe0_T?m@04d?7@d0:/00N<[8b8[8QX00940b@014@TA4@290=40VP01TB8J8QXS0:8
00K<S=3@dM02[0?A0]000lcAm@0Jm@03lOG@00?@0j`01<b/d8`2[004d=7AdA7e0oT3nP03nO[j00Gi
0_X2n@03mM2/009400<TA4@00T@2909400@TA4@T0T@29006A2@TA2AX0T@2J0:<0hP01VR8[:b<c0?@
00?AlM400_400m7am@03l@07dOG@lOGAm@02l@03mO7e00;A00?ad<`01=000lb/d002[004R:b8R0:<
0Z`00m3<[002R09X0T@2J004A8R8R09X00=4J6P00hP2[003d=7e00Ge00?imOD01OD00oWem@06m@05
lM7@d:`00hP2J0I400=XA4@02T@290=41R@6A00394@T00<T2d@00fQ4A002J005A6Q4R6P018P2S003
R8b800:/0X`01Zb<R:c<[0:<00F/R:b<[002S00:[8R8J8QXR8b8S0F800><R8P00X`00jb8S002[0:<
0hP00jb<[003[003S:b/00F/00F8[:b<[002S003[8b/00F80J`00003A6Q4009400=XA4@06T@00fQ4
J00VA00394A400]400<TA4@014@00bA4A006A00594@TA2@05D@3J004R=2/S0:/00R8S:b/S:b8S0R8
00B<R8R<0hP00hc@[003S003[8b800F<00>8S8`00Z`00hR<R005J0E400J8[=3ad=49m@03nOGe00;@
00GamOGAl@02d003c=3@00C@00?amOD01OD3n@?j0oD00m7ad002[008S:b/[<camO46m@03nOGe00;e
00?jnOT00_T00oGim@02n@Ce00?imOD04?D00o7ed@02d008[8R<R:b<R6P2A0<T00E494A49004A0AX
00=4S6P00XP3S003d<c@00?@00?adO400]000lc@m@05m@03nOGe00Ge00?amOD01oD00o7em@02m@0<
dM3@c=3<R:b<c:b<0/`00m3Al@0Am@?i00GjnOWjn@07nP;i00GjmOF/J003A0/T0T@00bA490029003
A2A4009400QXR8QXR6R8J0:800N<[8cAd=7e00;A0o401M7amM7a00;@0_D01o7@d=3edOD00]400o7A
d@03d004lM3@d@;@00?<[8P01HP3[0:<0XP8J003R6R800=X00B8S:b/0]02l@Ge0_TAm@04d:b/[0>8
00=XA4@014@00fQ4A002J09400<TA4@014@00bA4A002A08T00A492@T1D@49003A2A400]40fP01HQ4
J6R800=X00><R8P00hP3S0B/0h`00hR/R002R0:<00F/S8b/R002S0:800B/S:b<18P00hb8R003S0>/
00><[:`01:`2S003[8b/00:/00><R:`00Z`2c006[8b/[8b/0h`00jb<S002S0680H`004M400<TA4@0
3D@390Q400<TA4@06d@012A4A4@3J004[6R8[0:<00N8[:b<[8R<00j800N<[8b8S8R<00F/0X`2[004
S:b/[0:<0XP016Q4J6P4A004J8S<d0;A00?@lOD02_D3d004lOGAd@;@00>/d=000/`2d005dOGemOT0
1?D01?Wjn_X2n@;e0]42d0F/00?@dOD02oD00oWjnP04n@03mOWe00;i00GenOGen@02m@03nOGe00ce
0o42d007[8b8[8R/R003A08T0T@290A400=XA6P00VP018aXJ6P2R003c=2<00:/00C<d:c@0o400m7<
[002d@[e00CamOGa1?D00o7em@08m@?@00G<[8R/S005[003mM3e00Ge00GjmOGil@06m@09n_Gin_Gj
nOGj00;i2OX00oG@J002J0=42B@2A00394A400=400<TA4@00T@00hb8A004J0:80Z`02]3amO7@lM3A
mO42m@06d?G@d?GA0_D01M3Ad=7a00;A00Cad?7A0]000o7@d002d005lM3@[8`00XP00haXR002R0>/
00><J6P00XP6J003R6R800:80j`01<c@lM46m@;i1_D00oWem@06m@03lM7@00:/0h`018QXR8P2J003
A6R800IX1d@01BA4A4@T00=40b@2A08T0T@390e400=XA4@00VP2A0EX00F8S8R<R003S0J/00B8S8b<
0XP3S0:80Z`2R0J<1HP01:b8R8`2[003S:b/00:/00><[8`00X`018R/S8`2[004R8aXR0F/00R8S:b8
[8b8S0:800C<S:b80H`003]400=XA4@08d@00bA4A009A00394A400m400<TA4@00T@00fQ4J004R0:<
00V8[8b<[8b/R8`02hP2S0>800F<R:b/R006S0>/0h`01jb8R8b8A6P00T@3J004R8c@d@;@00?amO40
2OD01_7AlM3ad@?@0/`00jc@[002d003dOGe00Ge0oT00o[in@03m@03lM7@00N/00?@mOD01OD2n@06
mOWemOWe0_T2m@05nOGinOD00oT00o[in@0>m@07lOGAdM3Ac002[004c8b<S09X0T@2909400<TA4@0
0d@016Q4A4@3J004S4B8S0F/00N<c<c@lM3A00;@00>/d?403_D01O7emOGA00[e00Sad=3<[8b/R0:<
0j`2d003lOGe00Ce00?imOD02?D3n@03n_Wi00Cj00?in_X01OX01OWedJaX00E400<TA4@00T@00bA4
900490A400HTA4A4J8P2J006A6QXJ8R<0j`01O7Ad?7@00;a00GAmOGel@04d@04mO7al@?A00C@dO7A
1=02d@03lM3A00?@0l`01Jb8[8R<00>80X`00hQXJ002J003A6R8009X00><R:`018P01Jc@dM3A00Oe
00Cin_Wi3_D01M7@d:b<00>80VP00hQXJ002J0:800=XA4@02D@00bA4900290942R@6A003J4A400U4
0fP00dAXA002R09X00b/R8b<R:b8S:b<[<`2S0:800><R8P00hP2S004[8b8S0:80Z`018R<S8`7R005
S:b<S:`00/`3[004R:b<R0:/00N<[8b8[8R/00;<1:`3R007[8R8R:b8S002[06<0HP0069400@TA2@T
0d@00bA4A008A00394A400e416P4R0:<00J/S8b8[=02[004R8b<[0><00B/S8b<0Z`3R007[8b/[8R<
[002S003[8b<00:<00J8S8b<R8`2R0=40fP01DAX[=3<00;@00?AmOD02oD01o7AdM7@c=000j`01M2/
d<cA00Se0oT01?[inOT3m@03d:b/00>/00?<d=001_D4n@;e0_T00o[em@03m@05nOGinOD01?TAm@03
lM7A00?@18`2R004J4AX90940R@8A0MX00>8S8`00Z`03Lb/d<b/dLc@dM2/d=407OD2d@03[<b/00:<
00>8S8P00j`2d17e0oT00o[in@05nP;i2?X01?F/[8P5A0HT0T@390A400<TA2@00T@2J0940XP01VR8
R8R<[0;@00GadM3Al@02d@Ca0m42l@;A00C@dM3@1=43d004lM7ad0;A0m000jc<[002[003R8b800:8
00B<R4AX0d@00fR8J002J005S?7@[8`00Z`2c003dO7e00We0_T2m@03nOGe00We0m000jb<J006J094
00AXR6QX3D@390A41R@4A08T3d@00fQ4A002J004R6QXJ0>80X`018R<R8`5[0:<0XP01Xb8R8b8S0>8
00><R8`018P00jaXJ005R0><0j`00hc<[002[006R:b/R:c<0Z`3S0:/00F<[=2/c002[0:800>/R8`0
18P00hb8R001J000;D@00fQ4A00]A00394A400U400<TA4@024@00bA4A005A00394A400M400=XR8P0
0VP01HR<R8R<00:800><[:`00hP2S0:80X`00jb<[003S003[8b/00:<1Z`4S003R8b/00:<00Z8[8R<
J4AXR6Q40VP01/c@dM3Al@ce1?401=7@c<`3[003d<c@00;@00?AmOD01OD6n@?e00?ad<`00j`018b/
c=08m@;i0oD3n@Ce0oT00oGin@03n@oe00?amOD00_43d005S8R8[8P00VP2A00494A490I400=XA6P0
1VP01XR<[8R<[0;@00C<[:cA0m001=7@d=4Mm@05dM3@d<`00X`6[0;@00?AlOD01_D00oWem@05m@;i
0_X00oWjnP0=nP06nOGed8QX1T@59003A2@T00=40VP00d@T9002A00694A4J8S<0XP2S003R8b/00;A
0m000o7Ad003d0;A00?<d=000_42d@;@00CAd=7a1=02d@03d?7A00;A0]02c0>/0X`00jb8R004J0A4
0VP3A009S:b8[8b/d<cA00;e00?amOD02OD01?WemOD2n@Oe00KAd:b/S8P3J0A41FP00dAXA00@A08T
00A492@T1D@2919400=XA8P00XP2J0>800F<R8R8S002R004S:b/[0:<00F8S8R8S003R003S8R800:8
00F<R8b/S005R006J8R<R8b/0X`6[004S:b8S0>/00><[8`00X`01Jc<[:c<00:/00F8J8QXS004R003
J8QX006<001VA00394A401E400<TA4@014@00fQ4J002R09X00N8S8b<[8R<00:/00>8S8P00X`00hR<
[004[0><00>/d:`00Z`00hb/[003[006S:b<S8R<0Z`2R003[8b800=X00Q4J6QXR:c@m@;@00?AmOD0
2OD3l@06dO7Ad<c@0j`01=3<d<`2d0Ke00?imOT00_T00o[im@03m@03d<c<00F/00?@dO401?D5n@;e
0oT3m@05nOGinOD00oT00o[em@0<m@03lOGa00?e00KamM3@[<`2S003R4AX00940b@6A003J8QX00A4
0VP014B8R8`4[004d:b/d0;e00Sad=7<d?7el@?e00?imOD00_D00oWem@05m@03nOGe00;e00GamOGe
n@02m@03dJb<00B/00?@[:`00/`3d0?e00?imOD00_T9m@Cj00?in_X02oX01_Wen_Ga[0Q41b@01D@T
94AX00U400EXS8QXS003R005[=7amM000_403lcAd=3ed=7@c?7Ad?G@d@03d00<lM7adOGAlM7ed?7A
0m001Jc@[8b800:<0XP2J003R4A4009X24@2R0:<00R/d=3edO7Ad0;a00?AmOD01oD01_WenOWen@?e
00GamO7<[002S003R6Q400941fP00hQ4J00BA08T24@00bA4A009A003J4AX00MX00>8J8P00fP2R004
S8R8S0:/00B8[:c<0j`00hR<R003S0:800F<R8b8S002R004S:b<[0:800B<R8R80X`4[003S:b/00:/
00?<[:`00X`4[004S:b8S0:/00><[:`00Z`028b8R8R/R8b816P1S0009T@01FQ4A4AX03Q400<TA4@0
6D@00bA4A006A003R6R800B80h`00hR<[002R0:<00>/S8`00X`3[0:<00>/R:`00Z`00lb/S002[0B<
00R/R8QXR<b/R0:<00>8A4@00d@2J003R:ce00;a0]000m7am@0:m@03lM7a00C@00N/d<c@[<b/00;@
00?amOD01oD4n@?e0]000lb/S002c004[=3al@Ce00CjnOWi0_D3n@Oe1OTFm@04lM7@c0B/0VP<A005
S6QXR4@00fP3R0:/0X`3d005[=3edO400]000lc@d00Mm@03lM3@00:/00B<[:c@0Z`01<c@dO4Am@;i
0_X00oWjnP0=nP06nOGilM281d@4909400<TA4@00d@290A400=XA4@018P2[0:800><d=000]02d@04
lM3@d@?@00?AmOD00o402?G@d=3AmO7A0_401=7emO43d@03lM3@00;<0j`00hR/R004J09400>8J4@0
24@2R00?A8R/[<c@dM3<d?7@lM7e00;a0oD00oWem@09m@07dM2/R8b8J002A006J4A4A6Q40VP00hQX
J00?A00394A401Q416P2A09X00B<J8QX1XP028b/[:b<[<c@0j`2R0><00F/S8b<R006S0>/1HP01Hb8
S8R/00:<2:`4S0>/00B<[8b/0X`00hR/[002S005R:b8R:`00X`018QXR8P1S00000=XA4@09T@00fQ4
A00eA00394A400U400<TA4@03d@00bA4A006A0>800N<R8R<[8b/00>80X`00hR<S004[006S:c@[8b/
0h`3[005S:b8S:`018`2R003S:b/00:800><J4@01VP01HS@lOGA00;@0_400oGam@09m@?A00G@dM2/
c006[003d?7e00We0_T2m@;a0]000lb/[002S004[=3el@Ge00GimOGim@02n@03mOWe00Ce00?in_T0
0_THm@09lM7@d:b<R6R8009X0T@390=400EXA6QXA004J004R6R8J0:800B<[<c@0/`02Jc@c=3<d<c@
d@0Gm@03lOGe00?e00CadM3<0Z`00hc<d002[006c=3@lM7a4OD2nA3j00KimOGed8`2J0=40b@00d@T
900490A400@TA2@T0T@00fQ4A003J003R:b<00:800>/d=000]001]7alO7@d@;@00cAlOGelM7adM3A
lM45l@04dOGem@;a0]42d003c:b/00:/0X`2R003J4AX009400=XA4@024@2J0940VP2[004d:b/[0;@
00?<d?404OD01M7@[8b/00IX0T@00fQ4A004J0m400<TA4@014@00bA4A004A00394A400I400<TA4@0
0VP00dAXJ002A09X00B8J8QX0XP01Hb8R8b800:<1:`00hb/[002[007R8b<[8b/R002S003[8b<00:8
00>/S8`00XP2S009R8b<S:b<R8b800B/0h`01Zb8S8b/S0>/18`2[0:<00B8S:b80X`2R005S8QXJ8`0
0HP00003J4A402A400=XA4@0>D@391m400=XA6P00XP00fR<R002R0:<00B/R8b80X`2R007S:b/[8b/
R002S003[8b<00:<0j`01Hb/S:b<00>/00N<R8R<R:b<00:/00>8J6P00T@2J003R8c@00;a00KAlM3a
mO4;m@04lOGad0;<00>/c:`01J`00m3em@09m@03nO[e00?e0]03[004S:b/d0Ge1?T3m@;i00?enOT0
0oD6nAWe00?ad=000Z`01HQ4J6R8009400<TA2@00d@016Q4J6P2A006R6QXS8QX0XP01Hb/[8c@00:/
00W@mM7@c=2/c=005oD00o7em@03m@;a00?@[:`01J`4d0?A00?amOD02OD00o7em@02m@;i2OX01?Wj
n_T3nP;i0_D02?7<R8QXA2A42B@4A0<T14@2J004A6Q4R0:/0XP00lb/S002d0;A1=000m7@d002l@06
mO7adM3A0_401OGalOGa00;e00?adOD00]001=7@lL`2[0F<00AXR6QX0T@00fQ4A00:A003J4A400=4
18P018b/[8`2[008dM3@lM7amO46m@04d?Ged@;@0Z`4R006J4A4J4AX0T@00fQ4J00>A0<T00=492@0
24@012A492@?A00:J8QXR6R8J8R<R09X00>8S8`01X`00jb<[003[003S:b800>80Z`3R006S8R8S8R<
0XP01Xb8R8R<[0><00>8S:`00j`00hb/[006[004S8R8S0B/18`01FR8R6R800=X0X`1R00000=XA4@0
AD@00fQ4A002J0a400<TA4@02D@01BA4A4@T01Y400MXA4A4J8QX00:<1HP3S0:/0XP01Hb/[:b<00J8
0X`3[003c:b<00J/00F<R8b8[004S004R6QXJ0940VP01HR/d=3a00;@00?AlM403OD01?7@c=08[004
c?7en@Oe0oT4m@;@0j`018b/[<`2d@Ce00GjmOGim@02n@03mOWe00;e00?imOT00oT00oGim@0Im@;@
00F/R8R8J002A08T1D@00fR8R003J09418P00fR<S002[0;<00C@dM3@0m42d003[<c@01;e0_401?Ga
lO45m@?a00?@[:`00j`4d003dO7e01;e0oT9nP?i1?X2n@;e00C@[8QX0d@59003A2@T00<T00=492@0
0R@2A00394A400A400=XR:`00XP2[0C@00?Ad=001]001o7emOG@dO400]43l@Ke0m43d0>/00><[8`0
0X`4J0Y400<TA4@024@01VQ4J6R8S09X00>/R8P00XP00jc<c002d003lOGa00Ke0]000lb/[004R0=4
00=XA4@00VP5A00394A400Q412@00d@T9009A00394A400=400=XA4@02D@5J0V800B<R8R<0hP00hb/
[002R0>/00>8[8P00hP00fR8R006[008R8b/S8R<[8`3[006S8R<S:b<0j`2S004[8b/c0:/0XP5S003
[8QX00F80fP2R06<000gA08T3d@00fQ4J00<A08T2d@00bA4A00QA004J4AXR09X0hP01:b8[8P2S003
R8b<00:<00b/R8R8[8b/S:b<[8`2[005d8b<S:`00h`01:b<R8P2S0B80VP4A09X00C@dOGa0]001=7@
lO4:m@03lOGa00;A00?@[:`01Z`00lcem@04m@07n_GenOGjn@05m@04dM2/[0:<00B/c=7A1OD01?We
mOX2m@03nOGe00;e00Oin_GjnOGi00;e00?imOT04oD01oWemOG<S8P00fP:A004J8R<R09400AXR8b<
18P2S004d<cAc0C@00?ad=000/`00m3em@07m@03lOGe00Ge00?AmM400o401=7edO44m@;@1<`01:c@
d=42d003mM7e00Oe00?amOD02OD01?[in_T6nP;i00KenOWin_T3m@07d<b/J4AXA0029004A2@TA08T
00A492A40R@3A0<T1d@00hR<R002[004d<c@d0;A0m001=7@c=04m@03dO7A00GA0_400oGam@02m@C@
0/`00jb<S002S005R8b8A6P00T@00fQ4A00@A008J4A4J4AXR4@2J0J800><c<`00]000m7@m@03m@05
lM3@[<`00XP00fR8R002J0A40VP00d@TA002A00394A400Q40b@01T@TA2A4J0I40b@5A0AX0d@2J003
A6Q4009X1HP00fR8R005R003J8R800:/0XP00jb8S002[0:<00B8[:aX0hP00jc<c003[003R8b<00:/
0XP01Jb8R:b<00>/00B8[:b<0Z`018R<[8`4[0:800J/S:aXR:`3R0:<00=XR6P00VP3R0004T@00fQ4
A00dA09X2d@2915400<TA4@00T@01BA4A4@T01M416P3R0><00B/S8b<0XP3S0>800F/S:b/S002[006
S:c@[8b/18`00jb<[004S003R:b8009X14@2J003S=3a00;e00Kad=3@dO4<m@05dM2/d8P01J`2c003
d=7e00Ge00KimOGimOT4m@;@0Z`2S005[8b/d?401oD01_WenOWen@;e00Cin_[j0oTLm@04dM2<R09X
1D@290A400AXR8QX0T@00fR8R002R005J8R/[<`01]000m7@d@03d0;<4OD01O7edO7A00;a00?AlOD0
0oD01?7@d<`6[004d=7AlACe0_T7nP04nO[im@Ki1?D00o7@[002J0M43R@7A003J8R800:/0]000m7a
d@02d@;@00?Ad=000m401O7emO7A00;a00GedM7ad@05m@04lM7@c0;@00B/S:b80h`2J0=400=XA4@0
1D@01RA4A2A490I400=XA4@014@3J004R6R8R0:<00N8S:b/d?7A00?e00Gad<c@[003R004S8R<J1E4
0b@00d@TA004A00494A4J0940R@6A0EX0d@018Q4J4@2J003R6R800F800><J8P01HP3[003S:b/00B/
00B8[8R/0X`2[0:<0j`01Xb/[8b/S0:800>/S:`00Z`018b/S8`3[003S:b/00:/00>8[<`00j`00hb/
[005S0>800>/J6P00fP1R05X0HP003I400<TA4@044@2J2140R@5A00394A4011400EXA6QXA002J0:8
00><R8`00X`00hR<[002S0:80X`01jb<S8R/R:`00h`2[006c:b/[8R<0j`3R007S:b<[8R<J005A09X
00F8S=3Am@02l@?@00?AlOD02?D3l@04dM3<c0:/00B<[:b/0/`00m3Am@0?m@03dM3<00:/00B<[8b/
0]07m@Ki0_D01?[in_X5nA[e00?Ad:`016P4A00394A400=400=XR4@00fP00dAXR003R0:/2=002O7A
lM3ad<c@l@0=m@05nOGemO400_D01M7ad=3a00?e00?Ad=400]02[003S:b/00;@0]400o7em@04m@03
nOGe00_e0_T7nP04nO[im@Ci1oD01?7@S6P7A0<T0T@00bA490039003A2@T00<T00Q4J4AXR6R8[0;@
00?<d=400_46d003dOG@00?a00CedM7e0_42d@05lOGamM000m44d003[8b<00><0XP3A003J4AX00E4
00@TA2A40R@3A0AX00A4J4A40fP014AXJ8P2J003R8b800>80X`2[005c=3ed<`01:`2S0B80fP<A003
94A400=400@TA4A40R@3A08T0T@00fQ4A00290Y400=XA4@00T@3J0>800IXR8R8J8`3R09X1HP4S004
[8b/S0>/18`00jb<S004[005R:b<R:`018`01:b<[8`2[003S:b/00><00>8S:`00Z`01Hb/c:c<00>/
00B<[8b<0XP00fR8R002J0>80VP1S000H4@00bA4A007A08T6D@4J003R=6/00:800><R8`00X`00jb<
S003[003S8R800:<00>8S8P00h`00jb<[002c0>/00N<[:b/R:b<00B80j`3J0=40VP01XR<d=3ed@;@
00C<d=3@2_D2l@04dM3@d0>/00F<[:c<[002d0Ge00CjmOGi1?D01OWemOG@00>/00B8[:b/0]000oGA
m@03m@;i00GjnOWim@02n@03mOWj00?j00Gin_Gen@02m@03nOGe01Ce00KAd8b8J8P2A004J4A4R0E4
0VP018b8R4@5S008d=7AmO7@lM03m@06lOGamM3<0]001O7emOGi013e00Gad=3@d@02l@;A0]001Jb<
R8b/00?@00?AlO405OD2n@Kj2?T7m@03lM6/00:80VP4A0<T00=492@00d@012A4A4@39006A6QXJ4AX
0XP2[0?@00?amOD00]44d004lOGAm@;A0o43m@03dOGe00Ge00CAlM7A0]000jb<[002R003J8QX00A4
00=XA4@00T@01RA4A2A490=400>8A4@00VP00dAXA003A0=X0T@4J0F800B<R8b<1:`01Hb8[8b800:<
00B8J8b<0hP00fQ4A002A0=X1T@290940R@8A00394A400m400>8A4@00T@00hQXJ003R003J8QX00:8
00F/R8R8J003R005[8R8R:`00X`5[0:<0Z`01XR<S8R<R0:/0h`00hR<[002[003S8R/00B<2J`00hb/
S006[0:<00J/S8b/R6P2S0:800B<R8R80VP1S0001D@2J0=400=XA4@06D@00fQ4A00SA003J4A401A4
00=XA4@04d@2J003A6Q400M40fP00dB8S002R003J8b/00:<00F/R8b8c002R003S8R800><0Z`3S006
R8b/[=2/0/`3[003S8R<00:<0hP01FR8R4AX009400=XA4@00VP01:c@dM42l@;<00>/c=002OD00o7e
d@02d003c=3<00J/0m001m7emOGimOX00_D01?WenOX2n@05mO7Ac=001J`2d006dO7emOWe0_T01OGi
mOGj00;e00Cin_[j1OT2m@04nOGen@ce00?imOD01oD01?6/A4@2J005A2A4A6P01D@3J0:800=X[:`0
0j`02=3AlO7ed=7@0_43m@03lM7@00;@00?adOD02oD00oWem@05m@05lM3@d?401M000lb/[002[005
c=3@d=400_4Em@03nO[j00Kj00?enOT00_X00oGin@07m@03lM2/00:<00=XA4@00T@39003A2A4008T
1D@39008A6Q4A6Q4R6P2[0;<00K@lOGAlM43d009dOGamO7edM3a00?e00CadO7A1OD2d@03lM3a00;@
00K<[:b8S8P2J003A6Q400A40R@3A00394A400=400=XA4@01d@2J0A41FP00hb8J003J007S8R8[8QX
R004J0:80j`2R0=X00=4J6P00VP4A00394A400DT1T@00bA4A00290U40b@01D@TA4AX009416P02hQX
J8QXS8R/S8QX00B80VP018R<[8`3[003S:b/00:/00j<[8b<[8b/R8c<S:b<R0:/00>8S8P00hP2S005
R8b<S:`00XP4[003S:b<00><0j`01=2/[:`2S003[6QX00J80VP1R05X0HP002I400=XA4@0<D@00bA4
900:A0<T00=494@00T@00bA4A00BA0AX00I4J6QXR6P2R0:<00J8S8b8[8P3S003[8R/00:<00F8S:b8
S009[0:<0XP00jb8J002R0:<00>8J6P01D@00fR8[002d005mM7AdM000Z`00m3am@08m@?a00C@dM3@
1:`2S003c:c@00Ce00?in_T01?D3n@?e00G@c:b/S003[0;@00?Ad?400oD00oWenP05m@?i00?jnOX0
2?TIm@03[6Q400e41FP4[003c=7e00?e00?amM401oD2d003dOGe00;e00?imOD04?D5d005[=3@d<`0
1j`2dAOe0_T8nPCi2oD2d0:/00>8J4@00T@29003A2@T00<T14@00bA4A003A00394AX00=X0Z`01=3<
d=42m@03lM7A00;@00?amOD00_D00o7Am@04m@Ca1oD2d@?@00>/R:`00hP2J003R6R800A40b@7A003
J4AX00E400=XA6P00VP3A09X0XP6J0:800><R8P01HP2J003R6R/00:/00C@[:b<18P4J0E400<TA4@0
0b@6A00394AX008T00=494@01D@390Q400EXR8QXA002J0V800>/R8P00XP2S0:800><R8`01j`01hb/
S8R<[8`00j`3S003[8b800:800J/R8R8S8P3[003R:b/00R/18`01jb<[:b8[8`00XP018b8R6P2S0:8
0VP1R000ET@00bA4A003A00394A400Q40R@2A0<T00=494@04D@3J003A6QX00EX0XP4S0>80X`2R005
[8b<S:`00h`01Jb8[:c<00>/00?<[:`00Z`01HaXJ8R<00J800=XA4@014@02fR8[=3amM7adM2/00;@
00?amOD01_D2l@;A0m000jc<[005[0;<00CamOGe0_X00oWem@09m@;@00[<[:b<[=3AmM7a0oD3n@Ge
00?imOT01?T2m@Ki5oD00o7<R008A00394A400A400=XR8P00X`2[0;@00?amOD01?D00m7am@05m@03
d=7@01Ke00?ad=001=001<c@c<`2[003S:b800>/00?@dOD04oD01O7enOGi00Kj1?T9m@0:nOGelM7<
d:b8J0940b@014@T94@390E40b@3A008J8b<S:c<[<`3l@03dM3@00;@00?amO400_D00o7el@02m@06
lOGadOGA1OD00o7ed@02d@04d<c@[0:<0XP016R8R8P3J0A40R@3A00394A400940fP02DAXJ6R8J4B8
A005J09416P9R003J4AX00AX00B<[:b/0]000jb8S002R09X00>8A4@02d@00fQ4A004A0<T14@290a4
1VP2R004J8R8R0:<1XP01Hb/R8b800:<00B/S:c<1Z`018b8S8`2R0>/0X`00jb<[003R005[8b/S8P0
0Z`2S0:/00B<[:c<0j`00m2/[002[005R8b<[8P00X`01:b<S8`2R0:<0XP1J0680HP00003J4A405m4
00@TA2@T0d@00bA49002909400<TA4@024@00bA49004A003J4AX00AX00N8J6QXS8R/00:800B<R8R/
0X`018R/R8P2S008R8b8R8b/R8`9[003S8R800J80VP6A005J8R8[=000_401M7ad=3<00;@0_47m@03
lOGa00C@00?<[8`00Z`2S0:/0]02l@03mOWe00_e00?ac:`00j`00hR/[002d0?a0_D5n@04mOWem@Gi
00OenOGin_Wj00?i5_D01?7@S8`>A09X00>8J8`00Z`00lcAm@05m@04lOGel@Ge0]400m3Am@0Cm@;a
1]002<c@[8R<R8b81:`00m3am@0Fm@03n_Wj00Cj1OT>m@;A0]0018a4J4@39003A2@T00@T0d@69094
0hP01Jc<[=3a00;e00?Ad?400]02l@Ce00?amO400_401=7@dO44m@06lOGemM7a0]400lb/[004R0=X
00=4J4@01D@290i416P01HaXJ6R800EX0XP2J0B800><R:`00XP3J0>800AXR8b80j`2S0:816P<A003
J4AX009400<TA4@01D@290e40fP00dAXR002R003J8R800N800MXR8R<R8b800:<00>/S:`01:`02<b<
[8b8S:b81:`2S0:800><R8P00XP3S0:/0h`5[009d8R<[<b/S<b/00:<1J`00hb8[003S0B80VP1R000
5T@00fQ4A01AA00394A401M400=XA6P01fP01Xb8R8QXS0>800>/R8`00XP01Zb<S8b8S0:800F<R:b/
d@03[004c:b<R09X0XP3J003R6QX00I400QXA8b/d=7el@;e00G@c=7@l@04m@03dOGa00;e00?AmOD0
0]03c003S:b<00F/0]03m@03n_Ge00We00?Ad<`00j`3S004[=3@l@;e00CimOGj0_D00oWem@02m@0?
nO[en_WenOGin_WjnOGi00Oe00CjmOGi1OD02_[emOGamLb/R6P5A003J4AX00E400AXA8b80X`00jcA
d@07m@03dOGe00?e00?amM400]000o7em@0:m@03nOGe00;e00GimOGel@02d007c=3@[<cA[002S009
R8b<[8R<[=3A00Ge00?imOD03_D00oWjnP06nPGi0oD00oWem@08m@04lLc@[09X14@29003A2@T00E4
1R@2A003J8R<00:/00G<d?7el@06d@;a0_D2l@;A00?elM000]400o7em@06m@07lOGAlLb/S002R004
J8QXR0Y40R@00d@TA009A0=X18P016R8J6P3A0>800EXR8R<R002[003d8aX00EX00=4J6P00XP018b8
[:`3S0:81FP:A003J4A4015416P00dAXA002A0AX0XP01FR8J8R<00J800=4S8P018P01Jb<S:b<00:/
00B8[:b<0XP01Hb8R:b800:/00>8S8`00X`2[0>800F/R:b<R002[0><0j`00lb8[002[007S<b/[8b8
[002S0B/00><R8`00XP016R8R6P2R000IT@00bA4A009A00394A401940fP2R003S8R800J80X`00jb8
S002R0:<0Z`3S0:800V<[<c<d:c<[8`00hP2S005R6QXJ4@00VP00dAXA002A006J4AXR:c@0]42m@;A
0m02l@Oe00CamO7a1=03[003S:b/00:/00K<d=7amOT7m@03nOGe00?e0]002/b/[8b/S:c<dO44m@03
nOGi00;e00?imOD00oT2m@Ki00CjnOWi1?D00oWem@02m@04nOGen@Ge00SimOGedM2/S0=400<TA4@0
0d@00bA49003A09X00J8S8c<d=4?m@?@5OD2l@K@00?<d:`00X`01HR/S:b800>/00?@lOD05OD7nP03
nOGe01;e0]000jb8J005A0<T0T@69003A2@T008T00=4J8P01:`00m3am@02l@GA00?amOD00oD2d@;e
00GadM7ad@09m@;A00C@c:b/0hP00fR8J002J1M400=XA6P00hP3J003A6QX00>800AX[8R/0h`00jb8
J004J09400=XR8P018P2S003R8b800:80VP018R<J6P2R003J4A400]40R@;A003J4A400I416P2R003
J8R800:800=XR8P018P3J0:800>/S8`00X`00hR/R003[004R8b8S0N/0X`00jb<S002S004R8b/[0:<
0j`2S0B/0/`2[004d:b/[0:<00>/S:`00j`018b/R8`2J004[8R8J0:8000VA00394A400a400<TA4@0
2T@00bA4A012A003R6QX00:800EXS8QXR002S0>800EXS8b/R005S0>/00N<[:b/S=2/00;<0Z`3R0><
2FP4A004S<c@d@;a0_D02O7Ad<c@dO7el@07m@05lOGadM000l`4[006c:c<d=7a3_D01?7@c:`2S0B/
0]03m@;i1OD00oWem@04n@03mOWi00Gi00GenOWen@02m@03nOGe00;e00CimOGi1OD02?WemOGA[8QX
0T@290E400<TA4@01D@01VR/[=3Al@ge00Gad=2/d00>m@03nOGe00Ce0_43d005c=3@d<`00X`01:b<
[8P4[003S=3a01Oe00?in_X00_X00oWem@06m@03nOGe00;e00?AlOD01_D01M7@S8QX00=400<TA2@0
0T@590941B@2A003J8b<00:/0]02m@04lM7Ad0?A1?D01?7elO42d0;a00?AlOD00oD01O7elO7e00;A
0l`01:c<R8P3J09400=XA4@034@00bA4J003A0IX0XP00fR8R002J0B800AXS8R/1HP02FR8J6Q4J8R<
[002J004R6QXR09X00>8J6P00XP00hb8R002R0=X0T@016Q4A4@39003A2A4009400@TA2@T1D@3J0M4
1fP00hQXR002R004J8QXJ0:800F<R8R8J003R003J8b<00:81:`01XR<S<b/S0F/00?<S8`00Z`01HR/
S8b800><0XP018b8R8P4[006c:c@d:b<1:`018b/[8`2R007S:b<R6R8[002R06<0HP1S000P4@00fQ4
A003A0IX0XP01:b8R8`2R005J8R<S:`01X`3[007S8R/[8b/c005[003R8b<00:80VP01HQ4J6Q400AX
0T@016R<c=02d@Ce00K@[=3@dO45m@03lOGe00;a00?elM400]02c004d:b/S0>/0m0?m@03dLb/00:/
00C<[:c<0]000o7em@02n@03mOWe00?e2?T00oGjn@05n@03mOWe00?e0_T00oGin@07m@03nOGi00;e
00?ad8P00T@00bA4A002A08T0d@012A4A4@2J006R8b/d?Ga1OD00o7em@05m@05dO7Ad=400_4@m@05
nOGemO400]002:c<[:c<[8R<0Z`00hR/R002[003R:c@01Ce00Kad?GenOX2n@06mO7adOGa1?D00oWe
m@02m@04dOGel@?e0_401_GAd8b8J0I400@TA2@T0d@39003A2@T00=400EXS:b/d002m@03lOGa00Ca
1_D00o7em@03l@03dOGe00;e00CamO7a0oD01?7Ad<`2[003S8R8009X00=4J6P00d@290Y40R@7A004
J4A4J0:816P01XQXR6R8S0J800><R6P016P2R003[8QX00AX00A4J4A40VP2S0:/00>8J6P00fP9A08T
00=492@02D@2J0Y40VP00hQXR005J0F800R<R8R8J8QXA0:80X`00hR/S002[005S8R<c8`02J`6S004
[8b<S0:80h`4[003c:c<00J/00K<S8b/S:`2R006[8R<R4B80X`2R0:/000]A003J4A4009400<TA4@0
:d@290U400<TA4@05d@016Q4J6P2A003J8R/00><0XP2J0>81X`00jb<c003R0J/00C<[:b/0X`00hQX
J002J004R6QXA09X00B8A6R80VP2[003d=7e00Ce0m000lc@d@0:m@;a0]42d0;<00F/c:b/c003[003
d?Ge00ge0]02[0;<0Z`00hb/l@03m@03nOGe00Ce0_T01?GinOD5n@04n_Win@_e1?T01?GinOD4n@?e
00C@S8QX3T@01VR<S8b/d@oe00OAlM7@dOGa013e00?imOD00_42d0:/00J8S:b/R6P3R005S8R/[8`0
0Z`00m7em@02m@03nOGe00ce0]401?7enOT2m@06lM3alOGA1?D00oWem@02m@03lOGe00Oe0_401Lb/
S4B800=X1d@00bA4900390A400AXR:b/0]001?GAlM02m@;A00?elOD01_D01]3elO7ed@;e0_44m@;a
00GAd=2/S002R09X0T@00fQ4A002A08T2d@00bA4A004A09X00=4J6P00fP2A003J8R800>800>/R6P0
0hP3J003R6R800=X0hP00fQ4J005A09X00F8[:b/d002S0:80fP9A08T00=494@01T@2J0]416P2R09X
0hP00fR8R002R006S8R<S8R<0XP2[005R8b<[8`01j`00lb/c004[003S:b<00F<0Z`3R0:<00>8[:`0
0X`2[003S:b<00B/00><[:`01:`2S004R8b<S0:800F/R6QXR001S000:4@00fQ4A003A003J4A401I4
00=XA4@07D@390U400<TA4@02D@00fQ4A005A09X00A4J6QX0hP2S0:800=XR8P00h`2R0B<00>/R8P0
0XP00hb/[003[003S:c<00>800AXR6QX0X`3J00:A8Q4A6R8J8R/d0;A00_amOGad<c@c=3Al@09m@?a
00?Ad=000l`7[003c=7e00ge0]400lb/[005[006d?GenOGi0oD01OWenOWe00;i00CenOWi0oX3n@Ge
00?imOT00_D00oWen@02n@04n_Wjn@;j0_T01?GilM02R09X1T@29008A2@TJ4AXR8`2[003dOGa00Ke
00?amOD01OD01=7@d=02d@Se00GAmOGen@02m@04nOGem@;a00C@c<b/0X`00jb8R003J0:800F<R8R/
S002d0?e00?imOT03?D2l@;@1?D2d@Ce00?AmOD01?D00o[em@04m@03dOGe00;e00KamOF/S8P2J094
00=XA4@00T@29004A2A4A0@T0d@2J004d<cAd@;e00OamOGAmM7a00Ge00GilO7ad002m@03lOGe00?e
00?AmOD00_D00m7ad003[003R6QX009400=XA4@01d@00bA49002A00394A4008T2D@016R8R6P4A003
J8R<009X00B<R8R81VP018QXR8P3J0:80VP4A0=X00>8[:`00X`00hR<R005J0A400=XA4@00T@01BA4
94AX011400=XA6P01FP4R09X0XP018b8R8P2S003R:b<00:/0X`00jb<[004[008c:b/[<b/c:`2c003
[8b/00><0XP2S005R:b<[8P00h`00jb8R002[005S:b<[8`00j`00hb/[003[003S:b800:<00N8J6R<
R4AX00:8000XA09X00A4J4AX=d@00bA4A006A00594A4A2@04T@00fQ4J002J0F800><R8`01HP3S007
R8b/R:b<[005R0B/0X`01:b<S8`3R09X18P00dAXR002J007A6QXR:c@l@02d@03lOGA00K@00?amOD0
2_D01]7@c<c@c0>/00><[8`00]000o7em@0;m@05lM7Ad<`01:`00lc@l@06m@03nOGe00Ke00?imOT0
2?T4m@;i0_D01_WenOGinPCi0_X2n@?e00?@[8P01d@39004A2A4A09X00F8J8b/d006m@03nOGe00Ke
00OAlM3@dO7A00Oe00?amOD01_D01oWemOGad<`01Z`01Xb8[8QXS0B80Z`5m@03nOGe00ce00Cad=7a
5oD00o7Am@03m@07lM6/[8b8J007A0@T0d@4909400=XS=000]001M7elOGA00?a2_D01=7emO47m@07
lOGelM7@c002[0:<00>8J4@00T@00fQ4A005A08T1T@390=400<TA4@014@3J004A6QXA0:800><R8`0
1XP3J003R6QX00:80VP2R004J8R8A0MX00>8S<`00Z`018b8J8P3J003A6Q400U400<TA4@00T@00bA4
A008A003J4AX00=X00>8J6P00hP00hb8S002R0:<00B8S:b<0XP00jb8S003[0:<1Z`00hb/[002c004
d:b/c0>/0XP2S003R8b800:/00>8S8P00X`01:b<S8P2[004R8b8R0F/00><[:`01J`3S0B800=XR8P0
0FP002]40fPMA003J4A400]400=XA4@07D@00fQ4A007A0=X00M4J4AXS8R<00:800F/R8R8J004R0><
0Z`3R004[8R8J0B80j`00hb8R002S0:800B<R8R<0hP00fQ4R003R006J8S<c=3A0]000m7al@05d003
c=3e00ce00?Ac:`00/`01Jc<c:b<00:/00?@mOD01?D00oWem@02m@04nOGem@;@1j`01M3emOGi00Ce
00CimOGi1OD5n@;j00?imOD01?D00oWen@02m@04nOGin@;j00KimO[jnOX2m@03nOGA00:/00>8J4@0
34@2R005J:b/d=400oD01?WenOT7m@;a00G@lM7el@05m@05d=7@lM401OD01?WemOD2l@;@1:`2R004
S8R<R0:<00>8J8`00X`00m3am@0Bm@03lM7@00?e00?imOD01?D00o7em@0;m@03lOGa00;e00?Ad?D0
0Z`01HR<R6R800E41B@2A0@T0T@018R/d:`2d003dO7e00;a2oD2l@Se00?adO400oD00o7@[002[006
R6R8R6R80VP4A0DT1D@290m40fP00dAXJ004R09X00B8J6QX0XP;J0:800=XR6P00VP024AXS8b/R:b<
0XP00hb8J002J003A6Q400Q400<TA4@03D@01FQ4J4AX00:80VP018b8R6P3R0:/00>8S:`00X`018R<
S8`3[00:R8b8S:c<[8b/S0:/0/`2S0:/00?<[8`00h`00hR<[003[0><0Z`2S0:/00F8S:b/S003[004
S:b/S0J/00B<c:b/0hP018b8[8P1J0001T@00fQ4A00RA0=X5d@00bA4A00XA003J4A401141VP018QX
J6P6R09X00J/S8b<R8`2[0:<0XP2S0:800>/S8`00XP00hb8R002S003R6QX00R80fP02hQXR:c<d=7a
d=7@00;A0]000lc@d002d003lOGe00[e00?ad=000/`00m3<c004[003c?7e00_e00?amM000Z`3S0:/
00?<d?D01oD00oWen@05m@03nOGi00?i00CjnOWi1oD01OWenOWe00;i0oX01OGinOWj00Ce00Sa[8b8
J8Q4J0U40fP018R/[=06m@;i2?D01_7AlO7el@Ce00Gad:c<d002[003d?7e00Ge00GadM3@c002[004
S8R<R0:<00=XR8P018P00hc<d005m@03nOGe00Ge00?amOD01?D00m3<d@02m@03nOGe00?e0_4?m@03
dOGe00?@1J`2R003A2A400A40b@3A00394A4009400AX[=2/0]000o7el@02m@03lOGe00We00GamOGe
l@03m@?a00CelO7e0]03[005S:b8S6P00hP00fQ4A00CA00394A400U400=XA6P018P016R8R8P7J003
A6QX00YX0d@016R8J8P2J005R:b/R8`00XP00fQ4A005A00594A4A2@00T@390=400=XA4@014@00fQ4
A002J004R6R8J0N80X`00jb<R004S0B80X`2[004S:b/d0N/00>8[8`00j`2R0><0Z`2S0:/0X`01:b8
S8`7[007R:b/[8b/S005[003S:b/00B/00B8[8b/0X`000I400=XA4@08d@00fQ4A007A00594A4A2@0
B4@01FQ4R6R8009X00B8J6R80X`2R09X00>8S8`00h`018R<[:`2S0:800YXR8R<[8b/S8R/0h`01hQX
R6R8J8`00XP2J003A6QX00=X00V<[<c@dM3Ad=400]000lb/d003d003lOGe00Oe00?amM400]001Lb/
d<c@00>/00F<[<c@d@03m@03nOGe00Ke00?adM000/`3[003c=3A00Oe00CjmOWi1?D00oWem@08n@Se
1?T00oGinP03nP;i00?jnOT00oD01_7@S:a4J0E400=XA4@00d@2J009R6R<[=3elOGi00Ce00CimOGi
0oD01=7edO46m@03lM7@00:/00J8[8b8c=02m@03n_Ge00;e1=02S003R:b/00:80VP018b8R:`2R003
S=3A00?e00?imOD00_D00o7em@02m@03dOGe00;e00Cad:c<0oD01?WemOT9m@05lOGemOT00oD01M7e
lM3e00;@00R/S:c@[8b8J1140VP4[005dOGAmM401OD00o7em@02m@05dOGelOD00_401?GamOD2d@07
mO7edLcad003[003S8R800>80VP2A09X64@00fQ4A003A003J4AX009X1HP2J003R6QX00=X00I4J6QX
A6P3R09X00=4J4@00d@01FQ4J4AX00:800EXR:b/S002R003J4B800=400<TA4@00d@00bA4A004A003
J4A400941FP00hQXJ002J007R8b<R6R8S002R0:/0XP4[004S8R/S0>/0X`2[003S:b/00>/00?<S8`0
0X`3[004R8b/R0F/00F<[8R<R002S003R:b/00Z<2J`01HR/[8b/00><0J`1S06/000`A00394A400M4
00<TA2@0;d@00bA4A00@A00394A400=40VP00hQXJ003J003R8b800:80VP01HR<R:b<00>800><R8P0
0hP026R8R8R<R:b<0hP018b8R6P2R004S6R<R09X0T@01hQXJ4AXS:`00]001o7AdM3Ad=401]000m7e
m@07m@;a00?Ad=001M05[0;<00?amOD02oD01?7@c<`3[003c=3A00We00?imOT01_D4n@03n_Wi00[e
00?in_T01?T3nP;i00?jnOD00_D01=2/S:`6A003J4A400I400IXR:b/d?4>m@;a1?D01?7emOD2d@;@
1:`018b/[=06m@04lM3@d0F/00><[8P00X`00hQXR003R003[=7e01;e00C@[:ca0oD01?WjnOT9m@03
lOGe00Ge00?adJ`00m02c006[<c@S8QX1D@00bA4A008A09X00J8[:b/d?D2l@;e00?amOD01oD4l@03
mO7a00Ce00CAlOGA1=04[004R6R8R09X0d@2J0E400<TA4@04T@00fQ4A002A0]X0XP4J005A6QXJ4@0
0VP2R09X24@00fQ4A003J007R8b/[8b8J002A08T00=492@014@290Y400IXA4A4J4@3J0:800B<R8QX
0hP00jb<[002S00:R8b<S:b<R:b<[0:80X`00jb<[002[005c:c@[8`00j`00lb<[002S005R:b<[8`0
0Z`2R009S8R8S:b<[8b/00><00B/S8b<1:`3S004c:b/R0:/00B8[8b/0X`1[068000gA00394A40254
00=XA4@04D@00bA4A00CA0=X00B8J6QX1hP01Jb<R8b/00:<0hP3S003R8b800:800=XR8P00X`01jb8
S8QXR6P00hP00hb/J007A006R6R8[=3A0]000m7@d@02d@;@00G<d<b/d002l@Ke00CadOGA0]000lc@
d002d0J/00?@lOD03OD01=2/R8`3[003c?Ge00Ke00CimOGi1?D01_WenO[im@Ci00GenOWen@02m@04
nOGin@;j00Gin_[inP03n@;j00WimOGed8b8S6P00T@00fQ4A009A0:800B<[<ca1OD00oWen@06m@05
lOGemO400]45m@0;nOG@mM3a[<b8[=001oD01=7@d=02[0;<0j`00hQXJ003R003S<cA01?e00C@[:cA
0_D00oWjnP02nP03nOGe00Ce00?adO402?D00m7@d@03d004dM3@d0B814@00bA4A009A0:800><[:`0
0]000m7al@0;m@06lOGAmM7a1OD00m7al@03d@;@00?<S:`00X`3R09X00E4J6R<J00?A00394A400M4
0VP2A0AX00>8J8P018P016R8R8P4J005A6QXA6P00XP2J0Q400=XA4@01D@00fR8[002[005R6Q4A2@0
0d@00bA4A002A00394A400I400EXA4AXA004J003R6R800:80X`3R004J8R<R0:/00><R8P00XP01Hb8
R8b/00:<00B8[8b/0X`2[0G<1J`3S0B/00B<[:b80X`018R<S8`2R0:/00><[8`01H`7[006S:b/S:b8
0X`00jb<[002[000:d@00bA4A007A00394A403]400<TA4@03T@01VQ4A6R<A09X1HP4S003R8b/00:<
0hP01Zb<S8b8J0:800Z/R8R8[8R<R8b816P2R003[6QX00I400>8J8P00Z`00m3Ad002d0;A0m001/c@
c<c@l@Se00CamM7A1M02c007[8b<[<c@l@0;m@04lOG@d0>/00B8[:cA3_D01?WemOD6n@?e0_T7m@03
nO[i00Ki00?jnOT00oT2m@04d8b8J0i400EXR8b/d009m@;i1oD01M7ed?Ga00?e00oin_[ed=7amO7@
c8b/d?401OD2d@0:d=7<d:c@[8b/S0:800N/S8b<[=3a01;e00CAd<ca0_D00oWjnP03nP03nOGe00Ce
0_43m@03lOGe00;e1]000m7@c002c0:800=XA4@02T@2J004A6QXR0>/00G@dM3ad@0:m@?a00C@mO7A
1OD2l@;A1=04[004S8R<R0EX0XP00fQ4A003A00594@TA2@014@00bA4A003A00494A4A09X0d@4J003
R6R800:800B<R6R80fP3A0IX2d@2J0A40VP3R0:<00>8J6P00T@290M400<TA4@014@00fQ4J002A0:8
0fP2R0AX00V/J8R<R:b<[8P00X`00jb<[006[0:<0j`2S0:/00C@c=2/0/`00jc<[002[003R8b<00>/
00J<[:b/S8P5S007R:b<[8b/S002[006S:b<[8b80X`2[00;R8b/[8R<R:b8[8`00FP000Q400=XA4@0
7d@00bA4A01GA0AX00><A6P00hP00fR8R004S0>/0X`00hR<R002[0:<00>8S8`00Z`02HR<R8b8[8b/
R003J004R8b8S09X00=4J4@00T@4J0:/00?@dM000]02d@G@0Z`01M3adOGa00Ge00?AmM401M02c006
d:b/S<b/0]0;m@;a00C@[:b80h`00lcam@07m@05nOGimOT01OD00o[in@03n@;e1?T6m@03nO[i00?i
00KjnOWjnOD2n@?e00G@[8b<J004A00394A400M400AXS<cA2_D01?WemOT5m@05lM3ed=400_D2nP04
mM2/d0;e00OamM3@S:c@00Ke00?Ac=001=03[004J8b/S0:/00B8S:cA1oD00oWem@03m@;a00OelOGa
d:c@00;e00Kin_[in_T6m@03dOGa00;e00GamOGam@02l@03dLc@00O@00>/R8P00VP:A003J8Q40094
00IXR:b/d?D2d007lOGAmM7en@03m@06lOG@d?7A2?D02]3ad=3Ad?7<[=02S004R8b8R09X00=4J4@0
0VP3A00394A4009400<TA4@03D@016Q4A4@5J0>80X`018R<R8P:J003A6QX00M400=XA6P00VP4A006
J4AXA8R<0XP01fQ4A4@TA2@01D@290Q400=XA6P02VP00hR/R003R0F<2:`2S004[8b<S0F/00?<[:`0
0]000jc<d002[003R8b<00:/00><[8P00X`01jb<S8R/S8P01j`3S003R8b<00:<1:`3S004R:c<S0>8
0H`1R068000ZA00394A400a400<TA4@084@00bA4A00CA08T2D@00fQ4A005A0>80VP4R008S8R8R:b8
S:`3S006[8b<R8b/18P3[009R8b<[8R/S:b800=X0hP00fQ4J002A0=X00B8J6R<0Z`00lc@c002d0?A
1M001/c@d=3el@?e00GamM7ad@02c0G@00?<[:`00j`2d0_e00GAmM3@[003S003[<ce00Oe0oT7m@Ci
00?jnOD00oD3n@Ke00?imOD01OT01_[inOWen@?e00G@[8b8J008A00494A4A09X00B8S:c@5_D2d@Ce
00?A[:`00]001O7emOGa00:/00?<dOD01?D01?7@d=43d0>/00B<[:b/0hP2[003dOGe00ce00SAmOGe
lM6/d0;e0_T2nP;i3?D00o7el@03m@;@00S<d=3@c=3<d0:/0X`00fQ4J002A004J4A4J0=40VP4A006
R:c@dM3A1?49m@;a00GelO7el@04m@04lM7Ad@C@0Z`00hb/[003R003A6Q400M40R@2A00594A4A2@0
44@4J004R8b8S0:80X`3R0AX0T@6J1A400F8S8b<J002A0DT14@00bA4A003A008J4A4A6Q4J4@3J0B8
00=XR8`01HP00hb8[002S0B/00><[:`01:`2S0:/0X`2[004c:c<d0;<00C@c=2/0X`00jb8[002R0B<
00>/R8P018`2[005S:b<S:`01XP4S003R8b800:<0XP018b8J8P2J06<0002A003J4A403540R@2A003
94A404Q400=XA4@00fP6R004S8R<R0:<0Z`02HR<R8b/S8R/R003S004[8R<R0:<00B/S:b80X`01fR8
R6R<R6P00d@02FQ4J8aXS<b<c003d004dM3@d@?@00CAc:c<0m05m@CA00?@c<`01=02[0><0Z`2d003
lOGe00Oe00CAmM3@1J`01=3AmOT4m@;i00GenOGen@05m@06nOGinOGi0_D3n@0:n_GenOGimOWjm@Ki
00CjnOGi0oD01O7AS8QX00E400=XA4@00R@4A0:<0Z`00m3em@0;m@04nOGin@Ge0_42m@03lM2/00:/
00C@c?Ga0_D01?Wed:`2d003mO7e00;e00C@dM3a0m03[004S8R<S0:800><c=403OD01_7AmM3ed0:/
00G<dOGen@04nPKe00?amO400_D02?7emM3edO7@0]43d004[=3@d0B/00>8J6P01D@00fQ4A006A09X
00>8c=000]03lAGe0_401=7adM42d0>/0X`3J0A400=XA4@01D@00bA4A00EA006R6R8R8b80X`00jb<
R003R003J8Q4009X00A4J8QX2T@00fQ4A009A005J8b<S8P00d@590I40R@:A005J8R8R8`01hP00fR8
S004S0>/0X`00hR/S002R0J<00F/S8R/S003[005c:b/c=000Z`2S003R8b<00B<00B8[8b/0X`3[003
S8R<00:/0X`00hR<S005S004R8b/S0:/00><R8P00hP1J0680H`0009400=XA4@0CT@00fQ4J00EA003
J4A400A400<TA4@04d@00fR8J007R0J<0XP2S008R8b8S8R/S:`4R003S:b800><1HP00jb8S002R09X
1D@02VR<S8b/dM3Ad<`4d004[=2/[0?@0]401o7emOGadO402=03[007S<b<[<c@d@09m@0:lM7@d:b<
[8c<l@We00?imOD00oD00oWem@06n@03mOWe00Ci0_D2n@;e00?jnOT00_D2n@04n_Wjn@Ge00?ad:`0
0XP9A00394A400940h`00m3am@0Fm@04lOGed0>/00><[=000oD2nP07mM2/[=3el@02m@03lM3a00;A
00C@dM7<0Z`00hQXR003S0:/00?@mOD02oD02_7AdJced<b/d=43m@?j00?imOD03?D01]7elO7@d@?@
00O<R:b/dM3<00:/00><R6P00VP3A003J4A400M400AXA:b/0]000m7ad@0Fm@;A00?amM000]000jb8
S002S003R6QX00=40fP2A00394A4011400=XA4@00d@00fQ4A003R003S8R800:<00B/R8b<0XP9J0U4
00<TA4@00d@3J0E400B8[8b/0VP2A0@T0T@00fQ4A00;A0=X0XP01Hb8S8R<00J800F<[8b8S002[003
S8R800B800><R8P00h`01:b8S8`2R003S:b/00:/00><[:`00Z`00hb/S003[004S:b8[0><00>8S:`0
0Z`2S0J/0X`01jb8[8b/S:`00X`01jb<S6R/S:`018P000Q400=XA4@0<d@00bA4A004A00394A400U4
00EXA4A4J00LA00394A400A400=XA4@01D@01VQ4A4AXA09X18P016R8[6P2[006S:b/S8R/18P01XaX
R8b8S0:800AXS8b<0XP2S004R6QXJ0>800AXR8b/1d@2J009[8R/d=7@lM3<00;@0/`4[0;@00GAlO7A
m@02l@O@0/`00jc<[005[004c=3@l@Oe00Oad=2/dM2<00:/00G<mOGen@02m@03nOGi00Ge00KimOWe
nOD6n@;e00Cin_Wi0_D01_WenOGinPCi0_X4n@Ce00KAd<b<R6P4A08T1d@00hb/S002d@03mOWe01Ce
00SamOG@[8R/S0;@0oD2nP;e00?<[?401OD00m3Ad002d004mM3<[0:<00>8S6P00hP00jcAm@0;m@06
lOGed?Ga0]000lc@d@03m@03nO[i00;i1_D00m7el@02m@08lOGelM7ed?D2d006dM2/[8c@0j`00lb/
R002R09X2d@3J003R:b/00;@0_D00o7em@05m@03lOGe00_e0_402?GAdM3<S:b80Z`00hQXA005A003
J4A4008T5d@2J004R6QXJ0:80X`01Zb<R8b8[0:82FP8A08T0d@00fQ4J002A005J4AXA8P00h`00hQX
J002A0@T0d@290Y40fP00hR<S002S0B800EXR8R<R002S005R8b/[<`00hP016R8R8`2R003S:b<00J8
00J<[:b/S:`2R003S:b<00B<0j`2S003[8R/00B/00><[8P00Z`00hb/S004S004R:b/S0:/00><R:`0
0X`2R0:<0hP1S00014@00fQ4A00nA00394A401e400=XA4@02T@00bA4A00;A09X0d@016Q4J6P2R004
J8R8S0:800R/S8R<[8R<[0><0hP5S0>800B/R:b80h`3R0:<1HP7A005J8R/[<`00]02m@?@00O<d=3@
[<b/00;@0]42l@05mO7AlM401=04c003d:b/00J/00?@lOD01oD2d007[=3<[<b/d00>m@03nOGe00?e
0_T01O[inOWe00Gi1_D2nP?i1?X4n@Ce00G@[:b8J004A00394A400=400=XA6P00XP00m3Al@0Gm@06
lOGed:b<0Z`02lc@mOGjnO[ilJc@00Ke0m401O7Ad=3<00:<00B/R8b/0XP01:c<d?46m@03nOGe00?e
00KadO7AmM42[0;A0oD00o[in@03n@Ke00CamOGa0_D01?7elOD6d007c=3<d<b/S003[0:<00>8J6P0
0T@00fQ4A005A005J8b8R8`00m02d@03mO7a01;e0]400m3ad002d006c8b8R8b816P8A08T1d@00bA4
A003A003J4A400I40VP00hQXJ002R0:<00B/S8b80X`3R0IX00=4J4@03D@00fQ4A003A003J4A4009X
00B8S8QX0d@39003A2A400<T14@2J0=40fP3R003[8b/00>80fP018b/R:`2S006R:b/[8b/18P00jb8
S003[003S8R/00B800>/S:`01:`3S005[8R/S:`00X`00jb<S003S004[8b/[0B<00>8[:`018`016R8
S=02[003R6R<00><00B8S8R<0XP1S0000VPnA00394A403e400=XA4@01FP00dAXJ002R003J8QX00>8
00F<R8b<[002S003R8b800:800><R8P00X`00fR8R002[004S:b<[0:800IXR8b<[8`2R0I400EXA6R<
[002d0;A0_402=7@c:c@c:c@0Z`2d0;A00OamOGelM3e00G@00C<d=3<0j`3c006d<c@lOGa0_D00o7e
d@02m@03dM2/00:/00?<[=402_D00oWem@07m@Gi00?enOT00oT00oGim@04m@Oi0_X00oWen@03m@;a
00C<[8QX34@016R8[8`2d003lOGe01Ce0_403=7a[<b<c:c@dOGjn@;j00Ced:c@1?D3d@06d?7Ad?7@
0Z`4S0>800B<[:cA3OD02O7AlOGAd:c<d@03m@;i0_D00oWem@06m@04lM7Ad@Ce00?ad?401M001O7@
d<c@00>/00K<[8R8J8P2J003A6Q400=400]XA4C@[6R8S:c<d008m@03nOGe00ce0o44d004[8b<S0:8
0d@00fQ4A004A0<T1T@490a416P2R0:<00>8S8`00X`01:b8[8`4J003R6Q4011400=XR4@01T@01FR8
R8b800M40R@00d@T9007A006J4AXJ4AX28P016R8R8P2S0>/00V<R:b<R8b/S8P01H`2[005S:b/R8`0
0hP00jb<R003[00:R8b/S:b<[8b/S0:/0X`01Jb<[:b<00>/0h`3[0>800><J8P00Z`3S0:80X`00hR/
S003R06<0HP000U400=XA4@044@00bA4A00?A00394A401Q400=XA4@03D@01BA4A4@T01e400=XA4@0
0T@4J003A6QX00AX1HP3S003[8R/00:80X`2R0:<28P01Hb/[:b<00:/00B<R8R80X`00jb<R004J0=4
00QXA8R<[=3<d0?A0m000lb/c002[006c=3@d=7a1OD00m7ad@09d003c:b/00;<0m000m7em@02m@;a
0]401?Gad:`2d003[=3e00ce00?imOT01OD00oWen@07n@03mOWe00Ce0_T00o[en@02n@03n_Wi00;i
1OD00m6/R002R0A40VP2A08T0T@2J004[8b/d@[e00?amOD02oD02?7AlM3<S:c@0oD01?WemOD2d003
c=7e00Ge00?amO400m42d003[8b<00F800B<[:cA2oD02O7edM3AlM7@[002d004lOGem@Ki1_D01?7A
lO43m@04dO7@d@C@00N/d<c@c=2/00;@00?<[8`00h`5J0U40VP018R/d?43m@03lOGe013e00?adM00
0m001lb/S:b<[6P02D@00bA49007A0<T2D@00fQ4A006J004R8b<S0:/00F<[:b8S003R003J8R800AX
0T@01BA4A4@T00M40VP9A003J8QX00940b@014@T94@390M41VP3R004[8R8[0N80X`00hR/R002S0>/
0X`2[003R:b/00>/00><R8P00XP00jb8S003S0B/00B<R8R80X`00jb<[003S0:/00F<[:b/c003[0><
0XP00hb8S002R003S:b<00:<0XP01Hb/[8R/00:80H`1R068000ZA00394A400Q400<TA4@01D@00bA4
A005A00494A4J3Y400IXA4A4J4@2J003R8b800:80Z`01Hb8R:b<00:/00><[8P01H`6R003S:b<00:/
00><[8P00XP00hb/[004R003J4A400940VP018S<d=42d0CA0]02[004c=3<d0?<00?@mOD01?D2l@;A
00C@dM3A1=000lb/c002[0C@00?amO400_D00m7ed002d@06d<c<d=7a3?D01OWemO[e00;i00CenOGe
1OT00oGim@02m@04nOGim@Cj00KenO[in_T2nP03nOGe00?e00GAd8b8J006A00394A400=40XP01:b<
c?4:m@03lOGe00[e1?401]6/[<b/d@Ce00?AlOD00]07m@0=lOGAdO7@dLb/S:b8J003R006S:c@dOGA
2?D02O7emO7Ad?7ed002[004c=7am@Ci00?enOD02?D01m7emO7elOD01=04[003c=2/00R/00?@S8P0
0XP2A003J4A400940R@2A004J4B8[0;@00?elOD04_D01O7Ad=3A00;@00O<[:b8S8QX00U40R@@A003
94A400E400AXR8QX0XP00jb<S002[003S:b<00><00EXR8QXR004J11400=XA4@024@00fQ4A00490E4
0R@5A006J8QXJ8R<0hP00fR8R002R007J8QXR:b8S002[0B80h`01:b<R8P2S006[8b8S:b<0hP00haX
S003S003R:b<00:/0XP02Hb8S8b/S:b<[003S003c:b/00:/00?<d:`00Z`00hb8S002S004[8b8S0:/
0X`00hR/S002[005R:b8R:`00X`00003A6R8035400<TA2@00d@29003A2A400]400=XA4@03d@291Y4
00=XA4@02d@5J0B800MXR:b8S8R<00:/00R<[:b/S:b<[0:<00>8S8`00XP018b8[8`2R004S8R8R0B/
0X`00jaXA003A09X00J<c<c<dO44d0:/00F<[:c<d002c0;@00GadOGel@02m@03dOGA00;@00G<d=3@
m@03d0>/00O@c=7@dOGA00;e00gAmM3amO7Ad<c@dOGi00Ge00?imOD00_D01O[emO[e00;i00CenOGe
1?T01?Gin_D2n@06mOWemO[e0_X01_GjmOWjm@;j0oT5m@03d:b8009X2d@00fR/[002[0?e00?imOD0
1_D00o7em@07m@08nOGemM7edM03[00:mM7emM7amM7el@Ge00?amOD00_D01M7@lM3<00:/00[<R8QX
R8b8[=3e0]08m@0=nOGelM3AlM3A[8b/d003m@Ki1oD02?7elOGadOGa1=000lb8R002[003c:c<00:<
00AXR8c<0j`2R09X00E4J4A49006A09X00B/d?7a0_D00o7em@06m@03nOGe00Oe00SAd=3<d<b/S0:/
00B<J6QX0T@00fQ4A009A003J4A400i41FP4R003S8R800F/00><d:`018P016R8J6P=A09X2D@00fQ4
9004A0<T0d@2J0E400AXA6QX18P00hb8R003R003J8R800:800UXR8R<c:b<R8`00hP2S0:/0hP01:b<
[8P7S007R8b<R:b<[003R003[8b/00:/00>8[:`00j`01Xb8R8b/S0:/00?<[=000Z`5S003[=2/00:8
0h`00jb<[002[003S8R<00:/0X`0009400>8A4@0<d@00bA4900EA00394A4039400AXA6R80VP00hR<
S003R00=S6R8R:b<[8R/S:b<[002S003[8R<00><00>8[8`00X`00hR/R003S003[8b/00:/0XP00fQ4
A003J008R8b/c=3AlM43d0:/00B<[:c@0/`00jc@[002d003lM7e00?e0]400o7@d003d0;A00?@[:`0
0Z`02=3<c:c@dOGa0_D2l@;A00?ed=000]000m7em@0;m@04nOGin@;e0_T2m@Si1oD4n@03mOWi00Cj
0_T5m@04dM2/S09X1d@01VQ4A4AXS0:/00?@lOD03?D00o7em@0;m@04lM2/c0;@00OamM7elOGa00We
00GamM3Ad002d@03d:b/00:/00R<R8R8S:c@l@ge00?adM000_401=2/[:`2d003mOWi00;i00?en_D0
2_D2l@;e00?ad=400]001:c<[<`3[008d:b<J8R/d<`2d003[8R800=X2T@01FR8c=3a01Ke1M03[003
S8QX009X4d@290Y40hP00fQ4R006R004S:b<S0>/00><R8P00XP3J0A400=XA4@014@00bA4A002A003
J4A400U400DTA4@TA00290=400=XA4@01T@02FR8J8R/R8b8S002R003S8R800F800=XR:`01hP00hb8
[002S0:800><R:`00XP018b/S:`2S008R8b8S:b8S:`2R003[8b/00>/0h`3[003S:b<00R/00B<[:b8
0X`00hR<S002[0><0Z`01XR<S:b<[0:80VP002m400=XA4@0>4@00hQ4A00?A09X1T@01FQ4J6R800=X
00F<R8b/S003R004S:b<[0:<00J8[:b<[8`2R0:<0Z`00hb/S002S007R8b8R8b8S004[09X1D@2J007
S:b/d=7ad002d@03d<b<00B/00W@[:c@[<c@dO400oD01?7edM45d003mM3@00;@00R/d=3@[<c@d@;e
1?401=7alO42d@;a3oD00oWen@02m@;i00CenOWi0oD2n@Oe00?in_T00_T01?GinOT2nP0<nO[emOWe
lM7<[8b80T@00fQ4A003A00694A4J8R/0/`00m3am@0Km@08lJc<c=7amM4=m@Ca00C@dO7@0/`00jb<
S002[003S:b/00;@00?amOD02oD2d0;a00?@[:`00Z`01M3emOWj00Ci3OD00o7ed002d003c:c@00;@
0Z`00hb/[003S005[=3<[<`00]001:b8J8P2J0Q400EXR:c<d@0=m@03nOGe00Ce0_42d@03mM3@00:/
00><R6P00VP:A00494@TA08T0d@29003A6Q400M40VP2R09X1hP018b/[:`4S09X00>8J6P00VP3A09X
14@00bA4900;A00494A4A0<T00A494A40R@00d@TA006A00594A4A6P00XP2S005[8b/R8`018P00fR8
R002R003J8R800N800><R8P01HP8S003R8b800:81h`5[003S8R/00>/0X`01:c@[:`2S003[8b/00>/
1HP038b/S:b8S8QXR8b/S0:80FP1R05X0007A00394A400M400=XA4@0?4@00bA4A00;A00394A40214
00=XA4@00T@7J003R8b800F81j`7S008[8R<S:b8[8`2[005S:c<S:`00X`00jb8R002J0A40VP2[006
c=3@lM3A0]001Zb<[8b/d0>/00G@[=3@l@04m@04lOGal@;@00GAlM3ad003c0B/0l`01M7amOGA00;e
00KamO7amO4Am@07nOGinOGim@03n@Ce00?imOT00oT2m@06nOGjnOGj0_T00o[inP02nP;i0oD2d@;@
00F/J4A4J005A00994A4J8b/c:c<00oe00?amOD02_D2l@>/0]000oGAd@0?m@03lM3@00;A00_@c:b<
[8b/S:b<[002d003dOGe00[e1=400o6<[002[003d?7e00?i00CjnOWi2oD01O7emM7e00?@0]401M2/
[8b/00:<00N/S:b/c=3<00?@00F<R8R8J009A004J8S<d0_e00?imOD01oD3l@;@00G<[8b/R003J0Q4
1B@3A0<T2T@2J003R6QX00=X00>8S8`018P00jb<[005[0F800=XA4@024@390i400<TA4@00T@290a4
0R@3A0:800><R8`018`4R003J8R800:800QXR6R8[8b8S0>800B<R8b<18P2S003[8R<00:<00>8S8P0
1HP3[003S8R<00N/00><[:`01Z`01hb/S:b<[8`00XP00jb8S002[003S8R8009X00F/S8b<R002S0>8
0008A003J4A401e400=XA4@0FD@4J0J800F<[8b8S002R0N/00J8S8R<[8`2[005J:b/R<`00j`00hR/
S006[0=X1D@01FR/[=3<00;A00CadM3A0Z`2S0B/00><[=000]000m7ed@04m@06lOGed?G@0]401m3a
d:c<d:`00]002/c@[=3elOGadOD2l@03mM7e00_e00?imOD01OD01?[emOT4m@06nOGenOGi0_D00oWj
m@03m@0:n_WenOGin_Wjm@?j0_T00oGad@02d0:/00=XA4@00T@00bA4A004A09X00B<[:c@0oD01O7e
mOGi00?e00OAmOGAmM7a00Ke00?amOD00_D02_6/c=3<d?G@mM02m@03lOGe00Se00?AlOD00oD2d0:/
00J<[8R<c8`3[003d?Ge00;e00GjmOGel@04m@0:d?7ad:b<[<b/d@;e1OX2n@;e00GimOGel@02m@09
lOGAmO7@mM2/00C@00B<[8R<1:`01<b/d:`2d0:/0XP5J09400=XA4@00T@018R/lO4;m@;i2OD2l@;@
0Z`2S0:800=XA6P01d@290E40b@4A003J4B800940VP2R09X00=4J6P00hP2S003[8b/00N/1HP00fQ4
J00BA003J4A400I400=XA4@024@00bA4A007A09X0XP02Xb/[8b8S8R<R8`3R003J8R<00>800=XS8`0
1hP00hb8R002R0><00F/R8b/S004R003S:b/00:80Z`2S12/00_@[:c<[8b/S8R<R002S0:/00><R8P0
1HP01Jb<S:b8005X000LA003J4A402U400<TA4@024@00bA4A00_A003J8QX00N818`2R003[8b/00:/
00><[8`00X`00jb<S002S007R:b8S:b<R002[0:<0j`3S004R6R8J0A400B8S:b/0]02d@05d=7@d:`0
0h`3[007S:b/[<c@l@04m@03lOGe00;a0m401M3ad<b/00;<00?@c=000j`00m3Am@03l@04dO7el@;e
00?amOD05oD00oWen@02m@;i2OD2n@03mOWe00;i00CenOWi0oX01OGad?7<00:<00=XA4@00T@00bA4
9005A004J8b/d1?e00GamOGen@06m@04lJb/c0;@00GelM3@l@0>m@04lOGem@;@00V/S:b8[8R<[8`0
0Z`00m3am@0:m@?A00?@mJ`00Z`00lc@d@02m@03nO[j00;j00?imOD02?D2l@;e0m000m7<d002c0:/
18`00hR<[004[003d:c<00:/00B<R6QX0d@2J0A400B8[<ca2_D00oWen@03m@06nOGemO7e0_401M7@
[<b/00:80VP5A00594A4A2@02D@2J0M40VP2R003J8QX00=X0h`3[005S:b/[8P00j`6R1i40VP9A003
94A400M40VP01HR<R:b800:<00B8S8b<0hP016R8[8`4R003[8R800:<0hP3S0>80X`01HQXS8R<00>8
00AX[:b<0XP01Hb/[8b/00:<00>/S:`00Z`01Hb8[:b<00R/00><[:`00hP4[0F<0hP00hb8[002R05X
0006A003J4A401Q400<TA4@054@012A4A2@3A08T1d@00bA4A00LA08T0T@290a400=XA4@014@01VQ4
A4AXR0=X18P2S00:c:b8R6R8[8R<[0:<0j`2S0:800B<[8R80X`00jb<S006[0><00B/S6QX1D@00fR8
[002[003d=7A00?A00G@[8b8S002[003c:b/00;<0]02d@Ce00GAmO7Am@02d@06d=7@[=3<1=001:c<
[=02l@04mO7am@;a00?elOD04oD00oWem@04m@;i0_D00oWem@08m@Ci00?enOT01?T4nP;e0]000jb<
R004A003J4A4008T14@01HR/[=3a00Oe00?imOD04oD01?7@d<`2d006dM3@d=7a2OD00o7el@06m@03
d:b800:<00B/S:b/0X`00jc@d00>m@03dO7@00:/0]000o7em@02n@04n_Win@_e00OamO7@lM3A00;@
00C<d<c<0j`00hb8[003[0?@00S<[:c<d:b8J0Q40VP00hb/d@02m@03nOGe00Oe00?imOD01oD2d@05
lM2/S:`00hP016Q4A4@490E40b@4A003R6Q400I400=XA6P00VP01XQXR8R<[0><0Z`2S003R8b<00:<
00F/R:b8J002R0=X00=4J4@02T@012A4A4@3J0M40VPBA0=X0hP00fR8R002R0J<0hP2S004R6R<[0J8
00>/R8P00h`00hR<R002J0N800V<[:b/S8R<[8`00j`2S004[8b/c0N/00?<[:`00/`01jb<[8R<R8`0
0j`01Xb8S:b<R0B<00>8S8P00HP0021400<TA4@064@00bA4A003A00994A494@TA2A4008T2D@00bA4
A008A00394A400A40R@00d@TA005A003J4AX011416P00hQXR004R004[8b<S0>80X`2[007S:b<[8R<
[003S0>/00N<c:b<[8R/00><00>/S:`00hP3J0=400>8S8`00/`00o7Al@02l@03dM2/00:<0j`01Lb/
c=2/00;@0]46m@09lM7edO7Ad=7@00:/0m001/b/[<c@l@;e00CadOGa6_D00oWem@03n@ge0_T00oGi
m@03n@03n_Wi00?j00WimO7@c8R<[6P01D@032A4A4@TA6R8S:c<l@ke00?AmOD03OD7d005lLc@lM40
1oD01?7AmM45m@;a00F/R8b/R002[0:<00B/S:c@3?D2l@03dM3@00>/00C<dM7e2?T00oGim@07m@04
dO7@c0C@1J`2S004R8b/S0:/00?@[:`00j`01=2/d:`4J0A40fP018b/c=4Bm@04lOGal@?A0Z`2S0:8
00=XA4@00T@290A400<TA2@01T@00hQXA008A09X0hP01Hb8S8R<00F/0hP01Hb8[8QX00:<00B8J8QX
3T@2909400=XA4@00VP2A003J4A400E400=XA4@034@3J0:80fP3R007S6R8S8QXS006R004J8R8R0:/
1hP00hb/[003R003J8QX00:800><R8P00hP01VR<R8b8[0><0j`00lb/[003[003c:b/00F/00C<d:b/
0h`2R005[8R8S:`00X`00hR<S002S003R:b/006<000YA00394A400Y400<TA4@00d@00bA4A005A004
94A490=400<TA4@06d@00bA49007A004J4A4J0U400=XA4@01D@00fR8S003R004J8R<R0:/00F8S8R<
R002S003[8R<00><00>/R8P01:`00hR<S004R007[8b/[=2/S003R006J4A4A8R<0Z`2d004dO7@l@;@
00B/S8b<1:`02<c@[=3<d?7A1?D01?7emM02l@03d?G@00?@00?<d:`00j`00m3ad@03l@07mM3emO7e
l@0?m@06nOGenOGi1OD01?[inOT<m@08n_Wen_Gin_D3n@;j0_T01O7<dJb<009X0T@00fQ4A007A0:8
00><c?D00oD01OWemOGA00Ce00CamOGA0_D00o7ed@05m@03lOGe00;e0]001?G@lOD2d0;a1oD2d@05
lM7emO400oD02_Wad8R/S:b8S:`2S0:/00?@lOD01OD02OWemOGAmO7@m@02d003R8c<00;@0_D01?Wj
nOX4n@Ce00WimOGedOGA[=401=003<c@[:b<[8b8S:b8S0:/00?<[8`00m000lb/c002R09X0d@2J094
00F8[:c@d@04m@05lOGemOT00_D01?WemOT3m@06dO7@d?7@0Z`01Hb/R8QX00E400@TA4A41B@016Q4
A4@2J003A6Q400=400MXA4AXA6R8009X0XP00jb<R004[003S8R800:800F<[8QXR002S0:80fPAA004
J4B8R0=X1d@2J003A6Q400Y40VP4R004J8R8R0><1hP00fR8[004R003S8R800J81X`3R003J8QX00B<
00>8J6P00XP01Xb8[:b<[0:<1J`2c009[8b/[8b/S:c<00:/00><R:`00hP00hb/S003[005S8QXR8`0
0Z`2S068000NA00394A401e400@TA2@T0T@01BA4A4@T009400<TA4@03T@00bA4A00;A00394A401]4
00=X[8`00XP01Zb8S:b<[0:<00>/R8`00XP4S004R8b<[0>80Z`3R0:<00>8J8`00Z`00hb/[002[0:8
00eXR8Q4J8R<[<c@lM3a00;A0]000jb<R002S006c:b/[=3<0m000m7el@03m@07lOGAmM7@d@03d0:/
00?<[:`00Z`00m3<d002d@08mO7AmM7amO4<m@03nOGe00Ge00?jmOD01OD00oWem@0;m@03n_We00;e
1?T00oGin@03n@;e0]001Zb<R6Q4J0940R@5A007J8S<[=3Al@0?m@04dOGel@[e00?adM000]001o7A
lM3AmO401oD01?7AlO46m@04d:b<S0:800><[:`00h`00jc@l@0;m@;a0m42[007c:c@d?7en@05nP03
nOGi00Ke00CamOGa0]001Lc@d=3<00;@00C<S8R<0j`018b/R8`3[0;@00GAd=3<[002R0=X00=4J4@0
0T@01FR8S:c@00?e00?amOD03?D01?7AlO42d0:/0hP2J0]40R@6A09X0d@00bA4A004A0AX00N8J8b<
R8b800:/00J<R6QXR8`6R0AX2T@00bA4A003A09X14@2J0E40VP6A003J4A400Q40VP5R0:<00>/S8`0
0XP2J0V800><R8`00XP00jb<R005[003R8b800>800=XR8P018P00hb/R002R005S8R<S:`00X`00jb<
[004[003c:b/00V/0XP2[0:<00>/c:`00XP018b8S8P2S003[8b/00:80003A00394A401=400<TA4@0
1T@00bA4A008A00394A400A400=XA4@04D@00bA4A00]A003J4@T00]400=XR6P00X`00hQXR002[0J<
00>8[8P00XP02Hb8R8R/R8b8J003S005R6R8S:`00h`01Jc@[8b800:<00J/R6QXR6P3R0:/00K<d?7a
d=42d004c8b<S0F/00?@c=000m000m7em@02m@;a0]402_7Ad=7@c:c@[<`2[0?<0m000o7Al@02d@;a
7?D2n@ke0_T3m@;i0_D00oWem@03m@05lM2/[8P00VP5A00494A4909400IX[:c@dO4?m@?A0_400m3e
m@09m@06d?7AlM3a0]000m7em@06m@?a1oD01M2/R8R<00:81X`00jc@l@0:m@06lOGalM7<0Z`01Lc@
[?7e00;i0_X01OWjmOGi00[e1]001:c@d:`2S003R:b/00><0XP00hb/c002d006lM3edM2/0hP2J0=4
0VP01HQX[:c@00_e0_T4m@;a00?AmM400]001Zb8R6Q4J0E400<TA4@014@00bA49004A003J4@T00E4
00=XA4@00T@00fR<S002R003[8b/00:/00>8S:`00fP028R<R8b8S:b80VP01DAXA4AX00=400=XA6P0
1D@012A4J6P4A003J4AX00A400=XA4@01d@00fQ4A004A09X00B8J6R<3XP00hb8R002R003S8R800J8
00><[:`00X`01:b<[:`4S005R6R8S8P00Z`00hb/S003R003S:b<00N/00><[:`00Z`00lb/[003[003
c:b<00:800B/R8b<0Z`00hb8R006S003[8b/00:800000fQ4A00NA00394A400a40R@7A00394A400Y4
00<TA4@02d@00bA4A007A00394A4009400<TA4@04d@00fQ4A008A0=X00B8J8R80VP018R/S8P3S003
[8R<00B<18P00hb8R002R006[8b<R6R<0Z`2S0B/0h`6R003J:b/00:/0]000m7@d@03d003c:b/00:<
1J`00m3<d003d0?e00CamO7e0_400oGad002d0;<1Z`00lb/c002c0;a00?elO400]400o7em@0Ym@06
nOGenOGi1?D00oWem@02m@04d:b/S0:81d@00bA49002A005J8b/d?403OD01?7emM43d003lM3a00Ce
00?amOD00oD01=7edO42d@;@00?AmO401_D00o7Ad@07m@04d8b<[09X0XP02Zb<S:b8[<c@mO49m@03
lM7a00;@0Z`2d004c?7en@Cj00?in_T01?D00oWem@04m@05d?7<d<`01j`00hR/[004R004[8R/[0;@
00OAd=7elM2/00:80VP2A003J8R800:80X`00jcAm@05m@03n_Ge00Oe00OamOGadM2/00:80VP7A003
94A400A400<TA4@00d@00bA49006A09X0T@2J005S8R8R8`01Z`4S003[8R/00:<1HP2J0940VP3A09X
24@00fQ4A00BA003J4A400E40fP2R003S8R/00><00>8S:`00X`4J0>80X`2J0B800><[8P00XP01Hb8
[:b<00:/2XP01Hb8S8b/00:800B<[:c<0Z`00hb/[004[003d<c@00>/00B<[=3<0X`00hR/S002S0:/
00F<R8R/S003[0B<0J`1S0007D@00bA4A00AA00394A4015400@TA4@T5d@00bA4A00QA003J4A4009X
00N8[8R8[8b/00:<00>/R8`01H`01HR/[8b800:<00>8S8`018`01Jb8R:b<00J/00><J4@00VP018QX
J6P2R0:/0/`00o7@d@02d005c:b/[8`00Z`02=2/[:c@c=3<0]001O7@lOGa00;e00CAmM7a1=001<b/
[<`6[0?@0]400oGad003d2We00?imOD01OD00oWem@03m@05nO7@S:`00XP00ha4A00:A0:800?<d=40
3OD01_7elOGAm@;a00?AlO402OD2l@06dOGemM3A0o400oGam@03m@03lM7e00Oe00CA[:b/0X`2R004
J8b<S0:/00?@dOD02oD01=7amM03c003d?7e00;e0_T4nP03nOGe00We00CamM3<0Z`02hR/[:b<[8R/
R6R800:<00B/S:b/0]000m7@m@02m@04lM2/S09X0d@3J0:800B<[=3a1OD2n@;e00?imOD01_D01?7A
d:`3R003J4A400E40R@;A00394A400I40fP014AXA6P3R009S:b/[8b/S:b<00>/00B8[8R80VP2R005
J4A4A6P01D@2J0U400=XA4@054@2J0940fP3R0><0Z`028b/R:b8S8QX0hP016R8R8`2R003S8R/00><
00B8S8b80X`3[004S8R8R09X1XP01:b8S8`3R004S:b/c0:/00><[=001J`02]2/c:b<d:c<S:`2S003
[8b/00B/00^8S8b<R8b8[8b/R001[0003d@00bA4A002A003J4A400E40R@7A00394A403Q40R@SA004
J4AXJ0:80h`03:b8[:b<[8b8S:b8[0><0XP01:b8[8`2[0:<0XP2S0F/00R8[:b<R4AXR0=40VP018c@
d:`2d004dM3@d0B/0X`5[0;@00?A[=000]001O7ed?Ga00;e00G@mO7@d@03d004c:c<[0;<0Z`00m2/
d@02d006mM7adM3e0]400oGAm@0;m@03nOGe00Se00?imOD02oD00oWem@02m@07nOGenOGjn@02m@0;
nOGed:c<S8QXA6P02D@016R/[<`2d@Ce00?imOD01_D01_7emM7am@;a00?@lO400oD00o7em@03m@03
dOGA00Ce00CAd?GA1OD2l@We0]02[0F<00N8S:b<[<c@00ce00O@mO7ec:c<00;a0_D2n@Cj0oT:m@09
lOG@c:b<[8R/00:<00>/R8P00X`00hR/S002S0:/00K<d=7@mO42m@05lLb<R6P014@4J003S:c<00;a
1_D00oWenP05m@04lOGem@;A0j`00hQXA006A08T2T@00bA4A006A09X0d@016Q4J6P2R005S8R8[8`0
0j`01Hb/[:b<00F80VP00hQ4A008A003J4@T00940fP2A004J8Q4J1=400EXA4B8J002R003J8R800><
1:`3S003R8b800>800AXR8R81H`01:b8R8`2[004S8R8S0:/00Z<R8R<J8QXR8b80X`018R<S8`3R0><
1J`01Lb/[:c<00:/00K<[8c<[<`2[004c:b<S0:/1h`00jb<[002R003S:b<006<000?A00394A40094
00=XA4@014@00bA4A00MA08T>4@01FQ4A4AX00e400=XR8P00XP00jb8R004S00:[8R8S<b8S8R<[0:8
18`4R008S8R8S:b<[<`2S003[8b8009X0hP2J005R8b/d<`01=02d@03d<b/00N/0l`2d008c=3@dM3A
lM42l@03d?G@00;@00?<d=000/`3[005c:b/S:`01=03l@?A5?D00oWem@0Cm@03nOGe00Ge1?T4m@06
d:b/S8QX34@2R003c?7e00oe00?adM400o43d@We00SamOGelOGAm@?A00?elOD01?D00o7em@05m@03
lM3@00:/0X`00hR<R004S0:/00?@dOD02_D2l@03mO7@00:/00?@lM400_D3nPKi1?D00oWem@02m@;a
00CAd:b/0XP00jb8S002S0:800F<R:b<R003[0?@00?AmOD00oD00m2/[004J003A6QX009X00F8[=3A
l@07m@03nOGe00Ce00_amO7edLb/R8b8J007A08T0T@00bA4A002A00394A400U40VP014AXJ4@4J0B8
00><R8`00XP00hb/[002[004S8R8R0=X00>8A6P03T@2J0940VP014AXJ4@290I40b@9A09X00>8S8`0
0XP3S003R:b/00><00B/S8QX1HP2S005R8b8R:`00X`00jb8S002[0>80Z`00hR<R009R003[8R800>8
00J<[:b8[<`2[005S:b/[8`01Z`01<b/[8`2[003S:b<00F/00><R:`00hP2S003R:b/00:/000:A005
94A4A2@02D@012A492@5A00394A401E400<TA4@02d@00bA4900HA00394A4011400=XA4@00VP=A09X
00Z8J6R<R:b<[8b/0X`01:b<S:`2S0:/00><R8P00XP00hb/S004S0:80j`00lb/[002[003R6R800F8
0X`01<c@[:`3d004lM3Ac0:/0X`4[004c=3@c0K@0]401_7AdM7ad@S@0/`2[003c:c<00?@00?AlM40
0o4[m@03nOGe00Se00?imOD00_D01=2/c:`3J0a400>8c=402OD00oWem@04m@?a0]42m@03lM7e00ce
00?amO400_D01?7AmO43m@03lOGa00Se00?ad8`018P00hb/S002R005S:b/[<`00_4<m@06lM3<[=3A
0]001_Gin_[inP;i00?jmOD01_D02?7elM3Ad:b<0XP00hb8R003R0:<0XP01Hb/[<b/00;@00Cad?Ga
0oD01M7@[8b800IX00J8S:b/d=48m@03nOGe00;e00GamO7ad@02d003[8R<00:800=4J4@00T@590=4
00@TA4@T3T@00fR8A002J008A8R8S8R/S:`2S005R:b<S:`01HP3J0940VP4A003J8Q400U40fP5A003
94A400U400=XA4@014@2J0F80X`7[005S8R8R8`00hP00hb8J002R003S8R800:800>/R8`00X`00hR<
R00@R004S8R8R0:<00>8S8P00X`01:b<[:`2S0B/0X`2[004R:b/[0:81:`5S003R6QX00>800><[8`0
0J`000m400<TA4@03T@00bA4A00EA00494A490A400<TA4@00d@29003A2A401Q400<TA4@014@00bA4
A00JA0AX00F8S8b/S002[003S:b/00>/00N<[8b<[8R<00:800J<[:b/S8P6S0B/00><[8`00XP3J003
R8b/00:/1=000m7@d002d003[<b/00><00V/S:b/c=3<d<`01=000o7@l@03d@07d=7ad?7@d@04d003
c:c@00;<00?@c=000]000o7@l@02lC[e00?ad:`00Z`2J09400<TA4@014@01bA4A4B8c?404OD00m7@
l@02m@04dOGAl@;e00?amOD01OD00o7em@03m@03lOGa00?e00?amOD02_D01O7@R8QX00:80h`2R004
S:b<[0;@00?AmOD02oD00m7@d002d0;a00?enOX01OX2n@We00G@lM7Ad002S0>800><R8`00X`028R<
S8c<S=3<0]02d@03lOGe00Ce00C@[8R81VP01HR<[=3a013e00OadM3<d:b<00:80VP3A0HT3T@01fQ4
J6Q4J8P016P00dAXR002R0:/00F<[:b/S003[0:80VP018QXJ8P<A003J4A400E40fP2A005J4A4A2@0
24@00fQ4A007A004J8R8R0:<1Z`00hb8[002S0B80VP018aXJ8P2S003R8b<00:<00>8S8P01hP016R8
R8P2S006R:b8S8R<0Z`018b/R8P2S0:/00><[8`01Z`018b/[8`5[00;S:b8S:b<[8b/S8P00Z`01Xb/
[8aXR0:<0Z`000a400<TA4@014@00bA4A00BA003J4A400]400=XA4@01d@00bA4A00RA00394A400E4
0R@IA09X0hP3[0:<00>/S8`00j`2S007[8b<S8R<[002R003S6R<00:800>/R8P00X`00jb8S002S0:8
00=XR6P00T@02VR<[8c<[=2/c?D2d00;dM2/[8b/S:b<[8`00Z`03hb/d=7ad=7@lM7@mO7Am@02d@;@
00?edM000]403M3Ad<c@[<c@c=3Ad?D00_400oG@m@02m@05nOGemO401?D00oWem@05m@04n_GenA;e
00?imOD00_D00oWem@03m@06nOGemM7@0X`00hQXR00;A004J8b8d0Oe00CimOGi2?D01=3amO42m@05
dOGamO401_D01]7emM7ed@?a0_D00o7em@03m@03lOGa00Ge00?amL`00XP028b8R8b8S:b80j`01<c@
dM02m@03dOGe00Se00?Ad<`00]001?GamOT7nP;i1oD00o7@l@02l@03[8b800:80h`3R003S:b/00:/
00><[:`00]02d@04lOGel@?e00W@[8R<R4B8J4@00fP018R/d?46m@03nOGe00Ke0]401=3<d:`3R003
J4A400=40R@3A00394A4009400=XA2@01T@00hQXJ002J004R6QXR0=418P00jb<S004[003R:b/00:8
0fP00dAXJ00DA09X00A4J4AX0d@00bA4A00@A09X00V8S8R8[8b/S<`00Z`01hR<S8b8J8P00VP8R0><
00B/S:b<0XP2J0:800=XR8P00XP016R<R8`2R0:<00=XS:`00X`4[006S:b<R8b80Z`02/b/[8R/S:c<
d<`4[003S:b800:/00V<R8b<[8R<c8`00VP00hR/R001S0005d@00bA4A002A00394A400m400<TA4@0
4D@290Y40R@<A00394@T02U40VP00hR<R007[0><1J`01hb8[:b<R6P028P00hb/[003S0:800><J6P0
0XP2J005S8R/S=000/`2d003dM3@00;@00G<[:b/S005[005S:c@d=400m000m7@m@02d@03d=7a00;@
00GedM3@d@03d0F/00O<d=3<dM3a00;A2OD00o7em@0Xm@03nOGe00?e00Gad:b/S003J0M400MXA6QX
R:c@00Ke00?imOD03?D2d@04lOGal@;e00?amOD00oD01_7elOGam@?a1OD00o7el@0;m@04d8R8R0:<
00>/R8`00XP2S003[=3<00?@00?AmOD02OD2d0:/00G@mM7an@04nP04nO[jnPSe00Gad?GAd003[0:<
00N8S8R8S8R<00F/0/`2d0;A0_45m@;@0Z`00hQXJ002J008A6QXR8c@dO45m@03nOGe00Ke00?adM00
0Z`4R09X0d@290I40R@00dAXA00290Q40fP018QXJ4@2J003R6R800>80j`01lb/c:b8S8P00VP3A003
J4A400m400=XA4@00T@4J003A6Q400M400=XR4@01D@01fQ4A4AXR8`00XP01fR/S8b/c:`00X`3R0=X
0XP01FR8R8R/00F800B<[8b<0XP2J0B800AXR8R80X`00hR<J002S0:/00^<[:b8[8b/S:b<[004S0:/
00G<[:b/S003[004d:b/S0B/00F<[:b8[006S0:800><R8P00H`001i400<TA4@07d@00bA4A002A003
94A400a400<TA2@02d@00bA4A00RA004J4B8S0>80j`2S0:/00B8[8b/0X`00jb<S002S005[8R<S8P0
0h`01Zb8S:b<[0:<0XP2S007R6R8S8QXR003[006c=3@c=3<0]001M7@S:c<00:/00F<R:b/S002[0;@
0/`2d0;a00KelM3@lM02d@S@00F/d=3<d004c005d=7adO40>_D01M7<[:b8009X24@00fQ4A002J003
S=3a00Ge00?imOD03?D00o7ed@0;m@04lOGal@?e00CAd?Ga4OD00o7@[003S003R8b800F800><[<`0
0]000m7em@05m@03dOGA00;e00W@[:c@lM3AmOT01OX01OGjnOGi00Ge00?ad=400]000jb8S007R004
S:b/c0:/00C@c:cA1M000o7em@02m@05lM7@[8`016P014AXJ8P3[003dOGe00?e00?imOD01oD01=7@
[8`4R0e40b@2A00394A4009400>8A6P00VP2R003A6QX009X28P00hb/[002[0F81fP;A09X0T@3J0=4
0XP5J0940VP3A004J4A4A09X00>8J4@00fP3R006[8R8[8c<0j`2R0:<00>8J6P01hP2J0J80X`7R0AX
0XP018b8S:`2R0><00b8S8R/S8R<[8R/R:`2S0B/18`018R/c:`5S0B/00B<R:b80j`018b8R8`2R06/
000;A00394A400E400<TA4@04d@00bA4A00BA00394@T01i40R@VA004J4AXR09X00>8[:`00j`3S0:/
00f<[:b/S:b<R:b8S:b800:<00F/R8QX[002R0:<00J8S8b/R8`2R0:/00><c:`01=000lc@d003d0>/
00><[8`00X`028R/S:c<d<c@0/`02m3AdM3AlM7edO7A00W@0j`2c005[=3@d?400]400oGam@06m@;a
2oD00oWem@0Cm@03nOGe00?e00?imOT01_D01O7@[:b<00=X00=494@024@016R8[=04m@03nOGi00;e
00?imOD03?D00o7em@08m@?a00GAmO7ed@02l@oe00GamOGAd002c005[8R<R8`00XP01fR8S8b/d=40
0_400oGam@04m@05dO7elM000Z`4d003mOWj00Kj00?imOD01OD00o7@d002d0:/00><R8P00XP01VR8
R8R<c0c@00?AmOD00_D01?7ed<`2[004S6QXA0AX00B8[<ca3oD01m6/S8b8J8P00d@290M41B@8A005
R6QXR6P00T@3J0N800Z<R8b/d<c@[8b816P014AXJ6P3A003J4A400E400AXR6QX0XP4J003R6Q400=4
00=XA4@00d@00fQ4J005A09X0T@2J0>800><R8`01j`3S003R6R800>800J<R8R8J:`3R003S8R/00><
1XP4J0>80h`02Jb8S8R<[8R<R002[0><2Z`3S0:800><[8`00X`2[006S8R/[8b80h`01:b<[:`3R06<
0HP001E400<TA4@06T@00fQ4A00aA08T8D@2J003R6R800:<0Z`018c<S:`2c0:<00>8[:`00j`4R0><
00^/R6R8S:b<R:b8[002S09X00J8[=28[8P2d003dM3@00G@00Oa[:b<[8QX00:<00>/S:`00/`01O7<
d<b/00?@00Ced?7e0]000oG@m@03d003dM3@00:/1=002Jc@d=3Ad?7@d@09m@03lOGe00Ge00KimOGi
mOTEm@04nOGen@;e00?imOT01OD01O7@[:b<00>834@016R8lO42m@05n_WjmOT02_D00oWem@0=m@06
lOGAlOGA0_D00m7ed@05m@03lOGe00?e00?amOD01OD01m3Ad:b<R6P00hP00fR8S002S0;@00KAmM7a
mO44m@04d?Gad0>/00G@[=3en@08nP03mOWe00Ce00GAd=7@c004[0>800N<R8R<[<cA00?@00C<d=2/
1=02d@03lM7e00?e0]001Lb<R8a4009X00>8J8P00Z`00m3em@0=m@04lLb8[0:800=XA6P02T@012A4
A2@8A004J8R8J0:80T@4J0:80X`018R<S8`6[0:800=XS8P00VP01DAXJ6Q4009X1D@4J0>80VP01HQX
R8Q400EX00A4J4A40VP014AXA6P4A003J4A400=X00>8S8`00Z`2S0J/00><[8`00X`01FR8R8R/00:8
00J<R8R<R8`2R005[8b<S6P02HP01Zb8S:b8c0:80X`01:b<R8P2[0:<00>8[:`00Z`00lb/c005[003
R8b<00>/00B<[:b/0X`00jb8R005[004R:b/[0:80J`1S000=4@00bA4A007A00394@T01A40R@9A003
94A400=40R@00d@TA00OA0=X0XP2[004S:b<S0>/0X`5[005S:b/[8`00Z`2S007R6R8[8b/R002[0><
0XP018b/S8P2[004c=2/c0;@0/`3d003c8b<00>800=XS:`01:`3d0:/00C<d=3@0]401M3ed=3A00?@
00B/d=3@0j`4d004c=3@d0;a00?AmM401oD00m7em@0:m@03nOGe00Ke00?amOD03?D01?WemOT2m@03
nOGe00?e00?ad:`00Z`00haXJ002J003A2A400I400EXA8R/d003m@;i00?enOT04?D00o7em@08m@Ca
00CelOGa2OD00o7em@07m@05lOGAd:`00hP3J003R6R<00><00>/d=400]400o7em@03m@05dM3adM00
1:`2d004lOGin@?j00Cin_[i1OD2l@K@0Z`2R0><0j`01=3adM42d0;A00>/d=000]04l@Ge00WAd:b/
R4AXA6P018P00m3am@02m@03lOGe00Se00?@c8`00hP3J09400<TA4@014@290E400<TA4@014@8J004
R6QXJ0B800><R8`00X`4[0F80VP00hQXA003J005R4A4A6P00d@4J003R6R800=X0XP3J003A6QX009X
14@00fQ4A004A004J4A4A0=X0X`4[003S:b/00>/0X`00jb8J004R003S8R800>800=XR8P00XP00hb/
R002J0>800><R8P018P4[006S8R<J8R/0X`00jb<[002[003R:b/00>/00?@[:`00j`4S005[8R8[8`0
0j`00hb/S002[005S:b/[8`00Z`018b8S8`1R0007D@00bA4A00>A00394A4009400@TA4@T54@00bA4
A00MA00394A401U400AXA6Q40VP00hR<[005[005S:b/[8`00Z`018b/[8`3[005S:b<[8`00XP00jb<
S002[003S8R800>800>/S8`01J`2d005c=3@dJ`00m04[0><1:`00lb/d003d003dM3@00?@00GAd?7@
d@04d003c=3<00>/00?<d=001]001M7alOGa00Oe00?amOD04oD00o7em@0=m@03nOGe00;e0_T5m@08
d:b/[8b8J4@2J004A2@T909400QXA6R8S:c@d@Se00?imOD05oD01?7emO4=m@03lOGe00Se00Cad=3@
2HP018b/[:`2d003dO7e00;e00KamO7AlM42d007[<b/[=3Ad002m@03nO[j00Cj00?imOD01?D01O7@
d=3A00;<0Z`00hR<[002R004[8R/d0;a00?ed=001M001?7@d=42l@04mO7el@;e00Cad=2/0fP00hQX
J002J006[=3AlOGA0_45m@06lOGed:b<0hP3J0]40R@00d@T9005A005J4AXJ4@01VP2A009J8R8R:b8
[8R<00B/0hP02Jb8J8QXR4AXA003J006A6Q4J4AX0T@2J003A6QX00=X0hP00hb8A004A003J4A40094
00=XA4@014@01FQ4A4AX00>80X`00jc<[002[003c:b<00B<00N8S8b8S8R/00B80fP9R003J8R800>8
0VP01XR<S8b/S0>80h`00hR<S002S0:800>/R:`01:`01hR/[8aXR:`00h`7[0B<00V8S:b/S8R<R8`0
0Z`1S000:4@00bA4A005A00394A400E400DTA4A4900:A00394A402Y400<TA4@03T@4J09400=XS8P0
1:`028b/[8b/S:b<0Z`00hb/S003[004S:b/R0:<0j`2S003[8b800EX00B8[:b<0Z`2c003d=7@00?@
00F/c=3@c002[005S:b<R8`01J`4d005dO7Ad?400]02d@?@00Cad=3<1:`2c0:/00?@c=000m001<c@
mO4Pm@03lOGe00[e00?imOX00_T00oGin@03m@09lOG@c:b<[8QX009400=XA4@01T@01VR8R8R/d0Ce
00?imOT06_D01?7edOD2lASe0/`01Jb8R8R/00F800><[:`00]02l@?e00WadM7AmM7adM000/`2[003
d=7@00;e00?in_X01?X2n@Ke0]42d0;<00B/S8b<1HP00lc@l@04l@03dM3@00;a00KedM7AlM48m@03
lM2800=X00U4J6QXR:c@lOD00o400oGam@02m@08lM7@d:b<[8P2J003R6Q4009400<TA4@00d@00bA4
9002909400<TA4@014@2J003A6QX00B80VP2R0:<00B/R:b<0j`4S0J800=XA8P016P5A09X14@4J0>8
00=XR6P03T@02FQ4A4AXA6R8J002R003J8b/00:/00B8[:b/0X`2[003S8R800:800>/R8`00XP00jb8
R002R003[8R800>800F<R8R8J008R004S:b8S0:80X`2[0B800F/R8R/S004[003S8R/00:/0h`00jb<
[003[0:<0j`3S0>/18`2[06<0J`1[000:D@00bA4A00;A00394@T00I400<TA4@05D@00bA4A00>A003
94A401U41FP01DB8R8R<00B/0X`01Jb<[:b<00:800R<[8b<[8b8S0:800>/R8P00X`4[09X00]4J6QX
R8b/S:b<[003d003c=3<00:/1<`02M2/S:b8J8R/S003[0C@00Wad?7@lM3Ad?401]001:c<d=02c0>/
00?<[=001=000m7al@0Nm@03lOGe00ce1_T5m@;a0]02[0><00=XA4@014@012A4A4@4J0:/00?@mOD0
7_D2l@03dO7a01We0]02[004R:b8S0>800B<[:c<0]000m7el@02m@08dO7alOGAlM43d0:/00?<dM00
0_D00oWjnP04nP;i1_D2d0;<0j`00hb8R003R0:<00?<d?400_42m@0?d?7AlOGAd?7@lM3AmO7A00Ge
00Sa[8aXR6Q4J0:800J<[=3AmM03l@Ce00GAd=2/S002R004J8QXJ0A40R@5A0<T34@2J003A6R800F8
00><R:`01j`00hb8R002J003R6QX009X00A4J6QX1d@2J0=400EXA6R8J003R09X1T@390A400AXA6QX
0T@00fQ4A003J0:800B/S:b/0XP3[0:<00O<[8b<[8R<00:800><R8P00hP2J0B800=XR8P00XP2J004
R8b8R0:<0j`00hR<R002R0:/00B<[8b80X`3R003S:b<00:<00>/R:`01j`018b/S8`3[0:80X`00hR/
S002S007[8b<S:b<[001R0002T@00bA4A00;A00394A4009400<TA4@03T@00bA4A00>A00394A402]4
00<TA4@00T@00bA4900AA0MX00B8S:b<0j`00hb/[004[003S:b/00B/0X`01HR/[8R<00J/00B8J6QX
0XP00fR8S002[003S:c<00;<00N/c<b<[<b/00;<00?@[:`00Z`2R003S8R/00:/00C<[=3<0]000m7@
d@06d008[<c<c:c<[=06[003c=3@00;@00?amO402OD00o7em@0;m@03lOGe00Ge00?AmO400_48m@09
nOGjn_GjnOGi00Ce0]401Lc@[8b800:/00=XA4@02D@2J005A8b8[=400oD01?WemOTIm@;A0_49m@03
lOGe00?e00?amOD01OD01]7alLc@c0:/0XP01FR8J8R<00>/017@dM3amO7elOGadOGad=7<d002c003
d?G@00;e00?in_X01OX01OGimOGj00;e00?Ac<`01J`4R005S:b/[=000_43m@08lM3emO7edO42d@03
d=7@00Oe00?ad8`00XP3J005[8R<c:`00]002?7@dO7elOGA1=001:b8J8P2J003R4A400<T0T@00fQ4
900490A400=XA4@00d@00hQ4R002J006R6R8R8b/0XP00fR8S002[005c8c<[8`00hP00fR8J002R0EX
1T@3J0941FP4R003J8Q400M40R@6A003J4A400A40VP00hR<R003[0>800><R8P00XP4S0>80X`5R0=X
00J<R8QXR6P2R004A8b<S09X0XP02:b<[:b<J8R<0Z`01hR<R6R/S:`00hP00hb/S002S0V/00><[:`0
0j`01Xb8S8R<R0:<0Z`00hb/[002S07<0J`1S00000=4J4@01d@00bA4A007A00394A400I400<TA4@0
1D@00bA4A002A00594@TA2@01D@012A4A2@7A00594A4A2@05d@00bA4A00@A00394A401I41VP00hb8
S004[0:<1j`00hb/c002[006S8R<S8R<1:`01hb/[8b8S8P00fP2R003[8b<00:/0]02[003c:c@00?@
00V/c:b<[8R<R:`00X`6[0;@00GAlO7@d@04d003c=3@00Z/00?<d=000m02d@03lOGe01oe00?AmO40
2oD01?WjnOT6m@;A0]001:b<R8P2J003A6Q400Y400EXS8b<d@0Qm@03dOGe01Se00KadOGAd:`2S004
[8QXJ0:80X`02:c<d=7@lOGa0_D2l@07dOGad=7@[002c0;@0_D00oWjnP04nP;i1_D01=3A[:`3S0:/
18P2S0;<00?amOD00_D00o7em@05m@?A0_400oGam@05m@04lLb/[0:800=XR6P00XP01:c@dM03d@04
lOGad@:/00Ka[8b8S8P3J09400<TA4@014@590M400=XA6P016P2R004J8QXR0:<0VP2R003S:b/00>/
00F8S8R8S003R003J8QX00=X00=4J4@00d@4J0=40fP4R003J8Q4009X00=4R4@02D@00fQ4A003A0AX
0X`018R/[8`8R0:/00><R8P02XP00fR8R002R003J8R800:800AXR8b<1XP3S0:800B<[8b/0X`01XR/
S8b/S0R80X`4[005S:b<S:`00X`018R<R8`2R0><0Z`01Xb8R8R<[06<000GA00394@T00I400<TA2@0
2D@00bA4A005A08T0T@00bA4A009A00394A401a400<TA2@024@01BA4A4@T01A41FP5R0:<00>/R:`0
0h`00hR/[002[006S:b<R8b/0XP5[003c:c<00><00B/R8QX0hP2[00;S:b/c=2/c:cAd<`00m02[0>8
0X`00jb<S005[003c=3@00;A0]000m7@d003d003c:c@00N/00C<[:b/1]000m7em@0Mm@03lOGe00;A
00?amOD01OD01OWenOWe00;i00?enOD00oD2d@05c:b<S8P00VP8A005J4A4R4@00VP2S003c=7e00Ge
00?imOD05_D2lA3e00?amOD01OD00m7el@04m@03lJb/00:/0XP00fR8S002[006c=3@d=7a0_D01M7e
lM3a00;A00Kad=7<d<`2d@03lOGi00Kj00KimOGimOT2m@;@0Z`00hR/[002[0:<0XP2S004[<cAl@_e
0_401M3alOGa00Oe00KadJb/R6P2A09X00>8[<`00]02d@;@00Gad=2/c002[004R8b8J0e40b@00dAX
A003A006J4B8R4AX1XP00hb/S004S0F/00?@[:`00X`5R003J8Q400A400=XA4@00d@:J0>80fP018Q4
A8P3J0=400MXA4A4J4AX00A400EXR8R8S003[0:<1XP01FR8R8R<00:800><R8P018P2[0B800EXR:b/
S00=R0><00B8[8R<0j`2S003[8b<00><0XP00hb8R002S005R:b<S:`00X`00jb<[002[004R8b8[0B<
0Z`2S003R:b<00:/0004A003J4A401U400<TA4@024@01FQ4A4@T00]400@TA4@T1T@291Q400<TA4@0
1T@00bA4A00MA0=X0XP00fR8R002R00>J8R8[8R/S:b<[8R<R8`2R003[8R<00:800B<R:b<0Z`2S0J8
00MXR8b/S:b<00:/00?@c=001<`2d007[<b/[8b8S003R003S:b/00:/00?<d=001=02d@S@1:`00lb<
[002c003[8c<00K@7OD01o7edO7edM002OD3n@03mOWe00Ge00Sad=2/S:b8J0=400<TA4@02D@2J004
S:c<dB7e00?amO404OD02?7emOGAmM3A0oD00o7<d002[0><00EX[<c@c002d003c?7a00;e00?amM00
0]02d@04lM3@d0;<00G@dOGen@07nP05mOWemOT00oD2d0:/00[@[:c@S8R<R6R80Z`00m3Am@08m@09
lOGemM7edOGa00Se00Cad:b/0VP01DAXR6R800>/00G<d=7@d@02d0B/00B<R6QX1T@00bA4A005A08T
2D@2J004A6R8A0>80Z`2S003R8b/00B/00V<[8b/S:aXR8`018P2J0I400AXA4A416P014AXJ6P3R003
S6QX00E416P2A003R4A400I416P00hb8[005[0:<18P00fR8R002S006R8b8S8QX0hP00hb8R002R004
S8R8R0:/00N8J8R8S:b<00:800IXS8R<R8`3R0:<00>8S8`00hP2[006R8b/[8R<0hP018b8[:`2S0B/
00B<[8b80Z`2R09X00><[8`01j`000A400=XA4@01d@00fQ4A00HA00394A400m400<TA4@02D@00bA4
A00;A00394@T031400AXA6R<0XP2S005R8b<[8P01J`01Hb/S8b800:/00F<[8b/S002[003S:b<00:<
00B/R6QX0XP01Hb8[8R<00>/00K<[<c@[<`2[003S=2/00;<00K@[:b<[8`4R0:/00B8[:c<1=001?7@
d=44d003c=3@00;@00>/d<`00j`00hb/[002c003d=7<00?@0oD00oWem@0Fm@08lM7AlM7ad?48m@;i
00?en_D01_D01?7Ad:`2S003R8aX00I400=XA4@014@01fR8R8b/d?400_D00oWem@05m@03n_Ge00;e
00?imOD03OD00o7ed@02m@03lOGe00;e00?amO402OD00o7el@05m@0<lOGad=6/d:b<[8b80j`01M3<
d?GA00;e00WamM7@dM3amM000]42c003[=3e00;e00Gin_[jn@02nP03nO[e00Ge00GAmM3@c002[003
d:b/00>800MXR:b/c?Ga00?e00?imOD01?D2d@;a0_D00m7em@03m@04nOGem@;@0Z`2R005J8QXJ8P0
0Z`01hS@d=7@dM000Z`2S0:800=XA4@03D@290a40fP2R003[8R/00:800><[:`02:`00haXJ002R004
J8R8R09X2T@016Q4A6P2A003J8R<00:80VP5A004J4A4J0=400=XA4@01d@2J0>81J`00hb8J005R004
[8R8R0=X00>8J8P00XP00hb8R009R004J8b8R0><0hP00jb<R002[0:80j`028R<S8R/S:b<0Z`4S005
R8b/S8P00X`00jb<[006[003R8b/00:<0XP00jb<[002[004R8b/[06<000:A00394A400Q400<TA4@0
14@00bA4A008A00394A401540R@9A00394@T00e40R@8A00394A400E400<TA4@07d@4R0:/00V8S8b/
S8R<[8`00j`3S0B/00><[:`00Z`2S003R:b800:800=XR8P018P2S005[8b/d<`00]001Zc@[=2/d0:/
0/`2[003J8R800F80X`2[003c=3@00;@00?Ad=000]46d003c=3<00;@00S<[<b/c=3<[0K@7OD01?7A
dO42d@03mO7e00Ge00KimOWimOT6m@03lM7@00:/0X`00hQXJ00;A09X00J8S8b/c?49m@Ci4_D00o7e
l@09m@03dOGe00Oe0_44m@06lOGemO7e0]000lb/[002[003S:b/00:/00C<dM3a1OD2d@04d?7ed@;@
00S<[:c<d?7en@Oj00GimOGen@02m@;a0]001:c<[<`2[004S:b8J0:80Z`01=7emOT8m@07lOGamO7e
l@0:m@08d<b<[8b8J4@3J003R:b/00:/00G@[:b<[002S0:800=XA4@01D@00bA4A004A0DT2T@2J003
A8R800F800><[:`01j`00lb<J002J0>800AXR4AX2T@4J004A6QXJ0B80VP00dAXA008A003J4A40094
0VP2A09X00A4R8R81J`4R003J8R/00:/00>8S8P01VP00hR<S009R0=X00>8S8P018P01Hb8S:b800><
00B8S8R80h`01Jb<[:b<00>/0X`3R0:<00>8S8`01Z`00hb/S002R008S8R<S8R<[8`2[003R8b/00:/
0005A00394A400940R@00d@TA00=A00394A4029400<TA4@04d@00bA4A00NA003J4A400i400]XR8QX
R:b<R:b<[002R0B/00V<[8b/S:b<[8`01J`018b/S8`5R005[8QXR8`00Z`2S0B/00?@[=001J`01<b/
c:`3R003[8R<00B80j`3d004dM3ed0;A00?@lM000m02[004d<c@c0:/00?@c<`00Z`3c0C@7OD2d003
lM7a00Ca1_D2n@05mOWemOT00oD00m7ad002d006c8b8R6R81D@00bA4A005A005J8R/[=002_D4n@;e
00?jmOD03OD00m7em@0Em@;a2?D00m7@d002d0:/00O@c:b<[=3A00;@0oD00o7em@02m@03lOGe00;A
00?@[:`00]000o7em@06nP;i2?D2d003[<c<00:/00>8[8`00XP3[003c=7e00ke00?amOD02oD2l@07
d:aXJ4AXA002J005[8b8R8`01:`01lb8S8QXA6P01T@00bA4A002A00394@T00<T0d@2J0E400N8J6R<
R8b/00:800F<[:b/S007[003R8b<00N80VP2A003J4A400940VP00hQXJ002A0AX0hP2J0940VP2A005
J4AXA2@00T@5J003A6QX009X00>8[8P00Z`01/b/[:b8S0>80Z`2S0F800B<J6R<0Z`2S004[8R8[0N8
00>/R8P00Z`2S006[8R<R8b80h`01XR/R8b/R0F/00^<[8b/S8R<R8b8[003S0:/00C<[:b/0h`2[003
S:b/00><0Z`018b/S<`1[0002d@00bA4A00<A00494A490Y400<TA4@01d@3J0U400EXA2A4900>A003
94A400e400<TA4@014@00bA4A00KA003J4A400AX1XP01:b8S8`3[003S:b<00B/00N<[6R8S:b<00B8
00><R8P00h`2R004J8b<S0:/00N<[8b/c:c<00F/00K@c=2/S8P3S003R6R800:800B<[<c<0]001=7@
d=02d@03lM3@00C@1:`01Lc@c=2/00?@0l`01:c@d?4Mm@;A00CadM3@0]47m@Ci1_D2l@06d=6/d:b<
0fP00dAXA002A00394A400940VP01TB8S:c@d@_e0oT5m@03nOGe00[e00C@mOGe0o4Am@?a1_D2l@?@
1<`01:c@[:`2d005dM3emO401?D00m7em@03d@;@00>/d=000]401OGin_[i00;j00?in_D01?D01_7A
mM3Ad0>/00><R8`01X`00lcAm@08m@04lOGam@;a0_D00o7em@0;m@03dJaX00IX00>8S8P00X`2[005
S:b/R8`016P2A003J4A4008T14@49003A2@T009416P00hQXA002R003[8R800>/0X`00jb<[002[005
S:b<[8`00j`2R003S8R800=X0T@016Q4A6P4A0=X00=4J6P00fP2R0AX00=4J4@01D@00fQ4A003A003
J8QX009X00=4J4@00VP2R003S:b/00:/0XP018b8R6P2R004S8R8J0:800MXR8R8J8b/00:<00J/S8b<
R8`2R003S8R<00:<00>/S8P00XP4S004[8b<[0:<00Z/S:b/R8b8S:b<0j`00hR<R004S0:80X`6[0:<
00B8[:b<0j`2S0J/0H`000A40VP4A00494A490940R@00d@TA002A0@T1D@00bA4A00=A004J4A4J0i4
00<TA4@08d@290]40VP>A0EX00I4J6R<R8`2R004S:b<S0>/18`02jb8S:b<R6R8S:b<00B818`5R003
[8b/00:/00F8S:c<d006[0;<0]001:b<R8P2S0:800>/R8`00Z`2c0;@0]44d005dM3@c:`00/`2[005
R8b/d:`00l`3d003[=3@00?@00?AlOD06OD2l@03d=7@00?@00?AmOD01?D01_[enO[en@;e00GimOGe
d@02d0>/0XP2J0]400QXR8R<[=7@d@We00?imOX00oT2m@03nOGe00Ke0]44m@06dOGedOGA0_D00o7e
m@04m@05nOGemO400oD00o7Ad004m@05lOGed?D00m001Zc<c:c<d0:/00?ed?400oD01?7emM42l@06
dOG@d=7@0l`2d003mOWi00;j00Gin_Wen@02m@09nOGamM3edLc@00:/0XP00hb8[002S0:800>/c?D0
2?D00o7em@03m@03dOGe00Oe00?imOD00oD01M3AS:aX00=400UXS8b<[8b/R8`00Z`2R09X00B8J8QX
2d@5909400AXA6QX0hP01Hb8J6R800:/00F<[8b/S004[005S8R<S:`00h`00jb<R002R0=X00=4J6P0
0T@016Q4A4@3J09416P3R00:S8QXA6Q4J4AXA09X14@00fQ4J002J004A6QXJ0:800F/R8b<c002[0:8
00R/S8R8[8R/S0B800=XR6P00VP3R0B<00>8S8`018P01jb8S8b8[8`00hP018b/S8`2R003S8R<00:<
00N8J8R/S:b<00:/00O<R8b8S8R/00>800><R8`00h`3R0:/00><[8`00/`01:b<[8`2[003S:b/006<
00000dAXA007A00494A490=400<TA4@00T@00bA4900@A00394A400e400<TA4@0;D@00bA4A00IA003
J4AX00AX00B8S8R80h`00jb<[002[003S:b<00:/00B8S8b80X`3R0:<0hP2S005[8b/R:`01HP01Hb/
S:b<00:/00?@[:`00j`3d005c=2/R8`00XP00jb8S002S0B/00?<d=000]000m7@d003d0?<0Z`2d0:<
00>/c=001M000m7@d006d003lOGe01Se0o401M3Ad=3a00Ge00?imOT00_T00o[en@05m@08dM3@d:b<
J8P2J0]40VP00hR<[002d003lOGe00Oe0oT2nP05nOGemOT01oD00o7@m@02m@03lOGa00?a0_D00o7e
m@0=m@;A1?D00o7ed@02l@;A0m03[00;c:b/d=7elOGadO400oD00o7el@05d007[<c<c:c@m@04nP?i
1_D01=7ed?42d006c8b<R8b80X`01XR<R:c@d@[e00?amOD00oD00o7em@0<m@03lJb8009X0T@2J005
S8R<R8`00XP2S0=X0XP00fR8J00;A00394A400Q40VP00hQXJ003R0:<00>/S8`00X`00lb/[002S0:/
00><R8`00X`00jb8J003J003A6Q400=40fP00dAXA003J004A6QXJ0:800F<R8R8J003A09X0d@016Q4
A6P4A004J4A4A09X0XP00hb/[003[007S8R<R8b8J002R003S6R<00:80VP00hQXJ003R0B<00B8S8b<
0XP00hb8S002R007S8R<R8b8[004R0B<0Z`2S003R:b/00:<0Z`4S0:80X`01:b8R8`3R003[8R<00:8
00J/S:b/S:`6S0:/0H`1[06<000=A00394A400E40R@6A00594A4A2@02d@00fQ4A00;A0<T3d@01BA4
A4@T01I400<TA4@014@00bA4A00AA004J4A4A09X00>8J6P00XP00fR8S003R006[8R<S8R<0Z`2R003
S:b<00:80X`00hR/S002S004R8b8S0:80VP3R0:<00R8[8R<[8b/c0F/00G@c<b/d003[0:<0Z`00hb/
S003S005c:c@c=401M000m7<d002[005c:b/[8`00Z`2c003d:c<00:/00?<d<`00]02c003[=3A00?e
00?amO401OD00o7em@05m@03dOGe00Ge00CAmM7A0m02l@Ce00KimOWimOT7m@;A0/`00hR<R002J0U4
00IXA6QXR:`3d003lOGe00We1?T2m@;i00?jnOD01?D00m7am@06m@05dO7amO403oD00o7el@09m@;a
0]000lb/[002[005S=3Ad?D01?44m@03lM7a00?@00S<[=2/d<c@m@Ci00?jnOD01oD3l@;@0/`02Hb8
R6R<[8R<[002d003dO7e01Ce00?amOD01oD01:b8J6P4A0AX00>8S:`00XP2J0F82D@00bA490059094
00=XA4@01VP2S0:80h`2[005S<b/[8P00Z`3S0>800F<R8R8J004A0=X00A4J4A40VP00dAXA004J003
S6R800>80fP2A09X24@4J09416P01XR<S:c<[0:80h`2R003J8b800B80VP00hR<R003R008S8R8S:b8
[8`3R0:<00>8[:`00X`2R0><00F/S8b/R003S006c:b<S:c<1:`2R0B<00B8S8b<0XP00jb8S002S0>/
00><R8P00Z`3S0V/0007A00494A4909400<TA2@014@012A492@5A00594A4A2@06D@390I400<TA4@0
<T@2J0e40fP4R0:/0VP2R0:/00><R8`00h`3[0:<1J`2R003S8R800:<0XP01VR8J8QXS0>/00B8S:b<
0Z`018b/S8`2[004c:c<d0>/00F<[8b/S003R006[8b/c=3<0]001O7@d=3a00?@0Z`00lb/[004[0;@
0/`01jb8c=3<d<`00Z`3d003lOGa00?A00?amOD00_D00o7em@03m@03lOGa00Oe00CamM3a0m000oGA
m@06m@03nOGi00;e00?imOD00oD01=7@c:`2R004A6Q4J0E400<TA4@00d@01VR<c:c@l@_e00?imOT0
0oT2m@;i1OD00o7@m@04m@;a00?AlM402_D2n@?e00?amOD03?D01o7Ad=2/S:`00X`3d0?a00?elOD0
1?D2d@04d=7@d0;<00N/d:c@dOGi00?j00?imOD00oD00o7em@02l@?A00?<[8P00XP02fR8R8c@dOGA
mM3a01Ce00?AmOD01oD01?7<R4@2J0940VP00hQXJ002R004J8R8R09X0XP2J0=400AXA4AX1T@012A4
A4@3J0941FP00hR/S002S003R8b/00R/00F8S8R8J004R0AX0T@01VR8J4AXA0=X00B8J4A40VP01XQX
R8QXR0AX0T@2J0E400<TA4@00VP01TAXA6Q4J0:800QXS:b/d:b8S0B800YXR8R<R6R<[8aX0hP018b8
S8P4S003R:b/00B800F<R8b<R003S006[8b/S:b<0XP00hb8R006S004R:c<[0:<00F/S:b/S002R004
[8R8S0J/00J<R6R8S8P2S004[8R8R0:/00><[<`00J`000Q400@TA2@T1D@2909400<TA2@01T@012A4
A2@EA00394A400Y400<TA4@00b@HA00394A400A400<TA4@064@4J004A6QXJ0>80X`01VR8S8R/S0>/
1h`02:b<S:b<R8b80X`00jb<[002R005J8R8[8`00Z`00hb/[002[005S:b/[<`02J`2S0:800>/S8`0
0XP2S0B/0m000o7@d004d003c=2/00:/00?<[:`01Z`3S009[<b/c=2/dLc@00;A0_43c004d=7al@Oe
00CAmO7A1_D2l@05mM3AdO400_D01?7enOD2n@03mO[e00We00Ca[:b<0XP01FQ4A4@T00I40VP2R004
[<c<d@?e00?imOD01OD00oWen@02n@03n_We00;e00?imOD00oD00o7@m@04m@07d=7Ad?7el@0=m@03
lOGe00ge0m002Lb/[:c@c=3Ad003m@03lOGe00Ce0]400m3<d002d003c=2/00;@00CenO[j0oT8m@06
dO7@d<b/1XP01Hc@dOG@00?a4_D00m7ed@02d@Se00?Ac6P00VP2A09X00>8J6P00fP018QXJ6P3A004
J4AXJ0A400=XA4@00d@00bA4A007A003J8R8009X00>8S8`01HP018b/[:`2S006[8b/[8R<18P2J004
A6R8A0=X0T@2J005R6QXR6P01XP016R8R8P2J09400=XA4@02D@00fQ4A003A0=X0hP2[007d:b/R:b8
S009R003S8R<00>80X`2R003S:b800N800R<J8aX[8QXS0:800N/R8b/S:b800:<00>8S8P00X`3R003
S:b/00>/0XP3J004R8b8R0>/00B8S8b/0XP2S003[8R<00:/0X`01HR/[:b<006/0009A00394A400Q4
00@TA4@T2D@00bA4A00=A00394A4009400<TA4@034@00bA4A003A00394A4008T4d@012A4A4@291a4
0fP014AXJ4@3R004[8R8S0>800B<[:b<0Z`01XR<R8R/R0:/00J<[8R8S8P3S004[8R8A09X00V8S8R8
[<b/c:`00h`018R/[=04[0;<00F<[8R8J005R006[8b8[8b/1=02d@03d?G@00;@0j`00lc@S002[003
c:c@00N/1=002Lc@d=3edM3Ac003d003dOGe00;e00?@mOD00_D01=7emO44m@09d?GelOGad?GA00Ce
00KjmOWimOT2m@03nOGe00Ce00C@[:b/0XP018aXA4@290E40VP01/b<d:ced@Ce00CimOGi1?D00oWe
n@04n@03mO[i00Ge00?ad?400oD02O7Ad=3Ad?7el@06m@?i4oD01?7Ad=02[007c:b/d<c@l@04m@03
nOGi00;e00?ad=001=02c0:/00C@lOGj0oT8m@?a0]03[0:<00=XS8`00Z`01M3adOGA00;a3OD01O7e
mOGA00;a0]000o7em@06m@03d8Q400=40VP00hQXJ003J004S6QXJ0E40fP2A09X1d@00fQ4J005A006
S8R/R6R<0XP018b8[8`2R0:/00><R8P00XP3[0J800=XA4@00T@2J003A6Q400IX00>8J8P01hP00fR8
J009A003J4A400I400AXA6QX0XP00fR8S002[004d8R8[0>800=XR6P00XP01FR8R8R<00:800F<J:b8
S002R006[8R8S8QX18P01VR8R8QXR0><0XP2S005[6R<R:`018`3R005J8R/S:`00XP01XaXA4AXR0:<
00B/S:b<0Z`01Xb8R8QXS0B80Z`3S0:/0HP1S0005T@012A4A2@2A00394A401I400<TA2@01D@00bA4
A004A00394A400M400<TA4@04T@012A4A2@=A09X4d@3J0:800QXR8R8S8R<R0B/00><[8`00X`00jb8
S002S004[8b<[0:80h`2R0EX00R8S8R8S:c<d0:<00>/S8`01Z`00hb/[002S003R8b800><00F8S8b<
R002[0?@00Cad=7A1M02c004[<b/[0;<0Z`2S0J/00C<d:c@0/`3d@;@0/`4d0?a00?elOD01_D00o7e
m@03m@Ca00?AlOD01OD01?WemOT8m@03lM7@00>/00>8J8`00d@00bA4A004A008J8R8S:c@c?43m@03
nOGe00Oe0_T00oGjn@03m@03nOGe00?e00?Ac=001?D2d006[<c@dM3e0]400o7em@04nA?e00K@lM3@
c=03[0?@00?amOD01_D00o7el@05d0;<00F/c:c@m@03n@We0_400m7@d002[0:<0hP018b/[=06lA7e
00?AmO400]400o7em@06m@04d:b8J0A40XP2J09400B8J8R80VP01TAXA4AXA0=X34@016Q4J6P6R006
[8R<S8R<1:`2S0:800N<[:b/S8R<00>800AXA4A40VP5A0=X0XP3J003R6QX00:80VP00hQXJ002A003
J4AX00e416P4R004[<c<[0><00>/R8`02HP00fR8R006R0:/00>8S8P028P00fR8J004R0:<0Z`00hb/
S002[004S:b/S0:800J<R8R/S:`2R0AX00F<R8b/R002[0:<0j`00hR<R003[003R:b/00:<0j`1S06/
0L`000Q400EXA2A4900FA00394@T00m400<TA4@00d@292Q40R@=A003J4A401A416P3R0:<0XP01Jb<
S8b/00><0j`018b/[:`3S006R8aXR8b/0XP4J0:800AXR8R<0Z`02HR<R8R/R:b<c006[0>800><[8P0
0XP016R8R8P2[00<c=3@lM3ad=7@lM3A1=05[007d:b<[8b/c006[005c=3@d=401]02d@Ga00?elOD0
3?D01?7elO4Cm@06dM2/[=2<0XP00dAXA007A003J8R<00:/00?<d?400_D2n@Ce00KimOGimOT2m@03
nOGi00;e00?imOD00oD00m6/d004m@;@00J<d:c<[=02[003d?Ge00;e0_TCm@03dO7@00?@00N/d<c@
lM7a00We0]400m2/d003d0?<00B/d?Ge0_T:m@04dO7@d0:/00B<R:b81J`00m7@d@03d@03mO7e00ce
0_42d@03d?Ga00;a1oD01o7@S8b8J8P01fP2A09X2D@2J0=400<TA4@014@2J003R6QX00940VP00hQX
R002R005S8R8R8`00Z`2S0>/00F<[:b/R002S004R6QXJ0940VP9A003J8QX00B800IXR6R8J8P2J003
A6QX00A400=XA4@02D@3J004R6R8R0:/00C<[8b/18`2R003S8R800:800AXR8b/1XP4S0:800=XR8P0
28P2S0>80h`01Zc<[8R<R0B<00B8[8b<0Z`2S0:800F<R8R<R002S003R:b<00:800B/S:b80h`4[003
S8R<00:<0j`1S0005D@00bA4A002A003J4A400A40R@4A00394A400Y400<TA4@02T@00bA4900PA003
94A400Q40b@@A003J4A400I40fP9R003S:b<00><1J`018b/S8`2R004[8b8R0:<0XP00fQ4R003R003
S:b/00:<00>/S:`01:`2S003c:b<00>/00J<R8R<R:`6R004S:c<[0?@00KAmM7ed=44d003[<c<00b/
00S<S:b/S:c@[0O@0Z`01OGAdO7@00;A00?amOD01oD00m7em@03m@03lOGe00Ce00?imOD00_D01?We
mOT6m@;@00F/c8b8J009A0=X00N<R:c@mO7e00?i0oD00oWem@08m@04nOGin@Ge00?Ad=401?D02=2/
S=2/c:c<0j`01=7amOD2nACe0]42c0;@0/`2d004dOGel@Oe0]401=2/c<`2d0:/00?@[=000oD00oWe
m@09m@04lM3@d0>/0X`4[00;c=3@mM7adOGamM403OD01=7adOD2l@03dO7e00Ke00?A[:`00X`01HQ4
A4B8009X00=4R6P00d@00fQ4A002J0m400=XA8P00fP2R004J8QXJ0F80X`8[0B<0hP3J09416P6A0EX
1hP016R8J8P2J09400=XA4@024@016Q4J4@2J003A6R800:800><[:`00Z`018R<S:`4R003S8R800>8
0X`3R0F<0j`00hR<R007R0:<0hP02:b<S:b<[8b/0X`2R003S:b<00F/0X`2[003S8R800F<00J/S:b<
[8`2[003R8b/00><00>/R8`00Z`01Hb/S<b/007<000EA00394A400U400<TA4@05T@00bA4A00cA08T
6D@026Q4J6R8[8b80X`2R004[8b8[0:<00F8[:b<[003S0:800>/J8P00hP01JaXJ6Q400=X0XP2[003
R8b/00B/0X`2[005c:aX[8`00XP018b/S8`2R004[8R8J0:<00n8[:c@[?7@dOG@mO7@dL`00Z`01Lb/
[:c<00:/00B<[:b<1:`2R0B/00K@c?7ad?44d006c?7@d?G@0_D00m3em@08m@03dOGa00;e00?amOD0
0_D00oWen@02m@06n_Gin_Gi1OD00m6/[003R004J4A4A09X0T@3J005A8R8S:`00]04m@06n_GenOGi
0_D00oWem@02m@05n_GinOD00_T3m@04dO7<d0;e00?amJ`01Z`01?7@d8P2d0?e1?T9m@03nOGe00Ce
00CamJb/0]04[0;@00?edM000oD03_WemOGamO7<d<cAd<b/0m02m@;i00?enOD01oD01M7ad=3<00:/
0X`00hR<[002[003c=3@00?a00GAmM7ed@09m@08lOGamO7elOD2l@03d=7A00Ge00Cad:b/0XP00fQ4
J002J0940fP3A08T0d@00fQ4A00>A003J4AX009X00J<J6QXA6P2R003[8b<00:<00>/S:`00Z`2S0:8
00N<R8R8J8QX009416P7A007J4AXR6R8J005R004J8QXR0IX0d@00bA4A005A009J4AXJ4AXR8b800:<
0/`2[00:S8R/[8aXS:aXS0B800><R6P00XP00hb/S002S004[8b<[0N800>/S:`00hP2[006J:b8S:b<
0Z`02HR<S8b8S8R/S003R003S:b800>800><R8P00X`5[003S:b800F800B<[:b<0j`2S06/0H`00114
00<TA4@03T@00bA4A00CA00494@T90E400<TA4@0;d@00bA4A009A003J4A400]40VP8R004S8R<S0:/
00><[:`00Z`4S0N80X`7J0:80X`00hR<S002[0B<00>8[8`00Z`01XR<S8b/R0:<0XP00hb8S003R0>/
1=02l@04mM7ad@;@1J`01<b/[:`3S003[8R800:<0XP01Hb/[:c<00o@0m400o7em@05m@04lOGel@;e
00?amO401_D00oWem@02m@;i1_D01M2/[8b8009X14@02FQ4A6Q4J4B8S002[003c=7a00Ke00?imOD0
1OD2n@03mOWi00?i1OD01=2/d?42m@03lM2<00:/00K<d<c@dM02S005d?7emOT00_D00oWem@0?m@05
dM3@c=000j`3d004dM3@l@Oe0_400m3<d002d@:/00?@dM000_D2n@[e0_42d004c=2/[0:<00V/S8b<
[<c@mO400oD00m7em@0=m@07lOGemM7ad002l@Oe0]000jb8A004J0=400=XA4@00d@00bA4A00AA003
J4A400AX00B<R6QX0hP01Jb<S8R<00:800N/S8b8S8R<00B81FP00dAXJ004A005J4A4J8P00fP00hR<
R003R004J8QXJ0:816P3A003J4A400M41fP018QXR8`7[003S8R800N800B<R8b80VP00hR<S002[003
S8R<00:800><R8P00hP02:b<S:b8[8b/0XP01Hb/R:b800><0Z`01Xb/R8b/S0:80X`018R/[8`2R0:<
00B/S:b/0X`2[003S:b<00:800F<[8b/J004S0>/000@A00594A4A2@05D@00bA4A002A00394A40094
00<TA4@00T@290=400<TA4@01T@391U400=X92@05d@2J0e40fP2R003S8R800:81H`02:b<[:c<[8b/
0XP2S00:R:b8R8b8S8QXA09X0XP02:b<[8R<R8b/0X`018R/S:`5S004R8b<S0:800b<R8R<R:aXR8b/
S:`3d00:dOGemO7ed=7@c0J/00J<R8b/S:`3R004[8QXS0B/00?@c=001=02d@03c=3@00?@00?<d=00
0]48m@03lOGe00;e00?amOD02_D2n@?e00CimOGA0Z`00hb8A003A08T0T@00fQ4A002A09X00B8[<ca
3?D2n@03mOWe00;i0_D00oWem@04m@04d:c<l@;e00CAd:b/1=02l@06d:b<[=3A0oD2nA;e0]02c0>/
1M000m7al@05m@03lM7A00C@00CAc:b/0]001=7enOT:m@;a0]001Lc@[:b<00N/00C@lO7e0_400m7a
d@0=m@06dOGamO7e0o47m@;@00?<R6P00T@2J003A6QX00EX5D@2J003A6QX009418P00hb8R002[003
R:b800:800>/R8`00X`6R0=X00>8J4@02T@018QXJ6P2R0:<0fP3R09X00B8J6QX0d@2J0Q41fP014AX
R8`3[003S8R/00:<0XP3J003S8R800F80VP3R0:/0hP01fR8R8R<R6P01HP3[0:80X`3[0:800>/S:`0
0Z`00hb8S002S0B80h`028R<S8b/R8b/0X`01Jb8S:b800:<00>8S8`00j`018b8R8`2[06<0007A003
94A400E400<TA4@00T@391I400<TA4@014@290E400HTA4@TA2@3A00394@T009400<TA2@02T@00bA4
A00;A00394A401I400=XA4@02T@2J003A6QX00:800>/S8P00XP00hb/R002S003[8b/00>/00B<[8R<
0XP00hb8R003R004S8QXJ0:81:`00hR<R005S004R8b<S0:/00B<[:b818`3R006S8R8S8R/0h`3[004
dM3am@;a00CAd=7@0/`3[008S:b8S8R/S:`2S0:800N<R8c@S:b<00:/00?@c=400]001?7@c=02[003
d:c@00;<0]000m7al@0:m@03lOGe00Oe00CjmOWi1?D01?WemM02[003R6Q400Y400IXA6QXS:`2l@Ce
00?imOD01OD00oWen@02m@04nOGen@Oe00?@[<`01?D01M3<d?7e00;@00CedM7@1:`2l@03mOWi00ge
00KamOGamM42d0:/0/`3d005lM7@dO401OD01=3ad=02c003[?G@00;<0m02m@03nOGi00Ke00GamOGe
d@02d005dJb<S:`00h`3[007c=3AmO7ed@02l@oe00CamO7a2_D2d@03d:b800A400=XA6P01FP3A09X
00E494A4J00<A0=X0d@2J005R8b8R8`00hP2S003[8R800:<00>/S8`01HP3J09400=XA6P00T@00fQ4
A003A005J8QXR6P01HP01fR8R8QXR8`00fP2A003J4AX00Q400AXA4AX0XP016R8R8`2[003c:b800>8
00F<R8R<R003J0J80VP00hQXR003R003[8QX00:800><R8P00X`01XR<R8R<R0F<1:`00hc<[002[0:<
00F8S8b8S002R004[8b<R0B<00>8S:`00X`00hR/R003S003[8b<00:/00N<[8b<R8b/00:80H`005=4
00<TA4@0;d@00fQ4A002A0EX28P2S0>/00J<[8b<[8P2[005J8R<S:`00XP018b8S8P2J003[8S<00:/
0XP028b8[:b<R8b80j`00hb/S005[003S:b/00>/1XP01Hb8S8b/00;@0]401?GalOD3d005[<b<[8P0
0h`02:b<R:b<R:b<0XP01/b/S:b<d0:/00C@c?Ga0]001?7<d<`4[005d<c@lM401?D00m7em@03m@03
lOGa00Ce00?imOD00_D01?WenOX6m@;@0Z`2A0AX1d@2J0:80]03m@03nOGe00?e00?imOD00_D01OWe
mOWe00;i00?enOT01OD01=2/d?42m@06dOG@d?Ga0_D00m3ad002d005c8R<d?400_D2n@Ge00?amOD0
1?D01?WemOD2l@03d<c@00:/0]002Lc@d=7ac=7el@03m@07lM7ad<c@d@03d0;<0]02m@;i00?enOD0
1OD00o7em@02d@06d=7@R:b<0hP018b/[:`2d0?e00GamM7ed@0:m@06lM7emO7A3?D01?7@d8P2J0=4
00=XR6P00fPIA0IX1HP2S004[8R8R0:<0hP4S0B80VP3A09X14@016Q4J4@3J003[6QX009X00>8J6P0
1XP00haXJ002A09X1d@00fQ4A002A0=X00B<R8b80Z`03]2/R8R/R8aXS8R<R6R816P00hQXJ003J003
R6R800F800><R8P01HP2S00>R8b8S<b8S:b8[8R<c8`2[0F800B<R8R/0X`4R008S8R8[8R<[8P3S0:/
00F<[8b<c003[003S8R/00:/0XP000e400DTA4A49007A00394A400I400DTA4A4900MA00394A400Y4
00<TA4@03D@290M400<TA4@03T@00fQ4A008A004J4A4A0MX00B8S8b/0hP00hb/[002S003[8b/00:<
0Z`01Xb8S8b8[0:800UXR6R8J8QXS:`00X`00hR<R002S004[8b8S0>/00B8S8b<1:`028b8[:b<[8R<
0XP018b8S8`3[0;@00WAlO7elM3Ad<`00Z`018b/[:`2S007[8b<[8b8[002S0:800F<[8b<R003[0G@
00?<[:`01Z`00lc@d002d005dO7amO400_D01?7emM4<m@?i1OD01M3<c:b800Q400=XA4@00VP2R0:/
00?@mOD05OD2n@Ce00?A[:`01?D2l@08d?GemM7ad?42d@05c8b8[=000oD00oWem@0?m@03lM3<00B/
0]001/c@dM3<d@Ge0o400m7@d002d@;@0Z`2d0;e00?imOD01_D00o7ed@02l@?A00?<S:`018P2[004
c:c@d0;a00KelO7AmO4:m@04dO7al@Ke00?imOD01_D01=7@[8P2J0=400EXA4A4J00:A00394A400U4
0VP01DB8J8R<009X00J<R8b8S:`2S0F800V<R8R8S8R<R:`00XP5J0E400EXR6QXA003J0:800=XR8P0
18P00fR8R003R0=X00A4J4AX1T@00fQ4A003A007S6R8R8b8S003c003[8b<00Z800=XR8P01FP00hR<
[003R0:<00B8S8QX0hP026R<R8R<R8b/0X`01HR<R8b800:/00B<[8b80h`01XR<R8R<[0B80X`018R/
R8`3R005S8R/[8P00X`01Zb<S8b/S0>80Z`2S0003d@00bA4A003A00694A494@T2T@00bA4A002A003
J4A400i400@TA2@T1T@491E400<TA4@094@2J004A6Q4A09X00N8J8QXR:b<00F800?<[8`00X`00hR/
[003S003[8R<00:80X`2R004J4AXA0:800=XS:`00XP00fR<S003S003R:b<00:<00F/S8b/S002[0B<
00>/S8P018`00jaX[002S0:/0]02d@09mM7ad=7@c:c@00>/00><[8P00h`01:b<[:`3S004R8b<S0:8
00B<[=3A0]001=7@d=04[003d:b/00:/00?@[<`01=000m7am@03m@03lOGe00[e0oT2m@04nOGad0>/
00>8J6P02d@2R004S<cAlAce00?@[:`01?D2l@05dOGAlM000_43m@05d8b/[=005OD00o7@[007[0;@
00K<d=3@mM42l@?A00?ad=001=002Lb/d=3amOWen@06m@03dOGA00;A00O@dM7@c:c<00:800><[8`0
0Z`2d008dM3edO7Ad?49m@03lOG@00;@1OD00oWen@07m@05lM2/R6P00d@2J09416P3A003J4AX00m4
00IXA8R8J8P3J0:800F<J8R/R002J0:80X`01:b8R8`3R09X00>8J6P01FP3A09X0d@016Q4J6P2R006
J8R8R8b/0XP3J003R6Q400]41VP01HQXR6R<00B/00?<S8`00X`:R004S8R8R09X0XP5S005[8R8R8`0
1HP2S007R8b8S:b<R003S003R8b<00B<00>/S8`00XP2S005[8R<R:`018P018b8R8`3R007S8R<S:b<
[003R0:<00B8S:b80j`1S0004d@290A400<TA2@02D@00bA4900DA00394A400Y400@TA4@T7d@00bA4
A009A003J4A400A400=XA4@014@3J0=400MXR8R8J8R<00:800AXR8R<0Z`2R004[8R<S0:800J<R8R8
S:`2S007[8b<J8QXA002R0:/00>8J8P00X`2[003S:b<00:<00>8[:`00Z`01Xb/[8b8[0:<00B8S:b<
18P00jb8S002S006c=3Ad?G@0]43d0;<1:`00hR<S003S0:/00B<[:b/1XP00hb/d005d003mM2/00N/
00B<[:b<1:`00m3am@04m@03lOGe00Ge00?imOD00_D00o[em@04m@04d:b/S0=X0T@012A4A4@2J094
00IXR8b/d=43m@03nOGe01Ce00OamOF/S<cA00?e00WAd:c@[<b/d?400_D00o7@[003[0Oe0_400m3a
m@03m@03lOGa00?e00?ad:`02J`2c0?@00?edO400]001=7edO42d007dM3@c=7@l@0;m@06dO7AdOG@
0_42d003dJb/00;<00>/c:`00/`02=3Ad=7elOG@0oD02_7emO7Ad?7@c=06m@03nO[e00Oe00Wad8b<
R4AXA8P01fP2A00394AX00Y400AXA4@T0T@3J0>80fP01Hb8R6R800:<0VP3R0:<00B/R:b/0XP2J003
R6Q400=X0XP2J0=400=XA4@016P7R003S8R800B80VP<A0UX00>/S:`00j`2S003R:b800:800=XR8P0
0XP00fR8R003R003J8R800B80j`4R0:<0XP01Hb/S8b800:<00G<[8b/S002[0>800B<[8b80X`2R003
S:b<00:800F<[8R<R002S003J8b800:800J<[8R<R8`4[0:<00F8S8b/S004[0001D@00fQ4A005A0@T
00E492A49002A00394A400I400DTA4A4900=A0@T00=494@02D@3909400<TA4@01D@00bA4A00GA003
94@T01]40VP01DAXR=28009X00J<R8R<R6P3S0B80X`046R8R8R/J8R<R8b/R8b8J8`2J005S6R<[8P0
1:`018b8[6P3S005R8b8S8P00Z`018b8R8P2[004S:b<S0F800F/S:b<c002d006lM3alM3e0]000jc@
[002[004S8R<J0:<00Z/S:b/S:b8S8R<0XP2S0B/00?<d=400]02[004d:b/d0:/0X`018R<S8`2[0;@
00GedOGel@02m@04lOGel@?e00KjmOGimOT3m@03dOG@00:/00><R4@00T@2909400AXA6R80VP01Xb8
[=3ed@ce00?imOD00_D00o[em@04m@07lOGedM2<[002m@0;lOG@[8R/c:b<c=000_D2d0B/00?@mOD0
1OD2d@03lM3e00?e0o401]7edM2/S0B/00R8[:c<[=2/c0;A00?amM400m401_G@d=3Am@G@0oD00oWe
m@04m@03dOGA00?a00?edM000]001M6/[:c<00B/0m001?G@mOD2l@07mO7edO7ed@02d004c=3@l@Ke
0oT3m@07lOGemO7A[002R009J8QXJ4B8J8QX00A400<TA6P02T@00fQ4A003A0EX00><R8P00XP2J0B8
00><R:`00XP2S003[8b<00:800=XR8P00VP00dAXJ003J003A6Q4009400=XA6P016P00hR/R003R006
S6QXR6R80fP2A003J4A400=40fP00dAXA002A005R6QXJ8P00X`00jb<[002[0F800AXR8QX0XP00fR8
R002J004R6R8J0>800F<R:b<R002[007R8b<R8b8J003S005[8b<[8P00X`018S<[:`4R0:<00N8S8R<
[8R<00:/0hP00fR/R00=R0:<00>/S:`00XP3S003R8b/006/000AA0<T00=494@07D@01BA4A4@T00Y4
0R@00d@TA008A00394A400M400<TA4@0:T@00fQ4A003J005[6QXJ8P00X`01HR<S8R<00:800N<[8b/
S8R<00:800B<[8b<0j`00hb8S003J0B818`3[003S:b800><00J8S8b<[8`2[007S8R8S:c<[004S0:8
00><[:`00X`02<c@dM3ed?7A0]000lb/c003[003R8b<00B<0j`2S0J80X`00jc<[002c0:/00G@[:b/
R002[004S:b/[0:800EXR8R8S002[004dO7elA?e00GadM3<[002R0A400YXA6Q4J4AXR6R<0Z`2dAce
00Ga[8R<d002m@03dM2/00:800b/R8R/d?7Ad:b<[8`2[003dOGe00;e00Oad=7@dM3a00;e00CAmM3@
0o401M7@[:b<00:/00V<[=3@dM3<d<`00m001_7AlM7am@;A00Cad=7@0Z`00m3Am@08m@08dO7alM7e
lM42d0;<00^/d<c@c=3<[<c@d@02l@?e00?amOD00oD01?7A[<`2d003dOGe00?e0oT00o[em@03m@;a
0_D01?7@[8`2R003A6Q400=X4T@00fQ4A003A0=X0hP2S004R6QXJ0:800><R8P018`02Jb<[8b8S8QX
R002J0A40VP6A0AX1hP01Zb8R8QXR0=X00F8A4A4J006A004J4A4J0941FP3R003[8b/00>/0hP00fR8
S006R004S:b8R09X0hP00hb8S002S006[8R/S8R<0hP01:b<S8`6R0:<00B8[:b81:`2S005[8b<S8P0
0X`00jaXR002R005J8R8R8`018P2S0:800B<[:b<0j`2R003S:b/00B/000DA08T24@00bA4A00BA08T
2d@00bA4A002A0<T:D@291Q40VP00hQXJ005R003S8R800:80X`00hR<R004R0:<00B8S:b/18`018Q4
J6P4R004S8R8S0:/0X`2[0:<0j`2S0>/00N<[8b8[8b/00:<00R8S8b<R8b8S0:/00W<d=3@dM3Ad?40
0]03[0><00B8[8R<1J`00hb8R002R0:<00>8S:`02Z`2S003[8b<00><1hP01Jc@dO7e00?a0oD00o7e
m@0;m@;A00G@[8b<R004J0940fP014AXS:`2S003c?7e01ce00Gad8b/c002m@05lLb8S8P00VP00hR/
[002c004[8R8[0:80]001]7@dOG@c0:/0m001=7adO42d008dO7adLc@c:`2S0>/00C<d<b/0/`2d006
dOGamM7a0_D2l@?@00B/S<c@1oD00m7ed@02d@06lM7adO7A0m001Zc@d=2/d0?<00S@lO7amO7ed@Ga
00G@c:c<d002l@Ge0oT00o[em@04m@06lOGemO7@0Z`00hQ4A003A003J4A400m40VP2A09X0d@3J003
R6R8009X00>8S8P01hP2S004[8b<S0:816P00dAXJ008A09X0XP3J0B80X`3R004J8QXJ0:800AXA6QX
1T@3J003R6QX009X00M4J6R8S8S<00B/00B<R8R<0hP2J003R6QX00:<0hP2J003R8b800N80X`2R006
S8R<R8b/0hP2S004R8b8R0:<00J/R8b/S8P3S005R8b8R8`00XP018b8J6P2R003J8R<00:<00>8S8P0
18`4[003c:b<00:<0Z`3S06/000=A00394A400E40R@3A00394A400=400<TA4@014@00bA4A00jA003
94A400E40R@3A08T4d@2J0A40fP00hQXJ005R004[8b<S0B800><R8P00X`00hR<R002S0>/00B<[6R8
0VP018R<[8`2R0>/00F8S:b8S003[0:<00B/R:b/0X`7[0:<00>8S8P00Z`01Hb/[:c<00?@0]402=3A
d=3<[8b/0h`01:b<[8`4[004S8R8S0>800><[8`00X`01:b<[8`8[004S:b<S0:80X`01hR<c<c@lM40
0_D00o7em@0=m@08lM7ed=7@S8P2S003R6Q400=400AXA4A40VP01Hb/R=3A00Ge00?imOD02oD00oWe
m@06m@06lM2/[8b/0oD01=2/S8P2J0:800><R8P00hP01:b8J8P2[005S<c@dL`00Z`01Xc<d=3Ad0;a
00?@c=400]000m7@[00;[0;@00B/d=7e0]02d@;a1=001=7@[=07m@;a00?AmM001?401M7@d=3A00C@
00F/d=3<d002d@06lM3AlOGa1M401M3Ad=3a00Ke00?imOD01?D01O7elM7a00Ce00C@S8QX1D@00fQ4
A00<A0AX1d@<J0N800><R:`00Z`4R0AX0XP00fQ4A003A0=X00B8J4A40fP3S0F826P7A09X0T@5J003
A6QX009X00>8[8`01:`00hb8S006R003J8R800>800=XR8P00XP00fR8R004R007S8R/[8R<[002S005
[<b/S8P00X`2[0:80h`02XR<[8b8[8b8S:`3S0B800=XA8P018P2S0B80X`01Zb<S8R/S0>/00F<[:b/
S002[0005T@00bA4A003A00394A400<T2T@00bA4A00<A0<T3D@00bA4A00GA08T14@390=400<TA4@0
3T@00fQ4A008A008J4AXJ8QXR6P2R0:<00B/S:b/0X`01jb<S8R<R:`00XP2[0:<00B8J6R80VP018R<
R8`2[005S:b/[8`01J`5S0>/00J8S8b<[8`2[0:<00F/S8b/R002S0>/013@c=3@dO7@dM2/S8R<[8b8
0X`01Jc<[:c<00>/00>8S8`00hP018b/S8`2[004R:c<c0:/0m02[0F<0j`00lc@m@05m@03lOGe00_e
00?imOD00_D00m7ad003[004R6QXJ0940VP02TAXJ4AXR:b8[=4Jm@09dM3@d<b/S:cA00?e00C@[8b<
0VP2R0AX00E4J6R8J002R005J8c@d:`00X`00jc<[002d003[=7A00>/00?@dM000Z`01Hb/c:c<00:/
0X`2[0;@0/`:d0;A00G@[8b/l@06m@Ca00G@lO7el@02d@C@00?Ad=001M001_7@lM7el@?e00OAmLc<
[=7@00;a00?elOD02_D01=7edM42l@?e00?@R6P016P5A00494@T90Q40fP00hQXJ007A0=X0XP00fR8
R003J0>800B<R8R80X`2[003S8R800:800AXR8R80VP3A09X0T@00fR8J004J008R8b<R8b8J4@5R09X
0T@2J09400IXR6Q4J4@5J003A6Q400=X00F8[8b<[002S0:80X`2R005S8R8R8`00XP00jb8R003R09X
0hP2J0:800><[:`00hP01Xb8S8b8J0><0hP00hb/R002R006S8R/R:b<1HP00hb8R002R09X00B<R8R8
0h`4R0><00>/S8`00Z`2S0B/0XP1S06/0009A003J4A4019400DTA4A49003A00794A4A2A4900>A003
94A400]400<TA2@01D@00bA4A00AA08T0T@00bA4A00JA003J4A400=400=XA4@00VP00hQXR002R0:<
00Z8S8b<[8R<[8R/0XP00hb8R006R0=X00E4J6R8S002[006c:b/[<b<0j`2S005R:b/[8`00Z`00hb8
S003[008S:b8[8b8[8`2[0:800B<c:b/1M000oG@d002[004S:b/S0:80j`01/b/c<b<[0F<00N8S:b/
S:b<00:800?@c=000]000m7<d002c0F/0]000m7em@02m@04dOGel@We00?imOD01?D02O7ed?G@[<b/
R00:A09X00F8[8R/d003m@03nOGe017e00?AlM400m000lb/[002[003c?Ge00;A00?@[:`00XP01Zb8
A6Q4R0AX00I4R8QXR:`2d003S8R/00N/00>8S8`01j`00m2/[006[005c:b/S:`01L`6d005[8R/[=40
1_D02=7alM7@lM7e0]42d004c=7@d@K@00F/d=7@d@02l@;e00?adM000Z`01Lc@d?7e00?a2?D00o7e
m@03d@03d?GA00;e00>/S6P016P5A00394A400Y40VP00hQXJ004A003J4A4009X00>8J8`00hP00fQ4
J003R0:/00>8J:`018`01HR/J8R<00:800=XA8P00T@3J0940fP01XQXR6R8J0B816P00haXR002R004
J4A4A0aX14@2J0:800>/S8P00Z`5S005R:b8R6P00hP01hb8R8QXS6P00XP016R8R6P3R006[8b/R8b/
0XP01:b8R8P2S004[8b<J0:800B<R8R80X`2R005S8R8R8`00hP028aXR6R8[8R<0hP6S004R8b/S0>/
00><R:`00h`2[06<0J`001M400<TA4@034@00bA4A00=A00494A490Q400<TA4@00d@4919400@TA2A4
0R@00d@TA006A00594A4A2@024@2J1140VP00dAXJ005R003[8R800><00B8S8R/0XP2S003R8b<00>8
00>/S8P00VP018QXR8P2S003R:b/00:/00J8S:b/S8P3S004[8b<R0:/00><[8`01J`018b/[8`2R004
S8R8S0>/00?<d=000]03d@04d<c<c0B/00>8[8`01J`2S007[8b/S:b<R002S0>/00N8[<cAd?7A00;a
0m45d003dO7e00Se00?AmOD03?D2l@06mM7ed<b/0X`00fQ4A006A004J8QXJ0:<00>/d?405OD00o7A
d003d0>/00B8S8c<1?D01?7Ad:`5R003J8Q4009416P2A0:<0Z`3R09X00F8S:b8J002R0:/00>8[:`0
1j`00lc@c002S005[8b/[8`00/`01Jc<d=3A00?@00J/R8R<d=43m@04lOGam@;a00?@lO400o42d005
c=3@dM000m45d0;A00?amOD00_401=2/[:`3d0Ca2OD01=7edOD3d0?a00C@[8QX0T@2J0A400<TA4@0
2D@016Q4A6P:A004R6QXJ0N800B/R8R/0hP00jb<S002R003S8QX009X0XP4J009A6QXA6Q4J8QX00N8
00><R8P00XP00haXR004R003A6QX009416P3A003J8QX00AX0T@2J0:81:`4R003S8R<00>80VP00hR<
R005R0=X0hP01fR8R8R/S8P00X`3R003S8R800><00>8S8P00XP00jb<R002[005R8b<R8`00XP018b8
R8P2J0B800F/R8QXR003S0:800><R8`01H`01Jb8R8b/00><0Z`0011400XTA4@TA2A494@T74@00bA4
A00=A00394A400a400<TA2@01T@00bA4A004A00394A400Q400<TA4@01d@00fQ4A00:A004J4A4A0=X
00=4J6P00VP4R0:/18`01Jb<[8b800F<0XP00hb/[004R005J8b8[8P00X`00jb<[005S0:800J/S:b8
S8P3[003S8R/00:/0X`2[00:R8b8R:b8J8R/S0>/00?<d=400m400m3<[003[0><00>8S:`00Z`2S009
c:b/R:b<R8b800:<00S<[:b/c=3Ad0;e00?amOD00_D2l@03mO7e00We0_400m7em@0=m@;a00?AlM00
0j`00hQXA008A0=X00F8S:c@l@04m@03nOGe00ke0]000lb/[008[006d?GemO7e0]001Jb<R8b8009X
00=4J4@00fP00hQ4A002J003R6QX00AX00A4R:b81FP2R0:<00B8S8b/0XP00hb/S002R0F/00><c=00
0m001=7@d<`2[005R:c<d?400_D01_7edO7ed@?@00Gad=7<d002c0O@00WAd=3@dO7elOD00m02[0C@
00?AmOD01_D3l@03mO7A00C@00OAlO7Ac8b8009X00=4J6P02d@00bA4A002A003J4A400=400EXA4A4
9003A0=X0XP2J003R8b/00:<0VP01HR<S:b<00J82fP2A003J4AX00IX00B8S8R/0XP00hb8S004R09X
00=4J6P00VP2A003J4A400=40VP00dAXA002J09400=XR8P00X`2[005S:b/R8`00hP2S0>800B<R8QX
1HP3J0:800><R8`00X`00hR/[003R0:<00B8S8R<18P2S0:800><[8P00XP2S003R:b<00:800AXR8R<
0hP2S004R6R<S0:800F<[8b<[002S0>800F<[8b<[002S0:/0H`001=400<TA2@034@290A400@TA4@T
2D@00bA4A00291a400<TA4@034@00bA4A007A0<T0T@390I400=XA4@034@8J0>80X`01:b8R8P3S006
R8b8R:b<0hP02hb/R8R<R6R8J8R/00R<00>/S8`00XP01:b8S8`2R008S:b<S8R/S:`2S0N800J<R8R<
R8`3[004d=7@d@?@1Z`00hb8S004[003S:b/00:/00B8S8b80X`01:c@dL`4d0;a5OD2l@03mO7e00ke
0_401Zc<[:b8J0A400@TA6Q416P2S003[=3@00Ce00?imOD03?D2d@?@0Z`00hb/[005[003c=7a00?e
00kadM3Ac8b8J8QXA8QXA09X0d@3J004A6Q4A0=X00>8J4@00d@4J0B800><J4@00hP01VR<R:b<[0:<
0j`2c007d=7@[<b/R003[006dO7elOGA0_400oG@d@03d@?@0/`00jc<[003d003c=3@00;@0_43m@?@
00?<d=000]000lc@l@07m@04lM7Al@;A00W@lM3adO7Ad:`00XP2J19400=XA4@00T@2J0I400@TA6QX
0hP00fR8R002R003S8R800:818`01Jb8R8R<00=X00>8J8P00VP01DB8J6Q4009X00F8J6QXR003J0F8
18`00hR<R005J003A6QX009400=XA4@01d@2J003R6QX00:800J<[:b<[8P2S003[8b800:80X`2R004
J8R8R09X0hP4J0B800F<R:b8[002S004R8b<S0:/00>8S8`00X`00jb<S002R003S:b<00:800><R8P0
0X`018R<J6P5R005J8R8R8`00XP2S0:/0X`3[0:<00>8[:`00Z`018b/S8`1[00034@00bA4A005A0@T
4d@00bA4A00;A00394A400I400<TA2@00d@012A4A2@CA00394A400=400<TA2@01T@290A400@TA2@T
1D@00fQ4A00=A0:800J<R6QXR6P2S0>800F/S8R8S006R006[8R<S8R/0hP00hb8R002R005[8R<S:`0
18`00jb8S002R0:<00F8[6R<R003[007R:b/[8b8S005R004[8b<R0:<0j`2d006dOG@lM3<2J`01Lb/
[:b800><00B/S8b<0XP01Jb<[:c<00?@00Oed?Gad?Ga00ge00KamOGamO42m@05lOGimOT00_D01OWe
mOWa00;e0_401M7@d:b<00:800=XA4@01T@01FR8S:b<00:/00G<mOGen@0>m@;@00KAd=7@[8`2c003
d:b/00:/0/`01M3emO7e00;A00C@dM2/18P00fR<R002J0=400>8J6P01D@00hQ4A003A003J4A400E4
00AXR8aX0T@00hQXR003R0:/00><[8`00Z`2S0>/00O<[:b/R8b800:/00C@lM7e1=401=3AdM43d0?<
00B/d<c@0Z`5d003mM3A00;A1=001Lc@d=3<00;@00CelOGe0_400oGad@05d004mM7ed@;@0Z`2R09X
00=4J4@044@00bA4A007A08T0d@2R003J8QX00J800=XR:`00XP2S00@[8QXJ8QXR6R8S6Q4J4AXA0AX
00F8J6QXR003J0B800><[8`00hP01FR<R6R800=400=XA4@00T@4J0=41fP2R007S:b<c:b8S002[004
J8R8R0:/0XP00fR8S003R0AX0XP016R8R:`3J003R8b/00:800J<R8b8S:`2S003[8R/00>/0XP00hb/
S006R003[8b/009X00>8J8P018P016R/R8P2S007R8b<S:b<d002[004S8R<[0:<00>/S:`00Z`001=4
1B@2A08T00=494@04T@016Q4A2@2A00394A4008T1d@29003A2@T008T5d@290a400@TA4@T34@00fQ4
A008A09X00=4J8P00XP2J0J800B/R8b80h`02HR<R8R/R8b/S002[0>81H`2[003S8R<00><0hP02:b8
R8b/R:b80X`01Jb8[:b<00:/00F8S:b8S003R0:<00F8S8R/S003[004d=7Am@;@00?<[:`00j`018b8
S8`4[0:<00>8[8`01XP00hb/d005d003dM3a00;a00?edO403?D00m7em@03m@03lOGe00ge00GadM3A
d002[004R4A4J0I40VP4S0;<00?amOD03_D3d@07d:c@d<c@c002d0:/0m001Lc@d?7A00;e00?Ad?D0
0]400jb8[005R006J4AXJ8b80VP2A0=X00=4J4@034@018QXA4@5J008R:b<c:b<R:`2R0N/0X`02Jb8
[<cadO7@l@02d@03d=7A00;A1M001:c@d=02[003d?7@00;@00?ad=000]02c003d=7@00?@00?<d=00
0_401?GalM43l@;@00G<d=3ad@02d004dM2/[0B800=4J6P024@01FQ4A4AX00M400@TA4AX1d@016Q4
J8P2J0:800AXR8QX18P3S0:826P00dAXJ002A09X00B8J4B80VP4R005J8b<R:`00XP2S003R6R800>8
00AXA6QX14@2J0940VP00dAXA005J004R6R<[0:<00R/R8R8S:b8S0>800><R8P01HP01VR8R8QXS09X
0hP2J007S:b/R8b8S002R0><00>/R8P00X`3R004S8R<[0>800F/R:b/S006R003J8b800B81:`00hR/
S005[0:<00>/S8`00X`4[00014@290A400<TA4@04T@012A4A2@6A00394A400E400=XA4@00d@00bA4
A009A00694@TA2A40R@GA00394A400=400<TA4@024@00bA4A00;A00394A400U42VP4R003J8R<00F8
00=XR8`00h`00jb8R002R09X0XP01Zb8R:b<R0:<00B/R8b/18P01hb8R8b8S:`00X`3[0B<00>/R8P0
0XP00hb8R002S0F/00C<d=3A0]02c008[8b/[8b8S<`2[004c:b/[0:800EXR8R8J003R0:/1M02d@;a
00GAlO7Al@0;m@07lOGelOGad@0>m@03lM7A00;@00?<S:`00XP3A003J4AX00AX00>8S:`00Z`00lca
m@02m@03nOGe00[e00?amM401]000o7@d002[005d<c@d=400]000m7@d@02d007dM3elJc@[006R0=X
00>8J6P00VP018Q4J4@2J0]400<TA4@014@00fQ4A002J0:<18P3S0>80Z`00m2/[002[003R:c@00G@
00SAd=7Ad=7@c0F/00?<[:`00Z`2c003d<c@00>/00?<[=400]001<c@d=43d009dM3AlM7@lM7a00C@
00?<dM000]02[0:<0hP2J003R6QX011400=XA4@014@00fQ4A004A003J8R8009X0hP02FR<S8R/R8b/
S006R0=X00E4J6R8J002A004R6R8R0IX00B8J8R818`8R003J8Q400AX0T@016Q4A4@2J003A6QX00=X
00>8J8P00VP02:b<[8b/R6R80X`6R003J8R800:800EXR8R8J003R003J8R800:800N<R8b8S8R<00F8
00EXR8b8[002R003J8QX00V800R<R8R8J8QXR09X1HP3[0:<0Z`00hb/[002S00:[8R<[8b/R8b/S0:/
0002A00394A401]400<TA4@034@00bA4A008A00494A4A08T1D@00bA49002A00594A4A2@03D@00bA4
900NA003J4A400]41fP3R003J8QX00>800AXR8b<0XP2S003R6R<00:<00B/S8R81FP01:b<S8`4R003
[8b800F80h`3R0b/00B<[8b80VP4R003S:b<00:<00C<d<c@0/`2[004S:b8R0>/00O@[<b/S8R/00V8
0Z`7d0;A0_401=3edO46m@04dOGel@;e00CamM3a0m49m@04lOGel@;A00G<d:b/S002R005A2A4A6P0
0T@2J008S:b/[=3Ad=4Bm@;a00GAlM7@l@03d003c=3@00:/00G@[:c<[002d005lM3@dO400m000o7@
d002[0F80X`3J003R6QX00=X00A4J4@T1d@00bA4A006A0AX0hP00fR8S002S0:800AXR:c<0j`00hb8
S008d0;a0]42d003S:b/00B/00><[:`02:`00lc@d@02d0:/00?<dM000]000oGam@02l@06d=7AlM3a
0]001Jc@d=2<00J80VP00dAXA00BA003J4A400=400AXA4AX0T@01FQ4J6R8009X00>8J6P018`2R0:<
1HP2J003R6Q400>81VP018QXR6P2R0=X0XP018b/[:`2S006R8b8R6R80VP2A0AX00I4J4A4J4@2J003
A6Q4009X00>8J8P00XP00hb/[002[003S8R800:800><R8P00h`018R<R8`5R003J8R800:800><J8P0
0XP2[005S:b<S:`018P00hb8R003R0>/2XP01Xb8R8b8[0:800Y4J:b<R8b/S<b/0X`5[0:800F<R8b<
c007[00014@012A4A2@<A08T0T@390=400<TA4@05T@00bA4A00:A00394A400=400DTA4A49008A003
J4A400=400<TA4@00d@01RA4A4@TA08T5d@012A4A2@5A004J4AXR0AX00>8J6P01XP01Hb8R8aX00>8
00><R8P00XP01Zb<R6R<R09X00><R8P03XP00hb8R002[003R:b/00:/0X`03:c@[8b/S8R<R6R8J0:8
00AXR8R<0Z`00lb/d002R004d<b/[0B<00G<[:b/S002[0><00>8J8P00XP00hb8S002[005d<c@d<`0
0m001M7@lM7@00;a00?AmOD00_D01_7elO7ed@;e0]401O7@lOGA00?e00?imOD01_D00m3ed002[003
R:a400A400IXA4A4J:`2R006[=3AlOGA0oD01?WemOT2m@03nOGe00Ce00[amOGamM7edM3e0]02c003
d:b/00:/0h`01Jb<d=3A00C@00CAmM3A0/`2S003R:b/00:<00>8[6P00X`2J003R6Q4009400<TA4@0
0R@5A005J4A4J4@01FP00dAXJ003J009S:b<S6R8[8b800><0hP8d003lM3@00;<1J`018c<S8`2[0:<
0XP01:b<[8`5d0?<0m001]7emOGam@;a00[@mM3ad?7@c:b<1XP00hb8J006A003J4A4009400DTA4A4
J005A003J4A400=400=XA4@014@3J004S6QXS0:800B<R:b/0hP01FR8R6R8009X00>8J6P00fP00hQ4
J004J004R6R8J0:80VP4R006[8b<R8b/0XP00jaXR003J0940fP00dAXA004A007R6QXJ8QXR002J0:8
0Z`01M2/[:b<00B800IXR8R8c8`2R003[8R800:80fP4R006J8R8S:c@0h`00jb8[003R09X00J8J8QX
R8`2R0:<0j`2R004J:b8S0:80X`01fR<J8R/R8`01:`01Hb/S8c<00>/00B8[:b818`2R003[8c<006/
0007A00394A400=400<TA4@014@01BA4A4@T00940b@3A00394A4019400<TA4@00d@00bA4A002A003
94A400I400<TA6P02T@00fQ4A006A08T14@012A4A2@3A00394A400A400<TA4@04D@00fQ4A002A003
J8QX009X00B8J6QX0h`2R003[8R<00><0fP2R005[8R/[8`00XP00jb8R003J0F80Z`7R003S8R<00B<
0j`00lb/[002d005[8R<[8`00XP00haXR006R007S:b/c:c<[002c003[<b/00>/00><[:`00j`5S0:8
00><R:`00XP2[004c=3<c0?@00?Ad=000]001M7@lOGa00?e00Cad?G@1O401=3adO4:m@03lOGe00;e
00Kad:b/R8`5A005J4A4A8P00X`2[003lOGe00?e1OT01OGinOGi00We00GamM3@d@02d003[<b/00:/
00B<[:b80h`00jc<c002[007c=3Ad?G@d@02d0:/00?<[8`00X`01HR<S:b<00:80VPDA003J4A40094
0VP01hQXJ8R<R6P01HP2S003R6QX00;@0]43d0;A0]04c0>/00B<[:b<0j`00hb8S002S0:/0]000m7@
d005d0;A00?elOD00o43d@06d=7@d<b<0XP00fR8R002R004J8R8J0I400=XA4@02d@00bA4A004A003
J4A4009400AXA4AX0hP00jb8R002R003S8R800=X18P01FR8J6R8009X00>8J6P016P00hQXJ004J003
R6R800J800><[:`00X`3R004J8QXJ0=40VP6A0UX0hP2S0:/00O<[8R8[8R<00:80X`2[003S8R800:8
00><R8P00fP00hQXR004R0:/00B8S8R<0Z`018b8R:`3R003S8R/00:/00N<R8b/d:b800:<0XP3S004
[8b<S0>800B<R8R<0j`01hb8R:b8[8`00j`2S0:800><[:`00X`1R06<0004A00394A400I400<TA4@0
1d@00bA4A009A00394A400e400<TA4@014@00bA49005A00394A400E40R@DA00394A400M400<TA4@0
54@00bA4A009A007R6QXJ4AXA002J003S:b<00F80X`00hR<R004R004J8R8R0=X0XP2J0>800J<R8R<
[8P2S0>800UXS6R8S:b<[8P00Z`018R/R8`2[004R8b/S0J800F<R8R<R002S0;<00>/d=001=04[003
S:b<00:/0X`2R0:<18P00hb8J005[0;@00?<d=000]001=7@d=04l@;e00?adO401O42d@Ca2OD00o7e
l@03m@03d8b800:82D@2R004S:c<l@?e0_T4nPKi2?D00o7Al@04d0:/00O@lJb<[8b800><00>8S:`0
0j`01Lc@dM3a00;A00CadM3A0Z`00hb/S002S006c=2/S8R<0VPAA00394AX00=41FP00dAXR002J0F8
00J/S8QXR<`5d0;<00G@c<b/d002[005S:b/S:`00X`4R003[8R<00>/00K@c=3@c:`2d005c=3@dO40
0_D00m7ad003d0;<0Z`018R/R8P2J0J80VP00dAXA00;A003J4A400Y400EXA4A4R003J0>800F/R8b8
J005R0]X0hP4J0B816P8R003S:b/00><0VP2R0=X2D@7J003R6QX00=X0XP2S003[<b/00>80X`00hR<
R003R003S8R8009X00J8J6R8J8P3J0N800B<R8R<1HP00jb<R004R0:<0XP3S0:80h`01:b8R:`5S003
R8b800><00>/S:`00j`02Hb8R8b8[8R<R003[003S:b<00:80005A00394A400Q400<TA4@01d@00bA4
A007A006J4A494@T3D@00bA4A00CA00394A401=400=XA6P094@2J004A6Q4J0940fP00hQXJ004R005
S8R8S8P00X`01:b<R8`2J0:800><R6P00fP00hR<[003R0:/0X`2R005S8R<S:`00XP018b/[:`4S003
[8b/00:<00>8S:`018P01FR<S8QX00:800><[8`00Z`01m3<c=3<[<`00Z`01HR/S:b<00>/0X`018R/
[:`3R0:<00B8S8b<0Z`2c0G@00?amM001=401_7edM7el@?A0_43m@04dO7el@Oe00CamOGa0oD2[0:<
00=XA6P00T@2J003A6QX009X00>8[=000oD01?WenOT3nP04nO[in@Ge00?amO400_D00o7Ad002d0Z/
00=X[8P00hP2S0:/1=000o7Am@02l@;@00_<d<b<[<b/d<c@[002R003S8QX00e400@TA4@T1T@016Q4
A8P5J0B80X`01HR<S:c<00K@00K<d=3@c=04[004S:b/[0:<0hP00jb<R002S004c=2/c0>/1=02d@?e
0_42d@;@00C<S:b<0Z`00hQXJ002J004R8b8R09X1D@016Q4A2@:A003J4A400A400=XA4@00d@00fQ4
J002R003J8R800>80VP00hQXR006R005J4AXJ8P00fP2R09X0XP3S0^800><[:`00h`2R09X0XP5J0A4
0XP016R8R6P2R0AX0hP3S007R:c@[8R<R002[0:<00B8S8QX0XP00fR8J003A004J8R8J0:800N<R8R/
J8R/00:<0XP00jb<J002R0:/00B<[8R<0hP2S0>800R<R8R<R:b<[0:<0XP01Hb8R8b800F<0Z`00hb/
S003R0:<00B8[8b/0X`00jb<R002S0001D@00bA4A00AA08T0d@00bA4A00;A003J4AX00A400<TA4@0
24@00bA4A004A08T0T@00bA4A00GA003J4A401a400=XA4@02D@2J09400AXR6R<0fP8R09X0hP00jb<
S004R09X18P018b8R8P2S005[8b<R8`028P018b/R8`3[007S:b<S8R<[003R003S8R<00J800><R:`0
1J`01<b/[8`3[005R:b/S:`00X`00hR<R002R004S8R<S0:800R/S:c<d<c@c0K@00CAd=3a0]401_Ga
lM7ad@?a0_D00o7el@02l@03mO7e00_e00GA[8b/R004A004J4A4A0AX00>8[=400oD01_WjnO[inP?i
00?enOD01_D4l@04d=7<[0;<0Z`048b/[:b<R6R8S8R<R4AXR:`3d00:dO7emM7ad<b/d0F/0]03[0:8
00B<R6QX0XP00fQ4A009A00394A400U400IXR6Q4J8P3[0:80X`2[0;@00>/d:`00Z`01]2/c=3<[0:<
00>/S:`00Z`01Hb8S:b<00>800N<R8c<S:b<00:/00S@[=3@lM7el@;e00?adM400]02[0:<1HP016R8
R:`2R0=X44@00fQ4J00<A005J4AXJ8P00fP2R005J4AXR6P00XP00fR8R002R0AX00^8J6QXA6R8J8QX
R003J0B80VP00hR<S002R006[8b<[8R/1XP016Q4J8P3A0EX0XP00fR8J004J003R6R<00:/00>8[:`0
0hP00hb8R005R003S8R800>81FP:R003S:b<00>800F<R8b/S002R005[8R8R:`00XP00hc<S005R0><
00>8S8`00XP3S006[8R8S8R<0j`2S004[8b/S0:80h`2[0J<000EA00394A400=400@TA2@T3D@00fQ4
J004A00394A400e40R@2A00394A402Q40R@;A003J4A400a40fP2A09X1hP018b8R8`3R005J8R8S:`0
0X`00hR<S002J0F800><R8`00X`01Jb<R8R/00:800F/R8b8S002R005S8R8[8`00j`00hb8R003S0>8
00N/R8R<J8QX00>80j`01=2/[<`6[005R8b/S<`00X`00jb8R002S0:80Z`028R<R8R<[=3A0/`3d003
c=3@00C@00_Ad?7adO7Ad=7@d@02l@04dO7Al@;e0]400o7em@07m@;A00B/S:b81D@00fQ4J004J003
S=3A00?e00?in_X00_T01?[imOT9m@04lOGAl@;@0Z`018b/R:`2S003[8R800=X00>8S8P00VP00dB<
S002d003dM3a00;a00?AmM400m02c0>/00C@c:c<0Z`01Lb/R8b/00:<00IXA6QXA6P2A003J4A400Q4
16P00dAXR003J0>800K@[8R<[8`3[003S=3@00:/0/`4[005S:b/[8P00Z`3S004R8b8R0:<00B8[8b<
0Z`02<c@d<c@c=7@0_401?GAlO42d009S:b<[8aXR6R8009X18P00haXJ002J0e40VP2A003J4A400=4
0R@4A09X0T@00hQXJ002J003R6Q400=X00>8J8P00VP01HQXR6Q400AX00>8J6P016P018QXJ8P2J003
R6QX00>80Z`3R004S8R<[0:<00>8J8P00fP00dAXJ002A0=X00E4J8R8S004R003J8QX00:800B/c8b8
0Z`2S0B80X`018R<[8`5R0IX00B/R8R<0hP00fR8R005R003S8R<00:<0XP03Hb8S:b<R8b8[<b8S8P0
0h`01:b<S:`4R003S:b800:<00>/S8`00j`00hb/[002S0:800><R:`01H`3[06<0005A00394@T00A4
00<TA4@01D@012A4A4@29003A2@T008T00=494@04D@00bA4A00=A00494A4A08T34@00bA4A002A003
94A400E400TTA4A494@TA2@00T@00bA4A003A00394A400M400>8A4@03T@00fR8J002A003J4AX00F8
00><[8P00hP01FR8R8R<00>/00B8J8R80VP6R003J8R800>800><[8`00X`4R0:<00J/S8R<[8`3[003
S:b800:80h`00hR<S005R003J8R800B/00?<[<`01:`00lb/S002[005S:b<S:`00h`00jb8S002R0><
0j`00m3Ad00<d0;a00KAd=3Ad=43d003lM7A00Ce00?Ad?402OD00o7A[002S09X1d@3J004S:c@d@Ce
1_T9m@07lOGAmM7ad002[0B<00>/S8`00hP7J09400=XS:`00m02l@?A00_ad=3@c=2/c=2/c004[004
d8b8S0>816P2A003J4A400a400AXA4A41VP018R<R:`3R005S:b/[<`02:`01Xc@d=2<R0><00B8S8b<
0hP01Hb8S:b800:<00>/c=000]001Lc@c=7a00;e00KadM2<R8`2[0:800EXR8QXS005R09X00=4J4@0
1T@00fQ4A002A003J4A400i400=XA6P026P00dB8R002J003R6QX00B80fP01dAXJ6R8J4@016P00dAX
J002R0EX0XP00jb<R002R004S8R8R09X0XP01fQ4A6Q4J4@00fP00dAXJ002R003S8R800EX0XP00hb/
[003[0J80h`2R09X00>8J4@01VP3R008J8R8S8QXR6P;R00:[8b8S8R<R:b<[0:<00>/S8`00XP018b/
S:`4R003S8R<00B80X`02Jb<S:b8S8R<R003[004S:b<R0>/0X`000Q400<TA4@00T@00bA4900<A003
94A400E400<TA4@06d@00bA4A009A00394A400Y400<TA4@02T@292=400AXA4AX14@2J0J800>/S8P0
0XP01Xb8R8b8S0:800=XR8P00VP00hQXR007R003[8R800:80X`01Jb8R8R<00:800><[8`00XP4[003
S8R<00:/00><R:`018P00hb8R002R003S:b<00:/00G<S:b/S004[004S:b<[0:80h`2R005[8R8S:`0
0hP3S003[=3@00c@00KAd=3Ad=45d007mM3alOGam@03l@Ge00?amOD00_D01]6/S8b8J0=400AXA4A4
0fP018b/c?45m@Ci00?enOD01oD00m3Ad003d0>/0X`01:b<[8`4R0=X18P01FQ4A4B800?@00?Ad=00
0]46d00;c=2/[=3<[8b/c8`00XP4[0:800AXA4AX0T@4J003A6Q400A400=XA4@00T@01FQ4J6R800=X
0XP2J0:80Z`01XR/[8b8c0>/00N<[<c@[8b800:<00>/R8P00Z`4S0:80Z`2R008[<b/[<b/c=02d@?a
00?<[8`00fP3R003J4B8009X0XP5J003A6Q401m400AXA6R80fP00hQXR002R003J8QX00AX00B8J6Q4
16P00hQXJ006J003R6QX009X00>8J6P00XP2S0:800B<R:b80fP01hQXR6Q4R6P00T@01FQ4A4AX00:8
00AXR8R81fP2S004[<b/[0:<18P00hb8R003R003J8QX00A40fP018QXJ8P3J0J800B/S8R<0hP00hb8
R002R003J8R<00:<0XP3S0B800F<[8b8S002R0:<00>8[8P00Z`018R<[8`4R0>/00R8S:b/dLb8S0F/
0002A00394A4008T00=494@00R@01D@TA4@T00M400<TA4@06D@2J11400<TA4@01D@290]400DTA4A4
9009A00394@T008T2D@00bA4A00EA003J4A400A40fP2R005J8R8R8`018P016R8S8`2J0:80fP2R006
J8R8S:b<18P3S006R:b/[8R<0XP018b/[8P2S004[8b/S0:800><[8`00X`018R/R8P3S004[8R/S0B/
00C<[:b<0Z`02hb/[8b8S:b8[8R<00B800B<R:b/0XP00fR8[002[0G@00?Ad=003m000o7Ad@02l@05
dOGalOD00_43m@;a00S@lOGelM7<[0:800=XA4@01T@2J003R:b/00Ce00?imOT00_T00oGim@08m@06
lM7@dM3<0j`00hb8S002S008R6R<R6Q4J4@3J003S8Q400=400>8[=000m401=3AdM47d006c:b/[8b8
0h`01XR<S8R/S0:800IXR8QXR6P3R003J8QX009X00A4J6QX0d@016Q4A4@2R09X0XP2J004R:b<R0:<
00>/S8`00Z`02HR<S8b8S:b8[003S003R:b800><00V8S8b<R8b/R8`00j`3d0;a00KAmM7@c=03S005
J8R8R6P01HP3J0=416PCA08T1d@00bA4J003J005R6Q4R6P00XP4J007A6QXJ8QXA009J0:81FP00dB8
R002J0F80VP018R<S8P2J007R6QXJ8QXR003J004A6QXJ0:80VP00hb8R002R008J8QXJ8R<R:`2S004
[8b<[0:<0hP01Zb<[8aXR09X00=4J6P016P01HQXJ6R8009X00F8[8b<R002S0:80Z`00hb8R004R004
J8R8R0:<00>8S8P00XP2S005[8R8R8`01hP00jb8S002S003[8QX00>818`01XR<[:b<R0B/0H`00094
00<TA2@00T@2909412@00d@TA008A00394@T00=400<TA4@08T@290U400<TA4@06D@291m416P2A09X
00=4J6P00VP:R006J8R/[8QX0XP3J0:800><[:`00XP018b/R8P2S0:/0X`00hR<R003R003[8R/00:8
00J<[8b/S8P3S0:800><R6P00h`01HR<[:b<00:/0X`6[0:<0Z`3S003[8R/00:/0X`018R<S8`2[00:
R6QXS:b<[<c@c0K@00?Ad=001M02c0C@00CAd=7@1?401OGalM3A00;a0m42m@05lOGA[8P00fP6A003
J4A4009X00>/d?D01?D3n@;e0_T5m@;a00?ed=401=000jc<S002S003[8R<00:816P01HQXJ6R8009X
0T@026Q4J6R/d=7a0m001M7@d<b/00;@0j`02Xb/S8b/R8b/R:`2S0B80X`2J0B800=XS8P00VP00dAX
A002J0=400=XA4@026P00hb8J003R003[8b/00:/00F8S8R/R002S005R8b<R8`00XP01Jb8S8b800:<
00>8[8`00Z`018b/[:`2d0;A00?ad?400]04[00:S:b8J8QXR8b8S0>800AXA4A416P5A003J4A400A4
00=XA4@04D@3J005R4B8R8`00XP5J003A6Q400IX00Y4J4AXR6R8J4B826P6R006J8R<J8R<0XP016Q4
S4@2R003J4AX009X0hP016R8R6P3R0=X00J8J8R<[8`3[004R:b/S0:800F<[8b8S005J0:800=XA6P0
0fP3R09X0Z`028b/R6R/J8R/18P01:aXR8`4R003[8R800:800F/S8R8[002R003J8R800:80X`01:b<
[:`3S005[8QXJ8P00Z`018b/[8`7[07<0J`1S0000T@012A492@4A00794@TA2A4900;A00494A4A08T
24@2909400<TA4@04T@00bA4900CA00394A4015400<TA4@014@01FQ4A4@T00i400=XA4@01D@3J094
00>8J6P00hP00fR8R002R004S8R8S0:800=XS8`00XP2J004R6R8S0F800AXR8R80h`00jb<S003S0>8
0j`2S003[8b/00:/18`01HR<[8R<00:80X`2R005[8b8[8`00XP4[004R:b/S0F/00><R:`00j`018b/
R:`2S004[8R<R0>/00F<[:c<[005d003dM3@00K@00?ad=000]001=7@dM45l@04mM7Ad@;a00GAlM7a
d002l@05dJb<R6P02D@2J004R:c<d@Ce1?T9m@06dOG@d<c@0/`01:b8[8`2[0:816P2A0EX00>8J4@0
0T@01BA4A8R/00C@0m400m3Ac002d0N/00J8S8b8S:`2R09X0X`3R003S8R800:800=XR6P016P9A003
J8QX00AX0hP2J0><00J/R:b/S:`3R003S8R/00B800><R8P00X`3R0><00N/S8b/S<b/00O@00O<d:b/
S8R/00:816P00hR/J003R006J4A4A6Q40VP00dAXA00AA003J4A400U400=XR6P00VP4R09X00>8J6P0
1FP00hQXR002J003R4AX00AX0XP4J005R6R8R6P028P2S0>80fP00hQXJ002J004A6R8J0:816P2R0=X
0hP2S003[8b<00:/00F<[8R/S004[0:800>/S6P00fP3R004A6QXR0EX00>8S8P01XP01Hb8R8QX00:8
18`00jb8S007R003J8b800B800=XR8`00X`00jb<S002[004S8R<[0:800F<[8b/S002R007S8R<R8b/
S003[0000d@00bA4A005A00394@T009400<TA4@024@290=400<TA4@024@00bA4A00CA08T6d@00bA4
A00CA0=X0T@00bA4A008A09X2D@3J09400IXA6QXR6P3R003J8R800B800B<R8R80fP5R004J8R8J0R8
0X`00hR<[004R0F<0j`018b/S:`3S004[8b8R09X0XP00jb8S002R003[8b<00F/00F<R:b/S004[004
S:b/S0J/0XP2S0:80h`01HR<S:c<00K@0Z`;d005dM3AlOD00_401oGamO7AmM000m42l@05d=7adJ`0
0XP01VQ4A6Q4J09400QXA4AXR:c@d@Ge0_T00oGim@05m@06lOGAd:c<1j`018R/[8P2J004R6QXJ0E4
00EXA8R<J005A006J:c@c=3A0]001O7Ad<c@00>/00>8[:`01H`018R/S8`3R004S:b<S0:800><d:`0
1FP6A003J4A400941fP00dAXA003J0:80Z`01XR/R8R/J0F80X`2R004J8R<S0R800><[8P00Z`00lc@
d002d004[=2/[0:800>/R8`00hP01haXR6R<J8P00fP00hQXA003J003R6QX00U400=XA4@04T@00fQ4
J002J003R6R800:81fP00hQXJ002J006R6QXA6Q416P2R003J4AX012800=XR6P02fP018QXR6P4R005
J8R<S8P00X`2[0:<0Z`00hb/[004S003[8R800:800F<J6Q4J002R09X00>8J8P00XP02Hb8R8b8S8R<
J004R003J8R800>800>/S8`00XP00hb8R006R004J8R<J0:800F<R8b/S005R003[8b800:800V<[8b/
R8b8S8P00X`3R003S:b<00:/0009A00394A400A400<TA4@02T@00bA4A002A00394A400I400<TA4@0
2D@00bA4A00>A00394A4015400=XA4@084@01bA4A4AXA6P02D@4J003A6Q400QX00>8A6P01HP5J0:8
00AXR8QX1HP2S003R8b800:/00><R8`00h`00jb8R002S0:80X`00hR/[004S005R8b<R8`00VP4R008
[8R8[<b/S=06[0B800>/R:`00h`018R<[8`2[003R8b800:<00>8S8P00Z`00hb8S003d004c:b/d0:/
1]001<c@d=02d@03c=3@00CA00?edOD01?402M3edM7@dO7@S002R0=40fP4A09X00B8[=3a1?D00oWe
m@0:m@03dO7@00:/00?<[:`01:`01XR<R8QXA0:814@2J09400AXR6QX1D@018R/d=02d@;@00OAd<c@
c:b<00>/00><[8`018P00jb<R002S004[8b<[0:<00>/R8`00XP2J003R6Q400=X0T@01VQ4A4AXR09X
0T@01fQ4J4AXR6P01XP2J005R6R8[8P00VP3R003J8R<00B800J<R8R8S8P2S0>/0]000o7@d002[0:8
00F<R8b8[003R003S8R<00=X00F8J6Q4J003A004J4A4J0U400<TA4@02d@01VQ4A4AXA0EX00>8J8P0
0XP01VR8R4AXA09X00>8J4@016P018QXJ8P3J003R6R800EX0XP2S0:800><R8P018P00fR/J005R003
A6QX00]X0hP00jb8S002S004R:b/S0:/0X`018R<[8P5S0:800=XR6P00T@4J007A8QXR6R8[003S0:8
0VP00hR<R002R004J8R8R0><00>8J8`00XP018b8R8`2R09X00>8J8P00XP2S008R8b8A8R<R8`4R004
[8R<[0:<00F/S8R8[004S004[8b/[06<000=A00394A400Q400<TA4@01D@00bA49004A08T6D@291I4
0fP4A00394@T00I400DTA4A4J00@A00394A400=400AXA4@T1T@3J09400=XA6P00VP2R004J8QXR09X
18P3J004A6QXR09X0XP016R8[8`2R0><00N8S8R/S8R/00:800F/S6R<R002[004S:b<S0:800B<R8b8
1H`5R006S8R8S:c<0XP5[003S8R800F800>/R:`00Z`2S0>/00N<R8b<R:b<00>/00R<[:c<d<b/d0;<
0j`01=2/d=02[0[@0]401M3alM7e00?@0]400m3<d002d004S6QXJ0A400=XR8P016P018R<d=43m@03
nOGe00We00KamO7ed<`6[008c:b/S8QXA6P2R0M400>8J6P00T@03BA4A2A4J8R<c=3Ad?400]401lc@
d<b/c8`00j`01Hb8J8b800:<0hP01Jb<[8R<00:800><R6P00VP00hQXJ002A0IX00A4J6R81D@2J003
A6R8009X0XP014AXJ4@4J003R6QX009X1HP01Zb8J8b8S0:800N/S8R8[8b/00;@00?AmM000Z`00hQX
R002J0:816P01jb8J8QXR6P06T@290A40VP3A003J4AX00QX00>8J6P00fP014AXJ4@4J003R6R8009X
00>8J6P01FP00hQXJ003J0N800EXR6R8S002J007R6R8J8QXA002J003A6QX009400IXA8QXR8`2R004
S8R8S0:/00F<R:b8S002R004[8R8J0:<00>/S8P00XP00fR8R004J003A6QX009X00N8J8R<R8b8009X
0hP00fR8R009R004[8R8R0><0XP02Xb8R8R/R6R8[6P4R0B<00j8S8b/S8R/S:b<[8b/S0:/00><[8`0
0j`1S06/0006A00394A4009400DTA2A49005A00494A490E400@TA2@T7d@391I400>8[6P01D@390I4
00<TA4@03d@00bA4A005A003J4A400M40VP5A09X00>8[6P00XP00fR8R006R0AX00B8J6QX0XP016R/
S8`2R0><0XP016R/R8P2S0:80h`3R0:<1HP2S0:80h`5R004J8R8S0>/00N8S:b<[8b/00B<0hP00hb8
[004[0:<00Z/S8b<R8b8S:b<0j`00m2/d002d0;<00B/d=3<3=000lc@d002d0;A0o400oGad@02d003
mM3@00?@00B/S6R<0XP016Q4J8P3J004A6QXR0:/00?AlOD00_D00oWem@0:m@06lOG@d:c@0/`01Jc<
[8b/00>800A4J4AX1d@2J0E412@2J005R=3AdO400]400lc@[007[004S8QXR0:/0XP2S003[8b/00>8
0X`018QXJ8P3J09400=XA6P00VP00hQ4J002J0Q41VP2A004J4A4A0UX00>8J6P00VP01HR/S8b/00:<
00J/S8b/S:`2c005d:b/[8P00VP018QXR4@2R0YX1T@00fQ4J008A00394A400]40VP6A0IX00=4J6P0
0XP2J003R6Q400=X00=4J6P01XP2J005A6R8J4@00fP00hQXR002R003S8R800B800=XR8`00XP3J004
R6R8A0EX00>8J6P00VP3R003J8R800>800J<[:b<[8P2S0:800R<R8aXR8b8S0>816P02DAXJ6R8J8QX
S003R003J8QX009X0XP00hb8R002R005J8R<S:`018P01Hb8R8R<00:800=XR8P00XP00hb/R002S008
R8b8[8R<R8`2R0:<00B/R8b<0Z`01hb/R8b8[8P01:`3S06/0007A08T0T@290M40R@3A00394@T0094
00@TA2@T2D@00bA4A00BA08T00=494@09T@00bA4A005A08T64@00fQ4A005A0=X00>8J6P016P00hR<
R002R09X0XP2J005R6QXJ8P00fP3R003J8R<00B800N<R8b<R8b800><0hP00hb8R002R0:<00B/R8R<
0XP00hb8J003R09X0hP2S003[8b<00:/00><R8P00Z`7S0F/00F<[8b<[003S003[8b/00F/0]001<c@
d:`3d003c=3<00?@00?<d=001=002]7@d=7@dOGAmO42d@;@00?ed=000]02[003S6R800:800EXR8R<
J003A007J8R<[=3Al@03m@03nOGe00Se00CamM7a0]000lc@c002[006R8b/S:b80VP00dAXJ008A007
J4A4A2A49002A00:94A4R:cAd=7ad0b/00B8S8b/0XP5[003R8b/00:/0hP2J0F80fP2R09400=XA4@0
0T@016Q4J6P5A0=X00=4J6P00T@016Q4A6P2R0=X00=4J4@00VP00hb/S002S0>800N/S8R/S:b<00>8
1FP2R008A6QXR6R8J4@2R09X14@2J0]400<TA4@01T@00bA4A00:A003J4A4009X00A4J4A426P01TAX
J6Q4J0>800F<J6QXR002J003R4A400=X00>8J8P02HP00jb<R002R003J8R800:800IXA6R8J4@4J003
R6R800J80X`01HR/[:b<00:/00><[:`00X`01Zb8R8b8[0>800=XR8P01fP00hQXJ006R004S8R8J0^8
0X`7R004J8QXJ0>80h`2R0><00>8S8P00hP3S0:80X`01Jb<[8b/00:80X`00jb8S002S0:/0007A0<T
2D@00bA4A00390E40b@01D@TA4AX01]400@TA2@T2T@00bA4A009A003J4A401540R@VA003J8QX00AX
1XP2J0:800=XR6P00fP8R004J8R<R0J<00B8S8R80X`016R8J6P4R0:/18P3S003R6R800B800J<R8b8
S:`4S003[8b/00N<00B8S8b<1j`01HR<S8b/00:<2J`Gd006lM7@dM3e0]02d@;@00G<d:b/S004R003
J8aX009X0d@01VR8[:c@d@oe00C@lM7A0j`00lb/[002S005[8b/S8P01FP6A003J4A400M40b@014AX
[:`4d003c:b/00;<1J`01Hb/[:b<00Z/00F<[:b<R002S0:80X`2R0=X0XP016Q4A6P3A09X00=4J4@0
14@2J0E400=XA4@00T@3J005S6Q4A6P00T@01XR<R8b/S0:800B<[8b<0hP8J0:800AXR6R80fP00dAX
R003J1A40VP>A003J4AX00=400AXA6QX0T@5J003R4AX00eX00>8J6P016P01HQXJ8QX00F800><R8P0
0XP2J0>800=XR8P00XP00fR8J007J0>800J<J6R/R:`2S003R8b<00:/00N<[8b/R8b800><00F8J8QX
R008J003A6Q400=X00F8S8b<J006R003J8R<00F80X`4R003J8QX00Z80X`01:aXR:`2R003[8b/00:8
00B<R8b<0XP01fR8R:b<R8`00hP2[06<0J`1[0000d@016Q4A4@29003A2A400E40R@3A00394@T00I4
0b@3A005J4A4A2@014@00bA4A00;A08T0T@290A41B@RA00394A4008T14@00bA4A00EA00494A4A0=X
0d@018QXJ8P2J0>800=XR8P00hP00haXJ004J003R6QX00=X00^8J8R8S:b<R8b/S002R003S:b800:8
00AXS8b80h`2[003S8R800B800>/S8P01HP03Zb8S8b8S8R<[8b8S8R<0Z`01Hb/S:b<00:/00B<[8b<
0Z`01hb/[8b/S:`00X`4[003S:b/00:/2M000jc@d00;d006dM3AlM3a0]001=7ad=02[003c:b<00:8
16P01DB8J6Q4009X00>8S8`00]0?m@03lOG@00;@0/`00m2/[002R006S8R<R8b80VP01DAXA4AX00e4
0b@2A004J8R8c0;@00?<[:`01Z`018b/[:`2S006[8b/[8b/0XP00jc<R003[005R8b<[8`00hP00hb8
R005R09X0T@2J09416P4A003J4A400E400IXA4AXA8P3A003R6QX00=X00N8S8R<[8b800:<0XP4J0=4
0fP01XQXA6R8A0=X0T@3J0a400<TA2@00T@290A40R@3A00694AXJ4AX24@00fQ4J002J004A6QXA0mX
00>8S8`00hP4J0:80fP00hR<S002R0:/0hP016R8R6P3R004J8b8R0=X00F8J6R8J002R003J8R800B8
0h`01:b8R8`3[004S:b8R0F<1HP00fQ4A006J004A6QXA09X00>8J6P01XP01FR8R8R<00>800IXR8R/
S8P3J0R800AXR:b<0XP01VR8R8R/S0>800><[8`00XP00jb8R004S0>800B<[:b<0Z`000I400<TA4@0
0T@00bA4A00IA00394A400A400<TA4@01D@290A400<TA2@01T@01RA4A4@TA0<T3T@290]400DTA4A4
900DA003J4A400a41VP00dAXJ003J003A6QX00N800><R6P016P00hQXJ002J0:800=XR8P00X`028R<
R8b8J8R/0X`3R0:<18P3S0J800>/R8P00hP00hb8R002R004S:b/S0:/00J<R8b8[8`2[004S:b/[0:<
0Z`00hb/[002[003S:b/00:/00B<[:c<1:`2c0B/1]000lb/d003d003c=3@00;@00_<d=3adOG@dO7@
l@02d003mM3@00?@00B/S8R80VP01dAXJ6Q4R6P00T@01VR8[<cad@?e00?imOD02_D01m3Ad=6/c:`0
0XP00fR8R004R004J4AXJ0i400<TA2@00b@3A003J:c<00?@00?<[<`00/`2[006R:b/S:b80X`01=2/
S8`2[008R8b8R8c@[8`2[003S8R/00:800J<R8R8J8P2J003R6QX009X0T@3J0E400=XA4@01d@016Q4
A6P4A0IX00B8J8b<18P00jb8J002A003J4A400I400=XA6P00fP2A006J4A4J4AX3T@00bA4A002A003
J4A400M40VP2A005J4A4A6P01T@01FQ4J6Q4009X0XP00dAXJ008J0:800B<[8b80VP00hQXJ002S004
[8R8R0><00B/S8R<1HP4J0>81FP5R003J8b8009X00>/R8P00hP2S004[8b/[0><0XP018b/S8`4R003
S6QX00AX00J8J6QXA6P2A0=X0X`2R00:S8R8R8b8S8QXR09X00B<R8R<0VP2R005S8R8R6P018P00fR8
R003R005J:b8R:`018P01Jb<R8R/00>80Z`4R003S:b<00:/0H`000A40b@3A08T00=492@00T@290A4
00<TA4@01D@00bA4A002A08T44@00bA4A004A00394A400I400<TA4@00T@00bA4900?A00394A400M4
00<TA2@00T@29003A2A401I400=XA4@01d@01FQ4A6Q400]X0hP2J005R6QXJ8P00fP00hQXJ002J0:8
00B<R8R<0XP00jb8S002R003S8R<00>800=XR8P00XP01Hb8S8b/00>800F<R8R/S007R00;J8R8[8R<
[8b/S:`00h`2[003S:b/00:<0Z`00hb/[002[004S:b/S0J/0X`5[0?<00G@[<c<[002c0S@00?Ad=00
0]001m7elOGAd?D00]001/c@d=3<d0:/0X`3R003A6QX009400=XA6P00VP018R<dM4Am@?A00?@[<`0
0Z`02hb8S8b8J8b/J8QX00I40R@6A08T00=492@00b@2A003J8R/00:/00C@[:b/0]02c008d:c<[8c<
[8`2[0:<0j`2S0B/00B8[<b/0X`00jb<S003R003J8R800:80VP4A0EX1D@2J09400=XA4@014@2J094
0VP00hQXA002J003R8b800:/1HP<A0EX0d@016Q4J6P7A00394A401U40fP4A003J4A400=400EXA6QX
A004J003R6Q400AX0T@4R0AX00R8S6QXR8b8[0>81H`3R004J8QXA09X18P2J0>800AXR6QX18P016R8
J6P5R0B/00F<[:b8S002R003S8R800:816P014AXJ4@3J0:800=XA4@00T@2R003S8R800B80X`00hR<
S002R09X0X`018QXR8P2J0>800=XR:`00hP2S0:80X`01Jb<[8R<00:800><[8P018`2R005S8R8J8P0
0X`2[0:<0J`000=400<TA4@01d@2909400DTA2@TA00290940R@6A0<T34@00fQ49008A00394A400E4
0R@3A00394A4015400<TA4@02T@012A4A2@RA09X1T@00fQ4J002J0>80VP2R09X00>8J8P00fP018R<
S6P4R005S8R<R8`00Z`00hb/S005R003S8R800:800MXS8R<[8QX00:<0XP01FR8R8R<00V800><R8P0
0h`01Zb<[:b<[0F<00>/S8`01:`018b8[8`2[0:<00B/S8b/0X`2[003c:b/00>/1=02c004d<c@c0S@
00GadO7Am@02d@K@0Z`00lb/[002[004R6R8R0940VP2A09X00F8J8b/d00Bm@03lOGA00?@00?<[8P0
0XP01:b8R8P3S003R6Q400m400<TA4@00R@4A008S:b/[=2/d=44d009[=2<[<c@c:b<00>800J/R8R<
[8`6[006S:b8S8QX0XP2J003R6QX00=X0T@3J004A6QXJ09400AXA4AX3D@00hQXR002A0>800AXR8b<
1HP00fQ4A00<A0AX1D@2J0A400=XA4@01D@290]40VP7A005R6Q4A6P03D@:J0=40fP2A0IX1hP00jb<
R005R09X00E4J6QXR003J0:800=XR6P016P6R004J8R8S0:800AXR:b/18`7R003J8R800:800=XA6P0
0T@2J003S6QX00=X00A4J6R80fP00hb8R004R005S8R8R6P00XP01hb8R6R8J8P00X`00hQXJ004R00<
S:b<R:b8S:b<[8b/0XP2S0:80Z`01Xb8S8QXR0R/0004A00594A4A2@00d@290I400<TA4@00b@2A004
94A4A0<T24@00bA4A006A003J4A400E400<TA2@00T@490A400<TA2@00T@29003A2A400i400=XA4@0
0d@00bA49006A08T1T@00bA4A005A00394A401140VP3A006J4AXJ4B80fP3R003J8R<00AX28P3S0F8
18`:R0:<0Z`>R003[8R800N800>/S8`00XP018b8R8`2R004S8R/R0:/00><[:`00X`01Jb8R:b<00>/
00><[8`00X`7[008S<c<c:c<d<`:d0;A00Kad?G@lM45d0N/18P2J004A6QXJ0B800><[=002oD00oWe
m@04m@03dO7@00?@00>/R8P00XP018b8[8P3[003S6Q400E412@4A0DT00E494A4J002A005R:c@d:`0
0]001Zc<[=2/d0J/00R<R8QXR6R/c0>/0X`00m2/[002[007c8R/J8R<R003J004R6QXJ09400EXA6QX
A003J003R6QX009X14@00bA4A006A003J4B800=X00J8J4B8J8P3S004R6QXJ0I400EXA4A4J002A005
J8R<R6P00d@00fR8J007A09X00A494@T14@00bA4A002A003J4A400U400EXA4B8J00<A0=X00A4J6R8
0fP5A0UX0XP01Zb8R8R<R0F<0XP00fR8J004J007R6QXJ8QXR006J0J800AXR8R<0XP00fR8R002S004
R:b8J0:800B<R8QX18P00dAXA002J005A6R8R6P018P4J005A6QXR6P00XP3J0:800F<J6R8J002R09X
00F8J6QXA003J004R6QXR0><00>8[8P00Z`2S00=R8b8J8R<R6R8S8QXS003R0><0j`2S00024@290M4
00@TA4A412@7A0<T14@00bA4A003A00394A400E400AXA2@T14@69003A2A400=400@TA2A40R@HA0@T
1D@00bA4900<A00394A400E400<TA4@014@00bA4A002A09X0T@016R8J6P2A003J4AX00:800AXR8R8
16P;R005[8b/R6P00XP00hb8S005R007J8R8R8b8[003S003R8b800:800QXR8R8S:b8J0:800>/R6P0
0X`01HR<R8R/00:80X`02Jb<R8b8[8b/R004[003S:b/00:<1J`01Hb/[8b800>/00?<S8`00j`01M2/
[:c<00G@00?<dL`00]000jc@l@04d006lM3AmM3A1=02c003[=6/00B80VP2A008J8QXJ8R<[8`2d0_e
00KimOGedO43d@04d<c@S0:800C<R8R80VP2S004d:b8J09400AXA4AX1B@00d@T900390940R@5A006
S:cAc=3e0Z`01m3<d:b<[8`01J`01hb8S8b/S8P01:`01M3<[8S<00:/00EXR8b8S002J005A8R8R6P0
0d@01FQ4J6Q4009X00E4J4A4J004A00394A400A400=XA4@00fP00dAXJ002J003R6R/00>80fP2A003
J4A4009400=XA4@00T@5J0:814@00fQ4A00:A00394A400M40VP9A00694AXJ4B80VP3A09X00I4J6Q4
J4@3J003A6QX00=X1D@00fR8J002R0=X00F8J8R8[002R0B<18P018b8R8P<J004R6QXJ0^800><R8P0
1XP01Zb8R8R<[0:<00>/R8P00XP2J003A6R<00=X00J8S8R8S8P2J003A6QX009X00><R8P00hP016R8
R8`3J0F800N<J6QXA6R800:<0fP2R008S6R8R8b/S8P2S003R6R<00:800QXR8b8J8b8[0:800>/R8P0
0h`1[0002D@012A4A2@3A08T0d@00bA4A007A0<T3D@00bA4A005A08T14@01bA4A4@TA2@02D@291M4
0b@2A00394A401M400<TA4@02d@00fQ4A002A003J4B800EX00>8J6P00VP00hQXJ006J0F800AXR8R<
18P2S004R:b8R0:<18P00fR8[004R003S:b<00F800><R8P02HP00hb8S002S004[8b8S0:800F<R8R/
R002S0:/00><[:`00Z`018b8[:`2S009R:b/[8b/S:b800B/00F<d:c<d002c004d<c@[0C@00KAc=3<
d=42d00:mM3elM7ed<c@[0G@00>/S8`018P2J00;A6QXJ8b/S:c@mO400oD00oWem@09m@03lM3a00;@
00?<[8`00XP016R8R:`3R0F<0VP4A00394@T00DT0T@01BA4A2A4008T0d@4[0?@0/`00jc<c003[008
d:b<[<c@R8`8[004lJb<S0F/00>8S8P00fP00hQXJ003A09X00=4J6P00fP2A005J4A4A2@00T@00fQ4
A002A00394AX00940VP2A09X0d@2J004R8aXR0=40VP:A09X00J8J6QXA6P=A003J4A400E400=XA4@0
3T@00fQ4A006J004A6QXJ09400=XA6P00d@00fQ4J004J005A6R8J8P00VP2R005J8R8R8`028P2S0:8
00=XR6P01fP00dAXJ002J003R6R8009X1hP016R8J6P8R008S:b<R6R8S8P2S004R8aXJ09400=XR4@0
16P4R09X0T@01FQ4J8QX00J80VP3R09X00B<J8R81FP00hb8R002J003R6QX00>800B<R8b<0Z`03Hb8
J8R/S8QXR8b8J8P00h`01Jb<R8b800>/0003A00394@T00Y400@TA4A40R@:A00494A490Y400<TA4@0
3D@29003A2@T02940R@014@TA4@2909400<TA4@06T@00bA4A004A09X24@3J0B800><R6P00VP3A09X
1HP2J007R8b/S8R<R005S0>800><R6P01XP00fR8R002R004J8R8J0>800B<R8QX1XP018b/[:`3R008
J8R8[8b8[8`5[004S:b/R0:<00>8[:`018`01Zb8S:b8S0B/00><d=000]001jc<[:c<d=400]001Lc@
d=3<00;@0]42d0;A00?ad?401m000m6/[004R003J4A400=X0hP2c0;A3oD2l@05d=7@dL`00j`3S004
R8b/[0:80Z`028b/R6Q4J4@T0T@00bA4A00390940R@01D@T94@T00=400EXR:b/d002d@07lM3<[8b/
d003[006S:c@d:b<0j`01Hc<c=3<00?@00B/d=3@0X`2[003R8b8009X00>8J6P00T@3J006A6QXJ4AX
0T@00hQXA004A003J4A400]40VP5A003R6QX00IX00=4J4@02D@3J0:800=XA4@014@2J003A2A40094
00<TA4@00R@2A08T00A492@T1T@00bA4A003A004J4A4A09X00>8J6P02T@01fQ4J8QXR8`01FP01TAX
R6R8S0N800B<R6QX0XP00jb8J003R0=40VP01dAXJ6R8J8P00fP00hQXR005R09X18P00jb8J002R006
[8b8S8R<0hP00hb8R003R003J4AX00AX00>8J6P00VP00hQXJ005J004A6QXJ0>80fP01HQXJ8QX00>8
16P2R003J8R800>80h`3R003S:b<00:800><R8`00VP01:b8J8P4S004[8b<R0:/1H`1R0004d@290]4
0b@9A00494A490A400DTA4@TA0039007A2@TA2A49006A0@T00=492@00d@01BA4A4@T01I40R@:A003
94A401E400=XA6P01d@3J006R:b8R6Q416P3A005J8Q4J8`018P02:b8c8QX[8R/0X`;R003S6QX00:8
00=XR6P00hP00hb8R008R0=X00>8[8`00X`00hR<R002S003R8b/00B<1:`018b/S:`3S0:/00F<R8b/
R003[003S:c<00>/00G<[=2/d002[0?<0]000m7@d@02d004c=3<d@G@00Cad=3A0m02[0;@00B/S8b8
0VP01hQXJ6R8J8P00Z`2c003lM7e00ce0_400m3Ac003d0>/00><[8P00XP01Zc@[:b<[0:<00B8J8b<
1D@=9009A2A4A2A4R8b/00?@00CamM2<1J`00hb/[002[0:81:`01Lb/d=3A00?@00CAc<b<0XP3S003
R6QX00AX00A4J6QX0T@00fQ4A002J09400=XA4@02T@00bA4A008A0=X00A4J4A41FP00hQXA006A0=X
0T@00fQ4A00>A0DT1D@390M400AXA4AX1D@3J003A6Q400Q40VP4A0AX00>8J6P00VP6R003J8R800>8
00F<R8R8J002R003J8QX00AX00=4J6P00VP2R0EX00B8J8QX0XP3J0F80fP00hR<S005R007S8R<S6R8
J003R0IX00F8J6QXA002J005A6Q4J4@01FP3R09X0XP2J0=416P3R09X0XP00hb/S002S0:80X`00hR/
S002S003R8b/00B800B/R:b/0X`01:b<[8P2[0:<00>/R:`00H`000E400=XR4@01d@00bA4A004A003
94A400Q400<TA2@04d@012A4A4@490A400@TA4@T0d@49003A2A400I40R@8A00394A400]40R@8A003
94A401A400@TA4AX0d@2J0A40fP3R09X00Q4R8R8J4AXR0=X0XP02FR/S8b8[8b/S002R003J:b800J8
0h`5R0AX0hP016R8R6P2R003J8R<00:800IXR8R8[8P2[0:800><[:`00h`2R0><0XP03=2/R<b/R8aX
R:b8[0:800B<R:c<1Z`01<b/[<`2[004c:c@c0C@00CAc=2/1=001?G@lM42d003dM3e00;@1J`00hb/
J003J003A6QX00:800R<[:b/c=7ed@?e00?jmOD01?D02M7edM3ad:c@c002d0B/00>8S8`00]001?7<
[8P2[0:800>/R6P00d@=909400<TA4@00T@3R008lLcAmM3ec=05[003d:b/00>/00?@c:`00Z`3d00:
lM3AlM3Ad:b8[0J80VP018QXA8P2A09X0T@4J09400=XA6P02D@290I40fP00hQ4A003A0AX0T@3J003
A6Q400=400B8A6QX1T@00fQ4A003A005J4A4A6P01B@7A00394A400I400=XA4@01D@016Q4A4@3J0Q4
0XP00fQ4A002J003R6QX00:800=XS8P028P01FR/R8R<00>800=XS8`00XP4J0=400EXR4AXR005J003
R6QX009X00B8J6QX1HP2J0:80h`00hR<S002S003R:b800:800AXS8R816P01hR<J6R8J4@00VP3A003
J4A4009X0XP2J003R6R8009X00>8A4@00T@4J005R4A4A8`00XP01:b8R8`4R0:<00F8S8R8S006R008
J8R/R:b<J8P2S004[8b/[0:<0XP0009400HTA4A4J2@=A08T24@290e400<TA4@01D@290=400<TA2@0
1D@00bA4900290941R@7A08T14@00bA4A00lA004J4A4A09X0XP3J004R6Q4A09X00I4J6R8J8P2S003
[8b<00:<00Z/R8b8S8R<R8b80X`01HR<S8b8009X0XP00fR8R005R003S8R800F80fP00hR<S002S007
[8R8R:b<[002S003R8b<00B<00J/R8R8S:`2R007S:b/S8R<R006[003S:b/00:/00G@c<c<d003[004
c:c@[0K@00CAd=3@0]400oG@l@04d003c=2/00>/00><R6P00fP2R004S8R/S0:/00?<lO403OD00m3a
d003d004c=3@d0B/00F<[:cAd002c004d8b<[0><00AXA4A40R@014AXA4@790M400AXR8b/0]001OGA
d=3A00:/00F8S:c@c002S0:/00S@[8b<[<cAd0;A00SelOGadM2/S0:80X`2J09400EXA6R8J002A004
J4A4J1=400<TA4@00d@2J003A6Q400E40VP4A0=X1D@016Q4J6P8A004J4A4J0Y400<TA4@01D@00bA4
A00<A09X1D@2J0M40fP3A0=X00A4R6QX0XP3J0>800B<J8R<1HP2J003R6QX00=X00>8J4@00T@016R8
J4@3J003R6R800:81VP2R09X0XP2J0>81h`5R004J8R8R0AX0XP7J0A400=XA6P00XP016R8A6P2R09X
00=4J4@00T@5J09400=XR8P00XP00hb8R002R003J8b800B800F<R8b<J004R004S:b8[0><00>8S8`0
0Z`01<b/[:`1S0001d@00bA4A00;A00494@T90Q400<TA4@02T@290M400@TA4A40R@00d@TA005A08T
0d@690I412@2A00394A400e40R@7A08T3d@016Q4A6P2A004J4A490Q400AXA4A40VP2A0=X00J8J6QX
S8P3A00;J4AXJ8R<J8R/R8`00Z`01XR/[8b8[0J800>/R8P00hP3J0:800AXR6QX18P00hb8R002R003
J8QX00AX00B8[8R/0hP00hb/R002[003S:b<00:<00>/S8`00XP01Xb8S:b<[0:<00>/S:`00j`018b/
[:`2c0>/00S@c=3<d<c@[0;@00?<[=001M02d@09lM7Ad?7AlM7@00:/00G@dLb/S002[0:80VP00hQX
R003[004R:c<d0oe00O@lM7@[<b/00C@00?edL`00]401:b<[:`3d005c:b8R6P02D@49004A2@T90A4
0b@2J004R:b<[0;a00G@c=2/S002[004c=3<[0;@00?<d<`00j`00m3ad@02l@08mO7elOG@c:`2R004
J8b8R0EX00>8J4@00d@4J1A40R@7A09X00=4J6P01d@3J003A6R800EX0d@00fQ4A004A003J4A400i4
00=XA4@01d@00fQ4J006A004J4A4J0A400AXA6QX0T@00fQ4J002J003A6Q400941VP00dAXJ00<R003
J8Q400IX0T@2J004R6QXA0AX0hP3J0940hP2J0J81X`00hR<S003R0=X00>8J4@00VP3R004J4AXA09X
0d@00fQ4A002J0>80fP01HQXJ6Q400=X00=4J6P00T@3J004A6QXJ0>800F<R8R8S002R006S:b<S8QX
18P2S0:800B<[8b80h`3[0:<0J`1S06<000DA00394@T00940R@5A0<T54@29003A2A400M400<TA4@0
14@59003A2@T00E40b@3A00394A400Q40b@00d@T900>A00394A400E400<TA4@04D@2J0940VP6A0=X
00>8A4@00T@00fQ4R002R0:<00F8[8b/S003[004c:b<[0><0XP2S0:800><R8`01HP01VR8S8R<[0n8
00><[8`00XP018b8R8P2[0:800F<[8b/S002R003[8b<00:<00>8[<`00Z`01Lb/[:b<00>/00N<[<b/
d:c<00;@0l`00m2/d002c005[=3<d<`00m001=7ed=42d0;a00_AlJc<dM2/c:b<[006R0:<00>/S:`0
0Z`00m3em@09m@Ga0]400m3<d003c005d?GjnOX00_D4[0;@00GadM2/S002J0A400<TA4@00b@014@T
A4@490=40R@01TAXJ8R<[0?@00>/d:`01:`00m3<d003[003dM3@00;@00GAlM7ad@04l@04mM3@[0:8
00EXR6R8A006J0=416P00hQ4A005A0<T34@00bA4A007A0=X14@6J003R4AX00=X14@00fQ4A006A09X
34@00fQ4A00<A09X0d@00fQ4A008A0AX00=4J4@01FP2A0=X0T@3J0>800=XR8P01XP4J003R6Q400IX
00>8J6P01FP4R0AX0hP4J00<R6R8R:b8S8R/S8R<1hP2J007A6QXR6R8J002A004J8QXR0AX00=4J8P0
0hP00haXJ003R09X00B8J6Q41FP01XQXJ6R8J0>800><R8P01HP2S005R8b8R:`00h`3R005S:b/S:`0
0h`2[003R8b/00:<0002A00494A4A08T6D@00bA4900DA00394A400a400@TA4A40R@2A00594@TA2@0
14@290i40R@014@T92@?A00394A401U40fP2R0I40VP00dAXA002A0AX00V8J8R/S8R<J8`00j`01Lb8
S8c<00:/00F<R8R/R002S0:800F/R8R<J003R005S8R/R6P00h`01HQXR8QX00J800B/R6R/0XP018aX
S8P2[00:R8b/R:b<R:b<[0:<00B8[8R<0Z`01/b<[:b<c0V/00c@[=2<d<c@c=3<d:`2d00=dJc@mM3a
d<cad?GAd002d@;@1j`2S0>800B<d:b/0]001?7emOX6m@08dOGelOGadO42d0;<00C@[=3e0oX01OWj
mM2/00C@00CamM3<0XP016Q4A4@390A40R@2A08T00=494@01D@01fR8[:c@[=000/`01]2/S:c@[0;@
00?Ac=000]001o7Ad=7@lM000o400m3el@02m@;@00B<R8R80fP01XQXR8R<R0AX00N8J4B8J4AX00=4
1B@;A0<T2T@016Q4A4@2J005S8R8J8P01fP3A003J4A400E40VP:A004J4A4A09X1d@00fQ4A006A005
J4A4A6P01T@016R8J8P2J09400MXR6QXA6Q400=X00>8A6P01FP2S0F81FP00dAXJ007J006R6QXJ4B8
0fP3R0=X00>8J8P00VP00hQXR003R009[8R<R:b<R:b<00B800B/J8R80VP028QXR8QXA6R/18P3J0>8
00EXR8R<J003R0EX00>8J8P00VP00dAXR002J006S8R8J8b80VP6R004S:b/R0><00>/R8P00X`018R<
S8P2S004[8R<S0:800>/R8`00J`000Q400<TA4@01D@00bA4A00;A0@T0d@2909400<TA4@02d@00bA4
A007A00394A400]40R@6A08T0T@00bA4A00:A08T00=492@04T@2915400=XA4@00d@2J003A6QX00EX
00E4J6Q4J005A003R6R800>80X`00jb8R005[005S8R<[8`00Z`01XR<[:b<[0B<18P00hb8R002S003
R8b<00N800AXR8b818`3R003S8R800>80X`01Jb8S8b800:<0hP00fR8R008[003S8R/00:/00?<[=00
0j`00lb/[002[007c=2/d<c@[002d005dM3@d?D00]43d003mM7e00?@1:`00lb/[002S0:80Z`00hb/
l@02c0;A2oD01M3ad=7@00;a1M000o7enP04nP05mM2/[=400]03d@04d:b8J0A40b@4A00494A490U4
0XP028b/[:c<dJc<0Z`01M2/c=3A00;a00?edO400_D5l@0;mM7alOGamM7ad:`016P;R003J8QX00AX
14@012A492@9A08T0d@3909400=XA2@01T@00fQ4J003J0>81fP2A006J4AXJ4AX3T@00fQ4A002A003
J4A400U400<TA4@03D@2J005R6Q4J4@00VP00hQXJ004J003R6Q4009X18P016R8R6P2R006S8R8J8QX
0T@>J003R6QX00AX00>8J6P028P018b8S8`3R003[8R800:800><R8P00XP2J00:S8R8J8b8J4AXA0:8
00EXR8aXR005J0B800B<R6QX0XP6J09400=XR6P00VP5R0=X00><R8P00XP01Jb8[:b<00>81H`018R/
R:`2S004R8b/S0>/0H`1[0001T@012A4A2@3A00494@T909400<TA4@01d@00bA4900290E400<TA4@0
1D@00bA4A00?A0<T1d@012A492@2A08T0d@3911400<TA2@03d@00bA4A002A00394A400=400=XA4@0
44@016Q4J4@9J0E40fP2R09X00>8J8P00XP01Hb/[:b<00:800><[:`00Z`00hb8S002[004S:b<[0:8
00><R8P00XP02Xb8R:b<R:b<R6P3R004J8R8S0B8016<R8R8S8R<[8R/S8R<[8R/R005S003R8b800J/
0X`01Zb<R8b/c0:/00S<[=2/c:c<[0[@0]402?GalM3adOGA0]001m7@d:c<[8`00Z`018b8R8`3[006
d:c<d?Ga2OD2l@08dO7@dM3AlM42d003dOGe00Oj00OedM7@lOGA00?@0Z`00hQ4A002A00394@T00m4
00AXR8b81:`01lc@c<c@dM000/`00m3em@02m@07dOGamM7el@03m@;A1?401M3elM2/00:800=XR6P0
0VP4R0:<18P01:b8R6P5A00394A400Q40R@4A0<T2T@5J006A8R8R6R81FP2A0=X0hP00fQ4J007A003
94A400I400<TA4@01T@00fQ4A005A003J4A400U400=XA6P00fP2A0QX00=4J6P01VP7R0=X0XP00fQ4
J003J004R6QXA0:80VP01DAXR6R800IX00>8J6P00fP6R004S8R<S0V800><R8P00VP00hb8R002J003
A6Q400941FP2A0IX0hP2J005R6Q4A6P00d@2J004R6QXR0UX2HP2S003R8b<00:<00>8S8P01hP01:b<
S:`2S06/0005A00394A400E400<TA4@00T@00bA4A009A00394A4008T1T@00bA4A007A00394A400E4
00<TA4@00T@29003A2A400M400@TA2@T0d@2909400<TA2@00R@7A00394A401A400<TA4@05D@39094
00EXA4AXA002J003A8R800=X00=4J6P016P01dAXJ8R/R6P00XP01FR<R:b800:/00>8S8P01J`2S0:/
00><[8`00Z`4R0F<00>/S8`00j`3J005R6R8R6P00XP00hb8J002R006S8R8R8b80Z`00hb8S002[005
S8R/S:`00X`7[003S:b/00:/0X`5[003c:b/00;@0Z`01Lc@d=3<00;@0]402m2/d?7@lM7@mM3a00?@
00GAd=2/c00;[006c:c<d=7a2OD00m7@d004d005dM3Ad=400_D4nP05oo[jn_T00_D3l@03mM3<00:/
00><J4@014@00bA4A002A003J4A4009400<TA4@00d@01VR8R8R<[0;<0m001:c@dOD3d0;a0oD00m7a
m@03m@03lOGe00?e00CAmO7a0m001<b/[8`2R0EX0XP016R8J6P6R0=X2T@012A4A4@290A40R@>A003
J4AX009X00>8J6P00T@01XQXR6Q4R0EX00F8J6Q4J007A003J4A400=40R@2A09X14@00fQ4A00CA0=X
00=4J6P00fP00hQXJ004J0:81FP:R09X00>8J8P00VP00hQXJ004J004A6QXJ0>80VP00hQXJ003J003
R6QX00:800IXR8R8[8P2S006R8b<S8QX0X`2R0AX18P00fQ4A003A006J4A4J8QX0T@00hQXJ002A0=X
0T@4J09400=XA6P00VP01DAXR6Q400=X18P00fR8R003R09X28P00hb/S002R003[8b/00J<0J`1S06/
000:A00394@T00I400<TA4@01T@00bA4A003A08T1T@290I400<TA4@02d@290i400<TA2@00T@591Q4
0R@:A003J4A400m400AXA2@T0T@2J0A426P00dAXA005A003J4B800:80fP01:b8R8`4[0:<00>/R8`0
0X`00jb<[006[003R8b800B800>/S:`00XP2S0:81fP00hR<R002R003J8R800:80X`01:b<[:`2S003
R:b<00:<0Z`00hb/S004[00:R<b/[8R<[8b/S0R/00K<[:b/d<`5d003dO7<00;@00?adM401=401=3a
d?42d003[<b/00:/00?<S:`00j`01/c@c:c<d0;A2OD00m3Ad008d003lOGj00Oj00?kn_X00_D01?7A
lL`2[003R8aX01=40VP01hb8S8R/d=402M001=7amO4?m@05lOGelM400m03[0QX2HP00fR8R002J0a4
00@TA2@T1T@490a400EXA6QXR003A0=X00F8A8QXR007J0Q400>8J6P00d@290E400=XA4@02D@290E4
16P6A004J4A4A0=X0XP2J003A8R800B800=XR8P01HP00hb8S004R0AX0hP6J003R6QX00=X0hP016R8
J6P7R0:<0hP016R/S8P2J003R8b800J81VP3A09X00=4J8P00VP00dAXJ002J004A6QXJ09400AXR6Q4
0VP01HQXJ6R8009X00F8J6R8J002R003J8R800EX00>8J8P01HP2J006R8b8S8QX18P3S004[8b/S06/
0009A00394@T00Q400@TA4@T2T@00bA4A00bA0<T1d@390i40b@AA003J4A400I400=XA4@014@00fQ4
A006A09X0XP00fQ4J006A0=X0XP00dAXJ002R004J8b/R0:/00><R8`00X`3[003S:b/00:/00K<[8b<
[8`3R003S:b800N81VP9R003J8QX00F800><R8P00h`2[003S8R<00><00B/S8R/0XP2S0:/00><[:`0
2j`2c005dM3Ad=400]001:c@d=03d@;@00?Ad?400m000lb/c009[006c=3@[<c@0]48m@0:lM3@d=7<
d:c@c0;@0_D01O[on__j00?k1?X01?GalM03[003S6Q400=400<TA4@014@016Q4J4@2R003J4A4009X
00N/R8S<d=7@00;A0]001jc@c<cAmO404_D00o7em@03d004mM3<[0=X0XP2J0>800J<R8R<R:`3R0=X
2D@01RA492A490I41R@=A005J4AXJ4@00fP00dAXJ002R09X00=4J6P00VP2A004J4A4J0Q400<TA4@0
4D@390A400=XA8P00VP8A09X0XP00fR<J002J0>80VP01DAXR8QX00B800><R8`00hP2J008A8QXJ8QX
R8`3R003A6QX009X00>8J8P01HP2J003S8R8009X00>8[8P00XP3S004R8b8J0>80fP2R0EX00=4R4@0
1FP00hQXA003J003A8QX009X00=4R6P00VP00haXA006J003S6QX00=X00A4J6QX0hP5J0J800><R6P0
0XP02Hb/R8QX[8R<[002R0><0J`1S07<0008A08T0T@00bA4A005A00394A400Q400<TA2@01T@00bA4
900<A00394A400U400DTA2A4900=A00394A401I400<TA2@00R@?A003J4A400Y400=XA2@00d@00bA4
A008A0AX00=4J6P00VP6A004J8QXR0AX0X`01hR<R8b8S8P02J`2S005[8b<S:`00h`00jb8R002S0B8
00EXR8R8J003R003[8b800B80fP00hQXR002R003S8QX00:80Z`3S00=R8b/S:b<R8b8S:b<[002S0:/
00N<[:b/S:b<00J/0]001]7@dM3<[0C@00OedO7@lM3A00C@00?<[:`00Z`01lb/[:c<[<`00]000lc@
d@02d@Se00GadM3@d@03d003c=3A00;e0_X01ookoo[on_/00_X01?_jnOD2d@>/0VP2A00494@T90A4
00IXA4AXA6P4A09X0hP01]7ad?7@d@?@00C<[?7@5OD00o7em@02d004dM3@[0:800=XR6P00XP016R8
R8`4R005[8R8J8P00VP?A00394A400=400<TA4@03T@016Q4A4@3J003A6QX009400=XR8`016P014AX
J6P3A003J4AX00=X1T@00fQ49007A00394A400Q400=XA4@01T@00bA4A003A007J4AXA6R8J002R09X
0XP4J003R6QX00=X0XP01Hb8R8QX00:81FP3R004J8R8R0=X0XP016R8J8P2J004R6QXJ0F80X`018R/
S8`4R004J8b8R0AX0XP4J0A400IXA6Q4J8P3J006A6QXR8aX0T@2J003A6R800=X00=4J6P01FP00hQX
J00;J0:800=XR8P00fP3R006S:b<S8QX0XP01Jb<[:b<00>80J`1c00024@01BA4A4@T00M40R@?A005
94A4A2@02D@00bA49002909400@TA4A40R@3A00394@T00E400<TA4@054@490M400<TA4@00b@FA003
94A400i400<TA4@014@4J09416P03TAXA8Q4J:b8J8QXR:b<0j`01Hb/R8R<00J/00F<[8R/R004[003
S8R<00><00B/S:b/0hP02Hb8R8QXR6R8S002[003S6QX00:80fP00hR/R006S004R8b/R0><00Z/R8b<
[8b/S:b81J`00lb/[007[003d<c@00?@00_ad=3@dM3Ac?7ed002d@03d?G@00?@00Z/c:b/c=2/c:c@
0j`2d004dM3ed0;e00GamOGam@03l@;<1M000o7em@03nP03oo[o00;k00Oon_[kn__j00;e0]000lb8
J002A08T00=492@00b@6A005J4A4J4@00fP01Jb8[=3a00?@00?<lL`00Z`00m3em@04m@03nOGe00oe
00WamM7elM7@[8`01XP01Zb<[:b8S0J80VP>A08T00=494@00d@00bA4A00>A003J4A4009X00>8J6P0
1FP00dAXJ003J0:800AXA6QX0T@00fQ4A002A005J4A4A2@014@00bA4A009A00494AXA08T1T@2J0=4
1FP00hQXJ002A0EX00>8J6P02HP01Xb/R:b8J0:800=XR6P016P00hQXR003J003R6R800>81FP01HQX
J8QX00>800><R:`00hP00fR8R003R005J8R8S8P01FP00hQXJ003A0=X0T@00fQ4J002A003J8R800=X
00A4J8QX0XP00fR8R002J0940fP2R003J8Q400=X00>8J6P01FP3R0AX1HP00jb8S002S0>800><[8`0
0X`1[06<0J`00003A6Q400U400<TA4@01D@00bA4A00:A08T0T@290a400<TA4@014@012A4A4@29005
A2A494@00R@2A00394@T01E412@8A00394A400@T1D@290E400=XA4@01T@290i40R@4A003J4A400=4
0hP7J005A6R8S6P00XP01FR8R8R<00:/0h`00jb<[004[003S8R800B/0X`4[004R8b<[0:<1hP3J003
R6R/00:/00N8[8R8J8QX00>80h`03:b8R8b8[8b8S:b8S0F/0X`00jb<c007[003S:b/00>/0/`00m7@
d005d007dM3Ad=7ad@03d003lM3@00C@00[<d:c@c=3<[<c@0m401O7AlM3A00?a00OedOG@dM3A00?@
00?AlO400oD3nP03oo[k00;k0oX4n`07n_Wad:b<R00=A09X0d@2J003R4B800:<00C@c=7A1=001_G@
d<c@l@Ge0_T@m@08dOG@mO7@lJ`2S0:/0XP018b/[8`3R0><00>8S:`00XP2J09400=XA4@00d@290]4
00<TA4@024@00fQ4A002A003J4A400EX00E4R6QXR002J008R6QXA6Q4J4@2R003J4A400a40R@00fQ4
A004A00394A4008T0d@290E400EXR8QXA003J0=400>8J6P00fP2A003J4B8009X00>8J6P01XP016R8
R8`2J0:800N/R8R<J8QX00>800AXR8R80fP018R<R6P6R003J8QX009X0XP00hb8R005R009J8R8R6R<
R6R8009X00=4R8P00VP00dB8R003J0A400=XA6P00VP00dAXJ002J003A6QX00UX0hP00fQ4R004J003
R6R800:800AXR6R<0XP016R8R8P2J004R8b<R0J<00R8[:b8[8b/S06/0002J0=400AXA4@T14@01BA4
94@T00=400<TA2@03D@290940R@7A00394A400=400@TA2@T0d@29003A2A400<T00E492A49004A004
94A490E400<TA4@014@01RA4A2A490A400@TA4@T0T@390A412@>A0<T2T@012A4A2@6A009J4A4A6R<
R4AX009400=XA4@01FP01DB8R6R8009X00R8S:b<R8b/S0B/00><[8`00j`00hS<[002S0:/00?<R8`0
0X`00hR<R003R004J8R8R09X1XP00hb8J002J004R8b8[0>800J<R8R8S:`2S0V/00><[:`00j`00lb/
[003[003S:b/00>/00S@c=7<d<c@[0;@1=401O7@dM3A00O@0]400m2/d003d0:/0]001_7@lM3Ad0;A
00kelOGadM3Ad=7@c=3Ad0?e0_X00ooko`03n`06oo[kn__o0oX00oWed002R0a400iXA6R8A6Q4J8R<
J8R/c0;@00CadOG@0_401]3alM3ad0Ke00?imOD02_D00o7il@02l@;@013ad=3<[6R<[8b/R8b/R8b/
0h`01hR<R8R<J8P00VP3A003J4A4009400<TA4@00T@391=40VP2A09X00A4J4AX14@2J003A6QX0094
0fP2R003S8Q4009400=XA4@01D@00fQ4A003A003J4A400Y400=XA4@014@2J003R4B8009X00><J4@0
0d@5J0941FP014AXJ8P2J0>80VP00hR/S006R007J8R8J8QXR003J0>800EXR8R8J006R0=X00=4J6P0
0hP3J0>800EXR8R8J002R005A6R8J4@016P2R0AX00=4J4@014@2J003A8QX00EX00>8A4@01VP2R004
J8QXS09X2HP00fR<R003J0:800MXR8R8S8R/00B<00J/R8b<[8`3[06<0009A00494A4A0<T1D@00bA4
A005A00394A401]400<TA4@01d@00bA4A00:A00394A400]400<TA2@00b@7A00394A400<T1D@290m4
22@<A00394A400E40VP00dAXA003A003J8R800AX00B8J6QX0XP3S0:80j`01Lb/[=2/00:<00>8[:`0
0Z`03Xb8R:b<c8R<R8b8S8R<1HP3J006R6R8J8R/0hP2J009R:b8S:b<[8b800:<00B/S8R<1Z`018c<
[=05[003c:c<00:/00F<[8b/S003[007c=2/c:c@c002d0;A00?ed=000]001=7ed?43d003dM3@00;@
00?<d=000]002Zc<d=3adO7@mM03l@;e00KAlM3Ad=43d004dO7em@;j0o/01?okno/2o`;j00?on_/0
0oX01?WAS6P4A003J2@T00E400AXR6R<0fP02ZaXJ6R8[<c@dOD2d008dO7@mM3AmM45m@?i1_D01OWe
mOGa00Ge00C@lM3@0j`018R<R=02[003R8b800:<00J/S8R<R8`5R0=X1d@290M400<TA4@02d@00fQ4
A004A09X2D@2J0E40VP018Q4J6P<A003J4A400Y400=XA6P02T@01HQXJ6Q4009X00=4J4@00T@3J006
A6R8J4AX0XP016R8J6P3R003A8R800F800=XR8P018P4J003R6R800AX0XP016R8R8P;J003R6R800>8
00IXR6R<R6P6R09X00=4J4@016P2R09X00>8J6P00VP4A09X00=4J6P01fP00dAXA002A09X00>8J6P0
0XP5J0B800B<R8QX0XP00fR8J003R0:<0XP018b8S8P2S007R8b<S:b<R003[0001d@00bA49004A08T
1d@01BA4A2A4008T0d@00bA4A00;A00394A400A400<TA4@034@290A40R@6A00394A400M40b@2A0@T
1T@00bA4A00JA00394@T00@T0T@00fQ4A00CA004J4AXJ0941VP2R003J8QX00>800N<R8R<[8R<00:8
0Z`2S009R8b<[8b/R8b/00:<00>/S8P00X`00jb8R002R00:S8R8J8QXR6R8J0>800><R6P01hP4S003
R8b<00:<1J`00hb/[00:[007c8b/[8b/R002S0;<00B/c<b/0]000lc@d@03d@05d<ced=400m002=7@
d<c@c=3<0m000jc<d002d003lM7a00;A00C@lM7e0o42d003dM3@00?@00CamOGi0oX01?ojnol2nP04
oo[kn`Oj00?ed8`00fP7A0=X00F8S:b8[002S00A[8b/[=3<dO7Ad?GAlM3ad?401oD2n@Ke00?imOD0
1?D01?7emO44m@05d:b/[8`00j`2S009R8b<S8R<[8R/00:<18P00fR8J00;A0@T0d@00bA4A002A003
J4A400Y416P9A003J4A400=400=XA4@00d@00bA4J00=A00394A400U41B@3A003J4AX00=X00=4J4@0
0T@00fQ4J004J003A6Q4009X1XP5J004R8b8S0:800=XR8P00XP2J005A6QXJ8P00fP00hQXJ002J0:8
00=XR6P016P2R0=X0XP00fR8J005R009S6QXJ8R<R8b8009X00=4J6P00VP018QXR8`4R09X24@2J009
R6Q4J8Q4J4AX00=40fP00dAXJ002J003R6QX00J82FP00hR/[002[0><00b8J8R<[8b8S:b8S8P2[000
14@012A4A2@4A00394A400e40R@>A08T1T@29003A2A4008T34@00bA4A002A00394A400A400<TA2@0
0T@00bA4A002A0<T00A494@T1d@00bA4A005A00394A4009400<TA4@02D@00bA4A003A0<T00A494AX
2T@00bA4A00=A003J4AX00>800=XA6P016P5R005S8R8R8`00hP2[003c:b800><00B/S:b80X`01:b<
[8P3[004R:b8S0>81fP00hQXR002R003S8R<00>800B<R:b80X`2R0:<00N/S8b8[8R<00>/00B8S8R<
0Z`00lb/d006[0:<00R8c=3@c=2/d0;<1=400m3Ad002d007lM3Ad?7@d@04d003[<c<00;<0]000o7A
m@02m@;A0]001]7edO7@d@O@00?amOD00_X2n`03n__j00?j00Ckn_[k1?X01O_jn_[e00;a00><J4@0
14@2J004A6R8S0:/00>8[8`00Z`00hc@c002d008mM3@d?GamM02l@03mO7e00Ce00?imOD05OD00m2/
c004[005R:b/S:`00X`3[003R:b<00:800><R8P00hP00fQ4A009A00394@T02Y40b@4A0<T2d@29003
A6Q400I400@TA2@T14@00fQ4A004A09X00B8J4AX0d@6J004A6R8S0B80VP00hQXR002R09X0XP01FR8
J6R800IX00>8J6P00VP00hQXA002R0=X00F8J8R8J002R003J8R800Z800EXR6R8S006R0EX00>8J8P0
0hP00fQ4A002A003J4A400E41FP014AXJ6P4A09X00=4J8P00VP2R004S8QXR09X1HP026R8R8QXR8b/
0XP02Xb/S:b8S6R<R6P3R003S8R<006<0008A00394A4025400<TA4@01d@00bA4A00HA00394A400U4
00<TA2@044@00bA4A005A00394A4011400<TA4@00T@00hQ49002A003J4A400E400=XA4@01D@2J0A4
00=XA6P00hP2J004A6QXA0>800QXR8b8[8QXR0><00>8[:`00X`02:b<R:b<R6R80Z`00hR/R002S003
[8R<00:<0XP018aXJ6P:R003J8R800:800><R8`00X`01XR/[8b/S0>800F<[:b/S006[004S<b/c0J/
00><[:`00Z`01=2/[:`3d004c=3@m@?@00KAd?7@mM02d@?@00>/c:`01:`2d0;a0oD00m3ed002d@05
d=7Ad?401=000lc@d003m@Kj00?on_/00_X02Oojn__jnoojn`03nP03mO6/009X14@018QXA8P2[0:8
0h`01Lb/c=3a00:/00Ged<c@d@02m@06dOG@lOGa1?D00oWen@02m@05nOGenOD00_T8m@08d?GelOG<
d<`3S005[8R8[8P01:`018b/[8P2S0>80VP00hQXR00;A08T1d@00fQ4A005A00394A401A400=XA4@0
14@01BA4A4@T009400<TA4@02d@00fQ4A004A0<T2T@00fQ4A002J004R6Q4J0=400F8J6QXR002J0:8
0X`00hQXJ002J0:800MXR8QXA6Q4009X00E4J6QXR003J003R6QX00IX0XP4J0>80VP4R005J8R8R8`0
0XP00haXR002R004J8R8R0:<0XP3J006R6QXJ8QX0XP01fR8J6Q4J8P00VP5A0=X00=4J6P016P2A006
J8QXA6R<0XP2J0>80VP00hR<R008R003S:b800F80h`5R09X00>8S8P00H`000E400@TA4@T2d@01BA4
A4@T01=40R@8A00394A400a40b@3A00394A400U40R@5A08T3d@390I400<TA4@014@00bA4A003A003
94A400e400=XA6P01T@00fQ4A005A003J4A400=400=XR8P00VP3A0AX00B8J6R80X`01HQXR8R<00>8
00j<[:b/S8R<[8b8J8R/c0:/00>8S8P018P01HaXR8b8009X0hP2J004S8QXR09X18P5S0B800J<R8b<
R8`6[0;@0Z`00hc<[006[005c8b/[<`00Z`2c005[=3<d<`00]001]7@dM3ed0;A00?adM400]43d0>/
00O<d8b/d?7A00?e0]401=3AdM45d003dM3@00;@00CamOGi0_X01O_joo_o00;k1OX01O_jno[k00Cj
00GimM28J004A004R6QXR0N/0/`01:c@d?42m@03d<c@00;e00?adM400]47m@?i3?D00o7el@03d@07
lM7@dLb/S002[0><1Z`01Hb/S8b800:<0XP00fR8J002R004J8R8J0Q400<TA4@00d@00bA4A004A003
J4A401E400=XA4@00d@016Q4A2@2A003J4A4019400@TA4A40R@00d@TA005A003J4A4009X00=4J6P0
0VP5A0QX00B8S8b81FP00hQXR002J003A8QX00AX00B8J8R80VP00hQXJ006J0:80fP00hQXJ004J0:8
0VP5R004J8QXJ0B80VP2R004[8QXJ0=400=XA6P00fP2A09X00=4J8P00VP00dAXA004A09X14@2J094
00=XA6P00VP4R09X0hP00fR8R002R003J8R800J800F<R8R8J005R0:<1hP1[0001D@01BA4A4@T00e4
00<TA4@034@00bA4900:A00494A490i400<TA2@05d@290I400<TA4@01T@290E40R@3A0@T00I492@T
A2@2A00394A400940b@?A003J4A400I400=XA4@00VP2R09X14@2J0B800YXR8R/R8b/c8R/0X`01:b<
[8`3[0:<0XP018b/R8`5R003S8R<00J81FP3R008J8QXJ8R/S:`2R003S8R800B800B<[8b<0XP00hb8
S00A[003c:c<00;<00F/d:c<[004d004dM3@d@;@00?Ad?400]401M3Ad=3<00:/00C<d=2/0]001M7e
mM7a00;A2]001?7Ad=42m@03nO[j00;j0o/00ooknP07nP03no[k00Kj00?e[6P00d@4J003R8b/00F/
00G@dM2/d@02m@03lM3a00?e00Gad:c<d@07m@03nO[e00ce00?amM400_401?GAlO42d@03d:b/00F/
00?@[=001J`00hb8[002R004S8R<R0EX2d@00fQ4A003A00394A400I400<TA4@01d@01FQ4A4AX0094
00=XA4@00VP4A003J4@T008T1D@01BA494@T009412@5A08T1D@290U41fP4A0MX00>8A8P00hP00fR8
J002J0F800=XR8P00VP00hQXR002J0:816P00hQXJ003J003R6R800MX0hP01Xb8R6R8J0:800=XR8P0
0XP00hb8R002J0:800><R6P00fP3A005J8QXJ4@00VP014AXA6P3A0=X0T@00fR8J004A003J4AX009X
00=4J6P01VP00hQXJ004R0=X1HP016R8R6P5R003S6QX00:800><R8P00h`1R06<0H`000E400<TA4@0
0T@00bA4A00<A00394A400]400<TA4@00d@00bA4A004A0<T0d@00bA4A008A00394A4015400@TA4@T
0d@00bA4A002A0<T0T@012A4A2@>A0DT00E494A49004A00494A4909400<TA4@054@2J0=41VP3A0=X
0hP3J0>800F<c8R<R002[0:<00J/S:b8S:`3S003R8b800j80VP3R09X00^8J6QXR8b8S:b<R002J003
S8R800:80X`01Zb<[8b/S0:/00F<[:b/d005[00:c:c@[=2/c:c@c0?@00C<d:b/0m001?7AlM02d@07
lM3Ad=7@d@02d007c:b/d<c@c002d007lM7adO7@d@0;d0;A00CamOGi1?X01__jn__jna3j00?ed8P0
0VP00dB8R002R003S:b/00B/0/`3d0;e00GAd=3ed@02d005dM3Ad=401OD3n@03n_We00[e0_43d@03
lOG@00;a00?@dM001J`01Hb/d:c<00B/00O@[:b/R8b/00><00AXR8R80T@2J005A6Q4A6P00T@00fR8
A00@A00394A400=400@TA4AX14@00fQ4A008A003R4@T008T00A492@T0d@00bA4900390=400@TA4A4
0b@:A006J4A4A6R816P3A0MX0hP014AXR8`2R004J4A4J0N80VP018QXS8P3J003R6QX00QX0hP00fQ4
J005J0N800AXR8QX0XP018b8R8`4R09X00>8J6P01VP4A0EX00U4J4A4J4AXA6P00XP01FQ4A6Q400=X
0T@00fR8J008J006R6QXJ8QX2XP01haXR8R<R8`00XP3S004R8b/[0B<000=A00394A4009400<TA4@0
1D@00bA4A00HA08T0d@00bA4A004A00594A4A2@00d@00bA4A00=A00394@T008T3D@290Y400<TA2@0
0b@00d@TA009A0@T24@01FQ4A4@T00Y400=XA4@01D@3J004R6Q4J09400AXA4AX0XP2J003R8b800:8
0Z`016R8[:`3S006[8R/[8R/0h`018R/R8P2S003R8b800B80VP3R005S:b8R6P00XP00fR<R00=R003
S8R<00:<00>/S:`01:`02hb8S:c<[<b/d:c<00:/0/`00jc@[002d0;<00G@[=3@d@02d0;a00CAmM3@
0m400o7@d004d004[=3@c0?@00?Ad?400m000lc@d008d006c=3alOGi1_X2n`03n__k013j00CimJb<
0VP2R0:<00B8[:c@1J`01]3AmO7ed0;A00?ed?400]001<c@dO48m@;i00?jmOD02OD01_7elOGAl@;e
0]401O7@[:c<00B/00?<[:`00j`00lb/S004S003[8b8009X0XP00haXR003J0I40fP8A00394A40094
00<TA4@00R@7A005J4A4A2@00T@00bA4A00:A0DT0d@690I41R@9A08T00=494@00T@00fQ4A004A09X
00B8J6R80VP00dAXR002R005J8QXJ8P016P3R0=X0XP2J005R6QXJ8P00fP00hQXJ002J003S6Q400]X
0XP00fR8J005R004S8R<S0J81FP2A09X00A4J6Q40fP01HQXA4B8009X0T@2J003R6QX009400=XA4@0
0T@;J005R6QXJ8P00fP018QXR8`3R0:<0Z`3R003S8R<00B80X`2[003R:b800:<000:A003J4A400a4
0R@4A00394A400I40R@;A00494A490I400=XA4@01T@00bA4A005A00394A400U400<TA4@01d@00fQ4
A00=A08T2T@00fQ4A005A00394A400A400<TA4@02T@00fQ4A009A004J4AXA09X0d@4J09400>8A8P0
0XP01:b8R8P2S005R6R<S8P00Z`018R/[8`2[003R:c<00>/00B8[8b/0hP01Xb8R8R<J0B800><R8P0
0VP4R007J8b/R8b/S004R005J8R<S:`00XP01Zb8R:b8[0:<00B/d<b/0m03c003d:c@00:/0]000lc@
c002d00@c=3Ad?G@lOG@dOG@mM3el@;@00CAc=3<0m001/cAd=3ed@;@00?<d=001M001lc@c<c@mO40
0_D00oWjnP06nP03no[j017j00Sed8b8J8R/c0:/00B<[:c<1:`00m7am@02m@03lOG@00;e00C<[=3<
0]42l@oe00?imM401?D01=7amO44m@03lOG@00B/00?<[<`00]001/b/c:c@[0><00B8S8R<18P2[0>8
00=XR6P00fPGA003J4A400m400<TA4@00T@00bA4A00:A00494@T90Y40R@:A08T14@4J0A40VP2R0MX
0XP00fR8R002R0=X00=4R6P00fP2R003J8QX009X00A4J6Q40VP3R09X00>8A6P00VP00hQ4J002J004
R6QXJ0:80VP00hQXJ003J0B800=XR8`00hP00fR8R002J003A6QX009X0d@5J09400>8J6P01FP01:aX
J8P3J003A6QX00UX18P016R8R6P3R007S8R8S8R/S003R0:<00>/S:`00VP2S007R:b<[8b8[002R000
24@00bA4J005A00394A400=40b@6A00394A400A400@TA2@T3D@290U400<TA4@00d@00bA4A004A004
94@T90Q40R@?A0@T1T@3911400<TA4@02D@00bA4A006A003J4A400a400EXA4AXA002J0I400=XR8P0
0VP014B8J8`2R003S8R<00>800F<[8b<R002S008[8b<S:b8S:`3S0>800QXR8QXR6R8J0:80VP6R0:<
00B/S:b/0XP00hb8R004R004S:b<S0F/00B<[:c<0Z`2c004[8b/c0:/00C<d=3A0]000lc@d004d007
dO7@d?G@d@02l@;A1]000lc@[002d005dM3Ad=402=002<c@c=2/c=3a0oD00oWjnP0InP04nOGad0:8
0X`6[0;<0m02m@03lOGe00;a00C@lO6/1=02m@05dOGemOT04oD02]7alO7AlM7elM49[003c=2/00>/
0XP00jb8J004R004J8R<[0:<0hP5J0e400<TA4@00d@00bA4A00DA00394A4008T00E492A49009A0@T
00=494@02d@00bA4A005A08T0T@3J003A6QX009400AXR6R80VP3R004J8R8J0:816P014AXR6P2A0eX
00E4J8R8J003A003J4AX00UX0XP6J003A6R<00:800AXR6QX0XP5J004A6Q4J0E40VP2R003J4A400AX
00>8J4@01fP2A006R6R8J8QX0T@2R0=X00B8J6R80fP2R003S:b800:80X`3R003S8R<00:800MXR8R8
[8R<00B80J`1S0005d@00bA4A004A00494@T90=40b@4A0@T0d@290i400<TA2@01D@00bA4A00=A0<T
3D@590940R@3A0@T34@390U400=XA4@094@5J006A6R8S8QX0hP00hb8R002S004R:b<[0>80Z`2S0>/
1HP00hb8R005R007J8R8S8R/S004R004S8R8R0:<00B8S8b<0XP4S006R8b/[8R<0j`00hb/[003[005
S:b/c:`03=000m7@m@02l@04d=7@d@;a00CAlM7A0]000lc@c002d004dM3Ac0;@00?Ad=000]001Lc@
d=3<00?@00B/c=3A0_D00oWjnP0FnP08nOGinOGimM42d0:/00?<[:`01J`01<c@d?42d@;e00SAlO7A
d?G@d@;@0o43m@03nOGe00oe00?amO400_D2l@08mO7edM3<S:`3d005c=3@c:`01H`01:b<S8P2S003
[8b/00:<0j`4R004J8QXJ09400AXA4AX54@00bA4A004A00494A4J09400@TA2@T1D@00bA4A00JA0<T
1D@01BA4A4AX00E40fP4A0=X0XP2J008R8aXJ8QXA6P3A008J4AXA6Q4J4@4J0:816P2R0IX0T@6J0>8
00=XR6P016P018QXJ6P2R006J8R8J8R<0fP00hQXJ002A0=X1D@01FR8J6Q400AX00>8J6P00fP01HQX
A6Q400IX00=4J8P018P01FR8J6R800=X0hP2S0>80X`5R007S8R8R6R8S003[0:<0HP1S06<000EA0<T
1d@29003A2@T00U40b@CA00594A4A2@00d@00bA4A007A00394A400941R@3A0<T14@00bA4900290=4
0b@4A00394A400E40VP5A00394@T009400=XA4@02D@00bA4A00JA004J4A4A0AX0T@4J0:80h`00jb<
R002S003[8R<00:800F/R8b/S004[0><00B8[8R80VP00hQXR002J0>800>/R8P01HP01:b8S8`2J005
S8R8[8`00XP00hb8[002[003R:b800>81J`01Hc@[=2/00;<00>/d=001]02d@05d?7AdM000m401]3e
dOGad@;@00?<d=000]001]7@c<c@d@C@00GAd=7A[002d005c:b/[<`00_400oGinP0FnP06nOGen_Gi
0_D01?WelL`3d0:/00><R:`00Z`5d004lOG@m@;a00OAmOGAd?Ga01Oe00CamO7a1=401?GAc8`5[004
c=3@d0>/1H`00hR<R002S004[8b8R0>/0X`018QXA4@6J0M400<TA4@01D@391=40b@4A004J4@T90A4
00<TA2@00T@00fQ4A006A00494AX909400@TA2@T0T@00bA4J003A004J4AXJ0A416P3A003R6R800:<
0hP2J0:800AXA6Q40fP4A09X00=4J6P01FP00dAXR008J003A6QX00=X00>8J6P00XP6J0^800AXR8R8
16P4A0AX0T@4J003A6QX009X00>8J6P00VP00hQXJ003J003A6QX009X00F8J6QXR003J0:80VP00hQX
J003R0:<0Z`2S003R8b<00F800J<R6QXR8`2[0:<00>/S8`00H`0009400@TA4@T44@00bA4A008A003
94@T00E400<TA4@00T@00bA4A00JA08T24@3909400<TA2@00T@01BA4A4@T009400=X94@01D@012A4
A4@3909400=X94@01T@016Q4R6P4A0<T1T@00hQXA003A003J4@T00a400=XA4@014@016Q4A4@29094
0VP00dAXA002A004J4A4A0AX00J8J8R8[8`2[0:800>/J:`00Z`01M28[:b<00:/00B<R8b/18`00hQX
R002R09X00N<R8b8S:b<00:80VP00jb8S004R003S8R800B800F<R<b<[002R0:<00AX[:b<1J`2d006
c=3<d<c@0]400oGAc002d0;A00K@lM7@mM02d@03d?Ge00G@00G<[=7@l@05d003dM3@00;@00cAlM3<
[=3<[=3<d=42m@03nO[j00;j00?in_X01oX00oWjnP05nP04nO[im@;i1OD01O7Ad=3a00>/00B<[:b/
1]000oG@l@02m@03d?Ge00?A0oD00o[em@07m@03nOGe00ge00SAmO7AmM6/S0F/0m05[004S:b<[0>8
0X`2R003S:b/00B<00>8J4@01fP6A08T1T@391=400<TA2@00d@00bA4A006A00494@T90=41R@014@T
A4@3909400<TA2@00b@5A0AX00E4J4A4J002A0AX0hP01FR8R6Q400=X1T@3J0A400AXA8R816P014AX
J8P5J003R6QX00EX00F8A6QXR006J0N800=XR8P018P00fQ4J002J0A400=XR6P00fP01HQ4A6Q4009X
0T@00hQ4A002J005A6QXJ4@01FP00dAXJ002J003R6R8009X00F8J8R8J003R004S8R8[0B800V<R8QX
S8R<R8`00fP2S005[8b/S8P00Z`000U400@TA4@T0d@00fQ4A002A00394A4009400<TA4@01d@00bA4
A00@A00394A400e400<TA4@00b@8A0<T1D@00bA4A00>A00394A400m40VP5A00394@T008T1T@016S<
J4@2J1i400=XA4@00d@00fQ4A002A004J8R8[0B800B<[:b/1HP00hb8S002[0:<0Z`038b/[8b8S:b<
R6R8S0:800AXR8R<1hP01:b<S8`2[0:<0Z`00hb8R002R0:/00B<[8c<0j`00hb/[006[0O@00?<d=00
0m001?7@d?42d0?A00?ed?400_400m7@d002d003c:b/00C@00>/d=001]001m7@[:c@[<`00m001?7e
mOD2nP03nO[j00;i3_X00oWjn@04n@03n_Ge00Ge0_401m2/[8b/c:`00/`2[006c?7ad?7A0_42m@;A
0_401?GinOT3m@03nOGe00;e00?imOD03OD3l@04dM3@[0:<1J`2d003R8b<00:/00><[8`01X`2[003
S:b/00:/0X`00hQXJ003J006A6Q4J4AX2T@012A492@CA00394A400E400<TA4@01d@290M40R@00fPT
A0039005A2@T94@012@6A004R6QXA09X0d@00fQ4A002J003R6QX00>81FP6A0AX1D@6J003A6QX00AX
00B8J6R80fP00dAXJ007J004R6R8J0B800B<R8b<0XP2S0:81FP3A0AX00A4J6QX0T@3J004R6QXR09X
00=4J4@01FP00dB8R004J0F80VP3R007J8R8J8QXR002S0:80h`3R0:/00F<R8QXR002J003[8b<00F/
000IA00394A400M400<TA2@00d@00bA4A00:A00394A4015400@TA2@T2T@012A4A6P2A00394A400e4
0R@?A003J4C<00=X00A492@T0T@00bA490039003A6QX009400=XA4@00d@00fQ4A00BA003J4A400Q4
00IXA4AXA8P2S003[8R<00:800R<[8b/R8b/S0B800>/R8P00h`00hR<S003S003[8b8009X00>8J8P0
0VP6R004J8QXJ0b800><R8`01H`2[005S:c<[8`00Z`00hb/[007d003c=3@00C@00CAd?7@0m401=3e
dO42d@?@00C<d<b/1=001=7<d:`3d0?<0m04[003c=3@00Ce00?in_T01?T00o[inP0;nPKi00GenOWe
nP03m@?a00C@[:b/0]000jc@c002d006dO7ad?7@1?D2d@03mO7e00_e00?imOD01OD00oWem@03m@06
nOGemO7A0]02c0V/00F8S:b<[003S0>/0h`5[005S:b<R8`00XP3J09400=XA4@02D@291e40R@00d@T
9002A0<T00=494@014@49003A2@T008T00A494A40R@2A00494A490M400=XA4@014@00bA4A002A0=X
00>8J:`00XP00fR8A002A09X00F<J6QXR003J0E400=XR6P01FP01HQXJ6R8009X00I4R6QXA6P2R0IX
0XP2J007R8b<S8R<[002S005R8b8S8P00VP4A0=X0T@5J0=416P00hQXJ004J003A6QX009400=XA6P0
1FP00hQXJ003J004R8b8R09X0XP00hb8R003R005S8R8S8P018`2R003S8QX00>800><[:`00X`000=4
00<TA4@02d@016Q4A4@39003A2@T00I400HTA2@TA2@2A08T34@00bA49002A08T1T@390940R@00d@T
A005A00394@T00=400@TA4@T4T@01BA4A4@T00]40VP2A0=X00I492@TA2@;A005J4A4J4@00fPAA003
J4A400M400=XA4@01D@2J0:800=XR:`00XP01:b<R8`2[0>80Z`3S0>800><R:`00Z`2S003J8b8009X
00F8J8R8S002R003S8R800N800><[8P018P02:b8R8b/R8b81j`00hb/c004[0;@00?<d<`01=001]7@
d=3ad@C@00CAd?GA0]000m7@d004[004c=3@d@;a00OAd:c@[<c@00:/00?@[:`01:`00lc@d006m@03
n_We00Ci1OX00oWjnP03nP;i0_D00oWjn@02m@07nOGenOGam@03d0>/00?@lM001=003OG@d?7edOGa
mM3Ad?400oD01?[imOT5m@03nOGe01?e00?ad<`00]001Jc@[<c@00;<00>/c:`01:`6S003[8b<00F/
00><R:`00XP3J003A6Q400]40R@4A003J4AX00Y400<TA4@02D@00bA4A0079004A2@T90940R@2A003
94@T00<T0d@00bA49002A00394A400I400<TA4@024@00bA4A004A0=X00><R8P00VP014AXJ8P4J003
A6QX00A41VP00dAXA003J0940VP00dAXJ003J003R6QX00EX0hP2J0B800V<R8b<R8b8J8P00fP5A007
J4A4J4AXA005J003A6Q4009X00=4J4@014@6J0:816P01DAXA8QX00R800B<R8R80X`00hR<S002S0:8
00B<[8R<1HP00hb8S003[0005d@00bA49007A0@T00E494A49006A003J4A400A40b@014@TA2@7A003
94A4009400<TA2@00d@590=40R@9A0<T34@00bA4A00;A0=X1T@390Y400=XA4@01D@00fQ4A006A003
J8Q400]400HTA4A4R6P7A003J4AX00>800B/R8aX0hP03:b8[8QXS:b8S:aXR09X0X`2[003R8b800F8
00=XS8`00XP02FR8R8R<R6R8[003R0:<00>8S:`00Z`3R0:<00Z/R8b8[=2<c:b<0Z`01M3<[:c<00G@
00?<lM400_401M3amM7e00;@00KAd=7ed?D2d005lM3<c:`00m001_7Ad?GAl@C@00R/d:c<[<b/c0:/
0/`01M3edOGA00?e00KimOGimOT;nPGe0_T01_GimOGjn@;e00W@lM2/c:c<mO400]001<b/d=03d@?e
00?adM000]03m@04n_Wjn@Oe00CimOGi1?D00oWem@0;m@03lM3@00?A0Z`01M2/c:c<00B/0X`2[0><
00J/S:b8[8`2[0><0XP00fR8J00;A00394A400I400AXA6QX24@01BA4A4AX00A40R@2A00394A400DT
00I494@TA2@3A00494A491Y400=XR4@00d@290940VP5A09X00B8J8Q40fP014B8J6P8A004J4A4J0E4
00=XA4@01D@6J004R6R8J0:80VP018QXJ8P2S0>800=XS8P00XP5J0a41FP014AXJ4@4J0=40VP2A005
R6QXJ8P016P01TAXJ8QXR09X00F<R8R8S006R0:<0XP01FR8R8R/00F800N/R8b8[<b/0068000@A003
94A400i40b@01D@TA2A400<T0T@00bA4A006A00394@T009400<TA2@01D@01BA4A4AX00940R@3A0@T
1D@00bA4A009A00394A401U40VP7A08T1T@00bA4A005A005J4A4A6P024@00fQ4A00AA00394A400I4
00MXR8QXS:b<00F80X`00fR8S004R003J8R800:80X`2R0><1hP3J004S8R8R09X00F8S8R<R004S003
[8b800:818`2R003S:b/00N/00K<[:b/d:`2c0?@00OAlM7adOGA00C@0]400o7@[002d@;@00F/c:b/
c002d006dO7AdO7A0m02[003c:b/00F/00C<d=3a0_D00m3am@05m@;i2_X00oWem@04m@?i0oD01_We
mOG<d0>/0m001<cAc:`2c004d?7Al@;e00CamM7A1?D01?WjnOTMm@03lM7@00;@00KadLc<d<`2[004
S8R<S0>/00><[8`00Z`2R006S:b<[8b/0X`2R09X5T@00fQ4A004A00394A4008T1D@00bA490059094
00<TA2@00R@00d@T900390A41B@;A00394A400Q400AXA6QX0T@00bA49009A09X0d@00fQ4J002J003
A8R800=X0T@016Q4A6P2A003J4A4009400=XA6P02D@2J003S8QX00=X00>8J6P00VP2R0><00>8S8`0
0X`018R<R8P2J005R6Q4A6P00T@2J003A6Q4009416P6A0>814@;J005R6QXJ8P00fP5R005[8R8R6P0
0XP3S0F80h`018R<R8P2S004R8b/[068000?A08T1d@00bA4A006A00494A4A0<T00=492@024@290]4
00DTA4@TA0039003A2@T008T0d@00bA4A005A08T2d@00bA4A00>A08T2T@00fQ4A003A00394A400a4
00=XA4@03T@00bA4A00BA00394A400A40VP4R0:/28P01:b8R8P2J0N80h`5R003S:b800=X0X`3R003
J8R800:80h`01XR<S8R<R0:<00>8S8`00hP00jb8[002[0:<1J`02<c@c=2/d?7e0_401m7elOGamM40
1=001=7@[=02d@03d<b/00>/1=000m7@d002d0;<1J`00lb/[002[004c:c@d@;@00SamOGenOGim@;i
0oX7n@Se0_T5m@;@00>/c<`00Z`01M3<d=3A00;@00?<[=000]402?7emO7elOGa1?D2n@ge00?imOD0
2oD01O7emOGa00;@00?Ad=000]02[003S:b<00:<00B/S:b/0XP2S004[8b/S0>/0X`01Jb<R8QX00:8
0fP5A005J4A4A6P07D@49004A2@T90=400@TA4A40R@2A00394@T00DT0d@00bA4A00AA003J4A400]4
00AXA6R80VP3A0=X0T@00fQ4A006A003J4A400E400=XA6P01D@2J0940fP2R0=X0XP028b8R8QXR8b8
0X`2R0><00N8J6QXR6R8009X0T@2J004A6QXJ0940VP5A004J4AXA09X00E4J4AXR006J003A8R800AX
00F8J6R8J003R09X0XP00hb8J002R0:<28P01Xb/R8b/R0F<000:A00394@T009400<TA4@01D@290Y4
12@2A0<T00=494@04d@00bA4A00aA00394A400a40b@5A00394A400M40VP:A003J4A401a400IXA4A4
R8`2R0B<1HP2S0:80fP2R003J8R800>80h`01:b<R:`2S0:80VP9R0><00J/R8b/R8`2R0><00J/S8b8
[8`7[003c:c@00:/1=000m7ed@04l@04mO7ed@C@00Wad=7@dM3<[<`00Z`2d004mM3@l@C@1j`00lb/
[003[007c=3Ad?7en@04m@Ci0_X3n@;j00?imOT01oD2n@Ke0]401=3<c=02d@04d=7@d@C@00?edM00
0]001_7@mO7ed@?e0_T00o[em@0;m@03nOGe00_e0_400m7ed@06d0;<00><c:`00Z`4S005[8R<S:`0
0h`00jb<[004[005S8R8R8`018P2J0=400=XA4@00T@00fQ4A003A003J4A401540R@2A0<T00=492@0
0b@5A0<T0d@29003A2@T008T2T@00bA4A007A00394A400E400=XA4@01D@00fQ4A002A004J4A4J094
16P3A009J4A4A6Q4J4AX00M40VP3A004J4A4A0YX18P016R8J8P4S0:80X`6J003A6Q4009X0T@00fQ4
J003J0Q400EXA4AXA002J0:800EXR8QXR004J003R6QX00IX18P016R8R8P3J0:800F<R8R8S003R0:<
0j`2R0:<0Z`1R0000T@290Q40b@4A00394A4009400<TA4@01T@690=40R@00d@T900>A00394A400]4
12@;A00394A4009400AXA4A40R@4A00394A400<T1d@39003A2@T00U40b@00d@TA00<A003J4A400I4
00=XA4@03D@00fQ4A00DA006R6QXR8b/0XP4J0:<00B8J6R81FP8R0B<0XP00jb8J002R00:J8R8J8R<
R8b/R0:<01>/R6R8S8R<[8R<R8b8[8b/S:b800>/0m03[0;@00KadM3AmM44l@07mO7Ad=7@d@06d003
[=3<00;@00KadM7AlM44d0>/00F<[:c@c002[003c=3A00?a00?AmOT01OD00oWen@03nP;i0_X4n@;e
0_T2m@03nOGe00Ge0_43d0?a00CelM3a0]000lc@d002d004dM3al@?e00?amOD01?TLm@07dO7AdM3a
d002[0?@00J/d:b/S:`3S0R/0X`6[004R:b/S0:800B/S6QX24@00fQ4A00=A00694@T94@T14@29005
A2A4A2@00T@690E400<TA4@01b@2A003J4A400Q400<TA4@00T@00fQ4A00>A09X14@2J0E40fP8A003
J4A400Q40fP5A0EX1XP5J0B800>/S8P00XP016R8R8P4J003A6Q400E400=XA6P00T@2J0a40hP00fQ4
J00=J0:80VP7R0AX0XP01Hb8R8b8009X0XP00hb8S002R003S:b<00:<000;A00394@T00I400<TA4@0
2d@00bA4A002A00594A4A2@00T@00bA4A00TA08T0T@291141B@2A00494A4A08T00=494@03T@390m4
00EXA4A4J00=A003J4A401I41FP00hb8R002J003R6R800>81VP2R004S8R8J0:800><R8P00hP00hb/
S009R004[8R8R0>/00B<R6R80Z`028b/S8b/S8R/0h`2[005S:b/d?400/`01Jb<d=7e00?A00Cad?7a
1?D00m7@d002d004dM3Al@G@0]401OG@d=3A00G@2J`01Lc@dM7a00We00?imOT00_T00o[im@05n@04
n_Wen@;e00?imOD01oD2d@03d?7a00;@00kAlOG@dOG@c=3<d<c@m@;A1_D2n@03n_We00;i1?D01OWe
mOGA00oe00CAmOGA0_401M7ed=3a00?@00?<d<`03J`00hb/[002[003S:b<00B/0XP00hb8J002J0Y4
0R@5A003J4A400=40R@014@T92@6A00394A400=400@TA2@T1T@3909412@00d@T900FA003J4A400U4
0fP;A003R4AX00A400EXA4A4J00:A09X14@00fQ4J002J005R6R8R6P018P4J0>800>/R8P00hP4J005
R6R8R6P014@00fQ4A006A09X2T@016R8S8P4J003R6QX00YX1XP00hb8R003J003R8b<00J80VP2R003
S6R800:<00B8S:b<0J`000A400<TA4@02D@01RA4A2A490e40R@00d@T9003A00394A4015400<TA4@0
3T@01BA4A4@T009400@TA2@T14@00fQ4A007A00394A4008T14@00bA4A002A00394A400]400=XA4@0
0d@390A400<TA4@03d@00bA4A002A00594A4A6P02D@01BA4A4AX00e40fP00hQXJ005R0=X0T@4J004
R6R8S0b800><R8P01hP2S005R8b<[8`00XP4S0:80Z`3S004[8b8[0B<00o<d=3<d<c@lOG@lM7adO40
1OD01o7@d=3Ad?D01=42d005dOGemM402M03[003S:b/00;<00G@dM7@l@02m@03nOGe00Ge0oT2nP03
nOGe00?e00CimOWi0oD00oWem@07m@03lM3A00;a00?Ad?400_401M3adM3<00;@00CAd=7A0_47m@03
n_Wi00;e00?imOD01?D3l@_e00_amM7amM7edM3Al@06d008c:c<d<b/R8`7[0:<1:`01Hb/S:b<00>/
00B8[8R<0fP2A003J4A400m40R@014@T94@290M40R@00d@T9003A0<T0d@;909400@TA2A40R@2A003
J4A400Q400<TA4@03D@4J0Y400=XA4@00d@00fR8A00BA09X00=4J6P00fP7R0AX00>8S8`018P2J0:8
00=XR8P016P3A0AX1T@2J0Q416P00hb8R004J0:800UXR6QXR6R8J8P00fP2R09X00B8J6R80VP2R007
S8R8R6R8J002S003[6R8009X0XP016R8S8`1[0000d@012A4A2@8A00494A4A0DT2D@012A494@290A4
12@3A00394A4009400DTA2A49005A00394A400i400<TA4@00T@00bA4A00>A08T1T@390A40b@7A003
94AX00U40R@5A08T3D@290=400@TA4@T24@016Q4A4@3J0]400EXA6Q4J003R0940XP5J003A6QX0094
16P01HR<R8R<00:800IXR8b8S8P2J0:800><R8P00X`2[006S8R<S:b<28P00hb/S003S004[8b<[0>8
1:`2d0;A00?adM400_D00m3el@05m@03d?7@00;a00?AmO400m000lcam@02d@C@00GadM3Ad002c0J/
0/`01=3emO46m@03nOGe00;e00GimO[jm@02n@Ce0_T3m@;i2OD01]7adO7el@Ce00?@dM000]001M7@
d=7a00We0oT2m@;i1_D3l@ge00?amM400o42m@;@00J/d?7AlM43d003[8b/00B/00?<[:`00j`01Lb/
c:c@00:/0X`3[0:<0XP2J003A6Q400I40R@2A00394A400Q412@024@TA4@TA2A41B@:A0HT0T@59003
A2@T008T2d@4909X34@00fQ4A009A00394AX00U400<TA4@03T@016Q4J4@5J0>80fP2R004S6R8[0B8
00EXR8QXS002R09X00>8J4@01D@2J0E400EXA4A4J005A0=X18P6J003R6QX00:80VP00hQXR002J003
R6QX009X0hP01HaXR8b800:<0XP028b8R8R<[8R<0VP01Xb8R8R<R06/000=A00394A400=400<TA4@0
24@012A492@3A00394A4009400DTA4A49007A0<T00=494@00R@IA00594@TA2@02D@00bA4900290M4
00<TA4@00T@49003A2@T00=40R@00dAXA00:A00394A400a400<TA4@00d@390e400AXA4A40fP?A004
J8aXR0EX0d@2J003R6Q4009X00>8J8P01XP00hb/S003R09X0XP028c@[8b8S8R<0XP4S0B80X`2R003
J8R<00Z/00G<[:b/c006d005lM7@dO401OD3l@OA0]02m@03lM7@00?@00CamOGA1=02[006c:b/c=3a
0_D00m3em@07m@03n_We00;e1OT8m@;i2oD00m7ed@02l@?e0]02d@04d?7@d@;a2OD00oWjn@0:m@03
lM7a00Ke00?amOD00_D00oWem@03m@06lOGemM3A1=001OGAd:c<00J/00?<[:`00Z`00lb/[003[003
c:b/00>/00C<S8b<0XP00fR8J002J0I412@4A0@T0d@012A492@3A00394A400<T00E492A4J004A003
J4A400=41B@3A0@T0T@490A400<TA4@00d@491I400=XA4@01D@00fQ4A002A003J4A401U40fP01HQX
J4AX00:80VP00hR<R006R09X00F8J6R8J004A0=X1D@2J0Q400=XA6P00VP2R0EX00>8J8P016P5R09X
0hP00fR8R006R004J8b8J0:800><R6P018P00fR8S004S0680J`000=400<TA4@02T@290E40R@00d@T
90029004A2@T90a400<TA4@014@01bA492A494@012@@A00494A490=40R@2A08T2T@490=400DTA4A4
9004A00694A494@T14@00bA4A002A003J4A400E400<TA4@014@00bA4A006A00494A490=400<TA4@0
24@00fQ4A002A003J4A400AX3d@7J003A6QX00=X00F<J4AXA002J0:800AXR8R<0hP2S003[8R800B8
00MXR8b/R:b<00B800><R8`01XP00hb8S002S0V/00G@c<c@c002d004[=3@l@;A00_ad?7elOGadM3A
l@02d@;a00KelM7@dO42m@08lM3@d?7elM42d003lM3@00J/0/`00m7@d002l@We00CimOGe0_TBm@05
nOGemO400_D00o7@d@03m@C@00?adM000]04m@08lOGenO[enOX;m@03d?7e00?e00?amO400o43m@03
nOGe00Ce0]000oG@m@03d0;a00Ked=3@c:`2S0:/00S@[<b/d:b8c0:/00B<[:b/0X`2[007R8b8J4B8
J005A00594A4A2@01d@3909400@TA4A40R@2A00394A400DT2d@590A41B@3A08T0T@012A492@5A0<T
00A494A40VPGA0=X00A4J4A40fPKA004J8R8J0940fP01XR/S8R/S0B81FP2R006A6Q4A6R81d@00fQ4
A003A0IX00A4J8R81FP00hQXR003J003R8b800F800><J8P01hP2[005R:b<S8P00h`2R005S8QXJ8P0
0X`2R0><0005A00394A400E400@TA4@T0T@29004A2@TA0<T0d@390A400@TA4A40R@9A0@T00=492@0
0T@291a400<TA4@024@890=400<TA4@00T@00bA4A007A08T1T@00bA49002A00394A400<T14@00bA4
A003A0DT5T@00fQ4J00?A004J4A4R0=X00A4J6Q40fP014AXA4@2J005S8R8J8P00X`3R003J8R800B8
00MXR8R8S8R<00>800B<[8R80X`3J005R8b/S:`00h`3[00;S:b<d:c@[<b/c=000/`3d003dOGa00Ce
00KamM3@mO43d@04mO7Al@;A00CamO7e1O401]7@d=3am@?@00?<[:`00Z`01Lc@d=3A00ge00?imOD0
5oD01O7emM7a00?e0_402m3amOG@dM3AlOGa00?e00?imOT00oT3m@03nOGe00Ce00?amOD01?D01M7e
lM3a00Ce00?imOD00_D00o7@c007d003mM3@00?@0j`2S0F/00><[:`00Z`01HR<[:c<00>/0X`00hQX
J002J11400@TA2@T14@00bA490029004A2@T90940R@00d@T90049004A2A4A0@T00E492A49002A0<T
14@00bA4A002A00494@T90I400<TA4@05d@00fQ4A003A003J4A400=400=XA4@06T@7J003A6QX00AX
0XP01FR8R6R8009X00F8J6Q4J002A09X1d@00fQ4J002A0MX00=4J8P016P028QXJ6R<J8QX0XP00fR8
R008R005J8QXR6P00X`00hR/S004R003[8b800=X1hP2S00000>/J4@00d@00bA4A002A00394A40094
00<TA2@00R@01D@T94@T00=400<TA2@00b@3A00494@T90Y42B@2A00494A491A40b@2A08T00=492@0
24@690e40R@2A00394@T00I40b@01D@TA2A400<T2d@290M400<TA4@00d@00fQ4A00;A004J4A490e4
00=XA6P00T@00fQ4A002J003A6QX009X00E4J4B8J006R004J8QXJ0R800><R8P01HP01Hb8R8R<00F8
0X`018R/R8P5[004S:c@c0:<00B/c:b/0]001ZcAd?7el@;e00?AmM400m001o7Ad?7@dO400]001_7A
lOGam@;a00CedM3a0]000m7em@02d0;a00?Ad=000]02c003dO7e00;e00?imOD00_D01?WemOT2m@03
nOGe01?e00GimOGel@03m@03lOGa00Ke00CAd?GA1OD2n@03mOWi00Ce0_T=m@04dM3@d0Ke0_42m@O@
00CAd=7e0]42d0F/00K<[<b/c8`2[003c:b/00>/00C<[8b/0X`00hR<J002J003R6Q401]40b@2A0`T
00=492@00T@390A412@3A0<T1T@00bA4A004A00394A400E400EXA4A4J00<A005J4A4A6P04d@00bA4
A00?A003J4AX00]X0hP00hb8R002J003R6Q400=X1T@00fQ4A004J004R4AXJ0941FP00hQ4J006J0>8
00=XR8P01HP00hb8R003R003J8QX00>800AXR8b/0XP018b/R8`5R003[8R/00><0J`1S0001d@012A4
92@2A08T0T@29003A2@T00@T0d@590941B@00d@T900390I41B@00d@T9002A00394@T00m40R@5A003
94A400<T0T@012A4A2@3A00394@T00DT1T@00bA49004A0@T0T@00bA4A005A08T00=492@014@290Q4
00<TA4@00d@00bA4A007A00594A4A2@02d@00fQ4A00=A003J4A400940VP014AXJ4@4J09400=XS6P0
0hP00hb8R005J0:800=XR8P00XP4J0>818`00hR<J002R003S8R<00B<00Z/R8b/c:b<[<c@1Z`3d003
dM3A00;e0_400m3ad@05d003dO7A00;A00C@dM7e0_44m@06lOGamM7a0oD00m7al@02m@?@00CAd=3A
1OD00oWem@0Qm@03lOGe00?e00GamOGad003m@03dOGa00Ke00?imOD05?D01_7AdM3ad@Ge00?@mOD0
0_400m7@d002d006dM3AmO7A0/`00jc@c002[0;<00?@[<`00X`5[00:c:b/[8b/S:c@S0:80VP3A003
J4A400U400=XA4@02d@29003A2@T00lT00=494@012@01D@TA4@T00=41R@>A08T0d@00fQ4A009A09X
0d@00fQ4A003A003J4A400e400<TA2@014@00bA4A00:A004J4AXA0EX00>8J6P01VP4R003J8QX00:8
0fP5A0MX00=4J6P01FP00hb8J003A0=X00B8J8R80VP8R003S6R<00:80VP2R003J8QX00:800>/R8P0
0XP018b8J8`4R003[8b<00:<0Z`000U40R@8A08T0T@390=400@TA2@T0d@59003A2@T00<T14@012A4
A2@5A00394A400A400<TA2@02T@2909400<TA4@00d@00bA4A003A08T00E494@TA0029003A2@T008T
2D@00bA4A003A00394A402940R@8A00394A400E400<TA4@04d@3J0M40VP014AXJ6P4A007J8R8R6R<
[002J008R6QXA6R<R6P3R003J8QX00>800>/S:`00XP018b/R8P2S0:800B<[:b/0X`00hR<S004[003
c=2/00F/0m001=7amO42m@;A00G@lO7@d@03d007dO7ed=7ed@02m@03dOGe00;e00?AmOD01?42m@;a
00?@dM400m000o7@m@09m@03nOGe00Se00?jmOD02?D00oWen@06m@?a0oD00o7em@02m@03dM3e00Ke
00?amOD00_TFm@;a00?Ad?400]001OGAmOGA00;e00GamM7@l@02d00:dM3AlM7ed<c@c0;@00>/R<`0
1:`01Hb/[8b/00;@0j`018b/c8P2[0:816P00dAXJ00KA08T00=492@01B@3A0@T0T@00bA4A00390A4
0R@2A0LT0d@390M40R@01D@TA4@T00E400=XA4@00T@016Q4A6P5A003J4AX00Q40R@2A003J:a40094
0R@5A003J4A400A400XTA4A4J4AXA6Q426P00dAXR008R09X00F8A4AXA003J0>81VP4R004J8R<R0UX
0hP2J004R6QX[0:800=XR6P00XP00haXR004R004J8R8[0:800AXR8QX1HP2[003R:b/00:/0M0000E4
00@TA4@T1T@00fQ4A00690A40b@00d@T90049006A2@TA2A40b@3A00494A4A08T24@01RA492A490I4
0R@3A00394@T008T00E492A49004A0@T00A494A40R@2A00494@TA0@T1D@00bA4900290M400<TA4@0
0T@390U400<TA4@03T@00bA4A004A08T1D@392I40fP018Q4J8P9J003R6QX00=X00F8J6R/J002R0:<
00J/S8b8J8`3R004S8R8S0F80h`5[0;<00N/c=3@dO7A00;e00KamO7AmO43d@09d=7AmO7elOGa00We
00CamOGA0o44d@04c=3<d0;a00GAmOGel@04m@;i2OD00oWem@04m@03lM3e01Oe00?AmOD00_D00o7e
l@03m@04nOGinAGe00CadM7a0]000oGam@03m@09lOGelM7edM3<00_@0j`00m2/[006[003S:b/00:<
00B/S8b<1HP00fR8J002R003J4@T00I400<TA4@01D@00bA4A002A0<T14@00bA490029003A2@T00<T
1D@01BA4A4@T00U400<TA4@012@014@TA4@390E40b@01D@T94@T00940R@MA00494A4A09X0T@391M4
1FP00dAXJ002J0>800EXR8R8J002A003J4AX00AX00>8J6P02VP3R0=X00>8J6P00VP6R007J8QXJ8QX
S00<J0^800=XR6P01hP2[06<0007A00594@TA2@01d@290M41R@3A08T00=492@01B@8A00394A400M4
0R@9A00394A4009400<TA4@00d@4909400HTA4@TA2@8A0<T00=492@012@2A0<T2T@290I400<TA4@0
3D@00fQ4A00@A08T14@00bA4A008A003J4A400A400<TA4@024@016Q4A6P6A09X0T@00fQ4A004A09X
00B<J6R826P00hQXJ002J0>80X`018QXJ8P2[0:800IXS8b/R:`4S003R8b/00>/00C@[=3@0]42l@03
mM7a00;a00Ked?7@dO43d@04lOGel@;e00?amOD00oD01?7emO43m@05lOGelOD01?400oGAc002d0;e
00?adOD02_D00oWem@0Gm@03lOGe00;e00KimOGamO4=m@03nOGe01Ce00CadM3<0]03l@;e00CadO7a
0oD2d004c:c@d@?@00Kad=3<d<`2[004d:b/[0?<0]001:b<[8`2[003d8b800F800F<R8QXR002J0E4
00<TA4@03D@290I40b@4A0<T14@490I412@2A0/T00=492@00T@3909400@TA4@T1D@00bA4A004A003
94A400U40R@;A0<T00=494@00R@DA004J4A4A0=X00=4J6P00VP01HR<R6R8009X0T@2J003A6Q400UX
00=4R6P00fP00hQXJ002R0=X00=4J8P00XP2J0:800=XA6P016P01HQXJ6Q400=X0XP01FR8J8QX00J8
00F/S8QXR003J007R8b8J8R<R001S00014@00bA4A00390U412@6A0@T14@3909412@3A0@T24@00bA4
A00;A00694A494@T1d@00bA4A00<A0XT00A492@T1T@390A40b@8A08T00I494@TA2@2A004J4A4A09X
4D@290a400<TA4@01d@00bA4900<A003J4A400A400=XA6P02D@3J005A6Q4A6P00T@3J003R6QX00J8
00><R8P00XP00hb8J002R004S8R<S0F800><[<`01=001<c@d=43l@04mM7Ad@?a00KAlM7@dO4:m@03
nOGe017e00CAd=7a0oD00o7en@0;m@05nOGemOT06oD2d@03lOGe00Oe00?amOD02OD00o7el@0:m@;a
00CAlM2/0]001=7adO43d@03lM7A00;e00?ad:`00]004?7@d=3ad=7<d<b/c=2/S8P4[009d:b<c:b8
S:b<00B800=XR8P00XP016R8J8P2J0=400<TA2@044@3909400@TA4A40R@;A00394A400]41R@00d@T
900390=40R@3A0DT1T@00bA4A002A00394A400DT00I492@TA2@5A08T14@01BA494@T00U400=XA4@0
14@00fQ4A008A003J4A400A41FP00dAXA002A09X00=4J4@00fP00hQXJ003A003J8QX009X0XP016Q4
R6P2R0IX00>8J6P01VP00dAXJ002J004R6QXJ0>80VP2R004J8R8S0J800IXR8R8J8P2S003R8b<00:<
0006A00394@T00]40b@6A00494A490=412@3A08T14@00bA49002A08T14@490]400<TA4@00T@00bA4
A00?A00394A400A400<TA2@01B@00d@T9007A08T0T@29004A2@T90Q40R@8A003J4@T00A400@TA4A4
0R@00d@TA004A0DT2D@00fQ4A00;A00394A400=40VP;A00394A400]416P8A09X0XP3J009R6QXS6R8
[8R<009X00^<R8R<[8b8J:b8J002S004[<c@c0G@1?401?G@lOD3d@06lM7@lM3a1OD01O7emOGj00Oe
00?imOD02_D2l@?e00K@mOGin_T9m@;i2?D00m7ed@0Cm@;a00?AmOD00oD00o7em@02m@05dOGemOX0
1_D01=7amO42m@03lOGe00Ce0]000oG@c003d0;a00CedM7@1O400oGAd003d005dM3ad?D00]03c006
d<c@d:b<0Z`2S0>/00?<d:`00j`3R003J8QX009X00><J8P00VP00dAXA004A00394A4009400<TA4@0
14@39003A2@T008T0T@012A4A2@6A08T1d@00bA4900490A43b@014@TA4@790A42B@2A0@T1D@00bA4
A004A08T74@00fQ4A00:A003J4A400=X0T@01FQ4A6Q400AX00A4R8b80VP2A0=X00A4J8R80fP2R09X
00R8J4A4J8QXR0=X00>8J6P00fP00hQXS003R005J8QXR8`00XP016R8J8`2R0:<0XP016R8S8`2R006
[8b8R8b/0H`000I400<TA4@02d@00bA4A006A0DT0T@390A40b@3A00394@T00@T0T@00bA4900290I4
0R@4A08T14@012A4A2@5A00394@T008T0d@29003A2A400Y40b@7A0@T0d@390Q400<TA4@014@012A4
A6P5A08T00=494@00T@390A40b@:A00394A400M40R@3A00394@T008T24@00bA4A00AA0=X1D@00fQ4
A002J003R8b8009X0XP3J0B800><J8P00X`2R004S8R8S0:/00>8S:`00j`3d00:mM3amM7amO7ed@;a
00?AlO400]001=7@mO4;m@03lOGe00ke00?ilO402?D00o[em@02n@?e00CimOGi8?D01M7emOGA00We
00?imOD01?D3l@03d=7e00Oe00?adO400]001:c@dM02m@?a00[AmO7amO7AmLb/0m001o7@d=7@dM00
1<`00m2/[00:[0><00>8S8`018P00fR8[002J0:800=4J4@00d@00bA4A002A00394A400I40R@2A0LT
00=494@01D@390A40R@00d@T90059003A2A400lT0d@29003A2@T00<T1D@01BA492A4008T14@59094
0R@00d@TA004A00494A491]400=XA4@044@2J0940VP00dAXJ002J003R8aX00EX00=4J6P00XP01FR8
R6R800MX00>8J6P00XP016R8J8P2J0>800J<R8QXR6P2R003S8R800B800=XR8`00XP00fR8R004R0><
00>8[:`00J`000Y40R@8A00394A400M41R@2A00694A4A2A40R@7A0<T0T@00bA49005A00394A400<T
00=492@00d@012A4A2@2A08T24@00bA4A00AA00494A4J0E412@2A0@T2D@00bA4A007A00394A40094
00@TA2@T3d@290I40b@7A08T0d@590Y400<TA4@034@00fQ4A00;A0=X00>8J6P00fP7R003[8b800:8
00MXR8R8J8R/00:800F<R8b/S002[0;@00GAlM3ad@05m@06dO7adO7A6?D2n@Oe00?adO402?D2n@Se
00?in_D03oD3n@[e00?amO405?D2d@03mM7a00[e00Gad=3@d@04m@Ca00CAmOGe0_46d008dO7AlM3A
d<`2d003c=3<00B/00?<[8`01:`00hb/R002R004S8R8R09X1HP00fQ4J00AA003J4A400HT00=492@0
0R@00d@TA0039003A2A400A412@01d@T92A494@02R@00d@T9004909400<TA4@02B@4A0<T1d@490Y4
00<TA4@024@00bA4A004A08T2d@2J1940VP3A0IX00I4J6R8J4@5J004R6R8R0=X00>8J6P00T@4J003
S8QX00=X00>8J6P028P00fR8R004R004J8QXJ0>800=XR:`00XP2S003[8b/00>80H`1[00000=494@0
0T@00bA49003A0<T00I492@TA2@3A00394@T00=40b@00d@T90029005A2@T94@012@5A00694@TA2A4
0b@4A00494@T90E400DTA4@TA0039003A2A401A40R@8A00394A400I42B@6A08T0d@00bA4A004A003
94@T00Q400<TA4@02D@00bA4900290E40R@8A0LT14@00bA4A007A00394A400=400<TA4@05T@3J003
A6QX009X1XP018b8S8`3R09X18P2S0>/00><[=000]03d@?a1_D01?7AdM4Bm@03nOGi00Ce00?imOD0
1?D2d@04mM7ed@;a6OD00o7em@0Am@05lOGamM404OD5l@03dOGe00Se0_400m7@m@05m@05lM7adO40
1?D00m3Ad004d004mM7ed@;@00KAd=2/d<`8[006S:b/S:b<1HP00jb8J003J005R6QXA6P04T@49094
00<TA2@022@00`0T90039004A2@TA08T00=494@00R@3A00394A4008T00E492@TA0049004A2@T90M4
12@3A0HT0T@02BA4A4@TA2A4900<A00494A490m400@TA4A40VPBA003J4A4009416P3A004R6QXA0AX
00J8J6R8J8P3J003A6QX00>80fP01DAXJ6R800IX0hP016R8[6P5R006J8R8R6R80VP00hR<R003J003
R8b800:800>/S8P01HP1S06/000=A00394A400@T1T@29004A2@T90A400@TA2@T0d@290Q400<TA2@0
2T@390A400<TA4@01b@00d@TA008A00394A400E412@00d@TA003A00394A4009400<TA4@01D@490A4
0b@JA003J4A401940R@9A00594A4A2@044@00bA4A003A00394A400]40VP4A004J4A4A0AX0T@016R8
J8P3J006R8b8R:b<1hP3S0:/00B8[:c<1=02l@?e00_amOGed?7AlOGad@02l@We00?imOD03oD02m7e
mOGad=7edOGi00We00GimOGel@0:m@03lOGe01;e00?amO405OD00o7em@0;m@03lM7a00;e00?amO40
1?401M3AmOGa00?@00KadM3@dO42d@03lM3a00C@00J/c:c@c=08[008S8R<[8R<[8P2J003R6QX009X
34@016Q4A4@290A40b@00d@T90029003A2@T00dT00=492@01B@2A00494A4A08T0T@290940R@3A003
94A400=40R@00d@TA00290a40R@6A00394A401Y40b@GA09X0T@4J003A6QX00=400=XA6P00T@5J004
R6R8J0:800=XA8P00VP014AXJ4@9J0:816P5R003J8QX009X1XP01HaXR8QX00:800B/R8b/2HP000=4
00<TA4@01d@29005A2A494@00R@4A0TT00=494@014@00bA4900390A40b@EA00494@T90]400<TA4@0
1d@39003A2@T00<T1T@00bA4A004A00594A4A2@00d@390A400<TA4@01D@00fQ4A00291U400@TA4@T
3T@00bA4A002A003J4A400U400=XA4@014@00fQ4A006A003J4A400A40VP<A0UX00F<R:aXR004[0>8
00EXS8R/R004S007[8cAc=3ad002m@03lOGe00?e00Sad=3edO7@l@We00CjnOWj0_T;m@04dOGed@;e
0]400o7@d002m@06nOGenOGi0_D3n@[e0_401=7amO4<m@07nOGemO7ed@0>m@03nOGe00Ce00?amOD0
1oD2n@Ge00?AlO400_D3l@03dO7A00Ga00G@dM3@d@02d00;lM7@d?7@lM7@dM000j`01/c@[8b/c0:/
0X`00jb8R002R003S:b<00:816P2R09X0d@2J0a400<TA4@00R@3A08T1D@390I40R@2A0LT0d@29094
00<TA4@01R@2A00394A4009400<TA2@00R@2A0@T14@290=40R@8A00494A490]400<TA4@02D@291Q4
00=XR4@00T@4J09400=XA4@02D@3J0>800EXR6Q4R003J09400=XA6P016P00dAXJ007J0:800B<R6R<
0XP01FR<R8QX00>800]XR8R8J8R<R8b8J002R0:<00>8S8`00HP000i40R@01T@T92A490I412@014@T
94@290A41B@6A00394A400A400DTA4A49006A00494@TA0<T0d@00bA4A00@A0PT1T@39003A2A400=4
0R@2A00394A4008T00A494A412@6A09X00<TA4@00T@00bA4A00@A00394A400A40R@<A0<T14@00bA4
A004A09X1D@00fQ4A002A00394A400e40VP?A0AX00]4R8b/R6R<c8b/S008R009S8R/[<c@c=3A00Ga
1?D2l@07dM3elM7el@07m@Ci00?jnOD01OD01?7elOD3l@03mM7e00Ce0o44m@?i0oD00oWjm@0;m@04
lM7ad@ge00?imOD00oD00o7el@0;m@03nOGe013e00?imOD00oD00o7em@03m@05lOGemO400oD01?7e
dM43d009dM3AdO7@dM3e00;a00?Ad:`00Z`2d003[8c<00J/00>8S8`00X`00hR/R002R0AX00>8J6P0
1T@00fQ4A00<A00394A400Q40R@;A00394A4008T00=494@00T@00bA4A007A0@T24@890940R@5A08T
1T@012A4A2@7A003J4A4011400<TA4@04T@00fQ4A002A0=X14@2J0I400=XA4@00d@00fQ4J005J003
R6QX009X00E4J6Q4J003A005J4AXJ4@01fP2R003J8R800B80VP2R004S8QXJ0:800>/R8P018P2S003
R6R/00:<0XP2[0002T@00bA4A00390940b@5A0@T0d@390I400<TA2@00b@5A08T0d@00bA4900290Q4
00<TA4@01d@490m40R@3A0<T1T@590A400DTA4A49002A08T14@690]40R@01D@TA4@T00A412@7A003
94A400E400<TA4@014@29003A2@T00E400<TA4@01T@00fQ4A003A003J4A401Y40VP00dAXA005A003
J4AX009X18P01:b<S:`3R09X00J8S8R<R8`2[009c=3Ad?7AlM7a00Ce00CamOGa0_D00m7ed@03m@05
lOGemOT02oD01?7elOD2d@04lOG@l@;@00?amOD06oD2l@03d?Ge00;e00?amOD03?D00o7ed@08m@03
nOGe00;e00?imOD01oD00o7em@05m@03nOGe00Se00?amOD00oD00o7el@02d005dM3ed?400m002M7@
lM3adM3Ad002[0C@0j`028b/[8b/S8R<0XP018b8R8`2R004J4AXR09X0T@00fQ4A003A003J4A400Q4
00<TA2@00T@29003A2A400]40R@2A08T0T@59003A2A400940b@4A08T1D@00bA4A005A0@T0T@290M4
00HTA4A494@39004A2A4A08T64@00bA4A00@A003J4A400I40VP9A003J4A400I400QXA4AXA8QXR09X
0T@4J0A41VP00dAXR003R003J8R800B<00F8J8R8S003R003[8R800N800V<J8b/R8b8S:`00H`000]4
00<TA2@03d@00bA4A00290I41b@3A00394@T00E40b@2A00394A400m40R@DA0@T14@00bA4A002A0<T
1D@00bA4A002909400@TA4@T0T@290i40R@4A08T1D@290M40b@2A0DT1T@290I40b@9A003J4A40194
00=XA4@04T@00fQ4A004J003R6QX00:<00F8[8b<R002J0:80fP3[0;@00?amOD05oD3n@Ce00GimO7e
l@03m@05lM7AlM400_44d@03mM7A00?e00?jmOD05?D00o7ed@06m@?a2_D00m7em@0;m@03nOGe017e
00?jmOD03_D01?7elO46d@;@0]401=3adO42d008dM3<d<c@[=02[003S:b<00>/0hP00haXR005R004
A6R8R09X1D@2J0A40fPCA003J4A400940R@00d@TA002A00394@T008T24@390I40R@6A00394A40094
0R@014@TA2@3A08T14@39003A2@T00940b@5A08T1d@00fPTA00?A00394A400@T0T@00bA4A006A09X
0d@2J0Y400=XA4@00T@00fR8J002J003R4A4009400>8J6P00fP018QXJ6P4A0=X00><J6P00fP00hQX
J002R0:<00F8[8R8J003R003J8R<00B800><R8P00XP00jb<R003S0F/0007A08T14@00bA4A00@A0<T
0T@290I400<TA4@00d@590940R@GA00394A400M400<TA4@01d@012A492@4A00394A400940b@8A08T
0T@012A492@2A08T1d@016Q494@290M400<TA4@01T@00bA4A004A08T0d@00bA4900290=40R@9A0<T
1d@00fQ4A002A003J4A400i40VPAA004J4A4A09X0T@2J0:800AXS8QX0XP018b8R:`2R0=X0Z`2d0?A
0_D00o7ed002l@03dOGa00Ge00?AmOD01_D00oWjm@03m@06nOGelM3a0oD00m3ad@02d@0:mO7elM7a
dM3ed0Ke00?imOD03?D02O7emOGamM7el@02m@04lOG@d0;a1oD01O7Ad?GA00Se00CimOGi9?D01=7a
lM42d004dOGAl@;A0m03d@03d=7A00;@00?<[<`01:`2S003[=2/00:<00>/R8P01hP016R<R8`2J0E4
0VP4A003J4A400I400=XA4@01T@00fQ4A005A0DT0T@00fPTA002909400=XA4@01d@00fQ490029094
00<TA4@00T@2909400<TA6P00T@00bA4A00<A00394@T00A400<TA4@02d@2J003A6Q400Y400EXA4A4
9003A00394A400M40VP5A005J4AXR6P01D@00fQ4A002A004J4A4J0941FP4A003J4AX009X00E4J8Q4
J003A0QX00=4J6P00fP00hb8S002R003S8QX00J800B<R8QX18P01:b<[8`2R0:<00>/S:`00J`000Q4
0b@2A00394A400940R@014@TA2@7A00594@T94@00R@6A08T14@690940R@GA00494A4A08T0T@390A4
00<TA4@00T@490A400PTA4@TA2A490M40b@5A00394A4009400<TA4@00T@016Q4A4@291941B@2A08T
0T@690=40b@2A00394A400=400<TA4@02T@2J09400=XA4@074@016Q4A6P7A09X00>8J6P00VP2R003
[8b<00:800=XR8P00XP2S004c=7Ad0;A00?amO400oD00m7am@03m@04lOGelA3e00CAlM3a0_D2l@03
d=7a00?e00OAd=3edO7@01We00CamM7a0_D01M7ad=3<00;A00?amOD01?D2l@04dOGal@Se00?imOD0
5OD00oWem@0>m@03lM7@00?@00GAlO7@c002d0;a0]001]7<d=3<[0;<00?@[<`00j`00m3<[003S0b8
0VP2A003J4A401U400=XA2@014@012A4A2@BA00494A4A0DT14@00bA4A005A00494A490Y400<TA4@0
1d@00bA4A005A00394A400I400=XA4@04D@00bA4A006A09X1d@5J004A6Q4A09X0d@00fQ4A002A0MX
00=4J4@00T@01HQXJ4AX00I41FP2A0=X0XP016R8R8`3R003J8aX00>800=XS8P00XP2J0B80h`01HQX
R8R<00>80H`000Y400<TA4@00d@39003A2A4008T0T@29003A2A400940b@2A00494A4A0<T24@29003
A2@T00i400DTA4A49009A0@T0d@00bA4A002A0<T00=492@01B@4A08T5T@00bA49005A00494@T90A4
00=XA4@00T@290Q400<TA4@024@390I400<TA4@02T@00bA4A008A005J4A4A6P074@00fQ4A00;A0AX
0T@2J0>800>/R8P00X`00hR/R002[0;@00Gad=3Al@02d@03d?7e00Ge00?amOD03?D00oWem@02m@03
dOG@00?a00WAlM7ed?7elM400]002?7AdM7elOGa3oD02O7emOGamM7am@02l@03mO7e00C@00?Ad=40
0oD00m3ad@03l@[e0_T00oGim@0Am@;i00?enOD03OD00o7em@02d@;@00KAlM3ac=02d@08lM3<d:c@
[=02c0F/00C<[=2/0X`01:b<R8P3J003R6R800:80fP2A09X00=4J4@05T@390=40R@5A00394A400E4
0b@2A003J2A400@T0T@490I40R@5A0@T0d@01BA4A4@T00Q40b@00d@TA007A00394A400E400=XA4@0
6d@00fQ4A003A003J4AX00=X0T@2J09400IXA6QXR6P2A09X00A4J6R816P3A0EX00=4J6P014@2J0:8
16P2R003J8R800J80VP6R0=X0XP2S003J8QX00=X00B8S8R80X`1[0002D@39005A2@T94@01B@5A08T
14@390E400<TA4@01d@390940R@>A00494A490a400<TA4@00T@00bA4A006A08T00=492@00R@5A003
94A4009400LTA4A494@T00Y412@KA00494A490I40R@3A0DT14@00bA4A004A0<T54@00fQ4A00=A08T
1D@00hQ4900290a40fP014AXA6P3R00;S<b/S:b<[8R/c?400]000o7Am@03l@?e00KamOGelOD2l@03
dOGe00Se00?imOD01?D01O7elOGA00;a00Ged?7am@04d@Ce00?AmOD05?D00o7@m@02m@06lOGAlM3a
0]43d1;e0_T3m@03nOGe00ke0_T2m@03nOGe017e0]401=3Ac:`4d0;A0]001lc@[=2/d<`01:`01<b/
[:`2S003[8aX00IX00J8J8QXA6P7A003J4A401A40b@00d@T900490M400DTA4A49003A08T00E492A4
9002A0@T1T@390E400<TA4@00d@89003A2A400DT00=492@01D@00fPTA002A08T1d@00bA4A00?A004
94A4J0Y400QXA6R8J8QXA0QX0XP3A09X00I4J6QXA6P2A006J4AXJ4AX0d@00fQ4A002A09X00B8J6R8
16P00hQXR00;R0:<00>8J6P00VP2R003S8R800AX00>8[:`00Z`2R00014@00fQ4A004A00394A400LT
0d@290Q400DTA4A4J008A00494A490M400<TA4@02d@00bA4A005A08T1d@00bA4A00390M40R@00d@T
A002A0<T0T@29004A2@T90E40b@9A08T0T@00bA4A007A005J4A4A6P014@00fQ4A00>A0<T0T@490E4
0R@5A08T0T@00fQ4A002A003J4A400M400=XA4@02D@00bA4A004A0<T1T@012A492@3A00394A400M4
00=XA6P00VP2R005J8R8[<`00Z`00hb/[002[0?@0]42l@03mM7a00Ce00CamM7e0]400o7em@08m@03
nOGe00Ke00KamOGedO42d@;a00CAd=3a0oD00o7em@0>m@03lOGe00?e0m401_GalO7ed0;A00?elOD0
0]400m3al@03m@03lOGa00[e0_TDm@;j0_D00oWem@0<m@03lOGe00;e00GAlM3@c002[0O@00K<d:c<
[<`5[003d:b<00:<00>/R8`00XP00haXJ002J003S8R800=400AXA4AX6T@39004A2@TA0@T00=494@0
1d@290E40R@00fPT9002A0<T0T@012A494@390E400@TA4AX14@9909422@8A00394@T01=400<TA4@0
0b@6A00396Q4009416P01hQXR8b8J4@00VP00dAXJ003A003J4A4009400=XA4@00T@2J0=40fP5A003
J4AX00IX00=4R8P00VP01XQXR6R8[0:800B<R8R/0hP00hb/R003J003A8QX00:800J<R8QXR8`4[0:8
000=A00394@T00@T00=494@01T@012A492@5A003R4A400E400@TA4A40b@4A00394A400M40b@:A003
94A400U40b@014@TA2@3A00394A400A40R@6A08T00=494@00d@390U400<TA2@00b@5A08T00=4J4@0
34@00bA4A00;A00494A4A0@T6d@00bA4A00AA00394A401U400>8A6P00fP01XQXJ6R8c0>/00B<R:b/
1M001=7@lM42m@Ca00KelOGAlM4Hm@04lM3Ad0;e00?Ad=400oD3lACe0]42m@;a00_elM3edOGamM7a
d@0=m@03nOGe00?e00?imOD01oD00oWem@08m@?i5_D02]7@d=2/c=3<d<`2d003dM3@00?<00?@[:`0
1J`01FR<[=2/00F80VP00dB8J002R09X1d@00fQ4A00BA00394@T00/T1T@6909400DTA2@TA0039006
A2@T94@T1d@39003A2A400=400DTA4A49002A0DT00=494@022@00d@TA00;A0<T2T@00fQ4A002A003
94A400E400=XA4@014@00hQXR002J005[8R8J4@01VP2A09X2D@01FQ4A6Q4009X00=4J6P014@00fQ4
A005J003A6QX00AX0XP00fR8R002R0:<0hP2S0>816P3R004[8R8J0:800><[8`00VP1R0002T@00bA4
A0069003A2A400M40R@3A00594A4A6P01T@290e400DTA4A49004A00594A4A2@00T@2909400<TA4@0
0T@00bA4A004A08T2D@290940b@6A0HT0d@690]400<TA4@01T@2J2140R@5A0DT00E492A49005A004
J4A490I40R@6A00394A400I400<TA4@024@491140fP3R004[8b8S0:/00F<[:c<[002d003dLc@00;a
00Ked?7edO43m@04lM3ad0Se00?amOD00_D00m7em@09m@?@0oD01M7@d?GA00Ke00?ilOD00_D00oWe
l@03l@Ce1?402=7adO7@lM7e0_401=3edO46m@03lOGe00Ge00KimOWimOX2n@03n_Ge00;e00CimOGi
2?D3n@;e00?imOD00_D00oWem@0?m@03lM7@00:/00?@c=000/`3d004c:c<[0;<1j`4S003[8b800R8
00=XA4@06D@590E412@00d@TA005A00394A4009412@3A00594A4A2@03D@490=40R@8A00594A4A2@0
0T@3909400<TA2@02R@3A0DT0T@012A492@3A09X00=4J4@02d@2J09400=XA6P024@2J003A6QX00AX
14@2J0E400=XR6P00fP6A004J4AXJ0=400B8J6Q40fP2R09X00>8S8P00hP00fR8R003S003[8R800B8
00J<R8b8[6P5R0=X0003A00394A400A40R@7A08T1T@00bA4A003A0<T2T@01BA4A4@T009400<TA4@0
0T@00bA4A00BA00394A400U40R@00d@TA003A00394A400E40b@3A00394@T00<T0T@00bA4A003A08T
00=494@00d@490A40R@00d@TA00AA003J4A401Q400<TA4@01b@/A0@T2d@00fQ4A002A006J8R8J8R<
1XP2[0;<0m001lc@d?G@lM000m401o7elO7AlM403OD00o7em@09m@03dO7A00;e00Gad?Gel@06m@03
nOGe00We00CamO7e0_42d003dOGA00?e00CamO7a0m400o7em@0;m@;i00?enOT00_T3nP03nOGe013e
00?imOD04oD00m7am@02l@0<d<b/d<c@[<b/d:c<0Z`00lc@c002[006c:b<[8b80Z`01=2/S8`2R09X
00V8J8QXA6Q4S6P03d@012A4A4@:90=412@014@T94@6909400<TA2@012@2A0<T00=494@00T@39003
A2A400=400<TA4@012@2A00394A400U40b@014@TA2@2A00394A400=400<TA4@00b@4A00794A4A2A4
9006A006J4A4J4AX2D@2J0:<00>8J4@016P01TAXA4AXR0AX00=4J6P00fP4A003J4A400=400=XA4@0
0VP5A003J4A4009400AXA6Q40fP2A0MX0XP01FR8J6R<00>800R<R6QXR6R8J0R800AXR8R80X`000A4
00@TA4@T0d@00bA49005A08T1D@290E412@2A00394A400=40R@2A00494A490A400<TA4@044@012A4
A2@6A08T0d@290I40R@2A0<T00=492@02b@2A08T2D@390M40b@IA08T64@590]400<TA4@01D@00bA4
A006A0<T6T@3J0A416P028QXR8QXR8b80Z`2c004d<c@c0;@00?Ad?400m03l@;A00G@dM3el@03m@03
lOGa00Ge00?amOD01?D2n@Ge00GAlM7ed003m@03lOGe00ge00?adM000o42d@?@00kadOGamO7elOGa
dO7el@_e0_T00oGin@02n@;j00Cin_[i0oD2n@[e00KimOWimOTBm@;A00oedM3<[<c@c=2/d<c@[<`0
0j`00m3<[003[003R8b800:<00B/c:b/0X`00hQXJ007J003[4A400a40R@2A09X0T@790=400DTA2@T
A00290941B@4A003J2@T008T00=492@00R@00dAXA002A00394@T008T0T@290A412@3A00394A4008T
0T@00bA4A00390=40R@00d@T900390=400<TA4@02T@390E400EXA4A4J006A005J4A4J4@00VP4R003
J4B800=X00>8J6P00fP014B8R4@5J0Q400=XA4@00T@00fQ4J004A09X00=4J4@016P00hQXA009J0:8
16P01HQXJ4AX00B80VP2R0=X0XP2J003R6QX00>80004A08T00=492@014@00bA4A004A00394A400=4
0b@6A00394A400Q40R@9A00394A4011400<TA4@01D@590940R@:A08T14@49003A2@T00<T0d@390Q4
0b@6A0@T00A492@T1T@00bA4A004A00394A400I400<TA4@014@00bA4A002A00394A400Y400<TA4@0
1D@290I400<TA4@03T@390U400<TA4@01T@00bA4A00>A004J8R8J0:800aXR8R8S:c@[=2/dL`3d003
dM3@00;@0_D01]7@dM3Ad0?e00?amM400_D00m7em@02m@04lOGid@[e00?AmO400_D01?7AmM42m@03
lOGe00;e00?amOD00oD01O7ed=3A00?a00?@dOD00]402_GAmM3elM3amM4<m@0:nOGemOWjmO[im@;j
00Cin_Gi0_D01?[imOT8m@03nOGj00;e00?jmOD01_D01M3enOGi00Oe00CAmM3@0Z`01=2/[=42[009
d:b/d:c<[=3<00:/00?<S8`018P01Xb8[=28[0YX00B8A4AX34@01BA4A8QX00941R@3A0DT0T@012A4
A2@2A0@T0d@590940R@4A08T00=492@00R@00d@T9002A0<T0T@01BA494@T00940R@2A0<T00=494@0
14@29003A2@T008T00=492@01D@00fQ4J005A00394@T01540fP00dAXA002J003R6QX00=X0T@4J003
A6Q4009X00=4R8P00VP8A0=X14@2J0M40VP00hQXJ006J004A6QXJ0J80VP01XQXJ6Q4J0:800AXR6QX
28P00fR8R003R05X0008A00394@T00=400<TA4@00T@00bA49004A08T24@29003A2A400E400<TA6P0
14@00bA4A00:A00394A400m400@TA4@T1D@290m41R@5A0@T00=494@03D@49003A2@T00<T0d@00bA4
A006A0<T2d@390Y400<TA4@054@00bA4A00@A00394A400M400<TA4@01D@290e400MXA6Q4J8Q400:8
00QXR8R8S<c@c0C@00?Ad=400]001?7@dO42d@05d=7AdM001?D00o7em@05m@03lOGe00Oe00?imOD0
1?D01o7edOG@lM000oD00o7em@08m@05lM7Ad?400_D01]7adO7@d@?@00Oad?GAlM7a00;e00?amOD0
1oD3n@03n_Wi00?j00?in_T00oT01?GinOX2n@We1?T01_GimOGad@oe00CamOG<1J`00lb/d002d008
[<c@d<c@[=03[0:<00>8S8P00h`00jb8R003R09X0XP016Q4J6P@A00394A400A40b@00d@TA002A08T
1D@49003A2A400<T0T@29003A2@T00E412@00d@T900590A400<TA2@00T@390Q40b@2A00394@T008T
0T@790Q400IXA4@TA2@FA003J4A400=X00>8J6P00fP3A0EX0T@6J003A6QX00I40VP01TAXJ4AXR0M4
00=XA6P00VP3A003J8R800IX1HP2J0:81VP2R0EX0XP5J0>80FP000A400@TA4A40R@7A0<T0T@29003
A2@T008T24@00bA49004A0<T1d@290E400DTA4A4900JA0<T2D@490=400<TA2@00R@4A0<T1T@39003
A2@T00I400@TA4@T1T@290]40R@;A00394A4011400@TA4AX1T@390=40R@BA08T44@00bA4A002A09X
2T@01FQ4J6Q400=X00><R:`00Z`6d003lM7a00G@00Sad=7@dM3Ad0Ge00?amOD00oD00m7em@0=m@09
lOGelM3elOGa00;A0_43m@0;lOGelM7edOGAlM400oD00m7al@03m@03d=7@00?a00?AlM402_D01?We
n_T4nP;i0oX3n@Ke0_T9m@?i1_D00o7em@0>m@03lM2/00:/00G<d<c<[003d003c=3<00G@0j`018b/
R8P3S0F800=XS8`00hP3J0:800=XA4@03T@012A4A4@39003A2@T00I400<TA4@01B@00d@T900290=4
1B@5A08T00E492@TA00590I400<TA4@00T@290E400<TA4@014@00bA4A005A08T00A492@T0d@00bA4
A008A00394A400e40VP7A004J8R8R0AX00=4J8P00fP3R0=41FP8A0UX1D@016Q4J4@3J09400=XR8P0
16P3R09X0hP2J003R6R800:80fP3R0=X1XP2J0:80FP1R00024@590E40R@4A0@T1D@00bA4A003A0<T
1d@00bA4A006A00394@T00=40b@8A00394A400a41R@8A0DT2d@490=400<TA2@00R@2A08T0d@00bA4
9002A00394A400A40R@9A00394@T00=40R@5A00394A401a40R@6A00394A402I400=XA6P03d@2J0:8
00F/S=3@[002d003mM3a00K@00>/d?D01=000o7Am@02m@03lOGA00Ge00?amOD03OD02?7edO7AmM7e
0_401oGad?GamM401OD00m7el@03m@0;d?GamM3amO7@mM400o400oGad@0<m@;i1oX00oWjn@02n@?e
1OT00o[im@02n@06mO7inOGi2OD01O7elOGa00We00CAlLb<1j`02]7@d:c@c:c@lM42d0:/0X`00hR<
R002R003S8R800V800=XA8P054@7909400<TA4@00T@39004A2A4A08T0d@00bA4A00390A41R@4A003
94@T00HT0T@01RA4A4@TA08T2T@012A492@7A00394A400]400=XA4@05D@4J09426P2A0=X18P4J003
R6Q400940fP3A09X14@4J0E400AXA4A40VP3A003J8QX00MX00J8J8QXA6P2R003J:aX00:80fP2R0=X
1HP3S003[8R800680003A00394A400M400<TA4@02D@00bA4A004A08T24@290I40R@5A00394A400A4
0b@EA00494A4909400@TA2@T2T@00bA4A007A0@T1D@390=40b@4A00394A400I40R@00d@TA008A08T
2T@691Y40R@6A08T24@00fQ4A002A00394A401]400=XA4@01D@2J09400=XA6P00VP2R0:/00Ced=7e
0]000o7@m@03d004c8b<c0?@0_42m@04lOGed@?e00GidO7ed@02m@03lOWe00ce00?Ad?401M000o7@
d@02d@03d?GA00;a00SelO7AmO7ed0;A00_adOG@mO7AlOG@m@03l@03d=7e00Ke00KamOGin_T2nP07
nO[in_WenP02n@05n_Gen_D00_T01?Gin_D2n@Ce00?jmOD00_D01OWemOGA00;e00?amOD02?D00m7a
d@02d0:/00><c=000Z`01M3ad=3<00C@00?ed=000]001Zb<[6R<J0>800N<R6R8J8QX00:800B<R8QX
1D@00hQXJ002A00394A400U412@8A00694@T94@T1D@00bA4A003A0<T14@590=400=XA2@00b@014@T
92@2A00394A400@T4d@290I412@;A003J4A400I400=XA6P02D@2J0940fP2A09X00A4J6Q40VP2R0AX
00R8J6Q4J4AXS09X0T@00hQ4A003A09X00>8J6P014@3J003A6QX009400MXR8QXR4B800IX00B8J4AX
0XP01Hb/R8b8009X0XP00fQ4R002R008J8R8J8b8[8`2R05X00000bA4A004A00494A490=400@TA4@T
1D@00bA4A006A00394A4009400<TA2@00T@012A492@6A08T2T@290M400<TA4@03D@00bA4A002A007
94@T94@TA003915400@TA4@T0T@290A41R@00d@TA008A00394A400Y40R@2A00394A400E412@4A003
94A400Q40R@00d@TA006A08T5T@00bA4A00TA0AX00Q4J4AXA8R/c0C@00Ced=3<0m000jc@[002[0C@
00CAlOGe0]47m@03lOGe013e00WadO7@dM3elM400_400m7ed@02m@03lOGe00;a00CAmOGe0]002=7@
d=3AlM3e0_42d@;a00C@mM3a1_D00o7em@02m@Gi0_X01OGimOGi00?e1?T00oGim@0Bm@03lOGe00[e
00CadO7@0/`02Jc<d:c<d?7@d@05d007lM6/c=2/c002[003R6R<00:/0X`00hQXJ003J0:800AXR6QX
0d@00fQ4A007A003J4A400I40b@4A14T1D@59003A2@T00DT00=4J4@012@2A08T0T@29004A2@T91E4
0R@8A00394A400U400=XA4@04D@01FQ4J6Q400EX0T@00fQ4J007A0=X14@00fQ4J003J003A6Q400I4
0fP7A09X00=4J6P01FP00dAXJ003J09416P00hR<R002S003R6R800>80fP4R006J8R8R8b80fP00094
0R@;A00394A400a40R@5A00394A4008T00=492@024@3909400<TA4@014@00bA4A005A00394A400E4
0b@00d@TA002A08T14@00bA4A0069004A2@T90m40b@00d@T900290I400@TA4@T24@29003J4A40094
00<TA4@014@490E400@TA2@T0T@290=400<TA4@00R@5A0<T00=XA4@014@290A40b@<A00494@TA0HT
94@00fQ4A002A004J8R8[0;@00>/c=000m001Jc@c=2/00?@0/`01=3Ad=42m@03dM3a00Se00?adOD0
0oD00oWem@08m@04lOGal@;A00O@mM3adOGa00?e00?amOD02_D2d007dM3@d=7am@02l@oe00?in_X0
1OX00oWjn@06m@;i00?enOD00oD2n@03mOWe00?e00?imOD01oD00o7em@06m@04dO7al@;e0]001Jc<
[:c<00;@0o43d005dM3Ad:`00/`4[0:800B/S:b<0XP3J0>80VP00haXJ00CA00394A400=400<TA4@0
0d@99003A2@T00<T0d@00bA4A002A0/T14@290E40b@4A00394A400M400<TA6P02D@00bA4A007A08T
00=494@01T@00fQ4A003A003J4A400M40VP2A0UX0T@3J0A400=XA4@00T@3J0E40hP00fQ4J008A004
J4A4J0E40VP014AXJ4@5J006R6QXR6R81FP2R004[8b8R0EX0hP01FR<R8QX00N80FP0009400LTA2A4
94@T011400<TA4@01D@00bA4A005A00394@T01=40b@4A00394A400A400@TA4A40R@@A0TT0d@00bA4
A003A003J4A400=400<TA4@00T@49004A2A4A0<T1T@29003A2@T00940b@=A00494A4A0PT0d@790A4
0R@4A0@T1T@390=400<TA4@01T@29003J4A400@T1T@290E40b@00dAXA006A003J4A400a400AXR8b8
0Z`00o6/d002d004c=3<d0:/00G@dM7@c002d003dM3a00;e0]09m@;a0_D4n@03mOWe00Ke00G@mM3e
l@02d@04mM3Ad0;e00KAmOGAmO45m@05lOGemO401M001M7@dOGa00?e00?@dOD02oD5n@05n_Win_D0
0_X00oGim@02n@;e00?imOD01OD2nP;i0_D00oWem@03m@03lOGe00;a0]400oGam@02m@04dOG@l@;A
00Cad:b/1M001?7AlL`4d003dLc<00;<00?@[:`00XP2S004[8R8R0=X1HP016Q4A6P6A09X2T@290U4
00DTA2@TA00490=40b@2A0@T00A492A40R@00d@T900390940R@01D@TA2A4008T00A492@T14@290M4
00<TA4@00T@00fQ4900AA00394@T01A40VP00dAXJ002J003A6Q400E40VP2A0=X14@2J004A6QXJ094
00MXA6QXA6Q400AX34@016Q4J6P2A0aX0XP01FR8R6R800=X0hP3J009R6QXJ8b8J4AX00J800B<R8R8
0FP0019412@01D@T94@T00I400<TA4@00d@29003A2@T00=400<TA2@00T@016Q492@5A003J4A4008T
00I494@TA2@8A08T2T@00bA4A003A0LT00E492A49008A00494A4A08T1D@39004A2A4A0DT14@490=4
0R@7A00394A4009412@5A0DT14@39005A2@TA2@014@00bA4A002A08T1d@00bA49003A00394@T00E4
0b@00dAX900390E400@TA2@T0T@49003A2A400E400AXA4A40VP01DAXA4AX009400AXA4AX0T@01fR8
[<b/c?400]001=7@dM02[0;@00?ad=000]000lcAd002l@06mM3alOGA0_D03O7emO7elOGimO[imOT0
2?D00m3Al@03m@03dOG@00;@00Cad?GA0oD01O7elOGa00Oe00oAd=3Ad?G@lOG@mM7@mO403?D01?We
nOX2m@03nOGj00?i0_D01_WenOGim@;i00?jmOD00_T01?[imOT3m@04lOGel@;e00[AmM7elM3AlM7e
0]42m@04lOG<d0;<0m001_GAmO7@c0;@00?adM400m02c0:/0h`01:b8[8`2R09X0XP00haXJ002J003
A6Q4011400<TA2@01T@012A4A4@790U41R@2A0hT0d@39003A2@T00A40R@2A00494A4A0<T1D@00bA4
A009A00394A401U40fP01DAXJ4AX00M40fP4A003J4A400941VP01DAXA4AX009400=XA6P00fP2A0AX
14@3J09400=XA6P00VP01XQXA4AXA09X00F8J8R8J002R0MX00J8J8R8S6P4R004J4AXJ0Z8000AA08T
0T@00bA4900290A400@TA4@T14@01RA4A2A490A40b@4A0<T1d@290E40R@7A00394A400i400<TA2@0
12@2A08T24@390=400<TA4@01D@00bA49003A0LT00A492@T4d@00bA4A009A00394A400940R@00d@T
A002A00394A400=400<TA4@00T@00bA4A00=A08T2D@390A41b@00d@T900FA09X1D@00fR/[002[003
d<c@00C@00?<dJ`00]000m7<d004d008lM7AmM7amO42m@06lOGemO7A1_D01?WenOT8m@04dO7el@;A
00K@lM3Ad=42m@03lOGA00Ce00?adOD01?D3d004dO7@d0;A00GedO7ad@0>m@;j1?D6n@Ce00Kin_Ge
n_T4m@03nOGi00;i1?D01=3amOD3l@0:mO7ed?7AmO7el@;e00WAd=3<d<c@dO400_D01]3Ac=3ad@;@
00>/d<`00]000jb<S002S003[8R800:80fP4R0EX44@00bA4A004A00394A400=40b@00d@TA002A08T
1D@00bA490059003A2@T00PT14@012A4A4@69004A2@TA0<T1D@390I400<TA4@034@00bA4A00GA004
J4AXJ0A40VP3A003J8QX00A400>8J4@00T@6J0U40fP3A004J4B<R0=416P3A0aX00F8J6R8J004R0=X
00>8J8P00hP2J0>800=XR6P00fP3R005[8b8R8`00HP00003J4A4015400<TA2@00d@29004A2@TA0<T
0T@290A40b@3A00394@T00940R@@A08T00=492@01d@00bA4A00<A08T00=494@02D@29003A2@T00DT
0T@290=40R@01D@T94@T009400<TA4@00R@00d@T900291=400=XA4@02T@00fQ4A002A00394A400E4
0R@LA003J4A400U40b@014@TA2@4A00394A4009400<TA4@00d@290i400=XR:`00j`2d004c:b/[0;@
00CAd=3@0m43d009dM3elOGAlOG@00?A0oD00o7em@0Cm@;a00O@[=2/d=7@00Ge00OamM3elOG@00?e
00KAmOGelOD3d0;a0_D01?7AlO42m@06nOGemO7A1OD01OWjn_We00;i00CenOWe0oT5m@?i1_D2nPKe
00?AlOD00_42m@09lOGAmO7AlOGa00;e00CAd<c<0]03l@04mO7@d@;@0]42d003[<c<00B/00B8[8R/
0X`2R09X00B8J8R80VP01TAXJ6Q4J1A412@3A0DT00E494A49005A00394A400=41B@3A08T24@01bA4
A2A494@012@2A0@T1d@291I400=XA4@054@016Q4A4@2J003A6Q400E40VP4A004J4A4A0EX00B8J4AX
0T@00fQ4J002R004J4AXJ0I40VP2A003J4A400E400=XA6P01FP00dAXJ003J004R6R8J0:800=XA8P0
0XP7J003R6QX00=X0XP00fR8R002[0:80H`000M40R@7A0DT00=494@00T@29003A2@T00<T1T@39094
00<TA4@00R@01D@TA4@T00E400<TA2@02D@39003A2A400=400<TA4@00R@4A0<T1d@012A4A2@2A0DT
0T@59003A2@T00<T0d@01BA4A4@T009400<TA4@014@00bA4A0029004A2@T90I400<TA2@00T@00bA4
A004A08T3d@290=400=XA2@00R@AA003J4A400I400AXA4A40R@9A08T0T@390E400<TA4@01D@01BA4
A4@T00a400AXR8QX0Z`00hb/c004[003d:c@00?@0]401?G@dO42d003mO7e00;e00GAmO7ed@03m@03
dOGe00Ce00?amOD02?D2l@04d?GAm@C@0m401?GamM43m@05dO7emM400_401?GAmM43m@03dOGA00;e
0_401oGAmO7enOX01_D00o7em@02m@;i00?en_T00_X3n@05mOWimOT00oD4n@Ke00?imOD01oD00m7@
l@02m@;a0]400o7Ad002l@;A1=02d@03lOGA00?a00?AlM000m06[0:<0XP00hb8R002R0:<18P00fQ4
J002J09400=XA4@034@01BA4A4@T00M412@2A08T1d@390E412@3A08T14@012A492@4A0<T0T@290]4
12@5A00394A400Y400MXA4A4J4AX029400IXA4A4J4@3J003A6QX009X00B8J6Q40VP014AXA4@4J003
A6Q400E41FP:A09X00=4J6P00VP3R0=X0hP01Hb8J8QX00>800=XR6P016P2A0R80h`1R0002d@00bA4
A0069006A2A4A2A412@9A0LT00=492@00b@6A00494@T90940b@6A0<T1D@590Q400=XR4@01D@00bA4
900390A40R@00d@TA005A00394A400U400<TA2@01T@39003A2A400HT00=492@00T@290E400<TA4@0
14@00bAXA007A0<T0d@79003A2A400i400<TA4@014@00fQ4A002A00594A4A2@01D@012A4A4@39094
00@TA4@T1T@490i400=XS8P00XP00hb/R003[006d:c@c?6/0]001_7@lM3Ad0;A00?ed?D00_D00o7e
m@05m@03lOGe00Ce00?@lOD01_D01O7AmO7<00;@00CAlO7@0/`00o7em@02m@03d?Ge00;e00GAlOGA
m@03d@03mO7e00Ce00?amOD00oD00o7em@0>m@;i1OX3n@;e00CimOWi1?D00oWem@0:m@;a00CelO7A
2?D5l@;A00k@dM3AlM7amM7adO7@d@C@00>/c:`00j`3S0F800EXR8b8[002R09X00=4J6P00VP01DAX
A4AX011400<TA4@01D@00bA4A00390Q40R@3A0/T14@;909400=XA4@01d@00bA49002A00394A400A4
00<TA4@024@00fQ4A004A003J4A400i400=XA4@03D@:J09400MXR6Q4J8QX00=400AXA4AX1T@016Q4
A6P5A003J4A4009400=XA4@00fP3A0AX00E4J8b<R004J003S8QX009X00R8J8R8S8QXA0EX00I4J8R<
R8`3J0B80002A00394A400E40R@3A00494@T90E41B@:A00394A4009400<TA2@012@2A00394@T0094
00<TA2@00R@9A08T1T@01RA492A490Q40VP7A0@T2T@49003A2A400Q41B@5A0HT00A492A40b@00d@T
A002A08T34@290I400<TA4@014@29003A2@T00LT1D@00bA4A002A003J4A4008T2T@00bA4A0029004
A2@TA08T0T@012A4A2@2A08T0d@291E400EXS8b8S004[008S:c<[=2/d:`2d005lM3Ad=401M000m7e
m@04m@03lOGa00Se00?AmOD01OD02o7Ad?7ed?7<lM7a00;@00C<dM3e0_401M7emOGA00;@0_401OG@
d=7e00;a2_D00o7em@06m@03dO7e00Ge00?in_X01OX5n@Ke00?imOD01?D01?WedM03m@;a00GAd?7a
m@02l@;e00?amOD00_401_GAlM3Al@;A00?edOD00oD2l@04mM3Ad@?@1:`028b/S8R/J8QX0hP00fR8
R002S003R6QX00940VP00dB8J002J15400<TA4@01D@2909400<TA4@014@00bA4A006A08T00E492@T
A00290Q42B@3A00794A4A6Q4900<A0<T2D@00fQ4A005A004J4A4J1A400<TA4@00T@01VQ4J4AXA0=X
00=4J4@00d@00fR8A002A003J8QX009400EXA4A4J005A004J4AXJ0A400=XA6P024@00fQ4A005A09X
18P3J0:80VP018R<J8`3R003J4A400=X00B8J8QX1hP2J0680007A00394@T00<T00=492@01d@012A4
94@490M400<TA2@00d@00bA49003A08T00=494@00b@2A0<T0d@00bA4A004A00394A400A400<TA2@0
0b@00d@T9002A00394A400Q400@TA2@T1T@012A4A4@49003A2@T00U412@6A0<T1D@00bA4A00390A4
00<TA4@00T@2J0Q400DTA4A4J00=A0DT00A492@T1D@00bA4A00CA0HT3d@00bA4A00DA003R8b800:8
0X`4[003d:b/00;@00G<d=3ed@03m@04dM3@d@Ce00CamOGe0o47m@04lOGen@Ge00CAlOGA0o401=3e
lO42d@03d?7A00;A0]001_GamO7ed@Ce00CadOGa0]401?GamO4=m@04lM7Al@;e00CamOGe0_T7nP05
mO[imOT00oD00oWen@0<m@08lOGAdO7@dM02d@04lM7ad@?a00GAlM7ed@05m@03lOGa00;e00GAd?7@
d@03d0>/0X`00hR<S005R005J8b<R8`01FP018QXJ4@3J0m40R@014@T92@5A0DT14@00bA49004A08T
0T@69003A2@T00M422@2A00394A400I400<TA4@00d@00fQ49003A0DT2D@012A4A6P;A003J4A401Q4
0fP5A003J4A400E40VP5A09X1T@3J0A40VP6A003J4A400A416P014AXJ8P6J005A6QXR6P00hP2J094
0VP01DB8J6Q400AX1HP1J00014@01BA4A2A400DT0d@00bA4A003A00794@T94@TA00590940b@00d@T
A0029006A2A4A2A40R@014@T92@2A0@T0d@00bA4A004A00494A490A400<TA2@00R@00d@T90039114
00<TA4@00T@790E400<TA4@014@39003A2A400A40b@4A00394A400940b@>A00394A400e400<TA4@0
1D@290A400<TA4@0:D@00bA4900;A006J4A494@T1d@00fR8R002R004S8R/[0:<00V/c=3@c=3<d<`0
0]400o7em@02d003lOGe00ke0_401OGamOGi00;e00[amM7amO7@c=3A0_D00o7Ad002d0;A00S@lOG@
mM3am@;a1?D2l@04mM7al@;e00KamOGamO4:m@05lM7edO401OD00o[in@04nP?i1OD3n@ge00?amM40
0]001=7@d=02l@08d=7@d=7ed=43m@04lM7ed@Ge00CamM7A1=001<b/S:`5R0><00=XR8P00XP2S003
J4A400=X44@00hQ4A008A00494A4A0@T00=492@02D@290940R@00d@T900?A0<T34@01BA4A4AX00A4
00<TA4@00d@390940R@9A00494A4J0=400DTA4A4J00?A00394A400Q400EXA6Q4J00<A09X2D@00fQ4
A005A0AX0T@016Q4J4@2J0E41VP00dAXJ002J005A6QXJ8P00fP00hQXJ003J004A6QXR0=X00=4J4@0
0VP00jb8R003J0000d@012A4A4@6909400<TA2@00b@014@T94@390E40R@6A00394A400M40b@8A003
94A4009400<TA4@00T@290]41b@5A0@T1D@29003A2A400941R@3A00394A400A400<TA2@00b@014@T
A2@3A00394@T00HT24@00bA49009A00394A400E400<TA6P01D@00bA4A004A0DT00=494@05D@290]4
00AXA4A40b@014@T92@9A003J4A400=40b@8A004R6R8R0:/00G@[:b<[003d006c=7Ad<cA0_401oGA
dM7amO402OD01O7elOGA00Ge00?AmOD01?D01]7@lOGAd0?e0_42d007[=7AmM7ad002d@;a00?elOD0
1_D2l@;e00?amOD03_D2l@03dM3a00Ce1OT2nP;i1oD00oWjn@02n@Ge00?imOD01OD01O7@lOGA00;@
00CelM3e0m401?7@dM42m@0;dM3adOGamO7edOD00]42d0;<1:`2S006R6R8R8b/0hP2J003R8aX00AX
2D@00fQ4A009A003J4A400=41b@3A0HT0T@00bA4A00690E40R@3A00394A400m400=XA4@014@00fQ4
A002A08T00=4J4@00T@00fQ49003A00394A400U400<TA4@00d@00bA4A005A003J4A400U400<TA4@0
6D@2J0U400=XA4@01T@2J0E40fP00dAXA005A09X00=4J6P00VP00hQXJ004J004A6R8R0IX00B8J8R8
1VP018R/J8P2J0680008A00494@T90940R@00d@TA002A08T0d@290E400<TA2@01D@00bA4A007A003
94@T009400=XR6P06d@3909400<TA4@00T@012A494@290E41B@2A08T00=492@01B@9A00394A400M4
1R@<A00394A400m400@TA6Q40R@9A0HT1d@00bA4A002A003J4A400I400=XA2@00R@7A003J4A400A4
0b@01D@TA4@T00940VP4A003J4A400=40R@7A003J4AX00:800AXS8b80Z`018b/[=02c004d=7@d0;a
0_D01_7AlO7el@Ge00?amOD00oD01O7elO7@00;A1=001_G@mO7ed0;A1=000oGAd002d005c=3@c=00
0]400o7@l@09m@06lM7adOGa4?D2l@;@0_D2l@;e0_T01_Gin_[en@Oe00?imOD00_T:m@06lOGedM3A
1=001?GAd?42d003dM3A00;@00?ed=000]06m@;a00CAlM3@0/`3[004S:b<R0:<00>8[8`00X`2R004
J8R8A0EX00=4J6P00VP?A004J4@T90A412@016Q4A4@39003A2@T00@T0T@6909400=XA2@00R@2A08T
2T@490U40VP2A08T00=4J6P01D@01RA4A2A491E400<TA4@06T@00fQ4A003A005J4A4J4@01VP4A004
J4AXJ0Y400=XA4@00d@00fQ4J002J0940VP00dAXA002J0:800AXA8R816P00hQXJ002R005S6Q4A6P0
0hP00fR8J003J004A8R8S09X0HP1J0680007A00394A400E400@TA4@T0T@290M400<TA4@01T@290a4
00<TA2@00T@00fQ4A007A00394A400I40R@00d@T9004A0<T0T@00bA4900490U41B@2A00394A400DT
0T@29003A2A400A400<TA2@01d@29004A2@T91U400@TA4A40b@2A0<T14@00bA4A002A0DT5T@390]4
00<TA4@00d@391=400<TA4@014@3J003R6QX00:81J`00lb/d004d004dOGam@?a0oD00o7em@03m@03
lOGe00Ge00_adM7elM3ad?7ed003m@04dOGad0:/00?@lO400m001LcAd:c<00;@00?Ad?D02OD01?7A
dM4Cm@06dM3@dO7A1_D3n@;e00?imOD01?D00oWem@0<m@03lOGe00;@0_400m7@d003d0CA00Gad=3a
m@03d003mO7e00Ce0o400m7ad002d0>/0h`2R008S8R<S8R<[6P2R0=X00>8J6P00fP00dAXJ00;A003
J4A400=400<TA4@01T@00bA4A002A0<T00=492@00b@5A00394@T00I400<TA4@00T@00bA4A009A08T
2D@2J005A6Q4A2@00T@00fQ4A003A00494A4A08T0T@00fQ4A00@A00394A401m40VP5A003J4AX009X
14@00fQ4J002J0=400=XA4@00d@00fQ4A003A0EX0T@<J005R6QXJ8P016P2R004J4AXJ0B800EXR8R8
J002A0:800AXR8QX0HP000U400EXA4A49002A08T0T@012A4A2@5A00394A401E400<TA2@034@00bA4
A002A00394A400E400<TA4@00d@02BA494@TA2A4900;A0DT14@012A492@3A00394@T00M41B@:A08T
00=4J4@02T@290U400<TA2@012@2A0@T00=4J4@01d@390M400=XA4@024@00bA4A003909400=XA4@0
34@29003A2A400A40R@5A00394A4009400EXA2A49004A0IX0XP01Hb8R<b/00C@00J/d=3AmM43m@03
lOGa00ge00GamOGed@07m@07dO7amM3Al@04d003mJc<00;@00F/d:c<[002d004dM3al@Se0_401=7@
lM4Bm@C@00?Ad=002?D00oWem@0;m@03nOGe00Ce00SamOGelM3Al@O@00gAd=3Ad=7@dO7@c=3a00;e
00KamOGedOD2l@;A0]001<c@[:`2S0:800B/S:b81H`2R003J8QX00AX5T@00fQ4A005A0TT2d@00bA4
A008A0<T2T@00bA4900390I40VP00dAXA00:A08T1D@00bA4A00IA00494A491=400<TA4@04T@2J0]4
00=XA4@00d@5J004A6QXR0aX00F8J6QXR003J004R6QXJ0B80VP3R0AX0XP1S0680FP000=400<TA4@0
14@290E40b@2A0<T0d@00bA4A00DA0<T4T@490i40b@AA08T24@390A400<TA4@01T@490M400<TA2@0
3D@2909400<TA4@01T@590A400<TA4@01D@790M400=X94@01D@29003A2@T01E400<TA4@02T@00fQ4
A005A09X00=4J4@01D@5J007R6R8S8S@c005d007c=3emM3el@03m@03dOGa00?e00?amOD01?D00m7a
l@02m@08dO7edOGadOD2d003mM3<00?@00?ec:`01:`2d003c:c@00;@00?Ad?402oD00m3al@07m@03
lOGe00[e0]400m3Ac002d004lOGen@?e0_TDm@05dOGemM000Z`01Lc@c<b/00?@00GAd=3@d@03d005
mM3AdO400_D01O7edO7@00;a00CAd=3<0]03[006S8R8S:b<0j`00hb/S002S0B81VP=A003J4A400Y4
00<TA4@014@5909400<TA4@03T@59003A6Q400I400@TA4A40b@7A003J4A400=40R@6A08T14@00bA4
A009A003J4A400Q40b@3A00494A491U400=XA4@01T@00fQ4A002A0=X2d@00fQ4A004A09X00A4J4A4
0fP018QXJ6P3A008J4AXJ8QXR6P2R003J4AX009X00B8J6R80VP02XQXR8QXR6R8S6P2R05X0003A003
94A400=40b@4A0@T0d@290M400=XA4@01D@00bA4A00;A0<T14@00fQ4A00;A00394A4009X2T@490A4
00<TA4@02T@00bA4A008A00394A4009X0d@290E40R@3A0@T3D@01FQ4A4@T00a400<TA4@00b@00d@T
A006A00394@T00HT00=4J4@014@016PT94@2J003A2@T00=40R@7A003J4A4011400<TA2@05T@6J009
R6R<[=2/c8c<00:/0l`01=7@lO45m@03lOGe00Ge00CAmOGe0_42m@0=d?GAd?7edOG@lM7@[002d003
c=7<00;<00?ac:`00]02[0?<00?@dOD02oD00m7em@0@m@05nOGimO400]001Jc<[=7a00Ge0oTBm@04
lOGad@;e00?@c:`01:`2c0;@0]43d007c=3@dM3Ad003m@;a00C@lM3e0]42d00>c:b/[8R/R8b/R8b8
[<`3S007[8R8S8R<R002J003R6Q4009X34@01FQ4A4@T009400=XA4@01b@00d@T90059003A2@T008T
3T@390]41R@8A004J4AXJ0=400<TA4@00T@012A4A2@2A08T3D@00fQ4J006A08T1D@00bA4A004A003
94A400M400<TA2@02T@00fQ4A005A003J4A4019400EXA4A4J003A003J4A400=400AXR6QX0d@00fQ4
J002J004R6QXR09X00=4J6P016P00hQXJ002R004J8R8R09X0hP2J0000T@01BA4A4@T00940R@00d@T
A002A00494A490=400<TA4@024@290A40R@=A08T00=494@014@490=400DTA2A49004A08T1D@012A4
A4@390e400@TA4A40R@00d@TA002A00494A490M40R@6A08T00=492@00R@00d@TA003A00394A401e4
0b@4A0<T0d@49003A2@T02E400@TA4@T14@00bA4900290Q400<TA4@034@2J004A6QXR0>/00>8[=00
1:`01lc@d?GamO402oD3l@Ce00CAd?7e0]000o7em@03m@04d<c@l@C@0_D01=2/dM02[006c=3@d=7a
3?D00o7em@0Am@04nOGAd@;@00?<d=001OD2nP;i3OD00o7em@04m@03lOGA00;A0]06[0C@00CAd<b/
0]000jc@d@02d@;a00K@mM3@dO42d003c=3@00>/00>8S:`00Z`2S0B/00B<[:b/28P4J15400<TA4@0
0d@00bA4900:9003A2A400<T00=494@01D@00fQ4A003A0<T1D@290=412@6A00394A400=400MXA4A4
94@T00940R@4A0@T1T@00bA4A00IA0<T2T@00bA4A005A003J4A4009400=XA4@06D@00fQ4A005A0UX
0d@5J003R6QX00=X00>8J6P016P00hQXR002R003J8R800:800EXR8QXR002J0001D@2909400<TA4@0
0b@IA00394A4009400<TA4@00T@00fQ4A002A0<T24@01BA4A2A400@T24@016Q4A2@5A08T0T@00bA4
A004A00394A400<T14@290]400<TA2@00d@00bA49005A0HT14@00bA4A00MA08T1T@390M40b@2A08T
24@016Q4A2@3A00594A4J4@00R@00d@TA005A0<T0T@00bA4A005A08T00=494@01D@00bA4A009A004
J4A4A0=X00J8J8b/R8`7[004d:cAd@Ge00?AmOD00_D01]7alM3ed0;e00_adM3<lOGad=7@m@02l@?@
00N/c=6/c?GA00?@00?e[:`00m02lB?e00Kad=3@mM02l@03mOWe00;e00?in_T00_T<m@03dOWe00Ge
00?ad=400]001<b/[8`4[008c=3ad<c@[=02[0?@00CelOGa0]000jc@m@02d003c=3@00:/00><R8`0
0j`00hR<[002[006S8R/S:b<0hP00fR8R002J0Q400<TA4@03D@39004A2@TA0<T0d@00bA4A005A003
94A401A400<TA4@00d@00bA4A006A00394A4009X14@290U40b@6A00494A4A08T4T@01BA4A4@T00A4
00=XA4@00T@291Y400=XA4@06T@3J003A6Q4009X00=4J6P03VP00hQXJ002R003J4AX00EX00>8J6P0
0VP000M40R@3A00394A401=40b@4A08T00=492@01d@012A4A2@:A00694@TA2A40b@@A00394A400]4
0R@6A08T0T@00bA4A007A00394A400HT0d@39003A2@T00A400<TA4@06d@012A492@2A08T0d@00bA4
A004A0LT00=494@02T@29003A2@T00A40R@00d@T90029003A2@T00A400<TA2@00d@00fQ4A0039003
A2A400=400<TA6P02T@016Q4A4@6J0B80X`3[009c=3AlM7elOGa00?e00GamO7el@02m@03dO7e00;e
0]001:c@mO42d003c=3@00>/00N<c=3@[<b/00?@00>/d<`00]000o7@d@0?m@03lOGe00Ce00?adOD0
3?D01m2/d<b/mO401oD00oWjn@0Em@;a0m000jb<[002S0?<0]001=7<d<`2d005c:c@d=400_D01]3a
[<c@d@;@00C<d<c@0Z`2S0N/00G@c:b8S005R00:J8QXR6Q4J8Q4J09400=XA4@03T@39003A2A4008T
1d@00bA4J004A08T4D@00fQ4A002A0=X00E494@TA00290=400DTA4A4J002A00394@T00@T2D@290A4
00<TA4@02D@00fQ4A002A08T24@00bA4A004A00394A400940R@>A003J4A400=400=XA4@01D@00fQ4
A002A003J4A400=400EXA4A4J007A0AX00J8J6QXA6P2A003J4AX009X00>8J6P016P00hQXS004J0:8
1fP00dAXR002J0680003A00394A4009400<TA4@00R@;A00394A400A400<TA4@034@012A4A2@9A0DT
1D@012A4A4@490a40b@7A0<T0d@490E40R@2A0<T1T@390=400<TA2@00R@6A08T74@012A4A6P7A003
J4A400]400<TA2@03d@00bA4A00<A00494AX90]40VP7A00394A4009400<TA4@024@018QXA4@2J004
R6QXJ0:800=XR8P00j`4d0;A00CelOGa1OD00o7em@03m@04lOGem@;@00V/d=3edM3<d<`00Z`01Hb/
d=3A00>/00C<[<b/0]02c004dM3@d@We00?imOD02_D00m7em@03m@03nOGe00Ge0]000lb/[002d003
mM7A00Ge00?jnOT04?D01_7emOGad0B/0X`01jb<[=3<d<`00]001Zc<d:c<[0?@00CamM3a1]001/c@
d=2/S0b/0XP00fR8R002S0:800=XR6P01fP4A003J4A400A400<TA4@00d@690E400<TA4@024@00bA4
A002A003J4A400M400=XA4@00VP:A08T14@390M41R@00d@TA004A08T1D@00bA49009A006J4A4A2A4
0R@7A08T1D@290E400<TA4@06T@00fQ4A002A003J4A400940VP2A0=X0d@016Q4A4@3J0=40VP2A09X
0T@01HQXJ6Q400=X00>/J6P00fP01XQXS4AXR09X00J8J6Q4R8`2R0000d@00bA4A002A0@T0d@00bA4
A00KA0HT24@01RA4A2A490A400@TA4A40b@=A08T1d@290M40R@6A0LT0d@590941b@5A08T6D@00bA4
A00=A004J4A490M412@@A00394A400=400<TA4@02d@290i412@3A08T34@00fQ4J002J006A6QXR6R8
0X`01/b/dM3Ad0;a2OD00o7em@07m@06dM3<[=7a0]42d00:c=3@c:c@c=2/c0>/00?@c=000/`01=3a
d=0Qm@;i00SelM7@c:c<d@;e00?AlOD01?D3n@oe0_401_GamOG@c0>/18`00jc@d003d003c=3@00?@
00J/d=3AlOD2d@;@0]46d0N/00N<c8b<[8b/00:<00N8[8b<R6R8009X00N8J6R8A6Q4009X0T@00fQ4
A009A00594A494@00b@JA00394@T009400=XA4@00VP00dAXA00<A00394A400I400<TA2@01B@6A0<T
1D@00bA4A004A00394A400E400<TA4@044@00bA4A004A08T2d@00fQ4A009A003J4A400I40fP2A003
J4A400940fP2A003J4A400AX00A4J6QX0T@3J003A6R800EX00>8J8P01VP2R09X0hP2J003R6R800>8
0003A00394@T009400DTA4A49003A00394A400=412@4A00494A490Y40R@@A00394@T00=41R@00d@T
A00?A00694A4A2A40R@7A0@T14@59003A2@T00DT00=492@00T@490M40R@9A00394A400a40R@8A0DT
0T@00fQ4A00290U400@TA4@T1D@00bA4A00HA0<T14@01FQ4A4@T01E400=XA4@00T@00fQ4A005J0>8
0X`2[0;@00CAd=7a2OD00o7em@05m@04dO7@c0:/00K@dM3@c=02[0;<00>/d:`01:`018b/d=42d003
c=3e00[e0_TBm@03nOGi00;e0_T00oGad@04d0?e00CamOGe0_T00oGim@0?m@;a0_D01=7elOD2d@04
d:b/S0:/1M001M7<c<c@00;<00B/d=3A0_D00m7ad002d005dM3@c=000Z`01<b/S8`4[0><00F8S:b/
R003[003R6QX00>800AXA4AX4d@290I40R@;A09X1d@012A4A4@390M400=XA4@00T@00fQ4A0029004
A2@TA08T1T@00bA49002A0DT1T@29003A6Q400Y40R@6A08T34@00bA4A00RA09X0d@01VQ4A6Q4J0=4
00=XA4@00d@2J004A6QXJ0940VP2R09X0T@01FQ4J6Q400UX00>8J6P00fP3R003S6QX00B80fP1A05X
0HP000E400@TA4@T0T@00bA49006A08T00=492@014@00bA490029003A2A400M40R@;A00394A400I4
00<TA4@00T@012A492@AA00394A400I40R@5A08T1T@390941b@5A0<T0d@290I400<TA4@03D@29154
00<TA4@02D@00bA4A00?A00394@T00Y40R@2A08T1D@012A492@PA003J4A400A40VP00dAXR002R004
S:b/[0;@0]42l@;e00?amOD01?D3l@Ge00CAd=3<0Z`2d003mM3@00;<00B/c<b<0]03[003c:c@00;@
00?ad=401OD2n@We00?imOD03OD01OWemOGi00Ge00Cad=7a0oD01?WemOD3nA3e00?amOD00_D01?7e
lM42l@03c:b/00:/00G<d=3@d@08d006dM3@dO7e0]401=3AdM44d0B/00B<[:c<0j`2S004R8b/[0:<
00>/c8`00hP2S004R4A4J19400<TA2@00b@4A08T2T@3J0Q400<TA2@00d@00fQ4A00:A004J4A4A0<T
1d@00bA4A0069003A2A400E400<TA4@04d@290E400=XA4@00d@490I400<TA4@044@00fQ4A003A0=X
00=4J4@00T@2J09400EXA4A4J002A004J4A4J09400AXA4A40VP00dAXJ003J0941FP2A005J4AXJ4@0
0fP2R09X00>8J8P00hP00fR8R009J00014@590M40R@2A00594A4A2@00d@590940R@7A0<T00A494A4
0b@2A0DT1D@39006A2A4A2A40R@BA0<T34@01BA4A4@T00=400@TA4A41B@3A00394A4008T0d@390M4
00<TA4@00d@290I40R@6A08T1d@290e400<TA4@00d@290a40b@00dAXJ002A003J4A4008T00=494@0
0R@/A004J4A4A0=X0XP4[007c=7@dM3ad003d@Ke0_46m@07lM7@d<b/c005d0>/00?<[:`00/`01M3<
[:c<00C@00?amOD00oD00oWjn@08m@;i5_D01?7elM05m@03nOGe00?i1oD00oWem@0:m@05lOGalM40
0]001=6/S:`2d0?A00?@dM000]000m6/d005d004mO7ed@;@00?Ad?401=001Jb<S:b800>/00F<[:b<
R008[0J800AXA6QX2D@00bA4A009A0<T0d@290Y416PBA09X00=4J4@01d@29006A2@TA2A41B@2A08T
00A494A40R@5A00594A4A2@04T@00bA4A003A003J4A400940R@8A003J4A401I40fP2A09X00A4J6QX
24@01FQ4A4AX00=400=XA4@00d@01FQ4J6R800IX0T@00fR8R002J0940fP018Q4A6P3R0AX00F8J6QX
A005J0001T@390=400DTA4A49007A00494@TA0DT00=492@00d@00bA4A003A08T00=494@00R@00d@T
900490I41R@:A08T1D@00fQ4A00EA00394A400=400HTA2A494@290940R@014@T92@5A00394A400=4
00=XA4@044@00bA4A006A004J4A4A08T00=494@02d@390e400<TA4@01B@9A08T0T@3915400=XA4@0
2T@01FQ4A4AX00E400=XA6P01FP014AXS8`3[005c:c@d?400]42d003c=7A00Ge00?AmO400_D01M7e
mM7e00;@0l`5d004[<c<d@C@00G<d<c@[003d0?e00?imOD00oD00oWem@08m@03nOGe00;e00?imOD0
1OD01?WemOT2m@06nOGemO7A1OD01_[inOWenPGe00CimOWi0_D01OWemOGa00?e0]401?GadOD3d008
dLb/c=3elOD3d009[=3@d:c@c?7@00;A00O@mO7@mM3A00;a00C@[=3@0XP018b/S8P2[007S:b<R:b8
S002R0B/00>8[8P00VP00hQXJ002J0I400AXA4@T2d@290Q40R@7A0IX1T@00fQ4A007A0=X1T@00bA4
9004A00394@T00940R@3A00394A400940b@2A08T2d@00bA4A00HA00394A400Y40R@8A09X00=4J4@0
2T@2J003A6Q400=400=XA4@01D@2J0940VP5A007R4AXJ8QXR002J007A8QXA8QXR003J003A6QX009X
0d@2J003R6QX00AX00B8J6QX18P000M400HTA2@TA2@2A00394@T00a41b@4A00494A490=40R@00d@T
A002A0@T0d@012A4A4@49003A2@T00Q40R@5A003J4A400=400<TA4@07D@5909412@00d@TA00<A005
94A4A2@01T@00bA4A008A00494A490a40R@014@T92@AA08T2d@39003A2@T01m400=XA4@00T@00fQ4
A005A003J4A400=400QXR8b/S:c@[0;@00?Ad?D00]02d@Ke0_42m@03d?Ga00;e00KadM3<d<`2d003
[<c@00:/00?<d=000m002Lc@[:c@dM3el@07m@03nOGe00Oe0_T6m@03nOGe00Ke00?imOD00_T4m@03
dO7a00Ce0_T01?GjnOT7m@03nOGe00Ce00SAlOGedO7Am@;@0j`9d003c=2/00;<00?@c=000m02d@03
mO7a00?@00SAd?7<[<b/S0R/00F8S8R<[002R004[8b/c0F80VP3A003J4A400=400=XA4@00T@00fQ4
A008A08T24@00bA4A005A09X00A4R6QX14@00fQ4A00:A003J4A400E40R@9A00394@T00@T1D@390e4
0b@>A004J4AXJ0i400<TA4@03T@00fQ4A006A003J4A401=40fP01DAXJ4AX00940VP3A0QX00=4R8P0
0VP01XQXA4AXA0UX0XP00fR8R002J004A6QXS05X0006A08T00A492A40R@014@T92@2A0<T00=494@0
1D@590=400DTA2@TA00290=400<TA4@00T@390=40b@2A00494A4A0@T14@00bA4A00@A08T34@00bA4
A00@A00394A400DT84@00bA4A003A00394A400a400DTA4A4900BA00394A400E400DTA4@TA00491=4
0R@00dAXA004A00394A400U400<TA4@00T@00fQ4A002A003J4A400:800^/S:c@c=3AmM3ad@02d003
lM7a00Ce00[amO7edM3adM3e1]02c003[=2/00?@00?<d:`00m02c0;@00?AlOD04?D00oWem@0Hm@?A
0oD01_WenOWen@oe00SAlO7ed:c@m@;@00B/R<b<0Z`8d00=[=3<d<c@c:c<dM3Al@07d006c:c@c:b<
0Z`2S0>/00N8[8b/S:b800:<00B/S8QX0XP00fQ4J002A09X1d@00fQ4A009A00494A490A400<TA4@0
0R@4A004J4AXR09X00F<J4A4J003A09X00B8A4A40VP3A003J4A4009400AXA4A40R@5A08T0d@29004
A2@T90I412@2A00494@T90E40b@9A003J4A4009400=XA6P074@2J0E40fP4A003J4AX00m400=XA4@0
0T@6J003A6QX009X0T@6J005R6QXR6P00XP2J0940VP2R009J8Q4J4AXR6Q400=X00>8J4@00VP1R05X
0007A08T00A494@T0T@012A4A2@2A08T00A492@T1T@39005A2A4A2@00d@290=400DTA2A49006A0<T
00=494@01T@2909400<TA4@03D@00bA4A006A00394A400I400<TA4@01T@00bA4A00:A0<T00A492@T
3d@29003A2A400=412@3A0@T3d@00bA4A002A0<T3D@00bA4A003A00394A400I40R@00d@TA005A003
J4A400]400<TA4@014@590=400AXA4AX44@2R0:/0]003:c@dO7AlM3Ad=7@d@Ce00WamO7Ad=7amM00
0_401=7@d=02c0?@00?<d=000m000jc<l@02d003lM3A00Se0oX00oWem@0Km@07nOGemM7am@02d@04
mOWin@;j1OD00oWen@09m@CA00F/S<cad002[006S:b<[=3<1]03c003[=3A00:/0/`01]7@d=7@c0G@
00C<[<b/18`00jb<[003[003S8R/00:80X`01:b8S8`3R003J4A400=400=XA4@00VP<A09X2T@290A4
00=XA4@00VP018QXJ6P3A003J4A400=400=XA4@00VP3A004J4A4J0I400<TA4@01d@29003A2A40094
00DTA2A49005A08T7D@00fQ4A00>A003J4A400Q40VP5A003J8QX009400=XA4@00T@3J003A6Q400A4
00=XA4@02D@2J003R4A400QX00I4J6R8J8P8J09400=XA6P01FP01TAXR6R8J0940XP2J0:80FP000Q4
12@3A08T00=492@014@390A400EXA4A49004A08T0T@00bA4A002A00494A490]400<TA2@00T@012A4
A4@29003A2A400=400<TA4@00d@016Q4A4@290Q400<TA4@01D@290Q400<TA4@044@00bA4A009A004
J4A4A08T1d@390A40b@=A0DT00=492@00b@2A003J4@T00I40b@4A00494A490I412@<A08T14@00bA4
A005A08T4d@00fQ4A003A09X00?<S<`00]02[0;e00CAmM3A0]03l@Ce00K@lOGAmM02m@08dOGAc=7<
d=43d0:/0]001m7@c=7amO400]401O7AmM7a00Ge0_XAm@04nOGen@Ge00CimOGi0oD03O7edO7edOWj
nO[enOX01?D01?[enOT5m@04nOGem@;@00?<[8P00]02[007S:b/S=3Ac004d00:dJb/c=3<mM2/S0;@
00?Ad?400m02c0?@1:`01hb/S8R<[8`00Z`4R003S:b<00R80VP4A004J4AXJ1U400<TA4@01T@3J0e4
0VP5A003J4A4009400=XA4@03T@290M400<TA4@00d@01RA494@TA0<T1T@290Y40VP2A003J4A400m4
00AXA4AX0d@016Q4A6P5A003J8QX00U416P8A09X14@2J004A6R8J09400IXA6R8J8P2J0940fP2R0AX
0XP01FQ4A6Q400IX0T@00fR8S005J003A6R800:80003A00694A4A2A40b@2A00394@T008T14@490A4
00EXA4A49004A08T2D@29003A2A401E400LTA4A494@T00I41B@6A00494A4A0<T00=492@01d@00bA4
A00;A00394A400=400<TA4@00T@00bA4A005A0<T14@4909400@TA2@T0T@00bA4900;A08T00=494@0
0T@690Q400@TA4A40R@2A00394A400940R@4A00394A400E40R@4A0@T1D@39007A2A4A2A49003A003
94A400U40VP6A003J4A400:800><[8`00j`01]7emO7Al@;@0]44m@05lOGalOD00_401OGAmOGa00?@
00?Ad=000]000jc<[002d006dO7AlOGA1?D01=7amO43m@?i3?D01O7emOGi00[e00?imOD01?D3l@04
dOGem@Ki3oD02_7@c<b/c:b<c8P5[003c:c@00C@00G<d:c@c002d003S:b<00;@0/`00m3<S003c0:/
00K<[:b/d:`2R006[8b/R8b/0XP00jb8S004R0:<0hP6A0AX6D@00bA4A007A003J4A400E400MXA6Q4
J4AX00A400=XA4@02d@00bA4A002A08T00=494@012@5A00394A400A40R@014@TA4@390Q400<TA2@0
5T@00bA4A00EA003J4A400E400=XA4@00VP9A006J4AXA6Q40fP00dAXJ002A003J4AX00MX0T@00fQ4
J005J003S8QX00AX0T@00hQXJ003A0AX00B8J6R816P1R0000T@00bA49003A00394A400A400<TA2@0
1T@290i40b@6A00394A400=412@5A00394@T009400DTA4A49003A08T0T@00bA4A009A0@T0T@390M4
0b@7A00494A4A08T0d@00bA49002911400@TA2@T1D@390A40b@<A00394A400I40R@2A00594A494@0
0R@4A08T2d@29003A2@T009400DTA4A49002A00394A4009412@6A0DT14@00bA4A002A00594@TA2@0
1d@2J0U40VP2S006[<b/[=3a0]04l@03dOGA00?e00GadOGed@02l@03mO7a00;a00?@mM001=001=7@
d<`2d0;A00SedO7adO7ed0;A00?amOD00oD00oWjm@0Wm@04nO[jnP;i2_D01OWemOGa00;e00CAc<b/
0]001Jb<R8R<00F/0]000m7@d003[008d<ced<b/d:`3d004[8b/c0R/00><[8P00hP01:b8S8P3S005
R8b8R6P01XP3J0A400>8J4@09D@00fQ4A005A005J4A4A6P02d@490941B@00d@T90029003A2A400PT
00Q494A494@TA0HT1D@00bA4A00290=400<TA4@04T@2919400EXA6R8J007A09X0XP8A003J4AX00E4
0fP00dB8A004A0QX0d@2J005A6R8S8P00fP00hQXJ006J0940fP01XQXR8QXR0=X0D@1J0000d@39003
A2A400M40R@00d@TA003A08T00=4J4@01d@590]40R@00d@T9007A08T1D@290E40b@6A00394@T00=4
1B@2A08T1d@390A400@TA2@T0d@4909412@:A00394A400@T1d@01BA492A400@T3T@00bA4A004A004
94@T90E40R@2A00594A4A2@00T@290I41b@2A00394A400=40b@2A0<T24@29004A2@T91A400=XA6P0
1d@3J006R:b/d<b/0m000m7al@03l@03mO7e00;e0o400oGAl@02m@07lOGalM7ed@02d003dM3A00?@
00G<dM3Am@02l@04d=7em@;@00?AmO400oD00o[in@06m@03nO[e01ke0oT2nP03nOGe00;i3_D2d0;<
0Z`2S0:80X`01=3<[<`2d003dM3<00>/00?<[=000j`00lb/d002d0F/00?<S:`00Z`2R006[8b<[8R<
0Z`018aXS8`3R003[8R800:800><R8P00VP3A0EX34@2J0]400<TA4@01d@4J0A40fP9A003J4A400A4
6b@2A08T00=494@02d@00bA4A003909400<TA2@00d@29003A2A400]40R@3A003J4AX009400=XA4@0
2T@2J0M40fP8A09X0T@00fQ4A006A003J4AX00941VP00dAXA003A003J8QX009X1hP01FR8R8b8009X
00A4J6Q436P000A412@?A0<T0T@012A4A6P2A0<T00A492@T24@012A4A2@IA08T00=494@00d@490I4
00<TA4@00d@00bA4A004A00394@T00=400<TA2@00R@4A08T0d@490M400@TA2@T0d@490=40b@2A003
94A400<T3d@00bA4A006A0DT00A492@T24@490I40b@01D@T94@T00I40b@2A0<T24@290940R@>A003
94A400i400B8J8R<0Z`00lc@d002d004dO7Ad0Oe00?AlO400_D01]3emM3el@;A0_400m2/d004d00A
[=3@dM3AmM7@mO7edM3AmM400oD01?[inOT5m@Ki5OD00oWem@05m@04nOGinA7e00Kad=2/S:`4R0><
00O@[:c@dM3A00F/00O@c<b/c:c<00;@00Kad?6/c=02[004R8b/S0:80h`4[003S8R<00:800^/J8R/
R:aXR8b8J005A0AX0T@00fQ4A008A003J4A400Y400<TA4@02D@3J0A400=XA4@00T@00bA4A007A003
J4A400DT0T@>9004A2@T909400<TA4@01T@00bA4A002A00394@T01540R@014AXA4@2J0M400@TA4A4
0fP2A003J4A4015400HTA8QXA6P6A003J8QX009400EXA4A49002A08T0T@00fQ4A003J003A6Q4009X
1D@2J0940XP00jb8S002R003J8QX00:800=4J6P01FP00dAXJ004A0=X0005A00394A4009400<TA2@0
1D@00bA4A003A08T1D@00fQ4A0029004A2@TA08T0T@00bA4A002A00594A4A2@00T@390Q400<TA2@0
0b@2A08T0T@490A41B@00d@TA002A00394A400M400HTA4A494@29003A2@T008T0T@00bA49005A0<T
00A492A41b@2A0@T14@290=40R@2A08T3D@01BA494@T00E412@00d@TA00290941B@2A0DT1T@29003
A2@T008T1d@00bA4A002A08T14@00bA4A00390940R@FA003J4A400I40VP02hR/[=6/c=3Ad?Ga00[e
00CAmOGa0_D01_7AdO7ed@;e0]001M7@d<b/00;@00SAd=3amM7@l@;e00[AmM3amO7enOGi0_X00oWe
m@02m@;i00?enOT02OD00oWem@03m@03nOGe00[e00GimOGim@02n@03mOWe00ge00O@[:b/S8R/00:8
00F/S:b/d002[003c=3@00R/00?ac=000/`3d003mLb<00:/00J8[:b8S8P4J005[8b<S:`00XP00fR<
R004J004S6R8S0:800=XA4@00d@3J1Q40R@01T@TA6Q490M416PCA00394@T00<T00=492@03B@3A08T
00=492@01d@290A412@AA00594A4A2@034@4J0M400@TA4AX3D@00hQXA006A006J4A4J4AX1D@00fQ4
A006A0AX0T@2J0=400=XA6P00fP00hQXJ002R004J8QXR0EX00=4J6P00XP2J0M40VP0009400<TA4@0
0T@5909400<TA4@00T@290E400<TA4@01D@39003A2@T008T0d@00bA4A00290=400<TA4@012@4A0DT
0T@690=400<TA4@01D@690940b@4A0@T14@490941b@4A0@T0d@39004A2@TA08T0d@00bA4A00390E4
0b@4A0<T2D@29003A2@T008T00=494@01T@3909412@2A00394A4009412@4A08T0T@290E400=XA6P0
1d@00bA49005A0<T8D@4J004R:b/c0;@0]400o7em@08m@05lOGamM400_401?GAmO42m@03dM3A00;A
0m001o7AdM3Ad?400_D00m3el@03m@03dM3A00?e0_T00o[im@02n@;e00GimOWen@0Hm@05lOGemOT0
0oD2nP;i3_D00o7<d002[0:800B/R8R80h`4[003d:c@00>/0h`00lc@d003d0;<0]001Jb8[:b<00B8
00=XA6P00VP01Jb<R8R<00:800=XR6P00VP4R0:<00B8J4AX1D@2J1M412@4A0<T00=XA4@00VP3A003
J4A400=40R@5A00394A400941B@00d@T9005A0PT0d@00bA4900590A40R@3A0<T00=492@00b@?A004
94A4A08T2d@00fQ4J005A005J4A4A2@00d@00bA4A00:A006J4A494AX0T@2J0940VP8A09X14@016R8
R6P2A003J8QX00E400=XA8P016P014AXS8P8J003R6QX00AX0T@00fQ4A002A05X0002A00694@T94@T
0T@29003A2A400E400<TA4@00d@00bA4A00;A00394A400A400@TA2A40b@00d@T900290=41b@00d@T
90029004A2A4A0<T1D@39003A2A400DT1D@590I400@TA4A41R@3A00494@T90=412@5A08T1T@390I4
0b@5A08T00=494@02D@490A400<TA4@014@00bA4A00<A00394A400E400<TA2@034@69003A2A400=4
00<TA4@02T@00bA4A009A003J4A4009400<TA4@00VP2A0=X00B8[<b/0]02d@?e00?amOD01_D2l@;e
0_401OGamO7e00;a00?@lM401M000m7ad@02l@[e00?adOD00_D01?WjnOT4m@04nO[im@?i8?D00oWe
n@0>m@03dM2/00:/00J8S8QXR6P2R0B<00F/c:c<[002S0:/00B<[<b/0m001Zc<[=2/S0:800><J8P0
0XP3A09X0Z`018b8[8`5R006J8R8R:b<0XP00fQ4J008J0I400=XA4@03d@290A400<TA4@00VP2A09X
0T@01FQ4A4AX00Q400@TA2@T1T@00bA49008A0DT0d@29003A2@T008T0T@00bA490069005A2A494@0
12@2A08T00=494@01T@2909400@TA4@T2T@00fQ4A007A00394@T00=400<TA4@04T@00fR8A008A003
J4A4009X0T@01FQ4J8b8009X00=4R6P00VP014AXA4@<J003R6QX009416P3A003J4AX00940VP3A000
0d@022A492A494@T0T@00bA49002A00394@T008T00=494@02T@2909400<TA4@00T@99003A2A400@T
0d@89004A2A490A40b@00d@TA0049003A2@T00@T0d@790]41B@9A0DT0T@290M400@TA2@T1D@016Q4
92@3A00394A400=40b@8A08T1D@390=400<TA4@01T@2911400<TA4@02T@890Q400<TA4@01T@00bA4
A00GA008J8R8S:c<dO4>m@06lOGemM7a1?D00m7ed003l@?@0m43l@Oe00GamOGel@03m@Ci0oD3n@04
n_WinAce00GimOGim@04n@ke0]02[004S6R8J0:<1XP01:c@[:`3c0B/00S<[:c<d<b/d0F/00>8J6P0
0fP2A009J8R<S:b<R8b/00R80h`2J003A6R800:80fP00hQXJ002J1]400<TA4@03d@00bA4A00=A0<T
1T@00bA4A003A00394@T00<T00=492@00R@014@T92@2A0DT0d@:9003A2A400a400<TA4@01D@00bA4
A00=A0DT44@00fQ4A002A003J4A400E40VP5A0QX00=4J6P00fP8A09X0XP01DAXA4AX00:80fP018QX
J6P4A005J4A4R6P00d@00003J4A400A400<TA4@01d@00bA4900290m400<TA4@01D@29003A2@T008T
00=494@00T@00bA4A004A0DT00=494@00R@7A0DT0d@89003A2@T00<T00A492@T1d@012A4A4@690=4
00<TA4@01T@29005A2@TA2@01d@290M400<TA4@01T@00fPT90029004A2@TA08T00=494@00b@3A0<T
00=492@012@4A08T1D@29003A2@T00M400<TA2@00R@00d@TA005A0DT00=492@03d@00bA4A007A004
J4A4A08T34@2R006J:b<d<ca3?D00m7el@02m@04dOGel@Ce00K@dO7@lM42d007mM3Ad=7ed@03m@09
nOGemM7edO7i00;e1?X2m@03nOGi00?i0_D00oWen@0:m@03nOGe00ke00KimOWjmOT<m@07dOGAd=7<
[002R003S8R800=X0X`01hR/[<b/S:`00]02[005R:cA[=000/`3d0:/00G<[8QXA002J004R6QXJ0>8
0Z`2S0>800><R8`00hP00hb/R002R09X00>8J6P018P018aXJ6P7A003J4A4009X44@00bA4A00NA0@T
00=494@00T@290=400@TA2A40R@00d@TA0029004A2A4A0<T0T@4909412@00d@T900490=400AXA4A4
0R@5A00694@T94@T0d@00bA4A008A003J4A400i400EXA4A49003A003J8Q400=40VP6A004J4A4J0A4
00=XA6P00T@4J004R6R8J0A400=XA4@016P00hQXA002A005J8R8J8P02fP00dB8J003A00000A494@T
1D@00bA49007A08T1T@00bA4A00?A08T0T@00bA4A002A08T00=494@01d@39004A2A4A08T1d@00bA4
9003A08T14@00bA4900390A40b@6A08T1D@490940R@3A09X14@00bA4A003A08T1T@00bA4A00@A08T
0T@290=400DTA4A49005A0DT0T@012A4A4@490A40b@00d@T9008A0HT24@590I40R@6A00394A400=4
00<TA4@00d@01FQ4A4@T00e400IXR8b<[<`3d0;a2oD01O7emOGa00Ge00oamM7adO7Ad=7adO7@dM00
0]45m@06lOG@dOGa0_D01?Wjn_T3m@?i00?jnOT00oD00oWem@06m@03nOGe01;e00?in_T04?D01M7e
d:b<00:800><R8P00XP2[004R8b<[0:<00>/d=000Z`01HR/lM3e00;@00?Ad<`00Z`018R/R8P6J005
R8b8R8`00XP00hb8R003R004S8R8R0:<0hP2J003R6QX00F80VP>A00594A4A2@074@00bA4A00;A003
94@T00=40b@01T@T94@TA0DT0T@00bA490029004A2@TA08T00=492@00b@3A00494A4A0HT1D@00bA4
9004A0<T00M494@TA2A4008T3d@012A4A2@2A00394A400I412@7A004J4A4J0M400=XA4@00VP3A003
J4A400=X00M4J6R8J4AX00E400AXA6QX0XP3J0:800=4R6P00VP00dAXA002J004R6QXA09X0d@000U4
0R@4A00594A4A2@01d@2911400DTA4A49002A0@T00=494@02D@490I400<TA4@03D@012A4A4@390=4
0b@=A0@T0d@00bA4A00=A0<T74@290E400@TA2@T0T@00fQ4A00890A400<TA4@01d@290E40R@2A08T
2d@291M400<TA2@00d@01FQ4A4@T00M400=XA4@00T@016Q4R8P2S006[=3@[=7a3OD01O7emOGa00Ge
00?amOD00]45m@05d?GalM403OD01?Wjn_X3n@;j00?in_T00_T2m@;i1oD2n@Ge0_T00oGim@08m@;i
00GjnO[jn@0=m@;A00G@c:b<[002S0:/00K@[8b<[8`3[005S=2/[8`00Z`01M2/c<c@00;<0j`4R003
J8QX009X00J8[8aXR8`2J0:800F<R:b<R002J0B800><J6P00XP3J0B800=XA4@014@3J2Q40b@8A0@T
14@690=41B@00d@T9002A00394@T00XT00=494@00d@690E400<TA4@014@012A494@29003A2@T00=4
0R@00d@T9006A00394A400=40R@00d@T9004A003J4A400E40R@4A09X14@00fQ4A009A004J4A4J0A4
0VP2A09X00A4J8QX0T@2J0E42fP3A09X00>8J6P00T@00fQ4J001A0001T@01BA494@T00A40R@9A0<T
1T@00bA49002A00394@T00M41R@;A00394@T008T0d@00bA4900390I400<TA4@00b@3A00394@T008T
0d@00fQ4A00;A0<T1D@390Q41B@00d@TA00390Q400<TA4@01D@00bA4A007A08T0T@012A4A4@290I4
00@TA4A412@8A004J4A4A0DT14@00bA4A00390=40R@EA00394A4015400<TA4@02D@3J0:80Z`01M2/
[=3A00ce0o43m@03lOGe00;e00?amOD00_D00m7em@03m@04lOGel@;e00?amOD01_D01OWemO[i00;j
0oT01O[inOWj00ge0_T00o[em@03m@06nOGenOGi1oD00oWjn@02nPce0_402=7ad=3<d:b<0j`00lb<
S003S0>/00><[:`00Z`01hb/[<b/d=401:`00m2/J005J09400AXR6Q40XP2J0F800F<R6QXR003J00:
R6QXJ8R<J8QXR0MX0T@2J0a400<TA4@014@2J11400=XA4@01D@00fQ4A002A00394@T008T1d@29003
A2A4009400<TA2@00R@4A00394@T00lT0d@390=400=XA2@00b@5A08T14@290=400<TA4@012@4A003
94A401Q40VP3A0AX34@2J0I40fP4A0AX0T@2J003A6Q400940VP2A09X0T@2J0A416P00dAXA003J000
24@390A40R@BA00394A400940b@7A00394@T008T3D@012A4A2@7A08T2D@39004A2A490M400=XA4@0
2d@290I40R@00d@TA005A0HT14@490A400<TA2@01D@590=40R@00d@T900290U40R@00dAXA006A003
94A4009400=XA4@014@49003A2A400M400<TA4@00T@390a400<TA4@014@00bA4A004A09X0d@00bA4
A00AA00594AXJ8P00X`4[005c?7@mO400_D2n@Oe00?AmOD00_D00o7em@06m@03dOGA00Ge00?amOD0
1_D01?WemOX4m@06nO[jn_We0oT01_[in_Wen@[e0oT3m@04nOGin@[e0_T00oGjnP0;m@04lM3ad@;<
0m06[0><1:`00hb/S003[005R8b/[=000/`01Zb<[8b/R09400=XA6P00VP00dB8J003J0:800=XR8`0
0X`00hR<R002R003S8R<00N800=XR8P00hP2A004J8QXJ0A400=XA4@01D@012A492@4A005J4A4A6P0
6T@390]40R@00d@T9004A0<T1d@49003A2@T00LT00=494@00T@012A492@4A08T00U494A494@TA2@0
1D@29004A2A4A0<T0d@00fQ4A006A003J4A4009400AXA6QX14@00fQ4A005A09X0T@2J004R6QXJ0Y4
00=XA4@00d@016Q4J6P4A09X00F8J6QXA002J005A6QXJ8P00T@01FQ4A4AX00940VP2A003J4A400IX
0D@1J0001T@012A4A2@DA00394A4009400<TA2@00T@390M400@TA4@T1D@00bA49006A00394@T0094
00@TA4@T0T@39003A6R800A412@2A00494@T90M40R@:A08T00=494@014@390I40b@2A00394A400=4
0R@6A08T1T@590940R@4A00394A400I412@00d@TA008A00394AX00E41B@4A003J4A400=400<TA6P0
0T@01BA4A4@T00M400HTA4@TA2@4A00394A400A40VP9A00394A4009400<TA4@02D@00fR8R002R0>/
00?<d=000_49m@03lOGa00ge00?amOD03?D00oWem@02m@05nOGenOX00_T01_[imOGinP;i00CjnOWi
2_D00oWen@04m@04nOGin@[e00GimOGjn@0;m@04lOG@d0>/0/`01Jc<[<c@00F/00B<[:c@1:`2R0:/
00?<dM001:`00hb8J004J0A41FP2R005J8R<R6P00XP00hb8R003R004J8QXJ0B800F<R8R8J003A003
J8QX00U41R@8A003J4A401=400@TA4A412@2A0<T0T@79003A2A4008T00A492@T24@:9003A2A4008T
14@00bA4A00290=400<TA4@00d@290Q41B@4A08T24@00bA4A006A003J4A400A40VP;A0=X14@2J0]4
00=XA6P01d@00fQ4R008J003R4A4009400=XA6P016P2A0=X00A4J6R80fP1R0000d@012A4A2@2A0<T
1T@00bA4A005A00394A400M400<TA4@00d@290a41B@3A00394@T009400<TA2@00R@00d@T90049094
00=XA4@00d@390A412@5A08T2d@590e40b@5A0<T0d@00bA49004A00394A400A41B@4A08T00=494@0
2D@00bA4A006A08T2T@390E400<TA4@014@29004A2@T90Q400<TA4@00T@016Q4A2@<A005J4A4A2@0
1D@290m400eXR8R/S<b/c8b/c=7@00_e00?AlOD07_D00oWen@02n@Cj00?imOT00_T00o[inP03n@Ce
00CimOGe0oT00oGin@04m@Ci1oD00oWem@02m@;i2oD2l@;@00F<d=3@c002d0:/0]001:b<S:`2S003
[=2/00:/00><R:`00Z`2d0>/00S<S8b8S8QXR0=X00E4J8QXR003S09X18`2R003[8R800:800><R6P0
0hP00jb8S003R004J4A4A0AX0T@290=41B@CA08T1d@290=400<TA4@01R@00d@T900290941b@3A0TT
00=492@01R@3A08T00A494@T14@012A4A4@390E400<TA4@02D@;9003A2A400A400<TA2@01d@00bA4
A002A08T0T@00fQ4A003A003J4A401140VP3A003J4A400AX00I4J6Q4J4@2J0=40fP2R0AX0d@2J0B8
00=XA6P00XP016Q4J4@3J0000d@00bA4A0029003A2@T00U40b@5A00494A4915400<TA4@00d@390I4
00<TA2@00T@39003A2@T00A40R@6A00494A490A40b@8A00394A400<T1T@9909400=XA4@00R@2A004
94AXA08T00A492A40R@4A00394A4009412@5A0<T14@29003A2A4009412@5A00394A4009400<TA2@0
1d@291E412@=A00394A4011400<TA4@00T@00bA4A00?A003R8b800:<0j`01Lb/d=3A00Ke0_42m@03
lOGe00Ke00?imOD04oD00oWen@02m@Ci00?jnOD00_D5n@03mOWe00Ce00CimOGe0oT3nP03nOGe00;e
00CimOGi2_D00oWen@05m@;i0_D01OWemOGA00K@00V/d<c@lM6/R:`00X`2[005S:b8[8`00XP5[007
S:b8S:b<R006J0940VP2R005J8QXJ8`01XP00fR8J002R003J8QX009X18P2J006A6Q4J4AX14@00bA4
900BA00394A400A412@2A0@T1D@49003A2@T008T0T@00bA49004A0DT0d@290=40R@00d@T90049003
A2@T00=400<TA2@012@4A0@T34@01RA4A4@TA0<T1D@590=400@TA4A40R@5A00394A4009400<TA4@0
0T@00fQ4A004A003J4A4019400=XA4@00T@2J0=400EXA4A4J006A09X0XP5J007R4A4J8QXA004J0I4
00=XA6P00VP000M400<TA4@014@00fQ4A003A08T00A494A41B@=A00394A400U400HTA4@TA2@4A004
94@TA08T0T@290940b@>A0@T00=492@00d@690A400<TA2@00R@2A0DT14@490=400=XA2@00d@01BA4
A2A4008T00E494A49002A08T00=XA4@00R@;A00394A400A400<TA4@012@5A00394A401U400=XA4@0
1d@00fQ4A00:A00394A4019400AXA4AX3d@00fR8R002R0F/0]000m7am@06m@03lOGe00Ce00CimOGi
1OD00oWem@0<m@04nOGem@;i00?jnOT00oT00o[en@03nP03nO[j00;e00?imOD00_D00oWem@02m@03
nO[i00;j0oT01?GinOD4n@03mOWe00Ke0_T6m@03nOGe00Ce00?ad=400m001M7<d=3A00;@00>/S:`0
1:`018b/S:`4S0F/0X`01jb8[:b8J8P00VP4A004J8R8J0N800>/R8P00VP00hQXJ003J0:80fP01HQX
A4AX00Q400<TA4@014@00fQ4A00:A0<T0d@490=41B@3A0@T00A494A412@2A0<T00E492@TA0049005
A2@TA8P00T@59005A2A494@00R@01D@T92A400DT1D@29003A2@T00e400HTA2@TA2@6A00394A400Q4
22@01D@TA4@T00Q400DTA4A4J00<A003J4A4009400AXA6QX0T@3J0=400EXA4A4J003A003J4AX0094
00C@R4B816P00dAXJ004J003A6QX00A40VP00dAXA002J0000T@00bA49002A00394A400E400<TA4@0
0T@290E40R@7A00394A400A40R@>A00394A400E40R@5A08T5d@390A400<TA4@00R@4A0<T0T@012A4
94@390=400@TA2@T14@4909400@TA4A42B@4A004J4@T90]412@01D@T92A4008T00A492@T14@29003
A2@T00Y400<TA4@074@290Y400=XA4@07d@3J003R8b/00>/00?<d=40:?D00oWem@06n@Ge0_T01?Gi
nOT3m@03lM7e00Ke0oT2nP03nOGi00?i00?enOX01?T6m@?i1OD00oWem@04m@03lOGa00;@00GadO7A
d002d@05[<b/c=001:`018R<[:`2S003[8b/00>/00^8[<b/R8b/R6R8J002A09X1HP2J0R80VP00hQX
J003J007S8R8R6R8J002R005J4AXA6P02T@00fQ4A002A003J4A400I422@6A0DT0T@=90=400DTA2@T
A00890942B@00d@TA003A0TT1D@790M400@TA4A412@7A08T2d@00bA4A003A08T00E494A49003A005
J4A4A2@05d@3J004A6Q4J09400=XR6P00T@00hQ4A002J0=400EXR8QXA004J09400=XA4@00VP014AX
A6P5A09X0d@000=400DTA4@TA00390A40R@00d@TA006A00394A4011400HTA2@TA2@FA08T2T@01FQ4
A4@T00A400<TA4@00R@2A08T00A492@T3D@490A40b@7A00394A400Y40b@2A00394A400=40R@=A0@T
14@290=412@2A0HT3D@390i400<TA4@00d@490U40fP<A00394A400i400=XA4@00d@2J005R:b/[<`0
0m07m@03lOGe00We00?jmOD02?D00oWem@08m@08nOGin_Gin_T3m@03nOGe00;e00Cin_Gi2_D01_We
nO[inP?i0_X2n@07mO[inO[en@05m@03nOGe00;e00CimOWi1_D01?7ed=03d@06mM3@dM3<0Z`3d004
lJb/S0:/0hP2[008S:b/S:c<d<`2[0:800=XR6P00d@016R8R:`2S004J8R8[0:800=XR8P01HP00fR8
J002J005R6R8R6P00XP2J003A6Q400E400<TA4@04D@8909400<TA2@00T@69004A2A4A0<T0T@29004
A2@T90940R@2A0HT0T@00bA4900590E41b@00d@TA00;9004A2A490E41R@00d@T900>A00394A400A4
00<TA2@0:D@01FQ4J4AX009400=XA4@014@3J003A6QX00A400=XA4@00XP3J0I40VP014AXA4@7J054
000012A4A4@290U400<TA2@00R@3A00494@T915400DTA2A4900@A00394A401]400<TA4@00d@290]4
00<TA4@00T@012A492@2A00594@TA2@014@00bA4A002A00394A400=40b@3A08T1D@390m412@3A003
94A400U41B@=A0DT1T@290E400=XA4@01D@00bA4A00:A09X64@00bA4A007A0=X0XP00jc<d002d003
dOGe00Ce00?AmO400oD00o7em@0Im@05nOGenOX00_T2nP?i00?enOT01OT<m@03n_Wi00?i1?X2n@?j
0_T2m@03nOGe00Se0oT00oGin@06m@03lOGA00;@0]400o7Ad003d003[<c@00:/00J<[8R<[8`6[006
S:c@[8R<0XP2J003R6Q400=400EXS:b8S003R0:<18P00hb8S002R005J4A4A6P00XP01:b8R8P2J0Q4
00<TA4@02T@00fQ4A004A00494A4A0DT1T@69004A2A4A0@T00=492@01B@4A0HT00=494@00T@00bA4
900390M40b@00d@T90079004A2@T90Q400<TA4@00T@00bA4A004A0<T14@00bA4A0029003A2A400Q4
0R@9A00394A400Q400=XA4@03D@00fQ4A005A09X00=4J4@00d@01FR8J6R8009X00=4J4@01T@016Q4
J6P5A0=X00B8J4A416P2A09X0006A00394A400=400DTA4@TA003909400<TA2@01d@00fQ4J00DA003
J4A401I400<TA4@01d@29004A2@T90A400<TA2@02T@00bA4A005A08T2D@390A412@9A00394A400=4
00<TA4@01T@290M40b@7A00394A400A400<TA4@00R@01D@TA2A4008T54@00bA4A008A08T24@00bA4
A003A09X4d@290I400@TA4A40VP014AXR8`4[003c:c<00;a1OD00m7el@08m@03nOGe00_e00?imOD0
2OD01?WenOT2nP03nOGi00;j00?imOT00oT00oGin@04m@03nOGe00;e00CjnOWj0_T4nP;i0_X4n@Oe
00?imOD00_D01OWjnOWe00;i1oD00o7Ad002d@09d=7@d<camO7@00>/0X`9[004d:b/[0:<0XP01fR8
J6Q4J4@00fP2R004S8R8S0:800=XR8P01XP2J09400MXR6R<R6R800AX34@00fQ4A00:A0HT00=492@0
0R@3A0LT0T@29003A2A400HT0T@59003A2@T00HT0T@01BA4A4@T00E41b@4A00394@T00<T00=492@0
0b@4A08T1d@00bA4A004A0@T0d@29004A2A4909400<TA4@00d@390Y40VP7A003J4B800E40VP01TAX
A6Q4J0A400=XA6P016P018QXJ4@2J09400MXR6QXA6Q4009X0d@5J0=40VP2A09X00B8A4AX0T@2J054
0FP1J00000<TA4@00T@390A42R@00d@TA007A003S6QX00M400<TA4@02T@2J1M400<TA4@01T@29094
12@8A00394A400e412@6A08T00I494A4J4@39003A2A400E400=XA4@014@00bA4A002A00394A40094
0b@7A00394A400M40R@4A00596Q494@012@3A00394A400E400=XA4@03D@00fQ4A004A00394A400m4
00=XA4@04D@00bA4A005A08T1D@00hR/R004[003c=3@00Oe00SAmOGamO7en@Ce00CjmOGi1oD2n@07
mOWemOWen@02m@03nOGe00;e00OjnOWenOGj00?i00CenO[i2oD01O[emO[e00?i0_X02OWjn_WjmOWj
m@02n@Ce00KimOWimOX3n@03mOWj00;e00cimOGelOGAd?7@dL`2d0:/0]000o7<c002d005c8b/[8`0
0/`2[005d:b/S:`00X`00jb8R002R003J4AX00AX18P2S0:800><R:`00XP01:aXR8`3J09400B8J8b8
16P7A08T14@016Q4A6P6A0PT00E492@TA00490941b@2A0/T0T@59003A2@T00LT0T@00bA49004A0LT
00=494@01D@49003A2A401e400@TA4A412@2A00394A400=40R@5A00394A400940VP00dAXJ006A003
R4A400=40VP014AXA4@2J0I400=XR6P026P014AXJ8P2J0A40fP014AXJ6P5A003J4A400AX1D@016Q4
A6P1A0000T@01BA494@T00=400<TA4@00d@00bA4A002A0HT14@016R/[6P2A003J4A400U400<TA4@0
0VP>A00394A400E400<TA4@02T@290A41B@014@TA4@390]400=XA2@01B@5A00394A400E40R@00d@T
900;A00394A400I400<TA4@012@=A005J4A4A2@00d@290E40b@3A00394A400=400=XA4@00T@01BA4
A4AX00]400<TA4@00T@00bA49006A08T8d@2J0=400=XR8`00Z`01hb/[:c<d=401OD01?7edOD2l@Ke
00?imOT01OD00oWem@02m@;i00KenOGen_D2n@06mOWemOWe0_T2m@06nOGin_Gi0_D00oWem@02m@03
nOGe00Oe0_T00oGin@06nP;i00?jnOT00_D00o[en@02n@;j0_T01_GinOGjn@Se00?adM400]400o7@
[002[0;A00_amO7Ac=3<[8R<c004[004S:b/[0:<00B/S8R80VP00hQXJ002R0=X0XP2S0B800B/S8R8
2FP6R09X00=4J4@014@2909400=XA4@02D@00bA4900590940b@2A08T0d@012A4A2@4A14T00=492@0
1b@2A00394A4008T0d@00bA490069005A<c<J4@012@GA08T0T@00bA4A004A00394A4008T0T@00bA4
A009A00394A4008T14@00fR8J005A003J4B800940VP014AXA6P2A0=X1D@4J0=40VP00dAXR002R004
J4A4J0M416P4A09X0T@3J0]40004A00394@T00=400DTA2A49002A0<T00=492@012@5A0AX14@29094
00=XA4@02T@01FQ4A4@T00E40b@?A00394A400M412@5A0@T0d@00bA4A006A0HT00I494A494@29094
0R@3A08T0d@290m400<TA4@04d@39003A2@T009400DTA4A4J002A08T3T@390e400<TA2@00d@290M4
0R@6A00394A401a40VP01dB8R8R<[8`00Z`00m3ad@05m@;a0_D00o7el@09m@04nOGen@Ge0oT7m@;i
0oD00oWem@03m@;i0oD2nA;e0oT01o[inO[in_T00oX00oWjn@02nP04nO[jn@;j0oT5m@03n_We00Ce
00?adO400]401=2/[=02d@05d?GAd:`00X`01Jb<[<b<00:/0X`4[003S8R<00:800MXR8QXA6Q4009X
0hP02Xb8R6R8S:b<d8P3J005R6QXA6P01hP016Q4A6P8A003J4A400Q400<TA2@00b@00d@TA0029094
0R@2A00794@T94@TA0059003A2@T00DT00=492@01b@00d@T900>909400<TA4@01b@014B8[6P591Q4
00<TA4@024@012A492@:A09X4d@018QXJ4@2J0=40VP3A003J4AX00Q400AXA6QX0T@;J0=40VP00hQX
J004A003J4AX00m40007A00394A4009400<TA2@014@49003A2@T008T2d@00bA4A002A09X0T@00bA4
A005A0=X00A492A40b@014@T92@8A00394A401U400DTA4A4900:A00394@T008T14@290i412@9A08T
1T@00bA4A00;A08T00E494@TA003909400AXA4@T4D@00bA49002909400<TA4@014@290A400<TA4@0
2d@00bA4A004A00394A400I400<TA4@04d@00fR8J002R004S:b/R0:/0m03m@04dOG@d@?a00?elOD0
2oD2n@Ge1?T00o[em@02m@03n_Ge00;e00?imOD02OD00oWem@02m@03nOGe00Ge00KimOGimOT3m@Ci
00CenOWi1?X00oWjnP07nP;i1OD2n@Ke00?AmM000]02[007c=3ad=7ed002S00:[8b<S:b8S:b<R0N/
0XP01Hb8R8Q400=X00>8S8P018P01fR<R8R<[8P00fP01hQXJ4AXR6P01HP4J0e40VP8A00394A400@T
0T@39003A2A400940b@3A0`T00=494@00b@00d@T900490941B@014@T92@4A0PT0d@492I400<TA4@0
3T@00fQ4A002A00394A400940VP6A004J4A4A09X1T@4J0=416P4A09X0T@2J0:80VP2A0AX00A4J6Q4
0fP00hQXA003A09X0d@00fQ4A007A05X000=A0<T34@00bA4A00AA08T2d@012A4A2@2A0<T8d@29094
0R@;A0DT14@390U400EXA4A49002A00394A401A400=XA4@034@39005A6QXA6P01D@00hQ4A009A08T
1d@00bA4A004A00394A400Y400=XA4@04d@00bA4A007A00394A400=400=XA4@00T@2J0B800Z/S:b<
[<b/lM3a1?D01]3edO7ed@;e00?amOD01oD01?Wen_T3m@07nO[in_WenP02m@03nOGi00;e00?imOD0
2oD01?WemOT7m@03nOGi00;e00?imOD00oD01?[enOX3n@03mO[i00;j00Kin_[en_T2nP?i00?enOD0
2?D3l@08dOGAd:c<d=42m@?A0Z`00hS@c002[0:<00Z/S8b/R:b8[=280fP00jb<R002R003J8QX00>8
00QXR6QX[8R/S0:800U4J6R8S6Q4J8P00fP00hR<J002J0A40VP00dAXA00BA0@T00=492@00b@3A0HT
0d@;90E400<TA4@00T@39003A2@T00<T00=492@00b@4A0hT44@00bA4A004A00394A401U400<TA4@0
0VP9A09X0d@00bA4A00=A09X00=4J4@00T@2J004R4A4A0MX00B8J4AX1d@00hQXJ006J0=400=XA4@0
2T@2J0540003A00394A400I40R@00d@TA004A00394@T00A400<TA4@01d@00bA4A008A00394@T00Q4
0R@2A00394@T008T7D@012A4A2@3A08T0T@29003A2@T00U40R@6A0<T1d@00bA4A003A00394@T00E4
0R@>A00394A400=40b@00fQ4A006A0<T7T@012A4A2@2A00394A400e400=XA4@03D@01BA4A4@T00Q4
0b@:A09X00I4J6R8S:`3S0?@0o400m7am@02dA3e00SimOWimO[inPCi1?D00oWem@0:m@03dO7e00?e
00?imOD01oD00oWjn@02m@Gi0_D4n@04mOWim@;j00Kin_WjnOX5n@?e00?imOD01oD01O7@dM7a00;@
00C<d=7e0]42d0;<00>/S8`00Z`01hR/R:b<R8`01J`01XQXJ:b<[0:800><R6P01HP016R8[8`3R0AX
00F8J6Q4J007R0=X0d@5J1=40R@2A00594A4A2@00d@690941R@2A00394@T008T2T@890=40b@5A0hT
2T@29003A2A400A400@TA4@T2T@00bA4A00AA004J4AXJ0M400AXA4@T1d@00fQ4J004A003J4A400:8
0VP3A003J4AX00=40VP00dAXJ004J0U40fP3A09X0T@00fQ4J004A003J4A400=40VP3A0002D@012A4
A4@290I40R@00d@T9006A00394A400E400<TA4@04T@290=40b@7A0<T2T@00bA49006A00494@T90=4
00<TA4@014@290=400@TA4@T24@29003A2A400]400DTA2A49006A00394A400M40R@00d@T900290A4
0b@5A00494A4A0@T00=494@03D@00bA4A003A08T1D@391I400<TA4@074@00bA4A006A003J4A4009X
00B8[8b<0Z`2d008lM7adO7AmO47m@03nOGe00Ge0oT2m@;i00?jnOD00_TAm@03lOGa00We00?imOD0
0_D00o[in@02n@03n_Ge00;i00OenOGin_We00;i0oX00oWjn@03nP05mOWimOT03_D2d005c=7ed=40
0_400oG@l@04d0:/00><[8`00Z`00hR/R002R0:/0X`2[003R6R800:80fP2R0AX00>8J6P00fP01hb/
R6R8J4@00VP00dAXJ004R003J8R800Q40VP2A00394A400A400<TA4@01D@00bA4A0059003A2@T00A4
00<TA4@00R@3A00494A490E40R@00d@TA003A00594A494@00R@3A08T0T@01BA4A4@T00E43b@9A08T
2d@00bA4A004A003J4@T00Q400<TA4@024@4J003A6Q400e400=XA4@00VP3A0IX0XP01FQ4A4AX00I4
0VP01DAXJ8QX00=400AXA4AX14@01FR8A6Q4009X00=4J6P00d@3J0M40VP1A05X0002A08T1D@00bA4
A002A00394A400A400<TA2@00R@=A00394@T00A40R@2A00394A4009400@TA4@T0T@29003A2@T008T
1d@390]40b@8A00394@T00e40R@2A0<T2D@00bA4A005A003J4A4009400<TA4@00T@3909422@2A14T
0d@00bA4A007A003J4A400U40R@<A0<T;D@00fQ4A004A0@T14@00bA4A002A007J8QXJ8R<R004[003
d?7A00?A00?edO401?D00o7em@07m@03nOGe00?e0oT4m@03nOGe00Ge00?imOD01?D01=7alO46m@03
nOGe00?i00CenO[j0oT01_[imOGim@?i00?jnOT00_D01O[inO[i00;j00Oin_GenOGi00oe0]001:c@
mM42m@?A00G@dLc<d005[0;<00><R:`00Z`00m2<[004R005S8R8J8P01FP018R<R6P4R005S8R8J8P0
0VP018QXJ6P3R09X0XP00fQ4J003A003J4A400A400<TA2@014@00bA4A008A0LT1D@012A4A4@49003
A2A400PT0T@01BA4A4@T00=40b@00dAXA002A0@T0T@39003A2@T00/T00=492@02d@00bA4A007A08T
3d@01FQ4A4AX00U40fP<A003J4A4009400AXA4AX14@6J003R6QX00E400=XA4@01T@4J0a416P2A003
J4AX009X0T@00fQ4A003A00394A400=400000d@TA006A0@T1d@290M400<TA4@00d@00bA4A003A003
94A400=400<TA2@01D@290I412@3A00394A400940R@014@TA2@;A00394A4009400AXA4A40R@=A0<T
1D@00bA4A005A08T00=494@03T@012A4A4@290941B@00d@T9006A00794A494@TA00291=400<TA4@0
2d@00fQ4A003A00494A4J0E400HTA4A494@391=400<TA4@00d@00bA4A00FA09X00I4J6R8[8`3[0;@
00GadM7ad002l@;e00CamOGa0oD01OWemOGi00Ke00?jnOD00oD00oWen@02m@03nOGe00Oe00CamOGA
1_D00oWen@02m@06nOGin_Wj0_T01?[in_T2m@03n_Gi00;i00GjmOGjn@02nP03nO[i00;i0_D00oWe
n@04m@;i0_D00o[em@06m@04d?7ad@;e00OAmM3@lM7a00?@1J`01HR<[:c<00:/00J8J:b<R8`2R003
[8QX00AX0hP01VQ4R6R8J0>800EXR4AXA002J005A8QXJ8P00fP2A003R6QX01U41B@014@T92@6A003
J2A400940R@3A0DT00E494A49005A0DT0T@790940b@00d@T90099003A2@T00I40R@5A08T6D@00fQ4
A00;A09X00=4J4@034@2J0a41VP5A003J4A4009X14@2J006R6Q4J4AX0T@3J00;A6Q4J4AXA6Q4J4@0
0fP2A09X00=4J4@01D@1J0540006A00694A4A2A40R@01D@TA4AX00=400<TA4@05T@490E400<TA4@0
3d@291Y400<TA4@02d@490A40b@2A00394A4008T1T@00bA4A00=A00494A4A0PT2d@00bA4A005A004
94A490E40R@3A00394A400M400=XA4@034@00bA4A008A08T4d@00bA4A003A0<T0T@00fQ4A002A004
94@T90i40VP018R/d=02[0;@00GAlO7Am@02l@ge0_T4m@Ci00GenOGen@07m@03nOGe00Ce00CadM7a
0oD02_WenOWenOGin_T2nP;i0oX00oWen@04m@03nO[i00;i00KenOGin_T2nP05mOWemOT01?D2n@;e
00GimOGel@04m@0<lOGelOGamO7edO7A0o401=7<[8P3[004S:b8S0:/18`018R<S:`4R09X1HP00fQ4
J002R006S8QXR6R80VP00dAXR003J0:<00=XA4@00d@00fQ4A00CA00494A4A0XT00=494@014@29094
12@2A0LT00=492@00d@49003A2@T00`T0d@;90U400<TA4@014@290Y40R@AA00394A400M400=XA4@0
0d@290i40fP3A09X00=4J6P00VP2A00494A4A09X00E4J6Q49002A0=X0T@016Q4J4@4J003A6QX00I4
00AXA4A40VP2A004J4A4A09X00=4J4@00VP000I400<TA4@014@00bA49006A00394A400E400<TA4@0
2d@2909400<TA4@01D@390m400<TA4@05T@012A492@6A08T1d@01BA4A4AX009400@TA2A40R@8A003
94A400i400<TA4@00T@00bA4900490Q412@6A08T00A492@T1D@2909400<TA4@03T@290A400DTA2A4
900/A0<T3T@5J0:<0j`2d0?e00?adOD03_D00oWem@02m@;i00CjnOGi0_D01?[enOT4m@03nOGe00?e
0_400oGad008m@04nOGinPCi00CjnO[j0oT8m@?i00?enOX00_T00o[im@08m@;i00OenOGelOGa00Ge
0m43m@03lOGa00;e00?ad=000]05[003R:b/00B/00><[:`00X`01Jb8J8QX00J80fP01DAXR8R<00:8
0VP2R0=X00B8S8QX18P2J1E400<TA4@02D@00bA4900490I40R@00d@T900390942R@2A0HT00=494@0
42@2A0DT1D@3909400<TA4@01d@00bA4A004A00394A400=400<TA4@01D@00fQ4A002A00394A400=4
00@TA4A40VP<A003J4A400M40VP3A0=X0T@2J0E400=XA6P00T@3J0Q400=XA6P01fP014AXJ6P7A0=X
0T@016Q4A8P3J0940FP00003J4A400=400DTA2A49002A08T00=494@00d@290Y400<TA4@00d@012A4
A4@290a400<TA4@00d@00bA4A005A00394A401I40b@014@T92@3A08T00A492@T0d@012A492@8A08T
1T@4915400<TA4@014@00bA4900390A41B@2A0<T0d@390M412@00d@TA00=A0<T1D@01BA4A4@T00A4
00=XA4@01D@00fQ4A00:A003J4A401140b@7A003J4A400E400MXA6QXS8R<00:/0l`00m3Ad@02d@03
mO7e00ge0_T3m@03nOGe00;e00?in_D00_T8m@;A0m000m7@m@02m@03nOGe00?e0_T;nP03nOGe00Ge
0_T01?GimOD2n@03n_We00We0_T01O[imOGA00Ge00KamM7AmO42m@03dOGe00;e0_402M7@d=3Ad<b/
R003S0J/00B<R8b80fP00hR<R004J0A400=XR6P01HP2J003A6R<00J80VP3A00394A4009400=XA4@0
2T@00fQ4A002A00394A400A40R@014@T92@6A0HT00E494@TA00490A412@3A0<T00A494A41R@2A003
94@T00HT0T@390940b@2A0DT1T@290a400=XA4@01D@00bA4A003A08T1T@00bA4A00;A00394A400Q4
0fP5A09X0d@2J0=40VP5A003J4AX00=40VP4A003R6QX009X3T@2J0A400AXR6Q40VP1A05X0FP000=4
00<TA4@00T@39004A2A4A08T44@00bA4A007A08T2d@390E400<TA4@014@291I412@00d@TA0029094
12@00d@T9004A00394A400E400@TA2@T1d@2919400<TA2@00R@4A0/T1D@290E40b@LA00394@T0094
0b@DA00594A4A6P01T@2J004A6Q4J0I400<TA2@00R@6A004J4A490=400=XA4@00d@2J003S:c@00;<
0Z`3d003mM7e00[e00?imOD00oD00oWem@02m@03nO[i00;j00?in_T02OD4d004dM3@l@Se0oT4nP03
nO[j00;j00CimOGi1?D00oWen@05m@03n_Wj00[e00?jnOT00oD2d@Ce00?amOD01OD00o7em@03m@04
dM3@c0:/00C<S8b<0XP018b/S:`3S003J8R800=X0X`2R003J8QX00=400=XA6P01HP016R8A6P4R003
J8R800:800=4J6P034@00bA4A00>A00394@T00A400<TA4@01D@390A40b@014@T92@6A08T0d@00bA4
A00390A412@00d@T900=90=40R@3A00394@T00DT4d@00bA4A007A00394A400U400<TA4@00T@00fQ4
A00?A004J4A4A09X00E4J4B8A003J0940VP00hQXA003J006A6QXR6Q40fP01DAXA4AX00E40fP9A005
J4A4A6P02T@000I400DTA4@TA002909400<TA4@00d@00bA4A00?A0<T00=494@024@2909400<TA2@0
14@00bA4A003A0<T3D@390I40b@3A00394A400DT24@390A412@9A00494A490I400AXA4AX1T@012A4
92@5A0DT0T@490A400@TA4@T0d@39003A2A400A400@TA2@T24@00fQ4A003A09X00=492@00b@FA08T
0T@00bA4A008A003J4AX00Q40R@2A003J4A400940VP4A003J4AX009416P018R/S<`2[003R:c@00?@
00?elOT01?D01?WemOT2m@03nOGe00Ci00KenO[in_T2nP05nO[imOT00oD01=7emM02c004d?7<c0?e
00KimOGimOX2n@Cj00Cin_Wi0oX3m@06nOGenOGi0_D00oWem@03m@;i2?D2n@03n_We00;e0]001O7e
mOGa00?e00?amOT01?D01m7elOG@c=000Z`01<b/[:`2R0F<00B8S8b<0XP2J007R8b8R6R8J003A006
J4AXR6R80X`00hQXJ002J003A8R/00>800=XR6P00VP=A00394A400Y400@TA2@T0T@00bA4900490=4
1B@3A08T00=494@01T@490940b@4A0<T0d@00bA490049003A2@T00TT0d@00bA4A002A00394@T00DT
14@00bA4A005A00394A400=400<TA4@05D@00bA4A008A00794A4A2A49004A003J4AX00U40VP2A09X
00B8A4AX14@4J003A6QX00E400=XA4@00VP00haXJ006A08T14@01FR8A4AX00M40007A00394A400DT
3T@012A4A4@290=400<TA2@04D@00bA4A005A00494A4A08T3d@00bA4A005A0<T1T@39003A2@T00i4
00<TA4@00R@2A00394A400=400<TA4@01d@00bA4A004A08T0d@490A400@TA2@T0d@00bA4A004A004
94A490U40R@4A08T3d@00fQ4900691A40R@00d@T900:A003R6Q4015400=XA4@02D@026R8J6R/R:c<
0j`4d003lOGe00ge00?in_T00_T01?Gjn_T4nP?i1OD01_7@dM3<[0;@00CAlOGi1?D00oWjn@02n@0:
n_WinO[in_Wjn@Se00?imOD01oD01OWemOGa00Ge00?jnOD00_D3d003dOGe00Ge00?amOD01?D2d@03
lM7a00;@1:`3S0:80Z`2S0>800><R8P00XP2S0B800EXA6QXR003J09400>8J6P00fP5R003[8QX00AX
3T@00bA4A00490]400DTA2@TA00290A40R@00d@TA002A0@T1T@00bA490039004A2@T909422@00d@T
90039003A2@T00XT1d@00bA4A0029004A2@T91I400<TA2@04T@00fQ4J00?A004J4AXJ09400AXA6QX
1T@00fR8[003J006A6QXA6R80fP00hQ4A005A003J4A400940fP2A003J4AX009X0T@00bA4A002J004
R6Q4J0Q4000;A00494A4A0<T0T@291=400<TA4@02D@00bA4A00=A00394A400=400<TA4@02T@00bA4
A004A00394@T00E40b@3A00494A4A08T2D@00bA4A002909400<TA4@014@012A492@5A08T34@390I4
0b@00d@TA004A08T2d@290E40b@BA0@T1D@390e40b@@A003J4AX00a40VP;A09X0XP01Hb/S:b<00:/
00KAd=7@dO44m@03nOGe00Ge00CimOWj0oT3nP03nO[j00;j00?imOT01_D01]7ac:c<d0;A00?amOD0
1?D00oWjnP02n@03n_Wi00?j00KimOWimOT>m@03dOGe00ke1=000oGam@03m@;A1_D01_7AmM7ed0B/
18P018b/[8`2R006[8R8R6R80VP2R003J8QX009X00=4J6P00XP00fQ4A002J003R6R8009X18P2J0:8
0VP01HQXJ4@T00M400=XA4@01T@00bA4A00?A00794A4A2A49007A0@T1D@2909400<TA2@00b@2A0DT
00=492@052@2A00394@T00=412@01T@T92A4909400DTA4A4J003A00694A494@T0T@390=400=XA4@0
1D@00fQ4A003A003J4A400A400=XA4@02T@3J003A6QX00A400=XA4@01D@016Q4J6P2A0=X00I4J4AX
R6P3A00394A4009X0T@01HQXA6Q4009X14@01VQ4A6Q4J09400=XA4@00T@00fQ4A003A0003D@00bA4
A003A00394A400U40R@8A00394A400A400<TA2@014@00bA4A00;A0@T0T@00bA4A003A00394A400a4
00<TA4@014@29003A2@T008T00=492@00R@9A08T00A492@T1D@69003A2@T00<T34@00bA4A00290E4
0b@9A08T2D@290A400<TA4@00R@CA0<T34@016PTA4@290A40R@00d@TA00=A003J4A400=400=XA4@0
4d@01FR8R8R<00:81J`01Lb/c=3A00ke0oT00o[inP06nP?i00?enOD00oD01?7AdM45d003lOGe00;e
00CimOGj1OT5nP03nOGe00Se0]400m3em@08m@03lOGe00We1M000o7em@02m@03d?Ge00Ge0_401=7@
dM03[0N<0Z`01Hb8[8R<00:80fP00hQXA003J003R6Q400=X0d@4J004R6R8J0:81fP00dAXJ00?A08T
5T@3909400=XA4@014@490E412@2A0LT00=492@05B@2A0HT0d@2909400<TA4@00R@5A09X14@290=4
0R@01D@TA4@T01M400<TA4@01D@00fQ4A004J09400=XA4@00T@00fQ4A002A005J4AXJ4@00VP00dAX
A002J0940VP00hQXJ005A09X0T@01HQ4A4AX00:80d@2J0940VP>A00000=XA4@04D@00bA4A006A003
94@T00Y400<TA4@00T@2911400AXA4A40b@014@TA2@MA0DT00=494@02d@39004A2@TA0DT24@29114
00<TA4@00T@00bA4A00290Y400<TA4@00d@2909400<TA4@00T@29003A2@T00e400=XA4@05d@290a4
00=XA4@05T@2J0Y40VP2R005[8b8R:`00h`2[003c:cA00ke00CimO[i1OX00oWjnP02nP?i1_D02M3A
lM3Ac:c@l@03m@?i00[jnO[jnO[enO[i0_X00oGim@03m@;a00?@dOD00_D2d004dOGen@Ge00C@dO7A
1OD00m7em@02d004lM7Ad@Ce00?amOT01_D01=7ad=42d0F/00B<[8b<0Z`00hb8R004R003J8R800:8
0VP3R09X00=4J6P00fP028QXJ6R8J8QX0XP016Q4J6P2A003J4B8009X0T@00bA4A006A0<T54@00fQ4
A006A09X14@01BA4A4@T009412@01D@T92A400LT0T@49003A2@T009400<TA2@02R@2A0@T1D@390A4
1B@8A00494A4A08T00=494@00T@00bA4A002A00394A400U400=XA4@014@290I40VP00dB8J002J094
0VP3A005J4A4A6P01T@4J003A6QX009X0T@00fQ4A008A003J4A400AX0T@00fR<J006A003J4A400E4
00=XA4@00FP000A40b@=A00394A400E40R@BA00494@T90=40R@2A00694A494@T0d@29003A2@T00@T
1T@2911400<TA2@012@7A00494A490E412@00d@T900590=40b@3A00494@T919400@TA4@T0T@012A4
92@4A08T1T@290E40R@2A00394A400e400<TA4@054@00bA49004A003J4A4009400=XA4@024@00fQ4
A002A09X6D@026R8R8b8[8b/0X`2[0;@00?AmOD01oD00oWem@03m@?i3OX00oWem@05m@?@00B/c=3a
0_D2nPKi00CjnOWi0oX2n@Ge00CadM7A0_45d0;e00?ad=001=001Jc@mM7e00Ca00?ed?401oD2l@Se
0_401=3Ad<`4[004S:b8S0:/00><R8P018P016R8R8P2S0:816P2A0=X00=4J6P046P00dB8A003A08T
1d@491E40b@3A00594A4A6P00T@490=41b@00d@T900<9003A2@T008T0T@B90A40b@3A0<T14@00bA4
9007A00394A4009412@5A0<T3D@012A492@7A09X0hP2J003A6Q400i400AXA6QX14@00fQ4A00;A004
J4A4A0=X0d@01FQ4A4AX00m40006A08T1D@012A492@9A00494A4A08T2d@00bA4A004A08T14@29003
A2A400M400<TA4@014@290I400<TA4@044@00bA4A00290i400<TA2@012@5A08T0d@390E40b@2A003
94A400<T1T@00bA4A002909400@TA4A40R@;A00594A4A2@00T@00bA4A003A08T3d@00fQ4A00AA004
94A4A08T3T@00bA4A002A003J4A401i400=XR8P00hP01Xb8S:b<c0;@00?AmOD01_D00oWem@03m@Gi
0_X00oWjnP08nP04nOGen@;e00GAd=3@l@02d0;e0oT00o[inP05n@?j0_T00o[in@03m@05lM7emO40
0_D01m7edM3<d?400]001]7<d<b/c0;@00?ad?400]400o7em@0Am@05lM3@dM000Z`3S005[8R<[8`0
0Z`3R0:<00EXR8b8S004R003J4AX00AX0XP4J004R6R8R0AX00F8J8QXR005J0m40R@5A00394A4008T
14@290Q400<TA4@00T@00fQ4A005909412@3A0hT0d@00bA490029005A2@T94@03b@5A00494A4A0<T
14@00bA4A003A08T0T@00bA4A002A0<T24@012A4A2@<A00394A400E400>8A6P00fP8A004J4AXJ0I4
00AXA6QX2D@00fQ4J003A003J4A4009400AXA6R80VP2A09X0d@016Q4A6P<A00000=494@00d@00bA4
9007A08T00a494A494@TA2A494@29006A2A494@T2T@290I400<TA4@03d@291M400DTA2@TA00490a4
00DTA2A49004A00394A4009400DTA4A49008A08T00E492@TA0039003A2A400E400<TA4@01T@39194
00<TA4@00d@00bA4A004A08T6d@00bA4A002A00394A400I400=XA4@01T@016Q4J6P3A003J4A400E4
0VPAA0=X0XP01Jb8R8b/00:<0Z`00m3al@0;m@Oi2oX01OWjnOGi00?e00G@c=3@l@02d@?e00?jnOT0
1?X3n@;j1_T9m@03nOGe00;e1]000jc<[002d0;<0]401?7AlO4<m@04nOGin@?e00O@dM7Ad:b800B<
00S<[8R/R:b<J0:80X`3R003[8b800:800=XA6P016P018QXJ4@3J004A6R8J09416P00dAXJ002J154
12@2A00394A400=400@TA2A412@3A08T1d@9909400DTA4@TA00N9003A2@T00<T00=492@00T@=90M4
1b@4A0<T2T@490I40R@9A005J4AXA6P00T@00fQ4A00?A09X0T@2J0U400=XA4@02T@3J0i400EXA4A4
J004A0000T@01BA4A4@T00m400<TA4@00d@690a40R@00d@TA004A00394A400E400<TA4@01T@00fQ4
900490Q400<TA4@02D@49003A2@T008T00=494@02D@012A4A2@9A00494A4A0<T0T@00bA4A005A0DT
00=492@00R@?A08T0d@00hQXA007A0<T14@016Q4A4@290E40R@5A003J4A400E400<TA4@00T@490I4
00<TA4@024@00fQ4A008A003J4A4009400=XA6P00b@5A003J4A400a400<TA4@00VP01TAXJ8b8J0:<
0Z`01/c@dM7el@?e00CimOGi0_D6n@Wj00?in_X00oX00oWjm@02m@03lM3<00;@00?ad?400_D3n@Cj
00?in_D01?X4n@03n_We00We00CimOGA0]001Lb/dM7<00:/0]000lcal@02m@03lM7e017e00Gad?7@
d@02[0><00R8[=2/R8b8[0>80X`00hR/R006R0=X00>8J6P00fP00dAXA002J003A6R800E400J8J6QX
A6P@A0<T00=492@02D@012A4A4@390940R@014@TA4@290=422@3A00394A401dT00=492@01B@2A08T
00=492@01b@00d@T9005A00394A4009412@4A0<T00=494@00d@00fQ4A002A00394@T009400<TA4@0
3d@4J003A8QX00m400AXA6R<0fP00dAXA00IA08T0T@016Q4A6P3A003J4A400=40FP1A0540006A003
94A400a400<TA4@014@2909400@TA4@T2d@390Q400DTA4A4900<A00494A490M400<TA4@02d@49004
A2@TA0HT0d@290]400=XA4@01T@01RA492A4J0M40b@4A00394A400e400<TA4@00T@00jb8A004A0DT
0d@00bA4A004A00494@T90=400<TA4@044@00bA4A002A003J4A400A400=XA2@01d@00bA4A007A0IX
7D@00fQ4J004J0:80Z`01]3<dO7Al@Se00CimOWj0oT?nP?i0oD00m7@d002d003dO7e00;e00?jnOX0
2OX6n@Oe00?imOD01?D2d@07d:c<dO7@[002c0;@0_44m@03lOGe00oe00OAd?7@dLb/00:80X`01hR/
[8R<R:`00XP2S003R8b/00F80fP00hQXJ005J003A6QX00AX00>8J4@00d@2J003R6Q400E40VPIA004
94A4A0<T00=494@01D@2909400<TA2@01R@6A0@T00A494A44B@00d@T90039003A2@T00LT00E492@T
A0049003A2A4008T1D@00bA4A002A0<T1D@29003A2A400M400=XA4@05D@2J003A8QX009X0T@00fQ4
A009A004J4AXJ0:80T@01VQ4J6Q4J0a40VP00dAXA002A004J4A490A40VP01DAXA4AX009400=XA4@0
0d@000M400<TA4@01T@01bA4A4@TA2@00T@00bA4900290=40R@<A08T0T@00bA4A003A00394A4008T
14@00bA49009A00394A4009400<TA4@034@012A494@290E40b@00d@TA004915400<TA2@00b@2A003
J4A400E412@3A0<T00A494@T64@01BA4A4@T00Y400<TA2@03D@00bA4A003A08T1T@00fQ4J003A08T
1d@00bA4A008A09X00=4J4@03d@00bA4A00;A003J4AX009400YXA6QXR8b8c=7a3OD2nA;j00?enOD0
0_D00m7@d002d003mO7e00;e00?in_X02OX02?WjnOWjnOGi0oD01OWjn_Gi00Ke00KAlM3@c=42d003
[=3A00;A00GamOGel@0Am@07dLc@c=2/S002R0><00F/S8R<R002[006S:b<R8b/18P00hb8J003J094
16P2A09X00>8J6P01T@5J0E400=XA4@02d@00bA4A009A08T0d@690A41B@00d@T9002909400<TA4@0
0R@00d@TA00690=43R@2A0DT00=492@032@00d@T9002909400<TA4@014@01bA4A2A494@00b@4A0<T
4D@29005A2@TA2@02T@2J09400EXA4A4J00?A003J4A400Q400=XA4@02D@00fQ4A00<A003J4A400E4
00=XA4@00d@0009400DTA2A49005A00394A4009400<TA4@00b@2A0<T4D@00bA49002A00394A400A4
00<TA4@00T@012A4A4@290m400<TA4@01D@00bA4A002A0DT2D@01RA492A490E400<TA4@02d@29094
0b@6A00394AX00=40R@7A0<T4T@00bA4A006A08T:4@01FQ4A4@T02140b@5A08T4T@026R8J6R8S:c<
0]400oGAl@03m@03lOGi00;e00?jnOT01?X00oWjnP0<nP03nOGe00;e0m400m3el@04m@04nO[jn@;j
00?in_X00_X00oWjnP02n@03mOWi00Ci0_X01OWjn_Wj00Ke00CAd=3a0]002<cAdM7@dOGa0_D00o7e
m@0>m@03dM3@00;@0Z`016R8S8`5R006S8R8R:b80VP6R003J8QX009X00A4J6R80VP2A0EX1D@5J003
A6QX00I400=XA2@00T@29003A2A400a400=XA4@00T@790A40R@00d@TA003A08T00A494A40R@00d@T
90049003A2@T00943b@4A0@T00=492@01R@00d@T900<90940b@4A0HT14@290Y400<TA4@01d@290]4
00AXA4A40VP7A09X1T@2J09400=XA4@03D@00fQ4A004A003J4AX00=400=XA4@01T@00fQ4J003A003
J4A400E4000HA00394A401940R@3A08T1T@00bA4A00?A003J4A400E400<TA4@00T@290I40R@2A003
94A400=400<TA4@00T@390I40R@3A00394A400I40R@LA0<T3T@00bA4A006A08T9D@00bA4A005A08T
1d@00fQ4A00:A004J4A4R0Q41B@EA0=X00J8J8R<[=42d003lM3e00Ge00GimO[jn@0BnP05nO[jnOX0
0oD00m3<d002d003mO7e00;e00Gin_Wjn@07nP;i00GjnOWim@03n@Oj0_T6m@05dM3@dOD00]001?7@
d?D2l@Ge00?imOD00_D00o[el@03m@;a0]002<c@[<b<R6R80X`5R004S8R8S0:800=XR8P00hP00fR8
J007J003R8aX00941VP3A0EX00B8A6QX1d@016Q4A4@29003A2A401A40R@<A0@T0T@490=412@00d@T
9002A0<T00=494@01R@00d@TA006A08T00=492@02b@00d@T90029005A2@TA2@00T@00bA49003A0@T
1T@290i40R@4A08T24@00fQ4A002A004R6Q4J11400=XA4@01D@00fQ4A008A003J4A400=400=XA6P0
14@00fQ4A003A004J4A4J09400N8A4B8J8QX00E40004A00394A400E400<TA4@00d@00bA4A003A003
94A400]400DTA4A49002A00394@T00M40b@9A00394A400i400<TA4@00d@00bA49005A00394A400E4
12@2A08T3d@2909412@9A00394A401140b@6A08T0T@00bA4A00290i40R@@A00394A4009400<TA4@0
0d@00bA4A002A00394A400A400<TA4@05T@00fQ4A007A00494@T91A41FP2R0:/00G@c=3@l@08m@;i
5_X2n@;e0_43d0?a1?D2nP03nO[j00;j0_T2nPKi00GjnO[jn@08nP;i1oD00o7el@02l@04dO7em@;a
3oD00o7Ad003d005c=28R6P00XP00hb8J005R003J8R800>800EXS6QXR004J003R6QX009X0hP00dAX
J003J003R6Q4009436P8A0@T84@01BA492A400TT0T@490A43B@00d@TA006A08T0T@99005A2@T94@0
12@00d@TA003A0@T0d@29006A2A4A2A40b@6A08T14@012A4A2@4A08T0T@00bA4A003A003J4A40094
0VP:A004J4A4J1Y416P4A003J4A400A40VP7A0EX14@1J00000=4J4@00d@00bA4A00:A00394A400Y4
00<TA4@00d@29003A2A4008T00=494@00T@290=40R@>A0DT24@00bA4A004A00794A4A2A49007A0DT
1D@290U41B@00d@T9003A08T24@00bA4A002A00394AX00A40R@6A00394A400TT00=492@03d@290m4
0R@4A00394A400940R@5A0@T0T@00bA4A002A00394A400940b@DA003J4A400]40R@<A09X0XP00hb/
[002d004lM3al@Se00?in_X05OX00oGim@03l@CA00K@mOGenOX2n@Oj00?in_T00oT00o[in@0;nP;i
00?enOD03?D00o7Ad@04m@03lOGe00Oe00?ad=001Z`7R0><00>8[8`00XP00fR8J003R0AX00>8J8P0
0fP01HQXR8b800=X00A4J4AX1d@3J003R6QX00EX0T@00bA4A003A08T1T@390Y400<TA2@00R@5A08T
00=494@00R@2A18T00=492@02R@014@T94@790=42R@2A0@T00A494@T14@00bA49003A0LT0T@00bA4
A002A00394@T008T0T@01RA4A2A490M40R@7A08T00A494AX0d@00bA4A002A003J4A401540VP8A003
J4A400I400AXA4AX1d@00fQ4A003A0=X1D@1J0002d@290M400<TA4@00d@00bA4A005A00494A490M4
00<TA4@014@012A4A2@4A00394A400=400<TA2@00T@29007A2@TA2A4900:A00394@T00=40b@00d@T
A003A0@T0T@3909400<TA2@00d@00bA4A00990A40R@3A003J4A400<T2T@29003A2@T00<T0T@49094
00DTA4A49004A003J4A401a400<TA4@00T@026Q4A4@TA2A40R@2A0<T0T@00fQ4A00HA00394A40154
00@TA4@T34@026R8R8R/d?G@0_D00m7em@04m@03nOGj01;j00?in_X00_X2n@Ce00?amM000m03m@03
n_Wj00Wj0oT01oGinOGin_T02OX00oWen@07m@03nOGe00Ce00CamO7a1?D00o7em@03m@04lOGAl@;@
1Z`018R<S8P2S003R:b800:/00[@R6R8S8QXS=2<1FP:R0EX00=4J4@00T@00fQ4A006J003A6QX009X
0d@00bA4A003A0DT0d@290E40b@7A00394A400=41B@00d@TA008900302@T00XT0T@99003A2@T00PT
00=494@02R@2A0/T00=494@014@3909400<TA2@01T@00bA4J002A00394@T00Y40R@4A09X0T@29003
A2A400Q40R@5A004J4AXA09X0d@00fQ4A004A003J4A400m400EXA4A4J006A09X34@1J0004d@00bA4
A003A08T1T@490A400HTA4@TA2@3A0<T14@012A4A2@2A00494@TA08T14@29003A2A400]40b@6A0@T
00E492A49004A0<T00=492@00R@00d@TA0029003A2@T019400@TA2@T0T@29003A2A400I400<TA4@0
1T@012A4A4@290E400<TA4@01D@391E400<TA4@014@00fQ4A00290A40R@00d@TA010A09X0XP01Hc@
d=3A00[e0_TFnP;i1oD01M7@dM7a00;e00?in_X00_T7nP;i00GenOGen@02m@04nOGen@Kj00?imOD0
1oD00oWem@08m@03lOGe00Oe00?amO400]42d007c:c<[<b/R002S003R:b/00:/00N<R:b<J<b/00MX
00B8J8R<0hP00fR/[002R0=X00E4J6Q4J005A09X00A4J6R81fP6A0<T0d@00bA4A002A00394A40094
00@TA2@T1d@00bA4A005A0HT00=492@02b@2A0LT00=494@01b@2A0LT00=492@032@00d@T90089003
A2@T00I40b@00d@T9008A00394A4011400<TA4@01D@01RA494@TA08T1D@290Q400=XA6P01d@2J0e4
00=XA4@00d@2J0e400=XA4@01T@1J054000FA00494@T90M40b@3A00494@T90M400<TA4@014@00bA4
A007A00394A400a400<TA4@00d@390M400<TA4@00T@01bA4A2A494@01b@014@T94@2J00494A490a4
00<TA4@00T@29003A2A400940R@BA08T1d@01BA494AX008T14@290A400<TJ4@00d@00fQ4A002A004
94A4A0<T2D@01RA4A4AXA08T3D@00bA4A005A00394A400m400=XA4@064@3J0>800K@[<c@dO49m@03
nO[j01Gj00?imOD01?D01?7AlOD2l@;e00?in_X01OX01?Wjn_X7n@03mOWi00;e1?T2nP;i3_D00o7e
m@03m@;a2?D01=7elO42d0:/00K<[<cA[8P2[003S:b/00F/0X`00jb<J002R003J4AX00F80X`3R003
[8b<00:80fP2A003J4A400E400=XA6P00fP00dAXA002J0I40R@4A0<T0T@29003A2A400@T3d@69094
22@00d@T90029003A2@T00DT00=494@012@00d@TA0099003A2@T00<T0T@49003A2@T00/T0T@290e4
00=XA4@04T@01FQ4A4@T00U400<TA4@04T@3J0M40fPCA0=X2T@3J0A400AXA6R80FP001A400<TA4@0
0b@4A003J4A4008T0T@00bA4900;A00394A400940b@014@T92@<A00594A4A2@024@291141R@01D@T
94@T00i400<TA4@02d@290A40R@BA00394@T00M400DTA4A49003A00394A4008T0T@390A400=XA4@0
0T@00bA4A004A00394A400]400=XA4@02D@2J09400<TA4@00T@291=400=XA4@054@00fQ4A002A09X
0hP2[004d<c@d0Oe0oTGnP;i1_D00o7em@04m@03nO[j00Wj00?in_T01OT:m@03nOGe01?e00?AmOD0
1oD01O7edM7@00:/00K@[:b/c:`2S004[8b<c0>/18`2R09X00B8J6QX0XP2J0:<0XP016R8S:`4R003
J8QX00=X14@3J003R6R8009X00A4J6QX0T@00fQ4A003A00394A400a400HTA2@TA2@:A0HT00A492@T
0d@29004A2@TA0PT0T@:90=41R@01T@TA4@TA0@T0T@290=442@8A0<T5D@00bA4A00iA003J4A400A4
00=XA4@00VP6A007J4A4A6Q4J005A0AX0005A00394A400E400<TA2@01D@01BA4A2A4008T0d@00fQ4
A008A00394A400]40b@00d@TA00;A0@T00=494@014@290A400DTA4A4900;A0HT00=494@034@39003
A2@T00I40R@4A00394@T00Y400=XA4@02T@00bA4A007A00694A4A2A412@014@T94@490m400@TA4AX
0T@2J0Q400AXA4A40R@01dAXA4AXA6P01T@390940VP3A09X9d@016R8R8`3[003c=3A00Oe6oX8m@04
lM7ed@?e00?in_T02_X4n@03n_We00Ke00CAlOGa1OD00o7em@05m@03lOGe00;e00CadOG@2oD02_7@
c=2<d:b<[8`3R0:<1j`01Hb/[:aX00>80VP018QXJ6P9R003J8R800EX0d@00fQ4A003J005R6QXJ4@0
1VP>A08T14@590941R@2A0LT0T@L9004A2A4A0<T00=492@042@00d@T900890940R@00d@TA00290A4
00<TA4@01D@00bA49005A00394A4009400LTA4A494@T00=400=XA4@01D@00fQ4A005A003J4A40094
00<TA4@03T@00fQ4J006A003J4A4009400=XA4@024@2J09400>8J4@01T@016Q4A2@5A003J4A40094
0002A00394@T00U40R@00d@TA004A08T00E494A4900<A0@T34@00bA49006A00394A4009412@7A003
94A401=40R@00d@T900390i41R@5A00494@T909412@:A003R4A400A422@9A00594A494@012@00d@T
900590Q400<TA4@02T@00fQ4A007A003J4A400A400AXA4AX2D@00bA4A00BA0@T1D@00bA4A00:A003
J4A400A40fP00hR/S002d003dOGe00Ke0_TInP03nOGe00Ke0]43d0?e00?in_X03_X2n@Ke00CAlM7a
0m400o7em@0<m@05lM7AmO402OD2l@09c8b/d:b8S=2/00><1Z`3S0>/1HP016R8J6P2R0AX0hP2J004
R6QXA0AX1D@8J0=400=XA4@00d@290E40R@2A00394A400A400<TA2@00d@69004A2A4A0DT00=494@0
6b@00d@T900>90942R@4A0@T00A492A41B@00d@TA004A00494A4A0<T1T@29003A2@T00M40R@5A003
J4A400U40fP7A003J4A400AX2D@01FQ4A4AX00A400=XA4@00T@00fQ4A004A004J4A4A0=X1D@2J0I4
00=XA4@014@000M400<TA4@00R@014@TA2@8A0<T00=494@00d@290I40R@00d@TA008A00394A40154
0b@5A00394A400M400<TA2@02T@39003A2A4008T3d@29003A2@T009400<TA4@01d@00bA4A007A003
J4AX00U400<TA4@00R@@A0<T00=492@00T@00bA4A00>A003J4A400E400=XA4@02D@00fQ4A007A003
J4AX01]40R@4A08T4T@3J0:80X`01<c@dM07m@03nO[j01Sj00?imOD01_D2l@;@00K<d?7amOTBnP?i
1_D00m3Ad@03l@?A1?D2l@06mO7elOGa2oD2d@07[8b/d:b8[002d003[8b/00:/00><[:`00j`2S0:8
00B<R8QX1hP5J003R6QX00=X0d@2J0E400=XA4@00VP00dAXJ009A08T1T@29003A2A400I400<TA4@0
0d@29004A2@TA0<T00=492@00T@290=41B@00d@T90089005A2@T94@01B@00d@T90029003A2@T00<T
0T@59003A2@T008T00=492@00b@4A00494@T90=40R@014@T92@=A08T0T@01FQ4A4@T009400<TA4@0
1T@012A4A4@2909X1d@016Q4A4@4J0E40VP014AXJ6P6A004J4A4J0m400=XA4@00d@016Q4J4@3J003
A6QX00=400=XA4@00d@00fQ4A002A05X0D@1A0001d@00bA49002A0<T00=494@01T@59003A2A40094
0R@4A08T24@01FQ4A4@T009400<TA4@02d@01RA492A490e400@TA4@T34@290941B@6A08T1D@290E4
00<TA4@014@01RA4A2A4919400DTA4A4900:A08T1T@290=400<TA4@03T@00fQ4J005A0=X2d@01FQ4
A4AX00=40fP5A003J4A4019400LTA4A494@T01M40VP2R006S:b/[=3A1oD00oWjnP0HnP03nOGe00Oe
00?adM400]000lc@m@02mA?j0oT4m@03lOGa00;a00?elM400_44m@03dOGA00;a2oD01_7edM2/R0:/
0XP01Hb/[:b<00J/0]001Jb8R8QX00>800EXR8b8S003R09X00B8J8R80VP00hQXJ004J0E40fP00dAX
J003J0A400AXA4A412@6A0<T00=492@00R@2A08T0d@49003A2@T00<T14@490A41R@2A0HT00A492@T
0T@99003A2@T00<T00=494@022@00d@T900590=41B@2A00594A4A2@03T@00bA4A004A08T00=492@0
3T@00fQ4A007A09X0T@016Q4J6P4A005J4A4A6P01D@00fQ4A003A003J4A400m400EXA4A4J002A09X
0T@2J0I400=XA4@00d@016Q4J4@1J0000d@00bA4A007A00394A400M40R@4A00394A400A400@TA2@T
1d@2J0E40R@5A00394A400E40b@5A00494@T90Y40R@@A00394A400m40R@4A003J4@T00e40R@>A08T
0T@00bA4A003A00394A400940R@;A08T0T@012A4A6PCA003J4A4009400=XA4@01T@00fQ4A002A09X
00A4J4AX2T@01FQ4A4@T00=40VP4A08T1D@00bA4A00FA009J8R8R8b8[=7a00Ce00GimOGjn@0HnP03
nO[e00[e00OadM7@c=3A00;e5OX00oWem@05m@GA0]001m7alM7@dO403?D01=3ed=02S0>80X`01Jb<
R8c<00B/00C<d=3a0Z`4R003J8R800J800=XR8P00XP3J0>800=XA4@01d@00fQ4A003J0Y400<TA4@0
2D@390]41b@00d@T900490940b@00d@T900490=42b@00d@T9006909422@00d@T90039003A2A400HT
00A492@T0T@00bA49002A0<T0T@00bA4A00BA00394A400940b@2A08T00=494@014@00fQ4A002J314
00=XA4@00d@2J003A6Q400U40fP5A003J4A40094000DA00394A400E40R@5A0@T9T@390=400<TA4@0
1D@390M400<TA4@014@390=40R@3A08T0d@491=400<TA2@00d@00fQ4A009A0<T0d@2909400<TA4@0
64@29003A2A400A400<TA4@00d@00fQ4A002A004J4A4J0=400=XA4@06d@00bA4A002J2940VP014AX
R8P2S004[<cal@Ge0oTJnP;i3?D02?7@d<c@lOGi4oX3n@Ge00Cad=2/0]401M2/d=3A00C@00?AmOD0
0oD00oWem@03m@05d?7@[8`018P01Hb/[:c<00B/00C@c:c<0]000jb8R003R003J8QX00F800AXA6R<
18P2J005R6QXA6P01d@4J0E400<TA4@00d@01BA4A4@T00Q412@3A003J4A4008T0T@79003A2@T00`T
1D@00fQ49007909400<TA4@00b@00d@T90049005A2@T94@02B@3A0HT00E492A49002A00594A4J2@0
0T@291M40R@00d@T9005A00394A400M400AXA4AX34@00fQ4A00>A00394A400E400=XA4@02d@2J0]4
00EXA4A4J009A0003d@00bA4A002A00394A400E400<TA4@01D@00bA4A004A0=X34@290E40VP8A003
94@T008T2D@01BA4A4@T00A40R@00d@TA003A00394A4008T0d@00bA4A002A08T0d@290A400<TA4@0
1d@00fQ4A004A00394A400E400<TA4@01D@00bA4900291]400<TA4@00T@3909400DTA4A4900>A003
J4A4019412@4A003J4A400A400=XR6P016P4A003J4A401U400=XA6P00XP3[003c=7e00Ce00?jnOT0
7?X02?WemOWenOGi1_D01m3<d<cAmOT05OX2n@Ge0]001Jc@d=2/00C@00C<[<ca1?D00oWem@03m@04
lM7A[0><18P00jb<S002c007d:c@d=6/c002[0:<18P00hb8R002R003S8R8009X1XP00dAXJ005J0I4
0fP00dAXA007A00394A400940R@:A00394A400A40b@00d@T90049003A2@T00HT0T@690Q41b@2A08T
0T@:9003A2@T00/T00=492@01B@00d@T900590=400<TA2@00R@00dAXA009A003J4A400Q40R@00d@T
A005A00494A4J0I400=XA4@00VP4A004J4A4A09X00=4J6P01D@2J0Q400<TA4@01d@01FQ4A6Q400IX
1D@00fQ4J003A007J4AXJ4AXA002J0Q4000:A00394A4009400@TA4A40R@4A08T00=492@01T@01BA4
94@T00=40VP00hQ4A004A00594A494@00R@2A00394A400A400AXA4A40R@00d@T900290U400<TA4@0
1D@290E40b@2A0HT14@2929400<TA4@014@691E400<TA4@00T@29003A6Q400Q400<TA4@00T@00bA4
A00=A09X3d@49003A2A400Y41FPFA00394@T00Y400>8S8`00Z`00m3am@05m@?i6_X8n@Oe00Oac=3@
dO7e00;i4oX00oWem@04m@05dM2/[<`00Z`02Lc@d=2/c:c<d@02l@Oe00Cad=2/0hP00hb8R002R006
[8b/[=3<0]000o7<d002[003S8R<00:800B/S:b<0VP00hb8R002J003R6QX00:800=XA4@00T@3J0M4
00=XA4@02D@29003A2A400a400PTA4A494@TA08T00=492@00b@00d@TA00490940R@2A0LT14@00bA4
A0059003A2@T009400<TA2@022@00d@T900G90940b@2A0<T00A494@T2T@00bA4A009A0@T00A494@T
1D@00bA4A002A00394@T00M400@TA6QX0T@2J1m41VP7A003J4A400=X00=4J6P00T@00fQ4J002A004
J4A4A09X0D@000m40R@4A00394A400A400<TA4@02D@00bA4A003J005dFQ4A6P01D@69003A2A400Q4
00@TA2A40b@3A00694A494@T3d@00bA4A002A00394@T008T1T@390E400<TA4@00T@290m40R@4A08T
1D@590]400=XA4@03D@00bA4A00>A00394A4009400AXA4A40VP>A003J4A400A400=XA4@03T@2J003
A6QX009X6d@00bA4A003A007J8R8S:c<d007m@?i7OX2n@03n_We00;e00?imOD00oD00m7@d002d003
lOGe00;i4?X2n@Ke00Cac:b<0Z`01Hb/[=2/00:<0Z`00lc@m@06m@;a0j`00fR8R002S0:800><R8`0
0Z`00m3<d003d006[8b/S:b<0XP3S003R6QX00:800AXR6R80VP00hQXJ00IA0@T0d@012A492@6A08T
1d@00bA4A0029004A2A4A0DT0T@49003A2@T00HT0T@69003A2@T00HT0T@89003A2@T01PT00=492@0
0d@290m400<TA4@01d@00bA4900390Q400<TA4@00d@01BA4A4AX00Q400=XA4@01T@00bA4A004A08T
1D@01FQ4A4@T00Y40fP00dAXA002J0=40VP01TAXJ6Q4J0A40VP6A0=X000?A00394A4008T00=494@0
1D@00bA4A00<A005J4AXR6P02d@490m400<TA4@014@00bA4A00?A00394A400=400<TA2@00b@5A0<T
1D@00bA4A00391140R@4A00394A400A40b@JA00394A400]400=XA4@014@00bA4A004A09X00>8A6P0
0T@290E40b@=A003J4@T00Q40fP00hQXA002A003J4A401a40fP2R007[=3@mOWen@02m@05n_Win_T0
7?X01OWjnOWe00Ci1OD00o7@d002d00;mO7enOGin_WjnOX00_T2m@;i00CjnOWi1oD02M6/[:b<[6R<
[002R006[8b<[8b/0oD02o7emOGAd:b<[6R800><00F/R:b/S002c0O@1:`01Xb8R8R<[0>800B<R6QX
1HP00fQ4A002A003J4A401=400@TA2@T1D@590E400<TA4@00d@012A4A2@2A00694A4A2A40R@2A08T
00=494@022@5A0@T0d@00bA490039004A2A4A1hT00=492@00T@29003A2A4008T2D@290Q400<TA4@0
14@490i400<TA4@02D@00fQ4A007A00394A400A400<TA4@03T@2J09426P4A0IX0d@2J006A6QXJ4AX
0d@3J00000=494@00d@01BA4A4@T00E41B@6A00394A401]41R@:A08T24@00bA4A002A00394A400a4
0R@3A0@T1T@01BA4A4@T00E40R@00d@TA007A08T0d@790Y40b@00d@TA002A00394A400A40b@8A003
94A4019400IXA4A494@2909400EXR8b8J004A0<T14@00bA4A00=A0<T2T@016Q4A6P;A00394@T0154
16P01HR<[=3A00?e0_T01OGinOGi01gj00?in_X00_D2n@03n_Wi00;i0_D2d@;@0Z`00lcAm@04m@03
nOGe00oe0_42[0:81VP2R003J8R800:/00S@mOGAlOGad0:/00F<[6R8S002[003S8R800B/0]001=7@
d=03[003S:b<00>800><[8P00XP01Jb8J8QX00:800=XR8P014@00fQ4A00CA08T24@00bA4900;A0DT
00=492@00R@3A0TT14@5909400<TA4@00b@014@TA4@E9003A2@T00<T00=492@00b@00d@T90029003
A2A400=40b@3A08T1d@3909400<TA4@00T@00bA4A00IA003J4A400M400=XA4@014@00fPTA00=A004
J4A4A09X0T@012A4A4@2J003A6R800EX00=4J4@00T@2J004A6QXJ0=40VP00dAXJ009A0004d@00bA4
A002A08T6d@00bA4A003A00394@T00A400DTA4A4900:A00394A400=40R@?A00394A400940b@9A003
94A400=40b@6A00494A4A08T0d@49003A2A400A400<TA4@00T@490M400<TA4@00d@00bA4A004A08T
5d@00fQ4A002A00394A400EX0d@01FQ4A4@T00m400=XA4@04T@016Q4A6P:A00494A4J0a40VP01DAX
J6R800:/00?@mOD00oD3n@03n_Gi01[j00?in_X00oX3n@;j0_T01O[imOGa00;A00C@[:b/0]000m7e
m@0Bm@;A00C@[8R816P00dAXA003J006R8b<[=3e0]42l@08mM2/S<b8J8`2[004S:b/S0:/00[<d=3e
lM3ec=280j`018b8S:`3R005S8R8J8P00VP018QXJ8P2J0A400=XA4@02D@00fQ4A006A00394A400=4
00<TA4@02T@012A492@7A08T00A494A40b@00d@T900490I432@00d@TA002A0`T00=492@022@2A003
J2@T00<T0T@49003A2A400@T1T@290E40b@<A00394A4009400<TA4@02d@00fQ4A00FA003J4A400Q4
1FP014AXA2@2A003J4A400=X00>8J8P00VP00haXJ006A09X00>/J6P00VP014AXJ4@3J0I40009A08T
2D@690e40R@>A00394A400Q400<TA2@00b@00d@TA004A00394@T00E41R@;A08T00=492@012@6A0<T
1D@390I400@TA4A41R@4A08T0d@2909400<TA4@00b@DA08T44@00fQ4A006A00394@T00A40XP2J0E4
00=XA2@01T@390i40R@7A003J4A401a400IXA6QXA8P2J0:800F<[?7en@02m@;i00CenOWe0_THnPCi
1OX01OWjn_Wj00;i0oD2l@03d:b/00>/00C<d=7@0]400m3Am@02m@08lM7ad?GamO43d@04d:b8R0MX
0d@2J0:<00K<dM7ed?D2l@05d8b/R8`00XP2[003S:b/00>/00G@c=7Am@04d004[8b/[0>800>/R6P0
0hP00jb8J003J0:80Z`01FQ4J4AX00E400<TA4@01d@390A40R@2A0<T00=494@01T@01BA4A4@T00Q4
0R@4A0LT00=492@00T@00bA4A0059003A2@T00@T00=492@00d@290=43R@00d@TA0039003A2@T00TT
0T@79004A2A4A08T1T@290I400HTA2@TA2@2A00394A400=40R@>A00394A400Y400=XA4@00d@00fQ4
A00:A0AX1T@2J0=400IXR6QXS6P4A006J4A4A6Q416P4A003J4AX00M40FP000M400<TA4@01d@012A4
94@5909400<TA4@02D@00bA4A005A00494A4A08T00=494@01D@00bA49004A0@T14@00bA4900290=4
0b@4A00394A400=400=XA4@00d@00bA4A002A00394@T00I40b@6A08T2T@00bA49004909400@TA4@T
14@590A400<TA4@03D@290=40R@GA08T1T@2J005R6Q4J4@00VP00dAXA007A08T34@390Q400=XA4@0
0d@00bA4A00HA003J4A4009X18P00jcAm@02m@Ci00CenOWi6OX02?WenOWenO[i1?X00oWjnP02n@Ce
00Cac<c<2J`00lc@d@08d006[<b/S:b80VP01hQXJ6R8J8P00VP00dAXJ002R003[?Ge00?a00GAlM2/
S003R0B/00B<[:b/1M000m7@d002d004[<b<[0>800F/R8R<R002S003R8b800:800=XR8P01FP7A003
94A400I40b@2A00494A4A0LT0d@00bA4A0029003A2A400E40R@00d@TA006A0@T00=492@00R@3A0DT
00=494@03R@2A00394@T00`T00=494@00b@014@T94@C9004A2@T90940R@014@T94@490940R@00d@T
A002A00394@T00=400<TA2@02d@00bA4A004A00394A400U400=XA2@034@00fQ4A008A0AX0T@4J003
R6Q400A400=XA6P00T@00fQ4A00?A0000d@00bA4A00=A0DT0d@012A492@;A00394A400940R@2A003
94A400Q40b@4A0<T00=494@01b@01D@T94@T01A412@5A00394@T008T1T@00bA4A006A0LT14@39003
A2A400=40b@:A00394A400M400DTA2@TA00290Y400<TA4@02d@390A400=XA6P00VP7A003J4A400M4
0b@CA003J4A400E40R@FA003J4A400A418P00hb/m@04m@03nOGe00Ci6OX3n@05mOWen_T02?X2n@Ce
0m000lb/[002[006S:b<[<c@0Z`00m3<[002d003c8b/00><0XP00fR8R005R0><0fP01hR<[=7elM00
0o400lb/S003S003R8b800:<00?<[=000m03d@05d=7<[8`00Z`01Xb8R8R<[0F<0hP016R8R8P2J004
A8Q4J0E400<TA4@034@49003A2@T00DT00=494@00R@2A08T0d@00bA4A00390U40R@2A0<T0T@00bA4
A00390=432@5A18T00A492@T0d@29003A2@T00LT00=492@01B@3A00894A4A2A494@390940b@00d@T
9005A0<T00A492A412@7A0<T0d@00bA4A00CA00394A400I400=XA6P00VP4A0MX6T@3J0940FP000=4
00<TA4@03D@290Q400<TA4@02T@00bA4A002A00394A400@T1d@012A492@4A08T00=492@00R@00d@T
A002A00494A4A08T0T@00bA4A00<A08T14@012A4A2@5A08T3D@29003A2@T00DT0d@29007A2@T94@T
A00390E400AXA4A412@6A00394A400=40R@00d@TA007A00394@T00]40b@2A00394AX009416P<A003
94A400Q400EXA4A4J00:A003J4A400Q400<TA4@02D@00fQ4A005A00;J4A4A6Q4J:b8J8P00Z`00o7e
m@05m@03nO[j01[j0oT01?GinOT9nPCi0_D3l@05d8c<[8`02:`2c0>/00C<[8b80X`028QXR8aXR:aX
0XP00jb8S003J003R:b/00;@00?<d?400]02[004S8R/S0:800><[:`00/`3d00?dO7@d:c<d<b<d8b8
S8R/00:<00CAS8b/18P00fR8R004J003R4A401A422@2A08T0T@490=400DTA4A49002A08T0T@390=4
0R@4A00394A400940b@014@TA4@5900304@T00DT14@;9003A2@T00TT0d@290A412@00d@TA00590=4
00@TA4A412@5A00494@T90M400<TA4@024@390Q400DTA2A4900DA08T14@016Q4A4@2J003R6QX00=4
16P014AXJ6P<A08T34@2J0A40002A00394A400=400<TA4@01d@00bA4A003A00394A400A400<TA4@0
24@00bA4A002A00394A400E40R@2A0DT1T@29003A2@T00I400<TA2@00T@2909400<TA4@02D@590=4
0R@014@TA6P3A08T3D@59003A2A4008T14@00bA4900690a40b@00d@TA003A00394@T008T00E492A4
9005A0HT1d@491940VP6A00394A400U400=XA4@03d@00bA4A00NA09X00J8J:b/c=03m@03nOGe00;e
6_X01?Wjn_T2nP04mOWim@;j00Cin_Wi0oX2n@03n_We00?a00?@[:`01J`00m3<c004d0:/00?<d:`0
0hP01hb8S8b8S6P00XP018b8S8P2S00=[8R8[<cad<c@dLb/c002S0:800R<[8b/c:c@c0;@00?Ad=00
0]001Lcac=2/00;<00><R8P00XP00jb<S002[008S8R<R6R8J8P4J0E400<TA4@034@00fQ490089003
A2@T00941R@4A08T0T@890940R@00d@TA005A0DT0T@39003A2@T00@T0T@01BA4A4@T00941R@014@T
92@2A00394@T00LT00A494A40R@01D@TA4@T00=400<TA2@00b@00d@T900290E40R@5A00494@TA08T
1D@290E40b@00d@TA002A08T1D@012A492@5A00394AX01U426P3A003J4A4009400DTA4A4J003A004
94@T90A400=XA4@01T@00fQ4A002A0000T@00bA4A002A00394A400e400DTA4A4J002A0<T3T@00bA4
A005A00394@T00940b@7A00394A400]40R@@A0HT0T@490A41b@;A00694A4A2A40R@6A0<T2T@01fR8
A4@TA2@00d@00bA4A003A0HT24@29004A2@T90I400@TA2@T4d@2J2e400<TA4@05T@2J0:80]000o7e
m@05m@;i7oX8n@03n_Wj00Cj0_T3m@04lM3<d0:/00?<d=002=05[0:<00>8S=000h`00hR<[003S003
R8b800:800><[=000]44d0>/0h`2R0:/2]000m7@d002d003[=2/00:/0X`02hR<[:b<c8b8[8b800IX
1T@290I400=XA4@00d@2J003A2@T00HT1T@69003A2A400=400<TA2@01R@3A08T00=494@00d@;9094
1B@2A003S4@T00<T0d@290944b@2A0@T00=XA4@014@00bA4900890=40R@01D@TA4@T00E40R@5A005
94A4A6P00d@2909400<TA4@00R@5A0<T14@00bA4A00JA0AX00>8J6P00VP4A003J4A400E40VP2A005
94A494@00VP00dAXA002A003J4A400940VP3A00024@00bA4A004A00394A400m400<TA4@02d@00bA4
A006A00694A4A2A40R@6A00394A400Y400<TA4@03d@590M40R@5A00394A4008T2d@00bA4A0029003
A2A400I400<TA4@024@016Q4A2@6A00394A400A40R@;A08T0d@390E400<TA4@01T@00fQ4A006A003
J4A400Q400=XA4@05D@00fQ4A00>A00394A401M40fP00hS@d008m@03nO[j01oj00Cin_Wj1?T7nP03
nOGe00;e00Kad=3<[<`2d003dOGa00G@0j`5d004S:b/[0><0Z`01Hb8J8R/00:800J<[:c<d?44[003
d:b<00>80h`4d0;a00?Ad=401=001:c@c=02[003S8R800:<1:`01Hb8S:b<009X00B8J6QX14@290M4
00<TA4@01T@290=400<TA4@01d@890M40b@7A00394@T009412@00d@T90039003A2@T00=412@4A08T
1T@C9005A2@T94@012@9A00394@T00<T00=492@00d@00bA4A007A08T14@00bA49009A0DT1D@29114
00=XA4@044@01FQ4A6Q4009X0T@016Q4J6P9A0=X0d@290940fP9A003J4A400940002A00394@T0094
00<TA4@014@00bA4A00=A00494A490E400<TA4@03T@022A4A4@TA2A41B@2A00394A400U40R@>A0@T
2T@290Q40R@6A00394A400A40b@2A003J4@T00A400<TA4@04T@00bA4A005A00394A400U400<TA4@0
4d@01fQ4A4AXA6P06D@00fQ4A009A003J4A4011400=XA4@05D@01VR8J8b/d0Se00?in_X09?X3n@Oj
00?imOD00oD01m3Ac:c@c:`00_400oGad@02l@05d8b/d=400]000m7@[002[004R8b<S0:/00F<R8R<
[002R0:<00V/c:c@[<b/c:`00XP01Jb<R:b<00;<00?@dM400oD00m3Ad@02d003mLc@00?<00>/S6P0
0hP00jb<[002[003R:b<00:800=XR6P00VP3A08T4D@00bA4J002A00494@T909400AXA4A41R@014@T
A4@390940R@;A0DT00A494A40R@00d@T9003A0LT00=492@00d@00fPTA0069005A2@T94@022@3A08T
00=492@00b@4A00494A4A0PT00=494@014@00bA4A006A00394A400e41R@4A08T00=4J6P00T@00bA4
A002A003J4A4009400<TA4@06d@016Q4A6P@A00394AX009X0d@01BA4A4AX00I4000;A00494A490E4
00@TA4@T1T@391Y412@2A08T00=492@00R@9A0<T4D@390M400<TA2@02D@00bA49003A0@T0T@012A4
A4@290E41R@00d@TA002A08T24@00bA490029003A2A400I400<TA4@04D@00bA4A00=A003J4AX0154
00=XA4@01D@00fQ4A009A003J4A400Q40VP3A00394A400U400=XA4@034@3J003S:c<00Ge1?TUnP04
nO[jn@Kj0oT4m@03lM7@00?@00>/lO401OD00m6/d004d@;@0Z`01XR<R8b/R0:<00=XR8`00Z`00hb/
[003[004R:b/S0:/0X`2[004S:b/c0;@00OadO7edM3A00?@00OAd<c<d:b<00B800F<[8b/R002S0B/
00><R8P00VPOA003J4A400=422@2A0LT00=494@024@59004A2A4A10T1T@00bA490059004A2@T9094
0b@014@T92@3A0<T0T@00bA490029006A2@TA2A40R@3A0@T1D@490I40R@3A00394A400Q400@TA2@T
0T@00bA4A002A00394A400Q40VPMA005R6QXA6P02d@016Q4A6P6A09X00=4J4@014@00fQ4A002A05X
0D@1A0000T@00bA4A005A00494@TA08T00=492@00b@00d@TA004A0@T34@290Q400<TA4@01T@29094
0R@;A0<T4D@00bA49008A08T14@00bA4A004A00394A4008T14@790A400HTA4A494@291A400DTA6Q4
J003A00394A400A400=XA4@06T@00fQ4A00=A005J4A4A6P07d@016Q4A6PJA0=X00>8[=400]03m@03
nOGi00;i7OX00oWjnP08nP03nO[j00Cj0_T5m@03d?7A00;@00F/c?7Al@06m@;a00?ed?400m000jb<
[002[003R8b800F800B<[8aX1j`018b/R8`4[0;@00?AlOD00_401=7adO42d@06d?7@d:c<1:`3S0>/
0X`01jb<S=2/S8P00fP<A003J4AX00Q412@3A003J4A400E442@00d@T9005A0@T0d@00bA4A002A0HT
0T@5909400<TA2@01B@00d@T900;9003A2@T00@T2D@00fQ4A006A0<T0T@690941B@4A0TT1d@00bA4
A003A00494A490U400@TA2@T1T@012A4A4@2J1Q400=XA4@054@00fQ4A00=A0004D@29003A2@T0094
0R@4A0<T14@291A400AXA4A40R@IA00394A400M400<TA4@02D@390m400<TA4@01D@00bA4A003A005
94@T94@012@4A08T1d@290940R@00d@T900DA08T3d@00bA4A00>A003J4A401E400<TA4@09T@00fQ4
A003A09X00F8[=7@l@04m@03nO[j01gj00?in_X04?X2n@Ge1]001=7elM0<m@03lM6/00:/00B<[8b<
0hP2J003R:b/00:<1j`01Xb/R8b/S0:/0]002?GalO7elOGA0o401]7ad=2/d0F/00><[:`00j`028c<
[8b/S8R<0VPFA0HT24@=90=41B@5A0HT0T@29003A2@T00=412@2A00394@T00@T0T@E9004A2@T90A4
00<TA4@01T@490941R@014@T92@2A0HT1T@790]40b@00d@TA00KA003J4A400I400<TA4@00T@00fQ4
J00QA003J4A400Q4000DA00494@T90Q40R@:A00394A400Q400<TA4@054@00bA4A005A08T3d@00bA4
A008A00394A400A400=XA4@03D@290Q40R@5A08T1d@012A492@3A00594A4A2@01T@00fQ4A00=A08T
2d@390A400AXA4@T24@00fQ4J005A003J4A403I416P01TAXJ6R<c0;@0oD01?Wen_TKnPCi3oX2n@03
n_Wi00Ce00?adM000]400m3al@03m@03lOGe00Se00CamM7@0Z`02XR/R8R<J8QXR6P2R007S8R/[8b8
[002S003c:b<00B/00G@dO7ed@05m@04d?7Am@;A0]001:cAc:`2c004S:b/d0:/00F<[:b/S002[004
S8R8J0I400<TA2@034@390941B@6A0<T0d@390I400<TA2@00R@00d@T9003A00394@T00HT0T@29094
1b@3A00394@T00I40R@2A0HT00=492@012@00d@TA002909400DTA4A49004A0@T0T@<9005A2A494@0
1b@2A0<T0d@00bA490049003A2@T00DT7D@3J0e400=XA4@0:T@001A41B@BA00394A400m400EXA4A4
900WA003J4A400I400<TA4@054@01BA4A4AX00I400<TA4@02d@290I41B@2A003J4A400E400=XA4@0
1D@012A4A4@2911416P;A003J4AX00A400=XA4@024@00bA4A002A09X3d@00fQ4A00?A00394A400A4
00=XA6P00T@2J009S:c@lM7enOGj00;i00?jnOX06OX2n@03n_Wj00kj00?imOT00oD01O7elM3e00;@
00Gad?Gel@09m@0;nO7emM3ec:c<S6P00hP3J004[6QXJ0:<00B/S8b<0XP2S0B/00?<d=001oD02?7e
lO7elM3e0m001Lc@d<ca00:<0/`01:c<[<`2[0><00>8S6P01D@00fQ4A007A09X1D@4909412@5A0@T
14@290I41R@00d@TA006A0<T14@3909422@4A00394A400=400@TA4A422@00d@T900290I40R@7A0<T
1T@69004A2@T90=40R@00d@TA0029003A2@T00<T14@00bA4900490=40R@014@TA2@6A00494A4A08T
00=4J4@00T@00bA4900QA09X8T@000Y400<TA4@01d@00bA4A00290Q400@TA4@T1d@00bA4A008A005
94A4A2@01D@00bA4A007A003J4A400a400<TA4@03D@00bA4A004A00394A400]40R@3A00394AX02A4
0R@4A00594A4A6P014@00bA4A004A00394A400940R@@A0=X2D@00fQ4A002A003J4A400=400<TA4@0
1d@2909400=XA4@00d@016Q4A6P6A003J4A400U400<TA4@00T@00bA4A007A09X00I4J6QXR8`2d0;e
00Gin_Wjn@0MnP;i3oX3n@03mOWe00?e00?@dM000m05m@03lOGe00?e0_T3m@03lOG@00;@0Z`00hb8
J002A004J8R8S09X0X`01jb<[6R<[8`00Z`01Xb/c:c@d@?e00?amOD00oD01o7edO7ed=400/`00m3<
d002c003[=2/00:<0j`00hb/S004R003J4A401140R@3A0HT0T@390A400<TA4@014@59003A2A400HT
0d@390=452@3A08T00A494@T1D@89003A2@T008T00=494@00T@39003A2A400941B@3A00494A4A0PT
14@012A492@4A0<T1T@29003A2@T008T00M494A494@T00A400DTA2A4900BA003J4A400a400<TA4@0
5T@00fQ4A00EA0003d@00bA4A002A00694A494@T1T@00bA4A003A00394A400E400<TA4@014@012A4
92@AA003J8Q401A400<TA4@01T@00bA4A003A00394@T01E400@TA4AX4D@00fQ4A00=A08T00=492@0
24@00bA4A002R09400<TA4@03d@00fQ4A002A003J4A402Q400EXA4A4J00GA003J4A400I400=XA4@0
0VP01hR/[=3amOT00_D01O[in_[i01gj00Cin_[i3?X00oWem@06m@03d=7@00?@0_4>m@?A00G@[8R8
[002R0=X0XP2J006[8b/[8R<0Z`00hb/[002[0;<0]001?GamM45m@03lOGa00;a00_ed=2/d<c@[<b/
d004[005S:b8[8`00hP4J0I400<TA4@01D@016Q492@4A0PT00=494@01R@3A0PT0d@9909400<TA2@0
22@2A0DT1D@3909412@2A00394@T008T00=494@01b@4A08T14@290=412@6A0DT14@00bA4A002A003
94A400=412@00d@TA002A08T0T@89003A2@T00A400@TA4@T0d@00bA4A00=A0<T14@00fQ4A00>A003
94A400U400=XA4@05D@3J00014@00fQ4A003A00394A4009400@TA2@T0T@01RA492A490A40R@5A003
94A400a40R@CA003J4AX01e400<TA4@01d@00bA4900?A0<T5D@00bA4A00=A00394A400E400<TA4@0
14@00hc<A00BA09X0T@016Q4J6P4A003J4A400E40VPOA003J4A400E400=XA6P00T@016Q4A4@2J094
00=XA4@01T@00fQ4A004J005R8b/[=401OD3nA[j0_T2nP;i0_X00oWjnP0:nP?i1_D00o7Ad004d003
dO7e00Ke00?imOT00oD01_7AdM2/S0:/0XP2J0>80VP01Hb8[:b800B/00><[<`01M09m@06dOGAlM7e
1M000lb/S006[0><00J/R8R8J8P8A00594A4A6P00d@00fQ4A006A0@T00=492@012@2A0DT14@49004
A2A4A08T00=492@00R@01D@TA4@T00943b@00d@TA005A0HT00=492@01R@00d@TA00690I400<TA4@0
0d@2909412@5A0DT1T@00bA4A00:A00394A4008T00=494@00R@2A0LT7D@2921400=XA4@02D@29003
A2A400E40VP00dAXJ001A00014@00fR<A004A00394A400E400<TA2@01d@00bA4A005A00394A400A4
00<TA4@06d@2J003[4A400I40R@2A00394A400Y400<TA4@00T@390Q400<TA4@03d@00bA4A004A003
J4A400a400DTA4A4900CA00394A401=400<TA4@01d@00fQ4A005A003J4A400=400=XA4@03d@00fQ4
A009A003J4A4009400=XA4@00d@3J0A40fP00dB<A008A003J4A4009X0T@2J0:800><[?D00_D02?[e
nOWen_We6_X01OGjn_Gj00?i3?X00oWjm@03m@0<nOGemM3adM3ad=7a1OD00o[en@04m@07lOG@dM2/
S003[003S6QX00=X00V<R8R/S:b<R:`00h`02:cAd?7@dOGa0_D00o7em@02m@;a00Ced?7e1=001_7@
d=2/R0:/00G@[:c<[003S004J8R8R09X00M4J4A4J4@T00940fP;A0<T00=492@01B@00d@T900390M4
3b@2A00394@T008T00E492@TA00:9003A2A4008T00A492A40b@00d@T900<90A400<TA4@01D@00bA4
A004A0@T1d@390M400<TA4@01D@012A494@290940R@00d@T900390=412@00d@TA009A08T3D@00bA4
900BA09X44@00fQ4A007A0<T00=4J4@00d@2J0A4000:A00394A4009400<TA4@00T@00bA4A005A08T
1d@01bA4A4@TA2@064@490A400>8A4@01T@290940R@?A0<T0d@39003A2@T01A400<TA4@01T@00bA4
A005A00594A4A2@024@490=400<TA4@02T@00fQ4A008A00394A4009400@TA4AX1T@00fQ4A002A003
J4A400940VP9A004J4AXA09X0d@01BA4R4@T00E400=XA4@034@00fQ4J00:A003J4A400Q400MXA6Q4
J8R<00:/00?@dOD01OD01o[enO[in_T04oX00oWjnP05nP04mO[in@gj00?in_T00oD01oWemOGAd?40
1=0<m@03lM7a00;@00>/S8P00hP00fR8J002R005S8R<S:`00X`01:c@c<`3d003dM3a00We00SamM7e
lM7@m@C@00CAd<c@0j`2c0>/00F<[8b8S002R0940VP6A003J4A400I40VP5A0LT00E494@TA0059094
00DTA4@TA0099003A2@T00<T00=494@00R@2A0<T00E492@TA0049003A2@T00PT00=492@00R@2A003
94A400=40b@5A08T0T@00bA4A009A0<T24@012A4A2@6A00394A400I400<TA4@01d@690A40R@5A08T
00A494@T;d@00fQ4A00AA00394A400A40VP00dAXA001A0000d@00bA4A003A08T5T@012A4A4@690Q4
0R@9A08T14@490]40b@3A08T1D@00bA4A006A00494@T90941b@014@T92@5A09X1T@491A400<TA4@0
1d@290=41B@4A00394@T00e412@eA0=X2T@01FQ4A4AX01=400=XA4@00fP2R003[=3e00Oe00?jnOT0
7OX00oWjn@02nP03nO[j00cj00CimOGi1?D2d@03d=7<00;@3?D00o7Ad002d0>/00B<R8R818`01:b<
[8P2[003S<c<00;@00KadO7AlM4;m@03dO7A00?a00KAlM3@c=05[003c=2/00:/00N<[8b8S8QX00=4
00=XA4@00T@00fQ4A002A003J4AX009416P3A0DT0T@39003A2A400PT14@79004A2@TA0LT0T@29094
12@2A0@T00=492@022@014@T94@590I40R@00d@TA004909400DTA4A49006A0<T1D@491Q40b@3A003
94@T00<T00M492A494AX00=400<TA2@01d@00fQ4A005A08T7d@00fQ4A008A003J4A400=400DTA4A4
9008A0=X0D@000a40R@00d@T9004A08T00=494@024@00bA490059003A2A400M400<TA2@01T@390E4
0b@8A08T0T@290=400@TA2@T0d@290I412@4A0DT00=492@00R@=A08T1d@00bA4A003A08T1D@00bA4
A007A00494@T909400HTA2@TA2@XA09X0d@3J0A400=XA6P05T@00fQ4A003A00394A400A400=XA4@0
64@3J004R8c<d0;e00?amOD00oDPnP03nO[i00;j0_T00oGjnP0:nPCi0oD2l@03dM3@00;@00?amOD0
0oD2n@Ge0_401]3<c:b<[0><0hP01hb8R:b8[8`00Z`02]3<dO7AlOGAmO49m@03lOGA00;A0_42d@;@
00?A[:`01J`00m2/d002[003S8R800B80VP:A007J8R8J4AXA003J0A41R@2A00494A4A08T0T@012A4
A2@4A00394@T00LT0d@5909400<TA4@014@00bA49002909400<TA4@012@3A00494A4A0@T00=492@0
0d@012A4A2@=A00394@T00I400<TA4@024@00bA4A009A00394A400=400<TA2@014@012A492@2A08T
00=492@00R@3A003J4A400Y400=XA4@00VP3A003J4A4011400=XA4@00VP3A003J4A400M400=XA4@0
5d@3J0940005A00494@T90a400DTA4A4900:A00494@TA0@T4T@012A492@2A0@T3D@290E400<TA2@0
0R@4A00494A4A0HT0T@49004A2@T90m400<TA4@01D@012A4A2@2A08T14@00fPTA006A0<T00=492@0
2d@00bA4A002A0@T0d@00fQ4A006A00394A4019400=XA4@00d@2J0Y400=XA6P024@00fQ4A009A003
J4A400940VP2A005J4AXA6P02T@00fQ4A003A0AX00B8[:c@1oD01O[in_[i01_j00?in_T00oX3n@cj
0_T00o[em@03m@04dM3@c0;@00SamOWen_Wen@Ke0]03[0:<00F8S:b<[003S00=[8b<S:b<R=3amM3e
d@02m@03lOGe00Se0o401OGad=3e00;@00>/c:`00j`00hc<[002[004c:c<[0><00>8J8`01VP6A003
J8QX00=X00=4J6P014@290=40R@6A0DT0d@00bA4A003A00494A4A0@T00A492@T0d@012A4A2@3A003
94A400DT00=492@00d@59005A2A4J2@02T@01bA4A2A494@00R@2A00394@T00E400<TA4@00d@590=4
1B@00dAXA004A003J4@T009400<TA4@01D@00bA4A003A0<T00=492@00b@BA003J4A4009X0T@00fQ4
A007A09X24@6J0=400=XA4@01T@016Q4A6P2A005J4A4A6P034@00fQ4A004A05X0005A00394A400A4
1B@2A0<T0T@390Q400<TA4@00d@291940R@5A08T00A494@T2d@00bA4A002A08T0T@00bA49009A08T
00A492A41B@00d@T9002A00394A400M400@TA4@T14@012A494@29003A2A400Q400<TA4@01T@49094
00@TA4A40R@3A08T14@690Y400<TA4@014@01FQ4A4AX00i40fP00dAXA009A003J4A401]400=XA4@0
44@00fQ4J003J005R:b/[=401oDMnP;i1?X6n@gj00?in_D00_D01o7edM3Ad=401?D2n@03n_We00Ce
00?AmM000Z`2c0B/0XP00jb<[003[006c:b/c?7@0_D00o7em@0=m@04lM3ed@;e00?Ad<`02J`00m2/
[002[004S:b8S0>816P00hQXA004A09X00>8J6P00VP00dAXJ003A0@T0T@390E40b@00d@TA002A08T
14@4909400<TA4@00b@9A0TT0T@00bA4A005A0<T0T@012A4A4@390=40b@00d@TA002A00394A400=4
00@TA2A40R@6A08T00A492@T0T@490Q400=XA4@01D@290=40b@5A08T00A492@T0d@00bA4J00=A09X
24@00fQ4A00AA0=X24@01FQ4A4AX009400=XA4@03T@00fQ4A005A05X0D@1A0001T@00bA4A0029004
A2@TA0DT14@290=400<TA4@014@290=40R@FA08T5d@00bA4A005A00394A400a40b@2A0<T2D@00fQ4
A007A08T0d@00bA4A006A00394A400U41R@6A08T0T@00bA49006A08T34@00fQ4A002A005J4A4A6P0
14@00fQ4A00oA003J4A400E400EXA4A4J002R0>/00?@mOD01?D00o[inP0LnP03nO[j00;j1?T00oGj
nP0;nP;i1oD00o7Al@05m@03n_We00Ce00?adM000]04[009c:b<S8R/R:b800:/00G<d=3<d002l@03
mO7e013e00OAmO7adOGA00?@00Z/S8b/R<b/c:c<0Z`4R006S8R8J8QX0T@2J0=40fP018QXJ8P2J0M4
1b@3A00394A4008T0T@01RA492A490=40b@3A00494A490M40R@00d@T9003A0<T00A492@T24@490E4
0b@3A0LT00=492@01d@3909400@TA2@T0T@4909400<TA4@00T@290a412@00d@T900290E412@7A003
J4A400Y400=XA4@00d@290941FP6A004J4A4J09400=XA4@00VP9A0=X8D@000I400@TA2A40R@00d@T
A002A00394A4009412@2A0<T00=492@00R@7A00394A400940R@014@T92@;A08T0d@01RA4A2A490E4
00<TA4@01D@390A400<TA2@00d@290I40R@014@T92@3A08T00=494@00d@390A40R@4A08T5d@89003
A2@T00E400@TA4@T1T@00bA4A00<A004J4A4J0Q400EXA4A4J005A003J4A402Q400=XA4@05d@2J005
S=3<d=401OD00oWjnP0SnPGi2?X2n@Gj0_T00oGim@02m@04lOGem@Ci1?D00o7Ad003d0:/00R<R8b/
S:b8S0:80X`2[006c=7@lOGa4_D2l@06dO7AlM7e0]02[003c8b<00:<1J`2S003R8b800B800=XR6P0
0T@00fQ4J003J003A6QX009X0XP00fR8J004A0TT0T@69004A2A4A08T0T@590=412@00d@TA007A0HT
0d@490=40R@014@T94@49004A2A4A0hT0T@890E40R@2A08T14@00bA4A002A00394A400]40R@014@T
A4@590A40R@@A09X44@01FQ4A4@T00=40VP<A09X:4@000M400HTA2@TA2@4A08T0T@490=40b@00d@T
9005A00494A490A400<TA2@01R@6A0DT5T@290Y40b@7A0<T0T@00bA49002909400<TA4@014@00fQ4
A007A00394A401I40b@00d@T900591e400=XA4@01T@00bA4A00;A003J4A401]400=XA6P04d@00fQ4
A002A003J4AX009X14@00fQ4A002J005S=3@mO400_D00oWen@02n@Oj00?in_X06OX3n@03mOWi00Sj
00?in_T01_X00oWem@05m@Ci1OD00m7@d002[006d<b/[8b80Z`4R0:<0j`01M7@lOGa00Ce00GamOGe
n@04m@03nOGe00Ce0_403=7@d?G<d<b<d:b8J0>/00>8[:`00Z`00hb8[002[003R8b800=X00A4J4A4
0fP00dAXJ002R09X00B<R8R80fP2A10T14@29003A2@T00TT0d@012A4A6P4A0LT00=492@01B@00d@T
900290A412@3A0HT00=492@01B@3A00394@T00@T00=XA4@00T@29003A2@T00]400<TA4@00d@2J004
R4A4909400HTA4A494@290I40R@HA003J4AX00940VP5A008J4A4A6Q4J8P9A003J4A400M400=XA4@0
0T@00fQ4A005A00394A4009400F8J4A4J00<A0001T@00bA4A0029003A2@T00=41b@00d@T9002A08T
00=494@01D@012A492@8A0<T0T@012A4A2@2A00394A4008T5T@290A400<TA4@00d@590I40R@2A0DT
0T@390U400<TA4@06d@990A400<TA4@04D@00bA4A00?A003J4A400U40VP8A003J4A400A40VP=A09X
14@00fQ4A00HA0EX00J8S=3@mM45m@;i9?X2n@?e2OX00oWjnP05nP03nO[e00Ke0_T5m@04dM3@c0:/
00?<S:`00Z`00hb/S002R003S:b<00>/0m000m7em@0Em@03dO7A00;@00B8[:b<0Z`2R003J8R<00F8
00F/R8b/S003R0IX00=4J6P00T@018QXR8P3J0F800=XA2@042@3A0<T00=492@03B@7A08T00=492@0
0b@2A00394@T008T0T@49004A2@TA0<T0d@690941B@3A0PT00I494A494@490E400<TA4@00T@39003
A2A4009400EXA4A49002A0<T00=492@01B@014@TA2@4A0<T0T@390I400=XA4@00T@00fQ4A005A003
J4A400Q400=XA4@02D@00fQ4A007A003J4A400Q400<TA2@024@00fQ4A00:A0001T@290=400<TA2@0
0d@690=400@TA2@T0T@290A400<TA4@02d@290Q400@TA4A40R@5A00394A401Q400<TA2@00b@7A003
94@T00@T0d@390I40R@01T@TA2A491M41B@00d@TA00=A004J4A4J1M40VP3A003R6Q400I400AXA4B8
14@00fQ4A006A09X2T@00bA4A003A09X4D@00bA4A00<A09X00R/R8R/d=7el@;e00GimOWjn@0UnP;i
0_D7nP;i00?jnOX01_X2n@ce00?Ad=001:`00m2/[002[003S:b/00:/00N<[<c@c=3A00ge00?imOD0
2_D2l@G@00C<S8R80X`02Jb<S8b/S:b<[002R0><00F/R6QXR00:J0>80fP00hQXJ003A18T00=492@0
0R@00d@TA0029007A2@T94@TA004909400<TA4@01T@59003A2@T00`T0T@00bA4A003909400<TA4@0
22@00d@T900790E400<TA2@012@4A00494A4A0DT24@59004A2A4A0<T00A492@T1D@390=400<TA2@0
1d@012A4A6P2A0=X0T@00fQ4A002A00394A401140fP9A003J4A400=400<TA4@02D@2J0E400=XA4@0
14@000I400<TA2@00T@022A4A4@TA2A40R@7A08T0T@29003A2A400=400<TA2@024@3909400DTA4A4
9006A08T1T@012A492@7A08T0T@390Y40b@6A00594@TA2@00d@39004A2@T90M40R@3A00394A40194
00<TA4@01T@012A4A6P8A00394A400E400<TA2@02d@00fQ4J00:A09X00=4J4@014@01FQ4A8QX00i4
00EXA4A4J00>A003J4A401e400=XR8`00Z`00m7am@05m@?i9_X2n@03mO[j00?j00?in_D01?D6nP?i
0oD02M7amM7edO7Ad003[006S:b/S:b<1:`01Hb/S8S<00?@00?AmOD01?D00oWem@05m@03nOGe00_e
00?ad=400m000lb/c002R0:<00V8[8b/S:b8[8P00h`2[0>800EXR6Q4J002R09X00>8J6P018P016R8
J8P4A0DT00=492@02R@00d@T9002A0<T0T@01BA492A4008T1D@290A40R@2A0@T00E492@TA0069003
A2@T008T00=494@012@5A08T0T@490=41B@00d@TA00290=400<TA4@00b@2A004R4@TA0HT0T@290A4
1R@4A0<T00=492@014@49003A2A4008T54@00fQ4A005A003J4A4009400=XA4@02D@00fQ4J007A003
J4A400A400<TA4@02T@2J0=40VP6A0001d@00bA4A006A08T0T@29003A2@T008T00=494@014@39094
0b@3A00394@T00M400<TA4@02D@49003A2A400A400<TA4@00d@00bA49002A0DT0d@290A40b@014@T
94@390I412@00d@TA00392]40fP>A00394A400A400<TA4@00d@00fQ4A009A004J4AXJ09400=XA4@0
2D@00fQ4A003A00394A400U400<TA2@02D@00fQ4A00=A003J4A400I400=XA4@00d@2J0:80Z`01M3e
lOGa00?e0oTWnPGi0_X00oWjn@02m@04dO7am@;i1?X00oWem@02l@03d<c@00?@00?<d:`02:`018b/
[<`4[0G@2?D01OWemOWe00;i2oD03?7elO7AlM3Ac:b<c0><00B8S8R<0XP00jb<S005S003[8QX00AX
00=4J6P00VP00hc<R004R006S8QXJ8QX0d@012A4A4@79004A2A4A0<T1D@<90940b@7A0/T00=492@0
3B@2A0@T00=492@01B@4A0<T00=494@00R@00d@T900390941B@00dAXA0039003A2@T00I40b@00d@T
9003A0<T00=492@00R@00d@TA002A00394@T00<T0d@00bA4A00=A00394A401i400=XA4@014@00fQ4
A00OA0001D@01bA4A4@TA2@00d@290941B@8A0<T00A494A40R@5A08T1d@00bA49002A0<T00A494A4
1B@5A00394A4009400@TA4@T1D@390=400<TA4@00T@29003A2A400<T00=492@01D@290940R@3A003
94A402=400<TA4@01d@00fQ4A005A005J4A4J4@00R@6A08T2T@00fQ4A005A0EX14@00fQ4A003A003
J4A400=40R@8A003J4A400Q400=XA4@00T@00fQ4A003A003J4A400=400<TA4@02T@01fQ4A6Q4J4@0
0XP00hc@d006m@05n_Gin_D00oX00o_jnP0CnP03oo[j00[j1?T00o[inP02n@04n_Gem@;@0_D02O[i
n_[enOGam@02d0:/00?<d<`00Z`01Hb/S:b800:/00B<[8b81Z`01/cadOGad@?e00CimOGj0_D01_We
nOWenP;e00?imOD02OD01M3ad:c@00:/00K@S:b/S:`4R0:/0XP2S004[8b/S0AX00E4J6R8J002R003
S8R800F81FP6A0<T00=494@00d@59003A2A4008T00=492@022@4A08T00=494@014@00bA4900690A4
0R@014@T94@89003A2@T00hT00A492@T0T@79003A2A400@T00A494A412@00d@T9002A08T0T@69094
00<TA2@01R@7A0@T2T@00bA4A00CA00394A401M40VP@A003J4A400A400EXA4A49002A09X0D@000I4
00<TA4@00d@29004A2A4A0@T00=494@02T@00bA4900490A400<TA4@01T@00bA4A002A08T1D@39003
A2A400e400<TA4@00T@39003A2A400E40R@5A00494A4909400<TA4@01D@012A492@VA00394A400A4
00=XA4@03d@00fQ4A00GA0=X6d@2J0Y400<TA4@064@00fQ4J005A09X00F<[:c@l@05m@05nOGin_T0
;OX01?Wjn_T2m@04d=7@d@;e0_X2n@;e00CadOG@0/`00hb/[002[006S:b/R:b<1:`018b/[<`3[003
lM7a00Ge00?imOD00_D01OWemOWe00;i0_D00oWem@08m@04dO7ad@;@0j`2c003[8c@00:/0hP01Jb<
S8R<00B/00>8J6P01FP00hQXR006R005S:b8R6P00XP00fQ4A004A00394@T00A41B@4A0<T00=492@0
1B@01D@TA4@T00A40b@4A00494@TA0DT00=494@00T@00bA49002A08T0T@99003A2@T00PT00=492@0
0R@00d@TA00690A40R@00d@T90069003A2@T00/T14@49004A2@T909400IXA4A494@490=400<TA2@0
0T@00fQ4A007A00394AX00]400=XA4@00T@00fQ4A00EA09X4d@01FQ4A4@T00940VP1A0001d@00bA4
A008A08T14@00bA4A009A00394@T00<T44@00bA4900290=40R@IA00394A400I400<TA2@02T@012A4
A2@8A00494AXJ0=400=XA4@044@00bA4A006A00394A400A400@TA4AX7T@00fQ4A004A003J4A4009X
1d@00fQ4J00DA09X44@00bA4A005A003J4A400m400AXA4A40hP01:c@dO47m@03nO[j02Kj00Cin_[j
0_T5nP04nOGel@?@0_D00oWem@05m@04lM2/S0:/00>8S:`018`8[0C<00?@dOD01OD00oWen@02m@03
nOGe00;e1OT00oGim@07m@03dOGA00?@0Z`00hb/[002[003c:b/00:<00>8[8P00X`00jb<[002[006
R6R8J4AX0hP01fR8S8R<R6P00XP00jb<R002R003J8QX00I400DTA2@TA0059003A2@T00=40R@014@T
A4@290A400<TA2@00d@390Q41R@9A0@T0T@00bA4900490=412@2A0@T1D@49003A2@T00<T14@00bA4
90059003A2@T00<T00=492@012@:A08T00=492@014@990]400=XA4@08T@2J2E40VP1A0003D@00bA4
A002A00394A400=400<TA4@01T@00bA49004A00594A4A2@04T@012A4A4@290E400<TA4@00T@00bA4
900290E40R@6A08T0d@00bA4A006A00394A400i400=XR6P024@00bA4A004A0=X3d@00fQ4A002A003
94A4009400=XA4@02D@00fQ4A00CA0=X0d@00fQ4A00DA00394A400m400AXA4AX0T@00fQ4A00;A004
J4A4J0I400EXA4AXA003J0>80]07m@03nO[i00_j00?kn_X07OX00oWjnP07nP03nOGe00ge00O@[:b<
[8b800:<0XP2J0:<1:`00hb/[002d003dO7e00Ce00?imOT01OT00o[in@02n@03n_Wi00ce00?Ad:`0
0Z`2S003c:b800B/00N8[8R8[8b800:<00F/S:b8J002R0=X0XP3J004R8b8S0:80Z`00hQXR002J0Q4
32@3A00394A400940R@2A00894A4J8a494@29003A2A400Y40b@8A0PT0T@490941R@00d@T900290E4
1B@2A00594@TA2@014@00bA49002909400<TA2@02R@01D@T94@T00A41b@01D@T92A400DT00=4J6P0
24@2J0E40VPNA09X1d@00fQ4A00EA08T1T@001540b@<A0<T84@00bA4A00;A0<T3T@00bA4A008A003
94@T011400=X[8`024@01BA4A4AX009400=XA4@074@2J0E400=XA4@03D@00bA4A002A003J4A40094
00AXA4AX0T@2J004A6QXJ09400EXA4A4J002A00394A4009400<TA2@01D@00bA4A008A003J4A401A4
00=XA4@014@00fQ4A002A003J4AX00:800>/d=401oD00o[enP06nP03nO[j00cj00?kn_X01?X00oWj
nP05nP03nO[j00?j00?in_X00_X00oWjnP05nP05mOWimOT00_D01o[emOGamO400]003<b/[8b/R8aX
A6Q4J0B/00?@[:`00]000oGad@06m@06n_GinOGj0_T01_[inO[en@_e00KAmOG@[<`2S003R:b/00:<
00C<[8b/0XP2S003[8R/00:<0Z`4R0AX0XP2J0^800=XA4@024@490=412@00d@TA003A0DT2D@00bA4
A007A00394@T00940R@3A08T1D@?9003A2A400XT0d@49003A2@T00<T24@390A412@2A0@T0T@00bA4
A005A0<T0T@<90Q416P6A003J4AX009400=XA4@05T@00fQ4J007A09X3d@00bA4A003A08T24@000Q4
00<TA4@00T@00bA4A003A00394A400a40b@;A00394A400Q400<TA4@03T@01BA4A4@T00I400<TA4@0
4T@290e400<TA4@00T@2J003A6Q400Q400=XA6P08T@00fQ4A003A003J4AX00=40R@7A003J4A40094
00<TA4@00d@2J0A40VP:A003J4A400e40R@9A003J4A400Q40VP8A00494A4J0E400=XA4@00T@3J0:8
00>/d?401oD00oWjn@0inP04nO[in@Oe00?Ad=000j`2S0:800=XR8P00XP01Xb/[=2/d0;<00C@dOGA
1OD3n@04mOWjn@;j00Gin_Wen@0<m@07dO7AdLc@[002S009d:b/R:b8[8R<00>800>/R:`00XP01Xb/
R8QXR0AX0h`00hR<R003R003J8R800>800=4J4@02D@01RA494@TA0@T0T@00bA4A002A0@T2T@290E4
00DTA4A49002A08T2d@00bA490039003A2@T00<T00E492@TA00:90A41B@01D@TA2A4008T14@79094
00<TA2@00T@00bA4A005A00394A400<T1D@89004A2@T90U40XP2J003A6Q400M40VPFA0IX1D@2J003
A6Q400M400AXA4AX3T@2J0540004A00494A490A40R@2A08T00A492@T0T@290=400<TA2@014@00bA4
A00KA00394A400M40R@8A08T14@00bA4A005A08T0T@01FQ4A4@T00i40R@4A0=X6d@00fQ4A00KA003
94A400e400<TA4@00T@00fQ4J00CA00394A400Q40b@DA003J4A400]400MXA6QXA6Q400=X0T@3R003
d?7e00?e00?in_D01?TlnP;i1oD00o7Ac003[0N80Z`00lcAd004[004d=7el@Ke1?T01o[inO[in_T0
4?D2l@;@0j`01]2/[8b/S0:800=XR8P00hP00jb<S002S0B80fP2R0:<00=XR8`00XP01hb8R8b8J8P0
16P014@TA2@2A08T0d@012A4A4@29004A2@T90]400DTA2A49002A00394@T009400<TA4@00T@390M4
00<TA4@014@59003A2@T00@T0d@69003A2@T00@T0d@39003A2A400<T00=494@01D@290=400<TA4@0
14@00bA4900290I400@TA2@T14@49005A2A4A2@014@012A494@290=400=XA6P00T@00fR8J005A0=X
5D@01FQ4A4B800AX1T@00fQ4A00KA00024@00bA4A004A08T0T@39003A2@T00A400<TA2@00b@4A003
94A4009400<TA4@00T@00bA49002A00394A400Q40b@7A0<T2d@29003A2@T00=400<TA4@00R@6A003
94A400a40R@WA003J4A400Y40R@4A0=X2T@01FQ4A4@T00Q40VP014AXJ6P/A00394A400A400=XA4@0
34@5J006A6Q4J4AX0XP00hc@m@02m@?j00KimOGimOTgnP;i1?X2n@Ke0]4:[0;<00C@dOGA1:`00lcA
l@06m@Ki00CjnO[j0oT01OGimOGi00_e00?ad=401:`01lb/[8R<R6P018P00hb8[002S003[8b<00>8
00=XR8P01HP00fR8[002S004J8R8R0EX0T@00bA49002A0<T0T@29003A2@T008T00A492@T0T@00bA4
A003A00594A4A2@00T@00bA4A003A08T3D@4909400<TA4@01B@014@T92@2A00394A400lT00A492@T
14@29006A2A494@T0T@290940b@014@TA4@590=40R@01T@TA4@TA0<T00E492@TA0039003A2A400=4
00<TA4@01T@00fQ4A003A09X14@00fQ4A004A003J4@T00a400=XA4@01VP2A003J4A400A40VP:A003
94A400I40b@6A0003D@01bA494@TA2@00d@00bA4A005A0HT24@01BA4A4@T00A400<TA4@02D@290e4
00<TA4@03T@00bA4A007A08T24@390940R@VA09X14@00fQ4A005A08T14@2J19400=XA4@01D@2J0A4
00<TA4@00T@00bA4A00DA00394A400A400<TA4@014@01BA4A4AX00A40VP014AXA6P3A004J4A4J0M4
00=XA4@00hP018camOD2n@;j0_T2m@05n_Gjn_T02?X00o_jnP0>nP03no[j00Gj00?kn_X05oX01OGj
nOGj00?e00GA[:b/S003[003d<c@00;A00CelOGa0Z`01<b/c=06m@;i00KenOGin_T2nP05mO[imOX0
0_T2m@03nOGe00Oe00SAmM7<d:b<l@>/00><[6P00hP01Xb8S8R/R0:/00F<R8b<R003J0B816P2S004
R:b8R0AX1D@00bA4A002A08T00A492A412@014@T94@490I400<TA4@00T@290=41R@?A08T00=492@0
12@00dAXA006A0dT0d@390E40R@2A0<T0d@49005A2A4A2@00d@390Q400<TA4@01R@2A00394A400=4
0R@@A003J4A401a41VP2A09X4D@00bA4A00?A0003D@012A4A4@290I400<TA4@00d@590=400<TA4@0
0d@01BA4A4@T00E40R@00d@TA00BA00394A401=40R@6A08T2D@012A4A2@EA00394A401m400<TA4@0
5d@00fQ4A002A09X8T@00bA4A004A00394A400=40R@6A003J4A400a400=XA4@01D@00fQ4J002S005
[=3emOT00oX01OWenO[i043j00?imOT00oD2d@F/00G@c:c<d002l@03dOGa00;@00G<d:c@l@05m@06
nOGenOGj1OT02O[inO[in_Wen@0;m@03lM3a00>/00?<[:`00Z`2R003J8R800:800><R8`00XP00hb/
R004R003J8QX00:800><J8P00XP00hb/R002R003[8QX00=X0d@290A400DTA4@TA005909400@TA4A4
0R@4A08T0d@01RA492A490A40b@6A00394A400A412@2A0DT1D@00bA490079003A2A400DT0d@290M4
1R@00d@T900390A400HTA4A494@590=40b@01D@T92A400LT0T@390A400=XA4@01D@00fQ4A009A004
J4AXJ0U400=XA4@01d@3J005A6QXA6P03d@00bA4A00;A08T1T@000M400<TA4@014@00bA4A004A003
94A400A400DTA4A49002A00494A490E400<TA4@024@29003A2A400=40b@;A00394A400E400<TA4@0
5D@00bA4A00591a400<TA4@084@390I400<TA4@03T@00fQ4J00=A00594A4A2@04T@00bA4A006A003
94A400I400AXA4AX2d@4J003A6Q400=416P2R003[?7e00;i1?X00oWen@12nPKe00?ad:`01j`2d003
dM3a00;A00K@c<c<dO48m@Si0_X4n@;e00?imOD02OD00o7@d003[007c:b/S:b8S005R007S6R8R8b/
S007R003J8QX00F800F<[8R8S002R0=X00=4J4@00T@012A4A2@3A00394@T008T1T@49003A2A40094
0b@2A00394@T00Q400@TA4A40R@5A00394A400940R@4A00494@T90U41b@3A0@T2d@89004A2@T90=4
00@TA2A40R@01FQ4A4@T00E412@00d@TA0059004A2@TA0<T34@2J0A40VP4A0:80fP4A09X2d@6J003
A6R8009X14@01FQ4A4AX00=40VP;A00494A490M4000DA00394A400a400<TA4@02d@012A4A4@29094
0R@014@T94@290I400=XA4@01T@00bA4A009A08T1d@00bA4A007A0<T00=494@01T@00bA4A008A003
94A401e400<TA4@014@00fQ4A006A0<T5d@00fQ4A008A003J4A400E400<TA4@07T@00fQ4A006A003
J4A400U400=XA4@01T@2J003R8c@00;e0_T3nP04nOGemD;j00?imOX01?D2d@04c:b/S0>/0/`00m3A
d@04d0;<0]47m@03nOGi00;e1OT01?[inOX2n@;e00?imOD02?D01?7A[<`3[003S8R/00:<00F/R8R8
S006R003J8R800:800AXS8R80VP00hQXJ002R09X0XP2J005R6QXJ8P00VP6A00494A4A08T0T@29094
00=XA4@012@00d@TA002A00394A400A400<TA4@02T@490A400<TA4@01D@00bA49003A0@T1T@29003
A2@T00`T14@59003A2@T00@T0d@5909400<TA4@00d@2909400@TA2A41b@3A00494A4A0@T1d@012A4
A6P5A09X1D@4J0M400=XA4@024@3J004A6QXA0AX64@00bA4A009A0001d@00bA4A00>A00394A40094
00HTA4A494@29003A2A400]400<TA4@014@690]400@TA4@T3T@390m41B@7A08T24@291E400<TA4@0
4d@00bA4A002A00394A400]400=XA4@014@00fQ4A005A003J4A400A40VPVA09X7D@2J0:/00?AmOD0
0_T01O[in_[e00;i00?enOX06oX00oWjnP0RnP;i00cjmOGedM2/S:b<[8`2[004c=3<d0;<0j`00m3A
m@08m@05nOGinOD00oT4nP;i3_D00m7@d004[007R8b8[8R<R002J003R8b800>800>/R8`01XP2J0:8
00=XA8P00fP00hQXJ002R003J4AX00=X0d@012A4A4@490941R@01T@T92A490940R@01D@T92A4008T
00A492@T2T@49003A2@T00940b@3A0<T00=494@00d@290E40R@2A0LT00=492@00b@014@T94@29003
A2@T008T00=492@00R@3A0LT24@49003A2A400LT1d@29004A2A490i40VP5A09X00=4J6P00VP5A003
J4AX00I41FP00dAXA003J0A40VPAA003J4A400I400=XA4@00T@001M400<TA2@00d@01bA4A4@TA2@0
2T@00bA4A009A0HT1D@00bA4A00EA0@T1D@490E400<TA2@00R@00dB8J00@A00394A400I400=XA4@0
34@00bA4A004A00394A400]400<TA4@03T@00fQ4A004A005J4AXA6P02T@01FQ4A4@T00U40VPDA004
J4A4J0a400=XA2@014@00fQ4A006A0EX00J/d?GenOX4n@06mOWenO[i2oX00o_jnP0BnP03nO[j01gj
0_T00o[in@02m@03dM2/00>/0X`00jc@d006[004S<c@l@Se00?imOD00_D01_WenO[inP?i00GenOGe
n@0:m@;@00C<[:b<0j`018b8R8`3R003J8b800:800>/S:`00h`3R09X0XP3J006R6QXJ8QX0hP7J0A4
32@00d@TA00790=42R@<A00794A494@TA0049003A2@T008T00A494@T0d@00bA4A003A10T00=492@0
22@00d@T90039003A2@T00@T00E492A49005A00494@T909400<TA2@01R@6A00594@TA2@024@2J003
A6Q4009X34@2J1540VP2A004J4A4J1940VP6A003J4A400A400AXA4A40FP0015400DTA4A49007A003
94A400<T00E494A49006A00494@T90E400HTA4A494@390E40b@00d@TA006A08T00=492@01d@490=4
0b@6A00394A400a412@5A08T14@00bA4A00GA08T2d@390i400<TA6P024@01FQ4J4AX01M40VPDA003
J4A401]41FP00hS<d@02m@?i00SjnOWimOWjnAgj00?in_X01OX00oWjnP0InP03nO[i00;i0_D00o7@
c002[0><1J`00lb/[002[003c=3a00We00?imOD00_D:n@03mOWi00[e00S@c=2/d:c@[0:<0XP01Hb8
R8QX00>80Z`018b/S8`6R004S8QXR0AX00=4J8P00XP2J003R4AX009X1D@39004A2A4A0HT00=492@0
0T@4909400<TA2@01b@<A00394@T009442@2A0<T0d@A9003A2A400@T00=492@01R@00d@T90089003
A2A400=41R@00d@T900890A41B@9A004J4AXA09X3D@01FQ4A4AX00Y400EXA6Q4J007A003J4A40114
00EXA4A4J00>A00034@00bA4A002A00694A494@T2T@00bA4A003A00394A400=400=XA4@02d@00bA4
A00390E400<TA4@01b@01D@T92A4008T2D@00bA4A00490=400<TA4@03d@390940R@2A08T0T@590E4
00<TA4@06d@290M400=XA4@01T@00bA4A007A003J4A400I40VPBA003J8Q400E400=XA4@034@00fQ4
J00:A09X3D@00fQ4J002J003R8c@00;e1?T00o[in@02n@;j00?in_X06oX00oWjn@05nP03nO[j01[j
00?imOT00oD00o7@d004[0:<00>/S:`01J`01<cAlM4;m@;i00GenOGinP04n@06n_Gen_Gi2OD01M7@
lJc@00>/0h`4R00:J8R8S8R<[8R<[0>800F<R8R<R008J003R6R800:80VP2A003J4A400=40R@6A0XT
14@69003A2@T008T1D@290E40R@3A0@T00=494@00T@99004A2@T90A44B@3A0dT0T@290E40R@4A003
94@T00LT00=494@012@01D@T92A400DT00=492@00d@00bA4A008A003J4A400e40VP;A004J4A4J0E4
00EXA4A4900FA004J4A4J0Q4000AA00394A400<T0d@00bA4A004A08T64@012A4A2@3A00494A4A08T
0T@491A400@TA2@T3d@012A4A6P8A00394A400I40R@<A003J4A400Q400=XA4@08d@00fQ4A003J003
A6Q400A40VP<A004J4A4A0=X00>/J4@054@3J0m400=XA4@02D@2J003R8c@00;e00CimOWe0_T2m@;i
1OX00oWjnP0MnP;i00?jnOT05oX01OWjnOGi00Ce00?amM001J`00hb/[005[003d?7a00We0_T3m@07
nO[inO[inP02n@04n_WinP;i2OD2l@04dM3@d0:/00><R8`00h`5R003[8R<00:<00>8S8`00XP00jb8
R003R005S6QXJ4@016P00hQXR006J0=400@TA4@T0d@00bA4900490940R@00d@T9003909400DTA4@T
A00390A40b@2A00494@TA0TT14@>90941b@01d@T92A494@012@4A0HT0d@390A41R@5A00394A40094
1B@00d@TA0059003A2@T00<T34@290A400=XA4@01T@00fQ4A00AA003J4A4009400=XA4@07D@00bA4
A007A04T0D@1A0004D@00bA4A008A00394A400Y400@TA4@T3D@690E400<TA4@044@390M40b@@A08T
7d@2J0U400=XA4@00T@00fQ4A005A003J4A401Y40VP2A09X1T@00hQ4A00:A003R4AX00IX0d@00fQ4
A00AA005J4AXJ4@00fP8A003J4A4009416P024AXA4AXR:c@0oD2n@04mOWinP;e00?in_X09OX3n@03
mOWi01?j0_T01OGimOGi00Ge00?@[:`02:`01]2/d=3Al@Se1?T2m@03nO[i00Cj0_T01_[inO[im@;i
1oD3d@;@0j`00hb8S002R003S8R800F800B/R8b<0XP2S0B800J/R8QXA6P2A0AX0T@00fQ4J002J0M4
12@5A08T1D@490940b@4A08T0T@00bA4900390Y412@4A08T00=494@04b@3A0<T00Q492A494@TA0DT
1D@390A41B@4A08T14@59003A2@T00@T0d@390Y400<TA2@00b@2A003J4A400Y400<TA4@00d@00bA4
A00<A004J4AXJ1A400<TA4@00T@00bA4A00=A05X000>A007J4A494@TA00290E400<TA4@00d@00bA4
A003A08T00=494@03d@00bA4A005A08T1T@00bA4900:A0<T1d@291140R@7A00394@T00A400<TA2@0
1T@290]400QXA4A4J4AXA0AX2T@3J1Y40fP;A003J4A400I400=XA6P00fP5A003J4A400m400=XA4@0
0T@00fQ4A00CA008J4A4A6R8[=04m@04nOGenP;i00?enOX08_X01_WjnO[im@;i00?enOT04_X00oWe
n@02m@03nOGe00?e00?ad<`01:`01HR<[:c<00;@0]4;m@?i00CenOWj0_T3nP;i00?jnOT01?T8m@;A
1=03[0><1HP01VR8S8R<[0F<00>/R8P00XP00fR8J007J003R6QX00=X0T@3J0E412@3A00394@T008T
0d@5909400<TA4@014@00bA4A00590Q43B@014@TA4@69003A2@T00XT0T@490=400DTA2@TA00390=4
00<TA2@01B@3A0HT0T@012A494@29003A2@T00@T00=492@02B@4A003J4A400E40R@6A003J4A400a4
00DTA2@TA00290E400=XA4@00T@00fQ4A002A003J4A400A40fP7A00394@T00]400=XA2@01T@1J000
0T@00fQ4A00;A00394A400A400<TA4@00T@290I40R@2A00394A400Y400<TA4@024@012A494@390E4
0b@=A00394A401I400<TA2@05D@29003A2A400I400AXA4AX0T@00fQ4A003A09X1d@00fQ4A006A005
94A4A6P00d@3J09400=XA4@024@00fQ4J00<A003J4A400A416P4A003J4A4011400AXA4AX1d@00fQ4
A00@A003J4AX009X00F8[?7enP04m@;i0_D2nB?j00?in_X00_X01?GinOD3n@03n_Wi00oj00Gin_Wi
nP06m@03d<c@00B/00R<[:c<d=7ed@_e1_T2nP05nO[in_T00_X01_Wjn_Wjn@Se00CAlM3<0]03[0:<
28P01:b<[8`3[0:<1hP2J004A6QXR09X00>8J6P00fP2A09X1T@390A412@2A0HT0d@012A4A4@490=4
00@TA2@T24@390941b@5A0@T00A494A432@5A00394A4014T00A494AX0T@29003A2@T00DT00=492@0
0R@2A0DT00=492@01B@6A003J4A400I400<TA4@064@00bA4A00QA00394A400=400<TA4@00d@00fQ4
A004A05X0D@1J0004D@012A492@2A00394A4009400@TA4@T0T@00bA4A004A00394A400U400@TA4@T
0d@00bA4A002A0<T0d@00bA4A003A00394A400A400<TA4@01D@00bA4900;A0<T2d@00bA4A008A003
94@T00I400DTA4A4900CA005c8Q4A6P014@01FQ4A4@T00Q400=XA4@014@00fQ4A005A004J4A4J114
00AXA4AX2D@2J2A400<TA4@02D@2J007A6QXJ8R/m@02nP?i0_X01?WemOTXnP;i1?D2n@?j00?in_X0
3_X01?WjnOT3m@03lOGA00;@1Z`00m3<d002l@ke00OimOWjnO[i00;j00Cin_[i0_X2n@03mOWe00Oe
00GadM3@c004[003R8aX00N800B<R:b<0XP00hb/R005R004[8R8J09436P8A0<T0d@49003A2@T008T
00A492@T0T@29003A2A400@T1D@490A412@3A0LT14@490940b@3A0lT00=492@00R@00d@T900=9003
A2@T00TT00=494@00T@01BA4A2A400PT00=492@01B@5A003J4A401i400<TA4@084@00bA4A0039003
A2A400=400<TA2@01d@1R0003T@00fQ4A00390=40R@3A00394A400i400<TA4@01d@29004A2A490=4
00<TA2@01T@00bA4A00290940b@4A003J4A400A400<TA4@024@290e400<TA4@05D@290]400=XA6P0
14@00m1XA00?A00394A400a400=XA4@014@01FQ4A4AX00e40fP:A004J4A4J11400=XA4@00d@00fQ4
A008A00394A400M40VP00dAXA003J004S:cen@;j00?in_X00_T2m@;j00?in_T00_X00oWjnP05nP03
nO[j01?j00?in_X00_X01OWjnOGi00;e1?X00oWjnP0;nP05nO[jnOX01_D01=3<c:`2R009d:b/[<c@
lOGA00Se00CimOGi0_D3n@03n_Wj00Cj1?T01o[inOWenOD00_T3m@;A0m02[005c:b8S6P00hP01fR8
R8R<R:`01H`4R003J8b800B800A4J6QX1HP00fR8A003J0I40b@3A08T0d@49004A2@T909412@00d@T
A00390E40R@2A00494A4A0@T00=492@00T@290E40R@2A00394A400DT00=492@04R@2A0DT0d@49094
0b@01D@TA2A400@T00=494@01d@89003A2@T00DT3D@00fQ4A00AA00394@T00U400=XA4@06D@00bA4
A00590M400<TA4@014@1R0004D@39006A2@T94@T14@290940R@8A00394@T008T1D@2909412@3A08T
1D@5909400@TA2@T5d@00bA4A00:A08T3D@01BA4A4AX00A400DTA4A4900:A003J4A401=400<TA2@0
44@00fQ4A006A003J4A401E40fP?A004J4A4A0=X44@00bA4A008A009J4AXJ4AXR<ce00Cj00?in_X0
0_D01OWjn_[i02Gj00?in_T00_T3m@?i4?X01?Wjn_T4m@;a00G@[:b/S004[0?<00CAmO7a3OD3n@Sj
1OT:m@03d=7A00;@00?<[:`00Z`3R0:<0XP01Hb8S8R/00><00B/S8R<1hP016Q4A4@3J0:80VP00dAX
A003J0E42R@2A0@T00=492@00b@01d@T92A494@00b@00d@T9006A00494@TA0TT1d@00bA4A002A004
94@TA1HT00A492A442@01T@TA4@TA0HT24@29003A2@T00<T00=494@01B@00d@TA00;A003J4A400M4
00<TA4@024@00bA4A00SA00394A400=40b@=A05X0004A00394A400E400DTA4@TA00290=400@TA2A4
1B@00d@TA009A0HT1D@290940R@3A08T00=492@00T@012A492@3A08T0T@00bA4A003A003J4A40194
00HTA4A494@29003A6Q400940b@2A0<T3D@390A400<TA4@024@2J003A6Q4015400@TA4AX2D@2J0A4
00AXA4AX0T@2J0A40VPXA005J4A4A2@04T@016Q4J6P3A003J4AX009X0Z`00oGjnP02nP03nO[j00?e
00Cin_[i3oX4n@Wj00?kn_/00_X00o_jnP05nP03nOGe00?e0_TBnP05mOWemO400]400lb/[003S004
[8c@c0?@00?elO400_D00o7em@03m@03nOGe00?i1?X2n@Cj00?in_T00_T00oGim@07m@05lM7@lM00
1J`018R<R8P4[007R8b<[8b8S002[0R80VP3A09X0hP00fR8A002A0=X14@99003A2@T00<T00=492@0
2B@00d@T90059005A2A4A2@00T@012A494@890=400<TA4@00T@39003A2@T008T0T@<9003A2@T00TT
00=492@012@2A0LT00M492@TA2A400@T00I494@TA2@2A0TT1T@590a400=XA4@01d@290Q400=XA4@0
6T@00fQ4A005A00394@T00I40R@3A00494A490M4000=A00394A400=400<TA4@01T@29005A2@TA2@0
0d@01BA4A4@T009400<TA2@00d@012A4A2@3A00494A4A0<T14@00bA4900290A400<TA4@01T@00fQ4
A005A003J4A400A400<TA4@00T@290I400<TA4@04D@00bA4A00@A00394A400E400=XA4@064@00bA4
A005A004J4AXJ0940fP2A09X1d@3J0m400=XA4@04D@00fQ4A00=A003J4A400I400=XA4@00T@00hQX
J002J004S:cem@Cj0_T3mA;j0_T00oGinP0=nP03no[k00Oj1_D?nP03nO[i00;i1?D00m7ec008[004
S=3@d0;a2?D00oWem@02n@03mO[i00;j00Kin_Win_T3nP03nO[i00;i2?D01=7edM05[003R8b<00>8
00>/S8`00XP00jb<S002S0:/1HP5J0A40fP00hQXA00:A18T14@>90=40b@4A0`T14@49003A2@T00@T
00=492@01D@M9004A2A4A0<T00=492@01R@00d@TA003A0@T0d@490=41B@8A00594A4A6P024@00bA4
A00?A003J4A400=400<TA4@04d@00bA4A002A08T0d@290I400DTA4A4J003A05X000<A00494@T90=4
0b@4A0HT00=492@00T@00bA4A003A00494A490a400<TA4@00R@5A00394A4008T1d@00bA4A00@A08T
0T@00bA490039004A2A4A0<T0d@00bA4A002A00394@T00M400<TA2@00R@=A00394A401Q400<TA4@0
1T@00bA4A004A09X00=4J4@00d@3J003A6Q400a400AXA4@T1T@016Q4A6P:A003J4A401a40fP3A0=X
00Y4J6QXR:c@lOGj0_T4m@03nO[j00cj00?in_X00oT>nP03no[j00Gj0_T00o[inP02n@?e0_T?nPOe
0]08[003c:c@00;@00?AmOD02OD2n@;e00?in_X01_X00oWjnP05n@Se00?ad=400]000lb/[002[007
S8R<R8b8J003R0:/0X`00jb<S002R003[8R800EX1D@2J003A6Q400Y400LTA4@TA2A400HT00=492@0
1B@2A0<T00E492@TA0049004A2A4A0DT0d@9909400DTA4@TA0049003A2@T008T14@490=432@00d@T
900<9003A2@T00943B@5A0@T0T@69003A2@T00940b@9A08T2D@00bA4A00BA00394A400i400<TA2@0
1D@390941B@4A00394A4008T1T@1J054000>A0<T0T@00bA4A002A0DT1d@290E412@;A0<T1T@00bA4
A00490E400@TA2@T2T@00bA4A003A0<T0T@390Q40R@3A00394A400=40R@8A0PT0T@290M400<TA4@0
54@39003A2@T00<T0T@00bA4A003A004J4A4J0E40fP00dAXA00=A003J4A400940VP2A003J4A4009X
4T@4J0]400=XA4@014@2J0=400UXA6QXA8S<[8`00l`00m7em@02m@03nOGi00;i3OX01?Wjn_T2nP03
nO[j00Wj00?kn_l01_X00oWjnP02nP03nO[j00Ce0_T>nP;i0oD2l@03c=2/00F/0/`2d004c=3Al@Ge
00?imOD00oD00oWem@02n@;j00?in_T01OX01oGjnOGimOT00oD01_7emO7el@;@00GAc<b/S002R003
S6R800:800>/J8P018P01Jb<[8b/00B80VP00dB8A004A09X00>8A6P01T@016Q4A2@5A08T00=494@0
2R@01d@T94@TA2@00T@290I400<TA2@00R@2A00394@T00=40b@2A00494A490I40b@3A0<T14@390=4
12@00d@T90059005A2@T94@02b@3A0hT1D@990=400DTA4A49003A00394A400A41B@;A003J4A400e4
00DTA4A4J008A00394A4009400<TA4@01d@00bA4A003A08T2T@00bA4A004A05X000@A00494A490E4
12@00d@TA00<A00394A401Q400<TA4@01T@01BA4A4@T00Q400<TA4@01D@290940R@6A00394A400Y4
0R@8A00394A400940b@3A00394A4011400<TA4@024@29003A2A400<T00=494@03T@00fQ4A002J003
A6Q400M40fPSA09X34@00fQ4A007A09X0T@4J004[=3A[0;@00?<lOD00oD00oWem@02nA3j00?in_X0
3oX2n`Sj00?in_T00oT3m@03nO[j00[j00?in_T01?D2d@05c:b/[<`01:`01]3<d<c@l@[e00?imOD0
1OT3nP?i00?jnOT01?T00oGim@02m@03lOGe00?e0]42d004c:b/[0B<00B8S8QX0XP00fR8S003S008
[8b<R8b8S8P2J0I400EXR8QXR003J0I40b@2A00394@T00<T0T@79006A2@T94@T14@390=400DTA2@T
A00290942R@3A00394@T008T0T@59003A2@T008T00=494@00b@4A0<T00=492@01R@00d@T90069003
A2@T008T00=494@03R@00d@TA005A00394@T00DT00A494@T1d@00bA4A005A00394@T01A400<TA4@0
4T@00bA4A002A00394A400Q400@TA4@T0T@00bA4A007A0<T1T@000Y400<TA4@01T@01RA4A2A490=4
0R@?A00394A400]400<TA2@01D@00bA4900390I400<TA4@00d@290A400<TA2@014@00bA4A002A003
94A4008T4D@00bA4A002A00394A400U400<TA4@07D@012A4A4@3909400@TA4A40R@6A003J4AX00Q4
00=XA6P024@016Q4J6PTA003J4A4019400F8J6QXA004J006R8b/c=3<0_400oGAm@03m@03nOGi00?i
00?jnOX02?X00oWenP0@nP03no[j00Sj00?in_X00oX01oWenOGin_T02?X00oWjn@02n@?e0]000jc@
[002[003S<c<00G@00?AlOD01OD00oWem@02m@Ci00CjnO[j2?T00oGin@09m@04lM7al@?@0/`2d003
[8b<00:<0XP4J006R8b8R8b/0X`2R004J8R<R09X1D@00hQXR004R0AX00=4J6P00T@29003A2@T00@T
0T@390942R@3A00394@T00=452@2A0DT00=492@012@014@TA4@29004A2A490940b@00d@T900D9094
4b@2A005J4A494@01b@014@T92@7A00394A401Q400<TA4@05D@00bA4A00;A003J4A400=40b@:A08T
1T@1J0001D@00bA4A002A08T2D@290=412@5A08T2D@00bA4A00:A08T00A494A40R@2A00394@T008T
0d@00bA4A004A00394A4008T0T@00bA4A006A00394A400A400DTA4A4J004A00394A4008T0d@29094
12@00d@TA00;A003J4A401940b@8A00394A400A400<TA4@05d@00fQ4A00NA003J4AX00a400<TA4@0
44@01VQ4A4AXA0AX00>8c:`00]07m@?i0_X4n@;e00?in_X01?X3nA[j1_T2nP03mOWi00?i2OX2n@03
mOWe00;e1=02S009[8b/[<c@c:c@00;A2oD01OWemOWj00Ki1?D00oWem@05m@07dM3emO7Ad002m@;@
00B/c:c@0/`2[0F80fP00hR<[002R003S:b800F800>/R6P014@01VR8J8b8S0AX00=4R4@014@=9094
2b@4A00694A4A2A43R@00d@T900490E40b@4A08T0d@00bA4A00G90=412@01D@T92A400TT00=494@0
0T@012A4J6P4A0DT0T@4909400<TA4@00T@590Y400<TA4@00T@00bA4A004A0<T1T@00bA4A004A004
94A4J0A400<TA4@04d@290m400<TA4@00D@000I400<TA4@034@390E400<TA4@00T@390A400@TA4@T
0d@00fQ4A008A00394A400E400<TA4@00T@290i40R@QA08T14@00bA4A00:A003J4AX01M400@TA4@T
5D@2J003A6QX01=400AXA4AX4D@00fQ4A005A003J4A400Y400<TA2@014@00fQ4A00=A003J4A400=X
0X`00lcAm@04m@03nOGe00;i1oX01oWenOWjnOD00_T00oGinP0HnP04nO[in@;j00?in_T00_X2m@;i
2_X01OWjmOGi00;e00g@c<c<[8R/S:c@[=2/00;@00CAmOGa2?D01?[enOX2n@03n_Wi00?i2OD02=7e
dM3Ad?GA0]03d@;@00B/c:c@0Z`2R003J8R<009X0XP4[007R:b<R8b8S002R0:<0fP01DB8A6R<00>8
1FP6A08T0d@00b@0900490A40R@00d@T900390a41R@2A0hT14@390=412@5A0<T0T@69004A2@TA0DT
00=494@00T@>9005A2@T94@00R@9A00394@T008T00I494A494@29003A2@T00E41B@>A08T1D@39114
00=XA4@04d@012A4A6P5A004J4A4909400<TA4@024@00004A2A490=400<TA4@00T@00bA49002A003
94A4008T00=494@02T@00bA4A002A00394A400@T24@00bA4900290A40R@014@TA4@590e400<TA2@0
0R@2A00394A400M400<TA4@02T@00bA4900391I400<TA4@044@00bA4A00BA00394@T01=400=XA4@0
14@00fQ4A003A08T1D@00fQ4A00LA00394A400a40VP00dAXA002J004A6QXA0=X00>8S=002OD00oWj
nP07nP;i00?jnOD00oD2nAOj00CimOWi0oD5nP;i0_D2n@[j00?enOD00_D00o7@c004[003d:b/00;<
00C@[=3@0_47m@;i00?jnOX01_X5n@Ce00KamM3ad?43d003lM3@00;@00?adM000]001:b<[<`2[005
S6R8R8`018P018b/S8P2S0B800N<J8R8J8QX00940fP018R<R6P3A004R6Q4A10T14@8909400<TA4@0
14@99004A2A4A08T00=492@01b@7A00394@T00<T00=494@03b@00d@T90059003A2A401@T00A492@T
1d@29008A2@T94@TA2@3A0@T0d@00bA4900590I40b@2A0<T0d@012A4A2@?A00394A401M400<TA4@0
1d@01bA4A4@TA2@024@000U400<TA4@00d@00bA4A003A00394@T00I400@TA2@T1T@01RA4A2A491U4
00<TA2@00b@:A00394A4008T0T@390Q400<TA4@034@890I400<TA4@07D@00bA4A00?A08T00=494@0
0d@00fQ4A00<A003J4A401U400=XA4@09D@00fQ4A004A0=X00J8J8R<[=06m@03nOGi00gj0_T4mA?j
00?in_X00_X00oGim@05m@03nO[i00?j0_D2n@Wj1OD2l@04d:b/S0F/0m001lc@d=7amO400oD2n@_j
0oT00oGim@02m@;a1=000m7@d002d0;<0Z`2d005c=3@[8`00j`2S003R6QX00B800EXR8R<R002S003
R6QX00B80VP00hQXJ003J003R8aX009X00A4J6QX0d@?90A400<TA2@01R@3A00394A400A40b@3A08T
00=492@00R@2A00394A400HT1d@690M422@3A08T0T@69003A2A400PT00=492@02B@=A08T24@290=4
0R@3A00394AX00=400<TA4@01D@29003A2@T00=400<TA4@00d@01BA4A4AX00m400<TA4@04T@290=4
0b@5A0<T1T@0011400<TA4@014@00bA4A003A00394A400A400<TA4@00T@00bA49009A00494A4A08T
3d@00bA4900>A00494@T90940b@7A00394@T00M40R@4A0LT0d@290Y400<TA4@04T@00bA4A004A09X
2d@00bA4900:A003J4A402m400<TA4@04T@2J0I400AXA6Q40fP2R0:/00?@dOD02?D>nP;i0_D6n@;j
00?in_X00_X2n@;j0_T01?Gin_T2nP;i1oD2n@?j00CimOGi2OX00oGim@02m@03lM7@00:/00><[:`0
0j`3d003[=3A00Ke00?in_X03?X3n@Ge00Sad=3@c=3<d0N/00?<[:`00h`01jb<S8R/S6P00XP2J004
A6QXJ0:800F<[8QXA004J0:800A4J8QX18P00fQ4J002J0940VP2A00394A400@T0T@69004A2A4A0XT
0T@00fQ4A005A00494A4A08T00=492@00b@014@TA4@790=400=XA4@01B@2A00394A4009412@01D@T
A4@T00E400<TA2@02B@3A0PT0T@790=400<TA4@014@490E400<TA4@014@00bA4A00=A00394@T0094
1B@4A00394@T00I400<TA4@014@00bA4A005A00394A401Q40R@00d@T9002A08T1d@001A40R@9A005
94A4A2@04d@4909400<TA4@01d@00bA4A008A08T2D@2909400<TA4@01T@00bA4A00>A005J4@TA2@0
14@00bA4A005A09X64@290E400=XA4@00d@00bA4A007A00394A400I400AXA4AX3d@00fQ4A004A003
R4A401I400<TA4@04T@00fQ4A004A0=X0T@02FR8[8R<[=3Ad008m@03nO[j00kj00CimO[i0_X00oWj
n@02n@06mO[imOWe0oT3m@07nO[in_Wen@07m@03nO[j00;j0_T00oGjnP08nPGe00KAc8R/S8P3[003
c=3@00;@00?elOD01?D3n@03no[j00;j00?kn_X01oX3n@?e00?@lM000]001Jc@c:b<00N/0h`2[005
c:b8[8P00fP018QXJ6P3R003J8b8009X00=4R4@00fP2R003J8R<00>80VP00dAXJ002A0=X14@59007
A2@T94@T0002909412@4A0@T0T@012A492@6A0XT14@790=412@2A00494A490A40b@5A08T14@00bA4
900:90940R@7A0DT0T@00bA4A002909400<TA4@02d@01BA4A4@T00A400<TA4@02D@29003A2A40094
12@2A00594A4A2@01T@00bA4A00?A003J4A400Y40R@6A00394A400=41B@8A0004d@01RA492A490E4
0R@=A00594A4A2@01D@290940R@4A08T2T@012A4A4@29003A2A400M41R@8A00394A401=412@8A003
J4A400a40R@8A00394A400Y400<TA4@01T@012A4A2@=A003J4A400940VP5A0=X14@00fQ4A00FA003
94A400E400<TA4@00d@290Q400=XA6P00T@4J0:800N/S8cAd?7@00Ke00?imOT04OX2n@;j1OT00oGi
m@0?m@03nOGe00Oe00Kin_[jnOD2n@Sj1OD00o7Ad006[0;<0]000m7am@05m@03nOGi00Gj00Ckn_[k
2?X2n@Ce00WAd=2/c:c<[8`01Z`3S003[8b/00:/0X`3R09X00>8J6P00VP5R0940VP02TAXA8QXR8b8
[8`2R003J4A4009X00=4J4@014@A9003A2@T00@T00=492@00R@00d@T900390E462@3A0<T00=494@0
14@00bA4A00390941B@4A0dT0T@390=400<TA4@02R@3A0DT00=494@014@29003A2@T008T0d@290a4
00@TA4@T0T@390=400<TA2@064@00bA4A00:A0<T2T@012A4A4@290I400<TA4@00D@000Q400<TA4@0
24@01BA4A4@T00a400<TA4@02T@01BA4A4@T00=400@TA2A40R@3A00394A400M400<TA4@01b@4A005
94A494@00R@00d@TA004A08T14@290I400<TA4@01d@3909400<TA4@01T@00bA4A00lA003J4A400]4
0VP@A003J4A401M40b@4A0]X0XP018b/[<`3l@;e00?amOD01OD00oWjnP0>nP06nO[jn_We0_X2n@Se
00Gad=7@d@02l@04mO7al@Oe0_T3nP04nOGinP;i1OX2n@Ge00?Ad<`00j`00lb/d003d0?e0oT4mA7j
1?T3m@03lM7@00;@00?<[:`00j`00hR/[002[003S:b/00:/00B<R8QX1XP5J003R6QX00=X00B8J6QX
0T@016R8R8P2S0:800EXA6Q4J002A004J4A4A0DT0T@J90Y44B@4A0@T0T@290Y40R@2A00394@T00@T
1D@29005A2@T94@012@00d@T900290E42B@014@T94@89003A2A400HT00A492@T0d@29003A2A40094
00@TA4@T1D@012A492@4A00394A400A400<TA4@074@00bA4A00290940R@5A08T3d@0015400<TA4@0
14@00bA4A005A08T00=494@024@00bA4A005A00394A400A40R@00d@TA00:A0<T1T@390940R@4A0@T
34@00bA4A00>A00394A403Y400<TA4@01d@00fQ4J00=A005J4A4A6P0;T@2J09400=XA6P00VP00hQX
J003J0:800F<[=3@d@07m@03nOGe00;i4OX01oWjn_[imOT00oX6m@03lM7a00[@0o45m@;i0_X00oWe
m@03n@Gj0_T5m@;@0Z`018b/[:`2d003dO7e00;i0_X01OWemOGi013j1_T3m@C@00K<[:c@S:`2S003
[=2<00:<0j`2S0:800=XR8P00hP00fQ4A002J004R6QXJ0A400EXR4A4R002S004[8R8R09X0T@3J0E4
2b@00d@T9002A0<T00=492@01B@5A00394A400Y41B@2A0<T0d@39003A2A4009400<TA4@014@00bA4
A004A0lT00A494A41B@00d@T9009909400<TA4@00b@01D@TA2A4008T00E492@TA00590=43B@AA08T
1T@01BA4A4@T00]400=XA4@03D@01BA492A4008T0T@00bA4A006A08T3d@0021400@TA2@T0T@290E4
0b@6A08T14@012A4A2@3A003S4A400=400@TA4A40R@5A08T2D@290940b@=A08T00=494@05T@290i4
00<TA4@07T@00fQ4A003A0=X00A4J4AX3d@00fQ4A00TA09X0T@00fQ4A002J004A6QXA0EX0T@2J007
R6R8S<c@d@08m@05nOGjmOT04OX2n@;j0_T00oGjnP02nP05nOGelOD00]02d@:/00b8[:b/S:c<dO7@
mO44m@Cj0oD00oWjnP05nP07mOWemOWel@05[004d<c@d0?e0_T3nP;e00CjnO[k1?X00oojnP04nP03
nO[j00;i00?jnOX01OD00o7@d@02[006c:c<[8b80j`2S003R8b/00><0XP026R8R6Q4J4AX0T@00hQ4
J006A09X00B8J8R80X`00hQXS002A003J4A4009400<TA4@00T@=9005A2@T94@00b@3A0DT0T@290a4
1R@;A00494@T90I40R@5A0@T14@290M42b@3A00594A494@00b@2A0<T00A492@T0T@59004A2@TA08T
0T@69003A2@T00<T1T@00bA4A004A00394A400=40R@3A00394A400<T3d@00bA4A00=A0<T0T@00bA4
A008A00394A400i4000:A00394A400E400<TA4@02d@390A40R@2A00394@T008T0d@00bA49002A004
94A490I400<TA4@00T@00bA4A005A00394A400940R@:A00394A400<T3T@392A400<TA4@024@00bA4
900LA007J4AXA6Q4J006A003J4A400U400=XA4@014@00fQ4J005A003J4A400e400HTA4@TA6P7A0EX
00E4J4AXR002A0AX00><[=000]44m@05nOGimOT00_D3nA3j0_T00o[inP03n@Gj0oD01]7@d=2/S0:8
00F/R8R<c002d004lM3ad@Ce00?in_X01OD5nP03nO[e00Ge0]000lb/d002c004d=7en@Kj0oD@nPSi
0_D2l@03dM3@00:/00?@[:`00X`00jb<S003[004R:b/S0N800IXA4A4J4@2J0M400=XR6P00hP00jc@
R002J09400=XA4@01d@49003A2@T00PT14@2909400@TA2A422@:A00394@T00<T14@290A40R@00d@T
9005A0<T1T@2909400<TA2@00b@5A08T00=492@04b@00d@T900690940b@2A08T00A492A42R@00d@T
A003A00494A4909400@TA2@T1d@00bA4A004A00494@T921400<TA4@00R@JA0002D@290A400<TA4@0
1T@01BA494AX00M400<TA4@014@490I400<TA4@00T@00bA4900:A00394A400]400<TA4@02d@01RA4
A2A490Q40R@3A0<T5T@00bA4A00291=40R@3A003J4A400Q40R@00d@TA007A0=X00A4J4AX0T@3J1Q4
00=XA4@034@00fQ4A005A003J4@T00=400=XA6P00d@00fQ4J003J09426P2[005d?7emOT00_D01?We
mOT2m@03nOGe00;i3oX3n@?j00?enOX01OX3m@;A00B/R8R80X`018R<R:`3d003dO7e00?e0_T00o[i
m@04m@03nO[j00?j0_T5m@;A1M000o7em@07nP;e4?X2n@04mOWinP?i0oD01?7AlM03c0B/00K<[8b/
S:`3S003[8R800B81FP6A003J4A400940VP01Hb8R8R<00:814@01FQ4J4AX00E412@00d@T90039003
A2@T008T00E494A49005A00494A4A0<T00=494@00T@00bA4A009A08T00=492@00T@00bA4A002A003
94@T00@T00=492@00R@7A0<T0T@59004A2@TA0/T00=492@01R@2A18T0T@012A494@<9005A2A494@0
0R@3A08T1d@00bA4A00CA003J4A400i400@TA4@T14@391=400<TA4@01D@001=400<TA4@014@290Q4
00<TA4@01T@290I400<TA4@03d@00bA4A009A0<T1D@00bA4A007A00394A4008T1T@290A40R@eA09X
64@00fQ4J003A09X44@291Y400EXA4B/J006A004J4AXA0=X00E4J6QXA005J003A6R800:/00GAmOGe
n@03m@06n_WinOGi0_D2nA7j00?in_X02OX00oWjm@02m@04d:b/R0:<0Z`00hb/[003d003dOGe00;e
0_X00oWem@03m@03nO[j00Cj0_T5m@Ca00?@dM401OD5nP03nOGj00kj0oT00oGin@02n@Ge00Kad=3@
c=0<[0:<00B/S8R80X`00hQXJ002A09X00=4J6P02D@028QXS8b8J8QX0d@018Q4A4@2J0=412@3A0LT
00I492@TA2@5A00394A4009412@3A00394@T00A40R@01T@TA4@TA0PT1T@490940R@7A00694A4A2A4
1b@2A0@T00A494A40R@01D@TA2A400DT00=492@042@4A0lT0d@290=40R@5A00394A400940R@4A0<T
8d@012A4A2@<A08T00=492@00T@00bA4A005A0002d@00bA4A005A08T0T@00bA4A002A00494A490=4
00<TA2@014@01RA492A490A400<TA4@03T@00bA49007A0<T00A492@T1T@00bA4A005A08T14@29003
A2@T00=400DTA4A4900DA00394A401i400=XA4@01T@00bA4A00>A0=X1D@00fQ4A00>A00394A401Q4
00=XA4@014@2J003A6Q400A416P2A0AX00U4R6QXR8b/d?400oD00oWenP02n@05n_GinOD00oT00o[i
nP0OnP04nOGed@?@1J`01=3<d?42m@;i0_X2n@03mOWj00Oj0_T8m@03lOGA00Ce00CamOGi0oX01?We
nOD5nP?i00CjnOWj0_T01O[imOWe00;i1oD02=7@d=3<d8b/0/`00jb<[007[004R8b8S0:80VP4A003
J4AX00=400<TA4@00T@2J0:800YXS8QXA6Q4J8Q40VP6A0<T0T@89003A2@T00DT0T@590=400@TA2@T
0d@00bA4A002A10T0T@012A494@29003A2A400<T24@29003A2@T00dT00E492@TA0079005A2A494@0
0R@2A0XT00=494@00T@59005A2@T94@032@00d@TA002A00394A400940b@5A0<T0T@290M400<TA4@0
3D@00fQ4A005A00394A4009400@TA4@T3D@01RA4A2A490M4000;A00394A400I400<TA4@03T@012A4
A6PKA0@T34@291A40R@014@TA2@?A003J4A400E400EXA4A49006A00394A4019400<TA4@064@016Q4
A4@2J1M40R@EA003J4A4009400=XA4@00d@00fQ4A002J006A6Q4A6Q40VP00dAXA007J006R8c<d?7e
0_T00oGin@02n@05mOWinOX00_D00o[inP0RnP;e00CadM3@0l`01=3<[=02m@04nOGinP;i0_D:nP05
mOWemOT02OD01_WelO7en@?j00?imOD01?X01oWjmOGjnOD00_T01OGimO[i00;e0_T4m@05lOGed?40
0]001<b/[:`2d004[8b/S0>/0h`00hR<R002R0=X00=4J6P00T@00fQ4A007A003J8R800:800B<R6QX
0T@2J003A6QX00I41b@00d@T900390941R@3A0@T0d@490=400<TA4@00R@014@T94@690941B@00d@T
90039004A2@TA0DT1D@39004A2A4A0XT0d@390941R@5A0<T0T@;90=400@TA4@T0T@00bA4A0039094
00<TA2@012@01D@T94@T00M400<TA4@014@00bA4A003A08T1T@00bA4900:A003J4A400I40b@4A0@T
0T@00bA4A006A004J4@TA08T00=494@01D@1J0004T@00bA4900CA005J4A4A2@05D@00bA4A00290I4
0R@6A00394A400M400<TA4@02T@491A400<TA4@014@00bA4A004A0<T4T@491M40VP2A0AX0T@00fQ4
A00@A00394A400E400=XA4@044@3J0E400=XA6P024@00fQ4A002A09X00E4J6QXR002[003dOGe00Ci
00?jnOD01_T00oGinP0InP03nO[j00Oj00?imOD00_D01=7@d=02d@03d?7e00;e00CimOWi0_D00oWj
nP08nP03nOGe00Ce00?in_X00_X00oWjn@04m@06nO[jn_We0_T3nPCi00?enOD00_D00oWem@02n@Oe
0_43m@04lM3@c0;@00B/d=3<0X`4[003c:b<00B80fP00hQXA002J004A6Q490Q400=XR8P016P2A003
J4AX00Y45B@014@TA4@390A40b@3A00394A4014T0T@00bA4900390=41b@3A00394@T008T0T@00bA4
90029003A2@T00<T0T@2909400DTA2@TA00290I40R@01D@T92A400<T00=492@012@6A00494@TA0TT
0T@290=40b@?A00394A401i400<TA2@00d@00bA4A004A00394@T00Y40R@00d@TA005A05X000:A003
J4A4009400<TA2@00R@4A00394A401540R@=A08T1D@00bA4A004A00394A4009400@TA2@T64@012A4
A4@290M40R@01D@TA4@T00I40b@`A00394A4009400=XA4@014@016Q4J6P2A003J4A400940b@9A005
94A4A2@05D@01FQ4A4AX01A400=XA6P016P024AXJ6R8S<cA0_D00oWjn@02nP;i00?jnOX00_T00oGi
nP0SnPCi0oD01_7Ad?7Al@?e1OT2m@Wj0_T6m@03nO[j00Gj00?imOD00oD01_Wjn_[im@;i0oX4n@03
n_Wi00?i00?enOT01oD00o7em@03m@04dM3@d0:/00?@[<`01Z`00lb<S004R09X0XP5J0E400<TA4@0
1D@3J0=40VP00dAXA00290M400<TA2@04R@3A0DT00=492@00b@3A00394A4009422@014@T92@7A0@T
14@59003A2@T00HT1D@290=43b@6A00494@T909400<TA2@03R@01D@T92A400TT0T@290=40b@4A003
94A400E41R@4A0<T0T@012A4A2@FA08T00=494@00T@00bA4900290=400<TA4@01d@01BA4A4@T0094
000>A00594@T94@00R@2A00394A400=400<TA2@00R@01FQ494@T00a400<TA4@03d@3909400<TA4@0
3d@00bA4A006A00394A400940R@014@T92@7A08T1D@00bA4A00HA003J4A401m40VP7A0EX?T@01FQ4
A6Q4009X00M4J6QXA6Q400=X0XP01:camOD2nP;i0oX00oWjnP02nP04nO[jnAGj00?in_X02?X2n@04
mOWin@Ge00CAmO7a0oD01?WenOT3m@_j0_T2m@08nOGenOGin_T2nP03nOGe00;e00?in_X00_X01?We
nOT2nP04nO[jn@;j00Kin_[jnOD4n@Ge0]44m@05lM7@dM001:`00lb/S002[006S:b<S8QX0hP01FR8
J8QX00940VP4A08T1T@2J003R4AX00=X2T@;90942R@2A0PT00=492@00T@D909400@TA2A40b@4A004
94A4A08T00A492A412@2A00394@T00@T00A494A442@5A08T14@00bA4900490E400@TA4A43B@4A003
94A4008T14@00fQ4A006A00394@T00E400DTA4A49002A00394A400M400=XA4@034@00bA49002A006
94A494@T1T@290A400<TA4@01d@001M40R@4A00494A490U400<TA4@03d@00bA49006A00594A4A2@0
0d@390a400<TA4@01T@00bA4A005A0<T14@012A492@3A00494@T911400@TA4@T14@00fQ4A006A08T
7T@00fQ4A003A09X0d@00fQ4A005A004J4A4J0e400=XA4@024@00bA4A009A00394A400=40VP6A003
J4AX00=X0d@3J006A6R8[8c@0oD01?WjmOD2nP06nO[inO[e3OX00oWjnP08nP03nO[j00Oj1?T00oGi
m@05m@07dOGelOGAl@02m@03n_Ge00;e3oX00oWen@03m@05lOGemOT00_D00oWem@05nP04nOGem@;i
00GjnO[jn@02nP03nO[i00?i00?jnOD01OD3d009nO[emO7@dM3<00F/00><c:`01:`2R007S8R8J8QX
R002J003A8QX009400=XA2@00R@6A003J8QX00IX1d@29003A2@T00HT0d@59003A2@T00E412@2A003
94A400A40b@00d@T9004A0PT0d@012A494@290I400<TA2@014@00bA4900490940R@2A08T14@69007
A2@T94@TA00290Q400<TA4@014@590940R@4A08T0T@390=41B@<A00394A400A40b@4A00394A402m4
00=XA4@03T@001=400<TA4@00d@00bA49008A00394A401a400LTA4A494@T00=40R@=A08T1d@490=4
12@2A08T24@012A494@29003A2A400Y412@=A08T8T@2J004A6Q4J0U400AXA4AX64@290m40VP8A004
J4AXJ0=40fP00dAXJ002R005[=3emOT00oX3n@03n_Wj00;i9OX3n@;e00?imOD00oD01?7elM48m@gj
00Cin_Wi2OD00oWem@03m@Gj2_D6n@;e1?T3m@07lM7@d=7en@03m@;A0m06[003S:b/00:<1HP3J004
R6QXJ0:800AXA6QX0b@7A0IX00=4J6P00d@590941R@00d@TA004A0HT0T@00bA490049005A2@T94@0
1B@2A08T00=492@00R@00d@T90029003A2@T00I40b@5A0<T00A494A43b@2A0HT00=494@022@00d@T
9005A0DT0T@990A40R@2A0`T00A494@T2T@01FQ4A2A4008T1D@00bA4A002A003J4A401=400<TA4@0
2D@00bA4A006A00396QX009400@TA4AX1T@190540D@000M400<TA4@00T@290I400<TA4@034@00bA4
A00DA00394A400]400<TA4@06T@390M400DTA4A4900:A00594@T94@00R@014@T94@390E400<TA4@0
3D@00bA4A00CA00394A400U400=XA6P04D@00fQ4A00SA003J4A4009X0T@3J0=41FP2A0IX00B8S:cA
0_D00oWjnP03nP03nO[i02_j00?imOD01_D00m7em@03m@05nOGemOT03oX00oWem@05m@04lM7en@Ge
00?in_X00_X5m@03nOGi017e0]000jc@l@02m@04nOGed@?@00R/d:b/S:b<R0><0hP2J003R6Q4009X
18P01FR8J6Q4008T14@8J0:80VP01TAXA4@TA0PT00=492@014@<9006A2A494@T0T@01bA4A4@TA2@0
0d@49004A2@TA08T0d@012A4A2@2A0<T00=492@00b@01T@TA2A4909400<TA2@01B@00`0T90029003
A2A400LT00=492@03R@00d@T900?90A432@2A0DT0T@290M400AXA4@T1d@391U400<TA4@04D@01BA4
A4AX00940R@6A08T0T@000Q400<TA4@00T@00bA4A005A08T34@290m400<TA2@014@012A4A2@DA003
94A400i41B@6A0@T3d@00bA490029003A2A4009400<TA4@04T@00bA4A009A003J4A400M400<TA4@0
0T@2J0E40VP4A003J4A4021400<TA4@04D@2J0A40fP014AXA4@9J0:800><d?D00_D00oWjnP03nP;i
;OX2m@05nOGemO402_D00oWjnP0=nP03nOGe00Ge0m000oGin@04m@06nO[jn_We0_42m@03nO[e00;e
00Oad=3@dM3A00;e00?@lOD00_D02?7@d=3Ad?Gi0oD2d@>/00C@[:b80j`018R<S8`4R003A6R800=X
00>8[8P00fP4A00394A400E400N8J6R8J8R<00A400<TA2@00b@00`0T9004900402@TA08T00A494A4
2R@2A00394A400U400<TA4@00R@00d@T900790=40b@00dAXA00590I40b@00d@T90099003A2@T00DT
00A494@T0T@69003A2@T00940R@5A0@T00=492@00b@2A08T0T@79003A2@T00<T2d@00bA4A00<A08T
0d@00bA4A00?A00394A400=400=XA4@04d@012A4A2@2A003J4@T00Y4000FA00394A400Y400DTA4A4
J00<A0@T0T@00bA4900290Y400<TA4@044@290I400@TA2@T1D@01BA492A4008T0d@290Y40R@2A003
94@T009400<TA4@014@00fQ4A00BA003J4A400i40R@8A005J4A4A6P00T@016Q4A6PBA003J4A400U4
0R@3A003J4A401A400=XA6P00d@01FR8J4AX00940VP2R005d=7emOT01?X2n@05n_Gjn_T01?X00oWj
nP0;nP03nO[j00Gj00?in_X01OX01?Wjn_T4nP?i1oD01_[emOWen@oj0_T2m@04nOGem@;a0]000m7e
n@04m@05nO[jn_T00oD02=7enOGimO7e0m02c0;@00?a[=000oD01_7@d:c@l@;e00gjnOWed:c@[<b/
S8R<00:/00F8S8b<R005J0>800EXR8R8A002J0A400@TA2@T1D@2J0>80VP4A0TT00<092@01R@014@T
94@;9003A2A400I400<TA4@014@390940b@00d@T90049003A2@T00=41R@4A08T00<094@052@4A0PT
00I492@TA2@3A0DT00=492@00R@02D@TA2A494@TA0029003A2@T00TT0d@00bA4J002A08T1d@00fQ4
A002A004J4@T939400=XA4@014@00bA4A005A09X0D@000a400<TA2@014@01BA4A4@T00A400<TA4@0
14@00bA4A003J0]400<TA2@01d@012A4A2@KA00394A4009400<TA2@01T@39003A2A4009400<TA4@0
4d@29003A2A400E400=XA4@014@2J1a41R@2A004J4AXJ0=400=XA4@034@00bA4A00AA00394A401E4
00=XA4@00fP2A09X00I4J6R8J4@5J003R8c<00Ce1OX2n@Cj00?in_X04?X00oWjnP0>nP03nO[j00;j
00?imOT03?D2nA3j00?imOD01OD2c0;@1_D01?Wjn_T6m@03lOGe00;e0_400lb/S003[004c=3@[0C@
00K<[=3AmOT3nP04mO7<d0;<00>/R8`00j`01hR/R8b8J4@00VP02dAXJ8QXS8QXA8QX00941B@2A006
94A4A6R816P018Q4J4@49003A2@T00hT0d@:90M400<TA4@014@290A42R@00d@T90059003A2@T00<T
0d@7909400<TA2@02B@01D@TA4@T009400<TA2@03B@014@T94@2909400<TA2@012@00d@T90029003
A2A400LT00=492@00b@2A0HT14@00bA49003A00394A4009412@7A08T1T@00bA4A00;A003J4A400M4
00<TA4@00d@290I40R@9A05X0D@000e40R@4A00394A4009400<TA4@01T@00bA4A005A003J4A400=4
00<TA4@02T@01bA4A4@TA2@01d@00bA4A00<A003R4A400I40b@00d@TA008A00494@T90Q400@TA4@T
1D@00bA4A00491a400=XA4@03D@290=400@TJ4A40VP2A005J4A4A6P03D@00fQ4A00GA003J4A400Q4
0VP3A004J4AXJ0=41VP2A0MX00>8S=001?DNnP03nO[j00kj00?in_X00_X2n@_e1_T?nPGe00?ad<`0
0Z`00m3am@02m@;a1OD2n@?e00?AmM400_400m6/R002R0:<0Z`018c@d=42[008R:b<d=7en_T2nP;e
00c<d:b/R6R8S:b<R6P4R09X14@00hQXJ004R09X0T@00bA4A004A09X1XP00fR8J002A0`T00=492@0
1B@2A0@T00H092@TA2@2A00394A400940R@6A0@T0d@490940b@3A0LT0d@00bA4A00G90E412@2A0DT
00=492@01B@7A0HT0T@49003A2@T008T00=494@01B@00d@T90029003A2@T00<T54@00bA4A003A0<T
00=4J6P00T@00bA4A00DA0<T00A494A40b@2A00394A4008T2d@0011400@TA4@T3d@00bA4A00HA003
94A4029400<TA4@01T@00fQ4A00@A00394A400=40R@00d@TA00CA003J4A401M40R@9A0AX0d@00fQ4
A003A004J4A4J1e400=XA4@01T@016Q4A4@3J003A6QX00E400EXA6QXA004J003R6QX00=X00>/S=00
0oD00oWjnP0LnP03nO[j01?j0_T00oGim@03n@?e00KimOWimOX2n@gj00?in_D00_D00o7el@02d0>/
00?@dOD00_D00m7@m@03m@04nO[jnP?e00Gad<c@[003R0:/00J<[:b/d<`3[0;@00?amOD00_T2m@07
dM3@c:b8S002R004S8R8R09X0XP2J003A6Q400AX00B8J8R80VP9A09X0hP016R8R8P2J003A2@T008T
0T@590940b@00d@T9005909400<TA2@012@8A00394A400I40b@01D@T94@T00940R@:A0@T00A494A4
0b@2A0@T00=492@022@2A08T0d@00bA49002A00394A400DT1D@29003A2@T00Q40R@2A0<T0T@59003
A2@T00XT14@590I40R@2A004J4@T90M400<TA4@02D@00bA4900JA08T34@016Q4A2@2A00054@012A4
A2@3A00494A491e40R@2A00594A4A2@024@00bA4A003A00394A400]412@2A00394A400E400<TA4@0
3D@00bA4A003A08T1T@290I40b@?A00394A401Q40VP3A09X34@00fQ4A009A003J4A400e400=XA4@0
24@2J003A6Q400a41fP01TAXJ8b/d0?e00?in_X02oX00oWjnP0<nP;i00?jnOX04?X2n@03n_Wi00Ki
0oD4n@03mOWi00kj0_T3m@?a0m03[003d?Ge00;e00?amOD00oD4nP;i0_D2d0F/00c<S=2/d<c@[<c@
dM06m@03dM3@00;@00>/R8`01XP2J0:80VP01DAXJ8QX00>81FP3A00494A490=41FP01HQXJ6Q400HT
14@290A42R@4A0<T2d@00bA4A005A0<T00E494A49009A003J4A400LT00=492@00R@2A0@T00=492@0
2B@2A08T0d@00bA490049003A2@T00A400<TA4@00d@00bA49005A00394A400=40b@3A00494A4A0DT
0T@012A492@3A003R6Q4009400<TA4@014@00bA49003909400<TA4@014@01RA4A6Q4J0Q400<TA2@0
4d@00bA4A00;A00494A4A08T00=4J6P014@001]400<TA4@044@00bA4A00CA00394A400A400<TA4@0
4T@390Q400EXR4A49005A00394A4019400=XA4@024@290a40R@8A00394A400A400<TA4@01D@01FQ4
A4AX00=400=XA6P00VP4A006J4A4J4AX14@00fQ4A004A003J4A400A400=XA4@04T@00fQ4J003J004
A6R8J0=400=XA6P00VP01TAXA6Q4J0940VP018R/[=03mA3j00?in_X03OX2nA3j00Oin_WimOWe00?i
00?enOD01_T00oGinP0=nP;i1?D01]7@c<c@S0>/00?@mOD01oD2n@Gj0_D2l@05dLc@d=401]000jc@
d002d@08mO7elOGad<`3d003[8b800:/00><J6P00fP2R004A6QXR0=X18P3J0e400B8J8R80fP2A0DT
1D@00bA4A003A0DT00A492A40R@4A00394A400M400<TA2@00d@00bA4A005A00494@T90=400<TA4@0
0T@2J0E400<TA4@00T@00bA4900490=41b@00d@T90079003A2@T00941B@=A0<T2d@290I41b@014@T
92@9A00394A400M400<TA2@02D@290=400@TA4@T4D@00fQ4A007A08T6D@001Q400<TA2@014@00bA4
A00<A00394A400940R@7A00594@TA2@01T@00bA4900291140R@2A0DT0T@00bA4A002A003J4A400A4
00HTA2@TA2@7A00394A4019400<TA4@014@00bA4A00290I40b@:A00394A400I400=XA4@00VP01HQ4
A4AX00U400=XA4@04d@00bA4A004A003J4A400E400=XA4@00d@00fQ4J002J004A6QXJ0Q400EXA4AX
A006J003R:cA00;e00?in_X07OX3nA;j0_T2m@?i00?jmOD01OD01?WemOT>nP;i0oD00o7Ad002[006
c:b/[8c<2_D2n@Kj00CimOGe0_401?GamO43d@?@00?AlOD00_D02O7edM2/c:c@[002S003[8b<009X
18P016Q4A4@4J003R6R800:80VP;A004J4AXJ0:80VP2A00394@T00<T00A494A412@3A0@T00=492@0
1R@2A08T00=492@014@490=40R@7A08T0d@00bA4A005A004J4A4A0<T0d@00bA4900<90=42R@5A0<T
1d@00bA4A003A00494@T90E400HTA4A494@490=400DTA2@TA00990=400HTA4@TA2@:A08T00E494A4
9004A00794@TA2A49006A00394A400U400=XA4@01d@290i40R@7A05X0D@001Q400<TA4@024@00bA4
A006A00394A400a40R@00d@TA00390A400@TA4@T44@390=40b@8A005J4A4A2@00d@290A41B@QA003
94A4009400<TA4@00R@5A00394A400E40R@4A09X00A4J6R<0d@4J0=400<TA4@05T@00bA4A00AA0=X
1D@01FQ4A4AX009400=XA4@00T@3J003A6QX00=X00><[?400_D00o[inP0MnPCi1OX00oWjnP09nPOi
1oD5n@Wj0oT00o[in@05m@03dM3<00:/00?<[:`00Z`00m3am@03m@03nOGe00;e0_T8nP;i1_D01O7e
d?7A00;a0oD2d007dM2/d:c<S003[0F80fP4A09X0hP01FR8S8QX009400=XA4@02d@2J0=41B@00d@T
9002A0<T00E494@TA005909412@<A00494A490A40b@6A08T3T@390=442@4A0TT00=XA2@012@00d@T
900390E400DTA4@TA0029003A2@T00A40b@00d@T90029004A6Q4A08T0T@490=40b@GA00394A400]4
00<TA4@01D@00fQ4A007A003J4A400=400AXA4@T4d@00fQ4A004A0002T@00bA4A006A00394@T00U4
00<TA4@02D@01BA494@T00Y40b@01T@TA2A490940R@2A0<T14@390=412@3A00394A400A40b@7A0<T
1d@00bA4900490m40R@DA08T24@00fQ4A003A003J4A4008T14@016Q4A4@2J003A6QX009X3D@01FQ4
A4AX00Y400<TA4@02T@00fQ4A007A0=X2T@00fQ4J006A0=X00E4J6R<c003m@;i3oX00oWjnP0=nP03
nOGe00;i00?jnOT00_T01O[inOWe00Ki0oD00oWem@07m@;i00CenOGi2_X00oWjn@06m@07lM7@d<b/
S002[003c=7A00Ge00CimOWi0_D;nP03nOGi00ce0]42d0B/00F<[:b/S003R0AX0T@2J005A6QXJ8`0
0VP2R0=400=XA4@00d@00bA4A00:A0@T14@012A492@6A00494@T90941B@5A003J8a400=400<TA4@0
0d@00bA4900490940R@?A00394A4008T00=492@00R@2A0`T00=494@00T@390943B@00d@T9002A08T
0T@012A494@590A41B@00d@TA005A00394@T00@T0d@00bA4A003A00594@TA2@00T@00bA4A008A0@T
0T@290U400<TA4@00d@00bA4A008A003J4A400I400@TA2@T3T@00bA4A002A0=X0D@001=400<TA4@0
2D@00bA4A008A00394A400e400<TA2@012@014@TA4@29003A2@T008T0d@29003A2A4009412@2A08T
1T@490E41B@5A00494A4A08T2D@2909400<TA4@01B@GA09X64@6J11400=XA4@01d@391A400EXA4AX
A003J0I400=XA4@01T@6J003R:ce00;e0_TNnP?i00[enOWin_WjnOGi0_D01OWemOWe00;i3OD3n@04
mOWjn@Sj1OT5m@03lM6/00;<0X`00jc<d003d@Ge0_X4n@gj00?imOD02?D01M7@d:b<00:/00>8[8P0
0j`2S003R6R800=X0T@3J005R8b8J8P00fP2A09X1d@00hQ4A002A003J4AX00=40R@7A0<T14@016Q4
94@290940b@00d@TA005A003R4A400Q400DTA2A49005A00394A400=400<TA4@014@59003A2A400@T
0T@490=41R@5A0<T0T@490943R@014@T94@79003A2@T00PT14@012A4A4@690=400=XA4@00d@00bA4
A0029003A2A400I400<TA2@00R@2A00494@T90I400<TA4@00R@2A003J4A400Y400=XA4@01D@00fPT
9003915400AXA6QX0D@000e400<TA4@014@00bA4A005A00394A400U400<TA4@044@29003A2A40094
1B@2A00394A400E400@TA4A412@2A0<T1D@39003A2A4009412@00d@T900390940R@2A08T0d@00bA4
A007A00394A4009400<TA4@044@00fQ4A00<A003J4A400M400<TA4@014@00fQ4A003A003J4A400Q4
0R@>A0<T1D@00fQ4A007A09X00=4J4@01D@00fQ4J00?A005J4AXA6P00XP00jcAm@02m@04nO[jnAcj
0_T2m@;i0_X5nAGe0_T2m@?i2OX00oWen@07m@07lM3@d:b8S003d003lM7e00?e1?T01?GinOT<nP;i
2OD00o7@d002[008S:b<[8R<[<`2S003R6QX009X00=4J4@00fP3R09X14@2J0Q400=XA4@00T@00fQ4
J008A00494A4A0HT1D@390A40R@00d@TA002A003J4A400Y400<TA4@00T@00bA4A00>A08T0d@012A4
94@29003A2A400@T00=494@00d@590Q40b@01D@TA2A400PT00=492@022@014@TA4@<90=400<TA4@0
2R@9A0@T0T@00fQ4A0039003A2@T00LT5d@00bA4A006A003J4A400A40R@6A003J4A400M40fP2A000
4d@00bA4A00DA08T2d@00bA4A009A00394A4009400<TA2@02T@00bA4A004A08T1T@29003A2@T008T
0T@2909400@TA2@T14@490=40b@6A0<T7T@016Q4A6P6A00394A400A400<TA4@01T@00fQ4A00:A003
94@T00i40b@6A003J4AX00Q400=XA6P00T@00fQ4A003A003J4A400e41VP00hb/d@03m@;i2oX00oWj
nP0AnP;i00Gen_WinP02n@04n_WjnP;i4oD01?WenOT9nP05nO[inOX02?D01M3ed<c@00:/0/`2d004
lOGem@Ci00CenOWi1OX00oWjnP03nP?i1_D01_7elM7@c0F/0X`01:b<[:`2R09X0T@5J004R8b8R0EX
4T@2J0a41R@3A0DT0T@590E40b@4A08T1T@00bA4A00;A00494@T90E400<TA4@00d@490940b@4A003
94@T00<T00=492@00T@390=41b@00d@T90029003A2@T00@T00E494@TA009909400<TA2@01b@3A003
94A400<T0T@01BA4A4@T00A40R@5A0DT00A494A412@EA003J4A400a400<TA2@02D@00fQ4A00<A000
5d@00bA4A00BA0@T2d@00bA4A004A00394A400A40R@5A08T3D@00bA49004A0TT0T@01BA4A2A400<T
00=492@01D@290M400<TA4@00d@00fQ4A009A005J4A4A2@05D@00fQ4A00:A0=X00=4J4@024@01BA4
A4@T00=400EXA4A4900AA09X00E4J4A4J002A09X00=4J4@01D@00fQ4A006A003J4A400M40VP00hS<
l@02m@?i2_X00oWjnP0CnP03nO[j00Gj0_T3nP;i4_D00oWjn@0:nPKi1oD3l@K@00?AlO401?D01?Wj
nOX3n@?j0_T01O[inOGi00ce00CamM3@0j`01m2/[:b<[8`00hP00fR<J00:J0B800=XA6P02D@00fQ4
A003A09X00B8A4@T1T@00fQ4A0029005A2A494@01b@2A0HT14@00bA4A005A00594A4A2@00T@01BA4
A4@T00E400@TA4A40b@00d@TA003A08T14@29004A2A4A0hT0T@00bA4A0029003A2@T00DT00=494@0
2R@6A00394@T00/T00=492@00R@3A00394@T00=40R@2A00794A4A2A49003A08T1T@890e400<TA4@0
1T@00fQ4A00@A00394A400Q400AXA4@T1D@00fQ4A002A0005d@00bA4A00DA00394A401Q400<TA4@0
4T@590=41R@00d@T9008A08T24@290e400=XA4@02d@00fQ4A00>A003J4A400i40VP3A0=X8d@00fQ4
J002A0AX1D@00fQ4A004A003J4A400Q400=XA4@00d@2J00:A6QXJ8R<dOGim@;i9?X00oWjnP03nP05
nO[in_T03oD01O[enO[i00_j0_T00oGin@08m@03lOGa00G@00C<d=3@1OD01?WjnOX2n@;j00?in_X0
0oT01_[imOWen@Ce00?amOD00oD2d003S:b/00B/00^<[8R8J8QXS6Q4J002R0=X00V8J6R8S8R<J4@0
0fP2A003J4A4009400=XA4@01D@00fQ4A009A0<T14@:90940b@=A004J4A4A08T0T@00bA4A00290=4
00<TA4@00b@2A08T2D@390940R@014@T94@590=40R@6A00394@T00PT00=492@01b@00d@TA005A003
94@T00A41b@00d@T900590Q40b@4A08T14@290=400DTA4@TA00490U40VPGA003J4A400A400<TA2@0
4T@00fQ4A001A0005d@01BA4A4@T00M400<TA4@024@00bA4A002A00394A401A400<TA4@024@00bA4
A003A00394A4009400DTA4A49003A0DT00=494@06T@00bA4A00RA003J4A400e40fP3A0AX00=4J6P0
4d@00fQ4A005A09X0T@01VQ4J4AXR0=X00=4J4@034@00fQ4A00?A09X00>8[=000_D2nBgj1?T@m@;i
2_X01?WjnOX3n@_e0m46d003dOGe00;e0_T00o[im@03n@Gj00Cin_[j3?D00o7@d004[004S:b<[0:8
00><R8`00VP00dAXJ005J0N816P3A003J4A400Y400=XA6P01d@01FPTA4@T00E40b@00d@T9005A003
94@T015400<TA4@014@290A400<TA4@00R@01D@TA4@T00Y40R@014@T92@2A0LT00=492@00R@2A003
94@T01HT00=492@00d@00bA4A004A14T0d@012A492@3A08T00=492@03d@29003A2A400A400<TA4@0
0T@2J1I400=XA4@014@3909400=XA4@024@2909400=XA4@00T@000m400<TA4@07d@00bA4A00MA005
94A4A2@01T@00bA4A004A0<T1D@293=40R@8A00394A401E40VP00dAXA002A003J4A400A400<TA4@0
24@3J003A6Q400=400=XA4@014@2J09416P00dAXJ002J0Y400=XA4@01T@00fQ4A008A09X00B/d?Ge
0_TYnP05nO[jnOX00_T00o[in@02m@03nOGe00Ke0oT00o[inP05nP;i1OX00oWjn@02n@03mOWe00Ke
00CamM7a1]000lc@m@04m@04n_Wen@;e0_T01?[inOX3n@_e00?AlM401:`00hR<[002S0:800V<R8aX
A6Q4J8P00fP8R0=X1D@00fQ4A003A003J4A400Y40R@3A08T00A492@T0d@39004A2A490E400<TA2@0
2d@390M40b@3A00494@T90=400<TA4@00d@00bA49007A0HT0T@69003A2@T00=40b@014@T94@<9003
A2@T00HT00=494@00T@2909400DTA2@TA0079007A2@T94@TA0039003A2A400=40R@7A00394A400U4
0b@7A00394A4025400<TA4@054@001A400<TA4@074@00bA4900?A003J4A400Y40R@AA00594A4A2@0
1d@00bA49004A08T0T@00bA4A002A08T14@00fQ4900?A08T1D@390]400EXA4A4J002A00394A400U4
0VP5A003J4A400U400=XA4@01D@3J0E400AXA4A40VP00dAXJ00:J1=40VP5A003J4AX00=400AXS<ca
0_D00oWjnP0XnP05nO[jnOX00oT00oGim@02n@Ge0oT00o[inP07nP;i00Cen_[i0_X01_WjnOGim@;i
1OD00o7em@02d@04d=7ad0;<0m04m@04nOGen@;e00?imOT01?T:m@;a0_D2d0:/00F<[8b<[004R003
S:aX009416P00dAXR002R004[8R8S0AX5d@01:a492@3A00394A4009400<TA4@00R@:A00394@T00Q4
00AXA4A40R@3A00394@T008T0d@69003A2@T00Q400<TA4@00d@39003A2@T00DT1d@00bA4A0029005
A2A4A2@00d@:90941R@2A00394@T00M41B@00d@TA0029004A2@T90=40b@00d@TA00GA00394A4008T
0T@00fQ4A005A09X00=4J6P044@00bA4A00OA0007T@00bA4A00CA00394A401]400<TA4@00d@00bA4
A00:A0<T0T@00fQ4A004A00394@T00A40R@00d@T900<A00394A400i40R@4A00394A4011400=XA4@0
34@00fQ4A00DA003J4A400a40VP2A09X00M4J6Q4J4AX019400AXA6QX34@2R003[?7e00;i:?X00oWe
n@04nP03nO[j00Cj00?enOT00oT00o[in@08nP04nO[jn@Gj0_T01?[imOD2n@;e00?imOD01_D2l@05
mM3@d:`00/`00m7em@0Hm@03dO7A00;@00_<[:b<[8b8[8R/S004R003J8QX00=X00N8J8R8S8QX00:8
00AXR6QX1T@01BA4A4@T00a400=XA4@00R@00d@TA005A0<T1D@00bA4A003A00394A401A40b@00d@T
A00=A00494A490E40R@4A0DT00=494@01D@01RA492A490940R@00d@T90029003A2@T00<T00E494@T
A00590=40b@2A00394A400DT00E494@TA00290=40R@014@T94@49003A6Q400M400=XA4@024@012A4
A2@VA003J4A400=400AXA4AX2D@00bA4A002A003J4A40054000GA00394A400A400<TA4@03D@290E4
0R@4A08T00=494@04d@012A4A2@>A0<T0T@00fQ4A006A00394A400E40R@]A003J4A400Q400<TA4@0
2T@00fQ4A003A00494A4J0=400=XA4@00VP<A003J4AX00=400AXA6Q42VP<A00394A400I40fP3A005
J4A4A6P00d@2R003c?Ge00;i:?X3nA3j00?in_X02OX00oWjnP02nP03nO[i00Si0oD00oWem@07m@;a
0]400lc@[002d0;a6?D01O7ed<c@00>/0XP01Jb8R:b800:/0fP00hR<J002J004A8QXJ0B800=4J8P0
0hP01DAX94AX00=400<TA4@014@00bA4A005A003J4A400=400<TA4@00T@016Q492@3A08T00=494@0
1T@290E40R@3A0HT00AXA4A41B@00d@TA00290E400<TA4@00d@2909400<TA4@012@00d@T90049094
0R@2A0LT0T@29003A2@T009412@2A00394@T00DT0T@00bA4A002A0@T00=492@00T@00bA4A007A003
94@T00@T0d@01BA4A4AX00M400=X94@02T@01FQ4A4@T00M40fP9A004J4AXJ0a40fP5A003J4A400Q4
00<TA4@01T@001M400<TA4@02D@01BA4A4@T00e400@TA2@T0d@2909400<TA4@084@390e400@TA4@T
14@00bA4A00/A003J4A400A400=XA4@00R@EA003J4A400=X2d@00fQ4A005A003J4AX00=X00>8J6P0
0fP00dAXJ003A003J4A4015400=XA4@00T@00fQ4A004A005J8R8c=400_D00oWjnP0WnP03nO[j01oj
1oT2nP?i0_D2n@_e0_42d005c=3@lM406?D00m7ad002c003[<b/00F<00B8S8b<16P2R003J4A40094
0XP00jb<R003J004[8R8R0i400<TA4@03D@290A40R@5A00394A400U400<TA4@01T@490E400@TA2A4
0R@00d@T9006A00494@T909400<TA2@01D@00bA4900D9003A2@T00@T00=492@00b@3A0@T14@39004
J4A4A0<T00A492A40R@8A0TT14@01FQ4A4AX00=400AXA2@T3T@00bA4A007A0=X2D@3J003A6Q400U4
0fP3A003J4A401=4000<A00394A400U40R@9A00394@T00=400<TA4@03d@290Q400@TA4@T0T@00bA4
A005A00394@T00M40R@5A0<T2D@00bA4900290I40R@LA003J4A400Q40b@9A00394A400Y400=XA4@0
0T@2J1M40VP3A003J4A400=42VP00dAXA003A003J4A400M400<TA4@01T@3J003A6Q400M400QXR8R/
d?7jnDOj00?in_X00_X2n@03n_Wj00Wi0_D00oWem@02m@05nOGemO400_D01M3ad=3A00;@00Kad?7e
dO4Am@05dM3@[<`00Z`00hb8R002S007R:b<[8b8J005R09X0d@2R004S8R8R09X0hP01FQ4A4AX00M4
00=XA4@02D@00bA4A004A08T0d@39003A2A400e400DTA4A49002A0<T00=492@00b@00d@T900690e4
0b@7A08T14@99003A2@T00XT0d@49003A6R800<T1D@390E40R@00d@TA0029003A2@T008T1D@012A4
A2@2A0@T54@01BA4A4@T00A400<TA2@00T@290=400=XA4@03D@00fQ4A00>A003J4A400Y40VP7A000
54@00bA4A00;A00394A400A400<TA4@014@00bA4A00=A08T00Y494@TA2A494@T1D@00bA4A009A0<T
0d@590M40b@014@T92@6A00394A400E400<TA4@034@00fQ4A007A003J4A400E40R@6A004J4A490Q4
00<TA4@01D@4J1E400=XA4@01D@016Q4A6P2A003J4A400EX1T@016Q4J6P?A003J4A400M40VP2A09X
00B/d?GeC?X01oWjnOGin_T00_X3n@03mOWi00ke0_401=7adO48d004dO7em@;a2OD00m7ad002d003
[8b<00><00B/S8R/18P00hb/J004R004S8QXJ0:800N<R8b<R6R8009X9D@01BA4A4@T01A40R@5A003
94A4008T00A492A40R@2A08T3T@00fQ4A007A0`T0d@790940b@00d@T9003A0<T34@2909400<TA2@0
0R@2A00594A4A2@00T@00bA4A00290940b@=A00394A400A400<TA4@01D@00bA4A00290a400@TA4AX
6T@00bA4A00@A0006D@00bA4A00:A00394A400e400<TA4@02T@01BA4A4@T00U400<TA4@01D@00bA4
A002A0LT00=492@024@290=40R@7A00394A400=40b@CA0=X5d@00bA4A003A09X1D@2J003R4A40094
0VP9A003J4A400=400=XA4@01D@2J003A6Q4009400=XR6P01FP00dAXJ006A09X2T@00fQ4J00<A00:
J4AXJ8S<dOGimDgj00?imOT01?T00o[in@04n@;e00?imOD02?D02?7emOGAmO7A0]001<b/[<`2d@05
lM7AlM401OD01_7AdM3Ac0;@0Z`4R004[8R<[0:800=XR8`00XP2J004R8b<R09X00F<J8R8S002[003
R8aX009X34@2J1E40R@2A08T2d@00bA4A003A0@T0d@016Q4A4@590=422@6A00394A400E400HTA4@T
A2@2A08T00=492@01b@3A0<T00A492@T0T@39005A2A494@01B@2A0<T00=494@00d@290Q400@TA2A4
1R@2A00394A400940R@9A08T00=494@03D@00bA4A00:A004J4A4A08T2d@00fQ4A007A003J4A40094
00=XA4@01T@00fQ4A002A09X1D@001E400@TA2@T34@01BA4A4@T00i400<TA4@024@02BA4A4@TA2A4
900BA00394@T00DT00=492@01D@490=412@00d@TA002A00394A400941B@2A00394A400e40fP9A003
94A400m40fP6A003J4AX009X14@3J0E400=XA4@014@00fQ4A005A0AX0T@00fQ4J003A0=X00=4J4@0
4T@00fQ4A00>A09X00>8[?400_D00oWjnP15nP03nO[j00;j1?T01OGinOWj00;i00CenOWi0_D00oWe
m@0=m@;a00?Ad=000/`00hS@d@03d@08d?7@dM3AmO45d003c=3@00><0XP02:b8R8R<[8b80X`00hQX
J002R0:<1hP3S005R8b8R6P00T@01FQ4A4@T009400<TA4@014@290]400<TA4@00T@49003A2@T008T
00=494@00d@290E41B@5A003J4A400DT0d@790E400<TA2@00T@00bA4A004909400<TA4@014@99003
A2@T010T00=492@00b@3A0@T14@01RA4A2A490940R@01D@T94@T00940b@2A0LT2D@00bA4A00BA003
94@T009400<TA2@01d@00bA4A00GA003J4A401=40002A003J4A4019400@TA4@T34@00bA4A007A003
94A400A400<TA4@00T@00bA4A002A0<T1D@00bA49002A00494A4A0<T00E494@TA00290E40b@3A0<T
14@00bA4A004A00594A4A2@00T@00bA4A005A00694@T94@T<d@00fQ4A002J003A6Q400940VP00hQX
A003A003J4A400I40VP2A004J4A4J0=400EXA4AXA002J0940VP2A09X1D@00fQ4A00:A09X3d@01FR8
J8cA00;e0_U2nP03nO[j00Gj00?in_X01?T01O[inOWe00?i00GjnOGim@02n@Ce00?imOD01OD2l@;A
00?@[:`00Z`2d0;A00G@lM3@c003d006[=3@c=3<0Z`00hb8R003R004S8R8[0J80VP2R005S8R<[8`0
0XP02FR8[:b<R8b/R002A004J4A4A0HT14@490A400<TA4@00T@00bA4A002A0@T0T@490E400<TA4@0
0T@49003A2@T00DT1D@00bA4A005A0DT0T@5909400HTA4A494@790=400<TA2@01B@014@T94@O90M4
00DTA4A49002A0<T00=494@00R@2A00394A400DT2D@012A494@390]400<TA4@00R@;A08T2d@00fQ4
A00>A00394@T00U40R@3A003J4A40054000@A00494A490=412@;A00394A400E400@TA4@T14@01BA4
A2A400<T0T@29003A2A4008T0T@01BA4A2A4008T00=494@00T@290940R@01D@T92A400@T00A494A4
0R@00d@TA004A08T24@390I40R@HA003J4A400i400EXA4A4J007A09X0d@4J0A41fP6A003J4A400A4
1FP03TAXJ6Q4J4AXR4AXA6R84T@01FQ4A4B801140VP018R/dO42mDOj00Gin_WinP0Gn@?e00CjmOGi
1?D01=7ad=03c005dM3@d<`01m000lc@d003d0;<00B/S8R80X`01HS<[8b/00:816P01XQXR8b8J0N8
00>/d:`00XP5J0M400<TA4@00d@390E40b@7A08T1T@00bA490029003A2A4008T0d@39003A2A400@T
14@590=41b@2A0DT0T@00bA4A00290=41B@4A00494@T909412@00d@T900490=400<TA2@032@2A0<T
0T@290M400<TA4@00T@00bA4A003A00594A4A2@00d@3909400<TA4@02T@00bA4A004A00394A400=4
1B@3A00394A400E400<TA4@04D@00fQ4A00=A08T14@00bA4A006A0005d@00bA4900DA00394@T008T
0d@00bA4A004A00394@T008T0d@29003A2@T00U40R@4A08T0T@00bA4900390A40R@5A08T2T@390M4
0b@<A00394A400U400=XA4@04D@00fQ4A005A09X00=4J4@00VP01TAXA4AXA09X00=4J6P00VP00dAX
A003J09400EXA4AXA002J0940fP018Q4A6P2A09X2D@01FQ4J4AX00Y40VP>A09X00E4J6R8[004m@kj
0_TknPCi00?jnOT00_T00oGin@02n@Oj1?T00oGin@02n@Ge00GamM3@c002d005mM3@d<`00Z`01lc@
c:c@[<`00]001Jc<[<b/00:<00B/R8QX0X`2R005S8QXR6P01XP00fR8S002J003R:b800>/0X`01HQX
J6Q4009X14@00fQ4A004A08T1D@290=400<TA4@00T@00bA4A008A08T2d@7909400<TA4@00T@39094
22@3A08T0T@01BA4A4@T00E412@2A00394A400<T0d@49003A2@T00DT14@012A4A4@990=40R@5A003
J2@T00=412@;A08T00A494@T1d@00fQ4A008A00394A401m400=XA6P00d@00fQ4A00;A003J4A400M4
00<TA4@01T@3J094000]A0<T00A494@T0T@00bA4A003A00594@TA2@014@012A4A4@390E40R@00d@T
9002A08T00=494@00d@00bA49002A0DT0d@590]400<TA4@014@392e400<TA4@014@3J0940fP8A003
R6Q400Q40VP2A005J4AXA6P014@2J0I400=XA4@00VPBA09X0T@00fQ4A00<A0=X00><c?400oD3nP03
nO[j00Wj00?in_X0=OX00oWjnP06nPCi00KenO[in_T5nP03nO[i00Gi00?jnOT01_D3d003lM7a00C@
00J/c:c<[<`2d003[=3@00;@00B/c8b80Z`01HQXJ6R8009X00><[8P00XP00fR8R004R008J8QXS8R<
[8P2[0:800><J8P00fP014AXA2@8A00394A400A400<TA2@00d@00bA49002A00394@T00E412@4A08T
00=494@00d@49003A2A400940b@3A08T00=494@00R@2A08T0T@290=400<TA4@012@5A0@T00=492@0
4R@3A00394A400=422@3A00394A400E412@014@TA2@:A00594A494@00R@:A003J4A4009400AXA4@T
:4@00fQ4A00OA09X0T@000e400<TA4@024@00bA4A00<A00394A400=400@TA2@T0T@00bA4A004A005
J4A4A2@01D@00bA49002A00394@T00E412@3A00394A400A400@TA4A40R@;A0<T24@00bA4A008A003
94A401Y400<TA4@04D@00fQ4A005A0=X5T@00fQ4A003A005R6Q4A6P01T@00fQ4A009A09X14@00fQ4
A003A09X34@01FQ4A6Q400AX00J/c=7enOD3nD?j0_T01O[inO[i00?j0oT01?[inOX2n@[j0oT2nP04
nO[em@;i0oD03?7@dOGad?7@dLb/c0>/00C<d=3<1=001Jb8R8R/00:<18P01FR<R8R<00=X0XP014B8
R8P3S003R8b/00:<18P014AXJ6P<A00394A400A400HTA4A4J8P4A00394A400I400<TA4@00R@;A004
94@T90E412@2A0DT1T@00bA4A003A08T0T@59004A2@TA0`T0T@=9003A2@T00M400<TA2@01B@3A0DT
0d@00bA4900390A400<TA4@00d@00bA4A003A0<T9d@00fQ4A002A00394A400Y400=XA4@01T@00fQ4
A00;A00394A400M400=XA4@00T@001M400<TA4@01d@00bA4A003A00394A401a400<TA4@014@290A4
0b@014@T94@49003A2A400=40R@4A00394A400M412@LA00394A400e400<TA4@024@00fQ4A002A003
94A400I41FP00dAXJ005A00394A4009400=XA4@01D@00fQ4A006J1E40VP01DAXA4AX009400AXA4AX
0T@00fQ4A00;A0IX00>8[=000oD2n@gj0_TbnP03nO[i00Gj00?in_X01?X2n@;j1?T7nP05nO[inOX0
0oT00oGin@03n@Ge00KamOGedO42d003c=3<00;@00?Ad=000]000m7<c002S003R8b<00:<00V8S8R8
J8QXS8P00fP00hQXR002R003[8R800:800B<J6R81FP5A00396Q400e400@TA2@T44@00bA49005A003
94@T00940R@5A0<T00A492@T0T@39003A2A400U400<TA2@014@690=412@00d@T900690E400DTA2@T
A0089003A2A4008T00=492@01B@3A0@T14@590]400=XA2@00R@3A08T0d@290a400<TA4@00T@390a4
00<TA4@014@00bA4A00:A003J4A400i400=XA4@01T@00bA4J009A0005D@01BA494@T00M400<TA2@0
1T@00bA4A006A00394A401m41B@2A0@T14@00bA4A003A00394A4009400<TA4@00T@00bA4900290A4
00<TA4@0;D@00fQ4A00AA09X0T@00fQ4A006A09X0d@00fQ4J007J09400=XA4@014@00fQ4A00;A003
J4A400A400AXA4AX0T@00fQ4A00@A0AX00>8[=000oD00oWjnP13nP03nO[j00;j00?in_X00oX01oWj
n_[imOT01oX01OWjmO[i00;j0oT00oGin@02n@03n_Gi00We00CAlM3@0]401]3ad?G@d@;<00>/S8`0
0j`6S004J8QXJ0>800=XR8P00hP01VR8[8b8S0:800><A6P00fP00hQXA00LA00494@T90Q400DTA4A4
9003A00394@T008T00A492A40b@2A0<T00=492@00R@2A0@T3D@3909422@00d@T90049003A2@T008T
0d@690=400<TA2@00b@00d@TA0079005A2A4A2@00T@00bA4A00590e412@3A00394A400=40R@5A08T
5D@00fQ4900JA003R6Q400]400=XA4@00T@00bA4A003A003J4A400A4000CA00694A494@T14@01BA4
94@T00M400<TA4@05D@290I400<TA4@00d@390=412@3A0HT0T@00bA490039004A2A4A08T1T@290A4
00<TA4@03T@390i400=XA4@034@00fQ4A003A003J4A400A400=XA4@00d@00fQ4A00@A003R6Q400A4
00=XS8P024@00fQ4A003A09X1d@00fQ4A008A004J4A4J0i400=XA6P00VP2A004R:c@l@;e00?in_X0
9?X00o_jnP03nP03no[j01;j00?in_X00_X00oWjn@0<nP;i1OX02_GinOWjmOWjmOT2m@04n_WinP;i
00KjmOGimOT5m@0<lLcemO7ed=7ad?7A0Z`2S0>/28P2J004A6R8J0:800A4J6R80fP018QXR8`3R0A4
00>8A4@01D@00fQ4A003A003J4A400A400@TA4@T14@01RA4A2A490a40R@2A08T0d@390I400<TA2@0
0T@990Y40R@00d@T900>900302@T00@T1D@69003A2@T00DT0d@49003A2@T00940R@3A0PT1d@00fPT
9003A00394A400E400<TA4@00T@00bA4A005A08T1T@00bA4A006A003J4A400=400=XA4@01D@00bA4
9008A003J4A400M400>/A4@00d@00fQ4A00;A09X0d@00fQ4A004A00054@00bA4A00;A00494A492U4
0R@4A08T00M494@TA2A400@T0T@02BA492A494@TA00390I400<TA4@00d@390A400<TA2@01d@39114
00=XA4@07T@2J09400=XA4@04d@2J0E400EXA6Q4J006A003J4A401540VP?A005J4AXA6P00XP00jcA
m@03mD;j00?in_X01OX00oWjnP07nPGi1?X01?WenOD4n@?e1oT01?[inOT6m@04d?Gam@?a00?Ad?D0
0]400m2/[002[003R:b800:800B<R8R816P01HQXR8Q400=X00>/R8P00XP00hb/R002S004R6Q4A09X
00=4J4@00d@00fQ4A00:A00394A400Y40R@2A08T24@490I400<TA4@01D@2909400<TA2@01b@9A0<T
00E492@TA0039003A2@T014T00E492@TA0029003A2@T00940b@00d@T90029003A2A400<T00=494@0
0d@390940b@7A003J4A400940R@5A00394A400a40R@6A00394A401e40fP7A00394AX01e40FP1A000
9D@00bA4A006A00394A400E400=XR6P02d@00bA4A008A08T24@590940R@014@T92@2A08T00=492@0
:D@016Q4A6P6A003J4A4015400<TA4@02T@3J004A6Q4J0I400AXA4AX2T@00fQ4A005A003J4AX00U4
00=XA4@014@00fQ4A00LA005J8R/[=401?D2n@?j00?in_X0>oX01?WjnOT<nPGi0_X01_WjnO[im@Ci
00CenOGe0_X01?WjnOT2nP?i00?enOD00oD01o7AlOGamM400_42m@05dLc<S:`00XP00jb<S005J003
A6QX00IX00J8J6QXR6P2R006[8QXJ8QX1D@2J1a41B@00d@TA002A00394A400=40R@2A00794A4A2A4
9007A0DT00=492@02R@014@TA4@49004A2@TA08T0d@A9003A2@T00<T1d@00bA490069003A2@T00DT
0T@59003A2@T008T34@390I400<TA4@01T@01BA4A4@T015400DTA4A4900BA09X2D@00fQ4A003A003
J4A401M4000AA00394A400e400<TA4@04d@00jaXA009A00394@T01941R@3A0DT00E494A49008A003
94A400=400<TA2@00R@YA0DT00=494@014@00bA4A009A09X3D@016Q4J4@4J0=400<TA4@054@00hQ4
A00=A005J4A4A8P03D@01VQ4A6R8J0:<00?AmOD00oD3nCoj00Cin_[i1OX3n@Cj0_T6nP;i00GjmOWi
m@02n@03mOWi00?i0_X2n@;j1OT5m@05lM7alOD00_401_GalM7<d0:/00><R8`00XP00dAXR004J003
R8b8009X00>8J6P00VP4R003[8R800:80VP2A0AX0T@016Q4J6P8A003J4A400E400<TA4@01D@490E4
0R@4A0<T1T@290M41B@00d@T9009909400<TA4@012@2A0<T0T@00bA4900<9003A2A400TT1T@79094
00@TA2A412@5A00394A4008T00=492@00d@00bA4A009A08T1D@01BA4A4@T00=400<TA2@03d@290I4
00<TA4@02d@00fQ4J003J0Q400=XA4@01D@01BA4A4@T00I40b@:A00034@00fQ4A00RA00894A4A6Q4
R6P<A00394A401141R@2A00494A4915400=XA4@044@00bA4A00LA0<T0T@00bA49007A08T0T@00fQ4
A004A003J4A400I400AXA6Q40VP00dAXJ009A003J4A400E400=XA4@02D@00fQ4A00AA003J4A400]4
00AXA4A40XP00hc<l@05m@03n_Wj03kj00?in_X00_X01OWjn_Wj00;i00GjnO[jn@02nP08nO[jnO[i
mOX3n@0<mO[emO[enO[en_We0_T2nP?i0_D00oWem@03m@04lOGed0;e00?@mM000]002Jc<[8b/J8QX
A002J004R6Q4J0B800B/R8R80VP3R003[8R800>80fP01DAXJ4AX009400AXA4AX2D@2J003A2A400]4
0R@;A08T1D@490Q40R@2A0TT0T@01BA4A4@T00=40b@00d@T900290E40R@3A0@T0d@790940b@3A003
94A400DT0d@00bA4J004A08T00=4J4@014@29004A6Q490=400<TA4@024@00bA4A00=A00394A40094
00<TA4@02T@00bA4A00DA09X0T@00fQ4A006A003J4A400U40R@8A003J4A400M4000^A00494A490M4
00=XA4@01D@2909400<TA2@02d@290=40R@2A0<T0d@00bA4A002A00394@T00e400<TA4@03T@012A4
A2@2A08T6T@29004A2@T90E40R@:A003J4A400A400=XA4@04d@01FQ4A4AX00I400=XA4@00T@00fQ4
R00@A003J4A400]400EXA4AXA002J005R6R<c=401OD2n@?j00?in_X0=oX00oWjnP03nP;i00CjnO[i
1oX00oWjnP02nPGi00GjnOWim@02n@03mOWi00;j2?T01_GinOWen@_e00?adM000]000lb<S002R003
J8Q4009X0XP3J0B800MXR8R8J8QX00J800F<J6Q4J006A005J4A4A6P02d@29003A2A400A41b@7A003
94A400@T1D@00bA4A006A0<T0T@9909400<TA4@01D@29003A2@T008T0d@2909400<TA2@022@2A08T
00=492@022@00d@TA0059004A2@T90I400@TA4AX3D@00bA4A009A08T24@390E400@TA4@T0T@290I4
00DTA4A49006A003J4A400Q41FP2A003J4@T01i400<TA4@01D@001Y400<TA4@014@00bA4A00=A003
94A400E400AXA4AX0R@00d@T900JA00394@T00=40R@2A00394A400e400<TA4@05D@490U400<TA4@0
1d@00bA4A00?A00394A400Y400AXA4A40VP2A004J4AXJ0i400=XA4@00VP;A003J4A4015400=XA4@0
3d@2J005R6R<[?401OD5nPCi<oX00oWjn@09nP;i00?jnOT01?X01?Wjn_T2nP0;nO[inO[in_WenOD0
1?T01?[inOD2n@03n_Wj00?i00?en_D02oD3l@;A0]001:b8R8P2J003A6QX00AX0hP018aXJ6P2R09X
0XP2S0>800>/R6P00VP6A003J4A400940fP2A003J4A400Y42B@:A0<T1T@00bA4A0029004A6Q4A0@T
00=492@02R@5A0@T00=492@01R@00d@TA0059003A2@T00@T00E492@TA0039003A2@T00<T00=494@0
1B@014@T92@2A08T00A494AX3d@00bA49003A00494A4A08T1d@890E40R@2A00394A400I40b@7A003
J4A400U41FP3A00394A400I400<TA4@04d@00bA4A003A08T000CA00394A400Q40R@7A00494A490=4
00<TA4@044@29003A2@T009400DTA4A49006A00394A400=400<TA4@00R@2A00394A4008T00=494@0
0R@00d@TA005A08T1D@290i40R@2A00394@T008T0T@290=400<TA4@05d@00bA4A008A003J4A40094
00=XA6P00T@01FQ4A4AX009400=XA4@02D@01RA4A6Q4J0=400=XA4@02d@00fQ4A00:A00494A4J0]4
00=XA4@00d@3J004R:c<l@Ge00KjnO[jnOX2nC3j00?in_X03_X01?WjnOT4nP04nO[jn@?j0oT01_[i
nOWen@;e1?T01OGimOWj00Ki00GenOGen@02m@03nOGe00?e00?adOD00m401M2/S8b800=X00A4J6R8
1FP7R007J8QXR8b8[002R003S8R8009X00=4J4@00d@00fQ4A003A003J4A4009400<TA4@01d@012AX
A4@29003A2@T008T00=494@00d@01FQ4A2A4008T0d@01BA4A2A400@T14@2909400@TA2A42B@00d@T
90049003A2@T00TT00=494@05R@014@TA2@2A0@T0T@39003A2@T00<T14@012A4A4@39003A2@T0094
0b@7A0<T00A492A41B@01D@TA4@T00E40R@:A00394@T008T4d@00fQ4A00:A003J4A401i4000JA003
94A402M400<TA4@00T@00bA4A00=A08T34@00bA4A006A00694@T94AX0T@012A492@=A00394A400=4
00DTA2A4900:A003J4A400Y40VP2A003J4A400U400=XA4@01d@00fQ4A006A09X1d@2J003A2A40094
00=XA6P00VP2A09X14@016Q4A6P3A005J4AXA8P05D@3J09400AXA6Q40fP01Jc@lOGi00;e0_T2nP03
nO[i00;j00?in_X04oX00oWjnP0CnP06nO[jnO7i0_X2n@Oj00Kin_[in_T2nP03nO[j00Gj00oin_Wi
n_Wen_Wen_Gin_D00_T02OGjmOGjnO[im@02nP;i2OD02o7ilOGad?Gac:b<00:800><R6P00fP00hQX
J005J00;R6QX[8R<R6R8J8P00X`2[004S8QXJ0I400>8A6P00T@2J0E40b@9A003J4@T00=40b@;A08T
0T@59003A2@T00I400<TA4@00d@012A4A4@590=412@3A0<T00A492@T24@990940b@014@TA4@390E4
00<TA2@01d@290E400<TA4@02D@00bA4A002A00394A4008T1D@00bA4A002A0<T0d@290E400<TA2@0
0d@290I400<TA4@00R@4A00394A400=400=XA4@0<4@00bA4J001A000?d@390A400@TA2@T14@00bA4
A006A0<T00=494@014@00bA4A002A08T00=494@014@290M400<TA4@03T@00bA4900jA00394A40154
00<TA4@00T@3J005R6QXA6P01d@016Q4A4@2J1m400MXA6QXR8c@00Ge00?in_X00_X01_Wjn_WjnBkj
00?en_X00_X00oWjnP09nP04nO[in@_j0oT01O[inOWe00Ci00?enOT00oD6n@;j0_T00oGin@08m@03
dM3A00;@0Z`2S003[8R8009X0T@2J0941hP01hb8R8QXA6P00XP2S0:80fP6A003J4A400=400AXA4A4
1R@6A00394A400E40b@9A00394A400PT00=494@01D@290=400<TA4@00T@29003A2@T008T00=492@0
0b@2A0PT0T@29003A2A400TT0T@49003A2A400DT0T@59004A2A4A0@T00=492@00R@6A0<T0T@390Q4
0b@3A08T00=494@014@012A4A2@5A08T0d@290M400<TA4@0@D@1J054000lA08T00I494@TA2@2A0<T
14@00bA49007A08T1d@290A40b@4A0<T4D@00bA4A006A08T14@00fQ4A00`A004J4A490A400=XA4@0
0T@00bA4J00=A09X00B8J4AX6T@00bA4A007A003J4A400M40VP2R003[=3a00?e0oT2nP?i0_X00oWj
nP02nP03nO[j01_j00?kn_X06_X01?WjnOT;nP;i1?X6n@Ce00CimOGe1_T=m@;a00?@lM000j`2S0B8
00=XA6P016P2R003S:b800:800EXR8QXR004J0:800B<R8QX1d@00fQ4A002A003J4A400<T0T@590A4
00<TA4@00R@00d@TA00490E41B@00d@TA00490=40b@5A00394A400E400<TA4@00d@2909400<TA2@0
6B@2A08T00=492@00b@014@T92@5A00394@T00<T00=494@01D@690I41B@9A08T00=494@00R@3A003
94A4009400<TA4@00d@390A400@TA4@T2T@00bA4A003A003J4A400M400<TA4@0;T@002I400<TA4@0
14@290M400<TA4@00T@012A4A2@4A00494A4A08T0T@01RA492A490I400<TA4@00R@7A00494A4A08T
0T@00bA4900290=400@TA4A412@2A00394A4015400=XA4@04T@00bA4A00BA00594A4A6P00T@00bA4
A00BA003J4A400M400=XR6P00VP3A00394A400A400=XA4@01d@00fQ4A00@A003J4A400E400EXR6R<
d006m@05nO[jnOX01?T4nP03mO[j03;j00?in_X00_X2n@oj00?in_T00_X2n@04n_Win@;e00?imOT0
0oD2n@?e00?imOD02oD4d@06[8R<S:b80VP3R004J8R8J0R800><R4@01FP4R003S8QX00I400<TA6P0
0d@2J0A400<TA4@00b@:A0@T0T@00bA49002A00394A400<T00=492@04D@01BA4A4AX00M40b@3A08T
00=492@02R@00d@T90069003A2@T00<T0T@;90A41B@3A0HT0T@00bA4900290A41B@:A0@T1D@290E4
00<TA4@00T@00fPTA00<A00494A4A08T1D@00fQ4A00hA000<T@012A4A2@6A00494A490U400@TA2@T
0T@29003A2A400M40R@5A08T0d@590I40b@3A08T3T@00bA4A00<A005J4A4A6P024@016Q4A2@8A005
94A4A2@00T@016Q4A4@290i400=XA4@014@00bA4A00:A003J4A400=X0d@290]40VP3A003J4A400E4
00<TA4@044@01FR8R:c@00Ge00?in_X00_X00oWjnP0DnP04no[jobOj00Kin_Win_T2nP03nO[j00Sj
0_T00o[in@02n@06n_Wen_Gi0_D01?WemOT2m@03nOGi00Se00CilO7e0_401=7@dJ`2R008S8R8J8R<
R6P2R09X00>8J6P00VP00hQXR002R004J4A4J0>800=XR8P00XP00fQ4A004A00394A400=40VP2A003
94@T00@T00=494@01T@29004A2@T90A40R@2A00394@T008T00=492@01D@290a400=XA4@00d@00fQ4
A002A08T14@00bA4900490941R@00d@T900390940b@5A0DT0T@690940b@3A0@T00=492@00d@690=4
12@5A00394A400A40b@5A08T2d@00bA4A008A08T0T@00fQ490029003A2A401940R@=A003J4A400]4
00<TA4@014@00fQ4A004A000:4@00bA49002A08T0T@00bA4A0029003A2A400Y400<TA4@00R@8A003
94A400a400<TA2@00R@014@T94@29003A2@T00E40R@7A00394A400=400<TA4@014@291E400=XA4@0
0T@016Q4A2@2A003J4A400=400@TA4@T24@00bA4A00<A003J4A401I400=XA4@00T@00bA4A009A09X
1d@00fQ4A002A00394A400A400=XA4@024@01FR8R:c@00Ge00?in_X0@oX4n@?j0_T;nP?i00KjnOWj
mOT5m@03nOGe00;e00?imOD03?D00o7@l@04d006[8QXJ8b80X`00jb8[002R003J4AX00AX00F8S8R<
R003J0>800EXR6R8S002R0=400<TA4@014@00fQ4A003A0<T00A492@T1T@01BA4A2A400@T0d@39008
A2A4A2A494@490=400HTA4@TA2@3A00394A400U41R@2A0PT00A492A44B@2A0@T0T@00bA490069003
A2@T008T0T@69003A2@T00LT1D@490A400<TA4@01D@390A400<TA4@00b@00d@TA00=A00394A400M4
00<TA2@05D@00bA4A00AA00394A400a400<TA4@00T@1J0009d@00bA4A007A00394@T00]400DTA4A4
9003A08T00=494@02D@01BA4A4@T00I400@TA2A40b@2A00494A4A0<T0d@00bA4A005A00394@T00Y4
00<TA4@01D@00fQ4J00<A003[4A400]400<TA4@04D@3J0A400=XA4@03T@00fQ4A00FA003J4AX00E4
00=XA4@01T@00bA4A004A0AX24@016R8c=03m@03nOGi00Wj00?in_X02_X00o_jnP02nP03no[j02Oj
0oT00o[inP03n@_j0_T01?[inOT3m@;i1?D00oWem@09m@07dOGemO7ed@02l@;@00G<[:b/R002J0:8
0h`01HR<R:b8009X00><J6P01HP01FQ4J6R<00F800B<R8QX0d@012A4A8P6A0TT0T@390I40R@00d@T
9007A0HT00=492@012@3A0@T1D@00bA4A008A0PT0T@590=400<TA4@022@00d@T90029004A2A4A08T
0d@69004A2A4A0`T0d@59003A2@T00E412@4A00594A4A2@01D@290Q400<TA4@00d@49003A2A400E4
00<TA4@02D@00bA4A006A00394A401Y400<TA4@01d@00bA4A00;A00094@01BA494@T00Y40R@7A08T
0T@00bA4A006A00594A4A2@00T@01BA4A4@T00=400<TA4@00d@29003A2@T00=40R@7A00594A4A2@0
2T@00bA4A003A00394@T00]400=XA4@064@00bA4A01LA09X1T@3J003[=3e00;e1?T5nP;i00?jnOT0
??X00oWjn@02nPCi2OX4n@04mOWim@Ci00?enOD01?D01?WemOT5m@03d?GA00;A00Ked=7@dM04S003
J8R800B800R<R8R<R8b8J0F800=X[:`00XP00fR8S002R004S8R<[0:80T@2J0=400>8J4@014@29005
A2@T94@00R@2A08T1d@29003A2@T009400<TA4@00d@390=41R@00d@T9009A00394A4009400@TA4@T
0T@;9006A2@T94@T0T@012A494@49003A2A400<T14@49003A2@T00DT0T@012A494@890940b@3A0DT
0T@690e400<TA4@024@00bA4A009A00594@TA2@02T@29003A2@T01E400<TA4@00d@00bA4A00GA005
94A4A6P00d@002E400<TA4@034@29003A2A400=400@TA4@T4d@00bA4A004A00394A400E40R@00d@T
900<A00394A400i400@TA4@T2T@00fQ4A00OA0@T1D@00fQ4A007A003J4A400Q40R@PA003J4A400m4
00AXA4A40fP8A004J8R<[0?e1?T5nP;i00?jnOX0>oX2n@04n_WjnP?i00?jnOX02_X2n@03mOWi00?i
00GenOGen@02m@?i1oD00o7ed002l@03dO7@00;@0Z`2S0R800B/R8R<0hP01FR8R8QX00:800><R6P0
0VP00hb8S003S007R8b8J4AXR005A0=X00I494A494@39004A2A490940b@9A00394@T00HT00A492A4
0R@2A0<T00E492@TA0029003A2@T00940R@3A08T0T@00bA4J002A00494A4A0DT00A492@T0T@29004
A2@TA0@T00=492@00R@4A0<T00=492@032@00fQ4900;90941R@01D@T92A400@T14@290E400<TA2@0
0d@29005A2@TA2@00T@00bA49006A08T1D@00bA4A004A0<T0T@29006A2A4J4AX24@00fQ4A002A003
94A400=400<TA4@084@005A40R@<A00494@T90Y400AXA4@T24@00bA4A00eA0@T44@39003A2A401a4
00AXA4AX1d@00fQ4A002A003J4A400U400=XA4@00T@2J0U400F8[<cAm@02n@03n_Gi00Kj0_T00o[e
nP02nP03no[j00Kj00?kn_X01OX00oojnP02nP03no[j01gj00Gin_[inP02n@05n_Win_D01oX01?Wj
n_T2nP03nO[i00?i00?enOD01OD00oWem@05m@03d?G@00?a00G@mM7@c004[005S:b8S8P00X`018R<
[8P2S0B800B<R8R80X`3R007J8R<S:b<[002R004S8QXR0:/14@2J003R4A400A41R@014@T94@39003
A2A400I400<TA2@00R@2A08T00Q492A494@TA0HT0T@6909400<TA2@012@7A00394A400LT24@59094
0R@00d@T900290=400<TA4@02b@6A00394@T00PT0T@490E40b@00d@TA008A00394A4009400<TA4@0
1D@00bA4A00<A00494A4A08T0T@016Q4A4@290I400=XA4@01T@01BA4A4AX00M400=XA4@08d@002I4
00@TA4@T1D@00bA4A003A00394A400I400<TA4@00T@00bA4A002A00394A4009400<TA4@01D@01BA4
A4@T00A40b@014@T92@3A08T00=494@00R@2A00394@T00=400DTA4A49003A00394A400Y400=XA4@0
2T@00bA4A00IA0<T1D@290=400=XA4@04d@00fQ4A007A003J4A400Q400=XA4@074@00fQ4A005A008
J4AXS:camOT<nP03nO[j03Wj0_T2nP03nO[j00Cj00?in_X01OX00oWjnP03nP03nO[j00?i4?D3l@03
dOGA00;a00G@[<b<R002S006R6R8S:b818`3R003J8R800R80VP00hR<S003[004c8R<S0:800><R4@0
0d@00fR8R004A00394@T00DT00=492@00b@6A08T00=494@00T@00bA4A002A00494@T90942B@2A0LT
1D@49003A2@T009400<TA4@01b@9A0hT00A492@T0T@;909400@TA4@T0d@89003A2@T00@T00=492@0
0b@00d@T9004A00494A4A08T14@290I40b@00d@TA009A00394A400@T0T@01BA4A4@T00]400=XA4@0
7T@2909400=XA4@03T@001M400<TA4@01d@00bA4A008A00394@T00I400<TA4@01T@01BA494@T00I4
00<TA4@014@00bA4A003A00394@T00I40R@00d@TA0049004A2A490940R@00d@T9009A0@T1D@00bA4
A00LA005J4A4A6P03T@00bA4A005A00394A403A400IXA4A4R8`GA0AX00F/d?Gen@0ZnP03nO[j01_j
0_T00o[in@06nP;i00?jnOX00_X00oWjn@03nPCi4_D01M7ed?7A00;a0]001<b/[:`2R003[8R800:8
00><R8`00XP4S0>800><R:`00XP3S007R6R/[8b/S002c0:/00F<[8R8J002A003J8QX009X00=492@0
0T@39003A2@T00940b@3A00494A4A0<T14@290A412@7A08T0d@390I400<TA2@014@012A492@3A004
94A4A08T00E494A49004A003J4@T008T00=494@00R@2A10T00=492@01B@3A00394@T00PT0T@69003
A2A400TT00E492@TA0029003A2@T00<T00E494A49002A00394A4009400<TA4@00b@00d@TA0029094
0R@4A00394A400DT3D@00bA4A00=A00394A400M400@TA4@T34@016Q4J6P2A000;4@00bA4A00>A004
94A490Q400<TA4@01D@012A4A4@290=412@00d@T900290=40R@2A0@T00=492@012@7A00394A400I4
0R@NA00594A4R6P00T@290A400@TA2@T2d@00fQ4A005A003J4A400I400@TA4A40VP00dAXA004A003
94A400]400=XA4@02T@00fS@J00>A003J4A400I40fP01Jc@mOGi00_j00?in_X05?X00o_jnP0UnP04
nO[in@Cj00Kin_[in_T8nP03nO[j00;i4oD2d@04lM7@d0B/00B<J6R80Z`00hb/S003[003S8R8009X
00>8S8`00X`01Jb<S8R/00:<00>8S8`00Z`018b/[=03[003R6Q4009400=XR4@00d@39003A2@T00/T
0T@390940b@8A0<T1T@012A494@79003A2A401540R@00d@TA00690=400=XA2@012@3A00394A4020T
00=492@00b@3A0@T00=492@00T@:90I412@5A00394A400Q412@00d@T9002A00394A400940b@01T@T
92A490M400<TA4@00d@012A4A2@CA00894A494@TA2@=A003J4A40054000lA00494@TA08T0d@00bA4
A00?A00394A400=400PTA4@TA2A4909400<TA4@00R@3A00394@T00HT14@00bA4A005A00394A401i4
00<TA4@014@290i400<TA4@00d@00fQ4A00<A08T34@00bA4A00IA003S6Q4015400AXA4A40VP014AX
R<`2m@Oj00Gin_[inP02n@03n_Gj00kj00?kn_X00_X00o_jnP0BnP03nO[j00[j00?in_X00_T01?[i
nOT2nP;i00GjnOWjn@04nP;i0_X3n@;j0_T2m@04nOGen@Se00?AmOD00_401M7@dM3<00F/0XP00jb<
c003[0:<0j`018aXR8`2R004S8S<S0>800><[8P01j`01=2/[:`2R0=40VP2A003J4@T00HT00A492@T
0d@290=400@TA2@T0T@2909400=XA4@00d@00bA4A00290A40b@00d@T900490940b@;A00594@TA2@0
0T@89004A2A490940R@2A00594A4A2@00T@012A492@3A0<T00=492@02b@00d@T90059003A2@T00<T
0d@59004A2A4A0/T1D@390A400<TA2@014@00bA4A004A0dT0T@29003A2@T00940b@@A003J4A40094
00<TA4@03D@29003A2A400a400=XA4@00D@0041400<TA4@01D@00bA4A003A00594A4A2@034@012A4
A2@2A00394@T00U400HTA2@TA2@;A00394@T01540VP00d@T900EA00594A4A2@034@00fQ4A00YA09X
1T@00bA4A005A003J4A401=40fP01XR<[?7en@?j0_T9nP03nO[j03?j1OT00o[inP04nP04nO[inP;i
00CjnO[j1?T2nPGi3_D01?7elOD2l@;A00?@c=000j`00lb/S003S0B/00B8[:b/0X`018R/R8`3R005
S8R<R8`00Z`01HR/S:c<00:/00N<[8b/S8QX00=40VP3A0@T00I494A494@290A400<TA4@01D@29003
A2@T00M412@4A08T0d@490A40b@4A00494A490=41B@00d@T90079003A2@T008T00=492@00T@390=4
12@4A0hT00E492@TA0049003A2@T00DT0d@01BA492A400@T00=492@022@5A0DT00I492@TA2@3A004
94@T90941B@00d@TA00690940b@2A00694@T94@T3d@01BA4A4AX00=40VP8A003J4@T00Q40b@4A004
94A4J094000[A08T64@490Q400<TA4@044@2909400DTA4A4J009A00394A4029400=XA4@04T@00bA4
A004A00394A400=40RA<A003J4A400E40fP01XR<[=3en@Wj0_TinPCi1?X2n@Cj00?in_X01?T00o[i
n@03n@07n_WinOGim@02n@_e00?amO400_400m3Ad003d005c:b/[8`02j`4S003[8QX00B800B<[8R<
2J`00lb<[002[003J4A4009X00>8J4@00R@2A0<T00=492@00R@6A00394A400Q400<TA2@01D@00bA4
90049004A2A490A40R@01d@TA4AXA2@01T@00bA4A003A00494@T90943B@2A0@T00=492@00R@00d@T
90039003A2A400XT00<092@00T@490E41b@6A00394@T00<T00=492@01b@2A00494A4A0<T00E492A4
9002A00394A400A41B@3A00594A4A2@00T@39005A2@TA2@02T@2909400<TA4@01D@00bA4A00EA003
94A400m40009A003J4A400i400<TA4@03D@01BA4A4@T00I400<TA2@044@01BA4A4@T00E400<TA4@0
0T@00bA4A003A00594A4A2@00d@00bA4A007A00394A400E400<TA4@014@00bA4A009A00394@T01Y4
00<TA2@034@290=400<TA4@00d@00fQ4A00HA00394A400=400=XA4@0;T@3J005R8b/lOD02_X00oWj
nP05nP03nO[j02oj00Kin_Win_T8nP05nO[inOX00_T3nP;i00KjnOWimOT2m@;i1?D00oWem@06m@03
lOGe00?A1M000lb/[002[0:<00>/S:`00j`018b/S8P3S006R6R<[8R/0X`2R0:/00?<d=001J`01<b/
[8`2J003A6QX00:814@5919400<TA4@01T@012A494@490941B@2A0DT0T@2909400<TA4@02D@00bA4
A0099003A2@T00hT00E494A49005A18T14@99003A2@T008T00=492@00T@5909400DTA4@TA0059094
00<TA4@024@01FQ4A4@T00]400<TA4@01T@00bA49006A00394A400A40R@2A00394A400Q400<TA4@0
3d@00bA4A00=A000:d@00bA4A009A00594A4A2@03D@012A492@6A08T1d@01RA494@TA08T1T@00bA4
A00390m400<TA4@02D@291Y400<TA4@00b@5A08T0T@290=400@TA6QX7d@2J0i400=XA4@03d@00fQ4
A003A003J4A400Y400=XA6P00XP01<canOT8nP06nO[inO[e1?X2n@_j00Kkn_[on_/GnP03nO[j00Gj
00?in_T01?T4nP09nO[jnO[imO[i00;j00?in_T00_T00o[en@02m@06nOGenOGi3?D2l@?A0m000jc<
[007[004S=2/R0:<00B/S8b/18P00jb8S002[007S:b<d<c@c003[0?<0Z`01haXJ6R8J8P01d@390m4
00EXA4A49006A005J4A494@01B@2A0@T0T@590940R@01D@T94@T00E400@TA4A422@00d@T90059003
A2@T00dT00=494@00T@2J1<T0d@89003A2@T00DT14@29003A2@T00DT00AXA4A40b@2A08T00=494@0
1d@00bA4A002A00594A4A2@00d@2909400=XA4@00T@490I40b@2A0<T00=494@01D@290A400<TA4@0
24@291E4000[A08T24@00bA4A003A08T3D@012A492@4A08T00A494@T14@290940R@01D@T94@T0094
22@3A00394A400Q400<TA4@02D@00bA4A00:A003J4A400A400=XA4@01D@2909400<TA2@01D@012A4
A4@490E400=XA4@00d@00bA4A00EA003J4A400E400=XA4@00T@00fQ4A008A003J4A401Y40fP2R004
[?7en@Wj00?in_T01OX00oWjn@0BnP03no[j01Oj00?in_T00_X2n@03n_Wi00;i1oX01?Wjn_T2nP05
nO[inOX00oT7m@04nOGen@Se00?amOD00]401?7@d=02[003c:c<00>/00?@c:`00X`00jb<[003S003
[8R800:800><[8P01X`00lc@d004[006c=3@c=280VP3R003J4A400E400<TA4@02d@00fQ4A004A08T
0T@00bA4A003A08T0T@01BA492A4010T0T@290=400=XA4@014@390941b@00d@T90029005A2@T94@0
2B@2A00494A490=41B@2A0/T0T@890941B@00d@TA003A0XT14@290940R@014@T92@6A00394A40094
0R@2A00394@T00940b@2A00394@T008T24@00bA4A003A00394@T00E400@TA4@T3d@491A4000]A003
94A400e400<TA4@04T@01BA4A4@T00E412@8A08T0d@390=400<TA4@00T@390M400<TA4@01d@00fQ4
A00<A003J4A400Q40R@8A00394A400A400<TA4@01T@00fQ4A003A08T1T@01BA4A4@T00A40VP=A09X
00A4J4AX:T@01VR8[=3en@cj0_T00o[inP04nC?j00Cin_[i1oX00oWjnP03nP03nO[i00Oi0oD00oWe
m@0:m@07lOGelM7@d@03d0:/00?<[:`00j`01/b/S8b8S0:80h`02jb8[8b8S:b8S8R/00:<00>/d?40
0]001:c<d<`2d003[<b<00:<00B8S6QX0d@00fQ4A006A00394A400M40VP014AXJ4@390A400<TA4@0
0T@3909400LTA4A494@T009412@00d@T90029004A2@T90Q400<TA2@00R@3A1DT00A492@T2D@29004
A2@TA0@T00=492@00R@5A0`T0d@39003A2A400<T0T@2909400<TA4@014@00bA49002909400DTA2@T
A00290M40b@5A08T1T@00bA4A007A00394A400A400<TA4@014@01BA4A4@T00e40R@00d@TA00?A003
94A40054000UA00394A400Y400<TA4@01D@00bA4A00:A00394A400A40R@01d@TA4@TA2@01T@490U4
00<TA4@04D@00bA4A00SA004J4@T909400<TA4@01D@00bA4A00390Y400<TA4@00R@2A004J4A4A08T
00=492@04T@4J003A6Q4009400AXA4AX5D@00fQ4A00<A09X00F8[<cen@0:nP;i00WjmO[jnO[imOT0
9oX00oWjnP07nP;i00?jnOT01?X01?Wjn_T6nP;i00?jnOT01OT00oGim@02n@03mOWi00_e00?adM00
1]07[004S8R8S0:800B<R8b<0XP00hb/[002R005[8b/[8`00Z`2d005mM3<lL`00m001<b<[8P2S003
[8QX01=400<TA4@01D@390A40R@4A0<T00I494A494@:90941R@:A0XT0T@00bA4900690=42B@00d@T
9005909400<TA4@03B@00d@T900:909400@TA4A40b@014@T94@39005A2@TA2@01D@29003A2A400PT
24@69003A2A4009400DTA4A49003A00394A400=40R@7A00394A4009400<TA4@00b@3A08T7d@00003
A6Q4015400<TA4@05d@012A494@2921400<TA4@02D@00bA4A007A00394A400=40VP<A00394A400Y4
00<TA4@01d@00bA4A00>A08T0T@012A4A2@DA00394A400Q400<TA6P03T@00fQ4A004A003J4A400Q4
00=XA4@024@00fQ4A00:A00394A400a400IXS:c@mOT8nP05nO[inOX01OT2m@03nO[j02Sj00Cin_Wi
0_X01?Wjn_X2n@cj4?T2m@03nOGe00Se00?amM400_42d003c=7@00:/00?<[=000j`2S0:/00B<[8b/
0X`2R003[8R800:/00><[8`00Z`00hc@d002d@08c=3@dM3Ac:`2S007[8R/S8Q4J006A00494A4J0U4
00AXA4@T0d@00bA4A004A00394A400I400<TA4@00T@49003A2A400DT00A492A40R@01D@T94@T00=4
00=XA2@022@01D@T92A400LT14@49003A2@T00DT0T@69004A2@TA0dT00=492@00b@00d@T90049094
2b@00hQ4900790940b@00d@TA0039004A2A490E400HTA4A494@490=40R@00d@TA002A00494A4A0DT
0T@00bA4A008A00394@T00A40R@DA09X2D@00003A6Q4009400=XA4@03T@00bA4A00AA00494A490i4
00<TA4@01T@00bA4A00<A00394A4019400<TA4@01D@00fQ4A00:A0<T9T@00bA4A003A00394A400a4
00<TA4@034@00fQ4A00@A003J4A400940VP3A003J4A400A400=XA4@024@00fQ4A003A005J4A4A6P0
4D@2J003[8c@00;e3?X01_GinOGjn@Ce9_X00oWjnP09nP;i00?jnOX02_X2n@04n_WinP?i00CenOWi
0_X5n@We0_400m3Al@03d004dM2/c0:/00G<[:b/R002[004S:b/S0:80X`01:b<J8`2[005S:b/[8`0
0Z`4d005c=3Ad=400Z`01XR/[8R/R0=X00A4J4A40b@00dAXJ00;A08T00A492@T0d@00fQ4A005A003
94A400M40R@00d@TA002A0HT1T@39003J4A400940R@00d@T9002A0HT0T@00bA4A0039003A2A400@T
0T@39006A2@TA2A42B@00d@T900290=40R@01D@T92A400DT00E492@TA00?90945B@3A00396Q400@T
2d@00bA4A002A00394A400A40b@00d@TA008A00694A494@T4d@2J0A40fP8A00014@2J0M400<TA4@0
4D@00bA4A006A00394@T00E400@TA2@T14@29005A2A4A2@00T@00bA4A00:A00494@T90Y400EXA4A4
9006A08T4d@00bA4A00QA003J4A400E400@TA4@T14@012A4A2@;A00394A400940VP:A08T34@00bA4
A00IA003J4A401I40fP2S004[?7en@_j0_T2m@;i0oD2nBKj1OT3nP03nO[j00Ci2_X5n@04n_WinPCi
00?jnOT01OT9m@03lM7a00;a00CAd=3A0]05[0:<00>8S:`00j`01HR/S8R<00>/00B8[:b<1Z`01]3<
d=3Ad0;A00C@[:b<0Z`2R09X24@00bA4A002A006J4@T94@T0T@00fQ4A00290=400DTA4A4J006A003
94A4009400@TA4A422@00d@T900490E40b@2A0DT00=492@012@2A08T00=492@012@2A0/T1D@290=4
12@2A0DT0d@022A4A4@TA2A422@00d@TA003A0HT00=492@032@00d@T900790A400<TA2@012@00d@T
A002A00494A490940R@3A08T00=494@00R@00d@TA00>A00394A401Y400=XA4@01d@000A400=XA4@0
84@012A4A2@:A00394A400Q400<TA4@02D@29003A2A400E40R@5A00394A4009400<TA4@01D@00bA4
900290I400=XA4@024@00bA4A006A00394A402940b@3A004J4A490E400<TA4@00T@00bA4A002A004
J4AXJ0U400@TA4@T6D@00bA4A008A003J4A401M400QXR6R8[=3en@[j0_T4m@03nOGe00?e00?in_X0
8?X00oWjn@03n@Oj1?T:nP?i00?enOT01_T2nPWi2_D3l@03d=7A00?@00>/d:`00j`01HR<[<b/00:<
00>8S:`00h`3[003S:b/00>/00b<[:c@c=3amO7ed=42c0:<00B/S8QX0XP016Q4A2@3A003J4A400=4
0R@2A00494A4[09400@TA4@T14@2J0I400LTA2A494@T00I400<TA4@00T@6909400<TA4@02R@2A08T
00I492@TA2@2A0LT00E492@TA00890I400<TA4@022@01D@T92A4008T0d@29003A2@T01DT00=494@0
0R@00d@TA0079003A2A400@T0d@00bA4A0059003A2A400a412@4A00894A4A8aXA2@;A00394A401M4
00=XA4@02D@000A400=XA4@09D@00bA4A00:A00394A400A40R@<A00394@T00m400<TA4@02d@00bA4
A004A003J4A401U400=XA4@024@00bA4A00AA08T14@29003A2@T009400<TA4@02D@2J1540R@RA003
J4A400=400=XA4@01T@01BA4A4AX009400IXR6R8S=02m@03nO[j00Oj00?imOD02_DRnP03nO[i00?j
00Gin_[inP07n@Wj1_T00o[in@03n@03n_Wi00Si2_D3l@03dM3A00?@00B/d=3<2:`3S004R8b8S0R/
00K@[=3@dM05m@;A0/`5[0:800=XA4@01D@00fQ4A002A0<T2D@012A492@;A0@T00=492@01B@01T@T
A4@TA0<T0T@29003A2@T00HT00=492@00R@2A08T00=492@032@2A0DT0T@49003A2@T00@T00=492@0
22@014B8A4@49003A2@T00941B@2A0LT00A492A41R@2A0XT00=492@01R@2A0DT00=492@00R@3A003
94A400940R@2A08T0T@00bA4A003A00394A400=40R@7A00494@T91I400=XA4@034@001E400@TA4@T
4T@01BA492A4008T0T@00bA4A002A00394A400E40R@<A00394A400Q400<TA4@05T@01HQ4A4B80194
0R@5A003J4@T00M40R@9A00394A400U400<TA4@014@01BA4A4@T00=400=XA2@00T@00bA4A003A09X
3T@2931400<TA2@00VP3A0=X00>8S:`00_D2n@Sj0_T;m@03nO[j00[j00?kn_X05?X2n@Cj00?in_X0
0_T2nP?i2?X5n@Cj1?T2nP?i00?jnOT00oT;m@05lM7Ac=000/`01M3<c=3<00B/00?@c8`00X`2[003
J8R/00:/00F<[8b/c002[005d:c@mM400oD01?WemO43d003[8R/00><0fP00dAXA002A003J4AX0094
00AXA4@T0T@016Q4A6P5A08T34@39003A2@T00PT00A494A40R@2A10T0T@A90942b@014@T94@79003
A2@T00@T00A4c4A41R@00d@T900390=41b@00d@T90059003A2@T00=41R@014@T94@29004A2A4A0PT
0T@390U40R@00d@T9009A0<T0T@390E41R@<A08T24@00fQ4A00<A0008d@00bA4A00>A00594A4A2@0
0T@00bA4A004A00394A400Q400<TA4@00R@8A00394A401M40VP2R11400HTA2@TA2@=A00394A400M4
00<TA4@00T@00bA4A005A00394A400E400<TA4@01D@29003A2A400Y400<TA4@014@00fQ4A006A003
94A401M400=XA4@03D@00fQ4A002A00394A400A40fP018b/lOD3n@Oj00?imOD02OD2nBSj1OT00o[i
n@02n@[j0_T00o[inP04nP03nO[j00;j00Gin_[jn@03nP?i2?D00m7ad@03d003[=3@00?@00c<[8b/
c=3<[8R/R8`2R003S:b/00J/00C<d=7a0_D00o7em@03m@06lOG@d:b<0hP4J003A6QX00=400=XA4@0
3d@290U400<TA4@03b@00d@TA002A0@T00=492@014@290940b@2A08T0T@00bA4900I9003A2@T00HT
00=494@01R@00d@TA00490941b@2A0hT0T@390=41R@3A0HT00=492@00R@3A0DT00A494A40b@2A003
94@T008T1T@00bA49002A00394A400940R@3A0<T00=494@02T@00bA4A00291M4000MA00594A494@0
0R@9A00394A401e400<TA4@00T@00bA4A005A0<T5d@016R8dJ`?A0@T00A494A40R@4A003J4A40194
00<TA2@03D@00fQ4900CA08T5T@012A4A2@EA003J8Q400M400=XA6P01T@016Q4A4@2J005S:c<lOD0
0_T8nP03nOGe00_e:OX01?Wjn_T2m@05nO[jn_T02?X2n@03n_Wj00;i3OX5n@Oe00Cad=7A2=000jb<
[002[003d:b800:<0Z`00hb/[003[003S:b/00;<00?@mM401_D01oWelO7elL`00j`2R09X00A4J6QX
14@016Q4J6P6A003J4A400=400<TA4@014@01fQ4A4@TA2@00T@?90941b@6A00794A494@TA00290A4
2b@00d@T90099004A2@T90A412@01D@T92A4008T00=494@012@3A0@T00=492@02B@00d@T90099003
A2@T00E40R@00d@TA002A08T0T@5909400<TA4@022@2A0HT0T@290E400<TA4@00d@012A4A2@2A003
94A4008T3d@012A492@4A0DT14@00bA4A008A0007T@01BA4A4@T00Q412@00d@T900BA00394A40094
00<TA4@00T@29004A2@T90=40R@3A00394A4008T1D@00bA4A004A00594A4A6P00T@01Xc@d6Q4J154
00@TA4@T6d@00bA4A008A0<T14@290Q400<TA4@06D@00fQ4A00MA003J4A400e400=XA6P00T@026Q4
J6R<[<ca0_D2n@Gj0_T>m@03nO[j02?j0_T00o[in@07n@Kj2OT;nP03nO[i00;i2?D2l@03mO7a00O@
0/`2[003S:b/00:/00><[8P00h`8[0?@00?AlOD02_D2d0:/00B<J6QX0XP4J003A6QX00:800><J4@0
2d@290Q40b@2A0TT0d@00bA4A0029005A2@TA2@02D@49003A2A400E43B@00d@T9002A00394@T00<T
00A492@T0T@00bA490039004A2@TA0<T14@390E400@TA4A422@3A0@T0T@89004A2A490=40b@2A004
94A4A0/T00=492@01B@3A0@T00A492@T0d@490A400<TA2@00R@014@TA2@:A00394A400A400<TA2@0
0R@6A0<T0d@00bA4J008A0007T@00bA4A00=A08T4D@29003A2A400E400@TA4@T1D@00bA4A009A003
94A400Y412@3A004J8aXJ09400=XA6P00T@291I400=XA4@00d@00bA4A00=A003J4A400I40R@5A003
94A400I400<TA4@01D@012A4A6P3A00394A400=400<TA4@02T@00bA4A006A003J4A400i400=XA4@0
4T@2J008A6QXS:c<lOD3n@Kj00?imOD02oD00oWjnP0QnP04nO[jnPKi00CjnOWi0oX2n@;j1OT2nP;i
2oX5n@We00OamM7@c=3<00C@00?<[:`00Z`01hb/S:b<R:`00XP4[005S:b/[=000_401m7amOGimOT0
1?D01?7ed=02[0AX00F<R4A4J003A0:814@00fQ4A004A00494A4A0<T1D@00bA4900290=40b@014@T
A4@5909400<TA4@01B@2A00394@T00A40b@00d@TA002A0/T14@490942b@00d@T9004909400<TA2@0
0R@4A08T00A4J4@T1d@790=412@014@TA4@69004A2A490=41B@5A0<T00=492@012@014@TA4@49003
A2A400@T00A492A40R@00d@T90039007A2A494@TA003909400<TA4@03d@00bA4A006A00394A400e4
0B@1A0007T@00bA4A002A00394A400a400<TA2@07d@012A492@5A08T1d@00bA4A004A00394A400M4
00=XA4@00VP2A00394@T00a40R@>A00394A402e40R@6A08T1D@00bA4A002A00394A400U400<TA4@0
2D@016Q4A4@3J1M400EXA4A4J002R003[=3a00;e1OX00oWjn@0>mBCj00?in_X01?T00o[en@02n@;j
00?in_T01oT01O[inO[i00[j00?in_T00_T:m@;a00GAd=3@c002d003[=2/00:/00F<[:b/R004S0:/
00><[8`01:`01]3AdM7el@[e00Gad=3<[003R003J8R800=400AXA4AX14@00fQ4A002A09X1D@390E4
12@3A004J4@T90=40b@6A00394@T00LT00=494@01D@29003A2A400A432@01D@T92A4018T0T@99003
A2@T00940b@2A00494A4A0TT00E492@TA00290941R@5A00694@T94@T1d@8909400<TA4@012@00d@T
A003A00694@T94@T0d@49006A2@T94@T0T@00bA4A00CA08T4T@00fQ4A004A00064@00fQ4A007A003
94A400M400@TA2@T1D@00bA4A009A00394A4008T0d@00bA4A008A08T00=494@02D@00bA4A00@A0=X
3D@00fQ4A002A00394@T00Q400=XA4@014@2909400=XA4@02T@2929400DTA4A4900;A00594A4A6P0
1T@291M400<TA6P014@00fQ4A00;A0=X00N8S<c<lOGi00Cj00?in_T01oD00o7em@04m@03nO[j023j
00[in_[in_Gin_Wj0_T00o[in@03n@05n_Win_D00oT01?[in_X2n@Oj0oT3m@04nOGen@Ke00W@mM3@
c=3<d<`00Z`02Hb/[:b8S:b8[002S0B/00F<c:b<c002[0;@00?amOD00_T00o[em@06m@?@00C<[8b<
0XP00fQ4A009A09X0d@016Q4A4@890=41b@2A00494A4A0<T14@00bA4A00990=400@TA4A40b@00d@T
9002909412@014@T94@59003A2@T00hT0T@3909400@TA2A41b@00d@TA002A0DT0d@<9003A2@T008T
00=492@02R@00d@TA006A005R4A494@01R@00d@T900290=41B@5A0@T1T@01RA492A490E400@TA2@T
2D@290941B@2A0<T2T@016Q4A6P2A05X0D@1A0007T@00bA4A00;A08T44@290=400LTA4A494@T00I4
0VP<A00394A401A400=XA4@04T@00bA4A005A003J4A400M400<TA4@03T@291=400=XA4@04D@390M4
0R@6A00794A4A2A4900;A00394A401A40fP7A004J4AXR0:/00C@mOGe1?X00oWjn@09m@;a1?DXnP;i
0oX01OWjnOWj00Oi00CjnOWj0oT9nP;i0_D00oWem@07m@03lOGa00K@1h`018R<[8P2S003R:b/00B/
1<`01=3alO43m@03nO[e00Oe00KAd=3Ad:`3S09X1T@2J004A6QXJ0=400=XA4@00T@390=400<TA4@0
0d@490E400<TA2@00R@5A08T00=492@01B@7A00394@T00TT00=492@00b@00d@T90059003A2@T00<T
00=492@01B@3A08T1d@49003A2@T00<T0d@490943R@2A08T00E492@TA0039005A2A494@01B@00d@T
A003A0@T00Q492A494@TA08T00A494@T0d@490E400<TA4@01d@390M412@014@T92@2A00394A400=4
0R@014@TA4@390I40R@2A004J4A4A09X0d@002m400<TA4@00d@00bA4A004A00394@T00@T14@00bA4
9006A003J4A400=40R@00d@TA003A08T1d@00bA4A00CA08T4d@00fQ4A00IA08T0d@00bA4A006A08T
0d@2J0=400<TA4@00T@390U40R@:A00394A400=400AXA4@T3d@00bA4A00CA003R4A400Q400MXR8R<
[=3e00;i1?X2n@03mOWe00Ce1?44m@03nO[j02Gj00?in_T01oX2n@04n_WinP;i0oX2n@[j00Gin_Ge
n@09m@05lM7adO400]000lb/S003S003[8b/00:80h`00jb8R002[005c:c<[<`00m02d@Ke00CimOGi
0oD3d@;@0Z`018b/[8`3J006A6QXJ4AX0d@3J0=42b@4A0<T14@012A492@2A0<T0T@012A494@39003
A2@T008T1D@00bA490089003A2@T018T0T@4909400<TA4@012@00d@TA003A0<T0T@59003A2A400<T
0d@29004A2@T90940R@00d@TA00?90941b@5A0/T0T@39004A2@T90941B@3A00594@TA2@00d@390=4
0b@4A00394A400@T0T@39003A2@T008T00=492@00b@2A0<T00=492@034@003M400DTA4A4900>A08T
14@00fQ4A002A00394A400=412@2A00394A4011400=XA4@02T@2J0I400=XA4@034@00fQ4A00;A004
J4A4J0Q40b@6A00394A400I400<TA2@02d@00fQ4A003A00394A400e40VP4A00394A401]400<TA4@0
0T@2J0]40VP00hR/d003m@Cj0oT5m@07lOGAdO7el@03m@Kj00?kn_X00_X01Oojn_[i00Sj00?in_X0
1OX00oWjnP02nP04mO[jn@Cj00Oin_[jnO[e00;j00?en_T00_X2n@05n_Wjn_T01?X00oWjn@02n@;e
00CimOGj0oD02O7emM7edO7@c005[0:<00N/R6R/S8R/00><00>8[:`00/`01=3<d=42m@03dOGa00?e
00?imOD01?D00o7ed002m@0;dM3@[<b/S8QXR6P01T@5J003R4A400=40b@00d@T9006A0<T14@290A4
12@00d@T90079004A2@T90940b@00d@T90079003A2@T00=43R@2A0@T00=492@00R@2A00494@TA08T
0d@290=400<TA2@014@290=412@00d@TA002A0<T00=494@012@3A0<T14@29003J4A400DT0T@00bA4
A002A00494A4A0<T00=492@00T@390E40R@4A00394A400E400AXA2A40b@00d@T9003A00494A4A0HT
2T@39004A2A4A0<T3D@19054001:A08T3T@290E400<TA4@0<4@00bA4A004A003J4A400E40R@>A08T
1T@291M40VPGA00394A4021416P4A003J4A400=400EXA8R/d002m@;i0oX00oWem@04m@07lOGadO7A
l@05mAgj00?in_X03_X01OWjn_Wj00;i1?X01?WjnOT7nP06nO[jnO[i1?D00oWem@02m@04nOGel@;@
00?Ac<`00Z`2S007[8b<[6R8[003S0>/00F8S:b/c002d0;A00CedM3a1OD01?WemOT3m@05lM7adO40
0]03[005S8QXR6P00d@00bA4A003J0E400<TA2@00R@3A00394A400E40R@00d@TA004A00494A4A08T
0T@3909400DTA4@TA00290A400<TA4@02b@4A0/T00A492A41R@00d@T9003909400<TA2@00T@89094
00<TA2@00b@00d@T90049003A2A400942b@00d@T900590941b@00d@T9002A0<T0d@01RA494@TA08T
00=492@00R@4A00394A400940R@3A00594A4A2@00T@29004A2@T90E400<TA4@00T@5909400=XA4@0
24@3909400<TA4@03T@00003A6Q401i40R@6A00394A401a400<TA4@03D@00bA4A006A00394A400Q4
00=XR4@05D@01FQ4A4@T00a400DTA4AXA002J15400<TA2@02d@00bA4A00EA00394A400940R@00d@T
A00cA0=X1D@2J0E40VP00hR/d003m@04nO[jn@Ke00OadO7AlM3a00;A00C@mOGi<oX01OWjn_[i00;j
2?T01?[in_T3nPCi2OD2d@;@1J`2S0:/0X`01Jb<S8b800:<00C<[:b/0]02d@Ke0oT:m@06lM3@d:b8
0Z`018b8J6P2A003J4A400940fP00d@TA002A0<T14@290E400=XA2@00b@3A00394@T00<T00=492@0
12@5A0<T24@490941R@3A08T0T@59003A2@T00<T00=492@00R@2A0DT0T@49003A2@T00<T00=492@0
1R@3A08T00=492@00b@00d@T900;9005A2@T94@032@014@TA4@29003A2@T00<T0d@012A494@590=4
12@6A0<T00E494@TA0039004A2A490E40R@3A0<T1T@01BA4A4AX00=40b@6A00394A400I400=XA4@0
0D@000]400=XA4@034@290Y400DTA2A4J004A00494A490940R@00d@TA00<A08T0d@29004A2A49094
00<TA4@012@5A08T14@00bA4A005A003[4A4009400<TA4@09D@2J005A6Q4A2@03T@00bA4A003A09X
00<TA4@01D@00bA4A002J0<T1D@00bA49004A08T0T@00bA4A0039005A2A4A6P0;d@00fQ4A002A003
J4AX009X14@2J003R:c<00Ce00Cin_Wi0_D00oWed@02d005lM7AdO400m001=7emOTcnP05nO[inOX0
1OT00oGin@02n@03n_Wi00;i0oX2n@03mOWe00Oe0]0;[006S:b/S:b81Z`2d0;A2OD00oWen@06m@04
lOGAc0B/00><J8P00T@3J09400=XA6P00VP5A0@T0d@290U40R@00d@T9005909400<TA2@00b@6A08T
3d@29003A2@T00@T00=492@01R@2A08T00=492@01R@01D@T92A402<T00=494@052@00d@T9002A08T
00=494@01R@2A0DT00A492A40b@3A0<T00E492@TA00290I400DTA4A4900;A00394A4015400<TA2@0
0R@2A00394A400I400=XA4@00D@000A400=XA4@0>D@00bA4A006A00394@T00=40R@00d@TA003A003
94A400E400<TA4@014@00bA4A00OA003J4A401a400=XA4@05D@00bA4A002A08T1D@00bA49005A08T
1D@00bA4A00FA08T3D@00fQ4A00;A003J4A400=40VP01XQ4J6Q4J0940VP00hR/l@03m@06nOGjnOGi
0oD00m3el@03d0;A0o401=7emOD3nP03no[j00Gj00?kn_X03oX00oWjnP08nP04nO[jn@;j00Kin_[i
n_T2nP09mO[imOWenO[i00;j00Kin_Win_T2nP03mOWi00Ce00GjmOGed@02l@B/00G<[:b8S004[005
S:b<[8`00Z`00lb/c002d@05lOGamOT00_D00oWen@02m@04nOGen@?e00?AmOD00]400jc<[003R004
J4AXA0=X00=4R4@024@29003A2A400=400<TA4@00d@00bA4A005A0DT00=4J4@00T@290940R@3A003
94@T00<T00=XA4@02D@290941b@00d@T9003A00394A400=41R@2A1lT00=492@01B@4A08T00=494@0
1B@00d@T9007909400DTA4A49003A0@T1D@49005A2@TA2@00d@00bA4900290I40R@5A08T00=492@0
14@00bA4A003A08T0T@00bA4A00490=400<TA4@01T@00bA4A003A00494A4A08T00=XA4@00d@001E4
0R@3A00494A490i40R@2A00394@T00M400DTA4@TA0029003A2A400=400<TA2@00b@3A00394@T00A4
0b@5A00394A400=40R@00d@TA00<A00394A4009400<TA4@084@00fQ4A00:A00394A4009400<TA4@0
34@290940b@5A00394A4008T0d@00bA4A00:A007J4A4A2A4900]A0=X00>8J4@016P3A004J8R/l@Ce
0oX01?WemOD2l@09d?7@dM3Ad?7A00;e0_42mB_j00?in_X00oX00oWjnP02nP03nO[j00Ci00GjnO[i
nP08n@03mOWe00Ge00CamO7A0]001/c@[:b<R0:<00F/S:b/S006[0;@00?AlOD01oD3n@03n_Ge00Ke
00CamM3@0j`2R003J4AX00IX00B8A4AX1T@00bA4A002A00394A400A40R@4A00394A4008T00A492@T
0d@390E400<TA4@01b@3A00594A4A2@014@<90A40R@3A0TT00=492@022@014@T94@K9003A2A400=4
42@024@T92A494@T0T@390A41B@2A00394A400=400<TA4@00R@00d@T90029006A2@TA2A412@2A003
94A400=400<TA4@00T@00bA49004A0<T14@00bA4A003A00394A400Y400<TA4@01D@00003J4A400A4
0fP=A00494A490m400<TA4@01D@390A40R@00d@TA006A00394A400=40R@01T@TA4@TA08T1T@290=4
0R@00d@TA005A00394A400Y400DTA4A49002A00694@T94@T:4@00bA4A002A00494A490I40R@3A003
94@T00<T1D@290940b@7A08T2T@39003A2A4029400=XA4@01T@00fQ4J002A09X1D@2J004R<cAl@?e
0_X02_WjmOGadO7@[=43d0;A00C@lO7a0_D00oWjnP0]nP03nO[j00Cj0oT00oGin@09n@03mOWe00ce
0]401]3<c=3<[0:<00N/S:b/S:b<00>/00CAd?7a2OD3n@03mOWe00Se00Kac<b/S:`2S003R4AX00=4
00=XR8P00VP00dAXA006A00594@TA2@00d@690A40b@3A0<T0d@29003A2@T009400<TA4@01b@2A007
94@TA2A49005A0DT00=492@00R@4A0<T0d@>9006A2@TA2A40R@00d@T900I9004A2@TA0DT0T@29004
A2@T909400@TA2@T0d@490940R@6A00394@T008T0d@590E412@01D@TA2A400DT0T@2909400@TA4AX
3T@00bA49006A00394A400U400<TA2@01T@000A40VP01=3e[6PZA00594A4A2@02d@00bA4A005A08T
24@29004A2A490940b@014@T92@3A00394A4011400@TA4A41B@2A003J4A400M400<TA4@06D@290e4
00<TA4@00R@;A00494A4A08T14@590A400=XA4@01D@290U40R@=A003J4AX00e400@TA4AX1d@00fQ4
A003A09X00B8[:c@0oD01?WjnOX5m@05dM3Ad=400]001Lc@d?7A00?e00?in_X0;?X00oWjn@02nP03
nO[i00Ki00CjnO[j1_T00oGin@04m@03nOGe00;e00CadM3@0/`2[0><0Z`2S0F/00?@dM002?D00oWe
m@06n@Se00Gac:b/S002R003S8QX009X00E4J8R8J002R003J4A400Q40b@2A0HT00=492@00T@790E4
1R@014@T94@4909412@5A08T1D@29004A2A4909400@TA4@T0d@;9005A2A494@01R@2A28T0T@39004
A2@TA0<T14@290941R@01T@TA2A4909400<TA4@00b@01D@TA4@T00=400<TA4@00d@00bA49002A08T
1T@2909400<TA4@02D@00bA4A005A00394@T00A400AXA2@T1D@290=40R@2A00394A400=40004A09X
00C@lM2<5d@390i400<TA4@00d@00bA4A002A00394A400U400@TA4@T2D@3909400<TA4@00T@00bA4
9003A00394A401940R@2A00594A4A2@00T@2J0Q400<TA4@04D@00fQ4A003A003J4@T008T14@01BA4
A4@T00=400<TA4@00R@:A0@T24@00bA49005A004J4AXJ0A40R@:A0<T;T@01HR/[=3a00?e00Cin_Wj
0oD00m7@c002d006dM3@c=3a0]02d@?e7OX00oWjnP0;nP04nO[jm@Oj00Kin_Win_D4nP09nOGimOWj
nOGj00Ke00CamM3a0]401Lb/[:b<00:81j`01]3<d?7@d@Ge00cjmOGimOWjmOWjmOT2m@07nOGemO7A
c002[0:<00>8[6P016P00hQXJ002J0:82d@29003A2@T00LT1D@490M41B@00d@T9003A08T0T@59094
00@TA2@T1D@00bA4A002A00594A4A2@00d@39003A2@T00HT0T@00bA4A00690A43B@00d@T900H9005
A2@T94@00R@4A003J4@T00<T0d@39003A2A4009412@2A003J4@T008T1T@01BA4A4@T00940R@5A0@T
14@00bA4A006A00394A400A41B@2A00394A400E400<TA4@00T@016Q4A2@8A00014@2J004d?Wic09X
5D@01BA4A4@T00i400<TA4@01d@00bA4A00EA0<T0T@00bA4A004A00494A491i400<TA4@044@00fQ4
A008A003J4A400Q400<TA4@014@490I41R@2A00394A400940b@6A0<T00=494@02d@00bA4A00:A08T
24@00bA4A00>A003J4A400M40VP2A003J4A400A40VP01HR<[<ca00;e00GjnOWjn@03m@03dLb/00C@
00?<d=000]03d@?e=_X00oWjnP02n@03n_Wj00Cj1OT8m@;A0]000lb/[006[003R:b/00K@0]400o7e
m@07m@03nO[i00;i1?D00oWem@02m@07dM2/c:b8S002R00<J8QXJ4AXR6Q4J4AX1T@290A42b@5A0<T
2T@690940R@4A08T14@00bA490029003A2@T00A41B@00d@TA002A0<T00E492@TA00290=40b@2A003
94@T01XT00=492@02b@00d@T90059003A2@T00<T0d@590A400@TA2@T1D@00bA4A004A0<T0T@00bA4
A00290=400<TA4@01d@690940R@5A08T1d@012A4A2@2A0<T00A494A40R@4A09X00E494A4J006A000
1D@01FR8d:aX00]400<TA4@03D@00bA4A00=A00394@T01A400<TA4@024@3909400<TA4@01d@012A4
A2@4A00394A401A40b@CA003J4A400I400<TA4@024@01FQ4A4@T00=400<TA4@01T@490=400<TA4@0
0R@00d@TA006A00394A4008T1T@00fQ4A00@A00394A400E400<TA4@05d@00fQ4A00:A09X00J8S8b/
c?42m@;i00?jmOD00_D2d@06d:c<c=2/1]000m7al@02m@03nO[j03Gj0oT00o[inP02n@03n_Wi00;i
00?enOD01OD2l@03dM3<00?@0j`00m3<[002[0G@0oD01O7emOGi00;e00?jnOD00_T00oGim@0:m@07
d=7@c:b<[003R0=X0XP00fR<A007A0LT00=494@02R@2A00394A400a41R@2A08T0T@00bA4A0029094
0R@2A00394@T00<T00=494@00T@390E40b@00d@TA00390E40b@2A0DT00E492@TA00>9003A2@T008T
0T@F9005A2A494@00R@014@TA4@290A400<TA4@014@00bA4A005A00394A4009400<TA2@014@39003
A2A400940R@014@T94@39004A2A490E400@TA4AX0d@00bA4A004A08T00=492@00b@BA0001d@00fQ4
A01?A0@T2d@29003A2A400a40R@3A00394@T008T0T@012A4A2@7A004J4A4A0<T2d@49003A2@T00I4
00=XA4@01D@00bA4A009A00394A4008T00=492@02T@012A492@3A003J4A400a40VPMA09X5T@00fQ4
J002J006R:c<lOGi0_X00oWem@02m@04lM3@[0;<00>/d=001]04m@03n_Wj03?j00?in_T00oT2nP03
nO[j00Ci1oD01M7ed=3<00;@0Z`00lb/d002d003c=3@00?@00?elOD01oD02?WjnOWjnOGi1OD01?We
mOD2l@03c:b/00B<00>8J6P00fP2R003J4A400E42b@00d@TA00790940b@8A09X0d@990U400<TA2@0
12@00d@TA003A00594A4A2@00d@290=41B@01D@T94@T00942B@2A0`T1D@290=400HTA4A494@>9003
A2@T00<T0T@490A400<TA4@01T@00bA4A004A00394A400E400<TA4@014@390940R@014@TA2@2A003
94A400<T1D@00bA4A002A00394A400e40b@6A08T1D@00bA49004A00084@00bA4900^A00394A40094
00<TA2@00T@00bA4A007A00594A4A2@03T@00bA4A006A00394A4008T0T@00bA49002A004J4A4J194
00<TA2@00b@4A004J4A490E40R@9A00594A4A2@05T@2J0i400=XA4@074@00fQ4A00FA003J4AX00:8
00B/c?7e0oX00oWen@02m@06c=3@[=3<0m001lc@d=3<dM000oD00oWjnP0cnP06nO[inO[i1?X01_We
nOWen@;e00CilOGe0]02c003d<c<00?@00>/d?400]001=7ad?D2d@03mO7e00;e00CjnOWj0_T01_[e
nOWen@;e00CimOGi0_D00o7@[004[0:800><J6P00VP00hQXJ00:A0LT14@590E40b@8A003R8a400=4
0R@00d@T900390E40R@01DAXA2A400@T3d@00bA4A003A08T1D@290941B@2A00394A400@T0T@00bA4
A00290940b@00d@T90029003A2A401TT0T@00bA4A008A08T0d@00bA4A00AA004J4@T90940b@2A003
94A400A400@TA2@T14@290=400<TA4@03D@490I400<TA4@00T@00fQ4A002A05X0D@1A0006T@00bA4
A005A00594A4A2@03T@012A4A2@4A08T44@290E400@TA2@T0T@01BA492A4008T14@012A4A2@DA003
94A400940R@2A00394A401M40R@6A08T14@00bA4J004A08T1D@29005A2A4A2@01d@00bA4A004A003
94A400E400<TA4@06d@00fQ4A00DA00394A400a400AXA4A40VP01dAXA8R<[=000_D02OWjn_[enOG@
d@02c0K@00?Ad=000m001=7emOD3nCSj00Cin_[i0_X8m@03lM7e00;@00N/d=3@[=2/00K@0o42m@04
dOGen@Wj00?imOT00_D3n@;e00CimM7@1J`00hb8R002J003R6QX009X24@990A41B@4A0@T24@00hb8
A003A0LT0T@00bA4A005A0TT0d@012A4A4@290I42B@2A0@T00M492@TA2A400HT00A494@T0T@E9003
A2@T008T00=492@02b@00d@T900690=41B@00d@T900290I41R@2A0<T00=492@01B@2A00394@T008T
0T@590=40b@00d@T900;A00494@T90U40R@:A09X000MA00794A4A2A4900GA08T0d@00bA4A00EA08T
00=494@01D@00bA4A002A00394A400=400<TA4@01d@290M400DTA2A49003A00394@T00U400<TA4@0
5D@012A4A4@290I40b@2A0<T00A492@T24@012A4A2@4A00394A400=40R@00d@TA00;A00394A400i4
0R@8A003J4AX01E40fP00dAXJ006A00;J8b/d?7enO[in_T00_D3l@;A00GadM7@d@03d005c=3@dO40
0_D00oWenP0inPCi2OD01o7ed=3<d<`00]000lc@d005d0?a00?elO400_D:nP06nOGemOWj0oT3m@04
d<c<S0B/00B8J6QX18P4A003J4A4008T00=492@01b@7A00394@T00DT0d@00bA4A00290Q40b@2A003
94A400=400=XA4@01R@00d@T90029003J4A400A40b@00d@TA002A0<T00=492@032@014@TA4@69094
0R@2A1TT00=492@01B@00d@T9002A08T00=492@01B@00d@TA002A0@T00A492@T14@00bA490049003
A2A4008T00I494A494@590941B@01D@T92A400<T00=494@012@6A00394@T00<T0T@00bA4A00DA05X
000]A00394A400E400@TA4@T0d@00bA4A003A00394@T009400HTA4@TA2@3A00394A400=400<TA4@0
0T@00bA4A004A00394A400=400DTA4@TA00290U400<TA2@01d@00bA4A006A00394@T00U40VP:A003
94A400a400<TA4@014@390A41B@DA00394@T00HT1d@00bA4900<A00394A400E400=XA4@014@2J003
A6Q401940VP5A004J4A4A09X00B<[=3a0oD4n@?e1=400o7@d003d0;<0]000m7am@03m@03nO[j00gj
00?in_X09_X01?WjnOT8m@;a0m401<c@d=44d003c=7@00?@00?AlO400oD00oWjnP08nP?e00Cin_[j
0_D00o[ed@02d007c:b/S:b<R002J0:80X`00fQ4A00290A41B@00d@TA00:A08T0d@00bA4A004A08T
2T@00bA4900<A003J4A400DT2D@2909400LTA4A494@T009400<TA4@00R@3A0PT00=492@01R@00d@T
900B90945B@00d@T90039003A2@T00@T00E492@TA0039003A2A400LT00=492@01B@00d@T90099003
A2@T00HT00=494@00T@49004A2@T90940R@00d@T900690U400<TA4@00T@00fQ4A005A000:T@01BA4
A4@T00a40R@6A00394A4009400<TA4@01D@012A4A2@7A00394A400E400DTA4@TA00390=400<TA4@0
0d@2909400<TA4@014@490E400<TA4@03D@00fQ4A009A08T1D@00bA4A00;A0<T0d@012A4A2@7A003
J4A400Q400@TA4@T1T@00bA4A008A00394@T00]400<TA4@06d@01BA4A4@T00e40fP2R003[<cA00?e
0_T5m@07d?7ad=7@c002d004[8c<d0;<00?AlOD00oD3n@03n_Wj00Oj00?in_T00_X00oWjnP0RnP?i
2OD00o7@d005d003dM3A00;@00GAmM7ed@06m@03nO[j00Sj00?imOD00oT00o[im@03m@G@0Z`2S003
R8b800>800UXA4@TA2A494@012@00d@T900;A0DT0T@00bA4A002A00594@TA2@02D@00bA4A00:A0<T
14@290940b@00d@T9004A0@T00=492@012@3A00494@TA0/T00=492@00b@00d@T900?9004A2@T9094
12@00d@T90029004A2@T90943B@00d@T900290940R@00d@T9002A00494A4909400DTA2@TA00390A4
0b@014@TA4@39003A2A4008T00A492@T1D@39006A2@T94@T0T@29003A2@T008T0d@00bA4A00=A003
J4A400=40FP001Y400<TA4@03T@00bA4900?A00394A401E412@2A0HT00=494@00d@012A492@6A005
94A4A2@00d@012A492@4A08T3T@012A4J6P3A003J4A400=400=XA4@02T@00bA4A0039003A2A400=4
00@TA4@T0T@39005J4A4A2@03T@00fQ4900DA00394A401E400=XA4@00T@00fQ4A00;A00394@T00i4
00<TA6P00fP018R<[=02m@03nOGe00Ke00GadO7@l@03d0:/0]02[003d=7e00Ce0_T01?Gin_T4nP04
nO[jn@;j00?in_X00_X00oWjnP0>nP03nO[i00Gj00?in_X01?X00oWen@07m@05lOGAmM402]02d@05
mM7alOD00]42m@03n_Wi00Wj0_D01?WenOT5m@09lM3<[=3<[8b800:/00><[8P00VP7A0DT0T@290a4
0R@00d@TA006A00494A490e41FP2A004J4A4A0@T1T@39004A2A490=40R@3A0DT00=494@00d@79003
A2A4008T0d@2909400<TA2@012@3A0DT00=492@01B@00d@T900490943B@3A0@T0d@00bA4A005A08T
00A494@T0T@00bA4A00290=400@TA4A40b@014@T92@7A08T00=494@024@29003A2A400Y40R@2A08T
3d@016Q4A6P2A0006D@00bA4A002A08T34@00bA4A009A00494A491U40R@00d@TA00390940R@00d@T
A003A00394A400A40R@01D@TA4@T00E400@TA2@T0d@391Y400><A4@02T@00bA4A00290=400<TA4@0
0R@2A00394A400<T0d@290a400AXA4@T1d@290e400<TA4@01D@01BA4A4@T00i400=XR6P08T@2J005
S:c<dO402oD2l@?A0]000jc@d002d0;a00?@mOD01_D3n@03n_Wi00Gi00?jnOT01OX00oWjn@03n@Oj
00Cin_[i1OX00oWjn@02nP04nO[in@We00CAlM7a0]43d003dM3@00C@00[amO7edO7AlOGi2oX01_We
mOGinPKe00Ca[=3@0/`00jb<R002[004R8aXJ0Q41B@2A08T1D@00bA4A004A0@T1D@290M412@00d@T
A003A003S6QX00=X0T@016Q4A4@590=41B@3A08T0T@012A4A4@29004A2@TA0HT00=492@00R@2A003
94@T00LT00=492@012@00d@T900=9003A2@T00@T00=492@03B@4A0<T00A492@T0d@00bA49002A0`T
0d@29005A2A4A2@00d@01BA494@T00940b@00d@TA002A00394A400940b@00d@TA00:A0<T00=492@0
2D@00fQ4A003A003R4A400940FP001Y400<TA4@04T@00bA4A002A00594A4A2@05D@012A4A2@5A004
94A490]400<TA4@014@29003A2@T00I40R@7A0@T5T@00fQ4A005A08T3D@00bA4900290940R@2A0DT
00=494@044@00fQ4A004A08T6D@00bA4A00=A004J4A4A08T1d@00fQ4A002A00394@T00U40VP5A007
J8R8[=3Al@02m@03nO[e00Ge00CamO7A1=001<c@dM02d@03d?7e00Ke0_T00oGin@04n@05n_WinOD0
0_X00oWjn@02n@09mOWimOWjnO[i00;j0_T01o[in_[in_T00_X2n@04n_Gin@Se00GAlM7@l@02d003
lM3@00C@00C<d=3A1?D01M7adO7e00_j00?enOT00_D00oWem@04m@07lM6/c=3<d002[006R:b/R:b<
1d@00bA4900290U40b@5A0@T2D@00fQ4A005A00394A4009400<TA4@01HP00fQ4A004A0DT00=492@0
0b@01D@TA8Q400/T0T@89003A2@T00943b@00d@T900=90942B@00d@T900;90A400<TA4@00T@390I4
2b@00d@T9004A00494@TA08T14@00bA49002A00494@T90E400<TA4@00T@012A4A2@3A00394@T00A4
22@DA05X000IA00394A4011400<TA4@02D@00bA4A00@A00394@T00=400<TA4@03T@012A4A4@290=4
00<TA4@00R@01D@T94AX00E400<TA4@06d@01FQ4A4@T01E400<TA4@00R@00d@T9005A00394@T00<T
24@00bA49002A00394A403M40R@5A003J4A400I400<TA4@01d@00fQ4A002A0AX00><[<`00oD2n@04
n_Wen@?e00KamO7Ad=42d007dM3@d=7ad@08m@Gi1oD4n@Ce1OT01?GimOD4n@;e0_T2m@Ci2oD00o7A
d@02l@;e0]43d007c=3@d<cAd002d@Se00?in_X01_X01?WemOX3m@03nOGe00?e0_401=3<d<`2[0?@
00R8S8R/R6Q4J0]400<TA4@00d@590I400<TA2@03D@00fQ4A007A09X00F8J6R8J002A0<T00=492@0
0b@00d@T90039003A2@T00<T00=492@00R@00d@T900890941B@2A0LT00=492@00T@69005A2@T94@0
2B@2A0LT0T@59003A2@T00LT00=494@014@490=43R@2A0<T0d@490E412@01D@T94@T00=400<TA4@0
0T@00bA490039004A2@TA0<T0T@290E40b@5A00394@T00A400<TA4@014@002i400<TA4@02T@00bA4
A00CA00394A400Q400=XA4@00d@00bA4A005A00494A4A0<T0d@00fQ4A009A08T0T@012A4A4@29114
00=XA4@04T@00bA4A002A0DT14@00bA4A003A0<T0d@01BA494@T01i400@TA2@T1D@01BA4A4@T00U4
0R@7A00394A400=400=XA4@04T@00fQ4A002A003J4AX00:800?<d?D00_D2nP;i00?enOT01OD01]7@
dLc@d@G@2_D00oWen@02n@03mOWe00;i00?enOT00_T2m@03nOGi00Se00?imOD00oD01OWen_Gi00Oe
00?amOD00_D01=7@dM02d@04lOGAd0?A00?<d=000m000lc@d@08m@03nO[j00Kj1?T9m@0<d<c<[=3<
d<b/c=2/0XP2S003R4B800e42b@6A00594A4A2@034@012AXA2@3A0EX00A4J4A40R@2A00394@T00PT
00=494@00R@00d@T900E909412@4A0@T00=492@04b@00d@TA00>90A41B@2A00394A400940R@3A0/T
00=494@014@290Q40R@00d@TA002A0<T14@290A400<TA4@00R@5A00494A4A0@T14@29003A2@T0094
0R@7A00394A400=4000PA00394@T00M400<TA4@06d@2919400=XA4@014@00bA4A003A00394A400=4
00<TA4@00T@01FQ4A4@T00M40R@00d@TA00SA00394A400E400<TA4@00b@014@T92@2A0<T14@49094
12@?A00394A400U400<TA4@00d@00bA4A00AA08T5d@00bA4A00=A0=X00I4R8R/d?42m@03nO[i00?i
1_D00o7Ad006d003dM3a00ge00GimOGim@0:nAOe0_42m@05dO7amM400]001:c@d=02l@06d=7emO7@
0/`6d0We1?T00o[in@05n@Se0]001Lb/[=3<00?@00N/S8b<[8QX009400IXA4A4J4@390=400@TA2@T
0d@490Q400<TA4@03T@00bA4A005A0=X00=4J6P024@39003A2@T00<T00=494@00d@29004A2@TA0@T
00I494A494@89005A2@T94@00R@00d@T900K9003A2@T008T00E492@TA0049003A2@T00LT00=492@0
0R@3A08T0T@49003A2@T00<T0T@390=400<TA4@02T@00bA49003909400<TA2@00R@00d@T9003A0@T
14@290941R@2A08T00=492@01D@290Y4000LA00394A400A400<TA4@06T@290a400<TA4@04d@00bA4
9006A00394A400e40R@5A0<T0d@00bA4A00MA006J4A4J4AX1d@390E400HTA4@TA2@3A0LT0d@00bA4
A007A00394A402A400<TA4@01D@012A4A4@2J0E400<TA4@00T@00bA4A008A006J4A4A6R80VP01hQX
J:c<d?400_D2nP03nO[i00;i1OD01]7@d=3<d0?a00?@mOD01_D2n@Se00?imOX00_T01_[enOWenQCe
00CamM7@1=400m3Ad@02d006[<c@d<cA0m02l@;@00B/d=3a0m000lb/m@06m@;i00?en_T00_X2n@05
mOWjnOD00_T4m@03lLc<00:/00?<[<`00l`00hb8R002R003J4A4009400<TA4@00T@390E40b@3A003
94A400Q400<TA4@02T@00fQ4900290I400@TA4AX2T@290=412@7A00494A4A1DT00A492A412@00d@T
900G9003A2@T01HT00A494@T0T@00bA490029003A2@T008T0T@29003A2A400=40R@2A0<T0T@00bA4
9002A08T00A494A40b@8A0<T00=492@012@00dAXA003A08T00=494@02D@012A492@3A0<T24@002=4
00<TA4@05T@00bA4A00290Q400<TA2@00T@00bA4A002A00394A400I400<TA4@00R@8A00694A4A2A4
0b@=A08T0d@3909400<TA4@01D@00bA4A00CA00394A400=400=XA4@024@00bA4A003A08T0T@00bA4
A004A00394A400A40R@00d@TA002A08T4D@00bA4A002A00394A400Q400<TA4@024@012A4A2@2A08T
1T@016Q492@2A00594A4A2@024@00fQ4A002A0IX0XP00jc<d002m@03nO[j00;j00?in_T01OD00o7e
m@0Em@05nOGinOD00_T01?GimOT2m@03nOGe00We00OamOGedOGa00;e00?adM001]000m7@d004d004
dJc<[0;<00>/d=000]000lb/[002[0?<0]03m@03n_Wi00?i00?jnOX01oD01_WemOGAl@;<0j`01<b/
c:`2S0:816P6A0DT00A492A412@3A00394A400]40R@00d@T9003A0<T0T@590E400@TJ6QX24@00bA4
A00690I400<TA4@00d@59003A2A400940b@00d@T9003909422@00d@T900K9003A2A400LT00=492@0
1b@00d@TA002A0PT00A492@T0d@00bA4900290=400<TA2@00R@00d@TA006909400<TA2@00T@29094
00<TA4@00T@5909400<TA4@01d@390E400<TA2@04d@004U400<TA4@01d@00fQ4A00CA00394A400A4
0b@>A00494A490E400HTA4A494@290M40VP00hQ4A00?A003J4A400=400DTA4A4J0029003A2A4008T
2D@290M40R@5A08T44@290=400<TA4@00d@290=40R@9A08T3T@00bA4A006A00394A400A400=XA6P0
0T@5J00:R6R<R8b/d?7en@Gj0_T@m@;i1?D4n@[e00KimOWimOT6m@03lOGa00Ka00?elM400_401=3e
d<`2[003d<c<00;@00C<d=3@0/`00jc<[002[004S:b/[0;<1Z`3c005d?GemOT01?X3n@04n_Gen@Ke
00Gad=7A[002c003S:b/00:/00>8S8P01FP7A00494@T90941b@4A09X2T@59003A2A400@T0d@29003
A2A400=40R@00dAXA003A0@T00A494A41b@00d@T9008A0DT00=492@00d@A90944B@2A08T0T@590A4
0b@00d@T900:9003A2A400=412@00d@T9005909400@TA4A40R@5A0<T0d@49003A2@T00E40R@:A003
94A401A400<TA4@04T@1J00014@00fQ4A00IA00394@T01Q400<TA4@024@00bA4A006A00394A400I4
00<TA4@014@290A400<TA4@01T@012A4A2@9A003J4A400940R@<A00394@T009400=XA4@00d@2J0a4
00<TA4@00T@2J0A40R@4A00494@T90=400<TA4@00R@4A00394A400I412@EA08T0T@00bA4A004A08T
0T@00bA49009A00394A400a40R@6A0<T2T@016Q4A4@4J0>800><[?400_D7nP;i2?D01OWenOWe00Ci
0oD2nASe0m400o7Am@02l@;e00CAlM7A0]001Lb/[:c<00:/1]03[003S=3<00>/0h`00jb<S007[006
d?7amO[i1?X:m@03lM7@00?@1j`01Hb/[8QX009400=XR4@024@290=400<TA2@00b@4A09X2T@49003
A2@T00DT14@00bA4A003A0<T00=4J4@00d@5909422@4A00394AX00A412@2A0<T0T@00bA4900<9094
4R@3A0<T00=492@01R@01D@T92A400`T00=492@00T@59003A2@T00940b@2A08T0T@01bA492A494@0
12@00d@T90039003A2@T00I40R@9A08T1d@012A4A2@:A00394A401940FP002540R@OA08T0d@00bA4
A003A08T0d@29004A2@T91A40b@2A00994A494@TA6R8009X0d@290e400<TA4@03d@00bA49003A003
94A400A400=XA4@00T@01BA4A4@T00941R@4A0DT2d@390U400<TA4@00T@00fQ4A004A0DT5D@00bA4
A00<A00394A400I400<TA4@03D@01FQ4J8QX00>80X`01=3emOD6nP04nOGen@Ce0_T00o[in@02nP;i
00KjnOWimOTFm@;a1M001?GalM42d005dM3@[<`00Z`2S0B/0]000lb/[002[0:<0j`028b8J8b/S:b<
0j`00hb/S002[003d=7e00;j0_T:m@06lM7@c:c@0Z`2R004[8R8R0><00=XA4@00T@3J0940R@4A0<T
0d@590I400<TA2@01D@59003A2@T00PT14@39003A2A400I400<TA2@012@00d@T900490e42b@2A0TT
00=492@04B@2A08T00=492@00b@2A0<T00=492@04B@2A0hT00E492@TA0049003A2A400dT00=492@0
0R@3A003J4@T00@T0T@00bA4A002A0HT14@01RA492A490=40R@4A08T4D@003Y400<TA4@03T@00bA4
A004A00394A401E400@TA4@T1D@390=400=XR6P024@01BA4A2A400@T4d@00bA4A00290E400<TA2@0
14@290A400<TA4@00b@3A0DT8D@016Q4A6P3A00394@T01=400<TA2@014@00bA4A003A00594A4A2@0
3d@00fQ4A008A0AX00J8J8R<[=03m@03nO[j00;j0oT2nP;i00?jnOT00oX2n@;j0_T00oGin@03nACe
0_43d003lM7a00?@00CAd<c<0Z`01/b/R:c<[0><00G@[:b/R002S006R6QXR8b80fP2S004J8R<S0:8
00=XR8P00Z`00m3em@04m@03lM3a00;e00?Ad=400]000lb/[003[00:R6QXR6R<J8b8J0A400=XA4@0
0T@390E400@TA4A40R@00d@T900290U400<TA4@00T@390=422@6A0<T0T@290A400DTA2@TA00=9094
12@3A0@T00E492@TA0049003A2@T00DT0T@590945R@00d@TA00290940R@00d@T90089003A2@T00<T
00E492@TA0089004A2A4A08T00=492@012@014@TA4@290A400HTA2@TA2@8A00394@T00<T0T@39094
00<TA2@01R@00d@T9008A00394@T00<T2D@00fQ4A005A000Bd@00bA4A00?A00394A400]400<TA4@0
0d@00bA49002A00394A400=X0T@00fQ4A00290E40b@2A08T2d@00bA4A006A00394A400=400<TA4@0
2D@290A40R@3A0HT0T@00bA4A00;A00594A4A2@00d@00fQ49008A0<T3D@00fQ4A009A00394A40094
0R@HA09X2T@2J003A6QX00:800><[=000_D00oWjnP0@nP03nO[j00;j0_T00o[inP02nP03nOGe013e
00GAlM7Ad002l@05dM3@d=400]02c005[=2/[8`00Z`01hb/R:b<[8`01HP016R8S8`2R006J8b8R6R8
0VP00dAXS002R005S:c@d=400_401?G@d=42d005c=2/[<`00Z`00hQXJ002J005A6Q4J4@00fP3A004
J4A4A0DT1D@290940R@4A00594A4A6P01D@39004A2@T909400@TA4A41R@2A004J4A490941B@2A003
J4A400E40R@00d@T9005909400@TA2@T0T@?9003J2@T00LT0T@49003A2@T01HT00=492@01R@01D@T
92A401LT0T@00bA4A00:90A40R@5A00394@T00a400PTA2@TA2A4909400@TA4A412@01T@T94@TA0DT
1d@01BA4A4@T00A400=XA4@01T@000]400=XA4@0?D@00bA4A00KA00394A400m400=XA4@00d@290E4
0R@3A08T0d@00fQ4A008A003J4A400Q400<TA4@034@01RA4A2A490=40R@2A00394A400e400=XA4@0
0d@01BA4J6Q4008T1d@390A400DTA4A4900@A08T1T@00bA4A005A08T3T@00fQ4A008A003J4A40094
00=XR6P00XP2d003lOGe00Gj00?in_X02_X00oWjnP02nP;i00CjnO[j0_D01OWemOGa00?e00GimOGe
l@02m@05dOGAlOD00]401O7@dJc<00?@00Ge[<b/d002[007R6R<R6R<R003S0EX00=4J8P00XP2J003
S8R800QX00>/R:`00Z`2d00AlM3@c=2/d:b8S:b8S:b8J4@00VP01DAXJ4AX009400AXA4AX1D@79094
00DTA4A49005A00394A400M40b@00d@T9009A0@T2T@490A40b@2A08T00=494@00b@3A0HT00=492@0
2b@4A0<T00=492@032@00d@T90079003A2@T008T0T@49005A2@T94@012@01D@T92A400<T00=494@0
0T@290=400<TA2@00b@2A0<T0T@00bA490049003A2A4008T00=494@012@3A08T00=494@01D@00bA4
A007A00494@T90E412@014@T92@2A0DT00=494@00d@00fQ4A005A005J4A4A2@00d@2J0540FP004E4
00DTA4A49005A00394A400I400DTA4A4900:A00394@T00m400<TA4@014@390I40R@7A003J4A400M4
00<TA4@01T@490=400<TA4@024@01RA4A2A490=40R@2A00394A401E40VP;A08T1D@29003A2A401E4
0R@8A08T6T@00fQ4A002A09X0XP018c<d?D2nA3j00?in_T01oX00oWem@0Bm@05lOGamM000m46d0;<
1:`3R006J8R8S8QX0XP6J003A8QX009X0X`01HQXJ4AX00:80VP00hb8[002S004[8b/S0:/00F8S8b8
J002R003S6R800=40VP00dAXA009A00394A400941B@5A0<T14@29003A6Q400=41B@3A0<T0d@990M4
00@TA2A41B@014@T92@4A0<T00=492@014@69003A2@T00XT00A494A40R@2A0PT00=492@00b@00d@T
9002A0DT00=492@00b@3A08T00E492@TA00690=41R@00d@T900:90941b@2A0DT0T@5909400<TA4@0
0R@3A0<T0T@39005A2@T94@00R@4A00394A400=40b@3A00494@T90M400<TA4@01T@290e40010A005
94A4A2@00T@00bA4A005A00394A400E400<TA4@00R@9A00394A400a40R@5A00394A400<T0T@00bA4
A005A00394A400I400<TA2@01D@012A492@5A00494@T909400<TA4@02D@00bA4A002A08T0d@012A4
92@5A0DT5T@012A4A4@290E40b@>A0<T1T@290E400DTA4A4900OA003J4B800>800F/dOGim@02n@04
n_Wjn@;j00?in_X01?X3n@03n_Wj00?j0_TGm@07dM3Ad?7Al@02d@06d=7@d:c@1J`2R003S8R8009X
0hP00fQ4J003J09400=XR6P00fP3A0=X0XP00haXJ00?J0I41FP9A00494A4A0@T1D@4909400EXA2A4
J004A0LT00A492@T0d@;90A412@5A00794@TA2A49002A0<T00=492@02R@2A0LT00=492@012@00d@T
900=9004A2A4A08T0T@00bA49004909412@00d@T9002A0@T00E494A49004A0<T00=494@00T@99094
1R@4A0DT00=494@01b@014@T92@3A0<T1D@690U400<TA2@00R@3A0@T14@00bA4A004A0<T00=494@0
3T@003a40R@4A00394A400I400DTA2A49009A00494A490a400<TA4@02D@00bA4A003A00394A400@T
00A494AX1T@00bA4A008A00594A496P014@012A4A2@6A00394A400M400<TA4@02T@690A40b@BA003
94A4009400<TA4@06D@00bA4A005A08T1d@00bA4A00DA00394A400U400=XA6P016P00hS@m@03m@;i
00CjnOWj1oT01?[inOX3n@?j0oT00oGim@0?m@04lOGAm@;a00[AlO7Ad?7@lM2/0]03[003S:b/00:<
00B8J4A416P00hQXJ002J0940XP01VQ4A4AXA09X0T@00hQXJ00GA003J4AX009X24@69003A2@T008T
14@390e442@014@T94@39004A2A4A08T2D@39003A2@T008T00A492A40b@2A0<T1D@99003A2@T008T
00I492@TA2@2A0PT00=492@03R@00d@TA002A0XT00=492@00b@01D@T92A400<T00=492@04B@2A08T
0d@990940R@2A0DT14@890U400@TA4@T4D@291=4000RA00394A400U400<TA4@03T@290U400DTA4@T
A0039003A2A400=40b@2A00394A400=400<TA4@01D@012A4A4@290=400<TA4@01D@00bA4900590=4
0R@3A08T34@00bA4A002A08T3d@00bA4A00290=400<TA4@024@59003A2@T00<T4D@39003A2A4008T
00=494@07T@00bA4A00NA08T2d@3J09400EXR:c<d002m@05nO[jn_T00_X00oWen@03n@;j00Cin_[e
2?X2n@Ke00GamOGan@06m@03dOGe00Ge00G@lM7@d@02[005c:b/R8`00j`00hQXA002A09X0XP3A09X
00=4J8`00VP5A003J8R/00940VP00dAXA00>A003J4A400940VP2A003R4A400M41B@00dAXA00390=4
12@<A08T00<092@00R@00d@T90039003A2A400=400<TA2@01B@6A00494@T90941R@00d@T900590=4
0R@4A0/T0T@00bA49002A00394A400=42R@00d@T90069005A2@T94@01B@2A0<T00A492@T0T@012A4
92@7A08T0T@29003A2@T00A400DTA2@TA00490940b@2A0PT1D@00bA4A00;90941B@5A0@T0T@390A4
00<TA4@01d@390A400@TA4AX2d@002i400<TA4@03d@00bA4900;A08T0T@00bA4A002A0@T00=494@0
0d@00bA4900<A00394@T009400<TA4@00b@00d@TA00690=412@2A0<T1D@00fQ4A002A0<T0T@00bA4
900>A00394A400<T2D@016Q4A4@490940R@00d@TA009A003J4A400940R@00d@T9002A00494@T90Q4
00DTA4A4900;A003J4A400I40R@2A00394A400E40R@>A08T0d@00bA4A009A005J4AXJ4@00fP2S003
[=3a00?e0_T00o[inP04n@;j00?in_X01OX01?Wjn_X2n@ke00?amOD01OD00o7el@03d@03d?7@00:/
00O<S:b/c:b<00:816P02XR<S8QXA6Q4J8P4J0E400IXS6Q4J8P6A00394A4009X0T@39003A6QX00A4
00=XA4@014@012A4A2@3A08T00=494@01D@00bA4A00490E400<TA4@01D@=909400<TA4@00R@01D@T
92A4008T0T@79006A2A4A2A412@014@T94@59003A2@T008T00=492@022@2A00394@T009412@4A0dT
00=492@00R@2A0HT1D@290940R@2A00394A4008T0d@012A492@2A00394@T00@T0T@01BA4A4@T00=4
00<TA4@01R@3A00394A4008T00=494@00d@00bA4900A9003A2A400@T00A492A40R@00d@TA00=A08T
0d@016Q4A2@=A000>T@00bA4A003A00394A400@T1T@00bA4A007A00394A400=400<TA4@00T@01BA4
A4@T00e41R@5A0<T1D@00bA4900390I40R@5A08T00E492A4900BA08T0T@290Y412@5A00394A400i4
00<TA2@00d@490Q400<TA4@05T@490I412@3A09X0d@00bA4A003A00394A4019400AXA6Q40VP00hR/
[002l@?e1?T00o[inP09nP08mOWinO[imOTGm@;A00G@dM2/c006[004S:b8R0=X1HP3J007R6R8R6Q4
R006A09X00E4J4A4J005A00394A400=412@2A003J4A4009400=XA4@00d@29003A2@T00HT1T@49003
A2@T00]41R@00d@T900:9004A2@TA0<T0T@290=412@00d@TA00290941B@2A00394@T00<T00A494A4
0R@00d@T90039004A2@T90Q40R@014@T92@2A0dT00=494@02R@2A0HT00E492@TA0069003A2@T00<T
00=492@00b@3A0`T0T@39003A2@T00=400<TA2@00R@3A00494A490941R@2A0TT14@012A4A2@3A003
94@T00A400<TA2@00T@00bA4A002A00494A49194000hA08T24@290Y400<TA4@034@3909400<TA4@0
0T@022A4A2A494@T3d@00bA49003A08T00=492@00T@00bA4A005A00394@T008T0T@012A492@3A003
94A400Q400<TA4@00T@390A400<TA4@014@012A4A4@390A400@TA2@T34@01RA492A4909400<TA4@0
1d@01RA492A4915400@TA4@T0T@4915400<TA4@00R@GA00:J4A4J4AXR8c<[0;@1_D3n@Kj00Cin_[j
1_TGm@04lOG@l@;@2Z`018b8J6P2S004R6QXA09X00B<R6QX34@2J0=400=XA4@00T@390I400<TA4@0
24@00fQ4A003A00394A400@T00=494@00d@890940VP5A00394@T00@T00A492A42b@2A0<T0d@012A4
A4@9909412@00d@T900?9003A2A400940R@2A00594@TA2@00T@5909422@00d@T90069003A2@T00DT
0T@39004A2@TA0@T00A492A412@2A0@T0T@B90A40b@00d@TA002A0/T00=492@00d@00bA4900@9003
A2A400=40b@3A00394@T00941R@00d@T9004A00494@T90Y4000=A09X0d@00fQ4A00KA003J4A400U4
00<TA4@00d@00bA4A00>A00394A400Q400DTA4A49006A00394A400M400<TA4@01d@012A4A2@6A003
94A400e400<TA4@00b@EA08T14@00bA4A004A08T0T@390=40b@00d@TA007A00394A400@T0T@012A4
92@4A00394A4009400<TA2@01d@00fQ4J008A00594A4A2@014@00bA4900?A00394@T00940R@KA0AX
00F8[=3<d007m@03nO[j00[j0_T01?[inOT4m@03nOGe00ce00?amOD00_D01=7@d<`4[009d:b/c:b<
[8QX00:80fP00dAXJ002S003R6QX00I400=XA4@024@2909412@5A08T1D@390940b@014@TA4@790=4
0b@00d@T900490E400DTA2@TA00790E432@01D@T94@T00A412@3A10T00=492@00b@01D@T94@T00=4
0R@8A0DT0d@00bA490069004A2@TA0HT00A492@T24@00bA4A0049004A2@TA0@T0T@59003A2@T00DT
00A492@T0T@590A400<TA4@012@4A0DT00=492@00d@012A4A4@390940R@00d@T90039003A2@T008T
1d@00bA4A002A00394@T008T00=492@00d@290E412@:A0004T@00fQ4A00XA00394A400U400<TA2@0
0T@012A4A4@29003A2A400U400LTA4A494@T00940R@7A00394A400Q400<TA2@00R@CA08T0T@39094
0R@@A00394A4009400DTA4A49003A00394@T00=40R@=A00394A400=412@5A00394A4008T00A492A4
0b@00d@TA00CA00394@T008T34@290Q412@MA09X0XP01Hb/[<c@00Ge0oT?nP03nOGi01Ke00KadM3@
[<`3[0;<00B/c8b<0Z`018QXJ8P3J003R6R800:80VP2A003J4A400I400<TA4@00T@3909400HTA4@T
A2@2A0HT0d@01BA492A400<T00=494@00T@490A40b@2A0DT1D@490=41b@2A0DT00=492@01B@3A08T
14@00bA49005A0dT00=492@01B@00d@TA00390940R@00d@TA005A00394@T008T0d@39003A2@T00HT
00=492@012@3A00394A4009400@TA4A40R@014@T92@2A0LT0T@79004A2@TA08T00E492@TA00290=4
00DTA2@TA0029003A2@T00<T0T@5909400@TA2A40R@3A0LT00=492@00b@2A0DT1D@290=400<TA4@0
0R@00d@TA002A0<T0d@012A492@<A000>d@01BA4A4@T00A400TTA4A494@TA2@00T@00bA4A002A003
94@T00=400<TA4@01T@00bA49004A00394A400e400@TA4A40b@5A00394A400e400@TA2@T14@00bA4
A00<A00394A400E400<TA4@014@39004A2A4A08T4d@49003A2A400@T1D@29003A2A400I400<TA4@0
2d@012A494@390a40b@;A00394A401E400=XA4@00T@01FR8R6R<00:800B/c=3a1?D3n@oj00?imOD0
0_D01?WemOT?m@;a00KAmM3Ac:`2d003[<b/00F/00n<R6R8S8QXA8QXA8QXA6P01T@00bA4900;9094
00<TA2@02B@4A08T00=492@014@69003A2@T00@T0T@29003A2A400E412@3A0<T0T@290941b@3A0DT
1T@490E40b@00d@TA007909400<TA2@00R@2A0/T1D@00bA4A004A0LT0T@@9004A2@T909400<TA2@0
0b@3A0<T0T@00bA4A00390940b@2A0<T00=492@00b@014@T92@2A0@T00A492A41B@00d@T90049003
A2@T00DT0d@:90E41B@5A08T0d@690A400<TA2@02D@00fQ4A007A000=d@01RA4A2A490=400<TA4@0
84@4909400<TA4@024@00bA4A007A00394A400A40R@2A08T3D@590A400<TA4@01T@890U412@5A08T
1D@39004A2A490942R@00d@T900390I412@3A0<T14@00bA4A002A08T0T@390A400<TA4@01T@29094
00<TA4@00d@00bA4A004A00394@T00m400LTA4A4J8QX00E400=XR6P00VP2R0:/00?@mOD01?D00oWj
nP08nP;i0_X00oWen@03m@05nO[inOD00_T@m@04lM7<c0J/0X`00jb8[002S003R:b800>800AXA6Q4
0VP3A0dT00=492@00d@<90I40b@2A0PT00=492@02R@2A08T0T@00bA49003A0DT00=492@04B@5A0@T
1T@B90=42b@3A0TT0T@590A44b@00d@T9005909400DTA2@TA00290940R@3A0<T00=492@00R@01T@T
A2A490942B@2A0XT00=494@052@3A0@T0d@4909400<TA2@00b@01D@TA4@T00I40b@AA000=d@01BA4
A4@T00E40R@2A08T0T@00bA4A003A00394A400E40R@5A00394@T00A400@TA4A40R@2A00494A4A0<T
2d@00bA4A006A00394A400I400=XA4@014@00bA4A00290e400<TA4@01b@7A00694@T94@T2T@89003
A2@T00DT00E492A49004A00394A400=400<TA4@01D@390=400DTA4A49006A08T2D@012A4A2@3A08T
0T@29003A2A400I41B@6A00494A490E400AXR6QX1D@4J0:80X`00lc@d@04m@_j0oT2nP03nO[e00;j
00?in_X00oT01?[imOT;m@;a00CAd:cA2J`5R005S6R8R4@00VP6A0TT00=492@01B@2A0lT14@79003
A2@T00hT1d@00bA490069005A2@T94@02b@3A0DT0T@012A494@49003A2@T00A41B@00d@T90089003
A2@T00/T0d@39003A2@T00<T00=492@01B@2A0PT00=494@01R@00d@T90059003A2@T00`T0T@:9003
A2@T01DT00A492@T0T@29004A2A4A0DT0T@5909422@9A0<T0d@00bA49005A00394A400=400<TA4@0
2d@190540D@001]400=XA4@07d@00bA4A00290U400<TA4@04d@00bA4A004A08T5T@292=40R@014@T
92@3A00694A494@T14@00bA49003909400<TA2@02D@290M400DTA4A49004A08T24@00fQ4A002A003
J4A400940b@2A08T34@00bA4A002A00394A400Q400<TA4@02d@390E400<TA4@02T@00fQ4J007A0=X
00N8J8b<R=7@00?e00?imOX01_X00oWjnP02n@06n_Wjn_Gj0_T01o[en_Wen_T01?D00oWen@09m@03
d?7@00;<0Z`01]7<[8S<S0:/00>8J6P00hP8A00394A4009400@TA4A42R@3A00494@T90940R@00d@T
9006A0<T0T@01BA492A400PT00=492@012@01D@T92AX00A40b@4A0<T00=492@01b@:A0<T0T@012A4
94@290U43B@3A0<T00=494@00T@2909400@TA4A40R@014@T94@290941R@2A08T0T@:90A43B@01d@T
A2A494@00R@2A0DT0T@49003A2@T00DT0T@99003A2@T00940b@2A00394A400HT0d@00fPT90029094
00<TA2@01B@2A00394A4009X0T@390A412@6A00394A400940R@00d@TA00:A05X000/A00394A401=4
0R@9A00394A400=400<TA4@02D@00bA4A004A0DT14@012A492@4A00494@T90A400<TA4@01d@290e4
0R@:A0HT14@00bA4A005A0TT00=492@00R@5A00494A4A08T1D@39003A2@T00a400DTA4A49004A08T
00A492A41B@5A08T14@00bA4A002A00394A400Q40R@7A08T14@291940VP9A008R6QXJ8b8[=02d@?e
00GjnO[jn@0=nP06nO[jnO[i0_X2n@03n_Gi00;e00?imOD01?D02?7emM7@dLcA0Z`00m2/[002[004
R8b<S0:800AXS8QX2D@00bA4A00290=42R@3A0DT14@00bA4A006A0@T00=492@00R@3A0DT00A492@T
0T@590E40b@3A0DT00=494@012@2A0DT00=494@00T@390A412@4A0HT00=492@02B@2A0XT1d@29003
A2@T00<T00=492@05R@3A0hT14@00bA4900<909412@00d@T900<909400<TA2@00R@00d@T90029003
A2@T00LT00=492@00R@014@TA4@69003A2A400M40b@00d@T900290Q400<TA4@00T@490]40FP002i4
00<TA4@06d@490M400<TA4@014@00bA4A006A00494@T90e400<TA4@00R@2A00394A400940R@00d@T
A00290e40R@BA0<T1d@29003A2A4009400<TA2@01B@014@TA4@2909400<TA4@014@39003A2A400M4
00=XA4@00T@00bA4A007A00394@T009400<TA4@00T@00bA4A008A0@T0T@012A4A2@6A00394A400a4
00<TA4@03D@00bA4J007A003J4AX00A40VP2R005S<c<d?400oD00oWjnP02nP03nO[j00Gj00?in_T0
0_T01?[inOX4n@03mOWe00Oe00CadOGA0o44d0V/0X`018R<S8P3J0E40R@2A0@T0d@49003A2@T00<T
00=492@01R@2A003J4A400A41B@4A0<T0T@79003A2@T00/T14@?90A41B@4A08T0d@49003A2A40094
12@00d@TA00=909400<TA2@01B@4A00594A4A2@00T@00bA490079004A2@TA0TT00A494A40R@01D@T
92A400PT00=492@00R@3A0PT00=492@01R@014@T92@2A0HT00A492@T0d@00bA49002A08T0T@69003
A2@T00@T14@49004A2@T909400<TA4@01d@01BA492A4008T00=492@00R@5A00494A4A08T24@00fQ4
A004A000=d@00bA4A002A08T2T@012A4A4@290M400DTA4A4900;A00394A400i400<TA4@00T@290I4
00<TA2@014@390Q40R@2A00394A4011400<TA2@014@00bA4A00390=42B@4A00394A400E40VP3A004
94A4J0Q400=XA4@01D@00bA4A003A08T1d@390U400<TA4@01D@290I400<TA4@04T@01BA4A4@T00m4
0VP5A003J4AX00:800B<[:cA1_D00o[in@05nP03nO[i00Gj00?enOD00_T9m@06dO7@dM3A0m001oG@
d=2/c=000Z`2c0:/0XP3S005R6Q4A6P014@390941b@00d@T900390940R@014@T94@39004A2A490Q4
12@5A0XT00=492@01B@00d@T90049003A2@T00lT14@69003A2A400`T14@>9003A2@T008T0T@49004
A2@T90E412@00d@T900290=400<TA2@012@00d@TA0099003A6Q400<T00E494@TA0029003A2@T00LT
00=492@00T@2909412@00d@T90039003A2@T00TT00=494@022@01T@TA2A4909432@2A0@T00=492@0
0R@=A00394@T00@T00=492@00R@00dAXA00490I400<TA4@01T@19054000mA00394A400U400@TA4A4
0b@014@TA4@3909400<TA4@03D@01BA4A4@T00e400<TA4@00d@00bA4A0029004A2@TA0<T0d@00bA4
A00391=40b@2A00394A400E400<TA2@00R@4A0HT0d@2909400<TA4@00T@2J0I400=XA4@02d@00bA4
A006A08T1T@490M400<TA4@00T@290=40R@00d@T9003A00394A400E40R@@A00394A400Y400<TA6P0
14@016Q4A4@2J0:80/`00o7ed005m@;i0_X2n@;j0_D01OWjn_Wj00;e00CimOGj2?D00m3Ad002d003
dJc@00?@0Z`02=2/d<b/R8b/0XP01VR<[:b8J0Q400<TA2@01b@00d@T90089005A2@T94@01R@014@T
94@29003A2A400<T00=492@02R@00d@TA00Q9003A2@T00<T00=492@00b@00d@T900990A43R@014@T
92@3A00394@T00@T00=494@00T@59005A2@TA2@00d@00bA4A0069003A2@T00LT00=492@00b@00d@T
90049003A2A400@T00=492@00b@2A00494A4A0<T0d@39003A2@T01<T00E492@TA0039003A2@T00HT
0d@790940b@4A08T14@2909400<TA2@00R@3A0@T14@390I40R@4A003J4A40094000mA00394A400U4
0R@4A00394A400A400<TA4@00R@7A00394A400A400<TA4@014@290I400@TA4@T14@00bA4A002A003
94@T00DT0T@29003A2@T01E400<TA4@01D@290=41R@4A00394@T008T0d@29003A2@T00=400<TA4@0
0T@00bA4A00>A00394A4011400<TA4@00T@00bA4A002A08T1D@00bA4A00290I400<TA4@00d@490=4
0R@4A0@T0d@290U400=XA4@02d@01fR8S:c@[<`00]42m@07lOGemO[en@02m@Ci00CjnOWi0_D02OWe
mOGimO7el@02m@07d=7@[=2/c003[006lLb/[8b80Z`00hb/[002R003J4B800:80VP8A00494@TA0HT
0T@49003A2@T00TT00=492@01B@01D@T92A400TT00=492@02B@00d@T900>9003A2@T00@T0T@59005
A2@T94@01R@014@T92@2A0LT0T@29003A2A400HT00A492A41B@3A0@T1T@01BA4A4@T00=42R@2A0TT
00A492@T0T@990942R@2A08T0T@00bA49007A0@T00=492@01R@3A0`T00=492@03B@2A0XT0T@00bA4
A007A0DT00E492A49002A0<T34@00fQ49006A04T0D@1A0006D@00bA4A00PA00394A401540R@5A08T
0T@290=40R@6A00394A400e400@TA4@T0T@00bA49007A08T00=492@00d@00bA4A007A00394A40094
00<TA4@00T@00fQ4A00:A003J4A400=412@5A0@T14@290I40R@=A00394A400E400<TA4@01D@00bA4
A00@A0<T1d@390]41B@3A0@T00=492@00R@5A08T0T@00bA4A00<A003J4AX009400EXR8R8S003[003
c=3a00Ge00?imOD00oD01?WemOX;m@08dM3ad:b<[8`3[006S8R/[8b80X`00fR<S002R003[8QX00MX
00I494A4J4@2909422@7A0HT00=492@00b@2A0XT0T@29003A2A400hT00=492@05B@00d@T90059004
A2@TA0<T00=492@01b@00d@T900390I41b@00d@TA003A0@T0T@012A4A4@390940b@5A0@T00=492@0
12@3A0@T00A494A412@2A00394@T00@T00=492@03B@00d@T90069005A2@T94@01b@2A00494A490=4
2R@3A0PT00=492@012@3A0<T14@00bA4900290U41R@014@T92@2A0<T0T@012A4A2@>A00394A40054
000RA00494A491i400<TA4@02D@012A4A4@59003A2A4008T1d@00bA4A006A00694A4A2A40R@4A003
94A400m400<TA2@014@00bA4A005A00494A490I400<TA4@05D@00bA49007909400<TA4@01d@290M4
0R@00d@TA00?A08T24@00bA4A006A00394A400=400DTA4A49007A00494A4A0<T00=492@00d@49004
A2@T91e40VP7R004S:c@d0;a00CelOGa2oD02=7@d=3Ad=7@1:`2R004S6R8R0><00>8c8`00XP01Jb8
J8QX00>800=4J4@01T@290=400@TA4A41B@01d@T94AXA2@014@49003A2@T00@T0T@00bA490039003
A2@T008T14@>9003A2@T00/T00=492@01b@00d@T900>9004A2@TA0HT14@01BA4A4@T00A400DTA2@T
A0099006A2@T94@T0T@4909400<TA4@00b@014@T94@890M40R@2A0<T0d@690=400<TA2@022@00d@T
90039003A2@T00HT0T@00fQ4A00490E40R@00d@T900>9003A2@T00XT00=494@00R@6A0@T00=494@0
0d@012A4A2@6A0<T0T@390e400<TA4@024@003I400=XA4@05d@00bA4A003A00494A4A0@T5D@012A4
A2@3A00394@T00e400<TA4@01D@00bA4A008A00394A400Y400<TA4@044@29003A2A400DT2D@29004
A2@T90=41B@00d@TA002A08T14@00bA4A00GA00394A400m40R@2A0<T00A492@T0d@012A4A4@290M4
00<TA4@02D@00fQ4A008A0AX00N8J8R8J8b800:/0]001?7@[=47m@0:d?7@d?6/R:b<J0><00J/J6R8
S:`2R0:/00B<R8R/0hP02JaXJ6Q4R6Q4J00<A00394A400<T0T@590940R@01T@TA4@TA0PT0T@99003
A2A400=43R@2A08T00=492@012@00d@T90099003A2@T00944B@2A00394@T00@T00A492@T1T@290E4
1B@01D@T92A400<T00=4J4@00T@00bA49002A0DT1D@29004A2A490E400@TA2@T0d@00bA4A002A0@T
00A494@T0T@012A4A4@390941R@2A08T0d@2909400<TA:`00T@490A40R@3A0TT0T@012A4A2@5A0PT
2d@00bA4A00290A400DTA4A49002A00494@TA0<T0T@490e400=XA4@01d@002=400<TA2@044@00fQ4
A00EA00594A4A2@01T@00bA49002A08T00=494@02d@290=400<TA4@01D@00bA4A00:A00494@T90I4
1B@2A0HT1T@01BA4A4@T00M40R@7A0DT00=492@01D@00bA4A007A08T00A492A412@4A00594A4A2@0
2d@00bA4A004A00394A400U40b@5A00494A490M400<TA4@03R@00d@T900290E412@01D@T94@T00I4
00<TA4@01T@9J003R8b/00:/00?@[=000]02m@04lM7@m@?@0Z`00hb8R002J007R6R8R6R8J004R006
S8R8R6R80fP2R003J4AX009X0T@290E40R@4A00394@T00<T00=492@012@00d@T90059003A2@T00<T
00=494@00T@990A43R@00d@T900I90946B@3A08T00=494@00T@00bA4A002A0<T00=492@01R@014@T
92@2A00394A400A412@00d@TA004A0<T0T@012A4A4@69003A2@T00940R@00d@T900<9004A2@T9094
0R@2A00494A4A0HT0d@2J003A2@T008T0T@012A492@2A0dT1D@00bA4A002A0HT0d@390I41R@2A0HT
00A492A41R@2A00594@TA2@01D@00bA4A004A00394AX00E40FP0019400=XA4@0?d@01BA4A4@T00I4
00<TA4@02d@00bA4A00290m400DTA4A49003A08T24@29003A2@T008T00=492@00T@2909400<TA2@0
12@00dAXA002A00594@T94@00VP3A00394@T009400<TA2@012@2A00394A400E400<TA2@01T@290A4
0b@014@TA6P@A0<T2d@390=400<TA4@02D@012A4A4@49003A2@T00940R@2A00494@T90I400@TA4@T
0T@390E400<TA4@014@00fQ4J004J0=400IXR8QXR6P4R0R/0h`00jb8S002J005S8QXJ8P00VP3R09X
18P2J09400AXA8R80d@00fQ4A00590M400<TA2@01B@00d@T900E9003A2A400PT0T@B9003A2@T00@T
00<092@00b@00d@T9004909412@4A0`T00=492@01B@00d@TA002A00394A4009412@5A0/T0T@29003
A2@T00=400<TA2@00R@3A00394@T00DT14@01BA492A400<T0d@00bA4A002A08T00=492@01B@00d@T
900490A422@00d@T9004909400AXA2@T0d@00bA4A00=9003A2@T00<T0T@79003A2@T00HT0T@49003
A2@T00@T0d@00bA4A003A00594@T94@00R@00d@T9003A00494@T90I400@TA2@T14@2J0A40FP1A000
Dd@00bA4A005A00594A4A2@03D@00bA4A00@A00594@TA2@01D@290940R@;A00394A4009400<TA2@0
1R@3A00394A400940R@3A08T14@390941B@:A00794A4A2A49009A00394A400I400<TA4@02d@290Y4
0R@8A08T2T@012A492@5A0@T00=494@02T@590940R@:A09X00=4J4@01T@3J003R6R8009X0hP2J0N8
00B<R8R816P4R004J8QXA0=X00>8J6P014@2J0M412@2A08T00E492@TA00I90943R@5A0@T00=492@0
22@2A0/T00A492@00b@3A08T0d@00bA490059003A2@T008T0T@00bA4A0049004A2@T90I40b@2A1lT
14@490E400@TA4@T0T@00bA4900290A44R@2A00694A4A2A42R@2A09X00=492@02B@00d@T900390=4
2B@00d@T900290941b@01D@T92A400HT00E494A49009A00394A4008T0d@290940R@9A00394@T00A4
00=XA4@01T@005]40R@00d@T900:A00394A400Y400<TA4@024@29003A2A400A400<TA4@05D@89094
0R@2A00694A494@T0d@29007A2A494@TA00290]41b@3A08T00=494@02D@591=40R@00d@T900BA005
94A4A2@01T@590e412@00d@T900;A09X14@01FQ4A6Q400=X00F8J6QXA005J006A8QXJ8QX0XP00fR8
J002J003[6R800:80VP018QXA4@3J0E40fP2A003J4A400=40R@2A0<T00Q492@TA2A4909412@00d@T
9003909400@TA2@T0T@8909412@00d@T9006A0lT0T@B9003A2A400A400<TA2@01b@014@T92@2A08T
0d@89003A2@T00DT00A492A44B@00d@T900990=412@5A00394A4008T1d@00bA4A0079003A2A400PT
0d@00bA4A002A0LT0T@290=40b@014@T92@3A0HT00=492@00d@00bA4900890=44R@2A08T00=492@0
14@00bA4A005A08T1T@390I40R@2A00394A400]4001BA00394A400U400<TA2@00T@00bA49007A003
94A400940b@9A00494@T90=400<TA4@00T@39003A2A400940R@>A0@T00=494@00T@290e40R@4A005
94A4A2@01T@00bA4A002A08T0T@01RA4A4@TA08T0d@012A4A2@3A00394A400@T4d@490=40b@=A0<T
24@790]41R@DA003J:aX00AX00>8J6P00fP2R09X00>8J8P00fP00dAXJ00;J005A6QXR6P014@016Q4
A6P8A00394A400=40b@00d@TA002A0@T00=492@022@3A08T0T@>90940b@2A0HT0d@89003A2@T00TT
00=492@00b@014@T92@4A0LT00=494@00b@4A08T00=492@01b@2A0HT0T@;90944B@6A0<T1T@590U4
00<TA2@012@2A0LT00=494@01D@49003A2@T008T00=492@00R@00d@T9002A0<T0d@49005A2@TA2@0
1T@39004A2@TA08T00A492A40R@00d@T90029003A2@T00XT0T@290Y400<TA2@00b@2A003J4@T008T
1D@00bA4A002A00594@TA2@02D@004m400DTA4A4900<A00394A400U400@TA4@T0T@00bA4A004A003
94A400A400<TA4@00R@5A08T00=492@00T@012A4A2@5A00594A4A2@00d@49003A2A400=400HTA4A4
94@290=40R@024@T92A494@T1d@00bA4A00290940b@8A0<T0T@5909400<TA4@03T@00bA4A004A08T
00A492@T0T@012A4A2@4A00394@T00e400<TA2@00b@2A08T00E494A49002A00394A400941R@=A003
94A400E40XP2J003R6QX00=X00B8J8R80T@2J0:80fP014AXJ4@4J003A6QX009X0T@016Q4J6PDA0@T
0T@00bA4900:9003A2@T00HT0T@00bA4900;9003A2@T00<T00E492@TA00;9004A2@TA08T00=492@0
1R@00d@T900890943B@00d@T9004A0TT00=492@014@;909400@TA4A43b@00d@TA006A0<T1D@:90A4
1b@014@T94@5909400=XA4@00d@59006A2@TA2A40b@00d@T90049006A2@TA2A412@014@T92@5A0<T
0T@00bA490029003A2@T010T00A494AX24@00bA4A006A08T14@39003A2@T00]400@TA4@T14@1J054
0D@0025400=XA4@0?4@3909400<TA4@014@012A4A2@:A00394A400940R@8A00494A4A08T00=494@0
2D@290I41B@00d@TA00290940R@00d@T9002A0HT00=494@00d@00bA4A007A0HT24@89003A2A40094
00@TA4@T1T@00bA4A002A0DT0T@390=412@3A0@T0d@00bA49007A00394A400<T0T@00bA4A005A08T
0T@012A4A2@<A08T14@290U41VP014AXJ8P4J005A6QXJ8P00d@00fQ4A004A006J4AXJ4B85d@01BA4
92A4008T00A492A432@2A0<T00=492@032@00d@T900C9004A2A4A1XT00=492@022@7A00394A40094
32@3A0/T00=492@00d@A90E41B@5A00394A400941b@014@T94@59003A2@T00LT1d@990941b@2A0lT
0T@00bA4A00390941B@00d@T900990941R@00d@TA00390U400@TA4A42B@014@TA2@>A08T0d@1J054
0B@003M400<TA4@01T@00bA4A00QA00394A4009400HTA4A494@2909400<TA4@01D@00fQ4A002A003
94A400I400@TA4A40R@3A00594A4A2@00d@390Q42b@3A00394@T00<T0T@6909412@5A0<T0T@590A4
12@4A08T0d@49004A2@TA0DT0T@:9004A2A4A08T14@00bA49002909400<TA2@00b@2A0HT0T@69003
A2@T00XT44@00bA4A002A00394A400I40fP3A09X00=4J4@00fP2A0AX0T@00fQ4A006J003A6Q401A4
0R@00d@T900@9004A2@TA0/T0d@69003A2@T00<T00=492@03B@4A0HT00=492@02b@2A0hT0d@00bA4
A002A00494A4A0LT0T@690=40R@00d@T9002A00494A4A0dT00E492@TA00390E40R@6A00394A400E4
1B@2A0@T00=494@032@5A0LT00A492A42B@00d@TA0069003A2@T00@T00=492@01B@00d@T90029003
A2A400@T00=492@01b@014@TA2@2A00394A400@T14@490A41B@2A00394@T00E400<TA4@01D@00bA4
A008A0003D@00bA4A00JA003J4A400]400@TA4@T6D@00bA4A00;A00394A400Q40R@?A00594A4A2@0
1d@012A492@3A00394A400E40b@4A00394A400940R@00d@T900490=43b@2A0<T1T@4909432@00d@T
A00390A400@TA2A40R@2A0@T0T@89003A2@T00<T00=494@00d@390A400<TA2@00R@5A0XT00=492@0
3B@2A00394A400M40R@00d@T9003A00394A400M400EXR4A4J002A003J4A4009400=XA4@00d@01VQ4
A6Q4J09416P00dAXA007A004J4@T90I41B@2A0@T00E492@TA00:9003A2A400PT00=494@012@2A0@T
00A492A42R@00d@T900390=49R@2A08T00A494A412@00d@T900;90I40b@00d@TA00490E412@4A0<T
0d@00bA4A005A00394A400=400HTA4A494@49006A2A4A2A412@00d@T900:90E40R@01D@T92A400<T
0T@590941B@3A0PT0d@=9003A2@T008T00=492@01b@2A08T14@39003A2A400940b@5A08T00=492@0
14@390A40R@5A0<T2D@004540R@2A00494A490I400DTA4A49009A00394A400A400<TA4@00d@00bA4
A00FA00394A400E400<TA2@014@00bA4A00>A0DT00=492@00T@00bA490049003A2@T00LT00=492@0
12@3A08T00=492@00b@00d@T900290=400<TA4@00b@00d@TA00390Q400<TA4@01B@2A0HT00A492A4
0b@9A00494A4A08T00A492@T0d@39003A2@T00@T0d@390940R@2A0HT00A492@T14@69003A2A401A4
00=XR4@024@2J0A400=XA6P03d@590I400>894@00T@390943b@2A0TT00A492@T0d@79003A2@T00lT
00=492@01R@01D@T92A401XT00=492@012@2A0dT00=492@01R@00d@T9004A0HT0d@89005A2A4A2@0
0T@490=400<TA4@00d@?9003A2@T00dT00=492@00b@2A00394@T00XT00=492@012@00d@T9002A0XT
0d@790A442@2A00394A4009400<TA4@014@590E40b@00d@TA002A0<T1D@290E400<TA4@02D@001Q4
00<TA4@054@00bA4A00IA00394A400E400<TA4@03T@29003A2A400a400<TA2@04T@00bA4A00:A08T
1T@290942b@5A00394@T00<T00E492@TA0059003A2A400A400<TA2@00R@8A0@T00I492A494@290U4
12@4A0DT00E494A49002A00394A400e40R@2A08T14@00bA4A0049003A2A400HT00=492@00d@390=4
00@TA2@T14@59003A2A401E400EXA4A4J00PA00994A4A6Q494B800<T0T@290=43B@4A0HT0d@00bA4
9002A2LT00A492@T0d@29004A2@TA1DT0T@790941B@2A0`T0T@790941B@2A00394A400<T00=492@0
0R@;A08T1D@F909412@2A00394@T00XT0T@00bA490029003A2@T00hT00=492@012@00d@TA002A0DT
00=492@012@2A0HT00=492@00R@00d@TA002A0HT1D@5909400<TA4@014@290=40R@=A000GD@00bA4
A007A00394A400E400<TA4@00d@39003A2@T00E40R@2A0<T00A492@T0d@012A492@3A0LT00=494@0
2B@00d@TA00490=41b@4A0DT0T@00bA4A0039003A2A400@T1d@01bA4A2A494@012@4A0<T1T@00bA4
9003A08T1D@00bA49002A08T0T@5909400@TA4@T0T@390A400<TA4@00R@2A0TT00=492@014@012A4
92@2A00394A400I41B@4A00594A4A2@00d@00fQ4A007A003J4A400e400<TA4@03d@01BA4A4@T00E4
42@00d@T900790=41R@00d@TA006A0<T00=492@06R@00d@T900I9003A2@T008T00=492@01B@00d@T
900490A40b@5A0XT00=4J4@01R@01D@T92A4008T14@59003A2A400@T14@29003A2@T008T0d@39094
00@TA2@T0d@690A40R@2A0<T0d@8909400<TA2@014@00bA4A003909422@014@TA4@69004A2@T90E4
1R@00d@T9007909412@00d@TA00290=40R@00d@TA002A0DT00=494@00d@01BA494@T00=40R@6A003
94A400A4000:A003J4A402m400=XA4@0;T@00bA4A004A00494@T90=400<TA4@00T@00bA4A005A003
94A400a40b@5A00494A4A08T00A492A40R@00d@T9004A0DT1T@01BA4A4@T009400DTA4A49005A003
94A400Y41B@00d@T9002A00394A400<T1d@290Q40R@014@T94@290A40b@4A0<T00M492@TA6R800A4
00@TA4A422@014@T92@3A0DT2d@490A40R@;A003J4A400U40R@3A003J4A400Y40b@CA0dT0d@890=4
00<TA4@00b@8A0@T00E492@TA00Y9005A2@T94@02R@2A0LT00=492@00T@012A4A2@4A00394A400=4
0R@00d@T90029003A2A4009X00=492@012@00d@T9002A08T0d@69003A2@T00<T0d@69003A2A40094
1R@2A08T0T@690=412@4A00394A400TT0T@00bA4900290A41B@3A0DT0d@00bA4A004A08T00A494AX
0d@490A41B@014@TA4@49005A2@TA2@00d@00bA49005A00494@T90940b@8A00494A490e40FP005E4
0R@6A00394A4009400DTA4A49006A00394@T00A40b@9A00594A4A2@00T@012A4A2@<A00494@T90=4
00<TA4@01T@012A492@2A08T1T@29003A2@T00940R@3A00494A490941B@00d@T9002A00394@T008T
14@39003A2@T00<T14@29003A2A400E400<TA4@024@2909412@5A00394@T00A40b@00d@T9008A0DT
00A492A41B@2A08T00=492@03T@290E40b@FA00394A400A400<TA4@01T@390=400@TA4A40R@4A004
94A4A0<T00=492@01R@00d@T900490=41R@4A0PT14@29003A2@T00DT00=492@06b@00d@T900=9003
A2@T00lT00=492@012@00d@T900590E42B@3A0/T00E492@TA0049003A2@T00HT0T@990=41R@2A08T
00=492@01R@00d@T900490943B@3A0@T0T@790=41R@014@T92@3A0<T0T@00bA4J002A10T00E494@T
A00490E40b@5A08T0d@490=400HTA4AXA2@;A003J4A400=4000/A003J4A400U400<TA4@07T@39004
A2A4909400<TA4@01D@00bA4A00UA08T0d@01BA494@T009400<TA4@00T@00bA4A002A0<T2D@00fQ4
A002A08T1D@39003A2A400`T00=492@01b@00d@T900390A40R@2A00394@T00<T00=494@014@29094
0b@00d@TA0029003A6Q4009400DTA4A49003A08T0d@00bA4A005A0HT00A492A40R@2A00694@TA2A4
0b@4A0@T00E492A49006A08T0d@290=400@TA2@T2D@00bA4A002A00394@T00<T1d@9909412@00d@T
A003A0@T00=492@032@2A00394@T00HT00=492@02R@3A0PT00A492A44B@00d@T90029005A2@T94@0
4B@2A0TT0d@99005A2@T94@012@7A0DT0d@59003A2@T00@T00=492@02B@01D@T92A4008T00=492@0
2b@00d@T900590=40R@2A0LT00=492@02R@00d@T9002909432@014@T92@2A00394A400`T00=492@0
2B@00d@TA0049003A2@T008T0T@29004A2@T90=400=XA4@01B@014@TA2@GA005J4A4A6P01D@00594
00<TA4@00d@590940R@6A0@T00=494@00R@01D@T94@T00]40R@;A08T0d@29003A2@T008T2D@00fQ4
9004A0@T0T@01BA4A4@T00I400<TA6P00T@490A44R@014@T94@590A40b@2A0@T0T@290943B@5A003
94@T00=400@TA4@T1D@00bA4A006A0<T0d@012A492@5A00494A4A08T0d@39003A2A400A40b@014@T
92@2A0DT1D@00bA4A005A00394A400A412@00d@T90059003A2@T00HT0d@39003A2@T009412@00d@T
A00>9005A2@T94@01B@014@T94@J9003A2@T00DT00<092@01B@00d@T90029004A2@TA1<T0T@99003
A2@T00PT00E492@TA00490940b@00d@T900490=41b@2A0<T00=492@02b@2A0<T1D@59003A2@T008T
00=492@012@014@TA4@;90=42R@00d@T9002909442@00d@T900=9003A2@T00dT00=492@03B@3A003
J4@T00TT00=XA2@00T@00bA4A006A00394A400i40VP000Y400=XA4@08T@00bA4A00RA00594@TA2@0
0d@00bA4A009A0<T1D@00bA4A00EA00394A400940R@3A00494A4A0@T0T@290I400DTA2@TA00390=4
00<TA4@00T@00bA49009A08T1T@290E40R@3A08T14@290=400@TA2A40R@01D@T92A4008T2D@;90=4
0R@6A0@T0T@00bA4A007A09X0d@29003A2@T00<T2D@290=400>8A2@00d@00bA4A003A0<T00=494@0
0T@012A492@:A08T0T@00bA4A004A0@T00A492A412@00d@TA00590E40R@00d@T9002A0<T00=492@0
1b@00d@T900_9003A2@T00DT00=492@00b@00d@T900590944b@3A08T00=492@00R@00d@T900>9003
A2A400940R@00d@T900;9003A2@T00XT00=492@00b@014@T92@2A08T1T@490942b@5A0XT1T@59004
A2@TA0<T0d@590940R@2A0LT0T@99004A2A4A08T0T@290940b@01D@T92A400XT0d@2909400@TA2A4
1B@01T@T96Q490a400<TA4@02d@00fQ4A001J0002T@00fQ4A005A003J4A400a400<TA4@08T@00bA4
A00290E400EXA4A49004A00394A400a40b@2A08T4d@00bA4A002A00394A400A400<TA4@01D@012A4
92@3A00894@TA2A494@290=40R@8A0@T2D@2909400<TA4@00R@2A0XT00A492A40b@4A0/T0T@49004
A2A4A0LT1D@3909400<TA4@00T@29004A6Q490]400<TA4@02R@6A0@T1D@490A412@4A0@T1T@290=4
0b@5A08T0T@2909412@01D@TA4@T009400<TA4@00R@3A00594A494@032@2A0<T00=492@012@3A1XT
00=492@00b@014@T94@_90940b@00d@T900=9003A2@T00@T0T@?9003A2A400PT00=492@032@00d@T
9002A00394AX00=400<TA2@00T@390941B@00d@T9002A0`T00=494@032@4A0lT00=492@01b@00d@T
900690941b@2A0hT0T@3909400<TA4@02B@014@T94@290i400=XA4@024@1R05X000eA003J2A40154
00<TA4@014@016Q4A2@4A00594A4A2@01d@290940R@00d@T900490E400DTA2A4900<A00494A4A0<T
00=494@00T@012A4A2@8A00494@TA0<T1D@00bA4A005A0DT24@290I400@TA4A42R@00d@T900490A4
32@00d@T9003909400@TA4A40R@<A0@T00=492@03D@00fQ49002A00394A400TT0T@6909400<TA2@0
0R@6A0@T00A492A40R@3A00394@T00@T0d@390E40b@5A0HT1D@00bA4900490=41b@00d@T90059094
0R@3A0HT0T@4900302@T01TT00=492@08R@00`0T900<9005A2@T94@02b@2A0LT00=492@03R@00d@T
90029003A2A401@T00=492@012@4A0PT00=494@00R@3A0DT00=492@02b@01D@T92A400LT0d@49094
2R@00d@T900790940R@5A0TT0T@390=41B@01T@T94@TA08T00=494@00R@00d@TA004A0PT0T@00bA4
A002J0E400=XR4@02T@1J054000AA003J4A402=400<TA4@064@290E400HTA4A494@290M41R@3A003
94A4009400<TA4@04D@390E400<TA4@02D@59003A2@T00a400<TA2@012@4A08T00=492@00T@012A4
A4@39004A2@T90942R@;A0<T1d@39003A2@T009400@TA2@T0d@00bA4A003A08T0T@39004A2A4A08T
4D@=9004A2@T90=40R@2A00494@TJ0=400<TA2@00b@014@TA4@89003A2@T008T0d@012A4A4@290Q4
12@5A0HT0d@00bA4A003A0HT00=494@01D@290=412@3A0DT00=492@012@01D@TA2A400XT00=492@0
8b@00d@T900Q9003A2A400940R@00d@T900F9003A2@T010T00E492@TA002909400@TA4A412@00d@T
A0059003A2A400DT00=494@02R@2A00394A400PT0T@490940R@2A0PT00=492@01b@02D@T92A494@T
A00890940b@2A00394@T00<T00=492@00d@59005A2@T94@00b@4A00394@T008T3D@00hQ4A00;A000
0d@00fQ4A00>A003J4A401]40R@3A00394A400Q400<TA4@034@012A4A2@2A08T0d@00bA4A00BA003
94A400A400<TA4@014@00bA4A003A00494A4A0@T0T@2909400<TA2@03T@290E400<TA4@01D@39006
A2A4A2A40R@6A00494A4A0<T00=492@01B@00d@T900590E40b@2A0DT14@A90A432@2A00394A400U4
00@TA2@T0T@29003A2@T01@T1T@29005A2@T94@022@2A0PT00E492@TA00390M412@3A0/T1d@59094
00<TA2@01D@290A400DTA2@TA00>90=412@2A08T0d@00bA490029005A2@T94@022@2A0`T00=492@0
0b@00d@T90029003A2@T008T00=492@02B@2A0DT00=492@01B@00d@T900L9003A2@T00dT00=492@0
1R@2A0<T2D@F9003A2@T00XT0d@590940R@00d@T900A9003A2@T00DT00=492@02R@3A00494A490A4
00@TA4A41B@01D@T92A400@T00A492A412@5A00394A400A400DTJ4A4J008A05X0D@003M400<TA4@0
0d@00bA4A00@A00394A400=40b@4A00394A400A400<TA4@034@00bA4A002A00394@T00A400<TA4@0
1D@00bA4A004A0<T34@290I40R@6A00394A400=40b@00d@TA002A08T1d@990=400@TA2A41b@00d@T
A003A0PT00A494@T0T@00bA490049003A2@T00LT0d@49003A2@T00DT0T@00bA4A007A00394@T00I4
00DTA4@TA0049004A2@TA08T0T@00bA4A00490E41R@00d@TA002909412@00d@T900790A400<TA4@0
2D@00bA4A002A00394@T00<T00=492@00b@01T@T94@TA0<T1D@00bA4A004A08T14@00bA4900B90=4
1B@014@T94@4909412@00d@T90049003A2@T00<T0d@5909422@00d@TA002A1DT00=492@01R@00d@T
9002A00394@T01DT0T@?90943B@5A00494A4A0DT0T@>9003A2@T00/T00E4J2@TA003909400<TA2@0
3B@00d@T900B9003A2@T00<T00=492@01T@00bA4A003A00394A400=400@TA4A40b@00d@T9006A003
J4A4008T1d@016Q4J6P2A003J4A400940FP1A054000>A09X9T@00bA4A00IA00394A400940R@3A0<T
14@00bA49005A00594@T94@012@6A00394@T009400<TA2@01D@00bA4A004A08T00=494@00R@:A08T
34@00bA4A002A00394@T008T1D@290I42B@00d@T9002A0PT0T@012A4A4@49004A2A4A0<T00A494A4
22@00d@T90029005A2@T94@00R@4A0LT0T@290=400@TA4@T0T@01BA494@T00A40R@00d@T90049094
12@5A0DT14@69003A2@T01<T00A492@T0d@012A494@2909400<TA4@00T@00bA49002909422@00d@T
900390Q400<TA4@014@29003A2A400HT0T@39003A2@T00DT00=492@04b@00d@T90059003A2@T008T
00=492@0:2@2A0PT00E492@TA00F9003A2@T008T0T@29003A2@T00DT00A492@T0T@00bA490029003
A2@T00@T14@99004A2@TA0<T00=492@01R@014@TA4@:90=400<TA2@00b@3A20T0T@;9006A2A494@T
2d@012A4A4@590M400=XA4@03d@2J0I4000QA00394A401Y400<TA4@064@00bA4A00AA00394A400Y4
00<TA4@00T@00bA4A00290Y41B@4A00394A4009400<TA4@00d@00bA4A003A00394A400M40R@2A004
94@T909400DTA4A49006A08T00=492@014@59004A2@T90Y40R@014@T92@4A00394A400LT00=492@0
0R@00d@T900390M41B@00d@T9002A00694A494@T1T@00bA4A0089003A2@T00DT1T@29003A2A400=4
3R@4A0lT1T@39003A6PT00E41R@3A08T00A494A40R@2A0HT00=492@00R@01D@TA2A400<T00=492@0
1B@2A00394@T008T00=492@00T@<9003A2@T04DT0T@N9003A2@T00`T0d@39003A2@T00DT00=492@0
1B@3A0@T00=492@02B@2A0<T00=492@00R@2A0DT00A492A41R@2A00494A4A0@T00=492@01b@00d@T
900G90941R@01T@T92A490M400<TA4@01D@00bA4A002A00394A400940VP?A09X1d@0045400<TA4@0
2T@012A492@6A08T0d@00bA4A00?A00394@T00e400<TA4@01T@00bA4A004A00494@T909400<TA2@0
14@290M40b@9A0<T14@00bA4A004A00394@T00E412@00d@TA004A08T0T@00bA4A005A00394A400=4
1B@3A08T0T@012A4A4@290942B@4A00494A4A0HT00E492A49002A00494A490E400<TA2@01R@3A0@T
00=492@00R@2A0LT00=492@00b@014@T92@2A08T00E492A49002A0`T00=492@02T@290=400<TA2@0
0R@6A08T1D@>9003A2@T010T00A494A41B@2A0dT00=492@07b@00d@T900C9003A2@T00XT00=492@0
4B@00d@T90099003A2@T00LT0T@G9005A2@T94@012@00d@T90089003A2A400XT1D@29003A2A400DT
00=494@01D@01BA4A2A400HT0T@I90A40b@014@TA4@290E400<TA2@01D@290e400=XA4@00T@00fQ4
A00=A09X0D@001E400<TA4@07d@00bA4A00PA003R=6800Y40R@@A00394A400a400<TA4@00d@00bA4
A00:A08T00=492@014@390Y40R@014@TA4@290A400<TA2@024@290I400<TA2@00T@29003A2A400]4
0R@4A08T0d@00bA4A002A00494B8A0PT0T@490A400<TA4@00T@00bA4A00>A0LT0T@:90=41B@4A0<T
0T@290940R@6A0<T0T@59003A2@T00<T3d@69003A6Q400940b@00d@T9005A0LT00A492A412@3A0TT
00=494@00d@2909400<TA4@01b@00d@T900390940VP990941R@00d@T90029003A2@T00<T00=494@0
5b@00d@T900;90941b@00d@T900<90=40R@00d@TA00790=41b@00d@T900<9003A2@T00XT0T@00bA4
900:9003A2@T008T0T@2909400<TA2@00R@01T@T92A490U400<TA4@01R@2A00394@T00dT0T@39003
A2@T009400@TA2@T1T@00bA4A004A08T00=4R4@01d@290Y400=XA4@00VP5A09X24@1J054000EA003
94A401i400<TA4@074@00bA4A002A003J=6/01=40R@3A08T0T@00bA4A00;A00394A400e400<TA4@0
1d@00bA4A00390E400=XA4@00T@49003A2A400=40R@00d@TA004A00494A4A0<T0d@39004A2@TA08T
00=492@00T@00bA49006A08T00=494@01b@3A00494B8R0<T00E492@TA006909400<TA4@014@01BA4
A4@T00e41R@3A0<T14@49003A2@T00@T14@790940R@00d@T900690=412@00d@T900490I412@4A0HT
00=494@00T@590I400<TA4@00b@00d@TA00E90945b@2A0/T00=492@022@00d@T900490940R@00d@T
90079003A2@T00/T00=492@00T@39008A2@TA2A494@D9005A2@T94@00R@00d@T90069003A2@T00DT
00=X92@062@2A0PT0d@3909422@2A0<T0d@490=41B@00d@T900290940R@00d@T900@909412@00d@T
A003A00394A400a40R@7A003[8Q400<T1T@00bA4A003A003J4A400i40FP1A0004d@00bA4A00hA004
R6Q490=400<TA4@00d@00fR8A00=A00394@T00A400<TA4@01T@01BA4A4@T00M400<TA4@044@00bA4
9004A00394A400e40R@2A0<T0T@590A40R@5A00394@T009400<TA2@03B@01T@TA4@TA0PT00=492@0
6R@014@T94@39004A2@T90I400<TA4@00T@390A400@TA2A40R@3A0@T00=492@012@5A0LT0T@00bA4
A002A0@T0d@490A41B@5A0<T00A492@T0T@590=412@00d@T900490941B@00d@TA00U9003A2@T02LT
00=492@02b@2A10T00E492@TA0029003A2@T00@T00=492@03b@01D@T92A400DT00=492@012@00d@T
A0069003A2@T01@T00=494@02b@2A08T00=492@00b@00d@T900790940b@2A00394@T00DT00=492@0
1b@2A00394@T00dT00=492@00R@014@T92@6A00394A400I412@00d@TA005A004J2@T90Y400AXA4@T
0d@00bA4J007A003J4A40094000hA00394A400e40b@?A00594A4A2@014@00bA4A003A00394A40294
00<TA4@00T@00bA4A00JA0<T00E492A49002A00394A400=400DTA4A49002A08T0d@00bA4A0039094
3B@2A1LT00=494@00R@00d@TA00890940R@014@T92@2A08T1D@00bA4A003A0<T00=492@02B@00d@T
A004A0<T1D@490940R@2A08T00=492@00b@00d@T900490A40b@00d@T9002A0XT0T@00bA4900290A4
2b@024@T92A494@T0T@;9003A2@T00/T0T@I90944B@00d@T900C9003A2@T00LT00=492@00R@014@T
A4@49004A2@TA1dT0T@:90=40b@00d@T900?9003A2@T00DT0T@49003A2@T00DT00=492@01b@01D@T
92A400LT14@<9003A2@T008T0T@290940b@00d@T900D9003A2A400M400LTA2A494@T009400@TA4A4
0b@00d@TA00;A00394A4009400=XA4@02T@000a400=XA4@03d@00fQ4A002A003J4A4019400DTA4A4
J005A00494A490A400<TA4@074@290U400<TA4@05d@00bA4A002A00394A400e400AXA4@T24@290E4
0R@<A00394A4008T14@490A41R@00d@T900:909400<TA2@01R@00d@T900490=400<TA4@00d@590A4
1B@2A0<T1D@290I41b@>A0@T0d@29004A2A4A08T0T@590A422@00d@TA0049003A2A400dT00=492@0
0R@2A0dT00=494@00T@012A4A4@B9004A2@TA0@T00=492@032@3A0LT00=494@00T@89003A2@T00@T
0T@590943R@00d@T90069003A2@T00<T0T@89003A2@T014T0T@F909400<TA2@032@2A0@T00=492@0
12@3A00494A4A0LT0T@89003A2@T00<T00A492@T14@01BA492A400@T00=492@01b@01T@T94@TA0<T
0T@790=43B@7A08T24@290=412@@A003J4A400A400EXA4A4J002A000=T@00bA4A004A00594A4A2@0
2D@00bA4A00jA08T24@291]400<TA4@00T@590=400@TA4@T0d@00bA4A006A0DT1T@B9003A2A400@T
00=492@01b@014@T94@29003A2@T00@T0T@39003A2@T00<T00A492@T1D@290E422@00d@T9004A0<T
1D@390=412@6A0@T0T@<9005A2@T94@032@00d@T9003909400@TA4@T0T@>9003A2@T008T00=492@0
42@01D@T94@T00=43B@00d@T900;90=44b@014@T94@>90942B@3A24T00=492@03B@2A0HT00=492@0
3R@2A0/T14@C90=41R@2A0@T00=494@04R@00d@T90079004A2@TA08T00=492@01R@01T@TA2A490Q4
00<TA4@01D@290E400<TA2@02d@00fQ4J009A005J4A4A6P00T@0035400<TA4@02T@012A4A2@4A005
94A4A2@0:D@012A4A2@=A00394@T011400DTA4A4900:A00394A400A40R@4A0DT00E494A49006A0<T
0d@012A4A4@590A40R@00d@TA003A0DT00E492@TA0059003A2@T00DT00E492@TA00:9003A2A400I4
00@TA4@T1D@2J0E400DTA4A49002A0TT14@2909400<TA4@01b@00d@T900290I40R@00d@T900C90E4
0R@2A0LT00A492A40R@2A0PT00A494@T0d@K9004A2A490946B@3A2<T00=4J2@012@01T@T92A49094
1R@2A18T00=492@01R@6A08T00=492@012@014@T92@2A0<T00=492@06B@4A0@T14@39003A2@T00LT
00=492@00R@3A0DT00A494A46b@2A0LT0T@49003A2A4009400<TA4@00d@390U400<TA4@01d@00hQ4
A006A004J4AXJ0E400<TA4@01D@2J054000<A00394A400a400<TA4@054@00bA4A00<A00494A491m4
00<TA4@01T@00bA4A00;A00394A402E40b@2A08T1D@290I412@9A0<T0d@012A4A4@490A40b@00d@T
9002A0@T00=494@01b@4A0<T00=492@00R@00d@T900:9003A2A400I412@6A003J4A400940b@5A0XT
0T@29003A2@T00XT0T@00bA4900290E42R@00d@TA0029003A2A400@T0T@2909412@00d@T90039003
A2A400DT0d@690E442@00d@T90079004A2@TA08T00=492@00b@00d@T900B9003A2A400HT00=492@0
5B@00d@T90089003A2@T00dT00=492@03b@00d@T90029004A2@TA0DT0T@59004A2@T90940b@00d@T
900:90940b@00d@TA0089004A2@TA0<T0T@=90=45R@00d@T900E9003A2@T00dT0T@00bA4A005A0DT
00A494@T5D@00bA4A003A09X0T@00bA4A007A0=X000cA00394A400U400<TA4@01T@390e400<TA4@0
2D@00bA4A00=A00594A4A2@02T@01BA4A4@T01Y400<TA2@02d@2909400@TA2@T14@29003A2@T00a4
00DTA2@TA0079003A2A400940R@3A00394A400<T00=494@00T@290=412@4A0@T00A494@T1T@29094
12@2A08T1D@29003A2A400E400<TA4@012@014@T92@4A0dT0T@00bA4A00290I42B@3A00394A400/T
0T@J90M41B@2A0@T00=492@01b@00d@T90089004A2@T90944b@00d@TA00@90941B@2A0DT00=492@0
3R@2A0DT00=492@01b@2A0@T00=492@01R@2A08T00=492@012@4A0LT0T@00bA4A00<9003A2@T00PT
0T@:9003A2@T00`T00=492@01b@2A0`T0T@69003A2@T00PT00=492@04b@00d@T900290A42R@4A0HT
4D@2J0U400@TA4A40VP001=400@TA4A40R@FA00394A401Q400<TA4@02T@00bA4A00EA08T3T@00bA4
A005A00394@T00U40VP;A004J4A490=400<TA2@01T@00bA4A0029003A2A400Q400@TA4A40R@4A003
94A400940b@2A0LT0d@290941R@4A00894@TA2A494@29007A2A4A2A49004A0<T1D@39003A2A400=4
12@014@TA4@490A412@2A0@T00E492A49002A0TT00E492@TA00290=400<TA4@01D@012A4A4@59094
00<TA4@00R@2A0`T0d@290940R@3A00394@T00/T0d@00bA4900290=41B@00d@TA00<9003A2A400HT
0T@C9003A2@T00DT00=494@01b@3A0DT0T@59003A2@T00<T0T@890=41B@=A0<T00=492@00b@014@T
A4@;90941b@4A0dT00=492@082@00d@TA002A0PT00=492@032@2A00494A4A08T00M492@TA2A400`T
00=492@00R@01D@T92A400DT00=492@01D@00bA4A002A0HT0T@00bA4900591m40VP001E400<TA4@0
=T@012A4A2@3A00394@T00]400=XA4@07d@00bA4A00=A00394@T00E400<TA4@01D@00bA4A00390A4
0R@2A0@T34@390=40b@3A08T00E492@TA0029003A2@T00A400<TA2@012@00d@T900=9003A2@T00HT
0T@590A412@4A0`T1D@39003A2@T00DT0T@590941b@014@T94@290i412@00d@T90029003A2@T0094
22@014@T92@2A0<T0T@390943b@2A08T00=494@00T@00fPT90039003A2@T00`T0d@59003A2@T018T
00=492@04B@00d@T900L90942B@00d@T900290941B@014@T94@490=40b@2A0dT00A494A48b@00d@T
900;9003A2A4010T00=492@01B@00d@T90049003A2@T00<T1D@69004A2@T90940b@3A00494A4A0TT
00=492@022@01D@TA4@T00I40R@:A08T34@00fQ4J003A09X000eA00394A400]400<TA4@01d@00bA4
A004A00394A4008T14@290A400B8J4@T1T@00bA4A006A08T6d@012A4A2@<A08T1d@3909412@00d@T
A003A00494@T90E400DTA2A49002A00494A4A0DT14@49003A2A400DT00=492@05b@00d@T90049003
A2@T00<T00=492@01b@00d@T900>9003A2@T00<T00A492A41B@00d@T90029004A2@TA0lT14@00bA4
90069003A2A400TT00=492@00R@00d@TA00<9003A2@T018T0T@29003A2@T00/T00=492@02b@00d@T
900@9003A2@T00XT00=492@0;B@00d@T900=9003A2@T00HT00A494A40b@00d@TA0079003A2@T01<T
00A492@T0T@29003A2@T00/T00=492@02R@2A1@T00A492A412@00d@T900390E40R@3A0@T0d@590A4
00<TA2@03b@4A00394A400A400=XR4@00R@2A00394A4009412@4A0=X34@2J0002T@00bA4A00MA003
94A401E400@TA4@T24@00fQ4A002A00394@T009400@TA4A40R@00d@TA008A08T0d@012A4A2@=A08T
:4@290E400<TA2@01D@012A4A2@3A08T0d@01BA494@T00E40b@6A0@T14@59003A2A400@T0T@H9003
A2@T00dT00=492@00b@00d@TA0089004A2@T90=40R@2A00494A4A0DT00=492@01B@2A0<T0T@490A4
1b@00d@TA00;9003A2@T008T00=492@00R@3A0LT00=492@04R@2A0LT00=492@05R@00d@T90049003
A2@T01`T00A492@T0T@G9003A2@T00DT00=492@06R@2A00394@T00@T00=492@032@00d@T900S9003
A2@T018T00=492@02b@3A0<T00=492@012@2A0<T0T@;9004A2@T90E42b@014@T92@2A00394@T00<T
0T@012A4A6P4A0@T0T@00bA4A002A00494A4J0i40FP1A000Cd@390=400<TA2@00R@5A08T4d@016Q4
A2@<A00394A400U400=XA4@08D@012A492@9A00494@T90M41B@3A0@T1d@39005A2@T94@00R@014@T
A4@29003A2@T00@T0T@00bA49003909400HTA4A494@99003A2@T00E412@2A00494A4A0@T00=492@0
0R@3A08T1D@39004A2A4A0DT0T@59003A2@T00@T0d@29004A2@T909400<TA2@00b@00d@T900?9003
A2@T008T0T@00bA4A00:9003A2A400HT00=492@01R@00d@T90059005A2@T94@032@00d@T900@9003
A2@T008T00=492@02R@3A00394@T01PT0T@79003A2@T00`T00=492@01R@00d@T9002909400<TA4@0
12@014@T92@5A08T00=494@014@00bA490099005A2@T94@01B@2A00494A4A0HT0T@59003A2@T008T
00=492@00R@00d@T90029003A2@T00XT14@39003A2@T00DT00=492@00R@00d@T90099003A2@T008T
0d@29003A2@T00LT14@012A494@3909412@014@T94@390Q40R@00dAXA00@A0005D@012A4A2@PA003
94A401540R@01D@T92A4008T0T@390=40b@2A00394A400=400<TA4@02d@00bA4A006A00:94A494@T
A2A490A400<TA4@01D@49003A2A400=400<TA2@00T@00bA4A00:A00394@T008T1D@00bA4A004A08T
14@8909412@8A0<T00=492@012@00d@T9002A00394@T00LT0d@49004A2@TA0@T00E492@TA00590I4
1b@3A0@T0d@29003A2A4008T0T@00bA490039003A2@T00HT00=492@042@00d@T900>9003A2A400lT
00=492@00T@:9003A2A400HT00=492@01R@00d@T90059003A2@T02XT00=492@01R@01D@T92A400dT
00=492@032@00d@T900P909400<TA2@012@00d@T9003909400<TA2@00b@4A0hT14@59003A2@T00LT
0d@79003A2@T00DT0T@D9003A2@T00dT00=492@03R@5A0PT00=492@022@00d@TA0039003A2A400<T
00E492A4900FA003J4A40094000CA08T6T@290I400@TA4@T2d@00bA4A007A0<T0T@00bA4A0029005
A2@TA2@06d@00bA49002A00394@T00940R@2A0<T0d@00bA4A004A00594@TA2@00T@00bA4A002A0HT
0T@39003A2@T00A412@5A08T00E492@TA0029003A2A400LT00=494@00b@5A00394A400942R@00d@T
90039003A2@T00@T00A492@T0d@390=40R@00d@T9009909432@00d@T9003909412@2A0<T0d@49003
A2@T00DT0T@K90941B@2A00394A4008T14@890=472@2A08T00=492@0Fb@2A20T0T@00bA4A0049003
A2@T00XT00=492@02R@00d@T90049003A2A400@T00=492@01B@2A0<T00=492@012@2A1hT00=492@0
1B@00d@T90049003A2@T00dT14@:9003A2@T00HT0d@29004A2@TA0@T0T@00bA4A00391U4000:A003
94A402A400DTA4A4J00IA00394@T008T00A492A40R@01T@T92A490e400HTA4@TA2@4A00394A40094
00<TA4@014@012A4A4@39003A2A400E40R@6A00394A400Q40b@00d@TA004A0@T00=492@00R@00d@T
A002A00494A490=40R@2A08T0T@00bA4A002A00494A490I400@TA4A45b@00d@TA0029003A2@T00<T
00=492@00b@00d@T900B90940b@014@T92@2A0<T14@00bA4A008A08T00A492A492@01D@T92A400<T
0d@01BA492A400<T0d@?9003A2@T00XT1D@?909412@00d@T900@9003A2@T03<T0T@@9004A2@TA0<T
00=492@01R@2A00394@T00<T00=492@00T@00bA4A0059003A2@T00@T00=492@00T@01BA492A400<T
0d@39004A2A4A0HT00=492@01b@2A0<T0d@59003A2@T00TT00A492A44b@01T@T94@TA0TT0T@39003
A2A400lT1d@00bA4A009A0<T0T@290a400=XA4@01T@004m400DTA2A4900<A00394A400e400<TA4@0
14@39004A2@TA08T2D@00bA4A005A00394A400I40b@:A00494@T90A40R@014@TA4@29003A2A400=4
00<TA4@014@39004A2@T90940R@014@TA2@2A00394@T00940R@3A08T0T@00bA49002909400<TA2@0
1B@2A0<T1T@I9003A2A400<T0T@69003A2@T008T14@29003A2A400DT0T@?909400<TA2@00b@2A0<T
00A492A43R@00d@T90039003A2A400=40b@2A00494A4A0@T00=492@012@2A00494@TA0LT00=492@0
1D@=90940b@00d@T900;9005A2@T94@072@00d@T900E9004A2A4A0<T00=492@012@2A0<T00I492@T
A8P390941B@6A0LT00A492A41R@2A08T00A492AX0R@2A00394@T009412@3A0@T00=492@052@00d@T
A0059004A2@TA0HT00=492@05B@00d@T900?9003A2@T00941b@00d@T900690Q400<TA4@03D@290U4
0VP01dAXA4AXA6P00d@0051400@TA2@T0T@00bA4A002A00694A494@T1D@00bA4A007A00394A400A4
0b@01d@TA6PTA2@03d@00bA4A007A08T24@00bA4A006A00394A400I400DTA2A49003A00394A400A4
2b@01T@TA4@TA0<T0T@2909400<TA4@00T@490A412@00d@T900490I44R@00d@TA0049003A2@T00<T
0T@690941b@01D@T92A400HT00=492@01B@00d@T90069004A2@TA2/T0d@@9003A2@T00XT00=494@0
3B@2A18T00=492@062@00d@T900b9003A6PT00/T00A492A45B@014@TA4@@9003A2@T00DT00=492@0
32@00d@T90029003A2@T00hT00=492@00b@00d@T90059003A2@T00DT00A492@T0T@:9003A2@T00HT
00=494@042@5A00394A400A400<TA4@01d@00bA4A009A007J4A4A6Q4J003A0001T@00fQ4A00EA003
94A401a400<TA4@014@00bA4A00<A08T0T@01BA4A2A4008T4d@00bA49007A08T0T@00bA4900JA08T
3T@290=40R@01T@TA2A4909400<TA4@01T@390941B@4A00394@T00U40b@3A08T0d@29003A2@T00LT
24@490940b@00d@T900590=43R@00d@T90039003A2@T00DT00=494@01B@3A0LT0T@59003A2A4008T
0T@59003A2@T00TT00=492@032@00d@T900:9003A2@T00lT00=492@01B@00d@T900<9003A2@T01DT
00=492@012@00d@T90059003A2@T00hT00=494@0:B@00d@T900@9004A2@TA1/T00=492@01B@00d@T
9002909400<TA4@00b@00d@TA00n9003A2@T01dT00=492@00T@00bA4A0039003A2A400E400<TA4@0
0T@490U400=XA4@01D@016Q4A4@2J0002T@290i400<TA4@08d@390Y400<TA4@014@00bA4A004A003
94A400=400<TA4@00T@01BA4A4@T009400@TA2A40R@5A08T00=494@024@00bA4A003A00394A400]4
00<TA4@00T@00bA4A00;A00394@T00U400<TA4@024@490=400@TA2@T0d@00bA49004A00494@T9094
00<TA4@014@690=41b@4A003J4A400Q40R@00d@T900290I42R@00d@T90069003A2@T00@T00=492@0
0T@012A4A4@290941B@00d@T9004A00494A4A08T1T@:9003A2@T00@T00A492A42R@00fQ490089003
A2@T00XT00=492@00R@00d@T900H9003A2@T00`T00=492@00d@5909400<TA2@0?b@2A00394@T00@T
0T@=9003A2@T00@T00=494@014@29003A2@T00@T00=492@02R@01D@T92A400@T00=492@022@00d@T
90089003A2A4008T00=492@04R@2A0TT00A494A40b@2A00494A4A0XT00=492@022@00d@T9003A003
94A400<T1D@490E40R@00d@TA002A08T3d@016Q4J6P3A0680D@004Y40b@2A00394A400=400<TA2@0
0R@6A0<T34@2909400<TA4@01b@3A00694@T94@T0d@29003A2A400=400<TA4@01D@012A4A2@7A08T
00=492@00R@5A0<T1D@01BA4A4@T00=400<TA2@01d@39003A2A400Q40b@00d@T9004909412@01D@T
94@T009400HTA4@TA2@4A003J4A400=400<TA4@00T@00bA4A00490E40R@2A0PT00=492@01B@2A0@T
00=492@00T@390940R@00d@T90029003A2@T00I40R@00d@TA003A00494A4A0@T00=492@02R@01D@T
92A400LT00=492@01R@00d@T900290948b@00d@T900490A41B@014@T92@3A0XT00=492@04B@00d@T
900Y9003A2@T00PT00H092@TR4@49003A2@T00lT00A494@T0T@89003A2@T01XT00=492@042@00d@T
900;9004A2@T90942b@2A00394@T008T0T@=9003A2@T008T00I492A494@390=400DTA4@TA0059003
A2@T00DT0T@490E400=XA4@024@00bA4A003A004J4B8R09X0T@000I400=XA4@07D@00bA4A00DA003
94A400i400<TA2@054@00bA4A00290E400<TA4@014@012A4A2@8A00394A400M40b@:A00394@T008T
2D@012A492@7A00394A400940R@2A00594@T94@00b@00d@TA005A0@T00=494@01D@00bA4A0029003
A2@T00<T14@29003A2@T008T0d@4909400<TA6P014@2909400<TA2@01b@4A0@T0T@00bA49002A004
94@TA1PT0T@89003A2@T00<T0d@012A4A4@:909400<TA2@07R@00d@T900J9003A2@T00HT00A492A4
0b@4A08T00=492@012@8A0@T0d@J90=46R@00d@T900;9003A2@T00DT00=492@012@014@T94@29003
A2@T00XT0T@012A494@D9003A2@T00DT00=492@012@00d@T900L9003A2A4008T0d@89003A2@T00LT
00=492@012@00d@T900990A41R@4A08T00=492@01B@4A0@T0T@490M400<TA4@01T@00bA4A004A0:8
16P004i40R@QA00394A400E400DTA4@TA0039003A2A400E400HTA4@TA2@<A00394@T00e400<TA4@0
14@00bA4A0029003A2@T00941B@2A0<T14@79003A2A400940R@2A0DT0T@012A4A4@390940b@00d@T
90079003A2A400944R@2A0LT14@00bA490029003A2@T01TT00=494@022@00d@T900m9003A2@T00TT
00=492@03B@00d@T900290=400<TA2@01R@8A0DT00=492@06B@3A0HT00=492@032@00d@T90029094
;R@00d@T900G9005A2@T94@0;2@5A0PT00=494@01R@00d@T90029003A2@T00/T1T@99003A2@T00A4
0b@4A0HT00I492@TA2@4A08T1D@2909400<TA4@014@3J0940008A00394A400I400@TA4@T1d@00bA4
A00LA00394A400m400HTA4@TA2@@A00394A400]400<TA2@01d@012A4A2@3A08T1D@01BA494@T00m4
00<TA4@014@00bA4A00>A00394A400HT1D@00bA4A004A0XT1D@01BA4A4@T00U400<TA2@00b@00d@T
90069003A2@T00@T00=492@01b@00d@T90039003A2@T00PT00A494@T0T@00bA4A002A0dT00=492@0
1B@01D@T92A400hT00=494@01B@2A3/T0T@00bA4900>9003A2@T008T00A494A422@014@T92@3A003
94@T024T0T@B9004A2@TA0@T00=492@032@00d@T90079003A2@T018T0T@99003A2@T014T00=494@0
2R@00d@T9002A0LT00=492@00b@00d@T900>9003A2@T00<T00=494@00R@2A08T00=492@00R@00d@T
900=90=400=X92@00R@00d@T900490A40R@00d@T9003909400<TA4@00d@2909400@TA4A40R@FA0=X
000CA00394A402I400<TA4@02T@012A4A4@29003A2A4008T4T@00bA4A006A00494@T90=400<TA4@0
0T@59003A2A400I400<TA2@00R@2A00394@T015400@TA4A40R@5A00394A400Q40b@5A08T1T@00bA4
A00690=400<TA4@014@00bA4900390=400<TA2@012@00d@TA0069003A2@T00@T00=492@01B@2A0<T
1D@29004A2A4A0XT1D@790942b@2A08T00=492@022@00d@T90049094?b@2A14T0T@<9003A2@T00@T
00=492@00b@00d@T900O9003A2@T00lT00=492@01R@2A0DT00=492@01b@00d@T900390942R@00d@T
90099003A2A400=41B@00d@T90069003A2@T01dT00=492@05B@00d@T90069004A2A4A08T0T@H9094
0b@2A0LT0T@39005A2@T94@012@014@TA4@390940R@00d@TA00291A400=XR4@00D@001Y400<TA4@0
8T@00bA4A00SA0<T0T@00bA4A009A00694A494@T0T@3909400<TA4@00d@390Q400<TA4@04T@00bA4
A003A00394A400M40R@6A00394@T008T0T@290A41B@00d@TA00290=40b@3A0@T00A494A44R@014@T
A4@69003A2@T008T14@39003A2@T00`T00=494@022@00d@T90099003A2A4009400<TA2@022@3A004
94@T90=400<TA2@00b@2A0HT00=494@06R@2A0`T00=492@00R@2A00494@TA0/T00=492@02R@3A0HT
00=492@012@00d@T900?9003A2@T00<T00=492@01b@00d@T90059003A2@T00PT0T@29003A2@T01<T
00=492@00R@014@TA4@39003A2@T00@T00=492@012@014@T92@4A14T00=492@02B@00d@TA0039005
A2@T94@04b@00d@T90069003A2A400@T00=492@012@2A0HT00A4J4A43b@014@T92@2A0<T00=492@0
0b@2A00394A4008T00E492@TA0029003A2@T008T0d@00bA490049003A2A400m40VP4A0=X000CA003
94A4051412@5A00394A400A400<TA2@01D@390E41B@9A00394A401Q400@TA4@T14@390I400<TA4@0
0b@014@TA2@2A00394@T00<T0d@4909412@00d@T900590943R@00d@T9002A08T00=492@022@3A1DT
0d@T9003A2A400@T14@490=45B@00d@T900I9003A2@T008T00A494A41R@00d@T900D9003A2@T00TT
00=492@01R@01D@TA2A400@T00=492@0>B@2A0`T00=492@00b@00d@T9007909412@00d@TA00=9003
A2@T00<T1T@390942R@00d@T9002A0PT00=492@02R@3A00394A400<T00=492@02B@00d@T90039003
A2@T00PT00=492@01b@00d@T90049003A2@T00TT14@390941b@00d@T9006A003J4A400E40VP4A003
J4A4005X0009A00394A401=400<TA4@0?D@00bA4A00JA00494A490Q400@TA4A40R@<A00394A400I4
00@TA2@T2T@290A40b@2A00394A400=412@2A00394@T00E400<TA4@00T@012A492@2A0<T00=492@0
1R@2A0dT0T@A90941B@00d@T900;9004A2@T90E42b@3A00494@TA0PT00=492@00b@01D@T92A400/T
00=492@02B@00d@T90039004A2@T90=472@00d@T900<9003A2@T00LT00=492@02R@2A0LT00=492@0
2b@4A1@T00=492@00b@2A0hT00=494@03b@4A18T00=492@012@014@T92@3A08T0T@N90941R@00fPT
90039003A2@T00LT0T@>90941B@2A1PT00E492@TA0099003A2A4008T00=492@00T@<90E40b@4A0<T
1D@00fQ4A009A004J8QXJ094000:A00394A400I400<TA4@04D@00bA4A00IA00394A401Q400<TA2@0
2D@290Y400<TA4@00R@>A08T00=494@05T@00bA490039004A2@T90E400HTA4@TA2@9A00394@T00A4
00<TA4@014@2909400@TA2A41B@00d@TA00<9003A2@T008T00=4J4@00d@49003A2@T00`T00I494A4
94@69004A2@T909400<TA4@00R@4A0HT0T@590=41R@2A1hT00=492@03R@00d@TA00<90940b@00d@T
900?9003A2@T00TT00A492A40b@00d@T900;9003A2@T00DT0T@>9003A2@T01<T00=492@04b@4A0`T
0T@00bA4A00290A46R@00d@T90089003A2@T00@T00=492@00R@2A0@T0d@;90940R@2A1XT0T@29004
A2@T90941b@00d@T900A90=412@014@T94@49004A2@TA0<T00E492@TA003909400=XA4@024@290M4
00=XA4@01D@016Q4A4@2J0940FP1A0007D@01BA4A4@T00U400<TA4@0;T@00bA4A00cA00394A40094
00=XA4@024@290940b@3A00394A400E400<TA4@02d@490M41R@00d@TA002A0<T00=492@01R@4A08T
00=494@00d@00bA4J006A0<T0T@49003A2@T00<T00=492@02b@00fQ4A002909412@4A0HT0T@59003
A2@T00DT14@59003A2@T00=40R@00d@TA0039003A2@T009400HTA2A494@99005A2@T94@00R@00d@T
900=9003A2@T01<T00E492@TA009909412@2A0HT00=492@02R@2A08T00=492@03R@00d@T90069003
A2@T00DT00=492@00R@00d@T900490941b@2A00394A400`T0T@01RA4A2A490941b@00d@T90029094
3R@2A0PT00=492@00R@00d@TA00490A412@4A0DT00=492@01B@00d@T900:9005A2@T94@012@01T@T
92A4909400@TA4@T0d@69003A2A400942R@3A08T0T@00bA4900390A412@01D@TA4@T00=40b@00d@T
A00GA003R6Q400E400=XA4@01d@000Y40R@7A00394A400M400<TA4@02T@00bA4A017A00394A400M4
00<TA4@02D@00bA4A002A00494A490m400<TA4@00T@01bA4A4@TA2@024@00bA4A006A00394A400<T
00=494@00d@790=41R@00d@T900490M412@3A0@T00=494@00T@290=42R@3A10T00=492@01B@3A0@T
0T@29003A2@T01HT0d@39003A2@T008T00E492A49002A0`T00=492@04R@00d@T90029003A2@T010T
00=492@06B@00d@T900>909492@00d@T90059003A2@T00<T00=494@01B@00d@T90029003A2A400@T
0T@;9003A2@T00HT00=492@032@2A0TT00=492@02b@00d@T90039003A2@T00LT00=492@08B@014@T
94@9909400<TA4@012@01D@T92A400@T00A492A41b@01D@T92A400HT00=492@01B@014@TA4@291U4
00=XA6P01d@1J0540FP005Q400DTA4A49002A00394A401A400<TA4@03D@00bA4A00MA00394A40094
0b@01d@T94@TA2@01D@00bA49003A00494A490940b@014@TA4@290I400<TA2@01R@2A00694A4A2A4
0b@00d@TA00290941B@4A0<T00=494@01R@01D@T92A4014T00=492@01b@00d@T900290E412@2A1PT
0d@39003A2@T009400<TA2@092@00d@T900B9003A2@T00lT0T@290=400<TA4@00T@d9003A2@T00DT
0T@59003A2@T00<T0T@59003A2@T01PT00=492@00b@00d@T90049003A2@T00HT00=492@02B@00d@T
900[9003A2@T00/T0T@590941R@00d@T900D9003A2A400XT00=492@01R@2A08T1T@012A492@2A003
94A400i400=XA4@01FP2A00034@00bA4A015A00394A400I400<TA2@04d@00bA4A00GA0<T1T@00bA4
A006A08T1D@290940R@01D@TA2A400<T00E494A49003A00494@T909400<TA2@00d@290E400@TA2@T
0d@00bA490069004A2A490941b@2A00394@T00@T00E492A49002A08T00A492A41R@00d@T900?90=4
0b@00d@T90029003A2@T00<T0T@00bA490049003A2@T00`T0T@H9003A2@T01XT00A492@T0T@P90=4
00@TA4@T1d@4909472@00d@T900@9006A2@T94@T0T@:909442@3A1TT00=492@03B@00d@T900<9094
1B@00d@T900E9003A2@T00<T00=492@012@00d@T90059003A2@T018T0T@89003A2@T00@T00=494@0
12@00d@T90069004A2A4A08T0d@39004A2@T90941B@00d@T900590M40R@5A004J4A4A09X0T@1J000
2d@00bA4A01MA0=X1D@00bA4A00AA00494@T90Y40R@5A00494A490i400<TA2@00R@:A00394@T00A4
00DTA4@TA0029003A2A400M40R@3A0@T00=494@00b@2A00394A400DT00=492@00b@3A08T14@01BA4
92A4008T0T@390941b@00d@T9004909400<TA2@00R@4A08T00=492@00b@00d@T90049003A2@T00=4
2R@00d@T90039003A2A400<T0T@29004A2A4A0DT0T@L9004A2@T90=46B@2A08T1D@490Q40R@00d@T
900H9005A2@T94@052@3A00394@T00DT00=494@00b@01D@T92A400@T0T@79003A2@T008T0T@79004
A2@TA0`T00=492@01R@014@T92@2A0dT0T@59003A2@T00/T00=492@01b@00d@T90069004A2@T9094
0R@2A0dT00=492@022@014@T94@:9003A2@T009432@00d@T90039003A6Q400941R@2A0DT0T@790E4
00<TA2@00T@01BA4A4AX00=416P003=400=XA4@00d@00bA4A00RA00394A400]400=XA4@04d@00bA4
A002A00394@T00U400@TA4@T0d@29004A2A490A400HTA4@TA2@5A00594A4A2@00d@00bA4A004A08T
00E494A49002A00394@T00=40R@8A0HT0T@01RA494@TA08T00=492@01b@00d@TA003A0@T0d@79003
A2A400XT00=492@012@3A0DT0T@7909400<TA2@01B@01D@T92A4018T00=492@01B@014@T94@490=4
?B@00d@T90099004A2A4J0<T00=494@01B@00fPT900M90941b@00d@T900390E41R@01d@T92A494@0
0b@00d@T900<9003A2@T00=41R@2A0HT00=492@01R@00d@TA0059003A2@T00<T00=492@01b@00d@T
900a9003A2@T01@T00=492@07B@2A00594@TA2@01T@29004A2@T909412@00d@TA002A00494A4A08T
3D@2J09416P0019400<TA2@05D@00fQ4A004A00394A401e400<TA4@0=4@00fQ4A00:A00394A400=4
00<TA4@034@00fQ4A002A00594A4A2@00T@00bA4A004A00394A400E41R@00d@T900390A40R@00d@T
A002A0DT0T@69005A2A494@012@01D@TA2A400<T00=492@00T@I9005A2@T94@012@00d@T900<9003
A2@T00dT00=492@042@2A08T00A492@T14@79003A2A400DT00=492@0:R@00d@TA00@9003A2@T0094
00<TA2@00T@79003A2@T01/T00=492@00b@014@TA4@;90A43R@00d@T900B9003A2@T00hT00=492@0
0R@2A0dT0T@690940R@00d@T90029003A2@T00LT00E492@TA0039005A2@T94@00b@2A1lT00=492@0
3B@01D@T92@000TT00=492@012@00d@T9004A00494A4A0@T0d@391E400=XA4@00T@3J068001]A003
J4A400m400<TA4@02T@012A4A2@5A00394A4019400=XA2@024@00bA4A003A00394@T00U40b@2A004
94@T909400<TA4@022@2A0<T00=492@00R@014@T94@290U41b@4A0lT00=492@01R@00d@T900>9003
A2@T00@T0T@00bA4A0089003A2@T014T0T@99003A2@T00DT0T@N909472@00d@TA005909412@2A003
94@T00/T00=492@02b@00d@T900R9003A2@T01<T00=492@00b@00dAXA0069003A2@T00@T0T@79094
72@2A00394@T00@T0T@<90=412@2A14T0T@;9003A2@T00hT00A492@T0T@F90U40R@5A00394A400E4
00<TA4@03d@00fQ4A002A05X000dA00494A4949400<TA4@00d@00bA4900`A00394A400A40b@6A006
94A494@T1D@29003A2A4008T14@29003A2A400940R@00d@T90029003A2@T00@T00=492@00R@00d@T
90029003A2A4008T00A492@T0T@00bA4900:9003A2@T00@T0T@00bA49002A00394A4018T0T@00bA4
A0069003A2@T00<T00=492@00b@2A0HT0T@M9003A2@T00=41b@00d@T900490942b@2A0PT00=492@0
2b@3A0@T0T@=9003A2@T00DT00=492@01B@00d@T900?90941B@2A0PT0T@49003A2@T00HT00E492@T
A0029003A2@T008T00E494B/A005909400<TA2@032@00d@T90069003A2@T014T00E492@TA0029003
J2A4008T00=492@012@3A1`T00=492@042@2A0hT00=492@032@00d@T900590A40b@2A00394A400<T
1D@00bA49005A08T2T@3J0A40FP001m40R@FA00394A403U400<TA4@01d@00fQ4A003A00394A40354
00<TA4@00b@4A00394A400DT00=494@00d@49003A2A400A400HTA4A494@=90=40b@01D@T92A400HT
00M494@TA2A4008T00E492@TA0089003A2@T00PT0d@@909432@00d@T90089003A2@T00@T0T@O9094
00<TA2@04R@00d@T90039004A2A4A0HT00=492@012@2A08T0T@00bA4A002A08T00=492@012@00d@T
900790A40R@00d@TA002A0PT0T@39003A2@T00lT0d@79003A2@T00943R@014@TA4@390941B@01D@T
92A400<T00=492@01R@3A1@T00=492@03R@00d@T900990941b@00d@T900B9003A2@T00LT0d@:9003
A2@T00/T00=492@02b@014@T92@2A0XT00A494A40R@4A00494@T90U400=XR4@01d@016Q4J6P2A05X
000SA00394A404]400<TA4@01d@01BA4S6PT00a400<TA4@03T@00bA49009A00394A400i400<TA4@0
0d@00bA4A002A0DT0T@00hQ4A002A08T0T@012A492@5A00394@T00LT0d@2909400DTA4@TA00=90A4
0b@00d@T90089003A2@T00TT0d@A9003A2@T00DT00=492@05B@01d@T92A494@01b@00d@T900@90=4
6B@00d@T90099003A2@T008T00=492@00b@01T@T94@TA18T0T@00bA490049003A2@T018T0d@69006
A2@TA2A42B@00d@TA0049003A2@T008T00=492@02B@2A0DT0T@49003A2@T01XT00=492@01R@00d@T
900:9003A2@T02LT00=492@07R@01d@T92A494@02b@01D@T92A400PT00A494@T1D@00bA49009A003
J4@T01940FP002A400<TA2@0:T@291m400<TA4@02T@00bA4A005A00394A400I400<TA2@00T@00bA4
A00>A00494A490a400HTA4@TA2@3A0@T1D@00bA4A002[0A400<TA2@00b@7A00594@T94@012@4A08T
0d@@90940b@2A10T00=492@012@00d@TA0079007A2A494@TA00C9003A2@T00HT00E492@TA00=9003
A2@T00940R@014@T94@=90941B@00d@T90069003A2@T00LT00=492@02B@2A0dT00=494@02B@00d@T
900T90=41B@01T@T94@TA1LT00=492@022@00d@T90029004A2A4A2XT00=492@02R@2A0HT00=492@0
;B@00`0T900A9003A2@T008T00=492@00d@69003A2@T00@T00=494@02B@2A00394@T00DT0T@00bA4
A00FA000:d@00fQ4A002A003J4A402E400<TA4@024@29003A6Q400a400<TA4@03D@00bA4A00;A003
94A400i40b@3A08T2D@012A4A4@4909400<TA4@00T@00bA4A004A003R=6800A40b@00d@T90029003
A2A400=40b@00d@TA004A0@T0d@69003A2@T00dT0T@@90940b@2A00394@T00<T00=494@00d@39094
0b@2A0`T0T@29003A2@T00<T00=492@00b@5A0@T00=492@012@00d@T90079003A2@T00LT14@39094
0b@01D@T92A400HT00A492A40R@00d@T900b90A41R@00d@T90059007A2@T94@TA00890A41B@2A0@T
00=492@00T@29003A2@T01@T0T@29003A2@T02dT00=492@02B@00d@T900K900302@T01hT00=492@0
0b@014@T94@E90941B@02d@T92A494@TA2A400<T1d@01RA4A6Q4J0U416P000Y400<TA4@0A4@00bA4
A00NA00394A400I400<TA4@03D@00bA4A00<A003J4A4009400<TA4@00T@00bA4A002A00394@T00Y4
00<TA4@01D@00bA4A002A00394A400A400N/d4A494@T00A41R@4A00594A4J2@014@69003A2@T00<T
00=492@00b@00d@TA00590941R@00d@T90029003A2A400HT0T@290E40R@014@TA2@5A08T0T@00fQ4
A003A0DT00E492A49004A08T00=492@00R@00d@T9002909400@TA4A40R@3A00394A4008T0T@00bA4
900390A42b@2A08T0T@00bA4A002A00494@TA08T0T@59003A2@T00LT0T@49003A2@T00/T00=492@0
2b@00d@T900990=41R@014@T94@490940b@00d@T900990=42b@024@T94B8A2A41R@014@T94@290=4
22@2A1@T00=492@06b@00d@T90089003A2@T00LT00=492@0=2@01D@T92A401TT0T@49003A2A4008T
0T@290=40R@:A003J4A400U400=XR8P00FP004Y400@TA4@T?D@01BA4A4AX009400<TA4@02T@00bA4
9005A0@T2d@00bA4A005A08T0T@2909400HTA4A4c8P5A00394A400LT14@012A492@2A00394@T00DT
00=492@02R@00d@T90059003A2@T02@T0T@59003A2A400=400<TA2@01B@3A1LT0d@29003A2@T00TT
00A494A412@00d@TA0039005A2@T94@00R@3A0HT14@=9003A2@T01<T00=492@03B@3A2TT00=492@0
2R@00d@T90089004A2@TA0DT0d@89003A2A401<T00=492@06b@00d@T900`9003A2@T00TT0T@<9004
A2@TA0hT00A492A422@014@T92@2A0@T0T@01BA4A2A4008T0d@2909400<TA4@034@00fR8R001R000
2D@00bA4A00MA00394A400]400<TA4@03D@00fQ4A00291A400<TA4@0?D@290Q400<TA4@024@01BA4
94AX00A40R@3A00894@TA2A4J8P3A08T00=494@00T@29003A2A4009400@TA2A42R@014@T94@39003
A2@T008T00=492@00R@014@T94@99005A2A494@01B@014@T92@4A14T00=492@012@3A08T00=492@0
0R@5A1DT0T@69003A2@T00XT00=492@01b@3A0<T0T@39003A2@T00=42R@00d@T900A9006A2A4A2A4
1B@00d@T900<909412@00d@T900<90=482@3A00394A400LT0T@79003A2@T00PT00=492@02R@00d@T
90039003A2@T008T00=494@05b@2A08T00=492@0>R@00d@T900:909432@00d@T9002A0@T14@79094
0b@6A08T1D@00bA4A003A00394A400=40fP014AXA6P2R09X000bA00394A400i400<TA4@024@012A4
A2@3A00394A401]400LTA4A494@T01=400<TA4@02d@00bA4A00CA00394A4009400<TA2@014@022A4
A2A494@T0d@00bA4A003A00394A400M400@TA2A4:R@3A0dT0d@B909412@7A0HT0d@J9004A2A4A0TT
00=492@012@00d@T900390A40R@4A0<T14@:9003A2@T01<T00A492A42R@00d@T9006909400<TA2@0
3R@6A0dT00=492@04B@00d@T900;90=412@00d@T90089003A2@T00hT00=494@01b@00d@T900;9003
A2@T01XT00=X92@05B@00d@T90059003A2@T00lT00=492@072@4A08T0d@290940R@2A08T0d@390=4
00<TA4@024@00fQ4J003A003J4A400AX000IA003J4A401M40R@7A00594A4A2@01D@00bA4A002A003
94A4009400PTA4@TA2A4911400<TA4@014@290U400<TA4@0;4@00bA49006A00394A400=400<TA2@0
2D@290=40R@3A00394@T00I400<TA4@00R@00d@TA00390A4:2@00d@T90039003A2A400940b@00d@T
A00:9003A2A400DT00=494@014@79003A2@T00/T00=494@00T@;9003A2@T00PT0T@G90940R@00d@T
90089003A2@T020T0T@29003A2@T008T0d@00bA4A0099003A2@T00<T00=4J4@012@2A0/T00=492@0
0R@00d@T90029003A2@T00@T00=492@0<B@00d@T90069003A2@T00XT0T@K90941B@00`0T90029080
2R@00d@T900590943b@00d@T90049003A2@T01@T0T@390A412@00d@TA003A0<T00=494@01d@00bA4
A005A003R6QX00A400=XA4@00T@1R054000:A00394A400I400@TA4@T3T@00bA4A00?A00594A4A2@0
3T@00bA4A00^A00694A494@T9d@290E400@TA2@T0T@390940R@8A00394A400940R@3A08T00=492@0
14@490=41R@2A0LT00=492@012@3A0dT00=492@042@2A08T00=492@00R@00d@T90079003A2@T00@T
00=494@00d@790940R@00d@T900<9003A2@T01HT00=492@0>B@2A0DT0T@59003A2@T00<T00=492@0
0T@00bA4900>9004A2A4A0<T0T@?9003A2@T01DT00=492@04R@00d@T900=90944b@00d@T900L9094
5B@00d@T900290944b@00d@T900N909400<TA2@02b@2A00394@T008T1T@012A4A2@7A09X1D@2J0=4
0FP1R05X0008A00394A4015400<TA4@00d@00bA4A002A00394A400M400<TA4@0>T@00bA4900>A003
94@T02A40R@2A00394A4009400<TA4@014@390M400@TA4A40R@01D@TA4@T00941b@4A0<T14@00bA4
90059005A2@T94@022@3A0<T00=492@00T@79005A2@TA2@00T@49003A2@T00@T00=492@01b@00d@T
90069003A2@T00@T0d@00bA490099003A2@T00dT00=492@0<b@00d@T900590943R@2A0DT00=494@0
7b@00d@T90089003A2@T01PT00=492@01R@01D@T92A401dT0T@E9003A2@T014T0T@>9003A2@T008T
0T@A9003A2@T00HT00=492@04B@00d@T900N90E422@3A0<T0T@290m400EXA4A4J003A09X0T@016Q4
A6P2R00000=4J4@01d@00bA4A007A00394A401E400<TA4@0:4@00bA4A00=A08T1T@00bA4A005A003
94A4009400<TA4@01T@00bA4A009A00394A401=40b@6A0<T0d@00bA49004A0<T0d@69003A2A400DT
0d@29003A2@T008T00=492@00R@3A00394@T00@T0T@=9003A2A400<T0T@49006A2A4A2A43B@01d@T
92A494@022@00d@T900=9003A2@T00HT0T@01BA492A401HT00=492@04B@00d@T90039003A2@T01XT
00=492@08R@00d@T900<90949b@3A2DT00=492@03B@00d@T90039003A2@T01@T00=492@00T@D9003
A2@T018T00=492@07b@01D@T92A400HT00=492@00b@3A0hT00A492@T1D@00bA49006A08T1D@29094
00=XA4@01T@00fQ4J001J0003D@00bA4A00]A00394A4011400=XA4@014@00bA4A00DA00394A400Y4
00<TA4@00d@00bA4A00TA00394A400E400@TA2@T24@69003A2@T00940b@2A00394@T008T14@59003
A2@T00@T0d@290A412@014@T94@49003A2A400<T00A492@T14@012A4A4@D90940R@00d@T90029003
A2@T01/T00=492@05b@00d@T900A90=44b@2A1DT00=492@07b@00d@T90069003A2@T00hT00=492@0
0R@2A0lT0T@L9003A2@T00DT00=492@00b@00d@T90029003A2@T00LT00=492@02R@00d@T900:9005
A2@T94@08R@014@T94@V90940R@00d@T90029005A2@T94@01B@2A00394@T00LT00=492@012@9A08T
2D@00bA4A004A005J4A4J8P00fP1R05X0FP00003A8R800I400=XA4@05T@00bA4A00FA00394A400E4
00<TA4@02T@00fQ4A00PA00394A400A400<TA4@074@012A492@IA08T1D@49004A2@T90=400<TA2@0
1b@3A00394A400TT14@39004A2@TA08T00=492@012@2A00594@T94@01B@6A0hT0T@00bA490029094
0R@014@T94@O9003A2@T00hT00=492@01R@01D@T92A400PT00=492@012@00fQ4A00;9005A2@T94@0
0b@00d@T90069003A2@T024T00=492@00b@2A0@T00=492@05b@00d@T90029003A2@T00HT0d@69003
A2@T00XT00=492@02B@00d@T90099003A2@T018T00=492@01B@00d@T900>9004A2@TA0lT0d@E9003
A2@T02XT00=492@012@00d@T900590941b@2A0@T1d@01FQ4A2A4008T1T@290=400=XA2@014@01hQX
J4B8S8P00FP000:/00><J4@0;d@00bA4A01CA00394A400A400<TA4@01T@00bA4A00FA0@T14@00bA4
A0049003A2@T008T00=494@00R@00d@T9002A00394A400=42R@3A0LT00=492@01b@3A0<T00=492@0
12@00d@T9002A0<T00=492@01B@00d@T900;90941b@00d@T90069004A2A4A1dT00=492@02R@2A0`T
00A492A40VPi90941b@2A14T00=492@09B@00d@T90059003A2@T00DT00=492@00b@2A00394@T00XT
00=492@05R@01D@T92A400<T00=492@02R@4A0`T00=492@05B@00d@T900[9006A2A4A2A43B@2A0DT
0T@59003A2A4008T1T@00bA49005A08T1D@00bA4A006A003J8b8005X000016Q4A6PZA00394A400M4
00DTA4A4900fA00394A401=40R@FA0=X2T@00bA49002A00394A4008T14@00bA4A0049004A2A49094
00<TA2@012@00d@T9002A00394A400A400@TA2@T14@39003A2@T00`T0d@49004A2@TA0@T0d@@9003
A2@T00@T0T@00bA490049003A2@T01DT00=492@092@00d@T90099003A2@T018T00=492@00b@00d@T
90089003A2@T00/T00=494@0?B@014@T94@89003A2@T00@T00A492A46b@00d@T90189003A2@T02PT
00A492A41b@00d@T900C9003A2@T00<T00E492@TA00390A400<TA4@00T@00bA4900390=400<TA4@0
24@2J003A6QX009X0009A00394A400Q400<TA4@09d@00bA4A00MA00394A400a40R@aA004J8S@S1I4
0R@4A0DT14@490=40R@00d@TA004A00394A400=400@TA4A412@00d@T90039004A2@T90940b@2A0HT
0T@00bA4A00B9004A2@TA0DT1D@O9003A2@T01LT0T@79003A2A401XT0d@M9004A2@TA0@T00=492@0
?2@2A0<T00=492@08B@014@TA4@290=400<TA2@02R@2A1DT00=492@0>R@00d@TA00O90943B@01D@T
92A400/T14@390a400<TA4@034@2J054000CA00394A4011400<TA4@09T@00bA4A01=A09X00B/lM1X
5T@290=40R@00d@TA005A08T0T@29005A2@TA2@00T@29004A2A4909400@TA2A42B@2A08T14@00bA4
A002A0<T14@00bA4900:9004A2@TA0HT0T@2909400<TA4@00T@012A492@2A0<T00=492@01B@00d@T
A00=9003A2@T00`T00=492@03B@01T@TA4@TA0XT00=492@01B@2A0HT0d@79003A2@T01<T00A492A4
0R@2A0HT00=492@022@00d@T900<9003A2@T00/T00=492@04R@2A00394A400DT00=492@01B@2A0@T
00=492@01R@00d@TA002A00494A490A400<TA2@04B@00d@T90079003A2@T00<T00=494@042@00d@T
900I90=43B@00d@T90049003A2@T008T00=492@03B@00d@T900690=400@TA2@T0T@@90e400=XA4@0
2D@00fQ4A006A0AX000:A00594A4A2@014@290a400<TA4@05d@00bA4A006A00394A400i400<TA4@0
<D@00bA4A00DA004J8S@R0m40R@00d@T9003A00394A400=40R@014@T92@7A0LT00=494@00R@2A08T
0T@29003A2@T00HT0d@490940R@2A00494@T90=41B@00d@T900:9003A2@T00<T00=492@00T@59094
12@2A0LT00A494A41b@00d@T900390=48b@00d@T900790=41R@2A0HT00=492@00R@00d@T900N9094
22@00d@T900i9003A2@T010T00E492@TA0089003A2A400<T0T@29003A2A401hT00=492@0<b@00d@T
90069003A2@T01hT0T@39004A2@TA14T0d@39003A2@T008T1T@00bA4A005A00394@T00Y400=XA4@0
0T@4J0002T@00bA4A002A00394A401540VPYA00394A401a400<TA4@06D@00bA4A00EA09X1D@00bA4
A007A00694A4A2A40b@4A08T14@00bA4A005A0@T00M492@TA2A4008T0T@00bA4A0039003A2@T008T
00I492@TA2@8A00394@T00HT00=492@02B@3A0<T0T@29003A2@T01TT00A492A41B@00d@T90059094
;b@2A0HT00=492@00R@2A00394A400<T0d@79003A2@T02/T00=492@06b@00d@T9002909400<TA4@0
52@01T@T92A4J08T00=492@022@00d@T900390940R@3A3LT00=492@0@B@00d@T90029004A2@TA1<T
00=492@01R@00d@TA003A00394A4008T1T@490I400=XA4@00T@4J0680FP1A0002D@390=400@TA2@T
3T@00bA4A002A00394A401e40R@<A00594A4A2@05T@290=400<TA4@04D@00bA4A00MA08T2D@00bA4
9002A08T0d@290I40R@00d@TA002A0<T00E494@TA0049003A2@T00/T14@490M422@4A00394A400<T
00=492@00R@00d@T900P9003A2@T00HT0T@W9003A2@T00LT00=492@04R@014@TA4@K9003A2@T01LT
00=492@02b@014@T92@2A1HT00I492A494@F90=400<TA4@022@2A0DT0T@F9003A2@T028T0d@U9005
A2@T94@062@2A0HT00=492@03B@00d@T9006909412@7A08T00E494A49004A00394A400Q40VP00dAX
J003A0000d@00bA4A00=A08T0d@00bA4A00GA00394A401m400<TA4@07D@00bA4A003A00394A402=4
00=XA4@01T@00bA4A003A00594A4A2@00T@00bA4A004A0@T0T@3909400<TA2@00d@01RA4A4@TA0@T
00=492@00T@6909400<TA2@00T@390M400<TA2@00d@390A47B@00d@T90039003A2@T00`T00=492@0
0R@00d@T900@9003A2@T00DT00I494A494@690945B@00d@T900:90941B@00d@T90069004A2@TA24T
0T@>9004A2@TA1`T00=492@032@00d@T900590940b@014@T92@3A08T0T@39003A2@T00<T00=494@0
0b@00d@T9003A0@T00=492@032@00d@T9003900302@T00hT00@092A452@2A10T00=492@00R@014@T
94@5909432@00d@T9002A08T00=492@012@00d@T90069004A2@TA0LT0d@59003A2A400e40b@5A003
J4A400940VP2A05X0D@1A0004d@00bA4A007A00394A4039400@TA4@T4d@00bA4A004A00494A4A08T
2T@00bA4A00VA08T00=494@00T@00bA4A00290940R@00d@TA0059003A2@T009400@TA2@T14@29094
0R@2A00394A400<T0d@790941B@2A0=X0d@590M432@00d@T900:9005A2A494@00b@5A1DT00=492@0
0b@00d@T90069003A2@T00DT00=494@0:B@2J0PT0T@N9003A2@T00TT00A494@T0d@79003A2@T00TT
0d@F90942b@00d@T90099003A2@T008T00=492@022@2A0<T00=492@02B@00d@T900/909452@00d@T
900B90940R@3A0<T00=492@02b@00d@T900;909462@3A00394A400]40b@:A09X0d@3J0002T@00bA4
A00DA00394A400Q400<TA4@08d@00bA4A01AA00394A400m400<TA4@00b@00d@T9004A0@T0T@00bA4
90039003A2A400LT0T@69003A2@T00<T00=494@02T@590M400<TA4@03R@2A0DT00=492@022@00d@T
9004A0/T00=492@06R@2A0lT00=492@042@00d@T90049003A6PT01LT00=492@01B@2A0HT00E492@T
A00690E400<TA2@01b@014@T92@2A0HT0d@;9003A2@T01TT00=492@012@00d@T90039003A2@T00TT
00A492@T0dA99003A2@T02/T00A492A482@2A0DT00=Xd:`00d@00fQ4A003A00394A400A40R@00d@T
9002A08T00A4J6QX14@1J0540FP0011400<TA4@01d@00bA4A009A00394A400=40b@=A0=X2T@00bA4
A002A08T5T@01RA4A2A493Y400<TA4@00d@00bA49005A004J4A490M400<TA4@00T@590940b@3A08T
00E492@TA00A9003A2@T00Y41B@8A0<T0T@;9003A2@T00=400<TA2@03B@3A1/T0d@E9003A2@T00<T
00=492@032@00d@T9002A0XT00=492@04R@2A0@T00A494A45B@00d@T90099003A2@T00PT00=492@0
3B@00d@T900H9003A2@T01@T00=494@00R@2A00494A4A1PT0T@U9003A2@T00/T00=XA2@01B@00d@T
9018909400B8A4@T0d@690941R@6A09X1D@1R05X0FP001A400<TA4@014@290i40R@>A003J:b/00Y4
00<TA4@0<4@29003A2A402m400<TA4@01D@290Y42B@2A00394A400DT0d@390943R@3A003J4A40094
00<TA2@00d@00bA49006A00394@T00940R@2A00394@T00940R@6A0DT0d@39003A2@T00@T0T@00bA4
A004A0DT0T@=9003A2@T01@T00=492@00R@2A0`T00=492@014@00bA4900M9003A2@T01`T00A492A4
7b@00d@T900;909400<TA2@072@00d@T900790=400@TA2A43B@00d@T900D9003A2A403<T00=492@0
0b@014@TA4@<9003A2@T01PT00=492@05R@5A0<T00E492@TA00490U400AXA6Q40VP1S05X0D@001A4
00<TA4@05D@391Q400DTA2A4901WA005J4A4A2@02d@01bA492A494@00R@6A0HT0T@00bA4A002A0<T
00=492@00R@00d@TA00BA00394A400=400<TA4@00R@2A08T0T@290E40VP012A4A4@69004A2@T9094
1B@2A00694A4A2A4<R@00d@T9002A0DT00E494A49008A0lT0T@<90946B@2A00394@T018T00=492@0
2R@3A0<T00=492@02b@00d@TA0069003A2A401XT00A494@T0d@79003A2@T00`T00=492@0>R@00d@T
900<90=482@2A08T0T@29004A2@TA0PT00Q494A494@TA08T00=492@01D@2909400<TA2@00R@00d@T
9002A09X00=4J4@00d@016Q4A8P4J00014@00bA4A00<A00694A494@T0T@00bA4A00?A00394A401=4
00<TA4@00d@00bA4900MA00394A4029400<TA4@07D@00bA4A005A0@T24@69004A2@T90I40b@2A0<T
14@;90=40R@7A08T00A494A40R@5A08T00E492@TA0039003A2@T00<T1D@00bA4900:9003A2@T00<T
00=492@072@2A0dT00=492@022@00d@T900290941b@:A0dT00=492@032@00d@T900I9005A2A4A6P0
0T@00bA4900=909432@3A2<T00=492@07B@00d@T900/900302@T02LT00=492@00R@2A20T00=492@0
6R@2A0<T1D@39004A2@TA0<T14@016Q4A6P2A005J4A4A6P00T@2J0007T@00bA4A00=A00394A401M4
00@TA4A40R@00d@T900<A00394A401U400<TA4@09d@01bA4A4@TA2@00d@290U40R@4A08T14@39094
12@3A003J2@T008T0T@290=422@2A08T00A494A41B@7A00394@T008T1T@00bA4900=90940b@00d@T
90089003A2@T00@T00=492@02R@2A2XT0T@290942B@2A00394A4009400<TA2@00R@00d@T900W9003
A2@T00DT00=492@00b@6A0XT00I492A494@89003A2@T00hT00I492A494@L9003A2@T008T0T@69003
A2@T01HT00=492@01R@00d@T90069003A2@T04HT00=492@03b@01D@T92A400hT00=492@02R@2A003
94A400M41B@014@T92@5A003J4A400940VP2A004J4B8J068000CA08T2d@01BA494@T00A400=XA4@0
0d@00bA4900>A00394A400U400<TA4@0DT@3909400<TA4@02T@490E41B@3A08T14@01BA4A4@T0094
00HTA2@TA2@5A0<T00I494@TA2@6A0<T0d@00bA4A003A00394@T00<T14@00bA490039004A2@TA08T
0d@29003A2@T00LT14@39003A2@T00@T00=492@01R@2A0<T00=492@03R@00d@T900W90E41b@00d@T
900T9003A2@T00dT00A492@T0T@79003A2@T00DT0T@K9003A2@T00lT00=492@03B@2A0LT0T@89003
A2A401hT00A492A4Ab@00d@T900Q9003A2@T00<T00=494@012@00d@TA004A00494A4J09412@@A003
J4A4009X0T@0019400@TA4@T2T@29003A2A400I400<TA2@00T@39003A2A400Y400<TA4@02D@00bA4
A00=A00594A4A2@06d@00bA4A00UA00394A400a40b@00d@T9003A00494A4A0<T1T@290=400<TA2@0
0d@00bA4A003A00594A4A2@00T@390=400<TA4@01B@014@T94@290=40R@014@T92@3A00394@T00<T
0T@490941B@014@T94@5909412@2A00394@T018T00A492A412@00d@T900V9005A2@T94@012@014@T
A6P29003A2A400PT00=492@05B@00d@T900=900302@T00@T00=492@00R@00d@TA0079003A2@T00<T
0T@C9003A2@T01TT00=492@03R@2A0HT00=492@00R@2A0PT00=492@01B@00d@T900@909472@00`0T
900<900302@T01PT00<092@06b@3A0PT00=492@00b@2A00394A400@T00M494A494@T00=40b@AA003
J4A400=X0D@0011400<TA4@03T@00bA4A007A00394A400A40R@7A0<T8D@012A4A2@NA00394A401m4
00<TA4@03D@01BA494@T00A40b@014@T92@<A0<T1T@012A494@29003A2@T00DT00=492@012@00d@T
A003A00394@T00940R@00d@T900990A40R@2A0<T00A492A40R@2A08T00A492A412@00d@T900P9003
A2@T00XT00=492@00b@2A1`T00E492@TA0079004A2@TA0<T00=492@03B@2A0DT00=492@00R@00d@T
900Q9003A2@T00lT0T@;9003A2@T00hT0T@J9003A2A405hT00=492@0=R@00d@T90069003A2@T0094
00<TA4@03D@012A4A4@2J0U400=XA6P00T@0021400<TA4@02d@012A492@9A00494@T91a400<TA4@0
0T@00bA4A002A00394A400U400<TA2@074@00bA4A00@A00494@T90]400DTA4@TA00290E41b@5A004
94A4A0DT0T@01BA4A4@T00A400<TA2@00d@00bA4900390940R@014@T94@390M41R@00d@TA0039003
A2@T01LT00=492@082@00d@T900;90=452@00d@T900E9003A2@T008T00A492A46b@00d@T90069094
00<TA2@0:2@2A08T00=494@05b@2A0@T00<094@02B@00d@T900>9003A2@T01/T0T@59003A2@T00@T
00E492@TA00U9003A2@T01<T0T@3909412@00d@T90039003A2@T01`T00=492@012@6A08T1T@012A4
A2@2A00394A400Q40FP1A054000JA00394A400E400<TA4@02d@290Y40R@00d@T9006A00394A401E4
00@TA4@T0T@00bA4A00:A00394A400M400@TA4@T14@390a40R@9A00394A400A400<TA2@01D@00bA4
A002A00394@T00<T14@;90940R@014@T92@2A0HT00A494@T0d@00bA49004A00394@T00<T00=492@0
1b@3A00394@T00=40b@4A1HT00=492@00R@2A0@T00=492@01b@00d@T900390946B@014@T92@2A0hT
00=492@022@00d@T90079003A2@T00XT00A492A412@00d@T900C9003A2@T00LT0T@;9003A2@T01LT
0T@n9003A2@T018T00=492@04B@00`0T900F900302@T00`T00<092@092@00d@T9002A0/T00A492A4
3R@00d@T900390=40b@00d@TA003A00394A4009400<TA4@04d@00fQ4A002A0008T@00bA4A00;A003
94A400U400<TA4@01T@00bA4A00DA00394A400M400<TJ8P054@00bA4A00JA00394A401U40R@3A08T
0T@390940b@3A0@T0d@290940b@00d@T9003A08T14@39005A2@T94@01B@014@T92@5A08T14@49003
A2@T009400<TA2@00b@01D@T94@T00=40b@3A00394A4009422@4A00394AX00@T0T@:9003A2@T008T
00=492@01b@2A08T14@39003A2@T00HT0d@59003A2A400941R@00d@T900390940b@2A0XT00=492@0
42@2A0@T0T@69007A2@T94@TA005909422@00d@T900;9005A2A4A6P01B@00d@T900>9003A2@T00A4
00DTA4@TA00790944b@01D@TA2A4024T00=492@04b@00`0T900@9003A2@0018T0T@B9003A2@T008T
00=494@00b@00d@T900:909400<TA2@00R@2A00394@T00@T0T@490I40R@2A08T00E492A4J00;A08T
0d@00fQ4J002A00084@00bA4A00BA00494A490=400<TA4@06D@00bA4A00290E400<TA4@00R@3A003
94A400I400<TA4@05T@00bA4A007A00394@T00Y40R@;A00994@TA2A494@T00=40R@2A00594A4A2@0
14@290I40b@2A0DT14@490940R@01D@T92A400DT00A492@T14@390A432@3A0DT0d@4909400@TA4A4
3B@00d@T900@90944R@3A0dT00=492@012@5A0DT0T@590948R@2A08T00=492@04R@2A1<T00=492@0
1B@2A1dT0d@890944B@3A2LT00<092@06B@00`0T900m9003A2@T00PT00=492@052@01d@T94@TA2@0
0d@29003A2@T00E400<TA4@00T@012A4A2@9A0004D@01BA494@T00I400<TA4@01D@00bA4A003A003
94A4009400@TA4@T0d@29003A2@T00<T24@00bA4A002A00394A400Y40R@00d@TA003A08T1D@00bA4
90029003A2A4009400<TA4@05T@012A4A4@291A40R@>A00394A400E400@TA4A41B@00dAXJ0029004
A2A4909400<TA4@014@49003A2A400@T1T@00bA4A003A0@T00=492@00b@00d@T9003A08T00=492@0
0b@7A08T00A494A40R@00d@TA003A00594A4A2@014@290=400<TA2@01R@00d@T900O9003A2A401HT
00=492@00d@39003A2@T010T0T@R9003A2@T00PT00A494A41b@00d@T900:909400DTJ8Q49003A1HT
00=492@08b@00d@T90069003A2@T054T00A492A46b@2A0HT00=492@042@00d@T900<9004A2@T90I4
00@TA2@T1d@01BA494@T00M400AXA6QX0D@001a400@TA4@T2D@00bA4A002A00394A400I40b@01D@T
A4@T00A400<TA4@024@00bA4A004A00394@T008T00E494A49003A00694A4A2A40R@5A00494A490i4
00<TA4@02T@00bA4A00@A00394@T00i400><A4@01d@00bA4A003A0DT0T@390]40b@00d@T900390M4
00<TA4@00T@01BA4A4@T00=412@2A0HT0T@012A492@7A0@T00A4J4A40R@6A00394A4009400<TA2@0
0R@4A0DT00=492@04b@00d@TA00F9003A2@T00DT0T@290I40R@014@T94@A90=45B@2A0DT00=492@0
3B@2A08T00=494@01R@00d@T900;9003A6QX03hT00A492A45R@2A0PT00<092@06R@00d@T900Q9003
A2@T00PT00=492@02b@00fQ490069003A2@T00`T00=492@012@2A00394A400HT0d@012A4A2@4A003
94A400a400<TA4@01D@00fQ4A002J0004D@012A4A2@9A00494A490a400@TA4@T1T@00bA4A00490I4
00<TA2@01d@00bA4A003A0@T1D@290E400<TA4@03D@00bA4A00<A08T0T@00bA4A00DA08T0T@00bA4
A005A00594A4A2@014@012A492@2A00394@T00E400@TA4@T0d@29004A2@T909400@TA4@T1D@00bA4
900290A41R@014@T92@6A08T00E492@TA0029003A2@T00E40R@8A08T14@390A412@2A08T00=492@0
0R@2A0`T00=492@03R@2A1HT0T@79006A2@T94@T0T@79003A2@T00@T0T@39003A2@T00@T00=492@0
0b@00d@T90029003A2@T00XT0d@B909462@3A3TT00=492@03R@00d@T9004900302@T008T00E492@T
A008900402@TA08T0P0A90809R@00d@T900>9003A2@T00@T00A492A40b@014@T94@?9003A2@T008T
0T@39003A2A400940R@;A00394@T00Q400DTA4A49005A003J4A4009X0HP1J0001d@00bA4A00QA005
94A4A2@014@00bA4A004A08T6D@00bA4A002A00594@TA2@01T@00bA4A005A00394A400A400<TA4@0
=T@022A494@TA2A40b@00d@T9005A08T0d@012A4A2@2A00394A4009400/TA2@TA2A494@TA00290A4
12@014@T94@39004A2A4A0@T1T@29003A2A4009400<TA2@034@690E40R@014@T92@2A0<T0d@;9094
12@00d@T900F9003A2@T00PT0T@69003A2@T008T00=494@03R@00d@T90029003A2@T018T0T@89094
00<TA2@032@00d@T900L90=40b@00d@T90049003A2@T01<T00=492@0Cb@00d@T9004900402A4A2LT
00=492@052@01D@T92A400<T00=494@00T@29003A2@T00XT0T@39003A2@T00TT1d@490E400<TA4@0
0b@3A00394@T00=400=XA6P00VP1S0680002A00594A4A2@02D@00bA4A00AA00394A400m400LTA4A4
94@T009400<TA4@034@00bA4A002A00794A4A2A49004A00394A400A400<TA4@01T@00bA4A00?A003
94A4021400<TA4@03D@00bA4A004A00694A4A2A40R@2A0<T00=492@00R@2A0DT0d@00bA49004A18T
00=492@00R@00d@TA004A00494@T90=40R@5A003J4A400E400<TA4@00b@5A0HT1d@39003A2@T02@T
00=492@01B@00d@T900290=47b@00d@T900;9003A2@T00PT00=492@00b@2A0<T00=492@0:2@3A1@T
00=492@08R@00d@T90059003A2@T00HT00=492@02B@00d@T900@900302@T00lT0TA<90940b@00d@T
9006909400@TA4@T14@790M412@5A00394A400a400=XA6P00VP2R0003D@00bA4A00UA00394A40094
00<TA4@02D@00bA4A01KA00394A400U400<TA4@014@01BA4A4AX009412@5A00394A400940b@3A0<T
0T@39004A2@TA0@T0T@39006A2@T94@T0T@01BA4A2A400@T64@00bA4A002A08T0d@690Q412@00d@T
A0039003A2@T008T0d@;9003A2@T00@T0T@59003A2@T00XT00=492@01b@00d@T90049003A2@T00hT
00=492@02B@3A00394@T00<T00=492@00b@00d@T9003A08T00A492A43b@4A0LT00=492@01B@00d@T
9004909452@00d@T90039003A2A400XT0T@>909422@00d@T90069003A2@T04dT0T@G9003A2A401hT
0T@690E412@2A0<T0T@016Q4J4@390I400<TA4@024@2J0E40FP1R06800000d@TA00KA00394@T00E4
00<TA4@01D@00bA49004A0<T00=494@01D@00bA4A01>A00394A400e40R@3A08T14@290A400<TA4@0
0d@00bA4A002A00394A400Q400<TA4@00T@290A41B@3A00494A4A08T0T@490940b@2A08T0d@491E4
0b@00d@TA007A00394A400@T1D@39003A2@T00=40b@2A0@T0d@C9003A2@T010T00=492@01b@2A0PT
00E494@TA00=9003A2@T00<T0d@89003A2@T00@T0d@G9003A2A4008T00=492@02b@3A0LT0T@390A4
42@00d@T900;9003A2@T00@T00=492@032@014@T94@Q90942B@00d@T900/90E442@2A00394A401`T
0T@390940R@01D@T92A4008T00=494@00R@00d@TA006A0<T14@01bA4A4AXA6P02D@00bA4J002R05X
000KA00394A400U400<TA4@03D@012A492@YA08T2T@00bA4A00XA003J4A4009400=X94@024@290=4
00<TA2@014@29003A2@T00@T3D@490A40R@4A00394@T00E400<TA2@01B@5A00394@T00<T1T@290=4
00<TA4@03D@00bA4A002A0<T00=494@00R@6A08T0T@00bA4A005A08T00A492@T0T@29003A2@T00LT
14@590940R@3A08T00=492@012@014@TA4@390940b@4A00394@T00@T0d@;90E400<TA2@01D@:9003
A2@T00<T0T@49004A2@T909400<TA4@012@00d@T9005909400<TA4@012@00d@T900?90940b@2A003
94@T00LT00=492@02B@00d@T900;9003A2@T00940b@2A0@T00=494@05b@00d@T900<9003A2@T01/T
00=492@06B@2A004J4A4A0DT00=492@01b@5A0`T00=492@02b@014@TA4@290940R@2A0DT00=492@0
0b@7A08T00=494@00b@01D@TA4@T00a400@TA4A40VP001A400<TA4@03d@2909400<TA2@034@00bA4
A002A00394A400940R@@A00394A401U400<TA4@0=D@390E40R@00d@TA002A0DT1D@00bA4A003A003
94A4009400@TA2@T0T@012A492@4A00394@T00A400HTA4A494@59005A2@T94@00b@6A0<T0d@00bA4
9007A00394A400A40b@00d@T900690940R@6A08T14@490943R@3A0DT1D@012A492@2A0lT0T@49094
00<TA4@00b@014@TA4@A90Q46R@2A0/T00=492@00d@390940R@00d@T900D9003A2@T00TT00=492@0
1R@00d@T900B9005A2@T94@012@4A1TT00=492@04B@2A0hT00=492@08R@3A0DT0T@00bA4900G9003
A2@T00XT0T@29004A2@TA08T00=492@02b@00d@T9004A0<T0T@290E40R@9A09X14@1J0540006A003
94A400m400<TA2@03d@00bA4A00:A00494A491M400<TA2@01T@00bA4A00<A00394A401Y400<TA4@0
6T@00bA4A009A00394A400A41R@3A0<T1d@012A492@2A00394A400i40R@2A00394@T008T00=494@0
0R@014@TA4@49004A2@TA0HT00=494@00T@290Q40R@00d@T9002A00494A4A0<T2T@00bA4A003A003
94@T00=40R@2A0<T00=494@012@2A0HT1D@290944B@2A00494@T90940R@7A08T0d@69003A2@T008T
00=492@012@00d@T9003A0<T0T@29003A2@T014T00=492@01B@2A08T14@K9003A2@T01<T00=492@0
22@2A0TT00=492@02B@01D@T92A403PT00=492@02R@00`0T900Q9003A2@T008T00=492@03R@3A0HT
0T@5909422@00d@T9002A0`T1D@01BA4A4@T00a40VP6A004J4AXJ054000GA00494@TA0<T6d@00bA4
A004A00394A400940R@<A00394A400m400<TA4@0?4@00bA4A008A00394A400=41b@01D@TA2A400<T
4T@00bA4A002A00394@T00@T14@012A492@2A0/T00A492A422@014@T92@3A00394@T00940R@00d@T
A00390A40b@00d@TA003A00394A400A40R@014@T94@890=42B@00d@T900390=400HTA4A494@49003
A2@T00PT00=494@00R@014@TA4@290M40b@00d@T900490=400<TA2@00b@01D@T92A400<T0d@49005
A2@T94@03b@00d@T9002A0HT00=492@00R@2A2LT0T@M90942R@2A00494@TA40T0T@F9003A2A400DT
00=492@00R@00d@T900590941B@2A0LT00=494@00T@79003A2@T00@T00=492@01R@014@TA4@59003
A2@T00@T00=494@00T@00bA4A006A08T14@01BA4A4AX00]4000NA00394A401U400@TA4@T0T@00bA4
A005A00494A4A0<T7T@290a400=XA4@00d@00fQ4A00@A00394@T00i400<TA4@01D@00bA49005A0DT
00A494@T0T@2909400<TA4@00T@29003A2@T00=400HTA2@TA2@6A08T0d@29003A2A400E40R@014@T
A4@7909400@TA2A412@00d@T9002A08T14@012A4A4@39006A2@TA2A40R@8A08T00=494@00T@012A4
A2@2A0HT0T@;909400DTA2@TA0029004A2A4A0HT00=492@01R@3A00494@T909400<TA2@014@89003
A2@T00<T1T@290940b@2A00394A400=412@00d@T900:9003A2@T00<T00=492@00T@;909432@00`0T
900T9003A2@T00PT00=492@01R@00d@T900890A400<TA2@05b@00d@T90079003A2@T03DT00=492@0
0R@00d@T900N9003A2@T00PT00=492@02R@2A0HT00=494@01R@00d@T9008A003J4A400940b@?A08T
000EA00394A400a40R@=A00394A4009400<TA2@07D@291A400<TA4@044@00fQ4A00QA08T1T@00bA4
9003A00594@TA2@014@290940R@6A00394@T009400<TA4@00T@012A4A4@290=400@TA4@T0d@012A4
A2@6A08T14@59003A2@T008T1D@00bA4A00290940R@6A0<T14@890A41b@2A00394@T00PT0d@@9094
12@2A00494@TA0HT0T@5909400@TA2@T1d@99003A2@T00@T1D@29004A2@T909400<TA4@014@@9094
2B@2A0XT0d@E9003A2@T00LT00=492@042@2A0TT00=492@00R@00d@T900890940R@4A08T00=492@0
22@3A0@T0T@59003A2@T00PT00=490001R@2A08T0T@@900302@T01@T00A492@T0T@@900502@T94@0
3B@00d@TA00A9005A2@T94@01B@00d@TA0069004A2@T90=400=XA4@00T@00bA4A003A08T00M4J4A4
J4@T00E40R@2A000\
\>"], "Graphics",
  ImageSize->{168.125, 233.375},
  ImageMargins->{{78, 0}, {0, 1.625}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Sophus Lie: Derived from a painting by Erik Werenskiold (Engel and \
Heegaard Vol. 2 [1912]).\
\>", "SmallText",
  PageBreakBelow->True],

Cell[TextData[
"Marius Sophus Lie, a Norwegian mathematician who made significant \
contributions to the theories of algebraic invariants and differential \
equations, was the youngest of six children of a Lutheran pastor, Johann \
Herman Lie. His mother came from a well-known Trondheim family. Lie first \
attended school in Moss (Kristianiaford); then, from 1857 to 1859, he \
attended Nissen's Private Latin School in Christiania. Lie mastered the \
classes without any difficulties. He studied at Christiania University from \
1859 to 1865, mainly mathematics and sciences. During his studies at \
Christiania, he had no preference for mathematics. Although mathematics was \
taught by Bjerknes and Sylow, Lie was not very impressed. After his \
examination in 1865, he gave private lessons, became somewhat interested in \
astronomy, and tried to learn mechanics; but he could not decide what to do. \
Lie himself said that the road to mathematics for him was long and difficult. \
The situation changed when, in 1868, he hit upon Poncelet's and Pl\
\[UDoubleDot]cker's writings. Later, he called himself a student of Pl\
\[UDoubleDot]cker, although he had never met him. Pl\[UDoubleDot]cker's \
momentous idea to create new geometries by choosing figures other than points\
\[LongDash]in fact, straight lines\[LongDash]as elements of space pervaded \
all of Lie\[CloseCurlyQuote]s work."], "Text",
  CellTags->{"algebraic invariants", "differential equations"}],

Cell[TextData[
"Lie\[CloseCurlyQuote]s first publication brought him a scholarship for \
studying abroad. In 1869, Lie went to Berlin, where he met Felix Klein, with \
whom he later cooperated in publishing several papers. He spent the winter of \
1869-1870 in Berlin where he met Kummer and Weierstra\[SZ]. In the summer of \
1870, Lie and, later, Klein traveled to Paris via G\[ODoubleDot]ttingen to \
meet Darboux and Jordan. Jordan acquainted Lie and Klein with the notion of a \
group introduced into algebra by Galois in 1832. In 1870, Lie discovered \
contact transformations. Using these transformations, a one-to-one \
correspondence could be established between lines and spheres in a way that \
tangent spheres correspond to intersecting lines. He also became familiar \
with Monge\[CloseCurlyQuote]s theory of differential equations. At the \
outbreak of the Franco-Prussian war in July of 1870, Klein left Paris; Lie, a \
Norwegian, stayed. In August, he decided to hike to Italy, but on his way he \
was arrested as a German spy near Fontainebleau. His mathematical notes were \
suspected to be military secrets in code\[LongDash]a letter from Klein seemed \
suspicious. After being locked in prison for a month, he was freed through \
Darboux's intervention. Just before the Germans blockaded Paris, he escaped \
to Italy. From there, he returned to Germany, where he again met Klein in D\
\[UDoubleDot]sseldorf."], "Text",
  CellTags->{
  "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
    "Darboux", "Jordan", "Galois", "Franco-Prussian war", "Fontainebleau"}],

Cell["\<\
In 1871, he became an assistant tutor at the University of Cristiania (Oslo). \
In the same year, he submitted for his doctor\[CloseCurlyQuote]s degree a \
memoir in which he advanced the theory of tangential transformations. During \
the period 1871\[Dash]1872, he developed the integration theory of partial \
differential equations, now found in many textbooks, although rarely under \
his name. Appointed extraordinary professor on 1 July 1872, he began his \
researches on continuous transformation groups in 1873. In 1874, Lie married \
Anna Birch from Tvedestrand. They had two daughters and a son. The marriage \
was very happy, and Lie was very fond of his family. In 1873, Lie turned from \
the invariants of contact transformations to the principles of the theory of \
transformation groups. Together with Sylow, he assumed the editorship of \
Niels Abel's work.\
\>", "Text",
  CellTags->{"Oslo", "Anna Birch", "Abel"}],

Cell[TextData[{
  "Lie was quite isolated in Christiania at that time. He had no students who \
were interested in his research. He was disappointed that his works did not \
receive more attention abroad. Except for Klein, Mayer, and later, Picard, \
nobody paid attention to his work. Lie\[CloseCurlyQuote]s results on the \
integration theory of partial differential equations were found by Adolph \
Mayer at that time, with whom he had conducted a lively correspondence. In a \
letter to Mayer he writes, \[OpenCurlyDoubleQuote]If I only knew how to get \
the mathematicians interested in transformation groups and their applications \
to differential equations. I am certain, absolutely certain in my case, that \
in the future these theories will be recognized as fundamental. I want to \
form thus an impression now, since for one thing, I could then achieve ten \
times as much.\[CloseCurlyDoubleQuote] His main interest turned to \
transformation groups, his most celebrated creation; although in 1876, he \
returned to differential geometry. In the same year, he joined G.O. Sars and \
Worm M\[UDoubleDot]ller in founding the ",
  StyleBox["Archiv f\[ODoubleDot]r mathematik og naturvidenskab",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Mayer", "Picard"}],

Cell[TextData[{
  "In 1884, Klein and Mayer induced Engel, who had just received his Ph.D., \
to visit Lie in order to learn about transformation groups and to help him \
write a comprehensive book on the subject. Engel stayed 9 months with Lie. \
Thanks to Engel\[CloseCurlyQuote]s activity, the work was accomplished, its \
three parts being published between 1888 and 1893. Engel and Lie developed a \
warm and lifelong friendship. Engel helped Lie by giving his rather intuitive \
geometrical ideas a more precise mathematical form. Lie often felt it a \
burden to prepare his ideas for publication. After 9 years of collaboration \
with Engel, Lie published ",
  StyleBox[ButtonBox["Theorie der Transformationsgruppen",
    ButtonData:>{"Literat.nb", "Lie-88"},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  ButtonBox[",",
    ButtonData:>{"Literat.nb", "Lie-88"},
    ButtonStyle->"Hyperlink"],
  " 3 vols. (1893). This work contains the results of his investigations of \
the general theory of finite continuous groups of transformations. It was \
followed by ",
  StyleBox["Geometrie der Ber\[UDoubleDot]hrungstransformationen",
    FontSlant->"Italic"],
  " (1896). "
}], "Text",
  CellTags->"Engel"],

Cell[TextData[
"In 1886, he succeeded Klein on the chair of mathematics at the University of \
Leipzig, with Engel as his assistant. At Leipzig, he found interested \
students, among them Scheffers, Zorawski, and Kowalewski. With Scheffers, Lie \
published textbooks on transformation groups and on differential equations, \
and a fragmentary geometry of contact transformations. Afterward, his student \
Kowalewski, wrote many books about Lie\[CloseCurlyQuote]s work. At this time, \
it was quite unusual for young French mathematicians to go to Germany for \
studying. But the Ecole Normale Sup\[EAcute]rieure in Paris sent some of \
their best students to Lie; and he was very proud of this. Lie did not plan \
to stay in Leipzig forever; he had in mind a period of 6 to 8 years. So he \
did not resign from his professorship in Christiania, but was granted an \
extraordinary leave of absence. Life in Leipzig was not that easy for Lie. \
His teaching duties were much heavier than at home, the language caused him \
some problems, and he became tired of supervising weak and dependent graduate \
students. As time passed, he also ran into trouble with some of his \
colleagues. In the last years of his life, Lie turned to foundations of \
geometry, which at that time meant the Helmholtz space problem."], "Text",
  CellTags->{
  "Zorawski", "Scheffers", "Ecole Normale Sup\[EAcute]rieure", "Kowalewski", 
    "Leipzig"}],

Cell["\<\
In 1898, he returned to Cristiania to accept a special chair of \
mathematics created for him, but his health was already broken. Lie, who was \
described as on open-hearted man of gigantic stature and excellent physical \
health, was struck by what was then called neurasthenia. This was the result \
of his rushing work and the overload of mental action. Treatment in a mental \
hospital led to his recovery, and in 1890, he could resume his work. His \
character, however, had changed greatly. He became increasingly sensitive, \
irascible, suspicious, and misanthropic, despite the many tokens of \
recognition that were heaped upon him. He died of pernicious anemia in \
February 1899. His papers were edited, with excellent annotations, by Engel \
and Heegaard.\
\>", "Text"],

Cell[TextData[{
  "An analysis of Lie\[CloseCurlyQuote]s work is given in the ",
  StyleBox[ButtonBox["Bibliotheca Mathematica",
    ButtonData:>{"Literat.nb", "collect-Lie"},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  " (1900). His collected works are contained in ",
  StyleBox["Gesammelte Abhandlungen",
    FontSlant->"Italic"],
  ", 7 vols (1922\[Dash]37). Two other standard works are his ",
  StyleBox["Differentialgleichungen ",
    FontSlant->"Italic"],
  "(1891) and ",
  StyleBox[" Vorlesungen \[UDoubleDot]ber continuierliche Gruppen",
    FontSlant->"Italic"],
  " (1893)."
}], "Text"],

Cell[TextData[
"In 1890, Lie himself wrote on his work in a letter to his friend Motzfeldt, \
\[OpenCurlyDoubleQuote]\[Ellipsis]my life\[CloseCurlyQuote]s work will stand \
through all times and, in the years to come, be more and more appreciated\
\[LongDash]no doubt about it.\[CloseCurlyDoubleQuote] It seems he was \
absolutely right!"], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"KeySymbols.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{693, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->483,
PrintingPageRange->{464, 464},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Appendix", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Appendix", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Marius Sophus Lie: a mathematicians life"->{
    Cell[2373, 65, 479, 9, 52, "Section",
      CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Marius Sophus Lie: a mathematicians life"]},
  "algebraic invariants"->{
    Cell[789895, 9805, 1468, 20, 306, "Text",
      CellTags->{"algebraic invariants", "differential equations"}]},
  "differential equations"->{
    Cell[789895, 9805, 1468, 20, 306, "Text",
      CellTags->{"algebraic invariants", "differential equations"}]},
  "Klein"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Berlin"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Kummer"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Weierstra\[SZ]"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "G\[ODoubleDot]ttingen"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Darboux"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Jordan"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Galois"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Franco-Prussian war"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Fontainebleau"->{
    Cell[791366, 9827, 1603, 22, 327, "Text",
      CellTags->{
      "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
        "Darboux", "Jordan", "Galois", "Franco-Prussian war", 
        "Fontainebleau"}]},
  "Oslo"->{
    Cell[792972, 9851, 941, 14, 201, "Text",
      CellTags->{"Oslo", "Anna Birch", "Abel"}]},
  "Anna Birch"->{
    Cell[792972, 9851, 941, 14, 201, "Text",
      CellTags->{"Oslo", "Anna Birch", "Abel"}]},
  "Abel"->{
    Cell[792972, 9851, 941, 14, 201, "Text",
      CellTags->{"Oslo", "Anna Birch", "Abel"}]},
  "Mayer"->{
    Cell[793916, 9867, 1280, 20, 264, "Text",
      CellTags->{"Mayer", "Picard"}]},
  "Picard"->{
    Cell[793916, 9867, 1280, 20, 264, "Text",
      CellTags->{"Mayer", "Picard"}]},
  "Engel"->{
    Cell[795199, 9889, 1222, 24, 222, "Text",
      CellTags->"Engel"]},
  "Zorawski"->{
    Cell[796424, 9915, 1427, 20, 306, "Text",
      CellTags->{
      "Zorawski", "Scheffers", "Ecole Normale Sup\[EAcute]rieure", 
        "Kowalewski", "Leipzig"}]},
  "Scheffers"->{
    Cell[796424, 9915, 1427, 20, 306, "Text",
      CellTags->{
      "Zorawski", "Scheffers", "Ecole Normale Sup\[EAcute]rieure", 
        "Kowalewski", "Leipzig"}]},
  "Ecole Normale Sup\[EAcute]rieure"->{
    Cell[796424, 9915, 1427, 20, 306, "Text",
      CellTags->{
      "Zorawski", "Scheffers", "Ecole Normale Sup\[EAcute]rieure", 
        "Kowalewski", "Leipzig"}]},
  "Kowalewski"->{
    Cell[796424, 9915, 1427, 20, 306, "Text",
      CellTags->{
      "Zorawski", "Scheffers", "Ecole Normale Sup\[EAcute]rieure", 
        "Kowalewski", "Leipzig"}]},
  "Leipzig"->{
    Cell[796424, 9915, 1427, 20, 306, "Text",
      CellTags->{
      "Zorawski", "Scheffers", "Ecole Normale Sup\[EAcute]rieure", 
        "Kowalewski", "Leipzig"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Marius Sophus Lie: a mathematicians life", 801186, 10021},
  {"algebraic invariants", 801557, 10028},
  {"differential equations", 801703, 10031},
  {"Klein", 801832, 10034},
  {"Berlin", 802080, 10040},
  {"Kummer", 802328, 10046},
  {"Weierstra\[SZ]", 802584, 10052},
  {"G\[ODoubleDot]ttingen", 802847, 10058},
  {"Darboux", 803096, 10064},
  {"Jordan", 803344, 10070},
  {"Galois", 803592, 10076},
  {"Franco-Prussian war", 803853, 10082},
  {"Fontainebleau", 804108, 10088},
  {"Oslo", 804354, 10094},
  {"Anna Birch", 804467, 10097},
  {"Abel", 804574, 10100},
  {"Mayer", 804682, 10103},
  {"Picard", 804781, 10106},
  {"Engel", 804879, 10109},
  {"Zorawski", 804968, 10112},
  {"Scheffers", 805153, 10117},
  {"Ecole Normale Sup\[EAcute]rieure", 805361, 10122},
  {"Kowalewski", 805547, 10127},
  {"Leipzig", 805730, 10132}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 303, 4, 117, "ChapterLine",
  CounterAssignments->{{"Title", 10}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],
Cell[2045, 57, 303, 4, 193, "Title",
  CounterAssignments->{{"Title", 10}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2373, 65, 479, 9, 52, "Section",
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Marius Sophus Lie: a mathematicians life"],
Cell[2855, 76, 121, 3, 54, "Text"],
Cell[2979, 81, 786764, 9716, 304, 786659, 9713, "GraphicsData", "Bitmap", \
"Graphics"],
Cell[789746, 9799, 146, 4, 30, "SmallText",
  PageBreakBelow->True],
Cell[789895, 9805, 1468, 20, 306, "Text",
  CellTags->{"algebraic invariants", "differential equations"}],
Cell[791366, 9827, 1603, 22, 327, "Text",
  CellTags->{
  "Klein", "Berlin", "Kummer", "Weierstra\[SZ]", "G\[ODoubleDot]ttingen", 
    "Darboux", "Jordan", "Galois", "Franco-Prussian war", "Fontainebleau"}],
Cell[792972, 9851, 941, 14, 201, "Text",
  CellTags->{"Oslo", "Anna Birch", "Abel"}],
Cell[793916, 9867, 1280, 20, 264, "Text",
  CellTags->{"Mayer", "Picard"}],
Cell[795199, 9889, 1222, 24, 222, "Text",
  CellTags->"Engel"],
Cell[796424, 9915, 1427, 20, 306, "Text",
  CellTags->{
  "Zorawski", "Scheffers", "Ecole Normale Sup\[EAcute]rieure", "Kowalewski", 
    "Leipzig"}],
Cell[797854, 9937, 791, 12, 201, "Text"],
Cell[798648, 9951, 614, 16, 96, "Text"],
Cell[799265, 9969, 348, 5, 75, "Text"],
Cell[799616, 9976, 150, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

