(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    136880,       4300]*)
(*NotebookOutlinePosition[    148433,       4588]*)
(*  CellTagsIndexPosition[    146947,       4545]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.10 Molecular Beam Epitaxy", "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 76}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Molecular Beam Epitaxy"],

Cell["\<\
Before discussing a detailed analysis of the growth equations of \
molecular beam epitaxy (MBE), let us describe the main relevant microscopic \
processes taking place on a crystal interface. The morphology of the \
interface is determined by the interplay among deposition, desorption, and \
surface diffusion. The term deposition means the sticking of an atom on the \
surface if it arrives from vapor. Crystals grow by atomic deposition. \
Desorption is the reverse effect, competing with deposition. Under \
desorption, we understand that atoms deposited on the surface leave the \
interface. When an atom is deposited on a surface, it forms bonds that must \
be broken before desorption can occur. If only some of the bonds are broken, \
the atom gains the ability to move on the surface. From a microscopic point \
of view, surface diffusion is an activated process. The discrete positions of \
the atom are determined by the crystal lattice. For an atom on the surface to \
diffuse to the next lattice position, it must overcome the lattice potential \
existing between two neighboring positions. This excess energy required for \
diffusion is the microscopic origin of the lattice potential.\
\>", "Text",
  CellTags->{
  "growth equations of molecular beam epitaxy", "microscopic processes", 
    "crystal interface", "deposition", "desorption", "surface diffusion", 
    "atomic deposition", "bonds", "activated process", "excess energy", 
    "lattice potential"}],

Cell["\<\
The physical mechanism that governs MBE is the surface diffusion of \
the deposited particles. For the moment, we assume that desorption is \
negligible. So we consider the scenario of atoms deposited on a surface, \
whereupon they diffuse. The goal is to find an equation for the form\
\>", 
  "Text",
  CellTags->"surface diffusion"],

Cell[BoxData[
    \(TraditionalForm\`\[PartialD]\_t\ \(a(x, t)\)\  = \ F(a, x, t)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "that describes the variation in the interface amplitude ",
  Cell[BoxData[
      \(TraditionalForm\`a(x, t)\)]],
  ". Diffusion processes are directly connected with a macroscopic current. \
The local changes in the surface height are the result of the currents along \
the surface. Since we neglect desorption, the total number of atoms remains \
unchanged during the diffusion process and the current must obey a continuity \
equation:"
}], "Text",
  CellTags->{
  "interface amplitude", "macroscopic current", "surface", 
    "continuity equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  = \ 
      \(-\ \(div(\(j\&\[RightVector]\)(x, t)) . \)\)\)], "NumberedEquation"],

Cell[TextData[{
  "On the other hand, the surface current is driven by the difference in the \
local chemical potential ",
  Cell[BoxData[
      \(TraditionalForm\`j\&\[RightVector] \[Tilde] \ grad(\[Mu](x, t))\)]],
  ". As we already mentioned, the diffusion is an activated process. The \
motion of an atom depends on the number of bonds that must be broken. The \
more neighbors an atom has, the lower the mobility. A measure of mobility is \
the local radius of curvature ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ". A simple assumption is that the chemical potential is proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)/r\)]],
  ", which, in turn, is proportional to ",
  Cell[BoxData[
      \(TraditionalForm\`div(grad(a(x, t)))\)]],
  ". Hence, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Mu]", "\[Tilde]", 
          RowBox[{"-", 
            RowBox[{
              StyleBox[
                RowBox[{"\[CapitalDelta]", 
                  StyleBox["a",
                    FontSlant->"Italic"]}]], "(", \(x, t\), ")"}]}]}], 
        TraditionalForm]]],
  ", where \[CapitalDelta] denotes the Laplacian. Combining the arguments \
given, we end up with the equation"
}], "Text",
  CellTags->{
  "surface current", "chemical potential", "activated process", "mobility", 
    "Laplacian"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ 0. \)], "NumberedEquation"],

Cell[TextData[{
  "In MBE experiments, we have, on the other side, a flux ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi] = \[Phi](x, t)\)]],
  " of atoms bombarding the surface. The flux is defined as the number of \
particles arriving on the unit surface in a unit time. At large length \
scales, the beam is homogeneous with an average intensity \[Phi]. Thus, the \
growth equation incorporating surface diffusion and deposition has the form"
}], "Text",
  CellTags->"intensity"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ \(\[Phi] . \)\)], "NumberedEquation"],

Cell[TextData[{
  "The growth equation incorporating statistical fluctuations in the flux was \
originally introduced independently by ",
  ButtonBox["Wolf and Villain [1990]",
    ButtonData:>{"Literat.nb", "Wolf-1990"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Das Sarma and Tamborenea [1991].",
    ButtonData:>{"Literat.nb", "Das Sarma-1991"},
    ButtonStyle->"Hyperlink"],
  " Since we are only interested in the deterministic behavior of the model, \
we suppress the noise in the equations. If we now include the process of \
desorption, we can write down a linear model for MBE. Let us assume with \
Villain that the desorption-dominated growth of the surface is governed by \
the difference between the average chemical potential in the vapor ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&_\)]],
  " and the local chemical potential on the surface ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](x, t)\)]],
  ". Thus, the temporal change in the amplitude ",
  StyleBox["a",
    FontSlant->"Italic"],
  " is given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          RowBox[{"\[Beta]", "(", 
            RowBox[{\(\[Mu](x, t)\), "-", 
              FormBox[\(\[Mu]\&_)\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  ". The complete deterministic model including deposition, desorption, and \
surface diffusion now reads"
}], "Text",
  CellTags->{"desorption", "chemical potential"}],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ \[Phi] + \ \ \[Alpha]\ \ \[Del]\^2\( a(x, t)\)\  + \ 
        \[Beta] \( \[Mu]\&_ . \)\)], "NumberedEquation"],

Cell[TextData[{
  "Apart from the beam flux \[Phi], we incorporated an additional flux \
\[Beta]",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\&_\)]],
  ". Both terms can be abbreviated by ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi] = \[Phi] + \[Beta]  \[Mu]\&_\)]],
  ":"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[PartialD]\_t\( a(x, t)\)\  + \ \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = 
      \ \ \[Alpha]\ \ \[Del]\^2\( a(x, t)\)\  + \ \(\[CapitalPhi] . \)\)], 
  "NumberedEquation"],

Cell[TextData[
"This equation contains all physically relevant linear terms describing the \
growth of interfaces by MBE. The competition between the diffusion and \
desorption processes will determine the growth of the surface. The parameters \
\[Kappa], \[Alpha], and \[CapitalPhi] are assumed to be real and positive."], 
  "Text",
  CellTags->"growth of interfaces"],

Cell[TextData[{
  "Another aspect to be considered in MBE is the influence of non-linearity. \
Non-linearity comes into play if we consider large domains in space. For such \
cases, the small gradients in ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " are not negligible. The corresponding terms of second- and third-order \
non-linearity are incorporated in the growth equation, which now reads"
}], "Text",
  CellTags->{"nonlinearity", "growth equation"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[PartialD]\_t\( a(x, t)\)\  + \ 
        \[Kappa]\ \ \[Del]\^4\( a(x, t)\)\  = \ 
      \[Alpha]\ \ \[Del]\^2\( a(x, t)\)\  + \ \[CapitalPhi]\  + 
        \[Gamma]\ \[Del]\^2\((\[Del]\(a(x, t)\))\)\^2 + \t
        \[Lambda] \[Del]\(\[CenterDot]\((\[Del]\(a(x, t)\))\)\^3\), \)\)], 
  "NumberedEquation",
  TextAlignment->Center,
  TextJustification->0,
  CellTags->"eq-7"],

Cell[TextData[{
  "where we kept terms up to the fourth order in ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x\)]],
  ". To gain some insight into the dynamic of this model, let us first \
examine the symmetries of the one-dimensional version. For this case, \
equation (5.83) reduces to a (1+1)-dimensional expression. The related \
equation for the amplitude"
}], "Text"],

Cell[BoxData[
    \(\(A = a[x, t]; \)\)], "Input"],

Cell[TextData[{
  "reads in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nMBE\  = \ 
      \[PartialD]\_t A + \ \[Kappa]\ \[PartialD]\_{x, 4}A\  - 
          \[Alpha] \[PartialD]\_{x, 2}A\  - \ 
          \[Gamma] \[PartialD]\_{x, 2}\((\[PartialD]\_x A)\)\^2 - 
          \[Lambda]\ \[PartialD]\_x\((\[PartialD]\_x A)\)\^3 - 
          \[CapitalPhi]\  == 0; nMBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[CapitalPhi]\) + a\_t - \[Alpha]\ a\_\(x, x\) - 
                3\ \[Lambda]\ a\_x\%2\ a\_\(x, x\) - 
                \[Gamma]\ \((2\ a\_\(x, x\)\%2 + 2\ a\_x\ a\_\(x, x, x\))\) + 
                \[Kappa]\ a\_\(x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"where \[Kappa], \[Alpha], \[Gamma], \[CapitalPhi], and \[Lambda] are real \
constants. The symmetries for this general non-linear model follow by"], 
  "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inMBE\  = \ 
      Infinitesimals[nMBE, 
        a, {x, t}, {\[Kappa], \[Alpha], \[Lambda], \[Gamma], \[CapitalPhi]}]; 
    inMBE // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1\)},
          {\(\[Xi]\_1 == k2\)},
          {\(\[Xi]\_2 == k3\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], k1], 
        Equal[ 
          Subscript[ \[Xi], 1], k2], 
        Equal[ 
          Subscript[ \[Xi], 2], k3]}]]], "Output"]
}, Open  ]],

Cell["\<\
representing a three-dimensional group containing only \
translations. The reduction of this (1+1)-dimensional model to an ODE follows \
by\
\>", "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ LieReduction[nMBE, {a}, {x, t}, {1, c}, {1}]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - c\ x - \[Zeta]\_1 == 0\)},
          {\(a - x - F\_1 == 0\)},
          {
            \(\(-\[CapitalPhi]\) + F1\_\(\[Zeta]\_1\) - 
                c\^2\ \[Alpha]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                3\ c\^2\ \[Lambda]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                6\ c\^3\ \[Lambda]\ F1\_\(\[Zeta]\_1\)\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                3\ c\^4\ \[Lambda]\ F1\_\[Zeta]\_1\%2\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                2\ c\^4\ \[Gamma]\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\)\%2 + 
                2\ c\^3\ \[Gamma]\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) - 
                2\ c\^4\ \[Gamma]\ F1\_\(\[Zeta]\_1\)\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                c\^4\ \[Kappa]\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
describing a moving wave solution governed by a non-linear \
fourth-order ODE. This reduced equation can be integrated once:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[H]; \n
    intMBE = \[Integral]\((
                red1\[LeftDoubleBracket]3, 1, 1\[RightDoubleBracket])\) 
              \[DifferentialD]zeta1 == C[1] /. {F1 \[Rule] H, 
          zeta1 \[Rule] \[Zeta]}; intMBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(H - \[Zeta]\ \[CapitalPhi] - C[1] - 
                c\^2\ \((\[Alpha] + 3\ \[Lambda])\)\ H\_\[Zeta] + 
                3\ c\^3\ \[Lambda]\ H\_\[Zeta]\%2 - 
                c\^4\ \[Lambda]\ H\_\[Zeta]\%3 - 
                2\ c\^3\ \[Gamma]\ \((\(-1\) + c\ H\_\[Zeta])\)\n\t\ 
                  H\_\(\[Zeta], \[Zeta]\) + 
                c\^4\ \[Kappa]\ H\_\(\[Zeta], \[Zeta], \[Zeta]\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The symmetries of the resulting third-order ODE are", "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infinirMBE = 
      Infinitesimals[intMBE, H, 
        \[Zeta], {\[Alpha], \[Kappa], \[Gamma], \[Lambda], \[CapitalPhi], c, 
          C[1]}, SubstitutionRules 
          \[Rule] {\[PartialD]\_{\[Zeta], 3}H[\[Zeta]]}]; 
    infinirMBE // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1\ \[CapitalPhi]\)},
          {\(\[Xi]\_1 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ k1, \[CapitalPhi]]], 
        Equal[ 
          Subscript[ \[Xi], 1], k1]}]]], "Output"]
}, Open  ]],

Cell["\<\
The result shows that the reduced equation following from the \
general model is not solvable by Lie's method.\
\>", "Text"],

Cell["\<\
In the following, we will discuss two limiting models, including \
surface diffusion in connection with non-linearity and desorption with \
non-linearity. Both models include a term describing deposition.\
\>", "Text"],

Cell[CellGroupData[{

Cell["5.6.10.1 Surface Diffusion with Nonlinearity", "Subsubsection",
  CellTags->"Surface Diffusion with Nonlinearity"],

Cell[TextData[{
  "If we choose in the general model (5.83) ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 0\)]],
  ", we get a model including only surface diffusion and quadratic \
non-linearity in the gradient of ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ". The equation of motion reduces to"
}], "Text",
  CellTags->"surface diffusion"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m8MBE\  = \ nMBE\  /. {\[Alpha] \[Rule] 0, \[Lambda] \[Rule] 0}; 
    m8MBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[CapitalPhi]\) + a\_t - 
                \[Gamma]\ \((2\ a\_\(x, x\)\%2 + 2\ a\_x\ a\_\(x, x, x\))\) + 
                \[Kappa]\ a\_\(x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The symmetry group of this special model", "Text",
  CellTags->"symmetry group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m8infi\  = \ 
      Infinitesimals[m8MBE, a, {x, t}, {\[Kappa], \[Gamma], \[CapitalPhi]}]; 
    m8infi // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == k1 + k4\ t\ \[CapitalPhi]\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k2", "+", 
                StyleBox[\(\(k4\ x\)\/4\),
                  ScriptLevel->0]}]}]},
          {\(\[Xi]\_2 == k3 + k4\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k1, 
            Times[ k4, t, \[CapitalPhi]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k2, 
            Times[ 
              Rational[ 1, 4], k4, x]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k3, 
            Times[ k4, t]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
contains translations and a scaling. Let us examine the scaling \
group\
\>", "Text",
  CellTags->"scaling group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = 
      \({{\(xi[1]\)[x, t, a], \(xi[2]\)[x, t, a]}, {\(phi[1]\)[x, t, a]}} /. 
          m8infi\) /. {k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 1}
          \)], "Input"],

Cell[BoxData[
    \({{x\/4, t}, {t\ \[CapitalPhi]}}\)], "Output"]
}, Open  ]],

Cell["\<\
This kind of infinitesimals reduce the original equation to a \
fourth-order ODE:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ 
      LieReduction[m8MBE, {a}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(t\/x\^4\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(a - t\ \[CapitalPhi] - F\_1 == 0\)},
          {
            \(F1\_\(\[Zeta]\_1\) + 
                840\ \[Kappa]\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1 - 
                1760\ \[Gamma]\ F1\_\[Zeta]\_1\%2\ \[Zeta]\_1\%2 + 
                3120\ \[Kappa]\ \[Zeta]\_1\%2\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                3200\ \[Gamma]\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1\%3\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                512\ \[Gamma]\ \[Zeta]\_1\%4\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1\)\%2 + 
                1920\ \[Kappa]\ \[Zeta]\_1\%3\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) - 
                512\ \[Gamma]\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1\%4\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                256\ \[Kappa]\ \[Zeta]\_1\%4\ 
                  F1\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Interestingly, the resulting ODE does not contain the flux term \
\[CapitalPhi]. This term is completely separated in the similarity \
representation of the solution by ",
  Cell[BoxData[
      \(TraditionalForm\`a = \[CapitalPhi]\ t\  + \(F\_1\)(t/x\^4)\)]],
  ". The unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  " has to satisfy the fourth-order ODE, which cannot be solved symbolically. \
However, we can derive a numerical solution if we add four initial conditions \
to the ODE:"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    "0"}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[DoublePrime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(3/2\)}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", 
                        TagBox[\((3)\),
                          Derivative],
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(-10\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Gamma] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[TextData[{
  "The numerical solution for a fixed value of \[Gamma] and nine different \
values of \[Kappa] follows by applying ",
  StyleBox["NDSolve[]", "MmaText"],
  " to the equations"
}], "Text",
  CellTags->"numerical solution"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq /. \[Kappa] \[Rule] i, F1, {zeta1, 1, 15}], {i,  .2, 
          1,  .1}]; \)\)], "Input"],

Cell["These solutions are plotted below.", "Text"],

Cell[BoxData[
    \(\(color\  = \ Table[RGBColor[i, 0.1, 0.3], {i,  .2, 1,  .1}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 6}, 
      PlotStyle \[Rule] color, 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 -0.764702 1.11405 [
[.21429 .33685 -3 -9 ]
[.21429 .33685 3 0 ]
[.40476 .33685 -3 -9 ]
[.40476 .33685 3 0 ]
[.59524 .33685 -3 -9 ]
[.59524 .33685 3 0 ]
[.78571 .33685 -3 -9 ]
[.78571 .33685 3 0 ]
[.97619 .33685 -3 -9 ]
[.97619 .33685 3 0 ]
[1.025 .34935 0 -7.5 ]
[1.025 .34935 10 7.5 ]
[.01131 .01513 -18 -4.5 ]
[.01131 .01513 0 4.5 ]
[.01131 .12654 -18 -4.5 ]
[.01131 .12654 0 4.5 ]
[.01131 .23794 -18 -4.5 ]
[.01131 .23794 0 4.5 ]
[.01131 .46075 -18 -4.5 ]
[.01131 .46075 0 4.5 ]
[.01131 .57216 -18 -4.5 ]
[.01131 .57216 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.21429 .34935 m
.21429 .3556 L
s
[(2)] .21429 .33685 0 1 Mshowa
.40476 .34935 m
.40476 .3556 L
s
[(3)] .40476 .33685 0 1 Mshowa
.59524 .34935 m
.59524 .3556 L
s
[(4)] .59524 .33685 0 1 Mshowa
.78571 .34935 m
.78571 .3556 L
s
[(5)] .78571 .33685 0 1 Mshowa
.97619 .34935 m
.97619 .3556 L
s
[(6)] .97619 .33685 0 1 Mshowa
.125 Mabswid
.0619 .34935 m
.0619 .3531 L
s
.1 .34935 m
.1 .3531 L
s
.1381 .34935 m
.1381 .3531 L
s
.17619 .34935 m
.17619 .3531 L
s
.25238 .34935 m
.25238 .3531 L
s
.29048 .34935 m
.29048 .3531 L
s
.32857 .34935 m
.32857 .3531 L
s
.36667 .34935 m
.36667 .3531 L
s
.44286 .34935 m
.44286 .3531 L
s
.48095 .34935 m
.48095 .3531 L
s
.51905 .34935 m
.51905 .3531 L
s
.55714 .34935 m
.55714 .3531 L
s
.63333 .34935 m
.63333 .3531 L
s
.67143 .34935 m
.67143 .3531 L
s
.70952 .34935 m
.70952 .3531 L
s
.74762 .34935 m
.74762 .3531 L
s
.82381 .34935 m
.82381 .3531 L
s
.8619 .34935 m
.8619 .3531 L
s
.9 .34935 m
.9 .3531 L
s
.9381 .34935 m
.9381 .3531 L
s
.25 Mabswid
0 .34935 m
1 .34935 L
s
gsave
1.025 .34935 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .01513 m
.03006 .01513 L
s
[(0.7)] .01131 .01513 1 0 Mshowa
.02381 .12654 m
.03006 .12654 L
s
[(0.8)] .01131 .12654 1 0 Mshowa
.02381 .23794 m
.03006 .23794 L
s
[(0.9)] .01131 .23794 1 0 Mshowa
.02381 .46075 m
.03006 .46075 L
s
[(1.1)] .01131 .46075 1 0 Mshowa
.02381 .57216 m
.03006 .57216 L
s
[(1.2)] .01131 .57216 1 0 Mshowa
.125 Mabswid
.02381 .03741 m
.02756 .03741 L
s
.02381 .0597 m
.02756 .0597 L
s
.02381 .08198 m
.02756 .08198 L
s
.02381 .10426 m
.02756 .10426 L
s
.02381 .14882 m
.02756 .14882 L
s
.02381 .1711 m
.02756 .1711 L
s
.02381 .19338 m
.02756 .19338 L
s
.02381 .21566 m
.02756 .21566 L
s
.02381 .26022 m
.02756 .26022 L
s
.02381 .28251 m
.02756 .28251 L
s
.02381 .30479 m
.02756 .30479 L
s
.02381 .32707 m
.02756 .32707 L
s
.02381 .37163 m
.02756 .37163 L
s
.02381 .39391 m
.02756 .39391 L
s
.02381 .41619 m
.02756 .41619 L
s
.02381 .43847 m
.02756 .43847 L
s
.02381 .48303 m
.02756 .48303 L
s
.02381 .50532 m
.02756 .50532 L
s
.02381 .5276 m
.02756 .5276 L
s
.02381 .54988 m
.02756 .54988 L
s
.02381 .59444 m
.02756 .59444 L
s
.02381 .61672 m
.02756 .61672 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 .1 .3 r
.5 Mabswid
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35103 L
.0379 .35326 L
.04262 .356 L
.05224 .36319 L
.06244 .37263 L
.10458 .42185 L
.14241 .46949 L
.1827 .5161 L
.22147 .55315 L
.24118 .56832 L
.2627 .5818 L
.27267 .58692 L
.28329 .5916 L
.29325 .59525 L
.30241 .59799 L
.31269 .60038 L
.3181 .60134 L
.32382 .60215 L
.32879 .60268 L
.33118 .60287 L
.33343 .60303 L
.33471 .6031 L
.3361 .60317 L
.33725 .60321 L
.33853 .60325 L
.3399 .60329 L
.34066 .6033 L
.34137 .60331 L
.34263 .60332 L
.34334 .60332 L
.34399 .60332 L
.34527 .60331 L
.34647 .60329 L
.34756 .60326 L
.34873 .60323 L
.35136 .60312 L
.35379 .60298 L
.35822 .60265 L
.36291 .60217 L
.37277 .60078 L
.38361 .59867 L
.40306 .59348 L
.42395 .58612 L
.46523 .56723 L
Mistroke
.50499 .54506 L
.54324 .52136 L
.58393 .49465 L
.62312 .4682 L
.66475 .43987 L
.70487 .4127 L
.74347 .38691 L
.78453 .35999 L
.82407 .33466 L
.86209 .31088 L
.90257 .28622 L
.94153 .26313 L
.97619 .24312 L
Mfstroke
.3 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35326 L
.04262 .35598 L
.05224 .36309 L
.06244 .37234 L
.10458 .41872 L
.14241 .45991 L
.16345 .47973 L
.1827 .49524 L
.20281 .50849 L
.22147 .51797 L
.23143 .52191 L
.24046 .52481 L
.25049 .52731 L
.256 .52836 L
.26118 .52914 L
.26584 .52968 L
.26848 .52991 L
.27095 .53009 L
.27228 .53016 L
.27355 .53023 L
.2747 .53027 L
.27592 .53031 L
.27656 .53033 L
.27725 .53034 L
.27848 .53036 L
.27917 .53036 L
.27991 .53037 L
.28062 .53037 L
.28126 .53036 L
.28234 .53035 L
.28349 .53033 L
.28457 .5303 L
.28556 .53026 L
.28798 .53015 L
.29026 .53001 L
.29481 .52964 L
.29973 .52908 L
.3092 .5276 L
.31961 .52535 L
.34065 .51902 L
.3601 .51125 L
.38099 .50113 L
.42227 .47675 L
Mistroke
.46203 .44922 L
.50027 .42026 L
.54097 .38782 L
.58015 .35575 L
.62179 .32135 L
.66191 .2883 L
.70051 .25683 L
.74157 .22392 L
.78111 .19285 L
.81913 .16364 L
.85961 .1333 L
.89857 .10483 L
.93998 .07538 L
.97619 .0503 L
Mfstroke
.4 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35596 L
.05224 .36304 L
.06244 .3722 L
.10458 .4173 L
.14241 .4559 L
.16345 .47377 L
.1827 .48729 L
.20258 .4982 L
.22147 .50566 L
.23106 .50838 L
.23632 .50957 L
.24128 .5105 L
.24591 .5112 L
.24835 .51151 L
.25092 .51178 L
.25309 .51198 L
.25548 .51216 L
.25764 .51228 L
.25967 .51237 L
.26093 .51241 L
.26162 .51242 L
.26227 .51243 L
.26341 .51245 L
.26467 .51246 L
.26534 .51246 L
.26604 .51245 L
.26729 .51243 L
.26799 .51242 L
.26864 .5124 L
.27012 .51236 L
.27141 .5123 L
.27263 .51224 L
.27491 .51211 L
.28002 .51167 L
.28465 .51113 L
.28892 .51051 L
.29858 .50869 L
.30827 .50632 L
.31734 .50362 L
.33798 .49588 L
.3768 .47613 L
.41808 .44928 L
Mistroke
.45784 .4193 L
.49609 .38785 L
.53678 .35258 L
.57596 .3176 L
.6176 .27994 L
.65772 .24358 L
.69632 .20884 L
.73738 .17234 L
.77692 .13777 L
.81494 .10516 L
.85542 .07119 L
.89438 .03924 L
.93579 .0061 L
Mfstroke
.93579 .0061 m
.94361 0 L
s
.5 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35596 L
.06244 .37211 L
.10458 .41649 L
.14393 .45501 L
.16369 .47073 L
.18177 .48252 L
.20117 .4923 L
.21188 .49641 L
.22205 .49949 L
.23164 .50165 L
.237 .50255 L
.24186 .50319 L
.24641 .50362 L
.24897 .50381 L
.25019 .50387 L
.25133 .50393 L
.25241 .50397 L
.25339 .50401 L
.25449 .50403 L
.25566 .50406 L
.25679 .50407 L
.25802 .50407 L
.25917 .50406 L
.26025 .50405 L
.26142 .50402 L
.26266 .50398 L
.26488 .50389 L
.26726 .50375 L
.26987 .50356 L
.27455 .5031 L
.27891 .50254 L
.28887 .50082 L
.29951 .49832 L
.32086 .49138 L
.34101 .48268 L
.37948 .4612 L
.4204 .43272 L
.4598 .40127 L
.49769 .36841 L
.53803 .33152 L
.57685 .29487 L
.61813 .25526 L
Mistroke
.65789 .21692 L
.69613 .18015 L
.73683 .14138 L
.77601 .10454 L
.81765 .06607 L
.85776 .02972 L
Mfstroke
.85776 .02972 m
.89125 0 L
s
.6 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37206 L
.10458 .41597 L
.14393 .45357 L
.16369 .46871 L
.18177 .47993 L
.20117 .48909 L
.21188 .49285 L
.22205 .4956 L
.23164 .49747 L
.237 .49821 L
.23953 .49848 L
.24186 .4987 L
.24403 .49886 L
.24641 .499 L
.24756 .49905 L
.2488 .4991 L
.25011 .49913 L
.25133 .49916 L
.25247 .49917 L
.25372 .49917 L
.2549 .49917 L
.25599 .49915 L
.25697 .49913 L
.25805 .4991 L
.26025 .49902 L
.26259 .49889 L
.26516 .4987 L
.27034 .4982 L
.27513 .49758 L
.27959 .49688 L
.28968 .49482 L
.30045 .49196 L
.3218 .48438 L
.34195 .47512 L
.38041 .4526 L
.42133 .42302 L
.46074 .39045 L
.49862 .35641 L
.53896 .31814 L
.57779 .28003 L
.61906 .23873 L
Mistroke
.65882 .19863 L
.69707 .16006 L
.73777 .11928 L
.77695 .08044 L
.81858 .03977 L
.8587 .00125 L
Mfstroke
.8587 .00125 m
.86003 0 L
s
.7 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37202 L
.10458 .4156 L
.14393 .45258 L
.16369 .46732 L
.18177 .47816 L
.20117 .48691 L
.21188 .49045 L
.21721 .49188 L
.22205 .49298 L
.22666 .49387 L
.23164 .49465 L
.23438 .495 L
.2369 .49528 L
.23947 .49551 L
.24186 .49568 L
.24392 .49579 L
.24497 .49584 L
.24612 .49588 L
.24738 .49592 L
.24857 .49594 L
.24973 .49595 L
.2508 .49596 L
.25192 .49595 L
.25298 .49594 L
.25413 .49592 L
.25538 .49588 L
.25662 .49584 L
.25792 .49578 L
.26025 .49565 L
.26282 .49546 L
.26525 .49524 L
.26979 .49472 L
.27999 .49308 L
.2888 .49115 L
.29835 .48853 L
.31823 .48145 L
.33927 .47176 L
.37716 .44943 L
.4175 .42003 L
.45632 .38756 L
.4976 .34976 L
Mistroke
.53736 .3111 L
.57561 .27252 L
.6163 .23055 L
.65549 .18968 L
.69712 .14614 L
.73724 .10434 L
.77584 .06445 L
.8169 .02254 L
Mfstroke
.8169 .02254 m
.83931 0 L
s
.8 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37199 L
.10458 .41533 L
.14393 .45185 L
.16369 .46631 L
.18177 .47688 L
.20117 .48533 L
.21188 .48871 L
.21721 .49006 L
.22205 .4911 L
.22666 .49192 L
.23164 .49263 L
.23438 .49294 L
.2369 .49318 L
.23947 .49337 L
.24186 .49351 L
.24392 .4936 L
.24507 .49363 L
.24612 .49366 L
.24727 .49367 L
.24852 .49368 L
.24971 .49368 L
.2508 .49367 L
.25192 .49365 L
.25298 .49362 L
.25413 .49358 L
.25538 .49353 L
.25792 .49339 L
.26025 .49323 L
.26499 .49279 L
.27005 .49215 L
.27917 .49058 L
.29002 .48806 L
.29987 .48516 L
.31906 .47799 L
.33985 .46811 L
.38077 .44318 L
.42017 .41358 L
.45806 .38116 L
.4984 .34345 L
.53723 .30492 L
.5785 .26231 L
Mistroke
.61826 .22025 L
.65651 .17928 L
.69721 .13548 L
.73639 .09337 L
.77802 .04893 L
.81814 .00655 L
Mfstroke
.81814 .00655 m
.82442 0 L
s
.9 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35595 L
.06244 .37197 L
.10458 .41513 L
.14393 .45129 L
.16369 .46554 L
.18177 .47591 L
.20117 .48414 L
.21188 .4874 L
.21721 .48869 L
.22205 .48967 L
.22666 .49044 L
.23164 .4911 L
.23438 .49138 L
.2369 .49159 L
.23931 .49175 L
.24064 .49182 L
.24186 .49188 L
.24291 .49191 L
.24405 .49194 L
.24525 .49197 L
.24639 .49198 L
.24746 .49198 L
.24859 .49198 L
.24956 .49197 L
.25062 .49195 L
.25187 .49191 L
.25301 .49187 L
.25559 .49175 L
.25786 .49161 L
.26025 .49141 L
.26525 .49089 L
.26979 .49028 L
.27999 .48841 L
.28944 .48612 L
.29835 .48347 L
.31837 .47593 L
.33682 .46717 L
.37622 .44343 L
.41411 .41524 L
.45445 .38074 L
.49328 .34423 L
.53455 .30282 L
Mistroke
.57431 .26117 L
.61256 .22002 L
.65326 .17553 L
.69244 .13238 L
.73407 .08649 L
.77419 .04248 L
.81279 .00047 L
Mfstroke
.81279 .00047 m
.81323 0 L
s
1 .1 .3 r
.02381 .34935 m
.02499 .34938 L
.02605 .34946 L
.02729 .34962 L
.02846 .34982 L
.03053 .35031 L
.03279 .35102 L
.0379 .35325 L
.04262 .35594 L
.06244 .37195 L
.10458 .41496 L
.1249 .43463 L
.14393 .45086 L
.16333 .46471 L
.18177 .47515 L
.19145 .47954 L
.20201 .48348 L
.21162 .4863 L
.22054 .48828 L
.22561 .48914 L
.22828 .48951 L
.2311 .48985 L
.23358 .4901 L
.23629 .49032 L
.23876 .49047 L
.24106 .49057 L
.24222 .49061 L
.24347 .49064 L
.24466 .49066 L
.24576 .49067 L
.24674 .49067 L
.24783 .49066 L
.24897 .49064 L
.25004 .49062 L
.25122 .49058 L
.25246 .49054 L
.25467 .49043 L
.25706 .49027 L
.25967 .49005 L
.26495 .48948 L
.26994 .48876 L
.27928 .48701 L
.28933 .48452 L
.30023 .48116 L
.3201 .47335 L
.34115 .46292 L
.37903 .43927 L
.41937 .40842 L
.4582 .37444 L
.49947 .3348 L
Mistroke
.53924 .29411 L
.57748 .25333 L
.61818 .20873 L
.65736 .16508 L
.69899 .11832 L
.73911 .07319 L
.77772 .02991 L
Mfstroke
.77772 .02991 m
.80459 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{240, 157.125},
  ImageMargins->{{47.1875, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000a1000`40O003h00Oogoo;Goo003oOol]
Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`0010001Goo0P001goo00<007ooOol017oo
00<007ooOol0bGoo00=lBGooL4T00Woo00ETBGooOomooeA900Aoo`03B4Uoogoo00Eoo`03?4Uoogoo
00]oo`03<4Uoogoo021oo`0017oo00<007ooOol00Woo0P001goo00<007ooOol017oo00<007ooOol0
b7oo00AlBGooL4Uoo`9TB@=oo`03E4Uoogoo009oo`03B4Uoogoo00Eoo`03?4Uoogoo00Yoo`8`BB=o
o`0017oo00<007ooOol02goo00<007ooOol017oo00<007ooOol0agoo00ElBGooL4UoofA900Aoo`03
E4Uoogoo009oo`03B4Uoogoo00Aoo`8lB@aoo`03<4Uoogoo02=oo`0017oo00<007ooOol037oo00<0
07ooOol00goo0`00aWoo00ElBGooL4UoofA900=oo`9DB@Aoo`03B4Uoogoo00Aoo`03?4Uoogoo00Yo
o`8`BBIoo`0017oo00<007ooOol037oo00<007ooOol00goo00<007ooOol0aGoo00ElBGooL4UoofA9
00=oo`03E4Uoogoo00=oo`03B4Uoogoo00Aoo`03?4Uoogoo00Yoo`03<4Uoogoo02Ioo`0017oo00<0
07ooOol03Goo00<007ooOol00Woo00<007ooOol0a7oo00ElBGooL4UoofA900=oo`03E4Uoogoo009o
o`98B@Eoo`8lB@aoo`03<4Uoogoo02Moo`0017oo00<007ooOol027oo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol0`goo00ElBGooOom`BFA900=oo`03E4Uoogoo009oo`03B4Uoogoo00Aoo`03
?4Uoogoo00]oo`03<4Uoogoo02Qoo`0010002goo1P0017oo00<007ooOol0`Woo00IlBGooOom`BGoo
I4T2Ool00eA9Oomoo`02Ool00dQ9Oomoo`04Ool00ca9Oomoo`0;Ool00c19Oomoo`0YOol001Uoo`03
001oogoo0<5oo`06O4UoogooL4UoofA90Woo00=DBGooOol00Woo00=8BGooOol017oo00<lBGooOol0
2Woo0S19;7oo000IOol20031Ool01Wa9Oomoog19OomTB@9oo`03E4Uoogoo009oo`03B4Uoogoo00Ao
o`03?4Uoogoo00Yoo`03<4Uoogoo02aoo`006Goo00<007ooOol0_goo00IlBGooOom`BGooI4T2Ool0
0eA9Oomoo`02Ool00dQ9Oomoo`04Ool00ca9Oomoo`0:Ool00c19Oomoo`0]Ool001Uoo`03001oogoo
0;moo`05O4Uoog19OomTB@02Ool00eA9Oomoo`02Ool00dQ9Oomoo`04Ool00ca9Oomoo`0:Ool00c19
Oomoo`0^Ool001Uoo`03001oogoo0;ioo`05O4Uoog19OomTB@02Ool00eA9Oomoo`02Ool00dQ9Oomo
o`04Ool00ca9Oomoo`09Ool2<4TaOol001Uoo`03001oogoo0;eoo`05O4Uoog19OomTB@02Ool00eA9
Oomoo`02Ool00dQ9Oomoo`04Ool00ca9Oomoo`09Ool00c19Oomoo`0FOol00bA9Oomoo`0HOol001Uo
o`03001oogoo0;aoo`05O4Uoog19OomTB@02Ool00eA9Oomoo`02Ool00dQ9Oomoo`04Ool00ca9Oomo
o`09Ool00c19Oomoo`0EOol294TKOol001Uoo`800;aoo`05O4Uoog19OomTB@02Ool015A9Oomoogoo
0TQ91Woo00<lBGooOol02Goo00<`BGooOol05Goo00<TBGooOol06goo000IOol00`00Oomoo`2jOol0
1Ga9Oom`BGooI4T00Woo00EDBGooOomoodQ900Moo`03?4Uoogoo00Qoo`8`BAIoo`8TBAioo`006Goo
00<007ooOol0^Woo00AlBG19OomTB@9oo`05E4UoogooOom8B@07Ool00ca9Oomoo`08Ool00c19Oomo
o`0EOol00bA9Oomoo`0NOol001Uoo`03001oogoo0;Uoo`04O4U`BGooI4T2Ool01EA9OomoogooB4T0
1goo00<lBGooOol027oo00<`BGooOol057oo0RA98Goo000IOol00`00Oomoo`2hOol01ga9L4Uoogoo
I4UooeA900=oo`03B4Uoogoo00Eoo`03?4Uoogoo00Qoo`03<4Uoogoo01Aoo`0394Uoogoo025oo`00
6Goo00<007ooOol0]goo00MlBG19OomoofA9OomDB@03Ool00dQ9Oomoo`05Ool00ca9Oomoo`07Ool2
<4TEOol294TTOol001Uoo`800;Moo`07O4U`BGooOomTBGooE4T00goo00=8BGooOol01Goo00<lBGoo
Ool01goo00<`BGooOol057oo00<TBGooOol097oo000IOol00`00Oomoo`2eOol01Ga9L4UoogooI4T0
0Woo00ADBGooOom8B@Ioo`8lB@Uoo`03<4Uoogoo01Aoo`0394Uoogoo02Eoo`006Goo00<007ooOol0
]7oo00ElBG19OomoofA9009oo`04E4UoogooB4T6Ool00ca9Oomoo`08Ool00c19Oomoo`0COol294TX
Ool001Uoo`03001oogoo0;=oo`05O4U`BGooOomTB@02Ool015A9OomoodQ91Woo00<lBGooOol027oo
00<`BGooOol04goo00<TBGooOol0:7oo000IOol00`00Oomoo`2bOol01Ga9L4UoogooI4T00Woo00AD
BGooOom8B@Ioo`03?4Uoogoo00Moo`8`BAEoo`0394Uoogoo02Uoo`006Goo00<007ooOol0/Goo00El
BG19OomoofA9009oo`05E4UoogooOom8B@05Ool00ca9Oomoo`07Ool00c19Oomoo`0COol294T/Ool0
01Uoo`800;5oo`05O4U`BGooOomTB@02Ool01EA9OomoogooB4T01Goo00<lBGooOol01goo00<`BGoo
Ool04goo00<TBGooOol0;7oo000IOol00`00Oomoo`2_Ool01Ga9L4UoogooI4T00Woo00EDBGooOomo
odQ900Eoo`03?4Uoogoo00Moo`03<4Uoogoo019oo`8TBBmoo`006Goo00<007ooOol0[Woo00ElBGoo
L4UoofA9009oo`05E4UoogooOom8B@05Ool00ca9Oomoo`06Ool2<4TDOol00bA9Oomoo`0_Ool000@0
00Eoo`8000Eoo`@000Eoo`03001oogoo0:eoo`03O4Uoog19009oo`03I4UooeA900=oo`03B4Uoogoo
00=oo`03?4Uoogoo00Ioo`03<4Uoogoo01=oo`0394Uoogoo031oo`0017oo00<007ooOol00Woo0P00
17oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0[7oo00=lBGooL4T00Woo00=TBGooE4T0
0goo00=8BGooOol00goo00<lBGooOol01Woo00<`BGooOol04Woo0RA9<goo0004Ool00`00Oomoo`08
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`2[Ool00ga9Oom`B@02Ool00fA9OomDB@03
Ool00dQ9Oomoo`02Ool2?4T8Ool00c19Oomoo`0BOol00bA9Oomoo`0cOol000Aoo`03001oogoo00Qo
o`03001oogoo009oo`03001oogoo009oo`<00:Yoo`03O4Uoog19009oo`04I4UoogooE4T2Ool00dQ9
Oomoo`02Ool00ca9Oomoo`06Ool2<4TCOol294TfOol000Aoo`03001oogoo00Uoo`@000Eoo`03001o
ogoo0:Yoo`05O4U`BGooOomTB@02Ool015A9OomoodQ917oo00<lBGooOol01Woo00<`BGooOol04Woo
00<TBGooOol0=Woo0004Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`2YOol01Ga9L4UoogooI4T00Woo00ADBGooOom8B@Aoo`03?4Uoogoo00Ioo`03<4Uoogoo015oo`8T
BCUoo`0017oo00<007ooOol027oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Z7oo00El
BG19OomoofA9009oo`04E4UoogooB4T4Ool00ca9Oomoo`06Ool00c19Oomoo`0AOol00bA9Oomoo`0i
Ool000@000aoo`@000Eoo`03001oogoo0:Moo`05O4U`BGooOomTB@02Ool015A9OomoodQ917oo00<l
BGooOol01Woo00<`BGooOol04Goo00<TBGooOol0>Woo000IOol2002WOol01Ga9L4UoogooI4T00Woo
00ADBGooOom8B@Aoo`03?4Uoogoo00Ioo`03<4Uoogoo011oo`8TBCeoo`006Goo00<007ooOol0YGoo
00ElBG19OomoofA9009oo`04E4UoogooB4T4Ool00ca9Oomoo`06Ool00c19Oomoo`0@Ool00bA9Oomo
o`0mOol001Uoo`03001oogoo0:Eoo`04O4U`BGooI4T2Ool015A9OomoodQ917oo00<lBGooOol01Goo
0S194Woo00<TBGooOol0?Woo000IOol00`00Oomoo`2TOol017a9L4UoofA90Woo00ADBGooOom8B@=o
o`8lB@Moo`03<4Uoogoo011oo`8TBD5oo`006Goo00<007ooOol0Xgoo00AlBG19OomTB@9oo`04E4Uo
ogooB4T3Ool00ca9Oomoo`06Ool00c19Oomoo`0@Ool00bA9Oomoo`11Ool001Uoo`03001oogoo0:9o
o`04O4U`BGooI4T2Ool015A9OomoodQ90goo00<lBGooOol01Woo00<`BGooOol047oo00<TBGooOol0
@Woo000IOol2002ROol017a9L4UoofA90Woo00ADBGooOom8B@=oo`03?4Uoogoo00Ioo`03<4Uoogoo
00moo`8TBDEoo`006Goo00<007ooOol0X7oo00AlBG19OomTB@9oo`04E4UoogooB4T3Ool00ca9Oomo
o`06Ool00c19Oomoo`0?Ool00bA9Oomoo`15Ool001Uoo`03001oogoo09moo`04O4U`BGooI4T2Ool0
15A9OomoodQ90goo00<lBGooOol01Woo00<`BGooOol03goo00<TBGooOol0AWoo000IOol00`00Oomo
o`2NOol017a9L4UoofA90Woo00ADBGooOom8B@=oo`03?4Uoogoo00Ioo`03<4Uoogoo00moo`0394Uo
ogoo04Moo`006Goo00<007ooOol0WGoo00AlBG19OomTB@9oo`04E4UoogooB4T3Ool00ca9Oomoo`06
Ool00c19Oomoo`0>Ool294U:Ool001Uoo`03001oogoo09eoo`03O4U`BFA9009oo`04E4UoogooB4T3
Ool00ca9Oomoo`05Ool2<4T@Ool00bA9Oomoo`1:Ool001Uoo`8009eoo`03O4U`BFA9009oo`04E4Uo
ogooB4T3Ool00ca9Oomoo`05Ool00c19Oomoo`0?Ool00bA9Oomoo`1;Ool001Uoo`03001oogoo09]o
o`03O4U`BFA9009oo`04E4UoogooB4T3Ool00ca9Oomoo`05Ool00c19Oomoo`0?Ool00bA9Oomoo`1<
Ool001Uoo`03001oogoo09Yoo`06O4U`BGooI4UooeA90Woo00E8BGooOomooca900Moo`03<4Uoogoo
00ioo`8TBDmoo`006Goo00<007ooOol0VGoo00IlBG19OomTBGooE4T2Ool01DQ9Oomoogoo?4T01goo
00<`BGooOol03Woo00<TBGooOol0Cgoo000IOol00`00Oomoo`2HOol01Wa9L4UoofA9OomDB@9oo`05
B4UoogooOollB@07Ool00c19Oomoo`0>Ool00bA9Oomoo`1@Ool001Uoo`03001oogoo09Moo`04O4Uo
og19I4T2Ool00eA9Oom8B@03Ool00ca9Oomoo`05Ool00c19Oomoo`0>Ool00bA9Oomoo`1AOol001Uo
o`8009Moo`04O4Uoog19I4T2Ool00eA9Oom8B@03Ool00ca9Oomoo`05Ool00c19Oomoo`0=Ool294UD
Ool001Uoo`03001oogoo09Eoo`04O4Uoog19I4T2Ool00eA9Oom8B@03Ool00ca9Oomoo`05Ool00c19
Oomoo`0=Ool00bA9Oomoo`1DOol001Uoo`03001oogoo09Aoo`04O4Uoog19I4T2Ool00eA9Oom8B@03
Ool00ca9Oomoo`05Ool00c19Oomoo`0=Ool00bA9Oomoo`1EOol000@000Eoo`8000Aoo`@000Ioo`03
001oogoo09=oo`04O4Uoog19I4T2Ool00eA9Oom8B@03Ool00ca9Oomoo`04Ool2<4T>Ool294UHOol0
00Aoo`03001oogoo009oo`8000Qoo`03001oogoo00=oo`03001oogoo099oo`04O4Uoog19I4T2Ool0
0eA9Oom8B@03Ool00ca9Oomoo`04Ool00c19Oomoo`0=Ool00bA9Oomoo`1HOol000Aoo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo099oo`03O4U`BFA9009oo`03E4UoodQ900=oo`03?4Uoogoo
00Aoo`03<4Uoogoo00eoo`0394Uoogoo05Uoo`0017oo00<007ooOol02Goo1@0017oo0`00TGoo00=l
BG19I4T00Woo00=DBGooB4T00goo00<lBGooOol017oo00<`BGooOol037oo0RA9G7oo0004Ool00`00
Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`2@Ool027a9Oom`BFA9OomDBGoo
B4T3Ool00ca9Oomoo`04Ool00c19Oomoo`0<Ool00bA9Oomoo`11Ool00aA9Oomoo`0HOol000Aoo`03
001oogoo00Qoo`03001oogoo009oo`03001oogoo009oo`03001oogoo08moo`08O4Uoog19I4UooeA9
Oom8B@=oo`03?4Uoogoo00Aoo`03<4Uoogoo00aoo`0394Uoogoo041oo`8DBA]oo`0017oo00<007oo
Ool027oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0SWoo00QlBGooL4UTBGooE4UoodQ9
0goo00<lBGooOol017oo00<`BGooOol02goo0RA9@Goo0QA97Goo0004000<Ool40005Ool00`00Oomo
o`2=Ool027a9Oom`BFA9OomDBGooB4T3Ool00ca9Oomoo`04Ool00c19Oomoo`0;Ool00bA9Oomoo`0o
Ool254TOOol001Uoo`8008eoo`08O4Uoog19I4UooeA9Oom8B@=oo`03?4Uoogoo00Aoo`03<4Uoogoo
00]oo`0394Uoogoo03ioo`8DBB5oo`006Goo00<007ooOol0Rgoo00QlBGooL4UTBGooE4UoodQ90goo
00<lBGooOol00goo0S193Goo00<TBGooOol0?Woo00<DBGooOol08Goo000IOol00`00Oomoo`2:Ool0
27a9Oom`BFA9OomDBGooB4T3Ool00ca9Oomoo`03Ool00c19Oomoo`0<Ool00bA9Oomoo`0mOol254TT
Ool001Uoo`03001oogoo08Uoo`08O4Uoog19I4UooeA9Oom8B@=oo`03?4Uoogoo00=oo`03<4Uoogoo
00aoo`0394Uoogoo03aoo`8DBBIoo`006Goo00<007ooOol0R7oo00QlBGooL4UTBGooE4UoodQ90Woo
0Sa91Goo00<`BGooOol02goo0RA9?Woo00<DBGooOol09Woo000IOol00`00Oomoo`27Ool027a9Oom`
BFA9OomDBGooB4T2Ool00ca9Oomoo`04Ool00c19Oomoo`0;Ool00bA9Oomoo`0lOol254TYOol001Uo
o`8008Moo`08O4U`BG19I4UooeA9Oom8B@9oo`03?4Uoogoo00Aoo`03<4Uoogoo00]oo`0394Uoogoo
03]oo`8DBB]oo`006Goo00<007ooOol0QGoo00QlBG19OomTBGooE4UoodQ90Woo00<lBGooOol017oo
00<`BGooOol02goo00<TBGooOol0>goo00<DBGooOol0:goo000IOol00`00Oomoo`24Ool027a9L4Uo
ofA9OomDBGooB4T2Ool00ca9Oomoo`04Ool00c19Oomoo`0;Ool00bA9Oomoo`0jOol254T^Ool001Uo
o`03001oogoo02aoo`D002eoo`<0029oo`08O4U`BGooI4UooeA9Oom8B@9oo`03?4Uoogoo009oo`80
0003<4Uoogoo00]oo`0394Uoogoo01eoo`@001Uoo`0354Uoogoo019oo`<001Uoo`006Goo00<007oo
Ool0;7oo00D007ooOomoo`0002aoo`05001oogooOol0000POol01Wa9L4UoofA9OomDB@98B@9oo`03
?4Uoogoo00=oo`8`B@aoo`8TBAmoo`03001oogoo009oo`03001oogoo01Eoo`0354Uoogoo019oo`05
001oogooOol0000HOol001Uoo`03001oogoo02eoo`03001oogoo035oo`03001oogoo01eoo`07O4U`
BGooI4UooeA9B4T00goo00<lBGooOol00goo00<`BGoo00002goo00<TBGooOol097oo00<007ooOol0
4goo0QA95Goo00D007ooOomoo`0001Qoo`006Goo0P00;goo00<007ooOol0<7oo00<007ooOol077oo
00MlBG19OomTBGooE4U8B@03Ool00ca9Oomoo`02Ool00`00<4T000030009Ool00bA9Oomoo`0UOol0
0`00Oomoo`0BOol00aA9Oomoo`0EOol01@00Oomoogoo000067oo000IOol00`00Oomoo`0_Ool00`00
Oomoo`0]Ool2000NOol01ga9L4UoofA9OomDBDQ900=oo`03?4Uoogoo00=oo`05<4T007ooOol00009
Ool00bA9Oomoo`0ROol4000COol254THOol4000IOol001Uoo`03001oogoo031oo`03001oogoo02io
o`03001oogoo01Yoo`07O4U`BGooI4UooeA9B4T00goo00<lBGooOol00goo00<`BGoo00000Woo00<0
07ooOol01Goo0RA99Goo00<007ooOol04goo00<DBGooOol067oo00<007ooOol06Woo000IOol00`00
Oomoo`0/Ool01@00Oomoogoo0000;7oo00D007ooOomoo`0001aoo`06O4UoofA9OomDBDQ90goo00<l
BGooOol00goo00L`BGooOomoo`00Ool00006Ool00bA9Oomoo`0UOol00`00Oomoo`0AOol254TLOol0
0`00Oomoo`0IOol001Uoo`03001oogoo02eoo`<002ioo`<001aoo`06O4UoofA9OomDBDQ90goo00<l
BGooOol00goo00<`BGooOol00goo0P001Goo00<TBGooOol09Woo1@003Goo0QA97goo0`0067oo000I
Ool00`00Oomoo`1lOol01Wa9L4UTBGooE4U8B@=oo`03?4Uoogoo00=oo`03<4Uoogoo00Yoo`0394Uo
ogoo03Qoo`0354Uoogoo03Yoo`006Goo0P00O7oo00IlBG19I4UooeA9B4T3Ool00ca9Oomoo`03Ool0
0c19Oomoo`09Ool294TiOol254TmOol001Uoo`03001oogoo07Yoo`06O4U`BFA9OomDBDQ90goo00<l
BGooOol00goo00<`BGooOol02Goo00<TBGooOol0=goo0QA9=Goo10001Woo000IOol00`00Oomoo`1i
Ool01Wa9L4UTBGooE4U8B@=oo`03?4Uoogoo009oo`8`B@]oo`0394Uoogoo03Moo`0354Uoogoo03Ao
o`03001oogoo009oo`03001oogoo00=oo`006Goo00<007ooOol0N7oo00IlBG19I4UooeA9B4T3Ool0
0ca9Oomoo`02Ool00c19Oomoo`0:Ool00bA9Oomoo`0fOol254TiOol30006Ool001Uoo`03001oogoo
07Moo`06O4U`BFA9OomDBDQ90goo00<lBGooOol00Woo00<`BGooOol02Woo00<TBGooOol0=Goo0QA9
>Woo00<007ooOol01goo000IOol00`00Oomoo`1fOol01Wa9L4UTBGooE4U8B@=oo`03?4Uoogoo009o
o`03<4Uoogoo00Uoo`8TBCIoo`8DBCaoo`03001oogoo00Moo`004goo1P0017a9M00000IlBG19I4T0
05A9B4T20002?4T400000c190000000900000bA90000000d000254Td000:Ool00`00Oomoo`07Ool0
01Uoo`04001oogooOol2O4T4Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`06Ool2O4T01G19I4UooeA9B4T00Woo00<lBGoo0000
0goo00<`BGooOol00goo00<007ooOol00goo00DTBGooOomoo`0000Uoo`03001oogoo00Moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`8DB@Qoo`03001oogoo00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00moo`03001oogoo00Ioo`006Goo00<007oo
Ool00goo00=lBC19Ool0K7oo00AlBGooL4UTB@9DB@04B4Uoogoo?4T5Ool00c19Oomoo`09Ool00bA9
Oomoo`0cOol00aA9Oomoo`12Ool30005Ool001Uoo`03001oogoo00Aoo`9lBF]oo`07O4U`BG19I4UD
BGooB4T00Woo00<lBGooOol00goo00<`BGooOol02Goo00<TBGooOol0<Woo0QA9A7oo0P000Woo00<0
07ooOol00Woo000IOol00`00Oomoo`06Ool00ga9Oomoo`1WOol01ga9L4UTBGooE4UoodQ9009oo`03
?4Uoogoo00=oo`03<4Uoogoo00Uoo`0394Uoogoo039oo`0354Uoogoo04Ioo`<000Aoo`006Goo0P00
1goo00<TBGa9Ool0IWoo00MlBG19I4UooeA9Oom8B@02Ool00ca9Oomoo`02Ool2<4T;Ool00bA9Oomo
o`0bOol00aA9Oomoo`1>Ool001Uoo`03001oogoo00Moo`0394UlBGoo06Aoo`05O4U`BFA9OomDB@02
B4T2Ool00ca9Oomoo`02Ool00c19Oomoo`09Ool294TcOol254UAOol001Uoo`03001oogoo00Qoo`03
94UlBGoo069oo`03O4U`BFA9009DB@05B4UoogooOollB@04Ool00c19Oomoo`09Ool00bA9Oomoo`0b
Ool00aA9Oomoo`1AOol001Uoo`03001oogoo00Uoo`0394UlBGoo061oo`06O4U`BFA9E4UoodQ90goo
00<lBGooOol00Woo00<`BGooOol02Goo00<TBGooOol0<Goo0QA9E7oo000IOol00`00Oomoo`0:Ool0
0bA9O4Uoo`1NOol01Wa9L4UTBEA9Oom8B@9oo`8lB@Aoo`03<4Uoogoo00Uoo`0394Uoogoo035oo`03
54Uoogoo05Aoo`006Goo00<007ooOol02goo00<TBGa9Ool0G7oo00IlBG19I4UDBGooB4T2Ool00ca9
Oomoo`03Ool00c19Oomoo`09Ool00bA9Oomoo`0`Ool254UGOol001Uoo`8000eoo`0394UlBGoo05Uo
o`9lB@05L4UooeA9Oom8B@02Ool00ca9Oomoo`03Ool00c19Oomoo`08Ool294TbOol00aA9Oomoo`1G
Ool001Uoo`03001oogoo00eoo`03O4Uoogoo05Moo`07O4Uoog19OomDBGooB4T00Woo00<lBGooOol0
0Woo0S192Woo00<TBGooOol0<Goo00<DBGooOol0F7oo000IOol00`00Oomoo`0=Ool00bA9O4Uoo`1F
Ool01ga9L4U`BGooE4UoodQ9009oo`03?4Uoogoo009oo`03<4Uoogoo00Uoo`0394Uoogoo031oo`8D
BE]oo`006Goo00<007ooOol03Woo00<TBGa9Ool0E7oo00=lBG19I4T00UA900EoodQ9Oomooca900Ao
o`03<4Uoogoo00Qoo`8TBC9oo`0354Uoogoo05]oo`006Goo00<007ooOol03goo00<TBGa9Ool0DWoo
00ElBG19OomDBGoo0098B@03OollBCa900Aoo`03<4Uoogoo00Qoo`0394Uoogoo031oo`8DBEioo`00
6Goo00<007ooOol047oo00<TBGa9Ool0D7oo00IlBG19OomDBGooB4T2Ool00ca9Oomoo`02Ool2<4T:
Ool00bA9Oomoo`0`Ool00aA9Oomoo`1NOol001Uoo`80019oo`0394UlBGoo04eoo`9lB@05L4UooeA9
Oom8B@02Ool00ca9Oomoo`02Ool00c19Oomoo`08Ool294TaOol254UQOol001Uoo`03001oogoo019o
o`0394UlBGoo04]oo`07O4U`BG19OomDBGooB4T00Woo00<lBGooOol00Woo00<`BGooOol027oo00<T
BGooOol0<7oo00<DBGooOol0HGoo000IOol00`00Oomoo`0COol00bA9O4U`B@19Ool00ga9L4Uoo`02
E4T00gooB4Uoo`02?4T4Ool00c19Oomoo`08Ool00bA9Oomoo`0_Ool254UTOol001Uoo`03001oogoo
01Aoo`0394UlBGa904Moo`05O4U`BGooE4Uoo`02B4T00goo?4Uoo`03Ool2<4T9Ool294T`Ool254UV
Ool001Uoo`03001oogoo01Aoo`0454TTBDQ9O4U4Ool2O4T01G19OomDBGooB4T00Woo00<lBGooOol0
0Woo00<`BGooOol027oo00<TBGooOol0;goo00<DBGooOol0IWoo000IOol00`00Oomoo`0EOol011A9
94U8BGa9@Woo00=lBG19I4T00UA90TQ900=ooca9?4T017oo00<`BGooOol027oo00<TBGooOol0;Woo
0QA9JGoo000IOol2000GOol011A994T`BGa9@7oo00AlBG19OomDB@98B@9oo`03?4Uoogoo00=oo`03
<4Uoogoo00Qoo`0394Uoogoo02ioo`0354Uoogoo06Uoo`006Goo00<007ooOol05goo00<DBBA9<4T0
0Wa9?7oo0Wa900ATBGooE4U8B@=oo`03?4Uoogoo009oo`8`B@Uoo`8TBBmoo`8DBFaoo`006Goo00<0
07ooOol05goo00HDBGoo94T`BDQ9O4TiOol2O4T01G19I4UDBEA9B4T00Woo0Sa917oo00<`BGooOol0
27oo00<TBGooOol0;Woo00<DBGooOol0K7oo00050004Ool20005Ool50004Ool00`00Oomoo`0HOol0
1QA9OolTBC19B4UlBCMoo`06O4U`BFA9OomDBDQ90goo00<lBGooOol00goo00<`BGooOol027oo00<T
BGooOol0;Goo0QA9Kgoo0002Ool00`00Oomoo`04Ool20007Ool00`00Oomoo`04Ool00`00Oomoo`0I
Ool01QA9OolTBC19B4UlBCAoo`9lB@05I4UooeA9E4U8B@03Ool00ca9Oomoo`02Ool2<4T9Ool294T^
Ool254UaOol0009oo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo01Yoo`0554UoobA9<4U8
B@02O4T`Ool2O4T01G19I4UDBEA9B4T00goo0Sa917oo00<`BGooOol027oo00<TBGooOol0;Goo00<D
BGooOol0LGoo0002Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool3000JOol01AA9OomoobA9<4T00TQ9
00=lBGooOol0;7oo00=lBG19I4T00UA900=8BGooOol00Woo00<lBGooOol00Woo0S192Woo00<TBGoo
Ool0;7oo0QA9M7oo0002Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0KOol011A9Oomo
obA90S1900=8BGa9Ool0:Woo0Wa900=TBEA9E4T00TQ90goo0Sa90goo0S192Woo0RA9;Woo00<DBGoo
Ool0M7oo0002Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0LOol00aA9Oomoo`0294T0
1319B4UlBGa99goo0Wa90VA900=DBDQ9B4T00goo0Sa917oo00<`BGooOol02Goo00<TBGooOol0;7oo
0QA9Mgoo0003000=Ool30006Ool00`00Oomoo`0MOol021A9Oomoogoo94T`BDQ9I4T3O4TQOol3O4T2
I4T00eA9Oom8B@03Ool2?4T4Ool2<4T:Ool294T^Ool00aA9Oomoo`1gOol0009oo`03001oogoo00eo
o`03001oogoo00Aoo`03001oogoo01ioo`0654UoogooOolTBC190TQ900=TBG19O4T00Wa977oo0Wa9
0fA900ADBGooB4U8B@9oo`8lB@Eoo`03<4Uoogoo00Uoo`0394Uoogoo02eoo`0354Uoogoo07Qoo`00
6Goo0P0087oo00LDBGooOomoobA9Ool`B@02B4T00fA9L4U`B@02O4TGOol3O4T2I4T2E4T00gooB4U8
B@02Ool2?4T5Ool2<4T:Ool294T^Ool254UkOol001Uoo`03001oogoo021oo`0554UoogooOolTB@02
Ool013a9B4U8BFA90W190Wa947oo1Ga900=oofA9I4T00UA900=oodQ9B4T00Woo0Sa91Goo0S192Woo
0RA9;goo00<DBGooOol0Ngoo000IOol00`00Oomoo`0QOol01AA9Oomoogoo94T00Woo00<`BCa9B4T0
0TQ90VA947a90g190fA90UA90dQ90Woo0Sa91Goo0S192Woo0RA9;goo0QA9OWoo000IOol00`00Oomo
o`0ROol01AA9Oomoogoo94T00goo00<`BCa9?4T00TQ90eA90VA927190fA90eA91DQ90Woo0ca91Goo
0S192Woo0RA9<7oo00<DBGooOol0OWoo000IOol00`00Oomoo`0ROol00aA9Oomoo`02Ool00bA9Oomo
o`02Ool01319?4TlBCa91DQ925A91DQ90Woo1Ca91Goo0c192Woo0RA9<7oo0QA9PGoo000IOol00`00
Oomoo`0SOol00aA9Oomoo`02Ool294T4Ool2<4T6?4T00gooB4U8B@03B4T4Ool4?4T8Ool2<4T<Ool0
0bA9Oomoo`0_Ool00aA9Oomoo`21Ool001Uoo`8002Eoo`0354Uoogoo00=oo`8TB@Aoo`8`B@Aoo`Xl
B@Moo`D`B@aoo`8TBC5oo`0354Uoogoo089oo`006Goo00<007ooOol09Goo00<DBGooOol017oo0RA9
17oo1C192goo1C193goo0RA9<Goo0QA9QGoo000IOol00`00Oomoo`0VOol00aA9Oomoo`05Ool294T7
Ool;<4TBOol294TbOol00aA9Oomoo`25Ool001Uoo`03001oogoo02Moo`0354Uoogoo00Ioo`8TBB1o
o`8TBC9oo`8DBHQoo`006Goo00<007ooOol0:7oo00<DBGooOol01goo0bA96Goo12A9<goo00<DBGoo
Ool0R7oo000IOol00`00Oomoo`0YOol00aA9Oomoo`09Ool294TCOol494TeOol254V;Ool001Uoo`80
02]oo`0354Uoogoo00Yoo`HTB@Moo`HTBCMoo`8DBHeoo`006Goo00<007ooOol0:goo00<DBGooOol0
3goo1bA9?7oo00<DBGooOol0SGoo000IOol00`00Oomoo`0/Ool00aA9Oomoo`1?Ool254V@Ool001Uo
o`03001oogoo02eoo`0354Uoogoo04aoo`8DBI9oo`006Goo00<007ooOol0;Woo00<DBGooOol0BWoo
00<DBGooOol0TWoo000IOol00`00Oomoo`0_Ool00aA9Oomoo`17Ool254VEOol001Uoo`80035oo`03
54Uoogoo04Aoo`8DBIMoo`006Goo00<007ooOol0<Goo00<DBGooOol0@Goo0QA9VGoo000IOol00`00
Oomoo`0bOol00aA9Oomoo`0nOol254VKOol000D000Aoo`8000Aoo`D000Eoo`03001oogoo03=oo`8D
BCaoo`8DBIeoo`000Woo00<007ooOol017oo0P0017oo00D007ooOomoo`0000Eoo`03001oogoo03Eo
o`0354Uoogoo03Moo`8DBImoo`000Woo00<007ooOol02goo00<007ooOol01Woo00<007ooOol0=Woo
00<DBGooOol0=7oo0QA9XGoo0002Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool3000gOol254TbOol2
54VSOol0009oo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo03Uoo`8DBBioo`8DBJEoo`00
0Woo00<007ooOol03Woo00<007ooOol00goo00<007ooOol0>goo0QA9:Woo0QA9Ygoo0003000<Ool0
1@00Oomoogoo00001Goo00<007ooOol0?Goo0QA99Goo0aA9ZGoo0002Ool00`00Oomoo`0;Ool30006
Ool00`00Oomoo`0oOol254TQOol254V/Ool001Uoo`80049oo`0354Uoogoo01Yoo`@DBJioo`006Goo
00<007ooOol0@Woo1AA94goo11A9/Woo000IOol00`00Oomoo`17Ool554T8Ool654VfOol001Uoo`03
001oogoo04aoo`PDBKaoo`006Goo00<007ooOol0ogoo4Goo000IOol00`00Oomoo`3oOolAOol001Uo
o`800?mooa9oo`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00
ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003oOol]Ool001Yoo`D00?moo`ioo`0077oo00<0
07ooOol0ogoo3Woo000COol30006Ool00`00Oomoo`3oOol>Ool001Aoo`03001oogoo00Eoo`03001o
ogoo0?moo`ioo`0057oo00<007ooOol01Goo00<007ooOol0ogoo3Woo000DOol00`00Ool00004Ool2
003oOol@Ool001Aoo`<00?mooaIoo`0057oo00<007oo0000ogoo5Woo000DOol01@00Oomoogoo0000
ogoo57oo000COol6003oOolDOol00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo
003oOol]Ool00?moobeoo`00ogoo;Goo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {195.375, 0}} -> {0.48078, 0.667728, \
0.0251985, 0.00430835}}]
}, Open  ]],

Cell[TextData[
"If we, on the other hand, fix the value of \[Kappa] and vary \[Gamma], we \
can examine the influence of \[Gamma] on the solution"], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    "0"}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[DoublePrime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(3/2\)}], ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", 
                        TagBox[\((3)\),
                          Derivative],
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(-10\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Kappa] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq /. \[Gamma] \[Rule] i, F1, {zeta1, 1, 15}], {i, 1, 5, 
          1}]; \)\)], "Input"],

Cell["The resulting solutions are shown in the following plot:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 6}, 
      PlotStyle \[Rule] color, 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 -0.849122 1.18268 [
[.21429 .32106 -3 -9 ]
[.21429 .32106 3 0 ]
[.40476 .32106 -3 -9 ]
[.40476 .32106 3 0 ]
[.59524 .32106 -3 -9 ]
[.59524 .32106 3 0 ]
[.78571 .32106 -3 -9 ]
[.78571 .32106 3 0 ]
[.97619 .32106 -3 -9 ]
[.97619 .32106 3 0 ]
[1.025 .33356 0 -7.5 ]
[1.025 .33356 10 7.5 ]
[.01131 .09703 -18 -4.5 ]
[.01131 .09703 0 4.5 ]
[.01131 .21529 -18 -4.5 ]
[.01131 .21529 0 4.5 ]
[.01131 .45183 -18 -4.5 ]
[.01131 .45183 0 4.5 ]
[.01131 .5701 -18 -4.5 ]
[.01131 .5701 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.21429 .33356 m
.21429 .33981 L
s
[(2)] .21429 .32106 0 1 Mshowa
.40476 .33356 m
.40476 .33981 L
s
[(3)] .40476 .32106 0 1 Mshowa
.59524 .33356 m
.59524 .33981 L
s
[(4)] .59524 .32106 0 1 Mshowa
.78571 .33356 m
.78571 .33981 L
s
[(5)] .78571 .32106 0 1 Mshowa
.97619 .33356 m
.97619 .33981 L
s
[(6)] .97619 .32106 0 1 Mshowa
.125 Mabswid
.0619 .33356 m
.0619 .33731 L
s
.1 .33356 m
.1 .33731 L
s
.1381 .33356 m
.1381 .33731 L
s
.17619 .33356 m
.17619 .33731 L
s
.25238 .33356 m
.25238 .33731 L
s
.29048 .33356 m
.29048 .33731 L
s
.32857 .33356 m
.32857 .33731 L
s
.36667 .33356 m
.36667 .33731 L
s
.44286 .33356 m
.44286 .33731 L
s
.48095 .33356 m
.48095 .33731 L
s
.51905 .33356 m
.51905 .33731 L
s
.55714 .33356 m
.55714 .33731 L
s
.63333 .33356 m
.63333 .33731 L
s
.67143 .33356 m
.67143 .33731 L
s
.70952 .33356 m
.70952 .33731 L
s
.74762 .33356 m
.74762 .33731 L
s
.82381 .33356 m
.82381 .33731 L
s
.8619 .33356 m
.8619 .33731 L
s
.9 .33356 m
.9 .33731 L
s
.9381 .33356 m
.9381 .33731 L
s
.25 Mabswid
0 .33356 m
1 .33356 L
s
gsave
1.025 .33356 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .09703 m
.03006 .09703 L
s
[(0.8)] .01131 .09703 1 0 Mshowa
.02381 .21529 m
.03006 .21529 L
s
[(0.9)] .01131 .21529 1 0 Mshowa
.02381 .45183 m
.03006 .45183 L
s
[(1.1)] .01131 .45183 1 0 Mshowa
.02381 .5701 m
.03006 .5701 L
s
[(1.2)] .01131 .5701 1 0 Mshowa
.125 Mabswid
.02381 .12068 m
.02756 .12068 L
s
.02381 .14433 m
.02756 .14433 L
s
.02381 .16799 m
.02756 .16799 L
s
.02381 .19164 m
.02756 .19164 L
s
.02381 .23895 m
.02756 .23895 L
s
.02381 .2626 m
.02756 .2626 L
s
.02381 .28625 m
.02756 .28625 L
s
.02381 .30991 m
.02756 .30991 L
s
.02381 .35722 m
.02756 .35722 L
s
.02381 .38087 m
.02756 .38087 L
s
.02381 .40452 m
.02756 .40452 L
s
.02381 .42818 m
.02756 .42818 L
s
.02381 .47548 m
.02756 .47548 L
s
.02381 .49914 m
.02756 .49914 L
s
.02381 .52279 m
.02756 .52279 L
s
.02381 .54645 m
.02756 .54645 L
s
.02381 .07337 m
.02756 .07337 L
s
.02381 .04972 m
.02756 .04972 L
s
.02381 .02606 m
.02756 .02606 L
s
.02381 .00241 m
.02756 .00241 L
s
.02381 .59375 m
.02756 .59375 L
s
.02381 .61741 m
.02756 .61741 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.2 .1 .3 r
.5 Mabswid
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .3377 L
.04262 .34056 L
.06244 .35756 L
.10458 .40322 L
.1249 .4241 L
.14393 .44132 L
.16333 .45603 L
.18177 .46711 L
.19145 .47177 L
.20201 .47596 L
.21162 .47896 L
.22054 .48106 L
.22561 .48197 L
.22828 .48236 L
.2311 .48272 L
.23358 .48298 L
.23629 .48322 L
.23876 .48338 L
.24106 .48349 L
.24222 .48353 L
.24347 .48356 L
.24466 .48358 L
.24576 .48359 L
.24674 .48359 L
.24783 .48358 L
.24897 .48356 L
.25004 .48354 L
.25122 .4835 L
.25246 .48345 L
.25467 .48333 L
.25706 .48316 L
.25967 .48293 L
.26495 .48232 L
.26994 .48157 L
.27928 .4797 L
.28933 .47706 L
.30023 .47349 L
.3201 .4652 L
.34115 .45413 L
.37903 .42902 L
.41937 .39628 L
.4582 .36019 L
.49947 .31812 L
Mistroke
.53924 .27493 L
.57748 .23163 L
.61818 .18429 L
.65736 .13794 L
.69899 .0883 L
.73911 .04039 L
Mfstroke
.73911 .04039 m
.77305 0 L
s
.3 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .3377 L
.04262 .34058 L
.06244 .35773 L
.10458 .40484 L
.14393 .44573 L
.16369 .46242 L
.18177 .47494 L
.20117 .48533 L
.21188 .48969 L
.22205 .49295 L
.23164 .49525 L
.237 .49621 L
.24186 .49689 L
.24641 .49735 L
.24897 .49754 L
.25019 .49762 L
.25133 .49767 L
.25241 .49772 L
.25339 .49776 L
.25449 .49779 L
.25566 .49781 L
.25679 .49782 L
.25802 .49782 L
.25917 .49781 L
.26025 .4978 L
.26142 .49777 L
.26266 .49773 L
.26488 .49763 L
.26726 .49749 L
.26987 .49728 L
.27455 .49679 L
.27891 .4962 L
.28887 .49438 L
.29951 .49172 L
.32086 .48435 L
.34101 .47513 L
.37948 .45232 L
.4204 .4221 L
.4598 .38872 L
.49769 .35383 L
.53803 .31468 L
.57685 .27577 L
.61813 .23373 L
Mistroke
.65789 .19303 L
.69613 .154 L
.73683 .11284 L
.77601 .07374 L
.81765 .0329 L
Mfstroke
.81765 .0329 m
.85185 0 L
s
.4 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .33771 L
.04262 .34059 L
.05224 .34813 L
.06244 .35791 L
.10458 .40659 L
.14241 .44917 L
.16345 .46935 L
.1827 .48491 L
.20281 .49795 L
.22147 .50704 L
.23066 .51044 L
.24046 .5133 L
.24606 .51459 L
.25133 .51558 L
.25606 .51627 L
.25853 .51657 L
.26118 .51684 L
.26375 .51704 L
.2661 .51719 L
.26723 .51724 L
.26846 .51729 L
.26962 .51733 L
.27069 .51735 L
.27193 .51737 L
.27309 .51738 L
.27437 .51737 L
.27509 .51737 L
.27575 .51736 L
.277 .51733 L
.27771 .51731 L
.27837 .51728 L
.28112 .51716 L
.28387 .51698 L
.28646 .51676 L
.29131 .51623 L
.29653 .51548 L
.30219 .51447 L
.31165 .51233 L
.32206 .50936 L
.3431 .50151 L
.38344 .48062 L
.42227 .45486 L
.46355 .42319 L
Mistroke
.50331 .38991 L
.54155 .35633 L
.58225 .31968 L
.62143 .28406 L
.66307 .24629 L
.70318 .21027 L
.74179 .17613 L
.78284 .14052 L
.82238 .10699 L
.86041 .07547 L
.90088 .04275 L
.93984 .01206 L
Mfstroke
.93984 .01206 m
.95554 0 L
s
.5 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .33771 L
.04262 .34061 L
.05224 .34819 L
.06244 .35809 L
.10458 .40848 L
.14241 .4547 L
.1827 .49631 L
.20124 .51164 L
.22147 .52528 L
.23243 .53127 L
.24261 .53596 L
.25226 .53963 L
.2627 .54276 L
.2682 .54406 L
.27327 .54505 L
.27801 .5458 L
.28053 .54613 L
.28322 .54643 L
.28567 .54665 L
.2879 .54682 L
.29014 .54695 L
.29227 .54704 L
.29342 .54708 L
.29465 .54711 L
.29569 .54712 L
.29685 .54713 L
.29808 .54713 L
.29878 .54712 L
.29942 .54711 L
.30059 .54709 L
.30183 .54706 L
.30306 .54701 L
.3044 .54695 L
.30683 .54681 L
.31137 .54644 L
.31668 .54584 L
.32157 .54513 L
.33049 .54345 L
.33994 .54115 L
.35951 .53485 L
.37782 .52725 L
.41665 .50668 L
.45792 .47981 L
Mistroke
.49769 .45071 L
.53593 .42089 L
.57663 .38811 L
.61581 .35614 L
.65744 .32222 L
.69756 .28988 L
.73617 .25927 L
.77722 .22739 L
.81676 .19742 L
.85479 .16931 L
.89526 .14016 L
.93422 .11287 L
.97564 .08467 L
.97619 .0843 L
Mfstroke
.6 .1 .3 r
.02381 .33356 m
.02499 .3336 L
.02605 .33368 L
.02729 .33385 L
.02846 .33406 L
.03053 .33459 L
.03279 .33534 L
.0379 .33772 L
.04262 .34062 L
.05224 .34825 L
.06244 .35827 L
.10458 .41053 L
.14241 .46111 L
.1827 .5106 L
.22147 .54995 L
.24118 .56607 L
.2627 .58039 L
.27267 .58584 L
.28329 .59082 L
.29325 .5947 L
.30241 .59762 L
.31269 .60016 L
.3181 .60119 L
.32382 .60206 L
.32879 .60262 L
.33118 .60283 L
.33343 .603 L
.33471 .60308 L
.3361 .60315 L
.33725 .6032 L
.33853 .60324 L
.3399 .60328 L
.34066 .6033 L
.34137 .60331 L
.34263 .60332 L
.34334 .60332 L
.34399 .60332 L
.34527 .60331 L
.34647 .60329 L
.34756 .60326 L
.34873 .60323 L
.35136 .60311 L
.35379 .60297 L
.35822 .60262 L
.36291 .60212 L
.37277 .60066 L
.38361 .59843 L
.40306 .59294 L
.42395 .58515 L
.46523 .56514 L
Mistroke
.50499 .54163 L
.54324 .5165 L
.58393 .48817 L
.62312 .46011 L
.66475 .43005 L
.70487 .40123 L
.74347 .37386 L
.78453 .3453 L
.82407 .31841 L
.86209 .29318 L
.90257 .26702 L
.94153 .24251 L
.97619 .22127 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{240, 148.5},
  ImageMargins->{{47.25, 0}, {0, 2.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000^A000`40O003h00O6Woo0P00`7oo00<D
BGooOol04Goo00<TBGooOol067oo00<`BGooOol07Woo000JOol00`00Oomoo`2nOol00aA9Oomoo`0A
Ool00bA9Oomoo`0HOol00c19Oomoo`0OOol001Yoo`03001oogoo0;eoo`0354Uoogoo015oo`0394Uo
ogoo01Moo`8`BB9oo`006Woo00<007ooOol0_7oo00<DBGooOol04Goo00<TBGooOol05goo00<`BGoo
Ool08Woo000JOol00`00Oomoo`2kOol00aA9Oomoo`0@Ool294TIOol00c19Oomoo`0SOol001Yoo`03
001oogoo0;Yoo`0354Uoogoo011oo`0394Uoogoo01Moo`8`BBIoo`006Woo00<007ooOol0^Woo00<D
BGooOol03goo00<TBGooOol05goo00<`BGooOol09Woo000JOol2002jOol00aA9Oomoo`0?Ool00bA9
Oomoo`0GOol00c19Oomoo`0WOol001Yoo`03001oogoo0;Qoo`0354Uoogoo00moo`0394Uoogoo01Mo
o`03<4Uoogoo02Qoo`006Woo00<007ooOol0]goo00<DBGooOol03goo00<TBGooOol05Woo0S19:goo
000JOol00`00Oomoo`2fOol00aA9Oomoo`0?Ool00bA9Oomoo`0FOol00c19Oomoo`0[Ool001Yoo`03
001oogoo0;Eoo`0354Uoogoo00moo`0394Uoogoo01Ioo`03<4Uoogoo02aoo`006Woo00<007ooOol0
]7oo00<DBGooOol03goo00<TBGooOol05Goo0S19;goo000JOol2002eOol00aA9Oomoo`0>Ool00bA9
Oomoo`0EOol00c19Oomoo`0_Ool001Yoo`03001oogoo0;=oo`0354Uoogoo00moo`0394Uoogoo01Ao
o`03<4Uoogoo031oo`006Woo00<007ooOol0/Woo00<DBGooOol03goo00<TBGooOol04goo0S19<goo
000JOol00`00Oomoo`2aOol00aA9Oomoo`0?Ool00bA9Oomoo`0COol00c19Oomoo`0cOol001Yoo`03
001oogoo0;5oo`0354Uoogoo00ioo`0394Uoogoo01=oo`03<4Uoogoo03Aoo`006Woo00<007ooOol0
/7oo00<DBGooOol03Woo00<TBGooOol04Woo0S19=goo000JOol2002`Ool00aA9Oomoo`0>Ool00bA9
Oomoo`0BOol00c19Oomoo`0gOol001Yoo`03001oogoo0:ioo`0354Uoogoo00ioo`0394Uoogoo019o
o`03<4Uoogoo03Qoo`006Woo00<007ooOol0[Woo00<DBGooOol03Goo00<TBGooOol04Goo0S19>goo
00000goo000000020005Ool20005Ool40005Ool00`00Oomoo`2]Ool00aA9Oomoo`0=Ool00bA9Oomo
o`0AOol00c19Oomoo`0OOol00ca9Oomoo`0IOol00003001oogoo009oo`03001oogoo009oo`8000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo0:aoo`0354Uoogoo00eoo`0394Uoogoo015o
o`03<4Uoogoo01ioo`8lBAaoo`0000<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol0Zgoo00<DBGooOol037oo0RA94goo00<`BGooOol07Woo00<lBGooOol0
77oo00000`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`02Ool3002ZOol0
0aA9Oomoo`0<Ool00bA9Oomoo`0AOol2<4TOOol2?4TOOol00003001oogoo009oo`03001oogoo00Uo
o`@000Eoo`03001oogoo0:Uoo`0354Uoogoo00aoo`0394Uoogoo015oo`03<4Uoogoo01eoo`8lBB5o
o`0000<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
Z7oo00<DBGooOol037oo00<TBGooOol04Goo00<`BGooOol07Goo00<lBGooOol08Goo00000`00Oomo
o`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`2WOol00aA9Oomo
o`0<Ool00bA9Oomoo`0AOol00c19Oomoo`0LOol2?4TTOol00003Ool00000008000aoo`@000Eoo`03
001oogoo0:Ioo`0354Uoogoo00aoo`0394Uoogoo015oo`03<4Uoogoo01aoo`03?4Uoogoo02Aoo`00
6Woo00<007ooOol0YWoo00<DBGooOol02goo00<TBGooOol04Goo00<`BGooOol06goo0Sa99goo000J
Ool2002VOol00aA9Oomoo`0;Ool00bA9Oomoo`0AOol00c19Oomoo`0KOol00ca9Oomoo`0WOol001Yo
o`03001oogoo0:Aoo`0354Uoogoo00]oo`0394Uoogoo011oo`8`BAeoo`03?4Uoogoo02Qoo`006Woo
00<007ooOol0Xgoo00<DBGooOol02goo00<TBGooOol047oo00<`BGooOol06goo0Sa9:goo000JOol0
0`00Oomoo`2ROol00aA9Oomoo`0;Ool00bA9Oomoo`0@Ool00c19Oomoo`0KOol00ca9Oomoo`0[Ool0
01Yoo`03001oogoo0:5oo`0354Uoogoo00aoo`0394Uoogoo00moo`03<4Uoogoo01Yoo`8lBBioo`00
6Woo00<007ooOol0X7oo00<DBGooOol037oo00<TBGooOol03goo00<`BGooOol06Woo00<lBGooOol0
;Woo000JOol2002POol00aA9Oomoo`0<Ool00bA9Oomoo`0?Ool00c19Oomoo`0JOol00ca9Oomoo`0_
Ool001Yoo`03001oogoo09ioo`0354Uoogoo00aoo`0394Uoogoo00moo`03<4Uoogoo01Uoo`8lBC9o
o`006Woo00<007ooOol0WWoo00<DBGooOol02goo00<TBGooOol03goo00<`BGooOol06Goo00<lBGoo
Ool0<Woo000JOol00`00Oomoo`2MOol00aA9Oomoo`0;Ool00bA9Oomoo`0?Ool00c19Oomoo`0IOol0
0ca9Oomoo`0cOol001Yoo`03001oogoo09aoo`0354Uoogoo00]oo`0394Uoogoo00ioo`8`BA]oo`03
?4Uoogoo03Aoo`006Woo00<007ooOol0Vgoo00<DBGooOol02goo00<TBGooOol03Woo00<`BGooOol0
6Goo0Sa9=goo000JOol2002KOol00aA9Oomoo`0;Ool00bA9Oomoo`0>Ool00c19Oomoo`0IOol00ca9
Oomoo`0gOol001Yoo`03001oogoo09Uoo`0354Uoogoo00]oo`0394Uoogoo00ioo`03<4Uoogoo01Uo
o`03?4Uoogoo03Qoo`006Woo00<007ooOol0VGoo00<DBGooOol02Woo00<TBGooOol03Woo00<`BGoo
Ool067oo0Sa9>goo000JOol00`00Oomoo`2HOol00aA9Oomoo`0:Ool00bA9Oomoo`0>Ool00c19Oomo
o`0HOol00ca9Oomoo`0kOol001Yoo`03001oogoo09Moo`0354Uoogoo00Yoo`0394Uoogoo00ioo`03
<4Uoogoo01Qoo`03?4Uoogoo03aoo`006Woo00<007ooOol0UWoo00<DBGooOol02Woo00<TBGooOol0
3Woo00<`BGooOol05goo0Sa9?goo000JOol2002FOol00aA9Oomoo`0:Ool00bA9Oomoo`0>Ool00c19
Oomoo`0GOol00ca9Oomoo`0oOol001Yoo`03001oogoo09Aoo`0354Uoogoo00Yoo`0394Uoogoo00eo
o`8`BAQoo`8lBD9oo`006Woo00<007ooOol0U7oo00<DBGooOol02Goo00<TBGooOol03Goo00<`BGoo
Ool05goo00<lBGooOol0@Woo00000goo000000020005Ool20004Ool40006Ool00`00Oomoo`2COol0
0aA9Oomoo`09Ool00bA9Oomoo`0=Ool00c19Oomoo`0GOol00ca9Oomoo`13Ool00003001oogoo009o
o`03001oogoo009oo`8000Qoo`03001oogoo00=oo`03001oogoo099oo`0354Uoogoo00Uoo`0394Uo
ogoo00eoo`03<4Uoogoo01Ioo`8lBDIoo`0000<007ooOol00Woo00<007ooOol03Goo00<007ooOol0
0Woo00<007ooOol0TGoo00<DBGooOol02Goo00<TBGooOol03Goo00<`BGooOol05Woo00<lBGooOol0
AWoo00000`00Oomoo`02Ool00`00Oomoo`09Ool50004Ool3002@Ool00aA9Oomoo`09Ool00bA9Oomo
o`0=Ool00c19Oomoo`0FOol00ca9Oomoo`17Ool00003001oogoo009oo`03001oogoo00Qoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo08moo`0354Uoogoo00Uoo`0394Uoogoo00aoo`8`BAQo
o`03?4Uoogoo04Qoo`0000<007ooOol00Woo00<007ooOol027oo00<007ooOol00Woo00<007ooOol0
0Woo00<007ooOol0Sgoo00<DBGooOol027oo00<TBGooOol037oo00<`BGooOol05Woo0Sa9;goo00=8
BGooOol06Goo00000`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`2>Ool00aA9Oomoo`08Ool00bA9Oomoo`0<Ool00c19Oomoo`0FOol00ca9Oomoo`0]Ool2
B4TLOol00003Ool00000008000aoo`@000Eoo`03001oogoo08eoo`0354Uoogoo00Qoo`0394Uoogoo
00aoo`03<4Uoogoo01Ioo`03?4Uoogoo02aoo`98BAioo`006Woo00<007ooOol0S7oo00<DBGooOol0
27oo00<TBGooOol037oo00<`BGooOol05Goo0Sa9;Goo0TQ987oo000JOol00`00Oomoo`2;Ool00aA9
Oomoo`08Ool00bA9Oomoo`0;Ool2<4TGOol00ca9Oomoo`0[Ool2B4TROol001Yoo`8008]oo`0354Uo
ogoo00Qoo`0394Uoogoo00]oo`03<4Uoogoo01Ioo`03?4Uoogoo02]oo`03B4Uoogoo029oo`006Woo
00<007ooOol0RGoo00<DBGooOol027oo00<TBGooOol02goo00<`BGooOol05Goo0Sa9;7oo0TQ99Goo
000JOol00`00Oomoo`28Ool00aA9Oomoo`08Ool00bA9Oomoo`0;Ool00c19Oomoo`0EOol00ca9Oomo
o`0[Ool00dQ9Oomoo`0UOol001Yoo`03001oogoo08Moo`0354Uoogoo00Qoo`0394Uoogoo00]oo`03
<4Uoogoo01Eoo`03?4Uoogoo02]oo`03B4Uoogoo02Ioo`006Woo00<007ooOol0Qgoo00<DBGooOol0
1goo00<TBGooOol02goo00<`BGooOol057oo0Sa9;7oo0TQ9:Goo000JOol00`00Oomoo`26Ool00aA9
Oomoo`07Ool00bA9Oomoo`0;Ool00c19Oomoo`0DOol00ca9Oomoo`0[Ool00dQ9Oomoo`0YOol001Yo
o`8008Ioo`0354Uoogoo00Moo`0394Uoogoo00]oo`03<4Uoogoo01Aoo`03?4Uoogoo02Yoo`98BBao
o`006Woo00<007ooOol0Q7oo00<DBGooOol01goo00<TBGooOol02goo00<`BGooOol04goo0Sa9;7oo
00=8BGooOol0;7oo000JOol00`00Oomoo`23Ool00aA9Oomoo`07Ool00bA9Oomoo`0;Ool00c19Oomo
o`0COol00ca9Oomoo`0ZOol2B4T_Ool001Yoo`03001oogoo089oo`0354Uoogoo00Moo`0394Uoogoo
00]oo`03<4Uoogoo01=oo`03?4Uoogoo02Yoo`03B4Uoogoo02moo`006Woo00<007ooOol0;7oo1@00
;Goo0`0087oo00<DBGooOol01goo00<TBGooOol00goo0`001Goo00<`BGooOol04goo00<lBGooOol0
3Woo100067oo00=8BGooOol04goo0`006Woo000JOol00`00Oomoo`0/Ool01@00Oomoogoo0000;7oo
00D007ooOomoo`0001ioo`0354Uoogoo00Moo`0394Uoogoo00Eoo`03001oogoo00=oo`03<4Uoogoo
019oo`8lBA1oo`03001oogoo009oo`03001oogoo01=oo`98BAEoo`05001oogooOol0000IOol001Yo
o`8002ioo`03001oogoo035oo`03001oogoo01]oo`0354Uoogoo00Moo`0394Uoogoo00Ioo`03001o
ogoo009oo`03<4Uoogoo019oo`03?4Uoogoo01Eoo`03001oogoo019oo`03B4Uoogoo01Eoo`05001o
ogooOol0000IOol001Yoo`03001oogoo02ioo`03001oogoo031oo`03001oogoo01Yoo`0354Uoogoo
00Moo`0394Uoogoo00=oo`H0009oo`03<4Uoogoo019oo`03?4Uoogoo01Ioo`03001oogoo011oo`98
BAQoo`05001oogooOol0000IOol001Yoo`03001oogoo02moo`03001oogoo02eoo`8001aoo`0354Uo
ogoo00Moo`0394Uoogoo00Eoo`04001oogoo0002Ool00c19Oomoo`0BOol00ca9Oomoo`0COol4000B
Ool00dQ9Oomoo`0HOol4000JOol001Yoo`03001oogoo031oo`03001oogoo02ioo`03001oogoo01Uo
o`0354Uoogoo00Ioo`0394Uoogoo00Ioo`06001oogoo001ooc194goo0Sa95Woo00<007ooOol04Goo
0TQ96goo00<007ooOol06goo000JOol00`00Oomoo`0/Ool01@00Oomoogoo0000;7oo00D007ooOomo
o`0001Yoo`0354Uoogoo00Ioo`0394Uoogoo00Qoo`04001ooc19<4TCOol00ca9Oomoo`0FOol00`00
Oomoo`0?Ool2B4TNOol00`00Oomoo`0JOol001Yoo`03001oogoo02eoo`<002ioo`<001Yoo`0354Uo
ogoo00Ioo`0394Uoogoo00Yoo`03<4T007oo019oo`03?4Uoogoo01Moo`D000aoo`03B4Uoogoo01mo
o`<001Uoo`006Woo0P00Ngoo00<DBGooOol01Woo00<TBGooOol02Woo00<`BGooOol04Woo00<lBGoo
Ool09goo0TQ9?Woo000JOol00`00Oomoo`1iOol00aA9Oomoo`06Ool00bA9Oomoo`0:Ool00c19Oomo
o`0AOol2?4TXOol2B4TdOol40008Ool001Yoo`03001oogoo07Qoo`0354Uoogoo00Ioo`0394Uoogoo
00Yoo`03<4Uoogoo015oo`03?4Uoogoo02Moo`03B4Uoogoo03=oo`03001oogoo009oo`03001oogoo
00Eoo`006Woo00<007ooOol0Mgoo00<DBGooOol01Woo00<TBGooOol02Woo00<`BGooOol04Goo00<l
BGooOol09Woo0TQ9>7oo0`0027oo000JOol00`00Oomoo`1fOol00aA9Oomoo`06Ool00bA9Oomoo`0:
Ool00c19Oomoo`0AOol00ca9Oomoo`0VOol00dQ9Oomoo`0gOol00`00Oomoo`09Ool001Yoo`03001o
ogoo07Eoo`0354Uoogoo00Ioo`0394Uoogoo00Yoo`03<4Uoogoo011oo`8lBBQoo`03B4Uoogoo03Qo
o`03001oogoo00Uoo`0057oo1P0014Q9L`0000<DB@0000001P0000<TB@0000002P0000<`B@000000
400000<lB@0000009P000TQ9<P002Goo00<007ooOol02Goo000JOol01@00OomoogooB4T01Goo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<DBGooOol01Woo00<TB@00Ool027oo00<00319<4T01goo00<007ooOol01goo00<0
03a9Ool01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00@007ooOom8B@Ioo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00ioo`03
001oogoo00Qoo`006Woo00<007ooOol00Woo00=8BGooOol0:Woo00<007ooOol0;Woo00<007ooOol0
47oo00<DBGooOol01Goo00<TBGooOol02Goo00<`BGooOol01goo00<007ooOol01goo00<lBGooOol0
97oo00<004Q9B4T0;Woo00<007ooOol03goo0`001goo000JOol00`00Oomoo`03Ool2B4U]Ool00aA9
Oomoo`05Ool00bA9Oomoo`09Ool00c19Oomoo`0AOol00ca9Oomoo`0UOol00dQ9Oomoo`0oOol20002
Ool00`00Oomoo`04Ool001Yoo`03001oogoo00Aoo`0394U8BGoo06Yoo`0354Uoogoo00Eoo`0394Uo
ogoo00Uoo`03<4Uoogoo011oo`8lBBIoo`98BDAoo`<000Ioo`006Woo00<007ooOol01Woo00=8BGoo
Ool0Igoo00<DBGooOol01Goo00<TBGooOol02Goo00<`BGooOol047oo00<lBGooOol09Goo00=8BGoo
Ool0CGoo000JOol20008Ool00dQ9Oomoo`1UOol00aA9Oomoo`05Ool00bA9Oomoo`09Ool00c19Oomo
o`0@Ool00ca9Oomoo`0TOol2B4U@Ool001Yoo`03001oogoo00Qoo`03B4Uoogoo06=oo`0354Uoogoo
00Eoo`0394Uoogoo00Uoo`03<4Uoogoo011oo`03?4Uoogoo02=oo`98BE9oo`006Woo00<007ooOol0
2Goo00=8BGooOol0HGoo00<DBGooOol01Goo00<TBGooOol027oo0S194Goo0Sa99Goo00=8BGooOol0
DWoo000JOol00`00Oomoo`09Ool00dQ9?4Uoo`1POol00aA9Oomoo`05Ool00bA9Oomoo`08Ool00c19
Oomoo`0@Ool00ca9Oomoo`0SOol2B4UEOol001Yoo`03001oogoo00Yoo`03B4TTBGoo05ioo`0354Uo
ogoo00Aoo`8TB@Yoo`03<4Uoogoo011oo`03?4Uoogoo02=oo`03B4Uoogoo05Eoo`006Woo00<007oo
Ool02goo00=8BBA9Ool0G7oo00<DBGooOol017oo00<TBGooOol02Goo00<`BGooOol047oo00<lBGoo
Ool08Woo0TQ9F7oo000JOol2000=Ool00dQ994Uoo`1IOol254T6Ool00bA9Oomoo`08Ool2<4TAOol2
?4TTOol00dQ9Oomoo`1HOol001Yoo`03001oogoo00eoo`03B4Uoogoo05Moo`0354Uoogoo00Eoo`03
94Uoogoo00Qoo`03<4Uoogoo011oo`03?4Uoogoo02=oo`03B4Uoogoo05Uoo`006Woo00<007ooOol0
3Goo00=8BCa9Ool0EWoo00<DBGooOol01Goo00<TBGooOol027oo00<`BGooOol047oo00<lBGooOol0
8Woo0TQ9G7oo000JOol00`00Oomoo`0>Ool00dQ9?4Uoo`1DOol00aA9Oomoo`05Ool00bA9Oomoo`08
Ool00c19Oomoo`0@Ool00ca9Oomoo`0ROol00dQ9Oomoo`1LOol001Yoo`03001oogoo00moo`03B4TT
BGoo059oo`0354Uoogoo00Eoo`0394Uoogoo00Qoo`03<4Uoogoo00moo`8lBB=oo`98BEmoo`006Woo
00<007ooOol047oo00=8BBA9Ool0D7oo00<DBGooOol01Goo00<TBGooOol027oo00<`BGooOol03goo
00<lBGooOol08Woo00=8BGooOol0Ggoo000JOol2000AOol00dQ9?4TTB@1>Ool254T7Ool00bA9Oomo
o`08Ool00c19Oomoo`0?Ool00ca9Oomoo`0ROol00dQ9Oomoo`1POol001Yoo`03001oogoo015oo`03
B4TlBBA904aoo`0354Uoogoo00Eoo`8TB@Uoo`8`BA5oo`03?4Uoogoo025oo`98BF=oo`006Woo00<0
07ooOol04Woo00=8BCa994T0BWoo00<DBGooOol01Goo00<TBGooOol027oo00<`BGooOol03goo0Sa9
8goo00=8BGooOol0Hgoo000JOol00`00Oomoo`0COol014Q9?4TTBAA9Agoo00<DBGooOol01Goo00<T
BGooOol027oo00<`BGooOol03goo00<lBGooOol08Woo00=8BGooOol0I7oo000JOol00`00Oomoo`0D
Ool014Q9?4TTBAA9AGoo00<DBGooOol01Goo00<TBGooOol027oo00<`BGooOol03goo00<lBGooOol0
8Woo00=8BGooOol0IGoo000JOol00`00Oomoo`0DOol01DQ9?4T`BBA954T0@Woo0QA91goo00<TBGoo
Ool027oo00<`BGooOol03goo00<lBGooOol08Goo0TQ9J7oo000JOol2000FOol01DQ9?4T`BGoo54T0
@7oo00<DBGooOol01Goo0RA92Goo0S1947oo0Sa98goo00=8BGooOol0J7oo000JOol00`00Oomoo`0F
Ool01DQ9?4TTBGoo54T0?Woo00<DBGooOol01Goo00<TBGooOol027oo00<`BGooOol03goo00<lBGoo
Ool08Woo00=8BGooOol0JGoo000JOol00`00Oomoo`0GOol014Q9?4TTBAA9?7oo0QA91goo00<TBGoo
Ool027oo00<`BGooOol03goo00<lBGooOol08Goo0TQ9K7oo00000goo000000030004Ool20005Ool5
0004Ool00`00Oomoo`0GOol01DQ9OollBBA954T0>Goo0QA91goo0RA92Goo0S194Goo00<lBGooOol0
8Goo00=8BGooOol0K7oo0003Ool00`00Oomoo`04Ool20007Ool00`00Oomoo`04Ool00`00Oomoo`0H
Ool01DQ9OollBBA954T0=goo00<DBGooOol01Woo00<TBGooOol027oo00<`BGooOol03goo0Sa98goo
00=8BGooOol0KGoo0003Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01DQ9?4T`
BBA954T0=7oo0QA927oo00<TBGooOol027oo00<`BGooOol03goo00<lBGooOol08Goo0TQ9L7oo0003
Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool3000JOol00dQ9?4T`B@0294T00aA9Oomoo`0^Ool254T8
Ool294T9Ool2<4TAOol00ca9Oomoo`0QOol00dQ9Oomoo`1`Ool000=oo`03001oogoo00eoo`03001o
ogoo00Aoo`03001oogoo01Yoo`07B4Uooca9<4UoobA954T0;Woo00<DBGooOol01goo00<TBGooOol0
27oo00<`BGooOol03goo0Sa98goo00=8BGooOol0LGoo0003Ool00`00Oomoo`0=Ool00`00Oomoo`04
Ool00`00Oomoo`0KOol01DQ9OollBC19Ool00RA900<DBGooOol0:7oo0QA927oo0RA92Goo0S194Goo
00<lBGooOol08Goo0TQ9M7oo000017oo000000003Goo0`001Woo00<007ooOol077oo00=8BGoo?4T0
0S1900AoobA954TDBBIoo`8DB@Qoo`8TB@Yoo`03<4Uoogoo011oo`03?4Uoogoo025oo`03B4Uoogoo
07Aoo`000goo00<007ooOol03Goo00<007ooOol017oo00<007ooOol07Goo00Q8BGoo?4Uooc19OolT
BGoo0QA98Woo0QA927oo0RA92goo00<`BGooOol03goo0Sa98Woo0TQ9Mgoo000JOol00`00Oomoo`0N
Ool01TQ9OollBGoo<4Uoo`8TB@03OolDBAA901ioo`8DB@Qoo`8TB@]oo`8`BA5oo`03?4Uoogoo025o
o`03B4Uoogoo07Moo`006Woo00<007ooOol07Woo00I8BGooOollBGoo<4T2Ool012A9OomooaA96Woo
0aA927oo0RA937oo00<`BGooOol047oo00<lBGooOol08Goo00=8BGooOol0N7oo000JOol2000POol0
0dQ9OollB@02Ool00c19Oomoo`0294T00goo54TDB@0354TBOol354T9Ool294T<Ool2<4TAOol2?4TR
Ool2B4UkOol001Yoo`03001oogoo021oo`03B4Uooca9009oo`04<4UoogooOol294T4Ool654T5Ool7
54T:Ool294T=Ool00c19Oomoo`0@Ool00ca9Oomoo`0QOol00dQ9Oomoo`1kOol001Yoo`03001oogoo
025oo`03B4Uooca9009oo`03<4Uoogoo009oo`8TB@Moo`LDB@ioo`8TB@eoo`8`BA5oo`8lBB9oo`98
BGioo`006Woo00<007ooOol08Goo00A8BGooOollB@9oo`8`B@Aoo`<TBAMoo`8TB@eoo`8`BA9oo`03
?4Uoogoo025oo`03B4Uoogoo07ioo`006Woo00<007ooOol08Woo00A8BGooOollB@=oo`8`B@Eoo`8T
B@moo`HTB@eoo`8`BA=oo`03?4Uoogoo021oo`98BH5oo`006Woo00<007ooOol08goo00A8BGooOoll
B@Aoo`8`B@Eoo`lTBA5oo`8`BA=oo`8lBB9oo`03B4Uoogoo085oo`006Woo0P009Goo00A8BGooOoll
B@Eoo`03<4Uoogoo01moo`<`BAAoo`03?4Uoogoo021oo`98BHAoo`006Woo00<007ooOol097oo00A8
BGooOomoo`8lB@Aoo`8`BAaoo`<`BAEoo`8lBB5oo`98BHIoo`006Woo00<007ooOol09Goo00=8BGoo
Ool00Woo00<lBGooOol00goo0S1967oo0S195goo00<lBGooOol087oo00=8BGooOol0QWoo000JOol0
0`00Oomoo`0VOol00dQ9Oomoo`02Ool00ca9Oomoo`04Ool4<4TAOol3<4TGOol2?4TQOol2B4V9Ool0
01Yoo`03001oogoo02Moo`03B4Uoogoo009oo`8lB@Qooa4`BAQoo`8lBB9oo`03B4Uoogoo08Uoo`00
6Woo00<007ooOol0:7oo00=8BGooOol00goo0Sa9;Goo0Sa98goo00=8BGooOol0RWoo000JOol2000Z
Ool00dQ9Oomoo`04Ool00ca9Oomoo`0XOol2?4TSOol2B4V=Ool001Yoo`03001oogoo02Yoo`03B4Uo
ogoo00Aoo`8lBBEoo`<lBBAoo`03B4Uoogoo08eoo`006Woo00<007ooOol0:goo00=8BGooOol01Goo
0Sa98Goo0Sa99Woo00=8BGooOol0SWoo000JOol00`00Oomoo`0/Ool00dQ9Oomoo`06Ool2?4TKOol4
?4TVOol2B4VAOol001Yoo`03001oogoo02eoo`03B4Uoogoo00Moo`<lBAEoo`<lBBUoo`03B4Uoogoo
095oo`006Woo00<007ooOol0;Woo00=8BGooOol02Goo1Ca92goo1Ca9:goo00=8BGooOol0TWoo000J
Ool2000`Ool00dQ9Oomoo`0=Ool;?4T^Ool2B4VEOol001Yoo`03001oogoo031oo`03B4Uoogoo04=o
o`98BIMoo`006Woo00<007ooOol0<Goo0TQ9@Goo0TQ9VGoo00000goo000000030004Ool20004Ool5
0005Ool00`00Oomoo`0cOol00dQ9Oomoo`0lOol2B4VKOol000=oo`03001oogoo00Aoo`8000Aoo`05
001oogooOol00005Ool00`00Oomoo`0dOol2B4TjOol2B4VMOol000=oo`03001oogoo00]oo`03001o
ogoo00Ioo`03001oogoo03Ioo`03B4Uoogoo03Ioo`03B4Uoogoo09eoo`000goo00<007ooOol037oo
00<007ooOol01Goo0`00=goo00=8BGooOol0<goo0TQ9X7oo0003Ool00`00Oomoo`0=Ool00`00Oomo
o`04Ool00`00Oomoo`0hOol2B4TaOol2B4VROol000=oo`03001oogoo00ioo`03001oogoo00=oo`03
001oogoo03Yoo`03B4Uoogoo02aoo`98BJAoo`0000Aoo`00000000aoo`05001oogooOol00005Ool0
0`00Oomoo`0kOol2B4TZOol2B4VVOol000=oo`03001oogoo00]oo`<000Ioo`03001oogoo03eoo`98
BBEoo`=8BJQoo`006Woo00<007ooOol0?goo0dQ97goo0dQ9Zgoo000JOol20013Ool2B4TIOol4B4V^
Ool001Yoo`03001oogoo04Aoo`=8BA9oo`A8BK9oo`006Woo00<007ooOol0Agoo2DQ900=oodQ9B4T0
1TQ9]Woo000JOol00`00Oomoo`1?Ool2B4VnOol001Yoo`03001oogoo0?mooa1oo`006Woo00<007oo
Ool0ogoo47oo000JOol2003oOolAOol00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo
;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003oOol]Ool00?moobeoo`006goo1@00ogoo3Goo000M
Ool00`00Oomoo`3oOol=Ool001Eoo`<000Eoo`03001oogoo0?moo`eoo`005Woo00<007ooOol017oo
00<007ooOol0ogoo3Goo000FOol00`00Oomoo`04Ool00`00Oomoo`3oOol=Ool001Ioo`03001oo`00
00=oo`800?moo`moo`005Woo0`00ogoo57oo000FOol00`00Ool0003oOolDOol001Ioo`05001oogoo
Ool0003oOolBOol001Eoo`H00?mooa9oo`00ogoo;Goo003oOol]Ool00?moobeoo`00ogoo;Goo003o
Ool]Ool00001\
\>"],
  ImageRangeCache->{{{0, 299}, {184.625, 0}} -> {0.450882, 0.717962, \
0.0254404, 0.0040973}}]
}, Open  ]],

Cell[TextData[
"We realize that the influence of the non-linear terms represented by \
\[Gamma] increases if \[Gamma] increases. The given solutions are by no means \
complete. We only get a caricature of the solution manifold by a numerical \
solution. However, for some practical applications, this solution may be \
sufficient to solve a specific problem."], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["5.6.10.2 Desorption with Non-linearity", "Subsubsection",
  CellTags->"Desorption with Nonlinearity"],

Cell[TextData[
"The general model of MBE reduces to a model containing only effects of \
desorption and deposition if we set the constants \[Kappa] and \[Gamma] equal \
to zero:"], "Text",
  CellTags->"desorption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m3MBE\  = \ nMBE\  /. {\[Kappa] \[Rule] 0, \[Gamma] \[Rule] 0}; 
    m3MBE // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-\[CapitalPhi]\) + a\_t - \[Alpha]\ a\_\(x, x\) - 
                3\ \[Lambda]\ a\_x\%2\ a\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"The equation of motion is a non-linear second-order PDE with a constant flux \
\[CapitalPhi] responsible for deposition. The equation of motion is connected \
with a non-linear diffusion equation including convective effects of the \
material in addition to the diffusive effects. The symmetries of this \
equation follow by"], "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m3infi\  = \ 
      Infinitesimals[m3MBE, a, {x, t}, {\[Alpha], \[Lambda], \[CapitalPhi]}]; 
    m3infi\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{"k3", "+", 
                
                StyleBox[
                  \(\(k4\ \((a + t\ \[CapitalPhi])\)\)\/\[CapitalPhi]\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{"k1", "+", 
                StyleBox[\(\(k4\ x\)\/\[CapitalPhi]\),
                  ScriptLevel->0]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{"k2", "+", 
                StyleBox[\(\(2\ k4\ t\)\/\[CapitalPhi]\),
                  ScriptLevel->0]}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ k3, 
            Times[ k4, 
              Power[ \[CapitalPhi], -1], 
              Plus[ a, 
                Times[ t, \[CapitalPhi]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, 
            Times[ k4, x, 
              Power[ \[CapitalPhi], -1]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k2, 
            Times[ 2, k4, t, 
              Power[ \[CapitalPhi], -1]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[
"describing a four-dimensional finite group with scaling and translation \
symmetries. We observe that the constant flux \[CapitalPhi] is connected with \
the scaling symmetry. We will examine the solutions for the non-linear \
deposition model for this symmetry. The infinitesimals for the scaling \
subgroup read"], "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infi\  = 
      \({{\(xi[1]\)[x, t, a], \(xi[2]\)[x, t, a]}, {\(phi[1]\)[x, t, a]}} /. 
          m3infi\) /. {k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 1}
          \)], "Input"],

Cell[BoxData[
    \({{x\/\[CapitalPhi], \(2\ t\)\/\[CapitalPhi]}, {
        \(a + t\ \[CapitalPhi]\)\/\[CapitalPhi]}}\)], "Output"]
}, Open  ]],

Cell["The corresponding reduction follows from", "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1\  = \ 
      LieReduction[m3MBE, {a}, {x, t}, 
        infi\[LeftDoubleBracket]1\[RightDoubleBracket], 
        infi\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(t\/x\^2\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(\(-a\) + t\ \[CapitalPhi]\)\/x\),
                    ScriptLevel->0]}], "-", \(F\_1\)}], "==", "0"}]},
          {
            \(\((F\_1)\)\_\(\[Zeta]\_1\) - 
                2\ \[Alpha]\ \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) - 
                6\ \[Lambda]\ F\_1\%2\ \[Zeta]\_1\ 
                  \((F\_1)\)\_\(\[Zeta]\_1\) + 
                24\ \[Lambda]\ F\_1\ \[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\[Zeta]\_1\%2 - 
                24\ \[Lambda]\ \[Zeta]\_1\%3\ \((F\_1)\)\_\[Zeta]\_1\%3 - 
                4\ \[Alpha]\ \[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                12\ \[Lambda]\ F\_1\%2\ \[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                48\ \[Lambda]\ F\_1\ \[Zeta]\_1\%3\ 
                  \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                48\ \[Lambda]\ \[Zeta]\_1\%4\ \((F\_1)\)\_\[Zeta]\_1\%2\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the similarity reduction, the flux \[CapitalPhi] is separated from the \
similarity function ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  ". This function has to satisfy a non-linear second-order ODE which is not \
symbolically solvable by ",
  StyleBox["DSolve[]", "MmaText"],
  ". The examination of the symmetry reveals that this equation does not \
allow any point symmetry and thus Lie's integration strategy terminates:"
}], "Text",
  CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Infinitesimals[red1\[LeftDoubleBracket]3\[RightDoubleBracket], F1, 
        zeta1, {\[Lambda], \[Alpha]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{zeta1, 2}F1[zeta1]}] // LTF
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\[Phi]\_1 == 0\)},
          {\(\[Xi]\_1 == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 0]}]]], "Output"]
}, Open  ]],

Cell["\<\
The only way to study the equation is a numerical integration. \
Adding initial conditions to the second-order ODE and fixing the \
parameters,\
\>", "Text",
  CellTags->"numerical integration"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(1/2\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Lambda] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[TextData[
"allows us the numerical integration. We first fixed \[Lambda] describing the \
non-linear influence in the equation and changed \[Alpha] over a large \
range:"], "Text"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq\  /. \ \[Alpha] \[Rule] i, F1, {zeta1, 1, 15}], {i, 
          1, 50, 10}]; \)\)], "Input"],

Cell[TextData[
"The resulting solutions for different \[Alpha] and identical initial \
conditions are plotted below."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 15}, 
      PlotStyle \[Rule] \ Table[Hue[i], {i, 0,  .5,  .1}], 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 -0.157294 0.172009 [
[.15079 .00222 -3 -9 ]
[.15079 .00222 3 0 ]
[.27778 .00222 -3 -9 ]
[.27778 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.53175 .00222 -3 -9 ]
[.53175 .00222 3 0 ]
[.65873 .00222 -6 -9 ]
[.65873 .00222 6 0 ]
[.78571 .00222 -6 -9 ]
[.78571 .00222 6 0 ]
[.9127 .00222 -6 -9 ]
[.9127 .00222 6 0 ]
[1.025 .01472 0 -7.5 ]
[1.025 .01472 10 7.5 ]
[.01131 .10072 -18 -4.5 ]
[.01131 .10072 0 4.5 ]
[.01131 .18672 -6 -4.5 ]
[.01131 .18672 0 4.5 ]
[.01131 .27273 -18 -4.5 ]
[.01131 .27273 0 4.5 ]
[.01131 .35873 -6 -4.5 ]
[.01131 .35873 0 4.5 ]
[.01131 .44474 -18 -4.5 ]
[.01131 .44474 0 4.5 ]
[.01131 .53074 -6 -4.5 ]
[.01131 .53074 0 4.5 ]
[.01131 .61675 -18 -4.5 ]
[.01131 .61675 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 .01472 m
.15079 .02097 L
s
[(2)] .15079 .00222 0 1 Mshowa
.27778 .01472 m
.27778 .02097 L
s
[(4)] .27778 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(6)] .40476 .00222 0 1 Mshowa
.53175 .01472 m
.53175 .02097 L
s
[(8)] .53175 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(10)] .65873 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(12)] .78571 .00222 0 1 Mshowa
.9127 .01472 m
.9127 .02097 L
s
[(14)] .9127 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.18254 .01472 m
.18254 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.34127 .01472 m
.34127 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.81746 .01472 m
.81746 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .10072 m
.03006 .10072 L
s
[(1.5)] .01131 .10072 1 0 Mshowa
.02381 .18672 m
.03006 .18672 L
s
[(2)] .01131 .18672 1 0 Mshowa
.02381 .27273 m
.03006 .27273 L
s
[(2.5)] .01131 .27273 1 0 Mshowa
.02381 .35873 m
.03006 .35873 L
s
[(3)] .01131 .35873 1 0 Mshowa
.02381 .44474 m
.03006 .44474 L
s
[(3.5)] .01131 .44474 1 0 Mshowa
.02381 .53074 m
.03006 .53074 L
s
[(4)] .01131 .53074 1 0 Mshowa
.02381 .61675 m
.03006 .61675 L
s
[(4.5)] .01131 .61675 1 0 Mshowa
.125 Mabswid
.02381 .03192 m
.02756 .03192 L
s
.02381 .04912 m
.02756 .04912 L
s
.02381 .06632 m
.02756 .06632 L
s
.02381 .08352 m
.02756 .08352 L
s
.02381 .11792 m
.02756 .11792 L
s
.02381 .13512 m
.02756 .13512 L
s
.02381 .15232 m
.02756 .15232 L
s
.02381 .16952 m
.02756 .16952 L
s
.02381 .20392 m
.02756 .20392 L
s
.02381 .22113 m
.02756 .22113 L
s
.02381 .23833 m
.02756 .23833 L
s
.02381 .25553 m
.02756 .25553 L
s
.02381 .28993 m
.02756 .28993 L
s
.02381 .30713 m
.02756 .30713 L
s
.02381 .32433 m
.02756 .32433 L
s
.02381 .34153 m
.02756 .34153 L
s
.02381 .37593 m
.02756 .37593 L
s
.02381 .39313 m
.02756 .39313 L
s
.02381 .41033 m
.02756 .41033 L
s
.02381 .42754 m
.02756 .42754 L
s
.02381 .46194 m
.02756 .46194 L
s
.02381 .47914 m
.02756 .47914 L
s
.02381 .49634 m
.02756 .49634 L
s
.02381 .51354 m
.02756 .51354 L
s
.02381 .54794 m
.02756 .54794 L
s
.02381 .56514 m
.02756 .56514 L
s
.02381 .58234 m
.02756 .58234 L
s
.02381 .59954 m
.02756 .59954 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.0873 .01472 m
.12336 .06033 L
.16269 .10401 L
.19962 .14078 L
.23514 .17318 L
.27295 .20516 L
.30934 .23395 L
.34802 .26278 L
.38529 .28909 L
.42115 .31323 L
.45929 .33782 L
.49601 .36055 L
.53133 .38163 L
.56893 .40332 L
.60512 .42353 L
.64359 .44436 L
.68065 .46385 L
.7163 .4821 L
.75424 .50102 L
.79076 .5188 L
.82957 .53725 L
.86696 .55462 L
.90294 .57099 L
.94121 .58804 L
.97619 .60332 L
s
1 .6 0 r
.0873 .01472 m
.12336 .05829 L
.16269 .09771 L
.19962 .12998 L
.23514 .15799 L
.27295 .18535 L
.30934 .20981 L
.34802 .23417 L
.38529 .2563 L
.42115 .27656 L
.45929 .29713 L
.49601 .31611 L
.53133 .33368 L
.56893 .35173 L
.60512 .36852 L
.64359 .38582 L
.68065 .40198 L
.7163 .4171 L
.75424 .43278 L
.79076 .44749 L
.82957 .46274 L
.86696 .4771 L
.90294 .49062 L
.94121 .50469 L
.97619 .51731 L
s
.8 1 0 r
.0873 .01472 m
.12336 .0582 L
.16269 .09742 L
.19962 .12948 L
.23514 .15729 L
.27295 .18444 L
.30934 .20869 L
.34802 .23284 L
.38529 .25479 L
.42115 .27486 L
.45929 .29524 L
.49601 .31405 L
.53133 .33145 L
.56893 .34933 L
.60512 .36597 L
.64359 .3831 L
.68065 .3991 L
.7163 .41408 L
.75424 .4296 L
.79076 .44416 L
.82957 .45927 L
.86696 .47348 L
.90294 .48686 L
.94121 .5008 L
.97619 .51328 L
s
.2 1 0 r
.0873 .01472 m
.12336 .05816 L
.16269 .09732 L
.19962 .1293 L
.23514 .15704 L
.27295 .18411 L
.30934 .2083 L
.34802 .23238 L
.38529 .25425 L
.42115 .27426 L
.45929 .29458 L
.49601 .31332 L
.53133 .33067 L
.56893 .34848 L
.60512 .36506 L
.64359 .38214 L
.68065 .39809 L
.7163 .41301 L
.75424 .42847 L
.79076 .44299 L
.82957 .45804 L
.86696 .4722 L
.90294 .48554 L
.94121 .49942 L
.97619 .51186 L
s
0 1 .4 r
.0873 .01472 m
.12336 .05814 L
.16269 .09726 L
.19962 .12921 L
.23514 .15691 L
.27295 .18395 L
.30934 .2081 L
.34802 .23214 L
.38529 .25398 L
.42115 .27395 L
.45929 .29424 L
.49601 .31295 L
.53133 .33026 L
.56893 .34805 L
.60512 .3646 L
.64359 .38164 L
.68065 .39757 L
.7163 .41246 L
.75424 .4279 L
.79076 .44239 L
.82957 .45741 L
.86696 .47155 L
.90294 .48486 L
.94121 .49872 L
.97619 .51114 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OAgoo1@0097oo0`00
8Woo0`008Woo10007Woo1@000goo10006Woo1@000Woo1@006Woo1@001Goo0`00<goo0017Ool01@00
Oomoogoo00009Goo00<007ooOol087oo00D007ooOomoo`00021oo`03001oogoo009oo`03001oogoo
01eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo009oo`05001oogoo
Ool0000LOol00`00Oomoo`06Ool00`00Oomoo`0bOol004Qoo`03001oogoo02Ioo`03001oogoo021o
o`05001oogooOol0000POol00`00Oomoo`02Ool00`00Oomoo`0MOol00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`0IOol00`00Oomoo`03Ool00`00Oomoo`0MOol00`00Oomoo`06Ool00`00Oomo
o`0bOol004Uoo`03001oogoo025oo`H0025oo`05001oogooOol0000POol00`00Oomoo`02Ool00`00
Oomoo`0MOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0IOol00`00Oomoo`04Ool00`00
Oomoo`0LOol00`00Oomoo`02Ool6000cOol004Yoo`03001oogoo025oo`04001oogoo000ROol4000R
Ool4000POol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0IOol00`00Oomoo`05Ool00`00
Oomoo`0KOol00`00Oomoo`03Ool01000Oomoo`00=7oo001;Ool00`00Oomoo`0POol01000Oomoo`00
8Woo00<007ooOol08Woo00<007ooOol00Woo00<007ooOol07Goo00<007ooOol00Woo00<007ooOol0
0Woo00<007ooOol06Goo00<007ooOol01Woo00<007ooOol06Woo00<007ooOol00goo00@007ooOol0
03Aoo`00Agoo00D007ooOomoo`0002=oo`03001oo`0002=oo`03001oogoo025oo`03001oogoo009o
o`03001oogoo01]oo`<000Aoo`03001oogoo009oo`03001oogoo01Moo`<000Aoo`05001oogooOol0
000JOol30006Ool00`00Ool0000dOol004Qoo`<002Eoo`8002Aoo`<0025oo`@0021oo`03001oogoo
00=oo`@001aoo`03001oogoo00=oo`<001eoo`03001oogoo00Eoo`8003Aoo`00ogooJGoo003oOomY
Ool00?mooeAoo`@0015oo`0097oo00<007ooOol0ogoo;7oo00<007ooOol00Woo00<007ooOol03Woo
000TOol00`00Oomoo`3oOol^Ool3000AOol002Aoo`03001oogoo0?moobeoo`03001oogoo019oo`00
97oo00<007ooOol0ogoo;Goo00<007ooOol04Woo000MOolJ00000`?/0000003o000@000:Ool00`00
Oomoo`0BOol002Aoo`03001oogoo00Moo`03001oogoo00Ioo`030003k7oo00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo011oo`03001oogoo015oo`0097oo00<007ooOol04Woo00<3k7oo
Ool03Woo00<007ooOol08goo00<007ooOol08goo00<007ooOol08goo00<007ooOol08goo00<007oo
Ool08goo00<007ooOol08goo00<007ooOol097oo0`0047oo000TOol00`00Oomoo`0BOol00g`00nao
o`3oOolIOol20002Ool00`00Oomoo`0=Ool002Aoo`03001oogoo01=oo`030naoogoo0?mooaYoo`<0
00moo`0097oo0P005Goo00<3k7ooOol0ogoo:goo000TOol00`00Oomoo`0EOol00`?/Oomoo`3oOolZ
Ool002Aoo`03001oogoo01Ioo`030naoogoo0?moobUoo`0097oo00<007ooOol05Woo00=l00?/Ool0
ogoo:Goo000TOol00`00Oomoo`0GOol00g`00naoo`3oOolXOol002Aoo`8001Uoo`030naoogoo0?mo
obMoo`0097oo00<007ooOol06Goo00<3k7ooOol0ogoo9Woo000TOol00`00Oomoo`0IOol00g`00nao
o`3oOolVOol002Aoo`03001oogoo01Yoo`03O003k7oo0?moobEoo`0097oo00<007ooOol06goo00=l
00?/Ool0ogoo97oo000TOol00`00Oomoo`0LOol00g`00naoo`3oOolSOol002Aoo`8001ioo`03O003
k7oo0?moob9oo`0097oo00<007ooOol07Woo00=l00?/Ool0ogoo8Goo000TOol00`00Oomoo`0OOol0
0g`00naoo`3oOolPOol002Aoo`03001oogoo021oo`03O003k7oo0?mooamoo`0097oo00<007ooOol0
8Goo00=l00?/Ool0ogoo7Woo000TOol2000ROol00g`0Ool3k03oOolNOol002Aoo`03001oogoo029o
o`03O01oo`?/0?mooaeoo`002goo1@0017oo0P001Goo10001Goo00<007ooOol08goo00=l07oo0n`0
ogoo77oo000=Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`0TOol00g`0Ool3k03oOolKOol000eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo02Eo
o`03O01oo`?/0?mooaYoo`003Goo00<007ooOol03goo00<007ooOol00Woo0`009Woo00=l07oo0n`0
ogoo6Goo000=Ool00`00Oomoo`0;Ool40005Ool00`00Oomoo`0WOol017`0Ool3k0?/ogoo5goo000=
Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0XOol017`0Oomn@0?/ogoo5Woo000;Ool3
000=Ool00`00Oomoo`06Ool00`00Oomoo`0YOol017`0Oomn@0?/ogoo5Goo000=Ool00`00Oomoo`0;
Ool50004Ool00`00Oomoo`0ZOol017`0Oomn@0?/ogoo57oo000TOol2000/Ool017`0Oomoo`?/ogoo
4goo000TOol00`00Oomoo`0/Ool00g`0Oomoo`020ncoOolAOol002Aoo`03001oogoo02eoo`05O01o
ogooOT03k03oOol@Ool002Aoo`03001oogoo02ioo`05O01oogooOT03k03oOol?Ool002Aoo`03001o
ogoo02moo`05O01oogooOT03k03oOol>Ool002Aoo`80035oo`05O01oogooOT03k03oOol=Ool002Ao
o`03001oogoo035oo`05O01oogooOT03k03oOol<Ool002Aoo`03001oogoo039oo`05O01oogooOol3
k03oOol;Ool002Aoo`03001oogoo03=oo`04O01oogooOol20ncoOol9Ool002Aoo`03001oogoo03Ao
o`06O01oogooOomn@0?/ogoo27oo000TOol2000fOol01W`0OomoogooOT03k?moo`Moo`0097oo00<0
07ooOol0=Woo00=l07ooOol00Woo00<3k7ooOol0ogoo17oo000TOol00`00Oomoo`0gOol2O003Ool0
0`?/Oomoo`3oOol3Ool002Aoo`03001oogoo03Uoo`04O01oogooOol20ncoOol3Ool002Aoo`03001o
ogoo03Yoo`03O01oogoo009oo`030naoogoo0?moo`0097oo0P00?7oo00=l07ooOol00Woo0P?/ogoo
000TOol00`00Oomoo`0lOol00g`0Oomoo`03Ool00`?/Oomoo`3lOol001Yoo`D000Eoo`03001oogoo
03eoo`03O01oogoo00=oo`83k?aoo`006Woo00D007ooOomoo`0000Eoo`03001oogoo03ioo`03O01o
ogoo00Aoo`030naoogoo0?Uoo`006goo00<007ooOol01Woo00<007ooOol0?goo0W`01Goo0P?/nGoo
000LOol00`00Oomoo`05Ool30011Ool00g`0Oomoo`04Ool00`?/Oomoo`3fOol001eoo`03001oogoo
00Aoo`03001oogoo049oo`03O01oogoo00Aoo`83k?Ioo`007Woo00<007ooOol00goo00<007ooOol0
@goo00=l07ooOol01Goo00<3k7ooOol0lgoo000JOol01@00Oomoogoo00001Goo00<007ooOol0A7oo
00=l07ooOol01Goo0P?/lgoo000KOol30006Ool00`00Oomoo`15Ool2O007Ool20ncaOol002Aoo`03
001oogoo04Moo`03O01oogoo00Ioo`030naoogoo0>ioo`0097oo0P00BGoo00=l07ooOol01Woo0P?/
kWoo000TOol00`00Oomoo`19Ool00g`0Oomoo`07Ool00`?/Oomoo`3[Ool002Aoo`03001oogoo04Yo
o`9l00Qoo`83k>]oo`0097oo00<007ooOol0C7oo00=l07ooOol01goo00<3k7ooOol0j7oo000TOol0
0`00Oomoo`1=Ool00g`0Oomoo`07Ool20ncXOol002Aoo`8004moo`03O01oogoo00Moo`03OT03k0?/
0>Ioo`0097oo00<007ooOol0Cgoo00=l07ooOol027oo00=n@0?/Ool0i7oo000TOol00`00Oomoo`1@
Ool2O009Ool00gi00n`3k03SOol002Aoo`03001oogoo059oo`03O01oogoo00Moo`9n@0030naoogoo
0>1oo`0097oo00<007ooOol0Dgoo00=l07ooOol027oo00=n@0?/0n`0h7oo000TOol2001EOol2O009
Ool2OT000`?/Oomoo`3MOol002Aoo`03001oogoo05Ioo`03O01oogoo00Qoo`03OT03k0?/0=eoo`00
97oo00<007ooOol0Egoo00=l07ooOol02Goo00=n@0?/0n`0fgoo000TOol00`00Oomoo`1HOol2O00;
Ool00gi00naoo`3IOol002Aoo`03001oogoo05Yoo`03O01oogoo00Yoo`83k=Qoo`0097oo0P00G7oo
00=l07ooOol02goo00<3k7ooOol0eGoo000TOol00`00Oomoo`1LOol2O00<Ool20ncEOol000Yoo`D0
00Eoo`8000Eoo`@000Eoo`03001oogoo05ioo`03O01oogoo00]oo`83k==oo`002Woo00D007ooOomo
o`0000Eoo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo05moo`9l00eoo`83k=5o
o`002goo00<007ooOol04Goo00<007ooOol00Woo00<007ooOol0HGoo00=l07ooOol037oo0P?/cgoo
000<Ool00`00Oomoo`0@Ool00`00Oomoo`02Ool3001ROol00g`0Oomoo`0=Ool20nc=Ool000eoo`03
001oogoo00]oo`@000Eoo`03001oogoo06=oo`9l00moo`030naoogoo0<Yoo`003Woo00<007ooOol0
2Woo00<007ooOol01Woo00<007ooOol0IGoo00=l07ooOol03Goo0P?/bWoo000:Ool01@00Oomoogoo
000037oo00<007ooOol01Woo00<007ooOol0IWoo00=l07ooOol03Woo0P?/b7oo000;Ool3000=Ool5
0004Ool00`00Oomoo`1WOol2O00@Ool20nc6Ool002Aoo`8006Yoo`03O01oogoo00moo`83k<Aoo`00
97oo00<007ooOol0JWoo0W`04Goo0P?/`Woo000TOol00`00Oomoo`1/Ool00g`0Oomoo`0@Ool20nc0
Ool002Aoo`03001oogoo06eoo`9l015oo`03OT03k0?/0;ioo`0097oo00<007ooOol0Kgoo0W`04Goo
00=n@0?/0n`0_7oo000TOol2001bOol00g`0Oomoo`0@Ool00gi00n`3k02jOol002Aoo`03001oogoo
079oo`9l019oo`03OT03k0?/0;Qoo`0097oo00<007ooOol0M7oo00=l07ooOol04Goo00An@0?/0n`3
k;Eoo`0097oo00<007ooOol0MGoo0W`04goo00An@6OP0n`3k;=oo`0097oo00<007ooOol0Mgoo00=l
07ooOol04Woo00An@6OP0n`3k;5oo`0097oo00<007ooOol0N7oo00=l07ooOol04goo00An@6OP0n`3
k:moo`0097oo0P00NWoo0W`05Goo00An@6OP0n`3k:eoo`0097oo00<007ooOol0Ngoo00=l07ooOol0
57oo00An@6OP0n`3k:]oo`0097oo00<007ooOol0O7oo00=l07ooOol05Goo00An@6OP0n`3k:Uoo`00
97oo00<007ooOol0OGoo0W`05goo00An@6OP0n`3k:Moo`0097oo00<007ooOol0Ogoo00=l07ooOol0
5Woo00An@6OP0n`3k:Eoo`0097oo0P00PGoo0W`067oo00An@6OP0n`3k:=oo`0097oo00<007ooOol0
PWoo0W`067oo00An@6OP0n`3k:5oo`006goo0`001Woo00<007ooOol0Q7oo0W`067oo00An@6OP0n`3
k9moo`006Woo00D007ooOomoo`0000Eoo`03001oogoo08Ioo`9l01Qoo`9n@083k9eoo`007Woo00<0
07ooOol00goo00<007ooOol0R7oo0W`067oo0Wi00P?/Vgoo000NOol00`00Oomoo`03Ool3002:Ool0
0g`0Oomoo`0GOol2OT020nbIOol001aoo`8000Ioo`03001oogoo08]oo`9l01Uoo`9n@083k9Moo`00
7Woo00<007ooOol00goo00<007ooOol0SGoo00=l07ooOol067oo0Wi00`?/U7oo000JOol01@00Oomo
ogoo00001Goo00<007ooOol0SWoo0W`06Woo0gi00P?/TWoo000KOol30006Ool00`00Oomoo`2@Ool2
O00KOol2OT020nb@Ool002Aoo`8009=oo`03O01oogoo01Yoo`9n@083k8ioo`0097oo00<007ooOol0
Tgoo0W`077oo0Wi00P?/S7oo000TOol00`00Oomoo`2EOol00g`0Oomoo`0KOol2OT030nb9Ool002Ao
o`03001oogoo09Ioo`9l01eoo`=n@0<3k8Ioo`0097oo00<007ooOol0V7oo0W`07Woo0Wi000@Gh0?/
0n`3k8=oo`0097oo0P00Vgoo0W`07Woo0Wi00QOP0`?/P7oo000TOol00`00Oomoo`2LOol2O00NOol3
OT025n020nanOol002Aoo`03001oogoo09ioo`9l01moo`9n@08Gh083k7aoo`0097oo00<007ooOol0
X7oo00=l07ooOol07Woo0gi000<Gh0?/0n`0NWoo000TOol00`00Oomoo`2QOol2O00QOol2OT000aOP
0n`3k01hOol002Aoo`800:Aoo`9l025oo`=n@083k7Ioo`0097oo00<007ooOol0YGoo0W`08Woo0Wi0
0`?/Lgoo000TOol00`00Oomoo`2WOol2O00ROol3OT020naaOol002Aoo`03001oogoo0:Uoo`9l02=o
o`9n@083k6moo`0097oo00<007ooOol0Zgoo00=l07ooOol08Woo0Wi00`?/K7oo000TOol2002]Ool2
O00TOol3OT020naZOol002Aoo`03001oogoo0:ioo`9l02Eoo`9n@0<3k6Moo`0097oo00<007ooOol0
/7oo0W`09Goo0gi00P?/IGoo000;Ool30006Ool20005Ool40005Ool00`00Oomoo`2bOol2O00VOol2
OT030naROol000Yoo`05001oogooOol00005Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`2dOol2O00VOol3OT020naPOol000ioo`03001oogoo00ioo`03001oogoo009oo`03001o
ogoo0;Ioo`03O01oogoo02Ioo`9n@0<3k5eoo`003Woo00<007ooOol03Woo00<007ooOol00Woo0`00
]goo0W`0:7oo0gi00`?/FWoo000<Ool2000=Ool40005Ool00`00Oomoo`2iOol2O00YOol2OT0011OP
0n`3k0?/Egoo000>Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool00`00Oomoo`2kOol2O00YOol2OT02
5n030naDOol000Yoo`05001oogooOol0000<Ool00`00Oomoo`06Ool00`00Oomoo`2mOol2O00YOol3
OT025n030naAOol000]oo`<000eoo`D000Aoo`03001oogoo0;moo`9l02Yoo`9n@0<Gh083k4moo`00
97oo0P00`Woo0W`0:Woo0gi00QOP0P?/CGoo000TOol00`00Oomoo`33Ool2O00[Ool3OT000aOP0n`3
k01;Ool002Aoo`03001oogoo0<Eoo`9l02aoo`9n@0035n03k0?/04Uoo`0097oo00<007ooOol0agoo
00=l07ooOol0:goo0gi00`?/AWoo000TOol00`00Oomoo`38Ool2O00^Ool3OT030na3Ool002Aoo`80
0<]oo`9l02moo`=n@083k45oo`0097oo00<007ooOol0c7oo0W`0<7oo0Wi00`?/?Woo000TOol00`00
Oomoo`3>Ool2O00`Ool3OT030n`kOol002Aoo`03001oogoo0=1oo`9l035oo`=n@0<3k3Qoo`0097oo
00<007ooOol0dWoo0g`0<Goo0gi00P?/=Woo000TOol2003FOol2O00bOol2OT030n`cOol002Aoo`03
001oogoo0=Moo`9l039oo`=n@0<3k31oo`0097oo00<007ooOol0fGoo0W`0<goo0gi010?/;7oo000T
Ool00`00Oomoo`3KOol2O00dOol3OT000aOP0n`3k0020n`XOol002Aoo`03001oogoo0=eoo`03O01o
ogoo03Aoo`9n@0<Gh083k2Ioo`0097oo0P00ggoo0W`0=Woo0gi00QOP9Woo000TOol00`00Oomoo`3P
Ool2O00gOol2OT0VOol001eoo`<000Aoo`03001oogoo0>9oo`9l05eoo`007Woo00<007ooOol00goo
00<007ooOol0i7oo0W`0Fgoo000NOol00`00Oomoo`03Ool00`00Oomoo`3VOol2O01IOol001Yoo`H0
00Aoo`<00>Qoo`=l05Ioo`006goo00@007ooOol000Eoo`03001oogoo0>]oo`9l05Aoo`006goo00@0
07ooOol000Eoo`03001oogoo0>eoo`=l055oo`0077oo00<007oo00001Goo00<007ooOol0l7oo0W`0
Cgoo000MOol20005Ool00`00Oomoo`3bOol2O01=Ool002Aoo`800?Eoo`9l04]oo`0097oo00<007oo
Ool0mWoo0W`0BGoo000TOol00`00Oomoo`3hOol3O016Ool002Aoo`03001oogoo0?]oo`9l04Aoo`00
97oo00<007ooOol0oGoo0W`0@Woo000TOol2003oOol1Ool2O010Ool002Aoo`03001oogoo0?moo`9o
o`9l03ioo`0097oo00<007ooOol0ogoo17oo0g`0>goo000TOol00`00Oomoo`3oOol7Ool2O00iOol0
02Aoo`03001oogoo0?moo`Uoo`9l03Moo`0097oo00<007ooOol0ogoo2goo0W`0=Goo000TOol2003o
Ool>Ool2O00cOol002Aoo`03001oogoo0?moo`moo`=l031oo`0097oo00<007ooOol0ogoo4Woo0W`0
;Woo000TOol00`00Oomoo`3oOolDOol2O00/Ool002Aoo`03001oogoo0?mooaIoo`9l02Yoo`0097oo
0P00ogoo6Goo0W`0:7oo000TOol00`00Oomoo`3oOolJOol2O00VOol000eoo`<000Aoo`8000Eoo`@0
00Eoo`03001oogoo0?mood9oo`003Woo00<007ooOol00goo0P0017oo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol0ogoo@Woo000>Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00`00Oomoo`3o
Oom2Ool000Yoo`H000moo`03001oogoo009oo`<00?mood9oo`002goo00@007ooOol000aoo`@00?mo
odYoo`002goo00@007ooOol000aoo`03001oogoo0?mood]oo`0037oo00<007oo000037oo00<007oo
Ool0ogooBgoo000=Ool2000<Ool5003oOom9Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUo
o`00ogooJGoo003oOomYOol00?moofUoo`009Goo1@00ogoo?goo000WOol00`00Oomoo`3oOoloOol0
01moo`<000Eoo`03001oogoo0?moocmoo`0087oo00<007ooOol017oo00<007ooOol0ogoo?goo000P
Ool00`00Oomoo`04Ool00`00Oomoo`3oOoloOol0021oo`03001oo`0000=oo`800?mood5oo`0087oo
0`00ogooAWoo000POol00`00Ool0003oOom6Ool0021oo`05001oogooOol0003oOom4Ool001moo`H0
0?moodAoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00001\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-1.94434, 0.708337, \
0.0659233, 0.0243337}}]
}, Open  ]],

Cell[TextData[
"We observe that the solution shows an increasing behavior in \[Zeta]. By \
increasing the dispersive strength \[Alpha] in the ODE, the solutions \
decrease in their values and tend to a limiting curve. The other behavior \
studied under identical initial conditions is the variation of the non-linear \
strength \[Lambda] at a fixed value of \[Alpha]. The equations plus initial \
conditions are created by"], "Text",
  CellTags->"nonlinear strength"],

Cell[BoxData[
    RowBox[{
      RowBox[{"neq", " ", "=", " ", 
        RowBox[{
          RowBox[{"Join", "[", 
            RowBox[{\(red1\[LeftDoubleBracket]3\[RightDoubleBracket]\), ",", 
              RowBox[{"{", 
                RowBox[{\(F1[1] == 1\), ",", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["F1", "\[Prime]",
                        MultilineFunction->None], "[", "1", "]"}], "==", 
                    \(1/2\)}]}], "}"}]}], "]"}], "/.", 
          \({\[Alpha] \[Rule] 1}\)}]}], ";"}]], "Input"],

Cell[TextData[
"The variation of \[Lambda] in the integration process delivers the \
solutions"], "Text"],

Cell[BoxData[
    \(\(nsol\  = \ 
      Table[NDSolve[neq\  /. \ \[Lambda] \[Rule] i, F1, {zeta1, 1, 15}], {i, 
          1, 50, 10}]; \)\)], "Input"],

Cell[TextData["which are plotted over \[Zeta] by"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[F1[\[Zeta]] /. nsol], {\[Zeta], 1, 15}, 
      PlotStyle \[Rule] \ Table[Hue[i], {i, 0,  .5,  .1}], 
      AxesLabel \[Rule] {"\<\[Zeta]\>", \*"\"\<\!\(F\_1\)\>\""}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0634921 -0.157294 0.172009 [
[.15079 .00222 -3 -9 ]
[.15079 .00222 3 0 ]
[.27778 .00222 -3 -9 ]
[.27778 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.53175 .00222 -3 -9 ]
[.53175 .00222 3 0 ]
[.65873 .00222 -6 -9 ]
[.65873 .00222 6 0 ]
[.78571 .00222 -6 -9 ]
[.78571 .00222 6 0 ]
[.9127 .00222 -6 -9 ]
[.9127 .00222 6 0 ]
[1.025 .01472 0 -7.5 ]
[1.025 .01472 10 7.5 ]
[.01131 .10072 -18 -4.5 ]
[.01131 .10072 0 4.5 ]
[.01131 .18672 -6 -4.5 ]
[.01131 .18672 0 4.5 ]
[.01131 .27273 -18 -4.5 ]
[.01131 .27273 0 4.5 ]
[.01131 .35873 -6 -4.5 ]
[.01131 .35873 0 4.5 ]
[.01131 .44474 -18 -4.5 ]
[.01131 .44474 0 4.5 ]
[.01131 .53074 -6 -4.5 ]
[.01131 .53074 0 4.5 ]
[.01131 .61675 -18 -4.5 ]
[.01131 .61675 0 4.5 ]
[.02381 .64303 -7.5 0 ]
[.02381 .64303 7.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15079 .01472 m
.15079 .02097 L
s
[(2)] .15079 .00222 0 1 Mshowa
.27778 .01472 m
.27778 .02097 L
s
[(4)] .27778 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(6)] .40476 .00222 0 1 Mshowa
.53175 .01472 m
.53175 .02097 L
s
[(8)] .53175 .00222 0 1 Mshowa
.65873 .01472 m
.65873 .02097 L
s
[(10)] .65873 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(12)] .78571 .00222 0 1 Mshowa
.9127 .01472 m
.9127 .02097 L
s
[(14)] .9127 .00222 0 1 Mshowa
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.18254 .01472 m
.18254 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.34127 .01472 m
.34127 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.81746 .01472 m
.81746 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .10072 m
.03006 .10072 L
s
[(1.5)] .01131 .10072 1 0 Mshowa
.02381 .18672 m
.03006 .18672 L
s
[(2)] .01131 .18672 1 0 Mshowa
.02381 .27273 m
.03006 .27273 L
s
[(2.5)] .01131 .27273 1 0 Mshowa
.02381 .35873 m
.03006 .35873 L
s
[(3)] .01131 .35873 1 0 Mshowa
.02381 .44474 m
.03006 .44474 L
s
[(3.5)] .01131 .44474 1 0 Mshowa
.02381 .53074 m
.03006 .53074 L
s
[(4)] .01131 .53074 1 0 Mshowa
.02381 .61675 m
.03006 .61675 L
s
[(4.5)] .01131 .61675 1 0 Mshowa
.125 Mabswid
.02381 .03192 m
.02756 .03192 L
s
.02381 .04912 m
.02756 .04912 L
s
.02381 .06632 m
.02756 .06632 L
s
.02381 .08352 m
.02756 .08352 L
s
.02381 .11792 m
.02756 .11792 L
s
.02381 .13512 m
.02756 .13512 L
s
.02381 .15232 m
.02756 .15232 L
s
.02381 .16952 m
.02756 .16952 L
s
.02381 .20392 m
.02756 .20392 L
s
.02381 .22113 m
.02756 .22113 L
s
.02381 .23833 m
.02756 .23833 L
s
.02381 .25553 m
.02756 .25553 L
s
.02381 .28993 m
.02756 .28993 L
s
.02381 .30713 m
.02756 .30713 L
s
.02381 .32433 m
.02756 .32433 L
s
.02381 .34153 m
.02756 .34153 L
s
.02381 .37593 m
.02756 .37593 L
s
.02381 .39313 m
.02756 .39313 L
s
.02381 .41033 m
.02756 .41033 L
s
.02381 .42754 m
.02756 .42754 L
s
.02381 .46194 m
.02756 .46194 L
s
.02381 .47914 m
.02756 .47914 L
s
.02381 .49634 m
.02756 .49634 L
s
.02381 .51354 m
.02756 .51354 L
s
.02381 .54794 m
.02756 .54794 L
s
.02381 .56514 m
.02756 .56514 L
s
.02381 .58234 m
.02756 .58234 L
s
.02381 .59954 m
.02756 .59954 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -68.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.0873 .01472 m
.12336 .06033 L
.16269 .10401 L
.19962 .14078 L
.23514 .17318 L
.27295 .20516 L
.30934 .23395 L
.34802 .26278 L
.38529 .28909 L
.42115 .31323 L
.45929 .33782 L
.49601 .36055 L
.53133 .38163 L
.56893 .40332 L
.60512 .42353 L
.64359 .44436 L
.68065 .46385 L
.7163 .4821 L
.75424 .50102 L
.79076 .5188 L
.82957 .53725 L
.86696 .55462 L
.90294 .57099 L
.94121 .58804 L
.97619 .60332 L
s
1 .6 0 r
.0873 .01472 m
.12336 .06023 L
.16269 .10335 L
.19962 .13928 L
.23514 .17074 L
.27295 .20162 L
.30934 .22933 L
.34802 .25699 L
.38529 .28218 L
.42115 .30525 L
.45929 .32872 L
.49601 .35038 L
.53133 .37045 L
.56893 .39109 L
.60512 .4103 L
.64359 .43009 L
.68065 .44859 L
.7163 .46591 L
.75424 .48387 L
.79076 .50072 L
.82957 .51821 L
.86696 .53467 L
.90294 .55017 L
.94121 .56631 L
.97619 .58078 L
s
.8 1 0 r
.0873 .01472 m
.12336 .06016 L
.16269 .10296 L
.19962 .1385 L
.23514 .16955 L
.27295 .2 L
.30934 .22729 L
.34802 .25452 L
.38529 .2793 L
.42115 .302 L
.45929 .32507 L
.49601 .34636 L
.53133 .36609 L
.56893 .38637 L
.60512 .40524 L
.64359 .42468 L
.68065 .44286 L
.7163 .45987 L
.75424 .4775 L
.79076 .49405 L
.82957 .51122 L
.86696 .52738 L
.90294 .54259 L
.94121 .55844 L
.97619 .57264 L
s
.2 1 0 r
.0873 .01472 m
.12336 .0601 L
.16269 .10269 L
.19962 .13797 L
.23514 .16876 L
.27295 .19895 L
.30934 .22598 L
.34802 .25295 L
.38529 .27749 L
.42115 .29995 L
.45929 .32279 L
.49601 .34387 L
.53133 .36338 L
.56893 .38345 L
.60512 .40212 L
.64359 .42136 L
.68065 .43934 L
.7163 .45616 L
.75424 .4736 L
.79076 .48998 L
.82957 .50696 L
.86696 .52294 L
.90294 .53799 L
.94121 .55367 L
.97619 .56771 L
s
0 1 .4 r
.0873 .01472 m
.12336 .06005 L
.16269 .10247 L
.19962 .13757 L
.23514 .16818 L
.27295 .19817 L
.30934 .22503 L
.34802 .25181 L
.38529 .27617 L
.42115 .29847 L
.45929 .32114 L
.49601 .34207 L
.53133 .36144 L
.56893 .38136 L
.60512 .39989 L
.64359 .41898 L
.68065 .43682 L
.7163 .45352 L
.75424 .47083 L
.79076 .48708 L
.82957 .50393 L
.86696 .51979 L
.90294 .53472 L
.94121 .55027 L
.97619 .56421 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OAgoo1@0097oo0`00
8Woo0`008Woo10007Woo1@000goo10006Woo1@000Woo1@006Woo1@001Goo0`00<goo0017Ool01@00
Oomoogoo00009Goo00<007ooOol087oo00D007ooOomoo`00021oo`03001oogoo009oo`03001oogoo
01eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo009oo`05001oogoo
Ool0000LOol00`00Oomoo`06Ool00`00Oomoo`0bOol004Qoo`03001oogoo02Ioo`03001oogoo021o
o`05001oogooOol0000POol00`00Oomoo`02Ool00`00Oomoo`0MOol00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`0IOol00`00Oomoo`03Ool00`00Oomoo`0MOol00`00Oomoo`06Ool00`00Oomo
o`0bOol004Uoo`03001oogoo025oo`H0025oo`05001oogooOol0000POol00`00Oomoo`02Ool00`00
Oomoo`0MOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0IOol00`00Oomoo`04Ool00`00
Oomoo`0LOol00`00Oomoo`02Ool6000cOol004Yoo`03001oogoo025oo`04001oogoo000ROol4000R
Ool4000POol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0IOol00`00Oomoo`05Ool00`00
Oomoo`0KOol00`00Oomoo`03Ool01000Oomoo`00=7oo001;Ool00`00Oomoo`0POol01000Oomoo`00
8Woo00<007ooOol08Woo00<007ooOol00Woo00<007ooOol07Goo00<007ooOol00Woo00<007ooOol0
0Woo00<007ooOol06Goo00<007ooOol01Woo00<007ooOol06Woo00<007ooOol00goo00@007ooOol0
03Aoo`00Agoo00D007ooOomoo`0002=oo`03001oo`0002=oo`03001oogoo025oo`03001oogoo009o
o`03001oogoo01]oo`<000Aoo`03001oogoo009oo`03001oogoo01Moo`<000Aoo`05001oogooOol0
000JOol30006Ool00`00Ool0000dOol004Qoo`<002Eoo`8002Aoo`<0025oo`@0021oo`03001oogoo
00=oo`@001aoo`03001oogoo00=oo`<001eoo`03001oogoo00Eoo`8003Aoo`00ogooJGoo003oOomY
Ool00?mooeAoo`@0015oo`0097oo00<007ooOol0ogoo;7oo00<007ooOol00Woo00<007ooOol03Woo
000TOol00`00Oomoo`3oOol^Ool3000AOol002Aoo`03001oogoo0?moobeoo`03001oogoo019oo`00
97oo00<007ooOol0ogoo;Goo00<007ooOol04Woo000MOolJ00000`?/0000003o000@000:Ool00`00
Oomoo`0BOol002Aoo`03001oogoo00Moo`03001oogoo00Ioo`030003k7oo00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo011oo`03001oogoo015oo`0097oo00<007ooOol04Woo00<3k7oo
Ool03Woo00<007ooOol08goo00<007ooOol08goo00<007ooOol08goo00<007ooOol08goo00<007oo
Ool08goo00<007ooOol08goo00<007ooOol097oo0`0047oo000TOol00`00Oomoo`0BOol00`?/Oomo
o`3oOolIOol20002Ool00`00Oomoo`0=Ool002Aoo`03001oogoo01=oo`030naoogoo0?mooaYoo`<0
00moo`0097oo0P005Goo00<3k7ooOol0ogoo:goo000TOol00`00Oomoo`0EOol00`?/Oomoo`3oOolZ
Ool002Aoo`03001oogoo01Ioo`030naoogoo0?moobUoo`0097oo00<007ooOol05Woo00<3k7ooOol0
ogoo:Goo000TOol00`00Oomoo`0GOol00`?/Oomoo`3oOolXOol002Aoo`8001Uoo`030naoogoo0?mo
obMoo`0097oo00<007ooOol06Goo00<3k7ooOol0ogoo9Woo000TOol00`00Oomoo`0IOol00`?/Oomo
o`3oOolVOol002Aoo`03001oogoo01Yoo`030naoogoo0?moobEoo`0097oo00<007ooOol06goo00<3
k7ooOol0ogoo97oo000TOol00`00Oomoo`0LOol00`?/Oomoo`3oOolSOol002Aoo`8001ioo`030nao
ogoo0?moob9oo`0097oo00<007ooOol07Woo00<3k7ooOol0ogoo8Goo000TOol00`00Oomoo`0OOol0
0`?/Oomoo`3oOolPOol002Aoo`03001oogoo021oo`030naoogoo0?mooamoo`0097oo00<007ooOol0
8Goo00<3k7ooOol0ogoo7Woo000TOol2000ROol00gi00naoo`3oOolNOol002Aoo`03001oogoo029o
o`03OT03k7oo0?mooaeoo`002goo1@0017oo0P001Goo10001Goo00<007ooOol08goo00=n@0?/Ool0
ogoo77oo000=Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`0TOol00gi00naoo`3oOolKOol000eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo02Eo
o`03OT03k7oo0?mooaYoo`003Goo00<007ooOol03goo00<007ooOol00Woo0`009Woo00=n@0?/Ool0
ogoo6Goo000=Ool00`00Oomoo`0;Ool40005Ool00`00Oomoo`0WOol00gi00naoo`3oOolHOol000eo
o`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo02Qoo`03OT03k7oo0?mooaMoo`002goo0`00
3Goo00<007ooOol01Woo00<007ooOol0:Goo00=n@0?/Ool0ogoo5Woo000=Ool00`00Oomoo`0;Ool5
0004Ool00`00Oomoo`0ZOol00gi00naoo`3oOolEOol002Aoo`8002aoo`03OT03k7oo0?mooaAoo`00
97oo00<007ooOol0;7oo00=n@0?/Ool0ogoo4goo000TOol00`00Oomoo`0]Ool00g`00naoo`3oOolB
Ool002Aoo`03001oogoo02ioo`03O003k7oo0?mooa5oo`0097oo00<007ooOol0;goo00=l00?/Ool0
ogoo47oo000TOol2000aOol00g`00naoo`3oOol?Ool002Aoo`03001oogoo035oo`03O003k7oo0?mo
o`ioo`0097oo00<007ooOol0<Woo00=l00?/Ool0ogoo3Goo000TOol00`00Oomoo`0cOol00g`00nao
o`3oOol<Ool002Aoo`03001oogoo03Aoo`03O003k7oo0?moo`]oo`0097oo0P00=Woo00=l00?/Ool0
ogoo2Woo000TOol00`00Oomoo`0fOol00g`00n`3k03oOol9Ool002Aoo`03001oogoo03Moo`03O01n
@0?/0?moo`Qoo`0097oo00<007ooOol0>Goo00=n@0?/Ool0ogoo1Woo000TOol00`00Oomoo`0jOol0
0gi00naoo`3oOol5Ool002Aoo`8003aoo`03OT03k7oo0?moo`Aoo`0097oo00<007ooOol0?7oo00=n
@0?/Ool0ogoo0goo000JOol50005Ool00`00Oomoo`0mOol00gi00n`3k03oOol2Ool001Yoo`05001o
ogooOol00005Ool00`00Oomoo`0nOol2OT000`?/Oomoo`3nOol001]oo`03001oogoo00Ioo`03001o
ogoo03moo`03O01n@0?/0?moo`0077oo00<007ooOol01Goo0`00@Goo00=n@0?/0n`0oGoo000MOol0
0`00Oomoo`04Ool00`00Oomoo`12Ool2OT000`?/Oomoo`3jOol001ioo`03001oogoo00=oo`03001o
ogoo04=oo`03O01n@0?/0?]oo`006Woo00D007ooOomoo`0000Eoo`03001oogoo04Aoo`04O01n@0?/
0nciOol001]oo`<000Ioo`03001oogoo04Eoo`04O01n@7i00nchOol002Aoo`03001oogoo04Moo`04
O01n@0?/0ncfOol002Aoo`8004Uoo`04O01n@6OP0nceOol002Aoo`03001oogoo04Uoo`04O01oogi0
0ncdOol002Aoo`03001oogoo04Yoo`9l0003OT03k0?/0?9oo`0097oo00<007ooOol0C7oo00Al07i0
In03k?5oo`0097oo00<007ooOol0CGoo00Al07ooIn03k?1oo`0097oo0P00Cgoo00=l07ooIn000P?/
kWoo000TOol00`00Oomoo`1?Ool01G`0Oomn@6OP0n`0kGoo000TOol00`00Oomoo`1@Ool2O00017oo
In03k0?/jgoo000TOol00`00Oomoo`1BOol01G`0OomWh6OP0n`0jWoo000TOol00`00Oomoo`1COol0
1G`0OomoofOP0n`0jGoo000TOol2001EOol2O00017ooIn03k0?/igoo000TOol00`00Oomoo`1FOol0
1G`0OomWh6OP0n`0iWoo000TOol00`00Oomoo`1GOol01G`0OomoofOP0n`0iGoo000TOol00`00Oomo
o`1HOol2O00017ooIn03k0?/hgoo000TOol00`00Oomoo`1JOol01G`0OomWh6OP0n`0hWoo000TOol2
001LOol017`0OomoofOP0P?/h7oo000TOol00`00Oomoo`1LOol2O00017ooIn1Wh0?/ggoo000:Ool5
0005Ool20005Ool40005Ool00`00Oomoo`1NOol017`0OomoofOP0P?/gGoo000:Ool01@00Oomoogoo
00001Goo0P0017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Ggoo0W`000=oofOP5n00
0P?/fgoo000;Ool00`00Oomoo`0AOol00`00Oomoo`02Ool00`00Oomoo`1QOol01W`0Oomn@6OP5n03
k=Yoo`0037oo00<007ooOol047oo00<007ooOol00Woo0`00HWoo00El07ooOomn@1OP0083k=Qoo`00
3Goo00<007ooOol02goo10001Goo00<007ooOol0Hgoo0W`000Eoogi05n0Gh0?/0=Moo`003Woo00<0
07ooOol02Woo00<007ooOol01Woo00<007ooOol0IGoo00El07ooOT1n@1OP0083k=Eoo`002Woo00D0
07ooOomoo`0000aoo`03001oogoo00Ioo`03001oogoo06Ioo`04O01oogooOT025n000`?/Oomoo`3B
Ool000]oo`<000eoo`D000Aoo`03001oogoo06Moo`9l0004Oomn@7i05n020ncBOol002Aoo`8006Yo
o`06O01oogooOT1Wh1OP0P?/d7oo000TOol00`00Oomoo`1ZOol2O0001WooOT1n@6OP5n03k<moo`00
97oo00<007ooOol0K7oo00=l07ooOol00Wi000=Wh0?/0n`0cGoo000TOol00`00Oomoo`1]Ool2O002
Ool017i0In1Wh0?/c7oo000TOol00`00Oomoo`1_Ool2O00017ooOT1n@6OP0P?/bWoo000TOol2001b
Ool017`0Oomoogi00VOP00<3k7ooOol0agoo000TOol00`00Oomoo`1bOol2O00017ooOT1n@6OP0P?/
agoo000TOol00`00Oomoo`1dOol017`0Oomoogi00VOP0P?/aGoo000TOol00`00Oomoo`1eOol2O000
0gooOT1n@002In000`?/Oomoo`32Ool002Aoo`03001oogoo07Moo`03O01oogoo009n@003In03k0?/
0<9oo`0097oo00<007ooOol0N7oo00El07ooOomoogi0009Wh0030naoogoo0;moo`0097oo0P00NWoo
0W`00Woo0Wi000=Wh0?/0n`0_goo000TOol00`00Oomoo`1kOol01G`0OomoogooOT000VOP0P?/_Goo
000TOol00`00Oomoo`1lOol017`0Oomoogoo0Wi00VOP0P?/^goo000TOol00`00Oomoo`1mOol2O003
Ool2OT02In020nbiOol002Aoo`03001oogoo07moo`03O01oogoo009oo`9n@09Wh083k;Moo`0097oo
0P00PGoo0W`017oo0Wi00VOP00<3k7ooOol0]7oo000TOol00`00Oomoo`22Ool2O004Ool2OT000fOP
0n`3k02dOol001]oo`<000Ioo`03001oogoo08Aoo`9l00Aoo`03OT1Wh6OP0083k;9oo`006Woo00D0
07ooOomoo`0000Eoo`03001oogoo08Ioo`9l00=oo`9n@09Wh083k;1oo`007Woo00<007ooOol00goo
00<007ooOol0R7oo0W`00goo0Wi00VOP0P?/[Woo000NOol00`00Oomoo`03Ool3002:Ool00g`0Oomo
o`02Ool2OT02In020nb/Ool001aoo`8000Ioo`03001oogoo08]oo`9l00Aoo`9n@09Wh0030naoogoo
0:Uoo`007Woo00<007ooOol00goo00<007ooOol0SGoo00=l07ooOol00goo0Wi000=Wh0?/0n`0ZGoo
000JOol01@00Oomoogoo00001Goo00<007ooOol0SWoo0W`01Goo00=n@6OPIn000P?/Ygoo000KOol3
0006Ool00`00Oomoo`2@Ool2O004Ool2OT02In020nbUOol002Aoo`8009=oo`03O01oogoo00=oo`04
OT1oofOPIn020nbSOol002Aoo`03001oogoo09=oo`9l00Aoo`9n@003OomWh6OP0083k:5oo`0097oo
00<007ooOol0UGoo00=l07ooOol00goo0Wi000=oofOPIn000P?/Wgoo000TOol00`00Oomoo`2FOol2
O005Ool01Gi0OomoofOP5n000P?/WGoo000TOol00`00Oomoo`2HOol2O004Ool2OT0017ooIn1Wh1OP
0P?/Vgoo000TOol2002KOol2O004Ool2OT0017ooIn1Wh1OP0P?/VGoo000TOol00`00Oomoo`2LOol2
O004Ool2OT0017ooIn1Wh1OP0P?/Ugoo000TOol00`00Oomoo`2NOol2O004Ool2OT0017ooIn1Wh1OP
0P?/UGoo000TOol00`00Oomoo`2POol00g`0Oomoo`03Ool2OT0017ooIn1Wh1OP0P?/Tgoo000TOol0
0`00Oomoo`2QOol2O005Ool2OT0017ooIn0Gh1OP0P?/TGoo000TOol2002TOol2O005Ool2OT02In02
5n020nb?Ool002Aoo`03001oogoo0:Eoo`9l00Eoo`9n@09Wh08Gh083k8eoo`0097oo00<007ooOol0
Ygoo0W`01Goo0Wi00VOP0QOP0P?/Rgoo000TOol00`00Oomoo`2YOol2O005Ool2OT02In025n020nb9
Ool002Aoo`03001oogoo0:]oo`03O01oogoo00Aoo`9n@09Wh08Gh083k8Moo`0097oo0P00[Goo0W`0
1Woo0Wi00VOP0QOP0P?/QGoo000TOol00`00Oomoo`2^Ool2O006Ool017i0OomWh6OP0QOP0`?/PWoo
000TOol00`00Oomoo`2`Ool2O005Ool2OT000gooIn1Wh0035n020nb0Ool000]oo`<000Ioo`8000Eo
o`@000Eoo`03001oogoo0;9oo`9l00Eoo`9n@004OomWh6OPIn025n020nanOol000Yoo`05001oogoo
Ool00005Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`2dOol2O005Ool2OT02
Ool2In025n020nalOol000ioo`03001oogoo00ioo`03001oogoo009oo`03001oogoo0;Ioo`03O01o
ogoo00Aoo`9n@09oo`9Wh08Gh083k7Yoo`003Woo00<007ooOol03Woo00<007ooOol00Woo0`00]goo
0W`01Woo0Wi00Woo0VOP0QOP0P?/N7oo000<Ool2000=Ool40005Ool00`00Oomoo`2iOol2O006Ool2
OT02Ool2In025n020nafOol000ioo`03001oogoo00Yoo`03001oogoo00Ioo`03001oogoo0;]oo`9l
00Ioo`9n@09oo`9Wh08Gh0<3k7=oo`002Woo00D007ooOomoo`0000aoo`03001oogoo00Ioo`03001o
ogoo0;eoo`9l00Ioo`9n@09oo`9Wh0<Gh083k75oo`002goo0`003Goo1@0017oo00<007ooOol0_goo
0W`01Woo0Wi00Woo0fOP0QOP0P?/Kgoo000TOol20032Ool2O006Ool2OT03Ool2In025n030na/Ool0
02Aoo`03001oogoo0<=oo`9l00Ioo`=n@09oo`9Wh0<Gh083k6Yoo`0097oo00<007ooOol0aGoo0W`0
1goo0Wi00Woo0fOP0QOP0P?/J7oo000TOol00`00Oomoo`37Ool00g`0Oomoo`06Ool2OT03Ool2In02
5n020naVOol002Aoo`03001oogoo0<Qoo`9l00Qoo`=n@09oo`9Wh08Gh083k6Aoo`0097oo0P00bgoo
0W`02Goo0Wi00Woo0VOP0QOP0P?/HWoo000TOol00`00Oomoo`3<Ool2O009Ool2OT02Ool2In025n02
0naPOol002Aoo`03001oogoo0<ioo`9l00Uoo`9n@09oo`9Wh08Gh0<3k5eoo`0097oo00<007ooOol0
d7oo0W`02Goo0Wi00Woo0VOP0aOP0P?/Fgoo000TOol00`00Oomoo`3BOol3O008Ool2OT02Ool3In02
5n020naIOol002Aoo`800=Ioo`9l00Qoo`9n@0=oo`9Wh08Gh0<3k5Ioo`0097oo00<007ooOol0egoo
0W`027oo0gi00Woo0VOP0aOP0P?/E7oo000TOol00`00Oomoo`3IOol2O009Ool2OT02Ool3In025n03
0naAOol002Aoo`03001oogoo0=]oo`9l00Uoo`9n@0=oo`9Wh0<Gh083k4moo`0097oo00<007ooOol0
gGoo00=l07ooOol027oo0gi00Woo0fOP0QOP0P?/CGoo000TOol2003OOol2O00;Ool2OT03Ool2In02
5n020na;Ool002Aoo`03001oogoo0>1oo`9l00]oo`=n@09oo`9Wh08Gh083k4Uoo`007Goo0`0017oo
00<007ooOol0hWoo0W`037oo0Wi00Woo0VOP0QOP0`?/AWoo000NOol00`00Oomoo`03Ool00`00Oomo
o`3TOol2O00<Ool2OT02Ool2In035n030na3Ool001ioo`03001oogoo00=oo`03001oogoo0>Ioo`9l
00aoo`9n@09oo`=Wh0<Gh083k45oo`006Woo1P0017oo0`00j7oo0g`02goo0Wi00goo0VOP00=ooaOP
5n000`?/?Woo000KOol01000Oomoo`001Goo00<007ooOol0jgoo0W`02goo0gi00Woo0VOP00AooaOP
5n0Gh0<3k3]oo`006goo00@007ooOol000Eoo`03001oogoo0>eoo`=l00]oo`9n@09oo`9Wh09oo`<G
h083k3Uoo`0077oo00<007oo00001Goo00<007ooOol0l7oo0W`02goo0Wi00Woo0VOP0goo0QOP0P?/
=goo000MOol20005Ool00`00Oomoo`3bOol2O00;Ool2OT02Ool3In02Ool25n020n`eOol002Aoo`80
0?Eoo`9l00]oo`9n@0=oo`=Wh003OolGh1OP0083k3=oo`0097oo00<007ooOol0mWoo0W`02goo0gi0
0goo0VOP00=ooaOP5n000`?/<7oo000TOol00`00Oomoo`3hOol3O00;Ool2OT03Ool3In035n030n`]
Ool002Aoo`03001oogoo0?]oo`9l00]oo`9n@0Aoo`=Wh0<Gh083k2]oo`0097oo00<007ooOol0oGoo
0W`02goo0Wi01Goo0VOP00=ooaOP5n000`?/:7oo000TOol2003oOol1Ool2O00;Ool2OT05Ool2In00
17oo5n0Gh1OP0P?/9Woo000TOol00`00Oomoo`3oOol2Ool2O00;Ool3OT04Ool2In02Ool25n0VOol0
02Aoo`03001oogoo0?moo`Aoo`=l00]oo`=n@0=oo`9Wh2Qoo`0097oo00<007ooOol0ogoo1goo0W`0
37oo0Wi00goo0VOP9Woo000TOol00`00Oomoo`3oOol9Ool2O00<Ool3OT0XOol002Aoo`03001oogoo
0?moo`]oo`9l00eoo`9n@2Ioo`0097oo0P00ogoo3Woo0W`0<goo000TOol00`00Oomoo`3oOol?Ool3
O00`Ool002Aoo`03001oogoo0?mooa9oo`9l02ioo`0097oo00<007ooOol0ogoo57oo0W`0;7oo000T
Ool00`00Oomoo`3oOolFOol2O00ZOol002Aoo`800?mooaUoo`9l02Qoo`0097oo00<007ooOol0ogoo
6Woo0W`09Woo000=Ool30004Ool20005Ool40005Ool00`00Oomoo`3oOom2Ool000ioo`03001oogoo
00=oo`8000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo0?mood9oo`003Woo00<007oo
Ool03Woo00<007ooOol00Woo00<007ooOol0ogoo@Woo000:Ool6000?Ool00`00Oomoo`02Ool3003o
Oom2Ool000]oo`04001oogoo000<Ool4003oOom:Ool000]oo`04001oogoo000<Ool00`00Oomoo`3o
Oom;Ool000aoo`03001oo`0000aoo`03001oogoo0?mood]oo`003Goo0P0037oo1@00ogooBGoo003o
OomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol002Eoo`D0
0?moocmoo`009goo00<007ooOol0ogoo?goo000OOol30005Ool00`00Oomoo`3oOoloOol0021oo`03
001oogoo00Aoo`03001oogoo0?moocmoo`0087oo00<007ooOol017oo00<007ooOol0ogoo?goo000P
Ool00`00Ool00003Ool2003oOom1Ool0021oo`<00?moodIoo`0087oo00<007oo0000ogooAWoo000P
Ool01@00Oomoogoo0000ogooA7oo000OOol6003oOom4Ool00?moofUoo`00ogooJGoo003oOomYOol0
0?moofUoo`00ogooJGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-1.94434, 0.708337, \
0.0659233, 0.0243337}}]
}, Open  ]],

Cell[TextData[
"We observe again the same behavior as in the case of the \[Alpha] variation. \
However, the decrease in the solution is much smaller by changing the \
strength of the non-linearity."], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"Atomic.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{676, 668},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->355,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Molecular Beam Epitaxy"->{
    Cell[1739, 51, 367, 5, 49, "Subsection",
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 76}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Molecular Beam Epitaxy"]},
  "growth equations of molecular beam epitaxy"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "microscopic processes"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "crystal interface"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "deposition"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "desorption"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}],
    Cell[6919, 170, 1447, 34, 201, "Text",
      CellTags->{"desorption", "chemical potential"}],
    Cell[85495, 2693, 214, 4, 54, "Text",
      CellTags->"desorption"]},
  "surface diffusion"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}],
    Cell[3597, 82, 345, 7, 96, "Text",
      CellTags->"surface diffusion"],
    Cell[16586, 457, 430, 13, 75, "Text",
      CellTags->"surface diffusion"]},
  "atomic deposition"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "bonds"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "activated process"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}],
    Cell[4785, 114, 1329, 33, 159, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "excess energy"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "lattice potential"->{
    Cell[2109, 58, 1485, 22, 285, "Text",
      CellTags->{
      "growth equations of molecular beam epitaxy", "microscopic processes", 
        "crystal interface", "deposition", "desorption", "surface diffusion", 
        "atomic deposition", "bonds", "activated process", "excess energy", 
        "lattice potential"}]},
  "interface amplitude"->{
    Cell[4056, 95, 571, 12, 117, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "macroscopic current"->{
    Cell[4056, 95, 571, 12, 117, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "surface"->{
    Cell[4056, 95, 571, 12, 117, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "continuity equation"->{
    Cell[4056, 95, 571, 12, 117, "Text",
      CellTags->{
      "interface amplitude", "macroscopic current", "surface", 
        "continuity equation"}]},
  "surface current"->{
    Cell[4785, 114, 1329, 33, 159, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "chemical potential"->{
    Cell[4785, 114, 1329, 33, 159, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}],
    Cell[6919, 170, 1447, 34, 201, "Text",
      CellTags->{"desorption", "chemical potential"}]},
  "mobility"->{
    Cell[4785, 114, 1329, 33, 159, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "Laplacian"->{
    Cell[4785, 114, 1329, 33, 159, "Text",
      CellTags->{
      "surface current", "chemical potential", "activated process", 
        "mobility", "Laplacian"}]},
  "intensity"->{
    Cell[6269, 154, 485, 9, 96, "Text",
      CellTags->"intensity"]},
  "growth of interfaces"->{
    Cell[9122, 229, 370, 6, 75, "Text",
      CellTags->"growth of interfaces"]},
  "nonlinearity"->{
    Cell[9495, 237, 465, 9, 96, "Text",
      CellTags->{"nonlinearity", "growth equation"}]},
  "growth equation"->{
    Cell[9495, 237, 465, 9, 96, "Text",
      CellTags->{"nonlinearity", "growth equation"}]},
  "eq-7"->{
    Cell[9963, 248, 417, 10, 29, "NumberedEquation",
      CellTags->"eq-7"]},
  "symmetries"->{
    Cell[11756, 304, 201, 4, 54, "Text",
      CellTags->"symmetries"],
    Cell[15232, 411, 93, 1, 33, "Text",
      CellTags->"symmetries"],
    Cell[86206, 2718, 377, 6, 96, "Text",
      CellTags->"symmetries"]},
  "reduction"->{
    Cell[12637, 337, 188, 5, 54, "Text",
      CellTags->"reduction"],
    Cell[88839, 2798, 81, 1, 33, "Text",
      CellTags->"reduction"]},
  "Surface Diffusion with Nonlinearity"->{
    Cell[16463, 454, 120, 1, 37, "Subsubsection",
      CellTags->"Surface Diffusion with Nonlinearity"]},
  "symmetry group"->{
    Cell[17562, 492, 86, 1, 33, "Text",
      CellTags->"symmetry group"]},
  "scaling group"->{
    Cell[18655, 532, 124, 4, 33, "Text",
      CellTags->"scaling group"]},
  "numerical solution"->{
    Cell[22455, 639, 238, 6, 54, "Text",
      CellTags->"numerical solution"]},
  "Desorption with Nonlinearity"->{
    Cell[85385, 2690, 107, 1, 37, "Subsubsection",
      CellTags->"Desorption with Nonlinearity"]},
  "infinitesimals"->{
    Cell[88085, 2777, 370, 6, 96, "Text",
      CellTags->"infinitesimals"]},
  "similarity reduction"->{
    Cell[90752, 2849, 539, 11, 96, "Text",
      CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}]},
  "DSolve[]"->{
    Cell[90752, 2849, 539, 11, 96, "Text",
      CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}]},
  "point symmetry"->{
    Cell[90752, 2849, 539, 11, 96, "Text",
      CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}]},
  "numerical integration"->{
    Cell[91935, 2886, 204, 5, 54, "Text",
      CellTags->"numerical integration"]},
  "nonlinear strength"->{
    Cell[113814, 3583, 467, 7, 96, "Text",
      CellTags->"nonlinear strength"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Molecular Beam Epitaxy", 138426, 4343},
  {"growth equations of molecular beam epitaxy", 138805, 4350},
  {"microscopic processes", 139160, 4357},
  {"crystal interface", 139511, 4364},
  {"deposition", 139855, 4371},
  {"desorption", 140199, 4378},
  {"surface diffusion", 140721, 4389},
  {"atomic deposition", 141229, 4400},
  {"bonds", 141568, 4407},
  {"activated process", 141919, 4414},
  {"excess energy", 142431, 4425},
  {"lattice potential", 142782, 4432},
  {"interface amplitude", 143135, 4439},
  {"macroscopic current", 143319, 4444},
  {"surface", 143491, 4449},
  {"continuity equation", 143675, 4454},
  {"surface current", 143855, 4459},
  {"chemical potential", 144047, 4464},
  {"mobility", 144327, 4471},
  {"Laplacian", 144510, 4476},
  {"intensity", 144693, 4481},
  {"growth of interfaces", 144792, 4484},
  {"nonlinearity", 144894, 4487},
  {"growth equation", 145012, 4490},
  {"eq-7", 145119, 4493},
  {"symmetries", 145216, 4496},
  {"reduction", 145450, 4503},
  {"Surface Diffusion with Nonlinearity", 145636, 4508},
  {"symmetry group", 145765, 4511},
  {"scaling group", 145862, 4514},
  {"numerical solution", 145964, 4517},
  {"Desorption with Nonlinearity", 146081, 4520},
  {"infinitesimals", 146204, 4523},
  {"similarity reduction", 146310, 4526},
  {"DSolve[]", 146443, 4529},
  {"point symmetry", 146582, 4532},
  {"numerical integration", 146728, 4535},
  {"nonlinear strength", 146839, 4538}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 367, 5, 49, "Subsection",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 76}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Molecular Beam Epitaxy"],
Cell[2109, 58, 1485, 22, 285, "Text",
  CellTags->{
  "growth equations of molecular beam epitaxy", "microscopic processes", 
    "crystal interface", "deposition", "desorption", "surface diffusion", 
    "atomic deposition", "bonds", "activated process", "excess energy", 
    "lattice potential"}],
Cell[3597, 82, 345, 7, 96, "Text",
  CellTags->"surface diffusion"],
Cell[3945, 91, 108, 2, 28, "NumberedEquation"],
Cell[4056, 95, 571, 12, 117, "Text",
  CellTags->{
  "interface amplitude", "macroscopic current", "surface", 
    "continuity equation"}],
Cell[4630, 109, 152, 3, 32, "NumberedEquation"],
Cell[4785, 114, 1329, 33, 159, "Text",
  CellTags->{
  "surface current", "chemical potential", "activated process", "mobility", 
    "Laplacian"}],
Cell[6117, 149, 149, 3, 29, "NumberedEquation"],
Cell[6269, 154, 485, 9, 96, "Text",
  CellTags->"intensity"],
Cell[6757, 165, 159, 3, 29, "NumberedEquation"],
Cell[6919, 170, 1447, 34, 201, "Text",
  CellTags->{"desorption", "chemical potential"}],
Cell[8369, 206, 232, 4, 29, "NumberedEquation"],
Cell[8604, 212, 301, 9, 54, "Text"],
Cell[8908, 223, 211, 4, 29, "NumberedEquation"],
Cell[9122, 229, 370, 6, 75, "Text",
  CellTags->"growth of interfaces"],
Cell[9495, 237, 465, 9, 96, "Text",
  CellTags->{"nonlinearity", "growth equation"}],
Cell[9963, 248, 417, 10, 29, "NumberedEquation",
  CellTags->"eq-7"],
Cell[10383, 260, 386, 8, 96, "Text"],
Cell[10772, 270, 50, 1, 27, "Input"],
Cell[10825, 273, 93, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[10943, 281, 329, 6, 28, "Input"],
Cell[11275, 289, 466, 12, 31, "Output"]
}, Open  ]],
Cell[11756, 304, 201, 4, 54, "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{
Cell[11982, 312, 169, 4, 27, "Input"],
Cell[12154, 318, 468, 16, 57, "Output"]
}, Open  ]],
Cell[12637, 337, 188, 5, 54, "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{
Cell[12850, 346, 141, 2, 45, "Input"],
Cell[12994, 350, 1152, 26, 85, "Output"]
}, Open  ]],
Cell[14161, 379, 148, 3, 54, "Text"],

Cell[CellGroupData[{
Cell[14334, 386, 257, 5, 57, "Input"],
Cell[14594, 393, 623, 15, 51, "Output"]
}, Open  ]],
Cell[15232, 411, 93, 1, 33, "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{
Cell[15350, 416, 274, 6, 46, "Input"],
Cell[15627, 424, 431, 14, 41, "Output"]
}, Open  ]],
Cell[16073, 441, 134, 3, 54, "Text"],
Cell[16210, 446, 228, 4, 75, "Text"],

Cell[CellGroupData[{
Cell[16463, 454, 120, 1, 37, "Subsubsection",
  CellTags->"Surface Diffusion with Nonlinearity"],
Cell[16586, 457, 430, 13, 75, "Text",
  CellTags->"surface diffusion"],

Cell[CellGroupData[{
Cell[17041, 474, 115, 2, 27, "Input"],
Cell[17159, 478, 388, 11, 31, "Output"]
}, Open  ]],
Cell[17562, 492, 86, 1, 33, "Text",
  CellTags->"symmetry group"],

Cell[CellGroupData[{
Cell[17673, 497, 142, 3, 27, "Input"],
Cell[17818, 502, 822, 27, 75, "Output"]
}, Open  ]],
Cell[18655, 532, 124, 4, 33, "Text",
  CellTags->"scaling group"],

Cell[CellGroupData[{
Cell[18804, 540, 210, 4, 45, "Input"],
Cell[19017, 546, 65, 1, 40, "Output"]
}, Open  ]],
Cell[19097, 550, 105, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[19227, 557, 250, 5, 45, "Input"],
Cell[19480, 564, 1335, 31, 121, "Output"]
}, Open  ]],
Cell[20830, 598, 543, 12, 117, "Text"],
Cell[21376, 612, 1076, 25, 45, "Input"],
Cell[22455, 639, 238, 6, 54, "Text",
  CellTags->"numerical solution"],
Cell[22696, 647, 147, 3, 27, "Input"],
Cell[22846, 652, 50, 0, 33, "Text"],
Cell[22899, 654, 100, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[23024, 660, 183, 3, 45, "Input"],
Cell[23210, 665, 33163, 1126, 207, 14169, 887, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[56388, 1794, 156, 2, 54, "Text"],
Cell[56547, 1798, 1076, 25, 45, "Input"],
Cell[57626, 1825, 143, 3, 27, "Input"],
Cell[57772, 1830, 72, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[57869, 1834, 183, 3, 45, "Input"],
Cell[58055, 1839, 26909, 838, 199, 10207, 627, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[84979, 2680, 369, 5, 96, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85385, 2690, 107, 1, 37, "Subsubsection",
  CellTags->"Desorption with Nonlinearity"],
Cell[85495, 2693, 214, 4, 54, "Text",
  CellTags->"desorption"],

Cell[CellGroupData[{
Cell[85734, 2701, 114, 2, 27, "Input"],
Cell[85851, 2705, 340, 10, 31, "Output"]
}, Open  ]],
Cell[86206, 2718, 377, 6, 96, "Text",
  CellTags->"symmetries"],

Cell[CellGroupData[{
Cell[86608, 2728, 145, 3, 27, "Input"],
Cell[86756, 2733, 1314, 41, 111, "Output"]
}, Open  ]],
Cell[88085, 2777, 370, 6, 96, "Text",
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[88480, 2787, 210, 4, 45, "Input"],
Cell[88693, 2793, 131, 2, 42, "Output"]
}, Open  ]],
Cell[88839, 2798, 81, 1, 33, "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{
Cell[88945, 2803, 250, 5, 45, "Input"],
Cell[89198, 2810, 1539, 36, 141, "Output"]
}, Open  ]],
Cell[90752, 2849, 539, 11, 96, "Text",
  CellTags->{"similarity reduction", "DSolve[]", "point symmetry"}],

Cell[CellGroupData[{
Cell[91316, 2864, 223, 4, 46, "Input"],
Cell[91542, 2870, 378, 13, 41, "Output"]
}, Open  ]],
Cell[91935, 2886, 204, 5, 54, "Text",
  CellTags->"numerical integration"],
Cell[92142, 2893, 563, 13, 27, "Input"],
Cell[92708, 2908, 185, 3, 54, "Text"],
Cell[92896, 2913, 149, 3, 27, "Input"],
Cell[93048, 2918, 127, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[93200, 2924, 212, 3, 45, "Input"],
Cell[93415, 2929, 20384, 651, 233, 8160, 496, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[113814, 3583, 467, 7, 96, "Text",
  CellTags->"nonlinear strength"],
Cell[114284, 3592, 562, 13, 27, "Input"],
Cell[114849, 3607, 105, 2, 33, "Text"],
Cell[114957, 3611, 150, 3, 27, "Input"],
Cell[115110, 3616, 59, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[115194, 3620, 212, 3, 45, "Input"],
Cell[115409, 3625, 21071, 660, 233, 8162, 496, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[136495, 4288, 208, 3, 54, "Text"],
Cell[136706, 4293, 146, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

