(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    445123,       8587]*)
(*NotebookOutlinePosition[    451997,       8770]*)
(*  CellTagsIndexPosition[    451102,       8744]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.6.9 The Rayleigh Particle", "Subsection",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 75}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"The Rayleigh particle"],

Cell[TextData[{
  "The Rayleigh particle is similar to the Brownian particle. The difference \
between the two species is that the Brownian particle has a constant \
velocity, whereas the Rayleigh particle is characterized by the macroscopic \
law for the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " in the form of the damping law"
}], "Text",
  Evaluatable->False,
  CellTags->{"Brownian particle", "Rayleigh particle"}],

Cell[BoxData[
    \(TraditionalForm\`\(V\&\[CenterDot]\)\  = \ \(-\[Gamma]\)\ \(V . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "We assume that ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is not too large. The Fokker-Planck (FP) equation related to the Rayleigh \
particle is discussed by ",
  ButtonBox["Van Kampen [1981]",
    ButtonData:>{"Literat.nb", "Van Kampen-1981"},
    ButtonStyle->"Hyperlink"],
  ". The equation of motion for the probability density ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " reads"
}], "Text",
  Evaluatable->False,
  CellTags->{"Fokker-Planck equation", "FP equation", "probability density"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[P, V]; \n
    rayleigh = 
      \[PartialD]\_t P[V, t] - 
          \[Gamma]\ 
            \((\[PartialD]\_V\((V\ P[V, t])\) + 
                \(k\ T\ \[PartialD]\_{V, 2}P[V, t]\)\/M)\) == 0; 
    rayleigh // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(P\_t\), "-", 
                RowBox[{"\[Gamma]", " ", 
                  RowBox[{"(", 
                    RowBox[{"P", "+", \(V\ P\_V\), "+", 
                      StyleBox[\(\(k\ T\ P\_\(V, V\)\)\/M\),
                        ScriptLevel->0]}], ")"}]}]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This linear equation for the probability density ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " depending on the velocity ",
  StyleBox["V ",
    FontSlant->"Italic"],
  "and time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " describes a damped particle of mass ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  " at a temperature ",
  StyleBox["T",
    FontSlant->"Italic"],
  ". The constants \[Gamma] and ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " are the damping parameter and the Boltzmann constant, respectively. The \
independent variables in the equation can be scaled in such a way that the \
equation is free of any parameters [",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Tau]", " ", "=", " ", 
          StyleBox[
            RowBox[{"\[Gamma]", 
              StyleBox["t",
                FontSlant->"Italic"]}]]}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"v", " ", "=", " ", 
          RowBox[{"V", " ", 
            FormBox[
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{"m", "/", 
                    RowBox[{"(", 
                      StyleBox["kT",
                        FontSlant->"Italic"], ")"}]}], ")"}], \(1/2\)],
              "TraditionalForm"]}]}], TraditionalForm]]],
  "]. The scaled equation is given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"damped particle", "temperature", "Boltzmann constant"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rayleigh = 
      \[PartialD]\_\[Tau] P[v, \[Tau]] - 
          \((\[PartialD]\_v\((v\ P[v, \[Tau]])\) + 
              \[PartialD]\_{v, 2}P[v, \[Tau]])\) == 0; rayleigh // \ LTF\)], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-P\) - v\ P\_v + P\_\[Tau] - P\_\(v, v\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This type of equation was examined by ",
  ButtonBox["Cicogna and Vitali [1990]",
    ButtonData:>{"Literat.nb", "Cicogna-1990"},
    ButtonStyle->"Hyperlink"],
  ". We reproduce their results to demonstrate that the structure of the \
infinitesimals can be quite different from a polynomial and that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is capable of finding these symmetries automatically. The infinitesimals \
read"
}], "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infirayl = Infinitesimals[rayleigh, {P}, {v, \[Tau]}]; 
    infirayl // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\[ScriptCapitalF]\_1 + v\ \((\[ScriptCapitalF]\_1)\)\_v - 
                \((\[ScriptCapitalF]\_1)\)\_\[Tau] + 
                \((\[ScriptCapitalF]\_1)\)\_\(v, v\) == 0\)},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(E\^\(-\[Tau]\)\ k1\), "+", \(E\^\[Tau]\ k2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(\(-2\)\ \[Tau]\)\), " ", 
                  \((k3 + E\^\(4\ \[Tau]\)\ k5)\), " ", "v"}]}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{
                RowBox[{
                  RowBox[{"-", 
                    StyleBox[\(1\/2\),
                      ScriptLevel->0]}], " ", \(E\^\(\(-2\)\ \[Tau]\)\), " ", 
                  "k3"}], "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", \(E\^\(2\ \[Tau]\)\), " ", "k5"}], 
                "+", "k6"}]}]},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", "P", " ", 
                  \((\(-E\^\(\(-2\)\ \[Tau]\)\)\ k3 + 2\ k4 - 
                      2\ E\^\[Tau]\ k2\ v - E\^\(2\ \[Tau]\)\ k5\ v\^2)\)}], 
                "+", \(\[ScriptCapitalF]\_1\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 1], 
            Times[ v, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], v]], 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], \[Tau]]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], v, v]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Times[ 
              Power[ E, 
                Times[ -1, \[Tau]]], k1], 
            Times[ 
              Power[ E, \[Tau]], k2], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ -2, \[Tau]]], 
              Plus[ k3, 
                Times[ 
                  Power[ E, 
                    Times[ 4, \[Tau]]], k5]], v]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, 
                Times[ -2, \[Tau]]], k3], 
            Times[ 
              Rational[ 1, 2], 
              Power[ E, 
                Times[ 2, \[Tau]]], k5], k6]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Rational[ 1, 2], P, 
              Plus[ 
                Times[ -1, 
                  Power[ E, 
                    Times[ -2, \[Tau]]], k3], 
                Times[ 2, k4], 
                Times[ -2, 
                  Power[ E, \[Tau]], k2, v], 
                Times[ -1, 
                  Power[ E, 
                    Times[ 2, \[Tau]]], k5, 
                  Power[ v, 2]]]], 
            Subscript[ \[ScriptCapitalF], 1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The symmetry group is given by a six-dimensional discrete group and an \
infinite dimensional group determined by the function ",
  StyleBox["free[1]", "MmaText",
    FontSlant->"Italic"],
  " satisfying the original Fokker-Planck equation. The structure of the \
infinitesimals illustrates that ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is capable of deriving non-polynomial results."
}], "Text",
  Evaluatable->False,
  CellTags->{"symmetry group", "discrete group", "Fokker-Planck equation"}],

Cell[TextData[{
  "The infinitesimals can be used to derive solutions of the FP equation. A \
simple solution is derived for the subgroup ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k2",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  "; the other constants are set to zero. The infinitesimals for this \
subgroup reduce to"
}], "Text",
  CellTags->{"FP equation", "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 1, k2 \[Rule] 1, k3 \[Rule] 0, k4 \[Rule] 0, 
          k5 \[Rule] 0, k6 \[Rule] 0, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{E\^\(-\[Tau]\) + E\^\[Tau], 0}, {\(-E\^\[Tau]\)\ P\ v}}\)], "Output"]
}, Open  ]],

Cell["\<\
The corresponding similarity reduction of the FP equation follows \
from\
\>", "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Tau] - \[Zeta]\_1 == 0\)},
          {
            \(E\^\(\(E\^\(2\ \[Tau]\)\ v\^2\)\/\(2\ 
                          \((1 + E\^\(2\ \[Tau]\))\)\)\)\ P - F\_1 == 0\)},
          {
            \(E\^\(\(E\^\(2\ \[Zeta]\_1\)\ v\^2\)\/\(\(-2\) - 
                        2\ E\^\(2\ \[Zeta]\_1\)\)\)\ 
                \((\(-F\_1\) + \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    E\^\(2\ \[Zeta]\_1\)\ \((F\_1)\)\_\(\[Zeta]\_1\))\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We realize that the similarity variable is given by the temporal variable \
\[Tau]. The resulting first-order ODE containing analytic coefficients is \
solved by ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  CellTags->{"similarity variable", "DSolve[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"solr1", " ", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(-F1[zeta1]\), "+", 
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}], "+", 
              RowBox[{\(E\^\(2\ zeta1\)\), " ", 
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
            "0"}], ",", "F1", ",", "zeta1"}], "]"}]}]], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(\(-\(1\/2\)\)\ Log[1 + E\^\(2\ #1\)] + #1\)\ C[1]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
The solution of the FP equation in original coordinates results by \
inverting the similarity representation derived above:\
\>", "Text",
  CellTags->{"solution of the FP equation", "similarity representation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1 = 
      Solve[red1\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr1, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] 
          \(E\^\(\(E\^\(2\ \[Tau]\)\ v\^2\)\/\(\(-2\) - 
                      2\ E\^\(2\ \[Tau]\)\) + \[Tau]\)\ 
              C[1]\)\/\@\(1 + E\^\(2\ \[Tau]\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "A picture for a fixed value of the constant of integration ",
  StyleBox["C",
    FontSlant->"Italic"],
  "[1] is shown below. The figure demonstrates that the probability density ",
  
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " has a single maximum in the velocity domain. The amplitude of the \
probability density increases with increasing time."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      \(P /. sol1\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. 
        C[1] \[Rule] 1, {v, \(-3\), 3}, {\[Tau], \(-2\), 2}, 
      AxesLabel \[Rule] {"\<v\>", "\<\[Tau]\>", "\<P\>"}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-16 1.04977 -0.0679587 1.04977 [
[.12586 .2075 -12 -8.99448 ]
[.12586 .2075 0 .00552 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.56094 .0364 -5.16972 -9 ]
[.56094 .0364 .83028 0 ]
[.29165 .07573 -10.2423 -15 ]
[.29165 .07573 .75771 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.0156 .31844 -24 -2.78741 ]
[.0156 .31844 0 6.21259 ]
[.00679 .37365 -18 -2.83425 ]
[.00679 .37365 0 6.16575 ]
[-0.00233 .43085 -24 -2.88295 ]
[-0.00233 .43085 0 6.11705 ]
[-0.01179 .49013 -6 -2.93362 ]
[-0.01179 .49013 0 6.06638 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02787 .31377 m
.034 .31144 L
s
[(0.25)] .0156 .31844 1 -0.38058 Mshowa
.0191 .3691 m
.02525 .36682 L
s
[(0.5)] .00679 .37365 1 -0.37017 Mshowa
.01002 .42641 m
.01619 .42419 L
s
[(0.75)] -0.00233 .43085 1 -0.35934 Mshowa
.0006 .48582 m
.0068 .48366 L
s
[(1)] -0.01179 .49013 1 -0.34808 Mshowa
.125 Mabswid
.03467 .27088 m
.03834 .26945 L
s
.03298 .28149 m
.03666 .28007 L
s
.03129 .29218 m
.03496 .29076 L
s
.02959 .30294 m
.03326 .30153 L
s
.02614 .32468 m
.02982 .32329 L
s
.0244 .33567 m
.02808 .33428 L
s
.02264 .34673 m
.02633 .34535 L
s
.02088 .35788 m
.02457 .3565 L
s
.01731 .3804 m
.021 .37904 L
s
.01551 .39178 m
.0192 .39042 L
s
.01369 .40324 m
.01739 .40189 L
s
.01186 .41478 m
.01556 .41344 L
s
.00816 .43812 m
.01187 .43679 L
s
.00629 .44991 m
.01 .4486 L
s
.00441 .46179 m
.00812 .46048 L
s
.00251 .47376 m
.00623 .47246 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
43.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
43.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(P) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.602 .725 .932 r
.38302 .58567 .40504 .60601 .44171 .60015 .41997 .57972 Metetra
.478 .68 .955 r
.41997 .57972 .44171 .60015 .47889 .60178 .45739 .58137 Metetra
.156 .513 .914 r
.45739 .58137 .47889 .60178 .51684 .61635 .49553 .59592 Metetra
0 .179 .669 r
.49553 .59592 .51684 .61635 .55606 .64688 .53486 .62622 Metetra
.506 .002 0 r
.53486 .62622 .55606 .64688 .59702 .68811 .5759 .66686 Metetra
0 .161 .659 r
.5759 .66686 .59702 .68811 .63961 .7233 .61861 .70127 Metetra
.384 .636 .954 r
.61861 .70127 .63961 .7233 .68272 .73097 .66203 .70838 Metetra
.779 .782 .855 r
.66203 .70838 .68272 .73097 .72478 .70062 .70465 .67794 Metetra
.871 .789 .767 r
.70465 .67794 .72478 .70062 .76508 .64197 .74567 .61943 Metetra
.889 .793 .748 r
.74567 .61943 .76508 .64197 .80429 .57638 .78564 .55379 Metetra
.873 .799 .774 r
.78564 .55379 .80429 .57638 .84375 .52102 .82577 .49802 Metetra
.826 .798 .824 r
.82577 .49802 .84375 .52102 .88446 .48162 .86706 .45796 Metetra
.762 .782 .87 r
.86706 .45796 .88446 .48162 .92673 .45531 .90984 .43099 Metetra
.708 .762 .895 r
.90984 .43099 .92673 .45531 .97036 .43666 .95396 .41176 Metetra
.597 .725 .934 r
.36043 .56492 .38302 .58567 .41997 .57972 .39765 .55899 Metetra
.469 .679 .957 r
.39765 .55899 .41997 .57972 .45739 .58137 .43532 .56078 Metetra
.142 .509 .911 r
.43532 .56078 .45739 .58137 .49553 .59592 .47364 .57539 Metetra
0 .182 .668 r
.47364 .57539 .49553 .59592 .53486 .62622 .51309 .60526 Metetra
0 .016 .51 r
.51309 .60526 .53486 .62622 .5759 .66686 .55419 .6448 Metetra
0 .193 .689 r
.55419 .6448 .5759 .66686 .61861 .70127 .59702 .67779 Metetra
.406 .639 .951 r
.59702 .67779 .61861 .70127 .66203 .70838 .64072 .68405 Metetra
.773 .772 .852 r
.64072 .68405 .66203 .70838 .70465 .67794 .6839 .65378 Metetra
.865 .784 .77 r
.6839 .65378 .70465 .67794 .74567 .61943 .7257 .59601 Metetra
.886 .792 .75 r
.7257 .59601 .74567 .61943 .78564 .55379 .76647 .53081 Metetra
.873 .801 .776 r
.76647 .53081 .78564 .55379 .82577 .49802 .80731 .47481 Metetra
.829 .801 .825 r
.80731 .47481 .82577 .49802 .86706 .45796 .8492 .43403 Metetra
.765 .786 .871 r
.8492 .43403 .86706 .45796 .90984 .43099 .89249 .40622 Metetra
.711 .765 .895 r
.89249 .40622 .90984 .43099 .95396 .41176 .93711 .38627 Metetra
.59 .725 .937 r
.33724 .54382 .36043 .56492 .39765 .55899 .37473 .53812 Metetra
.453 .677 .96 r
.37473 .53812 .39765 .55899 .43532 .56078 .41263 .54029 Metetra
.118 .501 .906 r
.41263 .54029 .43532 .56078 .47364 .57539 .45114 .555 Metetra
0 .188 .669 r
.45114 .555 .47364 .57539 .51309 .60526 .4907 .58409 Metetra
0 .049 .54 r
.4907 .58409 .51309 .60526 .55419 .6448 .53188 .62167 Metetra
0 .247 .737 r
.53188 .62167 .55419 .6448 .59702 .67779 .57481 .65228 Metetra
.438 .641 .943 r
.57481 .65228 .59702 .67779 .64072 .68405 .61879 .65722 Metetra
.763 .757 .847 r
.61879 .65722 .64072 .68405 .6839 .65378 .66252 .62754 Metetra
.855 .776 .773 r
.66252 .62754 .6839 .65378 .7257 .59601 .70513 .57146 Metetra
.881 .789 .755 r
.70513 .57146 .7257 .59601 .76647 .53081 .74677 .50755 Metetra
.872 .803 .779 r
.74677 .50755 .76647 .53081 .80731 .47481 .78838 .45166 Metetra
.832 .807 .827 r
.78838 .45166 .80731 .47481 .8492 .43403 .83088 .41007 Metetra
.77 .793 .872 r
.83088 .41007 .8492 .43403 .89249 .40622 .87469 .38115 Metetra
.715 .771 .896 r
.87469 .38115 .89249 .40622 .93711 .38627 .9198 .36025 Metetra
.577 .725 .943 r
.3134 .52257 .33724 .54382 .37473 .53812 .35114 .51744 Metetra
.425 .672 .965 r
.35114 .51744 .37473 .53812 .41263 .54029 .38926 .52031 Metetra
.083 .491 .897 r
.38926 .52031 .41263 .54029 .45114 .555 .42795 .53513 Metetra
0 .206 .676 r
.42795 .53513 .45114 .555 .4907 .58409 .46767 .56277 Metetra
0 .108 .596 r
.46767 .56277 .4907 .58409 .53188 .62167 .50894 .59707 Metetra
0 .329 .804 r
.50894 .59707 .53188 .62167 .57481 .65228 .55197 .62386 Metetra
.479 .641 .928 r
.55197 .62386 .57481 .65228 .61879 .65722 .5962 .62684 Metetra
.748 .735 .84 r
.5962 .62684 .61879 .65722 .66252 .62754 .64048 .59834 Metetra
.839 .763 .778 r
.64048 .59834 .66252 .62754 .70513 .57146 .68392 .54536 Metetra
.872 .785 .762 r
.68392 .54536 .70513 .57146 .74677 .50755 .7265 .48406 Metetra
.87 .807 .785 r
.7265 .48406 .74677 .50755 .78838 .45166 .76895 .42893 Metetra
.836 .817 .83 r
.76895 .42893 .78838 .45166 .83088 .41007 .81211 .3865 Metetra
.778 .805 .874 r
.81211 .3865 .83088 .41007 .87469 .38115 .85644 .35613 Metetra
.722 .78 .898 r
.85644 .35613 .87469 .38115 .9198 .36025 .90202 .33389 Metetra
.552 .724 .954 r
.28885 .50155 .3134 .52257 .35114 .51744 .32681 .49751 Metetra
.379 .665 .97 r
.32681 .49751 .35114 .51744 .38926 .52031 .36513 .50141 Metetra
.041 .481 .884 r
.36513 .50141 .38926 .52031 .42795 .53513 .40404 .51607 Metetra
0 .247 .701 r
.40404 .51607 .42795 .53513 .46767 .56277 .44395 .54111 Metetra
0 .214 .693 r
.44395 .54111 .46767 .56277 .50894 .59707 .48539 .57025 Metetra
.086 .435 .875 r
.48539 .57025 .50894 .59707 .55197 .62386 .52854 .59142 Metetra
.524 .637 .903 r
.52854 .59142 .55197 .62386 .5962 .62684 .57298 .59165 Metetra
.728 .706 .829 r
.57298 .59165 .5962 .62684 .64048 .59834 .61776 .56505 Metetra
.815 .742 .783 r
.61776 .56505 .64048 .59834 .68392 .54536 .66204 .51695 Metetra
.855 .776 .773 r
.66204 .51695 .68392 .54536 .7265 .48406 .70563 .46014 Metetra
.864 .809 .794 r
.70563 .46014 .7265 .48406 .76895 .42893 .74902 .40694 Metetra
.841 .828 .835 r
.74902 .40694 .76895 .42893 .81211 .3865 .79289 .36393 Metetra
.789 .822 .878 r
.79289 .36393 .81211 .3865 .85644 .35613 .83776 .33172 Metetra
.734 .796 .902 r
.83776 .33172 .85644 .35613 .90202 .33389 .8838 .30758 Metetra
.51 .725 .97 r
.26349 .48155 .28885 .50155 .32681 .49751 .30162 .47913 Metetra
.313 .655 .971 r
.30162 .47913 .32681 .49751 .36513 .50141 .34015 .48409 Metetra
.016 .485 .874 r
.34015 .48409 .36513 .50141 .40404 .51607 .37933 .4977 Metetra
0 .338 .769 r
.37933 .4977 .40404 .51607 .44395 .54111 .41955 .51831 Metetra
0 .377 .827 r
.41955 .51831 .44395 .54111 .48539 .57025 .46124 .54012 Metetra
.287 .534 .913 r
.46124 .54012 .48539 .57025 .52854 .59142 .50456 .55391 Metetra
.565 .627 .873 r
.50456 .55391 .52854 .59142 .57298 .59165 .54918 .55073 Metetra
.704 .672 .816 r
.54918 .55073 .57298 .59165 .61776 .56505 .59438 .52664 Metetra
.781 .713 .788 r
.59438 .52664 .61776 .56505 .66204 .51695 .63945 .48512 Metetra
.828 .759 .786 r
.63945 .48512 .66204 .51695 .70563 .46014 .68409 .43497 Metetra
.85 .806 .807 r
.68409 .43497 .70563 .46014 .74902 .40694 .72851 .38552 Metetra
.841 .839 .844 r
.72851 .38552 .74902 .40694 .79289 .36393 .77322 .34283 Metetra
.802 .843 .882 r
.77322 .34283 .79289 .36393 .83776 .33172 .81869 .30876 Metetra
.751 .821 .907 r
.81869 .30876 .83776 .33172 .8838 .30758 .8652 .28212 Metetra
.444 .726 .986 r
.23714 .46362 .26349 .48155 .30162 .47913 .27544 .46288 Metetra
.253 .651 .964 r
.27544 .46288 .30162 .47913 .34015 .48409 .31425 .46797 Metetra
.066 .537 .897 r
.31425 .46797 .34015 .48409 .37933 .4977 .35382 .47869 Metetra
.041 .492 .885 r
.35382 .47869 .37933 .4977 .41955 .51831 .39449 .49272 Metetra
.223 .543 .928 r
.39449 .49272 .41955 .51831 .46124 .54012 .43656 .50548 Metetra
.45 .592 .902 r
.43656 .50548 .46124 .54012 .50456 .55391 .48011 .51104 Metetra
.594 .616 .843 r
.48011 .51104 .50456 .55391 .54918 .55073 .52489 .5042 Metetra
.681 .642 .804 r
.52489 .5042 .54918 .55073 .59438 .52664 .57041 .48278 Metetra
.742 .68 .791 r
.57041 .48278 .59438 .52664 .63945 .48512 .61614 .44866 Metetra
.789 .731 .798 r
.61614 .44866 .63945 .48512 .68409 .43497 .66177 .40685 Metetra
.821 .789 .822 r
.66177 .40685 .68409 .43497 .72851 .38552 .7073 .36333 Metetra
.828 .838 .855 r
.7073 .36333 .72851 .38552 .77322 .34283 .753 .32283 Metetra
.807 .86 .889 r
.753 .32283 .77322 .34283 .81869 .30876 .79922 .28781 Metetra
.768 .85 .913 r
.79922 .28781 .81869 .30876 .8652 .28212 .84627 .25862 Metetra
.39 .733 .991 r
.20967 .44808 .23714 .46362 .27544 .46288 .24825 .44775 Metetra
.278 .681 .971 r
.24825 .44775 .27544 .46288 .31425 .46797 .2875 .45087 Metetra
.242 .643 .961 r
.2875 .45087 .31425 .46797 .35382 .47869 .32764 .45643 Metetra
.319 .635 .964 r
.32764 .45643 .35382 .47869 .39449 .49272 .3689 .4624 Metetra
.446 .627 .93 r
.3689 .4624 .39449 .49272 .43656 .50548 .41143 .46589 Metetra
.547 .613 .87 r
.41143 .46589 .43656 .50548 .48011 .51104 .45525 .4638 Metetra
.614 .609 .822 r
.45525 .4638 .48011 .51104 .52489 .5042 .50018 .45368 Metetra
.663 .621 .797 r
.50018 .45368 .52489 .5042 .57041 .48278 .54594 .43451 Metetra
.705 .65 .793 r
.54594 .43451 .57041 .48278 .61614 .44866 .59217 .40711 Metetra
.744 .696 .806 r
.59217 .40711 .61614 .44866 .66177 .40685 .63863 .3738 Metetra
.778 .755 .832 r
.63863 .3738 .66177 .40685 .7073 .36333 .68521 .33766 Metetra
.797 .813 .865 r
.68521 .33766 .7073 .36333 .753 .32283 .732 .30163 Metetra
.795 .855 .895 r
.732 .30163 .753 .32283 .79922 .28781 .77917 .26784 Metetra
.774 .867 .918 r
.77917 .26784 .79922 .28781 .84627 .25862 .82697 .23738 Metetra
.427 .756 .995 r
.18118 .43271 .20967 .44808 .24825 .44775 .22027 .43044 Metetra
.418 .735 .991 r
.22027 .43044 .24825 .44775 .2875 .45087 .26015 .42933 Metetra
.454 .712 .978 r
.26015 .42933 .2875 .45087 .32764 .45643 .30098 .42847 Metetra
.509 .679 .942 r
.30098 .42847 .32764 .45643 .3689 .4624 .34287 .42662 Metetra
.559 .645 .891 r
.34287 .42662 .3689 .4624 .41143 .46589 .38588 .42236 Metetra
.596 .619 .845 r
.38588 .42236 .41143 .46589 .45525 .4638 .42999 .41439 Metetra
.626 .609 .813 r
.42999 .41439 .45525 .4638 .50018 .45368 .47509 .40174 Metetra
.652 .613 .798 r
.47509 .40174 .50018 .45368 .54594 .43451 .52103 .38401 Metetra
.677 .633 .798 r
.52103 .38401 .54594 .43451 .59217 .40711 .56761 .3615 Metetra
.704 .667 .811 r
.56761 .3615 .59217 .40711 .63863 .3738 .61469 .33507 Metetra
.731 .713 .834 r
.61469 .33507 .63863 .3738 .68521 .33766 .66215 .30599 Metetra
.752 .766 .864 r
.66215 .30599 .68521 .33766 .732 .30163 .70998 .27566 Metetra
.763 .815 .894 r
.70998 .27566 .732 .30163 .77917 .26784 .75822 .24537 Metetra
.76 .849 .918 r
.75822 .24537 .77917 .26784 .82697 .23738 .807 .21606 Metetra
.534 .765 .982 r
.15209 .41337 .18118 .43271 .22027 .43044 .19184 .4074 Metetra
.551 .739 .964 r
.19184 .4074 .22027 .43044 .26015 .42933 .23244 .40131 Metetra
.573 .707 .933 r
.23244 .40131 .26015 .42933 .30098 .42847 .27395 .39458 Metetra
.592 .674 .897 r
.27395 .39458 .30098 .42847 .34287 .42662 .31642 .38667 Metetra
.608 .645 .862 r
.31642 .38667 .34287 .42662 .38588 .42236 .35986 .37701 Metetra
.621 .626 .834 r
.35986 .37701 .38588 .42236 .42999 .41439 .40426 .36514 Metetra
.634 .617 .815 r
.40426 .36514 .42999 .41439 .47509 .40174 .44955 .35073 Metetra
.647 .618 .807 r
.44955 .35073 .47509 .40174 .52103 .38401 .49568 .33365 Metetra
.661 .63 .807 r
.49568 .33365 .52103 .38401 .56761 .3615 .54254 .31398 Metetra
.677 .651 .817 r
.54254 .31398 .56761 .3615 .61469 .33507 .59007 .29197 Metetra
.694 .681 .834 r
.59007 .29197 .61469 .33507 .66215 .30599 .63819 .26807 Metetra
.71 .718 .856 r
.63819 .26807 .66215 .30599 .70998 .27566 .68687 .2428 Metetra
.722 .759 .882 r
.68687 .2428 .70998 .27566 .75822 .24537 .73611 .2167 Metetra
.729 .796 .905 r
.73611 .2167 .75822 .24537 .807 .21606 .78593 .1903 Metetra
.606 .737 .938 r
.12274 .38764 .15209 .41337 .19184 .4074 .16317 .37791 Metetra
.613 .713 .916 r
.16317 .37791 .19184 .4074 .23244 .40131 .20441 .36766 Metetra
.619 .688 .893 r
.20441 .36766 .23244 .40131 .27395 .39458 .2465 .3567 Metetra
.625 .666 .87 r
.2465 .3567 .27395 .39458 .31642 .38667 .28945 .34482 Metetra
.63 .649 .85 r
.28945 .34482 .31642 .38667 .35986 .37701 .33327 .33183 Metetra
.635 .637 .835 r
.33327 .33183 .35986 .37701 .40426 .36514 .37795 .31759 Metetra
.64 .631 .825 r
.37795 .31759 .40426 .36514 .44955 .35073 .42348 .30199 Metetra
.647 .631 .82 r
.42348 .30199 .44955 .35073 .49568 .33365 .46982 .28498 Metetra
.654 .637 .821 r
.46982 .28498 .49568 .33365 .54254 .31398 .51696 .26657 Metetra
.662 .649 .827 r
.51696 .26657 .54254 .31398 .59007 .29197 .56485 .24684 Metetra
.672 .667 .837 r
.56485 .24684 .59007 .29197 .63819 .26807 .61347 .22591 Metetra
.681 .689 .851 r
.61347 .22591 .63819 .26807 .68687 .2428 .6628 .20393 Metetra
.69 .715 .868 r
.6628 .20393 .68687 .2428 .73611 .2167 .71284 .18108 Metetra
.697 .742 .886 r
.71284 .18108 .73611 .2167 .78593 .1903 .76358 .15758 Metetra
.635 .71 .901 r
.09313 .35645 .12274 .38764 .16317 .37791 .13412 .34389 Metetra
.636 .694 .887 r
.13412 .34389 .16317 .37791 .20441 .36766 .17589 .33083 Metetra
.638 .68 .873 r
.17589 .33083 .20441 .36766 .2465 .3567 .21845 .31721 Metetra
.639 .668 .861 r
.21845 .31721 .2465 .3567 .28945 .34482 .2618 .30295 Metetra
.641 .658 .851 r
.2618 .30295 .28945 .34482 .33327 .33183 .30597 .28799 Metetra
.643 .652 .844 r
.30597 .28799 .33327 .33183 .37795 .31759 .35095 .27229 Metetra
.646 .648 .838 r
.35095 .27229 .37795 .31759 .42348 .30199 .39675 .25581 Metetra
.649 .648 .836 r
.39675 .25581 .42348 .30199 .46982 .28498 .44337 .23853 Metetra
.652 .651 .836 r
.44337 .23853 .46982 .28498 .51696 .26657 .4908 .22045 Metetra
.656 .658 .839 r
.4908 .22045 .51696 .26657 .56485 .24684 .53904 .20158 Metetra
.661 .667 .845 r
.53904 .20158 .56485 .24684 .61347 .22591 .58809 .18194 Metetra
.666 .679 .853 r
.58809 .18194 .61347 .22591 .6628 .20393 .63795 .16157 Metetra
.671 .693 .862 r
.63795 .16157 .6628 .20393 .71284 .18108 .68862 .14052 Metetra
.676 .709 .873 r
.68862 .14052 .71284 .18108 .76358 .15758 .74011 .11884 Metetra
.646 .698 .884 r
.06303 .32212 .09313 .35645 .13412 .34389 .10448 .30772 Metetra
.647 .69 .876 r
.10448 .30772 .13412 .34389 .17589 .33083 .14667 .29291 Metetra
.647 .682 .869 r
.14667 .29291 .17589 .33083 .21845 .31721 .18962 .27767 Metetra
.647 .676 .863 r
.18962 .27767 .21845 .31721 .2618 .30295 .23334 .26197 Metetra
.648 .671 .858 r
.23334 .26197 .2618 .30295 .30597 .28799 .27785 .24578 Metetra
.649 .668 .855 r
.27785 .24578 .30597 .28799 .35095 .27229 .32316 .2291 Metetra
.65 .666 .852 r
.32316 .2291 .35095 .27229 .39675 .25581 .36927 .2119 Metetra
.651 .666 .851 r
.36927 .2119 .39675 .25581 .44337 .23853 .41621 .19417 Metetra
.653 .667 .851 r
.41621 .19417 .44337 .23853 .4908 .22045 .46398 .17591 Metetra
.655 .67 .853 r
.46398 .17591 .4908 .22045 .53904 .20158 .5126 .1571 Metetra
.657 .675 .855 r
.5126 .1571 .53904 .20158 .58809 .18194 .56207 .13776 Metetra
.66 .681 .859 r
.56207 .13776 .58809 .18194 .63795 .16157 .61241 .11788 Metetra
.662 .688 .864 r
.61241 .11788 .63795 .16157 .68862 .14052 .66363 .09746 Metetra
.665 .697 .87 r
.66363 .09746 .68862 .14052 .74011 .11884 .71575 .07653 Metetra
.652 .698 .88 r
.03218 .28654 .06303 .32212 .10448 .30772 .07401 .27095 Metetra
.652 .693 .876 r
.07401 .27095 .10448 .30772 .14667 .29291 .11658 .25501 Metetra
.652 .69 .873 r
.11658 .25501 .14667 .29291 .18962 .27767 .15989 .23872 Metetra
.652 .687 .87 r
.15989 .23872 .18962 .27767 .23334 .26197 .20396 .22204 Metetra
.652 .685 .868 r
.20396 .22204 .23334 .26197 .27785 .24578 .24882 .20499 Metetra
.653 .683 .866 r
.24882 .20499 .27785 .24578 .32316 .2291 .29448 .18753 Metetra
.653 .682 .865 r
.29448 .18753 .32316 .2291 .36927 .2119 .34095 .16968 Metetra
.654 .682 .864 r
.34095 .16968 .36927 .2119 .41621 .19417 .38826 .1514 Metetra
.655 .683 .864 r
.38826 .1514 .41621 .19417 .46398 .17591 .43642 .13271 Metetra
.656 .684 .865 r
.43642 .13271 .46398 .17591 .5126 .1571 .48545 .11358 Metetra
.657 .686 .866 r
.48545 .11358 .5126 .1571 .56207 .13776 .53536 .09401 Metetra
.658 .689 .868 r
.53536 .09401 .56207 .13776 .61241 .11788 .58618 .07399 Metetra
.659 .693 .87 r
.58618 .07399 .61241 .11788 .66363 .09746 .63793 .05352 Metetra
.66 .697 .873 r
.63793 .05352 .66363 .09746 .71575 .07653 .69063 .03259 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{272.125, 204.5},
  ImageMargins->{{Inherited, 0}, {0, 3.3125}},
  ImageRegion->{{0.07, 1}, {0, 0.97}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005D0000oa000`40O003h00OogooEGoo003oOomE
Ool00?mooeEoo`00ogooEGoo003oOomEOol00?mooeEoo`00ogoo1Woo1@00BWoo003oOol6Ool01@00
Oomoogoo0000BWoo003oOol7Ool00`00Oomoo`1;Ool00?eoo`H000Aoo`03001oogoo04Yoo`00ogoo
2Goo00<007ooOol0BGoo003oOol:Ool00`00Oomoo`18Ool00?moo`Ioo`05001oogooOol0001:Ool0
0<ioo`D002Aoo`8000eoo`<004]oo`00cWoo00D007ooOomoo`00029oo`D005Yoo`00cgoo00<007oo
Ool087oo0`000goo0P00FWoo003@Ool00`00Oomoo`0MOol20006Ool00`00Ool0001IOol00=5oo`03
001oogoo01Uoo`<000Qoo`04001oogoo001HOol00=9oo`03001oogoo01Eoo`<000]oo`04001oogoo
001HOol00<ioo`05001oogooOol0000EOol2000>Ool01@00Oomoogoo0000Egoo003?Ool3000COol3
000@Ool00`00Oomoo`02Ool00`00Oomoo`1DOol00>=oo`8000=oo`03001oogoo00eoo`04001oogoo
Ool2001FOol00>1oo`<001Ioo`03001oogoo009oo`03001oogoo05=oo`00PGoo0P00Fgoo0P0067oo
0P001Goo00<007ooOol0DWoo0021Ool2001HOol3000HOol200000e;K00000004Ool00`00Oomoo`1B
Ool0081oo`04001oogoo001EOol2000HOol30003D[/20005Ool00`00Oomoo`1AOol0081oo`04001o
ogoo001BOol3000HOol200002E:jD]]B^e;KD[YBf`00D]/00005Ool00`00Oomoo`1@Ool007moo`03
001oogoo009oo`03001oogoo04aoo`@001Moo`<000QB^`03001B^`0000Eoo`03001oogoo051oo`00
OWoo0`000Woo0`00Bgoo0P0017oo0P004goo0P0000mBfe:kD]]B^U;KD[]Bfe:jD]]B^e;K001Bfe:k
000017oo0P00DGoo003>Ool3000HOol3000=D[/01@00D[]B^e:k000017oo00<007ooOol0Cgoo003<
Ool2000HOol300005E:jD[/005;KD[]Bfe:jD]]B^e;KD[YBfe:kD]]B^U;K001Bfe:jD]/00005Ool0
0`00Oomoo`1>Ool00<Uoo`<001Moo`<000EB^`03001B^e:k00]B^`03001B^e:k009B^`03001oogoo
00=oo`03001oogoo04eoo`00agoo0P005goo0`0001aB^U:kD[YBfe:jD[]B^U;KD[X005:jD]]B^e;K
D[YBfe:kD]]B^U;KD[]Bf`00D]]B^e;KD[X000Eoo`03001oogoo04eoo`00a7oo0`005Woo0`0035:k
00<005:kD[/02U:k00<005:kD[/00e:k00<007ooOol00goo00<007ooOol0C7oo0032Ool20003Ool0
0`00Oomoo`0@Ool300008e:jD[]B^U;KD[YB^e:jD]]B^U:kD[YBfe:jD[]B^U;K001Bfe:jD]]B^e;K
D[YBfe:kD]]B^U;K001Bfe:jD]]B^e;K00001Woo00<007ooOol0Bgoo002oOol3000FOol20002D[/0
0`00D[]B^`0?D[/00`00D[]B^`08D[/00`00D[]B^`03D[/20005Ool2001<Ool00;aoo`<001Moo`80
000UD[]B^U:kD[X005:jD]]B^U:kD[YBfe:jD[]B^U;KD[YB^e:jD]]B^U:kD[X005:kD]]B^U;KD[]B
fe:jD]]B^e;K001Bfe:kD]/00P0000=B^UKK000017oo0P00C7oo002jOol2000GOol30007D[/00`00
D[]B^`0?D[/00`00D[]B^`07D[/40004D[/00`00Oomoo`04Ool00`00Oomoo`19Ool008moo`@002Ao
o`<001Moo`80000UD[YB^e:jD[]B^U:kD[YB^e:jD[/005:kD[YBfe:jD[]B^U;KD[YB^e:jD]]B^U:k
D[YBfe:jD[/005;KD[]Bfe:jD]]B^e;KD[X00P0000UFfe:jE]]B^UKKD[YFfe:j00001Goo00<007oo
Ool0BGoo002>Ool00`00Oomoo`02Ool00`00Oomoo`0OOol2000HOol2000=D[/00`00D[]B^`0?D[/0
0`00D[]B^`02D[/300000e:k001B^`07D[/00`00Oomoo`04Ool00`00Oomoo`18Ool008ioo`03001o
ogoo009oo`03001oogoo01aoo`<0009oo`03001oogoo019oo`<0000TD[YB^e:jD[]B^U:kD[YB^e:j
D[]B^U:kD[YB^e:jD[/005:kD[YBfe:jD[]B^U;KD[YB^e:jD]]B^U:kD[YBfe:j001B^U;K0P0000mB
^UKKD[YFfe:j001B^UKKD[YFfe:jE]]B^UKK00001Woo00<007ooOol0Agoo002>Ool00`00Oomoo`02
Ool00`00Oomoo`0JOol2000GOol30002D[/00`00D[]B^`0>D[/00`00D[]B^`0>D[/30007D[/00`00
D[]B^`07D[/00`00Oomoo`03Ool00`00Oomoo`17Ool008ioo`03001oogoo009oo`03001oogoo01Mo
o`<001Moo`80000UD[YB^e:JD[]B^P00D[YB^e:jD[]B^U:kD[YB^e:jD[]B^U:kD[YB^e:jD[]B^P00
D[YB^e:jD]]B^U:kD[YBfe:jD[]B^U;KD[X00P0001EF^e:j001B^UKKD[YFfe:jE]]B^P00D[YFfe:j
E]]B^UKKD[YFfe:j00001Goo0P004Goo1@00<Woo002>Ool00`00Oomoo`02Ool00`00Oomoo`0EOol2
000GOol300000e:kD[YB^`02D[/015:jD[]B^`004E:k00<005:kD[/025:k0P000U:k00=B^U:k0000
1e:k00<005:kD[/025:k00<007ooOol017oo00<007ooOol047oo00<007ooOol0<Woo002>Ool00`00
Oomoo`02Ool00`00Oomoo`0BOol3000FOol300009E:kDYYB^e:jD[]BVU:kD[YB^e:JD[]B^P00D[YB
^e:jD[]B^U:kD[YB^e:jD[]B^U:kD[YB^e:jD[/005;KD[YB^e:jD]]B^U:k00<0000JD[]B^UJkD[YB
^e:jE[/005KKD[YFfe:jE]]B^P00D[YFfe:jE]]B^UKKD[YFfe:jE]/000Ioo`03001oogoo011oo`03
001oogoo039oo`00Sgoo10004Woo0`005Woo0`0000=B^e:jD[/00U:k00EB^U:kD[]B^e:j00=B^`03
D[YB^`00015B^`03001B^e:k009B^`800003D[]B^U:k009B^`06D[YB^e:kD[]B^P001U:k00<005:k
D[/02E:k00<007ooOol017oo00<007ooOol017oo1P001Goo00<007ooOol0<Woo002SOol200000goo
0000000DOol200009e:kCYX005:jD[]BVU:kD[YB^e:JD[]B^U:kDYYB^e:jD[]BVU:k001B^e:jD[]B
^U:kD[YB^e:jD[]B^U:kD[YB^e:jD[]B^P00D[YBf`02000085:jE[]B^U:kD[YF^e:jD[]B^UJkD[YB
^e:j001B^UKKD[YFfe:j001B^UKKD[YFfe:jE]]B^UKKD[YFfe:j0007Ool00`00Oomoo`0>Ool00`00
Oomoo`0bOol00:1oo`<001Moo`800005D[YB^e:kD[/00003D[/01E:jD[]B^e:kD[X00e:k00MB^U:k
D[]B^e:jD[/0000?D[/30003D[/01E:jD[]B^e:kD[X00e:k00IB^U:kD[]B^e:j0004D[/00`00D[]B
^`09D[/20006Ool00`00Oomoo`0>Ool00`00Oomoo`0bOol009ioo`8001Moo`<0000UD[]B^U:kCYYB
^e:jD[/005:kD[YB^e:JD[]B^U:kDYYB^e:jD[]BVU:kD[YB^e:J001B^U:kD[YB^e:jD[]B^U:kD[YB
^e:jD[/00`00029B^e:J001B^UJkD[YB^e:jE[]B^U:kD[YF^e:jD[]B^UJkD[YB^`00E]]B^UKKD[X0
05:jE]]B^UKKD[YFfe:jE]]B^P800003E]]B^`0000Ioo`03001oogoo00]oo`<003Aoo`00Vgoo0`00
5goo0P000e:k00EB^U:kD[]B^e:j009B^`03001B^U:k009B^`05D[YB^e:kD[]B^P03D[/01U:jD[]B
^e:kD[X000UB^`80009B^P06D[]B^U:j001B^e:j0e:k00EB^U:kD[]B^e:j00=B^`05D[YB^e:kD[/0
0003D[/00`00D[]B^`04D[/30002E]/00e:kE]/00007Ool00`00Oomoo`0<Ool00`00Oomoo`0bOol0
09Uoo`8001Qoo`80000UD[YB^djJD[]B^U:kCYYB^e:jD[]>VU:kD[X005:JD[]B^U:kDYYB^e:jD[]B
VU:kD[YB^e:JD[]B^U:kDYX005:jD[]B^U:kD[X00`00029BVU:kDYYB^e:JD[]BVU:k001B^e:jE[]B
^U:kD[YF^e:jD[]B^UJkD[YB^e:jE[]B^P00D[YFfe:j001B^UKKD[YFf`800009D[]Ffe:jE]]B^eKK
D[YFf`0000Aoo`<004=oo`00UWoo0`005goo0`0000=B^e:jD[/00U:k00EB^U:kD[]B^e:j00=B^`05
D[YB^e:k001B^P03D[/01E:jD[]B^e:kD[X00e:k00EB^U:kD[]B^`00009B^`<00003D[YB^e:j009B
^P07D[]B^U:jD[YB^e:j00000U:k00EB^U:kD[]B^e:j00=B^`05D[YB^e:kD[]B^P02D[/01@00D[]B
^`00D[/00`0000=Ffe:kE]/00UKK00IB^eKKE]]Ffe:k0007Ool00`00Oomoo`10Ool009Aoo`800003
Ool007oo01Eoo`80000TD[]>VP00D[YB^djJD[]B^U:kCYYB^e:jD[]>VU:kD[YB^djJD[/005:kDYYB
^e:jD[]BVU:kD[YB^e:JD[]B^U:kDYYB^e:j0`0002=BVU:kDYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:k
DYX005:jD[]B^UJkD[YB^e:jE[]B^U:kD[YF^e:jD[]B^UJk001Ffe:j0080000?E]]B^UKKD[]Ffe:j
E]]B^eKKD[YFfe:kE]]B^P0000Moo`03001oogoo03moo`00TGoo0`0017oo00<007ooOol047oo0`00
00EB^U:kD[]B^`0000=B^`05D[YB^e:kD[]B^P03D[/02E:jD[]B^e:kD[YB^`00D[]B^P03D[/01E:j
D[]B^e:kD[X00e:k0P0000=BVU:j00000U:j00EB^e:jD[YB^U:k00=B^P07D[]B^U:jD[YB^e:j0000
0U:k00EB^U:kD[]B^e:j00=B^`05D[YB^e:kD[]B^P040003E]/01E:kE]]FfeKKD[/00eKK00EB^eKK
E]]Ff`0000Moo`03001oogoo03moo`00SWoo0`005goo0`0002E>VU:kDYYB^djJD[]BVU:k001B^e:j
D[]>VU:kD[YB^djJD[]B^U:kCYYB^e:jD[]>VU:k001B^e:JD[]B^U:kDYYB^e:jD[]BVP0200008e:k
DYYB^e:J001BVU:kDYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:kDYYB^`00E[]B^U:kD[YF^e:jD[]B^UJk
D[YB^e:jE[/00P0001EB^UKK000005:jE]]B^eKKD[YFfe:kE]]B^UKKD[]Ffe:jE]]B^eKK00001goo
00<007ooOol0?Woo002<Ool2000HOol200001E:jD[]B^e:kD[X00e:k00EB^U:kD[]B^`0000=B^`05
D[YB^e:kD[]B^P03D[/01U:jD[]B^e:kD[X0009B^`05D[YB^e:kD[]B^P03000025:JD[YBVU:jDYYB
^U:J0003D[X01E:kD[YB^U:jD[/00e:j00IB^e:jD[YB^U:k0003D[/01E:jD[]B^e:kD[X00U:k0P00
00AB^e:jE[]B^P800003E]]B^eKK009Ff`05D[]FfeKKE]]B^`03E]/015:kE]]Ff`0027oo00<007oo
Ool0?Goo0029Ool3000GOol300009E:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VU:kDYX004jJD[]B^U:k
CYYB^e:jD[]>VU:kD[YB^djJD[]B^U:kCYX005:jD[]BVU:k0080000SDYYB^e:JD[]BVU:kDYYB^e:J
D[/005:kDYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:kDYYB^e:J001B^UJkD[YB^e:jE[]B^P0300006U:j
E[]B^UKKD[YF^e:j001B^eKKD[YFfe:kE]]B^UKKD[]Ffe:jE]]B^eKKD[YFfe:k0006Ool2000oOol0
08Moo`8001Moo`<0009B^`03001B^U:k009B^`05D[YB^e:kD[]B^P03D[/01E:jD[]B^`00D[X00e:k
00EB^U:kD[]B^e:j00=B^`05D[YB^e:kD[/00002D[/200003e:jDYYB^U:JD[YBVU:jDYYB^U:JD[YB
VU:j001B^`03D[X01E:kD[YB^U:jD[/00e:j00IB^e:jD[YB^P00D[X3D[/200002U:jE[]B^U:kD[YF
^e:jD[]B^UJk0P000UKK00EB^eKKE]]Ffe:k00=Ff`07D[]FfeKKE]]B^eKK000027oo00<007ooOol0
?7oo0024Ool300000goo001oo`0DOol200009U:kDYYB^djJD[/005:kCYYB^e:JD[]>VU:kDYYB^djJ
D[]BVU:kCYYB^e:J001>VU:kD[YB^djJD[]B^U:kCYYB^e:jD[]>VU:kD[X300008e:JD[]BVU:kDYYB
^e:JD[]BVU:kDYYB^e:JD[]BVP00DYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:kDYYB^e:JD[/005:kD[X0
0P00021F^e:jE]]B^UJkD[YFfe:jE[]B^UKKD[YF^`00E]]B^eKKD[YFfe:kE]]B^UKKD[]Ffe:jE]]B
^eKKD[YFf`0027oo00<007ooOol0>goo0022Ool2000GOol30002D[/02E:jD[]B^e:kD[YB^`00D[]B
^P03D[/01E:jD[]B^e:kD[X00e:k00EB^U:k001B^e:j00=B^`05D[YB^e:kD[]B^P02D[/300005U:J
D[X005:jDYYB^U:JD[YBVU:jDYYB^U:JD[YBVU:jDYYB^U:J001B^U:k0e:j00EB^e:jD[YB^U:k00=B
^P03D[]B^P000080000?D[YB^e:jE[]B^U:kD[YF^e:jD[]B^UJkD[YB^e:j008000=Ff`05D[]FfeKK
E]]B^`03E]/00e:kE]]Ff`0200000eKk001oo`06Ool00`00Oomoo`0kOol007moo`<001Ioo`<0000V
DYYB^djJD[]BVU:kCYYB^e:JD[]>VP00DYYB^djJD[]BVU:kCYYB^e:JD[]>VU:kDYYB^djJD[/005:k
CYYB^e:jD[]>VU:kD[YB^`80000TDYYB^djJD[]BVP00DYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:kDYYB
^e:JD[/005:kDYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:k0P00019BVUJk001F^e:jE]]B^UJkD[YFfe:j
E[]B^UKKD[YF^e:jE]/2000035:jE]]B^eKKD[YFfe:kE]]B^UKKD[]Ff`800005E]]Jo5KKF_`00007
Ool00`00Oomoo`0jOol0059oo`D002Ioo`8001Ioo`<0009B^`05D[YB^e:kD[]B^P03D[/01U:jD[]B
^e:kD[X0009B^`05D[YB^e:kD[]B^P03D[/02E:jD[]B^e:kD[YB^`00D[]B^P03D[/300001E:jDYYB
VU:JD[X00e:J018005:JD[YBVU:jDYYB^U:JD[YBVU:jDYYB^U:JD[YBVU:j0002D[X01E:kD[YB^U:j
D[/00e:j0P000e:j01EBVP00D[YF^e:jD[]B^UJkD[YB^e:jE[]B^U:kD[YF^e:j001B^P00D[/00eKK
00EB^eKKE]]Ffe:k00800003E_]FfeKk009Fn`03E]/007oo00Ioo`03001oogoo03Yoo`00DWoo00D0
07ooOomoo`0002=oo`<001Ioo`80000VDYYB^`00D[]BVU:kCYYB^e:JD[]>VU:kDYYB^djJD[]BVU:k
CYX005:JD[]>VU:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VP00D[YB^`<0000TD[]>VU:kDYYB^djJD[]B
VU:kCYYB^`00D[]BVU:kDYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:kDYX005:JD[]BVU:kDYYB^e:J0`00
021BVUJkDYYF^e:JE[]BVP00D[YF^e:jE]]B^UJkD[YFfe:jE[]B^UKKD[YF^`00E]/005KKD[YFfe:k
E]]B^UKK0P0000YFfe[lE]]Jo5KKF_aFfe[lE]/000Ioo`8003]oo`00Dgoo00<007ooOol08Goo0`00
5Woo0`0000IB^e:jD[]B^`00D[X3D[/01E:jD[]B^e:kD[X00e:k00EB^U:kD[]B^`0000=B^`05D[YB
^e:kD[]B^P03D[/015:jD[]B^e:k0`0000EB^U:JDYYBVU:j00=BVP05D[YBVU:JDYYB^P02DYX04P00
D[YBVU:jDYYB^U:JD[YBVU:jDYYB^U:JD[YBVU:jDYX000=B^P03D[/00000009B^P05DYYB^U:jD[YB
VP03D[X05@00D[]B^UJkD[YB^e:jE[]B^U:kD[YF^e:jD[]B^P00D[YB^`00E]]B^`02E]/20003E_/0
1EKKE_]FneKkE]/00eKk00=Ff`00Ool01Woo00<007ooOol0>7oo001:Ool60004Ool00`00Oomoo`0N
Ool20003Ool00`00Oomoo`0@Ool300009E:kCYYB^e:JD[]>VU:kDYX004jJD[]BVU:kCYYB^e:JD[]>
VU:kDYYB^djJD[]BVU:k001B^e:JD[]>VU:kDYYB^djJD[]BVU:k00<0000VD[Y>VP00DYYB^djJD[]B
VU:kCYYB^e:JD[]>VU:kDYYB^djJD[/005:kDYYB^e:JD[]BVU:kDYYB^e:JD[]BVU:kDYYB^`00D[]B
VP80000QE[]BVUJkDYYF^e:JE[]BVUJkDYYF^e:JE[/005KKD[YF^e:jE]]B^UJkD[YFfe:jE[]B^UKK
001F^e:j001B^eKK0080000@E]]Jo5KKF_aFfe[lE]]Jo5KKF_aFfe[lE]]Jo5KK0006Ool00`00Oomo
o`0hOol005Eoo`03001oogoo01Yoo`<001Ioo`800003D[]B^U:k009B^`05D[YB^e:kD[]B^P02D[/0
0`00D[YB^`02D[/01E:jD[]B^e:kD[X00e:k00EB^U:kD[/005:j00=B^`05D[YB^e:kD[]B^P020005
DYX01000DYYBVU:j0e:J00EB^U:JDYYBVU:j00=BVP0BD[YBVP00DYYB^U:JD[YBVU:jDYYB^U:JD[YB
VU:jDYYB^U:J0`0000EBVU:jD[YB^U:J00=B^P05DYYB^U:jD[YBVP03D[X04000D[]B^UJkD[YB^e:j
E[]B^U:kD[YF^e:j001B^UJk0`0000=FneKKE_/00UKk00EFfeKkE_]FneKK00=Fn`05E]]FneKkE_/0
0007Ool00`00Oomoo`0gOol005Ioo`03001oogoo01Moo`8001Ioo`<0000UCYYB^e:JD[]>VU:kDYYB
^djJD[]BVU:kCYYB^`00D[]>VU:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VU:kDYX004jJD[]BVU:kCYX0
0`0002E>VU:kDYYB^TjJD[]BVU:j001B^e:JD[]>VU:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VP00DYYB
^e:JD[]BVU:kDYYB^e:JD[]BVP03000085:JE[X005JkDYYF^e:JE[]BVUJkDYYF^e:JE[]BVUJkDYYF
^e:J001B^UKKD[YF^e:jE]]B^UJkD[YFfe:jE[/300005UKKE[X005KKF_aFfe[lE]]Jo5KKF_aFfe[l
E]]Jo5KKF_aFfe[lE]]Jo0001goo00<007ooOol0=Woo001BOol01@00Oomoogoo00005Woo0`005Woo
0P0000EB^U:k001B^e:j00=B^`05D[YB^e:kD[]B^P03D[/01E:jD[/005:kD[X00e:k00EB^U:kD[]B
^e:j00=B^`05D[YB^`00D[]B^P03000;DYX01@00DYYBVU:JD[X00e:J00EB^U:JDYYBVU:j00=BVP0;
D[X005:jDYYB^U:JD[YBVU:jDYYB^P020005DYX01000D[YB^U:J0e:j00EBVU:jD[YB^U:J00=B^P0>
DYYB^U:j001B^U:kD[YF^e:jD[]B^UJkD[YB^`8000AFf`05001FneKkE_]Ff`03E_/01EKKE_]FneKk
E]/00eKk00EFfeKkE_]Fn`0000Ioo`03001oogoo03Ioo`00Dgoo0`005Goo0P005Woo0`0002AB^e:J
D[]>VP00DYYB^djJD[]BVU:kCYYB^e:JD[]>VU:kDYYB^djJD[/005:kCYYB^e:JD[]>VU:kDYYB^djJ
D[]BVU:kCYX300009TjJD[]BVU:jCYYB^e:JD[Y>VU:kDYYB^TjJD[]BVP00CYYB^e:JD[]>VU:kDYYB
^djJD[]BVU:kCYYB^e:JD[/005:kDYYB^e:JD[/300008EJjDYYB^U:JE[YBVU:jDYX005:JE[]BVUJk
DYYF^e:JE[]BVUJkDYYF^e:JE[]BVUJk001F^e:jE]]B^UJkD[YFf`03000065KK001FfeJjE]]FfUKK
001Jo5KKF_aFfe[lE]]Jo5KKF_aFfe[lE]]Jo5KKF_aFf`800003Gc`007oo00Eoo`03001oogoo021o
o`<0019oo`00J7oo0`005Goo0`000e:k00IB^U:kD[]B^e:j0002D[/01E:jD[]B^e:kD[X00e:k00IB
^U:kD[]B^e:j0002D[/01E:jD[]B^e:kD[X00e:k00AB^U:k0000009BVP03001BVU:J00eBVP03001B
^U:J009BVP05D[YBVU:JDYYB^P03DYX01e:jDYYBVU:J001BVU:j00<000]BVP05001B^U:jD[YBVP03
D[X01E:JD[YB^U:jDYX00e:j00MBVU:j001F^e:jD[]B^P020004E]/00`00E]]Ff`04E]/01@00E_]F
neKkE]/00eKk00IFfeKkE_]FneKKE_/20003Fa`00e/l001oo`03Ool00`00Ool0000QOol01000Oomo
o`004Goo001VOol20003Ool00`00Oomoo`0@Ool200009E:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VP00
DYYB^djJD[]BVU:kCYYB^e:JD[]>VU:kDYYB^djJ001BVU:kCYYB^e:JD[]>VU:k00<0000UD[]>VU:j
CYX005:JD[Y>VU:kDYYB^TjJD[]BVU:jCYYB^e:JD[Y>VU:k001B^djJD[]BVU:kCYYB^e:JD[]>VU:k
DYYB^djJD[/00`0002=F^U:JD[YBVUJjDYYB^U:JE[YBVU:jDYYF^U:JD[X005JkDYYF^e:JE[]BVUJk
DYYF^e:JE[]BVUJkDYYF^e:J001B^UJk0080000IE]YFfeJjE]]FfUKK001FfeKJE]]F^UKKE]YFf`00
F_aFfe[lE]]Jo5KKF_aFfe[lE]/00P0000QO?5/LGcaK6ellFaaO?0001Goo00<007ooOol07goo00<0
07ooOol04Woo001SOol3000EOol30002D[/01E:jD[]B^e:kD[X00e:k00EB^U:kD[]B^`0000=B^`05
D[YB^e:kD[]B^P03D[/01U:jD[]B^e:kD[X0009B^`03D[YB^`00008000QBVP03001BVU:J00eBVP03
001BVU:j00=BVP05D[YBVU:JDYYB^P03DYX20002DYX00`00DYYBVP0>DYX01@00D[YB^U:jDYX00e:j
00EBVU:jD[YB^U:J00=B^P<000QFf`03001FfeKK00EFf`03001FfeKk009Fn`08E]]FneKkE_]Ff`00
FaaK?0=K7005FcaK75/LFa`00006Ool00`00Oomoo`0NOol00`00Oomoo`0BOol0061oo`<001Ioo`80
000UC[YB^`00D[]BVU:kCYYB^e:JD[]>VU:kDYYB^djJD[]BVU:k001B^e:JD[]>VU:kDYYB^djJD[]B
VU:kCYYB^e:JD[/005:kDYX00P0002MB^djJD[Y>VU:kCYYB^TjJD[]>VU:j001B^e:JD[Y>VU:kDYYB
^TjJD[]BVU:jCYYB^e:JD[Y>VP00DYYB^djJD[]BVU:kCYYB^e:JD[/00P0002=BVE:JCYUBVP00D[YB
VUJjDYYB^U:JE[YBVU:jDYYF^U:JD[YBVUJjDYX005:JE[]BVUJkDYYF^e:JE[]BVUJkDYYF^e:J0080
000KE[YB^P00E]YFfeJjE]]FfUKKE[YFf`00E]]F^UKKE]YFfeJjE]]FfP00E]]Jo5KKF_aFfe[l0080
000<Fa]O?5/LGcaK6ellFaaO?5/KGcaK70001Woo00<007ooOol07Woo00<007ooOol04Goo001NOol2
000FOol30004D[/00`00D[YB^`02D[/01E:jD[]B^e:kD[X00e:k00EB^U:kD[]B^`0000=B^`05D[YB
^e:kD[]B^P03D[/00e:jD[]B^`03000>DYX00`00DYYBVP0=DYX01000DYYBVU:j0e:J00AB^P000000
00MBVP03001BVU:J00iBVP03001BVU:j009B^P06DYYB^U:jD[YBVU:j0P0015Jj00<005KKE]/01UKK
00<005KKE]/01eKK00@005KKE_]Fn`80009K7005FcaK75/LFaaK?003Fa`01E/lFaaK75/L00001Goo
00<007ooOol077oo1@004Goo001KOol3000EOol300009E:kCYYB^djjD[]>VU:kC[X004jJD[]BVU:k
CYYB^e:JD[]>VU:kDYYB^djJD[]BVP00CYYB^e:JD[]>VU:kDYYB^djJD[]BVU:k0080000WCYYB^`00
D[]>VU:jCYYB^djJD[Y>VU:kCYYB^TjJD[]>VU:j001B^e:JD[Y>VU:kDYYB^TjJD[]BVU:jCYYB^e:J
D[X005:kDYYB^djJ0080000SDYY>VE:JDYUBVTjIDYYBVE:JCYT005:JD[YBVUJjDYYB^U:JE[YBVU:j
DYYF^U:JD[YBVUJj001F^e:JE[]BVUJkDYYF^`0300006eJkD[YF^U:jE[]B^UJj001FfeKJE]]F^UKK
E]YFf`00E]]FfUKKE[YFfeKJE]]F^UKK001Jo00200004U/LGcaK6ellFaaO?5/KGcaK75llFa]O?5/L
GcaK6ellFa`000Eoo`03001oogoo00Moo`@002Ioo`00FGoo0P0000=oo`00Ool04goo0P0035:k00<0
05:jD[/00U:k00EB^U:kD[]B^e:j00=B^`05D[YB^e:k001B^P03D[/015:jD[]B^e:k0`0015:J00<0
05:JDYX03E:J00<005:JDYX03E:J00<005:JDYX00P003E:J00<005:JDYX03U:J00<005:jDYX00U:j
0P002eJj00<005KKE]/01EKK00<005KKE]/01eKK00<005/lFa`00U/L00EK?5/LFaaK75/l00=K7005
FcaK75/LFaaK?00200000emL001oo`02Ool00`00Ool00007Ool00`00Oomoo`02Ool00`00Oomoo`0S
Ool005Ioo`<000Aoo`03001oogoo00ioo`<0000TCYYB^djjD[]>VU:kC[YB^djJD[]>^U:kCYYB^`00
D[]>VU:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VU:kDYX004jJD[]BVU:k0`0002MB^djJD[]>VU:kCYYB
^djJ001>VU:kCYYB^TjJD[]>VU:jCYYB^djJD[Y>VU:kCYX004jJD[]BVU:jCYYB^e:JD[Y>VU:kDYYB
^TjJD[/00`0002=BVU:IDYY>VE:JDYUBVTjIDYYBVE:JCYUBVU:IDYX005JjDYYB^U:JE[YBVU:jDYYF
^U:JD[YBVUJjDYYB^U:J001BVUJk0080000MD[YF^U:jE[]B^UJjD[YF^e:jE[YB^UJkD[X005JjE]]F
fUKKE[YFfeKJ001F^UKKE]YFfeJjE]]FfP0200005e/L001O?5/KGcaK75llFa]O?5/LGcaK6ellFaaO
?5/KGc`006=MGeaSOEmL000017oo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol08goo001D
Ool2000FOol20002D[/00`00D[]B^`0=D[/00`00D[]B^P03D[/01E:jD[]B^e:kD[X00e:k00EB^U:k
001B^e:j008000]BVP03001BVU:J00iBVP03001BVU:J00UBVP80009BVP03001BVU:J00iBVP03001B
VU:J00eBVP<0011F^P03001FfeKK00AFf`03001FfeKK00=Ff`8000AJn`03001K?5/L009K7005FcaK
75/LFaaK?003Fa`20002Ge`01EmMGeaOG5mL000017oo00<007ooOol017oo00<007ooOol00Woo00<0
07ooOol08goo001AOol3000FOol2000095:kC[YB^djJD[/005:kCYYB^djjD[]>VU:kC[YB^djJD[]>
^U:kCYYB^`00D[]>VU:kDYYB^djJD[]BVU:kCYYB^e:JD[]>VP<0000WCYYB^djJD[]>VU:kCYYB^djJ
D[]>VU:kCYYB^`00D[Y>VU:kCYYB^TjJD[]>VU:jCYYB^djJD[Y>VU:k001B^TjJD[]BVU:jCYYB^e:J
00<0000SCWUBVTiiDYX005:JCYUBVU:IDYY>VE:JDYUBVTjIDYYBVE:JCYUBVU:I001BVUJjDYYB^U:J
E[YBVU:jDYYF^U:JD[YBVP0200007UJjDYT005:jE[YB^UJkD[YF^U:jE[]B^UJjD[YF^e:jE[YB^UJk
001FfeJjE]]FfUKKE[X005KJE]]F^P80000LFa]Jne/LF_]K6e[k001K75llFa]O?5/LGcaK6ellFaaO
?5/K001OG6=MGeaSOEmLHeeOG6=m0005Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0S
Ool004moo`8001Ioo`<000MB^`03001B^e:k00eB^`04001B^e:kD[X3D[/01U:jD[]B^e:kD[YB^`80
009BVP03001BVU:J00eBVP03001BVU:J00eBVP03001BVU:J009BVP<000QBVP03001BVU:J00iBVP03
001BVU:J00QBVP800005DYYFVU:JEYX0000AE[X00`00E]]Ff`03E]/01000E]/000002E[k00<005/L
Fc`00e/L00=K?5/LFa`00P000emL00EOGEmLGeaOG5mM009OG003001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo02=oo`00C7oo0`005Woo0P0002A>^U:kCYYB^djjD[]>VU:kC[YB
^djJ001>^U:kCYYB^djjD[]>VU:kC[YB^djJD[]>^U:kCYX005:JD[]>VU:kDYYB^djJD[/300009e:k
CYYB^djJ001>VU:kCYYB^djJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[Y>VU:kCYYB^TjJD[]>VU:j
CYYB^djJD[Y>VP00DYYB^P02000094iiDYY>NE:JCWUBVTiiDYY>NE:JCWT005:IDYY>VE:JDYUBVTjI
DYYBVE:JCYUBVU:IDYY>VE:J001B^U:JE[YBVU:jDYYF^P<0000NE[YBVEJjDYUF^U:IE[X005JkD[YF
^U:jE[]B^UJjD[YF^e:jE[YB^UJkD[YF^U:jE[/005KKE[YFfeKJ0P00019K75[kFa]Jne/LF_]K6e[k
FaaJne/KF_/005/LGcaK6ellFa`200003V=mGeaSGEmLHgeOG6=MGeaSOEmLHeeOG6=m0004Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0SOol004Uoo`<000=oo`03001oogoo011oo`<000iB
^`03001B^e:k00eB^`05001B^e:kD[YB^`030002DYX01e:jDYYBVU:JD[YBVP0000mBVP03001BVU:J
00aBVP<000iBVP03001BVU:J00iBVP03001BVU:J009BVP80000;EYYBVUJJDYYFVU:JEYYBVUJJDYX0
000AE[X00`00E]]Ff`03000>F_/01`00FaaK?5/L001OG5mM00=OG005GeeOG5mLGeaOG@03Ge`20000
0f=l001oo`040004Ool4000VOol004Moo`8001Ioo`<0000TD[]>^P00C[YB^djJD[]>^U:kCYYB^djj
D[]>VU:kC[YB^djJ001>^U:kCYYB^djjD[]>VU:kC[YB^djJD[]>^U:k001B^e:J0P0002QB^djJD[]>
VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^TjJD[]>
VU:jCYYB^djJD[Y>VP80000UDYY>N@00CWUBVTiiDYY>NE:JCWUBVTiiDYY>NE:JCWUBVTii001BVE:J
CYUBVU:IDYY>VE:JDYUBVTjIDYYBVE:JCYT005:JD[X00P0001mBVEJjDYUF^U:IE[YBVEJjDYUF^U:I
E[YBV@00D[YF^e:jE[YB^UJkD[YF^U:jE[]B^UJjD[YF^e:jE[YB^P0200004e/KF_/005[kFa]Jne/L
F_]K6e[kFaaJne/KF_]K75[kFa/005ll0080000CGeaSOEmLHeeOG6=mGeaSGEmLHgeOG6=MGe`005mL
HgeOG6=m00000goo00<007ooOol0;7oo0014Ool3000EOol30005D[/00`00D[]B^`0>D[/00`00D[]B
^`0;D[/300000e:JD[YBVP02DYX01E:jDYYBVU:JD[X00e:J00=B^P00DYX03U:J00<005:JDYX01U:J
0`0000EBNU:JDYYBVP0000mBVP03001BVU:J00eBVP<0000AEYYBVUJJDYYFVU:JEYYBVUJJDYYFVU:J
EYYBVUJJDYX0000>E[X200000eKJ001Jn`02000?F_/01000GeaOG5mM0emL00EOGEmLGeaOG5mM009O
G0800007HeaSO6=lHgeSG6=l00000goo00<007ooOol0:goo0012Ool2000EOol3000095:kC[YB^djk
D[]>^U:kC[]B^`00D[]>^U:kCYYB^djjD[]>VU:kC[YB^djJD[]>^U:kCYX004jjD[]>VU:kC[YB^djJ
D[]>^P<0000WCYYB^`00D[]>VU:kCYYB^djJD[]>VU:kCYYB^djJD[]>VU:k001B^djJD[]>VU:kCYYB
^djJD[]>VU:kCYYB^djJD[/005:kCYYB^TjJ00<0000UCWUBVTiiDYY>NE:JCWUBVP00DYY>NE:JCWUB
VTiiDYY>NE:JCWUBVTiiDYY>NE:J001BVU:IDYY>VE:JDYUBVTjIDYYBVE:JCYT00P00021BVU9i001B
VEJjDYUF^U:IE[YBVEJjDYUF^U:IE[YBVEJjDYUF^P00E[YB^UJkD[YF^U:jE[]B^UJjD[YF^e:j0P00
00=JfeKJ00000P0000mJne/K001K75[kFa]Jne/LF_]K6e[kFaaJne/KF_/00P0001QS?000HgeOG6=M
GeaSOEmLHeeOG6=mGeaSG@00HgeOG6=mGeaSOEmLHgeOG6=m0003Ool00`00Oomoo`0ZOol0041oo`80
01Aoo`<000eB^`03001B^e:k00eB^`03001B^e:k00AB^`<00003DYYB^djJ009BVP05001BVU:JDYYB
^P03DYX01E:jDYYBVU:JD[X00e:J00=B^P00DYX03E:J00<005:JDYX00P0000EBNU:JDYYBVU9j00=B
VP04DWYBVU:J000@DYX00`00DYYBVP07DYX20003DYT055:J001FVU:JEYYBVUJJDYYFVU:JEYYBVUJJ
DYYFVU:JEYYBVUJJ0009E[X200001e[J00000000F]YJf`00009Jn`03001Jne[k00QJn`800005Gc]O
?5lkHc`00002Ge`01EmMGeaOG5mLGed00UmL00<006=mHe`00V=l00QSOF=LHgaSO6=mHeaSO0000Woo
00<007ooOol0:Woo0010Ool3000AOol2000095:kC[/004jkD[]>^U:kC[]B^djjD[]>^e:kC[YB^djk
D[/005:kC[YB^djJD[]>^U:kCYYB^djjD[]>VU:kC[YB^`00D[]>^P<0000XCYYB^djJD[]>VU:kCYYB
^djJ001>VU:kCYYB^djJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB^djJD[]>VU:kCYYB
^djJD[/300009U:JCWUBVTiiDYY>NE:JCWUBVTiiDYY>NE:JCWT004iiDYY>NE:JCWUBVTiiDYY>NE:J
CWUBVTiiDYY>N@00CYUBVU:IDYY>VE:JDYT2000085JJDWUBVU9iEYYBNE:J001F^U:IE[YBVEJjDYUF
^U:IE[YBVEJjDYUF^U:IE[YBV@00D[YF^U:jE[]B^UJjD[X500004EKJF]]F^U[KE]YJf`00FaaJn`00
F_]K75[kFa]Jne/LF_/00P0000iS?5lkHcaO>f<lGc]S?000HgeOG6=MGeaSOEmL0P0000iSOEmLHgeO
G6=mGeaSOEmLHgeOG6=mGeaSO@000Woo00<007ooOol0:Goo0010Ool3000?Ool20004D[/00`00D[]B
^`0<D[/00`00D[]B^`0=D[/300000e:JD[]>VP02DYX01U:kCYYBVU:JD[]>VP9BVP05001BVU:JDYYB
^P03DYX01E:jDYYBVU:JD[X00e:J00<005:JDYX025:J0`000U:J00<0059jDYX00U:J00EBNU:JDYYB
VU9j00=BVP04DWYBVU:J000?DYX00`00DYYBVP02DYX200000e:IDYYBV@02DYT05e:JDYUBVE:I001B
VUJJDYYFVU:JEYYBVUJJDYYFVU:JEYYBVUJJDYYFVU:J000015Jj100000=JfU[KE]X00U[J00EJfeKJ
F]YJfP0000=Jn`03001Jne[k00=Jn`0<001O>f<lGc]O?5lkHcaO>ellGc]S?0000UmL00IOGEmL001S
O6=mHe`2Hg`01V=mHeaSO6=lHgeSG09SO0800005He`00000Ool0000ZOol003Moo`@000Eoo`04001o
ogoo000;Ool300008e;KC[]B^djkD]]>^e:k001B^djkD[]>^U:kC[]B^djjD[]>^e:kC[YB^djk001>
VU:kC[YB^djJD[]>^U:kCYYB^djjD[/00P0002M>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VU:kCYYB
^`00D[]>VU:kCYYB^djJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYX0100002QBVTiiDYY>
NE:J001BVTiiDYY>NE:JCWUBVTiiDYY>NE:JCWUBVTiiDYX005:JCWUBVTiiDYY>NE:JCWUBVTiiDYY>
NE:JCWUBVP00DYY>V@80000PDYYBNEJJDWUBVU9iEYYBNE:JDWUFVU9i001BVEJjDYUF^U:IE[YBVEJj
DYUF^U:IE[YBVEJjDYUF^P00E[]B^P@0000CF]]F^U[KE]YJfeJjF]]FfU[KE[YJfeKJ001Jne/LF_/0
05[kFa`00P0000iO>f<lGc]S?5lkHcaO>f<lGc]S?5lkHc`006=m0P00019OG6=mGeaSOEmLHgeOG6=m
GeaSOEmLHgeOG000GeaSG5mL0002Ool00`00Oomoo`0XOol003Ioo`03001oogoo009oo`05001oogoo
Ool00004Ool00`00Oomoo`06Ool2000;D[/00`00D[]B^`0<D[/00`00D[]B^`06D[/300001U:kCYYB
^e:j001>VP9BVP06D[]>VU:JDYYB^djJ0U:J00EB^djJDYX005:j00=BVP05D[YBVU:JDYYB^P03DYX0
15:jDYYBVP000U:J0`0000E>NU:JDYYBVTij00=BVP05CWYBVP00DYYBNP03DYX01E9jDYYBVU:JDWX0
0e:J00=BNU:J00003U:J0`000e:I00EBVU:IDYUBVE:J00=BV@0EDYYBVE:IDYT005:JEYYBVUJJDYYF
VU:JEYYBVUJJDYYFVU:JEYYBVUJJ00<00006F]]FfU[JF]YJfeKJ0U[J00IJfeKJF]YJfU[KE]X2F]X0
0`00F_]Jn`03000045llGc]S?5lkGcaO>f<lGc]O?5lkHcaO>ellGc]S?0000V=l00ISOF=LHgaSO6=m
He`2Hg`00f=mHeaSO00200001UmLHeaOG6=LGe`0009oo`03001oogoo02Moo`00=Woo00<007ooOol0
0Woo00@007ooOomoo`<000=oo`03001oogoo009oo`<0000RC[]B^djkD]]>^e:kC[]BfdjkD[]>^e;K
C[]B^`00D[]>^e:kC[YB^djkD[]>^U:kC[]B^djjD[]>^`00CYYB^djjD[/300009U:kCYYB^djJD[]>
VU:kCYX004jJD[]>VU:kCYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYYB^djJD[]>
VU:kCYX30000:TiiDYY>NE:JCWUBVTiiDYY>NE:JCWUBVTii001>NE:JCWUBVTiiDYY>NE:JCWUBVTii
DYY>NE:JCWUBVP00DYY>NE:JCWUBVTiiDYY>NE:JCWUBVP80000PCWUBVP00DYYBNEJJDWUBVU9iEYYB
NE:JDWUFVU9iDYYBNEJJ001F^U:IE[YBVEJjDYUF^U:IE[YBVEJjDYUF^P<0000EE[X005[KE]YJfeJj
F]]FfU[KE[YJfeKJF]]F^U[KE]YJfeJjF]/005/K00<0000YHcaO>f<lGc]S?5lkHcaO>f<lGc]S?5lk
HcaO>f<l001WO000HgeOG6=mGeaSOEmLHgeOG6=mGeaSO@00HgeOG6=LGeaSOEmLHeaOG000Ool0000Y
Ool003Ioo`03001oogoo009oo`05001oogooOol00006Ool40002D[/00`00D[]B^`0<D[/00`00D[]B
^`0<D[/00`00D[]B^`0200003U:kCYYB^e:jD[]>VU:kD[YB^djJD[]B^P00CYX2DYX01U:kCYYBVU:J
D[]>VP9BVP05D[]>VP00DYYB^P03DYX01E:jDYYBVU:JD[X00U:J0P0000E>VU:J001BVTij00=BVP05
CWYBVU:JDYY>NP03DYX01Dij001BVU:JDWX00e:J00EBNU:JDYYBVU9j00=BVP03DWX005:J00MBVP<0
009BN@05DYUBN@00DYUBVP03DYT01E:JDYUBVE:IDYX00e:I00eBVU:IDYT005JJDYYFVU:JEYYBVUJJ
DYYFVP0400001EJiE[YF^P00E]X00U[J00IJfeKJF]YJfU[KE]X2F]X065[KE]YJfU[JF]]FfU[J001S
?5lkGc`006<lGc]O?5lkHcaO>ellGc]S?5lkGcaO>`80009SG006Ie`006=lHgaSOF=L0V=l015SOF=L
Hg`006=LGeaSG5mLHeaOG6=LGeaSG5mL001oo`0002Qoo`00=Woo00<007ooOol00Woo00@007ooOomo
o`8000=oo`<0000SC[]BfdjkD]a>^e;K001BfdjkD[]>^e;KC[]B^djkD]]>^e:kC[]Bfdjk001>^U:k
C[]B^djjD[]>^e:kC[YB^djkD[]>^P0300009TjJD[]>VU:kCYYB^djJD[]>VU:kCYYB^djJD[/005:k
CYYB^djJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB^djJD[/30000:E:JCWYBVTij001>
NE:JCWUBVTiiDYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYY>NE:JCWUBVTiiDYY>NE:JCWUBVTiiDYY>
N@00CWUBVTiiDYX00`0001mBVU9iDYY>NE:JDWUBVTii001BNE:JDWUFVU9iDYYBNEJJDWUBVU9iEYYB
NE:JDWUFVP00E[YBVEJjDYUF^P0500005UZjEYUF^UJIF[YFV@00E[YJfeKJF]]F^U[KE]YJfeJjF]]F
fU[KE[YJfeKJ0P0001iO6`00HcaO>f<l001S?5lkHcaO>f<lGc]S?5lkHcaO>`00He]WO6=KIgaSFfMl
001SOEmLHgeOG6=mGe`2000036=mGeaSG5mLHgeOG6=LGeaSOEmLHe`0009oo`03001oogoo02Eoo`00
=Woo00<007ooOol00Woo00H007ooOomoo`00Ool30009D[/00`00D[]B^`0=D[/00`00D[]B^`07D[/3
00005DjkD[/005:kCYYB^e:jD[]>VU:kD[YB^djJD[]B^U:kCYYB^`00D[]>VP02DYX01U:kCYYBVU:J
D[]>VP9BVP05D[]>VP00DYYB^P02DYX300002E:JCYYBVTjJDYY>VU:JCYX00002DYX01DijDYYBVU:J
CWX00e:J00E>NU:JDYYBVP0000=BVP05DWYBVU:JDYYBNP03DYX01E9jDYYBVU:J00000U:J0P000U9i
00EBVE9iDWUBNE:I00=BN@05DYT005:IDYUBVP03DYT01E:JDYUBVE:IDYX00e:I00EBVU:I001BVUJJ
00<00003EYX00000009F^P05E[UF^UJjE[YF^@02E[X01P00E]YJfU[JF]]FfP9JfP0JF]]FfU[JF]YJ
feKJ001NnelKG_YO6`00HcaO>`00Gc]S?5lkGcaO>f<lGc]O?5lk001SF`9SG006IeaSFf=LHeaWG000
0V=l015SOF=L001OG6=LGeaSG5mLHeaOG6=LGeaSG5mLHeaOG6=L00<002Moo`00=Woo00<007ooOol0
0Woo00@007ooOomoo`80000SC[]BfdjkD]a>^e;KC[]Bg4jkD]]>^e;LC[/004jkD]]>^e:kC[]Bfdjk
D[]>^e;KC[]B^djkD]]>^`00C[YB^djkD[]>^P0300009djJD[]>VU:kCYYB^`00D[]>VU:kCYYB^djJ
D[]>VU:kCYYB^djJD[]>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VU:kCYYB^`00D[]>VP020000:U:J
CWYBVTijDYY>NU:JCWYBVTijDYX005:JCWUBVTiiDYY>NE:JCWUBVTiiDYY>NE:JCWT004iiDYY>NE:J
CWUBVTiiDYY>NE:JCWUBVTiiDYY>N@<0000ODWUBVTiiDYYBNE:JCWUBVU9iDYY>NE:JDWUBVP00EYYB
NE:JDWUFVU9iDYYBNEJJDWUBVU9iEYYBNE:JDWT00P0001]F^U:I000005JjEYUJ^UJIE[YFVEZjEYUF
^UJIF[X005[KE[YJfeKJF]]F^U[KE]YJfeJjF]/00P00011NnUlKG_YO6ekjGa/006<lGc/005lkHcaO
>f<lGc]S?080000<He]WO6=KIgaSFfMlHe]WO6=KIg`006=m0P0000eOG6=mGeaSG5mLHgeOG6=LGeaS
OEmLHeaOG002000015mL001oo`009Woo000gOol40004Ool2000>D[/00`00D[]B^`0<D[/00`00D[]B
^`0300001DjkD[]B^e:kC[/00e:k01E>^`00D[YB^djJD[]B^U:kCYYB^e:jD[]>VU:kD[YB^djJ001B
VU:kCYX00U:J00IB^djJDYYBVU:kCYX2DYX300003djJDYY>VU:JCYYBVTjJDYY>VU:JCYYBVTjJDYX0
0003DYX01DijDYYBVU:JCWX00e:J00E>NU:JDYX0059j00=BVP05DWYBVU:JDYYBNP02DYX30002DWT0
1000DWUBNE:I0e9i00EBVE9iDWUBNE:I00=BN@05001BVE:IDYUBVP03DYT01U:JDYUBVE:IDYYBV@@0
0004EYX00000E[T3E[X01EJiE[YF^UJjE[T00eJj00EF^EJj001JfeKJ009JfP0JF]]FfU[JF]YJf`00
Ga]NnelKG_YO6ekkGa]NnUlK001S?5lk001O>f<lGc]O?000IeaSF`9SG006IeaSFf=LHeaWG6=K0V=L
00mWG000HeaOG6=LGeaSG5mLHeaOG6=LGeaSG5mLHe`00P000ell00@007ooOol002Eoo`00?Woo1000
01aBg4jkD]]>^e;LC[]BfdjkD]a>^e;KC[]Bg4jk001>^e;KC[]B^djkD]]>^e:kC[]BfdjkD[]>^`<0
000WCYYB^djJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB^djJD[]>VU:kCYYB^djJD[]>
VP00CYYB^djJD[]>VU:kCYYB^djJ00<0000ZCYYBVP00DYY>NU:JCWYBVTijDYY>NU:JCWYBVTijDYY>
NU:J001BVTiiDYY>NE:JCWUBVTiiDYY>NE:JCWUBVP00DYY>NE:JCWUBVTiiDYY>NE:J0P0001m>NE9i
CWUBVTii001>NE:JDWUBVTiiDYYBNE:JCWUBVU9iDYY>NE:JDWT0059iEYYBNE:JDWUFVU9iDYYBN@03
00000e9iEYYBN@020000>5ZjEYUF^UJIF[YFVEJjEYUJ^UJIE[YFVEZjEYUF^UJI001FfU[KE[YJfeKJ
F]]F^U[K001O6ekjGa]NnUlKG_YO6ekjGa]NnP00Gc]S?000HcaO>f<l001WO6=KIgaSFfMlHe]WO6=K
IgaSFfMlHe/200005fMl001SOEmLHeaOG6=mGeaSG5mLHgeOG6=L001OG5llGeaO?5mLGc`007oo0000
9Goo000nOol01@00Oomoogoo00003U:k00<005:kD[/01e:k0`0000E>^e:k001B^djk00=B^`05C[]B
^e:kD[]>^`03D[/05Djk001B^U:kCYYB^e:jD[]>VU:kD[YB^djJD[]B^U:kCYX005:JD[]>VP02DYX3
00005djJDYY>VU:JCYX004jJDYY>VU:JCYYBVTjJDYY>VU:JCYYBVTjJDYY>VP00CWX00e:J00E>NU:J
DYYBVTij00=BVP05CWYBVP00DYYBNP03DYX300000e9iCWUBN@02DWT014iiDWUBN@000e9i00EBVE9i
DWUBNE:I00=BN@05DYUBNE9i001BVP03DYT00e:JDYT000020003DYT00e:J00000002EYT01@00E[YF
^UJjE[T00eJj00EF^EJjE[YF^UJi00=F^P05E[T005[JF]]FfP02F]X200003elKG_]O6ekjGa]NnelK
G_YO6ekkGa]NnP00Gc]S?00300001VMLHe]SG6=LIeaSF`9SG00BIeaSFf=LHe`006MKIg]WFfMl001S
G5mLHeaOG6=LGeaSG5mL0P0025ll00<007oo000097oo000nOol00`00Oomoo`02Ool05@00D]a>^e;K
C[]Bg4jkD]]>^e;LC[]BfdjkD]`005:kC[]BfdjkD[]>^`0300009djkD[]>^e:kC[]B^`00D[]>VU:k
CYYB^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[]>VU:kCYYB^`00D[]>VP03
0000:TjJDYY>VU:KCYYBVTjJDY]>VP00CWYBVTijDYY>NU:JCWYBVTijDYY>NU:JCWYBVTij001>NE:J
CWUBVTiiDYY>NE:JCWUBVTiiDYY>N@00CWUBVP<0000NDWU>NE:JCWUBNDiiDYY>NE9iCWUBVP00DYY>
NE:JDWUBVTiiDYYBNE:JCWUBVU9iDYY>NE:J001BVU9i0`0000EBNEJJDWUBVU9i0080000/EYUBNEJJ
DWT005JIF[YFVEJjEYUJ^UJIE[YFVEZjEYUF^UJIF[YFVEJjEYT005KJF]]F^P00G_YO6ekjGa]NnUlK
G_YO6ekjGa]NnUlKG_YO6ekj001O>`80000VIgaSFfMlHe]WO6=KIgaSFfMlHe]WO6=K001SFfMlHe]W
O6=KIg`006=mGeaSG5mLHgeOG000GcaOG5llGeaO?5mLGcaOG5llGeaO?0<002=oo`00?Woo0P0017oo
00<005:kD[/02e:k00<005:kD[/00`0000E>^e:kD[]B^djk00=B^`05C[/005:kD[]>^`03D[/01Djk
D[]B^e:kC[/00e:k00m>^`00D[YB^djJD[]B^U:kCYYB^e:jD[]>VU:kD[X00`0001m>VU:JCYYBVTjJ
DYY>VU:JCYYBVTjJDYY>VP00CYYBVTjJDYY>VU:JCYYBVTjJDYY>VU:JCYYBVTjJ001>NP03DYX01Dij
DYYBVU:JCWX00e:J0`0000=BNDiiDWT00U9i00E>NE9iDWUBNDii00=BN@04CWUBN@00DYT3DWT01E:I
DWUBNE9iDYT00e9i00=BVE9i00000P000e:I00=BVU:I00000P0000EBVEJIEYUFVE:I009FV@03001F
^EJj009F^P05E[UF^UJjE[YF^@03E[X01UJiE[YF^UJj001JfP80000EG_YO6ekkGa]NnUlKG_]O6ekj
Ga]NnelKG_YO6ekkGa]NnP00HeaWG000009SG007IeaSFf=LHeaWG6=KHe`00P0000aWFfMkIe]WO6MK
Ig]WF`00GeaSG5mLHe`2000<Gc`00`00Ool0000SOol003ioo`03001oogoo00=oo`0>001>^e;LC[]B
fdjkD]a>^e;KC[]Bg4jkD]]>^`<0000WC[]B^djkD[]>^e:kC[]B^djkD[]>^e:kC[/004jJD[]>VU:k
CYYB^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJ00<0000ZCYYB^`00DY]>VU:J
CYYBVdjJDYY>VU:KCYYBVTjJDY/005:JCWYBVTijDYY>NU:JCWYBVTijDYY>NU:JCWYBVP00DYY>NE:J
CWUBVTiiDYY>NE:J0`0001iBNTii001>NE9iCWUBVTiiDWU>NE:JCWUBNDiiDYY>NE9iCWT0059iDYY>
NE:JDWUBVTiiDYYBNE:JCWT300001Tii001BNE:JDWUFVP80000^DWUFVU9iEYUBNEJJDWUFVE9iEYX0
05JjEYUJ^UJIE[YFVEZjEYUF^UJIF[YFVEJjEYUJ^UJIE[X005lKG_YO6ekjGa]NnUlKG_YO6ekjGa]N
nUlKG_YO6ekjGa/200006F<j001SF`00He]WO6=KIgaSFfMlHe]WO000IgaSFfMlHe]WO6=KIgaSFfMl
He/005mL0080000BGeaO?5mLGcaOG5llGeaO?5mLGcaOG5llGeaO?5mL001oo`008Woo000nOol00`00
Ool00004Ool00`00D[]B^`07D[/300001DjkD[/005:kC[/00e:k00E>^e:kD[]B^djk00=B^`05C[/0
05:kD[]>^`03D[/01DjkD[]B^e:kC[/00e:k00L005:kD[YB^djJD[]B^P0300009djJD[]>VTjKCYX0
04jJDYY>VU:JCYYBVTjJDYY>VU:JCYYBVTjJDYX005:JCYYBVTjJDYY>VU:JCYYBVTjJDYY>VU:JCYYB
VP00DYY>NP03DYX300001U9jCWU>NDiiDWX000=BN@05CWUBNE9iDWU>N@03DWT024iiDWUBNE9iCWT0
059iDYT3DWT00e:IDWT000020003DWT015:I001BVE:I0P000eJI00EBVEJIEYUFVE:I00=FV@05DYUF
V@00E[YF^@03E[X01EJiE[YF^UJjE[T00eJj01eF^@00001NfP00Ga]NnelKG_YO6ekkGa]NnUlKG_]O
6ekjGa]NnelK001W>f<kIc]S>P00He`006=K009SG00AIeaSF`00001WO6MKIg]WFfMlIe]WNfMKIgaW
FfMkIe/0000?Gc`2000015/L001oo`008Goo000mOol30006Ool01`00C[]Bg4jkD]]>^e;L0080000W
C[]Bg4jkD]a>^e;L001B^djkD[]>^e:kC[]B^djkD[]>^e:kC[]B^djk001>VU:kCYYB^djJD[]>VU:k
CYYB^djJD[]>VU:k001B^djJ00<0000ZCYYB^djJD[]>VU:kCYYB^djJ001>VU:KCYYBVTjJDY]>VU:J
CYYBVdjJDYY>VU:K001BVTijDYY>NU:JCWYBVTijDYY>NU:JCWYBVTij001>NE:J0`0001mBNTiiDYY>
NE9jCWUBVTiiDWX005:JCWUBNDiiDYY>NE9iCWUBVTiiDWU>NE:JCWUBN@00DYYBNE:JCWUBVP020000
1diiDYYBNE:JCWUBVU9i00<0000LDWUFVE9iEYYBNEJIDWUFVU9iEYUBNEJJDWUFVE9i001FVEJjEYUJ
^UJIE[YFVEZjEYUF^UJIF[X20000;5ZiG]YJ^@00G_YO6ekjGa]NnUlKG_YO6ekjGa]NnUlKG_YO6`00
Ic]S>VLkHcYW>f<j001SF`00He]WO6=K001SFfMlHe]WO6=KIgaSFfMlHe]WO6=KIg`200003V=K001O
?5mLGcaOG5llGeaO?5mLGcaOG5llGe`2000015/KGcaK6ell0P002Goo1@004goo000LOol40005Ool2
0004Ool50004Ool40005Ool00`00Oomoo`07Ool00`00D[]B^`030003D[/01TjkD[]B^e:kC[/0009B
^`05C[]B^e:kD[]>^`03D[/01TjkD[]B^e:kC[/0009B^`05C[]B^e:kD[]>^`03D[/00djkD[]B^`03
0000:TjJD[]>VTjKCYYB^djJCY]>VU:kCYY>VdjJ001>VU:JCYYBVTjJDYY>VU:JCYYBVTjJDYY>VP00
CYYBVTjJDYY>VU:JCYYBVTjJDYY>VU:JCYYBVP<00005DWY>NDiiCWUBNP03CWT01U9jCWU>NDii001>
N@=BN@05CWUBNE9iDWU>N@03DWT01TiiDWUBNE9i001BN@<0009BN@05DYUBNE9iDWUBV@020002DWT0
1@00EYUFVEJIDYT00eJI00EBVEJIEYUFVE:I00=FV@05DYT005JjE[YF^@03E[X00eJiE[YF^P020002
F]X045kJF]UJfU[J001NnUlKG_]O6ekjGa]NnelKG_YO6ekk0P0000QW>f<kIc]S>VLkHc]W>`000V=L
018006=K001WFfMlIe]WNfMKIgaWFfMkIe]WO6MKIg/006MKHe/2Ie/00`00GcaO?007Gc`200002Ell
FaaK75/LGcaK7000Ool0000:Ool00`00Oomoo`0COol001]oo`03001oogoo009oo`03001oogoo009o
o`8000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`08Ool2
00009U;LC[]Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C[]B^djkD[]>^e:kC[]B^djkD[]>^e:kC[]B^djk
001>VU:kCYYB^djJD[]>VU:kCYX30000:TjKD[/005:kCYYB^djJD[]>VU:kCYYB^djJD[]>VU:k001B
VTjJDY]>VU:JCYYBVdjJDYY>VU:KCYYBVTjJ001>NU:JCWYBVTijDYY>NU:JCWYBVP<0000ODYY>N@00
CWUBNTiiDYY>NE9jCWUBVTiiDWY>NE:JCWT004iiDYY>NE9iCWUBVTiiDWU>NE:JCWUBNDiiDYX00`00
00QBVU9iDYY>NE:JDWUBVTii0P0003mBNE9hEYUBN000DWUFVU9iEYUBNEJJDWUFVE9iEYYBNEJIDWUF
VU9iEYT005ZjEYUF^UJIF[YFVEJjEYT005ZiG]YJ^EkJF[UNfUZiG]YJ^@00G_YO6ekjGa]NnUlKG_YO
6ekj001S>VLkHcYW>f<jIc]S>VLkHcYW>`00Ig`00P0000]SFfMlHe]WO6=KIgaSFfMlHe]WO6=K0080
000=IeaSFfMKHc]WG6=K001O?5mLGcaOG5llGe`00P0000aK6ellFa]O?5/KGcaK6ellFa/007oo0009
Ool00`00Oomoo`0COol001]oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo009oo`8000Yoo`03001>^e:k009B^`05C[]B^e:kD[]>^`03D[/01Djk001B^e:kC[/00e:k00E>
^e:kD[]B^djk00=B^`05001B^e:kD[]>^`02D[/300000djkD[]>^`02C[/09000CYY>VdjJD[]>VTjK
CYYB^djJCY]>VU:kCYY>V`00DYY>VU:JCYYBVTjJDYY>VU:JCYYBVTjJDYY>VP00CYYBVTjJDYY>VP@0
0006CYY>NDijCWY>VP000Tii00EBNTiiCWU>NE9j00=>N@06DWY>NDiiCWT004ii0e9i00I>NE9iDWUB
NDiiDWT30002DWT01@00DWUBNE9iDYT00U9i0P001e9i00<005:IEYT00UJI00EBVEJIEYUFVE:I00=F
V@05DYUFVEJIEYT00003E[X01EJiE[X00000F]T00U[J00mNfU[IF]YJfUkJF]UJfP00Ga]NnUlKG_]O
6ekjGa/00P0001YS>VLkHc]W>f<jIc]S>fLkHcYW>f<kIc/006Mk001WO6MKIg]WFfMlIe]WNfMKIgaW
F`000VMK00MSFfMKIe]WFf=KIe/00004Gc`20002Fa`01EllFaaK75/LGc`00e/L00AO?5/L000000Uo
o`03001oogoo01=oo`006goo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol027oo00<007oo
Ool00Woo00<007ooOol02Woo020004jkD]a>^e;LC[]Bg4jkD]a>^e;LC[]Bg4jk001>^e:kC[]B^djk
D[]>^e:kC[]B^djkD[]>^e:k001B^djJ0`0002U>Ve:kCYYB^djKD[]>VU:kCY/004jJD[]>VU:kCYYB
^djJD[]>VU:kCYYB^djJD[/005:JCYYBVdjJDYY>VU:KCYYBVTjJDY]>VU:J001BVTij00<0000PCWUB
VTiiDYY>NE:JCWUBVTiiDYX005:JCWUBNTiiDYY>NE9jCWUBVTiiDWY>NE:J001BNDiiDYY>NE9iCWUB
VP<0000:DYY>NE9iCWUBVP00DYY>NE:JDWT200007UJIDWQBNE9hEYUBN59iDWQFV@00EYUBNEJJDWUF
VE9iEYYBNEJIDWUFVU9iEYUBNEJJDWT005JIF[YFV@80000kG]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfUZi
G]X005lKG_YO6ekjGa/006LkHcYW>f<jIc]S>VLkHcYW>f<jIc]S>VLk001[F`00Ig`006MlHe]WO6=K
IgaSFfMlHe/006<kIeaSFfMKHc]WG6=KIe]S>fML001OG00200003e/KGcaK6ellFa]O?5/KGcaK6ell
Fa]O?5/KGcaK6`020008Ool00`00Oomoo`0COol001]oo`03001oogoo009oo`03001oogoo00]oo`03
001oogoo00=oo`@000Eoo`03001oogoo00Yoo`03001B^djk00=B^`05C[]B^e:kD[]>^`03D[/01Djk
001B^e:kC[/00e:k00E>^e:kD[]B^djk009B^`<00003C[]B^djk009>^`05D[]>^djkC[]B^`03C[/0
7000CYY>VdjJD[]>VTjKCYYB^djJCY]>VU:kCYX004jJDYY>VU:JCYYBVTjJDYY>VU:JCYYBVTjJ0`00
00=>NTjJCWT00Tij00I>VTiiCWY>NTjJCWT2CWX01@00CWU>NDiiDWX00dii00EBNTiiCWU>NE9j009>
N@04001BNDiiDWT30003DWT024iiDWUBNE9iCWUBN@00DYT2000<DWT00`00EYUBV@03EYT01E:IEYUF
VEJIDYT00eJI00=BVEJIEYT00`0000=JfUkJF]T00U[J00INfU[IF]YJfUkJF]T2F]X05UkJF]UJfP00
Ga]NnUlK001W>f<jIc]S>fLkHcYW>f<kIc]S>VLkHc]W>`000VMJ00U[FP00Ig/006MlIe]WNfMKIg`0
0P000VMK00ESFfMKIe]WFf=K00=WF`04He]WF`00Gc`3Fa`01EllFaaK75/LGc`00e/L00QO?5/LFaaK
75ll001oo`001goo00<007ooOol04goo000KOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomo
o`02Ool00`00Oomoo`06Ool2000<Ool06@00D]a>^e;LC[]Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C[]B
^djkD[]>^e:kC[]B^djk00<0000YC[]B_000D[]>Ve:kCYYB^djKD[]>VU:kCY]B^djJD[]>V`00CYYB
^djJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJDYY>VU:KCYYBVTjJDY]>VP03000084ijCYX005:JCWUB
VTiiDYY>NE:JCWUBVTiiDYY>NE:JCWT004iiDYY>NE9jCWUBVTiiDWY>NE:JCWUBNTiiDYX300002e:J
CWUBNDiiDYY>NE9iCWUBVTiiDWT00`0003ABNE9hEYUBN59iDWQFVE9hDWUBN5JIDWQBNE9h001BNEJI
DWUFVU9iEYUBNEJJDWUFVE9iEYYBNEJIDWUFVP00G]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfUZiG]YJ^EkJ
F[UNfUZi001NnP80000CIc]S>VLkHcYW>f<jIc]S>VLkHcYW>f<jIc/006]KIcY[FfLjJe/00P0002ES
FfMlHe]WO000Ie]S>fMLHe]WFf<kIeaSFfMKHc]WG6=KIe/006MK001O?5/KGcaK6ellFa]O?5/KGcaK
6ellFa]O?5/KGcaK6`030005Ool3000EOol001]oo`03001oogoo009oo`03001oogoo00Qoo`05001o
ogooOol00004Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00D[]>^`03D[/01DjkD[]B^e:kC[/0
0e:k00D005:kD[]B^djk009B^`<00003C[]>_4jk009>^`05C[`004jkC[]B^`03C[/01E:kC[]>^djk
D[/00Tjk01D005:kCYY>VdjJD[]>VTjKCYYB^djJCY]>VU:kCYX004jJDYY>VU:JCYX00`001DjJ00H0
04iiCWY>NTjJCWT2CWX02DjJCWU>NTijCYY>NDij001BNP03CWT01E9jCWU>NDiiDWX00Tii10000U9i
00E>NE9iDWUBNDii00=BN@<00003DWU>N@0000mBN@04001FVEJIDYT3EYT01E:IEYUFVEJIDYT00UJI
0P0000AJV@00G]YJf@9JfP06G]YJfE[JF]YNfU[I0U[J01INfU[IF]YJfUkJF]T006<kIc]S>VLkHc]W
>f<jIc]S>fLkHcYW>f<kIc/0009WFP08JeYWFVMJIeY[FVMJ001WF`8000=WF`05He]WFfMKIe]SF`03
Ie/00f=K00000003Hc/00`00GcaK7002Fa`01EllFaaK75/LGc`00e/L00=O?00000000U/L0P001Woo
00<007ooOol04goo000LOol4000<Ool30005Ool50003Ool00`00Oomoo`0>Ool04@00D]a>^e;LC[]B
g4jkD]a>^e;LC[]Bg4jkD]`005:kC[/00`0002U>^e:lC[]Bg4jkD[a>^e;LC[/004jJD[]>Ve:kCYYB
^djKD[]>VU:kCY]B^djJD[/005:kCYYB^djJD[]>VU:kCYYB^djJD[]>VU:k001BVdjJ00<0000QCWY>
VTijDY]>NTjJCWYBVdij001>NE:JCWUBVTiiDYY>NE:JCWUBVTiiDYY>NE:J001BNTiiDYY>NE9jCWUB
VTii0080000:DYY>NE9jCWT004iiDWU>NE:JCWT400008E9iCUQBNDiHDWT005JIDWQBNE9hEYUBN59i
DWQFVE9hDWUBN5JIDWQBN@00EYYBNEJIDWUFVU9iEYUBNEJJDWUFV@020000CeJIF[UFV000F[UNfUZi
G]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfUZiG]YJ^@00G_T006<jIc]S>VLkHcYW>f<jIc]S>VLkHcYW>`00
Je]W>V]KIcY[FfLjJe]W>V]KIcX006=KIe]S>fMLHe]WFf<kIeaSFfMKHc]WG6=K001S>fMKHc]SFf<k
Ie/005llFa]O?5/KGcaK6ellFa]O?5/K00800007FaaJne/LFa/007oo00006goo000lOol2000@Ool0
0`00D[]>^`03D[/01DjkD[]B^e:kC[/00U:k0`0000=>^djlC[/00Tjk00E>_4jkC[]>^djl00=>^`05
001>^djkC[]B^`03C[/01E:kC[]>^djkD[/00Tjk00d005:kCYY>VdjJD[]>VTjKCYYB^djJCY]>VP03
000<CYX00`00CYY>N@02CWX01TjJCWU>NTijCYY>N@9>NP05CYY>N@00CWUBNP03CWT300000diiDWY>
N@02CWT0159j001BNE9i0`000U9i00E>NE9iDWUBNDii00=BN@03001BNE9i00eBN@05001FVEJIEYUB
V@03EYT03E:I000005ZIEYUJVEJIFYUFV@00F]YNfU[I009JfP06G]YJfE[JF]YNfU[I0U[J011NfP00
001RnF;jH_T006<kIc]S>VLkHc]W>f<jIc]S>`80009WFP05JeYWFVMJIeY[FP03IeX30002Ie/01F=K
Ie]WFfMKHe/00fMK00=SF`00Hc/01V<k00<005/LGc`00e/L00=O?5/LFa`00P0000EK6e/LFaaK75/K
009K708001]oo`00?7oo00<007ooOol03goo00T004jkD]a>^e;LC[]Bg4jkD]`0100002Q>^e;L001B
g4jkD[a>^e;LC[]B_4jkD]a>^e:lC[]Bg4jk001>VU:kCY]B^djJD[]>Ve:kCYYB^djKD[]>VU:k001B
^djJD[]>VU:kCYYB^`@0000QCYY>^`00DY]>NTjJCWYBVdijCYY>NU:KCWY>VTijDY/005:JCWUBVTii
DYY>NE:JCWUBVTiiDYY>NE:JCWT004ii00<00009CWUBNTiiDYY>NE9jCWUBVTii00<0000TCUQBNDiH
DWU>F59iCUQBNDiHDWU>F59iCUP0059hEYUBN59iDWQFVE9hDWUBN5JIDWQBNE9hEYUBN000DWUFVU9i
EYUBNEJJ0P0003AFV5ZiEYUJ^EJHF[UFVEZiEYP005ZiG]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfP00H_YN
nF<JH_URnUki001S>VLkHcYW>f<jIc]S>P00IcY[FfLjJe]W>V]KIcY[FfLjJe]W>P00JcY[FP800008
He]WFf<kIeaSFfMKHc]WG080000?Hc]WFf<kHe]S>fMKHc]SFf<k001K6ellFa]O?5/K0080000:FaaK
6e/LF_]K75/KFaaJne/LFa/2000JOol003aoo`03001oogoo011oo`04001B^e:kC[/40003C]`01Djl
C]a>g4kL00000Tjk00E>_4jkC[]>^djl00=>^`05C[a>^djkC[/00003C[/01E:kC[]>^djkD[/00djk
00IB^djk001>VU:kCYX40006CY/00`00CYY>VP0<CYX00`00CYY>N@02CWX01TjJCWU>NTijCYY>N@9>
NP<00003CWUBNTii009>N@05DWY>NDiiCWUBNP0200000dii001>N@03DWT01DiiDWUBNE9iCWT00e9i
00A>NE9iDWT000mBN@04001BVEJIEYT2000035ZIEYUJVEJIFYUFVEZIEYUJVEJIFYT0009JfP06G]YJ
fE[JF]YNfU[I0U[J015NfP00H_YRnF;jH_URnV;iH_YRn@00Hc]W>f<jIc]S>`0000=WFP05JeYWFVMJ
IeY[FP03IeX00`00JeY[FP02JeX20002Ie/01F=KIe]WFfMK000036<k00<005/LGc`00P000U/L00EK
6e/LFaaK75/K00=K7003Fa]K75/L008001Uoo`00?7oo0P004Woo0`0002Q>^e;LC[]Bg4jkD]a>^e;L
C[]Bg4jkD]`005;LC[]B_4jkD]a>^e:lC[]Bg4jkD[a>^e;LC[/004jJD[]>Ve:kCYYB^djKD[]>VU:k
CY]B^`@0000SBYY>^djJC[]:VTjkCYY>^dZJC[]>VP00CWYBVdijCYY>NU:KCWY>VTijDY]>NTjJCWX0
04iiDYY>NE:JCWUBVTiiDYY>N@0300002TiiDYX005:JCWUBNTiiDYY>NE9j0`0002EBNDiIDWU>F@00
CUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUQBN@00DWUBN5JIDWQBNE9hEYUBN59iDWQFVE9hDWUBN5JI
001FV@0200005eJIF[UFV5ZiEYUJ^EJHF[UFVEZiEYQJ^EJIF[T005kJF[UNfUZiG]YJ^EkJF[T00P00
025RnUkiHaYRnF;jG_US6V;iH_YNn@00HcYW>f<j001W>V]KIcY[FfLjJe]W>V]KIcY[FfLj001[>V]J
IcY[FV/jJeX00P0001=SFfMKHc]WG000He]S>fMKHc]SFf<kIe]S>f=KHc]WFf<kHe]S>`0200003e/L
F_]K75/KFaaJne/LFa]K75[kFaaK6e/LF_]K7002000IOol003aoo`03001oogoo019oo`04001>g4kL
C[`3C]`01DjlC]a>g4kLC[`00dkL00@004jkC[]>_0=>^`05C[a>^djkC[]>_002C[/00`00D[]>^`02
C[/015:kC[]>^djk100000=>_4jk000034jK00<004jJCYX034jJ00@004ijCYY>N@9>NP<00003CWY>
VTii009>NP05001>NDiiCWUBNP0300000diiCUU>N@02CWT01DiICWT0059iCWT00e9i00E>NE9iDWUB
NDii00=BN@03CWUBN@0000mBN@0C001JVEJIFYUFVEZIEYUJVEJIFYUFVEZIEYUJVEJIFYUFV@00F]T0
0U[J01ENfU[IF]YJfP00H_URnV;iH_YRnF;jH_URnV;iH_YRnF;jH_T006<k00000fMJ00E[FVMJIeYW
FV]J00=WFP03001[FV]J00E[FP04001[FP00Ie/2000=Hc/200001F<k001K75/LFa/00e/L00EK6e/L
FaaK75/K00=K7004Fa/00000000HOol003]oo`03001oogoo01Aoo`0Q001>^e;LC[]Bg4jkD]a>^e;L
C[]Bg4jkD]a>^`00C[]Bg4jkD[a>^e;LC[]B_4jkD]a>^e:lC[]Bg000D[]>VU:k00@0000UB[]>_4Zk
C[a:^djl001>^djJC[]:VTjkCYY>^dZJC[]>VTjkBYY>^`00CYY>NU:KCWY>VTijDY]>NTjJCWYBVdij
CYY>NP00CWT00`0000]>NE:JCWUBVTiiDYY>NE:JCWT004ii0080000XDWU>FE9iCUUBNDiIDWU>FE9i
CUUBN@00DWU>F59iCUQBNDiHDWU>F59iCUQBNDiHDWU>F000DWQBNE9hEYUBN59iDWQFVE9hDWUBN5JI
DWP20000HEJI001J^EJHF[UFVEZiEYQJ^EJIF[UFV5ZiEYUJ^EJHF[UFV@00F[UNfUZiG]YJ^@00H_UR
nUkiHaYRnF;jG_US6V;iH_YNnF<JH_URnUki001W>V]KIcY[FfLjJe]W>V]KIcY[FfLj001[>V]JIcY[
FV/jJeYW>V]JJcX006Lj001S>f=KHc]WFf<kHe]S>fMKHc]SFf<kIe]S>f=K001S>f<KHc/005/LFa]K
75[kFaaK6e/LF_]K75/KFaaJne/L00800004E_]K7000000GOol003]oo`03001oo`0001Eoo`04001>
g4kLC[`3C]`01DjlC]a>g4kLC[`00TkL00D004jkC[]>^djl00=>^`06C[a>^djkC[]>_4jk100000a>
_4jkC[a>^djlC[]>_4jkC[a>^djl000=CY/00`00CYY>VP0;CYX200000dijCYY>N@02CWX01TjJCWU>
NTijCYY>N@<00005CUU>NDiiCWU>F@03CWT01TiICWU>NDiiCUT0009BN@05CWUBNE9iDWU>N@03DWT0
1TiiDWUBNE9iCWT000YBN@80000HEWQFNE9h001FVEZIEYUJVEJIFYUFVEZIEYUJVEJIFYUFVEZIEYUJ
VEJI001JfE[J0P0001ARnF;jH_URnV;iH_YRnF;jH_URnV;iH_YRnF;jH_T006LI001WFV]J0fMJ00E[
FVMJIeYWFP0000][FP03001[>@0000]S>`8000ES>`05001K75/LFaaK6`03Fa`00e/KFaaK70020003
Fa`00e[k0000000GOol003]oo`8001Moo`0G001>^e;LC[]Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C[]B
g4jkD[a>^e;LC[]B_0040000:4ZlC]d004jlB[]>_4ZkC[a:^djlB[]>_4ZkC[a:^djl001>^djJC[]:
VTjkCYY>^dZJC[]>VTjkBYX004ijCYY>NU:KCWY>VTijDY]>NTjJ0`0000U>VP00DYY>NE:JCWUBVTii
DYX0100002U:NDij001BNDiIDWU>FE9iCUUBNDiIDWU>FE9iCUUBNDiI001>F59iCUQBNDiHDWU>F59i
CUQBNDiHDWU>F59i001FVE9hDWUBN5JIDWQBNE9h00800014EYUBN5JIDWQFVE9h001FVEZiEYQJ^EJI
F[UFV5ZiEYUJ^EJHF[UFVEZiEYQJ^@00G]X006<JH_URnUkiHaYRnF;jG_US6V;iH_YNnF<JH_URnUki
001W6F/JIaT006LjJe]W>V]KIcY[FfLj001[>V]JIcY[FV/jJeYW>V]JJcY[FVLj001[>@80000KIe]S
>f=KHc]WFf<kHe]S>fMKHc/005lJHc]S6f<kGaYS>f<KHc/005/LFa]K75[kFaaK6e/L00800007F_]K
75KkFaaJne/LE_/00P005Woo000ROol40005Ool20005Ool40005Ool00`00Oomoo`0GOol01000C]a>
g4jl0dkL00E>_4kLC]a>g4jl009>g004001>^djkC[/400005DkLB]a>g4[LC]a:g4kL001>_4jkC[a>
^djlC[]>_4jkC[a>^djlC[/0000=CY/00`00CYY>VP04CYX30004CYX01000CWU>NTij100000=>NTii
CWX00Tij00E>N@00CWU>NDiI00=>N@05CUU>NDiiCWU>F@03CWT01@00DWUBNE9iCWT00e9i00E>NE9i
DWUBNDii00=BN@03001BNE9i00=BN@80000/DWQFNEIhEWUBN5IiEWQFN@00FYUFVEZIEYUJVEJIFYUF
VEZIEYUJVEJIFYUFVEZIEYUJV@00H_YRnF;jH_URnV;iH_YRnF;jH_URnV;iH_YRnF;jH_T000EW6@03
001WFV]J00=WFP03001[FV]J00U[FP06001[>F/j001[FP0026<k00<006<kHc/026<k00D005/LFaaK
75/K00800003FaaJne/L009K7007F_]K75/LFa`007oo00005Goo000QOol00`00Oomoo`02Ool00`00
Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2000IOol03@00C[]Bg4jkD]a>^e;L
C[]Bg4jkD]a>^e;L00@0000ZB[a>gDZlC]e:_4kMB[a>gDZlC]e:_000B[]>_4ZkC[a:^djlB[]>_4Zk
C[a:^djlB[/004ZJC[]>VTjkBYY>^djJC[]:VTjkCYY>^`00DY]>NTjJ0`0000I>VTijDY]>NTjJCWX5
0000;DYiCWY:NDijBWU>NTYiCWY:NDijBWT004iIDWU>FE9iCUUBNDiIDWU>FE9iCUUBNDiIDWT0059i
CUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUP0059hEYUBN00200006UJIDWQFVE9hEYUBN5JIDWQFVE9h
EYT005ZiEYUJ^EJHF[UFVEZiEYQJ^EJIF[UFV5ZiEYT20000=EkI001RnUkiHaYRnF;jG_US6V;iH_YN
nF<JH_URnUki001W6F/JIaU[>VLIJaYW6@00IcY[FfLj001[>V]JIcY[FV/jJeYW>V]JJcY[FVLj001[
>F]JIcU[FP00JeX006MKHc]SFf<kIe/00P0000iO6V<kHa]S>elJHc]S6f<kGaYS>f<K001Jne/L0P00
00aFne/LF_]K75KkFaaJne/LE_]K75[kFa`2000EOol0025oo`03001oogoo009oo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo01Uoo`04001>g4kLC[`3C]`00djl0000000200007T[mB]d004[L
C]a:g4kLB]a>g4[LC]a:g4kLB]a>g4[L001>^djlC[]>_4jkC[a>^djlC[]>_4jkC[`000e>V`<000E>
VP@00005BWY:VdZJ001>N@03CWX01DiiCWY>NTijCWT00dij00D004iiCWU>NDiI00=>N@05CUU>NDii
CWU>F@02CWT00`00CWUBN@02DWT01DiiDWUBNE9iCWT00e9i00=>NE9iDWT00`0001aFN5IiDWQFNEIh
EWUBN5IiEWQFNE9hEWUFN000EYUJVEJIFYUFVEZIEYUJVEJIFYUFVEZIEYT000AN^@0>001RnV;iH_YR
nF;jH_URnV;iH_YRnF;jH_T000UW6@03001WFP0000][FP0:001[>F/jJcY[FV/iJcX006]J0003Hc/0
0`00Hc]S>`0<Hc/20003Fa`01E[kFaaK75/LF_/00e/L00IJne/LFa`007oo000DOol0025oo`03001o
ogoo009oo`03001oogoo00eoo`05001oogooOol0000MOol00`00C[]Bg0040000;4[MC_e:gDkmB]e>
oD[M001:_4kMB[a>gDZlC]e:_4kMB[a>gDZlC]e:_000B[]>_4ZkC[a:^djlB[]>_4ZkC[a:^djl001>
^dZJC[]>VTjkBYY>^djJC[/400000dijDY]>NP040000<TjKBWY>VdYjCY]:NTjK001>NTYiCWY:NDij
BWU>NTYiCWY:NDijBWU>NP00DWU>FE9iCUUBNDiIDWU>FE9iCUUBNDiIDWU>F@00CUQBNDiHDWU>F59i
CUQBNDiHDWU>F59iCUP200006eJIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9h001FV5ZiEYUJ
^EJHF[UFVEZiEYQJ^@02000045ZhG]UJ^5kIF[P006;iH_YNnF<JH_URnUkiHaYRnF;j0P0001IW6F/J
IaU[>VLIJaYW6F/jIaU[6VLI001[>V]JIcY[FV/jJeYW>V]JJcY[FP80000;JcU[FVLiJeY[>F]JIcT0
06/i001S>`0200003F<kGaYS>f<KHc]O6V<kHa]S>elJHc]S6f<k0080000AGa/005KkFaaJne/LE_]K
75[kFaaFne/LF_]K75KkFaaJn`02000DOol0025oo`03001oogoo009oo`03001oogoo00Uoo`@000Ao
o`03001oogoo01aoo`80000XC_e:gD[mB]e>oD[MB_e:gDkmB]e:oD[M001:g4kLB]a>g4[LC]a:g4kL
B]a>g4[LC]a:g000C[]>_4jkC[a>^djlC[]>_4jkC[a>^djl0005CY/30002CY/500003dZJCY]:NTZK
BYY>VdYjBY]:VTjKBWY:V`00CWY>N@03CWX01DiiCWY>NTijCWT00Tij00<004iICWT00Tii00E>FDii
CWU>NDiI00=>N@05CUU>N@00DWU>N@03DWT01TiiDWUBNE9iCWUBN@80000MDUQBN@00EWUBN5IiEWQF
NE9hEWUFN5IiDWQFNEIhEWUBN5Ii001JVEJIFYUFVEZIEYUJVEJIFYT00008G[T02P00H_URnV;iH_YR
nF;jH_URnP0036LI00<006/i000026]J00<006]JJcT00V/j00U[FV/iJcY[>V]JJcT006/j00003F<k
0P0000IS>elKHa/005/LF_/3Fa`01E[kFaaK75/LF_/00e/L0P0000=Jo00000004goo000QOol00`00
Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`05Ool2000NOol0:`00B]e>oD[MC_e:gDkmB]e>oD[M
C_e:gDkmB]d004ZlC]e:_4kMB[a>gDZlC]e:_4kMB[a>gDZl001:^djlB[]>_4ZkC[a:^djlB[]>_4Zk
001>VTjk00P0000fAY]:_4ZK001:NTjKBWY>VdYjCY]:NTjKBWY>VdYjCY]:NP00BWU>NTYiCWY:NDij
BWU>NTYiCWY:NDijBWT004iIDWU>FE9iCUUBNDiIDWU>FE9iCUUBNDiIDWT0059iCUQBNDiHDWU>F59i
0`0007ABNDiHDWU>F000DWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYT005ZiEYQJ^EJIF[UF
V5Zi001NfEZhG]UJ^5kIF[QNfEZhG]UJ^000H_URnUkiHaYRnF;j001[>VLIJaYW6F/jIaU[6VLIJcYW
6F/JIaT006/HJcU[6000JcY[FVLjJeY[>V]J001[FV/iJeYW>F]JJcU[FVLiJeY[>F]JIcT006Li001O
6V<kHa]S>elJHc]S6f<kGaYS>f<K001O6V<kGa]S>elJHc/005/LE_]K75[kFaaFne/LF_]K75Kk0P00
00IK75KkFa`007oo000BOol0025oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Eoo`03
001oogoo01ioo`0V001:gDkmB]e:oD[MC_e:gD[mB]e>oD[MB_e:g@00B]a>g4[LC]a:g4kLB]a>g4[L
C]a:g4kL001>_4jkC[a>^djlC[]>_4jkC[a>^`H0000IB[a:W4ZlBY]:_4ZLB[a:VdZl001>VdYjBY]:
VTjKBWY:VdZJCY]:NTZKBYY>VdYj00000Tij00E>NDijCWY>NTii00=>NP05CWU>NP00CWU>F@03CWT0
1DiICWU>NDiiCUT00dii00I>F@00DWUBNDiiDWT300007U9iDUQBNE9HDWUBF59iDUP005IhEWUBN5Ii
EWQFNE9hEWUFN5IiDWQFNEIhEWUBN000EYUJVEJIFYUFV@8000aN^@06001RnF;jH_URnP0036LI00<0
06/iJcT00f/i00<006]JJeX00V]J00<006]JJcT00V/j00I[FV/iJcY[>V]JJcT2JcX01@00JcT006/i
000026<k0P0000=S6f<kGa/00V<K00IS>elKHa/005/LF_/3Fa`01E[kFa`00000F_/00U[l00=K75[k
F_`00P004Woo0005Ool3000JOol4000<Ool50003Ool00`00Oomoo`0OOol07`00B]e>oD[MC_e:gDkm
B]e>oD[MC_e:gDkmB]d004ZlC]e:_4kMB[a>gDZlC]e:_4kMB[a>g@00C[a:^djl00P0000kA[`004ZK
B[a6VdZlBY]:_4JKB[a:VdZlAY]:_000CY]:NTjKBWY>VdYjCY]:NTjKBWY>VdYjCY/004ijBWU>NTYi
CWY:NDijBWU>NTYiCWY:NDij001BNDiIDWU>FE9iCUUBNDiIDWU>FE9iCUUBNDiI001>F0020000MU9i
CUQBNDiHDWU>F59iCUQBNDiHDWT005JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9h001FVEZi
EYP005ZhG]UJ^5kIF[QNfEZhG]UJ^5kIF[QNfEZhG]T006<JH_URnP00JcYW6F/JIaU[>VLIJaYW6F/j
IaU[6VLI001[66/iJaQ_>F/HJcT006]JJcY[FP00JeY[>F]JIcU[FV/iJeYW>F]JJcU[FVLi001W>F/j
001[FVLi001O6V<kHa]S>elJHc/006<kGaYS>elKHc]O6V<kGa]S>elJHc/005/LE_]K75[k0P0000UK
75KkFaaFne/LE_]K75KkFa`00P004Goo0006Ool00`00Oomoo`0aOol2000QOol2000054kmB]e:oD[M
C_e:gD[mB]e>oD[MB_e:g@00B]a>g4[LC]a:g4kLB]`800000dKMA[d0000200008DJmA]e6_DKMA[d0
04ZLB[a:VdZlBYa:_4ZKB[a:W4ZlBY]:_000CY]:NTZKBYY>VdYjBY]:VTjKBWY:VdZJCY/00003CWX0
1DiiCWY>NTijCWT00dij00E>N@00CWU>NDiI00=>N@06CUU>NDiiCWU>FDii1000021BF59iDUQBNE9H
DWUBF59iDUQBNE9HDWUBF59i001FNEIhEWUBN5IiEWQFNE9hEWUFN5IiDWQFNEIhEWT005ZI0P0045ji
00<006;j000036LI00<006/iJcT01V/i00D006]J001[FV/i009[>P06JeY[>F/jJcY[FV/i0V/j00P0
06/iJcY[>F/j001[>P0016<k0P000V<K00IS>elKHa]S6f<kGa/2Ha/00f<kGa/00002Fa`200000e[l
FaaJn`02F_`02E/LF_]Jo5[lFaaJn`00Ool0000@Ool000Ioo`03001oogoo035oo`03001oogoo029o
o`0;001>oD[MC_e:gDkmB]e>oD[MC_e:g@0900001T;MA_i2gDKn@]e6oP@0000iA[a:gDJlB]e6_4[M
A[a:gDJl001:VdZlAY]:_4ZKB[a6VdZlBY]:_4JKB[`004jKBWY>VdYjCY]:NTjKBWY>VdYjCY]:NP00
BWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWT004iIDWU>FE9iCUUBNDiI00@0001WCWU>F@00CUQBNDiH
DWU>F59iCUQBNDiHDWU>F59iCUQBNDiH001BN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFV@00
G]UJ^5kIF[QNfEZhG]UJ^5kIF[QNfEZhG]UJ^5kIF[QNfEZhG]T006/jIaU[6VLIJcYW6F/JIaU[>VLI
JaYW6@00JaQ[>F/HKcU[66/iJaQ_>F/HJcT006]JJcU[FVLiJeY[>F]JIcU[FV/iJeYW>@00IcU[>VLi
JeYW>F/j001[FP00Hc/00P0000mO6f<kGaYS>elKHc]O6V<kGa]S>elJHc]O6f<kGaX00P0000iK75Kk
FaaFne/LE_]K75KkFaaFne/LE_]K75Kk0P0027oo1@000goo0006Ool4000_Ool00`00Oomoo`0TOol0
1000C_e:gD[m1P000d;n00<004;NA_h00TKn00E2gTKnA_i6oT;N00@0000XA]e6_DKMA[e6gDJmA]e6
_DKMA[e6gDJm001:W4ZlBY]:_4ZLB[a:VdZlBYa:_4ZK001:VTjKBWY:VdZJCY]:NTZKBYY>VdYjBY]:
VP00CWT3CWX01DiiCWY>NTijCWT00dij00@004iiCWU>N@@000=>F@0RCWU>FDiICUT0059HDWUBF59i
DUQBNE9HDWUBF59iDUQBNE9HDWUBF000DWQFNEIhEWUBN5IiEWQFNE9hEWUFN5IiDWP200000eZI001N
^@0@G[T00`00H_T0000:IaT00`00JcU[>@08JcT00`00KcT00002JcX01V]JJcU[>V/jJeY[>@9[>P0>
001[>F/jJcU[>V/iJcY[>F/j001[>P00Hc]O6`9S6`06Hc]O6f<KHa]S>elK0V<K00=S>elKHa/00P00
00EO6`00F_aK75[k009Jo006FaaJne[lF_aK75[k0U[l00AK7000Ool000Moo`05001oogooOol00003
Ool000Ioo`05001oogooOol0000^Ool2000VOol3000044<O@_i37d;n@am2oT<O@_i37d;n0012gDKn
@]e6oT;M0`0003M2gDKn@]e6oP00B]e6_4[MA[a:gDJlB]e6_4[MA[a:g@00B[a:VdZlAY]:_4ZKB[a6
VdZlBY]:_4JK001:NTjKBWY>VdYjCY]:NTjKBWY>VdYjCY/004ijBWU>NTYiCWY:NDijBWU>NTYiCWY:
N@0400009diiCUU>NDiICWU>FDiiCUU>NDiICWT0059iCUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUQB
N@00EYUBN5JIDWQFVE9hEYUBN5JIDWQFV@020000@eIhFYUFN000F[QNfEZhG]UJ^5kIF[QNfEZhG]UJ
^5kIF[QNfEZhG]T006KiH]QRn@00JcYW6F/JIaU[>VLIJaYW6F/j001[>F/HKcU[66/iJaQ_>F/HJcT0
06liJcQ_>@00JeY[>F]JIcU[FV/iJeYW>@00IcU[>VLiJeYW>F/jIcU[FVLi0080000RJcX006<kGaYS
>elKHc]O6V<kGa]S>elJHc]O6f<k001S>elJHa/005/LE_]K75KkFaaFne/LE_]K75KkFaaFne/LE_/4
0007Ool00`00Oomoo`04Ool000Ioo`05001oogooOol0000^Ool00`00Oomoo`0VOol00`00@am2oP02
@_h01D<O@_i2oT;n@al00d;n00<004;N00000P0000E2gTKnA_i6oT;N00=6oP0Y0016gDJmA]e6_DKM
A[e6gDJmA]e6_DKM001:_4ZLB[a:VdZlBYa:_4ZKB[a:W4ZlBY/004ZJCY]:NTZKBYY>VdYjBY]:VTjK
BWY:V`00CWY>N@03CWX00diiCWX000030002BWX01000CUU>FDii0diI00E>NDiICUU>FDii009>F@0R
001BNE9HDWUBF59iDUQBNE9HDWUBF59iDUQBNE9HDWT005IiDWQFNEIhEWUBN5IiEWQFN@00FYQFV5ZI
EYQJV5JH000>G[T01P00H_URf6;IH]P000QW6@03001[>F/i00Q[>@06001[>6lhKcQ_>@000V/j00m[
FV/iJcY[>P00JcU[>V/iJcY[>F/jJcU[>V/iJcX00P0000EW>F/i001S>elK009S6`06Hc]O6f<KHa]S
>elK0P0000IS6elKGa]O6f<K0002F_`01U/LF_]Jo5[lFaaJn`9Jo005Fa`00000F_aK70020008Ool0
0`00Oomoo`03Ool000Ioo`05001oogooOol0000^Ool00`00Oomoo`0WOol200002D;n@am2oT<O@_i3
7d;n@am2oP040000=4Kn@]e6oT;MA_i2gDKn@]e6oT;M0016_4[MA[a:gDJlB]e6_4[MA[a:gDJlB]d0
04ZlBY]:_4JKB[a:VdZlAY]:_4ZKB[a6V`00BWY>VdYjCY]:NTjKBWY>VdYjCY]:NP00BWU>NTYi1000
02a:NTYJBWY:FTYjBUX004iICWU>FDiiCUU>NDiICWU>FDiiCUU>NDiI001>F59iCUQBNDiHDWU>F59i
CUQBNDiHDWU>F59iCUP0059hEYUBN5JIDWQFVE9h0P0006IJVEIhFYUFN5ZIEWQJV@00G]UJ^5kIF[QN
fEZhG]UJ^5kIF[QNfEZhG]T006KiH]QRnF;HI_URf000IaU[>VLIJaYW6F/j001[>F/HKcU[66/iJaQ_
>F/HJcU[6000JcQ_>F/HKcU[>000IcU[FV/iJeYW>@00IcU[>VLiJeYW>F/jIcU[FVLiJcX006/jIaT0
06LIJcX006<kGaYS>elKHc]O6V<kGa/005lJHc]O6V<KGaYS>elJHa/005/LE_]K75KkFaaFne/LE_/2
00001e/LE_]K75Kk001oo`0000Qoo`03001oogoo009oo`001Goo1@00;goo0P00:Woo00D004;n@_i2
oT<O0092oP8000=2oP03@al004Kn0096oP05@]i6oTKnA_i2gP02A_h08@00A[e6gDJmA]e6_DKMA[e6
gDJmA]e6_DKM001:_4ZLB[a:VdZlBYa:_4ZKB[a:W4Zl001:VdZJCY]:NTZKBYY>V`08000;BWX01@00
CUU>FDiICWT00diI02Q>NDiICUU>FDiiCUT0059HDWUBF59iDUQBNE9HDWUBF59iDUQBNE9HDWUBF000
EWQFNE9hEWUFN000EYQJV5JHFYUFV5ZHEYQJVEJHFYP000]N^@0:001RnF;HH]URf6;iH]QRfF;H0004
IaT00`00JcU[>@08JcT01P00JcQ_>6lhKcU[>09_>00J001[>F/jJcX006/iJcY[>F/jJcU[>V/iJcY[
>F/j001[>VLiJcUW>@00IcT006<KHc]O6`9S6`05Hc/00000Ga]S6`03Ga/01V<KGa]O6elKHa/0009J
o003FaaJn`0000800005E_]Jo5[lFaaFn`02F_`00`00Ool00008Ool00`00Oomoo`01Ool003Uoo`03
001oogoo02Yoo`030012oT<O00<0000J@am2oT<O@_i37d;n@al004Kn@]e6oT;MA_i2gDKn@]e6oT;M
0016_4[MA[a:gDJlB]e6_1P0000eAYa2NdJLAW]6W49k001:FTYjBUY:NTYJBWY:FTYjBUY:NTYJBWX0
04iiCUU>NDiICWU>FDiiCUU>NDiICWU>FDii001BNDiHDWU>F59iCUQBNDiHDWU>F59iCUQBNDiHDWT0
05JIDWQFV@0200005EIhFYUFN5ZIEWQJVEIhFYUFN5ZIEWQJV@00G]UJ^5kIF[QNfEZhG]UJ^0020000
CFKiH]QRnF;HI_URf6;iH]QVnF;H001W6F/j001[>F/HKcU[66/iJaQ_>F/HJcU[6000JcQ_>F/HKcU[
>6liJaQ_>F/h001W>@00IcU[>VLiJeYW>F/jIcU[FVLiJcX006/jIaU[>VLIJcX006/jIaT005lKHc]O
6V<k001S6elJHc]O6V<KGaYS>elJHa]O6V<kGaX005KkFa`00P0000]Fne/LE_]K75KkFaaFne/LE_]K
75Kk008000Aoo`05001oogooOol00003Ool001Moo`@000Eoo`8000Moo`03001oogoo00=oo`@000Io
o`03001oogoo02Yoo`<00092oP04@am2oT;n@_hG00001cKN>]hfgS[N=]hjgP0000<n_@05?Ydn_Cjm
?[dnW@03?[d03@00AYa6VdJLAW]6W4JKAYa6NdJLAY]6W00000e:NP03001>NDiI009>F@05CWU>FDiI
CUU>N@03CUT04Dii001BNE9HDWUBF59iDUQBNE9HDWUBF59iDUQBNE9HDWT00`0000mJVEJHFYQFV5ZI
EYQJV5JHFYUFV5ZHEYQJVEJH00001eji010006;HH_URf6;IH]QRnF;HH]URf6;iH]QRf@00IaT000Y[
>@06001[>6lhKcQ_>F/h0Vlh01a_>F/hKcQ_>000JcU[>V/iJcY[>F/jJcU[>V/iJcX006/jIcU[>FLi
JcYW>F/i001[>VLi001S6`80009O6`05Ha]O6elKGa]S6`03Ga/016<KGa]O6elK0P000U[l00IK75Kk
F_aJo5/LE_/2F_`015/LE_]Jo5[l0P0017oo0`0017oo000FOol00`00Oomoo`02Ool00`00Oomoo`02
Ool20007Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0XOol30003
Ool600001S;n=_lboSLO<_hfo`80001H<]hfoc;N=_lbgSKo<]hfoc;N000f_S[O=[hjgcJn>]lf_S[O
=[hjgcJn>]l004:n?Ye2_CjM@[hnWD:m?Ye2_SjM0012NdJLAW]6W49kAYa6NdJL@W]6W4IkAY`004Yj
BUY:NTYJBWY:FTYjBUY:NTYJBWY:FP00CUU>NDiICWU>FDiiCUU>NDiICWU>FDiiCUT004iHDWU>F59i
CUQBNDiHDWU>F59iCUQBNDiHDWT20000I5IhFYUFN5ZIEWQJVEIhFYUFN5ZIEWQJVEIhFYUFN5ZIEWP0
05ZhG]UJ^5kIF[P006;HI_URf6;iH]QVnF;HH_URf6KiH]QRnF;HI_T006/iJaQ_>F/HJcU[66liJaQ[
>F/HKcT006liJaQ_>F/hKcU[66liJcQ_>F/H001[6000IcU[FVLiJcYW>F]JIcU[>P00JcYW6F/jIaU[
>VLIJcYW6F/j001[>VLI001O6V<KGaYS>elJHa]O6V<kGaYS6elJHc]O6V<K0P00011O6P00E_]K75Kk
FaaFne/LE_]K75KkFaaFne/LE_]K708000]oo`005Woo00<007ooOol00Woo00<007ooOol02goo00<0
07ooOol01goo00<007ooOol00Woo0P009Woo0`001goo0P000SKo00DbocKo=_lfoc;o00<fo`0;<_l0
03;O=_lbgS;o<]lfoc;N<_lbg`02000033[N=]hjgSKN>]hfgS[N=]hjgSKN>]h000<n_@05?Ydn_Cjm
?[dnW@02?[d03@00AW]6W4JKAYa6NdJLAY]6W4IkAYa6V`0000e:NP03001>FDii00=>F@05CWU>FDiI
CUU>N@03CUT03000DUQBNE9HDWUBF59iDUQBNE9HDWUBF080000DDWUBN000EYQJV5JHFYUFV5ZHEYQJ
VEJHFYQFV5ZIEYQJV5JHFYT000AN^@0B001Rf6;iH]QRfF;HH_URf6;IH]QRnF;HH]URf6;i001Vn000
2F/i00D006lhKcQ_>F/h009_>005KcU[>6lhKcP00003KcP06@00JcU[>V/iJcY[>F/j001[>VLiJcUW
>F/jIcU[>FLiJcYW>@00IcT006LI001O6f<K00=O6`05Ha]O6elKGa]S6`02Ga/01`00Ha]O6elK001K
75Kk009Jo006FaaFne[lF_aK75Kk0U[l00AK75Kk000000]oo`005Woo00<007ooOol00Woo00<007oo
Ool037oo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol08Woo0`0037oo0P0000Xfoc;n=alb
oSKo<_hg7c;n=_lboP80001A=_lbgSKo<]hfoc;N=_lbgSKo000jgcJn>]lf_S[O=[hjgcJn>]lf_S[O
0012_SjM@[dnWD:n?Ye2_CjM@[hnW@00@W]6W4IkAYa2NdJLAW]6W49kAYa6N`00BUY:NTYJBWY:FTYj
BUY:NTYJBWY:FTYj001>NDiICWU>FDiiCUU>NDiICWU>FDiiCUU>N@00DWU>F59iCUQBNDiHDWU>F59i
0080001UDUQBNE9HEWT005ZIEWQJVEIhFYUFN5ZIEWQJVEIhFYUFN5ZIEWQJVEIhFYT005kIF[P006;H
I_URf6;iH]QVnF;HH_URf6KiH]QRnF;HI_T006/HI_Q[6@00JcU[66liJaQ[>F/HKcT006liJaQ_>F/h
KcU[66liJcQ_>F/HKcT006lhJaQ_>6/H001W>F]JIcU[>P00JcYW6F/jIaU[>VLIJcYW6F/jIaU[>VLI
001W6F/j001S>elJHa]O6V<kGaYS6elJHc]O6P0200004F<KGaYS6elJHa/005/LE_]K75KkFaaFne/L
E_]K75KkFa`00P0000=oo`00Ool02Woo000FOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomo
o`02Ool40005Ool00`00Oomoo`0OOol3000AOol200001C;o=_lfocKo<_l00cKo01TbocKo000003;N
<_lbgcKo<]hboc;O=_l003[N=]hjgSKN>]hfgS[N=]hjgSKN000nW@03?[d01CjM?[dn_Cjm?Yd00Sjm
00d004IkAYa6VdJLAW]6W4JKAYa6NdJLAY/0000<BWX01000CUU>FDii0diI00E>NDiICUU>FDii009>
F@07001BNE9HDWUBF59iDUP00P0002YBNE9hDWUBN59iDWQBN@00FYUFV5ZHEYQJVEJHFYQFV5ZIEYQJ
V5JHFYUFV5ZHEYP005ji001Rf6;iH]QRfF;HH_URf6;IH]QRnF;HH]URf6;i0002I_P016[hI_QVn000
1F/i00D006lhKcQ_>F/h009_>006KcU[>6lhKcQ_>@001Flh01L006/jJcU[>P00JcYW>F/iIcU[>VLi
JcUW>F/jIcU[>FLi001W6@00IcU[>P00009O6`09Ha]O6elKGa]S6elK001O6f<K00=O6`06Ha]O6elK
001K75Kk0U[l00AK75KkF_aJo08000Aoo`03001oogoo00Qoo`005Woo00<007ooOol00Woo00<007oo
Ool03Goo00D007ooOomoo`0000Qoo`8001ioo`8001Iooa800003=_lbgSKo00800010=[hjgcJn>]lf
_S[O=[hjgcJn000nWD:n?Ye2_CjM@[hnWD:m?Ye2_P00AYa2NdJLAW]6W49kAYa6NdJL@W]6W000BWY:
FTYjBUY:NTYJBWY:FTYjBUY:NTYJ001>FDiiCUU>NDiICWU>FDiiCUU>NDiICWU>F@00CUQBNDiHDWT2
0000IU9HEWUBF59iDUQFNE9HDWUBF000EWQJVEIhFYUFN5ZIEWQJVEIhFYUFN5ZIEWQJVEIhFYUFN000
H]QVnF;HH_URf6KiH]QRnF;HI_URf6;iH]QVn@00JaQVn6/II_Q[66Kh001[66/iJaQ_>@00KcU[66li
JcQ_>F/HKcU[>6liJaQ_>@00KcQ[66lhJaQ_>6/HKcP006/j001[>VLIJcYW6F/jIaU[>VLIJcYW6F/j
IaT006LIJcYW6@00IaU[>P00Hc]O6V<KGaYS>`80000?GaYS6elJHa]O6V<KGaYS6elJHa/005/LE_]K
75Kk00<000Ioo`03001oogoo00Qoo`005Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol0
0Woo00D007ooOomoo`0000Qoo`03001oogoo01Yoo`<001Yoo`800003;]lbobkN008^g`04<_l^gRkO
;]l200038[h;00001S[N=]hjgSKN000nW@<n_@0C?Ydn_Cjm?[dnWCjm0016W4IkAYa6VdJLAW]6W4JK
AYa6NdJL000034Yj00D004iICUU>FDii00=>F@08CWU>FDiICUU>NDiI001BF080000/DWUBN59iDWQB
NE9hDWUBN59iDWQBNE9h001FV5ZIEYQJV5JHFYUFV5ZHEYQJVEJHFYQFV5ZIEYP005jh001Rf6;IH]QR
nF;HH]URf6;iH]QRfF;HH_T0009Vn007J_QVn6KhI_QZn6Kh00000f/i00@006lhKcU[>09_>006KcU[
>6lhKcQ_>@002Flh01L006/jIcU[>FLiJcYW>F/iIcU[>VLiJcUW>@00IaU[>FLiJcX006/iIcU[>P00
009O6`05Ha/005lKGa]S6`03Ga/02F<KGa]O6elKHa]O6`00F_aK70020009Ool00`00Oomoo`08Ool0
01Moo`@000]oo`H000=oo`D000=oo`03001oogoo01Qoo`<001moo`800009<_l^gS;o;]hbobkN<_l^
gS;o008000078YhR_QjN8[hRWR:n7Yh00P0000<NWQYm7Yh0200002/nWD:m?Ye2_SjM@[dnWD:n0016
W49kAYa6NdJL@W]6W4IkAYa2N`00BUY:NTYJBWY:FTYjBUY:NTYJBWY:FTYj001>NDiICWU>FDiiCUU>
NDiICWU>F@050000759HDWUBF5IiDUQBNE9HEWUBF59iDUQFNE9HDWT005ZIEWQJVEIhFYUFN5ZIEWQJ
VEIhFYUFN5ZI0P0003aJV5ji001RnF;HI_URf6;iH]QVnF;HH_URf6Ki001[66KhJaUVn6/HI_Q[6FKh
JaQVn000JaP006/HKcU[>6liJaQ_>F/hKcU[66li001_>6/HKcQ[66lhJaQ_>6/HKcP006lh001[>VLI
JcYW6F/jIaU[>VLIJcX200002fLIJcYW6F/jIaU[>P00JcYW6@00GaX00P0000iS6elJHa]O6V<KGaYS
6elJHa]O6V<KGaYS6elJ0P002goo00<007ooOol027oo000gOol2000FOol3000TOol200001BkN;]l^
gc;o;]h00RkO00@bobkN000000LR_P0;000NWQYn7YhNOQjN6WhNWQin000VOP0600003cjm?Yd004JK
AYa6NdJLAY]6W4IkAYa6VdJLAW/0000<BWX01000CWU>FDiI1P00025:FDiICUU>N@00DWUBN59iDWQB
NE9hDWUBN59iDWQBNE9hDWUBN59i001JV5JHFYUFV5ZHEYQJVEJHFYQFV5ZI00000ejh00eJ^5jh001R
nF;HH]URf6;iH]QRfF;HH_T00002I_P01F[hI_QVn6KhJ_P00fKh00IZn6Kh001_>6liJcP2KcP01fli
JcQ_>6lhKcU[>00000U_>00I001_66lh001[>VLiJcUW>F/jIcU[>@00JcYW6F/iIcU[>VLIJcUW>F/j
001[>FLi00000elK00ES6elKGa]O6f<K00=O6`03Ha]O6elK008000eoo`03001oogoo00Qoo`00=goo
00<007ooOol04Woo0`00:Goo3`0000@RWR:n7YhR_P80000>6WdNWQYm7YhJOAjN6Wd002Im:YhVOBJN
9WdZWPT0000=AYa2NdJLAW]6W000BWY:FTYjBUY:NTYJBWX02@0006m>NTYICWY:FDijBUU>NTYICWY:
F@00DUQFNE9HDWUBF5IiDUQBNE9HEWUBF59iDUQFNE9H001FN5ZIEWQJVEIhFYUFN5ZIEWQJV@00G[UJ
V5jiFYQN^EZH001Rf6;iH]QVnF;HH_URf6KiH]P006KhJaUVn6/HI_Q[6FKhJaQVn6/II_P006[g001[
>6liJaQ_>F/hKcU[66liJcP006/HKcQ[66lhJaQ_>6/HKcQ[6000KaQ_>6/GKcP006/jIaU[>VLIJcX0
06/jIaU[>VLIJcYW6F/jIaU[>VLIJcX00P0000eW6@00GaYS6elJHa]O6V<KGaYS6elJHa]O6P02000?
Ool00`00Oomoo`08Ool003Moo`03001oogoo00moo`<002ioo`800009=]hfgcKN=]lfgSKO=]hfgcKN
00X000077YhNOQjN6WhNWQin00002BIn00<003Im=Wd00SIm3@0000Y6Nd9KAW]2FdIk@U/004iICWU:
F@9>F@06CWU:FDiICUU>NDYI0TiI01P0059hDWUBN59iDWQBNE9hDWUBN59iDWQBNE9hDWUBN000EYQJ
V5JHFYUFV5ZHEYP20003G[P045ZhG[QN^5jhF[P006;HH_URf6;IH]QRnF;H001Vn6[h0fKh00MZn6Kh
I_QVn6[hI_P00002JaP01F/G001_>6liJcP00Vlh00=_>F/h00002Flh00<006lHKcP00Vlh01Q_66lh
001[>VLiJcT006/jIaU[>FLiJcYW6F/iIcU[>VLIJcUW>@00IaUW>FLI0003Ga/01f<KGa]O6elKHa]O
6`00015oo`03001oogoo00Qoo`00=goo00<007ooOol037oo0`00<goo014003KN=]lfgS[o=]hfgcKN
>_lfgSKO000NWQim7YhNOAjN00@000056WdNWQYm7YhJO@020000WBZN9WdVWRIm:YhVOBJN9Wd003Il
>WdfO3Ym=W`jOCIl>WdfO3Ym0016Nd9JAW]2FTIk@UY6Nd9JAW]2FTIk001>NTYICWY:FDijBUU>NTYI
CWY:FDijBUU>NP00DWUBF5IiDUQBNE9HEWUBF59iDUQFNE9HDWUBF5Ii001JVEIhFYUFN5ZIEWP005ZH
G[UJV5jiFYQN^EZHG[UJV5jiFYP006;HH_URf6KiH]P006KhJaUVn6/HI_Q[6FKhJaQVn6/II_Q[6000
KaQZmflHJ_L006/hKcU[66liJcP006/HKcQ[66lhJaQ_>6/HKcQ[66lh001_>6/GKcQ_66lhJaM_>000
JcX006/jIaU[>VLIJcYW6F/jIaU[>VLIJcYW6@00IaT006LIJcYW6@00GaYS6elJHa]O6V<K0080019o
o`03001oogoo00Qoo`00=goo0P002Woo0`00=goo00`003KN=]lfgSKO=]hfgcKN=]lfgSKO00077Yh5
000011jN7WhNWP001bIn00<003Im=Wd023Im00h0049KAW]2FdIk@U]6Nd9KAW]2FdIk@U]6N`000TiI
00I>NDYICUU>FDiiBUT2CUT06TiiBUU>F@00DWUBN59iDWQBNE9hDWUBN59iDWQBNE9hDWUBN59i001J
VEJHFYQFV000F[P3G[P01EZhG[QN^5jhF[P00ejh00P006;IH]QRnF;H001Vn6[h0fKh00EZn6KhI_QV
n6[h009Vn003001[66/G00=[6006001_>6lhKcU[>0002Vlh00D006lhKcQ_>6lH00=_>00HKaQ_>000
JcYW6F/iIcU[>VLIJcUW>F/jIaU[>FLi001W6FLiIaT006LIIcT006<K0elK0P005Goo00<007ooOol0
1goo000gOol00`00Oomoo`07Ool2000kOol200002CKO=]hjocKN=]lfgS[o=]hfg`0200001aim7YhN
OAjN7WdNWQim008000031Q`0000000<0000o:YhVOBJN9WdZWRIm9Yh003Ym=W`jOCIl>WdfO3Ym=W`j
OCIl0012FTIk@UY6Nd9JAW]2FTIk@UY6Nd9J001:FDijBUU>NTYICWY:FDijBUU>NTYICWY:F@00DUQB
NE9HEWUBF59iDUQFNE9HDWUBF5IiDUQBNE9H001FN5ZI0080001FFYQN^EZHG[UJV5jiFYQN^EZHG[UJ
V5jiFYQN^@00I_URf000I_Q[6FKhJaQVn6/II_Q[66KhJaUVn6/H001_66[gKaQZmflHJ_M_6000KcU[
>6li001_>6/HKcQ[66lhJaQ_>6/HKcP006lhJaM_>6lHKcQ[5flhKaQ_>000KcP006/jIaU[>VLIJcYW
6F/jIaU[>VLI001W6F/jIaU[>P00JcYW6F/j001S6`8001Moo`03001oogoo00Moo`00=Woo00<007oo
Ool01Goo0`00?goo4@000ajN0P0000<66`HL1Q`00`001RIn00<003Im=Wd023Im00h0049KAW]2FdIk
@U]6Nd9KAW]2FdIk@U/004YI0TiI00I>NDYICUU>FDiiBUT2CUT04TiiBUT0059hDWUBN59iDWQBNE9h
DWUBN59iDWQBNE9hDWUBN0800003G[QJ^5jh009N^005F[QN^5jhG[QJ^003G[P025ZhG[QN^000H]P0
06KhJ_P3I_P01F[hI_QVn6KhJ_P00VKh00<006/HJaL00f/H00M[5f/HJaQ[6000KcP00009KcP01@00
KcQ_>6lhKaP00flh00i_66lh001_>6lH001W>F/jIaU[>FLiJcYW6F/i0P0000]W6FLiIaU[>FLIIcT0
06/iIaUW>@0001Uoo`03001oogoo00Moo`00=Woo00<007oo00000Woo0`00@goo00/004;N?]i2oSkN
@]hngT;n?]i2gSkN008000039YhVORJN00L000031S`66`HL00@0000g9WdZWRIm9Yh003Ym=W`jOCIl
>WdfO3Ym=W`jO@00AW]2FTIk@UY6Nd9JAW]2FTIk@UY6N`00CWY:FDijBUU>NTYICWY:FDijBUU>NTYI
CWX005IiDUQBNE9HEWUBF59iDUQFNE9HDWUBF5IiDUP00P0005QN^EZHG[UJV5jiFYQN^EZHG[UJV5ji
FYQN^EZHG[UJV5jiFYP006KhJaUVn6/HI_Q[6FKhJaQVn6/II_Q[66Kh001ZmflHJ_M_66[gKaQZmflH
J_M_6000KcQ[66lhJaQ_>6/HKcQ[66lhJaP006/GKcQ_66lhJaM_>6lHKcQ[5`00KaM_>6/G001W6F/j
IaU[>VLIJcX006/jIaU[>VLIJcYW6F/jIaU[>P00JcX001Yoo`03001oogoo00Moo`00=Woo1@00Agoo
00<003kN?]h02CkN00<002JN9Yh01RJN100000@670HK0005n`80008VOP03000fOCIm00PfO@0?0016
Nd9KAW]2FdIk@U]6Nd9KAW]2FdIk001>NDYI009>F@06CWU:FDiICUU>NDYI0TiI00e>N@00DWUBN59i
DWQBNE9hDWUBN59iDWQBN@0200000eIiEYT00003G[P01EZhG[QN^5jhF[P00ejh00QJ^5jhG[QN^5Zh
001Rf0000fKh00EZn6KhI_QVn6[h00=Vn003001[5f/H009[6009JaM[66/HJaQ[5f/H001_600000Q_
>004001_>6lhKaP3KcP01FlHKcQ_>000KaP00flh01=_6000IcU[>VLIJcT006/iIaUW>FLIJcUW6FLi
IaU[>FLIIcT0000KOol00`00Oomoo`07Ool002eoo`D000Aoo`8004]oo`80000=?]i2oSkN@]hngT;n
?]i2gSkN@_h002JN9Wh00bJN00HVORJN9YhVWP001O/2000010HK0005f`Gl100002dfO3Ym=W`jOCIl
>WdfO3Ym=W`0049JAW]2FTIk@UY6Nd9JAW]2FTIk@UX004YICWY:FDijBUU>NTYICWY:FDijBUU>NTYI
001BF5IiDUQBNE9HEWUBF59iDUP00P0005UFVE9hEYUBN000FYQN^EZHG[UJV5jiFYQN^EZHG[UJV5ji
FYQN^EZH001N^6;IH[P006KhJaUVn6/HI_Q[6FKhJaQVn000J_M_66[gKaQZmflHJ_M_66[gKaQZm`00
KaM_6000KcQ[66lhJaQ_>6/H001[5flhKaQ_>6/GKcQ_66lhJaL006lGKcQ[5flhKaM_>6/G001W6F/j
001[>VLIJcYW6F/jIaU[>VLIJcYW6F/j008001]oo`03001oogoo00Moo`00;goo00<007ooOol01Goo
00<007ooOol0Bgoo00<003kN?]h023kN0P0022JN00<000Gk0M/0100000<5n`GK1O/00`0023Im0100
049KAW]2FdIk@U]6Nd9KAW]2FdIk@U/004iICWU:F@9>F@06CWU:FDiICUU>NDYI0TiI00L0059hDWUB
N59iDWQBN@0200002EIhEYUFNEJIEWQFVEIi001J^003G[P01EZhG[QN^5jhF[P00ejh00=J^000H]P0
0f;H00<006[hI_P00VKh00IZn6KhI_QVn000JaL3JaP01F/GJaQ[66/HJaL00V/H00H006lGKaM_5flH
0005KcP00`00KcQ_6003KcP01FlHKcQ_>000KaP00flh01=_66lhKcQ_>000JcT006/iIaUW>FLIJcUW
6FLiIaU[>FLIIcT00002Ool00`00Oomoo`0HOol00`00Oomoo`07Ool002moo`03001oogoo00Ioo`80
04aoo`07000ngT;n?]i2gSkN@_h02`000bJN0P0000<1f`Gk0MX00P0000@5o0GK1O`5f`D0000S=W`j
OCIl>WdfO000@UY6Nd9JAW]2FTIk@UY6Nd9JAW/004ijBUU>NTYICWY:FDijBUU>NTYICWY:FDij001B
NE9HEWUBF0020000G5JIDWQFVE9hEYUBN5JIDWQFV@00G[UJV5jiFYQN^EZHG[UJV5jiFYQN^EZH001N
^6;IH[QRf5jhH]T006/HI_Q[6FKhJaQVn6/I001_66[gKaQZmflHJ_M_66[gKaQZm`00KaM_66/GKaQ_
5`00JaQ_>6/HKcP006lhKaQ_>6/GKcQ_66lhJaM_>000KcQ[5flhKaM_>6/GKcQ_5flh001[>VLIJcYW
6F/jIaU[>VLIJcYW6F/j0004Ool00`00Oomoo`0GOol00`00Oomoo`07Ool002moo`03001oogoo00Qo
o`03001oogoo04Yoo`H00007A]i6gDKN@]e6gTKM000012jN1`0000<5n`7K1O/00P0000D5f`Gk1O/0
01XL008J7@@0000>=Wd004Ik@U]6Nd9KAW]2FdIk@U]6Nd9KAW/0009>F@06CWU:FDiICUU>NDYI0TiI
00E>NDYICUT0059i0080000?EWUFVEIhEYUFNEJIEWQFVEIiEYUFN5JI001N^5Zh00=N^006F[QN^5jh
G[QJ^00026;H00<006[hI_P00VKh00=Zn000JaP00V/H00E[5f/HJaQ[66/G009[6005001_5flGKaM_
6003KaL01P00KcQ_>000KcQ_60=_>005KaQ_>6lhKcP00003KcP04flHKcQ_>6lhKaQ_>000KcP006Li
IaU[>FLIIcUW6F/iIaUW>@0000Ioo`03001oogoo01Moo`03001oogoo00Ioo`00;goo00<007ooOol0
2Goo00<007ooOol0BWoo01H004;MA_i2gDKN@]e6oT;MA]i2gDKn@]d002jN<[h^WRjn;Yhb_RjN;[h^
WP@0000=1O/1f`000005o0GK000J71hm6Q`J?AXL7Sd01@0001=6Nd9JAW]2FTIk@UY6Nd9J001:FDij
BUU>NTYICWY:FDijBUU>NP050000GUJIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFV@00G[UJV5ji
FYQN^EZHG[UJV000G[QRfF:hH]QN^6;IH[QRf5jhH]T006/HI_Q[6@00KaQZmflHJ_M_66[gKaQZmflH
J_M_6000KaQ[5flHKaM_66/GKaQ_5`00JaP006lHKcQ[5flhKaQ_>6/GKcP006lhJaM_>6lGKcQ[5flh
KaM_>6/G001_5`00IaU[>VLIJcYW6F/jIaU[>P001goo00<007ooOol05goo00<007ooOol01Woo000_
Ool00`00Oomoo`0:Ool00`00Oomoo`1:Ool03000@]e6gTKMA]i2gDKNA]e6gT;MA]i6g@8000T^WP05
0005n`000001f`0300000`Gk000J70026Qd01aXm6Q`J7AXM6Sd003IL00H00005@U]6Nd9K001:F@02
CUT60003BWX04TYJ001FNEJIEWQFVEIiEYUFN5JIEWUFVEIhEYUFNEJIEWP0009N^006F[QN^5jhG[QJ
^0002f;H00@006KhJ_P000=[6005JaM[66/HJaQ[5`03JaP01000KaM_5flH0flG00I_66lGKaM_5`00
KaP3KcP01FlHKcQ_>6lh00000flh00E_66lhKcQ_>6lH009_>00<001_66lhKaP006LIIcUW6F/iIaUW
>@002Goo00<007ooOol05Woo00<007ooOol01Woo000]Ool3000=Ool2001;Ool2000064Kn@]e6gT;M
A_i2gDKN@]e6oT;MA]h003:n;Yh^_RjN<[h^WRjn;Yhb_P001O`5f`L0000?6Q`N?AXL6SdJ71hm6Q`0
03Hk>U`fFcYL=S/jG3IK00L0001WBUY:NTYIBWY:FTYjBUU:NTYJBWX005JIDWQFVE9hEYUBN5JIDWQF
VE9hEYUBN5JIDWQFVE9h001JV5jiFYQN^EZH001N^6;IH[QRf5jhH]UR^6;HG[QRfF:hH]QN^000I_P0
06[gKaQZmflHJ_M_66[gKaQZmflH001_66/GKaQ_5flHJaM_66lGKaQ[5`00KaL006/GKcQ_66lhJaM_
>6lH001[5flhKaM_>6/GKcQ_5flhJaL006lGKcQ[5flhKaL006LIJcYW6F/j00002goo00<007ooOol0
5Goo00<007ooOol01Woo000_Ool00`00Oomoo`0=Ool00`00Oomoo`1:Ool03@00A]i6gDKN@]e6gTKM
A]i2gDKNA]e6gP0000T^WP8000<5f`8000040EP000006Q`26Qd01AXm6Q`J7AXM00000cIL00DjG3IL
=U`fG3YL008fG003001:NTYJ00=:NP05BUY:NTYjBWY:FP03BWX04@00EYUFNEJIEWQFVEIiEYUFN5JI
EWUFVEIhEYUFNEJI00000ejh00=J^000H]P03V;H00@006/HJaQ[5`=[6008JaM[66/HJaQ[5`00KaM_
60=_5`06KaQ_5flGKaM_60000VlG00<006lHKcP00Vlh00E_6000KcQ_>6lH00=_>00?KaQ_>6lhKcP0
06lhKaQ_>6lHKcQ_6000IaUW>@0000eoo`03001oogoo01Aoo`03001oogoo00Ioo`00@7oo00<007oo
Ool0BWoo00L004Kn@]e6gT;MA_i2g@0B00000`Gl1M/5o0020000G@4g000J71hm6Q`J?AXL7SdJ7000
=S/jG3IK>U`f>cYL=U/jG3Hk001:FTYjBUU:NTYJBWY:FDYjBUY:NTYIBWY:FP00DWQFVE9hEYUBN5JI
DWQFVE9hEYUBN5JIDWQFVE9hEYT005jiFYP005jhH]UR^6;HG[QRfF:hH]QN^6;IH[QRf5jhH]UR^000
I]P006[gKaQZmflHJ_M_66[gKaQZm`00JaM_66lGKaQ[5flHKaM_66/GKaP00002KaL077<hKaL006/G
KcQ_6000JaM_>6lGKcQ[5flhKaM_>6/GKcP006lhJaM_>6lGKcQ[5flh001[>P003Woo00<007ooOol0
57oo00<007ooOol01Woo0011Ool00`00Oomoo`1:Ool600000dKMB]e6g@02A]d034[M000003:N=[hb
WSJn<Yhf_S:N=[hbWP<000051M/5n`000001E`0200026Qd01AXm6Q`J7AXM00000cIL00LjG3IL=U`f
G3YL=U`00002BWX01DYJBWY:NTYjBUX00dYj01I:FTYjBWX005IhEYUFNEJIEWQFVEIiEYUFN5JIEWUF
VEIhEYUFN@00F[P000mRf005001Vn6KhI]P00002JaP026/GJaQ[66/HJaL006lGKaP3KaL01VlHKaM_
5flGKaP000E_5`04001_>6lH0002KcP01FlHKcQ_>6lhKaP00flh00/006lhKaQ_>6lHKcQ_66lhKaQ_
>000011oo`03001oogoo01=oo`03001oogoo00Ioo`00@Woo0P00Bgoo01T004[nA]e:gDKMB_i6gD[M
A]e:oTKMB]e6g@00<Yhf_S:M=[hbWSJn<Ydf_S:N0005f`0200000`Gl000000040000F1XL6SdJ71hm
000jG3Hk>U`fFcYL=S/jG3IK>U`004YjBUY:NTYIBWY:FTYjBUU:NTYJBWY:FDYj001FVE9hEYUBN5JI
DWQFVE9hEYUBN5JIDWQFVE9hEYUBN000G[QRfF:hH]QN^6;IH[QRf5jhH]UR^6;HG[QRfF:h001Vf6Kh
I]QVn000KaQZmflHJ_M_66[gKaP006lHKaM_66/GKaQ_5flHJaM_66lG001_5g<h0flG01Qc>000KcP0
06lhKaM_>6/GKcQ_5flhJaM_>000KcQ[5flhKaM_>6/GKcQ_5flh000BOol00`00Oomoo`0BOol00`00
Oomoo`06Ool004Aoo`03001oogoo04Uoo`040016gDKMB]d3A]d04d[MA]e6gDKMB]e6g@00<Yhf_S:N
=[hbWSJn<Yhf_S:N0005f`Wl008000031M/0000000@000056SdJ71XM000jG003=U`01SYL=U`fG3IL
>U`000=:NP05BUY:NTYjBWY:FP03BWX044YJBWX005JIEWQFVEIiEYUFN5JIEWUFVEIhEYUFNEJI0P00
00=FV@00H]P036;H00@006KhI_QVf0=Vn008001[66/HJaQ[5f/H001_60=_5`07KaQ_5flGKaM_66lG
000026lG00<006lhKaP00flh011_66lhKcQ_>6lH001_66lhKaQ_>6lHKcQ_66lhKaP0019oo`03001o
ogoo01=oo`03001oogoo00Eoo`00AGoo00<007ooOol0BGoo0P0000]6gD[MA]e:oTKMB]e6gD[nA]e:
gDKM0080000<=[hbWCJn<Yhf_S:M=[hbWP001M/9o0GK0`0000@0m@000001NP80000U6Q`N?@00>U`f
>cYL=U/jG3Hk>U`fFcYL001:NTYJBWY:FDYjBUY:NTYIBWY:FTYjBUT0059hEYUBN5JIDWQFVE9hEYUB
N5JIDWP00P0002]J^EJIF[T006;HG[QRfF:hH]QN^6;IH[QRf5jhH]UR^000I]QVn6KHI_QVf6KhI]QV
n000KaQZmflH001_66lGKaQ[5flHKaM_66/GKaQ_5`00KaMc>003KaL06G<hKaM_5`00LcL006lhJaM_
>6lGKcQ[5flhKaL006/GKcQ_5flhJaM_>6lGKcQ[5`0001Aoo`03001oogoo019oo`03001oogoo00Eo
o`00AWoo00<007ooOol0BWoo00<004KMB]d00dKM00E:gDKMA]e6gD[M00L00006=[hbWSJn<Yh000GK
0`Wl0P0000<0m@0000000P5i0`0000<fG3YL=U`00SIL00HjG3IL=U`fG000BUX3BWX01DYJBWY:NTYj
BUX00dYj00Y:FP00EWUFVEIhEYUFNEJIEWQFV@800007EYUJ^EJIF[UFVEZi00002V;H00@006KhI_QV
f0=Vn008I]QVn6KhI_P006/H001_60=_5`05KaQ_5flGKaM_6002KaL00`00KaM_5`06KaL01P00KaM_
5`00KcQ_60=_>00<KaP006lHKcQ_66lhKaQ_>6lHKcQ_60005Woo00<007ooOol04Goo00<007ooOol0
1Goo0017Ool2001;Ool01000A]e:gDKM1P0000M:gDKLB_d003Zn=Ydj_P07000010Wl1M/9o0GK0P00
00D0mP000GX1N@5j00<0000L>U`f>cYL=U/jG3Hk>U`fF`00BUU:NTYJBWY:FDYjBUY:NTYIBWY:FTYj
001FVE9hEYUBN5JIDWP20000;EZiEYUJ^EJIF[UFVEZiEYT006:hH]QN^6;IH[QRf5jhH]UR^000I]QV
n6KHI_QVf6KhI]QVn6KHI_QVf000J_L006lGKaQ[5flHKaM_66/GKaQ_5flH001c>003KaL06G<hKaM_
5flG001_5g<gKaIc=`00KcQ[5flhKaM_>000KcQ_5flhJaM_>6lGKcQ[5`0001Qoo`03001oogoo011o
o`03001oogoo00Eoo`00BGoo00<007ooOol0BGoo0`002T[M00<003Zn=Yd00SJn00@j_SJM=[hf_P@0
00052O`5f`000000mP0200000`5i0GX1N@040002=U`01SYL=U`fG000BWY:FP=:NP05BUY:NTYjBWY:
FP03BWX01000EYUFNEJI0P0000aFVEZiEYUJ^EJIF[UFVEZiEYUJ^EJI0008H]P00`00I_QVf003I_P0
1FKHI_QVn6KhI]P00VKh00D006lGKaM_5flH00=_5`04KaQ_5flG0009KaL00`00KaM_5`02KaL04000
KcQ_>6lHKcP006lhKaQ_>6lHKcQ_66lhKaQ_>00067oo00<007ooOol047oo00<007ooOol01Goo001:
Ool00`00Oomoo`19Ool01@00B]e:gDKLB_d00T[M0196g4[mB]e:gDKLB_d003Zn=Ydj_SJM>[hfWCZn
=Yd000Wk3O`200000`GK000000030000105i0GX1N@000R8L0`00018jG3Hk>U`004YjBUU:NTYJBWY:
FDYjBUY:NTYIBWY:FP00DWP20000;eZiEYUJ^EJIF[UFVEZiEYUJ^EJIF[UFVEZi001RfF:hH]QN^6;I
H[QRf000I_QVf6KhI]QVn6KHI_QVf6KhI]QVn6KH001Vn000JaM_66lGKaQ[5flHKaM_66/G00000flG
01Yc>6lGKaM_5g<h001c=flFLcM_5g<gKaH006lGKcP006lhKaM_>6/GKcQ_5flhJaM_>0006Woo00<0
07ooOol03goo00<007ooOol01Goo001;Ool00`00Oomoo`19Ool00`00B]e:g@0:B]d00`00>[hfW@02
=[h013Zn=Ydf_SJn0P000Pgl200000<1NP5i0000128L10000TYj00E:FTYjBWY:NTYJ00L0000AEYUJ
^EJIF[UFVEZiEYUJ^EJIF[UFVEZiEYUJ^EJIF[T00005H]P00`00I_QVf003I_P01FKHI_QVn6KhI]P0
0VKh00D006[hJ_QZn00000=_5`05KaQ_5flGKaL00009KaL00`00KaM_5`05KaL03000KcP006lHKcQ_
66lhKaQ_>6lHKcP001aoo`03001oogoo00ioo`03001oogoo00Eoo`00C7oo0P00BWoo0P0000=:gDKL
B_d00T[M01E6g4[mB]e:gDKLB_d003Zn=Ydj_SJM>[hfWCZn=Ydj_P003O`9o0gl2O/00P0000L0e@00
0000005j0GT000038Q`00bHM8Q`R700800001DIjAW]6NdIkAWX00TIk02l005JIF[UFVEZiEYUJ^EJI
F[UFVEZiEYUJ^EJIF[UFV@00G[QRfF:hH]P006KhI]QVn6KHI_QVf6KhI]QVn6KHI_QVf6Kh001[66Kg
JaP006lHJaM_66lGKaQ[5`0000=_5`0JLcQ_5flGKaMc>6lG001_5W<gKaMc=flFLcM_5g<gKaH006lG
KcQ[5flhKaM_>6/GKcP001ioo`03001oogoo00eoo`03001oogoo00Eoo`00CWoo00<007ooOol0BGoo
00<004[MB]d01d[M200000DfWCJn=[hj_P0000D=o0L000PR70030016NdIk00Y6N`0B001J^EJIF[UF
VEZiEYUJ^EJIF[UFVEZiEYUJ^EJIF[UFV@000V;H00<006KhI]P00fKh00EVf6KhI_QVn6KH00=Vn004
001Zn6[hJaP2J_P00`00KaQ_5`02KaL00flH001_5`07KaL00`00KaM_5`07KaL02`00KaL006lHKcQ_
66lhKaQ_>6lH00007Woo00<007ooOol03Woo00<007ooOol017oo001?Ool00`00Oomoo`19Ool01000
B]e6g4[m1@0000Q:gD[LB_d003Zn>Ydj_SZM1`0000@9o0gl2O/=o08000030;@0002e008000059QdR
728L8Q`V7@028Q`01@00AW]6NdIkAWX00dIk03=6NTIkAW]6NdIjAW/005ZiEYUJ^EJIF[UFVEZiEYUJ
^EJIF[UFVEZiEYUJ^@00H]P006KhI]QVn6KHI_QVf6KhI]QVn6KHI_QVf6Kh001[66KgJaQVn6/HI_M[
6000KaQ[5flH00000VlG00Ec>6lGKaM_5g<h009_5`0D001c=flGLcM_5W<gKaMc=flFLcL007<gKaH0
06lGKcQ[5flhKaL0021oo`03001oogoo00eoo`03001oogoo00Aoo`00D7oo00<007ooOol0BGoo0`00
2D[M00X003Zn>Ydj_SZm>[hjWCZn>[dj_P@0008=o08000030;@0003E008000LR70030016NdIk00]6
N`0C001J^EJIF[UFVEZiEYUJ^EJIF[UFVEZiEYUJ^EJIF[T006KhI]P00fKh00EVf6KhI_QVn6KH00=V
n004001Zn6[hJaP3J_P01V/HJ_QZn000KaP000U_5`03001_5flG00M_5`0:001_5flGLcM_5`00KaQ_
>6lH000ROol00`00Oomoo`0<Ool00`00Oomoo`04Ool0055oo`03001oogoo04Uoo`04001:gD[LB_d2
B]d04d[LB_e:gD[MB]a:o@00>[hjWCZn>Ydj_SZM>[hjWCZn000B7@gl008000033O`9o00000800004
0;D0e@009Qd38Q`012HM8Q`R70000dIk00E6NTIkAW]6NdIj00=6N`0?AWX005JIF[UFVEZiEYUJ^EJI
F[UFVEZiEYUJ^EJI0080000MG]X006KhI]QVn6KHI_QVf6KhI]QVn6KHI_P006/HI_M[66KhJaQVmf/H
I_Q[66Kg001_5`00KaMc>003KaL05g<hKaM_5flG001_5g<gKaIc=flGLcM_5W<g001c=flFLcM_5g<g
001_>6lG00008goo00<007ooOol037oo00<007ooOol017oo001BOol2001:Ool00`00B]e:g@09B]d0
3P00>[hjWCZn>[dj_SZM>[hj_CZn000Ao0gl4O`700000`3E000000068Q`00`00AW]6N`0:AW/02`00
EYUJ^EJIF[UFVEZiEYUJ^EJIF[T00P0000MJ^E[JF[UJfP00I_QVf003I_P026KHI_QVn6KhI]P006[h
JaP3J_P01f/HJ_QZn6[hJaQZn00000U_5`03001_5flG00M_5`03001_5g<g00=_5`04LcL006lh000T
Ool00`00Oomoo`0;Ool00`00Oomoo`04Ool005Aoo`03001oogoo04Qoo`04001:gD[LB_d2B]d05T[L
B_e:gD[MB]a:o@00>[hjWCZn>Ydj_SZM>[hjWCZn000B7@gl4Q`=o18M1@0000@0e@000000008R7004
9QdR7000AWX3AW/01DIjAW]6NdIkAWX00dIk02X005ZiEYUJ^EJIF[UFVEZiEYUJ^@00G]YJ^EkJF[UN
fUZi001Vf6KhI]QVn6KHI_QVf6KhI]P006KgJaQVn6/HI_M[66KhJaQVmf/HI_P006[g0003KaL067<h
KaM_5flG001_5g<gKaIc=flGLcM_5W<gKaL006lFLcM_5g<gKaIc=flGLcL002Ioo`03001oogoo00Yo
o`03001oogoo00Aoo`00EGoo00<007ooOol0B7oo00<004[MB]d01d[M200000/jWCZn>[dj_P004O`=
o17l3O`Ao0gl00@000030=D000Vk008000<R70030016NdIk00Y6N`07001J^EJIF[UFVEZiEYT00P00
00UJfUZiF]YJ^E[JF[UJfUZi00000VKh00QVf6KhI_QVn6KH001Zn6/H0f[h00M[66[hJ_QZn6/HJ_P0
0002JaP00f/G001_5`05KaL00`00KaM_5`06KaL00`00KaMc=`03KaL017<gKaM_5`00:7oo00<007oo
Ool02Goo00<007ooOol017oo001FOol00`00Oomoo`18Ool01000B]e:g4[m1@0000Q>gD[LC_d003jn
>Ydn_SZM1`0000D=o18L3O`B7@gl00@000040=D000Vk1K/2000012HM8Q`004Ij0dIk00E6NTIkAW]6
NdIj00=6N`04001J^EJIF[T2000095ZiG]YJ^EkJF[UNfUZiG]YJ^EkJF[T006KHI_QVf6KhI]P006Kg
JaQVn6/HI_M[66KhJaQVmf/HI_Q[6000KaQZmflHJ_L000=_5`0ELcP007<gKaIc=flGLcM_5W<gKaMc
=`00LcM_5g<gKaIc=flGLcM_5P0002Qoo`03001oogoo00Uoo`03001oogoo00Aoo`00Egoo0P00BGoo
0`002D[M00X003Zn>[dj_SZm>[hj_CZn>[dj_P@000033O`Ao0gl00D000@9^`<000a6N`0C001FV@00
001JfUZiF]YJ^E[JF[UJfUZiF]YJ^E[JF[UJfUZi00000VKh00AVf000J_Q[60=Zn005JaQZn6[hJ_Q[
6002J_P00`00JaQ[5`03JaP00`00KaM_5`02KaL00`00KaM_5`06KaL00`00LcM_5`02KaL01G<gKaM_
5flG0000:Woo00<007ooOol02Goo00<007ooOol00goo001IOol00`00Oomoo`17Ool03000C]e:g4km
B]a>gD[LC_e:g4kMB]a>o@80000;>Ydn_SZM?[hjWCjn>Ydn_P004QdAo00200000a8M3O`000040000
1@FJ2K/5^`Vk1IX03`0003mJ^EkJF[UNfUZiG]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfP00I_QVf6Kh001[
66KhJaQVmf/HI_Q[66KgJaQVn6/H001_66[gKaQZmflHJ_M_6000LcQ_5`00KaIc=flGLcM_5W<gKaMc
=`00LcM_5g<gKaIc=flGLcM_5W<g0000:goo00<007ooOol027oo00<007ooOol00goo001JOol00`00
Oomoo`17Ool00`00B]e:g@0:B]d02@00>[dj_SZm>[hj_CZn>[dj_P0200000a7l4Q`000030000102d
0000DP001PVk00<004:L@W`00T9l00E2W49l@Wa2O4:L00=2O00E001J^E[JF[UJfUZiF]YJ^E[JF[UJ
fUZiF]YJ^E[JF[UJfP00I_P006/H00=Zn005JaQZn6[hJ_Q[6002J_P00`00JaQ[5`03JaP01f/GJaQ[
66/H001_5`0000Q_5`05001_5flGKaMc=`03KaL00g<g001oo`0/Ool00`00Oomoo`07Ool00`00Oomo
o`03Ool005]oo`03001oogoo04Moo`0L001>gD[LC_e:g4kMB]a>oD[LC]e:g4kmB]`003ZM?[hjWCjn
>Ydn_SZM?[hjW@004O`B70gl4Qd20000E02D0000DP001IX9^`Fk2K/5VP00?Wa2W3ik@Y`nO4:L?W]2
W3il@Y`nNd:L001NfUZiG]YJ^EkJF[UNfUZiG]YJ^EkJF[UNfUZiG]YJ^EkJ001[66KhJaQVmf/HI_Q[
66KgJaQVn6/HI_L006[gKaQZmflHJ_M_66[gKaQZmflH001c=flGLcM_5W<gKaMc=flF001_5g<gKaIc
=flGLcM_5W<gKaL002eoo`03001oogoo00Moo`03001oogoo00=oo`00G7oo0P00B7oo00<004[MB]d0
24[M3P0000@B717l4O`Ao0<000030580000000@9^`030012O4:L00=2O005@Ya2O49l@Wa2W002@W`0
3`00F]YJ^E[JF[UJfUZiF]YJ^E[JF[UJfUZiF]YJ^@0200001Ekj001Zn6[hJaP00f[h00I[66[hJ_QZ
n000JaL3JaP02F/GJaQ[66/HJaM[6000KaP00006KaL01@00KaM_5flGLcL00flG00=c=flG0000;goo
00<007ooOol01Woo00<007ooOol00goo001NOol00`00Oomoo`16Ool01000C]e:g4km1P003Woo0`00
00<B7A7l00001@0001d9^`Fk2K/5VP00?Wa2W3ik@Y`nO4:L?W]2W3il@Y`nN`00F[UNfUZiG]YJ^EkJ
F[UNfUZiG]YJ^EkJ0080000/F]UNnUkJ001Vmf/HI_Q[66KgJaQVn6/HI_L006[gKaQZmflHJ_M_66[g
KaQZmflH001_66/GKaP007<gKaMc=flFLcL007<gKaIc=flGLcM_5W<gKaL0035oo`03001oogoo00Eo
o`03001oogoo00=oo`00Ggoo00<007ooOol0AWoo0`005goo0P0000@Ao0000000]0@000<9^`030012
O4:L00=2O00I@Ya2O49l@Wa2W49l001J^E[JF[UJfUZiF]YJ^E[JF[UJfP00G_YNfUkjG]YNnUkJ0000
0f[h00I[66[hJ_QZn000JaL3JaP01F/GJaQ[66/HJaL00V/H00<006/GKaP00VlH00D006lGKaM_5`00
009_5`05LcM_5flGKaMc=`02KaL00`00Oomoo`0`Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0061o
o`03001oogoo04Eoo`03001oogoo01Uoo`H0000J0ET1>0001K/9^`00@Y`nO4:L?W]2W3il@Y`nNd:L
?Wa2W3ik001J^EkJF[UNfUZiG]YJ^@80000^G_YJfEkjG]YNnU[IG_YNfP00I_M[66KhJaQVmf/H001_
66[gKaQZmflHJ_M_66[gKaQZm`00JaM_66/GKaQ[5`00KaIc=`00LcM_5W<gKaMc=flFLcM_5g<g000c
Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0065oo`8004Eoo`03001oogoo01aoo`@000060ET1>000
0009^`000T9l00E2W49l@Wa2O4:L00=2O00E@Y`005[JF[UJfUZiF]YJ^@00G]YNnUkJG_YNfUkjG]YN
nUkJG_X006/H00=Zn003JaP006/H009[6005JaM[66/HJaQ[5`02JaP00`00JaM_6002KaP026/GKaQ_
6000KaL006lGLcL3KaL01G<gKaM_5flG0000=7oo00<007ooOol017oo00<007ooOol00Woo001SOol0
0`00Oomoo`12Ool00`00Oomoo`0NOol300005@5I0CP1F@002K/004:L?Wa2W3ik@Y`nO4:L?W]2W3il
@Y`005kJF[UNfP020000<5kJG_YJfEkjG]YNnU[IG_YNfUkjF]UNnP00JaQVmf/H001_66[gKaQZmflH
J_M_66[gKaQZm`00JaM_66/GKaQ[5flHJaM_66/G001_5W<gKaMc=flFLcM_5g<gKaH003Ioo`03001o
ogoo00=oo`03001oogoo009oo`00I7oo00<007ooOol0@Goo00<007ooOol07goo0`0000<1F@4h0ET0
0P000d9l00E2W49l@Wa2O4:L00=2O00F001J^@00001NnUkJG_YNfUkjG]YNnUkJG_YNfUkjG]YNnUkJ
G_X006/H0003JaP01F/GJaQ[66/HJaL00f/H00D006lHKaQ_66/G00=_6004JaL006lG0003KaL01G<g
KaM_5flG0000=goo00<007ooOol00goo00<007ooOol00Woo001UOol00`00Oomoo`10Ool00`00Oomo
o`0QOol20000105I0CP1F@4h3@0003=JfEkjG]YNnU[IG_YNfUkjF]UNnUkJG_YJfEkjG]YNnU[I001V
n000J_M_66[gKaQZmflHJ_M_66[gKaP006lHJaM_66/GKaQ[5flHJaM_6000KcQ[5`00KaIc=flGLcM_
5W<g0000>7oo00<007ooOol00Woo00<007ooOol00Woo001VOol20010Ool00`00Oomoo`0ROol30000
8P4h0ET1>@00>W`jWCYm>YdjO3ZM>WdjWCYl>YdjO@00G]YNnUkJG_YNfUkjG]YNnUkJG_YNfUkjG]YN
nUkJG_YNfP000V/H00E[5f/HJaQ[66/G00=[6005001_66lHKaQ[5`03KaP026/GKaP006lHKaM_66lG
0003KaL00g<g001oo`0iOol01@00Oomoogoo000017oo001XOol00`00Oomoo`0mOol00`00Oomoo`0S
Ool300007P4h0ET1>000>W`nWCYl?YdjO3jM>W`nWCYl?YdjO000F]UNnUkJG_YJfEkjG]YNnU[IG_YN
fUkjF]UNnP80000PG_X006[gKaQZmflHJ_M_66[gKaP006lHJaM_66/GKaQ[5flHJaM_6000KcQ[5flH
JaM_>000LcM_5W<gKaL003]oo`04001oogoo0004Ool006Uoo`03001oogoo03aoo`03001oogoo02Ao
o`<0000M0CP1F@00>YdjO3ZM>WdjWCYl>YdjOCZM>W`jW@00G_YNfUkjG]YNnUkJG_YNfUkjG]YNnUkJ
G_X00002G_X00f;jG_X00002JaP01V/GJaQ[66/HJaL0009_6005JaM_66lHKaQ[5`02KaP02`00KaM_
66lGKaQ_5flH001c=flG0000?7oo00@007ooOol000Aoo`00JWoo00<007ooOol0>goo00<007ooOol0
9Goo100001P1F@00?YdjO3jM>W`nWCYl?YdjO3jM>W`nW@00G_YJfEkjG]YNnU[IG_YNfUkjF]T20000
8V;jG_YS6UkjH_YNnP00J_M_66[gKaQZm`00JaM_66/GKaQ[5flHJaM_66/G001[5flHJaM_>6/GKaQ[
5flh001c=`00?Goo00<007oo000017oo001[Ool2000kOol00`00Oomoo`0WOol06P000?L0005I000j
WCYl>YdjOCZM>W`jWCYm>YdjO3ZM001NnUkJG_YNfUkjG]YNnUkJ0003G_X01V;jG_YNnUkjH_X000=[
6005JaL006lHKaQ[5`03KaP03f/GKaQ_6000KaM_66lGKaQ_5flHKaM_66lGKaP0000oOol00`00Ool0
0003Ool006eoo`03001oogoo03Qoo`03001oogoo02Qoo`0F0000m`000ET003jM>W`nWCYl?YdjO3jM
>W`nWCYl?Yd005kjF]UNnUkJG_X200008ekjH_YNnV<JG_YRnUkjHaYNnV;j001_66[g001[5flHJaM_
66/GKaQ[5flHJaM_6000KaQ[5flhJaM_66/GKcQ[5flH0000@Goo0P000goo001^Ool00`00Oomoo`0g
Ool00`00Oomoo`0YOol05P000?L00000>WdjWCYl>YdjOCZM>W`jWCYm>YdjO000G]YNnUkJG_X006;j
0ekj00ERnUkjG_YNnV;j00=NnP06H_X006/H001_66/G0flH011[5flHKaQ_6000KaQ_5flHKaM_66lG
KaQ_5flHKaL0045oo`8000=oo`00Kgoo00<007ooOol0=Goo00<007ooOol0:goo0P0000<0eP000000
1@0000LjO3jM>W`nWCYl001NfP0200009F<JG_YRnUkjHaYNnV;jG_YS6UkjH_YNnV<JG_YRnP00KaQ[
5flHJaM_66/GKaQ[5flHJaL006/GKcQ[5flHJaM_>6/GKaQ[5`00049oo`8000=oo`00L7oo0P00=Goo
00<007ooOol0;7oo0P0000L0mP00=WdfWCIm=YdfO@0700000ekjH_YNnP02G_X01F;jG_YNnUkjH_X0
0ekj00IRnUkjG_X006<J0003KaP046/GKaQ_66lHJaL006lGKaQ_5flHKaM_66lGKaQ_5`00?goo1000
1Goo001bOol00`00Oomoo`0bOol00`00Oomoo`0]Ool200006`3F000fOCJM=WdfWSIm=YdfOCJN=Wdf
WCIm001NnV;jG_YS6UkjH_YNnV<JG_YRnUkjHaYNnP0200005V<KG_YS6`00KaQ[5flHJaM_66/G001[
5flhJaM_66/GKcQ[5flHJaM_>000>goo10002Goo001cOol00`00Oomoo`0aOol00`00Oomoo`0^Ool2
0000403f000fOCJM=WdfWCIm=YdfOCJM=WdfWCIm001NnV;j0ekj00MRnUkjG_YNnV;jG_X00002HaX0
1EkjHaYS6V<J00000flH00e[5flH001_66lGKaQ_5flHKaM_66lGKaP0000hOol4000=Ool007Aoo`03
001oogoo031oo`03001oogoo02moo`<0000^=YhfOCJM=WdfWSIm=YdfOCJN=WdfW@00HaYNnV;jG_YS
6UkjH_YNnV<JG_X005kjHa]NnV<KG_YS6ekj001[5flHJaM_6000KcQ[5flHJaM_>6/GKaQ[5flh000e
Ool4000AOol007Eoo`80031oo`03001oogoo02moo`@0000<=YdfOCJM=WdfWCIm=YdfOCJM=WdfW@00
0Ukj00ERnUkjG_YNnV;j0080009S6P05G_YS6V<JHaYNnP02HaX03P00JaM_6000KaQ_5flHKaM_66lG
KaQ_5flH000bOol4000EOol007Moo`03001oogoo02eoo`03001oogoo031oo`@0000[=YhfOCJM=Wdf
WSIm=YdfOCJN=WdfW@00HaYNnV;jG_YS6P00Ha]NnV<KG_YS6ekjHa]NnV<KG_YS6ekj001[5`00JaM_
66/GKcQ[5flHJaM_>6/G0000;Woo10006Goo001hOol00`00Oomoo`0/Ool00`00Oomoo`0aOol70000
2CIm=YdfOCJM=WdfWCIm=Yd00002G_X00f;j001S6P02HaX01EkjHaYS6V<JG_X00f<J00iNnV<JHaX0
06lGKaQ_5flHKaM_66lGKaQ_5`00;7oo0`007Goo001iOol00`00Oomoo`0[Ool00`00Oomoo`0bOol0
1P0009@00000<YhbO@H00004=YhfO@00G_X200003F<KG_YS6ekjHa]NnV<KG_YS6ekjHa]NnV<K0080
000:HaX006/GKcQ[5flHJaM_>6/G000YOol4000POol007Yoo`8002]oo`03001oogoo03=oo`040000
U0000002<Wd01C:N<WdbOC9m<Yh0100000ENnV<JHaYS6Ukj00=S6P07G_YS6V<JHaYNnV<J000016<J
00P006lGKaQ_5flHKaM_60009Goo100097oo001lOol00`00Oomoo`0XOol00`00Oomoo`0dOol00`00
09@0U00200005C9m<Yh^OC:N<WdbWRim<YhbO@00G_YS6ekjHa]NnV<KG_YS6ekjHa]NnP02000036<K
HaYS6elJHa]S6P00JaM_>6/GKaP0029oo`@002Qoo`00OGoo00<007ooOol09goo00<007ooOol0=Goo
00<0002D09@00P0000<bOC:N<Wd00S9m00HbWS9m<WdbO@00G_X3HaX01UkjHaYS6V<JG_X000US6P04
001_5flH000OOol4000/Ool007ioo`03001oogoo02Ioo`03001oogoo03Ioo`030000U02D0080000@
<WdbWRim<YhbOC:N;WdbWS9m001NnV<KG_YS6ekjHa/200003UlJHa]S6V<KGaYS6f<JHa]O6V<KHaX0
06/G000KOol4000`Ool007moo`8002Ioo`03001oogoo03Moo`800080U0<000<bO@06<YhbOC9m<Wd0
05kj0f<J00<006<JHaX036<J00<007ooOol05Woo1000=7oo0021Ool00`00Oomoo`0SOol00`00Oomo
o`0iOol01@0009@0U000;Wd01P0000@bWS9m001NnP80000?Ha]O6V<KHaYS6elJHa]S6V<KGaYS6f<J
Ha]O6P0001Eoo`@003Qoo`00PWoo00<007ooOol08Woo00<007ooOol0>Woo00X0002D000^ORim;Wh^
OBin;Wd^OP@000iS6P8001=oo`<003aoo`00Pgoo00<007ooOol08Goo00<007ooOol0>goo01/0002D
000bWRim<Yh^OC:N;WdbWRim<Yh^O@00GaYS6f<JHa]O6V<KHaYS6elJHa]S6V<K00004Goo1000?goo
0024Ool2000QOol00`00Oomoo`0lOol03P0009@002in;Wd^ORim;Wh^OBin;Wd^ORim000:HaX00`00
Oomoo`0<Ool40013Ool008Ioo`03001oogoo01ioo`03001oogoo03eoo`<0000B<Yh^OC:N;WdbWRim
<Yh^OC:N;Wd005lJHa]S6V<KGaYS6f<J0P002goo1000Agoo0027Ool00`00Oomoo`0MOol00`00Oomo
o`0oOol03000;Wd^ORim;Wh^OBin;Wd^ORim;Wh000IS6P03001oogoo00Moo`@004]oo`00R7oo00<0
07ooOol077oo00<007ooOol0@7oo100000dbWRim<Yh^OC:N;WdbWP00Ha]O6V<KHaX00006Ool4001?
Ool008Uoo`03001oogoo01]oo`03001oogoo04Aoo`H00004;Wd^OP00HaX20003Ool4001COol008Yo
o`8001]oo`03001oogoo04Yoo`@0009oo`<005Moo`00S7oo00<007ooOol067oo00<007ooOol0C7oo
1000FWoo002=Ool00`00Oomoo`0GOol00`00Oomoo`18Ool4001NOol008ioo`03001oogoo01Ioo`03
001oogoo04Aoo`@0069oo`00Sgoo0P005Woo00<007ooOol0@7oo1000IWoo002AOol00`00Oomoo`0C
Ool00`00Oomoo`0lOol4001ZOol0099oo`03001oogoo019oo`03001oogoo03Qoo`@006ioo`00Tgoo
00<007ooOol04Goo00<007ooOol0=Goo0`00LWoo002DOol2000@Ool00`00Oomoo`0bOol4001eOol0
09Ioo`03001oogoo00eoo`03001oogoo02ioo`@007Uoo`00Ugoo00<007ooOol037oo00<007ooOol0
:Woo1000OGoo002HOol00`00Oomoo`0;Ool00`00Oomoo`0VOol40021Ool009Uoo`8000]oo`03001o
ogoo029oo`@008Eoo`00Vgoo00<007ooOol027oo00<007ooOol07Woo1000RGoo002LOol00`00Oomo
o`07Ool00`00Oomoo`0JOol4002=Ool009eoo`03001oogoo00Ioo`03001oogoo01Moo`<0095oo`00
WWoo0P001Woo00<007ooOol04goo1000U7oo002POol00`00Oomoo`03Ool00`00Oomoo`0?Ool4002H
Ool00:5oo`03001oogoo009oo`03001oogoo00]oo`@009aoo`00XWoo00D007ooOomoo`0000Uoo`@0
0:1oo`00Xgoo0P0000=oo`00Ool017oo1000Y7oo002UOol200000goo00000002002XOol00:Ioo`80
0:aoo`00ogooEGoo003oOomEOol00?mooeEoo`00ogooEGoo003oOomEOol00?mooeEoo`00ogooEGoo
003oOomEOol00?mooeEoo`00ogooEGoo003oOomEOol00?mooeEoo`00\
\>"],
  ImageRangeCache->{{{23.75, 339.125}, {254.625, 7.6875}} -> {-0.183584, \
0.0449353, 0.00421766, 0.00421766}}]
}, Open  ]],

Cell[TextData[{
  "A second solution with similar properties develops from the subgroup ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", 
          RowBox[{
            StyleBox["k2",
              FontSlant->"Italic"], "=", 
            RowBox[{
              StyleBox["k4",
                FontSlant->"Italic"], "=", "1"}]}]}], TraditionalForm]]],
  ". The corresponding infinitesimals are"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 1, k2 \[Rule] 1, k3 \[Rule] 0, k4 \[Rule] 1, 
          k5 \[Rule] 0, k6 \[Rule] 0, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{E\^\(-\[Tau]\) + E\^\[Tau], 0}, {1\/2\ P\ \((2 - 2\ E\^\[Tau]\ v)\)}}
      \)], "Output"]
}, Open  ]],

Cell["The similarity reduction of the FP equation is gained with", "Text",
  CellTags->{
  "similarity reduction", "similarity reduction of the FP equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(red2 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red2]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Tau] - \[Zeta]\_1 == 0\)},
          {
            \(E\^\(\(-\(\(E\^\[Tau]\ v\)\/\(1 + E\^\(2\ \[Tau]\)\)\)\) + 
                      \(E\^\(2\ \[Tau]\)\ v\^2\)\/\(2\ 
                          \((1 + E\^\(2\ \[Tau]\))\)\)\)\ P - F\_1 == 0\)},
          {
            \(\(-F\_1\) - 2\ E\^\(2\ \[Zeta]\_1\)\ F\_1 + 
                \((F\_1)\)\_\(\[Zeta]\_1\) + 
                2\ E\^\(2\ \[Zeta]\_1\)\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                E\^\(4\ \[Zeta]\_1\)\ \((F\_1)\)\_\(\[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again the similarity variable is \[Tau]. The similarity representation of \
the solution combines an unknown function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " with an exponential depending on the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and time \[Tau]. The related first-order ODE which ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " has to satisfy determines the similarity solution:"
}], "Text",
  ShowCellBracket->True,
  CellTags->{"similarity representation", "similarity solution"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(solr2\  = 
      DSolve[red2\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]
        \)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((E\^\(\(-\(\(1 + E\^\(2\ #1\)\)\/\(2\ 
                            \((1 + 2\ E\^\(2\ #1\) + E\^\(4\ #1\))\)\)\)\) - 
                    \(\((1 + E\^\(2\ #1\))\)\^2\ Log[1 + E\^\(2\ #1\)]\)\/\(2
                        \ \((1 + 2\ E\^\(2\ #1\) + E\^\(4\ #1\))\)\) + 
                    \(\((1 + E\^\(2\ #1\))\)\^2\ #1\)\/\(1 + 
                        2\ E\^\(2\ #1\) + E\^\(4\ #1\)\)\)\ C[1]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell["This solution reads, in original variables,", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2 = 
      Solve[red2\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr2, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] 
          \(E\^\(\(\(-1\) + 2\ E\^\[Tau]\ v - E\^\(2\ \[Tau]\)\ v\^2 + 
                      2\ \((1 + E\^\(2\ \[Tau]\))\)\ \[Tau]\)\/\(2\ 
                      \((1 + E\^\(2\ \[Tau]\))\)\)\)\ 
              C[1]\)\/\@\(1 + E\^\(2\ \[Tau]\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"The plot of the solution shows that, contrary to the previous group, a small \
difference exists. The difference occurs for larger positive velocities and \
negative times \[Tau]. In this region, the probability density has a \
non-vanishing value."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      \(P /. sol2\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. 
        C[1] \[Rule] 1, {v, \(-3\), 5}, {\[Tau], \(-2\), 2}, 
      AxesLabel \[Rule] {"\<v\>", "\<\[Tau]\>", "\<P\>"}, 
      PlotPoints \[Rule] 25]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.04977 -0.0679587 1.04977 [
[.10092 .21731 -12 -8.91782 ]
[.10092 .21731 0 .08218 ]
[.25429 .15697 -5.74307 -9 ]
[.25429 .15697 .25693 0 ]
[.41721 .09289 -5.43033 -9 ]
[.41721 .09289 .56967 0 ]
[.59061 .02474 -5.11759 -9 ]
[.59061 .02474 .88241 0 ]
[.29165 .07573 -10.2423 -15 ]
[.29165 .07573 .75771 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01553 .31893 -24 -2.78782 ]
[.01553 .31893 0 6.21218 ]
[.00663 .37467 -18 -2.83512 ]
[.00663 .37467 0 6.16488 ]
[-0.00258 .43242 -24 -2.8843 ]
[-0.00258 .43242 0 6.1157 ]
[-0.01214 .49231 -6 -2.93549 ]
[-0.01214 .49231 0 6.06451 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02779 .31426 m
.03392 .31193 L
s
[(0.25)] .01553 .31893 1 -0.38048 Mshowa
.01894 .37011 m
.02509 .36784 L
s
[(0.5)] .00663 .37467 1 -0.36997 Mshowa
.00977 .42799 m
.01594 .42577 L
s
[(0.75)] -0.00258 .43242 1 -0.35904 Mshowa
.00026 .488 m
.00645 .48585 L
s
[(1)] -0.01214 .49231 1 -0.34767 Mshowa
.125 Mabswid
.03465 .27097 m
.03832 .26955 L
s
.03295 .28168 m
.03663 .28026 L
s
.03124 .29247 m
.03492 .29105 L
s
.02952 .30333 m
.0332 .30192 L
s
.02604 .32528 m
.02973 .32388 L
s
.02429 .33637 m
.02797 .33498 L
s
.02252 .34754 m
.0262 .34616 L
s
.02073 .35879 m
.02442 .35741 L
s
.01713 .38152 m
.02083 .38017 L
s
.01531 .39302 m
.01901 .39166 L
s
.01348 .40459 m
.01718 .40325 L
s
.01163 .41625 m
.01533 .41491 L
s
.00789 .43982 m
.0116 .4385 L
s
.00601 .45173 m
.00972 .45042 L
s
.0041 .46373 m
.00782 .46243 L
s
.00219 .47582 m
.0059 .47452 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
45.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
45.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(P) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.617 .728 .925 r
.3923 .59331 .40507 .60526 .42639 .60139 .41372 .58925 Metetra
.546 .702 .942 r
.41372 .58925 .42639 .60139 .44785 .60056 .43527 .58812 Metetra
.377 .623 .949 r
.43527 .58812 .44785 .60056 .46946 .60509 .45696 .59219 Metetra
.018 .405 .855 r
.45696 .59219 .46946 .60509 .49131 .61762 .47886 .60409 Metetra
0 .056 .572 r
.47886 .60409 .49131 .61762 .51355 .63995 .50111 .62567 Metetra
.656 .177 0 r
.50111 .62567 .51355 .63995 .53639 .67124 .52392 .6563 Metetra
.704 .235 0 r
.52392 .6563 .53639 .67124 .55996 .70643 .54745 .69127 Metetra
.573 .105 0 r
.54745 .69127 .55996 .70643 .5842 .73633 .57168 .72165 Metetra
0 .364 .833 r
.57168 .72165 .5842 .73633 .60876 .75041 .59632 .73697 Metetra
.657 .741 .912 r
.59632 .73697 .60876 .75041 .63313 .74175 .62088 .72996 Metetra
.855 .795 .791 r
.62088 .72996 .63313 .74175 .65686 .71095 .64489 .70061 Metetra
.909 .799 .727 r
.64489 .70061 .65686 .71095 .67982 .66577 .66817 .65619 Metetra
.923 .802 .709 r
.66817 .65619 .67982 .66577 .70226 .61684 .69092 .60719 Metetra
.919 .809 .723 r
.69092 .60719 .70226 .61684 .7246 .57287 .71351 .56253 Metetra
.896 .815 .761 r
.71351 .56253 .7246 .57287 .74722 .53822 .73633 .52693 Metetra
.851 .813 .812 r
.73633 .52693 .74722 .53822 .77037 .51322 .75963 .50101 Metetra
.793 .798 .857 r
.75963 .50101 .77037 .51322 .79407 .49584 .78348 .48291 Metetra
.737 .777 .885 r
.78348 .48291 .79407 .49584 .81828 .48342 .80783 .46999 Metetra
.699 .76 .899 r
.80783 .46999 .81828 .48342 .8429 .47374 .83258 .45999 Metetra
.678 .749 .905 r
.83258 .45999 .8429 .47374 .86783 .46535 .85767 .45139 Metetra
.669 .744 .907 r
.85767 .45139 .86783 .46535 .89303 .45748 .88302 .44335 Metetra
.665 .742 .908 r
.88302 .44335 .89303 .45748 .91847 .44975 .90862 .43548 Metetra
.664 .742 .908 r
.90862 .43548 .91847 .44975 .94414 .44202 .93445 .42762 Metetra
.664 .741 .908 r
.93445 .42762 .94414 .44202 .97003 .43424 .96052 .41972 Metetra
.619 .728 .924 r
.37934 .58119 .3923 .59331 .41372 .58925 .40087 .57693 Metetra
.553 .704 .941 r
.40087 .57693 .41372 .58925 .43527 .58812 .42251 .57548 Metetra
.395 .632 .949 r
.42251 .57548 .43527 .58812 .45696 .59219 .44428 .57905 Metetra
.058 .43 .871 r
.44428 .57905 .45696 .59219 .47886 .60409 .46623 .59022 Metetra
0 .092 .609 r
.46623 .59022 .47886 .60409 .50111 .62567 .48849 .61092 Metetra
.627 .151 0 r
.48849 .61092 .50111 .62567 .52392 .6563 .51128 .64073 Metetra
.685 .219 0 r
.51128 .64073 .52392 .6563 .54745 .69127 .53476 .6753 Metetra
.562 .101 0 r
.53476 .6753 .54745 .69127 .57168 .72165 .55898 .7061 Metetra
0 .332 .814 r
.55898 .7061 .57168 .72165 .59632 .73697 .58369 .72276 Metetra
.624 .722 .917 r
.58369 .72276 .59632 .73697 .62088 .72996 .60842 .71768 Metetra
.844 .792 .801 r
.60842 .71768 .62088 .72996 .64489 .70061 .63272 .69016 Metetra
.906 .801 .732 r
.63272 .69016 .64489 .70061 .66817 .65619 .65634 .64682 Metetra
.925 .806 .71 r
.65634 .64682 .66817 .65619 .69092 .60719 .6794 .59793 Metetra
.923 .814 .722 r
.6794 .59793 .69092 .60719 .71351 .56253 .70226 .5526 Metetra
.902 .821 .758 r
.70226 .5526 .71351 .56253 .73633 .52693 .72529 .51595 Metetra
.859 .82 .809 r
.72529 .51595 .73633 .52693 .75963 .50101 .74875 .48896 Metetra
.801 .805 .855 r
.74875 .48896 .75963 .50101 .78348 .48291 .77273 .47 Metetra
.743 .782 .884 r
.77273 .47 .78348 .48291 .80783 .46999 .79721 .45647 Metetra
.702 .763 .899 r
.79721 .45647 .80783 .46999 .83258 .45999 .82211 .44608 Metetra
.68 .751 .905 r
.82211 .44608 .83258 .45999 .85767 .45139 .84734 .43722 Metetra
.669 .745 .907 r
.84734 .43722 .85767 .45139 .88302 .44335 .87285 .429 Metetra
.665 .743 .908 r
.87285 .429 .88302 .44335 .90862 .43548 .89861 .42099 Metetra
.664 .742 .908 r
.89861 .42099 .90862 .43548 .93445 .42762 .92461 .413 Metetra
.664 .741 .908 r
.92461 .413 .93445 .42762 .96052 .41972 .95085 .40496 Metetra
.622 .729 .924 r
.36619 .56889 .37934 .58119 .40087 .57693 .38782 .56442 Metetra
.559 .707 .939 r
.38782 .56442 .40087 .57693 .42251 .57548 .40956 .56265 Metetra
.413 .64 .95 r
.40956 .56265 .42251 .57548 .44428 .57905 .43141 .56568 Metetra
.1 .456 .886 r
.43141 .56568 .44428 .57905 .46623 .59022 .45342 .57604 Metetra
0 .134 .649 r
.45342 .57604 .46623 .59022 .48849 .61092 .4757 .59571 Metetra
.591 .118 0 r
.4757 .59571 .48849 .61092 .51128 .64073 .49847 .62448 Metetra
.659 .197 0 r
.49847 .62448 .51128 .64073 .53476 .6753 .5219 .65844 Metetra
0 0 .446 r
.5219 .65844 .53476 .6753 .55898 .7061 .54609 .68952 Metetra
0 .3 .795 r
.54609 .68952 .55898 .7061 .58369 .72276 .57085 .70758 Metetra
.584 .696 .919 r
.57085 .70758 .58369 .72276 .60842 .71768 .59575 .70472 Metetra
.83 .787 .812 r
.59575 .70472 .60842 .71768 .63272 .69016 .62033 .67947 Metetra
.902 .802 .74 r
.62033 .67947 .63272 .69016 .65634 .64682 .64429 .63766 Metetra
.925 .811 .713 r
.64429 .63766 .65634 .64682 .6794 .59793 .66769 .58916 Metetra
.926 .82 .721 r
.66769 .58916 .6794 .59793 .70226 .5526 .69083 .54322 Metetra
.908 .828 .755 r
.69083 .54322 .70226 .5526 .72529 .51595 .71408 .50542 Metetra
.868 .828 .805 r
.71408 .50542 .72529 .51595 .74875 .48896 .7377 .47719 Metetra
.81 .813 .853 r
.7377 .47719 .74875 .48896 .77273 .47 .76183 .45717 Metetra
.751 .789 .884 r
.76183 .45717 .77273 .47 .79721 .45647 .78644 .4429 Metetra
.707 .767 .899 r
.78644 .4429 .79721 .45647 .82211 .44608 .81147 .43202 Metetra
.682 .753 .905 r
.81147 .43202 .82211 .44608 .84734 .43722 .83685 .42286 Metetra
.671 .746 .907 r
.83685 .42286 .84734 .43722 .87285 .429 .86252 .41444 Metetra
.666 .743 .908 r
.86252 .41444 .87285 .429 .89861 .42099 .88844 .40626 Metetra
.664 .742 .908 r
.88844 .40626 .89861 .42099 .92461 .413 .91461 .39813 Metetra
.664 .741 .908 r
.91461 .39813 .92461 .413 .95085 .40496 .94101 .38996 Metetra
.624 .73 .923 r
.35285 .55641 .36619 .56889 .38782 .56442 .37458 .55175 Metetra
.565 .709 .938 r
.37458 .55175 .38782 .56442 .40956 .56265 .39642 .54963 Metetra
.431 .649 .95 r
.39642 .54963 .40956 .56265 .43141 .56568 .41836 .55209 Metetra
.144 .483 .9 r
.41836 .55209 .43141 .56568 .45342 .57604 .44043 .56157 Metetra
0 .18 .691 r
.44043 .56157 .45342 .57604 .4757 .59571 .46274 .58004 Metetra
.545 .077 0 r
.46274 .58004 .4757 .59571 .49847 .62448 .48548 .60754 Metetra
.625 .168 0 r
.48548 .60754 .49847 .62448 .5219 .65844 .50887 .6406 Metetra
0 0 .468 r
.50887 .6406 .5219 .65844 .54609 .68952 .53302 .67175 Metetra
0 .273 .777 r
.53302 .67175 .54609 .68952 .57085 .70758 .5578 .6912 Metetra
.537 .662 .917 r
.5578 .6912 .57085 .70758 .59575 .70472 .58286 .69083 Metetra
.809 .778 .824 r
.58286 .69083 .59575 .70472 .62033 .67947 .60771 .66835 Metetra
.895 .803 .749 r
.60771 .66835 .62033 .67947 .64429 .63766 .63203 .62861 Metetra
.925 .815 .718 r
.63203 .62861 .64429 .63766 .66769 .58916 .65579 .58091 Metetra
.93 .826 .721 r
.65579 .58091 .66769 .58916 .69083 .54322 .67924 .53453 Metetra
.916 .836 .752 r
.67924 .53453 .69083 .54322 .71408 .50542 .70272 .49552 Metetra
.879 .838 .801 r
.70272 .49552 .71408 .50542 .7377 .47719 .72651 .46585 Metetra
.822 .824 .85 r
.72651 .46585 .7377 .47719 .76183 .45717 .75076 .44456 Metetra
.761 .798 .883 r
.75076 .44456 .76183 .45717 .78644 .4429 .7755 .42935 Metetra
.714 .773 .899 r
.7755 .42935 .78644 .4429 .81147 .43202 .80067 .41786 Metetra
.686 .756 .905 r
.80067 .41786 .81147 .43202 .83685 .42286 .82619 .40832 Metetra
.672 .747 .907 r
.82619 .40832 .83685 .42286 .86252 .41444 .85202 .39965 Metetra
.667 .744 .908 r
.85202 .39965 .86252 .41444 .88844 .40626 .8781 .3913 Metetra
.664 .742 .908 r
.8781 .3913 .88844 .40626 .91461 .39813 .90444 .38301 Metetra
.664 .741 .908 r
.90444 .38301 .91461 .39813 .94101 .38996 .93102 .3747 Metetra
.626 .731 .923 r
.3393 .54376 .35285 .55641 .37458 .55175 .36113 .5389 Metetra
.571 .712 .937 r
.36113 .5389 .37458 .55175 .39642 .54963 .38308 .53646 Metetra
.448 .657 .95 r
.38308 .53646 .39642 .54963 .41836 .55209 .4051 .53832 Metetra
.188 .51 .913 r
.4051 .53832 .41836 .55209 .44043 .56157 .42725 .54684 Metetra
0 .231 .735 r
.42725 .54684 .44043 .56157 .46274 .58004 .44959 .56397 Metetra
0 0 .505 r
.44959 .56397 .46274 .58004 .48548 .60754 .47233 .58992 Metetra
.58 .13 0 r
.47233 .58992 .48548 .60754 .50887 .6406 .49568 .62173 Metetra
0 0 .498 r
.49568 .62173 .50887 .6406 .53302 .67175 .51977 .65262 Metetra
0 .251 .764 r
.51977 .65262 .53302 .67175 .5578 .6912 .54457 .67333 Metetra
.485 .621 .909 r
.54457 .67333 .5578 .6912 .58286 .69083 .56974 .67566 Metetra
.78 .762 .837 r
.56974 .67566 .58286 .69083 .60771 .66835 .59486 .65649 Metetra
.884 .8 .762 r
.59486 .65649 .60771 .66835 .63203 .62861 .61954 .61951 Metetra
.923 .818 .725 r
.61954 .61951 .63203 .62861 .65579 .58091 .64368 .57318 Metetra
.933 .833 .722 r
.64368 .57318 .65579 .58091 .67924 .53453 .66746 .52668 Metetra
.923 .846 .749 r
.66746 .52668 .67924 .53453 .70272 .49552 .69119 .48646 Metetra
.891 .85 .796 r
.69119 .48646 .70272 .49552 .72651 .46585 .71516 .45517 Metetra
.837 .837 .846 r
.71516 .45517 .72651 .46585 .75076 .44456 .73955 .43235 Metetra
.774 .81 .881 r
.73955 .43235 .75076 .44456 .7755 .42935 .76441 .41596 Metetra
.723 .782 .899 r
.76441 .41596 .7755 .42935 .80067 .41786 .7897 .40367 Metetra
.691 .761 .905 r
.7897 .40367 .80067 .41786 .82619 .40832 .81537 .39363 Metetra
.675 .75 .907 r
.81537 .39363 .82619 .40832 .85202 .39965 .84134 .38466 Metetra
.668 .745 .908 r
.84134 .38466 .85202 .39965 .8781 .3913 .86759 .3761 Metetra
.665 .742 .908 r
.86759 .3761 .8781 .3913 .90444 .38301 .8941 .36765 Metetra
.664 .742 .908 r
.8941 .36765 .90444 .38301 .93102 .3747 .92086 .35919 Metetra
.627 .731 .922 r
.32554 .53094 .3393 .54376 .36113 .5389 .34748 .5259 Metetra
.577 .714 .936 r
.34748 .5259 .36113 .5389 .38308 .53646 .36953 .52314 Metetra
.464 .666 .95 r
.36953 .52314 .38308 .53646 .4051 .53832 .39165 .52441 Metetra
.231 .537 .924 r
.39165 .52441 .4051 .53832 .42725 .54684 .41387 .53192 Metetra
0 .286 .777 r
.41387 .53192 .42725 .54684 .44959 .56397 .43627 .54754 Metetra
0 .032 .567 r
.43627 .54754 .44959 .56397 .47233 .58992 .45901 .57166 Metetra
0 0 .466 r
.45901 .57166 .47233 .58992 .49568 .62173 .48232 .60181 Metetra
0 0 .536 r
.48232 .60181 .49568 .62173 .51977 .65262 .50636 .63199 Metetra
0 .239 .756 r
.50636 .63199 .51977 .65262 .54457 .67333 .53114 .65369 Metetra
.432 .574 .895 r
.53114 .65369 .54457 .67333 .56974 .67566 .55641 .6588 Metetra
.742 .737 .847 r
.55641 .6588 .56974 .67566 .59486 .65649 .58176 .64346 Metetra
.867 .793 .776 r
.58176 .64346 .59486 .65649 .61954 .61951 .6068 .61002 Metetra
.917 .82 .735 r
.6068 .61002 .61954 .61951 .64368 .57318 .63134 .56586 Metetra
.935 .84 .726 r
.63134 .56586 .64368 .57318 .66746 .52668 .65548 .51975 Metetra
.93 .856 .747 r
.65548 .51975 .66746 .52668 .69119 .48646 .67949 .4785 Metetra
.903 .864 .79 r
.67949 .4785 .69119 .48646 .71516 .45517 .70366 .44545 Metetra
.854 .854 .841 r
.70366 .44545 .71516 .45517 .73955 .43235 .72819 .4208 Metetra
.791 .826 .88 r
.72819 .4208 .73955 .43235 .76441 .41596 .75316 .4029 Metetra
.736 .794 .899 r
.75316 .4029 .76441 .41596 .7897 .40367 .77858 .38957 Metetra
.699 .769 .906 r
.77858 .38957 .7897 .40367 .81537 .39363 .80437 .37887 Metetra
.679 .754 .908 r
.80437 .37887 .81537 .39363 .84134 .38466 .8305 .36949 Metetra
.669 .746 .908 r
.8305 .36949 .84134 .38466 .86759 .3761 .85691 .36068 Metetra
.665 .743 .908 r
.85691 .36068 .86759 .3761 .8941 .36765 .88359 .35204 Metetra
.664 .742 .908 r
.88359 .35204 .8941 .36765 .92086 .35919 .91052 .34342 Metetra
.628 .732 .922 r
.31156 .51796 .32554 .53094 .34748 .5259 .33361 .51276 Metetra
.581 .717 .936 r
.33361 .51276 .34748 .5259 .36953 .52314 .35576 .5097 Metetra
.479 .673 .95 r
.35576 .5097 .36953 .52314 .39165 .52441 .37799 .51041 Metetra
.272 .562 .933 r
.37799 .51041 .39165 .52441 .41387 .53192 .4003 .51687 Metetra
0 .342 .817 r
.4003 .51687 .41387 .53192 .43627 .54754 .42276 .53085 Metetra
0 .102 .633 r
.42276 .53085 .43627 .54754 .45901 .57166 .44553 .55285 Metetra
0 0 .533 r
.44553 .55285 .45901 .57166 .48232 .60181 .46881 .58088 Metetra
0 .023 .583 r
.46881 .58088 .48232 .60181 .50636 .63199 .4928 .60981 Metetra
0 .239 .755 r
.4928 .60981 .50636 .63199 .53114 .65369 .51755 .63202 Metetra
.385 .528 .877 r
.51755 .63202 .53114 .65369 .55641 .6588 .54288 .63979 Metetra
.694 .703 .854 r
.54288 .63979 .55641 .6588 .58176 .64346 .56842 .62867 Metetra
.84 .779 .793 r
.56842 .62867 .58176 .64346 .6068 .61002 .59379 .59963 Metetra
.906 .818 .749 r
.59379 .59963 .6068 .61002 .63134 .56586 .61875 .55863 Metetra
.933 .845 .733 r
.61875 .55863 .63134 .56586 .65548 .51975 .64329 .51371 Metetra
.936 .866 .746 r
.64329 .51371 .65548 .51975 .67949 .4785 .66762 .47182 Metetra
.916 .879 .784 r
.66762 .47182 .67949 .4785 .70366 .44545 .69201 .43701 Metetra
.872 .874 .835 r
.69201 .43701 .70366 .44545 .72819 .4208 .71669 .41026 Metetra
.812 .848 .877 r
.71669 .41026 .72819 .4208 .75316 .4029 .74178 .39049 Metetra
.753 .812 .899 r
.74178 .39049 .75316 .4029 .77858 .38957 .7673 .37576 Metetra
.71 .781 .907 r
.7673 .37576 .77858 .38957 .80437 .37887 .79322 .36414 Metetra
.685 .76 .909 r
.79322 .36414 .80437 .37887 .8305 .36949 .81948 .35421 Metetra
.672 .75 .909 r
.81948 .35421 .8305 .36949 .85691 .36068 .84605 .34505 Metetra
.667 .744 .908 r
.84605 .34505 .85691 .36068 .88359 .35204 .8729 .33619 Metetra
.665 .742 .908 r
.8729 .33619 .88359 .35204 .91052 .34342 .90001 .32739 Metetra
.629 .733 .923 r
.29737 .50482 .31156 .51796 .33361 .51276 .31953 .4995 Metetra
.584 .719 .936 r
.31953 .4995 .33361 .51276 .35576 .5097 .34178 .49619 Metetra
.491 .681 .95 r
.34178 .49619 .35576 .5097 .37799 .51041 .36411 .49636 Metetra
.31 .585 .94 r
.36411 .49636 .37799 .51041 .4003 .51687 .38652 .50177 Metetra
.027 .398 .853 r
.38652 .50177 .4003 .51687 .42276 .53085 .40906 .51402 Metetra
0 .18 .701 r
.40906 .51402 .42276 .53085 .44553 .55285 .43187 .53363 Metetra
0 .058 .607 r
.43187 .53363 .44553 .55285 .46881 .58088 .45515 .55907 Metetra
0 .082 .638 r
.45515 .55907 .46881 .58088 .4928 .60981 .4791 .5861 Metetra
0 .253 .762 r
.4791 .5861 .4928 .60981 .51755 .63202 .5038 .60816 Metetra
.35 .487 .856 r
.5038 .60816 .51755 .63202 .54288 .63979 .52915 .61821 Metetra
.639 .658 .853 r
.52915 .61821 .54288 .63979 .56842 .62867 .55485 .61146 Metetra
.802 .753 .808 r
.55485 .61146 .56842 .62867 .59379 .59963 .58052 .58758 Metetra
.886 .809 .768 r
.58052 .58758 .59379 .59963 .61875 .55863 .60588 .55088 Metetra
.926 .847 .746 r
.60588 .55088 .61875 .55863 .64329 .51371 .63085 .50827 Metetra
.938 .875 .749 r
.63085 .50827 .64329 .51371 .66762 .47182 .65554 .46651 Metetra
.926 .894 .778 r
.65554 .46651 .66762 .47182 .69201 .43701 .6802 .4302 Metetra
.891 .896 .825 r
.6802 .4302 .69201 .43701 .71669 .41026 .70506 .40119 Metetra
.836 .875 .871 r
.70506 .40119 .71669 .41026 .74178 .39049 .73026 .37916 Metetra
.776 .837 .899 r
.73026 .37916 .74178 .39049 .7673 .37576 .75588 .36259 Metetra
.726 .799 .91 r
.75588 .36259 .7673 .37576 .79322 .36414 .78191 .34969 Metetra
.694 .772 .911 r
.78191 .34969 .79322 .36414 .81948 .35421 .8083 .33894 Metetra
.677 .755 .91 r
.8083 .33894 .81948 .35421 .84605 .34505 .83502 .32929 Metetra
.669 .747 .909 r
.83502 .32929 .84605 .34505 .8729 .33619 .86203 .32012 Metetra
.666 .744 .908 r
.86203 .32012 .8729 .33619 .90001 .32739 .88932 .3111 Metetra
.628 .734 .924 r
.28295 .49154 .29737 .50482 .31953 .4995 .30521 .48614 Metetra
.586 .721 .937 r
.30521 .48614 .31953 .4995 .34178 .49619 .32757 .48263 Metetra
.502 .688 .951 r
.32757 .48263 .34178 .49619 .36411 .49636 .35 .48231 Metetra
.344 .607 .947 r
.35 .48231 .36411 .49636 .38652 .50177 .37251 .48669 Metetra
.104 .452 .884 r
.37251 .48669 .38652 .50177 .40906 .51402 .39515 .49714 Metetra
0 .263 .766 r
.39515 .49714 .40906 .51402 .43187 .53363 .41803 .51415 Metetra
0 .146 .684 r
.41803 .51415 .43187 .53363 .45515 .55907 .44134 .53658 Metetra
0 .155 .696 r
.44134 .53658 .45515 .55907 .4791 .5861 .46527 .56104 Metetra
.039 .28 .774 r
.46527 .56104 .4791 .5861 .5038 .60816 .48992 .58214 Metetra
.332 .457 .837 r
.48992 .58214 .5038 .60816 .52915 .61821 .51525 .59377 Metetra
.583 .609 .844 r
.51525 .59377 .52915 .61821 .55485 .61146 .54105 .59117 Metetra
.751 .715 .818 r
.54105 .59117 .55485 .61146 .58052 .58758 .56697 .57294 Metetra
.853 .788 .787 r
.56697 .57294 .58052 .58758 .60588 .55088 .59271 .54166 Metetra
.91 .841 .764 r
.59271 .54166 .60588 .55088 .63085 .50827 .61812 .50274 Metetra
.934 .88 .758 r
.61812 .50274 .63085 .50827 .65554 .46651 .64323 .4623 Metetra
.932 .907 .775 r
.64323 .4623 .65554 .46651 .6802 .4302 .66822 .42518 Metetra
.907 .918 .815 r
.66822 .42518 .6802 .4302 .70506 .40119 .69329 .39405 Metetra
.862 .906 .862 r
.69329 .39405 .70506 .40119 .73026 .37916 .71864 .36947 Metetra
.804 .871 .897 r
.71864 .36947 .73026 .37916 .75588 .36259 .74435 .35058 Metetra
.749 .828 .912 r
.74435 .35058 .75588 .36259 .78191 .34969 .77047 .3359 Metetra
.71 .791 .915 r
.77047 .3359 .78191 .34969 .8083 .33894 .79697 .32394 Metetra
.686 .767 .913 r
.79697 .32394 .8083 .33894 .83502 .32929 .82382 .31353 Metetra
.673 .753 .911 r
.82382 .31353 .83502 .32929 .86203 .32012 .85099 .3039 Metetra
.668 .746 .909 r
.85099 .3039 .86203 .32012 .88932 .3111 .87845 .29459 Metetra
.626 .735 .925 r
.26829 .47815 .28295 .49154 .30521 .48614 .29065 .47271 Metetra
.586 .724 .938 r
.29065 .47271 .30521 .48614 .32757 .48263 .31311 .46907 Metetra
.51 .695 .952 r
.31311 .46907 .32757 .48263 .35 .48231 .33566 .46831 Metetra
.374 .628 .952 r
.33566 .46831 .35 .48231 .37251 .48669 .35828 .47169 Metetra
.177 .502 .909 r
.35828 .47169 .37251 .48669 .39515 .49714 .38103 .48031 Metetra
0 .348 .824 r
.38103 .48031 .39515 .49714 .41803 .51415 .40401 .49459 Metetra
0 .243 .758 r
.40401 .49459 .41803 .51415 .44134 .53658 .42738 .51366 Metetra
0 .236 .753 r
.42738 .51366 .44134 .53658 .46527 .56104 .45131 .53494 Metetra
.11 .318 .791 r
.45131 .53494 .46527 .56104 .48992 .58214 .47592 .55421 Metetra
.333 .443 .823 r
.47592 .55421 .48992 .58214 .51525 .59377 .50122 .56645 Metetra
.536 .564 .831 r
.50122 .56645 .51525 .59377 .54105 .59117 .52705 .56733 Metetra
.693 .667 .82 r
.52705 .56733 .54105 .59117 .56697 .57294 .55316 .55475 Metetra
.805 .751 .803 r
.55316 .55475 .56697 .57294 .59271 .54166 .57923 .52972 Metetra
.879 .821 .787 r
.57923 .52972 .59271 .54166 .61812 .50274 .60508 .49594 Metetra
.92 .876 .776 r
.60508 .49594 .61812 .50274 .64323 .4623 .63064 .45839 Metetra
.93 .914 .78 r
.63064 .45839 .64323 .4623 .66822 .42518 .65602 .42171 Metetra
.916 .936 .806 r
.65602 .42171 .66822 .42518 .69329 .39405 .68138 .38911 Metetra
.882 .936 .849 r
.68138 .38911 .69329 .39405 .71864 .36947 .7069 .36204 Metetra
.833 .912 .89 r
.7069 .36204 .71864 .36947 .74435 .35058 .73273 .34045 Metetra
.779 .868 .914 r
.73273 .34045 .74435 .35058 .77047 .3359 .75893 .32343 Metetra
.733 .823 .92 r
.75893 .32343 .77047 .3359 .79697 .32394 .78552 .3097 Metetra
.701 .788 .918 r
.78552 .3097 .79697 .32394 .82382 .31353 .81248 .2981 Metetra
.682 .765 .914 r
.81248 .2981 .82382 .31353 .85099 .3039 .83978 .28771 Metetra
.672 .753 .911 r
.83978 .28771 .85099 .3039 .87845 .29459 .8674 .27793 Metetra
.623 .736 .928 r
.25339 .46467 .26829 .47815 .29065 .47271 .27585 .45926 Metetra
.585 .726 .941 r
.27585 .45926 .29065 .47271 .31311 .46907 .29841 .45553 Metetra
.516 .701 .954 r
.29841 .45553 .31311 .46907 .33566 .46831 .32106 .45438 Metetra
.402 .646 .956 r
.32106 .45438 .33566 .46831 .35828 .47169 .34381 .45679 Metetra
.247 .549 .929 r
.34381 .45679 .35828 .47169 .38103 .48031 .36669 .46358 Metetra
.097 .429 .872 r
.36669 .46358 .38103 .48031 .40401 .49459 .38979 .47507 Metetra
.024 .341 .821 r
.38979 .47507 .40401 .49459 .42738 .51366 .41326 .49058 Metetra
.062 .321 .803 r
.41326 .49058 .42738 .51366 .45131 .53494 .43723 .50822 Metetra
.188 .365 .809 r
.43723 .50822 .45131 .53494 .47592 .55421 .46182 .52487 Metetra
.35 .443 .816 r
.46182 .52487 .47592 .55421 .50122 .56645 .48708 .53665 Metetra
.504 .53 .817 r
.48708 .53665 .50122 .56645 .52705 .56733 .51291 .53991 Metetra
.636 .617 .814 r
.51291 .53991 .52705 .56733 .55316 .55475 .53911 .53234 Metetra
.745 .701 .81 r
.53911 .53234 .55316 .55475 .57923 .52972 .56544 .51377 Metetra
.831 .782 .806 r
.56544 .51377 .57923 .52972 .60508 .49594 .59168 .48625 Metetra
.89 .854 .8 r
.59168 .48625 .60508 .49594 .63064 .45839 .61771 .45328 Metetra
.917 .909 .798 r
.61771 .45328 .63064 .45839 .65602 .42171 .64354 .41879 Metetra
.915 .944 .807 r
.64354 .41879 .65602 .42171 .68138 .38911 .66927 .38606 Metetra
.892 .958 .834 r
.66927 .38606 .68138 .38911 .7069 .36204 .69505 .35717 Metetra
.856 .949 .875 r
.69505 .35717 .7069 .36204 .73273 .34045 .72104 .33292 Metetra
.811 .917 .909 r
.72104 .33292 .73273 .34045 .75893 .32343 .74734 .31314 Metetra
.765 .87 .925 r
.74734 .31314 .75893 .32343 .78552 .3097 .774 .29704 Metetra
.726 .824 .926 r
.774 .29704 .78552 .3097 .81248 .2981 .80104 .28363 Metetra
.698 .79 .921 r
.80104 .28363 .81248 .2981 .83978 .28771 .82845 .27199 Metetra
.682 .767 .916 r
.82845 .27199 .83978 .28771 .8674 .27793 .8562 .2614 Metetra
.619 .738 .931 r
.23823 .45117 .25339 .46467 .27585 .45926 .26078 .44582 Metetra
.582 .729 .944 r
.26078 .44582 .27585 .45926 .29841 .45553 .28344 .44204 Metetra
.521 .708 .956 r
.28344 .44204 .29841 .45553 .32106 .45438 .3062 .44051 Metetra
.429 .664 .959 r
.3062 .44051 .32106 .45438 .34381 .45679 .32908 .44195 Metetra
.312 .59 .943 r
.32908 .44195 .34381 .45679 .36669 .46358 .35211 .44695 Metetra
.205 .502 .906 r
.35211 .44695 .36669 .46358 .38979 .47507 .37536 .45565 Metetra
.155 .43 .868 r
.37536 .45565 .38979 .47507 .41326 .49058 .39895 .46757 Metetra
.182 .402 .841 r
.39895 .46757 .41326 .49058 .43723 .50822 .423 .48135 Metetra
.268 .416 .825 r
.423 .48135 .43723 .50822 .46182 .52487 .44762 .49479 Metetra
.379 .456 .814 r
.44762 .49479 .46182 .52487 .48708 .53665 .47284 .50508 Metetra
.49 .512 .807 r
.47284 .50508 .48708 .53665 .51291 .53991 .49864 .50941 Metetra
.591 .575 .804 r
.49864 .50941 .51291 .53991 .53911 .53234 .52489 .50565 Metetra
.684 .647 .807 r
.52489 .50565 .53911 .53234 .56544 .51377 .55138 .49295 Metetra
.768 .726 .813 r
.55138 .49295 .56544 .51377 .59168 .48625 .57793 .47204 Metetra
.839 .808 .82 r
.57793 .47204 .59168 .48625 .61771 .45328 .60439 .44497 Metetra
.886 .882 .823 r
.60439 .44497 .61771 .45328 .64354 .41879 .63069 .41455 Metetra
.902 .936 .824 r
.63069 .41455 .64354 .41879 .66927 .38606 .65687 .38358 Metetra
.891 .965 .833 r
.65687 .38358 .66927 .38606 .69505 .35717 .68301 .35433 Metetra
.865 .973 .857 r
.68301 .35433 .69505 .35717 .72104 .33292 .70925 .32823 Metetra
.832 .96 .893 r
.70925 .32823 .72104 .33292 .74734 .31314 .7357 .30582 Metetra
.795 .925 .922 r
.7357 .30582 .74734 .31314 .774 .29704 .76246 .28697 Metetra
.757 .879 .934 r
.76246 .28697 .774 .29704 .80104 .28363 .78957 .27113 Metetra
.724 .833 .933 r
.78957 .27113 .80104 .28363 .82845 .27199 .81706 .25757 Metetra
.7 .798 .926 r
.81706 .25757 .82845 .27199 .8562 .2614 .84491 .24558 Metetra
.614 .74 .935 r
.22279 .43767 .23823 .45117 .26078 .44582 .24544 .43242 Metetra
.58 .732 .947 r
.24544 .43242 .26078 .44582 .28344 .44204 .2682 .42858 Metetra
.528 .715 .958 r
.2682 .42858 .28344 .44204 .3062 .44051 .29108 .42664 Metetra
.456 .68 .961 r
.29108 .42664 .3062 .44051 .32908 .44195 .3141 .42711 Metetra
.374 .626 .951 r
.3141 .42711 .32908 .44195 .35211 .44695 .33729 .43033 Metetra
.303 .562 .928 r
.33729 .43033 .35211 .44695 .37536 .45565 .36071 .43635 Metetra
.272 .506 .897 r
.36071 .43635 .37536 .45565 .39895 .46757 .38446 .4448 Metetra
.289 .473 .867 r
.38446 .4448 .39895 .46757 .423 .48135 .40862 .45473 Metetra
.344 .466 .84 r
.40862 .45473 .423 .48135 .44762 .49479 .43329 .46467 Metetra
.415 .479 .818 r
.43329 .46467 .44762 .49479 .47284 .50508 .45851 .47271 Metetra
.49 .508 .803 r
.45851 .47271 .47284 .50508 .49864 .50941 .48428 .47685 Metetra
.563 .549 .797 r
.48428 .47685 .49864 .50941 .52489 .50565 .51052 .47537 Metetra
.635 .602 .799 r
.51052 .47537 .52489 .50565 .55138 .49295 .5371 .46722 Metetra
.705 .666 .809 r
.5371 .46722 .55138 .49295 .57793 .47204 .56387 .45233 Metetra
.773 .742 .825 r
.56387 .45233 .57793 .47204 .60439 .44497 .59067 .43157 Metetra
.832 .824 .841 r
.59067 .43157 .60439 .44497 .63069 .41455 .61742 .40656 Metetra
.87 .898 .85 r
.61742 .40656 .63069 .41455 .65687 .38358 .64407 .3793 Metetra
.878 .951 .853 r
.64407 .3793 .65687 .38358 .68301 .35433 .67066 .35173 Metetra
.862 .976 .857 r
.67066 .35173 .68301 .35433 .70925 .32823 .69727 .32542 Metetra
.836 .981 .875 r
.69727 .32542 .70925 .32823 .7357 .30582 .72399 .3014 Metetra
.81 .968 .904 r
.72399 .3014 .7357 .30582 .76246 .28697 .75092 .28015 Metetra
.783 .938 .93 r
.75092 .28015 .76246 .28697 .78957 .27113 .77814 .26167 Metetra
.754 .895 .941 r
.77814 .26167 .78957 .27113 .81706 .25757 .80569 .24564 Metetra
.726 .851 .94 r
.80569 .24564 .81706 .25757 .84491 .24558 .83361 .23159 Metetra
.609 .743 .94 r
.20707 .42423 .22279 .43767 .24544 .43242 .22981 .41904 Metetra
.579 .736 .95 r
.22981 .41904 .24544 .43242 .2682 .42858 .25268 .41508 Metetra
.537 .721 .958 r
.25268 .41508 .2682 .42858 .29108 .42664 .27569 .41267 Metetra
.485 .694 .961 r
.27569 .41267 .29108 .42664 .3141 .42711 .29886 .41212 Metetra
.43 .655 .954 r
.29886 .41212 .3141 .42711 .33729 .43033 .32223 .4136 Metetra
.388 .609 .937 r
.32223 .4136 .33729 .43033 .36071 .43635 .34583 .4171 Metetra
.369 .564 .912 r
.34583 .4171 .36071 .43635 .38446 .4448 .36975 .42232 Metetra
.379 .531 .881 r
.36975 .42232 .38446 .4448 .40862 .45473 .39406 .42864 Metetra
.411 .512 .851 r
.39406 .42864 .40862 .45473 .43329 .46467 .41882 .43509 Metetra
.455 .508 .824 r
.41882 .43509 .43329 .46467 .45851 .47271 .44407 .44047 Metetra
.502 .517 .805 r
.44407 .44047 .45851 .47271 .48428 .47685 .46983 .44345 Metetra
.552 .539 .794 r
.46983 .44345 .48428 .47685 .51052 .47537 .49605 .44277 Metetra
.602 .572 .793 r
.49605 .44277 .51052 .47537 .5371 .46722 .52266 .43752 Metetra
.654 .618 .801 r
.52266 .43752 .5371 .46722 .56387 .45233 .54954 .42725 Metetra
.708 .676 .817 r
.54954 .42725 .56387 .45233 .59067 .43157 .57659 .41213 Metetra
.763 .747 .838 r
.57659 .41213 .59067 .43157 .61742 .40656 .6037 .39285 Metetra
.812 .825 .861 r
.6037 .39285 .61742 .40656 .64407 .3793 .6308 .37054 Metetra
.844 .898 .876 r
.6308 .37054 .64407 .3793 .67066 .35173 .65787 .34651 Metetra
.849 .951 .881 r
.65787 .34651 .67066 .35173 .69727 .32542 .68494 .32206 Metetra
.833 .977 .882 r
.68494 .32206 .69727 .32542 .72399 .3014 .71205 .29827 Metetra
.81 .982 .891 r
.71205 .29827 .72399 .3014 .75092 .28015 .73928 .27594 Metetra
.789 .974 .912 r
.73928 .27594 .75092 .28015 .77814 .26167 .76671 .25552 Metetra
.771 .952 .934 r
.76671 .25552 .77814 .26167 .80569 .24564 .7944 .23713 Metetra
.751 .917 .947 r
.7944 .23713 .80569 .24564 .83361 .23159 .8224 .22068 Metetra
.606 .746 .943 r
.19106 .4108 .20707 .42423 .22981 .41904 .2139 .40562 Metetra
.58 .739 .951 r
.2139 .40562 .22981 .41904 .25268 .41508 .23689 .40143 Metetra
.549 .727 .957 r
.23689 .40143 .25268 .41508 .27569 .41267 .26004 .39845 Metetra
.514 .706 .958 r
.26004 .39845 .27569 .41267 .29886 .41212 .28337 .39682 Metetra
.481 .677 .952 r
.28337 .39682 .29886 .41212 .32223 .4136 .30692 .39663 Metetra
.456 .643 .937 r
.30692 .39663 .32223 .4136 .34583 .4171 .33073 .39781 Metetra
.446 .607 .915 r
.33073 .39781 .34583 .4171 .36975 .42232 .35483 .40014 Metetra
.451 .575 .888 r
.35483 .40014 .36975 .42232 .39406 .42864 .3793 .40323 Metetra
.468 .552 .859 r
.3793 .40323 .39406 .42864 .41882 .43509 .40418 .40647 Metetra
.493 .538 .832 r
.40418 .40647 .41882 .43509 .44407 .44047 .42949 .40911 Metetra
.521 .535 .811 r
.42949 .40911 .44407 .44047 .46983 .44345 .45526 .41034 Metetra
.552 .543 .798 r
.45526 .41034 .46983 .44345 .49605 .44277 .48147 .40933 Metetra
.585 .56 .792 r
.48147 .40933 .49605 .44277 .52266 .43752 .50808 .40539 Metetra
.621 .588 .795 r
.50808 .40539 .52266 .43752 .54954 .42725 .53502 .39804 Metetra
.659 .627 .806 r
.53502 .39804 .54954 .42725 .57659 .41213 .56222 .38712 Metetra
.701 .678 .824 r
.56222 .38712 .57659 .41213 .6037 .39285 .58958 .37278 Metetra
.743 .74 .849 r
.58958 .37278 .6037 .39285 .6308 .37054 .61704 .35549 Metetra
.783 .811 .875 r
.61704 .35549 .6308 .37054 .65787 .34651 .64456 .33594 Metetra
.811 .88 .896 r
.64456 .33594 .65787 .34651 .68494 .32206 .6721 .31494 Metetra
.819 .934 .907 r
.6721 .31494 .68494 .32206 .71205 .29827 .69968 .29333 Metetra
.808 .965 .908 r
.69968 .29333 .71205 .29827 .73928 .27594 .72734 .27184 Metetra
.788 .976 .91 r
.72734 .27184 .73928 .27594 .76671 .25552 .75512 .25108 Metetra
.77 .973 .92 r
.75512 .25108 .76671 .25552 .7944 .23713 .78308 .23144 Metetra
.756 .96 .935 r
.78308 .23144 .7944 .23713 .8224 .22068 .81128 .21317 Metetra
.605 .748 .945 r
.17475 .3973 .19106 .4108 .2139 .40562 .1977 .392 Metetra
.586 .742 .95 r
.1977 .392 .2139 .40562 .23689 .40143 .22082 .38746 Metetra
.564 .731 .953 r
.22082 .38746 .23689 .40143 .26004 .39845 .24413 .38379 Metetra
.543 .714 .952 r
.24413 .38379 .26004 .39845 .28337 .39682 .26764 .38107 Metetra
.523 .692 .945 r
.26764 .38107 .28337 .39682 .30692 .39663 .29138 .37929 Metetra
.51 .665 .932 r
.29138 .37929 .30692 .39663 .33073 .39781 .31538 .3784 Metetra
.504 .637 .913 r
.31538 .3784 .33073 .39781 .35483 .40014 .33969 .37824 Metetra
.506 .609 .889 r
.33969 .37824 .35483 .40014 .3793 .40323 .36432 .37855 Metetra
.514 .585 .864 r
.36432 .37855 .3793 .40323 .40418 .40647 .38933 .37897 Metetra
.527 .568 .84 r
.38933 .37897 .40418 .40647 .42949 .40911 .41474 .37907 Metetra
.543 .558 .82 r
.41474 .37907 .42949 .40911 .45526 .41034 .44056 .37835 Metetra
.561 .556 .806 r
.44056 .37835 .45526 .41034 .48147 .40933 .46678 .37631 Metetra
.582 .562 .797 r
.46678 .37631 .48147 .40933 .50808 .40539 .49339 .37249 Metetra
.604 .576 .795 r
.49339 .37249 .50808 .40539 .53502 .39804 .52036 .36652 Metetra
.629 .599 .8 r
.52036 .36652 .53502 .39804 .56222 .38712 .54763 .35815 Metetra
.657 .631 .812 r
.54763 .35815 .56222 .38712 .58958 .37278 .57515 .34731 Metetra
.688 .673 .83 r
.57515 .34731 .58958 .37278 .61704 .35549 .60287 .3341 Metetra
.72 .724 .853 r
.60287 .3341 .61704 .35549 .64456 .33594 .63072 .31878 Metetra
.75 .783 .88 r
.63072 .31878 .64456 .33594 .6721 .31494 .65868 .30174 Metetra
.775 .844 .904 r
.65868 .30174 .6721 .31494 .69968 .29333 .68673 .28344 Metetra
.787 .898 .922 r
.68673 .28344 .69968 .29333 .72734 .27184 .71487 .26438 Metetra
.784 .937 .929 r
.71487 .26438 .72734 .27184 .75512 .25108 .74311 .24506 Metetra
.771 .957 .931 r
.74311 .24506 .75512 .25108 .78308 .23144 .77149 .2259 Metetra
.755 .964 .933 r
.77149 .2259 .78308 .23144 .81128 .21317 .80003 .20724 Metetra
.608 .749 .944 r
.15815 .38358 .17475 .3973 .1977 .392 .18122 .37801 Metetra
.595 .743 .947 r
.18122 .37801 .1977 .392 .22082 .38746 .20449 .37299 Metetra
.581 .733 .947 r
.20449 .37299 .22082 .38746 .24413 .38379 .22797 .36856 Metetra
.569 .719 .944 r
.22797 .36856 .24413 .38379 .26764 .38107 .25166 .36474 Metetra
.558 .701 .936 r
.25166 .36474 .26764 .38107 .29138 .37929 .2756 .36152 Metetra
.551 .68 .924 r
.2756 .36152 .29138 .37929 .31538 .3784 .2998 .35882 Metetra
.547 .657 .908 r
.2998 .35882 .31538 .3784 .33969 .37824 .3243 .35656 Metetra
.547 .634 .889 r
.3243 .35656 .33969 .37824 .36432 .37855 .34911 .35456 Metetra
.55 .613 .868 r
.34911 .35456 .36432 .37855 .38933 .37897 .37427 .35262 Metetra
.556 .595 .848 r
.37427 .35262 .38933 .37897 .41474 .37907 .39978 .35049 Metetra
.564 .583 .83 r
.39978 .35049 .41474 .37907 .44056 .37835 .42567 .34789 Metetra
.574 .575 .816 r
.42567 .34789 .44056 .37835 .46678 .37631 .45194 .34453 Metetra
.586 .574 .806 r
.45194 .34453 .46678 .37631 .49339 .37249 .47858 .34012 Metetra
.6 .579 .801 r
.47858 .34012 .49339 .37249 .52036 .36652 .50557 .33441 Metetra
.615 .59 .801 r
.50557 .33441 .52036 .36652 .54763 .35815 .53289 .3272 Metetra
.633 .607 .807 r
.53289 .3272 .54763 .35815 .57515 .34731 .5605 .31836 Metetra
.652 .632 .817 r
.5605 .31836 .57515 .34731 .60287 .3341 .58837 .30785 Metetra
.674 .664 .833 r
.58837 .30785 .60287 .3341 .63072 .31878 .61646 .2957 Metetra
.697 .704 .853 r
.61646 .2957 .63072 .31878 .65868 .30174 .64474 .28204 Metetra
.719 .75 .876 r
.64474 .28204 .65868 .30174 .68673 .28344 .67317 .26708 Metetra
.739 .8 .901 r
.67317 .26708 .68673 .28344 .71487 .26438 .70175 .25105 Metetra
.753 .849 .922 r
.70175 .25105 .71487 .26438 .74311 .24506 .73046 .23424 Metetra
.759 .89 .937 r
.73046 .23424 .74311 .24506 .77149 .2259 .75932 .21694 Metetra
.755 .921 .945 r
.75932 .21694 .77149 .2259 .80003 .20724 .78832 .19943 Metetra
.614 .748 .941 r
.14127 .36943 .15815 .38358 .18122 .37801 .16449 .36349 Metetra
.606 .742 .941 r
.16449 .36349 .18122 .37801 .20449 .37299 .18792 .35789 Metetra
.598 .733 .939 r
.18792 .35789 .20449 .37299 .22797 .36856 .21156 .35267 Metetra
.591 .721 .934 r
.21156 .35267 .22797 .36856 .25166 .36474 .23545 .34781 Metetra
.585 .706 .927 r
.23545 .34781 .25166 .36474 .2756 .36152 .25958 .34329 Metetra
.581 .69 .916 r
.25958 .34329 .2756 .36152 .2998 .35882 .28398 .33906 Metetra
.578 .671 .903 r
.28398 .33906 .2998 .35882 .3243 .35656 .30866 .33506 Metetra
.577 .653 .888 r
.30866 .33506 .3243 .35656 .34911 .35456 .33365 .33119 Metetra
.578 .635 .871 r
.33365 .33119 .34911 .35456 .37427 .35262 .35895 .32733 Metetra
.58 .619 .855 r
.35895 .32733 .37427 .35262 .39978 .35049 .3846 .32335 Metetra
.584 .606 .841 r
.3846 .32335 .39978 .35049 .42567 .34789 .41058 .31908 Metetra
.589 .597 .828 r
.41058 .31908 .42567 .34789 .45194 .34453 .43692 .31436 Metetra
.595 .592 .818 r
.43692 .31436 .45194 .34453 .47858 .34012 .4636 .30903 Metetra
.603 .591 .812 r
.4636 .30903 .47858 .34012 .50557 .33441 .49063 .30294 Metetra
.612 .594 .809 r
.49063 .30294 .50557 .33441 .53289 .3272 .518 .29593 Metetra
.622 .602 .809 r
.518 .29593 .53289 .3272 .5605 .31836 .54567 .28792 Metetra
.634 .615 .814 r
.54567 .28792 .5605 .31836 .58837 .30785 .57365 .27882 Metetra
.647 .633 .822 r
.57365 .27882 .58837 .30785 .61646 .2957 .60189 .26859 Metetra
.662 .657 .834 r
.60189 .26859 .61646 .2957 .64474 .28204 .63038 .25725 Metetra
.678 .685 .85 r
.63038 .25725 .64474 .28204 .67317 .26708 .6591 .24483 Metetra
.694 .719 .869 r
.6591 .24483 .67317 .26708 .70175 .25105 .68802 .23144 Metetra
.709 .756 .889 r
.68802 .23144 .70175 .25105 .73046 .23424 .71713 .21719 Metetra
.722 .795 .91 r
.71713 .21719 .73046 .23424 .75932 .21694 .74643 .20222 Metetra
.731 .833 .928 r
.74643 .20222 .75932 .21694 .78832 .19943 .7759 .18669 Metetra
.622 .746 .935 r
.12413 .35471 .14127 .36943 .16449 .36349 .14751 .3483 Metetra
.617 .739 .933 r
.14751 .3483 .16449 .36349 .18792 .35789 .1711 .34208 Metetra
.612 .731 .93 r
.1711 .34208 .18792 .35789 .21156 .35267 .19492 .33607 Metetra
.608 .721 .925 r
.19492 .33607 .21156 .35267 .23545 .34781 .21899 .33026 Metetra
.605 .709 .918 r
.21899 .33026 .23545 .34781 .25958 .34329 .24331 .32462 Metetra
.602 .696 .909 r
.24331 .32462 .25958 .34329 .28398 .33906 .26789 .31912 Metetra
.601 .682 .899 r
.26789 .31912 .28398 .33906 .30866 .33506 .29276 .31372 Metetra
.6 .667 .887 r
.29276 .31372 .30866 .33506 .33365 .33119 .31792 .30836 Metetra
.599 .653 .874 r
.31792 .30836 .33365 .33119 .35895 .32733 .34338 .30297 Metetra
.6 .64 .862 r
.34338 .30297 .35895 .32733 .3846 .32335 .36916 .29748 Metetra
.601 .628 .85 r
.36916 .29748 .3846 .32335 .41058 .31908 .39526 .2918 Metetra
.603 .619 .84 r
.39526 .2918 .41058 .31908 .43692 .31436 .42168 .28585 Metetra
.606 .612 .831 r
.42168 .28585 .43692 .31436 .4636 .30903 .44844 .27953 Metetra
.61 .608 .824 r
.44844 .27953 .4636 .30903 .49063 .30294 .47553 .27275 Metetra
.615 .607 .819 r
.47553 .27275 .49063 .30294 .518 .29593 .50295 .26543 Metetra
.62 .609 .817 r
.50295 .26543 .518 .29593 .54567 .28792 .53069 .25749 Metetra
.627 .614 .818 r
.53069 .25749 .54567 .28792 .57365 .27882 .55874 .24887 Metetra
.635 .623 .821 r
.55874 .24887 .57365 .27882 .60189 .26859 .58709 .23953 Metetra
.644 .635 .827 r
.58709 .23953 .60189 .26859 .63038 .25725 .61573 .22943 Metetra
.653 .651 .836 r
.61573 .22943 .63038 .25725 .6591 .24483 .64464 .21857 Metetra
.664 .671 .847 r
.64464 .21857 .6591 .24483 .68802 .23144 .67381 .20697 Metetra
.674 .694 .86 r
.67381 .20697 .68802 .23144 .71713 .21719 .70322 .19465 Metetra
.685 .72 .876 r
.70322 .19465 .71713 .21719 .74643 .20222 .73287 .18166 Metetra
.696 .749 .893 r
.73287 .18166 .74643 .20222 .7759 .18669 .76274 .16806 Metetra
.63 .742 .928 r
.10674 .33931 .12413 .35471 .14751 .3483 .13028 .33239 Metetra
.627 .736 .926 r
.13028 .33239 .14751 .3483 .1711 .34208 .15404 .32556 Metetra
.624 .729 .922 r
.15404 .32556 .1711 .34208 .19492 .33607 .17804 .31882 Metetra
.622 .721 .917 r
.17804 .31882 .19492 .33607 .21899 .33026 .20228 .31216 Metetra
.62 .711 .911 r
.20228 .31216 .21899 .33026 .24331 .32462 .22678 .30557 Metetra
.618 .701 .904 r
.22678 .30557 .24331 .32462 .26789 .31912 .25155 .29903 Metetra
.617 .69 .895 r
.25155 .29903 .26789 .31912 .29276 .31372 .27659 .2925 Metetra
.616 .679 .887 r
.27659 .2925 .29276 .31372 .31792 .30836 .30191 .28596 Metetra
.615 .667 .877 r
.30191 .28596 .31792 .30836 .34338 .30297 .32753 .27937 Metetra
.615 .657 .868 r
.32753 .27937 .34338 .30297 .36916 .29748 .35345 .27268 Metetra
.615 .647 .859 r
.35345 .27268 .36916 .29748 .39526 .2918 .37967 .26585 Metetra
.616 .639 .85 r
.37967 .26585 .39526 .2918 .42168 .28585 .40621 .25884 Metetra
.617 .632 .843 r
.40621 .25884 .42168 .28585 .44844 .27953 .43306 .25159 Metetra
.619 .627 .837 r
.43306 .25159 .44844 .27953 .47553 .27275 .46024 .24405 Metetra
.621 .623 .832 r
.46024 .24405 .47553 .27275 .50295 .26543 .48773 .23617 Metetra
.624 .622 .828 r
.48773 .23617 .50295 .26543 .53069 .25749 .51554 .22791 Metetra
.627 .623 .827 r
.51554 .22791 .53069 .25749 .55874 .24887 .54368 .21923 Metetra
.631 .626 .827 r
.54368 .21923 .55874 .24887 .58709 .23953 .57212 .21008 Metetra
.636 .632 .829 r
.57212 .21008 .58709 .23953 .61573 .22943 .60087 .20045 Metetra
.642 .64 .832 r
.60087 .20045 .61573 .22943 .64464 .21857 .62992 .19031 Metetra
.648 .65 .838 r
.62992 .19031 .64464 .21857 .67381 .20697 .65926 .17965 Metetra
.655 .663 .846 r
.65926 .17965 .67381 .20697 .70322 .19465 .68889 .16846 Metetra
.662 .678 .855 r
.68889 .16846 .70322 .19465 .73287 .18166 .7188 .15675 Metetra
.669 .695 .866 r
.7188 .15675 .73287 .18166 .76274 .16806 .74897 .14454 Metetra
.637 .738 .921 r
.08911 .32321 .10674 .33931 .13028 .33239 .1128 .31577 Metetra
.635 .733 .919 r
.1128 .31577 .13028 .33239 .15404 .32556 .13673 .30836 Metetra
.634 .727 .915 r
.13673 .30836 .15404 .32556 .17804 .31882 .1609 .30097 Metetra
.632 .72 .911 r
.1609 .30097 .17804 .31882 .20228 .31216 .18532 .29359 Metetra
.631 .713 .906 r
.18532 .29359 .20228 .31216 .22678 .30557 .20999 .28621 Metetra
.63 .705 .9 r
.20999 .28621 .22678 .30557 .25155 .29903 .23493 .27881 Metetra
.629 .696 .894 r
.23493 .27881 .25155 .29903 .27659 .2925 .26013 .27139 Metetra
.628 .688 .887 r
.26013 .27139 .27659 .2925 .30191 .28596 .28562 .26392 Metetra
.627 .679 .88 r
.28562 .26392 .30191 .28596 .32753 .27937 .31139 .25637 Metetra
.626 .671 .873 r
.31139 .25637 .32753 .27937 .35345 .27268 .33745 .24874 Metetra
.626 .663 .866 r
.33745 .24874 .35345 .27268 .37967 .26585 .36381 .24099 Metetra
.626 .656 .86 r
.36381 .24099 .37967 .26585 .40621 .25884 .39047 .23309 Metetra
.626 .65 .854 r
.39047 .23309 .40621 .25884 .43306 .25159 .41743 .22502 Metetra
.627 .645 .848 r
.41743 .22502 .43306 .25159 .46024 .24405 .44471 .21676 Metetra
.628 .641 .844 r
.44471 .21676 .46024 .24405 .48773 .23617 .4723 .20827 Metetra
.629 .638 .84 r
.4723 .20827 .48773 .23617 .51554 .22791 .50021 .19952 Metetra
.631 .637 .838 r
.50021 .19952 .51554 .22791 .54368 .21923 .52843 .1905 Metetra
.633 .637 .836 r
.52843 .1905 .54368 .21923 .57212 .21008 .55697 .18118 Metetra
.636 .638 .836 r
.55697 .18118 .57212 .21008 .60087 .20045 .58583 .17153 Metetra
.638 .641 .837 r
.58583 .17153 .60087 .20045 .62992 .19031 .615 .16155 Metetra
.642 .646 .839 r
.615 .16155 .62992 .19031 .65926 .17965 .64448 .15121 Metetra
.646 .652 .842 r
.64448 .15121 .65926 .17965 .68889 .16846 .67427 .1405 Metetra
.65 .66 .847 r
.67427 .1405 .68889 .16846 .7188 .15675 .70437 .12942 Metetra
.654 .67 .853 r
.70437 .12942 .7188 .15675 .74897 .14454 .73477 .11796 Metetra
.643 .735 .915 r
.07122 .30643 .08911 .32321 .1128 .31577 .09507 .29852 Metetra
.642 .73 .913 r
.09507 .29852 .1128 .31577 .13673 .30836 .11916 .29058 Metetra
.641 .725 .91 r
.11916 .29058 .13673 .30836 .1609 .30097 .14349 .28262 Metetra
.64 .72 .906 r
.14349 .28262 .1609 .30097 .18532 .29359 .16807 .27462 Metetra
.639 .714 .902 r
.16807 .27462 .18532 .29359 .20999 .28621 .19291 .26659 Metetra
.638 .708 .898 r
.19291 .26659 .20999 .28621 .23493 .27881 .21801 .2585 Metetra
.637 .702 .893 r
.21801 .2585 .23493 .27881 .26013 .27139 .24338 .25036 Metetra
.636 .696 .888 r
.24338 .25036 .26013 .27139 .28562 .26392 .26903 .24214 Metetra
.636 .689 .883 r
.26903 .24214 .28562 .26392 .31139 .25637 .29495 .23385 Metetra
.635 .683 .878 r
.29495 .23385 .31139 .25637 .33745 .24874 .32115 .22546 Metetra
.635 .677 .873 r
.32115 .22546 .33745 .24874 .36381 .24099 .34765 .21696 Metetra
.635 .671 .868 r
.34765 .21696 .36381 .24099 .39047 .23309 .37444 .20834 Metetra
.634 .666 .863 r
.37444 .20834 .39047 .23309 .41743 .22502 .40154 .19958 Metetra
.635 .662 .859 r
.40154 .19958 .41743 .22502 .44471 .21676 .42893 .19067 Metetra
.635 .658 .855 r
.42893 .19067 .44471 .21676 .4723 .20827 .45664 .18159 Metetra
.635 .655 .852 r
.45664 .18159 .4723 .20827 .50021 .19952 .48466 .17232 Metetra
.636 .652 .849 r
.48466 .17232 .50021 .19952 .52843 .1905 .51299 .16286 Metetra
.637 .651 .847 r
.51299 .16286 .52843 .1905 .55697 .18118 .54164 .15319 Metetra
.638 .65 .846 r
.54164 .15319 .55697 .18118 .58583 .17153 .57061 .14329 Metetra
.639 .65 .845 r
.57061 .14329 .58583 .17153 .615 .16155 .5999 .13315 Metetra
.641 .652 .845 r
.5999 .13315 .615 .16155 .64448 .15121 .62951 .12275 Metetra
.643 .654 .846 r
.62951 .12275 .64448 .15121 .67427 .1405 .65944 .1121 Metetra
.645 .658 .848 r
.65944 .1121 .67427 .1405 .70437 .12942 .6897 .10118 Metetra
.648 .662 .85 r
.6897 .10118 .70437 .12942 .73477 .11796 .72028 .08998 Metetra
.648 .732 .911 r
.05306 .28905 .07122 .30643 .09507 .29852 .07707 .2807 Metetra
.647 .728 .908 r
.07707 .2807 .09507 .29852 .11916 .29058 .10131 .2723 Metetra
.646 .724 .906 r
.10131 .2723 .11916 .29058 .14349 .28262 .1258 .26384 Metetra
.645 .72 .903 r
.1258 .26384 .14349 .28262 .16807 .27462 .15054 .25533 Metetra
.645 .716 .9 r
.15054 .25533 .16807 .27462 .19291 .26659 .17554 .24675 Metetra
.644 .711 .896 r
.17554 .24675 .19291 .26659 .21801 .2585 .2008 .2381 Metetra
.644 .707 .893 r
.2008 .2381 .21801 .2585 .24338 .25036 .22633 .22937 Metetra
.643 .702 .889 r
.22633 .22937 .24338 .25036 .26903 .24214 .25212 .22056 Metetra
.642 .697 .886 r
.25212 .22056 .26903 .24214 .29495 .23385 .2782 .21166 Metetra
.642 .693 .882 r
.2782 .21166 .29495 .23385 .32115 .22546 .30455 .20266 Metetra
.642 .688 .878 r
.30455 .20266 .32115 .22546 .34765 .21696 .33119 .19355 Metetra
.641 .684 .875 r
.33119 .19355 .34765 .21696 .37444 .20834 .35812 .18434 Metetra
.641 .68 .871 r
.35812 .18434 .37444 .20834 .40154 .19958 .38535 .175 Metetra
.641 .676 .868 r
.38535 .175 .40154 .19958 .42893 .19067 .41288 .16553 Metetra
.641 .673 .865 r
.41288 .16553 .42893 .19067 .45664 .18159 .44072 .15592 Metetra
.641 .67 .862 r
.44072 .15592 .45664 .18159 .48466 .17232 .46886 .14616 Metetra
.641 .667 .86 r
.46886 .14616 .48466 .17232 .51299 .16286 .49732 .13624 Metetra
.641 .665 .857 r
.49732 .13624 .51299 .16286 .54164 .15319 .52609 .12616 Metetra
.642 .664 .856 r
.52609 .12616 .54164 .15319 .57061 .14329 .55519 .1159 Metetra
.642 .663 .854 r
.55519 .1159 .57061 .14329 .5999 .13315 .58461 .10546 Metetra
.643 .662 .854 r
.58461 .10546 .5999 .13315 .62951 .12275 .61435 .09482 Metetra
.644 .663 .853 r
.61435 .09482 .62951 .12275 .65944 .1121 .64443 .08399 Metetra
.645 .664 .853 r
.64443 .08399 .65944 .1121 .6897 .10118 .67484 .07295 Metetra
.646 .665 .854 r
.67484 .07295 .6897 .10118 .72028 .08998 .70558 .06169 Metetra
.651 .73 .907 r
.03462 .27114 .05306 .28905 .07707 .2807 .05878 .26241 Metetra
.651 .727 .905 r
.05878 .26241 .07707 .2807 .10131 .2723 .08317 .2536 Metetra
.65 .724 .903 r
.08317 .2536 .10131 .2723 .1258 .26384 .10781 .24472 Metetra
.65 .721 .901 r
.10781 .24472 .1258 .26384 .15054 .25533 .13271 .23576 Metetra
.649 .718 .899 r
.13271 .23576 .15054 .25533 .17554 .24675 .15786 .22672 Metetra
.649 .715 .896 r
.15786 .22672 .17554 .24675 .2008 .2381 .18327 .2176 Metetra
.648 .711 .894 r
.18327 .2176 .2008 .2381 .22633 .22937 .20895 .20839 Metetra
.648 .708 .891 r
.20895 .20839 .22633 .22937 .25212 .22056 .2349 .19909 Metetra
.647 .704 .888 r
.2349 .19909 .25212 .22056 .2782 .21166 .26112 .1897 Metetra
.647 .701 .886 r
.26112 .1897 .2782 .21166 .30455 .20266 .28763 .1802 Metetra
.647 .698 .883 r
.28763 .1802 .30455 .20266 .33119 .19355 .31442 .1706 Metetra
.646 .694 .88 r
.31442 .1706 .33119 .19355 .35812 .18434 .3415 .16088 Metetra
.646 .691 .878 r
.3415 .16088 .35812 .18434 .38535 .175 .36887 .15105 Metetra
.646 .688 .875 r
.36887 .15105 .38535 .175 .41288 .16553 .39654 .1411 Metetra
.646 .685 .873 r
.39654 .1411 .41288 .16553 .44072 .15592 .42452 .13102 Metetra
.646 .683 .871 r
.42452 .13102 .44072 .15592 .46886 .14616 .4528 .12081 Metetra
.646 .68 .869 r
.4528 .12081 .46886 .14616 .49732 .13624 .4814 .11046 Metetra
.646 .678 .867 r
.4814 .11046 .49732 .13624 .52609 .12616 .51031 .09996 Metetra
.646 .677 .865 r
.51031 .09996 .52609 .12616 .55519 .1159 .53954 .08932 Metetra
.646 .675 .864 r
.53954 .08932 .55519 .1159 .58461 .10546 .56911 .07852 Metetra
.646 .674 .863 r
.56911 .07852 .58461 .10546 .61435 .09482 .599 .06756 Metetra
.646 .674 .862 r
.599 .06756 .61435 .09482 .64443 .08399 .62922 .05644 Metetra
.647 .673 .861 r
.62922 .05644 .64443 .08399 .67484 .07295 .65979 .04514 Metetra
.647 .674 .861 r
.65979 .04514 .67484 .07295 .70558 .06169 .69069 .03367 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{306, 233.5},
  ImageMargins->{{0, 0}, {0, 6.3125}},
  ImageRegion->{{0.07, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005n00018a000`40O003h00OogooOgoo003oOomo
Ool00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00
ogooOgoo003oOomoOol00?moobEoo`D005Eoo`00ogoo9Goo00D007ooOomoo`0005Eoo`00ogoo9Woo
00<007ooOol0EWoo003oOolMOol60004Ool00`00Oomoo`1EOol00?moobQoo`03001oogoo05Aoo`00
mGoo0`00<7oo00<007ooOol0Dgoo003fOol00`00Oomoo`0[Ool01@00Oomoogoo0000EGoo003fOol0
0`00Oomoo`0/Ool3001FOol00?9oo`H001ioo`8006Ioo`00lgoo00@007ooOol001eoo`D006Eoo`00
lgoo00@007ooOol001Yoo`<000=oo`8006Eoo`00m7oo00<007oo000067oo0P001Woo00<007oo0000
I7oo003eOol2000EOol30008Ool01000Oomoo`00Hgoo003oOol:Ool3000;Ool01000Oomoo`00Hgoo
003oOol8Ool2000>Ool01@00Oomoogoo0000HWoo003oOol5Ool30002Ool00`00Oomoo`0;Ool00`00
Oomoo`02Ool00`00Oomoo`1OOol00?moo`=oo`8001Aoo`05001oogooOol0001QOol00?moo`<001Io
o`03001oogoo00<0061oo`00oGoo0P006Goo00<007ooOol00goo00<007ooOol0GGoo003jOol3000J
Ool20005Ool00`00Oomoo`1MOol0091oo`8006Eoo`<00003Ool007oo01Qoo`800003D[/007oo00Eo
o`03001oogoo05aoo`00T7oo0P00Hgoo0P0017oo00<007ooOol057oo0`0000=>VU:kCYX00P001Goo
00<007ooOol0G7oo002?Ool01000Oomoo`00Ggoo0`006goo0P0000I>VU:kDYYB^djJD[/20006Ool0
0`00Oomoo`1KOol008moo`04001oogoo001MOol2000KOol300002e:kCYYB^djJD[]>VU:kCYX004jJ
00001Woo00<007ooOol0FWoo002>Ool00`00Oomoo`02Ool00`00Oomoo`1GOol3000JOol300003U:k
DYX004jJD[]BVU:kCYYB^e:JD[/005:k0006Ool00`00Oomoo`1JOol008eoo`<0009oo`<005Ioo`80
01Uoo`@0000BD[]>VU:kCYYB^`00D[]>VU:kCYYB^djJD[]>VP00CYYB^`001Goo0P00Fgoo003XOol3
00000goo001oo`0EOol300005TjJD[]BVU:kCYYB^e:JD[]>VU:k001B^djJD[]BVU:kCYYB^`00D[]>
VP001goo00<007ooOol0F7oo002iOol5000XOol2000IOol200006TjJD[/005:kCYYB^djJD[]>VU:k
CYYB^djJ001>VU:kCYYB^djJD[]>VP00CYYB^djJ0006Ool00`00Oomoo`1HOol00;Uoo`05001oogoo
Ool0000UOol3000HOol300006U:kDYYB^djJ001BVU:kCYYB^e:JD[]>VU:kDYYB^djJ001BVU:kCYYB
^e:JD[/005:kDYX20007Ool00`00Oomoo`1GOol00;Yoo`03001oogoo02=oo`<001Uoo`80000JD[]>
VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VP<00003CYYB^`00
00Moo`03001oogoo05Ioo`00^goo00<007ooOol087oo0P006Goo0`0001]BVU:kCYYB^e:JD[]>VU:k
DYYB^`00D[]BVU:kCYYB^e:JD[]>VU:kDYYB^`00D[]BVU:kCYX00P0000EBVTjJDYYBVP0000Moo`03
001oogoo05Ioo`00_7oo00<007ooOol077oo10005goo0`0001a>VU:k001B^djJD[]>VU:kCYYB^djJ
D[]>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^`800008CYX004jJD[]>VU:kCYX000Moo`03
001oogoo05Eoo`00_Goo00<007ooOol06Goo0P000goo00<007ooOol04Goo100001aBVU:kCYYB^e:J
001>VU:kDYYB^djJD[]BVU:kCYYB^e:J001>VU:kDYYB^djJD[]BVU:kCYYB^`<000=BVP07CYX005:J
DYY>VU:J000027oo00<007ooOol0E7oo002iOol01@00Oomoogoo000067oo0`005Woo0`0001eB^djJ
D[]>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:k00<0000>
D[/005:kCYYB^djJD[/005:kCYYB^djJD[/000Ioo`8005Ioo`00^Woo0`005goo0P005goo0P0001aB
^e:K001>VU:kDYYB^djJD[]BVU:kCYYB^`00D[]>VU:kDYYB^djJD[]BVU:kCYYB^`00D[]>VP@000=B
VP05CYYBVP00DYY>VP02DYX00`00CYYBVP02DYX00djJ001oo`07Ool00`00Oomoo`1COol00=5oo`<0
01Moo`80000KCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYYB
^djJ00<0000FCYYB^djJDY]>VU:kCYYBVdjJ001>VU:kCYYB^`00D[]>VU:kCYYB^djJ0008Ool00`00
Oomoo`1BOol00<moo`8001Qoo`80000KD[]>VU:kDY]B^djJD[/005:kCYYB^e:JD[]>VU:kDYYB^djJ
001BVU:kCYYB^e:JD[]>VU:k00800005CYYBVP00DYY>VP03DYX01TjJDYYBVU:JCYX0009BVP05CYX0
05:JDYY>VP03DYX00`00Oomoo`06Ool00`00Oomoo`1BOol00<aoo`<0009oo`03001oogoo019oo`<0
000JCYYB^djJD[]>VU:kCYYB^djJ001>VU:kCYYB^djJD[]>VU:kCYYB^djJ001>VU:kCYYB^`<0000J
D[]>VU:KCYX004jJDY]>VU:kCYYBVdjJD[]>VU:K001B^djJD[/005:kCYYB^djJD[]>VP8000Qoo`03
001oogoo055oo`00bGoo0`005goo0`0001]>VU:k001B^djJD[]BVe:kCYYB^e:KD[]>VP00DYYB^djJ
D[]BVU:kCYYB^e:JD[/005:kDYX00P0000UBVTjJDYY>VU:JCYYBVTjJ00000U:J00E>VU:JDYYBVTjJ
00=BVP05001BVU:J001>VP03DYX20002DYX00`00Oomoo`06Ool00`00Oomoo`1@Ool00<Moo`8001Mo
o`<0000KCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYYB^djJ
00<0000JCYYBVdjJD[]>VU:KCYYB^djJDY/005:kCYYBVdjJD[]>VU:KCYYB^djJ001>VU:k001B^`<0
0005DYY>VU:kCYX00008Ool00`00Oomoo`1@Ool00<Aoo`<001Ioo`<00005CYYB^e:kD[]>VP03D[/0
4djJ001BVe:kCYYB^e:KD[]>VU:kDY]B^`00D[]BVU:kCYYB^e:J00<0000?CYYBVP00DYY>VU:JCYYB
VTjJDYY>VU:JCYYBVP0000=BVP05CYYBVU:JDYY>VP02DYX01P00CYX00000DYY>VP=BVP04CYYBVU:J
0008Ool00`00Oomoo`1?Ool00<9oo`8001Moo`80000JCYYB^`00D[]>VU:kCYYB^djJD[]>VU:kCYX0
04jJD[]>VU:kCYYB^djJD[]>VP00CYYB^`@0000KCYYBVdjJD[]>VP00CYYB^djJDY]>VU:kCYYBVdjJ
D[]>VP00CYYB^djJDY]>VU:kCYYBVdjJ00@0000:D[]>VU:JCYYB^djJDYY>VU:k0007Ool3000AOol5
000jOol00;moo`<00003Ool007oo01=oo`<000=B^`05CYX005:kD[]>VP03D[/03TjJD[]B^e:k001B
^e:KD[]>VU:kDY]B^djJD[/3000065:JCYYBVTjJDYY>VU:JCYYBVTjJ001>VU:JCYYBVTjJDYY>VU:J
CYYBVTjJ001>VP=BVP06CYX00000001>VU:J0P0000E>VU:JDYYBVTjJ00=BVP03CYYBVP0000Qoo`03
001oogoo015oo`03001oogoo03Yoo`00_Goo0P001Goo00<007ooOol03goo0P0001UB^djJD[]>VU:k
CYYB^djJ001>VU:kCYYB^djJD[]>VU:kCYYB^`00D[]>VU:kCYYB^`03000075:kCYX004jJD[]>VU:K
CYYB^djJDY]>VU:k001BVdjJD[]>VU:KCYYB^djJDY]>VU:k001BVdjJ0`0000E>VU:KCYYBVTjJ0080
000;DYY>VU:kCYYBVTjJD[]>VU:JCYX00009Ool00`00Oomoo`0@Ool00`00Oomoo`0jOol00;Yoo`<0
01Ioo`<0009B^`05CYYB^e:kD[]>VP03D[/01@00D[]B^e:kCYX00e:k00I>VU:kD[/004jJD[/30000
75:JCYYBVTjJDYX005:JCYYBVTjJDYY>VU:JCYYBVTjJDYX005:JCYYBVTjJDYY>VU:JCYYBVTjJ0`00
00E>VU:JDYYBVTjJ00=BVP05CYX005:JDYY>VP03DYX01TjJDYYBVU:JCYX000Qoo`03001oogoo00Eo
o`H000Eoo`03001oogoo03Yoo`00]goo0`005Woo0`0001Q>VU:k001B^djJD[]>VU:kCYYB^djJD[]>
VU:k001B^djJD[]>VU:kCYYB^djJD[/300007E:kCYYBVdjJD[]>VU:KCYYB^`00DY]>VU:kCYYBVdjJ
D[]>VU:KCYX004jJDY]>VU:kCYYBVdjJD[/00P0001U>NP00CYYBVTjJDY]>VU:JCYYBVdjJDYX005:k
CYYBVTjJD[]>VU:JCYYB^djJDYX00009Ool00`00Oomoo`0?Ool00`00Oomoo`0jOol00;Eoo`8001Io
o`<0009B^`05C[]B^e:k001>VP03D[/01DjJD[]B^e:kCYX00U:k00<004jJD[/00U:k00=>VU:kD[/0
0P0001eBVTjJ001>VU:JCYYBVTjJDYY>VU:JCYX004jJDYY>VU:JCYYBVTjJDYY>VU:JCYX004jJDYY>
VU:J00<00005DYY>VU:JCYX00002DYX01DjJDYYBVU:JCYX00U:J0P000e:J00E>VU:JDYYBVTjJ009B
VP8000Uoo`03001oogoo00ioo`03001oogoo03Yoo`00/Woo1@004goo0`0001Y>VU:kCYYB^djJD[]>
VU:kCYX004jJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:k0P0001e>VU:KCYYB^`00DY]>VU:k
CYYBVdjJD[]>VU:KCYX004jJDY]>VU:kCYYBVdjJD[]>VU:K001B^djJ0080000ADYY>VU:JCWYBVTjJ
DYX005:KCYYBVTjJDY]>VU:JCYYBV`02000024jJD[]>VU:JCYYB^djJDYX200000e:J001oo`08Ool0
0`00Oomoo`0<Ool3000lOol008Eoo`@002Moo`8001Eoo`<0009B^`05001B^e:kD[]>^`03D[/01Djk
D[]B^`00CYX00e:k00U>VU:kD[]B^djJD[/005:kCYX00P0001aBVdjJDYY>VU:KCYYBVP00DYY>VU:J
CYYBVTjJDYY>VU:J001BVTjJDYY>VU:JCYYBVTjJDYY>VP<0000;CYYBVTjJDYY>VU:JCYYBVTjJDYX0
0003DYX01TjJDYYBVU:JCYYBVP800004CYYBVU:JDYX300001E:jDYYBVU:J00002Goo00<007ooOol0
3Goo00<007ooOol0>Woo0024Ool00`00Oomoo`02Ool00`00Oomoo`0QOol3000DOol300006djJD[]>
VU:kCYX004jJD[]>VU:kCYYB^djJD[]>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VP0300006djJD[]>
VU:KCYYB^djJDY]>VP00CYYBVdjJD[]>VU:KCYYB^djJDY/005:kCYYBVdjJD[]>VP0300005dijDYX0
05:JCYYBVTijDYY>VU:JCWYBVTjJ001>VU:KCYYBVTjJDY]>VU:JCYX00P0000aBVTjJ000005:kCYYB
^e:JD[]>VU:k0007Ool4001;Ool008Aoo`03001oogoo009oo`03001oogoo01moo`8001Aoo`<0009B
^`05C[]B^e:kD[]>^`02D[/00`00C[]B^`02D[/02DjkD[]B^e:kC[]B^`00D[]>VP03D[/07TjJ0000
0000CYYBVP00DY]>VU:JCYYBVdjJDYY>VU:KCYX004jJDYY>VU:JCYYBVTjJDYY>VP00CYYBVP@0000C
CYYBVTjJDYY>VP00CYYBVTjJDYY>VU:JCYYBVTjJDYY>VP00CYX00e:J00A>VU:JDYYBVP@000=BVP05
D[YBVU:JDYYB^P02DYX00`00Oomoo`07Ool00`00Oomoo`19Ool008Aoo`03001oogoo009oo`03001o
ogoo01aoo`<001Aoo`80000JC[]B^`00D[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB^djJ
D[]>VP00CYYB^`@0000JCYYB^djJD[]>VP00CYYBVdjJD[]>VU:KCYYB^djJDY/005:kCYYBVdjJD[]>
VU:KCYYB^`<0000LDYY>NU:JCWYBVTijDYY>NU:JCWX004ijDYY>VU:JCWYBVTjJDYY>NU:J001BVTjJ
DY]>VU:JCYX300003TjJDYX005:kCYYB^e:JD[]>VU:kDYYB^djJ000:Ool00`00Oomoo`18Ool008Ao
o`03001oogoo009oo`03001oogoo01Yoo`<001Aoo`800006D[]>^e:kD[/004jk0e:k00U>^e:kD[]B
^djkD[/005:kC[/00e:k00A>^e:kD[]B^`<0000KDY]>VU:JCYYBVdjJDYY>VU:KCYX004jJDY]>VU:J
CYYBVdjJDYY>VU:K001BVTjJDYY>VU:J00<0009>VP0I001>VU:JCYYBVTjJDYY>VU:JCYYBVP00DYY>
VU:JCYYBVTjJDYY>VU:JCYYBVP00DYX010000U:J00H005:JDYX005:JD[X3DYX01e:jDYYBVU:JD[YB
VP0000Yoo`03001oogoo04Moo`00Q7oo00<007ooOol00Woo00<007ooOol05goo0`000Woo00<007oo
Ool047oo0P0001Q>VU:kC[]B^djJD[]>^`00CYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[/3
00006e:kCYX004jJD[]>VU:kCYYB^djJD[]>VU:kCYX004jJDY]>VU:kCYYBVdjJD[]>VP00CYYB^`03
00006e:JCWYBVTijDYX005:JCWYBVTijDYY>NU:JCWYBVTijDYX005:JCWYBVTjJDYY>NU:JCYYBVP03
00005U:JCYYBVTjJDYY>VP00CYYBVTjJ001BVU:kCYYB^e:JD[]>VU:kDYYB^`002Woo00<007ooOol0
Agoo0024Ool00`00Oomoo`02Ool00`00Oomoo`0DOol3000EOol30003D[/01DjkD[]B^e:kC[/00U:k
00<004jkD[/00U:k00I>^e:kD[]B^djk0002D[/300006e:KCYYBVdjJDY/005:JCYYBVdjJDYY>VU:K
CYYBVTjJDY/005:JCYYBVdjJDYY>VU:KCYYBVP030002CYX01E:JCYY>VTjJDYX00TjJ01<005:JCYYB
VTjJDYY>VU:JCYYBVTjJ001>VU:JCYYBVTjJDYY>VP0200000e:JCYX00006DYX01@00DYYBVU:J0000
0U:J00EB^U:JDYYBVU:j00=BVP03D[X007oo00Uoo`03001oogoo04Ioo`00QGoo10005Goo0P005Goo
0`0001MB^djk001>VU:kC[]B^djJD[]>^e:kCYYB^`00D[]>VU:kCYYB^djJD[]>VU:k00<0000KD[]>
VU:kCYYB^djJD[]>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VU:k001B^djJDY]>VU:k00<0000MDYY>
NP00CWYBVTijDYY>NU:JCWYBVTij001>NU:JCWYBVTijDYY>NU:JCWYBVTij001>VU:JCWYBVP020000
6TiiDYY>NU:J001BVTjJDYY>VU:JCYX004jJDYY>VU:J001B^e:JD[]>VU:kDYYB^djJD[/2000;Ool0
0`00Oomoo`15Ool009]oo`<001Aoo`<000=B^`05C[]B^`00D[]>^`03D[/02DjkD[]B^e:kC[]B^`00
D[]>^`03D[/300006e:kCYX004jJDY]>VU:KCYYBVdjJDY]>VP00CYYBVTjJDY]>VU:JCYYBVdjJDYY>
VP00CYYBVP030002CYX01E:JCYY>VP00DYX00djJ01ABVTjJCYY>VU:JCYX004jJDYY>VU:JCYYBVTjJ
DYY>VU:J001BVTjJ0P000e:J00E>VU:JDYYBVP0000EBVP03001BVU:J009BVP05001BVU:JDYYB^P03
DYX20002D[/00`00Oomoo`07Ool20017Ool009Uoo`<001=oo`<0000GD[]>^e:kC[YB^djkD[]>^U:k
001B^djJD[]>^e:kCYYB^djkD[]>VP00CYYB^`0300006e:kCYYB^djJD[/005:kCYYB^djJD[]>VU:k
CYYB^djJ001>VU:kCYYB^djJD[]>VU:kCYYB^`0300007U:JCWYBVTijDYY>NU:JCWYBVP00DYY>NU:J
CWYBVTijDYY>NU:J001BVTijDYY>NU:JCWYBVTijDYY>NP<0000JCWYBVTiiDYY>NU:JCWUBVTij001>
VU:JCYYBVTjJ001>VU:JCYYBVTjJ001>VU:kDYYB^`800005D[YF^e:jE]/0000;Ool00`00Oomoo`14
Ool009Ioo`<000=oo`03001oogoo00eoo`<0009B^`03001>^e:k009B^`09C[]B^e:kD[]>^e:k001B
^djk00=B^`04C[]B^e:kD[/3000075:kCYYBVdjJD[]>VU:KCYYB^`00DY]>VU:KCYYBVdjJDY]>VU:K
001BVdjJDYY>VU:KCYYBVTjJ0P000TjJ00D004jJCYY>VU:J00=>VP05DYY>VP00CYYBVP03CYX035:J
CYY>VTjJDYX005:JCYYBVTjJDYY>VP<00003CYYBVP0000=BVP05CYYBVU:JDYY>VP02DYX00`00DYYB
VP02DYX00`00DYYBVP03DYX00`00D[YBVP02000025JkD[YB^e:kE[]B^U:k000;Ool00`00Oomoo`13
Ool009Aoo`8001=oo`<0000GD[]>^e:kC[]B^`00D[]>^U:kC[]B^djjD[]>^e:kC[YB^`00D[]>VU:k
C[]B^`03000075:kCYX004jJD[]>VU:kCYYB^djJD[]>VP00CYYB^djJD[]>VU:kCYYB^djJD[/005:k
CYYB^djJ0`0001a>NU:JCWYBVP00DYY>NU:JCWYBVTijDYY>NU:JCWX004ijDYY>NU:JCWYBVTijDYY>
NP00CWYBVP@0000KCWUBVTiiDYY>N@00CWUBVTijDYY>NE:JCWYBVTiiDYX005:JCYYBVTjJ001>VU:J
CYYBVTjJ00<0000;D[YFfe:jE[]B^UKKD[YF^e:jE]/0000:Ool00`00Oomoo`13Ool0095oo`<0019o
o`<000=B^`09C[]B^e:kD[]>^e:k001B^djk00=B^`06C[]B^e:kD[]>^`000U:k0`0001eB^djJD[]>
Ve:k001BVdjJD[]>VU:KCYYB^djJDY]>VP00CYYBVdjJDY]>VU:KCYYBVdjJ001>VU:K00800003CYYB
VTjJ009>VP05DYY>VTjJ001BVP03CYX01U:JCYY>VTjJDYX0009>VP05DYY>VTjJCYYBVP02CYX30000
35:JCYYBVTijDYY>VU:JCWYBVTjJ001>VP=BVP07CYYBVU:JDYY>VU:J00000e:J00<005:JDYX00`00
00EBVU:j001F^e:j009B^`08E[]B^U:kD[]F^e:jD[/000Yoo`03001oogoo049oo`00SWoo0`004Woo
0`0001MBg4jk001>^e:kC[]B^djkD[]>^e:kC[]B^`00D[]>^U:kC[]B^djjD[]>^e:k00<0000MD[]>
VU:kCYYB^djJD[]>VU:k001B^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYYB^`030000
6e:JCWYBVTijDYY>NU:JCWYBVTij001>NU:JCWYBVTijDYY>NU:JCWYBVP00DYY>NU:JCWYBVP030000
6e:JCWT004iiDYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYY>NU:JCWUBVTijDYY>N@00CYYBVP040000
4U:JE[]BVU:kDYX005:jE[]B^UKKD[YF^e:jE]]B^UJkD[X000]oo`03001oogoo045oo`00S7oo0`00
4Goo0`000e:k00E>^e:k001B^djk00=B^`09C[]B^e:kD[]>^e:k001B^djk00=B^`<0000MD[]>V`00
CY]B^djJD[]>Ve:kCYYB^djK001>VU:KCYYB^djJDY]>VU:kCYYBV`00DY]>VU:KCYYBV`030002CYX0
0`00CYYBVP03CYX02E:JCYY>VTjJDYY>VP00CYYBVP03CYX01E:JCYY>VTjJ00000TjJ0`0001A>VTij
DYY>NTjJ001BVTijDYY>VU:JCWYBVTjJDYY>NU:J001BVTjJ0e:J00A>VU:JDYYBVP<00003D[X005:j
009B^P09DYYB^U:jD[YBVP00D[]F^e:j009B^`07E[]B^U:kD[]F^e:j00002Woo00<007ooOol0@Goo
0029Ool30003Ool00`00Oomoo`0;Ool300005e;LC[]B^djkD]a>^e:kC[]Bg000D[]>^e:kC[]B^djk
D[]>^e:kC[/004jkD[/00`0001eB^djJD[]>VU:k001B^djJD[]>VU:kCYYB^djJD[]>VP00CYYB^djJ
D[]>VU:kCYYB^djJ001>VU:k00<0000KDYY>NU:KCWYBVP00DYY>NU:JCWYBVTijDYY>NU:JCWYBVP00
DYY>NU:JCWYBVTijDYY>NU:J00<0000LDYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYY>NE:JCWUBVTii
DYY>N@00CWYBVTiiDYY>NU:JCWT200005e:JCYX005:J001BVUJkDYYB^e:JE[]BVU:k001Ffe:jE[]B
^UKKD[YF^e:jE]/00P0000=Ff`00Ool02Goo00<007ooOol0@7oo0027Ool2000BOol20002D[/00`00
C[]B^`02D[/02DjkD[]B^e:kC[]B^`00D[]>^`03D[/014jkD[]B^e:k0`0001eB^djKD[]>^e:kCY]B
^djkD[/005:kCY]B^djJD[]>Ve:kCYYB^`00D[]>VU:KCYYB^djJDY]>VU:k00<000U>VP04001>VTjJ
DYX3CYX01U:JCYY>VTjJDYX0009>VP03DYY>VTjJ00<0009>NP0G001>NTjJCWYBVTijCYY>NU:JCWX0
04jJDYY>NU:JCYYBVTijDYY>VU:JCWX00002DYX014jJDYX0000015:J00D005:jD[X005:J00=B^P05
DYYB^U:jD[X00002D[/015JkD[YB^e:k0P0000AFo5KkE_`000Uoo`03001oo`00045oo`00Q7oo0`00
4Goo0`0001I>^e;LC[]Bg4jk001>^e;LC[]B^djkD]a>^e:kC[]Bg000D[]>^e:kC[]B^`<0000MD[]>
VP00CYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VU:kCYYB^`00D[]>VU:kCYYB^`030000
6e:KCWX004ijDYY>NU:KCWYBVTijDY]>NU:J001BVTijDYY>NU:JCWYBVTijDYY>NP00CWYBVP030000
7U:JCWUBVTiiDYX005:JCWUBVTiiDYY>NE:JCWUBVTii001>NE:JCWUBVTiiDYY>NE:JCWUBVP00DYY>
NP800005D[YBVU:JCYYB^P02DYX04000E[/005:kDYYF^e:JD[]BVUJkDYX005:jE]]B^UJk0P0000MF
ne[lE]]Jo5KkF_`0000:Ool00`00Oomoo`0oOol0089oo`80015oo`<0009B^`05C[]B^e:kD[]>^`02
D[/00`00C[]B^`02D[/01TjkD[]B^e:kC[/0009B^`<0000MD[]>^e:kC[]B^`00D[]>^e:kCY]B^djk
D[]>Ve:kC[/004jJD[]>Ve:kCYYB^djKD[]>VP00CYYB^`030005CYX00`00CYY>VP08CYX01@00CYY>
VTjJDYX00djJ00=BVTjJCYX00`000Tij00E>VTijCWY>NTjJ009>NP0E001BVTijCYY>NU:JCWY>VTij
DYX005:JCYYBVTijDYY>VU:JCWYBVTjJ00<000UBVP03001BVP00009B^P05DYYB^U:jD[YBVP02D[X0
3P00D[X00000E_aFneKlE_]Fo5KkE_aFneKl000:Ool00`00Oomoo`0nOol005=oo`D002Moo`<0011o
o`<0000FC[]Bg000D]a>^e;LC[]Bg4jkD]a>^e;L001B^djkD]a>^e:kC[]Bg4jkD[/3000075:kCYYB
^djJD[]>VU:kCYYB^`00D[]>VU:kCYYB^djJD[]>VU:kCYX004jJD[]>VU:kCYYB^djJ100001]BVdij
DY]>VU:KCWYBVdjJDY/005:KCWYBVTijDY]>NU:JCWYBVdij001>NU:JCWYBVTijDYX00`0001iBVP00
DYY>NE:JCWUBVTiiDYY>NE:JCWT004iiDYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYY>NE:JCWT30000
14ii001>VU:j0U:J00M>VU:jDYYBVTjJD[YBVP02000025JkDYYB^e:JE[]BVU:kDYX3000035KKF_aF
ne[lE]]Jo5KkF_aFfe[lE_/000Yoo`03001oogoo03ioo`00Dgoo00D007ooOomoo`0002Eoo`8000=o
o`03001oogoo00Yoo`<00003D[]Bfdjk009B^`03001>^e:k009B^`09C[]B^e:kD[]>^e:k001B^djk
00=B^`0NC[/00000D[]>^`00C[]B^djkD[]>^e:kC[]B^djkD[/005:kC[]B^djKD[]>^e:kCY]B^`00
D[]>VU:k10000djJ00<004jJCYX024jJ00<004jJCYX01djJ00<005:JCYX010000Tij00E>VTijCWX0
04jJ00=>NP0CCYY>NTijCWY>VTij001>NU:JCWY>VTijDYY>NTjJCWX004ijDYX010000U:J00A>VU:J
DYX000YBVP800006DYYB^U:jD[YBVU:j0P000UKK00h005KlE_]Fo5KkE_aFneKlE_]Fo5KkE_aFn`00
2Woo00<007ooOol0?Goo001DOol00`00Oomoo`0SOol3000?Ool300005djkD]a>^e;LC[]Bg4jkD]a>
^`00C[]Bg4jkD]a>^e;LC[]Bg4jkD]`005:kC[/00`0001U>VU:kC[]B^djJ001>VU:kCYYB^djJD[]>
VU:kCYX004jJD[]>VU:kCYYB^djJD[]>VP04000075:KCYYBVdjJDY]>VU:K001BVdjJDY]>NU:KCYYB
VdijDY]>VP00CWYBVdijDYY>NU:KCWYBVTij0`0001i>NE:JCWUBVTiiDYY>NE:JCWT004iiDYY>NE:J
CWUBVTiiDYY>NE:J001BVTiiDYY>NE:JCWUBVTiiDYX300003E:JCWUBVTiiDYY>NE:JCWUBVP00DYY>
VU:j009BVP0;CYYB^U:JDYY>VU:j001B^e:JE[]BVP020003E]/035;KE]/005[lE]]Jo5KkF_aFfe[l
E_]Jo0800003Fc`007oo00Uoo`03001oogoo03aoo`00Bgoo1P0017oo00<007ooOol07goo0`0047oo
0P0000=B^e;L00000U:k00IBfdjkD[]B^e;KC[/2D[/00`00C[]B^`02D[/01DjkD[]B^e:kC[/00`00
01U>^e:kC[]B^djkD[]>^e:k001B^djkD[]>^e:kC[]B^djkD[]>^`00CY]B^djkD[]>V`030002CYX0
0`00CYY>VP07CYX00`00CYY>VP08CYX00`00CYY>VP03CYX30002CWX00`00CYY>NP02CWX02DjJCWY>
NTijCYY>NP00CWY>VP03CWX034jJCWY>NTijCYX004jJCWYBVTijCYY>NP800004DWY>N@00CYX3DYX0
1djJDYYBVU:JCYYBVP0000YBVP03001B^U:j008000QFf`07001Fo5KkE_aFneKlE_/00P0000EOGE/l
FeeKG@0000Uoo`03001oogoo03aoo`00EWoo00<007ooOol077oo0P0047oo0`0001IBg4jkD]a>^e;L
001Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C[]Bg4jkD]a>^`<0000IC[]B^`00D[]>VU:kC[]B^djJD[]>
^e:k001B^djJD[]>VU:kCYYB^djJD[/005:kCYX00`0001e>VU:kCYYBVdjJ001>VU:KCYYBVdjJDY]>
VU:KCYYBV`00DY]>VU:KCWYBVdjJDY]>NU:K001BVTij00<0000PCWUBVTiiCYY>N@00CWUBVTiiDYY>
NE:JCWUBVTiiDYX005:JCWUBVTiiDYY>NE:JCWUBVTii001>NE:JCWUBVP80000@CWUBVTiiDYX005:J
CWUBVTiiDYY>NE:JCWUBVTii0002DYX01TjJD[YBVU:JCYYB^P9BVP<00003E]]BfeKK009Ff`0:D]]F
feKKE]]Bf`00E_]Jo5KKF_`2000025/lGeeK?5mMFcaOGE/l0008Ool2000VOol3000DOol005Moo`03
001oogoo01Qoo`D000eoo`<0000:D]a>^e;KD[]Bg4jkD]]B^e;L0002D[/02U;KC[]B^e:kD]]>^e:k
001B^djk0`0001U>^e:kC[]B^djk001>^e:kC[]B^djkD[]>^e:kC[]B^`00D[]>^e:kC[]B^djkD[]>
^`030003CYX01djKCYY>VTjJCY]>VP0000U>VP03001>VTjJ00M>VP<000=>NP09CYY>NTijCWY>VTij
001>NTjJ00=>NP05CYY>NTijCWX00003CWX01DjJCWY>NTijCYX00dij00h004ij000005:JCWUBNTii
DYY>NE9j001BVTjJ0e:J00I>VU:JDYYBVTjJ0007DYX300000e:j001Ff`0:E]/01000E_/000000U]M
00IOGE/lFeeKGEmMFc`2Fed00`00Oomoo`07Ool00`00Oomoo`0SOol01000Oomoo`004goo001COol0
1@00Oomoogoo000067oo0P003goo0`0001IBg4jk001>^e;LC[]Bg4jkD]a>^e;LC[/004jkD]a>^e;L
C[]Bg4jkD]a>^`<0000JC[]B^djkD[]>^e:kC[]B^djk001>^e:kCYYB^djkD[]>VU:kC[]B^`00D[]>
VU:kCYYB^`80000MCYYB^`00DY]>VU:kCYYBVdjJD[]>VU:K001BVdjJDY]>VU:KCYYBVdjJDY]>VP00
CWYBVdjJDY]>NP0300008DiiDYX004jJCWUBVTiiCYY>NE:JCWU>VP00DYY>NE:JCWUBVTiiDYY>NE:J
CWT004iiDYY>NE:JCWUBVTiiDYY>N@0300005TiiDYY>NE:JCWUBVTiiDYY>N@00CWUBVTiiDYY>NE:J
CWUBVTiiDYX005:j0U:J00U>VP00000005:jE]/005Jk00000eKK00EBfeKKE]]Ffe;K00=Ff`0<D]/0
05/lGeeK?5mMFcaOGE/lGeeK?5mM0P0000=OW@00Ool01goo00<007ooOol08goo00<007ooOol057oo
001DOol3000FOol3000>Ool300004U;LC[]Bg5;KD]`005;KD[]Bg4jkD]]B^e;LC[]Bfe:k001>^`9B
^`03D]]>^e:k0080000JC[]B^`00D[]>^e:kC[]B^djkD[]>^e:kC[/004jkD[]>^e:kC[]B^djkD[]>
^`00C[]B^`<00007CY]>VTjKCYX004jJCY/00djJ00I>VdjJCYY>VTjK0009CYX00`00CYY>VP030003
CWX01DjJCWX004ijCYX00dij00I>VTijCWY>NTjJ0002CWX01DjJCWY>NTijCYX00Tij00<004jJCWX0
0Tij00=>VTij00000P0000i>NDij001BVTiiDWY>NE:JCWUBNTiiDYY>N@000U:J00E>VU:JDYYBVTjJ
00=BVP0=001BVP00001B^UJkD[YF^e:j001B^UJk00002EKK0P0000EK7000FeeOGE/l009KG@05GeeK
?5]M001O_@03Gid20007Ool00`00Oomoo`0ROol00`00Oomoo`0DOol006]oo`8000ioo`<0000GD]a>
^e;LC[]Bg4jkD]a>^e;L001Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C[]Bg00300006E;LC[]B^djkD]`0
05:kC[]B^djkD[]>^e:kC[]B^`00D[]>^e:kCYYB^djkD[]>VU:k00<0000LD[]>VU:kCYYB^djJD[]>
VP00CYYBVdjJD[]>VU:KCYYB^djJ001>VU:KCYYBVdjJDY]>VU:KCYX3000084iiDYY>NTjJCWUBVTij
CYY>N@00CWU>VTiiDYY>NDjJCWUBVTii001>NE:JCWUBVTiiDYY>NE:JCWUBVP00DYX400006TiiDYY>
NE9jCWT004iiDYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYY>NE:JCWUBVTiiDYX3000035KKD[YF^e:j
E]]B^UJk001Ffe:j001Bf`=Ff`03D]]FfeKK0080000:FcaK75/lFa`005/lGeeK?5mMFc`2000026>n
GieO_EnMHkiOWEnm0007Ool00`00Oomoo`0ROol00`00Oomoo`0COol006Qoo`<000ioo`80000GD]a>
f`00D]]Bg4jkD]aBfe;LC[]Bg5;KD]`005;KD[]Bg4jkD]]B^e;LC[]Bf`0300006E:kC[]B^djkD[]>
^e:kC[/004jkD[]>^e:kC[]B^djkD[]>^e:k001B^djkD[]>^e:k00<0009>V`0=001>VTjKCYY>VdjJ
CY]>VTjKCYX004jJCY/00djJ00E>VdjJCYY>VP0000E>VP<00004CWY>VP00CYX3CWX01TjJCWY>NTij
CYX0009>NP05CYY>NTijCWY>VP03CWX01@00CWY>NTijCYX00dij01Y>VP00000004ijCWU>NTiiCWY>
NDijCWU>NTii001>NE:JCWUBNTiiDYY>NE9jCWUBVP000e:J00=>VU:J00000P000U:J00d005:jE[]B
^UJkD[YF^e:j001B^UJkD[X00004E]/200000e/LFcaK7002Fa`02E/l001KGE]MGeeK?000GieO_@03
Gid01EnmGid00000Gmd00P001Goo00<007ooOol087oo1@004goo001VOol20002Ool00`00Oomoo`09
Ool300005TjkD]a>^e;LC[/004jkD]a>^e;LC[]Bg4jkD]a>^e;L001Bg4jkD]a>^e;L0`0001UBg4jk
001>^e;LC[]B^djkD]a>^e:kC[/004jkD[]>^e:kC[]B^djkD[]>^`00CYYB^`03000075:kCYYB^djJ
D[/005:kCYYB^djJD[]>VU:kCYYB^`00D[]>VU:KCYYB^djJDY]>VU:k001BVdjJ0`00021>NTjJCWY>
VTij001>NTjJCWUBVTijCYY>NE:JCWY>VP00DYY>NDjJCWUBVTiiCYY>NE:J001BVTiiDYY>NE:J0`00
01]>NTii001>NE9jCWUBVTiiDWY>NE:JCWUBNP00DYY>NE:JCWUBVTiiDYY>NE:JCWT004iiDYX00`00
01AF^U:JD[YBVUJj001F^e:jE]]B^UJkD[YFf`00E[]B^UKK001Ffe;K0P0000]K?5/LFcaK75/lFaaK
?5/LFc`005mM0080000=GieS_UnMGkeOWF>nGid005nlHmeO_5oMGk`00P0017oo00<007ooOol0=goo
001SOol3000=Ool300005TkKD]aBfe;LC]]Bg5;KD]a>f`00D]]Bg4jkD]aBfe;LC[]Bg5;K001>^e;K
0`0001UB^djkD[]>^e:k001B^djkD[]>^e:kC[]B^djkD[]>^`00C[]B^djkD[]>^e:kC[]B^`030002
CY/01DjkCY]>VdjKC[/00TjK00/004jKCYY>VdjJCY]>VTjKCYY>V`00009>VP06CY]>VTjJCYY>VdjJ
0`0000a>NTjJCWY>VTijCYY>NTjJCWX004ijCYX3CWX01DjJCWY>NTij00000dij00E>VTijCWY>NTjJ
009>NP03001>VP000080000KCWY>NDiiCWU>NP00CWY>NDijCWU>NTiiCWY>NDijCWU>NP00DWY>NE:J
CWUBNTiiDYY>NE9j00<0009BVP05D[YBVU:JDYYB^P02DYX03000E[]B^UJkD[YF^e:j001B^UJkD[YF
^`8000=K7005FcaK75/LFaaK?003Fa`01E/l001OWEnMGkd00enM00=O_@0000001EoM0P0000AOg@00
001oo`<000Uoo`@002]oo`00H7oo0`003Woo0P0001I>^e;L001Bg4jkD]a>^e;LC[]Bg4jkD]`005;L
C[]Bg4jkD]a>^e;LC[]Bg0<0000JD]a>^e;LC[]Bg4jkD]a>^e;L001B^djkD]a>^e:kC[]Bg4jkD[]>
^`00C[]B^djkD[]>^`80000MD[]>V`00CYYB^djJD[]>VU:kCYYB^djJD[/005:kCYYB^djJD[]>VU:k
CYYB^`00D[]>VU:KCYYB^`0200007dijCY/004jJCWY>VTijCYY>NTjJCWY>VP00DYY>NTjJCWUBVTij
CYY>NE:JCWX004iiDYY>NDjJCWUBVTii00@0000LCWY>NE9jCWU>NTiiDWY>NDij001BVTiiDWY>NE:J
CWUBNTiiDYY>N@00CWUBVTiiDYY>NE:JCWT200005U:J001B^U:JE[YBVU:jDYYF^U:JD[YBVUJj001F
^e:jE]]B^UJk001Ffe:j0P0000aK7000FcaK75/lFaaK?5/LFcaK75/lFa`200003F>M001S_UnMGkeO
WF>n001OgEnlHmeO_5oM00800006GkeOgEnlHmeO_@000Woo00<007ooOol01Woo00<007ooOol00Woo
00<007ooOol0:7oo001NOol2000>Ool30003D]`04e;KD]`005;LC]]Bg5;KD]a>fe;LD]]Bg000D]aB
fe;LC[]Bg5;K0080000JD[]>^`00C[]B^djkD[]>^e:kC[]B^djkD[/005:kC[]B^djkD[]>^e:kC[]B
^`00D[]>^`<0009>^`04CY]>^`00C[/3CY/04DjkCY]>VdjKC[]>V`00CYY>VdjJCY]>VTjKCYY>VdjJ
00000TjJ0`000djJ00e>NP00CWY>VTijCYY>NTjJCWY>VTijCYX00002CWX01DjJCWY>NTijCYX00Tij
00@004jJCWY>NP@00006CWU>NTii001>NDij0dii01E>NTiiCWU>N@00CWU>NTiiCWY>NDijCWU>NTii
CWY>N@00CWUBNTiiDYX00P0015:J00<005:jDYX00U:J00eB^U:JDYYBVU:jDYX005:jE[]B^UJkD[YF
^`0200001U[kF_aFn`00FaaK?0=K7003FcaK75/L008000=OO@04Gid00000Gid20005Gmd00`00GmeO
_@03Gmd200001EnM001oogoo00001goo00<007ooOol00Woo00<007ooOol0:7oo001KOol3000=Ool3
00005U;LC]]Bg4jkD]a>fe;LC[]Bg000D]a>^e;LC[]Bg4jkD]a>^e;L001Bg4jk0`0001Q>^e;LC[]B
g4jk001>^e;LC[]Bg4jkD]a>^e;LC[]Bg000D[]>^e;LC[]B^djkD]`400006djKD[]>VU:kCY]B^djJ
D[/005:kCYYB^djJD[]>VU:kCYYB^djJ001>VU:kCYYB^djJD[]>VP04000074jKCWY>VTijCY]>NTjJ
CWX004ijCYY>NTjJCWY>VTijCYY>NP00CWUBVTijCYY>NE:JCWY>VTii1000021>NTiiCWY>FDijCWU>
NP00DWY>NDijCWUBNTiiCWY>NE9jCWT004iiDYY>NE9jCWUBVTiiDWY>NE:J001BVTii0P0001IBVTii
DYYBNE:JCWT005:JD[YBVUJjDYYB^U:JE[YBVU:jDYX005:jE[]B^P<0000KE_]K75KkF_aFn`00FaaK
?5/LFcaK75/l001SWEmmHieOO6>MGgeSWEml001O_5oMGkaSgEnl00800004HmeO_EoMGk`200001Enn
GieO_UnM00000Woo00<007ooOol017oo00<007ooOol00Woo00<007ooOol0:7oo001IOol20003Ool0
0`00Oomoo`08Ool20002D]`00`00D]]Bg002D]`03e;KD]aBg5;LD]/005;KD]a>fe;LD]]Bg4kKD]aB
f`0300005djkD]a>^e:kC[]Bg4jkD[]>^`00C[]B^djkD[]>^e:kC[]B^djk001>^e:kC[/010000djk
00D004jkC[]>^djK00=>^`04CY]>^`00C[/3CY/02DjkCY]>VdjKC[/004jKCYY>V`040003CYX00`00
CWY>VP02CYX044ijCYY>VTjJ001>VTijCYY>NTjJCWY>VTijCYY>NP000dij00=>VTij00000P000Tii
00<004ijCWT00Tii00I>NTiiCWU>NDij0002CWT01DijCWU>NDiiCWX00Tii00/004ijCWU>NTiiCWY>
NDijCWU>NTii00<000UBVP03001BVU:j00=BVP07D[YBVU:JDYYB^P00E[/00P0000EFne[k001Jo5Kk
009Jn`06F_aFn`00FaaK?5/L0P0000EOWEmmGgeOOEnM009OO@800004Gkd00000Gmd20002Gmd015nm
Gmd000001enM00<007oo00001Woo00<007ooOol00Woo00<007ooOol0:7oo001FOol30005Ool00`00
Oomoo`05Ool300005TkKD]a>^e;LC]/004jkD]a>fe;LC[]Bg4kKD]a>^`00C[]Bg4jkD]a>^e;L0P00
01I>^e;L001Bg4jkD]a>^e;LC[]Bg4jkD]`005;LC[]Bg4jkD]a>^e;LC[]Bg0@0000KCY]B^djKD[]>
Ve:kCY/004jJD[]>Ve:kCYYB^djKD[]>VP00CYYB^djJD[]>VU:kCYYB^djJ00@0000NCY]>NTjKCWY>
VdijCY/004jJCWY>VdijCYY>NTjKCWY>VP00CYY>NTjJCWY>VTijCYY>NTjJ001>VTii0`00025:FDij
CWU>NTYI001>NDijCUU>NTiiCWY>FDijCWT004iiDWY>NDijCWUBNTiiCWY>NE9j001BNTiiDYY>NE9j
CWT00`0001M>N@00DWUBVTiiDYYBNE:JCWUBVU9iDYX005JjDYYB^U:JE[YBVU:jDYYF^U:J0080000=
FaaFne[lE_/005KkF_aFne/LE_]Jo000Fc`00P0000iOO6>MGgeSWEmlHieOOF>M001SgEnlHmeO_6?M
0P0000=O_6?MGkd00P0000UO_UnMGkiOWEnnGieO_UnMGkh00P0000=oo`00Ool017oo00<007ooOol0
0Woo00<007ooOol0:7oo001DOol2000=Ool30009D]`00`00D]]Bg002D]`025;KD]aBg5;LD]/005;K
D]`300005U;LC[]Bg4jkD]`005:kC[]Bg4jkD[]>^e;LC[]B^`00D[]>^e:kC[]B^djk0P000Tjk00<0
04jkC[/01djk00<004jKC[/00Tjk00Q>VdjkC[]>^djK001>Vdjk0djK0`0000=>VTjK00002DjJ00<0
04jJCWX00djJ00e>NTjJCYX004ijCYY>NTjJCWY>VTijCYY>NP030003CWT02DijCWU>NDiiCWY>N@00
CWU>NP03CWT01DijCWU>NDii00000dii00U>NTiiCWU>NDijCWT004iiCWX0100000I>NE9iCWUBNTii
000:DYX01000DYYBVU:j0e:J00=B^P0000000UKK00D005[kF_]Jo000009Jn`06F_aFne[kF_]Jo000
0Umm00IOWEmmGgeOOEnMGgd2000016?MGkeSgF>m0P000V?L0`002EnM0P000U]M00<007oo000017oo
00<007ooOol00Woo00<007ooOol0:7oo001AOol3000=Ool200005TkKD]`005;LC]]Bg4jkD]a>fe;L
C[]Bg000D]a>^e;LC]]Bg4jkD]a>fe;L0`0001IBg4jkD]a>^e;LC[]Bg4jkD]`005;LC[]Bg4jkD]a>
^e;LC[]Bg000D]a>^`<0000KC[]B_4jkD[`005:kCY]B^djKD[]>Ve:kCY]B^djK001>VU:kCY]B^djJ
D[]>Ve:k001B^djJ00<0000OCYY>VdijCY]>VP00CWY>VdijCY]>NTjKCWY>VdijCY/004jJCWY>Vdij
CYY>NTjKCWX004ijCYY>NTjJCWX00`00021:FDij001>NTYICWY>NDijBUU>NTiiCWX004ijCWU>NTiI
CWY>NDijCUU>NP00CWY>NE9jCWU>NTiiDWY>NDij0`0001UBVTiiDYY>NE:JCWUBVTiiDYX005:JDWUB
VTiiDYYBNE:JCWUBVU9i001BVUJjDYYB^P0300003UKKE]YJfeKJ001Fne/LE_/005KkFaaFne[lE_/2
00004emM000005mmHieOO6>MGgd005nlHmeO_6?MGk`005oLHmeOg6?m00800008Gk`005nMGkiOWEnn
GieO_P8000=KG@04GgeKG@000005Ool4000[Ool004ioo`@000aoo`<000EBg003001Bg5;L00MBg003
001Bg5;K00=Bg00ID]/00000D]a>f`00C[]Bg4jkD]a>^e;LC[]Bg4jk001>^e:kC[]Bg4jkD[]>^e;L
C[/00`0024jk00<004jkC[/024jk00<004jKC[/00Tjk00=>VdjkC[/00`0000Y>VTjKCYY>VdjJCY]>
VTjKCYX000U>VP04001>VTjJCWX3CYX01DijCYX004jJCWX00`0000Q>NDijCWU>NTii001>NDij0dii
00I>NTiiCWU>NDij0002CWT01DijCWU>NDiiCWX00Tii00<004ijCWT00Tii00A>NP000000009>N@0<
001>NE9jCWUBNDiiDWY>NE9iCWUBNP002U:J00@005:J000000QFf`07001Fne[k001Jo5KkF_/00P00
00EOG5mMGeaOGEmL00800007Gid00000HkeSgEnmHmd00P0000EOg6?LHmaSg@00009S_@04HmeO_@00
0002Gid20007Fed00`00Ool0000cOol004aoo`8000Aoo`03001oogoo00Ioo`<0000FD]a>fe;LC]]B
g4kKD]a>fe;L001Bg4kKD]a>^e;LC]]Bg4jkD]`005;LC[/300005TjkD]a>^e;LC[/004jkD]a>^e;L
C[]Bg4jkD]a>^`00C[]Bg4jkD]a>^e;L0P0001Y>^e;L001B_4jkD[a>^e:lC[]B_4jkD[`005:kCY]B
^djKD[]>Ve:kCY]B^`00D[]>VU:k100001m>VTjK001>VdjJCY]>NTjKCYY>VdijCY]>VP00CWY>Vdij
CY]>NTjKCWY>Vdij001>NTjJCWY>VdijCYY>NP03000084YICWY:NDijBUU>NTYiCWY:F@00CWU>NTYI
CWY>NDijBUU>NTii001>FDijCWU>NTiICWY>NDijCUT004iiCWX300006U9jCUUBNTiiDWX005:JCWUB
VTiiDYY>NE:JCWUBVTii001>NE:JDWUBVTiiDYYBNE:JCWT300002eKJF]]FfUKKE]YJfeKJE]]FfU[K
E]X00`0001MFn`00001OOEmLGeeOG5mmGeaOGEmLGgd006?MGkaSgEnlHmd006?mGmaSgEoL00800007
HmeO_6?MGkeSgEnlHmd00P0000=KGEmmFed00U]M00AOOE]MFeeKG@800003Ool007oo035oo`00BGoo
0`003Goo0P000U;L00<005;LD]`025;L00<005;LD]`01U;L0`0001I>fe;LC]aBg4kKD]a>g5;LC]/0
04jkD]a>^e;LC[]Bg4jkD]a>^`00C[]B^`<0009>^`03C[a>^`0000U>^`03001>^djk00M>^`@000=>
V`0?CYY>VdjK001>VTjKCYY>VdjJCY]>VTjKCYY>V`0000U>VP04001>VTjJCYX40002CWX02`00CWY>
NDijCWU>NTiiCWY>NDij00000Tii00E>NTiiCWU>NDij00=>N@05001>NDiiCWU>NP03CWT014ij0000
00002Dii00`0059iCWUBNTiiDWU>NE9jCWUBNDii0006DYX200000e:jE[X00009E]/3000035[l0000
05mLGeeOG5mMGeaOGEmLGeeOG0800004Hkd00000Gkd200001V?MGmaSg6?L001O_@9S_@04HmeO_F>m
Hkd200000enM001KG@06Fed2000015LLEcd00000<Woo0017Ool2000=Ool3000054kKD_a>g5;LC]/0
04kKD]a>fe;LC]]Bg4kKD]a>fe;L001Bg4kKD]`400005DjkD]`005;LC[]Bg4jkD]a>^e;LC[]Bg000
D]a>^e;LC[]Bg4jkD]a>^`04000065;LC[]Bg4jkD]a>^e;LC[/004jkD[a>^e:lC[]B_4jkD[a>^`00
CY]B^djKD[]>V`<0000NCYY>^`00CY]>VTjkCYY>VdjJC[]>VP00CWY>VdjJCY]>NTjKCYY>VdijCY/0
04jKCWY>VdijCY]>NTjK1@00025>NTYiCWY:NDijBWT004YiCWY:FDijBWU>NTYICWY:NDij001>NTii
CWY:FDijCWU>NTYICWX004ijCUU>NTiiCWX00`0001a>NDiI001>NE9jCUUBNTiiDWY>FE9jCWT004ii
DYY>NE:JCWUBVTiiDYY>NE:J001BVTiiDYYBN@80000;E[]B^UJjDYX005KJE]]FfU[KE]YFf`030000
3EKKE]YJf`00Ged005mmGeaOGEmLGgeOG5mM00800005HkaS_F>LHkeS_00200000f?mGmaSg@020000
1UnmHmeO_6?MGkeSg@800005GgeOWEmmHid00002Fed02EmmFed00000FceG75/mEaaK?@02000aOol0
04Eoo`8000aoo`<000UBg003001Bg5;L00MBg0@00003D]a>g5;L009Bg00@C]aBg000D]a>fe;LC]aB
g4kKD]a>g5;L001Bg4jkD]`4000014jkC[a>^`000djk00M>_4jkC[]>^djlC[/00008C[/00`00C[]>
^`030003CY/00djkCY/00002CY/01DjJCY]>VdjKCYX00TjK00/004jJCY]>VTjKCYY>VdjJCY]>VP00
00=>VP@000=>NP03001>NTij00I>NP0;001>NDijCWU>NTiiCWY>NDijCWT00003CWT01DijCWU>NDii
CWX00Tii00<004ij00000P0000=>NDiICWT00Tii00<004iiCWT024ii00d004iiDWU>NE9jCWUBNDii
DWY>NE9i001BVP020002E[X01U:jE[YF^UJjD[X0009Ff`<000AFf`80000<Gc`005mM001OGEmLGeeO
G5mM001S_F>l0f>m00AS_000HmaSg0<00006HmeO_F>mHkeSgEnm0P0000=OWEmmGid00UnM00AOO@00
FeeKG@800007EaeK?ELLEceG7E/mEa`00P00<Goo0015Ool30009Ool2000054kKD_`005;LC]]Bo4kL
D]a>fe;lC]aBg4kK001>fe;LC]]Bg4kKD]`200005DkLD]`005;LC]]Bg4jkD]a>fe;LC[]Bg000D]a>
^e;LC[]Bg4jkD]a>^`0400006U;LC[]Bg4jkD]a>^e;L001Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C[]B
_4jkD[a>^e:lC[/3000074jJC[]>VdjkCYY>^djKC[]>VP00CYY>VdjJC[]>VTjKCYY>^`00CY]>NTjK
CYY>VdijCY]>VTjK100002A:NDjJBWY>NTYiCYY:NP00BWU>NTYiCWY:NDijBWU>NP00CWY:NDijBUU>
NTYiCWY:FDijBWT004YICWY>NDijBUU>NTiiCWX300007DiiCUU>NTiICWU>FDijCUU>N@00DWY>NE9j
CUUBNTiiDWY>FE9j001BVTiiDYY>NE:JCWUBVTiiDYX00`0000YF^U:JE[]B^UJjDYYF^e:jE[YBVP80
0005E]]FfU[KE]YFf`0200002E/KGcaK6ell001OG@00GgeOG00200001F>mHkaS_F>LHkd00P0000IS
g6OlHmaSg000Iod200003EnlHmd00000GgeSWEmmGieOOF>MGgeOWEmm0080000:FceG75/mEaaK?ELL
FceG75/mEa`3000_Ool004Eoo`<000Ioo`<000EBg003001Bg5;L00QBg003001Bg5;L00<00006D]a>
g5;LD]`004kL0e;L00a>g5;LD]aBg4kL001>g5;LC]]Bg4kLD]`200003TkLD]`004jlC[]Bg4jkC[a>
^e;LC[]>_000C[`3C[/01TjlC[]>^djkC[`000=>^`@00004CY]>^`00C[/3CY/01djkCY]>VdjKC[]>
V`00009>V`0<CYY>VdjKCY]>VTjK001>VdjJCY]>VTjK0`0000=>VTYj00000Tij00E:NTijCWY>NTYj
009>NP03001>NTij00I>NP0<001>NTiiCWY>NDijCWU>NTiiCWX004ij0dii00M>NP00000004iiCUT0
0002CWT01DiICWU>NDiiCUT00Tii00<004iiCWT024ii00L0059jCWUBNDiiDWY>N@0200000e:JDYT0
0002E[X01E:jE[YF^UJjD[X00`0000=B^P00E]/00UKK0P0000UO?5/LGcaO75llFaaO?000Ged00P00
0V>m00ES_6>mHkeS_@0000ASg08000ASg08000=OW@06GgeOWEnMGieOOEnM0P0000aK?@00EaeK?ELL
EceG7E/mEaaG?ELMFcd3000_Ool004Eoo`04001oogoo0002Ool300004e;lC]aBo4kKD_a>g5;lC]]B
o000D]a>fe;lC]aBg4kKD_a>g5;L00<0000ED]a>fe;LC]aBg4kKD]a>g000C[]Bg4kKD]a>^e;LC]]B
g4jk001>^e;L00<0000HD]a>^e;LC[]Bg000D]a>^e;LC[]Bg4jkD]a>^e;L001Bg4jkD]a>^e;LC[]B
g4jk100001e>^djKC[a>VdjkCY]>_000C[]>VTjkCY]>^djJC[]>Vdjk001>^djJCY]>VTjkCYY>VdjJ
001>VTjK00<0000UCYY:NTjKBWY>VP00CYY:NTijBWU>VTYjCWY:NDjJ001>NTYiCWY:NDijBWU>NTYi
001:FDijBWU>NTYICWY:NDijBUU>NP00CWX00`0001m>NDYICWY:FDii001>NTiICWU>FDijCUU>NDiI
CWY>F@00CUUBNTiiDWY>FE9jCWUBNTiI001>NE:JCWUBVP0200002E:IEYYBVE:J001F^e:jE[YBVP03
00001U:JE[]B^UJj001Jf`80000:Fa]O?5/KGcaK6ellFa]O?5/KGc`200001f>LHkeS_6>mHiaS_@00
009Sg005IoaSg000HmaWo@03Hm`2000026>m001SWEmmGieOOF>MGgd2000035mMFcaKGE/l001G75/m
EaaK?ELLFceG70800003EaeBo00002moo`00>goo10001Goo00<007ooOol010000U;L00<005;LD]`0
25;L00<005;LD]`015;L0P0000=Bg4kL00000U;L00E>g5;LD]aBg4kL009Bg003001>g5;L009Bg004
C]aBg5;LD]`300001U;LC[]>g4kLD]a>^`9>g00=D]`004jlC[]Bg4jkC[a>^e;LC[]>_000C[`00djk
00I>_000001>^djl0003C[/024jKC[]>^djkCY]>^`00C[/3CY/01TjkCY]>VdjKC[/000=>V`04CYY>
VdjKCY/300001TjJBWY>NTijCYY:NP9>NP03CYX004ij009>NP07BWY>NTijCWY:NTij000024ij00P0
04iiCWY>NDijCWU>NTii100000E>NDiICUU>FDii00=>F@03CWT004ii009>N@07CUU>NDiiCWU>FDii
00002Tii00@004ii000000=BVP04DYUBVU:JDYX400001E:jE[YF^UJjD[X00eJj00/005llGaaO?5/L
GcaO75llFaaO?5lL00800004Hid00000Hk`2Hkd20004Hm`00`00HmaSg003Hm`00`00HkeS_@02Hkd2
0002Gid20002Fed02U/mFeeKGE]M001G?ELMFceG75Lm0P0000AFo5LLE_aG708002ioo`00>Woo00<0
07ooOol00Woo00<007ooOol00Woo0`0001E>g5;lC]aBo4kLD_a>g000C]]Bo4kLD_a>fe;lC]aBo4kK
D_`005;LC]/00`0001E>fe;lC]aBg4kK001>g5;LC]]Bg4kLD]a>fe;LC]`004jkD]a>fe;LC[/00P00
01UBg4jk001>^e;LC[]Bg4jkD]a>^e;LC[/004jkD]a>^e;LC[]Bg4jkD]a>^`00C[]Bg003000074jl
C[]>_4jk001>VdjlCY]>^djKC[a>VdjkCY/004jKC[]>VTjkCY]>^djJC[]>V`00CYY>^djJ100002=>
VdYj001:NTjJBWY>VdYjCYY:NTjKBWX004YiCYY:NTijBWU>VTYjCWY:N@00BWU>NTYiCWY:NDijBWU>
NP00CWY:FDij00@0000QBUU>NDYI001:FDiiBUU>NTYICWU:FDijBUT004iICWY>FDiiCUU>NTiICWU>
FDij001BNTiIDWY>NE9jCUUBNTii00<00007DYUBVU:IEYYBVE:JDYT0100000QF^e:jE[YBVUJkD[YF
^U:J0P0000mJn`00GcaK6ellFa]O?5/KGcaK6`00HgaSWF=lIid00P0000=SW000Hm`00V?L00EWo000
001Sg6Om009Sg0800007HkaS_F>lHkeS_6>mHk`00P0000aKGE/lGeeK?5]MFcaOGE/lFed005/mEa`2
00001eLMD_aG7E;lEaeBo5LM008002eoo`00>Woo00<007ooOol00Woo00<007ooOol00Woo0P002E;L
00<005;LD]`01e;L0`0000E>g5;LD]aBg4kL00=Bg005C]`005;LD]a>g003D]`01DkLD]`005;LC]`0
0`000dkL00IBg4kL001>g5;LC[/2C]`03E;LC[]>g4kL001>^djlC[]Bg4jkC[a>^e;L00<00005C[a>
^djkC[]>_003C[/00`00CY]>^`02C[/024jKC[]>^djkCY/004jKC[/3CY/00djkCY]>V`0400000djJ
CY]:NP02CYX01TjK001>NTijCYY:NP9>NP06CYY:NTijCWX004Yj0dij00I:NTijCWY>NTYj0007CWX4
0002CUT01TiiBUU>FDiICWT0009>F@05CWU>FDiICUU>N@03CUT00`00CUU>N@02CWT01TiICWU>NDii
CUT000E>N@<0009BN@05001BVU:JDYYBV@0300001E:IDYYBVP00D[X00eJj00AB^UJj000000AJn`06
001O?5lLGcaK75ll0P0000ISO6>MHiaSWF=lHid30003Hm`00`00HmaSg003Hm`00`00HkeS_@05Hkd2
00001Emm001KGE]MFcd00e]M00=K?E]MFed00`0000]Fo5LLE_aG75KlEaaFo5LLE_aG700002eoo`00
>Woo00<007ooOol00Woo00<007ooOol00Woo01<007oo001>g5;lC]aBo4kLD_a>g5;lC]`004kKD_a>
g5;lC]]Bo00200005DkLD_`005;LC]]Bo4kLD]a>fe;lC]aBg000D]a>g5;LC]]Bg4kLD]a>f`030000
5djkD]a>^e;LC[]Bg4jkD]a>^`00C[]Bg4jkD]a>^e;LC[]Bg4jk001>^e;LC[/0100001Y>g4jk001>
^djlC[]>_4jkC[a>^djlC[/004jKC[a>VdjkCY]>_4jKC[]>V`00CY]>^djJ100002=>VdZJ001:NTjK
BWY>VdYjCY]:NTjK001>VdYjCYY:NTjKBWY>VTYjCY/004ijBWU>VTYjCWY:NDjJBWY>NP00CWY:NDij
00@0000SBUU>NP00CWU:FDijBUU>NDYICWY:FDii001>NTYICWU:FDijBUU>NDYICWX004iiCUU>NTiI
CWU>FDijCUU>NDiI001>N@0300001diiDYY>NE:JCWT005:I00<0000;DYUFVU:IDYYBVEJJDYT005:J
E[]B^P020003F_/04E[KF_]Jn`00Fa]O?5/KGc`006NMHgaSWF=lIieSO6>MHg`00P0000=Wg0000000
0P0000=Sg6OmHm`00P0000US_F>lHkeS_6>mHkaS_@00Hid00Umm00MOO000FcaKGE/lGeeK?0030000
3ELLFcd005LMD_aG7E;lEaeBo5LMD_aG7E;l008002aoo`00>Woo00<007ooOol00Woo00<007ooOol0
0Woo0P0000=oo`00D]`025;L00<005;LD]`00`000e;L00E>g5;L001Bg4kL00=Bg005C]aBg5;LD]`0
0003D]`40002C]`00`00D]a>g002C]`02U;LC]a>g4kLD]a>g000C]aBg4jk0TkL00=Bg4jkC]`01000
00Y>^djlC[]>_4jkC[a>^`00C[]>_0=>^`06C[a>^djkC[/004jK0djk00=>VdjkC[/01@0000U:VdjK
CY]>VdZKCY/004jKBWX00TjJ00I>VdYjCYY>VTjK0002CWX02TjJBWY>NTijCYY:NTij001>NTYj0dij
00=:NTij0000100000Y>NDYICUU:FDiiBUT004iICWU:F@9>F@05CWU:FDiICUT00003CUT01DiiCUU>
FDiICWT00TiI00<004iiCUT00dii00=>FDiiCWT00`000U9i00E>NE9iDWUBNDii00<00005DYUBVU:J
DYYBV@03DYX015:IDYX005Jj0P002E[k00d005/L000006>MHgaSWF>LHieSO6>MHi`00002Im`01@00
Im`006OLIm/00`001f>m0P001Emm00<005]MFed00`0000=G75LMEa`00ULL00]G7@00EaaFo5LLE_aG
75KlEaaFo5LL00<002]oo`00>Woo00<007ooOol00Woo00<007ooOol00Woo00d007ooOomoo`00C]aB
o4kLD_a>g5;lC]aBo00300004U;lC]aBo4kLD_a>g5;lC]aBo000D]a>fe;lC]aBg4kKD_a>g0@0000F
D]a>fe;LC]aBg4kKD]`005;LC[]Bg4jkD]a>^e;LC[]Bg4jk001>^e;LC[/400006E;LC[/004jkD]a>
^dkLC[]Bg4jkC]a>^`00C[]>_4jkC[a>^djlC[]>_000C[]>Vdjl00@0000SBY]>^dZK001:VTjKBYY>
VdZJCY]:VTjK001>VdYjCY]:NTjKBWY>VdYj001:NTjKBWY>VTYjCY]:NTjJBWX004YjCWY:N@040000
9TijBUT004YICWY:FDijBUU>NTYICWY:F@00BUU>NDYICWY:FDiiBUU>NTYI001:FDijBUU>NDYICWY:
FDiiBUT004iICWU>FDijCUT3000024iIDWT005:JCWUBVTiiDYX200003DiiDYY>N@00DYUFVU:IDYYB
VEJJDYUBVU:I00800003F_]Jfe[k009Jn`05F]]Jne[kF_]Jf`02F_/07`00HgaWWF=lHieSO6NMHgaS
WF=l001Sg6OLHkaWg000IoaSffOlIm/006>k001S_6>mHkaS_F>l001OO6>M009OO@04GgaSWEmmGgd2
000045LLFceG75/mEaaK?ELLFceG7000D_aG7E;lEaeBo5LM0`0000=FoE;l0000:goo000jOol00`00
Oomoo`02Ool01@00Oomoogoo00001Goo00@005;LD]aBg0@0009Bg003001>g5;L009Bg006C]aBg5;L
D]a>g0000U;L00A>g5;LD]aBg0800003C]aBg000009>g005D]a>g4kLC]aBg002C]`00`00D]a>g002
C]`01E;LC]a>g4kLD]`01000015>_4kLC[a>g4jlC]a>_000C[]>_4jkC[a>^djlC[]>_000009>^`06
C[a>^djkC[]>_4jk10000djK00E:VdjKCY]>V`0000=>V`09BY]>VdjKCY]:VdjK001>VdYj009>VP06
CY]:NTjJCYX004Yj0Tij00A>VTYjCWY>NPD0000ABUU:NTYICWY:FDYjBUT004YICUU:FDiiBUU>FDYI
CWT00002CUT02DiiBUU>FDiICWU:FDiI001>N@03CUT024iiCUU>FDiICWU>F@00CWT30002CWT01TiI
CWU>N@00CWUBN@<000=BN@05CWUBN@00DYYBV@03DYX01e:IDYX00000E[YFfP0000UJn`800008He`0
06=lHieSW6>MHgaSW@8000AWg0800004Im]Wo0000003Im`200000f>m00000007Ggd200001E/m001G
75LLEad00eLL00MG7ELLEaaG7000E_aG700300001EKlD_aFo5;lE_`00P00:Woo000kOol40004Ool0
0`00Oomoo`04Ool3000054kLD_e>g5;lC]aBoDkL001>g5;lC]aBo4kLD_a>g5;lC]`004kLD]`30000
5U;LC]aBo4kLD]`005;LC]aBg4kKD]a>g5;LC]]Bg000D]a>^e;LC[]Bg4jk0P0001U>g4jk001>^dkL
C[]Bg4jkC]a>^e;LC[/004jkD]a>^dkLC[]Bg4jkC]`004jlC[]>_00400008TZKC[`004jkBY]>^dZK
C[]:VdjkBY]>^`00CY]:VTjKBYY>VdZJCY]:VP00BWY>VdYjCY]:NTjKBWY>V`00CYY:NTjK100002Q:
FTijBUT004YICWY:FDijBUU>NTYICWX004ijBUU>NTYICWY:FDijBUU>NP00CWY:FDiiBUU>NTYICWU:
FDij001>NDYICWY:FDiiBUU>NP@00008CUUBNDiIDWU>FE9iCUUBN@<0000>DYY>NE:JCWUBVTiiDYY>
NE:J001BVU:IEYYBV@800005F]]F^U[KE[X00002F_/02e[KF_]Jne[kF]]Jn`00HeaOFf=LGe`00P00
00QWWF=lHid006OLHmaWg6>l0P0000IWo6?K000006OLHk/3Im`01V>kIm`005mmGgaSW@9OO@0BGgaS
WEmm001K?5mMFcaKG@00FceG75/mEaaK?ELLFceG75/m0`0000UFoE;lE_aBo5KmD_aFo5;lE_d00P00
:Goo0013Ool20006Ool01000D]aBo4kL0U;L00ABo4kLD]aBg08000=Bg004C]aBg5;LD]`300002U;L
C]aBg4kLD]a>g5;LC]aBg0000TkL00EBg4kLC]a>g5;L009>g003001Bg4kL00<000A>g00C001>g4jl
C]a>_4kLC[a>g4jlC]`004jlC[]>_4jkC[a>^djlC[/0100000Y>_4ZKC[]>^djlBY]>^`00CY]:V`=>
V`05BY]>VdjKCY/00003CY/02DZKCY]>VdjKBY/004jJCY]:NP02CYX00djKBWX000030007BWX05@00
BWY:FDijBUU:NTYICWY:FDYj001>NDYICUU:FDiiBUU>FDYI001:F@02CUT02TiiBUU>FDiICWU:F@00
CUU>NDiI10000diI00H004iiCWU>NDiICWT3000014ii001BNDii0e9i00I>NE9iDWUBNDii0002DYX2
000025JjE]YF^UKJE[YFfUJj0005F_/20007He`00`00Hid00004Im`01@00Im]Wg6OKIo`00P001FOL
0P0000=S_@00Ggd015mm0P000U/m00AK?5/mFcd000=G7003EaeG75LL00<0009Fo00:001Bo5KlD_aF
o5;lE_aBo5KlD_`2000YOol004=oo`03001oogoo00Ioo`0>001>g5;lC]aBoDkLD_a>g5;mC]aBo000
D_a>g0@0000FD_a>g000C]aBg4kLD_a>g5;LC]aBo4kLD]`005;LC]aBg4kKD]a>g5;LC]/300005Tjk
D]a>_4kLC[]Bg4jlC]`005;LC[]>g4jkD]a>^dkLC[]Bg000C]a>^e;L1000029:^djl001>_4ZKC[a:
VdjlBY]>_4ZKC[`004jkBY]>^dZKC[]:VdjkBY/004ZJCY]:VTjKBYY>VdZJCY/004jKBWY>V`@0000X
BWY>N`00CWY:FDijBUY>NTYICWY:FTij001>NTYICWY:FDijBUU>NTYI001:FDijBUU>NTYICWY:FDij
BUT004YICWY:FDiiBUU>NTYICWT400002TYHCWU>FDiiBUQ>NDiI001>FE9i0`0000mBNDiIDWU>FE9i
001BVTiiDYY>NE:JCWUBVTiiDYX00`0000]JfeJjF]]F^U[KE[YJfeJjF]]F^P00009Jn`0<F]/005mL
HeaOFf=LGeaSG5mKHeaOG6=L0P0000MSg6OLHk`006OKIoaSf`0200000fOLHk/00002Im`01V>k001S
W6NmHiaW_@80000>Gg`00000FeeK?5mMFcaKGE/lGeeK?000EaaK?@<0000?EaeBo5LLD_aG7@00E_aB
o5KmD_aFo5;lE_eBo5Kl00<002Qoo`00@goo00<007ooOol01goo00@005;LD_a>g09Bg004D_a>g5;L
D]`300004dkLD]a>g5;LC]aBg4kL001>g5;LC]aBg4kLD]a>g5;LC]aBg000009>g003D]`000000080
009>g003001>g4kL00M>g009001>g4jlC]a>_4kLC[a>g4jl00@000=>_005B[]>_4jl001:V`02C[/0
1djlBY]>^djkC[a:V`00009>V`05BY]>VdjKCY]:V`02CY/00`00BY]>V`02CY/00dZKCY]>V`040006
BWX00`00BWY:NP07BWX05P00BUU:NTYICWY:FDYjBUU>NP00CUU:FDiiBUU>FDYICWU:FDiI001>NDYI
0TiI00M>N@00000004iIBUT00008CUT30003CWT01TiICWU>NDiiCUT0009BN@05CWUBNE9iDWU>N@02
00003eJJDYT005JjE]YF^UKJE[YFfUJjE]YF^UKJ001Jn`02000:He`00`00IkaW_00400000fOLIm/0
0004Im`03@00Im`00000HiaS_F>LIkeSW6>mHi`005/l00=K?@06FcaK?E/mFceK?5/m0`000UKl00EG
75KlE_aFo5LL009Fo006001Fo5;lE_aBo5Kl0`0000AFo5;l000002Moo`00@goo0P002Goo00L004kL
D_a>g5;mC]aBo00200002dkLD_d005;mC]aBo4kLD_e>g5;lC]`00P0000QBg4kLD_a>g5;LC]aBo4kL
10000TkL01EBgDkLC]a>g5;M001>g4jkD]a>_4kLC[]Bg4jlC]`005;LC[]>g4jkD]`00P00029:^dkL
001>_4ZkC[a:^djlB[]>_4Zk001:VdjlBY]>_4ZKC[a:VdjlBY/004ZKC[]:VdjkBY]>^dZKC[/004jK
BYY>V`@00004BWY:V`00CW/3BWX08dikBWY:NTYj001:FTijBUU>NTYJCWY:FDijBUX004YICWY:FDij
BUU>NTYICWX004ijBUU>NTYICWY:FDijBUU>NP00CWT00`0000]>FDYHCUU:FDiI001>NDiICWU:F4ii
00<0000ACWT0059iCUUBNDiIDWU>FE9iCUUBNDiI001>NE:JCWUBVP0200006e:IE[YBVEJJ001JfeJj
F]]F^U[KE[YJfeJjF]]F^U[K001SG5mLHeaOFf=LGeaSG5mKHeaOG00200001f^lIkaW_6NL001Wff_k
0080009Wg00<Hk]Wg6OLIm`006NmHiaW_F>LIkeSW6Nm0P0000UOG000FcaOGE/lFeeK?5mMFc`00P00
00mK?ELL001Bo5LMD_aG75;lEaeBo5LLD_`005;lE_`00`0000MFo5;LE_aBg5KlD]`0000WOol0049o
o`8000]oo`03001Bg5;l00<0000CD_a>g5;lC]aBo000D]a>g5;LC]aBg4kLD]a>g5;L001Bg4kLD]`0
10000TkL00<004kLC]`01dkL00<004kLC]`01TkL00<004jlC]`00`000Tjl00=>g4jl00000Tjl00E:
^djlC[a>_4Zk009>_006001:VdjkC[]>_4ZK0Tjk00=>_4ZK00000TjK00=:VdjKCY/01P0000M:NdYj
BY]:NTYkBWX00008BWX00`00BWY:NP07BWX04@00CWY:FDYjBUU>NTYIBWY:F@00BUU>FDYICWU:FDiI
BUT0100000]>FDYICUU:FDiIBUU>FDYICUT004iI00<000E>F@03001>NDiI00=>N@05CUU>NDiiCWT0
0002DWT2000045JJDYYFVU:IEYYBVUJJ001FfUJjE]YF^UKJE[YFfUJj0P0000=O6`00He`01f=L00<0
06NlIk`00fNl00H006OKJm][f`00Jm/20002Im`200001VNm001S_F>LIkeSW0800006HgeOO5mmGg`0
05/l0e/m0P0000=G75/MEa`00ULL00D005KlE_aFo5LL00=Fo005Ea`00000001Fo003D_`01EKlD_aB
o5;lE_`00P009Woo0012Ool00`00Oomoo`0;Ool200004U;mC]aBoDkLD_e>g5;mC]aBo@00D_e>g5;l
C]aBoDkLD_a>g0@00009D_e>g5;mC]aBoDkLD_d005;M00=>g00=D]e>g4kLC]`004jlC]a>^e;LC[a>
g4jkD]`00`0001Y>g4ZlC]a:^dkLB[a>g4Zk001:^djlB[]>_4ZkC[a:^djlB[/004ZKC[a:VdjlBY]>
_4ZK1`000TZK00i:NTjK001:VdYjCY]:NTZKBWY>VdYj001:NTik0dYj01U>NdYjBWX004ijBUY>NTYI
CWY:FTijBUU>NP00CWY:FDijBUU>NTYICWY:F@00BUU>NP0400003DYICUU:>000BUU>FDYHCUU:FDiI
BUQ>FDYI0080000BCWU>FDiiBUQ>NDiICWU:F000CUUBNDiIDWU>FE9iCUUBNDiI0`0001ABVEJJDYUF
^U:IEYYBVEJjDYT005JjF]]F^U[KE[YJfeJj001K6elL0UlK00X006=LGeaSG5mKHeaOG000Iia[_09W
_00:Ii`006OKJo]Wf`00Im][nfOJJo/200001V>LIkeSW000HiaW_@800009GeaSOEmLHgeOG6=m001K
GE/l0080000>FaeG75/mEaaK7ELLFcd005LLD_aG7E;lEaaBo080000=E_aBo000D]aFo5;LE_aBg5Kl
D]aFo5;LE_`00P009Goo0012Ool00`00Oomoo`0<Ool04@00C]aBo4kLD_a>g5;lC]aBo4kL001>g5;L
C]aBg4kLD]`00P000TkL00<004kLC]`01dkL00<004kLC]`01TkL00@004kLC]a>g0@0009>g005001>
_4jlC[a>g003C[`00dkLC[`00002C[`02TZkC[a>_4jlB[]>_000C[a:Vdjk100000A:VdZLBY/000M:
V`0;001:NTZKBWY:NdYjBY]:NTYkBWX00007BWX00`00BWY:NP07BWX01P00BUU>NTYIBWY:F@H000M:
F@07001>FDYICUU:FDiIBUT00`0000=:F@00CUT024iI00@004iiCWU>F@=>N@80000BDWT005:IEYYB
VUJJDYUFVU:JEYYBVEJJDYX005JjE]YF^UKJ0P001UlK00@006=LHeaSG08000AW_0800004Im][ff_K
0003Jm/016_kJm/006OK0P0000eS_F>L000005mmGgaSOEmlGgeOO6=mGgaOO@020003Ea`01E/MEaaG
75LLFad00ULL00<005LLE_`00`0000QBo5KlD_aFo5;l001Bo5Kl0e;l00AFo5;lD_aBo08002Eoo`00
@Woo0`003Goo00d004kLD_e>g5;mC]aBoDkLD_e>g000C]aBo@0300004E;mC]aBoDkLD_d005;mC]aB
oDkLD_e>g5;mC]`004kLD]d00dkL00=BgDkLC]`0100001U:_4kMB[a>g4ZlC]e:_000B[]>g4ZlC]a:
^dkLB[a>g4Zk001:^djlB[]>_4ZkC[a:^`0400002DjlBY]:_4ZKC[a:VdZl001>V`02BY/03dYjCY]:
VdZKBWX004YjBY]:NTjKBWY:VdYjCY/00002BWX03TikBWY:NTYjCW]:NP00BUU>NTYJCWY:FDijBUX7
0002BUT03dXiBUX004iIBSQ>FDYICUU:>4iIBUU>F@00CUU:F@0300004dYICUU:F4iI001>NDYHCWU>
FDiiBUQ>NDiICWT0059iCUUBNDiI0080000GDWU>NE:JCWT005:IE[YBVEJJDYUF^U:IEYYBVEJj001J
feJjF]/005lKFa]O7002Ga/02U/KGaaO6elK001SG000IkaWW6^l0VNl010006_lIm][nfOK001Wff_k
ImY[nfOK001W^f_LIk][g0800009Ge`005mLHgeOG6=mGeaSOEmL0080000<Ged005/MEaaK?ELLFaeG
75/mEaaK7ELL0`0000mBo5KmD_aFo5;lE_eBo5Kl001Fo5;LE_aBg5KlD]`00`0000=Bg5Kl000097oo
0012Ool00`00Oomoo`0>Ool200001e;lC]aBo4kLD_a>g5;l00<0009>g005C_e>g4kLC]a>o@02C]`0
0`00C]a>g006C]`01000C]a>g4kL10000TkL00<004kLC]`01dkL00D004jlC[a>_4kL00=>_003C]`0
04jl009>_0@0009:_003001:W4ZK009:V`06BYa:VdZKBY]:W00024ZK00X004YjBY]:NTYkBWY:VdYj
BW/000M:NP04001:NTYjBWX4000014YIBUY:F@001dYI00<004YIBUT01dYI0`0000U:FDiIBUU>FDYI
CUU:FDiI00002DiI00@004ii000000IBN@0<001FVU:IEYYBVUJJDYUFVU:JEYYBVEJJ0`002elK00<0
06NlIk`00fNl00<006_KIm/00V_K00/006_KJm][ff_kJm/006OKJmaW^f_L00800008Ii`005ml001O
O5mmGgaSO@800006FcaO?E/lFc`005/M0eLL00=K7ELL00000P0000eFo5LL001Fo5;lE_aBo5KlD_aF
o5;lE_`00002D_`30005D_`20009Ool5000EOol0021oo`@000Eoo`8000Aoo`D000Aoo`@000Ioo`03
001oogoo011oo`03001BoDkL00@0000ED_e>g000C]aBoDkLD_e>g5;mC]aBoDkLD_d005;mC]aBoDkL
D_e>g5;m00@0000IC]a>gD[LC]e>g4kMB]`004ZlC]a:_4kMB[a>g4ZlC]d004kLB[]>g4ZlC]a:^dkL
B[`0100001=:_4ZKC[a:VdZlBY]>_000B[a:VdjlBY]:_4ZKC[a:VdZl001>V`02BY/03TYjCY]:VdZK
001>VdYjBY]:NTjKBWY:VdYj0003BWX00dikBWX0000500002DYJAUU:FTIIBUY6FDYJ001:FP02BUT0
2dXiBUY:FDYIBST004YICUU:>4iIBUT00`0001=:F@00BUQ>FDYICUU:F4iIBUU>FDYH001>FDiiBUQ>
NDiICWU:F00400005E:JCWUBNDiiDYY>NE9iCWUBVP00EYYBVEJjDYUFVU:IE[YBVEJJDYT00002Ga/0
1U/KGaaO6elKFa]O709O6`04Fa/00000Ig`20002Ik`02P00JoaWff_kIm/006OKJo]WfV_k0P0000UW
^f_LIk][g000IkaWW6NlHi`00P0000iSOEmL000005mMFcaOGE/lGeeK?5mM001K7ELL0`0000mBo5LM
E_aG75;l001Bo5KlD_aFoE;lE_aBo5KmD_`00`0000YBg5KlD]aFo5;LE_aBg5KlD]`000]oo`03001o
ogoo01Eoo`007goo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00D007ooOomoo`0000=oo`03
001oogoo009oo`03001oogoo00=oo`80019oo`800008C]a>o4kLD_e>g4klC]`000=>g005C_e>g4kL
C]a>o@02C]`00`00C]a>g00400000dkMC]`00009C]`20007C]`01000C]a>_4jl10000TZl00<004Zl
B[`01dZl00<004ZLBY/00TZK00E:W4ZKBY]:V`0000Q:V`08001:NdYjBY]:NTYkBWY:V`H00006BUY:
NTIJBUX004YJ0dYI00I:FTYIBUU:FDYJ0007BUT00`00BUU:F@030004BUT03000CUU:FDiIBUU>FDYI
CUU:FDiIBUT0009>F@@0009>F@03001BNE9i00QBN@09001BVUJJDYUFVU:JEYYBVEJJ00800003F]X0
05lK00QO6`03001WNfMl009WO005Ig/00000001Wf`02Jm/02P00Jm][ff_KJo/006_LIm][g6Nk0P00
1fNL0P000e/l00IO?E/lFcaK?5lmFc`300003eKlEaaFo5LLE_aG75KlEaaFo000D_aFo5;lE_aBo003
00000e;lE_`00009D_`2000:Ool00`00Oomoo`0EOol001moo`03001oogoo009oo`03001oogoo00Uo
o`03001oogoo00Uoo`03001oogoo009oo`8001Aoo`09001BoDkLD_e>g5;mC]aBoDkL00800008D_e>
g5;mC]aBoDkLD_e>g0<0000GB]a>oDkLC_e:g4kmC]`004[LC]e>g4kMB]a>gDkLC]e:g4kM001>g4Zl
C]e:_00600007DkLB[a>g4ZlC]a:_4kL001>_4ZKB[a:VdjlBY]:_4ZK001:VdZlBY]>_4ZKB[a:Vdjl
BY/004YjCY/00TZK00M:NTjKBY/004YjCY]:NP0400005dYkAUX004IJBWY6FDYjAUY:NTII0016FDYJ
AUU:FTIIBUY6FDYJAUT004XiBUX00TYI00=:>DYJBUT00`00015:FDiIBSQ>FDYICUU:>4iI001>FDYH
CUU:FDiIBUQ>FDYI00@0000HDWU>F59iCUQBNDiHDWT0059iCWUBVTiiDWU>NE:JCWUBNDii001BVEJJ
DYUF^U:I0P0000EJne[JF]]JfP00009O6`04Fa]O75lKGa/200002FMkIgaSNfNLIg]WO000Kma[^`04
000046_kImY[n`00JmaW^f_LIk/006>LIkaWW6NlHiaW_6NL0P0000USO@00GeeK?5mMFcaOGE/lGed0
0P0000mG75/m001G75;lEaeFo5LLD_aG7EKlEa`005KmD_`00`00015Bo5KlD]aFo5;l001Bg5KlD]aF
o5;LE_aBg5KlD]aFo00000Yoo`03001oogoo01Eoo`007goo00<007ooOol00Woo00<007ooOol02Woo
00<007ooOol027oo00<007ooOol00Woo00<007ooOol057oo00/005;mC]a>o4kLD_e>g4klC]aBo@00
009>g003C_d000000080000;C]a>o@00C]e>g4kMC]a>gDkLC]e>g0020008C]`500001D[LB]e:_4[L
00002DZl00<004ZlB[`01TZl00<004ZKBY`00dZK00A:W4ZKBY/000E:V`H00007AWY:NTIjBWY6NTYj
00000TYJ00U:NTIJBUY:FTYjAUX004YIBUX00dYI00E:FTYIBUU:F@0000=:F@<00003BUT004YI00Q:
F@06001:FDiIBUU>FDYI0`000TiI00@004iICUU>N@=>F@03CWU>F@0000YBN@04001FVU:JEYX20007
F]X00`00Ga]O6`02Ga/00`00IgaWN`03Ig`016MkIg`006_K0f^k00<006_JKmX0100000AWff_L0000
00MWW004001SO6=lHg`2000015lmFcaK?5/l0P000e/L00]G75/L001G75KlEaaFo5LLE_aG75Kl00<0
0003D_aFo5;l009Bo005E_aBo5;lD_`00007D_`40009Ool00`00Oomoo`0EOol001moo`03001oogoo
009oo`03001oogoo00]oo`03001oogoo00=oo`@000Eoo`03001oogoo01Eoo`09001BoDkLD_e>g5;m
C]aBoDkL00@0000EC_e>g4kmC]a>oDkLC_d004kmB]a>oDkLC_e:g4kmC]a>o@00C]e>g4kM00@0000S
B]a>g@00C]e:_4kMB[a>gDZlC]d004kLB[a>g4ZlC]a:_4kLB[a>g000C[a:VdZlBY]>_4ZKB[a:V`00
BY]:_4ZKC[a:V`0800008DZKAWY:VdIj0016FTYkAUY:NdIJBW]6FTYk001:NTIJBWY6FDYjAUY:NP00
BUY6FDYJAUU:FTIIBUY6FDYJ001:F@020002BUT03dXiBUY:F@00BSQ>FDYICUU:>4iIBUU>FDXh001:
F@0300006TYHCUU:>4iIBUP004iHDWU>F59iCUQBNDiHDWU>F000CWUBNDiiDYY>NE9iCWUBVTiiDWT3
000035[KF]YJne[JF]]JfU[kF]YJfe[J001O6`80000DIiaWNfMlHg]WW6MkIg`006oLJk][ff^k001[
fVoKJmY_n`00Km][fP800007IkaSW6NlIiaW_6>LIk`00P0000QOG6=mHeaSO5mL001K?5mM0P0000iG
75/mEaaK?ELLFceG7000E_aG75;lEaeFo5LL0P00011Bo5Kl001Fo5;lE_aBg5KlD_aFo5;LE_`005Kl
D]aFo0@00003D]aFo5;L008000Qoo`03001oogoo01Eoo`007goo00<007ooOol00Woo00<007ooOol0
37oo00<007ooOol00Woo00<007ooOol01Woo0P005goo00@005;mC]a>o0@0009>o@0C001>oDkMC_e>
g4kmC]e>oDkLC_d004kMC]a>gDkLC]e>g4kMC]`0100000Y>gD[LB]e:g4kMB]a:g@00B]e:_09:g004
B]e:_4[L0009B[`00`00B[a:_003B[`800001TJKBYa6VdJK001:N`=6N`0>BW]6NdIk001:NTIjBWY6
NTYjAWY:NTIj0016FP9:FP06BWY6FTYJBUY:NP000TYI00E:FTYIBUU:FDYJ00<000M:F@03001:FDYI
00E:F@@0009>F@05BUQ>FDiICUU:F002CUT01@00CUU>FDiICWT00diI00=>N@00DWT0259i0P003E[J
00@006MlIgaWN`=WO004Ig/00000Jm/3Jk/01P00JmY_fV_JKm/0009_fP04Km/006^k0005Ii`00`00
HgaSO006Hg`200000e/LEaaK7002Fa`025LLFaaK75/LEa`005KlEa`300000eKlD_aFo002E_`01000
D_aBo5Kl0e;l00=Fo5;l00000`000e;l00ABg5;lD_aBo08000Ioo`<001Moo`007goo00<007ooOol0
0Woo00<007ooOol027oo00D007ooOomoo`0000Aoo`03001oogoo00Ioo`03001oogoo01Moo`<0000E
D_e>g4kmC]aBoDkLC_d004kmC]a>oDkLC_e>g4kmC]a>o@00C_e:g4km00@0000MB]a>o@00C]e:g4kM
B]a>gD[LC]e:g4kM001>gDZlC]e:_4kMB[a>g@00C]a:_4kLB[a>g4ZlC]a:_0060000:dZlAYa:_4JK
0016VdZLAW]:W4JKBYa6N`00AWY:VdIjBY]6NTZKAWY:V`00BW]6FTYkAUY:NdIJBW]6FP00AUU:NTIJ
BWY6FDYjAUX004IIBUY6FDYJ00<00003BUY6F@00009:F@09BSU:FTYIBUU:>DYJ001>FDXh00@0000N
CUU:>4YI001>FDYHCUU:>4iIBUQ>FDXhCUT0059iCUQBNDiHDWU>F59iCUQBN@00DYY>NE9iCWUBVTii
0P0001]F^UJI001JfU[kF]YJfe[JF_]JfU[KF]YJne[J001S6P00Ig]WO6=kIiaWN`00Jk]_g6^kJm/0
0P0000a[fVoKJmY_n`00Km][fVok001_ff^jKm/200002V>L000006=lGeaSOF=LHgaOG6=m0P0000aK
?000EaaK?ELLFceG75/mEaaK?ELLFcd300003eKlD_aG75;lE_aBo5LLD_`005;LE_aBo5KlD]aFo002
000035;LE_`005KlD]aFo5;LE_aBg5KlD]aFo08000Moo`03001oogoo01Eoo`0087oo100037oo0`00
1Goo1@0017oo00<007ooOol067oo00<004kmC]`00dkm00A>g4kmC_e>o@800007C]e>oDkLC_e>gDkm
C]`0100001A>gD[MC_e:gDkMB]e>o@00B]e:g4kMB]a:gD[LC]e:g000B]a:gDZl0T[L00A:gDZlB]`0
00=:_0@00003A[a:_0000096W006B[a6W4JLAYa:_0000TJK00U:W4JKAY]6VdZLAY/004IkBW/00dIk
00i:NdIkAW/004YjAWY:NTIjBWY6NTYj001:NTIJ0TYJ00A:NTIJBUY:FP@00007BUY:FDYIBUU:FTYI
000014YI1P0000U:>4YIBSU:FDXhBUU:>@00BUP00diI00Q:F4iICUU>FDYHCUT004ii0diI00E>NDiI
CUU>F@0000ABN@800005EYUF^UJIE[X00009F]X20003Hc/01`00IgaWO6Mk001[^f_K009[^`05001_
ff_JKmY[fP020002KmX01FoK001[^f^kKk/00f^k00<006=lHg`01V=l00@005llGcaOG080009K7005
EaaK75/LFaaG700200000eLLE_`00002E_`01E;lE_aFo5KlD_`00UKl00<005;lD_`00`001E;l00<0
05;lD]`00e;l00IBg5;lD_`007oo000NOol0041oo`03001oogoo01Yoo`0>001>oDkLD_e>g4kmC]aB
oDkLC_e>g000C]a>o@@0000KB]a>o@00C_e:g4kmB]a>oD[LC_e:g4km001>gD[LC]e:g4kMB]a>gD[L
001:_4kMB[a>gDZl00H0000_B[e6_4ZmA[a:_DJl0016VdZlAYa:_4JKB[a6W4Zl001:W4JKBYa6NdZL
AY]:W4Ik0016NTZKAWY:VdIjBY]6NP00AUY:NdIJBW]6FTYkAUY:N`00BWY6FDYjAUY:NP0300001DYJ
AUU:FTIIBUX02@0002A:FDHhBUU6>000BSQ:FDXhCUU:>4YIBSQ>FDXh001:>4iIBUQ>FDXhCUU:F4iI
BSP004iHDWU>F59iCUQBNDiHDWU>F000CWT200004UJjEYUF^UJIE[YFVEJj001Jfe[JF_]JfU[KF]YJ
n`00Hc]S6P=S>`0QHaX006Mk001[^foLJk][f`00Ko][fVoKJmX006_JKm][fVok001_ff^jKm][^foK
JkX006NK001OG6=mHeaSO5mL0080000;GeaK?5mMGcaOG000FceG75/mEaaK?@0200003UKlFaeFo5LL
001G75;lE_aBo5LLD_aFo5;lEa`300004EKlD]aFo5;LE_aBg5KlD]`005;LE_aBg5KlD]aFo5;LE_`0
0`007Woo0010Ool3000KOol200001DkLC_e>oDkmC]`00dkm0`0000=>oD[MC_d00Tkm01A:gDkm001>
oD[MC]e:gDkmB]e>gD[M001:g4[MB]a>gD[LB]e:g4kM1P0000i:_D[MA[a:g@00B[a6_4ZlA[a:_4Jl
B[a6_0000dJL00I:_4JLAYa6W4Zl0002AY/02DZLAY]6VdJKBYa6V`00AW]:N`03AW/03DYkAW/004Ij
BWY6NTYjAWY:NTIj001:FTYj00/00006AUU6>DHiASU6F@001dXi00d004YIBSU:FDXhBUU:>DYIBSQ:
F@00CUU:F003CUT024YHCUU>FDiIBUP004iICWT3CUT00diiCUT0000200002eJIE[YFVEJjEYUF^UJI
E[YFVEJj00001E[J00<006<kHc/01V<k0P0000Y[ff^kJk/006oKJmY_fV_J001[fP9_fP05Km/006^k
Jk]_^`03Jk/01000Ii][Vf^K0P0000=SO00000000ell00IOG5llGcaO?5mL0002Fa`20003Ea`01EKl
EaaG75LL00000eKl00=Bo5Kl00000P0000=Fo5;l00002E;l00@005;lD_aBg0@0009Bo08001eoo`00
@7oo00<007ooOol07Goo00@004kLD_e>g0@0000;C_e:g000B]a>oD[LC_e:g4kmB]a>o@0200002d[L
C_e:g4kmB]a>oD[L001:g4kMB]`0100003=:gDKL0016_4[MA[a:gDJlB]e6_4[M001:_DJlB[e6_4Zm
A[a:_DJl0016VdZlAYa:_4JKB[a6W4Zl001:W4JKBYa6NdZLAY]:W000BY]6NTZKAWY:VdIjBY/004Yk
AUY:NdIJBW/020000316>DIJASU6FP00BUU6>DYIASU:FDHiBUU6>@00ASQ:FDHhBUU6>4YIASQ:F@00
CUU:>4YIBSQ>FDXhBUU:>4iI001>FDXhCUU:F4iIBSQ>FDYHCUT0059iCUQBNDiHDWT200004E9hDYT0
05JjEYUF^UJIE[YFVEJjEYUF^UJIE[X005[KF]X00P0000=S>f<JHc/00V<k00IS6V<kHc/006]kJi/4
00008F_JKm][fP00JmY_ff_JKo/006oKJkY_ff^kKm][^P00Ii][W6NKJkaWVf^L001OGEllGeaK?5mM
GcaOG5/lGeeO?003000035KlEaaFo5/ME_aG75KlFaeFo000D_aG70<0000?E_aBo5KlD]aFo000E_aB
g5KlD]aFo5;LE_aBg5Kl00@00007D]aFo5;LD_aBg5KlD]`00P0077oo0010Ool00`00Oomoo`0NOol3
0007C_d01000C_e>oD[M0dkm00Q:gDkmC_d004[MC]e:gDkm1P001d[M01<004ZmB]e6_4[MB[e:gDJl
B]d004ZlA[a:_4JlB[a6_4ZlA[`00003AY`01DZlAYa6W4JL00000dJK00=:W4JK00004@000TIJ00/0
04IIAUY6>DIJAUU6FTHi0016>DII00=6>@05AUU6>DHiAST00007BST02`00BSQ:FDXiBUU:>4YIBSU:
FDXh00000TiI00E:F4iICUU>FDYH00=>F@03001>F@00008000ABN@0?001FVEJjEYUF^UJIE[YFVEJj
EYUF^UJI001JfP0000QS>`80009[V`05Jg][V`00KmY_^P040002KmX01FoK001[^f^kKk/00V^k0P00
00UWVf^KJi][W6NKJi/006Ml00000Ull00IOG5llGcaO?5mLGc`40003Ea`01UKlEaaG75LLE_aG70<0
000:E_aBo5KlD_aFo5;lE_aBo5Kl0005D_`30002D_`01000D_aBo5;L0e;l00ABg5;l000001aoo`00
@7oo0P0087oo01<004[LC_e>gDkmB]a>oDkMC_e:g000B]a>oD[LC_e:g4kmB]a>o@0500001T[mB]e>
oD[M0016g0=:g@0LA]a:gD[MB]e6g000A[a:gDJlB]e6_4[MA[`004JlB[e6_4ZmA[a:_DJlB[d004Zl
AY]:_4JLB[`80000349kAYa2NdJL0016Nd9JAW]2FTIk@UY6N`<0000cAUY2FTIK@UY6FP00AUY6>DIJ
ASU6FTHiAUY6>@00ASU:FDHiBUU6>DYIASU:F@00BUU6>4YIASQ:FDHhBUU6>000BSQ>FDXhBUU:>4iI
BSQ:FDXh001:F4iIBSQ>FDYHCUU:>4iI00<00005DYUBNE9iDWQBV@02DWT03U9h001FVEJjEYUF^UJI
E[YFVEJjEYUF^UJI0002Hc/056<JHc]S>f<kHaYS>`00Ji][Nf^KJg][V`00Km]_^VoKKkX006oILmX3
000036oKJkY_ff^kKm/006^lIi][W6NKJkaWV`800009IgaSFfMl001OGEllGeaK?5mM00800003FaaO
?5/L00800006FaeFo5LLE_aK7EKl0P0000mG75Kl001Bg5KlD_aFo5;LE_aBo5KlD]`005;LE_`00`00
00mFo5;LE_aBg5Kl001Fo5;LD_aBg5KlD]aBo5;LE_`00P006goo0010Ool00`00Oomoo`0POol00`00
C_e>o@07C_d01000C_e>oD[M10000T[m00D004[MB]e:gD[m00=:g@03001:gD[M00I:g@0?001:gDZm
B]e6_4[MB[e:gDJl0016_4ZlA[a:_4Jl00P0000BAYa2W4JL@Y`0049kAW]2NdIl@W]6Nd9k0012FdIk
@U]6Nd9K0`0024IJ00T004IJAUU6FTHiAUY6FDIJ00000THi00E6FDHiASU6>DII0096>@03001:>DXi
00E:>@0;001:FDXhBUU:>DYIBSQ:FDXiBUT00003CUT00dYHCUT0000200000diI001BN@09DWT02@00
EYUF^UJIE[YFVEJjEYUF^P0200000ekJ001S>`05Hc/02000Ji][Vf^KJg][V`00KmX3KkX01`00KmUc
fVoJLmX007?J0080009[^`03001[W6NK009[V`03JiaWV`00009WO005Hg]WO6MlIg`00002Gc`20000
1U/lFaaK?5/LFcaK7080009G70<000EFo009001Bo5KlD_aFo5;lE_aBo5Kl00<000UBo005001Bo5;l
D_aBg003D_`015;L000000006Woo000oOol00`00Oomoo`0ROol200001dkmC]e>oD[LC_e>gDkm00@0
000?B]e>oD[MC_e:gDkmB]d004[MC_e:gD[mB]e>oD[M008000=:g@0:A]a:gD[MB]d004[MA[a:gDJl
B]d800005d:LA[e2W4Jm0016W4:LAYa2W4JL@Ya6W000AYa2NdJL@W]6W49kAYa2N`00@UX00`000392
FTIk@UX0049JAU]2FTIJ@UY6Fd9J0016>DIJASU6FTHiAUY6>DIJ001:FDHiBUU6>DYIASU:FDHi0016
>4YIASQ:FDHhBUU6>4YI001:FDXhCUU:>4YIBSQ>FDXhBUT004iI0`0000UBNDiHCUU>F59i001BNE9h
DYT00U9i00]BN5:IDWUBN@00E[YFVEJjEYUF^UJI00800005G_]JfUkjF]X00002Hc/05f<J000006^K
Jg][Vf]kJi/006oKKkY_ffnjKm/007?JKkUcfP00LmY_^G?JKkT00P0000m[_6NKJiaWVf^lIi/006=K
IgaSFfMlHe]WO6=KIg`00P0000QK75/lFaaO?5/LFcaK75ll100000mFo5LLD_aG75KlEaaBo5LL001F
o5;LE_aBo5KlD]`00P00019Fo5;L001Bg5KlD]aFo5;LE_aBg5KlD]`005;LE_aBg5;lD]`300000e;L
E_`0000JOol003moo`03001oogoo02Aoo`03001>oDkm00@00006C_e:o@00B_e>oD[M0T[m00E>oD[M
B_e:o@0000=:g@06B_e:gD[MB]e:o@0014[M20000TJm01Y6gDJm0016_4Jm@[a6_DJlA[e2_4Jm0016
W4:LAYa2W4JL@Ya6W000AWa2NdIk@W]6O49k0`0000Q2FdIk@U]6Nd9KAW]2F`001dIJ00T004HiAUY6
FDIJASU6FTII00000dHi00M6FDHiASU6>DIIAST00007BST02000BSU:FDXhBUU:>DYIBSP400002DiI
CUQ>FDiHCUU>F4iICUP0000:DWT01000E[YFVEJj0P000Ukj00UNfUkjG_YNnUkJ001S>`00Jg/00f^K
00A[Nf^KJi/000=_^P0=KmX007?JKmYcfP00LmY_fW?JKkUcfP00KkX00P0000A[Vf^L0000009WO005
Hg]WO6MlIgaSN`0200002F=L001K?5/LFcaK75/lFaaK?00300000e/L001Fo008E_`00`00E_aBo003
0003D_`00eKlD_`00009D_`00`00D]`0000200001E;LD_aBo5;lD]`00P006Goo000oOol3000UOol2
00005d[mC_e:gDkmB_e>oD[M001:gDkmB]e>oD[MC_e:gDkmB]d004[MC_e:gD[mB]d01`000256gD[N
A]e6g@00A]e2_DKM@[a6gD:mA]e2_000@Ya6_D:LA[e2W4Jm@Ya6_@00AYa2W4JL@Ya6W4:LAY`004JL
@W/00`000312NdJL0016Nd9JAW]2FTIk@UY6N`00AUY2FTIK@UY6FT9JAU/004IJASU6FTHiAUY6>DIJ
AST004HiBUU6>DYIASU:FDHiBUT004YIASQ:FDHhBUU6>4YIASP004XhBUT400003TXhCUT004iICUQB
NDiHCUU>F59iCUQ>FDiH0002DWT02E9hDYUBNE9iDWQBVE9i001FV@0200008ekjF]YNne[JG_YJfUkk
F]YNnU[J001[Nf^KJg][Vf]kJi][N`00KkY_ffnjKm/007?JKkUcfP00LmY_^G?JKkUcfP00Lk/00Vnj
00Y_VP00001WO6=KIgaSFfMlHe]WO0800009Gc]SG5lkHe`005llFaaK?5/L00800003FaaFo5/L0080
0009D_aG75KlEaaBo5LLE_aG75;l00<0000AD]aFo5;LE_aBg5KlD]aFo000E_aBg5KlD]aFo5;LE_aB
g00300002E;LE_aBg5;lD]aFo5;LD_aBg002000HOol003moo`03001oogoo02Ioo`05001>oDkmC_e:
o@03C_d01D[m001:oDkmB]d00T[m00=>oD[MB_d01P0000E6gD[MA]e:o@0000M6g@040016_DJmA]d3
A[d04TKMA[d004JlA[e2_4JmA[a6_D:l0012W4JL@Ya6W4:LAYa2W0<0000?@W]6Nd9kAWa2N`00@U]6
Nd9KAW]2FdIk@U]6N`0000M6FP0:0016FTHiAUY6FDIJASU6FP00AUT3AST01TIIASU6>DHiAUT000A:
>@H00005BUU:>4XhBSQ:F@02BSP02`00CUU>F4iICUQ>FDiHCUU>F4iI00002U9i00<005kJG_X00Ukj
00ENfUkjG_YNnUkJ009NnP06001W>P00001[Vf]k0V^K010006njKkY_^VoJ001cfVoJLmY_f@00KmYc
fVniLmX000E_^P05001_V`00IgaSN`02Ig`20006He`00`00FaaK?00200001ULLFaaK75/LEaaK7080
00EFo0<00004D_aFo000E_`3D_`01UKlD_aBo5;lE_`000=Bo0@00005D]aBo000D_aBg003D_`015;L
D_aBo5;l0P0067oo000UOol40005Ool20005Ool40006Ool00`00Oomoo`0WOol03@00C_e:oDkmB]e>
oD[mC_e:g@00B]e>oD[M00@0000=B_i:g@00A]e:oTKMB_i6gD[nA]e:oP00B]h00dKM01Q:gTKMA]d0
04KM@[e6gD:lA]e2_DKM@[`004:LA[e2W4Jm@Ya6_D:L0012W4JL@Y`300009d:L0012NdJL@W]6W49k
AYa2N`00@UY6Nd9JAW]2FTIk@UX0049JAUY2FTIK@UY6FT9J0016>DIJASU6FTHiAUY6>DIJ001:FDHi
BUU6>@0900006THHBSU6>000BSQ>FDXhCUU:>4iIBSQ>FDXh001>F4iICUQBNDiHCUU>F59iCUP0059h
DYT2DWT0159hDYUBNE9i0P00011FV@00F]YNne[JG_YJfUkkF]YNnU[J001W>VMKHcYWF`80000BJg/0
06njKm]_^VoK001cfVniLmY_f@00KkUcfVniLmX007>k0Vnj00Q_VW>k001_Vf]jKi/006Ml0P0000UO
>f=LGc]SG5lkHeaO>f=LGc/00P0000QK75LLFaaFo5/LEaaK75Kl0P0000=G75;l00000P0000mBo5LL
D_aFo5;l001Bg5KlD]aFo5;LE_aBg5KlD]`01000011Fo5;LE_aBg5KlD]aFo000D_aBg5KlD]aBo5;L
E_aBg0<001Moo`0097oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<0
07ooOol00goo00<007ooOol0:7oo00D004kmC_e>oD[m00=>o@@000M:o@0:0016gD[MA]e:oDKMB]e6
gD[m0007A]d01000A[e6_DKM0TJm>00014Hi00X004XiASQ:>DHhBSU6>4XiASP000=:>00ABUU:>4Xh
BSQ:FDXh001>F4iICUQ>FDiHCUU>F4iICUP00005DWT200001UZiEYUF^@00G_YNfP=NnP0<G]YNnUkj
001W>VLkIcYWFfLjIc]W>P000fnj00a_fVnj001_fW?JKmT006oJLmY_^G?J0005KkX01`00Ki][VVnK
JiY_V`0000USG0800003Gc`005LL00=K7005EaaK75/LFaaG700300001E;lE_aFo5KlD_`00eKl00AB
o000D_aFo0=Bo0<00003D_aFo00000=Bo00:D]aBo5;lD_aBg5;l001Bo5;LD_`40002D_`2000FOol0
02Aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00=oo`8002Yoo`03001>oD[m00@0000G
C_e:g@00001:oT[MB_i:gD[nB]e:oT[M0016gD[nA]e:oTKMB_i6gD[n001:gP03A]d800002D;N?[e2
_Cjm000nW4:m?Ya2_@040000D3il?Y`nO4:M?W`nW3il000nFcil?U]2O3iK?W`0049K?SY2Fchj@U/n
>T9K0012FShj@SXn>D9J?SY2>P00ASY26DHi@QU6>T8IASU26@00AQQ6>D8HASU664Hi@QQ6>@00BSU6
64XiASQ:>DHHBST004iIBSQ>FDXhCUU:>4iIBSQ>F@00DWU>F4iICUQBNDiHCUU>F59i001BNE9hDYT2
00005eJIF[YFVEZjEYUJ^P00G_YJfUkkF]YNnU[J001W>VMKHcYWFfLjIe]S>P00JgX00P0000e_ffnj
001_^G?JKmT006niLmY_^G?J001c^`02KkX07fnJ000006nKJgY_Vf^JKi/006]k001SG5lkHeaO>f=L
Gc]SG000GcaO6ellGc/005KlFaaG75/LE_aK75LL00@0000<E_aBo5LLD_aFo5;lEaaBo5Kl001Fo5;L
0`0000mBg5KlD]aFo5;L001Bg5KlD]aFo5;LE_aBg5KlD]`0100000IFo5;LD_aBg5KlD]`2000FOol0
02Aoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo02]oo`800003B_e>
oD[m009:o@04C_e:oD[m0008B_d01P00A]e:gDKMB_e6g@L000=2g@03A]h004:m0092_@05?[e2_D:m
@[dn_@040004?Yd00`00?W`nW003?W`01CjL000nFciK?W`00ciK00H003hj?U/nFd9K?SX2?U/00d9K
0012>P06@SX01000@SU2>DHi0d8i00=6>@00AST01dHi00/004HhBSU6>4XiASQ:>DHhBST004YI00=:
>00?BUU:>4XhBSP004iHCUU>F4iICUQ>FDiHCUU>F4iI00<0009F^@0:F[UFVEJiE[UJ^EJIE[T005kj
G]X2G_X02P00IcYW>fLjIe]W>VLkIcX006mj0fnJ1`0000AcfVniLmX000A_^P08001[VVnKJiY_Vf^J
Ki/000=[N`03001SG6=L009SG08000EO?003001K75LL00=K70800007E_aG7000Ea`005KlD_`00eKl
00=Bo5KlE_`00`0000=Bo5KlD_`00U;l00IFo5;lD_aBo000D]`3D_`02E;L00000000D]aBo000D_aB
g003D_`00e;LD_aBo002000EOol002Aoo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`03001o
ogoo02aoo`0:001>oT[mC_e:gDknB_e>oD[MC_h2000014[MB_i:gD[n20000196gDKnA]e6oP00A]i2
_DKN@[e6gT:mA]h004;N?[e2_Cjm@]h40000DSjL@[dnW4:m?Ya2_CjL000nO3jL?Wa2WCil?Y`0049l
?U/nO3iK@W`nF`00?SY2Fchj@U/n>T9K?SX003hi@UXn>T8j?SU2FShj00126DHj@QU6>D8IASY26DHi
0016>DHHASU264HiAQQ6>@00BSU6>4XiAQQ:>DHhBSU66000BSQ>FDXhCUU:>4iIBSQ>FDXh001>F59i
CUQ>FDiHDWU>F4iI0P0002AFVEZjEYUJ^UJIF[YFVEZjEYUJ^UJIF[X005kjF]X006LjIe]S>VMKIcYW
Ff<j001[NVnJJgY_Vf]j001_VG>jKkT007>hMmT300004g>kKkY_^VnJ001[VVnKJgY_Vf^JKi/006]k
IgY[NfMJJg/006=L0080000;Gc]O?5lKGcaO>ellGa]O?000FaaFo00200001E/LE_]K75KlFa`00P00
00IBo5KlD_aG75;lE_`200003e;lE_`005KlD]aFo5;LE_aBg5KlD]aFo000E_aBg00300004E;LE_aB
g5;lD]`005;LD_aBg5KlD]aBo5;LE_`007oo000057oo000TOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`06Ool2000^Ool200000d[mC_e:o@02B_d00dkmB_e:o@0500001D[nB]e:oD[m0000
0dKM00E6oTKMA]e6gDKn00800003@]e6gT;M0092g@03A]h004:m00<000=2_@03000nWCjM00DnW@04
000nO3il?Y`3?W`01@00?U/nFciK?W`00ciK00H003hj?U/nFd9K?SX2?U/00`00@SY2>P05@SX01@00
@SU2>D8iAST00d8i00<004HiAST01THi00`004XiASQ:>DHhBSU6>4XiASP004XhBUT3BSP02DYIBSQ:
>000CUU>F4iICUQ>F@030002DWT01000E[UJ^EJI0UJi019J^EJIE[UF^EZiEYT005kj001W>VLkIcYW
FfLjIc]W>P00KgX3KiX00fmj001c^@02LkT00`00LkUc^@02LkT02`00LkT00000KkX006^JKi][VVnK
JiX00P001f]k00<005llGc`02Ell0P0000QFo5LLE_aG75KlEaaFo5LL0P000UKl0`0000IFo5;lE_aB
o5Kl0002D_`01UKlD_aBo5;lE_aBo0<00005D]aBo5;lD_aBg003D_`01E;L001Bo5;lD]`00e;l00AB
g000000001Aoo`0097oo00<007ooOol00Woo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol0
;goo00@004[mC_e:g@@0000:C_i:o@00A]e:oTKMB_i6gD[nA]d200003DKnA]e6oTKMA_i6gDKnA]d0
04:mA]i2_DKN00<0001C@]hn_D:m?[e2gSjm@[d004:m?Ya2_CjL@[dnW4:m0012WCil?Y`nO4:M?W`0
03iK@W`nFcil?U]2O000@U/n>T9K?SY2Fchj@U/0048j?SU2FShj@SXn>D9J0016>D8IASY26DHi@QU6
>T8I001264HiAQQ6>D8HASU66000AQQ:>DHhBSU664XiASQ:>@00CUU:>4iIBSQ>FDXhCUU:>4iI001>
F@030000B59iDWQBNE9hDWT005ZjEYUJ^UJIF[YFVEZjEYUJ^UJIF[YFV@00IcYWFf<jIe]W>VMKHcX0
06]jKiY[NVnKJgX006nILkY_^G>j001gfG>hMkT007NiLkQg^G>H001[VVnKJgY_Vf^J001WFV]kIgY[
NfMJJg]WNV]k001WN`00GcaO6ellGc]O?5lKGcaO>`80000;Gc`005/LE_]K75KlFaaFne/LE_aK7003
00003eKlD]aFo5;lE_aBg5KlD_`005;LE_aBg5KlD]aFo002000045;LE_`005;lD]aFo5;LD_aBg5Kl
D]aBo000E_aBg5;l100000ABg5Kl000001=oo`0027oo0`006Woo100037oo1@0017oo00<007ooOol0
<7oo0`001d[m00H004[MB_e:oD[nB]d2B_d01D[n0016gDKMA_h00TKM7P000Sil00<003il?U/00SiK
00HnO3iK?U/0049K?SX2?U/0149K?SXnF`001T8j00<0048iAST00d8i00A6>D8i@ST000Q6>@0:0016
>4XiASQ:>DHhBSU6>4Xi0002BSP01DYIBSQ:>4XhBUT00`002E9i00D005JiE[UJ^EJI009F^@03F[UF
VEJi00800009G_X006LjIe]W>VLkIcX006mj00=_VP03KgX007>i00=c^@03001c^G>i009c^@06001c
^G>iLkT007>I0P0000=_Vf^J00001f]k0P000fMK00<005llGc`00ell0P0000]K75llFaaO7000EaaF
o5LLE_aG75Kl00<0000<E_`005;lE_aBo5KlD_aFo5;lE_aBo0000U;l0`0015;l00@005;lD_aBg0=B
o003D]aBo5;l00@00003D_aBg5;l009Bo003D]`0000001=oo`002Goo00<007ooOol0<Woo00<007oo
Ool0<Goo0P00011>oD[MC_i:oDkmB]e>oT[m0016gD[nA]e:oTKMB_i6g@H00003A_h000000080000I
?[e2gSjm@]hn_D;N000n_SZM?[hjWCjn>Ydn_P00>YdfOCZM=W`jWCIm>Yd003Ym=U`01`0003<nFcil
?U/003hj@U/n>T9K?SY2Fchj000n>T8j?SU2FShj@SXn>@00@QU6>D8IASY26DHi@QU6>P00ASU264Hi
AQQ6>D8HAST004XiAQQ:>DHhBSU664XiASP004XhCUU:>4iIBSP00P0003M>FDXh001BN59iDWQBNE9h
DWUBN59iDWQBN@00F[YFVEZjEYUJ^UJIF[X006;jG_URnUkI001W>VMKHcX006]jKiY[NVnKJgX006nI
LkY_^G>j001gfG>hMkUc^000LkQg^G>H001cVG>iLiUc^@0200002VMJJg]WNV]kIeY[NfMj001SFfMk
0VMK00ESFfMk001O?5lK0080000:GcaK6ellFa]O?5/KGc`005/LE_/300000eKkEaaFo00200002EKl
D_aFo5;LE_aBo5KlD]aFo00300003UKlD]aFo5;LE_aBg5KlD]`005;LD_aBg5KlD]`300002e;LD_`0
05KlD]aBo5;LE_aBg5;lD]`00P004Woo0009Ool00`00Oomoo`0aOol3000dOol00`00B_e:o@06B_d0
0`00B]e:o@0400001DKmB_h004KN@]d00P0000a6gT;MA]i2g@00?[i2gSjm?]hn_T;N0002>[d03Sjn
>Ydj_CZm?[h003ZM=WdjWCIm>YdfOCZM0002=U`01SIl=U`fG000>U`f>`P0008nF`03@U/n>P0000I2
>P040012>D8iAST3@ST00dHi@ST00007AST03000ASQ:>DHhBSU6>4XiASQ:>DHh001:>0<000=>F003
CUT0059i00UBN@06001FVEJiE[UJ^EJI0P0000YRnUkjG_YNnV;jG_X006Lj001_NP=_VP03KgY_VP00
00=c^@03001c^G>i009c^@03001c^G>i009c^@08001cVG>ILkUcV@00KiT000E[N`03001WFfMK00IW
F`800009FaaO75/LGcaK75lLFaaO?5/L00<000MFo0800005E_aBo5KlD_aFo00300000eKlD_`00008
D_`00`00D_aBo0030002D_`01E;LD_aBo000D]`00e;l00MBg5;lD_aBo000Ool0000AOol000Uoo`@0
031oo`03001oogoo03Eoo`800004B]e>oT[mC_d500001T[nA]e:oTKMB_i6g@<0000^@]e6oT;MA_i2
gDKn@]d003jm@]hn_D;N?[e2gP00?[hjWCjn>Ydn_SZM?[h003ZM=WdjWCIl>YdfOCZM000jOCIL>Wdf
G000=S/jG3Hk>U`f>cYL=S/003XJ>S/800006Shi@UXn>T8j0016>T8IASU26DHj@QU6>D8I001664Hi
@QQ6>DHHASU26000ASQ:>DHHBST60000?dXhCUU:>4iIBSQ>FDXhCUT0059iDWQBNE9hDWUBN59iDWQB
NE9h001FVEZjEYT005kIH_YNnF;jG]URnUkiH_YNf@00JgY_VV]jKi][NVnJ001c^VniLkX007OILkQg
^G>h001c^7NiLiQg^@00LkUcVG>iLiT006miLiY_N@0200001F]k000006=KIg/00VMK00iSFfMkIe]W
F`00Ie`005llFa]O?5/KGcaK6ell0P0000YK6elL001G75KkEaaFo5LLE_]G70800003D]aFo0000080
000>E_aBo5KlD]aFo000E_aBg5KlD]aFo5;LE_aBg0<0000AD]aBo5;LE_aBg5;lD]aFo5;L001Bg5Kl
D]aBo5;LE_aBg003000AOol000Uoo`05001oogooOol0000_Ool00`00Oomoo`0gOol4000024kmB_e:
oD[m0016gD[mA_d300004dKmB_h00000@]e6gT;MA]i2gDKN@]d003jn@]hn_CkN?[i2gP00008j_@0=
?[hjWCZm>[dn_P00>YdfOCZM=WdjWCIm00000cIL00DfO3IL000f>cYL00<f>`06>U`003Xj>SXj>cXJ
0SXj00@j>`00?QXn6AX000=:>004ASQ:>000CUT3CUP01DiICUQ>F4iH00002U9i00H005Zi000005kj
H_X3G_X01f;jG_YNnUkj001W>P00009_VP03KgY_VP0000=c^@03001c^G>i009c^@03001c^G>i009c
^@04001cVG>ILkT2LiT01`00LiY_NG>IKiUcVP0000QWF`800008He]S>f<k001O?5/LGaaK708000AK
7003001Fo5Kl00IFo0<0000:E_aBo5KlD_aFo5;lE_aBo5Kl0005D_`20002D_`01@00D_aBo5;lD]`0
0e;l00IBg5;l001Bo5;LD_`40002D_`20009Ool50002Ool000Uoo`05001oogooOol0000_Ool00`00
Oomoo`0hOol02000B]e>oT[MC_e:gDknB]d3000034KMB_i6gD[nA]e:oTKM0012gDKn@]e6oQH0001M
=W`jWCIm000fG3Ym=U`jOCIL000f>cYL=S/jG3Hk>U`003Xk>QXj>cHJ>S/j6P00>QTn>SXI?QXj6Chj
>QT003hH@QTn6D8I?QQ26ChI001264Hi@QQ6>D8HASU26000AQQ:>DHhBSU664XiASQ:>DHH001:>4iI
BSQ>FDXhCUU:>4iIBSP0059hDWUBN59iDWQBNE9hDWUBN59i001RnUkIH_YNnF;jG]URnUkiH_YNf@00
IcY[FVLi0080000OKiX007>jKkUc^VnI001c^7NiLkP007>hMkUcV7Ni001c^G>ILkUcVG>i001cVVmi
LiY_NG>J001_NP00Ig/00VMK00aSFfMkIe/006<kIeaS>fMKHc/005/KGc`200003E/KFaaK6elLFa]K
75/K001Fo5LLE_]G75Kl0080000?Ea`00000D]aFo5;lE_aBg5KlD_aFo5;L001Bg5Kl00<0000>E_aB
g5KlD]aFo000E_aBg5;lD]aFo5;LD_aBg0@00007E_aBg5;lD]aFo5;LD_`00P0027oo00D007ooOomo
o`00009oo`002Goo00D007ooOomoo`0002moo`8003Yoo`04001:oD[mB_d3000024[mC_d004[mA_e:
oTKMB_d70003@]h04D;M000j_Sjn>[hn_SZn?[h003JN=YdfWSJM=YhfWCJN00000RiM1P000SIL00Df
O3IL000f>cYL00<f>`06>U`003Xj>SXj>cXJ0SXj00X003hI?QXn6ChJ?QTn6P00@QTn6@=26@0=?QU2
6D8I001264HIAQQ6>D8HAQU66000ASP00dXh00Q6>4XhBSQ:>4Hh001>F4iI0diH00A>FDiHCUP000QB
N@800003F[T006;j00=NnP0;H_YNnUkjG_X006LjJcYW>V/jIcY[>P020003LkT00`00LkUc^@02LkT0
1@00LkUc^G>i00000W>I00Yc^G>ILiT007>JKgUcVFnILiX000=_NP03001WFfMK009WF`03001S>f=K
00=S>`04He]S>`000009Fa`00`00E_aFo0030004E_`2000025;lE_aBo5KlD_aFo5;lE_`30008D_`0
0`00D]aBo002D_`02E;LD_`00000D]aBo000D_aBg003D_`01E;LD_aBo5;l00002Goo00<007ooOol0
0goo0008Ool5000`Ool00`00Oomoo`0jOol300001D[MC_e:gDknB]d01P00029:oTKMB_i6g@00@]e2
gT;MA]i2gD;N@]d003Zm?[hj_CkN>[dn_P00=YhbWCJN<WdfWS:M=Yh0039m;UdbOBiL<Wd^G@H0000o
>U`f>cYL=S/jG3Hk000f6SXk>QXj>cHJ>S/003hJ>QTn>SXI?QXj6Chj00126ChH@QTn6D8I?QQ26@00
ASU264Hi@QQ6>D8HAST004XiAQQ:>DHhBSU664XiASQ:>@00CUU:>4iIBSQ>FDXhCUU:>4iI001BNE9h
DWUBN59i0080000:EYUJ^EJI001NnF;jG]URnUkiH_X200002FLjJeYW>F]JIcY[FP00LiY_N@040000
6gNiLkQgf@00MkUcV7NiLkP007>ILkUcVG>i001cVVmiLiY_NG>J001_NV]IKgY_NFmj001WN`020000
1V<kIeaS>fMKHc]WG080000;Ga/005/KFaaK6elLFa]K75/KGaaK6`030002E_`02e;kEaaFo5KlD_/0
05Kl001Bg5KlD_`0100000mFo5;L001Bg5KlD]aFo5;LE_aBg5KlD]`005;LE_`00`0000iFo5;LD_aB
g000D]aBo5;LE_aBg5;lD]aFo5;L0P002Goo00<007ooOol00Woo000lOol00`00Oomoo`0hOol30000
17oo001:oD[m100000]:oDkm001:oDKMB_i6gD[mA]e:oTKM00800003@]i2gD;N0092gP0A@]d003Zn
?[hj_Sjn>[hn_P00=YhfWCJN=YdfWSJM=Yh00002;Ud0139m;Ud^G@0012hl0`0000<f>cYL=S/00SHk
00l003XJ>SXj>SXk>QXj>P00?QXn6ChJ?QTn6ShI00000T8I014n6D8I@QU26ChI001664Hi@QQ66DHH
ASU264HI001:>4Hh00=:>005ASQ:>4XhBSP00002CUP01diICUQ>F4iHCUU>F00000=BN@800003F[UF
VEZi009J^@04EYT005kjH_X2G_X02@00JcYW>V/jIcY[>VLjJcX00004KgT00`00LiQcV@040003LkT0
0`00LiUc^@02LiT01`00LiY_NG>IKiUcVP0000=_NP05KgU_NVmjKgX00002Hc/01V=KHc]S>f<kHe/0
00AS>`03001K75/L00AK7080009K7003001Fo5Kl00IFo0D00003D_aFo5;l009Bo003E_aBo00000MB
o0@000=Bo006D]aBo5;lD_aBg0000U;l00=Bg5;lD_`00`000U;l00<007ooOol01goo00<007ooOol0
0Goo000lOol00`00Ool0000eOol30005Ool200001dkmB]e>oD[MC_e:gDkm0080000ZA]e:oTKMB_i6
gD[nA]e:oP00@]i2gDKN@]e2gT;M000j_Cjn>[dngSZm?[h003JN<YdfWS9m=YhbW@00;U`bOBiM<Wd^
G39m000^?2Xl;SdZ?2hl1@0003@jG000>S/f6SXk>QXj>cHJ000j6ChJ>QTn>SXI?QXj6@00?QU26ChH
@QTn6D8I?QP0048HASU264Hi@QQ6>D8H0016>4XiAQQ:>DHhBSU664XiASP004XhCUU:>4iIBSQ>FDXh
CUU:>0<0000QEYUJ^UJIF[UFVEZjEYUJ^EJI001NnF;j001[FVLjJeYW>F]JIcY[FP00LiY_NG=jKgUc
VP00MiUcV7NI001gV7>G00<0000ILiUc^G>ILkUcV@00KgUcVVmiLiY_N@00JeU_NVmiKgY[FFmj001_
NP00IeaS>fMKHc/00P0000US>elKHcaO>f<kGa/005/KFa`00`0000MK75KkFaaFne/L001G7002E_`0
0e;kEaaFo00300003U;l001Bg5KlD]aFo5;LE_aBg5Kl001Fo5;LE_`400003e;LE_aBg000D]aFo5;L
D_aBg5KlD]aBo000E_aBg00300001U;LD_aBg5KlD]`000Yoo`40005oo`5oo`00?7oo0P00=7oo0P00
2Goo00D004[mB_e:oDkm00=:o@08C_e:o@00A]e:oTKMB_e6gAD00004=YdfWSJM0003;Ud00c9m;Ud0
0005;S`00`00;Q/^6`02;Q/400003CXJ>SXj>SXk>QX003hI?QXn6ChJ?QTn6P0000=26@0>?QU26D8I
@QT004HIAQQ6>D8HAQU664Hi@QP0009:>005ASQ:>4XhBSQ6>002BSP01@00CUQ>F4iHCUT00diH0P00
0eZi00EFVEZiF[UJ^EJI00=J^@0;001NnP00JcYW>V/jIcY[>VLjJcX00005KgT01P00LiUcV7>ILiP0
00=gV004001gV0000002LiT01`00KgUcVFnILiY_N@00009_NP05KgU_NVmjKgX00003JeX01000Hc/0
00002F<k0P0000=K75[lFa`00U/L00EJo5/LFaaK7000009Fo0<0009Fo004001Fo000E_`3D_`015Kl
D_aBo5;l100025;l00<005;LD_`00U;l00=Bg5;lD_`00`000U;l00EBg5;lD_aBo5;L009Bo003001o
ogoo00=oo`05001oogooOol00002Ool001Yoo`@000Eoo`8000Moo`03001oogoo00=oo`@000Ioo`03
001oogoo031oo`<000aoo`800007C_e:gDkmB]e>oD[MC_d01P0001E6gD[nA]e:oP00@]hn_D;N@]e2
gSjm000fWCZn=Ydj_SJM>[h002in;Wd01P0000dbOBiM<Wd^G000:S`^?2Xl;SdZ?000;O/b7002;Q/0
0bgk<Q`000040000:CXk000n>SXI?QXj6Chj>QTn6P00@QTn6D8I?QQ26ChI@QT004Hi@QQ6>D8HASU2
64Hi001:>DHhBSU664XiASQ:>DHHBST004iIBSQ>FDXhCUT00P0002YBF59i001J^UJIF[UFVEZjEYUJ
^EJIF[YFVEZi001[FVLjJeYW>F]JIcY[FVLi001_NG=jKgUcVP00MiUcV7NILiP007>GMkQcV7NH001g
V7>GMiP2000076miLiY_NG>JKgT006]IKgY_NFmjJeU_NP00KgY[FFmjJeY_NP00HcaO>f<kGa]S?5lk
Hc]O6f<l0P0000aO6`00E_]K75KkFaaFne/LE_]K75KkFa`200003U;lE_aBneKlD_aFo000E_`005Kl
D]aFo5;LE_`2000045;LE_`005KlD]aFo5;LE_aBg5KlD]aFo000D_aBg5Kl100000eBg5;l001Fo5;L
D_aBg5KlD]aBo5;LE_`00006Ool30003Ool001Uoo`03001oogoo009oo`03001oogoo009oo`8000Mo
o`03001oogoo009oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo02eoo`<0015oo`03001:
oD[m00@0000>C_e:g@00A]e:oDKMB]e6gD[mA]e:g@00@]i2g@=2gP08@]d00000>[hf_SZn=[hj_P80
0003;Wd^ORim008^O@H000H^?003000^6bhK00<^6`03000anS8J008anP@00007?QTn6ShI?QXn6@00
?QT00d8I00dn6D8I@QT0048HAQU664Hi@QQ66DHHAST00003BSP024HhBSQ:>4XhASQ:>000CUT30000
1U9iDWQBNE9i001FV@=J^@0@EYUJ^EZiF[UFVEZi001RnP00JcYW>V/jIcY[>VLj0004KgT01P00LiUc
V7>ILiP000AgV003001gV7NH009gV007001cN000001cVVmi00000Vmj00E_NFmjKgY_NP0000E[FP03
001[FP0000MS>`06001O>elKGc]O6`000U/L00EJo5/LFaaK75[l00800003Fa`005Kl00IFo0800003
D_aFo00000800006E_aBo5;lD_aFo00025;l10000e;l00EBg5;lD_aBo00000=Bo004D]aBo5;lD_`3
000;Ool001Uoo`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Moo`03001oogoo00=oo`80
02]oo`<001Eoo`80000YB]e>oD[LC_e:gDkmB]`004KMB_i6gD[nA]e:oTKMB_h004;N?[e2gT;M@]hn
_D;N000j_SJM>[hfWCZn=Yd002im;WhZOBin;Wd0028L9SdR?003000022Xl;S`Z?2hm:S`002gk<Q`2
;Q/022gk000anS8J<OXf6c7j<QX500006Shj>QT003hH@QTn6D8I?QQ26@00ASU264Hi@QQ6>D8HASU2
6000AQQ:>DHhBSU664XiASP400005E9iCUQBNE9HDWU>F59iDUP005JIF[YFVEZiEYUJ^UJIF[T006;j
G]URnP02000076LjJeYW>@00KgUcNVmiLiY_N@00LiQgVG>HMiT007NhLiQgV000MiQcUgNHLiMgV000
MiQcMgNH0P0001E[FFmjKgU_NV]IKgX006mjJeU_NV]JKgX006]JIcY[FP00HcaO>f<kGa/00P0000]S
?5lKHcaO6f<l001K75KkFaaFne/L0080000<E_]K75Kk001BneKlD_aFo5;kE_aBo5Kl0`0000mFo5;L
E_aBg5KlD]aFo5;L001Bg5KlD]aFo5;LE_`00P0000mBg5Kl001Bo5;LE_aBg5;lD]aFo5;L001Bg5Kl
D]`0100000=oo`00Ool02goo000IOol00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool0
0`00Oomoo`03Ool00`00Oomoo`0WOol3000IOol01@00C_e>oDkmB]d00dkm00U:g@00A]e:oDKMB]e6
gD[mA]d04P0000H^ORim;Wd^O@008S`39Sd500000bhl000^6`04;Q/01000<OXanS8J0c7j00D003Gi
>OTenCWi00H000926@0>?QU26@00ASU264HIAQQ6>D8HAQU66000ASQ:>0@00003BSQ:>@0000=BN@05
DWQBNE9iDWUBN002DWT00`00EYUJ^@02F[T01EJIF[T006;jG]T00V;i00ERnUkI001W>P0000E_N@06
001cV7>ILiQcV@0017NH00<007NHMiP00WNH00T007NHMgQgV7=h001cN000KgT00fmj00<006]JJeX0
0f]J00<006]JJeX00f]J00d006<k000005lKGc]O6elkGa]O>elKGc/00002Fa`200001e/LE_aK75Kl
FaaFo00000EFo0<00004E_`005;lE_`3D_`01EKlD_aBo5;l00000U;l0`000e;l00EBg000D_aBo5;L
00=Bo003D]aBo00000<000Ioo`03001oogoo00Uoo`006Goo00<007ooOol00Woo00<007ooOol037oo
00<007ooOol00Woo10001Goo00<007ooOol09Goo0`007Goo0P0000Y:gDkmB]a>oD[MC_e:g000A]e:
oP@0000AA]e:oP00@]hn_D;N?[e2gSjm@]h003JN<Ydf_S:M=YhbW@0500002Rim000R72Hm8S`V?@00
8Q`Mnb7l0`0000<^6bgk<Q`00RhK014003HK<OXb6S7j=Q/anP00=OTj6SGi>QXenCXJ000n6Cgh0100
000FCUU:>4iIBSQ>FDXhCUT0059iDUQBNDiHDWUBF59iCUQBN@00F[UFVEZjEYT200009V;jG]URnUkI
H_YNfF;jG]T006miLgY_NG>JKgT007>HMiUcV7NI001g^7>HMiQcU`00LiMgV7>GMiP007NHLgMgV7=h
MiP007NHLgP200006fmj001_NV]IKgY[FVmj001[FVLjJeYW>V]JIcY[FP00HcaO6f<lGa]S?5lKHcaO
6f<lGa]S?00200002eKkFaaFne/LE_]K75KkFa`005KlD_/00`0000=BneKlD_`00P0000UFo5;LE_aB
g5KlD]aFo5;LE_`00`0000iFo5;LE_aBg5KlD]aFo5;L001Bg5;lD]aFo5;L0P002Woo00<007ooOol0
2Goo000IOol00`00Oomoo`02Ool00`00Oomoo`0=Ool01@00Oomoogoo000027oo00<007ooOol08Woo
0`008Woo00D004kmC_e:gDkm00D0000?B]e6gD[MA]e:gDKMB]d004;N?[e2gT;M@]hn_D;N00800006
<YdfWSJN=YhbW@000bIM10000bHm00H0027l8O`Qo1gk8O`20003;Q/01@00<OXanS7j<QX00S7j00l0
03Wi=OTinCGi>OTen@00?OTn6Cgi?QTmnChI00000THH00U66D8HAQQ664HI@QQ66000BST00dXh00I:
>DXhBSQ:>000DWP3DWT03E9hDWUBNE9iDWQBN@00F[UFV@00H_URnUkI009Rn@07H_YNfF;iH_T006/i
00000fmi00L007>HLiUcV7>ILiP00003MiP00`00MiQgV002MiP01`00MiQgN7NHLgQgV00000EcN003
001[FV]J00A[FP03001[FV]J00A[FP0;001W>P00Gc]O6elkGa]O>elKGc]O6`0200002UlK001K75Kl
FaaFo5/LE_aK75Kl0`001eKl0P000U;l00=Fo5;lD_`00`000U;l00<005;LD_`00U;l00EBg5;lD_aB
o000009Bo0<000aoo`03001oogoo00Uoo`006Goo00<007ooOol00Woo00<007ooOol027oo00<007oo
Ool00Woo00D007ooOomoo`0000Qoo`80021oo`<002Ioo`@0000MC_e:g4kmB]`004KMB_e6gD[nA]e:
oDKMB_h004;N?[e2gSjm@]hn_D;N?[d003:M=[hbWCJN<Yd000029Ud00b8m9UhVG@0300002B8l000M
nb8L7O/Qo1gk000QfP020000A38L;Q/0037j=Q/anS8J<OXf6`00>QXenCXJ=OTj6SGi000mn3hI?OPn
6Cgh?QT004Hi@QQ66D8HASU264HI@QP004XhCUU:>4iIBSQ>FDXhCUU:>000CUQBNE9HDWU>F59iDUQB
NDiH001FV@00G]URnUkIH_YNfF;jG]URnUkI001W6F/iIaT20000<g=j001gVG>HMiUcV000LiQgV7>G
MkP007NHLiMgV7>G001cMgNHLgQgV000MiQcN7MhLgQgV000LgT006mjJeY_NV]I001W>V]JIcY[FVLj
JeX006]KIcY[FP00HcaO6f<lGa]S?00200002UlKGcaO6elL001K75KkFaaFne/L0P0000iFne/L001F
o5;kE_aBo5KlD_]Fo5;l001Bg5Kl0`0000iFo5;LE_aBg5KlD]`005;LE_aBg5KlD]aFo5;L0`003goo
00<007ooOol02Goo000JOol4000;Ool60003Ool50004Ool00`00Oomoo`0MOol2000ZOol02000C]e>
oDkMC_e>gDkmC]d200003D[MA]e:gDKMB]e6gD[M0012gSjm@]i2gD;N00L00003=YhbW@0000DVG@03
000Eo000008000067O/Qo27l8O`Mn`000R7K0`0001Hb6S7j<OXanS8J<OX003Gi>OTenCWi=OTin@00
?QTmnChI?OTn6Cgi001260966009AQU264HHAQQ66D8H001:>4Xi00=:>006BSU:>4Xh001BNE9h0e9i
00UBN59iDWUBNE9h001RnF;jG]T00V;i00ERnUkIH_URn@0000I[>@06001cVG>HLiUcV00017NH00<0
07NHMiP00WNH00H007MhMiQcN7NH0005LgP01000LgQcN7=h0P0000=[FP00JeX01F]J00<006LjIcX0
0fLj00<005lkGa/00P001UlK00<005KlFa`00`000UKl00AK75KlE_`000MFo0<0009Bo005E_aBo5;l
D_aFo002D_`01000D_aBg5;l10004Woo00<007ooOol02Goo000kOol00`00Oomoo`0JOol3000]Ool0
3P00B]a>oD[LC_e:g4kmB]a>o@00B_e6gD[nA]d800001d;N?[e2gSjm000^OC:N00D000079UdR?BIN
000Io1Gk6O`00P0000TMnb8L7O/Qo1gk000QfR7K8MX00`0002hanSHK<OXb6S7j000enCXJ=OTj6SGi
>QX003hI?OPn6Cgh?QTmn000@QQ6>D8HAQU264Hi@QQ66@00CUU:>4iIBSQ>FDXhCUU:>000DUQBNDiH
DWUBF59iCUQBN@80000BEYP005kIH_YNfF;jG]URnUkI001W6F/iIaU[>VLIJcT007=i0P0002=cV7NI
001gV7>GMkP007NHLiMgV7>G001cMgNHLgQgV7=g001cN7MhLgQgV7=h001_F7=iLeQcNFmH001W>V]J
IcY[FVLj00800007Je]W>V]JIcY[FfLjJeX00P0000UO6elLGa]O?5lKGaaO6ellGa/00P0000aK75Kk
FaaFne/LE_]K75Kk001Bo5KlD_/4000035Kl000005;LE_aBg5KlD]aFo5;LE_aBg0@001Ioo`03001o
ogoo00Uoo`00>goo00<007ooOol05goo0`00<Goo00P004kMC_e>gDkmC]e>oDkM1@000T[M0156gD[M
0012gSjm@[hn_D;N?[e2_Sjm000bOC:N<YdbWS9m00H000046O`Eo1Wl5O`200038O`01P008M/Qfb7K
8MXQf`<0008anP0B<QX003Wi=OTinCGi>OTen@00?OTn6Cgi?QTmnChI00166D8H0THH00I66D8HAQQ6
64HI0002BSP01dXiBSQ:>4XhBSU:>000009BN@03DWQBNE9i00800004FYUFVEZI0002H_T01F;jG]UR
nF;i00001f/i00@006mHKeU_F0<000=gV00;001gV7NHMiP007MhMiQcN7NHMgP00005LgP01000LgQc
N7=H0W=h00<006mH00000f]J00<006LjIcX01VLj00<006Lj00001elK0P0000=O6`00E_`00UKl00IK
75KlE_aFo5/LE_`300001U;lE_aFo5KlD_aFo08000=Bo003E_aBo5;l008001Yoo`03001oogoo00Uo
o`00>Woo0`005Goo0`00=Goo00<004[LC_d0100000Y:g4km001:gDKMB_e6gD[MA]e:o@80000A?[e2
gSjm@]hn_D;N000bWRim<Yh^OC:N;Wd001hL7SdJ7002000011Wl5O/Io1Gl0`0000PMnb7l000Unb7J
8M/QfP000RWJ0`0002Db6P00>QXenCXJ=OTj6SGi000mn3hI?OPn6Cgh?QT004HI@QQ6>D8HAQU264Hi
@QP004XhCUU:>4iIBSQ>FDXhCUT0059iDUQBN@0200006eJIF[UFV5ZiEYUJ^@00H_YNfF;jG]T006LI
JcUW6F/jIaU[>FLI001_F7=iKeQcN@00MgQcM`040000>GNHLiMgV000MiQcN7NHLgL007=hMgQcN7NH
LgP006mHLgUcF7=iKeP006mHLeU_F000IcX006LjJe]W>V]JIcY[FfLjJeX006LkIcX005lKGcaO6elL
Ga]O?000GaaK6elL001K75KkFaaFne/LE_]K700200003UKk001Bo5KlD]]Fo5;lE_aBf`00D_`005;L
E_`3000MOol00`00Oomoo`08Ool003Yoo`03001oogoo019oo`<003Uoo`800007C_e>g4kmC]e>oDkL
C_d00P0000E6gD[MB]e:gDKM009:g@0C000n_D:n?[e2gSjm@[h003:N<WdbWS:M<YhbO@007QdN?AhL
7Sd00P0000DEo1Wl5O`0016k00<000068MXQfb7K8M/QfP0012WJ0`00010inCGi>OTenCWi000n6Cgi
?QTmnChI?OT004HHAQU260966005AQU264HHAQP00003BSP01DXiBSQ:>4XhBST00`0000YJVEJIFYUF
VEZIEYUJVEJIFYT0009Rn@03001[>F/i00E[>@0;001_F6mIKeQcFFmH001cN7MhLgP00002MgL30000
1GNHLgQgV7Mh00001G=h00@007=hLgQcF0=cN006001cF6mHLeU_F00026Lj00<006LjIcX00VLj00@0
05lKGa]O6`8000EO6`03001K75Kl009Fo08000AFo004001Fo5KlD_`3E_`00e;l00000002000POol0
0`00Oomoo`08Ool003Yoo`03001oogoo00moo`<003eoo`0?001>g4kmB]a>oDkLC_e:g4kmC]`004KM
B_e6gD[M00h00008;WdbWRim000N71hm6Q`N?@<000056O`0016k3IXA^`0200001B7J9O/QfR7K0000
0bWJ00@Y^BWJ000en@@0000J=OTj6P00?QTmn3hI?OPn6Cgh001264HI@QQ6>D8HAQU264Hi001>FDXh
CUU:>4iIBSQ>F@80000VEYQJ^EJIF[UFV5ZiEYUJ^EJHF[UFV@00G]T006LIJcUW6F/jIaU[>FLI001_
F7=iKeQcNFmH001cMgMhLgMgN000MiQgMgMh001gM`80000KLgMgV000MgQcN7NHLgP006mHLgUcF7=i
KeQcN@00LeU_F7=iKeP006lh001W>V]JIcY[FfLj00800007Ic]W>VLkHcYW>`00Ga`00P0000YK6elL
Fa]O75/KGaaK6`00E_]K7080000=E_]K75KkFaaFne/L001Fo5;lE_aBfeKlD_`00`008Woo00<007oo
Ool027oo000jOol00`00Oomoo`0<Ool30011Ool200001dkmC]a>oDkMC_e>g4km00D000A:g@05000n
_Cjm?[dn_P02?[d00`00;Wh^O@0600001Ahm7Q`N?@002K/00`00116k0P000b7K00<002WJ:MX00bWJ
00<0037I<MT00S7I100000Hn6Cgi?QTmnChI0002AQP02THI@QQ664HHAQU264HH001:>DXh100000m>
FDiH001FVEZIEYUJVEJIFYUFVEZIEYUJVEJI000026/i00P006mIKeQcFFmH001cN7Mh0W=h00<007Mg
MgL00WMg00@007MgMgMgM`8000EcN003001cN7=H00=cN00:001cF6mHLeU_F7=H001_FFmH0003IcX0
0`00IcYW>P06IcX00`00Ga]O6`08Ga/20009E_`00`00E_aFo0030003Ool00`00Oomoo`0OOol00`00
Oomoo`08Ool003Yoo`8000Yoo`<004Ioo`03001>oD[L00@0000AC_e>g000A]e:oDKMB]e6gD[mA]d0
03jm@]hn_D:n?[e2gP0200001BYm;Wh^OBin:Wd00`0000DJ70002I/9^`VJ008000054K/=VQ6k000E
VP0200000b7J000Y^@03:MX02RVi000afCGi<MTenS7I=OT003hI100000Lmn3hI0016>D8HAQU26007
0000:TiHDWU>F59iCUQBN@00F[UFV5ZiEYUJ^EJHF[UFVEZiEYP005kI001W6F/jIaU[>FLIJcX007=i
KeQcNFmHLgT007MhLgMgN7=g001gMgMhLgL0009gM`04MeIgM`00MgL20000:7=hMgP007=iLeQcNFmH
LgT007=IKeQcNFmHLeT007=IKcQ_FFlh001W>P00HcYW>fLjIc]S>VLkIcYW>`00Ic/005lLFa]O75/K
GaaK6elL0P0000]Jn`00E_]K75KkFaaFne/LE_]K75Kk00<000Ioo`03001oogoo01moo`03001oogoo
00Qoo`00>Woo00<007ooOol01goo0P00BWoo0P0000Q>g4kmC]a>oDkLC_e>g0001d[M00D003jm?[dn
_Cjn00<n_@08000^OBim;Wd^ORim000Eo0<00089^`042I/9^`0000024K/00`005IXEVP030005:MX0
0`00<MTaf@04<MT01@00?OTmnCgi>OP01`0001a664HiAQQ6>@00CUU>F4iICUQ>FDiHCUU>F4iI001J
VEJIFYUFVEZIEYUJVEJI001NfF;IG]T000A[>@08001_FFmHLeU_F6mI001gN0=cN003001gMgMg009g
M`03001gMgMg009gM`04001gMgMgMeL200000g=hLeQcN002LgP02@00LeQ_F7=IKeQcF000KeU_F003
KeT00fmH001W>P06IcX2000016LjHcYW>P0015lK0P0000EO6e/KGa]K6`0000IFo08000Yoo`03001o
ogoo01ioo`03001oogoo00Qoo`00>Goo00<007ooOol01Goo0`00CGoo01H004kmC]a>oDkLC_e>g4km
001:gDKMB_e6gD[MA]e:oDKM000n_D;N?[e2_PD00007;Wh^OBin000Eo17l5O`00P0000l9V`Vk2IX0
005I000=VP004GXEVQ5i5IX002WJ:KT00bWJ04D003Gj<MTenC7I=OXaf@00>OPn6CWh?QTin3hI>OP0
04HHASU664HiAQQ6>DHHAST0059iCUQBNDiHDWU>F59iCUQBN@00F[UFV5ZiEYUJ^EJH001NfF;IG]UR
nEkI001W6F/j001cNFmHLgU_F7=i001gN7=gMgQcM`00MgMgN7=gMiP007MgMeH00WMg02T007=FMgMg
EWMg001gM`00LgU_F7=iLeP006mHLgU_F7=I001cFFlhKeU_>7=IKcP006/h001W>VLkHcYW>fLj001S
6VLkHaYW>f<JIc/005lL0080000:F_]O75[kGaaJnelLF_/005KkFa`3000=Ool00`00Oomoo`0MOol0
0`00Oomoo`08Ool003Uoo`03001oogoo009oo`<0055oo`09001>oDkLC_e>g4kmC]a>o@0000E:g@L0
0004?[hn_Cjm?[d600035O`02Q7l000000Vk2I/000EI000A^`0011FJ0P0012WJ00<0037I<MT00c7I
00<003gi>OP00cgi01Xin3gi0016>DHHASU664HiAQQ6>DHH001>F4iICUQ>FDiHCUU>F4iICUP005JI
FYUFVEZI0P00011NfF;IG]URfEkIH]UNf@00JcT006mHLeU_F6mIKeP000=cN003MgP007Mg00=gM`03
001gMgMg009gM`03001gMgMG009gM`03001gEgMG00800009LeP006mHLeU_F7=HKeP006mH00=_F@06
KeP006liKeU_>@000fLj00@006LjIcYS>P=W>P0=HcYW>P00Ga]K6elKFa]O6e/KGa]K6elKFa/00P00
47oo00<007ooOol07Goo00<007ooOol027oo000iOol5001EOol01@00C_e>g4kmC]`02000011:gDKL
B]e6g@00?[dn_Sjm?[hn_Cjn?[d002YM:WhZG@<000034O`Eo17l00<000032IX0005I008000065IXA
NQFJ4GT001fI0P000RWJ0480037I=OXafCGi<MTenP00?QTin3hI>OPn6CWh?QT004HiAQQ6>DHHASU6
64HiAQP004iHDWU>F59iCUQBNDiHDWU>F000EYUJ^@00H_UNfF;IG]URnEkIH]UNfF;iG]T006mHLgU_
F7=iKeP007=gMgQcMgMh001gN7=gMiQgM`00MeH3MgL07P00MgMgEWMgLeH007=GMgMcEWMgLeL006mH
LgU_F7=IKeP006lhKeU_>7=IKcP006/hKeU[>6mI001W>`800007HaYW>f<JIc]S6VLkHaX00P0000UW
>`00GaaJnelLF_]O75[kGa`00P004goo00<007ooOol07Goo00<007ooOol01goo000iOol2001IOol4
00001DkLC_e>g4kM000024[M00D003jm?[dn_Cjn008n_@03000ZOBYM008ZG@06:Wd00000000Eo000
0P5I0P000`EI00<001FJ5IX00QFJ00<001fI8IX00P0000<YfP00<MT0137I00@003gi?OTin0<mn@0X
>OP004HHASU664HiAQQ6>DHHAST004iICUQ>FDiHCUU>F4iICUQ>F@00FYT006;IG]URfEkIH]UNfF;I
G]URfEkI001W6@00KeQ_FFmH0003LgP00gMh001gM`03MgL00`00MgMgM`03MgL00`00MeMgM`02MgL0
3@00MeMgEgMgMeL007=G001_F7=HKeP006mH00=_F@04KeP006liKeT3KcT00fmI001W>P02IcX03f<j
IcYW>VLjHcX006<JIc]S6V<j001O6e/KGa]K6`02000FOol00`00Oomoo`0LOol00`00Oomoo`07Ool0
02moo`D000Ioo`03001oogoo05Qoo`08001>oDkLC_e>g4kmC]a>o@80000FA]a:gDKMB]e6g4[MA]d0
03jm?[hn_Cjn?[dn_P00:WhZGBYn:UdZOP003M`30000405j0ET1FP001EX1F@EJ000EVQ5j5IX0026j
7ITQ^QfI0P00020enC7I=OXafCGi<MT003Wh?QTin3hI>OPn6CWh001664HiAQQ6>DHHASU66000CUQB
NDiHDWU>F59iCUQBNDiH0P0000iRnEkIH]UNfF;iG]URfEkIH_UNf@00IaQ[6FLH0P0000acN@00MgQc
MgMhLgL007=gMiQgMgMh0003MgL03gMF001gEWMgLeIgM`00MgMcEWMgLeMgM`00MeMcE`0200005G=i
001_FFlhLeU_>6mI001_FF/hKeU[>6mI001_>@00Ic]S6VLkHaYW>`02000026<JIc]S6VLkHaX005[k
Ga`2000IOol00`00Oomoo`0KOol00`00Oomoo`07Ool0035oo`03001oogoo00Moo`8005Uoo`0:001>
oDkLC]e>g4kmC]a>gDkL0004B]d<0003:Ud012Ym0009^`Vk0P000`5I00<000EI1ET00`000QFJ00H0
026I7ITQVQfI8IT20004<MT01@00?OTmnCgi>OP00cgi010004HiAQQ6>DHHASU664HiAQP004iHCUU>
F4iICUQ>F@80009FV@0A001RfEkIH]UNfF;IG]URfEkI001W6F/IIaU[6FLIJaT00002LgP00gMhLgP0
0004MgL00`00MgMgM`02MgL00`00MeMgM`02MgL017MG001gEgMg0WMG00L007MGLeMgEg=GMeL00003
KeT016mHKeT006mI0fli00E_F@00JcU[>Fli0080000;IcX00000HcYS6VLkHaYS>V<JIc]S6P02000K
Ool00`00Oomoo`0KOol00`00Oomoo`07Ool0035oo`03001oogoo00Uoo`03001oogoo05Moo`08001>
oDkLC_e>g4kmC]a>o@D0000;B]e6g4[MA]d003ZM?[hjWCjn>Ydn_P05000022Yn000=g0Vk3M`0005j
0ET200003PEJ0ET000Dh000ANP007ITQ^QfI8KXMV@00;KT2000063Gj<MT003Wh?QTin3hI>OPn6CWh
?QT004HiAQQ6>DHHASU664Hi001BNDiHDWU>F080000EEYUBN5JIEWP005kIH_UNfF;IG]URnEkI001W
66/IIaQ[6FLHJaT006mH00800008LgMgN000MiQgMgMhLgL0009gM`0^MeIgM`00MgMcEWMgMeH007=F
MgMcEgMgLeH007=GMeMcEWMG001gE`00LeU_>6mI001_FF/hKeU[>6mI001_>F/hKeU[>FliJcP006<J
Ic]S6VLkHaYW>f<JIc/2000NOol00`00Oomoo`0JOol00`00Oomoo`07Ool0035oo`03001oogoo00Yo
o`03001oogoo05Moo`03001>oDkL00@00004C]e>g000A]d3B]d00dKMB]e:g@020002?[d01cjn>[dn
_@009UdV?BIM00<00089^`042M/000000ET200021ET03@001CP001FJ000MVB6I7ITQVQfI000]^BgI
00800003<MT003Wh00<mn@0>>OPmnCgi001664HiAQQ6>DHHASU664Hi001>F@800005EWUFVEJIEYUF
N@02EYT03`00G]URfEkIH]UNf@00IaU[6FLIJaUW6F/IIaT00003KcP20004MgL00`00MgMgM`02MgL0
2000MgMgMgMgMeL007MGMgL3MeL01`00LeMgEg=GMeMcE`00009cE`04001_F@00KeT3KcT01FmI001[
>F/iKcT00f/i00X006/i001S6VLkHaYS>V<JIc/0025oo`03001oogoo01Uoo`03001oogoo00Moo`00
<Goo00<007ooOol02goo00<007ooOol0Egoo0P0000M>g5;mC]a>oDkLD_e>g00200004d[MA]e:gDKL
B]e6gD[M000n_SZM?[hjWCjn000VGB8m9UdV?BIM008000052K/=g0000001F@0400003PEI1CP00000
8KXMVB6j7ITQ^P00<MT]^BgI;KT600002ChI>OPn6CWh001664HiAQQ6>@0500007EJIEWQFVE9hEYUF
N5JIDWQFV@00H]UNfF;iG]T006LHJaUW66/IIaQ[6FLH001_>7=IKcQ_F000LeP00P0000EcMgNH001g
MgMF009gM`0S001cEWMgMeIgM`00MgMcEgMgLeH007=GMeMcEWMGLeL007<gMeMc=gMG001_FF/hKeU[
>6mIJcP006/hKeU[>FliJcP00002JcT01F/h001S6VLkHaX00P008Woo00<007ooOol06Goo00<007oo
Ool01goo000aOol00`00Oomoo`0<Ool2001HOol02`00C_e>g4kMC]a>oDkLC]e>g4km00000d[M00=6
g@0000001@0000Dj_Cjm000VGBHm00<VG@@000050?L0005I0000m`0200004`Di1CP5>@008IXMVB6I
7ITQVP00;MT]^BgI;KT]f@00?QTinCgi00T00006BUU:>4XiBST005Ii0eJI019FNEJIEYUFVEIiEYT0
06;IG]T006LIJaUW6F/IIaU[6FLI0005KcP01000LeMcEg=G0P0017Mg00L007MgMgMgEgMg001gM`03
MeL01gMg001gEg=GMeMcE`0000AcE`03001cE`00009_>@05KeU_>@00JcU_>@03JcT00`00JcU[>@02
JcT01000HcX000009Goo00<007ooOol06Goo00<007ooOol01Woo000_Ool3000@Ool00`00Oomoo`1F
Ool02@00C_e>g5;mC]a>oDkLD_e>g00500001dJlB]e6gD[M000n_SZM00D000068SdVGBHm0001NPFK
0P0000X0m`000000n03G0005>0EI1CP5F@80000l7ITQ^QfI000]^C7I;KT]fBfi000in3hI>OPn6CWh
?QTin000BSQ:FDHhBUU:>4YIASQ:F@00EYUBN5JIEWQFVE9hEYUFN5JIDWP005kI001W66/IIaQ[6FLH
JaUW6000KcQcFFlhKeQ_>000LeMcF7<gLeP007MG0P000WMg01P007MgMeIgMg=F001cEgMgLeIgM`00
MeMcEWMGLeMgE`00MeMc=gMGLcL007<gLeL2000026/h001[>6mIJcU_>F/h0002JcT01F/hKcU[>F/i
0000:7oo00<007ooOol067oo00<007ooOol01Woo000aOol00`00Oomoo`0?Ool00`00Oomoo`1FOol0
1000C_e>g4kM1000011>g4km001:gDKMB]e6gD[MA]e:g@00>[djWCZn>Ydj_@H000071GX5VPFJ0000
m`3h00000P3g01@000Di1CT5>0005GT001fI8ITMV@00;KT]fBfi;MT]^@00?OTn6CWi0Sgi00Hn6CWi
001:>DYIBSP2BST01TYIBSQ:>@00EYUFN@=FV@0?EWUFVEJIEYUFN@00IaU[6FLIJaUW6F/IIaU[6@00
00E_>006001cEg=GLeQcE`000WMG00EcE`00001gMgMG009gM`0<001gEgMGMeMgM`00MeMcEgMGLeMg
E`0017=G00T007<gLcMc=g=GLcL006/iKcT00f/i00=_>@00JcT016/i00<007ooOol0:7oo00<007oo
Ool05goo00<007ooOol01Woo0014Ool00`00Oomoo`1FOol300006DkmC]a>oDkLC_e>g4km001:gDKM
B]e6_4[MA]d003ZM?[hjWCjn>Ydn_P008SdN728m0080000?0GX5V`5j0000m`4H0000n03G0005>0EI
1CP001EI0080000m8KX002gI;KTafBfi;MT003hI>OPn6CWh?QTin3hI001:FDXhBUU6>4YIBSQ:FDHh
001FN5JIDWQFVEIhEYUBN5JIEWP005Zh001W66/IIaQ[6FLHJaT007=IKcQ_F6lhLeT007=HLcMcF7=G
001cEWMGLeIgE`00MeL00P00029cEWMg001gMg=FMgMcE`00LeIgEg=GMeL007MGLcMgEg<gMeL007=G
LcMcF7<g001_=`00JcU_>F/hKeT006/iJcQ_>@9[>@03001oogoo02Uoo`03001oogoo01Moo`03001o
ogoo00Ioo`00AGoo0P00Egoo01/004kmC]a>gDkLC_e>g4kMC]`004KMB]e6gD[MA]e:gDKM000jWCZm
>Ydj_SZM>[d0028m7Sd00R8m0P000PFJ00D0003g0000003g00<000031CT5>000008EN@<00006;MT]
^BgI;KT]f@000Sgi00Hn6CWi?OTmnChI0002BST01dYIBSQ:>DXiBUU:>000009FV@04EWUFVEJIEYT2
00002EjiG]UN^@00IaU[6FLIJaT00005KcP01000LeMcEg=H0W=G00<007MGLeL00WMG00@007MFMeIg
EP80009gE`09MgMgE`00LeMgEg=GMeMcE`0000AcE`04001c=g<gLeL2LcL01`00LcMc=`00JcU_>@00
00E[>@03001oogoo02]oo`03001oogoo01Ioo`03001oogoo00Ioo`00Agoo00<007ooOol0EGoo0P00
00a>g4kmC]a>oDkLC_e>g000A[a:gDKMB]d<00000ahL8SdN?0080000B@3h0000m`001ET001Ei5ETE
NAEH000]^BgI;KTafBfi000in3hI>OPn6CWh?QTin000ASQ:FDXhBUU6>4YIBSQ:F@00EYUFN5JIDWQF
V@00G]UJ^5kIF[UNfEZh001W66/I001cFFlhKeQ_>7=IKcP007<gLeQcEg=H001gEg=FMeMcEP00LeIg
Eg=FMeL007MF0080000LLeMgM`00MeMcEgMGLeH007<gMeMc=gMG001cEg<gLeQc=g=G001cF6lgLeP0
06mI001[>F/hKcT2JcT00`00Oomoo`0]Ool00`00Oomoo`0EOol00`00Oomoo`06Ool004Qoo`03001o
ogoo05Ioo`05001>g4kMC]a>o@0700001D[MA]e6gDKM00000cZM00<jWSZM>Yd01P0000@1F@000000
]P@000050=L0m`001CT000035GT300001RgI;KT]fBfi000in@8mn@06?QTinCgi001:FDXh0TXi00I:
FDXhBSU:>DYI0003EYT01000G[UN^EkI0eji00ENfEji001W6@0000E_>003001cEg=H00=cE`03001c
EgMG009gE`06001gEWMFMeMgEP000gMF0P0000EgEg=GMeMcE`0000EcE`03001c=g=G009c=`03001c
=g<g00=c=`03001[>F/i00A[>@03001oogoo02eoo`03001oogoo01Eoo`03001oogoo00Ioo`00BGoo
00<007ooOol0EWoo100000a>oDkLC_e>g000A[a:gDJmB]e6_4[MA[d200002CZn=Ydj_SJM>[h001hM
6Q`N?@0200001P4i0EX0002f0000U@80000:0=L0m`00000EF1Ei5ETEN@00;MT200005Bfi<MT003hI
>OPn6CWh?QTin3hI001:FDHhBUU:>4YIASQ:FDXh001BN00200008ekIF[QNfEZiG]UJ^5kIF[UNfEZh
001_>6mHKcQcFFlh001c=g=HLeMcF7<g001cEWMGLeIgE`00MeMcEWMGLeH007<fMeL00WMF01Yc=P00
000007=FMeL007MGLcMgEg<g001c=g=HLcMcEg<g001_=g=HKcMcF000LcP006li0V/i00=[>000Ool0
<7oo00<007ooOol05Goo00<007ooOol01Goo001:Ool2001GOol02@00C]a>gDkLC_e>g4kMC]`00003
A]d01T[MA]e6gDKMB]d0008jW@08>YhjWCZM000N7AXL6QdJ7080000<0ET0002f0000U@000?L0e`3g
0=L001EI0QEi00@002Vi:KTY^@800004;MT003hI>OT2?OT01ShI>OT004XiBUU:>09:>@03BUU:>000
008000=N^@05G]UN^EjiG[UNf@03G[T00`00I_P00004KcP00`00LeQcE`02LeL00`00LeMgE`02MeL0
17=G001gEWMG0WMF00<007MFMeH00WMF00@007LfMeIgEP8000EcE`03001cEg<g009c=`03001c=g<g
00=c=`03001c=g<g00800003JcT007oo039oo`03001oogoo01Aoo`03001oogoo00Eoo`00C7oo00<0
07ooOol0EGoo00h004kLC_e>g4kmC]a>oDkL0016_4[MA[e:gDJl1`0000LfWCZn000N7AXL7SdJ7002
00002@5J0000]P0009D0003g0=L0m`0200001QEH5GTEF@00:KT]f@8Y^@D00007?QTin3hI>OP004Xh
BUT0100002I>FE9iCUT005ZhG]UJ^EkIF[QNfEZiG]UJ^000H_QVnF;h001_>6mH001cF7=GLeQc=g=H
001gEg=FMeMcEP00LeIgEg=FMeL007MG0WMF01ic=WMG001gEW<fMeH007MF001gEg<gMeL007=HLcMc
Eg<g001_=g=HKcMcF6lg001_=g<hKcMc>6lg000eOol00`00Oomoo`0COol00`00Oomoo`05Ool004eo
o`03001oogoo05Eoo`05001>g4kMC]a>o@080004A]d00`00=YdfW@0500000aXL6QdJ700400001`2f
0000U@000?L0e`3g008000035ETEN@0000HY^@03000n6ChI00L00003CWU>FDii009>N@04CUU>N@00
G]T3G[T01UkIG[UN^Eji001Vn0=Vn@04I_P006lh0003LeL00g=H001gE`02MeL017=G001gEWMG0gMF
00<007MFMeH00WMF00P007MFMeIgEWLf001g=WMF0P0000=cE`00LcL00W<g00=cE`00LcL00g<g00@0
07<gLcM_=`9c=`03001oogoo03Aoo`03001oogoo01=oo`03001oogoo00Eoo`00CWoo00<007ooOol0
EGoo100001=>oDkLC_e>g000A[a:gDJmB]e6_4[MA[e:g@00>YhfWCZN=YdjWP0600000`4G00000004
00001`3g0=L000Th000EF00000<Y^@05;MTY^BVi00126P02?QT053gi@QXn6ChI001BNDiIDWU>FE9i
CUUBNDiIDWT005kIF[QNfEZiG]T2000066;hI_URn6KiH_QVnF;h001cEg=HLcMcF7=G001cEWMGLeIg
E`00MeMcEWMGLeH0009gEP0OLcIgEgMF001c=WMFLcH007<fMeIc=WMFLcH007<gLeMc=g=H001cF6lg
LeQ_=g=H001c>6lgLcQ_=g<h0000=goo00<007ooOol04Woo00<007ooOol01Goo001?Ool00`00Oomo
o`1EOol02000C]a>gDkLC_e>g4kMC]`20007A]d01000=YdfWCJN0SJM00@001Gl5O`Eo080008160D0
00070?L0e`002CP001EI00001RVi00<003hI?QT013hI00<004iICWT00Tii00Q>FDiiCWU>NDiI001N
^EkI0Uji00<006KiI_P00fKi00YVn6KiI_T006/H001cEg=HLeL0009gE`04LeMgE`00MeL3MeH00gMG
001gEP03MeH01`00MeIgEWLfMeH007MF00=g=P06001c=P00LcMcE`001G<g00<007<gKcL00g<g00<0
07ooOol0=goo00<007ooOol04Goo00<007ooOol01Goo001@Ool2001FOol2000034kmC]a>oDkLC_e>
g4km001:gDJmB]e6_0L0000:=YdjWP005Q`Eo1HM5O`0004G0CP50000103g000=F@Th0P0000T]fBVi
:KTY^BgI:KT003gi@QX00ShI01dmnD8J?QT004iIDWU>FE9iCUUBNDiIDWU>F@00F[UNf@00I_URn6Ki
H_QVnF;hI_URn000JaQ_66/H0080000?LeP007MGLeIgEg=F001cEWMGLeIgE`00MeIc=WMG009gEP0L
001gEW<fMeH007MFLcIgEW<fMeH007LfLcH007<g001_=g=HKcMcF6lg001_=g<hKcMc>6lg000jOol0
0`00Oomoo`0@Ool00`00Oomoo`05Ool0059oo`03001oogoo05Eoo`05001>gDkLC_e>g00700001DJm
A]e6gDKM00000SJM1@000aGl00<0004H00001@0000@0m`003CP9>08000HY^@03000n6ChI00@n6@03
001>NDiI00=>N@09CUU>NDiiCWT005ji001VnFKh00=Vn@05I_QVnFKiI_T00005JaP00`00MeMcE`02
MeL01`00MeIgEWMFMeMgEP0000AgEP03001gEWLf009gEP06001g=WLfMcIgEP000gLf00=c=P00LcL0
17<g00<006lgLcL00W<g00=_=`00Ool0>Woo00<007ooOol047oo00<007ooOol01Goo001COol00`00
Oomoo`1EOol400004T[LC_e>g4km0016gDJmA]e6_DKMA[e6g@00=YhbOCJN<WdfWP<000035Qd00000
00D0000609H000002CP=F@Th0P0000T]fBVi:KTY^BgI000n6Cgi@QX00ShI01hmnD8J001BNDiIDWU>
FE9iCUUBNDiIDWT006KiH_QVnF;hI_URn6KiH_QVn@00KaQ[66liJaQ_6000LcP200002W=FMeL007MG
LeIgEg=F001c=WMG0WMF011c=P00LcIgEW<f001c=WMFLcIgEW<f001c=WMFLcIg=P80000:KcMcF6lg
001_=g<hKcMc>6lg000mOol00`00Oomoo`0@Ool00`00Oomoo`04Ool005Aoo`03001oogoo05Eoo`09
001>gDkLC]e>g4kMC]a>g@0000=6g@05A[e6gDKMA]d00002=Yd01CJN=YdfW@004O`00`0000<0m`00
00000`0000H0U@000009>0dh2CP30004:KT00`00?QTn6@04?QT01000CWU>NDiI0dii00E>F@00001F
V@0000=Vn@05I_QVnFKiI_T00006JaP01000KcM_>6lg0`0000EgEWMGMeIgEP0000AgEP03001g=WMF
009gEP06001g=WLfMeIg=P000WLf00Ec=WLf001g=W<f00800003LcL007<g009c=`03KcMc=`0003io
o`03001oogoo00moo`03001oogoo00Aoo`00EGoo0P00EWoo00d004kmC]a>oD[LC_e>g4km0016gDJm
A]e6_@0700001C9m=Yh0017l3M/00P0000h0m`000000000c0000UP003CT9>0eI000Y^RFi0P000RVi
00D003hI?QTmnD8J008n6@06?OT004iIDWU>FE9i0P0001UFVEZjEYUF^@00I_URn6KiH_QVn@00KaQ[
66liJaQ_66/H001_=g<hKaMc>000LcM_=P0200000gMG001gE`02MeH07G<fMeL007MFLcIgEP00MeIc
=WMFLcIgEP00MeIc=WLfLcH007<fMcIc=WLf001c>6lgLcQ_=g<h0000?goo00<007ooOol03goo00<0
07ooOol017oo001GOol00`00Oomoo`1DOol01@00C]e>g4kMC]`01`0000E6_DKMA[e6g@00008bO@@0
00054O`=g17L0000m`0500002@2E000=>0Th3CP002Vi9KTY^@0200000bVi000n6@05?QT00`00CWU>
N@020007EYT01@00I_UVnFKi00001V/H00L006lgKcQ_=flhKcL00004LcL20004MeH02000MeIgEWMF
McH007LfMeH2McH00`00McIc=P02McH01P00LcIg=W<fMcIc=P800005LcM_=g<gLcL00010Ool00`00
Oomoo`0>Ool00`00Oomoo`04Ool005Qoo`03001oogoo05Aoo`@0000BB]a>oDkLC_d004KMA[e6gD:m
A]e6_DKM000fWS9m<YhbOCJN0P0000@=fa7l0000m`@0000;07D000003CT9>0009KTY^RFi:MXU^@0;
000075JIE[UFVEZjEYUF^EJIF[YFV@00H_QVnF;h001[66liJaQ_66/H001_=g<hKaMc>6lg001_=W=G
0W<g029_=P00LcH007<fMeMgEP00LcIgEW<f001c=WMFLcIgEW<f001c=WLfLcIgEP00McIc=WLfLcH0
07<FMcL007<hKcL0049oo`03001oogoo00eoo`03001oogoo00Aoo`00FGoo00<007ooOol0E7oo0140
04kMC]a>gDkLC]e>g4kM0016gDJmA]e6_DKMA[e6g@00008bO@03<YhbOC9m00X0000609D000003CP9
>0000RVi00dU^BVi:KTY^@00@SY2>D8j@SU2>T8i@SX0000:EYT00`00I_P00006JaP01`00KcQ_=flh
KcM_>00000Ec=`03001c=g<f00<0009gEP04McIgEP00MeH3McH00`00LcIg=P02McH02000McIc=WLf
LcIg=P00McH2LcH00`00LcL00013Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool005Yoo`8005Eoo`0=
001>oDkLC_e:g4kmC]a>o@00A]e6_DKM@[d01@0000HbOC:N<Wd000Vk2M`200000`2E000000040000
;@DH00000000:MXU^BVj9KTYfRFi0012>DHj@SU2>T8iASY2>@00EYUJ^UJIE[UFVEZjEYUF^EJIF[YF
V@00JaQ_>F/HKaQ[66li001c>6lGLcQ_=g<h001cE`02LcL08flfLeL007LgLcIgEg<fMcL007MFLcIg
EP00MeIc=WMFLcIgEP00McIc=WMFLcH007<fMcIc=WLf001g=g<fMcIc5WLg0000A7oo00<007ooOol0
37oo00<007ooOol017oo001LOol00`00Oomoo`1COol01@00C]e>g4kMC]`01`0000A2_DKMA[e6g@H0
00052K/9f`Vk0000]@0300000`0c000000021AP20003:KT032Fi:KTY^@00@SU2>T8i@SY2>D8j@ST0
00QFV@800003G]T006/H00=[6007001_>6lgKcQ_=flh00001W<g00L007<fLcMc=W<g001g=P020000
0gMF001g=P02McH00gMF001g=P02McH027<f001c=WLfLcIg=W<f0003LcH00gLf001oo`15Ool00`00
Oomoo`0<Ool00`00Oomoo`03Ool005eoo`03001oogoo05=oo`@0000@B]a>oD[LC_d004KM@[e6gD:m
A]e2_DKM000bWRim<Wh3000010WL2K/0002E1@0002X4m`DH1AL002Fi:MXU^BVj9KTYfP00@SY2>DHj
@SU2>T8iASX005JiEYUJ^UJIE[UFVEZj001NfEjiG]YNf@00JaQ_>@00LcQ_5g<hKcMc>6lG0002LcL0
96lfLeMc=`00LcIgEg<fMcMc=P00LcIg=W<f001c=WMFLcIgEW<f001c=WMFLcIg=P00McIc=WLfLcH0
07<fMcIc5WLgLcH004Moo`03001oogoo00]oo`03001oogoo00=oo`00GWoo00<007ooOol0Dgoo0140
04kMC]a>gDkLC]e>g4kM0016gDJmA]e2_DKMA[d002im00<bO@07;Wd000000009^`000;D01@000`DH
0P000bVi00/U^BVi0012>T8i@SY2>D8j@SU2>P0000AFV@8000INf@09001[6000KcM_>6lgKcQ_=`00
00Ic=`0:001c=g<fLcMc=P00LcIg=W<fMcH2000017LfMeIg=P000WLf00Uc=WLf001g=W<fMcIc=WLf
00000W<f00=g=W<f0000B7oo00<007ooOol02goo00<007ooOol00goo001OOol2001DOol200005D[L
C_e:g4kmB]a>o@00A]e2_DKM@[e6gD:m000^OC:N;WdbORim0005VP08000010DH1?L560DG0`00010U
^BVj9KT0048i@SY2>DHj@SU2>T8i001FVEJiEYT0009Nf@0>G[UNfUkIG]UN^EkJG]T006lGLcQ_=g<h
KaL0009c=`0AKcIcEg<gLcL007MGLcIg=g<fMeL007LfLcIgE`00McIc=@0200004WMF001gEW<fMcIc
=P00LcIg=W<fMcH007LfLaIg=g<fMcH004Uoo`03001oogoo00Yoo`03001oogoo00=oo`00HGoo00<0
07ooOol0Dgoo00D004kLC]e>g4kM00d00003<Wd^O@000085^`D0000305<000DH00856003000YfRFj
00<000099KT0048i@SY2>D8j@SU2>T8i00<000UNf@08001Vn@00KcM_>6lgKcP000Ic=`0B001c=W<g
LcIc=`00McIc=WLfLcH007<fMcIc=WLf001g=W<f0WLf00T007<fMcIc=WLfLcH007<fMcH00W<f00<0
07ooOol0BGoo00<007ooOol02Goo00<007ooOol00goo001ROol00`00Oomoo`1COol400003DkmB]a>
o@00A]i2_DKM@[e6gT:m000^GBin00@000031IX5^`FJ00H000081AP4m`DH000YfRFi:MXU^@X00005
G]YNfEkIG[UNfP02G]T03UjiG]YNf@00H_QVnF;h001_5g<h001c=flfLeL2LcL04Flf001c=WLgLcIg
Eg<f001c=WMGLcH007<eMcIc=WLfLcD00P0000mg=W<fMeH007LfLcIg=W<f001c5WLgLcIg=W<F0000
C7oo00<007ooOol027oo00<007ooOol00goo001SOol00`00Oomoo`1COol02000C]a>gD[LC]e>g4kM
0002@[d01DKM@[e2_D:m00001Bim0P000PFk1P000PDH00P002Fj:MXU^RWJ9KXYfP000TYJ00I:NTIJ
BUY:FTYj0008G]T01000I_UVnF;i0VKi00<006lg00001W<g018007<gLcIc=g<f001c=WLfLcIg=P00
McIc=WLfLcH007<fMcH300001gLfLcIg=W<fMcH007Lf00=c=P03001oogoo04]oo`03001oogoo00Qo
o`03001oogoo00=oo`00I7oo0P00E7oo01@004[LC_e:g4kmB]a>o@00A]i2_DKM@[e6gT:m000^GBin
;Wd^ORiM2`000184m`009KTYfRFi:MXU^@00AUY:NTIJBWY6FTYjAUY:NP00G]X2G]T03UjiG]YNf@00
H_QVnF;hI_URn6KiH_P006lfLeL2LcL08VlfLeL007LgLcIgEg<fMcL007MGLcIg=P00McIc=WLfLcEg
=P00McIc5GLfLcD007<fMcIc=WLf001g=g<fMcIc5P00Cgoo00<007ooOol027oo00<007ooOol00Woo
001VOol00`00Oomoo`1BOol01@00C]a>gD[LC]d03@000Rim00<0006J00001@000P3g0P0000PYfRFj
:MXU^RWJ9KX004IJ0TYJ00I:NTIJBUY:FTYj0004G]T01000I_UVnF;i0fKi00ARn@00JaP000Ec=`0E
001c=W<gLcIc=`00McIc=WLfLcH007<fMcIc=WLf001g=W<fMcIc=WLf00800004LcIg=W<f0003LcH0
0gLf001oo`1?Ool00`00Oomoo`07Ool00`00Oomoo`02Ool006Moo`03001oogoo059oo`@000eoo`@0
00030IX5V`0000@0000R0?P0m`00000YfRFi:MXU^BWJ9KT004IJBWY6FTYjAUY:NTIJ001N^EkJG]T0
06;hI_URn6KiH_QVnF;h001Vn6/IJaP200006W=GLcL007<fMeMc=WLgLcH007<fMcIc=P00LcIg=W<e
McIc=P00LaEg=W<eMcH007LfLaD300001G<fMcIc5WLg0000DGoo00<007ooOol01goo00<007ooOol0
0Woo001XOol00`00Oomoo`1AOol00`00Oomoo`0BOol200000`FJ0000000200030?L2000022WJ9KXY
fRFj:MX004YjAUX2BUX01dYjAUY:FTYJ001Nf@00009Vn@08H_UVnFKiI_URnFKi001[6@=[600NJaT0
07<g001c=g<fLcMc=P00LcIg=W<fMcH007LfLcIg=W<f001c=WLfLcIg=W<f001c=GLfLcIg=P000W<f
00=g=W<f0000DWoo00<007ooOol01Woo00<007ooOol00Woo001YOol2001AOol00`00Oomoo`0DOol6
00000`3g0?P0m`0400002bWJ9KTYfP00BWY6FTYjAUY:NTIJBWX00P00031Rn6KiH_QVnF;hI_URn6Ki
001[6F/HJaUVn6/IJaQ[6@00MeMc=WLgLcIgE`00McIc=WMGLcH007<eMcIc=WLf001g=W<eMcIc5@00
LaEg=W<EMcH007Lf001g=g<f001DOol00`00Oomoo`05Ool00`00Oomoo`02Ool006]oo`03001oogoo
04ioo`03001oogoo01Ioo`D00080m`04000YnbWJ:OX400000dYJBWY6FP040002CYX00`00H_UVn@02
I_T016;iI_T006/I0f/H02A[6F/HJaP006lh001c=g<fLcL007LfLcIg=W<f001c=WLfLcIg=P00McIc
=WLfLcIg=P00McIc=WLfLcD007<fMcH007<f001EOol00`00Oomoo`04Ool00`00Oomoo`02Ool006ao
o`03001oogoo04eoo`03001oogoo01Qoo`@000080?L0n000:O/YfRgk:MXYn`@0000HCYYBVdjJDY]>
VU:K001VnF;hI_URn6Ki001[6F/HJaUVn6/IJaQ[6@00KcQ[5flh0P0001]c=P00LcIgEg<fMcH007Lf
LcIg=W<e001c=GLfLaEg=P00McIc5GLfLaD007<EMcIc5GLf0000EWoo00<007ooOol017oo00<007oo
Ool00Woo001]Ool00`00Oomoo`1<Ool00`00Oomoo`0IOol400020?L02P00:O/YfRWj:MXYnbWJ001>
VU:J0djJ00UBVTjJCYX006KiH_UVn@00JaT00f/H00I[6F/HJaQ[6000JaP2KaP07FlhJaP007<fMcIc
=WLf001g=W<fMcIc=WLf001g=W<fMcIc=P00LcIg=W<eMcH007LfLaEg=W<f0000Egoo00<007ooOol0
0goo00<007ooOol00Woo001^Ool2001<Ool00`00Oomoo`0JOol20000@03G00000000:MXYnbWJ;O/Y
fRWk001BVdjJDY]>VU:KCYYBVdjJDY/006KiH_P006/HJaUVn6/IJaQ[6FKh001[5flhJaM_>6/G001_
5`00LcIg=W<f001c=WLfLcEg=P00McIc5GLfLcD007<EMcIc5GLf001g=W<EMcIc5@00FGoo00<007oo
Ool00goo00<007ooOol00Goo001`Ool00`00Oomoo`19Ool00`00Oomoo`0KOol200020?L200001bWJ
:O/YfRWj:MXYn`00009>VP09DYY>VTjJCYYBVTjJ001Vn@0000=[6006JaU[66/HJaP006/H0VlH00I_
>6/HKaP006lhKaL300005G<fMcIc=WLfLcH007<fMcIc=WLf001g=W<eMcIc=P00LaEg=W<fMcH0001J
Ool00`00Oomoo`02Ool00`00Oomoo`01Ool0075oo`03001oogoo04Qoo`03001oogoo01aoo`0D0000
n03G0?L002gk:MXYnbWJ;O/YfP00CYYBVdjJDY]>VU:KCYYBV`80000YJaQ[6FKhJaU[66/II_P006/G
KcQ[5flhJaM_>000LcQ_5g<hKaMc>000McIc=GLfLcH007<EMcIc=GLf001g=W<EMcIc5@00LaEg=W<E
McH0001KOol00`00Oomoo`02Ool00`00Oomoo`01Ool0079oo`03001oogoo04Moo`03001oogoo01eo
o`040000m`3g0?L200001RWJ:O/YfRWj:MX000=>VP09DYY>VP00001FfUJj001[66/I00=[600S001[
66lHKaQ_>6/HKaP006lhKaM_=flGKcP007<g001g=W<fMcH007LfLcIg=W<f001c=GLfLcIg=P00McIc
=WLfLaD0001LOol01@00Oomoogoo00000goo001cOol20016Ool00`00Oomoo`0NOol200000`3h0=L0
m`05000012gk001BVdjJ0`0000EF^U[KE[YFfeJj0080000CJaUVn6/I001_>6/GKcQ[5flhJaL006lG
LcQ_5g<hKaL006lFLcL00`0000mg=W<eMcIc5@00LaEg=W<EMcH007LfLaEg=W<E0000GWoo00@007oo
Ool000=oo`00MGoo00<007ooOol0@goo00<007ooOol07goo0P000P3g00<002hK;Q/00RhK10000eJj
00EFfUJjE[YF^UKJ009F^P03001[6@00009_600;KcQ[66lHKaP006lGKcM_5flhKaL00002LcL04flG
LcMc=`00LcIg=W<fMcH007LfLcIg=W<e001c=WLfLaEg=P0005ioo`04001oogoo0003Ool007Ioo`03
001oogoo049oo`03001oogoo021oo`80000Z0?P0e`00;O/b6bhK<Q/]nc8K001FfeJjF]]F^UKKE[YJ
feJjE]]F^U[K001_>6/GKcQ[5flhJaL006lGLcQ_5g<hKaL006lFLcM_5g<gKaH006lF0P0000ag=P00
McIc5GLfLaD007<EMcIc5GLf001POol00`00Ool00003Ool007Moo`03001oogoo045oo`03001oogoo
021oo`D000H^6`03001F^UKJ00=F^P04E]YF^UJjE[X2000015kj001_>6/H0VlH00Y_>000KcM_5flh
KaM_=`00LcM_5`=c=`04001c=g<gLcL200002W<fMcIc=GLf001g=W<EMcIc=P00HGoo00<007oo0000
0Woo001hOol00`00Oomoo`10Ool00`00Oomoo`0QOol20000403G0000038K;O/b6bhK<Q/]n`00E[YF
feJjF]]F^UKK0P0002EJfUkjF]YNnP00KcQ[5flh001c>6lGLcQ_5g<h001c=flGLcM_5W<g001c=flF
LcM_5P00KaH007<EMcH007LfLaEg=W<EMcH0001ROol20002Ool007Uoo`80041oo`03001oogoo029o
o`8000030=L002hK00H^6`04001F^UKJE[X200004UkjF]YNnUkJG_YJfP00KaQ_>000KcM_5flhKaM_
=`00LcM_5`=c=`0AKaL007<gLcMc5W<g001c=g<F001c=P00LaEg=W<fMcH0001SOol20002Ool007]o
o`03001oogoo03eoo`03001oogoo029oo`<000030=L0000000800005<Q/^6c8K001Jf`02000085[J
G_YJfUkjF]YNnU[JG_YJfP00JaL006lGLcQ_5g<hKaL006lGLcM_5W<gKaL006lFLcM_5W<g001c=g<F
LcL200001W<EMcIc5GLfLaD006=oo`80009oo`00O7oo00<007ooOol0?7oo00<007ooOol08goo0`00
00@0e`00=S`f?0D0000DG_YNfUkjF]YNnUkJG_YJfUkjG]YNnU[J001_5flhKaM_=flG001_5`=c=`05
KaL007<gLcMc5P02LcL02`00LaIc=W<fLcL007LfLcIg=W<E0000H7oo100017oo001mOol00`00Oomo
o`0kOol00`00Oomoo`0TOol30000<@3G000b>cIL<S/fG38k=U`005kjF]YNnU[JG_YJfUkjF]YNnU[J
001Nn@00KaMc>6lG001_5g<gKaIc=flGLcL007<gKaIc=flF001c5W<gKaIc=`00LcL007LfLaEg=P00
05aoo`@000Qoo`00OWoo0P00>goo00<007ooOol097oo0P0000@0m`000000008f?00<=S/f?3Hl=S`0
05kjG]YNnU[JG_YNfUkj0P0000=RnV<JH_X00P0000=_>000LcL00W<g00E_5g<g001c=g<F00=c=`08
001c=W<fLcMc5P00LaIc=P<005Uoo`@000aoo`00P7oo00<007ooOol0>7oo00<007ooOol09Goo0P00
0300m`3h000fG38k=U`b>cIL<S/fG000G_YJfUkjF]YNnP00HaYNnF<JH_US6UkiHaX007<gKaIc=flG
LcL007<gKaIc=flFLcL007<gKaIc=g<F001c5W<gLaIc=g<F001EOol4000@Ool0085oo`03001oogoo
03Moo`03001oogoo02Ioo`050000m`3g0?P00003=S`02CHk=S`f?000F]YNnUkJG_X00002H_X02V<J
H_YRnV;jHaX006LI001c=flG0W<g00<007<FLcL00W<g00`007<fLcIc=g<FLcH007<fLaIc=W<F001B
Ool4000DOol0089oo`03001oogoo03Ioo`03001oogoo02Ioo`8000030?P0m`3h00@00005<S/fG38k
001JfP02000086<JG_US6V;iHaYNnF<J001W6V;iIaX007<gKaH006lFLcM_5W<gKaH006lFLcMc5W<g
001c=g<FLcMc5W<g001>Ool4000HOol008=oo`8003Ioo`03001oogoo02Moo`800080m`040?P003il
>W`50003H_X01V<JH_YRnV;jHaX000EW6@03001c=`0000=c=`05LaH007<fLcMc5P02LcH01P00LaIc
=W<FLcH004]oo`@001aoo`00QGoo00<007ooOol0<goo00<007ooOol0:7oo0`0002X0m`00>U`nO3YL
?W`jG3il>U`005kiHaYRnF<JG_US6P00IaYRnFLJIaUW6V;iIaX007<gKaIc=flFLcL007<gLaIc=flF
001c5W<gLaIc=g<F0018Ool3000POol008Ioo`03001oogoo039oo`03001oogoo02Uoo`0=0000n000
0?L003Yl?W`jO3il>W`nO3Yl00000f;j00=S6P00IaT01VLI00T006/I001c=g<FLcL007<gLaH00W<f
00Mc=`00LcIc5W<fLaH00015Ool4000SOol008Moo`03001oogoo035oo`03001oogoo02Uoo`80000J
0?L0003g000jG3il>U`nO3YL?W`006<JG_US6P00IaYRnFLJIaUW6V;iIaX006/IIaQ[>@80000=KaH0
07<FLcM_5W<g001c=g<FLcMc5W<g0000@Goo10009goo0028Ool2000aOol00`00Oomoo`0ZOol20000
3@3h000003il>W`nO3Yl?W`jO3il001S6P0000MW6@09001[6FLIJaUW6F/IIaT007<F009c=P08LcMc
5P00LaIc=W<FLcH003ioo`@002]oo`00RWoo00<007ooOol0;Woo00<007ooOol0:goo0P0000<0m`4H
0000200001]W6V;iIaYW6FLJH_UW6P00JaUW66/iIaU[6FLH001[6000KaIc=g<F001c5W<gLaIc=g<F
0000>Woo1000;goo002;Ool00`00Oomoo`0]Ool00`00Oomoo`0/Ool300000`4H0012W006@Y`00`00
IaUW6@03IaT02@00JaUW6F/IIaU[6FLI001[6002JaT02@00LaIc=P00LcIc5W<fLaH0000gOol4000c
Ool008aoo`03001oogoo02aoo`03001oogoo02eoo`0M0001>@000AP004:M@Ya6_D:L@Ye2W4Jm001W
6V;iIaX006/IIaQ[>FLIJaUW6000JaQ[>F/HJcU[600200001W<gLaIc=g<FLcL003=oo`@003Moo`00
SGoo0P00;7oo00<007ooOol0;Goo0P0000<1>@00000024:L00/006LI001[6FLIJaUW6F/IIaT006/H
00=[6@09JaQ[6F/I001c5W<fLaIc=P00031oo`@003]oo`00Sgoo00<007ooOol0:7oo00<007ooOol0
;goo00<0004H0CT00P0000E2W4:M@Ya6_D:L00@0000EJaUW66/iIaU[6FLHJcT006/iJaQ[>F/HJcU[
6000JaP007<FLcMc5P0002aoo`@003moo`00T7oo00<007ooOol09goo00<007ooOol0<7oo00@0004H
0CT160D0000;B[a:_DJlB[`006/IIaU[6FLIJaT00003JaT016/HJaU[6@000f/H0`00:Woo0`00@goo
002AOol00`00Oomoo`0VOol00`00Oomoo`0aOol200007P4i0AP004JlB]e6_4[MA[a:gDJlB]d006/I
IaQ[>@00JcU[66/iJaQ[>F/H001[66liJaQ_>F/HKcT002Ioo`@004Ioo`00TWoo0P009Woo00<007oo
Ool0<Woo0P0000H1>@4H001:_4ZmA[`2B[`01TZmA[a:_000JaT000=[6@04JaQ[6F/I0003JaP016/h
JaQ[60008goo1000BWoo002DOol00`00Oomoo`0SOol00`00Oomoo`0bOol00`000ET00002000024[M
A[a:gDJlB]e6_4[MA[`200003V/iJaQ[>F/HJcU[66/i001_>F/HKcU[66li000POol4001>Ool009Eo
o`03001oogoo029oo`03001oogoo03=oo`030001F@4i0080009:_003B[d000000080009>g003001[
6F/H00=[6@04001[66/HJcP3JaP00`00Oomoo`0JOol4001BOol009Ioo`03001oogoo025oo`03001o
ogoo03Aoo`040001F@4i0ET300004dkMB]a>gDkLC]e:g4kM001[>F/HJcT006liJaQ_>F/HKcU[6000
01Uoo`@005Ioo`00Ugoo0P008Goo00<007ooOol0=Goo0P0000<1>@5I00002DkL00<006/I00000V/H
00E[>6/HJaQ[600001Ioo`@005Yoo`00VGoo00<007ooOol07Woo00<007ooOol0=Woo0P0000/1>@5I
001>gDkLC]e:g4kMC]a>gD[L00800007KcU[66liJaQ_>F/H00004goo1000GWoo002JOol00`00Oomo
o`0MOol00`00Oomoo`0gOol40006C]`2000015;LD_`006/h0f/H00<007ooOol03goo0`00HWoo002K
Ool00`00Oomoo`0LOol00`00Oomoo`0hOol01P000GX00000B]a>g@<0000:D_eBg5;lD]aBo@00KcU[
66li000=Ool4001UOol009aoo`8001aoo`03001oogoo03Uoo`8000030GX0000000=Bo009D]aBo5;l
D_aBg5;l001[>00000Yoo`@006Uoo`00WWoo00<007ooOol06Goo00<007ooOol0>goo00`0005I001B
g5;mD]aBo5;LD_eBg5;lD]`20007Ool4001]Ool009moo`03001oogoo01Qoo`03001oogoo03aoo`<0
0006D]aBo5;lD_aBg5;l0P001Goo1000LGoo002POol00`00Oomoo`0GOol00`00Oomoo`0nOol20000
0e;LD_d000020003Ool4001eOol00:5oo`8001Moo`03001oogoo041oo`80009oo`@007Uoo`00Xgoo
00<007ooOol057oo00<007ooOol0@7oo1000OGoo002TOol00`00Oomoo`0COol00`00Oomoo`0mOol3
0021Ool00:Eoo`03001oogoo019oo`03001oogoo03Uoo`@008Aoo`00YWoo00<007ooOol04Goo00<0
07ooOol0=Goo1000R7oo002WOol2000AOol00`00Oomoo`0aOol4002<Ool00:Uoo`03001oogoo00io
o`03001oogoo02eoo`@0091oo`00ZWoo00<007ooOol03Goo00<007ooOol0:Goo1000U7oo002[Ool0
0`00Oomoo`0;Ool00`00Oomoo`0VOol4002HOol00:aoo`8000]oo`03001oogoo029oo`@009aoo`00
[Woo00<007ooOol027oo00<007ooOol07Woo1000X7oo002_Ool00`00Oomoo`07Ool00`00Oomoo`0K
Ool3002TOol00;1oo`03001oogoo00Ioo`03001oogoo01Moo`@00:Moo`00/Goo0P001Woo00<007oo
Ool04goo1000Zgoo002cOol00`00Oomoo`03Ool00`00Oomoo`0?Ool4002_Ool00;Aoo`03001oogoo
009oo`03001oogoo00]oo`@00;=oo`00]Goo00D007ooOomoo`0000Uoo`@00;Moo`00]Woo0P0000=o
o`00Ool017oo1000^goo002hOol200000goo00000002002oOol00;Uoo`800<=oo`00ogooOgoo003o
OomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmo
o`00ogooOgoo0000\
\>"],
  ImageRangeCache->{{{26.75, 381.5}, {290.875, 0}} -> {-0.170221, 0.00730374, \
0.00369513, 0.00369513}}]
}, Open  ]],

Cell[TextData[{
  "A quite different solution of the FP equation follows if we set ",
  StyleBox["k5",
    FontSlant->"Italic"],
  " = ",
  StyleBox["k6",
    FontSlant->"Italic"],
  " = 1",
  ". The rest of the group parameters are set to zero. The similarity \
variable for this subgroup is a combination of the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and the time \[Tau]. The infinitesimals are"
}], "Text",
  CellTags->"solution of the FP equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 0, 
          k5 \[Rule] 1, k6 \[Rule] 1, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{1\/2\ E\^\(2\ \[Tau]\)\ v, 1 + E\^\(2\ \[Tau]\)\/2}, {
        \(-\(1\/2\)\)\ E\^\(2\ \[Tau]\)\ P\ v\^2}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The similarity reduction of the original equations displays that the \
similarity solution for ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " is given by a function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)]],
  " which now has to satisfy a second-order equation:"
}], "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red3 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red3]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\@\(2 + E\^\(2\ \[Tau]\)\)\/v\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(E\^\(v\^2\/2\)\ P - F\_1 == 0\)},
          {
            \(\(-\[Zeta]\_1\)\ 
                \((2\ F1\_\(\[Zeta]\_1\) + 
                    2\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1\%2 + 
                    \[Zeta]\_1\%3\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The second-order ODE is identified by ",
  StyleBox["DSolve[]", "MmaText"],
  " as"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solr3\  = 
      DSolve[red3\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]
        \)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((C[2] - 1\/2\ \@\[Pi]\ C[1]\ Erfi[1\/#1]&)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The result contains the special function ",
  StyleBox["Erfi[] ", "MmaText"],
  "which gives the imaginary error function erfi(z). In original variables, \
the result reads"
}], "Text",
  CellTags->"Erfi[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol3 = 
      Solve[red3\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr3, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] 
          1\/2\ E\^\(-\(v\^2\/2\)\)\ 
            \((2\ C[2] - \@\[Pi]\ C[1]\ Erfi[v\/\@\(2 + E\^\(2\ \[Tau]\)\)])
              \)}}\)], "Output"]
}, Open  ]],

Cell["\<\
The plot of this function demonstrates that the probability density \
is localized along a fixed axis parallel to the time axis. However, there are \
small variations in the velocity direction.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      \(P /. sol3\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          C[1] \[Rule] 1, C[2] \[Rule] 1/2}, {v, \(-3\), 5}, {\[Tau], \(-2\), 
        2}, AxesLabel \[Rule] {"\<v\>", "\<\[Tau]\>", "\<P\>"}, 
      PlotPoints \[Rule] 25]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.66533e-16 1.04977 -0.0679587 1.04977 [
[.10092 .21731 -12 -8.91782 ]
[.10092 .21731 0 .08218 ]
[.25429 .15697 -5.74307 -9 ]
[.25429 .15697 .25693 0 ]
[.41721 .09289 -5.43033 -9 ]
[.41721 .09289 .56967 0 ]
[.59061 .02474 -5.11759 -9 ]
[.59061 .02474 .88241 0 ]
[.29165 .07573 -10.2423 -15 ]
[.29165 .07573 .75771 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.01328 .333 -6 -2.79975 ]
[.01328 .333 0 6.20025 ]
[-0.00165 .42658 -18 -2.87931 ]
[-0.00165 .42658 0 6.12069 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.02556 .32837 m
.03169 .32605 L
s
[(0)] .01328 .333 1 -0.37783 Mshowa
.0107 .42213 m
.01687 .41991 L
s
[(0.5)] -0.00165 .42658 1 -0.36015 Mshowa
.125 Mabswid
.02265 .34668 m
.02634 .3453 L
s
.01972 .36521 m
.02341 .36385 L
s
.01674 .38396 m
.02044 .38261 L
s
.01374 .40293 m
.01744 .40159 L
s
.02842 .31026 m
.0321 .30886 L
s
.03126 .29236 m
.03494 .29095 L
s
.03407 .27466 m
.03774 .27324 L
s
.03684 .25717 m
.0405 .25573 L
s
.00762 .44156 m
.01133 .44024 L
s
.0045 .46122 m
.00821 .45991 L
s
.00135 .48112 m
.00507 .47982 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(P) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.605 .736 .937 r
.38987 .65604 .40289 .66751 .4246 .66367 .41167 .65229 Metetra
.538 .716 .955 r
.41167 .65229 .4246 .66367 .44646 .6622 .43362 .65107 Metetra
.403 .665 .966 r
.43362 .65107 .44646 .6622 .4685 .66433 .45574 .65363 Metetra
.175 .552 .93 r
.45574 .65363 .4685 .66433 .49079 .67087 .4781 .66071 Metetra
0 .402 .83 r
.4781 .66071 .49079 .67087 .51342 .68129 .50079 .67163 Metetra
0 .351 .784 r
.50079 .67163 .51342 .68129 .53646 .69309 .52391 .68365 Metetra
.051 .499 .89 r
.52391 .68365 .53646 .69309 .55991 .70194 .54746 .69216 Metetra
.454 .723 .983 r
.54746 .69216 .55991 .70194 .58364 .70316 .5713 .69241 Metetra
.713 .794 .915 r
.5713 .69241 .58364 .70316 .60744 .69401 .59522 .68185 Metetra
.804 .786 .836 r
.59522 .68185 .60744 .69401 .63111 .67521 .61903 .6616 Metetra
.829 .771 .798 r
.61903 .6616 .63111 .67521 .6546 .65061 .64269 .63592 Metetra
.825 .761 .791 r
.64269 .63592 .6546 .65061 .67802 .62514 .66627 .60996 Metetra
.804 .755 .807 r
.66627 .60996 .67802 .62514 .70153 .60263 .68996 .58749 Metetra
.771 .75 .834 r
.68996 .58749 .70153 .60263 .72529 .58474 .71392 .56997 Metetra
.732 .747 .863 r
.71392 .56997 .72529 .58474 .74941 .57123 .73823 .55689 Metetra
.698 .744 .887 r
.73823 .55689 .74941 .57123 .77387 .56085 .76287 .54688 Metetra
.675 .743 .902 r
.76287 .54688 .77387 .56085 .79865 .55228 .78783 .53852 Metetra
.664 .744 .91 r
.78783 .53852 .79865 .55228 .82371 .54456 .81306 .53086 Metetra
.66 .745 .914 r
.81306 .53086 .82371 .54456 .84901 .53712 .83853 .5234 Metetra
.659 .747 .915 r
.83853 .5234 .84901 .53712 .87454 .52972 .86423 .51593 Metetra
.659 .747 .915 r
.86423 .51593 .87454 .52972 .9003 .52229 .89015 .50839 Metetra
.659 .747 .916 r
.89015 .50839 .9003 .52229 .92629 .5148 .91631 .50077 Metetra
.659 .748 .916 r
.91631 .50077 .92629 .5148 .95251 .50723 .9427 .49308 Metetra
.659 .748 .916 r
.9427 .49308 .95251 .50723 .97896 .4996 .96933 .48532 Metetra
.6 .735 .939 r
.37664 .64443 .38987 .65604 .41167 .65229 .39854 .64082 Metetra
.526 .713 .958 r
.39854 .64082 .41167 .65229 .43362 .65107 .42057 .63991 Metetra
.376 .655 .966 r
.42057 .63991 .43362 .65107 .45574 .65363 .44276 .64297 Metetra
.128 .527 .916 r
.44276 .64297 .45574 .65363 .4781 .66071 .46519 .65069 Metetra
0 .369 .801 r
.46519 .65069 .4781 .66071 .50079 .67163 .48795 .6622 Metetra
0 .331 .761 r
.48795 .6622 .50079 .67163 .52391 .68365 .51115 .67445 Metetra
.051 .507 .89 r
.51115 .67445 .52391 .68365 .54746 .69216 .53479 .68256 Metetra
.484 .743 .985 r
.53479 .68256 .54746 .69216 .5713 .69241 .55874 .68169 Metetra
.734 .801 .905 r
.55874 .68169 .5713 .69241 .59522 .68185 .5828 .66949 Metetra
.814 .786 .827 r
.5828 .66949 .59522 .68185 .61903 .6616 .60677 .64758 Metetra
.832 .769 .791 r
.60677 .64758 .61903 .6616 .64269 .63592 .63058 .62067 Metetra
.825 .757 .788 r
.63058 .62067 .64269 .63592 .66627 .60996 .65434 .59415 Metetra
.801 .75 .805 r
.65434 .59415 .66627 .60996 .68996 .58749 .67822 .57175 Metetra
.765 .744 .834 r
.67822 .57175 .68996 .58749 .71392 .56997 .70236 .55466 Metetra
.724 .74 .864 r
.70236 .55466 .71392 .56997 .73823 .55689 .72686 .54212 Metetra
.69 .738 .888 r
.72686 .54212 .73823 .55689 .76287 .54688 .75169 .53254 Metetra
.669 .739 .902 r
.75169 .53254 .76287 .54688 .78783 .53852 .77683 .52445 Metetra
.66 .742 .91 r
.77683 .52445 .78783 .53852 .81306 .53086 .80223 .5169 Metetra
.658 .744 .914 r
.80223 .5169 .81306 .53086 .83853 .5234 .82787 .50944 Metetra
.658 .746 .915 r
.82787 .50944 .83853 .5234 .86423 .51593 .85374 .50189 Metetra
.658 .747 .915 r
.85374 .50189 .86423 .51593 .89015 .50839 .87983 .49425 Metetra
.659 .747 .916 r
.87983 .49425 .89015 .50839 .91631 .50077 .90616 .48652 Metetra
.659 .748 .916 r
.90616 .48652 .91631 .50077 .9427 .49308 .93273 .4787 Metetra
.659 .748 .916 r
.93273 .4787 .9427 .49308 .96933 .48532 .95954 .47081 Metetra
.593 .734 .942 r
.36321 .63268 .37664 .64443 .39854 .64082 .3852 .62926 Metetra
.511 .709 .961 r
.3852 .62926 .39854 .64082 .42057 .63991 .40731 .62874 Metetra
.343 .642 .964 r
.40731 .62874 .42057 .63991 .44276 .64297 .42957 .6324 Metetra
.071 .496 .896 r
.42957 .6324 .44276 .64297 .46519 .65069 .45205 .64086 Metetra
0 .33 .764 r
.45205 .64086 .46519 .65069 .48795 .6622 .47488 .65304 Metetra
0 .307 .733 r
.47488 .65304 .48795 .6622 .51115 .67445 .49815 .66554 Metetra
.054 .517 .892 r
.49815 .66554 .51115 .67445 .53479 .68256 .52189 .67317 Metetra
.518 .764 .986 r
.52189 .67317 .53479 .68256 .55874 .68169 .54598 .671 Metetra
.755 .807 .894 r
.54598 .671 .55874 .68169 .5828 .66949 .57019 .65694 Metetra
.824 .786 .817 r
.57019 .65694 .5828 .66949 .60677 .64758 .59431 .63313 Metetra
.837 .767 .785 r
.59431 .63313 .60677 .64758 .63058 .62067 .61829 .60483 Metetra
.825 .753 .784 r
.61829 .60483 .63058 .62067 .65434 .59415 .64222 .57767 Metetra
.797 .744 .804 r
.64222 .57767 .65434 .59415 .67822 .57175 .66628 .55533 Metetra
.757 .737 .834 r
.66628 .55533 .67822 .57175 .70236 .55466 .69061 .53875 Metetra
.715 .733 .865 r
.69061 .53875 .70236 .55466 .72686 .54212 .7153 .52685 Metetra
.681 .731 .888 r
.7153 .52685 .72686 .54212 .75169 .53254 .74032 .5178 Metetra
.662 .734 .903 r
.74032 .5178 .75169 .53254 .77683 .52445 .76565 .51006 Metetra
.656 .738 .91 r
.76565 .51006 .77683 .52445 .80223 .5169 .79123 .50267 Metetra
.656 .743 .914 r
.79123 .50267 .80223 .5169 .82787 .50944 .81704 .49522 Metetra
.657 .745 .915 r
.81704 .49522 .82787 .50944 .85374 .50189 .84308 .48762 Metetra
.658 .747 .916 r
.84308 .48762 .85374 .50189 .87983 .49425 .86934 .47987 Metetra
.658 .747 .916 r
.86934 .47987 .87983 .49425 .90616 .48652 .89585 .47202 Metetra
.659 .748 .916 r
.89585 .47202 .90616 .48652 .93273 .4787 .92259 .46408 Metetra
.659 .748 .916 r
.92259 .46408 .93273 .4787 .95954 .47081 .94958 .45605 Metetra
.585 .732 .945 r
.34957 .62083 .36321 .63268 .3852 .62926 .37164 .61765 Metetra
.491 .704 .964 r
.37164 .61765 .3852 .62926 .40731 .62874 .39383 .6176 Metetra
.301 .624 .96 r
.39383 .6176 .40731 .62874 .42957 .6324 .41615 .62197 Metetra
.004 .456 .867 r
.41615 .62197 .42957 .6324 .45205 .64086 .43869 .63129 Metetra
0 .285 .718 r
.43869 .63129 .45205 .64086 .47488 .65304 .46157 .64421 Metetra
0 .282 .701 r
.46157 .64421 .47488 .65304 .49815 .66554 .48491 .65696 Metetra
.06 .53 .894 r
.48491 .65696 .49815 .66554 .52189 .67317 .50876 .66402 Metetra
.555 .786 .985 r
.50876 .66402 .52189 .67317 .54598 .671 .53299 .66035 Metetra
.776 .812 .882 r
.53299 .66035 .54598 .671 .57019 .65694 .55736 .64418 Metetra
.834 .786 .806 r
.55736 .64418 .57019 .65694 .59431 .63313 .58166 .61824 Metetra
.841 .764 .777 r
.58166 .61824 .59431 .63313 .61829 .60483 .60581 .58835 Metetra
.826 .749 .78 r
.60581 .58835 .61829 .60483 .64222 .57767 .62991 .56047 Metetra
.793 .739 .802 r
.62991 .56047 .64222 .57767 .66628 .55533 .65415 .5382 Metetra
.749 .73 .834 r
.65415 .5382 .66628 .55533 .69061 .53875 .67867 .52219 Metetra
.704 .724 .865 r
.67867 .52219 .69061 .53875 .7153 .52685 .70355 .51102 Metetra
.671 .723 .889 r
.70355 .51102 .7153 .52685 .74032 .5178 .72876 .50262 Metetra
.654 .728 .903 r
.72876 .50262 .74032 .5178 .76565 .51006 .75427 .49531 Metetra
.651 .735 .911 r
.75427 .49531 .76565 .51006 .79123 .50267 .78003 .48813 Metetra
.653 .74 .914 r
.78003 .48813 .79123 .50267 .81704 .49522 .80602 .48074 Metetra
.656 .744 .915 r
.80602 .48074 .81704 .49522 .84308 .48762 .83223 .47309 Metetra
.657 .746 .916 r
.83223 .47309 .84308 .48762 .86934 .47987 .85868 .46525 Metetra
.658 .747 .916 r
.85868 .46525 .86934 .47987 .89585 .47202 .88536 .45728 Metetra
.659 .747 .916 r
.88536 .45728 .89585 .47202 .92259 .46408 .91228 .4492 Metetra
.659 .748 .916 r
.91228 .4492 .92259 .46408 .94958 .45605 .93945 .44104 Metetra
.574 .73 .948 r
.33571 .60888 .34957 .62083 .37164 .61765 .35786 .60603 Metetra
.466 .697 .968 r
.35786 .60603 .37164 .61765 .39383 .6176 .38012 .60655 Metetra
.248 .6 .952 r
.38012 .60655 .39383 .6176 .41615 .62197 .40249 .61175 Metetra
0 .407 .826 r
.40249 .61175 .41615 .62197 .43869 .63129 .42507 .62203 Metetra
0 .234 .663 r
.42507 .62203 .43869 .63129 .46157 .64421 .448 .63575 Metetra
0 .255 .667 r
.448 .63575 .46157 .64421 .48491 .65696 .47142 .64874 Metetra
.073 .548 .899 r
.47142 .64874 .48491 .65696 .50876 .66402 .49539 .6551 Metetra
.595 .807 .981 r
.49539 .6551 .50876 .66402 .53299 .66035 .51978 .64973 Metetra
.797 .816 .867 r
.51978 .64973 .53299 .66035 .55736 .64418 .54433 .63121 Metetra
.844 .785 .795 r
.54433 .63121 .55736 .64418 .58166 .61824 .56881 .60289 Metetra
.846 .762 .769 r
.56881 .60289 .58166 .61824 .60581 .58835 .59314 .57124 Metetra
.826 .746 .775 r
.59314 .57124 .60581 .58835 .62991 .56047 .61742 .54252 Metetra
.79 .733 .8 r
.61742 .54252 .62991 .56047 .65415 .5382 .64183 .52029 Metetra
.741 .722 .834 r
.64183 .52029 .65415 .5382 .67867 .52219 .66653 .5049 Metetra
.692 .714 .866 r
.66653 .5049 .67867 .52219 .70355 .51102 .69159 .49456 Metetra
.658 .713 .889 r
.69159 .49456 .70355 .51102 .72876 .50262 .717 .48692 Metetra
.644 .72 .903 r
.717 .48692 .72876 .50262 .75427 .49531 .7427 .48014 Metetra
.644 .729 .911 r
.7427 .48014 .75427 .49531 .78003 .48813 .76865 .47326 Metetra
.649 .738 .914 r
.76865 .47326 .78003 .48813 .80602 .48074 .79482 .46597 Metetra
.654 .743 .915 r
.79482 .46597 .80602 .48074 .83223 .47309 .82121 .4583 Metetra
.657 .746 .915 r
.82121 .4583 .83223 .47309 .85868 .46525 .84783 .45037 Metetra
.658 .747 .916 r
.84783 .45037 .85868 .46525 .88536 .45728 .87468 .44228 Metetra
.659 .747 .916 r
.87468 .44228 .88536 .45728 .91228 .4492 .90179 .43407 Metetra
.659 .748 .916 r
.90179 .43407 .91228 .4492 .93945 .44104 .92914 .42578 Metetra
.56 .728 .953 r
.32162 .59688 .33571 .60888 .35786 .60603 .34385 .59444 Metetra
.434 .687 .971 r
.34385 .59444 .35786 .60603 .38012 .60655 .36616 .59565 Metetra
.181 .568 .936 r
.36616 .59565 .38012 .60655 .40249 .61175 .38857 .60181 Metetra
0 .348 .772 r
.38857 .60181 .40249 .61175 .42507 .62203 .41118 .61314 Metetra
0 .181 .602 r
.41118 .61314 .42507 .62203 .448 .63575 .43416 .6277 Metetra
0 .231 .632 r
.43416 .6277 .448 .63575 .47142 .64874 .45767 .64087 Metetra
.095 .572 .907 r
.45767 .64087 .47142 .64874 .49539 .6551 .48176 .6464 Metetra
.637 .826 .973 r
.48176 .6464 .49539 .6551 .51978 .64973 .50632 .63913 Metetra
.816 .819 .852 r
.50632 .63913 .51978 .64973 .54433 .63121 .53108 .61802 Metetra
.854 .784 .783 r
.53108 .61802 .54433 .63121 .56881 .60289 .55576 .58711 Metetra
.851 .76 .761 r
.55576 .58711 .56881 .60289 .59314 .57124 .58029 .55351 Metetra
.828 .743 .77 r
.58029 .55351 .59314 .57124 .61742 .54252 .60474 .52382 Metetra
.786 .727 .798 r
.60474 .52382 .61742 .54252 .64183 .52029 .62932 .50158 Metetra
.732 .713 .833 r
.62932 .50158 .64183 .52029 .66653 .5049 .65419 .48683 Metetra
.678 .703 .865 r
.65419 .48683 .66653 .5049 .69159 .49456 .67944 .4774 Metetra
.644 .702 .889 r
.67944 .4774 .69159 .49456 .717 .48692 .70504 .47062 Metetra
.633 .711 .903 r
.70504 .47062 .717 .48692 .7427 .48014 .73093 .46449 Metetra
.637 .723 .91 r
.73093 .46449 .7427 .48014 .76865 .47326 .75706 .45799 Metetra
.645 .734 .914 r
.75706 .45799 .76865 .47326 .79482 .46597 .78342 .45087 Metetra
.652 .741 .915 r
.78342 .45087 .79482 .46597 .82121 .4583 .80999 .44322 Metetra
.656 .745 .915 r
.80999 .44322 .82121 .4583 .84783 .45037 .83679 .43522 Metetra
.658 .746 .916 r
.83679 .43522 .84783 .45037 .87468 .44228 .86383 .42702 Metetra
.658 .747 .916 r
.86383 .42702 .87468 .44228 .90179 .43407 .89112 .41868 Metetra
.659 .748 .916 r
.89112 .41868 .90179 .43407 .92914 .42578 .91866 .41024 Metetra
.541 .725 .959 r
.30729 .58489 .32162 .59688 .34385 .59444 .32959 .58298 Metetra
.392 .673 .972 r
.32959 .58298 .34385 .59444 .36616 .59565 .35194 .58501 Metetra
.1 .526 .91 r
.35194 .58501 .36616 .59565 .38857 .60181 .37438 .59223 Metetra
0 .282 .706 r
.37438 .59223 .38857 .60181 .41118 .61314 .39702 .60468 Metetra
.435 0 0 r
.39702 .60468 .41118 .61314 .43416 .6277 .42004 .62006 Metetra
.359 0 0 r
.42004 .62006 .43416 .6277 .45767 .64087 .44363 .63331 Metetra
.128 .602 .919 r
.44363 .63331 .45767 .64087 .48176 .6464 .46787 .63785 Metetra
.677 .841 .962 r
.46787 .63785 .48176 .6464 .50632 .63913 .49263 .62849 Metetra
.833 .819 .836 r
.49263 .62849 .50632 .63913 .53108 .61802 .5176 .60461 Metetra
.863 .783 .771 r
.5176 .60461 .53108 .61802 .55576 .58711 .54252 .57094 Metetra
.857 .758 .753 r
.54252 .57094 .55576 .58711 .58029 .55351 .56725 .53523 Metetra
.83 .74 .765 r
.56725 .53523 .58029 .55351 .60474 .52382 .59188 .50443 Metetra
.784 .723 .795 r
.59188 .50443 .60474 .52382 .62932 .50158 .61662 .48207 Metetra
.723 .705 .832 r
.61662 .48207 .62932 .50158 .65419 .48683 .64166 .46792 Metetra
.664 .691 .865 r
.64166 .46792 .65419 .48683 .67944 .4774 .66708 .45944 Metetra
.628 .689 .888 r
.66708 .45944 .67944 .4774 .70504 .47062 .69286 .45363 Metetra
.619 .699 .902 r
.69286 .45363 .70504 .47062 .73093 .46449 .71894 .44826 Metetra
.627 .715 .909 r
.71894 .44826 .73093 .46449 .75706 .45799 .74527 .44226 Metetra
.639 .728 .913 r
.74527 .44226 .75706 .45799 .78342 .45087 .77182 .43539 Metetra
.648 .738 .915 r
.77182 .43539 .78342 .45087 .80999 .44322 .79858 .42781 Metetra
.654 .743 .915 r
.79858 .42781 .80999 .44322 .83679 .43522 .82556 .41978 Metetra
.657 .746 .915 r
.82556 .41978 .83679 .43522 .86383 .42702 .85279 .41148 Metetra
.658 .747 .916 r
.85279 .41148 .86383 .42702 .89112 .41868 .88026 .40302 Metetra
.659 .747 .916 r
.88026 .40302 .89112 .41868 .91866 .41024 .90799 .39444 Metetra
.515 .72 .966 r
.29271 .573 .30729 .58489 .32959 .58298 .31506 .57174 Metetra
.337 .654 .97 r
.31506 .57174 .32959 .58298 .35194 .58501 .33745 .5747 Metetra
.005 .472 .869 r
.33745 .5747 .35194 .58501 .37438 .59223 .35991 .58307 Metetra
0 .213 .631 r
.35991 .58307 .37438 .59223 .39702 .60468 .38257 .59663 Metetra
.485 0 0 r
.38257 .59663 .39702 .60468 .42004 .62006 .40563 .61275 Metetra
.376 0 0 r
.40563 .61275 .42004 .62006 .44363 .63331 .42931 .62595 Metetra
.176 .638 .936 r
.42931 .62595 .44363 .63331 .46787 .63785 .4537 .62934 Metetra
.715 .851 .947 r
.4537 .62934 .46787 .63785 .49263 .62849 .47867 .61775 Metetra
.848 .818 .819 r
.47867 .61775 .49263 .62849 .5176 .60461 .5039 .59098 Metetra
.871 .781 .759 r
.5039 .59098 .5176 .60461 .54252 .57094 .52907 .55443 Metetra
.862 .757 .745 r
.52907 .55443 .54252 .57094 .56725 .53523 .55402 .51649 Metetra
.833 .739 .76 r
.55402 .51649 .56725 .53523 .59188 .50443 .57884 .48443 Metetra
.783 .72 .793 r
.57884 .48443 .59188 .50443 .61662 .48207 .60374 .46181 Metetra
.715 .697 .832 r
.60374 .46181 .61662 .48207 .64166 .46792 .62893 .44818 Metetra
.65 .679 .864 r
.62893 .44818 .64166 .46792 .66708 .45944 .65451 .44063 Metetra
.611 .674 .886 r
.65451 .44063 .66708 .45944 .69286 .45363 .68047 .43584 Metetra
.604 .686 .9 r
.68047 .43584 .69286 .45363 .71894 .44826 .70674 .43135 Metetra
.616 .704 .908 r
.70674 .43135 .71894 .44826 .74527 .44226 .73327 .42597 Metetra
.632 .721 .912 r
.73327 .42597 .74527 .44226 .77182 .43539 .76001 .41946 Metetra
.644 .733 .914 r
.76001 .41946 .77182 .43539 .79858 .42781 .78696 .41204 Metetra
.652 .741 .915 r
.78696 .41204 .79858 .42781 .82556 .41978 .81413 .40402 Metetra
.656 .745 .915 r
.81413 .40402 .82556 .41978 .85279 .41148 .84155 .39565 Metetra
.658 .746 .915 r
.84155 .39565 .85279 .41148 .88026 .40302 .86921 .38706 Metetra
.658 .747 .916 r
.86921 .38706 .88026 .40302 .90799 .39444 .89714 .37835 Metetra
.481 .714 .973 r
.27786 .56132 .29271 .573 .31506 .57174 .30025 .56084 Metetra
.267 .627 .961 r
.30025 .56084 .31506 .57174 .33745 .5747 .32266 .56483 Metetra
0 .408 .812 r
.32266 .56483 .33745 .5747 .35991 .58307 .34513 .57435 Metetra
.416 0 0 r
.34513 .57435 .35991 .58307 .38257 .59663 .3678 .58897 Metetra
.522 0 0 r
.3678 .58897 .38257 .59663 .40563 .61275 .39091 .60568 Metetra
.377 0 0 r
.39091 .60568 .40563 .61275 .42931 .62595 .41469 .61864 Metetra
.238 .679 .957 r
.41469 .61864 .42931 .62595 .4537 .62934 .43925 .6207 Metetra
.748 .855 .929 r
.43925 .6207 .4537 .62934 .47867 .61775 .46446 .60679 Metetra
.86 .815 .804 r
.46446 .60679 .47867 .61775 .5039 .59098 .48997 .57711 Metetra
.878 .78 .749 r
.48997 .57711 .5039 .59098 .52907 .55443 .51541 .53768 Metetra
.868 .757 .738 r
.51541 .53768 .52907 .55443 .55402 .51649 .5406 .49743 Metetra
.838 .739 .755 r
.5406 .49743 .55402 .51649 .57884 .48443 .56562 .46399 Metetra
.784 .718 .791 r
.56562 .46399 .57884 .48443 .60374 .46181 .59068 .44093 Metetra
.71 .692 .831 r
.59068 .44093 .60374 .46181 .62893 .44818 .61602 .42764 Metetra
.637 .668 .863 r
.61602 .42764 .62893 .44818 .65451 .44063 .64174 .42093 Metetra
.594 .659 .883 r
.64174 .42093 .65451 .44063 .68047 .43584 .66787 .41716 Metetra
.588 .67 .897 r
.66787 .41716 .68047 .43584 .70674 .43135 .69432 .41362 Metetra
.602 .691 .905 r
.69432 .41362 .70674 .43135 .73327 .42597 .72103 .40898 Metetra
.622 .711 .91 r
.72103 .40898 .73327 .42597 .76001 .41946 .74797 .40296 Metetra
.638 .727 .912 r
.74797 .40296 .76001 .41946 .78696 .41204 .77512 .3958 Metetra
.648 .737 .914 r
.77512 .3958 .78696 .41204 .81413 .40402 .8025 .38787 Metetra
.654 .742 .915 r
.8025 .38787 .81413 .40402 .84155 .39565 .83011 .37948 Metetra
.657 .745 .915 r
.83011 .37948 .84155 .39565 .86921 .38706 .85797 .3708 Metetra
.658 .747 .915 r
.85797 .3708 .86921 .38706 .89714 .37835 .88609 .36196 Metetra
.436 .705 .979 r
.26271 .54999 .27786 .56132 .30025 .56084 .28513 .55039 Metetra
.183 .591 .941 r
.28513 .55039 .30025 .56084 .32266 .56483 .30756 .55544 Metetra
0 .34 .744 r
.30756 .55544 .32266 .56483 .34513 .57435 .33004 .56605 Metetra
.474 0 0 r
.33004 .56605 .34513 .57435 .3678 .58897 .35272 .58155 Metetra
.543 0 0 r
.35272 .58155 .3678 .58897 .39091 .60568 .37588 .59863 Metetra
.361 0 0 r
.37588 .59863 .39091 .60568 .41469 .61864 .39977 .61114 Metetra
.311 .721 .977 r
.39977 .61114 .41469 .61864 .43925 .6207 .42451 .61177 Metetra
.774 .854 .91 r
.42451 .61177 .43925 .6207 .46446 .60679 .44998 .59553 Metetra
.869 .811 .789 r
.44998 .59553 .46446 .60679 .48997 .57711 .47579 .563 Metetra
.884 .778 .739 r
.47579 .563 .48997 .57711 .51541 .53768 .50154 .52077 Metetra
.874 .757 .731 r
.50154 .52077 .51541 .53768 .5406 .49743 .527 .47824 Metetra
.843 .741 .751 r
.527 .47824 .5406 .49743 .56562 .46399 .55222 .4433 Metetra
.787 .719 .789 r
.55222 .4433 .56562 .46399 .59068 .44093 .57745 .41962 Metetra
.707 .689 .831 r
.57745 .41962 .59068 .44093 .61602 .42764 .60291 .40644 Metetra
.626 .659 .862 r
.60291 .40644 .61602 .42764 .64174 .42093 .62877 .40038 Metetra
.578 .646 .881 r
.62877 .40038 .64174 .42093 .66787 .41716 .65504 .39753 Metetra
.571 .655 .893 r
.65504 .39753 .66787 .41716 .69432 .41362 .68166 .39496 Metetra
.588 .676 .901 r
.68166 .39496 .69432 .41362 .72103 .40898 .70857 .39115 Metetra
.611 .699 .906 r
.70857 .39115 .72103 .40898 .74797 .40296 .73571 .38575 Metetra
.63 .717 .91 r
.73571 .38575 .74797 .40296 .77512 .3958 .76306 .37898 Metetra
.643 .73 .912 r
.76306 .37898 .77512 .3958 .8025 .38787 .79064 .37125 Metetra
.651 .738 .913 r
.79064 .37125 .8025 .38787 .83011 .37948 .81845 .3629 Metetra
.655 .743 .914 r
.81845 .3629 .83011 .37948 .85797 .3708 .84651 .35419 Metetra
.657 .745 .915 r
.84651 .35419 .85797 .3708 .88609 .36196 .87484 .34525 Metetra
.38 .692 .981 r
.24724 .53914 .26271 .54999 .28513 .55039 .26969 .54045 Metetra
.093 .547 .909 r
.26969 .54045 .28513 .55039 .30756 .55544 .29212 .54649 Metetra
0 .28 .678 r
.29212 .54649 .30756 .55544 .33004 .56605 .31461 .55802 Metetra
.51 0 0 r
.31461 .55802 .33004 .56605 .35272 .58155 .33733 .57415 Metetra
.549 0 0 r
.33733 .57415 .35272 .58155 .37588 .59863 .36054 .59134 Metetra
.325 0 0 r
.36054 .59134 .37588 .59863 .39977 .61114 .38454 .60321 Metetra
.387 .756 .992 r
.38454 .60321 .39977 .61114 .42451 .61177 .40949 .60233 Metetra
.795 .848 .891 r
.40949 .60233 .42451 .61177 .44998 .59553 .43524 .58384 Metetra
.876 .806 .777 r
.43524 .58384 .44998 .59553 .47579 .563 .46137 .54865 Metetra
.889 .776 .731 r
.46137 .54865 .47579 .563 .50154 .52077 .48745 .50379 Metetra
.879 .758 .725 r
.48745 .50379 .50154 .52077 .527 .47824 .5132 .45906 Metetra
.849 .743 .747 r
.5132 .45906 .527 .47824 .55222 .4433 .53865 .42259 Metetra
.791 .723 .788 r
.53865 .42259 .55222 .4433 .57745 .41962 .56404 .3981 Metetra
.707 .69 .832 r
.56404 .3981 .57745 .41962 .60291 .40644 .58963 .38478 Metetra
.619 .654 .862 r
.58963 .38478 .60291 .40644 .62877 .40038 .61561 .37912 Metetra
.565 .635 .879 r
.61561 .37912 .62877 .40038 .65504 .39753 .64201 .377 Metetra
.555 .64 .889 r
.64201 .377 .65504 .39753 .68166 .39496 .66878 .3753 Metetra
.573 .661 .897 r
.66878 .3753 .68166 .39496 .70857 .39115 .69586 .37234 Metetra
.598 .685 .902 r
.69586 .37234 .70857 .39115 .73571 .38575 .7232 .36764 Metetra
.62 .705 .906 r
.7232 .36764 .73571 .38575 .76306 .37898 .75076 .36139 Metetra
.636 .721 .909 r
.75076 .36139 .76306 .37898 .79064 .37125 .77855 .35399 Metetra
.646 .732 .911 r
.77855 .35399 .79064 .37125 .81845 .3629 .80657 .34581 Metetra
.652 .739 .913 r
.80657 .34581 .81845 .3629 .84651 .35419 .83484 .33714 Metetra
.655 .743 .914 r
.83484 .33714 .84651 .35419 .87484 .34525 .86337 .32815 Metetra
.317 .673 .976 r
.23143 .5288 .24724 .53914 .26969 .54045 .2539 .53095 Metetra
.012 .502 .87 r
.2539 .53095 .26969 .54045 .29212 .54649 .27636 .53782 Metetra
0 .236 .628 r
.27636 .53782 .29212 .54649 .31461 .55802 .29887 .55002 Metetra
.526 0 0 r
.29887 .55002 .31461 .55802 .33733 .57415 .32161 .5665 Metetra
.538 0 0 r
.32161 .5665 .33733 .57415 .36054 .59134 .34489 .58355 Metetra
0 .301 .671 r
.34489 .58355 .36054 .59134 .38454 .60321 .36902 .59461 Metetra
.458 .781 .998 r
.36902 .59461 .38454 .60321 .40949 .60233 .39418 .59224 Metetra
.81 .84 .873 r
.39418 .59224 .40949 .60233 .43524 .58384 .42022 .57165 Metetra
.881 .801 .766 r
.42022 .57165 .43524 .58384 .46137 .54865 .4467 .53405 Metetra
.893 .775 .724 r
.4467 .53405 .46137 .54865 .48745 .50379 .47313 .48682 Metetra
.884 .76 .72 r
.47313 .48682 .48745 .50379 .5132 .45906 .49919 .44005 Metetra
.855 .747 .743 r
.49919 .44005 .5132 .45906 .53865 .42259 .52489 .40206 Metetra
.798 .728 .787 r
.52489 .40206 .53865 .42259 .56404 .3981 .55045 .37663 Metetra
.71 .694 .833 r
.55045 .37663 .56404 .3981 .58963 .38478 .57618 .36293 Metetra
.615 .653 .864 r
.57618 .36293 .58963 .38478 .61561 .37912 .60226 .35737 Metetra
.555 .628 .879 r
.60226 .35737 .61561 .37912 .64201 .377 .62877 .35572 Metetra
.542 .628 .887 r
.62877 .35572 .64201 .377 .66878 .3753 .65568 .3547 Metetra
.56 .646 .892 r
.65568 .3547 .66878 .3753 .69586 .37234 .68292 .3525 Metetra
.586 .67 .897 r
.68292 .3525 .69586 .37234 .7232 .36764 .71044 .34852 Metetra
.61 .691 .901 r
.71044 .34852 .7232 .36764 .75076 .36139 .7382 .34287 Metetra
.628 .709 .905 r
.7382 .34287 .75076 .36139 .77855 .35399 .7662 .33591 Metetra
.64 .722 .908 r
.7662 .33591 .77855 .35399 .80657 .34581 .79444 .32803 Metetra
.648 .731 .91 r
.79444 .32803 .80657 .34581 .83484 .33714 .82293 .31951 Metetra
.652 .738 .912 r
.82293 .31951 .83484 .33714 .86337 .32815 .85168 .31056 Metetra
.259 .653 .965 r
.21527 .51889 .23143 .5288 .2539 .53095 .23777 .52171 Metetra
0 .467 .837 r
.23777 .52171 .2539 .53095 .27636 .53782 .26026 .52916 Metetra
.357 0 0 r
.26026 .52916 .27636 .53782 .29887 .55002 .2828 .54174 Metetra
.522 0 0 r
.2828 .54174 .29887 .55002 .32161 .5665 .30559 .5583 Metetra
.513 0 0 r
.30559 .5583 .32161 .5665 .34489 .58355 .32894 .57498 Metetra
0 .358 .734 r
.32894 .57498 .34489 .58355 .36902 .59461 .35321 .58517 Metetra
.518 .794 .996 r
.35321 .58517 .36902 .59461 .39418 .59224 .37859 .58137 Metetra
.82 .831 .858 r
.37859 .58137 .39418 .59224 .42022 .57165 .40493 .5589 Metetra
.884 .796 .758 r
.40493 .5589 .42022 .57165 .4467 .53405 .43177 .51919 Metetra
.896 .774 .718 r
.43177 .51919 .4467 .53405 .47313 .48682 .45857 .46988 Metetra
.889 .761 .715 r
.45857 .46988 .47313 .48682 .49919 .44005 .48497 .42128 Metetra
.861 .751 .74 r
.48497 .42128 .49919 .44005 .52489 .40206 .51093 .38185 Metetra
.805 .735 .786 r
.51093 .38185 .52489 .40206 .55045 .37663 .53669 .35542 Metetra
.716 .702 .836 r
.53669 .35542 .55045 .37663 .57618 .36293 .56254 .34116 Metetra
.615 .657 .868 r
.56254 .34116 .57618 .36293 .60226 .35737 .58873 .33544 Metetra
.549 .626 .881 r
.58873 .33544 .60226 .35737 .62877 .35572 .61534 .33396 Metetra
.533 .622 .886 r
.61534 .33396 .62877 .35572 .65568 .3547 .64236 .33336 Metetra
.549 .636 .89 r
.64236 .33336 .65568 .3547 .68292 .3525 .66974 .33172 Metetra
.575 .657 .893 r
.66974 .33172 .68292 .3525 .71044 .34852 .69743 .32836 Metetra
.599 .678 .896 r
.69743 .32836 .71044 .34852 .7382 .34287 .72539 .32329 Metetra
.618 .696 .899 r
.72539 .32329 .7382 .34287 .7662 .33591 .75359 .31684 Metetra
.632 .71 .903 r
.75359 .31684 .7662 .33591 .79444 .32803 .78205 .30934 Metetra
.641 .721 .906 r
.78205 .30934 .79444 .32803 .82293 .31951 .81077 .30109 Metetra
.648 .73 .909 r
.81077 .30109 .82293 .31951 .85168 .31056 .83974 .29231 Metetra
.218 .636 .954 r
.19876 .50917 .21527 .51889 .23777 .52171 .22131 .51244 Metetra
0 .449 .82 r
.22131 .51244 .23777 .52171 .26026 .52916 .24384 .52019 Metetra
.356 0 0 r
.24384 .52019 .26026 .52916 .2828 .54174 .26643 .53288 Metetra
.503 0 0 r
.26643 .53288 .2828 .54174 .30559 .5583 .28928 .54929 Metetra
.475 0 0 r
.28928 .54929 .30559 .5583 .32894 .57498 .31271 .56548 Metetra
0 .414 .795 r
.31271 .56548 .32894 .57498 .35321 .58517 .33712 .57478 Metetra
.563 .798 .987 r
.33712 .57478 .35321 .58517 .37859 .58137 .36271 .56968 Metetra
.826 .823 .845 r
.36271 .56968 .37859 .58137 .40493 .5589 .38936 .54558 Metetra
.886 .792 .751 r
.38936 .54558 .40493 .5589 .43177 .51919 .41657 .50407 Metetra
.899 .773 .713 r
.41657 .50407 .43177 .51919 .45857 .46988 .44376 .45297 Metetra
.892 .763 .712 r
.44376 .45297 .45857 .46988 .48497 .42128 .47051 .40279 Metetra
.867 .756 .738 r
.47051 .40279 .48497 .42128 .51093 .38185 .49676 .36205 Metetra
.813 .742 .786 r
.49676 .36205 .51093 .38185 .53669 .35542 .52273 .33461 Metetra
.723 .711 .839 r
.52273 .33461 .53669 .35542 .56254 .34116 .54873 .31968 Metetra
.618 .665 .873 r
.54873 .31968 .56254 .34116 .58873 .33544 .57501 .31358 Metetra
.547 .629 .885 r
.57501 .31358 .58873 .33544 .61534 .33396 .60172 .31202 Metetra
.527 .62 .888 r
.60172 .31202 .61534 .33396 .64236 .33336 .62884 .31156 Metetra
.541 .631 .889 r
.62884 .31156 .64236 .33336 .66974 .33172 .65635 .31024 Metetra
.566 .648 .891 r
.65635 .31024 .66974 .33172 .69743 .32836 .68419 .3073 Metetra
.59 .667 .892 r
.68419 .3073 .69743 .32836 .72539 .32329 .71232 .30271 Metetra
.61 .683 .894 r
.71232 .30271 .72539 .32329 .75359 .31684 .74072 .29671 Metetra
.624 .697 .897 r
.74072 .29671 .75359 .31684 .78205 .30934 .76939 .28962 Metetra
.634 .709 .901 r
.76939 .28962 .78205 .30934 .81077 .30109 .79833 .28171 Metetra
.642 .719 .904 r
.79833 .28171 .81077 .30109 .83974 .29231 .82753 .27317 Metetra
.202 .628 .949 r
.18192 .49932 .19876 .50917 .22131 .51244 .20453 .50278 Metetra
0 .449 .824 r
.20453 .50278 .22131 .51244 .24384 .52019 .22713 .5106 Metetra
0 .231 .63 r
.22713 .5106 .24384 .52019 .26643 .53288 .24978 .5232 Metetra
.471 0 0 r
.24978 .5232 .26643 .53288 .28928 .54929 .27268 .5393 Metetra
.426 0 0 r
.27268 .5393 .28928 .54929 .31271 .56548 .2962 .55495 Metetra
0 .464 .846 r
.2962 .55495 .31271 .56548 .33712 .57478 .32074 .56342 Metetra
.596 .797 .976 r
.32074 .56342 .33712 .57478 .36271 .56968 .34655 .55718 Metetra
.83 .815 .835 r
.34655 .55718 .36271 .56968 .38936 .54558 .3735 .5317 Metetra
.887 .788 .746 r
.3735 .5317 .38936 .54558 .41657 .50407 .4011 .48867 Metetra
.901 .772 .71 r
.4011 .48867 .41657 .50407 .44376 .45297 .4287 .43608 Metetra
.896 .764 .709 r
.4287 .43608 .44376 .45297 .47051 .40279 .45582 .38453 Metetra
.872 .76 .736 r
.45582 .38453 .47051 .40279 .49676 .36205 .48237 .34263 Metetra
.82 .749 .786 r
.48237 .34263 .49676 .36205 .52273 .33461 .50856 .31426 Metetra
.73 .721 .842 r
.50856 .31426 .52273 .33461 .54873 .31968 .53471 .29862 Metetra
.623 .675 .878 r
.53471 .29862 .54873 .31968 .57501 .31358 .56111 .29203 Metetra
.547 .636 .891 r
.56111 .29203 .57501 .31358 .60172 .31202 .58791 .29018 Metetra
.524 .623 .892 r
.58791 .29018 .60172 .31202 .62884 .31156 .61513 .28963 Metetra
.536 .63 .892 r
.61513 .28963 .62884 .31156 .65635 .31024 .64275 .28838 Metetra
.56 .645 .891 r
.64275 .28838 .65635 .31024 .68419 .3073 .67073 .28563 Metetra
.584 .661 .891 r
.67073 .28563 .68419 .3073 .71232 .30271 .69901 .28131 Metetra
.602 .675 .891 r
.69901 .28131 .71232 .30271 .74072 .29671 .72759 .27564 Metetra
.617 .687 .893 r
.72759 .27564 .74072 .29671 .76939 .28962 .75646 .26889 Metetra
.627 .698 .896 r
.75646 .26889 .76939 .28962 .79833 .28171 .78561 .26129 Metetra
.636 .707 .899 r
.78561 .26129 .79833 .28171 .82753 .27317 .81504 .25302 Metetra
.208 .628 .951 r
.16477 .48902 .18192 .49932 .20453 .50278 .18747 .49248 Metetra
0 .462 .84 r
.18747 .49248 .20453 .50278 .22713 .5106 .21014 .50018 Metetra
0 .257 .667 r
.21014 .50018 .22713 .5106 .24978 .5232 .23285 .51255 Metetra
.43 0 0 r
.23285 .51255 .24978 .5232 .27268 .5393 .25582 .52828 Metetra
0 .18 .604 r
.25582 .52828 .27268 .5393 .2962 .55495 .27941 .54339 Metetra
.035 .502 .883 r
.27941 .54339 .2962 .55495 .32074 .56342 .30408 .55111 Metetra
.619 .793 .965 r
.30408 .55111 .32074 .56342 .34655 .55718 .3301 .54392 Metetra
.833 .808 .827 r
.3301 .54392 .34655 .55718 .3735 .5317 .35737 .51728 Metetra
.888 .785 .742 r
.35737 .51728 .3735 .5317 .4011 .48867 .38535 .473 Metetra
.902 .771 .707 r
.38535 .473 .4011 .48867 .4287 .43608 .41336 .41916 Metetra
.898 .765 .707 r
.41336 .41916 .4287 .43608 .45582 .38453 .44087 .36646 Metetra
.876 .763 .734 r
.44087 .36646 .45582 .38453 .48237 .34263 .46774 .32356 Metetra
.826 .756 .785 r
.46774 .32356 .48237 .34263 .50856 .31426 .49416 .29434 Metetra
.738 .731 .845 r
.49416 .29434 .50856 .31426 .53471 .29862 .52049 .27801 Metetra
.629 .686 .884 r
.52049 .27801 .53471 .29862 .56111 .29203 .54701 .27088 Metetra
.549 .645 .897 r
.54701 .27088 .56111 .29203 .58791 .29018 .57391 .26862 Metetra
.523 .63 .898 r
.57391 .26862 .58791 .29018 .61513 .28963 .60123 .26781 Metetra
.534 .634 .896 r
.60123 .26781 .61513 .28963 .64275 .28838 .62896 .26643 Metetra
.557 .646 .894 r
.62896 .26643 .64275 .28838 .67073 .28563 .65705 .26367 Metetra
.58 .659 .892 r
.65705 .26367 .67073 .28563 .69901 .28131 .68548 .25943 Metetra
.598 .671 .891 r
.68548 .25943 .69901 .28131 .72759 .27564 .71423 .2539 Metetra
.612 .681 .891 r
.71423 .2539 .72759 .27564 .75646 .26889 .74327 .24733 Metetra
.622 .69 .892 r
.74327 .24733 .75646 .26889 .78561 .26129 .77262 .23994 Metetra
.63 .698 .894 r
.77262 .23994 .78561 .26129 .81504 .25302 .80227 .23188 Metetra
.229 .632 .957 r
.14734 .47802 .16477 .48902 .18747 .49248 .17013 .48133 Metetra
0 .48 .862 r
.17013 .48133 .18747 .49248 .21014 .50018 .19288 .48883 Metetra
0 .287 .706 r
.19288 .48883 .21014 .50018 .23285 .51255 .21565 .50089 Metetra
0 .164 .595 r
.21565 .50089 .23285 .51255 .25582 .52828 .23867 .51625 Metetra
0 .217 .652 r
.23867 .51625 .25582 .52828 .27941 .54339 .26234 .53086 Metetra
.093 .53 .908 r
.26234 .53086 .27941 .54339 .30408 .55111 .28713 .53795 Metetra
.635 .788 .955 r
.28713 .53795 .30408 .55111 .3301 .54392 .31336 .52995 Metetra
.834 .803 .821 r
.31336 .52995 .3301 .54392 .35737 .51728 .34093 .50236 Metetra
.888 .783 .739 r
.34093 .50236 .35737 .51728 .38535 .473 .36931 .45704 Metetra
.903 .771 .705 r
.36931 .45704 .38535 .473 .41336 .41916 .39775 .40216 Metetra
.9 .766 .705 r
.39775 .40216 .41336 .41916 .44087 .36646 .42565 .34849 Metetra
.879 .766 .733 r
.42565 .34849 .44087 .36646 .46774 .32356 .45286 .30473 Metetra
.831 .761 .785 r
.45286 .30473 .46774 .32356 .49416 .29434 .47953 .27478 Metetra
.744 .739 .847 r
.47953 .27478 .49416 .29434 .52049 .27801 .50604 .2578 Metetra
.634 .696 .89 r
.50604 .2578 .52049 .27801 .54701 .27088 .53269 .25013 Metetra
.552 .655 .904 r
.53269 .25013 .54701 .27088 .57391 .26862 .5597 .24744 Metetra
.523 .638 .905 r
.5597 .24744 .57391 .26862 .60123 .26781 .58712 .24628 Metetra
.533 .641 .902 r
.58712 .24628 .60123 .26781 .62896 .26643 .61496 .24464 Metetra
.555 .651 .899 r
.61496 .24464 .62896 .26643 .65705 .26367 .64318 .2417 Metetra
.578 .662 .895 r
.64318 .2417 .65705 .26367 .68548 .25943 .67175 .23736 Metetra
.595 .671 .893 r
.67175 .23736 .68548 .25943 .71423 .2539 .70064 .23179 Metetra
.609 .679 .892 r
.70064 .23179 .71423 .2539 .74327 .24733 .72986 .22525 Metetra
.618 .686 .892 r
.72986 .22525 .74327 .24733 .77262 .23994 .75939 .21792 Metetra
.626 .693 .892 r
.75939 .21792 .77262 .23994 .80227 .23188 .78924 .20995 Metetra
.256 .637 .962 r
.12964 .46619 .14734 .47802 .17013 .48133 .15252 .46928 Metetra
.033 .497 .882 r
.15252 .46928 .17013 .48133 .19288 .48883 .17535 .47651 Metetra
0 .314 .741 r
.17535 .47651 .19288 .48883 .21565 .50089 .19818 .48828 Metetra
0 .193 .635 r
.19818 .48828 .21565 .50089 .23867 .51625 .22125 .50328 Metetra
0 .248 .691 r
.22125 .50328 .23867 .51625 .26234 .53086 .24498 .51746 Metetra
.137 .548 .923 r
.24498 .51746 .26234 .53086 .28713 .53795 .26988 .52401 Metetra
.646 .784 .947 r
.26988 .52401 .28713 .53795 .31336 .52995 .29631 .51535 Metetra
.835 .799 .816 r
.29631 .51535 .31336 .52995 .34093 .50236 .3242 .48697 Metetra
.889 .781 .736 r
.3242 .48697 .34093 .50236 .36931 .45704 .35298 .44078 Metetra
.904 .77 .704 r
.35298 .44078 .36931 .45704 .39775 .40216 .38185 .38503 Metetra
.901 .767 .704 r
.38185 .38503 .39775 .40216 .42565 .34849 .41017 .33055 Metetra
.882 .768 .732 r
.41017 .33055 .42565 .34849 .45286 .30473 .43771 .28605 Metetra
.836 .766 .785 r
.43771 .28605 .45286 .30473 .47953 .27478 .46465 .25545 Metetra
.75 .747 .849 r
.46465 .25545 .47953 .27478 .50604 .2578 .49135 .23791 Metetra
.639 .706 .895 r
.49135 .23791 .50604 .2578 .53269 .25013 .51814 .22974 Metetra
.555 .665 .91 r
.51814 .22974 .53269 .25013 .5597 .24744 .54526 .22661 Metetra
.525 .647 .912 r
.54526 .22661 .5597 .24744 .58712 .24628 .5728 .22506 Metetra
.533 .649 .909 r
.5728 .22506 .58712 .24628 .61496 .24464 .60076 .22309 Metetra
.555 .658 .905 r
.60076 .22309 .61496 .24464 .64318 .2417 .6291 .21988 Metetra
.577 .668 .9 r
.6291 .21988 .64318 .2417 .67175 .23736 .6578 .21533 Metetra
.594 .676 .897 r
.6578 .21533 .67175 .23736 .70064 .23179 .68685 .2096 Metetra
.607 .682 .895 r
.68685 .2096 .70064 .23179 .72986 .22525 .71623 .20294 Metetra
.617 .687 .893 r
.71623 .20294 .72986 .22525 .75939 .21792 .74594 .19553 Metetra
.624 .692 .893 r
.74594 .19553 .75939 .21792 .78924 .20995 .77597 .18752 Metetra
.281 .641 .966 r
.11167 .4535 .12964 .46619 .15252 .46928 .13465 .45634 Metetra
.069 .511 .898 r
.13465 .45634 .15252 .46928 .17535 .47651 .15755 .4633 Metetra
0 .337 .769 r
.15755 .4633 .17535 .47651 .19818 .48828 .18043 .47478 Metetra
0 .218 .668 r
.18043 .47478 .19818 .48828 .22125 .50328 .20354 .48946 Metetra
0 .272 .72 r
.20354 .48946 .22125 .50328 .24498 .51746 .22732 .50328 Metetra
.17 .561 .932 r
.22732 .50328 .24498 .51746 .26988 .52401 .25233 .5094 Metetra
.654 .78 .941 r
.25233 .5094 .26988 .52401 .29631 .51535 .27896 .50019 Metetra
.836 .796 .813 r
.27896 .50019 .29631 .51535 .3242 .48697 .30716 .47115 Metetra
.889 .78 .735 r
.30716 .47115 .3242 .48697 .35298 .44078 .33634 .42422 Metetra
.904 .77 .703 r
.33634 .42422 .35298 .44078 .38185 .38503 .36565 .36772 Metetra
.902 .768 .703 r
.36565 .36772 .38185 .38503 .41017 .33055 .39439 .31254 Metetra
.884 .77 .731 r
.39439 .31254 .41017 .33055 .43771 .28605 .4223 .26742 Metetra
.839 .77 .785 r
.4223 .26742 .43771 .28605 .46465 .25545 .44951 .23626 Metetra
.754 .753 .851 r
.44951 .23626 .46465 .25545 .49135 .23791 .4764 .21822 Metetra
.644 .714 .899 r
.4764 .21822 .49135 .23791 .51814 .22974 .50335 .2096 Metetra
.557 .674 .916 r
.50335 .2096 .51814 .22974 .54526 .22661 .5306 .20605 Metetra
.526 .656 .918 r
.5306 .20605 .54526 .22661 .5728 .22506 .55825 .20413 Metetra
.534 .657 .915 r
.55825 .20413 .5728 .22506 .60076 .22309 .58633 .20182 Metetra
.556 .666 .91 r
.58633 .20182 .60076 .22309 .6291 .21988 .6148 .19829 Metetra
.578 .675 .906 r
.6148 .19829 .6291 .21988 .6578 .21533 .64365 .19346 Metetra
.595 .682 .902 r
.64365 .19346 .6578 .21533 .68685 .2096 .67285 .18749 Metetra
.607 .687 .899 r
.67285 .18749 .68685 .2096 .71623 .20294 .70239 .18061 Metetra
.616 .691 .897 r
.70239 .18061 .71623 .20294 .74594 .19553 .73227 .17303 Metetra
.623 .695 .896 r
.73227 .17303 .74594 .19553 .77597 .18752 .76249 .16486 Metetra
.303 .643 .967 r
.09343 .43998 .11167 .4535 .13465 .45634 .11649 .44257 Metetra
.099 .522 .909 r
.11649 .44257 .13465 .45634 .15755 .4633 .13946 .44928 Metetra
0 .354 .79 r
.13946 .44928 .15755 .4633 .18043 .47478 .16239 .46049 Metetra
0 .237 .692 r
.16239 .46049 .18043 .47478 .20354 .48946 .18553 .4749 Metetra
0 .29 .741 r
.18553 .4749 .20354 .48946 .22732 .50328 .20936 .48843 Metetra
.194 .569 .938 r
.20936 .48843 .22732 .50328 .25233 .5094 .23446 .49418 Metetra
.659 .777 .936 r
.23446 .49418 .25233 .5094 .27896 .50019 .26128 .48451 Metetra
.836 .794 .811 r
.26128 .48451 .27896 .50019 .30716 .47115 .28979 .45491 Metetra
.889 .779 .734 r
.28979 .45491 .30716 .47115 .33634 .42422 .31939 .40735 Metetra
.905 .77 .702 r
.31939 .40735 .33634 .42422 .36565 .36772 .34915 .3502 Metetra
.903 .768 .702 r
.34915 .3502 .36565 .36772 .39439 .31254 .37833 .29441 Metetra
.885 .771 .731 r
.37833 .29441 .39439 .31254 .4223 .26742 .4066 .24874 Metetra
.841 .772 .785 r
.4066 .24874 .4223 .26742 .44951 .23626 .43409 .21709 Metetra
.758 .758 .852 r
.43409 .21709 .44951 .23626 .4764 .21822 .46119 .19862 Metetra
.647 .72 .902 r
.46119 .19862 .4764 .21822 .50335 .2096 .4883 .1896 Metetra
.56 .681 .92 r
.4883 .1896 .50335 .2096 .5306 .20605 .51567 .18568 Metetra
.527 .663 .922 r
.51567 .18568 .5306 .20605 .55825 .20413 .54345 .1834 Metetra
.535 .664 .92 r
.54345 .1834 .55825 .20413 .58633 .20182 .57166 .18074 Metetra
.557 .673 .916 r
.57166 .18074 .58633 .20182 .6148 .19829 .60028 .17689 Metetra
.578 .682 .911 r
.60028 .17689 .6148 .19829 .64365 .19346 .62927 .17175 Metetra
.595 .688 .907 r
.62927 .17175 .64365 .19346 .67285 .18749 .65863 .1655 Metetra
.608 .693 .904 r
.65863 .1655 .67285 .18749 .70239 .18061 .68834 .15836 Metetra
.617 .697 .901 r
.68834 .15836 .70239 .18061 .73227 .17303 .71839 .15053 Metetra
.623 .699 .899 r
.71839 .15053 .73227 .17303 .76249 .16486 .74879 .14214 Metetra
.32 .644 .967 r
.07491 .4257 .09343 .43998 .11649 .44257 .09806 .42806 Metetra
.123 .529 .916 r
.09806 .42806 .11649 .44257 .13946 .44928 .12109 .43453 Metetra
0 .367 .805 r
.12109 .43453 .13946 .44928 .16239 .46049 .14405 .44552 Metetra
0 .251 .71 r
.14405 .44552 .16239 .46049 .18553 .4749 .16721 .4597 Metetra
0 .303 .756 r
.16721 .4597 .18553 .4749 .20936 .48843 .19107 .47297 Metetra
.211 .575 .941 r
.19107 .47297 .20936 .48843 .23446 .49418 .21626 .47842 Metetra
.663 .775 .933 r
.21626 .47842 .23446 .49418 .26128 .48451 .24328 .46836 Metetra
.837 .792 .809 r
.24328 .46836 .26128 .48451 .28979 .45491 .2721 .43828 Metetra
.889 .778 .733 r
.2721 .43828 .28979 .45491 .31939 .40735 .30211 .39016 Metetra
.905 .77 .701 r
.30211 .39016 .31939 .40735 .34915 .3502 .33234 .33244 Metetra
.904 .769 .702 r
.33234 .33244 .34915 .3502 .37833 .29441 .36196 .27609 Metetra
.886 .772 .73 r
.36196 .27609 .37833 .29441 .4066 .24874 .39061 .22994 Metetra
.843 .774 .785 r
.39061 .22994 .4066 .24874 .43409 .21709 .41839 .19786 Metetra
.76 .761 .853 r
.41839 .19786 .43409 .21709 .46119 .19862 .44571 .179 Metetra
.65 .725 .904 r
.44571 .179 .46119 .19862 .4883 .1896 .47297 .16963 Metetra
.562 .686 .923 r
.47297 .16963 .4883 .1896 .51567 .18568 .50049 .16536 Metetra
.528 .669 .926 r
.50049 .16536 .51567 .18568 .54345 .1834 .5284 .16276 Metetra
.536 .671 .924 r
.5284 .16276 .54345 .1834 .57166 .18074 .55674 .15978 Metetra
.557 .679 .92 r
.55674 .15978 .57166 .18074 .60028 .17689 .5855 .15562 Metetra
.579 .688 .916 r
.5855 .15562 .60028 .17689 .62927 .17175 .61465 .15017 Metetra
.596 .695 .911 r
.61465 .15017 .62927 .17175 .65863 .1655 .64418 .14362 Metetra
.609 .699 .908 r
.64418 .14362 .65863 .1655 .68834 .15836 .67406 .1362 Metetra
.617 .702 .905 r
.67406 .1362 .68834 .15836 .71839 .15053 .70429 .12809 Metetra
.624 .705 .903 r
.70429 .12809 .71839 .15053 .74879 .14214 .73488 .11943 Metetra
.333 .645 .967 r
.05609 .41074 .07491 .4257 .09806 .42806 .07932 .41289 Metetra
.14 .534 .92 r
.07932 .41289 .09806 .42806 .12109 .43453 .1024 .41914 Metetra
0 .377 .816 r
.1024 .41914 .12109 .43453 .14405 .44552 .1254 .42993 Metetra
0 .262 .723 r
.1254 .42993 .14405 .44552 .16721 .4597 .14857 .44392 Metetra
0 .312 .767 r
.14857 .44392 .16721 .4597 .19107 .47297 .17245 .45698 Metetra
.223 .579 .943 r
.17245 .45698 .19107 .47297 .21626 .47842 .19773 .46217 Metetra
.665 .774 .93 r
.19773 .46217 .21626 .47842 .24328 .46836 .22493 .45178 Metetra
.837 .791 .807 r
.22493 .45178 .24328 .46836 .2721 .43828 .25407 .42126 Metetra
.889 .778 .732 r
.25407 .42126 .2721 .43828 .30211 .39016 .28451 .37264 Metetra
.905 .77 .701 r
.28451 .37264 .30211 .39016 .33234 .33244 .31521 .31439 Metetra
.904 .769 .701 r
.31521 .31439 .33234 .33244 .36196 .27609 .34528 .25755 Metetra
.887 .773 .73 r
.34528 .25755 .36196 .27609 .39061 .22994 .37431 .21095 Metetra
.844 .776 .785 r
.37431 .21095 .39061 .22994 .41839 .19786 .4024 .17849 Metetra
.762 .764 .854 r
.4024 .17849 .41839 .19786 .44571 .179 .42993 .15928 Metetra
.652 .729 .906 r
.42993 .15928 .44571 .179 .47297 .16963 .45737 .14959 Metetra
.563 .691 .926 r
.45737 .14959 .47297 .16963 .50049 .16536 .48502 .14502 Metetra
.529 .674 .929 r
.48502 .14502 .50049 .16536 .5284 .16276 .51307 .14211 Metetra
.536 .676 .928 r
.51307 .14211 .5284 .16276 .55674 .15978 .54156 .13884 Metetra
.558 .685 .924 r
.54156 .13884 .55674 .15978 .5855 .15562 .57047 .13438 Metetra
.58 .693 .919 r
.57047 .13438 .5855 .15562 .61465 .15017 .59978 .12863 Metetra
.597 .7 .915 r
.59978 .12863 .61465 .15017 .64418 .14362 .62947 .12178 Metetra
.61 .705 .912 r
.62947 .12178 .64418 .14362 .67406 .1362 .65953 .11407 Metetra
.618 .708 .909 r
.65953 .11407 .67406 .1362 .70429 .12809 .68995 .10567 Metetra
.625 .71 .907 r
.68995 .10567 .70429 .12809 .73488 .11943 .72074 .09674 Metetra
.343 .645 .966 r
.03697 .39519 .05609 .41074 .07932 .41289 .06026 .39713 Metetra
.153 .538 .923 r
.06026 .39713 .07932 .41289 .1024 .41914 .0834 .40319 Metetra
0 .383 .823 r
.0834 .40319 .1024 .41914 .1254 .42993 .10641 .4138 Metetra
0 .269 .732 r
.10641 .4138 .1254 .42993 .14857 .44392 .12959 .42762 Metetra
0 .319 .775 r
.12959 .42762 .14857 .44392 .17245 .45698 .15349 .44051 Metetra
.232 .581 .944 r
.15349 .44051 .17245 .45698 .19773 .46217 .17884 .44547 Metetra
.667 .772 .928 r
.17884 .44547 .19773 .46217 .22493 .45178 .20623 .43478 Metetra
.837 .79 .807 r
.20623 .43478 .22493 .45178 .25407 .42126 .23569 .40387 Metetra
.889 .777 .732 r
.23569 .40387 .25407 .42126 .28451 .37264 .26656 .35478 Metetra
.905 .77 .701 r
.26656 .35478 .28451 .37264 .31521 .31439 .29775 .29604 Metetra
.905 .769 .701 r
.29775 .29604 .31521 .31439 .34528 .25755 .32829 .23875 Metetra
.888 .774 .73 r
.32829 .23875 .34528 .25755 .37431 .21095 .35771 .19174 Metetra
.845 .777 .785 r
.35771 .19174 .37431 .21095 .4024 .17849 .3861 .15892 Metetra
.764 .766 .854 r
.3861 .15892 .4024 .17849 .42993 .15928 .41386 .13939 Metetra
.653 .732 .907 r
.41386 .13939 .42993 .15928 .45737 .14959 .44147 .1294 Metetra
.564 .694 .928 r
.44147 .1294 .45737 .14959 .48502 .14502 .46927 .12455 Metetra
.53 .677 .932 r
.46927 .12455 .48502 .14502 .51307 .14211 .49746 .12137 Metetra
.537 .679 .93 r
.49746 .12137 .51307 .14211 .54156 .13884 .52609 .11781 Metetra
.559 .689 .926 r
.52609 .11781 .54156 .13884 .57047 .13438 .55516 .11307 Metetra
.581 .698 .922 r
.55516 .11307 .57047 .13438 .59978 .12863 .58464 .10704 Metetra
.598 .705 .918 r
.58464 .10704 .59978 .12863 .62947 .12178 .61451 .0999 Metetra
.61 .71 .915 r
.61451 .0999 .62947 .12178 .65953 .11407 .64475 .0919 Metetra
.619 .713 .913 r
.64475 .0919 .65953 .11407 .68995 .10567 .67537 .08322 Metetra
.626 .715 .911 r
.67537 .08322 .68995 .10567 .72074 .09674 .70635 .07399 Metetra
.35 .645 .965 r
.01752 .37909 .03697 .39519 .06026 .39713 .04088 .38084 Metetra
.163 .54 .925 r
.04088 .38084 .06026 .39713 .0834 .40319 .06405 .38673 Metetra
0 .388 .828 r
.06405 .38673 .0834 .40319 .10641 .4138 .08708 .39718 Metetra
0 .274 .738 r
.08708 .39718 .10641 .4138 .12959 .42762 .11025 .41085 Metetra
0 .324 .78 r
.11025 .41085 .12959 .42762 .15349 .44051 .13416 .42358 Metetra
.238 .583 .945 r
.13416 .42358 .15349 .44051 .17884 .44547 .15959 .42835 Metetra
.668 .772 .927 r
.15959 .42835 .17884 .44547 .20623 .43478 .18717 .41738 Metetra
.837 .789 .806 r
.18717 .41738 .20623 .43478 .23569 .40387 .21695 .3861 Metetra
.889 .777 .731 r
.21695 .3861 .23569 .40387 .26656 .35478 .24826 .33657 Metetra
.905 .77 .7 r
.24826 .33657 .26656 .35478 .29775 .29604 .27995 .27738 Metetra
.905 .769 .701 r
.27995 .27738 .29775 .29604 .32829 .23875 .31097 .21964 Metetra
.888 .774 .73 r
.31097 .21964 .32829 .23875 .35771 .19174 .3408 .17225 Metetra
.846 .778 .785 r
.3408 .17225 .35771 .19174 .3861 .15892 .3695 .13909 Metetra
.765 .767 .855 r
.3695 .13909 .3861 .15892 .41386 .13939 .39749 .11927 Metetra
.654 .734 .908 r
.39749 .11927 .41386 .13939 .44147 .1294 .42526 .10901 Metetra
.565 .697 .929 r
.42526 .10901 .44147 .1294 .46927 .12455 .45321 .10389 Metetra
.531 .68 .933 r
.45321 .10389 .46927 .12455 .49746 .12137 .48154 .10044 Metetra
.538 .682 .932 r
.48154 .10044 .49746 .12137 .52609 .11781 .51033 .09662 Metetra
.56 .692 .929 r
.51033 .09662 .52609 .11781 .55516 .11307 .53956 .09161 Metetra
.582 .701 .924 r
.53956 .09161 .55516 .11307 .58464 .10704 .56921 .08531 Metetra
.599 .708 .921 r
.56921 .08531 .58464 .10704 .61451 .0999 .59926 .07789 Metetra
.611 .713 .918 r
.59926 .07789 .61451 .0999 .64475 .0919 .6297 .06961 Metetra
.62 .717 .915 r
.6297 .06961 .64475 .0919 .67537 .08322 .66051 .06064 Metetra
.626 .719 .913 r
.66051 .06064 .67537 .08322 .70635 .07399 .6917 .05113 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.11029 .2265 m
.11497 .2311 L
s
[(-2)] .10092 .21731 1 .98174 Mshowa
.26314 .16665 m
.26757 .17149 L
s
[(0)] .25429 .15697 .91436 1 Mshowa
.42547 .10309 m
.4296 .10819 L
s
[(2)] .41721 .09289 .81011 1 Mshowa
.59817 .03546 m
.60196 .04082 L
s
[(4)] .59061 .02474 .70586 1 Mshowa
.125 Mabswid
.14766 .21187 m
.15043 .21466 L
s
.18558 .19702 m
.18832 .19985 L
s
.22407 .18195 m
.22677 .18482 L
s
.3028 .15112 m
.30541 .15406 L
s
.34306 .13535 m
.34564 .13834 L
s
.38395 .11935 m
.38647 .12237 L
s
.46763 .08658 m
.47006 .08968 L
s
.51046 .06981 m
.51284 .07294 L
s
.55397 .05277 m
.55629 .05595 L
s
.07346 .24092 m
.0763 .24365 L
s
.64309 .01787 m
.6453 .02113 L
s
gsave
.29165 .07573 -71.2423 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(v) show
69.062500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.563},
  ImageMargins->{{Inherited, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X00018a000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00
ogoo3Goo1@00Egoo003oOol=Ool01@00Oomoogoo0000Egoo003oOol>Ool00`00Oomoo`1HOol00?mo
o`Eoo`H000Aoo`03001oogoo05Moo`00ogoo47oo00<007ooOol0EWoo003LOol3000aOol00`00Oomo
o`1EOol00=eoo`03001oogoo02aoo`05001oogooOol0001GOol00=eoo`03001oogoo02eoo`<005Qo
o`00fGoo1P007goo0P00J7oo003JOol01000Oomoo`007Woo1@00Igoo003JOol01000Oomoo`006goo
0`000goo0P00Igoo003KOol00`00Ool0000IOol20006Ool00`00Ool0001VOol00=aoo`8001Ioo`<0
00Qoo`04001oogoo001UOol00?9oo`8000]oo`04001oogoo001UOol00>moo`<000eoo`05001oogoo
Ool0001TOol00>aoo`<0009oo`03001oogoo00]oo`03001oogoo009oo`03001oogoo065oo`00jWoo
0P0057oo00D007ooOomoo`0006=oo`00igoo0`005Woo00@007ooOomoo`80069oo`00iGoo0P006Goo
00<007ooOol00goo00<007ooOol0Ggoo003ROol3000KOol00`00Oomoo`03Ool00`00Oomoo`1OOol0
0>1oo`8001ioo`03001oogoo00Aoo`03001oogoo05ioo`00MWoo0P00IGoo0`000Woo0P0077oo00<0
07ooOol01Goo00<007ooOol0GGoo001fOol2001SOol2000SOol00`00Oomoo`05Ool00`00Oomoo`1M
Ool007Eoo`04001oogoo001OOol3000UOol00`00Oomoo`06Ool00`00Oomoo`1LOol007Eoo`04001o
ogoo001MOol2000XOol00`00Oomoo`07Ool00`00Oomoo`1KOol007Aoo`03001oogoo009oo`03001o
ogoo05Moo`<002Uoo`8000Uoo`03001oogoo05]oo`00Lgoo0`000Woo0`00EWoo0P0000=oo`00Ool0
9Woo0`0000=>g00000001goo00<007oo0000G7oo002POol5000YOol3000WOol40002C]`014kMC]`0
00002Goo00<007ooOol0FWoo002POol01@00Oomoogoo00009goo0P009goo0`0024kL00<004kL0000
2Goo00<007ooOol0FGoo002QOol00`00Oomoo`0UOol3000VOol3000014[LC]d004kM0dkL00E>gDkL
C]a>g000009>g003001oogoo00Moo`03001oogoo05Qoo`00XWoo00<007ooOol08Goo0`009Goo1000
1DkL00<004kLC]`01TkL00D004kLC]a>g00000Qoo`03001oogoo05Qoo`00Xgoo00<007ooOol07Woo
0P009Goo0`0000e>gD[LC]e:_4kMB]a>gDZlC]e:g000C]a>g@03C]`01dkMC]`004kLC]e>g00000Uo
o`03001oogoo05Moo`00Y7oo00<007ooOol06Woo0`000Woo00<007ooOol07goo0`0000=>g4[L0000
2dkL00<004kLC]`01DkL00<004kLC]`00P002Goo00<007ooOol0EWoo002POol01@00Oomoogoo0000
6Woo0P008goo100001E>gDZlC]e:_4kM001>gDZlC]e:g4kMB[a>gD[LC]e:_4kMB]`004kLC]d00dkL
00M>g@00000004kMC]`00008Ool2001GOol00:5oo`<001Qoo`<0025oo`@0000;B]a>g4[LC]e:g4kL
B]a>gD[LC]`0000;C]`00`00C]a>g0050004C]`00`00Oomoo`05Ool3001GOol00;Yoo`8001moo`D0
000JB]e:_4kM001>gDZlC]e:_4kMB[a>gDZlC]e:_4kM001>gDZlC]e:g4kMB[a>gD[LC]e:_0<00006
C[a>gDkLC]`004kM0TkL00=>_4kM00002Goo00<007ooOol0E7oo002gOol3000LOol50002B]`054[M
B[a:g4[LB]e:_000B]a>gD[LC]a:g4kMB]a>g4[LC]e:g4kL0006C]`30002C]`00`00C]a>g002C]`0
0`00C]a>g004C]`00`00Oomoo`06Ool00`00Oomoo`1DOol00;Eoo`800003Ool007oo01Moo`D0000M
B]e6_4[M001:gDZlC]e:_4[MB[a>gDZlB]e:_000B[a>gDZlC]e:_4kMB[a>gDZlC]e:_000B]a>g@04
00001TZlC]e:_4kLB[`0009>g006C[a>g@00C]a>_4kM0TkL00=>_000Ool027oo00<007ooOol0Dgoo
002bOol3000GOol5000034ZmA[a:gDJlB[e6_4[MA[`004[LB]e:_09:g00AB]e:_4[LB]a:gDZl001:
g4kMB]a>g4[LC]e:g4kLB]a>g@03000:C]`01@00C]a>g4kL00001dkL00<007ooOol01goo00<007oo
Ool0DWoo002`Ool2000FOol400008DJm@[a6g@00B]e6_4[MA[a:gDJlB]e6_4[MA[`004ZlB]e:_4kM
B[a:gDZlC]e:_4[MB[`004ZlC]e:_4kMB[a>g@0300003dkMB[`004ZlC]a:_4kMB[a>g4ZlC]e:_4kL
B[`00002C]`01P00C]e>g4kLC[a>g@9>g003001oogoo00Moo`03001oogoo059oo`00[Goo0`004Goo
1`000TJm01E6_4JmA[e6_DJl0016_4[MA[a:_DJlB]e6_4ZmA[a:gDJl001:g4[MB[`00T[L00Q:gDZl
B]a:g4[M001>g4[L100000I>g4ZlC]a:g4kL000;C]`01000C]a>g0001dkL0P002Goo00<007ooOol0
DGoo002[Ool2000:Ool:000094:L@[e2W4Jm@Y`004:lA]e6_4Jm@[a6gDJlA[e2_000A[a:gDJlB]e6
_4[MA[a:gDJlB]e6_000B[a:gDZlC]e:_4[MB[a>g@@0000MB[a>gDZlC]e:_4kMB[a>gDZlC]d004kM
B[a>g4ZlC]e:_4kLB[a>gDZlC]`004kM001>g4jlC]e>g00300000djlC]`00009Ool00`00Oomoo`1@
Ool00:Qoo`<000Eoo`L000E2_@030012_D:m00M2_@030016_DJl00=6_@0AA[a6_DJmA[e6_000A[a:
gDJlB[e6_4[MA[a:_DJlB]d00002B]`00d[M00000003000044[LB[a:g@00C]a:g4kLB[a>g4[LC]a:
_4kLB]a>g0002TkL00<004kL000010000TkL00A>_4kLC]`000Qoo`80019oo`D003]oo`00YGoo0`00
0Woo00<007oo00000`0002]6gDJlA]d004:m?Ya2_D:L@[dnW4:m@Ya2_@00A[e2W4:m@Ya6_D:L@[e2
W4Jm0016_D:lA]e6_4Jm@[a6gDJlA[e2_000A[a:gDJlB]e6_4[MA[a:g@0500007T[MB[a>gDZlB]e:
_4kMB[`004ZlC]e:_4kMB[a>gDZlC]e:_4kMB[a>g@00C]e:_4kLB[a>gDZlC]a:_0@0000;C]a>_4kL
B[a>g4jlC]a:_4kLC[`00009Ool00`00Oomoo`0AOol00`00Oomoo`0kOol00:=oo`8000=oo`@00096
_@06A[a6_DJmA[e6_0002T:m00<004:m@[d01d:m00<004JmA[`00dJm00Q6_4JmA[e6_@00B[e6_4[M
1@0001]:_DJlB[d004[LB[a:gDZlB]a:_4[MB[a:g4Zl001:_4kLB]a>g4ZlC]a:g4kLB[a>g4[L0000
0dkL1@0000E>_4kLC]`004jl00=>g007C[a>g4kLC]a>_4kL00002Woo00<007ooOol047oo00<007oo
Ool0>goo002POol30002Ool30000:E;lD]`004JlA]e6_4KMA[a6gDJlA]e6_000@Ya2_CjL@[e2W4:m
?Ya2_D:L0012W4Jm@Ya2_D:LA[e2W4:m@Ya6_@00A[e2_4KMA[a6_D:lA]d01@0001m:gDJlB]e6_4[M
A[a:gDJl001:_4kMB[a:gDZlC]e:_4[MB[a>gDZl001:_4kMB[a>gDZlC]e:_4kMB[a>g@0400005DZl
C]a:_4kLB[a>g4ZlC]`004kLB[a>g4jlC]a:_4kLC[a>g4ZlC]`00009Ool00`00Oomoo`05Ool60005
Ool00`00Oomoo`0kOol009ioo`80009oo`<0009Bg006D_aBg5;LD]`004Jl0dJm00I6_4JmA[e6_DJl
0009@[d00`00@[e2_@07@[d01000A[e6_DJl10000dJm01h004ZmA[a:_DJlB[e6_4ZmA[a:_DJl001:
_4[LB[a:gDZlB]a:_4[MB[a:g4Zl001:_4kLB]a>g4ZlC]`3000014kLB[`004jl0dkL00E>_4kLC]a>
g4jl00800003C]a>_4kL009>g006C[a>g4kLC]a>_0002Woo00<007ooOol03goo00<007ooOol0>goo
002KOol30002Ool2000095;lD]aBo4kLD_aBg5;lC]aBo5;L0016_4KMA[a6gDJlA]e6_4KMA[`004:L
@[dnW4:m@Ya2_CjL@[e2W000@Ya6_D:L@[e2W0L0000Q@[a6_DJlA[e2_4JmA[`004JlB]e6_4[MA[a:
gDJlB]e6_4[MA[`004ZlC]e:_4[MB[a>gDZlB]e:_4kM001>gDZl00@0000?C]e:_4kLB[a>g@00C]a:
_4kLB[a>g4ZlC]a:_4kL0080000:C[a>g4ZlC]a>_4kLB[a>g4jlC]`2000:Ool00`00Oomoo`0>Ool0
0`00Oomoo`0kOol006]oo`@002Yoo`800007Ool007ooOol005kj00000e;L00EBo5;LD]aBg5;l009B
g0030016_DJl00=6_@05A[a6_DJmA[d00006@[d900001T:M@[e2_D:m@Yd00096_@05A[a6_DJmA[e6
_002A[d05@00A[a:_DJlB[e6_4ZmA[a:_DJlB[e6_000B[a:g4ZlB]e:_4[LB[a:g@0400003DZlC]a:
_4kLB[a>g4ZlC]a:_4kL001>g4jl00=>g004C[a>g4kLC]`20002C]`014jlC]a>g4kL0`0000=>g4jl
00002Goo00<007ooOol037oo0`00?Goo001ZOol00`00Oomoo`02Ool00`00Oomoo`0TOol30004Ool2
000055kjHa/005;lC]aBo5;LD_a>g5;lD]aBo4kLD_`004KMA[a6gDJlA]d:0000:4:L@[dnW4:m@Y`0
04:LA[e2W4:m@Ya6_D:L@[e2W000A[a6_D:lA[e6_4Jm@[a6_DJl0016_4[MA[a:gDJlB]e6_4[MA[a:
g@00B]e:_4kM1@0001Q:gDZlB]d004kLB[a>gDZlC]a:_4kMB[a>g4Zl001:_4kLB[a>g4ZlC]a:_4kL
B[`200000dkLC[`0000300001TkLB[]>g4jlC]`000Yoo`03001oogoo00eoo`03001oogoo03]oo`00
JWoo00<007ooOol00Woo00<007ooOol08Woo0P001Woo00P005lJG_YS6UkjGaX005;l0e;L00IBo5;L
D]aBg5;lD]`600000dJmA[a6_@02A[d01@00@[e2_D:m@Yd00d:m00E2WD:m0012_D:M00=2_@06@Ye2
_D:m@[e2W@000TJm00E6_4JmA[e6_DJl0096_@090016_4ZmA[a:_DJlB[e6_4Zm00D0009:_00CB]a:
_4ZlB[a:g4Zl001:_4kLB[a>g4ZlC]a:_4kLB[a>g4Zl00000TkL00I>_4kLC]a>g4jlC]`400002djl
C]a>_4kLC[a>g4jlC]a>_4kL00001goo0P0000=oo`00Ool0Bgoo001ZOol00`00Oomoo`02Ool00`00
Oomoo`0OOol30007Ool04000Ha]NnV<KG_YS6ekjHa/005;lC]aBo5;LD_a>g5;l0P0002i>g5;l0016
_DJlA]e6_4JmA[a6gDJl000nW4:m@Ya2_CjL@[e2W4:m?Ya2_@00@[e2W4Jm@Ya2_D:LA[e2W4:m0016
_DJlA[e2_4JmA[a6_D:lA[d004[MA[a:g@D0000PB[e6_4[M001:gDZlB]e:_4[MB[a:gDZlB]e:_000
B[a>g4ZlC]e:_4kLB[a>gDZlC]`004kLB[a>g4ZlC]a:_0<0000?B[a>g000C]a>_4kLB[]>g4jlC]a:
^dkLC[a>g00000Uoo`03001oogoo04Yoo`00JWoo00<007ooOol00Woo00<007ooOol077oo0`0027oo
0P0000]O6UkjHaYNnUlJG_YS6UkjGaX005;l00=Bg080009Bg003D_aBg0000096_@05A[a6_DJmA[e6
_002A[d00`00@Ye2_@02@[d02D:M@[e2_D:m@Ye2_@00@[e2W@03@[d01D:M@[e2_D:m00000dJm00=6
_4Jm00001P0000]:_4JlB[e6_4ZlA[a:_DJl001:_4[L00=:_00CB]a:_4ZlB[a:g4Zl001:_4kLB[a>
g4ZlC]a:_4kLB[a>g000C]`0100000=>_4kL00000Tjl00d004jlC]a>_4kLC[a>g4jlC]a>_4kLC[`0
000:Ool00`00Oomoo`19Ool006Yoo`03001oogoo009oo`03001oogoo01Yoo`@000Qoo`0?001NnV<K
G_YS6ekjHa]NnV<KG_YS6ekj001Bg5;l0080000TD]aBo4kLD_aBg5;lC]`004JlA[e6_4KMA[a6_DJl
A]e6_000?Ya2_D:L@[dnW4:m@Ya2_CjL@[d004:m@Ya6_D:L@[e2W4Jm1`0002A6_D:lA[e2W4Jm001:
_DJlB]e6_4ZmA[a:gDJlB[e6_000B[a:gDZlB]e:_4[MB[a:gDZlB]e:_000B[a>g4ZlC]e:_4kLB[`4
00005dkLB[a>g4ZkC]a:_000B[]>g4Zl001:^dkLC[a>g4ZkC]a>_4kLB[]>g4jl00002Woo00<007oo
Ool0B7oo001ZOol00`00Oomoo`02Ool00`00Oomoo`0HOol2000;Ool03P00G_YO6UkjHaYNnUlJG_YS
6UkjGaYNnV<JG_X200001E;lD]aBg5;LD_`00e;L00=Bo5;L00000TJm00E6_4JmA[e6_DJl0096_@03
0012WD:m0092_@06@Ye2_D:m@[e2W@000T:m00=2W@0000000P000d:m01P004JmA[a6_DJlA[e6_4Jm
A[`004JlB[e6_4ZlA[a:_DJlB[a6_4ZmA[`004ZlB]`3B[`02D[LB[a:_4ZlB]`004kLB[a>g0040003
B[`02P00B[a>_4jlC]a:_4jl001>g4Zl0Tjl00`004jlC]a>_4kLC[a>g4jlC]a>_4kL000:Ool00`00
Oomoo`18Ool006]oo`@001Qoo`<000aoo`0=001[6000G_YS6ekjHa]NnV<KG_YS6ekjHa/00P0001eN
nP00D]aBo4kLD_aBg5;lC]aBo5;LD_a>g000A[a6_DJlA]e6_4JmA[a6g@00@[dnW4:m@Ya2_CjL00L0
000V@Ya6_D:L@[e2W4Jm@Y`004:LA[e2_4Jm@Ya6_D:lA[e2W000A[a:_DJlB]e6_4ZmA[a:gDJlB[e6
_000B[a:gDZlB]e:_4[MB[a:g@D0000MC]a:_4kLB[a>g4ZlC]`004kLB[]>g4ZlC]a:^`00B[a>g4Zk
C]a:_000B[]>g4jlC]a:^dkLC[a>g003000:Ool00`00Oomoo`17Ool008Eoo`8000ioo`0E001[66/H
JaP005kjGaYNnV<JG_YO6UkjHaX005lJG_YS6Ukj001Bg5;l00=Bg006D_aBg5;LD]aBo0000dJm00=6
_4Jm00002@0000I2W4:m@Ye2_D:L0002@[d01D:L@[e2_D:m@Y`00T:m01H004JlA[e6_4JmA[a6_DJl
A[e6_000A[a:_DJlB[a6_4ZmA[a:_4JlB[d0009:_003B]`0000000<000=:_004001:_4ZlC[`3B[`0
1TjlB[a:_000C]a:_09>_00;C]`004jlC[a>g4ZlC[`004kLC[a>g0050003C[`00`00Oomoo`08Ool0
0`00Oomoo`16Ool0089oo`<000moo`04001[66/HJ_P2JaP01P00G_YS6ekjHa]NnP80000@Ha]NnV<K
G_YS6ekj001Bg5;lC]aBo5;LD_a>g5;lD]`60000;DJmA[a6_DJlA[d004:m?Ya2_D:L@[dnW4:m@Ya2
_CjL0012W4:m@Ya6_D:L@[e2W4Jm@Y`004:LA[e2_4Jm@Ya6_D:lA[e2W000A[a:_DJlB]e6_4ZmA[a:
g@050002B[`074[MB[a:_4ZlB]e:_000B[a>g4ZlC]a:_4kLB[a>g4ZlC]`004kLB[]>g4Zl001:^dkL
B[a>g4Zk100000U>g4jkC]a:^dkLC[]>g4Zk00002Goo0P00B7oo001oOol4000@Ool00`00JaQ[6004
JaP03`00HaYNnUlJG_X005kjGaYNnV<JG_YO6UkjHaX00002D]`015;lD]aBg5;L0`000U;L00D004Jm
A[e6_DJl00=6_@0>A[a6_@00@[e2W4:m@Ye2_D:L@[e2WD:m@Y`00092_@05@Ya2_D:m@[e2W002@[d0
3@00A[a6_DJlA[e6_4JmA[a6_@00B[a6_4Zm00D00004B[a6_4Zl000:B[`01@00B[a:_4ZlC[`00dZl
00Y>_4ZlB[`004kLB[a>_000C]a:_0<00003B[a>_00000Y>_003001oogoo00Qoo`03001oogoo04Eo
o`00OGoo0P004goo00@006/HJaQZn0=[6004J_Q[6000Ha/200003EkjHa]NnV<KG_YS6ekjHa]NnV<K
001Bo5;L00<0000ZC]aBo4kKD_a>g5;l0016_DJlA[e6_4JmA[a6_DJlA[d004:m?Ya2_D:L@[dnW4:m
@Ya2_@00A[e2W4:m@Ya6_D:L@[e2W4Jm0016_D:LA[e2_4Jm1`0000]:_DJlB[e6_4ZmA[a:_DJl001:
_4[M00=:_00CB]e:_4ZlB[a:g@00C]a:_4kLB[a>g4ZlC]a:_4kLB[`004ZlC]`01000015:^dkLB[]>
g4Zk001>^dkLB[]>g4jkC]a:^dkLC[]>g00000]oo`03001oogoo04Aoo`00NWoo0`0057oo00<006/H
JaP026/H00h006<JG_YO6UkjHaYNnUlJG_YS6UkjGaYNnV<J0P002U;L00D004JmA[e6_DJl00=6_@0=
A[a6_@00@[e2W4:m@Ye2_D:L@[e2WD:m00000d:m00=2W4:m000020000156_DJLA[a6_4Jm001:_4Jl
B[a6_4ZlA[a:_4JlB[a6_00000Y:_003001>_4Zl009:_004C[a:_4ZlB[`400000djl001>_002C[`0
1TZlC[a>_4jlB[`000Y>_003001oogoo00Qoo`03001oogoo04Aoo`00N7oo0P005Woo00@006/HJaQZ
n0=[600AJ_Q[66/HJaP006/H001S6ekjHa]NnV<KG_YS6ekjHa]NnP0200007F<K001Bo4kLD_a>fe;l
C]aBo4kKD_a>g000A[a6_DJlA[e6_4JmA[a6_DJlA[d004:m?Ya2_D:L@[d02@0001e6_D:L@[e2W4Jm
0016_D:LA[e2W4Jm@Ya6_D:L0016_4ZmA[a:_DJlB[e6_4ZmA[a:_DJl001:_4[M00=:_008B]e:_4Zl
B[`004ZlC]a:_0D0000JB[a>_4Zk001:^`00B[]>g4ZkC]a:^dkLB[]>g000C]a>^dkLB[]>g4jkC]a:
^dkLC[/000]oo`03001oogoo04=oo`00MGoo0`005goo00<006/HJaP026/H00h006/HJaQ[6000HaYN
nUlJG_YS6UkjGaYNnP000ekj00=S6P00D]`02E;L00<004JlA[d00TJm00A6_4JmA[e6_@L0000B@[e2
W4:M@Ye2_@00@Ye2W4:m@Ya2WD:L@[e2W000A[a6_DJL0TJl0156_DJLA[a6_000A[a:_4JlB[a6_4Zl
A[a:_4JlB[a6_00000M:_0D000=:_00:C[a:_4ZlB[a>_000C[`004jlB[`3C[`01DZlC[a>_4jl0000
2Djl0P002Woo00<007ooOol0@goo001cOol2000IOol01000JaQ[66[h0f/H011Zn6/HJaQ[66[h001Z
n6/HJ_Q[6000Ha]NnV<KG_YS6`80000EG_YS6ekjHa]NnV<K001Bo4kLD_a>fe;lC]aBo4kKD_a>g000
A[a6_DJl00@0000/A[e2W4Jm0012_CjL@[e2W4:m?Ya2_D:L0012W4Jm@Ya2_D:LA[e2W4:m@Y`004:L
A[e2W4Jm@Ya6_D:LA[e2W000A[a:_DJlB[e6_4ZmA[a:_DJlB[d0009:_003B]d00000008000=:_00;
001:_4jlB[]>g4ZlC[a:^dkLB[a>_002000044ZkC]a:^dkLB[]>g4ZkC]a:^`00B[]>g4jkC]a:^dkL
0`0000=>g4jk00002Woo00<007ooOol0@Woo001`Ool30002Ool00`00Oomoo`0EOol00`00JaQ[6009
JaP00`00JaQ[6003JaP01`00G_YS6UkjGaX006<J00=NnP05HaYNnUkjG_X0000:D]`400002dJlA[e6
_4JmA[a6_DJl0012WD:m@Y`00T:M0192_D:L@Ye2W@00@Ya2WD:L@[e2W4:M@Ya2_D:L0016_4JmAY`2
A[`03DJmAYa6_4Jl0016_4ZlA[a:_4JlB[a6_4Zl00D000M:_004001:_4ZlC[`3B[`01DjlB[a:_4Zl
C[`00P000Tjl00E:_4jlC[a>_4Zl009>_003001>_00000<000=>_003C[]>_00000]oo`03001oogoo
045oo`00KWoo0P0077oo00@006kf001Zn0=[600?J_Q[66/HJaQZn000J_Q[66[hJaQZn6/HJ_P005kj
0080000AHa]NnV<KG_YS6ekjHa]NnV<KG_X004kKD_a>g5;lC]]Bo0030000;E;lC]`004:LA[e6_4Jm
@Ya6_DJlA[e2W000@Ya2_CjL@[e2W4:m?Ya2_D:L0012W4Jm@Ya2_D:LA[e2W4:m@Y`004:LA[e2W4Jm
@Ya6_D:LA[d004ZmA[a:_@05000014ZlAYa:_@002DZl01@004kLB[a>_4ZkC]a:_4jlB[]>g4ZlC[`0
04kLB[]>g4ZkC]a:^dkL100000]:^dkLC[]>_4ZkC]a>^djlB[]>g00000Uoo`8004=oo`00Jgoo0`00
7Woo00@006lFKaH000M[6003001[66/H00M[6003001NnV<J00=NnP05HaYNnUkjG_YS6P03G_X00`00
D]aBg0030006D]`03P00A[a6_DJlA[e6_4JmA[a6_DJl0012WD:m@Y`2@Yd03T:m@Ya2WD:M0012W4:M
@Ya2_D:L@Ye2W4:m0002A[`00dJmAYa6_0070002A[`01dZlA[a6_4JlB[a6_00000Y:_004001:_4Zl
C[`3B[`01TjlB[a:_4Zl001:_09>_0@00006C[a:^djl001>_4jk0djl00M>^djlC[a>_4jkC[`0000:
Ool00`00Oomoo`10Ool006Uoo`80021oo`07001c5fkfLaM^mP00J_P00f/H01]Zn000J_Q[66[hJaQZ
n6/HJ_Q[66[h001Zn000G_YS6ekjHa]NnV<KG_YS6ekjHa]NnV<KG_X00P0002=Bo4kLD]a>fe;lC]aB
g4kKD_a>g000@Ya6_DJlA[e2W4JmA[a6_D:L0012W4:m?Ya2_D:L@[dnW4:m0012_D:LA[e2W4:m00T0
000AA[e2W4Jm@Ya6_@00B[a6W4ZmAYa:_4JLB[e6W4ZlAY`0000:B[`02@00C]a:_4jlB[]>g4ZlC[a:
^`0500005DZkC[a:^djlB[]>_4Zk001>^djlB[]>g4jkC[a:^dkLC[]>_4ZkC]`0000:Ool00`00Oomo
o`0oOol003Qoo`D002Uoo`<0029oo`03001_5W<F009_5P03001[66/H009[6003001[66/H00M[6007
001[66/HJaP005kjHaX00ekj00ES6UkjG_YNnV<J00800003G_X005;L00UBg00;0016_DJlA[e6_4Jm
A[a6_DJlA[d00002@Yd00d:m@Ya2W@0900004D:M@Ya2W4:L@Yd004JlAYa6_4JLA[a6W4JlAY`004Jl
B[`00dJl00I:_4JlA[a6_4Zl000:B[`01000B[a:_4Zl1@0000E:_000B[`004Zk00=>_006B[]>_4jl
C[a:^`000Tjl00E>^djlC[a>_4jk00=>_003C[/007oo00Uoo`03001oogoo03moo`00>7oo00D007oo
Oomoo`0002Moo`80009oo`03001oogoo01moo`0i001^mW<GK_Ic5fkfLaL006/HJ_Q[6000JaQZn6/H
J_Q[66[hJaQZn6/H001[66[hJaQZn000G_YS6ekjHa]NnV<KG_YS6`00Ha]NnV<KG_X004kKD_a>g5;L
C]]Bo4kLD]a>fe;l0016_D:LA[e6_4Jm00T0000T@[dnW4:M?Ya2_@00@Ye2W4:m@Ya2WD:L@[e2W000
@Ya6_D:LA[e2W4Jm@Ya6_D:L0016W4ZlAYa:_DJLB[a6W4ZmAYa:_00024Zl1@0001i:^djlBY]>_4Zk
C[`004jl001>_4ZkC[a:^djlB[]>_4ZkC[a:^`00C[]>_4ZkC]a>^djlB[]>g4jkC[`2000:Ool00`00
Oomoo`0nOol003Uoo`03001oogoo02Eoo`<002Ioo`03001c5VlF009_5P06LaI_5VlF001[60002F/H
00<006/HJaP00f/H00@005kjG_YS6P=NnP8000INnP03001Bg5;L00MBg0H0000AA[e6_4JlA[a6_@00
@Ye2W4:M@Ya2WD:L@Ye2W000@Ya2W@03@Y`04D:M@Ya2W4:L0016W4JlAYa6_4JLA[a6W4JlAY`004Jl
B[`00dJl00E:_4JlA[a6_00000=:_0D000=:_005001:_4ZlB[a>_003B[`01P00B[a:_000C[a:^`=>
_006B[]>_4jlC[a:^`000Tjl00A>^djlC[a>_0<00003C[a>^`0000Yoo`03001oogoo03eoo`00<7oo
1P0017oo00<007ooOol08Goo0`00:7oo034007<GK_Ic5fkfLaM^mW<GK_Ic5`00JaQZn6/HJ_Q[66[h
JaQZn6/H001[66[hJaQZn6/HJ_Q[6000Ha]NnV<KG_X005kjHa]NnV<KG_YS6ekjHa/005;LC]]Bo4kL
D]a>f`030000<DkKD]`004Jm@Ya6_DJLA[e2W4JmAY`003jL@[dnW4:M?Ya2_CjL@YdnW000@Ya2WD:L
@[e2W4:M@Ya2_D:L0012W4Jm@Ya6_D:LA[e2W4Jm@Y`004JLB[a6W4ZmAYa:_4JL00D0000QBY]:_4ZK
B[a:VdZlBY]:_000C[a:VdjlB[]>_4ZKC[`004jlBY/004ZkC[a:^djlB[]>_4ZkC[a:^djl001>g4jk
00@00006C[a:^dkLC[]>_0002Woo00<007ooOol0?Goo000kOol00`00Oomoo`0NOol2000ZOol00`00
LaI_5P02KaH027<FKaI_5VlFLaH006lF0007JaP00`00JaQ[6007JaP01000G_X000002Ukj00<005;L
D]`00`0000Q>g5;LD]aBg4kL0016_4Jm0dJl00i6_DJlA[a6_000@Ya2WD:L@Ye2W4:M@Ya2W@000T:L
00E2WD:L@Ya2W4:M00=2W00:0016W4JlAYa6_4JLA[a6W4Jl0002A[`00dZl00000002000014JLA[a6
W0002TZl00<004jlB[`00TZl00M>_4Zl001:_4jlB[`00002C[`01TZkC[a>_4jlB[]>_0@0000;C[]>
_4jkC[a>^djlC[]>_4jkC[`00008Ool3000VOol3000EOol003aoo`03001oogoo01Yoo`<002aoo`0]
001^mW<GK_Ic5fkfLaM^mW<GK_H006kfLaL006/HJ_Q[66[hJaP006/HJ_Q[66[hJaQZn6/HJ_Q[66[h
JaP006<KG_YS6ekjHa]NnV<KG_YS6ekjHa]NnV<K0080000/C]]Bg4kKD]a>fe;LC]]Bg4kK0016W4Jm
@Ya6_DJLA[e2W4JmAY`003jL@[dnW4:M?Ya2_CjL@Yd004:m@Ya2WD:L@[e2W4:M@Ya2_@00A[e2W4Jm
@Ya6_@L0000QB[a6VdZlAYa:_4JKB[`004ZlBY]:_4ZKB[a:VdZlBY]:_4ZK001:^djlBY]>_4ZkC[`0
04jlB[]>_000C[a:^djl00D0000?C[a:^djl001>g4jkC[a:^dkLC[]>_4ZkC]a>^`0000]oo`03001o
ogoo02=oo`04001oogoo000DOol003Qoo`05001oogooOol0000JOol2000^Ool01@00KaI_5VlFLaH0
0flF00Ec5VlF001_5W<F009_5P05001[66/HJaP0000;JaP00`00JaP0000:G_X2000015kj001Bg4kL
0e;L00E>g5;LD]aBg0000096_005A[e6_4JlA[a6_@02A[`02P00@Ye2W4:M@Ya2WD:L@Ye2W0000d:L
00=2WD:L@Y`02@001DJL00/004JlAYa:_4JLA[a6W4ZlAYa6_00000Y:_003001:_4jl00=:_004001:
_4ZlB[`400005DjlB[]>_4jkC[a:^djlC[/004jkC[a>^djlC[]>_4jkC[a>^djlC[/0000:Ool00`00
Oomoo`0SOol00`00Oomoo`0EOol003Uoo`<001Qoo`<0031oo`12001c5fkfLaM^mW<GK_Ic5fkf001^
mW<GK_Ic5fkf001Zn6/HJ_P006[hJaQZn6/HJ_Q[66[hJaQZn6/H001[66[hJaP006<KG_YS6ekjHa]N
nV<KG_X005kjHa]NnV<K001Bg4kKD]a>fe;LC]]Bg4kKD]`004JmAYa6_D:LA[e6W4Jm4@0002U2WD:L
@Ye2W4:M0016_4:LA[a2W4Jl@Ya6_4:L0016VdZlAYa:_4JKB[a6W4ZlAY]:_000B[a:VdZlBY]:_4ZK
B[a:VdZl001>_4ZkC[a:Vdjl00@0000IBY]>_000C[a:^djlBY]>_4ZkC[a:VdjlB[/004ZkC]a>^djl
B[]>g4jkC[a:^dkL00002goo00<007ooOol08Woo00<007ooOol05Goo001BOol2000bOol01000KaI_
5W<F0flF00Ec5VlFKaH007<F00=_5P05LaI_5P00JaP0000:JaP00`00JaQ[6003JaP00`00G_YNnP03
G_X20006G_X00`00D]a>g003D]`014kLD]aBg0000dJl100000E6_4JLA[`004:M00=2W005@Ye2W4:L
@Y`00009@Y`00`00AYa6W007AY`02`00AYa6_4JLB[a6W4JlAYa:_4JL00002TZl00<004Zl00000`00
00=:_4jlB[/00TZl01P004ZkC[a>^djlB[]>_4jkC[a:^djl001>_4jkC[a>^djlC[]>_4jkC[a>^djl
000;Ool00`00Oomoo`0ROol00`00Oomoo`0DOol004ioo`@003Aoo`0k001^mW<GK_Ic5fkfLaM^mW<G
001c5fkfLaM^mW<GK_Ic5fkf001Zn6/HJ_Q[66[hJaQZn6/HJ_Q[6000JaQZn6/HI_Q[66[h001NnV<K
G_YS6`00Ha]NnV<KG_YS6ekjHa]NnP00C]]Bg4kKD]a>fe;LC]]Bg0040000=d:LA[e2W4Jm@Ya6_D:L
000nW4:M?Wa2WCjL@YdnO4:M0012WD:L@Ye2W4:M@Ya2WD:L@Ye2W000@Ya6_4:LA[a2W4Jl@Ya6_4:L
0016VdZlAYa:_4JKB[a6W4ZlAY/004ZKB[a:VdZlBY]:_4ZK00@0000NC[a:Vdjl001>_4ZKC[a:Vdjl
BY/004ZKC[a:^djlBY]>_4ZkC[a:Vdjl001>_4ZkC]a>^djlB[]>g4jk0`002goo00<007ooOol087oo
1@0057oo001=Ool3000eOol00`00KaIc5P03KaH01G<FKaI_5P00LaH00flF00Mc5VlFKaI_5P00K_H0
0008JaP00`00JaQ[6006JaP01000G_X000002Ukj00@005;LD]a>g0@0000?D]a>g000AYa6_4JLA[a6
W4JlAYa6_4JL0012W4:M00=2W004@Ye2W4:L0009@Y`00`00AYa6W008AY`02P00AYa6_4JLB[a6W4Jl
AYa:_0000dZl100000E:VdZlB[`004Zk009:_006001:^dZlB[a>_4Zk0TZl00h004ZkC[a>^djlB[]>
_4jkC[a:^`00C[]>_4jk1@0000A>^djlC[/000]oo`03001oogoo03Qoo`00BWoo0`00>7oo03D007<G
K_Ic5fkfLaM^mW<GK_H006kfLaM^mW<GK_Ic5fkfLaL007<GK_H006[hJaQZn6/HJ_Q[66[h001Zn6/H
I_Q[66[hJaQVn6/HJ_P005kjHa]NnV<KG_YS6ekjHa]NnV<KG_YS6ekj00<0000dC[]Bg4jkD]a>^e;L
C[/004:LA[e2W4Jm@Ya6_D:LA[e2W000?Ya2WCil@YdnW4:M?Wa2W@00@Ye2W4:M@Ya2WD:L@Ye2W4:M
0016_4:LA[a2W4Jl@Ya6_4:LA[`004ZlAY]:_4JLB[`700007DZlBY]:_4ZKB[a:VdZl001>_4ZKC[`0
04jlBY]>_4ZKC[a:Vdjl001>_4ZKC[a:^djlBY]>_4ZkC[`0100000U>^dkLC[]>_4jkC]a>^djl0000
2Woo0`002Goo1000;7oo0018Ool2000jOol00`00LaI_5P02KaH01G<FKaI_5VlF00000flF00Ic5VlF
KaI_5W<F0002KaH00g<FK_H00005JaP00`00JaQ[6007JaP00`00JaP0000:G_X2000065kj001>g5;L
C]aBg4kLD]a>g5;LC]`004JLA[a6W4JlAYa6_4JLA[a6W000@Ya2W@=2W004@Ye2W4:L0008@Y`00`00
AYa6W004AY`900001TZlAYa6W4JLB[`000=:_00=BY]:_4ZlB[a:VdZl001>_4ZkB[`004jlB[/00TZl
00U>_4ZkB[`004jlB[]>_4jkC[`00`0000i>_4jk001>^djlC[]>_4jkC[a>^djlC[]>_0002goo00<0
07ooOol01Woo00<007ooOol00Woo00<007ooOol0:Goo0015Ool3000kOol0=P00LaH007<GK_Ic5fkf
LaM^mP00K_Ic5fkfLaM^mW<GK_Ic5fkf001^mW<GK_Ic5fkf001Zn6/HJ_P006[hJaQVn6/HJ_Q[66Kh
JaQZn000I_Q[66[h001NnV<KG_YS6ekjHa]NnV<K001Rn`9NnP0S001Bg4jkD]a>^e;LC[]Bg4jkD]`0
04Jm@Ya6_D:LA[e2W4Jm@Ya6_@00@YdnW4:M?Wa2WCjL@YdnO000@Ya2WD:L@Ye2W00:00009dJL@Ya6
W4:KAY`004ZlAY]:_4JKB[a6VdZlAY/004ZKB[a:VdZlBY]:_4ZKB[a:VdZl001>_4ZK001:VdjlBY]>
_4ZKC[a:V`00B[]>_00300004DjlBY]>_4ZkC[`004kLC[]>_4jkC]a>^djlC[]>g4jk000037oo00<0
07ooOol01Goo00<007ooOol00Woo00<007ooOol0:Goo0012Ool3000nOol01@00L_Ec5@00LaH00flF
00Ec5P00KaI_5W<F00=_5P06LaI_5P00KaIc5Vkf0VlF00Ec5Vkf001[600000U[6004001[66/HJ_P2
JaP00`00G_YNnP03G_X20005G_X04000D]a>g5;LC]aBg4kLD]a>g5;L0016_4JLA[a6W4Jl4P001D:L
00<004JLAY`01dJL00<004JLB[`00dJL00I:_4JLAYa6W000BY/3B[`02DZKB[a:_4ZlBY]:_000C[`0
0002B[`014jlB[]:_4Zl100001E>_4jkC[a>^djlC[]>_4jkC[`004jlC[]>_4jkC[a>^djlC[]>_4jk
000037oo00<007ooOol017oo00<007ooOol00Woo00<007ooOol0:Goo0010Ool4000nOol0=@00L_Ec
5VkeLaH007<GK_Ic5`00LaM^mW<GK_Ic5fkfLaM^mP00K_Ic5fkfLaM^mW<GK_Ic5fkf001Zn6/HI_Q[
66[hJaQVn6/HJ_P006KhJaQZn6/HI_Q[6000Ha]NnV<KG_X005kjH_/00ekj00aRnekjG_X005;LC[]B
g4jkD]a>^e;LC[/60000>TJl@Ya6_4:LA[`004:M?Wa2W3il@YdnO4:L?W`0049l@Ya2O4:L@Wa2W49l
@Y`004JL@Y]6W4:LAYa2VdJL@Ya6W4:K0016VdZlAY]:_4JKB[a6VdZlAY/004ZKB[a:VdZlBY]:_4ZK
B[a:V`00BY/004ZK1@0001U:VdjlBY/004ZkC[a:VdjlB[]>_4ZKC[a:^djl001>g4jkC[a>^dkLC[]>
_4jkC]`0000<Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`0YOol003ioo`8000=oo`03
001oogoo03aoo`09001c5G;eLaIbm@00KaIc5P00009_5P05LaI_5VlFKaIc5P02KaH00`00LaI^mP02
KaH01g<FK_I_5VlF001^mP0000M[6004001[66/HJ_P3JaP016[hJaP005kj0P002Ukj00H005;LC]aB
g4kLD]`200000djkC]`00008AY`00`00@Wa2W002@Y`01D9l@Ya2W4:L00002D:L00<004JLAY`01dJL
00@004JLAYa:_0=6W006B[a6W4JLAY`004ZK0dZl00=:VdZlB[`01@0001e:VdZlB[]>_4ZKB[a:^djl
001>_4jkC[a>^djlC[]>_4jkC[a>^`00C[]>_4jkC[a>^djlC[]>_4jk008000aoo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo02Uoo`00>goo0`00@goo034007<FK_Ec5W;eLaI^m@00K_H006kf
LaM^mW<GK_Ic5fkfLaL007<GK_Ic5fkfLaM^mW<GK_Ic5`00LaM^mP00J_Q[66KhJaQZn6/H001[66[h
JaQVn6/HJ_Q[66KhJaP00002G_X01F;kG_YNnUkjH_/00ekj00ERnekj001>^e;L00<0000iD]a>^e;L
C[/004:LA[a2W4Jl@Ya6_4:LA[a2W000?Wa2WCil@Y`nO4:M?Wa2W000@Ya2O4:L@Wa2W49l@Ya2O4:L
0016W4:KAYa2W4JL@Y]6W4:LAY`004ZlAY]:_4JKB[a6VdZlAY]:_000B[a:VdZl00@0000OBY]:_4ZK
001:VdjlBY]>_4ZKC[a:VdjlBY]>_000C[a:^djlBY]>_4ZkC[a:VdjlB[/004jkC]a>^djlC[/00`00
00=>^e;L000037oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0:Goo000hOol30016Ool0
2`00L_Ec5W;eLaEbmG<FL_D006lFLaH00flF00Ic5VlFKaI_5P00K_H2KaH01W<FK_I_5VlFLaH000=_
5P03K_H006/H00=[6003001[66[h00=[6007J_Q[66/HJaP006/H000035kj0P0000U>g4jlD]a>^dkL
C[aBg4jk00002DJL00<0049l@Y`00T:L00E2O4:L@Ya2W00000U2W0030016W4JL00I6W0050016W4JL
AYa:_002AY`7000084ZLBY]:_4ZKBYa:VdZl001:_4ZkC[a:VdZlB[]>_4ZKB[a:^`00C[]>_4jkC[a>
^djlC[]>_4jkC[`004jlC[/300001TjkC[a>^djlC[/000Yoo`<000Eoo`@002aoo`00=Woo0P00B7oo
03<006keLaIbmG<FK_Ec5W;e001^m@00K_Ic5fkfLaM^mW<GK_H006kfLaM^mW<GK_Ic5fkfLaL007<G
K_Ic5fkfLaL006/HJ_Q[6000JaQZn6/HI_Q[66[hJaQVn6/H001[66Kh00000ekj00ERnekjG_YNnV;k
009NnP80000]G_X004jkD]a>^e;LC[]Bg4jkD]a>^`00@Ya6_4:LA[a2W4Jl@Ya6_4:L000nO4:M?Wa2
W3il@YdnO4:L0012W49l@Ya2O4:L@Wa2W49l0012W4JL@Y]6W4:L00X0000>B[a6VdZLAY]:_000B[a:
VdZlBY]:_4ZKB[a:V`80000CC[a:VdjlBY]>_4ZKC[a:VdjlBY/004ZKC[a:^djlBY]>_4ZkC[`01000
00Y>^e;LC[]>g4jkD]a>^dkLC[/000aoo`03001oogoo039oo`00<goo0`0000=oo`00Ool0AWoo00l0
07;eLaIbmG<EL_Ec5W;eLaD007<FL_D006lFLaH00flF00H006kfKaI_5W<FK_H2KaH00g<FK_H00002
KaH02FkfKaI_5VlF001[6000JaQZn003JaP01V[hJaQ[66/HJ_P0009[6003J_P005kj00MNnP0@001N
nUkjG_X005;LC[]>g4jlD]a>^dkLC[aBg4jk0008AY`00`00@Ya2O003@Y`0149l@Ya2W0001D:L2@00
1DJL00H004JKAYa6W4ZLAY/2AY`02TZLAY/004ZKB[a:VdZLBY]:_4ZK0`0000i:VdZlB[]>_4ZKB[a:
^djlBY]:_000C[a>^djl1@0000i>_4jkC[`004jlC[]>_4jkC[a>^djlC[]>_0003Goo00<007ooOol0
<Goo000aOol2001<Ool0=P00LaIbmG<FK_Ec5W;eLaH007<FL_Ec5Vke001^mW<GK_Ic5`00LaM^mW<G
K_Ic5fkfLaM^mP00K_Ic5fkfLaM^mW<GK_Ic5`00JaQZn6/HI_Q[66[hJaQVn6/HJ_P006KhJaQVn6/H
I_P000=NnP05H_]NnP00001Nn`02G_X04U[JG_/005;LC[]Bg4jkD]a>^e;LC[]Bg000A[a2W4Jl@Ya6
_180000M@W]2W49k@Ya2N`00@W]6W49kAYa2NdJL@W]6W000BYa6VdZlAY]:W4JKB[a6VdZLAY/004ZK
B[a:V`03000034ZKB[`00000BY]>_4ZKC[a:VdjlBY]>_0D0000DC[a>^djlB[]>_4jkC[a:^`00C[]>
g4jkD]a>^dkLC[]Bg4jkC]`000aoo`03001oogoo035oo`00;Woo0`00CGoo01<007<FL_Ec5G;eLaIb
mG<EL_D007;eLaEbmG<FL_D006lFLaH00002KaH01g<FK_I_5VlFLaI^mP00009_5P09K_I_5VlFKaI^
mVlF001_5`0000=[6006J_Q[66/HJaQZn0000V/H00IZn6/HJaQ[66[h0003G_X00`00G_YNnP06G_X0
2000D]a>^dkLC[aBg4jkC]`70003AY`01D:LAY`004:L?W`00T9l00i2W3il@Wa2O000@Wa2W49l@Ya2
O4:L@Wa2W0002DJL00<004ZLAY/00TJL00E:W4JKAYa6W4ZL00@00005BY]:W4ZKB[a:V`0200000djl
BY]:_00500006DjlB[]>_000C[a>^djlC[]>_4jkC[a>^djlC[/004jkC[a>^djlC[]>_4jkC[a>^`00
00eoo`03001oogoo031oo`00;7oo0P00D7oo03T007;eLaI^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaI^
m@00K_H006kfLaM^mW<GK_Ic5fkfLaL007<GK_Ic5fkfLaM^mW<GK_H006kf001Vn6/HJ_Q[66KhJaQZ
n000I_Q[66KhJaQVn6/HI_Q[6000H_/00P0000IJfUkkG_YNnU[JG_/2G_X01E[J001>^e;LC[/01000
031Bg4jkD]`004JL@Ya6W49kAYa2W4JL@W/003il@Y`nNd:L?Wa2W3ik@Y`004:L@W]2W49k@Ya2Nd:L
@W]2W000AYa2NdJL@W]6W49kAYa2NdJL001:W4JKB[a6VdZLAY/400001dZlBY]:_4ZKB[a:VdZl00D0
000MC[a:VdjlBY]>_4ZKC[a:V`00C[]>_4ZkC[a>^djlB[]>_4jkC[`005;LC[]>g4jkD]a>^dkLC[]B
g002000=Ool00`00Oomoo`0_Ool002Yoo`80055oo`0F001bmG<EL_Ec5W;eLaEbmG<F001c5G;eLaIb
mG<EL_Ec5W;e001_5W<FK_H2KaH01W<FK_I_5P00KaI^mP=_5P05K_I_5VlF001^mP02KaH00`00J_Q[
6002JaP01F[h001[66/HJ_P00f/H00EZn6/HJaQ[600000aNnP<000=>^`06C[a>^djkC[/004:L0dJL
00U2W4JLAYa6W4:L0012O4:L?W`00T9l00i2W3il@W`004:L@Wa2W49l@Ya2O4:L@Wa2W0002DJL00@0
04ZLAY]6W0800007AY]6W4JL001:VdZLBY/0100001m:_4ZK000004jlB[]>_4ZkC[a:^djlB[]>_4Zk
001>^djlC[]>_4jkC[a>^djlC[]>_000C[a>^djlC[]>_00300000dkLC[`0000<Ool00`00Oomoo`0_
Ool002Yoo`80051oo`0m001bmG<FK_Ec5W;eLaI^mG<F001c5VkeLaIbmG<FK_Ec5W;e001^m@00K_Ic
5fkfLaM^mW<G001c5fkfLaM^mW<GK_Ic5fkfLaL007<GK_Ic5fkf001Vn6/HJ_P006KhJaQVn6/HI_Q[
66KhJaQVn6/H001[6000G_/00Ukj03UJfUkkG_YNnU[JG_]NnP00F]X004jkD]a>^e;LC[]Bg4jkD]a>
^`00@W]6W4:LAYa2NdJL@Ya6W49k000nO4:L?W]2W3il@Y`nN`00@W]2W49k@Ya2Nd:L@W]2W49k@Y`0
04JL@W]6W49kAYa2NdJL@W/0100000=:_4JK00001P00021:VdZlBY]>_4ZKB[a:V`00BY]>_4ZKC[a:
VdjlBY]>_4ZKC[`004jlC[]>_4ZkC[a>^djlB[]>_4jk001>^e;L0`0000MBg4jkD]a>^e;LC[/0000:
Ool3000`Ool002Yoo`03001oo`0004moo`0I001c5G;eLaIbmG<EL_Ec5W;e001bmG<FL_Ec5G;eLaIb
mG<E001c5W;e001_5W<FK_H00VlF00<006kfKaH00VlF00E^mVlFKaI_5P00009_5P0:KaM^mVlFKaH0
06[hJaP006/HJ_P3JaP02F[hJaQ[66/H001[66[hJaP00007G_X20002G_X01000C[]>^djl0djk00I>
_4jkC[]>^`00@Y`3AY`02D:LAYa6W4JL@Y`0049l@Y`nO002@W`03D:L?W`0049l@Ya2O4:L@Wa2W49l
@Ya2O00000E6W0T0000>AY]:W4JKBYa6V`00BY]:W4ZKB[a:VdZLBY]:_080000CB[]>_4ZkC[a:^djl
B[]>_4ZkC[`004jlC[]>_4jkC[a>^djlC[/0100000]>g4jlC]a>_4kLC[a>g4jlC]a>_00000aoo`03
001oogoo02eoo`00:Woo00@007ooOol004eoo`10001c5VkeLaIbmG<FK_Ec5W;e001^mG<FL_Ec5Vke
LaIbmG<F001c5W;eLaI^m@00K_Ic5fkf001^mW<GK_Ic5fkfLaM^mW<G001c5fkfLaM^mW<GK_Ic5`00
JaP006/HI_Q[66KhJaQVn6/HI_Q[6000JaQVn6/HI_Q[6000G_/2G_X0:e[JG_/005kjF]YNnU[JG_X0
05;LC[]Bg4jkD]a>^e;LC[]Bg4jk0012NdJL@Ya6W49kAYa2W4JL0012W3il@Y`nNd:L?Wa2W000@Ya2
Nd:L@W]2W49k00X0000GAYa2NdJL@W/004JKBYa6VdZLAY]:W4JKBY`004ZlBY]>_4ZKB[a:VdjlBY]:
_00200003DZKC[a:VdjlBY]>_4ZKC[a:V`00B[]>_4jk00D0000?C[]>g4jk001>^e;LC[]Bg4jkD]a>
^e;LC[]Bg00000aoo`03001oogoo02eoo`00:Goo00<007ooOol00Woo00<007ooOol0BWoo01P007;e
LaIbmG<EL_Ec5W;eLaD007<FL_Ec5G;eLaIbmG<EL_D007;eLaEbmG<F0002KaH00`00K_I_5P02KaH0
2FkfKaI_5VlFK_H006lFKaM^mP02KaH01VlGK_I_5P00JaQZn0=[600<J_Q[66/HJaP006/HJ_Q[66[h
JaQZn00015kj00D005kjG_YNnUkJ00=NnP04001>^djkC[`3C[/01TjlC[]>^`00AYa2W0=6W1800092
O003@W]2O0000080000KAYa6VdJLAW]6W4JKAY`004ZLAY]:W4JKBYa6VdZLAY]:W000B[a:VdZLBY]:
_4ZKBYa:VdZl00800007B[]>_4ZkC[a:^djlB[/01@000Tjl01=>^djlC[a>_4jkC[`004kLC[a>g4jl
C]a>_4kLC[a>g4jlC]`0000<Ool00`00Oomoo`0/Ool002Uoo`8000Aoo`03001oogoo04Qoo`12001^
mG<FL_Ec5VkeLaIbmG<F001c5W;eLaI^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaH007<G001c5fkfLaM^
mW<GK_Ic5fkf001^mW<GK_Ic5fkfLaM^mW<G001c5`00JaQVn6/HI_Q[66KhJaP006/HI_Q[66KhJaQV
n6/HI_P005[J0P00015NnU[JG_YJfUkjF]YNnU[JG_X005;LC[]Bg4jkD]a>^e;L00L0000CAYa2NdJL
@W]6W000@Y`nNd9l?W]2W3ik@W`004:L@W]2W49k@Y`00`0002=2W000AYa2NdJL@W]6W49kAYa2NdJL
001:W4JKBYa6VdZLAY]:W4JK001:VdZlBY]>_4ZKB[a:VdjlBY]:_000C[a:Vdjl00@0000IBY]>_4Zk
001>^dkLC[]>g4jkC]a>^dkLC[]>g000D]a>^e;LC[]Bg4jkD]a>^e;LC[/00P002goo00<007ooOol0
;7oo000YOol00`00Oomoo`04Ool00`00Oomoo`17Ool06`00LaIbmG<EL_Ec5W;eLaEbm@00L_Ec5G;e
LaIbmG<EL_Ec5P00LaEbmG<FL_Ec5G;eLaH00003KaH02FkfKaI_5VlFK_I_5P00KaM^mP02KaH02VlG
K_I_5VlF001^mVlF001[66[h0f/H00eZn000J_Q[66[hJaQZn6/HJ_Q[66[h001NfP03G_X01EkJG_YN
nUkjG]X00Ukj00@004jkC[]>^`@000=>^`0;0016W49kAYa2W4JL@W]6W4:L000nN`03@W`01Sik@Wa2
O000@W]2O0<000=2O00N@W]2O000AYa6NdJLAY]6W4IkAYa6V`00AY]:W4JKBYa6VdZLAY]:W4JK001:
VdZlBY]:W4ZKB[a:VdZL1@0000Y>_4ZkC[a>^djlB[]>_000C[a>^`=>_00=C[]>_4jlC[a>^djl001>
g4jlC]a>_4kLC[`00`0000=>g5;L00002goo00<007ooOol0:goo000YOol00`00Oomoo`05Ool20016
Ool06`00LaIbmG<FK_Ec5W;eLaI^m@00L_Ec5VkeLaIbmG<FK_Ec5P00LaI^mG<FL_Ec5VkeLaIbm@02
0000<W<GK_Ic5fkfLaM^mW<G001c5fkfLaM^mW<GK_Ic5fkf001^mW<GK_Ic5`00JaQVn6/HI_P006Kh
JaQVn6/HI_Q[66KhJaQVn000I_P005[JG_YJfUkjF]YNnU[JG_YJfUkjF]X3000064jkC[a>Ve:lC[]>
_4jK0012NdJL@W]6W49kAYa2NdJL@W/003ik@Y`nNd9l?W]2W0<0000O@Ya2Nd:L@W]2W49k@Ya2N`00
@W]6W49kAYa2NdJL@W]6W49k0016VdZLAY]:W4JKBYa6VdZL001>_4ZKB[`01@0001]>_4ZK000004jl
B[]>_4ZKC[a:^djlBY]>_000C]a>^dkLC[]>g4jkC]a>^dkLC[/004jkD]`0100000I>fe;LC]aBg4kK
000<Ool00`00Oomoo`0ZOol002Uoo`03001oogoo00Moo`03001oogoo049oo`0O001c5P00LaEbmG<F
L_Ec5G;eLaH007<EL_Ec5W;eLaEbmG<FL_D007;eLaIbmG<EL_Ec5W;e001bmG<F00000flF00E^mVlF
001_5fkf009_5P06KaM^mVlFKaH006kf0VlF00=_5fkf00000V/H015Zn000J_Q[66[hJaQZn6/HJ_Q[
66[h001Vn6[h001NnUkJ00=NnP04G]YNnUkjG_X200000e[J001>^`08C[/03000@Ya6W49kAYa2W4JL
@W]6W000@W`nN`92O0800092O0030012Nd9l0092O00D@W]2O49l@Wa2N`00AY]6W4IkAYa6VdJLAW]6
W000BYa6VdZLAY]:W0L0000CB[a:VdZlBY]:_4ZKB[a:V`00B[]>_4jkC[a:^djlC[]>_4Zk00000Tjl
00E>^djlC[a>_4jk00=>_0<0000;D]a>g5;LC]aBg4kLD]a>g5;LC]`0000:Ool2000/Ool002Uoo`03
001oogoo00Qoo`03001oogoo045oo`1<001bmG<F001c5W;eLaI^mG<F001c5VkeLaIbmG<FK_Ec5W;e
001^mG<FL_Ec5VkeLaIbmG<F001c5W;eLaH007<GK_Ic5fkf001^mW<GK_Ic5fkfLaM^mW<G001c5fkf
LaM^mW<GK_H006Kh001Vn6/HI_Q[66KhJaQVn6/HI_P006KhJaQVn6/H001NnU[JG_YJfUkjF]X20000
5ekjF]YNnP00C[a>Ve:lC[]>_4jKD[a>^djl0016W49kAYa2NdJL@W]6W49kAY`0100001@nNd9l?W]2
W3ik0012Nd:L@W]2W49k@Ya2Nd:L0016W49kAYa2NdJL2@0000m:W4JKB[a6VdZL001>_4ZKC[a:Vdjl
BY]>_4ZKC[`00P00011:VdjlB[]>_4ZKC[a:^djlBY/004jkC]a>^dkLC[]>g0<0000>D]a>^`00C]aB
g4kKD]a>g5;LC]]Bg4kLD]`000aoo`03001oogoo02Uoo`00:7oo00<007ooOol02Woo00<007ooOol0
?goo028007;eLaEc5G<F001c5G;eLaIbm@00L_Ec5W;eLaEbmG<FL_Ec5@00LaIbmG<EL_Ec5W;eLaD0
07<FL_Ec5G;eLaH0009_5P06001^mVlFKaI_5fkf0VlF00I_5`00KaI_5VlGK_H2KaH05flGK_H006[h
JaQZn6/HJ_Q[66[hJaQZn000I_QZn6KhJ_QVn6[h001NnUkJG_X00P0000MJfUkJF]YNnU[JG]X00009
C[/01`00AYa2W4JL@W]6W4:L00<00092O009?W]2O49l@W`nNd9l0012O49k00=2O0T0000TAYa6VdJL
AW]6W000BYa6VdZLBY]:W4JKBYa:V`00BY]:_4ZKB[a:VdZlBY]:_4ZKB[`004jlB[]>_4jkC[a:^djl
C[]>_0000Tjl100000=>g4jlC]`00TkL00d005;LC]aBg4kLD]a>g5;LC]aBg4kLD]`0000<Ool00`00
Oomoo`0XOol002Qoo`8000aoo`03001oogoo03ioo`19001c5VkeLaIbmG<F001c5W;e001^mG<FL_Ec
5VkeLaIbmG<F001c5W;eLaI^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaH007<G001c5fkfLaM^mW<GK_Ic
5`00LaM^mW<GK_Ic5fkfLaM^mP00K_H006KhJaQVn6/HI_Q[66Kh001Vn6/HI_Q[66KhJaQVn000F]X0
0P0001INnU[JG_YJfUkjF]YNnU[JG_X004jlCY]B_4jkC[a>Ve:lC[/0049kAYa2Na@0000[@Wa2NdJL
@W]2O000AYa6NdJL@W]6W4IkAYa2N`00AY]:W4JKB[a6VdZLAY]:_4JK001:VdjlBY]>_4ZKC[a:Vdjl
BY]>_000C[a:VdjlB[]>_4ZKC[`0100001I>^e;LC[]Bg4jkD]a>^e;LC[]Bg000D]a>g5;LC]]Bg4kL
D]a>fe;LC]`000aoo`03001oogoo02Qoo`00:7oo00<007ooOol037oo00<007ooOol0?7oo00D007<E
LaEc5W;e009c5@0NLaH007<E001c5W;eLaEbmG<FL_Ec5G;e001bmG<EL_Ec5W;eLaEbm@00L_Ec5G;e
LaIbmG<EL_Ec5P000VlF00Y_5fkfKaI_5VlGK_H006lFKaM^mP9_5P0TKaM^mVlF001_5fkf001Zn6/H
J_Q[66[hJaP006[hI_QZn6KhJ_QVn6[hI_P005[JG_YJfUkJF]YNnU[JG]YJfUkjF]YNfP001djk1P00
03E2NdIl@W]6O49k0012Nd9l@W]2O49k@Wa2Nd9l0012O49k@Wa2Nd9l@W]2O49k0016NdJLAY]6W4Ik
AYa6VdJLAW/004ZKBYa6VdZLBY]:W4JKBYa:V`00BY]:_4ZKB[a:VdZlBY]:_4ZK00800003C[a:^`00
00<000=>_005001>g4kLC]a>_003C]`03TjlC]a>g000C]aBg4kLD]a>g5;LC]aBg4kLD]`2000<Ool0
0`00Oomoo`0WOol002Qoo`03001oogoo00eoo`03001oogoo03]oo`1J001^mG<FL_Ec5VkeLaIbmG<F
001c5W;eLaI^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaI^mG<F001c5VkeLaIbmG<FK_Ec5P00LaH007<G
K_Ic5fkfLaM^mP00K_Ic5fkfLaM^mW<GK_Ic5`00LaM^mVlGK_H006KhJaQVn6/H001[66KhJaQVn6/H
I_Q[66Kh001Vn000F]YNnU[JG_YJfUkjF]YNnU[JG_YJfP00C[]>_4jK1@0003U>V`00@W]6W49kAYa2
NdJL@W]6W000@W`nNd9l?U]2O3ik@W`nF`00@W]2O49kAYa2Nd9l@W]6W49k0012NdJLAW]6W49kAYa6
NdJL@W/004JKBYa6VdZlAY]:W4JKB[a6V`00BY]>_4ZKC[a:VdjlBY/01@0001Y:^dkLC[]>g4ZkC]a>
^dkL001Bg4jkD]a>^e;LC[]Bg4jkD]a>^`00C]]Bg4kLD]a>fe;L0`0000=Bo4kL000037oo00<007oo
Ool09Woo000XOol00`00Oomoo`0>Ool00`00Oomoo`0iOol01000LaEc5W;e0W<E029c5W;eLaD007<F
001c5G;eLaIbmG<EL_Ec5P00LaEbmG<FL_Ec5G;eLaH007<EL_Ec5W;eLaEbmG<FL_D007;eLaH0009_
5P06KaM^mVlF001_5fkf0VlF02I_5fkfKaH006lGK_I_5VkfKaL006/HJ_Q[6000J_QVn6[hI_QZn6Kh
J_QVn000I_QZn000G]YJfUkjF]YNfU[JG_YJfUkJF]YNnU[J1@0003Q>VdjkCY]>^`00AWa2NdIl@W]6
O49kAWa2NdIl0012O49k@Wa2Nd9l@W]2O49k0012Nd9l@W]2O49k@Wa2Nd9l@W/004IkAYa6VdJLAW]6
W4JKAY`004ZLBY]:W4JKBYa:VdZLAY]:W000B[a:VdZl100000A:^djlB[/0009>_005C[]>_4jlC[a>
^`03C[`01@00C]a>g4kLC[`00dkL00E>_4kL001Bg4kL00@000=Bg003C]aBg00000]oo`8002Qoo`00
:7oo00<007ooOol03goo00<007ooOol0>7oo05H007<FL_Ec5VkeLaIbmG<FK_D007;eLaH007<FL_Ec
5VkeLaH007<FK_Ec5W;eLaI^mG<FL_D006keLaIbmG<FK_Ec5W;e001^mG<FL_Ec5P00LaM^mW<G001c
5fkfLaM^mW<GK_Ic5fkf001^mVlGK_Ic5fkfKaL006/H001[66KhJaQVn6/HI_Q[66KhJaP006/HI_QZ
n000G_YJfUkjF]YNnU[JG_YJfUkj100003I>VdjkBY]>^djKC[]:Vdjk0016W49kAYa2NdJL@W]6W49k
AY`0049l?W]2O3iK@W`nNd9l?U/0049k@Wa2NdJL@W]2O49kAY`004JL@W]6W4IkAYa2NdJLAW]6W000
B[a6VdZLAY]:_4JKBY`500001djlBY]>_4ZKC[a:Vdjl0080000BC[]>g4ZkC]a>^dkLB[]>g4jk001>
^e;LC[]Bg4jkD]a>^e;L100000]>g5;lC]aBo4kLD_a>g5;lC]aBo00000aoo`03001oogoo02Eoo`00
9goo00<007ooOol04Goo00<007ooOol0=Woo00<007<FL_D00W<E00Ic5W;eLaEc5@00L_D2LaD08W<F
001c5G;eLaIbm@00L_Ec5W;eLaEbmG<FL_D007;eLaIbmG<EL_Ec5W;eLaD007<FL_Ec5G;e001^mVlF
001_5fkf0VlF01U_5fkfKaI_5P00K_I_5VkfKaM^mVlFK_I_5`00J_QVn6[hI_QZn6KhJ_QVn6[h001Z
n003I_P026[h001NfU[JG_YJfUkJF]X30002F]X0<`00C[]>VdjkCY]>^djKC[]>Vdjk0016O49kAWa2
NdIl@W]6O49kAW`0049l@W]2O49k@Wa2Nd9l@W/0049k@Wa2Nd9l@W]2O49k@W`004JLAW]6W4JKAYa6
NdJLAY/004JKBYa:V`0400003TZLBY]:W000C[a:^djlB[]>_4ZkC[a:^djl0003C[`01DjkC[a>_4jl
C[/00Tjl00@004jlC]a>g0@00006D]a>g5;L001Bg4kL0e;L00I>g5;LD]aBg4kL000=Ool00`00Oomo
o`0TOol002Moo`8001=oo`03001oogoo03Eoo`1C001bmG<FK_Ec5W;eLaI^mG<F001c5VkeLaIbmG<F
001c5W;e001^mG<FL_Ec5VkeLaIbmG<F001c5W;eLaI^mG<FL_Ec5P00LaIbmG<FK_Ec5W;e001^mP00
K_Ic5fkfLaM^mW<GK_H006kfKaM^mW<GK_I_5fkfLaL006lG001[66KhJaQVn6/HI_Q[6000JaQVn6[h
I_Q[66KhJ_P005kjF]YNnP030000<5kJF]UNfU[JG]X004jkCY]>^dZKC[]>VdjkBY]>^`00AYa2NdJL
@W]6W49kAYa2N`00?U]2O3ik@W`nFd9l?W]2O000AYa2Nd9l@W]6W49k@Wa2N`00AW]6W49kAYa6N`L0
000ABY]:_4JKB[a:VdZlAY/004ZKC[a:VdjlBY]>_4ZKC[a:V`0200002DkLC[]>g4ZkC]a>^dkLB[]>
g004000054kLD]a>fe;LC]aBg4kK001>g5;lC]aBo4kLD_a>g5;lC]aBo4kL000<Ool00`00Oomoo`0T
Ool002Moo`03001oogoo01=oo`03001oogoo03=oo`06001bmG<ELaEc5W;e0W<E00Ic5P00LaEc5G<F
L_D2LaD07W<F001c5@00LaIbmG<EL_Ec5W;eLaD007<FL_Ec5G;eLaIbmG<EL_D007;eLaEbmG<FL_Ec
5G;e001^mP9_5P0IKaM^mVlFKaI_5`00KaI^mVlGK_I_5VkfKaM^mP00K_I_5`00J_QVn6[hI_QZn000
J_P00fKh00AZn6KhI_QVn0@000QJfP0@001>VdjkCY]>^djKC[]>VdjkCY/0049kAWa2NdIl@W/K0000
6DJKAYa6NdJLAY/004ZKBYa:VdZLBY]:W4ZKBYa:V`00B[]>_4ZkC[a:^djlB[]>_4Zk008000=>_003
C[]>_0000080009>g00;001>g5;LC]aBg4kLD]a>g5;LC]`00002D]`01DkLD]aBg5;LC]`00U;L0P00
3Goo00<007ooOol08goo000WOol00`00Oomoo`0DOol00`00Oomoo`0bOol0CP00LaI^mG<FL_Ec5Vke
LaIbm@00K_Ec5W;eLaI^mG<FL_Ec5P00LaIbmG<FK_Ec5W;eLaI^m@00L_Ec5VkeLaIbmG<FK_D007;e
LaI^mG<FL_Ec5Vke001^m@00K_Ic5fkfLaM^mW<G001_5fkfLaM^mVlGK_Ic5fkf001^mW<GK_I_5`00
JaQVn6/H001[66KhJ_QVn6/HI_QZn0@0000CF]UNfU[JG]YJfEkJF]YNfU[IG]YJfP00BY]>^djKC[]:
VdjkCY/01`0003I2NdIl@W]6W49k000nFd9l?U]2O3iK@W`nFd9l0016W49kAWa2NdJL@W]6O49k0016
NdJLAW]6W4IkAYa6NdJL001:_4JKB[a:VdZlAY]:_4ZKB[`004jlBY]>_4ZKC[a:VdjlBY]>_000C]`5
00005U;LC[a>g4jkD]`005;LC]]Bg4kLD]a>fe;LC]aBg4kK001>g5;lC]aBo4kL0`0000=>g5;l0000
3Goo00<007ooOol08Woo000WOol00`00Oomoo`0EOol00`00Oomoo`0`Ool01@00LaEc5G<FL_D00W<E
00Ic5W;e001c5G<FL_D2LaD08W<FL_Ec5@00LaH007<EL_Ec5W;eLaEbm@00L_Ec5G;eLaIbmG<EL_Ec
5P00LaEbmG<FL_Ec5G;eLaH007<EL_D006kf0VlF01E_5fkf001^mVlGK_I_5VkfKaM^mP00K_I_5fkf
KaI^mP00I_QZn6Kh00000fKh00UZn000000006[hI_P006Kh00002U[J00@004jkCY]>^`@000=>V`0;
0012NdIk@W]6Nd9kAW]2NdIk0012O003@W/01D9l@W]2Nd9k00000d9k0252O49k@W]2Nd9l0016W4JK
AYa6NdJLAY]6W4IkAY`004ZLBY]:W4ZKBYa:VdZLBY]:W000C[a:^djlB[]>_4ZkC[`0100000E>_4kL
C]a>g4jl00=>g00=C[a>g000D]a>g5;LC]aBg4kLD]a>g5;L00000U;L0`0000MBg5;lD]aBo5;LD_`0
000<Ool00`00Oomoo`08Ool5000EOol002Moo`03001oogoo01Ioo`80031oo`19001^mG<FL_Ec5Vke
LaIbmG<F001c5W;eLaI^mG<FL_Ec5Vke001bmG<F001c5W;eLaI^mG<F001c5VkeLaIbmG<FK_Ec5P00
LaI^mG<FL_Ec5VkeLaH007<FK_Ec5Vke001^mW<GK_H006kfLaM^mVlGK_Ic5fkfKaL007<GK_I_5fkf
LaM^mP00I_P006KhJ_P00`0001=Zn6KhJaQVn000I]QZn@00G]YJfEkJF]YNfU[IG]YJfUkJF]UNfP03
0000>TjkBY]>^dZJC[]:Vdjk0016W49kAWa2NdJL@W]6O49kAY`0049l?U]2O3iK@W`nFd9l?U/0049k
AYa2NdIl@W]6W49kAW`004JLAW]6W4IkAYa6NdJLAW]6W000B[a6VdZlBY]:_4JKB[a:V`00BY]>_4ZK
100000=>g4ZkC]`00P00019>^e;LC[a>g4jkD]a>_4kLC[]Bg000D]a>fe;LC]aBg4kKD]`400002TkL
D_a>g5;mC]aBo4kLD_e>g0002goo00<007oo00002goo00<007ooOol05Goo000WOol00`00Oomoo`0H
Ool00`00Oomoo`0/Ool01000LaEc5W;e0W<E00Ic5W;eLaD007<FL_D2LaD01W<FL_Ec5G<E001bm@9c
5@0`LaH007<EL_Ec5P00LaEbmG<FL_Ec5G;eLaIbm@00L_Ec5W;eLaEbmG<FL_D007;eLaIbmG<E001_
5fkf001^mVlGK_I_5VkfKaM^mVlF001_5fkfKaI^mVlGK_I_5Vkf100000MZn6KhI_QVn6[hI_P00004
I_P00`00F]YJfP06F]X200000e[J001>V`08CY/03000AW]2NdIk@W]6Nd9kAW]2N`00@W]2O0=2N`05
@Wa2Nd9k0012O003@W/0549l@W]2Nd9k0016NdJLAY]6W4IkAYa6VdJLAW/004ZKBYa:VdZLBY/70007
C[`01000C]`004jl0dkL00U>_4kLC]a>g4jl001>g5;LC]`010000U;L00eBo000D_aBg5;lD]aBo5;L
D_aBg5;lD]`0000=Ool00`00Oomoo`08Ool00`00Oomoo`0EOol002Ioo`<001Yoo`03001oogoo02]o
o`14001c5W;eLaI^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaI^mG<F001c5VkeLaIbmG<F001c5W;e001^
mG<FL_Ec5VkeLaIbm@00K_Ec5W;eLaI^mG<FL_D006keLaI^mG<FK_Ec5P00LaL007<GK_I_5fkfLaM^
mVlG001c5fkfKaM^mW<GK_I_5`@0000:I_Q[66KhJ_QVn6/HI_P006KHJ_T2I_P0>fKHJ_T005kJF]UN
fU[JG]YJf@00F[UJfUZi001:VdjkBYY>^dZKC[]:VTjkBY/0049kAYa2NdIl@W]6W49kAWa2N`00?U]2
O3iK@W`nFd9l?U]2O000AWa2NdJL@W]6O49kAYa2N`00AW]6W4IkAYa6NdJLAW/01`0001Y:VdZlBY]>
_4ZK001:^dkLB[]>g4ZkC]a:^dkLB[/004jl001>^e;LC[a>g4jkD]a>_4kL1000019>g5;lC]aBo4kL
D_a>g5;l001BoDkLD_a>g5;mC]aBo4kLD_d2000<Ool00`00Oomoo`08Ool00`00Oomoo`0EOol002Io
o`03001oogoo01]oo`03001oogoo02Uoo`03001c5W;e009c5@06LaIbmG<ELaD007;e0W<E00Ic5W;e
LaEc5G<F0002LaD01G<FL_Ec5G<ELaH00P0002MbmG<FL_Ec5G;eLaIbmG<E001c5W;eLaEbmG<FL_Ec
5@00LaIbmG<EL_Ec5W;eLaD006lGK_I_5VkfKaM^mVlFK_H006kfKaI^mVlGK_H00P0000E_5`00K_I^
mP0000=Vn004J_QVn6Kh0007I_P01000F]YJfU[J0P001E[J00<004jKCY/01djK00X0049kAW]2NdIk
@W]6Nd9kAW/00092N`09@Wa2Nd9k@W]2O49k0012Nd9l00=2N`07@Wa2Nd9k0016W4IkAY`0100000A6
VdZLAY/0009:_007BY]:_4ZlB[a:VdZl00002Tjl0P0000=>g4jlC]`00TkL0`0000IBg4kL001Bg5;l
C]`2D]`02e;lC]aBg5;L001Bg5;lD]aBo5;LD_`00`000U;l00<007ooOol02Woo00<007ooOol01goo
00<007ooOol05Goo000LOol40006Ool00`00Oomoo`0LOol00`00Oomoo`0XOol0@000L_Ec5VkeLaIb
mG<FK_Ec5P00LaI^mG<FL_Ec5VkeLaIbm@00K_Ec5W;eLaI^mG<FL_Ec5P00LaIbmG<FK_Ec5W;eLaH0
07<FL_Ec5VkeLaIbmG<F001c5VkeLaI^mG<FK_Ec5P00LaH006lGK_Ic5fkfKaM^mP00K_I_5fkf0`00
00i^mW<G001_5fkfKaM^mP00I_Q[66KhJ_P006[i0VKh00MVf6[iI_QVn6KH001JfP0200005ekJF[UJ
fUZiG]YJ^E[JF[T004ZKC[]:VTjkBY]>^dZJC[/004Il@W]6W49kAW`06@0001e:W4JKBYa6VdZLAY]:
W000C[a:VdZlBY]>_4ZKB[a:Vdjl001>g4ZkC]a:^dkLB[]>g4ZkC]`005;L00D0000CD]a>g5;LC]aB
g000D_a>g5;lC]aBo4kLD_a>g5;lC]`004kLD_d00`0000IBoE;LD_a>g5;m000=Ool00`00Oomoo`06
Ool00`00Oomoo`0EOol001]oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo01eoo`03001o
ogoo02Ioo`06001bmG<ELaEc5W;e0W<E00Ic5P00LaEc5G<FL_D2LaD01W<FL_D007<ELaIbm@9c5@0U
LaIbmG<E001c5P00LaEbmG<FL_Ec5G;e001bmG<EL_Ec5W;eLaEbm@00L_Ec5G;eLaIbmG<EL_D007;e
LaH006lGK_I_5VkfKaL0100000E^mVlFK_I_5`00009^mP05KaM^mVkf001Zn002I_P00`00I_QVn008
I_P00`00F]YJfP09F]X00`00CY]>V`05CY/600001TIk@W]6Nd9kAW/000Q2N`0D0012NdIl@W]6Nd9k
AWa2NdIk001:W4JKAYa6VdZLAY]6W4JKBY`000=:_007BY]:_4ZlB[a:VdZl00001djl1@0000EBg4kL
C]a>g5;L00=>g006D]`005;LD]aBo4kL0U;L00=Bo4kLD]`00`002E;l00<007ooOol02Woo00<007oo
Ool017oo0`005goo000KOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0NOol00`00Oomo
o`0TOol0?000K_H006keLaIbmG<FK_Ec5W;e001^mG<FL_Ec5VkeLaIbmG<F001c5W;eLaI^mG<FL_Ec
5Vke001bmG<F001c5W;eLaI^m@00L_Ec5VkeLaIbmG<FK_D006keLaI^mG<FK_Ec5Vke001^mG<FK_Ec
5P00KaM^mP<0000BK_Ic5fkfKaM^mW<GK_H006kfKaM^mVlGK_I_5`00J_P006[i0VKh01QVf6[iI_QV
n6KHJ_UVn000I]P005ZiF]YJ^EkJF[UJfUZiG]YJ^E[J001>^dZKC[/40000=DZJCY/004Ik@W]6O49k
AW]2NdIl@W/0049K@Wa2Nd9l@U]2O49k@W`004JL@W]6W49kAYa2NdJL@W/004JKBYa6VdZLAY]:W4JK
BYa6V`00BY]>_4ZKB[a:VdjlBY]:_4ZK001:^dkLB[/0100000=>g4jlC]`00P00011>g5;LC]aBg4kL
D]a>g5;LC]aBg000D_a>g5;lC]aBo0<0000>D_e>g000C]aBoE;LD_a>g5;mD]aBo4kLD_d000Uoo`@0
00Moo`03001oogoo01Eoo`006goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol07goo00<0
07ooOol08goo00D006lFKaH007;e009c5@06LaIbm@00LaEc5W;e0W<E00Ic5W;eLaD007<FL_D2LaD0
1W<FL_Ec5G<E001bm@9c5@0JLaH007<EL_Ec5P00LaEbmG<FL_Ec5G;e001bmG<EL_Ec5W;eLaEbmG<F
001c5W;eLaIbm@@0000;KaI^mVlGK_I_5VkfKaM^mP00K_I_5`03K_H016lGK_I^mP002VKh00@006Kh
I_P000YJfP@00003CY]:VdjK009>V`0<BY/0049kAW]2NdIk@W]6Nd9kAW]2N`00249k01D004Ik@W]6
O49kAW]2NdIl@W/004JKBYa6VdJLAY]:W4JKAYa6V`00BY/00dZl00=:VdZlB[`01@0000E>_4kLC]a>
g4jl009>g005001>g000C]aBg003C]`01e;LC]a>g4kL001>g5;L00<000=Bo003D]aBo00000YBo003
001oogoo00]oo`03001oogoo01aoo`006goo00<007ooOol00Woo00<007ooOol00Woo0P008Woo00<0
07ooOol08Goo03L007<GK_Ic5fkf001^mG<FL_Ec5P00LaIbmG<FK_Ec5W;eLaI^m@00L_Ec5VkeLaIb
mG<FK_Ec5P00LaI^mG<FL_D006keLaH007<FK_Ec5W;eLaI^mG<F001c5VkeLaI^mG<FK_Ec5P00LaI^
m@0300006Vke001^mP00K_Ic5fkfKaM^mW<GK_H006kfKaM^mVlGK_I_5fkfKaL006lG001Vn6KHJ_T2
I_P046KHJ_UVn000I]QVnFKHI_P005kJF[UJfUZiG]YJ^E[J0P0003AJ^E[J001>VdZJCY]:VTjKBYY>
VdZJ0012NdIk@W]6O49kAW]2NdIl@W/0049K@Wa2Nd9l@U]2O49k0012NdJL@W]6W49kAYa2NdJL@W/0
04JKBYa6VdZLAY]:W4JKBY`004ZlBY]>_0@0000HB[]>_4Zk001>_4kLC[]>g4jlC]a>^dkLC[`004kL
001>g5;LC]aBg4kLD]a>g5;L0`0001=BoDkLD_a>g5;mC]aBo4kLD_d005;lC]aBoE;LD_a>g5;mD]aB
o002000<Ool00`00Oomoo`0LOol001]oo`03001oogoo009oo`03001oogoo009oo`03001oogoo029o
o`03001oogoo01moo`04001_5VlFLaL3KaH01P00L_Ec5@00LaIbm@9c5@06LaIbmG<ELaD007;e0W<E
00Ic5W;eLaEc5G<F0002LaD05W<FL_Ec5G<E001bm@00L_Ec5W;eLaEbmG<F001c5G;eLaIbmG<EL_Ec
5W;e0`00011bmG<FL_Ec5W;e001^mVlGK_I_5VkfKaM^mVlF001_5`=^mP07KaM^mVkfK_H006kf0000
1VKh0P000VKh00EVf6KhI_QVn00000AJfP800006F]YJ^UZjF[X004ZK0djK011:VdjKCY]>VdZK0012
NdIk@W]6Nd9kAW]2NdIk@W/000M2N`0?0012NdIk@W]6O49kAW]2NdIl0016W4JKBYa6VdJL00L00008
C[a:_4jlB[a>_4ZlC[`000=>g005C[a>g4kLC]a>_002C]`01@00C]`004kLD]`00TkL0`000U;L00<0
05;LD_`00U;l00MBg5;lD_aBo5;LD_`00005D_`30002D_`00`00Oomoo`0:Ool00`00Oomoo`0KOol0
01]oo`03001oogoo009oo`03001oogoo009oo`03001oogoo02=oo`03001oogoo01ioo`0b001^mW<G
K_Ic5fkfLaM^mP00K_D007;eLaI^mG<FL_Ec5VkeLaH007<FK_Ec5W;eLaI^mG<FL_D006keLaIbmG<F
K_Ec5W;e001^mG<FL_Ec5VkeLaIbm@00K_Ec5VkeLaI^m@<0000NK_Ec5VkeLaI^mG<FK_D006ke001^
mVlGK_Ic5fkfKaL006lGK_I_5fkfKaM^mVlGK_H006kfKaMZmP000VKh00iVf6[i001Vn6KHI_UVf6Kh
I]QVnFKH001J^EkJ0P0002QF^E[JF[UJfUJiF]YJ^@00BYY>VdZJCY]:VTjKBYY>VdZJ0012NdIk@W]6
O49kAW]2NdIl0012O49K@Wa2Nd9l@U]2O000AYa2NdJL@W]6W0T0000KB[a6VdZlAY]:_000C[a:^djl
B[]>_4ZkC[a:^djl001>g4jlC]a>^dkLC[a>g4jkC]`005;L00D0000CD_e>g5;lC]aBo@00D_a>g5;m
C]aBo4kLD_e>g5;lC]`005;LD_`00`0000MBoE;LD_eBg5;mD]`0000<Ool00`00Oomoo`0JOol001ao
o`@000Eoo`03001oogoo02Aoo`03001oogoo01aoo`03001_5W<G00=_5P06LaM_5VlFKaH007;e0W<E
00Ic5W;eLaEc5G<F0002LaD02W<FL_Ec5G<ELaIbm@00LaEc5W;e0W<E00mc5W;e001c5@00L_Ec5G;e
LaIbm@00L_Ec5W;eLaD00P0001AbmG<E001c5W;eLaIbmG<FL_Ec5P00LaIbm@00K_I_5fkfKaI^mP00
0fkf00]_5fkfK_I^mP00K_I^mfkfK_M^mP00009Vn005001Vn6KhI_QVf003I_P00fKHI_QVn0020002
F[X01E[JF[YJ^UZjF]X00UZj00<004jKBY/00djK00Y:VdjKCY]>V`00AW]2NdIk@W]6Na400006AYa6
NdJLAY]6W0000TZL019:_4ZKBYa:W4ZlBY/004ZlC[a:_4jlB[a>_4ZlC[a:_4jl0003C]`014jlC]a>
g4kL1@000U;L00YBo4kLD]aBg5;lC]aBg000D_aBg0=Bo004D]aBo5;lD_`30009D_`00`00Oomoo`0:
Ool00`00Oomoo`0JOol002Eoo`03001oogoo02Eoo`03001oogoo01]oo`0^001c5fkfLaM^mW<GK_Ic
5fkf001^mP00K_Ec5W;eLaI^mG<FL_D006keLaIbmG<FK_Ec5W;eLaH007<FL_Ec5VkeLaIbmG<F001c
5W;e001^mG<FL_Ec5P00LaH30000AG<FK_Ec5P00LaI^mG<FK_Ec5VkeLaH007<FK_Ec5Vke001^mVlG
K_H006kfKaM^mVlGK_I_5fkfKaL006lGJ_I_5fkfKaL006[i001Vn6KHI_UVf6KhI]QVnFKHI_QVf000
H]P005JiF]YJ^E[JE[UJfUZiF]YF^E[J001>VdZJCY]:VTjKBYY>V`070000;TIl@W]6Nd9kAW`004Il
@W]6O49kAWa2NdIl0016W49kAYa6NdJL@W]6W4Ik0016VdZlAY]:_4JKB[a6VdZlAY/004ZkC[a:^djl
B[]>_4ZkC[a:^`00C[]>g4jl100001EBg4kLD]`005;l001BoDkLD_a>g5;mC]aBo4kLD_d005;lC]aB
oDkLD_`00`0000iBo4kL001Bg5;mD]aBoE;LD_eBg5;mD]aBo@002Woo0`006goo000UOol00`00Oomo
o`0VOol00`00Oomoo`0IOol00`00LaM_5P02KaH01W<GKaI_5VlFLaL0009_5P0:001bmG<ELaEc5W;e
001c5G<FL_D2LaD01W<FL_Ec5@00LaIbm@9c5@06LaIbmG<E001c5W;e0W<E00<007;eLaD00`0001Mc
5G;eLaIbmG<EL_D007;eLaIbmG<FL_Ec5W;e001bmG<FL_Ec5P00KaI^mP0000=^mP0>KaM^mVkfK_I_
5`00K_M^mVkgK_I^mfkfK_L000=Vn005I]QVn6KhI_QVf002I_P01@00I]QVn000F]X00eZj00MJfUZj
F[YJ^U[JF[X00002CY/00dZK000000020003CY/00`00AW]6N`06AW/00`00@W]2O003@W/03T9l@W/0
04JKAYa6NdJLAY]6W4IkAYa6V`00BY/2BY`03TZlBY]:W4ZLB[a:V`00B[a>_4ZlC[a:_4jlB[`50008
C]`00`00D_`00002D]`01e;lC]aBg5;LD_a>g000009Bo0<000EBo003001Bo5;l00QBo08000aoo`03
001oogoo01Qoo`0097oo00<007oo0000:7oo0P0067oo02X007<GK_Ic5fkfLaM^mW<GK_Ic5`00LaM^
mW<GK_H006keLaIbmG<F001c5W;eLaI^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaI^m@00L_Ec5VkeLaH4
0000@fkeLaI^mG<FK_Ec5Vke001^mG<FK_Ec5VkeLaI^m@00K_Ec5VkeLaI^mG<F001c5`00KaM^mVlG
K_I_5fkfKaL006lGJ_I_5fkfKaMZmVlG001^m`00I_UVf6KhI]QVnFKHI_QVf000H]QVn6;HI_T005[J
E[UJfUZiF]YF^E[JF[UJfUJi00<0000`BWY>VdZJCY]:NTjKBYX0049kAWa2NdIk@W]6O49kAW]2N`00
@W]6O49kAWa2NdIl@W/004IkAYa2NdJLAW]6W49kAY`004ZlAY]:_4JKB[a6VdZlAY]:_000C[a:^djl
100001M:^dkLB[`004kLD]a>g5;LC]aBg4kLD]a>g000C]`004kLD_e>g5;lC]aBoDkL00@0000@D_a>
g5;mD]aBo4kLD_eBg5;l001BoE;LD_eBg5;mD]`300000e;lD_d0000;Ool00`00Oomoo`0HOol002Ao
o`8002]oo`03001oogoo01Eoo`05001_5VlFKaIc5`03KaH01G<G001_5VlFLaL00flF00H007;eLaD0
07<FL_D2LaD01W<FL_Ec5G<E001bm@9c5@07LaIbmG<ELaD007;eLaD00`000W<E01X007;eLaEbmG<F
L_Ec5G;eLaH007<FL_Ec5W;eLaIbmG<F001c5W;eLaIbmG<FL_Ec5P000Vkf019_5fkfK_I^mVlGK_H0
06kfK_M^mVkgK_I^mfkf001^mP00I]P3I_P036KHI_QVn000I]QVn6KHI_QVf6Kh001JfP=J^P03F]YJ
^UZj00800005E[T004jKCY]:VP03CY/014ZJCY]>V`0024Ik00@0049k@W]2O0=2N`0>@Wa2N`00AY]6
W4IkAYa6VdJLAW]6W000B[a:V`9:W003B[a:VdZL00D00008C]a>_4kLC[a>g4jlC]`000Y>g004001B
g000C]`5000015;LD_aBg0002E;l00<005;lD_`010001E;l00<007ooOol02Woo00<007ooOol05goo
000TOol00`00Oomoo`0[Ool00`00Oomoo`0COol09@00K_Ic5fkfLaM^mW<GK_Ic5fkf001^mW<GK_Ic
5fkfLaM^mP00K_D007;eLaI^mG<FL_Ec5VkeLaH007<FK_Ec5W;eLaI^mG<F00<00005LaIbmG<FK_Ec
5P020000?fkeLaI^mG<FK_Ec5P00LaI^mG<FK_Ec5VkeLaH007<FK_Ec5VkeLaI^mG<F001c5P00KaM^
mVlGK_I_5fkf001ZmVlGK_I_5f[fKaM^mP00J_I_5f[f001Vf6KiI]QVn6KHI_T006KhH]QVnF;HI_QR
f6Ki001JfUJiF]YJ^@020000;5[JE[UJ^P00CY]:VTjKBWY>VdZJCY]:NTjK0016Nd9kAWa2NdIk@W]6
O49kAW/004Il@W]6O49kAWa2NdIl@W/004IkAYa2NdJLAW]6W49k0016VdZlAY/400005djlB[]:_000
C]a:_4kLB[]>g4ZlC]a:^dkL001Bg4kLD]a>g5;LC]aBg4kLD]`01000019>g5;mC]aBo4kLD_e>g5;l
001BoE;LD_a>g5;mD]aBo4kLD_d300002e;mD_aBoE;LD_eBo5;mD]aBoE;l000037oo00<007ooOol0
5Woo000TOol00`00Oomoo`0/Ool00`00Oomoo`0AOol01@00KaI_5VlFLaL00flF00Ec5flF001_5W<G
00=_5P06LaM_5VlFKaH007;e0W<E00Ic5W;eLaEc5G<F0002LaD00g<FL_Ec5@030002LaD01W<FL_Ec
5G<ELaH0009c5@0J001bmG<EL_Ec5W;e001bmG<FL_Ec5W;eLaIbm@00L_Ec5W;eLaIbmG<FL_D007;e
LaH0009^mP0BKaM^mVkf001^mfkfK_M^mVkgK_I^m`00K_MZmVkgK_H006KH0fKh00`006KhI]QVn6KH
I_QVf6KhI]P005ZjF]X20002F[X01EJiF[YJ^UZj00000djK00M:VTjKCY]>VdZJCY/00008AW/01@00
@W]2Nd9k@W`00d9k00M2O000AYa6VdJLAW]6W0060007B[`03000C[a>g4jlC]a>_4kLC[a>g4jlC]`0
00E>g0<0000>D]a>g000001Bo5;LD_aBg5;lD]aBo5;LD_`000EBo0<0009Bo003001Bo5;l00QBo003
001oogoo00Yoo`03001oogoo01Ioo`0097oo00<007ooOol0;Goo00<007ooOol047oo020007<GK_Ic
5fkfLaM^mW<GK_Ic5`00LaM^mW<GK_Ic5fkfLaM^mP00KaH006keLaIbmG<FK_Ec5W;e001^mG<F0`00
04Qc5W;e001^mG<FL_Ec5VkeLaIbm@00K_Ec5W;e001^mG<FK_D006keLaI^mG<FK_Ec5Vke001^mG<F
K_Ec5VkeLaI^m@00K_Ec5VkeLaH006lGK_I_5`00KaM^mVlGJ_I_5fkfKaL006lGJ_I^mf[fKaMZmP00
I]QVn@00I_QRf6KiH]QVn6;HI_URf6KhH]P2000065ZjE[UJfUJiF[YF^E[JE[UJ^P00CY]:VTjKBWY>
VdZJCY]:NP00@W]6Nd9kAWa2Na80000KB[a6VdZLAY/004ZkB[a:VdjlB[]:_4ZKC[a:^`00B[]>g4Zl
C]a:^dkLB[a>g4Zk001>g5;L00<0000CD_a>g5;mC]aBo000D_d005;lC]aBoDkLD_a>g5;mC]`004kL
D_d00`00019BoE;LD_eBg5;m001BoE;LD_eBo5;mD]aBoE;lD_eBg5;m000:Ool3000GOol002Aoo`@0
02eoo`03001oogoo00ioo`04001_5VlFLaL3KaH01G<GKaI_5P00LaL00flF00Ic5flFKaI_5W<G0002
KaH02000L_Ec5G<ELaIbm@00LaD20002LaD01W<FL_D007<ELaIbm@9c5@06LaIbm@00LaEc5W;e0W<E
01T007;eLaD007<FL_Ec5W;eLaIbmG<F001c5W;eLaIbmG<FL_Ec5P00LaI^mG;fL_D00002K_H08000
K_M^mVkgK_I^mfkfK_M^mP00J_I^mfkfK_MZmVkg001Vn000I_QVf6KhI]QVn6KHI_QVf6KhI]P006;H
0002F[X01EJiF[YJ^UZjE[T00eZj00D004jKCY]>VdZJ00=>V`H000E6N`050016NdIkAW]6W003AW/0
0dJL0016W002AY`01TJKAYa6W4JLAY/000U:_008001>_4kLC[a>g4jlC]a>_0@0000CD]a>g5;LC]aB
g4kLD]a>g5;L001Bo000D_aBg5;lD]aBo5;LD_`00`002E;l00<005;lD_`01e;l0P0037oo00<007oo
Ool05Goo000TOol200000bZN:Wd00004000YOol00`00Oomoo`0=Ool07000K_Ic5fkfLaM^mW<GK_Ic
5`00LaM^mW<GK_Ic5fkfLaM^mW<G001c5fkfLaM_5P00K_Ec5W;e0`0001EbmG<FK_Ec5W;e001^mG<F
L_Ec5VkeLaIbmG<F001c5W;eLaI^mG<FL_D00P0004Ic5VkeLaI^mG<FK_Ec5P00LaI^mG<FK_Ec5Vke
LaH007<FK_Ec5VkeLaI^m@00K_H006kfKaMZmVlGK_I_5f[f001ZmVkgJ_I_5f[fK_MZmVlG001Vn6;H
I_URf6KhH]QVnF;HI_QRf000H]QVn000F]YF^EZjE[UJfUJiF[YF^E[JE[T004YjCY]:VP@0000[CY]:
NP00AW]6VdIkAYa6NdJKAW]6W000AYa2NdJL@W]6W49kAYa2N`00AY]:_4JKBYa6VdZlAY]:W4JK001:
^dZlBY]>_4ZkB[a:Vdjl001>g4ZkC]`010000TkL019>_000C]aBo4kLD_e>g5;lC]aBoDkLD_`005;m
001Bo4kLD_d300004e;mD]`005;LD_eBg5;mD]aBoE;LD_eBg5;m001BoE;LD_eBo5;m00<00003D_eB
g00000aoo`03001oogoo01Aoo`008goo0P0000Aoo`00:YhZOP<ZWPD002Ioo`03001oogoo00]oo`03
001_5W<G00=_5P05LaM_5VlFKaH00003KaH01W<GKaI_5VlFLaL0009_5P04LaM_5VlFKaH400002W<F
L_Ec5G<ELaIbmG<E001c5W;e0W<E00Ic5W;eLaD007<FL_D2LaD0?W<FL_Ec5G<E001bmG<FL_Ec5W;e
LaIbm@00L_Ec5W;eLaIbmG<FL_D006keL_IbmG<FK_EbmW;e001^mVkgK_I^mfkfK_M^mP00J_I^mfkf
K_MZmVkgK_I^m`00K_L006KhI]QVn6KHI_QVf6KhI]P006;HI]QRf6KH0003F[X01UJiF[YJ^UZjE[UJ
^P@00007CYY>VdjJCY]>VTjK00002DIk00<004JLAW/00TIk00I6W4IkAW]6N`00AY/3AY`01DJKAYa6
W4JL000024Zl10001dkL00d005;LC]aBg4kLD]a>g5;LC]aBg4kL001Bg0040003D_`015;LD_aBo000
2E;l00<005;lD_`00`001U;l00<007ooOol02Woo00<007ooOol04goo000SOol01000Oomoogoo0P00
00PZOBjN:WhZWRYm000B718m10008goo00<007ooOol02Goo01P006LH001^mW<GK_Ic5fkfLaM^mP00
K_Ic5fkfLaM^mW<GK_Ic5fkf001^mW<GKaH30000GFlF001^m@00L_Ec5VkeLaIbmG<F001c5W;eLaI^
mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaI^m@00L_D006keLaI^mG<FK_D006keLaI^mG<FK_Ec5Vke001^
mG<FK_Ec5VkeLaI^m@00K_D006[fKaM^mVlGJ_I_5`00K_MZmVlGJ_I^mf[fKaMZmP00J_H006;HI_QR
f6KiH]QVn6;H001Rf6KhH]QVnF;H001F^E[JE[UJ^UJiF]YF^@020000:eZjE[T004YjCY]:VTjKBWY>
VdZJCY/004JLAW]6VdIkAYa6NdJKAW/0049kAYa2NdJL@W]6W49kAYa2N`00AY]:_4JKBYa6VdZlAY]:
W000C[a:^dZl00@00006B[]>g000C]a>_5;L0TkL00i>_5;LC]a>g000D_e>g5;lC]aBoDkLD_a>g5;m
1000015Bg5;mC]aBoE;LD_e>g5;m001BoE;LD_eBg5;mD]aBoE;L00@0000:D_eBg5;mD_aBoE;LD_eB
o5;m000<Ool00`00Oomoo`0COol002=oo`03001oogoo00=oo`03000ZORZN008ZWP06:Wh0018L4QdB
718M0`008Woo00<007ooOol01goo00L006/IJaU[6@00KaIc5`03KaH01@00KaI_5VlFLaL00flF00Ac
5flF001_5P<00003KaIc5flF009_5P06001bmG<ELaEc5W;e0W<E00H007;eLaEc5G<FL_D2LaD01P00
L_Ec5G<ELaIbm@9c5@0JLaH007<FLaD007;eLaIbmG<F001c5W;eLaIbmG<FL_Ec5P00L_IbmG<FK_Eb
mW;eLaH0009bmP0R001^mVkgK_I^m`00K_M^mVkgJ_I^mfkfK_MZmP00J_M^mf[f001Vf6KhI]QVn6KH
I_P006KHH]QVf6;HI]QRf000E[T3F[X200003eJiF[YF^EZj001>VdjJCY]>VTjKCYY>VdjJCY/00008
AW/00`00AW]6W003AW/01TJLAW]6N`00AYa6V`=6W0L00007C[a:_4jlB[a>_4Zl00002TkL00H005;L
C]aBg4kLD]`300001E;lD]`005;L00000U;l00MBg5;lD_aBo5;LD_`00003D_`40003D_`00`00D_aB
o008D_`00`00Oomoo`0:Ool00`00Oomoo`0BOol002=oo`03001oogoo00Aoo`@00009:YhZO@00000B
?A8L5Sd0006J0080025oo`03001oogoo00Eoo`0D001W66/iIaQ[6FLH001^mW<GK_Ic5`00LaM^mW<G
K_Ic5fkfLaM^mP<0001OKaIc5fkfLaM_5W<GK_H006lF001^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaI^
mG<F001c5VkeLaIbmG<FK_Ec5P00LaI^mG<FL_D006keLaH007<FK_Ec5VkeLaI^mG<F001c5VkeLaI^
mG<FK_Ec5P00LaI^mG<FK_D006[fKaM^mP00J_I_5f[fK_MZmVlGJ_H006[fK_MZmVkgJ_H006;HI_QR
f6Ki001Vn6;HI_URf6KhH]QVn@00F[YF^@0200007eZjE[UJ^UJiF[YF^EZj001>VdYjCY]:VTjKBWY>
VdZJCY/004JLAW]6VdIkAYa6NdJK0016W49kAYa2NdJL00T0000?B[a6VdZlAY]:_000C]a:_4kLB[]>
g4ZlC]a:^`00009>g00:C[aBg4kLC]a>_5;LC]`004kLD_d300001U;mC]aBo4kLD_e>g0800008D_eB
g5;mC]aBoE;LD_e>g0@0000BD_eBg5;mD]aBoE;LD_eBg000D_aBoE;LD_eBo5;mD]aBoE;l0P002Woo
0`004goo0003Ool3000MOol00`00Oomoo`05Ool00`00:WhZWP0600001A8L4Qd000000GT00P0087oo
00<007ooOol00goo00<006/IJaT01F/I00@006lFLaL0009_5P04LaM_5VlFKaH400001G<GKaI_5VlF
LaL00flF00Ic5`00KaI_5P00L_D2LaD01W<F001c5G<ELaIbm@9c5@06LaH007<ELaEc5W;e0W<E03mc
5W;e001c5G<FL_Ec5P00LaIbm@00L_Ec5W;eLaIbmG<FL_D007;eLaI^mG;fL_Ec5Vke001bmW<FK_Eb
mP00K_M^mP00K_I^mf[fK_M^mVkgJ_I^m`00K_MZmVkgJ_M^mf[f001Vf6Kh001Vf6;HI]QRf6KHH]QV
f6;HI]P00P0001AF^EZjE[UJ^UJiF[YF^EZjE[T004jJCY]>VTjKCYY>VdjJCY]>VP001DIk200000Q6
W4JKAYa6VdJL001:_4ZL0dZl00i:W4ZlB[`004ZlC[a:_4jlB[a>_4ZlC[a:_0001dkL100000aBo5;L
D_a>g5;lD]aBo4kLD_`005;l0003D_`015;L000000000U;l00<005;lD_`01e;l00<005;lD_`015;l
0`000U;l00<007ooOol02Goo00<007ooOol04Goo0004Ool00`00Oomoo`0LOol20007Ool01`009WdZ
WRYn:YhVOBZN00H000040GT1VP00000OOol05000Oomoogoo001W66/iIaQ[6FLHJcUW66/IIaP006kf
001^mW<GK_H30000;6kfLaL007<GKaIc5fkfLaM_5W<GK_Ic5`00LaM^mW<GKaH006keLaH007<FK_Ec
5W;eLaI^mG<FL_D006keLaIbmG<FK_Ec5W;e001^mG<FL_Ec5VkeLaH20000BFkeLaI^mG<FK_Ec5Vke
001^mG<FK_Ec5VkeLaI^m@00K_Ec5VkeLaI^mG<F001_5`00KaMZmVkgJ_I_5f[fK_L006kgJ_I^mf[f
K_MZmVkg001Vn@00I_QRf6KiH]QVn6;HI_URf6Kh001Vn@00F[YF^EZjE[UJ^UJiF[YF^EZjE[T004ZJ
CY]:NTjKBYY>VdYj00L0000RAW]:W4IkBY/004ZLAY]:W4IkBYa6VdZLAW/004JKB[a6VdZlAY]:_4JK
B[a6V`00B[]>g4ZlC]a:^dkLB[a>g000D]`2C]`4000044kLD_e>g000C]aBoDkLD_a>g5;mC]aBo4kL
D_d005;m100001=>g5;mD]aBoDkL001Bg5;mD]aBoE;LD_eBg5;mD]aBo@00D_eBo00300001U;lD_eB
g5;mD_`000aoo`03001oogoo011oo`0017oo00<007ooOol06goo0P002Goo0P000bZN00HZORZN000B
7A8L4Qd300020GT2000NOol01000Oomoo`002V/I00<006lFLaL00P0000=_5W<GKaH00VlF00D006lF
KaI_5W<G00=_5P05LaL006lFKaIc5`03KaH01P00L_D007<ELaIbm@9c5@06LaIbm@00LaEc5W;e0W<E
01ic5W;eLaD007<FL_Ec5W<ELaIbmG<F001c5W;eLaIbmG<FL_Ec5P00LaI^mG;fL_Ec5VkeL_H007<F
K_D2L_H087<FK_EbmP00K_MZmVkgK_I^mf[fK_L006kgJ_I^mf[gK_MZmVkgJ_M^m`00I]QRf6KHH]QV
f6;HI]QRf6KH0002H]P03`00E[UJ^UJiF[YF^EZjE[UJ^UJiF[X004jKCYY>V`0400001DjJCY]>VP00
AW/00TJK00m:VdIkAY]6V`00AY]6W4JKAYa6VdJLAY]6W4JK00000TZl00E:W4ZlB[a:_4ZL009:_008
001:_4jlB[a>_4ZlC[a:_0@00005D]a>g4kLC]aBg003C]`02P00C]aBo5;LD_a>g5;lD]aBo4kL1000
25;l00<005;lD_`01e;l0`002E;l00<007ooOol02Woo00<007ooOol03goo0004Ool4000JOol00`00
Oomoo`0:Ool01P00:YhZORZN9WdZWP8000033Q`B?A8L00<000040GT00000000MOol200002V/iIaQ[
6FLHJcUW66/IIaQ[>FLH100007Ec5fkfLaM^mW<GK_H006lFLaM^mW<GKaIc5fkfLaM_5P00K_Ic5flF
LaM^mW<GKaH006keLaIbmG<FK_Ec5W;eLaH007<FL_Ec5VkeLaIbmG<F001c5W;eLaI^mG<FL_Ec5P00
LaH007<FK_Ec5VkeLaH007<FK_Ec5VkeLaI^mG<F001c5VkeLaI^mG<FK_Ec5P00LaH006kgJ_I_5f[f
K_L006kgJ_I^mf[fK_MZmVkgJ_I^m`00K_L006KiH]QVn6;HI_URf6Kh001VnF;HI]QRf000E[UJ^UJi
F[YF^EZjE[UJ^UJiF[X00`0002M>VdjJCY]>VTjKCYY>V`00BY]6NdZLAW]:VdIkBYa6N`00AW]:W4JK
BYa6NdZLAY]:W4Ik0016VdZlAY]:_4JKB[a6VdZl001>g4ZkC]`0100001=>_4kL001BoDkLD_a>g5;m
C]aBo4kLD_d005;lC]aBoDkLD_a>g00300004dkLD_d00000C]aBoE;LD_e>g5;mD]aBoDkL001Bg5;m
D]aBoE;L00<0000=D_aBo@00D_eBo5;mD]aBoE;lD_eBg5;m000037oo00<007ooOol03goo0004Ool0
1@00Oomoogoo00006Goo00<007ooOol02goo100000TZORZN:Yh0018L4QdB70000GT01P006goo00<0
06/IJaT01f/I0`000V/I00<006lFLaL00flF00D006lFKaI_5W<G00=_5P05LaM_5P00KaIc5`03KaH0
1W<GKaH006lF001bm@9c5@06LaIbmG<E001c5W;e0W<E01ic5W;eLaEc5@00L_Ec5W<ELaIbmG<FLaD0
07;eLaH007<FL_Ec5W;e001^mG;fL_Ec5VkeL_Ibm@00K_D2L_H05W<FK_EbmW;f001^mP00K_I^mf[f
K_M^mP00J_I^mf[gK_MZmVkgJ_M^m`000V[g00P006;HI]QRf6KHH]QVf0001V;H00P005JiF[YF^EZj
E[UJ^UJi0P0000iJ^P00CY]>VTjKCYY>VdjJCY]>VTjK001:VdIk0TJK00i:VdIkAY/004JLAY]6W4JK
AYa6VdJLAY]6W0000dZl00=:W4Zl00001P001dkL00@004kLC]aBg0=>g006D]a>g4kL001Bo4kL0`00
00IBg5;lD_aBo5;LD_`20008D_`00`00D_aBo0030005D_`00`00D_aBo007D_`2000<Ool00`00Oomo
o`06Ool50003Ool000Aoo`05001oogooOol0000IOol00`00Oomoo`0<Ool00`00:YhVOP0600001Q8m
4Q`000000IX1N@8000030AL0000001Qoo`08001[>FLHJaUW66/iIaQ[6@@0001fIaQ[>FLHJcUW6000
K_Ic5fkfLaL007<GK_Ic5flFLaM^mW<GKaH006kfLaM_5W<GK_Ic5flFLaL007<GKaH006keLaIbmG<F
K_D007;eLaI^mG<FL_Ec5Vke001bmG<FK_Ec5W;eLaI^m@00L_Ec5VkeLaH007<FK_D006keLaI^mG<F
K_Ec5Vke001^mG<FK_Ec5VkeLaI^m@00K_Ec5Vke001ZmVkgJ_H006[fK_MZmVkgJ_I^mf[fK_MZmP00
J]I^mf[f001Rf6KiH]QVn000I_URf6KHH]QVnF;HI]QRf000E[UJ^UJiF[X200007UJiF[YF^@00CYY>
VdjJCY]>VTjKCYY>VdjJ0016NdZKAW]:W4IkBY]6NdZL001:W4IkBYa6VdZLAW]:W0L0000GC[a:_4jl
B[]>_000C]a:_4kLC[a>g4ZlC]a>_000C]aBoDkLD_a>g5;mC]aBo00400004TkLD_e>g5;mC]aBoDkL
D_e>g000D]`004kLD_eBg5;mC]aBo@@0000?D_aBoE;LD_eBo5;mD]aBoE;l001Bg5;mD_aBoE;L00<0
0003D]aBo@0000Yoo`<000Moo`05001oogooOol00003Ool000Aoo`05001oogooOol0000IOol00`00
Oomoo`0=Ool01@00:YhZWRZN9Wh00RZN1P000`5i10005Woo00<006/IJaT00f/I0`000V/I00<006/I
JaT01F/I00@006lFLaL0009_5P05LaM_5VlFKaIc5`02KaH00`00LaM_5P02KaH01G<GKaI_5P00LaL0
0flF00H007;eLaEc5@00L_D2LaD07W<FL_Ec5G<E001bmG<FLaEc5W;eLaIc5G<F001c5W<ELaIbmG<F
001c5P00L_IbmG<FK_EbmW;eLaH0009bmP0GLaI^mG;fL_Ic5P00L_I^mW<FK_H006kf001ZmVkgJ_M^
mf[fK_MZmfkgJ_H00005J_L01000H]QVf0002F;H00<005ZjE[T00P0001AJ^UJiF[YF^EZjE[T004jJ
CY]>VTjKCYY>VdjJCY]>VP00AY]:VdIk0TJK00I:VdIk0016VdJLAY/40002BY`00dZl001:_008B[`0
0`00C]a>g006C]`01000C]a>g4kL100000IBo4kLD]`005;lD]`3D_`02E;LD_aBo5;lD]`005;l001B
o0040003D_`00`00D_aBo007D_`00`00D_aBo0030006D_`00`00Oomoo`09Ool00`00Oomoo`06Ool0
0`00Oomoo`04Ool000=oo`D001Yoo`8000moo`8000099WhZWRIm:YhVOP003Q`B7@hL008000030IX1
N@6J00D0019oo`800003JcUW66/I00<0001iJaUW66/iIaP006LHJcUW66/iIaQ[>FLHJcUW6000K_H0
06kfLaM_5W<GK_Ic5flFLaL007<GKaIc5fkfLaM_5W<GK_H006lFLaM^mW<GKaH006keLaH007<FK_Ec
5W;eLaI^mG<F001c5VkeLaIbmG<FK_Ec5P00LaI^mG<FL_Ec5VkeLaH007<FK_Ec5VkeLaI^mG<F001c
5VkeLaI^mG<FK_Ec5P00LaI^mG<FK_Ec5P00KaL006kgJ_I^mf[fK_MZmVkgJ_H006[FK_MZmVkgJ]I^
m`00I_P006KiH]QVf6;HI_URf6KHH]QVnF;HI]P00P0001QF^EZjE[UJ^UJiF[YF^EZj001>VdjJCY]>
VTjKCYY>VdjJCY/004ZLAW]:VdIkBY`600006TJKB[a6VdZlAY]:_4JK001:^djlB[a>_4ZkC[a:_4jl
B[/004jlC]a:_4kLC[a>g4ZlC]`400004TkLD_a>g5;mC]aBo4kLD_d005;mC]aBoDkLD_e>g5;mC]aB
o@@0000AD]aBoE;LD_eBg5;mD]`005;LD_eBo5;mD]aBoE;lD_eBg00300002U;LD_eBo5;mD]aBoE;l
D_eBg00037oo00<007ooOol01Woo00<007ooOol00goo000QOol2000BOol01000:YhZWRIn0RZN0P00
0PhL00<B7@0000000P5i0`0000<1>00000003Goo0`0000=C7ELM00000P001V/I00<006/IJaT02F/I
00<006lFLaL00flF00Ec5flFKaH007<G00=_5P05LaM_5VlFKaH00003KaH017<GKaI_5VlF0P000W<E
029c5W;eLaEc5G<F001c5W<ELaIbmG<FLaEc5W;e001c5G<FL_Ec5W<ELaH007<F001c5VkeL_IbmG<F
K_D007;fLaI^m@9bmP0CLaI^m@00K_Ic5VkfL_I^mW<F001^mf[gK_MZmVkgJ_M^mf[f000026[g00<0
06;HH]P02F;H01@006;H001J^UJiF[YF^EZjE[UJ^UJiF[X004jKCYY>VdjJCY]>VTjK1`0014ZK00@0
04ZLB[a:V`9:W005B[a:VdZLBY`00009B[`01000C]a>g4kL10000TkL00/004kLD]a>g5;lC]aBg4kL
D_a>g000009Bo004D]aBo5;lD_`30002D_`20008D_`00`00D_aBo003D_`30002D_`00`00D_aBo008
D_`00`00Oomoo`0:Ool00`00Oomoo`06Ool00`00Oomoo`02Ool0025oo`03001oogoo019oo`@00007
:YhVORZN000B7@hL4Qd00`0000H1VP000000005H0CL40006Ool300000e;lEad000020000SULM001[
>FLHJaUW66/iIaP006LHJcUW66/iIaQ[>FLHJcUW66/iIaP006LH001_5W<GK_Ic5flFLaM^mP00KaIc
5fkfLaM_5W<GK_Ic5`00LaM^mW<GKaIc5fkfLaM_5P00K_Ec5W;eLaI^mG<FL_D006keLaIbmG<FK_Ec
5W;e001^mG<FL_Ec5VkeLaIbm@00K_Ec5P00LaI^mG<FK_D006keLaI^mG<FK_Ec5Vke001^mG<FK_Ec
5VkeLaH007<F001^mf[fK_MZmVkgJ_I^m`00K_MZmVkgJ]I^mf[fK_L006kg001Vf6;HI_URf6KHH]QV
nF;HI]P006KIH]P005JiF[YF^EZjE[UJ^UJiF[YF^@00CYY>VdjJ100001iB^djJD[/004ZLBY]:W4ZK
BYa:VdZL001:_4JKB[a6VdZlAY]:_4JKB[a6V`00B[]>_4ZlC[a:^djlB[`500000dkLD]e>g002C]`0
3e;MC]`004kLD_e>g5;lC]aBoDkLD_a>g000C]aBo@0300001U;mC]aBoE;LD_e>g080000:D_eBg5;m
D]aBoE;LD_d005;mD]`3000045;LD_eBo5;mD]aBo@00D_eBg5;mD_aBoE;LD_eBo5;m0P002goo00<0
07ooOol01goo00<007ooOol00Goo0007Ool40005Ool20005Ool40006Ool00`00Oomoo`0COol00`00
9WhVWP0600000`hL4Qd0000400001`4F0001>04h000JGAiM00H00003DaeG7E;l00800005EaeBo5<M
DaeG7@020003JaT00`00JaU[6@09JaT01`00JaU[6F/I001_5W<G00=_5P05001_5VlFKaIc5`03KaH0
1G<G001_5VlFLaL00flF00Ic5flF001_5P00L_D2LaD07W<FL_D007<ELaIbmG<FLaEc5W;eLaH007<F
L_Ec5W<ELaIbm@00LaEc5W;eLaH007<FK_EbmP00LaI^m@9bmP0DLaI^m@00K_Ic5VkfL_I^mW<FK_H0
06kfL_H006kgJ_M^mf[fK_L000QZm`03001Zm`0000QRf003001Rf6;H009Rf00:001F^EZjE[UJ^UJi
F[YF^EZjE[T3000024jJCY]>VU:kCYY>VdjJ0008BY/01@00BYa:W4ZlBY/00TZL00A:_4ZKBY`000=:
_0@00004C[a>g4Zl0008C]`02@00D_a>g5;LC]aBo4kLD]a>g0040009D_`20007D_`30009D_`00`00
D_aBo004D_`30002D_`00`00Oomoo`08Ool20004Ool01@00Oomoogoo00000goo0006Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0DOol0
1`009WhVWRIm:YhVORJN00H000040GT000000AL20000204g000J?AiM6SdNGQXm7Ud400007E;lEaeB
o5LMD_aG7E;lEaeBo000IaP006LHJcUW66/iIaQ[>FLHJcUW66/iIaP006LHJcUW66/iIaP00P00061c
5fkf001_5W<GK_Ic5flFLaM^mW<G001c5fkfLaM_5W<GK_Ic5flFLaL007<GKaH006keLaIbmG<F001c
5W;eLaI^mG<FL_Ec5P00LaIbmG<FK_Ec5W;eLaH007<FK_Ec5Vke001^mG<F001c5VkeLaI^mG<FK_Ec
5P00LaI^mG<FK_Ec5Vke001^mG<FK_Ic5P00K_MZmVkg001^mf[fK_MZeVkgJ_I^mf[F001Zef[gJ]H0
06;HI]QRf6KiH]P200003FKIH]QRf6;HI]T005ZjE[UJ^UJiF[YF^EZj0080000LE[T004jJD[]>VU:k
CYYB^djJD[]>VP00BY]:W4ZKBYa:VdZLBY]:W000B[a6VdZlAY]:_4JKB[`500002DkLB[a>g4ZlC]a:
_4kL001Bg@03C]`02E;MC]a>g4kLD]d005;lC]aBo@0400003TkLD_e>g000D]aBoDkLD_eBg5;mC]aB
oE;LD_d200000e;LD_d00003000045;LD_d005;mD]aBoE;lD_eBg5;mD_aBoE;L001Bo5;m0`0000IB
oE;LD_eBo5;m0007Ool50005Ool30004Ool000Ioo`03001oogoo009oo`03001oogoo00eoo`03001o
ogoo00=oo`03001oogoo01Eoo`8000069YhVORJN9WhVWP000`hL0P000P5i1`0000<NGAXm00000`00
0U<M00IG7E;lDaeC7ELMD_`2Dad00eLM0000000;JaT00`00JaU[6@06JaT00`00LaL00002KaH02G<G
KaI_5VlFLaM_5P00KaIc5`03KaH09W<GKaI_5P00LaM_5VlGKaH007;eLaD007<FL_Ec5W<ELaIbmG<F
LaD007;eLaIc5G<FL_Ec5P00LaIbmG<FLaEc5W;e001bm@00K_D2L_H03G<FK_EbmP00LaI^mW;fK_Ic
5VkfL_H007;f00=^mP04001ZmVkg0008J_L00`00J_MZm`02J_L00`00H]QRf002H]P00`00H]QRf006
H]P01@00F[YF^EZjE[T00P0000mJ^UZiF[X004jKCYYB^djJCY]>VU:kCYY>VdjJ00001dZK00@004ZK
BYa:W0@000=:_00;001>g4ZlC]a>_4kLB[a>g4jlC]`00008C]`400002E;lD]aBo4kLD_aBg5;lC]`0
0009D_`40007D_`00`00D_aBo007D_`30009D_`00`00Oomoo`040004Ool00`00Oomoo`0:Ool000Io
o`03001oogoo009oo`03001oogoo00eoo`03001oogoo00=oo`03001oogoo01Moo`06000VWRIm:YhV
ORJN0P0000<>70hM2O`00P0000<1N@0000001P0000dJ?AiN6SdNG@00EaeBo5LMD_aG7E;lEaeBo002
0000MeLMD_`006LHJcUW66/iIaQ[>FLHJcUW6000IaQ[>FLHJcUW66/iIaQ[>FLHJcT007<GK_Ic5flF
LaM^mW<GKaH006kfLaM_5W<GK_Ic5flFLaL007<GKaIc5fkfLaM_5P00K_D007;eLaI^mG<FL_Ec5Vke
001bmG<FK_Ec5W;eLaI^m@00K_Ec5VkeLaI^mG<FK_D006keLaI^mG<FK_Ec5Vke001^mG<FK_Ec5Vke
LaH007<FK_Ic5VkeLaI^mP00J_H006[fK_MZeVkgJ_I^mf[FK_L006[gJ]I^mf[GJ_L006KiH]P006;H
I]T00f;H00MVfF;HH]QRf000E[UJ^P0200005UJiF[YF^E[JE[UJ^P00D[]>VU:kCYYB^djJD[]>VU:k
001:W4ZKBYa:VdZL1P0001A:^djlBY]>_4ZkC[a:V`00B[a>g4ZlC]a:_4kLB[a>g4ZlC]`005;M0dkL
01IBg@00001>g5;m001BoDkLD_e>g5;mC]aBoDkLD_d005;mD]aBoDkLD_eBg0<0000BD]aBo@00001B
g5;mD]aBoE;LD_eBg000D_aBoE;LD_eBo5;m0`0000aBoE;L001Bo5;mD]aBoE;lD_eBg5;mD_`30008
Ool00`00Oomoo`0:Ool000Ioo`03001oogoo009oo`03001oogoo00Uoo`@000Eoo`<001Uoo`@00004
9WhVWRIn00033Q`700002@4h000000006SdNGAYM7Ud00002Dad00eLMD_aC7@0200001U;lDaeC7E<M
D_`000M[6@03001[6F/I00Q[6@04001[6@00LaL3KaH01G<GKaI_5P00LaL00flF02Yc5flFKaI_5P00
KaI_5flFLaM_5VlGKaH007;eLaIc5G<FL_Ec5W<ELaH007<FLaEc5W;eLaIc5@00L_Ec5W<ELaIbmG<F
LaD007;e001bmW<FK_D2L_H02@00K_IbmVkfLaI^mW;fK_H00003K_H01G;fK_I^mVkf000026[g00<0
06[gJ_L016[g00<006;H00002f;H0P00019J^UJiF[YJ^EZjE[UJ^UZiF[X004jKCYYB^djJCY]>VU:k
CYX600001DjkBY]>^dZK00002DZl00/004jlC]a:_4kLC[a>g4ZlC]a>_000009>g0<0009>g00>D]a>
g000D]aBo4kLD_aBg5;lC]aBo5;LD_`0009Bo0<000EBo08000QBo003001Bo5;l00<000EBo003001B
o5;l00MBo08000Yoo`03001oogoo00Uoo`001Woo00<007ooOol00Woo00<007ooOol02Goo00<007oo
Ool01Woo00<007ooOol06Woo0P0000<RO@000000100000<>7@Wl0000100000@0mP000CL1F0D00004
7Ud005LMD_`20000NELMD_aG7E;lEaeBo5LMD_`006LHJcUW66/iIaP006LHJcUW66/iIaQ[>FLHJcUW
66/i001[>FLHJcT007<GK_Ic5flFLaL007<GKaIc5fkfLaM_5W<GK_H006lFLaM^mW<GKaIc5fkf001_
5P00K_Ec5W;eLaI^mG<F001c5VkeLaIbmG<FK_Ec5P00LaI^mG<FK_Ec5VkeLaH007<FK_D006keLaI^
mG<F001c5VkeLaI^mG<FK_D006kfLaI^mG<FK_Ic5Vke001^mP00J]I^mf[fK_MZeVkg001Zmf[FK_MZ
ef[gJ]I^mf[G001Rf6KI00=Rf00II]URf6;HH]QVfF;H001R^000E[UJ^UJiF]YF^EZjE[UJfUJiF[X0
05:kCYYB^djJD[/00P0001e>VU:k001>_4ZKC[a:VdjlBY]>_4ZK001:VdjlB[]>_4ZKC[a:^djlBY/0
04ZlC]a:_4kLB[a>g4Zl00@0000BD_e>g5;lC]aBoDkLD_a>g000C]aBoDkLD_e>g5;mC]aBoDkL0`00
00UBg5;mC]aBoE;LD_e>g5;mD]`00P0000IBoE;LD_eBg5;mD]`400003e;mD]aBoE;lD_eBg5;mD_aB
o@00D_eBo5;mD]aBo@0300000e;mD_`00009Ool00`00Oomoo`09Ool000Ioo`03001oogoo009oo`03
001oogoo00Uoo`03001oogoo00Ioo`03001oogoo01aoo`06000RORJN9WhVWR9n1P0000@1N@000000
mP8000050CP001iM6SdJG@040002Dad01E;lDaeC7E<MD_`00e<M00=Bo000JaT00V/I00<006/IJaT0
26/I00<006/IJaT00f/I00<007<GKaH00VlF00D006lFKaI_5W<G00=_5P0R001_5VlGKaIc5flFKaM_
5W<G001_5flF001bmG<FLaEc5W;e001c5G<FL_Ec5W<ELaH007<FLaEc5W;eLaIc5G<F0003LaH03G;e
001bmW<F001bmVkfLaI^mW;fK_Ic5P00009^mP06L_I^mVkfK_IbmP000Vkf00<006[gJ_L00f[g00<0
06[gJ_L01F[g00<006[g00002F;H014006;HH]P005ZjF[UJ^UJiF[YJ^EZjE[UJ^UZi001>VTjK00<0
00=B^`0;DYX004ZKC[]:VdjkBY]>^dZKC[/00009B[`01000C]a>_4kL10000dkL00D004kLC]a>g5;L
00=>g008D]a>g000D]aBo4kLD_aBg0<0009Bo003001Bo5;l00MBo004001Bo000D_`40003D_`00`00
D_aBo007D_`00`00D_aBo0030005D_`00`00Oomoo`07Ool00`00Oomoo`09Ool000Moo`@000aoo`D0
00Aoo`03001oogoo01eoo`D000058WdVWP002Q`9o00200003@5i0EP000000AH0005H000NGAXm7UhJ
?AiM0080001iD_aG7E;lEaeBo5LMD_aG7E;lEaeBo000IaP006LHJcUW66/iIaQ[>FLHJcUW66/i001[
>FLHJcUW6F/iIaQ[>@00LaM^mP00KaIc5fkfLaM_5W<GK_Ic5`00LaM^mW<GKaIc5fkfLaL007<GK_Ic
5flF001^mG<FL_D006keLaIbmG<FK_Ec5W;e001^mG<FK_Ec5VkeLaI^m@00K_Ec5VkeLaI^m@00K_D0
06keLaI^mG<FK_Ec5P00LaI^mG<FK_Ic5VkeLaH007<FK_Ic5Vkf001ZeVkgJ_H006[FK_MZef[gJ]I^
mf[GJ_L006[g00000V;H01EVfF;HH]QRf6KIH]P006:hH]URf6;I001JfUJiF[YF^E[JE[UJ^UJiF]X0
0`0001MB^djJD[]>VU:kCYYB^djJ001:VdjlBY]>_4ZKC[a:Vdjl001>_4ZKC[a:^djl00L00003C]a>
_4kL009>g00?C[a>g000D_a>g5;mC]aBo4kLD_e>g5;l001BoDkL00<0000?C]aBoDkLD_e>g000C]aB
oE;LD_e>g5;mD]aBoDkL00@0000AD_eBo5;mD]aBoE;lD_d005;mD_aBoE;LD_eBo5;mD]aBo@030000
2U;mD_aBoE;LD_eBo5;mD]aBo@0027oo00<007ooOol02Goo000POol00`00Oomoo`0MOol600001R9n
9Yh000002O`:708000030ET0000000@000077UdJ?AYM6SdNGAXm00000U<M00EBo5<MDaeC7E;l00=C
7@8000Y[6@03001[6F/I00M[6@03001c5`00009_5P0WLaM_5VlFKaIc5`00KaM_5W<GKaI_5flFLaM_
5P00KaIc5flFKaM_5P00L_Ec5P00LaIbmG<FLaEc5W;e001c5G<FL_Ec5W<ELaIbm@00009c5P0@L_Ec
5W<FLaIbm@00K_Ic5VkfL_I^mW<FK_H006kfL_H3K_H00g;fK_H00004K_H01000J_MZm`0026[g00D0
06[gJ]MZm`0000IRf003001Rf6;H00=Rf008001F^EZjF[UJ^UJiF[YJ^@800004F[YJ^@00DYX3D[/0
3E:JD[]B^e:kDYX004ZKC[]:VdjkBY]>^dZK00H000E>_003001>g4kL00M>g003001Bg4kL009>g003
D]a>g4kL00@0009Bo005D]aBo5;lD_aBg002D_`00`00D_aBo003D_`30002D_`20008D_`00`00D_aB
o003D_`30002D_`00`00D_aBo007D_`00`00Oomoo`06Ool00`00Oomoo`09Ool0021oo`03001oogoo
01Yoo`<000=oo`03000RWR9n00H000033Q`0000000L0000>7UdJ?AiN6SdNGAXm001Bo5LMD_aG7E;l
EaeBo080000`EaeBo000IaQ[>FLHJcUW66/iIaQ[>@00JcUW66/iIaU[>FLHJcUW6F/iIaQ[>@00LaM^
mW<GKaIc5fkfLaL007<GK_Ic5flFLaM^mW<GKaH006kfLaM_5W<GK_Ic5flF0P0003ic5W;eLaI^mG<F
L_Ec5P00LaI^mG<FK_Ec5VkeLaH007<FK_Ec5VkeLaI^m@00K_D006keLaI^mG<FK_D006keLaI^mW<F
K_Ec5Vkf001^mW<FK_Ic5VkfLaH006kg001^mf[GJ_MZeVkgJ]MZm`00J_MZef[gI]MZm`000V;H00mV
fF;H001R^6;IH]QRfF:hH]URf000E[UJfUJiF[X00P00019J^E[JE[UJfP00D[]>VU:kCYYB^djJD[]>
VU:k001>_4ZKC[`400003DjkC[`004kLB[]>g4ZkC]a:^dkLB[]>g00000=>g009C[a>g4kLC]a>_000
C]aBo4kL00@0000@D_e>g5;l001BoDkLD_e>g5;mC]aBoDkLD_d005;mC]`300001U;LD_eBg5;mD]aB
o@80000:D]aBoE;lD_eBg5;mD_`005;LD_d300003e;mD_aBoE;LD_eBo000D]aBoE;lD_eBg5;mD_aB
o@020007Ool00`00Oomoo`09Ool0021oo`8001Qoo`<000Moo`07000RWR9n8YhROR:N8Wh0200000<0
mP0000001@0000HNGAXm000005<MD_`30005Dad00`00JaU[6@04JaT00`00JaU[6@09JaT01000JaT0
07<G0flF02Ic5flF001_5W<GKaI_5flFLaM_5P00KaIc5flFKaM_5W<GKaI_5flF001bmG<FLaEc5W;e
LaH007<FL_Ec5W<ELaIbmG<F001c5W;e0g<F00abmG<F001c5W;f001^mW<FK_IbmP00L_H3K_H017;f
K_I^mP001fkf00<006[gJ_L01F[g00<006[gJ]L00f[g00=Zef[g00000V;H00<006;HH]P01V;H00<0
05ZjE[T00P0000YJ^UZiF[YJ^EZjF[UJ^P00D[]BVP=B^`03DYYB^e:k00@00007C[a>^djkC[]>_4jk
00002Djl00<004kLC]`01TkL100000E>g5;LD]aBo4kL009Bg003D_`005;l009Bo005D]aBo5;lD_aB
g0030009D_`00`00D_`00006D_`30009D_`00`00D_aBo004D_`20002D_`00`00Oomoo`04Ool00`00
Oomoo`09Ool001moo`8001Ioo`<000]oo`8000078WhRWQim8YhROP001O/00`0000D1F0000000mP3e
008000036UdJ?AiN00H00009D_aG7E;lEaeBo5LMD_aG7E;l0080001gJcUW66/i001[>FLHJcUW6F/i
IaQ[>FLIJcUW66/i001[>FLHJcT007<GK_Ic5flF001^mW<GKaIc5fkfLaM_5W<G001c5flFLaM^mW<G
KaIc5fkf001_5P00K_Ec5W;eLaI^m@00K_Ec5VkeLaI^mG<FK_D006keLaI^mG<FK_Ec5P00LaI^mG<F
K_D006keLaH007<FK_Ic5VkeLaI^mW<F001c5VkfLaI^mW<FK_Ic5P00LaL006[gJ]I^mf[GJ_MZeP00
J]MZmfKGJ_MZef[gI]L006;H001R^6;IH]QRfF:hH]URf6;IH[QRf@02000045JiF]YJ^E[JE[UJfUZi
F]YF^E[J001B^djJD[]>VU:k0P0001MB^U:k001>_4jkC[a>^djlC[]>_4jk001:^dkLB[]>g4ZkC]a:
^dkLB[/004jl009>g0@0000AD]a>g000C]aBo4kLD_e>g5;lC]aBoDkLD_`005;mC]aBo@0400003DkL
D_d005;mD]aBoE;LD_eBg5;mD]aBoE;L00800003D_eBg00000<0000@D_eBo000D]aBoE;lD_eBg5;m
D_aBoE;LD_d005;mD]`300001U;LD_eBo5;mD]`000Eoo`03001oogoo00Uoo`007goo00<007ooOol0
4Woo0`0047oo00H0029n8YhROR:N8Wh200001@Gl000000000EP00P0000/0m@00000JGAXm6UdJ?AYM
6SdJG@0000]C7@03001[6@0000][6@04001[6F/IJcT2JaT05`00LaM_5P00KaIc5flFKaM_5W<GKaI_
5`00LaM_5VlGKaIc5flFKaM_5W<G00000VlG00h007;eLaIc5@00L_Ec5W<ELaIbmG<FLaD007;e0g<F
00EbmG<FLaH007;f00=c5P04001bmVkf0003K_H01G;fK_I^mVkf00001fkf00<006kf00001F[g00<0
06[GJ_L00V[g00IZef[gJ_MZmf[G000:H]P03P00H]P005ZjF[UJ^UZiF[YJ^EZjF[UJ^UZi0002D[/3
00001E:kD[YB^e:k00000djk00M>_4jkC[]>^djlC[/00007C[`500000dkLD]a>g002C]`01U;LC]`0
05;LD_a>g09Bg004D_a>g5;LD]`40007D_`00`00D_aBo007D_`40007D_`00`00D_aBo006D_`40008
D_`00`00Oomoo`04Ool00`00Oomoo`08Ool001moo`03001oogoo00moo`<001Aoo`@000068YhROR:N
000:70Gk0`0000<1F00000000`0005PJ?AiN6SdJGAXm7Uh005LMD_aG7E;lEaeBo5LMD_aG7E;lEad0
06/iIaQ[>FLIJcUW66/iIaU[>FLHJcT006/iIaQ[>FLIJcUW66/i001c5`00LaM_5W<GK_Ic5flFLaM^
mP00KaIc5fkfLaM_5W<GK_Ic5`00LaM_5W<GKaH006keLaH007<FK_Ec5VkeLaI^mG<F001c5VkeLaI^
mG<FK_D006keLaI^mG<FK_Ec5P80000kK_Ic5VkeLaI^mW<FK_D006kfLaI^mW<FK_Ic5Vkf001^mVlF
K_H006[GJ_MZeP00J]MZmfKGJ_MZef[gI]MZmf[G001Ve`00H]QRfF:hH]URf6;IH[QRf@00H]URf000
F[UJfUJiF]YJ^E[JE[UJfUZiF]YF^@0200005E:kD[YF^e:jD[]B^UJkD[X004jkC[a>^djlC[]>_4jk
C[`004kLB[]>g00400004djkD]a>_000C]aBo4kLD]a>g5;lC]aBg000D_e>g5;lC]aBoDkL00<0000B
C]aBo000D_eBg5;mC]aBoE;LD_e>g000D]aBoE;LD_eBg5;m0`00011BoE;L000005;mD]aBoE;lD_eB
g5;mD_`005;LD_eBo0@0000>D_eBg5;m001BoE;LD_eBo5;mD]aBoE;lD_d000Eoo`03001oogoo00Qo
o`007goo00<007ooOol037oo0`0067oo0P0000<NWP00000010000PGl200000LJ?AYM6SdJGAXm6Ud0
0008Dad200000e<M001[6@08JaT01000JaU[6F/i0f/I01I[>F/IJaT007<GKaI_5flFLaM_5VlGKaH0
06lFKaM_5W<GKaI_5flFLaL0009_5`04LaM_5VlGKaL2000027<FLaEc5W;eLaIc5G<F0003LaH01G;e
LaIc5W<F00000g<F00EbmW<FLaIc5P00009^mP06L_I^mVkfK_IbmP001fkf00<006kfK_H00Vkf00@0
06[g001Ze`=Zm`09J]MZmf[gJ_MZef[g001Zm`0000MRf00>001Rf6;HH]URf000F[UJ^UZiF[YJ^EZj
F[UJ^P800005F[T005:kD[]B^P03D[/015:jD[]B^`000djk00A>_4jkC[]>^`@000Q>g005001>g4kL
C]aBg003C]`015;L001Bg5;L0`0000IBg5;lD]aBo5;L0009D_`00`00D_aBo0030005D_`00`00D_`0
0007D_`40007D_`00`00D_aBo007D_`20004Ool00`00Oomoo`08Ool001moo`03001oogoo00Uoo`<0
01eoo`8000047WdRWQim7Yh600000`4g0000000500002QXm6UdJ?AiN001G7E;lEaeBo5LM0P0009AB
o5<MD_aG7@00JcUW66/iIaU[>FLHJcT006/iIaQ[>FLIJcUW66/iIaU[>@00JcT007<GK_Ic5flFLaM^
mP00KaIc5fkfLaM_5W<GK_Ic5`00LaM_5W<GKaIc5flFLaM_5P00K_Ec5VkeLaI^mG<FK_D006keLaI^
mG<FK_Ec5P00LaI^mG<FK_Ec5VkeLaH007<F001c5VkfLaI^mG<F001c5VkfLaI^mW<FK_Ic5P00KaI^
mW<GK_I_5P00K_L006[gI]MZmf[GJ_MVef[gJ]MZm`00J_QVef[g001RfF;HH]UR^6;I001RfF;HH]UR
f6;IH]P005ZiF]YF^E[JF[UJfP00G]YJ^E[J001F^e:jD[]B^UJkD[YB^e:jE[/004jlC[]>_0@0000E
C[]Bg000D]a>_5;LC[]Bg4jlD]a>^e;L001Bg4kLD_a>g5;LC]aBo4kL00<0000AC]aBo4kLD_e>g5;l
C]aBoDkL001>g5;mD]aBoDkLD_eBg00400002E;mD]aBoE;LD_eBg5;mD]aBo@02000015;lD_eBg5;m
0`00019BoE;l001Bg5;mD_aBoE;LD_eBo5;mD]`005;lD_eBg5;mD_`300000e;lD_d00003Ool00`00
Oomoo`08Ool001moo`03001oogoo00Moo`80029oo`<000047WhNWP0000021O/200000`5G0EP00003
00000aXm00000002000011YM001C7E<M0P001e<M00<006/IJaT00f/I00@006/IJaU[>@=[6@05JcU[
6F/I001[>@02JaT04`00LaM_5VlGKaIc5`00KaM_5W<GKaI_5flFLaM_5P00KaMc5flF009_5`0;LaM_
5P00KaL007;eLaIc5G<FL_D00002LaH01W;eLaIc5W<FL_D0009c5P06L_Ic5W<FLaIbmP000W<F00H0
06kfK_IbmVkf0006K_H00`00K_I^mP05K_H01@00J_MZmf[gJ]L00f[g00EZef[g001Zmf[G009Zm`03
001Rf6;H009Rf004001Rf6;HH]T3H]P01V;IH]P005ZiF[YJ^@800006F]YJ^E[JF[UJfP000e:k00EB
^U:kD[]B^e:j00@00008D[]>^e;LC[]B^djkD]`000U>g004001Bg4kLC]`400003DkLD]`005;lD]aB
o5;LD_aBg5;lD]aBo00000=Bo0@000=Bo003001Bo5;l00MBo003001Bo00000<000EBo003001Bo5;l
00MBo003001Bo5;l00<000EBo005001oogooOol0000:Ool001ioo`<000Eoo`<002Ioo`H00085n`04
1M/000000EP4000011Hm6UdF?AYM100001iBo5LMD_aC7E;lEaeBo5<MD_aG7@00JcUW66/i001[>FLH
JcUW6F/iIaQ[>FLIJcT006/iIaU[>FLIJcT20000HVkfLaL007<GK_Ic5flFLaM^mW<GKaH006lFLaM_
5W<GKaIc5flFLaL007<GKaH006keLaI^mG<F001c5VkeLaI^mG<FK_D006keLaI^mG<FK_Ec5Vke001^
mG<FK_Ic5P00LaI^mP00K_Ic5VkfLaI^mW<FK_H006kfLaM^mVlFK_Ic5`00K_L006[gJ]MZmfKGJ_MZ
ef[g001Zn6KGJ_MVef[hI]L006:hH]T006;IH]QRfF;HH]URf6;IH]QRf@00F]X200003UZiG]YJ^E[J
F[UNfUZiF]X005JkD[YB^e:jE[/2000055:jE]/005;LC[]Bg4jkD]a>^e;LC[/004jkD]a>_5;LC[]B
g4jlD]`5000045;mC]aBo4kLD_e>g5;l001BoDkLD_a>g5;mC]aBo4kL1000015BoE;LD_e>g5;mD]aB
oDkL001Bg5;mD]aBoE;LD_eBg5;m00@0000@D_aBoE;LD_eBo5;mD]aBo@00D_eBg5;mD_aBoE;LD_d4
00002U;lD_eBg5;mD_aBoE;LD_eBo0000Woo00<007ooOol027oo000NOol00`00Oomoo`02Ool3000[
Ool00`006WdJOP0300031O/700026Sd011YM6SdJ?@002e<M00<006/I00000V/I00E[>F/IJaU[6F/i
009[6@03001[>F/I009[6@0BJcU[6F/IJaT006lF001_5W<GKaI_5flFLaM_5P00KaMc5flF0VlG00Ic
5flFKaL007<GKaH2KaL01P00L_Ec5P00LaIbm@=c5P05L_Ec5P00LaIbmP03LaH01G;fLaH007<FKaH0
0g<F00<006kf00001Vkf00<006kfK_H01Fkf00@006kf001Ze`=Zm`05J]MZmf[g001Ze`03J_L01F[G
J_L006;H00000V;H00ERfF;HH]QRf6;I00=Rf00?H]T005[JF[UJfUZiF]YJ^E[JF[UJfUZi001B^U:k
00<0009F^`0=E]]B^P00C[]Bg4jkD[]>^e;LC[]B^djk00000dkL100001=Bg4kLD]`005;LC]aBg4kL
D]a>g5;LC]`005;LD_aBg5;lD]aBo00200000e;LD_`00009D_`00`00D_aBo004D_`20002D_`20008
D_`01000D_aBo5;l10000e;l00<005;lD_`01e;l00@007ooOol000Yoo`007Woo00<007oo00000P00
;goo0P0000<NOQYm00002`00010JGAHm6UdF?AYM001C7E;lEaeBo5<MD_aG7E;lDaeBo0800020JcUW
66/iIaU[>FLHJcUW6F/i001[>FLIJcUW6F/iIaU[>FLIJcUW6@00K_Ic5flFLaM^mW<GKaIc5`00LaM_
5W<GKaIc5flFLaL007<GKaIc5flFLaM_5P00K_D006keLaI^mG<FK_Ec5P00LaI^mG<FK_Ec5VkeLaH0
07<FK_Ic5VkeLaI^mW<F001c5VkfLaI^mW<FK_Ic5P00LaM^mVlFK_Ic5fkf001ZmVlGK_H006KGJ_MZ
ef[gI]L006KGJ_MVef[hI]MZmfKGJ_P006;IH]QRfF;HH]URf6;IH]QRfF;HH]T006;I001NfUZiF]YJ
^EkJF[UJfUZiG]YJ^@80000AE]]B^UKKD[YFfe:jE]]B^P00C[]Bg4jkD]a>^e;LC[]Bg004000054kL
D]a>fe;LC]aBg4kKD]`005;lC]aBoDkLD_a>g5;mC]`004kLD_d300004U;mD]aBo4kLD_d005;mC]aB
oE;LD_e>g5;mD]aBo@00D_eBg0<00005D_aBoE;LD_eBo00200001e;mD_aBoE;LD_eBo5;m00@0000@
D]aBoE;lD_eBg5;mD_aBo@00D_eBo5;mD]aBoE;lD_d30002Ool00`00Oomoo`07Ool001ioo`8003Ao
o`H000030MX0000000@000050AL00000000JG@026Sd20006Dad20002Dad00`00JcU[6@02JaT01F/i
JaU[6F/I00000f/I019[>F/IJaU[6F/iJaT006/I001_5VlGKaIc5flFKaL007<GKaH2KaL01W<GKaI_
5flG001_5P9_5`06LaM_5VlGKaL007;e0g<F00EbmG<FLaH007;f00=c5P05L_Ic5W<F001_5P03LaH0
1FlFLaH007<F00001Fkf00<006kfK_H01Fkf00<006kgK_H00Vkf00H006[GJ_MZm`00J]L3J_L026[G
J_MZmf[g001Zm`00H]T3H]P016;IH]QRf6;H0P000V;H00T005ZiF]YJ^E[JF[UJfUZiF]X00P0000=J
fP00D[X00UJk00aFfe:jE[]F^eKKD[X004jkD]a>^e:kC[/20002D]/04`00C]aBg4kLD]a>g5;LC]aB
g4kL001>g5;LC]aBg4kLD]a>g5;L00<000=Bo006D]aBo5;lD_aBg00025;l100025;l00<005;l0000
15;l0P000U;l00<005;lD_`01e;l00@005;lD_aBo0@000=Bo003001oo`0000Uoo`007goo00<007oo
Ool0<goo0P0000<FO@0000000`0000<1fP000000100000<JG@0000000P0000@F?@00D_aG7@<0002B
DaeBoE<MD_aC7@00JcUW66/iIaU[>FLH001W6F/iIaU[>FLIJcUW6F/iIaT006LIJcUW6@00K_Ic5flF
LaL007<GKaIc5flFLaM_5W<GKaH006lFLaM_5W<GKaIc5flF001_5P00K_Ec5VkeLaI^m@00K_Ec5Vke
LaI^mG<FK_D006kfLaI^mG<FK_Ic5Vke001^mP00K_Ic5VkfLaH007<GK_I_5VkfLaM^mVlF001_5fkf
K_MZmVlGK_H006KG001Vef[gI]MZn6KGJ_MVef[h001Zn6KG001Rf6;IH]QRfF;HH]URf000H]QRfF;H
H_URf000F[UNfUZiF]YJ^EkJ001NfUZiG]X005KKD[YFfe:jE]]B^UKKD[YFf`00D]a>^`<0000CD[]B
g5:kD]aB^`00C]]Bg4kLD]a>fe;LC]aBg4kK001>g5;lC]`01000011BoDkL001>g5;mD]aBo4kLD_eB
g5;lC]`005;LD_e>g0@0000?D_eBg5;m001BoE;lD_eBg5;mD_aBoE;LD_d005;m00@0000>D]aBoE;l
D_eBg000D_aBoE;LD_eBo5;mD]aBo@@00008D_aBoE;LD_eBo5;mD]aBo@8000Uoo`0087oo0P00=Goo
0P000QYm00DJOP000000007K00D000@F?@@000UC7@8000=[6@05001[6F/IJaU[>@03JaT03V/iJaT0
06/IJcUW6F/iJaT006lFKaL007<GKaH2KaL01W<GKaI_5flG001_5P9_5`06LaM_5VlGKaMc5`000VlG
00<007;eLaH00W<F00D007<FLaIc5W;f009c5P03001_5W<F009c5P08KaIc5W<F001_5W<FKaH000=^
mP03001^mVkf00E^mP05001^mVkfK_I^m`02K_H00`00J_L00003J_L01V[GJ_MZmf[gJ]L0009Zm`04
I]L006;HH]T3H]P01@00H]QRf6;HH]T00f;H00@005ZiF]YJ^@80009JfP06G]YJfE[J001Ffe:j0UJk
00AFfe:jE[]F^`<00003D]]Bg5;K009Bf`0<D]aBfe;K001Bg4kLD]a>g5;LC]aBg4kL1@0000UBg5;l
D]aBo5;LD_aBg000D]`00e;l00ABg5;lD_aBo0@000QBo003001Bo5;l00EBo0@000QBo003001Bo5;l
00ABo080009Bo003001Bo5;l00MBo08000Uoo`008Woo00<007ooOol0=7oo0P0000<FOAYn5Wd02@00
0aHm07LJGAHm001Bo5<MD_eC7E;lDaeBoE<MD_aC7E;m001W6000IaU[>FLIJcUW6F/iIaU[>FLI001W
6F/iIaU[>FLIJcUW6@00K_H006lFLaM_5W<GKaIc5flFLaL007<GKaIc5flFLaM_5W<G001c5flFLcM_
5P00K_Ec5P00LaI^mG<FK_Ec5VkeLaH007<FK_Ec5VkfLaI^mG<F001c5VkfLaM^mP00K_H006kfKaI^
mW<GK_I_5Vkf001^mVkgJ_I_5fkfK_MZmVlG001ZmfKGJ_QVef[gI]MZn6KG001Vef[hI]MZn6KG001R
f6;I0080000:H]QRfF;HH_URf6;IH]QRn@00F]X200003UZiG]YJ^EkJF[UNfUZiG]X005KKD[YFfe:j
E]/2000045JjE]/005;LD[]Bg5:kD]aB^e;LD[]Bg000D]a>fe;L1000015Bg5;lC]/004kLD_a>g5;m
C]aBo4kLD_e>g000C]aBoE;L00@0000@D_a>g000D]aBoE;LD_eBg5;mD]aBoE;L001Bg5;mD_`40000
0e;mD]aBo@0200002e;LD_eBo5;mD]aBoE;lD_d005;mD_`00`0000iBo5;mD]aBo@00D_eBg5;mD_aB
oE;LD_eBo5;m0P002Goo000SOol00`00Oomoo`0dOol700000`7J0000000400055Sd00`00DaeC7@08
Dad20003JaT04V/iJaU[6F/IJcU[6@00JaU[>FLIJcU[6F/iIaU[>F/I001_5P9_5`06LaM_5VlGKaMc
5`000VlG00Ic5flFKaM_5g<G0002KaL01g<GKaM_5flG001bm@00009c5P05L_Ic5W<FLaH00003LaH0
3FlFLaIc5W<F001c5VlFLaI_5W<F001^mP0000I^mP05001^mVkfK_I^m`03K_H01Vkg001^m`00J_MZ
e`=Zm`05J]L006[gJ_MVe`03J_L01000H]P006;I0f;H00ERfF;HH]QRf6;I009Rf003001NfU[I009J
fP09G]YJfE[JF]YNfU[I001F^eKK00<00003E]]FfUKK009Ff`04001Bfe;KD]`3D]/00e;LD]/00003
0007D]`02P00D_aBg5;lD]aBo5;LD_aBg5;l10001e;l00<005;lD_`01U;l100025;l0P001U;l1000
25;l00<005;lD_`00e;l0`0000=oo`00Ool027oo000TOol00`00Oomoo`0eOol00`005WdJOP040000
1@6i000000000?H00P000QHm00TJGAHm001Bo5<MD_eC7E;lDad00`000U<M07h006LIJcUW6F/iIaU[
>FLIJcT006/iIaU[>FLIJcUW6F/iIaT006LI001_5W<GKaIc5flFLaM_5P00KaIc5flFLaM_5W<GKaH0
06lFLcM_5W<GKaIc=flF001^mG<FK_Ec5VkeLaI^m@00K_Ec5VkfLaI^mG<FK_H006kfLaM^mW<FK_Ic
5`00KaI^mW<GK_I_5VkfLaL006kgJ_I_5fkfK_MZmVlGK_H006[f001Vef[gI]MZn6KG001Vef[hI]MZ
n6KGJ_QVef[h001RnF;HH]URf6;iH]QRfF;HH_URf6;I001Vn@00G]YJ^EkJF[UNfUZiG]YJ^EkJF[T2
00003eKKE[YJfeJjE]]F^U[KE[X005:kD]aB^e;LD[]Bg00200004U;KE_`005;lC]]Bo5;LD_a>fe;l
D]aBo000D_e>g5;lC]aBo@<0000BD_aBg000C]aBoE;LD_a>g5;mD]aBo000D_eBg5;mD]aBoE;L0P00
011BoE;L001Bg5;mD_aBoE;LD_eBo5;mD]`005;l001Bg0@0000?D_eBo5;m001BoE;lD_eBg5;mD_aB
oE;L001Bo5;m00<000Aoo`03001oogoo00Moo`009Goo0P00=Woo0P0000<JOAIm5Wd0300000@F?@00
DaeC7@<000IC7@05001[6F/IJaU[>@02JaT02`00JcUW6F/iJaU[>FLIJcU[6@00IaT00V/i00X006lF
KaM_5g<GKaH006lGLaM_5P9_5`05LaM_5P00KaMc5`03KaL01W<GKaL006lG001bmP=c5P05L_H007<F
LaI_5P03LaH02flF001_5W<FKaIc5VlFLaH006lF00001Fkf00@006kfK_I^m`=^mP07K_M^mP00K_I^
mfkf00000V[g00EZe`00J_MZmfKG00=Zm`05I]MZm`00J_P00002H]P01F;IH]QRf6;HH]T00V;H00L0
06;IH]P005[JG]YJf@02F]X00ekJF]UJfP0200001E[I001FfeKKE]X00eKK00AFfUKKE]/0009Bf`<0
009Bf`04E]aBfe;K0008D]`00`00D]aBo00300001U;lD]aBo5;LD_`000UBo003001Bo5;l00<000EB
o003001Bo5;l00IBo0@000QBo003001Bo5;l00EBo0<000Qoo`03001oogoo00Ioo`009goo00<007oo
Ool0=Goo100000@FO@000001fPD000035SdB700000<000=C7@05C_eC7E<MDae>o@02Dad200004V/i
IaU[>@00JcUW6F/iIaU[>FLIJcUW6@00IaU[>VLIJcYW6@80001bLaM_5P00KaIc5flFLaM_5W<GKaH0
06lFLcM_5W<GKaIc=flFLaL007<gKaL006keLaI^mG<F001c5VkfLaI^mG<FK_H006kfLaM^mW<FK_Ic
5fkf001^mW<G001_5VkfLaM^mP00J_I_5fkfK_MZmVlGK_H006[fKaMZmVkgJ_H006KGJ_L006[hI]MZ
n6KGJ_QVef[h001Zn6KGJ_P006;iH]QRfF;HH_URf6;I001VnF;HH_URf000F[UNfUZiG]YJ^EkJ001N
fU[IG]X005[KE[YFfeJjF]]F^UKKE[YJfeJj0P00015Fo5;KE]aBfeKlD]]Fg5;K001Bg5;lC]]Bo5;L
D_a>fe;l00<0000AD_aBg5;lC]aBo5;LD_a>g5;l001Bo4kLD_eBg5;lC]aBo@0400003e;LD_eBg5;m
D]aBoE;LD_d005;mD]aBoE;lD_eBg002000045;mD]`00000D_eBg5;mD_aBoE;LD_eBo000D]aBoE;l
10002goo00<007ooOol01Woo000XOol00`00Oomoo`0eOol200000aYm0000000300000`6i00000003
00034Sd2000;Dad03@00JaT006/iIaU[>F/IJcUW6F/iJaT006LI00=[>@09IaU[>F/iJcT006lG001c
5flF009_5`05LaM_5VlG001c5`03KaL017<GKaM_5`0016lG00H007;fLaH007<FKaH3LaH036lFLaH0
07<FKaIc5VlFLaI_5P00KaIc5`9_5P06001^mVkf001^mVkg0fkf00i^mfkfK_H006kgK_I^mfkfK_L0
06[g001ZmfKG0f[g00UVef[gJ_L006KGJ_MVmf[h00000V;H00iRfF;H000006;IH]QRfF;HH]URf000
F]YNfU[I0P0000=NfU[IG]X00UkJ00D005KKE]]FfeKJ00=Ff`800003E]/005;K009Bf`07E]aBfe;K
D]]Fg5;K00000e;L10000U;L00/005;LD_aBg5;lD]aBo5;LD_aBg00000=Bo0@000=Bo003001Bo5;l
00MBo003001Bo5;l00<000ABo003001Bo00000MBo0@000moo`03001oogoo00Ioo`00:Goo00<007oo
Ool0=Woo0P0000<JWQYm6Yh02@0000@F?A8l5Sd000=C7@06C_eC7E<MDae>oE<M0`00075[>FLIJcUW
6F/iIaU[>FLI001W6F/jIaU[>VLIJcYW6F/jIaU[>P00LaM_5W<GKaIc5flFLaL007<gKaIc5flFLcM_
5W<G001c=flGLcM_5g<gKaL006ke001^mW<FK_Ec5VkfLaH007<GK_Ic5VkfLaM^mW<F001c5fkfLaM^
mW<G001_5P00KaM^mVkgJ_I_5fkfK_L006lGJ_I^mf[fKaMZmVkg001Zn6KGJ_QVef[hI]MZn6KG001V
ef[hI]MZn6KG001Rf6;iH]P006;HI_URf6;iH]QVnF;HH_T005kJ0080000=F]UNfU[IG]YJfEkJF]UN
fP00F]]F^UKKE[X00P0000eJfeKJF_]FfP00D]]Fo5;KE]aBfeKlD]]Fg004000045;KE_aBg5;lD]]F
o5;L001>g5;lD]aBo4kLD_aBg5;l1000011Bg5;mD]aBo5;LD_eBg5;l001BoE;LD_eBg5;mD]aBo@@0
0008D]aBoE;lD_eBg5;mD_aBo@800004D_aBoE;LD_d3000COol00`00Oomoo`06Ool002Yoo`03001o
ogoo03Moo`@000046Wd000000KT:0003Dad40003Dad02@00JcU[6F/iIaU[>F/I001W6@03JcT02FLI
JcU[>F/iIaU[>@00JcX00002KaL01G<GKaI_5flG00000flG00Ec5flGKaM_5`0000M_5`03001_5W<F
009c5P0<KaIc5W<F001_5W<FKaIc5VlFLaH007<G0flF00Ec5flFKaH006kg00=^mP0>K_M^mVkf001^
mfkfK_M^mVkgK_I^m`00K_L000=Zm`0II]MZmf[g001Vef[gI_MZn6KGJ_MVm`00H]P006;HH]URf6;I
H]QRfF;HH]URf6;I00000ekJ00EJfEkJG]YNfU[I009NfP03001FfUKK00800008E]YJfeKKF]]FfU[K
001Fg0=Bf`09E]aBf`00001Fo5KK001Bg5;l00=Bg00:D_aBg5;L001Bo5;LD_aBg5;lD]`200000e;l
D]`00009D_`01000D_aBo5;l10000e;l00<005;lD_`01U;l00<005;l00000`005Woo00<007ooOol0
1Woo000[Ool2000hOol200000ajN0000000700000`hL4Sd>7005000024lMDai?7E<NCaeC7TlMDah2
0000NFLIJcUW6@00IaU[>VLIJcYW6F/jIaU[>VLIJcX006/jIaU[>P00LaM_5W<GKaH006lFLaM_5W<g
KaIc5flF001_5g<gKaMc=flGLcM_5`00KaL006keLaI^mW<FK_D006kfLaI^mW<GK_Ic5Vkf001^mW<G
K_Ic5fkfLaL007<G001^mf[fKaM^mVkg001_5f[fK_MZmVlGJ_I^mf[f001ZmP00I]MZn6KGJ_QVe`00
I]MZn6KGJ_QVef[hI]MZn6KG001Rf6KiH]QRnF;HI_URf6;iH]QVn@00I_T005kJF]UNfU[IG]YJfEkJ
F]UNfU[I0080000<F_]FfU[KE]YJneKJF]]FfU[k001Fg5;K0`00015BfeKlD]]Fo5;K001Bg5;lD]]F
o5;LD_aBfeKl001Bo4kL00<0000>D]aBo5;LD_aBg000D]aBo5;LD_eBg5;lD]aBo@@0000@D_aBoE;L
D_eBo5;mD]aBo@00D_eBg5;mD_aBoE;LD_d4000HOol00`00Oomoo`06Ool002eoo`03001oogoo03Mo
o`8000@NWPH000053Sd>718m3Q`00002Dad01DlMDaeC7E<MCad00e<M00E?7@00JaT006LI00=[>@09
IaU[>F/iJcUW6F/i001[>VLi009[>@05JcX006lGKaL00003KaL01G<GKaM_5flG000026lG00D006lG
KaL006lF00=c5P08001c5VlFLaI_5W<FKaH000=_5P09LaM_5VlFKaH006lF001^mVkg00=^mP0>001^
mVkgK_I^mfkfK_M^mP00J_M^mf[g001Ve`9Zm`0J001Vef[gI_MZn6KGJ_MVmf[hI]L006Kh001Rf6;I
H]QRfF;HH]URf6;I001RfF;H001Jf@=NfP04F]UNfUkJG]X2000035kJ001FfU[KE]]JfeKJF]]Ffe[K
E]YJf`8000=Ff`06E_aFfeKKE]]Fo0000U;L00IBo5;LD]aBg5;lD]`300001E;LD_aBo5;lD]`00e;l
00<005;lD_`015;l0P000U;l00<005;lD_`01e;l00@005;lD_aBo0@000Aoo`03001oogoo01Eoo`03
001oogoo00Ioo`00;Woo00<007ooOol0>7oo1@0000@RWP000001f@80000?4Sd>718m3Q`004lMDai?
7E<NCaeC7TlMDai?7E<N00800021IaU[>VLIJcYW6F/jIaU[>VLIJcX006/jIaU[>VLIJcYW6F/j001c
5`00LaM_5W<gKaIc5flFLcL007<gKaMc=flGLcM_5g<g001c>6lGLcQ_5`00K_Ec5P00LaI^mW<GK_Ic
5VkfLaL007<GK_Ic5fkfLaM^mP00KaIc5fkf001^mVkgJ_H006[fK_MZmVlGJ_I^mf[f001ZmVkgJ_I_
5f[f001Vef[h001Zn6KGJ_QVef[hI]MZn6KG001Vef[h001RnF;HI_URf6;iH]QVn@00I_URf6KiH]P0
05[IG]YJfEkJF]UNfP00G_YJfEkjG]T005KJF_]FfU[KE]YJneKJ0080000?F_/005KlD]]Fo5;KE_aB
feKlD]]Fo000E_aBg5;l00@0000?D]]Fo000D_aBg5;lD]aBo5;LD_aBg5;l001BoE;L00<0000>D]aB
o5;LD_eBg000D]aBoE;lD_eBg5;mD_aBo@@000Qoo`03001oogoo01Eoo`03001oogoo00Ioo`00;goo
00<007ooOol0>Goo0P0000<V_P0000001P0000<>718m3Q`00P0000=C7DlMDad00U<M00I?7@00001?
7TlM0002JcT02FLIJcU[>F/iIaU[>@00JcYW>@02JcT01V/jIcU[>F/iJcX0009_5`06LaM_5flGKaMc
5`001flG00@006lGKaM_=`=_5`0:001_5P00KaIc5VlFLaI_5W<F0002KaH01W<GKaI_5VlF001_5P=_
5`0aKaH006kf001^mVkgK_I^mfkfK_M^mVkg001^mf[gK_MZmfkg001Zm`00J_MVmf[hI]MZmfKgJ_QV
ef[g001Zn6KgI_P006;IH]QRfF;HH]T006;IH]QRnF;HH]URf000F]T00UkJ0P000ekJ00QNfEkJ001J
feKJF]]Ffe[K0P0000IJfe[kF]YJf`00E_`3E]/015KlE]]FfeKK100000YFo5;LD_aBo5KlD]aBo000
D_aBg0=Bo003D]aBo5;l00<000QBo003001Bo5;l00ABo08000eoo`03001oogoo01Eoo`03001oogoo
00Eoo`00<7oo0P00>goo0P0000<VWRJn9Yh0200000@B?@00Dai?7@<0001dCaeC?TlMDai?7@00IaU[
>VLIJcYW6F/j001[>VLIJcYW6F/jIaU[>VLIJcX006/j001c=flFLaM_5W<gKaH006lGLcM_5g<gKaMc
=flG001_5g<hKaMc>6lGLcQ_5`00K_Ic5fkfLaI^mW<GK_H006kfLaM^mW<GK_Ic5`00LaM^mW<GKaIc
5`00KaL006kgJ_I_5f[fK_MZmVlG001^mf[fKaMZmVkgJ_I_5`00J_QVef[hI]MZn6KGJ_QVef[h001Z
n6KGJ_QVe`00H]QRnF;HI_T006KiH]QVnF;HI_URf6Ki001NfP80000;G]UNnU[IG_YNfEkjF]UNnP00
F]]FfP0200003E[kE]YJne[JF_]FfP00D]]Fo5;KE_aBfeKl0080000@E]]Fo000E_aBfeKlD]]Fo5;K
E_aBfeKl001Bo5;LD_`400003e;LD_`005;mD]aBo5;LD_eBg5;lD]aBo@00D_eBg003000@Ool00`00
Oomoo`0DOol00`00Oomoo`05Ool0039oo`03001oogoo03Yoo`@000039[h000000080008:70@00009
Cae?7TlMCai?7DlNCae?7TlM00800006JcUW6F/i001[>VLi0V/i00Y[>VLiJcU[>F/j001[>VLjJcX0
009_5`03LaM_5`0000M_5`03001_5flg00=_5`0=KcM_5`00KcL006lFLaI_5W<FKaH006lFLaL00flF
00=c5`00KaL00VlG025_5VlGKaM_5`00K_M^mVkgK_I^mfkfK_L006kgJ_M^mf[gK_MZmfkg001Zm`00
J_QVef[gI_MZn6KGJ_L006[hI_L00VKh019Zn6Kg001Rf6;I001RfF;HH_URf6;IH]QRnF;HH]T005kJ
G]T3G]X01UkIG]YNfUkJG]UNfP800005F]YJfe[KF_]JfP02F]/01E[kF]X005KKE_`00`0000IFo5KK
E_]Ff`00D]`2D_`01UKlD]aBo5;lE_aBg0@000MBo003001Bo5;l00EBo0@001=oo`03001oogoo01Ao
o`03001oogoo00Eoo`00<goo00<007ooOol0>Woo00<002jn;[l01P000PXL0945o0XL001C7TlMDci?
7E<NCaeC?TlMDai?7E<n001[>P00JcYW6F/jIaU[>VLIJcYW6F/j001[>VLiJcYW>F/j001c=flF001_
5g<gKaMc=flGLcM_5`00KaMc>6lGLcQ_5g<hKaL006lGLcQ_5`00K_Ic5fkfLaH007<GK_Ic5fkfLaL0
07<GK_Ic5flFLaM^mW<G001_5`00KaMZmVkgJ_I_5f[f001ZmVlGJ_I^mf[fKaMZmP00J_M_5`00J_QV
ef[hI]MZn000J_QVef[hI]MZn6KGJ_P006Ki001VnF;HI_URf6KiH]QVnF;HI_T006Ki001NnU[IG_YN
fEkjF]UNnUkIG_X006;j001JneKJF_]JfU[kE]YJne[JF_]FfP0200003UKlE]]Fo5KKE_aFfeKlE]/0
05;KE_aBfeKlD]/300003e;KE_`005;lD]aFo5;LD_aBg5KlD]`005;LD_eBg004000HOol00`00Oomo
o`0COol00`00Oomoo`05Ool003Aoo`03001oogoo03Yoo`800004;[l^_Rjn;[h400032Q`2000024lM
Cai?7DlNCae?7TlMCah300001V/jIcU[>F/iJcYW>@9[>@80000:JcYW>V/jIcU[>VLjJcX006lG0006
KaL00`00KaM_=`03KaL03FlgKaM_5`00KcQ_5flhKcL006lFLaH007<G00=_5P03LaM_5P00009_5`06
KaI_5flGKaM_5P000VlG010006kgK_I^mfkf001ZmfkgJ_M^mf[gK_MZm`00J_M^m`9Zm`07001Zn6KG
J_L006[hI_L00VKh01=Zn6KgI_QVn6[h001RfF;HH_URf6;IH]QRnF;HH]T006KiH]P00002G]X01EkI
G]YNfUkJG]T00P0000INnUkIG_X005[kF]X2F]/00e[kF]YJf`0200003E[J001FfeKlE]]FneKKE_aF
feKk001Fo5;L00<00006D_aFo5;lE_aBo00025;l10007Goo00<007ooOol04Woo00<007ooOol01Goo
000eOol2000lOol01P00;[l^_S;O;[h^_`H000052Q`004lMDci?7@040000?TlnBae??P00JcYW6F/j
IaU[>VLI001W>F/jIcU[>VLiJcYW>F/jIcU[>P00LcM_5g<gKaMc=flGLcL007<hKaMc>6lGLcQ_5g<h
001c>6lGKcQ_5g<hKaL006kf001^mW<GK_Ic5fkf001^mW<GKaIc5fkfLaM_5P00K_H3KaL0?`00KaMZ
mP00J_I_5f[fK_MZmVlGJ_H006[gKaMZmflGJ_L006KGJ_QVe`00I]MZn6KGJ_QVef[hI]MZn000J_P0
06KiH]QVnF;HI_URf6Ki001VnF;HI_URf000G]UNnU[IG_YNf@00G]URnUkIG_YNf@00F]YJneKJF_]J
fP02000035kkF]YJn`00E_aFfeKlE]]Fo5KKE_aFf`<0000?D]]Fo5;KE_aBfeKlD]]Fo5;K001Bg5;l
D]aFo5;L0080029oo`03001oogoo015oo`03001oogoo00Eoo`00=goo00<007ooOol0>Woo2@000PGk
1@0000=?7TlnCah00TlN00=??TlNCah00P00015W>F/iJcT006LiJcYW>V/jIcU[>VLjJcYW>F/j001[
>P0000E_5`03001_=flG009_5`0=KcM_5flG001_>6lGKcQ_=flhKaM_>6lg00000flF00Ic5flFKaH0
06lGKaH3KaL00flFKaL00005KaL03000K_L006kgJ_M^mf[gK_MZmfkg001^m`=Zm`06K_MZm`00I_L0
06Kg0VKh00IZn6KgI_QVn6[h0002I_P01V[h001RfF;HH_URf0800007I_URf6;iH_UVnF;H00000UkJ
00aNf@00G]YNnUkIG_YNfUkjG]T005[KF_/20002F_/02U[JF_]Jne[k001FneKKE_aFfeKk0P000UKk
00/005KlD_aFo5;lE_aBo5KlD_aFo000009Bo0<002Aoo`03001oogoo015oo`03001oogoo00Eoo`00
>7oo00<007ooOol0>Woo00L003KO<[hfgcJn=]lb_P0300000`Gk1O`5n`0200005TlnBai??T/MCci;
7TlnBae??T/N001W6@00IcU[>VLiJcYW>F/jIcU[>VLi0P0000=[FVLjJeX00P0002=_5g<g001c>6lG
LcQ_5g<hKaMc>000LcQ_5flhKaMc>6lGKcQ_5`00KaL006kfLaM^mW<G001c5flFLaM^mW<GKaIc5`00
00=_5`0bK_I_5flGKaL006lGJ_I^mf[fKaMZmVkg001_5f[gKaMZmflGJ_M_5f[g001Vef[hI]MZn6KG
J_QVef[h001Zn6KGJ_QVe`00H]QVnF;H001Rf6KiH]QVnF;HI_URf6Ki001NnP800009G]URnUkIG_YN
fF;jG]UNnUkI0080000;F_]JfUkkF]YJne[JG_]JfP00E]]Fo00300003U[lE]]Jo5KKF_`005KlD]]F
o5;KE_aBfeKlD]/3000XOol00`00Oomoo`0AOol00`00Oomoo`04Ool003Uoo`03001oogoo03Yoo`80
0005=[hfgSJn=]hf_P0400031O/01000Cai?7Tln0dlN00=??TlNCah00P0000aW>F/jIcY[>VLiJcYW
>V/jIcT006LjJcX3IcX01F/jIcX006lG00000flG00e_=flGKaM_5`00KaM_>6lgKcQ_5flhKcL00003
KcP01P00KaI_5P00KaM_5P=_5`03KaI_5`0000M_5`0:001_5`00K_MZmfkgJ_M^m`00K_L3J_L02Vkg
J_MZmf[g001Zm`00I_QZn6Kg0VKh00EZn000I_QVn6[h00=Vn006001Rf000H_UVnF;H0V;i01=VnF;H
H_URnFKi001NnUkJG_YNfEkjG]YNnUkIG_YNfP00G_T00002F_/01E[JF_]Jne[kF]X00U[k0P000UKk
00eFo5KkE_]FneKlE_/005;lE_aBo5KlD_aFo002000/Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool0
03Yoo`8003aoo`07000b_SKO=[hfgc:n=]l0200000=;7TlnBad0100003E;?d/N001W>F/jIcU[>VLi
JcYW>@00IcY[FVLjJeYW>V]JIcY[FVLj001_5g<hKaMc>6lGLcQ_5`00KaM_>6lGLcQ_5flhKaMc>000
KcQ_5flhKaL006kf001_5W<GK_Ic5flFLaM^mP00009_5`0lK_I_5flGKaM^mP00JaL006[fKaMZmVkg
J_H006[gKaMZmflGJ_M_5f[gKaL006/H001Zn6KGJ_QVef[hI]L006KGJ_QVef[hI]MZn6KG001Rf6Ki
H]QVnF;HI_URf6KiH]QVn@00I_T006;jG]UNnUkIH_YNfEkj0P0000YNfF;j001Nne[JF_]JfUkkF]YJ
n`80000>F_X005KKF_aFfe[lE]]Jo5KKF_aFf`00D]]Fo0<002moo`03001oogoo00moo`03001oogoo
00Aoo`00?7oo00<007ooOol0>Woo2`0000<1fP0000000`0000M;7T/nBai;?T/NBci;7P0200000f/j
IcY[>P0200000fLjJcYW>P02IcX02F/jIcYW>VLj001W>P00KaM_=`03KaL02P00KaM_>6lgKcQ_5flh
KcM_>0001Vlh00<006lFKaL00VlG00A_5VlGKaL000M_5`09001_5flGKaL006[gK_MZm`0000=Zm`06
K_MZmf[gJ_M^m`000f[g00P006KhI_QZn6Kg001Vn6[h0fKh00IZn6Kh001Vn000H]P2H_T04VKiH]QR
nF;iI_T006KiH_UVn@00G_YNfUkjG]UNnP00H_YNn@9NnP03H_X005[k009Jn`08F]X00000G_]JnU[k
F_X000=Fn`05E_aFneKkE_]Fo003000bOol00`00Oomoo`0?Ool00`00Oomoo`04Ool003eoo`03001o
ogoo03Yoo`800005?]lj_SkN>[hng`0200008Aim0000007J0KX004/NBci;7T/oBai;?T/NBcm;7T/n
001[>P00JeYW>V]JIcY[FVLjJeYW>V]JIcX006LjIe]W>P0200006g<hKaL006lGKcQ_5g<hKaM_>6lG
LcP006lhKaM_>6lGKcQ_5`00JcP006kfLaM_5W<GK_H00002KaL0AVkfKaM_5flGK_H006/GKaQZmflH
JaL006[f001ZmflGJ_M_5f[gKaMZmflG001[66[gKaQZmf/H001Zn6KG001Vef[hI]MZn6KGJ_QVe`00
I]MZn000I_URf6KiH]QVnF;HI_T006KiH]QVnF;H001NfF;jG]UNnP00H_YNfF;jG]URnUkI001JfUkk
0P0000eJfUkkF_YNne[JG_/005[lE]]Jo5KKF_aFf`02000fOol00`00Oomoo`0>Ool00`00Oomoo`04
Ool003ioo`03001oogoo03]oo`800003>]hngS[N008jgPD0000;0MX00000Bci;7T/nBai;?T/NBci;
7P020002IcX01F/jIcYW>VLjJcX00fLj018006LjIeYW>VMKIcYWFP00KcL006lhKcM_>6lGKcQ_=flh
0007KcP01@00KcQ_>000KaH00flG00<006lGKaL01FlG00<006lGKaL00flG00<006kg00000V[g00I^
mf[gJ_MZmfkg0006J_L01@00I_L006KhJ_P00fKh00EZn6KhI_P006[h009Vn003001VnF;H009Rn@80
0008I_URnFKiH_QVnF;i001Nf@800006H_YNnEkjG_YRnUki0Ukj0P0000aJne[jG_]JnU[kF_YNne[j
F_/005KlE_/3000iOol00`00Oomoo`0=Ool00`00Oomoo`04Ool003moo`8003eoo`h00003Bci;7T/o
00@0000:Aai7?`00001W>V]JIcY[FVLjJeX200008fLjIe]W>V]KIcYWFfLjJe/006lhKaMc>6lGKcQ_
5g<h001_>6lGKcQ_5flhKaM_>000KcQ[66liJcP006kfLaL006lGK_H00flG04i^mVlG001_66[gKaQ[
5flHJ_M_6000KaMZmflGJ_M_5f[gKaMZm`00J_M_66[gJaQZmflHJ_L006KGJ_QVef[hI]MZn6KGJ_P0
06[hI_QZn6KGJ_P006KiH]P006;HI_URf6KiH]QVnF;HI_URf000G]URnUkIH_YNfF;jG]URnUkI001N
n@00F]YNne[jG_]JfUkkF_YNne[JG_/2000lOol00`00Oomoo`0=Ool00`00Oomoo`04Ool0045oo`03
001oogoo03]oo`03000ngT;N00<ngP04@]h002ZN:Yh600002dLoAai7?dLNAcm77TLoAah006LjJcX0
0VLj01<006MKIcYWFVLjIe]W>VMJIcYWF`00Ie/006lhKaM_>6lgKcP00007KcP00`00KcQ_>004KcP0
0`00KaH00006KaL00`00KaM_5`05KaL01000KaP006kg0f[g00=^mf[g00001f[g00<006[g00000fKh
00EZn6KhI_P006[h00=Vn00BJ_QVn000H_T006;hI_URnFKiH_QVnF;iI_URn000I_T005ki0Ukj00IR
nUkiG_YNnP00G_T2H_X02000F_YJne[jG_]JnU[kF_X2000oOol00`00Oomoo`0<Ool00`00Oomoo`04
Ool0049oo`03001oogoo03]oo`07000ngT;N?]e2gSkN@]h00P0000<VWP0000000`0000U77TLoAai7
?dLNAcm77TLoAah00P0000m[FP00Je]W>VMKIcY[FfLjIe]W>V]K001WFf<jIe/00P0001E_5g<hKaL0
06lGKcQ_5flhKaM_>000KcQ[66liJcQ_>6/HKcU[>000K_H00flG041^mVlGKaL006[gKaQ[5flHJ_M_
66/G001[5flH001_5f[gKaMZm`00J_M_66[gJaQZmflHJ_L006[gJaP006[hI]MZn6KGJ_P006[hI_QZ
n6KGJ_QVn6[hI]L006;HI_URf6KiH]QVnF;HI_URf000H]QVnF;h001NfF;jG]URnP80000:G_URnUkI
H_X005kkF]YNne[jG_/20012Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool004=oo`03001oogoo03]o
o`03000ngT;N00<ngP03@]hngP00008ZWPD00005Acm77TLoAai7?`0500002VMKIcYWFVLjIe]W>VMJ
IcYWF`001VMK00<006lG00001flh00<006lhKcP01Flh00<006/i00001FlG00<006lGKaL01FlG00T0
06/HKaQ[5flH001^mf[g000026[g00H006/HJ_MZn000J_P2I_P00`00J_QVn002I_P03f[hI_QVn6Kh
001Vn000H_UVnF;hI_URnFKiH_P00002I_T02F;iI_T006;jG_UNnP00H_YNn@03H_X01EkiH_X005kk
F_X00P00AGoo00<007ooOol02goo00<007ooOol00goo0014Ool00`00Oomoo`0kOolD000034<o?ai3
?clN@cl006MKIcY[FfLjIe]W>P800003Ie]S>VMK009WF`0GHcYWFfMK001_5flhKaM_>6lGKcQ_5`00
JaQ_>F/hKcQ[66liJcP006/hKcU[>0020002KaL0<`00J_M_66/GKaQZmflHJaL006/GKaQ[5flHJaM_
6000KaL006lHJ_M[66[gKaQZmf/H001[66[gJaQZmf/H001Zn6KG001Vn6[hI]MZn6KhJ_QVe`00I_QZ
n6Kh001Rf6KiH]QVn@0200004V;HI_URn6KiH]QVn@00H_X006;jG_URnUkIH_YNnF;jG]URnP8004Mo
o`03001oogoo00]oo`03001oogoo00=oo`00AGoo0P00?7oo00@004;N@]i2g@=2gP06@]d002jN<[h^
WS:n100000Po7d<o?am37clO@clo7d<O0P0000AW>VMJIcX000UWF`03001SF`0000E_>003001_>6lh
00I_>009001_>F/hKcU[>Fli001_5`0000I_5`0:001[66lHJaM_66/HKaQ[5flH0007J_L02P00JaQZ
mf[hJ_M[66[g001Vn0000fKh00EZn6KhI_QVn00000=Vn006J_P006KiH_UVn@000fKi00URnFKiI_UV
nF;iI_T006;jG_T00f;j00ENnF;jH_YRnP0004Yoo`03001oogoo00Yoo`03001oogoo00=oo`00Agoo
00<007ooOol0>Woo0P0000I6gT;MA_i2gDKN@]d2000013:n;Yhb_RjN0`0000`o7T<o?ai3?clN@clo
7T<o?ah006Lj0002Ie/01V<jIe]WFfMKHcYWF`800003He]WO6=K0080001HKcQ_5`00JaQ_>F/hKcQ[
66liJcQ_>000KcU[>6liJcQ_>F/hKcT006lHJaM_66[gKaQ[5flH001_66/GKaQ[5flHJaM_6000KaP0
06/HJ_M_66[gJaP006/HJ_M[66[gJaQZmf/HJ_L006KhJ_QVef[hI_QZn6KG001Vn6[hI_QZn6KhJ_P0
06Ki001VnF;HI_URn6KiH]QVnF;hI_T006LI001RnUkIH_YNnF;jG]T2001<Ool00`00Oomoo`09Ool0
0`00Oomoo`03Ool004Qoo`03001oogoo03]oo`030012gT;M0092gPL00003;Yhb_P0000800005@clo
7d<O?am3?`040008Ie/02`00HeaSFfMLHe]SG6=KIe`006lh00001flh00/006liJcQ_>F/iKcU[>6li
001[>@0000E_5`09001_66/GKaQ[66lHJaM_600000=[600B001Zmf[gJ_L006/HJ_MZn6[gJaQZmf[h
J_L006[h001Vn6[h0fKh00EZn000I_QVn6[h00=Vn003J_P006Ki009Vn@0:H_UVnFKiI_URnFKi001V
nF;i0002H_X015kiH_YRnP00Cgoo00<007ooOol027oo00<007ooOol00goo0019Ool00`00Oomoo`0k
Ool400001dKMA_i2gDKn000f_S:N00X00004>alfoc/O=al20003Ie/07V<jIe/006MLHe]WO6=KIeaS
FfMlHe]WG000KcU[>6lhJaQ_>F/hKcP006liJcQ_>F/hKcU[>6li001_FP9[>@12001_66/GKaP006lH
JaM_66/GKaQ[5flHJaL006/HKaQ[6000J_M[66[g001Zmf/HJ_M[66[gJaQZm`00J_M[66Kg001Vn6[h
I]MZn000J_QVn6[hI_QZn6KhJ_P006[h001VnF;hI_URf6KiH_QVn@00IaURn6KiH_P005kiH_YNf@00
D7oo00<007ooOol027oo00<007ooOol00goo001:Ool2000lOol00`00A]i6g@02A]d00dKNA]e6g@02
0005=[h40003>al013LO>alk7c/O0P0000]WF`00001SG6=KIeaSFf=LHe]WG6=K00800003He`006lh
00A_>009001_>F/hKcU[>FliJcQ_>@0000A[>@0=001_5flG001_66/GKaQ[66lHJaM_66/H00001F/H
00/006[g001Zmf[hJ_M[66[gJ_QZm`0000=Zn006JaP006KhI_QZn0000VKh00IZn6KhI_QVn6[h0002
I_P00`00H_UVn@02I_T01F;iI_T006KiH_T00fKi00@006;j0000059oo`03001oogoo00Qoo`03001o
ogoo009oo`00C7oo00<007ooOol0>Woo0P0000U2gDKnA]e6oT;MA_i6g@00<Yh00cJn00<bWP000000
2`0000iSFfMLHe]WO6=KIeaSFfMlHe/005mLHgaOG6=l0P0000a[>6lhJaP006/hKcU[>6liJcQ_>@00
KeX3JcT0@6mJJcT006[g001[5flHJaM_66/GKaQ[5`00JaQ_66/HKaQ[66lHJaP006[gJaQZmf/HJ_M[
66[g001Zmf/HI_M[66[gJaP006[h001Zn6KhJ_QVn6[hI_QZn000J_QVn6/II_P006;HI_URn6Ki001W
6F;hI_URn6LIH_QVn@00EGoo00<007ooOol01goo00<007ooOol00Woo001=Ool00`00Oomoo`0kOol0
1@00A]e6gDKMA]h03`0000Hbobkn;_l^oc;o;_h200001FMLHe]SG6=KIe`00P001f=L00X006lh001[
>6liJcU_>F/hKcT000Q[>@09001[5flHJaQ_66/GKaQ[600000M[600:001[6000J_M[66[gJ_QZmf/H
0002J_P01V/HJ_QZn6[hJaP0009Vn006J_QVn6KhI_QZn0000VKh00YZn6KhI_QVn000H_UVn@00I_UR
n@=Vn@03H_UVn@0005Ioo`03001oogoo00Moo`03001oogoo009oo`00CWoo00<007ooOol0>goo1000
00]:oTKMB_i6g@00=[djgSZn>]hf_C[N00H00006;_hc7bkn<_l^oS<O0P0001ISF`00001SO5mLHgaO
G6=lGeaSO5mLHgaOG000JcQ_>F/hKcU[>6li001_FP=[>@10KeY[>F/iJcT006Li001[5flHJaM_66/G
001[66lHJaQ_66/HKaQ[6000JaQ[6F/H001Zmf/HJ_M[6000JaQVmf/HJ_M[66KgJaP006/H001Zn6Kh
J_QVn6[hI_P006KhJaUVn6[hI_Q[6@00I_T006LIH_QVnF;hIaURn6Ki001HOol00`00Oomoo`06Ool0
0`00Oomoo`02Ool004moo`8003aoo`030016gDKM00E6g@03000j_SZn00@j_P80008NG@X000YSG080
0007Ge`006/iKcU[>6li000026/i00@006LjJcY[>P800004KaQ[66lH0007JaP02@00JaQ[66/I001Z
n6[gJaP00002J_P02V/HJ_QZn6[hJaP006/HJ_Q[60000VKh00EZn6Kh001Vn6[h00=Vn006J_QVn6Kh
001VnF;i0fKi00=RnFKi0000FWoo00<007ooOol01Goo00<007ooOol00Woo001AOol00`00Oomoo`0j
Ool05000A]e:oTKMB_i6gD[nA]d003Jm>]hj_S[N=[djgSZn000JGAin7Ud200001RKO9]hVgb;N9]lV
gP800006HgaOG6=lGeaSO5mL0P0000AOOEmLGgeKG0800003KcT006mJ00=[>@10KeY[>F/iJcT006Li
JcYW>F]JIcU[>P00KaP006lHJaQ_66/HKaQ[66lH001[6F/HJaU[66/I001[6000JaQVmf/HJ_M[66Kg
JaP006/HI_Q[66Kh001Vn6[hI_P006KhJaUVn6[hI_Q[6FKhJ_P006/I001VnF;hIaURn6Ki001LOol0
0`00Oomoo`04Ool00`00Oomoo`02Ool0059oo`03001oogoo03Yoo`030016gDKM0096g@d0008NG@L0
008VgP80009SG080009OG@07GeaOGEmMGeeOG5mM000026/i00<006LjJcX00V/j00EW>V/jJcY[>P00
00M[6004001[66/HJaT3JaP01F/I001Zn6[hJaP00f[h00e[6000JaQZn6/HJ_Q[66[h001Vn000I_QZ
n003I_P01F[hI_QVn000J_P00VKh00<006KiH_T00VKi00<007ooOol0FWoo00<007ooOol017oo00<0
07ooOol00Woo001COol00`00Oomoo`0jOol4000034[mA]e:oTKM000j_CkN>[dngSZm?]hj_@P00003
7[hJW@0000D00008GgeKG5mmGeaOOE]LGgeOG0800005Fgh006/iJcU_FP03JcT0?@00IcU[>VLiJeYW
>F/jIcU[FP00Ic/006lHJaQ_66/HKaP006/IJaQ[6F/HJaU[66/I001[6@00JaQZmf/HI_M[66[g001V
n6/HI_Q[66KhJaQVn000I_Q[6FKhJ_QVn6/II_QZn000JaUVn6/II_P006;hI_URn00005ioo`03001o
ogoo00Aoo`03001oogoo005oo`00E7oo0P00>goo00H004KMB]e:gD[mA]d2B]d2000023kN?[hngSZn
?]hn_P008Wd29Wh500001QZM7[hJ_Ajn6Yd0009OG@04GeaOGEmMGed20004Fed20003JcT00`00IcY[
>P02JcX00fLjJcY[>P020003IcX01@00JaQ[66/H00000V/H00I[6F/HJaQ[66/I0003JaT04000J_QZ
n6/HJ_P006[hJaQZn6/HJ_Q[66[h001Vn0000fKh00EZn6KhI_P006[h00=Vn005J_QVn000I_T0001P
Ool00`00Oomoo`03Ool00`00Oomoo`01Ool005Ioo`03001oogoo03Uoo`80000CB_i6gD[mA]e:oTKM
B_d003kN>[dngSZm?]hj_@008UdVOR9m9Wh01`0000HN_QZM000005mmFe`20000Ae]NEeeKOU]MFeiG
GE]nFed006/i001W>F/jIcU[FVLiJcYW>@00IcYW>fLjIe]W>P00JaQ_66/H001[66/IJaQ[6F/HJaT0
06/IIaQ[>FLH001Vmf/HJ_L006KhJaQVn6/HI_Q[66Kh001Vn6/II_P006KhJaUVn6[h001[6FKhJaUV
n6/II_Q[6FKh0000HGoo00<007ooOol00goo00<007ooOol00Goo001GOol00`00Oomoo`0jOol01@00
B]e:gD[mA]d03P0000<VOP0000002P002U]M0P0000EW>V/jJcY[>VLj009[>P03001W>VLj00EW>P05
001[6000JaQ[6@03JaP00f/I001[6@02JaT056LIJaU[6@00J_P006[hJaQZn6/HJ_Q[66[h001Vn6/H
I_Q[6000J_P2I_P00`00J_QVn002I_P01F[hI_QVn6Kh0000Hgoo00<007ooOol00Woo00<007ooOol0
0Goo001HOol00`00Oomoo`0jOol400003TKMB_i:gD[m0012gSjm@]hn_D;N?[d002Im:Yh:00002a9l
5Yd00000EeeKOU]MFeiGGE]nFed00P0000MGGU=M001W>F]JIcU[>P020000=6LjIc]W>VMKIcYW>fLj
Ie]W>P00JaQ[6F/HJaU[66/IJaP006LHJcUW66/IIaQ[>FLH001Vn6/HI_Q[66KhJaQVn000I_Q[6FKh
JaUVn6/I001Zn000JaUVn6/II_Q[6FKhJaUVn000IGoo00D007ooOomoo`0000=oo`00FGoo0P00>goo
00@004[MB]e:o@=:g@03B_d003kN008ngP03?[hngSkN00800004:YhZORZN:Wh<0002Fed30002Eeh0
0e=NEeiGGP0200000f/j001W>P09IcX00`00Hc/00003JaP00f/IJaP00002JaT066LIJaU[6F/IIaT0
06LI001Zn6/HJ_Q[66[hJaP006/HI_Q[66KhJaQVn6/H001Zn0=Vn005J_QVn6KhI_P0001WOol01000
Oomoo`000goo001KOol00`00Oomoo`0iOol03@00B_i:gD[mA]e:oT[MB_d004;N?[e2gSjm00L00003
9WdZWP0000H000033Wd0000000800009DeeGGU<mEeiCGEMNDceGGU=M00800009Ie]W>VLkIcYWFfLj
Ic]W>VMK0080000ZHcYW>f<j001[66/IJaP006LHJcUW66/IIaQ[>FLH001W6F/jIaT006KhJaQVn6/H
001[6FKhJaUVn6/II_Q[6@00JaT006/II_Q[6FKhJaUVn000J7oo00@007ooOol000=oo`00G7oo00<0
07ooOol0>Goo00D004[MB]e:oD[M00L00005@]e2gT;N@]h00002;Yh?0002Eeh00e=NEeh000030000
0dlnDeh00007IcX02P00Ic]S>fLkHcYW>f<k001[60000V/I00IW6F/IJaU[6FLI0004IaT04P00JaQZ
n6/H001[66KhJaQVn6/HI_Q[6000JaUVn6/I001Zn0=Vn003001oogoo06Qoo`03001oo`0000=oo`00
GGoo00<007ooOol0>Goo100000a:gDkmB]e:o@00@]hn_D;N?[e2gSjm@]h20002;Yh00bim;Yh^WP07
00000`Xl0000000400001e=OCciCGTlnDem??U=N0080000`IcYW>fLjIe/006LkHcYW>f<jIc]S>VLk
HcX006LHJcUW66/IIaQ[>FLH001W6F/jIaU[6FLIJcX006/H001[6FKhJaUVn6/II_Q[6@00JaUVn6/I
I_P006KhJaUVn000K7oo00<007oo00000Woo001NOol00`00Oomoo`0iOol02000B_e:gD[mB]e:oD[M
B_d20002@]h01T;M@]i2gT;N@]d000D^WP03000>700000H0008:?08000=??P08Dei??TlnCciCGTln
001W>P800007Ic]S>fLkHcYW>f<kIc/00P0000=S>`00IaT00f/I00=W6@00IaT01fLI018006/HI_Q[
66KhJaQVn6/H001[6FKhJaUW66/II_P006Kh001^Ool20002Ool005moo`8003Yoo`08001>oD[MB_e:
gDkmB]e:o@d0008^WP03000=o0hM00/00005Dem??U=NCciCG`040000;6<jIc]S>VLkHcYW>f<jIc/0
06<kGa]S?5lk001W66/iIaP006LIJcYW6F/IIaU[>VLIJaT006Lj001[6FKhJaUVn6/I001[6FKhJaUV
n6/II_Q[6FKh001_Ool20002Ool0065oo`03001oogoo03Qoo`03001:oD[M00@0000;B_e:g@00@]e2
gT;M@]i2gD;N@]d00002<Yh500023Q`500000`HL1S`000060002Bch024/oBch006<kIc]S>VLkHc/2
0006Hc/00`00IaT00008IaT04P00IaYW6FLI001[66KhJaP006/II_Q[6FLHJaUVn6/IIaP0071oo`80
009oo`00HWoo00<007ooOol0>7oo0P0000M:gDkmB]a>oD[MC_e:g002000034;N@[e6gT;M@]i2_@00
<Yhb_RjM<[hbWPX0000<2S`66`Xl001;?d/NBcm;7T/oBai;?d/N0P0002MW>`00001O>f<kGa]S?5lk
Hc]O6f<lGc/006LIJcYW6F/IIaU[>VLIJaT006LjIaUW6VLIIcX006/I001[6FKhJaUVn6/II_Q[6FKh
0000KGoo100017oo001SOol00`00Oomoo`0hOol2000044[MB_e:gD[mB]e:oD[MB_d004;N@]e2gT;M
@]i2g@001C:N0P0000<F?A8m00002P0000=;?T/oBch00T/n10002F<k0P0000=O>`00IaT016LI0P00
00EW6VLIIaUW6FLJ009W6@0:001[6FKhJaUW66/II_Q[6FLH001ZOol40008Ool006Aoo`8003Yoo`80
0004C_e:g4kmB]dC00000a8L5Sd0000500000`HK000000050000:4<NAam37TLo001S>elKHcaO>f<k
Ga]S?000GcaO6f<lGa/006LIJcYW6@00IaUW>VLIIaYW6FLjIaUW6P00IcX006/II_Q[6FKhJaUVn000
Igoo100037oo001VOol00`00Oomoo`0hOol5000COol:000030HL1Q/00000Aam77TLOAai77dLNAal0
00AS>`80000;GcaO>ellGc]O?5lk001W6@00IaUW6P03IaT03FLJIaUW6@00IaYS6VLJ001[6FKhJaUW
600006Aoo`@0011oo`00Igoo00<007ooOol0=goo00<007ooOol06Goo300000Q37TLo@ai77d<NAcl0
06<k0P0001aO6ellGa]S?5lKGcaO6f<lGa/006LIIcYW6FLJIaUW>VLIIaX006LjHaUW6V<I001Vn6/I
I_P0065oo`@001Aoo`00J7oo00<007ooOol0=Woo00<007ooOol06goo1P0000<670Gk00002@0000UO
?5lkGcaO>ellGc]O?5lkGc`00P0000=K?000IaT00VLI00IW6VLIIaT006LJHaX3IaX016<J001W6000
GWoo100067oo001YOol2000fOol00`00Oomoo`0MOol600002PGk1Q`5n`00?_i37ckn@alnoT<O0P00
00EO6f<lGa]O?5lK00800004GcaK6ellFa`200003FLjIaUW6P00IcYS6FLJHaUW>V<IIaYS6@0005ao
o`<001aoo`00Jgoo00<007ooOol0<goo00<007ooOol07goo2P0000I2ockn@alnoT;o?_h2000015ll
000005/L0U/l00YO?5/LFcaK?5ll001W6@00IaYS6P=W6P04HaYW6VLJ001IOol4000OOol006aoo`03
001oogoo039oo`03001oogoo025oo`@000031O/6700000X0000EGcaK75llFa]O?5/LGcaK6ellFaaO
?000IcYS6FLJHaUW>V<IIaYS6@0005Ioo`@002=oo`00KGoo00<007ooOol0<Goo00<007ooOol08goo
10000PGk00X5o000>_ljoSko>_hjoc[n?_l0009K?006GcaK75/lFcaO?5/L0P0000=K?000IaX00VLJ
00AS6VLJ000005=oo`@002Moo`00KWoo0P00<Goo00<007ooOol09Goo200000`jgSko>]hnoc[N?_l0
05llFaaO?5/KGc`200002ELLFceG75/m001W>V<IIaX0001AOol4000[Ool0071oo`03001oogoo02io
o`03001oogoo02Moo`800085n`H00004>_ljoSko0002Fc`20002Fa`025/lFaaK75/LFc`006LJ001>
Ool4000_Ool0075oo`03001oogoo02eoo`03001oogoo02Uoo`8000061O/5o0GK000fgS[O1P0000UG
75/mEaaK?ELLFceG75/mEa`00P00Bgoo1000<goo001bOol00`00Oomoo`0/Ool00`00Oomoo`0[Ool2
00002PGl1O/003KN>]lfgS[N=]hjg`000U/L00EK?5/LFaaK75/l008004Uoo`@003Moo`00Lgoo0P00
;7oo00<007ooOol0;Goo100000HfgS[O=]hjocKN>]l200000eLLFcd000020018Ool3000kOol007Eo
o`03001oogoo02Uoo`03001oogoo031oo`/004Moo`@003ioo`00MWoo00<007ooOol0:7oo00<007oo
Ool0OWoo1000@Woo001gOol00`00Oomoo`0WOol00`00Oomoo`1jOol40016Ool007Qoo`03001oogoo
02Ioo`03001oogoo07Ioo`@004Yoo`00NGoo0P009Woo00<007ooOol0LWoo1000CWoo001kOol00`00
Oomoo`0SOol00`00Oomoo`1^Ool4001BOol007aoo`03001oogoo029oo`03001oogoo06]oo`<005Io
o`00OGoo00<007ooOol08Goo00<007ooOol0Igoo1000FGoo001nOol2000QOol00`00Oomoo`1SOol4
001MOol0081oo`03001oogoo01ioo`03001oogoo05moo`@0065oo`00PGoo00<007ooOol07Goo00<0
07ooOol0Fgoo1000IGoo0022Ool00`00Oomoo`0LOol00`00Oomoo`1GOol4001YOol008=oo`8001ao
o`03001oogoo05=oo`@006eoo`00QGoo00<007ooOol06Goo00<007ooOol0D7oo0`00LGoo0026Ool0
0`00Oomoo`0HOol00`00Oomoo`1<Ool4001dOol008Moo`03001oogoo01Moo`03001oogoo04Qoo`@0
07Qoo`00R7oo0P005goo00<007ooOol0A7oo1000O7oo002:Ool00`00Oomoo`0DOol00`00Oomoo`10
Ool40020Ool008]oo`03001oogoo019oo`03001oogoo03eoo`@008Aoo`00S7oo00<007ooOol04Goo
00<007ooOol0>Goo1000R7oo002=Ool2000AOol00`00Oomoo`0fOol3002<Ool008moo`03001oogoo
00ioo`03001oogoo039oo`@008moo`00T7oo00<007ooOol03Goo00<007ooOol0;Woo1000Tgoo002A
Ool00`00Oomoo`0<Ool00`00Oomoo`0ZOol4002GOol0099oo`03001oogoo00]oo`03001oogoo02Io
o`@009]oo`00Tgoo0P002goo00<007ooOol08Woo1000Wgoo002EOol00`00Oomoo`08Ool00`00Oomo
o`0NOol4002SOol009Ioo`03001oogoo00Moo`03001oogoo01Yoo`@00:Moo`00Ugoo00<007ooOol0
1Woo00<007ooOol05goo0`00Zgoo002HOol20006Ool00`00Oomoo`0COol4002^Ool009Yoo`03001o
ogoo00=oo`03001oogoo00moo`@00;9oo`00Vgoo00<007ooOol00Woo00<007ooOol02goo1000]Woo
002LOol01@00Oomoogoo00002Goo1000^Woo002MOol200000goo001oo`04Ool4002nOol009moo`80
0003Ool0000000800<9oo`00X7oo0P00aWoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol0
0?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {290.938, 0}} -> {-0.0883945, 0.0137197, \
0.00364067, 0.00364067}}]
}, Open  ]],

Cell[TextData[{
  "Another non-trivial similarity reduction for the FP equation follows from \
the subgroup ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k3",
            FontSlant->"Italic"], "=", "1"}], TraditionalForm]]],
  ". The infinitesimals for this subgroup read"
}], "Text",
  CellTags->"nontrivial similarity reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(inf1 = 
      \({{\(xi[1]\)[v, \[Tau], P], \(xi[2]\)[v, \[Tau], P]}, {
              \(phi[1]\)[v, \[Tau], P]}} /. 
          infirayl\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. {
          k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 1, k4 \[Rule] 0, 
          k5 \[Rule] 0, k6 \[Rule] 0, \(free[1]\)[___] \[Rule] 0}\)], "Input"],

Cell[BoxData[
    \({{1\/2\ E\^\(\(-2\)\ \[Tau]\)\ v, 
        \(-\(1\/2\)\)\ E\^\(\(-2\)\ \[Tau]\)}, {
        \(-\(1\/2\)\)\ E\^\(\(-2\)\ \[Tau]\)\ P}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The reduced FP equation represents a second-order ODE. The similarity \
variable ",
  StyleBox["zeta1 ",
    FontSlant->"Italic"],
  "combines the time \[Tau] and the logarithm of the velocity ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(red4 = 
      LieReduction[rayleigh, {P}, {v, \[Tau]}, 
        inf1\[LeftDoubleBracket]1\[RightDoubleBracket], 
        inf1\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
    LTF[Flatten[red4]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \( : \ \) 
      "The equations appear to involve transcendental functions of the \
variables in an essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\[Tau] + Log[v] - \[Zeta]\_1 == 0\)},
          {\(P\ v - F\_1 == 0\)},
          {
            \(\(-E\^\(3\ \[Tau]\)\)\ 
                \((2\ F\_1 - 3\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\))\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The solution of the second-order ODE is a combination of two \
exponentials\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solr4\  = 
      DSolve[red4\[LeftDoubleBracket]3, 1\[RightDoubleBracket], F1, zeta1]
        \)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] \((E\^#1\ C[1] + E\^\(2\ #1\)\ C[2]&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the original coordinates, the solution is linear in ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " and increases exponentially in time:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol4 = 
      Solve[red4\[LeftDoubleBracket]2, 1\[RightDoubleBracket] /. solr4, P] // 
        Simplify\)], "Input"],

Cell[BoxData[
    \({{P \[Rule] E\^\[Tau]\ \((C[1] + E\^\[Tau]\ v\ C[2])\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The solutions derived from different subgroups of the FP equation \
demonstrate that it is straightforward to uncover solutions with ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " for a (1\[ThinSpace]+\[ThinSpace]1)-dimensional PDE."
}], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"MolecularBeamEpitaxy.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{662, 668},
WindowMargins->{{22, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->348,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ 
          "Point Symmetries of Partial Differential Equations", FontSlant -> 
            "Italic"]}], "Header"], Inherited, None}, {
    None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (Part[ {"Working Examples"}, #]&)], 
            FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->True,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"Hyperlinks"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "The Rayleigh particle"->{
    Cell[1739, 51, 386, 6, 49, "Subsection",
      Evaluatable->False,
      CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 75}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"The Rayleigh particle"]},
  "Brownian particle"->{
    Cell[2128, 59, 441, 10, 75, "Text",
      Evaluatable->False,
      CellTags->{"Brownian particle", "Rayleigh particle"}]},
  "Rayleigh particle"->{
    Cell[2128, 59, 441, 10, 75, "Text",
      Evaluatable->False,
      CellTags->{"Brownian particle", "Rayleigh particle"}]},
  "Fokker-Planck equation"->{
    Cell[2688, 75, 537, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "Fokker-Planck equation", "FP equation", "probability density"}],
    Cell[10000, 306, 527, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry group", "discrete group", "Fokker-Planck equation"}]},
  "FP equation"->{
    Cell[2688, 75, 537, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "Fokker-Planck equation", "FP equation", "probability density"}],
    Cell[10530, 320, 580, 17, 75, "Text",
      CellTags->{"FP equation", "infinitesimals"}]},
  "probability density"->{
    Cell[2688, 75, 537, 15, 75, "Text",
      Evaluatable->False,
      CellTags->{
      "Fokker-Planck equation", "FP equation", "probability density"}]},
  "damped particle"->{
    Cell[4054, 121, 1478, 45, 117, "Text",
      Evaluatable->False,
      CellTags->{"damped particle", "temperature", "Boltzmann constant"}]},
  "temperature"->{
    Cell[4054, 121, 1478, 45, 117, "Text",
      Evaluatable->False,
      CellTags->{"damped particle", "temperature", "Boltzmann constant"}]},
  "Boltzmann constant"->{
    Cell[4054, 121, 1478, 45, 117, "Text",
      Evaluatable->False,
      CellTags->{"damped particle", "temperature", "Boltzmann constant"}]},
  "infinitesimals"->{
    Cell[6055, 188, 519, 13, 96, "Text",
      Evaluatable->False,
      CellTags->"infinitesimals"],
    Cell[10530, 320, 580, 17, 75, "Text",
      CellTags->{"FP equation", "infinitesimals"}]},
  "symmetry group"->{
    Cell[10000, 306, 527, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry group", "discrete group", "Fokker-Planck equation"}]},
  "discrete group"->{
    Cell[10000, 306, 527, 12, 96, "Text",
      Evaluatable->False,
      CellTags->{
      "symmetry group", "discrete group", "Fokker-Planck equation"}]},
  "similarity reduction"->{
    Cell[11593, 353, 132, 4, 33, "Text",
      CellTags->"similarity reduction"],
    Cell[122088, 2396, 158, 2, 33, "Text",
      CellTags->{
      "similarity reduction", "similarity reduction of the FP equation"}]},
  "similarity variable"->{
    Cell[12692, 388, 279, 6, 54, "Text",
      CellTags->{"similarity variable", "DSolve[]"}]},
  "DSolve[]"->{
    Cell[12692, 388, 279, 6, 54, "Text",
      CellTags->{"similarity variable", "DSolve[]"}]},
  "solution of the FP equation"->{
    Cell[13702, 419, 221, 4, 54, "Text",
      CellTags->{"solution of the FP equation", "similarity representation"}],
    
    Cell[282402, 5438, 477, 14, 75, "Text",
      CellTags->"solution of the FP equation"]},
  "similarity representation"->{
    Cell[13702, 419, 221, 4, 54, "Text",
      CellTags->{"solution of the FP equation", "similarity representation"}],
    
    Cell[123266, 2429, 555, 14, 75, "Text",
      CellTags->{"similarity representation", "similarity solution"}]},
  "similarity reduction of the FP equation"->{
    Cell[122088, 2396, 158, 2, 33, "Text",
      CellTags->{
      "similarity reduction", "similarity reduction of the FP equation"}]},
  "similarity solution"->{
    Cell[123266, 2429, 555, 14, 75, "Text",
      CellTags->{"similarity representation", "similarity solution"}],
    Cell[283412, 5469, 345, 10, 54, "Text",
      CellTags->"similarity solution"]},
  "Erfi[]"->{
    Cell[285281, 5534, 226, 6, 54, "Text",
      CellTags->"Erfi[]"]},
  "nontrivial similarity reduction"->{
    Cell[441724, 8470, 356, 10, 54, "Text",
      CellTags->"nontrivial similarity reduction"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"The Rayleigh particle", 446899, 8636},
  {"Brownian particle", 447278, 8644},
  {"Rayleigh particle", 447431, 8648},
  {"Fokker-Planck equation", 447589, 8652},
  {"FP equation", 447921, 8661},
  {"probability density", 448199, 8668},
  {"damped particle", 448379, 8673},
  {"temperature", 448543, 8677},
  {"Boltzmann constant", 448714, 8681},
  {"infinitesimals", 448881, 8685},
  {"symmetry group", 449100, 8691},
  {"discrete group", 449279, 8696},
  {"similarity reduction", 449464, 8701},
  {"similarity variable", 449710, 8707},
  {"DSolve[]", 449822, 8710},
  {"solution of the FP equation", 449953, 8713},
  {"similarity representation", 450204, 8719},
  {"similarity reduction of the FP equation", 450492, 8725},
  {"similarity solution", 450656, 8729},
  {"Erfi[]", 450870, 8734},
  {"nontrivial similarity reduction", 450980, 8737}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 386, 6, 49, "Subsection",
  Evaluatable->False,
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 75}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"The Rayleigh particle"],
Cell[2128, 59, 441, 10, 75, "Text",
  Evaluatable->False,
  CellTags->{"Brownian particle", "Rayleigh particle"}],
Cell[2572, 71, 113, 2, 33, "NumberedEquation"],
Cell[2688, 75, 537, 15, 75, "Text",
  Evaluatable->False,
  CellTags->{
  "Fokker-Planck equation", "FP equation", "probability density"}],

Cell[CellGroupData[{
Cell[3250, 94, 254, 7, 78, "Input"],
Cell[3507, 103, 532, 15, 43, "Output"]
}, Open  ]],
Cell[4054, 121, 1478, 45, 117, "Text",
  Evaluatable->False,
  CellTags->{"damped particle", "temperature", "Boltzmann constant"}],

Cell[CellGroupData[{
Cell[5557, 170, 214, 5, 28, "Input"],
Cell[5774, 177, 266, 8, 30, "Output"]
}, Open  ]],
Cell[6055, 188, 519, 13, 96, "Text",
  Evaluatable->False,
  CellTags->"infinitesimals"],

Cell[CellGroupData[{
Cell[6599, 205, 108, 2, 27, "Input"],
Cell[6710, 209, 3275, 94, 129, "Output"]
}, Open  ]],
Cell[10000, 306, 527, 12, 96, "Text",
  Evaluatable->False,
  CellTags->{"symmetry group", "discrete group", "Fokker-Planck equation"}],
Cell[10530, 320, 580, 17, 75, "Text",
  CellTags->{"FP equation", "infinitesimals"}],

Cell[CellGroupData[{
Cell[11135, 341, 349, 6, 45, "Input"],
Cell[11487, 349, 91, 1, 30, "Output"]
}, Open  ]],
Cell[11593, 353, 132, 4, 33, "Text",
  CellTags->"similarity reduction"],

Cell[CellGroupData[{
Cell[11750, 361, 254, 5, 45, "Input"],
Cell[12007, 368, 670, 17, 81, "Output"]
}, Open  ]],
Cell[12692, 388, 279, 6, 54, "Text",
  CellTags->{"similarity variable", "DSolve[]"}],

Cell[CellGroupData[{
Cell[12996, 398, 564, 13, 27, "Input"],
Cell[13563, 413, 124, 3, 33, "Output"]
}, Open  ]],
Cell[13702, 419, 221, 4, 54, "Text",
  CellTags->{"solution of the FP equation", "similarity representation"}],

Cell[CellGroupData[{
Cell[13948, 427, 136, 3, 27, "Input"],
Cell[14087, 432, 211, 4, 57, "Output"]
}, Open  ]],
Cell[14313, 439, 389, 10, 75, "Text"],

Cell[CellGroupData[{
Cell[14727, 453, 226, 4, 45, "Input"],
Cell[14956, 459, 106143, 1903, 270, 24403, 890, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[121114, 2365, 470, 14, 54, "Text"],

Cell[CellGroupData[{
Cell[121609, 2383, 349, 6, 45, "Input"],
Cell[121961, 2391, 112, 2, 42, "Output"]
}, Open  ]],
Cell[122088, 2396, 158, 2, 33, "Text",
  CellTags->{
  "similarity reduction", "similarity reduction of the FP equation"}],

Cell[CellGroupData[{
Cell[122271, 2402, 254, 5, 45, "Input"],
Cell[122528, 2409, 723, 17, 73, "Output"]
}, Open  ]],
Cell[123266, 2429, 555, 14, 75, "Text",
  CellTags->{"similarity representation", "similarity solution"}],

Cell[CellGroupData[{
Cell[123846, 2447, 127, 3, 27, "Input"],
Cell[123976, 2452, 462, 8, 54, "Output"]
}, Open  ]],
Cell[124453, 2463, 59, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[124537, 2467, 136, 3, 27, "Input"],
Cell[124676, 2472, 293, 5, 60, "Output"]
}, Open  ]],
Cell[124984, 2480, 275, 4, 75, "Text"],

Cell[CellGroupData[{
Cell[125284, 2488, 256, 5, 45, "Input"],
Cell[125543, 2495, 156844, 2940, 310, 54996, 1678, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[282402, 5438, 477, 14, 75, "Text",
  CellTags->"solution of the FP equation"],

Cell[CellGroupData[{
Cell[282904, 5456, 349, 6, 45, "Input"],
Cell[283256, 5464, 141, 2, 45, "Output"]
}, Open  ]],
Cell[283412, 5469, 345, 10, 54, "Text",
  CellTags->"similarity solution"],

Cell[CellGroupData[{
Cell[283782, 5483, 254, 5, 45, "Input"],
Cell[284039, 5490, 180, 3, 69, "Message"],
Cell[284222, 5495, 662, 18, 95, "Output"]
}, Open  ]],
Cell[284899, 5516, 114, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[285038, 5524, 127, 3, 27, "Input"],
Cell[285168, 5529, 98, 2, 43, "Output"]
}, Open  ]],
Cell[285281, 5534, 226, 6, 54, "Text",
  CellTags->"Erfi[]"],

Cell[CellGroupData[{
Cell[285532, 5544, 136, 3, 27, "Input"],
Cell[285671, 5549, 180, 4, 50, "Output"]
}, Open  ]],
Cell[285866, 5556, 217, 4, 54, "Text"],

Cell[CellGroupData[{
Cell[286108, 5564, 280, 5, 45, "Input"],
Cell[286391, 5571, 155318, 2896, 304, 54337, 1645, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[441724, 8470, 356, 10, 54, "Text",
  CellTags->"nontrivial similarity reduction"],

Cell[CellGroupData[{
Cell[442105, 8484, 349, 6, 45, "Input"],
Cell[442457, 8492, 167, 3, 42, "Output"]
}, Open  ]],
Cell[442639, 8498, 280, 9, 54, "Text"],

Cell[CellGroupData[{
Cell[442944, 8511, 254, 5, 45, "Input"],
Cell[443201, 8518, 180, 3, 69, "Message"],
Cell[443384, 8523, 469, 13, 61, "Output"]
}, Open  ]],
Cell[443868, 8539, 99, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[443992, 8546, 127, 3, 27, "Input"],
Cell[444122, 8551, 88, 1, 30, "Output"]
}, Open  ]],
Cell[444225, 8555, 178, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[444428, 8564, 136, 3, 27, "Input"],
Cell[444567, 8569, 90, 1, 30, "Output"]
}, Open  ]],
Cell[444672, 8573, 272, 6, 54, "Text"],
Cell[444947, 8581, 160, 3, 44, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

