(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16922,        636]*)
(*NotebookOutlinePosition[     26053,        876]*)
(*  CellTagsIndexPosition[     25526,        858]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["", "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  AspectRatioFixed->True,
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["Section"],
  ". ",
  " Installing ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " "
}], "Section",
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 2}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)},
  CellTags->"Installing MathLie"],

Cell[TextData[{
  "The following instructions serve to install ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " a program based on the former program Lie by ",
  ButtonBox["G. Baumann [1992].",
    ButtonData:>{"Literat.nb", "Baum-92"},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "C",
  ".",
  
  CounterBox["Subsection"],
  "  ",
  "Windows 95/98"
}], "Subsection",
  CellTags->"Windows 95"],

Cell[CellGroupData[{

Cell[" C.1.1  Manual Installation", "Subsubsection",
  CellTags->{"Manual installation W95", "Introduction"}],

Cell[TextData[{
  "1. Create the directory \"AddOns\\Applications\\",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  "\" at that location where your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " files are located. You'll get the location by"
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \($TopDirectory\)], "Input",
  CellTags->{"$TopDirectory", "Introduction"}],

Cell[BoxData[
    \("C:\\PROGRAMME\\WOLFRAM RESEARCH\\MATHEMATICA\\3.0\\"\)], "Output",
  CellTags->"Introduction"]
}, Open  ]],

Cell[TextData[{
  "2. Copy all the files and directories on CD in the directory ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " into the directory \"AddOns\\Applications\\ ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ".\" "
}], "Text",
  CellTags->"Introduction"],

Cell["3. Go to the Help menu and select \"Rebuild Help Index.\"", "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  "4. ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " uses the global variable $MathLiePath to locate different files. Set this \
 variable to the path where you have located the files."
}], "Text",
  CellTags->{"$MathLiePath", "Introduction"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($MathLiePath\  = \ $TopDirectory <> "\</AddOns/Applications/MathLie/\>"\
\)], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \("C:\\PROGRAMME\\WOLFRAM  \
RESEARCH\\MATHEMATICA\\3.0/AddOns/Applications/MathLie/"\)], "Output",
  CellTags->"Introduction"]
}, Open  ]],

Cell[TextData[{
  "5. Add to the variable $Path in the ",
  StyleBox["init.m ",
    FontColor->RGBColor[1, 0, 0]],
  "file the location of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". \nAppendTo[$Path,$MathLiePath\"]"
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(AppendTo[$Path, $MathLiePath]\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "You are now ready to use ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and view the Help information."
}], "Text",
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["C.1.2  Automatic Installation", "Subsubsection",
  CellTags->{"Automatic Installation W95", "Introduction"}],

Cell[TextData[{
  "The following lines install the package and the documentation of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The files are located in the ",
  StyleBox["AddOns",
    FontSlant->"Italic"],
  " application directories. "
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[Install]\), "\n", 
    \(\t\(Install[] := 
        Block[{location1, 
            source}, \n\t\tlocation1 = $TopDirectory <> \
"\</AddOns/Applications/MathLie\>"; \n\t\tsource\  = \ 
            Input["\<Where is the CD located? Use a string as input value; 

eg. d:/MathLie .\>"]; \[IndentingNewLine]If[$VersionNumber < 
              4, \n\t\tCreateDirectory[location1]]; \n\t\tCopyDirectory[
            source, location1]; \n\t\tPrint["\<Installation successfully 

terminated\>"]];\)\), "\n", 
    \(Install[]\)}], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \("Installation successfully   terminated"\)], "Print"]
}, Open  ]],

Cell["Go to the Help menu and select \"Rebuild Help Index.\"", "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " uses the global variable $MathLiePath to locate different files. Set this \
 variable to the path where you have located the files."
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(\($MathLiePath\  = \ $TopDirectory <> \
"\</AddOns/Applications/MathLie/\>";\)\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "Add to the variable $Path in the file ",
  StyleBox["init.m ",
    FontColor->RGBColor[1, 0, 0]],
  "the location of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ".\nAppendTo[$Path,$TopDirectory<>\"/AddOns/Applications/",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  "\"]"
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(AppendTo[$Path, $MathLiePath]\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "You are now ready to use ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and view the Help information."
}], "Text",
  CellTags->"Introduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["C.2  Mac", "Subsection",
  CellTags->"Mac"],

Cell[CellGroupData[{

Cell["C.2.1  Manual Installation", "Subsubsection",
  CellTags->{"Manual installation Mac", "Introduction"}],

Cell[TextData[{
  "1. Create the directory \"AddOns\\Applications\\",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  "\" at that location where your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " files are located. You'll get the location by"
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \($TopDirectory\)], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \("C:\\PROGRAMME\\WOLFRAM RESEARCH\\MATHEMATICA\\3.0\\"\)], "Output",
  CellTags->"Introduction"]
}, Open  ]],

Cell[TextData[{
  "2. Copy all the files and directories on disk/CD in the directory ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " into the directory \"AddOns\\Applications\\ ",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  "\" "
}], "Text",
  CellTags->"Introduction"],

Cell["3. Go to the Help menu and select \"Rebuild Help Index.\"", "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  "4. ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " uses the global variable $MathLiePath to locate different files. Set this \
 variable to the path where you have located the files."
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MathLiePath\  = \ $TopDirectory <> "\</AddOns/Applications/MathLie/\>"\
\)], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \("C:\\PROGRAMME\\WOLFRAM  \
RESEARCH\\MATHEMATICA\\3.0/AddOns/Applications/MathLie/"\)], "Output",
  CellTags->"Introduction"]
}, Open  ]],

Cell[TextData[{
  "5. Add to the variable $Path in the ",
  StyleBox["init.m ",
    FontColor->RGBColor[1, 0, 0]],
  "file the location of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". \nAppendTo[$Path,$MathLiePath\"]"
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(AppendTo[$Path, $MathLiePath]\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "You are now ready to use ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and view the Help information."
}], "Text",
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["C.2.2  Automatic Installation", "Subsubsection",
  CellTags->{"Automatic Installation Mac", "Introduction"}],

Cell[TextData[{
  "The following lines install the package and the documentation of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The files are located in the ",
  StyleBox["AddOns",
    FontSlant->"Italic"],
  " application directories. "
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[Install]\), "\n", 
    \(\t\(Install[] := 
        Block[{location1, 
            source}, \n\t\tlocation1 = $TopDirectory <> \
"\</AddOns/Applications/MathLie\>"; \n\t\tsource\  = \ 
            Input["\<Where is the CD located? Use a string as input value; 

eg. d:/MathLie .\>"]; \n\t\tIf[$VersionNumber < 4, \n\t\tCreateDirectory[
              location1]]; \n\t\tCopyDirectory[source, 
            lication1]; \n\t\tPrint["\<Installation successfully 

terminated\>"]];\)\), "\n", 
    \(Install[]\)}], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \("Installation successfully terminated"\)], "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Introduction"]
}, Open  ]],

Cell["Go to the Help menu and select \"Rebuild Help Index.\"", "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " uses the global variable $MathLiePath to locate different files. Set this \
 variable to the path where you have located the files."
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(\($MathLiePath\  = \ $TopDirectory <> \
"\</AddOns/Applications/MathLie/\>";\)\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "Add to the variable $Path in the file ",
  StyleBox["init.m ",
    FontColor->RGBColor[1, 0, 0]],
  "the location of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ".\nAppendTo[$Path,$TopDirectory<>\"/AddOns/Applications/",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  "\"]"
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(AppendTo[$Path, $MathLiePath]\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "You are now ready to use ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and view the Help information."
}], "Text",
  CellTags->"Introduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["C.3  UNIX", "Subsection",
  CellTags->"UNIX"],

Cell[CellGroupData[{

Cell["C.3.1  Manual Installation", "Subsubsection",
  CellTags->{"Manual installation UNIX", "Introduction"}],

Cell[TextData[{
  "1. Create the directory \"",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  "\" in your $HOME/.Mathematica/3.0/AddOns/Applications directory. You'll   \
get the location of your home directory by"
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \($HomeDirectory\)], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \(\(\(\(/\)\(users\)\)/depart1\)/gbaumann\)], "Output",
  CellTags->"Introduction"]
}, Open  ]],

Cell[TextData[{
  "2. Copy all the files and directories on CD in the directory ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " into the directory \"",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  "\""
}], "Text",
  CellTags->"Introduction"],

Cell["3. Go to the Help menu and select \"Rebuild Help Index.\"", "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  "4. ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " uses the global variable $MathLiePath to locate different files. Set this \
 variable to the path where you have located the files."
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MathLiePath\  = \ $HomeDirectory <> "\</MatLie/\>"\)], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \("/users/depart1/gbaumann/MathLie/"\)], "Output",
  CellTags->"Introduction"]
}, Open  ]],

Cell[TextData[{
  "5. Add to the variable $Path in the ",
  StyleBox["init.m ",
    FontColor->RGBColor[1, 0, 0]],
  "file the location of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". \nAppendTo[$Path,$MathLiePath\"]"
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(AppendTo[$Path, $MathLiePath]\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "You are now ready to use ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and view the Help information."
}], "Text",
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["C.3.2  Automatic Installation", "Subsubsection",
  CellTags->{"Automatic Installation UNIX", "Introduction"}],

Cell[TextData[{
  "The following lines install the package and the documentation of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ". The files are located in the ",
  StyleBox["AddOns",
    FontSlant->"Italic"],
  " application directories. "
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[Install]\), "\n", 
    \(\t\(Install[] := 
        Block[{location1, 
            source}, \n\t\tlocation1 = $HomeDirectory <> \
"\</.Mathematica/3.0/AddOns/Applications/MathLie\>"; \n\t\tsource\  = \ 
            Input["\<Where is the CD located? Use a string as input value; 

eg. d:/MathLie .\>"]; \n\t\tIf[$VersionNumber < 4, \n\t\tCreateDirectory[
              location1]]; \n\t\tCopyDirectory[source, 
            location1]; \n\t\tPrint["\<Installation successfully 

terminated\>"]];\)\), "\n", 
    \(Install[]\)}], "Input",
  CellTags->"Introduction"],

Cell[BoxData[
    \("Installation successfully terminated"\)], "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Introduction"]
}, Open  ]],

Cell["Go to the Help menu and select \"Rebuild Help Index.\"", "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " uses the global variable $MathLiePath to locate different files. Set this \
 variable to the path where you have located the files."
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(\($MathLiePath\  = \ $HomeDirectory <> \
"\</.Mathematica/3.0/AddOns/Applications/MathLie\>";\)\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "Add to the variable $Path in the file ",
  StyleBox["init.m ",
    FontColor->RGBColor[1, 0, 0]],
  "the location of ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  ".\nAppendTo[$Path,$HomeDirectory<>\"/.Mathematica/3.0/AddOns/Applications/ \
",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  "\"]"
}], "Text",
  CellTags->"Introduction"],

Cell[BoxData[
    \(AppendTo[$Path, $MathLiePath]\)], "Input",
  CellTags->"Introduction"],

Cell[TextData[{
  "You are now ready to use ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " and view the Help information."
}], "Text",
  CellTags->"Introduction"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[TextData[ButtonBox["Next notebook Titelpage",
  ButtonData:>{"Title.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}],

Cell[TextData[ButtonBox["Next notebook Bibliography",
  ButtonData:>{"Literat.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{734, 668},
WindowMargins->{{14, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Introduction", FontSlant -> "Italic"]}], "Header"], 
      Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Introduction", FontSlant -> "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
IndexCreationOptions->{"Format"->"SectionReferences"},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
PrivateFontOptions->{"FontType"->"Outline"},
CharacterEncoding->"$SystemCharacterEncoding",
Magnification->1.25,
CounterBoxOptions->{CounterFunction:>Identity},
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Installing MathLie"->{
    Cell[2112, 61, 475, 14, 53, "Section",
      CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 2}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Installing MathLie"]},
  "Windows 95"->{
    Cell[2899, 89, 130, 8, 49, "Subsection",
      CellTags->"Windows 95"]},
  "Manual installation W95"->{
    Cell[3054, 101, 109, 1, 37, "Subsubsection",
      CellTags->{"Manual installation W95", "Introduction"}]},
  "Introduction"->{
    Cell[3054, 101, 109, 1, 37, "Subsubsection",
      CellTags->{"Manual installation W95", "Introduction"}],
    Cell[3166, 104, 297, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[3488, 117, 93, 2, 25, "Input",
      CellTags->{"$TopDirectory", "Introduction"}],
    Cell[3584, 121, 115, 2, 25, "Output",
      CellTags->"Introduction"],
    Cell[3714, 126, 278, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[3995, 137, 101, 1, 29, "Text",
      CellTags->"Introduction"],
    Cell[4099, 140, 267, 7, 45, "Text",
      CellTags->{"$MathLiePath", "Introduction"}],
    Cell[4391, 151, 134, 3, 40, "Input",
      CellTags->"Introduction"],
    Cell[4528, 156, 145, 3, 40, "Output",
      CellTags->"Introduction"],
    Cell[4688, 162, 268, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[4959, 173, 90, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[5052, 177, 170, 6, 29, "Text",
      CellTags->"Introduction"],
    Cell[5259, 188, 114, 1, 24, "Subsubsection",
      CellTags->{"Automatic Installation W95", "Introduction"}],
    Cell[5376, 191, 289, 9, 54, "Text",
      CellTags->"Introduction"],
    Cell[5690, 204, 584, 14, 243, "Input",
      CellTags->"Introduction"],
    Cell[6365, 224, 98, 1, 33, "Text",
      CellTags->"Introduction"],
    Cell[6466, 227, 240, 6, 54, "Text",
      CellTags->"Introduction"],
    Cell[6709, 235, 139, 3, 27, "Input",
      CellTags->"Introduction"],
    Cell[6851, 240, 344, 12, 54, "Text",
      CellTags->"Introduction"],
    Cell[7198, 254, 90, 2, 27, "Input",
      CellTags->"Introduction"],
    Cell[7291, 258, 170, 6, 33, "Text",
      CellTags->"Introduction"],
    Cell[7584, 275, 108, 1, 34, "Subsubsection",
      CellTags->{"Manual installation Mac", "Introduction"}],
    Cell[7695, 278, 297, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[8017, 291, 74, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[8094, 295, 115, 2, 25, "Output",
      CellTags->"Introduction"],
    Cell[8224, 300, 283, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[8510, 311, 101, 1, 29, "Text",
      CellTags->"Introduction"],
    Cell[8614, 314, 249, 7, 45, "Text",
      CellTags->"Introduction"],
    Cell[8888, 325, 134, 3, 40, "Input",
      CellTags->"Introduction"],
    Cell[9025, 330, 145, 3, 40, "Output",
      CellTags->"Introduction"],
    Cell[9185, 336, 268, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[9456, 347, 90, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[9549, 351, 170, 6, 29, "Text",
      CellTags->"Introduction"],
    Cell[9756, 362, 114, 1, 20, "Subsubsection",
      CellTags->{"Automatic Installation Mac", "Introduction"}],
    Cell[9873, 365, 289, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[10187, 378, 571, 14, 249, "Input",
      CellTags->"Introduction"],
    Cell[10761, 394, 151, 4, 24, "Print",
      CellTags->"Introduction"],
    Cell[10927, 401, 98, 1, 29, "Text",
      CellTags->"Introduction"],
    Cell[11028, 404, 240, 6, 45, "Text",
      CellTags->"Introduction"],
    Cell[11271, 412, 139, 3, 40, "Input",
      CellTags->"Introduction"],
    Cell[11413, 417, 344, 12, 45, "Text",
      CellTags->"Introduction"],
    Cell[11760, 431, 90, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[11853, 435, 170, 6, 29, "Text",
      CellTags->"Introduction"],
    Cell[12148, 452, 109, 1, 34, "Subsubsection",
      CellTags->{"Manual installation UNIX", "Introduction"}],
    Cell[12260, 455, 258, 7, 62, "Text",
      CellTags->"Introduction"],
    Cell[12543, 466, 75, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[12621, 470, 101, 2, 25, "Output",
      CellTags->"Introduction"],
    Cell[12737, 475, 254, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[12994, 486, 101, 1, 29, "Text",
      CellTags->"Introduction"],
    Cell[13098, 489, 249, 7, 45, "Text",
      CellTags->"Introduction"],
    Cell[13372, 500, 112, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[13487, 504, 96, 2, 25, "Output",
      CellTags->"Introduction"],
    Cell[13598, 509, 268, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[13869, 520, 90, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[13962, 524, 170, 6, 29, "Text",
      CellTags->"Introduction"],
    Cell[14169, 535, 115, 1, 20, "Subsubsection",
      CellTags->{"Automatic Installation UNIX", "Introduction"}],
    Cell[14287, 538, 289, 9, 45, "Text",
      CellTags->"Introduction"],
    Cell[14601, 551, 589, 14, 249, "Input",
      CellTags->"Introduction"],
    Cell[15193, 567, 151, 4, 24, "Print",
      CellTags->"Introduction"],
    Cell[15359, 574, 98, 1, 29, "Text",
      CellTags->"Introduction"],
    Cell[15460, 577, 240, 6, 45, "Text",
      CellTags->"Introduction"],
    Cell[15703, 585, 156, 3, 40, "Input",
      CellTags->"Introduction"],
    Cell[15862, 590, 365, 13, 62, "Text",
      CellTags->"Introduction"],
    Cell[16230, 605, 90, 2, 25, "Input",
      CellTags->"Introduction"],
    Cell[16323, 609, 170, 6, 29, "Text",
      CellTags->"Introduction"]},
  "$TopDirectory"->{
    Cell[3488, 117, 93, 2, 25, "Input",
      CellTags->{"$TopDirectory", "Introduction"}]},
  "$MathLiePath"->{
    Cell[4099, 140, 267, 7, 45, "Text",
      CellTags->{"$MathLiePath", "Introduction"}]},
  "Automatic Installation W95"->{
    Cell[5259, 188, 114, 1, 24, "Subsubsection",
      CellTags->{"Automatic Installation W95", "Introduction"}]},
  "Mac"->{
    Cell[7510, 270, 49, 1, 26, "Subsection",
      CellTags->"Mac"]},
  "Manual installation Mac"->{
    Cell[7584, 275, 108, 1, 34, "Subsubsection",
      CellTags->{"Manual installation Mac", "Introduction"}]},
  "Automatic Installation Mac"->{
    Cell[9756, 362, 114, 1, 20, "Subsubsection",
      CellTags->{"Automatic Installation Mac", "Introduction"}]},
  "UNIX"->{
    Cell[12072, 447, 51, 1, 26, "Subsection",
      CellTags->"UNIX"]},
  "Manual installation UNIX"->{
    Cell[12148, 452, 109, 1, 34, "Subsubsection",
      CellTags->{"Manual installation UNIX", "Introduction"}]},
  "Automatic Installation UNIX"->{
    Cell[14169, 535, 115, 1, 20, "Subsubsection",
      CellTags->{"Automatic Installation UNIX", "Introduction"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Installing MathLie", 18711, 683},
  {"Windows 95", 19051, 690},
  {"Manual installation W95", 19159, 693},
  {"Introduction", 19291, 696},
  {"$TopDirectory", 24392, 827},
  {"$MathLiePath", 24505, 830},
  {"Automatic Installation W95", 24631, 833},
  {"Mac", 24757, 836},
  {"Manual installation Mac", 24858, 839},
  {"Automatic Installation Mac", 25004, 842},
  {"UNIX", 25131, 845},
  {"Manual installation UNIX", 25235, 848},
  {"Automatic Installation UNIX", 25384, 851}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 348, 6, 117, "ChapterLine",
  Evaluatable->False,
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2112, 61, 475, 14, 53, "Section",
  CounterAssignments->{{"Title", 0}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 2}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Installing MathLie"],
Cell[2590, 77, 284, 8, 54, "Text"],

Cell[CellGroupData[{
Cell[2899, 89, 130, 8, 49, "Subsection",
  CellTags->"Windows 95"],

Cell[CellGroupData[{
Cell[3054, 101, 109, 1, 37, "Subsubsection",
  CellTags->{"Manual installation W95", "Introduction"}],
Cell[3166, 104, 297, 9, 45, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[3488, 117, 93, 2, 25, "Input",
  CellTags->{"$TopDirectory", "Introduction"}],
Cell[3584, 121, 115, 2, 25, "Output",
  CellTags->"Introduction"]
}, Open  ]],
Cell[3714, 126, 278, 9, 45, "Text",
  CellTags->"Introduction"],
Cell[3995, 137, 101, 1, 29, "Text",
  CellTags->"Introduction"],
Cell[4099, 140, 267, 7, 45, "Text",
  CellTags->{"$MathLiePath", "Introduction"}],

Cell[CellGroupData[{
Cell[4391, 151, 134, 3, 40, "Input",
  CellTags->"Introduction"],
Cell[4528, 156, 145, 3, 40, "Output",
  CellTags->"Introduction"]
}, Open  ]],
Cell[4688, 162, 268, 9, 45, "Text",
  CellTags->"Introduction"],
Cell[4959, 173, 90, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[5052, 177, 170, 6, 29, "Text",
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[5259, 188, 114, 1, 24, "Subsubsection",
  CellTags->{"Automatic Installation W95", "Introduction"}],
Cell[5376, 191, 289, 9, 54, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[5690, 204, 584, 14, 243, "Input",
  CellTags->"Introduction"],
Cell[6277, 220, 73, 1, 29, "Print"]
}, Open  ]],
Cell[6365, 224, 98, 1, 33, "Text",
  CellTags->"Introduction"],
Cell[6466, 227, 240, 6, 54, "Text",
  CellTags->"Introduction"],
Cell[6709, 235, 139, 3, 27, "Input",
  CellTags->"Introduction"],
Cell[6851, 240, 344, 12, 54, "Text",
  CellTags->"Introduction"],
Cell[7198, 254, 90, 2, 27, "Input",
  CellTags->"Introduction"],
Cell[7291, 258, 170, 6, 33, "Text",
  CellTags->"Introduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7510, 270, 49, 1, 26, "Subsection",
  CellTags->"Mac"],

Cell[CellGroupData[{
Cell[7584, 275, 108, 1, 34, "Subsubsection",
  CellTags->{"Manual installation Mac", "Introduction"}],
Cell[7695, 278, 297, 9, 45, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[8017, 291, 74, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[8094, 295, 115, 2, 25, "Output",
  CellTags->"Introduction"]
}, Open  ]],
Cell[8224, 300, 283, 9, 45, "Text",
  CellTags->"Introduction"],
Cell[8510, 311, 101, 1, 29, "Text",
  CellTags->"Introduction"],
Cell[8614, 314, 249, 7, 45, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[8888, 325, 134, 3, 40, "Input",
  CellTags->"Introduction"],
Cell[9025, 330, 145, 3, 40, "Output",
  CellTags->"Introduction"]
}, Open  ]],
Cell[9185, 336, 268, 9, 45, "Text",
  CellTags->"Introduction"],
Cell[9456, 347, 90, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[9549, 351, 170, 6, 29, "Text",
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[9756, 362, 114, 1, 20, "Subsubsection",
  CellTags->{"Automatic Installation Mac", "Introduction"}],
Cell[9873, 365, 289, 9, 45, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[10187, 378, 571, 14, 249, "Input",
  CellTags->"Introduction"],
Cell[10761, 394, 151, 4, 24, "Print",
  CellTags->"Introduction"]
}, Open  ]],
Cell[10927, 401, 98, 1, 29, "Text",
  CellTags->"Introduction"],
Cell[11028, 404, 240, 6, 45, "Text",
  CellTags->"Introduction"],
Cell[11271, 412, 139, 3, 40, "Input",
  CellTags->"Introduction"],
Cell[11413, 417, 344, 12, 45, "Text",
  CellTags->"Introduction"],
Cell[11760, 431, 90, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[11853, 435, 170, 6, 29, "Text",
  CellTags->"Introduction"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12072, 447, 51, 1, 26, "Subsection",
  CellTags->"UNIX"],

Cell[CellGroupData[{
Cell[12148, 452, 109, 1, 34, "Subsubsection",
  CellTags->{"Manual installation UNIX", "Introduction"}],
Cell[12260, 455, 258, 7, 62, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[12543, 466, 75, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[12621, 470, 101, 2, 25, "Output",
  CellTags->"Introduction"]
}, Open  ]],
Cell[12737, 475, 254, 9, 45, "Text",
  CellTags->"Introduction"],
Cell[12994, 486, 101, 1, 29, "Text",
  CellTags->"Introduction"],
Cell[13098, 489, 249, 7, 45, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[13372, 500, 112, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[13487, 504, 96, 2, 25, "Output",
  CellTags->"Introduction"]
}, Open  ]],
Cell[13598, 509, 268, 9, 45, "Text",
  CellTags->"Introduction"],
Cell[13869, 520, 90, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[13962, 524, 170, 6, 29, "Text",
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[14169, 535, 115, 1, 20, "Subsubsection",
  CellTags->{"Automatic Installation UNIX", "Introduction"}],
Cell[14287, 538, 289, 9, 45, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[14601, 551, 589, 14, 249, "Input",
  CellTags->"Introduction"],
Cell[15193, 567, 151, 4, 24, "Print",
  CellTags->"Introduction"]
}, Open  ]],
Cell[15359, 574, 98, 1, 29, "Text",
  CellTags->"Introduction"],
Cell[15460, 577, 240, 6, 45, "Text",
  CellTags->"Introduction"],
Cell[15703, 585, 156, 3, 40, "Input",
  CellTags->"Introduction"],
Cell[15862, 590, 365, 13, 62, "Text",
  CellTags->"Introduction"],
Cell[16230, 605, 90, 2, 25, "Input",
  CellTags->"Introduction"],
Cell[16323, 609, 170, 6, 29, "Text",
  CellTags->"Introduction"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16554, 622, 19, 0, 52, "Section"],
Cell[16576, 624, 155, 3, 44, "Text"],
Cell[16734, 629, 160, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

