(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   9894629,     199726]*)
(*NotebookOutlinePosition[   9927858,     200537]*)
(*  CellTagsIndexPosition[   9922547,     200416]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["5.5 Similarity Reduction of Partial Differential Equations", "Section",
  CounterAssignments->{{"Title", 5}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 23}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Reduction of partial differential equations"],

Cell[TextData[{
  "A similarity reduction of a differential equation is closely connected \
with the invariance of the equation. In C",
  ButtonBox["hapter 3,",
    ButtonData:>{"symmet1.nb", 
      "Symmetries of Ordinary Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " we discussed the group invariance of ordinary differential equations. The \
invariance condition in connection with ordinary differential equations was \
beneficial for the reduction of the order or the integration of ODEs by \
quadratures. In this section, we will discuss the invariance condition of a \
partial differential equation to reduce the equation to an ODE or to a PDE in \
less independent coordinates. The first case occurs for an equation with two \
independent variables, whereas a general reduction to another PDE follows in \
cases with more than two independent variables. The reduction procedure \
generates a similarity representation of the original equation. Since we \
reduce the number of independent variables, a similarity reduction results \
into a representation which has some advantages compared with the original \
equation."
}], "Text",
  CellTags->{
  "reduction of differential equations", "group invariance", 
    "invariance condition", "reduction of order", 
    "integration of ODEs by quadrature", 
    "invariance condition of partial differential equations", 
    "similarity representation", "reduce of independent variables"}],

Cell["\<\
This procedure works independent of the nature of the PDE, linear \
or nonlinear. It is also independent of the order of the PDE and it does not \
need information on boundary conditions. The benefit of the reduction is a \
simpler equation allowing an analytic or numeric solution. Examples of \
similarity solutions are widely encountered in mechanics, hydrodynamics, in \
the general theory of relativity, etc. However, the solutions derived in \
these fields are mainly guesswork and lack an algorithmic procedure. We are \
going to show here that a similarity reduction is an algorithmic procedure \
delivering a large number of ans\[ADoubleDot]tze discussed in the literature.\
\
\>", "Text",
  CellTags->{
  "boundary condition", "similarity solution", "mechanics", "hydrodynamics", 
    "theory of relativity", "algorithmic procedure of similarity reduction"}],

Cell["\<\
The main idea behind a similarity reduction is the term invariance. \
The discussion of invariance is the first step in this section. To simplify \
the theoretical representation, we restrict the examination to cases with two \
independent variables. A generalization to more independent variables is \
straightforward.\
\>", "Text",
  CellTags->"invariance"],

Cell["\<\
Let us consider the general PDE in two independent variables and \
one dependent variable in the form\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[CapitalDelta](x, t, u, u\_x, u\_t, u\_\(x, x\), \[Ellipsis])\  = \ 
      0, \)\)], "NumberedEquation",
  CellTags->"eq-1"],

Cell["\<\
which is invariant under the one-parameter Lie group of \
transformations\
\>", "Text",
  Evaluatable->False,
  CellTags->{"one-parameter Lie group", "transformation"}],

Cell[BoxData[
    \(TraditionalForm\`\(\(x\^*\)\  = \ X(x, t, u; \[Epsilon]), \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(\(t\^*\) = \ T(x, t, u; \[Epsilon]), \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(u\^*\)\  = \ \ \(U(x, t, u; \[Epsilon]) . \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "Let us further assume that ",
  Cell[BoxData[
      \(TraditionalForm\`u = \[CapitalTheta](x, t)\)]],
  " is a solution of equation ",
  ButtonBox["(5.24)",
    ButtonData:>"eq-1",
    ButtonStyle->"Hyperlink"],
  ". Inserting this solution into the transformations (5.25)\[Dash](5.27), we \
can write"
}], "Text",
  Evaluatable->False,
  CellTags->"transformation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(x\^*\)\  = \ \ X(x, t, \[Theta](x, t); \[Epsilon]), \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(\(t\^*\)\  = \ T(x, t, \[Theta](x, t); \[Epsilon]), 
    \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(\(u\^*\)\  = \ U(x, t, \[Theta](x, t); \[Epsilon]), 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "stating that ",
  Cell[BoxData[
      \(TraditionalForm\`\(u\^*\)\)]],
  " is also a solution of the transformed PDE. The use of these facts allows \
us to define the invariance in the following way."
}], "Text",
  Evaluatable->False,
  CellTags->{"transformed PDE", "invariance"}],

Cell["Definition: Invariance", "Definition",
  CellTags->"Definition: Invariance"],

Cell[TextData[{
  "A PDE is invariant under a one-parameter Lie group transformation if ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(u\^*\),
            "TraditionalForm"], "="}], TraditionalForm]], "InlineFormula"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ U(x, t, \[CapitalTheta](x, t); \[Epsilon])\)\)], 
    "InlineFormula"],
  " also satisfies the transformed PDE whenever ",
  Cell[BoxData[
      \(TraditionalForm\`u = \[CapitalTheta](x, t)\)]],
  " is a solution of the original PDE.\[ThickSpace]\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  Background->None,
  CellTags->"invariant under a one-parameter Lie group"],

Cell["\<\
If we additionally require that we can solve this problem uniquely, \
we end up with the functional equation\
\>", "Text",
  Evaluatable->False,
  CellTags->"functional equation"],

Cell[BoxData[
    \(TraditionalForm
    \`\[CapitalTheta](X(x, t, \[CapitalTheta](x, t); \[Epsilon]), 
        T(x, t, \[Theta](x, t); \[Epsilon]))\  = \ 
      \(U(x, t, \[CapitalTheta](x, t); \[Epsilon]) . \)\)], "NumberedEquation",\

  CellTags->"eq-8"],

Cell[TextData[
"The solution of this functional equation can be found by introducing the \
infinitesimal representation of the transformations (5.28)\[Dash](5.30). We \
will carry out the calculation by replacing the transformations \
(5.28)\[Dash](5.30) by their infinitesimal representations"], "Text",
  Evaluatable->False,
  CellTags->{
  "infinitesimal representation of a transformation", 
    "infinitesimal representation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[T, X, U]; \n
    itrafo = {
        X \[Rule] 
          Function[{x, t, u, \[Epsilon]}, 
            x + \[Epsilon]\ \(xi[1]\)[x, t, u]], \n\t\t
        T \[Rule] 
          Function[{x, t, u, \[Epsilon]}, 
            t + \[Epsilon]\ \(xi[2]\)[x, t, u]], \n\t\t
        U \[Rule] 
          Function[{x, t, u, \[Epsilon]}, 
            u + \[Epsilon]\ \(phi[1]\)[x, t, u]]}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({X \[Rule] 
        Function[{x, t, u, \[Epsilon]}, x + \[Epsilon]\ \(xi[1]\)[x, t, u]], 
      T \[Rule] 
        Function[{x, t, u, \[Epsilon]}, t + \[Epsilon]\ \(xi[2]\)[x, t, u]], 
      U \[Rule] 
        Function[{x, t, u, \[Epsilon]}, u + \[Epsilon]\ \(phi[1]\)[x, t, u]]}
      \)], "Output"]
}, Open  ]],

Cell["\<\
Inserting the infinitesimal representation of the transformations \
into the functional equation (5.31), we get the simplification\
\>", "Text",
  Evaluatable->False,
  CellTags->"simplification"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fun = 
      \[CapitalTheta][X[x, t, \[CapitalTheta], \[Epsilon]], 
            T[x, t, \[CapitalTheta], \[Epsilon]]] == 
          U[x, t, \[CapitalTheta], \[Epsilon]] /. itrafo\)], "Input"],

Cell[BoxData[
    \(\[CapitalTheta][x + \[Epsilon]\ \(xi[1]\)[x, t, \[CapitalTheta]], 
        t + \[Epsilon]\ \(xi[2]\)[x, t, \[CapitalTheta]]] == 
      \[CapitalTheta] + \[Epsilon]\ \(phi[1]\)[x, t, \[CapitalTheta]]\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The parameter \[Epsilon] is the group parameter of the transformation. On \
the left-hand side this expression contains the solution \[Theta] for which \
we are looking. Actually, the above expressions contain \[Theta] in a \
functional form, too. However, this representation depends on the \
infinitesimals parameter \[Epsilon] allowing us a Taylor expansion around the \
identity \[Epsilon]",
  Cell[BoxData[
      \(TraditionalForm\`\( = 0\)\)]],
  ". If we additionally subtract the right-hand side from the left-hand side \
and extract the terms of lowest order in \[Epsilon], we get the result "
}], "Text",
  Evaluatable->False,
  CellTags->{
  "group parameter", "infinitesimals parameter", "Taylor expansion"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[
          \((Series[
                  fun\[LeftDoubleBracket]1\[RightDoubleBracket], {\[Epsilon], 
                    0, 1}] /. \[CapitalTheta][x, t] \[Rule] \[CapitalTheta])
              \) - fun\[LeftDoubleBracket]2\[RightDoubleBracket], 
          \[Epsilon]] == 0 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\[CapitalTheta]\_x\ \[Xi]\_1 + \[CapitalTheta]\_t\ \[Xi]\_2 - 
        \[Phi]\_1 == 0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This first-order PDE is called the invariant surface condition. The \
problem we face is the solution of this first-order partial differential \
equation. Actually, this is not a problem if we use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " offers a package integrated in the function ",
  StyleBox["DSolve[]", "MmaText"],
  " allowing the integration of first-order PDEs. This package uses the fact \
that a first-order PDE is closely related to a set of ordinary differential \
equations. The connection between the first-order PDE and the system of ODEs \
can be demonstrated by the following reasoning."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "invariant surface condition", "first-order partial differential equation", 
    "DSolve[]", "first-order PDEs"}],

Cell[TextData[{
  "Let us assume that an arbitrary surface in the space with coordinates ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["t",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["u ",
    FontSlant->"Italic"],
  "is given by"
}], "Text",
  Evaluatable->False,
  CellTags->"surface"],

Cell[BoxData[
    \(TraditionalForm\`u\  = \ \(\[CapitalTheta](x, t) . \)\)], 
  "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "Later, we will identify this surface as the solution surface of the \
first-order PDE. A curve embedded in this surface can be described by a set \
of parametric coordinates. Let ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " be the parameter along the curve; then the curve itself is given by the \
triple"
}], "Text",
  Evaluatable->False,
  CellTags->"first-order PDE"],

Cell[BoxData[
    \(TraditionalForm\`\(\((x = x(s), t = t(s), u = u(s))\) . \)\)], 
  "NumberedEquation",
  Evaluatable->False],

Cell["The tangent vector to this curve is", "Text",
  Evaluatable->False,
  CellTags->"tangent vector"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(v\&\[RightVector]\), " ", "=", " ", 
          RowBox[{
            RowBox[{\(e\&\[RightVector]\_x\), " ", 
              FractionBox[
                StyleBox["dx",
                  FontSlant->"Italic"], 
                StyleBox["ds",
                  FontSlant->"Italic"]]}], " ", "+", " ", 
            RowBox[{\(e\&\[RightVector]\_t\), " ", 
              FractionBox[
                StyleBox["dt",
                  FontSlant->"Italic"], 
                StyleBox["ds",
                  FontSlant->"Italic"]]}], " ", "+", " ", 
            RowBox[{\(e\&\[RightVector]\_u\), " ", 
              FractionBox[
                StyleBox["du",
                  FontSlant->"Italic"], 
                StyleBox["ds",
                  FontSlant->"Italic"]]}]}]}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ e\&\[RightVector]\_x\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ e\&\[RightVector]\_t\)\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ e\&\[RightVector]\_u\)\)]],
  " are the unit vectors in the directions of the coordinate axes. The normal \
direction on the surface ",
  Cell[BoxData[
      \(TraditionalForm
      \`H = \(u - \[CapitalTheta](x, t) = \(const . \)\)\)]],
  " is determined by the gradient divided by the magnitude of the gradient"
}], "Text",
  Evaluatable->False,
  CellTags->{"normal direction", "unit vector", "gradient"}],

Cell[BoxData[
    \(TraditionalForm
    \`n\&\[RightVector]\  = \ 
      \(\[Del]H\/\(\[VerticalSeparator]\(\[Del]H \[VerticalSeparator] 
            \)\)\  = \ 
        \(1\/\(\[VerticalSeparator]\(\[Del]H \[VerticalSeparator] \)\)\) 
          \(\((\(-e\&\[RightVector]\_x\) \[CapitalTheta]\_x\  - \ 
                e\&\[RightVector]\_t\ \[CapitalTheta]\_t\  + \ 
                e\&\[RightVector]\_u)\) . \)\)\)], "NumberedEquation"],

Cell[TextData[{
  "The condition ",
  Cell[BoxData[
      \(TraditionalForm\`\(n\&\[RightVector]\) v\&\[RightVector]\  = \ 0\)]],
  " assures that the curve ",
  Cell[BoxData[
      \(TraditionalForm\`\((x(s), t(s), u(s))\)\)]],
  " is part of the surface ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". This condition, however, is nothing more than"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[CapitalTheta]\_x\), " ", 
            FractionBox[
              StyleBox["dx",
                FontSlant->"Italic"], 
              StyleBox["ds",
                FontSlant->"Italic"]]}], " ", "+", " ", 
          RowBox[{\(\[CapitalTheta]\_t\), " ", 
            FractionBox[
              StyleBox["dt",
                FontSlant->"Italic"], 
              StyleBox["ds",
                FontSlant->"Italic"]]}]}], "  ", "=", "  ", 
        RowBox[{
          FractionBox[
            StyleBox["du",
              FontSlant->"Italic"], 
            StyleBox["ds",
              FontSlant->"Italic"]], "."}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell["If we define a family of curves by", "Text",
  Evaluatable->False,
  CellTags->"family of curves"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            StyleBox["dx",
              FontSlant->"Italic"], 
            StyleBox["ds",
              FontSlant->"Italic"]], " ", "=", " ", 
          \(\(\[Xi]\_1\)(x, t, u)\)}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            StyleBox["dt",
              FontSlant->"Italic"], 
            StyleBox["ds",
              FontSlant->"Italic"]], " ", "=", " ", 
          \(\(\[Xi]\_2\)(x, t, u)\)}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            StyleBox["du",
              FontSlant->"Italic"], 
            StyleBox["ds",
              FontSlant->"Italic"]], " ", "=", " ", 
          \(\(\[Phi]\_1\)(x, t, u)\)}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "called the characteristic differential equations, we can rewrite the \
surface condition ",
  Cell[BoxData[
      \(TraditionalForm\`\(n\&\[RightVector]\) v\&\[RightVector]\  = \ 0\)]],
  " in a partial differential equation of first order:"
}], "Text",
  Evaluatable->False,
  CellTags->{"characteristic differential equations", "surface condition"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Xi]\_1\ \[CapitalTheta]\_x\  + \ \[Xi]\_2\ \[CapitalTheta]\_t\  = \ 
      \[Phi]\_1, \)\)], "NumberedEquation"],

Cell[TextData[{
  "which is equivalent with the equation derived from the functional relation \
",
  ButtonBox["(5.31) ",
    ButtonData:>"eq-8",
    ButtonStyle->"Hyperlink"],
  "for \[CapitalTheta]. Consequently, each one-parameter family of \
characteristic curves generates a surface which defines an integral surface ",
  
  Cell[BoxData[
      \(TraditionalForm\`u - \[CapitalTheta](x, t) = \(const . \)\)]],
  " and each such integral surface is generated by a one-parameter family of \
characteristic curves."
}], "Text",
  Evaluatable->False,
  CellTags->{
  "family of characteristic curves", "integral surface", 
    "characteristic curves"}],

Cell["Example 1", "Example"],

Cell["\<\
Let us consider the first-order partial differential equation\
\>", 
  "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(pde1 = 
      x\ \[PartialD]\_x \[CapitalTheta][x, t] + 
          t\ \[PartialD]\_t \[CapitalTheta][x, t] == \[CapitalTheta][x, t]; 
    pde1 // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(t\ \[CapitalTheta]\_t + x\ \[CapitalTheta]\_x == \[CapitalTheta]\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "corresponding to a scaling symmetry with infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_1 = x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_2 = t\)]],
  ". The first-order PDE is solved by"
}], "Text",
  Evaluatable->False,
  CellTags->{"scaling symmetry", "first-order PDE"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = DSolve[pde1, \[CapitalTheta][x, t], {x, t}]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{\[CapitalTheta][x, t] \[Rule] x\ \(C[1]\)[t\/x]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "where ",
  StyleBox["C[1][t/x]", "MmaText",
    FontSlant->"Italic"],
  " is an arbitrary function. A graphical representation of this solution \
with ",
  StyleBox["C[1]", "MmaText",
    FontSlant->"Italic"],
  " replaced by ",
  StyleBox["Sin[]", "MmaText"],
  " is given by"
}], "Text",
  Evaluatable->False,
  CellTags->"Sin[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      \((\[CapitalTheta][x, t] /. \((sol /. C[1] \[Rule] Sin)\))
          \)\[LeftDoubleBracket]1\[RightDoubleBracket], \n
      \t{x, 0.1, 2}, {t, \(-2\)\ \[Pi], 2\ \[Pi]}, \n\t
      AxesLabel \[Rule] {"\<x\>", "\<t\>", "\<\[CapitalTheta]\>"}, \n\t
      PlotPoints \[Rule] 40, Mesh \[Rule] False]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-016 1.04977 -0.0679587 1.04977 [
[.15237 .19707 -17.8465 -9 ]
[.15237 .19707 .15354 0 ]
[.31741 .13214 -5.61962 -9 ]
[.31741 .13214 .38038 0 ]
[.49342 .06293 -15.8713 -9 ]
[.49342 .06293 2.12873 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.29165 .07573 -9.31117 -15 ]
[.29165 .07573 .68883 0 ]
[.73568 .04839 0 -6.20944 ]
[.73568 .04839 12 2.79056 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.95831 .38931 0 -5.88673 ]
[.95831 .38931 6 3.11327 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02413 .26502 -12 -2.74225 ]
[.02413 .26502 0 6.25775 ]
[.01569 .31791 -12 -2.78696 ]
[.01569 .31791 0 6.21304 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00209 .42932 -6 -2.88165 ]
[-0.00209 .42932 0 6.11835 ]
[-0.01146 .48805 -6 -2.93184 ]
[-0.01146 .48805 0 6.06816 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.16157 .20642 m
.16617 .2111 L
s
[(0.5)] .15237 .19707 .98294 1 Mshowa
.32604 .14202 m
.33035 .14696 L
s
[(1)] .31741 .13214 .87321 1 Mshowa
.50139 .07336 m
.50537 .07857 L
s
[(1.5)] .49342 .06293 .76347 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.19364 .19386 m
.19637 .1967 L
s
.22611 .18115 m
.22881 .18402 L
s
.259 .16827 m
.26166 .17117 L
s
.29231 .15523 m
.29493 .15816 L
s
.3602 .12864 m
.36275 .13164 L
s
.39481 .11509 m
.39732 .11812 L
s
.42987 .10136 m
.43235 .10443 L
s
.4654 .08745 m
.46783 .09055 L
s
.53786 .05908 m
.5402 .06224 L
s
.57482 .04461 m
.57712 .0478 L
s
.61228 .02994 m
.61453 .03317 L
s
.65025 .01507 m
.65245 .01833 L
s
.12989 .21883 m
.13268 .2216 L
s
.0986 .23108 m
.10142 .23383 L
s
.06769 .24318 m
.07054 .2459 L
s
.03716 .25514 m
.04004 .25782 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72342 .05305 m
.71728 .05538 L
s
[(-5)] .73568 .04839 -1 .37988 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.94577 .39318 m
.9395 .39511 L
s
[(5)] .95831 .38931 -1 .30816 Mshowa
.125 Mabswid
.74932 .09266 m
.74563 .09403 L
s
.77428 .13086 m
.77058 .1322 L
s
.79837 .1677 m
.79466 .16902 L
s
.82162 .20326 m
.8179 .20455 L
s
.86578 .27081 m
.86204 .27206 L
s
.88677 .30292 m
.88302 .30414 L
s
.90707 .33398 m
.90332 .33518 L
s
.92673 .36405 m
.92298 .36523 L
s
.69654 .01193 m
.69287 .01336 L
s
.96423 .4214 m
.96046 .42254 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(t) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03635 .26025 m
.04246 .25786 L
s
[(-2)] .02413 .26502 1 -0.39061 Mshowa
.02795 .31324 m
.03408 .3109 L
s
[(-1)] .01569 .31791 1 -0.38068 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01026 .42488 m
.01644 .42265 L
s
[(1)] -0.00209 .42932 1 -0.35963 Mshowa
.00094 .48373 m
.00713 .48157 L
s
[(2)] -0.01146 .48805 1 -0.34848 Mshowa
.125 Mabswid
.03469 .2707 m
.03836 .26928 L
s
.03303 .28123 m
.0367 .27981 L
s
.03135 .29183 m
.03502 .29041 L
s
.02966 .3025 m
.03333 .30109 L
s
.02624 .32406 m
.02992 .32266 L
s
.02451 .33495 m
.0282 .33356 L
s
.02277 .34591 m
.02646 .34453 L
s
.02102 .35696 m
.02471 .35558 L
s
.01749 .37928 m
.02118 .37792 L
s
.0157 .39056 m
.0194 .3892 L
s
.0139 .40192 m
.0176 .40057 L
s
.01209 .41335 m
.01579 .41202 L
s
.00842 .43648 m
.01213 .43515 L
s
.00657 .44816 m
.01028 .44685 L
s
.00471 .45993 m
.00842 .45862 L
s
.00283 .47179 m
.00654 .47048 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Q) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.435 .687 .97 r
.3936 .69521 .40169 .70185 .41543 .69063 .407 .69616 Mtetra
.881 .991 .747 r
.407 .69616 .41543 .69063 .42867 .69819 .42107 .67769 Mtetra
.641 .557 .744 r
.42107 .67769 .42867 .69819 .44231 .69515 .43473 .67331 Mtetra
0 .129 .652 r
.43473 .67331 .44231 .69515 .45595 .69598 .44792 .69408 Mtetra
.937 .802 .686 r
.44792 .69408 .45595 .69598 .47007 .67331 .46238 .65799 Mtetra
0 0 .446 r
.46238 .65799 .47007 .67331 .48385 .67266 .47583 .68131 Mtetra
.585 .157 .194 r
.47583 .68131 .48385 .67266 .49753 .69729 .48975 .68593 Mtetra
.867 .715 .692 r
.48975 .68593 .49753 .69729 .51168 .67736 .50404 .65388 Mtetra
.76 .607 .689 r
.50404 .65388 .51168 .67736 .52576 .64546 .51815 .63216 Mtetra
.47 .545 .851 r
.51815 .63216 .52576 .64546 .53979 .63433 .53224 .63553 Mtetra
.796 .338 .154 r
.53224 .63553 .53979 .63433 .554 .64456 .54656 .65308 Mtetra
.757 .365 .311 r
.54656 .65308 .554 .64456 .56852 .66347 .56113 .67071 Mtetra
.668 .232 .204 r
.56113 .67071 .56852 .66347 .58325 .67956 .57583 .68007 Mtetra
.06 .625 .712 r
.57583 .68007 .58325 .67956 .59804 .68684 .59053 .67894 Mtetra
.772 .772 .853 r
.59053 .67894 .59804 .68684 .61276 .6842 .60512 .66881 Mtetra
.774 .666 .744 r
.60512 .66881 .61276 .6842 .62732 .67335 .61957 .65264 Mtetra
.763 .625 .707 r
.61957 .65264 .62732 .67335 .64173 .65698 .6339 .63338 Mtetra
.753 .606 .695 r
.6339 .63338 .64173 .65698 .65599 .63774 .64816 .61337 Mtetra
.745 .598 .694 r
.64816 .61337 .65599 .63774 .67017 .61775 .66239 .59423 Mtetra
.738 .598 .701 r
.66239 .59423 .67017 .61775 .68433 .59849 .67665 .57692 Mtetra
.732 .604 .715 r
.67665 .57692 .68433 .59849 .69852 .58089 .69099 .56193 Mtetra
.726 .617 .736 r
.69099 .56193 .69852 .58089 .71279 .56544 .70544 .54944 Mtetra
.718 .638 .767 r
.70544 .54944 .71279 .56544 .72718 .55232 .72005 .53939 Mtetra
.708 .669 .81 r
.72005 .53939 .72718 .55232 .74172 .54155 .73482 .53162 Mtetra
.687 .713 .868 r
.73482 .53162 .74172 .54155 .75643 .533 .74979 .5259 Mtetra
.642 .768 .94 r
.74979 .5259 .75643 .533 .77134 .52647 .76495 .52198 Mtetra
.533 .812 .997 r
.76495 .52198 .77134 .52647 .78645 .52176 .78032 .51961 Mtetra
.305 .768 .945 r
.78032 .51961 .78645 .52176 .80177 .51862 .79589 .51855 Mtetra
.004 .581 .714 r
.79589 .51855 .80177 .51862 .81731 .51684 .81168 .51859 Mtetra
.225 0 0 r
.81168 .51859 .81731 .51684 .83306 .51622 .82768 .51952 Mtetra
.357 0 0 r
.82768 .51952 .83306 .51622 .84903 .51657 .84388 .52118 Mtetra
.429 0 0 r
.84388 .52118 .84903 .51657 .86521 .51771 .86029 .52341 Mtetra
.47 0 0 r
.86029 .52341 .86521 .51771 .8816 .5195 .8769 .52608 Mtetra
.495 .002 .015 r
.8769 .52608 .8816 .5195 .8982 .5218 .8937 .52909 Mtetra
.51 .029 .05 r
.8937 .52909 .8982 .5218 .915 .52451 .9107 .53233 Mtetra
.518 .046 .072 r
.9107 .53233 .915 .52451 .932 .52753 .92789 .53572 Mtetra
.523 .056 .086 r
.92789 .53572 .932 .52753 .9492 .53077 .94526 .53921 Mtetra
.525 .06 .093 r
.94526 .53921 .9492 .53077 .96659 .53416 .96281 .54273 Mtetra
.524 .06 .095 r
.96281 .54273 .96659 .53416 .98416 .53763 .98055 .54623 Mtetra
.582 .697 .921 r
.3855 .68688 .3936 .69521 .407 .69616 .399 .68544 Mtetra
.73 .695 .817 r
.399 .68544 .407 .69616 .42107 .67769 .41282 .67708 Mtetra
.821 .946 .904 r
.41282 .67708 .42107 .67769 .43473 .67331 .42674 .66606 Mtetra
0 .182 .665 r
.42674 .66606 .43473 .67331 .44792 .69408 .44017 .67612 Mtetra
.774 .64 .713 r
.44017 .67612 .44792 .69408 .46238 .65799 .45437 .65676 Mtetra
.872 .462 .244 r
.45437 .65676 .46238 .65799 .47583 .68131 .46776 .68376 Mtetra
.915 .966 .794 r
.46776 .68376 .47583 .68131 .48975 .68593 .48204 .66504 Mtetra
.808 .642 .677 r
.48204 .66504 .48975 .68593 .50404 .65388 .49637 .63437 Mtetra
.662 .577 .749 r
.49637 .63437 .50404 .65388 .51815 .63216 .51045 .62822 Mtetra
.705 .17 0 r
.51045 .62822 .51815 .63216 .53224 .63553 .52459 .64263 Mtetra
.774 .375 .298 r
.52459 .64263 .53224 .63553 .54656 .65308 .53897 .66134 Mtetra
.697 .281 .254 r
.53897 .66134 .54656 .65308 .56113 .67071 .55356 .67292 Mtetra
.245 0 0 r
.55356 .67292 .56113 .67071 .57583 .68007 .56821 .6735 Mtetra
.768 .803 .881 r
.56821 .6735 .57583 .68007 .59053 .67894 .58282 .66423 Mtetra
.777 .673 .749 r
.58282 .66423 .59053 .67894 .60512 .66881 .59733 .64829 Mtetra
.764 .626 .708 r
.59733 .64829 .60512 .66881 .61957 .65264 .61173 .62901 Mtetra
.753 .606 .695 r
.61173 .62901 .61957 .65264 .6339 .63338 .62606 .60898 Mtetra
.744 .598 .695 r
.62606 .60898 .6339 .63338 .64816 .61337 .64036 .58998 Mtetra
.736 .598 .703 r
.64036 .58998 .64816 .61337 .66239 .59423 .65469 .57302 Mtetra
.73 .606 .719 r
.65469 .57302 .66239 .59423 .67665 .57692 .66909 .55857 Mtetra
.723 .621 .743 r
.66909 .55857 .67665 .57692 .69099 .56193 .68361 .54677 Mtetra
.714 .645 .779 r
.68361 .54677 .69099 .56193 .70544 .54944 .69828 .53751 Mtetra
.7 .682 .829 r
.69828 .53751 .70544 .54944 .72005 .53939 .71311 .53058 Mtetra
.671 .733 .896 r
.71311 .53058 .72005 .53939 .73482 .53162 .72812 .52571 Mtetra
.6 .791 .972 r
.72812 .52571 .73482 .53162 .74979 .5259 .74333 .52262 Mtetra
.427 .804 .992 r
.74333 .52262 .74979 .5259 .76495 .52198 .75873 .52104 Mtetra
.126 .67 .828 r
.75873 .52104 .76495 .52198 .78032 .51961 .77434 .5207 Mtetra
.157 0 0 r
.77434 .5207 .78032 .51961 .79589 .51855 .79016 .52138 Mtetra
.326 0 0 r
.79016 .52138 .79589 .51855 .81168 .51859 .80617 .52288 Mtetra
.415 0 0 r
.80617 .52288 .81168 .51859 .82768 .51952 .82239 .52502 Mtetra
.464 0 0 r
.82239 .52502 .82768 .51952 .84388 .52118 .83881 .52765 Mtetra
.492 0 .008 r
.83881 .52765 .84388 .52118 .86029 .52341 .85542 .53064 Mtetra
.509 .027 .047 r
.85542 .53064 .86029 .52341 .8769 .52608 .87222 .53388 Mtetra
.518 .045 .072 r
.87222 .53388 .8769 .52608 .8937 .52909 .8892 .53729 Mtetra
.523 .056 .086 r
.8892 .53729 .8937 .52909 .9107 .53233 .90637 .54079 Mtetra
.525 .06 .093 r
.90637 .54079 .9107 .53233 .92789 .53572 .92372 .54431 Mtetra
.524 .06 .094 r
.92372 .54431 .92789 .53572 .94526 .53921 .94124 .5478 Mtetra
.521 .056 .091 r
.94124 .5478 .94526 .53921 .96281 .54273 .95893 .55123 Mtetra
.516 .048 .082 r
.95893 .55123 .96281 .54273 .98055 .54623 .97679 .55455 Mtetra
.818 .814 .846 r
.37719 .68173 .3855 .68688 .399 .68544 .39115 .66957 Mtetra
.073 .268 .757 r
.39115 .66957 .399 .68544 .41282 .67708 .40425 .68252 Mtetra
.391 .805 .603 r
.40425 .68252 .41282 .67708 .42674 .66606 .41822 .67353 Mtetra
.841 .977 .676 r
.41822 .67353 .42674 .66606 .44017 .67612 .43251 .65373 Mtetra
.345 .369 .742 r
.43251 .65373 .44017 .67612 .45437 .65676 .44604 .66483 Mtetra
.663 .242 .236 r
.44604 .66483 .45437 .65676 .46776 .68376 .45981 .67359 Mtetra
.874 .726 .695 r
.45981 .67359 .46776 .68376 .48204 .66504 .47435 .64161 Mtetra
.74 .598 .698 r
.47435 .64161 .48204 .66504 .49637 .63437 .48859 .62381 Mtetra
.101 .392 .849 r
.48859 .62381 .49637 .63437 .51045 .62822 .50261 .63252 Mtetra
.792 .373 .253 r
.50261 .63252 .51045 .62822 .52459 .64263 .51679 .65144 Mtetra
.721 .319 .286 r
.51679 .65144 .52459 .64263 .53897 .66134 .53123 .6653 Mtetra
.446 0 0 r
.53123 .6653 .53897 .66134 .55356 .67292 .54583 .66784 Mtetra
.756 .844 .918 r
.54583 .66784 .55356 .67292 .56821 .6735 .56045 .65958 Mtetra
.78 .682 .756 r
.56045 .65958 .56821 .6735 .58282 .66423 .575 .64392 Mtetra
.765 .628 .709 r
.575 .64392 .58282 .66423 .59733 .64829 .58947 .62461 Mtetra
.753 .606 .695 r
.58947 .62461 .59733 .64829 .61173 .62901 .60387 .60458 Mtetra
.743 .597 .695 r
.60387 .60458 .61173 .62901 .62606 .60898 .61824 .58576 Mtetra
.735 .598 .705 r
.61824 .58576 .62606 .60898 .64036 .58998 .63264 .5692 Mtetra
.727 .607 .723 r
.63264 .5692 .64036 .58998 .65469 .57302 .64711 .55537 Mtetra
.719 .625 .751 r
.64711 .55537 .65469 .57302 .66909 .55857 .66168 .54434 Mtetra
.709 .654 .793 r
.66168 .54434 .66909 .55857 .68361 .54677 .6764 .53594 Mtetra
.69 .698 .852 r
.6764 .53594 .68361 .54677 .69828 .53751 .69127 .52992 Mtetra
.645 .756 .93 r
.69127 .52992 .69828 .53751 .71311 .53058 .70633 .52595 Mtetra
.528 .807 .997 r
.70633 .52595 .71311 .53058 .72812 .52571 .72157 .52372 Mtetra
.267 .749 .928 r
.72157 .52372 .72812 .52571 .74333 .52262 .73701 .52293 Mtetra
.063 0 0 r
.73701 .52293 .74333 .52262 .75873 .52104 .75265 .52331 Mtetra
.283 0 0 r
.75265 .52331 .75873 .52104 .77434 .5207 .76848 .52462 Mtetra
.397 0 0 r
.76848 .52462 .77434 .5207 .79016 .52138 .78451 .52665 Mtetra
.457 0 0 r
.78451 .52665 .79016 .52138 .80617 .52288 .80073 .52922 Mtetra
.49 0 0 r
.80073 .52922 .80617 .52288 .82239 .52502 .81715 .5322 Mtetra
.508 .025 .044 r
.81715 .5322 .82239 .52502 .83881 .52765 .83375 .53544 Mtetra
.518 .045 .071 r
.83375 .53544 .83881 .52765 .85542 .53064 .85053 .53886 Mtetra
.523 .056 .086 r
.85053 .53886 .85542 .53064 .87222 .53388 .8675 .54236 Mtetra
.525 .06 .093 r
.8675 .54236 .87222 .53388 .8892 .53729 .88464 .54588 Mtetra
.523 .059 .094 r
.88464 .54588 .8892 .53729 .90637 .54079 .90195 .54937 Mtetra
.519 .054 .089 r
.90195 .54937 .90637 .54079 .92372 .54431 .91943 .55276 Mtetra
.514 .045 .079 r
.91943 .55276 .92372 .54431 .94124 .5478 .93707 .55604 Mtetra
.506 .033 .066 r
.93707 .55604 .94124 .5478 .95893 .55123 .95488 .55917 Mtetra
.497 .018 .047 r
.95488 .55917 .95893 .55123 .97679 .55455 .97284 .56214 Mtetra
.356 .557 .91 r
.36901 .67165 .37719 .68173 .39115 .66957 .38236 .67562 Mtetra
0 0 0 r
.38236 .67562 .39115 .66957 .40425 .68252 .39631 .66698 Mtetra
.358 .452 .821 r
.39631 .66698 .40425 .68252 .41822 .67353 .40978 .6739 Mtetra
.947 .847 .712 r
.40978 .6739 .41822 .67353 .43251 .65373 .4245 .64312 Mtetra
.831 .395 0 r
.4245 .64312 .43251 .65373 .44604 .66483 .43764 .66965 Mtetra
.852 .996 .762 r
.43764 .66965 .44604 .66483 .45981 .67359 .45202 .65254 Mtetra
.801 .638 .681 r
.45202 .65254 .45981 .67359 .47435 .64161 .46656 .62377 Mtetra
.578 .548 .785 r
.46656 .62377 .47435 .64161 .48859 .62381 .48061 .62349 Mtetra
.8 .33 .112 r
.48061 .62349 .48859 .62381 .50261 .63252 .4946 .64109 Mtetra
.743 .346 .3 r
.4946 .64109 .50261 .63252 .51679 .65144 .50886 .65714 Mtetra
.56 .074 .059 r
.50886 .65714 .51679 .65144 .53123 .6653 .52337 .66192 Mtetra
.719 .891 .959 r
.52337 .66192 .53123 .6653 .54583 .66784 .53798 .65485 Mtetra
.785 .694 .764 r
.53798 .65485 .54583 .66784 .56045 .65958 .55258 .63953 Mtetra
.767 .631 .71 r
.55258 .63953 .56045 .65958 .575 .64392 .56712 .6202 Mtetra
.752 .606 .695 r
.56712 .6202 .575 .64392 .58947 .62461 .58159 .60017 Mtetra
.742 .597 .696 r
.58159 .60017 .58947 .62461 .60387 .60458 .59603 .58157 Mtetra
.733 .598 .707 r
.59603 .58157 .60387 .60458 .61824 .58576 .61049 .5655 Mtetra
.724 .609 .728 r
.61049 .5655 .61824 .58576 .63264 .5692 .62502 .55237 Mtetra
.715 .63 .761 r
.62502 .55237 .63264 .5692 .64711 .55537 .63965 .5422 Mtetra
.702 .665 .811 r
.63965 .5422 .64711 .55537 .66168 .54434 .65441 .53475 Mtetra
.674 .717 .882 r
.65441 .53475 .66168 .54434 .6764 .53594 .66932 .52969 Mtetra
.601 .782 .967 r
.66932 .52969 .6764 .53594 .69127 .52992 .68441 .52667 Mtetra
.407 .796 .989 r
.68441 .52667 .69127 .52992 .70633 .52595 .69968 .52532 Mtetra
.063 .625 .779 r
.69968 .52532 .70633 .52595 .72157 .52372 .71514 .52532 Mtetra
.224 0 0 r
.71514 .52532 .72157 .52372 .73701 .52293 .73079 .5264 Mtetra
.374 0 0 r
.73079 .5264 .73701 .52293 .75265 .52331 .74664 .52829 Mtetra
.448 0 0 r
.74664 .52829 .75265 .52331 .76848 .52462 .76267 .5308 Mtetra
.486 0 0 r
.76267 .5308 .76848 .52462 .78451 .52665 .77889 .53375 Mtetra
.507 .023 .04 r
.77889 .53375 .78451 .52665 .80073 .52922 .79529 .537 Mtetra
.518 .044 .07 r
.79529 .537 .80073 .52922 .81715 .5322 .81187 .54043 Mtetra
.523 .056 .086 r
.81187 .54043 .81715 .5322 .83375 .53544 .82863 .54394 Mtetra
.524 .06 .093 r
.82863 .54394 .83375 .53544 .85053 .53886 .84557 .54746 Mtetra
.522 .058 .093 r
.84557 .54746 .85053 .53886 .8675 .54236 .86267 .55092 Mtetra
.518 .052 .087 r
.86267 .55092 .8675 .54236 .88464 .54588 .87994 .55429 Mtetra
.512 .042 .076 r
.87994 .55429 .88464 .54588 .90195 .54937 .89737 .55751 Mtetra
.503 .028 .06 r
.89737 .55751 .90195 .54937 .91943 .55276 .91495 .56057 Mtetra
.492 .01 .039 r
.91495 .56057 .91943 .55276 .93707 .55604 .93269 .56343 Mtetra
.479 0 .013 r
.93269 .56343 .93707 .55604 .95488 .55917 .95059 .56609 Mtetra
.464 0 0 r
.95059 .56609 .95488 .55917 .97284 .56214 .96863 .56853 Mtetra
.703 .864 .959 r
.36046 .66796 .36901 .67165 .38236 .67562 .37428 .66196 Mtetra
.767 .672 .758 r
.37428 .66196 .38236 .67562 .39631 .66698 .38847 .6479 Mtetra
.388 .427 .78 r
.38847 .6479 .39631 .66698 .40978 .6739 .40188 .65557 Mtetra
.684 .598 .754 r
.40188 .65557 .40978 .6739 .4245 .64312 .41595 .6478 Mtetra
.737 .301 .215 r
.41595 .6478 .4245 .64312 .43764 .66965 .42947 .66105 Mtetra
.884 .742 .7 r
.42947 .66105 .43764 .66965 .45202 .65254 .44426 .62936 Mtetra
.708 .582 .712 r
.44426 .62936 .45202 .65254 .46656 .62377 .45854 .61672 Mtetra
.561 .04 0 r
.45854 .61672 .46656 .62377 .48061 .62349 .47241 .63052 Mtetra
.767 .365 .292 r
.47241 .63052 .48061 .62349 .4946 .64109 .48646 .64837 Mtetra
.629 .182 .17 r
.48646 .64837 .4946 .64109 .50886 .65714 .50084 .65568 Mtetra
.614 .921 .975 r
.50084 .65568 .50886 .65714 .52337 .66192 .51543 .65004 Mtetra
.79 .709 .775 r
.51543 .65004 .52337 .66192 .53798 .65485 .53007 .63512 Mtetra
.768 .634 .712 r
.53007 .63512 .53798 .65485 .55258 .63953 .54467 .61577 Mtetra
.752 .606 .695 r
.54467 .61577 .55258 .63953 .56712 .6202 .55922 .59576 Mtetra
.74 .596 .697 r
.55922 .59576 .56712 .6202 .58159 .60017 .57373 .57744 Mtetra
.73 .599 .71 r
.57373 .57744 .58159 .60017 .59603 .58157 .58825 .56193 Mtetra
.721 .612 .735 r
.58825 .56193 .59603 .58157 .61049 .5655 .60283 .54962 Mtetra
.71 .637 .774 r
.60283 .54962 .61049 .5655 .62502 .55237 .6175 .5404 Mtetra
.691 .68 .834 r
.6175 .5404 .62502 .55237 .63965 .5422 .6323 .53398 Mtetra
.648 .742 .918 r
.6323 .53398 .63965 .5422 .65441 .53475 .64724 .52996 Mtetra
.522 .8 .996 r
.64724 .52996 .65441 .53475 .66932 .52969 .66236 .52791 Mtetra
.218 .722 .903 r
.66236 .52791 .66932 .52969 .68441 .52667 .67765 .52744 Mtetra
.138 0 0 r
.67765 .52744 .68441 .52667 .69968 .52532 .69312 .52823 Mtetra
.341 0 0 r
.69312 .52823 .69968 .52532 .71514 .52532 .70877 .52996 Mtetra
.435 0 0 r
.70877 .52996 .71514 .52532 .73079 .5264 .72462 .53239 Mtetra
.482 0 0 r
.72462 .53239 .73079 .5264 .74664 .52829 .74064 .53531 Mtetra
.506 .02 .036 r
.74064 .53531 .74664 .52829 .76267 .5308 .75685 .53856 Mtetra
.518 .044 .069 r
.75685 .53856 .76267 .5308 .77889 .53375 .77323 .54199 Mtetra
.523 .056 .086 r
.77323 .54199 .77889 .53375 .79529 .537 .78979 .54551 Mtetra
.524 .06 .093 r
.78979 .54551 .79529 .537 .81187 .54043 .80651 .54903 Mtetra
.522 .057 .092 r
.80651 .54903 .81187 .54043 .82863 .54394 .8234 .55247 Mtetra
.516 .05 .085 r
.8234 .55247 .82863 .54394 .84557 .54746 .84046 .55579 Mtetra
.509 .037 .071 r
.84046 .55579 .84557 .54746 .86267 .55092 .85767 .55895 Mtetra
.499 .021 .052 r
.85767 .55895 .86267 .55092 .87994 .55429 .87504 .56191 Mtetra
.486 .001 .028 r
.87504 .56191 .87994 .55429 .89737 .55751 .89256 .56466 Mtetra
.471 0 0 r
.89256 .56466 .89737 .55751 .91495 .56057 .91023 .56718 Mtetra
.453 0 0 r
.91023 .56718 .91495 .56057 .93269 .56343 .92805 .56946 Mtetra
.431 0 0 r
.92805 .56946 .93269 .56343 .95059 .56609 .94601 .57149 Mtetra
.405 0 0 r
.94601 .57149 .95059 .56609 .96863 .56853 .96411 .57328 Mtetra
.718 .68 .813 r
.35221 .65618 .36046 .66796 .37428 .66196 .36615 .64822 Mtetra
.507 .563 .847 r
.36615 .64822 .37428 .66196 .38847 .6479 .37972 .65007 Mtetra
.876 .979 .839 r
.37972 .65007 .38847 .6479 .40188 .65557 .39406 .63473 Mtetra
0 .101 .642 r
.39406 .63473 .40188 .65557 .41595 .6478 .40718 .6548 Mtetra
.672 .935 .652 r
.40718 .6548 .41595 .6478 .42947 .66105 .4216 .63987 Mtetra
.79 .633 .688 r
.4216 .63987 .42947 .66105 .44426 .62936 .4363 .61397 Mtetra
.379 .47 .827 r
.4363 .61397 .44426 .62936 .45854 .61672 .4502 .62024 Mtetra
.794 .369 .238 r
.4502 .62024 .45854 .61672 .47241 .63052 .46404 .63892 Mtetra
.675 .254 .238 r
.46404 .63892 .47241 .63052 .48646 .64837 .47825 .64904 Mtetra
.337 .819 .845 r
.47825 .64904 .48646 .64837 .50084 .65568 .4928 .64511 Mtetra
.796 .728 .789 r
.4928 .64511 .50084 .65568 .51543 .65004 .50747 .63069 Mtetra
.771 .637 .714 r
.50747 .63069 .51543 .65004 .53007 .63512 .52214 .61132 Mtetra
.752 .606 .695 r
.52214 .61132 .53007 .63512 .54467 .61577 .53676 .59136 Mtetra
.738 .596 .698 r
.53676 .59136 .54467 .61577 .55922 .59576 .55134 .57338 Mtetra
.727 .599 .713 r
.55134 .57338 .55922 .59576 .57373 .57744 .56591 .55855 Mtetra
.716 .615 .743 r
.56591 .55855 .57373 .57744 .58825 .56193 .58053 .54716 Mtetra
.703 .647 .791 r
.58053 .54716 .58825 .56193 .60283 .54962 .59524 .53902 Mtetra
.676 .699 .864 r
.59524 .53902 .60283 .54962 .6175 .5404 .61006 .53371 Mtetra
.602 .77 .96 r
.61006 .53371 .6175 .5404 .6323 .53398 .62503 .53076 Mtetra
.38 .783 .984 r
.62503 .53076 .6323 .53398 .64724 .52996 .64015 .52971 Mtetra
0 .566 .713 r
.64015 .52971 .64724 .52996 .66236 .52791 .65545 .53012 Mtetra
.293 0 0 r
.65545 .53012 .66236 .52791 .67765 .52744 .67093 .53165 Mtetra
.419 0 0 r
.67093 .53165 .67765 .52744 .69312 .52823 .68658 .53398 Mtetra
.476 0 0 r
.68658 .53398 .69312 .52823 .70877 .52996 .70241 .53687 Mtetra
.504 .016 .03 r
.70241 .53687 .70877 .52996 .72462 .53239 .71842 .54011 Mtetra
.518 .043 .067 r
.71842 .54011 .72462 .53239 .74064 .53531 .7346 .54356 Mtetra
.523 .056 .086 r
.7346 .54356 .74064 .53531 .75685 .53856 .75095 .54709 Mtetra
.524 .059 .093 r
.75095 .54709 .75685 .53856 .77323 .54199 .76747 .55059 Mtetra
.52 .056 .091 r
.76747 .55059 .77323 .54199 .78979 .54551 .78415 .554 Mtetra
.514 .046 .081 r
.78415 .554 .78979 .54551 .80651 .54903 .80099 .55727 Mtetra
.505 .032 .065 r
.80099 .55727 .80651 .54903 .8234 .55247 .81799 .56034 Mtetra
.493 .013 .043 r
.81799 .56034 .8234 .55247 .84046 .55579 .83514 .5632 Mtetra
.479 0 .014 r
.83514 .5632 .84046 .55579 .85767 .55895 .85244 .56581 Mtetra
.461 0 0 r
.85244 .56581 .85767 .55895 .87504 .56191 .86989 .56817 Mtetra
.439 0 0 r
.86989 .56817 .87504 .56191 .89256 .56466 .88748 .57026 Mtetra
.413 0 0 r
.88748 .57026 .89256 .56466 .91023 .56718 .90521 .57209 Mtetra
.381 0 0 r
.90521 .57209 .91023 .56718 .92805 .56946 .92308 .57365 Mtetra
.343 0 0 r
.92308 .57365 .92805 .56946 .94601 .57149 .94109 .57495 Mtetra
.298 0 0 r
.94109 .57495 .94601 .57149 .96411 .57328 .95923 .57598 Mtetra
.192 .694 .91 r
.34341 .65386 .35221 .65618 .36615 .64822 .35702 .65418 Mtetra
.314 0 0 r
.35702 .65418 .36615 .64822 .37972 .65007 .3708 .65317 Mtetra
.937 .941 .769 r
.3708 .65317 .37972 .65007 .39406 .63473 .38552 .63112 Mtetra
.798 .306 .006 r
.38552 .63112 .39406 .63473 .40718 .6548 .39874 .64831 Mtetra
.897 .765 .708 r
.39874 .64831 .40718 .6548 .4216 .63987 .41376 .6173 Mtetra
.651 .555 .733 r
.41376 .6173 .4216 .63987 .4363 .61397 .42794 .61126 Mtetra
.799 .309 .028 r
.42794 .61126 .4363 .61397 .4502 .62024 .44161 .6288 Mtetra
.713 .305 .273 r
.44161 .6288 .4502 .62024 .46404 .63892 .45561 .64189 Mtetra
.082 0 0 r
.45561 .64189 .46404 .63892 .47825 .64904 .47008 .64004 Mtetra
.803 .754 .808 r
.47008 .64004 .47825 .64904 .4928 .64511 .48478 .62623 Mtetra
.773 .641 .716 r
.48478 .62623 .4928 .64511 .50747 .63069 .49952 .60685 Mtetra
.751 .605 .696 r
.49952 .60685 .50747 .63069 .52214 .61132 .51421 .58696 Mtetra
.736 .595 .699 r
.51421 .58696 .52214 .61132 .53676 .59136 .52885 .56941 Mtetra
.723 .6 .718 r
.52885 .56941 .53676 .59136 .55134 .57338 .54347 .55539 Mtetra
.711 .62 .754 r
.54347 .55539 .55134 .57338 .56591 .55855 .55812 .54506 Mtetra
.693 .659 .812 r
.55812 .54506 .56591 .55855 .58053 .54716 .57285 .53811 Mtetra
.65 .724 .903 r
.57285 .53811 .58053 .54716 .59524 .53902 .58769 .534 Mtetra
.515 .791 .995 r
.58769 .534 .59524 .53902 .61006 .53371 .60266 .53217 Mtetra
.154 .683 .865 r
.60266 .53217 .61006 .53371 .62503 .53076 .61779 .53212 Mtetra
.22 0 0 r
.61779 .53212 .62503 .53076 .64015 .52971 .63309 .53338 Mtetra
.395 0 0 r
.63309 .53338 .64015 .52971 .65545 .53012 .64855 .53558 Mtetra
.469 0 0 r
.64855 .53558 .65545 .53012 .67093 .53165 .66419 .53842 Mtetra
.502 .012 .024 r
.66419 .53842 .67093 .53165 .68658 .53398 .68 .54167 Mtetra
.517 .042 .065 r
.68 .54167 .68658 .53398 .70241 .53687 .69598 .54513 Mtetra
.523 .056 .086 r
.69598 .54513 .70241 .53687 .71842 .54011 .71213 .54866 Mtetra
.523 .059 .093 r
.71213 .54866 .71842 .54011 .7346 .54356 .72844 .55215 Mtetra
.519 .054 .089 r
.72844 .55215 .7346 .54356 .75095 .54709 .74491 .55552 Mtetra
.511 .042 .077 r
.74491 .55552 .75095 .54709 .76747 .55059 .76155 .55872 Mtetra
.501 .025 .058 r
.76155 .55872 .76747 .55059 .78415 .554 .77833 .56169 Mtetra
.487 .003 .031 r
.77833 .56169 .78415 .554 .80099 .55727 .79526 .56441 Mtetra
.469 0 0 r
.79526 .56441 .80099 .55727 .81799 .56034 .81234 .56686 Mtetra
.448 0 0 r
.81234 .56686 .81799 .56034 .83514 .5632 .82956 .56902 Mtetra
.421 0 0 r
.82956 .56902 .83514 .5632 .85244 .56581 .84693 .5709 Mtetra
.389 0 0 r
.84693 .5709 .85244 .56581 .86989 .56817 .86443 .57249 Mtetra
.349 0 0 r
.86443 .57249 .86989 .56817 .88748 .57026 .88207 .5738 Mtetra
.302 0 0 r
.88207 .5738 .88748 .57026 .90521 .57209 .89984 .57482 Mtetra
.246 0 0 r
.89984 .57482 .90521 .57209 .92308 .57365 .91775 .57557 Mtetra
.179 0 0 r
.91775 .57557 .92308 .57365 .94109 .57495 .93579 .57605 Mtetra
.105 0 0 r
.93579 .57605 .94109 .57495 .95923 .57598 .95395 .57627 Mtetra
.621 .624 .833 r
.3351 .64049 .34341 .65386 .35702 .65418 .34887 .63783 Mtetra
.629 .592 .793 r
.34887 .63783 .35702 .65418 .3708 .65317 .36275 .63451 Mtetra
.466 .482 .79 r
.36275 .63451 .3708 .65317 .38552 .63112 .37638 .63898 Mtetra
0 0 0 r
.37638 .63898 .38552 .63112 .39874 .64831 .39079 .62702 Mtetra
.77 .625 .699 r
.39079 .62702 .39874 .64831 .41376 .6173 .40554 .60546 Mtetra
0 .188 .719 r
.40554 .60546 .41376 .6173 .42794 .61126 .41917 .61819 Mtetra
.75 .34 .274 r
.41917 .61819 .42794 .61126 .44161 .6288 .43294 .6341 Mtetra
.382 0 0 r
.43294 .6341 .44161 .6288 .45561 .64189 .44728 .63479 Mtetra
.812 .792 .834 r
.44728 .63479 .45561 .64189 .47008 .64004 .462 .62175 Mtetra
.777 .647 .719 r
.462 .62175 .47008 .64004 .48478 .62623 .47681 .60236 Mtetra
.751 .605 .696 r
.47681 .60236 .48478 .62623 .49952 .60685 .49157 .58258 Mtetra
.733 .594 .701 r
.49157 .58258 .49952 .60685 .51421 .58696 .50626 .56558 Mtetra
.719 .601 .724 r
.50626 .56558 .51421 .58696 .52885 .56941 .52092 .55252 Mtetra
.703 .626 .768 r
.52092 .55252 .52885 .56941 .54347 .55539 .53559 .54341 Mtetra
.678 .676 .842 r
.53559 .54341 .54347 .55539 .55812 .54506 .55033 .53776 Mtetra
.603 .754 .95 r
.55033 .53776 .55812 .54506 .57285 .53811 .56517 .53492 Mtetra
.344 .766 .976 r
.56517 .53492 .57285 .53811 .58769 .534 .58014 .53424 Mtetra
.106 0 0 r
.58014 .53424 .58769 .534 .60266 .53217 .59526 .53516 Mtetra
.361 0 0 r
.59526 .53516 .60266 .53217 .61779 .53212 .61054 .5372 Mtetra
.459 0 0 r
.61054 .5372 .61779 .53212 .63309 .53338 .62598 .53998 Mtetra
.5 .006 .015 r
.62598 .53998 .63309 .53338 .64855 .53558 .64159 .54322 Mtetra
.517 .041 .063 r
.64159 .54322 .64855 .53558 .66419 .53842 .65737 .54669 Mtetra
.523 .055 .086 r
.65737 .54669 .66419 .53842 .68 .54167 .67332 .55023 Mtetra
.522 .058 .092 r
.67332 .55023 .68 .54167 .69598 .54513 .68943 .5537 Mtetra
.517 .051 .087 r
.68943 .5537 .69598 .54513 .71213 .54866 .70569 .55701 Mtetra
.508 .037 .072 r
.70569 .55701 .71213 .54866 .72844 .55215 .72211 .56012 Mtetra
.495 .016 .048 r
.72211 .56012 .72844 .55215 .74491 .55552 .73868 .56296 Mtetra
.478 0 .016 r
.73868 .56296 .74491 .55552 .76155 .55872 .7554 .56552 Mtetra
.457 0 0 r
.7554 .56552 .76155 .55872 .77833 .56169 .77226 .56778 Mtetra
.43 0 0 r
.77226 .56778 .77833 .56169 .79526 .56441 .78926 .56972 Mtetra
.397 0 0 r
.78926 .56972 .79526 .56441 .81234 .56686 .8064 .57135 Mtetra
.357 0 0 r
.8064 .57135 .81234 .56686 .82956 .56902 .82367 .57266 Mtetra
.307 0 0 r
.82367 .57266 .82956 .56902 .84693 .5709 .84108 .57367 Mtetra
.246 0 0 r
.84108 .57367 .84693 .5709 .86443 .57249 .85862 .57439 Mtetra
.175 0 0 r
.85862 .57439 .86443 .57249 .88207 .5738 .87629 .57481 Mtetra
.093 0 0 r
.87629 .57481 .88207 .5738 .89984 .57482 .89409 .57496 Mtetra
.004 0 0 r
.89409 .57496 .89984 .57482 .91775 .57557 .91202 .57484 Mtetra
.089 .645 .791 r
.91202 .57484 .91775 .57557 .93579 .57605 .93007 .57446 Mtetra
.178 .702 .869 r
.93007 .57446 .93579 .57605 .95395 .57627 .94825 .57384 Mtetra
.848 .922 .88 r
.32602 .63942 .3351 .64049 .34887 .63783 .3404 .62655 Mtetra
.734 .697 .816 r
.3404 .62655 .34887 .63783 .36275 .63451 .35459 .61756 Mtetra
0 .066 .63 r
.35459 .61756 .36275 .63451 .37638 .63898 .3676 .63533 Mtetra
.915 .802 .721 r
.3676 .63533 .37638 .63898 .39079 .62702 .38282 .6057 Mtetra
.533 .498 .762 r
.38282 .6057 .39079 .62702 .40554 .60546 .39673 .60771 Mtetra
.793 .354 .204 r
.39673 .60771 .40554 .60546 .41917 .61819 .41024 .62552 Mtetra
.539 .07 .091 r
.41024 .62552 .41917 .61819 .43294 .6341 .42441 .6293 Mtetra
.818 .846 .87 r
.42441 .6293 .43294 .6341 .44728 .63479 .43912 .61724 Mtetra
.781 .654 .722 r
.43912 .61724 .44728 .63479 .462 .62175 .454 .59786 Mtetra
.75 .605 .697 r
.454 .59786 .462 .62175 .47681 .60236 .46883 .57823 Mtetra
.729 .593 .703 r
.46883 .57823 .47681 .60236 .49157 .58258 .48357 .56193 Mtetra
.713 .602 .732 r
.48357 .56193 .49157 .58258 .50626 .56558 .49825 .55002 Mtetra
.693 .635 .787 r
.49825 .55002 .50626 .56558 .52092 .55252 .51292 .5423 Mtetra
.652 .701 .882 r
.51292 .5423 .52092 .55252 .53559 .54341 .52766 .53808 Mtetra
.505 .778 .994 r
.52766 .53808 .53559 .54341 .55033 .53776 .54248 .53656 Mtetra
.069 .626 .808 r
.54248 .53656 .55033 .53776 .56517 .53492 .55743 .53701 Mtetra
.305 0 0 r
.55743 .53701 .56517 .53492 .58014 .53424 .57253 .53883 Mtetra
.445 0 0 r
.57253 .53883 .58014 .53424 .59526 .53516 .58779 .54155 Mtetra
.496 0 .004 r
.58779 .54155 .59526 .53516 .61054 .5372 .6032 .54478 Mtetra
.517 .039 .061 r
.6032 .54478 .61054 .5372 .62598 .53998 .61878 .54826 Mtetra
.523 .055 .086 r
.61878 .54826 .62598 .53998 .64159 .54322 .63452 .55179 Mtetra
.521 .057 .091 r
.63452 .55179 .64159 .54322 .65737 .54669 .65042 .55523 Mtetra
.514 .048 .084 r
.65042 .55523 .65737 .54669 .67332 .55023 .66648 .55848 Mtetra
.503 .03 .065 r
.66648 .55848 .67332 .55023 .68943 .5537 .68269 .56147 Mtetra
.487 .005 .036 r
.68269 .56147 .68943 .5537 .70569 .55701 .69905 .56415 Mtetra
.467 0 0 r
.69905 .56415 .70569 .55701 .72211 .56012 .71555 .56651 Mtetra
.44 0 0 r
.71555 .56651 .72211 .56012 .73868 .56296 .7322 .56853 Mtetra
.407 0 0 r
.7322 .56853 .73868 .56296 .7554 .56552 .74898 .57021 Mtetra
.365 0 0 r
.74898 .57021 .7554 .56552 .77226 .56778 .7659 .57154 Mtetra
.312 0 0 r
.7659 .57154 .77226 .56778 .78926 .56972 .78295 .57254 Mtetra
.248 0 0 r
.78295 .57254 .78926 .56972 .8064 .57135 .80013 .57321 Mtetra
.169 0 0 r
.80013 .57321 .8064 .57135 .82367 .57266 .81744 .57357 Mtetra
.079 0 0 r
.81744 .57357 .82367 .57266 .84108 .57367 .83487 .57363 Mtetra
.019 .593 .719 r
.83487 .57363 .84108 .57367 .85862 .57439 .85244 .57341 Mtetra
.119 .666 .817 r
.85244 .57341 .85862 .57439 .87629 .57481 .87012 .57291 Mtetra
.214 .723 .895 r
.87012 .57291 .87629 .57481 .89409 .57496 .88793 .57216 Mtetra
.298 .76 .948 r
.88793 .57216 .89409 .57496 .91202 .57484 .90587 .57116 Mtetra
.367 .78 .98 r
.90587 .57116 .91202 .57484 .93007 .57446 .92392 .56992 Mtetra
.423 .788 .995 r
.92392 .56992 .93007 .57446 .94825 .57384 .9421 .56847 Mtetra
.294 .436 .834 r
.31765 .62457 .32602 .63942 .3404 .62655 .33094 .63176 Mtetra
.508 .887 .698 r
.33094 .63176 .3404 .62655 .35459 .61756 .34528 .62199 Mtetra
.417 .844 .694 r
.34528 .62199 .35459 .61756 .3676 .63533 .35956 .61401 Mtetra
.733 .607 .717 r
.35956 .61401 .3676 .63533 .38282 .6057 .3742 .59891 Mtetra
.741 .233 0 r
.3742 .59891 .38282 .6057 .39673 .60771 .38754 .61602 Mtetra
.629 .193 .194 r
.38754 .61602 .39673 .60771 .41024 .62552 .40147 .62346 Mtetra
.806 .922 .914 r
.40147 .62346 .41024 .62552 .42441 .6293 .41616 .6127 Mtetra
.787 .663 .727 r
.41616 .6127 .42441 .6293 .43912 .61724 .4311 .59333 Mtetra
.748 .604 .697 r
.4311 .59333 .43912 .61724 .454 .59786 .446 .57395 Mtetra
.724 .591 .707 r
.446 .57395 .454 .59786 .46883 .57823 .46077 .55854 Mtetra
.705 .605 .743 r
.46077 .55854 .46883 .57823 .48357 .56193 .47545 .548 Mtetra
.678 .649 .814 r
.47545 .548 .48357 .56193 .49825 .55002 .49011 .54185 Mtetra
.603 .733 .936 r
.49011 .54185 .49825 .55002 .51292 .5423 .50482 .53916 Mtetra
.294 .741 .961 r
.50482 .53916 .51292 .5423 .52766 .53808 .51962 .53897 Mtetra
.211 0 0 r
.51962 .53897 .52766 .53808 .54248 .53656 .53454 .5405 Mtetra
.423 0 0 r
.53454 .5405 .54248 .53656 .55743 .53701 .5496 .54311 Mtetra
.492 0 0 r
.5496 .54311 .55743 .53701 .57253 .53883 .56482 .54633 Mtetra
.516 .037 .057 r
.56482 .54633 .57253 .53883 .58779 .54155 .5802 .54982 Mtetra
.522 .055 .085 r
.5802 .54982 .58779 .54155 .6032 .54478 .59574 .55335 Mtetra
.52 .055 .09 r
.59574 .55335 .6032 .54478 .61878 .54826 .61144 .55674 Mtetra
.511 .043 .079 r
.61144 .55674 .61878 .54826 .63452 .55179 .62729 .55989 Mtetra
.497 .021 .055 r
.62729 .55989 .63452 .55179 .65042 .55523 .64329 .56273 Mtetra
.477 0 .019 r
.64329 .56273 .65042 .55523 .66648 .55848 .65944 .56522 Mtetra
.451 0 0 r
.65944 .56522 .66648 .55848 .68269 .56147 .67573 .56734 Mtetra
.418 0 0 r
.67573 .56734 .68269 .56147 .69905 .56415 .69216 .56907 Mtetra
.374 0 0 r
.69216 .56907 .69905 .56415 .71555 .56651 .70872 .57043 Mtetra
.319 0 0 r
.70872 .57043 .71555 .56651 .7322 .56853 .72542 .57141 Mtetra
.249 0 0 r
.72542 .57141 .7322 .56853 .74898 .57021 .74225 .57204 Mtetra
.163 0 0 r
.74225 .57204 .74898 .57021 .7659 .57154 .75921 .57233 Mtetra
.063 0 0 r
.75921 .57233 .7659 .57154 .78295 .57254 .77629 .57229 Mtetra
.047 .614 .745 r
.77629 .57229 .78295 .57254 .80013 .57321 .7935 .57195 Mtetra
.156 .69 .847 r
.7935 .57195 .80013 .57321 .81744 .57357 .81083 .57131 Mtetra
.255 .743 .921 r
.81083 .57131 .81744 .57357 .83487 .57363 .82828 .5704 Mtetra
.34 .774 .968 r
.82828 .5704 .83487 .57363 .85244 .57341 .84585 .56923 Mtetra
.407 .788 .992 r
.84585 .56923 .85244 .57341 .87012 .57291 .86354 .56782 Mtetra
.459 .789 .999 r
.86354 .56782 .87012 .57291 .88793 .57216 .88135 .56618 Mtetra
.498 .782 .996 r
.88135 .56618 .88793 .57216 .90587 .57116 .89928 .56432 Mtetra
.527 .771 .987 r
.89928 .56432 .90587 .57116 .92392 .56992 .91733 .56226 Mtetra
.549 .759 .975 r
.91733 .56226 .92392 .56992 .9421 .56847 .9355 .56 Mtetra
.819 .958 .904 r
.3083 .62459 .31765 .62457 .33094 .63176 .32273 .61308 Mtetra
.303 .388 .784 r
.32273 .61308 .33094 .63176 .34528 .62199 .33606 .62205 Mtetra
.936 .862 .742 r
.33606 .62205 .34528 .62199 .35956 .61401 .35139 .59511 Mtetra
.251 .353 .774 r
.35139 .59511 .35956 .61401 .3742 .59891 .36486 .60561 Mtetra
.7 .267 .218 r
.36486 .60561 .3742 .59891 .38754 .61602 .37848 .61715 Mtetra
.694 .976 .91 r
.37848 .61715 .38754 .61602 .40147 .62346 .3931 .60812 Mtetra
.794 .675 .733 r
.3931 .60812 .40147 .62346 .41616 .6127 .40811 .58879 Mtetra
.746 .603 .699 r
.40811 .58879 .41616 .6127 .4311 .59333 .42307 .56976 Mtetra
.718 .59 .711 r
.42307 .56976 .4311 .59333 .446 .57395 .43785 .55549 Mtetra
.694 .61 .758 r
.43785 .55549 .446 .57395 .46077 .55854 .45251 .54659 Mtetra
.653 .67 .854 r
.45251 .54659 .46077 .55854 .47545 .548 .46714 .5422 Mtetra
.492 .76 .99 r
.46714 .5422 .47545 .548 .49011 .54185 .4818 .5411 Mtetra
0 .541 .718 r
.4818 .5411 .49011 .54185 .50482 .53916 .49656 .54221 Mtetra
.388 0 0 r
.49656 .54221 .50482 .53916 .51962 .53897 .51144 .54468 Mtetra
.485 0 0 r
.51144 .54468 .51962 .53897 .53454 .5405 .52646 .54788 Mtetra
.515 .034 .052 r
.52646 .54788 .53454 .5405 .5496 .54311 .54164 .55139 Mtetra
.522 .054 .084 r
.54164 .55139 .5496 .54311 .56482 .54633 .55697 .5549 Mtetra
.517 .052 .088 r
.55697 .5549 .56482 .54633 .5802 .54982 .57246 .55822 Mtetra
.506 .036 .072 r
.57246 .55822 .5802 .54982 .59574 .55335 .58811 .56125 Mtetra
.488 .008 .041 r
.58811 .56125 .59574 .55335 .61144 .55674 .60391 .56389 Mtetra
.463 0 0 r
.60391 .56389 .61144 .55674 .62729 .55989 .61985 .56613 Mtetra
.43 0 0 r
.61985 .56613 .62729 .55989 .64329 .56273 .63593 .56794 Mtetra
.385 0 0 r
.63593 .56794 .64329 .56273 .65944 .56522 .65215 .56932 Mtetra
.326 0 0 r
.65215 .56932 .65944 .56522 .67573 .56734 .6685 .5703 Mtetra
.25 0 0 r
.6685 .5703 .67573 .56734 .69216 .56907 .68499 .57088 Mtetra
.155 0 0 r
.68499 .57088 .69216 .56907 .70872 .57043 .7016 .57108 Mtetra
.042 0 0 r
.7016 .57108 .70872 .57043 .72542 .57141 .71834 .57092 Mtetra
.08 .64 .776 r
.71834 .57092 .72542 .57141 .74225 .57204 .73519 .57044 Mtetra
.198 .715 .879 r
.73519 .57044 .74225 .57204 .75921 .57233 .75218 .56964 Mtetra
.302 .763 .948 r
.75218 .56964 .75921 .57233 .77629 .57229 .76928 .56854 Mtetra
.385 .786 .985 r
.76928 .56854 .77629 .57229 .7935 .57195 .7865 .56718 Mtetra
.447 .791 .998 r
.7865 .56718 .7935 .57195 .81083 .57131 .80383 .56556 Mtetra
.493 .785 .997 r
.80383 .56556 .81083 .57131 .82828 .5704 .82129 .56371 Mtetra
.527 .774 .988 r
.82129 .56371 .82828 .5704 .84585 .56923 .83886 .56163 Mtetra
.551 .759 .974 r
.83886 .56163 .84585 .56923 .86354 .56782 .85655 .55935 Mtetra
.569 .745 .959 r
.85655 .55935 .86354 .56782 .88135 .56618 .87435 .55687 Mtetra
.582 .73 .945 r
.87435 .55687 .88135 .56618 .89928 .56432 .89227 .55422 Mtetra
.592 .717 .93 r
.89227 .55422 .89928 .56432 .91733 .56226 .91031 .55139 Mtetra
.6 .704 .917 r
.91031 .55139 .91733 .56226 .9355 .56 .92846 .5484 Mtetra
.638 .602 .798 r
.29987 .60845 .3083 .62459 .32273 .61308 .31387 .60447 Mtetra
.637 .728 .914 r
.31387 .60447 .32273 .61308 .33606 .62205 .32792 .60087 Mtetra
.651 .567 .747 r
.32792 .60087 .33606 .62205 .35139 .59511 .34218 .59493 Mtetra
.773 .293 .093 r
.34218 .59493 .35139 .59511 .36486 .60561 .35545 .61015 Mtetra
0 0 0 r
.35545 .61015 .36486 .60561 .37848 .61715 .36995 .6035 Mtetra
.805 .694 .742 r
.36995 .6035 .37848 .61715 .3931 .60812 .38503 .58424 Mtetra
.744 .602 .7 r
.38503 .58424 .3931 .60812 .40811 .58879 .40003 .56573 Mtetra
.709 .588 .718 r
.40003 .56573 .40811 .58879 .42307 .56976 .4148 .55292 Mtetra
.677 .617 .781 r
.4148 .55292 .42307 .56976 .43785 .55549 .42942 .54598 Mtetra
.602 .701 .913 r
.42942 .54598 .43785 .55549 .45251 .54659 .44398 .5435 Mtetra
.222 .7 .936 r
.44398 .5435 .45251 .54659 .46714 .5422 .45858 .544 Mtetra
.322 0 0 r
.45858 .544 .46714 .5422 .4818 .5411 .47328 .54626 Mtetra
.475 0 0 r
.47328 .54626 .4818 .5411 .49656 .54221 .48811 .54944 Mtetra
.514 .03 .046 r
.48811 .54944 .49656 .54221 .51144 .54468 .50308 .55295 Mtetra
.521 .052 .083 r
.50308 .55295 .51144 .54468 .52646 .54788 .51822 .55644 Mtetra
.514 .048 .084 r
.51822 .55644 .52646 .54788 .54164 .55139 .53351 .55966 Mtetra
.499 .026 .063 r
.53351 .55966 .54164 .55139 .55697 .5549 .54895 .5625 Mtetra
.476 0 .022 r
.54895 .5625 .55697 .5549 .57246 .55822 .56454 .56489 Mtetra
.443 0 0 r
.56454 .56489 .57246 .55822 .58811 .56125 .58028 .5668 Mtetra
.397 0 0 r
.58028 .5668 .58811 .56125 .60391 .56389 .59616 .56823 Mtetra
.335 0 0 r
.59616 .56823 .60391 .56389 .61985 .56613 .61218 .56919 Mtetra
.252 0 0 r
.61218 .56919 .61985 .56613 .63593 .56794 .62832 .56971 Mtetra
.145 0 0 r
.62832 .56971 .63593 .56794 .65215 .56932 .6446 .56981 Mtetra
.016 0 0 r
.6446 .56981 .65215 .56932 .6685 .5703 .661 .56951 Mtetra
.121 .669 .811 r
.661 .56951 .6685 .5703 .68499 .57088 .67752 .56885 Mtetra
.249 .742 .913 r
.67752 .56885 .68499 .57088 .7016 .57108 .69416 .56786 Mtetra
.353 .781 .972 r
.69416 .56786 .7016 .57108 .71834 .57092 .71092 .56655 Mtetra
.432 .793 .996 r
.71092 .56655 .71834 .57092 .73519 .57044 .7278 .56496 Mtetra
.488 .789 .998 r
.7278 .56496 .73519 .57044 .75218 .56964 .74479 .56311 Mtetra
.527 .776 .989 r
.74479 .56311 .75218 .56964 .76928 .56854 .7619 .56101 Mtetra
.554 .76 .974 r
.7619 .56101 .76928 .56854 .7865 .56718 .77912 .55869 Mtetra
.573 .743 .957 r
.77912 .55869 .7865 .56718 .80383 .56556 .79646 .55615 Mtetra
.587 .727 .94 r
.79646 .55615 .80383 .56556 .82129 .56371 .81391 .55343 Mtetra
.597 .712 .925 r
.81391 .55343 .82129 .56371 .83886 .56163 .83147 .55052 Mtetra
.604 .699 .91 r
.83147 .55052 .83886 .56163 .85655 .55935 .84915 .54745 Mtetra
.61 .686 .897 r
.84915 .54745 .85655 .55935 .87435 .55687 .86694 .54423 Mtetra
.614 .675 .885 r
.86694 .54423 .87435 .55687 .89227 .55422 .88485 .54085 Mtetra
.617 .665 .874 r
.88485 .54085 .89227 .55422 .91031 .55139 .90287 .53734 Mtetra
.619 .656 .864 r
.90287 .53734 .91031 .55139 .92846 .5484 .921 .5337 Mtetra
0 0 0 r
.29022 .60937 .29987 .60845 .31387 .60447 .30411 .60831 Mtetra
.931 .954 .775 r
.30411 .60831 .31387 .60447 .32792 .60087 .31934 .58663 Mtetra
0 .069 .629 r
.31934 .58663 .32792 .60087 .34218 .59493 .33242 .60211 Mtetra
.191 0 0 r
.33242 .60211 .34218 .59493 .35545 .61015 .34671 .59881 Mtetra
.821 .721 .755 r
.34671 .59881 .35545 .61015 .36995 .6035 .36185 .57967 Mtetra
.739 .601 .702 r
.36185 .57967 .36995 .6035 .38503 .58424 .37688 .56194 Mtetra
.697 .586 .727 r
.37688 .56194 .38503 .58424 .40003 .56573 .3916 .55105 Mtetra
.651 .63 .817 r
.3916 .55105 .40003 .56573 .4148 .55292 .40613 .54637 Mtetra
.473 .732 .983 r
.40613 .54637 .4148 .55292 .42942 .54598 .42061 .5459 Mtetra
.183 0 0 r
.42061 .5459 .42942 .54598 .44398 .5435 .43513 .54785 Mtetra
.458 0 0 r
.43513 .54785 .44398 .5435 .45858 .544 .44977 .55099 Mtetra
.511 .024 .036 r
.44977 .55099 .45858 .544 .47328 .54626 .46454 .55451 Mtetra
.519 .05 .08 r
.46454 .55451 .47328 .54626 .48811 .54944 .47948 .55795 Mtetra
.509 .041 .079 r
.47948 .55795 .48811 .54944 .50308 .55295 .49457 .56103 Mtetra
.488 .011 .048 r
.49457 .56103 .50308 .55295 .51822 .55644 .50981 .56362 Mtetra
.457 0 0 r
.50981 .56362 .51822 .55644 .53351 .55966 .52521 .56566 Mtetra
.411 0 0 r
.52521 .56566 .53351 .55966 .54895 .5625 .54075 .56715 Mtetra
.346 0 0 r
.54075 .56715 .54895 .5625 .56454 .56489 .55643 .5681 Mtetra
.254 0 0 r
.55643 .5681 .56454 .56489 .58028 .5668 .57225 .56854 Mtetra
.131 0 0 r
.57225 .56854 .58028 .5668 .59616 .56823 .5882 .5685 Mtetra
0 0 0 r
.5882 .5685 .59616 .56823 .61218 .56919 .60427 .56803 Mtetra
.173 .702 .852 r
.60427 .56803 .61218 .56919 .62832 .56971 .62047 .56716 Mtetra
.308 .769 .947 r
.62047 .56716 .62832 .56971 .6446 .56981 .63678 .56593 Mtetra
.41 .794 .99 r
.63678 .56593 .6446 .56981 .661 .56951 .65321 .56437 Mtetra
.48 .793 .999 r
.65321 .56437 .661 .56951 .67752 .56885 .66976 .56251 Mtetra
.527 .78 .99 r
.66976 .56251 .67752 .56885 .69416 .56786 .68642 .56038 Mtetra
.558 .761 .973 r
.68642 .56038 .69416 .56786 .71092 .56655 .70319 .558 Mtetra
.578 .742 .954 r
.70319 .558 .71092 .56655 .7278 .56496 .72008 .5554 Mtetra
.592 .723 .935 r
.72008 .5554 .7278 .56496 .74479 .56311 .73707 .55258 Mtetra
.602 .707 .917 r
.73707 .55258 .74479 .56311 .7619 .56101 .75418 .54958 Mtetra
.609 .692 .902 r
.75418 .54958 .7619 .56101 .77912 .55869 .7714 .5464 Mtetra
.614 .678 .887 r
.7714 .5464 .77912 .55869 .79646 .55615 .78873 .54307 Mtetra
.618 .667 .875 r
.78873 .54307 .79646 .55615 .81391 .55343 .80617 .53958 Mtetra
.62 .656 .864 r
.80617 .53958 .81391 .55343 .83147 .55052 .82372 .53595 Mtetra
.622 .647 .854 r
.82372 .53595 .83147 .55052 .84915 .54745 .84138 .5322 Mtetra
.624 .639 .845 r
.84138 .5322 .84915 .54745 .86694 .54423 .85915 .52832 Mtetra
.625 .631 .837 r
.85915 .52832 .86694 .54423 .88485 .54085 .87704 .52434 Mtetra
.626 .625 .83 r
.87704 .52434 .88485 .54085 .90287 .53734 .89504 .52024 Mtetra
.626 .619 .823 r
.89504 .52024 .90287 .53734 .921 .5337 .91315 .51605 Mtetra
.639 .594 .787 r
.28173 .59213 .29022 .60937 .30411 .60831 .29583 .58778 Mtetra
.451 .461 .778 r
.29583 .58778 .30411 .60831 .31934 .58663 .30943 .59263 Mtetra
.421 0 0 r
.30943 .59263 .31934 .58663 .33242 .60211 .32338 .59403 Mtetra
.845 .767 .776 r
.32338 .59403 .33242 .60211 .34671 .59881 .33857 .57511 Mtetra
.733 .598 .706 r
.33857 .57511 .34671 .59881 .36185 .57967 .3536 .55856 Mtetra
.678 .584 .743 r
.3536 .55856 .36185 .57967 .37688 .56194 .36823 .55015 Mtetra
.597 .654 .877 r
.36823 .55015 .37688 .56194 .3916 .55105 .38263 .54802 Mtetra
.112 .631 .886 r
.38263 .54802 .3916 .55105 .40613 .54637 .397 .54947 Mtetra
.423 0 0 r
.397 .54947 .40613 .54637 .42061 .5459 .41144 .55254 Mtetra
.508 .015 .021 r
.41144 .55254 .42061 .5459 .43513 .54785 .42602 .55607 Mtetra
.516 .045 .076 r
.42602 .55607 .43513 .54785 .44977 .55099 .44075 .55942 Mtetra
.501 .031 .07 r
.44075 .55942 .44977 .55099 .46454 .55451 .45565 .56227 Mtetra
.472 0 .024 r
.45565 .56227 .46454 .55451 .47948 .55795 .4707 .5645 Mtetra
.427 0 0 r
.4707 .5645 .47948 .55795 .49457 .56103 .48591 .56608 Mtetra
.358 0 0 r
.48591 .56608 .49457 .56103 .50981 .56362 .50127 .56701 Mtetra
.256 0 0 r
.50127 .56701 .50981 .56362 .52521 .56566 .51676 .56735 Mtetra
.113 0 0 r
.51676 .56735 .52521 .56566 .54075 .56715 .53239 .56714 Mtetra
.063 .627 .744 r
.53239 .56714 .54075 .56715 .55643 .5681 .54815 .56645 Mtetra
.237 .74 .898 r
.54815 .56645 .55643 .5681 .57225 .56854 .56403 .56532 Mtetra
.376 .792 .978 r
.56403 .56532 .57225 .56854 .5882 .5685 .58003 .5638 Mtetra
.469 .799 .999 r
.58003 .5638 .5882 .5685 .60427 .56803 .59614 .56192 Mtetra
.527 .784 .991 r
.59614 .56192 .60427 .56803 .62047 .56716 .61237 .55974 Mtetra
.562 .762 .972 r
.61237 .55974 .62047 .56716 .63678 .56593 .62871 .55729 Mtetra
.585 .739 .95 r
.62871 .55729 .63678 .56593 .65321 .56437 .64516 .55458 Mtetra
.599 .718 .928 r
.64516 .55458 .65321 .56437 .66976 .56251 .66172 .55165 Mtetra
.608 .7 .909 r
.66172 .55165 .66976 .56251 .68642 .56038 .67839 .54853 Mtetra
.615 .683 .891 r
.67839 .54853 .68642 .56038 .70319 .558 .69517 .54521 Mtetra
.619 .669 .876 r
.69517 .54521 .70319 .558 .72008 .5554 .71205 .54174 Mtetra
.622 .657 .863 r
.71205 .54174 .72008 .5554 .73707 .55258 .72904 .53811 Mtetra
.624 .646 .852 r
.72904 .53811 .73707 .55258 .75418 .54958 .74614 .53434 Mtetra
.625 .636 .842 r
.74614 .53434 .75418 .54958 .7714 .5464 .76335 .53045 Mtetra
.626 .628 .833 r
.76335 .53045 .7714 .5464 .78873 .54307 .78067 .52644 Mtetra
.627 .621 .825 r
.78067 .52644 .78873 .54307 .80617 .53958 .79809 .52232 Mtetra
.627 .614 .818 r
.79809 .52232 .80617 .53958 .82372 .53595 .81562 .5181 Mtetra
.628 .608 .812 r
.81562 .5181 .82372 .53595 .84138 .5322 .83327 .51378 Mtetra
.628 .603 .806 r
.83327 .51378 .84138 .5322 .85915 .52832 .85102 .50937 Mtetra
.628 .599 .801 r
.85102 .50937 .85915 .52832 .87704 .52434 .86888 .50488 Mtetra
.628 .594 .797 r
.86888 .50488 .87704 .52434 .89504 .52024 .88686 .50031 Mtetra
.628 .59 .793 r
.88686 .50031 .89504 .52024 .91315 .51605 .90495 .49566 Mtetra
.801 .985 .892 r
.27179 .59372 .28173 .59213 .29583 .58778 .2865 .5819 Mtetra
0 .281 .694 r
.2865 .5819 .29583 .58778 .30943 .59263 .29997 .58908 Mtetra
.88 .845 .806 r
.29997 .58908 .30943 .59263 .32338 .59403 .3152 .57057 Mtetra
.722 .593 .712 r
.3152 .57057 .32338 .59403 .33857 .57511 .33017 .55587 Mtetra
.646 .582 .769 r
.33017 .55587 .33857 .57511 .3536 .55856 .34463 .55062 Mtetra
.449 .684 .966 r
.34463 .55062 .3536 .55856 .36823 .55015 .35887 .55113 Mtetra
.336 0 0 r
.35887 .55113 .36823 .55015 .38263 .54802 .37313 .55409 Mtetra
.501 0 0 r
.37313 .55409 .38263 .54802 .397 .54947 .38751 .55762 Mtetra
.51 .038 .069 r
.38751 .55762 .397 .54947 .41144 .55254 .40204 .56081 Mtetra
.488 .013 .054 r
.40204 .56081 .41144 .55254 .42602 .55607 .41676 .56331 Mtetra
.444 0 0 r
.41676 .56331 .42602 .55607 .44075 .55942 .43163 .56501 Mtetra
.373 0 0 r
.43163 .56501 .44075 .55942 .45565 .56227 .44667 .56593 Mtetra
.259 0 0 r
.44667 .56593 .45565 .56227 .4707 .5645 .46185 .56613 Mtetra
.088 0 0 r
.46185 .56613 .4707 .5645 .48591 .56608 .47717 .56569 Mtetra
.125 .673 .797 r
.47717 .56569 .48591 .56608 .50127 .56701 .49263 .5647 Mtetra
.319 .778 .946 r
.49263 .5647 .50127 .56701 .51676 .56735 .5082 .56323 Mtetra
.45 .805 .997 r
.5082 .56323 .51676 .56735 .53239 .56714 .5239 .56134 Mtetra
.526 .791 .993 r
.5239 .56134 .53239 .56714 .54815 .56645 .53971 .55908 Mtetra
.568 .764 .97 r
.53971 .55908 .54815 .56645 .56403 .56532 .55564 .55651 Mtetra
.592 .736 .944 r
.55564 .55651 .56403 .56532 .58003 .5638 .57167 .55367 Mtetra
.606 .711 .919 r
.57167 .55367 .58003 .5638 .59614 .56192 .58781 .55059 Mtetra
.615 .69 .897 r
.58781 .55059 .59614 .56192 .61237 .55974 .60406 .54729 Mtetra
.62 .672 .878 r
.60406 .54729 .61237 .55974 .62871 .55729 .62042 .54381 Mtetra
.623 .657 .862 r
.62042 .54381 .62871 .55729 .64516 .55458 .63688 .54016 Mtetra
.626 .644 .849 r
.63688 .54016 .64516 .55458 .66172 .55165 .65344 .53636 Mtetra
.627 .634 .837 r
.65344 .53636 .66172 .55165 .67839 .54853 .67011 .53243 Mtetra
.628 .624 .828 r
.67011 .53243 .67839 .54853 .69517 .54521 .68688 .52837 Mtetra
.628 .616 .819 r
.68688 .52837 .69517 .54521 .71205 .54174 .70376 .5242 Mtetra
.628 .609 .812 r
.70376 .5242 .71205 .54174 .72904 .53811 .72074 .51993 Mtetra
.628 .603 .805 r
.72074 .51993 .72904 .53811 .74614 .53434 .73782 .51556 Mtetra
.628 .597 .799 r
.73782 .51556 .74614 .53434 .76335 .53045 .75502 .5111 Mtetra
.628 .592 .794 r
.75502 .5111 .76335 .53045 .78067 .52644 .77232 .50656 Mtetra
.628 .588 .789 r
.77232 .50656 .78067 .52644 .79809 .52232 .78972 .50195 Mtetra
.628 .584 .785 r
.78972 .50195 .79809 .52232 .81562 .5181 .80723 .49726 Mtetra
.628 .58 .782 r
.80723 .49726 .81562 .5181 .83327 .51378 .82486 .4925 Mtetra
.628 .577 .778 r
.82486 .4925 .83327 .51378 .85102 .50937 .84259 .48768 Mtetra
.627 .574 .775 r
.84259 .48768 .85102 .50937 .86888 .50488 .86043 .48279 Mtetra
.627 .572 .773 r
.86043 .48279 .86888 .50488 .88686 .50031 .87838 .47784 Mtetra
.627 .569 .77 r
.87838 .47784 .88686 .50031 .90495 .49566 .89644 .47284 Mtetra
.292 .396 .797 r
.26322 .5756 .27179 .59372 .2865 .5819 .27649 .58379 Mtetra
.899 .955 .827 r
.27649 .58379 .2865 .5819 .29997 .58908 .29172 .56612 Mtetra
.701 .585 .723 r
.29172 .56612 .29997 .58908 .3152 .57057 .30654 .55439 Mtetra
.584 .584 .818 r
.30654 .55439 .3152 .57057 .33017 .55587 .32075 .55291 Mtetra
0 .52 .796 r
.32075 .55291 .33017 .55587 .34463 .55062 .33483 .55564 Mtetra
.486 0 0 r
.33483 .55564 .34463 .55062 .35887 .55113 .34901 .55914 Mtetra
.499 .023 .056 r
.34901 .55914 .35887 .55113 .37313 .55409 .36336 .56204 Mtetra
.462 0 .023 r
.36336 .56204 .37313 .55409 .38751 .55762 .37791 .56394 Mtetra
.39 0 0 r
.37791 .56394 .38751 .55762 .40204 .56081 .39263 .56484 Mtetra
.262 0 0 r
.39263 .56484 .40204 .56081 .41676 .56331 .40751 .56484 Mtetra
.049 0 0 r
.40751 .56484 .41676 .56331 .43163 .56501 .42254 .56408 Mtetra
.214 .732 .865 r
.42254 .56408 .43163 .56501 .44667 .56593 .43771 .56267 Mtetra
.416 .809 .986 r
.43771 .56267 .44667 .56593 .46185 .56613 .453 .56074 Mtetra
.525 .8 .996 r
.453 .56074 .46185 .56613 .47717 .56569 .46842 .55837 Mtetra
.577 .766 .968 r
.46842 .55837 .47717 .56569 .49263 .5647 .48394 .55563 Mtetra
.602 .731 .935 r
.48394 .55563 .49263 .5647 .5082 .56323 .49958 .5526 Mtetra
.615 .701 .906 r
.49958 .5526 .5082 .56323 .5239 .56134 .51532 .5493 Mtetra
.622 .677 .881 r
.51532 .5493 .5239 .56134 .53971 .55908 .53117 .54578 Mtetra
.626 .658 .862 r
.53117 .54578 .53971 .55908 .55564 .55651 .54712 .54208 Mtetra
.628 .642 .845 r
.54712 .54208 .55564 .55651 .57167 .55367 .56318 .53821 Mtetra
.629 .629 .832 r
.56318 .53821 .57167 .55367 .58781 .55059 .57933 .5342 Mtetra
.629 .618 .821 r
.57933 .5342 .58781 .55059 .60406 .54729 .59559 .53006 Mtetra
.63 .609 .811 r
.59559 .53006 .60406 .54729 .62042 .54381 .61194 .52581 Mtetra
.629 .602 .803 r
.61194 .52581 .62042 .54381 .63688 .54016 .6284 .52146 Mtetra
.629 .595 .796 r
.6284 .52146 .63688 .54016 .65344 .53636 .64496 .51702 Mtetra
.629 .589 .79 r
.64496 .51702 .65344 .53636 .67011 .53243 .66162 .51249 Mtetra
.629 .584 .785 r
.66162 .51249 .67011 .53243 .68688 .52837 .67838 .50788 Mtetra
.628 .58 .781 r
.67838 .50788 .68688 .52837 .70376 .5242 .69524 .5032 Mtetra
.628 .576 .777 r
.69524 .5032 .70376 .5242 .72074 .51993 .71221 .49846 Mtetra
.628 .573 .773 r
.71221 .49846 .72074 .51993 .73782 .51556 .72927 .49365 Mtetra
.627 .569 .77 r
.72927 .49365 .73782 .51556 .75502 .5111 .74645 .48878 Mtetra
.627 .567 .767 r
.74645 .48878 .75502 .5111 .77232 .50656 .76373 .48386 Mtetra
.627 .564 .765 r
.76373 .48386 .77232 .50656 .78972 .50195 .78111 .47888 Mtetra
.626 .562 .762 r
.78111 .47888 .78972 .50195 .80723 .49726 .7986 .47385 Mtetra
.626 .56 .76 r
.7986 .47385 .80723 .49726 .82486 .4925 .8162 .46876 Mtetra
.626 .558 .758 r
.8162 .46876 .82486 .4925 .84259 .48768 .83391 .46363 Mtetra
.626 .556 .757 r
.83391 .46363 .84259 .48768 .86043 .48279 .85172 .45845 Mtetra
.625 .555 .755 r
.85172 .45845 .86043 .48279 .87838 .47784 .86965 .45323 Mtetra
.625 .553 .754 r
.86965 .45323 .87838 .47784 .89644 .47284 .88769 .44796 Mtetra
.874 .971 .849 r
.25299 .57762 .26322 .5756 .27649 .58379 .26812 .56196 Mtetra
.659 .57 .744 r
.26812 .56196 .27649 .58379 .29172 .56612 .28261 .55502 Mtetra
.424 .596 .916 r
.28261 .55502 .29172 .56612 .30654 .55439 .29654 .5572 Mtetra
.435 0 0 r
.29654 .5572 .30654 .55439 .32075 .55291 .31053 .56059 Mtetra
.473 0 .024 r
.31053 .56059 .32075 .55291 .33483 .55564 .32473 .56287 Mtetra
.408 0 0 r
.32473 .56287 .33483 .55564 .34901 .55914 .33914 .56375 Mtetra
.262 0 0 r
.33914 .56375 .34901 .55914 .36336 .56204 .35374 .56341 Mtetra
0 0 0 r
.35374 .56341 .36336 .56204 .37791 .56394 .3685 .56212 Mtetra
.342 .799 .943 r
.3685 .56212 .37791 .56394 .39263 .56484 .38341 .56011 Mtetra
.521 .815 .999 r
.38341 .56011 .39263 .56484 .40751 .56484 .39845 .55754 Mtetra
.59 .768 .964 r
.39845 .55754 .40751 .56484 .42254 .56408 .4136 .55455 Mtetra
.615 .722 .922 r
.4136 .55455 .42254 .56408 .43771 .56267 .42886 .55121 Mtetra
.626 .686 .887 r
.42886 .55121 .43771 .56267 .453 .56074 .44423 .54761 Mtetra
.63 .659 .86 r
.44423 .54761 .453 .56074 .46842 .55837 .4597 .5438 Mtetra
.631 .639 .839 r
.4597 .5438 .46842 .55837 .48394 .55563 .47527 .53981 Mtetra
.632 .623 .823 r
.47527 .53981 .48394 .55563 .49958 .5526 .49094 .53567 Mtetra
.631 .61 .811 r
.49094 .53567 .49958 .5526 .51532 .5493 .5067 .5314 Mtetra
.631 .6 .8 r
.5067 .5314 .51532 .5493 .53117 .54578 .52257 .52703 Mtetra
.63 .592 .792 r
.52257 .52703 .53117 .54578 .54712 .54208 .53852 .52256 Mtetra
.63 .585 .785 r
.53852 .52256 .54712 .54208 .56318 .53821 .55458 .51801 Mtetra
.629 .579 .779 r
.55458 .51801 .56318 .53821 .57933 .5342 .57073 .51339 Mtetra
.629 .574 .774 r
.57073 .51339 .57933 .5342 .59559 .53006 .58698 .50869 Mtetra
.628 .57 .77 r
.58698 .50869 .59559 .53006 .61194 .52581 .60333 .50394 Mtetra
.627 .566 .766 r
.60333 .50394 .61194 .52581 .6284 .52146 .61978 .49912 Mtetra
.627 .563 .763 r
.61978 .49912 .6284 .52146 .64496 .51702 .63632 .49425 Mtetra
.627 .56 .76 r
.63632 .49425 .64496 .51702 .66162 .51249 .65296 .48933 Mtetra
.626 .558 .758 r
.65296 .48933 .66162 .51249 .67838 .50788 .66971 .48437 Mtetra
.626 .556 .756 r
.66971 .48437 .67838 .50788 .69524 .5032 .68655 .47935 Mtetra
.625 .554 .754 r
.68655 .47935 .69524 .5032 .71221 .49846 .7035 .47429 Mtetra
.625 .552 .752 r
.7035 .47429 .71221 .49846 .72927 .49365 .72055 .46919 Mtetra
.625 .55 .75 r
.72055 .46919 .72927 .49365 .74645 .48878 .7377 .46404 Mtetra
.625 .549 .749 r
.7377 .46404 .74645 .48878 .76373 .48386 .75496 .45885 Mtetra
.624 .548 .748 r
.75496 .45885 .76373 .48386 .78111 .47888 .77232 .45363 Mtetra
.624 .546 .747 r
.77232 .45363 .78111 .47888 .7986 .47385 .78978 .44836 Mtetra
.624 .545 .745 r
.78978 .44836 .7986 .47385 .8162 .46876 .80736 .44305 Mtetra
.624 .544 .745 r
.80736 .44305 .8162 .46876 .83391 .46363 .82504 .4377 Mtetra
.623 .543 .744 r
.82504 .4377 .83391 .46363 .85172 .45845 .84283 .43232 Mtetra
.623 .543 .743 r
.84283 .43232 .85172 .45845 .86965 .45323 .86073 .42689 Mtetra
.623 .542 .742 r
.86073 .42689 .86965 .45323 .88769 .44796 .87874 .42143 Mtetra
.555 .542 .795 r
.24433 .55888 .25299 .57762 .26812 .56196 .25827 .55875 Mtetra
0 .499 .784 r
.25827 .55875 .26812 .56196 .28261 .55502 .27209 .56176 Mtetra
.395 0 0 r
.27209 .56176 .28261 .55502 .29654 .5572 .2862 .56259 Mtetra
.246 0 0 r
.2862 .56259 .29654 .5572 .31053 .56059 .30055 .56159 Mtetra
.149 .692 .75 r
.30055 .56159 .31053 .56059 .32473 .56287 .3151 .55939 Mtetra
.509 .841 .998 r
.3151 .55939 .32473 .56287 .33914 .56375 .32978 .55643 Mtetra
.61 .771 .957 r
.32978 .55643 .33914 .56375 .35374 .56341 .34459 .55297 Mtetra
.632 .705 .899 r
.34459 .55297 .35374 .56341 .3685 .56212 .35951 .54918 Mtetra
.636 .662 .858 r
.35951 .54918 .3685 .56212 .38341 .56011 .37453 .54514 Mtetra
.636 .632 .83 r
.37453 .54514 .38341 .56011 .39845 .55754 .38965 .54093 Mtetra
.635 .612 .81 r
.38965 .54093 .39845 .55754 .4136 .55455 .40486 .53658 Mtetra
.633 .597 .796 r
.40486 .53658 .4136 .55455 .42886 .55121 .42017 .53213 Mtetra
.632 .586 .785 r
.42017 .53213 .42886 .55121 .44423 .54761 .43557 .52758 Mtetra
.63 .578 .777 r
.43557 .52758 .44423 .54761 .4597 .5438 .45105 .52297 Mtetra
.629 .571 .77 r
.45105 .52297 .4597 .5438 .47527 .53981 .46664 .51828 Mtetra
.628 .565 .765 r
.46664 .51828 .47527 .53981 .49094 .53567 .48231 .51355 Mtetra
.627 .561 .76 r
.48231 .51355 .49094 .53567 .5067 .5314 .49807 .50875 Mtetra
.627 .557 .757 r
.49807 .50875 .5067 .5314 .52257 .52703 .51393 .50392 Mtetra
.626 .554 .754 r
.51393 .50392 .52257 .52703 .53852 .52256 .52988 .49904 Mtetra
.625 .552 .751 r
.52988 .49904 .53852 .52256 .55458 .51801 .54593 .49411 Mtetra
.625 .549 .749 r
.54593 .49411 .55458 .51801 .57073 .51339 .56207 .48915 Mtetra
.625 .547 .747 r
.56207 .48915 .57073 .51339 .58698 .50869 .5783 .48415 Mtetra
.624 .546 .746 r
.5783 .48415 .58698 .50869 .60333 .50394 .59463 .47911 Mtetra
.624 .544 .744 r
.59463 .47911 .60333 .50394 .61978 .49912 .61106 .47403 Mtetra
.624 .543 .743 r
.61106 .47403 .61978 .49912 .63632 .49425 .62758 .46892 Mtetra
.623 .542 .742 r
.62758 .46892 .63632 .49425 .65296 .48933 .64421 .46378 Mtetra
.623 .541 .741 r
.64421 .46378 .65296 .48933 .66971 .48437 .66093 .45859 Mtetra
.623 .54 .74 r
.66093 .45859 .66971 .48437 .68655 .47935 .67775 .45338 Mtetra
.623 .539 .739 r
.67775 .45338 .68655 .47935 .7035 .47429 .69467 .44813 Mtetra
.622 .538 .738 r
.69467 .44813 .7035 .47429 .72055 .46919 .7117 .44284 Mtetra
.7117 .44284 .72055 .46919 .7377 .46404 .72883 .43752 Mtetra
.622 .537 .737 r
.72883 .43752 .7377 .46404 .75496 .45885 .74606 .43217 Mtetra
.622 .536 .737 r
.74606 .43217 .75496 .45885 .77232 .45363 .76339 .42678 Mtetra
.622 .536 .736 r
.76339 .42678 .77232 .45363 .78978 .44836 .78083 .42136 Mtetra
.622 .535 .736 r
.78083 .42136 .78978 .44836 .80736 .44305 .79838 .4159 Mtetra
.622 .535 .735 r
.79838 .4159 .80736 .44305 .82504 .4377 .81604 .41041 Mtetra
.81604 .41041 .82504 .4377 .84283 .43232 .8338 .40488 Mtetra
.621 .534 .735 r
.8338 .40488 .84283 .43232 .86073 .42689 .85167 .39931 Mtetra
.621 .534 .734 r
.85167 .39931 .86073 .42689 .87874 .42143 .86965 .39372 Mtetra
0 0 0 r
.23383 .56106 .24433 .55888 .25827 .55875 .24806 .55816 Mtetra
.448 .869 .941 r
.24806 .55816 .25827 .55875 .27209 .56176 .26247 .55423 Mtetra
.643 .772 .942 r
.26247 .55423 .27209 .56176 .2862 .56259 .27699 .54994 Mtetra
.647 .667 .855 r
.27699 .54994 .2862 .56259 .30055 .56159 .29161 .54547 Mtetra
.64 .617 .811 r
.29161 .54547 .30055 .56159 .3151 .55939 .30631 .54091 Mtetra
.635 .59 .786 r
.30631 .54091 .3151 .55939 .32978 .55643 .3211 .53629 Mtetra
.632 .574 .771 r
.3211 .53629 .32978 .55643 .34459 .55297 .33597 .53162 Mtetra
.629 .563 .762 r
.33597 .53162 .34459 .55297 .35951 .54918 .35093 .5269 Mtetra
.627 .556 .755 r
.35093 .5269 .35951 .54918 .37453 .54514 .36597 .52215 Mtetra
.626 .551 .75 r
.36597 .52215 .37453 .54514 .38965 .54093 .3811 .51737 Mtetra
.625 .547 .746 r
.3811 .51737 .38965 .54093 .40486 .53658 .39631 .51256 Mtetra
.624 .544 .744 r
.39631 .51256 .40486 .53658 .42017 .53213 .41162 .50771 Mtetra
.624 .542 .741 r
.41162 .50771 .42017 .53213 .43557 .52758 .42701 .50284 Mtetra
.623 .54 .74 r
.42701 .50284 .43557 .52758 .45105 .52297 .44248 .49793 Mtetra
.623 .538 .738 r
.44248 .49793 .45105 .52297 .46664 .51828 .45805 .493 Mtetra
.622 .537 .737 r
.45805 .493 .46664 .51828 .48231 .51355 .47371 .48803 Mtetra
.622 .536 .736 r
.47371 .48803 .48231 .51355 .49807 .50875 .48945 .48304 Mtetra
.622 .535 .735 r
.48945 .48304 .49807 .50875 .51393 .50392 .50529 .47801 Mtetra
.622 .534 .735 r
.50529 .47801 .51393 .50392 .52988 .49904 .52122 .47296 Mtetra
.621 .534 .734 r
.52122 .47296 .52988 .49904 .54593 .49411 .53725 .46788 Mtetra
.621 .533 .734 r
.53725 .46788 .54593 .49411 .56207 .48915 .55336 .46276 Mtetra
.621 .533 .733 r
.55336 .46276 .56207 .48915 .5783 .48415 .56958 .45762 Mtetra
.621 .532 .733 r
.56958 .45762 .5783 .48415 .59463 .47911 .58588 .45244 Mtetra
.621 .532 .732 r
.58588 .45244 .59463 .47911 .61106 .47403 .60229 .44724 Mtetra
.60229 .44724 .61106 .47403 .62758 .46892 .61879 .442 Mtetra
.621 .531 .732 r
.61879 .442 .62758 .46892 .64421 .46378 .63539 .43673 Mtetra
.63539 .43673 .64421 .46378 .66093 .45859 .65208 .43144 Mtetra
.621 .531 .731 r
.65208 .43144 .66093 .45859 .67775 .45338 .66888 .4261 Mtetra
.66888 .4261 .67775 .45338 .69467 .44813 .68578 .42074 Mtetra
.62 .53 .731 r
.68578 .42074 .69467 .44813 .7117 .44284 .70278 .41535 Mtetra
.70278 .41535 .7117 .44284 .72883 .43752 .71988 .40992 Mtetra
.71988 .40992 .72883 .43752 .74606 .43217 .73708 .40446 Mtetra
.62 .53 .73 r
.73708 .40446 .74606 .43217 .76339 .42678 .75439 .39896 Mtetra
.75439 .39896 .76339 .42678 .78083 .42136 .77181 .39344 Mtetra
.77181 .39344 .78083 .42136 .79838 .4159 .78933 .38788 Mtetra
.78933 .38788 .79838 .4159 .81604 .41041 .80696 .38228 Mtetra
.62 .529 .73 r
.80696 .38228 .81604 .41041 .8338 .40488 .82469 .37665 Mtetra
.82469 .37665 .8338 .40488 .85167 .39931 .84254 .37099 Mtetra
.84254 .37099 .85167 .39931 .86965 .39372 .86049 .36529 Mtetra
.658 .593 .771 r
.22505 .54196 .23383 .56106 .24806 .55816 .23957 .53565 Mtetra
.635 .556 .748 r
.23957 .53565 .24806 .55816 .26247 .55423 .25407 .53033 Mtetra
.628 .543 .739 r
.25407 .53033 .26247 .55423 .27699 .54994 .26863 .52532 Mtetra
.624 .537 .736 r
.26863 .52532 .27699 .54994 .29161 .54547 .28325 .52043 Mtetra
.623 .534 .733 r
.28325 .52043 .29161 .54547 .30631 .54091 .29794 .51558 Mtetra
.622 .532 .732 r
.29794 .51558 .30631 .54091 .3211 .53629 .31272 .51074 Mtetra
.621 .531 .731 r
.31272 .51074 .3211 .53629 .33597 .53162 .32758 .50589 Mtetra
.621 .53 .731 r
.32758 .50589 .33597 .53162 .35093 .5269 .34252 .50103 Mtetra
.621 .53 .73 r
.34252 .50103 .35093 .5269 .36597 .52215 .35754 .49616 Mtetra
.62 .529 .73 r
.35754 .49616 .36597 .52215 .3811 .51737 .37265 .49126 Mtetra
.37265 .49126 .3811 .51737 .39631 .51256 .38784 .48634 Mtetra
.62 .529 .729 r
.38784 .48634 .39631 .51256 .41162 .50771 .40312 .48139 Mtetra
.40312 .48139 .41162 .50771 .42701 .50284 .41849 .47642 Mtetra
.41849 .47642 .42701 .50284 .44248 .49793 .43394 .47142 Mtetra
.62 .528 .729 r
.43394 .47142 .44248 .49793 .45805 .493 .44949 .4664 Mtetra
.44949 .4664 .45805 .493 .47371 .48803 .46512 .46135 Mtetra
.46512 .46135 .47371 .48803 .48945 .48304 .48084 .45626 Mtetra
.48084 .45626 .48945 .48304 .50529 .47801 .49666 .45115 Mtetra
.49666 .45115 .50529 .47801 .52122 .47296 .51256 .44601 Mtetra
.51256 .44601 .52122 .47296 .53725 .46788 .52856 .44085 Mtetra
.52856 .44085 .53725 .46788 .55336 .46276 .54465 .43565 Mtetra
.54465 .43565 .55336 .46276 .56958 .45762 .56084 .43042 Mtetra
.56084 .43042 .56958 .45762 .58588 .45244 .57712 .42516 Mtetra
.57712 .42516 .58588 .45244 .60229 .44724 .5935 .41987 Mtetra
.5935 .41987 .60229 .44724 .61879 .442 .60998 .41455 Mtetra
.60998 .41455 .61879 .442 .63539 .43673 .62655 .4092 Mtetra
.62655 .4092 .63539 .43673 .65208 .43144 .64322 .40381 Mtetra
.64322 .40381 .65208 .43144 .66888 .4261 .65999 .3984 Mtetra
.65999 .3984 .66888 .4261 .68578 .42074 .67686 .39295 Mtetra
.67686 .39295 .68578 .42074 .70278 .41535 .69383 .38747 Mtetra
.69383 .38747 .70278 .41535 .71988 .40992 .71091 .38195 Mtetra
.71091 .38195 .71988 .40992 .73708 .40446 .72809 .37641 Mtetra
.62 .528 .728 r
.72809 .37641 .73708 .40446 .75439 .39896 .74537 .37083 Mtetra
.74537 .37083 .75439 .39896 .77181 .39344 .76276 .36521 Mtetra
.76276 .36521 .77181 .39344 .78933 .38788 .78025 .35956 Mtetra
.78025 .35956 .78933 .38788 .80696 .38228 .79785 .35388 Mtetra
.79785 .35388 .80696 .38228 .82469 .37665 .81556 .34816 Mtetra
.81556 .34816 .82469 .37665 .84254 .37099 .83337 .34241 Mtetra
.83337 .34241 .84254 .37099 .86049 .36529 .8513 .33662 Mtetra
.671 .973 .898 r
.21427 .54401 .22505 .54196 .23957 .53565 .22914 .53489 Mtetra
.826 .943 .901 r
.22914 .53489 .23957 .53565 .25407 .53033 .2443 .52259 Mtetra
.769 .788 .869 r
.2443 .52259 .25407 .53033 .26863 .52532 .25931 .51247 Mtetra
.713 .688 .825 r
.25931 .51247 .26863 .52532 .28325 .52043 .27422 .50414 Mtetra
.68 .634 .796 r
.27422 .50414 .28325 .52043 .29794 .51558 .2891 .49696 Mtetra
.661 .602 .778 r
.2891 .49696 .29794 .51558 .31272 .51074 .30399 .49048 Mtetra
.649 .583 .767 r
.30399 .49048 .31272 .51074 .32758 .50589 .31892 .48443 Mtetra
.642 .57 .759 r
.31892 .48443 .32758 .50589 .34252 .50103 .3339 .47867 Mtetra
.637 .561 .753 r
.3339 .47867 .34252 .50103 .35754 .49616 .34895 .47309 Mtetra
.633 .555 .748 r
.34895 .47309 .35754 .49616 .37265 .49126 .36407 .46764 Mtetra
.63 .55 .745 r
.36407 .46764 .37265 .49126 .38784 .48634 .37927 .46226 Mtetra
.629 .546 .743 r
.37927 .46226 .38784 .48634 .40312 .48139 .39455 .45693 Mtetra
.627 .544 .741 r
.39455 .45693 .40312 .48139 .41849 .47642 .40991 .45163 Mtetra
.626 .541 .739 r
.40991 .45163 .41849 .47642 .43394 .47142 .42536 .44635 Mtetra
.625 .54 .738 r
.42536 .44635 .43394 .47142 .44949 .4664 .44089 .44107 Mtetra
.624 .538 .737 r
.44089 .44107 .44949 .4664 .46512 .46135 .45651 .4358 Mtetra
.624 .537 .736 r
.45651 .4358 .46512 .46135 .48084 .45626 .47221 .43052 Mtetra
.623 .536 .735 r
.47221 .43052 .48084 .45626 .49666 .45115 .48801 .42522 Mtetra
.623 .535 .734 r
.48801 .42522 .49666 .45115 .51256 .44601 .5039 .41991 Mtetra
.622 .534 .734 r
.5039 .41991 .51256 .44601 .52856 .44085 .51987 .41459 Mtetra
.622 .534 .733 r
.51987 .41459 .52856 .44085 .54465 .43565 .53595 .40924 Mtetra
.622 .533 .733 r
.53595 .40924 .54465 .43565 .56084 .43042 .55211 .40387 Mtetra
.55211 .40387 .56084 .43042 .57712 .42516 .56837 .39848 Mtetra
.622 .532 .732 r
.56837 .39848 .57712 .42516 .5935 .41987 .58472 .39306 Mtetra
.621 .532 .732 r
.58472 .39306 .5935 .41987 .60998 .41455 .60118 .38761 Mtetra
.60118 .38761 .60998 .41455 .62655 .4092 .61772 .38214 Mtetra
.621 .531 .731 r
.61772 .38214 .62655 .4092 .64322 .40381 .63437 .37664 Mtetra
.63437 .37664 .64322 .40381 .65999 .3984 .65112 .37111 Mtetra
.65112 .37111 .65999 .3984 .67686 .39295 .66796 .36555 Mtetra
.66796 .36555 .67686 .39295 .69383 .38747 .68491 .35996 Mtetra
.621 .53 .731 r
.68491 .35996 .69383 .38747 .71091 .38195 .70196 .35434 Mtetra
.70196 .35434 .71091 .38195 .72809 .37641 .71911 .34869 Mtetra
.621 .53 .73 r
.71911 .34869 .72809 .37641 .74537 .37083 .73637 .343 Mtetra
.73637 .343 .74537 .37083 .76276 .36521 .75373 .33728 Mtetra
.62 .53 .73 r
.75373 .33728 .76276 .36521 .78025 .35956 .77119 .33153 Mtetra
.77119 .33153 .78025 .35956 .79785 .35388 .78877 .32575 Mtetra
.78877 .32575 .79785 .35388 .81556 .34816 .80645 .31993 Mtetra
.62 .529 .73 r
.80645 .31993 .81556 .34816 .83337 .34241 .82424 .31407 Mtetra
.82424 .31407 .83337 .34241 .8513 .33662 .84214 .30818 Mtetra
.343 .423 .8 r
.20535 .52483 .21427 .54401 .22914 .53489 .21879 .53142 Mtetra
.456 .821 .994 r
.21879 .53142 .22914 .53489 .2443 .52259 .23318 .52915 Mtetra
.565 .912 .702 r
.23318 .52915 .2443 .52259 .25931 .51247 .24844 .51754 Mtetra
.708 .981 .795 r
.24844 .51754 .25931 .51247 .27422 .50414 .26381 .5047 Mtetra
.796 .976 .907 r
.26381 .5047 .27422 .50414 .2891 .49696 .27912 .49299 Mtetra
.787 .884 .916 r
.27912 .49299 .2891 .49696 .30399 .49048 .29435 .48268 Mtetra
.752 .794 .887 r
.29435 .48268 .30399 .49048 .31892 .48443 .30954 .47355 Mtetra
.721 .728 .856 r
.30954 .47355 .31892 .48443 .3339 .47867 .32472 .46532 Mtetra
.698 .682 .831 r
.32472 .46532 .3339 .47867 .34895 .47309 .33991 .45775 Mtetra
.681 .65 .813 r
.33991 .45775 .34895 .47309 .36407 .46764 .35514 .45069 Mtetra
.668 .627 .798 r
.35514 .45069 .36407 .46764 .37927 .46226 .37042 .44399 Mtetra
.659 .609 .787 r
.37042 .44399 .37927 .46226 .39455 .45693 .38575 .43757 Mtetra
.652 .596 .779 r
.38575 .43757 .39455 .45693 .40991 .45163 .40116 .43135 Mtetra
.647 .586 .772 r
.40116 .43135 .40991 .45163 .42536 .44635 .41663 .42529 Mtetra
.643 .578 .766 r
.41663 .42529 .42536 .44635 .44089 .44107 .43218 .41935 Mtetra
.64 .571 .762 r
.43218 .41935 .44089 .44107 .45651 .4358 .44781 .41349 Mtetra
.637 .566 .758 r
.44781 .41349 .45651 .4358 .47221 .43052 .46352 .4077 Mtetra
.635 .562 .755 r
.46352 .4077 .47221 .43052 .48801 .42522 .47932 .40195 Mtetra
.633 .558 .752 r
.47932 .40195 .48801 .42522 .5039 .41991 .4952 .39624 Mtetra
.632 .555 .75 r
.4952 .39624 .5039 .41991 .51987 .41459 .51117 .39055 Mtetra
.63 .552 .748 r
.51117 .39055 .51987 .41459 .53595 .40924 .52723 .38488 Mtetra
.629 .55 .746 r
.52723 .38488 .53595 .40924 .55211 .40387 .54339 .37921 Mtetra
.628 .548 .745 r
.54339 .37921 .55211 .40387 .56837 .39848 .55963 .37354 Mtetra
.627 .546 .743 r
.55963 .37354 .56837 .39848 .58472 .39306 .57597 .36787 Mtetra
.627 .545 .742 r
.57597 .36787 .58472 .39306 .60118 .38761 .5924 .36218 Mtetra
.626 .543 .741 r
.5924 .36218 .60118 .38761 .61772 .38214 .60893 .35649 Mtetra
.626 .542 .74 r
.60893 .35649 .61772 .38214 .63437 .37664 .62556 .35078 Mtetra
.625 .541 .74 r
.62556 .35078 .63437 .37664 .65112 .37111 .64229 .34506 Mtetra
.625 .54 .739 r
.64229 .34506 .65112 .37111 .66796 .36555 .65911 .33931 Mtetra
.624 .539 .738 r
.65911 .33931 .66796 .36555 .68491 .35996 .67604 .33354 Mtetra
.624 .539 .737 r
.67604 .33354 .68491 .35996 .70196 .35434 .69306 .32775 Mtetra
.624 .538 .737 r
.69306 .32775 .70196 .35434 .71911 .34869 .71019 .32193 Mtetra
.623 .537 .736 r
.71019 .32193 .71911 .34869 .73637 .343 .72742 .31609 Mtetra
.72742 .31609 .73637 .343 .75373 .33728 .74476 .31022 Mtetra
.623 .536 .736 r
.74476 .31022 .75373 .33728 .77119 .33153 .7622 .30432 Mtetra
.623 .536 .735 r
.7622 .30432 .77119 .33153 .78877 .32575 .77975 .29839 Mtetra
.623 .535 .735 r
.77975 .29839 .78877 .32575 .80645 .31993 .7974 .29243 Mtetra
.622 .535 .734 r
.7974 .29243 .80645 .31993 .82424 .31407 .81516 .28644 Mtetra
.622 .534 .734 r
.81516 .28644 .82424 .31407 .84214 .30818 .83304 .28042 Mtetra
.893 .951 .836 r
.19433 .52648 .20535 .52483 .21879 .53142 .21011 .50887 Mtetra
.314 .369 .76 r
.21011 .50887 .21879 .53142 .23318 .52915 .22349 .5175 Mtetra
.385 .58 .918 r
.22349 .5175 .23318 .52915 .24844 .51754 .23758 .52012 Mtetra
.556 .934 .856 r
.23758 .52012 .24844 .51754 .26381 .5047 .25268 .51214 Mtetra
.541 .89 .656 r
.25268 .51214 .26381 .5047 .27912 .49299 .26817 .4998 Mtetra
.617 .933 .703 r
.26817 .4998 .27912 .49299 .29435 .48268 .28374 .4867 Mtetra
.719 .987 .824 r
.28374 .4867 .29435 .48268 .30954 .47355 .29927 .47422 Mtetra
.778 .981 .907 r
.29927 .47422 .30954 .47355 .32472 .46532 .31476 .46274 Mtetra
.786 .925 .928 r
.31476 .46274 .32472 .46532 .33991 .45775 .33021 .45226 Mtetra
.768 .856 .916 r
.33021 .45226 .33991 .45775 .35514 .45069 .34566 .44264 Mtetra
.745 .795 .893 r
.34566 .44264 .35514 .45069 .37042 .44399 .36111 .43375 Mtetra
.724 .747 .87 r
.36111 .43375 .37042 .44399 .38575 .43757 .37658 .42543 Mtetra
.707 .71 .85 r
.37658 .42543 .38575 .43757 .40116 .43135 .39209 .41759 Mtetra
.692 .68 .834 r
.39209 .41759 .40116 .43135 .41663 .42529 .40766 .41013 Mtetra
.681 .658 .82 r
.40766 .41013 .41663 .42529 .43218 .41935 .42328 .40296 Mtetra
.672 .639 .809 r
.42328 .40296 .43218 .41935 .44781 .41349 .43896 .39604 Mtetra
.665 .625 .799 r
.43896 .39604 .44781 .41349 .46352 .4077 .45471 .38931 Mtetra
.659 .613 .791 r
.45471 .38931 .46352 .4077 .47932 .40195 .47054 .38274 Mtetra
.654 .603 .785 r
.47054 .38274 .47932 .40195 .4952 .39624 .48644 .3763 Mtetra
.65 .595 .779 r
.48644 .3763 .4952 .39624 .51117 .39055 .50243 .36996 Mtetra
.647 .588 .774 r
.50243 .36996 .51117 .39055 .52723 .38488 .5185 .36369 Mtetra
.644 .582 .77 r
.5185 .36369 .52723 .38488 .54339 .37921 .53466 .35749 Mtetra
.641 .577 .767 r
.53466 .35749 .54339 .37921 .55963 .37354 .5509 .35133 Mtetra
.639 .572 .763 r
.5509 .35133 .55963 .37354 .57597 .36787 .56724 .34522 Mtetra
.637 .568 .761 r
.56724 .34522 .57597 .36787 .5924 .36218 .58367 .33913 Mtetra
.636 .565 .758 r
.58367 .33913 .5924 .36218 .60893 .35649 .60019 .33306 Mtetra
.634 .562 .756 r
.60019 .33306 .60893 .35649 .62556 .35078 .6168 .32701 Mtetra
.633 .56 .754 r
.6168 .32701 .62556 .35078 .64229 .34506 .63352 .32096 Mtetra
.632 .557 .752 r
.63352 .32096 .64229 .34506 .65911 .33931 .65032 .31491 Mtetra
.631 .555 .751 r
.65032 .31491 .65911 .33931 .67604 .33354 .66723 .30885 Mtetra
.63 .553 .749 r
.66723 .30885 .67604 .33354 .69306 .32775 .68424 .3028 Mtetra
.63 .552 .748 r
.68424 .3028 .69306 .32775 .71019 .32193 .70135 .29673 Mtetra
.629 .55 .747 r
.70135 .29673 .71019 .32193 .72742 .31609 .71856 .29064 Mtetra
.628 .549 .746 r
.71856 .29064 .72742 .31609 .74476 .31022 .73588 .28455 Mtetra
.628 .547 .745 r
.73588 .28455 .74476 .31022 .7622 .30432 .75329 .27843 Mtetra
.627 .546 .744 r
.75329 .27843 .7622 .30432 .77975 .29839 .77082 .27229 Mtetra
.627 .545 .743 r
.77082 .27229 .77975 .29839 .7974 .29243 .78845 .26613 Mtetra
.626 .544 .742 r
.78845 .26613 .7974 .29243 .81516 .28644 .80619 .25995 Mtetra
.626 .543 .742 r
.80619 .25995 .81516 .28644 .83304 .28042 .82404 .25374 Mtetra
.466 .499 .809 r
.18524 .50747 .19433 .52648 .21011 .50887 .19906 .51023 Mtetra
.882 .956 .848 r
.19906 .51023 .21011 .50887 .22349 .5175 .21485 .49356 Mtetra
.3 .349 .746 r
.21485 .49356 .22349 .5175 .23758 .52012 .22828 .50304 Mtetra
.34 .456 .833 r
.22828 .50304 .23758 .52012 .25268 .51214 .24225 .50872 Mtetra
.562 .867 .996 r
.24225 .50872 .25268 .51214 .26817 .4998 .25717 .50458 Mtetra
.561 .926 .767 r
.25717 .50458 .26817 .4998 .28374 .4867 .27265 .49438 Mtetra
.535 .882 .64 r
.27265 .49438 .28374 .4867 .29927 .47422 .28835 .48165 Mtetra
.576 .905 .661 r
.28835 .48165 .29927 .47422 .31476 .46274 .30411 .46836 Mtetra
.651 .956 .749 r
.30411 .46836 .31476 .46274 .33021 .45226 .31985 .45543 Mtetra
.724 .989 .844 r
.31985 .45543 .33021 .45226 .34566 .44264 .33556 .44321 Mtetra
.768 .983 .907 r
.33556 .44321 .34566 .44264 .36111 .43375 .35126 .43179 Mtetra
.78 .944 .931 r
.35126 .43179 .36111 .43375 .37658 .42543 .36694 .42113 Mtetra
.773 .893 .929 r
.36694 .42113 .37658 .42543 .39209 .41759 .38263 .41116 Mtetra
.758 .841 .915 r
.38263 .41116 .39209 .41759 .40766 .41013 .39835 .40178 Mtetra
.741 .796 .896 r
.39835 .40178 .40766 .41013 .42328 .40296 .41409 .3929 Mtetra
.726 .758 .879 r
.41409 .3929 .42328 .40296 .43896 .39604 .42988 .38445 Mtetra
.712 .727 .862 r
.42988 .38445 .43896 .39604 .45471 .38931 .44572 .37636 Mtetra
.7 .701 .848 r
.44572 .37636 .45471 .38931 .47054 .38274 .46161 .36857 Mtetra
.69 .68 .835 r
.46161 .36857 .47054 .38274 .48644 .3763 .47758 .36103 Mtetra
.682 .662 .824 r
.47758 .36103 .48644 .3763 .50243 .36996 .49361 .3537 Mtetra
.674 .647 .815 r
.49361 .3537 .50243 .36996 .5185 .36369 .50972 .34655 Mtetra
.668 .635 .807 r
.50972 .34655 .5185 .36369 .53466 .35749 .5259 .33954 Mtetra
.663 .624 .8 r
.5259 .33954 .53466 .35749 .5509 .35133 .54217 .33265 Mtetra
.659 .615 .794 r
.54217 .33265 .5509 .35133 .56724 .34522 .55852 .32587 Mtetra
.655 .607 .788 r
.55852 .32587 .56724 .34522 .58367 .33913 .57495 .31917 Mtetra
.652 .6 .784 r
.57495 .31917 .58367 .33913 .60019 .33306 .59148 .31254 Mtetra
.649 .594 .779 r
.59148 .31254 .60019 .33306 .6168 .32701 .6081 .30596 Mtetra
.646 .589 .776 r
.6081 .30596 .6168 .32701 .63352 .32096 .62481 .29943 Mtetra
.644 .584 .772 r
.62481 .29943 .63352 .32096 .65032 .31491 .64161 .29293 Mtetra
.642 .58 .769 r
.64161 .29293 .65032 .31491 .66723 .30885 .65851 .28646 Mtetra
.64 .576 .767 r
.65851 .28646 .66723 .30885 .68424 .3028 .67551 .28001 Mtetra
.639 .573 .764 r
.67551 .28001 .68424 .3028 .70135 .29673 .69261 .27358 Mtetra
.638 .57 .762 r
.69261 .27358 .70135 .29673 .71856 .29064 .7098 .26715 Mtetra
.636 .567 .76 r
.7098 .26715 .71856 .29064 .73588 .28455 .7271 .26073 Mtetra
.635 .565 .758 r
.7271 .26073 .73588 .28455 .75329 .27843 .74451 .2543 Mtetra
.634 .563 .756 r
.74451 .2543 .75329 .27843 .77082 .27229 .76201 .24787 Mtetra
.633 .56 .755 r
.76201 .24787 .77082 .27229 .78845 .26613 .77962 .24143 Mtetra
.632 .559 .754 r
.77962 .24143 .78845 .26613 .80619 .25995 .79734 .23499 Mtetra
.632 .557 .752 r
.79734 .23499 .80619 .25995 .82404 .25374 .81517 .22852 Mtetra
.426 .869 .885 r
.17399 .50845 .18524 .50747 .19906 .51023 .18865 .50356 Mtetra
.824 .811 .838 r
.18865 .50356 .19906 .51023 .21485 .49356 .2043 .48917 Mtetra
.794 .871 .904 r
.2043 .48917 .21485 .49356 .22828 .50304 .21963 .47833 Mtetra
.293 .339 .739 r
.21963 .47833 .22828 .50304 .24225 .50872 .23317 .48823 Mtetra
.314 .398 .789 r
.23317 .48823 .24225 .50872 .25717 .50458 .2471 .49584 Mtetra
.499 .71 .965 r
.2471 .49584 .25717 .50458 .27265 .49438 .26191 .49497 Mtetra
.607 .947 .927 r
.26191 .49497 .27265 .49438 .28835 .48165 .27734 .48743 Mtetra
.558 .915 .723 r
.27734 .48743 .28835 .48165 .30411 .46836 .2931 .4761 Mtetra
.533 .879 .633 r
.2931 .4761 .30411 .46836 .31985 .45543 .309 .46309 Mtetra
.555 .89 .64 r
.309 .46309 .31985 .45543 .33556 .44321 .32494 .44962 Mtetra
.609 .929 .701 r
.32494 .44962 .33556 .44321 .35126 .43179 .34088 .43637 Mtetra
.672 .969 .782 r
.34088 .43637 .35126 .43179 .36694 .42113 .35681 .42363 Mtetra
.727 .99 .857 r
.35681 .42363 .36694 .42113 .38263 .41116 .37273 .41153 Mtetra
.761 .984 .907 r
.37273 .41153 .38263 .41116 .39835 .40178 .38864 .40008 Mtetra
.775 .955 .93 r
.38864 .40008 .39835 .40178 .41409 .3929 .40456 .38925 Mtetra
.774 .915 .934 r
.40456 .38925 .41409 .3929 .42988 .38445 .42051 .37898 Mtetra
.765 .873 .926 r
.42051 .37898 .42988 .38445 .44572 .37636 .43648 .36921 Mtetra
.752 .832 .913 r
.43648 .36921 .44572 .37636 .46161 .36857 .45249 .35989 Mtetra
.739 .797 .898 r
.45249 .35989 .46161 .36857 .47758 .36103 .46855 .35094 Mtetra
.726 .765 .884 r
.46855 .35094 .47758 .36103 .49361 .3537 .48466 .34233 Mtetra
.715 .739 .87 r
.48466 .34233 .49361 .3537 .50972 .34655 .50084 .334 Mtetra
.705 .716 .857 r
.50084 .334 .50972 .34655 .5259 .33954 .51708 .32592 Mtetra
.696 .696 .846 r
.51708 .32592 .5259 .33954 .54217 .33265 .53339 .31805 Mtetra
.688 .679 .836 r
.53339 .31805 .54217 .33265 .55852 .32587 .54978 .31036 Mtetra
.682 .665 .827 r
.54978 .31036 .55852 .32587 .57495 .31917 .56625 .30283 Mtetra
.676 .652 .819 r
.56625 .30283 .57495 .31917 .59148 .31254 .5828 .29543 Mtetra
.671 .641 .812 r
.5828 .29543 .59148 .31254 .6081 .30596 .59943 .28815 Mtetra
.666 .632 .806 r
.59943 .28815 .6081 .30596 .62481 .29943 .61616 .28096 Mtetra
.662 .623 .8 r
.61616 .28096 .62481 .29943 .64161 .29293 .63297 .27385 Mtetra
.659 .616 .795 r
.63297 .27385 .64161 .29293 .65851 .28646 .64987 .26682 Mtetra
.656 .61 .791 r
.64987 .26682 .65851 .28646 .67551 .28001 .66687 .25984 Mtetra
.653 .604 .787 r
.66687 .25984 .67551 .28001 .69261 .27358 .68397 .25291 Mtetra
.65 .598 .783 r
.68397 .25291 .69261 .27358 .7098 .26715 .70116 .24601 Mtetra
.648 .594 .78 r
.70116 .24601 .7098 .26715 .7271 .26073 .71845 .23915 Mtetra
.646 .589 .777 r
.71845 .23915 .7271 .26073 .74451 .2543 .73584 .23231 Mtetra
.644 .586 .774 r
.73584 .23231 .74451 .2543 .76201 .24787 .75334 .22549 Mtetra
.643 .582 .771 r
.75334 .22549 .76201 .24787 .77962 .24143 .77094 .21869 Mtetra
.641 .579 .769 r
.77094 .21869 .77962 .24143 .79734 .23499 .78864 .21189 Mtetra
.64 .576 .767 r
.78864 .21189 .79734 .23499 .81517 .22852 .80645 .20509 Mtetra
.683 .617 .775 r
.16468 .48988 .17399 .50845 .18865 .50356 .17969 .48161 Mtetra
.088 .235 .721 r
.17969 .48161 .18865 .50356 .2043 .48917 .19263 .49461 Mtetra
.941 .951 .754 r
.19263 .49461 .2043 .48917 .21963 .47833 .20949 .46913 Mtetra
.684 .757 .907 r
.20949 .46913 .21963 .47833 .23317 .48823 .22448 .46302 Mtetra
.289 .334 .736 r
.22448 .46302 .23317 .48823 .2471 .49584 .23813 .47314 Mtetra
.298 .365 .764 r
.23813 .47314 .2471 .49584 .26191 .49497 .25211 .482 Mtetra
.44 .59 .905 r
.25211 .482 .26191 .49497 .27734 .48743 .26686 .48371 Mtetra
.597 .876 .993 r
.26686 .48371 .27734 .48743 .2931 .4761 .28224 .4788 Mtetra
.607 .954 .855 r
.28224 .4788 .2931 .4761 .309 .46309 .29802 .46937 Mtetra
.555 .907 .699 r
.29802 .46937 .309 .46309 .32494 .44962 .31402 .45734 Mtetra
.532 .878 .63 r
.31402 .45734 .32494 .44962 .34088 .43637 .33012 .44409 Mtetra
.545 .883 .629 r
.33012 .44409 .34088 .43637 .35681 .42363 .34626 .43046 Mtetra
.582 .91 .672 r
.34626 .43046 .35681 .42363 .37273 .41153 .3624 .41695 Mtetra
.633 .947 .736 r
.3624 .41695 .37273 .41153 .38864 .40008 .37853 .40382 Mtetra
.685 .976 .806 r
.37853 .40382 .38864 .40008 .40456 .38925 .39467 .3912 Mtetra
.728 .99 .865 r
.39467 .3912 .40456 .38925 .42051 .37898 .4108 .37913 Mtetra
.757 .984 .907 r
.4108 .37913 .42051 .37898 .43648 .36921 .42695 .3676 Mtetra
.77 .962 .929 r
.42695 .3676 .43648 .36921 .45249 .35989 .44312 .35659 Mtetra
.773 .93 .936 r
.44312 .35659 .45249 .35989 .46855 .35094 .45931 .34606 Mtetra
.768 .895 .933 r
.45931 .34606 .46855 .35094 .48466 .34233 .47554 .33596 Mtetra
.759 .86 .924 r
.47554 .33596 .48466 .34233 .50084 .334 .49182 .32624 Mtetra
.748 .827 .912 r
.49182 .32624 .50084 .334 .51708 .32592 .50815 .31687 Mtetra
.737 .797 .9 r
.50815 .31687 .51708 .32592 .53339 .31805 .52454 .3078 Mtetra
.727 .77 .887 r
.52454 .3078 .53339 .31805 .54978 .31036 .541 .29901 Mtetra
.717 .747 .875 r
.541 .29901 .54978 .31036 .56625 .30283 .55752 .29044 Mtetra
.709 .726 .864 r
.55752 .29044 .56625 .30283 .5828 .29543 .57412 .28209 Mtetra
.701 .709 .854 r
.57412 .28209 .5828 .29543 .59943 .28815 .59079 .27392 Mtetra
.694 .693 .845 r
.59079 .27392 .59943 .28815 .61616 .28096 .60755 .2659 Mtetra
.687 .679 .836 r
.60755 .2659 .61616 .28096 .63297 .27385 .62439 .25802 Mtetra
.682 .667 .829 r
.62439 .25802 .63297 .27385 .64987 .26682 .64131 .25026 Mtetra
.677 .656 .822 r
.64131 .25026 .64987 .26682 .66687 .25984 .65832 .24261 Mtetra
.672 .646 .816 r
.65832 .24261 .66687 .25984 .68397 .25291 .67543 .23504 Mtetra
.668 .638 .81 r
.67543 .23504 .68397 .25291 .70116 .24601 .69263 .22756 Mtetra
.665 .63 .805 r
.69263 .22756 .70116 .24601 .71845 .23915 .70992 .22014 Mtetra
.662 .623 .8 r
.70992 .22014 .71845 .23915 .73584 .23231 .72732 .21277 Mtetra
.659 .617 .796 r
.72732 .21277 .73584 .23231 .75334 .22549 .74481 .20546 Mtetra
.656 .611 .792 r
.74481 .20546 .75334 .22549 .77094 .21869 .7624 .19818 Mtetra
.654 .606 .789 r
.7624 .19818 .77094 .21869 .78864 .21189 .7801 .19093 Mtetra
.652 .602 .785 r
.7801 .19093 .78864 .21189 .80645 .20509 .7979 .18371 Mtetra
.509 .902 .937 r
.15323 .48991 .16468 .48988 .17969 .48161 .16801 .48463 Mtetra
.36 .829 .779 r
.16801 .48463 .17969 .48161 .19263 .49461 .18292 .4789 Mtetra
.609 .62 .837 r
.18292 .4789 .19263 .49461 .20949 .46913 .19767 .47556 Mtetra
.936 .964 .747 r
.19767 .47556 .20949 .46913 .22448 .46302 .2146 .4503 Mtetra
.594 .662 .885 r
.2146 .4503 .22448 .46302 .23813 .47314 .22939 .44754 Mtetra
.286 .331 .734 r
.22939 .44754 .23813 .47314 .25211 .482 .24318 .45779 Mtetra
.288 .346 .749 r
.24318 .45779 .25211 .482 .26686 .48371 .25724 .46746 Mtetra
.397 .511 .857 r
.25724 .46746 .26686 .48371 .28224 .4788 .27197 .4712 Mtetra
.549 .766 .978 r
.27197 .4712 .28224 .4788 .29802 .46937 .28733 .46866 Mtetra
.63 .943 .954 r
.28733 .46866 .29802 .46937 .31402 .45734 .30314 .46126 Mtetra
.599 .947 .804 r
.30314 .46126 .31402 .45734 .33012 .44409 .31921 .45064 Mtetra
.552 .902 .683 r
.31921 .45064 .33012 .44409 .34626 .43046 .33544 .43812 Mtetra
.532 .877 .628 r
.33544 .43812 .34626 .43046 .3624 .41695 .35174 .42465 Mtetra
.539 .878 .623 r
.35174 .42465 .3624 .41695 .37853 .40382 .36807 .41086 Mtetra
.566 .898 .653 r
.36807 .41086 .37853 .40382 .39467 .3912 .38442 .39712 Mtetra
.606 .928 .703 r
.38442 .39712 .39467 .3912 .4108 .37913 .40076 .38367 Mtetra
.651 .959 .763 r
.40076 .38367 .4108 .37913 .42695 .3676 .41711 .37063 Mtetra
.694 .981 .822 r
.41711 .37063 .42695 .3676 .44312 .35659 .43346 .35805 Mtetra
.729 .99 .871 r
.43346 .35805 .44312 .35659 .45931 .34606 .44983 .34594 Mtetra
.754 .984 .907 r
.44983 .34594 .45931 .34606 .47554 .33596 .46621 .33431 Mtetra
.767 .966 .928 r
.46621 .33431 .47554 .33596 .49182 .32624 .48263 .32312 Mtetra
.771 .94 .936 r
.48263 .32312 .49182 .32624 .50815 .31687 .49909 .31234 Mtetra
.769 .911 .936 r
.49909 .31234 .50815 .31687 .52454 .3078 .51558 .30193 Mtetra
.763 .88 .931 r
.51558 .30193 .52454 .3078 .541 .29901 .53213 .29188 Mtetra
.754 .85 .922 r
.53213 .29188 .541 .29901 .55752 .29044 .54874 .28213 Mtetra
.745 .822 .912 r
.54874 .28213 .55752 .29044 .57412 .28209 .56541 .27266 Mtetra
.736 .797 .901 r
.56541 .27266 .57412 .28209 .59079 .27392 .58215 .26344 Mtetra
.727 .774 .89 r
.58215 .26344 .59079 .27392 .60755 .2659 .59896 .25444 Mtetra
.719 .753 .879 r
.59896 .25444 .60755 .2659 .62439 .25802 .61584 .24564 Mtetra
.711 .735 .869 r
.61584 .24564 .62439 .25802 .64131 .25026 .6328 .23702 Mtetra
.704 .718 .86 r
.6328 .23702 .64131 .25026 .65832 .24261 .64985 .22855 Mtetra
.698 .704 .852 r
.64985 .22855 .65832 .24261 .67543 .23504 .66698 .22023 Mtetra
.692 .691 .844 r
.66698 .22023 .67543 .23504 .69263 .22756 .6842 .21202 Mtetra
.687 .679 .837 r
.6842 .21202 .69263 .22756 .70992 .22014 .70151 .20392 Mtetra
.682 .668 .83 r
.70151 .20392 .70992 .22014 .72732 .21277 .71892 .19591 Mtetra
.678 .659 .824 r
.71892 .19591 .72732 .21277 .74481 .20546 .73642 .18799 Mtetra
.674 .65 .819 r
.73642 .18799 .74481 .20546 .7624 .19818 .75401 .18014 Mtetra
.67 .642 .814 r
.75401 .18014 .7624 .19818 .7801 .19093 .77171 .17235 Mtetra
.667 .635 .809 r
.77171 .17235 .7801 .19093 .7979 .18371 .78951 .16461 Mtetra
.449 .512 .831 r
.14367 .47203 .15323 .48991 .16801 .48463 .15758 .4746 Mtetra
.831 .755 .779 r
.15758 .4746 .16801 .48463 .18292 .4789 .17393 .4558 Mtetra
0 .037 .601 r
.17393 .4558 .18292 .4789 .19767 .47556 .1864 .47442 Mtetra
.904 .894 .809 r
.1864 .47442 .19767 .47556 .2146 .4503 .20303 .45375 Mtetra
.918 .96 .795 r
.20303 .45375 .2146 .4503 .22939 .44754 .21968 .43224 Mtetra
.529 .593 .862 r
.21968 .43224 .22939 .44754 .24318 .45779 .23438 .43187 Mtetra
.284 .329 .732 r
.23438 .43187 .24318 .45779 .25724 .46746 .24831 .44218 Mtetra
.281 .334 .739 r
.24831 .44218 .25724 .46746 .27197 .4712 .26247 .4524 Mtetra
.366 .459 .823 r
.26247 .4524 .27197 .4712 .28733 .46866 .27724 .4577 Mtetra
.499 .668 .939 r
.27724 .4577 .28733 .46866 .30314 .46126 .29261 .45722 Mtetra
.613 .879 .99 r
.29261 .45722 .30314 .46126 .31921 .45064 .30844 .45181 Mtetra
.633 .961 .903 r
.30844 .45181 .31921 .45064 .33544 .43812 .32458 .44278 Mtetra
.59 .938 .768 r
.32458 .44278 .33544 .43812 .35174 .42465 .34092 .43133 Mtetra
.55 .898 .673 r
.34092 .43133 .35174 .42465 .36807 .41086 .35737 .41843 Mtetra
.532 .877 .627 r
.35737 .41843 .36807 .41086 .38442 .39712 .37387 .40475 Mtetra
.535 .876 .62 r
.37387 .40475 .38442 .39712 .40076 .38367 .39041 .39079 Mtetra
.555 .89 .641 r
.39041 .39079 .40076 .38367 .41711 .37063 .40696 .37685 Mtetra
.586 .915 .68 r
.40696 .37685 .41711 .37063 .43346 .35805 .42351 .36312 Mtetra
.624 .942 .73 r
.42351 .36312 .43346 .35805 .44983 .34594 .44007 .34972 Mtetra
.664 .967 .784 r
.44007 .34972 .44983 .34594 .46621 .33431 .45664 .33671 Mtetra
.701 .983 .834 r
.45664 .33671 .46621 .33431 .48263 .32312 .47322 .32412 Mtetra
.73 .989 .876 r
.47322 .32412 .48263 .32312 .49909 .31234 .48983 .31194 Mtetra
.751 .984 .907 r
.48983 .31194 .49909 .31234 .51558 .30193 .50647 .30018 Mtetra
.764 .969 .926 r
.50647 .30018 .51558 .30193 .53213 .29188 .52315 .2888 Mtetra
.769 .948 .936 r
.52315 .2888 .53213 .29188 .54874 .28213 .53987 .27778 Mtetra
.769 .923 .938 r
.53987 .27778 .54874 .28213 .56541 .27266 .55664 .2671 Mtetra
.765 .896 .935 r
.55664 .2671 .56541 .27266 .58215 .26344 .57346 .25672 Mtetra
.758 .869 .929 r
.57346 .25672 .58215 .26344 .59896 .25444 .59035 .24663 Mtetra
.751 .843 .921 r
.59035 .24663 .59896 .25444 .61584 .24564 .6073 .23679 Mtetra
.743 .819 .911 r
.6073 .23679 .61584 .24564 .6328 .23702 .62433 .22718 Mtetra
.735 .797 .901 r
.62433 .22718 .6328 .23702 .64985 .22855 .64143 .21779 Mtetra
.728 .777 .892 r
.64143 .21779 .64985 .22855 .66698 .22023 .6586 .20858 Mtetra
.72 .758 .883 r
.6586 .20858 .66698 .22023 .6842 .21202 .67586 .19954 Mtetra
.713 .742 .874 r
.67586 .19954 .6842 .21202 .70151 .20392 .6932 .19065 Mtetra
.707 .726 .865 r
.6932 .19065 .70151 .20392 .71892 .19591 .71064 .18189 Mtetra
.701 .713 .857 r
.71064 .18189 .71892 .19591 .73642 .18799 .72816 .17326 Mtetra
.696 .7 .85 r
.72816 .17326 .73642 .18799 .75401 .18014 .74577 .16474 Mtetra
.691 .689 .843 r
.74577 .16474 .75401 .18014 .77171 .17235 .76348 .15631 Mtetra
.686 .679 .837 r
.76348 .15631 .77171 .17235 .78951 .16461 .78129 .14796 Mtetra
.877 .908 .847 r
.13205 .47086 .14367 .47203 .15758 .4746 .14826 .45386 Mtetra
.515 .516 .795 r
.14826 .45386 .15758 .4746 .17393 .4558 .1625 .45455 Mtetra
.208 .726 .871 r
.1625 .45455 .17393 .4558 .1864 .47442 .17707 .45335 Mtetra
.346 .416 .791 r
.17707 .45335 .1864 .47442 .20303 .45375 .191 .45966 Mtetra
.949 .946 .739 r
.191 .45966 .20303 .45375 .21968 .43224 .20843 .43195 Mtetra
.883 .935 .847 r
.20843 .43195 .21968 .43224 .23438 .43187 .22477 .41461 Mtetra
.483 .543 .842 r
.22477 .41461 .23438 .43187 .24831 .44218 .23945 .41597 Mtetra
.283 .327 .732 r
.23945 .41597 .24831 .44218 .26247 .4524 .25352 .42631 Mtetra
.276 .325 .733 r
.25352 .42631 .26247 .4524 .27724 .4577 .26781 .4369 Mtetra
.345 .423 .799 r
.26781 .4369 .27724 .4577 .29261 .45722 .28264 .44341 Mtetra
.456 .593 .9 r
.28264 .44341 .29261 .45722 .30844 .45181 .29804 .44469 Mtetra
.576 .795 .982 r
.29804 .44469 .30844 .45181 .32458 .44278 .31391 .44113 Mtetra
.64 .936 .966 r
.31391 .44113 .32458 .44278 .34092 .43133 .33012 .43373 Mtetra
.626 .961 .858 r
.33012 .43373 .34092 .43133 .35737 .41843 .34656 .42355 Mtetra
.583 .93 .743 r
.34656 .42355 .35737 .41843 .37387 .40475 .36315 .41148 Mtetra
.549 .896 .665 r
.36315 .41148 .37387 .40475 .39041 .39079 .37982 .39825 Mtetra
.532 .877 .626 r
.37982 .39825 .39041 .39079 .40696 .37685 .39654 .38437 Mtetra
.533 .874 .618 r
.39654 .38437 .40696 .37685 .42351 .36312 .41328 .37024 Mtetra
.547 .885 .633 r
.41328 .37024 .42351 .36312 .44007 .34972 .43004 .3561 Mtetra
.572 .904 .664 r
.43004 .3561 .44007 .34972 .45664 .33671 .4468 .34211 Mtetra
.604 .928 .705 r
.4468 .34211 .45664 .33671 .47322 .32412 .46358 .3284 Mtetra
.639 .952 .753 r
.46358 .3284 .47322 .32412 .48983 .31194 .48037 .31502 Mtetra
.674 .972 .8 r
.48037 .31502 .48983 .31194 .50647 .30018 .49717 .302 Mtetra
.705 .985 .844 r
.49717 .302 .50647 .30018 .52315 .2888 .514 .28936 Mtetra
.731 .989 .879 r
.514 .28936 .52315 .2888 .53987 .27778 .53086 .27709 Mtetra
.749 .984 .907 r
.53086 .27709 .53987 .27778 .55664 .2671 .54776 .26517 Mtetra
.761 .971 .925 r
.54776 .26517 .55664 .2671 .57346 .25672 .5647 .2536 Mtetra
.767 .953 .935 r
.5647 .2536 .57346 .25672 .59035 .24663 .5817 .24235 Mtetra
.768 .932 .939 r
.5817 .24235 .59035 .24663 .6073 .23679 .59874 .2314 Mtetra
.766 .908 .938 r
.59874 .2314 .6073 .23679 .62433 .22718 .61585 .22073 Mtetra
.761 .884 .933 r
.61585 .22073 .62433 .22718 .64143 .21779 .63302 .21031 Mtetra
.755 .861 .927 r
.63302 .21031 .64143 .21779 .6586 .20858 .65027 .20013 Mtetra
.749 .838 .919 r
.65027 .20013 .6586 .20858 .67586 .19954 .66758 .19016 Mtetra
.742 .817 .911 r
.66758 .19016 .67586 .19954 .6932 .19065 .68498 .18039 Mtetra
.735 .797 .902 r
.68498 .18039 .6932 .19065 .71064 .18189 .70245 .17079 Mtetra
.728 .779 .893 r
.70245 .17079 .71064 .18189 .72816 .17326 .72001 .16136 Mtetra
.721 .762 .885 r
.72001 .16136 .72816 .17326 .74577 .16474 .73766 .15207 Mtetra
.715 .747 .877 r
.73766 .15207 .74577 .16474 .76348 .15631 .7554 .14291 Mtetra
.709 .733 .869 r
.7554 .14291 .76348 .15631 .78129 .14796 .77323 .13387 Mtetra
.371 .487 .847 r
.12218 .4539 .13205 .47086 .14826 .45386 .13595 .45798 Mtetra
.215 0 0 r
.13595 .45798 .14826 .45386 .1625 .45455 .15035 .45795 Mtetra
.947 .909 .748 r
.15035 .45795 .1625 .45455 .17707 .45335 .16799 .4296 Mtetra
0 0 .517 r
.16799 .4296 .17707 .45335 .191 .45966 .18025 .45122 Mtetra
.785 .795 .86 r
.18025 .45122 .191 .45966 .20843 .43195 .19622 .43928 Mtetra
.947 .956 .723 r
.19622 .43928 .20843 .43195 .22477 .41461 .2138 .41081 Mtetra
.832 .89 .883 r
.2138 .41081 .22477 .41461 .23945 .41597 .2299 .39719 Mtetra
.449 .506 .826 r
.2299 .39719 .23945 .41597 .25352 .42631 .2446 .39983 Mtetra
.282 .326 .731 r
.2446 .39983 .25352 .42631 .26781 .4369 .25882 .41018 Mtetra
.272 .32 .729 r
.25882 .41018 .26781 .4369 .28264 .44341 .27325 .42102 Mtetra
.328 .398 .782 r
.27325 .42102 .28264 .44341 .29804 .44469 .28817 .42848 Mtetra
.422 .536 .867 r
.28817 .42848 .29804 .44469 .31391 .44113 .30363 .43123 Mtetra
.535 .716 .956 r
.30363 .43123 .31391 .44113 .33012 .43373 .31955 .42936 Mtetra
.623 .88 .989 r
.31955 .42936 .33012 .43373 .34656 .42355 .33584 .42356 Mtetra
.646 .959 .929 r
.33584 .42356 .34656 .42355 .36315 .41148 .35238 .41472 Mtetra
.618 .956 .822 r
.35238 .41472 .36315 .41148 .37982 .39825 .3691 .40366 Mtetra
.578 .923 .725 r
.3691 .40366 .37982 .39825 .39654 .38437 .38593 .3911 Mtetra
.548 .893 .66 r
.38593 .3911 .39654 .38437 .41328 .37024 .40282 .37757 Mtetra
.533 .877 .626 r
.40282 .37757 .41328 .37024 .43004 .3561 .41976 .3635 Mtetra
.532 .873 .617 r
.41976 .3635 .43004 .3561 .4468 .34211 .43671 .34919 Mtetra
.542 .881 .627 r
.43671 .34919 .4468 .34211 .46358 .3284 .45368 .33485 Mtetra
.562 .897 .652 r
.45368 .33485 .46358 .3284 .48037 .31502 .47066 .32063 Mtetra
.589 .917 .686 r
.47066 .32063 .48037 .31502 .49717 .302 .48766 .30664 Mtetra
.619 .94 .727 r
.48766 .30664 .49717 .302 .514 .28936 .50466 .29292 Mtetra
.651 .96 .771 r
.50466 .29292 .514 .28936 .53086 .27709 .52169 .27953 Mtetra
.682 .976 .813 r
.52169 .27953 .53086 .27709 .54776 .26517 .53875 .26646 Mtetra
.709 .986 .851 r
.53875 .26646 .54776 .26517 .5647 .2536 .55583 .25373 Mtetra
.731 .988 .882 r
.55583 .25373 .5647 .2536 .5817 .24235 .57296 .24134 Mtetra
.748 .984 .907 r
.57296 .24134 .5817 .24235 .59874 .2314 .59012 .22926 Mtetra
.759 .973 .923 r
.59012 .22926 .59874 .2314 .61585 .22073 .60734 .21749 Mtetra
.765 .957 .934 r
.60734 .21749 .61585 .22073 .63302 .21031 .62461 .20601 Mtetra
.767 .939 .939 r
.62461 .20601 .63302 .21031 .65027 .20013 .64194 .1948 Mtetra
.766 .918 .939 r
.64194 .1948 .65027 .20013 .66758 .19016 .65934 .18384 Mtetra
.763 .896 .936 r
.65934 .18384 .66758 .19016 .68498 .18039 .67681 .17311 Mtetra
.758 .875 .932 r
.67681 .17311 .68498 .18039 .70245 .17079 .69435 .1626 Mtetra
.753 .854 .925 r
.69435 .1626 .70245 .17079 .72001 .16136 .71196 .15229 Mtetra
.747 .834 .918 r
.71196 .15229 .72001 .16136 .73766 .15207 .72966 .14216 Mtetra
.74 .815 .91 r
.72966 .14216 .73766 .15207 .7554 .14291 .74744 .1322 Mtetra
.734 .797 .902 r
.74744 .1322 .7554 .14291 .77323 .13387 .76531 .12239 Mtetra
.666 .912 .977 r
.11043 .4513 .12218 .4539 .13595 .45798 .12556 .44457 Mtetra
.668 .683 .856 r
.12556 .44457 .13595 .45798 .15035 .45795 .14068 .43848 Mtetra
.74 .641 .75 r
.14068 .43848 .15035 .45795 .16799 .4296 .15681 .42413 Mtetra
.054 .558 .883 r
.15681 .42413 .16799 .4296 .18025 .45122 .17107 .42705 Mtetra
.101 .229 .711 r
.17107 .42705 .18025 .45122 .19622 .43928 .18441 .44035 Mtetra
.926 .919 .789 r
.18441 .44035 .19622 .43928 .2138 .41081 .20168 .41683 Mtetra
.94 .959 .744 r
.20168 .41683 .2138 .41081 .2299 .39719 .21916 .39034 Mtetra
.773 .834 .899 r
.21916 .39034 .2299 .39719 .2446 .39983 .23508 .37983 Mtetra
.423 .479 .813 r
.23508 .37983 .2446 .39983 .25882 .41018 .24983 .38344 Mtetra
.281 .325 .73 r
.24983 .38344 .25882 .41018 .27325 .42102 .26421 .39378 Mtetra
.27 .315 .726 r
.26421 .39378 .27325 .42102 .28817 .42848 .27879 .40478 Mtetra
.316 .379 .769 r
.27879 .40478 .28817 .42848 .30363 .43123 .29382 .41299 Mtetra
.396 .494 .841 r
.29382 .41299 .30363 .43123 .31955 .42936 .30935 .41699 Mtetra
.496 .649 .926 r
.30935 .41699 .31955 .42936 .33584 .42356 .32535 .41661 Mtetra
.592 .813 .984 r
.32535 .41661 .33584 .42356 .35238 .41472 .34173 .41232 Mtetra
.645 .929 .972 r
.34173 .41232 .35238 .41472 .3691 .40366 .35838 .40484 Mtetra
.643 .966 .892 r
.35838 .40484 .3691 .40366 .38593 .3911 .37522 .3949 Mtetra
.609 .949 .793 r
.37522 .3949 .38593 .3911 .40282 .37757 .3922 .38316 Mtetra
.573 .918 .711 r
.3922 .38316 .40282 .37757 .41976 .3635 .40927 .37018 Mtetra
.547 .892 .656 r
.40927 .37018 .41976 .3635 .43671 .34919 .42639 .35638 Mtetra
.533 .877 .626 r
.42639 .35638 .43671 .34919 .45368 .33485 .44355 .34211 Mtetra
.531 .873 .616 r
.44355 .34211 .45368 .33485 .47066 .32063 .46072 .32762 Mtetra
.539 .878 .623 r
.46072 .32762 .47066 .32063 .48766 .30664 .47791 .31308 Mtetra
.555 .891 .643 r
.47791 .31308 .48766 .30664 .50466 .29292 .49511 .29864 Mtetra
.577 .908 .672 r
.49511 .29864 .50466 .29292 .52169 .27953 .51232 .28438 Mtetra
.603 .928 .707 r
.51232 .28438 .52169 .27953 .53875 .26646 .52956 .27036 Mtetra
.632 .948 .746 r
.52956 .27036 .53875 .26646 .55583 .25373 .54681 .25662 Mtetra
.661 .966 .786 r
.54681 .25662 .55583 .25373 .57296 .24134 .56409 .24317 Mtetra
.688 .979 .823 r
.56409 .24317 .57296 .24134 .59012 .22926 .5814 .23003 Mtetra
.712 .987 .857 r
.5814 .23003 .59012 .22926 .60734 .21749 .59876 .21719 Mtetra
.731 .988 .885 r
.59876 .21719 .60734 .21749 .62461 .20601 .61615 .20465 Mtetra
.746 .984 .907 r
.61615 .20465 .62461 .20601 .64194 .1948 .6336 .1924 Mtetra
.757 .974 .922 r
.6336 .1924 .64194 .1948 .65934 .18384 .6511 .18043 Mtetra
.763 .961 .933 r
.6511 .18043 .65934 .18384 .67681 .17311 .66866 .16871 Mtetra
.766 .944 .938 r
.66866 .16871 .67681 .17311 .69435 .1626 .68628 .15725 Mtetra
.766 .926 .94 r
.68628 .15725 .69435 .1626 .71196 .15229 .70398 .14601 Mtetra
.764 .906 .938 r
.70398 .14601 .71196 .15229 .72966 .14216 .72174 .13498 Mtetra
.76 .887 .935 r
.72174 .13498 .72966 .14216 .74744 .1322 .73959 .12416 Mtetra
.756 .867 .93 r
.73959 .12416 .74744 .1322 .76531 .12239 .75751 .11351 Mtetra
.715 .666 .801 r
.10021 .43547 .11043 .4513 .12556 .44457 .11576 .42558 Mtetra
.682 .621 .781 r
.11576 .42558 .12556 .44457 .14068 .43848 .13118 .41705 Mtetra
0 .172 .696 r
.13118 .41705 .14068 .43848 .15681 .42413 .14405 .43083 Mtetra
.947 .95 .738 r
.14405 .43083 .15681 .42413 .17107 .42705 .16188 .40284 Mtetra
0 0 .469 r
.16188 .40284 .17107 .42705 .18441 .44035 .17406 .42608 Mtetra
.602 .652 .872 r
.17406 .42608 .18441 .44035 .20168 .41683 .18934 .42269 Mtetra
.951 .945 .734 r
.18934 .42269 .20168 .41683 .21916 .39034 .20723 .39397 Mtetra
.928 .957 .779 r
.20723 .39397 .21916 .39034 .23508 .37983 .22451 .3704 Mtetra
.715 .777 .901 r
.22451 .3704 .23508 .37983 .24983 .38344 .24032 .36242 Mtetra
.404 .458 .803 r
.24032 .36242 .24983 .38344 .26421 .39378 .25515 .36678 Mtetra
.281 .325 .73 r
.25515 .36678 .26421 .39378 .27879 .40478 .26969 .3771 Mtetra
.268 .313 .724 r
.26969 .3771 .27879 .40478 .29382 .41299 .28442 .38822 Mtetra
.306 .364 .759 r
.28442 .38822 .29382 .41299 .30935 .41699 .29958 .39701 Mtetra
.375 .461 .821 r
.29958 .39701 .30935 .41699 .32535 .41661 .31521 .40205 Mtetra
.464 .594 .897 r
.31521 .40205 .32535 .41661 .34173 .41232 .33131 .40299 Mtetra
.558 .747 .965 r
.33131 .40299 .34173 .41232 .35838 .40484 .34777 .40011 Mtetra
.629 .881 .988 r
.34777 .40011 .35838 .40484 .37522 .3949 .36454 .39396 Mtetra
.653 .954 .945 r
.36454 .39396 .37522 .3949 .3922 .38316 .38152 .38518 Mtetra
.636 .965 .86 r
.38152 .38518 .3922 .38316 .40927 .37018 .39865 .37437 Mtetra
.602 .943 .771 r
.39865 .37437 .40927 .37018 .42639 .35638 .41589 .36207 Mtetra
.57 .914 .7 r
.41589 .36207 .42639 .35638 .44355 .34211 .4332 .34871 Mtetra
.546 .89 .653 r
.4332 .34871 .44355 .34211 .46072 .32762 .45055 .33466 Mtetra
.533 .877 .626 r
.45055 .33466 .46072 .32762 .47791 .31308 .46793 .32019 Mtetra
.53 .872 .616 r
.46793 .32019 .47791 .31308 .49511 .29864 .48533 .30551 Mtetra
.536 .876 .62 r
.48533 .30551 .49511 .29864 .51232 .28438 .50274 .29078 Mtetra
.549 .886 .636 r
.50274 .29078 .51232 .28438 .52956 .27036 .52016 .27612 Mtetra
.568 .901 .66 r
.52016 .27612 .52956 .27036 .54681 .25662 .53761 .26161 Mtetra
.59 .919 .691 r
.53761 .26161 .54681 .25662 .56409 .24317 .55507 .2473 Mtetra
.616 .938 .725 r
.55507 .2473 .56409 .24317 .5814 .23003 .57255 .23323 Mtetra
.642 .955 .762 r
.57255 .23323 .5814 .23003 .59876 .21719 .59006 .21943 Mtetra
.668 .97 .798 r
.59006 .21943 .59876 .21719 .61615 .20465 .60761 .20591 Mtetra
.693 .981 .831 r
.60761 .20591 .61615 .20465 .6336 .1924 .62519 .19266 Mtetra
.714 .987 .861 r
.62519 .19266 .6336 .1924 .6511 .18043 .64282 .1797 Mtetra
.732 .988 .887 r
.64282 .1797 .6511 .18043 .66866 .16871 .6605 .167 Mtetra
.745 .984 .907 r
.6605 .167 .66866 .16871 .68628 .15725 .67823 .15456 Mtetra
.755 .975 .921 r
.67823 .15456 .68628 .15725 .70398 .14601 .69603 .14238 Mtetra
.761 .963 .932 r
.69603 .14238 .70398 .14601 .72174 .13498 .71388 .13043 Mtetra
.765 .949 .937 r
.71388 .13043 .72174 .13498 .73959 .12416 .73181 .1187 Mtetra
.765 .932 .94 r
.73181 .1187 .73959 .12416 .75751 .11351 .74981 .10719 Mtetra
.352 .767 .979 r
.08836 .43124 .10021 .43547 .11576 .42558 .10284 .43017 Mtetra
.686 .98 .838 r
.10284 .43017 .11576 .42558 .13118 .41705 .11878 .41848 Mtetra
.536 0 0 r
.11878 .41848 .13118 .41705 .14405 .43083 .13251 .42527 Mtetra
.908 .798 .728 r
.13251 .42527 .14405 .43083 .16188 .40284 .15087 .394 Mtetra
0 .41 .838 r
.15087 .394 .16188 .40284 .17406 .42608 .16491 .40005 Mtetra
0 .085 .627 r
.16491 .40005 .17406 .42608 .18934 .42269 .17786 .41816 Mtetra
.859 .868 .845 r
.17786 .41816 .18934 .42269 .20723 .39397 .19469 .40128 Mtetra
.951 .952 .717 r
.19469 .40128 .20723 .39397 .22451 .3704 .21279 .37132 Mtetra
.908 .945 .817 r
.21279 .37132 .22451 .3704 .24032 .36242 .22988 .3508 Mtetra
.663 .724 .895 r
.22988 .3508 .24032 .36242 .25515 .36678 .24562 .3449 Mtetra
.389 .442 .795 r
.24562 .3449 .25515 .36678 .26969 .3771 .26055 .34986 Mtetra
.28 .324 .73 r
.26055 .34986 .26969 .3771 .28442 .38822 .27526 .36015 Mtetra
.266 .31 .722 r
.27526 .36015 .28442 .38822 .29958 .39701 .29016 .37133 Mtetra
.298 .353 .751 r
.29016 .37133 .29958 .39701 .31521 .40205 .30545 .38058 Mtetra
.358 .435 .804 r
.30545 .38058 .31521 .40205 .33131 .40299 .3212 .38649 Mtetra
.437 .55 .873 r
.3212 .38649 .33131 .40299 .34777 .40011 .3374 .38859 Mtetra
.525 .688 .942 r
.3374 .38859 .34777 .40011 .36454 .39396 .35398 .387 Mtetra
.603 .825 .985 r
.35398 .387 .36454 .39396 .38152 .38518 .37086 .38214 Mtetra
.649 .924 .975 r
.37086 .38214 .38152 .38518 .39865 .37437 .38798 .37452 Mtetra
.652 .965 .915 r
.38798 .37452 .39865 .37437 .41589 .36207 .40527 .36469 Mtetra
.628 .961 .832 r
.40527 .36469 .41589 .36207 .4332 .34871 .42268 .35317 Mtetra
.596 .937 .753 r
.42268 .35317 .4332 .34871 .45055 .33466 .44018 .34038 Mtetra
.567 .91 .692 r
.44018 .34038 .45055 .33466 .46793 .32019 .45773 .32669 Mtetra
.546 .889 .65 r
.45773 .32669 .46793 .32019 .48533 .30551 .47531 .31239 Mtetra
.534 .877 .625 r
.47531 .31239 .48533 .30551 .50274 .29078 .49292 .29771 Mtetra
.53 .872 .616 r
.49292 .29771 .50274 .29078 .52016 .27612 .51055 .28284 Mtetra
.534 .875 .618 r
.51055 .28284 .52016 .27612 .53761 .26161 .5282 .26791 Mtetra
.545 .883 .631 r
.5282 .26791 .53761 .26161 .55507 .2473 .54585 .25304 Mtetra
.56 .896 .651 r
.54585 .25304 .55507 .2473 .57255 .23323 .56353 .23828 Mtetra
.58 .911 .678 r
.56353 .23828 .57255 .23323 .59006 .21943 .58122 .2237 Mtetra
.603 .929 .708 r
.58122 .2237 .59006 .21943 .60761 .20591 .59894 .20933 Mtetra
.627 .946 .741 r
.59894 .20933 .60761 .20591 .62519 .19266 .61669 .1952 Mtetra
.651 .961 .775 r
.61669 .1952 .62519 .19266 .64282 .1797 .63447 .18132 Mtetra
.675 .974 .808 r
.63447 .18132 .64282 .1797 .6605 .167 .65229 .16769 Mtetra
.697 .983 .838 r
.65229 .16769 .6605 .167 .67823 .15456 .67016 .15432 Mtetra
.716 .987 .865 r
.67016 .15432 .67823 .15456 .69603 .14238 .68807 .14121 Mtetra
.732 .988 .888 r
.68807 .14121 .69603 .14238 .71388 .13043 .70604 .12834 Mtetra
.744 .984 .907 r
.70604 .12834 .71388 .13043 .73181 .1187 .72407 .1157 Mtetra
.754 .976 .921 r
.72407 .1157 .73181 .1187 .74981 .10719 .74217 .1033 Mtetra
.596 .645 .869 r
.07774 .4167 .08836 .43124 .10284 .43017 .09252 .41349 Mtetra
.273 .446 .851 r
.09252 .41349 .10284 .43017 .11878 .41848 .10627 .41899 Mtetra
.886 .939 .844 r
.10627 .41899 .11878 .41848 .13251 .42527 .12315 .40089 Mtetra
.552 .512 .765 r
.12315 .40089 .13251 .42527 .15087 .394 .13801 .39943 Mtetra
.925 .966 .772 r
.13801 .39943 .15087 .394 .16491 .40005 .15559 .37543 Mtetra
0 0 .442 r
.15559 .37543 .16491 .40005 .17786 .41816 .16776 .39955 Mtetra
.387 .485 .838 r
.16776 .39955 .17786 .41816 .19469 .40128 .18245 .40336 Mtetra
.934 .929 .776 r
.18245 .40336 .19469 .40128 .21279 .37132 .20027 .37815 Mtetra
.948 .955 .724 r
.20027 .37815 .21279 .37132 .22988 .3508 .21837 .34908 Mtetra
.88 .923 .849 r
.21837 .34908 .22988 .3508 .24562 .3449 .23528 .33143 Mtetra
.617 .678 .885 r
.23528 .33143 .24562 .3449 .26055 .34986 .25101 .32722 Mtetra
.377 .429 .788 r
.25101 .32722 .26055 .34986 .27526 .36015 .26605 .33265 Mtetra
.28 .324 .73 r
.26605 .33265 .27526 .36015 .29016 .37133 .28092 .34291 Mtetra
.265 .309 .721 r
.28092 .34291 .29016 .37133 .30545 .38058 .29599 .35411 Mtetra
.292 .344 .745 r
.29599 .35411 .30545 .38058 .3212 .38649 .31143 .36373 Mtetra
.344 .415 .791 r
.31143 .36373 .3212 .38649 .3374 .38859 .32732 .37037 Mtetra
.414 .515 .852 r
.32732 .37037 .3374 .38859 .35398 .387 .34364 .37349 Mtetra
.495 .638 .918 r
.34364 .37349 .35398 .387 .37086 .38214 .36034 .37308 Mtetra
.574 .769 .971 r
.36034 .37308 .37086 .38214 .38798 .37452 .37736 .36941 Mtetra
.633 .881 .987 r
.37736 .36941 .38798 .37452 .40527 .36469 .39462 .36294 Mtetra
.657 .949 .954 r
.39462 .36294 .40527 .36469 .42268 .35317 .41207 .35412 Mtetra
.648 .968 .887 r
.41207 .35412 .42268 .35317 .44018 .34038 .42966 .34344 Mtetra
.621 .956 .809 r
.42966 .34344 .44018 .34038 .45773 .32669 .44734 .33131 Mtetra
.59 .931 .739 r
.44734 .33131 .45773 .32669 .47531 .31239 .46509 .31809 Mtetra
.564 .907 .685 r
.46509 .31809 .47531 .31239 .49292 .29771 .48289 .30409 Mtetra
.545 .889 .648 r
.48289 .30409 .49292 .29771 .51055 .28284 .50071 .28954 Mtetra
.534 .877 .625 r
.50071 .28954 .51055 .28284 .5282 .26791 .51856 .27466 Mtetra
.53 .872 .616 r
.51856 .27466 .5282 .26791 .54585 .25304 .53643 .25959 Mtetra
.533 .874 .617 r
.53643 .25959 .54585 .25304 .56353 .23828 .55431 .24447 Mtetra
.541 .88 .627 r
.55431 .24447 .56353 .23828 .58122 .2237 .5722 .22937 Mtetra
.555 .891 .644 r
.5722 .22937 .58122 .2237 .59894 .20933 .59011 .21437 Mtetra
.572 .905 .667 r
.59011 .21437 .59894 .20933 .61669 .1952 .60804 .19953 Mtetra
.592 .921 .694 r
.60804 .19953 .61669 .1952 .63447 .18132 .626 .18487 Mtetra
.613 .937 .724 r
.626 .18487 .63447 .18132 .65229 .16769 .64399 .17042 Mtetra
.636 .952 .755 r
.64399 .17042 .65229 .16769 .67016 .15432 .66201 .1562 Mtetra
.659 .965 .787 r
.66201 .1562 .67016 .15432 .68807 .14121 .68008 .14221 Mtetra
.68 .976 .816 r
.68008 .14221 .68807 .14121 .70604 .12834 .69819 .12847 Mtetra
.7 .984 .844 r
.69819 .12847 .70604 .12834 .72407 .1157 .71634 .11495 Mtetra
.717 .987 .869 r
.71634 .11495 .72407 .1157 .74217 .1033 .73456 .10167 Mtetra
.822 .838 .861 r
.06582 .41068 .07774 .4167 .09252 .41349 .08212 .39671 Mtetra
.518 .578 .855 r
.08212 .39671 .09252 .41349 .10627 .41899 .09663 .39627 Mtetra
.746 .625 .726 r
.09663 .39627 .10627 .41899 .12315 .40089 .11343 .37907 Mtetra
0 0 .369 r
.11343 .37907 .12315 .40089 .13801 .39943 .12517 .40254 Mtetra
.96 .864 .699 r
.12517 .40254 .13801 .39943 .15559 .37543 .14468 .36395 Mtetra
0 .307 .789 r
.14468 .36395 .15559 .37543 .16776 .39955 .15858 .37231 Mtetra
0 0 .557 r
.15858 .37231 .16776 .39955 .18245 .40336 .17127 .3937 Mtetra
.746 .785 .885 r
.17127 .3937 .18245 .40336 .20027 .37815 .1876 .38381 Mtetra
.951 .945 .733 r
.1876 .38381 .20027 .37815 .21837 .34908 .20595 .35442 Mtetra
.941 .957 .745 r
.20595 .35442 .21837 .34908 .23528 .33143 .22394 .32724 Mtetra
.845 .893 .873 r
.22394 .32724 .23528 .33143 .25101 .32722 .24073 .31215 Mtetra
.578 .638 .874 r
.24073 .31215 .25101 .32722 .26605 .33265 .25647 .30935 Mtetra
.367 .418 .782 r
.25647 .30935 .26605 .33265 .28092 .34291 .27164 .31516 Mtetra
.28 .324 .73 r
.27164 .31516 .28092 .34291 .29599 .35411 .28669 .32537 Mtetra
.265 .308 .72 r
.28669 .32537 .29599 .35411 .31143 .36373 .30193 .33658 Mtetra
.287 .337 .74 r
.30193 .33658 .31143 .36373 .32732 .37037 .31753 .34648 Mtetra
.333 .398 .78 r
.31753 .34648 .32732 .37037 .34364 .37349 .33356 .35374 Mtetra
.395 .486 .834 r
.33356 .35374 .34364 .37349 .36034 .37308 .35002 .35775 Mtetra
.468 .595 .896 r
.35002 .35775 .36034 .37308 .37736 .36941 .36685 .35839 Mtetra
.545 .717 .952 r
.36685 .35839 .37736 .36941 .39462 .36294 .38401 .35585 Mtetra
.611 .833 .985 r
.38401 .35585 .39462 .36294 .41207 .35412 .40142 .35047 Mtetra
.651 .919 .977 r
.40142 .35047 .41207 .35412 .42966 .34344 .41904 .34268 Mtetra
.658 .962 .93 r
.41904 .34268 .42966 .34344 .44734 .33131 .43681 .33288 Mtetra
.642 .967 .861 r
.43681 .33288 .44734 .33131 .46509 .31809 .45468 .32147 Mtetra
.614 .95 .789 r
.45468 .32147 .46509 .31809 .48289 .30409 .47264 .30881 Mtetra
.586 .927 .727 r
.47264 .30881 .48289 .30409 .50071 .28954 .49065 .2952 Mtetra
.562 .905 .679 r
.49065 .2952 .50071 .28954 .51856 .27466 .5087 .28089 Mtetra
.545 .888 .646 r
.5087 .28089 .51856 .27466 .53643 .25959 .52677 .26611 Mtetra
.534 .877 .625 r
.52677 .26611 .53643 .25959 .55431 .24447 .54486 .25101 Mtetra
.53 .872 .616 r
.54486 .25101 .55431 .24447 .5722 .22937 .56297 .23574 Mtetra
.532 .873 .616 r
.56297 .23574 .5722 .22937 .59011 .21437 .58109 .22041 Mtetra
.539 .878 .624 r
.58109 .22041 .59011 .21437 .60804 .19953 .59923 .20509 Mtetra
.55 .888 .639 r
.59923 .20509 .60804 .19953 .626 .18487 .61739 .18986 Mtetra
.565 .9 .658 r
.61739 .18986 .626 .18487 .64399 .17042 .63556 .17475 Mtetra
.583 .914 .682 r
.63556 .17475 .64399 .17042 .66201 .1562 .65377 .15982 Mtetra
.602 .929 .709 r
.65377 .15982 .66201 .1562 .68008 .14221 .672 .14506 Mtetra
.623 .943 .738 r
.672 .14506 .68008 .14221 .69819 .12847 .69027 .13052 Mtetra
.644 .957 .767 r
.69027 .13052 .69819 .12847 .71634 .11495 .70858 .11619 Mtetra
.665 .969 .796 r
.70858 .11619 .71634 .11495 .73456 .10167 .72694 .10208 Mtetra
.289 .53 .91 r
.05475 .39756 .06582 .41068 .08212 .39671 .06864 .40108 Mtetra
.927 .949 .786 r
.06864 .40108 .08212 .39671 .09663 .39627 .08645 .37722 Mtetra
.512 .547 .828 r
.08645 .37722 .09663 .39627 .11343 .37907 .10104 .3771 Mtetra
.667 .12 0 r
.10104 .3771 .11343 .37907 .12517 .40254 .11425 .38879 Mtetra
.828 .726 .752 r
.11425 .38879 .12517 .40254 .14468 .36395 .13188 .36668 Mtetra
.892 .97 .827 r
.13188 .36668 .14468 .36395 .15858 .37231 .14913 .34731 Mtetra
0 0 .429 r
.14913 .34731 .15858 .37231 .17127 .3937 .16133 .37189 Mtetra
.183 .323 .772 r
.16133 .37189 .17127 .3937 .1876 .38381 .17555 .38143 Mtetra
.892 .901 .827 r
.17555 .38143 .1876 .38381 .20595 .35442 .1931 .36144 Mtetra
.953 .95 .716 r
.1931 .36144 .20595 .35442 .22394 .32724 .21168 .33061 Mtetra
.932 .954 .772 r
.21168 .33061 .22394 .32724 .24073 .31215 .22954 .30573 Mtetra
.806 .858 .888 r
.22954 .30573 .24073 .31215 .25647 .30935 .24624 .29289 Mtetra
.546 .605 .863 r
.24624 .29289 .25647 .30935 .27164 .31516 .26202 .29126 Mtetra
.358 .409 .778 r
.26202 .29126 .27164 .31516 .28669 .32537 .27732 .29737 Mtetra
.28 .324 .729 r
.27732 .29737 .28669 .32537 .30193 .33658 .29255 .30753 Mtetra
.264 .307 .72 r
.29255 .30753 .30193 .33658 .31753 .34648 .30797 .31872 Mtetra
.283 .331 .736 r
.30797 .31872 .31753 .34648 .33356 .35374 .32375 .32885 Mtetra
.323 .385 .771 r
.32375 .32885 .33356 .35374 .35002 .35775 .33993 .33662 Mtetra
.379 .462 .82 r
.33993 .33662 .35002 .35775 .36685 .35839 .35654 .34141 Mtetra
.446 .559 .876 r
.35654 .34141 .36685 .35839 .38401 .35585 .37352 .343 Mtetra
.518 .671 .933 r
.37352 .343 .38401 .35585 .40142 .35047 .39082 .3415 Mtetra
.586 .785 .974 r
.39082 .3415 .40142 .35047 .41904 .34268 .4084 .33717 Mtetra
.636 .881 .986 r
.4084 .33717 .41904 .34268 .43681 .33288 .42619 .33037 Mtetra
.659 .944 .961 r
.42619 .33037 .43681 .33288 .45468 .32147 .44414 .32146 Mtetra
.656 .968 .906 r
.44414 .32146 .45468 .32147 .47264 .30881 .46222 .31082 Mtetra
.635 .964 .839 r
.46222 .31082 .47264 .30881 .49065 .2952 .48038 .29878 Mtetra
.608 .945 .773 r
.48038 .29878 .49065 .2952 .5087 .28089 .49861 .28564 Mtetra
.582 .923 .718 r
.49861 .28564 .5087 .28089 .52677 .26611 .51688 .27167 Mtetra
.56 .903 .675 r
.51688 .27167 .52677 .26611 .54486 .25101 .53519 .25708 Mtetra
.544 .887 .644 r
.53519 .25708 .54486 .25101 .56297 .23574 .55351 .24205 Mtetra
.534 .877 .625 r
.55351 .24205 .56297 .23574 .58109 .22041 .57185 .22674 Mtetra
.53 .872 .616 r
.57185 .22674 .58109 .22041 .59923 .20509 .59021 .21127 Mtetra
.531 .872 .615 r
.59021 .21127 .59923 .20509 .61739 .18986 .60858 .19572 Mtetra
.537 .877 .622 r
.60858 .19572 .61739 .18986 .63556 .17475 .62697 .18018 Mtetra
.546 .885 .634 r
.62697 .18018 .63556 .17475 .65377 .15982 .64538 .16471 Mtetra
.559 .895 .651 r
.64538 .16471 .65377 .15982 .672 .14506 .6638 .14935 Mtetra
.575 .908 .673 r
.6638 .14935 .672 .14506 .69027 .13052 .68226 .13414 Mtetra
.593 .922 .697 r
.68226 .13414 .69027 .13052 .70858 .11619 .70075 .11909 Mtetra
.612 .936 .723 r
.70075 .11909 .70858 .11619 .72694 .10208 .71927 .10423 Mtetra
.724 .809 .918 r
.04279 .38962 .05475 .39756 .06864 .40108 .0584 .38141 Mtetra
.527 .548 .821 r
.0584 .38141 .06864 .40108 .08645 .37722 .07302 .3807 Mtetra
.323 0 0 r
.07302 .3807 .08645 .37722 .10104 .3771 .08737 .38291 Mtetra
.893 .986 .795 r
.08737 .38291 .10104 .3771 .11425 .38879 .10495 .3619 Mtetra
.188 .269 .716 r
.10495 .3619 .11425 .38879 .13188 .36668 .11837 .37312 Mtetra
.971 .892 .69 r
.11837 .37312 .13188 .36668 .14913 .34731 .13825 .33373 Mtetra
0 .238 .749 r
.13825 .33373 .14913 .34731 .16133 .37189 .15207 .34381 Mtetra
0 0 .505 r
.15207 .34381 .16133 .37189 .17555 .38143 .16461 .36744 Mtetra
.591 .669 .893 r
.16461 .36744 .17555 .38143 .1931 .36144 .18046 .36398 Mtetra
.938 .935 .769 r
.18046 .36398 .1931 .36144 .21168 .33061 .19879 .33757 Mtetra
.951 .953 .716 r
.19879 .33757 .21168 .33061 .22954 .30573 .21743 .30697 Mtetra
.918 .947 .801 r
.21743 .30697 .22954 .30573 .24624 .29289 .23517 .28445 Mtetra
.767 .821 .895 r
.23517 .28445 .24624 .29289 .26202 .29126 .25181 .27357 Mtetra
.518 .576 .853 r
.25181 .27357 .26202 .29126 .27732 .29737 .26766 .27291 Mtetra
.351 .401 .774 r
.26766 .27291 .27732 .29737 .29255 .30753 .28311 .27928 Mtetra
.28 .324 .729 r
.28311 .27928 .29255 .30753 .30797 .31872 .29851 .28938 Mtetra
.264 .307 .719 r
.29851 .28938 .30797 .31872 .32375 .32885 .31412 .30054 Mtetra
.279 .327 .733 r
.31412 .30054 .32375 .32885 .33993 .33662 .33007 .31084 Mtetra
.315 .374 .764 r
.33007 .31084 .33993 .33662 .35654 .34141 .34643 .31905 Mtetra
.365 .442 .807 r
.34643 .31905 .35654 .34141 .37352 .343 .36319 .3245 Mtetra
.426 .529 .859 r
.36319 .3245 .37352 .343 .39082 .3415 .38033 .32695 Mtetra
.493 .631 .913 r
.38033 .32695 .39082 .3415 .4084 .33717 .3978 .3264 Mtetra
.56 .739 .96 r
.3978 .3264 .4084 .33717 .42619 .33037 .41554 .32307 Mtetra
.617 .839 .985 r
.41554 .32307 .42619 .33037 .44414 .32146 .43351 .31723 Mtetra
.652 .916 .979 r
.43351 .31723 .44414 .32146 .46222 .31082 .45166 .30921 Mtetra
.662 .958 .941 r
.45166 .30921 .46222 .31082 .48038 .29878 .46994 .29936 Mtetra
.651 .969 .883 r
.46994 .29936 .48038 .29878 .49861 .28564 .48832 .28799 Mtetra
.629 .96 .819 r
.48832 .28799 .49861 .28564 .51688 .27167 .50677 .27539 Mtetra
.603 .941 .759 r
.50677 .27539 .51688 .27167 .53519 .25708 .52527 .26182 Mtetra
.578 .92 .709 r
.52527 .26182 .53519 .25708 .55351 .24205 .54381 .2475 Mtetra
.558 .901 .671 r
.54381 .2475 .55351 .24205 .57185 .22674 .56238 .23263 Mtetra
.544 .887 .643 r
.56238 .23263 .57185 .22674 .59021 .21127 .58096 .21736 Mtetra
.534 .877 .625 r
.58096 .21736 .59021 .21127 .60858 .19572 .59956 .20183 Mtetra
.53 .872 .616 r
.59956 .20183 .60858 .19572 .62697 .18018 .61818 .18614 Mtetra
.531 .872 .615 r
.61818 .18614 .62697 .18018 .64538 .16471 .6368 .17038 Mtetra
.535 .875 .62 r
.6368 .17038 .64538 .16471 .6638 .14935 .65545 .15461 Mtetra
.543 .882 .63 r
.65545 .15461 .6638 .14935 .68226 .13414 .67411 .1389 Mtetra
.555 .892 .645 r
.67411 .1389 .68226 .13414 .70075 .11909 .6928 .12329 Mtetra
.569 .903 .664 r
.6928 .12329 .70075 .11909 .71927 .10423 .71151 .1078 Mtetra
.75 .745 .847 r
.03123 .37802 .04279 .38962 .0584 .38141 .04728 .36716 Mtetra
0 .192 .715 r
.04728 .36716 .0584 .38141 .07302 .3807 .06028 .37761 Mtetra
.572 .887 .99 r
.06028 .37761 .07302 .3807 .08737 .38291 .07571 .37248 Mtetra
.884 .754 .714 r
.07571 .37248 .08737 .38291 .10495 .3619 .09499 .33974 Mtetra
.759 .392 0 r
.09499 .33974 .10495 .3619 .11837 .37312 .10592 .36939 Mtetra
.928 .815 .713 r
.10592 .36939 .11837 .37312 .13825 .33373 .12556 .33351 Mtetra
.844 .958 .884 r
.12556 .33351 .13825 .33373 .15207 .34381 .14248 .31844 Mtetra
0 0 .423 r
.14248 .31844 .15207 .34381 .16461 .36744 .15474 .34323 Mtetra
.016 .188 .699 r
.15474 .34323 .16461 .36744 .18046 .36398 .1686 .35724 Mtetra
.82 .851 .872 r
.1686 .35724 .18046 .36398 .19879 .33757 .18579 .34294 Mtetra
.951 .945 .733 r
.18579 .34294 .19879 .33757 .21743 .30697 .2046 .31299 Mtetra
.947 .955 .728 r
.2046 .31299 .21743 .30697 .23517 .28445 .22321 .28356 Mtetra
.9 .934 .827 r
.22321 .28356 .23517 .28445 .25181 .27357 .24084 .26332 Mtetra
.728 .784 .897 r
.24084 .26332 .25181 .27357 .26766 .27291 .25746 .25414 Mtetra
.495 .552 .844 r
.25746 .25414 .26766 .27291 .28311 .27928 .27339 .2543 Mtetra
.345 .395 .77 r
.27339 .2543 .28311 .27928 .29851 .28938 .28899 .26087 Mtetra
.28 .323 .729 r
.28899 .26087 .29851 .28938 .31412 .30054 .30458 .27091 Mtetra
.264 .306 .719 r
.30458 .27091 .31412 .30054 .33007 .31084 .32038 .28203 Mtetra
.277 .323 .73 r
.32038 .28203 .33007 .31084 .34643 .31905 .33652 .29245 Mtetra
.308 .364 .757 r
.33652 .29245 .34643 .31905 .36319 .3245 .35305 .30102 Mtetra
.353 .425 .796 r
.35305 .30102 .36319 .3245 .38033 .32695 .36998 .30706 Mtetra
.409 .503 .844 r
.36998 .30706 .38033 .32695 .3978 .3264 .38729 .31027 Mtetra
.471 .596 .895 r
.38729 .31027 .3978 .3264 .41554 .32307 .40493 .3106 Mtetra
.536 .697 .943 r
.40493 .3106 .41554 .32307 .43351 .31723 .42285 .3082 Mtetra
.595 .797 .977 r
.42285 .3082 .43351 .31723 .45166 .30921 .44101 .30328 Mtetra
.639 .882 .986 r
.44101 .30328 .45166 .30921 .46994 .29936 .45936 .29615 Mtetra
.661 .939 .965 r
.45936 .29615 .46994 .29936 .48832 .28799 .47785 .28709 Mtetra
.661 .966 .92 r
.47785 .28709 .48832 .28799 .50677 .27539 .49645 .27641 Mtetra
.646 .968 .862 r
.49645 .27641 .50677 .27539 .52527 .26182 .51513 .26439 Mtetra
.623 .955 .802 r
.51513 .26439 .52527 .26182 .54381 .2475 .53387 .25128 Mtetra
.598 .936 .748 r
.53387 .25128 .54381 .2475 .56238 .23263 .55266 .23731 Mtetra
.575 .917 .702 r
.55266 .23731 .56238 .23263 .58096 .21736 .57147 .22266 Mtetra
.557 .899 .667 r
.57147 .22266 .58096 .21736 .59956 .20183 .5903 .20752 Mtetra
.543 .886 .642 r
.5903 .20752 .59956 .20183 .61818 .18614 .60915 .192 Mtetra
.535 .877 .625 r
.60915 .192 .61818 .18614 .6368 .17038 .62802 .17624 Mtetra
.53 .872 .616 r
.62802 .17624 .6368 .17038 .65545 .15461 .6469 .16033 Mtetra
.53 .872 .614 r
.6469 .16033 .65545 .15461 .67411 .1389 .66579 .14435 Mtetra
.534 .874 .618 r
.66579 .14435 .67411 .1389 .6928 .12329 .6847 .12836 Mtetra
.541 .88 .627 r
.6847 .12836 .6928 .12329 .71151 .1078 .70362 .1124 Mtetra
.242 .587 .947 r
.01926 .36808 .03123 .37802 .04728 .36716 .03332 .37063 Mtetra
.877 .977 .839 r
.03332 .37063 .04728 .36716 .06028 .37761 .05065 .35232 Mtetra
.628 .553 .751 r
.05065 .35232 .06028 .37761 .07571 .37248 .06627 .34569 Mtetra
.674 .569 .729 r
.06627 .34569 .07571 .37248 .09499 .33974 .08257 .33477 Mtetra
.724 .192 0 r
.08257 .33477 .09499 .33974 .10592 .36939 .09541 .34969 Mtetra
.687 .632 .788 r
.09541 .34969 .10592 .36939 .12556 .33351 .11174 .34021 Mtetra
.969 .908 .7 r
.11174 .34021 .12556 .33351 .14248 .31844 .13159 .30313 Mtetra
0 .189 .718 r
.13159 .30313 .14248 .31844 .15474 .34323 .14538 .31453 Mtetra
0 0 .467 r
.14538 .31453 .15474 .34323 .1686 .35724 .15783 .33967 Mtetra
.417 .532 .867 r
.15783 .33967 .1686 .35724 .18579 .34294 .17324 .3418 Mtetra
.909 .917 .812 r
.17324 .3418 .18579 .34294 .2046 .31299 .19142 .31962 Mtetra
.954 .949 .716 r
.19142 .31962 .2046 .31299 .22321 .28356 .21047 .28816 Mtetra
.942 .955 .746 r
.21047 .28816 .22321 .28356 .24084 .26332 .22902 .26038 Mtetra
.877 .917 .85 r
.22902 .26038 .24084 .26332 .25746 .25414 .24656 .24226 Mtetra
.691 .748 .895 r
.24656 .24226 .25746 .25414 .27339 .2543 .26319 .23456 Mtetra
.475 .532 .835 r
.26319 .23456 .27339 .2543 .28899 .26087 .27921 .23541 Mtetra
.34 .39 .767 r
.27921 .23541 .28899 .26087 .30458 .27091 .29498 .24214 Mtetra
.279 .323 .729 r
.29498 .24214 .30458 .27091 .32038 .28203 .31076 .25211 Mtetra
.263 .306 .719 r
.31076 .25211 .32038 .28203 .33652 .29245 .32676 .26317 Mtetra
.274 .32 .728 r
.32676 .26317 .33652 .29245 .35305 .30102 .34309 .27369 Mtetra
.303 .356 .752 r
.34309 .27369 .35305 .30102 .36998 .30706 .3598 .28256 Mtetra
.343 .411 .787 r
.3598 .28256 .36998 .30706 .38729 .31027 .37691 .28911 Mtetra
.394 .481 .831 r
.37691 .28911 .38729 .31027 .40493 .3106 .3944 .29299 Mtetra
.452 .565 .879 r
.3944 .29299 .40493 .3106 .42285 .3082 .41222 .29413 Mtetra
.513 .659 .926 r
.41222 .29413 .42285 .3082 .44101 .30328 .43034 .29259 Mtetra
.572 .756 .965 r
.43034 .29259 .44101 .30328 .45936 .29615 .44869 .28856 Mtetra
.621 .844 .985 r
.44869 .28856 .45936 .29615 .47785 .28709 .46724 .28228 Mtetra
.653 .913 .979 r
.46724 .28228 .47785 .28709 .49645 .27641 .48595 .27402 Mtetra
.664 .954 .949 r
.48595 .27402 .49645 .27641 .51513 .26439 .50478 .26405 Mtetra
.658 .969 .9 r
.50478 .26405 .51513 .26439 .53387 .25128 .5237 .25264 Mtetra
.64 .966 .843 r
.5237 .25264 .53387 .25128 .55266 .23731 .54269 .24003 Mtetra
.617 .951 .787 r
.54269 .24003 .55266 .23731 .57147 .22266 .56172 .22646 Mtetra
.594 .932 .738 r
.56172 .22646 .57147 .22266 .5903 .20752 .58079 .2121 Mtetra
.573 .914 .696 r
.58079 .2121 .5903 .20752 .60915 .192 .59988 .19714 Mtetra
.556 .898 .664 r
.59988 .19714 .60915 .192 .62802 .17624 .61899 .18171 Mtetra
.543 .886 .641 r
.61899 .18171 .62802 .17624 .6469 .16033 .63812 .16595 Mtetra
.535 .877 .625 r
.63812 .16595 .6469 .16033 .66579 .14435 .65725 .14996 Mtetra
.531 .873 .617 r
.65725 .14996 .66579 .14435 .6847 .12836 .6764 .13382 Mtetra
.53 .872 .614 r
.6764 .13382 .6847 .12836 .70362 .1124 .69556 .11761 Mtetra
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.16157 .20642 m
.16617 .2111 L
s
[(0.5)] .15237 .19707 .98294 1 Mshowa
.32604 .14202 m
.33035 .14696 L
s
[(1)] .31741 .13214 .87321 1 Mshowa
.50139 .07336 m
.50537 .07857 L
s
[(1.5)] .49342 .06293 .76347 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.19364 .19386 m
.19637 .1967 L
s
.22611 .18115 m
.22881 .18402 L
s
.259 .16827 m
.26166 .17117 L
s
.29231 .15523 m
.29493 .15816 L
s
.3602 .12864 m
.36275 .13164 L
s
.39481 .11509 m
.39732 .11812 L
s
.42987 .10136 m
.43235 .10443 L
s
.4654 .08745 m
.46783 .09055 L
s
.53786 .05908 m
.5402 .06224 L
s
.57482 .04461 m
.57712 .0478 L
s
.61228 .02994 m
.61453 .03317 L
s
.65025 .01507 m
.65245 .01833 L
s
.12989 .21883 m
.13268 .2216 L
s
.0986 .23108 m
.10142 .23383 L
s
.06769 .24318 m
.07054 .2459 L
s
.03716 .25514 m
.04004 .25782 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{Inherited, Inherited}, {Inherited, 8}},
  ImageSize->{260.5, 185.625},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000550000j1000`40O003h00OogooAWoo003JOol5
001VOol00=Yoo`05001oogooOol0001VOol00=]oo`03001oogoo06Moo`00g7oo00<007ooOol0IWoo
003MOol00`00Oomoo`1UOol00=ioo`03001oogoo06Aoo`00fWoo00D007ooOomoo`0006Ioo`00fgoo
0`00Igoo003oOom6Ool00?moodIoo`00ogooAWoo003oOom6Ool00?moodIoo`00ogooAWoo003QOol2
001ROol00=moo`800003Ool00000065oo`00g7oo0`000goo0P00HGoo003JOol20006Ool3001POol0
0=Moo`<000Qoo`04001oogoo001OOol00=Aoo`<00003Ool007oo00Qoo`04001oogoo001OOol009Yo
o`D000Aoo`8000Eoo`@002Aoo`8000ioo`05001oogooOol0001NOol009aoo`03001oogoo00Aoo`80
00Aoo`03001oogoo009oo`03001oogoo01ioo`<0011oo`03001oogoo009oo`03001oogoo00ioo`@0
04Uoo`00L7oo0P000Woo0P009Woo00<007ooOol03goo00<007ooOol077oo0P004goo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol0AWoo001aOol01000Oomoo`009goo00<0
07ooOol03goo00<007ooOol06Goo0`0000=oo`00Ool04goo00<007ooOol00Woo00<007ooOol04Goo
00<007ooOol0AWoo001bOol2000XOol00`00Oomoo`0;Ool4000JOol2000IOol00`00Oomoo`03Ool0
0`00Oomoo`03Ool60007Ool00`00Oomoo`16Ool0079oo`8002Qoo`03001oogoo00]oo`03001oogoo
01Qoo`<001]oo`03001oogoo00=oo`03001oogoo00aoo`@004Uoo`00LGoo00@007ooOol002Eoo`<0
00eoo`03001oogoo01Ioo`8001ioo`03001oogoo00Aoo`03001oogoo00]oo`03001oogoo04Yoo`00
L7oo0P000Woo0P009Woo00<007ooOol02goo1@004Goo0`0087oo00<007ooOol01Goo00<007ooOol0
2Woo00<007ooOol0BWoo002mOol3000SOol00`00Oomoo`03Ool3000<Ool50018Ool00;Uoo`04001o
o`00000VOol00`00Oomoo`06Ool00`00Oomoo`1FOol00;Qoo`<002Qoo`03001oogoo00Moo`03001o
ogoo05Eoo`00]Woo0P00:goo00<007ooOol01goo00<007ooOol0EGoo002cOol3000]Ool00`00Oomo
o`08Ool00`00Oomoo`1DOol00;1oo`<0031oo`03001oogoo00Uoo`03001oogoo05=oo`00[Woo1000
<Goo00<007ooOol02Goo00<007ooOol0Dgoo002[Ool30003Ool00`00Oomoo`0_Ool00`00Oomoo`0:
Ool00`00Oomoo`1BOol00:Uoo`8003Qoo`03001oogoo00Yoo`03001oogoo059oo`00YWoo0`00>Woo
00<007ooOol02goo00<007ooOol0DGoo001iOol5000VOol200000goo001oo`0jOol00`00Oomoo`0<
Ool00`00Oomoo`1@Ool007]oo`03001oogoo02=oo`<0041oo`03001oogoo00Yoo`80059oo`00Ngoo
00<007ooOol08Goo0P00@goo00<007ooOol037oo00<007ooOol0Cgoo001kOol00`00Oomoo`0NOol3
0015Ool00`00Oomoo`0=Ool00`00Oomoo`1>Ool007]oo`03001oogoo01aoo`800003Ool007oo04Eo
o`03001oogoo00=oo`08CkICf5OIFmYKneoLHoeOg09oo`03001oogoo04ioo`00Ngoo00<007ooOol0
6Goo0`00BWoo00<007ooOol00TND00Q?]U?HFo]Kfe_kGmaOgEoL0Unm0Woo00<007ooOol0CGoo001i
Ool3000GOol4001=Ool04000Oom;UDNDEmUGfU_kFmYOgEoLHoeOWF>mGieS_EnM0Woo00<007ooOol0
C7oo001kOol00`00Oomoo`0DOol3001?Ool01`00AiA;]U?HEmYKnUOJ009Og006HkeO_EnmGkeS_Enm
0Umm00=oo`00Ool0CGoo002?Ool3001AOol05CmB001;UE?HEmYKnUOJGoaKg6?MGkeS_EnMHkeOG5mm
GeaSOEmLOol0001=Ool008eoo`8005=oo`03@g=7U000009GfP05FoYOg5oLGmaS_@03Gkd00emmGeeO
O@02Ggd01EmMFcaK77oo0000C7oo002:Ool3001COol03d=c@e97U4ng001GfUolFmaOo5_LHmeO_F?M
GkaSW@02Ggd025mLHgeK6ellFa]O?7oo001<Ool008Qoo`800003Ool007oo059oo`93L`09BkE?]UOI
001Oo5_KFo]Kff>m009O_@03GgeOWEmm009OO@07GcaK75/lFaaO?5/LFc`00P00Bgoo0025Ool3001F
Ool2@g<06d^ECkIGfE_K001KfeolFm]SgEnlHmeOO6>MGgeSWEmlGcaK?5llFa]O?5/KGcaFfU[kOol0
001:Ool008=oo`8005Qoo`93L`07CkMGfEOIFm]Oo000Fo/015oM00AOWF>MGgeOO@9O?005FcaO?5ll
GcaK7002F]/015[kE]]Jf`00BWoo0020Ool3001HOol014=b@g=3LdoG0U?H01]GfU_kFmX005nlHmeO
_6>MGgeSWEnMHieK?5llFcaO?5/lGcaK?5[kE]YJneKJF_]FfWoo0000BGoo001mOol30002Ool00`00
Oomoo`1EOol014=b@g=;]T^f0U?H00IKfe_kFmYOg000Gmd3Gid01V>MGieOG5mLGeeK?0=O?0AJn`07
E]]Jfe[KF_]Ffgoo0000B7oo001kOol2001LOol05d=cAg=;UE?IDmQKneOJFo]Og5oMGm`005nMHkeO
WEmMGcaOGE/lGeeO?5mME]/00e[k00YFfe[kE]YJneKJF_]FVEJjOol004Qoo`00?Goo10001Goo0P00
1Goo10009goo0`00GGoo0T=c00I;]U?HDmQKne_KGmd3Gm`01F>mGid005nmGed00emL00EOGEllGeaJ
ne/K00IJn`9F^P06EYYF^UJjE[Yoo`00Agoo000lOol00`00Oomoo`02Ool00`00Oomoo`02Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`0ROol200000goo001oo`1LOol2@g<05TNDDmQ?]e_jEmUOo5_L
GoaOWF>mGieS_@00GgeOG5mmFcaOGEllFaaJne/L0U[k00]Ffe[kF_]JneJiE[YFVEJjDYUF^UJI009o
o`03001oogoo04Aoo`00?7oo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol07goo0`00Ggoo
0T=c0T^E00E?edngEmYOg5ol009Og00:GkeS_EnmGeeOG000GeaOGEmLGed3F_/00e/KF_]Jn`03F_/7
E[X01EJJE[YF^Woo0000AWoo000lOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`0MOol2
001QOol07DND@g=;UDngDmQGfEolFmaOo5_LHkeO_F?MGkeSOEmLGgd005mmGeaO75/KGaaJne/LF_]K
75[kFa`00UJj00YF^EJjE[YF^U:IE[YFVEJjDYUF^P9oo`03001oogoo04=oo`00?7oo00<007ooOol0
0Woo00<007ooOol02Goo10007Goo0`00HWoo00e7M4=cBiE?]doGDmUKne_KGoaO_F>mGkeS_@05Ggd0
1@00Fa]K75/KFa`00U/K0e[k00=FfUJjE[X01UJj00=FVUJjE[X00U9i00Aoo`00000004Aoo`00?7oo
00<007ooOol00Woo00<007ooOol02Goo00<007ooOol077oo0P00I7oo01m7U4=bAiA;UTngDmQOo5_K
GoaO_6?MGkaSgEmlHgeOG6=mGgaO?000GaaK6elLF_]O75/KF]YF^U[KE[YJfP04E[X02EJiE[YF^UJI
DWQFVE9iEYUBN002Ool00`00Oomoo`12Ool003aoo`03001oogoo009oo`03001oogoo00Uoo`03001o
ogoo01Uoo`<006Aoo`0:@g=7M4=cAiA;]UOIDmUKne_KHmd3Gmd00f?MGgeOW@02Ggd015/LGcaK7000
0U/L00=K6e/LE]X00eKJ0eJj00=FfUJjE[X00UJj00=BNE:IDWT01E9i0goo00<007ooOol0@Goo000m
Ool4000<Ool5000DOol3001VOol0<4=dAiE3LdnfDmQGnE?HGoaKff?MGkaSgEnlHieOOF>MGgaSWE/K
GcaK6ell001O?5/KF]]F^U[KE[YJfeJjF]YF^U[KE[YJfU9iEYUBNEJIDWUFVE9iEYUBN5JIDWUFV@=o
o`03001oogoo041oo`00I7oo0P0000=oo`00Ool0IGoo0dND00a;UE?HDmQCf5_kFmYOgEoLGmeOWF>M
Ggd2Gid02F>MFcaO?5/LGcaK7000FaaJf`03E]X03E[KE]YFfUJjE]YF^UJIDYUFVE9iDYUBNEJI00MB
N@=oo`03001oogoo041oo`00HGoo0`00JGoo0393M4=c@g=;]DngDmQGfU_kGmaSoEoLGmeOWF>mGgeS
WEmlGeeK?5llFcaO?5/KGc`005[kE]YJfeJjF]]F^U[KE[YJfe9iEYUBNEJJDWUFVE9iEYUBNEJIDWUF
VE9iEYU>F59h17oo00<007ooOol0?goo001OOol2001ZOol2Ai@2@g<03D^EDmQKne_JGmeOg5oMGmaS
WEnMHkeOWF>M009O?00<FcaO?5llGcaK?5[KE]/005KJF]]Ffe[K0eKJ00eFVE:IEYUBVEJIDYUFVE9i
EYUBNE:IDWUFV@06DUP4Ool00`00Oomoo`0NOol3000MOol005aoo`<006]oo`0]BiI7UD=cBiE;]Dnf
FoYGfEolFmaOo5nMHkeOWF>mGieOGE/lGeeK?5llFcaOGEKKF_]FfU[k001JfeKJF_]FfUJJDYUFVU:I
EYYBVEJJDWUFVE9iEYYBNEJI009BN@07DUQBN4iHDWQ>F59hCUP017oo00<007ooOol07Goo00D007oo
Oomoo`0001aoo`00FWoo0P00KGoo00=7UD=c@g<00TND00=?]eOjGm`00UoL00EOo5nmHkeO_F>m00=O
G003GeeOG5mL009Jn`0:F]]Jne[kF_]FfP00E]]JfeJIEYX2EYT02E:IEYUFVEJIDYUFVE:IEYUBV@02
DUP00e9hDUQBF006DUP5Ool00`00Oomoo`0LOol00`00Oomoo`0NOol005Moo`<006ioo`0iBiI3Ld=c
AiA;UEOIGoaKg5olFmaS_EnmHkeO_F>mGeaOOE/lGeeO?5/LF_]K75KKF_]FfU[kE]]Jn`00E[YBVEJj
DYUF^U:IEYYBVEJJDYUFVU9iEYYBF59iCUQBNE9HDWQ>F59iDUQBN4iHDWQ>F59h00=oo`<001eoo`03
001oogoo01ioo`00E7oo0`00Kgoo01A7UDNDAiA3LdNDCkMCf5okFm]Kne_KHkeO_F>mGkeOOEmLGgeO
GEmm25[k00QJfeJjE[X005JIEYYFVEJj15JI00QBVEJIEYUBN59HDWQBF59h0e9H00=BN59HDUP01E9H
1Goo00<007ooOol06goo00<007ooOol07Woo001BOol20002Ool00`00Oomoo`1/Ool0?D^FAiE3M4=c
AiA?]U?HGoaKfeolFm]SgEnmHmeOG6=mGeaOOEmLHgeJnelLF_]K75[kFaaJne/LEYUF^U:IE[X005Jj
DYUF^U:IE[YBVEJJDYUFVU9HDWUBF59iCUQBNE9HDWU>F59iDUQBN4iHDWU>=e9HCSMBF4hg00Eoo`03
001oogoo00Moo`@000ioo`D001eoo`00Cgoo0`00LWoo00i;]TND@g=3LdMcDmUCf5okFm]KnenmHmeO
_EoM0Umm00MOG5mmGeeK75/KFaaK6`05F_/4E[X02EJJE[X005JjEYUFVUJIE[YBF002DWP02E9iDUQB
N59HDWQBF59hDUQBN004DUP01ThgCSQ>=e9HCSM>>0Ioo`03001oogoo00Eoo`03001oogoo009oo`03
001oogoo00aoo`03001oogoo01ioo`00C7oo0`00M7oo01a3M4NE?e97U5?HEmUCf5olFm]SgEnlHmeO
_F>MGgaSWEmlHieJnelLF_]O75[kGaaJne/LF_]J^PAF^P0DEYUF^U:I001BVEJjDYUFNE9hDWUBF59i
DUQBNE9HDWUBF59iCUQBN@9BF00:CSMBF4hgDUQ>=e9HCSMBF4hgDUP5Ool00`00Oomoo`05Ool00`00
Oomoo`02Ool00`00Oomoo`0]Ool004Yoo`@007=oo`0=BkM7UDNE@g=;UDngDmM?]e_kFmYOgEoLGmd0
1Emm00UO?5/LGcaK6e/LFa]K75/KFa`01UJj00eFVUJjE[YF^P00DWUBN59iDWQBNE9hDWUBF002DWP0
4U9iDUQBN59HDWQ>=e9HCSMBF4hgDUQ>=e9HCSM>>4hgDUQ>=`Ioo`03001oogoo00Aoo`03001oogoo
009oo`03001oogoo02eoo`00B7oo0P00MWoo01e?fDNEBkI3LT^eCkMCf5OJFo]Og6?MGmaSoEnMHieO
WF>MFa]O?5/KGcaK6elLF_]O75[kF]]F^U[K00=F^P0TF[YF^UJjDYUF^U9h001BN5IiDWQBNE9HEWUB
F59iDUQBNE9HDWU>=e9HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF4hg1Goo00<007ooOol017oo
00<007ooOol00Woo00<007ooOol0;Goo0014Ool4001gOol04DoHAiE3M4=cBiE?]e_jFmYOgEoLGmeO
g6>MGieSWEnMHid00Ull00YK75llFaaO?5/LE]YF^UKJE[YFfPMF^P=BN@0:001BNE9hDWUBN59iDWQB
NE9hDWT2DUP04TiHDUQ>=e9HCSQBF4hgDUQ>=e9HCSMBF4hgDUQ>=dhhCSMBF0Ioo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo02eoo`00@goo0`00N7oo025;]TNEAiE3DT^eBkIGnUOIGoaOg5ol
FmaSWEnMHieOWEmMFcaO?5/lGcaK6ellE[YJfeKJF]]F^U[KE[YJfeJjF[X00UJj00aBN5JIDWUFNE9h
001BN5IiDUQFNE9hDWT2DUP05DhgDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9HCQM>=dhGDSM>
5`07Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0]Ool0041oo`<002]oo`06E_]Fo5Kl
>QXj6CXJB7oo00=?^4^gBkL00T=c00E7U4^fEmUOg5ol009Og004GkeS_EnmHkd7Gc`01E[KE]YJfeKJ
F]/00UKJ00AF^UKJE[YFfP=BN@03EYUBNE9i009BN@06001BNE9iDWUBN59i0U9H00i>F59HCUQBF4iH
DUQ>>59HCSMBF4hhDUQ>=e9H2Dhg1Woo00<007ooOol00goo1000<7oo000mOol3000/Ool03EKlE_]F
o5KKE_`j6CXJ>QTn6RUg:IPUMbVH049oo`0nCkU?]d^gAiA3LdNDEmUGnU_LGoaOWF>mGieS_EnMHkeO
?5mMFcaO?5/lGeeFfU[kE]YJfeKJF]]F^U[KE[YJfeJjEYUBNEJIDWQFVE9iEYUBN5JIDWP0059hEYUB
N59HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF09>=`0:CQMB>4hgCSM>5e8gCQM>=dhGDSL5Ool0
0`00Ool0000hOol003]oo`<002eoo`9_VP=Fo00:E_]Fo3XJ>QXj6BUh:GLYV2Ug8CI0Ool01ToJBkM7
U4=dAiA?]P9Cf007Fm]OnenmHkeO_F>mGkd00UmL01EOGEmLGeaJfe[kF]]Jne[KF_]FfU[KE]YJfeKJ
F]]BVEJIDWUFVE:IEYT00e9i00IFVE9i0000059HCUP3DUP034iHDUQBF59HCUQBF4iHDUQ>F59HCSQB
F0e>=`Qoo`03001oogoo03Eoo`00>7oo0`00;goo019_^fnJKkY_VUKlE_]Fo5KK?QXj6CXJ>QTYV2Ug
:IPUMb5G8CHlOol015?JBiI?]dNE0T=c02A;]E?HDmQKff?MGkeSgEnlHmeO_EmMGcaOGEmLGeeJne[l
E]YJneKJF_]FfU[kE[YJfeKJEYYBNEJJDWUFVE9iEYUBNEJIDWP300005TiGDUP0059HCUMBF4hgDUQ>
=e9HCSMBF4hgDUQ>=e9HCQMB>4hgDSM>5e8h0Thg00Q>5e8hCSM>=dhGDSM>5dhg27oo00<007ooOol0
=Goo000fOol2000aOol5KiX01EKkE_aFo5KlE_/00cXJ00@YMbUh:GLYV0<Q=SUoo`9?fP03CkU?fD=c
0093L`9Cf008Fo]Kff?MGkeS_EnmHmeOO09OO@03GeeOG5[k00AJn`07F]]Jne[KF_]JfeJIDYT00eJI
00EBVEJIDYUFVE9i00<000ABF005CUP0059HDUQ>F003DUP01DiHDUQBF59HCUP04dhg27oo00<007oo
Ool0=7oo000dOol2000bOol05VnkKiY_^VnJKk]_VVnjE]]Fo5KkE_`j6ChJ>QTj6REg:IPYMb5G7CHQ
EadF=goo00ECfe?LBkQ?fDND0093L`0>EmUCf5_jEmYSgEoLHmeOG6=mGeaSOEmLHgeOG09Jn`03F_aJ
ne[k009Jn`0<E]YJne:IE[YBVEJJDWUFVU:IEYYBNEJI0P0001i>F59iCUQBF4iHDWQ>F59HCUL004iH
DUQ>Ee9HCSMBF4hgDUQ>=e8gCSMB>4hgDSM>5e8hCSMB=dhGDSP2CSL01dhGDSQ>5dhgCQMB=dhG00Uo
o`03001oogoo03=oo`00<goo0`00<Goo1VnJ0U/L00Hn>ShJ?SXn>RVH:GL3:IP00bUg:GPQ=P038CH0
0adf8CIoo`0bOol2Dm`01ToICkU;]TND@g=;U@9?]`08FoYKfUoMGmaOgEnMHieOO0=OO@=K6`IJn`05
EYYFVEJJEYUFVP02EYT00e:IEYT00002000;DUP014iH001BF59H5Dhg0ThG00=>=dhFCQL02Goo00<0
07ooOol0<goo000dOol00`00Ool0000_Ool06g_GMkIgegNfGaaK6elLFa]O75/K?SXj6Shj>QXYV2Ug
:IPQ=RVH9GLYV24f8ELM=R4f7AHQ=P0`Ool06U?KDma?^4oIBkQ?^4NDAi=7M5?GEmYKnUoLHmeOg6>M
GgaSWEmmHieJnelLF_]O75[kGa`3F_/02E[lEYUF^U:IE[YBVEJjDYUF^P0300008E9iDUQBN4iHDWUB
F59hCUQBN4iHDUQ>F59hCUQBF4iG001>=e8hCSMB>4hgDSQ>=e8hCSMB=dhgDSQ>=e8gCQMB>002CSL0
2ThGDSQ>5ThgCQI>=dhFCSM>5Thg2Goo00<007ooOol0<Woo000YOol50006Ool01000Oomoo`00;Woo
00Eg]gOGMkMc^W>i00=K7006Fa]K73hj?SXn6Shj0RVH00DYMbVH8CHQ=RUg00<Q=P<M=P038CIoogoo
02aoo`08DkeCgDoJDm]CfTNEAiA3L`9?]`05EmYKnUoLGmeOO@02Gid01F>MGgeOWE/LGc`00e/K00=K
75/KFa/00UJj00IFVUJjE[YF^UJIEYX300001E9hDUQBN59HDWP02e9H0dhg00<004hgCSL03dhg00=>
5dhgCQH00ThG00I>=dhFCQM>5dhgCQH:Ool00`00Oomoo`0aOol002Uoo`05001oogooOol00005Ool2
0003Ool00`00Oomoo`0ZOol067NfMmMg]W>jKkUc^VnIGaaK6elLFa]O73XJ?SXj6RVH:GLYV2Ug8ELQ
=R5G7CHQE`8Q=P057AHQ=QdF8CLM=P0ZOol075?NDkeGgToJDm];]d^fAiI7U4^ECkICfEOIFmaOo5nM
HkeOO6>MGgeO?5/KGcaK6ellF_]O75[k0UJj00EJfUJIE[YBVEJj00<0000SE[YBF59iDUQBNE9HDWU>
F59iDUQBN4iHDWUBF59hCUQBN4hgDSQ>=e9HCSMB>000DUQ>=e8hCSMB>4hgDSM>=e8hCSMB=`02CSL0
3ThFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCSL9Ool2000cOol002Yoo`03001oogoo00Ioo`03001o
ogoo00=oo`03001oogoo02Uoo`03MmMg]g>j00=c^@03LkYc^E/L009K7005Fa/n>Shj?SXn6P03:IP0
0bUg8CHQ=P058CH27CH38CHWOol01E>mDmeC_E?KCmX00ToI00A;]TNFAg=;]@9Gf@9Og00=HkeOWF>m
GieS_EnMGcaK75llFaaO?5/LGc`01UJj0`000UJj00UBNE9HDWQBN59iDUQBN59HDWP01e9H00EB>4hg
CSM>=e8h00A>=`03001>=dhg00M>=`03CQM>=dhG009>5`06CSM>5dhGCQM>=dhF0ThG00A>=dhFCQM>
5`]oo`03001oogoo031oo`008Goo1P0017oo00<007ooOol01Goo0P001Goo00<007ooOol09goo01Mg
egNfLkY_^G>jKiUc^VniHeaO>d9K?SY2Fchj;IPYMbVH:GLYV2Ug:IPM=R5G008Q=P0:7AHQEadF8CHM
5R4f7CHQ=b5G9GLSOol08E>oDiiCWdnNEmeCg4oICkU;]T=bAiACfEOiDmUOo5_LHkeOWF>mGieS_E/l
GeaK?5llFa]O?5/KF]]F^U[KE[YJfP030000>UJjEYUF^U9HEWUBF59iDUQBNE9HDWU>F59iDUQBNDiH
DWUBF59hCSMBF4hgDSQ>=e9HCSMB>4hgDUQ>=e8h001B>4hgDSQ>=e8hCQI>=dhFCSM>5ThgCQI>=dhF
CSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhF2goo00<007ooOol0;goo000/Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`0UOol00gOGMkMc^P03LkT02G>jGc]S?5llHc`n>T8j?SY2FP03:IP0124f
:GLYV2VH0b4f00<M=R4f7CH00Qdf00<Q=Qdf8CH00R4f00@QEbEG9ELUMaeoo`ECWP08DmaCgE?LCmU7
UT^f@g97L`9Cf006DkMKne_kHkeO_F>m1ell0UKJ00AJfUJjE]YFfP8000=F^P09DWQBNE9hDWUBN59i
DWQBNE9H00=BN004DUQBN59HDWP3CSL01E8hCSM>=dhgDSP01dhg00<004hgCSL00Thg0dhG00E>=dhG
CQM>5dhg00=>5`06CSM>5ThGCQM>=dhF0ThG00=>=dhFCQL02goo00<007ooOol0;goo000]Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool2000UOol0:GNfNmMg]W_GMkIkeelkHeaO>f=LGc]SG3hj@U/n>T9K
:GL]V2Ug8ELM=RVH:GLQEadf8ELM5R4f7CHQ=QdF8CHM=R5G7CHUMb5G9GLQEbVH9IP06Goo025;GTmO
Bei?Ge?LDmeC_5OMCkU?fD^gCmQ3LdNDCkMCf5_KGo]O_6?MGkeSgEmLHgeK?5mLFcaOGEKJF]]FfU[K
E[X00`000eJj00eFVE9hEWUBF5IiDWQBNE9HDWUBF59iDUQBN@02DUP0;DhgDUQ>=e9HCSMBF4hgDUQ>
=e9HCSMB>4hgDUQ>=e8hCSMBF4hg001>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCSM>
5ThgCQI>5dhFCQM:5P0<Ool00`00Oomoo`0^Ool002Uoo`05001oogooOol00005Ool00`00Oomoo`08
Ool00`00Oomoo`0QOol04GNfNkIg]WOFMkIgeW>hLkUO?6<lGc]S?5ll@UXn>T8j?SX00bVH1b4f0Qdf
0b4f00<M=R4f8CH00R4f00@UMb5G9ELUE`<YV1Aoo`06Cei?GdmNCem?GTmO15>n0U?K01=;^4nh@g=3
Le?HGo]Kfe_kGkeS_EnmGeeOG5mMGeaOGEmLF]]FfP02F]/3000015KJF]YF^UKJ1U9i00ABN59iDWQB
N@=BN009DWU>=e9HCSMBF4hgCSQ>=e8h00=>=`05DSQ>=dhgCSMB>002CSL02ThGCSM>5dhgCQL004hG
CSM>5dhg0dhG00E>=dhGCQM>5dhg00=>5`05CSM>5ThGCQI>5`03CQH00dhGCQIoo`0;Ool00`00Oomo
o`0]Ool002Yoo`<000Eoo`03001oogoo00Yoo`03001oogoo01moo`0IMkEkeWNfNmMg]W_GLkQgfG>h
MmUc^6=LGc]SG5lk@U/n>T9K?SXYV2Ug;IPQ=R5G7CH00R4f00XQEadF8CHM5R5G7CHQEadf8CLM=P8Q
E`039GLQEbEg008YV0069IPY^BgI<OX]fC7j2Woo00Y6oD/NA_i:oTKmBai;GTmOBeiG_P9C_P0EDkeG
_ToKDma;]dNE@g93Ld^fFoYGfU_jGmaSgEoLGeeOG6=mGeaOGEmL009Jn`<0000TE]YJfeJjF]]F^UJI
DWQFVE9hEWUBN5JIDWQBNE9HEWUBN59iCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9H
0Thg021>5ThgCQI>=dhFCSL004hgCQI>=dhFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCQM:5ThGCQI>
5dXFCQM>5ThG37oo00<007ooOol0;Goo000bOol00`00Oomoo`0;Ool00`00Oomoo`0NOol01W^fMkIg
eWNfMmIg]P9c^@09MkUc^6MKIe]6Fd9J@U/YV2fH00DYV0@Q=P8M=P048CHM=Qdf7CH38CH29GL28CH0
12EG9GLQEbEG0bVH00LafRgI<OX]fC7J=S/j>`03=S/01D:M?Y`nWCjM@Yd01TKn1E>n0U?K0T^h00I;
]T=cAiEGfU_jEmX2Gmd026?MGgeOOEmmGeeOG5mMF_/30002F]/025KJF]]JfeJIDWUBVE9iEYT6DWT0
4U9hDWUBN59HCUQBF4hgDUQ>=e9HCSM>>4hgDUQ>=dhhCSMB>0A>=`0@CQM>=dhGCSM>5dhgCQM>=dhG
CSL004hgCQM>=dhGCSL3CQL01DhgCQI>5dhFCQL00dhF00E>5dhFCQI>5ThG00=>5P03CQMoogoo00Yo
o`03001oogoo02aoo`00<Woo0P003Goo00<007ooOol077oo02AkeWNfNmMg]W_GMkIgfG>hMmUSFfMl
He]WO49JAW]2FTIk:IP]V2VG8ELYMbVH7CHQEb4f8ELM5R4f7AHQ=QdF8CHM=R5G7CH28EL01bEg8ELU
Mb5G9GLQEbVi008YV00[9IPanRgI<OX]fCXl=S/j>cHk>S`f>d:M?Ya2WCjL@Ye6oD/NA_iCOdmnDim?
OU=oCm]Cg4oKDmY?^DMc@g97U5OJFoYOg6?MGmaSWEmlHgeOO6>MGg`00`000U[k04]FfU[kE]YJfe9i
EYYBNEJIDWQFVE9iEYUBN5JIDWQFNE9hEYU>=e9HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF4hg
DUQ>5U8gCQM>=dhFDSM>5dhgCQI>=dhFCSM>5Thg001>=dhFCSM>5ThgCQI>=dhFCQM:5ThGCQI>5dXF
CQM>5ThGBQI>5dhFCQM:5ThGCQH03Goo00<007ooOol0:goo000bOol00`00Oomoo`0=Ool00`00Oomo
o`0KOol01GNfMmIg]WOFMkH00W>i00EWO6MKIe]WFfMl009WF`03@UY6Fd9J008YV005;IPYV24f8CHY
V0048CH27CH28CH00adf8CHQ=P028CH39GL01BEG:KPUEbEg8EL00bVH00D]fC7J;MTanRgI008f>`06
>S/f>cHk?Ye2WCjL0SjM00I2WDmnCgm?OU=oCgh3Dmd025>mCmY;]T=c@g9?]U?HEmT3Gm`01F>MGieO
OEmmHgd00P0000=K6e[kF_/015[k0eJI00UBVEJIEYUFVE9iDYUBNEJICUP00e9H011>F59HCUQBF4hg
DUQ>F59HCSMBF4hgDUQ>=dhhCSMBF0A>=`0@CQM>=dhGCSM>5dhgCQM>=dhGCSM>5dhgCQM>=`00CSL2
CQL02ThFCQM>5ThGCQI>5dhFCQM>5ThG0dhF00E>5dhFCQI>5ThG00=>5P]oo`8002eoo`00<Woo00<0
07ooOol03Woo00<007ooOol01goo00=kUGooOol03goo01mg]W_FMkIkegNfNmIg]GOHLkMWO6=KIgaS
FfMlHe]6Nd9JAW/YUbfH:IP]V1df8ELQ=R5G7CHQEadF8CHM5P028CH0125G7AHQEadf0R5G00TUN25G
9GLYV2fi:IP]^BFH:KT00RVH01T]fC7j;MTanSHk>S`f>cXk=S/j?4/NBcm;7T/oBai;?d/NEmeC_E?M
DkeGgDniCmQ;^002@g<02D^eDmQOo5oLGoaOW6>mGieSW@0300000elLF_]O7002F_/07UKJF_]BVEJj
DYUFVU9iEYUBNEJJDWUFVE9hDUQ>F59HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF09>=`0^CQIB
=dhGCSM>5U8gCQM>=dhFDSM>5dhgCQIB=dhFCSM>5ThgCQI>=dhF001>5ThGBQI>=dhFCQM:5ThgCQI>
5dXFCQM>5ThGBQI>5dhFCQM:5ThGCQI>5dXFCQL=Ool00`00Oomoo`0ZOol0035oo`<0011oo`03001o
ogoo00Eoo`04NiEkUW^E0;H>Ool017NfNkIg]W^g0gNf00EkeWNgMmQg^7OH00=6N`05BY/YV2fH@UY6
F`03:IP38CH01adf8CHQ=R4f7CHQ=Qdf008Q=P068ELQ=R4f8CHUMbEG0bEg00<YV2Vh:IP01C7j00@]
fC7J;MTanPI2_@04Bai;?T/NBch5Dih2Dm`2CkP2@g<01eOIDmQOo5oLHieOWF>M00<00006GcaK75/K
Fa]K75[k0U/K00IFVUJIEYUFVEJJDYT3EYT00e:IEYUBF005DUP034iHDUQBF59HCSMBF4iHDUQ>=e9H
CSMBF0A>=`05CQM>=dhgCSM>5`03CSL02ThGCSM>5dhgCQM>=dhGCSM>5dhg0ThG011>5P00CQI>5dhF
CQM>5ThGCQI>5dhFCQM>5ThGCQI>5`=>5P03CQM>5ThF00=>5Pioo`03001oogoo02Uoo`00<Goo00<0
07ooOol04Goo00<007ooOol017oo00EkUW^ENiH0]@2f00eoo`0`NmIg]W_GMkIk]gNeNmIc]gOHLkMg
f6]kJi]6NTZKAW]:VbVH;KPYV2fH:IL]V24f8ELM=R5G7AHQ=Qdf8CHM5R4f7CHQEb4f9GPUEb5G7CHU
Mb5G9GPQEbfi:IP]^BVH137j018jG3YK>U`jFcYL@[e6gT:m@]e2_DKN@[eC_dnNDkm?WU>oCih2Dm`0
2DoHAiA7LdNEDmM?]eokFm]S_@030000FUllFa]O?5/KGcaJnelLF_]O75JIE[YFVEJjDYUF^U:IE[YB
NEJJDWUBF4iHDUQ>F59HCUMBF4iHDUQ>=e9HCSMBF4hgDUQ>=e9HCSMB=dhGCSM>5e8gCQM>=dhFDSM>
5dhgCQIB=dhGCSM>5U8gCQM>=dhFCSM>5ThGBQI>=dhFCQM:5P00CQI>5dXFCSM>5ThGBQI>5dhFCQM:
5ThGCQI>5dXFCQM>5ThGBOI>5dXFCQM9mPeoo`03001oogoo02Uoo`00:7oo1@0017oo00<007ooOol0
4Woo00<007ooOol00Woo00MkUW^ENiEkUG^F0;H03P0;Ool2LiT03G^gMkIg]WNfNmIg]gOHMkQgf6]k
Ji][Nf^K00=6N`05;KPYV2fH8CH]V002:IP38CH27CH01B4f7CHM=Qdf8EL00b4f00<UN2Eg9GL00REg
00HUEbEg9GLY^BVH:KP5<OX00cYL>U/jG002>U`4@[d00d]NCem?GP03Dih2Dm`01T^hCkQ;]d=cAgA?
]`9Kn`<00003HkeO_Ell009O?005FaaO?5/LGcaFVP03E[X015JJE[YFVEJJ0eJI3E9H00=>F59HDUP0
3Dhg00E>5dhgCSM>=dhG00=>=`0HCQM>=dhFCQM>5ThGCQI>5dhFCQM>5ThG001>5dhFCQM>5ThGCQI>
5dhFCQM>5ThG34hF3Woo00<007ooOol0:7oo000ZOol00`00Oomoo`04Ool2000DOol02`00Oomoogoo
NiEkUW^ENiI[^`0=0;D02Woo03=c^G>HNmMg]W^gMkIkeW>gMmQc]gOHJg][Vf]jJi][NdZKAWY:VdIk
;KPYV2fh8CHQEbVG8ELQ=R5G7AHQ=QdF8ELM5R4f7AHQEadf8ELUMbEh9ELUN2Vh;KTY^2gI:IP]^BVH
;KT0137j01HjFcYL>U/jG3YK>Ua;?TmOBci?Gd/nCem;?U?LCk]Cg4oJDm]3LdMcCkMOn`<0000GHkeO
_6>mGcaOG5/lGeeK6ellFa]JfUJjF]YFVEJjEYUF^UJIE[YBVEJjCUQBN@02DUP08TiHDWQ>F59HCUMB
F4iHDUQ>Ee9HCSMBF4hGDSQ>5dhgCQMB=dhGCSM>5e8gCQM>=dhFDSM>5dhgCQIB=dhGCSM>5U8g0ThG
02=:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQL004hgCQI>5dXFCSM>5ThGBQI>5dXFCQM9mThGBQI>5dWf
CQM:5ThGBOI>5dXF00moo`03001oogoo02Moo`00:Woo00<007ooOol017oo00<007ooOol057oo00<0
07ooNiD00W^E00IkUV^kJm][f`2f00h8Ool3LiT3MkH03G_FMkIgf7NhMmQ[Nf^KJg][Vf]kJi][NdZK
0096N`03;IP]^2VH00LQ=P<M=P058ELQ=Qdf8CHQE`028CH00bEg9GPUM`03;KT01BVi;KTf6SHK<QX0
1C7j0TKn00Q6gDKnA_i6oT]NCem?GTmO15>n00A?fT^gAiE3L`<00005FoYOg6?MGmeOG003Gc`00emL
GcaO?006E[X01EJJE[YF^UJjEYX00U9H00=BN59HDUP02e9H3dhg00A>5dhgCSM>=`9>5`0HCQI>5dhF
CQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThG001>5dhFCQM>5ThG44hF3goo00<007ooOol09goo
000OOol60005Ool00`00Oomoo`04Ool00`00Oomoo`0EOol02P00NiIkUF_LJk][g6^kJm`0300>27oo
01YcV7>iMkIk]gNfNmIg]W_FMkEkeWNfMmMg]WOGBY]>_4ZKC[`]V2fhAWY:VbVH;KPYV25G0R4f00DM
=R5G8CHQ=QdF008Q=P0V8ELQ=R5G8CHQEadf9GPUMbEh9EL]fBVh;KTY^3HK<QXf6c7j?YdjO3il>W`n
WDKMA_i2gDKnA]e6oT;MDmiC_E>nDkeCfd^iCmU3L`800007FoYGfF?MGmaSgEmLHgd00UmL00YK?5mM
GcaJfeJjF]]F^U[JE[YJfP9F^P1BEYUF^U9HDWU>F59iDUQBN4iHDWU>F59HCUQBN4iHDUQ>Ee9HCSMB
=dhGDSQ>=e8gCQMB=dhGCSM>5e8gCQM>=dhGDSM>5dhgCQIB=dhFCQM:5ThgCQI>5dXFCSM>5ThGBQI>
=dhFCQM:5ThgCQI>5dXFCSM>5ThG001>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>
5dWfCQL?Ool00`00Oomoo`0VOol002Yoo`03001oogoo00=oo`8001Moo`9kU@03Jm][^f_K009[f`04
Jk/03@0>00h6Ool2LiT3MkH02g^gMkIg]WNfNmIg]WOGMkMgefnJKkX00Tjk00A:Vdjk;KP]^0<]V003
;KPQ=R4f008Q=P047CHQ=Qdf8CH27CH01b4f8ELQ=REh8CHQEb4f008UM`039GPY^Bfi008]^@05:KTf
6SHJ=Q/b6P05?W`2A_h01TKMA_i?OTmoCgi?O`9Cg@0ECkT00000001;UEOJGmeSgEoLGgeOG5mmGeaO
OEmLGgeFfU[JE]YJfeKJ00IF^P05DWUBF59hDWQBN@03DUP00e9hDUQBF004DUPDCSL06ThFCQM>5ThG
CQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhF000ECQH>Ool3000WOol002Yo
o`03001oogoo00Aoo`03001oogoo00]oo`04DSIF=eRPG<06Ool02g^EMcIc=GLfLcEkUG]eJm`0300=
00h01Goo04EcV7>iLiUk]gNfNmMg]gNhMkEkeWNfMmMg]WOGKiY_^VnJC[a:VdjlBY/]^BfH;KPM=R5G
:IP]^1df8ELM5R4f7AHQ=QdF8CHM5R5G8CHQEbEg:IPUMbVH9ELUN2Eg9GPY^2gI:KP]^C7j=Q/b6SHK
>W`nWCYl?W`jO3jMCgiCOdmnDim?OU?MDk`00`00038oDTnfBiECf5oLHoaOg6>MGgaSOEmLHgeOG5[k
F]YJneJjF]]FfU[KE[YFNE9hDWUBF5IiDUQBNE9HDWUBF59hCUQBNE9HDWQ>F58hCSMB>4hgDSQ>=e8g
CQMB>4hgDSM>5e8h0Thg03Q>5e8gCQM>=dhGCSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5ThGBQI>
=dhFCQM:5ThgCQI>5dXFCSM:5ThGBOI>5dXF0019mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>
5dWfCQM:5ThG47oo00<007ooOol09Goo000XOol30005Ool00`00Oomoo`0:Ool01eHfDSIF=U8fESIH
X5f000Aoo`9FN009LcIg=WLfMcIkMG^ENgE[f`0<00803P03<Q/b6S8K00=cV@=WF`0=MkMg^7NfNmIg
]WOGMkMgefnJKkY_VVnjKiX00djk00@]V2fh;KP]^0HQ=P0;7CHQ=R5F8ELM=R4f7CHQEb4f8ELUM`02
9GP4;MT00bfi:KT]^@02;KT0138J=QXf6SHK24/N00MCg@00000004niBkM3L`02Ai@2Gm`01UolGgeS
WEnMHieOO@=Jn`08F]]Jne[kF]]FfU[JDWUFN@9BN@07DWQBNE9hDWUBN59iDUP00e9h0U9H00=>=e8g
CSL04Dhg0ThG01A>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThG2dhF00<004hF
CQH04DhF4Goo00<007ooOol097oo000ZOol00`00Oomoo`03Ool20009Ool01e8fEUMB=UHgDSIFEe8f
009HX09oo`0dEWQBN5JILcEg=W<eMcIkMG^ENgEkU@3G00d0]@0><QXf6c8J=Q/b6VMKIeY[NfMKMkQg
Ug_FMkIgegNfMmM_VVnjKiYc^fnJKkY:VdjlBY]>_2fH;KT]V25G7CHQEadf8ELM=R4f7AH28CH072EG
8CHQEb4f8ELQ=RVH9GLYV2Eg;MT]^C7J;KTj>cHK>S/f>cXk?Ya2_CjL@[e77T/OAai;7TLN0`00011?
WU?LCm];]d=cBiECf5olGmaSWEmlHieOO6>MF_]K709Jn`1QF]YJneKJF_]JfUJIDWQFVE9hEYUBF5Ii
DWQBNE9HDWUBF59iDUQBNDhgDSQ>=e9HCSMB>4hgDSQ>=e8hCQMB>4hgDSM>5e8hCSMB=dhGDSQ>5Thg
BQI>=dhFCSM:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM:5ThGBOI>5dXFCQM9mThG
BQI>5dWfCQM:5P00BOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQH04Goo00<007oo
Ool08goo000`Ool00`00Oomoo`06Ool2CSL01UHfDSIF=U8fESIB=P9^mPIFN0=g=P0:LcIkUG]eNiEk
MG^E00l03@2e00h2<Q/00c8JIe]WF`02Ie/00gNhMkMkeP02MkH01gNgMmM_VVnjKiYBg5;K00=Bg0@]
^003;IP]^24f00<Q=P037CHQ=R4f008M=P0;8ELQER5G8ELYV2Eh8ELQ=REh9GLUN005;MT4=S/01T:m
?Ye2WCjM@[dnW@<0009CWP05Dm]Cg4^gBkM3L`02CkH2Fo/01F>mGkeS_F>mFa/00e[k00=K6e[kF_/0
0U[k00ABNEJIDWUFN@=BN@05EWUBN59iDWQBN@03DWP01E8hCSM>=dhgDSL03Dhg0dhG00E>5ThGCQM>
5dhF00=>5`0>CQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5a1>5P03001>5ThF015>5Q5oo`03001o
ogoo02=oo`00<7oo00<007ooOol017oo05]>5dhgCQM>=dhGESMB=UIGDSIF=fkeLaI^mEIhDWQFVEIh
McIc=GLfLcEkUG]eNiEkMG^EKmT03@0<1;H0]CHK<QYWFfMJJg]WFgNhMiMkeWNfNmIg]W_GMkIkeWNf
LmYc^E;LD]]Fo5;K<KT]^37I8CH]^2fH8ELQ=R5G7CHQ=Qdf8CHM5R4f7AHQEb4f9ELQ=RVH9GLYV2Eg
:IPUMbVH;KT]fBfi<MXf>cXk=Q/j>cHk@[dnW0030000NT/nCem;?U?LCk]Cg4niCmY3DToGFmYOnenL
HkeOWF>mGiaO?5/KFaaJnelLF_]K75[kEYUBNEJIDWUFVE9hEYUBN5JIDWQBNE9HEWUBN59iCSMBF4hg
DUQ>=e9HCSMB>4hgDUQ>=e8hCSMB>4hgDSM>5e8hCQI>=dXFCSM>5ThgBQI>=dhFCSM:5ThgCQI>5dXF
CSM>5ThGBQI>=dhFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5`00
CQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQLAOol00`00Oomoo`0ROol002moo`80
00Eoo`0:KmY>=dhgCSM>5dhgDSIF=U8fESH4K_H4EWP2McH03G<fNiEkMG^ENgEkUFoILmY_f@0?00`4
]@2e00AWF`0;MkQg]gNhMkIcVGNfNkMg]WOFMkIgeP03LkT01E;LD]]Bg5;L<KT00Rfh0R4f00@]V24f
8CHQ=P<M=P038ELM=Qdf008QE`088EHQEbVH:IPUN2VH<MXanPH]f@@f>`80000>Bci?Gd]NCem;?U>n
DkeC_ToIAiE3LdnfFm]Kn`9S_@08GkeS_ElLGcaK6ellF_]K6`9Jn`9FV@04DWUFVE:IEYT3DWT02EIi
DWUBNE9iDUQ>=e8hCSMB>003CSL01E8hCSM>=dhgDSL01Thg0ThG00E>5ThGCQM>5dhF00=>5`0<CQI>
5dhGCQM>5ThGCQI>5dhFCQM>5ThG0dhF00E>5dhFCQI>5ThG019>5P03001>5ThF011>5Q9oo`03001o
ogoo025oo`00<7oo00<007ooOol00Woo011_fFojKmU>=dhGCSM>5dhgDSIF=e8fLaI^mG;fK_Ec5P9F
N00BLcEg=W<eMcIkMG^ENgEkUFoILmY_fG?J00`0402e1;H0]F]k0VMK00YgUgNhKgUcVVmiNmMg]W_F
MkIke`=c^@0=LmYBfe;LD]]Fo2fh<KT]^25G8CHQEadf8EL00R4f00DM5R4f7CHUEb5F008Q=P0?8ELQ
=RVH9GPYV2Eg<OX]fC7j;MTjG3YK>U`fFcYL00<0000gA]i;?TmOBci?Ge>mDmiC_DoJBkM?^4=BCmMG
fEOjGkaSgEnlHmeK6ellFa]O?5/KGcaBVEJJDYUF^U:IEYYBNEJIDWUFVE9iEYUBN5JICSMBF4hgDUQ>
=e9HCSMBF4hgDUQ>=e9HCSMBF4hgDSP00Thg04M>5ThgCQI>=dhFCSM>5ThgCQI>=dXFCSM>5ThgBQI>
=dhFCSM:5ThgCQI>5dXFCSM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>
5dWfCQM:5ThGBOH004XFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWf015oo`03001o
ogoo025oo`00;goo00<007oo00000goo0foJ00M>5dhgCSM>=dhGESIB=P06K_H2EWP06GLfLcIg=W]e
NiEkMG^EKmUcfVoILmU_f@0=00l03@2e1;D0]@BeBY]:_6nILiU_VG^g00=g]P03MmIc^G>i00Ac^@9B
g005D]]Bg2fh<KT]^0078CH27CH68EL02REh:IPYV2VH9GPanS7J<OX]fCYL0`0000<jG4;MA]h00d;M
00=C_U>mDkh00U?L00E;]d^h@g=;UEOI00=Sg@0:GmaOG5llGeaK6ellGaaF^UJiE[X6EYT0459iEYUB
VEJICSMBF4hhDUQ>=e9HCSMBF4hgDSQ>=e8h0dhg00IB>4hgCSM>5dhgCQH2CQL00dhgCQI>5`02CQL0
1DhFCQM>5dhGCQH00dhG00A>5ThGCQM>5`=>5P05CQM>5ThFCQI>5`03CQH00dhGCQI>5P0CCQH00`00
CQI>5P0@CQH@Ool3000ROol002moo`8000=oo`0`KoY_fFojKmU_nThGCSM>5dhgCQMFEfkeL_I^mG<F
K_EcnFoHMcIc=GLfLcEkUG]eNiEVef[gI]MkMP4HLmY_f@0=00m:_4ZKB[a6VdZlBY]cVVmiLiYg]W^g
MkIkegNf0W>i00ecfW>iFaaFnc7I<KPafBfh<MT]^36i7CHQE`028CH04QdF8ELM=R4f7AHUEb5F9ELQ
ERVi8CHQEbEg:IPUN2VH;MTanP<0000i>U`jFcYL=U/jG4mnDgm?OU>OCgiCOdnlDme;]dND@g=KnUOI
HmeO_5mMGcaOG5llGeeO?5mLEYUF^UJIE[YFVEJjDYUFVU:IE[YBVEJIDWUBF4hgDUQ>=e9HCSMBF4hg
DUQ>=e9HCSMBF4hgDUQ>=e9H009>=`1;CQI>=dhFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCSM:5Thg
CQI>=dXFCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThG
BOI>5dXFCQM9mThGBQI>5dWf001:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXF019oo`03
001oogoo00Moo`@001Eoo`009Woo10001Goo00@001iM7UdJG@8NG@9NnP9_fP03CSM>5dhg009>=`I^
mP0;KmQcnFoH5AHDmQDF5?HE5VKGJ]MVe`03NgD20CP02P0=00l03dZLBY]:_4ZKLiU_VG>J0gNf00=g
eWNfLkT00W>i1E/L0c7I0R4f00H]^36i8CHQ=Qdf8CH37CH00b4f8ELQE`028EL4:IP00bEh:IP00002
0000337j<MXanTKnAai6oTLNA_i77TmnCgm?OP9Cg006BkQ;]dNFBiECf5>g0UoL00ISOEmlGeaO?5mL
Gc`2E[X00e[JE[UF^P02E[X00eJiEYUFV@03EYT2DUP034iHDUQBF59HCSMBF4hhDUQ>=e8hCSMBF0=>
=`06DSQ>5dhGCQM>=dhF0ThG00I>=dhFCQM>5dhgCQH3CQL024hFCQM>5dhGCQI>5dhFCQL3CQH01DhG
CQI>5ThFCQL00dhF00E>5dhFCQI>5ThG01E>5P03001>5ThF00m>5Q9oo`03001oogoo00Eoo`03001o
ogoo009oo`03001oogoo019oo`009Goo00<007ooOol00Woo00<007ooOol00Woo02L007oo6SdNGU[J
G_YNfUkjF]X0eVoICSM>5d^OAgi;WfkeLaI^mG;fKmQcnFoHLoTDmADF5?HE5VKGJ_MVef[GMeEkMWME
NgH1600A4CL00P0?02U:_4ZKLiY_NG>JMkIk]gNfNmMgUg_FMkEkeW>hMmQFne/LF_]K72fh<MTa^37I
7CHQEb4f8ELM=R5G7CHQ=R5G9GLM=R4f8EHUEb5F9ELYV2Vi00<0000B=Q/anSjM>W`nWCYl?Ye6oT/N
A_i;7TKnBai?g5?MCkaCfdoJ0T=c00eCf5oLGoaOG6=mGgaSOEmLHgeF^U[JE[YJf`02E[X0JUJIE[YF
VEJjEYUBF4iHDUQ>Ee9HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF4hFCSM>5ThgCQI>=dhFCSM>
5ThgCQI>=dhFCSM>5ThgCQI>=dhFCSM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:
5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThG001>5dXFCQM9
mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThG4goo00<007ooOol02Goo00<007ooOol04Woo000UOol0
0`00Oomoo`02Ool01000Oomoogoo0P000Woo1Ukj0P2f00=7OdNOAgh00TMo00e7WfkfK_I_f48j?QTn
>FoH5AHDmQDF5?IZe`02I]L2NgD01WMENgEcf00=0CP03@8E>005BY]:W6nILiY_V@02MkH02WNhMiQg
^7NfNmIc^7OHMkQgf7>h0e/L00@a^37I<MTQEP8Q=P087CHQ=R4f8CHM=R4f8ELUE`DQE`800003:IPa
nS8J00<anP0A?YdnO3il?W`nWDKnAai6oU>nDiiC_U>NCm]7UTMdDmMCf002Gm`00emmHgeOO002Ggd0
1E[KF]YJfeJjF]X015Jj00=F^EJjDUP02E9H00a>F59HCSQBF4hgDUQ>>4hgCQM>=dhGCSL3CQL01Thg
CQM>5dhGCSM>5P9>5`03CSM>5ThG009>5`=>5P05CQM>5ThFCQI>5`03CQH01DhGCQI>5ThFCQL00dhF
00E>5dhFCQI>5ThG01Q>5P03001>5ThF00i>5Q=oo`03001oogoo00Uoo`03001oogoo019oo`009Goo
00<007ooOol00Woo00<007ooOol00Woo03`007ooOomooekJG_YJfUkjG]YNnShI@SXn6D8j?QU2>ShI
MmQc^48j?QU2>ShI@SY_f1DF5?EZmfKGJ]MVeg]fMeEkMWMEMmQce`4h010EF14g5EQ_NG>JKgUO75/K
MkQgUgNhMkEkeWNfMmQc]gOHLkQSG37I=OT2<MT03bfh<MTQ=R5G7CHQEadf8CHM=R4f7CHUMb5G9GLQ
E`030000TR5F:KTYV2Vi<OXb6c7j=Q/jO3jM>W`nWCYl?Ye?WU>oCiiC_TnjDm];^4NDBiE?]U_JGo]O
W6>mGieS_EKJF_]FfU[kE]YJfeJjF]YF^U[KDUQBN4iHDWQBF59hCUMBF4iHDUQ>=e9HCSMBF4hgDUQ>
=e9HCQIB=dhFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCSM:5ThGBOI>5dXFCQM9
mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:
5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThG001>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQLD
Ool00`00Oomoo`04Ool4000EOol002Eoo`03001oogoo009oo`05001oogooOol00005Ool3G_X2Fc`0
1U/m@QU2>D8I@SU26@=g^008?QTn>ChI@SYNMW?h5?IZe`=Ve`0:NgEgEG]eNgEgf7?GMmP03@4h5CL3
5CP01ADgGa]O6gNhMiP00WNh00IkeWNfMmQg^7OHGc`3He`01C7I=MTQ=S7I<KP00R4f00PQER4f8CHM
=R4f7CHQ=Qdf0`0000@Y^Bfi:KPY^@<YV08anP0B<QXanS7jBci;Gd/nBcm;?T]OBci;?e>mDme3M4Md
BkEKne_J1F>M0U[k00EJfU[KF]YJfe[J009F^P03DWQBF59h00YBF00@CUQBF59HDUQ>F4hgCQM>=dhG
CSM>5dhgCQM>=dhGCSL3CQL01DhgCQI>5dhGCSL00dhF00E>5dhFCQI>5ThG00=>5P05CQM>5ThFCQI>
5`03CQH01DhGCQI>5ThFCQL084hF00<004hFCQH03DhF57oo00<007ooOol00goo00<007ooOol05Woo
000UOol00`00Oomoo`02Ool01000Oomoogoo0P001Goo045K?5/mFaaO?E/l@SXn6D8j?QU2>W>hMmUc
^7OH?QU2>ShIGWIJEV[gI]MZefKGJ_MgEG]fMeEgf7?GMmQc]gOH00d04A4g5EQK6elLFa]O77NGMkQc
Ug_FMkIgf7>gHeaO>f=LGc]SG5lk=OTafCGi8CHQEbfh8ELQ=R5G7CHQ=adf00<0000T8ELUMb5G9GLY
^2fi:IP]^CHK=S/b6T:n?[e2_Cjm@[i;?TmOBci?Gd/nDme?_DoIAiI3Le_JGo]KfV>mGiaS_EnMFa]J
nelL0U[k07=FfU[kE]YJne9HDWUBF59iDUQBN59HDWQ>F59hCUQBF4iGDUQ>F4hgCQIB=dhGCSM>5U8g
CQI>=dhFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dhFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dWfCQM:5ThG
BOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThG
BQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQH004WfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5P0D
Ool00`00Oomoo`03Ool00`00Oomoo`0FOol002Eoo`03001oogoo009oo`05001oogooOol00007Ool0
0e/lFceK?002Fc`00d8i@QU2>@02MkP01G>hMkQg^48j?QT015if0VKG00=ZegMENgD00W]e00McegOH
LmQgf7?G00d1>005Ga/017NHMkQg^7_F0gNf00=gegNgHe`00V=L00EO?6=L<MTefC7I008Q=P048EHQ
=R4f8CH300001adf9GLUEb4f8ELUEb5G008Y^@06;KTY^3Hk=Q/f>cHK1T:m00MCgE>mDme?fe?L@g=;
]@03EmT00f?MHkeSg@07F_/02E[KF]YBNE9hDWUBF59hDUQBN008DUP4CSL044hGCSM>=dhgCQM>=dhG
CSM>5dhgCQM>=dhGCSM>5dhg0ThG00=>5ThGCQH00ThF00E>5dhFCQI>5ThG00=>5P05CQM>5ThFCQI>
5`03CQH00dhGCQI>5P0UCQH00`00CQI>5P0<CQHCOol30004Ool5000DOol001Aoo`80011oo`@000Ao
o`03001oogoo00Moo`0hFceK75lm?QU2>W>hMmUc^7OHLkQgfG>hGWIJEUigFWINMUYFJ_MVeg]fMeEk
MT7gAQQc5W<g0IUgf7>g00h045lLFa]O77NGMkQcUgNhMkIk]gNfNmMg]WOGMkIgeelkHeaO>f=L<MTe
nC7I8ELQ=P<0008Q=P2M7CHQ=b5G9GPQEbEg8ELUMb5G;KTY^2fi:IPf>cHK=S/b6T:n?[e2_DmnDim?
OTmoCk]Cg4=dAiACf5OiGkaSgEnlGcaK6ellF_]O75[kFa]JnelLDWQFNE9HEWUBN59iDUQBNE9HDWU>
F59hDUQBN4iHDSM>5dhgCQIB=dhGCSM>5U8gCQM>=dhFDSM>5ThgCQI>=dhFCSM>5ThGCQI>5dXFCQM:
5ThGBQI>5dXFCQM:5ThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9
mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:
5P00BOI>5dXFCQM9mThGBQI>5dXFCQM:5ThGBQH05Woo00<007ooOol06Woo000COol01000Oomoo`00
5Woo0P002Woo1R8L00EWFfMJ@UXn>T8j00MNMP95m`0>AQQ1mdGgAOMc=W<FLcIc5P6J00d]nRgJ<OYg
V0=g^09[NP03MkIk]gNg00=ge`07Ig][NcGi=OXenCGI<MT00`000R4f00DM=R4f7CHQ=Qdf00<UM`@]
f@0B:KPY^BVi;KTf6cHk=Q/f>cHKCgm?OTmoCgiCg4oKBkI3M4ND0UOI00ES_F?MGaaO?5/K009O700;
GcaK6eIiDWUFVE9iEWUBN59iDWQBN@02DWP0159HDWQBF59h34hg00a>5dhgCQM>=dhGCSM>5dhgCQM>
=dhFCQL3CQH01DhGCQI>5ThFCQL00dhF00E>5dhFCQI>5ThG00=>5P03CQM>5ThF02a>5P03001>5ThF
00A>5P03CQM>5ThG00=>5P03CQM>5Woo01Aoo`03001oogoo01Yoo`004Woo00<007ooOol00Woo00<0
07ooOol057oo00<007ooOol02Goo034R727l9QaW>V]KIcY[Fchj@U/n>T9KFWINMUYFGWMJMW>j@OM6
647gAQQ1mg<gLaIc=g<FNmL1V@1C00danRgI<OX]fC7jJeY_NWNfNmMg]WOGMkI[W6MkJiaWNcXJ=OTi
nP020000YS7I=OTM=R5G7CHQ=Qdf8CLM=R4f8ELUN25G9GPY^BgJ;KT]fSIK>U`fFcYL@]e6oT;nA_i2
gDKn@_iCg4nkCmY3M4NDCkICeeoLHoaO?6=MFa]O?5/KGcaBVEJIDWQFVE9iEYUBN5IiDWQFNE9HEWUB
F59iDUQB>4hgDSM>5e8gCQMB=dhFDSM>5dhgCQIB=dhGCSM>5U8gCQI>=dhFDSM>5ThGBQI>5dhFCQM:
5ThGCQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:
5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9
mThGBQI>5dWfCQL004hGBOI>5dXFCQM:5ThGBQI>5dXFCQM:5ThG5Woo00<007ooOol06Goo000BOol0
1P00Ool00000Ool001Eoo`03001oogoo00]oo`0:Ie]WFVMKIeYWFfMJIe/n>T9J?SX4GWH3KkX0447g
AOM5mdHHLaIc=W<FLcIg]WNg0IX0DbgJ;OX]fS7j0f]j00Uk]gNfMmMgef^KIg][NfMkJi/00`0000De
nR4f8CHQ=R5F00@Q=P057CHUN1df8CHUE`029GL5;MT013YK>U`jG3YL14Kn00U?WU>nDki?fD=dAiA?
]UolGm`01UmL1EJI00ABNEIiDWUFV@9BN@04DWQBNE9hDWT>CSL01DhGCSM>=dhgCQL00ThF00E>5dhF
CQI>5ThG00=>5P05CQM>5ThFCQI>5`03CQH01DhGCQI>5ThFCQL06dhF00=>5dhFCQH05dhF00]>5`00
CQM>5ThGCQI>5dhFCQM>5ThG00=>5P03CQMoogoo01Aoo`03001oogoo01Qoo`004Woo00H007oo0000
07oo000EOol2000=Ool0:F]KIcY[FfLjJe]W>T9K?SY2FeYFGWMJMW>jKkYc^VnjAQQ1mdHHLaIc=g<F
LcMg]W_GMkH1VP0c00d]fFmjJeY_NV]JNmMg]W^gMkIkegNfJi`00`0002m[W3Gi>QXenB5G8CHQEadf
8ELM=R4g7CHQ=REg9IPUMbEh8ELUN25G;MXY^BgJ;KTjG3IK>U`fFcYLCiiC_TnNDki;^DoJAiICeeoL
HoaOg6=MGcaSGEmLHeeFVEZj009FV@1kDYUFVU:IEYUBN5JIDWUFVDhgDSQ>=e8hCSMB>4hgDSM>5e8h
CQMB=dhGDSM>5dhgCQIB=dhGCSM>5U8gCQI>5dXFCQM>5ThGBQI>5dhFCQM:5ThGCQI>5dXFCQM:5ThG
BQI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThG
BQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM>5ThG
BQI>5`00CQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXF01Ioo`03001oogoo01Qoo`004Woo00<007ooOol0
0Woo00<007ooOol04goo00<007ooOol03Woo00U:NdZKBY]:VdYk8KXn>T9JGWH01Fnj00]5mdHHLaIc
=W<FLcIc5WNgMkIge`0>0080D`05KgY[NV]jJgYk]`02MkH00gNHMkP0000200001GOFIg][NfMkJi/0
0SGi00<Q=R5G8CH01b4f00HUMbEh9GLanRgj<OX5;MT01D/oBci;?T/nBcl00T/n0U?M00U3Ld^EFoYK
nemlHieSOF>MGg`00eJj00=F^EJjEYT01EJI00ABNDhgCSMB>0=>=`03DSM>=dhg00e>=`05CQM>5ThF
CQI>5`03CQH01DhGCQI>5ThFCQL00dhF00E>5dhFCQI>5ThG01m>5P05CQM>5ThFCQI>5`0ACQH03dhG
CQI>5dhFCQM>5ThGCQH004hFCQM>5ThGCQI>5`03CQH014hGCQI>5ThF5Woo00<007ooOol05goo000C
Ool01000Oomoo`005Woo00<007ooOol03goo021:NTZKBWY:Vafj8M/M^W>jKkYc^VnjLkY_^W>j@OMc
=g<FLcMc5W_GMkIkegNf00h0<`1C03=_NV]JKgYg]TjK0`0004ekeWNfNmM_^W>j>QTn>SXJ8ELenB5G
8CHQEb4f8ELM=R4g7CHQ=adf9GPUMbFH;MXanRgI<OXjO3jM>W`nWCYlBcm7?T/oBciCgDnlBkM3Leok
FmYSWEmlHieOO6>ME[YJfUJjF[YFVEJjEYUJ^U:IEYUBVEJJCSMBF4hgDUQ>=e8hCSMB>4hgDSQ>5e8h
CSMB=dhGDSM>5e8g009>5`1TCQI>5dXFCQM>5ThGBQI>5dhFCQM:5ThGCQI>5dXFCQM>5ThGBQI>5dhF
CQM:5ThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWf
CQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dXFCQM>5ThGBQI>5dhF
CQM:5ThGCQI>5dXF001>5ThGBQI>5dXFCQM:5ThGBQI>5dXFCQLFOol2000HOol001Aoo`8001Ioo`<0
015oo`05BW]:VdZKBY/M^P038KX00eOJEWQFN002EWP037<fLaIc=W<FMkMg]WOGMkIg]gNf00h0<`<0
D`<00005MkQcV7OFMkIgeP03KkX01Shj>QXj6SXJ8ELen@8Q=P068ELM=R4f8CHYV2Eh0R4f00<UN2Eg
9GP00S7j00D]nS7j?YdnWCjL008nW@08Dme?_5?MCmY?fd=cEmQCf0=S_@07E]YJfUJjF]YFfU[JE[T0
0eJj00QF^E8hCSMBF4hgDSQ>=e8h0dhg00=B=dhgCSL01Thg0dhF00E>5dhFCQI>5ThG00=>5P05CQM>
5ThFCQI>5`03CQH01DhGCQI>5ThFCQL06dhF00E>5dhFCQI>5ThG00=>5P05CQM>5ThFCQI>5`03CQH0
0dhGCQI>5P07CQH05dhGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhF001>5ThGCQI>5dhFCQL0
0dhF00=>5dhFOol057oo00<007oo000067oo000SOol50005Ool00`00Oomoo`0@Ool06TZKBWY:VdYj
8MXM^UOj:_iJ^E9GEWQBF5IhDUMc=g<FLcMg]P2fFWMNU`HK1S`03TjKBWX20000^TjKBWYg^G>HNmIg
]W>jKkYc^VnJLkY_^Shj>QTn>R4f8ELQ=R5G8CHQ=adf8ELM=RVH9GPYV2Eg9GPUMc7j;MXanRgI<OY?
OTmoBgi?WdmnCgm?^TNEAiAGf5nlHmeS_6>mF]YNneJjF]YF^U[KE[YJfUJIF[Y>=e9HCSMBF4hgDUQ>
=e9HCSMBF4hgDUQ>=e8hCSMB>4hgDSM>5dhgCQI>5dXFCQM>5ThGBQI>5dhFCQM:5ThGCQI>5dXFCQM>
5ThGBQI>5dhFCQM:5ThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9
mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCSM>
5ThGBQI>=dhFCQM:5ThGCQI>5dXFCQM>5ThGBQI>5dhFCQM:5P00BQI>5dXFCQM:5ThgBQI>=dhFCSM:
5QIoo`8001Moo`009Goo00<007ooOol01Goo00<007ooOol04Goo00I:VdYkBY]:Vb/NFYP3FYT4EWP0
2@2E0;D0U@2eFWMNUeigGYMJM`030003BY/017NhLiQgeWNf1fnj00<j6Shj>QX00R4f00<QEb4f8CH0
0R4f00hM=R4f9IPYV2Eh=Q/b6cHK<QY2gT;M@]i2gD;N0Tmo00I?OToJCmY;^5?HEmP3Hkd5F_/01eKJ
F]YF^U[JE]YBF4iG00=BF004CSMB>4hgDUP3CSL01E8hCSM>=dhgDSL00Thg00I>5ThGCQI>5dhFCQL3
CQH01DhGCQI>5ThFCQL00dhF00E>5dhFCQI>5ThG01]>5P05CQM>5ThFCQI>5`03CQH01DhGCQI>5ThF
CQL00dhF00E>5dhFCQI>5ThG00=>5P0JCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhF
CQM>5ThGCQI>5dhFCQL0009>5`03CSM>5dhG009>5`04CQI>5dhGCQLCOol300000goo001oo`0FOol0
02Eoo`03001oogoo00Aoo`8001Ioo`0@F[UJV5ZiEYQJ^EZHEWQBEeIhDUQFN02EGYMJMejGFWH30000
C00?3?H8eDjKBWYg^G>HMkQg]V<kMkIkeg>hMmU2FT9K?SXQEcXJ?SXQ=R5G8CHQEadf8ELM=R4g7CHY
V2Eh:IPUN3Hk<QXf6c8J@]i2gD;N@[e2gT;MDki?WD=cBiE?]UoLHoaOg5[kF]YNne[jF_]JfU[KE[YJ
fTiGDUQ>=e9HCSMBF4hgDUQ>=e9HCSMBF4hgDUQ>=e9H0Thg075>5ThGBQI>=dhFCQM:5ThgCQI>5dXF
CQM>5ThGBQI>5dhFCQM:5ThGCQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXF
CQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWf
CQM:5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5ThGBQI>5dhFCQM:5ThGCQI>5dXFCQM>5ThGBQI>5dhF
CSL004hgCQI>=dXFCSM>5ThgBQI>=dhF00moo`@000Aoo`03001oogoo01Eoo`009Goo00<007ooOol0
17oo00<007ooOol05Woo0eZI00=JV5ZIEWP015Ih00=NUeYg00000P0000EJMejGMiMgU`Hk0088eP06
MkQcV7NHHaYS>gNf0WNg00UgfG>hLmQ2FT9K@UXQER4f?SX00b4f00HQEb4f8CHYV24f7CH29IP02BVH
<QXf6c8K=Q/b6T;N@]e2gP02Ckh02D^gAg=;UF?LGmaSo5lKGaaO6`06F_/7DUP024iGDUQ>=e9HCSMB
>4hgDUP2CSL02ThFCQM>5ThGCQI>5dhFCQM>5ThG0dhF00E>5dhFCQI>5ThG00=>5P03CQM>5ThF01U>
5P05CQM>5ThFCQI>5`03CQH01DhGCQI>5ThFCQL00dhF00E>5dhFCQI>5ThG00=>5P0JCQM>5ThGCQI>
5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5P9>5`06CSM>5dhGCQM>=`00
0ThG00=>=dhGCQL00ThG00=>5ThGOol02goo0`0027oo00<007ooOol05Goo000UOol00`00Oomoo`04
Ool00`00Oomoo`0GOol025ZiFYQJ^EJHF[UBF5IhDYX30000aUYfGYMJMejGMiIkUgNG0108e@cf2=D8
mV<JHc]S6W_GMkIgfG>hMmUc^49K@UY2Fb4f8ELQ=R5G8CHQEadf8ELM=RVi:IPY^BEh:IPUN2VH<QXf
>c8J=Q/b6U>nCkiCg4nk@gAOg6?lGmaO?5/KGcaK6ellFa]O?59HDWUBF59hCUMBF4iHDUQ>Ee9HCSMB
F4hgDUQ>=e9HCSMBF4hgCQM:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5ThGCQI>5dXFCQM>5ThGBQI>
5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>
5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM:5ThgCQI>5dXFCSM>5ThGBQI>
=dhFCQM:5ThgCQI>5dXFCSM>5ThGBQI>5dhFCQM:5ThgCQI>=dXFCSM>5ThgBQI>=dhF001:5ThgCQI>
=dXFCSM>5ThgBQI>=`Qoo`<000aoo`03001oogoo01Aoo`009Goo00<007ooOol00goo0P006Goo00EJ
V5ZIFYUJVEZH00<0009B^P04GWMNUeYgGYL4MiL01`0?1S/8eV<KHaYS>f<J009g]`0;MmUc^7?HLmQg
fG>h@U]2FT9K8CHQEP028EL38CH02B5G8CHY^BVH:KTfG3YL=Ua;?`03Aah01T/oCma?g4NE@g=KfP9K
nP07HgaOG5lLGa]O?5lKDWT00U9h0e9H00=BN59HDUP01U9H01A>EdhGCQI>5dhFCQM>5ThGCQI>5dhF
CQM>5ThGCQI>5dhFCQM>5ThG0dhF00=>5dhFCQH06DhF00E>5dhFCQI>5ThG00=>5P05CQM>5ThFCQI>
5`03CQH08ThGCQI>5ThFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>
5dhFCQM>5ThGCQI>5dhF0ThG00E>=dhGCQM>5dhg00=>5`05CSM>5dhGCQL00004CQL01DhFCQM>5dhG
CQH017oo10003goo00<007ooOol057oo000SOol30006Ool00`00Oomoo`0HOol0AU>N00000000DiiF
^e:JE[]BVUJkFWMNUgNFNiMgUg^GMiIkU`0?Hc]S6V<kHaYS>gNfNmMc^7OIBY]:_4ZKBY`Q=T9K@UXQ
Eb4f8ELQ=R5G8CHQEadf8ELYV2Vi:IPY^CHk>U`fFcYL=S]Cg4nlDma;^4=dFmYKnUmLHgeOG6=mGeaS
OE9hEWUBN5Ii0U9h08UBF59iDUQBF4iGDUQ>F59HCQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThGBQI>=dhF
CQM:5ThgCQI>5dXFCSM>5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWf
CQM:5ThGBOI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dhF
CQM:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5ThgCQI>=dXF
CSM>5ThgBQI>=dhFCSM:5ThgCQI>=dXFCSM>5P00BQI>=dhFCSM:5ThgCQM>=goo00<001=oo`03001o
ogoo01Aoo`009Goo00<007ooOol017oo00<007ooOol05goo0P000Woo0e>N0U:j00AF^e:jGYMNM`Ig
U`0501003f<kHaYS6`02MkL017=iLiUgegOG14ZK00DQ=R5F@UXQEb4f00<QE`<Q=P0D8ELYV2Vi:IPj
G3IL>Ua;OdmoBgi?Od^i@g=KfU_jGeaSO5mLHeaOG09FV@07DWUBN5IiDWQBNE9HDWP01E9H0dhG01A>
5ThGCQM>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThG6dhF00E>5dhFCQI>5ThG00=>5P05
CQM>5ThFCQI>5`03CQH01DhGCQI>5ThFCQL00dhF00=>5dhFCQL00ThG01=>5ThGCQI>5dhFCQM>5ThG
CQI>5dhFCQM>5ThGCQI>5dhFCQM>5P04CQL01DhgCQM>5dhGCSL00dhG00E>=dhGCQM>5dhg00=>5`05
CSM>5dhGCQL00002CQL2CSL014hGCSM>=dhg5Woo00<007ooOol057oo000[Ool2000FOol30005Ool0
:2WJ;OXYfUJkDYYF^e:J@QTmn48I?OQ26Cgh6]/FfRVi00mS>f<JNmMcNG>IKgQgegNgMmM:VdZlBY/Q
Eb4f9ELQ=R5G7CHQEb4f;MXY^BgJ0RVi0:<YV2Vi:IQ?Od]nCim;OT_IBkQCedngHkeSW6NmHiaS_E9i
EYUBNEJIDWUFNE9hEWUBN5IiDUQBN59HDWU>5ThgCQI>=dhFCSM>5ThgCQI>=dXFCSM>5ThgBQI>=dhF
CQM:5ThgCQI>5dXFCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWf
CQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCSM>5ThgBQI>=dhF
CQM:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5ThgBQI>=dhGCSM:5ThgCQM>=dXF
CSM>5ThgBQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThgBQM>>000CSM:5dhhCQM>=dXGCSQ>5`0FOol00`00
Oomoo`0DOol002]oo`03001oogoo019oo`<000Qoo`04;OX]fRgj;MX3KiX023gh?QPmn48I?OQZn6Kh
6]/4:IP00g=iLiUcN@05MmL2BY/01b4f8ELQ=R5G8CHQEb4f008QE`05;MTY^BgI;MTn_@03?Yd03Cjm
?Ye?_TnmDmMSW6>mHieS_F>LE[YF^EJj00AFV@05DWQBNE9hEWUBN002CQL01ThgCQM>5dhGCSM>5P=>
5`0<CQI>5dhGCQM>5ThGCQI>5dhFCQM>5ThG6dhF00E>5dhFCQI>5ThG00=>5P05CQM>5ThFCQI>5`03
CQH01DhGCQI>5ThFCQL00ThF0ThG00E>5ThGCQM>5dhF00=>5`0?CQI>5dhGCQM>5ThGCQI>5dhFCQM>
5ThGCQI>5dhF009>5`07CSM>5dhgCQM>=dhGCSL00dhG00E>=dhGCQM>5dhg00=>5`06CSM>5dhGCQM>
=dhG1Dhg00<004hgCSL00dhg00=>5dhgOol05Goo00<007ooOol057oo000[Ool00`00Oomoo`0?Ool3
000<Ool00bgj:MX]nP04KiX0<Sgh@QTmn6[hI_M[600b6]/YV2Vi:IQcVFmhLiUg]gOGLkIG75Kl8EM:
VbEG8CHQEb4f9ELQ=R5G7CHQEbVi;MXY^BgJ:KTn_CZM?[e?_Dnn@g=Cef?LHoaOg6?lEYUJ^UJIF[X2
EYT0TE9iEYUBNEJIDWQFNDhFCSM>5U8gCQI>=dhFCSM>5ThgCQI>=dhFCSM>5ThgCQI>=dXFCSM>5ThG
BOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM:5ThG
BQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBOI>5dXFCSM:5ThgCQI>=dXFCSM>5Thg
BQI>=dhFCQM:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5ThgCQM>=dXFCSM>5dhgBQI>=dhGCSM:5Thg
CQM>=dXFCSM>5ThgBQI>=dhFCSM:5ThgCQM>=dhGCSQ>5dhgBQM>>000CSM:5dhhCQM>=dXG01Ioo`03
001oogoo01Aoo`00:goo00<007ooOol037oo0`003goo00<]fRgjKiX016nJ00Q26Cgh?QQVn6[hI_QZ
n00b0RVH00=cVG=iLiT00WOG1EKl00@QEdZK8EHQ=PDQE`058CHQEbgI;MTY^@02;MT01DnnCke;fT=c
Ho`00f?L00QJfe[JF]YF^EJjE[UF^UJi15JI00E>=dhGCSM>5dhg00=>5`06CSM>5ThGCQM>=dhF0dhG
00A>5ThGCQI>5a]>5P05CQM>5ThFCQI>5`03CQH01DhGCQI>5ThFCQL00dhF00I>5dhFCQI>5ThGCQH3
CQL01DhFCQM>5dhGCQH00dhG00E>5ThGCQM>5dhF00=>5`05CQI>5dhFCQM>5P02CQL03DhgCQM>=dhG
CSM>5dhgCQM>=dhGCSM>5dhg00=>5`05CSM>5dhGCQM>=`03CQL>CSL01000CSM>=dhG0dhg00=>5goo
Ool04goo00<007ooOol057oo000ZOol2000;Ool3000COol7KiX03d8II_M[66KhJ_QVm`0c039cVFmh
LiUcNGOGMkMgf002E_`0VE;lEa`Q=R5G8CHUEb4f8ELQEREG;OXb6bgjAam2oTLO@_i77d;nCm]3Lf?l
HmaJne[JF_]JfU[kF]YJ^UJIF[YFVEZjCQMB=dhFDSM>5ThgCQIB=dhFCSM>5U8gCQI>=dhFCSM>5Thg
CQI>=dhFCSM>5ThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM:5ThG
BQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThgCQI>=dXFCSM>5Thg
BQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThGBQI>=dhFCQM:5ThgCQM>=dXGCSM>5dhgBQI>=dhGCSM:5Thg
CQM>=dXFCSM>5dhgBQI>=dhGCSM:5P02CSL06DhhCQM>>4hgCSQ>5dhhCQM>>4hGCSQ>5dhgCQM>>4hG
CSM:5`00CQM>=dXGCSQ>5dhg01Ioo`03001oogoo01=oo`00:goo00<007ooOol01Woo0`006Woo00Xf
6SGi=OYVn6[hI_QZn6KhJ_QVn0@0<P9:NP03MmMg]eKl00=Fo0058ELQER5G8CHQEP048EL02c7j<O/]
nTLN@_i77T^jBmY7U5_iFmT00UlK00UJfe[JF]YJfU[KF]YF^UJiDSL01Thg00I>5dhgCQM>=dhGCSL3
CQL01DhgCQI>5dhGCSL05dhF00E>5dhFCQM>5ThG00=>5P05CQM>5ThFCQI>5`03CQH01DhGCQI>5ThF
CQL00dhF00E>5dhFCQM>5dhg00=>5`03CSM>5ThG009>5`05CQI>5dhGCQM>5P03CQL01ThFCQM>5dhG
CQI>5`9>=`0DCQM>=dhgCSM>5dhgCQM>=dhGCSM>5dhgCQM>=dhGCSM>5dhgCQM>=`=>5`03CSQ>=dhg
01=>=`04001>>4hhCSL3CSPEOol00`00Oomoo`0COol002Yoo`03001oo`0000Eoo`8001eoo`0D=OTj
6SGi>QYVn6[hI_M[66KhJ_Q:FDijBUU>NTYIMmQg]gOGMkMG709Fo0068CHUEb4f9GPQEbEG0R5G0:/Q
ES8K;OXb6bgj<Q];OT]o@g=KnUlKGcaO6ellGa]Jne[JF_]JfU[kCQMB=dhgDSM>5e8gCQMB=dhFDSM>
5ThgCQIB=dhFCSM>5U8gBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9
mThGBQI>5dXFCQM>5ThGBQI>5dhFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXFCQM>
5ThgBQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThgBQI>=dhFCSM:5ThgCQI>=dXFCSM>5dhgBQM>>4hGCSM:
5dhgCQM>=dXFCSM>5dhgBQI>=dhGCSM:5ThgCQM>=dXFCSM>5dhhCQM>>4hgCSQ>5dhhCSM>>4hGCSQ>
5dhhCQM>>4hGCSM>5dhhCQM>=dhGCSQ>5diHCSL004hgCSQ>=diHCSL05Goo00<007ooOol04goo000Z
Ool20003Ool3000POol01CGi=QXenCGj=OT00SnM00=FN0SF;eP00dYj00MgegNgMkMSO6MlHg`QE`02
E_`0124f8ELQEREh1B5G14]o00=7UT=cFoT00elK00UO?5lKGa]O6e8gCSMB=dhgDSL00dhg00=B=dhg
CSL00Thg00A>5dhgCQM>=`=>5aY>5P0;CQM>5ThGCQI>5dhFCQM>5ThGCQI>5`03CQH01DhGCQI>5ThF
CQL00dhF14hG00E>=dhGCQM>5dhg00=>5`03CSM>5dhG009>5`05CQI>5dhGCQM>5P03CQL00dhFCSM>
=`05CSL01DhGCSM>=dhgCQL00dhg00U>5dhgCQM>=dhGCSM>5dhgCQL00Thg00E>>4hgCSM>=dhh00=>
=`03CSQ>=dhg00m>=`=>>005001>>4hhCSQ>=`02CSPDOol00`00Oomoo`0COol0021oo`D000Eoo`03
001oo`00008002=oo`0L>QXenCXJ?ga3WE9GEWQBEeIh1=I>NTYIMmQg]fMlHe]WO6=LIg`Q=REG8CHQ
Eb4f9ELQEbEh8EL3=U`0OcHk=U`fG4oM@g=WWF=lHieO6ellGa]O?4hgDUQ>=e8hCSMBF4hgDSM>5e8g
CSMB=dhFDSM>5e8gCQIB=dhFCSM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThG
BOI>5dXFCQM:5ThgCQI>5dXFCQM>5ThGBQI>5dhFCQM:5ThGBQI>5dXFCQM:5ThGBQI>5dXFCSM:5Thg
CQM>=dXFCSM>5ThgBQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThgBQI>=dhFCSQ>5dhhCQM>>4hGCSQ>5dhg
CQM>>4hGCSM:5dhhCQM>=dXGCSM>5dhgBQI>=dhG009>=`0YCUQ>=dhhCSM>>4hgCSQ>=dhhCSM>>4hG
CSQ>=dhhCQM>>4hgCSQ>5dhhCQM>>4hGCSQ>=diHCSM>F4hgCUQ>=diHCSM>F000CUQ>=dhhCSM>F00D
Ool00`00Oomoo`0COol0021oo`05001oogooOol00005Ool2000WOol3?id02EIHEWQFN5IhEUP8mR/h
CWYg]`02IcX01fMlHgaSO6=lIg`QER5G008UV0058CHQEb5g9GPQE`03=U`00d^lBke3L`06Hg`02e9H
DUMBF58gDUQ>=e8gCSMB=dhgDSL01dhg64hF015>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>
5ThG00=>5P04CQM>5ThFCQH2CQL01dhgCQM>=dhGCSM>5dhg00=>5`05CSM>5dhGCQM>=`03CQL00dhg
CQM>5`02CQL@CSL01DhGCSM>=dhgCQL00dhg00Q>5dhhCSQ>>4hgCSQ>=dhh0dhg00E>>4hgCSM>=dhh
00Q>=`=>>003CUQ>>4hh00I>>005CSM>>4hhCSP00003CSP00dhgCSQoo`0BOol00`00Oomoo`0COol0
025oo`03001oogoo00Moo`03001oogoo02Qoo`0EEWQBEeIhDUMFN0CF2?H4eV/jIaU[>VLiJcYSFfMl
He`UEb4f9ELUN2FH008UN01o8ELUN25GCme;_4oMHmaWo6=lHieSO6NMDUQBN4hgDUQ>=e9HCSMBF4hg
DSQ>=e8gCSMB=dhGDSM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWf
CQM:5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5ThGBQI>5dhFCQM:5ThGCQI>5dXFCQM:5ThGBQI>=dhG
CSM:5ThgCQM>=dXFCSM>5ThgBQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThgBQI>>4hgCSQ>5dhhCQM>>4hG
CSQ>5dhgCQM>>4hGCSM:5dhhCQM>=dXGCSM>5dhgBQL00Thg02i>>4hgCUQ>=dhhCSM>F4hgCSQ>=dhh
CSM>>4hgCSQ>=dhhCQM>>4hgCSQ>5diHCSQ>F4hgCUQ>>4iHCSM>F4hgCUQ>=diHCSM>F4hgCUQ>=diH
001>F4hgCSQ>=a=oo`03001oogoo01=oo`008Woo00<007ooOol01goo0P00:Goo00=FN5IHEWP00UIh
00<8eVLjIcX00fLj00=_^REG8EL00V=l00<UEb5F9IP00RFH00PUN3kN?]hngSjn?]iSg6OL0f?L1E9H
00QB=e9HDUMBF4hgDSM>=e8g0dhg6ThF01Q>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThG
CQI>5dhFCQM>5ThgCQL3CSL034hGCSM>5dhgCQM>=dhGCSM>5dhgCQM>=`=>5`05CSM>5dhGCQM>>003
CSL00dhhCSM>=`0>CSL00dhGCSM>=`02CSL3CSP01DhgCSQ>>4hhCSL00dhh00A>=dhhCSM>>0=>=`0=
CSQ>=dhgCSM>>4hgCUQ>>4iHCSQ>F4hhCUP00dhh00=>F4hhCSP01Thh00A>=dhhCSP000=>F003CUUo
ogoo019oo`03001oogoo019oo`008goo00<007ooOol027oo00<007ooOol09Woo021BEeIhDUMFN59G
JcYW6F/jIcU[>VnjLm]_^REG8EHUMb4f9ELUN2FI9GPUV3Zm?]hn_TNDHmaWo59hEYUBN5JI0U9h03UB
EeIhDUQBF4hgDUQ>=e9HCSMBF4hgDSQ9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:
5ThGBOI>5dXFCSM:5ThgCQI>5dXFCSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCQM>5ThGBQH00ThG01I>
=dhGCSQ>5dhgBQM>=dhGCSM:5ThgCQM>=dXFCSM>5dhgBQI>=dhFCSM:5P9>=`0`CSQ>=dhhCSM>>4hg
CSQ>=dhhCQM>>4hgCSQ>5dhhCQM>>4hGCSQ>5dhgCQM>>4hGCUQ>=diHCSM>F4hgCUQ>=diHCSM>F4hg
CSQ>=diHCSM>>4hgCUQ>=dhhCSM>>4hg0Thh01I>F4hhCUQ>>4iHCSQ>F4hhCUQ>>4iHCSM>F4hhCUQ>
=diHCSM>F4hgCUQ>=`9>F007CUU>F000CSQ>FDiHCUT04goo00<007ooOol04Woo000TOol00`00Oomo
o`08Ool00`00Oomoo`0VOol2EWP00c=k=g/gN`03IcX02fnjKmY_^VoJ8ELUEb5G:MXQEbEG9GP00bFH
00E7Gd=dFmQKnEZi009FN003EWUFN5Ih00IBF004DSMBF59GCQLFCQH2CQL01DhFCQM>5dhGCQH00dhG
00m>5ThGCQI>5dhFCQM>5ThGCQI>5dhFCQM>5ThGCQH01Dhg00E>5dhgCSM>=dhG00=>=`08CQM>=dhG
CSM>5dhgCQM>=`=>5`09CSQ>=dhhCSM>>4hgCSQ>=dhh00e>=`07CUQ>>4iHCSQ>F4hhCUP014hh00E>
=dhhCSQ>>4hg00=>>006CSM>>4hgCSQ>=dhh1TiH00Q>>4iHCUQ>F4hhCUQ>>4iH0dhh00=>F4hhCSP0
1Thh00Q>F4iICUQ>FDiHCUU>F0000diH4goo00<007ooOol04Woo000POol01@00Oomoogoo00002goo
00<007ooOol0:Goo0cWi04m_^W?KKkY_fVnj9GLQEREG8EHYfRViAgm3GTMoAei7U5OHF[YF^EZjE[UF
VE9hEYUBN5JIDUQBN59GEWQ:5ThGBOI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>
5dWfCQM:5ThgBQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThGBQI>=dhFCQM:5ThgCQI>5dXFCSM>5P02CQL0
5ThhCQM>=dhGCSQ>5dhgCQM>>4hGCSM:5dhgCQM>=dXFCSM>5dhgBQI>=dhG0Thg01A>F4hgCSQ>=dhh
CSM>>4hgCSQ>=dhhCSM>>4hgCSQ>5dhhCSM>>4hG0Thh02i>F4hgCUQ>>4iHCSM>F4hgCUQ>=diHCSM>
F4hgCUQ>=diHCSM>F4hgCSQ>=diICUQ>FDhhCUU>>4iHCSQ>FDhhCUQ>>4iHCSQ>F4hhCUQ>>4iHCSQ>
F4hhCUQ>=`9>F00?CUU>F4iiCUQ>FDiHCUU>F4iICUQ>F@00CUU>>4iI01=oo`03001oogoo019oo`00
8Goo0`003Goo0P00:Goo1CWi00ac^REgKmY_^REG8ELUEbVi:MXY^RWJ:KT2FmP01EZjF[UJ^EZiF[X0
0eIh00EFNEIhCQI>5ThG00=>5P05CQM>5ThFCQI>5`0@CQH3CQL00dhgCQM>5`02CQL03dhFCQM>5dhG
CQI>5dhFCQM>5ThGCQI>5dhFCQM>5P09CSL01DhGCSM>=dhgCQL00dhg00I>5dhgCQM>=dhGCSL6CSP0
24hgCSQ>>4hhCSM>>4hgCSP3CSL00dhhCSM>=`05CSL00diHCSQ>F002CUP014hhCUQ>>4iH0dhh00=>
F4hhCSP00Thh00Q>=dhhCSQ>FDiHCUU>F4iI0diH00=>FDiHCUP01TiH00Q>>4iHCUQ>F4hhCUQ>>4iH
24iI00Q>F4iICUU>FDiHCUU>F4iI0TiH00@004iICUQ>F19oo`03001oogoo019oo`00<goo00<007oo
Ool09goo058ef3Wi>OUcfVniLmXUEbEh8EHUMb5F9ELU^BWJ@kY7UUlJHc]O6UZjE[UJ^UJiF[YBN5JI
CQI>5dXFCQM>5ThGBQI>5dXFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCQM9mThGBQI>=dXFCSM>5Thg
BQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThgBQI>=dhFCQM:5ThhCSM>>4hgCSQ>=dhhCQM>>09>=`0kCQM>
>4hGCSM>5dhhCQM>=dhGCSM>5dhgBQMBF4hhCUQ>=e9HCSM>F4hgDUQ>=dhhCSM>F4hgCSQ>=dhhCSM>
>4hgCSQ>=dhhCSMBFDhhCUU>>59ICSQ>F4hhDUQ>>4iHCSM>F4hhCUQ>=diHCSM>F4hgCUQ>=`02CUP0
<4iiCUQ>FDiHCUU>F4iICSQ>FDiHCUU>>4iICSQ>F4hhCUU>>4iHCSQ>F4hhCWU>F4iiCUU>NDiHCWU>
F4iiCUQ>NDiHCUU>F4iiCUQ>FDiHCUU>F4iICSQ>F@00CUU>>19oo`03001oogoo019oo`00=7oo00<0
07ooOol09Woo0SWi00Ac^VnjLmY_^P<UM`0<;S`^G2hl;Ud^?6<KGa]S6elKHa]O6eZj0eZi00E>5dhF
CQI>5ThG00=>5P05CQM>5ThFCQI>5`03CQH00dhGCQI>5P04CQH2CSL024hGCSM>5dhgCQM>=dhGCSL4
CQL01DhFCQM>5dhGCQH00dhG00A>=dhhCSQ>>0=>=`03CSQ>=dhg00Y>=`05CQM>=dhgCSM>>003CUP0
14hhCUQ>>4iH24hh00Q>=dhhCSQ>>4hgCSQ>=dhh0diH00=>FDiHCUP01TiH00Q>>4iHCSQ>F4hhCUQ>
>4iH0dhh00=>F4iICUT014iI00I>F4iICUQ>FDiHCUT3CUP00diICUQ>F003CUP3CWT014iICWU>FDii
24iI00]>F4iICUU>FDiHCUU>F4iICUQ>FDiH00=>N@03001>NDii015oo`03001oogoo019oo`00=Goo
00<007ooOol09Woo05]cfVniLmY_^G?J9ELUN2EG9GP^?39MAiE[_6NkHc]O6V<KGaYS>elJCQM:5Thg
CQI>5dXFCQM>5ThGBQI>5dhFCQM9mThGBQI>5dWfCQM:5ThGBOI>5dXFCSM>5dhgCQM>=dhFCSM>5Thg
BQI>=dhFCSM:5ThgCQI>=dXFCSM>5ThgBQIBF4hgCUQ>=e9HCSM>F4hgCSQ>=dhhCSM>>4hgCSQ>5dhh
CQM>=dhGCSQ>5dhgCQMBF@02CUP04DhhDUQ>>4iHCSMBF4hhCUQ>=e9HCSM>F4hgDUQ>=dhhCSL00TiH
055>NDiHDWU>F4iICUQBFDiHCUU>>59ICSQ>FDhhDUQ>>4iHCSQBF4hhCUQ>=diHCSQ>NDiHCWU>FDii
CUQ>NDiHCWU>F4iICUQ>FDiHCUU>F4iICSQ>FDiHCWY>FDijCUU>NTiICWY>FDiiCUU>NTiICWU>F4ii
CUU>NDiHCWU>F4iiCUQ>NDiHCUU>F4ijCWU>NTiICWY>NDijCUT004iICWX04Goo00<007ooOol04Woo
000fOol2000YOol00bViKkYcfP049GL013LoIkaW_6^l0VNl00Y>5dhgCQI>5dhFCQM>5ThGCQI>5`=>
5P05CQM>5ThFCQI>5`03CQH01DhGCQI>5ThFCQL024hg00A>5dhgCQM>=`=>5`03CSM>5dhG009>5`04
CQI>5dhhCUP4CSP014hgCSQ>>4hh0dhg00=>>4hgCSL01dhg1diH00Q>>4iHCUQ>F4hhCUQ>>4iH1Dhh
0TiI00=>NDiICUT00TiI00A>F4iICUU>F@a>F005CSQ>NDiiCWU>F@03CWT8CUT01TiHCUU>F4iICUQ>
F@9>NP04CWU>NTijCWX3CWT00dijCUU>N@02CWT3CUT00diiCUU>F@05CUT7CWX014iiCWY>NDij0dii
00H004iiCWTl8D0Q?24>Ool00`00Oomoo`0AOol003Qoo`03001oogoo02Moo`0U:KTYV3]O=chkGcLn
JkaW^f_LIk]B=dhFCSM>5ThgCQI>=dhFCQM:5ThgCQI>5dXFCQM>5ThGBQI>5dhFCQM9mThGBQI>>4hg
DSP00Thg05=>5dhhCQM>=dhFCSM>5dhgBQI>=dhFCSM:5ThgCQI>=dXFDUQ>>4iHCSQBF4hgCUQ>=e9H
CSM>F4hgDUQ>=dhhCSM>>4hgCSQ>5dhhCSM>>4iHDWU>F4iICUQBFDiHCUU>>59ICSQ>F4hhDUQ>>4iH
CSMBF4hhCUQ>FE9jCUU>NTiHDWU>FDiiCUQBNDiHCWU>F59iCUQ>FDiHDUU>F4iICSQBFDhh009>F@0a
CWY>NDijCUU>NTiICWU>FDijCUU>NDiHCWU>FDiiCUQ>NDiHCWU>F4iICUQ>VTYiCWY>NDijCWU>NTiI
CWY>FDijCUU>NDiICWY>FDiiCUU>NDiICWU>F4iiCWY>VTYjCYX00Tij01I:NDjJCWU>NTiICWY>NDij
CUU>NTiICWY>F@00CUU08S`Q@28l8D0R?2508PYoo`03001oogoo015oo`00>Goo00<007ooOol09Woo
00DYV2Vi:IPY^BVH009W_003Jka>=dhg00=>=`9>5`05CSM>5ThGCQI>5`03CQH01DhGCQI>5ThFCQL0
0ThF0Thh00A>=dhhCSM>>0Q>=`08CQM>=dhgCSM>5dhgCQM>=`=>F003CUU>F4iH00=>F09>>003CUQ>
>4hh009>>004CSM>>4hhCSP3CSL00diiCUU>N@02CUT014iHCUU>F4iI24iH00I>>4iHCSQ>F4hhCWX6
CWT3CUT00diiCUU>F@02CUT014iHCUU>F4iI0TiH1Tij0dii00=>NTiiCWT00Tii00A>FDiiCUU>N@M>
F@U>NP04CWU>NTiiCWX4CWT01DiICWU>NDiiCWX00djJ00A>NTjJCWY>VPQ>NP05CWU>NTiiCWY>N@03
CY/01DjJ001>Vd0R?2800d0R00<l8T0R@280240R00<007ooOol04Goo000jOol00`00Oomoo`0VOol0
BRFH:KUCfeOLDm]BF59GDSM>5U8gCQMB=dhFCSM>5ThgBQI>=dhFCQM:5ThGCQI>5dXFDUU>F59HCSQB
F4hgCUQ>=e9HCSM>>4hgDSQ>5dhgCQM>>4hGCSM>5ThgCQMBNDiHDWU>FE9ICUQBFDiHDUU>>59HCSQ>
F4hgDUQ>=diHCSMBF4hgCUQ>=e9HCWU>NTiIDWX2CWT0PdiHDWU>FDiICUQBNDiHCUU>>59ICUQ>FDhh
DUQ>>4iHCSQBVTiiCWY>NE:JCWU>NTiIDWY>FDiiCUQBNDiICWU>F59iCUQ>NDiHCY]>NTjJCWY>Vdii
CYY>NDjJCWU>NTiICWY>NDijCUU>NTiICWU>FDiiCUU>NDiHCWU>NTjKBWY>VdijCYY:NDjJCWY>VTii
CWY>NDijCWU>NTiICWY>FDijBYY>VdYjCY]:VTjKBWY>VdijCY]:NTjJCWY>VTYjCYY>NDijBWU>VTii
C[]:VTjkBY]>^dZJCY]:VTjK001>Vc`R@28l8T0R?2908S`Q@28l8T0R?2908S`R@28l8T0R00004goo
000kOol2000VOol00eOLDm]Cg002DUP00e9GDUQBF005CSL02DhFCQM>5dhGCQI>5dhFCQM>F@02CWT0
0e9iCUQ>F003CUP3CSP3CSL00dhhCSM>=`04CSL024iiCWY>NDijCUU>NDiICWT2CUT8CUP3CSP01DiH
CSQ>NTijCYX00Tij14ii00Q>FDiiCUU>NDiHCUU>F4iI1TiH00A>NTjJCWY>VP9>NP04CWU>NTiiCWX6
CWT3CUT01DiiCYY>VdjJCY/00TjJ00A>NTjJCWY>VPI>NP=>N@05CWY>VdjKCY]>^`02CY/014jJCY]>
VTjK0TjJ00=>NTjJCWX01Dij00E>NDijCWY>NTii00M>V`05CYY>VdjKCYY>NP03CYX3CWX01djJCWY>
^djKC[]:Vdjk009>V`05BY]>VdjKCY]>VP03CY/00`00CY]08P05@2800c`R@2908P05@2800goo001o
o`0BOol003eoo`03001oogoo02Ioo`0eDUQBEe9HDSMBF4hGDSM>5U8gCQI>=dhFCSM>5ThGBQIB^djJ
DWU>F59iCUUBNDhhDUU>F59HCSMBF4hgCUQ>=e8hCSM>>4hgD[]>VU:KCYYB^diiDWY>NE:JCUUBNDiH
DWU>F59ICUQBF@02CUP0UDhhDUQ>>4jKCYYBVdjJCY]>VU:JCWU>VTiiDWY>NDijCUUBNTiICWU>F59i
CUQ>FDiHDWU>F4jKCYY>VdjJCY]>NTjJCWY>VTijDYY>NDijCWUBVTiICWY>FE9jBY]>^dZKC[]:Vdjk
BYY>VdjJCY]>NTjKCWY>VTijCYY>NDjJCWU>VTZKC[a:VdjlBY]>_4ZKC[]:VdjkBYY>VdjJCY]:VTjK
CWY>VdYjCY]>NTjJBWU>VTijC[a:VdjlBY]>_4ZKC[]:VdjkBYY>VdZJCY]:NTjKBYY>VdYjCY]>NTjK
BY]>_4ZkC[a:VdjlBY]>_4ZKC[a:VdjkBYY>^dZKC[]:NTjKBYY>V`00@28l8D0R?2508S`R@28l8D0R
?2508S`Q@28l8Goo00004goo000nOol00`00Oomoo`0VOol3DUP00e9GCSM>=`03CSL014hGCSM>5ThG
0U:J00E>VU:JDYYBNDiI009>N@E>F009CSM>>4hhCSQ>_4kLC[a>g4jl009>VP05CY]>VTijCWU>NP02
CWT01TiICWU>FDiiCUQ>F@9>F003C[]>_4jk009>^`05CY]>VTjKCYY>V`03CWX00djJCWY>N@04CWT0
0diICWU>F@03C[/01TjKC[]>^djKCYY>V`9>VP09CWY>VTijCYY>NDijCWU>NTii00=>_006B[]>_4jK
C[]>Vdjk0TjK00U>VTjKCYY>VdijCYY>NTjJCWX00TZl00M>g4ZlB[a>^djlB[]>_002C[/3CY/01Djk
CYY>VdjJCY/014jJ00A>NTZlB[a>_0=:_005C[a:VdjkC[]>_008CY/00djJCY]:_005B[`02TZkC[a:
_4jlBY]>^djKC[]:Vdjk0TjK00Y:VdjKCY]:g4ZlB]a:_000B[`l8PLl8@07@28l8D0R?2508Woo0000
4goo000oOol00`00Oomoo`0UOol0158gDUQBEe9H0U8g051>5e8gCQIC7TkmDae>oE<NCYYB^djJD[]>
FE9iCUQBNDiIDUQ>>59ICUQ?7T[mCai:oDlNC[]Bg4jkC]a>VU:kCYYBVdjJDYY>NE9jCWUBNDiIDWU>
F4kMB]a>gD[LC]e>^djlCY]>_4jkCY]>VU:KCYY>VdiiDYY>NDjJB]a>oD[MC_e:g4kLB[a>g4ZkC[a>
VdjkBY]>_4jJCY]>VTjK0TjJ02i>NTjJCWY>VTZlC]e:_4kMB[a>_4ZkC[a:^djkBY]>^dZKC[]:VdjK
BYY>VdjJB]e:_4kMB]a:gDZlC]a:_4kLB[a>_4ZKC[a:VdjlBY]>^dZKC[]:Vd[MA]a:o@9:g@0fA]a>
gDZlC]e:_4kLB[]>_4ZkC]a:VdjlBY]>_4ZKC[a:VTjkBY]>^dZlB]e:_4[MB[a:gDZlC]a:_4kLB[a>
_4ZKC[a:^djlBY]>_4ZKC[a:Vd[MB]a:gDJlB]e:g4[MB[a>gDZl000h0D0Q0c`Q00M08C`Q?24h0C`Q
?04l8@03Ool00`00Oomoo`0@Ool0041oo`8002Ioo`04DUMBF59HDUP5=gd015<MCaeC7Dkm0e:J00I>
VU:JCWUBNDiICWT5?el02DlNB_e?7T/MC]a>_4kLC[a>g003CYX04DjKCWU>NTiiCWY:oT/NB_i;7T[n
C]e>g4kMB]a>gDjkC[`00Tjk00Y>VTjKCYY>VdjJBai6oTLNA_i;7P=:g@06B_e:gDjlC[a>g4Zl0djk
00A>VdjkA_i77P=6oP05B_e:gD[mB]e:o@03B]`00dkMB[]>_002C[`02DZkC[]>VdjkCY]>^d[mB_i6
g@02B_d00d[MB]a:g@02B]d3B[`034kLB[a>_4jkC[a:^djlA_e:oTKMA_i6o@E:g@04B[a:g4ZlB]`3
B[`02DjlB[a:_4KmA_i6oDKnA_e6oP04B]d01D[LB]e:g4[MB]`01TZl00Y>_4ZkC[a:_4[MA]e:gDKM
B]e6g@E:g@06B[a:g4ZlB]a:_0000cP000Ph0CP0?24l0C`Q?04l8C`10goo00<007ooOol047oo0012
Ool00`00Oomoo`0VOol0P48HASU264Hi@QQ6>E8fDai>oE<MC_eB^djJD[]>VQ;G3[LB]`jf4]L>]a:g
?cm3GcmOCai:oDlNB_e>g4jkD]a>^b/m9ad[?R/M:cdo?d<o?cm3?dKmBai:oD/NA_e;7T[LC]e:g4kM
C[]>_4jKC[`o7T<o?ai3?clNBai6oD/NA_i>oD[LC_e:gDkmB]a>g4ZlC]a:^d<o?ai3?clN@cm6oTLN
A_i;7T[MB_e6gD[nB]e:oDZlC]e:_4kM?ai37clN@alo7TLNA_i77T;nAai6gD[nA]e:oT[LB]e:_4kM
B]a:gCkn@alo7T<O?_i77d;nAai2oTLOA]e:oTKMB_h2B]d0@DKLB_e:gD[MB[a>gDZlC]e2oTLO@_i7
7T;nAam6gD[nA]e:oTKMB_e6gD[mA]e:oDZlB]e:_4[MB[a77d;nAai2oTLO@_i6oTKMB_i6gD[mA]e:
oTKMB_e6_4[MB]a:gDJlB]e2oTLN@_i77d;n000h03`1>00l0C@0>00d03P0=00017oo00<007ooOol0
47oo0013Ool00`00Oomoo`0VOol014HHAQU664HH0VoJ1U8g00=FEUYFESH00UIF00=JETHiFUH00eYF
00QBF58gDUQJEEYFFUEFEe8g0UIG00=NEUYEEUH00eIF0d<o00To?eYFFUIJEUIFEWQJEQ[k6]X00Q[K
00`c?c<n<clc?T<o@am3?d<OBai6oTLNA_h79ad013Lo>clg?cLo14<O00A6oTLNA_i6oPH_7P05>alk
?c/O>cm37P03@al014<N@am6oTLN0TKn00I:oD[nA]e:oC/O>cl3>al00c/o@ai37`02@al00d<NA_i6
oP03A_h02dKmB_i6gDKn>alo7c/O?alk7clO@ah00d<O00]2oTKnA_i6oT;nA_i6oDKnA_e6oTKm00Do
7`05@ai37d<N@am37P03A_h01D;nA_i6oTKnA_d00TKn011:gDKMB]e6gD[M@_i37d<N@am2oT<O@_i6
oT;nA_h000<d00Hh00Aoo`03001oogoo011oo`00A7oo00<007ooOol09Goo04E6>D8HASU[fVoKKmYB
=e8fDUMB=U8gKkUJEeHfFUIF=UYGESIJEUXeFUIJEEYFFSEBF5YEGUIJEEifDSIFEe8fGWIJEEiFESIJ
EeHfFUMF=UifESIJEUHeFUIF=UYFESEJEUYEFUIF=EYFEUMJEUXeGUIJEEYgEUIJMeYEGUIJ=EYgEUIJ
MeIFGUH00eYF00EJMeYFFUIJEEif009JEP1]FUENMUIG7_`Jfakl6]/No2lN;cl_7Rlo>alk?c/O>clB
^QKK4[XFfa:j5]/B^RLN8_dW7R;m<clc7S<o<aho?c/O?clk7clo6]`NoAkL7_`Jg1km:ah_7R[n;ah[
7SLo<ahg?c<N?alk7clo>alo7ckn@alnoT<O;ahc?blN<al_7S<o=alk?cLO>clg7clO>alo7c/O?aln
oT<O?_i37ckn<clc7S<O<ahc?c<N>alg7c/o=alo7c/N?alo7SlO>ai37ckn@alnoT<O@_i77T;nAal0
03@0;0000c0000</0300Ool017oo00<007ooOol047oo0015Ool2000VOol00dHHKmY_fP03KmX3DSL0
0g>iLmYc^@02EUH00eYFESI_F@06FUH01EYEFUIJEEiFFUD00eIG00AJEEiEGUENEP=FEP03GUINEEiE
009JEP03EUIJEUiE00MJEP06FUEJEUYEFUIJEEYG0eYE15YF00=NEUYEFUD015YF00=JEEYFFUH02UYF
00=JMeYEFUH00eYF00AJMeYFGUIJE@9JEP05FWIJEUYFFUEJMP03FUH01EYfFUIJEUYFFWH00eYF00MJ
MeYFFUIJEUYgFUIJM`0:Ool55]/29_d01bLM8_d_7blN;al_7RlO00HB^P<No0037_dNo2/N00@[7P8c
7`05<ahc7c/O>alg7`02>al01RKm8_dVoB;m9_dRo@<_7P0;:ah_7S<O=alc7cLO000T0200900P0007
Ool00`00Oomoo`0@Ool004Moo`03001oogoo02=oo`16JmY_ffoJKmY[fVoKDSIB=e8fLmY_^G?JESIJ
EeHfKeU_F7=IFUEJEUXeFUIZmeiFFUENMUYEGUIJEEIGFUENEUYEGWIJEEYGESIJEeYEGWIJEEYFESIJ
EUYEGWIJEEYFESEJEUYEGWIJ=EiFFUEJEUXeGUIJEEiFFSENEUYEGUIFEUiFFUENEUYEFWL2FUH0<5YE
GUIJEEYFFUENMUYFGUIJEEifFUENEUYEGWIJEEiFFUENMUYEGUIJEUifFUENEUYEGWMJEUYgFUENMUYE
GWIJEUigFUINEUYFGWIJEUifFUINMUYFGWIJEEifFUIJMcYoo`0;1WP:V@Ih2YT6N1KK4[XFf`005]/8
0008Ool00`00Oomoo`0@Ool004Qoo`03001oogoo02Ioo`0;8IU_fVoJDSMcfW>iLmUc^EYFESIFEP03
KeT3FUH02F[hJaQZn5iFFUEJEUYEGUIJE@02GUD01EiFFUENEEiEEUH00eiE00ANEUIFFUIJEP=NE@=J
EP=NE@05FUEJEUYEFUINE@02FUD01EYFFUEJEEYEGUH00eYE00MNEUYFFUIJEUiEFUENE@03FUH00eiE
FUENE@04FUH01EYEFUIJEUYFFUD00UYF015NEUYEFUIJEEiFFUEJEUYEGUIJEEiFFUIJMUYFGUEJEEiF
00=JEP05FWIJEEYFFUINEP02FUI3Ool00`00Oomoo`08Ool00`00Oomoo`0@Ool004Uoo`03001oogoo
02Eoo`188GPUVB5h9IUSffOl0?EcfVniFUI_F7=IKeQ_FEXeFUIJEF/HJ_M[65YEGUIJEEifI]MZeeYE
GWIJEEiFFUENMUYEGWIJEEifFUENMUHeGWIJEEifFUEJEUYEFUIJEEifGUEJEUXeGUINEEifFUENEUYE
GUIJ=EifFUENEUYEGUIJEEiFFUINEUYEGUIJEEif0UYF02QJEEiFFUENEUYEGWIJEEiFFUENMUYEGUIJ
EEiFFUENEUYEGWIJEEiFFUENMUYEGUIJEEifFUINEUYEGWIJEEifFUINMUYEGUIJEEifFUINMTEoo`03
001oogoo00Qoo`03001oogoo00moo`00BWoo0P009Woo00PQV6OlHm]Wo6OKIoaSf`4E1VmI00QJEV/H
J_Q[66[hFUIJEEiF0fKG00INEUYEGUENEEiFI[H2GUD00eiFGUENE@07GUD00eYFGUENE@02GUD00eYE
FUIJE@03GUD3FUD01EYFGUENEEYEGUH00eYE00]NEEYEGUEJEEiEFUEJEUYEGUEJEEiE00=JEP=NE@0L
FUEJEUYFGUEJEEiEFUENEUYEFUINEEiFFUENEUYEGUIJEEiEFUENEUYEGUEJEUYfFUINEEYEGUH3FUI6
Ool00`00Oomoo`07Ool00`00Oomoo`0?Ool004aoo`03001oogoo02=oo`1`IoaSffOlCUQBFDiHDUPe
]cWH=KQ_FFmHLeU_F6/HJ_M[66[gJaQJEEifFUEZefKGJ]QVeeiFFUENMV:fI[MR]UifFUENMUYEI[MJ
EEifFUENMUYEGWIJEEifGUENMUYEGWIJEEifFUENMUiEGUIJ=EiFGUENMUiEGUIJEEiFFUENMUYEGUIJ
EEiFFUENEUYEGUIJEEiFFUENEUYEGUIJEEiFFUENEUYEGWIJEEiFFUENMUYEGUIJEEiFFUENEUYEGWIJ
EEiEFUENMUYEGUIJEEifFUINEUYEGWIJEEifFUE7Ool00`00Oomoo`07Ool00`00Oomoo`0?Ool004eo
o`03001oogoo02Eoo`05DUQ>F4iHCUQBF003=MP02WOHMkQgf7NhJaQZn6/HJ_Q[65YE1FKG00=NEEiF
FUD00fJg0eiE00=V]f:FH[H015iE00=RUUiEGUD02EiE00=JEEYFGUD00eiE0eYE0eiE00=JEEiEFUD0
0eiE00EJEEiEFUENEEYE00=NE@05FUENEEiEFUIJE@03GUD00eYEFUIJE@03GUD00eYEGUIJE@03GUD0
35YEGUEJEEiFFUENEEYEGUIJEEiEFUENETQoo`03001oogoo00Ioo`03001oogoo00moo`00CWoo00<0
07ooOol09Goo06]BF4iHDUU>F3WH=KMgf7>gMmQc]gOHCSM[66[gJaQZmf[GI]MZf6KGJ]MVef[HFUEV
]f:fI]MR]UifFUENMV:FI[MRUUifFUENMV:FI[MRUUifFUENMUiEHYIJEEifGUENMUYEGWIJEEifGUEN
MUiEGUIJEEiFGUENMUiEGUIJEEiFGUENMUiEGUIJEEiFFUENMEYEGUIJEEiFFUENEUYEGUIJEEiFFUEN
EUYEGUIJEEiEFUENMUYEGUIJEEifFUENEUYEGWIJEEiEFUENMUYEGUIJEEif04Yoo`03001oogoo00Eo
o`03001oogoo00moo`00Cgoo0P009Goo00=>F59HCUP00TiH00Dif7NhMmQ>g5;L009>g0EB=`IVe`=V
]`08I[IV]fJgGUIRUV:fHYIV]`=NE@=RUPANE@9RUP]NE@03GUINEEiE009NE@04FUENEEYEGWD2GUD0
0eYEGUEJE@02GUD00eieFUENE@06GUD00eYEGUENE@06GUD00eiFGUENE@02GUD00eYEGUIJE@03GUD0
15YEGUEJEEiFC7oo00<007ooOol017oo00<007ooOol03goo001AOol00`00Oomoo`0SOol054iHDUQ>
F59ICUQBNDiHDWU>g5;lC]aBEdhgDSM>=WMgMeIZefKGJ]P300004VKGH[IV]f:fI]MRUVJgHYIV]f:F
I[MJEFJgHYIRUf:FGWINE@9NMP9RUP0kGWIJEEifGUERUUiEGWINEEifGUENMUiEGWINEEifGUENMUYE
GWINEEieGUENEUYEGUINEEifGUENEUYEGUINEEieGUENEUYEGUIJEEifFUENEEYEGUIJEEiEFUENMUYE
GUEJEEifFUENEUYEGWIJEEiFFUENMP1=Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool0059oo`03001o
ogoo02Eoo`05CUQ>FDiHDUU>F002C]`00e;LC]aB=`02DSL01WMFMgMgEgMg7EQJEP800004I[IV]fJg
I[L2Em`016:FI[MRUV:f1V:F0UiE16:F0eiE0f:F15iE00=NMUiEGUD015iE00ENMEiEGUENEEie00=N
E@03GWENEEiE009NE@05FUENEEiEGWEJE@0EGUD00eYEGUIJE@1>Ool00`00Oomoo`04Ool00`00Oomo
o`0>Ool005=oo`03001oogoo02Eoo`0FCUQBNDiHDWU>F5;mC]aBo4hfDUMgEWMgLeIgMgMFGWIJEEif
FUH006:fFo`3Em`036JgHYIV]f:FIkeRUV:GHYIV]f:FHYMJE@=RUP9NMP04GUENMUifHYH2GWH09UiE
GWINMV:FGWENMUiEGWINEF:FGUENMEiEGWINEEieGUENMUiEGWENEEifFUENMEiEGWINEEiFFUENEUiE
GWENEEiFFUENEEYEGWH2GUD02eYEGWIJEEiEFUENMUYEGUEJEEifFUD0D7oo00<007ooOol00goo00<0
07ooOol03Woo001DOol2000UOol03E9ICUQ>FDiHIm`QN2EhC]aBg58gMgMgEgMg008cE@03FUINMUYF
009JEP04LcIc5T7g@OL2Em`01F:fIiaW_6NLIk`02f:F00ENEF:FHYIRMV:F00=NE@03HYIRMV:F00=N
E@05HYINMV9fGUENM@02GUD00eifGWENE@02GUD01EieGUENEEiEGWD01eiE00ENMEiEGUENEEie00eN
EE5oo`03001oogoo00=oo`03001oogoo00ioo`00EWoo00<007ooOol08goo02IBNFNkJmaW_6OL8GPU
V25hMgMcET>FF[UNfC=E=eIJEUifFUEg=W<FMcIc5T7hGWERMV>LIkeSW6NlHiaV]f:FHYMRUV]KIeYR
UUif0f:F00YNMV:FGWIRUUifHYINEF:FGWERUP9NMP07GUENMUieHYINMEifGUD00Uie015RUUieGWEN
EEifGUERMUiEGWINEEieGUENMUYEGWENEEif009NE@07FUENMUiEGWENEEifFUD00UiE00INMUiEGUEJ
EEifFUECOol00`00Oomoo`02Ool00`00Oomoo`0>Ool005Moo`03001oogoo029oo`9Wg005IkaWg6OL
9IPQN0029GP01UjiF[UJ^EZiG[TcE@9JEP03GWIc5W<f009c=P0:GWERMF9eHWENMFNlIiaW_6NLHYH4
Ie/4HYH00fLJHYIRMP03HYH02F9fHYIRMV:FGWIRUV9fGUENMP02HWH02F:FGUENEEiEHWINMV9fGUEN
M@02GUD00eifHWINE@02GUD01EieGUENEEiEGWD01eiE00ENMEiEGUENEEie00ENEEEoo`05001oogoo
Ool0000@Ool005Qoo`03001oogoo02Eoo`0nJmaW_2FH?gE__6^KG]UJ^EkIF[TgEEYEGWIc5WLfLaIg
=P00HWINEF9fGWERMVkeLaI>5U8gIeY[FfMJIe]WFV]KHYIW>V<IIcYW6F:FGWIRUUifI_UNMF:FGWIR
UUieHYINMF:FGWERUUieHYINEF:FGWERUUieGWINE@9NM@0KHYINMEieGUENMUiEHWINEEifGUENMEiE
GWINEEieGUENMUiEGWEJEEifGUENMEiEGWIJEEiE05Ioo`04001oogoo000@Ool005Uoo`8002Eoo`08
8KTQ^R6jJk][Vf^kF[UN^@=J^@0><eEJEW<fLcH007NgMkP0069eGWERMG;fLaI^m@9B=P9RM@AWF`=W
6P05IaUW6V:FHYIRMP03I_T01EifHYIRMV:FH]P00V9f00=RUUifHWH00V9f00ANMV9fGWIRMP9NE@07
GWIRMUieHWINEEieGUD00Uif00ARMUiEGUENE@9NM@9NE@05GWENEEiEGUENM@03GUD00eieGUENE@1G
Ool01000Oomoo`0047oo001KOol00`00Oomoo`0SOol0@b6IKka[Vf^kJi]__4iHCUU>>59I>MQg=W<F
>OTif7NhLkL005ieHWINEG<FK_Ec5VkeDSMRMFJEHWEVUFkEL_IF=FLjIaUW>V<IIcYNMVKiH_QW6F;h
HYINMF:FH]QVn6;HHYINMF:FGWEVf6:gHYINMF:FGWERUUiEHYINMF9fGWENMUiE009NM@0CHWINMEie
GUENMUieHWINMEifGUENMEiEHWINEEieGUENMUiEGWD0FGoo00<007oo000047oo001LOol00`00Oomo
o`0ROol00f^kJi]>NP02CWX014iiCUQ>F4iI0TiH00Dif3Wh>MQg^7Ng009_fP9RM@05LaI^mG;fL_Ic
5P05HWD2K_D00fkfESIW6P02IaX01FLII_UVnFKiH_T00VKi00IRUV;HH]QRf6KHGWH2HWH05V;HH[QR
f5ifHWINMV9fGWIRMUieHWINMV9fGWENEEifHWINMEifGUENMEiE0Uif00URMUiEGUENEF9fGWENMUiE
GWD00UiEFgoo00<007oo00003goo001MOol00`00Oomoo`0TOol0BDijBWU>NTYIDUU>F4iICSPinCWH
MkQc]fojKmU_nP00HWI^mG<FK_Ec5U>cEkARMFJEHWEVUFkEL_I^eEYFESEVUF9dIYERM6LIH_QVnF;h
IaURf6KhH]QVnF;HI_QNMFKHH[MVf6:gI]QNMF:FGWERf6:gHWINMF:FGWERMUieHWINMF9fGWERMUiE
HWINMF9f009NM@08GUENMUieHWINEEifGUENMEeoo`8000moo`00GWoo00<007ooOol097oo0dij0diH
00A>FDiH>MQg]`E_fP07K_EbmW;fLaI^mENdDk@00f9e00=^mFkfK]D00Vke00EVUF9eIWEVMFJE009^
e@@[>P03H]QVf6;H00=Rf008H[QRf6;HH]QR^69fGWIRMP9R]`07GWIRMUieHWIR]f9fGWD00Uif00IR
MUieGWINMV9fGWD2GWH2GWD00eifGWERMP03GUEMOol2000?Ool005moo`8002Eoo`09CWY:NDijCSQB
FDiHCUTn>T8j008n>P15GYLa^6oIKoY^mG<FK_EFEe9GEkAC/fJEHWEbmVkEL_I^eG;fHWAVUF9dIYER
M6kEJ]ENMUYEIYERM2]JH]QVn6;HCkm;WVKHH[MVf6:gI]QR]f:FH[MR^6:gH]QNMF9fGWER^6:GHWIN
MF9fGWER]eieHWINMF9fGWERMUieHWINEF9fGWERMUiE05ioo`8000moo`00HGoo00<007ooOol097oo
1EZi0chj00=NUf:gGYL00Rfh1EIG0WMF00=RMFkfK]D00Vke00I^mV_gIWEVMFJEHWD3K]D02EYEGUEV
MFJEIWAVUDnNCki;WP02Cih00f;HH[QRf002H]P3H[L016:hH[MRMUif0f:g00MNMV9fGWER]f:GH[MN
M@02GWH0269fHYMNMUieHWINMEifGWEKOol4000AOol0069oo`03001oogoo02Aoo`0<FYUJ^EJIF[UJ
VChjGYMR^5jGH[P]Uc6h0UIG019BEeIhMeEkEWMEJoE^eG;fK]EbmV_GKoQ[efJEHWAVUF[EK_H2K]D0
:F9dIYERM6JEJ[E^eUiEHWENEDnoH[MVf6:gFiiKOE^NH[MRf6:gH[QR]f:hHYMR]ejGH[QNMF:gGYIR
]ejGHWINMF9fGYIR]ejFHWINMF9fGUD0F7oo10005Goo001SOol00`00Oomoo`0SOol5F[T025jGH[MN
Uf:gGYMR]bfH;KP3EUL2MeH01V_EJmA[eFkeK_I^e@9[m`03JoQRMFIe00E^e@06IYEVM6JEIWE^eF[E
0UiE00UNMGooOomKOU^NFgeKWU]nH[P00V:g00=OG5mMGe`01F:g00IRUf:gHYMR]f:GHWH4HYL00eie
GWINM@1EOol4000IOol006Aoo`8002Aoo`0MFgiGGE]nEeeKOUjGH[QNUf:hGYLa^2fGEWQFEg]FMeE[
mF_DJoEWe7;fK]DYMeieKoQ[efJEHWA^mP02K]D02V[EMmURM6JEHWAVUF[EK]ENEF9e1Goo01]KWU]m
FiiKOEmMGeaSGEmLGeeNUf:hHYMS>elKH[MNUf:gGYIR]ejFH[MNUV:gGYIRMUiEHWH0DGoo10007Goo
001VOol00`00Oomoo`0SOol01UMnFgiGGF:gGYMR]`<00003<KP]V5IG009gEP08JmAW_6NlJmE[e2Ug
HWIRUP9RMP03JoM^eFkE009^e@06LmUcf7?HIWEVUF[E0VkE00=NMEiEOol02Goo00iOGEmLGeaOG5mM
H[MS>elkHc]O6f:gHYMR]ekj1V:G00=RMWooOol0C7oo10008Goo001WOol00`00Oomoo`0SOol012XL
;S`Z72hl0VLj0P00010Y^BgJMeEkEVNlJmaW^f_LIk`0]EieHYINMF:FLaAg=@9^e@0;J]E^mW?HMmUc
^6JEHWA^eFZeK]IZe@0<Ool04emMGeaSGEmLHc]O6f<lGa]S>ejFH[MNnV<KG_YR]ejFH[MNUV:g04ao
o`<002Eoo`00J7oo00<007ooOol08goo00<Z?2hlIcX00VLj00D55`Cg000Y^BgI009W_006CSMB=dhg
DSL0M6:F0f9f00=g=GLEMcD00VkE0g?H00=cfFIdIYD00VkE00=ZeFkEOol04Goo00EO6f<kGc]S>ekj
00=S6PARUdUoo`@002Qoo`00JGoo0P0097oo0fLj01m[>VLj2AL4mekJF[UN^FoFDSM>5U8gCQIB=`2D
HYINMGLeMaEg=G<DOomcf7OILkQgfG?HMmUZ]FkFJ]E^e@0GOol01PIfG_YS6ekjHa]NUTMoo`@002ao
o`00Jgoo00<007ooOol08goo0fLj15Zi0Vog00U_ee8gCSMB=dhg07ARMV:FMaD00gLe1goo00A^eF[E
K]E^eAUoo`03G_YS6V<J04Aoo`@0031oo`00K7oo00<007ooOol08goo01=:gDJlB]eJ^EjiF[UcmfoG
KoM>5U8gCQIB=dhF0;Eg5GLeLaAg=@09Ool00fkEJ[Eoo`1LOol4000dOol006eoo`03001oogoo029o
o`03A[a:_DJl009J^@03KoMoogoo009_m`05CSMB=dhgDSL0M003McD00gLEOomoo`07Ool2K]EIOol4
000hOol006ioo`8002=oo`03A[a:gDJl071oo`<003aoo`00L7oo00<007ooOol08Woo00<007ooOol0
JWoo1000?goo001aOol00`00Oomoo`0QOol00`00Oomoo`1VOol40013Ool0079oo`03001oogoo021o
o`03001oogoo069oo`@004Moo`00Lgoo0P0087oo00<007ooOol0GWoo1000Bgoo001eOol00`00Oomo
o`0MOol00`00Oomoo`1JOol4001?Ool007Ioo`03001oogoo01aoo`03001oogoo05Moo`<005=oo`00
Mgoo00<007ooOol06goo00<007ooOol0Dgoo1000EWoo001hOol2000KOol00`00Oomoo`1?Ool4001J
Ool007Yoo`03001oogoo01Qoo`03001oogoo04]oo`@005ioo`00Ngoo00<007ooOol05goo00<007oo
Ool0Agoo1000HWoo001lOol00`00Oomoo`0FOol00`00Oomoo`13Ool4001VOol007eoo`8001Ioo`03
001oogoo041oo`<006Yoo`00Ogoo00<007ooOol04goo00<007ooOol0?7oo1000KGoo0020Ool00`00
Oomoo`0BOol00`00Oomoo`0hOol4001aOol0085oo`03001oogoo015oo`03001oogoo03Aoo`@007Eo
o`00PWoo0P0047oo00<007ooOol0<Goo1000NGoo0024Ool00`00Oomoo`0=Ool00`00Oomoo`0]Ool4
001mOol008Eoo`03001oogoo00aoo`03001oogoo02Yoo`<0085oo`00QWoo00<007ooOol02goo00<0
07ooOol09Woo1000Q7oo0027Ool2000;Ool00`00Oomoo`0ROol40028Ool008Uoo`03001oogoo00Qo
o`03001oogoo01ioo`@008aoo`00RWoo00<007ooOol01goo00<007ooOol06Woo1000T7oo002;Ool0
0`00Oomoo`06Ool00`00Oomoo`0FOol4002DOol008aoo`8000Ioo`03001oogoo01=oo`<009Qoo`00
SWoo00<007ooOol00goo00<007ooOol03goo1000Vgoo002?Ool00`00Oomoo`02Ool00`00Oomoo`0;
Ool4002OOol0091oo`05001oogooOol00009Ool4002SOol0095oo`800003Ool007oo00Aoo`@00:Mo
o`00Tgoo0P0000=oo`0000000P00Zgoo002DOol2002_Ool00001\
\>"],
  ImageRangeCache->{{{0, 324.625}, {231, 0}} -> {-0.150424, 0.0141804, \
0.00445478, 0.00445478}}]
}, Open  ]],

Cell[TextData["\[EmptySquare]"], "Text",
  TextAlignment->Right,
  TextJustification->0],

Cell["\<\
Actually, the family of solutions of the characteristic \
differential equations can be represented in a parametric form by\
\>", "Text",\

  Evaluatable->False,
  CellTags->"characteristic differential equations"],

Cell[BoxData[
    \(TraditionalForm\`x\  = \ x(s, r), \ \ \ t = \ t(s, r), \ \ \ 
    u\  = \ u(s, r), \)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " is the parameter along a characteristic curve and ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " is the parameter identifying a characteristic curve equal to a certain \
constant on a characteristic. The essential point of these considerations is \
that the solution of a first-order partial differential equation is \
represented by a family of surfaces ",
  Cell[BoxData[
      \(TraditionalForm\`u - \[CapitalTheta](x, t) = \(const . \)\)]]
}], "Text",
  Evaluatable->False,
  CellTags->{"characteristic curve", "family of surfaces"}],

Cell[TextData[{
  "Now, if ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, t, \[CapitalTheta]) = 0\)]],
  " defines a surface satisfying the first-order partial differential \
equation, then this surface is an invariant of the one-parameter Lie group \
transformation. This is obvious from the condition"
}], "Text",
  Evaluatable->False,
  CellTags->"one-parameter Lie group transformation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(v\&\[RightVector]\),
              "TraditionalForm"], \(F(x, t, \[CapitalTheta])\)}], " ", "=", 
          " ", "0"}], ","}], TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\)]],
  " is the vector field of the transformation given by "
}], "Text",
  Evaluatable->False,
  CellTags->"vector field"],

Cell[BoxData[
    \(TraditionalForm
    \`v\&\[RightVector]\  = \ 
      \[Xi]\_1\ \[PartialD]\_x\ \(+\ \[Xi]\_2\)\ 
        \[PartialD]\_t\ \(+\ \[Phi]\_1\)\ \[PartialD]\_\[CapitalTheta] . \)], 
  "NumberedEquation"],

Cell[TextData[{
  "The result is that the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`\(v\&\[RightVector]\ \)\)]],
  " applied on the surface ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, t, \[CapitalTheta])\)]],
  " delivers  the determining equation for the surface. These facts are \
summarized in the following theorem."
}], "Text",
  Evaluatable->False,
  CellTags->"determining equation of a surface"],

Cell["Theorem: Invariance condition", "Theorem",
  CellTags->"Theorem: Invariance condition"],

Cell[TextData[{
  "The function ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, t, \[CapitalTheta])\)]],
  " is an invariant of a one-parameter Lie group transformation if the \
condition"
}], "Text",
  Evaluatable->False,
  CellTags->{"one-parameter Lie group transformation", "invariant"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(v\&\[RightVector]\),
            "TraditionalForm"], "F"}], " ", "=", " ", "0"}], 
      TraditionalForm]], "NumberedEquation",
  Evaluatable->False],

Cell[TextData["is satisfied.\[ThickSpace]\[EmptyCircle]"], "Text"],

Cell["\<\
This condition always results into a first-order partial \
differential equation independent of the number of dependent and independent \
variables. The equation is solvable by applying the method of \
characteristics. We demonstrate the application of the theorem by an example.\
\
\>", "Text",
  Evaluatable->False,
  CellTags->"method of characteristics"],

Cell["Example 2", "Example"],

Cell["\<\
Let us apply the theorem for a subgroup of the heat equation. The \
symmetry we will examine is connected with the scaling symmetry\
\>", "Text",
  Evaluatable->False,
  CellTags->{"heat equation", "scaling symmetry"}],

Cell[BoxData[
    \(\(xi[1]\)[x, t, u] = x; \n\(xi[2]\)[x, t, u] = 2\ t; \n
    \(phi[1]\)[x, t, u] = c\ u; \)], "Input",
  PageWidth->Infinity],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " is an arbitrary parameter. The invariance condition (5.44) now reads"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(invar = 
      \(xi[1]\)[x, t, u]\ \[PartialD]\_x F[x, t, u] + \n\t\t
          \(xi[2]\)[x, t, u]\ \[PartialD]\_t F[x, t, u] + \n\t\t
          \(phi[1]\)[x, t, u]\ \[PartialD]\_u F[x, t, u] == 0; 
    invar // \ LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(2\ t\ F\_t + c\ u\ F\_u + x\ F\_x == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The solution of this PDE follows by", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solh = DSolve[invar, F[x, t, u], {x, t, u}]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{F[x, t, u] \[Rule] \(C[1]\)[t\/x\^2, u\ x\^\(-c\)]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing the general solution of the first-order partial differential \
equation. The arbitrary function ",
  StyleBox["C[1]", "MmaText",
    FontSlant->"Italic"],
  " depends on two invariants given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(I\_1\),
            "TraditionalForm"], "=", " ", 
          FormBox[\(t/x\^2\),
            "TraditionalForm"]}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(I\_2\),
            "TraditionalForm"], "=", \(u/x\^c\)}], TraditionalForm]]],
  ". These two invariants allow the reduction of the heat equation to an \
ordinary differential equation. The reduction procedure itself is based on \
the following theorem."
}], "Text",
  Evaluatable->False,
  CellTags->{"invariants", "reduction procedure"}],

Cell["Theorem: Invariant representation", "Theorem",
  CellTags->"Theorem: Invariant Representation"],

Cell[TextData[{
  "Let the equation ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " be invariant under a one-parameter group \[GothicCapitalG] and let the \
infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`i = 1, 2, \[Ellipsis], p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 1, 2, \[Ellipsis], q\)]],
  ", be non-vanishing functions on the solution surface ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " of the equation. Then, the surface ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " can be represented by equations of the form"
}], "Text",
  Evaluatable->False,
  CellTags->{"invariant", "infinitesimals"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[CapitalPhi]\_k\)(\(I\_1\)(x, u), \[Ellipsis], \ I\_\(p - 1\))\ \  = 
      \ 0\ , \ \ \ \ \ \ \ \ \ k\  = 1, 2, \[Ellipsis], q, \)], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`I\_1\)]],
  ", \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`I\_\(p - 1\)\)]],
  " define a basis of invariants of the group \[GothicCapitalG].\[ThickSpace]\
\[EmptyCircle]"
}], "Text",
  Evaluatable->False,
  CellTags->"invariants of a group"],

Cell["\<\
The use of the invariants allows us to reduce the original \
equation. Let us demonstrate the reduction process by the example of the heat \
equation. The left-hand side of the equation of motion reads\
\>", "Text",
  Evaluatable->False,
  CellTags->{"reduction process", "heat equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(heat = {\[PartialD]\_t u[x, t] - \[PartialD]\_{x, 2}u[x, t]}; 
    heat // LTF\ \)\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The two integrals obtained by integrating the characteristic equation are \
",
  Cell[BoxData[
      \(TraditionalForm\`I\_1\)]],
  " = ",
  StyleBox["t",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\(/ x\)\^2\)]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(I\_2\),
            "TraditionalForm"], "=", \(u/x\^c\)}], TraditionalForm]]],
  ". The first integral combines the independent variables in a unique \
variable called the similarity variable ",
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta] = t/x\^2\)]],
  ". The second invariant, ",
  Cell[BoxData[
      \(TraditionalForm\`I\_2\)]],
  ", combines the dependent variable and one independent variable to the \
similarity representation of the solution ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(u(x, t) = x\^c\),
            "TraditionalForm"], " ", \(F(\[Zeta])\)}], TraditionalForm]]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`F(\[Zeta]) = I\_2\)]],
  ". These two relations allow us to define the following rules:"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "characteristic equation", "similarity variable", 
    "similarity representation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rules = {t \[Rule] \[Zeta]\ x\^2, 
        u \[Rule] Function[{x, t}, x\^c\ F[t\/x\^2]]}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({t \[Rule] x\^2\ \[Zeta], u \[Rule] Function[{x, t}, x\^c\ F[t\/x\^2]]}
      \)], "Output"]
}, Open  ]],

Cell["Applying these two rules to the heat equation, we get", "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(rheat = heat /. rules; rheat // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
              \(\(-\((\(-1\) + c)\)\)\ c\ F\ x\^\(\(-2\) + c\)\), "+", 
                \(x\^\(\(-2\) + c\)\ F\_\[Zeta]\), "+", 
                \(4\ c\ x\^\(\(-2\) + c\)\ \[Zeta]\ F\_\[Zeta]\), "-", 
                RowBox[{\(x\^c\), " ", 
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox[\(\(6\ \[Zeta]\ F\_\[Zeta]\)\/x\^2\),
                        ScriptLevel->0], "+", 
                      
                      StyleBox[
                        \(\(4\ \[Zeta]\^2\ F\_\(\[Zeta], \[Zeta]\)\)\/x\^2\),
                        ScriptLevel->0]}], ")"}]}]}], "\n", "\t", "==", 
              "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "representing an ordinary differential equation for ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " depending only on \[Zeta]. The common factor ",
  Cell[BoxData[
      \(TraditionalForm\`x\^\(c - 2\)\)]],
  " can be eliminated by division:"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(rheat = Expand[rheat\/x\^\(c - 2\)]; rheat // LTF\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(c\ F - c\^2\ F + F\_\[Zeta] - 6\ \[Zeta]\ F\_\[Zeta] + 
                4\ c\ \[Zeta]\ F\_\[Zeta] - 
                4\ \[Zeta]\^2\ F\_\(\[Zeta], \[Zeta]\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Thus, we reduced the original PDE to an ODE by utilizing the invariants of \
the group. The merit of this reduction is that the derived ODE is easier to \
solve than the original PDE. Another advantage is that we can use the \
solution procedures discussed in S",
  ButtonBox["ection 4.4,",
    ButtonData:>{"symmet2.nb", 
      "Analysis of Ordinary Differential Equations"},
    ButtonStyle->"Hyperlink"],
  " allowing us to solve the reduced equation. However, in the present case, \
we utilize the capabilities of ",
  StyleBox["DSolve[]", "MmaText"],
  ". The solution of the ODE follows by"
}], "Text",
  Evaluatable->False,
  CellTags->{"reduced a PDE to an ODE", "invariants of a group", "DSolve[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sheat = 
      DSolve[rheat\[LeftDoubleBracket]1\[RightDoubleBracket] == 0, F, \[Zeta]]
        \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{F \[Rule] 
          \((C[1]\ Hypergeometric1F1[1\/2 - c\/2, 3\/2, \(-\(1\/\(4\ #1\)\)\)]
                    \ \((1\/#1)\)\^\(1\/2 - c\/2\) + 
                C[2]\ Hypergeometric1F1[\(-\(c\/2\)\), 1\/2, 
                    \(-\(1\/\(4\ #1\)\)\)]\ \((1\/#1)\)\^\(\(-c\)/2\)&)\)}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The resulting solution is a combination of special functions containing \
the group parameter ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ". Since we started from a second-order ordinary differential equation, we \
end up with a solution containing two constants of integration ",
  StyleBox["C[1]", "MmaText",
    FontSlant->"Italic"],
  " and ",
  StyleBox["C[2]", "MmaText",
    FontSlant->"Italic"],
  ". The two solutions are graphically shown in the following figure. The \
different curves represent different values of the group parameter ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->{"special functions", "group parameter"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[Table[
            F[\[Zeta]] /. sheat\[LeftDoubleBracket]1, 1\[RightDoubleBracket], 
            \n\t\t\t{c, \(-2.1\), 2.1,  .5}] /. {C[1] \[Rule] 1, 
            C[2] \[Rule] 0}], \n\t{\[Zeta], 0.01, 2}, \t
      AxesLabel \[Rule] {"\<\[Zeta]\>", "\<F\>"}, \n\t
      PlotStyle \[Rule] Table[Hue[i\/10], {i, 1, 8}]]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0832909 0.155681 [
[.2619 .07079 -9 -9 ]
[.2619 .07079 9 0 ]
[.5 .07079 -3 -9 ]
[.5 .07079 3 0 ]
[.7381 .07079 -9 -9 ]
[.7381 .07079 9 0 ]
[.97619 .07079 -3 -9 ]
[.97619 .07079 3 0 ]
[1.025 .08329 0 -7.5 ]
[1.025 .08329 10 7.5 ]
[.01131 .00545 -24 -4.5 ]
[.01131 .00545 0 4.5 ]
[.01131 .16113 -18 -4.5 ]
[.01131 .16113 0 4.5 ]
[.01131 .23897 -6 -4.5 ]
[.01131 .23897 0 4.5 ]
[.01131 .31681 -18 -4.5 ]
[.01131 .31681 0 4.5 ]
[.01131 .39465 -6 -4.5 ]
[.01131 .39465 0 4.5 ]
[.01131 .47249 -18 -4.5 ]
[.01131 .47249 0 4.5 ]
[.01131 .55033 -6 -4.5 ]
[.01131 .55033 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2619 .08329 m
.2619 .08954 L
s
[(0.5)] .2619 .07079 0 1 Mshowa
.5 .08329 m
.5 .08954 L
s
[(1)] .5 .07079 0 1 Mshowa
.7381 .08329 m
.7381 .08954 L
s
[(1.5)] .7381 .07079 0 1 Mshowa
.97619 .08329 m
.97619 .08954 L
s
[(2)] .97619 .07079 0 1 Mshowa
.125 Mabswid
.07143 .08329 m
.07143 .08704 L
s
.11905 .08329 m
.11905 .08704 L
s
.16667 .08329 m
.16667 .08704 L
s
.21429 .08329 m
.21429 .08704 L
s
.30952 .08329 m
.30952 .08704 L
s
.35714 .08329 m
.35714 .08704 L
s
.40476 .08329 m
.40476 .08704 L
s
.45238 .08329 m
.45238 .08704 L
s
.54762 .08329 m
.54762 .08704 L
s
.59524 .08329 m
.59524 .08704 L
s
.64286 .08329 m
.64286 .08704 L
s
.69048 .08329 m
.69048 .08704 L
s
.78571 .08329 m
.78571 .08704 L
s
.83333 .08329 m
.83333 .08704 L
s
.88095 .08329 m
.88095 .08704 L
s
.92857 .08329 m
.92857 .08704 L
s
.25 Mabswid
0 .08329 m
1 .08329 L
s
gsave
1.025 .08329 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .00545 m
.03006 .00545 L
s
[(-0.5)] .01131 .00545 1 0 Mshowa
.02381 .16113 m
.03006 .16113 L
s
[(0.5)] .01131 .16113 1 0 Mshowa
.02381 .23897 m
.03006 .23897 L
s
[(1)] .01131 .23897 1 0 Mshowa
.02381 .31681 m
.03006 .31681 L
s
[(1.5)] .01131 .31681 1 0 Mshowa
.02381 .39465 m
.03006 .39465 L
s
[(2)] .01131 .39465 1 0 Mshowa
.02381 .47249 m
.03006 .47249 L
s
[(2.5)] .01131 .47249 1 0 Mshowa
.02381 .55033 m
.03006 .55033 L
s
[(3)] .01131 .55033 1 0 Mshowa
.125 Mabswid
.02381 .02102 m
.02756 .02102 L
s
.02381 .03659 m
.02756 .03659 L
s
.02381 .05215 m
.02756 .05215 L
s
.02381 .06772 m
.02756 .06772 L
s
.02381 .09886 m
.02756 .09886 L
s
.02381 .11443 m
.02756 .11443 L
s
.02381 .13 m
.02756 .13 L
s
.02381 .14556 m
.02756 .14556 L
s
.02381 .1767 m
.02756 .1767 L
s
.02381 .19227 m
.02756 .19227 L
s
.02381 .20784 m
.02756 .20784 L
s
.02381 .2234 m
.02756 .2234 L
s
.02381 .25454 m
.02756 .25454 L
s
.02381 .27011 m
.02756 .27011 L
s
.02381 .28568 m
.02756 .28568 L
s
.02381 .30124 m
.02756 .30124 L
s
.02381 .33238 m
.02756 .33238 L
s
.02381 .34795 m
.02756 .34795 L
s
.02381 .36352 m
.02756 .36352 L
s
.02381 .37908 m
.02756 .37908 L
s
.02381 .41022 m
.02756 .41022 L
s
.02381 .42579 m
.02756 .42579 L
s
.02381 .44136 m
.02756 .44136 L
s
.02381 .45692 m
.02756 .45692 L
s
.02381 .48806 m
.02756 .48806 L
s
.02381 .50363 m
.02756 .50363 L
s
.02381 .5192 m
.02756 .5192 L
s
.02381 .53476 m
.02756 .53476 L
s
.02381 .5659 m
.02756 .5659 L
s
.02381 .58147 m
.02756 .58147 L
s
.02381 .59704 m
.02756 .59704 L
s
.02381 .6126 m
.02756 .6126 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .6 0 r
.5 Mabswid
.02857 .02175 m
.03081 .01937 L
.03203 .01792 L
.0332 .01655 L
.03428 .01544 L
.03545 .01472 L
.03652 .01483 L
.0375 .01589 L
.03867 .01864 L
.03976 .02294 L
.04096 .02976 L
.04225 .03964 L
.04488 .06754 L
.04729 .10074 L
.05752 .27519 L
.06701 .41723 L
.07199 .4731 L
.07729 .51898 L
.08032 .53953 L
.08317 .55556 L
.08577 .56761 L
.08851 .57801 L
.09094 .58546 L
.09362 .59189 L
.09605 .59632 L
.09832 .59938 L
.0997 .60077 L
.101 .60178 L
.10217 .60247 L
.10345 .60297 L
.1041 .60315 L
.10483 .60327 L
.10559 .60332 L
.1063 .6033 L
.10757 .60312 L
.10828 .60293 L
.10894 .60271 L
.11021 .60215 L
.11141 .60148 L
.11365 .59986 L
.11869 .59477 L
.12777 .58181 L
.14836 .54321 L
.18664 .46756 L
.22735 .40006 L
.26656 .34931 L
.30426 .31108 L
.34439 .27894 L
.38302 .25426 L
.42409 .23304 L
Mistroke
.46366 .21633 L
.50171 .20292 L
.5422 .1909 L
.58119 .18107 L
.62262 .17214 L
.66253 .16473 L
.70094 .1585 L
.74179 .15268 L
.78114 .14775 L
.81897 .14352 L
.85924 .1395 L
.89801 .13603 L
.93922 .13271 L
.97619 .13001 L
Mfstroke
.8 1 0 r
.02857 .2738 m
.03081 .27832 L
.0332 .28387 L
.03526 .28969 L
.0375 .29778 L
.04014 .31043 L
.04262 .32568 L
.04729 .3608 L
.05667 .43706 L
.06165 .47146 L
.06701 .50098 L
.06987 .51351 L
.07248 .52315 L
.07759 .53745 L
.08034 .5429 L
.0818 .54522 L
.08335 .54731 L
.08483 .54895 L
.08618 .55015 L
.08754 .5511 L
.08881 .55178 L
.08998 .55222 L
.09126 .55252 L
.09191 .5526 L
.0926 .55264 L
.09385 .55258 L
.09509 .55237 L
.09627 .55205 L
.09733 .55165 L
.09848 .55112 L
.10111 .54952 L
.10391 .54731 L
.10894 .54226 L
.12831 .51481 L
.1465 .48463 L
.18499 .42363 L
.22593 .37047 L
.26535 .33021 L
.30327 .29943 L
.34363 .27311 L
.38248 .25252 L
.42377 .23452 L
.46355 .22008 L
.50183 .20831 L
.54254 .1976 L
.58175 .18872 L
.61944 .18125 L
.65958 .17427 L
.69821 .16833 L
.73928 .16273 L
Mistroke
.77884 .15792 L
.8169 .15375 L
.85739 .14975 L
.89638 .14626 L
.9378 .14289 L
.97619 .14005 L
Mfstroke
.2 1 0 r
.02857 .39126 m
.04729 .44021 L
.05682 .4692 L
.05956 .4757 L
.06216 .48093 L
.06451 .48491 L
.06701 .48835 L
.0696 .49112 L
.07198 .49301 L
.07331 .49381 L
.07455 .49439 L
.07591 .49487 L
.07667 .49506 L
.07737 .49519 L
.0786 .49533 L
.07974 .49534 L
.08099 .49525 L
.08169 .49515 L
.08232 .49502 L
.08348 .49473 L
.08474 .49432 L
.08702 .49332 L
.08967 .49183 L
.09257 .48981 L
.09844 .48475 L
.10894 .47341 L
.14916 .42191 L
.18787 .37682 L
.22903 .33804 L
.26867 .3083 L
.30681 .28511 L
.34739 .26489 L
.38646 .24874 L
.42402 .2356 L
.46402 .22364 L
.50252 .21372 L
.54345 .20456 L
.58288 .19684 L
.6208 .19026 L
.66115 .18402 L
.7 .17865 L
.74129 .17352 L
.78108 .16907 L
.81935 .16516 L
.86007 .16137 L
.89927 .15803 L
.93697 .15507 L
.97619 .15223 L
s
0 1 .4 r
.02857 .40875 m
.0375 .41607 L
.04729 .42562 L
.05222 .42962 L
.05498 .43133 L
.0575 .43252 L
.05864 .43294 L
.05984 .4333 L
.06047 .43346 L
.06117 .43361 L
.06239 .43381 L
.06354 .43392 L
.06478 .43397 L
.06594 .43394 L
.06701 .43386 L
.06771 .43378 L
.06837 .43368 L
.06959 .43345 L
.07091 .43313 L
.07234 .4327 L
.07729 .43065 L
.08313 .42729 L
.08851 .42351 L
.10894 .40585 L
.14823 .36955 L
.18601 .33921 L
.22623 .31277 L
.26495 .29202 L
.3061 .27387 L
.34575 .25931 L
.38388 .2474 L
.42446 .23652 L
.46353 .22743 L
.50109 .21975 L
.5411 .21251 L
.57959 .20629 L
.62052 .20037 L
.65995 .19524 L
.69787 .19076 L
.73823 .1864 L
.77708 .18256 L
.81837 .17882 L
.85815 .1755 L
.89642 .17254 L
.93714 .16962 L
.97619 .167 L
s
0 1 1 r
.02857 .37034 m
.0332 .37068 L
.0375 .37102 L
.03993 .3712 L
.04223 .37134 L
.0435 .3714 L
.04422 .37142 L
.04488 .37143 L
.04605 .37145 L
.04729 .37143 L
.0485 .3714 L
.04962 .37134 L
.05091 .37124 L
.05213 .37112 L
.0543 .37082 L
.05667 .37039 L
.06204 .36902 L
.06701 .36729 L
.08731 .35728 L
.10894 .34448 L
.15031 .32092 L
.19018 .30176 L
.22854 .28647 L
.26933 .2729 L
.30862 .26189 L
.34641 .25279 L
.38663 .24438 L
.42534 .23728 L
.4665 .23062 L
.50614 .2249 L
.54428 .21994 L
.58486 .21517 L
.62393 .21099 L
.66149 .2073 L
.70149 .20368 L
.73999 .20047 L
.78092 .1973 L
.82035 .19446 L
.85827 .19192 L
.89862 .18938 L
.93747 .18708 L
.97619 .18493 L
s
0 .4 1 r
.02857 .31049 m
.0375 .30936 L
.04729 .30787 L
.0575 .30581 L
.06701 .30347 L
.10894 .29136 L
.14774 .28083 L
.18897 .27132 L
.2287 .26361 L
.26693 .25725 L
.30759 .25139 L
.34674 .24646 L
.38439 .24224 L
.42447 .23821 L
.46305 .23472 L
.50407 .23135 L
.54358 .22838 L
.58158 .22576 L
.62203 .22317 L
.66096 .22087 L
.70233 .21858 L
.7422 .21653 L
.78056 .21468 L
.82136 .21282 L
.86065 .21114 L
.89843 .20961 L
.93865 .20806 L
.97619 .20668 L
s
.2 0 1 r
.02857 .2501 m
.06701 .24866 L
.10894 .24687 L
.14831 .24536 L
.18618 .2441 L
.22648 .24294 L
.26528 .24195 L
.30652 .24102 L
.34625 .24022 L
.38447 .23953 L
.42513 .23885 L
.46429 .23825 L
.50193 .23771 L
.54202 .23718 L
.5806 .23671 L
.62162 .23623 L
.66113 .2358 L
.69913 .23541 L
.73957 .23501 L
.77851 .23465 L
.81988 .23429 L
.85975 .23395 L
.8981 .23365 L
.9389 .23333 L
.97619 .23306 L
s
.8 0 1 r
.02857 .19901 m
.06701 .20452 L
.10894 .21049 L
.14831 .21552 L
.18618 .21982 L
.22648 .22392 L
.26528 .22749 L
.30652 .23094 L
.34625 .23399 L
.38447 .23671 L
.42513 .23942 L
.46429 .24186 L
.50193 .24407 L
.54202 .24631 L
.5806 .24835 L
.62162 .25041 L
.66113 .25231 L
.69913 .25406 L
.73957 .25584 L
.77851 .25749 L
.81988 .25918 L
.85975 .26075 L
.8981 .26221 L
.9389 .26371 L
.97619 .26504 L
s
1 .6 0 r
.02857 .16004 m
.06701 .17047 L
.10894 .1813 L
.14831 .19059 L
.18618 .19879 L
.22648 .20686 L
.26528 .21409 L
.30652 .22129 L
.34625 .22783 L
.38447 .23381 L
.42513 .23986 L
.46429 .24544 L
.50193 .2506 L
.54202 .25588 L
.5806 .26079 L
.62162 .26583 L
.66113 .27054 L
.69913 .27493 L
.73957 .27947 L
.77851 .28373 L
.81988 .28813 L
.85975 .29227 L
.8981 .29616 L
.9389 .30021 L
.97619 .30382 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X0000gQ000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`002Goo10001Goo0P001Goo1000ogooC7oo0008Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`3oOom3Ool000Qoo`03001o
ogoo009oo`03001oogoo00eoo`03001oogoo00=oo`03001oogoo0?mood=oo`001P000Woo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol00goo0`00ogoo@goo0008Ool00`00Oomoo`02Ool00`00
Oomoo`09Ool40006Ool00`00Oomoo`3oOom3Ool000Qoo`03001oogoo009oo`03001oogoo00Uoo`03
001oogoo00Moo`03001oogoo0?mood=oo`0027oo00<007ooOol00Woo00<007ooOol02Goo00<007oo
Ool01goo00<007ooOol00Wi0ogoo@Goo0009Ool4000<Ool50005Ool01P00Oomn@7i0Oomn@?mood1o
o`008goo00<007i0Ool00Woo00=n@7ooOol0ogoo?Woo000SOol00`00Oomoo`02Ool00gi0Oomoo`3o
OolnOol002=oo`03001oogoo009oo`03OT1oogoo0?moocioo`008goo00<007ooOol00Woo00=n@7oo
Ool0ogoo?Woo000SOol20004Ool00gi0Oomoo`0gOol40005Ool20005Ool4000mOol5000mOol50004
Ool20005Ool4000lOol5000MOol002=oo`03001oogoo00=oo`03OT1oogoo03Ioo`03001oogoo009o
o`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo03aoo`03001oogoo03moo`03001o
ogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo03Uoo`05001oogooOol0000MOol002=oo`03
001oogoo00=oo`03OT1oogoo03Ioo`03001oogoo009oo`03001oogoo00eoo`03001oogoo03aoo`03
001oogoo03moo`03001oogoo00moo`03001oogoo03Yoo`03001oogoo01ioo`008goo00<007ooOol0
0goo00=n@7ooOol0=Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol0?7oo00<007ooOol0
?goo00<007ooOol03goo00<007ooOol0>goo00<007ooOol07Goo000SOol00`00Oomoo`03Ool00gi0
Oomoo`0fOol00`00Oomoo`02Ool00`00Oomoo`09Ool4000oOol00`00Oomoo`0oOol00`00Oomoo`0;
Ool4000oOol00`00Oomoo`0LOol002=oo`8000Aoo`03OT1oogoo03Ioo`03001oogoo009oo`03001o
ogoo00Uoo`03001oogoo041oo`03001oogoo03moo`03001oogoo00]oo`03001oogoo045oo`03001o
ogoo01]oo`008goo00<007ooOol017oo00=n@7ooOol0=Goo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol0?Woo0`00?goo0`003Goo00<007ooOol0?Goo00D007ooOomoo`0001eoo`008goo00<0
07ooOol017oo00=n@7ooOol0=Woo100037oo1@00?Woo00<007ooOol0?goo00<007ooOol02goo1@00
?7oo0`007Woo000SOol00`00Oomoo`04Ool00gi0Oomoo`3oOollOol002=oo`03001oogoo00Aoo`03
OT1oogoo0?moocaoo`008goo0P001Goo00=n@7ooOol0ogoo<7oo100027oo000SOol00`00Oomoo`04
Ool00gi0Oomoo`3oOol_Ool00`00Oomoo`02Ool00`00Oomoo`05Ool002=oo`03001oogoo00Aoo`03
OT1oogoo0?mooc5oo`<000Qoo`008goo00<007ooOol017oo00=n@7ooOol0ogoo<7oo00<007ooOol0
2Goo000SOol00`00Oomoo`04Ool00gi0Oomoo`3oOol`Ool00`00Oomoo`09Ool001aoo`h00003OT00
00000?l002H000Yoo`03001oogoo00Uoo`008goo00<007ooOol017oo00=n@7ooOol01Goo00<007oo
Ool02goo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol02goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol02goo00<007ooOol037oo00<007ooOol037oo00<007oo
Ool037oo00<007ooOol02goo00<007ooOol037oo00<007ooOol037oo00<007ooOol02goo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol02goo00<007ooOol04Goo00<007oo
Ool027oo000SOol00`00Oomoo`04Ool00gi0Oomoo`10Ool00`00Oomoo`16Ool00`00Oomoo`17Ool0
0`00Oomoo`16Ool00`00Oomoo`0BOol30007Ool002=oo`03001oogoo00Aoo`03OT1oogoo0?mooc5o
o`80009oo`03001oogoo00Aoo`008goo00<007ooOol017oo00=n@7ooOol0ogoo<goo0`001Woo000S
Ool20005Ool00gi0Oomoo`3oOollOol002=oo`03001oogoo00Aoo`03OT1oogoo0?moocaoo`008goo
00<007ooOol017oo00=n@7ooOol0ogoo?7oo000SOol00`00Oomoo`04Ool00gi0Oomoo`3oOollOol0
02=oo`8000Eoo`03OT1oogoo0?moocaoo`008goo00<007ooOol017oo00=n@7ooOol0ogoo?7oo000S
Ool00`00Oomoo`04Ool00gi0Oomoo`3oOollOol002=oo`03001oogoo00Aoo`03OT1oogoo0?moocao
o`008goo00<007ooOol017oo00=n@7ooOol0ogoo?7oo000SOol20006Ool00gi0Oomoo`3oOolGOol6
OT0NOol002=oo`03001oogoo00Eoo`03OT1oogoo0?moo`]oo`an@2Aoo`008goo00<007ooOol01Goo
00=n@7ooOol0oWoo37i0<7oo000SOol00`00Oomoo`05Ool00gi0Oomoo`3bOol<OT0HOol6In0NOol0
02=oo`03001oogoo00Eoo`03OT1oogoo0>Uoo`Un@1Qoo`aWh2Aoo`008goo0P001Woo00=n@7ooOol0
hgoo1Wi05Goo36OP<7oo000SOol00`00Oomoo`05Ool00gi0Oomoo`3JOol9OT0AOol:In0lOol000Uo
o`@000Eoo`8000Eoo`@000Ioo`03001oogoo00Eoo`03OT1oogoo0=1oo`Yn@1Aoo`IWh29oo`HGh1io
o`0027oo00<007ooOol00Woo00<007ooOol00Woo0P0017oo00<007ooOol00Woo00<007ooOol00goo
00<007ooOol01Goo00=n@7ooOol0bWoo1Wi05Goo2FOP77oo31OP97oo0008Ool00`00Oomoo`02Ool0
0`00Oomoo`0=Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00gi0Oomoo`34Ool6OT0?Ool<In0IOol<
5n0`Ool000Qoo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00=oo`03001n@7i000Eoo`03
OT1oogoo0;ioo`In@0]oo`YWh1Uoo``Gh3aoo`0027oo00<007ooOol00Woo00<007ooOol02Goo1000
1Woo00<007ooOol017i000=oogi0Ool0^Goo1Wi02goo1VOP5goo31OPB7oo0008Ool00`00Oomoo`02
Ool00`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`04Ool4OT2bOol6OT0;Ool6In0DOol95n0T
OolB0n`NOol000Qoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Eo
o`03OT1oogoo00En@:Moo`In@0]oo`IWh1Aoo`HGh25oo``3k31oo`002Goo100037oo1@001Goo00<0
07ooOol01Goo00=n@7ooOol01Goo17i0Wgoo17i02goo1VOP47oo2QOP6goo30?/?7oo000SOol20006
Ool00gi0Oomoo`09Ool4OT2GOol4OT09Ool6In0=Ool95n0HOol=0na8Ool002=oo`03001oogoo00Eo
o`03OT1oogoo00eoo`An@8moo`An@0Moo`IWh0eoo`HGh1Qoo`T3k5Eoo`008goo00<007ooOol01Goo
00=n@7ooOol04Goo17i0Qgoo17i01Goo1VOP37oo1aOP67oo1P?/>Woo1P?o7Woo000SOol00`00Oomo
o`06Ool00gi0Oomoo`0DOol4OT1oOol4OT04Ool5In0<Ool65n0EOol:0n`dOol<0olTOol002=oo`80
00Moo`03OT1oogoo01Qoo`En@7Ioo`An@0Aoo`AWh0]oo`HGh0moo``3k2IooaP3oc1oo`008goo00<0
07ooOol01Woo00=n@7ooOol07Goo1Wi0KGoo0gi017oo16OP2Goo1QOP37oo2@?/9Woo30?oB7oo000S
Ool00`00Oomoo`06Ool00gi0Oomoo`0SOol6OT1TOol3OT03Ool4In08Ool55n0<Ool60n`ROol=0omD
Ool002=oo`03001T7f@O00AT7`9oo`03OT1oogoo02Uoo`An@5eoo`=n@09oo`AWh0Ioo`HGh0]oo`H3
k1aoo``3of5oo`008goo00<007ooOol017oo2V@O:7oo17i0EWoo0gi000=oofOPIn000VOP17oo1QOP
2goo1P?/5Woo30?oKGoo000SOol20007Ool00gi0Oomoo`05Ool6I1lVOol5OT1>Ool3OT04In04Ool4
5n0;Ool60n`@Ool<0om9OolB0IlNOol002=oo`03001oogoo00Ioo`03OT1oogoo00]oo`IT7bEoo`In
@4Eoo`=n@0=Wh0Aoo`@Gh0Uoo`H3k0eoo`T3oceooaP1Wc1oo`008goo00<007ooOol01Woo00=n@7oo
Ool04Goo1V@O9Goo1Wi0?7oo0gi00fOP0goo11OP1Woo1`?/3Goo1P?o;Woo606OB7oo000SOol00`00
Oomoo`06Ool00gi0Oomoo`0GOol9I1lROol6OT0cOol3OT03In02Ool45n04Ool60n`;Ool90olXOol<
0ImPOol002=oo`03001oogoo00Ioo`03OT1oogoo021oo`eT7a]oo`Mn@2Yoo`9n@0=Wh003OolGh1OP
008Gh09oo`H3k0Qoo`T3oaQooaT1Wfaoo`008goo0P001goo00=n@7ooOol0;Goo36@O5Woo1Wi08Woo
0Wi00VOP11OP1P?/27oo1P?o57oo3@6OQGoo000SOol00`00Oomoo`06Ool00gi0Oomoo`0iOol<I1l@
Ool6OT0IOol3OT0016OP5n0Gh1OP10?/1Goo2@?o3Woo306OTWoo000IOol50005Ool00`00Oomoo`06
Ool00gi0Oomoo`15Ool=I1l9Ool6OT0AOol2OT000fOP5n0Gh0030n`:0ol;Ool<0InNOol001]oo`03
001oogoo00Eoo`03001oogoo00Ioo`03OT1oogoo059oo`aT7`=oo`In@0Uoo`9n@0035n03k0?o00D3
o`Uoo``1WeEoocLD7aioo`006goo00<007ooOol01Goo00<007ooOol01Woo00=n@7ooOol0GWoo2F@O
1Wi000=oogi00ol010?o0goo306O37ooEA@OEGoo000KOol00`00Oomoo`05Ool30006Ool00gi0Oomo
o`1BOolH51l3I1l6OT03I1lI51nZOol001]oo`03001oogoo00Eoo`03001oogoo00Ioo`03OT1oogoo
025ooc4D7`aoo``1W`030ol3k6OP00Ioo`In@1ET7j]oo`006goo00<007ooOol01Goo00<007ooOol0
1goo00=n@7ooOol01goo6A@O=Goo206O17oo1@?o00<3k1OPIn003goo2Gi037oo36@OWgoo000IOol3
0007Ool00`0051lD7`0A51m8Ool60Il6Ool60ol30n`00aOPIn1n@00JOol9OT0?OolII1n6Ool001]o
o`03001oogoo00Eoo`03001oogoo00Moo`03OT1oogoo04Qoo`L1W`Moo`D3o`9oo`@3k0045n1Wh6OP
OT0UOol6OT0ROol<I1mjOol002=oo`8000Qoo`03OT1oogoo049oo`H1W`Yoo`@3o`=oo`@3k003OolG
h1OP009Wh003OT1oogoo02]oo`In@2QooaQT7f9oo`008goo00<007ooOol01goo00=n@7ooOol0?7oo
1P6O37oo10?o0goo10?/0Woo0aOP0VOP0Wi0=7oo1Wi0>Woo6F@OBGoo000SOol00`00Oomoo`07Ool0
0gi0Oomoo`0fOol60Il>Ool40ol5Ool20n`4Ool25n000gooIn1Wh002OT0lOol:OT19OolII1l`Ool0
02=oo`03001oogoo00Moo`03OT1oogoo031oo`H1Wa1oo`@3o`Moo`83k0=oo`<Gh005OomWh6OPOomn
@018Ool9OT1IOolBI1lNOol002=oo`03001oogoo00Moo`03OT1oogoo02Yoo`H1Wa9oo`@3o`Qoo`<3
k0=oo`8Gh09oo`9Wh003Oomn@7i0059oo`In@8=oo`008goo0P0027oo00=n@7ooOol097oo1P6O57oo
10?o2Woo0P?/17oo0QOP0Woo0VOP00=oogi0OT00FWoo2Gi0NWoo000SOol00`00In1oo`07Ool00gi0
Oomoo`0POol40IlHOol20ol;Ool30n`4Ool25n02Ool2In000gooOT1n@01UOol<OT1^Ool002=oo`03
001oofOP00Moo`03OT1oogoo01aoo`@1WaUoo`<3o`]oo`83k0Eoo`8Gh0=oo`04In1oogooOT1cOol9
OT1UOol002=oo`04001oogooIn06Ool00gi0Oomoo`0HOol40IlJOol30ol<Ool20n`5Ool25n03Ool2
In02Ool00gi0Oomoo`1kOol6OT1OOol002=oo`800003OomWh7oo00Eoo`03OT1oogoo01Aoo`@1Waao
o`83o`aoo`<3k0Eoo`8Gh0Aoo`05In1oogooOomn@024Ool:OT1EOol002=oo`05001oogooOomWh005
Ool00gi0Oomoo`0@Ool40IlMOol30ol<Ool20n`6Ool25n05Ool00fOPOomoo`02OT2?Ool<OT19Ool0
02=oo`05001oogooOomWh005Ool00gi0Oomoo`0<Ool40IlNOol30ol=Ool20n`7Ool00aOPOomoo`03
Ool2In02Ool00gi0Oomoo`2KOol9OT10Ool002=oo`05001oogooOomWh005Ool00gi0Oomoo`09Ool3
0IlOOol30ol>Ool20n`7Ool25n05Ool01FOPOomoogooOT00Ygoo1Wi0>Woo000SOol01@00Oomoogoo
In001Goo00=n@7ooOol01Goo106O7goo0`?o3goo0P?/1goo0QOP1Goo0VOP0goo00=n@7ooOol0[7oo
2Wi0<7oo000SOol20002Ool00fOPOomoo`04Ool017i0Oomoogoo0`6O8Goo0P?o4Goo00<3k7ooOol0
1Woo00<Gh7ooOol017oo00=Wh7ooOol00Woo00=n@7ooOol0]goo37i097oo000SOol00`00Oomoo`02
Ool00fOPOomoo`03Ool017i00Il1W`6O8Woo0P?o4Goo0P?/1goo0QOP1Woo00AWh7ooOomoo`9n@<Io
o`In@1ioo`002Goo1@0017oo0P001Goo10001Woo00<007ooOol00Woo00=Wh06O0Il0106O8goo0P?o
4Goo0P?/27oo00<Gh7ooOol017oo0VOP0goo00=n@7ooOol0jWoo000;Ool00`00Oomoo`04Ool20004
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`000Il1W`030Il5Ool00gi0Oomoo`0OOol20olAOol2
0n`9Ool00aOPOomoo`04Ool00fOPOomoo`02Ool00gi0Oomoo`3[Ool000]oo`03001oogoo00moo`03
001oogoo00=oo`03001oogoo009oo`03In1oogoo00=oo`03OT1oogoo01eoo`83oa9oo`030naoogoo
00Moo`8Gh0Ioo`03In1oogoo009oo`03OT1oogoo0>aoo`002goo00<007ooOol03goo00<007ooOol0
0goo0`000Woo00=Wh7ooOol00goo00=n@7ooOol06goo0P?o4Woo0P?/2Goo00<Gh7ooOol01Goo00=W
h7ooOol00Woo00=n@7ooOol0kGoo000;Ool00`00Oomoo`0;Ool40006Ool00`00Oomoo`03Ool00fOP
Oomoo`02Ool00gi0Oomoo`0IOol20olBOol20n`:Ool00aOPOomoo`05Ool00fOPOomoo`02Ool00gi0
Oomoo`3^Ool000]oo`03001oogoo00]oo`03001oogoo00Moo`03001oogoo00=oo`03In1oogoo009o
o`03OT1oogoo01Moo`83oa=oo`030naoogoo00Qoo`8Gh0Ioo`9Wh0Aoo`03OT1oogoo0>moo`002Goo
0`003Goo00<007ooOol01goo00<007ooOol00goo00=Wh7ooOol00Woo00=n@7ooOol05Goo0P?o4goo
0P?/2Woo00<Gh7ooOol01Goo00=Wh7ooOol00goo00=n@7ooOol0l7oo000;Ool00`00Oomoo`0;Ool5
0005Ool00`00Oomoo`03Ool00fOPOomoo`02Ool00gi0Oomoo`0DOol00`?oOomoo`0BOol00`?/Oomo
o`09Ool00aOPOomoo`05Ool00fOPOomoo`03Ool00gi0Oomoo`3aOol002=oo`8000Aoo`03In1oogoo
009oo`03OT1oogoo019oo`83oa=oo`83k0Yoo`8Gh0Moo`03In1oogoo00=oo`03OT1oogoo0?9oo`00
8goo00<007ooOol00goo00=Wh7ooOol00Woo00=n@7ooOol04Goo00<3ogooOol04Goo0P?/2goo00<G
h7ooOol01Woo00=Wh7ooOol00goo00=n@7ooOol0lgoo000SOol00`00Oomoo`03Ool00fOPOomoo`02
Ool00gi0Oomoo`0?Ool20olCOol00`?/Oomoo`0:Ool00aOPOomoo`06Ool00fOPOomoo`03Ool00gi0
Oomoo`3dOol002=oo`03001oogoo00=oo`03In1oogoo009oo`03OT1oogoo00eoo`83oaAoo`030nao
ogoo00Yoo`035n1oogoo00Ioo`03In1oogoo00=oo`03OT1oogoo0?Eoo`008goo00<007ooOol017oo
00=Wh7ooOol00Woo00=n@7ooOol02goo00<3ogooOol04Woo0P?/37oo00<Gh7ooOol01Woo00=Wh7oo
Ool00goo00=n@7ooOol0mWoo000SOol20005Ool00fOPOomoo`02Ool00gi0Oomoo`09Ool20olDOol0
0`?/Oomoo`0;Ool00aOPOomoo`06Ool00fOPOomoo`03Ool00gi0Oomoo`3gOol002=oo`03001oogoo
00Aoo`03In1oogoo009oo`03OT1oogoo00Moo`83oaEoo`030naoogoo00]oo`035n1oogoo00Ioo`03
In1oogoo00=oo`03OT1oogoo0?Qoo`008goo00<007ooOol017oo00=Wh7ooOol00Woo00=n@7ooOol0
1Goo0P?o5Goo0P?/3Goo00<Gh7ooOol01Woo00=Wh7ooOol00goo00=n@7ooOol0nGoo000SOol00`00
Oomoo`04Ool00fOPOomoo`02Ool00gi0Oomoo`03Ool20olFOol00`?/Oomoo`0;Ool25n08Ool00fOP
Oomoo`04Ool00gi0Oomoo`3iOol002=oo`8000Eoo`03In1oogoo009oo`04OT1oogooOol20olGOol0
0`?/Oomoo`0;Ool00aOPOomoo`07Ool00fOPOomoo`04Ool00gi0Oomoo`3jOol002=oo`03001oogoo
00Aoo`03In1oogoo009oo`04OT1oo`?o0olGOol20n`=Ool00aOPOomoo`07Ool00fOPOomoo`04Ool0
0gi0Oomoo`3kOol002=oo`030003ogoo00Aoo`03In1oogoo009oo`83oaQoo`030naoogoo00aoo`03
5n1oogoo00Moo`03In1oogoo00Aoo`03OT1oogoo0?aoo`008goo00<007oo0ol02@?o00=n@7ooOol0
5Woo00<3k7ooOol037oo00<Gh7ooOol01goo00=Wh7ooOol01Goo00=n@7ooOol0o7oo000SOol00`00
Oomoo`05Ool01FOPOomoogooOT005goo00<3k7ooOol037oo00<Gh7ooOol01goo00=Wh7ooOol01Goo
00=n@7ooOol0oGoo000SOol20006Ool01FOPOomoogooOT005Woo00<3k7ooOol037oo00<Gh7ooOol0
1goo00=Wh7ooOol01Goo00=n@7ooOol0oWoo000SOol00`00Oomoo`05Ool01FOPOomoogooOT005Goo
00<3k7ooOol037oo00<Gh7ooOol027oo00=Wh7ooOol017oo00=n@7ooOol0ogoo000HOol50006Ool0
0`00Oomoo`05Ool01FOPOomoogooOT0057oo00<3k7ooOol037oo00<Gh7ooOol027oo00=Wh7ooOol0
1Goo00=n@7ooOol0ogoo000HOol01@00Oomoogoo00001Woo00<007ooOol01Goo00EWh7ooOomoogi0
019oo`83k0moo`035n1oogoo00Moo`03In1oogoo00Eoo`03OT1oogoo0?moo`5oo`006Goo00<007oo
Ool01goo00<001OPOol01Goo00EWh7ooOomoogi0015oo`030naoogoo00ioo`035n1oogoo00Moo`03
In1oogoo00Eoo`03OT1oogoo0?moo`9oo`006Woo00<007ooOol01Woo00<001OP00001Goo00=Wh7oo
Ool00Woo00=n@7ooOol03Goo00<3k7ooOol03Woo00<Gh7ooOol027oo00=Wh7ooOol017oo00=n@7oo
Ool0ogoo0goo000KOol00`00Oomoo`05Ool00`00OolGh005Ool00fOPOomoo`02Ool00gi0Oomoo`0<
Ool00`?/Oomoo`0>Ool00aOPOomoo`08Ool00fOPOomoo`05Ool00gi0Oomoo`3oOol3Ool001aoo`03
001oogoo00Aoo`03001ooaOP00Ioo`05In1oogooOomn@00=Ool00`?/Oomoo`0>Ool00aOPOomoo`08
Ool00fOPOomoo`05Ool00gi0Oomoo`3oOol4Ool001Qoo`05001oogooOol00006Ool01000OomooaOP
1Goo00EWh7ooOomoogi000aoo`030naoogoo00ioo`035n1oogoo00Qoo`03In1oogoo00Eoo`03OT1o
ogoo0?moo`Eoo`006Goo0`001goo00@000?/OolGh0Eoo`05In1oogooOomn@00;Ool00`?/Oomoo`0>
Ool00aOPOomoo`09Ool00fOPOomoo`05Ool00gi0Oomoo`3oOol5Ool002=oo`8000030n`Gh7oo00Ao
o`05In1oogooOomn@00:Ool00`?/Oomoo`0?Ool00aOPOomoo`08Ool00fOPOomoo`05Ool00gi0Oomo
o`3oOol6Ool002=oo`05001oogoo0n`Gh004Ool01FOPOomoogooOT002Goo00<3k7ooOol03goo00<G
h7ooOol027oo00=Wh7ooOol01Woo00=n@7ooOol0ogoo1Woo000SOol01@00Oomoogoo0n`017oo00EW
h7ooOomoogi000Qoo`030naoogoo00moo`035n1oogoo00Qoo`03In1oogoo00Ioo`03OT1oogoo0?mo
o`Moo`008goo00<007ooOol00Woo00D3k7ooOomoofOP00=oo`03OT1oogoo00Eoo`030naoogoo00mo
o`035n1oogoo00Uoo`03In1oogoo00Eoo`03OT1oogoo0?moo`Qoo`008goo00<007ooOol00Woo00DG
h0?/OomoofOP00=oo`03OT1oogoo00Aoo`030naoogoo00moo`035n1oogoo00Uoo`03In1oogoo00Io
o`03OT1oogoo0?moo`Qoo`008goo0P000goo00<Gh7oo0n`00Woo00AWh7ooOomn@0Aoo`83k15oo`03
5n1oogoo00Uoo`03In1oogoo00Ioo`03OT1oogoo0?moo`Uoo`008goo00<007ooOol00goo00<Gh7oo
0n`00P?/0Woo00En@7ooOomoo`?/01=oo`035n1oogoo00Uoo`03In1oogoo00Eoo`03OT1oogoo0?mo
o`Yoo`008goo00<007ooOol00goo00@Gh7ooOomoo`L3k1=oo`035n1oogoo00Uoo`03In1oogoo00Io
o`03OT1oogoo0?moo`Yoo`008goo00<007ooOol017oo00@Gh7ooOomWh0=oo`03OT1oogoo019oo`03
5n1oogoo00Uoo`03In1oogoo00Ioo`03OT1oogoo0?moo`]oo`008goo0P001Goo00@Gh7ooOomWh0=o
o`03OT1oogoo015oo`035n1oogoo00Yoo`03In1oogoo00Ioo`03OT1oogoo0?moo`]oo`008goo00<0
07ooOol017oo00@Gh7ooOomWh0=oo`03OT1oogoo011oo`035n1oogoo00Yoo`03In1oogoo00Ioo`03
OT1oogoo0?moo`aoo`008goo00<007ooOol01Goo00@Gh7ooOomWh09oo`03OT1oogoo00moo`035n1o
ogoo00]oo`03In1oogoo00Eoo`03OT1oogoo0?moo`eoo`008goo00<007ooOol01Goo00@Gh7ooOomW
h09oo`03OT1oogoo00moo`035n1oogoo00Yoo`03In1oogoo00Ioo`03OT1oogoo0?moo`eoo`008goo
00<007ooOol01Goo00@Gh7ooOomWh09oo`03OT1oogoo00ioo`035n1oogoo00Yoo`03In1oogoo00Io
o`03OT1oogoo0?moo`ioo`008goo0P001goo00<Gh7ooIn000Woo00=n@7ooOol03Goo00<Gh7ooOol0
2goo00=Wh7ooOol01Goo00=n@7ooOol0ogoo3goo000SOol00`00Oomoo`06Ool00aOPOomWh003Ool0
0gi0Oomoo`0;Ool00aOPOomoo`0;Ool00fOPOomoo`06Ool00gi0Oomoo`3oOol?Ool000Qoo`D000Eo
o`8000Eoo`@000Ioo`03001oogoo00Ioo`035n1oofOP00=oo`03OT1oogoo00Yoo`035n1oogoo00]o
o`03In1oogoo00Ioo`03OT1oogoo0?mooa1oo`0027oo00D007ooOomoo`0000Eoo`8000Aoo`03001o
ogoo009oo`03001oogoo00=oo`03001oogoo00Moo`035n1oofOP009oo`03OT1oogoo00Yoo`035n1o
ogoo00]oo`03In1oogoo00Ioo`03OT1oogoo0?mooa1oo`002Goo00<007ooOol04Goo00<007ooOol0
0goo00<007ooOol01goo00<Gh7ooIn000Woo00=n@7ooOol02Goo00<Gh7ooOol02goo00=Wh7ooOol0
1Woo00=n@7ooOol0ogoo4Goo000:Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool30008Ool01AOPIn1o
ogooOT002Woo00<Gh7ooOol037oo00=Wh7ooOol01Goo00=n@7ooOol0ogoo4Woo000;Ool00`00Oomo
o`0;Ool40006Ool00`00Oomoo`08Ool01AOPIn1oogooOT002Goo00<Gh7ooOol037oo00=Wh7ooOol0
1Woo00=n@7ooOol0ogoo4Woo000<Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`09Ool0
11OPOomoogi027oo00<Gh7ooOol037oo00=Wh7ooOol01Woo00=n@7ooOol0ogoo4goo0008Ool01@00
Oomoogoo000037oo00<007ooOol01goo00<007ooOol02Goo00@Gh7ooOomn@0Qoo`035n1oogoo00ao
o`03In1oogoo00Ioo`03OT1oogoo0?mooa=oo`002Goo0`003Goo1@001Goo00<007ooOol02Goo00EW
h1OPOomoogi000Ioo`035n1oogoo00aoo`03In1oogoo00Ioo`03OT1oogoo0?mooaAoo`008goo0P00
2goo00@Gh7ooOomn@0Aoo`8Gh0ioo`03In1oogoo00Moo`03OT1oogoo0?mooaAoo`008goo00<007oo
Ool02Woo00AWh1OP5n1n@0=oo`035n1oogoo00ioo`03In1oogoo00Ioo`03OT1oogoo0?mooaEoo`00
8goo00<007ooOol02Woo00=Wh7oo5n0011OP47oo00=Wh7ooOol01goo00=n@7ooOol0ogoo5Goo000S
Ool00`00Oomoo`0:Ool016OPOomoogi04Woo00=Wh7ooOol01goo00=n@7ooOol0ogoo5Woo000SOol0
0`00Oomoo`0:Ool016OPOomoogi04Woo00=Wh7ooOol01goo00=n@7ooOol0ogoo5Woo000SOol2000;
Ool016OPOomoogi04Goo00=Wh7ooOol01goo00=n@7ooOol0ogoo5goo000SOol00`00Oomoo`0;Ool0
16OPOomoogi03goo00=Wh7ooOol027oo00=n@7ooOol0ogoo5goo000SOol00`00Oomoo`0;Ool016OP
Oomoogi03goo00=Wh7ooOol01goo00=n@7ooOol0ogoo67oo000SOol00`00Oomoo`0;Ool016OPOomo
ogi03Woo00=Wh7ooOol027oo00=n@7ooOol0ogoo67oo000SOol2000<Ool016OPOomoogi03Goo00=W
h7ooOol027oo00=n@7ooOol0ogoo6Goo000SOol00`00Oomoo`0<Ool00fOPOomn@00=Ool00fOPOomo
o`08Ool00gi0Oomoo`3oOolIOol002=oo`03001oogoo00aoo`03In1oogi000aoo`03In1oogoo00Qo
o`03OT1oogoo0?mooaYoo`008goo00<007ooOol03Goo00=Wh7i0Ool02Woo00=Wh7ooOol02Goo00=n
@7ooOol0ogoo6Woo000SOol00`00Oomoo`0=Ool00fOPOT1oo`0:Ool00fOPOomoo`08Ool00gi0Oomo
o`3oOolKOol002=oo`8000moo`03In1oogoo00Qoo`03In1oogoo00Uoo`03OT1oogoo0?mooa]oo`00
8goo00<007ooOol03Woo00=Wh7ooOol01goo00=Wh7ooOol02Goo00=n@7ooOol0ogoo77oo000IOol3
0007Ool00`00Oomoo`0>Ool00fOPOomoo`07Ool00fOPOomoo`09Ool00gi0Oomoo`3oOolLOol001Qo
o`05001oogooOol00006Ool00`00Oomoo`0>Ool00fOPOomoo`06Ool00fOPOomoo`09Ool00gi0Oomo
o`3oOolMOol001aoo`03001oogoo00Aoo`03001oogoo00ioo`03OT1Wh7oo00Eoo`03In1oogoo00Uo
o`03OT1oogoo0?mooaioo`0077oo00<007ooOol017oo0`003goo00=n@6OPIn000Woo0VOP37oo00=n
@7ooOol0ogoo7Woo000JOol20007Ool00`00Oomoo`0?Ool00gi0OomWh003In0<Ool00gi0Oomoo`3o
OolOOol001aoo`03001oogoo00Aoo`03001oogoo00moo`03OT1oogoo00moo`03OT1oogoo0?mooamo
o`0067oo00D007ooOomoo`0000Ioo`03001oogoo00moo`03OT1oogoo00ioo`03OT1oogoo0?moob1o
o`006Goo0`001goo00<007ooOol047oo00=n@7ooOol03Goo00=n@7ooOol0ogoo87oo000SOol2000A
Ool00gi0Oomoo`0<Ool00gi0Oomoo`3oOolQOol002=oo`03001oogoo011oo`03OT1oogoo00aoo`03
OT1oogoo0?moob5oo`008goo00<007ooOol04Goo00=n@7ooOol02Woo00=n@7ooOol0ogoo8Woo000S
Ool00`00Oomoo`0AOol00gi0Oomoo`0:Ool00gi0Oomoo`3oOolROol002=oo`03001oogoo015oo`03
OT1oogoo00Uoo`03OT1oogoo0?moob=oo`008goo0P004goo00=n@7ooOol027oo00=n@7ooOol0ogoo
8goo000SOol00`00Oomoo`0BOol00gi0Oomoo`07Ool00gi0Oomoo`3oOolTOol002=oo`03001oogoo
01=oo`03OT1oogoo00Eoo`03OT1oogoo0?moobEoo`008goo00<007ooOol04goo00=n@7ooOol01Goo
00=n@7ooOol0ogoo9Goo000SOol00`00Oomoo`0COol00gi0Oomoo`04Ool00gi0Oomoo`3oOolVOol0
02=oo`8001Eoo`03OT1oogoo009oo`03OT1oogoo0?moobMoo`008goo00<007ooOol057oo1Gi0ogoo
:Woo000SOol00`00Oomoo`3oOom3Ool002=oo`03001oogoo0?mood=oo`008goo0P00ogooA7oo000S
Ool00`00Oomoo`3oOom3Ool002=oo`03001oogoo0?mood=oo`00ogooJGoo003oOomYOol00?moofUo
o`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003o
OomYOol00?moofUoo`00ogooJGoo000POol3003oOom6Ool0025oo`03001oogoo0?moodEoo`008Goo
00<007ooOol0ogooAGoo000QOol00`00Ool0003oOom5Ool0025oo`<00?moodEoo`008Goo00<007oo
0000ogooAGoo000QOol01@00Oomoogoo0000ogoo@goo000POol6003oOom3Ool00?moofUoo`00ogoo
JGoo003oOomYOol00?moofUoo`00ogooJGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {221.375, 0}} -> {-0.241336, -0.616962, \
0.00849577, 0.0259865}}]
}, Open  ]],

Cell[TextData[{
  "The second solution with ",
  Cell[BoxData[
      \(TraditionalForm\`C[1] = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`C[2] = 1\)]],
  " has the graph "
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[
      Evaluate[Table[
            F[\[Zeta]] /. 
              sheat\[LeftDoubleBracket]1, 1\[RightDoubleBracket], {c, 
              \(-2.1\), 2.1,  .5}] /. {C[1] \[Rule] 0, C[2] \[Rule] 1}], \n
      \t{\[Zeta], 0.01, 2}, AxesLabel \[Rule] {"\<\[Zeta]\>", "\<F\>"}, 
      PlotStyle \[Rule] Table[Hue[i\/10], {i, 1, 8}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0995965 0.283835 [
[.2619 .0871 -9 -9 ]
[.2619 .0871 9 0 ]
[.5 .0871 -3 -9 ]
[.5 .0871 3 0 ]
[.7381 .0871 -9 -9 ]
[.7381 .0871 9 0 ]
[.97619 .0871 -3 -9 ]
[.97619 .0871 3 0 ]
[1.025 .0996 0 -7.5 ]
[1.025 .0996 10 7.5 ]
[.01131 .24151 -18 -4.5 ]
[.01131 .24151 0 4.5 ]
[.01131 .38343 -6 -4.5 ]
[.01131 .38343 0 4.5 ]
[.01131 .52535 -18 -4.5 ]
[.01131 .52535 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2619 .0996 m
.2619 .10585 L
s
[(0.5)] .2619 .0871 0 1 Mshowa
.5 .0996 m
.5 .10585 L
s
[(1)] .5 .0871 0 1 Mshowa
.7381 .0996 m
.7381 .10585 L
s
[(1.5)] .7381 .0871 0 1 Mshowa
.97619 .0996 m
.97619 .10585 L
s
[(2)] .97619 .0871 0 1 Mshowa
.125 Mabswid
.07143 .0996 m
.07143 .10335 L
s
.11905 .0996 m
.11905 .10335 L
s
.16667 .0996 m
.16667 .10335 L
s
.21429 .0996 m
.21429 .10335 L
s
.30952 .0996 m
.30952 .10335 L
s
.35714 .0996 m
.35714 .10335 L
s
.40476 .0996 m
.40476 .10335 L
s
.45238 .0996 m
.45238 .10335 L
s
.54762 .0996 m
.54762 .10335 L
s
.59524 .0996 m
.59524 .10335 L
s
.64286 .0996 m
.64286 .10335 L
s
.69048 .0996 m
.69048 .10335 L
s
.78571 .0996 m
.78571 .10335 L
s
.83333 .0996 m
.83333 .10335 L
s
.88095 .0996 m
.88095 .10335 L
s
.92857 .0996 m
.92857 .10335 L
s
.25 Mabswid
0 .0996 m
1 .0996 L
s
gsave
1.025 .0996 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .24151 m
.03006 .24151 L
s
[(0.5)] .01131 .24151 1 0 Mshowa
.02381 .38343 m
.03006 .38343 L
s
[(1)] .01131 .38343 1 0 Mshowa
.02381 .52535 m
.03006 .52535 L
s
[(1.5)] .01131 .52535 1 0 Mshowa
.125 Mabswid
.02381 .12798 m
.02756 .12798 L
s
.02381 .15636 m
.02756 .15636 L
s
.02381 .18475 m
.02756 .18475 L
s
.02381 .21313 m
.02756 .21313 L
s
.02381 .2699 m
.02756 .2699 L
s
.02381 .29828 m
.02756 .29828 L
s
.02381 .32666 m
.02756 .32666 L
s
.02381 .35505 m
.02756 .35505 L
s
.02381 .41182 m
.02756 .41182 L
s
.02381 .4402 m
.02756 .4402 L
s
.02381 .46858 m
.02756 .46858 L
s
.02381 .49697 m
.02756 .49697 L
s
.02381 .07121 m
.02756 .07121 L
s
.02381 .04283 m
.02756 .04283 L
s
.02381 .01445 m
.02756 .01445 L
s
.02381 .55373 m
.02756 .55373 L
s
.02381 .58212 m
.02756 .58212 L
s
.02381 .6105 m
.02756 .6105 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .6 0 r
.5 Mabswid
.14976 0 m
.16671 .0767 L
.17759 .11354 L
.18752 .14118 L
.20651 .1818 L
.21724 .1992 L
.22716 .21251 L
.24574 .23171 L
.25631 .23999 L
.26623 .24637 L
.27602 .25155 L
.28632 .25598 L
.30473 .26179 L
.31423 .26392 L
.32437 .26567 L
.33395 .26688 L
.34265 .26767 L
.34747 .26799 L
.35258 .26825 L
.35694 .26841 L
.35942 .26848 L
.36173 .26853 L
.36301 .26855 L
.36441 .26857 L
.36505 .26857 L
.36573 .26858 L
.36695 .26859 L
.36824 .26859 L
.36945 .26859 L
.37054 .26859 L
.37171 .26858 L
.37301 .26857 L
.37443 .26856 L
.37591 .26854 L
.3773 .26852 L
.38243 .2684 L
.38743 .26823 L
.39285 .26801 L
.40272 .26748 L
.42119 .26614 L
.46182 .26209 L
.50095 .25734 L
.53856 .25243 L
.57861 .24708 L
.61716 .24198 L
.65815 .2367 L
.69762 .23182 L
.73559 .22733 L
.776 .22278 L
.81491 .21862 L
Mistroke
.85625 .21445 L
.89608 .21065 L
.93441 .20718 L
.97517 .2037 L
.97619 .20362 L
Mfstroke
.8 1 0 r
.10286 0 m
.10894 .03575 L
.11913 .08539 L
.13015 .12929 L
.14938 .18664 L
.15884 .20788 L
.16922 .22711 L
.18018 .24361 L
.19018 .25587 L
.20959 .27378 L
.22028 .28103 L
.2304 .28657 L
.24001 .29082 L
.25021 .29443 L
.25977 .2971 L
.26854 .29903 L
.27786 .30061 L
.28266 .30126 L
.28791 .30186 L
.29677 .30261 L
.3016 .30291 L
.3061 .30311 L
.30871 .30321 L
.31112 .30327 L
.31377 .30333 L
.3151 .30335 L
.31586 .30336 L
.31657 .30336 L
.31786 .30337 L
.31903 .30338 L
.3203 .30338 L
.32101 .30338 L
.32168 .30338 L
.32289 .30337 L
.32399 .30337 L
.32526 .30335 L
.32646 .30334 L
.32871 .3033 L
.33109 .30325 L
.33535 .30313 L
.33993 .30297 L
.34495 .30274 L
.3644 .30151 L
.38522 .29969 L
.42643 .29511 L
.46613 .29001 L
.50432 .28485 L
.54495 .27932 L
.58407 .27408 L
.62168 .26918 L
Mistroke
.66174 .26417 L
.70028 .25955 L
.74127 .25487 L
.78075 .25059 L
.81872 .24668 L
.85913 .24271 L
.89803 .23909 L
.93937 .23544 L
.97619 .23235 L
Mfstroke
.2 1 0 r
.02857 .04603 m
.0332 .04456 L
.03541 .04382 L
.0365 .04349 L
.0375 .04325 L
.03869 .04307 L
.03998 .04307 L
.04107 .04325 L
.04223 .04368 L
.04347 .04443 L
.04464 .04542 L
.04591 .04685 L
.04729 .04879 L
.04981 .05341 L
.05257 .05989 L
.05759 .07476 L
.06701 .10858 L
.08731 .1808 L
.09844 .21309 L
.10894 .2382 L
.11913 .2582 L
.13015 .27573 L
.14938 .29833 L
.15884 .30655 L
.16922 .31387 L
.18018 .32002 L
.19018 .32445 L
.19948 .32775 L
.20959 .33058 L
.22028 .33286 L
.2304 .33445 L
.23975 .3355 L
.24508 .33595 L
.25008 .33628 L
.25263 .33642 L
.25532 .33654 L
.26013 .33671 L
.26282 .33678 L
.26531 .33682 L
.26675 .33684 L
.26805 .33686 L
.26877 .33686 L
.26956 .33687 L
.2703 .33687 L
.27098 .33687 L
.27223 .33687 L
.27341 .33687 L
.27447 .33686 L
.27563 .33685 L
.27688 .33684 L
Mistroke
.27822 .33683 L
.28062 .33679 L
.28536 .33668 L
.28965 .33654 L
.30023 .33609 L
.31018 .33552 L
.3302 .33404 L
.34859 .33237 L
.38794 .32819 L
.42577 .32374 L
.46604 .31881 L
.50481 .31407 L
.54602 .30912 L
.58571 .3045 L
.6239 .30022 L
.66453 .29586 L
.70366 .29184 L
.74127 .28815 L
.78132 .28439 L
.81987 .28094 L
.86086 .27745 L
.90033 .27423 L
.9383 .27128 L
.97619 .26846 L
Mfstroke
0 1 .4 r
.02857 .26737 m
.06701 .30162 L
.08702 .32392 L
.09837 .33373 L
.10894 .34109 L
.12796 .35082 L
.13862 .3547 L
.14831 .35747 L
.15822 .35969 L
.16736 .36128 L
.1774 .36261 L
.18296 .36318 L
.18804 .36361 L
.19741 .36421 L
.20257 .36444 L
.20495 .36453 L
.20748 .3646 L
.20985 .36466 L
.21199 .36471 L
.21418 .36475 L
.21619 .36477 L
.21733 .36478 L
.21854 .36479 L
.21975 .3648 L
.22044 .3648 L
.22108 .36481 L
.22224 .36481 L
.2233 .36481 L
.22453 .36481 L
.22569 .3648 L
.22682 .36479 L
.22804 .36479 L
.23025 .36476 L
.23288 .36473 L
.23529 .36469 L
.24026 .36458 L
.2455 .36444 L
.25425 .36414 L
.26383 .36372 L
.30418 .36131 L
.34303 .35836 L
.38432 .35494 L
.42411 .35154 L
.46238 .34828 L
.50309 .34488 L
.5423 .3417 L
.58 .33875 L
.62014 .33572 L
.65877 .33292 L
.69984 .33006 L
Mistroke
.7394 .32743 L
.77745 .325 L
.81795 .32252 L
.85693 .32023 L
.89836 .31789 L
.93828 .31573 L
.97619 .31375 L
Mfstroke
0 1 1 r
.02857 .37387 m
.06701 .37764 L
.08702 .37945 L
.09837 .38019 L
.10894 .38072 L
.1189 .38111 L
.12796 .38137 L
.13298 .38148 L
.13842 .38159 L
.14353 .38166 L
.14831 .38172 L
.15284 .38177 L
.1577 .3818 L
.16047 .38182 L
.16311 .38183 L
.16547 .38184 L
.16671 .38184 L
.16805 .38185 L
.16879 .38185 L
.16947 .38185 L
.17011 .38185 L
.1708 .38185 L
.17202 .38185 L
.1733 .38185 L
.17403 .38185 L
.1747 .38185 L
.17547 .38185 L
.1762 .38185 L
.17749 .38185 L
.1789 .38185 L
.18144 .38184 L
.18413 .38183 L
.18897 .38181 L
.19384 .38179 L
.1983 .38176 L
.20835 .38168 L
.22654 .38149 L
.26596 .38094 L
.30388 .38032 L
.34424 .37962 L
.38309 .37893 L
.42438 .37821 L
.46416 .37752 L
.50243 .37688 L
.54315 .37621 L
.58235 .3756 L
.62005 .37503 L
.66019 .37444 L
.69882 .37389 L
.73989 .37333 L
Mistroke
.77945 .37282 L
.81751 .37233 L
.858 .37184 L
.89699 .37137 L
.93841 .3709 L
.97619 .37048 L
Mfstroke
0 .4 1 r
.02857 .3926 m
.04729 .38935 L
.06701 .38583 L
.07737 .38441 L
.08702 .38343 L
.09257 .38299 L
.09761 .38268 L
.1004 .38254 L
.10343 .38241 L
.10609 .38231 L
.10894 .38222 L
.11147 .38216 L
.11379 .38212 L
.1149 .3821 L
.11612 .38209 L
.11726 .38207 L
.11833 .38206 L
.11898 .38206 L
.11969 .38206 L
.12093 .38205 L
.12163 .38205 L
.12237 .38205 L
.123 .38205 L
.1237 .38205 L
.12494 .38205 L
.12564 .38206 L
.12627 .38206 L
.12868 .38208 L
.12997 .3821 L
.13135 .38211 L
.13382 .38215 L
.13942 .38227 L
.14426 .38241 L
.1496 .38259 L
.16885 .38347 L
.1896 .38471 L
.23054 .38769 L
.26996 .39091 L
.30788 .39413 L
.34824 .39758 L
.38709 .40087 L
.42838 .4043 L
.46816 .40752 L
.50643 .41053 L
.54715 .41365 L
.58635 .41656 L
.62405 .41928 L
.66419 .42209 L
.70282 .42472 L
.74389 .42743 L
Mistroke
.78345 .42997 L
.82151 .43235 L
.862 .43481 L
.90099 .43712 L
.94241 .43951 L
.97619 .44141 L
Mfstroke
.2 0 1 r
.02857 .36073 m
.0375 .36027 L
.04729 .35976 L
.05222 .35955 L
.05493 .35945 L
.0575 .35938 L
.05866 .35935 L
.05989 .35933 L
.06053 .35932 L
.06124 .35931 L
.06248 .3593 L
.06361 .3593 L
.06482 .35929 L
.06597 .3593 L
.06701 .3593 L
.06771 .35931 L
.06837 .35932 L
.06959 .35934 L
.07091 .35936 L
.07234 .3594 L
.07492 .35948 L
.07729 .35958 L
.08274 .35987 L
.08851 .36028 L
.09825 .3612 L
.10894 .36247 L
.14916 .36903 L
.18787 .37682 L
.22903 .38578 L
.26867 .39463 L
.30681 .40317 L
.34739 .41217 L
.38646 .42069 L
.42402 .42874 L
.46402 .43713 L
.50252 .44502 L
.54345 .45324 L
.58288 .46097 L
.6208 .46824 L
.66115 .47582 L
.7 .48297 L
.74129 .4904 L
.78108 .49742 L
.81935 .50404 L
.86007 .51096 L
.89927 .51749 L
.93697 .52366 L
.97619 .52997 L
s
.8 0 1 r
.02857 .30839 m
.06701 .31864 L
.10894 .33244 L
.14831 .34697 L
.18618 .36152 L
.22648 .37721 L
.26528 .39231 L
.30652 .40824 L
.34625 .42343 L
.38447 .43787 L
.42513 .45303 L
.46429 .46743 L
.50193 .48109 L
.54202 .49545 L
.5806 .5091 L
.62162 .52342 L
.66113 .53705 L
.69913 .55 L
.73957 .56362 L
.77851 .57659 L
.81988 .59022 L
.85975 .6032 L
.8981 .61557 L
s
.8981 .61557 m
.90581 .61803 L
s
1 .6 0 r
.02857 .2544 m
.06701 .27557 L
.10894 .29897 L
.14831 .3211 L
.18618 .34242 L
.22648 .3651 L
.26528 .3869 L
.30652 .41002 L
.34625 .43224 L
.38447 .45357 L
.42513 .4762 L
.46429 .49793 L
.50193 .51878 L
.54202 .54093 L
.5806 .5622 L
.62162 .58476 L
.66113 .60644 L
s
.66113 .60644 m
.68229 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  ImageSize->{299, 185},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005e0000ia000`40O003h00O77oo00<007ooOol0
5goo00=Wh7ooOol03Goo00=n@7ooOol0ogoo;Goo000LOol00`00Oomoo`0GOol00fOPOomoo`0=Ool0
0gi0Oomoo`3oOol]Ool001aoo`03001oogoo01Moo`03In1oogoo00eoo`03OT1oogoo0?moobeoo`00
77oo00<007ooOol067oo00=Wh7ooOol03Goo00=n@7ooOol0ogoo;7oo000LOol00`00Oomoo`0HOol0
0fOPOomoo`0=Ool00gi0Oomoo`3oOol/Ool001aoo`<001Qoo`03In1oogoo00eoo`03OT1oogoo0?mo
obaoo`0077oo00<007ooOol067oo00=Wh7ooOol03Goo00=n@7ooOol0ogoo;7oo000LOol00`00Oomo
o`0HOol00fOPOomoo`0=Ool00gi0Oomoo`3oOol/Ool001aoo`03001oogoo01Qoo`03In1oogoo00io
o`03OT1oogoo0?moob]oo`0077oo00<007ooOol06Goo00=Wh7ooOol03Goo00=n@7ooOol0ogoo:goo
000LOol00`00Oomoo`0IOol00fOPOomoo`0=Ool00gi0Oomoo`3oOol[Ool001aoo`03001oogoo01Uo
o`03In1oogoo00eoo`03OT1oogoo0?moob]oo`0077oo00<007ooOol06Goo00=Wh7ooOol03Goo00=n
@7ooOol0ogoo:goo000LOol00`00Oomoo`0IOol00fOPOomoo`0>Ool00gi0Oomoo`3oOolZOol001ao
o`<0009oo`8Gh1Ioo`03In1oogoo00eoo`03OT1oogoo0?moobYoo`0077oo00<007oo5n000QOP00=o
oaOP5n005Goo00=Wh7ooOol03Goo00=n@7ooOol0ogoo:Woo000LOol00`00Oomoo`05Ool00aOPOomo
o`0BOol00fOPOomoo`0=Ool00gi0Oomoo`3oOolZOol001aoo`03001oogoo00Ioo`035n1oogoo015o
o`03In1oogoo00eoo`03OT1oogoo0?moobYoo`0077oo00<007ooOol01Woo00<Gh7ooOol04Woo00=W
h7ooOol03Goo00=n@7ooOol057oo10001Goo0P001Goo1000@Woo1@00@Goo1@0017oo0P001Goo1000
@Woo1@007Goo000LOol00`00Oomoo`07Ool00aOPOomoo`0AOol00fOPOomoo`0=Ool00gi0Oomoo`0C
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`11Ool00`00
Oomoo`13Ool00`00Oomoo`04Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`0oOol01@00Oomoogoo
00007Goo000LOol00`00Oomoo`07Ool00aOPOomoo`0AOol00fOPOomoo`0=Ool00gi0Oomoo`0COol0
0`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`11Ool00`00Oomoo`13Ool00`00Oomoo`0?Ool0
0`00Oomoo`10Ool00`00Oomoo`0NOol001aoo`03001oogoo00Moo`035n1oogoo015oo`03In1oogoo
00eoo`03OT1oogoo01=oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo045oo`03001oogoo
04=oo`03001oogoo00moo`03001oogoo045oo`03001oogoo01eoo`0077oo00<007ooOol01goo00<G
h7ooOol04Woo00=Wh7ooOol037oo00=n@7ooOol04goo00<007ooOol00Woo00<007ooOol02Goo1000
A7oo00<007ooOol0@goo00<007ooOol02goo1000AGoo00<007ooOol077oo000LOol00`00Oomoo`08
Ool00aOPOomoo`0AOol00fOPOomoo`0=Ool00gi0Oomoo`0BOol00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`15Ool00`00Oomoo`13Ool00`00Oomoo`0;Ool00`00Oomoo`17Ool00`00Oomoo`0K
Ool001aoo`<000Qoo`035n1oogoo015oo`03In1oogoo00eoo`03OT1oogoo019oo`03001oogoo009o
o`03001oogoo00Uoo`03001oogoo04=oo`<004=oo`<000eoo`03001oogoo04=oo`05001oogooOol0
000MOol001aoo`03001oogoo00Qoo`035n1oogoo015oo`03In1oogoo00eoo`03OT1oogoo01=oo`@0
00aoo`D004=oo`03001oogoo04=oo`03001oogoo00]oo`D0049oo`<001ioo`0077oo00<007ooOol0
27oo00<Gh7ooOol04Woo00=Wh7ooOol037oo00=n@7ooOol0ogoo:7oo000LOol00`00Oomoo`09Ool0
0aOPOomoo`0AOol00fOPOomoo`0=Ool00gi0Oomoo`3oOolWOol001aoo`03001oogoo00Uoo`035n1o
ogoo015oo`03In1oogoo00eoo`03OT1oogoo0?mooa]oo`@000Qoo`0077oo00<007ooOol02Goo00<G
h7ooOol04Goo00=Wh7ooOol03Goo00=n@7ooOol0ogoo6Woo00<007ooOol00Woo00<007ooOol01Goo
000LOol00`00Oomoo`09Ool00aOPOomoo`0AOol00fOPOomoo`0>Ool00gi0Oomoo`3oOolKOol30008
Ool001aoo`03001oogoo00Yoo`035n1oogoo015oo`03In1oogoo00eoo`03OT1oogoo0?mooaYoo`03
001oogoo00Uoo`0077oo00<007ooOol02Woo00<Gh7ooOol04Goo00=Wh7ooOol03Goo00=n@7ooOol0
ogoo6Woo00<007ooOol02Goo000DOolE00000aOP0000000A00000fOP0000000=00000gi00000003o
000?000;Ool00`00Oomoo`09Ool001aoo`03001oogoo00Yoo`045n1oogoo000?Ool00`00In1oo`0<
Ool01000Oomoogi037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol04Goo00<007ooOol027oo000LOol00`00
Oomoo`0;Ool00aOPOomoo`0@Ool00fOPOomoo`0>Ool00gi0Oomoo`0JOol00`00Oomoo`1;Ool00`00
Oomoo`1;Ool00`00Oomoo`1<Ool00`00Oomoo`0BOol30007Ool001aoo`03001oogoo00]oo`035n1o
ogoo015oo`03In1oogoo00eoo`03OT1oogoo0?mooaYoo`80009oo`03001oogoo00Aoo`0077oo00<0
07ooOol02goo00<Gh7ooOol04Goo00=Wh7ooOol03Woo00=n@7ooOol0ogoo6goo0`001Woo000LOol0
0`00Oomoo`0<Ool00aOPOomoo`0@Ool00fOPOomoo`0>Ool00gi0Oomoo`3oOolTOol001aoo`03001o
ogoo00aoo`035n1oogoo011oo`03In1oogoo00ioo`03OT1oogoo0?moobAoo`0077oo00<007ooOol0
37oo00<Gh7ooOol047oo00=Wh7ooOol03goo00=n@7ooOol0ogoo8goo000LOol00`00Oomoo`0<Ool0
0aOPOomoo`0AOol00fOPOomoo`0>Ool00gi0Oomoo`3oOolSOol001aoo`<000eoo`035n1oogoo011o
o`03In1oogoo00ioo`03OT1oogoo0?moob=oo`0077oo00<007ooOol03Goo00<Gh7ooOol047oo00=W
h7ooOol03goo00=n@7ooOol0ogoo8Woo000LOol00`00Oomoo`0=Ool00aOPOomoo`0@Ool00fOPOomo
o`0?Ool00gi0Oomoo`3oOolROol001aoo`03001oogoo00ioo`035n1oogoo011oo`03In1oogoo00io
o`03OT1oogoo0?moob9oo`0077oo00<007ooOol03Woo00<Gh7ooOol047oo00=Wh7ooOol03goo00=n
@7ooOol0ogoo8Goo000LOol00`00Oomoo`0>Ool00aOPOomoo`0@Ool00fOPOomoo`0?Ool00gi0Oomo
o`3oOolQOol001aoo`03001oogoo00moo`035n1oogoo011oo`03In1oogoo00ioo`03OT1oogoo0?mo
ob5oo`0077oo00<007ooOol03goo00<Gh7ooOol047oo00=Wh7ooOol03goo00=n@7ooOol0ogoo87oo
000LOol00`00Oomoo`0?Ool00aOPOomoo`0AOol00fOPOomoo`0>Ool00gi0Oomoo`3oOolPOol001ao
o`03001oogoo00moo`035n1oogoo015oo`03In1oogoo00moo`03OT1oogoo0?mooamoo`0077oo0`00
47oo00<Gh7ooOol047oo00=Wh7ooOol03goo00=n@7ooOol0ogoo7goo000LOol00`00Oomoo`0@Ool0
0aOPOomoo`0AOol00fOPOomoo`0?Ool00gi0Oomoo`3oOolNOol001aoo`03001oogoo011oo`035n1o
ogoo015oo`03In1oogoo00moo`03OT1oogoo0?mooaioo`0077oo00<007ooOol04Goo00<Gh7ooOol0
47oo00=Wh7ooOol047oo00=n@7ooOol0ogoo7Goo000LOol00`00Oomoo`0AOol00aOPOomoo`0AOol0
0fOPOomoo`0?Ool00gi0Oomoo`3oOolMOol001aoo`03001oogoo015oo`035n1oogoo015oo`03In1o
ogoo011oo`03OT1oogoo0?mooaaoo`0077oo00<007ooOol04Goo00<Gh7ooOol04Woo00=Wh7ooOol0
3goo00=n@7ooOol0ogoo77oo000LOol00`00Oomoo`0BOol00aOPOomoo`0AOol00fOPOomoo`0@Ool0
0gi0Oomoo`3oOolKOol001aoo`03001oogoo019oo`035n1oogoo015oo`03In1oogoo011oo`03OT1o
ogoo0?mooa]oo`0077oo0`004Woo00<Gh7ooOol04Woo00=Wh7ooOol047oo00=n@7ooOol0ogoo6Woo
000LOol00`00Oomoo`0COol00aOPOomoo`0AOol00fOPOomoo`0@Ool00gi0Oomoo`3oOolJOol001ao
o`03001oogoo01=oo`035n1oogoo015oo`03In1oogoo015oo`03OT1oogoo0?mooaUoo`0077oo00<0
07ooOol057oo00<Gh7ooOol04Goo00=Wh7ooOol04Goo00=n@7ooOol0ogoo67oo000LOol00`00Oomo
o`0DOol00aOPOomoo`0AOol00fOPOomoo`0AOol00gi0Oomoo`3oOolHOol001aoo`03001oogoo01Ao
o`035n1oogoo019oo`03In1oogoo015oo`03OT1oogoo0?mooaMoo`0077oo00<007ooOol05Goo00<G
h7ooOol04Goo00=Wh7ooOol04Woo00=n@7ooOol0kgoo27i07Woo000LOol00`00Oomoo`0EOol00aOP
Oomoo`0BOol00fOPOomoo`0BOol00gi0Oomoo`3TOol:OT0VOol001aoo`03001oogoo01Ioo`035n1o
ogoo015oo`03In1oogoo019oo`03OT1oogoo0=ioo`In@31oo`0077oo0`005Woo00<Gh7ooOol04Woo
00=Wh7ooOol04Woo00=n@7ooOol0dgoo2Wi0=Woo000LOol00`00Oomoo`0FOol00aOPOomoo`0BOol0
0fOPOomoo`0COol00gi0Oomoo`35Ool=OT10Ool001aoo`03001oogoo01Moo`035n1oogoo019oo`03
In1oogoo01=oo`03OT1oogoo0;Yoo`Yn@4eoo`0077oo00<007ooOol05goo00<Gh7ooOol04Woo00=W
h7ooOol057oo00=n@7ooOol0/goo1Wi0Egoo000LOol00`00Oomoo`0GOol00aOPOomoo`0COol00fOP
Oomoo`0DOol00gi0Oomoo`2XOol:OT1MOol001aoo`03001oogoo01Qoo`035n1oogoo019oo`03In1o
ogoo01Eoo`03OT1oogoo09Yoo`en@6Moo`0077oo00<007ooOol067oo00<Gh7ooOol04goo00=Wh7oo
Ool05Goo00=n@7ooOol0Sgoo2Wi0M7oo0002Ool40005Ool20005Ool40006Ool00`00Oomoo`0HOol0
0aOPOomoo`0DOol00fOPOomoo`0EOol00gi0Oomoo`28Ool6OT1IOol7In0NOol00003Ool007oo00=o
o`03001oogoo009oo`8000Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo01Uoo`035n1o
ogoo01=oo`03In1oogoo01Ioo`9n@85oo`Mn@59oo`eWh2Eoo`0000=oo`00Ool00goo00<007ooOol0
3Goo00<007ooOol00goo00<007ooOol06Goo00<Gh7ooOol057oo00=Wh7ooOol05goo00=n@7ooOol0
Mgoo1gi0C7oo3FOP<Woo00000goo001oo`03Ool00`00Oomoo`0=Ool00`00Oomoo`03Ool3000JOol0
0aOPOomoo`0DOol00fOPOomoo`0GOol2OT1aOol6OT16Ool=In0oOol00003Ool007oo00=oo`03001o
ogoo00Uoo`@000Ioo`03001oogoo01Yoo`035n1oogoo01Eoo`03In1oogoo01Qoo`03OT1oogoo06Qo
o`In@49oo`YWh4aoo`0000=oo`00Ool00goo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0
6goo00<Gh7ooOol05Goo00=Wh7ooOol067oo0Wi0GWoo2Wi0@Woo1VOPEWoo00000goo001oo`03Ool0
0`00Oomoo`09Ool00`00Oomoo`07Ool00`00Oomoo`0LOol00aOPOomoo`0DOol00fOPOomoo`0JOol2
OT1BOol:OT12Ool:In1LOol0009oo`@000aoo`D000Eoo`03001oogi001aoo`035n1oogoo01Eoo`03
In1oogoo01]oo`An@4Qoo`In@49oo`YWh6Ioo`0077oo00<007ooOol00Wi06goo00<Gh7ooOol05Goo
00=Wh7ooOol07Woo0gi0>goo2Wi0@Woo1VOPL7oo000LOol00`00Oomoo`02Ool2OT0JOol00aOPOomo
o`0EOol00fOPOomoo`0POol3OT0^Ool:OT12Ool:In1fOol001aoo`03001oogoo00Aoo`03OT1oogoo
01Moo`035n1oogoo01Ioo`03In1oogoo029oo`=n@2Eoo`In@49oo`YWh81oo`0077oo00<007oo0n`0
1Goo0Wi067oo00<Gh7ooOol05Woo00=Wh7ooOol097oo2gi02goo3gi0@Woo1VOPRWoo000LOol30000
0`?/Oomoo`04Ool2OT0FOol00aOPOomoo`0GOol00fOPOomoo`0^Ool;OT18Ool9In1OOolC5n0NOol0
01aoo`05001oogooOol3k007Ool2OT0EOol00aOPOomoo`0GOol00fOPOomoo`1fOol:In1NOol:5n0a
Ool001aoo`03001oogoo009oo`030naoogoo00Ioo`03OT1oogoo019oo`035n1oogoo01Qoo`03In1o
ogoo06moo`IWh69oo`HGh3]oo`0077oo00<007ooOol00goo00<3k7ooOol01Woo0Wi04goo00<Gh7oo
Ool067oo0VOPJ7oo1fOPGWoo2QOP@Goo000LOol00`00Oomoo`04Ool00`?/Oomoo`07Ool2OT0BOol0
0aOPOomoo`0IOol00fOPOomoo`1NOol7In1GOol>5n1;Ool001aoo`03001oogoo00Eoo`83k0Uoo`9n
@15oo`035n1oogoo01Uoo`9Wh5Qoo`IWh55oo`dGh5Uoo`0077oo00<007ooOol01goo00<3k7ooOol0
27oo00=n@7ooOol03goo00<Gh7ooOol06Woo0VOPD7oo1VOPBgoo31OPIWoo000LOol00`00Oomoo`08
Ool00`?/Oomoo`08Ool2OT0@Ool00aOPOomoo`0KOol3In13Ool:In17Ool:5n1bOol001aoo`03001o
ogoo00Uoo`030naoogoo00Uoo`9n@0moo`035n1oogoo01eoo`AWh3Eoo`YWh4]oo`HGh7aoo`0077oo
0`002Woo00<3k7ooOol02Woo0Wi03Woo00<Gh7ooOol087oo0fOP:goo1fOPBgoo2QOPPWoo000LOol0
0`00Oomoo`0;Ool00`?/Oomoo`0;Ool00gi0Oomoo`0<Ool00aOPOomoo`0ROol6In0HOol=In15Ool=
5n2<Ool001aoo`03001oogoo00aoo`030naoogoo00]oo`9n@0eoo`035n1oogoo02MooaQWh4Qoo`XG
h9Uoo`0077oo00<007ooOol03Goo00<3k7ooOol037oo0Wi037oo00<Gh7ooOol0P7oo1QOPXgoo000L
Ool01000OomT7f@O3Goo00<3k7ooOol03Goo0Wi02goo0QOPNGoo1aOPZGoo000LOol01000Oomoogoo
16@O2Woo00<3k7ooOol03Woo0Wi02goo00<Gh7ooOol0Kgoo1aOPRgoo1`?/7Woo000LOol00`00Oomo
o`05Ool4I1l6Ool00`?/Oomoo`0@Ool2OT0:Ool00aOPOomoo`1UOol95n25Ool=0n`UOol001aoo`03
001oogoo00Uoo`AT7`=oo`030naoogoo015oo`9n@0Uoo`8Gh5]oo`XGh85oo`d3k39oo`0077oo00<0
07ooOol03Goo0f@O00=oo`?/Ool04goo00=n@7ooOol027oo0QOPDWoo1aOPL7oo6`?/?goo000LOol0
0`00Oomoo`0@Ool2I1l00`?/Oomoo`0BOol2OT0:Ool35n16Ool95n1[Ool<0naJOol001aoo`<0019o
o`=T7aAoo`9n@0]oo`<Gh3Uoo`XGh6Moo`d3k6Ioo`0077oo00<007ooOol057oo00@3k6@OI1mT7a=o
o`9n@0aoo`<Gh31oo`HGh6Aoo`d3k7=oo`0077oo00<007ooOol05Woo00<3k7ooI1l00V@O4Woo0Wi0
3Goo1aOP77oo3AOPG7oo3P?/P7oo000LOol00`00Oomoo`0GOol20n`2Ool3I1lAOol2OT0BOolL5n1L
Ool=0nb>Ool001aoo`03001oogoo01Uoo`030naoogoo009oo`AT7`moo`9n@7aoo``3k9]oo`0077oo
00<007ooOol06Woo0P?/1Woo0f@O3Woo00=n@7ooOol0K7oo3@?/Ygoo000LOol00`00Oomoo`0LOol2
0n`7Ool3I1l<Ool2OT1OOol=0nbdOol001aoo`03001oogoo01ioo`83k0Qoo`9T7`aoo`9n@51oo`d3
k<5oo`0077oo00<007ooOol087oo0P?/27oo0f@O2goo0Wi0@Goo3@?/cWoo000LOol3000ROol30n`8
Ool3I1l:Ool2OT0bOol=0ncKOol001aoo`03001oogoo00Qoo`LD7aIoo`<3k0Qoo`9T7`Yoo`9n@29o
o`h3k>Qoo`0077oo00<007oo51l021@O1goo3A@O37oo1P?/17oo0f@O2Goo0Wi04goo3@?/mWoo000L
Ool00`00Oomoo`0LOol451l>Ool70n`2I1l90n`00gi00n`3k00@0ncoOol4Ool001aoo`03001oogoo
021oo`DD7a9oo`=T7`Moo`9n@?mooaAoo`0077oo00<007ooOol09Goo1A@O47oo0f@O1Woo0Wi0dWoo
8@?o7Woo000BOol50005Ool00`00Ool3o`050olUOol651l=Ool2I1l6Ool00gi0Oomoo`21Oom>0olo
Ool001Aoo`03001oogoo00Eoo`03001oogoo00Eoo`X3ob5oo`HD7`Uoo`=T7`Aoo`9n@41ood43oheo
o`0057oo00<007ooOol01Goo00<007ooOol03goo30?o6goo11@O27oo0V@O17oo00=n@7ooOol02Goo
=0?ocWoo000DOol00`00Oomoo`05Ool3000AOolP0Il90ol551l50ol3I1l20ol2OT090oooOol3Ool0
01Aoo`03001oogoo00Eoo`03001oogoo00Uoo`P1Wb1oo`X1W`Aoo`DD7`=oo`=T7`03Oomn@7i00?mo
o`Yoo`0057oo00<007ooOol01Goo00<007ooOol00goo1P6O<Woo2@6O11@O0Woo0V@O00=oogi0Ool0
ogoo27oo000BOol30007Ool00`00Ool1W`030Im5Ool451l2I1l2OT050IooOol2Ool001Aoo`03001o
ogoo00Eoo`03001oogoo04aoo`<D7`03I1mn@7i000=oo`d1WoAoo`0077oo00<007ooOol0D7oo00@D
7f@OOT1n@0ioo`d1WnMoo`0077oo00<007ooOol0Dgoo00=T7gi0OT000Q@O5goo3@6OfWoo000LOol0
0`00Oomoo`1EOol00f@OOT1n@00551lOOol=0Io=Ool001aoo`03001oogoo05Moo`03I1mn@7i000=o
o`@D7bQoo`d1Wl1oo`0077oo00<007ooOol0FGoo00=T7gi0I1l01Goo1A@O<7oo3@6O/goo000LOol3
001KOol2OT000f@OOomoo`06Ool551lhOol=0InVOol001aoo`03001oogoo05eoo`9n@09T7`Yoo`@D
7d5oo`d1WiUoo`0077oo00<007ooOol0Ggoo0Wi00f@O2goo11@OBWoo3@6OS7oo000LOol00`00Oomo
o`1QOol2OT000gooI1mT7`0=Ool551mBOol=0ImoOol001aoo`03001oogoo06=oo`9n@004OomT7f@O
I1l?Ool651mIOol=0ImbOol001aoo`03001oogoo06Eoo`9n@09oo`=T7a9oo`HD7f1oo`d1WfEoo`00
77oo00<007ooOol0Igoo00=n@7ooOol00Woo16@O57oo11@OJGoo6P6OBgoo000LOol00`00Oomoo`1X
Ool2OT06Ool3I1lEOol451moOol=0IlnOol001aoo`03001oogoo06Yoo`9n@0Moo`=T7aIoo`DD7hMo
o`d1Wc5oo`0077oo0`00K7oo0Wi027oo0V@O6Goo11@OT7oo4`6O7Woo000LOol00`00Oomoo`1^Ool2
OT08Ool3I1lJOol451nmOol001aoo`03001oogoo071oo`9n@0Uoo`=T7a]oo`HD7kMoo`0077oo00<0
07ooOol0LWoo0Wi02Woo0V@O7goo1Q@O/Goo000LOol00`00Oomoo`1dOol00gi0Oomoo`09Ool3I1lR
Ool651n[Ool001aoo`03001oogoo07Eoo`9n@0aoo`9T7bIoo`@D7jMoo`0077oo00<007ooOol0Mgoo
0Wi037oo0f@O9goo11@OXgoo000LOol00`00Oomoo`1iOol00gi0Oomoo`0<Ool3I1lXOol651nMOol0
01aoo`03001oogoo07Yoo`9n@0moo`9T7baoo`HD7iMoo`0077oo0`00O7oo00=n@7ooOol03Woo0f@O
;goo1Q@OTGoo000LOol00`00Oomoo`1mOol2OT0AOol3I1lbOol451n=Ool001aoo`03001oogoo07mo
o`9n@19oo`AT7c9oo`@D7hUoo`0077oo00<007ooOol0PGoo00=n@7ooOol04goo0f@O<goo1Q@OPgoo
000LOol00`00Oomoo`22Ool2OT0FOol3I1lfOol651mmOol001aoo`03001oogoo08Aoo`9n@1Moo`9T
7cYoo`HD7gMoo`0077oo00<007ooOol0QWoo0Wi05goo0f@O?Goo11@OLgoo000LOol00`00Oomoo`28
Ool2OT0HOol3I1lnOol451m_Ool001aoo`03001oogoo08Yoo`9n@1Uoo`9T7d1oo`HD7fUoo`0077oo
00<007ooOol0S7oo0Wi06Goo0f@O@goo1Q@OHgoo000LOol3002>Ool00gi0Oomoo`0IOol2I1m7Ool7
51mLOol001aoo`03001oogoo08moo`9n@1]oo`9T7daoo`HD7eIoo`0077oo00<007ooOol0TGoo0Wi0
6goo0f@OCgoo1a@OCgoo000LOol00`00Oomoo`2COol2OT0LOol2I1mDOol651m9Ool001aoo`03001o
ogoo09Eoo`9n@1aoo`=T7eMoo`LD7d9oo`0077oo00<007ooOol0Ugoo0Wi07Goo16@OFWoo1Q@O?7oo
0002Ool50004Ool20005Ool40006Ool00`00Oomoo`2IOol2OT0OOol3I1mMOol751leOol000Aoo`03
001oogoo00Aoo`8000Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo09]oo`03OT1oogoo
01moo`AT7f1oo`HD7bmoo`0017oo00<007ooOol03goo00<007ooOol00goo00<007ooOol0W7oo0Wi0
8goo0f@OHgoo1Q@O:Goo0004Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool3002NOol2OT0TOol2I1mW
Ool451lUOol000Aoo`03001oogoo00]oo`@000Ioo`03001oogoo0:1oo`9n@2Aoo`=T7fQoo`@D7b5o
o`0017oo00<007ooOol02goo00<007ooOol01goo00<007ooOol0XWoo0Wi09Goo0f@OJGoo0a@O7Woo
0002Ool3000=Ool00`00Oomoo`07Ool00`00Oomoo`2TOol2OT0VOol2I1n8Ool000Aoo`03001oogoo
00]oo`D000Eoo`03001oogoo0:Ioo`9n@2Ioo`=T7hEoo`0077oo00<007ooOol0Z7oo00=n@7ooOol0
9Woo0f@OPWoo000LOol00`00Oomoo`2YOol2OT0YOol3I1moOol001aoo`03001oogoo0:]oo`9n@2Yo
o`=T7gaoo`0077oo00<007ooOol0[Goo00=n@7ooOol0:Woo0f@ONGoo000LOol3002^Ool2OT0]Ool3
I1mfOol001aoo`03001oogoo0;1oo`9n@2ioo`9T7gAoo`0077oo00<007ooOol0/Woo0Wi0;Woo0f@O
LGoo000LOol00`00Oomoo`2dOol00gi0Oomoo`0^Ool3I1m^Ool001aoo`03001oogoo0;Eoo`9n@35o
o`=T7f]oo`0077oo00<007ooOol0]goo0Wi0<Woo0f@OJ7oo000LOol00`00Oomoo`2iOol2OT0cOol4
I1mTOol001aoo`03001oogoo0;]oo`03OT1oogoo03Aoo`=T7f5oo`0077oo00<007ooOol0_7oo0Wi0
=goo0f@OGWoo000LOol00`00Oomoo`2nOol2OT0hOol3I1mKOol001aoo`<00<1oo`9n@3Uoo`AT7eMo
o`0077oo00<007ooOol0`Woo00=n@7ooOol0>Woo0f@OE7oo000LOol00`00Oomoo`33Ool2OT0mOol3
I1mAOol001aoo`03001oogoo0<Eoo`9n@3ioo`9T7dmoo`0077oo00<007ooOol0agoo0Wi0?Woo0f@O
C7oo000LOol00`00Oomoo`39Ool2OT0oOol3I1m9Ool001aoo`03001oogoo0<]oo`9n@41oo`9T7dMo
o`0077oo00<007ooOol0cGoo0Wi0@7oo0f@OA7oo000LOol00`00Oomoo`3?Ool00gi0Oomoo`10Ool3
I1m1Ool001aoo`<00=1oo`9n@4=oo`AT7ceoo`0077oo00<007ooOol0dWoo0Wi0AGoo0f@O>Woo000L
Ool00`00Oomoo`3DOol2OT16Ool2I1lhOol001aoo`03001oogoo0=Ioo`03OT1oogoo04Eoo`9T7cIo
o`00ogooMWoo003oOomfOol00?moogIoo`00ogooMWoo003oOomfOol00?moogIoo`00ogooMWoo003o
OomfOol00?moogIoo`00ogooMWoo003oOomfOol00?moogIoo`00ogooMWoo000JOol3003oOomIOol0
01]oo`03001oogoo0?mooeQoo`006goo00<007ooOol0ogooF7oo000KOol00`00Ool0003oOomHOol0
01]oo`<00?mooeQoo`006goo00<007oo0000ogooF7oo000KOol01@00Oomoogoo0000ogooEWoo000J
Ool6003oOomFOol00?moogIoo`00ogooMWoo003oOomfOol00?moogIoo`00ogooMWoo0000\
\>"],
  ImageRangeCache->{{{0, 372.75}, {230.25, 0}} -> {-0.183758, -0.350907, \
0.00798096, 0.0133897}}]
}, Open  ]],

Cell[TextData[{
  "The symbolic solution for the heat equation in the original coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is derived from the similarity solution by inverting the \
transformations:"
}], "Text",
  Evaluatable->False,
  CellTags->"heat equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(backrules = {\[Zeta] \[Rule] t\/x\^2, 
        F \[Rule] Function[\[Zeta], F[\[Zeta]]\ x\^c]}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\[Zeta] \[Rule] t\/x\^2, F \[Rule] Function[\[Zeta], F[\[Zeta]]\ x\^c]}
      \)], "Output"]
}, Open  ]],

Cell["\<\
The actual solution follows then by the resubstitution of the \
similarity representation:\
\>", "Text",
  Evaluatable->False,
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution = \(F[\[Zeta]] /. sheat\) /. backrules\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({\((x\^2\/t)\)\^\(1\/2 - c\/2\)\ C[1]\ 
          Hypergeometric1F1[1\/2 - c\/2, 3\/2, \(-\(x\^2\/\(4\ t\)\)\)] + 
        \((x\^2\/t)\)\^\(\(-c\)/2\)\ C[2]\ 
          Hypergeometric1F1[\(-\(c\/2\)\), 1\/2, \(-\(x\^2\/\(4\ t\)\)\)]}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In conclusion, we can say that a solution of a partial differential \
equation in two independent variables can be constructed by two invariants of \
the group. One of these two invariants becomes the new independent variable ",
  
  Cell[BoxData[
      \(TraditionalForm\`\[Zeta] = \[Zeta](x, t)\)]],
  ", the so-called similarity variable, and the other invariant plays the \
role of a dependent variable ",
  Cell[BoxData[
      \(TraditionalForm\`F(\[Zeta])\)]],
  ". The similarity representation of the solution is given by the relation"
}], "Text",
  Evaluatable->False,
  CellTags->{"similarity variable", "similarity representation"}],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalTheta]\  = \ H(x, t, F(\[Zeta]))\)], 
  "NumberedEquation"],

Cell[TextData[{
  "with the dependence of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " on ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["t",
    FontSlant->"Italic"],
  " and the arbitrary function ",
  Cell[BoxData[
      \(TraditionalForm\`F(\[Zeta])\)]],
  " known explicitly. The substitution of this similarity representation into \
the original equation results in an ordinary differential equation for ",
  Cell[BoxData[
      \(TraditionalForm\`F(\[Zeta])\)]],
  ".\[ThickSpace]\[EmptySquare]"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "Now we know the fundamental steps to reduce a PDE to an ODE if the \
symmetries of the PDE are given. The package ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " offers a function called ",
  StyleBox["LieReduction[], ", "MmaText"],
  "which allows us to reduce the number of independent variables by applying \
the above considerations. The function ",
  StyleBox["LieReduction[]", "MmaText"],
  " can be used to automatically derive the similarity representation of the \
heat equation and others. The information we need to set up the calculation \
are the equation, the dependent and independent variables, and two lists for \
the infinitesimals. The first list of the infinitesimals carries the \
information on the independent variables and the second carries the group \
structure of the dependent variables. The following example shows how the \
reduction for the scaling symmetry is derived for the heat equation:"
}], "Text",
  Evaluatable->False,
  CellTags->{"LieReduction[]", "similarity representation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1 = 
      LieReduction[{\[PartialD]\_t u[x, t] - \[PartialD]\_{x, 2}u[x, t]}, {
          u}, \n\t\t{x, t}, {x, 2\ t}, {c\ u}]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(t\/x\^2\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {\(u\ x\^\(-c\) - F\_1 == 0\)},
          {
            \(\(-x\^c\)\ 
                \((\(-c\)\ F\_1 + c\^2\ F\_1 - \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    6\ \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) - 
                    4\ c\ \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    4\ \[Zeta]\_1\%2\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\))
                  \)\n\t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The output of the function is a list containing the similarity variables \
as equations at the first position. The second part of the list contains the \
similarity representation of the solution. The third and last part of the \
resulting list contains the reduction of the original equation. Another \
example for the application of this function is given by the potential \
Burgers equation. We already determined the symmetries of the potential \
Burgers equation in S",
  ButtonBox["ection 5.4.4",
    ButtonData:>{"symmet5.nb", "potential Burgers equation"},
    ButtonStyle->"Hyperlink"],
  ". Using the results from there for the special group with ",
  StyleBox["k6=1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["ki=0",
    FontSlant->"Italic"],
  " for ",
  StyleBox["i",
    FontSlant->"Italic"],
  "\[NotEqual]6, we find"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "similarity variables", "similarity representation of the solution", 
    "reduction", "potential Burgers equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(red1 = 
      LieReduction[{
          \[PartialD]\_t u[x, t] + \((\[PartialD]\_x u[x, t])\)\^2 - 
            \[PartialD]\_{x, 2}u[x, t]}, \n
        \t\t{u}, {x, t}, {4\ t\ x, 4\ t\^2}, {2\ t + x\^2}]; 
    LTF[Flatten[red1]] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(t\/x\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/4\),
                    ScriptLevel->0], " ", 
                  RowBox[{"(", 
                    RowBox[{\(4\ u\), "-", 
                      StyleBox[\(x\^2\/t\),
                        ScriptLevel->0], "-", \(2\ Log[x]\)}], ")"}]}], "-", 
                \(F\_1\)}], "==", "0"}]},
          {
            \(\[Zeta]\_1\%2\ 
                \((3 - 12\ F1\_\(\[Zeta]\_1\)\ \[Zeta]\_1 + 
                    4\ F1\_\[Zeta]\_1\%2\ \[Zeta]\_1\%2 - 
                    4\ \[Zeta]\_1\%2\ F1\_\(\[Zeta]\_1, \[Zeta]\_1\))\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the reduction is a non-linear second-order ordinary \
differential equation which we can solve by using the function ",
  StyleBox["DSolve[]:", "MmaText"]
}], "Text",
  Evaluatable->False,
  CellTags->"DSolve[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solburgersp = 
      DSolve[red1\[LeftDoubleBracket]3, 1\[RightDoubleBracket] == 0, F1, 
        zeta1]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{F1 \[Rule] \((C[2] + \(3\ Log[#1]\)\/2 - Log[\(-1\) + #1\ C[1]]&)\)}}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The final solution of the potential Burgers equation follows by using the \
second part of the similarity reduction. Inserting the solution for ",
  Cell[BoxData[
      FormBox[
        StyleBox["F1",
          "InlineFormula",
          FontSlant->"Italic"], TraditionalForm]]],
  " into the similarity representation, we get a representation of the \
solution in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " coordinates,"
}], "Text",
  Evaluatable->False,
  CellTags->"similarity representation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution = 
      Flatten[red1\[LeftDoubleBracket]2\[RightDoubleBracket] /. solburgersp]
        \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({1\/4\ \((4\ u - x\^2\/t - 2\ Log[x])\) == 
        C[2] + 3\/2\ Log[t\/x] - Log[\(-1\) + \(t\ C[1]\)\/x]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Solving this relation with respect to ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we end up with the explicit solution of the potential Burgers equation \
in the form"
}], "Text",
  Evaluatable->False,
  CellTags->"solution of the potential Burgers equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solf = 
      Simplify[Solve[solution\[LeftDoubleBracket]1\[RightDoubleBracket], u]]
        \)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({{u \[Rule] 
          1\/4\ \((
              x\^2\/t + 4\ C[2] + 6\ Log[t\/x] + 2\ Log[x] - 
                4\ Log[\(-1\) + \(t\ C[1]\)\/x])\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
The solution of the chosen subgroup contains two constants of \
integration which have to be chosen in such a way that the initial and \
boundary conditions are satisfied.\
\>", "Text",
  Evaluatable->False],

Cell["Example 3", "Example"],

Cell[TextData[{
  "Another example of two coupled diffusion equations demonstrates the \
application of the function ",
  StyleBox["LieReduction[]", "MmaText"],
  " on a system of equations. The (1+1)-dimensional version of the equations \
of motion for the density ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and the density ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " are given by"
}], "Text",
  Evaluatable->False,
  CellTags->{"two coupled diffusion equations", "LieReduction[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(cdiffu = {\[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)v[x, t], \n\t\t
        \[PartialD]\_t v[x, t]\  - \[PartialD]\_\(x, x\)u[x, t]}; 
    cdiffu // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(u\_t - v\_\(x, x\) == 0\)},
          {\(v\_t - u\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The two equations allow a large symmetry group. The infinitesimals of this \
group follow by applying the function ",
  StyleBox["Infinitesimals[]", "MmaText"],
  ". The result reads"
}], "Text",
  Evaluatable->False,
  CellTags->{"infinitesimals", "Infinitesimals[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(icdiffu = 
      Infinitesimals[cdiffu, {u, v}, \n\t\t{x, t}, {}, 
        SubstitutionRules 
          \[Rule] {\[PartialD]\_t u[x, t], \[PartialD]\_t v[x, t]}]; 
    icdiffu // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(-\((\[ScriptCapitalF]\_2)\)\_t\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)},
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                \((\[ScriptCapitalF]\_2)\)\_\(x, x\) == 0\)},
          {\(\[Xi]\_1 == k6 + k7\ x - 2\ t\ \((k3 + k5\ x)\)\)},
          {\(\[Xi]\_2 == k1 + 2\ t\ \((k7 - k5\ t)\)\)},
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{\(\((k4 + k5\ t)\)\ u\), "+", 
                RowBox[{"v", " ", 
                  RowBox[{"(", 
                    RowBox[{"k2", "+", \(k3\ x\), "+", 
                      StyleBox[\(\(k5\ x\^2\)\/2\),
                        ScriptLevel->0]}], ")"}]}], "+", 
                \(\[ScriptCapitalF]\_1\)}]}]},
          {
            RowBox[{\(\[Phi]\_2\), "==", 
              RowBox[{\(\((k4 + k5\ t)\)\ v\), "+", 
                RowBox[{"u", " ", 
                  RowBox[{"(", 
                    RowBox[{"k2", "+", \(k3\ x\), "+", 
                      StyleBox[\(\(k5\ x\^2\)\/2\),
                        ScriptLevel->0]}], ")"}]}], "+", 
                \(\[ScriptCapitalF]\_2\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 2], x, x]], 0], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k6, 
            Times[ k7, x], 
            Times[ -2, t, 
              Plus[ k3, 
                Times[ k5, x]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ k1, 
            Times[ 2, t, 
              Plus[ k7, 
                Times[ -1, k5, t]]]]], 
        Equal[ 
          Subscript[ \[Phi], 1], 
          Plus[ 
            Times[ 
              Plus[ k4, 
                Times[ k5, t]], u], 
            Times[ v, 
              Plus[ k2, 
                Times[ k3, x], 
                Times[ 
                  Rational[ 1, 2], k5, 
                  Power[ x, 2]]]], 
            Subscript[ \[ScriptCapitalF], 1]]], 
        Equal[ 
          Subscript[ \[Phi], 2], 
          Plus[ 
            Times[ 
              Plus[ k4, 
                Times[ k5, t]], v], 
            Times[ u, 
              Plus[ k2, 
                Times[ k3, x], 
                Times[ 
                  Rational[ 1, 2], k5, 
                  Power[ x, 2]]]], 
            Subscript[ \[ScriptCapitalF], 2]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The two functions ",
  StyleBox["free[1]", "MmaText",
    FontSlant->"Italic"],
  " and ",
  StyleBox["free[2]", "MmaText",
    FontSlant->"Italic"],
  StyleBox[" ", "MmaText"],
  "satisfy the original equations and generate the infinite dimensional part \
of the group. The finite part of the group is represented by a \
seven-dimensional symmetry group. From this group, we select the subgroup \
with ",
  StyleBox["k4 = k7 = 1", "MmaText",
    FontSlant->"Italic"],
  " representing a scaling symmetry of the coupled equations:"
}], "Text",
  Evaluatable->False,
  CellTags->"symmetry group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(xinfi = 
      \({\(xi[1]\)[x, t, u, v], \(xi[2]\)[x, t, u, v]} /. \n\t\t
          icdiffu\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. \n
        \t\t{k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 1, 
          k5 \[Rule] 0, k6 \[Rule] 0, k7 \[Rule] 1}\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    \({x, 2\ t}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(uinfi = 
      \({\(phi[1]\)[x, t, u, v], \(phi[2]\)[x, t, u, v]} /. 
          icdiffu\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. \n
        \t\t{k1 \[Rule] 0, k2 \[Rule] 0, k3 \[Rule] 0, k4 \[Rule] 1, 
          k5 \[Rule] 0, k6 \[Rule] 0, k7 \[Rule] 1, \n\t\t\t
          \(free[1]\)[x, t] \[Rule] 0, \(free[2]\)[x, t] \[Rule] 0}\)], 
  "Input"],

Cell[BoxData[
    \({u, v}\)], "Output"]
}, Open  ]],

Cell["\<\
The reduction of the coupled diffusion equations for the scaling \
group follows then by\
\>", "Text",
  Evaluatable->False,
  CellTags->"reduction of the coupled diffusion equations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rcdiffu = LieReduction[cdiffu, {u, v}, {x, t}, {x, 2\ t}, {u, v}]; 
    LieTraditionalForm[rcdiffu] /. zeta1 \[Rule] \[Zeta]\_1 // TableForm\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
              StyleBox[\(t\/x\^2\),
                ScriptLevel->0], "==", \(\[Zeta]\_1\)}], "\<\"\"\>"},
          {
            RowBox[{
              StyleBox[\(u\/x\),
                ScriptLevel->0], "==", \(F\_1\)}], 
            RowBox[{
              StyleBox[\(v\/x\),
                ScriptLevel->0], "==", \(F\_2\)}]},
          {
            \(\((F\_1)\)\_\(\[Zeta]\_1\) - 
                2\ \[Zeta]\_1\ \((F\_2)\)\_\(\[Zeta]\_1\) - 
                4\ \[Zeta]\_1\%2\ \((F\_2)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0
              \), \(\(-2\)\ \[Zeta]\_1\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                \((F\_2)\)\_\(\[Zeta]\_1\) - 
                4\ \[Zeta]\_1\%2\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->2,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{
        Equal[ 
          Times[ t, 
            Power[ x, -2]], 
          Subscript[ \[Zeta], 1]]}, {
        Equal[ 
          Times[ u, 
            Power[ x, -1]], 
          Subscript[ F, 1]], 
        Equal[ 
          Times[ v, 
            Power[ x, -1]], 
          Subscript[ F, 2]]}, {
        Equal[ 
          Plus[ 
            Subscript[ 
              Subscript[ F, 1], 
              Subscript[ \[Zeta], 1]], 
            Times[ -2, 
              Subscript[ \[Zeta], 1], 
              Subscript[ 
                Subscript[ F, 2], 
                Subscript[ \[Zeta], 1]]], 
            Times[ -4, 
              Power[ 
                Subscript[ \[Zeta], 1], 2], 
              Subscript[ 
                Subscript[ F, 2], 
                Subscript[ \[Zeta], 1], 
                Subscript[ \[Zeta], 1]]]], 0], 
        Equal[ 
          Plus[ 
            Times[ -2, 
              Subscript[ \[Zeta], 1], 
              Subscript[ 
                Subscript[ F, 1], 
                Subscript[ \[Zeta], 1]]], 
            Subscript[ 
              Subscript[ F, 2], 
              Subscript[ \[Zeta], 1]], 
            Times[ -4, 
              Power[ 
                Subscript[ \[Zeta], 1], 2], 
              Subscript[ 
                Subscript[ F, 1], 
                Subscript[ \[Zeta], 1], 
                Subscript[ \[Zeta], 1]]]], 0]}}]]], "Output",
  FontSize->8]
}, Open  ]],

Cell[TextData[{
  "The derived coupled set of ordinary differential equations in ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F\_1\), "=", 
          StyleBox[
            RowBox[{
              StyleBox["F",
                FontSlant->"Italic"], "1"}]]}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F\_2\), "=", 
          StyleBox[
            RowBox[{
              StyleBox["F",
                FontSlant->"Italic"], "1"}]]}], TraditionalForm]]],
  " is not solved by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This is obvious from"
}], "Text",
  ShowCellBracket->True,
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[rcdiffu\[LeftDoubleBracket]3\[RightDoubleBracket], {F1, F2}, 
      zeta1]\)], "Input"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["F1", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}], "-", 
                RowBox[{"2", " ", "zeta1", " ", 
                  RowBox[{
                    SuperscriptBox["F2", "\[Prime]",
                      MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
                RowBox[{"4", " ", \(zeta1\^2\), " ", 
                  RowBox[{
                    SuperscriptBox["F2", "\[DoublePrime]",
                      MultilineFunction->None], "[", "zeta1", "]"}]}]}], 
              "==", "0"}], ",", 
            RowBox[{
              RowBox[{
                RowBox[{\(-2\), " ", "zeta1", " ", 
                  RowBox[{
                    SuperscriptBox["F1", "\[Prime]",
                      MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
                RowBox[{
                  SuperscriptBox["F2", "\[Prime]",
                    MultilineFunction->None], "[", "zeta1", "]"}], "-", 
                RowBox[{"4", " ", \(zeta1\^2\), " ", 
                  RowBox[{
                    SuperscriptBox["F1", "\[DoublePrime]",
                      MultilineFunction->None], "[", "zeta1", "]"}]}]}], 
              "==", "0"}]}], "}"}], ",", \({F1, F2}\), ",", "zeta1"}], 
      "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "However, this is not the end of the story. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " offers an alternate way: the numerical solution of the equation. The \
function ",
  StyleBox["NDSolve[]", "MmaText"],
  " is capable of handling this task. This function is beneficial in solving \
the reduced system of equations. In determining a numerical solution, it is \
mandatory that the equations be free of any parameters and that the initial \
conditions be added to the equations:"
}], "Text",
  Evaluatable->False,
  CellTags->{"NDSolve[]", "numerical solution", "initial conditions"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqat\  = \ rcdiffu\[LeftDoubleBracket]3\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["F1", "\[Prime]",
                MultilineFunction->None], "[", "zeta1", "]"}], "-", 
            RowBox[{"2", " ", "zeta1", " ", 
              RowBox[{
                SuperscriptBox["F2", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
            RowBox[{"4", " ", \(zeta1\^2\), " ", 
              RowBox[{
                SuperscriptBox["F2", "\[DoublePrime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", "zeta1", " ", 
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["F2", "\[Prime]",
                MultilineFunction->None], "[", "zeta1", "]"}], "-", 
            RowBox[{"4", " ", \(zeta1\^2\), " ", 
              RowBox[{
                SuperscriptBox["F1", "\[DoublePrime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
          "0"}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
 For the initial conditions, we choose the following \
relations:\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"initials", "=", 
        RowBox[{"{", 
          RowBox[{\(F1[1] ==  .1\), ",", \(F2[1] ==  .2\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "1", "]"}], "==", 
              \(- .1\)}], ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["F2", "\[Prime]",
                  MultilineFunction->None], "[", "1", "]"}], "==", 
              \(-0.5\)}]}], "}"}]}], ";"}]], "Input"],

Cell[TextData[{
  "setting the function values at ",
  StyleBox["zeta1=1",
    FontSlant->"Italic"],
  " and the derivatives to certain constants. These four equations are joined \
with the list of equations ",
  StyleBox["eqat",
    FontSlant->"Italic"],
  ":"
}], "Text",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqat = Join[eqat, initials]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["F1", "\[Prime]",
                MultilineFunction->None], "[", "zeta1", "]"}], "-", 
            RowBox[{"2", " ", "zeta1", " ", 
              RowBox[{
                SuperscriptBox["F2", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "-", 
            RowBox[{"4", " ", \(zeta1\^2\), " ", 
              RowBox[{
                SuperscriptBox["F2", "\[DoublePrime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
          "0"}], ",", 
        RowBox[{
          RowBox[{
            RowBox[{\(-2\), " ", "zeta1", " ", 
              RowBox[{
                SuperscriptBox["F1", "\[Prime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["F2", "\[Prime]",
                MultilineFunction->None], "[", "zeta1", "]"}], "-", 
            RowBox[{"4", " ", \(zeta1\^2\), " ", 
              RowBox[{
                SuperscriptBox["F1", "\[DoublePrime]",
                  MultilineFunction->None], "[", "zeta1", "]"}]}]}], "==", 
          "0"}], ",", 
        RowBox[{\(F1[1]\), "==", 
          StyleBox["0.1`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1]}], ",", 
        RowBox[{\(F2[1]\), "==", 
          StyleBox["0.2`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["F1", "\[Prime]",
              MultilineFunction->None], "[", "1", "]"}], "==", 
          RowBox[{"-", 
            StyleBox["0.1`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["F2", "\[Prime]",
              MultilineFunction->None], "[", "1", "]"}], "==", 
          RowBox[{"-", 
            StyleBox["0.5`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The complete list of equations and initial conditions is now used in the \
numerical integration for ",
  StyleBox["zeta1",
    FontSlant->"Italic"],
  " in the range ",
  StyleBox["1\[LessEqual] zeta1\[LessEqual]50",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  CellTags->"numerical integration"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nsolve = NDSolve[eqat, {F1, F2}, {zeta1, 1, 50}]\)], "Input",
  PageWidth->Infinity],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"F1", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{1.`, 50.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"F2", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{1.`, 50.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
The numerical solution is represented by an interpolating function. \
We can use the representations to plot the solution:\
\>", "Text",
  Evaluatable->False,
  CellTags->"interpolating function"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[{F1[x], F2[x]} /. nsolve], {x, 1, 50}, \n\t
      PlotStyle 
        \[Rule] {RGBColor[1.000, 0.000, 0.000], \n\t\t\t
          RGBColor[0.000, 0.000, 1.000]}, \n\t
      AxesLabel 
        \[Rule] {\*"\"\<\!\(\[Zeta]\_1\)\>\"", 
          \*"\"\<\!\(F\_1\),\!\(F\_2\)\>\""}]\)], "Input",
  PageWidth->Infinity],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0190476 0.585155 0.0908215 [
[.21429 .57265 -6 -9 ]
[.21429 .57265 6 0 ]
[.40476 .57265 -6 -9 ]
[.40476 .57265 6 0 ]
[.59524 .57265 -6 -9 ]
[.59524 .57265 6 0 ]
[.78571 .57265 -6 -9 ]
[.78571 .57265 6 0 ]
[.97619 .57265 -6 -9 ]
[.97619 .57265 6 0 ]
[1.025 .58515 0 -7.5 ]
[1.025 .58515 15 7.5 ]
[.01131 .04023 -12 -4.5 ]
[.01131 .04023 0 4.5 ]
[.01131 .13105 -12 -4.5 ]
[.01131 .13105 0 4.5 ]
[.01131 .22187 -12 -4.5 ]
[.01131 .22187 0 4.5 ]
[.01131 .31269 -12 -4.5 ]
[.01131 .31269 0 4.5 ]
[.01131 .40351 -12 -4.5 ]
[.01131 .40351 0 4.5 ]
[.01131 .49433 -12 -4.5 ]
[.01131 .49433 0 4.5 ]
[.02381 .64303 -16 0 ]
[.02381 .64303 16 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.21429 .58515 m
.21429 .5914 L
s
[(10)] .21429 .57265 0 1 Mshowa
.40476 .58515 m
.40476 .5914 L
s
[(20)] .40476 .57265 0 1 Mshowa
.59524 .58515 m
.59524 .5914 L
s
[(30)] .59524 .57265 0 1 Mshowa
.78571 .58515 m
.78571 .5914 L
s
[(40)] .78571 .57265 0 1 Mshowa
.97619 .58515 m
.97619 .5914 L
s
[(50)] .97619 .57265 0 1 Mshowa
.125 Mabswid
.0619 .58515 m
.0619 .5889 L
s
.1 .58515 m
.1 .5889 L
s
.1381 .58515 m
.1381 .5889 L
s
.17619 .58515 m
.17619 .5889 L
s
.25238 .58515 m
.25238 .5889 L
s
.29048 .58515 m
.29048 .5889 L
s
.32857 .58515 m
.32857 .5889 L
s
.36667 .58515 m
.36667 .5889 L
s
.44286 .58515 m
.44286 .5889 L
s
.48095 .58515 m
.48095 .5889 L
s
.51905 .58515 m
.51905 .5889 L
s
.55714 .58515 m
.55714 .5889 L
s
.63333 .58515 m
.63333 .5889 L
s
.67143 .58515 m
.67143 .5889 L
s
.70952 .58515 m
.70952 .5889 L
s
.74762 .58515 m
.74762 .5889 L
s
.82381 .58515 m
.82381 .5889 L
s
.8619 .58515 m
.8619 .5889 L
s
.9 .58515 m
.9 .5889 L
s
.9381 .58515 m
.9381 .5889 L
s
.25 Mabswid
0 .58515 m
1 .58515 L
s
gsave
1.025 .58515 -61 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(z) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
.02381 .04023 m
.03006 .04023 L
s
[(-6)] .01131 .04023 1 0 Mshowa
.02381 .13105 m
.03006 .13105 L
s
[(-5)] .01131 .13105 1 0 Mshowa
.02381 .22187 m
.03006 .22187 L
s
[(-4)] .01131 .22187 1 0 Mshowa
.02381 .31269 m
.03006 .31269 L
s
[(-3)] .01131 .31269 1 0 Mshowa
.02381 .40351 m
.03006 .40351 L
s
[(-2)] .01131 .40351 1 0 Mshowa
.02381 .49433 m
.03006 .49433 L
s
[(-1)] .01131 .49433 1 0 Mshowa
.125 Mabswid
.02381 .05839 m
.02756 .05839 L
s
.02381 .07655 m
.02756 .07655 L
s
.02381 .09472 m
.02756 .09472 L
s
.02381 .11288 m
.02756 .11288 L
s
.02381 .14921 m
.02756 .14921 L
s
.02381 .16738 m
.02756 .16738 L
s
.02381 .18554 m
.02756 .18554 L
s
.02381 .2037 m
.02756 .2037 L
s
.02381 .24003 m
.02756 .24003 L
s
.02381 .2582 m
.02756 .2582 L
s
.02381 .27636 m
.02756 .27636 L
s
.02381 .29453 m
.02756 .29453 L
s
.02381 .33085 m
.02756 .33085 L
s
.02381 .34902 m
.02756 .34902 L
s
.02381 .36718 m
.02756 .36718 L
s
.02381 .38535 m
.02756 .38535 L
s
.02381 .42168 m
.02756 .42168 L
s
.02381 .43984 m
.02756 .43984 L
s
.02381 .458 m
.02756 .458 L
s
.02381 .47617 m
.02756 .47617 L
s
.02381 .5125 m
.02756 .5125 L
s
.02381 .53066 m
.02756 .53066 L
s
.02381 .54883 m
.02756 .54883 L
s
.02381 .56699 m
.02756 .56699 L
s
.02381 .02206 m
.02756 .02206 L
s
.02381 .0039 m
.02756 .0039 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -77 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
69.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
73.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(,) show
79.562500 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(F) show
85.562500 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
90.125000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.04286 .59424 m
.08072 .57392 L
.12201 .55468 L
.16079 .53919 L
.19809 .52592 L
.23779 .51309 L
.276 .5017 L
.31662 .49043 L
.35575 .48023 L
.39339 .47094 L
.43344 .46153 L
.47201 .45286 L
.50908 .44487 L
.54857 .43666 L
.58656 .42904 L
.62696 .4212 L
.66588 .41389 L
.70331 .40706 L
.74314 .39998 L
.78149 .39334 L
.82224 .38647 L
.8615 .38 L
.89928 .37392 L
.93946 .36759 L
.97619 .36192 L
s
0 0 1 r
.04286 .60332 m
.06129 .5661 L
.08072 .53532 L
.12201 .48338 L
.15931 .44506 L
.19901 .40959 L
.23722 .379 L
.27784 .34932 L
.31697 .32286 L
.35461 .29901 L
.39466 .27507 L
.43323 .2532 L
.4703 .23311 L
.50979 .21261 L
.54778 .19365 L
.58818 .17422 L
.6271 .15615 L
.66453 .13931 L
.70436 .12191 L
.74271 .10564 L
.78346 .08881 L
.82272 .07302 L
.8605 .05818 L
.90068 .04276 L
.93938 .02824 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  Evaluatable->False,
  TextAlignment->Center,
  ImageSize->{250.75, 154.875},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004i0000`A000`40O003h00O5Goo00<007ooOol0
ogoo8Woo000EOol2003oOolSOol001Eoo`03001oogoo0?moob9oo`005Goo00<007ooOol0ogoo8Woo
000EOol00`00Oomoo`3mOol201lROol001Eoo`03001oogoo0?]oo`807bAoo`005Goo0P00nWoo0P0O
9Woo000EOol00`00Oomoo`3gOol201lXOol000eoo`<000Eoo`03001oogoo0?Aoo`<07bYoo`0037oo
00D007ooOomoo`0000Aoo`03001oogoo0?1oo`@07beoo`0037oo00D007ooOomoo`0000Aoo`03001o
ogoo0>aoo`@07c5oo`000goo1P000goo00D007ooOomoo`0000Aoo`<00>Uoo`<07cEoo`0037oo1000
1Goo00<007ooOol0igoo0P0O>7oo000<Ool00`00Oomoo`06Ool00`00Oomoo`3UOol201ljOol000eo
o`03001oogoo00Eoo`03001oogoo0>=oo`807caoo`003Woo0`0017oo00<007ooOol0hGoo0P0O?Woo
000EOol2003OOol301m0Ool001Eoo`03001oogoo0=aoo`807d=oo`005Goo00<007ooOol0fGoo0`0O
AGoo000EOol00`00Oomoo`3GOol201m8Ool001Eoo`03001oogoo0=Aoo`<07dYoo`005Goo0P00dWoo
0`0OCGoo000EOol00`00Oomoo`3?Ool201m@Ool001Eoo`03001oogoo0<aoo`<07e9oo`005Goo00<0
07ooOol0bGoo0`0OEGoo000EOol00`00Oomoo`36Ool301mHOol001Eoo`800<Eoo`807e]oo`005Goo
00<007ooOol0`Goo0`0OGGoo000EOol00`00Oomoo`2oOol201mPOol001Eoo`03001oogoo0;eoo`80
7f9oo`005Goo0P00_7oo0P0OI7oo000EOol00`00Oomoo`2iOol201mVOol000aoo`@000Eoo`03001o
ogoo0;Moo`807fQoo`002goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0]7oo0`0OJWoo
000@Ool00`00Oomoo`02Ool00`00Oomoo`2bOol201m]Ool000=oo`H000Moo`03001oogoo009oo`<0
0;1oo`807fmoo`0037oo10001Goo00<007ooOol0[Woo0P0OLGoo000<Ool00`00Oomoo`06Ool00`00
Oomoo`2/Ool201mcOol000aoo`03001oogoo00Ioo`03001oogoo0:Uoo`<07gEoo`0037oo1@0017oo
00<007ooOol0Ygoo0P0ON7oo000EOol2002UOol301mjOol001Eoo`03001oogoo0:9oo`807geoo`00
5Goo00<007ooOol0X7oo0P0OOgoo000EOol00`00Oomoo`2NOol201n1Ool001Eoo`03001oogoo09ao
o`807h=oo`005Goo0P00Vgoo0P0OQGoo000EOol00`00Oomoo`2HOol201n7Ool001Eoo`03001oogoo
09Eoo`<07hUoo`005Goo00<007ooOol0Tgoo0P0OS7oo000EOol00`00Oomoo`2AOol201n>Ool001Eo
o`80091oo`807i1oo`005Goo00<007ooOol0SGoo0P0OTWoo000EOol00`00Oomoo`2:Ool301nDOol0
01Eoo`03001oogoo08Qoo`807iMoo`005Goo00<007ooOol0QWoo0P0OVGoo000EOol20025Ool201nK
Ool001Eoo`03001oogoo089oo`807ieoo`003Woo0`0017oo00<007ooOol0P7oo0P0OWgoo000?Ool0
0`00Oomoo`03Ool00`00Oomoo`1nOol201nQOol000moo`03001oogoo00=oo`03001oogoo07aoo`80
7j=oo`000goo1P000Woo1P0017oo0`00Ngoo00<07gooOol0Xgoo000<Ool01000Oomoo`001Goo00<0
07ooOol0NGoo0P0OYWoo000<Ool01000Oomoo`001Goo00<007ooOol0Mgoo0P0OZ7oo000=Ool00`00
Ool00005Ool00`00Oomoo`1fOol00`0OOomoo`2XOol000ioo`8000Eoo`03001oogoo07Aoo`807j]o
o`005Goo0P00Lgoo0P0O[Goo000EOol00`00Oomoo`1`Ool201n_Ool001Eoo`03001oogoo06ioo`80
7k5oo`005Goo00<007ooOol0K7oo0P0O/goo000EOol00`00Oomoo`1ZOol201neOol001Eoo`8006Uo
o`807kMoo`005Goo00<007ooOol0IWoo0P0O^Goo000EOol00`00Oomoo`1TOol201nkOol001Eoo`03
001oogoo069oo`807keoo`005Goo00<007ooOol0HGoo00<07gooOol0_Goo000EOol2001POol201o0
Ool001Eoo`03001oogoo05ioo`0301moogoo0<1oo`005Goo00<007ooOol0G7oo0P0O`goo000EOol0
0`00Oomoo`1JOol201o5Ool001Eoo`03001oogoo05Uoo`0301moogoo0<Eoo`005Goo0P00F7oo0P0O
b7oo000<Ool30006Ool00`00Oomoo`1FOol00`0OOomoo`38Ool000]oo`05001oogooOol00005Ool0
0`00Oomoo`1DOol201o;Ool000moo`03001oogoo00=oo`03001oogoo059oo`807leoo`000goo1P00
1Woo00<007ooOol00goo0`00DGoo00<07gooOol0cGoo000=Ool20006Ool00`00Oomoo`1?Ool201o@
Ool000moo`03001oogoo00=oo`03001oogoo04eoo`807m9oo`002goo00D007ooOomoo`0000Eoo`03
001oogoo04aoo`0301moogoo0=9oo`0037oo0`001Woo00<007ooOol0BWoo0P0OeGoo000EOol2001:
Ool00`0OOomoo`3EOol001Eoo`03001oogoo04Qoo`0301moogoo0=Ioo`005Goo00<007ooOol0AWoo
0P0OfGoo000EOol00`00Oomoo`15Ool00`0OOomoo`3IOol001Eoo`03001oogoo04=oo`807maoo`00
5Goo0P00@goo00<07gooOol0g7oo000EOol00`00Oomoo`10Ool201oOOol001Eoo`03001oogoo03mo
o`0301moogoo0=moo`005Goo00<007ooOol0?Woo00<07gooOol0h7oo000EOol00`00Oomoo`0lOol2
01nlOol5O00ROol001Eoo`8003aoo`0301moogoo0;Eoo`Ml02Moo`005Goo00<007ooOol0>Woo00<0
7gooOol0/7oo1W`0;Woo000EOol00`00Oomoo`0hOol201n^Ool5O00dOol001Eoo`03001oogoo03Mo
o`0301moogoo0:Qoo`Il03Uoo`005Goo00<007ooOol0=Woo00<07gooOol0XWoo1g`0?goo000EOol2
000eOol201nMOol8O016Ool001Eoo`03001oogoo03=oo`0301moogoo09Moo`Il04ioo`002goo1@00
1Goo00<007ooOol0<Woo00<07gooOol0Tgoo1G`0E7oo000;Ool01@00Oomoogoo00001Goo00<007oo
Ool0<Goo00<07gooOol0SWoo1W`0FGoo000<Ool00`00Oomoo`06Ool00`00Oomoo`0`Ool00`0OOomo
o`2:Ool5O01OOol000=oo`H000Aoo`03001oogoo00Eoo`<002ioo`807hQoo`El06Aoo`003Woo00<0
07ooOol017oo00<007ooOol0;Goo00<07gooOol0Pgoo1G`0JGoo000?Ool00`00Oomoo`03Ool00`00
Oomoo`0/Ool00`0OOomoo`1oOol5O01^Ool000]oo`05001oogooOol00005Ool00`00Oomoo`0[Ool0
0`0OOomoo`1kOol5O01cOol000aoo`<000Ioo`03001oogoo02Yoo`0301moogoo07Ioo`Il07Qoo`00
5Goo0P00:Woo00<07gooOol0LWoo1G`0OWoo000EOol00`00Oomoo`0XOol00`0OOomoo`1]Ool6O023
Ool001Eoo`03001oogoo02Ioo`807f]oo`El08Uoo`005Goo00<007ooOol09Goo00<07gooOol0IWoo
1G`0SWoo000EOol00`00Oomoo`0TOol00`0OOomoo`1ROol5O02COol001Eoo`8002Aoo`0301moogoo
05eoo`Il09Qoo`005Goo00<007ooOol08Woo00<07gooOol0FGoo1G`0WWoo000EOol00`00Oomoo`0Q
Ool00`0OOomoo`1EOol5O02SOol001Eoo`03001oogoo021oo`0301moogoo059oo`Al0:Qoo`005Goo
00<007ooOol07goo00<07gooOol0D7oo0g`0[7oo000EOol2000OOol00`0OOomoo`1=Ool4O02_Ool0
01Eoo`03001oogoo01eoo`0301moogoo04Yoo`Al0;=oo`005Goo00<007ooOol07Goo00<07gooOol0
A7oo1W`0]goo000EOol00`00Oomoo`0LOol00`0OOomoo`11Ool4O02mOol001Eoo`03001oogoo01]o
o`0301moogoo03moo`=l0<5oo`005Goo0P006goo00<07gooOol0?7oo17`0a7oo000EOol00`00Oomo
o`0IOol00`0OOomoo`0iOol4O038Ool000aoo`D000Aoo`03001oogoo01Qoo`0301moogoo03Aoo`Il
0<aoo`003Woo00<007ooOol017oo00<007ooOol05goo00<07gooOol0<Goo17`0dWoo000>Ool00`00
Oomoo`04Ool00`00Oomoo`0FOol00`0OOomoo`0_Ool3O03FOol000=oo`H000Eoo`03001oogoo00Ao
o`<001Eoo`0301moogoo02ioo`9l0=Uoo`003Woo00<007ooOol017oo00<007ooOol05Goo00<07goo
Ool0:goo0g`0fgoo000>Ool00`00Oomoo`04Ool00`00Oomoo`0DOol00`0OOomoo`0YOol3O03NOol0
00aoo`<000Ioo`03001oogoo01=oo`0301moogoo02Moo`=l0>5oo`003Woo00<007ooOol017oo0P00
4goo00<07gooOol097oo17`0i7oo000EOol00`00Oomoo`0AOol00`0OOomoo`0ROol3O03XOol001Eo
o`03001oogoo011oo`0301moogoo01moo`Al0>]oo`005Goo00<007ooOol03goo00<07gooOol077oo
17`0kgoo000EOol00`00Oomoo`0?Ool00`0OOomoo`0IOol3O03cOol001Eoo`8000moo`0301moogoo
01Qoo`9l0?Ioo`005Goo00<007ooOol03Goo00<07gooOol05Woo0g`00Woo1@000goo10009Woo1@00
17oo10009goo0`001Goo1000:Woo0`000goo10009goo100017oo10007Goo000EOol00`00Oomoo`0<
Ool00`0OOomoo`0EOol2O007Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0SOol01@00
Oomoogoo00000goo00<007ooOol00Woo00<007ooOol08goo00D007ooOomoo`0000=oo`03001oogoo
009oo`03001oogoo02Qoo`05001oogooOol00004Ool00`00Oomoo`0SOol00`00Oomoo`02Ool01000
Oomoo`0017oo00<007ooOol06Woo000EOol00`00Oomoo`0;Ool00`0OOomoo`0COol3O009Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0TOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`00
Oomoo`0WOol01@00Oomoogoo000017oo00<007ooOol0:7oo00D007ooOomoo`0000Aoo`03001oogoo
02Qoo`04001oogoo0004Ool00`00Oomoo`0JOol001Eoo`03001oogoo00]oo`0301moogoo015oo`9l
00aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo00=oo`03001oogoo
009oo`03001oogoo02Moo`05001oogooOol00004Ool00`00Oomoo`0TOol60002Ool00`00Oomoo`02
Ool00`00Oomoo`0XOol01000Oomoo`0017oo00<007ooOol06Woo000EOol2000;Ool00`0OOomoo`0?
Ool3O00>Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0VOol00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`0UOol20004Ool00`00Oomoo`02Ool00`00Oomoo`0UOol01000Oomoo`00
0goo00<007ooOol00Woo00<007ooOol097oo10000goo00<007ooOol00Woo00<007ooOol06Woo000E
Ool00`00Oomoo`09Ool00`0OOomoo`0>Ool2O00AOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`0WOol01@00Oomoogoo000017oo00<007ooOol09goo00D007ooOomoo`0000Aoo`03001oogoo
02Eoo`04001oogoo0003Ool00`00Oomoo`02Ool00`00Oomoo`0TOol00`00Oomoo`04Ool00`00Oomo
o`02Ool00`00Oomoo`0JOol001Eoo`03001oogoo00Uoo`0301moogoo00]oo`=l015oo`<000Aoo`03
001oogoo009oo`03001oogoo02=oo`05001oogooOol00003Ool00`00Oomoo`02Ool00`00Oomoo`0S
Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol09Woo00<007oo00000goo00<007oo
Ool00Woo00<007ooOol097oo00<007ooOol017oo00<007ooOol00Woo00<007ooOol06Woo000EOol0
0`00Oomoo`08Ool00`0OOomoo`0:Ool2O00FOol00`00Oomoo`03Ool4000WOol30005Ool4000WOol3
0005Ool4000ZOol20004Ool4000WOol50003Ool4000MOol001Eoo`03001oogoo00Qoo`0301moogoo
00Qoo`9l0?moo`eoo`005Goo0P0027oo00<07gooOol01Woo0g`0o7oo10000goo1@001Woo000EOol0
0`00Oomoo`06Ool00`0OOomoo`05Ool2O03nOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`06Ool001Eoo`03001oogoo00Ioo`0301moogoo00=oo`9l0?moo`=oo`<000Eoo`03001oogoo00Io
o`005Goo00<007ooOol01Goo00<07gooOol00Woo0W`0ogoo17oo00<007ooOol01Woo00<007ooOol0
1Woo000EOol00`00Oomoo`05Ool00`0OOomoo`02O03oOol6Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool000moo`d0000401l00000O03n0009Ool00`00Oomoo`05Ool20008Ool001Eoo`03001oogoo00Ao
o`0401ml07`0000:Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`0?
Ool00`00Oomoo`0>Ool001Eoo`03001oogoo00=oo`0301ml07oo02]oo`03001oogoo031oo`03001o
ogoo031oo`03001oogoo035oo`03001oogoo031oo`03001oogoo011oo`<000eoo`005Goo00<007oo
Ool00Woo00=l000OOol0ogoo37oo0P000Woo00<007ooOol02Woo000EOol00`00Oomoo`02Ool00`0O
Oomoo`3oOol>Ool3000<Ool001Eoo`8000=oo`0301moogoo0?mooaeoo`005Goo00<007ooOol0ogoo
8Woo000EOol00`00Oomoo`3oOolROol001Eoo`03001oogoo0?moob9oo`005Goo00<007ooOol0ogoo
8Woo003oOoljOol00?moocYoo`00ogoo>Woo003oOoljOol00?moocYoo`00ogoo>Woo003oOoljOol0
0?moocYoo`00ogoo>Woo003oOoljOol000]oo`D000=oo`03001oogoo00]oo`<00?mooaIoo`003Goo
00<007ooOol00goo0P0037oo00<007ooOol0ogoo5Woo0005Ool30005Ool00`00Oomoo`04Ool00`00
Oomoo`02Ool30006Ool00`00Oomoo`3oOolEOol000Ioo`03001oogoo00Aoo`03001oogoo00Aoo`80
00Aoo`03001oogoo00Eoo`03001oogoo0?mooaEoo`001Woo00<007ooOol017oo00<007ooOol02Woo
00<007ooOol017oo00<007oo0000ogoo5Woo0006Ool00`00Ool00003Ool2000<Ool00`00Ool00005
Ool00`00Oomoo`3oOolEOol000Ioo`<0015oo`<00?mooaeoo`001Woo00<007oo00004Goo00<007oo
0000ogoo7Goo0006Ool01@00Oomoogoo00003goo00D007ooOomoo`000?mooa]oo`001Goo1P003Woo
1P00ogoo6goo003oOoljOol00?moocYoo`00ogoo>Woo003oOoljOol00?moocYoo`00\
\>"],
  ImageRangeCache->{{{0, 312.438}, {192.563, 0}} -> {-4.18233, -6.44295, \
0.242786, 0.0509185}}]
}, Open  ]],

Cell[TextData[{
  "The utilization of the numerical capabilities of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allows us to examine the solution of the reduced equations for a limited \
range in ",
  StyleBox["zeta1",
    FontSlant->"Italic"],
  " and for a special choice of initial values. This numerical representation \
of the solution compared with an analytic solution is far from being \
complete. An analytic solution, if we found one, is valid for all initial \
conditions and unlimited in the range of the independent variable. So \
numerical solution can only show us the behavior for a specific case of \
initial conditions.\[ThickSpace]\[EmptySquare]"
}], "Text",
  CellTags->"analytic solution"],

Cell["Example 4", "Example"],

Cell[TextData[{
  "Another problem also handled by the function ",
  StyleBox["LieReduction[]", "MmaText"],
  " is the reduction of partial differential equations in more than two \
independent variables. Such a case is given by the ",
  ButtonBox["Karpman-Belashov",
    ButtonData:>{"Literat.nb", "Karp-91"},
    ButtonStyle->"Hyperlink"],
  " equation (KB) (",
  ButtonBox["Karpman and Belashov [1991]",
    ButtonData:>{"Literat.nb", "Karp-91"},
    ButtonStyle->"Hyperlink"],
  ")"
}], "Text",
  Evaluatable->False,
  CellTags->{"LieReduction[]", "Karpman-Belashov equation"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"6", " ", 
            FormBox[\(u\_x\%2\),
              "TraditionalForm"]}], " ", "+", " ", \(u\_\(x, t\)\), " ", "+", 
          " ", \(6\ u\ u\_\(x, x\)\), "-", \(u\_\(y, y\)\), "-", 
          \(\[Mu]\ u\_\(x, x, x\)\), "-", \(\[Epsilon]\ u\_\(x, x, x, x\)\), 
          "-", \(\[Lambda]\ u\_\(x, x, x, x, x, x\)\)}], "=", "0."}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[
"The KB equation contains the Zabolotskaya-Khoklov equation (ZK) with \
\[Epsilon] = 0 and \[Lambda] = 0, and the Kadomtsev-Petviashvili equation \
(KP) with \[Mu] = 0 and \[Lambda] = 0. The KB-equation is used to model \
two-dimensional solitons and wave packages in weakly dispersive and \
dissipative media. Karpman and Belashov studied this type of equation \
numerically. We will examine here the algebraic properties of the equation. \
Especially, we will examine the ZK equation and the corresponding analytical \
solutions. First, let us determine the symmetries of the  KB equation"], 
  "Text",
  Evaluatable->False,
  CellTags->{
  "Zabolotskaya-Khoklov equation", "KB-equation", 
    "Kadomtsev-Petviashvili equation", 
    "wave in weakly dispersive and dissipative media", "ZK-equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(karp = {
        \[PartialD]\_x\((
              \[PartialD]\_t u[x, y, t] + 
                6\ u[x, y, t]\ \[PartialD]\_x u[x, y, t] - \ \n\t\t\t\t
                \[Mu]\ \[PartialD]\_{x, 2}u[x, y, t] - 
                \[Epsilon]\ \[PartialD]\_{x, 3}u[x, y, t] - \n\t\t\t\t\t
                \[Lambda]\ \[PartialD]\_{x, 5}u[x, y, t])\) - 
          \[PartialD]\_{y, 2}u[x, y, t]}; karp // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(6\ u\_x\%2 + u\_\(x, t\) + 6\ u\ u\_\(x, x\) - u\_\(y, y\) - 
                \[Mu]\ u\_\(x, x, x\) - \[Epsilon]\ u\_\(x, x, x, x\) - 
                \[Lambda]\ u\_\(x, x, x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[
"The three parameters \[Lambda], \[Mu], and \[Epsilon] are real constants. \
The infinitesimals of the KB equation follow by"], "Text",
  Evaluatable->False,
  CellTags->{"KB-equation", "infinitesimals of the KB-equation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ikarp = 
      Infinitesimals[karp, {u}, {x, y, t}, {\[Mu], \[Epsilon], \[Lambda]}]; 
    ikarp // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/12\),
                  ScriptLevel->0], " ", 
                \((2\ \((\[ScriptCapitalF]\_2)\)\_t + 
                    y\ \((\[ScriptCapitalF]\_1)\)\_\(t, t\))\)}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", "y", " ", 
                  \(\((\[ScriptCapitalF]\_1)\)\_t\)}]}]}]},
          {\(\[Xi]\_2 == \[ScriptCapitalF]\_1\)},
          {\(\[Xi]\_3 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 12], 
            Plus[ 
              Times[ 2, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t]], 
              Times[ y, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t, t]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ 1, 2], y, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Xi], 3], k1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the calculation is an infinite dimensional symmetry group \
determined by two arbitrary functions ",
  Cell[BoxData[
      RowBox[{
        RowBox[{
          StyleBox[\(\[ScriptCapitalF]\_1\),
            FontFamily->"Times",
            FontSize->10,
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            PrivateFontOptions->{"FontPostScriptName"->Automatic}], "="}], 
        " "}]]],
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " and ",
  Cell[BoxData[
      RowBox[{
        RowBox[{
          StyleBox[\(\[ScriptCapitalF]\_2\),
            FontFamily->"Times",
            FontSize->10,
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            PrivateFontOptions->{"FontPostScriptName"->Automatic}], "="}], 
        " "}]]],
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["2", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  StyleBox[".",
    FontSlant->"Italic"],
  " These two functions determine the transformation of the ",
  Cell[BoxData[
      \(TraditionalForm\`y, x\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " coordinates. We also observe that the group is free of any system \
parameter \[Lambda], \[Epsilon], and \[Mu]. The two arbitrary functions ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " and",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["2", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " do not have to satisfy any other equations. Thus, we can choose them \
individually. If we assume, for example, that these functions are given by \
two constants ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["free",
                FontSlant->"Italic"], 
              StyleBox["[",
                "MmaText"], 
              StyleBox["1",
                "MmaText"], 
              StyleBox["]",
                "MmaText"]}], 
            StyleBox["[",
              "MmaText"], 
            StyleBox["t",
              "MmaText"], 
            StyleBox["]",
              "MmaText"]}], 
          StyleBox[" ",
            "MmaText"], 
          StyleBox["=",
            "MmaText"], 
          StyleBox[" ",
            "MmaText"], 
          StyleBox["k2",
            "MmaText",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["free",
                FontSlant->"Italic"], 
              StyleBox["[",
                "MmaText"], 
              StyleBox["2",
                "MmaText"], 
              StyleBox["]",
                "MmaText"]}], 
            StyleBox["[",
              "MmaText"], 
            StyleBox["t",
              "MmaText"], 
            StyleBox["]",
              "MmaText"]}], 
          StyleBox[" ",
            "MmaText"], 
          StyleBox["=",
            "MmaText"], 
          StyleBox[" ",
            "MmaText",
            FontSlant->"Italic"], 
          StyleBox["k3",
            "MmaText",
            FontSlant->"Italic"]}], TraditionalForm]]],
  ", we immanently select from the infinite dimensional group those subgroups \
which describe the invariance of the equation with respect to translations in \
the independent variables. At the other hand, this special subgroup creates \
the following reduction:"
}], "Text",
  Evaluatable->False,
  CellTags->{"infinite-dimensional symmetry group", "subgroup"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rkarp = LieReduction[karp, {u}, {x, y, t}, {k1, k2, k3}, \n\t\t{0}]; 
    LTF[Flatten[rkarp]] /. {zeta1 \[Rule] \[Zeta]\_1, 
        zeta2 \[Rule] \[Zeta]\_2}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(\(-k1\)\ t + k3\ x\)\/k1\),
                    ScriptLevel->0]}], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(k2\ x - k1\ y\)\/k1\),
                    ScriptLevel->0]}], "-", \(\[Zeta]\_2\)}], "==", "0"}]},
          {\(u - F\_1 == 0\)},
          {
            \(6\ k1\^4\ k3\^2\ \((F\_1)\)\_\[Zeta]\_1\%2 + 
                12\ k1\^4\ k2\ k3\ \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_1)\)\_\(\[Zeta]\_2\) + 
                6\ k1\^4\ k2\^2\ \((F\_1)\)\_\[Zeta]\_2\%2 - 
                k1\^5\ k3\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                6\ k1\^4\ k3\^2\ F\_1\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                k1\^5\ k2\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) + 
                12\ k1\^4\ k2\ k3\ F\_1\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) - 
                k1\^6\ \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                6\ k1\^4\ k2\^2\ F\_1\ 
                  \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                k1\^3\ k3\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                3\ k1\^3\ k2\ k3\^2\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2\) + 
                3\ k1\^3\ k2\^2\ k3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2\) + 
                k1\^3\ k2\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                k1\^2\ k3\^4\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1\) - 
                4\ k1\^2\ k2\ k3\^3\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_2\) - 
                6\ k1\^2\ k2\^2\ k3\^2\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                4\ k1\^2\ k2\^3\ k3\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                k1\^2\ k2\^4\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                k3\^6\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) - 
                6\ k2\ k3\^5\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2\) - 
                15\ k2\^2\ k3\^4\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2\) - 
                20\ k2\^3\ k3\^3\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                15\ k2\^4\ k3\^2\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                6\ k2\^5\ k3\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                k2\^6\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a non-linear partial differential equation of sixth order \
for the similarity function ",
  Cell[BoxData[
      \(TraditionalForm\`F1\)],
    FontSlant->"Italic"],
  ". The similarity function depends on the two similarity variables ",
  StyleBox["zeta1",
    FontSlant->"Italic"],
  " and ",
  StyleBox["zeta2",
    FontSlant->"Italic"],
  ". Thus, we reduced a (2+1)-dimensional PDE to a (1+1)-dimensional PDE. \
Both similarity variables ",
  StyleBox["zeta1 ",
    FontSlant->"Italic"],
  "and ",
  StyleBox["zeta2",
    FontSlant->"Italic"],
  " are invariants of the KP equation. The reduced equation is again a \
candidate for Lie's method. For the sake of simplicity, we choose the group \
constants ",
  StyleBox["k1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["k2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["k3",
    FontSlant->"Italic"],
  " in a suited way by  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", 
          RowBox[{
            StyleBox["k2",
              FontSlant->"Italic"], "=", "1"}]}], TraditionalForm]]],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k3",
            FontSlant->"Italic"], "=", "v"}], TraditionalForm]]],
  ". The corresponding reduction thus simplifies to"
}], "Text",
  Evaluatable->False,
  CellTags->{
  "nonlinear partial differential equation of sixth order", "reduction"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rkarp1 = LieReduction[karp, {u}, {x, y, t}, {1, 1, v}, \n\t\t{0}]; 
    LTF[Flatten[rkarp1]] /. {zeta1 \[Rule] \[Zeta]\_1, 
        zeta2 \[Rule] \[Zeta]\_2}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - v\ x - \[Zeta]\_1 == 0\)},
          {\(\(-x\) + y - \[Zeta]\_2 == 0\)},
          {\(u - F\_1 == 0\)},
          {
            \(6\ v\^2\ \((F\_1)\)\_\[Zeta]\_1\%2 + 
                12\ v\ \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_1)\)\_\(\[Zeta]\_2\) + 6\ \((F\_1)\)\_\[Zeta]\_2\%2 - 
                v\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                6\ v\^2\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) + 
                12\ v\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) - 
                \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                6\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                v\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                3\ v\^2\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2\) + 
                3\ v\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2\) + 
                \[Mu]\ \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                v\^4\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1\) - 
                4\ v\^3\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_2\) - 
                6\ v\^2\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                4\ v\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                v\^6\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) - 
                6\ v\^5\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2\) - 
                15\ v\^4\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2\) - 
                20\ v\^3\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                15\ v\^2\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                6\ v\ \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                \[Lambda]\ 
                  \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
It is obvious that the reduction of the KB equation is a \
sixth-order non-linear PDE in 1+1 variables. Thus, the resulting equation is \
nearly as complicated as the original equation. To simplify things, let us \
examine models which follow from the KB equation. If we change the parameters \
in the KB equation in an appropriate way, we get a simplified equation. One \
example is the reduction of the KB equation by\
\>", "Text",
  CellTags->{"KB-equation", "sixth-order nonlinear PDE"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(karps1\  = \ karp\  /. \ \[Lambda] \[Rule] 0; karps1 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(6\ u\_x\%2 + u\_\(x, t\) + 6\ u\ u\_\(x, x\) - u\_\(y, y\) - 
                \[Mu]\ u\_\(x, x, x\) - \[Epsilon]\ u\_\(x, x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
This kind of equation is called a reduced KB equation (rKB) in the \
following. The infinitesimals of this equation are calculated by\
\>", "Text",\

  CellTags->"reduced KB-equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infkarps1\  = \ 
      Infinitesimals[karps1, u, {x, y, t}, {\[Mu], \[Epsilon]}]; 
    infkarps1\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/12\),
                  ScriptLevel->0], " ", 
                \((2\ \((\[ScriptCapitalF]\_2)\)\_t + 
                    y\ \((\[ScriptCapitalF]\_1)\)\_\(t, t\))\)}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{\(\[ScriptCapitalF]\_2\), "+", 
                RowBox[{
                  StyleBox[\(1\/2\),
                    ScriptLevel->0], " ", "y", " ", 
                  \(\((\[ScriptCapitalF]\_1)\)\_t\)}]}]}]},
          {\(\[Xi]\_2 == \[ScriptCapitalF]\_1\)},
          {\(\[Xi]\_3 == k1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 12], 
            Plus[ 
              Times[ 2, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t]], 
              Times[ y, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t, t]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ 
            Subscript[ \[ScriptCapitalF], 2], 
            Times[ 
              Rational[ 1, 2], y, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Subscript[ \[ScriptCapitalF], 1]], 
        Equal[ 
          Subscript[ \[Xi], 3], k1]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, we find a group which is determined by two arbitrary functions ",
  Cell[BoxData[
      \(\[ScriptCapitalF]\_1\)], "MmaText"],
  " ",
  StyleBox["= ", "MmaText"],
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["] ", "MmaText"],
  "and ",
  Cell[BoxData[
      RowBox[{
        RowBox[{
          StyleBox[\(\[ScriptCapitalF]\_2\),
            FontFamily->"Times",
            FontSize->10,
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            PrivateFontOptions->{"FontPostScriptName"->Automatic}], "="}], 
        "  "}]]],
  StyleBox["f",
    FontSlant->"Italic"],
  StyleBox["ree", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["2", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ". Both functions depend only on ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and are not restricted by any side conditions. It is obvious that the \
symmetries of the model with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 0\)]],
  " allow the same transformations as the complete model."
}], "Text"],

Cell[TextData[{
  "The following reduction of the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = 0\)]],
  " model assumes that ",
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[2] = 1 = ", "MmaText"],
  StyleBox["free", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[1]", "MmaText"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["k1",
            FontSlant->"Italic"], "=", "c"}], TraditionalForm]], "MmaText"],
  ", with ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " a real constant:"
}], "Text",
  CellTags->"reduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rkarps1 = LieReduction[karps1, {u}, {x, y, t}, {1, 1, c}, \n\t\t{0}]; 
    LTF[Flatten[rkarps1]] /. {zeta1 \[Rule] \[Zeta]\_1, 
        zeta2 \[Rule] \[Zeta]\_2}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - c\ x - \[Zeta]\_1 == 0\)},
          {\(\(-x\) + y - \[Zeta]\_2 == 0\)},
          {\(u - F\_1 == 0\)},
          {
            \(6\ c\^2\ \((F\_1)\)\_\[Zeta]\_1\%2 + 
                12\ c\ \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_1)\)\_\(\[Zeta]\_2\) + 6\ \((F\_1)\)\_\[Zeta]\_2\%2 - 
                c\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                6\ c\^2\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) + 
                12\ c\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) - 
                \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                6\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                c\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                3\ c\^2\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2\) + 
                3\ c\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2\) + 
                \[Mu]\ \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) - 
                c\^4\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_1\) - 
                4\ c\^3\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1, 
                    \[Zeta]\_2\) - 
                6\ c\^2\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                4\ c\ \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2\) - 
                \[Epsilon]\ 
                  \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2, 
                    \[Zeta]\_2\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a fourth-order non-linear PDE in the similarity variables ",
  StyleBox["zeta1",
    FontSlant->"Italic"],
  ", ",
  StyleBox["zeta2",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["F1",
    FontSlant->"Italic"],
  ". The reduction is as complicated as the reduction of the full KB \
equation."
}], "Text",
  CellTags->"fourth-order nonlinear PDE"],

Cell[TextData[
"Another simplification of the original KB equation follows if we set \
\[Epsilon] and \[Lambda] equal to zero:"], "Text",
  CellTags->"KB-equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(karps2\  = \ karp\  /. \ {\[Lambda] \[Rule] 0, \[Epsilon] \[Rule] 0}; 
    karps2 // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(6\ u\_x\%2 + u\_\(x, t\) + 6\ u\ u\_\(x, x\) - u\_\(y, y\) - 
                \[Mu]\ u\_\(x, x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
The resulting equation is known as the ZK equation. The symmetries \
of the ZK equation are determined by\
\>", "Text",
  CellTags->"ZK-equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(infkarps2\  = \ Infinitesimals[karps2, u, {x, y, t}, {\[Mu]}]; 
    infkarps2\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/12\),
                  ScriptLevel->0], " ", 
                \((\(-6\)\ k2\ u + 2\ \((\[ScriptCapitalF]\_2)\)\_t + 
                    y\ \((\[ScriptCapitalF]\_1)\)\_\(t, t\))\)}]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              RowBox[{
                StyleBox[\(1\/2\),
                  ScriptLevel->0], " ", 
                \((k2\ x + 2\ \[ScriptCapitalF]\_2 + 
                    y\ \((\[ScriptCapitalF]\_1)\)\_t)\)}]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              RowBox[{
                StyleBox[\(\(3\ k2\ y\)\/4\),
                  ScriptLevel->0], "+", \(\[ScriptCapitalF]\_1\)}]}]},
          {\(\[Xi]\_3 == k1 + k2\ t\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 12], 
            Plus[ 
              Times[ -6, k2, u], 
              Times[ 2, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 2], t]], 
              Times[ y, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t, t]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Times[ k2, x], 
              Times[ 2, 
                Subscript[ \[ScriptCapitalF], 2]], 
              Times[ y, 
                Subscript[ 
                  Subscript[ \[ScriptCapitalF], 1], t]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Plus[ 
            Times[ 
              Rational[ 3, 4], k2, y], 
            Subscript[ \[ScriptCapitalF], 1]]], 
        Equal[ 
          Subscript[ \[Xi], 3], 
          Plus[ k1, 
            Times[ k2, t]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "For this model, we again find an infinite symmetry group depending on two \
arbitrary functions. Contrary to the models examined above, the discrete part \
of the symmetry group increases by one group parameter. The reduction of this \
model for a scaling group with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["k2",
              FontSlant->"Italic"], "=", "1"}], ",", " ", 
          RowBox[{
            StyleBox["k1",
              FontSlant->"Italic"], "=", "0"}]}], TraditionalForm]]],
  ", and the arbitrary functions set equal to zero follows by"
}], "Text",
  CellTags->{"infinite symmetry group", "scaling group"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rkarps21 = 
      LieReduction[karps2, {u}, {x, y, t}, {x\/2, \(3  y\)\/4, t}, \n
          \t\t{\(-\(u\/2\)\)}] // PowerExpand; 
    LTF[Flatten[rkarps21]] /. {zeta1 \[Rule] \[Zeta]\_1, 
        zeta2 \[Rule] \[Zeta]\_2}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(t\/x\^2\),
                  ScriptLevel->0], "-", \(\[Zeta]\_1\)}], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(y\/x\^\(3/2\)\),
                  ScriptLevel->0], "-", \(\[Zeta]\_2\)}], "==", "0"}]},
          {\(u\ x - F\_1 == 0\)},
          {
            \(\[Zeta]\_1\%\(7/4\)\ 
                \((48\ I\ t\^\(1/4\)\ \[Mu]\ F\_1 + 
                    144\ I\ t\^\(1/4\)\ F\_1\%2 - 
                    24\ I\ t\^\(1/4\)\ \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    432\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_1\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    672\ I\ t\^\(1/4\)\ F\_1\ \[Zeta]\_1\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\) + 
                    192\ I\ t\^\(1/4\)\ \[Zeta]\_1\%2\ 
                      \((F\_1)\)\_\[Zeta]\_1\%2 + 
                    267\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_2\ 
                      \((F\_1)\)\_\(\[Zeta]\_2\) + 
                    468\ I\ t\^\(1/4\)\ F\_1\ \[Zeta]\_2\ 
                      \((F\_1)\)\_\(\[Zeta]\_2\) + 
                    288\ I\ t\^\(1/4\)\ \[Zeta]\_1\ \[Zeta]\_2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                      \((F\_1)\)\_\(\[Zeta]\_2\) + 
                    108\ I\ t\^\(1/4\)\ \[Zeta]\_2\%2\ 
                      \((F\_1)\)\_\[Zeta]\_2\%2 - 
                    16\ I\ t\^\(1/4\)\ \[Zeta]\_1\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    384\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_1\%2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                    192\ I\ t\^\(1/4\)\ F\_1\ \[Zeta]\_1\%2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                    12\ I\ t\^\(1/4\)\ \[Zeta]\_2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) + 
                    540\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_1\ \[Zeta]\_2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) + 
                    288\ I\ t\^\(1/4\)\ F\_1\ \[Zeta]\_1\ \[Zeta]\_2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) - 
                    8\ I\ t\^\(1/4\)\ 
                      \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                    189\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_2\%2\ 
                      \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                    108\ I\ t\^\(1/4\)\ F\_1\ \[Zeta]\_2\%2\ 
                      \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                    64\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_1\%3\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                    144\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_1\%2\ \[Zeta]\_2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2\) + 
                    108\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_1\ \[Zeta]\_2\%2\ 
                      \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2\) + 
                    27\ I\ t\^\(1/4\)\ \[Mu]\ \[Zeta]\_2\%3\ 
                      \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\))
                  \) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
representing a third-order non-linear PDE. Another reduction \
follows for translations as symmetry transformations:\
\>", "Text",
  CellTags->{"third-order nonlinear PDE", "translation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rkarps22 = LieReduction[karps2, {u}, {x, y, t}, {1, 1, c}, \n\t\t{0}]; 
    LTF[Flatten[rkarps22]] /. {zeta1 \[Rule] \[Zeta]\_1, 
        zeta2 \[Rule] \[Zeta]\_2}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(t - c\ x - \[Zeta]\_1 == 0\)},
          {\(\(-x\) + y - \[Zeta]\_2 == 0\)},
          {\(u - F\_1 == 0\)},
          {
            \(6\ c\^2\ \((F\_1)\)\_\[Zeta]\_1\%2 + 
                12\ c\ \((F\_1)\)\_\(\[Zeta]\_1\)\ 
                  \((F\_1)\)\_\(\[Zeta]\_2\) + 6\ \((F\_1)\)\_\[Zeta]\_2\%2 - 
                c\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) + 
                6\ c\^2\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) - 
                \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) + 
                12\ c\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2\) - 
                \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                6\ F\_1\ \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2\) + 
                c\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_1\) + 
                3\ c\^2\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1, \[Zeta]\_2\) + 
                3\ c\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_2, \[Zeta]\_2\) + 
                \[Mu]\ \((F\_1)\)\_\(\[Zeta]\_2, \[Zeta]\_2, \[Zeta]\_2\) == 0
              \)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
We use this similarity representation to apply Lie's procedure \
again. The symmetries of the reduction follow by\
\>", "Text",
  CellTags->{"similarity representation", "Lie's procedure"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(irkarps22 = 
      Infinitesimals[rkarps22\[LeftDoubleBracket]3, 1\[RightDoubleBracket], 
        F1, {zeta1, zeta2}, {c, \[Mu]}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{zeta1, 3}F1[zeta1, zeta2]}]; 
    irkarps22 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(\((1 - 4\ c + 24\ c\^2\ F1)\)\ k3\)\/\(\(-6\) + 
                      12\ c\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_1\), "==", 
              
              StyleBox[
                \(\(\((\(-1\) + 2\ c)\)\ k1 - 
                      c\ k3\ \((zeta1 + 4\ c\ zeta1 - c\ zeta2)\)\)\/\(\(-1
                        \) + 2\ c\)\),
                ScriptLevel->0]}]},
          {
            RowBox[{\(\[Xi]\_2\), "==", 
              
              StyleBox[
                \(\(\((\(-1\) + 2\ c)\)\ k2 + 
                      k3\ \((\((\(-1\) + 2\ c)\)\ zeta1 + 
                            \((1 - 6\ c)\)\ c\ zeta2)\)\)\/\(\(-1\) + 
                      2\ c\)\),
                ScriptLevel->0]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Power[ 
              Plus[ -6, 
                Times[ 12, c]], -1], 
            Plus[ 1, 
              Times[ -4, c], 
              Times[ 24, 
                Power[ c, 2], F1]], k3]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Times[ 
            Power[ 
              Plus[ -1, 
                Times[ 2, c]], -1], 
            Plus[ 
              Times[ 
                Plus[ -1, 
                  Times[ 2, c]], k1], 
              Times[ -1, c, k3, 
                Plus[ zeta1, 
                  Times[ 4, c, zeta1], 
                  Times[ -1, c, zeta2]]]]]], 
        Equal[ 
          Subscript[ \[Xi], 2], 
          Times[ 
            Power[ 
              Plus[ -1, 
                Times[ 2, c]], -1], 
            Plus[ 
              Times[ 
                Plus[ -1, 
                  Times[ 2, c]], k2], 
              Times[ k3, 
                Plus[ 
                  Times[ 
                    Plus[ -1, 
                      Times[ 2, c]], zeta1], 
                  Times[ 
                    Plus[ 1, 
                      Times[ -6, c]], c, zeta2]]]]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
The result is a finite symmetry group of order three, allowing us a \
further reduction. Before we execute this step, we rename the variables to \
simplify the equations:\
\>", "Text",
  CellTags->"finite symmetry group"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eqv\  = 
      \ {rkarps22\[LeftDoubleBracket]3, 1, 1\[RightDoubleBracket]} /. 
        \ {F1 \[Rule] H, zeta1 \[Rule] \[Zeta]1, zeta2 \[Rule] \[Zeta]2}; 
    eqv // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(6\ c\^2\ H\_\[Zeta]1\%2 + 12\ c\ H\_\[Zeta]1\ H\_\[Zeta]2 + 
                6\ H\_\[Zeta]2\%2 - c\ H\_\(\[Zeta]1, \[Zeta]1\) + 
                6\ c\^2\ H\ H\_\(\[Zeta]1, \[Zeta]1\) - 
                H\_\(\[Zeta]1, \[Zeta]2\) + 
                12\ c\ H\ H\_\(\[Zeta]1, \[Zeta]2\) - 
                H\_\(\[Zeta]2, \[Zeta]2\) + 6\ H\ H\_\(\[Zeta]2, \[Zeta]2\) + 
                c\^3\ \[Mu]\ H\_\(\[Zeta]1, \[Zeta]1, \[Zeta]1\) + 
                3\ c\^2\ \[Mu]\ H\_\(\[Zeta]1, \[Zeta]1, \[Zeta]2\) + 
                3\ c\ \[Mu]\ H\_\(\[Zeta]1, \[Zeta]2, \[Zeta]2\) + 
                \[Mu]\ H\_\(\[Zeta]2, \[Zeta]2, \[Zeta]2\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["\<\
For the non-linear third-order PDE in the second similarity \
representation, we select the subgroup of translations to carry out another \
reduction. The infinitesimals for this case are given by\
\>", "Text",
  CellTags->{
  "nonlinear third-order PDE", "second similarity representation", 
    "infinitesimals"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(inf1\  = \ 
      \(\({\(xi[1]\)[zeta1, zeta2, F1], \(xi[2]\)[zeta1, zeta2, F1]}\  /. \ 
            irkarps22\)\  /. 
          \ {k1 \[Rule] 1, k2 \[Rule] v, k3 \[Rule] 0}\)\  /. {F1 \[Rule] H, 
          zeta1 \[Rule] \[Zeta]1, zeta2 \[Rule] \[Zeta]2}\ \)\)], "Input"],

Cell[BoxData[
    \({1, v}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(inf2\  = \ 
      \(\({\(phi[1]\)[zeta1, zeta2, F1]}\  /. \ irkarps22\)\  /. 
          \ {k1 \[Rule] 1, k2 \[Rule] v, k3 \[Rule] 0}\)\  /. {F1 \[Rule] H, 
          zeta1 \[Rule] \[Zeta]1, zeta2 \[Rule] \[Zeta]2}\ \)\)], "Input"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell["The corresponding reduction follows from", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rkarps221 = LieReduction[eqv, {H}, {\[Zeta]1, \[Zeta]2}, inf1, inf2]; 
    LTF[Flatten[rkarps221]] /. {zeta1 \[Rule] \[Zeta]}\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-\[Zeta]\) - v\ \[Zeta]1 + \[Zeta]2 == 0\)},
          {\(H - F\_1 == 0\)},
          {
            \(6\ \((F\_1)\)\_\[Zeta]\%2 - 12\ c\ v\ \((F\_1)\)\_\[Zeta]\%2 + 
                6\ c\^2\ v\^2\ \((F\_1)\)\_\[Zeta]\%2 - 
                \((F\_1)\)\_\(\[Zeta], \[Zeta]\) + 
                v\ \((F\_1)\)\_\(\[Zeta], \[Zeta]\) - 
                c\ v\^2\ \((F\_1)\)\_\(\[Zeta], \[Zeta]\) + 
                6\ F\_1\ \((F\_1)\)\_\(\[Zeta], \[Zeta]\) - 
                12\ c\ v\ F\_1\ \((F\_1)\)\_\(\[Zeta], \[Zeta]\) + 
                6\ c\^2\ v\^2\ F\_1\ \((F\_1)\)\_\(\[Zeta], \[Zeta]\) + 
                \[Mu]\ \((F\_1)\)\_\(\[Zeta], \[Zeta], \[Zeta]\) - 
                3\ c\ v\ \[Mu]\ \((F\_1)\)\_\(\[Zeta], \[Zeta], \[Zeta]\) + 
                3\ c\^2\ v\^2\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta], \[Zeta], \[Zeta]\) - 
                c\^3\ v\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta], \[Zeta], \[Zeta]\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a third-order non-linear ODE which allows a two-dimensional \
discrete symmetry group depending on group parameters ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " of the preceding reductions:"
}], "Text",
  CellTags->"third-order nonlinear ODE"],

Cell[CellGroupData[{

Cell[BoxData[
    \(irkarps221 = 
      Infinitesimals[rkarps221\[LeftDoubleBracket]3, 1\[RightDoubleBracket], 
        F1, {zeta1}, {c, \[Mu], v}, 
        SubstitutionRules \[Rule] {\[PartialD]\_{zeta1, 3}F1[zeta1]}]; 
    irkarps221 // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\[Phi]\_1\), "==", 
              
              StyleBox[
                \(\(k2\ \((
                        \(-1\) + v - c\ v\^2 + 6\ F1\ \((\(-1\) + c\ v)\)\^2)
                        \)\)\/\(6\ \((\(-1\) + c\ v)\)\^2\)\),
                ScriptLevel->0]}]},
          {\(\[Xi]\_1 == k1 - k2\ zeta1\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          Subscript[ \[Phi], 1], 
          Times[ 
            Rational[ 1, 6], k2, 
            Power[ 
              Plus[ -1, 
                Times[ c, v]], -2], 
            Plus[ -1, v, 
              Times[ -1, c, 
                Power[ v, 2]], 
              Times[ 6, F1, 
                Power[ 
                  Plus[ -1, 
                    Times[ c, v]], 2]]]]], 
        Equal[ 
          Subscript[ \[Xi], 1], 
          Plus[ k1, 
            Times[ -1, k2, zeta1]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result indicates that the third-order ODE is at least reducible to a \
second-order ODE which, in fact, is possible by an integration with respect \
to ",
  StyleBox["zeta1",
    FontSlant->"Italic"],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(firstIntegral\  = \ 
      \[Integral]rkarps221\[LeftDoubleBracket]3, 1, 1\[RightDoubleBracket] 
            \[DifferentialD]zeta1\  == \ c1; 
    LTF[firstIntegral] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\(-c1\) + 
                \((\(-1\) + v - c\ v\^2 + 6\ F\_1 - 12\ c\ v\ F\_1 + 
                      6\ c\^2\ v\^2\ F\_1)\)\ \((F\_1)\)\_\(\[Zeta]\_1\)\n
                \t - \((\(-1\) + c\ v)\)\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The resulting second-order ODE is solved by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol1\  = \ DSolve[firstIntegral, F1, zeta1]\)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((\((\((1 - v + c\ v\^2)\)\ 
                      AiryBi[\((
                            13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                              2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                              v\^2\ \((1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))
                                  \))\)/
                          \((4\ 3\^\(2/3\)\ 
                              \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] - 
                    2\ 3\^\(1/3\)\ \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(1/3\)\ 
                      AiryBiPrime[
                        \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                              2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                              v\^2\ \((1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))
                                  \))\)/
                          \((4\ 3\^\(2/3\)\ 
                              \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] + 
                    \((AiryAi[
                            \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                                  2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                                  v\^2\ \((
                                      1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))
                                      \))\)/
                              \((4\ 3\^\(2/3\)\ 
                                  \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))
                                \)] - 
                          v\ AiryAi[
                              \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                                    2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                                    v\^2\ \((
                                        1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))
                                        \))\)/
                                \((4\ 3\^\(2/3\)\ 
                                    \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))
                                  \)] + 
                          c\ v\^2\ 
                            AiryAi[
                              \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                                    2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                                    v\^2\ \((
                                        1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))
                                        \))\)/
                                \((4\ 3\^\(2/3\)\ 
                                    \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))
                                  \)] - 
                          2\ 3\^\(1/3\)\ 
                            \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(1/3\)\ 
                            AiryAiPrime[
                              \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                                    2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                                    v\^2\ \((
                                        1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))
                                        \))\)/
                                \((4\ 3\^\(2/3\)\ 
                                    \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))
                                  \)])\)\ C[1])\)/
                \((6\ \((\(-1\) + c\ v)\)\^2\ 
                    \((AiryBi[
                          \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                                2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                                v\^2\ \((
                                    1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))\))
                              \)/\((4\ 3\^\(2/3\)\ 
                                \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))
                              \)] + AiryAi[
                            \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 12\ c1\ #1 - 
                                  2\ v\ \((1 + 12\ c\ \((1 + c1\ #1)\))\) + 
                                  v\^2\ \((
                                      1 + 2\ c + 12\ c\^2\ \((1 + c1\ #1)\))
                                      \))\)/
                              \((4\ 3\^\(2/3\)\ 
                                  \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))
                                \)]\ C[1])\))\)&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is a complicated expression containing special functions of the \
Airy type. However, the solution simplifies if we set the integration \
constant ",
  StyleBox["c1",
    FontSlant->"Italic"],
  " equal to zero."
}], "Text",
  CellTags->"Airy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(firstIntegral\  = firstIntegral\  /. c1 \[Rule] 0; 
    LTF[firstIntegral] /. zeta1 \[Rule] \[Zeta]\_1\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\((\(-1\) + v - c\ v\^2 + 6\ F\_1 - 12\ c\ v\ F\_1 + 
                      6\ c\^2\ v\^2\ F\_1)\)\ \((F\_1)\)\_\(\[Zeta]\_1\) - 
                \((\(-1\) + c\ v)\)\^3\ \[Mu]\ 
                  \((F\_1)\)\_\(\[Zeta]\_1, \[Zeta]\_1\)\n\t == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell["The solution now reads", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol2\  = \ DSolve[firstIntegral, F1, zeta1]\)], "Input"],

Cell[BoxData[
    \({{F1 \[Rule] 
          \((1\/6\ \((
                  1\/\((1 - c\ v)\)\^2 - v\/\(1 - c\ v\) + 
                    \(1\/\((1 - c\ v)\)\^2\) 
                      \((\[Sqrt]\((
                              \(-1\) + 2\ v - v\^2 - 2\ c\ v\^2 + 
                                2\ c\ v\^3 - c\^2\ v\^4 - 12\ C[2] + 
                                24\ c\ v\ C[2] - 12\ c\^2\ v\^2\ C[2])\)\ 
                          Tan[1\/6\ 
                              \((\(-\(\((
                                        3\ #1\ 
                                        \[Sqrt]\((
                                        \(-1\) + 2\ v - v\^2 - 2\ c\ v\^2 + 
                                        2\ c\ v\^3 - c\^2\ v\^4 - 12\ C[2] + 
                                        24\ c\ v\ C[2] - 12\ c\^2\ v\^2\ C[2])
                                        \))\)/
                                      \((\((1 - c\ v)\)\^3\ \[Mu])\)\)\) + 
                                  \(1\/\((1 - c\ v)\)\^2\) 
                                    \((C[1]\ 
                                        \[Sqrt]\((
                                        \(-1\) + 2\ v - v\^2 - 2\ c\ v\^2 + 
                                        2\ c\ v\^3 - c\^2\ v\^4 - 12\ C[2] + 
                                        24\ c\ v\ C[2] - 12\ c\^2\ v\^2\ C[2])
                                        \))\))\)])\))\)&)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "containing only the ",
  StyleBox["Tan[]", "MmaText"],
  " function. At this stage of the calculation, we derived a solution for a \
special subgroup of all the possible symmetries of the original equation. \
This special function will help us to represent the solution in the original \
variables. To get the representation of the solution in ",
  Cell[BoxData[
      \(TraditionalForm\`x, y, t, \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we have to invert all the similarity transformations carried out above:"
}], "Text",
  CellTags->{"Tan[]", "special function"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ 
      u \[Rule] Function[{x, y, t}, $r] /. $r \[Rule] 
          \((F1[t - c\ x, \(-x\) + y] /. 
              \((F1 \[Rule] Function[{zeta1, zeta2}, $w]\  /. 
                  \ $w \[Rule] 
                    \((\((\((H == F1[\(-v\)\ \[Zeta]1 + \[Zeta]2] /. \ sol1)
                              \)\  /. {H \[Rule] F1, \[Zeta]1 \[Rule] zeta1, 
                              \[Zeta]2 \[Rule] zeta2})\)\  /. 
                        \ {Equal[a_, b_]} -> b)\))\))\)\)], "Input",
  CellTags->{"AiryBi[]", "AiryBiPrime[]", "AiryAi[]", "AiryAiPrime[]"}],

Cell[BoxData[
    \(u \[Rule] 
      Function[{x, y, t}, 
        \((\((1 - v + c\ v\^2)\)\ 
                AiryBi[\((
                      13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                        12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                        2\ v\ \((
                            1 + 12\ c\ 
                                \((1 + 
                                    c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\))
                                  \))\) + 
                        v\^2\ \((
                            1 + 2\ c + 
                              12\ c\^2\ 
                                \((1 + 
                                    c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\))
                                  \))\))\)/
                    \((4\ 3\^\(2/3\)\ 
                        \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] - 
              2\ 3\^\(1/3\)\ \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(1/3\)\ 
                AiryBiPrime[
                  \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                        12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                        2\ v\ \((
                            1 + 12\ c\ 
                                \((1 + 
                                    c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\))
                                  \))\) + 
                        v\^2\ \((
                            1 + 2\ c + 
                              12\ c\^2\ 
                                \((1 + 
                                    c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\))
                                  \))\))\)/
                    \((4\ 3\^\(2/3\)\ 
                        \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] + 
              \((AiryAi[
                      \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                            12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                            2\ v\ \((
                                1 + 12\ c\ 
                                    \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\) + 
                            v\^2\ \((
                                1 + 2\ c + 
                                  12\ c\^2\ 
                                    \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\))\)/
                        \((4\ 3\^\(2/3\)\ 
                            \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] - 
                    v\ AiryAi[
                        \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                              12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                              2\ v\ \((
                                  1 + 12\ c\ 
                                      \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\) + 
                              v\^2\ \((
                                  1 + 2\ c + 
                                    12\ c\^2\ 
                                      \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\))\)/
                          \((4\ 3\^\(2/3\)\ 
                              \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] + 
                    c\ v\^2\ 
                      AiryAi[\((
                            13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                              12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                              2\ v\ \((
                                  1 + 12\ c\ 
                                      \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\) + 
                              v\^2\ \((
                                  1 + 2\ c + 
                                    12\ c\^2\ 
                                      \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\))\)/
                          \((4\ 3\^\(2/3\)\ 
                              \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] - 
                    2\ 3\^\(1/3\)\ \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(1/3\)\ 
                      AiryAiPrime[
                        \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                              12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                              2\ v\ 
                                \((1 + 
                                    12\ c\ 
                                      \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\) + 
                              v\^2\ \((
                                  1 + 2\ c + 
                                    12\ c\^2\ 
                                      \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\))\)/
                          \((4\ 3\^\(2/3\)\ 
                              \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)])
                  \)\ C[1])\)/
          \((6\ \((\(-1\) + c\ v)\)\^2\ 
              \((AiryBi[
                    \((13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                          12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                          2\ v\ \((
                              1 + 12\ c\ 
                                  \((1 + 
                                      c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\) + 
                          v\^2\ \((
                              1 + 2\ c + 
                                12\ c\^2\ 
                                  \((1 + 
                                      c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\))\)/
                      \((4\ 3\^\(2/3\)\ 
                          \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)] + 
                  AiryAi[\((
                          13 - 2\ c\ v\^3 + c\^2\ v\^4 + 
                            12\ c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)\) - 
                            2\ v\ \((
                                1 + 12\ c\ 
                                    \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\) + 
                            v\^2\ \((
                                1 + 2\ c + 
                                  12\ c\^2\ 
                                    \((1 + 
                                        c1\ \((\(-x\) - v\ \((t - c\ x)\) + y)
                                        \))\))\))\)/
                        \((4\ 3\^\(2/3\)\ 
                            \((c1\ \((\(-1\) + c\ v)\)\^2)\)\^\(2/3\))\)]\ 
                    C[1])\))\)]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The second type of solution allowed by the reduced KB equation was derived \
for ",
  Cell[BoxData[
      \(TraditionalForm\`c1 = 0\)]],
  ". In original variables, this solution reads "
}], "Text",
  CellTags->"KB-equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sols\  = \ 
      u \[Rule] Function[{x, y, t}, $r] /. $r \[Rule] 
          \((F1[t - c\ x, \(-x\) + y] /. 
              \((F1 \[Rule] Function[{zeta1, zeta2}, $w]\  /. 
                  \ $w \[Rule] 
                    \((\((\((H == F1[\(-v\)\ \[Zeta]1 + \[Zeta]2] /. \ sol2)
                              \)\  /. {H \[Rule] F1, \[Zeta]1 \[Rule] zeta1, 
                              \[Zeta]2 \[Rule] zeta2})\)\  /. 
                        \ {Equal[a_, b_]} -> b)\))\))\)\)], "Input"],

Cell[BoxData[
    \(u \[Rule] 
      Function[{x, y, t}, 
        1\/6\ \((
            1\/\((1 - c\ v)\)\^2 - v\/\(1 - c\ v\) + 
              \(1\/\((1 - c\ v)\)\^2\) 
                \((\[Sqrt]\((
                        \(-1\) + 2\ v - v\^2 - 2\ c\ v\^2 + 2\ c\ v\^3 - 
                          c\^2\ v\^4 - 12\ C[2] + 24\ c\ v\ C[2] - 
                          12\ c\^2\ v\^2\ C[2])\)\ 
                    Tan[1\/6\ 
                        \((\(-\(\(1\/\(\((1 - c\ v)\)\^3\ \[Mu]\)\) 
                                \((3\ \((\(-x\) - v\ \((t - c\ x)\) + y)\)\ 
                                    \[Sqrt]\((
                                        \(-1\) + 2\ v - v\^2 - 2\ c\ v\^2 + 
                                        2\ c\ v\^3 - c\^2\ v\^4 - 12\ C[2] + 
                                        24\ c\ v\ C[2] - 12\ c\^2\ v\^2\ C[2])
                                        \))\)\)\) + 
                            \(1\/\((1 - c\ v)\)\^2\) 
                              \((C[1]\ 
                                  \[Sqrt]\((
                                      \(-1\) + 2\ v - v\^2 - 2\ c\ v\^2 + 
                                        2\ c\ v\^3 - c\^2\ v\^4 - 12\ C[2] + 
                                        24\ c\ v\ C[2] - 12\ c\^2\ v\^2\ C[2])
                                      \))\))\)])\))\)]\)], "Output"]
}, Open  ]],

Cell["We can inspect the ZK equation by this solution:", "Text",
  CellTags->"ZK-equation"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(karp\  /. \ {\[Lambda] \[Rule] 0, \[Epsilon] \[Rule] 0}\)\  /. sols
        \  // Simplify\)], "Input"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result is that the given solution satisfies the ZK equation. To get an \
impression on how the complicated symbolic solutions behave in the ",
  Cell[BoxData[
      \(TraditionalForm\`x, y, t\)]],
  " space, let us plot the solutions for different times over the (",
  Cell[BoxData[
      \(TraditionalForm\`x, y\)]],
  ")-plane. We choose the parameters for both plots as"
}], "Text",
  CellTags->{"ZK-equation", "symbolic solution"}],

Cell[BoxData[
    \(\(parameters\  = 
      \ {c \[Rule] 2, v \[Rule] 1, C[1] \[Rule] 0, C[2] \[Rule] 1, 
        \[Mu] \[Rule] 2, c1 \[Rule] 1}; \)\)], "Input"],

Cell["The two functions are created by", "Text"],

Cell[BoxData[
    \(\(pl\  = \ \(u[x, y, t]\  /. \ sol\)\  /. parameters; \)\)], "Input"],

Cell[TextData[{
  "for the general case with ",
  Cell[BoxData[
      \(TraditionalForm\`c1 = 1\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pls\  = \ \(u[x, y, t]\  /. \ sols\)\  /. parameters\)], "Input"],

Cell[BoxData[
    \(1\/6\ \((2 + 4\ Tanh[t - x - y])\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The two special solutions serve to create an animation for ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\) \[LessEqual] t \[LessEqual] \ 2\)]],
  " in steps of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta]t = 1/4\)]],
  ". The general solution looks like a bunch of crests moving from the left \
to the right:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Plot3D[
        Evaluate[pl /. t \[Rule] \[Tau]], {x, \(-2\) \[Pi], 2  \[Pi]}, {y, 
          \(-\[Pi]\), \[Pi]}, AxesLabel \[Rule] {"\<x\>", "\<y\>", "\<u\>"}, 
        PlotRange 
          \[Rule] {{\(-2\) \[Pi], 2  \[Pi]}, {\(-\[Pi]\), \[Pi]}, {\(-100\), 
              100}}, PlotPoints \[Rule] 60, Mesh \[Rule] False], {\[Tau], 
        \(-2\), 2,  .25}]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.11022e-16 1.04977 -0.0679587 1.04977 [
[.08733 .22266 -12 -8.87681 ]
[.08733 .22266 0 .12319 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.60704 .01829 -5.08896 -9 ]
[.60704 .01829 .91104 0 ]
[.29165 .07573 -9.31117 -15 ]
[.29165 .07573 .68883 0 ]
[.76162 .0881 0 -6.17057 ]
[.76162 .0881 12 2.82943 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.93925 .36012 0 -5.91342 ]
[.93925 .36012 6 3.08658 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02494 .25992 -24 -2.73794 ]
[.02494 .25992 0 6.26206 ]
[.01611 .31527 -18 -2.78472 ]
[.01611 .31527 0 6.21528 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00254 .43215 -12 -2.88407 ]
[-0.00254 .43215 0 6.11593 ]
[-0.0124 .49393 -18 -2.93688 ]
[-0.0124 .49393 0 6.06312 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09674 .23181 m
.10144 .23638 L
s
[(-5)] .08733 .22266 1 .97262 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.61454 .02905 m
.61829 .03444 L
s
[(5)] .60704 .01829 .69632 1 Mshowa
.125 Mabswid
.14416 .21324 m
.14694 .21603 L
s
.19248 .19432 m
.19521 .19716 L
s
.24172 .17504 m
.2444 .17792 L
s
.2919 .15539 m
.29453 .15832 L
s
.39523 .11493 m
.39774 .11796 L
s
.44843 .0941 m
.45088 .09718 L
s
.50269 .07285 m
.50508 .07598 L
s
.55805 .05117 m
.56037 .05435 L
s
.05019 .25004 m
.05305 .25274 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.74932 .09266 m
.74316 .09495 L
s
[(-2)] .76162 .0881 -1 .37124 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.92673 .36405 m
.92047 .36602 L
s
[(2)] .93925 .36012 -1 .31409 Mshowa
.125 Mabswid
.77428 .13086 m
.77058 .1322 L
s
.79837 .1677 m
.79466 .16902 L
s
.82162 .20326 m
.8179 .20455 L
s
.86578 .27081 m
.86204 .27206 L
s
.88677 .30292 m
.88302 .30414 L
s
.90707 .33398 m
.90332 .33518 L
s
.72342 .05305 m
.71974 .05445 L
s
.69654 .01193 m
.69287 .01336 L
s
.94577 .39318 m
.94201 .39434 L
s
.96423 .4214 m
.96046 .42254 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03716 .25514 m
.04327 .25274 L
s
[(-100)] .02494 .25992 1 -0.39157 Mshowa
.02837 .31059 m
.0345 .30825 L
s
[(-50)] .01611 .31527 1 -0.38117 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.00981 .42772 m
.01599 .4255 L
s
[(50)] -0.00254 .43215 1 -0.3591 Mshowa
0 .48963 m
.0062 .48748 L
s
[(100)] -0.0124 .49393 1 -0.34736 Mshowa
.125 Mabswid
.03543 .26607 m
.0391 .26464 L
s
.03368 .27708 m
.03735 .27566 L
s
.03193 .28817 m
.0356 .28676 L
s
.03016 .29934 m
.03383 .29793 L
s
.02658 .32192 m
.03026 .32053 L
s
.02477 .33334 m
.02845 .33195 L
s
.02295 .34483 m
.02663 .34345 L
s
.02111 .35641 m
.0248 .35504 L
s
.0174 .37983 m
.02109 .37847 L
s
.01552 .39167 m
.01922 .39032 L
s
.01363 .4036 m
.01733 .40225 L
s
.01173 .41561 m
.01543 .41428 L
s
.00788 .43991 m
.01159 .43859 L
s
.00593 .4522 m
.00964 .45089 L
s
.00397 .46458 m
.00768 .46328 L
s
.00199 .47706 m
.00571 .47576 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.655 .75 .92 r
.39636 .69721 .40169 .70188 .41061 .69936 .4053 .6947 Mtetra
.657 .752 .92 r
.4053 .6947 .41061 .69936 .41957 .69679 .41427 .69214 Mtetra
.658 .753 .92 r
.41427 .69214 .41957 .69679 .42855 .6942 .42328 .68953 Mtetra
.659 .754 .92 r
.42328 .68953 .42855 .6942 .43756 .69158 .43231 .6869 Mtetra
.43231 .6869 .43756 .69158 .44661 .68895 .44137 .68426 Mtetra
.44137 .68426 .44661 .68895 .45568 .68632 .45046 .68161 Mtetra
.45046 .68161 .45568 .68632 .46478 .68369 .45959 .67896 Mtetra
.658 .753 .92 r
.45959 .67896 .46478 .68369 .47391 .68106 .46874 .67631 Mtetra
.46874 .67631 .47391 .68106 .48308 .67842 .47792 .67365 Mtetra
.47792 .67365 .48308 .67842 .49227 .67577 .48714 .67099 Mtetra
.48714 .67099 .49227 .67577 .5015 .67313 .49638 .66832 Mtetra
.49638 .66832 .5015 .67313 .51075 .67047 .50566 .66565 Mtetra
.50566 .66565 .51075 .67047 .52004 .66781 .51496 .66297 Mtetra
.51496 .66297 .52004 .66781 .52936 .66514 .5243 .66029 Mtetra
.657 .753 .92 r
.5243 .66029 .52936 .66514 .5387 .66247 .53367 .65759 Mtetra
.53367 .65759 .5387 .66247 .54809 .65978 .54307 .65489 Mtetra
.657 .752 .92 r
.54307 .65489 .54809 .65978 .5575 .65709 .55251 .65218 Mtetra
.55251 .65218 .5575 .65709 .56694 .65439 .56197 .64947 Mtetra
.56197 .64947 .56694 .65439 .57642 .65169 .57147 .64674 Mtetra
.57147 .64674 .57642 .65169 .58593 .64897 .581 .64401 Mtetra
.581 .64401 .58593 .64897 .59547 .64625 .59057 .64127 Mtetra
.59057 .64127 .59547 .64625 .60504 .64351 .60016 .63852 Mtetra
.60016 .63852 .60504 .64351 .61465 .64077 .60979 .63576 Mtetra
.60979 .63576 .61465 .64077 .62429 .63802 .61945 .63299 Mtetra
.61945 .63299 .62429 .63802 .63396 .63526 .62915 .63021 Mtetra
.62915 .63021 .63396 .63526 .64367 .6325 .63888 .62743 Mtetra
.63888 .62743 .64367 .6325 .65341 .62972 .64864 .62463 Mtetra
.64864 .62463 .65341 .62972 .66318 .62693 .65844 .62183 Mtetra
.65844 .62183 .66318 .62693 .67299 .62414 .66827 .61902 Mtetra
.66827 .61902 .67299 .62414 .68283 .62133 .67814 .6162 Mtetra
.67814 .6162 .68283 .62133 .69271 .61852 .68803 .61336 Mtetra
.68803 .61336 .69271 .61852 .70262 .6157 .69797 .61052 Mtetra
.69797 .61052 .70262 .6157 .71256 .61287 .70794 .60767 Mtetra
.70794 .60767 .71256 .61287 .72254 .61002 .71794 .60481 Mtetra
.71794 .60481 .72254 .61002 .73256 .60717 .72798 .60194 Mtetra
.72798 .60194 .73256 .60717 .74261 .60431 .73806 .59906 Mtetra
.73806 .59906 .74261 .60431 .75269 .60144 .74817 .59617 Mtetra
.74817 .59617 .75269 .60144 .76281 .59856 .75831 .59327 Mtetra
.75831 .59327 .76281 .59856 .77297 .59567 .76849 .59037 Mtetra
.76849 .59037 .77297 .59567 .78316 .59277 .77871 .58745 Mtetra
.77871 .58745 .78316 .59277 .79339 .58986 .78896 .58452 Mtetra
.78896 .58452 .79339 .58986 .80365 .58694 .79925 .58158 Mtetra
.79925 .58158 .80365 .58694 .81396 .58401 .80958 .57863 Mtetra
.80958 .57863 .81396 .58401 .82429 .58107 .81995 .57567 Mtetra
.81995 .57567 .82429 .58107 .83467 .57812 .83035 .5727 Mtetra
.83035 .5727 .83467 .57812 .84508 .57516 .84079 .56972 Mtetra
.84079 .56972 .84508 .57516 .85553 .57219 .85126 .56673 Mtetra
.85126 .56673 .85553 .57219 .86602 .56921 .86178 .56373 Mtetra
.86178 .56373 .86602 .56921 .87654 .56622 .87233 .56071 Mtetra
.87233 .56071 .87654 .56622 .8871 .56321 .88292 .55769 Mtetra
.88292 .55769 .8871 .56321 .8977 .5602 .89355 .55466 Mtetra
.89355 .55466 .8977 .5602 .90834 .55718 .90421 .55161 Mtetra
.90421 .55161 .90834 .55718 .91902 .55414 .91492 .54856 Mtetra
.91492 .54856 .91902 .55414 .92973 .5511 .92566 .54549 Mtetra
.92566 .54549 .92973 .5511 .94049 .54804 .93645 .54241 Mtetra
.93645 .54241 .94049 .54804 .95128 .54497 .94727 .53933 Mtetra
.94727 .53933 .95128 .54497 .96211 .54189 .95813 .53623 Mtetra
.95813 .53623 .96211 .54189 .97299 .5388 .96903 .53312 Mtetra
.96903 .53312 .97299 .5388 .9839 .5357 .97998 .53 Mtetra
.654 .749 .92 r
.391 .6925 .39636 .69721 .4053 .6947 .39996 .69 Mtetra
.656 .751 .92 r
.39996 .69 .4053 .6947 .41427 .69214 .40895 .68744 Mtetra
.658 .753 .92 r
.40895 .68744 .41427 .69214 .42328 .68953 .41797 .68484 Mtetra
.659 .753 .92 r
.41797 .68484 .42328 .68953 .43231 .6869 .42702 .6822 Mtetra
.659 .754 .92 r
.42702 .6822 .43231 .6869 .44137 .68426 .4361 .67954 Mtetra
.4361 .67954 .44137 .68426 .45046 .68161 .44522 .67688 Mtetra
.44522 .67688 .45046 .68161 .45959 .67896 .45436 .67421 Mtetra
.659 .753 .92 r
.45436 .67421 .45959 .67896 .46874 .67631 .46353 .67153 Mtetra
.658 .753 .92 r
.46353 .67153 .46874 .67631 .47792 .67365 .47273 .66886 Mtetra
.47273 .66886 .47792 .67365 .48714 .67099 .48197 .66618 Mtetra
.48197 .66618 .48714 .67099 .49638 .66832 .49123 .66349 Mtetra
.49123 .66349 .49638 .66832 .50566 .66565 .50053 .6608 Mtetra
.50053 .6608 .50566 .66565 .51496 .66297 .50986 .6581 Mtetra
.50986 .6581 .51496 .66297 .5243 .66029 .51922 .6554 Mtetra
.657 .753 .92 r
.51922 .6554 .5243 .66029 .53367 .65759 .52861 .65269 Mtetra
.52861 .65269 .53367 .65759 .54307 .65489 .53803 .64997 Mtetra
.53803 .64997 .54307 .65489 .55251 .65218 .54749 .64724 Mtetra
.657 .752 .92 r
.54749 .64724 .55251 .65218 .56197 .64947 .55697 .64451 Mtetra
.55697 .64451 .56197 .64947 .57147 .64674 .56649 .64177 Mtetra
.56649 .64177 .57147 .64674 .581 .64401 .57605 .63902 Mtetra
.57605 .63902 .581 .64401 .59057 .64127 .58563 .63626 Mtetra
.58563 .63626 .59057 .64127 .60016 .63852 .59525 .63349 Mtetra
.59525 .63349 .60016 .63852 .60979 .63576 .6049 .63071 Mtetra
.6049 .63071 .60979 .63576 .61945 .63299 .61459 .62793 Mtetra
.61459 .62793 .61945 .63299 .62915 .63021 .62431 .62513 Mtetra
.62431 .62513 .62915 .63021 .63888 .62743 .63406 .62233 Mtetra
.63406 .62233 .63888 .62743 .64864 .62463 .64384 .61952 Mtetra
.64384 .61952 .64864 .62463 .65844 .62183 .65366 .61669 Mtetra
.65366 .61669 .65844 .62183 .66827 .61902 .66352 .61386 Mtetra
.66352 .61386 .66827 .61902 .67814 .6162 .67341 .61102 Mtetra
.67341 .61102 .67814 .6162 .68803 .61336 .68333 .60817 Mtetra
.68333 .60817 .68803 .61336 .69797 .61052 .69329 .60531 Mtetra
.69329 .60531 .69797 .61052 .70794 .60767 .70328 .60244 Mtetra
.70328 .60244 .70794 .60767 .71794 .60481 .71331 .59957 Mtetra
.71331 .59957 .71794 .60481 .72798 .60194 .72337 .59668 Mtetra
.72337 .59668 .72798 .60194 .73806 .59906 .73347 .59378 Mtetra
.73347 .59378 .73806 .59906 .74817 .59617 .74361 .59087 Mtetra
.74361 .59087 .74817 .59617 .75831 .59327 .75378 .58795 Mtetra
.75378 .58795 .75831 .59327 .76849 .59037 .76399 .58502 Mtetra
.76399 .58502 .76849 .59037 .77871 .58745 .77423 .58208 Mtetra
.77423 .58208 .77871 .58745 .78896 .58452 .78451 .57914 Mtetra
.78451 .57914 .78896 .58452 .79925 .58158 .79483 .57618 Mtetra
.79483 .57618 .79925 .58158 .80958 .57863 .80518 .57321 Mtetra
.80518 .57321 .80958 .57863 .81995 .57567 .81557 .57023 Mtetra
.81557 .57023 .81995 .57567 .83035 .5727 .826 .56724 Mtetra
.826 .56724 .83035 .5727 .84079 .56972 .83646 .56424 Mtetra
.83646 .56424 .84079 .56972 .85126 .56673 .84697 .56123 Mtetra
.84697 .56123 .85126 .56673 .86178 .56373 .85751 .55821 Mtetra
.85751 .55821 .86178 .56373 .87233 .56071 .86809 .55517 Mtetra
.86809 .55517 .87233 .56071 .88292 .55769 .87871 .55213 Mtetra
.87871 .55213 .88292 .55769 .89355 .55466 .88936 .54908 Mtetra
.88936 .54908 .89355 .55466 .90421 .55161 .90006 .54601 Mtetra
.90006 .54601 .90421 .55161 .91492 .54856 .91079 .54294 Mtetra
.91079 .54294 .91492 .54856 .92566 .54549 .92156 .53985 Mtetra
.92156 .53985 .92566 .54549 .93645 .54241 .93238 .53675 Mtetra
.93238 .53675 .93645 .54241 .94727 .53933 .94323 .53364 Mtetra
.94323 .53364 .94727 .53933 .95813 .53623 .95412 .53052 Mtetra
.95412 .53052 .95813 .53623 .96903 .53312 .96505 .52739 Mtetra
.96505 .52739 .96903 .53312 .97998 .53 .97602 .52425 Mtetra
.652 .748 .92 r
.38561 .68773 .391 .6925 .39996 .69 .39459 .68526 Mtetra
.655 .75 .92 r
.39459 .68526 .39996 .69 .40895 .68744 .40359 .68271 Mtetra
.657 .752 .92 r
.40359 .68271 .40895 .68744 .41797 .68484 .41263 .68011 Mtetra
.658 .753 .92 r
.41263 .68011 .41797 .68484 .42702 .6822 .4217 .67746 Mtetra
.659 .754 .92 r
.4217 .67746 .42702 .6822 .4361 .67954 .4308 .67479 Mtetra
.4308 .67479 .4361 .67954 .44522 .67688 .43994 .67211 Mtetra
.43994 .67211 .44522 .67688 .45436 .67421 .4491 .66942 Mtetra
.4491 .66942 .45436 .67421 .46353 .67153 .45829 .66673 Mtetra
.658 .753 .92 r
.45829 .66673 .46353 .67153 .47273 .66886 .46751 .66403 Mtetra
.46751 .66403 .47273 .66886 .48197 .66618 .47677 .66133 Mtetra
.47677 .66133 .48197 .66618 .49123 .66349 .48605 .65863 Mtetra
.48605 .65863 .49123 .66349 .50053 .6608 .49537 .65592 Mtetra
.49537 .65592 .50053 .6608 .50986 .6581 .50472 .65321 Mtetra
.50472 .65321 .50986 .6581 .51922 .6554 .5141 .65048 Mtetra
.5141 .65048 .51922 .6554 .52861 .65269 .52351 .64776 Mtetra
.657 .753 .92 r
.52351 .64776 .52861 .65269 .53803 .64997 .53296 .64502 Mtetra
.53296 .64502 .53803 .64997 .54749 .64724 .54243 .64228 Mtetra
.657 .752 .92 r
.54243 .64228 .54749 .64724 .55697 .64451 .55194 .63952 Mtetra
.55194 .63952 .55697 .64451 .56649 .64177 .56148 .63676 Mtetra
.56148 .63676 .56649 .64177 .57605 .63902 .57106 .63399 Mtetra
.57106 .63399 .57605 .63902 .58563 .63626 .58067 .63122 Mtetra
.58067 .63122 .58563 .63626 .59525 .63349 .59031 .62843 Mtetra
.59031 .62843 .59525 .63349 .6049 .63071 .59998 .62564 Mtetra
.59998 .62564 .6049 .63071 .61459 .62793 .60969 .62283 Mtetra
.60969 .62283 .61459 .62793 .62431 .62513 .61943 .62002 Mtetra
.61943 .62002 .62431 .62513 .63406 .62233 .6292 .6172 Mtetra
.6292 .6172 .63406 .62233 .64384 .61952 .63901 .61437 Mtetra
.63901 .61437 .64384 .61952 .65366 .61669 .64886 .61153 Mtetra
.64886 .61153 .65366 .61669 .66352 .61386 .65873 .60868 Mtetra
.65873 .60868 .66352 .61386 .67341 .61102 .66865 .60582 Mtetra
.66865 .60582 .67341 .61102 .68333 .60817 .67859 .60295 Mtetra
.67859 .60295 .68333 .60817 .69329 .60531 .68858 .60007 Mtetra
.68858 .60007 .69329 .60531 .70328 .60244 .69859 .59718 Mtetra
.69859 .59718 .70328 .60244 .71331 .59957 .70865 .59428 Mtetra
.70865 .59428 .71331 .59957 .72337 .59668 .71874 .59138 Mtetra
.71874 .59138 .72337 .59668 .73347 .59378 .72886 .58846 Mtetra
.72886 .58846 .73347 .59378 .74361 .59087 .73902 .58553 Mtetra
.73902 .58553 .74361 .59087 .75378 .58795 .74922 .58259 Mtetra
.74922 .58259 .75378 .58795 .76399 .58502 .75945 .57965 Mtetra
.75945 .57965 .76399 .58502 .77423 .58208 .76972 .57669 Mtetra
.76972 .57669 .77423 .58208 .78451 .57914 .78003 .57372 Mtetra
.78003 .57372 .78451 .57914 .79483 .57618 .79037 .57074 Mtetra
.79037 .57074 .79483 .57618 .80518 .57321 .80075 .56775 Mtetra
.80075 .56775 .80518 .57321 .81557 .57023 .81117 .56475 Mtetra
.81117 .56475 .81557 .57023 .826 .56724 .82162 .56174 Mtetra
.82162 .56174 .826 .56724 .83646 .56424 .83211 .55872 Mtetra
.83211 .55872 .83646 .56424 .84697 .56123 .84264 .55569 Mtetra
.84264 .55569 .84697 .56123 .85751 .55821 .85321 .55265 Mtetra
.85321 .55265 .85751 .55821 .86809 .55517 .86382 .5496 Mtetra
.86382 .5496 .86809 .55517 .87871 .55213 .87446 .54653 Mtetra
.87446 .54653 .87871 .55213 .88936 .54908 .88515 .54346 Mtetra
.88515 .54346 .88936 .54908 .90006 .54601 .89587 .54037 Mtetra
.89587 .54037 .90006 .54601 .91079 .54294 .90664 .53728 Mtetra
.90664 .53728 .91079 .54294 .92156 .53985 .91744 .53417 Mtetra
.91744 .53417 .92156 .53985 .93238 .53675 .92828 .53105 Mtetra
.92828 .53105 .93238 .53675 .94323 .53364 .93916 .52792 Mtetra
.93916 .52792 .94323 .53364 .95412 .53052 .95008 .52478 Mtetra
.95008 .52478 .95412 .53052 .96505 .52739 .96104 .52163 Mtetra
.96104 .52163 .96505 .52739 .97602 .52425 .97205 .51846 Mtetra
.649 .746 .92 r
.38019 .6829 .38561 .68773 .39459 .68526 .38918 .68047 Mtetra
.654 .749 .92 r
.38918 .68047 .39459 .68526 .40359 .68271 .3982 .67794 Mtetra
.656 .751 .92 r
.3982 .67794 .40359 .68271 .41263 .68011 .40726 .67534 Mtetra
.658 .753 .92 r
.40726 .67534 .41263 .68011 .4217 .67746 .41635 .67269 Mtetra
.659 .753 .92 r
.41635 .67269 .4217 .67746 .4308 .67479 .42547 .67001 Mtetra
.659 .754 .92 r
.42547 .67001 .4308 .67479 .43994 .67211 .43462 .66731 Mtetra
.43462 .66731 .43994 .67211 .4491 .66942 .4438 .66461 Mtetra
.4438 .66461 .4491 .66942 .45829 .66673 .45302 .66189 Mtetra
.659 .753 .92 r
.45302 .66189 .45829 .66673 .46751 .66403 .46226 .65918 Mtetra
.658 .753 .92 r
.46226 .65918 .46751 .66403 .47677 .66133 .47154 .65646 Mtetra
.47154 .65646 .47677 .66133 .48605 .65863 .48084 .65374 Mtetra
.48084 .65374 .48605 .65863 .49537 .65592 .49018 .65101 Mtetra
.49018 .65101 .49537 .65592 .50472 .65321 .49955 .64828 Mtetra
.49955 .64828 .50472 .65321 .5141 .65048 .50895 .64554 Mtetra
.50895 .64554 .5141 .65048 .52351 .64776 .51838 .64279 Mtetra
.657 .753 .92 r
.51838 .64279 .52351 .64776 .53296 .64502 .52785 .64004 Mtetra
.52785 .64004 .53296 .64502 .54243 .64228 .53735 .63727 Mtetra
.53735 .63727 .54243 .64228 .55194 .63952 .54688 .6345 Mtetra
.657 .752 .92 r
.54688 .6345 .55194 .63952 .56148 .63676 .55644 .63173 Mtetra
.55644 .63173 .56148 .63676 .57106 .63399 .56604 .62894 Mtetra
.56604 .62894 .57106 .63399 .58067 .63122 .57567 .62614 Mtetra
.57567 .62614 .58067 .63122 .59031 .62843 .58533 .62334 Mtetra
.58533 .62334 .59031 .62843 .59998 .62564 .59503 .62053 Mtetra
.59503 .62053 .59998 .62564 .60969 .62283 .60476 .6177 Mtetra
.60476 .6177 .60969 .62283 .61943 .62002 .61452 .61487 Mtetra
.61452 .61487 .61943 .62002 .6292 .6172 .62432 .61203 Mtetra
.62432 .61203 .6292 .6172 .63901 .61437 .63415 .60918 Mtetra
.63415 .60918 .63901 .61437 .64886 .61153 .64402 .60632 Mtetra
.64402 .60632 .64886 .61153 .65873 .60868 .65392 .60345 Mtetra
.65392 .60345 .65873 .60868 .66865 .60582 .66386 .60058 Mtetra
.66386 .60058 .66865 .60582 .67859 .60295 .67383 .59769 Mtetra
.67383 .59769 .67859 .60295 .68858 .60007 .68384 .59479 Mtetra
.68384 .59479 .68858 .60007 .69859 .59718 .69388 .59189 Mtetra
.69388 .59189 .69859 .59718 .70865 .59428 .70396 .58897 Mtetra
.70396 .58897 .70865 .59428 .71874 .59138 .71407 .58604 Mtetra
.71407 .58604 .71874 .59138 .72886 .58846 .72422 .5831 Mtetra
.72422 .5831 .72886 .58846 .73902 .58553 .7344 .58016 Mtetra
.7344 .58016 .73902 .58553 .74922 .58259 .74463 .5772 Mtetra
.74463 .5772 .74922 .58259 .75945 .57965 .75488 .57423 Mtetra
.75488 .57423 .75945 .57965 .76972 .57669 .76518 .57126 Mtetra
.76518 .57126 .76972 .57669 .78003 .57372 .77551 .56827 Mtetra
.77551 .56827 .78003 .57372 .79037 .57074 .78588 .56527 Mtetra
.78588 .56527 .79037 .57074 .80075 .56775 .79629 .56226 Mtetra
.79629 .56226 .80075 .56775 .81117 .56475 .80673 .55924 Mtetra
.80673 .55924 .81117 .56475 .82162 .56174 .81721 .55621 Mtetra
.81721 .55621 .82162 .56174 .83211 .55872 .82773 .55317 Mtetra
.82773 .55317 .83211 .55872 .84264 .55569 .83829 .55012 Mtetra
.83829 .55012 .84264 .55569 .85321 .55265 .84889 .54706 Mtetra
.84889 .54706 .85321 .55265 .86382 .5496 .85952 .54398 Mtetra
.85952 .54398 .86382 .5496 .87446 .54653 .8702 .5409 Mtetra
.8702 .5409 .87446 .54653 .88515 .54346 .88091 .5378 Mtetra
.88091 .5378 .88515 .54346 .89587 .54037 .89166 .5347 Mtetra
.89166 .5347 .89587 .54037 .90664 .53728 .90245 .53158 Mtetra
.90245 .53158 .90664 .53728 .91744 .53417 .91328 .52845 Mtetra
.91328 .52845 .91744 .53417 .92828 .53105 .92415 .52531 Mtetra
.92415 .52531 .92828 .53105 .93916 .52792 .93507 .52216 Mtetra
.93507 .52216 .93916 .52792 .95008 .52478 .94602 .519 Mtetra
.94602 .519 .95008 .52478 .96104 .52163 .95701 .51582 Mtetra
.95701 .51582 .96104 .52163 .97205 .51846 .96804 .51264 Mtetra
.646 .743 .92 r
.37473 .67799 .38019 .6829 .38918 .68047 .38374 .67563 Mtetra
.652 .748 .92 r
.38374 .67563 .38918 .68047 .3982 .67794 .39278 .67312 Mtetra
.655 .75 .92 r
.39278 .67312 .3982 .67794 .40726 .67534 .40186 .67053 Mtetra
.657 .752 .92 r
.40186 .67053 .40726 .67534 .41635 .67269 .41096 .66789 Mtetra
.658 .753 .92 r
.41096 .66789 .41635 .67269 .42547 .67001 .4201 .6652 Mtetra
.659 .754 .92 r
.4201 .6652 .42547 .67001 .43462 .66731 .42927 .66249 Mtetra
.42927 .66249 .43462 .66731 .4438 .66461 .43848 .65976 Mtetra
.43848 .65976 .4438 .66461 .45302 .66189 .44771 .65703 Mtetra
.44771 .65703 .45302 .66189 .46226 .65918 .45697 .6543 Mtetra
.658 .753 .92 r
.45697 .6543 .46226 .65918 .47154 .65646 .46627 .65156 Mtetra
.46627 .65156 .47154 .65646 .48084 .65374 .4756 .64882 Mtetra
.4756 .64882 .48084 .65374 .49018 .65101 .48495 .64607 Mtetra
.48495 .64607 .49018 .65101 .49955 .64828 .49434 .64332 Mtetra
.49434 .64332 .49955 .64828 .50895 .64554 .50377 .64056 Mtetra
.50377 .64056 .50895 .64554 .51838 .64279 .51322 .63779 Mtetra
.51322 .63779 .51838 .64279 .52785 .64004 .52271 .63502 Mtetra
.657 .753 .92 r
.52271 .63502 .52785 .64004 .53735 .63727 .53223 .63224 Mtetra
.53223 .63224 .53735 .63727 .54688 .6345 .54178 .62945 Mtetra
.657 .752 .92 r
.54178 .62945 .54688 .6345 .55644 .63173 .55137 .62666 Mtetra
.55137 .62666 .55644 .63173 .56604 .62894 .56098 .62385 Mtetra
.56098 .62385 .56604 .62894 .57567 .62614 .57064 .62104 Mtetra
.57064 .62104 .57567 .62614 .58533 .62334 .58032 .61821 Mtetra
.58032 .61821 .58533 .62334 .59503 .62053 .59004 .61538 Mtetra
.59004 .61538 .59503 .62053 .60476 .6177 .59979 .61254 Mtetra
.59979 .61254 .60476 .6177 .61452 .61487 .60958 .60969 Mtetra
.60958 .60969 .61452 .61487 .62432 .61203 .6194 .60683 Mtetra
.6194 .60683 .62432 .61203 .63415 .60918 .62926 .60396 Mtetra
.62926 .60396 .63415 .60918 .64402 .60632 .63915 .60109 Mtetra
.63915 .60109 .64402 .60632 .65392 .60345 .64908 .5982 Mtetra
.64908 .5982 .65392 .60345 .66386 .60058 .65904 .5953 Mtetra
.65904 .5953 .66386 .60058 .67383 .59769 .66903 .5924 Mtetra
.66903 .5924 .67383 .59769 .68384 .59479 .67906 .58948 Mtetra
.67906 .58948 .68384 .59479 .69388 .59189 .68913 .58655 Mtetra
.68913 .58655 .69388 .59189 .70396 .58897 .69923 .58362 Mtetra
.69923 .58362 .70396 .58897 .71407 .58604 .70937 .58067 Mtetra
.70937 .58067 .71407 .58604 .72422 .5831 .71954 .57771 Mtetra
.71954 .57771 .72422 .5831 .7344 .58016 .72976 .57475 Mtetra
.72976 .57475 .7344 .58016 .74463 .5772 .74 .57177 Mtetra
.74 .57177 .74463 .5772 .75488 .57423 .75029 .56878 Mtetra
.75029 .56878 .75488 .57423 .76518 .57126 .76061 .56579 Mtetra
.76061 .56579 .76518 .57126 .77551 .56827 .77097 .56278 Mtetra
.77097 .56278 .77551 .56827 .78588 .56527 .78136 .55976 Mtetra
.78136 .55976 .78588 .56527 .79629 .56226 .7918 .55673 Mtetra
.7918 .55673 .79629 .56226 .80673 .55924 .80227 .55369 Mtetra
.80227 .55369 .80673 .55924 .81721 .55621 .81278 .55064 Mtetra
.81278 .55064 .81721 .55621 .82773 .55317 .82332 .54758 Mtetra
.82332 .54758 .82773 .55317 .83829 .55012 .83391 .54451 Mtetra
.83391 .54451 .83829 .55012 .84889 .54706 .84453 .54143 Mtetra
.84453 .54143 .84889 .54706 .85952 .54398 .8552 .53833 Mtetra
.8552 .53833 .85952 .54398 .8702 .5409 .8659 .53523 Mtetra
.8659 .53523 .8702 .5409 .88091 .5378 .87664 .53211 Mtetra
.87664 .53211 .88091 .5378 .89166 .5347 .88742 .52898 Mtetra
.88742 .52898 .89166 .5347 .90245 .53158 .89824 .52584 Mtetra
.89824 .52584 .90245 .53158 .91328 .52845 .9091 .52269 Mtetra
.9091 .52269 .91328 .52845 .92415 .52531 .92 .51953 Mtetra
.92 .51953 .92415 .52531 .93507 .52216 .93094 .51636 Mtetra
.93094 .51636 .93507 .52216 .94602 .519 .94192 .51317 Mtetra
.94192 .51317 .94602 .519 .95701 .51582 .95295 .50998 Mtetra
.95295 .50998 .95701 .51582 .96804 .51264 .96401 .50677 Mtetra
.64 .738 .92 r
.36925 .67297 .37473 .67799 .38374 .67563 .37826 .67073 Mtetra
.649 .746 .92 r
.37826 .67073 .38374 .67563 .39278 .67312 .38732 .66826 Mtetra
.654 .749 .92 r
.38732 .66826 .39278 .67312 .40186 .67053 .39642 .66568 Mtetra
.656 .751 .92 r
.39642 .66568 .40186 .67053 .41096 .66789 .40554 .66304 Mtetra
.658 .753 .92 r
.40554 .66304 .41096 .66789 .4201 .6652 .4147 .66035 Mtetra
.659 .753 .92 r
.4147 .66035 .4201 .6652 .42927 .66249 .42389 .65763 Mtetra
.659 .754 .92 r
.42389 .65763 .42927 .66249 .43848 .65976 .43312 .65489 Mtetra
.43312 .65489 .43848 .65976 .44771 .65703 .44237 .65214 Mtetra
.44237 .65214 .44771 .65703 .45697 .6543 .45165 .64938 Mtetra
.659 .753 .92 r
.45165 .64938 .45697 .6543 .46627 .65156 .46097 .64663 Mtetra
.658 .753 .92 r
.46097 .64663 .46627 .65156 .4756 .64882 .47032 .64386 Mtetra
.47032 .64386 .4756 .64882 .48495 .64607 .4797 .6411 Mtetra
.4797 .6411 .48495 .64607 .49434 .64332 .48911 .63833 Mtetra
.48911 .63833 .49434 .64332 .50377 .64056 .49855 .63555 Mtetra
.49855 .63555 .50377 .64056 .51322 .63779 .50803 .63277 Mtetra
.50803 .63277 .51322 .63779 .52271 .63502 .51754 .62997 Mtetra
.657 .753 .92 r
.51754 .62997 .52271 .63502 .53223 .63224 .52708 .62718 Mtetra
.52708 .62718 .53223 .63224 .54178 .62945 .53665 .62437 Mtetra
.53665 .62437 .54178 .62945 .55137 .62666 .54626 .62155 Mtetra
.657 .752 .92 r
.54626 .62155 .55137 .62666 .56098 .62385 .5559 .61873 Mtetra
.5559 .61873 .56098 .62385 .57064 .62104 .56557 .6159 Mtetra
.56557 .6159 .57064 .62104 .58032 .61821 .57528 .61306 Mtetra
.57528 .61306 .58032 .61821 .59004 .61538 .58502 .61021 Mtetra
.58502 .61021 .59004 .61538 .59979 .61254 .5948 .60735 Mtetra
.5948 .60735 .59979 .61254 .60958 .60969 .60461 .60448 Mtetra
.60461 .60448 .60958 .60969 .6194 .60683 .61445 .6016 Mtetra
.61445 .6016 .6194 .60683 .62926 .60396 .62433 .59871 Mtetra
.62433 .59871 .62926 .60396 .63915 .60109 .63425 .59582 Mtetra
.63425 .59582 .63915 .60109 .64908 .5982 .6442 .59291 Mtetra
.6442 .59291 .64908 .5982 .65904 .5953 .65418 .58999 Mtetra
.65418 .58999 .65904 .5953 .66903 .5924 .6642 .58707 Mtetra
.6642 .58707 .66903 .5924 .67906 .58948 .67426 .58413 Mtetra
.67426 .58413 .67906 .58948 .68913 .58655 .68435 .58119 Mtetra
.68435 .58119 .68913 .58655 .69923 .58362 .69448 .57823 Mtetra
.69448 .57823 .69923 .58362 .70937 .58067 .70464 .57527 Mtetra
.70464 .57527 .70937 .58067 .71954 .57771 .71484 .57229 Mtetra
.71484 .57229 .71954 .57771 .72976 .57475 .72508 .5693 Mtetra
.72508 .5693 .72976 .57475 .74 .57177 .73535 .56631 Mtetra
.73535 .56631 .74 .57177 .75029 .56878 .74566 .5633 Mtetra
.74566 .5633 .75029 .56878 .76061 .56579 .75601 .56028 Mtetra
.75601 .56028 .76061 .56579 .77097 .56278 .76639 .55725 Mtetra
.76639 .55725 .77097 .56278 .78136 .55976 .77681 .55422 Mtetra
.77681 .55422 .78136 .55976 .7918 .55673 .78727 .55117 Mtetra
.78727 .55117 .7918 .55673 .80227 .55369 .79777 .54811 Mtetra
.79777 .54811 .80227 .55369 .81278 .55064 .80831 .54503 Mtetra
.80831 .54503 .81278 .55064 .82332 .54758 .81888 .54195 Mtetra
.81888 .54195 .82332 .54758 .83391 .54451 .8295 .53886 Mtetra
.8295 .53886 .83391 .54451 .84453 .54143 .84015 .53576 Mtetra
.84015 .53576 .84453 .54143 .8552 .53833 .85084 .53264 Mtetra
.85084 .53264 .8552 .53833 .8659 .53523 .86157 .52951 Mtetra
.86157 .52951 .8659 .53523 .87664 .53211 .87234 .52638 Mtetra
.87234 .52638 .87664 .53211 .88742 .52898 .88315 .52323 Mtetra
.88315 .52323 .88742 .52898 .89824 .52584 .894 .52007 Mtetra
.894 .52007 .89824 .52584 .9091 .52269 .90489 .5169 Mtetra
.90489 .5169 .9091 .52269 .92 .51953 .91582 .51371 Mtetra
.91582 .51371 .92 .51953 .93094 .51636 .92679 .51052 Mtetra
.92679 .51052 .93094 .51636 .94192 .51317 .9378 .50731 Mtetra
.9378 .50731 .94192 .51317 .95295 .50998 .94886 .50409 Mtetra
.94886 .50409 .95295 .50998 .96401 .50677 .95995 .50086 Mtetra
.628 .728 .919 r
.36374 .66773 .36925 .67297 .37826 .67073 .37276 .66574 Mtetra
.646 .743 .92 r
.37276 .66574 .37826 .67073 .38732 .66826 .38183 .66334 Mtetra
.652 .748 .92 r
.38183 .66334 .38732 .66826 .39642 .66568 .39094 .66079 Mtetra
.655 .75 .92 r
.39094 .66079 .39642 .66568 .40554 .66304 .40009 .65816 Mtetra
.657 .752 .92 r
.40009 .65816 .40554 .66304 .4147 .66035 .40927 .65547 Mtetra
.658 .753 .92 r
.40927 .65547 .4147 .66035 .42389 .65763 .41848 .65274 Mtetra
.659 .754 .92 r
.41848 .65274 .42389 .65763 .43312 .65489 .42772 .64999 Mtetra
.42772 .64999 .43312 .65489 .44237 .65214 .43699 .64722 Mtetra
.43699 .64722 .44237 .65214 .45165 .64938 .4463 .64444 Mtetra
.4463 .64444 .45165 .64938 .46097 .64663 .45564 .64166 Mtetra
.658 .753 .92 r
.45564 .64166 .46097 .64663 .47032 .64386 .465 .63888 Mtetra
.465 .63888 .47032 .64386 .4797 .6411 .4744 .6361 Mtetra
.4744 .6361 .4797 .6411 .48911 .63833 .48384 .63331 Mtetra
.48384 .63331 .48911 .63833 .49855 .63555 .4933 .63051 Mtetra
.4933 .63051 .49855 .63555 .50803 .63277 .5028 .62771 Mtetra
.5028 .62771 .50803 .63277 .51754 .62997 .51233 .6249 Mtetra
.51233 .6249 .51754 .62997 .52708 .62718 .52189 .62208 Mtetra
.657 .753 .92 r
.52189 .62208 .52708 .62718 .53665 .62437 .53149 .61925 Mtetra
.53149 .61925 .53665 .62437 .54626 .62155 .54112 .61642 Mtetra
.657 .752 .92 r
.54112 .61642 .54626 .62155 .5559 .61873 .55078 .61358 Mtetra
.55078 .61358 .5559 .61873 .56557 .6159 .56048 .61073 Mtetra
.56048 .61073 .56557 .6159 .57528 .61306 .57021 .60787 Mtetra
.57021 .60787 .57528 .61306 .58502 .61021 .57997 .605 Mtetra
.57997 .605 .58502 .61021 .5948 .60735 .58977 .60212 Mtetra
.58977 .60212 .5948 .60735 .60461 .60448 .59961 .59923 Mtetra
.59961 .59923 .60461 .60448 .61445 .6016 .60947 .59633 Mtetra
.60947 .59633 .61445 .6016 .62433 .59871 .61938 .59343 Mtetra
.61938 .59343 .62433 .59871 .63425 .59582 .62931 .59051 Mtetra
.62931 .59051 .63425 .59582 .6442 .59291 .63929 .58759 Mtetra
.63929 .58759 .6442 .59291 .65418 .58999 .6493 .58465 Mtetra
.6493 .58465 .65418 .58999 .6642 .58707 .65934 .58171 Mtetra
.65934 .58171 .6642 .58707 .67426 .58413 .66942 .57875 Mtetra
.66942 .57875 .67426 .58413 .68435 .58119 .67954 .57579 Mtetra
.67954 .57579 .68435 .58119 .69448 .57823 .68969 .57281 Mtetra
.68969 .57281 .69448 .57823 .70464 .57527 .69988 .56982 Mtetra
.69988 .56982 .70464 .57527 .71484 .57229 .7101 .56683 Mtetra
.7101 .56683 .71484 .57229 .72508 .5693 .72037 .56382 Mtetra
.72037 .56382 .72508 .5693 .73535 .56631 .73066 .56081 Mtetra
.73066 .56081 .73535 .56631 .74566 .5633 .741 .55778 Mtetra
.741 .55778 .74566 .5633 .75601 .56028 .75137 .55474 Mtetra
.75137 .55474 .75601 .56028 .76639 .55725 .76179 .55169 Mtetra
.76179 .55169 .76639 .55725 .77681 .55422 .77223 .54863 Mtetra
.77223 .54863 .77681 .55422 .78727 .55117 .78272 .54556 Mtetra
.78272 .54556 .78727 .55117 .79777 .54811 .79325 .54248 Mtetra
.79325 .54248 .79777 .54811 .80831 .54503 .80381 .53939 Mtetra
.80381 .53939 .80831 .54503 .81888 .54195 .81441 .53629 Mtetra
.81441 .53629 .81888 .54195 .8295 .53886 .82505 .53317 Mtetra
.82505 .53317 .8295 .53886 .84015 .53576 .83573 .53005 Mtetra
.83573 .53005 .84015 .53576 .85084 .53264 .84645 .52691 Mtetra
.84645 .52691 .85084 .53264 .86157 .52951 .85721 .52376 Mtetra
.85721 .52376 .86157 .52951 .87234 .52638 .86801 .52061 Mtetra
.86801 .52061 .87234 .52638 .88315 .52323 .87885 .51743 Mtetra
.87885 .51743 .88315 .52323 .894 .52007 .88973 .51425 Mtetra
.88973 .51425 .894 .52007 .90489 .5169 .90065 .51106 Mtetra
.90065 .51106 .90489 .5169 .91582 .51371 .91161 .50785 Mtetra
.91161 .50785 .91582 .51371 .92679 .51052 .92261 .50464 Mtetra
.92261 .50464 .92679 .51052 .9378 .50731 .93365 .50141 Mtetra
.93365 .50141 .9378 .50731 .94886 .50409 .94474 .49817 Mtetra
.94474 .49817 .94886 .50409 .95995 .50086 .95586 .49491 Mtetra
.596 .697 .913 r
.35822 .6619 .36374 .66773 .37276 .66574 .36723 .66064 Mtetra
.64 .738 .92 r
.36723 .66064 .37276 .66574 .38183 .66334 .37631 .65836 Mtetra
.649 .746 .92 r
.37631 .65836 .38183 .66334 .39094 .66079 .38544 .65585 Mtetra
.654 .749 .92 r
.38544 .65585 .39094 .66079 .40009 .65816 .3946 .65323 Mtetra
.656 .751 .92 r
.3946 .65323 .40009 .65816 .40927 .65547 .4038 .65055 Mtetra
.658 .753 .92 r
.4038 .65055 .40927 .65547 .41848 .65274 .41303 .64782 Mtetra
.659 .753 .92 r
.41303 .64782 .41848 .65274 .42772 .64999 .42229 .64505 Mtetra
.659 .754 .92 r
.42229 .64505 .42772 .64999 .43699 .64722 .43159 .64227 Mtetra
.43159 .64227 .43699 .64722 .4463 .64444 .44091 .63947 Mtetra
.44091 .63947 .4463 .64444 .45564 .64166 .45027 .63667 Mtetra
.659 .753 .92 r
.45027 .63667 .45564 .64166 .465 .63888 .45966 .63387 Mtetra
.658 .753 .92 r
.45966 .63387 .465 .63888 .4744 .6361 .46908 .63106 Mtetra
.46908 .63106 .4744 .6361 .48384 .63331 .47853 .62825 Mtetra
.47853 .62825 .48384 .63331 .4933 .63051 .48802 .62544 Mtetra
.48802 .62544 .4933 .63051 .5028 .62771 .49754 .62261 Mtetra
.49754 .62261 .5028 .62771 .51233 .6249 .50709 .61979 Mtetra
.50709 .61979 .51233 .6249 .52189 .62208 .51667 .61695 Mtetra
.657 .753 .92 r
.51667 .61695 .52189 .62208 .53149 .61925 .52629 .6141 Mtetra
.52629 .6141 .53149 .61925 .54112 .61642 .53594 .61125 Mtetra
.53594 .61125 .54112 .61642 .55078 .61358 .54563 .60839 Mtetra
.657 .752 .92 r
.54563 .60839 .55078 .61358 .56048 .61073 .55535 .60552 Mtetra
.55535 .60552 .56048 .61073 .57021 .60787 .5651 .60264 Mtetra
.5651 .60264 .57021 .60787 .57997 .605 .57489 .59975 Mtetra
.57489 .59975 .57997 .605 .58977 .60212 .58471 .59686 Mtetra
.58471 .59686 .58977 .60212 .59961 .59923 .59457 .59395 Mtetra
.59457 .59395 .59961 .59923 .60947 .59633 .60446 .59103 Mtetra
.60446 .59103 .60947 .59633 .61938 .59343 .61439 .58811 Mtetra
.61439 .58811 .61938 .59343 .62931 .59051 .62435 .58517 Mtetra
.62435 .58517 .62931 .59051 .63929 .58759 .63435 .58223 Mtetra
.63435 .58223 .63929 .58759 .6493 .58465 .64438 .57927 Mtetra
.64438 .57927 .6493 .58465 .65934 .58171 .65445 .57631 Mtetra
.65445 .57631 .65934 .58171 .66942 .57875 .66455 .57333 Mtetra
.66455 .57333 .66942 .57875 .67954 .57579 .67469 .57035 Mtetra
.67469 .57035 .67954 .57579 .68969 .57281 .68487 .56735 Mtetra
.68487 .56735 .68969 .57281 .69988 .56982 .69509 .56435 Mtetra
.69509 .56435 .69988 .56982 .7101 .56683 .70534 .56133 Mtetra
.70534 .56133 .7101 .56683 .72037 .56382 .71562 .5583 Mtetra
.71562 .5583 .72037 .56382 .73066 .56081 .72595 .55527 Mtetra
.72595 .55527 .73066 .56081 .741 .55778 .73631 .55222 Mtetra
.73631 .55222 .741 .55778 .75137 .55474 .74671 .54916 Mtetra
.74671 .54916 .75137 .55474 .76179 .55169 .75715 .54609 Mtetra
.75715 .54609 .76179 .55169 .77223 .54863 .76763 .54301 Mtetra
.76763 .54301 .77223 .54863 .78272 .54556 .77814 .53992 Mtetra
.77814 .53992 .78272 .54556 .79325 .54248 .78869 .53682 Mtetra
.78869 .53682 .79325 .54248 .80381 .53939 .79928 .53371 Mtetra
.79928 .53371 .80381 .53939 .81441 .53629 .80991 .53058 Mtetra
.80991 .53058 .81441 .53629 .82505 .53317 .82058 .52745 Mtetra
.82058 .52745 .82505 .53317 .83573 .53005 .83129 .5243 Mtetra
.83129 .5243 .83573 .53005 .84645 .52691 .84204 .52114 Mtetra
.84204 .52114 .84645 .52691 .85721 .52376 .85283 .51797 Mtetra
.85283 .51797 .85721 .52376 .86801 .52061 .86365 .51479 Mtetra
.86365 .51479 .86801 .52061 .87885 .51743 .87452 .5116 Mtetra
.87452 .5116 .87885 .51743 .88973 .51425 .88543 .5084 Mtetra
.88543 .5084 .88973 .51425 .90065 .51106 .89638 .50518 Mtetra
.89638 .50518 .90065 .51106 .91161 .50785 .90737 .50195 Mtetra
.90737 .50195 .91161 .50785 .92261 .50464 .9184 .49872 Mtetra
.9184 .49872 .92261 .50464 .93365 .50141 .92947 .49546 Mtetra
.92947 .49546 .93365 .50141 .94474 .49817 .94059 .4922 Mtetra
.94059 .4922 .94474 .49817 .95586 .49491 .95174 .48893 Mtetra
.401 .481 .827 r
.35289 .65171 .35822 .6619 .36723 .66064 .36166 .65532 Mtetra
.628 .728 .919 r
.36166 .65532 .36723 .66064 .37631 .65836 .37076 .65329 Mtetra
.646 .743 .92 r
.37076 .65329 .37631 .65836 .38544 .65585 .3799 .65085 Mtetra
.652 .748 .92 r
.3799 .65085 .38544 .65585 .3946 .65323 .38908 .64826 Mtetra
.655 .75 .92 r
.38908 .64826 .3946 .65323 .4038 .65055 .3983 .64558 Mtetra
.657 .752 .92 r
.3983 .64558 .4038 .65055 .41303 .64782 .40755 .64285 Mtetra
.658 .753 .92 r
.40755 .64285 .41303 .64782 .42229 .64505 .41683 .64008 Mtetra
.659 .754 .92 r
.41683 .64008 .42229 .64505 .43159 .64227 .42614 .63728 Mtetra
.42614 .63728 .43159 .64227 .44091 .63947 .43549 .63447 Mtetra
.43549 .63447 .44091 .63947 .45027 .63667 .44487 .63165 Mtetra
.44487 .63165 .45027 .63667 .45966 .63387 .45428 .62883 Mtetra
.658 .753 .92 r
.45428 .62883 .45966 .63387 .46908 .63106 .46372 .626 Mtetra
.46372 .626 .46908 .63106 .47853 .62825 .47319 .62317 Mtetra
.47319 .62317 .47853 .62825 .48802 .62544 .4827 .62033 Mtetra
.4827 .62033 .48802 .62544 .49754 .62261 .49224 .61749 Mtetra
.49224 .61749 .49754 .62261 .50709 .61979 .50181 .61464 Mtetra
.50181 .61464 .50709 .61979 .51667 .61695 .51142 .61179 Mtetra
.51142 .61179 .51667 .61695 .52629 .6141 .52106 .60892 Mtetra
.657 .753 .92 r
.52106 .60892 .52629 .6141 .53594 .61125 .53074 .60605 Mtetra
.53074 .60605 .53594 .61125 .54563 .60839 .54044 .60317 Mtetra
.657 .752 .92 r
.54044 .60317 .54563 .60839 .55535 .60552 .55019 .60028 Mtetra
.55019 .60028 .55535 .60552 .5651 .60264 .55996 .59738 Mtetra
.55996 .59738 .5651 .60264 .57489 .59975 .56977 .59448 Mtetra
.56977 .59448 .57489 .59975 .58471 .59686 .57962 .59156 Mtetra
.57962 .59156 .58471 .59686 .59457 .59395 .5895 .58863 Mtetra
.5895 .58863 .59457 .59395 .60446 .59103 .59941 .5857 Mtetra
.59941 .5857 .60446 .59103 .61439 .58811 .60936 .58275 Mtetra
.60936 .58275 .61439 .58811 .62435 .58517 .61935 .5798 Mtetra
.61935 .5798 .62435 .58517 .63435 .58223 .62937 .57683 Mtetra
.62937 .57683 .63435 .58223 .64438 .57927 .63943 .57386 Mtetra
.63943 .57386 .64438 .57927 .65445 .57631 .64952 .57087 Mtetra
.64952 .57087 .65445 .57631 .66455 .57333 .65965 .56788 Mtetra
.65965 .56788 .66455 .57333 .67469 .57035 .66982 .56487 Mtetra
.66982 .56487 .67469 .57035 .68487 .56735 .68002 .56186 Mtetra
.68002 .56186 .68487 .56735 .69509 .56435 .69026 .55883 Mtetra
.69026 .55883 .69509 .56435 .70534 .56133 .70054 .5558 Mtetra
.70054 .5558 .70534 .56133 .71562 .5583 .71085 .55275 Mtetra
.71085 .55275 .71562 .5583 .72595 .55527 .7212 .54969 Mtetra
.7212 .54969 .72595 .55527 .73631 .55222 .73159 .54662 Mtetra
.73159 .54662 .73631 .55222 .74671 .54916 .74202 .54354 Mtetra
.74202 .54354 .74671 .54916 .75715 .54609 .75248 .54045 Mtetra
.75248 .54045 .75715 .54609 .76763 .54301 .76298 .53735 Mtetra
.76298 .53735 .76763 .54301 .77814 .53992 .77353 .53424 Mtetra
.77353 .53424 .77814 .53992 .78869 .53682 .78411 .53112 Mtetra
.78411 .53112 .78869 .53682 .79928 .53371 .79472 .52799 Mtetra
.79472 .52799 .79928 .53371 .80991 .53058 .80538 .52484 Mtetra
.80538 .52484 .80991 .53058 .82058 .52745 .81608 .52168 Mtetra
.81608 .52168 .82058 .52745 .83129 .5243 .82682 .51852 Mtetra
.82682 .51852 .83129 .5243 .84204 .52114 .83759 .51534 Mtetra
.83759 .51534 .84204 .52114 .85283 .51797 .84841 .51214 Mtetra
.84841 .51214 .85283 .51797 .86365 .51479 .85927 .50894 Mtetra
.85927 .50894 .86365 .51479 .87452 .5116 .87016 .50573 Mtetra
.87016 .50573 .87452 .5116 .88543 .5084 .8811 .5025 Mtetra
.8811 .5025 .88543 .5084 .89638 .50518 .89208 .49926 Mtetra
.89208 .49926 .89638 .50518 .90737 .50195 .9031 .49601 Mtetra
.9031 .49601 .90737 .50195 .9184 .49872 .91416 .49275 Mtetra
.91416 .49275 .9184 .49872 .92947 .49546 .92527 .48948 Mtetra
.92527 .48948 .92947 .49546 .94059 .4922 .93641 .48619 Mtetra
.93641 .48619 .94059 .4922 .95174 .48893 .9476 .48289 Mtetra
0 0 0 r
.34657 .66043 .35289 .65171 .36166 .65532 .3561 .64941 Mtetra
.596 .697 .913 r
.3561 .64941 .36166 .65532 .37076 .65329 .36517 .64811 Mtetra
.64 .738 .92 r
.36517 .64811 .37076 .65329 .3799 .65085 .37433 .64579 Mtetra
.649 .746 .92 r
.37433 .64579 .3799 .65085 .38908 .64826 .38352 .64324 Mtetra
.654 .749 .92 r
.38352 .64324 .38908 .64826 .3983 .64558 .39276 .64058 Mtetra
.656 .751 .92 r
.39276 .64058 .3983 .64558 .40755 .64285 .40203 .63785 Mtetra
.658 .753 .92 r
.40203 .63785 .40755 .64285 .41683 .64008 .41133 .63507 Mtetra
.659 .753 .92 r
.41133 .63507 .41683 .64008 .42614 .63728 .42066 .63226 Mtetra
.659 .754 .92 r
.42066 .63226 .42614 .63728 .43549 .63447 .43003 .62944 Mtetra
.43003 .62944 .43549 .63447 .44487 .63165 .43943 .6266 Mtetra
.43943 .6266 .44487 .63165 .45428 .62883 .44886 .62375 Mtetra
.659 .753 .92 r
.44886 .62375 .45428 .62883 .46372 .626 .45832 .6209 Mtetra
.658 .753 .92 r
.45832 .6209 .46372 .626 .47319 .62317 .46782 .61805 Mtetra
.46782 .61805 .47319 .62317 .4827 .62033 .47735 .6152 Mtetra
.47735 .6152 .4827 .62033 .49224 .61749 .48691 .61233 Mtetra
.48691 .61233 .49224 .61749 .50181 .61464 .49651 .60947 Mtetra
.49651 .60947 .50181 .61464 .51142 .61179 .50613 .60659 Mtetra
.50613 .60659 .51142 .61179 .52106 .60892 .5158 .60371 Mtetra
.657 .753 .92 r
.5158 .60371 .52106 .60892 .53074 .60605 .52549 .60082 Mtetra
.52549 .60082 .53074 .60605 .54044 .60317 .53522 .59792 Mtetra
.53522 .59792 .54044 .60317 .55019 .60028 .54499 .59501 Mtetra
.657 .752 .92 r
.54499 .59501 .55019 .60028 .55996 .59738 .55479 .59209 Mtetra
.55479 .59209 .55996 .59738 .56977 .59448 .56462 .58916 Mtetra
.56462 .58916 .56977 .59448 .57962 .59156 .57449 .58623 Mtetra
.57449 .58623 .57962 .59156 .5895 .58863 .58439 .58328 Mtetra
.58439 .58328 .5895 .58863 .59941 .5857 .59433 .58033 Mtetra
.59433 .58033 .59941 .5857 .60936 .58275 .60431 .57736 Mtetra
.60431 .57736 .60936 .58275 .61935 .5798 .61432 .57439 Mtetra
.61432 .57439 .61935 .5798 .62937 .57683 .62436 .5714 Mtetra
.62436 .5714 .62937 .57683 .63943 .57386 .63445 .56841 Mtetra
.63445 .56841 .63943 .57386 .64952 .57087 .64456 .5654 Mtetra
.64456 .5654 .64952 .57087 .65965 .56788 .65472 .56239 Mtetra
.65472 .56239 .65965 .56788 .66982 .56487 .66491 .55936 Mtetra
.66491 .55936 .66982 .56487 .68002 .56186 .67514 .55633 Mtetra
.67514 .55633 .68002 .56186 .69026 .55883 .6854 .55328 Mtetra
.6854 .55328 .69026 .55883 .70054 .5558 .6957 .55022 Mtetra
.6957 .55022 .70054 .5558 .71085 .55275 .70604 .54716 Mtetra
.70604 .54716 .71085 .55275 .7212 .54969 .71642 .54408 Mtetra
.71642 .54408 .7212 .54969 .73159 .54662 .72684 .54099 Mtetra
.72684 .54099 .73159 .54662 .74202 .54354 .73729 .53789 Mtetra
.73729 .53789 .74202 .54354 .75248 .54045 .74778 .53478 Mtetra
.74778 .53478 .75248 .54045 .76298 .53735 .75831 .53166 Mtetra
.75831 .53166 .76298 .53735 .77353 .53424 .76888 .52852 Mtetra
.76888 .52852 .77353 .53424 .78411 .53112 .77949 .52538 Mtetra
.77949 .52538 .78411 .53112 .79472 .52799 .79013 .52222 Mtetra
.79013 .52222 .79472 .52799 .80538 .52484 .80082 .51906 Mtetra
.80082 .51906 .80538 .52484 .81608 .52168 .81155 .51588 Mtetra
.81155 .51588 .81608 .52168 .82682 .51852 .82231 .51269 Mtetra
.82231 .51269 .82682 .51852 .83759 .51534 .83312 .50949 Mtetra
.83312 .50949 .83759 .51534 .84841 .51214 .84396 .50628 Mtetra
.84396 .50628 .84841 .51214 .85927 .50894 .85485 .50305 Mtetra
.85485 .50305 .85927 .50894 .87016 .50573 .86578 .49981 Mtetra
.86578 .49981 .87016 .50573 .8811 .5025 .87674 .49657 Mtetra
.87674 .49657 .8811 .5025 .89208 .49926 .88775 .4933 Mtetra
.88775 .4933 .89208 .49926 .9031 .49601 .8988 .49003 Mtetra
.8988 .49003 .9031 .49601 .91416 .49275 .90989 .48675 Mtetra
.90989 .48675 .91416 .49275 .92527 .48948 .92103 .48345 Mtetra
.92103 .48345 .92527 .48948 .93641 .48619 .9322 .48014 Mtetra
.9322 .48014 .93641 .48619 .9476 .48289 .94342 .47682 Mtetra
.8 .685 .738 r
.34109 .65155 .34657 .66043 .3561 .64941 .35072 .63912 Mtetra
.4 .481 .827 r
.35072 .63912 .3561 .64941 .36517 .64811 .35956 .64271 Mtetra
.628 .728 .919 r
.35956 .64271 .36517 .64811 .37433 .64579 .36872 .64065 Mtetra
.646 .743 .92 r
.36872 .64065 .37433 .64579 .38352 .64324 .37793 .63816 Mtetra
.652 .748 .92 r
.37793 .63816 .38352 .64324 .39276 .64058 .38719 .63552 Mtetra
.655 .75 .92 r
.38719 .63552 .39276 .64058 .40203 .63785 .39647 .63281 Mtetra
.657 .752 .92 r
.39647 .63281 .40203 .63785 .41133 .63507 .40579 .63003 Mtetra
.658 .753 .92 r
.40579 .63003 .41133 .63507 .42066 .63226 .41515 .62721 Mtetra
.659 .754 .92 r
.41515 .62721 .42066 .63226 .43003 .62944 .42454 .62437 Mtetra
.42454 .62437 .43003 .62944 .43943 .6266 .43396 .62151 Mtetra
.43396 .62151 .43943 .6266 .44886 .62375 .44341 .61865 Mtetra
.44341 .61865 .44886 .62375 .45832 .6209 .45289 .61578 Mtetra
.658 .753 .92 r
.45289 .61578 .45832 .6209 .46782 .61805 .46241 .6129 Mtetra
.46241 .6129 .46782 .61805 .47735 .6152 .47196 .61003 Mtetra
.47196 .61003 .47735 .6152 .48691 .61233 .48155 .60715 Mtetra
.48155 .60715 .48691 .61233 .49651 .60947 .49116 .60426 Mtetra
.49116 .60426 .49651 .60947 .50613 .60659 .50081 .60136 Mtetra
.50081 .60136 .50613 .60659 .5158 .60371 .5105 .59846 Mtetra
.5105 .59846 .5158 .60371 .52549 .60082 .52022 .59555 Mtetra
.657 .753 .92 r
.52022 .59555 .52549 .60082 .53522 .59792 .52997 .59263 Mtetra
.52997 .59263 .53522 .59792 .54499 .59501 .53976 .5897 Mtetra
.657 .752 .92 r
.53976 .5897 .54499 .59501 .55479 .59209 .54958 .58676 Mtetra
.54958 .58676 .55479 .59209 .56462 .58916 .55944 .58382 Mtetra
.55944 .58382 .56462 .58916 .57449 .58623 .56933 .58086 Mtetra
.56933 .58086 .57449 .58623 .58439 .58328 .57926 .5779 Mtetra
.57926 .5779 .58439 .58328 .59433 .58033 .58922 .57492 Mtetra
.58922 .57492 .59433 .58033 .60431 .57736 .59922 .57194 Mtetra
.59922 .57194 .60431 .57736 .61432 .57439 .60925 .56894 Mtetra
.60925 .56894 .61432 .57439 .62436 .5714 .61932 .56594 Mtetra
.61932 .56594 .62436 .5714 .63445 .56841 .62943 .56292 Mtetra
.62943 .56292 .63445 .56841 .64456 .5654 .63957 .5599 Mtetra
.63957 .5599 .64456 .5654 .65472 .56239 .64975 .55686 Mtetra
.64975 .55686 .65472 .56239 .66491 .55936 .65997 .55382 Mtetra
.65997 .55382 .66491 .55936 .67514 .55633 .67022 .55076 Mtetra
.67022 .55076 .67514 .55633 .6854 .55328 .68051 .54769 Mtetra
.68051 .54769 .6854 .55328 .6957 .55022 .69084 .54462 Mtetra
.69084 .54462 .6957 .55022 .70604 .54716 .70121 .54153 Mtetra
.70121 .54153 .70604 .54716 .71642 .54408 .71161 .53843 Mtetra
.71161 .53843 .71642 .54408 .72684 .54099 .72205 .53532 Mtetra
.72205 .53532 .72684 .54099 .73729 .53789 .73253 .5322 Mtetra
.73253 .5322 .73729 .53789 .74778 .53478 .74305 .52906 Mtetra
.74305 .52906 .74778 .53478 .75831 .53166 .75361 .52592 Mtetra
.75361 .52592 .75831 .53166 .76888 .52852 .7642 .52277 Mtetra
.7642 .52277 .76888 .52852 .77949 .52538 .77484 .5196 Mtetra
.77484 .5196 .77949 .52538 .79013 .52222 .78551 .51642 Mtetra
.78551 .51642 .79013 .52222 .80082 .51906 .79623 .51324 Mtetra
.79623 .51324 .80082 .51906 .81155 .51588 .80698 .51004 Mtetra
.80698 .51004 .81155 .51588 .82231 .51269 .81778 .50682 Mtetra
.81778 .50682 .82231 .51269 .83312 .50949 .82861 .5036 Mtetra
.82861 .5036 .83312 .50949 .84396 .50628 .83948 .50036 Mtetra
.83948 .50036 .84396 .50628 .85485 .50305 .8504 .49712 Mtetra
.8504 .49712 .85485 .50305 .86578 .49981 .86136 .49386 Mtetra
.86136 .49386 .86578 .49981 .87674 .49657 .87235 .49059 Mtetra
.87235 .49059 .87674 .49657 .88775 .4933 .88339 .4873 Mtetra
.88339 .4873 .88775 .4933 .8988 .49003 .89447 .48401 Mtetra
.89447 .48401 .8988 .49003 .90989 .48675 .9056 .4807 Mtetra
.9056 .4807 .90989 .48675 .92103 .48345 .91676 .47738 Mtetra
.91676 .47738 .92103 .48345 .9322 .48014 .92797 .47405 Mtetra
.92797 .47405 .9322 .48014 .94342 .47682 .93922 .4707 Mtetra
.339 .589 .937 r
.33543 .64568 .34109 .65155 .35072 .63912 .34433 .64782 Mtetra
0 0 0 r
.34433 .64782 .35072 .63912 .35956 .64271 .35394 .63671 Mtetra
.596 .697 .913 r
.35394 .63671 .35956 .64271 .36872 .64065 .36308 .63538 Mtetra
.64 .738 .92 r
.36308 .63538 .36872 .64065 .37793 .63816 .37231 .63302 Mtetra
.649 .746 .92 r
.37231 .63302 .37793 .63816 .38719 .63552 .38158 .63042 Mtetra
.653 .749 .92 r
.38158 .63042 .38719 .63552 .39647 .63281 .39088 .62772 Mtetra
.656 .751 .92 r
.39088 .62772 .39647 .63281 .40579 .63003 .40023 .62494 Mtetra
.658 .753 .92 r
.40023 .62494 .40579 .63003 .41515 .62721 .4096 .62212 Mtetra
.659 .753 .92 r
.4096 .62212 .41515 .62721 .42454 .62437 .41901 .61927 Mtetra
.659 .754 .92 r
.41901 .61927 .42454 .62437 .43396 .62151 .42845 .61639 Mtetra
.42845 .61639 .43396 .62151 .44341 .61865 .43792 .61351 Mtetra
.43792 .61351 .44341 .61865 .45289 .61578 .44743 .61062 Mtetra
.659 .753 .92 r
.44743 .61062 .45289 .61578 .46241 .6129 .45697 .60772 Mtetra
.658 .753 .92 r
.45697 .60772 .46241 .6129 .47196 .61003 .46654 .60483 Mtetra
.46654 .60483 .47196 .61003 .48155 .60715 .47615 .60192 Mtetra
.47615 .60192 .48155 .60715 .49116 .60426 .48579 .59901 Mtetra
.48579 .59901 .49116 .60426 .50081 .60136 .49546 .5961 Mtetra
.49546 .5961 .50081 .60136 .5105 .59846 .50517 .59318 Mtetra
.50517 .59318 .5105 .59846 .52022 .59555 .51491 .59025 Mtetra
.657 .753 .92 r
.51491 .59025 .52022 .59555 .52997 .59263 .52468 .58731 Mtetra
.52468 .58731 .52997 .59263 .53976 .5897 .53449 .58436 Mtetra
.53449 .58436 .53976 .5897 .54958 .58676 .54434 .5814 Mtetra
.657 .752 .92 r
.54434 .5814 .54958 .58676 .55944 .58382 .55422 .57843 Mtetra
.55422 .57843 .55944 .58382 .56933 .58086 .56413 .57546 Mtetra
.56413 .57546 .56933 .58086 .57926 .5779 .57409 .57247 Mtetra
.57409 .57247 .57926 .5779 .58922 .57492 .58407 .56948 Mtetra
.58407 .56948 .58922 .57492 .59922 .57194 .59409 .56647 Mtetra
.59409 .56647 .59922 .57194 .60925 .56894 .60415 .56346 Mtetra
.60415 .56346 .60925 .56894 .61932 .56594 .61425 .56043 Mtetra
.61425 .56043 .61932 .56594 .62943 .56292 .62438 .5574 Mtetra
.62438 .5574 .62943 .56292 .63957 .5599 .63455 .55435 Mtetra
.63455 .55435 .63957 .5599 .64975 .55686 .64475 .5513 Mtetra
.64475 .5513 .64975 .55686 .65997 .55382 .65499 .54823 Mtetra
.65499 .54823 .65997 .55382 .67022 .55076 .66527 .54515 Mtetra
.66527 .54515 .67022 .55076 .68051 .54769 .67559 .54207 Mtetra
.67559 .54207 .68051 .54769 .69084 .54462 .68594 .53897 Mtetra
.68594 .53897 .69084 .54462 .70121 .54153 .69633 .53586 Mtetra
.69633 .53586 .70121 .54153 .71161 .53843 .70676 .53274 Mtetra
.70676 .53274 .71161 .53843 .72205 .53532 .71723 .52961 Mtetra
.71723 .52961 .72205 .53532 .73253 .5322 .72774 .52647 Mtetra
.72774 .52647 .73253 .5322 .74305 .52906 .73829 .52331 Mtetra
.73829 .52331 .74305 .52906 .75361 .52592 .74887 .52015 Mtetra
.74887 .52015 .75361 .52592 .7642 .52277 .75949 .51697 Mtetra
.75949 .51697 .7642 .52277 .77484 .5196 .77016 .51378 Mtetra
.77016 .51378 .77484 .5196 .78551 .51642 .78086 .51058 Mtetra
.78086 .51058 .78551 .51642 .79623 .51324 .7916 .50737 Mtetra
.7916 .50737 .79623 .51324 .80698 .51004 .80238 .50415 Mtetra
.80238 .50415 .80698 .51004 .81778 .50682 .81321 .50092 Mtetra
.81321 .50092 .81778 .50682 .82861 .5036 .82407 .49767 Mtetra
.82407 .49767 .82861 .5036 .83948 .50036 .83497 .49441 Mtetra
.83497 .49441 .83948 .50036 .8504 .49712 .84592 .49114 Mtetra
.84592 .49114 .8504 .49712 .86136 .49386 .85691 .48786 Mtetra
.85691 .48786 .86136 .49386 .87235 .49059 .86793 .48457 Mtetra
.86793 .48457 .87235 .49059 .88339 .4873 .879 .48126 Mtetra
.879 .48126 .88339 .4873 .89447 .48401 .89011 .47794 Mtetra
.89011 .47794 .89447 .48401 .9056 .4807 .90127 .47461 Mtetra
.90127 .47461 .9056 .4807 .91676 .47738 .91246 .47127 Mtetra
.91246 .47127 .91676 .47738 .92797 .47405 .9237 .46791 Mtetra
.9237 .46791 .92797 .47405 .93922 .4707 .93498 .46455 Mtetra
.594 .717 .93 r
.32971 .64024 .33543 .64568 .34433 .64782 .33881 .63884 Mtetra
.8 .685 .738 r
.33881 .63884 .34433 .64782 .35394 .63671 .34851 .62632 Mtetra
.399 .48 .827 r
.34851 .62632 .35394 .63671 .36308 .63538 .35742 .6299 Mtetra
.628 .728 .919 r
.35742 .6299 .36308 .63538 .37231 .63302 .36665 .62779 Mtetra
.646 .743 .92 r
.36665 .62779 .37231 .63302 .38158 .63042 .37594 .62526 Mtetra
.652 .748 .92 r
.37594 .62526 .38158 .63042 .39088 .62772 .38526 .62258 Mtetra
.655 .75 .92 r
.38526 .62258 .39088 .62772 .40023 .62494 .39462 .61982 Mtetra
.657 .752 .92 r
.39462 .61982 .40023 .62494 .4096 .62212 .40402 .617 Mtetra
.658 .753 .92 r
.40402 .617 .4096 .62212 .41901 .61927 .41344 .61413 Mtetra
.659 .754 .92 r
.41344 .61413 .41901 .61927 .42845 .61639 .42291 .61124 Mtetra
.42291 .61124 .42845 .61639 .43792 .61351 .4324 .60834 Mtetra
.4324 .60834 .43792 .61351 .44743 .61062 .44193 .60543 Mtetra
.44193 .60543 .44743 .61062 .45697 .60772 .45149 .60251 Mtetra
.658 .753 .92 r
.45149 .60251 .45697 .60772 .46654 .60483 .46108 .59959 Mtetra
.46108 .59959 .46654 .60483 .47615 .60192 .47071 .59667 Mtetra
.47071 .59667 .47615 .60192 .48579 .59901 .48037 .59374 Mtetra
.48037 .59374 .48579 .59901 .49546 .5961 .49007 .5908 Mtetra
.49007 .5908 .49546 .5961 .50517 .59318 .4998 .58786 Mtetra
.4998 .58786 .50517 .59318 .51491 .59025 .50956 .58491 Mtetra
.50956 .58491 .51491 .59025 .52468 .58731 .51936 .58195 Mtetra
.657 .753 .92 r
.51936 .58195 .52468 .58731 .53449 .58436 .52919 .57898 Mtetra
.52919 .57898 .53449 .58436 .54434 .5814 .53906 .576 Mtetra
.657 .752 .92 r
.53906 .576 .54434 .5814 .55422 .57843 .54897 .57302 Mtetra
.54897 .57302 .55422 .57843 .56413 .57546 .5589 .57002 Mtetra
.5589 .57002 .56413 .57546 .57409 .57247 .56888 .56702 Mtetra
.56888 .56702 .57409 .57247 .58407 .56948 .57889 .564 Mtetra
.57889 .564 .58407 .56948 .59409 .56647 .58894 .56098 Mtetra
.58894 .56098 .59409 .56647 .60415 .56346 .59902 .55794 Mtetra
.59902 .55794 .60415 .56346 .61425 .56043 .60914 .55489 Mtetra
.60914 .55489 .61425 .56043 .62438 .5574 .6193 .55184 Mtetra
.6193 .55184 .62438 .5574 .63455 .55435 .62949 .54877 Mtetra
.62949 .54877 .63455 .55435 .64475 .5513 .63972 .5457 Mtetra
.63972 .5457 .64475 .5513 .65499 .54823 .64999 .54261 Mtetra
.64999 .54261 .65499 .54823 .66527 .54515 .66029 .53951 Mtetra
.66029 .53951 .66527 .54515 .67559 .54207 .67063 .5364 Mtetra
.67063 .5364 .67559 .54207 .68594 .53897 .68101 .53328 Mtetra
.68101 .53328 .68594 .53897 .69633 .53586 .69143 .53015 Mtetra
.69143 .53015 .69633 .53586 .70676 .53274 .70189 .52701 Mtetra
.70189 .52701 .70676 .53274 .71723 .52961 .71238 .52386 Mtetra
.71238 .52386 .71723 .52961 .72774 .52647 .72292 .52069 Mtetra
.72292 .52069 .72774 .52647 .73829 .52331 .73349 .51752 Mtetra
.73349 .51752 .73829 .52331 .74887 .52015 .7441 .51433 Mtetra
.7441 .51433 .74887 .52015 .75949 .51697 .75475 .51113 Mtetra
.75475 .51113 .75949 .51697 .77016 .51378 .76544 .50792 Mtetra
.76544 .50792 .77016 .51378 .78086 .51058 .77617 .5047 Mtetra
.77617 .5047 .78086 .51058 .7916 .50737 .78695 .50147 Mtetra
.78695 .50147 .7916 .50737 .80238 .50415 .79776 .49823 Mtetra
.79776 .49823 .80238 .50415 .81321 .50092 .80861 .49497 Mtetra
.80861 .49497 .81321 .50092 .82407 .49767 .8195 .4917 Mtetra
.8195 .4917 .82407 .49767 .83497 .49441 .83043 .48842 Mtetra
.83043 .48842 .83497 .49441 .84592 .49114 .84141 .48513 Mtetra
.84141 .48513 .84592 .49114 .85691 .48786 .85242 .48182 Mtetra
.85242 .48182 .85691 .48786 .86793 .48457 .86348 .47851 Mtetra
.86348 .47851 .86793 .48457 .879 .48126 .87458 .47518 Mtetra
.87458 .47518 .879 .48126 .89011 .47794 .88572 .47184 Mtetra
.88572 .47184 .89011 .47794 .90127 .47461 .89691 .46848 Mtetra
.89691 .46848 .90127 .47461 .91246 .47127 .90814 .46511 Mtetra
.90814 .46511 .91246 .47127 .9237 .46791 .91941 .46173 Mtetra
.91941 .46173 .9237 .46791 .93498 .46455 .93072 .45834 Mtetra
.625 .733 .925 r
.32394 .63493 .32971 .64024 .33881 .63884 .33309 .63289 Mtetra
.341 .589 .937 r
.33309 .63289 .33881 .63884 .34851 .62632 .34206 .635 Mtetra
0 0 0 r
.34206 .635 .34851 .62632 .35742 .6299 .35175 .62381 Mtetra
.596 .697 .913 r
.35175 .62381 .35742 .6299 .36665 .62779 .36096 .62244 Mtetra
.64 .738 .92 r
.36096 .62244 .36665 .62779 .37594 .62526 .37026 .62003 Mtetra
.649 .746 .92 r
.37026 .62003 .37594 .62526 .38526 .62258 .3796 .61739 Mtetra
.653 .749 .92 r
.3796 .61739 .38526 .62258 .39462 .61982 .38898 .61464 Mtetra
.656 .751 .92 r
.38898 .61464 .39462 .61982 .40402 .617 .39839 .61183 Mtetra
.658 .753 .92 r
.39839 .61183 .40402 .617 .41344 .61413 .40784 .60896 Mtetra
.659 .753 .92 r
.40784 .60896 .41344 .61413 .42291 .61124 .41733 .60606 Mtetra
.659 .754 .92 r
.41733 .60606 .42291 .61124 .4324 .60834 .42684 .60314 Mtetra
.42684 .60314 .4324 .60834 .44193 .60543 .43639 .60021 Mtetra
.43639 .60021 .44193 .60543 .45149 .60251 .44597 .59727 Mtetra
.659 .753 .92 r
.44597 .59727 .45149 .60251 .46108 .59959 .45559 .59433 Mtetra
.658 .753 .92 r
.45559 .59433 .46108 .59959 .47071 .59667 .46524 .59138 Mtetra
.46524 .59138 .47071 .59667 .48037 .59374 .47492 .58843 Mtetra
.47492 .58843 .48037 .59374 .49007 .5908 .48464 .58547 Mtetra
.48464 .58547 .49007 .5908 .4998 .58786 .49439 .58251 Mtetra
.49439 .58251 .4998 .58786 .50956 .58491 .50418 .57954 Mtetra
.50418 .57954 .50956 .58491 .51936 .58195 .514 .57656 Mtetra
.657 .753 .92 r
.514 .57656 .51936 .58195 .52919 .57898 .52386 .57357 Mtetra
.52386 .57357 .52919 .57898 .53906 .576 .53375 .57057 Mtetra
.53375 .57057 .53906 .576 .54897 .57302 .54368 .56756 Mtetra
.657 .752 .92 r
.54368 .56756 .54897 .57302 .5589 .57002 .55364 .56455 Mtetra
.55364 .56455 .5589 .57002 .56888 .56702 .56364 .56152 Mtetra
.56364 .56152 .56888 .56702 .57889 .564 .57367 .55849 Mtetra
.57367 .55849 .57889 .564 .58894 .56098 .58374 .55544 Mtetra
.58374 .55544 .58894 .56098 .59902 .55794 .59385 .55238 Mtetra
.59385 .55238 .59902 .55794 .60914 .55489 .604 .54932 Mtetra
.604 .54932 .60914 .55489 .6193 .55184 .61418 .54624 Mtetra
.61418 .54624 .6193 .55184 .62949 .54877 .62439 .54315 Mtetra
.62439 .54315 .62949 .54877 .63972 .5457 .63465 .54006 Mtetra
.63465 .54006 .63972 .5457 .64999 .54261 .64494 .53695 Mtetra
.64494 .53695 .64999 .54261 .66029 .53951 .65527 .53383 Mtetra
.65527 .53383 .66029 .53951 .67063 .5364 .66564 .5307 Mtetra
.66564 .5307 .67063 .5364 .68101 .53328 .67605 .52756 Mtetra
.67605 .52756 .68101 .53328 .69143 .53015 .68649 .52441 Mtetra
.68649 .52441 .69143 .53015 .70189 .52701 .69698 .52124 Mtetra
.69698 .52124 .70189 .52701 .71238 .52386 .7075 .51807 Mtetra
.7075 .51807 .71238 .52386 .72292 .52069 .71806 .51488 Mtetra
.71806 .51488 .72292 .52069 .73349 .51752 .72866 .51169 Mtetra
.72866 .51169 .73349 .51752 .7441 .51433 .7393 .50848 Mtetra
.7393 .50848 .7441 .51433 .75475 .51113 .74998 .50526 Mtetra
.74998 .50526 .75475 .51113 .76544 .50792 .7607 .50203 Mtetra
.7607 .50203 .76544 .50792 .77617 .5047 .77146 .49878 Mtetra
.77146 .49878 .77617 .5047 .78695 .50147 .78226 .49553 Mtetra
.78226 .49553 .78695 .50147 .79776 .49823 .7931 .49226 Mtetra
.7931 .49226 .79776 .49823 .80861 .49497 .80398 .48898 Mtetra
.80398 .48898 .80861 .49497 .8195 .4917 .8149 .48569 Mtetra
.8149 .48569 .8195 .4917 .83043 .48842 .82586 .48239 Mtetra
.82586 .48239 .83043 .48842 .84141 .48513 .83687 .47907 Mtetra
.83687 .47907 .84141 .48513 .85242 .48182 .84791 .47574 Mtetra
.84791 .47574 .85242 .48182 .86348 .47851 .859 .4724 Mtetra
.859 .4724 .86348 .47851 .87458 .47518 .87013 .46905 Mtetra
.87013 .46905 .87458 .47518 .88572 .47184 .8813 .46568 Mtetra
.8813 .46568 .88572 .47184 .89691 .46848 .89252 .46231 Mtetra
.89252 .46231 .89691 .46848 .90814 .46511 .90378 .45892 Mtetra
.90378 .45892 .90814 .46511 .91941 .46173 .91508 .45551 Mtetra
.91508 .45551 .91941 .46173 .93072 .45834 .92642 .4521 Mtetra
.635 .738 .923 r
.31814 .62964 .32394 .63493 .33309 .63289 .32732 .62737 Mtetra
.594 .717 .93 r
.32732 .62737 .33309 .63289 .34206 .635 .33649 .62593 Mtetra
.801 .686 .738 r
.33649 .62593 .34206 .635 .35175 .62381 .34627 .61331 Mtetra
.398 .48 .827 r
.34627 .61331 .35175 .62381 .36096 .62244 .35525 .61688 Mtetra
.628 .728 .919 r
.35525 .61688 .36096 .62244 .37026 .62003 .36455 .61472 Mtetra
.646 .743 .92 r
.36455 .61472 .37026 .62003 .3796 .61739 .37391 .61215 Mtetra
.652 .748 .92 r
.37391 .61215 .3796 .61739 .38898 .61464 .3833 .60942 Mtetra
.655 .75 .92 r
.3833 .60942 .38898 .61464 .39839 .61183 .39274 .60661 Mtetra
.657 .752 .92 r
.39274 .60661 .39839 .61183 .40784 .60896 .40221 .60375 Mtetra
.658 .753 .92 r
.40221 .60375 .40784 .60896 .41733 .60606 .41171 .60084 Mtetra
.659 .754 .92 r
.41171 .60084 .41733 .60606 .42684 .60314 .42125 .5979 Mtetra
.42125 .5979 .42684 .60314 .43639 .60021 .43082 .59495 Mtetra
.43082 .59495 .43639 .60021 .44597 .59727 .44042 .59199 Mtetra
.44042 .59199 .44597 .59727 .45559 .59433 .45006 .58903 Mtetra
.658 .753 .92 r
.45006 .58903 .45559 .59433 .46524 .59138 .45973 .58606 Mtetra
.45973 .58606 .46524 .59138 .47492 .58843 .46944 .58309 Mtetra
.46944 .58309 .47492 .58843 .48464 .58547 .47918 .58011 Mtetra
.47918 .58011 .48464 .58547 .49439 .58251 .48895 .57712 Mtetra
.48895 .57712 .49439 .58251 .50418 .57954 .49876 .57413 Mtetra
.49876 .57413 .50418 .57954 .514 .57656 .50861 .57113 Mtetra
.50861 .57113 .514 .57656 .52386 .57357 .51849 .56812 Mtetra
.657 .753 .92 r
.51849 .56812 .52386 .57357 .53375 .57057 .5284 .5651 Mtetra
.5284 .5651 .53375 .57057 .54368 .56756 .53835 .56207 Mtetra
.657 .752 .92 r
.53835 .56207 .54368 .56756 .55364 .56455 .54834 .55904 Mtetra
.54834 .55904 .55364 .56455 .56364 .56152 .55836 .55599 Mtetra
.55836 .55599 .56364 .56152 .57367 .55849 .56842 .55293 Mtetra
.56842 .55293 .57367 .55849 .58374 .55544 .57852 .54987 Mtetra
.57852 .54987 .58374 .55544 .59385 .55238 .58865 .54679 Mtetra
.58865 .54679 .59385 .55238 .604 .54932 .59882 .5437 Mtetra
.59882 .5437 .604 .54932 .61418 .54624 .60902 .54061 Mtetra
.60902 .54061 .61418 .54624 .62439 .54315 .61927 .5375 Mtetra
.61927 .5375 .62439 .54315 .63465 .54006 .62955 .53438 Mtetra
.62955 .53438 .63465 .54006 .64494 .53695 .63987 .53125 Mtetra
.63987 .53125 .64494 .53695 .65527 .53383 .65022 .52811 Mtetra
.65022 .52811 .65527 .53383 .66564 .5307 .66062 .52496 Mtetra
.66062 .52496 .66564 .5307 .67605 .52756 .67105 .5218 Mtetra
.67105 .5218 .67605 .52756 .68649 .52441 .68152 .51862 Mtetra
.68152 .51862 .68649 .52441 .69698 .52124 .69203 .51544 Mtetra
.69203 .51544 .69698 .52124 .7075 .51807 .70258 .51224 Mtetra
.70258 .51224 .7075 .51807 .71806 .51488 .71317 .50903 Mtetra
.71317 .50903 .71806 .51488 .72866 .51169 .7238 .50581 Mtetra
.7238 .50581 .72866 .51169 .7393 .50848 .73446 .50258 Mtetra
.73446 .50258 .7393 .50848 .74998 .50526 .74517 .49934 Mtetra
.74517 .49934 .74998 .50526 .7607 .50203 .75592 .49609 Mtetra
.75592 .49609 .7607 .50203 .77146 .49878 .76671 .49282 Mtetra
.76671 .49282 .77146 .49878 .78226 .49553 .77753 .48954 Mtetra
.77753 .48954 .78226 .49553 .7931 .49226 .7884 .48625 Mtetra
.7884 .48625 .7931 .49226 .80398 .48898 .79931 .48295 Mtetra
.79931 .48295 .80398 .48898 .8149 .48569 .81026 .47964 Mtetra
.81026 .47964 .8149 .48569 .82586 .48239 .82126 .47631 Mtetra
.82126 .47631 .82586 .48239 .83687 .47907 .83229 .47297 Mtetra
.83229 .47297 .83687 .47907 .84791 .47574 .84337 .46962 Mtetra
.84337 .46962 .84791 .47574 .859 .4724 .85449 .46625 Mtetra
.85449 .46625 .859 .4724 .87013 .46905 .86565 .46288 Mtetra
.86565 .46288 .87013 .46905 .8813 .46568 .87685 .45949 Mtetra
.87685 .45949 .8813 .46568 .89252 .46231 .8881 .45609 Mtetra
.8881 .45609 .89252 .46231 .90378 .45892 .89939 .45267 Mtetra
.89939 .45267 .90378 .45892 .91508 .45551 .91072 .44924 Mtetra
.91072 .44924 .91508 .45551 .92642 .4521 .9221 .4458 Mtetra
.639 .74 .922 r
.31229 .62435 .31814 .62964 .32732 .62737 .3215 .62197 Mtetra
.625 .733 .925 r
.3215 .62197 .32732 .62737 .33649 .62593 .33072 .61988 Mtetra
.342 .59 .937 r
.33072 .61988 .33649 .62593 .34627 .61331 .33975 .62197 Mtetra
0 0 0 r
.33975 .62197 .34627 .61331 .35525 .61688 .34952 .6107 Mtetra
.596 .697 .913 r
.34952 .6107 .35525 .61688 .36455 .61472 .3588 .60929 Mtetra
.64 .738 .92 r
.3588 .60929 .36455 .61472 .37391 .61215 .36818 .60684 Mtetra
.649 .746 .92 r
.36818 .60684 .37391 .61215 .3833 .60942 .37759 .60415 Mtetra
.653 .749 .92 r
.37759 .60415 .3833 .60942 .39274 .60661 .38704 .60136 Mtetra
.656 .751 .92 r
.38704 .60136 .39274 .60661 .40221 .60375 .39653 .59849 Mtetra
.658 .753 .92 r
.39653 .59849 .40221 .60375 .41171 .60084 .40606 .59558 Mtetra
.659 .753 .92 r
.40606 .59558 .41171 .60084 .42125 .5979 .41562 .59263 Mtetra
.659 .754 .92 r
.41562 .59263 .42125 .5979 .43082 .59495 .42521 .58966 Mtetra
.42521 .58966 .43082 .59495 .44042 .59199 .43483 .58668 Mtetra
.43483 .58668 .44042 .59199 .45006 .58903 .44449 .58369 Mtetra
.659 .753 .92 r
.44449 .58369 .45006 .58903 .45973 .58606 .45419 .5807 Mtetra
.658 .753 .92 r
.45419 .5807 .45973 .58606 .46944 .58309 .46392 .57771 Mtetra
.46392 .57771 .46944 .58309 .47918 .58011 .47368 .57471 Mtetra
.47368 .57471 .47918 .58011 .48895 .57712 .48348 .5717 Mtetra
.48348 .5717 .48895 .57712 .49876 .57413 .49331 .56869 Mtetra
.49331 .56869 .49876 .57413 .50861 .57113 .50318 .56567 Mtetra
.50318 .56567 .50861 .57113 .51849 .56812 .51308 .56264 Mtetra
.657 .753 .92 r
.51308 .56264 .51849 .56812 .5284 .5651 .52302 .5596 Mtetra
.52302 .5596 .5284 .5651 .53835 .56207 .53299 .55655 Mtetra
.53299 .55655 .53835 .56207 .54834 .55904 .543 .55349 Mtetra
.657 .752 .92 r
.543 .55349 .54834 .55904 .55836 .55599 .55305 .55042 Mtetra
.55305 .55042 .55836 .55599 .56842 .55293 .56313 .54735 Mtetra
.56313 .54735 .56842 .55293 .57852 .54987 .57325 .54426 Mtetra
.57325 .54426 .57852 .54987 .58865 .54679 .58341 .54116 Mtetra
.58341 .54116 .58865 .54679 .59882 .5437 .5936 .53805 Mtetra
.5936 .53805 .59882 .5437 .60902 .54061 .60384 .53493 Mtetra
.60384 .53493 .60902 .54061 .61927 .5375 .6141 .5318 Mtetra
.6141 .5318 .61927 .5375 .62955 .53438 .62441 .52866 Mtetra
.62441 .52866 .62955 .53438 .63987 .53125 .63475 .52551 Mtetra
.63475 .52551 .63987 .53125 .65022 .52811 .64514 .52235 Mtetra
.64514 .52235 .65022 .52811 .66062 .52496 .65556 .51918 Mtetra
.65556 .51918 .66062 .52496 .67105 .5218 .66602 .51599 Mtetra
.66602 .51599 .67105 .5218 .68152 .51862 .67652 .5128 Mtetra
.67652 .5128 .68152 .51862 .69203 .51544 .68705 .50959 Mtetra
.68705 .50959 .69203 .51544 .70258 .51224 .69763 .50637 Mtetra
.69763 .50637 .70258 .51224 .71317 .50903 .70824 .50314 Mtetra
.70824 .50314 .71317 .50903 .7238 .50581 .7189 .4999 Mtetra
.7189 .4999 .7238 .50581 .73446 .50258 .72959 .49665 Mtetra
.72959 .49665 .73446 .50258 .74517 .49934 .74033 .49338 Mtetra
.74033 .49338 .74517 .49934 .75592 .49609 .75111 .49011 Mtetra
.75111 .49011 .75592 .49609 .76671 .49282 .76192 .48682 Mtetra
.76192 .48682 .76671 .49282 .77753 .48954 .77278 .48352 Mtetra
.77278 .48352 .77753 .48954 .7884 .48625 .78368 .4802 Mtetra
.78368 .4802 .7884 .48625 .79931 .48295 .79462 .47688 Mtetra
.79462 .47688 .79931 .48295 .81026 .47964 .8056 .47354 Mtetra
.8056 .47354 .81026 .47964 .82126 .47631 .81662 .47019 Mtetra
.81662 .47019 .82126 .47631 .83229 .47297 .82768 .46683 Mtetra
.82768 .46683 .83229 .47297 .84337 .46962 .83879 .46345 Mtetra
.83879 .46345 .84337 .46962 .85449 .46625 .84994 .46006 Mtetra
.84994 .46006 .85449 .46625 .86565 .46288 .86113 .45666 Mtetra
.86113 .45666 .86565 .46288 .87685 .45949 .87237 .45325 Mtetra
.87237 .45325 .87685 .45949 .8881 .45609 .88365 .44982 Mtetra
.88365 .44982 .8881 .45609 .89939 .45267 .89497 .44638 Mtetra
.89497 .44638 .89939 .45267 .91072 .44924 .90633 .44293 Mtetra
.90633 .44293 .91072 .44924 .9221 .4458 .91774 .43947 Mtetra
.64 .74 .922 r
.30641 .61903 .31229 .62435 .3215 .62197 .31564 .6166 Mtetra
.635 .738 .923 r
.31564 .6166 .3215 .62197 .33072 .61988 .32489 .61427 Mtetra
.594 .717 .93 r
.32489 .61427 .33072 .61988 .33975 .62197 .33413 .61279 Mtetra
.801 .687 .738 r
.33413 .61279 .33975 .62197 .34952 .6107 .344 .60009 Mtetra
.397 .479 .827 r
.344 .60009 .34952 .6107 .3588 .60929 .35303 .60364 Mtetra
.628 .728 .919 r
.35303 .60364 .3588 .60929 .36818 .60684 .36241 .60144 Mtetra
.646 .743 .92 r
.36241 .60144 .36818 .60684 .37759 .60415 .37184 .59882 Mtetra
.652 .748 .92 r
.37184 .59882 .37759 .60415 .38704 .60136 .38131 .59605 Mtetra
.655 .75 .92 r
.38131 .59605 .38704 .60136 .39653 .59849 .39082 .59319 Mtetra
.657 .752 .92 r
.39082 .59319 .39653 .59849 .40606 .59558 .40037 .59028 Mtetra
.658 .753 .92 r
.40037 .59028 .40606 .59558 .41562 .59263 .40995 .58732 Mtetra
.659 .754 .92 r
.40995 .58732 .41562 .59263 .42521 .58966 .41956 .58433 Mtetra
.41956 .58433 .42521 .58966 .43483 .58668 .42921 .58133 Mtetra
.42921 .58133 .43483 .58668 .44449 .58369 .43889 .57833 Mtetra
.43889 .57833 .44449 .58369 .45419 .5807 .44861 .57531 Mtetra
.658 .753 .92 r
.44861 .57531 .45419 .5807 .46392 .57771 .45836 .57229 Mtetra
.45836 .57229 .46392 .57771 .47368 .57471 .46814 .56927 Mtetra
.46814 .56927 .47368 .57471 .48348 .5717 .47796 .56624 Mtetra
.47796 .56624 .48348 .5717 .49331 .56869 .48782 .56321 Mtetra
.48782 .56321 .49331 .56869 .50318 .56567 .49771 .56017 Mtetra
.49771 .56017 .50318 .56567 .51308 .56264 .50764 .55712 Mtetra
.50764 .55712 .51308 .56264 .52302 .5596 .5176 .55406 Mtetra
.657 .753 .92 r
.5176 .55406 .52302 .5596 .53299 .55655 .5276 .55099 Mtetra
.5276 .55099 .53299 .55655 .543 .55349 .53763 .54791 Mtetra
.657 .752 .92 r
.53763 .54791 .543 .55349 .55305 .55042 .5477 .54482 Mtetra
.5477 .54482 .55305 .55042 .56313 .54735 .55781 .54172 Mtetra
.55781 .54172 .56313 .54735 .57325 .54426 .56796 .53861 Mtetra
.56796 .53861 .57325 .54426 .58341 .54116 .57814 .53549 Mtetra
.57814 .53549 .58341 .54116 .5936 .53805 .58836 .53236 Mtetra
.58836 .53236 .5936 .53805 .60384 .53493 .59861 .52922 Mtetra
.59861 .52922 .60384 .53493 .6141 .5318 .60891 .52607 Mtetra
.60891 .52607 .6141 .5318 .62441 .52866 .61924 .52291 Mtetra
.61924 .52291 .62441 .52866 .63475 .52551 .62961 .51974 Mtetra
.62961 .51974 .63475 .52551 .64514 .52235 .64002 .51655 Mtetra
.64002 .51655 .64514 .52235 .65556 .51918 .65046 .51336 Mtetra
.65046 .51336 .65556 .51918 .66602 .51599 .66095 .51015 Mtetra
.66095 .51015 .66602 .51599 .67652 .5128 .67147 .50693 Mtetra
.67147 .50693 .67652 .5128 .68705 .50959 .68204 .5037 Mtetra
.68204 .5037 .68705 .50959 .69763 .50637 .69264 .50046 Mtetra
.69264 .50046 .69763 .50637 .70824 .50314 .70329 .49721 Mtetra
.70329 .49721 .70824 .50314 .7189 .4999 .71397 .49395 Mtetra
.71397 .49395 .7189 .4999 .72959 .49665 .72469 .49067 Mtetra
.72469 .49067 .72959 .49665 .74033 .49338 .73546 .48738 Mtetra
.73546 .48738 .74033 .49338 .75111 .49011 .74626 .48408 Mtetra
.74626 .48408 .75111 .49011 .76192 .48682 .7571 .48077 Mtetra
.7571 .48077 .76192 .48682 .77278 .48352 .76799 .47745 Mtetra
.76799 .47745 .77278 .48352 .78368 .4802 .77892 .47411 Mtetra
.77892 .47411 .78368 .4802 .79462 .47688 .78989 .47076 Mtetra
.78989 .47076 .79462 .47688 .8056 .47354 .8009 .4674 Mtetra
.8009 .4674 .8056 .47354 .81662 .47019 .81195 .46403 Mtetra
.81195 .46403 .81662 .47019 .82768 .46683 .82304 .46064 Mtetra
.82304 .46064 .82768 .46683 .83879 .46345 .83418 .45724 Mtetra
.83418 .45724 .83879 .46345 .84994 .46006 .84536 .45383 Mtetra
.84536 .45383 .84994 .46006 .86113 .45666 .85659 .4504 Mtetra
.85659 .4504 .86113 .45666 .87237 .45325 .86785 .44697 Mtetra
.86785 .44697 .87237 .45325 .88365 .44982 .87916 .44352 Mtetra
.87916 .44352 .88365 .44982 .89497 .44638 .89052 .44005 Mtetra
.89052 .44005 .89497 .44638 .90633 .44293 .90191 .43657 Mtetra
.90191 .43657 .90633 .44293 .91774 .43947 .91335 .43308 Mtetra
.639 .74 .921 r
.30049 .61365 .30641 .61903 .31564 .6166 .30973 .61122 Mtetra
.639 .74 .922 r
.30973 .61122 .31564 .6166 .32489 .61427 .31901 .60879 Mtetra
.625 .733 .925 r
.31901 .60879 .32489 .61427 .33413 .61279 .3283 .60666 Mtetra
.343 .59 .936 r
.3283 .60666 .33413 .61279 .344 .60009 .3374 .60873 Mtetra
0 0 0 r
.3374 .60873 .344 .60009 .35303 .60364 .34726 .59737 Mtetra
.596 .697 .913 r
.34726 .59737 .35303 .60364 .36241 .60144 .35661 .59592 Mtetra
.64 .738 .92 r
.35661 .59592 .36241 .60144 .37184 .59882 .36606 .59342 Mtetra
.649 .746 .92 r
.36606 .59342 .37184 .59882 .38131 .59605 .37555 .59069 Mtetra
.653 .749 .92 r
.37555 .59069 .38131 .59605 .39082 .59319 .38508 .58785 Mtetra
.656 .751 .92 r
.38508 .58785 .39082 .59319 .40037 .59028 .39464 .58493 Mtetra
.658 .753 .92 r
.39464 .58493 .40037 .59028 .40995 .58732 .40424 .58197 Mtetra
.659 .753 .92 r
.40424 .58197 .40995 .58732 .41956 .58433 .41388 .57897 Mtetra
.659 .754 .92 r
.41388 .57897 .41956 .58433 .42921 .58133 .42355 .57595 Mtetra
.42355 .57595 .42921 .58133 .43889 .57833 .43325 .57292 Mtetra
.43325 .57292 .43889 .57833 .44861 .57531 .44299 .56989 Mtetra
.659 .753 .92 r
.44299 .56989 .44861 .57531 .45836 .57229 .45276 .56685 Mtetra
.658 .753 .92 r
.45276 .56685 .45836 .57229 .46814 .56927 .46257 .5638 Mtetra
.46257 .5638 .46814 .56927 .47796 .56624 .47242 .56075 Mtetra
.47242 .56075 .47796 .56624 .48782 .56321 .48229 .5577 Mtetra
.48229 .5577 .48782 .56321 .49771 .56017 .49221 .55463 Mtetra
.49221 .55463 .49771 .56017 .50764 .55712 .50216 .55156 Mtetra
.50216 .55156 .50764 .55712 .5176 .55406 .51214 .54848 Mtetra
.657 .753 .92 r
.51214 .54848 .5176 .55406 .5276 .55099 .52217 .54539 Mtetra
.52217 .54539 .5276 .55099 .53763 .54791 .53222 .54229 Mtetra
.53222 .54229 .53763 .54791 .5477 .54482 .54232 .53918 Mtetra
.657 .752 .92 r
.54232 .53918 .5477 .54482 .55781 .54172 .55245 .53606 Mtetra
.55245 .53606 .55781 .54172 .56796 .53861 .56262 .53293 Mtetra
.56262 .53293 .56796 .53861 .57814 .53549 .57283 .52978 Mtetra
.57283 .52978 .57814 .53549 .58836 .53236 .58307 .52663 Mtetra
.58307 .52663 .58836 .53236 .59861 .52922 .59335 .52347 Mtetra
.59335 .52347 .59861 .52922 .60891 .52607 .60367 .5203 Mtetra
.60367 .5203 .60891 .52607 .61924 .52291 .61403 .51712 Mtetra
.61403 .51712 .61924 .52291 .62961 .51974 .62443 .51392 Mtetra
.62443 .51392 .62961 .51974 .64002 .51655 .63486 .51071 Mtetra
.63486 .51071 .64002 .51655 .65046 .51336 .64534 .5075 Mtetra
.64534 .5075 .65046 .51336 .66095 .51015 .65585 .50427 Mtetra
.65585 .50427 .66095 .51015 .67147 .50693 .6664 .50103 Mtetra
.6664 .50103 .67147 .50693 .68204 .5037 .67699 .49778 Mtetra
.67699 .49778 .68204 .5037 .69264 .50046 .68762 .49451 Mtetra
.68762 .49451 .69264 .50046 .70329 .49721 .69829 .49124 Mtetra
.69829 .49124 .70329 .49721 .71397 .49395 .709 .48795 Mtetra
.709 .48795 .71397 .49395 .72469 .49067 .71975 .48465 Mtetra
.71975 .48465 .72469 .49067 .73546 .48738 .73055 .48134 Mtetra
.73055 .48134 .73546 .48738 .74626 .48408 .74138 .47802 Mtetra
.74138 .47802 .74626 .48408 .7571 .48077 .75225 .47468 Mtetra
.75225 .47468 .7571 .48077 .76799 .47745 .76317 .47133 Mtetra
.76317 .47133 .76799 .47745 .77892 .47411 .77412 .46797 Mtetra
.77412 .46797 .77892 .47411 .78989 .47076 .78512 .4646 Mtetra
.78512 .4646 .78989 .47076 .8009 .4674 .79616 .46122 Mtetra
.79616 .46122 .8009 .4674 .81195 .46403 .80725 .45782 Mtetra
.80725 .45782 .81195 .46403 .82304 .46064 .81837 .45441 Mtetra
.81837 .45441 .82304 .46064 .83418 .45724 .82954 .45099 Mtetra
.82954 .45099 .83418 .45724 .84536 .45383 .84075 .44755 Mtetra
.84075 .44755 .84536 .45383 .85659 .4504 .85201 .4441 Mtetra
.85201 .4441 .85659 .4504 .86785 .44697 .8633 .44064 Mtetra
.8633 .44064 .86785 .44697 .87916 .44352 .87465 .43716 Mtetra
.87465 .43716 .87916 .44352 .89052 .44005 .88603 .43367 Mtetra
.88603 .43367 .89052 .44005 .90191 .43657 .89746 .43017 Mtetra
.89746 .43017 .90191 .43657 .91335 .43308 .90894 .42666 Mtetra
.636 .737 .921 r
.29454 .60819 .30049 .61365 .30973 .61122 .3038 .60581 Mtetra
.64 .74 .922 r
.3038 .60581 .30973 .61122 .31901 .60879 .31309 .60333 Mtetra
.635 .738 .923 r
.31309 .60333 .31901 .60879 .3283 .60666 .32242 .60097 Mtetra
.594 .717 .93 r
.32242 .60097 .3283 .60666 .3374 .60873 .33173 .59944 Mtetra
.802 .687 .738 r
.33173 .59944 .3374 .60873 .34726 .59737 .34168 .58665 Mtetra
.396 .479 .827 r
.34168 .58665 .34726 .59737 .35661 .59592 .35079 .59018 Mtetra
.628 .728 .919 r
.35079 .59018 .35661 .59592 .36606 .59342 .36024 .58794 Mtetra
.646 .743 .92 r
.36024 .58794 .36606 .59342 .37555 .59069 .36974 .58527 Mtetra
.652 .748 .92 r
.36974 .58527 .37555 .59069 .38508 .58785 .37929 .58245 Mtetra
.655 .75 .92 r
.37929 .58245 .38508 .58785 .39464 .58493 .38888 .57954 Mtetra
.657 .752 .92 r
.38888 .57954 .39464 .58493 .40424 .58197 .3985 .57658 Mtetra
.658 .753 .92 r
.3985 .57658 .40424 .58197 .41388 .57897 .40815 .57357 Mtetra
.659 .754 .92 r
.40815 .57357 .41388 .57897 .42355 .57595 .41785 .57054 Mtetra
.41785 .57054 .42355 .57595 .43325 .57292 .42757 .56749 Mtetra
.42757 .56749 .43325 .57292 .44299 .56989 .43733 .56443 Mtetra
.43733 .56443 .44299 .56989 .45276 .56685 .44713 .56137 Mtetra
.658 .753 .92 r
.44713 .56137 .45276 .56685 .46257 .5638 .45696 .5583 Mtetra
.45696 .5583 .46257 .5638 .47242 .56075 .46683 .55522 Mtetra
.46683 .55522 .47242 .56075 .48229 .5577 .47673 .55215 Mtetra
.47673 .55215 .48229 .5577 .49221 .55463 .48667 .54906 Mtetra
.48667 .54906 .49221 .55463 .50216 .55156 .49664 .54596 Mtetra
.49664 .54596 .50216 .55156 .51214 .54848 .50665 .54286 Mtetra
.50665 .54286 .51214 .54848 .52217 .54539 .5167 .53975 Mtetra
.657 .753 .92 r
.5167 .53975 .52217 .54539 .53222 .54229 .52678 .53663 Mtetra
.52678 .53663 .53222 .54229 .54232 .53918 .5369 .5335 Mtetra
.657 .752 .92 r
.5369 .5335 .54232 .53918 .55245 .53606 .54706 .53035 Mtetra
.54706 .53035 .55245 .53606 .56262 .53293 .55725 .5272 Mtetra
.55725 .5272 .56262 .53293 .57283 .52978 .56748 .52404 Mtetra
.56748 .52404 .57283 .52978 .58307 .52663 .57775 .52087 Mtetra
.57775 .52087 .58307 .52663 .59335 .52347 .58806 .51768 Mtetra
.58806 .51768 .59335 .52347 .60367 .5203 .5984 .51449 Mtetra
.5984 .51449 .60367 .5203 .61403 .51712 .60879 .51128 Mtetra
.60879 .51128 .61403 .51712 .62443 .51392 .61921 .50806 Mtetra
.61921 .50806 .62443 .51392 .63486 .51071 .62967 .50484 Mtetra
.62967 .50484 .63486 .51071 .64534 .5075 .64017 .5016 Mtetra
.64017 .5016 .64534 .5075 .65585 .50427 .65071 .49835 Mtetra
.65071 .49835 .65585 .50427 .6664 .50103 .66129 .49508 Mtetra
.66129 .49508 .6664 .50103 .67699 .49778 .67191 .49181 Mtetra
.67191 .49181 .67699 .49778 .68762 .49451 .68257 .48852 Mtetra
.68257 .48852 .68762 .49451 .69829 .49124 .69326 .48522 Mtetra
.69326 .48522 .69829 .49124 .709 .48795 .704 .48191 Mtetra
.704 .48191 .709 .48795 .71975 .48465 .71478 .47859 Mtetra
.71478 .47859 .71975 .48465 .73055 .48134 .7256 .47526 Mtetra
.7256 .47526 .73055 .48134 .74138 .47802 .73646 .47191 Mtetra
.73646 .47191 .74138 .47802 .75225 .47468 .74737 .46855 Mtetra
.74737 .46855 .75225 .47468 .76317 .47133 .75831 .46518 Mtetra
.75831 .46518 .76317 .47133 .77412 .46797 .7693 .4618 Mtetra
.7693 .4618 .77412 .46797 .78512 .4646 .78033 .4584 Mtetra
.78033 .4584 .78512 .4646 .79616 .46122 .7914 .45499 Mtetra
.7914 .45499 .79616 .46122 .80725 .45782 .80251 .45157 Mtetra
.80251 .45157 .80725 .45782 .81837 .45441 .81367 .44813 Mtetra
.81367 .44813 .81837 .45441 .82954 .45099 .82486 .44469 Mtetra
.82486 .44469 .82954 .45099 .84075 .44755 .83611 .44123 Mtetra
.83611 .44123 .84075 .44755 .85201 .4441 .84739 .43775 Mtetra
.84739 .43775 .85201 .4441 .8633 .44064 .85872 .43426 Mtetra
.85872 .43426 .8633 .44064 .87465 .43716 .8701 .43076 Mtetra
.8701 .43076 .87465 .43716 .88603 .43367 .88151 .42725 Mtetra
.88151 .42725 .88603 .43367 .89746 .43017 .89298 .42372 Mtetra
.89298 .42372 .89746 .43017 .90894 .42666 .90448 .42018 Mtetra
.63 .732 .921 r
.28856 .6026 .29454 .60819 .3038 .60581 .29782 .60034 Mtetra
.639 .74 .921 r
.29782 .60034 .3038 .60581 .31309 .60333 .30714 .59787 Mtetra
.639 .74 .922 r
.30714 .59787 .31309 .60333 .32242 .60097 .31648 .59539 Mtetra
.625 .733 .925 r
.31648 .59539 .32242 .60097 .33173 .59944 .32585 .59322 Mtetra
.345 .59 .936 r
.32585 .59322 .33173 .59944 .34168 .58665 .33502 .59526 Mtetra
0 0 0 r
.33502 .59526 .34168 .58665 .35079 .59018 .34496 .58382 Mtetra
.596 .697 .914 r
.34496 .58382 .35079 .59018 .36024 .58794 .35438 .58233 Mtetra
.64 .738 .92 r
.35438 .58233 .36024 .58794 .36974 .58527 .3639 .57978 Mtetra
.649 .746 .92 r
.3639 .57978 .36974 .58527 .37929 .58245 .37347 .577 Mtetra
.653 .749 .92 r
.37347 .577 .37929 .58245 .38888 .57954 .38307 .57411 Mtetra
.656 .751 .92 r
.38307 .57411 .38888 .57954 .3985 .57658 .39272 .57115 Mtetra
.658 .753 .92 r
.39272 .57115 .3985 .57658 .40815 .57357 .40239 .56813 Mtetra
.659 .753 .92 r
.40239 .56813 .40815 .57357 .41785 .57054 .41211 .56509 Mtetra
.659 .754 .92 r
.41211 .56509 .41785 .57054 .42757 .56749 .42186 .56202 Mtetra
.42186 .56202 .42757 .56749 .43733 .56443 .43164 .55894 Mtetra
.43164 .55894 .43733 .56443 .44713 .56137 .44146 .55585 Mtetra
.659 .753 .92 r
.44146 .55585 .44713 .56137 .45696 .5583 .45131 .55276 Mtetra
.658 .753 .92 r
.45131 .55276 .45696 .5583 .46683 .55522 .4612 .54966 Mtetra
.4612 .54966 .46683 .55522 .47673 .55215 .47113 .54656 Mtetra
.47113 .54656 .47673 .55215 .48667 .54906 .48109 .54345 Mtetra
.48109 .54345 .48667 .54906 .49664 .54596 .49109 .54033 Mtetra
.49109 .54033 .49664 .54596 .50665 .54286 .50112 .53721 Mtetra
.50112 .53721 .50665 .54286 .5167 .53975 .51119 .53407 Mtetra
.657 .753 .92 r
.51119 .53407 .5167 .53975 .52678 .53663 .5213 .53093 Mtetra
.5213 .53093 .52678 .53663 .5369 .5335 .53144 .52778 Mtetra
.53144 .52778 .5369 .5335 .54706 .53035 .54162 .52461 Mtetra
.657 .752 .92 r
.54162 .52461 .54706 .53035 .55725 .5272 .55184 .52144 Mtetra
.55184 .52144 .55725 .5272 .56748 .52404 .5621 .51825 Mtetra
.5621 .51825 .56748 .52404 .57775 .52087 .57239 .51506 Mtetra
.57239 .51506 .57775 .52087 .58806 .51768 .58273 .51185 Mtetra
.58273 .51185 .58806 .51768 .5984 .51449 .5931 .50864 Mtetra
.5931 .50864 .5984 .51449 .60879 .51128 .60351 .50541 Mtetra
.60351 .50541 .60879 .51128 .61921 .50806 .61396 .50217 Mtetra
.61396 .50217 .61921 .50806 .62967 .50484 .62444 .49892 Mtetra
.62444 .49892 .62967 .50484 .64017 .5016 .63497 .49565 Mtetra
.63497 .49565 .64017 .5016 .65071 .49835 .64554 .49238 Mtetra
.64554 .49238 .65071 .49835 .66129 .49508 .65614 .4891 Mtetra
.65614 .4891 .66129 .49508 .67191 .49181 .66679 .4858 Mtetra
.66679 .4858 .67191 .49181 .68257 .48852 .67747 .48249 Mtetra
.67747 .48249 .68257 .48852 .69326 .48522 .6882 .47917 Mtetra
.6882 .47917 .69326 .48522 .704 .48191 .69897 .47583 Mtetra
.69897 .47583 .704 .48191 .71478 .47859 .70978 .47249 Mtetra
.70978 .47249 .71478 .47859 .7256 .47526 .72062 .46913 Mtetra
.72062 .46913 .7256 .47526 .73646 .47191 .73152 .46576 Mtetra
.73152 .46576 .73646 .47191 .74737 .46855 .74245 .46238 Mtetra
.74245 .46238 .74737 .46855 .75831 .46518 .75342 .45898 Mtetra
.75342 .45898 .75831 .46518 .7693 .4618 .76444 .45557 Mtetra
.76444 .45557 .7693 .4618 .78033 .4584 .7755 .45215 Mtetra
.7755 .45215 .78033 .4584 .7914 .45499 .7866 .44872 Mtetra
.7866 .44872 .7914 .45499 .80251 .45157 .79774 .44527 Mtetra
.79774 .44527 .80251 .45157 .81367 .44813 .80893 .44181 Mtetra
.80893 .44181 .81367 .44813 .82486 .44469 .82016 .43834 Mtetra
.82016 .43834 .82486 .44469 .83611 .44123 .83143 .43486 Mtetra
.83143 .43486 .83611 .44123 .84739 .43775 .84275 .43136 Mtetra
.84275 .43136 .84739 .43775 .85872 .43426 .85411 .42784 Mtetra
.85411 .42784 .85872 .43426 .8701 .43076 .86551 .42432 Mtetra
.86551 .42432 .8701 .43076 .88151 .42725 .87696 .42078 Mtetra
.87696 .42078 .88151 .42725 .89298 .42372 .88846 .41723 Mtetra
.88846 .41723 .89298 .42372 .90448 .42018 .9 .41366 Mtetra
.614 .718 .919 r
.28256 .59671 .28856 .6026 .29782 .60034 .29181 .5948 Mtetra
.636 .737 .921 r
.29181 .5948 .29782 .60034 .30714 .59787 .30114 .59237 Mtetra
.64 .74 .922 r
.30114 .59237 .30714 .59787 .31648 .59539 .31051 .58985 Mtetra
.635 .738 .923 r
.31051 .58985 .31648 .59539 .32585 .59322 .3199 .58743 Mtetra
.594 .717 .93 r
.3199 .58743 .32585 .59322 .33502 .59526 .32929 .58587 Mtetra
.802 .688 .739 r
.32929 .58587 .33502 .59526 .34496 .58382 .33933 .57299 Mtetra
.395 .478 .828 r
.33933 .57299 .34496 .58382 .35438 .58233 .3485 .57649 Mtetra
.628 .728 .919 r
.3485 .57649 .35438 .58233 .3639 .57978 .35803 .57421 Mtetra
.646 .743 .92 r
.35803 .57421 .3639 .57978 .37347 .577 .36761 .57149 Mtetra
.652 .748 .92 r
.36761 .57149 .37347 .577 .38307 .57411 .37723 .56862 Mtetra
.655 .75 .92 r
.37723 .56862 .38307 .57411 .39272 .57115 .3869 .56567 Mtetra
.657 .752 .92 r
.3869 .56567 .39272 .57115 .40239 .56813 .3966 .56265 Mtetra
.658 .753 .92 r
.3966 .56265 .40239 .56813 .41211 .56509 .40633 .55959 Mtetra
.659 .754 .92 r
.40633 .55959 .41211 .56509 .42186 .56202 .4161 .55651 Mtetra
.4161 .55651 .42186 .56202 .43164 .55894 .42591 .55341 Mtetra
.42591 .55341 .43164 .55894 .44146 .55585 .43575 .5503 Mtetra
.43575 .5503 .44146 .55585 .45131 .55276 .44563 .54718 Mtetra
.658 .753 .92 r
.44563 .54718 .45131 .55276 .4612 .54966 .45554 .54406 Mtetra
.45554 .54406 .4612 .54966 .47113 .54656 .46549 .54094 Mtetra
.46549 .54094 .47113 .54656 .48109 .54345 .47547 .5378 Mtetra
.47547 .5378 .48109 .54345 .49109 .54033 .4855 .53466 Mtetra
.4855 .53466 .49109 .54033 .50112 .53721 .49555 .53152 Mtetra
.49555 .53152 .50112 .53721 .51119 .53407 .50565 .52836 Mtetra
.50565 .52836 .51119 .53407 .5213 .53093 .51578 .52519 Mtetra
.657 .753 .92 r
.51578 .52519 .5213 .53093 .53144 .52778 .52595 .52202 Mtetra
.52595 .52202 .53144 .52778 .54162 .52461 .53615 .51883 Mtetra
.657 .752 .92 r
.53615 .51883 .54162 .52461 .55184 .52144 .5464 .51564 Mtetra
.5464 .51564 .55184 .52144 .5621 .51825 .55668 .51243 Mtetra
.55668 .51243 .5621 .51825 .57239 .51506 .567 .50921 Mtetra
.567 .50921 .57239 .51506 .58273 .51185 .57736 .50598 Mtetra
.57736 .50598 .58273 .51185 .5931 .50864 .58776 .50274 Mtetra
.58776 .50274 .5931 .50864 .60351 .50541 .59819 .49949 Mtetra
.59819 .49949 .60351 .50541 .61396 .50217 .60867 .49623 Mtetra
.60867 .49623 .61396 .50217 .62444 .49892 .61918 .49296 Mtetra
.61918 .49296 .62444 .49892 .63497 .49565 .62973 .48967 Mtetra
.62973 .48967 .63497 .49565 .64554 .49238 .64033 .48637 Mtetra
.64033 .48637 .64554 .49238 .65614 .4891 .65096 .48307 Mtetra
.65096 .48307 .65614 .4891 .66679 .4858 .66163 .47975 Mtetra
.66163 .47975 .66679 .4858 .67747 .48249 .67235 .47641 Mtetra
.67235 .47641 .67747 .48249 .6882 .47917 .6831 .47307 Mtetra
.6831 .47307 .6882 .47917 .69897 .47583 .6939 .46971 Mtetra
.6939 .46971 .69897 .47583 .70978 .47249 .70473 .46634 Mtetra
.70473 .46634 .70978 .47249 .72062 .46913 .71561 .46296 Mtetra
.71561 .46296 .72062 .46913 .73152 .46576 .72653 .45957 Mtetra
.72653 .45957 .73152 .46576 .74245 .46238 .73749 .45616 Mtetra
.73749 .45616 .74245 .46238 .75342 .45898 .7485 .45274 Mtetra
.7485 .45274 .75342 .45898 .76444 .45557 .75954 .44931 Mtetra
.75954 .44931 .76444 .45557 .7755 .45215 .77063 .44586 Mtetra
.77063 .44586 .7755 .45215 .7866 .44872 .78176 .4424 Mtetra
.78176 .4424 .7866 .44872 .79774 .44527 .79293 .43893 Mtetra
.79293 .43893 .79774 .44527 .80893 .44181 .80415 .43545 Mtetra
.80415 .43545 .80893 .44181 .82016 .43834 .81541 .43195 Mtetra
.81541 .43195 .82016 .43834 .83143 .43486 .82672 .42844 Mtetra
.82672 .42844 .83143 .43486 .84275 .43136 .83807 .42492 Mtetra
.83807 .42492 .84275 .43136 .85411 .42784 .84946 .42138 Mtetra
.84946 .42138 .85411 .42784 .86551 .42432 .8609 .41783 Mtetra
.8609 .41783 .86551 .42432 .87696 .42078 .87238 .41426 Mtetra
.87238 .41426 .87696 .42078 .88846 .41723 .88391 .41068 Mtetra
.88391 .41068 .88846 .41723 .9 .41366 .89548 .40709 Mtetra
.56 .665 .908 r
.27659 .58982 .28256 .59671 .29181 .5948 .28577 .58911 Mtetra
.63 .732 .921 r
.28577 .58911 .29181 .5948 .30114 .59237 .29511 .58682 Mtetra
.639 .74 .921 r
.29511 .58682 .30114 .59237 .31051 .58985 .30449 .58429 Mtetra
.639 .74 .922 r
.30449 .58429 .31051 .58985 .3199 .58743 .31391 .58177 Mtetra
.625 .733 .925 r
.31391 .58177 .3199 .58743 .32929 .58587 .32335 .57955 Mtetra
.346 .591 .936 r
.32335 .57955 .32929 .58587 .33933 .57299 .33259 .58156 Mtetra
0 0 0 r
.33259 .58156 .33933 .57299 .3485 .57649 .34261 .57004 Mtetra
.595 .697 .914 r
.34261 .57004 .3485 .57649 .35803 .57421 .35212 .5685 Mtetra
.64 .738 .92 r
.35212 .5685 .35803 .57421 .36761 .57149 .36171 .56591 Mtetra
.649 .746 .92 r
.36171 .56591 .36761 .57149 .37723 .56862 .37135 .56308 Mtetra
.653 .749 .92 r
.37135 .56308 .37723 .56862 .3869 .56567 .38104 .56014 Mtetra
.656 .751 .92 r
.38104 .56014 .3869 .56567 .3966 .56265 .39076 .55712 Mtetra
.658 .753 .92 r
.39076 .55712 .3966 .56265 .40633 .55959 .40052 .55406 Mtetra
.659 .753 .92 r
.40052 .55406 .40633 .55959 .4161 .55651 .41031 .55096 Mtetra
.659 .754 .92 r
.41031 .55096 .4161 .55651 .42591 .55341 .42014 .54784 Mtetra
.42014 .54784 .42591 .55341 .43575 .5503 .43 .54471 Mtetra
.43 .54471 .43575 .5503 .44563 .54718 .4399 .54157 Mtetra
.659 .753 .92 r
.4399 .54157 .44563 .54718 .45554 .54406 .44984 .53842 Mtetra
.658 .753 .92 r
.44984 .53842 .45554 .54406 .46549 .54094 .45981 .53527 Mtetra
.45981 .53527 .46549 .54094 .47547 .5378 .46982 .53212 Mtetra
.46982 .53212 .47547 .5378 .4855 .53466 .47987 .52896 Mtetra
.47987 .52896 .4855 .53466 .49555 .53152 .48995 .52579 Mtetra
.48995 .52579 .49555 .53152 .50565 .52836 .50007 .52261 Mtetra
.50007 .52261 .50565 .52836 .51578 .52519 .51022 .51942 Mtetra
.657 .753 .92 r
.51022 .51942 .51578 .52519 .52595 .52202 .52042 .51622 Mtetra
.52042 .51622 .52595 .52202 .53615 .51883 .53065 .51301 Mtetra
.53065 .51301 .53615 .51883 .5464 .51564 .54092 .50979 Mtetra
.657 .752 .92 r
.54092 .50979 .5464 .51564 .55668 .51243 .55122 .50656 Mtetra
.55122 .50656 .55668 .51243 .567 .50921 .56157 .50332 Mtetra
.56157 .50332 .567 .50921 .57736 .50598 .57195 .50007 Mtetra
.57195 .50007 .57736 .50598 .58776 .50274 .58238 .49681 Mtetra
.58238 .49681 .58776 .50274 .59819 .49949 .59284 .49354 Mtetra
.59284 .49354 .59819 .49949 .60867 .49623 .60334 .49025 Mtetra
.60334 .49025 .60867 .49623 .61918 .49296 .61388 .48696 Mtetra
.61388 .48696 .61918 .49296 .62973 .48967 .62446 .48365 Mtetra
.62446 .48365 .62973 .48967 .64033 .48637 .63508 .48033 Mtetra
.63508 .48033 .64033 .48637 .65096 .48307 .64574 .47699 Mtetra
.64574 .47699 .65096 .48307 .66163 .47975 .65644 .47365 Mtetra
.65644 .47365 .66163 .47975 .67235 .47641 .66718 .47029 Mtetra
.66718 .47029 .67235 .47641 .6831 .47307 .67797 .46693 Mtetra
.67797 .46693 .6831 .47307 .6939 .46971 .68879 .46355 Mtetra
.68879 .46355 .6939 .46971 .70473 .46634 .69966 .46015 Mtetra
.69966 .46015 .70473 .46634 .71561 .46296 .71056 .45675 Mtetra
.71056 .45675 .71561 .46296 .72653 .45957 .72151 .45333 Mtetra
.72151 .45333 .72653 .45957 .73749 .45616 .7325 .4499 Mtetra
.7325 .4499 .73749 .45616 .7485 .45274 .74353 .44645 Mtetra
.74353 .44645 .7485 .45274 .75954 .44931 .75461 .443 Mtetra
.75461 .443 .75954 .44931 .77063 .44586 .76573 .43953 Mtetra
.76573 .43953 .77063 .44586 .78176 .4424 .77689 .43604 Mtetra
.77689 .43604 .78176 .4424 .79293 .43893 .7881 .43255 Mtetra
.7881 .43255 .79293 .43893 .80415 .43545 .79934 .42904 Mtetra
.79934 .42904 .80415 .43545 .81541 .43195 .81064 .42551 Mtetra
.81064 .42551 .81541 .43195 .82672 .42844 .82197 .42198 Mtetra
.82197 .42198 .82672 .42844 .83807 .42492 .83335 .41843 Mtetra
.83335 .41843 .83807 .42492 .84946 .42138 .84478 .41486 Mtetra
.84478 .41486 .84946 .42138 .8609 .41783 .85625 .41129 Mtetra
.85625 .41129 .8609 .41783 .87238 .41426 .86777 .4077 Mtetra
.86777 .4077 .87238 .41426 .88391 .41068 .87933 .40409 Mtetra
.87933 .40409 .88391 .41068 .89548 .40709 .89093 .40047 Mtetra
0 0 .468 r
.27285 .55257 .27659 .58982 .28577 .58911 .27971 .58313 Mtetra
.614 .718 .919 r
.27971 .58313 .28577 .58911 .29511 .58682 .28904 .58118 Mtetra
.636 .737 .921 r
.28904 .58118 .29511 .58682 .30449 .58429 .29844 .5787 Mtetra
.64 .74 .922 r
.29844 .5787 .30449 .58429 .31391 .58177 .30788 .57614 Mtetra
.635 .738 .923 r
.30788 .57614 .31391 .58177 .32335 .57955 .31735 .57367 Mtetra
.594 .717 .93 r
.31735 .57367 .32335 .57955 .33259 .58156 .32681 .57207 Mtetra
.803 .689 .739 r
.32681 .57207 .33259 .58156 .34261 .57004 .33694 .55909 Mtetra
.394 .478 .828 r
.33694 .55909 .34261 .57004 .35212 .5685 .34618 .56257 Mtetra
.628 .728 .919 r
.34618 .56257 .35212 .5685 .36171 .56591 .35578 .56024 Mtetra
.646 .743 .92 r
.35578 .56024 .36171 .56591 .37135 .56308 .36544 .55747 Mtetra
.652 .748 .92 r
.36544 .55747 .37135 .56308 .38104 .56014 .37514 .55455 Mtetra
.655 .75 .92 r
.37514 .55455 .38104 .56014 .39076 .55712 .38488 .55155 Mtetra
.657 .752 .92 r
.38488 .55155 .39076 .55712 .40052 .55406 .39466 .54848 Mtetra
.658 .753 .92 r
.39466 .54848 .40052 .55406 .41031 .55096 .40448 .54537 Mtetra
.659 .754 .92 r
.40448 .54537 .41031 .55096 .42014 .54784 .41433 .54224 Mtetra
.41433 .54224 .42014 .54784 .43 .54471 .42422 .53908 Mtetra
.42422 .53908 .43 .54471 .4399 .54157 .43414 .53592 Mtetra
.43414 .53592 .4399 .54157 .44984 .53842 .4441 .53275 Mtetra
.658 .753 .92 r
.4441 .53275 .44984 .53842 .45981 .53527 .4541 .52958 Mtetra
.4541 .52958 .45981 .53527 .46982 .53212 .46413 .5264 Mtetra
.46413 .5264 .46982 .53212 .47987 .52896 .4742 .52321 Mtetra
.4742 .52321 .47987 .52896 .48995 .52579 .4843 .52002 Mtetra
.4843 .52002 .48995 .52579 .50007 .52261 .49445 .51682 Mtetra
.49445 .51682 .50007 .52261 .51022 .51942 .50463 .51361 Mtetra
.50463 .51361 .51022 .51942 .52042 .51622 .51484 .51038 Mtetra
.657 .753 .92 r
.51484 .51038 .52042 .51622 .53065 .51301 .5251 .50715 Mtetra
.5251 .50715 .53065 .51301 .54092 .50979 .5354 .50391 Mtetra
.657 .752 .92 r
.5354 .50391 .54092 .50979 .55122 .50656 .54573 .50066 Mtetra
.54573 .50066 .55122 .50656 .56157 .50332 .5561 .4974 Mtetra
.5561 .4974 .56157 .50332 .57195 .50007 .56651 .49412 Mtetra
.56651 .49412 .57195 .50007 .58238 .49681 .57696 .49084 Mtetra
.57696 .49084 .58238 .49681 .59284 .49354 .58745 .48754 Mtetra
.58745 .48754 .59284 .49354 .60334 .49025 .59797 .48423 Mtetra
.59797 .48423 .60334 .49025 .61388 .48696 .60854 .48091 Mtetra
.60854 .48091 .61388 .48696 .62446 .48365 .61915 .47758 Mtetra
.61915 .47758 .62446 .48365 .63508 .48033 .6298 .47424 Mtetra
.6298 .47424 .63508 .48033 .64574 .47699 .64049 .47088 Mtetra
.64049 .47088 .64574 .47699 .65644 .47365 .65121 .46751 Mtetra
.65121 .46751 .65644 .47365 .66718 .47029 .66198 .46413 Mtetra
.66198 .46413 .66718 .47029 .67797 .46693 .6728 .46074 Mtetra
.6728 .46074 .67797 .46693 .68879 .46355 .68365 .45734 Mtetra
.68365 .45734 .68879 .46355 .69966 .46015 .69454 .45392 Mtetra
.69454 .45392 .69966 .46015 .71056 .45675 .70548 .45049 Mtetra
.70548 .45049 .71056 .45675 .72151 .45333 .71646 .44705 Mtetra
.71646 .44705 .72151 .45333 .7325 .4499 .72748 .44359 Mtetra
.72748 .44359 .7325 .4499 .74353 .44645 .73854 .44012 Mtetra
.73854 .44012 .74353 .44645 .75461 .443 .74964 .43664 Mtetra
.74964 .43664 .75461 .443 .76573 .43953 .76079 .43314 Mtetra
.76079 .43314 .76573 .43953 .77689 .43604 .77199 .42964 Mtetra
.77199 .42964 .77689 .43604 .7881 .43255 .78322 .42611 Mtetra
.78322 .42611 .7881 .43255 .79934 .42904 .7945 .42258 Mtetra
.7945 .42258 .79934 .42904 .81064 .42551 .80583 .41903 Mtetra
.80583 .41903 .81064 .42551 .82197 .42198 .81719 .41547 Mtetra
.81719 .41547 .82197 .42198 .83335 .41843 .82861 .41189 Mtetra
.82861 .41189 .83335 .41843 .84478 .41486 .84006 .4083 Mtetra
.84006 .4083 .84478 .41486 .85625 .41129 .85157 .4047 Mtetra
.85157 .4047 .85625 .41129 .86777 .4077 .86312 .40108 Mtetra
.86312 .40108 .86777 .4077 .87933 .40409 .87471 .39745 Mtetra
.87471 .39745 .87933 .40409 .89093 .40047 .88635 .39381 Mtetra
.393 .122 .38 r
.26378 .58589 .27285 .55257 .27971 .58313 .27368 .57615 Mtetra
.56 .665 .908 r
.27368 .57615 .27971 .58313 .28904 .58118 .28294 .5754 Mtetra
.63 .732 .921 r
.28294 .5754 .28904 .58118 .29844 .5787 .29234 .57306 Mtetra
.639 .74 .921 r
.29234 .57306 .29844 .5787 .30788 .57614 .3018 .57049 Mtetra
.639 .74 .922 r
.3018 .57049 .30788 .57614 .31735 .57367 .3113 .56792 Mtetra
.625 .733 .925 r
.3113 .56792 .31735 .57367 .32681 .57207 .32081 .56565 Mtetra
.348 .591 .936 r
.32081 .56565 .32681 .57207 .33694 .55909 .33012 .56764 Mtetra
0 0 0 r
.33012 .56764 .33694 .55909 .34618 .56257 .34023 .55602 Mtetra
.595 .697 .914 r
.34023 .55602 .34618 .56257 .35578 .56024 .34981 .55444 Mtetra
.64 .738 .92 r
.34981 .55444 .35578 .56024 .36544 .55747 .35948 .5518 Mtetra
.649 .746 .92 r
.35948 .5518 .36544 .55747 .37514 .55455 .3692 .54892 Mtetra
.653 .749 .92 r
.3692 .54892 .37514 .55455 .38488 .55155 .37897 .54592 Mtetra
.656 .751 .92 r
.37897 .54592 .38488 .55155 .39466 .54848 .38877 .54286 Mtetra
.658 .753 .92 r
.38877 .54286 .39466 .54848 .40448 .54537 .39861 .53974 Mtetra
.659 .753 .92 r
.39861 .53974 .40448 .54537 .41433 .54224 .40848 .53659 Mtetra
.659 .754 .92 r
.40848 .53659 .41433 .54224 .42422 .53908 .41839 .53342 Mtetra
.41839 .53342 .42422 .53908 .43414 .53592 .42834 .53023 Mtetra
.42834 .53023 .43414 .53592 .4441 .53275 .43832 .52704 Mtetra
.659 .753 .92 r
.43832 .52704 .4441 .53275 .4541 .52958 .44834 .52384 Mtetra
.658 .753 .92 r
.44834 .52384 .4541 .52958 .46413 .5264 .4584 .52064 Mtetra
.4584 .52064 .46413 .5264 .4742 .52321 .46849 .51743 Mtetra
.46849 .51743 .4742 .52321 .4843 .52002 .47862 .51421 Mtetra
.47862 .51421 .4843 .52002 .49445 .51682 .48879 .51099 Mtetra
.48879 .51099 .49445 .51682 .50463 .51361 .49899 .50775 Mtetra
.49899 .50775 .50463 .51361 .51484 .51038 .50924 .50451 Mtetra
.657 .753 .92 r
.50924 .50451 .51484 .51038 .5251 .50715 .51952 .50125 Mtetra
.51952 .50125 .5251 .50715 .5354 .50391 .52984 .49799 Mtetra
.52984 .49799 .5354 .50391 .54573 .50066 .54019 .49471 Mtetra
.657 .752 .92 r
.54019 .49471 .54573 .50066 .5561 .4974 .55059 .49143 Mtetra
.55059 .49143 .5561 .4974 .56651 .49412 .56103 .48813 Mtetra
.56103 .48813 .56651 .49412 .57696 .49084 .5715 .48482 Mtetra
.5715 .48482 .57696 .49084 .58745 .48754 .58202 .4815 Mtetra
.58202 .4815 .58745 .48754 .59797 .48423 .59257 .47817 Mtetra
.59257 .47817 .59797 .48423 .60854 .48091 .60317 .47483 Mtetra
.60317 .47483 .60854 .48091 .61915 .47758 .6138 .47147 Mtetra
.6138 .47147 .61915 .47758 .6298 .47424 .62448 .4681 Mtetra
.62448 .4681 .6298 .47424 .64049 .47088 .63519 .46472 Mtetra
.63519 .46472 .64049 .47088 .65121 .46751 .64595 .46133 Mtetra
.64595 .46133 .65121 .46751 .66198 .46413 .65675 .45793 Mtetra
.65675 .45793 .66198 .46413 .6728 .46074 .66759 .45451 Mtetra
.66759 .45451 .6728 .46074 .68365 .45734 .67847 .45108 Mtetra
.67847 .45108 .68365 .45734 .69454 .45392 .68939 .44764 Mtetra
.68939 .44764 .69454 .45392 .70548 .45049 .70036 .44419 Mtetra
.70036 .44419 .70548 .45049 .71646 .44705 .71136 .44072 Mtetra
.71136 .44072 .71646 .44705 .72748 .44359 .72241 .43724 Mtetra
.72241 .43724 .72748 .44359 .73854 .44012 .73351 .43374 Mtetra
.73351 .43374 .73854 .44012 .74964 .43664 .74464 .43024 Mtetra
.74464 .43024 .74964 .43664 .76079 .43314 .75582 .42672 Mtetra
.75582 .42672 .76079 .43314 .77199 .42964 .76704 .42318 Mtetra
.76704 .42318 .77199 .42964 .78322 .42611 .77831 .41964 Mtetra
.77831 .41964 .78322 .42611 .7945 .42258 .78962 .41607 Mtetra
.78962 .41607 .7945 .42258 .80583 .41903 .80098 .4125 Mtetra
.80098 .4125 .80583 .41903 .81719 .41547 .81238 .40891 Mtetra
.81238 .40891 .81719 .41547 .82861 .41189 .82382 .40531 Mtetra
.82382 .40531 .82861 .41189 .84006 .4083 .83531 .40169 Mtetra
.83531 .40169 .84006 .4083 .85157 .4047 .84685 .39807 Mtetra
.84685 .39807 .85157 .4047 .86312 .40108 .85843 .39442 Mtetra
.85843 .39442 .86312 .40108 .87471 .39745 .87006 .39076 Mtetra
.87006 .39076 .87471 .39745 .88635 .39381 .88173 .38709 Mtetra
.9 .711 .638 r
.25773 .57835 .26378 .58589 .27368 .57615 .26993 .53867 Mtetra
0 0 .465 r
.26993 .53867 .27368 .57615 .28294 .5754 .27681 .56933 Mtetra
.614 .718 .919 r
.27681 .56933 .28294 .5754 .29234 .57306 .28621 .56733 Mtetra
.636 .737 .921 r
.28621 .56733 .29234 .57306 .3018 .57049 .29569 .56481 Mtetra
.64 .74 .922 r
.29569 .56481 .3018 .57049 .3113 .56792 .30521 .56219 Mtetra
.635 .738 .923 r
.30521 .56219 .3113 .56792 .32081 .56565 .31475 .55968 Mtetra
.594 .717 .93 r
.31475 .55968 .32081 .56565 .33012 .56764 .32428 .55803 Mtetra
.803 .689 .739 r
.32428 .55803 .33012 .56764 .34023 .55602 .3345 .54496 Mtetra
.392 .477 .828 r
.3345 .54496 .34023 .55602 .34981 .55444 .34381 .54842 Mtetra
.628 .728 .919 r
.34381 .54842 .34981 .55444 .35948 .5518 .35349 .54603 Mtetra
.646 .743 .92 r
.35349 .54603 .35948 .5518 .3692 .54892 .36323 .54322 Mtetra
.652 .748 .92 r
.36323 .54322 .3692 .54892 .37897 .54592 .37301 .54025 Mtetra
.655 .75 .92 r
.37301 .54025 .37897 .54592 .38877 .54286 .38283 .53719 Mtetra
.657 .752 .92 r
.38283 .53719 .38877 .54286 .39861 .53974 .39269 .53407 Mtetra
.658 .753 .92 r
.39269 .53407 .39861 .53974 .40848 .53659 .40259 .53091 Mtetra
.659 .754 .92 r
.40259 .53091 .40848 .53659 .41839 .53342 .41252 .52772 Mtetra
.41252 .52772 .41839 .53342 .42834 .53023 .4225 .52451 Mtetra
.4225 .52451 .42834 .53023 .43832 .52704 .4325 .52129 Mtetra
.4325 .52129 .43832 .52704 .44834 .52384 .44255 .51807 Mtetra
.658 .753 .92 r
.44255 .51807 .44834 .52384 .4584 .52064 .45263 .51484 Mtetra
.45263 .51484 .4584 .52064 .46849 .51743 .46274 .51161 Mtetra
.46274 .51161 .46849 .51743 .47862 .51421 .4729 .50837 Mtetra
.4729 .50837 .47862 .51421 .48879 .51099 .48309 .50512 Mtetra
.48309 .50512 .48879 .51099 .49899 .50775 .49332 .50186 Mtetra
.49332 .50186 .49899 .50775 .50924 .50451 .50359 .49859 Mtetra
.50359 .49859 .50924 .50451 .51952 .50125 .51389 .49531 Mtetra
.657 .753 .92 r
.51389 .49531 .51952 .50125 .52984 .49799 .52424 .49203 Mtetra
.52424 .49203 .52984 .49799 .54019 .49471 .53462 .48873 Mtetra
.657 .752 .92 r
.53462 .48873 .54019 .49471 .55059 .49143 .54505 .48542 Mtetra
.54505 .48542 .55059 .49143 .56103 .48813 .55551 .4821 Mtetra
.55551 .4821 .56103 .48813 .5715 .48482 .56601 .47876 Mtetra
.56601 .47876 .5715 .48482 .58202 .4815 .57655 .47542 Mtetra
.57655 .47542 .58202 .4815 .59257 .47817 .58713 .47207 Mtetra
.58713 .47207 .59257 .47817 .60317 .47483 .59775 .4687 Mtetra
.59775 .4687 .60317 .47483 .6138 .47147 .60842 .46532 Mtetra
.60842 .46532 .6138 .47147 .62448 .4681 .61912 .46193 Mtetra
.61912 .46193 .62448 .4681 .63519 .46472 .62986 .45852 Mtetra
.62986 .45852 .63519 .46472 .64595 .46133 .64065 .45511 Mtetra
.64065 .45511 .64595 .46133 .65675 .45793 .65147 .45168 Mtetra
.65147 .45168 .65675 .45793 .66759 .45451 .66234 .44824 Mtetra
.66234 .44824 .66759 .45451 .67847 .45108 .67325 .44478 Mtetra
.67325 .44478 .67847 .45108 .68939 .44764 .6842 .44132 Mtetra
.6842 .44132 .68939 .44764 .70036 .44419 .6952 .43784 Mtetra
.6952 .43784 .70036 .44419 .71136 .44072 .70623 .43434 Mtetra
.70623 .43434 .71136 .44072 .72241 .43724 .71731 .43084 Mtetra
.71731 .43084 .72241 .43724 .73351 .43374 .72844 .42732 Mtetra
.72844 .42732 .73351 .43374 .74464 .43024 .7396 .42379 Mtetra
.7396 .42379 .74464 .43024 .75582 .42672 .75081 .42024 Mtetra
.75081 .42024 .75582 .42672 .76704 .42318 .76207 .41668 Mtetra
.76207 .41668 .76704 .42318 .77831 .41964 .77337 .41311 Mtetra
.77337 .41311 .77831 .41964 .78962 .41607 .78471 .40952 Mtetra
.78471 .40952 .78962 .41607 .80098 .4125 .7961 .40592 Mtetra
.7961 .40592 .80098 .4125 .81238 .40891 .80753 .40231 Mtetra
.80753 .40231 .81238 .40891 .82382 .40531 .81901 .39868 Mtetra
.81901 .39868 .82382 .40531 .83531 .40169 .83053 .39504 Mtetra
.83053 .39504 .83531 .40169 .84685 .39807 .8421 .39138 Mtetra
.8421 .39138 .84685 .39807 .85843 .39442 .85371 .38771 Mtetra
.85371 .38771 .85843 .39442 .87006 .39076 .86537 .38403 Mtetra
.86537 .38403 .87006 .39076 .88173 .38709 .87708 .38033 Mtetra
.504 .674 .94 r
.25154 .57216 .25773 .57835 .26993 .53867 .26074 .57207 Mtetra
.387 .115 .374 r
.26074 .57207 .26993 .53867 .27681 .56933 .27073 .56224 Mtetra
.559 .665 .908 r
.27073 .56224 .27681 .56933 .28621 .56733 .28005 .56146 Mtetra
.63 .732 .921 r
.28005 .56146 .28621 .56733 .29569 .56481 .28953 .55907 Mtetra
.639 .74 .921 r
.28953 .55907 .29569 .56481 .30521 .56219 .29907 .55645 Mtetra
.639 .74 .922 r
.29907 .55645 .30521 .56219 .31475 .55968 .30864 .55383 Mtetra
.625 .733 .925 r
.30864 .55383 .31475 .55968 .32428 .55803 .31823 .55152 Mtetra
.349 .592 .936 r
.31823 .55152 .32428 .55803 .3345 .54496 .32761 .55347 Mtetra
0 0 0 r
.32761 .55347 .3345 .54496 .34381 .54842 .33781 .54177 Mtetra
.595 .697 .914 r
.33781 .54177 .34381 .54842 .35349 .54603 .34747 .54014 Mtetra
.64 .738 .92 r
.34747 .54014 .35349 .54603 .36323 .54322 .35722 .53745 Mtetra
.649 .746 .92 r
.35722 .53745 .36323 .54322 .37301 .54025 .36702 .53451 Mtetra
.653 .749 .92 r
.36702 .53451 .37301 .54025 .38283 .53719 .37686 .53147 Mtetra
.656 .751 .92 r
.37686 .53147 .38283 .53719 .39269 .53407 .38674 .52835 Mtetra
.658 .753 .92 r
.38674 .52835 .39269 .53407 .40259 .53091 .39666 .52518 Mtetra
.659 .753 .92 r
.39666 .52518 .40259 .53091 .41252 .52772 .40662 .52197 Mtetra
.659 .754 .92 r
.40662 .52197 .41252 .52772 .4225 .52451 .41661 .51875 Mtetra
.41661 .51875 .4225 .52451 .4325 .52129 .42664 .51551 Mtetra
.42664 .51551 .4325 .52129 .44255 .51807 .43671 .51226 Mtetra
.659 .753 .92 r
.43671 .51226 .44255 .51807 .45263 .51484 .44681 .509 Mtetra
.658 .753 .92 r
.44681 .509 .45263 .51484 .46274 .51161 .45696 .50574 Mtetra
.45696 .50574 .46274 .51161 .4729 .50837 .46713 .50248 Mtetra
.46713 .50248 .4729 .50837 .48309 .50512 .47735 .49921 Mtetra
.47735 .49921 .48309 .50512 .49332 .50186 .48761 .49592 Mtetra
.48761 .49592 .49332 .50186 .50359 .49859 .4979 .49263 Mtetra
.4979 .49263 .50359 .49859 .51389 .49531 .50823 .48933 Mtetra
.657 .753 .92 r
.50823 .48933 .51389 .49531 .52424 .49203 .5186 .48602 Mtetra
.5186 .48602 .52424 .49203 .53462 .48873 .52901 .4827 Mtetra
.52901 .4827 .53462 .48873 .54505 .48542 .53946 .47937 Mtetra
.657 .752 .92 r
.53946 .47937 .54505 .48542 .55551 .4821 .54995 .47602 Mtetra
.54995 .47602 .55551 .4821 .56601 .47876 .56048 .47266 Mtetra
.56048 .47266 .56601 .47876 .57655 .47542 .57105 .4693 Mtetra
.57105 .4693 .57655 .47542 .58713 .47207 .58165 .46592 Mtetra
.58165 .46592 .58713 .47207 .59775 .4687 .5923 .46253 Mtetra
.5923 .46253 .59775 .4687 .60842 .46532 .60299 .45912 Mtetra
.60299 .45912 .60842 .46532 .61912 .46193 .61372 .45571 Mtetra
.61372 .45571 .61912 .46193 .62986 .45852 .62449 .45228 Mtetra
.62449 .45228 .62986 .45852 .64065 .45511 .63531 .44884 Mtetra
.63531 .44884 .64065 .45511 .65147 .45168 .64616 .44538 Mtetra
.64616 .44538 .65147 .45168 .66234 .44824 .65706 .44192 Mtetra
.65706 .44192 .66234 .44824 .67325 .44478 .668 .43844 Mtetra
.668 .43844 .67325 .44478 .6842 .44132 .67898 .43495 Mtetra
.67898 .43495 .6842 .44132 .6952 .43784 .69 .43144 Mtetra
.69 .43144 .6952 .43784 .70623 .43434 .70107 .42793 Mtetra
.70107 .42793 .70623 .43434 .71731 .43084 .71218 .42439 Mtetra
.71218 .42439 .71731 .43084 .72844 .42732 .72333 .42085 Mtetra
.72333 .42085 .72844 .42732 .7396 .42379 .73453 .41729 Mtetra
.73453 .41729 .7396 .42379 .75081 .42024 .74577 .41372 Mtetra
.74577 .41372 .75081 .42024 .76207 .41668 .75706 .41014 Mtetra
.75706 .41014 .76207 .41668 .77337 .41311 .76839 .40654 Mtetra
.76839 .40654 .77337 .41311 .78471 .40952 .77976 .40292 Mtetra
.77976 .40292 .78471 .40952 .7961 .40592 .79118 .3993 Mtetra
.79118 .3993 .7961 .40592 .80753 .40231 .80264 .39566 Mtetra
.80264 .39566 .80753 .40231 .81901 .39868 .81415 .392 Mtetra
.81415 .392 .81901 .39868 .83053 .39504 .82571 .38833 Mtetra
.82571 .38833 .83053 .39504 .8421 .39138 .83731 .38465 Mtetra
.83731 .38465 .8421 .39138 .85371 .38771 .84896 .38095 Mtetra
.84896 .38095 .85371 .38771 .86537 .38403 .86066 .37724 Mtetra
.86066 .37724 .86537 .38403 .87708 .38033 .8724 .37351 Mtetra
.602 .72 .928 r
.24528 .56623 .25154 .57216 .26074 .57207 .25463 .56443 Mtetra
.901 .711 .637 r
.25463 .56443 .26074 .57207 .27073 .56224 .26696 .52454 Mtetra
0 0 .461 r
.26696 .52454 .27073 .56224 .28005 .56146 .27387 .55529 Mtetra
.614 .718 .919 r
.27387 .55529 .28005 .56146 .28953 .55907 .28334 .55324 Mtetra
.636 .737 .921 r
.28334 .55324 .28953 .55907 .29907 .55645 .29289 .55067 Mtetra
.64 .74 .922 r
.29289 .55067 .29907 .55645 .30864 .55383 .30249 .548 Mtetra
.635 .738 .923 r
.30249 .548 .30864 .55383 .31823 .55152 .31211 .54545 Mtetra
.594 .717 .93 r
.31211 .54545 .31823 .55152 .32761 .55347 .32172 .54375 Mtetra
.804 .69 .739 r
.32172 .54375 .32761 .55347 .33781 .54177 .33203 .53058 Mtetra
.391 .477 .828 r
.33203 .53058 .33781 .54177 .34747 .54014 .34141 .53402 Mtetra
.628 .728 .919 r
.34141 .53402 .34747 .54014 .35722 .53745 .35117 .53158 Mtetra
.646 .743 .92 r
.35117 .53158 .35722 .53745 .36702 .53451 .36098 .52871 Mtetra
.652 .748 .92 r
.36098 .52871 .36702 .53451 .37686 .53147 .37085 .52569 Mtetra
.655 .75 .92 r
.37085 .52569 .37686 .53147 .38674 .52835 .38075 .52258 Mtetra
.657 .752 .92 r
.38075 .52258 .38674 .52835 .39666 .52518 .39069 .51941 Mtetra
.658 .753 .92 r
.39069 .51941 .39666 .52518 .40662 .52197 .40067 .51619 Mtetra
.659 .754 .92 r
.40067 .51619 .40662 .52197 .41661 .51875 .41069 .51294 Mtetra
.41069 .51294 .41661 .51875 .42664 .51551 .42074 .50968 Mtetra
.42074 .50968 .42664 .51551 .43671 .51226 .43083 .50641 Mtetra
.43083 .50641 .43671 .51226 .44681 .509 .44096 .50313 Mtetra
.658 .753 .92 r
.44096 .50313 .44681 .509 .45696 .50574 .45113 .49984 Mtetra
.45113 .49984 .45696 .50574 .46713 .50248 .46133 .49655 Mtetra
.46133 .49655 .46713 .50248 .47735 .49921 .47157 .49326 Mtetra
.47157 .49326 .47735 .49921 .48761 .49592 .48185 .48995 Mtetra
.48185 .48995 .48761 .49592 .4979 .49263 .49217 .48663 Mtetra
.49217 .48663 .4979 .49263 .50823 .48933 .50253 .48331 Mtetra
.50253 .48331 .50823 .48933 .5186 .48602 .51293 .47997 Mtetra
.657 .753 .92 r
.51293 .47997 .5186 .48602 .52901 .4827 .52336 .47663 Mtetra
.52336 .47663 .52901 .4827 .53946 .47937 .53384 .47327 Mtetra
.657 .752 .92 r
.53384 .47327 .53946 .47937 .54995 .47602 .54435 .4699 Mtetra
.54435 .4699 .54995 .47602 .56048 .47266 .55491 .46652 Mtetra
.55491 .46652 .56048 .47266 .57105 .4693 .5655 .46313 Mtetra
.5655 .46313 .57105 .4693 .58165 .46592 .57614 .45973 Mtetra
.57614 .45973 .58165 .46592 .5923 .46253 .58681 .45631 Mtetra
.58681 .45631 .5923 .46253 .60299 .45912 .59753 .45288 Mtetra
.59753 .45288 .60299 .45912 .61372 .45571 .60829 .44944 Mtetra
.60829 .44944 .61372 .45571 .62449 .45228 .61909 .44599 Mtetra
.61909 .44599 .62449 .45228 .63531 .44884 .62993 .44252 Mtetra
.62993 .44252 .63531 .44884 .64616 .44538 .64081 .43905 Mtetra
.64081 .43905 .64616 .44538 .65706 .44192 .65174 .43556 Mtetra
.65174 .43556 .65706 .44192 .668 .43844 .66271 .43205 Mtetra
.66271 .43205 .668 .43844 .67898 .43495 .67372 .42853 Mtetra
.67372 .42853 .67898 .43495 .69 .43144 .68477 .425 Mtetra
.68477 .425 .69 .43144 .70107 .42793 .69587 .42146 Mtetra
.69587 .42146 .70107 .42793 .71218 .42439 .70701 .4179 Mtetra
.70701 .4179 .71218 .42439 .72333 .42085 .71819 .41433 Mtetra
.71819 .41433 .72333 .42085 .73453 .41729 .72942 .41075 Mtetra
.72942 .41075 .73453 .41729 .74577 .41372 .74069 .40715 Mtetra
.74069 .40715 .74577 .41372 .75706 .41014 .75201 .40354 Mtetra
.75201 .40354 .75706 .41014 .76839 .40654 .76337 .39991 Mtetra
.76337 .39991 .76839 .40654 .77976 .40292 .77477 .39628 Mtetra
.77477 .39628 .77976 .40292 .79118 .3993 .78622 .39262 Mtetra
.78622 .39262 .79118 .3993 .80264 .39566 .79772 .38895 Mtetra
.79772 .38895 .80264 .39566 .81415 .392 .80926 .38527 Mtetra
.80926 .38527 .81415 .392 .82571 .38833 .82085 .38158 Mtetra
.82085 .38158 .82571 .38833 .83731 .38465 .83249 .37786 Mtetra
.83249 .37786 .83731 .38465 .84896 .38095 .84417 .37414 Mtetra
.84417 .37414 .84896 .38095 .86066 .37724 .8559 .3704 Mtetra
.8559 .3704 .86066 .37724 .8724 .37351 .86768 .36664 Mtetra
.621 .73 .924 r
.23898 .56035 .24528 .56623 .25463 .56443 .24838 .55814 Mtetra
.504 .674 .94 r
.24838 .55814 .25463 .56443 .26696 .52454 .25765 .55801 Mtetra
.381 .107 .368 r
.25765 .55801 .26696 .52454 .27387 .55529 .26772 .5481 Mtetra
.559 .665 .908 r
.26772 .5481 .27387 .55529 .28334 .55324 .27712 .54728 Mtetra
.63 .732 .921 r
.27712 .54728 .28334 .55324 .29289 .55067 .28668 .54484 Mtetra
.639 .74 .921 r
.28668 .54484 .29289 .55067 .30249 .548 .29629 .54217 Mtetra
.639 .74 .922 r
.29629 .54217 .30249 .548 .31211 .54545 .30594 .5395 Mtetra
.625 .733 .925 r
.30594 .5395 .31211 .54545 .32172 .54375 .3156 .53713 Mtetra
.351 .592 .936 r
.3156 .53713 .32172 .54375 .33203 .53058 .32505 .53906 Mtetra
0 0 0 r
.32505 .53906 .33203 .53058 .34141 .53402 .33535 .52726 Mtetra
.595 .697 .914 r
.33535 .52726 .34141 .53402 .35117 .53158 .34508 .52559 Mtetra
.64 .738 .92 r
.34508 .52559 .35117 .53158 .36098 .52871 .35491 .52284 Mtetra
.649 .746 .92 r
.35491 .52284 .36098 .52871 .37085 .52569 .36479 .51986 Mtetra
.653 .749 .92 r
.36479 .51986 .37085 .52569 .38075 .52258 .37472 .51676 Mtetra
.656 .751 .92 r
.37472 .51676 .38075 .52258 .39069 .51941 .38468 .51359 Mtetra
.658 .753 .92 r
.38468 .51359 .39069 .51941 .40067 .51619 .39468 .51036 Mtetra
.659 .753 .92 r
.39468 .51036 .40067 .51619 .41069 .51294 .40472 .5071 Mtetra
.659 .754 .92 r
.40472 .5071 .41069 .51294 .42074 .50968 .4148 .50382 Mtetra
.4148 .50382 .42074 .50968 .43083 .50641 .42492 .50052 Mtetra
.42492 .50052 .43083 .50641 .44096 .50313 .43507 .49721 Mtetra
.659 .753 .92 r
.43507 .49721 .44096 .50313 .45113 .49984 .44526 .4939 Mtetra
.658 .753 .92 r
.44526 .4939 .45113 .49984 .46133 .49655 .45549 .49059 Mtetra
.45549 .49059 .46133 .49655 .47157 .49326 .46576 .48727 Mtetra
.46576 .48727 .47157 .49326 .48185 .48995 .47606 .48393 Mtetra
.47606 .48393 .48185 .48995 .49217 .48663 .48641 .48059 Mtetra
.48641 .48059 .49217 .48663 .50253 .48331 .49679 .47725 Mtetra
.49679 .47725 .50253 .48331 .51293 .47997 .50721 .47389 Mtetra
.657 .753 .92 r
.50721 .47389 .51293 .47997 .52336 .47663 .51767 .47052 Mtetra
.51767 .47052 .52336 .47663 .53384 .47327 .52817 .46713 Mtetra
.52817 .46713 .53384 .47327 .54435 .4699 .53871 .46374 Mtetra
.657 .752 .92 r
.53871 .46374 .54435 .4699 .55491 .46652 .5493 .46034 Mtetra
.5493 .46034 .55491 .46652 .5655 .46313 .55992 .45692 Mtetra
.55992 .45692 .5655 .46313 .57614 .45973 .57058 .45349 Mtetra
.57058 .45349 .57614 .45973 .58681 .45631 .58128 .45005 Mtetra
.58128 .45005 .58681 .45631 .59753 .45288 .59203 .4466 Mtetra
.59203 .4466 .59753 .45288 .60829 .44944 .60281 .44313 Mtetra
.60281 .44313 .60829 .44944 .61909 .44599 .61364 .43966 Mtetra
.61364 .43966 .61909 .44599 .62993 .44252 .62451 .43617 Mtetra
.62451 .43617 .62993 .44252 .64081 .43905 .63542 .43266 Mtetra
.63542 .43266 .64081 .43905 .65174 .43556 .64638 .42915 Mtetra
.64638 .42915 .65174 .43556 .66271 .43205 .65738 .42562 Mtetra
.65738 .42562 .66271 .43205 .67372 .42853 .66842 .42207 Mtetra
.66842 .42207 .67372 .42853 .68477 .425 .6795 .41852 Mtetra
.6795 .41852 .68477 .425 .69587 .42146 .69063 .41495 Mtetra
.69063 .41495 .69587 .42146 .70701 .4179 .7018 .41137 Mtetra
.7018 .41137 .70701 .4179 .71819 .41433 .71301 .40777 Mtetra
.71301 .40777 .71819 .41433 .72942 .41075 .72427 .40416 Mtetra
.72427 .40416 .72942 .41075 .74069 .40715 .73557 .40053 Mtetra
.73557 .40053 .74069 .40715 .75201 .40354 .74692 .3969 Mtetra
.74692 .3969 .75201 .40354 .76337 .39991 .75831 .39324 Mtetra
.75831 .39324 .76337 .39991 .77477 .39628 .76975 .38958 Mtetra
.76975 .38958 .77477 .39628 .78622 .39262 .78123 .3859 Mtetra
.78123 .3859 .78622 .39262 .79772 .38895 .79276 .3822 Mtetra
.79276 .3822 .79772 .38895 .80926 .38527 .80434 .37849 Mtetra
.80434 .37849 .80926 .38527 .82085 .38158 .81596 .37477 Mtetra
.81596 .37477 .82085 .38158 .83249 .37786 .82763 .37103 Mtetra
.82763 .37103 .83249 .37786 .84417 .37414 .83935 .36728 Mtetra
.83935 .36728 .84417 .37414 .8559 .3704 .85111 .36351 Mtetra
.85111 .36351 .8559 .3704 .86768 .36664 .86292 .35973 Mtetra
.626 .731 .923 r
.23263 .55445 .23898 .56035 .24838 .55814 .24206 .55211 Mtetra
.602 .72 .928 r
.24206 .55211 .24838 .55814 .25765 .55801 .25148 .55027 Mtetra
.902 .712 .636 r
.25148 .55027 .25765 .55801 .26772 .5481 .26394 .51017 Mtetra
0 0 .458 r
.26394 .51017 .26772 .5481 .27712 .54728 .27087 .54101 Mtetra
.614 .718 .919 r
.27087 .54101 .27712 .54728 .28668 .54484 .28042 .53892 Mtetra
.636 .737 .921 r
.28042 .53892 .28668 .54484 .29629 .54217 .29005 .53629 Mtetra
.64 .74 .922 r
.29005 .53629 .29629 .54217 .30594 .5395 .29972 .53357 Mtetra
.635 .738 .923 r
.29972 .53357 .30594 .5395 .3156 .53713 .30942 .53097 Mtetra
.594 .717 .93 r
.30942 .53097 .3156 .53713 .32505 .53906 .31911 .52922 Mtetra
.805 .691 .739 r
.31911 .52922 .32505 .53906 .33535 .52726 .32951 .51596 Mtetra
.39 .476 .828 r
.32951 .51596 .33535 .52726 .34508 .52559 .33896 .51936 Mtetra
.628 .728 .919 r
.33896 .51936 .34508 .52559 .35491 .52284 .3488 .51688 Mtetra
.646 .743 .92 r
.3488 .51688 .35491 .52284 .36479 .51986 .3587 .51396 Mtetra
.652 .748 .92 r
.3587 .51396 .36479 .51986 .37472 .51676 .36864 .51088 Mtetra
.655 .75 .92 r
.36864 .51088 .37472 .51676 .38468 .51359 .37863 .50771 Mtetra
.657 .752 .92 r
.37863 .50771 .38468 .51359 .39468 .51036 .38865 .50449 Mtetra
.658 .753 .92 r
.38865 .50449 .39468 .51036 .40472 .5071 .39872 .50121 Mtetra
.659 .754 .92 r
.39872 .50121 .40472 .5071 .4148 .50382 .40882 .49791 Mtetra
.40882 .49791 .4148 .50382 .42492 .50052 .41896 .49459 Mtetra
.41896 .49459 .42492 .50052 .43507 .49721 .42914 .49126 Mtetra
.42914 .49126 .43507 .49721 .44526 .4939 .43935 .48792 Mtetra
.658 .753 .92 r
.43935 .48792 .44526 .4939 .45549 .49059 .44961 .48458 Mtetra
.44961 .48458 .45549 .49059 .46576 .48727 .4599 .48123 Mtetra
.4599 .48123 .46576 .48727 .47606 .48393 .47023 .47788 Mtetra
.47023 .47788 .47606 .48393 .48641 .48059 .4806 .47451 Mtetra
.4806 .47451 .48641 .48059 .49679 .47725 .49101 .47114 Mtetra
.49101 .47114 .49679 .47725 .50721 .47389 .50145 .46775 Mtetra
.50145 .46775 .50721 .47389 .51767 .47052 .51194 .46436 Mtetra
.657 .753 .92 r
.51194 .46436 .51767 .47052 .52817 .46713 .52247 .46095 Mtetra
.52247 .46095 .52817 .46713 .53871 .46374 .53304 .45754 Mtetra
.657 .752 .92 r
.53304 .45754 .53871 .46374 .5493 .46034 .54364 .45411 Mtetra
.54364 .45411 .5493 .46034 .55992 .45692 .55429 .45067 Mtetra
.55429 .45067 .55992 .45692 .57058 .45349 .56498 .44721 Mtetra
.56498 .44721 .57058 .45349 .58128 .45005 .57571 .44375 Mtetra
.57571 .44375 .58128 .45005 .59203 .4466 .58649 .44027 Mtetra
.58649 .44027 .59203 .4466 .60281 .44313 .5973 .43678 Mtetra
.5973 .43678 .60281 .44313 .61364 .43966 .60816 .43328 Mtetra
.60816 .43328 .61364 .43966 .62451 .43617 .61906 .42976 Mtetra
.61906 .42976 .62451 .43617 .63542 .43266 .63 .42623 Mtetra
.63 .42623 .63542 .43266 .64638 .42915 .64098 .42269 Mtetra
.64098 .42269 .64638 .42915 .65738 .42562 .65201 .41913 Mtetra
.65201 .41913 .65738 .42562 .66842 .42207 .66308 .41557 Mtetra
.66308 .41557 .66842 .42207 .6795 .41852 .67419 .41198 Mtetra
.67419 .41198 .6795 .41852 .69063 .41495 .68535 .40839 Mtetra
.68535 .40839 .69063 .41495 .7018 .41137 .69655 .40478 Mtetra
.69655 .40478 .7018 .41137 .71301 .40777 .70779 .40116 Mtetra
.70779 .40116 .71301 .40777 .72427 .40416 .71908 .39752 Mtetra
.71908 .39752 .72427 .40416 .73557 .40053 .73042 .39387 Mtetra
.73042 .39387 .73557 .40053 .74692 .3969 .7418 .3902 Mtetra
.7418 .3902 .74692 .3969 .75831 .39324 .75322 .38652 Mtetra
.75322 .38652 .75831 .39324 .76975 .38958 .76469 .38283 Mtetra
.76469 .38283 .76975 .38958 .78123 .3859 .77621 .37912 Mtetra
.77621 .37912 .78123 .3859 .79276 .3822 .78777 .3754 Mtetra
.78777 .3754 .79276 .3822 .80434 .37849 .79938 .37166 Mtetra
.79938 .37166 .80434 .37849 .81596 .37477 .81103 .36791 Mtetra
.81103 .36791 .81596 .37477 .82763 .37103 .82274 .36415 Mtetra
.82274 .36415 .82763 .37103 .83935 .36728 .83449 .36036 Mtetra
.83449 .36036 .83935 .36728 .85111 .36351 .84628 .35657 Mtetra
.84628 .35657 .85111 .36351 .86292 .35973 .85813 .35276 Mtetra
.623 .728 .922 r
.22625 .54844 .23263 .55445 .24206 .55211 .23569 .54614 Mtetra
.621 .73 .924 r
.23569 .54614 .24206 .55211 .25148 .55027 .24516 .54388 Mtetra
.505 .674 .94 r
.24516 .54388 .25148 .55027 .26394 .51017 .25451 .54371 Mtetra
.375 .099 .361 r
.25451 .54371 .26394 .51017 .27087 .54101 .26466 .53372 Mtetra
.559 .665 .908 r
.26466 .53372 .27087 .54101 .28042 .53892 .27414 .53285 Mtetra
.63 .732 .921 r
.27414 .53285 .28042 .53892 .29005 .53629 .28377 .53036 Mtetra
.639 .74 .921 r
.28377 .53036 .29005 .53629 .29972 .53357 .29346 .52764 Mtetra
.639 .74 .922 r
.29346 .52764 .29972 .53357 .30942 .53097 .30319 .52492 Mtetra
.625 .733 .925 r
.30319 .52492 .30942 .53097 .31911 .52922 .31293 .5225 Mtetra
.352 .592 .936 r
.31293 .5225 .31911 .52922 .32951 .51596 .32246 .52439 Mtetra
0 0 0 r
.32246 .52439 .32951 .51596 .33896 .51936 .33284 .51251 Mtetra
.595 .697 .914 r
.33284 .51251 .33896 .51936 .3488 .51688 .34265 .51079 Mtetra
.64 .738 .92 r
.34265 .51079 .3488 .51688 .3587 .51396 .35257 .50799 Mtetra
.649 .746 .92 r
.35257 .50799 .3587 .51396 .36864 .51088 .36253 .50494 Mtetra
.653 .749 .92 r
.36253 .50494 .36864 .51088 .37863 .50771 .37254 .50179 Mtetra
.656 .751 .92 r
.37254 .50179 .37863 .50771 .38865 .50449 .38258 .49856 Mtetra
.658 .753 .92 r
.38258 .49856 .38865 .50449 .39872 .50121 .39267 .49528 Mtetra
.659 .753 .92 r
.39267 .49528 .39872 .50121 .40882 .49791 .4028 .49196 Mtetra
.659 .754 .92 r
.4028 .49196 .40882 .49791 .41896 .49459 .41296 .48862 Mtetra
.41296 .48862 .41896 .49459 .42914 .49126 .42316 .48527 Mtetra
.42316 .48527 .42914 .49126 .43935 .48792 .4334 .4819 Mtetra
.659 .753 .92 r
.4334 .4819 .43935 .48792 .44961 .48458 .44368 .47853 Mtetra
.658 .753 .92 r
.44368 .47853 .44961 .48458 .4599 .48123 .454 .47516 Mtetra
.454 .47516 .4599 .48123 .47023 .47788 .46435 .47178 Mtetra
.46435 .47178 .47023 .47788 .4806 .47451 .47475 .46839 Mtetra
.47475 .46839 .4806 .47451 .49101 .47114 .48518 .46499 Mtetra
.48518 .46499 .49101 .47114 .50145 .46775 .49566 .46158 Mtetra
.49566 .46158 .50145 .46775 .51194 .46436 .50617 .45816 Mtetra
.657 .753 .92 r
.50617 .45816 .51194 .46436 .52247 .46095 .51672 .45473 Mtetra
.51672 .45473 .52247 .46095 .53304 .45754 .52732 .45129 Mtetra
.52732 .45129 .53304 .45754 .54364 .45411 .53795 .44783 Mtetra
.657 .752 .92 r
.53795 .44783 .54364 .45411 .55429 .45067 .54863 .44437 Mtetra
.54863 .44437 .55429 .45067 .56498 .44721 .55935 .44089 Mtetra
.55935 .44089 .56498 .44721 .57571 .44375 .57011 .4374 Mtetra
.57011 .4374 .57571 .44375 .58649 .44027 .58091 .4339 Mtetra
.58091 .4339 .58649 .44027 .5973 .43678 .59175 .43038 Mtetra
.59175 .43038 .5973 .43678 .60816 .43328 .60263 .42685 Mtetra
.60263 .42685 .60816 .43328 .61906 .42976 .61356 .42331 Mtetra
.61356 .42331 .61906 .42976 .63 .42623 .62453 .41975 Mtetra
.62453 .41975 .63 .42623 .64098 .42269 .63554 .41619 Mtetra
.63554 .41619 .64098 .42269 .65201 .41913 .6466 .41261 Mtetra
.6466 .41261 .65201 .41913 .66308 .41557 .6577 .40901 Mtetra
.6577 .40901 .66308 .41557 .67419 .41198 .66884 .4054 Mtetra
.66884 .4054 .67419 .41198 .68535 .40839 .68003 .40178 Mtetra
.68003 .40178 .68535 .40839 .69655 .40478 .69126 .39815 Mtetra
.69126 .39815 .69655 .40478 .70779 .40116 .70254 .3945 Mtetra
.70254 .3945 .70779 .40116 .71908 .39752 .71386 .39083 Mtetra
.71386 .39083 .71908 .39752 .73042 .39387 .72522 .38715 Mtetra
.72522 .38715 .73042 .39387 .7418 .3902 .73663 .38346 Mtetra
.73663 .38346 .7418 .3902 .75322 .38652 .74809 .37976 Mtetra
.74809 .37976 .75322 .38652 .76469 .38283 .75959 .37603 Mtetra
.75959 .37603 .76469 .38283 .77621 .37912 .77114 .3723 Mtetra
.77114 .3723 .77621 .37912 .78777 .3754 .78274 .36855 Mtetra
.78274 .36855 .78777 .3754 .79938 .37166 .79438 .36478 Mtetra
.79438 .36478 .79938 .37166 .81103 .36791 .80607 .361 Mtetra
.80607 .361 .81103 .36791 .82274 .36415 .8178 .35721 Mtetra
.8178 .35721 .82274 .36415 .83449 .36036 .82959 .3534 Mtetra
.82959 .3534 .83449 .36036 .84628 .35657 .84142 .34958 Mtetra
.84142 .34958 .84628 .35657 .85813 .35276 .8533 .34573 Mtetra
.611 .717 .921 r
.21984 .54219 .22625 .54844 .23569 .54614 .22928 .54014 Mtetra
.626 .731 .923 r
.22928 .54014 .23569 .54614 .24516 .54388 .23878 .53775 Mtetra
.602 .72 .928 r
.23878 .53775 .24516 .54388 .25451 .54371 .24828 .53586 Mtetra
.903 .713 .636 r
.24828 .53586 .25451 .54371 .26466 .53372 .26087 .49555 Mtetra
0 0 .454 r
.26087 .49555 .26466 .53372 .27414 .53285 .26783 .52648 Mtetra
.614 .718 .919 r
.26783 .52648 .27414 .53285 .28377 .53036 .27745 .52434 Mtetra
.636 .737 .921 r
.27745 .52434 .28377 .53036 .29346 .52764 .28716 .52166 Mtetra
.64 .74 .922 r
.28716 .52166 .29346 .52764 .30319 .52492 .29691 .51889 Mtetra
.635 .738 .923 r
.29691 .51889 .30319 .52492 .31293 .5225 .30669 .51623 Mtetra
.594 .717 .93 r
.30669 .51623 .31293 .5225 .32246 .52439 .31645 .51444 Mtetra
.805 .691 .739 r
.31645 .51444 .32246 .52439 .33284 .51251 .32695 .50108 Mtetra
.389 .476 .828 r
.32695 .50108 .33284 .51251 .34265 .51079 .33647 .50446 Mtetra
.628 .728 .919 r
.33647 .50446 .34265 .51079 .35257 .50799 .34639 .50192 Mtetra
.646 .743 .92 r
.34639 .50192 .35257 .50799 .36253 .50494 .35637 .49894 Mtetra
.652 .748 .92 r
.35637 .49894 .36253 .50494 .37254 .50179 .3664 .49581 Mtetra
.655 .75 .92 r
.3664 .49581 .37254 .50179 .38258 .49856 .37647 .49259 Mtetra
.657 .752 .92 r
.37647 .49259 .38258 .49856 .39267 .49528 .38658 .4893 Mtetra
.658 .753 .92 r
.38658 .4893 .39267 .49528 .4028 .49196 .39673 .48597 Mtetra
.659 .754 .92 r
.39673 .48597 .4028 .49196 .41296 .48862 .40692 .48261 Mtetra
.40692 .48261 .41296 .48862 .42316 .48527 .41715 .47923 Mtetra
.41715 .47923 .42316 .48527 .4334 .4819 .42741 .47584 Mtetra
.42741 .47584 .4334 .4819 .44368 .47853 .43771 .47245 Mtetra
.658 .753 .92 r
.43771 .47245 .44368 .47853 .454 .47516 .44806 .46905 Mtetra
.44806 .46905 .454 .47516 .46435 .47178 .45844 .46564 Mtetra
.45844 .46564 .46435 .47178 .47475 .46839 .46886 .46222 Mtetra
.46886 .46222 .47475 .46839 .48518 .46499 .47932 .4588 Mtetra
.47932 .4588 .48518 .46499 .49566 .46158 .48982 .45536 Mtetra
.48982 .45536 .49566 .46158 .50617 .45816 .50036 .45192 Mtetra
.50036 .45192 .50617 .45816 .51672 .45473 .51094 .44846 Mtetra
.657 .753 .92 r
.51094 .44846 .51672 .45473 .52732 .45129 .52156 .44499 Mtetra
.52156 .44499 .52732 .45129 .53795 .44783 .53222 .44151 Mtetra
.657 .752 .92 r
.53222 .44151 .53795 .44783 .54863 .44437 .54293 .43802 Mtetra
.54293 .43802 .54863 .44437 .55935 .44089 .55367 .43452 Mtetra
.55367 .43452 .55935 .44089 .57011 .4374 .56446 .431 Mtetra
.56446 .431 .57011 .4374 .58091 .4339 .57528 .42747 Mtetra
.57528 .42747 .58091 .4339 .59175 .43038 .58616 .42393 Mtetra
.58616 .42393 .59175 .43038 .60263 .42685 .59707 .42038 Mtetra
.59707 .42038 .60263 .42685 .61356 .42331 .60802 .41681 Mtetra
.60802 .41681 .61356 .42331 .62453 .41975 .61902 .41323 Mtetra
.61902 .41323 .62453 .41975 .63554 .41619 .63007 .40964 Mtetra
.63007 .40964 .63554 .41619 .6466 .41261 .64115 .40603 Mtetra
.64115 .40603 .6466 .41261 .6577 .40901 .65228 .40241 Mtetra
.65228 .40241 .6577 .40901 .66884 .4054 .66345 .39877 Mtetra
.66345 .39877 .66884 .4054 .68003 .40178 .67467 .39512 Mtetra
.67467 .39512 .68003 .40178 .69126 .39815 .68593 .39146 Mtetra
.68593 .39146 .69126 .39815 .70254 .3945 .69724 .38779 Mtetra
.69724 .38779 .70254 .3945 .71386 .39083 .70859 .38409 Mtetra
.70859 .38409 .71386 .39083 .72522 .38715 .71999 .38039 Mtetra
.71999 .38039 .72522 .38715 .73663 .38346 .73143 .37667 Mtetra
.73143 .37667 .73663 .38346 .74809 .37976 .74292 .37294 Mtetra
.74292 .37294 .74809 .37976 .75959 .37603 .75446 .36919 Mtetra
.75446 .36919 .75959 .37603 .77114 .3723 .76604 .36542 Mtetra
.76604 .36542 .77114 .3723 .78274 .36855 .77767 .36165 Mtetra
.77767 .36165 .78274 .36855 .79438 .36478 .78934 .35785 Mtetra
.78934 .35785 .79438 .36478 .80607 .361 .80107 .35404 Mtetra
.80107 .35404 .80607 .361 .8178 .35721 .81284 .35022 Mtetra
.81284 .35022 .8178 .35721 .82959 .3534 .82465 .34638 Mtetra
.82465 .34638 .82959 .3534 .84142 .34958 .83652 .34253 Mtetra
.83652 .34253 .84142 .34958 .8533 .34573 .84844 .33866 Mtetra
.568 .677 .913 r
.21347 .53513 .21984 .54219 .22928 .54014 .22283 .53403 Mtetra
.623 .728 .922 r
.22283 .53403 .22928 .54014 .23878 .53775 .23234 .53168 Mtetra
.621 .73 .924 r
.23234 .53168 .23878 .53775 .24828 .53586 .24189 .52937 Mtetra
.505 .674 .94 r
.24189 .52937 .24828 .53586 .26087 .49555 .25131 .52916 Mtetra
.368 .09 .355 r
.25131 .52916 .26087 .49555 .26783 .52648 .26155 .51909 Mtetra
.559 .665 .908 r
.26155 .51909 .26783 .52648 .27745 .52434 .2711 .51817 Mtetra
.63 .732 .921 r
.2711 .51817 .27745 .52434 .28716 .52166 .28081 .51563 Mtetra
.639 .74 .921 r
.28081 .51563 .28716 .52166 .29691 .51889 .29058 .51286 Mtetra
.639 .74 .922 r
.29058 .51286 .29691 .51889 .30669 .51623 .30039 .51008 Mtetra
.625 .733 .925 r
.30039 .51008 .30669 .51623 .31645 .51444 .31021 .50761 Mtetra
.353 .593 .936 r
.31021 .50761 .31645 .51444 .32695 .50108 .31981 .50947 Mtetra
0 0 0 r
.31981 .50947 .32695 .50108 .33647 .50446 .33029 .49749 Mtetra
.595 .697 .914 r
.33029 .49749 .33647 .50446 .34639 .50192 .34018 .49572 Mtetra
.64 .738 .92 r
.34018 .49572 .34639 .50192 .35637 .49894 .35018 .49287 Mtetra
.649 .746 .92 r
.35018 .49287 .35637 .49894 .3664 .49581 .36022 .48977 Mtetra
.653 .749 .92 r
.36022 .48977 .3664 .49581 .37647 .49259 .37032 .48656 Mtetra
.656 .751 .92 r
.37032 .48656 .37647 .49259 .38658 .4893 .38045 .48327 Mtetra
.658 .753 .92 r
.38045 .48327 .38658 .4893 .39673 .48597 .39062 .47993 Mtetra
.659 .753 .92 r
.39062 .47993 .39673 .48597 .40692 .48261 .40083 .47655 Mtetra
.659 .754 .92 r
.40083 .47655 .40692 .48261 .41715 .47923 .41109 .47315 Mtetra
.41109 .47315 .41715 .47923 .42741 .47584 .42138 .46974 Mtetra
.42138 .46974 .42741 .47584 .43771 .47245 .4317 .46632 Mtetra
.659 .753 .92 r
.4317 .46632 .43771 .47245 .44806 .46905 .44207 .46289 Mtetra
.658 .753 .92 r
.44207 .46289 .44806 .46905 .45844 .46564 .45248 .45945 Mtetra
.45248 .45945 .45844 .46564 .46886 .46222 .46292 .45601 Mtetra
.46292 .45601 .46886 .46222 .47932 .4588 .47341 .45256 Mtetra
.47341 .45256 .47932 .4588 .48982 .45536 .48394 .4491 Mtetra
.48394 .4491 .48982 .45536 .50036 .45192 .4945 .44563 Mtetra
.4945 .44563 .50036 .45192 .51094 .44846 .50511 .44215 Mtetra
.657 .753 .92 r
.50511 .44215 .51094 .44846 .52156 .44499 .51576 .43866 Mtetra
.51576 .43866 .52156 .44499 .53222 .44151 .52645 .43515 Mtetra
.52645 .43515 .53222 .44151 .54293 .43802 .53718 .43163 Mtetra
.657 .752 .92 r
.53718 .43163 .54293 .43802 .55367 .43452 .54795 .4281 Mtetra
.54795 .4281 .55367 .43452 .56446 .431 .55877 .42456 Mtetra
.55877 .42456 .56446 .431 .57528 .42747 .56962 .42101 Mtetra
.56962 .42101 .57528 .42747 .58616 .42393 .58052 .41744 Mtetra
.58052 .41744 .58616 .42393 .59707 .42038 .59146 .41386 Mtetra
.59146 .41386 .59707 .42038 .60802 .41681 .60245 .41027 Mtetra
.60245 .41027 .60802 .41681 .61902 .41323 .61348 .40666 Mtetra
.61348 .40666 .61902 .41323 .63007 .40964 .62455 .40304 Mtetra
.62455 .40304 .63007 .40964 .64115 .40603 .63566 .39941 Mtetra
.63566 .39941 .64115 .40603 .65228 .40241 .64682 .39576 Mtetra
.64682 .39576 .65228 .40241 .66345 .39877 .65803 .3921 Mtetra
.65803 .3921 .66345 .39877 .67467 .39512 .66927 .38842 Mtetra
.66927 .38842 .67467 .39512 .68593 .39146 .68057 .38473 Mtetra
.68057 .38473 .68593 .39146 .69724 .38779 .69191 .38103 Mtetra
.69191 .38103 .69724 .38779 .70859 .38409 .70329 .37731 Mtetra
.70329 .37731 .70859 .38409 .71999 .38039 .71472 .37358 Mtetra
.71472 .37358 .71999 .38039 .73143 .37667 .72619 .36983 Mtetra
.72619 .36983 .73143 .37667 .74292 .37294 .73772 .36607 Mtetra
.73772 .36607 .74292 .37294 .75446 .36919 .74928 .36229 Mtetra
.74928 .36229 .75446 .36919 .76604 .36542 .7609 .3585 Mtetra
.7609 .3585 .76604 .36542 .77767 .36165 .77256 .35469 Mtetra
.77256 .35469 .77767 .36165 .78934 .35785 .78427 .35087 Mtetra
.78427 .35087 .78934 .35785 .80107 .35404 .79603 .34703 Mtetra
.79603 .34703 .80107 .35404 .81284 .35022 .80783 .34318 Mtetra
.80783 .34318 .81284 .35022 .82465 .34638 .81968 .33931 Mtetra
.81968 .33931 .82465 .34638 .83652 .34253 .83158 .33543 Mtetra
.83158 .33543 .83652 .34253 .84844 .33866 .84353 .33153 Mtetra
.158 .237 .696 r
.20799 .51822 .21347 .53513 .22283 .53403 .21636 .52768 Mtetra
.611 .718 .921 r
.21636 .52768 .22283 .53403 .23234 .53168 .22586 .52558 Mtetra
.626 .731 .923 r
.22586 .52558 .23234 .53168 .24189 .52937 .23544 .52314 Mtetra
.602 .72 .928 r
.23544 .52314 .24189 .52937 .25131 .52916 .24501 .5212 Mtetra
.904 .713 .635 r
.24501 .5212 .25131 .52916 .26155 .51909 .25775 .48068 Mtetra
0 0 .45 r
.25775 .48068 .26155 .51909 .2711 .51817 .26473 .5117 Mtetra
.614 .718 .919 r
.26473 .5117 .2711 .51817 .28081 .51563 .27443 .50951 Mtetra
.636 .737 .921 r
.27443 .50951 .28081 .51563 .29058 .51286 .28421 .50678 Mtetra
.64 .74 .922 r
.28421 .50678 .29058 .51286 .30039 .51008 .29404 .50395 Mtetra
.635 .738 .923 r
.29404 .50395 .30039 .51008 .31021 .50761 .3039 .50124 Mtetra
.594 .717 .929 r
.3039 .50124 .31021 .50761 .31981 .50947 .31375 .49939 Mtetra
.806 .692 .739 r
.31375 .49939 .31981 .50947 .33029 .49749 .32434 .48593 Mtetra
.388 .475 .828 r
.32434 .48593 .33029 .49749 .34018 .49572 .33394 .48928 Mtetra
.628 .728 .919 r
.33394 .48928 .34018 .49572 .35018 .49287 .34394 .48669 Mtetra
.646 .743 .92 r
.34394 .48669 .35018 .49287 .36022 .48977 .35401 .48366 Mtetra
.652 .748 .92 r
.35401 .48366 .36022 .48977 .37032 .48656 .36412 .48047 Mtetra
.655 .75 .92 r
.36412 .48047 .37032 .48656 .38045 .48327 .37427 .47719 Mtetra
.657 .752 .92 r
.37427 .47719 .38045 .48327 .39062 .47993 .38447 .47384 Mtetra
.658 .753 .92 r
.38447 .47384 .39062 .47993 .40083 .47655 .39471 .47045 Mtetra
.659 .754 .92 r
.39471 .47045 .40083 .47655 .41109 .47315 .40498 .46703 Mtetra
.40498 .46703 .41109 .47315 .42138 .46974 .4153 .46359 Mtetra
.4153 .46359 .42138 .46974 .4317 .46632 .42565 .46015 Mtetra
.42565 .46015 .4317 .46632 .44207 .46289 .43604 .45669 Mtetra
.658 .753 .92 r
.43604 .45669 .44207 .46289 .45248 .45945 .44648 .45323 Mtetra
.44648 .45323 .45248 .45945 .46292 .45601 .45695 .44976 Mtetra
.45695 .44976 .46292 .45601 .47341 .45256 .46746 .44628 Mtetra
.46746 .44628 .47341 .45256 .48394 .4491 .47801 .4428 Mtetra
.47801 .4428 .48394 .4491 .4945 .44563 .48861 .4393 Mtetra
.48861 .4393 .4945 .44563 .50511 .44215 .49924 .43579 Mtetra
.49924 .43579 .50511 .44215 .51576 .43866 .50992 .43227 Mtetra
.657 .753 .92 r
.50992 .43227 .51576 .43866 .52645 .43515 .52063 .42874 Mtetra
.52063 .42874 .52645 .43515 .53718 .43163 .53139 .4252 Mtetra
.657 .752 .92 r
.53139 .4252 .53718 .43163 .54795 .4281 .54219 .42164 Mtetra
.54219 .42164 .54795 .4281 .55877 .42456 .55303 .41808 Mtetra
.55303 .41808 .55877 .42456 .56962 .42101 .56392 .41449 Mtetra
.56392 .41449 .56962 .42101 .58052 .41744 .57485 .4109 Mtetra
.57485 .4109 .58052 .41744 .59146 .41386 .58582 .40729 Mtetra
.58582 .40729 .59146 .41386 .60245 .41027 .59683 .40367 Mtetra
.59683 .40367 .60245 .41027 .61348 .40666 .60789 .40004 Mtetra
.60789 .40004 .61348 .40666 .62455 .40304 .61899 .39639 Mtetra
.61899 .39639 .62455 .40304 .63566 .39941 .63014 .39273 Mtetra
.63014 .39273 .63566 .39941 .64682 .39576 .64133 .38906 Mtetra
.64133 .38906 .64682 .39576 .65803 .3921 .65256 .38537 Mtetra
.65256 .38537 .65803 .3921 .66927 .38842 .66384 .38167 Mtetra
.66384 .38167 .66927 .38842 .68057 .38473 .67516 .37795 Mtetra
.67516 .37795 .68057 .38473 .69191 .38103 .68653 .37422 Mtetra
.68653 .37422 .69191 .38103 .70329 .37731 .69795 .37047 Mtetra
.69795 .37047 .70329 .37731 .71472 .37358 .70941 .36671 Mtetra
.70941 .36671 .71472 .37358 .72619 .36983 .72092 .36293 Mtetra
.72092 .36293 .72619 .36983 .73772 .36607 .73247 .35914 Mtetra
.73247 .35914 .73772 .36607 .74928 .36229 .74407 .35534 Mtetra
.74407 .35534 .74928 .36229 .7609 .3585 .75572 .35152 Mtetra
.75572 .35152 .7609 .3585 .77256 .35469 .76741 .34768 Mtetra
.76741 .34768 .77256 .35469 .78427 .35087 .77916 .34383 Mtetra
.77916 .34383 .78427 .35087 .79603 .34703 .79095 .33997 Mtetra
.79095 .33997 .79603 .34703 .80783 .34318 .80279 .33609 Mtetra
.80279 .33609 .80783 .34318 .81968 .33931 .81467 .33219 Mtetra
.81467 .33219 .81968 .33931 .83158 .33543 .82661 .32828 Mtetra
.82661 .32828 .83158 .33543 .84353 .33153 .8386 .32435 Mtetra
0 0 0 r
.19963 .53091 .20799 .51822 .21636 .52768 .20992 .52052 Mtetra
.567 .677 .913 r
.20992 .52052 .21636 .52768 .22586 .52558 .21935 .51937 Mtetra
.623 .728 .922 r
.21935 .51937 .22586 .52558 .23544 .52314 .22894 .51697 Mtetra
.621 .73 .924 r
.22894 .51697 .23544 .52314 .24501 .5212 .23856 .51461 Mtetra
.505 .674 .94 r
.23856 .51461 .24501 .5212 .25775 .48068 .24805 .51435 Mtetra
.361 .082 .348 r
.24805 .51435 .25775 .48068 .26473 .5117 .25839 .5042 Mtetra
.559 .665 .909 r
.25839 .5042 .26473 .5117 .27443 .50951 .26801 .50324 Mtetra
.63 .732 .921 r
.26801 .50324 .27443 .50951 .28421 .50678 .2778 .50064 Mtetra
.639 .74 .921 r
.2778 .50064 .28421 .50678 .29404 .50395 .28765 .49781 Mtetra
.639 .74 .922 r
.28765 .49781 .29404 .50395 .3039 .50124 .29754 .49498 Mtetra
.625 .733 .924 r
.29754 .49498 .3039 .50124 .31375 .49939 .30744 .49246 Mtetra
.355 .593 .936 r
.30744 .49246 .31375 .49939 .32434 .48593 .31712 .49428 Mtetra
0 0 0 r
.31712 .49428 .32434 .48593 .33394 .48928 .32769 .48221 Mtetra
.595 .697 .914 r
.32769 .48221 .33394 .48928 .34394 .48669 .33767 .48039 Mtetra
.64 .738 .92 r
.33767 .48039 .34394 .48669 .35401 .48366 .34775 .47747 Mtetra
.649 .746 .92 r
.34775 .47747 .35401 .48366 .36412 .48047 .35788 .47432 Mtetra
.653 .749 .92 r
.35788 .47432 .36412 .48047 .37427 .47719 .36806 .47105 Mtetra
.656 .751 .92 r
.36806 .47105 .37427 .47719 .38447 .47384 .37828 .4677 Mtetra
.658 .753 .92 r
.37828 .4677 .38447 .47384 .39471 .47045 .38854 .4643 Mtetra
.659 .753 .92 r
.38854 .4643 .39471 .47045 .40498 .46703 .39884 .46087 Mtetra
.659 .754 .92 r
.39884 .46087 .40498 .46703 .4153 .46359 .40918 .45741 Mtetra
.40918 .45741 .4153 .46359 .42565 .46015 .41956 .45393 Mtetra
.41956 .45393 .42565 .46015 .43604 .45669 .42997 .45045 Mtetra
.659 .753 .92 r
.42997 .45045 .43604 .45669 .44648 .45323 .44043 .44696 Mtetra
.658 .753 .92 r
.44043 .44696 .44648 .45323 .45695 .44976 .45093 .44346 Mtetra
.45093 .44346 .45695 .44976 .46746 .44628 .46147 .43996 Mtetra
.46147 .43996 .46746 .44628 .47801 .4428 .47205 .43645 Mtetra
.47205 .43645 .47801 .4428 .48861 .4393 .48267 .43292 Mtetra
.48267 .43292 .48861 .4393 .49924 .43579 .49333 .42939 Mtetra
.49333 .42939 .49924 .43579 .50992 .43227 .50403 .42584 Mtetra
.657 .753 .92 r
.50403 .42584 .50992 .43227 .52063 .42874 .51478 .42229 Mtetra
.51478 .42229 .52063 .42874 .53139 .4252 .52556 .41872 Mtetra
.52556 .41872 .53139 .4252 .54219 .42164 .53639 .41514 Mtetra
.657 .752 .92 r
.53639 .41514 .54219 .42164 .55303 .41808 .54726 .41154 Mtetra
.54726 .41154 .55303 .41808 .56392 .41449 .55817 .40793 Mtetra
.55817 .40793 .56392 .41449 .57485 .4109 .56913 .40431 Mtetra
.56913 .40431 .57485 .4109 .58582 .40729 .58013 .40068 Mtetra
.58013 .40068 .58582 .40729 .59683 .40367 .59117 .39703 Mtetra
.59117 .39703 .59683 .40367 .60789 .40004 .60226 .39337 Mtetra
.60226 .39337 .60789 .40004 .61899 .39639 .61339 .3897 Mtetra
.61339 .3897 .61899 .39639 .63014 .39273 .62457 .38601 Mtetra
.62457 .38601 .63014 .39273 .64133 .38906 .63579 .38231 Mtetra
.63579 .38231 .64133 .38906 .65256 .38537 .64705 .37859 Mtetra
.64705 .37859 .65256 .38537 .66384 .38167 .65836 .37486 Mtetra
.65836 .37486 .66384 .38167 .67516 .37795 .66972 .37112 Mtetra
.66972 .37112 .67516 .37795 .68653 .37422 .68112 .36736 Mtetra
.68112 .36736 .68653 .37422 .69795 .37047 .69256 .36358 Mtetra
.69256 .36358 .69795 .37047 .70941 .36671 .70406 .35979 Mtetra
.70406 .35979 .70941 .36671 .72092 .36293 .7156 .35599 Mtetra
.7156 .35599 .72092 .36293 .73247 .35914 .72718 .35217 Mtetra
.72718 .35217 .73247 .35914 .74407 .35534 .73882 .34834 Mtetra
.73882 .34834 .74407 .35534 .75572 .35152 .7505 .34449 Mtetra
.7505 .34449 .75572 .35152 .76741 .34768 .76223 .34062 Mtetra
.76223 .34062 .76741 .34768 .77916 .34383 .774 .33674 Mtetra
.774 .33674 .77916 .34383 .79095 .33997 .78583 .33285 Mtetra
.78583 .33285 .79095 .33997 .80279 .33609 .7977 .32894 Mtetra
.7977 .32894 .80279 .33609 .81467 .33219 .80963 .32501 Mtetra
.80963 .32501 .81467 .33219 .82661 .32828 .8216 .32107 Mtetra
.8216 .32107 .82661 .32828 .8386 .32435 .83362 .31711 Mtetra
.848 .711 .712 r
.19326 .52227 .19963 .53091 .20992 .52052 .20439 .50345 Mtetra
.154 .235 .695 r
.20439 .50345 .20992 .52052 .21935 .51937 .21281 .51291 Mtetra
.611 .718 .921 r
.21281 .51291 .21935 .51937 .22894 .51697 .22239 .51077 Mtetra
.626 .731 .923 r
.22239 .51077 .22894 .51697 .23856 .51461 .23204 .50828 Mtetra
.602 .72 .928 r
.23204 .50828 .23856 .51461 .24805 .51435 .24169 .50628 Mtetra
.905 .714 .634 r
.24169 .50628 .24805 .51435 .25839 .5042 .25457 .46555 Mtetra
0 0 .446 r
.25457 .46555 .25839 .5042 .26801 .50324 .26157 .49666 Mtetra
.614 .718 .919 r
.26157 .49666 .26801 .50324 .2778 .50064 .27135 .49441 Mtetra
.636 .737 .921 r
.27135 .49441 .2778 .50064 .28765 .49781 .28122 .49163 Mtetra
.64 .74 .922 r
.28122 .49163 .28765 .49781 .29754 .49498 .29113 .48875 Mtetra
.635 .738 .923 r
.29113 .48875 .29754 .49498 .30744 .49246 .30107 .48598 Mtetra
.594 .717 .929 r
.30107 .48598 .30744 .49246 .31712 .49428 .31099 .48408 Mtetra
.806 .693 .74 r
.31099 .48408 .31712 .49428 .32769 .48221 .32168 .47052 Mtetra
.387 .475 .828 r
.32168 .47052 .32769 .48221 .33767 .48039 .33136 .47384 Mtetra
.628 .728 .919 r
.33136 .47384 .33767 .48039 .34775 .47747 .34145 .47119 Mtetra
.646 .743 .92 r
.34145 .47119 .34775 .47747 .35788 .47432 .3516 .4681 Mtetra
.652 .748 .92 r
.3516 .4681 .35788 .47432 .36806 .47105 .3618 .46485 Mtetra
.655 .75 .92 r
.3618 .46485 .36806 .47105 .37828 .4677 .37204 .46151 Mtetra
.657 .752 .92 r
.37204 .46151 .37828 .4677 .38854 .4643 .38232 .45811 Mtetra
.658 .753 .92 r
.38232 .45811 .38854 .4643 .39884 .46087 .39265 .45466 Mtetra
.659 .754 .92 r
.39265 .45466 .39884 .46087 .40918 .45741 .40301 .45118 Mtetra
.40301 .45118 .40918 .45741 .41956 .45393 .41342 .44768 Mtetra
.41342 .44768 .41956 .45393 .42997 .45045 .42386 .44416 Mtetra
.42386 .44416 .42997 .45045 .44043 .44696 .43435 .44065 Mtetra
.658 .753 .92 r
.43435 .44065 .44043 .44696 .45093 .44346 .44487 .43712 Mtetra
.44487 .43712 .45093 .44346 .46147 .43996 .45543 .43359 Mtetra
.45543 .43359 .46147 .43996 .47205 .43645 .46604 .43005 Mtetra
.46604 .43005 .47205 .43645 .48267 .43292 .47669 .4265 Mtetra
.47669 .4265 .48267 .43292 .49333 .42939 .48738 .42294 Mtetra
.48738 .42294 .49333 .42939 .50403 .42584 .4981 .41937 Mtetra
.4981 .41937 .50403 .42584 .51478 .42229 .50888 .41578 Mtetra
.657 .753 .92 r
.50888 .41578 .51478 .42229 .52556 .41872 .51969 .41219 Mtetra
.51969 .41219 .52556 .41872 .53639 .41514 .53055 .40858 Mtetra
.657 .752 .92 r
.53055 .40858 .53639 .41514 .54726 .41154 .54145 .40496 Mtetra
.54145 .40496 .54726 .41154 .55817 .40793 .55239 .40132 Mtetra
.55239 .40132 .55817 .40793 .56913 .40431 .56337 .39768 Mtetra
.56337 .39768 .56913 .40431 .58013 .40068 .5744 .39402 Mtetra
.5744 .39402 .58013 .40068 .59117 .39703 .58547 .39034 Mtetra
.58547 .39034 .59117 .39703 .60226 .39337 .59659 .38666 Mtetra
.59659 .38666 .60226 .39337 .61339 .3897 .60775 .38295 Mtetra
.60775 .38295 .61339 .3897 .62457 .38601 .61896 .37924 Mtetra
.61896 .37924 .62457 .38601 .63579 .38231 .63021 .37551 Mtetra
.63021 .37551 .63579 .38231 .64705 .37859 .6415 .37176 Mtetra
.6415 .37176 .64705 .37859 .65836 .37486 .65284 .36801 Mtetra
.65284 .36801 .65836 .37486 .66972 .37112 .66423 .36423 Mtetra
.66423 .36423 .66972 .37112 .68112 .36736 .67566 .36044 Mtetra
.67566 .36044 .68112 .36736 .69256 .36358 .68714 .35664 Mtetra
.68714 .35664 .69256 .36358 .70406 .35979 .69867 .35282 Mtetra
.69867 .35282 .70406 .35979 .7156 .35599 .71024 .34899 Mtetra
.71024 .34899 .7156 .35599 .72718 .35217 .72186 .34514 Mtetra
.72186 .34514 .72718 .35217 .73882 .34834 .73353 .34128 Mtetra
.73353 .34128 .73882 .34834 .7505 .34449 .74524 .3374 Mtetra
.74524 .3374 .7505 .34449 .76223 .34062 .757 .33351 Mtetra
.757 .33351 .76223 .34062 .774 .33674 .76881 .3296 Mtetra
.76881 .3296 .774 .33674 .78583 .33285 .78067 .32567 Mtetra
.78067 .32567 .78583 .33285 .7977 .32894 .79258 .32173 Mtetra
.79258 .32173 .7977 .32894 .80963 .32501 .80454 .31778 Mtetra
.80454 .31778 .80963 .32501 .8216 .32107 .81655 .3138 Mtetra
.81655 .3138 .8216 .32107 .83362 .31711 .8286 .30981 Mtetra
.443 .643 .942 r
.18666 .51554 .19326 .52227 .20439 .50345 .19592 .51612 Mtetra
0 0 0 r
.19592 .51612 .20439 .50345 .21281 .51291 .2063 .50565 Mtetra
.567 .677 .913 r
.2063 .50565 .21281 .51291 .22239 .51077 .21581 .50445 Mtetra
.623 .728 .922 r
.21581 .50445 .22239 .51077 .23204 .50828 .22547 .502 Mtetra
.621 .73 .924 r
.22547 .502 .23204 .50828 .24169 .50628 .23518 .49958 Mtetra
.506 .674 .94 r
.23518 .49958 .24169 .50628 .25457 .46555 .24474 .49928 Mtetra
.354 .073 .341 r
.24474 .49928 .25457 .46555 .26157 .49666 .25517 .48904 Mtetra
.559 .665 .909 r
.25517 .48904 .26157 .49666 .27135 .49441 .26487 .48804 Mtetra
.63 .732 .921 r
.26487 .48804 .27135 .49441 .28122 .49163 .27474 .48538 Mtetra
.639 .74 .921 r
.27474 .48538 .28122 .49163 .29113 .48875 .28467 .4825 Mtetra
.639 .74 .922 r
.28467 .4825 .29113 .48875 .30107 .48598 .29464 .47961 Mtetra
.625 .733 .924 r
.29464 .47961 .30107 .48598 .31099 .48408 .30463 .47704 Mtetra
.356 .593 .935 r
.30463 .47704 .31099 .48408 .32168 .47052 .31438 .47882 Mtetra
.535 .817 .469 r
.31438 .47882 .32168 .47052 .33136 .47384 .32505 .46665 Mtetra
.595 .697 .914 r
.32505 .46665 .33136 .47384 .34145 .47119 .33511 .46478 Mtetra
.64 .738 .92 r
.33511 .46478 .34145 .47119 .3516 .4681 .34527 .46181 Mtetra
.649 .746 .92 r
.34527 .46181 .3516 .4681 .3618 .46485 .35549 .45859 Mtetra
.653 .749 .92 r
.35549 .45859 .3618 .46485 .37204 .46151 .36576 .45526 Mtetra
.656 .751 .92 r
.36576 .45526 .37204 .46151 .38232 .45811 .37606 .45186 Mtetra
.658 .753 .92 r
.37606 .45186 .38232 .45811 .39265 .45466 .38641 .4484 Mtetra
.659 .753 .92 r
.38641 .4484 .39265 .45466 .40301 .45118 .3968 .4449 Mtetra
.659 .754 .92 r
.3968 .4449 .40301 .45118 .41342 .44768 .40723 .44137 Mtetra
.40723 .44137 .41342 .44768 .42386 .44416 .4177 .43784 Mtetra
.4177 .43784 .42386 .44416 .43435 .44065 .42821 .43429 Mtetra
.659 .753 .92 r
.42821 .43429 .43435 .44065 .44487 .43712 .43876 .43074 Mtetra
.658 .753 .92 r
.43876 .43074 .44487 .43712 .45543 .43359 .44936 .42718 Mtetra
.44936 .42718 .45543 .43359 .46604 .43005 .45999 .42361 Mtetra
.45999 .42361 .46604 .43005 .47669 .4265 .47066 .42003 Mtetra
.47066 .42003 .47669 .4265 .48738 .42294 .48138 .41644 Mtetra
.48138 .41644 .48738 .42294 .4981 .41937 .49213 .41285 Mtetra
.49213 .41285 .4981 .41937 .50888 .41578 .50293 .40923 Mtetra
.657 .753 .92 r
.50293 .40923 .50888 .41578 .51969 .41219 .51378 .40561 Mtetra
.51378 .40561 .51969 .41219 .53055 .40858 .52466 .40198 Mtetra
.52466 .40198 .53055 .40858 .54145 .40496 .53559 .39833 Mtetra
.657 .752 .92 r
.53559 .39833 .54145 .40496 .55239 .40132 .54656 .39467 Mtetra
.54656 .39467 .55239 .40132 .56337 .39768 .55757 .39099 Mtetra
.55757 .39099 .56337 .39768 .5744 .39402 .56863 .38731 Mtetra
.56863 .38731 .5744 .39402 .58547 .39034 .57973 .3836 Mtetra
.57973 .3836 .58547 .39034 .59659 .38666 .59088 .37989 Mtetra
.59088 .37989 .59659 .38666 .60775 .38295 .60207 .37616 Mtetra
.60207 .37616 .60775 .38295 .61896 .37924 .6133 .37242 Mtetra
.6133 .37242 .61896 .37924 .63021 .37551 .62459 .36866 Mtetra
.62459 .36866 .63021 .37551 .6415 .37176 .63591 .36489 Mtetra
.63591 .36489 .6415 .37176 .65284 .36801 .64728 .3611 Mtetra
.64728 .3611 .65284 .36801 .66423 .36423 .6587 .3573 Mtetra
.6587 .3573 .66423 .36423 .67566 .36044 .67017 .35348 Mtetra
.67017 .35348 .67566 .36044 .68714 .35664 .68168 .34965 Mtetra
.68168 .34965 .68714 .35664 .69867 .35282 .69324 .3458 Mtetra
.69324 .3458 .69867 .35282 .71024 .34899 .70484 .34194 Mtetra
.70484 .34194 .71024 .34899 .72186 .34514 .71649 .33806 Mtetra
.71649 .33806 .72186 .34514 .73353 .34128 .72819 .33417 Mtetra
.72819 .33417 .73353 .34128 .74524 .3374 .73994 .33026 Mtetra
.73994 .33026 .74524 .3374 .757 .33351 .75174 .32634 Mtetra
.75174 .32634 .757 .33351 .76881 .3296 .76358 .3224 Mtetra
.76358 .3224 .76881 .3296 .78067 .32567 .77548 .31845 Mtetra
.77548 .31845 .78067 .32567 .79258 .32173 .78742 .31448 Mtetra
.78742 .31448 .79258 .32173 .80454 .31778 .79941 .31049 Mtetra
.79941 .31049 .80454 .31778 .81655 .3138 .81146 .30648 Mtetra
.81146 .30648 .81655 .3138 .8286 .30981 .82355 .30246 Mtetra
.589 .713 .93 r
.17999 .50912 .18666 .51554 .19592 .51612 .18949 .50737 Mtetra
.849 .712 .711 r
.18949 .50737 .19592 .51612 .2063 .50565 .20072 .48843 Mtetra
.151 .232 .694 r
.20072 .48843 .2063 .50565 .21581 .50445 .2092 .49789 Mtetra
.611 .718 .921 r
.2092 .49789 .21581 .50445 .22547 .502 .21886 .49569 Mtetra
.626 .731 .923 r
.21886 .49569 .22547 .502 .23518 .49958 .22859 .49315 Mtetra
.602 .72 .928 r
.22859 .49315 .23518 .49958 .24474 .49928 .23832 .4911 Mtetra
.906 .715 .633 r
.23832 .4911 .24474 .49928 .25517 .48904 .25134 .45015 Mtetra
0 0 .443 r
.25134 .45015 .25517 .48904 .26487 .48804 .25836 .48135 Mtetra
.614 .718 .919 r
.25836 .48135 .26487 .48804 .27474 .48538 .26822 .47905 Mtetra
.636 .737 .921 r
.26822 .47905 .27474 .48538 .28467 .4825 .27817 .47621 Mtetra
.64 .74 .922 r
.27817 .47621 .28467 .4825 .29464 .47961 .28816 .47327 Mtetra
.635 .738 .923 r
.28816 .47327 .29464 .47961 .30463 .47704 .29819 .47045 Mtetra
.594 .717 .929 r
.29819 .47045 .30463 .47704 .31438 .47882 .30819 .46849 Mtetra
.807 .694 .74 r
.30819 .46849 .31438 .47882 .32505 .46665 .31898 .45483 Mtetra
.386 .475 .828 r
.31898 .45483 .32505 .46665 .33511 .46478 .32874 .45812 Mtetra
.628 .728 .919 r
.32874 .45812 .33511 .46478 .34527 .46181 .33891 .45541 Mtetra
.646 .743 .92 r
.33891 .45541 .34527 .46181 .35549 .45859 .34914 .45226 Mtetra
.652 .748 .92 r
.34914 .45226 .35549 .45859 .36576 .45526 .35943 .44895 Mtetra
.655 .75 .92 r
.35943 .44895 .36576 .45526 .37606 .45186 .36976 .44555 Mtetra
.657 .752 .92 r
.36976 .44555 .37606 .45186 .38641 .4484 .38013 .44208 Mtetra
.658 .753 .92 r
.38013 .44208 .38641 .4484 .3968 .4449 .39055 .43857 Mtetra
.659 .754 .92 r
.39055 .43857 .3968 .4449 .40723 .44137 .40101 .43503 Mtetra
.40101 .43503 .40723 .44137 .4177 .43784 .4115 .43146 Mtetra
.4115 .43146 .4177 .43784 .42821 .43429 .42204 .42789 Mtetra
.42204 .42789 .42821 .43429 .43876 .43074 .43261 .42431 Mtetra
.658 .753 .92 r
.43261 .42431 .43876 .43074 .44936 .42718 .44323 .42072 Mtetra
.44323 .42072 .44936 .42718 .45999 .42361 .45389 .41712 Mtetra
.45389 .41712 .45999 .42361 .47066 .42003 .46459 .41352 Mtetra
.46459 .41352 .47066 .42003 .48138 .41644 .47534 .4099 Mtetra
.47534 .4099 .48138 .41644 .49213 .41285 .48612 .40628 Mtetra
.48612 .40628 .49213 .41285 .50293 .40923 .49695 .40264 Mtetra
.49695 .40264 .50293 .40923 .51378 .40561 .50782 .39899 Mtetra
.657 .753 .92 r
.50782 .39899 .51378 .40561 .52466 .40198 .51873 .39533 Mtetra
.51873 .39533 .52466 .40198 .53559 .39833 .52969 .39165 Mtetra
.657 .752 .92 r
.52969 .39165 .53559 .39833 .54656 .39467 .54068 .38796 Mtetra
.54068 .38796 .54656 .39467 .55757 .39099 .55173 .38426 Mtetra
.55173 .38426 .55757 .39099 .56863 .38731 .56282 .38054 Mtetra
.56282 .38054 .56863 .38731 .57973 .3836 .57395 .37681 Mtetra
.57395 .37681 .57973 .3836 .59088 .37989 .58512 .37307 Mtetra
.58512 .37307 .59088 .37989 .60207 .37616 .59634 .36931 Mtetra
.59634 .36931 .60207 .37616 .6133 .37242 .60761 .36554 Mtetra
.60761 .36554 .6133 .37242 .62459 .36866 .61892 .36176 Mtetra
.61892 .36176 .62459 .36866 .63591 .36489 .63028 .35796 Mtetra
.63028 .35796 .63591 .36489 .64728 .3611 .64168 .35414 Mtetra
.64168 .35414 .64728 .3611 .6587 .3573 .65313 .35031 Mtetra
.65313 .35031 .6587 .3573 .67017 .35348 .66463 .34646 Mtetra
.66463 .34646 .67017 .35348 .68168 .34965 .67617 .3426 Mtetra
.67617 .3426 .68168 .34965 .69324 .3458 .68776 .33873 Mtetra
.68776 .33873 .69324 .3458 .70484 .34194 .6994 .33484 Mtetra
.6994 .33484 .70484 .34194 .71649 .33806 .71109 .33093 Mtetra
.71109 .33093 .71649 .33806 .72819 .33417 .72282 .32701 Mtetra
.72282 .32701 .72819 .33417 .73994 .33026 .7346 .32307 Mtetra
.7346 .32307 .73994 .33026 .75174 .32634 .74643 .31912 Mtetra
.74643 .31912 .75174 .32634 .76358 .3224 .75831 .31515 Mtetra
.75831 .31515 .76358 .3224 .77548 .31845 .77024 .31116 Mtetra
.77024 .31116 .77548 .31845 .78742 .31448 .78222 .30716 Mtetra
.78222 .30716 .78742 .31448 .79941 .31049 .79425 .30314 Mtetra
.79425 .30314 .79941 .31049 .81146 .30648 .80633 .29911 Mtetra
.80633 .29911 .81146 .30648 .82355 .30246 .81846 .29506 Mtetra
.611 .723 .925 r
.17326 .50274 .17999 .50912 .18949 .50737 .18282 .50053 Mtetra
.444 .643 .942 r
.18282 .50053 .18949 .50737 .20072 .48843 .19215 .50108 Mtetra
0 0 0 r
.19215 .50108 .20072 .48843 .2092 .49789 .20262 .49051 Mtetra
.567 .677 .913 r
.20262 .49051 .2092 .49789 .21886 .49569 .2122 .48927 Mtetra
.623 .728 .922 r
.2122 .48927 .21886 .49569 .22859 .49315 .22195 .48676 Mtetra
.621 .73 .924 r
.22195 .48676 .22859 .49315 .23832 .4911 .23173 .48429 Mtetra
.506 .674 .939 r
.23173 .48429 .23832 .4911 .25134 .45015 .24137 .48395 Mtetra
.347 .064 .333 r
.24137 .48395 .25134 .45015 .25836 .48135 .25189 .47362 Mtetra
.559 .665 .909 r
.25189 .47362 .25836 .48135 .26822 .47905 .26167 .47256 Mtetra
.63 .732 .921 r
.26167 .47256 .26822 .47905 .27817 .47621 .27162 .46985 Mtetra
.639 .74 .921 r
.27162 .46985 .27817 .47621 .28816 .47327 .28164 .46691 Mtetra
.639 .74 .922 r
.28164 .46691 .28816 .47327 .29819 .47045 .29169 .46397 Mtetra
.625 .733 .924 r
.29169 .46397 .29819 .47045 .30819 .46849 .30176 .46134 Mtetra
.358 .594 .935 r
.30176 .46134 .30819 .46849 .31898 .45483 .31159 .46308 Mtetra
.547 .827 .481 r
.31159 .46308 .31898 .45483 .32874 .45812 .32236 .45081 Mtetra
.595 .697 .914 r
.32236 .45081 .32874 .45812 .33891 .45541 .3325 .44888 Mtetra
.64 .738 .92 r
.3325 .44888 .33891 .45541 .34914 .45226 .34275 .44585 Mtetra
.649 .746 .92 r
.34275 .44585 .34914 .45226 .35943 .44895 .35306 .44258 Mtetra
.653 .749 .92 r
.35306 .44258 .35943 .44895 .36976 .44555 .36341 .43919 Mtetra
.656 .751 .92 r
.36341 .43919 .36976 .44555 .38013 .44208 .37381 .43572 Mtetra
.658 .753 .92 r
.37381 .43572 .38013 .44208 .39055 .43857 .38425 .43219 Mtetra
.659 .753 .92 r
.38425 .43219 .39055 .43857 .40101 .43503 .39473 .42863 Mtetra
.659 .754 .92 r
.39473 .42863 .40101 .43503 .4115 .43146 .40525 .42505 Mtetra
.40525 .42505 .4115 .43146 .42204 .42789 .41582 .42144 Mtetra
.41582 .42144 .42204 .42789 .43261 .42431 .42642 .41783 Mtetra
.659 .753 .92 r
.42642 .41783 .43261 .42431 .44323 .42072 .43707 .41422 Mtetra
.658 .753 .92 r
.43707 .41422 .44323 .42072 .45389 .41712 .44775 .41059 Mtetra
.44775 .41059 .45389 .41712 .46459 .41352 .45848 .40696 Mtetra
.45848 .40696 .46459 .41352 .47534 .4099 .46925 .40331 Mtetra
.46925 .40331 .47534 .4099 .48612 .40628 .48006 .39966 Mtetra
.48006 .39966 .48612 .40628 .49695 .40264 .49092 .39599 Mtetra
.49092 .39599 .49695 .40264 .50782 .39899 .50181 .39232 Mtetra
.657 .753 .92 r
.50181 .39232 .50782 .39899 .51873 .39533 .51276 .38863 Mtetra
.51276 .38863 .51873 .39533 .52969 .39165 .52374 .38492 Mtetra
.52374 .38492 .52969 .39165 .54068 .38796 .53477 .38121 Mtetra
.657 .752 .92 r
.53477 .38121 .54068 .38796 .55173 .38426 .54584 .37748 Mtetra
.54584 .37748 .55173 .38426 .56282 .38054 .55696 .37373 Mtetra
.55696 .37373 .56282 .38054 .57395 .37681 .56812 .36998 Mtetra
.56812 .36998 .57395 .37681 .58512 .37307 .57933 .3662 Mtetra
.57933 .3662 .58512 .37307 .59634 .36931 .59058 .36242 Mtetra
.59058 .36242 .59634 .36931 .60761 .36554 .60187 .35862 Mtetra
.60187 .35862 .60761 .36554 .61892 .36176 .61322 .3548 Mtetra
.61322 .3548 .61892 .36176 .63028 .35796 .62461 .35097 Mtetra
.62461 .35097 .63028 .35796 .64168 .35414 .63604 .34713 Mtetra
.63604 .34713 .64168 .35414 .65313 .35031 .64752 .34327 Mtetra
.64752 .34327 .65313 .35031 .66463 .34646 .65905 .3394 Mtetra
.65905 .3394 .66463 .34646 .67617 .3426 .67063 .33551 Mtetra
.67063 .33551 .67617 .3426 .68776 .33873 .68225 .3316 Mtetra
.68225 .3316 .68776 .33873 .6994 .33484 .69392 .32768 Mtetra
.69392 .32768 .6994 .33484 .71109 .33093 .70564 .32374 Mtetra
.70564 .32374 .71109 .33093 .72282 .32701 .71741 .31979 Mtetra
.71741 .31979 .72282 .32701 .7346 .32307 .72922 .31582 Mtetra
.72922 .31582 .7346 .32307 .74643 .31912 .74109 .31184 Mtetra
.74109 .31184 .74643 .31912 .75831 .31515 .753 .30784 Mtetra
.753 .30784 .75831 .31515 .77024 .31116 .76497 .30382 Mtetra
.76497 .30382 .77024 .31116 .78222 .30716 .77698 .29979 Mtetra
.77698 .29979 .78222 .30716 .79425 .30314 .78904 .29574 Mtetra
.78904 .29574 .79425 .30314 .80633 .29911 .80116 .29168 Mtetra
.80116 .29168 .80633 .29911 .81846 .29506 .81332 .28759 Mtetra
.613 .722 .923 r
.16649 .49626 .17326 .50274 .18282 .50053 .17607 .494 Mtetra
.589 .713 .93 r
.17607 .494 .18282 .50053 .19215 .50108 .18565 .49221 Mtetra
.849 .712 .711 r
.18565 .49221 .19215 .50108 .20262 .49051 .19699 .47315 Mtetra
.147 .23 .693 r
.19699 .47315 .20262 .49051 .2122 .48927 .20552 .4826 Mtetra
.611 .718 .921 r
.20552 .4826 .2122 .48927 .22195 .48676 .21526 .48034 Mtetra
.626 .731 .923 r
.21526 .48034 .22195 .48676 .23173 .48429 .22507 .47775 Mtetra
.602 .72 .928 r
.22507 .47775 .23173 .48429 .24137 .48395 .23488 .47565 Mtetra
.907 .716 .632 r
.23488 .47565 .24137 .48395 .25189 .47362 .24805 .43449 Mtetra
0 0 .439 r
.24805 .43449 .25189 .47362 .26167 .47256 .25509 .46577 Mtetra
.614 .718 .919 r
.25509 .46577 .26167 .47256 .27162 .46985 .26504 .46341 Mtetra
.636 .737 .921 r
.26504 .46341 .27162 .46985 .28164 .46691 .27506 .46051 Mtetra
.64 .74 .922 r
.27506 .46051 .28164 .46691 .29169 .46397 .28514 .45752 Mtetra
.635 .738 .923 r
.28514 .45752 .29169 .46397 .30176 .46134 .29525 .45463 Mtetra
.594 .717 .929 r
.29525 .45463 .30176 .46134 .31159 .46308 .30534 .45262 Mtetra
.808 .694 .74 r
.30534 .45262 .31159 .46308 .32236 .45081 .31623 .43886 Mtetra
.384 .474 .829 r
.31623 .43886 .32236 .45081 .3325 .44888 .32606 .44211 Mtetra
.628 .728 .919 r
.32606 .44211 .3325 .44888 .34275 .44585 .33632 .43935 Mtetra
.646 .743 .92 r
.33632 .43935 .34275 .44585 .35306 .44258 .34665 .43613 Mtetra
.652 .748 .92 r
.34665 .43613 .35306 .44258 .36341 .43919 .35702 .43276 Mtetra
.655 .75 .92 r
.35702 .43276 .36341 .43919 .37381 .43572 .36744 .4293 Mtetra
.657 .752 .92 r
.36744 .4293 .37381 .43572 .38425 .43219 .37791 .42577 Mtetra
.658 .753 .92 r
.37791 .42577 .38425 .43219 .39473 .42863 .38841 .42219 Mtetra
.659 .754 .92 r
.38841 .42219 .39473 .42863 .40525 .42505 .39896 .41858 Mtetra
.39896 .41858 .40525 .42505 .41582 .42144 .40955 .41495 Mtetra
.40955 .41495 .41582 .42144 .42642 .41783 .42018 .41131 Mtetra
.42018 .41131 .42642 .41783 .43707 .41422 .43085 .40767 Mtetra
.658 .753 .92 r
.43085 .40767 .43707 .41422 .44775 .41059 .44157 .40401 Mtetra
.44157 .40401 .44775 .41059 .45848 .40696 .45232 .40035 Mtetra
.45232 .40035 .45848 .40696 .46925 .40331 .46312 .39668 Mtetra
.46312 .39668 .46925 .40331 .48006 .39966 .47396 .39299 Mtetra
.47396 .39299 .48006 .39966 .49092 .39599 .48484 .3893 Mtetra
.48484 .3893 .49092 .39599 .50181 .39232 .49577 .3856 Mtetra
.49577 .3856 .50181 .39232 .51276 .38863 .50674 .38188 Mtetra
.657 .753 .92 r
.50674 .38188 .51276 .38863 .52374 .38492 .51775 .37815 Mtetra
.51775 .37815 .52374 .38492 .53477 .38121 .52881 .3744 Mtetra
.657 .752 .92 r
.52881 .3744 .53477 .38121 .54584 .37748 .53991 .37064 Mtetra
.53991 .37064 .54584 .37748 .55696 .37373 .55106 .36687 Mtetra
.55106 .36687 .55696 .37373 .56812 .36998 .56225 .36309 Mtetra
.56225 .36309 .56812 .36998 .57933 .3662 .57348 .35929 Mtetra
.57348 .35929 .57933 .3662 .59058 .36242 .58477 .35547 Mtetra
.58477 .35547 .59058 .36242 .60187 .35862 .59609 .35164 Mtetra
.59609 .35164 .60187 .35862 .61322 .3548 .60747 .3478 Mtetra
.60747 .3478 .61322 .3548 .62461 .35097 .61889 .34394 Mtetra
.61889 .34394 .62461 .35097 .63604 .34713 .63035 .34007 Mtetra
.63035 .34007 .63604 .34713 .64752 .34327 .64187 .33618 Mtetra
.64187 .33618 .64752 .34327 .65905 .3394 .65343 .33227 Mtetra
.65343 .33227 .65905 .3394 .67063 .33551 .66504 .32835 Mtetra
.66504 .32835 .67063 .33551 .68225 .3316 .67669 .32442 Mtetra
.67669 .32442 .68225 .3316 .69392 .32768 .6884 .32047 Mtetra
.6884 .32047 .69392 .32768 .70564 .32374 .70015 .3165 Mtetra
.70015 .3165 .70564 .32374 .71741 .31979 .71195 .31252 Mtetra
.71195 .31252 .71741 .31979 .72922 .31582 .7238 .30852 Mtetra
.7238 .30852 .72922 .31582 .74109 .31184 .7357 .30451 Mtetra
.7357 .30451 .74109 .31184 .753 .30784 .74765 .30047 Mtetra
.74765 .30047 .753 .30784 .76497 .30382 .75965 .29643 Mtetra
.75965 .29643 .76497 .30382 .77698 .29979 .7717 .29236 Mtetra
.7717 .29236 .77698 .29979 .78904 .29574 .7838 .28828 Mtetra
.7838 .28828 .78904 .29574 .80116 .29168 .79595 .28418 Mtetra
.79595 .28418 .80116 .29168 .81332 .28759 .80815 .28007 Mtetra
.598 .708 .921 r
.1597 .48946 .16649 .49626 .17607 .494 .16927 .48752 Mtetra
.611 .723 .925 r
.16927 .48752 .17607 .494 .18565 .49221 .17891 .48526 Mtetra
.444 .643 .942 r
.17891 .48526 .18565 .49221 .19699 .47315 .18831 .48576 Mtetra
0 0 0 r
.18831 .48576 .19699 .47315 .20552 .4826 .19887 .47511 Mtetra
.567 .677 .914 r
.19887 .47511 .20552 .4826 .21526 .48034 .20853 .47382 Mtetra
.623 .728 .922 r
.20853 .47382 .21526 .48034 .22507 .47775 .21836 .47125 Mtetra
.621 .73 .924 r
.21836 .47125 .22507 .47775 .23488 .47565 .22822 .46873 Mtetra
.507 .674 .939 r
.22822 .46873 .23488 .47565 .24805 .43449 .23794 .46833 Mtetra
.34 .054 .326 r
.23794 .46833 .24805 .43449 .25509 .46577 .24855 .45792 Mtetra
.558 .665 .909 r
.24855 .45792 .25509 .46577 .26504 .46341 .25841 .45681 Mtetra
.63 .732 .921 r
.25841 .45681 .26504 .46341 .27506 .46051 .26845 .45404 Mtetra
.639 .74 .921 r
.26845 .45404 .27506 .46051 .28514 .45752 .27854 .45104 Mtetra
.639 .74 .922 r
.27854 .45104 .28514 .45752 .29525 .45463 .28868 .44804 Mtetra
.625 .733 .924 r
.28868 .44804 .29525 .45463 .30534 .45262 .29884 .44535 Mtetra
.359 .594 .935 r
.29884 .44535 .30534 .45262 .31623 .43886 .30875 .44706 Mtetra
.559 .837 .493 r
.30875 .44706 .31623 .43886 .32606 .44211 .31962 .43469 Mtetra
.595 .697 .914 r
.31962 .43469 .32606 .44211 .33632 .43935 .32985 .4327 Mtetra
.64 .738 .92 r
.32985 .4327 .33632 .43935 .34665 .43613 .34019 .42961 Mtetra
.649 .746 .92 r
.34019 .42961 .34665 .43613 .35702 .43276 .35058 .42627 Mtetra
.653 .749 .92 r
.35058 .42627 .35702 .43276 .36744 .4293 .36103 .42281 Mtetra
.656 .751 .92 r
.36103 .42281 .36744 .4293 .37791 .42577 .37152 .41928 Mtetra
.658 .753 .92 r
.37152 .41928 .37791 .42577 .38841 .42219 .38205 .41569 Mtetra
.659 .753 .92 r
.38205 .41569 .38841 .42219 .39896 .41858 .39262 .41207 Mtetra
.659 .754 .92 r
.39262 .41207 .39896 .41858 .40955 .41495 .40324 .40842 Mtetra
.40324 .40842 .40955 .41495 .42018 .41131 .4139 .40475 Mtetra
.4139 .40475 .42018 .41131 .43085 .40767 .42459 .40107 Mtetra
.659 .753 .92 r
.42459 .40107 .43085 .40767 .44157 .40401 .43533 .39739 Mtetra
.658 .753 .92 r
.43533 .39739 .44157 .40401 .45232 .40035 .44612 .39369 Mtetra
.44612 .39369 .45232 .40035 .46312 .39668 .45694 .38999 Mtetra
.45694 .38999 .46312 .39668 .47396 .39299 .46781 .38628 Mtetra
.46781 .38628 .47396 .39299 .48484 .3893 .47872 .38256 Mtetra
.47872 .38256 .48484 .3893 .49577 .3856 .48968 .37882 Mtetra
.48968 .37882 .49577 .3856 .50674 .38188 .50067 .37508 Mtetra
.657 .753 .92 r
.50067 .37508 .50674 .38188 .51775 .37815 .51172 .37132 Mtetra
.51172 .37132 .51775 .37815 .52881 .3744 .5228 .36755 Mtetra
.5228 .36755 .52881 .3744 .53991 .37064 .53393 .36376 Mtetra
.657 .752 .92 r
.53393 .36376 .53991 .37064 .55106 .36687 .54511 .35996 Mtetra
.54511 .35996 .55106 .36687 .56225 .36309 .55633 .35614 Mtetra
.55633 .35614 .56225 .36309 .57348 .35929 .5676 .35231 Mtetra
.5676 .35231 .57348 .35929 .58477 .35547 .57891 .34847 Mtetra
.57891 .34847 .58477 .35547 .59609 .35164 .59027 .34461 Mtetra
.59027 .34461 .59609 .35164 .60747 .3478 .60167 .34074 Mtetra
.60167 .34074 .60747 .3478 .61889 .34394 .61313 .33685 Mtetra
.61313 .33685 .61889 .34394 .63035 .34007 .62463 .33295 Mtetra
.62463 .33295 .63035 .34007 .64187 .33618 .63617 .32903 Mtetra
.63617 .32903 .64187 .33618 .65343 .33227 .64776 .3251 Mtetra
.64776 .3251 .65343 .33227 .66504 .32835 .6594 .32115 Mtetra
.6594 .32115 .66504 .32835 .67669 .32442 .67109 .31718 Mtetra
.67109 .31718 .67669 .32442 .6884 .32047 .68283 .3132 Mtetra
.68283 .3132 .6884 .32047 .70015 .3165 .69462 .3092 Mtetra
.69462 .3092 .70015 .3165 .71195 .31252 .70645 .30519 Mtetra
.70645 .30519 .71195 .31252 .7238 .30852 .71834 .30116 Mtetra
.71834 .30116 .7238 .30852 .7357 .30451 .73027 .29711 Mtetra
.73027 .29711 .7357 .30451 .74765 .30047 .74226 .29305 Mtetra
.74226 .29305 .74765 .30047 .75965 .29643 .75429 .28897 Mtetra
.75429 .28897 .75965 .29643 .7717 .29236 .76638 .28488 Mtetra
.76638 .28488 .7717 .29236 .7838 .28828 .77851 .28076 Mtetra
.77851 .28076 .7838 .28828 .79595 .28418 .7907 .27663 Mtetra
.7907 .27663 .79595 .28418 .80815 .28007 .80294 .27249 Mtetra
.527 .642 .906 r
.15301 .48139 .1597 .48946 .16927 .48752 .16243 .48093 Mtetra
.613 .722 .923 r
.16243 .48093 .16927 .48752 .17891 .48526 .17209 .47862 Mtetra
.589 .713 .93 r
.17209 .47862 .17891 .48526 .18831 .48576 .18174 .47677 Mtetra
.85 .713 .711 r
.18174 .47677 .18831 .48576 .19887 .47511 .1932 .45759 Mtetra
.144 .228 .693 r
.1932 .45759 .19887 .47511 .20853 .47382 .20178 .46703 Mtetra
.611 .718 .921 r
.20178 .46703 .20853 .47382 .21836 .47125 .2116 .46472 Mtetra
.626 .731 .923 r
.2116 .46472 .21836 .47125 .22822 .46873 .22149 .46207 Mtetra
.602 .72 .928 r
.22149 .46207 .22822 .46873 .23794 .46833 .23138 .45992 Mtetra
.908 .716 .631 r
.23138 .45992 .23794 .46833 .24855 .45792 .2447 .41854 Mtetra
0 0 .435 r
.2447 .41854 .24855 .45792 .25841 .45681 .25176 .4499 Mtetra
.614 .718 .919 r
.25176 .4499 .25841 .45681 .26845 .45404 .26179 .44748 Mtetra
.636 .737 .921 r
.26179 .44748 .26845 .45404 .27854 .45104 .2719 .44453 Mtetra
.64 .74 .922 r
.2719 .44453 .27854 .45104 .28868 .44804 .28206 .44147 Mtetra
.635 .738 .923 r
.28206 .44147 .28868 .44804 .29884 .44535 .29226 .43853 Mtetra
.595 .717 .929 r
.29226 .43853 .29884 .44535 .30875 .44706 .30244 .43646 Mtetra
.808 .695 .74 r
.30244 .43646 .30875 .44706 .31962 .43469 .31343 .42259 Mtetra
.383 .474 .829 r
.31343 .42259 .31962 .43469 .32985 .4327 .32334 .42581 Mtetra
.628 .728 .919 r
.32334 .42581 .32985 .4327 .34019 .42961 .33369 .42298 Mtetra
.646 .743 .92 r
.33369 .42298 .34019 .42961 .35058 .42627 .3441 .41971 Mtetra
.652 .748 .92 r
.3441 .41971 .35058 .42627 .36103 .42281 .35457 .41627 Mtetra
.655 .75 .92 r
.35457 .41627 .36103 .42281 .37152 .41928 .36508 .41274 Mtetra
.657 .752 .92 r
.36508 .41274 .37152 .41928 .38205 .41569 .37564 .40915 Mtetra
.658 .753 .92 r
.37564 .40915 .38205 .41569 .39262 .41207 .38624 .4055 Mtetra
.659 .754 .92 r
.38624 .4055 .39262 .41207 .40324 .40842 .39688 .40183 Mtetra
.39688 .40183 .40324 .40842 .4139 .40475 .40756 .39813 Mtetra
.40756 .39813 .4139 .40475 .42459 .40107 .41829 .39443 Mtetra
.41829 .39443 .42459 .40107 .43533 .39739 .42906 .39071 Mtetra
.658 .753 .92 r
.42906 .39071 .43533 .39739 .44612 .39369 .43987 .38699 Mtetra
.43987 .38699 .44612 .39369 .45694 .38999 .45072 .38326 Mtetra
.45072 .38326 .45694 .38999 .46781 .38628 .46162 .37952 Mtetra
.46162 .37952 .46781 .38628 .47872 .38256 .47256 .37577 Mtetra
.47256 .37577 .47872 .38256 .48968 .37882 .48354 .372 Mtetra
.48354 .372 .48968 .37882 .50067 .37508 .49457 .36823 Mtetra
.49457 .36823 .50067 .37508 .51172 .37132 .50564 .36444 Mtetra
.657 .753 .92 r
.50564 .36444 .51172 .37132 .5228 .36755 .51675 .36064 Mtetra
.51675 .36064 .5228 .36755 .53393 .36376 .52791 .35682 Mtetra
.657 .752 .92 r
.52791 .35682 .53393 .36376 .54511 .35996 .53912 .35299 Mtetra
.53912 .35299 .54511 .35996 .55633 .35614 .55037 .34915 Mtetra
.55037 .34915 .55633 .35614 .5676 .35231 .56167 .34529 Mtetra
.56167 .34529 .5676 .35231 .57891 .34847 .57301 .34142 Mtetra
.57301 .34142 .57891 .34847 .59027 .34461 .5844 .33753 Mtetra
.5844 .33753 .59027 .34461 .60167 .34074 .59584 .33363 Mtetra
.59584 .33363 .60167 .34074 .61313 .33685 .60732 .32971 Mtetra
.60732 .32971 .61313 .33685 .62463 .33295 .61885 .32578 Mtetra
.61885 .32578 .62463 .33295 .63617 .32903 .63043 .32183 Mtetra
.63043 .32183 .63617 .32903 .64776 .3251 .64206 .31786 Mtetra
.64206 .31786 .64776 .3251 .6594 .32115 .65373 .31388 Mtetra
.65373 .31388 .6594 .32115 .67109 .31718 .66545 .30989 Mtetra
.66545 .30989 .67109 .31718 .68283 .3132 .67722 .30588 Mtetra
.67722 .30588 .68283 .3132 .69462 .3092 .68904 .30185 Mtetra
.68904 .30185 .69462 .3092 .70645 .30519 .70091 .2978 Mtetra
.70091 .2978 .70645 .30519 .71834 .30116 .71283 .29374 Mtetra
.71283 .29374 .71834 .30116 .73027 .29711 .7248 .28967 Mtetra
.7248 .28967 .73027 .29711 .74226 .29305 .73682 .28557 Mtetra
.73682 .28557 .74226 .29305 .75429 .28897 .74889 .28146 Mtetra
.74889 .28146 .75429 .28897 .76638 .28488 .76101 .27733 Mtetra
.76101 .27733 .76638 .28488 .77851 .28076 .77318 .27319 Mtetra
.77318 .27319 .77851 .28076 .7907 .27663 .78541 .26903 Mtetra
.78541 .26903 .7907 .27663 .80294 .27249 .79768 .26485 Mtetra
0 0 0 r
.13214 .59641 .15301 .48139 .16243 .48093 .15557 .47403 Mtetra
.598 .708 .921 r
.15557 .47403 .16243 .48093 .17209 .47862 .16521 .47202 Mtetra
.611 .723 .925 r
.16521 .47202 .17209 .47862 .18174 .47677 .17493 .46971 Mtetra
.445 .643 .942 r
.17493 .46971 .18174 .47677 .1932 .45759 .1844 .47017 Mtetra
0 0 0 r
.1844 .47017 .1932 .45759 .20178 .46703 .19506 .45943 Mtetra
.567 .677 .914 r
.19506 .45943 .20178 .46703 .2116 .46472 .2048 .45808 Mtetra
.623 .728 .922 r
.2048 .45808 .2116 .46472 .22149 .46207 .2147 .45546 Mtetra
.621 .73 .924 r
.2147 .45546 .22149 .46207 .23138 .45992 .22465 .45288 Mtetra
.507 .673 .939 r
.22465 .45288 .23138 .45992 .2447 .41854 .23444 .45244 Mtetra
.332 .045 .318 r
.23444 .45244 .2447 .41854 .25176 .4499 .24516 .44193 Mtetra
.558 .665 .909 r
.24516 .44193 .25176 .4499 .26179 .44748 .25509 .44077 Mtetra
.63 .732 .921 r
.25509 .44077 .26179 .44748 .2719 .44453 .26522 .43795 Mtetra
.639 .74 .921 r
.26522 .43795 .2719 .44453 .28206 .44147 .2754 .43488 Mtetra
.639 .74 .922 r
.2754 .43488 .28206 .44147 .29226 .43853 .28562 .43182 Mtetra
.625 .733 .924 r
.28562 .43182 .29226 .43853 .30244 .43646 .29587 .42907 Mtetra
.36 .594 .935 r
.29587 .42907 .30244 .43646 .31343 .42259 .30586 .43073 Mtetra
.571 .846 .505 r
.30586 .43073 .31343 .42259 .32334 .42581 .31683 .41826 Mtetra
.595 .697 .914 r
.31683 .41826 .32334 .42581 .33369 .42298 .32714 .41622 Mtetra
.64 .739 .92 r
.32714 .41622 .33369 .42298 .3441 .41971 .33758 .41306 Mtetra
.649 .746 .92 r
.33758 .41306 .3441 .41971 .35457 .41627 .34806 .40966 Mtetra
.653 .749 .92 r
.34806 .40966 .35457 .41627 .36508 .41274 .3586 .40614 Mtetra
.656 .751 .92 r
.3586 .40614 .36508 .41274 .37564 .40915 .36918 .40254 Mtetra
.658 .753 .92 r
.36918 .40254 .37564 .40915 .38624 .4055 .37981 .39889 Mtetra
.659 .753 .92 r
.37981 .39889 .38624 .4055 .39688 .40183 .39047 .39519 Mtetra
.659 .754 .92 r
.39047 .39519 .39688 .40183 .40756 .39813 .40118 .39147 Mtetra
.40118 .39147 .40756 .39813 .41829 .39443 .41194 .38774 Mtetra
.41194 .38774 .41829 .39443 .42906 .39071 .42273 .38399 Mtetra
.659 .753 .92 r
.42273 .38399 .42906 .39071 .43987 .38699 .43357 .38024 Mtetra
.658 .753 .92 r
.43357 .38024 .43987 .38699 .45072 .38326 .44445 .37648 Mtetra
.44445 .37648 .45072 .38326 .46162 .37952 .45538 .37271 Mtetra
.45538 .37271 .46162 .37952 .47256 .37577 .46634 .36893 Mtetra
.46634 .36893 .47256 .37577 .48354 .372 .47736 .36513 Mtetra
.47736 .36513 .48354 .372 .49457 .36823 .48841 .36133 Mtetra
.48841 .36133 .49457 .36823 .50564 .36444 .49951 .35751 Mtetra
.657 .753 .92 r
.49951 .35751 .50564 .36444 .51675 .36064 .51066 .35368 Mtetra
.51066 .35368 .51675 .36064 .52791 .35682 .52185 .34983 Mtetra
.52185 .34983 .52791 .35682 .53912 .35299 .53308 .34598 Mtetra
.657 .752 .92 r
.53308 .34598 .53912 .35299 .55037 .34915 .54437 .3421 Mtetra
.54437 .3421 .55037 .34915 .56167 .34529 .55569 .33821 Mtetra
.55569 .33821 .56167 .34529 .57301 .34142 .56707 .33431 Mtetra
.56707 .33431 .57301 .34142 .5844 .33753 .57849 .33039 Mtetra
.57849 .33039 .5844 .33753 .59584 .33363 .58996 .32646 Mtetra
.58996 .32646 .59584 .33363 .60732 .32971 .60147 .32251 Mtetra
.60147 .32251 .60732 .32971 .61885 .32578 .61303 .31855 Mtetra
.61303 .31855 .61885 .32578 .63043 .32183 .62465 .31457 Mtetra
.62465 .31457 .63043 .32183 .64206 .31786 .6363 .31058 Mtetra
.6363 .31058 .64206 .31786 .65373 .31388 .64801 .30657 Mtetra
.64801 .30657 .65373 .31388 .66545 .30989 .65977 .30254 Mtetra
.65977 .30254 .66545 .30989 .67722 .30588 .67157 .2985 Mtetra
.67157 .2985 .67722 .30588 .68904 .30185 .68343 .29444 Mtetra
.68343 .29444 .68904 .30185 .70091 .2978 .69533 .29036 Mtetra
.69533 .29036 .70091 .2978 .71283 .29374 .70728 .28627 Mtetra
.70728 .28627 .71283 .29374 .7248 .28967 .71929 .28216 Mtetra
.71929 .28216 .7248 .28967 .73682 .28557 .73134 .27803 Mtetra
.73134 .27803 .73682 .28557 .74889 .28146 .74345 .27389 Mtetra
.74345 .27389 .74889 .28146 .76101 .27733 .7556 .26973 Mtetra
.7556 .26973 .76101 .27733 .77318 .27319 .76781 .26555 Mtetra
.76781 .26555 .77318 .27319 .78541 .26903 .78007 .26136 Mtetra
.78007 .26136 .78541 .26903 .79768 .26485 .79239 .25714 Mtetra
.567 .357 .555 r
.13825 .47597 .13214 .59641 .15557 .47403 .14881 .46583 Mtetra
.527 .642 .907 r
.14881 .46583 .15557 .47403 .16521 .47202 .15829 .46533 Mtetra
.613 .722 .923 r
.15829 .46533 .16521 .47202 .17493 .46971 .16803 .46296 Mtetra
.589 .713 .929 r
.16803 .46296 .17493 .46971 .1844 .47017 .17776 .46106 Mtetra
.851 .714 .711 r
.17776 .46106 .1844 .47017 .19506 .45943 .18933 .44175 Mtetra
.14 .225 .692 r
.18933 .44175 .19506 .45943 .2048 .45808 .19797 .45118 Mtetra
.611 .718 .921 r
.19797 .45118 .2048 .45808 .2147 .45546 .20787 .44882 Mtetra
.626 .731 .923 r
.20787 .44882 .2147 .45546 .22465 .45288 .21784 .44611 Mtetra
.602 .72 .928 r
.21784 .44611 .22465 .45288 .23444 .45244 .22781 .4439 Mtetra
.909 .717 .631 r
.22781 .4439 .23444 .45244 .24516 .44193 .24129 .4023 Mtetra
0 0 .431 r
.24129 .4023 .24516 .44193 .25509 .44077 .24837 .43374 Mtetra
.614 .718 .919 r
.24837 .43374 .25509 .44077 .26522 .43795 .25849 .43127 Mtetra
.636 .737 .921 r
.25849 .43127 .26522 .43795 .2754 .43488 .26868 .42825 Mtetra
.64 .74 .922 r
.26868 .42825 .2754 .43488 .28562 .43182 .27893 .42513 Mtetra
.635 .738 .923 r
.27893 .42513 .28562 .43182 .29587 .42907 .28922 .42213 Mtetra
.595 .717 .929 r
.28922 .42213 .29587 .42907 .30586 .43073 .29948 .42001 Mtetra
.809 .696 .74 r
.29948 .42001 .30586 .43073 .31683 .41826 .31058 .40602 Mtetra
.382 .473 .829 r
.31058 .40602 .31683 .41826 .32714 .41622 .32057 .4092 Mtetra
.628 .728 .919 r
.32057 .4092 .32714 .41622 .33758 .41306 .331 .40632 Mtetra
.646 .743 .92 r
.331 .40632 .33758 .41306 .34806 .40966 .34151 .40298 Mtetra
.652 .748 .92 r
.34151 .40298 .34806 .40966 .3586 .40614 .35207 .39947 Mtetra
.655 .75 .92 r
.35207 .39947 .3586 .40614 .36918 .40254 .36268 .39588 Mtetra
.657 .752 .92 r
.36268 .39588 .36918 .40254 .37981 .39889 .37333 .39221 Mtetra
.658 .753 .92 r
.37333 .39221 .37981 .39889 .39047 .39519 .38402 .3885 Mtetra
.659 .754 .92 r
.38402 .3885 .39047 .39519 .40118 .39147 .39476 .38476 Mtetra
.39476 .38476 .40118 .39147 .41194 .38774 .40554 .381 Mtetra
.40554 .381 .41194 .38774 .42273 .38399 .41636 .37722 Mtetra
.41636 .37722 .42273 .38399 .43357 .38024 .42723 .37344 Mtetra
.658 .753 .92 r
.42723 .37344 .43357 .38024 .44445 .37648 .43814 .36965 Mtetra
.43814 .36965 .44445 .37648 .45538 .37271 .44909 .36585 Mtetra
.44909 .36585 .45538 .37271 .46634 .36893 .46009 .36203 Mtetra
.46009 .36203 .46634 .36893 .47736 .36513 .47113 .35821 Mtetra
.47113 .35821 .47736 .36513 .48841 .36133 .48221 .35438 Mtetra
.48221 .35438 .48841 .36133 .49951 .35751 .49334 .35053 Mtetra
.49334 .35053 .49951 .35751 .51066 .35368 .50452 .34667 Mtetra
.657 .753 .92 r
.50452 .34667 .51066 .35368 .52185 .34983 .51574 .34279 Mtetra
.51574 .34279 .52185 .34983 .53308 .34598 .527 .33891 Mtetra
.657 .752 .92 r
.527 .33891 .53308 .34598 .54437 .3421 .53832 .335 Mtetra
.53832 .335 .54437 .3421 .55569 .33821 .54967 .33109 Mtetra
.54967 .33109 .55569 .33821 .56707 .33431 .56108 .32715 Mtetra
.56108 .32715 .56707 .33431 .57849 .33039 .57253 .3232 Mtetra
.57253 .3232 .57849 .33039 .58996 .32646 .58403 .31924 Mtetra
.58403 .31924 .58996 .32646 .60147 .32251 .59558 .31526 Mtetra
.59558 .31526 .60147 .32251 .61303 .31855 .60717 .31127 Mtetra
.60717 .31127 .61303 .31855 .62465 .31457 .61882 .30726 Mtetra
.61882 .30726 .62465 .31457 .6363 .31058 .63051 .30323 Mtetra
.63051 .30323 .6363 .31058 .64801 .30657 .64225 .29919 Mtetra
.64225 .29919 .64801 .30657 .65977 .30254 .65404 .29513 Mtetra
.65404 .29513 .65977 .30254 .67157 .2985 .66588 .29106 Mtetra
.66588 .29106 .67157 .2985 .68343 .29444 .67776 .28697 Mtetra
.67776 .28697 .68343 .29444 .69533 .29036 .6897 .28286 Mtetra
.6897 .28286 .69533 .29036 .70728 .28627 .70169 .27873 Mtetra
.70169 .27873 .70728 .28627 .71929 .28216 .71373 .27459 Mtetra
.71373 .27459 .71929 .28216 .73134 .27803 .72582 .27043 Mtetra
.72582 .27043 .73134 .27803 .74345 .27389 .73796 .26626 Mtetra
.73796 .26626 .74345 .27389 .7556 .26973 .75016 .26207 Mtetra
.75016 .26207 .7556 .26973 .76781 .26555 .7624 .25785 Mtetra
.7624 .25785 .76781 .26555 .78007 .26136 .7747 .25363 Mtetra
.7747 .25363 .78007 .26136 .79239 .25714 .78705 .24938 Mtetra
.945 .665 .477 r
.1314 .4679 .13825 .47597 .14881 .46583 .12757 .58129 Mtetra
0 0 0 r
.12757 .58129 .14881 .46583 .15829 .46533 .15136 .45831 Mtetra
.598 .708 .921 r
.15136 .45831 .15829 .46533 .16803 .46296 .16108 .45625 Mtetra
.611 .723 .925 r
.16108 .45625 .16803 .46296 .17776 .46106 .17088 .45388 Mtetra
.446 .643 .942 r
.17088 .45388 .17776 .46106 .18933 .44175 .18042 .4543 Mtetra
0 0 0 r
.18042 .4543 .18933 .44175 .19797 .45118 .19118 .44346 Mtetra
.567 .677 .914 r
.19118 .44346 .19797 .45118 .20787 .44882 .20099 .44206 Mtetra
.623 .728 .922 r
.20099 .44206 .20787 .44882 .21784 .44611 .21098 .43939 Mtetra
.621 .73 .924 r
.21098 .43939 .21784 .44611 .22781 .4439 .22101 .43674 Mtetra
.507 .673 .939 r
.22101 .43674 .22781 .4439 .24129 .4023 .23088 .43625 Mtetra
.324 .035 .31 r
.23088 .43625 .24129 .4023 .24837 .43374 .2417 .42565 Mtetra
.558 .666 .909 r
.2417 .42565 .24837 .43374 .25849 .43127 .25172 .42444 Mtetra
.63 .732 .921 r
.25172 .42444 .25849 .43127 .26868 .42825 .26192 .42155 Mtetra
.639 .74 .921 r
.26192 .42155 .26868 .42825 .27893 .42513 .27219 .41843 Mtetra
.639 .74 .922 r
.27219 .41843 .27893 .42513 .28922 .42213 .28251 .4153 Mtetra
.625 .733 .924 r
.28251 .4153 .28922 .42213 .29948 .42001 .29284 .41249 Mtetra
.362 .595 .935 r
.29284 .41249 .29948 .42001 .31058 .40602 .30291 .41411 Mtetra
.582 .855 .517 r
.30291 .41411 .31058 .40602 .32057 .4092 .31398 .40153 Mtetra
.595 .697 .914 r
.31398 .40153 .32057 .4092 .331 .40632 .32439 .39943 Mtetra
.64 .739 .92 r
.32439 .39943 .331 .40632 .34151 .40298 .33491 .39621 Mtetra
.649 .746 .92 r
.33491 .39621 .34151 .40298 .35207 .39947 .34549 .39274 Mtetra
.653 .749 .92 r
.34549 .39274 .35207 .39947 .36268 .39588 .35612 .38915 Mtetra
.656 .751 .92 r
.35612 .38915 .36268 .39588 .37333 .39221 .3668 .38549 Mtetra
.658 .753 .92 r
.3668 .38549 .37333 .39221 .38402 .3885 .37752 .38176 Mtetra
.659 .753 .92 r
.37752 .38176 .38402 .3885 .39476 .38476 .38828 .378 Mtetra
.659 .754 .92 r
.38828 .378 .39476 .38476 .40554 .381 .39909 .37421 Mtetra
.39909 .37421 .40554 .381 .41636 .37722 .40994 .3704 Mtetra
.40994 .3704 .41636 .37722 .42723 .37344 .42084 .36659 Mtetra
.659 .753 .92 r
.42084 .36659 .42723 .37344 .43814 .36965 .43177 .36277 Mtetra
.658 .753 .92 r
.43177 .36277 .43814 .36965 .44909 .36585 .44275 .35893 Mtetra
.44275 .35893 .44909 .36585 .46009 .36203 .45378 .35509 Mtetra
.45378 .35509 .46009 .36203 .47113 .35821 .46485 .35124 Mtetra
.46485 .35124 .47113 .35821 .48221 .35438 .47596 .34737 Mtetra
.47596 .34737 .48221 .35438 .49334 .35053 .48712 .3435 Mtetra
.48712 .3435 .49334 .35053 .50452 .34667 .49833 .33961 Mtetra
.657 .753 .92 r
.49833 .33961 .50452 .34667 .51574 .34279 .50958 .3357 Mtetra
.50958 .3357 .51574 .34279 .527 .33891 .52087 .33178 Mtetra
.52087 .33178 .527 .33891 .53832 .335 .53222 .32785 Mtetra
.657 .752 .92 r
.53222 .32785 .53832 .335 .54967 .33109 .54361 .3239 Mtetra
.54361 .3239 .54967 .33109 .56108 .32715 .55504 .31994 Mtetra
.55504 .31994 .56108 .32715 .57253 .3232 .56653 .31596 Mtetra
.56653 .31596 .57253 .3232 .58403 .31924 .57806 .31197 Mtetra
.57806 .31197 .58403 .31924 .59558 .31526 .58964 .30796 Mtetra
.58964 .30796 .59558 .31526 .60717 .31127 .60127 .30393 Mtetra
.60127 .30393 .60717 .31127 .61882 .30726 .61294 .29989 Mtetra
.61294 .29989 .61882 .30726 .63051 .30323 .62467 .29583 Mtetra
.62467 .29583 .63051 .30323 .64225 .29919 .63644 .29176 Mtetra
.63644 .29176 .64225 .29919 .65404 .29513 .64826 .28767 Mtetra
.64826 .28767 .65404 .29513 .66588 .29106 .66013 .28356 Mtetra
.66013 .28356 .66588 .29106 .67776 .28697 .67206 .27944 Mtetra
.67206 .27944 .67776 .28697 .6897 .28286 .68403 .2753 Mtetra
.68403 .2753 .6897 .28286 .70169 .27873 .69605 .27114 Mtetra
.69605 .27114 .70169 .27873 .71373 .27459 .70813 .26697 Mtetra
.70813 .26697 .71373 .27459 .72582 .27043 .72026 .26278 Mtetra
.72026 .26278 .72582 .27043 .73796 .26626 .73243 .25857 Mtetra
.73243 .25857 .73796 .26626 .75016 .26207 .74466 .25434 Mtetra
.74466 .25434 .75016 .26207 .7624 .25785 .75695 .2501 Mtetra
.75695 .2501 .7624 .25785 .7747 .25363 .76928 .24584 Mtetra
.76928 .24584 .7747 .25363 .78705 .24938 .78167 .24156 Mtetra
.517 .679 .939 r
.12438 .46087 .1314 .4679 .12757 .58129 .13387 .46022 Mtetra
.565 .354 .553 r
.13387 .46022 .12757 .58129 .15136 .45831 .14452 .45 Mtetra
.527 .642 .907 r
.14452 .45 .15136 .45831 .16108 .45625 .15408 .44944 Mtetra
.613 .722 .923 r
.15408 .44944 .16108 .45625 .17088 .45388 .1639 .44702 Mtetra
.589 .713 .929 r
.1639 .44702 .17088 .45388 .18042 .4543 .17371 .44506 Mtetra
.852 .715 .711 r
.17371 .44506 .18042 .4543 .19118 .44346 .1854 .42562 Mtetra
.137 .223 .691 r
.1854 .42562 .19118 .44346 .20099 .44206 .19409 .43505 Mtetra
.611 .718 .921 r
.19409 .43505 .20099 .44206 .21098 .43939 .20407 .43263 Mtetra
.626 .731 .923 r
.20407 .43263 .21098 .43939 .22101 .43674 .21413 .42985 Mtetra
.602 .72 .928 r
.21413 .42985 .22101 .43674 .23088 .43625 .22418 .42758 Mtetra
.91 .718 .63 r
.22418 .42758 .23088 .43625 .2417 .42565 .23782 .38577 Mtetra
0 0 .426 r
.23782 .38577 .2417 .42565 .25172 .42444 .24492 .41729 Mtetra
.614 .718 .919 r
.24492 .41729 .25172 .42444 .26192 .42155 .25512 .41475 Mtetra
.636 .737 .921 r
.25512 .41475 .26192 .42155 .27219 .41843 .26541 .41167 Mtetra
.64 .74 .922 r
.26541 .41167 .27219 .41843 .28251 .4153 .27574 .40849 Mtetra
.635 .738 .923 r
.27574 .40849 .28251 .4153 .29284 .41249 .28611 .40542 Mtetra
.595 .717 .929 r
.28611 .40542 .29284 .41249 .30291 .41411 .29647 .40324 Mtetra
.809 .697 .74 r
.29647 .40324 .30291 .41411 .31398 .40153 .30767 .38915 Mtetra
.381 .473 .829 r
.30767 .38915 .31398 .40153 .32439 .39943 .31774 .39229 Mtetra
.628 .728 .919 r
.31774 .39229 .32439 .39943 .33491 .39621 .32827 .38934 Mtetra
.646 .743 .92 r
.32827 .38934 .33491 .39621 .34549 .39274 .33887 .38593 Mtetra
.652 .748 .92 r
.33887 .38593 .34549 .39274 .35612 .38915 .34952 .38236 Mtetra
.655 .75 .92 r
.34952 .38236 .35612 .38915 .3668 .38549 .36022 .3787 Mtetra
.657 .752 .92 r
.36022 .3787 .3668 .38549 .37752 .38176 .37097 .37496 Mtetra
.658 .753 .92 r
.37097 .37496 .37752 .38176 .38828 .378 .38176 .37118 Mtetra
.659 .754 .92 r
.38176 .37118 .38828 .378 .39909 .37421 .3926 .36737 Mtetra
.3926 .36737 .39909 .37421 .40994 .3704 .40348 .36354 Mtetra
.40348 .36354 .40994 .3704 .42084 .36659 .4144 .35969 Mtetra
.4144 .35969 .42084 .36659 .43177 .36277 .42536 .35583 Mtetra
.658 .753 .92 r
.42536 .35583 .43177 .36277 .44275 .35893 .43637 .35197 Mtetra
.43637 .35197 .44275 .35893 .45378 .35509 .44743 .3481 Mtetra
.44743 .3481 .45378 .35509 .46485 .35124 .45852 .34421 Mtetra
.45852 .34421 .46485 .35124 .47596 .34737 .46967 .34032 Mtetra
.46967 .34032 .47596 .34737 .48712 .3435 .48086 .33641 Mtetra
.48086 .33641 .48712 .3435 .49833 .33961 .49209 .33249 Mtetra
.49209 .33249 .49833 .33961 .50958 .3357 .50337 .32855 Mtetra
.657 .753 .92 r
.50337 .32855 .50958 .3357 .52087 .33178 .5147 .3246 Mtetra
.5147 .3246 .52087 .33178 .53222 .32785 .52607 .32064 Mtetra
.657 .752 .92 r
.52607 .32064 .53222 .32785 .54361 .3239 .53749 .31666 Mtetra
.53749 .31666 .54361 .3239 .55504 .31994 .54896 .31267 Mtetra
.54896 .31267 .55504 .31994 .56653 .31596 .56048 .30866 Mtetra
.56048 .30866 .56653 .31596 .57806 .31197 .57204 .30463 Mtetra
.57204 .30463 .57806 .31197 .58964 .30796 .58365 .30059 Mtetra
.58365 .30059 .58964 .30796 .60127 .30393 .59531 .29654 Mtetra
.59531 .29654 .60127 .30393 .61294 .29989 .60702 .29246 Mtetra
.60702 .29246 .61294 .29989 .62467 .29583 .61878 .28837 Mtetra
.61878 .28837 .62467 .29583 .63644 .29176 .63059 .28427 Mtetra
.63059 .28427 .63644 .29176 .64826 .28767 .64244 .28015 Mtetra
.64244 .28015 .64826 .28767 .66013 .28356 .65435 .27601 Mtetra
.65435 .27601 .66013 .28356 .67206 .27944 .66631 .27185 Mtetra
.66631 .27185 .67206 .27944 .68403 .2753 .67832 .26768 Mtetra
.67832 .26768 .68403 .2753 .69605 .27114 .69037 .26349 Mtetra
.69037 .26349 .69605 .27114 .70813 .26697 .70248 .25928 Mtetra
.70248 .25928 .70813 .26697 .72026 .26278 .71465 .25506 Mtetra
.71465 .25506 .72026 .26278 .73243 .25857 .72686 .25082 Mtetra
.72686 .25082 .73243 .25857 .74466 .25434 .73913 .24656 Mtetra
.73913 .24656 .74466 .25434 .75695 .2501 .75145 .24228 Mtetra
.75145 .24228 .75695 .2501 .76928 .24584 .76382 .23798 Mtetra
.76382 .23798 .76928 .24584 .78167 .24156 .77624 .23367 Mtetra
.592 .714 .928 r
.11728 .45402 .12438 .46087 .13387 .46022 .12694 .45203 Mtetra
.946 .665 .474 r
.12694 .45203 .13387 .46022 .14452 .45 .12291 .56589 Mtetra
0 0 0 r
.12291 .56589 .14452 .45 .15408 .44944 .14707 .4423 Mtetra
.598 .708 .921 r
.14707 .4423 .15408 .44944 .1639 .44702 .15687 .44019 Mtetra
.611 .723 .925 r
.15687 .44019 .1639 .44702 .17371 .44506 .16675 .43776 Mtetra
.446 .643 .941 r
.16675 .43776 .17371 .44506 .1854 .42562 .17637 .43813 Mtetra
0 0 0 r
.17637 .43813 .1854 .42562 .19409 .43505 .18723 .4272 Mtetra
.567 .677 .914 r
.18723 .4272 .19409 .43505 .20407 .43263 .19712 .42575 Mtetra
.623 .728 .922 r
.19712 .42575 .20407 .43263 .21413 .42985 .20719 .42301 Mtetra
.621 .73 .924 r
.20719 .42301 .21413 .42985 .22418 .42758 .2173 .42031 Mtetra
.508 .673 .939 r
.2173 .42031 .22418 .42758 .23782 .38577 .22726 .41976 Mtetra
.316 .024 .301 r
.22726 .41976 .23782 .38577 .24492 .41729 .23817 .40907 Mtetra
.558 .666 .909 r
.23817 .40907 .24492 .41729 .25512 .41475 .24828 .4078 Mtetra
.63 .732 .921 r
.24828 .4078 .25512 .41475 .26541 .41167 .25857 .40485 Mtetra
.639 .74 .921 r
.25857 .40485 .26541 .41167 .27574 .40849 .26893 .40166 Mtetra
.639 .74 .922 r
.26893 .40166 .27574 .40849 .28611 .40542 .27933 .39847 Mtetra
.625 .733 .924 r
.27933 .39847 .28611 .40542 .29647 .40324 .28975 .39559 Mtetra
.363 .595 .935 r
.28975 .39559 .29647 .40324 .30767 .38915 .29991 .39717 Mtetra
.594 .864 .528 r
.29991 .39717 .30767 .38915 .31774 .39229 .31109 .38449 Mtetra
.595 .697 .914 r
.31109 .38449 .31774 .39229 .32827 .38934 .32159 .38232 Mtetra
.64 .739 .92 r
.32159 .38232 .32827 .38934 .33887 .38593 .3322 .37904 Mtetra
.649 .746 .92 r
.3322 .37904 .33887 .38593 .34952 .38236 .34288 .3755 Mtetra
.653 .749 .92 r
.34288 .3755 .34952 .38236 .36022 .3787 .3536 .37184 Mtetra
.656 .751 .92 r
.3536 .37184 .36022 .3787 .37097 .37496 .36437 .36811 Mtetra
.658 .753 .92 r
.36437 .36811 .37097 .37496 .38176 .37118 .37519 .36431 Mtetra
.659 .753 .92 r
.37519 .36431 .38176 .37118 .3926 .36737 .38605 .36048 Mtetra
.659 .754 .92 r
.38605 .36048 .3926 .36737 .40348 .36354 .39696 .35662 Mtetra
.39696 .35662 .40348 .36354 .4144 .35969 .40791 .35274 Mtetra
.40791 .35274 .4144 .35969 .42536 .35583 .4189 .34885 Mtetra
.659 .753 .92 r
.4189 .34885 .42536 .35583 .43637 .35197 .42994 .34496 Mtetra
.658 .753 .92 r
.42994 .34496 .43637 .35197 .44743 .3481 .44102 .34105 Mtetra
.44102 .34105 .44743 .3481 .45852 .34421 .45215 .33714 Mtetra
.45215 .33714 .45852 .34421 .46967 .34032 .46333 .33321 Mtetra
.46333 .33321 .46967 .34032 .48086 .33641 .47454 .32927 Mtetra
.47454 .32927 .48086 .33641 .49209 .33249 .48581 .32532 Mtetra
.48581 .32532 .49209 .33249 .50337 .32855 .49712 .32135 Mtetra
.657 .753 .92 r
.49712 .32135 .50337 .32855 .5147 .3246 .50848 .31737 Mtetra
.50848 .31737 .5147 .3246 .52607 .32064 .51988 .31338 Mtetra
.51988 .31338 .52607 .32064 .53749 .31666 .53133 .30937 Mtetra
.657 .752 .92 r
.53133 .30937 .53749 .31666 .54896 .31267 .54283 .30534 Mtetra
.54283 .30534 .54896 .31267 .56048 .30866 .55438 .3013 Mtetra
.55438 .3013 .56048 .30866 .57204 .30463 .56598 .29725 Mtetra
.56598 .29725 .57204 .30463 .58365 .30059 .57762 .29317 Mtetra
.57762 .29317 .58365 .30059 .59531 .29654 .58931 .28908 Mtetra
.58931 .28908 .59531 .29654 .60702 .29246 .60105 .28498 Mtetra
.60105 .28498 .60702 .29246 .61878 .28837 .61285 .28086 Mtetra
.61285 .28086 .61878 .28837 .63059 .28427 .62469 .27672 Mtetra
.62469 .27672 .63059 .28427 .64244 .28015 .63658 .27257 Mtetra
.63658 .27257 .64244 .28015 .65435 .27601 .64852 .2684 Mtetra
.64852 .2684 .65435 .27601 .66631 .27185 .66051 .26421 Mtetra
.66051 .26421 .66631 .27185 .67832 .26768 .67255 .26 Mtetra
.67255 .26 .67832 .26768 .69037 .26349 .68465 .25578 Mtetra
.68465 .25578 .69037 .26349 .70248 .25928 .69679 .25154 Mtetra
.69679 .25154 .70248 .25928 .71465 .25506 .70899 .24728 Mtetra
.70899 .24728 .71465 .25506 .72686 .25082 .72124 .243 Mtetra
.72124 .243 .72686 .25082 .73913 .24656 .73355 .23871 Mtetra
.73355 .23871 .73913 .24656 .75145 .24228 .7459 .2344 Mtetra
.7459 .2344 .75145 .24228 .76382 .23798 .75831 .23007 Mtetra
.75831 .23007 .76382 .23798 .77624 .23367 .77078 .22572 Mtetra
.602 .716 .925 r
.11014 .4471 .11728 .45402 .12694 .45203 .11984 .44488 Mtetra
.517 .679 .938 r
.11984 .44488 .12694 .45203 .12291 .56589 .12941 .44419 Mtetra
.563 .35 .55 r
.12941 .44419 .12291 .56589 .14707 .4423 .14016 .43387 Mtetra
.527 .643 .907 r
.14016 .43387 .14707 .4423 .15687 .44019 .1498 .43326 Mtetra
.613 .722 .923 r
.1498 .43326 .15687 .44019 .16675 .43776 .1597 .43078 Mtetra
.589 .713 .929 r
.1597 .43078 .16675 .43776 .17637 .43813 .16959 .42877 Mtetra
.853 .716 .711 r
.16959 .42877 .17637 .43813 .18723 .4272 .18139 .4092 Mtetra
.133 .221 .69 r
.18139 .4092 .18723 .4272 .19712 .42575 .19014 .41861 Mtetra
.611 .718 .921 r
.19014 .41861 .19712 .42575 .20719 .42301 .20021 .41613 Mtetra
.626 .731 .923 r
.20021 .41613 .20719 .42301 .2173 .42031 .21035 .4133 Mtetra
.602 .72 .928 r
.21035 .4133 .2173 .42031 .22726 .41976 .22048 .41097 Mtetra
.911 .718 .629 r
.22048 .41097 .22726 .41976 .23817 .40907 .23428 .36894 Mtetra
0 0 .422 r
.23428 .36894 .23817 .40907 .24828 .4078 .24141 .40052 Mtetra
.614 .718 .92 r
.24141 .40052 .24828 .4078 .25857 .40485 .25169 .39793 Mtetra
.636 .737 .921 r
.25169 .39793 .25857 .40485 .26893 .40166 .26207 .39478 Mtetra
.64 .74 .922 r
.26207 .39478 .26893 .40166 .27933 .39847 .27249 .39154 Mtetra
.635 .738 .923 r
.27249 .39154 .27933 .39847 .28975 .39559 .28295 .3884 Mtetra
.595 .717 .929 r
.28295 .3884 .28975 .39559 .29991 .39717 .2934 .38616 Mtetra
.81 .697 .741 r
.2934 .38616 .29991 .39717 .31109 .38449 .30471 .37196 Mtetra
.38 .472 .829 r
.30471 .37196 .31109 .38449 .32159 .38232 .31487 .37505 Mtetra
.628 .728 .919 r
.31487 .37505 .32159 .38232 .3322 .37904 .32549 .37204 Mtetra
.646 .743 .92 r
.32549 .37204 .3322 .37904 .34288 .3755 .33618 .36856 Mtetra
.652 .748 .92 r
.33618 .36856 .34288 .3755 .3536 .37184 .34693 .36492 Mtetra
.655 .75 .92 r
.34693 .36492 .3536 .37184 .36437 .36811 .35773 .36119 Mtetra
.657 .752 .92 r
.35773 .36119 .36437 .36811 .37519 .36431 .36857 .35738 Mtetra
.658 .753 .92 r
.36857 .35738 .37519 .36431 .38605 .36048 .37946 .35353 Mtetra
.659 .754 .92 r
.37946 .35353 .38605 .36048 .39696 .35662 .39039 .34965 Mtetra
.39039 .34965 .39696 .35662 .40791 .35274 .40137 .34574 Mtetra
.40137 .34574 .40791 .35274 .4189 .34885 .4124 .34182 Mtetra
.4124 .34182 .4189 .34885 .42994 .34496 .42346 .33789 Mtetra
.658 .753 .92 r
.42346 .33789 .42994 .34496 .44102 .34105 .43457 .33395 Mtetra
.43457 .33395 .44102 .34105 .45215 .33714 .44573 .33001 Mtetra
.44573 .33001 .45215 .33714 .46333 .33321 .45693 .32605 Mtetra
.45693 .32605 .46333 .33321 .47454 .32927 .46818 .32208 Mtetra
.46818 .32208 .47454 .32927 .48581 .32532 .47948 .31809 Mtetra
.47948 .31809 .48581 .32532 .49712 .32135 .49082 .3141 Mtetra
.49082 .3141 .49712 .32135 .50848 .31737 .50221 .31008 Mtetra
.657 .753 .92 r
.50221 .31008 .50848 .31737 .51988 .31338 .51364 .30606 Mtetra
.51364 .30606 .51988 .31338 .53133 .30937 .52513 .30202 Mtetra
.657 .752 .92 r
.52513 .30202 .53133 .30937 .54283 .30534 .53666 .29796 Mtetra
.53666 .29796 .54283 .30534 .55438 .3013 .54824 .29389 Mtetra
.54824 .29389 .55438 .3013 .56598 .29725 .55986 .2898 Mtetra
.55986 .2898 .56598 .29725 .57762 .29317 .57154 .2857 Mtetra
.57154 .2857 .57762 .29317 .58931 .28908 .58327 .28157 Mtetra
.58327 .28157 .58931 .28908 .60105 .28498 .59504 .27744 Mtetra
.59504 .27744 .60105 .28498 .61285 .28086 .60687 .27328 Mtetra
.60687 .27328 .61285 .28086 .62469 .27672 .61874 .26911 Mtetra
.61874 .26911 .62469 .27672 .63658 .27257 .63067 .26493 Mtetra
.63067 .26493 .63658 .27257 .64852 .2684 .64264 .26072 Mtetra
.64264 .26072 .64852 .2684 .66051 .26421 .65467 .2565 Mtetra
.65467 .2565 .66051 .26421 .67255 .26 .66675 .25226 Mtetra
.66675 .25226 .67255 .26 .68465 .25578 .67888 .248 Mtetra
.67888 .248 .68465 .25578 .69679 .25154 .69106 .24373 Mtetra
.69106 .24373 .69679 .25154 .70899 .24728 .70329 .23944 Mtetra
.70329 .23944 .70899 .24728 .72124 .243 .71558 .23513 Mtetra
.71558 .23513 .72124 .243 .73355 .23871 .72792 .2308 Mtetra
.72792 .2308 .73355 .23871 .7459 .2344 .74032 .22645 Mtetra
.74032 .22645 .7459 .2344 .75831 .23007 .75276 .22209 Mtetra
.75276 .22209 .75831 .23007 .77078 .22572 .76527 .2177 Mtetra
.587 .701 .922 r
.10299 .43982 .11014 .4471 .11984 .44488 .11266 .43792 Mtetra
.592 .714 .928 r
.11266 .43792 .11984 .44488 .12941 .44419 .12241 .43587 Mtetra
.947 .665 .471 r
.12241 .43587 .12941 .44419 .14016 .43387 .11816 .55019 Mtetra
0 0 0 r
.11816 .55019 .14016 .43387 .1498 .43326 .14271 .42601 Mtetra
.598 .708 .921 r
.14271 .42601 .1498 .43326 .1597 .43078 .15259 .42384 Mtetra
.611 .723 .925 r
.15259 .42384 .1597 .43078 .16959 .42877 .16254 .42135 Mtetra
.447 .643 .941 r
.16254 .42135 .16959 .42877 .18139 .4092 .17224 .42167 Mtetra
0 0 0 r
.17224 .42167 .18139 .4092 .19014 .41861 .1832 .41064 Mtetra
.567 .677 .914 r
.1832 .41064 .19014 .41861 .20021 .41613 .19318 .40913 Mtetra
.623 .728 .922 r
.19318 .40913 .20021 .41613 .21035 .4133 .20333 .40633 Mtetra
.621 .73 .924 r
.20333 .40633 .21035 .4133 .22048 .41097 .21353 .40357 Mtetra
.508 .673 .939 r
.21353 .40357 .22048 .41097 .23428 .36894 .22357 .40297 Mtetra
.307 .014 .292 r
.22357 .40297 .23428 .36894 .24141 .40052 .23458 .39218 Mtetra
.558 .666 .909 r
.23458 .39218 .24141 .40052 .25169 .39793 .24477 .39085 Mtetra
.63 .732 .921 r
.24477 .39085 .25169 .39793 .26207 .39478 .25515 .38784 Mtetra
.639 .74 .921 r
.25515 .38784 .26207 .39478 .27249 .39154 .2656 .38458 Mtetra
.639 .74 .922 r
.2656 .38458 .27249 .39154 .28295 .3884 .2761 .38132 Mtetra
.625 .733 .924 r
.2761 .38132 .28295 .3884 .2934 .38616 .28661 .37838 Mtetra
.364 .595 .935 r
.28661 .37838 .2934 .38616 .30471 .37196 .29685 .37991 Mtetra
.605 .872 .54 r
.29685 .37991 .30471 .37196 .31487 .37505 .30814 .36712 Mtetra
.595 .697 .914 r
.30814 .36712 .31487 .37505 .32549 .37204 .31873 .36489 Mtetra
.64 .739 .92 r
.31873 .36489 .32549 .37204 .33618 .36856 .32944 .36154 Mtetra
.649 .746 .92 r
.32944 .36154 .33618 .36856 .34693 .36492 .34021 .35793 Mtetra
.653 .749 .92 r
.34021 .35793 .34693 .36492 .35773 .36119 .35103 .3542 Mtetra
.656 .751 .92 r
.35103 .3542 .35773 .36119 .36857 .35738 .3619 .35039 Mtetra
.658 .753 .92 r
.3619 .35039 .36857 .35738 .37946 .35353 .37282 .34653 Mtetra
.659 .753 .92 r
.37282 .34653 .37946 .35353 .39039 .34965 .38378 .34262 Mtetra
.659 .754 .92 r
.38378 .34262 .39039 .34965 .40137 .34574 .39479 .33869 Mtetra
.39479 .33869 .40137 .34574 .4124 .34182 .40584 .33474 Mtetra
.40584 .33474 .4124 .34182 .42346 .33789 .41693 .33077 Mtetra
.659 .753 .92 r
.41693 .33077 .42346 .33789 .43457 .33395 .42807 .3268 Mtetra
.658 .753 .92 r
.42807 .3268 .43457 .33395 .44573 .33001 .43926 .32282 Mtetra
.43926 .32282 .44573 .33001 .45693 .32605 .45049 .31883 Mtetra
.45049 .31883 .45693 .32605 .46818 .32208 .46177 .31483 Mtetra
.46177 .31483 .46818 .32208 .47948 .31809 .4731 .31081 Mtetra
.4731 .31081 .47948 .31809 .49082 .3141 .48447 .30678 Mtetra
.48447 .30678 .49082 .3141 .50221 .31008 .49589 .30274 Mtetra
.657 .753 .92 r
.49589 .30274 .50221 .31008 .51364 .30606 .50736 .29868 Mtetra
.50736 .29868 .51364 .30606 .52513 .30202 .51887 .29461 Mtetra
.51887 .29461 .52513 .30202 .53666 .29796 .53043 .29052 Mtetra
.657 .752 .92 r
.53043 .29052 .53666 .29796 .54824 .29389 .54204 .28642 Mtetra
.54204 .28642 .54824 .29389 .55986 .2898 .5537 .2823 Mtetra
.5537 .2823 .55986 .2898 .57154 .2857 .56541 .27816 Mtetra
.56541 .27816 .57154 .2857 .58327 .28157 .57717 .27401 Mtetra
.57717 .27401 .58327 .28157 .59504 .27744 .58898 .26984 Mtetra
.58898 .26984 .59504 .27744 .60687 .27328 .60084 .26565 Mtetra
.60084 .26565 .60687 .27328 .61874 .26911 .61275 .26145 Mtetra
.61275 .26145 .61874 .26911 .63067 .26493 .62471 .25723 Mtetra
.62471 .25723 .63067 .26493 .64264 .26072 .63672 .25299 Mtetra
.63672 .25299 .64264 .26072 .65467 .2565 .64878 .24873 Mtetra
.64878 .24873 .65467 .2565 .66675 .25226 .66089 .24446 Mtetra
.66089 .24446 .66675 .25226 .67888 .248 .67306 .24017 Mtetra
.67306 .24017 .67888 .248 .69106 .24373 .68528 .23586 Mtetra
.68528 .23586 .69106 .24373 .70329 .23944 .69755 .23153 Mtetra
.69755 .23153 .70329 .23944 .71558 .23513 .70987 .22719 Mtetra
.70987 .22719 .71558 .23513 .72792 .2308 .72225 .22282 Mtetra
.72225 .22282 .72792 .2308 .74032 .22645 .73468 .21844 Mtetra
.73468 .21844 .74032 .22645 .75276 .22209 .74717 .21404 Mtetra
.74717 .21404 .75276 .22209 .76527 .2177 .75971 .20962 Mtetra
.491 .613 .9 r
.09601 .43083 .10299 .43982 .11266 .43792 .10544 .43088 Mtetra
.602 .716 .925 r
.10544 .43088 .11266 .43792 .12241 .43587 .11523 .4286 Mtetra
.517 .679 .938 r
.11523 .4286 .12241 .43587 .11816 .55019 .12487 .42786 Mtetra
.56 .347 .548 r
.12487 .42786 .11816 .55019 .14271 .42601 .13572 .41745 Mtetra
.526 .643 .907 r
.13572 .41745 .14271 .42601 .15259 .42384 .14543 .41679 Mtetra
.613 .722 .923 r
.14543 .41679 .15259 .42384 .16254 .42135 .15541 .41424 Mtetra
.589 .713 .929 r
.15541 .41424 .16254 .42135 .17224 .42167 .16539 .41217 Mtetra
.853 .716 .711 r
.16539 .41217 .17224 .42167 .1832 .41064 .17731 .39247 Mtetra
.129 .218 .689 r
.17731 .39247 .1832 .41064 .19318 .40913 .18612 .40187 Mtetra
.611 .718 .921 r
.18612 .40187 .19318 .40913 .20333 .40633 .19627 .39933 Mtetra
.626 .731 .923 r
.19627 .39933 .20333 .40633 .21353 .40357 .20649 .39643 Mtetra
.602 .72 .928 r
.20649 .39643 .21353 .40357 .22357 .40297 .21672 .39404 Mtetra
.913 .719 .628 r
.21672 .39404 .22357 .40297 .23458 .39218 .23068 .35179 Mtetra
0 0 .418 r
.23068 .35179 .23458 .39218 .24477 .39085 .23783 .38345 Mtetra
.614 .718 .92 r
.23783 .38345 .24477 .39085 .25515 .38784 .2482 .38079 Mtetra
.636 .737 .921 r
.2482 .38079 .25515 .38784 .2656 .38458 .25866 .37758 Mtetra
.64 .74 .922 r
.25866 .37758 .2656 .38458 .2761 .38132 .26918 .37426 Mtetra
.635 .738 .923 r
.26918 .37426 .2761 .38132 .28661 .37838 .27973 .37106 Mtetra
.595 .717 .929 r
.27973 .37106 .28661 .37838 .29685 .37991 .29027 .36875 Mtetra
.811 .698 .741 r
.29027 .36875 .29685 .37991 .30814 .36712 .30169 .35444 Mtetra
.379 .472 .829 r
.30169 .35444 .30814 .36712 .31873 .36489 .31193 .35749 Mtetra
.628 .728 .919 r
.31193 .35749 .31873 .36489 .32944 .36154 .32265 .35441 Mtetra
.646 .743 .92 r
.32265 .35441 .32944 .36154 .34021 .35793 .33344 .35086 Mtetra
.652 .748 .92 r
.33344 .35086 .34021 .35793 .35103 .3542 .34429 .34715 Mtetra
.655 .75 .92 r
.34429 .34715 .35103 .3542 .3619 .35039 .35518 .34334 Mtetra
.657 .752 .92 r
.35518 .34334 .3619 .35039 .37282 .34653 .36612 .33946 Mtetra
.658 .753 .92 r
.36612 .33946 .37282 .34653 .38378 .34262 .37711 .33554 Mtetra
.659 .754 .92 r
.37711 .33554 .38378 .34262 .39479 .33869 .38815 .33158 Mtetra
.38815 .33158 .39479 .33869 .40584 .33474 .39923 .3276 Mtetra
.39923 .3276 .40584 .33474 .41693 .33077 .41035 .3236 Mtetra
.41035 .3236 .41693 .33077 .42807 .3268 .42152 .3196 Mtetra
.658 .753 .92 r
.42152 .3196 .42807 .3268 .43926 .32282 .43274 .31559 Mtetra
.43274 .31559 .43926 .32282 .45049 .31883 .444 .31156 Mtetra
.444 .31156 .45049 .31883 .46177 .31483 .45531 .30753 Mtetra
.45531 .30753 .46177 .31483 .4731 .31081 .46667 .30348 Mtetra
.46667 .30348 .4731 .31081 .48447 .30678 .47807 .29942 Mtetra
.47807 .29942 .48447 .30678 .49589 .30274 .48952 .29534 Mtetra
.48952 .29534 .49589 .30274 .50736 .29868 .50102 .29125 Mtetra
.657 .753 .92 r
.50102 .29125 .50736 .29868 .51887 .29461 .51257 .28715 Mtetra
.51257 .28715 .51887 .29461 .53043 .29052 .52416 .28302 Mtetra
.657 .752 .92 r
.52416 .28302 .53043 .29052 .54204 .28642 .5358 .27889 Mtetra
.5358 .27889 .54204 .28642 .5537 .2823 .5475 .27473 Mtetra
.5475 .27473 .5537 .2823 .56541 .27816 .55924 .27056 Mtetra
.55924 .27056 .56541 .27816 .57717 .27401 .57103 .26638 Mtetra
.57103 .26638 .57717 .27401 .58898 .26984 .58287 .26218 Mtetra
.58287 .26218 .58898 .26984 .60084 .26565 .59477 .25796 Mtetra
.59477 .25796 .60084 .26565 .61275 .26145 .60671 .25372 Mtetra
.60671 .25372 .61275 .26145 .62471 .25723 .6187 .24946 Mtetra
.6187 .24946 .62471 .25723 .63672 .25299 .63075 .24519 Mtetra
.63075 .24519 .63672 .25299 .64878 .24873 .64285 .2409 Mtetra
.64285 .2409 .64878 .24873 .66089 .24446 .65499 .2366 Mtetra
.65499 .2366 .66089 .24446 .67306 .24017 .6672 .23227 Mtetra
.6672 .23227 .67306 .24017 .68528 .23586 .67945 .22793 Mtetra
.67945 .22793 .68528 .23586 .69755 .23153 .69176 .22357 Mtetra
.69176 .22357 .69755 .23153 .70987 .22719 .70412 .21919 Mtetra
.70412 .21919 .70987 .22719 .72225 .22282 .71654 .21479 Mtetra
.71654 .21479 .72225 .22282 .73468 .21844 .72901 .21037 Mtetra
.72901 .21037 .73468 .21844 .74717 .21404 .74153 .20593 Mtetra
.74153 .20593 .74717 .21404 .75971 .20962 .75411 .20148 Mtetra
.786 .876 .447 r
.08523 .44978 .09601 .43083 .10544 .43088 .09821 .42348 Mtetra
.587 .701 .922 r
.09821 .42348 .10544 .43088 .11523 .4286 .10797 .42152 Mtetra
.592 .714 .928 r
.10797 .42152 .11523 .4286 .12487 .42786 .11779 .41941 Mtetra
.948 .665 .468 r
.11779 .41941 .12487 .42786 .13572 .41745 .11332 .5342 Mtetra
0 0 0 r
.11332 .5342 .13572 .41745 .14543 .41679 .13826 .40941 Mtetra
.598 .708 .921 r
.13826 .40941 .14543 .41679 .15541 .41424 .14822 .40718 Mtetra
.611 .723 .925 r
.14822 .40718 .15541 .41424 .16539 .41217 .15826 .40463 Mtetra
.448 .643 .941 r
.15826 .40463 .16539 .41217 .17731 .39247 .16804 .4049 Mtetra
0 0 0 r
.16804 .4049 .17731 .39247 .18612 .40187 .1791 .39377 Mtetra
.567 .677 .914 r
.1791 .39377 .18612 .40187 .19627 .39933 .18916 .39221 Mtetra
.623 .728 .922 r
.18916 .39221 .19627 .39933 .20649 .39643 .1994 .38934 Mtetra
.621 .73 .924 r
.1994 .38934 .20649 .39643 .21672 .39404 .20968 .38651 Mtetra
.508 .673 .939 r
.20968 .38651 .21672 .39404 .23068 .35179 .2198 .38586 Mtetra
.299 .003 .283 r
.2198 .38586 .23068 .35179 .23783 .38345 .23093 .37497 Mtetra
.558 .666 .909 r
.23093 .37497 .23783 .38345 .2482 .38079 .2412 .37358 Mtetra
.63 .732 .921 r
.2412 .37358 .2482 .38079 .25866 .37758 .25167 .3705 Mtetra
.639 .74 .921 r
.25167 .3705 .25866 .37758 .26918 .37426 .26221 .36718 Mtetra
.639 .74 .922 r
.26221 .36718 .26918 .37426 .27973 .37106 .2728 .36385 Mtetra
.625 .733 .924 r
.2728 .36385 .27973 .37106 .29027 .36875 .2834 .36084 Mtetra
.366 .596 .934 r
.2834 .36084 .29027 .36875 .30169 .35444 .29373 .36231 Mtetra
.616 .881 .551 r
.29373 .36231 .30169 .35444 .31193 .35749 .30513 .34942 Mtetra
.594 .697 .915 r
.30513 .34942 .31193 .35749 .32265 .35441 .31581 .34713 Mtetra
.64 .739 .92 r
.31581 .34713 .32265 .35441 .33344 .35086 .32662 .3437 Mtetra
.649 .746 .92 r
.32662 .3437 .33344 .35086 .34429 .34715 .33749 .34002 Mtetra
.653 .749 .92 r
.33749 .34002 .34429 .34715 .35518 .34334 .34841 .33622 Mtetra
.656 .751 .92 r
.34841 .33622 .35518 .34334 .36612 .33946 .35938 .33234 Mtetra
.658 .753 .92 r
.35938 .33234 .36612 .33946 .37711 .33554 .3704 .3284 Mtetra
.659 .753 .92 r
.3704 .3284 .37711 .33554 .38815 .33158 .38146 .32442 Mtetra
.659 .754 .92 r
.38146 .32442 .38815 .33158 .39923 .3276 .39257 .32041 Mtetra
.39257 .32041 .39923 .3276 .41035 .3236 .40372 .31638 Mtetra
.40372 .31638 .41035 .3236 .42152 .3196 .41492 .31234 Mtetra
.659 .753 .92 r
.41492 .31234 .42152 .3196 .43274 .31559 .42617 .30829 Mtetra
.658 .753 .92 r
.42617 .30829 .43274 .31559 .444 .31156 .43746 .30424 Mtetra
.43746 .30424 .444 .31156 .45531 .30753 .4488 .30017 Mtetra
.4488 .30017 .45531 .30753 .46667 .30348 .46019 .29609 Mtetra
.46019 .29609 .46667 .30348 .47807 .29942 .47162 .29199 Mtetra
.47162 .29199 .47807 .29942 .48952 .29534 .4831 .28788 Mtetra
.4831 .28788 .48952 .29534 .50102 .29125 .49463 .28376 Mtetra
.657 .753 .92 r
.49463 .28376 .50102 .29125 .51257 .28715 .50621 .27962 Mtetra
.50621 .27962 .51257 .28715 .52416 .28302 .51784 .27547 Mtetra
.51784 .27547 .52416 .28302 .5358 .27889 .52951 .2713 Mtetra
.657 .752 .92 r
.52951 .2713 .5358 .27889 .5475 .27473 .54124 .26711 Mtetra
.54124 .26711 .5475 .27473 .55924 .27056 .55302 .26291 Mtetra
.55302 .26291 .55924 .27056 .57103 .26638 .56484 .25869 Mtetra
.56484 .25869 .57103 .26638 .58287 .26218 .57672 .25445 Mtetra
.57672 .25445 .58287 .26218 .59477 .25796 .58864 .2502 Mtetra
.58864 .2502 .59477 .25796 .60671 .25372 .60062 .24593 Mtetra
.60062 .24593 .60671 .25372 .6187 .24946 .61265 .24164 Mtetra
.61265 .24164 .6187 .24946 .63075 .24519 .62473 .23733 Mtetra
.62473 .23733 .63075 .24519 .64285 .2409 .63686 .23301 Mtetra
.63686 .23301 .64285 .2409 .65499 .2366 .64905 .22867 Mtetra
.64905 .22867 .65499 .2366 .6672 .23227 .66129 .22431 Mtetra
.66129 .22431 .6672 .23227 .67945 .22793 .67358 .21993 Mtetra
.67358 .21993 .67945 .22793 .69176 .22357 .68592 .21553 Mtetra
.68592 .21553 .69176 .22357 .70412 .21919 .69832 .21112 Mtetra
.69832 .21112 .70412 .21919 .71654 .21479 .71077 .20668 Mtetra
.71077 .20668 .71654 .21479 .72901 .21037 .72328 .20223 Mtetra
.72328 .20223 .72901 .21037 .74153 .20593 .73584 .19776 Mtetra
.73584 .19776 .74153 .20593 .75411 .20148 .74846 .19327 Mtetra
.68 .526 .669 r
.08026 .42493 .08523 .44978 .09821 .42348 .09115 .41436 Mtetra
.491 .613 .9 r
.09115 .41436 .09821 .42348 .10797 .42152 .10066 .41436 Mtetra
.602 .716 .925 r
.10066 .41436 .10797 .42152 .11779 .41941 .11052 .41202 Mtetra
.518 .679 .938 r
.11052 .41202 .11779 .41941 .11332 .5342 .12024 .41122 Mtetra
.558 .343 .545 r
.12024 .41122 .11332 .5342 .13826 .40941 .1312 .40072 Mtetra
.526 .643 .907 r
.1312 .40072 .13826 .40941 .14822 .40718 .14099 .4 Mtetra
.613 .722 .923 r
.14099 .4 .14822 .40718 .15826 .40463 .15105 .3974 Mtetra
.589 .713 .929 r
.15105 .3974 .15826 .40463 .16804 .4049 .1611 .39526 Mtetra
.854 .717 .711 r
.1611 .39526 .16804 .4049 .1791 .39377 .17316 .37543 Mtetra
.126 .216 .688 r
.17316 .37543 .1791 .39377 .18916 .39221 .18202 .38482 Mtetra
.611 .718 .921 r
.18202 .38482 .18916 .39221 .1994 .38934 .19225 .38221 Mtetra
.626 .731 .923 r
.19225 .38221 .1994 .38934 .20968 .38651 .20257 .37925 Mtetra
.602 .72 .928 r
.20257 .37925 .20968 .38651 .2198 .38586 .21288 .37679 Mtetra
.914 .72 .627 r
.21288 .37679 .2198 .38586 .23093 .37497 .22701 .33432 Mtetra
0 0 .414 r
.22701 .33432 .23093 .37497 .2412 .37358 .23418 .36605 Mtetra
.614 .718 .92 r
.23418 .36605 .2412 .37358 .25167 .3705 .24464 .36332 Mtetra
.636 .737 .921 r
.24464 .36332 .25167 .3705 .26221 .36718 .2552 .36004 Mtetra
.64 .74 .922 r
.2552 .36004 .26221 .36718 .2728 .36385 .26581 .35666 Mtetra
.635 .738 .923 r
.26581 .35666 .2728 .36385 .2834 .36084 .27645 .35338 Mtetra
.595 .717 .929 r
.27645 .35338 .2834 .36084 .29373 .36231 .28708 .35101 Mtetra
.811 .699 .741 r
.28708 .35101 .29373 .36231 .30513 .34942 .29862 .33658 Mtetra
.377 .471 .829 r
.29862 .33658 .30513 .34942 .31581 .34713 .30894 .33959 Mtetra
.628 .728 .919 r
.30894 .33959 .31581 .34713 .32662 .3437 .31976 .33643 Mtetra
.646 .743 .92 r
.31976 .33643 .32662 .3437 .33749 .34002 .33065 .33282 Mtetra
.652 .748 .92 r
.33065 .33282 .33749 .34002 .34841 .33622 .34159 .32903 Mtetra
.655 .75 .92 r
.34159 .32903 .34841 .33622 .35938 .33234 .35259 .32515 Mtetra
.657 .752 .92 r
.35259 .32515 .35938 .33234 .3704 .3284 .36363 .3212 Mtetra
.658 .753 .92 r
.36363 .3212 .3704 .3284 .38146 .32442 .37472 .3172 Mtetra
.659 .754 .92 r
.37472 .3172 .38146 .32442 .39257 .32041 .38586 .31316 Mtetra
.38586 .31316 .39257 .32041 .40372 .31638 .39704 .3091 Mtetra
.39704 .3091 .40372 .31638 .41492 .31234 .40827 .30503 Mtetra
.40827 .30503 .41492 .31234 .42617 .30829 .41955 .30095 Mtetra
.658 .753 .92 r
.41955 .30095 .42617 .30829 .43746 .30424 .43087 .29686 Mtetra
.43087 .29686 .43746 .30424 .4488 .30017 .44224 .29275 Mtetra
.44224 .29275 .4488 .30017 .46019 .29609 .45366 .28864 Mtetra
.45366 .28864 .46019 .29609 .47162 .29199 .46512 .28451 Mtetra
.46512 .28451 .47162 .29199 .4831 .28788 .47664 .28037 Mtetra
.47664 .28037 .4831 .28788 .49463 .28376 .4882 .27621 Mtetra
.4882 .27621 .49463 .28376 .50621 .27962 .49981 .27204 Mtetra
.657 .753 .92 r
.49981 .27204 .50621 .27962 .51784 .27547 .51147 .26785 Mtetra
.51147 .26785 .51784 .27547 .52951 .2713 .52318 .26365 Mtetra
.657 .752 .92 r
.52318 .26365 .52951 .2713 .54124 .26711 .53493 .25943 Mtetra
.53493 .25943 .54124 .26711 .55302 .26291 .54674 .25519 Mtetra
.54674 .25519 .55302 .26291 .56484 .25869 .5586 .25094 Mtetra
.5586 .25094 .56484 .25869 .57672 .25445 .57051 .24667 Mtetra
.57051 .24667 .57672 .25445 .58864 .2502 .58247 .24238 Mtetra
.58247 .24238 .58864 .2502 .60062 .24593 .59448 .23808 Mtetra
.59448 .23808 .60062 .24593 .61265 .24164 .60655 .23376 Mtetra
.60655 .23376 .61265 .24164 .62473 .23733 .61866 .22941 Mtetra
.61866 .22941 .62473 .23733 .63686 .23301 .63083 .22506 Mtetra
.63083 .22506 .63686 .23301 .64905 .22867 .64305 .22068 Mtetra
.64305 .22068 .64905 .22867 .66129 .22431 .65533 .21628 Mtetra
.65533 .21628 .66129 .22431 .67358 .21993 .66766 .21187 Mtetra
.66766 .21187 .67358 .21993 .68592 .21553 .68004 .20744 Mtetra
.68004 .20744 .68592 .21553 .69832 .21112 .69247 .20299 Mtetra
.69247 .20299 .69832 .21112 .71077 .20668 .70496 .19851 Mtetra
.70496 .19851 .71077 .20668 .72328 .20223 .71751 .19402 Mtetra
.71751 .19402 .72328 .20223 .73584 .19776 .73011 .18952 Mtetra
.73011 .18952 .73584 .19776 .74846 .19327 .74277 .18499 Mtetra
.859 .417 .008 r
.073 .41672 .08026 .42493 .09115 .41436 .08022 .4333 Mtetra
.793 .881 .454 r
.08022 .4333 .09115 .41436 .10066 .41436 .09335 .40683 Mtetra
.586 .701 .922 r
.09335 .40683 .10066 .41436 .11052 .41202 .10318 .40481 Mtetra
.592 .714 .928 r
.10318 .40481 .11052 .41202 .12024 .41122 .11308 .40265 Mtetra
.949 .665 .466 r
.11308 .40265 .12024 .41122 .1312 .40072 .10839 .51789 Mtetra
0 0 0 r
.10839 .51789 .1312 .40072 .14099 .4 .13373 .3925 Mtetra
.598 .708 .921 r
.13373 .3925 .14099 .4 .15105 .3974 .14378 .3902 Mtetra
.611 .723 .925 r
.14378 .3902 .15105 .3974 .1611 .39526 .1539 .38759 Mtetra
.448 .643 .941 r
.1539 .38759 .1611 .39526 .17316 .37543 .16375 .38781 Mtetra
0 0 0 r
.16375 .38781 .17316 .37543 .18202 .38482 .17492 .37659 Mtetra
.566 .677 .914 r
.17492 .37659 .18202 .38482 .19225 .38221 .18506 .37496 Mtetra
.623 .728 .922 r
.18506 .37496 .19225 .38221 .20257 .37925 .19539 .37203 Mtetra
.621 .73 .924 r
.19539 .37203 .20257 .37925 .21288 .37679 .20576 .36913 Mtetra
.509 .673 .938 r
.20576 .36913 .21288 .37679 .22701 .33432 .21597 .36842 Mtetra
.289 0 .274 r
.21597 .36842 .22701 .33432 .23418 .36605 .2272 .35743 Mtetra
.557 .666 .909 r
.2272 .35743 .23418 .36605 .24464 .36332 .23756 .35598 Mtetra
.63 .732 .921 r
.23756 .35598 .24464 .36332 .2552 .36004 .24813 .35283 Mtetra
.639 .74 .921 r
.24813 .35283 .2552 .36004 .26581 .35666 .25876 .34944 Mtetra
.639 .74 .922 r
.25876 .34944 .26581 .35666 .27645 .35338 .26944 .34604 Mtetra
.625 .733 .924 r
.26944 .34604 .27645 .35338 .28708 .35101 .28014 .34296 Mtetra
.367 .596 .934 r
.28014 .34296 .28708 .35101 .29862 .33658 .29055 .34438 Mtetra
.627 .889 .562 r
.29055 .34438 .29862 .33658 .30894 .33959 .30207 .33138 Mtetra
.594 .697 .915 r
.30207 .33138 .30894 .33959 .31976 .33643 .31284 .32902 Mtetra
.64 .739 .92 r
.31284 .32902 .31976 .33643 .33065 .33282 .32375 .32552 Mtetra
.649 .746 .92 r
.32375 .32552 .33065 .33282 .34159 .32903 .33472 .32176 Mtetra
.653 .749 .92 r
.33472 .32176 .34159 .32903 .35259 .32515 .34574 .31789 Mtetra
.656 .751 .92 r
.34574 .31789 .35259 .32515 .36363 .3212 .35681 .31393 Mtetra
.658 .753 .92 r
.35681 .31393 .36363 .3212 .37472 .3172 .36793 .30991 Mtetra
.659 .753 .92 r
.36793 .30991 .37472 .3172 .38586 .31316 .3791 .30586 Mtetra
.659 .754 .92 r
.3791 .30586 .38586 .31316 .39704 .3091 .39031 .30177 Mtetra
.39031 .30177 .39704 .3091 .40827 .30503 .40157 .29766 Mtetra
.40157 .29766 .40827 .30503 .41955 .30095 .41288 .29355 Mtetra
.659 .753 .92 r
.41288 .29355 .41955 .30095 .43087 .29686 .42423 .28942 Mtetra
.658 .753 .92 r
.42423 .28942 .43087 .29686 .44224 .29275 .43563 .28528 Mtetra
.43563 .28528 .44224 .29275 .45366 .28864 .44708 .28113 Mtetra
.44708 .28113 .45366 .28864 .46512 .28451 .45857 .27697 Mtetra
.45857 .27697 .46512 .28451 .47664 .28037 .47012 .2728 Mtetra
.47012 .2728 .47664 .28037 .4882 .27621 .48171 .26861 Mtetra
.48171 .26861 .4882 .27621 .49981 .27204 .49335 .2644 Mtetra
.657 .753 .92 r
.49335 .2644 .49981 .27204 .51147 .26785 .50504 .26018 Mtetra
.50504 .26018 .51147 .26785 .52318 .26365 .51679 .25594 Mtetra
.51679 .25594 .52318 .26365 .53493 .25943 .52858 .25169 Mtetra
.657 .752 .92 r
.52858 .25169 .53493 .25943 .54674 .25519 .54042 .24742 Mtetra
.54042 .24742 .54674 .25519 .5586 .25094 .55231 .24313 Mtetra
.55231 .24313 .5586 .25094 .57051 .24667 .56426 .23883 Mtetra
.56426 .23883 .57051 .24667 .58247 .24238 .57625 .2345 Mtetra
.57625 .2345 .58247 .24238 .59448 .23808 .5883 .23016 Mtetra
.5883 .23016 .59448 .23808 .60655 .23376 .6004 .22581 Mtetra
.6004 .22581 .60655 .23376 .61866 .22941 .61255 .22143 Mtetra
.61255 .22143 .61866 .22941 .63083 .22506 .62475 .21704 Mtetra
.62475 .21704 .63083 .22506 .64305 .22068 .63701 .21262 Mtetra
.63701 .21262 .64305 .22068 .65533 .21628 .64932 .20819 Mtetra
.64932 .20819 .65533 .21628 .66766 .21187 .66169 .20374 Mtetra
.66169 .20374 .66766 .21187 .68004 .20744 .6741 .19927 Mtetra
.6741 .19927 .68004 .20744 .69247 .20299 .68658 .19479 Mtetra
.68658 .19479 .69247 .20299 .70496 .19851 .69911 .19028 Mtetra
.69911 .19028 .70496 .19851 .71751 .19402 .71169 .18575 Mtetra
.71169 .18575 .71751 .19402 .73011 .18952 .72433 .18121 Mtetra
.72433 .18121 .73011 .18952 .74277 .18499 .73703 .17664 Mtetra
.532 .685 .937 r
.06557 .40932 .073 .41672 .08022 .4333 .07521 .40824 Mtetra
.68 .525 .669 r
.07521 .40824 .08022 .4333 .09335 .40683 .08621 .39759 Mtetra
.491 .613 .9 r
.08621 .39759 .09335 .40683 .10318 .40481 .09579 .39753 Mtetra
.602 .716 .925 r
.09579 .39753 .10318 .40481 .11308 .40265 .10573 .39513 Mtetra
.518 .679 .938 r
.10573 .39513 .11308 .40265 .10839 .51789 .11553 .39427 Mtetra
.556 .34 .542 r
.11553 .39427 .10839 .51789 .13373 .3925 .12659 .38367 Mtetra
.526 .643 .907 r
.12659 .38367 .13373 .3925 .14378 .3902 .13646 .3829 Mtetra
.612 .722 .923 r
.13646 .3829 .14378 .3902 .1539 .38759 .1466 .38024 Mtetra
.589 .713 .929 r
.1466 .38024 .1539 .38759 .16375 .38781 .15674 .37804 Mtetra
.855 .718 .711 r
.15674 .37804 .16375 .38781 .17492 .37659 .16892 .35807 Mtetra
.122 .213 .686 r
.16892 .35807 .17492 .37659 .18506 .37496 .17784 .36744 Mtetra
.611 .718 .921 r
.17784 .36744 .18506 .37496 .19539 .37203 .18816 .36477 Mtetra
.626 .731 .923 r
.18816 .36477 .19539 .37203 .20576 .36913 .19857 .36173 Mtetra
.602 .72 .928 r
.19857 .36173 .20576 .36913 .21597 .36842 .20897 .35921 Mtetra
.915 .721 .626 r
.20897 .35921 .21597 .36842 .2272 .35743 .22327 .31652 Mtetra
0 0 .409 r
.22327 .31652 .2272 .35743 .23756 .35598 .23046 .34831 Mtetra
.614 .718 .92 r
.23046 .34831 .23756 .35598 .24813 .35283 .24101 .34552 Mtetra
.636 .737 .921 r
.24101 .34552 .24813 .35283 .25876 .34944 .25166 .34217 Mtetra
.64 .74 .922 r
.25166 .34217 .25876 .34944 .26944 .34604 .26237 .33871 Mtetra
.635 .738 .923 r
.26237 .33871 .26944 .34604 .28014 .34296 .27311 .33537 Mtetra
.595 .717 .929 r
.27311 .33537 .28014 .34296 .29055 .34438 .28383 .33293 Mtetra
.812 .7 .741 r
.28383 .33293 .29055 .34438 .30207 .33138 .29549 .31838 Mtetra
.376 .471 .829 r
.29549 .31838 .30207 .33138 .31284 .32902 .3059 .32134 Mtetra
.628 .728 .919 r
.3059 .32134 .31284 .32902 .32375 .32552 .31681 .31811 Mtetra
.646 .743 .92 r
.31681 .31811 .32375 .32552 .33472 .32176 .3278 .31442 Mtetra
.652 .748 .92 r
.3278 .31442 .33472 .32176 .34574 .31789 .33884 .31056 Mtetra
.655 .75 .92 r
.33884 .31056 .34574 .31789 .35681 .31393 .34994 .3066 Mtetra
.657 .752 .92 r
.34994 .3066 .35681 .31393 .36793 .30991 .36109 .30257 Mtetra
.658 .753 .92 r
.36109 .30257 .36793 .30991 .3791 .30586 .37228 .29849 Mtetra
.659 .754 .92 r
.37228 .29849 .3791 .30586 .39031 .30177 .38352 .29438 Mtetra
.38352 .29438 .39031 .30177 .40157 .29766 .39481 .29024 Mtetra
.39481 .29024 .40157 .29766 .41288 .29355 .40615 .28609 Mtetra
.40615 .28609 .41288 .29355 .42423 .28942 .41753 .28193 Mtetra
.658 .753 .92 r
.41753 .28193 .42423 .28942 .43563 .28528 .42897 .27775 Mtetra
.42897 .27775 .43563 .28528 .44708 .28113 .44044 .27357 Mtetra
.44044 .27357 .44708 .28113 .45857 .27697 .45197 .26937 Mtetra
.45197 .26937 .45857 .27697 .47012 .2728 .46355 .26516 Mtetra
.46355 .26516 .47012 .2728 .48171 .26861 .47517 .26094 Mtetra
.47517 .26094 .48171 .26861 .49335 .2644 .48685 .2567 Mtetra
.48685 .2567 .49335 .2644 .50504 .26018 .49857 .25244 Mtetra
.657 .753 .92 r
.49857 .25244 .50504 .26018 .51679 .25594 .51035 .24817 Mtetra
.51035 .24817 .51679 .25594 .52858 .25169 .52217 .24389 Mtetra
.657 .752 .92 r
.52217 .24389 .52858 .25169 .54042 .24742 .53405 .23958 Mtetra
.53405 .23958 .54042 .24742 .55231 .24313 .54597 .23526 Mtetra
.54597 .23526 .55231 .24313 .56426 .23883 .55795 .23092 Mtetra
.55795 .23092 .56426 .23883 .57625 .2345 .56998 .22656 Mtetra
.56998 .22656 .57625 .2345 .5883 .23016 .58206 .22219 Mtetra
.58206 .22219 .5883 .23016 .6004 .22581 .5942 .21779 Mtetra
.5942 .21779 .6004 .22581 .61255 .22143 .60638 .21338 Mtetra
.60638 .21338 .61255 .22143 .62475 .21704 .61862 .20895 Mtetra
.61862 .20895 .62475 .21704 .63701 .21262 .63092 .2045 Mtetra
.63092 .2045 .63701 .21262 .64932 .20819 .64326 .20004 Mtetra
.64326 .20004 .64932 .20819 .66169 .20374 .65567 .19555 Mtetra
.65567 .19555 .66169 .20374 .6741 .19927 .66812 .19104 Mtetra
.66812 .19104 .6741 .19927 .68658 .19479 .68064 .18652 Mtetra
.68064 .18652 .68658 .19479 .69911 .19028 .6932 .18198 Mtetra
.6932 .18198 .69911 .19028 .71169 .18575 .70583 .17741 Mtetra
.70583 .17741 .71169 .18575 .72433 .18121 .7185 .17283 Mtetra
.7185 .17283 .72433 .18121 .73703 .17664 .73124 .16822 Mtetra
.587 .71 .928 r
.05808 .402 .06557 .40932 .07521 .40824 .06787 .39991 Mtetra
.855 .413 0 r
.06787 .39991 .07521 .40824 .08621 .39759 .07511 .4165 Mtetra
.799 .886 .462 r
.07511 .4165 .08621 .39759 .09579 .39753 .08839 .38987 Mtetra
.586 .701 .922 r
.08839 .38987 .09579 .39753 .10573 .39513 .09831 .38779 Mtetra
.592 .713 .928 r
.09831 .38779 .10573 .39513 .11553 .39427 .10829 .38557 Mtetra
.95 .665 .463 r
.10829 .38557 .11553 .39427 .12659 .38367 .10336 .50127 Mtetra
0 0 0 r
.10336 .50127 .12659 .38367 .13646 .3829 .12912 .37527 Mtetra
.598 .708 .921 r
.12912 .37527 .13646 .3829 .1466 .38024 .13924 .37291 Mtetra
.611 .723 .925 r
.13924 .37291 .1466 .38024 .15674 .37804 .14946 .37023 Mtetra
.449 .644 .941 r
.14946 .37023 .15674 .37804 .16892 .35807 .15939 .3704 Mtetra
0 0 0 r
.15939 .3704 .16892 .35807 .17784 .36744 .17066 .35907 Mtetra
.566 .677 .914 r
.17066 .35907 .17784 .36744 .18816 .36477 .18089 .35738 Mtetra
.623 .728 .922 r
.18089 .35738 .18816 .36477 .19857 .36173 .19131 .35438 Mtetra
.621 .73 .924 r
.19131 .35438 .19857 .36173 .20897 .35921 .20177 .35142 Mtetra
.509 .673 .938 r
.20177 .35142 .20897 .35921 .22327 .31652 .21206 .35065 Mtetra
.28 0 .264 r
.21206 .35065 .22327 .31652 .23046 .34831 .2234 .33956 Mtetra
.557 .666 .91 r
.2234 .33956 .23046 .34831 .24101 .34552 .23385 .33804 Mtetra
.63 .732 .921 r
.23385 .33804 .24101 .34552 .25166 .34217 .24451 .33482 Mtetra
.639 .74 .921 r
.24451 .33482 .25166 .34217 .26237 .33871 .25524 .33136 Mtetra
.639 .74 .922 r
.25524 .33136 .26237 .33871 .27311 .33537 .26601 .32789 Mtetra
.625 .733 .924 r
.26601 .32789 .27311 .33537 .28383 .33293 .27681 .32473 Mtetra
.368 .596 .934 r
.27681 .32473 .28383 .33293 .29549 .31838 .28731 .3261 Mtetra
.638 .896 .573 r
.28731 .3261 .29549 .31838 .3059 .32134 .29894 .31299 Mtetra
.594 .697 .915 r
.29894 .31299 .3059 .32134 .31681 .31811 .30982 .31056 Mtetra
.64 .739 .92 r
.30982 .31056 .31681 .31811 .3278 .31442 .32082 .30698 Mtetra
.649 .746 .92 r
.32082 .30698 .3278 .31442 .33884 .31056 .33189 .30315 Mtetra
.653 .749 .92 r
.33189 .30315 .33884 .31056 .34994 .3066 .34302 .2992 Mtetra
.656 .751 .92 r
.34302 .2992 .34994 .3066 .36109 .30257 .35419 .29516 Mtetra
.658 .753 .92 r
.35419 .29516 .36109 .30257 .37228 .29849 .36541 .29107 Mtetra
.659 .753 .92 r
.36541 .29107 .37228 .29849 .38352 .29438 .37669 .28693 Mtetra
.659 .754 .92 r
.37669 .28693 .38352 .29438 .39481 .29024 .38801 .28276 Mtetra
.38801 .28276 .39481 .29024 .40615 .28609 .39937 .27857 Mtetra
.39937 .27857 .40615 .28609 .41753 .28193 .41079 .27438 Mtetra
.659 .753 .92 r
.41079 .27438 .41753 .28193 .42897 .27775 .42225 .27017 Mtetra
.658 .753 .92 r
.42225 .27017 .42897 .27775 .44044 .27357 .43376 .26595 Mtetra
.43376 .26595 .44044 .27357 .45197 .26937 .44532 .26172 Mtetra
.44532 .26172 .45197 .26937 .46355 .26516 .45693 .25747 Mtetra
.45693 .25747 .46355 .26516 .47517 .26094 .46858 .25321 Mtetra
.46858 .25321 .47517 .26094 .48685 .2567 .48029 .24894 Mtetra
.48029 .24894 .48685 .2567 .49857 .25244 .49205 .24465 Mtetra
.657 .753 .92 r
.49205 .24465 .49857 .25244 .51035 .24817 .50385 .24034 Mtetra
.50385 .24034 .51035 .24817 .52217 .24389 .51571 .23602 Mtetra
.51571 .23602 .52217 .24389 .53405 .23958 .52762 .23168 Mtetra
.657 .752 .92 r
.52762 .23168 .53405 .23958 .54597 .23526 .53958 .22732 Mtetra
.53958 .22732 .54597 .23526 .55795 .23092 .55159 .22295 Mtetra
.55159 .22295 .55795 .23092 .56998 .22656 .56366 .21856 Mtetra
.56366 .21856 .56998 .22656 .58206 .22219 .57577 .21414 Mtetra
.57577 .21414 .58206 .22219 .5942 .21779 .58794 .20972 Mtetra
.58794 .20972 .5942 .21779 .60638 .21338 .60017 .20527 Mtetra
.60017 .20527 .60638 .21338 .61862 .20895 .61244 .2008 Mtetra
.61244 .2008 .61862 .20895 .63092 .2045 .62477 .19632 Mtetra
.62477 .19632 .63092 .2045 .64326 .20004 .63716 .19181 Mtetra
.63716 .19181 .64326 .20004 .65567 .19555 .6496 .18729 Mtetra
.6496 .18729 .65567 .19555 .66812 .19104 .66209 .18275 Mtetra
.66209 .18275 .66812 .19104 .68064 .18652 .67464 .17819 Mtetra
.67464 .17819 .68064 .18652 .6932 .18198 .68725 .1736 Mtetra
.68725 .1736 .6932 .18198 .70583 .17741 .69991 .169 Mtetra
.69991 .169 .70583 .17741 .7185 .17283 .71263 .16438 Mtetra
.71263 .16438 .7185 .17283 .73124 .16822 .7254 .15974 Mtetra
.586 .704 .924 r
.05056 .39445 .05808 .402 .06787 .39991 .06036 .39238 Mtetra
.532 .685 .937 r
.06036 .39238 .06787 .39991 .07511 .4165 .07007 .39125 Mtetra
.679 .524 .669 r
.07007 .39125 .07511 .4165 .08839 .38987 .08117 .38049 Mtetra
.49 .613 .9 r
.08117 .38049 .08839 .38987 .09831 .38779 .09083 .38038 Mtetra
.602 .716 .925 r
.09083 .38038 .09831 .38779 .10829 .38557 .10085 .37792 Mtetra
.518 .679 .938 r
.10085 .37792 .10829 .38557 .10336 .50127 .11073 .37701 Mtetra
.553 .336 .54 r
.11073 .37701 .10336 .50127 .12912 .37527 .12189 .36631 Mtetra
.526 .643 .907 r
.12189 .36631 .12912 .37527 .13924 .37291 .13184 .36548 Mtetra
.612 .722 .923 r
.13184 .36548 .13924 .37291 .14946 .37023 .14207 .36274 Mtetra
.59 .713 .929 r
.14207 .36274 .14946 .37023 .15939 .3704 .1523 .36048 Mtetra
.856 .719 .71 r
.1523 .36048 .15939 .3704 .17066 .35907 .1646 .34038 Mtetra
.118 .211 .685 r
.1646 .34038 .17066 .35907 .18089 .35738 .17359 .34973 Mtetra
.611 .718 .921 r
.17359 .34973 .18089 .35738 .19131 .35438 .184 .34699 Mtetra
.626 .731 .923 r
.184 .34699 .19131 .35438 .20177 .35142 .19449 .34389 Mtetra
.602 .72 .928 r
.19449 .34389 .20177 .35142 .21206 .35065 .20498 .3413 Mtetra
.916 .721 .625 r
.20498 .3413 .21206 .35065 .2234 .33956 .21946 .29838 Mtetra
0 0 .405 r
.21946 .29838 .2234 .33956 .23385 .33804 .22666 .33024 Mtetra
.614 .718 .92 r
.22666 .33024 .23385 .33804 .24451 .33482 .23731 .32737 Mtetra
.636 .737 .921 r
.23731 .32737 .24451 .33482 .25524 .33136 .24806 .32395 Mtetra
.64 .74 .922 r
.24806 .32395 .25524 .33136 .26601 .32789 .25886 .32042 Mtetra
.635 .738 .923 r
.25886 .32042 .26601 .32789 .27681 .32473 .2697 .317 Mtetra
.595 .717 .929 r
.2697 .317 .27681 .32473 .28731 .3261 .28052 .31449 Mtetra
.813 .701 .741 r
.28052 .31449 .28731 .3261 .29894 .31299 .29229 .29983 Mtetra
.375 .47 .829 r
.29229 .29983 .29894 .31299 .30982 .31056 .30279 .30274 Mtetra
.628 .728 .919 r
.30279 .30274 .30982 .31056 .32082 .30698 .3138 .29943 Mtetra
.646 .743 .92 r
.3138 .29943 .32082 .30698 .33189 .30315 .32489 .29566 Mtetra
.652 .748 .92 r
.32489 .29566 .33189 .30315 .34302 .2992 .33604 .29172 Mtetra
.655 .75 .92 r
.33604 .29172 .34302 .2992 .35419 .29516 .34724 .28768 Mtetra
.657 .752 .92 r
.34724 .28768 .35419 .29516 .36541 .29107 .35849 .28357 Mtetra
.658 .753 .92 r
.35849 .28357 .36541 .29107 .37669 .28693 .36979 .27941 Mtetra
.659 .754 .92 r
.36979 .27941 .37669 .28693 .38801 .28276 .38114 .27522 Mtetra
.38114 .27522 .38801 .28276 .39937 .27857 .39254 .271 Mtetra
.39254 .271 .39937 .27857 .41079 .27438 .40399 .26677 Mtetra
.40399 .26677 .41079 .27438 .42225 .27017 .41548 .26252 Mtetra
.658 .753 .92 r
.41548 .26252 .42225 .27017 .43376 .26595 .42702 .25827 Mtetra
.42702 .25827 .43376 .26595 .44532 .26172 .43861 .254 Mtetra
.43861 .254 .44532 .26172 .45693 .25747 .45025 .24972 Mtetra
.45025 .24972 .45693 .25747 .46858 .25321 .46194 .24543 Mtetra
.46194 .24543 .46858 .25321 .48029 .24894 .47368 .24112 Mtetra
.47368 .24112 .48029 .24894 .49205 .24465 .48547 .23679 Mtetra
.48547 .23679 .49205 .24465 .50385 .24034 .49731 .23245 Mtetra
.657 .753 .92 r
.49731 .23245 .50385 .24034 .51571 .23602 .5092 .22809 Mtetra
.5092 .22809 .51571 .23602 .52762 .23168 .52114 .22372 Mtetra
.657 .752 .92 r
.52114 .22372 .52762 .23168 .53958 .22732 .53314 .21932 Mtetra
.53314 .21932 .53958 .22732 .55159 .22295 .54519 .21491 Mtetra
.54519 .21491 .55159 .22295 .56366 .21856 .55729 .21048 Mtetra
.55729 .21048 .56366 .21856 .57577 .21414 .56944 .20604 Mtetra
.56944 .20604 .57577 .21414 .58794 .20972 .58164 .20157 Mtetra
.58164 .20157 .58794 .20972 .60017 .20527 .5939 .19709 Mtetra
.5939 .19709 .60017 .20527 .61244 .2008 .60621 .19259 Mtetra
.60621 .19259 .61244 .2008 .62477 .19632 .61858 .18806 Mtetra
.61858 .18806 .62477 .19632 .63716 .19181 .631 .18352 Mtetra
.631 .18352 .63716 .19181 .6496 .18729 .64348 .17896 Mtetra
.64348 .17896 .6496 .18729 .66209 .18275 .65601 .17438 Mtetra
.65601 .17438 .66209 .18275 .67464 .17819 .6686 .16978 Mtetra
.6686 .16978 .67464 .17819 .68725 .1736 .68125 .16516 Mtetra
.68125 .16516 .68725 .1736 .69991 .169 .69395 .16052 Mtetra
.69395 .16052 .69991 .169 .71263 .16438 .70671 .15586 Mtetra
.70671 .15586 .71263 .16438 .7254 .15974 .71952 .15118 Mtetra
.529 .652 .913 r
.04313 .38587 .05056 .39445 .06036 .39238 .05277 .38493 Mtetra
.587 .71 .928 r
.05277 .38493 .06036 .39238 .07007 .39125 .06264 .38278 Mtetra
.852 .409 0 r
.06264 .38278 .07007 .39125 .08117 .38049 .06991 .39939 Mtetra
.806 .89 .47 r
.06991 .39939 .08117 .38049 .09083 .38038 .08334 .3726 Mtetra
.586 .701 .922 r
.08334 .3726 .09083 .38038 .10085 .37792 .09334 .37045 Mtetra
.592 .713 .928 r
.09334 .37045 .10085 .37792 .11073 .37701 .1034 .36816 Mtetra
.951 .665 .46 r
.1034 .36816 .11073 .37701 .12189 .36631 .09823 .48431 Mtetra
0 0 0 r
.09823 .48431 .12189 .36631 .13184 .36548 .12442 .35771 Mtetra
.597 .708 .921 r
.12442 .35771 .13184 .36548 .14207 .36274 .13463 .35529 Mtetra
.611 .723 .925 r
.13463 .35529 .14207 .36274 .1523 .36048 .14493 .35254 Mtetra
.449 .644 .94 r
.14493 .35254 .1523 .36048 .1646 .34038 .15494 .35265 Mtetra
0 0 0 r
.15494 .35265 .1646 .34038 .17359 .34973 .16632 .34122 Mtetra
.566 .677 .914 r
.16632 .34122 .17359 .34973 .184 .34699 .17664 .33947 Mtetra
.623 .728 .922 r
.17664 .33947 .184 .34699 .19449 .34389 .18715 .3364 Mtetra
.621 .73 .924 r
.18715 .3364 .19449 .34389 .20498 .3413 .1977 .33336 Mtetra
.509 .673 .938 r
.1977 .33336 .20498 .3413 .21946 .29838 .20808 .33253 Mtetra
.27 0 .254 r
.20808 .33253 .21946 .29838 .22666 .33024 .21953 .32134 Mtetra
.557 .666 .91 r
.21953 .32134 .22666 .33024 .23731 .32737 .23007 .31976 Mtetra
.63 .732 .921 r
.23007 .31976 .23731 .32737 .24806 .32395 .24082 .31646 Mtetra
.639 .74 .921 r
.24082 .31646 .24806 .32395 .25886 .32042 .25165 .31292 Mtetra
.639 .74 .922 r
.25165 .31292 .25886 .32042 .2697 .317 .26252 .30938 Mtetra
.625 .733 .924 r
.26252 .30938 .2697 .317 .28052 .31449 .27342 .30615 Mtetra
.37 .596 .934 r
.27342 .30615 .28052 .31449 .29229 .29983 .28401 .30746 Mtetra
.648 .904 .583 r
.28401 .30746 .29229 .29983 .30279 .30274 .29575 .29424 Mtetra
.594 .697 .915 r
.29575 .29424 .30279 .30274 .3138 .29943 .30673 .29173 Mtetra
.64 .739 .92 r
.30673 .29173 .3138 .29943 .32489 .29566 .31784 .28808 Mtetra
.649 .746 .92 r
.31784 .28808 .32489 .29566 .33604 .29172 .32901 .28417 Mtetra
.653 .749 .92 r
.32901 .28417 .33604 .29172 .34724 .28768 .34024 .28013 Mtetra
.656 .751 .92 r
.34024 .28013 .34724 .28768 .35849 .28357 .35152 .27602 Mtetra
.658 .753 .92 r
.35152 .27602 .35849 .28357 .36979 .27941 .36285 .27184 Mtetra
.659 .753 .92 r
.36285 .27184 .36979 .27941 .38114 .27522 .37423 .26762 Mtetra
.659 .754 .92 r
.37423 .26762 .38114 .27522 .39254 .271 .38566 .26337 Mtetra
.38566 .26337 .39254 .271 .40399 .26677 .39713 .2591 Mtetra
.39713 .2591 .40399 .26677 .41548 .26252 .40866 .25482 Mtetra
.659 .753 .92 r
.40866 .25482 .41548 .26252 .42702 .25827 .42023 .25053 Mtetra
.658 .753 .92 r
.42023 .25053 .42702 .25827 .43861 .254 .43185 .24622 Mtetra
.43185 .24622 .43861 .254 .45025 .24972 .44352 .24191 Mtetra
.44352 .24191 .45025 .24972 .46194 .24543 .45524 .23758 Mtetra
.45524 .23758 .46194 .24543 .47368 .24112 .46702 .23323 Mtetra
.46702 .23323 .47368 .24112 .48547 .23679 .47884 .22887 Mtetra
.47884 .22887 .48547 .23679 .49731 .23245 .49071 .22449 Mtetra
.657 .753 .92 r
.49071 .22449 .49731 .23245 .5092 .22809 .50264 .2201 Mtetra
.50264 .2201 .5092 .22809 .52114 .22372 .51462 .21569 Mtetra
.51462 .21569 .52114 .22372 .53314 .21932 .52664 .21126 Mtetra
.657 .752 .92 r
.52664 .21126 .53314 .21932 .54519 .21491 .53873 .20681 Mtetra
.53873 .20681 .54519 .21491 .55729 .21048 .55086 .20235 Mtetra
.55086 .20235 .55729 .21048 .56944 .20604 .56305 .19786 Mtetra
.56305 .19786 .56944 .20604 .58164 .20157 .57529 .19336 Mtetra
.57529 .19336 .58164 .20157 .5939 .19709 .58758 .18884 Mtetra
.58758 .18884 .5939 .19709 .60621 .19259 .59993 .1843 Mtetra
.59993 .1843 .60621 .19259 .61858 .18806 .61234 .17974 Mtetra
.61234 .17974 .61858 .18806 .631 .18352 .6248 .17516 Mtetra
.6248 .17516 .631 .18352 .64348 .17896 .63731 .17057 Mtetra
.63731 .17057 .64348 .17896 .65601 .17438 .64988 .16595 Mtetra
.64988 .16595 .65601 .17438 .6686 .16978 .66251 .16131 Mtetra
.66251 .16131 .6686 .16978 .68125 .16516 .67519 .15665 Mtetra
.67519 .15665 .68125 .16516 .69395 .16052 .68793 .15197 Mtetra
.68793 .15197 .69395 .16052 .70671 .15586 .70073 .14727 Mtetra
.70073 .14727 .70671 .15586 .71952 .15118 .71359 .14255 Mtetra
0 0 .268 r
.04106 .34189 .04313 .38587 .05277 .38493 .04516 .37726 Mtetra
.586 .704 .924 r
.04516 .37726 .05277 .38493 .06264 .38278 .05504 .37512 Mtetra
.533 .685 .936 r
.05504 .37512 .06264 .38278 .06991 .39939 .06483 .37393 Mtetra
.679 .524 .668 r
.06483 .37393 .06991 .39939 .08334 .3726 .07604 .36308 Mtetra
.49 .613 .9 r
.07604 .36308 .08334 .3726 .09334 .37045 .08577 .36291 Mtetra
.602 .716 .925 r
.08577 .36291 .09334 .37045 .1034 .36816 .09588 .36038 Mtetra
.518 .679 .938 r
.09588 .36038 .1034 .36816 .09823 .48431 .10583 .35941 Mtetra
.55 .332 .537 r
.10583 .35941 .09823 .48431 .12442 .35771 .11711 .34861 Mtetra
.525 .643 .907 r
.11711 .34861 .12442 .35771 .13463 .35529 .12714 .34772 Mtetra
.612 .722 .923 r
.12714 .34772 .13463 .35529 .14493 .35254 .13746 .34492 Mtetra
.59 .713 .929 r
.13746 .34492 .14493 .35254 .15494 .35265 .14777 .34259 Mtetra
.857 .72 .71 r
.14777 .34259 .15494 .35265 .16632 .34122 .16021 .32235 Mtetra
.114 .208 .684 r
.16021 .32235 .16632 .34122 .17664 .33947 .16925 .33168 Mtetra
.611 .718 .921 r
.16925 .33168 .17664 .33947 .18715 .3364 .17975 .32887 Mtetra
.626 .731 .923 r
.17975 .32887 .18715 .3364 .1977 .33336 .19033 .32569 Mtetra
.602 .72 .928 r
.19033 .32569 .1977 .33336 .20808 .33253 .20091 .32303 Mtetra
.917 .722 .624 r
.20091 .32303 .20808 .33253 .21953 .32134 .21558 .27989 Mtetra
0 0 .4 r
.21558 .27989 .21953 .32134 .23007 .31976 .2228 .31181 Mtetra
.614 .718 .92 r
.2228 .31181 .23007 .31976 .24082 .31646 .23354 .30887 Mtetra
.636 .737 .921 r
.23354 .30887 .24082 .31646 .25165 .31292 .24438 .30537 Mtetra
.64 .74 .922 r
.24438 .30537 .25165 .31292 .26252 .30938 .25528 .30177 Mtetra
.635 .738 .923 r
.25528 .30177 .26252 .30938 .27342 .30615 .26622 .29827 Mtetra
.595 .717 .929 r
.26622 .29827 .27342 .30615 .28401 .30746 .27714 .29568 Mtetra
.813 .701 .741 r
.27714 .29568 .28401 .30746 .29575 .29424 .28903 .2809 Mtetra
.374 .469 .83 r
.28903 .2809 .29575 .29424 .30673 .29173 .29962 .28376 Mtetra
.628 .728 .919 r
.29962 .28376 .30673 .29173 .31784 .28808 .31073 .28038 Mtetra
.646 .743 .92 r
.31073 .28038 .31784 .28808 .32901 .28417 .32193 .27653 Mtetra
.652 .748 .92 r
.32193 .27653 .32901 .28417 .34024 .28013 .33318 .27251 Mtetra
.655 .75 .92 r
.33318 .27251 .34024 .28013 .35152 .27602 .34449 .26839 Mtetra
.657 .752 .92 r
.34449 .26839 .35152 .27602 .36285 .27184 .35585 .2642 Mtetra
.658 .753 .92 r
.35585 .2642 .36285 .27184 .37423 .26762 .36726 .25996 Mtetra
.659 .754 .92 r
.36726 .25996 .37423 .26762 .38566 .26337 .37872 .25568 Mtetra
.37872 .25568 .38566 .26337 .39713 .2591 .39022 .25137 Mtetra
.39022 .25137 .39713 .2591 .40866 .25482 .40178 .24706 Mtetra
.40178 .24706 .40866 .25482 .42023 .25053 .41338 .24273 Mtetra
.658 .753 .92 r
.41338 .24273 .42023 .25053 .43185 .24622 .42504 .23838 Mtetra
.42504 .23838 .43185 .24622 .44352 .24191 .43674 .23403 Mtetra
.43674 .23403 .44352 .24191 .45524 .23758 .4485 .22966 Mtetra
.4485 .22966 .45524 .23758 .46702 .23323 .4603 .22528 Mtetra
.4603 .22528 .46702 .23323 .47884 .22887 .47216 .22089 Mtetra
.47216 .22089 .47884 .22887 .49071 .22449 .48406 .21647 Mtetra
.48406 .21647 .49071 .22449 .50264 .2201 .49602 .21204 Mtetra
.657 .753 .92 r
.49602 .21204 .50264 .2201 .51462 .21569 .50803 .2076 Mtetra
.50803 .2076 .51462 .21569 .52664 .21126 .5201 .20313 Mtetra
.657 .752 .92 r
.5201 .20313 .52664 .21126 .53873 .20681 .53221 .19865 Mtetra
.53221 .19865 .53873 .20681 .55086 .20235 .54438 .19415 Mtetra
.54438 .19415 .55086 .20235 .56305 .19786 .55661 .18962 Mtetra
.55661 .18962 .56305 .19786 .57529 .19336 .56888 .18509 Mtetra
.56888 .18509 .57529 .19336 .58758 .18884 .58122 .18053 Mtetra
.58122 .18053 .58758 .18884 .59993 .1843 .5936 .17595 Mtetra
.5936 .17595 .59993 .1843 .61234 .17974 .60604 .17135 Mtetra
.60604 .17135 .61234 .17974 .6248 .17516 .61854 .16674 Mtetra
.61854 .16674 .6248 .17516 .63731 .17057 .63109 .1621 Mtetra
.63109 .1621 .63731 .17057 .64988 .16595 .6437 .15744 Mtetra
.6437 .15744 .64988 .16595 .66251 .16131 .65637 .15277 Mtetra
.65637 .15277 .66251 .16131 .67519 .15665 .66909 .14807 Mtetra
.66909 .14807 .67519 .15665 .68793 .15197 .68187 .14335 Mtetra
.68187 .14335 .68793 .15197 .70073 .14727 .69471 .13861 Mtetra
.69471 .13861 .70073 .14727 .71359 .14255 .7076 .13385 Mtetra
.277 0 .256 r
.02649 .37914 .04106 .34189 .04516 .37726 .03765 .36854 Mtetra
.529 .653 .914 r
.03765 .36854 .04516 .37726 .05504 .37512 .04737 .36754 Mtetra
.587 .71 .928 r
.04737 .36754 .05504 .37512 .06483 .37393 .05732 .36533 Mtetra
.849 .405 0 r
.05732 .36533 .06483 .37393 .07604 .36308 .06461 .38194 Mtetra
.812 .894 .477 r
.06461 .38194 .07604 .36308 .08577 .36291 .0782 .35499 Mtetra
.586 .701 .922 r
.0782 .35499 .08577 .36291 .09588 .36038 .08827 .35278 Mtetra
.592 .713 .928 r
.08827 .35278 .09588 .36038 .10583 .35941 .09842 .35042 Mtetra
.952 .665 .457 r
.09842 .35042 .10583 .35941 .11711 .34861 .093 .46702 Mtetra
0 0 0 r
.093 .46702 .11711 .34861 .12714 .34772 .11963 .33981 Mtetra
.597 .708 .921 r
.11963 .33981 .12714 .34772 .13746 .34492 .12992 .33733 Mtetra
.611 .723 .925 r
.12992 .33733 .13746 .34492 .14777 .34259 .14031 .33451 Mtetra
.45 .644 .94 r
.14031 .33451 .14777 .34259 .16021 .32235 .1504 .33456 Mtetra
0 0 0 r
.1504 .33456 .16021 .32235 .16925 .33168 .1619 .32303 Mtetra
.566 .678 .914 r
.1619 .32303 .16925 .33168 .17975 .32887 .1723 .32121 Mtetra
.623 .728 .922 r
.1723 .32121 .17975 .32887 .19033 .32569 .1829 .31806 Mtetra
.621 .73 .924 r
.1829 .31806 .19033 .32569 .20091 .32303 .19355 .31495 Mtetra
.51 .673 .938 r
.19355 .31495 .20091 .32303 .21558 .27989 .20402 .31406 Mtetra
.26 0 .243 r
.20402 .31406 .21558 .27989 .2228 .31181 .21558 .30276 Mtetra
.557 .666 .91 r
.21558 .30276 .2228 .31181 .23354 .30887 .22621 .30111 Mtetra
.63 .732 .921 r
.22621 .30111 .23354 .30887 .24438 .30537 .23707 .29774 Mtetra
.639 .74 .921 r
.23707 .29774 .24438 .30537 .25528 .30177 .24799 .29412 Mtetra
.639 .74 .922 r
.24799 .29412 .25528 .30177 .26622 .29827 .25896 .2905 Mtetra
.625 .733 .924 r
.25896 .2905 .26622 .29827 .27714 .29568 .26995 .2872 Mtetra
.371 .597 .934 r
.26995 .2872 .27714 .29568 .28903 .2809 .28064 .28845 Mtetra
.658 .911 .594 r
.28064 .28845 .28903 .2809 .29962 .28376 .2925 .27511 Mtetra
.594 .697 .915 r
.2925 .27511 .29962 .28376 .31073 .28038 .30358 .27253 Mtetra
.64 .739 .92 r
.30358 .27253 .31073 .28038 .32193 .27653 .31479 .26879 Mtetra
.649 .746 .92 r
.31479 .26879 .32193 .27653 .33318 .27251 .32607 .2648 Mtetra
.653 .749 .92 r
.32607 .2648 .33318 .27251 .34449 .26839 .33741 .26069 Mtetra
.656 .751 .92 r
.33741 .26069 .34449 .26839 .35585 .2642 .34879 .25649 Mtetra
.658 .753 .92 r
.34879 .25649 .35585 .2642 .36726 .25996 .36023 .25223 Mtetra
.659 .753 .92 r
.36023 .25223 .36726 .25996 .37872 .25568 .37172 .24792 Mtetra
.659 .754 .92 r
.37172 .24792 .37872 .25568 .39022 .25137 .38326 .24359 Mtetra
.38326 .24359 .39022 .25137 .40178 .24706 .39484 .23923 Mtetra
.39484 .23923 .40178 .24706 .41338 .24273 .40648 .23486 Mtetra
.659 .753 .92 r
.40648 .23486 .41338 .24273 .42504 .23838 .41817 .23049 Mtetra
.658 .753 .92 r
.41817 .23049 .42504 .23838 .43674 .23403 .4299 .22609 Mtetra
.4299 .22609 .43674 .23403 .4485 .22966 .44169 .22169 Mtetra
.44169 .22169 .4485 .22966 .4603 .22528 .45353 .21727 Mtetra
.45353 .21727 .4603 .22528 .47216 .22089 .46542 .21284 Mtetra
.46542 .21284 .47216 .22089 .48406 .21647 .47736 .20839 Mtetra
.47736 .20839 .48406 .21647 .49602 .21204 .48935 .20392 Mtetra
.657 .753 .92 r
.48935 .20392 .49602 .21204 .50803 .2076 .5014 .19944 Mtetra
.5014 .19944 .50803 .2076 .5201 .20313 .5135 .19494 Mtetra
.5135 .19494 .5201 .20313 .53221 .19865 .52565 .19041 Mtetra
.657 .752 .92 r
.52565 .19041 .53221 .19865 .54438 .19415 .53785 .18588 Mtetra
.53785 .18588 .54438 .19415 .55661 .18962 .55011 .18132 Mtetra
.55011 .18132 .55661 .18962 .56888 .18509 .56243 .17674 Mtetra
.56243 .17674 .56888 .18509 .58122 .18053 .57479 .17215 Mtetra
.57479 .17215 .58122 .18053 .5936 .17595 .58722 .16753 Mtetra
.58722 .16753 .5936 .17595 .60604 .17135 .5997 .16289 Mtetra
.5997 .16289 .60604 .17135 .61854 .16674 .61223 .15824 Mtetra
.61223 .15824 .61854 .16674 .63109 .1621 .62482 .15356 Mtetra
.62482 .15356 .63109 .1621 .6437 .15744 .63747 .14887 Mtetra
.63747 .14887 .6437 .15744 .65637 .15277 .65017 .14415 Mtetra
.65017 .14415 .65637 .15277 .66909 .14807 .66294 .13942 Mtetra
.66294 .13942 .66909 .14807 .68187 .14335 .67575 .13466 Mtetra
.67575 .13466 .68187 .14335 .69471 .13861 .68863 .12988 Mtetra
.68863 .12988 .69471 .13861 .7076 .13385 .70157 .12508 Mtetra
.903 .71 .631 r
.01898 .36988 .02649 .37914 .03765 .36854 .03561 .32428 Mtetra
0 0 .262 r
.03561 .32428 .03765 .36854 .04737 .36754 .03966 .35973 Mtetra
.586 .704 .924 r
.03966 .35973 .04737 .36754 .05732 .36533 .04962 .35753 Mtetra
.533 .685 .936 r
.04962 .35753 .05732 .36533 .06461 .38194 .05949 .35628 Mtetra
.679 .523 .668 r
.05949 .35628 .06461 .38194 .0782 .35499 .07081 .34533 Mtetra
.49 .613 .901 r
.07081 .34533 .0782 .35499 .08827 .35278 .08062 .3451 Mtetra
.602 .716 .925 r
.08062 .3451 .08827 .35278 .09842 .35042 .09081 .34251 Mtetra
.519 .679 .938 r
.09081 .34251 .09842 .35042 .093 .46702 .10085 .34147 Mtetra
.548 .328 .534 r
.10085 .34147 .093 .46702 .11963 .33981 .11223 .33057 Mtetra
.525 .643 .908 r
.11223 .33057 .11963 .33981 .12992 .33733 .12234 .32962 Mtetra
.612 .722 .923 r
.12234 .32962 .12992 .33733 .14031 .33451 .13275 .32675 Mtetra
.59 .713 .929 r
.13275 .32675 .14031 .33451 .1504 .33456 .14315 .32435 Mtetra
.858 .721 .71 r
.14315 .32435 .1504 .33456 .1619 .32303 .15572 .30397 Mtetra
.111 .205 .683 r
.15572 .30397 .1619 .32303 .1723 .32121 .16482 .31327 Mtetra
.611 .718 .921 r
.16482 .31327 .1723 .32121 .1829 .31806 .17542 .31039 Mtetra
.626 .731 .923 r
.17542 .31039 .1829 .31806 .19355 .31495 .1861 .30714 Mtetra
.602 .72 .927 r
.1861 .30714 .19355 .31495 .20402 .31406 .19677 .30441 Mtetra
.918 .723 .623 r
.19677 .30441 .20402 .31406 .21558 .30276 .21162 .26105 Mtetra
0 0 .395 r
.21162 .26105 .21558 .30276 .22621 .30111 .21886 .29301 Mtetra
.614 .718 .92 r
.21886 .29301 .22621 .30111 .23707 .29774 .2297 .29 Mtetra
.636 .737 .921 r
.2297 .29 .23707 .29774 .24799 .29412 .24064 .28642 Mtetra
.64 .74 .922 r
.24064 .28642 .24799 .29412 .25896 .2905 .25164 .28274 Mtetra
.635 .738 .923 r
.25164 .28274 .25896 .2905 .26995 .2872 .26268 .27917 Mtetra
.595 .717 .929 r
.26268 .27917 .26995 .2872 .28064 .28845 .27369 .27651 Mtetra
.814 .702 .742 r
.27369 .27651 .28064 .28845 .2925 .27511 .28571 .26161 Mtetra
.372 .469 .83 r
.28571 .26161 .2925 .27511 .30358 .27253 .29639 .2644 Mtetra
.628 .728 .919 r
.29639 .2644 .30358 .27253 .31479 .26879 .30761 .26094 Mtetra
.646 .743 .92 r
.30761 .26094 .31479 .26879 .32607 .2648 .31891 .25701 Mtetra
.652 .748 .92 r
.31891 .25701 .32607 .2648 .33741 .26069 .33027 .25291 Mtetra
.655 .75 .92 r
.33027 .25291 .33741 .26069 .34879 .25649 .34168 .2487 Mtetra
.657 .752 .92 r
.34168 .2487 .34879 .25649 .36023 .25223 .35315 .24443 Mtetra
.658 .753 .92 r
.35315 .24443 .36023 .25223 .37172 .24792 .36467 .2401 Mtetra
.659 .754 .92 r
.36467 .2401 .37172 .24792 .38326 .24359 .37624 .23574 Mtetra
.37624 .23574 .38326 .24359 .39484 .23923 .38786 .23135 Mtetra
.38786 .23135 .39484 .23923 .40648 .23486 .39952 .22694 Mtetra
.39952 .22694 .40648 .23486 .41817 .23049 .41124 .22252 Mtetra
.658 .753 .92 r
.41124 .22252 .41817 .23049 .4299 .22609 .42301 .2181 Mtetra
.42301 .2181 .4299 .22609 .44169 .22169 .43483 .21365 Mtetra
.43483 .21365 .44169 .22169 .45353 .21727 .4467 .2092 Mtetra
.4467 .2092 .45353 .21727 .46542 .21284 .45863 .20473 Mtetra
.45863 .20473 .46542 .21284 .47736 .20839 .4706 .20024 Mtetra
.4706 .20024 .47736 .20839 .48935 .20392 .48263 .19573 Mtetra
.48263 .19573 .48935 .20392 .5014 .19944 .49471 .19121 Mtetra
.657 .753 .92 r
.49471 .19121 .5014 .19944 .5135 .19494 .50684 .18667 Mtetra
.50684 .18667 .5135 .19494 .52565 .19041 .51903 .18212 Mtetra
.657 .752 .92 r
.51903 .18212 .52565 .19041 .53785 .18588 .53127 .17754 Mtetra
.53127 .17754 .53785 .18588 .55011 .18132 .54356 .17294 Mtetra
.54356 .17294 .55011 .18132 .56243 .17674 .55591 .16833 Mtetra
.55591 .16833 .56243 .17674 .57479 .17215 .56832 .16369 Mtetra
.56832 .16369 .57479 .17215 .58722 .16753 .58078 .15904 Mtetra
.58078 .15904 .58722 .16753 .5997 .16289 .5933 .15437 Mtetra
.5933 .15437 .5997 .16289 .61223 .15824 .60587 .14967 Mtetra
.60587 .14967 .61223 .15824 .62482 .15356 .6185 .14496 Mtetra
.6185 .14496 .62482 .15356 .63747 .14887 .63118 .14022 Mtetra
.63118 .14022 .63747 .14887 .65017 .14415 .64393 .13547 Mtetra
.64393 .13547 .65017 .14415 .66294 .13942 .65673 .13069 Mtetra
.65673 .13069 .66294 .13942 .67575 .13466 .66959 .12589 Mtetra
.66959 .12589 .67575 .13466 .68863 .12988 .68251 .12107 Mtetra
.68251 .12107 .68863 .12988 .70157 .12508 .69548 .11623 Mtetra
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.09674 .23181 m
.10144 .23638 L
s
[(-5)] .08733 .22266 1 .97262 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.61454 .02905 m
.61829 .03444 L
s
[(5)] .60704 .01829 .69632 1 Mshowa
.125 Mabswid
.14416 .21324 m
.14694 .21603 L
s
.19248 .19432 m
.19521 .19716 L
s
.24172 .17504 m
.2444 .17792 L
s
.2919 .15539 m
.29453 .15832 L
s
.39523 .11493 m
.39774 .11796 L
s
.44843 .0941 m
.45088 .09718 L
s
.50269 .07285 m
.50508 .07598 L
s
.55805 .05117 m
.56037 .05435 L
s
.05019 .25004 m
.05305 .25274 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.5},
  ImageMargins->{{Inherited, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.271883,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X00018a000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00
hGoo1000Pgoo003POol00`00Oomoo`02Ool00`00Oomoo`20Ool00>Eoo`03001oogoo081oo`00iGoo
00<007ooOol0P7oo003QOol40023Ool00>5oo`03001oogoo01]oo`8006Moo`00hGoo00<007ooOol0
6Goo0P0000=oo`000000IWoo003QOol5000DOol30003Ool2001VOol00?Qoo`800003Ool007oo00=o
o`03001oo`0006Eoo`00mGoo0`0017oo00D007ooOomoo`00009oo`03001oogoo069oo`00lWoo0`00
2goo00@007oo000006Aoo`00l7oo0P003Woo00D007ooOomoo`0006=oo`00kGoo0`0047oo00<007oo
Ool00Woo00<007ooOol0H7oo003[Ool2000COol00`00Oomoo`02Ool00`00Oomoo`1POol00>Qoo`<0
01Ioo`03001oogoo009oo`03001oogoo05moo`00iWoo0`0067oo00<007ooOol00goo00<007ooOol0
GWoo003SOol30003Ool00`00Oomoo`0EOol00`00Oomoo`03Ool00`00Oomoo`1NOol00>5oo`8000Io
o`03001oogoo01Eoo`03001oogoo00Aoo`03001oogoo05eoo`00MWoo0P000Woo0P00HWoo0`0087oo
00<007ooOol017oo00<007ooOol0GGoo001gOol01000Oomoo`00HGoo0P008goo00<007ooOol01Goo
00<007ooOol0G7oo001hOol2001OOol3000UOol00`00Oomoo`06Ool00`00Oomoo`1KOol007Qoo`80
05aoo`<002Qoo`03001oogoo00Ioo`03001oogoo05]oo`00Mgoo00@007ooOol005Uoo`8002]oo`03
001oogoo00Moo`03001oogoo05Yoo`00MWoo0P000Woo0P00EGoo0`000Woo00<007ooOol0:7oo00<0
07ooOol01Woo0`00Fgoo003?Ool2000`Ool00`00Oomoo`08Ool00`00Oomoo`1IOol00<aoo`<0039o
o`03001oogoo00Uoo`03001oogoo05Qoo`00bWoo0P00=Goo00<007ooOol02Woo00<007ooOol0Egoo
0037Ool3000gOol00`00Oomoo`0:Ool00`00Oomoo`1GOol00<Eoo`8003Yoo`03001oogoo00]oo`03
001oogoo00moo`D0049oo`00`Woo0`00?7oo00<007ooOol037oo00<007ooOol03Woo00D007ooOomo
o`00049oo`00`7oo0P000Woo00<007ooOol0>goo00<007ooOol02goo00<007ooOol03goo00<007oo
Ool0@goo002mOol30012Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool60004Ool00`00Oomoo`12Ool0
0;Yoo`<004Eoo`03001oogoo00eoo`03001oogoo00moo`03001oogoo045oo`00^7oo0P00B7oo00<0
07ooOol03Goo00<007ooOol047oo00<007ooOol0@7oo002eOol3001:Ool00`00Oomoo`0>Ool00`00
Oomoo`0;Ool01@00Oomoogoo0000@Woo002cOol2001=Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool3
0013Ool008Ioo`@002Ioo`<004moo`03001oogoo00moo`03001oogoo055oo`00QGoo00<007ooOol0
0Woo00<007ooOol08Goo0P000Woo00<007ooOol0CGoo00<007ooOol03Goo0P0000=oo`00Ool0DGoo
0025Ool00`00Oomoo`02Ool00`00Oomoo`0NOol3001DOol00`00Oomoo`0AOol00`00Oomoo`1?Ool0
08Eoo`03001oogoo009oo`03001oogoo01aoo`8005Moo`03001oogoo015oo`03001oogoo04moo`00
QGoo00<007ooOol00Woo00<007ooOol06Goo0`00FGoo00<007ooOol04Woo00<007ooOol0CWoo0025
Ool00`00Oomoo`02Ool00`00Oomoo`0GOol2001LOol00`00Oomoo`0BOol00`00Oomoo`1>Ool008Eo
o`03001oogoo009oo`03001oogoo01Aoo`<005ioo`03001oogoo01=oo`03001oogoo04eoo`00QWoo
100057oo0`00HGoo00<007ooOol057oo00<007ooOol0C7oo002LOol20003Ool00`00Oomoo`1NOol0
0`00Oomoo`0DOol00`00Oomoo`1<Ool009Uoo`<0069oo`05D_eBo5;mD_`0000GOol00`00Oomoo`1;
Ool009Moo`8006=oo`=Bo005D_eBo5;lD_`0000GOol00`00Oomoo`1:Ool009Aoo`<006=oo`0:D_eB
o5;mD_aBoE;lD_eBo5;m000GOol00`00Oomoo`1:Ool0099oo`80069oo`=Bo005D_eBo5;lD_aBo@03
D_`015;mD_`005;l5goo00<007ooOol0BGoo002?Ool3001ROol04U;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBo@00D_eBo1Eoo`03001oo`0004Yoo`00SGoo0`00HWoo00=Bo5;mD_`00U;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_`00003D_`FOol00`00Oomoo`18Ool008Yoo`<000=oo`03001oogoo
05Yoo`0JD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoAMo
o`03001oogoo04Moo`00Qgoo0`001Woo00<007ooOol0F7oo0U;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`02E;mD_aBo5;lD_eBo000D_aBo@02D_`GOol00`00Oomoo`16Ool008Eoo`80069o
o`0PD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eB
o5;mD_aBoAIoo`03001oogoo04Ioo`00PWoo0`00HWoo00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo00000=Bo003D_eBo7oo01Ioo`03001oogoo04Eo
o`00P7oo0P00Hgoo02EBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo00GOol00`00Oomoo`14Ool007eoo`<0065oo`05D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_`005;lD_d00e;l00=BoE;lOol05Goo00<007ooOol0A7oo001kOol20002Ool00`00Oomoo`1M
Ool0;5;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_dGOol00`00Oomoo`13Ool007Qoo`<0069oo`9B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;l00000e;l00EBoE;lD_aBo5;m01Moo`03001oogoo049oo`00MWoo0P00HGoo
03ABo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoAIoo`03001oogoo049o
o`00Lgoo0`00HGoo0U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_`005;lD_d00e;l00ABoE;lD_aB
o1Moo`03001oogoo045oo`00LGoo0P00HWoo03UBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
o@00D_eBo5;mD_aBoE;lD_eBo5;mD_`05Goo0`00@Woo001^Ool3001POol2D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m001Bo5;lD_d00e;l00ABoE;lD_aBo1Ioo`03001oogoo
041oo`00Jgoo0`00HGoo045Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;l01Ioo`03001oogoo03moo`00JGoo0P000goo00<007oo
Ool0Fgoo00=Bo5;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_`005;m00=Bo005D_eBo5;lD_aBo@03D_`EOol00`00Oomoo`0oOol006Ioo`<005moo`19D_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_d05Woo00<007ooOol0?Woo001TOol2001POol00e;lD_eBo002D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBo@00D_aB
o5;m00=Bo005D_eBo5;lD_aBo@02D_`FOol00`00Oomoo`0mOol0065oo`<0061oo`1?D_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0
05;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d05Goo00<007ooOol09Goo0`005Goo000eOol4000V
Ool2001OOol00e;lD_eBo002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009Bo003001BoE;l009Bo005D_eBo5;lD_aBo@03D_`00e;m
D_aoo`0EOol00`00Oomoo`0VOol00`00Oomoo`0COol003Aoo`03001oogoo009oo`03001oogoo021o
o`<0061oo`1ED_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0
5Woo00<007ooOol09Goo00<007ooOol04goo000iOol00`00Oomoo`0NOol20002Ool00`00Oomoo`1L
Ool2D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo006D_eBo5;lD_aBo@000U;l00EBoE;lD_aBo5;m00=Bo006D_eBo5;lD_aBoE;l
5Goo00<007ooOol097oo00<007oo000057oo000/Ool60007Ool00`00Oomoo`0KOol3001OOol0G5;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_dFOol00`00Oomoo`0SOol00`00Ool0000DOol003Eoo`@001aoo`80061oo`9Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;l001Bo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m01Io
o`03001oogoo025oo`05001oogooOol0000COol003Eoo`03001oogoo01Yoo`<0061oo`1RD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoAAoo`8002=oo`05001oogooOol0000COol003Eoo`03001oogoo01Moo`<005moo`9B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m001Bo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@0EOol00`00Oomoo`0OOol3000017oo000000004Woo000e
Ool5000COol2001POol0JE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo00FOol00`00Oomoo`0g
Ool004Yoo`<00003Ool007oo05eoo`05D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00U;l00<005;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`EOol00`00Oomoo`08Ool4000[Ool004Qoo`8005moo`1`D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_dFOol00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`0XOol0
04Eoo`<005moo`05D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00UBoE;lD_aBo5;mD_`005;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@02
D_`FOol00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0XOol004=oo`80061oo`1eD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l01Ioo`03001oogoo
00Eoo`03001oogoo009oo`03001oogoo02Qoo`00@7oo0`00GWoo00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o00000=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lOol05Goo00<007ooOol0
17oo00<007ooOol00Woo00<007ooOol0:7oo000nOol2001MOol0Oe;lD_eBo5<MD_aBoE;lDaeBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l01Ioo`03
001oogoo00=oo`03001oogoo009oo`03001oogoo02Qoo`00>goo1000GGoo0e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00UBoE;lD_aBo5;mD_`005;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;m
D_aoo`0DOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0XOol003Uoo`8000Aoo`03001o
ogoo05Qoo`24DaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l5Goo00<007ooOol00goo1000:goo000fOol3
001MOol3D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo00000=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m01=oo`800003Ool007oo039oo`00<goo
0`00GWoo08]BoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@0EOol00`00Oomoo`0a
Ool0035oo`8005moo`03D_aBoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00P0000=Bo5;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d05Goo00<007ooOol0<7oo000^Ool3001MOol0Le;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<M
D_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m00<0000MD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@0EOol00`00Oomoo`0_Ool002aoo`@005aoo`03D_aB
oE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00`0000IBoE;lD_aB
o5;m0002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`EOol0
0`00Oomoo`0_Ool002Yoo`8005ioo`1aD_e>g5;mD_aBoDkLD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
DaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBo@03000095;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo1Eoo`03001oogoo02ioo`00:Woo0P00Fgoo00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_`00000D_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_d005;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo003
D_eBo5;l01Eoo`03001oogoo02ioo`0047oo1@000goo100017oo10001Woo00<007oo0000EWoo07=>
g5;mC]aBoDkLD_e>g5;mC_aBoDklD_eBo5;mC_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eB
o5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo0030000:U;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoAEoo`03001oogoo02eoo`004Woo00<007ooOol00Woo00<007ooOol0
0Woo00@007ooOol000Aoo`03001oogoo00=oo`800003Ool007oo04aoo`04I[L]fBgJ;MT2C]`01TkM
C]a>g5;lD_e>o09Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mD_`000020003D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005001Bo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo003D_eBo5;l01Eoo`03001oogoo02aoo`004Woo00<007ooOol00Woo00<0
07ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`8000=oo`03001oogoo035oo`03M]<02goo
01Eoo`1fI]MV]VKG;MT]fRWIC_e>g4kmC]aBoDkLD_e>g5;mC]aBoDkLD_eBo5;mC_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_`30000<U;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_dDOol00`00Oomoo`0/
Ool000Moo`H000Eoo`03001oogoo009oo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool00`00Oomoo`0`Ool00g;C00aoo`0EOol01fJgI]MV]RgJ;MT]fRgI009>g005
C]e>g5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mD_`000020003D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01@00D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`00e;mD_aoo`0DOol00`00Oomoo`0[Ool0019oo`03001oogoo009oo`03
001oogoo009oo`04001oogoo0004Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0_Ool0
0gKcL]=oo`0DOol0LFJfI]MV]VKGI[H]fRgI;MXYfE;mC]aBoDkLD_e>g5;mC]aBoE;lD_e>g5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0
0`0003UBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0
4goo00<007oo0000;7oo000BOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<0
07ooOol00Woo0P001Woo0P00;goo0W;C57oo00=V]fKGI[H00VJg00=VedZlB[`00dZl0Tkl00EBoDkL
C_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00=BoE;l00000P000e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m009Bo003001BoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00IBoE;lD_aBo5;mD_`DOol00`00Oomoo`0ZOol0011oo`<000Aoo`03001oogoo009o
o`04001oogoo0004Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`0[Ool017;CM]=bdP0<
3goo00U:gD[LB]e:_4[MI[IVefJfI]L00U>B06E:_4[MB[a:gDkLD_e>g5;mC]aBoDklD_e>g5;mC_aB
oDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l00<00010D_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_dEOol00`00Oomoo`0YOol0019oo`03001oogoo00=oo`@000Aoo`@000Eoo`03001oogoo00Qo
o`03001oogoo02Yoo`9bd`03M]<02goo00]oo`04C_e>g4kmC]`3B]d014[LI[MV]fKG0e>B1DZl00E>
o5;lD_aBoDkl009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01U;mD_aB
o5;lD_eBo0<000=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00U;l00<005;mD_`00U;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d05Goo00<007ooOol0:7oo000XOol00`00Oomoo`0:
Ool00`00Oomoo`0YOol017;BM_=bd`0<2Woo071>g5;mC]aBoDkLD_e>g4[MB]a:gDZlI]MCTVKGI[H]
fRgIC_e>g4kmC]a>oDkLD_e>g5;mC]aBoE;lD_e>g5;mD_aBoDklD_eBo5;mD_aBoE;lD_eBo5<MD_aB
oE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBo@800017D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo00EOol00`00Oomoo`0XOol002Qo
o`<000]oo`03001oogoo02Moo`06L]=fdg;CL]<031`71goo00YBoDkLC_e>o5;mC]a>oDkLC_e>g0=:
g@08;UeV]fJgI]L]fBgJ;MU>g@=>g005C]eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00U;l0`000U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`02E;mD_aBo5;lD_eBo000
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo004D_eBo5;lD_`EOol00`00Oomo
o`0WOol002Qoo`03001oogoo00aoo`03001oogoo02Ioo`06M_=bdgKCL]80300;0goo071>g5;mC]aB
oDkLD_e>g5;mC]aBoD[LC_e>g4kmB]`^GBYM;UeV]VKGI[IVebWI;MX]fBgJC]aBoDkLD_e>g5;mC]aB
oDkLD_eBo5;mC]aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC
7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@<0001>D_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;l5Goo00<007ooOol09Woo000XOol00`00Oomoo`0=Ool00`00Oomoo`0U
Ool3L]<01WKCL]<034kLC]e:g09>g00=C_e>g4klC]aBoDkLC_e>o5;mC]a>gDkLC_d00RiM00=V]fKG
I[H00VJg1DZl00A>g4klC_aBo@=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo003D_eBo5;l00<0009B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo009D_eBo5;lD_aBoE;l001Bo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00ABoE;lD_aBo1Aoo`03001oogoo02Ioo`00
:7oo0P003goo00<007ooOol097oo07=fdg;BM_=bdgKC00/034[LC]e:_4kMB]aBoDkLD_e>g5;mC]aB
oDkLD_e:g4kmC]a>oFJfI]MV]VKGI[ICTTnAB]e:_4[MB[aBoDkLD_e>g5;mC]aBoDklD_e>g5;mD_aB
oDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBo@030000EU;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_`DOol00`00Oomoo`0UOol002Qoo`03001oogoo00moo`03001oogoo029oo`9bd`09
M]=bdg;CL]<0300;00a>g4km00=>g00:D_e>g4klC_aBoDkLC_e>g4kmB]`3B]d01VJfI[MV]e>BCi5C
TPE:_005D_e>o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo003D_eBo5;l00<0009Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01U;mD_aBo5;lD_d0009Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009Bo1Eoo`03001oogoo02Aoo`00:7oo
00<007ooOol047oo00<007ooOol08Goo06ibdWKcL]=fdg;BM_=2W4Jl@Ya6_4kLC_e>g5;mC]aBoDkL
D_e>g5;mC]aBoDkLD_e:_4[MB]aVefJfDi9V]VKG:MT]fTkLC_e>g4kmC]aBoDkLD_e>g5;mC]aBoE;l
D_e>g5;mD_aBoDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;m0`0005eBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_d04goo0P009Woo000WOol00`00Oomoo`0BOol00`00Oomoo`0AOol00f[E
3=Eoo`08Ool00d[MB]a:g@02B]d3L]<00gKCL]=bd`04AY`03dkLC_e>g4kLC_aBoDkLC_e>o4kmC]a>
oDkLC_e:g002B]d02BiMI[IV]fJg;MX]fBgJC]a>g@03C]`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo003D_eBo5;l00<0009Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00IBoE;lD_aBo5;m0002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@02D_`DOol00`00Oomoo`0SOol002Moo`<001=oo`03001oogoo011oo`03K]IZe@cE00Eo
o`1_C_e>g4kmC]a>gD[LC]e:g7KCL]9flg;CM]=bdTJl@Ya6_4:LA[a>g5;mC]aBoDkLD_e>g5;mC]a>
oD[LC_e>g4km:U`^GBYMI]MV]VKGI[H]fRWI;MX]fE;mC]aBoDkLD_e>g5;mC]aBoDkLD_eBo5;mC]aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m00<0001TD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_`EOol00`00Oomoo`0ROol002Moo`03001oogoo01Aoo`03001oogoo00ioo`9ZeP0>
K]H8]@cEB]a>gD[LC]a:g4kmC]a>gDkLB]e:g09:g@03M]=bdg;C009bd`0500a>g4kLC]e:g002C]`0
34kmC]a>o4kLD_e>g4kmC_a>oDkLC]e>g08^G@9V]`03I]MV]VJg00E:_005D_e>g4klC_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l0P000U;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo00000=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00IBoE;lD_aBo5;mD_`DOol00`00Oomoo`0ROol001Eoo`@000Aoo`@000Ioo`03001o
ogoo01Eoo`03001oogoo00eoo`1cJ]E^eV[E3=D8]0cEB]a>gDZlC]e>g4kmC]a>oDkLC]e:g4kML]=f
dg;BM]=bd`0<00]>gD[LC]e:_4kMC]aBoDkLD_e>g5;mC]aBoDkLC_e:g4kmC]aVefJfI]MV]VKGCg5C
TTZlB]e:_4[MC]aBoDkLD_e>g5;mC]aBoDklD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aB
oE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_`00`0006YBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0
05;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoAEoo`03001oogoo
025oo`0057oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo00=oo`03001oogoo01Ioo`80
00aoo`0;J]I^eV[EJ]H8]@cE2;D<eD[LC]e:g002C]`01TkMC]a>gDkL?[dnW@Ebd`@03007C]a>oDkL
C]a>o5;mC]`00Tkl00IBoDkLC_e>o4[MB]`2B]d01VKGI[IV]dnADi5?L@E:_003D_aBoDkl009Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo004D_eBo5;lD_`300000e;lD_eBo002D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00D005;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoGooOol04goo00<007ooOol087oo000IOol01000
Oomoo`0017oo00<007ooOol00goo0P006Goo00<007ooOol02Goo06i^eV[EK]IZeFkF2;@<e@Rd3=E>
g4kmB]a>oD[LC_e:g4km?Yefdg;BM]=bdgKCL]96_4:LA[a2W4JlC]a>oDkLD_e>g5;mC]aBoDkLD_e>
g5;mC]a:gDZlB]eV]VKGI[IVefJf;MX]fDkmC]a>oDkLC_e>g5;mC]aBoDkLD_e>g5;mD_aBoDklD_eB
o5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;l0`00079Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_dDOol00`00Oomoo`0POol000aoo`H000Moo`04001oogoo0004Ool00`00Oomo
o`02Ool00`00Oomoo`0JOol00`00Oomoo`07Ool01VkFJ]EZeV[FK]IZe@=6_00:AYa6_4kLC]e>g4kM
C]a>gDkLC]d7L]<4AY`2C]`05TkmC]a>oDklD_e>g4kmC]a>oDkLC_e>g4[MB]a:gFJgI]MV]VJg;MT]
fRgI0TkL00E>gDkLC]aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00ABoE;lD_aBo0<00003D_aB
oE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0U;l00<005;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`015;mD_aBo5;l5Goo
00<007ooOol07goo000EOol40003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0KOol0
0`00Oomoo`03Ool0K4[MA[a:gDZlK]IZeFkFJ]E^eV[EA[e6W4JlAYa6_DkLC_e>g4kmB]a>gD[LC]eb
dgKCL]9fdg;CM]=2W4Jl@Ya6_4:LD_e>g5;mC]aBoDkLD_e>g5;mC]a>oD[LC_e>g2iM:U`^GFJfI]MR
]VKG;MT]fRgIC_e>g4kmC]aBoDkLD_e>g5;mD_aBoDkLD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lDaeB
o5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo0<0001iD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`057oo
00<007ooOol07goo000EOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`02Ool200000goo
L]=oo`0JOol03000B]a>gD[LC]e:g4[MB]a:gF[FK]HfO@9ZeP06K]H8]@cEB]a>gD[L0TkL00=>oDkL
C]d00T[M00=:g7;CL]<017;C00X034[LC]a>g4kMB]a>o4kLC_e>g09>o007D_e>g4kmC]a>oDkLC]d0
0RiM00UV]VJgI[MVefJf;MX]fBgJ;MT00Tkl00EBoDkLC_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`015;mD_aBo5;l0`00
00=Bo5;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`02E;mD_aBo5;lD_eBo000D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo004D_eBo5;lD_`DOol00`00Oomoo`0NOol001Eoo`03001oogoo00Aoo`03001oogoo009oo`03
001oogoo009oo`04001oogooK[<HOol09DE@@C12W3il@Ya:g4kMB]a>gD[LB]e6_4[M=We^eV[EK]IZ
e@cE2;@<eD[LC]e:_4kmC]a>oDkLC_e:g4kMB]afdg;CM]=bdWKC00803017B[a>gD[LC]e:_5;mC]aB
oDkLD_e>g5;mC]aBoDkLC_e:g4kmI[IVef:fI]MV]TnACg1:gDZlB]e:_5;mC]aBoDkLD_e>o5;mC]aB
oE;lD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aB
oE;lD_eBo0030000PE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo00DOol00`00Oomoo`0MOol001Eoo`D000=oo`@0
00Eoo`04001oog;CL]<GOol03TE@@C15<49l@Ya2O4:L@Wa>gD[LC]e:g3ZM=Wd2J]H00fkFJ]EZeP02
3=D030ReC]a:g4kMB]a>gDkLC]e>g4kM?Ydn_@Ebd`@0309>g00;C_e>g4klC_aBoDkLC_e>o5;mC]a>
o@02B]d01D[LB]eV]fKGI[H00Tma00=?TDZlB[`00dZl0U;l00EBoDklD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo004D_eBo5;lD_`300000e;lD_eB
o002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`02E;mD_aBo5;lD_eBo000D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo003D_eBo5;l01=oo`8001moo`009Woo00@007ooL]Ab/aIoo`1[AE11<4E@@C15
D4ZlB]e:_4[MB[a>gD[LC_dfOCZMJ]E^eV[EK]IZeFkF2;D<e@RdC_e>g4kmB]a>oD[LC_e:g4:mL]=f
dg;BM]=bdgKC@Ya6_4:LA[a2W5;mC]a>oDkLD_e>g5;mC]aBoDkLD_e>g5;mB]a:gDZlI]MV]VKGH[IV
ebgI;MY>g4kmC]a>oDkLD_e>g5;mC]aBoE;lD_e>g5;mD_aBoDklD_eBo5;mD_aBoE;lD_eBo5<MD_aB
oE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBo@020000R5;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;m57oo00<007ooOol077oo000UOol01P00Ool007:cL]<01aAoo`0:AE11<4D`@C15D44`001:g4[M
B[`2B]`01TkMB]a>gF[FK]IZe@9ZeP03K]IZeDJl0096_009AYa>gDkLC]e>g4kMC]a>gDkL00Mbd`A6
W0=>g00;C_e>g4kmC_aBoDkLC_e>g4kmC]a>o@02B]d024[LI[MV]fJgI[H]fRgI;MX3C]`01DkMC]aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
o@00000005;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01U;mD_aBo5;lD_d0009Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009Bo1Aoo`03001oogoo00Mo
o`D000moo`009Goo0P0000Ab/g;CK[<020eoo`0=C]e:_4kMB]a>gCjM@[e1<4E@@C15D44`AE000P00
05i:_4[MB[a:gDZlB]e6_4[MJ]E^eV[EK]IZeFkF2;A6_DJLA[a6W4kmC]a>oDkLC_e:g4kMB]afdg;C
M]=bdWKCL]<034:LA[a2W4JlC]aBoDkLD_e>g5;mC]aBoDkLC_e>g4kmB]a>oBYM;UdZG6KGI[IVef:f
;MX]fBgJ;MUBoDkLD_e>g5;mC]aBoDkLD_eBo5;mC]aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aC7E;l
D_eBo5<MD_aBo@<0002>D_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`D
Ool00`00Oomoo`07Ool01@00Oomoogoo00003goo000UOol00`00Oombd`02L]<00`07Oomoo`07Ool0
45HDEQDjG3il?Ua:gD[LB]e:g4:m?Ye5<44`AE11<4D`100000A:g4kMB]a>g@9:g@05B]a:gF[FK]IZ
e@02J]H23=D024kLB]a>gD[LC]e>g4kmC]`3B]d00d[LL]=bd`04L]<04P0<B]a>g4kLC]e>g4klC]a>
oDkLC_e>o5;mC]a>gDkLC_e>g08^G@03I[MV]VJg009V]`E:_09>o005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_d00000001Bo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo006D_eBo5;lD_aBo@000U;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01U;mD_aBo5;lD_eBo1Aoo`03001oogoo00Moo`03001oogoo011oo`00
9Goo00L007;CK[=be7:c00PL1`06Ool0=eHEDOAF5E7dEQDjFcil>U/nO4ZlC]e:g4:m@C15D44`AE11
<4EA?Wa2W3il@Ya:g4kMB]a>gD[LB]e6_4[M=We^eV[EK]H8]@cE2;A>gD[LC]e:_4kmC]a>oDkLC]e:
g4kMB]afdg;CM]=bdgKC0080300dB[a>gD[LC]e>g5;mC]aBoDkLD_e>g5;mC]a>oDkLC_e:g6KGI[IV
ef:fI]M;L4maB[a:gDZlB]e>g5;mC]aBoDkLD_e>o5;mC]aBoE;lD_e>g5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_d30000UU;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo1Aoo`03001oogoo00Moo`03001oogoo00moo`009Goo00L007;CL]=b/g;C00LP1`05
Ool2EQ@07UHEDOAF55HDEQE:_4ZmB[a:gD[LB]dn_DE@@C15<44`AE11<4E@@Wa2W49l@Ya:g4kMB]a>
gD[L=YdfO@9ZeP03K]IZeF[F008<e@0;B]a>g4[LC]e:g4kMC]a>gDkL?[dnW@06L]<300`3C]`02Tkm
C]a>o4klD_e>g4kmC_aBoDkL0d[M00E:g6JgI[MV]d]`009?L@E:_004C_aBo5;lD_d3D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00<00005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01@00D_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mOomoo`0BOol00`00Oomoo`08Ool00`00Oomo
o`0>Ool002Eoo`07001be7:cL]=^/`0870L00Woo0d:m06QAm5HEDOAF5E7dEQEWKVN?A[a:gDJlB]e6
_4:m@C15D44`AE11<4E@@C15DDZlB]e:_4[MB]a>gD[LC_dfOCZMJ]E^eV[EK]IZe@cE2;D<eD[LC_e>
g4kmB]a>oD[LC_e:g4kmL]=fdg;CM]=bdgKC@Ya6_4:LA[a>g5;mC]a>oDkLD_e>g5;mC]aBoDkLD_e>
g4[MB]a:gF:fI]M;L6KGH[HafRgIC_e>g4kmC]a>oDkLD_e>g5;mC]aBoE;lD_e>g5;mD_aBoDklD_eB
o5;m0`0009eBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBo@0DOol00`00Oomoo`08Ool00`00Oomoo`0=Ool002Eoo`03001b
/g;C009bd`0500M:gDZlB]e:_002@[d06UHEDOAF55HDEQEAm6N>Ifi:gDZlB[e:_4[M?Ye5<44`AE11
<4D`@C15D44`001:g4[MB[`2B]`01TkMB]a>gF[FK]IZe@9ZeP033=D004Jl0096_005C]a>gDkLC]e>
g003B]d00d[LB]ebd`05L]<3AY`03TkmC]a>g4kLC_e>g4kmC_aBoDkLC_e>g4kmC]`3B]d022YMI[MV
]fJg;MT]fRgIC]d3C]`01DkMD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00<00005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00D005;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l5Goo00<007ooOol00goo00D007ooOomoo`0000moo`0097oo044007:cL]=^/g;DL[<02007
B]e6_4[MA[a:gD:mEQEAm5HEDOAWSf=^IhmWKTkMB[a>gD[LAE11<4E@@C15D44`AE51<4E@001:gDZl
B]e:_4[MB[a:gDJlB]eZeFkFJ]E^eV[E3=E6W4JmAYa6_4JLC_e>g4kmC]a>gD[LC]e:g7KC00=bd`0[
M]=bddJl@Ya6_4:LD_e>g5;mC]aBoDkLD_e>g5;mC]a>oDkLC_e:g2iM:Ud^GF:fI]MV]VKG;MTafRgI
;MY>g5;mC]aBoDkLD_e>g5;mC]aBoE;lD_d00`000:ABoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;l
DaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
57oo00<007ooOol017oo0`0047oo000TOol02@00L]=bdg;CL[=bd`0700P01`03B]d01DZl@[eF55HE
DO@00UHD00mF5CYL?W`nG4[MB]a:gD4`AE11<4D`@C15D44`AE000`0000E>gD[LC]e:g4kM009:g@03
B]aZeV[F00=ZeP8<e@09B]a>g4[LC]e:g4kMC]a>oDkL00=:g@03B]abdg;C00=bd`0300a>gD[L009>
g00?C_e>g4klC]a>oDkLC_e>o5;mC]a>gDkLC_dZGBiM009V]`03I[IV]fJg00E:_004C]a>o4klD_d3
D_`01E;mD_`00000D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo000
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`015;mD_aBo5;l4Goo0P0000=oo`00
Ool05goo000TOol01`00K[=be7:cL]=^/d:M0092W00j?Wa:gDJlB]e6_5HEDOAF5F=^EQEAm3il>U/n
O3YK?Wa6_4E@@C15D44`AE11<4E@@C15DCil@Y`nO4kMB]a>gD[LC]e:_4[MA[`jWF[EK]IZ]@cE3;D<
eDZlC]e:g4kMC]a>oDkLC_e>g4:m?Ye2_G;CM]<3L]<0900=00a>gDZlC]e:g4kMC]aBoDkLD_e>g5;m
C]aBoDkLC_e>g4kmH[IVefJfI]MR]TmaBg1:g4ZlB]e:_5;mC]aBoDkLD_e>g0<0002[C]aBoE;lD_e>
o5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l01Aoo`03001oogoo01Eoo`006Woo10001Woo
00<007;CL[<00W;C0Woo14:L0d[M00EAm5HDEQAF5E8D009F500IB]e:_4ZmB[a:gD4`AC11<4E@@C15
D44`AE11D4:L@Wa2W49l@Ya:g4kMB]a>gCIm=Yd01F[F0`cE00Y:g4kLB]a>gDkLC]e>g4kMC]`n_@Ib
d`<03006C_e>g4kLC]a>oDkL0Tkl00IBoDkLC_e>g4kmC]`3B]d00fJfI[MV]`03Bg05B[`00e;mC_`0
00020003D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo000D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`015;mD_aBo5;l4goo00<0
07ooOol05Goo000IOol00`00Oomoo`02Ool00`00Oomoo`03Ool01000Oombdfjc17oo00@024:L@Y`n
O0=2_@0bDOAF5E7dEQEAm5HEHfi:gDJlB]e6_4E@@C15D44`AE11<4EA@C15DD4`C]e:_4[MB[a>gD[L
C]e:g3ZM=We^eVZeK]IZeFkF2;@<e@be3=E:g4kmC]a>oD[LC_e:g4kmB]afd`=bd`0PM]=bddJl@Ya6
_4:LC_e>g5;mC]a>oDkLD_e>g5;mC]aBoDkLD_e:_4[MB]aVef:fCg5V]VKG;MTafTkLC_e>g0<0002c
C]aBoDkLD_e>g5;mD_aBoDklD_eBo5;mC_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<M
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo00C
Ool00`00Oomoo`0DOol001Uoo`03001oogoo009oo`03001oogoo00=oo`8000Ioo`0500L024ZlB]e:
_002@[d01EHEDQAF55HDEQD00fM^00YWSTZlB[e1<4E@@C15<44`AE11<0=5D005001:g4[LB]e:_002
B]`00dkMB]aZeP05J]H00`cEAYa6_002A[`01DkLC]e>g4kMB]`00d[M00=:g7;CL]<017;C0dJL00m>
g4kmC]a>o4kLC_e>g4kmC_aBoDkLC_e>g4kmB]`00T[M00H^GFJfI[MV]bgJ;MT30003C]`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;l001Bo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lD_`057oo00<0
07ooOol04goo000IOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`06Ool0700800M:gDJl
B]e6_4[M@[eF5E7dEQEAm5HEDO@nO3YK?W`nWDE@@C15D44`AE51<4E@@C15DD4`0`0001a:g4kMB]a>
gDJlB]e6_6kFJ]E^eVZeK]IZe@cEAYa6_DJLA[a>g4kmC]a>oD[LC]e:g4kML]=fd`=bd`0HM]<034Jl
@Ya6_4kLD_e>g5;mC]aBoDkLD_e>g5;mB]a>oDkLC_dZG2iMI[IVef:f0`000;X]fC7J;MUBoDkLD_e>
g5;mC]aBoDkLD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eB
o5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_dC
Ool00`00Oomoo`0COol001Uoo`03001oogoo009oo`03001oogoo009oo`03001oogoo00Ioo`0300L0
200700=:g@0MB[a2_EHDEQEB56M^EQAF5CYL?W`nG4:m@C15<44`AE11<4E@@C15D45@0015D4:L@Wa2
W4[LC]e:g003B]d00d[LJ]IZeP03J]H23=D02D[LC]a:g4kMC]a>gDkLC_e>g003B]d5L]<200`04TkM
B]a>g4kLC_e>g4klC]aBoDkLC_e>o5;mC]a>gDkLC_eV]P<00003I[IV]dZl00A:_005D_e>g4klC_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`02E;mD_aB
o5;lD_eBo000D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo003D_eBo7oo01=o
o`03001oogoo019oo`006Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol01goo02]2O4:L
?Wa:gDJlB]e6_5HEDOAF5E7dEQEAm5HE>U/nO3jMAE11<4E@@C15D44`AE51<4EA0015DCil@Y`nO4kM
B]a>gD[LB]e6_4[MA[a^eV[EK]IZ]@033=D02dZlC]e:g4kMB]a>oD[LC_e:g4:m?Yd00W;C01Afdg;C
L]<0300=B]a>gDZlC]e:g5;mC]aBoDkLD_e>g5;mC]aBoDZl0`000<5R]VKGI[IVed]?Bg1:_4[LB[a:
gDZlD_e>g5;mC]aBoDkLD_e>o5;mC_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aB
oE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo00DOol00`00Oomoo`0AOol001Uoo`03001oogoo009oo`03001oogoo009oo`8000Uoo`A2
W09:g@05DQAF56M^EQEB5002EQ@02T[MB[a2_D4`AE11<4E@@C15D44`1DE@00Y2O4:L@Wa>gD[LC]e:
g3JM=WdfW@EZeP<<e@09C]a>gDkLC]e>g4kMC]a>gCjM00Ibd`0500d0300<C]a>o@03C]`01U;mC]a>
o4klC_e>g0<00005B]a:gD[MI[MV]P03I[L012gI;MY>g4kM0dkL00EBoDklD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo006D_eBo5;lD_aBo@000U;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01U;mD_aBo5;lD_eBo1=oo`03001oogoo015o
o`006Woo10001Goo00<007ooOol02Goo00A6_4[MA[a:g@92_@0bDOAF5E7dEQEAm5HEHfe:gCjMAE11
<4E@@C15DD4`AE51<4EA@E15DD4`001:_4[MB[a>oD[LC]e:g4kmJ]E^eVZeK]IZeFkFAYa:_DJLA[a:
g4kmC]a>oD[LC_e:g4kmL]=fd`=bd`0=M]AbddJl@Ya6_4kLC_e>g5;mC]aBoDkLD_d00P000<Q>g5;m
C]aBoDZlB]e:g6KGH[IVefJf;MX]fC7jC]a>oDkLC_e>g5;mC]aBoDkLD_e>g5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m4Woo0`004Woo0005Ool200000goo0000
000IOol00`00Oomoo`0:Ool00dZlB]e:_002@[d03VN>DQAF55HDEQESKVM^Hfi2_D4`AC11<4E@@C03
AE001D5@AE15D4E@00000T[L00=:gDZlB]`00T[M00=:g4[MJ]H016[F00X<eDJLA[a6_4kMC]a>gDkL
C]e:g0=:g@Ibd`E6W003C_e>g4kl00<0000<C_e>o5;mC]a>gDkLC_dZGBiM:UeV]fJf0VJg00D]fRgI
;MY>g4kM009>g003D_aBoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m001Bo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`00e;mOomoo`0AOol00`00Oomoo`0@Ool000Aoo`03001oogoo008001Yoo`03
001oogoo00Yoo`04B]e6_4[MA[`2@[d04eHEDOAF5E7dEQDjFcil?Ye5D44`AE11<4E@@C15DD4`0011
<4EA00<0000=C]e:g4kMB]a>gDJlB]e6_6kFJ]E^eVZeK]H00PcE00]6W4ZmAYa>oDkLC_e>g4kmB]a>
gD[L009bd`09M]Abdg;CL[<03D[LC]e:_4kM00<0003?D_e>g5;mC]aBoDkLD_e:g4kmC]`^GBYLI]MV
]VKGH[IVebgI;MX]fC7jC]aBoDkLD_e>g5;mC]aBoDkLD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m01=oo`03001oogoo00moo`0017oo00D007ooOomoo`00
01Uoo`<000aoo`=:g@05B[a2_EHDEQEB5002EQ@035HE>Ua2_D4`AE11<4E@@C15D45@AE0000=5D008
@Wa2W49lC]e:g4kMB]a>g@9:g@03B]`fWF[F009ZeP<<e@09B]a>g4[LC_e>g4kMC]a>oD[L009:g@Eb
d`0300`03@000080009>g00>D_e>g4klC_aBoDkLC_e>o4kmC]a>gDkLI[MV]P=V]`03Adm;D4Zl00=:
_006C_aBoDkLC_aBo5;m0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005001Bo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo003D_eoogoo015oo`03001oogoo00ioo`0017oo00D007ooOomoo`0001Uoo`03001o
ogoo00eoo`0eB]e6_4[M@YaF5E7dEQEAm5HEDOAF5D4`AE11<4E@@C15DD4`AE51<4EA@E15DD4`@Y`n
O4:L?Wa2W4[LC]e:g4km=WdjWFZeK]IZeFkFJ[D@e@cEC]e:_4kMB]a>gD[LC_e:g4km?Yefe002L]<0
0g:cM]@000020000eP0=00a>oDkLD_e>g5;mC]aBoDkLD_e>g5;mC]a:gDZlB]e:g6KGH[IVedM?Bg17
Cd[MB[a:g4ZlB]e>g5;mC]aBoDklD_e>g5;mC_aBoDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeB
o5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;l4goo00<007ooOol03Woo0004Ool01@00Oomoogoo00006Goo00<0
07ooOol03Woo0d[M00A2_EHDEQAF5@9F5007Hfe5D44`AC11<4E@@C001TE@00I5DDE@B]a:g4[MB[`2
B]`014kMB]`fWCIm1F[F0`cE00U>gDkLC]e>g4kMC]a>gDkLC]d00W;C0`0000=bddJLAY`00dJL00I>
oDkLC]a>o5;mC]`2C_`01dkmC]a>oDkLB]e:g4[M009V]`05AdmV]fJg;MX]f@02C]`01TkMC]a>g5;l
D_e>o09Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo000D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
15;mD_aBo5;l4goo00<007ooOol03Goo0003Ool20002Ool2000IOol00`00Oomoo`0?Ool3@[d0;U7d
EQEAm5HEDOAWST4`AE11<4EA@C15D44`AE51<4EA@C15DD5@AE4004kMB[a:gDZlC_e:g4kMB]a^eV[E
K]IZ]FkFJ]D@eDJLB[e6W4kmB]a>oDkLC_e:g4kM0`000=ife7;CL]=b/g;D@Ya6_4:LA[a>g4kmC]aB
oDkLD_e>g5;mC]aBoDkLD_e>g4[MB[a:gBYMI]MR]VKG;MT]fRgIC_e>g4kmC]a>oDkLD_e>g5;mD_aB
oDkLD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`C
Ool00`00Oomoo`0<Ool0029oo`80019oo`03@[eF5EHD009F500;IfiSKDD`@C15D44`AE11<4E@@E00
0005AE0300000d[LB]e:_003B]d00d[LJ]IZeP03J]H00`cEA[a6W003A[`00dkLC]d000020003B]d5
L]<5AY`00dkLC_e>g002C_`02U;mC]a>oDklC_e>g4kMC]`^GBYM0fJg00EV]VJg;MT]fRgI009>o005
D_e>g4klD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_`005;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00ABoE;lD_aBo19oo`03001oogoo00aoo`008Woo00<007ooOol04Goo02U2_E7dEQEAm5HE
DOAF5D4`AE0nWDE@@C15DD4`AE4004EA@E15DD4`000nO4:L?Wa2W4[LC]e:g4[MA[a:gDJlK]IZeFkF
J[E^ePcEC]e:_4kM00<00009C_e>g4kMB]a>gD[LC]eb/g;D009bd`3J00a>gD[LC]e:_4kMC]aBoDkL
D_e>g5;mC]aBoDkLC_e:g4kmC]aVef:fI]MV]VKGH[I:gDZlB]a:_5;mC]aBoDkLD_e>o5;mC]aBoE;l
D_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoA=o
o`03001oogoo00]oo`008Goo00<007ooOol04goo00A2_EHDEQESK@9F5006AE11<4:m@C15D44`1TE@
00Y5D@00AE52O4:L@Wa>gD[LC]e:g0=:g@03B]aZeV[F009ZeP8<e@80000:C]a:g4kMC]a>gDkL?[dn
WCjm?Yd4L]<02P0=00a>g4kLC]e:g4kLC_aBoDkL0Tkl00IBoDkLC_e>o4[MB]`2B]d016JgI[IV]fJg
0TM?1DZl00=Bo5;mC_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo009D_eBo5;lD_aBoE;l001Bo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00=BoE;lD_`04Woo0P0037oo000QOol00`00Ool0000COol08d:LEQEA
m5HEDOAF5D4`AE11<4EA@C15DD4`AE51D4EA@C15DD5@0011D4EA?Wa2W3ilC_e:g4kMB]`jWCIm>YeZ
]FkFJ]D00`0000`<eA3EB]a>oDkLC_e:g4kmB]a2_CjML]@2L]<0gG:cL]@0300=00`03DkLC_e>g5;m
C]aBoDkLD_e>g5;mC]aBoDkLB]e:_4[MI[IVef:fI]MR]S7J;MU>oDkLC_e>g4kmC]aBoDkLD_eBo5;m
C]aBoE;lD_e>o5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_`04goo00<007ooOol02Woo000QOol2000DOol02T:mEQAF55HDEQEF54D`@C15D44`0dE@00=1D4E@
AE0014E@00a5DDE@001:g4[MB[a>gD[LC]e:g4kMJ]H300000f[FA[a6W003A[`024kLC]e>g4kMC]a>
gDkLC]d6L]<4AY`044kLC_e>g4kLC_aBoDkLC_e>o4kmC]a>oDkLB]e:g4[M0VJg00EV]VJg;MT]fRgI
009>g005C]e>g5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00UBoE;lD_aBo5;mD_`005;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`00e;mD_aoo`0AOol2000;Ool000moo`@000Aoo`@000Ioo`03001o
ogoo01Aoo`0LEQEAm5HEDOAF5D4`AE11<4E@@C15DD4`0011<4EA@E15DD4`AE55D4EA001>gDZlB]e:
_4[MA[`3000056[EK]IZ]FkFJ]E6_4JLB[e6W4kmB]a>oDkLC]e:g4kMB]a>gG:cL]@2L]<0gG:c00e2
W4Jl@Ya6_4kLD_e>g5;mC]aBoDkLD_e>g4kmB]a>oDkL;UdZG2iMH[IV]f:fI]L]fC7JC]a>oDkLC_e>
g5;mC]aBoDkLD_eBo5;mC]aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_`03Woo0`0000=oo`00Ool02Woo000>Ool00`00Oomoo`02Ool01000Oomo
o`0017oo00<007ooOol00goo00<007ooOol05Goo00aF5EHDEQAF54E@>Ua5D44`AE11D4E@0004AE00
0`00AE15D@0300000dkMB]`000020002B]d00d[LJ]IZeP03J]H00`cE4=E6W002A[`01TkmC]a>gDkL
B]e:g09:g@Ebd`803@03C]a>gD[L009>g00>C_e>g4klC_aBoDkLC_e>o4kmC]a>gBYM;UeV]P=V]`09
I[H]fRgI;MY>g4klC]aBoDkL009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBo@00D_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoGooOol027oo100017oo00<007ooOol02Goo
000COol01000Oomoo`0017oo00<007ooOol00goo00<007ooOol05Goo01EAm5HEDOAood4`Oom1<4EA
@C15DD4`AE51D4EA@C15D@00AE51D4Ea?W`00`000?Y:g4kMB]a>gDJlB]e6_3ZMJ]E^eVZe4?D<eA3E
B[a>gD[LC_e>g4kmC]a>oD[LC]e:g7;CL[=be7;C00d0300=B]a>gDZlC]e>g5;mC]aBoDkLD_e>g5;m
C]a>oD[LC_eR]VJgH[IVef:fAdm3;T[MB[a:g4kLD_e>g5;mC]aBoDklD_e>g5;mD_aBoDkLD_eBo5;m
D_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@Ioo`<000Qo
o`03001oogoo00Uoo`004goo00@007ooOol000Aoo`03001oogoo009oo`<001Ioo`9F5006EQDnWDD`
Oom5D44`1TE@00A5DDE@0015D0<0000:@Wa2W49lC]e:g4kMB]a>gCIm=Yd5J]H23=D02TkMB]a>g4[L
C]e>g4kMC]a>gCjM1G;C100=00M>g4kmC]a>g4klD_e>g002C_`00e;mC]a>o@02B]d01D[LB]eV]fJg
I[H00dM?14Zl00E>o5;lD_aBoDkl009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBo@00D_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l0goo0`0037oo00<007ooOol027oo000?Ool4
0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0GOol03UHEOom2_D4`Oom1<4E@@C15
DD4`AE51<4EA@E03000084E@AE55D4kMB[a:gDZlC_e:g4kMB]`jWCImK]IZ]FkFJ]E^ePcE4?D<eDkm
B]a>oDkLC_e:g4kmB]a>oG:cL]@2L]<0gg:cA[a2W4Jl@Ya6_4kLC_e>g5;mC]aBoDkLD_e>g5;mC]aB
oD[LB]e:_6KGH[I7Cf:fI]L]fC7JC]a>oDkLC_e>g5;mC]aBoDkLD_eBo5;mC]aBoE;lD_e>o5;mD_aB
oE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l008000moo`03
001oogoo00Qoo`003goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
5goo00UF57oo?[e5D7ooAE11<4E@@E000TE@0`0000M5D4EAAE15DDE@AE400002B]`01T[MB[a:g4[L
C]e:g0EZeP033=D004JL0096_006C]e>g4kMC]a>gD[L0d[M1G;C1DJL00=>g4kmC]`00Tkl00MBoDkL
C_e>g4kmC]a>o@02B]d024[L:UeV]fJgI[H]fRgI;MX3C]`01DkMC]aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01@00D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`@
Ool00`00Oomoo`08Ool000moo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo01Uoo`07AE1oogoo@C15DD4`AE400P0000U1D4EA@C0004E@AE55D4EaAE000`0001a:g4kMB]a>
gDJlB]e6_6kFJ]E^eVZeK]H<eDJlAYa:_DJLC_e>g4kmC]a>oD[LC]e:g7;CL[=be09bd`3OL[<03D[L
C]e:_4kMC]aBoDkLD_e>g5;mC]aBoDkLC_e:g4km:Ud^GF:fI]MR]VJgH[HanRgI<MY>g5;mC]aBoDkL
D_e>g5;mC]aBoE;lD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_`03goo00<007ooOol027oo000?Ool50003Ool40005Ool2000JOol0
144`OomoodE@0`0014E@00i5D@00AE55D4EAAE15DD9l@Ya2O4:LB]a>gD[L0d[M1F[F0PcE00Y>gD[L
C]a:g4kmC]a>gDkLC_e:g09:g@Ebd`803@0@C]a>gD[LC_a>g4kmC]a>oDklD_e>g4kmC]a>oDkLC]d2
I[L016JfI[MV]fJg14Zl00E>g4klC]aBoDkL009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o00000=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lD_`03goo00<007ooOol0
27oo000POol00`00Oomoo`0IOol0;dE@00000000Oom1<4EA@E15DD4`AE51D4EA@E15DDE@AE55D4Ea
?Wa2W3il@Ya:g4kMB]a:gDJlB]eZ]FkFJ[EZeVZe4?H<eDkMB[a>gD[LC_e:g4kmB]a>oCjM@[d00W;C
0>9b/g;DL]<03@0<C]e:g4kMB[aBoDkLD_e>g5;mC]aBoDkLD_e:g4[MB[a:gF:fI[MR]VKG@bi7CdZl
B]e:_4[LC]aBoDkLD_e>g5;mC_aBoDkLD_eBo5;mC_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;l
D_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@ioo`03001oogoo00Qoo`0087oo00<007oo
Ool05goo0`0000IoocjMAE1oodE@@E06AE002TEAAE15DDE@AE55D4EAB]a:gDZl0T[L00A>gD[L=Ydf
O@EZeP<<e@09C]e>g4kMC]a>gDkLC]e>g3jm00Ibd`<03@9>g00;C_e>g4klC_aBoDkLC_a>g4kmC]a>
o@02B]d024[LI[MV]fJgI[IV]bgI;MX3C]`01TkMC_aBo5;lD_e>o09Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_`005;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lD_`0
3Goo00<007ooOol027oo000OOol00`00Oomoo`0EOol30004Ool0;d:m@C1ood4`AE51<4EA@E15DD4`
AE55D4EAAE15LDE@AG55D000B[a:gDZlC_e:g4kMB]a^eVZeJ]IZ]FkF3=D004JLB[e6W4kmB]a>oDkL
C_e:g4kmB]abdg:cL]@00W;C0>9b/`0=@Ya6_4:LD_e>g4kmC]aBoDkLD_e>g5;mC]aBoDkLD_e:g4[M
B[aVef:fI[MR]S7j;MTafTkLC_e>g4kmC]aBoDkLD_e>g5;mD_aBoDkLD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBo@00D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@eoo`03001o
ogoo00Moo`007goo0P004goo0`001goo00Dn_DE@Oom5D3jm00A5D0060015D4EAAE15DDE@0dEA0P00
00=:g4[MB[`00d[M00=:g6[FJ]H00f[F00<<eDJlAY`00TJl00I>oDkLC]e>g4kmB]`2B]d6L]<0500=
AYa6W4JLC_a>g4kmC]a>oDklD_e>g4kmC]a>oDkLC]dZGBiMI[H3I[L026Jf;MT]fBgJC]a>o4kLD_d3
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@02D_`00`00D_eBo002D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo003D_eBo7oo00aoo`03001oogoo00Moo`007goo00<007ooOol0
3goo0`002Woo0355DGooOom1<4:m@E15DD4`AE4004EA@E15LDE@AG55D4EaAE12W3il@Ya:g4kMB]a:
gDJlB]e6_6kFJ[EZeVZe4?H<eDkMB[a>gD[LC_e>g4kmC]a>oD[LC]e:g7;CL[=be002L]<200d0gd[L
C]e:_5;mC]aBoDkLD_e>g5;mC]aBoDkLC_e:g4kmH[IV]f:fI]MR]VJgB[a:gDZlB]a>g5;mC]aBoDkL
D_e>o5;mC]aBoE;lD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l00aoo`03001oogoo00Moo`007goo00<007ooOol037oo0`00
3Goo00E1<7ooAE15D3jM0095D006AE55D4EAAE15DDE@0dEA00U5D4EA@Wa2W49lC]e:g4kMB]`00d[M
019:g6[FJ]IZePcE4=D<eDkMB]a>g4[LC]e>g4kMC]a>gCjM?[d5L]<200d2C]`02dkMB]a>o4klD_e>
g4kmC_aBoDkLC_d00T[M00I:g4[MI[MV]fJfI[L2@bh4B[`014klD_aBo5;m0e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`02E;mD_aBo5;lD_eBo000D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo003D_eBo7oo00Yoo`03001oogoo00Moo`007goo00<007ooOol02Goo0`0047oo02m5D7ooAE51
<4:m@C15DD5@AE51D4EAAE15DDE@AG55D4EaAE19LCil@Y`nO4kmB]a>gD[L>YhfOCJMJ[E^eVZeJ]H<
eA3f3=E>oD[LC_e>g4kmB]a>oD[L?[eb/g;D009bd`03L[=be00=00803@3PD_e>g4kmC]aBoDkLD_e>
g5;mC]aBoDkLD_e:g4[MB[aVef:fI[MR]VKG;MTafTkLC_e>g4kmC]aBoDkLD_e>g5;mD_aBoDkLD_eB
o5;mC_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo0Yoo`03001oogoo00Moo`007goo0P0027oo0P004goo00E1<7oo@E15D3jm00A5
D006AE55D4EAAE15DDE@0TEA00]5LDEA001:g4[MB[a>gD[LC]e:g4kM00EZeP0<A[a6W4JlA[a>gDkL
C]e>g4kMC]a>gDkL1g;C0dJL0TkL00]>oDkLC_e>o5;mC]a>oDkLC_e>g4km009:g@05B]aV]fJgI[MV
]P02;MT01C7JC]a>g4kLC]d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;l001Bo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoGooOol027oo00<0
07ooOol01goo000NOol00`00Oomoo`05Ool3000GOol04DEAOom2_D5@AE51<4EAAE15DDE@AG55D4Ea
AE15LDE@AG400P000?m:_4[MB[a:gDJlB]e6_4[MJ[EZeVZeK]IZ]DJlAYa:_DJLA[a>g4kmC]a>oD[L
C]e:g7;CL[=be7;CL]A^/dJlAYa6_4:LD_e>g5;mC]aBoDkLD_e>g5;mC]a>oD[LC_dZGBiMH[IVef:f
I[MR]S7j;MTafTkLD_e>g5;mC]aBoDkLD_e>g5;mD_aBoDkLD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
DaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_d005;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`000=BoE;lD_d02Woo00<0
07ooOol01Woo000NOol00`00Oomoo`02Ool3000JOol00dE@OolnW@02AE001TEA0015DDE@AE55D0E5
D@07@Wa2W49l@Ya:g4kMB]`014[M1F[F00/@eDkMB]a>g4[LC]e>g4kMC]a:gD[L009:g@Ebd`0B00e>
g4kLC]e:g4klC]a>oDkLC_e>o5;mC]a>oDkLC_e>g4kM0VJg00AV]VJgI[MV]`A:_004C]a>o4kLD_d3
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m001Bo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`:Ool00`00Oomoo`06Ool001ioo`03001oo`00008001eo
o`0bAE5ood:m@C15DD5@AE51D4EAAE15DDE@AG55D4EaAE1oocil@Y`nNd:LB]a>gD[LC]e6_4[MA[a^
eVZeJ]IZ]A3f3=E>gDZlC]e:g4kMC]a>oDkL?[dnWD:mL]=be6jcL]Abd`803@0EC]e:g4kMB[aBoDkL
D_e>g5;mC]aBoDkLD_e:g4[MB[a:gF:fI[MR]VKG0080003;B[a:gDZlB]a>g5;mC]aBoDkLD_e>o5;m
C]aBoE;lD_e>o5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001BoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo009Ool00`00Oomoo`06Ool001ioo`<001moo`03@E1oodE@00A5
D006AE55D4EAAE15DDE@0TEA00e5LGooOom2O4:L@Wa2W4[LC]e:g4kM=WdfW@05J]H34=D024kLC]e>
g4kMC]a>gDkL?[d6L]<300d2C]`02dkmC]a>o4klD_e>g4klC]a>oDkLC_d00T[M00E:g6JgI[MV]fJf
008]f@06<MY>g4kLC]a>gDkl0U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00IB
oE;lD_aBo5;m0002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo004D_eBo5;lD_`8Ool0
0`00Oomoo`06Ool001moo`03001oogoo01ioo`0@AE5oodEA@E15DD4`AE55D4EAAE15LDE@AG55D4Ua
AE03Ool0odZlB]e:_4kMB]a>gD[LC_eZ]F[FJ[E^eVZeJ]I6W4ZmAYa6_4[LC_e>g4kmB]a>oD[LL]A^
/g;DL]=be6jcL]A6W4Jl@YaBoDkLC_e>g5;mC]aBoDkLD_e>g5;mC]aBoD[LB]e:_6KGH[IV]f:f<OX]
fC7JC]a>oDkLC_e>g5;mC]aBoDkLD_eBo5;mC]aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eB
o5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo0001U;mD_aBoE;lD_eBo0Moo`03001o
ogoo00Ioo`0017oo1@000goo100017oo100027oo0P0087oo0dE@00I5DDE@AE55D4EAAE05AE45Ool0
0d[MB[a:g004B]d5J]H00a3eAYa6_002A[`01DkLC]e>g4kmB]`00T[M1W;C14JL00e>o4kLC_e>g4km
C_aBoDkLC_e>g4kmC]a>g@03:Ud3I[L3;MT01C7JC]a>o4kLD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo00000=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00=BoE;lD_`01goo00<007ooOol01Woo0006Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
1000Oomoo`0017oo00<007ooOol01goo00<007ooOol07Goo00e5DGooAE4004EA@E15LDE@AG55D4Ea
AE15L@07Ool0odkMB]a>gDJlB]e6_6kFJ[EZeVZeK]H<eA3eB[a>gD[LC]e>g4kmC]a>gD[LC]e:g7;D
K[=be7:cL]@03DkMB]a>gDZlD_e>g5;mC]aBoDkLD_e>g5;mC]a>oD[L;UdZGFJgH[IVef:fB]a:_4[M
B[a:g4kLD_e>g5;mC]aBoDklD_e>g5;mD_aBoDkLD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;m
D_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_`005;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@0015;lD_eBo5;m1Woo00<007oo
Ool01Woo0006Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol027oo
00<007ooOol077oo00M5D7ooAE12_DE@AE55D003AE400dE@AE55D@07Ool014[LC]e:g4kM0d[M16[F
0Q3E00/@mD[LC]a:g4kMC]a>gDkL?[dnWCjm00Ebd`803@9>g00>C]e:g4klC_aBoDkLC_e>o5;mC]a>
oDkLC_e>g0=V]`03I[H0000000E:_004C_aBo5;lD_d3D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo000D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
0e;mD_aoo`06Ool00`00Oomoo`05Ool000Ioo`03001oogoo009oo`03001oogoo009oo`04001oogoo
0004Ool00`00Oomoo`09Ool00`00Oomoo`0KOol03DEAOom5DCjMAE55D4EAAE15LDE@AG55D4Ua00Qo
o`3oB]a>gD[LC_dfOCJMJ[E^eVZeJ]IZ]A3f3=D@mD[LC_e>g4kmB]a>oD[L?[e^/g;DL[=be6jcL]@0
3@0>00eBoDkLC_e>g5;mC]aBoDkLD_e>g5;mC]aBoD[LB]e:_6KGH[IV]f:f<OX]fDkmC]a>oDkLC_e>
g5;mC]aBoDkLD_eBo5;mC_aBoE;lD_e>o5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l0004D_eBo5;mD_`6Ool00`00Oomoo`05Ool0
00Ioo`03001oogoo009oo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`0:Ool2000KOol3
AE001T:mAE15DDE@AE55D095D@03AG55DGoo00Qoo`04B]a>gD[LC]d6J]H02dJLA[a6_4JlC]a>gDkL
C]e>g4kMC]`01g;C0dJL0TkL00]>oDkLC_e>o5;mC]a>oDkLC_e>g4km009:g@04I[IV]fJgI[L3;MT0
1DkMC]a>g4kLC]d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m009Bo003001BoE;l009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lOol0
17oo00<007ooOol01Goo0006Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<0
07ooOol037oo00<007ooOol067oo00e5DD4`AE4nWDEA@E15LDE@AG55D4EaAE15L@0:Ool0odJlB]e6
_4[MJ[EZeVZeK]IZ]A3eAYa:_DJLA[a>g4kmC]a>oD[LC]e:g7;DK[=be7:cL]A^/dJlAYa6_4:LD_e>
g5;mC]aBoDkLD_e>g5;mC]a>oD[LC_dZGBiMH[IV]f:fI[L]fC7j;MTafTkLD_e>g5;mC]aBoDkLD_e>
g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo00015;mD_aBoE;l17oo00<007ooOol01Goo0004Ool30004
Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol03Goo00<007ooOol067oo00I5DGoo@[e5
D4EAAE05AE4<Ool3B]d5J]H02a3E4?E:g4kLB]a>gDkLC]e>g4[MB]`00T[M1G;C01803DkLC]a>gD[L
C_a>g4kmC]a>oDklD_e>g4kmC]a>oDkLC]d2I[L00fJfI[MV]`05B[`014kLC_a>g5;m0e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00UBoE;lD_aBo5;mD_`005;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`00e;mOomoo`02Ool00`00Oomoo`05Ool000Ioo`03001o
ogoo00=oo`@000Aoo`@0015oo`03001oogoo01Moo`0;@E1oocjMAE55D4EAAE15LDE@AG55D00=Ool0
;dJlB]e6_6kFJ[EZeVZeK]H@eA3eB[a>gD[LC]e>g4kmC]`n_CjM@[eb/g;DK[=be7:c00h03DkMB]a>
gDZlD_e>g5;mC]aBoDkLD_e>g5;mB]a:gDZlB]eR]VJgH[H00P000=5:g4ZlB]e:_4[LC]aBoDkLD_e>
g5;mC_aBoDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m00=oo`03001oogoo00Eoo`00:Woo
00<007ooOol05Woo00Q5D7oo@[e5D4EAAE15DDE@0TEA00=5LGooOol037oo00<fOCJMJ]H016[F00/@
mA3E4?E>g4kMC]a>gDkLC]e>g3jm00Ibd`0300d03P0=009>g00;C_e>g4klC_aBoDkLC_e>g4kmC]a>
o@03B]d3I[L016Jf;MT]fDkM0dkL00E>gDklD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo009D_eBo5;lD_aBoE;l001Bo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l0goo00<007ooOol01Goo000[Ool2000FOol02d4`Oom5D4EAAE15LDE@AG55D4UaAE00
3goo0?mZ]F[FJ[E^eVZe4?H004ZmAYa6_4[LC_e>g4kmB]a>oD[LL]A^/g;DL[=be6jcL]A6W4Jl@YaB
oDkLC_e>g5;mC]aBoDkLD_e>g5;mC]aBoD[LB]e:_6JgH[IV]bgI<OX]fDkmC]a>oDkLC_e>g5;mC]aB
oDkLD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`00E;m0E;l0goo00<007ooOol017oo000]
Ool00`00Oomoo`0COol01TEAOom5DDE@AE55D0E5DA1oo`AZeP03Ool@mDJL00=6_005C]a>gDkLC_e:
g002B]d6L]<04@0>AYa6W4JLC_a>g4kmC]a>oDklD_e>g4kmC]a>oDkLC]d00RYM00AV]VJgI[MV]`<]
f@05D_e>g4klC]aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBo@00D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l0Woo
00<007ooOol017oo000^Ool00`00Oomoo`0DOol0245@Oom5D4:mAE15LDE@AG4BOol0ofZeJ]Ioogoo
4=D@mTZlC]e:g4kMC]a>oDkLC_e:g4kMB]a>gFjcL]Ab/g;D00d03T[LC]e:_5;mC]aBoDkLD_e>g5;m
C]aBoDkLC_e:g4kmH[IV]f:fI[MR]T[LB[a:gDZlD_e>g5;mC]aBoDkLD_e>o5;mC]aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo00015;mD_aoo`001Woo000_Ool00`00Oomoo`0COol01TEAOom5
DCjmAE55D095DAMoo`0<4=D@mD[LC]a:g4kMC]a>gDkLC]dnWCjm1G;C00H03P0=C]a>g4kMB]`2C_`0
1e;mC]a>oDklD_e>g4km00A:g@9V]`03I[H0000000A:_005D_e>o5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBo@00D_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00U;l00=oo`00Ool01Goo000`Ool2000COol024E@Oom5
D4:mAE15LDE@BG4GOol0oQ3f4=D@mT[LC_e>g4kmB]a>oD[LC_e:g7;DL[=be6jcL]@03@0>00eBoDkL
C_e>g5;mC]aBoDkLD_e>g5;mC]aBoD[LB]e:_6JgH[IV]f:f<OX]fDkmC]a>oDkLD_e>g5;mC]aBoDkL
D_eBo5;mC_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m0006Ool0039oo`03001oogoo
011oo`04AE55D4EA?Yd2AE400dEaAE5oo`0GOol3A[`01DkLC]e>g4kMB]`00d[M00=:g7;CL]<00g;C
14JL00a>g4kmC]a>oDklD_e>g4kmC]a>oDkLC_d3B]d3I[L012gI<MT]fDkM0dkL00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01@00
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo003D_eBo5;l00=oo`03001oogoo00Aoo`00<goo00<0
07ooOol03goo00Q1D4EaAE12_DE@AG55D4Ea67oo0296W4ZmAYa6_4kLC_e>g4kmB]a>gD[LC]e^/g;D
K[=be6jc00i:g4kMB[a>gDkLD_e>g5;mC]aBoDkLC_e>g4kmB]a>o@8ZG@3AH[IV]f:fI[L]fC7j;MUB
oDkLD_e>g5;mC]aBoDkLD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo008Ool00`00Oomoo`03Ool0
03Aoo`03001oogoo00moo`03AE1oocjm00=5DAYoo`09B]a>g4[LC]e>g4kMC]a>oD[L00=:g@Abd`05
00d03TkLC]e:g002C]`02dkmC]a>oDklD_e>g4kMC]a>oDkLC]d00VJg00AR]VJg000000=:_005D_e>
g4klC]aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo00000=Bo005D_eBo5;lD_aBo@0<Ool00`00Oomoo`03Ool003Eoo`8000moo`06
AE5ood:mAE15LDE@6goo0>a:_4kMB]a>gD[LC_e:g4km?Ye2_FjcL]A^/g;DK[<03P0=00i>g4kmC]aB
oDkLD_e>g5;mC]aBoDkLB]e:g4[MB[a:gF:fI[MR]VJg001:g4ZlB]e:_5;mC]aBoDkLD_e>g5;mC_aB
oDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m001B
oE;lD_eBo5;m3goo00<007ooOol00goo000gOol00`00Oomoo`0<Ool00dE@OolnW@02AE400dEaOomo
o`0JOol02DkLC]e>g4kMC]a>gDkLC]e>g005L]<4AY`02dkLC_e>g4kLC_aBoDkLC_e>g4kmC]`014[M
0fJg00AR]S7I;MU>g@=>g005D_e>o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00ABoE;lD_`001=oo`03001oogoo00=oo`00>7oo00<007oo
Ool02goo00I5LGooAG55D4UaAE0MOol0hd[LC_e>g4kmB]a>gD[LC]e:g7;DK[=be6jcL]A6W4Jl@Ya6
_4kLD_e>g5;mC]aBoDkLD_e>g5;mC]a:gD[LB]e:_6JgH[IV]f:f<OX]fDkmC]a>oDkLD_e>g5;mC]aB
oDkLD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0
0goo00<007ooOol047oo00<007ooOol00goo000iOol00`00Oomoo`0:Ool00dE@Oom5D@03AE4NOol0
1DkLC]e>g4kmB]`00d[M0g;C00Ibe7;C00i>g4kMB]`2C]`02TkmC]a>o4klD_e>g4kmC]a>oDkL0RYM
00=V]f:fI[L00VJg00P]fC7I;MUBoDkLC_a>g5;m0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m009Bo0Qoo`03001oogoo00moo`03001oogoo00=oo`00>Woo0P00
37oo00=5LGooAG4087oo029>g4kmC]a>oDkLC]e:g4kMK[=be6jcL]@03@0>B]a>gDZlC]e>g5;mC]aB
oDkLD_e>g5;mC]a>oD[LI[MR]VJgH[IV]`80002fB[a:gDZlD_e>g5;mC]aBoDkLD_e>o5;mC_aBoE;l
D_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@]oo`03001oogoo00moo`03001oogoo00=o
o`00?7oo00<007ooOol02Goo00=5D7ooAE408Goo00Q>g4kMC]a>gDkL?[ebdg;D0g;C0`0>00a>g4km
C]a>g4klD_e>g4klC]a>oDkLC_d3B]d3I[L016:fI[L]fC7J0dZl00EBoDklD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00IBoE;lD_aBo5;mD_`@Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool003eo
o`03001oogoo00Qoo`03AG5oodUa02Aoo`3?B]a>oD[LL]A^/g;DK[=be6jcA[a2W4JlC]a>oDkLD_e>
g5;mC]aBoDkLD_e>g5;mB]a:gF:fI[MR]VJgH[HanRgI<OY>g4kmC]a>oDkLD_e>g5;mC]aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;l01Aoo`03001oogoo00ioo`03001oogoo009oo`00?Woo00<007oo
Ool01goo00=5DDEaAE409Goo0T[M00A:g7;CL]=be09bd`0700i6W4JLAYa>g4kmC]`00Tkl00MBoDkL
C_e>g4kmC]a>g@02:Ud036:fI[MV]fJgH[HafBgI<MY>g4klC]aBo@=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00=BoGooOol05goo00<007ooOol03Goo00<007ooOol00Woo000oOol00`00Oomoo`06Ool00dEa
AE15L@0VOol01d[LC]e:g7;DK[=be6jc00803P2mC]e:_4kMC]aBoDkLD_e>g5;mC]aBoDkLC_e:g4km
H[IV]f:fI[MR]VJgB[a:gDZlB]a>g5;mC]aBoDkLD_e>o5;mC]aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m01aoo`03001oogoo
00eoo`03001oogoo009oo`00@7oo0P001goo00=5DGooOol09Woo00<nWG;DL]<00W;C00Ybe00>00h0
3TkMB]a>g4klD_e>g09>o003D_e>g4km00A:g@9V]`04H[IV]`000004B[`014klD_aBo5;m0e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o003D_eoogoo01ioo`03001oogoo00aoo`03001oogoo009oo`00@Woo00<007ooOol017oo00=5D7oo
Ool09goo0;e^/g;DK[=be6jcA[a2W4JlAYa>oDkLD_e>g5;mC]aBoDkLD_e>g5;mB]a:gDZlI[MR]VJg
H[HanRgIC_e>g4kmC]a>oDkLD_e>g5;mC]aBoE;lD_e>o5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<M
D_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`09Goo00<007ooOol02goo00<007ooOol00Woo0013Ool0
0`00Oomoo`03Ool00dEaOomoo`0XOol00g;CL]Abd`02Ool4AY`02dkmC]a>g4klD_e>g4kmC]a>oDkL
C_d00d[M0fJg00@]fC7I<MU>g@=>g005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`XOol00`00Oomoo`0;Ool00`00Oomoo`02Ool004Aoo`03
001oogoo009oo`03AE1oogoo02Qoo`03L]A^/goo009oo`0@00i>gDZlC]e:g5;mC]aBoDkLD_e>g5;m
C]a>oD[LC_d2:Ud0WV:fI[MR]VJg;MTanRgID_e>g5;mC]aBoDkLD_e>g5;mC]aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d]Ool00`00Oomoo`0;Ool00`00Oomoo`01Ool004Eo
o`80009oo`03AE5oogoo02eoo`803P06C]e:g4kLC]aBoDkL0Tkl00MBoDkLC_e>o4kmC]a>g@02I[L0
16:fI[L000000dZl00EBoDkLC_a>g5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00=BoE;lD_`0<Goo00<007ooOol02Woo00<007ooOol00Goo0017Ool00`00Oomoo`0_Ool0ZP0=00h0
3TkmC]aBoDkLD_e>g5;mC]aBoDkLD_e>g4[MB[a:gF:fI[MR]VJg;MTanTZlB]e:_5;mC]aBoDkLD_e>
g5;mC_aBoDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_deOol00`00Oomoo`09Ool00`00Oomoo`01
Ool004Qoo`03001oogoo02moo`=6W00<C_e>g4kLC]aBoDkLC_e>o4kmC]a>oDkL0T[M0fJg00AR]S7I
<MTafP=>g005C]e>o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lOol0>7oo00<007ooOol0
2Goo00<007ooOol00Goo0019Ool00`00Oomoo`0_Ool0XD:LA[a6W5;mC]aBoDkLD_e>g5;mC]a>oD[L
C_e>g2YM:SaV]f:fI[MRUS7j;MTanTkLD_e>g5;mC]aBoDkLD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0?Goo
00<007ooOol027oo00<007ooOol00Goo001:Ool2000`Ool054[LC]a>g4kmC]a>o4kLD_e>g4kmC_a>
oDkLC]e>g6JgH[IV]fJfI[L4B[`014kLC_a>g5;m0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00IBoE;lD_aBo5;mD_a1Ool00`00Oomoo`07
Ool00`00Oomoo`01Ool004aoo`03001oogoo02ioo`0BB[a>gD[LD_e>g5;mC]aBoDkLD_e>g4[MB[a:
gD[LI[MRUVJg0P0008A:_4[MB[a:g4kLD_e>g5;mC]aBoDklD_e>o5;mD_aBoE;lD_eBo5;mD_aC7E;l
D_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_e6Ool00`00Oomoo`06Ool00`00Oomo
o`01Ool004eoo`03001oogoo02ioo`=>g008C_e>g4klC_a>oDkLC_e>g0=:g@06I[IV]f:fI[LafC7J
0dkL00E>gDklD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m04Uoo`03001oogoo00Moo`40005oo`5oo`00CWoo00<007ooOol0;Woo091>
g5;mC]aBoDkLD_e>g5;mC]aBoDkLB]e:_4[M:UeV]f:F<OX]fC7jC]a>oDkLC_e>g5;mC]aBoDkLD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_e=Ool00`00Oomoo`06
Ool10001Ool1Ool004moo`8002moo`0;C]a>o4kLC_e>g4kmC_aBoDkLC]e>g002:Ud016JgI[IV]f:f
0S7I00DafTkLC_a>g5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eB
o5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;lDWoo00<007ooOol01Goo0@000Goo0Goo001AOol00`00Oomoo`0]Ool03dkLD_e>g5;mC]aBoDkL
D_e:g4kmC]aV]f:FI[MR]P020000MT[MB[a:g4ZlD_e>g5;mC]aBoDklD_e>g5;mD_aBoDklD_eBo5;m
D_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lEGoo00<007ooOol01Goo0@000Goo0Goo001BOol00`00Oomoo`0]Ool0
24kLC_a>o5;mC]a>oDkLC_d3B]d01VJgH[IV]fJf<MX]f@9>g006C]e>g5;lD_aBoDkl0U;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo5Uoo`03001oogoo00Aoo`40005oo`5oo`00Dgoo00<007ooOol0
;Goo07m>g5;mC]aBoDkLD_e>g5;mB[a:gF:fI[MRUVJg;MTanRgIC_e>g4kmC]aBoDkLD_e>g5;mD_aB
oDkLD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo01MOol00`00Oomoo`03Ool10001Ool1Ool005Aoo`03001oogoo02eo
o`0EC]a>oDklD_e>g4kMC]a>oBYMI[MV]VJgH[IV]c7I<MX]fDklC]aBoDkL009Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o003D_eBo5;l069oo`03001oogoo00=oo`40005oo`00EGoo0P00;Woo00a>g5;mC]aBoD[LC_e>g6Jg
HYIV]f:fI[L20000IDZlB]a:_5;mC]aBoDkLD_e>o5;mC]aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aC
7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0J7oo00<007ooOol00goo0@000Goo001G
Ool00`00Oomoo`0/Ool00dkLC_e>o004B]d01VJgH[IV]f:f<MXaf@=:_004C_aBo5;lD_d3D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo6aoo`03001o
ogoo009oo`40005oo`00F7oo00<007ooOol0;7oo06Y>g5;mC]aBoDZlB]eR]VJgHYIV]bgI<OX]fDkm
C]a>oDkLD_e>g5;mC]aBoE;lD_e>g5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<MD_aBoE;lDaeBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoG5oo`05001oogooOol00001Ool005Uoo`03001oogoo02aoo`04C]a>gDkLC_d2:Ud02f:fI[MR
]VJg<MTafS7IC_a>g5;mC]`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o003D_eBo5;l07Eoo`04001oogoo0001Ool005Yoo`8002eoo`1RB]a>oDkLC_eRUVJgH[IV]f:FB]e:
_4[LB[aBoDkLD_e>g5;mC_aBoDkLD_eBo5;mC]aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoGQoo`04
001oogoo0001Ool005aoo`03001oogoo02]oo`A:g@05H[IV]f:fI[L00004B[`2D_`01E;mC_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005
D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00U;lO7oo00<007oo00000Goo001MOol00`00Oomoo`0[
Ool0FTZlB]e:g6JgHYIV]f:f<OX]fDkmC]a>oDkLD_e>g5;mC]aBoE;lD_e>g5;mD_aBoDklD_eBo5;m
D_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoH1oo`40005oo`400000GWoo00<007ooOol0:goo0d[M00EV]f:fI[MR]S7j008af@03C]a>gDkL
009Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;l
D_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m009Bo8Aoo`800000Ggoo0P00;7oo054V?2YMH[IV]f:FI[M:
_4[LB[a:gDkLD_e>g5;mC_aBoDkLD_eBo5;mC]aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`0R7oo0P00001QOol00`00Oomoo`0ZOol016:fI[MR
]VJg0P0014Zl00=Bo5;mC_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo006D_eBo5;lD_aBoE;lRgoo0P00001ROol00`00Oomoo`0ZOol0AV:FI[Moogoo
;MTanTkLC_e>g4kmC]aBoDkLD_eBo5;mC]aBoE;lD_e>o5;mD_aBoE;lD_eBo5;mD_aC7E;lD_eBo5<M
D_aBoE;lDaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mSGoo10000Woo001SOol00`00Oomoo`0]Ool01C7j<MTafC7IC]d00TkL00=Bo5;m
D_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00=BoE;lD_`0S7oo10001Woo
001TOol2000^Ool0>d[LB[a:gDZlD_e>g5;mC]aBoDkLD_eBo5;mC]aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_d0Rgoo10002Woo001VOol00`00Oomoo`0/Ool3B[`00e;lD_e>o002D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@02D_b:Ool4000>Ool006Moo`03001oogoo02]oo`0dC]a>
oDkLC_e>g5;mC]aBoE;lD_e>g5;mD_aBoDklD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;lDaeBo5;mD_aC
7E;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_f:Ool3000BOol006Qoo`03001o
ogoo02]oo`06C]a>gDkLC]aBo5;m0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;m
D_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@02D_b9Ool4000EOol006Uoo`80
02aoo`0/C]aBoDkLD_e>g5;mC]aBoE;lD_e>g5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5<MD_aBoE;l
DaeBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoHQoo`@001Uoo`00Jgoo00<007ooOol0:goo
00EBoDklD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m
00=Bo004D_eBo5;lD_b:Ool4000MOol006aoo`03001oogoo02]oo`0PD_e>g5;mC]aBoDkLD_eBo5;m
C_aBoE;lD_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;lD_eBo5<MD_aBoE;lD_eBo8Uoo`@0025oo`00KGoo
00<007ooOol0:goo00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00ABoE;lD_aBo8Uoo`<002Eoo`00KWoo00<007ooOol0;7oo01M>g5;mC]aBoDkLD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lDaeBo5;mD_aC7E;l08Qoo`@002Qoo`00Kgoo0P00;Goo0e;l00EBoE;lD_aBo5;m
00=Bo005D_eBo5;lD_aBo@03D_b7Ool4000/Ool0075oo`03001oogoo02Yoo`0@D_e>g5;mD_aBoDkl
D_eBo5;mD_aBoE;lD_eBo5<MD_b6Ool4000`Ool0079oo`03001oogoo02Yoo`05D_eBo5;lD_aBo@03
D_`015;mD_aBo5;lQGoo1000=7oo001cOol00`00Oomoo`0ZOol01E;mC]aBoE;lD_d0Qgoo1000>7oo
001dOol2000/Ool00`00Oomoo`24Ool3000lOol007Ioo`03001oogoo02Uoo`03001oogoo081oo`@0
03moo`00Mgoo00<007ooOol0:7oo00<007ooOol0O7oo1000@goo001hOol00`00Oomoo`0WOol00`00
Oomoo`1hOol40017Ool007Uoo`8002Moo`03001oogoo07Aoo`@004]oo`00Ngoo00<007ooOol097oo
00<007ooOol0LGoo0`00Cgoo001lOol00`00Oomoo`0SOol00`00Oomoo`1]Ool4001BOol007eoo`03
001oogoo029oo`03001oogoo06Uoo`@005Ioo`00OWoo0P008Woo00<007ooOol0IGoo1000FWoo0020
Ool00`00Oomoo`0OOol00`00Oomoo`1QOol4001NOol0085oo`03001oogoo01ioo`03001oogoo05io
o`<0069oo`00PWoo00<007ooOol07Goo00<007ooOol0FWoo1000IGoo0023Ool00`00Oomoo`0LOol0
0`00Oomoo`1FOol4001YOol008Aoo`8001aoo`03001oogoo059oo`@006eoo`00QWoo00<007ooOol0
6Goo00<007ooOol0CWoo1000LGoo0027Ool00`00Oomoo`0HOol00`00Oomoo`1;Ool3001eOol008Qo
o`03001oogoo01Moo`03001oogoo04Moo`@007Qoo`00RGoo0P005goo00<007ooOol0@goo1000O7oo
002;Ool00`00Oomoo`0DOol00`00Oomoo`0oOol40020Ool008aoo`03001oogoo019oo`03001oogoo
03aoo`@008Aoo`00SGoo00<007ooOol04Goo00<007ooOol0>Goo0`00R7oo002>Ool2000AOol00`00
Oomoo`0eOol4002;Ool0091oo`03001oogoo00ioo`03001oogoo035oo`@008moo`00TGoo00<007oo
Ool03Goo00<007ooOol0;Goo1000Tgoo002BOol00`00Oomoo`0<Ool00`00Oomoo`0YOol4002GOol0
09=oo`8000aoo`03001oogoo02Eoo`@009]oo`00UGoo00<007ooOol02Goo00<007ooOol08Woo0`00
Wgoo002FOol00`00Oomoo`08Ool00`00Oomoo`0NOol4002ROol009Moo`03001oogoo00Moo`03001o
ogoo01Yoo`@00:Ioo`00V7oo00<007ooOol01Woo00<007ooOol05Woo1000ZWoo002IOol20006Ool0
0`00Oomoo`0BOol4002^Ool009]oo`03001oogoo00=oo`03001oogoo00moo`<00;9oo`00W7oo00<0
07ooOol00Woo00<007ooOol02goo1000]Goo002MOol01@00Oomoogoo00002Goo1000^Goo002NOol2
00000goo001oo`04Ool4002mOol00:1oo`800003Ool0000000800<5oo`00XGoo0P00aGoo003oOomY
Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00
ogooJGoo0000\
\>"],
  ImageRangeCache->{{{0, 359}, {290.875, 0}} -> {-0.0882282, 0.0218253, \
0.00362403, 0.00362403}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.11022e-16 1.04977 -0.0679587 1.04977 [
[.08733 .22266 -12 -8.87681 ]
[.08733 .22266 0 .12319 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.60704 .01829 -5.08896 -9 ]
[.60704 .01829 .91104 0 ]
[.29165 .07573 -9.31117 -15 ]
[.29165 .07573 .68883 0 ]
[.76162 .0881 0 -6.17057 ]
[.76162 .0881 12 2.82943 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.93925 .36012 0 -5.91342 ]
[.93925 .36012 6 3.08658 ]
[.91861 .21225 0 -10.0521 ]
[.91861 .21225 10 4.94788 ]
[.02494 .25992 -24 -2.73794 ]
[.02494 .25992 0 6.26206 ]
[.01611 .31527 -18 -2.78472 ]
[.01611 .31527 0 6.21528 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00254 .43215 -12 -2.88407 ]
[-0.00254 .43215 0 6.11593 ]
[-0.0124 .49393 -18 -2.93688 ]
[-0.0124 .49393 0 6.06312 ]
[-0.05457 .39542 -10 -4.72232 ]
[-0.05457 .39542 0 10.2777 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09674 .23181 m
.10144 .23638 L
s
[(-5)] .08733 .22266 1 .97262 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.61454 .02905 m
.61829 .03444 L
s
[(5)] .60704 .01829 .69632 1 Mshowa
.125 Mabswid
.14416 .21324 m
.14694 .21603 L
s
.19248 .19432 m
.19521 .19716 L
s
.24172 .17504 m
.2444 .17792 L
s
.2919 .15539 m
.29453 .15832 L
s
.39523 .11493 m
.39774 .11796 L
s
.44843 .0941 m
.45088 .09718 L
s
.50269 .07285 m
.50508 .07598 L
s
.55805 .05117 m
.56037 .05435 L
s
.05019 .25004 m
.05305 .25274 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.74932 .09266 m
.74316 .09495 L
s
[(-2)] .76162 .0881 -1 .37124 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.92673 .36405 m
.92047 .36602 L
s
[(2)] .93925 .36012 -1 .31409 Mshowa
.125 Mabswid
.77428 .13086 m
.77058 .1322 L
s
.79837 .1677 m
.79466 .16902 L
s
.82162 .20326 m
.8179 .20455 L
s
.86578 .27081 m
.86204 .27206 L
s
.88677 .30292 m
.88302 .30414 L
s
.90707 .33398 m
.90332 .33518 L
s
.72342 .05305 m
.71974 .05445 L
s
.69654 .01193 m
.69287 .01336 L
s
.94577 .39318 m
.94201 .39434 L
s
.96423 .4214 m
.96046 .42254 L
s
gsave
.91861 .21225 -61 -14.0521 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03716 .25514 m
.04327 .25274 L
s
[(-100)] .02494 .25992 1 -0.39157 Mshowa
.02837 .31059 m
.0345 .30825 L
s
[(-50)] .01611 .31527 1 -0.38117 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.00981 .42772 m
.01599 .4255 L
s
[(50)] -0.00254 .43215 1 -0.3591 Mshowa
0 .48963 m
.0062 .48748 L
s
[(100)] -0.0124 .49393 1 -0.34736 Mshowa
.125 Mabswid
.03543 .26607 m
.0391 .26464 L
s
.03368 .27708 m
.03735 .27566 L
s
.03193 .28817 m
.0356 .28676 L
s
.03016 .29934 m
.03383 .29793 L
s
.02658 .32192 m
.03026 .32053 L
s
.02477 .33334 m
.02845 .33195 L
s
.02295 .34483 m
.02663 .34345 L
s
.02111 .35641 m
.0248 .35504 L
s
.0174 .37983 m
.02109 .37847 L
s
.01552 .39167 m
.01922 .39032 L
s
.01363 .4036 m
.01733 .40225 L
s
.01173 .41561 m
.01543 .41428 L
s
.00788 .43991 m
.01159 .43859 L
s
.00593 .4522 m
.00964 .45089 L
s
.00397 .46458 m
.00768 .46328 L
s
.00199 .47706 m
.00571 .47576 L
s
gsave
-0.05457 .39542 -71 -8.72232 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(u) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.651 .747 .92 r
.39637 .69709 .40169 .70181 .41061 .69936 .4053 .69467 Mtetra
.654 .75 .92 r
.4053 .69467 .41061 .69936 .41956 .69684 .41427 .69216 Mtetra
.657 .752 .92 r
.41427 .69216 .41956 .69684 .42855 .69427 .42327 .6896 Mtetra
.658 .753 .92 r
.42327 .6896 .42855 .69427 .43756 .69167 .43231 .68699 Mtetra
.659 .753 .92 r
.43231 .68699 .43756 .69167 .4466 .68904 .44137 .68435 Mtetra
.659 .754 .92 r
.44137 .68435 .4466 .68904 .45568 .68641 .45046 .6817 Mtetra
.45046 .6817 .45568 .68641 .46478 .68377 .45958 .67904 Mtetra
.45958 .67904 .46478 .68377 .47391 .68113 .46874 .67638 Mtetra
.658 .753 .92 r
.46874 .67638 .47391 .68113 .48308 .67848 .47792 .67372 Mtetra
.47792 .67372 .48308 .67848 .49227 .67583 .48714 .67105 Mtetra
.48714 .67105 .49227 .67583 .5015 .67318 .49638 .66838 Mtetra
.49638 .66838 .5015 .67318 .51075 .67052 .50566 .6657 Mtetra
.50566 .6657 .51075 .67052 .52004 .66786 .51496 .66302 Mtetra
.51496 .66302 .52004 .66786 .52936 .66519 .5243 .66033 Mtetra
.5243 .66033 .52936 .66519 .5387 .66251 .53367 .65764 Mtetra
.657 .753 .92 r
.53367 .65764 .5387 .66251 .54809 .65983 .54307 .65494 Mtetra
.54307 .65494 .54809 .65983 .5575 .65713 .55251 .65223 Mtetra
.657 .752 .92 r
.55251 .65223 .5575 .65713 .56694 .65443 .56197 .64951 Mtetra
.56197 .64951 .56694 .65443 .57642 .65173 .57147 .64678 Mtetra
.57147 .64678 .57642 .65173 .58593 .64901 .581 .64405 Mtetra
.581 .64405 .58593 .64901 .59547 .64628 .59057 .64131 Mtetra
.59057 .64131 .59547 .64628 .60505 .64355 .60016 .63855 Mtetra
.60016 .63855 .60505 .64355 .61465 .64081 .60979 .63579 Mtetra
.60979 .63579 .61465 .64081 .62429 .63806 .61946 .63303 Mtetra
.61946 .63303 .62429 .63806 .63397 .6353 .62915 .63025 Mtetra
.62915 .63025 .63397 .6353 .64367 .63253 .63888 .62746 Mtetra
.63888 .62746 .64367 .63253 .65341 .62975 .64864 .62467 Mtetra
.64864 .62467 .65341 .62975 .66319 .62697 .65844 .62186 Mtetra
.65844 .62186 .66319 .62697 .67299 .62417 .66827 .61905 Mtetra
.66827 .61905 .67299 .62417 .68283 .62137 .67814 .61623 Mtetra
.67814 .61623 .68283 .62137 .69271 .61855 .68804 .6134 Mtetra
.68804 .6134 .69271 .61855 .70262 .61573 .69797 .61055 Mtetra
.69797 .61055 .70262 .61573 .71257 .6129 .70794 .6077 Mtetra
.70794 .6077 .71257 .6129 .72255 .61005 .71794 .60484 Mtetra
.71794 .60484 .72255 .61005 .73256 .6072 .72798 .60197 Mtetra
.72798 .60197 .73256 .6072 .74261 .60434 .73806 .59909 Mtetra
.73806 .59909 .74261 .60434 .75269 .60147 .74817 .5962 Mtetra
.74817 .5962 .75269 .60147 .76282 .59859 .75831 .5933 Mtetra
.75831 .5933 .76282 .59859 .77297 .5957 .76849 .59039 Mtetra
.76849 .59039 .77297 .5957 .78316 .5928 .77871 .58747 Mtetra
.77871 .58747 .78316 .5928 .79339 .58989 .78897 .58454 Mtetra
.78897 .58454 .79339 .58989 .80366 .58697 .79926 .5816 Mtetra
.79926 .5816 .80366 .58697 .81396 .58404 .80958 .57865 Mtetra
.80958 .57865 .81396 .58404 .8243 .5811 .81995 .57569 Mtetra
.81995 .57569 .8243 .5811 .83467 .57815 .83035 .57272 Mtetra
.83035 .57272 .83467 .57815 .84508 .57519 .84079 .56974 Mtetra
.84079 .56974 .84508 .57519 .85553 .57221 .85126 .56675 Mtetra
.85126 .56675 .85553 .57221 .86602 .56923 .86178 .56375 Mtetra
.86178 .56375 .86602 .56923 .87654 .56624 .87233 .56074 Mtetra
.87233 .56074 .87654 .56624 .8871 .56324 .88292 .55772 Mtetra
.88292 .55772 .8871 .56324 .8977 .56022 .89355 .55468 Mtetra
.89355 .55468 .8977 .56022 .90834 .5572 .90421 .55164 Mtetra
.90421 .55164 .90834 .5572 .91902 .55416 .91492 .54858 Mtetra
.91492 .54858 .91902 .55416 .92974 .55112 .92566 .54552 Mtetra
.92566 .54552 .92974 .55112 .94049 .54806 .93645 .54244 Mtetra
.93645 .54244 .94049 .54806 .95128 .545 .94727 .53935 Mtetra
.94727 .53935 .95128 .545 .96212 .54192 .95813 .53625 Mtetra
.95813 .53625 .96212 .54192 .97299 .53883 .96904 .53314 Mtetra
.96904 .53314 .97299 .53883 .9839 .53573 .97998 .53002 Mtetra
.648 .745 .92 r
.39101 .6923 .39637 .69709 .4053 .69467 .39996 .68993 Mtetra
.653 .749 .92 r
.39996 .68993 .4053 .69467 .41427 .69216 .40895 .68744 Mtetra
.656 .751 .92 r
.40895 .68744 .41427 .69216 .42327 .6896 .41797 .68488 Mtetra
.657 .752 .92 r
.41797 .68488 .42327 .6896 .43231 .68699 .42702 .68227 Mtetra
.658 .753 .92 r
.42702 .68227 .43231 .68699 .44137 .68435 .4361 .67963 Mtetra
.659 .754 .92 r
.4361 .67963 .44137 .68435 .45046 .6817 .44521 .67697 Mtetra
.44521 .67697 .45046 .6817 .45958 .67904 .45436 .67429 Mtetra
.45436 .67429 .45958 .67904 .46874 .67638 .46353 .67161 Mtetra
.659 .753 .92 r
.46353 .67161 .46874 .67638 .47792 .67372 .47273 .66893 Mtetra
.658 .753 .92 r
.47273 .66893 .47792 .67372 .48714 .67105 .48197 .66624 Mtetra
.48197 .66624 .48714 .67105 .49638 .66838 .49123 .66355 Mtetra
.49123 .66355 .49638 .66838 .50566 .6657 .50053 .66086 Mtetra
.50053 .66086 .50566 .6657 .51496 .66302 .50986 .65816 Mtetra
.50986 .65816 .51496 .66302 .5243 .66033 .51922 .65545 Mtetra
.51922 .65545 .5243 .66033 .53367 .65764 .52861 .65274 Mtetra
.657 .753 .92 r
.52861 .65274 .53367 .65764 .54307 .65494 .53803 .65002 Mtetra
.53803 .65002 .54307 .65494 .55251 .65223 .54749 .64729 Mtetra
.54749 .64729 .55251 .65223 .56197 .64951 .55697 .64455 Mtetra
.657 .752 .92 r
.55697 .64455 .56197 .64951 .57147 .64678 .56649 .64181 Mtetra
.56649 .64181 .57147 .64678 .581 .64405 .57605 .63906 Mtetra
.57605 .63906 .581 .64405 .59057 .64131 .58563 .6363 Mtetra
.58563 .6363 .59057 .64131 .60016 .63855 .59525 .63353 Mtetra
.59525 .63353 .60016 .63855 .60979 .63579 .6049 .63075 Mtetra
.6049 .63075 .60979 .63579 .61946 .63303 .61459 .62796 Mtetra
.61459 .62796 .61946 .63303 .62915 .63025 .62431 .62517 Mtetra
.62431 .62517 .62915 .63025 .63888 .62746 .63406 .62236 Mtetra
.63406 .62236 .63888 .62746 .64864 .62467 .64384 .61955 Mtetra
.64384 .61955 .64864 .62467 .65844 .62186 .65366 .61673 Mtetra
.65366 .61673 .65844 .62186 .66827 .61905 .66352 .6139 Mtetra
.66352 .6139 .66827 .61905 .67814 .61623 .67341 .61106 Mtetra
.67341 .61106 .67814 .61623 .68804 .6134 .68333 .6082 Mtetra
.68333 .6082 .68804 .6134 .69797 .61055 .69329 .60534 Mtetra
.69329 .60534 .69797 .61055 .70794 .6077 .70328 .60247 Mtetra
.70328 .60247 .70794 .6077 .71794 .60484 .71331 .5996 Mtetra
.71331 .5996 .71794 .60484 .72798 .60197 .72338 .59671 Mtetra
.72338 .59671 .72798 .60197 .73806 .59909 .73347 .59381 Mtetra
.73347 .59381 .73806 .59909 .74817 .5962 .74361 .5909 Mtetra
.74361 .5909 .74817 .5962 .75831 .5933 .75378 .58798 Mtetra
.75378 .58798 .75831 .5933 .76849 .59039 .76399 .58505 Mtetra
.76399 .58505 .76849 .59039 .77871 .58747 .77423 .58211 Mtetra
.77423 .58211 .77871 .58747 .78897 .58454 .78451 .57916 Mtetra
.78451 .57916 .78897 .58454 .79926 .5816 .79483 .5762 Mtetra
.79483 .5762 .79926 .5816 .80958 .57865 .80518 .57324 Mtetra
.80518 .57324 .80958 .57865 .81995 .57569 .81557 .57026 Mtetra
.81557 .57026 .81995 .57569 .83035 .57272 .826 .56727 Mtetra
.826 .56727 .83035 .57272 .84079 .56974 .83647 .56426 Mtetra
.83647 .56426 .84079 .56974 .85126 .56675 .84697 .56125 Mtetra
.84697 .56125 .85126 .56675 .86178 .56375 .85751 .55823 Mtetra
.85751 .55823 .86178 .56375 .87233 .56074 .86809 .5552 Mtetra
.86809 .5552 .87233 .56074 .88292 .55772 .87871 .55216 Mtetra
.87871 .55216 .88292 .55772 .89355 .55468 .88936 .5491 Mtetra
.88936 .5491 .89355 .55468 .90421 .55164 .90006 .54604 Mtetra
.90006 .54604 .90421 .55164 .91492 .54858 .91079 .54296 Mtetra
.91079 .54296 .91492 .54858 .92566 .54552 .92157 .53987 Mtetra
.92157 .53987 .92566 .54552 .93645 .54244 .93238 .53678 Mtetra
.93238 .53678 .93645 .54244 .94727 .53935 .94323 .53367 Mtetra
.94323 .53367 .94727 .53935 .95813 .53625 .95412 .53055 Mtetra
.95412 .53055 .95813 .53625 .96904 .53314 .96506 .52741 Mtetra
.96506 .52741 .96904 .53314 .97998 .53002 .97603 .52427 Mtetra
.644 .742 .92 r
.38562 .68743 .39101 .6923 .39996 .68993 .39459 .68514 Mtetra
.651 .747 .92 r
.39459 .68514 .39996 .68993 .40895 .68744 .40359 .68268 Mtetra
.654 .75 .92 r
.40359 .68268 .40895 .68744 .41797 .68488 .41263 .68013 Mtetra
.657 .752 .92 r
.41263 .68013 .41797 .68488 .42702 .68227 .4217 .67753 Mtetra
.658 .753 .92 r
.4217 .67753 .42702 .68227 .4361 .67963 .4308 .67488 Mtetra
.659 .753 .92 r
.4308 .67488 .4361 .67963 .44521 .67697 .43993 .6722 Mtetra
.659 .754 .92 r
.43993 .6722 .44521 .67697 .45436 .67429 .4491 .66951 Mtetra
.4491 .66951 .45436 .67429 .46353 .67161 .45829 .66681 Mtetra
.45829 .66681 .46353 .67161 .47273 .66893 .46751 .66411 Mtetra
.658 .753 .92 r
.46751 .66411 .47273 .66893 .48197 .66624 .47677 .6614 Mtetra
.47677 .6614 .48197 .66624 .49123 .66355 .48605 .65869 Mtetra
.48605 .65869 .49123 .66355 .50053 .66086 .49537 .65598 Mtetra
.49537 .65598 .50053 .66086 .50986 .65816 .50472 .65326 Mtetra
.50472 .65326 .50986 .65816 .51922 .65545 .5141 .65054 Mtetra
.5141 .65054 .51922 .65545 .52861 .65274 .52351 .6478 Mtetra
.52351 .6478 .52861 .65274 .53803 .65002 .53296 .64507 Mtetra
.657 .753 .92 r
.53296 .64507 .53803 .65002 .54749 .64729 .54243 .64232 Mtetra
.54243 .64232 .54749 .64729 .55697 .64455 .55194 .63957 Mtetra
.657 .752 .92 r
.55194 .63957 .55697 .64455 .56649 .64181 .56148 .6368 Mtetra
.56148 .6368 .56649 .64181 .57605 .63906 .57106 .63403 Mtetra
.57106 .63403 .57605 .63906 .58563 .6363 .58067 .63126 Mtetra
.58067 .63126 .58563 .6363 .59525 .63353 .59031 .62847 Mtetra
.59031 .62847 .59525 .63353 .6049 .63075 .59998 .62567 Mtetra
.59998 .62567 .6049 .63075 .61459 .62796 .60969 .62287 Mtetra
.60969 .62287 .61459 .62796 .62431 .62517 .61943 .62005 Mtetra
.61943 .62005 .62431 .62517 .63406 .62236 .62921 .61723 Mtetra
.62921 .61723 .63406 .62236 .64384 .61955 .63901 .6144 Mtetra
.63901 .6144 .64384 .61955 .65366 .61673 .64886 .61156 Mtetra
.64886 .61156 .65366 .61673 .66352 .6139 .65874 .60871 Mtetra
.65874 .60871 .66352 .6139 .67341 .61106 .66865 .60585 Mtetra
.66865 .60585 .67341 .61106 .68333 .6082 .6786 .60298 Mtetra
.6786 .60298 .68333 .6082 .69329 .60534 .68858 .6001 Mtetra
.68858 .6001 .69329 .60534 .70328 .60247 .6986 .59721 Mtetra
.6986 .59721 .70328 .60247 .71331 .5996 .70865 .59431 Mtetra
.70865 .59431 .71331 .5996 .72338 .59671 .71874 .59141 Mtetra
.71874 .59141 .72338 .59671 .73347 .59381 .72886 .58849 Mtetra
.72886 .58849 .73347 .59381 .74361 .5909 .73902 .58556 Mtetra
.73902 .58556 .74361 .5909 .75378 .58798 .74922 .58262 Mtetra
.74922 .58262 .75378 .58798 .76399 .58505 .75945 .57967 Mtetra
.75945 .57967 .76399 .58505 .77423 .58211 .76972 .57672 Mtetra
.76972 .57672 .77423 .58211 .78451 .57916 .78003 .57375 Mtetra
.78003 .57375 .78451 .57916 .79483 .5762 .79037 .57077 Mtetra
.79037 .57077 .79483 .5762 .80518 .57324 .80075 .56778 Mtetra
.80075 .56778 .80518 .57324 .81557 .57026 .81117 .56478 Mtetra
.81117 .56478 .81557 .57026 .826 .56727 .82162 .56177 Mtetra
.82162 .56177 .826 .56727 .83647 .56426 .83212 .55875 Mtetra
.83212 .55875 .83647 .56426 .84697 .56125 .84265 .55572 Mtetra
.84265 .55572 .84697 .56125 .85751 .55823 .85321 .55268 Mtetra
.85321 .55268 .85751 .55823 .86809 .5552 .86382 .54962 Mtetra
.86382 .54962 .86809 .5552 .87871 .55216 .87447 .54656 Mtetra
.87447 .54656 .87871 .55216 .88936 .5491 .88515 .54348 Mtetra
.88515 .54348 .88936 .5491 .90006 .54604 .89588 .5404 Mtetra
.89588 .5404 .90006 .54604 .91079 .54296 .90664 .5373 Mtetra
.90664 .5373 .91079 .54296 .92157 .53987 .91744 .53419 Mtetra
.91744 .53419 .92157 .53987 .93238 .53678 .92828 .53107 Mtetra
.92828 .53107 .93238 .53678 .94323 .53367 .93916 .52794 Mtetra
.93916 .52794 .94323 .53367 .95412 .53055 .95009 .5248 Mtetra
.95009 .5248 .95412 .53055 .96506 .52741 .96105 .52165 Mtetra
.96105 .52165 .96506 .52741 .97603 .52427 .97205 .51849 Mtetra
.637 .736 .92 r
.38021 .68242 .38562 .68743 .39459 .68514 .38918 .68028 Mtetra
.648 .745 .92 r
.38918 .68028 .39459 .68514 .40359 .68268 .3982 .67787 Mtetra
.653 .749 .92 r
.3982 .67787 .40359 .68268 .41263 .68013 .40726 .67534 Mtetra
.656 .751 .92 r
.40726 .67534 .41263 .68013 .4217 .67753 .41635 .67274 Mtetra
.657 .752 .92 r
.41635 .67274 .4217 .67753 .4308 .67488 .42547 .67009 Mtetra
.658 .753 .92 r
.42547 .67009 .4308 .67488 .43993 .6722 .43462 .6674 Mtetra
.659 .754 .92 r
.43462 .6674 .43993 .6722 .4491 .66951 .4438 .6647 Mtetra
.4438 .6647 .4491 .66951 .45829 .66681 .45301 .66198 Mtetra
.45301 .66198 .45829 .66681 .46751 .66411 .46226 .65926 Mtetra
.659 .753 .92 r
.46226 .65926 .46751 .66411 .47677 .6614 .47153 .65653 Mtetra
.658 .753 .92 r
.47153 .65653 .47677 .6614 .48605 .65869 .48084 .6538 Mtetra
.48084 .6538 .48605 .65869 .49537 .65598 .49018 .65107 Mtetra
.49018 .65107 .49537 .65598 .50472 .65326 .49955 .64833 Mtetra
.49955 .64833 .50472 .65326 .5141 .65054 .50895 .64559 Mtetra
.50895 .64559 .5141 .65054 .52351 .6478 .51838 .64284 Mtetra
.51838 .64284 .52351 .6478 .53296 .64507 .52785 .64008 Mtetra
.657 .753 .92 r
.52785 .64008 .53296 .64507 .54243 .64232 .53735 .63732 Mtetra
.53735 .63732 .54243 .64232 .55194 .63957 .54688 .63455 Mtetra
.54688 .63455 .55194 .63957 .56148 .6368 .55644 .63177 Mtetra
.657 .752 .92 r
.55644 .63177 .56148 .6368 .57106 .63403 .56604 .62898 Mtetra
.56604 .62898 .57106 .63403 .58067 .63126 .57567 .62618 Mtetra
.57567 .62618 .58067 .63126 .59031 .62847 .58533 .62338 Mtetra
.58533 .62338 .59031 .62847 .59998 .62567 .59503 .62056 Mtetra
.59503 .62056 .59998 .62567 .60969 .62287 .60476 .61774 Mtetra
.60476 .61774 .60969 .62287 .61943 .62005 .61452 .61491 Mtetra
.61452 .61491 .61943 .62005 .62921 .61723 .62432 .61207 Mtetra
.62432 .61207 .62921 .61723 .63901 .6144 .63415 .60922 Mtetra
.63415 .60922 .63901 .6144 .64886 .61156 .64402 .60636 Mtetra
.64402 .60636 .64886 .61156 .65874 .60871 .65392 .60349 Mtetra
.65392 .60349 .65874 .60871 .66865 .60585 .66386 .60061 Mtetra
.66386 .60061 .66865 .60585 .6786 .60298 .67383 .59772 Mtetra
.67383 .59772 .6786 .60298 .68858 .6001 .68384 .59482 Mtetra
.68384 .59482 .68858 .6001 .6986 .59721 .69388 .59192 Mtetra
.69388 .59192 .6986 .59721 .70865 .59431 .70396 .589 Mtetra
.70396 .589 .70865 .59431 .71874 .59141 .71407 .58607 Mtetra
.71407 .58607 .71874 .59141 .72886 .58849 .72422 .58313 Mtetra
.72422 .58313 .72886 .58849 .73902 .58556 .73441 .58019 Mtetra
.73441 .58019 .73902 .58556 .74922 .58262 .74463 .57723 Mtetra
.74463 .57723 .74922 .58262 .75945 .57967 .75489 .57426 Mtetra
.75489 .57426 .75945 .57967 .76972 .57672 .76518 .57128 Mtetra
.76518 .57128 .76972 .57672 .78003 .57375 .77551 .5683 Mtetra
.77551 .5683 .78003 .57375 .79037 .57077 .78588 .5653 Mtetra
.78588 .5653 .79037 .57077 .80075 .56778 .79629 .56229 Mtetra
.79629 .56229 .80075 .56778 .81117 .56478 .80673 .55927 Mtetra
.80673 .55927 .81117 .56478 .82162 .56177 .81721 .55624 Mtetra
.81721 .55624 .82162 .56177 .83212 .55875 .82773 .5532 Mtetra
.82773 .5532 .83212 .55875 .84265 .55572 .83829 .55014 Mtetra
.83829 .55014 .84265 .55572 .85321 .55268 .84889 .54708 Mtetra
.84889 .54708 .85321 .55268 .86382 .54962 .85952 .54401 Mtetra
.85952 .54401 .86382 .54962 .87447 .54656 .8702 .54092 Mtetra
.8702 .54092 .87447 .54656 .88515 .54348 .88091 .53783 Mtetra
.88091 .53783 .88515 .54348 .89588 .5404 .89166 .53472 Mtetra
.89166 .53472 .89588 .5404 .90664 .5373 .90245 .5316 Mtetra
.90245 .5316 .90664 .5373 .91744 .53419 .91329 .52848 Mtetra
.91329 .52848 .91744 .53419 .92828 .53107 .92416 .52534 Mtetra
.92416 .52534 .92828 .53107 .93916 .52794 .93507 .52218 Mtetra
.93507 .52218 .93916 .52794 .95009 .5248 .94602 .51902 Mtetra
.94602 .51902 .95009 .5248 .96105 .52165 .95701 .51585 Mtetra
.95701 .51585 .96105 .52165 .97205 .51849 .96805 .51266 Mtetra
.621 .721 .918 r
.37477 .67712 .38021 .68242 .38918 .68028 .38375 .67533 Mtetra
.644 .742 .92 r
.38375 .67533 .38918 .68028 .3982 .67787 .39278 .673 Mtetra
.651 .747 .92 r
.39278 .673 .3982 .67787 .40726 .67534 .40186 .6705 Mtetra
.654 .75 .92 r
.40186 .6705 .40726 .67534 .41635 .67274 .41096 .66791 Mtetra
.657 .752 .92 r
.41096 .66791 .41635 .67274 .42547 .67009 .4201 .66526 Mtetra
.658 .753 .92 r
.4201 .66526 .42547 .67009 .43462 .6674 .42927 .66257 Mtetra
.659 .753 .92 r
.42927 .66257 .43462 .6674 .4438 .6647 .43847 .65985 Mtetra
.659 .754 .92 r
.43847 .65985 .4438 .6647 .45301 .66198 .44771 .65712 Mtetra
.44771 .65712 .45301 .66198 .46226 .65926 .45697 .65438 Mtetra
.45697 .65438 .46226 .65926 .47153 .65653 .46627 .65163 Mtetra
.658 .753 .92 r
.46627 .65163 .47153 .65653 .48084 .6538 .47559 .64888 Mtetra
.47559 .64888 .48084 .6538 .49018 .65107 .48495 .64613 Mtetra
.48495 .64613 .49018 .65107 .49955 .64833 .49434 .64338 Mtetra
.49434 .64338 .49955 .64833 .50895 .64559 .50377 .64061 Mtetra
.50377 .64061 .50895 .64559 .51838 .64284 .51322 .63785 Mtetra
.51322 .63785 .51838 .64284 .52785 .64008 .52271 .63507 Mtetra
.52271 .63507 .52785 .64008 .53735 .63732 .53223 .63229 Mtetra
.657 .753 .92 r
.53223 .63229 .53735 .63732 .54688 .63455 .54178 .6295 Mtetra
.54178 .6295 .54688 .63455 .55644 .63177 .55137 .6267 Mtetra
.657 .752 .92 r
.55137 .6267 .55644 .63177 .56604 .62898 .56098 .62389 Mtetra
.56098 .62389 .56604 .62898 .57567 .62618 .57064 .62108 Mtetra
.57064 .62108 .57567 .62618 .58533 .62338 .58032 .61825 Mtetra
.58032 .61825 .58533 .62338 .59503 .62056 .59004 .61542 Mtetra
.59004 .61542 .59503 .62056 .60476 .61774 .5998 .61258 Mtetra
.5998 .61258 .60476 .61774 .61452 .61491 .60958 .60973 Mtetra
.60958 .60973 .61452 .61491 .62432 .61207 .6194 .60687 Mtetra
.6194 .60687 .62432 .61207 .63415 .60922 .62926 .604 Mtetra
.62926 .604 .63415 .60922 .64402 .60636 .63915 .60112 Mtetra
.63915 .60112 .64402 .60636 .65392 .60349 .64908 .59823 Mtetra
.64908 .59823 .65392 .60349 .66386 .60061 .65904 .59534 Mtetra
.65904 .59534 .66386 .60061 .67383 .59772 .66903 .59243 Mtetra
.66903 .59243 .67383 .59772 .68384 .59482 .67906 .58951 Mtetra
.67906 .58951 .68384 .59482 .69388 .59192 .68913 .58659 Mtetra
.68913 .58659 .69388 .59192 .70396 .589 .69923 .58365 Mtetra
.69923 .58365 .70396 .589 .71407 .58607 .70937 .5807 Mtetra
.70937 .5807 .71407 .58607 .72422 .58313 .71955 .57775 Mtetra
.71955 .57775 .72422 .58313 .73441 .58019 .72976 .57478 Mtetra
.72976 .57478 .73441 .58019 .74463 .57723 .74 .5718 Mtetra
.74 .5718 .74463 .57723 .75489 .57426 .75029 .56881 Mtetra
.75029 .56881 .75489 .57426 .76518 .57128 .76061 .56582 Mtetra
.76061 .56582 .76518 .57128 .77551 .5683 .77097 .56281 Mtetra
.77097 .56281 .77551 .5683 .78588 .5653 .78136 .55979 Mtetra
.78136 .55979 .78588 .5653 .79629 .56229 .7918 .55676 Mtetra
.7918 .55676 .79629 .56229 .80673 .55927 .80227 .55372 Mtetra
.80227 .55372 .80673 .55927 .81721 .55624 .81278 .55067 Mtetra
.81278 .55067 .81721 .55624 .82773 .5532 .82333 .54761 Mtetra
.82333 .54761 .82773 .5532 .83829 .55014 .83391 .54453 Mtetra
.83391 .54453 .83829 .55014 .84889 .54708 .84454 .54145 Mtetra
.84454 .54145 .84889 .54708 .85952 .54401 .8552 .53836 Mtetra
.8552 .53836 .85952 .54401 .8702 .54092 .8659 .53525 Mtetra
.8659 .53525 .8702 .54092 .88091 .53783 .87664 .53214 Mtetra
.87664 .53214 .88091 .53783 .89166 .53472 .88742 .52901 Mtetra
.88742 .52901 .89166 .53472 .90245 .5316 .89824 .52587 Mtetra
.89824 .52587 .90245 .5316 .91329 .52848 .9091 .52272 Mtetra
.9091 .52272 .91329 .52848 .92416 .52534 .92 .51956 Mtetra
.92 .51956 .92416 .52534 .93507 .52218 .93095 .51638 Mtetra
.93095 .51638 .93507 .52218 .94602 .51902 .94193 .5132 Mtetra
.94193 .5132 .94602 .51902 .95701 .51585 .95295 .51 Mtetra
.95295 .51 .95701 .51585 .96805 .51266 .96401 .50679 Mtetra
.569 .668 .905 r
.36934 .67084 .37477 .67712 .38375 .67533 .37828 .67024 Mtetra
.637 .736 .92 r
.37828 .67024 .38375 .67533 .39278 .673 .38733 .66806 Mtetra
.648 .745 .92 r
.38733 .66806 .39278 .673 .40186 .6705 .39642 .66561 Mtetra
.653 .749 .92 r
.39642 .66561 .40186 .6705 .41096 .66791 .40554 .66304 Mtetra
.656 .751 .92 r
.40554 .66304 .41096 .66791 .4201 .66526 .4147 .6604 Mtetra
.657 .752 .92 r
.4147 .6604 .4201 .66526 .42927 .66257 .42389 .65771 Mtetra
.658 .753 .92 r
.42389 .65771 .42927 .66257 .43847 .65985 .43311 .65498 Mtetra
.659 .754 .92 r
.43311 .65498 .43847 .65985 .44771 .65712 .44237 .65223 Mtetra
.44237 .65223 .44771 .65712 .45697 .65438 .45165 .64947 Mtetra
.45165 .64947 .45697 .65438 .46627 .65163 .46097 .6467 Mtetra
.659 .753 .92 r
.46097 .6467 .46627 .65163 .47559 .64888 .47032 .64394 Mtetra
.658 .753 .92 r
.47032 .64394 .47559 .64888 .48495 .64613 .4797 .64116 Mtetra
.4797 .64116 .48495 .64613 .49434 .64338 .48911 .63839 Mtetra
.48911 .63839 .49434 .64338 .50377 .64061 .49855 .63561 Mtetra
.49855 .63561 .50377 .64061 .51322 .63785 .50803 .63282 Mtetra
.50803 .63282 .51322 .63785 .52271 .63507 .51753 .63002 Mtetra
.51753 .63002 .52271 .63507 .53223 .63229 .52708 .62722 Mtetra
.657 .753 .92 r
.52708 .62722 .53223 .63229 .54178 .6295 .53665 .62441 Mtetra
.53665 .62441 .54178 .6295 .55137 .6267 .54626 .6216 Mtetra
.54626 .6216 .55137 .6267 .56098 .62389 .5559 .61877 Mtetra
.657 .752 .92 r
.5559 .61877 .56098 .62389 .57064 .62108 .56557 .61594 Mtetra
.56557 .61594 .57064 .62108 .58032 .61825 .57528 .6131 Mtetra
.57528 .6131 .58032 .61825 .59004 .61542 .58502 .61025 Mtetra
.58502 .61025 .59004 .61542 .5998 .61258 .5948 .60739 Mtetra
.5948 .60739 .5998 .61258 .60958 .60973 .60461 .60452 Mtetra
.60461 .60452 .60958 .60973 .6194 .60687 .61446 .60164 Mtetra
.61446 .60164 .6194 .60687 .62926 .604 .62434 .59875 Mtetra
.62434 .59875 .62926 .604 .63915 .60112 .63425 .59585 Mtetra
.63425 .59585 .63915 .60112 .64908 .59823 .6442 .59294 Mtetra
.6442 .59294 .64908 .59823 .65904 .59534 .65418 .59003 Mtetra
.65418 .59003 .65904 .59534 .66903 .59243 .6642 .5871 Mtetra
.6642 .5871 .66903 .59243 .67906 .58951 .67426 .58417 Mtetra
.67426 .58417 .67906 .58951 .68913 .58659 .68435 .58122 Mtetra
.68435 .58122 .68913 .58659 .69923 .58365 .69448 .57826 Mtetra
.69448 .57826 .69923 .58365 .70937 .5807 .70464 .5753 Mtetra
.70464 .5753 .70937 .5807 .71955 .57775 .71484 .57232 Mtetra
.71484 .57232 .71955 .57775 .72976 .57478 .72508 .56933 Mtetra
.72508 .56933 .72976 .57478 .74 .5718 .73535 .56634 Mtetra
.73535 .56634 .74 .5718 .75029 .56881 .74566 .56333 Mtetra
.74566 .56333 .75029 .56881 .76061 .56582 .75601 .56031 Mtetra
.75601 .56031 .76061 .56582 .77097 .56281 .76639 .55728 Mtetra
.76639 .55728 .77097 .56281 .78136 .55979 .77682 .55424 Mtetra
.77682 .55424 .78136 .55979 .7918 .55676 .78728 .55119 Mtetra
.78728 .55119 .7918 .55676 .80227 .55372 .79777 .54813 Mtetra
.79777 .54813 .80227 .55372 .81278 .55067 .80831 .54506 Mtetra
.80831 .54506 .81278 .55067 .82333 .54761 .81889 .54198 Mtetra
.81889 .54198 .82333 .54761 .83391 .54453 .8295 .53889 Mtetra
.8295 .53889 .83391 .54453 .84454 .54145 .84015 .53578 Mtetra
.84015 .53578 .84454 .54145 .8552 .53836 .85084 .53267 Mtetra
.85084 .53267 .8552 .53836 .8659 .53525 .86157 .52954 Mtetra
.86157 .52954 .8659 .53525 .87664 .53214 .87234 .5264 Mtetra
.87234 .5264 .87664 .53214 .88742 .52901 .88315 .52325 Mtetra
.88315 .52325 .88742 .52901 .89824 .52587 .894 .52009 Mtetra
.894 .52009 .89824 .52587 .9091 .52272 .90489 .51692 Mtetra
.90489 .51692 .9091 .52272 .92 .51956 .91582 .51374 Mtetra
.91582 .51374 .92 .51956 .93095 .51638 .92679 .51054 Mtetra
.92679 .51054 .93095 .51638 .94193 .5132 .93781 .50734 Mtetra
.93781 .50734 .94193 .5132 .95295 .51 .94886 .50412 Mtetra
.94886 .50412 .95295 .51 .96401 .50679 .95995 .50089 Mtetra
.029 .024 .514 r
.3653 .63393 .36934 .67084 .37828 .67024 .3728 .66487 Mtetra
.621 .721 .918 r
.3728 .66487 .37828 .67024 .38733 .66806 .38185 .66304 Mtetra
.644 .742 .92 r
.38185 .66304 .38733 .66806 .39642 .66561 .39095 .66067 Mtetra
.651 .747 .92 r
.39095 .66067 .39642 .66561 .40554 .66304 .40009 .65812 Mtetra
.654 .75 .92 r
.40009 .65812 .40554 .66304 .4147 .6604 .40927 .65549 Mtetra
.657 .752 .92 r
.40927 .65549 .4147 .6604 .42389 .65771 .41848 .6528 Mtetra
.658 .753 .92 r
.41848 .6528 .42389 .65771 .43311 .65498 .42772 .65007 Mtetra
.659 .753 .92 r
.42772 .65007 .43311 .65498 .44237 .65223 .43699 .64731 Mtetra
.659 .754 .92 r
.43699 .64731 .44237 .65223 .45165 .64947 .4463 .64453 Mtetra
.4463 .64453 .45165 .64947 .46097 .6467 .45563 .64175 Mtetra
.45563 .64175 .46097 .6467 .47032 .64394 .465 .63896 Mtetra
.658 .753 .92 r
.465 .63896 .47032 .64394 .4797 .64116 .4744 .63616 Mtetra
.4744 .63616 .4797 .64116 .48911 .63839 .48384 .63337 Mtetra
.48384 .63337 .48911 .63839 .49855 .63561 .4933 .63057 Mtetra
.4933 .63057 .49855 .63561 .50803 .63282 .5028 .62776 Mtetra
.5028 .62776 .50803 .63282 .51753 .63002 .51233 .62495 Mtetra
.51233 .62495 .51753 .63002 .52708 .62722 .52189 .62213 Mtetra
.52189 .62213 .52708 .62722 .53665 .62441 .53149 .6193 Mtetra
.657 .753 .92 r
.53149 .6193 .53665 .62441 .54626 .6216 .54112 .61646 Mtetra
.54112 .61646 .54626 .6216 .5559 .61877 .55078 .61362 Mtetra
.657 .752 .92 r
.55078 .61362 .5559 .61877 .56557 .61594 .56048 .61077 Mtetra
.56048 .61077 .56557 .61594 .57528 .6131 .57021 .60791 Mtetra
.57021 .60791 .57528 .6131 .58502 .61025 .57997 .60504 Mtetra
.57997 .60504 .58502 .61025 .5948 .60739 .58977 .60216 Mtetra
.58977 .60216 .5948 .60739 .60461 .60452 .59961 .59927 Mtetra
.59961 .59927 .60461 .60452 .61446 .60164 .60947 .59637 Mtetra
.60947 .59637 .61446 .60164 .62434 .59875 .61938 .59346 Mtetra
.61938 .59346 .62434 .59875 .63425 .59585 .62932 .59055 Mtetra
.62932 .59055 .63425 .59585 .6442 .59294 .63929 .58762 Mtetra
.63929 .58762 .6442 .59294 .65418 .59003 .6493 .58468 Mtetra
.6493 .58468 .65418 .59003 .6642 .5871 .65934 .58174 Mtetra
.65934 .58174 .6642 .5871 .67426 .58417 .66942 .57878 Mtetra
.66942 .57878 .67426 .58417 .68435 .58122 .67954 .57582 Mtetra
.67954 .57582 .68435 .58122 .69448 .57826 .68969 .57284 Mtetra
.68969 .57284 .69448 .57826 .70464 .5753 .69988 .56986 Mtetra
.69988 .56986 .70464 .5753 .71484 .57232 .71011 .56686 Mtetra
.71011 .56686 .71484 .57232 .72508 .56933 .72037 .56385 Mtetra
.72037 .56385 .72508 .56933 .73535 .56634 .73067 .56084 Mtetra
.73067 .56084 .73535 .56634 .74566 .56333 .741 .55781 Mtetra
.741 .55781 .74566 .56333 .75601 .56031 .75138 .55477 Mtetra
.75138 .55477 .75601 .56031 .76639 .55728 .76179 .55172 Mtetra
.76179 .55172 .76639 .55728 .77682 .55424 .77224 .54866 Mtetra
.77224 .54866 .77682 .55424 .78728 .55119 .78272 .54559 Mtetra
.78272 .54559 .78728 .55119 .79777 .54813 .79325 .54251 Mtetra
.79325 .54251 .79777 .54813 .80831 .54506 .80381 .53942 Mtetra
.80381 .53942 .80831 .54506 .81889 .54198 .81442 .53631 Mtetra
.81442 .53631 .81889 .54198 .8295 .53889 .82506 .5332 Mtetra
.82506 .5332 .8295 .53889 .84015 .53578 .83574 .53007 Mtetra
.83574 .53007 .84015 .53578 .85084 .53267 .84646 .52694 Mtetra
.84646 .52694 .85084 .53267 .86157 .52954 .85722 .52379 Mtetra
.85722 .52379 .86157 .52954 .87234 .5264 .86801 .52063 Mtetra
.86801 .52063 .87234 .5264 .88315 .52325 .87885 .51746 Mtetra
.87885 .51746 .88315 .52325 .894 .52009 .88973 .51428 Mtetra
.88973 .51428 .894 .52009 .90489 .51692 .90065 .51108 Mtetra
.90065 .51108 .90489 .51692 .91582 .51374 .91161 .50788 Mtetra
.91161 .50788 .91582 .51374 .92679 .51054 .92261 .50466 Mtetra
.92261 .50466 .92679 .51054 .93781 .50734 .93366 .50143 Mtetra
.93366 .50143 .93781 .50734 .94886 .50412 .94474 .49819 Mtetra
.94474 .49819 .94886 .50412 .95995 .50089 .95586 .49494 Mtetra
.441 .186 .431 r
.35793 .66788 .3653 .63393 .3728 .66487 .36732 .6585 Mtetra
.569 .668 .905 r
.36732 .6585 .3728 .66487 .38185 .66304 .37633 .65787 Mtetra
.637 .736 .92 r
.37633 .65787 .38185 .66304 .39095 .66067 .38545 .65565 Mtetra
.648 .745 .92 r
.38545 .65565 .39095 .66067 .40009 .65812 .3946 .65316 Mtetra
.653 .749 .92 r
.3946 .65316 .40009 .65812 .40927 .65549 .4038 .65055 Mtetra
.656 .751 .92 r
.4038 .65055 .40927 .65549 .41848 .6528 .41303 .64786 Mtetra
.657 .752 .92 r
.41303 .64786 .41848 .6528 .42772 .65007 .42229 .64513 Mtetra
.658 .753 .92 r
.42229 .64513 .42772 .65007 .43699 .64731 .43158 .64236 Mtetra
.659 .754 .92 r
.43158 .64236 .43699 .64731 .4463 .64453 .44091 .63956 Mtetra
.44091 .63956 .4463 .64453 .45563 .64175 .45027 .63676 Mtetra
.45027 .63676 .45563 .64175 .465 .63896 .45966 .63395 Mtetra
.659 .753 .92 r
.45966 .63395 .465 .63896 .4744 .63616 .46908 .63113 Mtetra
.658 .753 .92 r
.46908 .63113 .4744 .63616 .48384 .63337 .47853 .62832 Mtetra
.47853 .62832 .48384 .63337 .4933 .63057 .48802 .6255 Mtetra
.48802 .6255 .4933 .63057 .5028 .62776 .49754 .62267 Mtetra
.49754 .62267 .5028 .62776 .51233 .62495 .50709 .61984 Mtetra
.50709 .61984 .51233 .62495 .52189 .62213 .51667 .617 Mtetra
.51667 .617 .52189 .62213 .53149 .6193 .52629 .61415 Mtetra
.657 .753 .92 r
.52629 .61415 .53149 .6193 .54112 .61646 .53594 .6113 Mtetra
.53594 .6113 .54112 .61646 .55078 .61362 .54563 .60843 Mtetra
.54563 .60843 .55078 .61362 .56048 .61077 .55535 .60556 Mtetra
.657 .752 .92 r
.55535 .60556 .56048 .61077 .57021 .60791 .5651 .60268 Mtetra
.5651 .60268 .57021 .60791 .57997 .60504 .57489 .59979 Mtetra
.57489 .59979 .57997 .60504 .58977 .60216 .58471 .5969 Mtetra
.58471 .5969 .58977 .60216 .59961 .59927 .59457 .59399 Mtetra
.59457 .59399 .59961 .59927 .60947 .59637 .60446 .59107 Mtetra
.60446 .59107 .60947 .59637 .61938 .59346 .61439 .58814 Mtetra
.61439 .58814 .61938 .59346 .62932 .59055 .62435 .58521 Mtetra
.62435 .58521 .62932 .59055 .63929 .58762 .63435 .58226 Mtetra
.63435 .58226 .63929 .58762 .6493 .58468 .64438 .57931 Mtetra
.64438 .57931 .6493 .58468 .65934 .58174 .65445 .57634 Mtetra
.65445 .57634 .65934 .58174 .66942 .57878 .66455 .57337 Mtetra
.66455 .57337 .66942 .57878 .67954 .57582 .6747 .57038 Mtetra
.6747 .57038 .67954 .57582 .68969 .57284 .68487 .56738 Mtetra
.68487 .56738 .68969 .57284 .69988 .56986 .69509 .56438 Mtetra
.69509 .56438 .69988 .56986 .71011 .56686 .70534 .56136 Mtetra
.70534 .56136 .71011 .56686 .72037 .56385 .71563 .55833 Mtetra
.71563 .55833 .72037 .56385 .73067 .56084 .72595 .5553 Mtetra
.72595 .5553 .73067 .56084 .741 .55781 .73631 .55225 Mtetra
.73631 .55225 .741 .55781 .75138 .55477 .74671 .54919 Mtetra
.74671 .54919 .75138 .55477 .76179 .55172 .75715 .54612 Mtetra
.75715 .54612 .76179 .55172 .77224 .54866 .76763 .54304 Mtetra
.76763 .54304 .77224 .54866 .78272 .54559 .77814 .53995 Mtetra
.77814 .53995 .78272 .54559 .79325 .54251 .78869 .53685 Mtetra
.78869 .53685 .79325 .54251 .80381 .53942 .79929 .53373 Mtetra
.79929 .53373 .80381 .53942 .81442 .53631 .80992 .53061 Mtetra
.80992 .53061 .81442 .53631 .82506 .5332 .82058 .52747 Mtetra
.82058 .52747 .82506 .5332 .83574 .53007 .83129 .52433 Mtetra
.83129 .52433 .83574 .53007 .84646 .52694 .84204 .52117 Mtetra
.84204 .52117 .84646 .52694 .85722 .52379 .85283 .518 Mtetra
.85283 .518 .85722 .52379 .86801 .52063 .86366 .51482 Mtetra
.86366 .51482 .86801 .52063 .87885 .51746 .87453 .51163 Mtetra
.87453 .51163 .87885 .51746 .88973 .51428 .88543 .50842 Mtetra
.88543 .50842 .88973 .51428 .90065 .51108 .89638 .50521 Mtetra
.89638 .50521 .90065 .51108 .91161 .50788 .90737 .50198 Mtetra
.90737 .50198 .91161 .50788 .92261 .50466 .9184 .49874 Mtetra
.9184 .49874 .92261 .50466 .93366 .50143 .92948 .49549 Mtetra
.92948 .49549 .93366 .50143 .94474 .49819 .94059 .49222 Mtetra
.94059 .49222 .94474 .49819 .95586 .49494 .95175 .48895 Mtetra
.9 .71 .636 r
.35243 .661 .35793 .66788 .36732 .6585 .36326 .62138 Mtetra
.023 .019 .512 r
.36326 .62138 .36732 .6585 .37633 .65787 .3708 .65242 Mtetra
.621 .721 .918 r
.3708 .65242 .37633 .65787 .38545 .65565 .37991 .65055 Mtetra
.644 .742 .92 r
.37991 .65055 .38545 .65565 .3946 .65316 .38909 .64813 Mtetra
.651 .747 .92 r
.38909 .64813 .3946 .65316 .4038 .65055 .3983 .64555 Mtetra
.654 .75 .92 r
.3983 .64555 .4038 .65055 .41303 .64786 .40754 .64288 Mtetra
.657 .752 .92 r
.40754 .64288 .41303 .64786 .42229 .64513 .41683 .64014 Mtetra
.658 .753 .92 r
.41683 .64014 .42229 .64513 .43158 .64236 .42614 .63737 Mtetra
.659 .753 .92 r
.42614 .63737 .43158 .64236 .44091 .63956 .43549 .63456 Mtetra
.659 .754 .92 r
.43549 .63456 .44091 .63956 .45027 .63676 .44486 .63174 Mtetra
.44486 .63174 .45027 .63676 .45966 .63395 .45427 .62891 Mtetra
.45427 .62891 .45966 .63395 .46908 .63113 .46372 .62607 Mtetra
.658 .753 .92 r
.46372 .62607 .46908 .63113 .47853 .62832 .47319 .62324 Mtetra
.47319 .62324 .47853 .62832 .48802 .6255 .4827 .6204 Mtetra
.4827 .6204 .48802 .6255 .49754 .62267 .49224 .61755 Mtetra
.49224 .61755 .49754 .62267 .50709 .61984 .50181 .6147 Mtetra
.50181 .6147 .50709 .61984 .51667 .617 .51142 .61184 Mtetra
.51142 .61184 .51667 .617 .52629 .61415 .52106 .60897 Mtetra
.52106 .60897 .52629 .61415 .53594 .6113 .53074 .6061 Mtetra
.657 .753 .92 r
.53074 .6061 .53594 .6113 .54563 .60843 .54044 .60322 Mtetra
.54044 .60322 .54563 .60843 .55535 .60556 .55019 .60032 Mtetra
.657 .752 .92 r
.55019 .60032 .55535 .60556 .5651 .60268 .55996 .59743 Mtetra
.55996 .59743 .5651 .60268 .57489 .59979 .56977 .59452 Mtetra
.56977 .59452 .57489 .59979 .58471 .5969 .57962 .5916 Mtetra
.57962 .5916 .58471 .5969 .59457 .59399 .5895 .58867 Mtetra
.5895 .58867 .59457 .59399 .60446 .59107 .59941 .58574 Mtetra
.59941 .58574 .60446 .59107 .61439 .58814 .60937 .58279 Mtetra
.60937 .58279 .61439 .58814 .62435 .58521 .61935 .57983 Mtetra
.61935 .57983 .62435 .58521 .63435 .58226 .62937 .57687 Mtetra
.62937 .57687 .63435 .58226 .64438 .57931 .63943 .57389 Mtetra
.63943 .57389 .64438 .57931 .65445 .57634 .64952 .57091 Mtetra
.64952 .57091 .65445 .57634 .66455 .57337 .65965 .56791 Mtetra
.65965 .56791 .66455 .57337 .6747 .57038 .66982 .56491 Mtetra
.66982 .56491 .6747 .57038 .68487 .56738 .68002 .56189 Mtetra
.68002 .56189 .68487 .56738 .69509 .56438 .69026 .55886 Mtetra
.69026 .55886 .69509 .56438 .70534 .56136 .70054 .55583 Mtetra
.70054 .55583 .70534 .56136 .71563 .55833 .71085 .55278 Mtetra
.71085 .55278 .71563 .55833 .72595 .5553 .7212 .54972 Mtetra
.7212 .54972 .72595 .5553 .73631 .55225 .73159 .54665 Mtetra
.73159 .54665 .73631 .55225 .74671 .54919 .74202 .54357 Mtetra
.74202 .54357 .74671 .54919 .75715 .54612 .75248 .54048 Mtetra
.75248 .54048 .75715 .54612 .76763 .54304 .76299 .53738 Mtetra
.76299 .53738 .76763 .54304 .77814 .53995 .77353 .53427 Mtetra
.77353 .53427 .77814 .53995 .78869 .53685 .78411 .53115 Mtetra
.78411 .53115 .78869 .53685 .79929 .53373 .79473 .52801 Mtetra
.79473 .52801 .79929 .53373 .80992 .53061 .80538 .52487 Mtetra
.80538 .52487 .80992 .53061 .82058 .52747 .81608 .52171 Mtetra
.81608 .52171 .82058 .52747 .83129 .52433 .82682 .51854 Mtetra
.82682 .51854 .83129 .52433 .84204 .52117 .8376 .51536 Mtetra
.8376 .51536 .84204 .52117 .85283 .518 .84841 .51217 Mtetra
.84841 .51217 .85283 .518 .86366 .51482 .85927 .50897 Mtetra
.85927 .50897 .86366 .51482 .87453 .51163 .87017 .50575 Mtetra
.87017 .50575 .87453 .51163 .88543 .50842 .8811 .50253 Mtetra
.8811 .50253 .88543 .50842 .89638 .50521 .89208 .49929 Mtetra
.89208 .49929 .89638 .50521 .90737 .50198 .9031 .49604 Mtetra
.9031 .49604 .90737 .50198 .9184 .49874 .91417 .49278 Mtetra
.91417 .49278 .9184 .49874 .92948 .49549 .92527 .4895 Mtetra
.92527 .4895 .92948 .49549 .94059 .49222 .93641 .48622 Mtetra
.93641 .48622 .94059 .49222 .95175 .48895 .9476 .48292 Mtetra
.515 .679 .94 r
.34682 .65543 .35243 .661 .36326 .62138 .35581 .65542 Mtetra
.436 .18 .426 r
.35581 .65542 .36326 .62138 .3708 .65242 .36527 .64597 Mtetra
.569 .668 .906 r
.36527 .64597 .3708 .65242 .37991 .65055 .37435 .6453 Mtetra
.637 .736 .92 r
.37435 .6453 .37991 .65055 .38909 .64813 .38353 .64304 Mtetra
.648 .745 .92 r
.38353 .64304 .38909 .64813 .3983 .64555 .39276 .6405 Mtetra
.653 .749 .92 r
.39276 .6405 .3983 .64555 .40754 .64288 .40203 .63785 Mtetra
.656 .751 .92 r
.40203 .63785 .40754 .64288 .41683 .64014 .41133 .63512 Mtetra
.657 .752 .92 r
.41133 .63512 .41683 .64014 .42614 .63737 .42066 .63234 Mtetra
.658 .753 .92 r
.42066 .63234 .42614 .63737 .43549 .63456 .43003 .62953 Mtetra
.659 .754 .92 r
.43003 .62953 .43549 .63456 .44486 .63174 .43943 .62669 Mtetra
.43943 .62669 .44486 .63174 .45427 .62891 .44886 .62384 Mtetra
.44886 .62384 .45427 .62891 .46372 .62607 .45832 .62098 Mtetra
.659 .753 .92 r
.45832 .62098 .46372 .62607 .47319 .62324 .46782 .61812 Mtetra
.658 .753 .92 r
.46782 .61812 .47319 .62324 .4827 .6204 .47735 .61526 Mtetra
.47735 .61526 .4827 .6204 .49224 .61755 .48691 .6124 Mtetra
.48691 .6124 .49224 .61755 .50181 .6147 .49651 .60952 Mtetra
.49651 .60952 .50181 .6147 .51142 .61184 .50613 .60664 Mtetra
.50613 .60664 .51142 .61184 .52106 .60897 .5158 .60376 Mtetra
.5158 .60376 .52106 .60897 .53074 .6061 .52549 .60086 Mtetra
.657 .753 .92 r
.52549 .60086 .53074 .6061 .54044 .60322 .53522 .59796 Mtetra
.53522 .59796 .54044 .60322 .55019 .60032 .54499 .59505 Mtetra
.54499 .59505 .55019 .60032 .55996 .59743 .55479 .59213 Mtetra
.657 .752 .92 r
.55479 .59213 .55996 .59743 .56977 .59452 .56462 .58921 Mtetra
.56462 .58921 .56977 .59452 .57962 .5916 .57449 .58627 Mtetra
.57449 .58627 .57962 .5916 .5895 .58867 .5844 .58332 Mtetra
.5844 .58332 .5895 .58867 .59941 .58574 .59433 .58037 Mtetra
.59433 .58037 .59941 .58574 .60937 .58279 .60431 .5774 Mtetra
.60431 .5774 .60937 .58279 .61935 .57983 .61432 .57442 Mtetra
.61432 .57442 .61935 .57983 .62937 .57687 .62437 .57144 Mtetra
.62437 .57144 .62937 .57687 .63943 .57389 .63445 .56844 Mtetra
.63445 .56844 .63943 .57389 .64952 .57091 .64457 .56544 Mtetra
.64457 .56544 .64952 .57091 .65965 .56791 .65472 .56242 Mtetra
.65472 .56242 .65965 .56791 .66982 .56491 .66491 .5594 Mtetra
.66491 .5594 .66982 .56491 .68002 .56189 .67514 .55636 Mtetra
.67514 .55636 .68002 .56189 .69026 .55886 .6854 .55331 Mtetra
.6854 .55331 .69026 .55886 .70054 .55583 .69571 .55026 Mtetra
.69571 .55026 .70054 .55583 .71085 .55278 .70605 .54719 Mtetra
.70605 .54719 .71085 .55278 .7212 .54972 .71642 .54411 Mtetra
.71642 .54411 .7212 .54972 .73159 .54665 .72684 .54102 Mtetra
.72684 .54102 .73159 .54665 .74202 .54357 .73729 .53792 Mtetra
.73729 .53792 .74202 .54357 .75248 .54048 .74778 .53481 Mtetra
.74778 .53481 .75248 .54048 .76299 .53738 .75831 .53169 Mtetra
.75831 .53169 .76299 .53738 .77353 .53427 .76888 .52855 Mtetra
.76888 .52855 .77353 .53427 .78411 .53115 .77949 .52541 Mtetra
.77949 .52541 .78411 .53115 .79473 .52801 .79014 .52225 Mtetra
.79014 .52225 .79473 .52801 .80538 .52487 .80082 .51909 Mtetra
.80082 .51909 .80538 .52487 .81608 .52171 .81155 .51591 Mtetra
.81155 .51591 .81608 .52171 .82682 .51854 .82231 .51272 Mtetra
.82231 .51272 .82682 .51854 .8376 .51536 .83312 .50951 Mtetra
.83312 .50951 .8376 .51536 .84841 .51217 .84396 .5063 Mtetra
.84396 .5063 .84841 .51217 .85927 .50897 .85485 .50308 Mtetra
.85485 .50308 .85927 .50897 .87017 .50575 .86578 .49984 Mtetra
.86578 .49984 .87017 .50575 .8811 .50253 .87675 .49659 Mtetra
.87675 .49659 .8811 .50253 .89208 .49929 .88775 .49333 Mtetra
.88775 .49333 .89208 .49929 .9031 .49604 .8988 .49006 Mtetra
.8988 .49006 .9031 .49604 .91417 .49278 .9099 .48677 Mtetra
.9099 .48677 .91417 .49278 .92527 .4895 .92103 .48348 Mtetra
.92103 .48348 .92527 .4895 .93641 .48622 .93221 .48017 Mtetra
.93221 .48017 .93641 .48622 .9476 .48292 .94342 .47685 Mtetra
.609 .725 .927 r
.34117 .65013 .34682 .65543 .35581 .65542 .35025 .64845 Mtetra
.901 .711 .635 r
.35025 .64845 .35581 .65542 .36527 .64597 .36119 .60862 Mtetra
.018 .015 .509 r
.36119 .60862 .36527 .64597 .37435 .6453 .36876 .63976 Mtetra
.621 .721 .918 r
.36876 .63976 .37435 .6453 .38353 .64304 .37795 .63786 Mtetra
.644 .742 .92 r
.37795 .63786 .38353 .64304 .39276 .6405 .38719 .6354 Mtetra
.651 .747 .92 r
.38719 .6354 .39276 .6405 .40203 .63785 .39647 .63277 Mtetra
.654 .75 .92 r
.39647 .63277 .40203 .63785 .41133 .63512 .40579 .63006 Mtetra
.657 .752 .92 r
.40579 .63006 .41133 .63512 .42066 .63234 .41515 .62728 Mtetra
.658 .753 .92 r
.41515 .62728 .42066 .63234 .43003 .62953 .42453 .62445 Mtetra
.659 .753 .92 r
.42453 .62445 .43003 .62953 .43943 .62669 .43395 .6216 Mtetra
.659 .754 .92 r
.43395 .6216 .43943 .62669 .44886 .62384 .44341 .61874 Mtetra
.44341 .61874 .44886 .62384 .45832 .62098 .45289 .61586 Mtetra
.45289 .61586 .45832 .62098 .46782 .61812 .46241 .61298 Mtetra
.658 .753 .92 r
.46241 .61298 .46782 .61812 .47735 .61526 .47196 .6101 Mtetra
.47196 .6101 .47735 .61526 .48691 .6124 .48155 .60721 Mtetra
.48155 .60721 .48691 .6124 .49651 .60952 .49116 .60432 Mtetra
.49116 .60432 .49651 .60952 .50613 .60664 .50081 .60142 Mtetra
.50081 .60142 .50613 .60664 .5158 .60376 .5105 .59851 Mtetra
.5105 .59851 .5158 .60376 .52549 .60086 .52022 .5956 Mtetra
.52022 .5956 .52549 .60086 .53522 .59796 .52997 .59268 Mtetra
.657 .753 .92 r
.52997 .59268 .53522 .59796 .54499 .59505 .53976 .58975 Mtetra
.53976 .58975 .54499 .59505 .55479 .59213 .54958 .58681 Mtetra
.657 .752 .92 r
.54958 .58681 .55479 .59213 .56462 .58921 .55944 .58386 Mtetra
.55944 .58386 .56462 .58921 .57449 .58627 .56933 .5809 Mtetra
.56933 .5809 .57449 .58627 .5844 .58332 .57926 .57794 Mtetra
.57926 .57794 .5844 .58332 .59433 .58037 .58922 .57496 Mtetra
.58922 .57496 .59433 .58037 .60431 .5774 .59922 .57197 Mtetra
.59922 .57197 .60431 .5774 .61432 .57442 .60925 .56898 Mtetra
.60925 .56898 .61432 .57442 .62437 .57144 .61932 .56597 Mtetra
.61932 .56597 .62437 .57144 .63445 .56844 .62943 .56296 Mtetra
.62943 .56296 .63445 .56844 .64457 .56544 .63957 .55993 Mtetra
.63957 .55993 .64457 .56544 .65472 .56242 .64975 .5569 Mtetra
.64975 .5569 .65472 .56242 .66491 .5594 .65997 .55385 Mtetra
.65997 .55385 .66491 .5594 .67514 .55636 .67022 .55079 Mtetra
.67022 .55079 .67514 .55636 .6854 .55331 .68051 .54773 Mtetra
.68051 .54773 .6854 .55331 .69571 .55026 .69084 .54465 Mtetra
.69084 .54465 .69571 .55026 .70605 .54719 .70121 .54156 Mtetra
.70121 .54156 .70605 .54719 .71642 .54411 .71161 .53846 Mtetra
.71161 .53846 .71642 .54411 .72684 .54102 .72205 .53535 Mtetra
.72205 .53535 .72684 .54102 .73729 .53792 .73253 .53223 Mtetra
.73253 .53223 .73729 .53792 .74778 .53481 .74305 .52909 Mtetra
.74305 .52909 .74778 .53481 .75831 .53169 .75361 .52595 Mtetra
.75361 .52595 .75831 .53169 .76888 .52855 .76421 .5228 Mtetra
.76421 .5228 .76888 .52855 .77949 .52541 .77484 .51963 Mtetra
.77484 .51963 .77949 .52541 .79014 .52225 .78552 .51645 Mtetra
.78552 .51645 .79014 .52225 .80082 .51909 .79623 .51326 Mtetra
.79623 .51326 .80082 .51909 .81155 .51591 .80698 .51006 Mtetra
.80698 .51006 .81155 .51591 .82231 .51272 .81778 .50685 Mtetra
.81778 .50685 .82231 .51272 .83312 .50951 .82861 .50363 Mtetra
.82861 .50363 .83312 .50951 .84396 .5063 .83949 .50039 Mtetra
.83949 .50039 .84396 .5063 .85485 .50308 .8504 .49714 Mtetra
.8504 .49714 .85485 .50308 .86578 .49984 .86136 .49388 Mtetra
.86136 .49388 .86578 .49984 .87675 .49659 .87236 .49061 Mtetra
.87236 .49061 .87675 .49659 .88775 .49333 .8834 .48733 Mtetra
.8834 .48733 .88775 .49333 .8988 .49006 .89448 .48403 Mtetra
.89448 .48403 .8988 .49006 .9099 .48677 .9056 .48073 Mtetra
.9056 .48073 .9099 .48677 .92103 .48348 .91676 .47741 Mtetra
.91676 .47741 .92103 .48348 .93221 .48017 .92797 .47407 Mtetra
.92797 .47407 .93221 .48017 .94342 .47685 .93922 .47073 Mtetra
.629 .735 .924 r
.33547 .64491 .34117 .65013 .35025 .64845 .34459 .6428 Mtetra
.515 .679 .94 r
.34459 .6428 .35025 .64845 .36119 .60862 .35364 .64275 Mtetra
.432 .174 .421 r
.35364 .64275 .36119 .60862 .36876 .63976 .36318 .63323 Mtetra
.569 .668 .906 r
.36318 .63323 .36876 .63976 .37795 .63786 .37233 .63253 Mtetra
.637 .736 .92 r
.37233 .63253 .37795 .63786 .38719 .6354 .38159 .63022 Mtetra
.648 .745 .92 r
.38159 .63022 .38719 .6354 .39647 .63277 .39089 .62764 Mtetra
.653 .749 .92 r
.39089 .62764 .39647 .63277 .40579 .63006 .40023 .62494 Mtetra
.656 .751 .92 r
.40023 .62494 .40579 .63006 .41515 .62728 .4096 .62217 Mtetra
.657 .752 .92 r
.4096 .62217 .41515 .62728 .42453 .62445 .41901 .61935 Mtetra
.658 .753 .92 r
.41901 .61935 .42453 .62445 .43395 .6216 .42845 .61649 Mtetra
.659 .754 .92 r
.42845 .61649 .43395 .6216 .44341 .61874 .43792 .6136 Mtetra
.43792 .6136 .44341 .61874 .45289 .61586 .44743 .61071 Mtetra
.44743 .61071 .45289 .61586 .46241 .61298 .45697 .6078 Mtetra
.659 .753 .92 r
.45697 .6078 .46241 .61298 .47196 .6101 .46654 .6049 Mtetra
.658 .753 .92 r
.46654 .6049 .47196 .6101 .48155 .60721 .47615 .60199 Mtetra
.47615 .60199 .48155 .60721 .49116 .60432 .48578 .59908 Mtetra
.48578 .59908 .49116 .60432 .50081 .60142 .49546 .59616 Mtetra
.49546 .59616 .50081 .60142 .5105 .59851 .50517 .59323 Mtetra
.50517 .59323 .5105 .59851 .52022 .5956 .51491 .5903 Mtetra
.51491 .5903 .52022 .5956 .52997 .59268 .52468 .58735 Mtetra
.657 .753 .92 r
.52468 .58735 .52997 .59268 .53976 .58975 .53449 .5844 Mtetra
.53449 .5844 .53976 .58975 .54958 .58681 .54434 .58145 Mtetra
.54434 .58145 .54958 .58681 .55944 .58386 .55422 .57848 Mtetra
.657 .752 .92 r
.55422 .57848 .55944 .58386 .56933 .5809 .56414 .5755 Mtetra
.56414 .5755 .56933 .5809 .57926 .57794 .57409 .57251 Mtetra
.57409 .57251 .57926 .57794 .58922 .57496 .58407 .56952 Mtetra
.58407 .56952 .58922 .57496 .59922 .57197 .5941 .56651 Mtetra
.5941 .56651 .59922 .57197 .60925 .56898 .60415 .5635 Mtetra
.60415 .5635 .60925 .56898 .61932 .56597 .61425 .56047 Mtetra
.61425 .56047 .61932 .56597 .62943 .56296 .62438 .55744 Mtetra
.62438 .55744 .62943 .56296 .63957 .55993 .63455 .55439 Mtetra
.63455 .55439 .63957 .55993 .64975 .5569 .64475 .55133 Mtetra
.64475 .55133 .64975 .5569 .65997 .55385 .65499 .54827 Mtetra
.65499 .54827 .65997 .55385 .67022 .55079 .66527 .54519 Mtetra
.66527 .54519 .67022 .55079 .68051 .54773 .67559 .5421 Mtetra
.67559 .5421 .68051 .54773 .69084 .54465 .68594 .539 Mtetra
.68594 .539 .69084 .54465 .70121 .54156 .69634 .53589 Mtetra
.69634 .53589 .70121 .54156 .71161 .53846 .70677 .53277 Mtetra
.70677 .53277 .71161 .53846 .72205 .53535 .71724 .52964 Mtetra
.71724 .52964 .72205 .53535 .73253 .53223 .72774 .5265 Mtetra
.72774 .5265 .73253 .53223 .74305 .52909 .73829 .52334 Mtetra
.73829 .52334 .74305 .52909 .75361 .52595 .74887 .52018 Mtetra
.74887 .52018 .75361 .52595 .76421 .5228 .7595 .517 Mtetra
.7595 .517 .76421 .5228 .77484 .51963 .77016 .51381 Mtetra
.77016 .51381 .77484 .51963 .78552 .51645 .78086 .51061 Mtetra
.78086 .51061 .78552 .51645 .79623 .51326 .7916 .5074 Mtetra
.7916 .5074 .79623 .51326 .80698 .51006 .80239 .50418 Mtetra
.80239 .50418 .80698 .51006 .81778 .50685 .81321 .50094 Mtetra
.81321 .50094 .81778 .50685 .82861 .50363 .82407 .4977 Mtetra
.82407 .4977 .82861 .50363 .83949 .50039 .83498 .49444 Mtetra
.83498 .49444 .83949 .50039 .8504 .49714 .84592 .49117 Mtetra
.84592 .49117 .8504 .49714 .86136 .49388 .85691 .48789 Mtetra
.85691 .48789 .86136 .49388 .87236 .49061 .86794 .48459 Mtetra
.86794 .48459 .87236 .49061 .8834 .48733 .87901 .48129 Mtetra
.87901 .48129 .8834 .48733 .89448 .48403 .89012 .47797 Mtetra
.89012 .47797 .89448 .48403 .9056 .48073 .90127 .47464 Mtetra
.90127 .47464 .9056 .48073 .91676 .47741 .91247 .47129 Mtetra
.91247 .47129 .91676 .47741 .92797 .47407 .9237 .46794 Mtetra
.9237 .46794 .92797 .47407 .93922 .47073 .93499 .46457 Mtetra
.636 .739 .922 r
.32974 .6397 .33547 .64491 .34459 .6428 .33888 .63741 Mtetra
.609 .725 .927 r
.33888 .63741 .34459 .6428 .35364 .64275 .34803 .63569 Mtetra
.902 .711 .634 r
.34803 .63569 .35364 .64275 .36318 .63323 .35908 .59566 Mtetra
.012 .01 .506 r
.35908 .59566 .36318 .63323 .37233 .63253 .36669 .6269 Mtetra
.621 .721 .918 r
.36669 .6269 .37233 .63253 .38159 .63022 .37595 .62496 Mtetra
.644 .742 .92 r
.37595 .62496 .38159 .63022 .39089 .62764 .38527 .62246 Mtetra
.651 .747 .92 r
.38527 .62246 .39089 .62764 .40023 .62494 .39462 .61978 Mtetra
.654 .75 .92 r
.39462 .61978 .40023 .62494 .4096 .62217 .40401 .61702 Mtetra
.657 .752 .92 r
.40401 .61702 .4096 .62217 .41901 .61935 .41344 .6142 Mtetra
.658 .753 .92 r
.41344 .6142 .41901 .61935 .42845 .61649 .4229 .61133 Mtetra
.659 .753 .92 r
.4229 .61133 .42845 .61649 .43792 .6136 .4324 .60843 Mtetra
.659 .754 .92 r
.4324 .60843 .43792 .6136 .44743 .61071 .44193 .60552 Mtetra
.44193 .60552 .44743 .61071 .45697 .6078 .45149 .6026 Mtetra
.45149 .6026 .45697 .6078 .46654 .6049 .46108 .59967 Mtetra
.658 .753 .92 r
.46108 .59967 .46654 .6049 .47615 .60199 .47071 .59674 Mtetra
.47071 .59674 .47615 .60199 .48578 .59908 .48037 .5938 Mtetra
.48037 .5938 .48578 .59908 .49546 .59616 .49007 .59086 Mtetra
.49007 .59086 .49546 .59616 .50517 .59323 .4998 .58791 Mtetra
.4998 .58791 .50517 .59323 .51491 .5903 .50956 .58496 Mtetra
.50956 .58496 .51491 .5903 .52468 .58735 .51936 .582 Mtetra
.51936 .582 .52468 .58735 .53449 .5844 .52919 .57903 Mtetra
.657 .753 .92 r
.52919 .57903 .53449 .5844 .54434 .58145 .53906 .57605 Mtetra
.53906 .57605 .54434 .58145 .55422 .57848 .54897 .57306 Mtetra
.657 .752 .92 r
.54897 .57306 .55422 .57848 .56414 .5755 .55891 .57006 Mtetra
.55891 .57006 .56414 .5755 .57409 .57251 .56888 .56706 Mtetra
.56888 .56706 .57409 .57251 .58407 .56952 .57889 .56404 Mtetra
.57889 .56404 .58407 .56952 .5941 .56651 .58894 .56101 Mtetra
.58894 .56101 .5941 .56651 .60415 .5635 .59902 .55798 Mtetra
.59902 .55798 .60415 .5635 .61425 .56047 .60914 .55493 Mtetra
.60914 .55493 .61425 .56047 .62438 .55744 .6193 .55188 Mtetra
.6193 .55188 .62438 .55744 .63455 .55439 .62949 .54881 Mtetra
.62949 .54881 .63455 .55439 .64475 .55133 .63972 .54573 Mtetra
.63972 .54573 .64475 .55133 .65499 .54827 .64999 .54264 Mtetra
.64999 .54264 .65499 .54827 .66527 .54519 .66029 .53954 Mtetra
.66029 .53954 .66527 .54519 .67559 .5421 .67063 .53644 Mtetra
.67063 .53644 .67559 .5421 .68594 .539 .68101 .53332 Mtetra
.68101 .53332 .68594 .539 .69634 .53589 .69143 .53018 Mtetra
.69143 .53018 .69634 .53589 .70677 .53277 .70189 .52704 Mtetra
.70189 .52704 .70677 .53277 .71724 .52964 .71238 .52389 Mtetra
.71238 .52389 .71724 .52964 .72774 .5265 .72292 .52072 Mtetra
.72292 .52072 .72774 .5265 .73829 .52334 .73349 .51755 Mtetra
.73349 .51755 .73829 .52334 .74887 .52018 .7441 .51436 Mtetra
.7441 .51436 .74887 .52018 .7595 .517 .75475 .51116 Mtetra
.75475 .51116 .7595 .517 .77016 .51381 .76545 .50795 Mtetra
.76545 .50795 .77016 .51381 .78086 .51061 .77618 .50473 Mtetra
.77618 .50473 .78086 .51061 .7916 .5074 .78695 .5015 Mtetra
.78695 .5015 .7916 .5074 .80239 .50418 .79776 .49825 Mtetra
.79776 .49825 .80239 .50418 .81321 .50094 .80861 .495 Mtetra
.80861 .495 .81321 .50094 .82407 .4977 .8195 .49173 Mtetra
.8195 .49173 .82407 .4977 .83498 .49444 .83044 .48845 Mtetra
.83044 .48845 .83498 .49444 .84592 .49117 .84141 .48515 Mtetra
.84141 .48515 .84592 .49117 .85691 .48789 .85243 .48185 Mtetra
.85243 .48185 .85691 .48789 .86794 .48459 .86349 .47853 Mtetra
.86349 .47853 .86794 .48459 .87901 .48129 .87459 .4752 Mtetra
.87459 .4752 .87901 .48129 .89012 .47797 .88573 .47186 Mtetra
.88573 .47186 .89012 .47797 .90127 .47464 .89691 .46851 Mtetra
.89691 .46851 .90127 .47464 .91247 .47129 .90814 .46514 Mtetra
.90814 .46514 .91247 .47129 .9237 .46794 .91941 .46176 Mtetra
.91941 .46176 .9237 .46794 .93499 .46457 .93072 .45837 Mtetra
.639 .74 .922 r
.32397 .63447 .32974 .6397 .33888 .63741 .33314 .63211 Mtetra
.629 .735 .924 r
.33314 .63211 .33888 .63741 .34803 .63569 .34233 .62995 Mtetra
.515 .679 .94 r
.34233 .62995 .34803 .63569 .35908 .59566 .35145 .62988 Mtetra
.427 .168 .417 r
.35145 .62988 .35908 .59566 .36669 .6269 .36106 .62028 Mtetra
.568 .668 .906 r
.36106 .62028 .36669 .6269 .37595 .62496 .37028 .61954 Mtetra
.637 .736 .92 r
.37028 .61954 .37595 .62496 .38527 .62246 .37961 .6172 Mtetra
.648 .745 .92 r
.37961 .6172 .38527 .62246 .39462 .61978 .38898 .61457 Mtetra
.653 .749 .92 r
.38898 .61457 .39462 .61978 .40401 .61702 .39839 .61183 Mtetra
.656 .751 .92 r
.39839 .61183 .40401 .61702 .41344 .6142 .40784 .60901 Mtetra
.657 .752 .92 r
.40784 .60901 .41344 .6142 .4229 .61133 .41732 .60614 Mtetra
.658 .753 .92 r
.41732 .60614 .4229 .61133 .4324 .60843 .42684 .60323 Mtetra
.659 .754 .92 r
.42684 .60323 .4324 .60843 .44193 .60552 .43639 .6003 Mtetra
.43639 .6003 .44193 .60552 .45149 .6026 .44597 .59736 Mtetra
.44597 .59736 .45149 .6026 .46108 .59967 .45559 .59441 Mtetra
.659 .753 .92 r
.45559 .59441 .46108 .59967 .47071 .59674 .46524 .59145 Mtetra
.658 .753 .92 r
.46524 .59145 .47071 .59674 .48037 .5938 .47492 .5885 Mtetra
.47492 .5885 .48037 .5938 .49007 .59086 .48464 .58553 Mtetra
.48464 .58553 .49007 .59086 .4998 .58791 .49439 .58257 Mtetra
.49439 .58257 .4998 .58791 .50956 .58496 .50418 .57959 Mtetra
.50418 .57959 .50956 .58496 .51936 .582 .514 .57661 Mtetra
.514 .57661 .51936 .582 .52919 .57903 .52386 .57362 Mtetra
.657 .753 .92 r
.52386 .57362 .52919 .57903 .53906 .57605 .53375 .57062 Mtetra
.53375 .57062 .53906 .57605 .54897 .57306 .54368 .56761 Mtetra
.54368 .56761 .54897 .57306 .55891 .57006 .55364 .56459 Mtetra
.657 .752 .92 r
.55364 .56459 .55891 .57006 .56888 .56706 .56364 .56156 Mtetra
.56364 .56156 .56888 .56706 .57889 .56404 .57367 .55853 Mtetra
.57367 .55853 .57889 .56404 .58894 .56101 .58375 .55548 Mtetra
.58375 .55548 .58894 .56101 .59902 .55798 .59385 .55242 Mtetra
.59385 .55242 .59902 .55798 .60914 .55493 .604 .54936 Mtetra
.604 .54936 .60914 .55493 .6193 .55188 .61418 .54628 Mtetra
.61418 .54628 .6193 .55188 .62949 .54881 .6244 .54319 Mtetra
.6244 .54319 .62949 .54881 .63972 .54573 .63465 .54009 Mtetra
.63465 .54009 .63972 .54573 .64999 .54264 .64494 .53698 Mtetra
.64494 .53698 .64999 .54264 .66029 .53954 .65527 .53386 Mtetra
.65527 .53386 .66029 .53954 .67063 .53644 .66564 .53073 Mtetra
.66564 .53073 .67063 .53644 .68101 .53332 .67605 .52759 Mtetra
.67605 .52759 .68101 .53332 .69143 .53018 .68649 .52444 Mtetra
.68649 .52444 .69143 .53018 .70189 .52704 .69698 .52128 Mtetra
.69698 .52128 .70189 .52704 .71238 .52389 .7075 .5181 Mtetra
.7075 .5181 .71238 .52389 .72292 .52072 .71806 .51491 Mtetra
.71806 .51491 .72292 .52072 .73349 .51755 .72866 .51172 Mtetra
.72866 .51172 .73349 .51755 .7441 .51436 .7393 .50851 Mtetra
.7393 .50851 .7441 .51436 .75475 .51116 .74998 .50529 Mtetra
.74998 .50529 .75475 .51116 .76545 .50795 .7607 .50206 Mtetra
.7607 .50206 .76545 .50795 .77618 .50473 .77146 .49881 Mtetra
.77146 .49881 .77618 .50473 .78695 .5015 .78226 .49556 Mtetra
.78226 .49556 .78695 .5015 .79776 .49825 .7931 .49229 Mtetra
.7931 .49229 .79776 .49825 .80861 .495 .80398 .48901 Mtetra
.80398 .48901 .80861 .495 .8195 .49173 .8149 .48572 Mtetra
.8149 .48572 .8195 .49173 .83044 .48845 .82586 .48241 Mtetra
.82586 .48241 .83044 .48845 .84141 .48515 .83687 .4791 Mtetra
.83687 .4791 .84141 .48515 .85243 .48185 .84791 .47577 Mtetra
.84791 .47577 .85243 .48185 .86349 .47853 .859 .47243 Mtetra
.859 .47243 .86349 .47853 .87459 .4752 .87013 .46908 Mtetra
.87013 .46908 .87459 .4752 .88573 .47186 .88131 .46571 Mtetra
.88131 .46571 .88573 .47186 .89691 .46851 .89252 .46233 Mtetra
.89252 .46233 .89691 .46851 .90814 .46514 .90378 .45894 Mtetra
.90378 .45894 .90814 .46514 .91941 .46176 .91508 .45554 Mtetra
.91508 .45554 .91941 .46176 .93072 .45837 .92643 .45212 Mtetra
.64 .74 .921 r
.31816 .62921 .32397 .63447 .33314 .63211 .32735 .62682 Mtetra
.637 .739 .922 r
.32735 .62682 .33314 .63211 .34233 .62995 .33656 .62449 Mtetra
.609 .725 .927 r
.33656 .62449 .34233 .62995 .35145 .62988 .34579 .62273 Mtetra
.904 .712 .634 r
.34579 .62273 .35145 .62988 .36106 .62028 .35694 .58249 Mtetra
.006 .005 .503 r
.35694 .58249 .36106 .62028 .37028 .61954 .36459 .61383 Mtetra
.621 .721 .918 r
.36459 .61383 .37028 .61954 .37961 .6172 .37392 .61184 Mtetra
.644 .742 .92 r
.37392 .61184 .37961 .6172 .38898 .61457 .38331 .6093 Mtetra
.651 .747 .92 r
.38331 .6093 .38898 .61457 .39839 .61183 .39274 .60658 Mtetra
.654 .75 .92 r
.39274 .60658 .39839 .61183 .40784 .60901 .40221 .60377 Mtetra
.657 .752 .92 r
.40221 .60377 .40784 .60901 .41732 .60614 .41171 .6009 Mtetra
.658 .753 .92 r
.41171 .6009 .41732 .60614 .42684 .60323 .42124 .59799 Mtetra
.659 .753 .92 r
.42124 .59799 .42684 .60323 .43639 .6003 .43082 .59504 Mtetra
.659 .754 .92 r
.43082 .59504 .43639 .6003 .44597 .59736 .44042 .59208 Mtetra
.44042 .59208 .44597 .59736 .45559 .59441 .45006 .58911 Mtetra
.45006 .58911 .45559 .59441 .46524 .59145 .45973 .58613 Mtetra
.658 .753 .92 r
.45973 .58613 .46524 .59145 .47492 .5885 .46944 .58315 Mtetra
.46944 .58315 .47492 .5885 .48464 .58553 .47918 .58017 Mtetra
.47918 .58017 .48464 .58553 .49439 .58257 .48895 .57718 Mtetra
.48895 .57718 .49439 .58257 .50418 .57959 .49876 .57419 Mtetra
.49876 .57419 .50418 .57959 .514 .57661 .50861 .57118 Mtetra
.50861 .57118 .514 .57661 .52386 .57362 .51849 .56817 Mtetra
.51849 .56817 .52386 .57362 .53375 .57062 .5284 .56515 Mtetra
.657 .753 .92 r
.5284 .56515 .53375 .57062 .54368 .56761 .53835 .56212 Mtetra
.53835 .56212 .54368 .56761 .55364 .56459 .54834 .55908 Mtetra
.657 .752 .92 r
.54834 .55908 .55364 .56459 .56364 .56156 .55836 .55603 Mtetra
.55836 .55603 .56364 .56156 .57367 .55853 .56842 .55298 Mtetra
.56842 .55298 .57367 .55853 .58375 .55548 .57852 .54991 Mtetra
.57852 .54991 .58375 .55548 .59385 .55242 .58865 .54683 Mtetra
.58865 .54683 .59385 .55242 .604 .54936 .59882 .54374 Mtetra
.59882 .54374 .604 .54936 .61418 .54628 .60902 .54064 Mtetra
.60902 .54064 .61418 .54628 .6244 .54319 .61927 .53754 Mtetra
.61927 .53754 .6244 .54319 .63465 .54009 .62955 .53442 Mtetra
.62955 .53442 .63465 .54009 .64494 .53698 .63987 .53129 Mtetra
.63987 .53129 .64494 .53698 .65527 .53386 .65022 .52814 Mtetra
.65022 .52814 .65527 .53386 .66564 .53073 .66062 .52499 Mtetra
.66062 .52499 .66564 .53073 .67605 .52759 .67105 .52183 Mtetra
.67105 .52183 .67605 .52759 .68649 .52444 .68152 .51866 Mtetra
.68152 .51866 .68649 .52444 .69698 .52128 .69203 .51547 Mtetra
.69203 .51547 .69698 .52128 .7075 .5181 .70258 .51227 Mtetra
.70258 .51227 .7075 .5181 .71806 .51491 .71317 .50906 Mtetra
.71317 .50906 .71806 .51491 .72866 .51172 .7238 .50584 Mtetra
.7238 .50584 .72866 .51172 .7393 .50851 .73447 .50261 Mtetra
.73447 .50261 .7393 .50851 .74998 .50529 .74517 .49937 Mtetra
.74517 .49937 .74998 .50529 .7607 .50206 .75592 .49612 Mtetra
.75592 .49612 .7607 .50206 .77146 .49881 .76671 .49285 Mtetra
.76671 .49285 .77146 .49881 .78226 .49556 .77754 .48957 Mtetra
.77754 .48957 .78226 .49556 .7931 .49229 .78841 .48628 Mtetra
.78841 .48628 .7931 .49229 .80398 .48901 .79932 .48298 Mtetra
.79932 .48298 .80398 .48901 .8149 .48572 .81027 .47966 Mtetra
.81027 .47966 .8149 .48572 .82586 .48241 .82126 .47634 Mtetra
.82126 .47634 .82586 .48241 .83687 .4791 .83229 .473 Mtetra
.83229 .473 .83687 .4791 .84791 .47577 .84337 .46965 Mtetra
.84337 .46965 .84791 .47577 .859 .47243 .85449 .46628 Mtetra
.85449 .46628 .859 .47243 .87013 .46908 .86565 .4629 Mtetra
.86565 .4629 .87013 .46908 .88131 .46571 .87685 .45951 Mtetra
.87685 .45951 .88131 .46571 .89252 .46233 .8881 .45611 Mtetra
.8881 .45611 .89252 .46233 .90378 .45894 .89939 .4527 Mtetra
.89939 .4527 .90378 .45894 .91508 .45554 .91072 .44927 Mtetra
.91072 .44927 .91508 .45554 .92643 .45212 .9221 .44583 Mtetra
.639 .739 .921 r
.31232 .62389 .31816 .62921 .32735 .62682 .32152 .62151 Mtetra
.639 .74 .922 r
.32152 .62151 .32735 .62682 .33656 .62449 .33076 .6191 Mtetra
.629 .735 .924 r
.33076 .6191 .33656 .62449 .34579 .62273 .34002 .6169 Mtetra
.516 .679 .939 r
.34002 .6169 .34579 .62273 .35694 .58249 .34921 .61679 Mtetra
.422 .162 .412 r
.34921 .61679 .35694 .58249 .36459 .61383 .35891 .60712 Mtetra
.568 .668 .906 r
.35891 .60712 .36459 .61383 .37392 .61184 .3682 .60635 Mtetra
.637 .736 .92 r
.3682 .60635 .37392 .61184 .38331 .6093 .3776 .60395 Mtetra
.648 .745 .92 r
.3776 .60395 .38331 .6093 .39274 .60658 .38705 .60128 Mtetra
.653 .749 .92 r
.38705 .60128 .39274 .60658 .40221 .60377 .39653 .59849 Mtetra
.656 .751 .92 r
.39653 .59849 .40221 .60377 .41171 .6009 .40606 .59563 Mtetra
.657 .752 .92 r
.40606 .59563 .41171 .6009 .42124 .59799 .41561 .59271 Mtetra
.658 .753 .92 r
.41561 .59271 .42124 .59799 .43082 .59504 .42521 .58975 Mtetra
.659 .754 .92 r
.42521 .58975 .43082 .59504 .44042 .59208 .43483 .58677 Mtetra
.43483 .58677 .44042 .59208 .45006 .58911 .44449 .58378 Mtetra
.44449 .58378 .45006 .58911 .45973 .58613 .45419 .58078 Mtetra
.659 .753 .92 r
.45419 .58078 .45973 .58613 .46944 .58315 .46392 .57778 Mtetra
.658 .753 .92 r
.46392 .57778 .46944 .58315 .47918 .58017 .47368 .57477 Mtetra
.47368 .57477 .47918 .58017 .48895 .57718 .48348 .57176 Mtetra
.48348 .57176 .48895 .57718 .49876 .57419 .49331 .56874 Mtetra
.49331 .56874 .49876 .57419 .50861 .57118 .50318 .56572 Mtetra
.50318 .56572 .50861 .57118 .51849 .56817 .51308 .56269 Mtetra
.51308 .56269 .51849 .56817 .5284 .56515 .52302 .55965 Mtetra
.657 .753 .92 r
.52302 .55965 .5284 .56515 .53835 .56212 .53299 .5566 Mtetra
.53299 .5566 .53835 .56212 .54834 .55908 .543 .55354 Mtetra
.543 .55354 .54834 .55908 .55836 .55603 .55305 .55047 Mtetra
.657 .752 .92 r
.55305 .55047 .55836 .55603 .56842 .55298 .56313 .54739 Mtetra
.56313 .54739 .56842 .55298 .57852 .54991 .57325 .5443 Mtetra
.57325 .5443 .57852 .54991 .58865 .54683 .58341 .5412 Mtetra
.58341 .5412 .58865 .54683 .59882 .54374 .59361 .53809 Mtetra
.59361 .53809 .59882 .54374 .60902 .54064 .60384 .53497 Mtetra
.60384 .53497 .60902 .54064 .61927 .53754 .61411 .53184 Mtetra
.61411 .53184 .61927 .53754 .62955 .53442 .62441 .5287 Mtetra
.62441 .5287 .62955 .53442 .63987 .53129 .63476 .52555 Mtetra
.63476 .52555 .63987 .53129 .65022 .52814 .64514 .52239 Mtetra
.64514 .52239 .65022 .52814 .66062 .52499 .65556 .51921 Mtetra
.65556 .51921 .66062 .52499 .67105 .52183 .66602 .51603 Mtetra
.66602 .51603 .67105 .52183 .68152 .51866 .67652 .51283 Mtetra
.67652 .51283 .68152 .51866 .69203 .51547 .68705 .50962 Mtetra
.68705 .50962 .69203 .51547 .70258 .51227 .69763 .5064 Mtetra
.69763 .5064 .70258 .51227 .71317 .50906 .70825 .50317 Mtetra
.70825 .50317 .71317 .50906 .7238 .50584 .7189 .49993 Mtetra
.7189 .49993 .7238 .50584 .73447 .50261 .7296 .49668 Mtetra
.7296 .49668 .73447 .50261 .74517 .49937 .74033 .49341 Mtetra
.74033 .49341 .74517 .49937 .75592 .49612 .75111 .49014 Mtetra
.75111 .49014 .75592 .49612 .76671 .49285 .76192 .48685 Mtetra
.76192 .48685 .76671 .49285 .77754 .48957 .77278 .48354 Mtetra
.77278 .48354 .77754 .48957 .78841 .48628 .78368 .48023 Mtetra
.78368 .48023 .78841 .48628 .79932 .48298 .79462 .47691 Mtetra
.79462 .47691 .79932 .48298 .81027 .47966 .8056 .47357 Mtetra
.8056 .47357 .81027 .47966 .82126 .47634 .81662 .47022 Mtetra
.81662 .47022 .82126 .47634 .83229 .473 .82769 .46685 Mtetra
.82769 .46685 .83229 .473 .84337 .46965 .83879 .46348 Mtetra
.83879 .46348 .84337 .46965 .85449 .46628 .84994 .46009 Mtetra
.84994 .46009 .85449 .46628 .86565 .4629 .86114 .45669 Mtetra
.86114 .45669 .86565 .4629 .87685 .45951 .87237 .45328 Mtetra
.87237 .45328 .87685 .45951 .8881 .45611 .88365 .44985 Mtetra
.88365 .44985 .8881 .45611 .89939 .4527 .89497 .44641 Mtetra
.89497 .44641 .89939 .4527 .91072 .44927 .90634 .44296 Mtetra
.90634 .44296 .91072 .44927 .9221 .44583 .91775 .43949 Mtetra
.635 .736 .921 r
.30645 .61847 .31232 .62389 .32152 .62151 .31566 .61616 Mtetra
.64 .74 .921 r
.31566 .61616 .32152 .62151 .33076 .6191 .32492 .61372 Mtetra
.637 .739 .922 r
.32492 .61372 .33076 .6191 .34002 .6169 .33421 .61135 Mtetra
.609 .725 .927 r
.33421 .61135 .34002 .6169 .34921 .61679 .3435 .60955 Mtetra
.905 .713 .633 r
.3435 .60955 .34921 .61679 .35891 .60712 .35477 .5691 Mtetra
0 .001 .501 r
.35477 .5691 .35891 .60712 .3682 .60635 .36245 .60055 Mtetra
.621 .721 .918 r
.36245 .60055 .3682 .60635 .3776 .60395 .37186 .59851 Mtetra
.644 .742 .92 r
.37186 .59851 .3776 .60395 .38705 .60128 .38132 .59592 Mtetra
.651 .747 .92 r
.38132 .59592 .38705 .60128 .39653 .59849 .39082 .59316 Mtetra
.654 .75 .92 r
.39082 .59316 .39653 .59849 .40606 .59563 .40037 .5903 Mtetra
.657 .752 .92 r
.40037 .5903 .40606 .59563 .41561 .59271 .40994 .58738 Mtetra
.658 .753 .92 r
.40994 .58738 .41561 .59271 .42521 .58975 .41956 .58442 Mtetra
.659 .753 .92 r
.41956 .58442 .42521 .58975 .43483 .58677 .42921 .58143 Mtetra
.659 .754 .92 r
.42921 .58143 .43483 .58677 .44449 .58378 .43889 .57842 Mtetra
.43889 .57842 .44449 .58378 .45419 .58078 .44861 .5754 Mtetra
.44861 .5754 .45419 .58078 .46392 .57778 .45836 .57237 Mtetra
.658 .753 .92 r
.45836 .57237 .46392 .57778 .47368 .57477 .46814 .56934 Mtetra
.46814 .56934 .47368 .57477 .48348 .57176 .47796 .56631 Mtetra
.47796 .56631 .48348 .57176 .49331 .56874 .48782 .56327 Mtetra
.48782 .56327 .49331 .56874 .50318 .56572 .49771 .56022 Mtetra
.49771 .56022 .50318 .56572 .51308 .56269 .50764 .55717 Mtetra
.50764 .55717 .51308 .56269 .52302 .55965 .5176 .55411 Mtetra
.5176 .55411 .52302 .55965 .53299 .5566 .5276 .55103 Mtetra
.657 .753 .92 r
.5276 .55103 .53299 .5566 .543 .55354 .53763 .54795 Mtetra
.53763 .54795 .543 .55354 .55305 .55047 .5477 .54486 Mtetra
.657 .752 .92 r
.5477 .54486 .55305 .55047 .56313 .54739 .55781 .54176 Mtetra
.55781 .54176 .56313 .54739 .57325 .5443 .56796 .53865 Mtetra
.56796 .53865 .57325 .5443 .58341 .5412 .57814 .53553 Mtetra
.57814 .53553 .58341 .5412 .59361 .53809 .58836 .5324 Mtetra
.58836 .5324 .59361 .53809 .60384 .53497 .59861 .52926 Mtetra
.59861 .52926 .60384 .53497 .61411 .53184 .60891 .52611 Mtetra
.60891 .52611 .61411 .53184 .62441 .5287 .61924 .52295 Mtetra
.61924 .52295 .62441 .5287 .63476 .52555 .62961 .51977 Mtetra
.62961 .51977 .63476 .52555 .64514 .52239 .64002 .51659 Mtetra
.64002 .51659 .64514 .52239 .65556 .51921 .65047 .51339 Mtetra
.65047 .51339 .65556 .51921 .66602 .51603 .66095 .51019 Mtetra
.66095 .51019 .66602 .51603 .67652 .51283 .67148 .50697 Mtetra
.67148 .50697 .67652 .51283 .68705 .50962 .68204 .50374 Mtetra
.68204 .50374 .68705 .50962 .69763 .5064 .69264 .5005 Mtetra
.69264 .5005 .69763 .5064 .70825 .50317 .70329 .49724 Mtetra
.70329 .49724 .70825 .50317 .7189 .49993 .71397 .49398 Mtetra
.71397 .49398 .7189 .49993 .7296 .49668 .72469 .4907 Mtetra
.72469 .4907 .7296 .49668 .74033 .49341 .73546 .48741 Mtetra
.73546 .48741 .74033 .49341 .75111 .49014 .74626 .48411 Mtetra
.74626 .48411 .75111 .49014 .76192 .48685 .75711 .4808 Mtetra
.75711 .4808 .76192 .48685 .77278 .48354 .76799 .47748 Mtetra
.76799 .47748 .77278 .48354 .78368 .48023 .77892 .47414 Mtetra
.77892 .47414 .78368 .48023 .79462 .47691 .78989 .47079 Mtetra
.78989 .47079 .79462 .47691 .8056 .47357 .8009 .46743 Mtetra
.8009 .46743 .8056 .47357 .81662 .47022 .81195 .46405 Mtetra
.81195 .46405 .81662 .47022 .82769 .46685 .82305 .46067 Mtetra
.82305 .46067 .82769 .46685 .83879 .46348 .83418 .45727 Mtetra
.83418 .45727 .83879 .46348 .84994 .46009 .84536 .45386 Mtetra
.84536 .45386 .84994 .46009 .86114 .45669 .85659 .45043 Mtetra
.85659 .45043 .86114 .45669 .87237 .45328 .86785 .44699 Mtetra
.86785 .44699 .87237 .45328 .88365 .44985 .87916 .44354 Mtetra
.87916 .44354 .88365 .44985 .89497 .44641 .89052 .44008 Mtetra
.89052 .44008 .89497 .44641 .90634 .44296 .90192 .4366 Mtetra
.90192 .4366 .90634 .44296 .91775 .43949 .91336 .43311 Mtetra
.626 .728 .92 r
.30054 .61288 .30645 .61847 .31566 .61616 .30976 .61075 Mtetra
.639 .739 .921 r
.30976 .61075 .31566 .61616 .32492 .61372 .31904 .60833 Mtetra
.639 .74 .922 r
.31904 .60833 .32492 .61372 .33421 .61135 .32835 .60587 Mtetra
.629 .735 .924 r
.32835 .60587 .33421 .61135 .3435 .60955 .33768 .60364 Mtetra
.516 .679 .939 r
.33768 .60364 .3435 .60955 .35477 .5691 .34694 .60349 Mtetra
.417 .155 .407 r
.34694 .60349 .35477 .5691 .36245 .60055 .35672 .59374 Mtetra
.568 .668 .906 r
.35672 .59374 .36245 .60055 .37186 .59851 .36608 .59293 Mtetra
.637 .736 .92 r
.36608 .59293 .37186 .59851 .38132 .59592 .37556 .59049 Mtetra
.648 .745 .92 r
.37556 .59049 .38132 .59592 .39082 .59316 .38508 .58777 Mtetra
.653 .749 .92 r
.38508 .58777 .39082 .59316 .40037 .5903 .39464 .58493 Mtetra
.656 .751 .92 r
.39464 .58493 .40037 .5903 .40994 .58738 .40424 .58202 Mtetra
.657 .752 .92 r
.40424 .58202 .40994 .58738 .41956 .58442 .41387 .57905 Mtetra
.658 .753 .92 r
.41387 .57905 .41956 .58442 .42921 .58143 .42354 .57605 Mtetra
.659 .754 .92 r
.42354 .57605 .42921 .58143 .43889 .57842 .43325 .57302 Mtetra
.43325 .57302 .43889 .57842 .44861 .5754 .44299 .56998 Mtetra
.44299 .56998 .44861 .5754 .45836 .57237 .45276 .56693 Mtetra
.659 .753 .92 r
.45276 .56693 .45836 .57237 .46814 .56934 .46257 .56388 Mtetra
.658 .753 .92 r
.46257 .56388 .46814 .56934 .47796 .56631 .47241 .56082 Mtetra
.47241 .56082 .47796 .56631 .48782 .56327 .48229 .55776 Mtetra
.48229 .55776 .48782 .56327 .49771 .56022 .49221 .55469 Mtetra
.49221 .55469 .49771 .56022 .50764 .55717 .50216 .55161 Mtetra
.50216 .55161 .50764 .55717 .5176 .55411 .51214 .54853 Mtetra
.51214 .54853 .5176 .55411 .5276 .55103 .52217 .54544 Mtetra
.657 .753 .92 r
.52217 .54544 .5276 .55103 .53763 .54795 .53222 .54233 Mtetra
.53222 .54233 .53763 .54795 .5477 .54486 .54232 .53922 Mtetra
.54232 .53922 .5477 .54486 .55781 .54176 .55245 .5361 Mtetra
.657 .752 .92 r
.55245 .5361 .55781 .54176 .56796 .53865 .56262 .53297 Mtetra
.56262 .53297 .56796 .53865 .57814 .53553 .57283 .52983 Mtetra
.57283 .52983 .57814 .53553 .58836 .5324 .58307 .52667 Mtetra
.58307 .52667 .58836 .5324 .59861 .52926 .59335 .52351 Mtetra
.59335 .52351 .59861 .52926 .60891 .52611 .60367 .52034 Mtetra
.60367 .52034 .60891 .52611 .61924 .52295 .61403 .51715 Mtetra
.61403 .51715 .61924 .52295 .62961 .51977 .62443 .51396 Mtetra
.62443 .51396 .62961 .51977 .64002 .51659 .63486 .51075 Mtetra
.63486 .51075 .64002 .51659 .65047 .51339 .64534 .50753 Mtetra
.64534 .50753 .65047 .51339 .66095 .51019 .65585 .5043 Mtetra
.65585 .5043 .66095 .51019 .67148 .50697 .6664 .50106 Mtetra
.6664 .50106 .67148 .50697 .68204 .50374 .67699 .49781 Mtetra
.67699 .49781 .68204 .50374 .69264 .5005 .68762 .49455 Mtetra
.68762 .49455 .69264 .5005 .70329 .49724 .69829 .49127 Mtetra
.69829 .49127 .70329 .49724 .71397 .49398 .709 .48798 Mtetra
.709 .48798 .71397 .49398 .72469 .4907 .71976 .48468 Mtetra
.71976 .48468 .72469 .4907 .73546 .48741 .73055 .48137 Mtetra
.73055 .48137 .73546 .48741 .74626 .48411 .74138 .47805 Mtetra
.74138 .47805 .74626 .48411 .75711 .4808 .75226 .47471 Mtetra
.75226 .47471 .75711 .4808 .76799 .47748 .76317 .47136 Mtetra
.76317 .47136 .76799 .47748 .77892 .47414 .77413 .468 Mtetra
.77413 .468 .77892 .47414 .78989 .47079 .78513 .46463 Mtetra
.78513 .46463 .78989 .47079 .8009 .46743 .79617 .46125 Mtetra
.79617 .46125 .8009 .46743 .81195 .46405 .80725 .45785 Mtetra
.80725 .45785 .81195 .46405 .82305 .46067 .81837 .45444 Mtetra
.81837 .45444 .82305 .46067 .83418 .45727 .82954 .45101 Mtetra
.82954 .45101 .83418 .45727 .84536 .45386 .84075 .44758 Mtetra
.84075 .44758 .84536 .45386 .85659 .45043 .85201 .44413 Mtetra
.85201 .44413 .85659 .45043 .86785 .44699 .86331 .44066 Mtetra
.86331 .44066 .86785 .44699 .87916 .44354 .87465 .43719 Mtetra
.87465 .43719 .87916 .44354 .89052 .44008 .88603 .4337 Mtetra
.88603 .4337 .89052 .44008 .90192 .4366 .89746 .4302 Mtetra
.89746 .4302 .90192 .4366 .91336 .43311 .90894 .42668 Mtetra
.604 .707 .917 r
.29463 .60688 .30054 .61288 .30976 .61075 .30383 .60525 Mtetra
.635 .736 .921 r
.30383 .60525 .30976 .61075 .31904 .60833 .31312 .6029 Mtetra
.64 .74 .921 r
.31312 .6029 .31904 .60833 .32835 .60587 .32245 .60041 Mtetra
.637 .739 .922 r
.32245 .60041 .32835 .60587 .33768 .60364 .33181 .59799 Mtetra
.609 .725 .927 r
.33181 .59799 .33768 .60364 .34694 .60349 .34117 .59615 Mtetra
.906 .714 .632 r
.34117 .59615 .34694 .60349 .35672 .59374 .35256 .5555 Mtetra
0 0 .498 r
.35256 .5555 .35672 .59374 .36608 .59293 .36028 .58704 Mtetra
.621 .721 .918 r
.36028 .58704 .36608 .59293 .37556 .59049 .36976 .58496 Mtetra
.644 .742 .92 r
.36976 .58496 .37556 .59049 .38508 .58777 .3793 .58232 Mtetra
.651 .747 .92 r
.3793 .58232 .38508 .58777 .39464 .58493 .38888 .57951 Mtetra
.654 .75 .92 r
.38888 .57951 .39464 .58493 .40424 .58202 .3985 .57661 Mtetra
.657 .752 .92 r
.3985 .57661 .40424 .58202 .41387 .57905 .40815 .57364 Mtetra
.658 .753 .92 r
.40815 .57364 .41387 .57905 .42354 .57605 .41784 .57063 Mtetra
.659 .753 .92 r
.41784 .57063 .42354 .57605 .43325 .57302 .42757 .56758 Mtetra
.659 .754 .92 r
.42757 .56758 .43325 .57302 .44299 .56998 .43733 .56452 Mtetra
.43733 .56452 .44299 .56998 .45276 .56693 .44713 .56145 Mtetra
.44713 .56145 .45276 .56693 .46257 .56388 .45696 .55837 Mtetra
.658 .753 .92 r
.45696 .55837 .46257 .56388 .47241 .56082 .46683 .55529 Mtetra
.46683 .55529 .47241 .56082 .48229 .55776 .47673 .55221 Mtetra
.47673 .55221 .48229 .55776 .49221 .55469 .48667 .54912 Mtetra
.48667 .54912 .49221 .55469 .50216 .55161 .49664 .54602 Mtetra
.49664 .54602 .50216 .55161 .51214 .54853 .50665 .54291 Mtetra
.50665 .54291 .51214 .54853 .52217 .54544 .5167 .5398 Mtetra
.5167 .5398 .52217 .54544 .53222 .54233 .52678 .53668 Mtetra
.657 .753 .92 r
.52678 .53668 .53222 .54233 .54232 .53922 .5369 .53354 Mtetra
.5369 .53354 .54232 .53922 .55245 .5361 .54706 .5304 Mtetra
.657 .752 .92 r
.54706 .5304 .55245 .5361 .56262 .53297 .55725 .52725 Mtetra
.55725 .52725 .56262 .53297 .57283 .52983 .56748 .52408 Mtetra
.56748 .52408 .57283 .52983 .58307 .52667 .57775 .52091 Mtetra
.57775 .52091 .58307 .52667 .59335 .52351 .58806 .51772 Mtetra
.58806 .51772 .59335 .52351 .60367 .52034 .5984 .51453 Mtetra
.5984 .51453 .60367 .52034 .61403 .51715 .60879 .51132 Mtetra
.60879 .51132 .61403 .51715 .62443 .51396 .61921 .5081 Mtetra
.61921 .5081 .62443 .51396 .63486 .51075 .62967 .50487 Mtetra
.62967 .50487 .63486 .51075 .64534 .50753 .64017 .50163 Mtetra
.64017 .50163 .64534 .50753 .65585 .5043 .65071 .49838 Mtetra
.65071 .49838 .65585 .5043 .6664 .50106 .66129 .49512 Mtetra
.66129 .49512 .6664 .50106 .67699 .49781 .67191 .49184 Mtetra
.67191 .49184 .67699 .49781 .68762 .49455 .68257 .48855 Mtetra
.68257 .48855 .68762 .49455 .69829 .49127 .69327 .48526 Mtetra
.69327 .48526 .69829 .49127 .709 .48798 .704 .48195 Mtetra
.704 .48195 .709 .48798 .71976 .48468 .71478 .47862 Mtetra
.71478 .47862 .71976 .48468 .73055 .48137 .7256 .47529 Mtetra
.7256 .47529 .73055 .48137 .74138 .47805 .73647 .47194 Mtetra
.73647 .47194 .74138 .47805 .75226 .47471 .74737 .46858 Mtetra
.74737 .46858 .75226 .47471 .76317 .47136 .75831 .46521 Mtetra
.75831 .46521 .76317 .47136 .77413 .468 .7693 .46183 Mtetra
.7693 .46183 .77413 .468 .78513 .46463 .78033 .45843 Mtetra
.78033 .45843 .78513 .46463 .79617 .46125 .7914 .45502 Mtetra
.7914 .45502 .79617 .46125 .80725 .45785 .80251 .4516 Mtetra
.80251 .4516 .80725 .45785 .81837 .45444 .81367 .44816 Mtetra
.81367 .44816 .81837 .45444 .82954 .45101 .82487 .44471 Mtetra
.82487 .44471 .82954 .45101 .84075 .44758 .83611 .44125 Mtetra
.83611 .44125 .84075 .44758 .85201 .44413 .8474 .43778 Mtetra
.8474 .43778 .85201 .44413 .86331 .44066 .85873 .43429 Mtetra
.85873 .43429 .86331 .44066 .87465 .43719 .8701 .43079 Mtetra
.8701 .43079 .87465 .43719 .88603 .4337 .88152 .42728 Mtetra
.88152 .42728 .88603 .4337 .89746 .4302 .89298 .42375 Mtetra
.89298 .42375 .89746 .4302 .90894 .42668 .90449 .42021 Mtetra
.503 .605 .888 r
.28881 .59894 .29463 .60688 .30383 .60525 .29787 .59957 Mtetra
.626 .728 .92 r
.29787 .59957 .30383 .60525 .31312 .6029 .30716 .5974 Mtetra
.639 .739 .921 r
.30716 .5974 .31312 .6029 .32245 .60041 .31651 .59493 Mtetra
.639 .74 .922 r
.31651 .59493 .32245 .60041 .33181 .59799 .32589 .59243 Mtetra
.629 .735 .924 r
.32589 .59243 .33181 .59799 .34117 .59615 .3353 .59015 Mtetra
.516 .679 .939 r
.3353 .59015 .34117 .59615 .35256 .5555 .34463 .58996 Mtetra
.412 .149 .401 r
.34463 .58996 .35256 .5555 .36028 .58704 .35449 .58013 Mtetra
.568 .669 .906 r
.35449 .58013 .36028 .58704 .36976 .58496 .36393 .57928 Mtetra
.637 .736 .92 r
.36393 .57928 .36976 .58496 .3793 .58232 .37348 .5768 Mtetra
.648 .745 .92 r
.37348 .5768 .3793 .58232 .38888 .57951 .38308 .57403 Mtetra
.653 .749 .92 r
.38308 .57403 .38888 .57951 .3985 .57661 .39272 .57115 Mtetra
.656 .751 .92 r
.39272 .57115 .3985 .57661 .40815 .57364 .40239 .56818 Mtetra
.657 .752 .92 r
.40239 .56818 .40815 .57364 .41784 .57063 .41211 .56516 Mtetra
.658 .753 .92 r
.41211 .56516 .41784 .57063 .42757 .56758 .42185 .56211 Mtetra
.659 .754 .92 r
.42185 .56211 .42757 .56758 .43733 .56452 .43164 .55903 Mtetra
.43164 .55903 .43733 .56452 .44713 .56145 .44146 .55594 Mtetra
.44146 .55594 .44713 .56145 .45696 .55837 .45131 .55284 Mtetra
.659 .753 .92 r
.45131 .55284 .45696 .55837 .46683 .55529 .4612 .54973 Mtetra
.658 .753 .92 r
.4612 .54973 .46683 .55529 .47673 .55221 .47113 .54663 Mtetra
.47113 .54663 .47673 .55221 .48667 .54912 .48109 .54351 Mtetra
.48109 .54351 .48667 .54912 .49664 .54602 .49109 .54039 Mtetra
.49109 .54039 .49664 .54602 .50665 .54291 .50112 .53726 Mtetra
.50112 .53726 .50665 .54291 .5167 .5398 .51119 .53413 Mtetra
.51119 .53413 .5167 .5398 .52678 .53668 .5213 .53098 Mtetra
.657 .753 .92 r
.5213 .53098 .52678 .53668 .5369 .53354 .53144 .52782 Mtetra
.53144 .52782 .5369 .53354 .54706 .5304 .54162 .52466 Mtetra
.54162 .52466 .54706 .5304 .55725 .52725 .55184 .52148 Mtetra
.657 .752 .92 r
.55184 .52148 .55725 .52725 .56748 .52408 .5621 .5183 Mtetra
.5621 .5183 .56748 .52408 .57775 .52091 .57239 .5151 Mtetra
.57239 .5151 .57775 .52091 .58806 .51772 .58273 .51189 Mtetra
.58273 .51189 .58806 .51772 .5984 .51453 .5931 .50868 Mtetra
.5931 .50868 .5984 .51453 .60879 .51132 .60351 .50545 Mtetra
.60351 .50545 .60879 .51132 .61921 .5081 .61396 .50221 Mtetra
.61396 .50221 .61921 .5081 .62967 .50487 .62444 .49895 Mtetra
.62444 .49895 .62967 .50487 .64017 .50163 .63497 .49569 Mtetra
.63497 .49569 .64017 .50163 .65071 .49838 .64554 .49242 Mtetra
.64554 .49242 .65071 .49838 .66129 .49512 .65614 .48913 Mtetra
.65614 .48913 .66129 .49512 .67191 .49184 .66679 .48583 Mtetra
.66679 .48583 .67191 .49184 .68257 .48855 .67748 .48252 Mtetra
.67748 .48252 .68257 .48855 .69327 .48526 .6882 .4792 Mtetra
.6882 .4792 .69327 .48526 .704 .48195 .69897 .47587 Mtetra
.69897 .47587 .704 .48195 .71478 .47862 .70978 .47252 Mtetra
.70978 .47252 .71478 .47862 .7256 .47529 .72063 .46916 Mtetra
.72063 .46916 .7256 .47529 .73647 .47194 .73152 .46579 Mtetra
.73152 .46579 .73647 .47194 .74737 .46858 .74245 .46241 Mtetra
.74245 .46241 .74737 .46858 .75831 .46521 .75342 .45901 Mtetra
.75342 .45901 .75831 .46521 .7693 .46183 .76444 .4556 Mtetra
.76444 .4556 .7693 .46183 .78033 .45843 .7755 .45218 Mtetra
.7755 .45218 .78033 .45843 .7914 .45502 .7866 .44875 Mtetra
.7866 .44875 .7914 .45502 .80251 .4516 .79774 .4453 Mtetra
.79774 .4453 .80251 .4516 .81367 .44816 .80893 .44184 Mtetra
.80893 .44184 .81367 .44816 .82487 .44471 .82016 .43837 Mtetra
.82016 .43837 .82487 .44471 .83611 .44125 .83143 .43488 Mtetra
.83143 .43488 .83611 .44125 .8474 .43778 .84275 .43138 Mtetra
.84275 .43138 .8474 .43778 .85873 .43429 .85411 .42787 Mtetra
.85411 .42787 .85873 .43429 .8701 .43079 .86552 .42435 Mtetra
.86552 .42435 .8701 .43079 .88152 .42728 .87697 .42081 Mtetra
.87697 .42081 .88152 .42728 .89298 .42375 .88846 .41725 Mtetra
.88846 .41725 .89298 .42375 .90449 .42021 .9 .41369 Mtetra
0 0 0 r
.28147 .61199 .28881 .59894 .29787 .59957 .2919 .59348 Mtetra
.603 .707 .917 r
.2919 .59348 .29787 .59957 .30716 .5974 .30118 .59181 Mtetra
.635 .736 .921 r
.30118 .59181 .30716 .5974 .31651 .59493 .31054 .58941 Mtetra
.64 .74 .921 r
.31054 .58941 .31651 .59493 .32589 .59243 .31994 .58688 Mtetra
.637 .739 .922 r
.31994 .58688 .32589 .59243 .3353 .59015 .32937 .58441 Mtetra
.609 .725 .927 r
.32937 .58441 .3353 .59015 .34463 .58996 .33881 .58253 Mtetra
.907 .714 .631 r
.33881 .58253 .34463 .58996 .35449 .58013 .35031 .54166 Mtetra
0 0 .495 r
.35031 .54166 .35449 .58013 .36393 .57928 .35807 .5733 Mtetra
.621 .721 .918 r
.35807 .5733 .36393 .57928 .37348 .5768 .36762 .57118 Mtetra
.644 .742 .92 r
.36762 .57118 .37348 .5768 .38308 .57403 .37724 .56849 Mtetra
.651 .747 .92 r
.37724 .56849 .38308 .57403 .39272 .57115 .3869 .56563 Mtetra
.654 .75 .92 r
.3869 .56563 .39272 .57115 .40239 .56818 .39659 .56268 Mtetra
.657 .752 .92 r
.39659 .56268 .40239 .56818 .41211 .56516 .40633 .55966 Mtetra
.658 .753 .92 r
.40633 .55966 .41211 .56516 .42185 .56211 .4161 .5566 Mtetra
.659 .753 .92 r
.4161 .5566 .42185 .56211 .43164 .55903 .42591 .5535 Mtetra
.659 .754 .92 r
.42591 .5535 .43164 .55903 .44146 .55594 .43575 .55039 Mtetra
.43575 .55039 .44146 .55594 .45131 .55284 .44563 .54727 Mtetra
.44563 .54727 .45131 .55284 .4612 .54973 .45554 .54414 Mtetra
.658 .753 .92 r
.45554 .54414 .4612 .54973 .47113 .54663 .46549 .54101 Mtetra
.46549 .54101 .47113 .54663 .48109 .54351 .47547 .53787 Mtetra
.47547 .53787 .48109 .54351 .49109 .54039 .48549 .53472 Mtetra
.48549 .53472 .49109 .54039 .50112 .53726 .49555 .53157 Mtetra
.49555 .53157 .50112 .53726 .51119 .53413 .50565 .52841 Mtetra
.50565 .52841 .51119 .53413 .5213 .53098 .51578 .52524 Mtetra
.51578 .52524 .5213 .53098 .53144 .52782 .52595 .52207 Mtetra
.657 .753 .92 r
.52595 .52207 .53144 .52782 .54162 .52466 .53615 .51888 Mtetra
.53615 .51888 .54162 .52466 .55184 .52148 .5464 .51568 Mtetra
.657 .752 .92 r
.5464 .51568 .55184 .52148 .5621 .5183 .55668 .51247 Mtetra
.55668 .51247 .5621 .5183 .57239 .5151 .567 .50925 Mtetra
.567 .50925 .57239 .5151 .58273 .51189 .57736 .50602 Mtetra
.57736 .50602 .58273 .51189 .5931 .50868 .58776 .50278 Mtetra
.58776 .50278 .5931 .50868 .60351 .50545 .59819 .49953 Mtetra
.59819 .49953 .60351 .50545 .61396 .50221 .60867 .49627 Mtetra
.60867 .49627 .61396 .50221 .62444 .49895 .61918 .49299 Mtetra
.61918 .49299 .62444 .49895 .63497 .49569 .62973 .48971 Mtetra
.62973 .48971 .63497 .49569 .64554 .49242 .64033 .48641 Mtetra
.64033 .48641 .64554 .49242 .65614 .48913 .65096 .4831 Mtetra
.65096 .4831 .65614 .48913 .66679 .48583 .66163 .47978 Mtetra
.66163 .47978 .66679 .48583 .67748 .48252 .67235 .47645 Mtetra
.67235 .47645 .67748 .48252 .6882 .4792 .6831 .4731 Mtetra
.6831 .4731 .6882 .4792 .69897 .47587 .6939 .46974 Mtetra
.6939 .46974 .69897 .47587 .70978 .47252 .70474 .46637 Mtetra
.70474 .46637 .70978 .47252 .72063 .46916 .71561 .46299 Mtetra
.71561 .46299 .72063 .46916 .73152 .46579 .72653 .4596 Mtetra
.72653 .4596 .73152 .46579 .74245 .46241 .73749 .45619 Mtetra
.73749 .45619 .74245 .46241 .75342 .45901 .7485 .45277 Mtetra
.7485 .45277 .75342 .45901 .76444 .4556 .75954 .44934 Mtetra
.75954 .44934 .76444 .4556 .7755 .45218 .77063 .44589 Mtetra
.77063 .44589 .7755 .45218 .7866 .44875 .78176 .44243 Mtetra
.78176 .44243 .7866 .44875 .79774 .4453 .79294 .43896 Mtetra
.79294 .43896 .79774 .4453 .80893 .44184 .80415 .43548 Mtetra
.80415 .43548 .80893 .44184 .82016 .43837 .81542 .43198 Mtetra
.81542 .43198 .82016 .43837 .83143 .43488 .82672 .42847 Mtetra
.82672 .42847 .83143 .43488 .84275 .43138 .83807 .42494 Mtetra
.83807 .42494 .84275 .43138 .85411 .42787 .84946 .4214 Mtetra
.84946 .4214 .85411 .42787 .86552 .42435 .8609 .41785 Mtetra
.8609 .41785 .86552 .42435 .87697 .42081 .87238 .41429 Mtetra
.87238 .41429 .87697 .42081 .88846 .41725 .88391 .41071 Mtetra
.88391 .41071 .88846 .41725 .9 .41369 .89549 .40712 Mtetra
.719 .584 .704 r
.27617 .59551 .28147 .61199 .2919 .59348 .28603 .58544 Mtetra
.502 .605 .888 r
.28603 .58544 .2919 .59348 .30118 .59181 .29516 .58604 Mtetra
.626 .728 .92 r
.29516 .58604 .30118 .59181 .31054 .58941 .30452 .58382 Mtetra
.639 .739 .921 r
.30452 .58382 .31054 .58941 .31994 .58688 .31394 .58131 Mtetra
.639 .74 .922 r
.31394 .58131 .31994 .58688 .32937 .58441 .3234 .57876 Mtetra
.629 .735 .924 r
.3234 .57876 .32937 .58441 .33881 .58253 .33288 .57643 Mtetra
.517 .679 .939 r
.33288 .57643 .33881 .58253 .35031 .54166 .34228 .57621 Mtetra
.407 .142 .396 r
.34228 .57621 .35031 .54166 .35807 .5733 .35223 .5663 Mtetra
.568 .669 .906 r
.35223 .5663 .35807 .5733 .36762 .57118 .36174 .56541 Mtetra
.637 .736 .92 r
.36174 .56541 .36762 .57118 .37724 .56849 .37136 .56288 Mtetra
.648 .745 .92 r
.37136 .56288 .37724 .56849 .3869 .56563 .38104 .56006 Mtetra
.653 .749 .92 r
.38104 .56006 .3869 .56563 .39659 .56268 .39076 .55712 Mtetra
.656 .751 .92 r
.39076 .55712 .39659 .56268 .40633 .55966 .40051 .55411 Mtetra
.657 .752 .92 r
.40051 .55411 .40633 .55966 .4161 .5566 .41031 .55104 Mtetra
.658 .753 .92 r
.41031 .55104 .4161 .5566 .42591 .5535 .42014 .54793 Mtetra
.659 .754 .92 r
.42014 .54793 .42591 .5535 .43575 .55039 .43 .5448 Mtetra
.43 .5448 .43575 .55039 .44563 .54727 .4399 .54166 Mtetra
.4399 .54166 .44563 .54727 .45554 .54414 .44984 .53851 Mtetra
.659 .753 .92 r
.44984 .53851 .45554 .54414 .46549 .54101 .45981 .53535 Mtetra
.658 .753 .92 r
.45981 .53535 .46549 .54101 .47547 .53787 .46982 .53219 Mtetra
.46982 .53219 .47547 .53787 .48549 .53472 .47986 .52902 Mtetra
.47986 .52902 .48549 .53472 .49555 .53157 .48995 .52585 Mtetra
.48995 .52585 .49555 .53157 .50565 .52841 .50007 .52266 Mtetra
.50007 .52266 .50565 .52841 .51578 .52524 .51022 .51947 Mtetra
.51022 .51947 .51578 .52524 .52595 .52207 .52042 .51627 Mtetra
.657 .753 .92 r
.52042 .51627 .52595 .52207 .53615 .51888 .53065 .51306 Mtetra
.53065 .51306 .53615 .51888 .5464 .51568 .54092 .50984 Mtetra
.54092 .50984 .5464 .51568 .55668 .51247 .55122 .50661 Mtetra
.657 .752 .92 r
.55122 .50661 .55668 .51247 .567 .50925 .56157 .50337 Mtetra
.56157 .50337 .567 .50925 .57736 .50602 .57195 .50012 Mtetra
.57195 .50012 .57736 .50602 .58776 .50278 .58238 .49685 Mtetra
.58238 .49685 .58776 .50278 .59819 .49953 .59284 .49358 Mtetra
.59284 .49358 .59819 .49953 .60867 .49627 .60334 .49029 Mtetra
.60334 .49029 .60867 .49627 .61918 .49299 .61388 .48699 Mtetra
.61388 .48699 .61918 .49299 .62973 .48971 .62446 .48368 Mtetra
.62446 .48368 .62973 .48971 .64033 .48641 .63508 .48036 Mtetra
.63508 .48036 .64033 .48641 .65096 .4831 .64574 .47703 Mtetra
.64574 .47703 .65096 .4831 .66163 .47978 .65644 .47369 Mtetra
.65644 .47369 .66163 .47978 .67235 .47645 .66719 .47033 Mtetra
.66719 .47033 .67235 .47645 .6831 .4731 .67797 .46696 Mtetra
.67797 .46696 .6831 .4731 .6939 .46974 .68879 .46358 Mtetra
.68879 .46358 .6939 .46974 .70474 .46637 .69966 .46018 Mtetra
.69966 .46018 .70474 .46637 .71561 .46299 .71056 .45678 Mtetra
.71056 .45678 .71561 .46299 .72653 .4596 .72151 .45336 Mtetra
.72151 .45336 .72653 .4596 .73749 .45619 .7325 .44993 Mtetra
.7325 .44993 .73749 .45619 .7485 .45277 .74354 .44648 Mtetra
.74354 .44648 .7485 .45277 .75954 .44934 .75461 .44303 Mtetra
.75461 .44303 .75954 .44934 .77063 .44589 .76573 .43956 Mtetra
.76573 .43956 .77063 .44589 .78176 .44243 .77689 .43607 Mtetra
.77689 .43607 .78176 .44243 .79294 .43896 .7881 .43258 Mtetra
.7881 .43258 .79294 .43896 .80415 .43548 .79935 .42907 Mtetra
.79935 .42907 .80415 .43548 .81542 .43198 .81064 .42554 Mtetra
.81064 .42554 .81542 .43198 .82672 .42847 .82198 .42201 Mtetra
.82198 .42201 .82672 .42847 .83807 .42494 .83336 .41846 Mtetra
.83336 .41846 .83807 .42494 .84946 .4214 .84478 .41489 Mtetra
.84478 .41489 .84946 .4214 .8609 .41785 .85625 .41131 Mtetra
.85625 .41131 .8609 .41785 .87238 .41429 .86777 .40772 Mtetra
.86777 .40772 .87238 .41429 .88391 .41071 .87933 .40412 Mtetra
.87933 .40412 .88391 .41071 .89549 .40712 .89094 .4005 Mtetra
.549 .064 0 r
.27014 .58883 .27617 .59551 .28603 .58544 .2786 .59848 Mtetra
.624 .793 .355 r
.2786 .59848 .28603 .58544 .29516 .58604 .28913 .57986 Mtetra
.603 .707 .917 r
.28913 .57986 .29516 .58604 .30452 .58382 .29847 .57814 Mtetra
.635 .736 .921 r
.29847 .57814 .30452 .58382 .31394 .58131 .30791 .57569 Mtetra
.64 .74 .921 r
.30791 .57569 .31394 .58131 .3234 .57876 .31738 .57312 Mtetra
.637 .739 .922 r
.31738 .57312 .3234 .57876 .33288 .57643 .32689 .5706 Mtetra
.61 .725 .927 r
.32689 .5706 .33288 .57643 .34228 .57621 .3364 .56867 Mtetra
.908 .715 .63 r
.3364 .56867 .34228 .57621 .35223 .5663 .34802 .5276 Mtetra
0 0 .492 r
.34802 .5276 .35223 .5663 .36174 .56541 .35582 .55933 Mtetra
.621 .721 .918 r
.35582 .55933 .36174 .56541 .37136 .56288 .36545 .55716 Mtetra
.644 .742 .92 r
.36545 .55716 .37136 .56288 .38104 .56006 .37515 .55443 Mtetra
.651 .747 .92 r
.37515 .55443 .38104 .56006 .39076 .55712 .38488 .55152 Mtetra
.654 .75 .92 r
.38488 .55152 .39076 .55712 .40051 .55411 .39466 .54851 Mtetra
.657 .752 .92 r
.39466 .54851 .40051 .55411 .41031 .55104 .40447 .54544 Mtetra
.658 .753 .92 r
.40447 .54544 .41031 .55104 .42014 .54793 .41433 .54232 Mtetra
.659 .753 .92 r
.41433 .54232 .42014 .54793 .43 .5448 .42421 .53918 Mtetra
.659 .754 .92 r
.42421 .53918 .43 .5448 .4399 .54166 .43414 .53601 Mtetra
.43414 .53601 .4399 .54166 .44984 .53851 .4441 .53284 Mtetra
.4441 .53284 .44984 .53851 .45981 .53535 .45409 .52965 Mtetra
.658 .753 .92 r
.45409 .52965 .45981 .53535 .46982 .53219 .46413 .52647 Mtetra
.46413 .52647 .46982 .53219 .47986 .52902 .4742 .52328 Mtetra
.4742 .52328 .47986 .52902 .48995 .52585 .4843 .52008 Mtetra
.4843 .52008 .48995 .52585 .50007 .52266 .49445 .51687 Mtetra
.49445 .51687 .50007 .52266 .51022 .51947 .50463 .51366 Mtetra
.50463 .51366 .51022 .51947 .52042 .51627 .51484 .51044 Mtetra
.51484 .51044 .52042 .51627 .53065 .51306 .5251 .5072 Mtetra
.657 .753 .92 r
.5251 .5072 .53065 .51306 .54092 .50984 .5354 .50396 Mtetra
.5354 .50396 .54092 .50984 .55122 .50661 .54573 .50071 Mtetra
.657 .752 .92 r
.54573 .50071 .55122 .50661 .56157 .50337 .5561 .49744 Mtetra
.5561 .49744 .56157 .50337 .57195 .50012 .56651 .49417 Mtetra
.56651 .49417 .57195 .50012 .58238 .49685 .57696 .49088 Mtetra
.57696 .49088 .58238 .49685 .59284 .49358 .58745 .48758 Mtetra
.58745 .48758 .59284 .49358 .60334 .49029 .59798 .48427 Mtetra
.59798 .48427 .60334 .49029 .61388 .48699 .60854 .48095 Mtetra
.60854 .48095 .61388 .48699 .62446 .48368 .61915 .47762 Mtetra
.61915 .47762 .62446 .48368 .63508 .48036 .6298 .47427 Mtetra
.6298 .47427 .63508 .48036 .64574 .47703 .64049 .47092 Mtetra
.64049 .47092 .64574 .47703 .65644 .47369 .65122 .46755 Mtetra
.65122 .46755 .65644 .47369 .66719 .47033 .66199 .46417 Mtetra
.66199 .46417 .66719 .47033 .67797 .46696 .6728 .46077 Mtetra
.6728 .46077 .67797 .46696 .68879 .46358 .68365 .45737 Mtetra
.68365 .45737 .68879 .46358 .69966 .46018 .69454 .45395 Mtetra
.69454 .45395 .69966 .46018 .71056 .45678 .70548 .45052 Mtetra
.70548 .45052 .71056 .45678 .72151 .45336 .71646 .44708 Mtetra
.71646 .44708 .72151 .45336 .7325 .44993 .72748 .44362 Mtetra
.72748 .44362 .7325 .44993 .74354 .44648 .73854 .44015 Mtetra
.73854 .44015 .74354 .44648 .75461 .44303 .74965 .43667 Mtetra
.74965 .43667 .75461 .44303 .76573 .43956 .7608 .43317 Mtetra
.7608 .43317 .76573 .43956 .77689 .43607 .77199 .42967 Mtetra
.77199 .42967 .77689 .43607 .7881 .43258 .78322 .42614 Mtetra
.78322 .42614 .7881 .43258 .79935 .42907 .7945 .42261 Mtetra
.7945 .42261 .79935 .42907 .81064 .42554 .80583 .41906 Mtetra
.80583 .41906 .81064 .42554 .82198 .42201 .8172 .4155 Mtetra
.8172 .4155 .82198 .42201 .83336 .41846 .82861 .41192 Mtetra
.82861 .41192 .83336 .41846 .84478 .41489 .84007 .40833 Mtetra
.84007 .40833 .84478 .41489 .85625 .41131 .85157 .40473 Mtetra
.85157 .40473 .85625 .41131 .86777 .40772 .86312 .40111 Mtetra
.86312 .40111 .86777 .40772 .87933 .40412 .87471 .39748 Mtetra
.87471 .39748 .87933 .40412 .89094 .4005 .88635 .39383 Mtetra
.562 .701 .934 r
.26402 .58286 .27014 .58883 .2786 .59848 .27326 .58186 Mtetra
.719 .584 .704 r
.27326 .58186 .2786 .59848 .28913 .57986 .2832 .57172 Mtetra
.502 .605 .888 r
.2832 .57172 .28913 .57986 .29847 .57814 .2924 .57228 Mtetra
.626 .728 .92 r
.2924 .57228 .29847 .57814 .30791 .57569 .30183 .57002 Mtetra
.639 .739 .921 r
.30183 .57002 .30791 .57569 .31738 .57312 .31133 .56745 Mtetra
.639 .74 .922 r
.31133 .56745 .31738 .57312 .32689 .5706 .32086 .56486 Mtetra
.629 .735 .924 r
.32086 .56486 .32689 .5706 .3364 .56867 .33042 .56248 Mtetra
.517 .679 .939 r
.33042 .56248 .3364 .56867 .34802 .5276 .33989 .56222 Mtetra
.402 .135 .39 r
.33989 .56222 .34802 .5276 .35582 .55933 .34993 .55223 Mtetra
.568 .669 .906 r
.34993 .55223 .35582 .55933 .36545 .55716 .35951 .5513 Mtetra
.637 .736 .92 r
.35951 .5513 .36545 .55716 .37515 .55443 .36921 .54872 Mtetra
.648 .745 .92 r
.36921 .54872 .37515 .55443 .38488 .55152 .37897 .54585 Mtetra
.653 .749 .92 r
.37897 .54585 .38488 .55152 .39466 .54851 .38877 .54286 Mtetra
.656 .751 .92 r
.38877 .54286 .39466 .54851 .40447 .54544 .3986 .53979 Mtetra
.657 .752 .92 r
.3986 .53979 .40447 .54544 .41433 .54232 .40848 .53667 Mtetra
.658 .753 .92 r
.40848 .53667 .41433 .54232 .42421 .53918 .41839 .53351 Mtetra
.659 .754 .92 r
.41839 .53351 .42421 .53918 .43414 .53601 .42834 .53033 Mtetra
.42834 .53033 .43414 .53601 .4441 .53284 .43832 .52713 Mtetra
.43832 .52713 .4441 .53284 .45409 .52965 .44834 .52392 Mtetra
.659 .753 .92 r
.44834 .52392 .45409 .52965 .46413 .52647 .4584 .52071 Mtetra
.658 .753 .92 r
.4584 .52071 .46413 .52647 .4742 .52328 .46849 .5175 Mtetra
.46849 .5175 .4742 .52328 .4843 .52008 .47862 .51427 Mtetra
.47862 .51427 .4843 .52008 .49445 .51687 .48879 .51104 Mtetra
.48879 .51104 .49445 .51687 .50463 .51366 .49899 .50781 Mtetra
.49899 .50781 .50463 .51366 .51484 .51044 .50924 .50456 Mtetra
.50924 .50456 .51484 .51044 .5251 .5072 .51952 .5013 Mtetra
.657 .753 .92 r
.51952 .5013 .5251 .5072 .5354 .50396 .52984 .49804 Mtetra
.52984 .49804 .5354 .50396 .54573 .50071 .54019 .49476 Mtetra
.54019 .49476 .54573 .50071 .5561 .49744 .55059 .49147 Mtetra
.657 .752 .92 r
.55059 .49147 .5561 .49744 .56651 .49417 .56103 .48817 Mtetra
.56103 .48817 .56651 .49417 .57696 .49088 .5715 .48486 Mtetra
.5715 .48486 .57696 .49088 .58745 .48758 .58202 .48154 Mtetra
.58202 .48154 .58745 .48758 .59798 .48427 .59257 .47821 Mtetra
.59257 .47821 .59798 .48427 .60854 .48095 .60317 .47487 Mtetra
.60317 .47487 .60854 .48095 .61915 .47762 .6138 .47151 Mtetra
.6138 .47151 .61915 .47762 .6298 .47427 .62448 .46814 Mtetra
.62448 .46814 .6298 .47427 .64049 .47092 .63519 .46476 Mtetra
.63519 .46476 .64049 .47092 .65122 .46755 .64595 .46137 Mtetra
.64595 .46137 .65122 .46755 .66199 .46417 .65675 .45796 Mtetra
.65675 .45796 .66199 .46417 .6728 .46077 .66759 .45455 Mtetra
.66759 .45455 .6728 .46077 .68365 .45737 .67847 .45112 Mtetra
.67847 .45112 .68365 .45737 .69454 .45395 .68939 .44767 Mtetra
.68939 .44767 .69454 .45395 .70548 .45052 .70036 .44422 Mtetra
.70036 .44422 .70548 .45052 .71646 .44708 .71137 .44075 Mtetra
.71137 .44075 .71646 .44708 .72748 .44362 .72242 .43727 Mtetra
.72242 .43727 .72748 .44362 .73854 .44015 .73351 .43377 Mtetra
.73351 .43377 .73854 .44015 .74965 .43667 .74464 .43027 Mtetra
.74464 .43027 .74965 .43667 .7608 .43317 .75582 .42675 Mtetra
.75582 .42675 .7608 .43317 .77199 .42967 .76705 .42321 Mtetra
.76705 .42321 .77199 .42967 .78322 .42614 .77831 .41966 Mtetra
.77831 .41966 .78322 .42614 .7945 .42261 .78963 .4161 Mtetra
.78963 .4161 .7945 .42261 .80583 .41906 .80098 .41253 Mtetra
.80098 .41253 .80583 .41906 .8172 .4155 .81238 .40894 Mtetra
.81238 .40894 .8172 .4155 .82861 .41192 .82383 .40534 Mtetra
.82383 .40534 .82861 .41192 .84007 .40833 .83532 .40172 Mtetra
.83532 .40172 .84007 .40833 .85157 .40473 .84685 .39809 Mtetra
.84685 .39809 .85157 .40473 .86312 .40111 .85844 .39445 Mtetra
.85844 .39445 .86312 .40111 .87471 .39748 .87006 .39079 Mtetra
.87006 .39079 .87471 .39748 .88635 .39383 .88174 .38712 Mtetra
.611 .725 .926 r
.25784 .57704 .26402 .58286 .27326 .58186 .26717 .57509 Mtetra
.541 .058 0 r
.26717 .57509 .27326 .58186 .2832 .57172 .27569 .58474 Mtetra
.633 .801 .365 r
.27569 .58474 .2832 .57172 .2924 .57228 .28631 .566 Mtetra
.603 .707 .917 r
.28631 .566 .2924 .57228 .30183 .57002 .29573 .56424 Mtetra
.635 .736 .921 r
.29573 .56424 .30183 .57002 .31133 .56745 .30523 .56175 Mtetra
.64 .74 .921 r
.30523 .56175 .31133 .56745 .32086 .56486 .31479 .55912 Mtetra
.637 .739 .922 r
.31479 .55912 .32086 .56486 .33042 .56248 .32437 .55656 Mtetra
.61 .725 .927 r
.32437 .55656 .33042 .56248 .33989 .56222 .33396 .55458 Mtetra
.909 .716 .629 r
.33396 .55458 .33989 .56222 .34993 .55223 .3457 .51329 Mtetra
0 0 .489 r
.3457 .51329 .34993 .55223 .35951 .5513 .35354 .54512 Mtetra
.621 .721 .918 r
.35354 .54512 .35951 .5513 .36921 .54872 .36325 .54291 Mtetra
.644 .742 .92 r
.36325 .54291 .36921 .54872 .37897 .54585 .37302 .54012 Mtetra
.651 .747 .92 r
.37302 .54012 .37897 .54585 .38877 .54286 .38284 .53716 Mtetra
.654 .75 .92 r
.38284 .53716 .38877 .54286 .3986 .53979 .39269 .5341 Mtetra
.657 .752 .92 r
.39269 .5341 .3986 .53979 .40848 .53667 .40259 .53097 Mtetra
.658 .753 .92 r
.40259 .53097 .40848 .53667 .41839 .53351 .41252 .5278 Mtetra
.659 .753 .92 r
.41252 .5278 .41839 .53351 .42834 .53033 .42249 .5246 Mtetra
.659 .754 .92 r
.42249 .5246 .42834 .53033 .43832 .52713 .4325 .52138 Mtetra
.4325 .52138 .43832 .52713 .44834 .52392 .44254 .51815 Mtetra
.44254 .51815 .44834 .52392 .4584 .52071 .45262 .51492 Mtetra
.658 .753 .92 r
.45262 .51492 .4584 .52071 .46849 .5175 .46274 .51168 Mtetra
.46274 .51168 .46849 .5175 .47862 .51427 .4729 .50843 Mtetra
.4729 .50843 .47862 .51427 .48879 .51104 .48309 .50518 Mtetra
.48309 .50518 .48879 .51104 .49899 .50781 .49332 .50192 Mtetra
.49332 .50192 .49899 .50781 .50924 .50456 .50359 .49864 Mtetra
.50359 .49864 .50924 .50456 .51952 .5013 .51389 .49536 Mtetra
.51389 .49536 .51952 .5013 .52984 .49804 .52424 .49207 Mtetra
.657 .753 .92 r
.52424 .49207 .52984 .49804 .54019 .49476 .53462 .48877 Mtetra
.53462 .48877 .54019 .49476 .55059 .49147 .54505 .48546 Mtetra
.657 .752 .92 r
.54505 .48546 .55059 .49147 .56103 .48817 .55551 .48214 Mtetra
.55551 .48214 .56103 .48817 .5715 .48486 .56601 .47881 Mtetra
.56601 .47881 .5715 .48486 .58202 .48154 .57655 .47546 Mtetra
.57655 .47546 .58202 .48154 .59257 .47821 .58713 .47211 Mtetra
.58713 .47211 .59257 .47821 .60317 .47487 .59776 .46874 Mtetra
.59776 .46874 .60317 .47487 .6138 .47151 .60842 .46536 Mtetra
.60842 .46536 .6138 .47151 .62448 .46814 .61912 .46196 Mtetra
.61912 .46196 .62448 .46814 .63519 .46476 .62986 .45856 Mtetra
.62986 .45856 .63519 .46476 .64595 .46137 .64065 .45514 Mtetra
.64065 .45514 .64595 .46137 .65675 .45796 .65148 .45171 Mtetra
.65148 .45171 .65675 .45796 .66759 .45455 .66234 .44827 Mtetra
.66234 .44827 .66759 .45455 .67847 .45112 .67325 .44482 Mtetra
.67325 .44482 .67847 .45112 .68939 .44767 .68421 .44135 Mtetra
.68421 .44135 .68939 .44767 .70036 .44422 .6952 .43787 Mtetra
.6952 .43787 .70036 .44422 .71137 .44075 .70624 .43438 Mtetra
.70624 .43438 .71137 .44075 .72242 .43727 .71732 .43087 Mtetra
.71732 .43087 .72242 .43727 .73351 .43377 .72844 .42735 Mtetra
.72844 .42735 .73351 .43377 .74464 .43027 .73961 .42382 Mtetra
.73961 .42382 .74464 .43027 .75582 .42675 .75082 .42027 Mtetra
.75082 .42027 .75582 .42675 .76705 .42321 .76207 .41671 Mtetra
.76207 .41671 .76705 .42321 .77831 .41966 .77337 .41314 Mtetra
.77337 .41314 .77831 .41966 .78963 .4161 .78471 .40955 Mtetra
.78471 .40955 .78963 .4161 .80098 .41253 .7961 .40595 Mtetra
.7961 .40595 .80098 .41253 .81238 .40894 .80753 .40234 Mtetra
.80753 .40234 .81238 .40894 .82383 .40534 .81901 .39871 Mtetra
.81901 .39871 .82383 .40534 .83532 .40172 .83053 .39507 Mtetra
.83053 .39507 .83532 .40172 .84685 .39809 .8421 .39141 Mtetra
.8421 .39141 .84685 .39809 .85844 .39445 .85372 .38774 Mtetra
.85372 .38774 .85844 .39445 .87006 .39079 .86538 .38405 Mtetra
.86538 .38405 .87006 .39079 .88174 .38712 .87709 .38035 Mtetra
.624 .731 .924 r
.25161 .57125 .25784 .57704 .26717 .57509 .26098 .56902 Mtetra
.562 .701 .934 r
.26098 .56902 .26717 .57509 .27569 .58474 .2703 .56798 Mtetra
.719 .584 .704 r
.2703 .56798 .27569 .58474 .28631 .566 .28032 .55776 Mtetra
.502 .605 .888 r
.28032 .55776 .28631 .566 .29573 .56424 .28959 .55829 Mtetra
.626 .728 .92 r
.28959 .55829 .29573 .56424 .30523 .56175 .2991 .55597 Mtetra
.639 .739 .921 r
.2991 .55597 .30523 .56175 .31479 .55912 .30867 .55336 Mtetra
.639 .74 .922 r
.30867 .55336 .31479 .55912 .32437 .55656 .31828 .55072 Mtetra
.629 .735 .924 r
.31828 .55072 .32437 .55656 .33396 .55458 .32791 .54829 Mtetra
.517 .679 .939 r
.32791 .54829 .33396 .55458 .3457 .51329 .33746 .54799 Mtetra
.396 .127 .384 r
.33746 .54799 .3457 .51329 .35354 .54512 .34758 .53792 Mtetra
.568 .669 .906 r
.34758 .53792 .35354 .54512 .36325 .54291 .35724 .53694 Mtetra
.637 .736 .92 r
.35724 .53694 .36325 .54291 .37302 .54012 .36703 .53431 Mtetra
.648 .745 .92 r
.36703 .53431 .37302 .54012 .38284 .53716 .37686 .53139 Mtetra
.653 .749 .92 r
.37686 .53139 .38284 .53716 .39269 .5341 .38674 .52835 Mtetra
.656 .751 .92 r
.38674 .52835 .39269 .5341 .40259 .53097 .39666 .52523 Mtetra
.657 .752 .92 r
.39666 .52523 .40259 .53097 .41252 .5278 .40662 .52205 Mtetra
.658 .753 .92 r
.40662 .52205 .41252 .5278 .42249 .5246 .41661 .51884 Mtetra
.659 .754 .92 r
.41661 .51884 .42249 .5246 .4325 .52138 .42664 .5156 Mtetra
.42664 .5156 .4325 .52138 .44254 .51815 .43671 .51235 Mtetra
.43671 .51235 .44254 .51815 .45262 .51492 .44681 .50909 Mtetra
.659 .753 .92 r
.44681 .50909 .45262 .51492 .46274 .51168 .45695 .50582 Mtetra
.658 .753 .92 r
.45695 .50582 .46274 .51168 .4729 .50843 .46713 .50255 Mtetra
.46713 .50255 .4729 .50843 .48309 .50518 .47735 .49927 Mtetra
.47735 .49927 .48309 .50518 .49332 .50192 .48761 .49598 Mtetra
.48761 .49598 .49332 .50192 .50359 .49864 .4979 .49269 Mtetra
.4979 .49269 .50359 .49864 .51389 .49536 .50823 .48938 Mtetra
.50823 .48938 .51389 .49536 .52424 .49207 .5186 .48607 Mtetra
.657 .753 .92 r
.5186 .48607 .52424 .49207 .53462 .48877 .52901 .48275 Mtetra
.52901 .48275 .53462 .48877 .54505 .48546 .53946 .47941 Mtetra
.53946 .47941 .54505 .48546 .55551 .48214 .54995 .47607 Mtetra
.657 .752 .92 r
.54995 .47607 .55551 .48214 .56601 .47881 .56048 .47271 Mtetra
.56048 .47271 .56601 .47881 .57655 .47546 .57105 .46934 Mtetra
.57105 .46934 .57655 .47546 .58713 .47211 .58165 .46596 Mtetra
.58165 .46596 .58713 .47211 .59776 .46874 .5923 .46257 Mtetra
.5923 .46257 .59776 .46874 .60842 .46536 .60299 .45916 Mtetra
.60299 .45916 .60842 .46536 .61912 .46196 .61372 .45575 Mtetra
.61372 .45575 .61912 .46196 .62986 .45856 .6245 .45232 Mtetra
.6245 .45232 .62986 .45856 .64065 .45514 .63531 .44887 Mtetra
.63531 .44887 .64065 .45514 .65148 .45171 .64616 .44542 Mtetra
.64616 .44542 .65148 .45171 .66234 .44827 .65706 .44195 Mtetra
.65706 .44195 .66234 .44827 .67325 .44482 .668 .43847 Mtetra
.668 .43847 .67325 .44482 .68421 .44135 .67898 .43498 Mtetra
.67898 .43498 .68421 .44135 .6952 .43787 .69 .43148 Mtetra
.69 .43148 .6952 .43787 .70624 .43438 .70107 .42796 Mtetra
.70107 .42796 .70624 .43438 .71732 .43087 .71218 .42443 Mtetra
.71218 .42443 .71732 .43087 .72844 .42735 .72333 .42088 Mtetra
.72333 .42088 .72844 .42735 .73961 .42382 .73453 .41732 Mtetra
.73453 .41732 .73961 .42382 .75082 .42027 .74577 .41375 Mtetra
.74577 .41375 .75082 .42027 .76207 .41671 .75706 .41017 Mtetra
.75706 .41017 .76207 .41671 .77337 .41314 .76839 .40657 Mtetra
.76839 .40657 .77337 .41314 .78471 .40955 .77976 .40295 Mtetra
.77976 .40295 .78471 .40955 .7961 .40595 .79118 .39933 Mtetra
.79118 .39933 .7961 .40595 .80753 .40234 .80265 .39568 Mtetra
.80265 .39568 .80753 .40234 .81901 .39871 .81416 .39203 Mtetra
.81416 .39203 .81901 .39871 .83053 .39507 .82571 .38836 Mtetra
.82571 .38836 .83053 .39507 .8421 .39141 .83731 .38468 Mtetra
.83731 .38468 .8421 .39141 .85372 .38774 .84896 .38098 Mtetra
.84896 .38098 .85372 .38774 .86538 .38405 .86066 .37726 Mtetra
.86066 .37726 .86538 .38405 .87709 .38035 .8724 .37354 Mtetra
.626 .731 .923 r
.24535 .56541 .25161 .57125 .26098 .56902 .25474 .56311 Mtetra
.611 .725 .926 r
.25474 .56311 .26098 .56902 .2703 .56798 .26414 .56111 Mtetra
.534 .051 0 r
.26414 .56111 .2703 .56798 .28032 .55776 .27272 .57077 Mtetra
.643 .808 .374 r
.27272 .57077 .28032 .55776 .28959 .55829 .28344 .55191 Mtetra
.603 .707 .917 r
.28344 .55191 .28959 .55829 .2991 .55597 .29293 .5501 Mtetra
.635 .736 .921 r
.29293 .5501 .2991 .55597 .30867 .55336 .30252 .54756 Mtetra
.64 .74 .921 r
.30252 .54756 .30867 .55336 .31828 .55072 .31214 .54488 Mtetra
.637 .739 .922 r
.31214 .54488 .31828 .55072 .32791 .54829 .32181 .54227 Mtetra
.61 .725 .927 r
.32181 .54227 .32791 .54829 .33746 .54799 .33147 .54025 Mtetra
.91 .716 .628 r
.33147 .54025 .33746 .54799 .34758 .53792 .34334 .49874 Mtetra
0 0 .485 r
.34334 .49874 .34758 .53792 .35724 .53694 .35121 .53067 Mtetra
.621 .721 .918 r
.35121 .53067 .35724 .53694 .36703 .53431 .361 .5284 Mtetra
.644 .742 .92 r
.361 .5284 .36703 .53431 .37686 .53139 .37085 .52556 Mtetra
.651 .747 .92 r
.37085 .52556 .37686 .53139 .38674 .52835 .38075 .52255 Mtetra
.654 .75 .92 r
.38075 .52255 .38674 .52835 .39666 .52523 .39069 .51943 Mtetra
.657 .752 .92 r
.39069 .51943 .39666 .52523 .40662 .52205 .40067 .51626 Mtetra
.658 .753 .92 r
.40067 .51626 .40662 .52205 .41661 .51884 .41069 .51303 Mtetra
.659 .754 .92 r
.41069 .51303 .41661 .51884 .42664 .5156 .42074 .50978 Mtetra
.42074 .50978 .42664 .5156 .43671 .51235 .43083 .5065 Mtetra
.43083 .5065 .43671 .51235 .44681 .50909 .44096 .50321 Mtetra
.44096 .50321 .44681 .50909 .45695 .50582 .45113 .49992 Mtetra
.658 .753 .92 r
.45113 .49992 .45695 .50582 .46713 .50255 .46133 .49662 Mtetra
.46133 .49662 .46713 .50255 .47735 .49927 .47157 .49332 Mtetra
.47157 .49332 .47735 .49927 .48761 .49598 .48185 .49001 Mtetra
.48185 .49001 .48761 .49598 .4979 .49269 .49217 .48669 Mtetra
.49217 .48669 .4979 .49269 .50823 .48938 .50253 .48336 Mtetra
.50253 .48336 .50823 .48938 .5186 .48607 .51293 .48003 Mtetra
.51293 .48003 .5186 .48607 .52901 .48275 .52336 .47668 Mtetra
.657 .753 .92 r
.52336 .47668 .52901 .48275 .53946 .47941 .53384 .47332 Mtetra
.53384 .47332 .53946 .47941 .54995 .47607 .54435 .46995 Mtetra
.657 .752 .92 r
.54435 .46995 .54995 .47607 .56048 .47271 .55491 .46657 Mtetra
.55491 .46657 .56048 .47271 .57105 .46934 .5655 .46317 Mtetra
.5655 .46317 .57105 .46934 .58165 .46596 .57614 .45977 Mtetra
.57614 .45977 .58165 .46596 .5923 .46257 .58681 .45635 Mtetra
.58681 .45635 .5923 .46257 .60299 .45916 .59753 .45292 Mtetra
.59753 .45292 .60299 .45916 .61372 .45575 .60829 .44948 Mtetra
.60829 .44948 .61372 .45575 .6245 .45232 .61909 .44603 Mtetra
.61909 .44603 .6245 .45232 .63531 .44887 .62993 .44256 Mtetra
.62993 .44256 .63531 .44887 .64616 .44542 .64081 .43908 Mtetra
.64081 .43908 .64616 .44542 .65706 .44195 .65174 .43559 Mtetra
.65174 .43559 .65706 .44195 .668 .43847 .66271 .43209 Mtetra
.66271 .43209 .668 .43847 .67898 .43498 .67372 .42857 Mtetra
.67372 .42857 .67898 .43498 .69 .43148 .68477 .42504 Mtetra
.68477 .42504 .69 .43148 .70107 .42796 .69587 .42149 Mtetra
.69587 .42149 .70107 .42796 .71218 .42443 .70701 .41794 Mtetra
.70701 .41794 .71218 .42443 .72333 .42088 .71819 .41437 Mtetra
.71819 .41437 .72333 .42088 .73453 .41732 .72942 .41078 Mtetra
.72942 .41078 .73453 .41732 .74577 .41375 .74069 .40718 Mtetra
.74069 .40718 .74577 .41375 .75706 .41017 .75201 .40357 Mtetra
.75201 .40357 .75706 .41017 .76839 .40657 .76337 .39994 Mtetra
.76337 .39994 .76839 .40657 .77976 .40295 .77478 .39631 Mtetra
.77478 .39631 .77976 .40295 .79118 .39933 .78623 .39265 Mtetra
.78623 .39265 .79118 .39933 .80265 .39568 .79772 .38898 Mtetra
.79772 .38898 .80265 .39568 .81416 .39203 .80927 .3853 Mtetra
.80927 .3853 .81416 .39203 .82571 .38836 .82086 .3816 Mtetra
.82086 .3816 .82571 .38836 .83731 .38468 .83249 .37789 Mtetra
.83249 .37789 .83731 .38468 .84896 .38098 .84417 .37417 Mtetra
.84417 .37417 .84896 .38098 .86066 .37726 .8559 .37043 Mtetra
.8559 .37043 .86066 .37726 .8724 .37354 .86768 .36667 Mtetra
.621 .726 .922 r
.23906 .55943 .24535 .56541 .25474 .56311 .24845 .55723 Mtetra
.624 .731 .924 r
.24845 .55723 .25474 .56311 .26414 .56111 .25789 .55495 Mtetra
.562 .701 .934 r
.25789 .55495 .26414 .56111 .27272 .57077 .26728 .55387 Mtetra
.719 .584 .704 r
.26728 .55387 .27272 .57077 .28344 .55191 .27739 .54356 Mtetra
.501 .605 .888 r
.27739 .54356 .28344 .55191 .29293 .5501 .28673 .54405 Mtetra
.626 .728 .92 r
.28673 .54405 .29293 .5501 .30252 .54756 .29632 .54169 Mtetra
.639 .739 .921 r
.29632 .54169 .30252 .54756 .31214 .54488 .30597 .53903 Mtetra
.639 .74 .922 r
.30597 .53903 .31214 .54488 .32181 .54227 .31565 .53633 Mtetra
.629 .735 .924 r
.31565 .53633 .32181 .54227 .33147 .54025 .32536 .53385 Mtetra
.518 .679 .938 r
.32536 .53385 .33147 .54025 .34334 .49874 .33499 .53351 Mtetra
.39 .12 .379 r
.33499 .53351 .34334 .49874 .35121 .53067 .3452 .52336 Mtetra
.567 .669 .907 r
.3452 .52336 .35121 .53067 .361 .5284 .35494 .52234 Mtetra
.637 .736 .92 r
.35494 .52234 .361 .5284 .37085 .52556 .3648 .51966 Mtetra
.648 .745 .92 r
.3648 .51966 .37085 .52556 .38075 .52255 .37472 .51668 Mtetra
.653 .749 .92 r
.37472 .51668 .38075 .52255 .39069 .51943 .38468 .51359 Mtetra
.656 .751 .92 r
.38468 .51359 .39069 .51943 .40067 .51626 .39468 .51041 Mtetra
.657 .752 .92 r
.39468 .51041 .40067 .51626 .41069 .51303 .40472 .50718 Mtetra
.658 .753 .92 r
.40472 .50718 .41069 .51303 .42074 .50978 .4148 .50391 Mtetra
.659 .754 .92 r
.4148 .50391 .42074 .50978 .43083 .5065 .42491 .50061 Mtetra
.42491 .50061 .43083 .5065 .44096 .50321 .43507 .4973 Mtetra
.43507 .4973 .44096 .50321 .45113 .49992 .44526 .49399 Mtetra
.659 .753 .92 r
.44526 .49399 .45113 .49992 .46133 .49662 .45549 .49066 Mtetra
.658 .753 .92 r
.45549 .49066 .46133 .49662 .47157 .49332 .46576 .48733 Mtetra
.46576 .48733 .47157 .49332 .48185 .49001 .47606 .484 Mtetra
.47606 .484 .48185 .49001 .49217 .48669 .4864 .48065 Mtetra
.4864 .48065 .49217 .48669 .50253 .48336 .49679 .4773 Mtetra
.49679 .4773 .50253 .48336 .51293 .48003 .50721 .47394 Mtetra
.50721 .47394 .51293 .48003 .52336 .47668 .51767 .47057 Mtetra
.657 .753 .92 r
.51767 .47057 .52336 .47668 .53384 .47332 .52817 .46718 Mtetra
.52817 .46718 .53384 .47332 .54435 .46995 .53871 .46379 Mtetra
.53871 .46379 .54435 .46995 .55491 .46657 .5493 .46038 Mtetra
.657 .752 .92 r
.5493 .46038 .55491 .46657 .5655 .46317 .55992 .45696 Mtetra
.55992 .45696 .5655 .46317 .57614 .45977 .57058 .45353 Mtetra
.57058 .45353 .57614 .45977 .58681 .45635 .58128 .45009 Mtetra
.58128 .45009 .58681 .45635 .59753 .45292 .59203 .44664 Mtetra
.59203 .44664 .59753 .45292 .60829 .44948 .60282 .44317 Mtetra
.60282 .44317 .60829 .44948 .61909 .44603 .61364 .43969 Mtetra
.61364 .43969 .61909 .44603 .62993 .44256 .62451 .4362 Mtetra
.62451 .4362 .62993 .44256 .64081 .43908 .63543 .4327 Mtetra
.63543 .4327 .64081 .43908 .65174 .43559 .64638 .42918 Mtetra
.64638 .42918 .65174 .43559 .66271 .43209 .65738 .42565 Mtetra
.65738 .42565 .66271 .43209 .67372 .42857 .66842 .42211 Mtetra
.66842 .42211 .67372 .42857 .68477 .42504 .6795 .41855 Mtetra
.6795 .41855 .68477 .42504 .69587 .42149 .69063 .41498 Mtetra
.69063 .41498 .69587 .42149 .70701 .41794 .7018 .4114 Mtetra
.7018 .4114 .70701 .41794 .71819 .41437 .71301 .4078 Mtetra
.71301 .4078 .71819 .41437 .72942 .41078 .72427 .40419 Mtetra
.72427 .40419 .72942 .41078 .74069 .40718 .73557 .40057 Mtetra
.73557 .40057 .74069 .40718 .75201 .40357 .74692 .39693 Mtetra
.74692 .39693 .75201 .40357 .76337 .39994 .75831 .39327 Mtetra
.75831 .39327 .76337 .39994 .77478 .39631 .76975 .38961 Mtetra
.76975 .38961 .77478 .39631 .78623 .39265 .78124 .38593 Mtetra
.78124 .38593 .78623 .39265 .79772 .38898 .79277 .38223 Mtetra
.79277 .38223 .79772 .38898 .80927 .3853 .80434 .37852 Mtetra
.80434 .37852 .80927 .3853 .82086 .3816 .81596 .3748 Mtetra
.81596 .3748 .82086 .3816 .83249 .37789 .82763 .37106 Mtetra
.82763 .37106 .83249 .37789 .84417 .37417 .83935 .36731 Mtetra
.83935 .36731 .84417 .37417 .8559 .37043 .85111 .36354 Mtetra
.85111 .36354 .8559 .37043 .86768 .36667 .86292 .35975 Mtetra
.603 .709 .919 r
.23275 .5531 .23906 .55943 .24845 .55723 .24213 .55129 Mtetra
.626 .731 .923 r
.24213 .55129 .24845 .55723 .25789 .55495 .25159 .54895 Mtetra
.611 .725 .926 r
.25159 .54895 .25789 .55495 .26728 .55387 .26107 .54689 Mtetra
0 0 .472 r
.26107 .54689 .26728 .55387 .27739 .54356 .2697 .55656 Mtetra
.652 .816 .384 r
.2697 .55656 .27739 .54356 .28673 .54405 .28052 .53758 Mtetra
.603 .707 .918 r
.28052 .53758 .28673 .54405 .29632 .54169 .29009 .53572 Mtetra
.635 .736 .921 r
.29009 .53572 .29632 .54169 .30597 .53903 .29975 .53313 Mtetra
.64 .74 .921 r
.29975 .53313 .30597 .53903 .31565 .53633 .30946 .5304 Mtetra
.637 .739 .922 r
.30946 .5304 .31565 .53633 .32536 .53385 .3192 .52774 Mtetra
.61 .725 .927 r
.3192 .52774 .32536 .53385 .33499 .53351 .32894 .52566 Mtetra
.911 .717 .627 r
.32894 .52566 .33499 .53351 .3452 .52336 .34093 .48394 Mtetra
0 0 .482 r
.34093 .48394 .3452 .52336 .35494 .52234 .34885 .51596 Mtetra
.621 .721 .918 r
.34885 .51596 .35494 .52234 .3648 .51966 .35871 .51365 Mtetra
.644 .742 .92 r
.35871 .51365 .3648 .51966 .37472 .51668 .36865 .51075 Mtetra
.651 .747 .92 r
.36865 .51075 .37472 .51668 .38468 .51359 .37863 .50768 Mtetra
.654 .75 .92 r
.37863 .50768 .38468 .51359 .39468 .51041 .38865 .50451 Mtetra
.657 .752 .92 r
.38865 .50451 .39468 .51041 .40472 .50718 .39872 .50128 Mtetra
.658 .753 .92 r
.39872 .50128 .40472 .50718 .4148 .50391 .40882 .498 Mtetra
.659 .754 .92 r
.40882 .498 .4148 .50391 .42491 .50061 .41896 .49469 Mtetra
.41896 .49469 .42491 .50061 .43507 .4973 .42913 .49135 Mtetra
.42913 .49135 .43507 .4973 .44526 .49399 .43935 .48801 Mtetra
.43935 .48801 .44526 .49399 .45549 .49066 .4496 .48466 Mtetra
.658 .753 .92 r
.4496 .48466 .45549 .49066 .46576 .48733 .4599 .4813 Mtetra
.4599 .4813 .46576 .48733 .47606 .484 .47023 .47794 Mtetra
.47023 .47794 .47606 .484 .4864 .48065 .4806 .47457 Mtetra
.4806 .47457 .4864 .48065 .49679 .4773 .491 .4712 Mtetra
.491 .4712 .49679 .4773 .50721 .47394 .50145 .46781 Mtetra
.50145 .46781 .50721 .47394 .51767 .47057 .51194 .46441 Mtetra
.51194 .46441 .51767 .47057 .52817 .46718 .52247 .461 Mtetra
.657 .753 .92 r
.52247 .461 .52817 .46718 .53871 .46379 .53304 .45758 Mtetra
.53304 .45758 .53871 .46379 .5493 .46038 .54364 .45415 Mtetra
.657 .752 .92 r
.54364 .45415 .5493 .46038 .55992 .45696 .55429 .45071 Mtetra
.55429 .45071 .55992 .45696 .57058 .45353 .56498 .44726 Mtetra
.56498 .44726 .57058 .45353 .58128 .45009 .57572 .44379 Mtetra
.57572 .44379 .58128 .45009 .59203 .44664 .58649 .44031 Mtetra
.58649 .44031 .59203 .44664 .60282 .44317 .5973 .43682 Mtetra
.5973 .43682 .60282 .44317 .61364 .43969 .60816 .43332 Mtetra
.60816 .43332 .61364 .43969 .62451 .4362 .61906 .4298 Mtetra
.61906 .4298 .62451 .4362 .63543 .4327 .63 .42627 Mtetra
.63 .42627 .63543 .4327 .64638 .42918 .64098 .42273 Mtetra
.64098 .42273 .64638 .42918 .65738 .42565 .65201 .41917 Mtetra
.65201 .41917 .65738 .42565 .66842 .42211 .66308 .4156 Mtetra
.66308 .4156 .66842 .42211 .6795 .41855 .67419 .41202 Mtetra
.67419 .41202 .6795 .41855 .69063 .41498 .68535 .40842 Mtetra
.68535 .40842 .69063 .41498 .7018 .4114 .69655 .40481 Mtetra
.69655 .40481 .7018 .4114 .71301 .4078 .70779 .40119 Mtetra
.70779 .40119 .71301 .4078 .72427 .40419 .71908 .39755 Mtetra
.71908 .39755 .72427 .40419 .73557 .40057 .73042 .3939 Mtetra
.73042 .3939 .73557 .40057 .74692 .39693 .7418 .39024 Mtetra
.7418 .39024 .74692 .39693 .75831 .39327 .75322 .38656 Mtetra
.75322 .38656 .75831 .39327 .76975 .38961 .76469 .38286 Mtetra
.76469 .38286 .76975 .38961 .78124 .38593 .77621 .37915 Mtetra
.77621 .37915 .78124 .38593 .79277 .38223 .78777 .37543 Mtetra
.78777 .37543 .79277 .38223 .80434 .37852 .79938 .37169 Mtetra
.79938 .37169 .80434 .37852 .81596 .3748 .81104 .36794 Mtetra
.81104 .36794 .81596 .3748 .82763 .37106 .82274 .36417 Mtetra
.82274 .36417 .82763 .37106 .83935 .36731 .83449 .36039 Mtetra
.83449 .36039 .83935 .36731 .85111 .36354 .84629 .3566 Mtetra
.84629 .3566 .85111 .36354 .86292 .35975 .85813 .35278 Mtetra
.525 .635 .901 r
.22652 .54534 .23275 .5531 .24213 .55129 .23577 .54521 Mtetra
.621 .726 .922 r
.23577 .54521 .24213 .55129 .25159 .54895 .24524 .54296 Mtetra
.624 .731 .924 r
.24524 .54296 .25159 .54895 .26107 .54689 .25476 .54063 Mtetra
.562 .701 .934 r
.25476 .54063 .26107 .54689 .2697 .55656 .26422 .53951 Mtetra
.719 .584 .704 r
.26422 .53951 .2697 .55656 .28052 .53758 .27441 .52912 Mtetra
.501 .605 .889 r
.27441 .52912 .28052 .53758 .29009 .53572 .28383 .52957 Mtetra
.626 .728 .92 r
.28383 .52957 .29009 .53572 .29975 .53313 .29349 .52716 Mtetra
.639 .739 .921 r
.29349 .52716 .29975 .53313 .30946 .5304 .30322 .52444 Mtetra
.639 .74 .922 r
.30322 .52444 .30946 .5304 .3192 .52774 .31298 .5217 Mtetra
.629 .735 .924 r
.31298 .5217 .3192 .52774 .32894 .52566 .32277 .51917 Mtetra
.518 .679 .938 r
.32277 .51917 .32894 .52566 .34093 .48394 .33248 .51879 Mtetra
.384 .112 .372 r
.33248 .51879 .34093 .48394 .34885 .51596 .34277 .50854 Mtetra
.567 .669 .907 r
.34277 .50854 .34885 .51596 .35871 .51365 .35259 .50748 Mtetra
.637 .736 .92 r
.35259 .50748 .35871 .51365 .36865 .51075 .36254 .50474 Mtetra
.648 .745 .92 r
.36254 .50474 .36865 .51075 .37863 .50768 .37254 .50171 Mtetra
.653 .749 .92 r
.37254 .50171 .37863 .50768 .38865 .50451 .38258 .49856 Mtetra
.656 .751 .92 r
.38258 .49856 .38865 .50451 .39872 .50128 .39267 .49533 Mtetra
.657 .752 .92 r
.39267 .49533 .39872 .50128 .40882 .498 .40279 .49204 Mtetra
.658 .753 .92 r
.40279 .49204 .40882 .498 .41896 .49469 .41296 .48871 Mtetra
.659 .754 .92 r
.41296 .48871 .41896 .49469 .42913 .49135 .42316 .48536 Mtetra
.42316 .48536 .42913 .49135 .43935 .48801 .4334 .48199 Mtetra
.4334 .48199 .43935 .48801 .4496 .48466 .44368 .47862 Mtetra
.659 .753 .92 r
.44368 .47862 .4496 .48466 .4599 .4813 .454 .47524 Mtetra
.658 .753 .92 r
.454 .47524 .4599 .4813 .47023 .47794 .46435 .47185 Mtetra
.46435 .47185 .47023 .47794 .4806 .47457 .47475 .46845 Mtetra
.47475 .46845 .4806 .47457 .491 .4712 .48518 .46505 Mtetra
.48518 .46505 .491 .4712 .50145 .46781 .49566 .46164 Mtetra
.49566 .46164 .50145 .46781 .51194 .46441 .50617 .45821 Mtetra
.50617 .45821 .51194 .46441 .52247 .461 .51672 .45478 Mtetra
.657 .753 .92 r
.51672 .45478 .52247 .461 .53304 .45758 .52732 .45134 Mtetra
.52732 .45134 .53304 .45758 .54364 .45415 .53795 .44788 Mtetra
.53795 .44788 .54364 .45415 .55429 .45071 .54863 .44441 Mtetra
.657 .752 .92 r
.54863 .44441 .55429 .45071 .56498 .44726 .55935 .44093 Mtetra
.55935 .44093 .56498 .44726 .57572 .44379 .57011 .43744 Mtetra
.57011 .43744 .57572 .44379 .58649 .44031 .58091 .43394 Mtetra
.58091 .43394 .58649 .44031 .5973 .43682 .59175 .43042 Mtetra
.59175 .43042 .5973 .43682 .60816 .43332 .60263 .42689 Mtetra
.60263 .42689 .60816 .43332 .61906 .4298 .61356 .42335 Mtetra
.61356 .42335 .61906 .4298 .63 .42627 .62453 .41979 Mtetra
.62453 .41979 .63 .42627 .64098 .42273 .63554 .41622 Mtetra
.63554 .41622 .64098 .42273 .65201 .41917 .6466 .41264 Mtetra
.6466 .41264 .65201 .41917 .66308 .4156 .6577 .40905 Mtetra
.6577 .40905 .66308 .4156 .67419 .41202 .66884 .40544 Mtetra
.66884 .40544 .67419 .41202 .68535 .40842 .68003 .40182 Mtetra
.68003 .40182 .68535 .40842 .69655 .40481 .69126 .39818 Mtetra
.69126 .39818 .69655 .40481 .70779 .40119 .70254 .39453 Mtetra
.70254 .39453 .70779 .40119 .71908 .39755 .71386 .39086 Mtetra
.71386 .39086 .71908 .39755 .73042 .3939 .72522 .38719 Mtetra
.72522 .38719 .73042 .3939 .7418 .39024 .73664 .38349 Mtetra
.73664 .38349 .7418 .39024 .75322 .38656 .74809 .37979 Mtetra
.74809 .37979 .75322 .38656 .76469 .38286 .7596 .37607 Mtetra
.7596 .37607 .76469 .38286 .77621 .37915 .77114 .37233 Mtetra
.77114 .37233 .77621 .37915 .78777 .37543 .78274 .36858 Mtetra
.78274 .36858 .78777 .37543 .79938 .37169 .79438 .36481 Mtetra
.79438 .36481 .79938 .37169 .81104 .36794 .80607 .36103 Mtetra
.80607 .36103 .81104 .36794 .82274 .36417 .81781 .35724 Mtetra
.81781 .35724 .82274 .36417 .83449 .36039 .82959 .35343 Mtetra
.82959 .35343 .83449 .36039 .84629 .3566 .84142 .3496 Mtetra
.84142 .3496 .84629 .3566 .85813 .35278 .8533 .34576 Mtetra
0 0 0 r
.21636 .58058 .22652 .54534 .23577 .54521 .2294 .53878 Mtetra
.602 .709 .919 r
.2294 .53878 .23577 .54521 .24524 .54296 .23885 .53693 Mtetra
.626 .731 .923 r
.23885 .53693 .24524 .54296 .25476 .54063 .24839 .53453 Mtetra
.611 .725 .926 r
.24839 .53453 .25476 .54063 .26422 .53951 .25794 .53243 Mtetra
0 0 .48 r
.25794 .53243 .26422 .53951 .27441 .52912 .26663 .5421 Mtetra
.661 .823 .393 r
.26663 .5421 .27441 .52912 .28383 .52957 .27755 .52299 Mtetra
.603 .708 .918 r
.27755 .52299 .28383 .52957 .29349 .52716 .2872 .52109 Mtetra
.635 .736 .921 r
.2872 .52109 .29349 .52716 .30322 .52444 .29694 .51844 Mtetra
.64 .74 .921 r
.29694 .51844 .30322 .52444 .31298 .5217 .30672 .51566 Mtetra
.637 .739 .922 r
.30672 .51566 .31298 .5217 .32277 .51917 .31654 .51295 Mtetra
.61 .725 .927 r
.31654 .51295 .32277 .51917 .33248 .51879 .32637 .51082 Mtetra
.912 .718 .626 r
.32637 .51082 .33248 .51879 .34277 .50854 .33849 .46889 Mtetra
0 0 .479 r
.33849 .46889 .34277 .50854 .35259 .50748 .34644 .501 Mtetra
.621 .721 .918 r
.34644 .501 .35259 .50748 .36254 .50474 .35639 .49863 Mtetra
.644 .742 .92 r
.35639 .49863 .36254 .50474 .37254 .50171 .36641 .49568 Mtetra
.651 .747 .92 r
.36641 .49568 .37254 .50171 .38258 .49856 .37647 .49255 Mtetra
.654 .75 .92 r
.37647 .49255 .38258 .49856 .39267 .49533 .38658 .48933 Mtetra
.657 .752 .92 r
.38658 .48933 .39267 .49533 .40279 .49204 .39673 .48604 Mtetra
.658 .753 .92 r
.39673 .48604 .40279 .49204 .41296 .48871 .40692 .4827 Mtetra
.659 .754 .92 r
.40692 .4827 .41296 .48871 .42316 .48536 .41714 .47933 Mtetra
.41714 .47933 .42316 .48536 .4334 .48199 .42741 .47594 Mtetra
.42741 .47594 .4334 .48199 .44368 .47862 .43771 .47253 Mtetra
.43771 .47253 .44368 .47862 .454 .47524 .44805 .46912 Mtetra
.658 .753 .92 r
.44805 .46912 .454 .47524 .46435 .47185 .45844 .46571 Mtetra
.45844 .46571 .46435 .47185 .47475 .46845 .46886 .46229 Mtetra
.46886 .46229 .47475 .46845 .48518 .46505 .47932 .45886 Mtetra
.47932 .45886 .48518 .46505 .49566 .46164 .48982 .45542 Mtetra
.48982 .45542 .49566 .46164 .50617 .45821 .50036 .45197 Mtetra
.50036 .45197 .50617 .45821 .51672 .45478 .51094 .44851 Mtetra
.51094 .44851 .51672 .45478 .52732 .45134 .52156 .44504 Mtetra
.657 .753 .92 r
.52156 .44504 .52732 .45134 .53795 .44788 .53222 .44156 Mtetra
.53222 .44156 .53795 .44788 .54863 .44441 .54293 .43807 Mtetra
.657 .752 .92 r
.54293 .43807 .54863 .44441 .55935 .44093 .55367 .43456 Mtetra
.55367 .43456 .55935 .44093 .57011 .43744 .56446 .43105 Mtetra
.56446 .43105 .57011 .43744 .58091 .43394 .57529 .42752 Mtetra
.57529 .42752 .58091 .43394 .59175 .43042 .58616 .42397 Mtetra
.58616 .42397 .59175 .43042 .60263 .42689 .59707 .42042 Mtetra
.59707 .42042 .60263 .42689 .61356 .42335 .60803 .41685 Mtetra
.60803 .41685 .61356 .42335 .62453 .41979 .61902 .41327 Mtetra
.61902 .41327 .62453 .41979 .63554 .41622 .63007 .40967 Mtetra
.63007 .40967 .63554 .41622 .6466 .41264 .64115 .40607 Mtetra
.64115 .40607 .6466 .41264 .6577 .40905 .65228 .40244 Mtetra
.65228 .40244 .6577 .40905 .66884 .40544 .66346 .39881 Mtetra
.66346 .39881 .66884 .40544 .68003 .40182 .67467 .39516 Mtetra
.67467 .39516 .68003 .40182 .69126 .39818 .68594 .3915 Mtetra
.68594 .3915 .69126 .39818 .70254 .39453 .69724 .38782 Mtetra
.69724 .38782 .70254 .39453 .71386 .39086 .70859 .38413 Mtetra
.70859 .38413 .71386 .39086 .72522 .38719 .71999 .38042 Mtetra
.71999 .38042 .72522 .38719 .73664 .38349 .73144 .3767 Mtetra
.73144 .3767 .73664 .38349 .74809 .37979 .74292 .37297 Mtetra
.74292 .37297 .74809 .37979 .7596 .37607 .75446 .36922 Mtetra
.75446 .36922 .7596 .37607 .77114 .37233 .76604 .36545 Mtetra
.76604 .36545 .77114 .37233 .78274 .36858 .77767 .36168 Mtetra
.77767 .36168 .78274 .36858 .79438 .36481 .78935 .35788 Mtetra
.78935 .35788 .79438 .36481 .80607 .36103 .80107 .35407 Mtetra
.80107 .35407 .80607 .36103 .81781 .35724 .81284 .35025 Mtetra
.81284 .35025 .81781 .35724 .82959 .35343 .82466 .34641 Mtetra
.82466 .34641 .82959 .35343 .84142 .3496 .83652 .34256 Mtetra
.83652 .34256 .84142 .3496 .8533 .34576 .84844 .33869 Mtetra
.636 .459 .626 r
.21294 .54082 .21636 .58058 .2294 .53878 .22311 .53092 Mtetra
.525 .635 .901 r
.22311 .53092 .2294 .53878 .23885 .53693 .23242 .53075 Mtetra
.621 .726 .922 r
.23242 .53075 .23885 .53693 .24839 .53453 .24197 .52845 Mtetra
.624 .731 .924 r
.24197 .52845 .24839 .53453 .25794 .53243 .25156 .52607 Mtetra
.562 .701 .934 r
.25156 .52607 .25794 .53243 .26663 .5421 .2611 .5249 Mtetra
.719 .585 .704 r
.2611 .5249 .26663 .5421 .27755 .52299 .27139 .51442 Mtetra
.5 .605 .889 r
.27139 .51442 .27755 .52299 .2872 .52109 .28087 .51484 Mtetra
.626 .728 .92 r
.28087 .51484 .2872 .52109 .29694 .51844 .29061 .51238 Mtetra
.639 .739 .921 r
.29061 .51238 .29694 .51844 .30672 .51566 .30042 .50961 Mtetra
.639 .74 .922 r
.30042 .50961 .30672 .51566 .31654 .51295 .31026 .5068 Mtetra
.629 .735 .924 r
.31026 .5068 .31654 .51295 .32637 .51082 .32013 .50422 Mtetra
.518 .679 .938 r
.32013 .50422 .32637 .51082 .33849 .46889 .32992 .5038 Mtetra
.378 .104 .366 r
.32992 .5038 .33849 .46889 .34644 .501 .34031 .49347 Mtetra
.567 .669 .907 r
.34031 .49347 .34644 .501 .35639 .49863 .3502 .49236 Mtetra
.637 .736 .92 r
.3502 .49236 .35639 .49863 .36641 .49568 .36024 .48956 Mtetra
.648 .745 .92 r
.36024 .48956 .36641 .49568 .37647 .49255 .37032 .48648 Mtetra
.653 .749 .92 r
.37032 .48648 .37647 .49255 .38658 .48933 .38045 .48327 Mtetra
.656 .751 .92 r
.38045 .48327 .38658 .48933 .39673 .48604 .39062 .47998 Mtetra
.657 .752 .92 r
.39062 .47998 .39673 .48604 .40692 .4827 .40083 .47663 Mtetra
.658 .753 .92 r
.40083 .47663 .40692 .4827 .41714 .47933 .41108 .47325 Mtetra
.659 .754 .92 r
.41108 .47325 .41714 .47933 .42741 .47594 .42137 .46984 Mtetra
.42137 .46984 .42741 .47594 .43771 .47253 .4317 .46641 Mtetra
.4317 .46641 .43771 .47253 .44805 .46912 .44207 .46297 Mtetra
.659 .753 .92 r
.44207 .46297 .44805 .46912 .45844 .46571 .45248 .45953 Mtetra
.658 .753 .92 r
.45248 .45953 .45844 .46571 .46886 .46229 .46292 .45608 Mtetra
.46292 .45608 .46886 .46229 .47932 .45886 .47341 .45262 Mtetra
.47341 .45262 .47932 .45886 .48982 .45542 .48394 .44916 Mtetra
.48394 .44916 .48982 .45542 .50036 .45197 .4945 .44569 Mtetra
.4945 .44569 .50036 .45197 .51094 .44851 .50511 .4422 Mtetra
.50511 .4422 .51094 .44851 .52156 .44504 .51576 .43871 Mtetra
.657 .753 .92 r
.51576 .43871 .52156 .44504 .53222 .44156 .52645 .4352 Mtetra
.52645 .4352 .53222 .44156 .54293 .43807 .53718 .43168 Mtetra
.53718 .43168 .54293 .43807 .55367 .43456 .54795 .42815 Mtetra
.657 .752 .92 r
.54795 .42815 .55367 .43456 .56446 .43105 .55877 .42461 Mtetra
.55877 .42461 .56446 .43105 .57529 .42752 .56962 .42105 Mtetra
.56962 .42105 .57529 .42752 .58616 .42397 .58052 .41748 Mtetra
.58052 .41748 .58616 .42397 .59707 .42042 .59146 .4139 Mtetra
.59146 .4139 .59707 .42042 .60803 .41685 .60245 .41031 Mtetra
.60245 .41031 .60803 .41685 .61902 .41327 .61348 .4067 Mtetra
.61348 .4067 .61902 .41327 .63007 .40967 .62455 .40308 Mtetra
.62455 .40308 .63007 .40967 .64115 .40607 .63566 .39944 Mtetra
.63566 .39944 .64115 .40607 .65228 .40244 .64682 .39579 Mtetra
.64682 .39579 .65228 .40244 .66346 .39881 .65803 .39213 Mtetra
.65803 .39213 .66346 .39881 .67467 .39516 .66928 .38845 Mtetra
.66928 .38845 .67467 .39516 .68594 .3915 .68057 .38476 Mtetra
.68057 .38476 .68594 .3915 .69724 .38782 .69191 .38106 Mtetra
.69191 .38106 .69724 .38782 .70859 .38413 .70329 .37734 Mtetra
.70329 .37734 .70859 .38413 .71999 .38042 .71472 .37361 Mtetra
.71472 .37361 .71999 .38042 .73144 .3767 .7262 .36986 Mtetra
.7262 .36986 .73144 .3767 .74292 .37297 .73772 .3661 Mtetra
.73772 .3661 .74292 .37297 .75446 .36922 .74929 .36232 Mtetra
.74929 .36232 .75446 .36922 .76604 .36545 .7609 .35853 Mtetra
.7609 .35853 .76604 .36545 .77767 .36168 .77256 .35472 Mtetra
.77256 .35472 .77767 .36168 .78935 .35788 .78427 .3509 Mtetra
.78427 .3509 .78935 .35788 .80107 .35407 .79603 .34706 Mtetra
.79603 .34706 .80107 .35407 .81284 .35025 .80783 .34321 Mtetra
.80783 .34321 .81284 .35025 .82466 .34641 .81969 .33934 Mtetra
.81969 .33934 .82466 .34641 .83652 .34256 .83159 .33546 Mtetra
.83159 .33546 .83652 .34256 .84844 .33869 .84354 .33156 Mtetra
.945 .594 .313 r
.20654 .53342 .21294 .54082 .22311 .53092 .21281 .56624 Mtetra
0 0 0 r
.21281 .56624 .22311 .53092 .23242 .53075 .22599 .52422 Mtetra
.602 .709 .919 r
.22599 .52422 .23242 .53075 .24197 .52845 .23551 .52231 Mtetra
.626 .731 .923 r
.23551 .52231 .24197 .52845 .25156 .52607 .24513 .51987 Mtetra
.611 .725 .926 r
.24513 .51987 .25156 .52607 .2611 .5249 .25475 .51772 Mtetra
0 0 .487 r
.25475 .51772 .2611 .5249 .27139 .51442 .2635 .52738 Mtetra
.67 .83 .403 r
.2635 .52738 .27139 .51442 .28087 .51484 .27453 .50816 Mtetra
.603 .708 .918 r
.27453 .50816 .28087 .51484 .29061 .51238 .28425 .5062 Mtetra
.635 .736 .921 r
.28425 .5062 .29061 .51238 .30042 .50961 .29407 .5035 Mtetra
.64 .74 .921 r
.29407 .5035 .30042 .50961 .31026 .5068 .30394 .50067 Mtetra
.637 .739 .922 r
.30394 .50067 .31026 .5068 .32013 .50422 .31384 .4979 Mtetra
.61 .725 .927 r
.31384 .4979 .32013 .50422 .32992 .5038 .32375 .49572 Mtetra
.913 .719 .626 r
.32375 .49572 .32992 .5038 .34031 .49347 .336 .45356 Mtetra
0 0 .476 r
.336 .45356 .34031 .49347 .3502 .49236 .34399 .48577 Mtetra
.621 .721 .918 r
.34399 .48577 .3502 .49236 .36024 .48956 .35402 .48334 Mtetra
.644 .742 .92 r
.35402 .48334 .36024 .48956 .37032 .48648 .36413 .48034 Mtetra
.651 .747 .92 r
.36413 .48034 .37032 .48648 .38045 .48327 .37428 .47715 Mtetra
.654 .75 .92 r
.37428 .47715 .38045 .48327 .39062 .47998 .38447 .47387 Mtetra
.657 .752 .92 r
.38447 .47387 .39062 .47998 .40083 .47663 .3947 .47052 Mtetra
.658 .753 .92 r
.3947 .47052 .40083 .47663 .41108 .47325 .40498 .46712 Mtetra
.659 .754 .92 r
.40498 .46712 .41108 .47325 .42137 .46984 .41529 .46369 Mtetra
.41529 .46369 .42137 .46984 .4317 .46641 .42565 .46024 Mtetra
.42565 .46024 .4317 .46641 .44207 .46297 .43604 .45678 Mtetra
.43604 .45678 .44207 .46297 .45248 .45953 .44648 .45331 Mtetra
.658 .753 .92 r
.44648 .45331 .45248 .45953 .46292 .45608 .45695 .44983 Mtetra
.45695 .44983 .46292 .45608 .47341 .45262 .46746 .44635 Mtetra
.46746 .44635 .47341 .45262 .48394 .44916 .47801 .44286 Mtetra
.47801 .44286 .48394 .44916 .4945 .44569 .48861 .43936 Mtetra
.48861 .43936 .4945 .44569 .50511 .4422 .49924 .43585 Mtetra
.49924 .43585 .50511 .4422 .51576 .43871 .50992 .43232 Mtetra
.50992 .43232 .51576 .43871 .52645 .4352 .52063 .42879 Mtetra
.657 .753 .92 r
.52063 .42879 .52645 .4352 .53718 .43168 .53139 .42525 Mtetra
.53139 .42525 .53718 .43168 .54795 .42815 .54219 .42169 Mtetra
.657 .752 .92 r
.54219 .42169 .54795 .42815 .55877 .42461 .55303 .41812 Mtetra
.55303 .41812 .55877 .42461 .56962 .42105 .56392 .41454 Mtetra
.56392 .41454 .56962 .42105 .58052 .41748 .57485 .41094 Mtetra
.57485 .41094 .58052 .41748 .59146 .4139 .58582 .40734 Mtetra
.58582 .40734 .59146 .4139 .60245 .41031 .59683 .40371 Mtetra
.59683 .40371 .60245 .41031 .61348 .4067 .60789 .40008 Mtetra
.60789 .40008 .61348 .4067 .62455 .40308 .61899 .39643 Mtetra
.61899 .39643 .62455 .40308 .63566 .39944 .63014 .39277 Mtetra
.63014 .39277 .63566 .39944 .64682 .39579 .64133 .38909 Mtetra
.64133 .38909 .64682 .39579 .65803 .39213 .65256 .3854 Mtetra
.65256 .3854 .65803 .39213 .66928 .38845 .66384 .3817 Mtetra
.66384 .3817 .66928 .38845 .68057 .38476 .67516 .37798 Mtetra
.67516 .37798 .68057 .38476 .69191 .38106 .68653 .37425 Mtetra
.68653 .37425 .69191 .38106 .70329 .37734 .69795 .3705 Mtetra
.69795 .3705 .70329 .37734 .71472 .37361 .70941 .36674 Mtetra
.70941 .36674 .71472 .37361 .7262 .36986 .72092 .36297 Mtetra
.72092 .36297 .7262 .36986 .73772 .3661 .73247 .35918 Mtetra
.73247 .35918 .73772 .3661 .74929 .36232 .74407 .35537 Mtetra
.74407 .35537 .74929 .36232 .7609 .35853 .75572 .35155 Mtetra
.75572 .35155 .7609 .35853 .77256 .35472 .76742 .34771 Mtetra
.76742 .34771 .77256 .35472 .78427 .3509 .77916 .34386 Mtetra
.77916 .34386 .78427 .3509 .79603 .34706 .79095 .34 Mtetra
.79095 .34 .79603 .34706 .80783 .34321 .80279 .33612 Mtetra
.80279 .33612 .80783 .34321 .81969 .33934 .81468 .33222 Mtetra
.81468 .33222 .81969 .33934 .83159 .33546 .82661 .3283 Mtetra
.82661 .3283 .83159 .33546 .84354 .33156 .8386 .32438 Mtetra
.535 .688 .937 r
.20002 .52695 .20654 .53342 .21281 .56624 .20938 .52623 Mtetra
.636 .457 .625 r
.20938 .52623 .21281 .56624 .22599 .52422 .21963 .51625 Mtetra
.525 .635 .901 r
.21963 .51625 .22599 .52422 .23551 .52231 .22902 .51603 Mtetra
.621 .726 .922 r
.22902 .51603 .23551 .52231 .24513 .51987 .23864 .51368 Mtetra
.624 .731 .924 r
.23864 .51368 .24513 .51987 .25475 .51772 .24831 .51125 Mtetra
.563 .701 .934 r
.24831 .51125 .25475 .51772 .2635 .52738 .25792 .51003 Mtetra
.719 .585 .704 r
.25792 .51003 .2635 .52738 .27453 .50816 .2683 .49947 Mtetra
.5 .605 .889 r
.2683 .49947 .27453 .50816 .28425 .5062 .27786 .49985 Mtetra
.626 .728 .92 r
.27786 .49985 .28425 .5062 .29407 .5035 .28769 .49733 Mtetra
.639 .739 .921 r
.28769 .49733 .29407 .5035 .30394 .50067 .29757 .49451 Mtetra
.639 .74 .922 r
.29757 .49451 .30394 .50067 .31384 .4979 .3075 .49165 Mtetra
.629 .735 .924 r
.3075 .49165 .31384 .4979 .32375 .49572 .31745 .48901 Mtetra
.519 .679 .938 r
.31745 .48901 .32375 .49572 .336 .45356 .32731 .48854 Mtetra
.372 .096 .359 r
.32731 .48854 .336 .45356 .34399 .48577 .33779 .47813 Mtetra
.567 .669 .907 r
.33779 .47813 .34399 .48577 .35402 .48334 .34777 .47696 Mtetra
.637 .736 .92 r
.34777 .47696 .35402 .48334 .36413 .48034 .35789 .47411 Mtetra
.648 .745 .92 r
.35789 .47411 .36413 .48034 .37428 .47715 .36806 .47097 Mtetra
.653 .749 .92 r
.36806 .47097 .37428 .47715 .38447 .47387 .37828 .4677 Mtetra
.656 .751 .92 r
.37828 .4677 .38447 .47387 .3947 .47052 .38853 .46435 Mtetra
.657 .752 .92 r
.38853 .46435 .3947 .47052 .40498 .46712 .39883 .46095 Mtetra
.658 .753 .92 r
.39883 .46095 .40498 .46712 .41529 .46369 .40917 .4575 Mtetra
.659 .754 .92 r
.40917 .4575 .41529 .46369 .42565 .46024 .41955 .45403 Mtetra
.41955 .45403 .42565 .46024 .43604 .45678 .42997 .45054 Mtetra
.42997 .45054 .43604 .45678 .44648 .45331 .44043 .44704 Mtetra
.659 .753 .92 r
.44043 .44704 .44648 .45331 .45695 .44983 .45093 .44354 Mtetra
.658 .753 .92 r
.45093 .44354 .45695 .44983 .46746 .44635 .46147 .44003 Mtetra
.46147 .44003 .46746 .44635 .47801 .44286 .47205 .43651 Mtetra
.47205 .43651 .47801 .44286 .48861 .43936 .48267 .43298 Mtetra
.48267 .43298 .48861 .43936 .49924 .43585 .49333 .42944 Mtetra
.49333 .42944 .49924 .43585 .50992 .43232 .50403 .4259 Mtetra
.50403 .4259 .50992 .43232 .52063 .42879 .51478 .42234 Mtetra
.657 .753 .92 r
.51478 .42234 .52063 .42879 .53139 .42525 .52556 .41877 Mtetra
.52556 .41877 .53139 .42525 .54219 .42169 .53639 .41518 Mtetra
.53639 .41518 .54219 .42169 .55303 .41812 .54726 .41159 Mtetra
.657 .752 .92 r
.54726 .41159 .55303 .41812 .56392 .41454 .55818 .40798 Mtetra
.55818 .40798 .56392 .41454 .57485 .41094 .56913 .40436 Mtetra
.56913 .40436 .57485 .41094 .58582 .40734 .58013 .40072 Mtetra
.58013 .40072 .58582 .40734 .59683 .40371 .59117 .39707 Mtetra
.59117 .39707 .59683 .40371 .60789 .40008 .60226 .39341 Mtetra
.60226 .39341 .60789 .40008 .61899 .39643 .61339 .38974 Mtetra
.61339 .38974 .61899 .39643 .63014 .39277 .62457 .38605 Mtetra
.62457 .38605 .63014 .39277 .64133 .38909 .63579 .38234 Mtetra
.63579 .38234 .64133 .38909 .65256 .3854 .64705 .37863 Mtetra
.64705 .37863 .65256 .3854 .66384 .3817 .65836 .3749 Mtetra
.65836 .3749 .66384 .3817 .67516 .37798 .66972 .37115 Mtetra
.66972 .37115 .67516 .37798 .68653 .37425 .68112 .36739 Mtetra
.68112 .36739 .68653 .37425 .69795 .3705 .69257 .36362 Mtetra
.69257 .36362 .69795 .3705 .70941 .36674 .70406 .35983 Mtetra
.70406 .35983 .70941 .36674 .72092 .36297 .7156 .35602 Mtetra
.7156 .35602 .72092 .36297 .73247 .35918 .72719 .3522 Mtetra
.72719 .3522 .73247 .35918 .74407 .35537 .73882 .34837 Mtetra
.73882 .34837 .74407 .35537 .75572 .35155 .7505 .34452 Mtetra
.7505 .34452 .75572 .35155 .76742 .34771 .76223 .34065 Mtetra
.76223 .34065 .76742 .34771 .77916 .34386 .77401 .33677 Mtetra
.77401 .33677 .77916 .34386 .79095 .34 .78583 .33288 Mtetra
.78583 .33288 .79095 .34 .80279 .33612 .79771 .32897 Mtetra
.79771 .32897 .80279 .33612 .81468 .33222 .80963 .32504 Mtetra
.80963 .32504 .81468 .33222 .82661 .3283 .8216 .3211 Mtetra
.8216 .3211 .82661 .3283 .8386 .32438 .83362 .31714 Mtetra
.601 .719 .927 r
.19342 .52066 .20002 .52695 .20938 .52623 .20291 .51873 Mtetra
.945 .592 .308 r
.20291 .51873 .20938 .52623 .21963 .51625 .20918 .55164 Mtetra
0 0 0 r
.20918 .55164 .21963 .51625 .22902 .51603 .22251 .5094 Mtetra
.602 .709 .919 r
.22251 .5094 .22902 .51603 .23864 .51368 .23212 .50744 Mtetra
.626 .731 .923 r
.23212 .50744 .23864 .51368 .24831 .51125 .24181 .50494 Mtetra
.611 .725 .926 r
.24181 .50494 .24831 .51125 .25792 .51003 .25152 .50274 Mtetra
0 0 .495 r
.25152 .50274 .25792 .51003 .2683 .49947 .26032 .51241 Mtetra
.679 .837 .412 r
.26032 .51241 .2683 .49947 .27786 .49985 .27146 .49305 Mtetra
.603 .708 .918 r
.27146 .49305 .27786 .49985 .28769 .49733 .28126 .49105 Mtetra
.635 .736 .921 r
.28126 .49105 .28769 .49733 .29757 .49451 .29116 .4883 Mtetra
.64 .74 .921 r
.29116 .4883 .29757 .49451 .3075 .49165 .30111 .48541 Mtetra
.637 .739 .922 r
.30111 .48541 .3075 .49165 .31745 .48901 .31109 .48258 Mtetra
.61 .725 .927 r
.31109 .48258 .31745 .48901 .32731 .48854 .32108 .48035 Mtetra
.915 .719 .625 r
.32108 .48035 .32731 .48854 .33779 .47813 .33347 .43797 Mtetra
0 0 .472 r
.33347 .43797 .33779 .47813 .34777 .47696 .3415 .47026 Mtetra
.621 .721 .918 r
.3415 .47026 .34777 .47696 .35789 .47411 .35161 .46778 Mtetra
.644 .742 .92 r
.35161 .46778 .35789 .47411 .36806 .47097 .3618 .46472 Mtetra
.651 .747 .92 r
.3618 .46472 .36806 .47097 .37828 .4677 .37204 .46148 Mtetra
.654 .75 .92 r
.37204 .46148 .37828 .4677 .38853 .46435 .38232 .45813 Mtetra
.657 .752 .92 r
.38232 .45813 .38853 .46435 .39883 .46095 .39264 .45472 Mtetra
.658 .753 .92 r
.39264 .45472 .39883 .46095 .40917 .4575 .40301 .45126 Mtetra
.659 .754 .92 r
.40301 .45126 .40917 .4575 .41955 .45403 .41341 .44777 Mtetra
.41341 .44777 .41955 .45403 .42997 .45054 .42386 .44426 Mtetra
.42386 .44426 .42997 .45054 .44043 .44704 .43434 .44073 Mtetra
.43434 .44073 .44043 .44704 .45093 .44354 .44487 .4372 Mtetra
.658 .753 .92 r
.44487 .4372 .45093 .44354 .46147 .44003 .45543 .43366 Mtetra
.45543 .43366 .46147 .44003 .47205 .43651 .46604 .43012 Mtetra
.46604 .43012 .47205 .43651 .48267 .43298 .47669 .42656 Mtetra
.47669 .42656 .48267 .43298 .49333 .42944 .48737 .423 Mtetra
.48737 .423 .49333 .42944 .50403 .4259 .4981 .41942 Mtetra
.4981 .41942 .50403 .4259 .51478 .42234 .50888 .41584 Mtetra
.50888 .41584 .51478 .42234 .52556 .41877 .51969 .41224 Mtetra
.657 .753 .92 r
.51969 .41224 .52556 .41877 .53639 .41518 .53055 .40863 Mtetra
.53055 .40863 .53639 .41518 .54726 .41159 .54145 .40501 Mtetra
.657 .752 .92 r
.54145 .40501 .54726 .41159 .55818 .40798 .55239 .40137 Mtetra
.55239 .40137 .55818 .40798 .56913 .40436 .56337 .39772 Mtetra
.56337 .39772 .56913 .40436 .58013 .40072 .5744 .39406 Mtetra
.5744 .39406 .58013 .40072 .59117 .39707 .58547 .39038 Mtetra
.58547 .39038 .59117 .39707 .60226 .39341 .59659 .3867 Mtetra
.59659 .3867 .60226 .39341 .61339 .38974 .60775 .38299 Mtetra
.60775 .38299 .61339 .38974 .62457 .38605 .61896 .37928 Mtetra
.61896 .37928 .62457 .38605 .63579 .38234 .63021 .37555 Mtetra
.63021 .37555 .63579 .38234 .64705 .37863 .6415 .3718 Mtetra
.6415 .3718 .64705 .37863 .65836 .3749 .65285 .36804 Mtetra
.65285 .36804 .65836 .3749 .66972 .37115 .66423 .36427 Mtetra
.66423 .36427 .66972 .37115 .68112 .36739 .67566 .36048 Mtetra
.67566 .36048 .68112 .36739 .69257 .36362 .68714 .35668 Mtetra
.68714 .35668 .69257 .36362 .70406 .35983 .69867 .35286 Mtetra
.69867 .35286 .70406 .35983 .7156 .35602 .71024 .34902 Mtetra
.71024 .34902 .7156 .35602 .72719 .3522 .72186 .34518 Mtetra
.72186 .34518 .72719 .3522 .73882 .34837 .73353 .34131 Mtetra
.73353 .34131 .73882 .34837 .7505 .34452 .74524 .33743 Mtetra
.74524 .33743 .7505 .34452 .76223 .34065 .75701 .33354 Mtetra
.75701 .33354 .76223 .34065 .77401 .33677 .76882 .32963 Mtetra
.76882 .32963 .77401 .33677 .78583 .33288 .78068 .32571 Mtetra
.78068 .32571 .78583 .33288 .79771 .32897 .79258 .32176 Mtetra
.79258 .32176 .79771 .32897 .80963 .32504 .80454 .31781 Mtetra
.80454 .31781 .80963 .32504 .8216 .3211 .81655 .31383 Mtetra
.81655 .31383 .8216 .3211 .83362 .31714 .82861 .30984 Mtetra
.613 .724 .924 r
.18678 .51436 .19342 .52066 .20291 .51873 .19632 .51215 Mtetra
.535 .688 .937 r
.19632 .51215 .20291 .51873 .20918 .55164 .20575 .51138 Mtetra
.635 .456 .624 r
.20575 .51138 .20918 .55164 .22251 .5094 .2161 .50131 Mtetra
.524 .635 .901 r
.2161 .50131 .22251 .5094 .23212 .50744 .22556 .50106 Mtetra
.621 .726 .922 r
.22556 .50106 .23212 .50744 .24181 .50494 .23526 .49866 Mtetra
.624 .731 .924 r
.23526 .49866 .24181 .50494 .25152 .50274 .245 .49617 Mtetra
.563 .701 .934 r
.245 .49617 .25152 .50274 .26032 .51241 .25469 .49491 Mtetra
.72 .585 .703 r
.25469 .49491 .26032 .51241 .27146 .49305 .26517 .48425 Mtetra
.5 .605 .889 r
.26517 .48425 .27146 .49305 .28126 .49105 .2748 .48459 Mtetra
.626 .728 .92 r
.2748 .48459 .28126 .49105 .29116 .4883 .28471 .48202 Mtetra
.639 .739 .921 r
.28471 .48202 .29116 .4883 .30111 .48541 .29467 .47914 Mtetra
.639 .74 .922 r
.29467 .47914 .30111 .48541 .31109 .48258 .30468 .47622 Mtetra
.629 .735 .924 r
.30468 .47622 .31109 .48258 .32108 .48035 .31472 .47353 Mtetra
.519 .679 .938 r
.31472 .47353 .32108 .48035 .33347 .43797 .32466 .47301 Mtetra
.365 .087 .353 r
.32466 .47301 .33347 .43797 .3415 .47026 .33524 .46251 Mtetra
.567 .669 .907 r
.33524 .46251 .3415 .47026 .35161 .46778 .3453 .46129 Mtetra
.637 .736 .92 r
.3453 .46129 .35161 .46778 .3618 .46472 .3555 .45839 Mtetra
.648 .745 .92 r
.3555 .45839 .3618 .46472 .37204 .46148 .36576 .45518 Mtetra
.653 .749 .92 r
.36576 .45518 .37204 .46148 .38232 .45813 .37606 .45185 Mtetra
.656 .751 .92 r
.37606 .45185 .38232 .45813 .39264 .45472 .38641 .44845 Mtetra
.657 .752 .92 r
.38641 .44845 .39264 .45472 .40301 .45126 .3968 .44498 Mtetra
.658 .753 .92 r
.3968 .44498 .40301 .45126 .41341 .44777 .40723 .44147 Mtetra
.659 .754 .92 r
.40723 .44147 .41341 .44777 .42386 .44426 .4177 .43793 Mtetra
.4177 .43793 .42386 .44426 .43434 .44073 .42821 .43438 Mtetra
.42821 .43438 .43434 .44073 .44487 .4372 .43876 .43082 Mtetra
.659 .753 .92 r
.43876 .43082 .44487 .4372 .45543 .43366 .44935 .42725 Mtetra
.658 .753 .92 r
.44935 .42725 .45543 .43366 .46604 .43012 .45999 .42368 Mtetra
.45999 .42368 .46604 .43012 .47669 .42656 .47066 .4201 Mtetra
.47066 .4201 .47669 .42656 .48737 .423 .48138 .4165 Mtetra
.48138 .4165 .48737 .423 .4981 .41942 .49213 .4129 Mtetra
.49213 .4129 .4981 .41942 .50888 .41584 .50293 .40929 Mtetra
.50293 .40929 .50888 .41584 .51969 .41224 .51378 .40566 Mtetra
.657 .753 .92 r
.51378 .40566 .51969 .41224 .53055 .40863 .52466 .40203 Mtetra
.52466 .40203 .53055 .40863 .54145 .40501 .53559 .39838 Mtetra
.53559 .39838 .54145 .40501 .55239 .40137 .54656 .39471 Mtetra
.657 .752 .92 r
.54656 .39471 .55239 .40137 .56337 .39772 .55757 .39104 Mtetra
.55757 .39104 .56337 .39772 .5744 .39406 .56863 .38735 Mtetra
.56863 .38735 .5744 .39406 .58547 .39038 .57973 .38365 Mtetra
.57973 .38365 .58547 .39038 .59659 .3867 .59088 .37993 Mtetra
.59088 .37993 .59659 .3867 .60775 .38299 .60207 .3762 Mtetra
.60207 .3762 .60775 .38299 .61896 .37928 .61331 .37245 Mtetra
.61331 .37245 .61896 .37928 .63021 .37555 .62459 .3687 Mtetra
.62459 .3687 .63021 .37555 .6415 .3718 .63591 .36492 Mtetra
.63591 .36492 .6415 .3718 .65285 .36804 .64729 .36114 Mtetra
.64729 .36114 .65285 .36804 .66423 .36427 .6587 .35733 Mtetra
.6587 .35733 .66423 .36427 .67566 .36048 .67017 .35352 Mtetra
.67017 .35352 .67566 .36048 .68714 .35668 .68168 .34968 Mtetra
.68168 .34968 .68714 .35668 .69867 .35286 .69324 .34584 Mtetra
.69324 .34584 .69867 .35286 .71024 .34902 .70484 .34198 Mtetra
.70484 .34198 .71024 .34902 .72186 .34518 .7165 .3381 Mtetra
.7165 .3381 .72186 .34518 .73353 .34131 .7282 .3342 Mtetra
.7282 .3342 .73353 .34131 .74524 .33743 .73994 .3303 Mtetra
.73994 .3303 .74524 .33743 .75701 .33354 .75174 .32637 Mtetra
.75174 .32637 .75701 .33354 .76882 .32963 .76359 .32243 Mtetra
.76359 .32243 .76882 .32963 .78068 .32571 .77548 .31848 Mtetra
.77548 .31848 .78068 .32571 .79258 .32176 .78742 .31451 Mtetra
.78742 .31451 .79258 .32176 .80454 .31781 .79942 .31052 Mtetra
.79942 .31052 .80454 .31781 .81655 .31383 .81146 .30651 Mtetra
.81146 .30651 .81655 .31383 .82861 .30984 .82355 .30249 Mtetra
.61 .719 .923 r
.18011 .50791 .18678 .51436 .19632 .51215 .18965 .50575 Mtetra
.601 .719 .927 r
.18965 .50575 .19632 .51215 .20575 .51138 .19922 .50377 Mtetra
.944 .591 .303 r
.19922 .50377 .20575 .51138 .2161 .50131 .2055 .53679 Mtetra
0 0 0 r
.2055 .53679 .2161 .50131 .22556 .50106 .21898 .49432 Mtetra
.602 .709 .919 r
.21898 .49432 .22556 .50106 .23526 .49866 .22866 .49231 Mtetra
.626 .731 .923 r
.22866 .49231 .23526 .49866 .245 .49617 .23843 .48976 Mtetra
.611 .725 .926 r
.23843 .48976 .245 .49617 .25469 .49491 .24822 .4875 Mtetra
0 0 .502 r
.24822 .4875 .25469 .49491 .26517 .48425 .25708 .49717 Mtetra
.688 .844 .421 r
.25708 .49717 .26517 .48425 .2748 .48459 .26833 .47769 Mtetra
.603 .708 .918 r
.26833 .47769 .2748 .48459 .28471 .48202 .27821 .47563 Mtetra
.635 .736 .921 r
.27821 .47563 .28471 .48202 .29467 .47914 .28819 .47282 Mtetra
.64 .74 .921 r
.28819 .47282 .29467 .47914 .30468 .47622 .29823 .46987 Mtetra
.637 .739 .922 r
.29823 .46987 .30468 .47622 .31472 .47353 .30829 .46699 Mtetra
.61 .725 .927 r
.30829 .46699 .31472 .47353 .32466 .47301 .31836 .4647 Mtetra
.916 .72 .624 r
.31836 .4647 .32466 .47301 .33524 .46251 .33089 .4221 Mtetra
0 0 .469 r
.33089 .4221 .33524 .46251 .3453 .46129 .33896 .45448 Mtetra
.621 .721 .918 r
.33896 .45448 .3453 .46129 .3555 .45839 .34916 .45194 Mtetra
.644 .742 .92 r
.34916 .45194 .3555 .45839 .36576 .45518 .35944 .44882 Mtetra
.651 .747 .92 r
.35944 .44882 .36576 .45518 .37606 .45185 .36976 .44551 Mtetra
.654 .75 .92 r
.36976 .44551 .37606 .45185 .38641 .44845 .38013 .44211 Mtetra
.657 .752 .92 r
.38013 .44211 .38641 .44845 .3968 .44498 .39055 .43864 Mtetra
.658 .753 .92 r
.39055 .43864 .3968 .44498 .40723 .44147 .401 .43512 Mtetra
.659 .754 .92 r
.401 .43512 .40723 .44147 .4177 .43793 .4115 .43156 Mtetra
.4115 .43156 .4177 .43793 .42821 .43438 .42203 .42799 Mtetra
.42203 .42799 .42821 .43438 .43876 .43082 .43261 .4244 Mtetra
.43261 .4244 .43876 .43082 .44935 .42725 .44323 .4208 Mtetra
.658 .753 .92 r
.44323 .4208 .44935 .42725 .45999 .42368 .45389 .4172 Mtetra
.45389 .4172 .45999 .42368 .47066 .4201 .46459 .41358 Mtetra
.46459 .41358 .47066 .4201 .48138 .4165 .47533 .40996 Mtetra
.47533 .40996 .48138 .4165 .49213 .4129 .48612 .40633 Mtetra
.48612 .40633 .49213 .4129 .50293 .40929 .49695 .40269 Mtetra
.49695 .40269 .50293 .40929 .51378 .40566 .50782 .39904 Mtetra
.50782 .39904 .51378 .40566 .52466 .40203 .51873 .39538 Mtetra
.657 .753 .92 r
.51873 .39538 .52466 .40203 .53559 .39838 .52969 .3917 Mtetra
.52969 .3917 .53559 .39838 .54656 .39471 .54069 .38801 Mtetra
.657 .752 .92 r
.54069 .38801 .54656 .39471 .55757 .39104 .55173 .3843 Mtetra
.55173 .3843 .55757 .39104 .56863 .38735 .56282 .38059 Mtetra
.56282 .38059 .56863 .38735 .57973 .38365 .57395 .37686 Mtetra
.57395 .37686 .57973 .38365 .59088 .37993 .58512 .37311 Mtetra
.58512 .37311 .59088 .37993 .60207 .3762 .59635 .36935 Mtetra
.59635 .36935 .60207 .3762 .61331 .37245 .60761 .36558 Mtetra
.60761 .36558 .61331 .37245 .62459 .3687 .61892 .36179 Mtetra
.61892 .36179 .62459 .3687 .63591 .36492 .63028 .35799 Mtetra
.63028 .35799 .63591 .36492 .64729 .36114 .64168 .35418 Mtetra
.64168 .35418 .64729 .36114 .6587 .35733 .65313 .35035 Mtetra
.65313 .35035 .6587 .35733 .67017 .35352 .66463 .3465 Mtetra
.66463 .3465 .67017 .35352 .68168 .34968 .67617 .34264 Mtetra
.67617 .34264 .68168 .34968 .69324 .34584 .68777 .33876 Mtetra
.68777 .33876 .69324 .34584 .70484 .34198 .6994 .33487 Mtetra
.6994 .33487 .70484 .34198 .7165 .3381 .71109 .33096 Mtetra
.71109 .33096 .7165 .3381 .7282 .3342 .72282 .32704 Mtetra
.72282 .32704 .7282 .3342 .73994 .3303 .7346 .3231 Mtetra
.7346 .3231 .73994 .3303 .75174 .32637 .74644 .31915 Mtetra
.74644 .31915 .75174 .32637 .76359 .32243 .75832 .31518 Mtetra
.75832 .31518 .76359 .32243 .77548 .31848 .77024 .31119 Mtetra
.77024 .31119 .77548 .31848 .78742 .31451 .78222 .30719 Mtetra
.78222 .30719 .78742 .31451 .79942 .31052 .79425 .30317 Mtetra
.79425 .30317 .79942 .31052 .81146 .30651 .80633 .29914 Mtetra
.80633 .29914 .81146 .30651 .82355 .30249 .81846 .29509 Mtetra
.585 .696 .919 r
.17344 .50098 .18011 .50791 .18965 .50575 .18294 .49935 Mtetra
.613 .724 .924 r
.18294 .49935 .18965 .50575 .19922 .50377 .19255 .49709 Mtetra
.536 .688 .937 r
.19255 .49709 .19922 .50377 .2055 .53679 .20206 .49627 Mtetra
.634 .455 .623 r
.20206 .49627 .2055 .53679 .21898 .49432 .2125 .48612 Mtetra
.524 .635 .902 r
.2125 .48612 .21898 .49432 .22866 .49231 .22203 .48582 Mtetra
.621 .726 .922 r
.22203 .48582 .22866 .49231 .23843 .48976 .23181 .48336 Mtetra
.624 .731 .924 r
.23181 .48336 .23843 .48976 .24822 .4875 .24164 .48082 Mtetra
.563 .701 .934 r
.24164 .48082 .24822 .4875 .25708 .49717 .2514 .47951 Mtetra
.72 .585 .703 r
.2514 .47951 .25708 .49717 .26833 .47769 .26197 .46876 Mtetra
.499 .605 .889 r
.26197 .46876 .26833 .47769 .27821 .47563 .27168 .46905 Mtetra
.626 .728 .92 r
.27168 .46905 .27821 .47563 .28819 .47282 .28167 .46643 Mtetra
.639 .739 .921 r
.28167 .46643 .28819 .47282 .29823 .46987 .29172 .46349 Mtetra
.639 .74 .922 r
.29172 .46349 .29823 .46987 .30829 .46699 .30182 .46052 Mtetra
.629 .735 .924 r
.30182 .46052 .30829 .46699 .31836 .4647 .31194 .45777 Mtetra
.519 .679 .938 r
.31194 .45777 .31836 .4647 .33089 .4221 .32196 .4572 Mtetra
.358 .079 .346 r
.32196 .4572 .33089 .4221 .33896 .45448 .33263 .4466 Mtetra
.567 .669 .907 r
.33263 .4466 .33896 .45448 .34916 .45194 .34278 .44534 Mtetra
.637 .736 .92 r
.34278 .44534 .34916 .45194 .35944 .44882 .35307 .44237 Mtetra
.648 .745 .92 r
.35307 .44237 .35944 .44882 .36976 .44551 .36342 .43911 Mtetra
.653 .749 .92 r
.36342 .43911 .36976 .44551 .38013 .44211 .37381 .43572 Mtetra
.656 .751 .92 r
.37381 .43572 .38013 .44211 .39055 .43864 .38425 .43224 Mtetra
.657 .752 .92 r
.38425 .43224 .39055 .43864 .401 .43512 .39473 .42871 Mtetra
.658 .753 .92 r
.39473 .42871 .401 .43512 .4115 .43156 .40525 .42514 Mtetra
.659 .754 .92 r
.40525 .42514 .4115 .43156 .42203 .42799 .41581 .42154 Mtetra
.41581 .42154 .42203 .42799 .43261 .4244 .42642 .41793 Mtetra
.42642 .41793 .43261 .4244 .44323 .4208 .43706 .4143 Mtetra
.659 .753 .92 r
.43706 .4143 .44323 .4208 .45389 .4172 .44775 .41067 Mtetra
.658 .753 .92 r
.44775 .41067 .45389 .4172 .46459 .41358 .45848 .40703 Mtetra
.45848 .40703 .46459 .41358 .47533 .40996 .46925 .40338 Mtetra
.46925 .40338 .47533 .40996 .48612 .40633 .48006 .39972 Mtetra
.48006 .39972 .48612 .40633 .49695 .40269 .49092 .39605 Mtetra
.49092 .39605 .49695 .40269 .50782 .39904 .50181 .39237 Mtetra
.50181 .39237 .50782 .39904 .51873 .39538 .51276 .38868 Mtetra
.657 .753 .92 r
.51276 .38868 .51873 .39538 .52969 .3917 .52374 .38497 Mtetra
.52374 .38497 .52969 .3917 .54069 .38801 .53477 .38125 Mtetra
.53477 .38125 .54069 .38801 .55173 .3843 .54584 .37752 Mtetra
.657 .752 .92 r
.54584 .37752 .55173 .3843 .56282 .38059 .55696 .37378 Mtetra
.55696 .37378 .56282 .38059 .57395 .37686 .56812 .37002 Mtetra
.56812 .37002 .57395 .37686 .58512 .37311 .57933 .36625 Mtetra
.57933 .36625 .58512 .37311 .59635 .36935 .59058 .36246 Mtetra
.59058 .36246 .59635 .36935 .60761 .36558 .60187 .35866 Mtetra
.60187 .35866 .60761 .36558 .61892 .36179 .61322 .35484 Mtetra
.61322 .35484 .61892 .36179 .63028 .35799 .62461 .35101 Mtetra
.62461 .35101 .63028 .35799 .64168 .35418 .63604 .34717 Mtetra
.63604 .34717 .64168 .35418 .65313 .35035 .64752 .34331 Mtetra
.64752 .34331 .65313 .35035 .66463 .3465 .65905 .33943 Mtetra
.65905 .33943 .66463 .3465 .67617 .34264 .67063 .33554 Mtetra
.67063 .33554 .67617 .34264 .68777 .33876 .68225 .33164 Mtetra
.68225 .33164 .68777 .33876 .6994 .33487 .69392 .32771 Mtetra
.69392 .32771 .6994 .33487 .71109 .33096 .70564 .32378 Mtetra
.70564 .32378 .71109 .33096 .72282 .32704 .71741 .31982 Mtetra
.71741 .31982 .72282 .32704 .7346 .3231 .72922 .31586 Mtetra
.72922 .31586 .7346 .3231 .74644 .31915 .74109 .31187 Mtetra
.74109 .31187 .74644 .31915 .75832 .31518 .753 .30787 Mtetra
.753 .30787 .75832 .31518 .77024 .31119 .76497 .30385 Mtetra
.76497 .30385 .77024 .31119 .78222 .30719 .77698 .29982 Mtetra
.77698 .29982 .78222 .30719 .79425 .30317 .78905 .29577 Mtetra
.78905 .29577 .79425 .30317 .80633 .29914 .80116 .29171 Mtetra
.80116 .29171 .80633 .29914 .81846 .29509 .81333 .28762 Mtetra
.44 .554 .875 r
.16702 .49135 .17344 .50098 .18294 .49935 .1762 .49279 Mtetra
.61 .719 .923 r
.1762 .49279 .18294 .49935 .19255 .49709 .18582 .49058 Mtetra
.601 .719 .927 r
.18582 .49058 .19255 .49709 .20206 .49627 .19546 .48855 Mtetra
.944 .59 .298 r
.19546 .48855 .20206 .49627 .2125 .48612 .20175 .52167 Mtetra
0 0 0 r
.20175 .52167 .2125 .48612 .22203 .48582 .21539 .47897 Mtetra
.602 .709 .92 r
.21539 .47897 .22203 .48582 .23181 .48336 .22515 .47691 Mtetra
.626 .731 .923 r
.22515 .47691 .23181 .48336 .24164 .48082 .235 .4743 Mtetra
.612 .725 .926 r
.235 .4743 .24164 .48082 .2514 .47951 .24486 .47199 Mtetra
0 0 .509 r
.24486 .47199 .2514 .47951 .26197 .46876 .25379 .48165 Mtetra
.697 .85 .43 r
.25379 .48165 .26197 .46876 .27168 .46905 .26514 .46204 Mtetra
.603 .708 .918 r
.26514 .46204 .27168 .46905 .28167 .46643 .27511 .45993 Mtetra
.635 .736 .921 r
.27511 .45993 .28167 .46643 .29172 .46349 .28517 .45706 Mtetra
.64 .74 .921 r
.28517 .45706 .29172 .46349 .30182 .46052 .29529 .45405 Mtetra
.637 .739 .922 r
.29529 .45405 .30182 .46052 .31194 .45777 .30544 .45111 Mtetra
.61 .725 .927 r
.30544 .45111 .31194 .45777 .32196 .4572 .3156 .44877 Mtetra
.917 .721 .622 r
.3156 .44877 .32196 .4572 .33263 .4466 .32826 .40595 Mtetra
0 0 .466 r
.32826 .40595 .33263 .4466 .34278 .44534 .33637 .43841 Mtetra
.621 .721 .918 r
.33637 .43841 .34278 .44534 .35307 .44237 .34666 .43581 Mtetra
.644 .742 .92 r
.34666 .43581 .35307 .44237 .36342 .43911 .35703 .43263 Mtetra
.651 .747 .92 r
.35703 .43263 .36342 .43911 .37381 .43572 .36744 .42926 Mtetra
.654 .75 .92 r
.36744 .42926 .37381 .43572 .38425 .43224 .37791 .42579 Mtetra
.657 .752 .92 r
.37791 .42579 .38425 .43224 .39473 .42871 .38841 .42226 Mtetra
.658 .753 .92 r
.38841 .42226 .39473 .42871 .40525 .42514 .39896 .41867 Mtetra
.659 .754 .92 r
.39896 .41867 .40525 .42514 .41581 .42154 .40955 .41505 Mtetra
.40955 .41505 .41581 .42154 .42642 .41793 .42018 .41141 Mtetra
.42018 .41141 .42642 .41793 .43706 .4143 .43085 .40776 Mtetra
.43085 .40776 .43706 .4143 .44775 .41067 .44156 .40409 Mtetra
.658 .753 .92 r
.44156 .40409 .44775 .41067 .45848 .40703 .45232 .40042 Mtetra
.45232 .40042 .45848 .40703 .46925 .40338 .46312 .39674 Mtetra
.46312 .39674 .46925 .40338 .48006 .39972 .47396 .39306 Mtetra
.47396 .39306 .48006 .39972 .49092 .39605 .48484 .38936 Mtetra
.48484 .38936 .49092 .39605 .50181 .39237 .49577 .38565 Mtetra
.49577 .38565 .50181 .39237 .51276 .38868 .50674 .38193 Mtetra
.50674 .38193 .51276 .38868 .52374 .38497 .51775 .3782 Mtetra
.657 .753 .92 r
.51775 .3782 .52374 .38497 .53477 .38125 .52881 .37445 Mtetra
.52881 .37445 .53477 .38125 .54584 .37752 .53991 .37069 Mtetra
.657 .752 .92 r
.53991 .37069 .54584 .37752 .55696 .37378 .55106 .36692 Mtetra
.55106 .36692 .55696 .37378 .56812 .37002 .56225 .36313 Mtetra
.56225 .36313 .56812 .37002 .57933 .36625 .57348 .35933 Mtetra
.57348 .35933 .57933 .36625 .59058 .36246 .58477 .35551 Mtetra
.58477 .35551 .59058 .36246 .60187 .35866 .59609 .35168 Mtetra
.59609 .35168 .60187 .35866 .61322 .35484 .60747 .34784 Mtetra
.60747 .34784 .61322 .35484 .62461 .35101 .61889 .34398 Mtetra
.61889 .34398 .62461 .35101 .63604 .34717 .63036 .3401 Mtetra
.63036 .3401 .63604 .34717 .64752 .34331 .64187 .33621 Mtetra
.64187 .33621 .64752 .34331 .65905 .33943 .65343 .33231 Mtetra
.65343 .33231 .65905 .33943 .67063 .33554 .66504 .32839 Mtetra
.66504 .32839 .67063 .33554 .68225 .33164 .67669 .32445 Mtetra
.67669 .32445 .68225 .33164 .69392 .32771 .6884 .3205 Mtetra
.6884 .3205 .69392 .32771 .70564 .32378 .70015 .31653 Mtetra
.70015 .31653 .70564 .32378 .71741 .31982 .71195 .31255 Mtetra
.71195 .31255 .71741 .31982 .72922 .31586 .7238 .30855 Mtetra
.7238 .30855 .72922 .31586 .74109 .31187 .7357 .30454 Mtetra
.7357 .30454 .74109 .31187 .753 .30787 .74765 .30051 Mtetra
.74765 .30051 .753 .30787 .76497 .30385 .75965 .29646 Mtetra
.75965 .29646 .76497 .30385 .77698 .29982 .7717 .29239 Mtetra
.7717 .29239 .77698 .29982 .78905 .29577 .7838 .28831 Mtetra
.7838 .28831 .78905 .29577 .80116 .29171 .79595 .28421 Mtetra
.79595 .28421 .80116 .29171 .81333 .28762 .80815 .2801 Mtetra
.747 .936 .596 r
.15851 .50033 .16702 .49135 .1762 .49279 .16946 .48575 Mtetra
.585 .697 .919 r
.16946 .48575 .1762 .49279 .18582 .49058 .17903 .48407 Mtetra
.613 .724 .924 r
.17903 .48407 .18582 .49058 .19546 .48855 .18872 .48175 Mtetra
.536 .688 .937 r
.18872 .48175 .19546 .48855 .20175 .52167 .1983 .48089 Mtetra
.633 .453 .622 r
.1983 .48089 .20175 .52167 .21539 .47897 .20884 .47065 Mtetra
.524 .635 .902 r
.20884 .47065 .21539 .47897 .22515 .47691 .21845 .47031 Mtetra
.621 .726 .922 r
.21845 .47031 .22515 .47691 .235 .4743 .2283 .46779 Mtetra
.624 .731 .924 r
.2283 .46779 .235 .4743 .24486 .47199 .23821 .4652 Mtetra
.563 .701 .933 r
.23821 .4652 .24486 .47199 .25379 .48165 .24806 .46383 Mtetra
.72 .585 .703 r
.24806 .46383 .25379 .48165 .26514 .46204 .25872 .45299 Mtetra
.499 .605 .889 r
.25872 .45299 .26514 .46204 .27511 .45993 .26851 .45324 Mtetra
.626 .728 .92 r
.26851 .45324 .27511 .45993 .28517 .45706 .27858 .45056 Mtetra
.639 .739 .921 r
.27858 .45056 .28517 .45706 .29529 .45405 .28872 .44756 Mtetra
.639 .74 .922 r
.28872 .44756 .29529 .45405 .30544 .45111 .2989 .44453 Mtetra
.629 .735 .924 r
.2989 .44453 .30544 .45111 .3156 .44877 .3091 .44172 Mtetra
.52 .679 .937 r
.3091 .44172 .3156 .44877 .32826 .40595 .31921 .4411 Mtetra
.351 .069 .338 r
.31921 .4411 .32826 .40595 .33637 .43841 .32998 .43041 Mtetra
.567 .669 .907 r
.32998 .43041 .33637 .43841 .34666 .43581 .34022 .42909 Mtetra
.637 .736 .92 r
.34022 .42909 .34666 .43581 .35703 .43263 .3506 .42606 Mtetra
.648 .745 .92 r
.3506 .42606 .35703 .43263 .36744 .42926 .36103 .42274 Mtetra
.653 .749 .92 r
.36103 .42274 .36744 .42926 .37791 .42579 .37152 .41928 Mtetra
.656 .751 .92 r
.37152 .41928 .37791 .42579 .38841 .42226 .38205 .41574 Mtetra
.657 .752 .92 r
.38205 .41574 .38841 .42226 .39896 .41867 .39262 .41215 Mtetra
.658 .753 .92 r
.39262 .41215 .39896 .41867 .40955 .41505 .40323 .40851 Mtetra
.659 .754 .92 r
.40323 .40851 .40955 .41505 .42018 .41141 .41389 .40485 Mtetra
.41389 .40485 .42018 .41141 .43085 .40776 .42459 .40116 Mtetra
.42459 .40116 .43085 .40776 .44156 .40409 .43533 .39747 Mtetra
.659 .753 .92 r
.43533 .39747 .44156 .40409 .45232 .40042 .44611 .39377 Mtetra
.658 .753 .92 r
.44611 .39377 .45232 .40042 .46312 .39674 .45694 .39006 Mtetra
.45694 .39006 .46312 .39674 .47396 .39306 .46781 .38635 Mtetra
.46781 .38635 .47396 .39306 .48484 .38936 .47872 .38262 Mtetra
.47872 .38262 .48484 .38936 .49577 .38565 .48968 .37888 Mtetra
.48968 .37888 .49577 .38565 .50674 .38193 .50067 .37513 Mtetra
.50067 .37513 .50674 .38193 .51775 .3782 .51172 .37137 Mtetra
.657 .753 .92 r
.51172 .37137 .51775 .3782 .52881 .37445 .5228 .36759 Mtetra
.5228 .36759 .52881 .37445 .53991 .37069 .53393 .36381 Mtetra
.53393 .36381 .53991 .37069 .55106 .36692 .54511 .36 Mtetra
.657 .752 .92 r
.54511 .36 .55106 .36692 .56225 .36313 .55633 .35619 Mtetra
.55633 .35619 .56225 .36313 .57348 .35933 .5676 .35236 Mtetra
.5676 .35236 .57348 .35933 .58477 .35551 .57891 .34851 Mtetra
.57891 .34851 .58477 .35551 .59609 .35168 .59027 .34465 Mtetra
.59027 .34465 .59609 .35168 .60747 .34784 .60168 .34078 Mtetra
.60168 .34078 .60747 .34784 .61889 .34398 .61313 .33689 Mtetra
.61313 .33689 .61889 .34398 .63036 .3401 .62463 .33299 Mtetra
.62463 .33299 .63036 .3401 .64187 .33621 .63617 .32907 Mtetra
.63617 .32907 .64187 .33621 .65343 .33231 .64777 .32513 Mtetra
.64777 .32513 .65343 .33231 .66504 .32839 .65941 .32118 Mtetra
.65941 .32118 .66504 .32839 .67669 .32445 .6711 .31722 Mtetra
.6711 .31722 .67669 .32445 .6884 .3205 .68283 .31323 Mtetra
.68283 .31323 .6884 .3205 .70015 .31653 .69462 .30924 Mtetra
.69462 .30924 .70015 .31653 .71195 .31255 .70645 .30522 Mtetra
.70645 .30522 .71195 .31255 .7238 .30855 .71834 .30119 Mtetra
.71834 .30119 .7238 .30855 .7357 .30454 .73027 .29715 Mtetra
.73027 .29715 .7357 .30454 .74765 .30051 .74226 .29308 Mtetra
.74226 .29308 .74765 .30051 .75965 .29646 .75429 .289 Mtetra
.75429 .289 .75965 .29646 .7717 .29239 .76638 .28491 Mtetra
.76638 .28491 .7717 .29239 .7838 .28831 .77851 .28079 Mtetra
.77851 .28079 .7838 .28831 .79595 .28421 .7907 .27666 Mtetra
.7907 .27666 .79595 .28421 .80815 .2801 .80294 .27252 Mtetra
.757 .64 .732 r
.15236 .48723 .15851 .50033 .16946 .48575 .16297 .476 Mtetra
.44 .554 .875 r
.16297 .476 .16946 .48575 .17903 .48407 .17222 .4774 Mtetra
.61 .719 .923 r
.17222 .4774 .17903 .48407 .18872 .48175 .18191 .47514 Mtetra
.601 .719 .927 r
.18191 .47514 .18872 .48175 .1983 .48089 .19163 .47305 Mtetra
.944 .588 .293 r
.19163 .47305 .1983 .48089 .20884 .47065 .19793 .50627 Mtetra
0 0 0 r
.19793 .50627 .20884 .47065 .21845 .47031 .21173 .46334 Mtetra
.602 .709 .92 r
.21173 .46334 .21845 .47031 .2283 .46779 .22157 .46123 Mtetra
.626 .731 .923 r
.22157 .46123 .2283 .46779 .23821 .4652 .2315 .45856 Mtetra
.612 .725 .926 r
.2315 .45856 .23821 .4652 .24806 .46383 .24144 .4562 Mtetra
0 0 .516 r
.24144 .4562 .24806 .46383 .25872 .45299 .25043 .46585 Mtetra
.705 .857 .439 r
.25043 .46585 .25872 .45299 .26851 .45324 .2619 .44611 Mtetra
.603 .708 .918 r
.2619 .44611 .26851 .45324 .27858 .45056 .27195 .44394 Mtetra
.635 .736 .921 r
.27195 .44394 .27858 .45056 .28872 .44756 .2821 .44101 Mtetra
.64 .74 .921 r
.2821 .44101 .28872 .44756 .2989 .44453 .2923 .43795 Mtetra
.637 .739 .922 r
.2923 .43795 .2989 .44453 .3091 .44172 .30254 .43494 Mtetra
.61 .725 .927 r
.30254 .43494 .3091 .44172 .31921 .4411 .31278 .43254 Mtetra
.918 .721 .621 r
.31278 .43254 .31921 .4411 .32998 .43041 .32559 .3895 Mtetra
0 0 .462 r
.32559 .3895 .32998 .43041 .34022 .42909 .33374 .42204 Mtetra
.621 .721 .918 r
.33374 .42204 .34022 .42909 .3506 .42606 .34412 .41939 Mtetra
.644 .742 .92 r
.34412 .41939 .3506 .42606 .36103 .42274 .35458 .41614 Mtetra
.651 .747 .92 r
.35458 .41614 .36103 .42274 .37152 .41928 .36508 .41271 Mtetra
.654 .75 .92 r
.36508 .41271 .37152 .41928 .38205 .41574 .37564 .40917 Mtetra
.657 .752 .92 r
.37564 .40917 .38205 .41574 .39262 .41215 .38623 .40557 Mtetra
.658 .753 .92 r
.38623 .40557 .39262 .41215 .40323 .40851 .39688 .40192 Mtetra
.659 .754 .92 r
.39688 .40192 .40323 .40851 .41389 .40485 .40756 .39823 Mtetra
.40756 .39823 .41389 .40485 .42459 .40116 .41829 .39452 Mtetra
.41829 .39452 .42459 .40116 .43533 .39747 .42905 .3908 Mtetra
.42905 .3908 .43533 .39747 .44611 .39377 .43986 .38707 Mtetra
.658 .753 .92 r
.43986 .38707 .44611 .39377 .45694 .39006 .45072 .38333 Mtetra
.45072 .38333 .45694 .39006 .46781 .38635 .46161 .37959 Mtetra
.46161 .37959 .46781 .38635 .47872 .38262 .47255 .37583 Mtetra
.47255 .37583 .47872 .38262 .48968 .37888 .48354 .37206 Mtetra
.48354 .37206 .48968 .37888 .50067 .37513 .49457 .36828 Mtetra
.49457 .36828 .50067 .37513 .51172 .37137 .50564 .36449 Mtetra
.50564 .36449 .51172 .37137 .5228 .36759 .51675 .36069 Mtetra
.657 .753 .92 r
.51675 .36069 .5228 .36759 .53393 .36381 .52791 .35687 Mtetra
.52791 .35687 .53393 .36381 .54511 .36 .53912 .35304 Mtetra
.657 .752 .92 r
.53912 .35304 .54511 .36 .55633 .35619 .55037 .34919 Mtetra
.55037 .34919 .55633 .35619 .5676 .35236 .56167 .34534 Mtetra
.56167 .34534 .5676 .35236 .57891 .34851 .57301 .34146 Mtetra
.57301 .34146 .57891 .34851 .59027 .34465 .5844 .33757 Mtetra
.5844 .33757 .59027 .34465 .60168 .34078 .59584 .33367 Mtetra
.59584 .33367 .60168 .34078 .61313 .33689 .60732 .32975 Mtetra
.60732 .32975 .61313 .33689 .62463 .33299 .61885 .32582 Mtetra
.61885 .32582 .62463 .33299 .63617 .32907 .63043 .32187 Mtetra
.63043 .32187 .63617 .32907 .64777 .32513 .64206 .3179 Mtetra
.64206 .3179 .64777 .32513 .65941 .32118 .65373 .31392 Mtetra
.65373 .31392 .65941 .32118 .6711 .31722 .66545 .30992 Mtetra
.66545 .30992 .6711 .31722 .68283 .31323 .67722 .30591 Mtetra
.67722 .30591 .68283 .31323 .69462 .30924 .68904 .30188 Mtetra
.68904 .30188 .69462 .30924 .70645 .30522 .70091 .29784 Mtetra
.70091 .29784 .70645 .30522 .71834 .30119 .71283 .29378 Mtetra
.71283 .29378 .71834 .30119 .73027 .29715 .7248 .2897 Mtetra
.7248 .2897 .73027 .29715 .74226 .29308 .73682 .2856 Mtetra
.73682 .2856 .74226 .29308 .75429 .289 .74889 .28149 Mtetra
.74889 .28149 .75429 .289 .76638 .28491 .76101 .27736 Mtetra
.76101 .27736 .76638 .28491 .77851 .28079 .77319 .27322 Mtetra
.77319 .27322 .77851 .28079 .7907 .27666 .78541 .26906 Mtetra
.78541 .26906 .7907 .27666 .80294 .27252 .79769 .26488 Mtetra
0 .347 .821 r
.14553 .47985 .15236 .48723 .16297 .476 .15435 .48493 Mtetra
.754 .94 .604 r
.15435 .48493 .16297 .476 .17222 .4774 .1654 .47025 Mtetra
.585 .697 .919 r
.1654 .47025 .17222 .4774 .18191 .47514 .17506 .46852 Mtetra
.613 .724 .924 r
.17506 .46852 .18191 .47514 .19163 .47305 .18482 .46615 Mtetra
.536 .688 .937 r
.18482 .46615 .19163 .47305 .19793 .50627 .19448 .46524 Mtetra
.632 .451 .62 r
.19448 .46524 .19793 .50627 .21173 .46334 .20511 .4549 Mtetra
.524 .635 .902 r
.20511 .4549 .21173 .46334 .22157 .46123 .21479 .45451 Mtetra
.621 .726 .922 r
.21479 .45451 .22157 .46123 .2315 .45856 .22473 .45194 Mtetra
.624 .731 .924 r
.22473 .45194 .2315 .45856 .24144 .4562 .23472 .44929 Mtetra
.563 .701 .933 r
.23472 .44929 .24144 .4562 .25043 .46585 .24465 .44787 Mtetra
.72 .585 .703 r
.24465 .44787 .25043 .46585 .2619 .44611 .25541 .43694 Mtetra
.499 .605 .89 r
.25541 .43694 .2619 .44611 .27195 .44394 .26528 .43714 Mtetra
.626 .728 .92 r
.26528 .43714 .27195 .44394 .2821 .44101 .27544 .43439 Mtetra
.639 .739 .921 r
.27544 .43439 .2821 .44101 .2923 .43795 .28566 .43133 Mtetra
.639 .74 .922 r
.28566 .43133 .2923 .43795 .30254 .43494 .29592 .42824 Mtetra
.629 .735 .924 r
.29592 .42824 .30254 .43494 .31278 .43254 .30622 .42537 Mtetra
.52 .679 .937 r
.30622 .42537 .31278 .43254 .32559 .3895 .31641 .4247 Mtetra
.344 .06 .331 r
.31641 .4247 .32559 .3895 .33374 .42204 .32728 .41392 Mtetra
.566 .669 .907 r
.32728 .41392 .33374 .42204 .34412 .41939 .33761 .41254 Mtetra
.637 .736 .92 r
.33761 .41254 .34412 .41939 .35458 .41614 .34807 .40945 Mtetra
.648 .745 .92 r
.34807 .40945 .35458 .41614 .36508 .41271 .3586 .40606 Mtetra
.653 .749 .92 r
.3586 .40606 .36508 .41271 .37564 .40917 .36918 .40254 Mtetra
.656 .751 .92 r
.36918 .40254 .37564 .40917 .38623 .40557 .3798 .39894 Mtetra
.657 .752 .92 r
.3798 .39894 .38623 .40557 .39688 .40192 .39047 .39527 Mtetra
.658 .753 .92 r
.39047 .39527 .39688 .40192 .40756 .39823 .40118 .39157 Mtetra
.659 .754 .92 r
.40118 .39157 .40756 .39823 .41829 .39452 .41193 .38784 Mtetra
.41193 .38784 .41829 .39452 .42905 .3908 .42273 .38409 Mtetra
.42273 .38409 .42905 .3908 .43986 .38707 .43357 .38032 Mtetra
.659 .753 .92 r
.43357 .38032 .43986 .38707 .45072 .38333 .44445 .37655 Mtetra
.658 .753 .92 r
.44445 .37655 .45072 .38333 .46161 .37959 .45537 .37278 Mtetra
.45537 .37278 .46161 .37959 .47255 .37583 .46634 .36899 Mtetra
.46634 .36899 .47255 .37583 .48354 .37206 .47735 .36519 Mtetra
.47735 .36519 .48354 .37206 .49457 .36828 .48841 .36139 Mtetra
.48841 .36139 .49457 .36828 .50564 .36449 .49951 .35757 Mtetra
.49951 .35757 .50564 .36449 .51675 .36069 .51066 .35373 Mtetra
.657 .753 .92 r
.51066 .35373 .51675 .36069 .52791 .35687 .52185 .34988 Mtetra
.52185 .34988 .52791 .35687 .53912 .35304 .53308 .34602 Mtetra
.53308 .34602 .53912 .35304 .55037 .34919 .54437 .34215 Mtetra
.657 .752 .92 r
.54437 .34215 .55037 .34919 .56167 .34534 .55569 .33826 Mtetra
.55569 .33826 .56167 .34534 .57301 .34146 .56707 .33436 Mtetra
.56707 .33436 .57301 .34146 .5844 .33757 .57849 .33044 Mtetra
.57849 .33044 .5844 .33757 .59584 .33367 .58996 .3265 Mtetra
.58996 .3265 .59584 .33367 .60732 .32975 .60147 .32255 Mtetra
.60147 .32255 .60732 .32975 .61885 .32582 .61304 .31859 Mtetra
.61304 .31859 .61885 .32582 .63043 .32187 .62465 .31461 Mtetra
.62465 .31461 .63043 .32187 .64206 .3179 .63631 .31061 Mtetra
.63631 .31061 .64206 .3179 .65373 .31392 .64801 .3066 Mtetra
.64801 .3066 .65373 .31392 .66545 .30992 .65977 .30258 Mtetra
.65977 .30258 .66545 .30992 .67722 .30591 .67157 .29853 Mtetra
.67157 .29853 .67722 .30591 .68904 .30188 .68343 .29447 Mtetra
.68343 .29447 .68904 .30188 .70091 .29784 .69533 .29039 Mtetra
.69533 .29039 .70091 .29784 .71283 .29378 .70728 .2863 Mtetra
.70728 .2863 .71283 .29378 .7248 .2897 .71929 .28219 Mtetra
.71929 .28219 .7248 .2897 .73682 .2856 .73134 .27807 Mtetra
.73134 .27807 .73682 .2856 .74889 .28149 .74345 .27392 Mtetra
.74345 .27392 .74889 .28149 .76101 .27736 .75561 .26976 Mtetra
.75561 .26976 .76101 .27736 .77319 .27322 .76782 .26558 Mtetra
.76782 .26558 .77319 .27322 .78541 .26906 .78008 .26139 Mtetra
.78008 .26139 .78541 .26906 .79769 .26488 .79239 .25717 Mtetra
.561 .699 .933 r
.13859 .47303 .14553 .47985 .15435 .48493 .14814 .4717 Mtetra
.757 .64 .732 r
.14814 .4717 .15435 .48493 .1654 .47025 .15884 .46037 Mtetra
.439 .554 .875 r
.15884 .46037 .1654 .47025 .17506 .46852 .16816 .46174 Mtetra
.61 .719 .923 r
.16816 .46174 .17506 .46852 .18482 .46615 .17794 .45942 Mtetra
.601 .719 .927 r
.17794 .45942 .18482 .46615 .19448 .46524 .18774 .45728 Mtetra
.944 .587 .288 r
.18774 .45728 .19448 .46524 .20511 .4549 .19404 .49059 Mtetra
0 0 0 r
.19404 .49059 .20511 .4549 .21479 .45451 .208 .44743 Mtetra
.602 .709 .92 r
.208 .44743 .21479 .45451 .22473 .45194 .21792 .44526 Mtetra
.626 .731 .923 r
.21792 .44526 .22473 .45194 .23472 .44929 .22794 .44254 Mtetra
.612 .725 .926 r
.22794 .44254 .23472 .44929 .24465 .44787 .23796 .44011 Mtetra
0 0 .524 r
.23796 .44011 .24465 .44787 .25541 .43694 .24701 .44976 Mtetra
.714 .863 .448 r
.24701 .44976 .25541 .43694 .26528 .43714 .2586 .42989 Mtetra
.603 .708 .918 r
.2586 .42989 .26528 .43714 .27544 .43439 .26873 .42766 Mtetra
.635 .736 .921 r
.26873 .42766 .27544 .43439 .28566 .43133 .27897 .42467 Mtetra
.64 .74 .921 r
.27897 .42467 .28566 .43133 .29592 .42824 .28926 .42154 Mtetra
.637 .739 .922 r
.28926 .42154 .29592 .42824 .30622 .42537 .29958 .41848 Mtetra
.61 .725 .927 r
.29958 .41848 .30622 .42537 .31641 .4247 .30991 .41602 Mtetra
.919 .722 .62 r
.30991 .41602 .31641 .4247 .32728 .41392 .32287 .37275 Mtetra
0 0 .458 r
.32287 .37275 .32728 .41392 .33761 .41254 .33106 .40537 Mtetra
.621 .721 .918 r
.33106 .40537 .33761 .41254 .34807 .40945 .34153 .40265 Mtetra
.644 .742 .92 r
.34153 .40265 .34807 .40945 .3586 .40606 .35208 .39934 Mtetra
.651 .747 .92 r
.35208 .39934 .3586 .40606 .36918 .40254 .36268 .39584 Mtetra
.654 .75 .92 r
.36268 .39584 .36918 .40254 .3798 .39894 .37332 .39224 Mtetra
.657 .752 .92 r
.37332 .39224 .3798 .39894 .39047 .39527 .38402 .38857 Mtetra
.658 .753 .92 r
.38402 .38857 .39047 .39527 .40118 .39157 .39475 .38485 Mtetra
.659 .754 .92 r
.39475 .38485 .40118 .39157 .41193 .38784 .40553 .3811 Mtetra
.40553 .3811 .41193 .38784 .42273 .38409 .41636 .37732 Mtetra
.41636 .37732 .42273 .38409 .43357 .38032 .42722 .37353 Mtetra
.42722 .37353 .43357 .38032 .44445 .37655 .43813 .36973 Mtetra
.658 .753 .92 r
.43813 .36973 .44445 .37655 .45537 .37278 .44909 .36592 Mtetra
.44909 .36592 .45537 .37278 .46634 .36899 .46008 .3621 Mtetra
.46008 .3621 .46634 .36899 .47735 .36519 .47112 .35827 Mtetra
.47112 .35827 .47735 .36519 .48841 .36139 .48221 .35444 Mtetra
.48221 .35444 .48841 .36139 .49951 .35757 .49334 .35059 Mtetra
.49334 .35059 .49951 .35757 .51066 .35373 .50452 .34672 Mtetra
.50452 .34672 .51066 .35373 .52185 .34988 .51574 .34285 Mtetra
.657 .753 .92 r
.51574 .34285 .52185 .34988 .53308 .34602 .527 .33895 Mtetra
.527 .33895 .53308 .34602 .54437 .34215 .53832 .33505 Mtetra
.657 .752 .92 r
.53832 .33505 .54437 .34215 .55569 .33826 .54967 .33113 Mtetra
.54967 .33113 .55569 .33826 .56707 .33436 .56108 .3272 Mtetra
.56108 .3272 .56707 .33436 .57849 .33044 .57253 .32325 Mtetra
.57253 .32325 .57849 .33044 .58996 .3265 .58403 .31928 Mtetra
.58403 .31928 .58996 .3265 .60147 .32255 .59558 .3153 Mtetra
.59558 .3153 .60147 .32255 .61304 .31859 .60717 .31131 Mtetra
.60717 .31131 .61304 .31859 .62465 .31461 .61882 .3073 Mtetra
.61882 .3073 .62465 .31461 .63631 .31061 .63051 .30327 Mtetra
.63051 .30327 .63631 .31061 .64801 .3066 .64225 .29923 Mtetra
.64225 .29923 .64801 .3066 .65977 .30258 .65404 .29517 Mtetra
.65404 .29517 .65977 .30258 .67157 .29853 .66588 .29109 Mtetra
.66588 .29109 .67157 .29853 .68343 .29447 .67777 .287 Mtetra
.67777 .287 .68343 .29447 .69533 .29039 .6897 .28289 Mtetra
.6897 .28289 .69533 .29039 .70728 .2863 .70169 .27877 Mtetra
.70169 .27877 .70728 .2863 .71929 .28219 .71373 .27463 Mtetra
.71373 .27463 .71929 .28219 .73134 .27807 .72582 .27047 Mtetra
.72582 .27047 .73134 .27807 .74345 .27392 .73796 .26629 Mtetra
.73796 .26629 .74345 .27392 .75561 .26976 .75016 .2621 Mtetra
.75016 .2621 .75561 .26976 .76782 .26558 .7624 .25789 Mtetra
.7624 .25789 .76782 .26558 .78008 .26139 .7747 .25366 Mtetra
.7747 .25366 .78008 .26139 .79239 .25717 .78705 .24941 Mtetra
.599 .716 .927 r
.13159 .46628 .13859 .47303 .14814 .4717 .14124 .4642 Mtetra
0 .35 .823 r
.14124 .4642 .14814 .4717 .15884 .46037 .15011 .46926 Mtetra
.761 .944 .612 r
.15011 .46926 .15884 .46037 .16816 .46174 .16128 .45447 Mtetra
.585 .697 .919 r
.16128 .45447 .16816 .46174 .17794 .45942 .17101 .45268 Mtetra
.613 .724 .924 r
.17101 .45268 .17794 .45942 .18774 .45728 .18085 .45026 Mtetra
.536 .688 .936 r
.18085 .45026 .18774 .45728 .19404 .49059 .19058 .4493 Mtetra
.631 .45 .619 r
.19058 .4493 .19404 .49059 .208 .44743 .20131 .43887 Mtetra
.523 .635 .902 r
.20131 .43887 .208 .44743 .21792 .44526 .21107 .43843 Mtetra
.621 .726 .922 r
.21107 .43843 .21792 .44526 .22794 .44254 .2211 .4358 Mtetra
.624 .731 .924 r
.2211 .4358 .22794 .44254 .23796 .44011 .23117 .43309 Mtetra
.563 .701 .933 r
.23117 .43309 .23796 .44011 .24701 .44976 .24118 .43161 Mtetra
.72 .585 .703 r
.24118 .43161 .24701 .44976 .2586 .42989 .25204 .42059 Mtetra
.498 .605 .89 r
.25204 .42059 .2586 .42989 .26873 .42766 .26199 .42074 Mtetra
.626 .728 .921 r
.26199 .42074 .26873 .42766 .27897 .42467 .27223 .41793 Mtetra
.639 .739 .921 r
.27223 .41793 .27897 .42467 .28926 .42154 .28254 .41481 Mtetra
.639 .74 .922 r
.28254 .41481 .28926 .42154 .29958 .41848 .2929 .41166 Mtetra
.629 .735 .924 r
.2929 .41166 .29958 .41848 .30991 .41602 .30328 .40872 Mtetra
.52 .679 .937 r
.30328 .40872 .30991 .41602 .32287 .37275 .31356 .408 Mtetra
.336 .051 .323 r
.31356 .408 .32287 .37275 .33106 .40537 .32453 .39712 Mtetra
.566 .669 .907 r
.32453 .39712 .33106 .40537 .34153 .40265 .33494 .39569 Mtetra
.637 .736 .92 r
.33494 .39569 .34153 .40265 .35208 .39934 .34551 .39253 Mtetra
.648 .745 .92 r
.34551 .39253 .35208 .39934 .36268 .39584 .35613 .38907 Mtetra
.653 .749 .92 r
.35613 .38907 .36268 .39584 .37332 .39224 .3668 .38548 Mtetra
.656 .751 .92 r
.3668 .38548 .37332 .39224 .38402 .38857 .37752 .38181 Mtetra
.657 .752 .92 r
.37752 .38181 .38402 .38857 .39475 .38485 .38828 .37808 Mtetra
.658 .753 .92 r
.38828 .37808 .39475 .38485 .40553 .3811 .39909 .37431 Mtetra
.659 .754 .92 r
.39909 .37431 .40553 .3811 .41636 .37732 .40994 .3705 Mtetra
.40994 .3705 .41636 .37732 .42722 .37353 .42083 .36668 Mtetra
.42083 .36668 .42722 .37353 .43813 .36973 .43177 .36285 Mtetra
.659 .753 .92 r
.43177 .36285 .43813 .36973 .44909 .36592 .44275 .35901 Mtetra
.658 .753 .92 r
.44275 .35901 .44909 .36592 .46008 .3621 .45378 .35516 Mtetra
.45378 .35516 .46008 .3621 .47112 .35827 .46485 .3513 Mtetra
.46485 .3513 .47112 .35827 .48221 .35444 .47596 .34743 Mtetra
.47596 .34743 .48221 .35444 .49334 .35059 .48712 .34355 Mtetra
.48712 .34355 .49334 .35059 .50452 .34672 .49833 .33966 Mtetra
.49833 .33966 .50452 .34672 .51574 .34285 .50958 .33575 Mtetra
.657 .753 .92 r
.50958 .33575 .51574 .34285 .527 .33895 .52087 .33183 Mtetra
.52087 .33183 .527 .33895 .53832 .33505 .53222 .3279 Mtetra
.53222 .3279 .53832 .33505 .54967 .33113 .54361 .32395 Mtetra
.657 .752 .92 r
.54361 .32395 .54967 .33113 .56108 .3272 .55504 .31998 Mtetra
.55504 .31998 .56108 .3272 .57253 .32325 .56653 .316 Mtetra
.56653 .316 .57253 .32325 .58403 .31928 .57806 .31201 Mtetra
.57806 .31201 .58403 .31928 .59558 .3153 .58964 .308 Mtetra
.58964 .308 .59558 .3153 .60717 .31131 .60127 .30397 Mtetra
.60127 .30397 .60717 .31131 .61882 .3073 .61294 .29993 Mtetra
.61294 .29993 .61882 .3073 .63051 .30327 .62467 .29587 Mtetra
.62467 .29587 .63051 .30327 .64225 .29923 .63644 .2918 Mtetra
.63644 .2918 .64225 .29923 .65404 .29517 .64826 .28771 Mtetra
.64826 .28771 .65404 .29517 .66588 .29109 .66014 .2836 Mtetra
.66014 .2836 .66588 .29109 .67777 .287 .67206 .27948 Mtetra
.67206 .27948 .67777 .287 .6897 .28289 .68403 .27533 Mtetra
.68403 .27533 .6897 .28289 .70169 .27877 .69606 .27118 Mtetra
.69606 .27118 .70169 .27877 .71373 .27463 .70813 .267 Mtetra
.70813 .267 .71373 .27463 .72582 .27047 .72026 .26281 Mtetra
.72026 .26281 .72582 .27047 .73796 .26629 .73244 .2586 Mtetra
.73244 .2586 .73796 .26629 .75016 .2621 .74467 .25437 Mtetra
.74467 .25437 .75016 .2621 .7624 .25789 .75695 .25013 Mtetra
.75695 .25013 .7624 .25789 .7747 .25366 .76928 .24587 Mtetra
.76928 .24587 .7747 .25366 .78705 .24941 .78167 .24159 Mtetra
.6 .713 .924 r
.12456 .45939 .13159 .46628 .14124 .4642 .13422 .45727 Mtetra
.561 .699 .933 r
.13422 .45727 .14124 .4642 .15011 .46926 .14384 .45588 Mtetra
.757 .641 .732 r
.14384 .45588 .15011 .46926 .16128 .45447 .15465 .44447 Mtetra
.438 .554 .875 r
.15465 .44447 .16128 .45447 .17101 .45268 .16404 .44579 Mtetra
.61 .719 .923 r
.16404 .44579 .17101 .45268 .18085 .45026 .17389 .44342 Mtetra
.601 .719 .927 r
.17389 .44342 .18085 .45026 .19058 .4493 .18377 .44121 Mtetra
.944 .585 .283 r
.18377 .44121 .19058 .4493 .20131 .43887 .19008 .47462 Mtetra
0 0 0 r
.19008 .47462 .20131 .43887 .21107 .43843 .20421 .43123 Mtetra
.602 .71 .92 r
.20421 .43123 .21107 .43843 .2211 .4358 .21421 .429 Mtetra
.626 .731 .923 r
.21421 .429 .2211 .4358 .23117 .43309 .22431 .42622 Mtetra
.612 .725 .926 r
.22431 .42622 .23117 .43309 .24118 .43161 .23442 .42373 Mtetra
0 .004 .531 r
.23442 .42373 .24118 .43161 .25204 .42059 .24353 .43337 Mtetra
.722 .869 .457 r
.24353 .43337 .25204 .42059 .26199 .42074 .25523 .41337 Mtetra
.603 .708 .918 r
.25523 .41337 .26199 .42074 .27223 .41793 .26545 .41108 Mtetra
.635 .736 .921 r
.26545 .41108 .27223 .41793 .28254 .41481 .27578 .40803 Mtetra
.64 .74 .921 r
.27578 .40803 .28254 .41481 .2929 .41166 .28616 .40483 Mtetra
.637 .739 .922 r
.28616 .40483 .2929 .41166 .30328 .40872 .29657 .40171 Mtetra
.61 .725 .927 r
.29657 .40171 .30328 .40872 .31356 .408 .30699 .39918 Mtetra
.92 .723 .619 r
.30699 .39918 .31356 .408 .32453 .39712 .3201 .35569 Mtetra
0 0 .455 r
.3201 .35569 .32453 .39712 .33494 .39569 .32833 .38839 Mtetra
.621 .721 .918 r
.32833 .38839 .33494 .39569 .34551 .39253 .33889 .38561 Mtetra
.644 .742 .92 r
.33889 .38561 .34551 .39253 .35613 .38907 .34953 .38223 Mtetra
.651 .747 .92 r
.34953 .38223 .35613 .38907 .3668 .38548 .36023 .37866 Mtetra
.654 .75 .92 r
.36023 .37866 .3668 .38548 .37752 .38181 .37097 .37499 Mtetra
.657 .752 .92 r
.37097 .37499 .37752 .38181 .38828 .37808 .38176 .37125 Mtetra
.658 .753 .92 r
.38176 .37125 .38828 .37808 .39909 .37431 .39259 .36746 Mtetra
.659 .754 .92 r
.39259 .36746 .39909 .37431 .40994 .3705 .40347 .36364 Mtetra
.40347 .36364 .40994 .3705 .42083 .36668 .41439 .35979 Mtetra
.41439 .35979 .42083 .36668 .43177 .36285 .42536 .35592 Mtetra
.42536 .35592 .43177 .36285 .44275 .35901 .43637 .35205 Mtetra
.658 .753 .92 r
.43637 .35205 .44275 .35901 .45378 .35516 .44742 .34817 Mtetra
.44742 .34817 .45378 .35516 .46485 .3513 .45852 .34428 Mtetra
.45852 .34428 .46485 .3513 .47596 .34743 .46967 .34038 Mtetra
.46967 .34038 .47596 .34743 .48712 .34355 .48086 .33647 Mtetra
.48086 .33647 .48712 .34355 .49833 .33966 .49209 .33255 Mtetra
.49209 .33255 .49833 .33966 .50958 .33575 .50337 .32861 Mtetra
.50337 .32861 .50958 .33575 .52087 .33183 .5147 .32466 Mtetra
.657 .753 .92 r
.5147 .32466 .52087 .33183 .53222 .3279 .52607 .32069 Mtetra
.52607 .32069 .53222 .3279 .54361 .32395 .53749 .31671 Mtetra
.657 .752 .92 r
.53749 .31671 .54361 .32395 .55504 .31998 .54896 .31271 Mtetra
.54896 .31271 .55504 .31998 .56653 .316 .56048 .3087 Mtetra
.56048 .3087 .56653 .316 .57806 .31201 .57204 .30468 Mtetra
.57204 .30468 .57806 .31201 .58964 .308 .58365 .30064 Mtetra
.58365 .30064 .58964 .308 .60127 .30397 .59531 .29658 Mtetra
.59531 .29658 .60127 .30397 .61294 .29993 .60702 .2925 Mtetra
.60702 .2925 .61294 .29993 .62467 .29587 .61878 .28841 Mtetra
.61878 .28841 .62467 .29587 .63644 .2918 .63059 .28431 Mtetra
.63059 .28431 .63644 .2918 .64826 .28771 .64244 .28019 Mtetra
.64244 .28019 .64826 .28771 .66014 .2836 .65435 .27605 Mtetra
.65435 .27605 .66014 .2836 .67206 .27948 .66631 .27189 Mtetra
.66631 .27189 .67206 .27948 .68403 .27533 .67832 .26772 Mtetra
.67832 .26772 .68403 .27533 .69606 .27118 .69038 .26353 Mtetra
.69038 .26353 .69606 .27118 .70813 .267 .70249 .25932 Mtetra
.70249 .25932 .70813 .267 .72026 .26281 .71465 .25509 Mtetra
.71465 .25509 .72026 .26281 .73244 .2586 .72686 .25085 Mtetra
.72686 .25085 .73244 .2586 .74467 .25437 .73913 .24659 Mtetra
.73913 .24659 .74467 .25437 .75695 .25013 .75145 .24231 Mtetra
.75145 .24231 .75695 .25013 .76928 .24587 .76382 .23801 Mtetra
.76382 .23801 .76928 .24587 .78167 .24159 .77625 .2337 Mtetra
.571 .687 .919 r
.11754 .45193 .12456 .45939 .13422 .45727 .12714 .45041 Mtetra
.599 .716 .927 r
.12714 .45041 .13422 .45727 .14384 .45588 .13686 .44827 Mtetra
0 .353 .825 r
.13686 .44827 .14384 .45588 .15465 .44447 .1458 .4533 Mtetra
.768 .948 .619 r
.1458 .4533 .15465 .44447 .16404 .44579 .15707 .4384 Mtetra
.585 .697 .919 r
.15707 .4384 .16404 .44579 .17389 .44342 .16688 .43656 Mtetra
.613 .724 .924 r
.16688 .43656 .17389 .44342 .18377 .44121 .1768 .43407 Mtetra
.536 .688 .936 r
.1768 .43407 .18377 .44121 .19008 .47462 .18662 .43306 Mtetra
.63 .448 .618 r
.18662 .43306 .19008 .47462 .20421 .43123 .19744 .42255 Mtetra
.523 .635 .902 r
.19744 .42255 .20421 .43123 .21421 .429 .20729 .42205 Mtetra
.621 .726 .922 r
.20729 .42205 .21421 .429 .22431 .42622 .21739 .41936 Mtetra
.624 .731 .924 r
.21739 .41936 .22431 .42622 .23442 .42373 .22755 .41658 Mtetra
.563 .701 .933 r
.22755 .41658 .23442 .42373 .24353 .43337 .23764 .41505 Mtetra
.72 .585 .703 r
.23764 .41505 .24353 .43337 .25523 .41337 .24861 .40394 Mtetra
.498 .605 .89 r
.24861 .40394 .25523 .41337 .26545 .41108 .25864 .40404 Mtetra
.626 .728 .921 r
.25864 .40404 .26545 .41108 .27578 .40803 .26897 .40117 Mtetra
.639 .739 .921 r
.26897 .40117 .27578 .40803 .28616 .40483 .27937 .39798 Mtetra
.639 .74 .922 r
.27937 .39798 .28616 .40483 .29657 .40171 .28981 .39476 Mtetra
.629 .735 .924 r
.28981 .39476 .29657 .40171 .30699 .39918 .30029 .39176 Mtetra
.521 .679 .937 r
.30029 .39176 .30699 .39918 .3201 .35569 .31066 .39098 Mtetra
.328 .041 .315 r
.31066 .39098 .3201 .35569 .32833 .38839 .32173 .38 Mtetra
.566 .669 .907 r
.32173 .38 .32833 .38839 .33889 .38561 .33223 .37851 Mtetra
.637 .736 .92 r
.33223 .37851 .33889 .38561 .34953 .38223 .34289 .37529 Mtetra
.648 .745 .92 r
.34289 .37529 .34953 .38223 .36023 .37866 .35361 .37176 Mtetra
.653 .749 .92 r
.35361 .37176 .36023 .37866 .37097 .37499 .36437 .3681 Mtetra
.656 .751 .92 r
.36437 .3681 .37097 .37499 .38176 .37125 .37519 .36436 Mtetra
.657 .752 .92 r
.37519 .36436 .38176 .37125 .39259 .36746 .38605 .36056 Mtetra
.658 .753 .92 r
.38605 .36056 .39259 .36746 .40347 .36364 .39696 .35672 Mtetra
.659 .754 .92 r
.39696 .35672 .40347 .36364 .41439 .35979 .40791 .35284 Mtetra
.40791 .35284 .41439 .35979 .42536 .35592 .4189 .34895 Mtetra
.4189 .34895 .42536 .35592 .43637 .35205 .42994 .34504 Mtetra
.659 .753 .92 r
.42994 .34504 .43637 .35205 .44742 .34817 .44102 .34113 Mtetra
.658 .753 .92 r
.44102 .34113 .44742 .34817 .45852 .34428 .45215 .33721 Mtetra
.45215 .33721 .45852 .34428 .46967 .34038 .46332 .33328 Mtetra
.46332 .33328 .46967 .34038 .48086 .33647 .47454 .32933 Mtetra
.47454 .32933 .48086 .33647 .49209 .33255 .48581 .32538 Mtetra
.48581 .32538 .49209 .33255 .50337 .32861 .49712 .32141 Mtetra
.49712 .32141 .50337 .32861 .5147 .32466 .50848 .31742 Mtetra
.657 .753 .92 r
.50848 .31742 .5147 .32466 .52607 .32069 .51988 .31343 Mtetra
.51988 .31343 .52607 .32069 .53749 .31671 .53133 .30942 Mtetra
.53133 .30942 .53749 .31671 .54896 .31271 .54283 .30539 Mtetra
.657 .752 .92 r
.54283 .30539 .54896 .31271 .56048 .3087 .55438 .30135 Mtetra
.55438 .30135 .56048 .3087 .57204 .30468 .56598 .29729 Mtetra
.56598 .29729 .57204 .30468 .58365 .30064 .57762 .29322 Mtetra
.57762 .29322 .58365 .30064 .59531 .29658 .58931 .28913 Mtetra
.58931 .28913 .59531 .29658 .60702 .2925 .60106 .28502 Mtetra
.60106 .28502 .60702 .2925 .61878 .28841 .61285 .2809 Mtetra
.61285 .2809 .61878 .28841 .63059 .28431 .62469 .27676 Mtetra
.62469 .27676 .63059 .28431 .64244 .28019 .63658 .2726 Mtetra
.63658 .2726 .64244 .28019 .65435 .27605 .64852 .26843 Mtetra
.64852 .26843 .65435 .27605 .66631 .27189 .66051 .26424 Mtetra
.66051 .26424 .66631 .27189 .67832 .26772 .67256 .26004 Mtetra
.67256 .26004 .67832 .26772 .69038 .26353 .68465 .25581 Mtetra
.68465 .25581 .69038 .26353 .70249 .25932 .6968 .25157 Mtetra
.6968 .25157 .70249 .25932 .71465 .25509 .709 .24731 Mtetra
.709 .24731 .71465 .25509 .72686 .25085 .72125 .24304 Mtetra
.72125 .24304 .72686 .25085 .73913 .24659 .73355 .23874 Mtetra
.73355 .23874 .73913 .24659 .75145 .24231 .74591 .23443 Mtetra
.74591 .23443 .75145 .24231 .76382 .23801 .75832 .2301 Mtetra
.75832 .2301 .76382 .23801 .77625 .2337 .77078 .22575 Mtetra
.351 .47 .841 r
.11099 .44039 .11754 .45193 .12714 .45041 .12003 .4434 Mtetra
.6 .713 .924 r
.12003 .4434 .12714 .45041 .13686 .44827 .12977 .44122 Mtetra
.561 .699 .933 r
.12977 .44122 .13686 .44827 .1458 .4533 .13947 .43978 Mtetra
.758 .641 .732 r
.13947 .43978 .1458 .4533 .15707 .4384 .15037 .42827 Mtetra
.438 .554 .875 r
.15037 .42827 .15707 .4384 .16688 .43656 .15984 .42955 Mtetra
.61 .719 .923 r
.15984 .42955 .16688 .43656 .1768 .43407 .16977 .42712 Mtetra
.601 .719 .927 r
.16977 .42712 .1768 .43407 .18662 .43306 .17973 .42486 Mtetra
.943 .583 .278 r
.17973 .42486 .18662 .43306 .19744 .42255 .18604 .45836 Mtetra
0 0 0 r
.18604 .45836 .19744 .42255 .20729 .42205 .20035 .41473 Mtetra
.602 .71 .92 r
.20035 .41473 .20729 .42205 .21739 .41936 .21043 .41244 Mtetra
.626 .731 .923 r
.21043 .41244 .21739 .41936 .22755 .41658 .22061 .40959 Mtetra
.612 .725 .926 r
.22061 .40959 .22755 .41658 .23764 .41505 .23081 .40705 Mtetra
0 .01 .538 r
.23081 .40705 .23764 .41505 .24861 .40394 .23999 .41668 Mtetra
.73 .875 .465 r
.23999 .41668 .24861 .40394 .25864 .40404 .25181 .39654 Mtetra
.603 .708 .918 r
.25181 .39654 .25864 .40404 .26897 .40117 .26211 .39419 Mtetra
.635 .736 .921 r
.26211 .39419 .26897 .40117 .27937 .39798 .27253 .39107 Mtetra
.64 .74 .921 r
.27253 .39107 .27937 .39798 .28981 .39476 .283 .38781 Mtetra
.637 .739 .922 r
.283 .38781 .28981 .39476 .30029 .39176 .29351 .38462 Mtetra
.61 .725 .927 r
.29351 .38462 .30029 .39176 .31066 .39098 .30402 .38203 Mtetra
.922 .724 .618 r
.30402 .38203 .31066 .39098 .32173 .38 .31728 .33831 Mtetra
0 0 .451 r
.31728 .33831 .32173 .38 .33223 .37851 .32555 .37108 Mtetra
.621 .721 .918 r
.32555 .37108 .33223 .37851 .34289 .37529 .3362 .36824 Mtetra
.644 .742 .92 r
.3362 .36824 .34289 .37529 .35361 .37176 .34694 .36479 Mtetra
.651 .747 .92 r
.34694 .36479 .35361 .37176 .36437 .3681 .35773 .36115 Mtetra
.654 .75 .92 r
.35773 .36115 .36437 .3681 .37519 .36436 .36857 .35741 Mtetra
.657 .752 .92 r
.36857 .35741 .37519 .36436 .38605 .36056 .37946 .3536 Mtetra
.658 .753 .92 r
.37946 .3536 .38605 .36056 .39696 .35672 .39039 .34974 Mtetra
.659 .754 .92 r
.39039 .34974 .39696 .35672 .40791 .35284 .40137 .34584 Mtetra
.40137 .34584 .40791 .35284 .4189 .34895 .41239 .34192 Mtetra
.41239 .34192 .4189 .34895 .42994 .34504 .42346 .33798 Mtetra
.42346 .33798 .42994 .34504 .44102 .34113 .43457 .33404 Mtetra
.658 .753 .92 r
.43457 .33404 .44102 .34113 .45215 .33721 .44573 .33008 Mtetra
.44573 .33008 .45215 .33721 .46332 .33328 .45693 .32612 Mtetra
.45693 .32612 .46332 .33328 .47454 .32933 .46818 .32214 Mtetra
.46818 .32214 .47454 .32933 .48581 .32538 .47948 .31815 Mtetra
.47948 .31815 .48581 .32538 .49712 .32141 .49082 .31415 Mtetra
.49082 .31415 .49712 .32141 .50848 .31742 .50221 .31014 Mtetra
.50221 .31014 .50848 .31742 .51988 .31343 .51364 .30611 Mtetra
.657 .753 .92 r
.51364 .30611 .51988 .31343 .53133 .30942 .52513 .30207 Mtetra
.52513 .30207 .53133 .30942 .54283 .30539 .53666 .29801 Mtetra
.657 .752 .92 r
.53666 .29801 .54283 .30539 .55438 .30135 .54824 .29393 Mtetra
.54824 .29393 .55438 .30135 .56598 .29729 .55986 .28984 Mtetra
.55986 .28984 .56598 .29729 .57762 .29322 .57154 .28574 Mtetra
.57154 .28574 .57762 .29322 .58931 .28913 .58327 .28162 Mtetra
.58327 .28162 .58931 .28913 .60106 .28502 .59504 .27748 Mtetra
.59504 .27748 .60106 .28502 .61285 .2809 .60687 .27332 Mtetra
.60687 .27332 .61285 .2809 .62469 .27676 .61874 .26915 Mtetra
.61874 .26915 .62469 .27676 .63658 .2726 .63067 .26496 Mtetra
.63067 .26496 .63658 .2726 .64852 .26843 .64264 .26076 Mtetra
.64264 .26076 .64852 .26843 .66051 .26424 .65467 .25654 Mtetra
.65467 .25654 .66051 .26424 .67256 .26004 .66675 .2523 Mtetra
.66675 .2523 .67256 .26004 .68465 .25581 .67888 .24804 Mtetra
.67888 .24804 .68465 .25581 .6968 .25157 .69106 .24376 Mtetra
.69106 .24376 .6968 .25157 .709 .24731 .7033 .23947 Mtetra
.7033 .23947 .709 .24731 .72125 .24304 .71558 .23516 Mtetra
.71558 .23516 .72125 .24304 .73355 .23874 .72792 .23083 Mtetra
.72792 .23083 .73355 .23874 .74591 .23443 .74032 .22648 Mtetra
.74032 .22648 .74591 .23443 .75832 .2301 .75277 .22212 Mtetra
.75277 .22212 .75832 .2301 .77078 .22575 .76527 .21773 Mtetra
.715 .946 .648 r
.1019 .44825 .11099 .44039 .12003 .4434 .11293 .43582 Mtetra
.571 .687 .919 r
.11293 .43582 .12003 .4434 .12977 .44122 .12261 .43424 Mtetra
.599 .716 .927 r
.12261 .43424 .12977 .44122 .13947 .43978 .13241 .43205 Mtetra
0 .356 .827 r
.13241 .43205 .13947 .43978 .15037 .42827 .14141 .43705 Mtetra
.774 .952 .626 r
.14141 .43705 .15037 .42827 .15984 .42955 .15279 .42204 Mtetra
.585 .697 .919 r
.15279 .42204 .15984 .42955 .16977 .42712 .16268 .42014 Mtetra
.613 .724 .924 r
.16268 .42014 .16977 .42712 .17973 .42486 .17269 .41759 Mtetra
.537 .688 .936 r
.17269 .41759 .17973 .42486 .18604 .45836 .18258 .41653 Mtetra
.629 .447 .617 r
.18258 .41653 .18604 .45836 .20035 .41473 .19351 .40592 Mtetra
.523 .635 .902 r
.19351 .40592 .20035 .41473 .21043 .41244 .20343 .40537 Mtetra
.621 .726 .922 r
.20343 .40537 .21043 .41244 .22061 .40959 .21362 .40262 Mtetra
.624 .731 .924 r
.21362 .40262 .22061 .40959 .23081 .40705 .22386 .39978 Mtetra
.563 .701 .933 r
.22386 .39978 .23081 .40705 .23999 .41668 .23404 .39819 Mtetra
.72 .585 .703 r
.23404 .39819 .23999 .41668 .25181 .39654 .24511 .38697 Mtetra
.497 .605 .89 r
.24511 .38697 .25181 .39654 .26211 .39419 .25522 .38702 Mtetra
.626 .728 .921 r
.25522 .38702 .26211 .39419 .27253 .39107 .26564 .38408 Mtetra
.639 .739 .921 r
.26564 .38408 .27253 .39107 .283 .38781 .27613 .38083 Mtetra
.639 .74 .922 r
.27613 .38083 .283 .38781 .29351 .38462 .28667 .37754 Mtetra
.629 .735 .924 r
.28667 .37754 .29351 .38462 .30402 .38203 .29723 .37448 Mtetra
.521 .679 .937 r
.29723 .37448 .30402 .38203 .31728 .33831 .30769 .37364 Mtetra
.32 .03 .307 r
.30769 .37364 .31728 .33831 .32555 .37108 .31888 .36256 Mtetra
.566 .669 .908 r
.31888 .36256 .32555 .37108 .3362 .36824 .32947 .36101 Mtetra
.637 .736 .92 r
.32947 .36101 .3362 .36824 .34694 .36479 .34022 .35772 Mtetra
.648 .745 .92 r
.34022 .35772 .34694 .36479 .35773 .36115 .35104 .35412 Mtetra
.653 .749 .92 r
.35104 .35412 .35773 .36115 .36857 .35741 .3619 .35039 Mtetra
.656 .751 .92 r
.3619 .35039 .36857 .35741 .37946 .3536 .37281 .34658 Mtetra
.657 .752 .92 r
.37281 .34658 .37946 .3536 .39039 .34974 .38378 .3427 Mtetra
.658 .753 .92 r
.38378 .3427 .39039 .34974 .40137 .34584 .39478 .33878 Mtetra
.659 .754 .92 r
.39478 .33878 .40137 .34584 .41239 .34192 .40583 .33484 Mtetra
.40583 .33484 .41239 .34192 .42346 .33798 .41693 .33087 Mtetra
.41693 .33087 .42346 .33798 .43457 .33404 .42807 .32689 Mtetra
.659 .753 .92 r
.42807 .32689 .43457 .33404 .44573 .33008 .43926 .3229 Mtetra
.658 .753 .92 r
.43926 .3229 .44573 .33008 .45693 .32612 .45049 .3189 Mtetra
.45049 .3189 .45693 .32612 .46818 .32214 .46177 .3149 Mtetra
.46177 .3149 .46818 .32214 .47948 .31815 .4731 .31088 Mtetra
.4731 .31088 .47948 .31815 .49082 .31415 .48447 .30684 Mtetra
.48447 .30684 .49082 .31415 .50221 .31014 .49589 .3028 Mtetra
.49589 .3028 .50221 .31014 .51364 .30611 .50736 .29874 Mtetra
.657 .753 .92 r
.50736 .29874 .51364 .30611 .52513 .30207 .51887 .29466 Mtetra
.51887 .29466 .52513 .30207 .53666 .29801 .53043 .29057 Mtetra
.53043 .29057 .53666 .29801 .54824 .29393 .54204 .28646 Mtetra
.657 .752 .92 r
.54204 .28646 .54824 .29393 .55986 .28984 .55371 .28234 Mtetra
.55371 .28234 .55986 .28984 .57154 .28574 .56541 .2782 Mtetra
.56541 .2782 .57154 .28574 .58327 .28162 .57717 .27405 Mtetra
.57717 .27405 .58327 .28162 .59504 .27748 .58898 .26988 Mtetra
.58898 .26988 .59504 .27748 .60687 .27332 .60084 .26569 Mtetra
.60084 .26569 .60687 .27332 .61874 .26915 .61275 .26149 Mtetra
.61275 .26149 .61874 .26915 .63067 .26496 .62471 .25726 Mtetra
.62471 .25726 .63067 .26496 .64264 .26076 .63672 .25303 Mtetra
.63672 .25303 .64264 .26076 .65467 .25654 .64878 .24877 Mtetra
.64878 .24877 .65467 .25654 .66675 .2523 .6609 .2445 Mtetra
.6609 .2445 .66675 .2523 .67888 .24804 .67306 .2402 Mtetra
.67306 .2402 .67888 .24804 .69106 .24376 .68528 .2359 Mtetra
.68528 .2359 .69106 .24376 .7033 .23947 .69755 .23157 Mtetra
.69755 .23157 .7033 .23947 .71558 .23516 .70988 .22722 Mtetra
.70988 .22722 .71558 .23516 .72792 .23083 .72225 .22286 Mtetra
.72225 .22286 .72792 .23083 .74032 .22648 .73469 .21848 Mtetra
.73469 .21848 .74032 .22648 .75277 .22212 .74717 .21408 Mtetra
.74717 .21408 .75277 .22212 .76527 .21773 .75971 .20966 Mtetra
.791 .679 .741 r
.09519 .43705 .1019 .44825 .11293 .43582 .10631 .42414 Mtetra
.35 .47 .841 r
.10631 .42414 .11293 .43582 .12261 .43424 .11541 .42711 Mtetra
.6 .713 .924 r
.11541 .42711 .12261 .43424 .13241 .43205 .12523 .42488 Mtetra
.561 .699 .933 r
.12523 .42488 .13241 .43205 .14141 .43705 .13501 .42338 Mtetra
.758 .642 .732 r
.13501 .42338 .14141 .43705 .15279 .42204 .14602 .41177 Mtetra
.437 .553 .876 r
.14602 .41177 .15279 .42204 .16268 .42014 .15555 .413 Mtetra
.61 .719 .923 r
.15555 .413 .16268 .42014 .17269 .41759 .16557 .41051 Mtetra
.601 .719 .927 r
.16557 .41051 .17269 .41759 .18258 .41653 .17561 .40819 Mtetra
.943 .582 .272 r
.17561 .40819 .18258 .41653 .19351 .40592 .18193 .44178 Mtetra
0 0 0 r
.18193 .44178 .19351 .40592 .20343 .40537 .19641 .39792 Mtetra
.602 .71 .92 r
.19641 .39792 .20343 .40537 .21362 .40262 .20658 .39557 Mtetra
.626 .731 .923 r
.20658 .39557 .21362 .40262 .22386 .39978 .21685 .39266 Mtetra
.612 .725 .926 r
.21685 .39266 .22386 .39978 .23404 .39819 .22713 .39005 Mtetra
0 .016 .545 r
.22713 .39005 .23404 .39819 .24511 .38697 .23637 .39967 Mtetra
.738 .881 .474 r
.23637 .39967 .24511 .38697 .25522 .38702 .24832 .37939 Mtetra
.603 .708 .918 r
.24832 .37939 .25522 .38702 .26564 .38408 .25871 .37698 Mtetra
.635 .736 .921 r
.25871 .37698 .26564 .38408 .27613 .38083 .26922 .37379 Mtetra
.64 .74 .921 r
.26922 .37379 .27613 .38083 .28667 .37754 .27978 .37047 Mtetra
.637 .739 .922 r
.27978 .37047 .28667 .37754 .29723 .37448 .29038 .3672 Mtetra
.61 .725 .927 r
.29038 .3672 .29723 .37448 .30769 .37364 .30098 .36455 Mtetra
.923 .725 .617 r
.30098 .36455 .30769 .37364 .31888 .36256 .3144 .32061 Mtetra
0 0 .447 r
.3144 .32061 .31888 .36256 .32947 .36101 .32271 .35345 Mtetra
.621 .721 .918 r
.32271 .35345 .32947 .36101 .34022 .35772 .33346 .35053 Mtetra
.644 .742 .92 r
.33346 .35053 .34022 .35772 .35104 .35412 .34429 .34701 Mtetra
.651 .748 .92 r
.34429 .34701 .35104 .35412 .3619 .35039 .35518 .3433 Mtetra
.654 .75 .92 r
.35518 .3433 .3619 .35039 .37281 .34658 .36612 .33949 Mtetra
.657 .752 .92 r
.36612 .33949 .37281 .34658 .38378 .3427 .37711 .33561 Mtetra
.658 .753 .92 r
.37711 .33561 .38378 .3427 .39478 .33878 .38814 .33167 Mtetra
.659 .754 .92 r
.38814 .33167 .39478 .33878 .40583 .33484 .39922 .3277 Mtetra
.39922 .3277 .40583 .33484 .41693 .33087 .41035 .3237 Mtetra
.41035 .3237 .41693 .33087 .42807 .32689 .42152 .31969 Mtetra
.42152 .31969 .42807 .32689 .43926 .3229 .43274 .31567 Mtetra
.658 .753 .92 r
.43274 .31567 .43926 .3229 .45049 .3189 .444 .31164 Mtetra
.444 .31164 .45049 .3189 .46177 .3149 .45531 .30759 Mtetra
.45531 .30759 .46177 .3149 .4731 .31088 .46667 .30354 Mtetra
.46667 .30354 .4731 .31088 .48447 .30684 .47807 .29948 Mtetra
.47807 .29948 .48447 .30684 .49589 .3028 .48952 .2954 Mtetra
.48952 .2954 .49589 .3028 .50736 .29874 .50102 .2913 Mtetra
.50102 .2913 .50736 .29874 .51887 .29466 .51257 .2872 Mtetra
.657 .753 .92 r
.51257 .2872 .51887 .29466 .53043 .29057 .52416 .28307 Mtetra
.52416 .28307 .53043 .29057 .54204 .28646 .5358 .27893 Mtetra
.657 .752 .92 r
.5358 .27893 .54204 .28646 .55371 .28234 .5475 .27478 Mtetra
.5475 .27478 .55371 .28234 .56541 .2782 .55924 .27061 Mtetra
.55924 .27061 .56541 .2782 .57717 .27405 .57103 .26642 Mtetra
.57103 .26642 .57717 .27405 .58898 .26988 .58287 .26222 Mtetra
.58287 .26222 .58898 .26988 .60084 .26569 .59477 .258 Mtetra
.59477 .258 .60084 .26569 .61275 .26149 .60671 .25376 Mtetra
.60671 .25376 .61275 .26149 .62471 .25726 .6187 .2495 Mtetra
.6187 .2495 .62471 .25726 .63672 .25303 .63075 .24523 Mtetra
.63075 .24523 .63672 .25303 .64878 .24877 .64285 .24094 Mtetra
.64285 .24094 .64878 .24877 .6609 .2445 .655 .23663 Mtetra
.655 .23663 .6609 .2445 .67306 .2402 .6672 .23231 Mtetra
.6672 .23231 .67306 .2402 .68528 .2359 .67945 .22796 Mtetra
.67945 .22796 .68528 .2359 .69755 .23157 .69176 .2236 Mtetra
.69176 .2236 .69755 .23157 .70988 .22722 .70412 .21922 Mtetra
.70412 .21922 .70988 .22722 .72225 .22286 .71654 .21482 Mtetra
.71654 .21482 .72225 .22286 .73469 .21848 .72901 .2104 Mtetra
.72901 .2104 .73469 .21848 .74717 .21408 .74153 .20597 Mtetra
.74153 .20597 .74717 .21408 .75971 .20966 .75411 .20151 Mtetra
.243 .533 .92 r
.08797 .42941 .09519 .43705 .10631 .42414 .0971 .43194 Mtetra
.723 .951 .656 r
.0971 .43194 .10631 .42414 .11541 .42711 .10824 .41941 Mtetra
.571 .687 .919 r
.10824 .41941 .11541 .42711 .12523 .42488 .11799 .41778 Mtetra
.599 .716 .927 r
.11799 .41778 .12523 .42488 .13501 .42338 .12787 .41552 Mtetra
0 .358 .829 r
.12787 .41552 .13501 .42338 .14602 .41177 .13694 .4205 Mtetra
.781 .956 .633 r
.13694 .4205 .14602 .41177 .15555 .413 .14843 .40537 Mtetra
.585 .697 .919 r
.14843 .40537 .15555 .413 .16557 .41051 .1584 .40341 Mtetra
.613 .724 .924 r
.1584 .40341 .16557 .41051 .17561 .40819 .16849 .40081 Mtetra
.537 .688 .936 r
.16849 .40081 .17561 .40819 .18193 .44178 .17846 .39968 Mtetra
.628 .445 .616 r
.17846 .39968 .18193 .44178 .19641 .39792 .18949 .38898 Mtetra
.523 .635 .902 r
.18949 .38898 .19641 .39792 .20658 .39557 .1995 .38837 Mtetra
.621 .726 .922 r
.1995 .38837 .20658 .39557 .21685 .39266 .20978 .38556 Mtetra
.624 .731 .924 r
.20978 .38556 .21685 .39266 .22713 .39005 .22011 .38265 Mtetra
.564 .701 .933 r
.22011 .38265 .22713 .39005 .23637 .39967 .23037 .381 Mtetra
.72 .585 .703 r
.23037 .381 .23637 .39967 .24832 .37939 .24154 .36969 Mtetra
.497 .605 .89 r
.24154 .36969 .24832 .37939 .25871 .37698 .25174 .36968 Mtetra
.626 .728 .921 r
.25174 .36968 .25871 .37698 .26922 .37379 .26225 .36668 Mtetra
.639 .739 .921 r
.26225 .36668 .26922 .37379 .27978 .37047 .27284 .36336 Mtetra
.639 .74 .922 r
.27284 .36336 .27978 .37047 .29038 .3672 .28347 .36 Mtetra
.629 .735 .924 r
.28347 .36 .29038 .3672 .30098 .36455 .29413 .35687 Mtetra
.521 .679 .937 r
.29413 .35687 .30098 .36455 .3144 .32061 .30468 .35597 Mtetra
.312 .02 .298 r
.30468 .35597 .3144 .32061 .32271 .35345 .31597 .34479 Mtetra
.566 .669 .908 r
.31597 .34479 .32271 .35345 .33346 .35053 .32665 .34317 Mtetra
.637 .736 .92 r
.32665 .34317 .33346 .35053 .34429 .34701 .3375 .33981 Mtetra
.648 .745 .92 r
.3375 .33981 .34429 .34701 .35518 .3433 .34842 .33614 Mtetra
.653 .749 .92 r
.34842 .33614 .35518 .3433 .36612 .33949 .35938 .33234 Mtetra
.656 .751 .92 r
.35938 .33234 .36612 .33949 .37711 .33561 .37039 .32845 Mtetra
.657 .752 .92 r
.37039 .32845 .37711 .33561 .38814 .33167 .38146 .3245 Mtetra
.658 .753 .92 r
.38146 .3245 .38814 .33167 .39922 .3277 .39257 .32051 Mtetra
.659 .754 .92 r
.39257 .32051 .39922 .3277 .41035 .3237 .40372 .31648 Mtetra
.40372 .31648 .41035 .3237 .42152 .31969 .41492 .31244 Mtetra
.41492 .31244 .42152 .31969 .43274 .31567 .42617 .30838 Mtetra
.659 .753 .92 r
.42617 .30838 .43274 .31567 .444 .31164 .43746 .30431 Mtetra
.658 .753 .92 r
.43746 .30431 .444 .31164 .45531 .30759 .4488 .30024 Mtetra
.4488 .30024 .45531 .30759 .46667 .30354 .46019 .29615 Mtetra
.46019 .29615 .46667 .30354 .47807 .29948 .47162 .29205 Mtetra
.47162 .29205 .47807 .29948 .48952 .2954 .4831 .28794 Mtetra
.4831 .28794 .48952 .2954 .50102 .2913 .49463 .28382 Mtetra
.49463 .28382 .50102 .2913 .51257 .2872 .50621 .27968 Mtetra
.657 .753 .92 r
.50621 .27968 .51257 .2872 .52416 .28307 .51784 .27552 Mtetra
.51784 .27552 .52416 .28307 .5358 .27893 .52951 .27135 Mtetra
.52951 .27135 .5358 .27893 .5475 .27478 .54124 .26716 Mtetra
.657 .752 .92 r
.54124 .26716 .5475 .27478 .55924 .27061 .55302 .26296 Mtetra
.55302 .26296 .55924 .27061 .57103 .26642 .56484 .25873 Mtetra
.56484 .25873 .57103 .26642 .58287 .26222 .57672 .2545 Mtetra
.57672 .2545 .58287 .26222 .59477 .258 .58864 .25024 Mtetra
.58864 .25024 .59477 .258 .60671 .25376 .60062 .24597 Mtetra
.60062 .24597 .60671 .25376 .6187 .2495 .61265 .24168 Mtetra
.61265 .24168 .6187 .2495 .63075 .24523 .62473 .23737 Mtetra
.62473 .23737 .63075 .24523 .64285 .24094 .63686 .23305 Mtetra
.63686 .23305 .64285 .24094 .655 .23663 .64905 .22871 Mtetra
.64905 .22871 .655 .23663 .6672 .23231 .66129 .22435 Mtetra
.66129 .22435 .6672 .23231 .67945 .22796 .67358 .21997 Mtetra
.67358 .21997 .67945 .22796 .69176 .2236 .68592 .21557 Mtetra
.68592 .21557 .69176 .2236 .70412 .21922 .69832 .21115 Mtetra
.69832 .21115 .70412 .21922 .71654 .21482 .71078 .20672 Mtetra
.71078 .20672 .71654 .21482 .72901 .2104 .72328 .20226 Mtetra
.72328 .20226 .72901 .2104 .74153 .20597 .73585 .19779 Mtetra
.73585 .19779 .74153 .20597 .75411 .20151 .74846 .1933 Mtetra
.564 .7 .932 r
.08063 .42219 .08797 .42941 .0971 .43194 .09032 .42061 Mtetra
.791 .68 .741 r
.09032 .42061 .0971 .43194 .10824 .41941 .10155 .40759 Mtetra
.348 .469 .841 r
.10155 .40759 .10824 .41941 .11799 .41778 .11072 .41053 Mtetra
.6 .713 .924 r
.11072 .41053 .11799 .41778 .12787 .41552 .12062 .40823 Mtetra
.561 .699 .933 r
.12062 .40823 .12787 .41552 .13694 .4205 .13047 .40668 Mtetra
.759 .642 .732 r
.13047 .40668 .13694 .4205 .14843 .40537 .14159 .39497 Mtetra
.436 .553 .876 r
.14159 .39497 .14843 .40537 .1584 .40341 .15119 .39615 Mtetra
.61 .719 .923 r
.15119 .39615 .1584 .40341 .16849 .40081 .16129 .3936 Mtetra
.601 .719 .927 r
.16129 .3936 .16849 .40081 .17846 .39968 .17142 .39122 Mtetra
.943 .58 .267 r
.17142 .39122 .17846 .39968 .18949 .38898 .17774 .4249 Mtetra
0 0 0 r
.17774 .4249 .18949 .38898 .1995 .38837 .1924 .3808 Mtetra
.602 .71 .92 r
.1924 .3808 .1995 .38837 .20978 .38556 .20265 .37839 Mtetra
.626 .731 .923 r
.20265 .37839 .20978 .38556 .22011 .38265 .21301 .37541 Mtetra
.612 .725 .926 r
.21301 .37541 .22011 .38265 .23037 .381 .22339 .37274 Mtetra
0 .023 .551 r
.22339 .37274 .23037 .381 .24154 .36969 .23269 .38233 Mtetra
.745 .886 .482 r
.23269 .38233 .24154 .36969 .25174 .36968 .24476 .36192 Mtetra
.603 .708 .918 r
.24476 .36192 .25174 .36968 .26225 .36668 .25525 .35944 Mtetra
.635 .736 .921 r
.25525 .35944 .26225 .36668 .27284 .36336 .26584 .35619 Mtetra
.64 .74 .921 r
.26584 .35619 .27284 .36336 .28347 .36 .2765 .35279 Mtetra
.637 .739 .922 r
.2765 .35279 .28347 .36 .29413 .35687 .2872 .34946 Mtetra
.61 .724 .927 r
.2872 .34946 .29413 .35687 .30468 .35597 .29789 .34674 Mtetra
.924 .725 .616 r
.29789 .34674 .30468 .35597 .31597 .34479 .31147 .30257 Mtetra
0 0 .443 r
.31147 .30257 .31597 .34479 .32665 .34317 .31982 .33547 Mtetra
.621 .721 .918 r
.31982 .33547 .32665 .34317 .3375 .33981 .33067 .33249 Mtetra
.644 .742 .92 r
.33067 .33249 .3375 .33981 .34842 .33614 .3416 .32889 Mtetra
.651 .748 .92 r
.3416 .32889 .34842 .33614 .35938 .33234 .35259 .32511 Mtetra
.654 .75 .92 r
.35259 .32511 .35938 .33234 .37039 .32845 .36363 .32122 Mtetra
.657 .752 .92 r
.36363 .32122 .37039 .32845 .38146 .3245 .37472 .31727 Mtetra
.658 .753 .92 r
.37472 .31727 .38146 .3245 .39257 .32051 .38586 .31325 Mtetra
.659 .754 .92 r
.38586 .31325 .39257 .32051 .40372 .31648 .39704 .3092 Mtetra
.39704 .3092 .40372 .31648 .41492 .31244 .40827 .30513 Mtetra
.40827 .30513 .41492 .31244 .42617 .30838 .41955 .30104 Mtetra
.41955 .30104 .42617 .30838 .43746 .30431 .43087 .29694 Mtetra
.658 .753 .92 r
.43087 .29694 .43746 .30431 .4488 .30024 .44224 .29283 Mtetra
.44224 .29283 .4488 .30024 .46019 .29615 .45366 .28871 Mtetra
.45366 .28871 .46019 .29615 .47162 .29205 .46512 .28457 Mtetra
.46512 .28457 .47162 .29205 .4831 .28794 .47664 .28043 Mtetra
.47664 .28043 .4831 .28794 .49463 .28382 .4882 .27627 Mtetra
.4882 .27627 .49463 .28382 .50621 .27968 .49981 .2721 Mtetra
.49981 .2721 .50621 .27968 .51784 .27552 .51147 .26791 Mtetra
.657 .753 .92 r
.51147 .26791 .51784 .27552 .52951 .27135 .52318 .2637 Mtetra
.52318 .2637 .52951 .27135 .54124 .26716 .53493 .25948 Mtetra
.657 .752 .92 r
.53493 .25948 .54124 .26716 .55302 .26296 .54674 .25524 Mtetra
.54674 .25524 .55302 .26296 .56484 .25873 .5586 .25099 Mtetra
.5586 .25099 .56484 .25873 .57672 .2545 .57051 .24671 Mtetra
.57051 .24671 .57672 .2545 .58864 .25024 .58247 .24243 Mtetra
.58247 .24243 .58864 .25024 .60062 .24597 .59448 .23812 Mtetra
.59448 .23812 .60062 .24597 .61265 .24168 .60655 .2338 Mtetra
.60655 .2338 .61265 .24168 .62473 .23737 .61866 .22945 Mtetra
.61866 .22945 .62473 .23737 .63686 .23305 .63083 .22509 Mtetra
.63083 .22509 .63686 .23305 .64905 .22871 .64305 .22072 Mtetra
.64305 .22072 .64905 .22871 .66129 .22435 .65533 .21632 Mtetra
.65533 .21632 .66129 .22435 .67358 .21997 .66766 .21191 Mtetra
.66766 .21191 .67358 .21997 .68592 .21557 .68004 .20747 Mtetra
.68004 .20747 .68592 .21557 .69832 .21115 .69248 .20302 Mtetra
.69248 .20302 .69832 .21115 .71078 .20672 .70497 .19855 Mtetra
.70497 .19855 .71078 .20672 .72328 .20226 .71751 .19406 Mtetra
.71751 .19406 .72328 .20226 .73585 .19779 .73011 .18955 Mtetra
.73011 .18955 .73585 .19779 .74846 .1933 .74277 .18502 Mtetra
.591 .71 .926 r
.07325 .41495 .08063 .42219 .09032 .42061 .08301 .41284 Mtetra
.245 .533 .92 r
.08301 .41284 .09032 .42061 .10155 .40759 .09221 .41533 Mtetra
.73 .956 .664 r
.09221 .41533 .10155 .40759 .11072 .41053 .10346 .4027 Mtetra
.571 .687 .919 r
.10346 .4027 .11072 .41053 .12062 .40823 .11329 .40101 Mtetra
.599 .716 .926 r
.11329 .40101 .12062 .40823 .13047 .40668 .12325 .39869 Mtetra
0 .361 .83 r
.12325 .39869 .13047 .40668 .14159 .39497 .13238 .40363 Mtetra
.787 .959 .64 r
.13238 .40363 .14159 .39497 .15119 .39615 .14399 .38839 Mtetra
.585 .697 .919 r
.14399 .38839 .15119 .39615 .16129 .3936 .15404 .38637 Mtetra
.613 .724 .924 r
.15404 .38637 .16129 .3936 .17142 .39122 .16422 .3837 Mtetra
.537 .688 .936 r
.16422 .3837 .17142 .39122 .17774 .4249 .17427 .38252 Mtetra
.627 .443 .615 r
.17427 .38252 .17774 .4249 .1924 .3808 .18541 .37172 Mtetra
.522 .635 .903 r
.18541 .37172 .1924 .3808 .20265 .37839 .19549 .37106 Mtetra
.621 .726 .922 r
.19549 .37106 .20265 .37839 .21301 .37541 .20586 .36817 Mtetra
.624 .731 .924 r
.20586 .36817 .21301 .37541 .22339 .37274 .21628 .3652 Mtetra
.564 .701 .933 r
.21628 .3652 .22339 .37274 .23269 .38233 .22663 .36349 Mtetra
.721 .585 .703 r
.22663 .36349 .23269 .38233 .24476 .36192 .23791 .35207 Mtetra
.497 .605 .89 r
.23791 .35207 .24476 .36192 .25525 .35944 .2482 .35201 Mtetra
.626 .728 .921 r
.2482 .35201 .25525 .35944 .26584 .35619 .2588 .34894 Mtetra
.639 .739 .921 r
.2588 .34894 .26584 .35619 .2765 .35279 .26948 .34555 Mtetra
.639 .74 .922 r
.26948 .34555 .2765 .35279 .2872 .34946 .2802 .34212 Mtetra
.629 .735 .923 r
.2802 .34212 .2872 .34946 .29789 .34674 .29096 .33891 Mtetra
.522 .679 .937 r
.29096 .33891 .29789 .34674 .31147 .30257 .3016 .33795 Mtetra
.303 .009 .289 r
.3016 .33795 .31147 .30257 .31982 .33547 .313 .32667 Mtetra
.566 .669 .908 r
.313 .32667 .31982 .33547 .33067 .33249 .32378 .32499 Mtetra
.637 .736 .92 r
.32378 .32499 .33067 .33249 .3416 .32889 .33473 .32155 Mtetra
.648 .745 .92 r
.33473 .32155 .3416 .32889 .35259 .32511 .34574 .31781 Mtetra
.653 .749 .92 r
.34574 .31781 .35259 .32511 .36363 .32122 .35681 .31393 Mtetra
.656 .751 .92 r
.35681 .31393 .36363 .32122 .37472 .31727 .36793 .30997 Mtetra
.657 .752 .92 r
.36793 .30997 .37472 .31727 .38586 .31325 .37909 .30594 Mtetra
.658 .753 .92 r
.37909 .30594 .38586 .31325 .39704 .3092 .39031 .30187 Mtetra
.659 .754 .92 r
.39031 .30187 .39704 .3092 .40827 .30513 .40157 .29776 Mtetra
.40157 .29776 .40827 .30513 .41955 .30104 .41287 .29364 Mtetra
.41287 .29364 .41955 .30104 .43087 .29694 .42423 .28951 Mtetra
.659 .753 .92 r
.42423 .28951 .43087 .29694 .44224 .29283 .43563 .28536 Mtetra
.658 .753 .92 r
.43563 .28536 .44224 .29283 .45366 .28871 .44708 .2812 Mtetra
.44708 .2812 .45366 .28871 .46512 .28457 .45857 .27704 Mtetra
.45857 .27704 .46512 .28457 .47664 .28043 .47012 .27286 Mtetra
.47012 .27286 .47664 .28043 .4882 .27627 .48171 .26866 Mtetra
.48171 .26866 .4882 .27627 .49981 .2721 .49335 .26446 Mtetra
.49335 .26446 .49981 .2721 .51147 .26791 .50504 .26023 Mtetra
.657 .753 .92 r
.50504 .26023 .51147 .26791 .52318 .2637 .51679 .25599 Mtetra
.51679 .25599 .52318 .2637 .53493 .25948 .52858 .25174 Mtetra
.52858 .25174 .53493 .25948 .54674 .25524 .54042 .24747 Mtetra
.657 .752 .92 r
.54042 .24747 .54674 .25524 .5586 .25099 .55231 .24318 Mtetra
.55231 .24318 .5586 .25099 .57051 .24671 .56426 .23887 Mtetra
.56426 .23887 .57051 .24671 .58247 .24243 .57625 .23455 Mtetra
.57625 .23455 .58247 .24243 .59448 .23812 .5883 .23021 Mtetra
.5883 .23021 .59448 .23812 .60655 .2338 .6004 .22585 Mtetra
.6004 .22585 .60655 .2338 .61866 .22945 .61255 .22147 Mtetra
.61255 .22147 .61866 .22945 .63083 .22509 .62475 .21708 Mtetra
.62475 .21708 .63083 .22509 .64305 .22072 .63701 .21266 Mtetra
.63701 .21266 .64305 .22072 .65533 .21632 .64932 .20823 Mtetra
.64932 .20823 .65533 .21632 .66766 .21191 .66169 .20378 Mtetra
.66169 .20378 .66766 .21191 .68004 .20747 .67411 .19931 Mtetra
.67411 .19931 .68004 .20747 .69248 .20302 .68658 .19482 Mtetra
.68658 .19482 .69248 .20302 .70497 .19855 .69911 .19031 Mtetra
.69911 .19031 .70497 .19855 .71751 .19406 .71169 .18579 Mtetra
.71169 .18579 .71751 .19406 .73011 .18955 .72433 .18124 Mtetra
.72433 .18124 .73011 .18955 .74277 .18502 .73703 .17667 Mtetra
.577 .695 .922 r
.06586 .40732 .07325 .41495 .08301 .41284 .07559 .40549 Mtetra
.564 .7 .932 r
.07559 .40549 .08301 .41284 .09221 .41533 .08536 .40385 Mtetra
.792 .68 .742 r
.08536 .40385 .09221 .41533 .10346 .4027 .09669 .39074 Mtetra
.347 .468 .841 r
.09669 .39074 .10346 .4027 .11329 .40101 .10593 .39363 Mtetra
.6 .713 .924 r
.10593 .39363 .11329 .40101 .12325 .39869 .11591 .39127 Mtetra
.561 .699 .933 r
.11591 .39127 .12325 .39869 .13238 .40363 .12585 .38966 Mtetra
.759 .643 .733 r
.12585 .38966 .13238 .40363 .14399 .38839 .13707 .37785 Mtetra
.436 .553 .876 r
.13707 .37785 .14399 .38839 .15404 .38637 .14675 .37898 Mtetra
.61 .719 .923 r
.14675 .37898 .15404 .38637 .16422 .3837 .15694 .37637 Mtetra
.601 .719 .927 r
.15694 .37637 .16422 .3837 .17427 .38252 .16715 .37392 Mtetra
.942 .578 .261 r
.16715 .37392 .17427 .38252 .18541 .37172 .17347 .40768 Mtetra
0 0 0 r
.17347 .40768 .18541 .37172 .19549 .37106 .18831 .36335 Mtetra
.602 .71 .92 r
.18831 .36335 .19549 .37106 .20586 .36817 .19866 .36087 Mtetra
.626 .731 .923 r
.19866 .36087 .20586 .36817 .21628 .3652 .2091 .35782 Mtetra
.612 .725 .926 r
.2091 .35782 .21628 .3652 .22663 .36349 .21957 .35509 Mtetra
0 .029 .558 r
.21957 .35509 .22663 .36349 .23791 .35207 .22894 .36466 Mtetra
.753 .892 .49 r
.22894 .36466 .23791 .35207 .2482 .35201 .24114 .34411 Mtetra
.603 .708 .918 r
.24114 .34411 .2482 .35201 .2588 .34894 .25171 .34157 Mtetra
.635 .736 .921 r
.25171 .34157 .2588 .34894 .26948 .34555 .26241 .33824 Mtetra
.64 .74 .921 r
.26241 .33824 .26948 .34555 .2802 .34212 .27316 .33477 Mtetra
.637 .739 .922 r
.27316 .33477 .2802 .34212 .29096 .33891 .28395 .33137 Mtetra
.61 .724 .926 r
.28395 .33137 .29096 .33891 .3016 .33795 .29474 .32858 Mtetra
.925 .726 .615 r
.29474 .32858 .3016 .33795 .313 .32667 .30848 .28418 Mtetra
0 0 .44 r
.30848 .28418 .313 .32667 .32378 .32499 .31687 .31715 Mtetra
.621 .721 .919 r
.31687 .31715 .32378 .32499 .33473 .32155 .32782 .31409 Mtetra
.644 .742 .92 r
.32782 .31409 .33473 .32155 .34574 .31781 .33885 .31042 Mtetra
.651 .748 .92 r
.33885 .31042 .34574 .31781 .35681 .31393 .34994 .30656 Mtetra
.654 .75 .92 r
.34994 .30656 .35681 .31393 .36793 .30997 .36109 .3026 Mtetra
.657 .752 .92 r
.36109 .3026 .36793 .30997 .37909 .30594 .37228 .29856 Mtetra
.658 .753 .92 r
.37228 .29856 .37909 .30594 .39031 .30187 .38352 .29447 Mtetra
.659 .754 .92 r
.38352 .29447 .39031 .30187 .40157 .29776 .39481 .29034 Mtetra
.39481 .29034 .40157 .29776 .41287 .29364 .40615 .28619 Mtetra
.40615 .28619 .41287 .29364 .42423 .28951 .41753 .28202 Mtetra
.41753 .28202 .42423 .28951 .43563 .28536 .42896 .27784 Mtetra
.658 .753 .92 r
.42896 .27784 .43563 .28536 .44708 .2812 .44044 .27364 Mtetra
.44044 .27364 .44708 .2812 .45857 .27704 .45197 .26944 Mtetra
.45197 .26944 .45857 .27704 .47012 .27286 .46355 .26523 Mtetra
.46355 .26523 .47012 .27286 .48171 .26866 .47517 .261 Mtetra
.47517 .261 .48171 .26866 .49335 .26446 .48685 .25676 Mtetra
.48685 .25676 .49335 .26446 .50504 .26023 .49857 .2525 Mtetra
.49857 .2525 .50504 .26023 .51679 .25599 .51035 .24823 Mtetra
.657 .753 .92 r
.51035 .24823 .51679 .25599 .52858 .25174 .52217 .24394 Mtetra
.52217 .24394 .52858 .25174 .54042 .24747 .53405 .23963 Mtetra
.657 .752 .92 r
.53405 .23963 .54042 .24747 .55231 .24318 .54597 .2353 Mtetra
.54597 .2353 .55231 .24318 .56426 .23887 .55795 .23096 Mtetra
.55795 .23096 .56426 .23887 .57625 .23455 .56998 .22661 Mtetra
.56998 .22661 .57625 .23455 .5883 .23021 .58206 .22223 Mtetra
.58206 .22223 .5883 .23021 .6004 .22585 .5942 .21783 Mtetra
.5942 .21783 .6004 .22585 .61255 .22147 .60638 .21342 Mtetra
.60638 .21342 .61255 .22147 .62475 .21708 .61862 .20899 Mtetra
.61862 .20899 .62475 .21708 .63701 .21266 .63092 .20454 Mtetra
.63092 .20454 .63701 .21266 .64932 .20823 .64327 .20007 Mtetra
.64327 .20007 .64932 .20823 .66169 .20378 .65567 .19559 Mtetra
.65567 .19559 .66169 .20378 .67411 .19931 .66813 .19108 Mtetra
.66813 .19108 .67411 .19931 .68658 .19482 .68064 .18656 Mtetra
.68064 .18656 .68658 .19482 .69911 .19031 .6932 .18201 Mtetra
.6932 .18201 .69911 .19031 .71169 .18579 .70583 .17745 Mtetra
.70583 .17745 .71169 .18579 .72433 .18124 .71851 .17286 Mtetra
.71851 .17286 .72433 .18124 .73703 .17667 .73124 .16826 Mtetra
.46 .587 .893 r
.05871 .39763 .06586 .40732 .07559 .40549 .06812 .39813 Mtetra
.591 .71 .926 r
.06812 .39813 .07559 .40549 .08536 .40385 .07797 .39596 Mtetra
.247 .534 .92 r
.07797 .39596 .08536 .40385 .09669 .39074 .08723 .39841 Mtetra
.738 .96 .672 r
.08723 .39841 .09669 .39074 .10593 .39363 .09859 .38567 Mtetra
.571 .687 .919 r
.09859 .38567 .10593 .39363 .11591 .39127 .1085 .38392 Mtetra
.599 .716 .926 r
.1085 .38392 .11591 .39127 .12585 .38966 .11855 .38154 Mtetra
0 .364 .832 r
.11855 .38154 .12585 .38966 .13707 .37785 .12774 .38645 Mtetra
.793 .962 .646 r
.12774 .38645 .13707 .37785 .14675 .37898 .13946 .37109 Mtetra
.585 .697 .919 r
.13946 .37109 .14675 .37898 .15694 .37637 .1496 .36901 Mtetra
.613 .724 .924 r
.1496 .36901 .15694 .37637 .16715 .37392 .15986 .36627 Mtetra
.537 .688 .936 r
.15986 .36627 .16715 .37392 .17347 .40768 .17 .36503 Mtetra
.626 .441 .613 r
.17 .36503 .17347 .40768 .18831 .36335 .18124 .35413 Mtetra
.522 .635 .903 r
.18124 .35413 .18831 .36335 .19866 .36087 .19141 .35341 Mtetra
.621 .726 .922 r
.19141 .35341 .19866 .36087 .2091 .35782 .20187 .35046 Mtetra
.624 .731 .924 r
.20187 .35046 .2091 .35782 .21957 .35509 .21238 .34742 Mtetra
.564 .701 .933 r
.21238 .34742 .21957 .35509 .22894 .36466 .22282 .34564 Mtetra
.721 .585 .703 r
.22282 .34564 .22894 .36466 .24114 .34411 .23421 .33412 Mtetra
.496 .605 .891 r
.23421 .33412 .24114 .34411 .25171 .34157 .24458 .334 Mtetra
.626 .728 .921 r
.24458 .334 .25171 .34157 .26241 .33824 .25528 .33085 Mtetra
.639 .739 .921 r
.25528 .33085 .26241 .33824 .27316 .33477 .26605 .32739 Mtetra
.639 .74 .922 r
.26605 .32739 .27316 .33477 .28395 .33137 .27688 .32389 Mtetra
.63 .735 .923 r
.27688 .32389 .28395 .33137 .29474 .32858 .28773 .32061 Mtetra
.522 .679 .936 r
.28773 .32061 .29474 .32858 .30848 .28418 .29847 .31959 Mtetra
.294 0 .28 r
.29847 .31959 .30848 .28418 .31687 .31715 .30998 .3082 Mtetra
.566 .669 .908 r
.30998 .3082 .31687 .31715 .32782 .31409 .32086 .30645 Mtetra
.637 .736 .92 r
.32086 .30645 .32782 .31409 .33885 .31042 .33191 .30294 Mtetra
.648 .745 .92 r
.33191 .30294 .33885 .31042 .34994 .30656 .34302 .29912 Mtetra
.653 .749 .92 r
.34302 .29912 .34994 .30656 .36109 .3026 .35419 .29516 Mtetra
.656 .751 .92 r
.35419 .29516 .36109 .3026 .37228 .29856 .36541 .29112 Mtetra
.657 .752 .92 r
.36541 .29112 .37228 .29856 .38352 .29447 .37668 .28701 Mtetra
.658 .753 .92 r
.37668 .28701 .38352 .29447 .39481 .29034 .388 .28286 Mtetra
.659 .754 .92 r
.388 .28286 .39481 .29034 .40615 .28619 .39937 .27867 Mtetra
.39937 .27867 .40615 .28619 .41753 .28202 .41078 .27447 Mtetra
.41078 .27447 .41753 .28202 .42896 .27784 .42225 .27025 Mtetra
.659 .753 .92 r
.42225 .27025 .42896 .27784 .44044 .27364 .43376 .26603 Mtetra
.658 .753 .92 r
.43376 .26603 .44044 .27364 .45197 .26944 .44532 .26179 Mtetra
.44532 .26179 .45197 .26944 .46355 .26523 .45692 .25754 Mtetra
.45692 .25754 .46355 .26523 .47517 .261 .46858 .25327 Mtetra
.46858 .25327 .47517 .261 .48685 .25676 .48029 .249 Mtetra
.48029 .249 .48685 .25676 .49857 .2525 .49205 .2447 Mtetra
.49205 .2447 .49857 .2525 .51035 .24823 .50385 .2404 Mtetra
.657 .753 .92 r
.50385 .2404 .51035 .24823 .52217 .24394 .51571 .23607 Mtetra
.51571 .23607 .52217 .24394 .53405 .23963 .52762 .23173 Mtetra
.52762 .23173 .53405 .23963 .54597 .2353 .53958 .22737 Mtetra
.657 .752 .92 r
.53958 .22737 .54597 .2353 .55795 .23096 .55159 .22299 Mtetra
.55159 .22299 .55795 .23096 .56998 .22661 .56366 .2186 Mtetra
.56366 .2186 .56998 .22661 .58206 .22223 .57578 .21419 Mtetra
.57578 .21419 .58206 .22223 .5942 .21783 .58795 .20976 Mtetra
.58795 .20976 .5942 .21783 .60638 .21342 .60017 .20531 Mtetra
.60017 .20531 .60638 .21342 .61862 .20899 .61245 .20084 Mtetra
.61245 .20084 .61862 .20899 .63092 .20454 .62478 .19636 Mtetra
.62478 .19636 .63092 .20454 .64327 .20007 .63716 .19185 Mtetra
.63716 .19185 .64327 .20007 .65567 .19559 .6496 .18733 Mtetra
.6496 .18733 .65567 .19559 .66813 .19108 .6621 .18278 Mtetra
.6621 .18278 .66813 .19108 .68064 .18656 .67465 .17822 Mtetra
.67465 .17822 .68064 .18656 .6932 .18201 .68725 .17364 Mtetra
.68725 .17364 .6932 .18201 .70583 .17745 .69991 .16904 Mtetra
.69991 .16904 .70583 .17745 .71851 .17286 .71263 .16441 Mtetra
.71263 .16441 .71851 .17286 .73124 .16826 .72541 .15977 Mtetra
.833 .95 .598 r
.04829 .40979 .05871 .39763 .06812 .39813 .06065 .39038 Mtetra
.577 .695 .922 r
.06065 .39038 .06812 .39813 .07797 .39596 .07046 .38849 Mtetra
.564 .7 .932 r
.07046 .38849 .07797 .39596 .08723 .39841 .0803 .38679 Mtetra
.792 .681 .742 r
.0803 .38679 .08723 .39841 .09859 .38567 .09175 .37356 Mtetra
.346 .468 .841 r
.09175 .37356 .09859 .38567 .1085 .38392 .10105 .37641 Mtetra
.6 .713 .924 r
.10105 .37641 .1085 .38392 .11855 .38154 .11112 .37399 Mtetra
.561 .699 .933 r
.11112 .37399 .11855 .38154 .12774 .38645 .12113 .37232 Mtetra
.759 .643 .733 r
.12113 .37232 .12774 .38645 .13946 .37109 .13247 .3604 Mtetra
.435 .553 .876 r
.13247 .3604 .13946 .37109 .1496 .36901 .14222 .36149 Mtetra
.61 .719 .923 r
.14222 .36149 .1496 .36901 .15986 .36627 .15249 .3588 Mtetra
.601 .719 .927 r
.15249 .3588 .15986 .36627 .17 .36503 .16279 .35629 Mtetra
.942 .576 .255 r
.16279 .35629 .17 .36503 .18124 .35413 .16911 .39014 Mtetra
0 0 0 r
.16911 .39014 .18124 .35413 .19141 .35341 .18415 .34556 Mtetra
.602 .71 .92 r
.18415 .34556 .19141 .35341 .20187 .35046 .19458 .34302 Mtetra
.626 .731 .923 r
.19458 .34302 .20187 .35046 .21238 .34742 .20512 .3399 Mtetra
.612 .725 .926 r
.20512 .3399 .21238 .34742 .22282 .34564 .21568 .33709 Mtetra
0 .035 .565 r
.21568 .33709 .22282 .34564 .23421 .33412 .22511 .34665 Mtetra
.76 .897 .498 r
.22511 .34665 .23421 .33412 .24458 .334 .23744 .32596 Mtetra
.603 .708 .918 r
.23744 .32596 .24458 .334 .25528 .33085 .24811 .32335 Mtetra
.635 .736 .921 r
.24811 .32335 .25528 .33085 .26605 .32739 .2589 .31995 Mtetra
.64 .74 .921 r
.2589 .31995 .26605 .32739 .27688 .32389 .26975 .3164 Mtetra
.637 .739 .922 r
.26975 .3164 .27688 .32389 .28773 .32061 .28064 .31292 Mtetra
.61 .724 .926 r
.28064 .31292 .28773 .32061 .29847 .31959 .29153 .31006 Mtetra
.926 .727 .613 r
.29153 .31006 .29847 .31959 .30998 .3082 .30544 .26543 Mtetra
0 0 .436 r
.30544 .26543 .30998 .3082 .32086 .30645 .31387 .29846 Mtetra
.621 .722 .919 r
.31387 .29846 .32086 .30645 .33191 .30294 .32491 .29533 Mtetra
.644 .742 .92 r
.32491 .29533 .33191 .30294 .34302 .29912 .33605 .29158 Mtetra
.651 .748 .92 r
.33605 .29158 .34302 .29912 .35419 .29516 .34724 .28765 Mtetra
.654 .75 .92 r
.34724 .28765 .35419 .29516 .36541 .29112 .35849 .2836 Mtetra
.657 .752 .92 r
.35849 .2836 .36541 .29112 .37668 .28701 .36979 .27949 Mtetra
.658 .753 .92 r
.36979 .27949 .37668 .28701 .388 .28286 .38114 .27531 Mtetra
.659 .754 .92 r
.38114 .27531 .388 .28286 .39937 .27867 .39254 .2711 Mtetra
.39254 .2711 .39937 .27867 .41078 .27447 .40398 .26687 Mtetra
.40398 .26687 .41078 .27447 .42225 .27025 .41548 .26261 Mtetra
.41548 .26261 .42225 .27025 .43376 .26603 .42702 .25835 Mtetra
.658 .753 .92 r
.42702 .25835 .43376 .26603 .44532 .26179 .43861 .25407 Mtetra
.43861 .25407 .44532 .26179 .45692 .25754 .45025 .24979 Mtetra
.45025 .24979 .45692 .25754 .46858 .25327 .46194 .24549 Mtetra
.46194 .24549 .46858 .25327 .48029 .249 .47368 .24118 Mtetra
.47368 .24118 .48029 .249 .49205 .2447 .48547 .23685 Mtetra
.48547 .23685 .49205 .2447 .50385 .2404 .49731 .2325 Mtetra
.49731 .2325 .50385 .2404 .51571 .23607 .5092 .22814 Mtetra
.657 .753 .92 r
.5092 .22814 .51571 .23607 .52762 .23173 .52114 .22377 Mtetra
.52114 .22377 .52762 .23173 .53958 .22737 .53314 .21937 Mtetra
.657 .752 .92 r
.53314 .21937 .53958 .22737 .55159 .22299 .54519 .21496 Mtetra
.54519 .21496 .55159 .22299 .56366 .2186 .55729 .21053 Mtetra
.55729 .21053 .56366 .2186 .57578 .21419 .56944 .20608 Mtetra
.56944 .20608 .57578 .21419 .58795 .20976 .58164 .20162 Mtetra
.58164 .20162 .58795 .20976 .60017 .20531 .5939 .19713 Mtetra
.5939 .19713 .60017 .20531 .61245 .20084 .60622 .19263 Mtetra
.60622 .19263 .61245 .20084 .62478 .19636 .61858 .1881 Mtetra
.61858 .1881 .62478 .19636 .63716 .19185 .63101 .18356 Mtetra
.63101 .18356 .63716 .19185 .6496 .18733 .64348 .179 Mtetra
.64348 .179 .6496 .18733 .6621 .18278 .65602 .17442 Mtetra
.65602 .17442 .6621 .18278 .67465 .17822 .6686 .16982 Mtetra
.6686 .16982 .67465 .17822 .68725 .17364 .68125 .1652 Mtetra
.68125 .1652 .68725 .17364 .69991 .16904 .69395 .16056 Mtetra
.69395 .16056 .69991 .16904 .71263 .16441 .70671 .1559 Mtetra
.70671 .1559 .71263 .16441 .72541 .15977 .71952 .15122 Mtetra
.719 .587 .706 r
.04228 .39153 .04829 .40979 .06065 .39038 .05342 .38055 Mtetra
.46 .587 .893 r
.05342 .38055 .06065 .39038 .07046 .38849 .0629 .38099 Mtetra
.591 .71 .926 r
.0629 .38099 .07046 .38849 .0803 .38679 .07283 .37876 Mtetra
.249 .535 .92 r
.07283 .37876 .0803 .38679 .09175 .37356 .08216 .38117 Mtetra
.745 .964 .68 r
.08216 .38117 .09175 .37356 .10105 .37641 .09363 .36832 Mtetra
.571 .687 .919 r
.09363 .36832 .10105 .37641 .11112 .37399 .10362 .36651 Mtetra
.599 .716 .926 r
.10362 .36651 .11112 .37399 .12113 .37232 .11375 .36407 Mtetra
0 .366 .834 r
.11375 .36407 .12113 .37232 .13247 .3604 .123 .36894 Mtetra
.798 .965 .653 r
.123 .36894 .13247 .3604 .14222 .36149 .13485 .35346 Mtetra
.585 .697 .919 r
.13485 .35346 .14222 .36149 .15249 .3588 .14507 .35132 Mtetra
.613 .724 .924 r
.14507 .35132 .15249 .3588 .16279 .35629 .15542 .34851 Mtetra
.538 .688 .936 r
.15542 .34851 .16279 .35629 .16911 .39014 .16565 .3472 Mtetra
.624 .44 .612 r
.16565 .3472 .16911 .39014 .18415 .34556 .177 .3362 Mtetra
.522 .635 .903 r
.177 .3362 .18415 .34556 .19458 .34302 .18725 .33542 Mtetra
.621 .726 .922 r
.18725 .33542 .19458 .34302 .20512 .3399 .1978 .3324 Mtetra
.624 .731 .924 r
.1978 .3324 .20512 .3399 .21568 .33709 .2084 .32929 Mtetra
.564 .701 .933 r
.2084 .32929 .21568 .33709 .22511 .34665 .21893 .32744 Mtetra
.721 .585 .703 r
.21893 .32744 .22511 .34665 .23744 .32596 .23044 .31582 Mtetra
.496 .604 .891 r
.23044 .31582 .23744 .32596 .24811 .32335 .2409 .31563 Mtetra
.626 .728 .921 r
.2409 .31563 .24811 .32335 .2589 .31995 .25169 .31242 Mtetra
.639 .739 .921 r
.25169 .31242 .2589 .31995 .26975 .3164 .26256 .30888 Mtetra
.639 .74 .922 r
.26256 .30888 .26975 .3164 .28064 .31292 .27348 .3053 Mtetra
.63 .735 .923 r
.27348 .3053 .28064 .31292 .29153 .31006 .28443 .30195 Mtetra
.522 .679 .936 r
.28443 .30195 .29153 .31006 .30544 .26543 .29527 .30086 Mtetra
.285 0 .27 r
.29527 .30086 .30544 .26543 .31387 .29846 .3069 .28936 Mtetra
.565 .669 .908 r
.3069 .28936 .31387 .29846 .32491 .29533 .31787 .28754 Mtetra
.637 .736 .92 r
.31787 .28754 .32491 .29533 .33605 .29158 .32902 .28395 Mtetra
.648 .745 .92 r
.32902 .28395 .33605 .29158 .34724 .28765 .34024 .28005 Mtetra
.653 .749 .92 r
.34024 .28005 .34724 .28765 .35849 .2836 .35152 .27602 Mtetra
.656 .751 .92 r
.35152 .27602 .35849 .2836 .36979 .27949 .36285 .27189 Mtetra
.657 .752 .92 r
.36285 .27189 .36979 .27949 .38114 .27531 .37422 .2677 Mtetra
.658 .753 .92 r
.37422 .2677 .38114 .27531 .39254 .2711 .38565 .26347 Mtetra
.659 .754 .92 r
.38565 .26347 .39254 .2711 .40398 .26687 .39713 .2592 Mtetra
.39713 .2592 .40398 .26687 .41548 .26261 .40865 .25491 Mtetra
.40865 .25491 .41548 .26261 .42702 .25835 .42023 .25061 Mtetra
.659 .753 .92 r
.42023 .25061 .42702 .25835 .43861 .25407 .43185 .2463 Mtetra
.658 .753 .92 r
.43185 .2463 .43861 .25407 .45025 .24979 .44352 .24198 Mtetra
.44352 .24198 .45025 .24979 .46194 .24549 .45524 .23764 Mtetra
.45524 .23764 .46194 .24549 .47368 .24118 .46702 .23329 Mtetra
.46702 .23329 .47368 .24118 .48547 .23685 .47884 .22893 Mtetra
.47884 .22893 .48547 .23685 .49731 .2325 .49071 .22455 Mtetra
.49071 .22455 .49731 .2325 .5092 .22814 .50264 .22015 Mtetra
.657 .753 .92 r
.50264 .22015 .5092 .22814 .52114 .22377 .51462 .21574 Mtetra
.51462 .21574 .52114 .22377 .53314 .21937 .52664 .21131 Mtetra
.52664 .21131 .53314 .21937 .54519 .21496 .53873 .20686 Mtetra
.657 .752 .92 r
.53873 .20686 .54519 .21496 .55729 .21053 .55086 .20239 Mtetra
.55086 .20239 .55729 .21053 .56944 .20608 .56305 .19791 Mtetra
.56305 .19791 .56944 .20608 .58164 .20162 .57529 .19341 Mtetra
.57529 .19341 .58164 .20162 .5939 .19713 .58759 .18888 Mtetra
.58759 .18888 .5939 .19713 .60622 .19263 .59994 .18434 Mtetra
.59994 .18434 .60622 .19263 .61858 .1881 .61234 .17978 Mtetra
.61234 .17978 .61858 .1881 .63101 .18356 .6248 .1752 Mtetra
.6248 .1752 .63101 .18356 .64348 .179 .63731 .1706 Mtetra
.63731 .1706 .64348 .179 .65602 .17442 .64988 .16599 Mtetra
.64988 .16599 .65602 .17442 .6686 .16982 .66251 .16135 Mtetra
.66251 .16135 .6686 .16982 .68125 .1652 .6752 .15669 Mtetra
.6752 .15669 .68125 .1652 .69395 .16056 .68794 .15201 Mtetra
.68794 .15201 .69395 .16056 .70671 .1559 .70073 .14731 Mtetra
.70073 .14731 .70671 .1559 .71952 .15122 .71359 .14259 Mtetra
.561 .076 0 r
.03475 .38318 .04228 .39153 .05342 .38055 .04285 .39266 Mtetra
.838 .952 .604 r
.04285 .39266 .05342 .38055 .0629 .38099 .05534 .37311 Mtetra
.577 .695 .922 r
.05534 .37311 .0629 .38099 .07283 .37876 .06523 .37116 Mtetra
.564 .7 .932 r
.06523 .37116 .07283 .37876 .08216 .38117 .07515 .3694 Mtetra
.793 .682 .742 r
.07515 .3694 .08216 .38117 .09363 .36832 .08671 .35606 Mtetra
.344 .467 .841 r
.08671 .35606 .09363 .36832 .10362 .36651 .09608 .35887 Mtetra
.6 .713 .924 r
.09608 .35887 .10362 .36651 .11375 .36407 .10623 .35638 Mtetra
.561 .699 .933 r
.10623 .35638 .11375 .36407 .123 .36894 .11633 .35464 Mtetra
.76 .644 .733 r
.11633 .35464 .123 .36894 .13485 .35346 .12777 .34263 Mtetra
.434 .553 .876 r
.12777 .34263 .13485 .35346 .14507 .35132 .13761 .34366 Mtetra
.61 .719 .923 r
.13761 .34366 .14507 .35132 .15542 .34851 .14797 .3409 Mtetra
.601 .719 .927 r
.14797 .3409 .15542 .34851 .16565 .3472 .15835 .33832 Mtetra
.941 .574 .25 r
.15835 .33832 .16565 .3472 .177 .3362 .16467 .37225 Mtetra
.677 .738 .234 r
.16467 .37225 .177 .3362 .18725 .33542 .1799 .32744 Mtetra
.602 .71 .92 r
.1799 .32744 .18725 .33542 .1978 .3324 .19043 .32482 Mtetra
.626 .731 .923 r
.19043 .32482 .1978 .3324 .2084 .32929 .20106 .32163 Mtetra
.612 .725 .926 r
.20106 .32163 .2084 .32929 .21893 .32744 .21171 .31875 Mtetra
0 .041 .572 r
.21171 .31875 .21893 .32744 .23044 .31582 .22121 .32829 Mtetra
.767 .902 .506 r
.22121 .32829 .23044 .31582 .2409 .31563 .23367 .30745 Mtetra
.603 .708 .918 r
.23367 .30745 .2409 .31563 .25169 .31242 .24444 .30477 Mtetra
.635 .736 .921 r
.24444 .30477 .25169 .31242 .26256 .30888 .25532 .30129 Mtetra
.64 .74 .921 r
.25532 .30129 .26256 .30888 .27348 .3053 .26627 .29767 Mtetra
.637 .739 .922 r
.26627 .29767 .27348 .3053 .28443 .30195 .27726 .29411 Mtetra
.61 .724 .926 r
.27726 .29411 .28443 .30195 .29527 .30086 .28825 .29118 Mtetra
.928 .728 .612 r
.28825 .29118 .29527 .30086 .3069 .28936 .30234 .24632 Mtetra
0 0 .432 r
.30234 .24632 .3069 .28936 .31787 .28754 .3108 .27941 Mtetra
.62 .722 .919 r
.3108 .27941 .31787 .28754 .32902 .28395 .32195 .2762 Mtetra
.644 .742 .92 r
.32195 .2762 .32902 .28395 .34024 .28005 .33319 .27237 Mtetra
.651 .748 .92 r
.33319 .27237 .34024 .28005 .35152 .27602 .34449 .26835 Mtetra
.654 .75 .92 r
.34449 .26835 .35152 .27602 .36285 .27189 .35585 .26423 Mtetra
.657 .752 .92 r
.35585 .26423 .36285 .27189 .37422 .2677 .36725 .26003 Mtetra
.658 .753 .92 r
.36725 .26003 .37422 .2677 .38565 .26347 .37871 .25577 Mtetra
.659 .754 .92 r
.37871 .25577 .38565 .26347 .39713 .2592 .39022 .25148 Mtetra
.39022 .25148 .39713 .2592 .40865 .25491 .40177 .24716 Mtetra
.40177 .24716 .40865 .25491 .42023 .25061 .41338 .24282 Mtetra
.41338 .24282 .42023 .25061 .43185 .2463 .42503 .23847 Mtetra
.658 .753 .92 r
.42503 .23847 .43185 .2463 .44352 .24198 .43674 .23411 Mtetra
.43674 .23411 .44352 .24198 .45524 .23764 .44849 .22973 Mtetra
.44849 .22973 .45524 .23764 .46702 .23329 .4603 .22535 Mtetra
.4603 .22535 .46702 .23329 .47884 .22893 .47216 .22095 Mtetra
.47216 .22095 .47884 .22893 .49071 .22455 .48406 .21653 Mtetra
.48406 .21653 .49071 .22455 .50264 .22015 .49602 .2121 Mtetra
.49602 .2121 .50264 .22015 .51462 .21574 .50803 .20765 Mtetra
.657 .753 .92 r
.50803 .20765 .51462 .21574 .52664 .21131 .5201 .20318 Mtetra
.5201 .20318 .52664 .21131 .53873 .20686 .53221 .1987 Mtetra
.657 .752 .92 r
.53221 .1987 .53873 .20686 .55086 .20239 .54438 .19419 Mtetra
.54438 .19419 .55086 .20239 .56305 .19791 .55661 .18967 Mtetra
.55661 .18967 .56305 .19791 .57529 .19341 .56888 .18513 Mtetra
.56888 .18513 .57529 .19341 .58759 .18888 .58122 .18057 Mtetra
.58122 .18057 .58759 .18888 .59994 .18434 .5936 .17599 Mtetra
.5936 .17599 .59994 .18434 .61234 .17978 .60604 .17139 Mtetra
.60604 .17139 .61234 .17978 .6248 .1752 .61854 .16678 Mtetra
.61854 .16678 .6248 .1752 .63731 .1706 .63109 .16214 Mtetra
.63109 .16214 .63731 .1706 .64988 .16599 .6437 .15748 Mtetra
.6437 .15748 .64988 .16599 .66251 .16135 .65637 .1528 Mtetra
.65637 .1528 .66251 .16135 .6752 .15669 .66909 .14811 Mtetra
.66909 .14811 .6752 .15669 .68794 .15201 .68187 .14339 Mtetra
.68187 .14339 .68794 .15201 .70073 .14731 .69471 .13865 Mtetra
.69471 .13865 .70073 .14731 .71359 .14259 .70761 .13389 Mtetra
.536 .686 .936 r
.02706 .37549 .03475 .38318 .04285 .39266 .03678 .37422 Mtetra
.719 .587 .706 r
.03678 .37422 .04285 .39266 .05534 .37311 .04802 .36314 Mtetra
.459 .586 .893 r
.04802 .36314 .05534 .37311 .06523 .37116 .05758 .36353 Mtetra
.591 .71 .926 r
.05758 .36353 .06523 .37116 .07515 .3694 .06759 .36124 Mtetra
.251 .535 .921 r
.06759 .36124 .07515 .3694 .08671 .35606 .07699 .36359 Mtetra
.752 .968 .687 r
.07699 .36359 .08671 .35606 .09608 .35887 .08857 .35064 Mtetra
.571 .687 .919 r
.08857 .35064 .09608 .35887 .10623 .35638 .09865 .34876 Mtetra
.599 .716 .926 r
.09865 .34876 .10623 .35638 .11633 .35464 .10886 .34625 Mtetra
0 .369 .836 r
.10886 .34625 .11633 .35464 .12777 .34263 .11818 .35109 Mtetra
.804 .968 .659 r
.11818 .35109 .12777 .34263 .13761 .34366 .13015 .33549 Mtetra
.585 .697 .919 r
.13015 .33549 .13761 .34366 .14797 .3409 .14046 .33328 Mtetra
.613 .724 .924 r
.14046 .33328 .14797 .3409 .15835 .33832 .15089 .3304 Mtetra
.538 .687 .936 r
.15089 .3304 .15835 .33832 .16467 .37225 .16121 .32903 Mtetra
.623 .438 .611 r
.16121 .32903 .16467 .37225 .1799 .32744 .17267 .31792 Mtetra
.522 .635 .903 r
.17267 .31792 .1799 .32744 .19043 .32482 .18301 .31708 Mtetra
.621 .726 .922 r
.18301 .31708 .19043 .32482 .20106 .32163 .19365 .31399 Mtetra
.624 .731 .924 r
.19365 .31399 .20106 .32163 .21171 .31875 .20435 .3108 Mtetra
.564 .701 .933 r
.20435 .3108 .21171 .31875 .22121 .32829 .21497 .30889 Mtetra
.721 .585 .703 r
.21497 .30889 .22121 .32829 .23367 .30745 .22659 .29716 Mtetra
.495 .604 .891 r
.22659 .29716 .23367 .30745 .24444 .30477 .23714 .29691 Mtetra
.626 .728 .921 r
.23714 .29691 .24444 .30477 .25532 .30129 .24803 .29362 Mtetra
.638 .739 .921 r
.24803 .29362 .25532 .30129 .26627 .29767 .259 .29 Mtetra
.639 .74 .922 r
.259 .29 .26627 .29767 .27726 .29411 .27002 .28634 Mtetra
.63 .735 .923 r
.27002 .28634 .27726 .29411 .28825 .29118 .28107 .28292 Mtetra
.522 .679 .936 r
.28107 .28292 .28825 .29118 .30234 .24632 .29201 .28175 Mtetra
.275 0 .26 r
.29201 .28175 .30234 .24632 .3108 .27941 .30375 .27015 Mtetra
.565 .669 .908 r
.30375 .27015 .3108 .27941 .32195 .2762 .31483 .26826 Mtetra
.637 .736 .92 r
.31483 .26826 .32195 .2762 .33319 .27237 .32608 .26459 Mtetra
.648 .745 .92 r
.32608 .26459 .33319 .27237 .34449 .26835 .33741 .26061 Mtetra
.653 .749 .92 r
.33741 .26061 .34449 .26835 .35585 .26423 .34879 .25649 Mtetra
.656 .751 .92 r
.34879 .25649 .35585 .26423 .36725 .26003 .36023 .25228 Mtetra
.657 .752 .92 r
.36023 .25228 .36725 .26003 .37871 .25577 .37172 .24801 Mtetra
.658 .753 .92 r
.37172 .24801 .37871 .25577 .39022 .25148 .38325 .24369 Mtetra
.659 .754 .92 r
.38325 .24369 .39022 .25148 .40177 .24716 .39484 .23933 Mtetra
.39484 .23933 .40177 .24716 .41338 .24282 .40648 .23496 Mtetra
.40648 .23496 .41338 .24282 .42503 .23847 .41816 .23057 Mtetra
.659 .753 .92 r
.41816 .23057 .42503 .23847 .43674 .23411 .4299 .22617 Mtetra
.658 .753 .92 r
.4299 .22617 .43674 .23411 .44849 .22973 .44169 .22176 Mtetra
.44169 .22176 .44849 .22973 .4603 .22535 .45353 .21734 Mtetra
.45353 .21734 .4603 .22535 .47216 .22095 .46542 .2129 Mtetra
.46542 .2129 .47216 .22095 .48406 .21653 .47736 .20845 Mtetra
.47736 .20845 .48406 .21653 .49602 .2121 .48935 .20398 Mtetra
.48935 .20398 .49602 .2121 .50803 .20765 .5014 .19949 Mtetra
.657 .753 .92 r
.5014 .19949 .50803 .20765 .5201 .20318 .5135 .19499 Mtetra
.5135 .19499 .5201 .20318 .53221 .1987 .52565 .19046 Mtetra
.52565 .19046 .53221 .1987 .54438 .19419 .53785 .18592 Mtetra
.657 .752 .92 r
.53785 .18592 .54438 .19419 .55661 .18967 .55011 .18136 Mtetra
.55011 .18136 .55661 .18967 .56888 .18513 .56243 .17679 Mtetra
.56243 .17679 .56888 .18513 .58122 .18057 .57479 .17219 Mtetra
.57479 .17219 .58122 .18057 .5936 .17599 .58722 .16757 Mtetra
.58722 .16757 .5936 .17599 .60604 .17139 .5997 .16294 Mtetra
.5997 .16294 .60604 .17139 .61854 .16678 .61223 .15828 Mtetra
.61223 .15828 .61854 .16678 .63109 .16214 .62482 .1536 Mtetra
.62482 .1536 .63109 .16214 .6437 .15748 .63747 .14891 Mtetra
.63747 .14891 .6437 .15748 .65637 .1528 .65017 .14419 Mtetra
.65017 .14419 .65637 .1528 .66909 .14811 .66294 .13945 Mtetra
.66294 .13945 .66909 .14811 .68187 .14339 .67576 .1347 Mtetra
.67576 .1347 .68187 .14339 .69471 .13865 .68863 .12992 Mtetra
.68863 .12992 .69471 .13865 .70761 .13389 .70157 .12512 Mtetra
.579 .704 .928 r
.01931 .36779 .02706 .37549 .03678 .37422 .02916 .36574 Mtetra
.554 .07 0 r
.02916 .36574 .03678 .37422 .04802 .36314 .03731 .37519 Mtetra
.843 .955 .61 r
.03731 .37519 .04802 .36314 .05758 .36353 .04993 .35551 Mtetra
.577 .695 .922 r
.04993 .35551 .05758 .36353 .06759 .36124 .0599 .3535 Mtetra
.564 .7 .932 r
.0599 .3535 .06759 .36124 .07699 .36359 .0699 .35167 Mtetra
.793 .683 .742 r
.0699 .35167 .07699 .36359 .08857 .35064 .08158 .33823 Mtetra
.343 .467 .841 r
.08158 .33823 .08857 .35064 .09865 .34876 .09102 .34099 Mtetra
.6 .713 .924 r
.09102 .34099 .09865 .34876 .10886 .34625 .10125 .33843 Mtetra
.561 .699 .933 r
.10125 .33843 .10886 .34625 .11818 .35109 .11144 .33663 Mtetra
.76 .644 .733 r
.11144 .33663 .11818 .35109 .13015 .33549 .12299 .3245 Mtetra
.433 .553 .876 r
.12299 .3245 .13015 .33549 .14046 .33328 .13291 .32548 Mtetra
.61 .719 .923 r
.13291 .32548 .14046 .33328 .15089 .3304 .14335 .32266 Mtetra
.601 .719 .927 r
.14335 .32266 .15089 .3304 .16121 .32903 .15383 .32 Mtetra
.94 .572 .244 r
.15383 .32 .16121 .32903 .17267 .31792 .16015 .354 Mtetra
.686 .745 .243 r
.16015 .354 .17267 .31792 .18301 .31708 .17558 .30895 Mtetra
.602 .71 .92 r
.17558 .30895 .18301 .31708 .19365 .31399 .18619 .30627 Mtetra
.626 .731 .923 r
.18619 .30627 .19365 .31399 .20435 .3108 .19692 .303 Mtetra
.612 .725 .926 r
.19692 .303 .20435 .3108 .21497 .30889 .20766 .30005 Mtetra
0 .047 .578 r
.20766 .30005 .21497 .30889 .22659 .29716 .21723 .30956 Mtetra
.774 .906 .514 r
.21723 .30956 .22659 .29716 .23714 .29691 .22983 .28858 Mtetra
.603 .708 .918 r
.22983 .28858 .23714 .29691 .24803 .29362 .24069 .28582 Mtetra
.635 .736 .921 r
.24069 .28582 .24803 .29362 .259 .29 .25168 .28227 Mtetra
.64 .74 .921 r
.25168 .28227 .259 .29 .27002 .28634 .26273 .27857 Mtetra
.637 .739 .922 r
.26273 .27857 .27002 .28634 .28107 .28292 .27382 .27493 Mtetra
.61 .724 .926 r
.27382 .27493 .28107 .28292 .29201 .28175 .28491 .27192 Mtetra
.929 .728 .611 r
.28491 .27192 .29201 .28175 .30375 .27015 .29917 .22683 Mtetra
0 0 .427 r
.29917 .22683 .30375 .27015 .31483 .26826 .30767 .25997 Mtetra
.62 .722 .919 r
.30767 .25997 .31483 .26826 .32608 .26459 .31893 .25668 Mtetra
.644 .742 .92 r
.31893 .25668 .32608 .26459 .33741 .26061 .33027 .25277 Mtetra
.651 .748 .92 r
.33027 .25277 .33741 .26061 .34879 .25649 .34168 .24867 Mtetra
.654 .75 .92 r
.34168 .24867 .34879 .25649 .36023 .25228 .35315 .24446 Mtetra
.657 .752 .92 r
.35315 .24446 .36023 .25228 .37172 .24801 .36466 .24017 Mtetra
.658 .753 .92 r
.36466 .24017 .37172 .24801 .38325 .24369 .37623 .23583 Mtetra
.659 .754 .92 r
.37623 .23583 .38325 .24369 .39484 .23933 .38785 .23145 Mtetra
.38785 .23145 .39484 .23933 .40648 .23496 .39952 .22704 Mtetra
.39952 .22704 .40648 .23496 .41816 .23057 .41124 .22262 Mtetra
.41124 .22262 .41816 .23057 .4299 .22617 .42301 .21818 Mtetra
.658 .753 .92 r
.42301 .21818 .4299 .22617 .44169 .22176 .43483 .21373 Mtetra
.43483 .21373 .44169 .22176 .45353 .21734 .4467 .20927 Mtetra
.4467 .20927 .45353 .21734 .46542 .2129 .45862 .20479 Mtetra
.45862 .20479 .46542 .2129 .47736 .20845 .4706 .2003 Mtetra
.4706 .2003 .47736 .20845 .48935 .20398 .48263 .19579 Mtetra
.48263 .19579 .48935 .20398 .5014 .19949 .49471 .19127 Mtetra
.49471 .19127 .5014 .19949 .5135 .19499 .50684 .18673 Mtetra
.657 .753 .92 r
.50684 .18673 .5135 .19499 .52565 .19046 .51903 .18217 Mtetra
.51903 .18217 .52565 .19046 .53785 .18592 .53127 .17759 Mtetra
.657 .752 .92 r
.53127 .17759 .53785 .18592 .55011 .18136 .54356 .17299 Mtetra
.54356 .17299 .55011 .18136 .56243 .17679 .55591 .16837 Mtetra
.55591 .16837 .56243 .17679 .57479 .17219 .56832 .16374 Mtetra
.56832 .16374 .57479 .17219 .58722 .16757 .58078 .15908 Mtetra
.58078 .15908 .58722 .16757 .5997 .16294 .5933 .15441 Mtetra
.5933 .15441 .5997 .16294 .61223 .15828 .60587 .14971 Mtetra
.60587 .14971 .61223 .15828 .62482 .1536 .6185 .145 Mtetra
.6185 .145 .62482 .1536 .63747 .14891 .63119 .14026 Mtetra
.63119 .14026 .63747 .14891 .65017 .14419 .64393 .1355 Mtetra
.64393 .1355 .65017 .14419 .66294 .13945 .65673 .13073 Mtetra
.65673 .13073 .66294 .13945 .67576 .1347 .66959 .12593 Mtetra
.66959 .12593 .67576 .1347 .68863 .12992 .68251 .12111 Mtetra
.68251 .12111 .68863 .12992 .70157 .12512 .69549 .11627 Mtetra
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.09674 .23181 m
.10144 .23638 L
s
[(-5)] .08733 .22266 1 .97262 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.61454 .02905 m
.61829 .03444 L
s
[(5)] .60704 .01829 .69632 1 Mshowa
.125 Mabswid
.14416 .21324 m
.14694 .21603 L
s
.19248 .19432 m
.19521 .19716 L
s
.24172 .17504 m
.2444 .17792 L
s
.2919 .15539 m
.29453 .15832 L
s
.39523 .11493 m
.39774 .11796 L
s
.44843 .0941 m
.45088 .09718 L
s
.50269 .07285 m
.50508 .07598 L
s
.55805 .05117 m
.56037 .05435 L
s
.05019 .25004 m
.05305 .25274 L
s
.67219 .00648 m
.67437 .00976 L
s
gsave
.29165 .07573 -70.3112 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
69.000000 14.437500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.563},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  AnimationDisplayTime->0.271883,
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X00018a000`40O003h00OogooJGoo003oOomY
Ool00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00ogooJGoo003oOomYOol00?moofUoo`00
hGoo1000Pgoo003POol00`00Oomoo`02Ool00`00Oomoo`20Ool00>Eoo`03001oogoo081oo`00iGoo
00<007ooOol0P7oo003QOol40023Ool00>5oo`03001oogoo01]oo`8006Moo`00hGoo00<007ooOol0
6Goo0P0000=oo`000000IWoo003QOol5000DOol30003Ool2001VOol00?Qoo`800003Ool007oo00=o
o`03001oo`0006Eoo`00mGoo0`0017oo00D007ooOomoo`00009oo`03001oogoo069oo`00lWoo0`00
2goo00@007oo000006Aoo`00l7oo0P003Woo00D007ooOomoo`0006=oo`00kGoo0`0047oo00<007oo
Ool00Woo00<007ooOol0H7oo003[Ool2000COol00`00Oomoo`02Ool00`00Oomoo`1POol00>Qoo`<0
01Ioo`03001oogoo009oo`03001oogoo05moo`00iWoo0`0067oo00<007ooOol00goo00<007ooOol0
GWoo003SOol30003Ool00`00Oomoo`0EOol00`00Oomoo`03Ool00`00Oomoo`1NOol00>5oo`8000Io
o`03001oogoo01Eoo`03001oogoo00Aoo`03001oogoo05eoo`00MWoo0P000Woo0P00HWoo0`0087oo
00<007ooOol017oo00<007ooOol0GGoo001gOol01000Oomoo`00HGoo0P008goo00<007ooOol01Goo
00<007ooOol0G7oo001hOol2001OOol3000UOol00`00Oomoo`06Ool00`00Oomoo`1KOol007Qoo`80
05aoo`<002Qoo`03001oogoo00Ioo`03001oogoo05]oo`00Mgoo00@007ooOol005Uoo`8002]oo`03
001oogoo00Moo`03001oogoo05Yoo`00MWoo0P000Woo0P00EGoo0`000Woo00<007ooOol0:7oo00<0
07ooOol01Woo0`00Fgoo003?Ool2000`Ool00`00Oomoo`08Ool00`00Oomoo`1IOol00<aoo`<0039o
o`03001oogoo00Uoo`03001oogoo05Qoo`00bWoo0P00=Goo00<007ooOol02Woo00<007ooOol0Egoo
0037Ool3000gOol00`00Oomoo`0:Ool00`00Oomoo`1GOol00<Eoo`8003Yoo`03001oogoo00]oo`03
001oogoo00moo`D0049oo`00`Woo0`00?7oo00<007ooOol037oo00<007ooOol03Woo00D007ooOomo
o`00049oo`00`7oo0P000Woo00<007ooOol0>goo00<007ooOol02goo00<007ooOol03goo00<007oo
Ool0@goo002mOol30012Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool60004Ool00`00Oomoo`12Ool0
0;Yoo`<004Eoo`03001oogoo00eoo`03001oogoo00moo`03001oogoo045oo`00^7oo0P00B7oo00<0
07ooOol03Goo00<007ooOol047oo00<007ooOol0@7oo002eOol3001:Ool00`00Oomoo`0>Ool00`00
Oomoo`0;Ool01@00Oomoogoo0000@Woo002cOol2001=Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool3
0013Ool008Ioo`@002Ioo`<004moo`03001oogoo00moo`03001oogoo055oo`00QGoo00<007ooOol0
0Woo00<007ooOol08Goo0P000Woo00<007ooOol0CGoo00<007ooOol03Goo0P0000=oo`00Ool0DGoo
0025Ool00`00Oomoo`02Ool00`00Oomoo`0NOol3001DOol00`00Oomoo`0AOol00`00Oomoo`1?Ool0
08Eoo`03001oogoo009oo`03001oogoo01aoo`8005Moo`03001oogoo015oo`03001oogoo04moo`00
QGoo00<007ooOol00Woo00<007ooOol06Goo0`00FGoo00<007ooOol04Woo00<007ooOol0CWoo0025
Ool00`00Oomoo`02Ool00`00Oomoo`0GOol2001LOol00`00Oomoo`0BOol00`00Oomoo`1>Ool008Eo
o`03001oogoo009oo`03001oogoo01Aoo`<005ioo`03001oogoo01=oo`03001oogoo04eoo`00QWoo
100057oo0`00HGoo00<007ooOol057oo00<007ooOol0C7oo002LOol20003Ool00`00Oomoo`1NOol0
0`00Oomoo`0DOol00`00Oomoo`1<Ool009Uoo`<0069oo`05D_eBo5;mD_`0000GOol00`00Oomoo`1;
Ool009Moo`8006=oo`=Bo005D_eBo5;lD_`0000GOol00`00Oomoo`1:Ool009Aoo`<006=oo`0:D_eB
o5;mD_aBoE;lD_eBo5;m000GOol00`00Oomoo`1:Ool0099oo`80069oo`=Bo005D_eBo5;lD_aBo@03
D_`015;mD_`005;l5goo00<007ooOol0BGoo002?Ool3001ROol04U;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBo@00D_eBo1Eoo`03001oo`0004Yoo`00SGoo0`00HWoo00=Bo5;mD_`00U;l00EBoE;l
D_aBo5;m00=Bo005D_eBo5;lD_`00003D_`FOol00`00Oomoo`18Ool008Yoo`<000=oo`03001oogoo
05Yoo`0JD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d005;mD_aBoAMo
o`03001oogoo04Moo`00Qgoo0`00HGoo0U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`0
2E;mD_aBo5;lD_eBo000D_aBo@02D_`GOol00`00Oomoo`16Ool008Eoo`80069oo`0PD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aBoAIoo`03
001oogoo04Ioo`00PWoo0`00HWoo00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo00000=Bo003D_eBo7oo01Ioo`03001oogoo04Eoo`00P7oo0P00Hgoo
02EBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_d005;mD_aBoE;lD_eBo00GOol00`00Oomoo`14Ool007eoo`<0065oo`05D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_`005;lD_d0
0e;l00=BoE;lOol05Goo00<007ooOol0A7oo001kOol20002Ool00`00Oomoo`1MOol0;5;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBo@00D_eBo5;mD_aBoE;lD_dGOol00`00Oomoo`13Ool007Qoo`<0069oo`9Bo005D_eBo5;lD_aB
o@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aB
o5;l00000e;l00EBoE;lD_aBo5;m01Moo`03001oogoo049oo`00MWoo0P00HGoo03ABo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_d005;mD_aBoE;lD_eBo5;mD_aBoAIoo`03001oogoo049oo`00Lgoo0`00HGoo
0U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_`005;lD_d00e;l00ABoE;lD_aBo1Moo`03001oogoo
045oo`00LGoo0P00HWoo03UBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aB
oE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBo@00D_eBo5;mD_aB
oE;lD_eBo5;mD_`05Goo00<007oo0000@Woo001^Ool3001POol2D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=B
o005D_eBo5;lD_aBo@03D_`01E;m001Bo5;lD_d00e;l00ABoE;lD_aBo1Ioo`03001oogoo041oo`00
Jgoo0`00HGoo045Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001B
o5;mD_aBoE;lD_eBo5;mD_aBoE;l01Ioo`03001oogoo03moo`00JGoo0P000goo00<007ooOol0Fgoo
00=Bo5;mD_`00U;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l
00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_`005;m
00=Bo005D_eBo5;lD_aBo@03D_`EOol00`00Oomoo`0oOol006Ioo`<005moo`19D_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;l
D_eBo5;mD_aBoE;lD_d05Woo00<007ooOol0?Woo001TOol2001POol00e;lD_eBo002D_`01E;mD_aB
o5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EB
oE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBo@00D_aBo5;m00=B
o005D_eBo5;lD_aBo@02D_`FOol00`00Oomoo`0mOol0065oo`<0061oo`1?D_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`005;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_d05Goo00<007ooOol09Goo0`005Goo000eOol4000VOol2001O
Ool00e;lD_eBo002D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03
D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;l
D_d00e;l00EBoE;lD_aBo5;m009Bo003001BoE;l009Bo005D_eBo5;lD_aBo@03D_`00e;mD_aoo`0E
Ool00`00Oomoo`0VOol00`00Oomoo`0COol003Aoo`03001oogoo009oo`03001oogoo021oo`<0061o
o`1ED_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eB
o5;mD_aBoE;lD_eBo5;mD_aBoE;l001Bo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_`05Woo00<0
07ooOol09Goo00<007ooOol04goo000iOol00`00Oomoo`0NOol20002Ool00`00Oomoo`1LOol2D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo006D_eBo5;lD_aBo@000U;l00EBoE;lD_aBo5;m00=Bo006D_eBo5;lD_aBoE;l5Goo00<0
07ooOol097oo00<007oo000057oo000/Ool60007Ool00`00Oomoo`0KOol3001OOol0G5;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo000D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_dFOol0
0`00Oomoo`0SOol00`00Ool0000DOol003Eoo`@001aoo`80061oo`9Bo005D_eBo5;lD_aBo@03D_`0
1E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d0
0e;l00EBoE;lD_aBo5;m00=Bo005D_eBo5;lD_aBo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aB
o5;m00=Bo005D_eBo5;l001Bo@03D_`01E;mD_aBo5;lD_d00e;l00EBoE;lD_aBo5;m01Ioo`03001o
ogoo025oo`05001oogooOol0000COol003Eoo`03001oogoo01Yoo`<0061oo`1RD_aBoE;lD_eBo5;m
D_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_eBo5;mD_aBoE;lD_e