(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    850517,      23544]*)
(*NotebookOutlinePosition[    893638,      24538]*)
(*  CellTagsIndexPosition[    886920,      24384]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["9", "ChapterLine",
  CounterAssignments->{{"Title", 8}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral},
  CellTags->"Generalized Symmetries of Partial Differential Equations"],

Cell["Generalized Symmetries", "Title",
  CounterAssignments->{{"Title", 8}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[CellGroupData[{

Cell[TextData[{
  "9.",
  CounterBox["Section"],
  ".",
  " Introduction"
}], "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],

Cell["\<\
The previous sections discussed the classical method, the \
non-classical method, and some extensions of Lie\[CloseCurlyQuote]s theory. \
We demonstrated the classification and solution of some types of ordinary as \
well as partial differential equations. Although very general, these methods \
mainly consider the geometric aspects of the transformations related to the \
equations. Essentially, we discussed invariance under point transformations \
and demonstrated that some kind of contact transformations are related to \
point transformations in case of first-order partial differential equations. \
However, it turns out that much wider classes of transformations leave \
differential equations invariant, including those considered by Lie.\
\>", 
  "Text",
  CellTags->{
  "classical method", "non-classical method", "point transformations", 
    "contact transformations"}],

Cell[TextData[{
  ButtonBox["Emmi Noether [1918]",
    ButtonData:>{"Literat.nb", "Noether-18"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Felix Klein [1918]",
    ButtonData:>{"Literat.nb", "Klein-1918"},
    ButtonStyle->"Hyperlink"],
  " demonstrated that a system of differential equations derivable from a \
variational principle allows a much greater set of transformations under \
which a given system of differential equations is invariant. They \
significantly extended the application of symmetry group methods by including \
derivatives of the dependent variables in the transformations. Moreover, they \
were able to offer a regular procedure to construct the related conservation \
laws which are based on the investigation of the invariance properties of the \
variational integral under the action of transformation groups. With the \
publication of her theorem, Emmi Noether demonstrated that Lie point \
symmetries cannot provide the total number of symmetries for a given system \
of differential equations. Consequently, the required integrals of motion and \
the solutions are not available for many systems."
}], "Text",
  CellTags->{
  "variational principle", "symmetry group method", "conservation laws", 
    "invariance properties", "variational integral", "integrals of motion"}],

Cell[TextData[{
  "In recent years, the symmetry methods have become more attractive, \
especially in the field of non-linear dynamics. In this chapter, we will \
consider a generalized method of Lie\[CloseCurlyQuote]s classical theory to \
determine the symmetries for non-linear PDEs and ODEs. We will demonstrate \
that the method is applicable to a large number of different models. Let us \
first outline the mathematical theory to generate a firm basis on which ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is grounded."
}], "Text",
  CellTags->{
  "nonlinear dynamics", "generalized method of Lie's classical theory"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.",
  CounterBox["Section"],
  ".",
  " Elements of Generalized Symmetries"
}], "Section",
  CellTags->"Elements of Generalized Symmetries"],

Cell[TextData[{
  "The setting of our program ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " is an entirely general one. Its algorithm is well known and described, \
for example. in the books by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  " or ",
  ButtonBox["Bluman and Kumei [1989]",
    ButtonData:>{"Literat.nb", "Blum-89"},
    ButtonStyle->"Hyperlink"],
  ". We consider the general case of a non-linear system of differential \
equations for an arbitrary number ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " of unknown functions ",
  Cell[BoxData[
      \(TraditionalForm\`u\^\[Alpha]\)]],
  " which may depend on ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  "  independent variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". We denote these sets of variables simply by ",
  Cell[BoxData[
      \(TraditionalForm\`u = \((u\^1, u\^2, \[Ellipsis], u\^q)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, x\_2, \[Ellipsis], x\_p)\)\)]],
  ", respectively. The most general case is given by a system of ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " non-linear differential equations"
}], "Text",
  CellTags->"algorithm of generalized symmetries"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(\(\[CapitalDelta]\^i\)(x, u\_\((k)\))\  = \ 0\), ",", 
        "            ", 
        FormBox[\(i = 1, 2, \[Ellipsis], m\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "of order ",
  StyleBox["k",
    FontSlant->"Italic"],
  ". The term ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\((k)\)\)]],
  " is understood as the ",
  StyleBox["k",
    FontSlant->"Italic"],
  "th derivative of ",
  StyleBox["u",
    FontSlant->"Italic"],
  " with respect to ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". We note that ",
  Cell[BoxData[
      \(TraditionalForm\`m, \ k, \ p\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are arbitrary, positive integers."
}], "Text"],

Cell["\<\
In order to find the properties of (9.1) different from point symmetries, \
non-classical symmetries, or potential symmetries, it is suitable to apply a \
transformation of the independent and dependent variables as well as the \
derivatives. This kind of transformation determines the attributes of the \
corresponding group \[GothicCapitalG]. \
\>", "Text",
  CellTags->{
  "point symmetries", "non-classical symmetries", "potential symmetries"}],

Cell["\<\
First, let us consider transformations of (9.1) depending on a single \
parameter  \[Epsilon]  which are given by\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(x\^*\)\  = \ \[CapitalXi](x, u\_\((k)\); \[Epsilon]), \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(u\^*\)\  = \ \[CapitalPhi](x, u\_\((k)\); \[Epsilon])\)], 
  "NumberedEquation"],

Cell[TextData[{
  "with ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, 2  \[Ellipsis]\)]],
  " denoting the order of the derivatives. The functions \[CapitalXi] and \
\[CapitalPhi] are assumed to be differentiable with respect to the dependent \
and independent variables. The identity transformation of the coordinates in \
(9.2) and (9.3) is given by ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ". In analogy to Lie's theory, the transformations (9.2)\[Dash](9.3) are \
generated by the vector field"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(v\& \[RightVector] \)\  = \ 
      \[Sum]\+\(i = 1\)\%p\(\( \[Xi]\_i\)(x, u\_\((k)\))\)\ 
            \[PartialD]\/\[PartialD]x\_i\  + \ 
        \[Sum]\+\(\[Alpha] = 1\)\%q\(\( \[Phi]\_\[Alpha]\)(x, u\_\((k)\))\)\ 
            \[PartialD]\/\[PartialD]u\^\[Alpha] . \)], "NumberedEquation"],

Cell[TextData[{
  "The infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " are derived  from equations (9.2) and (9.3) by differentiating the \
transformations with respect to the group parameter \[Epsilon]. Considering  \
these expressions for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] = 0\)]],
  ", we get"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[Xi]\_i\)(x, u\_\((k)\))\  = \ 
      \(\[PartialD]\(\[CapitalXi](x, u\_\((k)\); \[Epsilon])
                \)\/\[PartialD]\[Epsilon]\) |\_\(\[Epsilon] = 0\)\ , \)\)], 
  "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Phi]\_\[Alpha]\)(x, u\_\((k)\))\  = \ 
      \[PartialD]\(\[CapitalPhi](x, u\_\((k)\); \[Epsilon])
              \)\/\[PartialD]\[Epsilon]\( | \_\(\[Epsilon] = 0\)\) . \)], 
  "NumberedEquation"],

Cell["\<\
The infinitesimal transformations corresponding to (9.2) and (9.3) \
are then given by\
\>", "Text",
  CellTags->"infinitesimal transformations"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(\(x\_i\%*\)\  = \ 
          x\_i\  + \ \[Epsilon]\ \(\(\[Xi]\_i\)(x, u\_\((k)\))\)\  + \ 
            o(\[Epsilon]\^2)\), ",", "   ", 
        FormBox[\(i = 1, 2, \[Ellipsis], p\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(u\^\(\[Alpha]*\)\  = \ 
          u\^\[Alpha]\  + \ \[Epsilon]\ \(\[Phi](x, u\_\((k)\))\)\  + \ 
            o(\[Epsilon]\^2)\), ",", "   ", 
        FormBox[\(\[Alpha] = 1, 2, \[Ellipsis], q\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[
"with \[Epsilon] being the group parameter, a small quantity. This \
representation is a straight generalization of Lie\[CloseCurlyQuote]s \
classical procedure. On the other hand, it is beneficial to introduce \
coordinates in which the infinitesimal transformations become the simple \
representation"], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(x\_i\%*\)\  = \ x\_i\), " ", ",", "  ", 
        FormBox[\(i = 1, 2, \[Ellipsis], p\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(u\^\(\[Alpha]*\)\  = \ 
          u\^\[Alpha]\  + \ 
            \[Epsilon]\ 
              \((\(\[Phi]\_\[Alpha]\)(x, u\_\((k)\))\  - \ 
                  \[Sum]\+\(i = 1\)\%p\( u\_i\%\[Alpha]\) 
                      \(\(\[Xi]\_i\)(x, u\_\((k)\))\))\)\  + \ 
            o(\[Epsilon]\^2)\), ",", "  ", 
        FormBox[\(\[Alpha] = 1, 2, \[Ellipsis], q\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "meaning that the complete transformations are represented by a \
transformation of the dependent variables. The corresponding representation \
of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  " is then"
}], "Text",
  CellTags->"transformation of the dependent variables"],

Cell[BoxData[
    \(TraditionalForm
    \`\(v\&\[RightVector]\_Q\  = \ 
      \[Sum]\+\(\[Alpha] = 1\)\%q\(\( Q\_\[Alpha]\)(x, u\_\((k)\))\)\ 
          \[PartialD]\/\[PartialD]u\^\[Alpha], \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(Q\_\[Alpha]\),
            "TraditionalForm"], "=", \(\(Q\_\[Alpha]\)(x, u\_\((k)\))\)}], 
        TraditionalForm]]],
  " is the characteristic of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  ". The characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\)]],
  " are related to the infinitesimals by"
}], "Text",
  CellTags->{"characteristic", "infinitesimals"}],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(Q\_\[Alpha]\  = \ 
          \[Phi]\_\[Alpha]\  - \ 
            \[Sum]\+\(i = 1\)\%p \[Xi]\_i\ u\_i\%\[Alpha]\), " ", ",", "  ", 
        FormBox[\(\[Alpha] = 1, 2, \[Ellipsis], \(q . \)\),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "It is obvious from these relations that point symmetries are a subset of \
generalized symmetries. Restricting the dependencies of the infinitesimals on \
the variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", we are back in the classical theory of Lie. The determination of the \
characteristics follow by a similar algorithm as used in the determination of \
point symmetries. The determining equations for the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\)]],
  " are consequences of the relation"
}], "Text",
  CellTags->"determination of the characteristics"],

Cell[BoxData[
    \(TraditionalForm
    \`pr  v\&\[RightVector]\_Q\ \[CapitalDelta]\ 
      \[VerticalSeparator]\_\(\[CapitalDelta] = 0\)\ \( = \ 0\)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`pr  v\&\[RightVector]\_Q\)]],
  " denotes the prolongation of the vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  ". The general expression of the prolongation reads"
}], "Text",
  CellTags->"prolongation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(pr  v\&\[RightVector]\_Q\),
          "TraditionalForm"], "=", 
        " ", \(\[Sum]\+\(\[Alpha] = \
1\)\[NegativeThinSpace]\(\(\[Sum]\+J\)\(\(D\_J\) \(Q\_\[Alpha]\) \
\[PartialD]\/\[PartialD]u\_J\%\[Alpha]\)\(\ \ \)\)\)}], 
      TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "with ",
  Cell[BoxData[
      \(TraditionalForm\`D\_J\)]],
  " the ",
  ButtonBox["total derivative",
    ButtonData:>{"derivat.nb", "Definition: Complete derivative"},
    ButtonStyle->"Hyperlink"],
  " depending on the multi-index ",
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  ". The invariance condition (9.13) is based on the fact that the equation ",
  
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  " and their differential consequences vanish on the solution manifold. From \
equation (9.13), we get a system of linear coupled PDEs for the \
characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\)]],
  " if we extract the coefficients of the derivatives in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " up to a certain order. We note that this order can be infinite. However, \
in practical calculations, we restrict the order of derivatives in ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\)]],
  " to a finite number. Equation (9.13) contains all the information to \
derive the generalized symmetries in a nutshell. The following section \
discusses the procedure of how equation (9.13) is algorithmically \
accessible."
}], "Text",
  CellTags->{
  "solution manifold", "linear coupled PDEs for the characteristics"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.",
  CounterBox["Section"],
  ".",
  " Algorithm for Calculation of Generalized Symmetries"
}], "Section",
  CellTags->"Algorithm for the Calculation of Generalized Symmetries"],

Cell["\<\
The procedure to calculate the generalized symmetries proceeds in the same \
way as for the classical symmetries. The following steps are based on (9.13):\
\
\>", "Text",
  CellTags->"algorithm of calculating generalized symmetries"],

Cell[TextData[{
  "Calculate the prolongation of the system of differential equations up to ",
  
  StyleBox["k",
    FontSlant->"Italic"],
  "th order by"
}], "ListItem",
  CellDingbat->"1.",
  Evaluatable->False,
  CellTags->"prolongation"],

Cell[BoxData[
    \(TraditionalForm\`\(pr  v\&\[RightVector]\_Q\ \[CapitalDelta]\  = \ 0, 
    \)\)], "NumberedEquation",
  Evaluatable->False],

Cell[TextData[{
  "    where ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " specifies the order of differentiation in the characteristics."
}], "ListItem",
  CellTags->"characteristics"],

Cell["\<\
Use the equations and their differential consequences to eliminate \
redundant information of the prolongation\
\>", "ListItem",
  CellDingbat->"2.",
  Evaluatable->False,
  CellTags->"redundant information"],

Cell[BoxData[
    \(TraditionalForm
    \`pr  v\&\[RightVector]\_Q\ 
        \[CapitalDelta]\( \[VerticalSeparator] \_\(\[CapitalDelta] = 0\)\)\ 
      \( = \ 0. \)\)], "NumberedEquation"],

Cell[TextData[{
  "Extract the determining equations from the prolongation. The determining \
equations follow as coefficients of the derivatives in ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ", i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`u\_x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(x, x\)\)]],
  ", etc. The order of derivatives used in the extraction should be greater \
than ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "."
}], "ListItem",
  CellDingbat->"3.",
  Evaluatable->False,
  CellTags->"determining equations"],

Cell["Solve the resulting linear determining equations.", "ListItem",
  CellDingbat->"4.",
  Evaluatable->False],

Cell[TextData[{
  "A selected number of examples will demonstrate the application of the \
algorithm. The four steps are realized in the function ",
  StyleBox["Baecklund[]", "MmaText"],
  ". This function fosters the determination of the generalized symmetries. \
The symmetries are represented by the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  " which are labeled in ",
  StyleBox["MathLie",
    FontSlant->"Italic"],
  " by ",
  StyleBox["QC", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["i", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ". Since the characteristics depend, in general, on derivatives of an \
infinite order, we need to restrict this order to a finite number. At the \
moment, this number must be specified by the user. The function ",
  StyleBox["Baecklund[]", "MmaText"],
  " assumes by default that the largest order of derivatives is one. Thus, ",
  StyleBox["Baecklund[]", "MmaText"],
  " determines so-called contact transformations by default. By increasing \
the order of derivatives ",
  Cell[BoxData[
      \(TraditionalForm\`n > 1\)]],
  " in the characteristics, we can force ",
  StyleBox["Baecklund[]", "MmaText"],
  " to determine generalized symmetries of order ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". The following examples illustrate the application of ",
  StyleBox["Baecklund[]", "MmaText"],
  " to examples like the diffusion equation, the potential Burgers equation, \
the generalized KdV equation, and a coupled system of wave equations."
}], "Text",
  CellTags->{"Baecklund[]", "characteristics"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.",
  CounterBox["Section"],
  ".",
  " Examples"
}], "Section",
  CellTags->"Examples"],

Cell[TextData[{
  "This section is concerned with application of ",
  StyleBox["Baecklund[]", "MmaText"],
  " to PDEs. The examples display the capabilities and the flexibility \
incorporated in the function."
}], "Text"],

Cell[CellGroupData[{

Cell["9.4.1 Diffusion Equation", "Subsection",
  CellTags->"Diffusion equation"],

Cell[TextData[{
  "Let us start with the diffusion equation. The four steps of the algorithm \
are carried out by the function ",
  StyleBox["Baecklund[]", "MmaText"],
  " automatically. We first demonstrate the simplest case of application. The \
standard case occurs when the equation is free of any parameter. Then, only \
the equation, the dependent variables, and independent variables are supplied \
to the function ",
  StyleBox["Baecklund[]", "MmaText"],
  ". In addition to these three input quantities, the side condition of \
equation (9.13) is needed, meaning that ",
  StyleBox["Baecklund[]", "MmaText"],
  " must know a term for which the equation of motion is solvable. This term \
must be provided as the fourth argument. The fifth argument is not necessary \
for first-order generalized symmetries. The generalized symmetries of \
first-order for the diffusion equation thus follow by"
}], "Text",
  CellTags->{"diffusion equation", "Baecklund[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalSymm\  = \ 
      Baecklund[
        \[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)u[x, t] == 0, {u}, {x, 
          t}, {\[PartialD]\_t u[x, t]}]; generalSymm // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\(QC[1]\)[t, x, u, u\_t, u\_x]\), "==", 
              RowBox[{
                RowBox[{"u", " ", 
                  RowBox[{"(", 
                    RowBox[{"k1", "+", 
                      StyleBox[\(\(k3\ x\)\/2\),
                        ScriptLevel->0]}], ")"}]}], "+", 
                \(\((k2 + k3\ t)\)\ u\_x\), "+", 
                \(\[ScriptCapitalF]\_1\)}]}]},
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          QC[ 1][ t, x, u, 
            Subscript[ u, t], 
            Subscript[ u, x]], 
          Plus[ 
            Times[ u, 
              Plus[ k1, 
                Times[ 
                  Rational[ 1, 2], k3, x]]], 
            Times[ 
              Plus[ k2, 
                Times[ k3, t]], 
              Subscript[ u, x]], 
            Subscript[ \[ScriptCapitalF], 1]]], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The result of the calculation is the representation of the characteristic \
QC[1] depending on the independent and the dependent variables and on \
first-order derivatives. Thus, ",
  StyleBox["Baecklund[]", "MmaText"],
  " calculates generalized symmetries of first order by default. The result \
also shows that the first-order generalized symmetries consist of an infinite \
and a finite part of transformations. The infinite part must satisfy the \
original equation. This behavior is expected for a linear equation. \
Generalized symmetries different from contact transformations follow by \
increasing the order ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". The order of the largest derivative in the characteristics is specified  \
by the fifth argument of ",
  StyleBox["Baecklund[]", "MmaText"],
  ". For example, if we are interested in second-order generalized \
symmetries, we initiate the calculation by"
}], "Text",
  CellTags->{
  "characteristic", "Baecklund[]", "generalized symmetries of first order", 
    "contact transformations", "second-order generalized symmetries"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalSymm\  = \ 
      Baecklund[
        \[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)u[x, t] == 0, {u}, {x, 
          t}, {\[PartialD]\_t u[x, t]}, 2]; generalSymm // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{
            \(\(QC[1]\)[t, x, u, u\_t, u\_\(t, t\), u\_x, u\_\(x, t\), 
                u\_\(x, x\)]\), "==", 
              RowBox[{
                RowBox[{
                  StyleBox[\(1\/4\),
                    ScriptLevel->0], " ", "u", " ", 
                  \((4\ k1 - 4\ k7 + 2\ k6\ t + 2\ k3\ x + k6\ x\^2)\)}], 
                "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"k2", "+", 
                      StyleBox[\(\(k5\ x\)\/2\),
                        ScriptLevel->0], "+", \(t\ \((k3 + k6\ x)\)\)}], 
                    ")"}], " ", \(u\_x\)}], "+", \(\[ScriptCapitalF]\_1\), 
                "+", \(\((k4 + t\ \((k5 + k6\ t)\))\)\ u\_\(x, x\)\)}]}]},
          {
            \(\(-\((\[ScriptCapitalF]\_1)\)\_t\) + 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          QC[ 1][ t, x, u, 
            Subscript[ u, t], 
            Subscript[ u, t, t], 
            Subscript[ u, x], 
            Subscript[ u, x, t], 
            Subscript[ u, x, x]], 
          Plus[ 
            Times[ 
              Rational[ 1, 4], u, 
              Plus[ 
                Times[ 4, k1], 
                Times[ -4, k7], 
                Times[ 2, k6, t], 
                Times[ 2, k3, x], 
                Times[ k6, 
                  Power[ x, 2]]]], 
            Times[ 
              Plus[ k2, 
                Times[ 
                  Rational[ 1, 2], k5, x], 
                Times[ t, 
                  Plus[ k3, 
                    Times[ k6, x]]]], 
              Subscript[ u, x]], 
            Subscript[ \[ScriptCapitalF], 1], 
            Times[ 
              Plus[ k4, 
                Times[ t, 
                  Plus[ k5, 
                    Times[ k6, t]]]], 
              Subscript[ u, x, x]]]], 
        Equal[ 
          Plus[ 
            Times[ -1, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Now, the characteristic ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_1\)]],
  " depends on the second-order derivative of ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". The group parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k\_i\)]],
  " denote the six different characteristics under which the diffusion \
equation is invariant. The invariance can be checked by ",
  StyleBox["Baecklund[]", "MmaText"],
  " if we provide additional information to the function. The additional \
information is carried by the option ",
  StyleBox["CharExpression\[Rule]", "MmaText",
    FontSlant->"Italic"],
  StyleBox["{", "MmaText",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["list", "MmaText",
    FontSlant->"Italic"],
  StyleBox["}", "MmaText"],
  StyleBox[",",
    FontSlant->"Italic"],
  " where ",
  StyleBox["list ",
    FontSlant->"Italic"],
  "contains the information on the characteristics. Let us check the \
invariance of the diffusion equation with the second-order characteristics \
derived above. For the following calculation, we first need to extract the \
characteristics from the result ",
  StyleBox["generalSymm",
    FontSlant->"Italic"],
  ":"
}], "Text",
  CellTags->"CharExpression"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"char", " ", "=", " ", 
        RowBox[{
          RowBox[{\(QC[1]\), "[", 
            RowBox[{"t", ",", "x", ",", \(u[x, t]\), ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 2)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((1, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], ",", 
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], "]"}], 
          "/.", \(generalSymm\[LeftDoubleBracket]1
            \[RightDoubleBracket]\)}]}], ";", 
      \(char // LieTraditionalForm\)}]], "Input"],

Cell[BoxData[
    \(1\/4\ u\ \((4\ k1 - 4\ k7 + 2\ k6\ t + 2\ k3\ x + k6\ x\^2)\) + 
      \((k2 + \(k5\ x\)\/2 + t\ \((k3 + k6\ x)\))\)\ u\_x + 
      \[ScriptCapitalF]\_1 + \((k4 + t\ \((k5 + k6\ t)\))\)\ u\_\(x, x\)\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "The  expression ",
  StyleBox["char",
    FontSlant->"Italic"],
  " is inserted into the option given as the seventh argument of ",
  StyleBox["Baecklund[]", "MmaText"],
  ". The sixth argument contains the parameters of the equation if any. The \
check of the equation is carried out by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalSymm\  = \ 
      Baecklund[
        \[PartialD]\_t u[x, t] - \[PartialD]\_\(x, x\)u[x, t] == 0, {u}, {x, 
          t}, {\[PartialD]\_t u[x, t]}, 2, {}, 
        CharExpression \[Rule] {char}]; generalSymm\  // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            \(\((\[ScriptCapitalF]\_1)\)\_t - 
                \((\[ScriptCapitalF]\_1)\)\_\(x, x\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We find that the arbitrary function ",
  StyleBox["free",
    FontSlant->"Italic"],
  "[",
  StyleBox["1",
    FontSlant->"Italic"],
  "] = ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalF]\_1\)]],
  " has to satisfy the diffusion equation itself. The result tells us that  \
the finite transformation properties in ",
  StyleBox["char",
    FontSlant->"Italic"],
  " are generalized symmetries of the diffusion equation. If the \
transformation group consists only of a finite group, the result would be an \
empty list. At this stage of our examinations, we are able to derive the \
generalized symmetries for a certain order of derivatives and we can check a \
given symmetry group to be a generalized symmetry of a specific equation."
}], "Text",
  CellTags->"generalized symmetries"]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.4.2 Potential Burgers Equation", "Subsection",
  CellTags->"Potential Burgers Equation"],

Cell[TextData[{
  "Another example frequently discussed in non-linear dynamics is the ",
  ButtonBox["Burgers equation",
    ButtonData:>{"symmet5.nb", "Burgers equation"},
    ButtonStyle->"Hyperlink"],
  ". Let us examine the potential form of this equation. In a previous \
section, we examined the prolongation formula of the Burgers equation. Here, \
we calculate the generalized symmetries. The potential Burgers equation in \
scaled variables read"
}], "Text",
  CellTags->{
  "nonlinear dynamics", "potential Burgers equation", "prolongation"}],

Cell[BoxData[
    \(TraditionalForm
    \`u\_t\  - \ \ u\_x\%2\  + \ \[Beta]\ u\_\(x, x\) = \ 0. \)], 
  "NumberedEquation"],

Cell[TextData[
"Subscripts in (9.17) denote differentiations. \[Beta] is a real constant \
measuring the dispersion strength. The generalized symmetries of first-order \
for the potential Burgers equation follow by"], "Text",
  CellTags->"dispersion strength"],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalSymmBurgers\  = \ 
      Baecklund[
        \[PartialD]\_t u[x, t] - \((\[PartialD]\_x u[x, t])\)\^2 + \ 
            \[Beta]\ \[PartialD]\_\(x, x\)u[x, t] == 0, {u}, {x, t}, {
          \[PartialD]\_t u[x, t]}, 1, {\[Beta]}]; 
    generalSymmBurgers // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(QC[1]\)[t, x, u, u\_t, u\_x] == 
              C[1] + k1\ u\_x + 
                E\^\(u/\[Beta]\)\ \[Beta]\ \[ScriptCapitalF]\_1\)},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\((\[ScriptCapitalF]\_1)\)\_t\/\[Beta]\),
                  ScriptLevel->0], "+", 
                \(\((\[ScriptCapitalF]\_1)\)\_\(x, x\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          QC[ 1][ t, x, u, 
            Subscript[ u, t], 
            Subscript[ u, x]], 
          Plus[ 
            C[ 1], 
            Times[ k1, 
              Subscript[ u, x]], 
            Times[ 
              Power[ E, 
                Times[ u, 
                  Power[ \[Beta], -1]]], \[Beta], 
              Subscript[ \[ScriptCapitalF], 1]]]], 
        Equal[ 
          Plus[ 
            Times[ 
              Power[ \[Beta], -1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], t]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 1], x, x]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Since equation (9.17) contains the parameter \[Beta], we must tell ",
  StyleBox["Baecklund[]", "MmaText"],
  " that \[Beta] has a special meaning in the calculation. Because the \
parameters are supplied as the sixth argument, we also need to specify the \
order of derivatives on which the characteristics depend. This number is \
given in the fifth argument of ",
  StyleBox["Baecklund[]", "MmaText"],
  ". The resulting characteristic depends on two parameters ",
  Cell[BoxData[
      \(TraditionalForm\`k1\)],
    FontSlant->"Italic"],
  " and ",
  StyleBox["C", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  ", and an auxiliary function ",
  StyleBox["f",
    FontSlant->"Italic"],
  StyleBox["ree", "MmaText",
    FontSlant->"Italic"],
  StyleBox["[", "MmaText"],
  StyleBox["1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["]", "MmaText"],
  " which must satisfy the diffusion equation."
}], "Text",
  CellTags->"Baecklund[]"]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.4.3 Generalized Korteweg-de Vries Equations", "Subsection",
  CellTags->{
  "Korteweg de Vries Equations", "Generalized Korteweg de Vries Equations"}],

Cell["\<\
The Korteweg-de Vries equation (KdV) is a standard equation with a broad \
range of applications. In this example, we examine the generalized symmetries \
of the KdV-Burgers equation (KdVB) for different geometries. The equation \
containing the plane, cylindrical, and spherical coordinates of the KdVB \
equation is\
\>", "Text",
  CellTags->"KdV-Burgers equation"],

Cell[BoxData[
    \(TraditionalForm
    \`u\_t\  + \ \(j\/2\) u\/t\  + \ \[Gamma]\ \(u\^m\) u\_x\  - \ 
        \[Mu]\ u\_\(x, x\)\  + \ \[Beta]\ u\_\(x, x, x\) = 0. \)], 
  "NumberedEquation"],

Cell[TextData[{
  StyleBox["\[ThinSpace]j",
    FontSlant->"Italic"],
  " determines the geometry in which the equation resides (",
  StyleBox["j ",
    FontSlant->"Italic"],
  "= 0 plane geometry, ",
  StyleBox["j ",
    FontSlant->"Italic"],
  "= 1 cylindrical geometry, and ",
  StyleBox["j ",
    FontSlant->"Italic"],
  "= 2 spherical geometry). ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", \[Gamma], \[Mu], and \[Beta] are constants. For ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu] = 0\)]],
  ", the KdV equation follows, and for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta] = 0\)]],
  ", equation (9.18) reduces to the Burgers equation. The power ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " distinguishes between the standard and the generalized potential form of \
the equation. \[Gamma] measures the strength of non-linearity. Let us first \
examine the generalized symmetries for ",
  Cell[BoxData[
      \(TraditionalForm\`m = 1, j = 1\)]],
  ", and arbitrary \[Gamma], \[Mu], and \[Beta]. Applying the function ",
  StyleBox["Baecklund[]", "MmaText"],
  " to this subordinate equation, we find"
}], "Text",
  CellTags->{
  "cylindrical geometry", "spherical geometry", "Burgers equation", 
    "KdV equation", "Baecklund[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalKdVSymm\  = \ 
      Baecklund[
        \[PartialD]\_t u[x, t] + j\/2\ u[x, t]\/t + \ 
              \[Gamma]\ \(u[x, t]\^m\) \[PartialD]\_x u[x, t] - 
              \[Mu]\ \[PartialD]\_\(x, x\)u[x, t]\  + \ 
              \[Beta]\ \[PartialD]\_\(x, x, x\)u[x, t] == 0\  /. {
            j \[Rule] 1, m \[Rule] 1}, {u}, {x, t}, {\[PartialD]\_t u[x, t]}, 
        1, {\[Gamma], \[Mu], \[Beta]}]; 
    \(generalKdVSymm // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            RowBox[{\(\(QC[1]\)[t, x, u, u\_t, u\_x]\), "==", 
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(k1\/\(\@t\ \[Gamma]\)\),
                    ScriptLevel->0]}], "+", 
                \(\((k2 + 2\ k1\ \@t)\)\ u\_x\)}]}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          QC[ 1][ t, x, u, 
            Subscript[ u, t], 
            Subscript[ u, x]], 
          Plus[ 
            Times[ -1, k1, 
              Power[ t, 
                Rational[ -1, 2]], 
              Power[ \[Gamma], -1]], 
            Times[ 
              Plus[ k2, 
                Times[ 2, k1, 
                  Power[ t, 
                    Rational[ 1, 2]]]], 
              Subscript[ u, x]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The generalized symmetry in first-order representation consists of two \
symmetries: a constant term and a term describing a translation in ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The reader may check the KdVB equation for other choices of parameters \
and higher-order representations of the characteristics. Other \
third-order-equations of KdV-type include"
}], "Text",
  CellTags->{"generalized symmetry", "KdVB equation"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`u\_t\  + \ u\_\(x, x, x\) - \ \(1\/8\) u\_x\%3\  + \ 
          \(u\_x\)(\[Alpha]\ e\^u + \[Beta]e\^\(-u\) + \[Gamma]) = 0\)]],
  ","
}], "NumberedEquation"],

Cell[TextData[{
  "where \[Alpha], \[Beta], and \[Gamma] are real constants. Equation (9.19) \
was discussed by ",
  ButtonBox["Calogero and Degasperis [1981]",
    ButtonData:>{"Literat.nb", "Calogero-1981"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Fokas [1980]",
    ButtonData:>{"Literat.nb", "Fokas-1980"},
    ButtonStyle->"Hyperlink"],
  " in connection with exactly solvable equations. The generalized symmetries \
of this equation follow by"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalKdVSymm\  = \ 
      Baecklund[
        \[PartialD]\_t u[x, t] + \ \[PartialD]\_\(x, x, x\)u[x, t] - 
            \(1\/8\) \((\[PartialD]\_x u[x, t])\)\^3 + \ 
            \[PartialD]\_x u[x, t] 
              \((\[Alpha]\ Exp[u[x, t]] + \[Beta]\ Exp[\(-u[x, t]\)] + 
                  \[Gamma])\) == 0, {u}, {x, t}, {\[PartialD]\_t u[x, t]}, 
        1, {\[Alpha], \[Beta], \[Gamma]}]; generalKdVSymm\  // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(QC[1]\)[t, x, u, u\_t, u\_x] == k1\ u\_x\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          QC[ 1][ t, x, u, 
            Subscript[ u, t], 
            Subscript[ u, x]], 
          Times[ k1, 
            Subscript[ u, x]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Again, we find, in lowest order approximation of the characteristic, a \
single expression representing a translation. Another kind of KdV equation \
demonstrating the application of ",
  StyleBox["Baecklund[]", "MmaText"],
  " to a system of equations is the ",
  ButtonBox["Hirota and Satsuma [1981]",
    ButtonData:>{"Literat.nb", "Hirota-1981"},
    ButtonStyle->"Hyperlink"],
  " (HS) equation, which is discussed in connection with soliton solutions. \
The model equations are"
}], "Text",
  CellTags->"Hirota and Satsuma equation"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(u\_t\), "+", \(u\_\(x, x, x\)\), "+", " ", 
            RowBox[{"6", 
              SubscriptBox[
                StyleBox["uu",
                  FontSlant->"Italic"], "x"]}], "-", 
            RowBox[{"6", 
              SubscriptBox[
                StyleBox["vv",
                  FontSlant->"Italic"], "x"]}]}], " ", "=", " ", "0"}], 
        ","}], TraditionalForm]], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`\(\ \ \ \ \ \ \ \ \ \ \ 
    v\_t\  - 2\ v\_\(x, x, x\) - \ 6  u\ v\_x\  = \ 0. \)\)], 
  "NumberedEquation"],

Cell["The generalized symmetries of this system follow by", "Text",
  CellTags->"generalized symmetries"],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalKdVSymm\  = \ 
      Baecklund[{
          \[PartialD]\_t u[x, t] + \ \[PartialD]\_\(x, x, x\)u[x, t] + 
              6\ u[x, t] \[PartialD]\_x u[x, t] + \ 
              2  v[x, t] \[PartialD]\_x v[x, t] == 0, 
          \[PartialD]\_t v[x, t]\  - \ 2\ \[PartialD]\_\(x, x, x\)v[x, t] - 
              6\ u[x, t]\ \[PartialD]\_x v[x, t] == 0}, {u, v}, {x, t}, {
          \[PartialD]\_t u[x, t], \[PartialD]\_t v[x, t]}, 2]; 
    generalKdVSymm // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(QC[1]\)[t, x, u, v, u\_t, v\_t, u\_\(t, t\), v\_\(t, t\), 
                u\_x, v\_x, u\_\(x, t\), v\_\(x, t\), \n\ \ \ \ \ 
                u\_\(x, x\), v\_\(x, x\)] == k1\ u\_x\)},
          {
            \(\(QC[2]\)[t, x, u, v, u\_t, v\_t, u\_\(t, t\), v\_\(t, t\), 
                u\_x, v\_x, u\_\(x, t\), v\_\(x, t\), \n\ \ \ \ \ 
                u\_\(x, x\), v\_\(x, x\)] == k1\ v\_x\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          QC[ 1][ t, x, u, v, 
            Subscript[ u, t], 
            Subscript[ v, t], 
            Subscript[ u, t, t], 
            Subscript[ v, t, t], 
            Subscript[ u, x], 
            Subscript[ v, x], 
            Subscript[ u, x, t], 
            Subscript[ v, x, t], 
            Subscript[ u, x, x], 
            Subscript[ v, x, x]], 
          Times[ k1, 
            Subscript[ u, x]]], 
        Equal[ 
          QC[ 2][ t, x, u, v, 
            Subscript[ u, t], 
            Subscript[ v, t], 
            Subscript[ u, t, t], 
            Subscript[ v, t, t], 
            Subscript[ u, x], 
            Subscript[ v, x], 
            Subscript[ u, x, t], 
            Subscript[ v, x, t], 
            Subscript[ u, x, x], 
            Subscript[ v, x, x]], 
          Times[ k1, 
            Subscript[ v, x]]]}]]], "Output"]
}, Open  ]],

Cell["\<\
Surprisingly, the HS system has only a one-parameter finite symmetry group \
depending on first-order derivatives. This happens even though we examined \
characteristics depending on second-order derivatives.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.4.4 Coupled System of Wave Equations", "Subsection",
  CellTags->"Coupled System of Wave Equations"],

Cell[TextData[{
  "Another example to demonstrate the capabilities of ",
  StyleBox["Baecklund[]", "MmaText"],
  " is the application to a coupled system of simple wave equations. This \
example serves to demonstrate that ",
  StyleBox["Baecklund[]", "MmaText"],
  " is capable of finding symmetries of systems of equations. We generalized \
the example given by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  " to a system of two equations. The two fields ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " are coupled to each other via the gradients. The generalized symmetries \
for the system of equations"
}], "Text",
  CellTags->{"wave equations", "Baecklund[]"}],

Cell[BoxData[
    \(TraditionalForm\`\(u\_t\  - v\ u\_x\  = \ 0, \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm\`v\_t - \ u\ v\_x\  = \ 0\)], "NumberedEquation"],

Cell["follow by", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(generalSymmWave\  = \ 
      Baecklund[{
          \[PartialD]\_t u[x, t] - \ v[x, t]\ \[PartialD]\_x u[x, t] == 0, 
          \[PartialD]\_t v[x, t]\  - u[x, t]\ \[PartialD]\_x v[x, t]}, {u, 
          v}, {x, t}, {\[PartialD]\_t u[x, t], \[PartialD]\_t v[x, t]}]; 
    \(generalSymmWave // Flatten\) // LTF\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(\(QC[1]\)[t, x, u, v, u\_t, v\_t, u\_x, v\_x] == 
              \(-k4\) - k1\ u - k2\ u\^2 - k3\ u\_x - k4\ t\ u\_x + 
                k1\ x\ u\_x + k2\ v\ x\ u\_x + u\_x\ \[ScriptCapitalF]\_1 + 
                u\_x\ \[ScriptCapitalF]\_2 + v\ u\_x\ \[ScriptCapitalF]\_3 - 
                u\_x\ \[ScriptCapitalF]\_4 - v\ u\_x\ \[ScriptCapitalF]\_5 - 
                u\ \((\[ScriptCapitalF]\_5)\)\_t\)},
          {
            \(\(QC[2]\)[t, x, u, v, u\_t, v\_t, u\_x, v\_x] == 
              \(-k4\) - k1\ v - k2\ v\^2 - k3\ v\_x - k4\ t\ v\_x + 
                k1\ x\ v\_x + k2\ u\ x\ v\_x + v\_x\ \[ScriptCapitalF]\_1 + 
                v\_x\ \[ScriptCapitalF]\_2 + u\ v\_x\ \[ScriptCapitalF]\_3 - 
                v\_x\ \[ScriptCapitalF]\_4 - u\ v\_x\ \[ScriptCapitalF]\_5 + 
                u\ v\_x\ \((\[ScriptCapitalF]\_1)\)\_v - 
                v\ v\_x\ \((\[ScriptCapitalF]\_1)\)\_v - 
                u\ v\_x\ \((\[ScriptCapitalF]\_4)\)\_v + 
                v\ v\_x\ \((\[ScriptCapitalF]\_4)\)\_v - 
                v\ \((\[ScriptCapitalF]\_5)\)\_t\)},
          {
            RowBox[{
              
              StyleBox[
                \(\(\(-k3\) + k5 - k4\ t + k6\ t - \[ScriptCapitalF]\_4 - 
                      v\ \[ScriptCapitalF]\_5 + t\ \[ScriptCapitalF]\_6 + 
                      \[ScriptCapitalF]\_7\)\/t\),
                ScriptLevel->0], "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\((\[ScriptCapitalF]\_2)\)\_u\/u\),
                  ScriptLevel->0], "+", \(\((\[ScriptCapitalF]\_3)\)\_u\)}], 
              "==", "0"}]}
          },
        RowSpacings->2,
        ColumnSpacings->3,
        ColumnWidths->0.95,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          QC[ 1][ t, x, u, v, 
            Subscript[ u, t], 
            Subscript[ v, t], 
            Subscript[ u, x], 
            Subscript[ v, x]], 
          Plus[ 
            Times[ -1, k4], 
            Times[ -1, k1, u], 
            Times[ -1, k2, 
              Power[ u, 2]], 
            Times[ -1, k3, 
              Subscript[ u, x]], 
            Times[ -1, k4, t, 
              Subscript[ u, x]], 
            Times[ k1, x, 
              Subscript[ u, x]], 
            Times[ k2, v, x, 
              Subscript[ u, x]], 
            Times[ 
              Subscript[ u, x], 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ 
              Subscript[ u, x], 
              Subscript[ \[ScriptCapitalF], 2]], 
            Times[ v, 
              Subscript[ u, x], 
              Subscript[ \[ScriptCapitalF], 3]], 
            Times[ -1, 
              Subscript[ u, x], 
              Subscript[ \[ScriptCapitalF], 4]], 
            Times[ -1, v, 
              Subscript[ u, x], 
              Subscript[ \[ScriptCapitalF], 5]], 
            Times[ -1, u, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 5], t]]]], 
        Equal[ 
          QC[ 2][ t, x, u, v, 
            Subscript[ u, t], 
            Subscript[ v, t], 
            Subscript[ u, x], 
            Subscript[ v, x]], 
          Plus[ 
            Times[ -1, k4], 
            Times[ -1, k1, v], 
            Times[ -1, k2, 
              Power[ v, 2]], 
            Times[ -1, k3, 
              Subscript[ v, x]], 
            Times[ -1, k4, t, 
              Subscript[ v, x]], 
            Times[ k1, x, 
              Subscript[ v, x]], 
            Times[ k2, u, x, 
              Subscript[ v, x]], 
            Times[ 
              Subscript[ v, x], 
              Subscript[ \[ScriptCapitalF], 1]], 
            Times[ 
              Subscript[ v, x], 
              Subscript[ \[ScriptCapitalF], 2]], 
            Times[ u, 
              Subscript[ v, x], 
              Subscript[ \[ScriptCapitalF], 3]], 
            Times[ -1, 
              Subscript[ v, x], 
              Subscript[ \[ScriptCapitalF], 4]], 
            Times[ -1, u, 
              Subscript[ v, x], 
              Subscript[ \[ScriptCapitalF], 5]], 
            Times[ u, 
              Subscript[ v, x], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], v]], 
            Times[ -1, v, 
              Subscript[ v, x], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 1], v]], 
            Times[ -1, u, 
              Subscript[ v, x], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 4], v]], 
            Times[ v, 
              Subscript[ v, x], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 4], v]], 
            Times[ -1, v, 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 5], t]]]], 
        Equal[ 
          Times[ 
            Power[ t, -1], 
            Plus[ 
              Times[ -1, k3], k5, 
              Times[ -1, k4, t], 
              Times[ k6, t], 
              Times[ -1, 
                Subscript[ \[ScriptCapitalF], 4]], 
              Times[ -1, v, 
                Subscript[ \[ScriptCapitalF], 5]], 
              Times[ t, 
                Subscript[ \[ScriptCapitalF], 6]], 
              Subscript[ \[ScriptCapitalF], 7]]], 0], 
        Equal[ 
          Plus[ 
            Times[ 
              Power[ u, -1], 
              Subscript[ 
                Subscript[ \[ScriptCapitalF], 2], u]], 
            Subscript[ 
              Subscript[ \[ScriptCapitalF], 3], u]], 0]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We realize that the characteristics depend on seven auxiliary functions ",
  StyleBox["free[i]",
    FontSlant->"Italic"],
  ". These functions are connected by one algebraic and one differential \
expression. The dependence in this algebraic form could not be resolved by \
the function ",
  StyleBox["PDESolve[]", "MmaText"],
  ". However, we find information on the generalized symmetries in a \
straightforward way."
}], "Text",
  CellTags->{"characteristics", "PDESolve[]"}],

Cell["\<\
So far, we discussed the application of generalized symmetries to \
PDEs. The following section will demonstrate the application of generalized \
symmetries in connection with ODEs.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.",
  CounterBox["Section"],
  ".",
  " Second-Order ODEs and the Euler-Lagrange Equation"
}], "Section",
  CellTags->"Second-Order ODEs and the Euler-Lagrange equation"],

Cell["\<\
A great number of problems in physics can be described by second-order \
ordinary differential equations\
\>", "Text",
  CellTags->"second order ODEs"],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(\(\[CapitalDelta]\_k\)(t, q\& . \_j, \(q\& .. \)\_j)\  = \ 0\), ",", 
        "      ", 
        FormBox[\(k, j = 1, 2, \[Ellipsis], N\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(q\_j\),
            "TraditionalForm"], "=", \(\(q\_j\)(t)\)}], TraditionalForm]]],
  " are a set of dependent variables. Dots denote derivatives with respect to \
time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". The ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_k\)]],
  "\[CloseCurlyQuote]s are given functions of the dependent and independent \
variables. For example, we can think of these expressions as Newton\
\[CloseCurlyQuote]s or Lagrange\[CloseCurlyQuote]s equations."
}], "Text",
  CellTags->{"Newton's equations", "Lagrange's equations"}],

Cell[TextData[{
  "Let us assume that (9.24) can be derived from a generating functional ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". The action ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " and the ",
  ButtonBox["calculus of variations",
    ButtonData:>{"derivat1.nb", "The Problem of Variations"},
    ButtonStyle->"Hyperlink"],
  " are the two keys of Hamilton\[CloseCurlyQuote]s principle and allow us to \
derive the equations of motion (9.24). The variation of an individual path ",
  Cell[BoxData[
      \(TraditionalForm\`q\_j\)]],
  " in the action"
}], "Text",
  CellTags->{
  "calculus of variations", "Hamilton's principle", "variation of a path"}],

Cell[BoxData[
    \(TraditionalForm
    \`S = \ \[Integral]\_t\_1\%t\_2\( \[GothicCapitalL](t, q\_j, 
            q\_j\%\[Prime])\) \[DifferentialD]t\)], "NumberedEquation"],

Cell[TextData[{
  "provides us with the equations of motion. We already know from the \
discussion in ",
  ButtonBox["Section 3.6.1",
    ButtonData:>{"derivat1.nb", "The Problem of Variations"},
    ButtonStyle->"Hyperlink"],
  " that the calculus of variations applied to (9.25) is equivalent with the \
",
  ButtonBox["Euler derivative",
    ButtonData:>{"derivat1.nb", "The Euler derivative"},
    ButtonStyle->"Hyperlink"],
  ". The resulting equations (9.24) are known as the Euler-Lagrange \
equations"
}], "Text",
  CellTags->{"Euler derivative", "Euler-Lagrange equations"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\(\[GothicCapitalE]\_k\)(\[GothicCapitalL])\), "=", 
          RowBox[{\(\[CapitalDelta]\_k\), "=", 
            RowBox[{
              FractionBox[
                StyleBox[
                  RowBox[{"\[Delta]", 
                    StyleBox["S",
                      FontFamily->"Times",
                      FontSize->10,
                      FontWeight->"Roman",
                      FontSlant->"Italic",
                      FontTracking->"Plain",
                      PrivateFontOptions->{
                      "FontPostScriptName"->Automatic}]}]], 
                SubscriptBox[
                  StyleBox[
                    RowBox[{"\[Delta]", 
                      StyleBox["q",
                        FontFamily->"Times",
                        FontSize->10,
                        FontWeight->"Roman",
                        FontSlant->"Italic",
                        FontTracking->"Plain",
                        PrivateFontOptions->{
                        "FontPostScriptName"->Automatic}]}]], "k"]], " ", 
              "=", " ", "0"}]}]}], ",", "      ", 
        RowBox[{
          FormBox[\(k = 1, 2, \[Ellipsis], N\),
            "TraditionalForm"], "."}]}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "The symbol ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox["\[Delta]", 
            SubscriptBox[
              StyleBox[
                RowBox[{"\[Delta]", 
                  StyleBox["q",
                    FontSlant->"Italic"]}]], "k"]], "=", " ", 
          RowBox[{\(\[Sum]\+\(n = 0\)\%\[Infinity]\), 
            RowBox[{\(\((\(-1\))\)\^n\), 
              FractionBox[\(d\^n\), 
                SuperscriptBox[
                  StyleBox["dt",
                    FontSlant->"Italic"], "n"]], 
              \((\[PartialD]\/\[PartialD]q\_\(k; \((n)\)\))\)}]}]}], 
        TraditionalForm]],
    ScriptLevel->1],
  " denotes the variational derivative and the ",
  ButtonBox["Euler derivative",
    ButtonData:>{"derivat1.nb", "Definition: Euler Operator"},
    ButtonStyle->"Hyperlink"],
  " is labeled by ",
  Cell[BoxData[
      \(TraditionalForm\`\[GothicCapitalE]\_k\)]],
  ". At this stage of the discussion, we know the equations of motion and \
certainly the physical interpretation. However, it is unknown to us under \
which conditions solutions of (9.24) can be found. The following section will \
outline how solutions of a second-order system of ODEs can be calculated by \
examining generalized symmetries of (9.24)."
}], "Text",
  CellTags->{
  "variational derivative", "Euler derivative", "generalized symmetries"}],

Cell[CellGroupData[{

Cell["9.5.1 Generalized Symmetries and Second-Order ODEs", "Subsection",
  CellTags->"Calculation of Generalized Symmetries"],

Cell[TextData[{
  "It is known that Lie\[CloseCurlyQuote]s original procedure ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(pr\^\((2)\)\) v\&\[RightVector]\ 
        \[CapitalDelta]  |\_\(\[CapitalDelta] = 0\)\ \( = \ 0\)\)]],
  " does not deliver all possible symmetries of a second-order ODE. For \
example, ",
  ButtonBox["Abraham-Shrauner and Guol [1993]",
    ButtonData:>{"Literat.nb", "Abraham-Schrauner-93"},
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  " discuss so-called ",
  StyleBox["hidden symmetries",
    FontSlant->"Italic"],
  " in connection with ordinary differential equations. At the turn of the \
century, ",
  ButtonBox["Emmy Noether [1918]",
    ButtonData:>{"Literat.nb", "Noether-18"},
    ButtonStyle->"Hyperlink"],
  " examined ODEs in connection with generalized point transformations. In \
turn, we have to use a generalized method to uncover the \
\[OpenCurlyDoubleQuote]hidden\[CloseCurlyDoubleQuote] symmetries. A \
generalization of the point transformations can be gained if the \
infinitesimals ",
  Cell[BoxData[
      \(TraditionalForm\`\[Xi]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_\[Alpha]\)]],
  " do not depend only on the dependent and independent variables but also on \
derivatives of the ",
  Cell[BoxData[
      \(TraditionalForm\`q\_i\)]],
  "\[CloseCurlyQuote]s. In the case of second-order ODEs, the space of \
coordinates needs to be extended by the first derivatives. All higher \
derivatives can be eliminated by the differential equations themselves or \
differential consequences of the equations. For a shorthand notation to \
denote the extended dependencies including derivatives, we use square \
brackets ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{\([q]\), 
                FormBox[\( = \((t, q\_i\)\),
                  "TraditionalForm"]}], ",", \(q\& . \_i\)}],
            "TraditionalForm"], ")"}], TraditionalForm]]],
  " in the infinitesimals ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              FormBox["\[Xi]",
                "TraditionalForm"], "=", "\[Xi]"}],
            "TraditionalForm"], "[", "q", "]"}], TraditionalForm]]],
  " and",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(\[Phi]\_i\),
              "TraditionalForm"], "=", " ", 
            FormBox[
              RowBox[{
                FormBox[\(\[Phi]\_i\),
                  "TraditionalForm"], "[", "q", "]"}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  "."
}], "Text",
  ShowCellBracket->True,
  CellTags->{"hidden symmetries", "generalized point transformations"}],

Cell["\<\
The corresponding generalized vector field for such transformations can \
formally be given by\
\>", "Text",
  CellTags->"generalized vector field"],

Cell[BoxData[
    \(TraditionalForm
    \`v\&\[RightVector]\  = \ 
      \[Xi][q]\ \[PartialD]\_t\ 
          \(+\ \(\[Sum]\+\(i = 1\)\%N \[Phi]\_i[q]\ 
                \[PartialD]\_\(q\_i\) . \)\)\)], "NumberedEquation"],

Cell[TextData[{
  "In a second step, we can introduce the characteristics for second-order \
ODEs by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(Q\_i[q]\),
            "TraditionalForm"], "=", 
          RowBox[{
            FormBox[
              RowBox[{
                FormBox[\(\[Phi]\_i[q]\),
                  "TraditionalForm"], "-", \(\[Xi][q]\)}],
              "TraditionalForm"], 
            FormBox[\(q\& . \),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". The corresponding vector field has the representation"
}], "Text",
  CellTags->"characteristics"],

Cell[BoxData[
    \(TraditionalForm
    \`v\&\[RightVector]\_Q\  = \ 
      \[Sum]\+\(i = 1\)\%N Q\_i[q]\ \[PartialD]\_\(q\_i\) . \)], 
  "NumberedEquation"],

Cell["\<\
The symmetries contained in (9.4) and (9.28) are essentially the \
same. The only difference is that (9.28) considers transformations of the \
dependent variables and derivatives in the extended form while (9.4) \
additionally takes into account a transformation of the independent \
variables. The main advantage of the evolutionary representation is its \
simplicity in the representation of the prolongation\
\>", "Text",
  CellTags->{"evolutionary representation", "prolongation"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(pr \( v\& \[RightVector] \)\_Q\), " ", "=", " ", 
        RowBox[{
        \(\[Sum]\+\(i = 1\)\%N\), \(\[Sum]\+\(J = 0\)\%\[Infinity]\), 
          RowBox[{
            FractionBox[\(d\^J\), 
              SuperscriptBox[
                StyleBox["dt",
                  FontSlant->"Italic"], \(\ J\)]], \((Q\_j[q])\), " ", 
            \(\[PartialD]\_\(q\_\(i; \((j)\)\)\) . \)}]}]}], 
      TraditionalForm]], "NumberedEquation"],

Cell["\<\
The assumption in the calculation of the related symmetries of \
(9.1) is the same as in the case of point symmetries. Thus, the computation \
of the generalized symmetries proceeds in essentially the same way as the \
computation of Lie point symmetries. Since we consider the variables and \
derivatives as independent up to a fixed order, we not only take equations \
(9.1) into account but also consider the derivatives of (9.1) as concerns the \
invariance condition. The invariance condition remains nearly the same and \
reads\
\>", "Text",
  CellTags->{
  "Lie point symmetries", "generalized symmetries", "invariance condition"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"pr", \(v\&\[RightVector]\_Q\), " ", \(\[CapitalDelta]\_k\), 
          SubscriptBox["\[VerticalSeparator]", 
            RowBox[{
              FractionBox[\(\(d\^J\) \[CapitalDelta]\_k\), 
                SuperscriptBox[
                  StyleBox["dt",
                    FontSlant->"Italic"], "J"]], "=", "0"}]]}], " ", "=", 
        " ", 
        RowBox[{"0", "       ", "with", " ", 
          FormBox[\(J = 0, 1, 2, \[Ellipsis]\),
            "TraditionalForm"], " ", "and", " ", 
          RowBox[{
            FormBox[\(k = 1, 2, \[Ellipsis]\),
              "TraditionalForm"], "."}]}]}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "Contrary to point symmetries, differential equations can be used to \
eliminate higher derivatives and also the differential consequences of \
equations (9.1). Equation (9.30) provides the determining equations for the \
characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  ". Although linear, it is very tricky to solve this system of equations, as \
it yields a large overdetermined system of equations. With some skill, \
solutions of (9.30) can be found by an ad hoc ansatz for the ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  "\[CloseCurlyQuote]s; for example, by assuming that ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  " has a special form (polynomial or power form) in the arguments. By this \
method, equation (9.30) will split into several equations that may or may not \
 have a non-zero solution. "
}], "Text",
  CellTags->{
  "determining equations for the characteristics", 
    "overdetermined system of equations"}],

Cell[TextData[{
  "In ",
  StyleBox["Baecklund[]", "MmaText"],
  ", we use an ansatz of polynomial form in the coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`q\_i\)]],
  " and momenta ",
  Cell[BoxData[
      \(TraditionalForm\`q\& . \_i\)]],
  ". This ansatz is exclusively used for second-order ODEs. If we can solve \
the resulting system of linear equations in the coefficients introduced by \
the ansatz, we will have determined the characteristics up to some power. \
This information can, in turn, be used to construct conservation laws and \
invariant solutions."
}], "Text",
  CellTags->{"Baecklund[]", "conservation laws", "invariant solution"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.5.2 Conservation Laws", "Subsection",
  Evaluatable->False,
  CellTags->"Conservation laws"],

Cell[TextData[{
  "With equation (9.26), we assume that the system of equations (9.1) is \
derivable by a variation of the path ",
  Cell[BoxData[
      \(TraditionalForm\`q\_i\)]],
  ". In close analogy to the question of invariance of (9.1), we can ask for \
the invariance of the action itself. This means that we have to assume"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Integral]\_t\_1\%t\_2\( \[GothicCapitalL](t, q\_i, q\& . \_i)\) 
          \[DifferentialD]t\  = \ 
      \[Integral]\_\(t\_1\%*\)\%\(t\_2\%*\)\(\[GothicCapitalL](\(t\^*\), 
            \(q\_i\%*\), \(q\& . \_i\%*\))\) 
          \(\[DifferentialD]\(t\^*\) . \)\)], "NumberedEquation"],

Cell["Two questions arise at this point:", "Text"],

Cell[TextData[
"Are the group elements g \[Element] \[GothicCapitalG] of (9.31) derivable \
from infinitesimal conditions?"], "ListItem",
  CellDingbat->"1."],

Cell["\<\
How are the symmetries of the Euler-Lagrange equations related to \
these variational symmetries? \
\>", "ListItem",
  CellDingbat->"2.",
  CellTags->{"variational symmetries", "Euler-Lagrange equations"}],

Cell["\<\
It is obvious that local transformations preserving the invariance of a \
functional transform one solution of the variational problem into another. \
This must be the case if relation (9.31) is correct. Thus, we can use Lie\
\[CloseCurlyQuote]s procedure applied to the Euler-Lagrange equations \
corresponding to (9.26), taking into account that not all symmetries of \
equations (9.1) are symmetries of (9.26). To uncover the variational \
symmetries, we can use the methods discussed so far but, in addition, need to \
check the relation\
\>", "Text",
  CellTags->{"Euler-Lagrange equations", "variational symmetries"}],

Cell[BoxData[
    FormBox[
      RowBox[{
      \(pr  v\&\[RightVector]\_Q\ \[CapitalDelta]\_k\  + \ 
            \(\[GothicCapitalD]\_Q\%*\) \[CapitalDelta]\_k\  = \ 0\), ",", 
        "     ", 
        FormBox[\(k = 1, 2, \[Ellipsis], N\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[GothicCapitalD]\_Q\%*\)\)]],
  " denotes the adjoint Fr\[EAcute]chet derivative of the characteristic ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  ". The evolutionary vector field ",
  Cell[BoxData[
      \(TraditionalForm\`v\&\[RightVector]\_Q\)]],
  " with its characteristic ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  " is a variational symmetry if equation (9.32) holds for all ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_i\)]],
  ". We now have a criterion singling out these symmetries from the \
generalized symmetries which are also variational symmetries. Noether",
  "\[CloseCurlyQuote]s",
  " theorem establishes the connection between the variational symmetries \
with their characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  " and the conserved quantities. The case of one independent variable can be \
summarized in the formula"
}], "Text",
  CellTags->{
  "Noether's theorem", "Fr\[EAcute]chet derivative", 
    "evolutionary vector field", "variational symmetry", 
    "generalized symmetries", "conserved quantities"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            StyleBox["dI",
              FontSlant->"Italic"], 
            StyleBox["dt",
              FontSlant->"Italic"]], " ", "=", " ", 
          \(\[Sum]\+\(i = 1\)\%N\( Q\_i\) \[CapitalDelta]\_i = \ 0\)}], 
        ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "which is a special case of the more general divergence formula given by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ". The essential points in determining integrals of motion for a given \
Euler-Lagrange system are, first, to find the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  " for the variational symmetries, and, second, to integrate equation \
(9.33). These two steps among others are implemented in ",
  StyleBox["MathLie.",
    FontSlant->"Italic"],
  " To show how the outlined analysis can be used in practical applications, \
we will give some examples demonstrating the application of ",
  StyleBox["Baecklund[]", "MmaText"],
  ". However, we first collect the essential steps of the algorithm to \
calculate integrals for second-order equations."
}], "Text",
  CellTags->{
  "divergence formula", "integrals of motion", "Euler-Lagrange system", 
    "variational symmetries", "Baecklund[]"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.",
  CounterBox["Section"],
  ".",
  " Algorithm for Conservation Laws of Second-Order ODEs"
}], "Section",
  CellTags->"Algorithm for conservation laws of second-order ODEs"],

Cell[TextData[{
  "The algorithm uses the notation by ",
  ButtonBox["Olver [1986]",
    ButtonData:>{"Literat.nb", "Olve-86"},
    ButtonStyle->"Hyperlink"],
  ". The work of Olver is instrumental in a direct implementation. Using the \
earlier notations, the algorithm involves the following steps:"
}], "Text",
  CellTags->"algorithm"],

Cell[TextData[{
  "Applying the prolongation operator ",
  Cell[BoxData[
      \(TraditionalForm\`pr \( v\& \[RightVector] \)\_Q\)]],
  " to each equation ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalDelta]\_i\)(x, u\_\((k)\))\)]],
  " and requiring that equation (9.30) be satisfied. "
}], "ListItem",
  CellDingbat->"1.",
  CellTags->"prolongation operator"],

Cell[TextData[{
  "Consider equation (9.30) as an algebraic system where derivatives become \
the new variables. Provided this system of algebraic equations can be solved \
by ",
  StyleBox["Solve[]", "MmaText"],
  ", we can gain ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " solutions ",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Beta]\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta] = 1, 2, \[Ellipsis], m\)]],
  " which contain the equations ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  ". The variables ",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Beta]\)]],
  " and derivatives of these relations are used as side conditions in \
equation (9.30)."
}], "ListItem",
  CellDingbat->"2.",
  CellTags->"Solve[]"],

Cell[TextData[{
  "Extract the determining equations for the characteristics ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_\[Alpha]\)]],
  " by equating the coefficients of all functionally independent expressions \
in the derivatives ",
  Cell[BoxData[
      \(TraditionalForm\`u\_J\%\[Alpha]\)]],
  " to zero."
}], "ListItem",
  CellDingbat->"3.",
  CellTags->{"determining equations", "characteristics"}],

Cell["\<\
Simplifying the total number of equations by using the first-order \
derivatives and homogeneous higher-order derivatives for the characteristics. \
This step is repeated until the number of determining equations reaches a \
stable value.\
\>", "ListItem",
  CellDingbat->"4."],

Cell["\<\
If the determining equations are known, it may be possible to solve \
these equations by using an ansatz of polynomials for the characteristics. We \
note that this step will not provide the most general solution of ordinary \
differential equations, if such one exists, but delivers at least a sub-class \
of solutions.\
\>", "ListItem",
  CellDingbat->"5.",
  CellTags->"polynomial"],

Cell[TextData[{
  "This procedure works expediently as long as the variables ",
  Cell[BoxData[
      \(TraditionalForm\`w\^\[Beta]\)]],
  " are obtainable by ",
  StyleBox["Solve[]", "MmaText"],
  " from the equations of motion (9.1) and if ",
  StyleBox["Solve[]", "MmaText"],
  " can find a solution from the linear equations for the constants used in \
the ansatz of the characteristics. The manual procedure, feeding back some \
information on the characteristics gained by partly solving the determining \
equations, is completely independent of the automatic solution procedure. If \
one is convinced that the ansatz used in ",
  StyleBox["Baecklund[]", "MmaText"],
  " does not provide the most general solution, one can use a manual and \
iterative procedure to find the solutions of the determining equations."
}], "Text",
  CellTags->"Solve[]"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.",
  CounterBox["Section"],
  ".",
  " Examples for Second-Order ODEs"
}], "Section",
  CellTags->"Examples for second-order ODEs"],

Cell["\<\
In this section, we will deal with the application of the generalized \
symmetry method previously introduced. We discuss the H\[EAcute]non-Heiles \
model, a quartic anharmonic oscillator, and the problem of two ions in a Paul \
trap.\
\>", "Text",
  CellTags->{
  "H\[EAcute]non-Heiles model", "quartic anharmonic oscillator", 
    "two ions in a Paul trap", "Paul trap"}],

Cell[CellGroupData[{

Cell["9.7.1 The H\[EAcute]non-Heiles Model", "Subsection",
  CellTags->"The Henon-Heiles model"],

Cell[TextData[{
  "The H\[EAcute]non-Heiles model for gravitating stars in a cylindrical \
galaxy is described by a set of two coupled non-linear second-order ODEs. The \
model in its original form with fixed parameters was used by ",
  ButtonBox["H\[EAcute]non and Heiles [1964]",
    ButtonData:>{"Literat.nb", "Henon-1964"},
    ButtonStyle->"Hyperlink"],
  " to examine the regular and chaotic motion of a star in a galaxy. Here, we \
are interested in the regular motion of the H\[EAcute]non-Heiles system. The \
two equations of motion are"
}], "Text",
  CellTags->{
  "gravitating stars", "regular and chaotic motion", 
    "regular motion of the H\[EAcute]non-Heiles system"}],

Cell[BoxData[
    \(TraditionalForm\`\(\(q\& .. \)\_1 + \ A\ q\_1 + \ 2  D\ q\_1\ q\_2 = 0, 
    \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(q\& .. \)\_2 + \ B\ q\_2 + \ D\ q\_1\%2 - C\ q\_2\%2 = 0, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", ",
  StyleBox["C",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["D",
    FontSlant->"Italic"],
  " are model parameters. In the original equations of H\[EAcute]non and \
Heiles, these parameters were fixed to a certain value. For these values, H\
\[EAcute]non and Heiles found chaotic behavior of the model if the total \
energy of the system is increased. Our interest here is to find those \
parameter combinations for which equations (9.34) and (9.35) possess symbolic \
solutions. It is known that the two equations of motion follow from the \
Lagrangian"
}], "Text",
  CellTags->{"total energy", "symbolic solution", "Lagrangian"}],

Cell[BoxData[
    FormBox[
      RowBox[{"L", " ", "=", " ", 
        RowBox[{"\[Integral]", 
          RowBox[{"(", 
            RowBox[{
              FormBox[
                RowBox[{
                  RowBox[{
                  \(\(1\/2\) \((q\& . \_1\%2 + q\& . \_2\%2)\)\), "-", 
                    \(\(A\/2\) q\_1\%2\), "-", \(\(B\/2\) q\_2\%2\), "-", 
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["Dq",
                          FontSlant->"Italic"], "1", "2"], \(q\_2\)}], "+", 
                    \(\(C\/3\) q\_2\%3\)}], ")"}],
                "TraditionalForm"], \(\[DifferentialD]t . \)}]}]}]}], 
      TraditionalForm]], "NumberedEquation"],

Cell["\<\
Applying the Euler derivative to the density of the Lagrangian, we can write \
down the equations of motion (9.34) and (9.35) by\
\>", "Text",
  CellTags->"Euler derivative"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HenonHeiles\  = 
      Thread[\[ScriptCapitalE]\_{q1, q2}\%t[
            \((\(1\/2\) 
                  \((\((\[PartialD]\_t q1[t])\)\^2 + 
                      \((\[PartialD]\_t q2[t])\)\^2)\) - \(A\/2\) q1[t]\^2 - 
                \(B\/2\) q2[t]\^2 - D\ \(q1[t]\^2\) q2[t] + \(C\/3\) q2[t]\^3)
              \)] == {0, 0}]; HenonHeiles // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(\(-A\)\ q\_1 - 2\ D\ q\_1\ q\_2 - \((q\_1)\)\_\(t, t\) == 0\)},
          {
            \(\(-D\)\ q\_1\%2 - B\ q\_2 + C\ q\_2\%2 - 
                \((q\_2)\)\_\(t, t\) == 0\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Given an arbitrary choice of the parameters ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", ",
  StyleBox["B",
    FontSlant->"Italic"],
  ", ",
  StyleBox["C",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["D",
    FontSlant->"Italic"],
  ", chaotic evolution occurs for the coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`q\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_2\)]],
  ". The non-chaotic or regular cases occur if the motion of the star is \
controlled at least by two integrals of motion. These two integrals fix the \
path of the system in the two-dimensional phase space. The special \
combinations of the parameters for which integrals of motion exists were \
derived with a Painlev\[EAcute] test by ",
  ButtonBox["Bountis et al. [1982]",
    ButtonData:>{"Literat.nb", "Bountis-1982"},
    ButtonStyle->"Hyperlink"],
  ". Here, we use ",
  StyleBox["Baecklund[]", "MmaText"],
  " to find the special parameter combinations under which integrals of \
motion exist. To find the integrals of motion, we apply the theory presented \
above. The integrals of motion are accessible by"
}], "Text",
  CellTags->{"chaotic evolution", "integrals of motion", "Baecklund[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(HHIntegrals\  = \ 
      Baecklund[
        HenonHeiles, {q1, q2}, {t}, {\[PartialD]\_\(t, t\)q1[t], 
          \[PartialD]\_\(t, t\)q2[t]}, 1, {A, B, C, D}, 
        AnsatzPoly \[Rule] {1, 1}]; 
    \(HHIntegrals // LieTraditionalForm\) // TableForm\)], "Input",
  CellMargins->{{0, Inherited}, {Inherited, Inherited}}],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 4\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-2\)\ A\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            RowBox[{
            \(\(-\(1\/2\)\)\ B\ q\_2\%2\), "+", \(\(C\ q\_2\%3\)\/3\), 
              StyleBox["-",
                ScriptLevel->0], \(1\/2\ \((q\_2)\)\_t\%2\)}]},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 4\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - \(1\/2\)\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(A\ q\_2\%2\)\/2 - 2\ D\ q\_2\%3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-D\)\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(A\ q\_2\%2\)\/2 - \(D\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(B\ q\_2\%2\)\/2 + \(C\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(B\ q\_2\%2\)\/2 - 2\ D\ q\_2\%3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] \(-\(\(2\ D\)\/5\)\)\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(B\ q\_2\%2\)\/2 - \(2\ D\ q\_2\%3\)\/15 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_2)\)\_t\)},
                {\(\((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-D\)\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/3\)\)\ D\ q\_1\%3 - A\ q\_1\ q\_2 - D\ q\_1\ q\_2\%2 - 
              \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {\(\(-2\)\ q\_2\ \((q\_1)\)\_t + q\_1\ \((q\_2)\)\_t\)},
                {\(q\_1\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 4\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(q\_2\ \((\(-A\)\ q\_1\%2 + \((q\_1)\)\_t\%2)\) - 
              q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {\(\(-2\)\ q\_2\ \((q\_1)\)\_t + q\_1\ \((q\_2)\)\_t\)},
                {
                  \(q\_1\ \((q\_1)\)\_t - 
                    \((3\ A\ \((q\_2)\)\_t)\)/\((2\ D)\)\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ D\ q\_1\%4 + 
              \(\((3\ A\^2 - 4\ D\^2\ q\_1\%2)\)\ q\_2\%2\)\/\(4\ D\) + 
              3\ A\ q\_2\%3 + 
              1\/2\ q\_2\ \((A\ q\_1\%2 + 2\ \((q\_1)\)\_t\%2)\) - 
              q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              \(3\ A\ \((q\_2)\)\_t\%2\)\/\(4\ D\)\)},
          {GridBox[{
                {\(\(-2\)\ q\_2\ \((q\_1)\)\_t + q\_1\ \((q\_2)\)\_t\)},
                {
                  \(q\_1\ \((q\_1)\)\_t + 
                    \((\((\(-4\)\ A + B)\)\ \((q\_2)\)\_t)\)/\((2\ D)\)\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ D\ q\_1\%4 - 
              \(\((\(-4\)\ A\ B + B\^2 + 4\ D\^2\ q\_1\%2)\)\ q\_2\%2\)\/\(4\ 
                  D\) + \((4\ A - B)\)\ q\_2\%3 + 
              1\/2\ q\_2\ 
                \((2\ A\ q\_1\%2 - B\ q\_1\%2 + 2\ \((q\_1)\)\_t\%2)\) - 
              q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              \(\((4\ A - B)\)\ \((q\_2)\)\_t\%2\)\/\(4\ D\)\)}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> Times[ 4, A], C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ -2, A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> A, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> Times[ 4, A], C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> B, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ -2, D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> Times[ -1, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> C, D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ -2, D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> Times[ 
          Rational[ -2, 5], D], D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -2, 15], D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 2], t], 
        Subscript[ 
          Subscript[ q, 1], t]}, {A -> A, B -> A, C -> Times[ -1, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 1], 3]], 
          Times[ -1, A, 
            Subscript[ q, 1], 
            Subscript[ q, 2]], 
          Times[ -1, D, 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ -1, 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ -2, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Subscript[ q, 1], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {A -> A, B -> Times[ 4, A], C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ 
            Subscript[ q, 2], 
            Plus[ 
              Times[ -1, A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Power[ 
                Subscript[ 
                  Subscript[ q, 1], t], 2]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ -2, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ -3, 2], A, 
            Power[ D, -1], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {A -> A, B -> A, C -> Times[ -6, D], 
        D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], D, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Power[ D, -1], 
            Plus[ 
              Times[ 3, 
                Power[ A, 2]], 
              Times[ -4, 
                Power[ D, 2], 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 3, A, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ 1, 2], 
            Subscript[ q, 2], 
            Plus[ 
              Times[ A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 3, 4], A, 
            Power[ D, -1], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ -2, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Times[ -4, A], B], 
            Power[ D, -1], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {A -> A, B -> B, C -> Times[ -6, D], 
        D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], D, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ D, -1], 
            Plus[ 
              Times[ -4, A, B], 
              Power[ B, 2], 
              Times[ 4, 
                Power[ D, 2], 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Plus[ 
              Times[ 4, A], 
              Times[ -1, B]], 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ 1, 2], 
            Subscript[ q, 2], 
            Plus[ 
              Times[ 2, A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -1, B, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ 4, A], 
              Times[ -1, B]], 
            Power[ D, -1], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}}, TableSpacing -> {1, 1}]]], 
  "Output",
  CellMargins->{{0, Inherited}, {Inherited, Inherited}},
  GridBoxOptions->{GridBaseline->Axis,
  RowSpacings->2,
  ColumnWidths->{0.3, 0.1, 0.6},
  ColumnAlignments->{Left},
  GridFrame->False,
  RowLines->False}]
}, Open  ]],

Cell["\<\
The result is a list containing several sub-lists. The sub-lists gather the \
information on the symmetries, the parameter combinations, and the related \
integral of motion. For example, the ninth element of the result\
\>", "Text",
  CellTags->{"parameter combinations", "integral of motion"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(HHIntegrals\[LeftDoubleBracket]9\[RightDoubleBracket] // 
      LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({{\((q\_1)\)\_t, \((q\_2)\)\_t}, {A \[Rule] A, B \[Rule] B, 
        C \[Rule] C, D \[Rule] D}, 
      \(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - \(B\ q\_2\%2\)\/2 + 
        \(C\ q\_2\%3\)\/3 - 1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2}
      \)], "Output"]
}, Open  ]],

Cell[TextData[{
  "states that the characteristics are given by the pair ",
  Cell[BoxData[
      RowBox[{
        StyleBox["(",
          FontFamily->"Times"], 
        RowBox[{
          RowBox[{
            StyleBox[
              SuperscriptBox[
                StyleBox[
                  RowBox[{
                    StyleBox["q",
                      FontFamily->"Times",
                      FontSlant->"Italic"], "1"}]], "\[Prime]",
                MultilineFunction->None],
              FontFamily->"Times"], 
            StyleBox["[",
              FontFamily->"Times"], 
            StyleBox["t",
              FontFamily->"Times",
              FontSlant->"Italic"], 
            StyleBox["]",
              FontFamily->"Times"]}], 
          StyleBox[",",
            FontFamily->"Times"], 
          RowBox[{
            StyleBox[
              SuperscriptBox[
                StyleBox[
                  RowBox[{
                    StyleBox["q",
                      FontFamily->"Times",
                      FontSlant->"Italic"], "2"}]], "\[Prime]",
                MultilineFunction->None],
              FontFamily->"Times"], 
            StyleBox["[",
              FontFamily->"Times"], 
            StyleBox["t",
              FontFamily->"Times",
              FontSlant->"Italic"], 
            StyleBox["]",
              FontFamily->"Times"]}]}], 
        StyleBox[")",
          FontFamily->"Times"]}]]],
  " and that all parameters are arbitrary. The related integral of motion is \
just the total energy of the system. Thus we find that for arbitrary \
parameter combinations, energy is a conserved quantity. The total energy is \
one of the two needed integrals to fix a path of the particle. Another \
integral of motion is given as the seventh element in"
}], "Text",
  CellTags->{"characteristics", "total energy"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(HHIntegrals\[LeftDoubleBracket]7\[RightDoubleBracket] // 
      LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \({{\((q\_1)\)\_t, \((q\_2)\)\_t}, {A \[Rule] A, B \[Rule] A, 
        C \[Rule] \(-6\)\ D, D \[Rule] D}, 
      \(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - \(A\ q\_2\%2\)\/2 - 
        2\ D\ q\_2\%3 - 1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Here, the characteristics are the same as before. However, the special \
combination of parameters ",
  Cell[BoxData[
      \(TraditionalForm\`\((A\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " arbitrary, ",
  Cell[BoxData[
      \(TraditionalForm\`B = A\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`C = \(-6\) D\)]],
  ") allows a second integral of motion in addition to the total energy. \
These two conserved quantities completely fix the motion of the star and the \
galaxy."
}], "Text",
  CellTags->{"integral of motion", "conserved quantities"}],

Cell[TextData[{
  "In the above calculations, the option ",
  StyleBox["AnsatzPoly\[Rule]", "MmaText",
    FontSlant->"Italic"],
  StyleBox["{", "MmaText",
    PrivateFontOptions->{"FontPostScriptName"->Automatic}],
  StyleBox["1,1", "MmaText",
    FontSlant->"Italic"],
  StyleBox["}", "MmaText"],
  " of ",
  StyleBox["Baecklund[] ", "MmaText"],
  "was used. This option affects ",
  StyleBox["Baecklund[]", "MmaText"],
  " in two ways. First, it creates a polynomial ansatz for the \
characteristics, and second, it determines the coefficients of this \
polynomial in such a way that integrals of motion exist. The two values in \
the list specify the polynomial degree in the coordinates and in the first \
derivatives, respectively. If you are convinced that the characteristics \
depend on the third order of the coordinates and on third order in the \
derivatives, you can call ",
  StyleBox["Baecklund[]", "MmaText"],
  " by"
}], "Text",
  CellTags->{
  "AnsatzPoly", "Baecklund[]", "polynomial ansatz", "integrals of motion"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(HHIntegrals\  = \ 
      Baecklund[
        HenonHeiles, {q1, q2}, {t}, {\[PartialD]\_\(t, t\)q1[t], 
          \[PartialD]\_\(t, t\)q2[t]}, 1, {A, B, C, D}, 
        AnsatzPoly \[Rule] {3, 3}]; 
    \(HHIntegrals // LieTraditionalForm\) // TableForm\)], "Input",
  CellMargins->{{0, Inherited}, {Inherited, Inherited}}],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(C\ q\_2\%3\)\/3 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ B\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ B\ q\_2\%2 + \(C\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/9\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/18\)\)\ A\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/4\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/8\)\)\ A\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_2\%2 + \(C\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 4\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-2\)\ A\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 9\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(9\/2\)\)\ A\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ B\ q\_2\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ B\ q\_2\%2 + \(C\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {"0"},
                {\(1\/9\ A\ q\_2\%2\ \((q\_2)\)\_t + \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/9\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/324\)\)\ A\^2\ q\_2\%4 - 
              1\/18\ A\ q\_2\%2\ \((q\_2)\)\_t\%2 - 
              1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {\(1\/4\ A\ q\_2\%2\ \((q\_2)\)\_t + \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/4\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/64\)\)\ A\^2\ q\_2\%4 - 
              1\/8\ A\ q\_2\%2\ \((q\_2)\)\_t\%2 - 1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {\(A\ q\_2\%2\ \((q\_2)\)\_t + \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_2\%4 - 
              1\/2\ A\ q\_2\%2\ \((q\_2)\)\_t\%2 - 1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {\(4\ A\ q\_2\%2\ \((q\_2)\)\_t + \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 4\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-4\)\ A\^2\ q\_2\%4 - 2\ A\ q\_2\%2\ \((q\_2)\)\_t\%2 - 
              1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {\(9\ A\ q\_2\%2\ \((q\_2)\)\_t + \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 9\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(81\/4\)\)\ A\^2\ q\_2\%4 - 
              9\/2\ A\ q\_2\%2\ \((q\_2)\)\_t\%2 - 1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {\(B\ q\_2\%2\ \((q\_2)\)\_t + \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ B\^2\ q\_2\%4 - 
              1\/2\ B\ q\_2\%2\ \((q\_2)\)\_t\%2 - 1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {\(B\ q\_2\%2\ \((q\_2)\)\_t + \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ B\^2\ q\_2\%4 - 
              1\/2\ B\ q\_2\%2\ \((q\_2)\)\_t\%2 - 1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {
                  \(\(-\(2\/3\)\)\ C\ q\_2\%3\ \((q\_2)\)\_t + 
                    \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/9\)\)\ C\^2\ q\_2\%6 + 
              1\/3\ C\ q\_2\%3\ \((q\_2)\)\_t\%2 - 1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {
                  \(\((A\ q\_2\%2 - \(2\ C\ q\_2\%3\)\/3)\)\ \((q\_2)\)\_t + 
                    \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_2\%4 + 1\/3\ A\ C\ q\_2\%5 - 
              1\/9\ C\^2\ q\_2\%6 - 
              1\/6\ q\_2\%2\ \((3\ A - 2\ C\ q\_2)\)\ \((q\_2)\)\_t\%2 - 
              1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {
                  \(\((B\ q\_2\%2 - \(2\ C\ q\_2\%3\)\/3)\)\ \((q\_2)\)\_t + 
                    \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ B\^2\ q\_2\%4 + 1\/3\ B\ C\ q\_2\%5 - 
              1\/9\ C\^2\ q\_2\%6 - 
              1\/6\ q\_2\%2\ \((3\ B - 2\ C\ q\_2)\)\ \((q\_2)\)\_t\%2 - 
              1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {"0"},
                {
                  \(\((B\ q\_2\%2 - \(2\ C\ q\_2\%3\)\/3)\)\ \((q\_2)\)\_t + 
                    \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ B\^2\ q\_2\%4 + 1\/3\ B\ C\ q\_2\%5 - 
              1\/9\ C\^2\ q\_2\%6 - 
              1\/6\ q\_2\%2\ \((3\ B - 2\ C\ q\_2)\)\ \((q\_2)\)\_t\%2 - 
              1\/4\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/9\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/4\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 4\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 9\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - 1\/2\ \((q\_1)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] \(-16\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-D\)\ q\_1\%2\ q\_2 - \(16\ D\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-D\)\ q\_1\%2\ q\_2 - 2\ D\ q\_2\%3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(A\ q\_2\%2\)\/2 + \(C\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(A\ q\_2\%2\)\/2 - 2\ D\ q\_2\%3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-D\)\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(A\ q\_2\%2\)\/2 - \(D\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 16\ A\)},
                {\(C \[Rule] \(-16\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 8\ A\ q\_2\%2 - 
              \(16\ D\ q\_2\%3\)\/3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(B\ q\_2\%2\)\/2 + \(C\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] \(-16\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(B\ q\_2\%2\)\/2 - \(16\ D\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(B\ q\_2\%2\)\/2 - 2\ D\ q\_2\%3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] \(-D\)\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ A\ q\_1\%2 - D\ q\_1\%2\ q\_2 - 
              \(B\ q\_2\%2\)\/2 - \(D\ q\_2\%3\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/9\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\/4\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 4\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 9\ A\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] 0\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(A\ q\_1\%2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3\)},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] C\)},
                {\(D \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4\)},
          {GridBox[{
                {\(\((q\_2)\)\_t\)},
                {\(\((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-D\)\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/3\)\)\ D\ q\_1\%3 - A\ q\_1\ q\_2 - D\ q\_1\ q\_2\%2 - 
              \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {
                  \(\((\(3\ A\)\/\(2\ D\) - 2\ q\_2)\)\ \((q\_1)\)\_t + 
                    q\_1\ \((q\_2)\)\_t\)},
                {\(q\_1\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(\(3\ A\^2\ q\_1\%2\)\/\(4\ D\)\)\) - \(D\ q\_1\%4\)\/4 - 
              D\ q\_1\%2\ q\_2\%2 - \(3\ A\ \((q\_1)\)\_t\%2\)\/\(4\ D\) + 
              q\_2\ \((\(-A\)\ q\_1\%2 + \((q\_1)\)\_t\%2)\) - 
              q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {
                  \(\((\(4\ A - B\)\/\(2\ D\) - 2\ q\_2)\)\ \((q\_1)\)\_t + 
                    q\_1\ \((q\_2)\)\_t\)},
                {\(q\_1\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] B\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(\(A\ \((4\ A - B)\)\ q\_1\%2\)\/\(4\ D\)\)\) - 
              \(D\ q\_1\%4\)\/4 - D\ q\_1\%2\ q\_2\%2 - 
              \(\((4\ A - B)\)\ \((q\_1)\)\_t\%2\)\/\(4\ D\) + 
              q\_2\ \((\(-A\)\ q\_1\%2 + \((q\_1)\)\_t\%2)\) - 
              q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {\(\(-2\)\ q\_2\ \((q\_1)\)\_t + q\_1\ \((q\_2)\)\_t\)},
                {\(q\_1\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] \(-6\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ D\ q\_1\%4 - D\ q\_1\%2\ q\_2\%2 + 
              q\_2\ \((q\_1)\)\_t\%2 - q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {
                  \(2\ D\ q\_1\%2\ q\_2\ \((q\_1)\)\_t + \((q\_1)\)\_t\%3 - 
                    1\/3\ D\ q\_1\%3\ \((q\_2)\)\_t\)},
                {\(\(-\(1\/3\)\)\ D\ q\_1\%3\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] 0\)},
                {\(B \[Rule] 0\)},
                {\(C \[Rule] \(-16\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(1\/18\ D\^2\ q\_1\%6 + 1\/3\ D\^2\ q\_1\%4\ q\_2\%2 - 
              D\ q\_1\%2\ q\_2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4 + 
              1\/3\ D\ q\_1\%3\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {
                  \(\((A\ q\_1\%2 + 2\ D\ q\_1\%2\ q\_2)\)\ \((q\_1)\)\_t + 
                    \((q\_1)\)\_t\%3 - 1\/3\ D\ q\_1\%3\ \((q\_2)\)\_t\)},
                {\(\(-\(1\/3\)\)\ D\ q\_1\%3\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] 16\ A\)},
                {\(C \[Rule] \(-16\)\ D\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 + 1\/18\ D\^2\ q\_1\%6 + 
              1\/3\ D\^2\ q\_1\%4\ q\_2\%2 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4 + 
              1\/3\ D\ q\_1\%2\ q\_2\ 
                \((A\ q\_1\%2 - 3\ \((q\_1)\)\_t\%2)\) + 
              1\/3\ D\ q\_1\%3\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {
                  \(\((A\ q\_1\%2 + 2\ D\ q\_1\%2\ q\_2 + A\ q\_2\%2 + 
                          \(2\ D\ q\_2\%3\)\/3)\)\ \((q\_1)\)\_t + 
                    \((q\_1)\)\_t\%3 + 
                    \((\(-\(1\/3\)\)\ D\ q\_1\%3 - A\ q\_1\ q\_2 - 
                          D\ q\_1\ q\_2\%2)\)\ \((q\_2)\)\_t\)},
                {
                  \(\((\(-\(1\/3\)\)\ D\ q\_1\%3 - A\ q\_1\ q\_2 - 
                          D\ q\_1\ q\_2\%2)\)\ \((q\_1)\)\_t + 
                    \((A\ q\_1\%2 + 2\ D\ q\_1\%2\ q\_2 + A\ q\_2\%2 + 
                          \(2\ D\ q\_2\%3\)\/3)\)\ \((q\_2)\)\_t + 
                    \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(A \[Rule] A\)},
                {\(B \[Rule] A\)},
                {\(C \[Rule] \(-D\)\)},
                {\(D \[Rule] D\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ A\^2\ q\_1\%4 + 1\/18\ D\^2\ q\_1\%6 + 
              1\/12\ \((\(-3\)\ A\^2 - 2\ D\^2\ q\_1\%2)\)\ q\_2\%4 - 
              1\/3\ A\ D\ q\_2\%5 - 1\/9\ D\^2\ q\_2\%6 - 
              1\/2\ A\ q\_1\%2\ \((q\_1)\)\_t\%2 - 1\/4\ \((q\_1)\)\_t\%4 + 
              1\/3\ D\ q\_2\%3\ \((\(-A\)\ q\_1\%2 - \((q\_1)\)\_t\%2)\) - 
              1\/3\ D\ q\_1\%2\ q\_2\ 
                \((2\ A\ q\_1\%2 + 3\ \((q\_1)\)\_t\%2)\) + 
              1\/6\ q\_2\%2\ 
                \((\(-4\)\ D\^2\ q\_1\%4 - 3\ A\ \((q\_1)\)\_t\%2)\) + 
              1\/3\ q\_1\ \((D\ q\_1\%2 + 3\ A\ q\_2 + 3\ D\ q\_2\%2)\)\ 
                \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              1\/6\ \((
                  \(-3\)\ A\ q\_1\%2 - 6\ D\ q\_1\%2\ q\_2 - 3\ A\ q\_2\%2 - 
                    2\ D\ q\_2\%3)\)\ \((q\_2)\)\_t\%2 - 
              1\/4\ \((q\_2)\)\_t\%4\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> 0, B -> 0, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> 0, B -> B, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> 0, B -> B, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> Times[ 
          Rational[ 1, 9], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 18], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> Times[ 
          Rational[ 1, 4], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 8], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> Times[ 4, A], C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ -2, A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> Times[ 9, A], C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -9, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{0, 
        Plus[ 
          Times[ 
            Rational[ 1, 9], A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> Times[ 
          Rational[ 1, 9], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 324], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 18], A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ 
            Rational[ 1, 4], A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> Times[ 
          Rational[ 1, 4], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 64], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 8], A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> A, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ 4, A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> Times[ 4, A], C -> 0, 
        D -> 0}, 
        Plus[ 
          Times[ -4, 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ -2, A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ 9, A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> Times[ 9, A], C -> 0, 
        D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -81, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -9, 2], A, 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ B, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> 0, B -> B, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ B, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ B, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> B, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ B, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ 
            Rational[ -2, 3], C, 
            Power[ 
              Subscript[ q, 2], 3], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> 0, B -> 0, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 9], 
            Power[ C, 2], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ 
            Plus[ 
              Times[ A, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ -2, 3], C, 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> A, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ 1, 3], A, C, 
            Power[ 
              Subscript[ q, 2], 5]], 
          Times[ 
            Rational[ -1, 9], 
            Power[ C, 2], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ 3, A], 
              Times[ -2, C, 
                Subscript[ q, 2]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ 
            Plus[ 
              Times[ B, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ -2, 3], C, 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> 0, B -> B, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ B, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ 1, 3], B, C, 
            Power[ 
              Subscript[ q, 2], 5]], 
          Times[ 
            Rational[ -1, 9], 
            Power[ C, 2], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ 3, B], 
              Times[ -2, C, 
                Subscript[ q, 2]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{0, 
        Plus[ 
          Times[ 
            Plus[ 
              Times[ B, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ -2, 3], C, 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> B, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ B, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ 1, 3], B, C, 
            Power[ 
              Subscript[ q, 2], 5]], 
          Times[ 
            Rational[ -1, 9], 
            Power[ C, 2], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ 3, B], 
              Times[ -2, C, 
                Subscript[ q, 2]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> 0, B -> 0, C -> C, D -> 0}, 
        Times[ 
          Rational[ -1, 2], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 2]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> 0, B -> B, C -> 0, D -> 0}, 
        Times[ 
          Rational[ -1, 2], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 2]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> 0, B -> B, C -> C, D -> 0}, 
        Times[ 
          Rational[ -1, 2], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 2]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> Times[ 
          Rational[ 1, 9], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> Times[ 
          Rational[ 1, 4], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> A, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> A, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> Times[ 4, A], C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> Times[ 9, A], C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> B, C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 0}, {A -> A, B -> B, C -> C, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> 0, B -> 0, C -> Times[ -16, D], D -> 
        D}, 
        Plus[ 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -16, 3], D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> 0, B -> 0, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ -2, D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> C, D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ -2, D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> A, C -> Times[ -1, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> Times[ 16, A], C -> 
        Times[ -16, D], D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ -8, A, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -16, 3], D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> C, D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ 1, 3], C, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> Times[ -16, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -16, 3], D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ -2, D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {A -> A, B -> B, C -> Times[ -1, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -1, 2], B, 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Power[ 
          Subscript[ 
            Subscript[ q, 1], t], 3], 0}, {A -> 0, B -> 0, C -> C, D -> 0}, 
        Times[ 
          Rational[ -1, 4], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 4]]}, {{
        Power[ 
          Subscript[ 
            Subscript[ q, 1], t], 3], 0}, {A -> 0, B -> B, C -> 0, D -> 0}, 
        Times[ 
          Rational[ -1, 4], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 4]]}, {{
        Power[ 
          Subscript[ 
            Subscript[ q, 1], t], 3], 0}, {A -> 0, B -> B, C -> C, D -> 0}, 
        Times[ 
          Rational[ -1, 4], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 4]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> Times[ 
          Rational[ 1, 9], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> Times[ 
          Rational[ 1, 4], A], C -> 0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> A, C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> A, C -> C, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> Times[ 4, A], C -> 
        0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> Times[ 9, A], C -> 
        0, D -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> B, C -> 0, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Plus[ 
          Times[ A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3]], 0}, {A -> A, B -> B, C -> C, D -> 
        0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]]]}, {{
        Subscript[ 
          Subscript[ q, 2], t], 
        Subscript[ 
          Subscript[ q, 1], t]}, {A -> A, B -> A, C -> Times[ -1, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 1], 3]], 
          Times[ -1, A, 
            Subscript[ q, 1], 
            Subscript[ q, 2]], 
          Times[ -1, D, 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ -1, 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 3, 2], A, 
                Power[ D, -1]], 
              Times[ -2, 
                Subscript[ q, 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Subscript[ q, 1], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {A -> A, B -> A, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -3, 4], 
            Power[ A, 2], 
            Power[ D, -1], 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 4], D, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -3, 4], A, 
            Power[ D, -1], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Subscript[ q, 2], 
            Plus[ 
              Times[ -1, A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Power[ 
                Subscript[ 
                  Subscript[ q, 1], t], 2]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 2], 
                Plus[ 
                  Times[ 4, A], 
                  Times[ -1, B]], 
                Power[ D, -1]], 
              Times[ -2, 
                Subscript[ q, 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Subscript[ q, 1], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {A -> A, B -> B, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], A, 
            Plus[ 
              Times[ 4, A], 
              Times[ -1, B]], 
            Power[ D, -1], 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 4], D, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Plus[ 
              Times[ 4, A], 
              Times[ -1, B]], 
            Power[ D, -1], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Subscript[ q, 2], 
            Plus[ 
              Times[ -1, A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Power[ 
                Subscript[ 
                  Subscript[ q, 1], t], 2]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ -2, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Subscript[ q, 1], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {A -> 0, B -> 0, C -> Times[ -6, D], D -> 
        D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], D, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Subscript[ q, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ 2, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3], 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Rational[ -1, 3], D, 
          Power[ 
            Subscript[ q, 1], 3], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {A -> 0, B -> 0, C -> Times[ -16, D], 
        D -> D}, 
        Plus[ 
          Times[ 
            Rational[ 1, 18], 
            Power[ D, 2], 
            Power[ 
              Subscript[ q, 1], 6]], 
          Times[ 
            Rational[ 1, 3], 
            Power[ D, 2], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ -1, D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]], 
          Times[ 
            Rational[ 1, 3], D, 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, D, 
                Power[ 
                  Subscript[ q, 1], 2], 
                Subscript[ q, 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3], 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Rational[ -1, 3], D, 
          Power[ 
            Subscript[ q, 1], 3], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {A -> A, B -> Times[ 16, A], C -> 
        Times[ -16, D], D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 18], 
            Power[ D, 2], 
            Power[ 
              Subscript[ q, 1], 6]], 
          Times[ 
            Rational[ 1, 3], 
            Power[ D, 2], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]], 
          Times[ 
            Rational[ 1, 3], D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2], 
            Plus[ 
              Times[ A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -3, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 3], D, 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, D, 
                Power[ 
                  Subscript[ q, 1], 2], 
                Subscript[ q, 2]], 
              Times[ A, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 2, 3], D, 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 1], t], 3], 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ -1, 3], D, 
                Power[ 
                  Subscript[ q, 1], 3]], 
              Times[ -1, A, 
                Subscript[ q, 1], 
                Subscript[ q, 2]], 
              Times[ -1, D, 
                Subscript[ q, 1], 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ -1, 3], D, 
                Power[ 
                  Subscript[ q, 1], 3]], 
              Times[ -1, A, 
                Subscript[ q, 1], 
                Subscript[ q, 2]], 
              Times[ -1, D, 
                Subscript[ q, 1], 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Plus[ 
              Times[ A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, D, 
                Power[ 
                  Subscript[ q, 1], 2], 
                Subscript[ q, 2]], 
              Times[ A, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 2, 3], D, 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Power[ 
            Subscript[ 
              Subscript[ q, 2], t], 3]]}, {A -> A, B -> A, C -> 
        Times[ -1, D], D -> D}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], 
            Power[ A, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 18], 
            Power[ D, 2], 
            Power[ 
              Subscript[ q, 1], 6]], 
          Times[ 
            Rational[ 1, 12], 
            Plus[ 
              Times[ -3, 
                Power[ A, 2]], 
              Times[ -2, 
                Power[ D, 2], 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 3], A, D, 
            Power[ 
              Subscript[ q, 2], 5]], 
          Times[ 
            Rational[ -1, 9], 
            Power[ D, 2], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 2], A, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]], 
          Times[ 
            Rational[ 1, 3], D, 
            Power[ 
              Subscript[ q, 2], 3], 
            Plus[ 
              Times[ -1, A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -1, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ -1, 3], D, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ q, 2], 
            Plus[ 
              Times[ 2, A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 3, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 6], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ -4, 
                Power[ D, 2], 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -3, A, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 3], 
            Subscript[ q, 1], 
            Plus[ 
              Times[ D, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 3, A, 
                Subscript[ q, 2]], 
              Times[ 3, D, 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 6], 
            Plus[ 
              Times[ -3, A, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -6, D, 
                Power[ 
                  Subscript[ q, 1], 2], 
                Subscript[ q, 2]], 
              Times[ -3, A, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ -2, D, 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}}]]], "Output",
  CellMargins->{{2, 2}, {Inherited, Inherited}},
  GridBoxOptions->{RowSpacings->2,
  ColumnWidths->{0.3, 0.1, 0.6},
  ColumnAlignments->{Left}}]
}, Open  ]],

Cell["\<\
We realize that the structure of the characteristics change and a \
large number of new integrals occur. These integrals represent the solution \
of the equation in implicit form.\
\>", "Text",
  CellTags->{"characteristics", "solution in implicit form"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.7.2 Two-Dimensional Quartic Oscillators", "Subsection",
  CellTags->"Two-Dimensional Quartic Oszillators"],

Cell["\<\
When two or more optical waves copropagate inside a fiber, they can \
interact with each other through the fiber non-linearity. In general, such an \
interaction can generate new waves under appropriate conditions through a \
variety of non-linear phenomena such as stimulated Raman and Brillouin \
scattering. The same non-linearity also provides a coupling between the \
incident waves through a phenomenon referred to as cross-phase modulation. \
Cross-phase modulation is always accompanied by self-phase modulation and \
occurs because the effective refractive index of a wave depends not only on \
the intensity of that wave but also on the intensity of the copropagating \
wave.\
\>", "Text",
  CellTags->{
  "optical waves", "fiber", "fiber nonlinearity", 
    "stimulated Raman scattering", "Brillouin scattering", 
    "cross-phase modulation", "self-phase modulation", 
    "effective refractive index", "intensity of a wave"}],

Cell[TextData[{
  "In this subsection, we will consider the coupling of two polarized waves \
with different frequencies. We assume that we have a polarization-preserving \
fiber so that the two waves maintain their polarization during propagation. \
This model, consisting of two coupled non-linear Schr\[ODoubleDot]dinger \
equations, can be reduced to a Hamiltonian system (cf. ",
  ButtonBox["Baumann [1991]",
    ButtonData:>{"Literat.nb", "Baumann-1991"},
    ButtonStyle->"Hyperlink"],
  "). The reduced model shows regular solutions for some parameter values. On \
the other hand, the Hamiltonian system can show chaos for an arbitrary choice \
of parameter values. The equations of motion follow from the Hamiltonian"
}], "Text",
  CellTags->{
  "polarized waves", "polarization-preserving fiber", 
    "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
    "Hamiltonian system", "chaos", "Hamiltonian"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(H\  = \ 
      \(1\/2\) \(\[Sum]\+\(i = 1\)\%2\((
              p\_i\%2 + \ \(1\/2\) \(\[Alpha]\_i\) q\_i\%2 + 
                \(\[CapitalGamma]\_i\) q\_i\%4)\)\)\  + \ 
        \(q\_1\%2\) q\_2\%2, \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`p\_i\)]],
  " denotes the momenta and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_i\)]],
  " the coordinates of the reduced equations. The ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\_i\)]],
  "\[CloseCurlyQuote]s and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma]\_i\)]],
  "\[CloseCurlyQuote]s are real constants. The equivalent formulation in \
Lagrange\[CloseCurlyQuote]s dynamic starts from the Lagrangian"
}], "Text",
  CellTags->{"Lagrange's dynamic", "Lagrangian"}],

Cell[BoxData[
    FormBox[
      RowBox[{"L", " ", "=", " ", 
        RowBox[{
          FormBox[\(1\/2\),
            "TraditionalForm"], 
          
          FormBox[\(\[Sum]\+\(i = 1\)\%2\((
                  q\& . \_i\%2 - \ \(1\/2\) \(\[Alpha]\_i\) q\_i\%2 - \ 
                    \(\[CapitalGamma]\_i\) q\_i\%4)\)\  - \ 
              \(q\_1\%2\) \(q\_2\%2 . \)\),
            "TraditionalForm"]}]}], TraditionalForm]], "NumberedEquation"],

Cell["\<\
Applying the Euler derivative to this Lagrangian, we find the equations of \
motion as\
\>", "Text",
  CellTags->{"Euler derivative", "Lagrangian"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"quarticOscillators", " ", "=", 
        RowBox[{"Thread", "[", 
          RowBox[{
            RowBox[{
              SubsuperscriptBox[
                StyleBox["\[ScriptCapitalE]",
                  ScriptLevel->1], \({q1, q2}\), "t"], "[", 
              \((\(1\/2\) 
                    \((\((\[PartialD]\_t q1[t])\)\^2 + 
                        \((\[PartialD]\_t q2[t])\)\^2 - 
                        \(1\/2\) 
                          \((\[Alpha]1\ q1[t]\^2 + \[Alpha]2\ q2[t]\^2)\) - 
                        \[CapitalGamma]1\ q1[t]\^4 - 
                        \[CapitalGamma]2\ q2[t]\^4)\)\  - 
                  \(q1[t]\^2\) q2[t]\^2)\), "]"}], " ", "==", \({0, 0}\)}], 
          "]"}]}], ";", \(quarticOscillators // LTF\)}]], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(\[Alpha]1\ q\_1\)\/2\),
                    ScriptLevel->0]}], "-", \(2\ \[CapitalGamma]1\ q\_1\%3\), 
                "-", \(2\ q\_1\ q\_2\%2\), "-", \(\((q\_1)\)\_\(t, t\)\)}], 
              "==", "0"}]},
          {
            RowBox[{
              RowBox[{
                RowBox[{"-", 
                  StyleBox[\(\(\[Alpha]2\ q\_2\)\/2\),
                    ScriptLevel->0]}], "-", \(2\ q\_1\%2\ q\_2\), "-", 
                \(2\ \[CapitalGamma]2\ q\_2\%3\), "-", 
                \(\((q\_2)\)\_\(t, t\)\)}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "These coupled second-order equations represent a similarity reduction of \
two coupled non-linear Schr\[ODoubleDot]dinger equations. The question now is \
under what circumstances is the given system of equations solvable? The \
answer is given by ",
  StyleBox["Baecklund[],", "MmaText"],
  " which delivers"
}], "Text",
  CellTags->{"similarity reduction", "Baecklund[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(QOIntegrals\  = \ 
      Baecklund[
        quarticOscillators, {q1, q2}, {t}, {\[PartialD]\_\(t, t\)q1[t], 
          \[PartialD]\_\(t, t\)q2[t]}, 
        1, {\[Alpha]1, \[Alpha]2, \[CapitalGamma]1, \[CapitalGamma]2}, 
        AnsatzPoly \[Rule] {4, 3}]; 
    \(QOIntegrals // LieTraditionalForm\) // TableForm\)], "Input",
  CellMargins->{{0, Inherited}, {Inherited, Inherited}}],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/6\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(q\_1\%4\/12\)\) - q\_1\%2\ q\_2\%2 - \(4\ q\_2\%4\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(q\_1\%4\/6\)\) - q\_1\%2\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(q\_1\%4\/6\)\) - q\_1\%2\ q\_2\%2 - \(4\ q\_2\%4\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(q\_1\%4\/2\)\) - q\_1\%2\ q\_2\%2 - q\_2\%4\/2 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/6\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(\(4\ q\_1\%4\)\/3\)\) - q\_1\%2\ q\_2\%2 - q\_2\%4\/12 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(\(4\ q\_1\%4\)\/3\)\) - q\_1\%2\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              1\/16\ \((\(-\[Alpha]1\) - 16\ q\_1\%2)\)\ q\_2\%2 - 
              q\_2\%4\/6 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              1\/16\ \((\(-\[Alpha]1\) - 16\ q\_1\%2)\)\ q\_2\%2 - 
              \(4\ q\_2\%4\)\/3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/2 + 
              1\/16\ \((\(-\[Alpha]1\) - 16\ q\_1\%2)\)\ q\_2\%2 - 
              q\_2\%4\/2 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/6\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - \(4\ q\_1\%4\)\/3 + 
              1\/16\ \((\(-\[Alpha]1\) - 16\ q\_1\%2)\)\ q\_2\%2 - 
              q\_2\%4\/12 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - \(4\ q\_1\%4\)\/3 + 
              1\/16\ \((\(-\[Alpha]1\) - 16\ q\_1\%2)\)\ q\_2\%2 - 
              q\_2\%4\/6 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              1\/4\ \((\(-\[Alpha]1\) - 4\ q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              1\/4\ \((\(-\[Alpha]1\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              \(4\ q\_2\%4\)\/3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/2 + 
              1\/4\ \((\(-\[Alpha]1\) - 4\ q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/2 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - \(4\ q\_1\%4\)\/3 + 
              1\/4\ \((\(-\[Alpha]1\) - 4\ q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/6\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/12 + 
              \((\(-\[Alpha]1\) - q\_1\%2)\)\ q\_2\%2 - \(4\ q\_2\%4\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              \((\(-\[Alpha]1\) - q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              \((\(-\[Alpha]1\) - q\_1\%2)\)\ q\_2\%2 - \(4\ q\_2\%4\)\/3 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/2 + 
              \((\(-\[Alpha]1\) - q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/2 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - \(4\ q\_1\%4\)\/3 + 
              \((\(-\[Alpha]1\) - q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/6\)},
                {\(\[CapitalGamma]2 \[Rule] \[CapitalGamma]2\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/12 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              \(\[CapitalGamma]2\ q\_2\%4\)\/2 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              \(4\ q\_2\%4\)\/3 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] \[CapitalGamma]2\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/6 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              \(\[CapitalGamma]2\ q\_2\%4\)\/2 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/2 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/2 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] \[CapitalGamma]2\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - q\_1\%4\/2 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              \(\[CapitalGamma]2\ q\_2\%4\)\/2 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - \(4\ q\_1\%4\)\/3 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - q\_2\%4\/6 - 
              1\/2\ \((q\_1)\)\_t\%2 - 1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] \[CapitalGamma]2\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - \(4\ q\_1\%4\)\/3 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              \(\[CapitalGamma]2\ q\_2\%4\)\/2 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] \[CapitalGamma]1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/6\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - 
              \(\[CapitalGamma]1\ q\_1\%4\)\/2 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              q\_2\%4\/12 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_1)\)\_t\)},
                {\(\((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] \[CapitalGamma]1\)},
                {\(\[CapitalGamma]2 \[Rule] \[CapitalGamma]2\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\%2 - 
              \(\[CapitalGamma]1\ q\_1\%4\)\/2 + 
              1\/4\ \((\(-\[Alpha]2\) - 4\ q\_1\%2)\)\ q\_2\%2 - 
              \(\[CapitalGamma]2\ q\_2\%4\)\/2 - 1\/2\ \((q\_1)\)\_t\%2 - 
              1\/2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\((q\_2)\)\_t\)},
                {\(\((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(2\/3\)\)\ q\_1\%3\ q\_2 - 2\/3\ q\_1\ q\_2\%3 - 
              \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {\(\((q\_2)\)\_t\)},
                {\(\((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/6\)\)\ q\_1\ \((3\ \[Alpha]1 + 4\ q\_1\%2)\)\ q\_2 - 
              2\/3\ q\_1\ q\_2\%3 - \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {\(q\_2\ \((q\_2)\)\_t\)},
                {\(q\_2\ \((q\_1)\)\_t - 2\ q\_1\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/6\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(2\/3\)\)\ q\_1\%3\ q\_2\%2 - 1\/3\ q\_1\ q\_2\%4 - 
              q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t + q\_1\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(q\_2\ \((q\_2)\)\_t\)},
                {\(q\_2\ \((q\_1)\)\_t - 2\ q\_1\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/6\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/24\)\)\ q\_1\ \((3\ \[Alpha]1 + 16\ q\_1\%2)\)\ 
                q\_2\%2 - 1\/3\ q\_1\ q\_2\%4 - 
              q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t + q\_1\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {\(\(-2\)\ q\_2\ \((q\_1)\)\_t + q\_1\ \((q\_2)\)\_t\)},
                {\(q\_1\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/6\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(2\/3\)\)\ q\_1\%2\ q\_2\%3 + 
              1\/3\ q\_2\ \((\(-q\_1\%4\) + 3\ \((q\_1)\)\_t\%2)\) - 
              q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {\(\(-2\)\ q\_2\ \((q\_1)\)\_t + q\_1\ \((q\_2)\)\_t\)},
                {\(q\_1\ \((q\_1)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/6\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(2\/3\)\)\ q\_1\%2\ q\_2\%3 + 
              1\/6\ q\_2\ 
                \((\(-3\)\ \[Alpha]1\ q\_1\%2 - 2\ q\_1\%4 + 
                    6\ \((q\_1)\)\_t\%2)\) - 
              q\_1\ \((q\_1)\)\_t\ \((q\_2)\)\_t\)},
          {GridBox[{
                {
                  \(\(-q\_2\%2\)\ \((q\_1)\)\_t + 
                    q\_1\ q\_2\ \((q\_2)\)\_t\)},
                {\(q\_1\ q\_2\ \((q\_1)\)\_t - q\_1\%2\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(1\/2\ q\_2\%2\ \((q\_1)\)\_t\%2 - 
              q\_1\ q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              1\/2\ q\_1\%2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {
                  \(\(-q\_2\%2\)\ \((q\_1)\)\_t + 
                    q\_1\ q\_2\ \((q\_2)\)\_t\)},
                {\(q\_1\ q\_2\ \((q\_1)\)\_t - q\_1\%2\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(1\/2\ q\_2\%2\ \((q\_1)\)\_t\%2 - 
              q\_1\ q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              1\/2\ q\_1\%2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {
                  \(\((\(-\(\(3\ \[Alpha]1\)\/2\)\) - q\_2\%2)\)\ 
                      \((q\_1)\)\_t + q\_1\ q\_2\ \((q\_2)\)\_t\)},
                {\(q\_1\ q\_2\ \((q\_1)\)\_t - q\_1\%2\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(3\/8\ \[Alpha]1\^2\ q\_1\%2 + \(3\ \[Alpha]1\ q\_1\%4\)\/4 + 
              3\/4\ \[Alpha]1\ \((q\_1)\)\_t\%2 + 
              1\/4\ q\_2\%2\ 
                \((3\ \[Alpha]1\ q\_1\%2 + 2\ \((q\_1)\)\_t\%2)\) - 
              q\_1\ q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              1\/2\ q\_1\%2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {
                  \(\((\(3\ \[Alpha]1\)\/8 - q\_2\%2)\)\ \((q\_1)\)\_t + 
                    q\_1\ q\_2\ \((q\_2)\)\_t\)},
                {\(q\_1\ q\_2\ \((q\_1)\)\_t - q\_1\%2\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(3\/32\)\)\ \[Alpha]1\^2\ q\_1\%2 - 
              \(3\ \[Alpha]1\ q\_1\%4\)\/16 - 
              3\/16\ \[Alpha]1\ \((q\_1)\)\_t\%2 + 
              1\/16\ q\_2\%2\ 
                \((\(-3\)\ \[Alpha]1\ q\_1\%2 + 8\ \((q\_1)\)\_t\%2)\) - 
              q\_1\ q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              1\/2\ q\_1\%2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {
                  \(\((\(1\/2\((\[Alpha]1 - \[Alpha]2)\)\) - q\_2\%2)\)\ 
                      \((q\_1)\)\_t + q\_1\ q\_2\ \((q\_2)\)\_t\)},
                {\(q\_1\ q\_2\ \((q\_1)\)\_t - q\_1\%2\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]2\)},
                {\(\[CapitalGamma]1 \[Rule] 1\)},
                {\(\[CapitalGamma]2 \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/8\)\)\ \[Alpha]1\ \((\[Alpha]1 - \[Alpha]2)\)\ 
                q\_1\%2 + 1\/4\ \((\(-\[Alpha]1\) + \[Alpha]2)\)\ q\_1\%4 + 
              1\/4\ \((\(-\[Alpha]1\) + \[Alpha]2)\)\ \((q\_1)\)\_t\%2 + 
              1\/4\ q\_2\%2\ 
                \((\(-\[Alpha]1\)\ q\_1\%2 + \[Alpha]2\ q\_1\%2 + 
                    2\ \((q\_1)\)\_t\%2)\) - 
              q\_1\ q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t + 
              1\/2\ q\_1\%2\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {
                  \(\((q\_1\%4\/6 + q\_1\%2\ q\_2\%2)\)\ \((q\_1)\)\_t + 
                    1\/2\ \((q\_1)\)\_t\%3 - 
                    1\/3\ q\_1\%3\ q\_2\ \((q\_2)\)\_t\)},
                {\(\(-\(1\/3\)\)\ q\_1\%3\ q\_2\ \((q\_1)\)\_t + 
                    1\/6\ q\_1\%4\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(q\_1\%8\/72\)\) - 1\/18\ q\_1\%4\ q\_2\%4 - 
              1\/12\ q\_1\%4\ \((q\_1)\)\_t\%2 - 1\/8\ \((q\_1)\)\_t\%4 - 
              1\/18\ q\_1\%2\ q\_2\%2\ \((q\_1\%4 + 9\ \((q\_1)\)\_t\%2)\) + 
              1\/3\ q\_1\%3\ q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t - 
              1\/12\ q\_1\%4\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {
                  \(\((\(\[Alpha]1\ q\_1\%2\)\/4 + q\_1\%4\/6 + 
                          q\_1\%2\ q\_2\%2)\)\ \((q\_1)\)\_t + 
                    1\/2\ \((q\_1)\)\_t\%3 - 
                    1\/3\ q\_1\%3\ q\_2\ \((q\_2)\)\_t\)},
                {
                  \(\(-\(1\/3\)\)\ q\_1\%3\ q\_2\ \((q\_1)\)\_t + 
                    1\/6\ q\_1\%4\ \((q\_2)\)\_t\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] 4\ \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 8\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/32\)\)\ \[Alpha]1\^2\ q\_1\%4 - 
              \(\[Alpha]1\ q\_1\%6\)\/24 - q\_1\%8\/72 - 
              1\/18\ q\_1\%4\ q\_2\%4 - 
              1\/24\ q\_1\%2\ \((3\ \[Alpha]1 + 2\ q\_1\%2)\)\ 
                \((q\_1)\)\_t\%2 - 1\/8\ \((q\_1)\)\_t\%4 - 
              1\/36\ q\_1\%2\ q\_2\%2\ 
                \((3\ \[Alpha]1\ q\_1\%2 + 2\ q\_1\%4 + 18\ \((q\_1)\)\_t\%2)
                  \) + 1\/3\ q\_1\%3\ q\_2\ \((q\_1)\)\_t\ \((q\_2)\)\_t - 
              1\/12\ q\_1\%4\ \((q\_2)\)\_t\%2\)},
          {GridBox[{
                {
                  \(1\/6\ q\_2\%4\ \((q\_1)\)\_t - 
                    1\/3\ q\_1\ q\_2\%3\ \((q\_2)\)\_t\)},
                {
                  \(\(-\(1\/3\)\)\ q\_1\ q\_2\%3\ \((q\_1)\)\_t + 
                    \((q\_1\%2\ q\_2\%2 + q\_2\%4\/6)\)\ \((q\_2)\)\_t + 
                    1\/2\ \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/18\)\)\ q\_1\%2\ q\_2\%6 - q\_2\%8\/72 + 
              1\/36\ q\_2\%4\ \((\(-2\)\ q\_1\%4 - 3\ \((q\_1)\)\_t\%2)\) + 
              1\/3\ q\_1\ q\_2\%3\ \((q\_1)\)\_t\ \((q\_2)\)\_t - 
              1\/12\ q\_2\%2\ \((6\ q\_1\%2 + q\_2\%2)\)\ \((q\_2)\)\_t\%2 - 
              1\/8\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {
                  \(1\/6\ q\_2\%4\ \((q\_1)\)\_t - 
                    1\/3\ q\_1\ q\_2\%3\ \((q\_2)\)\_t\)},
                {
                  \(\(-\(1\/3\)\)\ q\_1\ q\_2\%3\ \((q\_1)\)\_t + 
                    \((\(\[Alpha]1\ q\_2\%2\)\/16 + q\_1\%2\ q\_2\%2 + 
                          q\_2\%4\/6)\)\ \((q\_2)\)\_t + 
                    1\/2\ \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\/4\)},
                {\(\[CapitalGamma]1 \[Rule] 8\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(1\/288\ \((\(-3\)\ \[Alpha]1 - 16\ q\_1\%2)\)\ q\_2\%6 - 
              q\_2\%8\/72 + 
              \(1\/4608\) 
                \((q\_2\%4\ 
                    \((\(-9\)\ \[Alpha]1\^2 - 96\ \[Alpha]1\ q\_1\%2 - 
                        256\ q\_1\%4 - 384\ \((q\_1)\)\_t\%2)\))\) + 
              1\/3\ q\_1\ q\_2\%3\ \((q\_1)\)\_t\ \((q\_2)\)\_t - 
              1\/96\ q\_2\%2\ \((3\ \[Alpha]1 + 48\ q\_1\%2 + 8\ q\_2\%2)\)\ 
                \((q\_2)\)\_t\%2 - 1\/8\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {
                  \(\((q\_1\%4\/6 + q\_1\%2\ q\_2\%2 + q\_2\%4\/6)\)\ 
                      \((q\_1)\)\_t + 1\/2\ \((q\_1)\)\_t\%3 + 
                    \((\(-\(1\/3\)\)\ q\_1\%3\ q\_2 - 1\/3\ q\_1\ q\_2\%3)\)\ 
                      \((q\_2)\)\_t\)},
                {
                  \(\((\(-\(1\/3\)\)\ q\_1\%3\ q\_2 - 1\/3\ q\_1\ q\_2\%3)\)\ 
                      \((q\_1)\)\_t + 
                    \((q\_1\%4\/6 + q\_1\%2\ q\_2\%2 + q\_2\%4\/6)\)\ 
                      \((q\_2)\)\_t + 1\/2\ \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] 0\)},
                {\(\[Alpha]2 \[Rule] 0\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(q\_1\%8\/72\)\) - 1\/18\ q\_1\%2\ q\_2\%6 - q\_2\%8\/72 - 
              1\/12\ q\_1\%4\ \((q\_1)\)\_t\%2 - 1\/8\ \((q\_1)\)\_t\%4 + 
              1\/36\ q\_2\%4\ \((\(-11\)\ q\_1\%4 - 3\ \((q\_1)\)\_t\%2)\) - 
              1\/18\ q\_1\%2\ q\_2\%2\ \((q\_1\%4 + 9\ \((q\_1)\)\_t\%2)\) + 
              1\/3\ q\_2\ \((q\_1\%3 + q\_1\ q\_2\%2)\)\ \((q\_1)\)\_t\ 
                \((q\_2)\)\_t + 
              1\/12\ \((\(-q\_1\%4\) - 6\ q\_1\%2\ q\_2\%2 - q\_2\%4)\)\ 
                \((q\_2)\)\_t\%2 - 1\/8\ \((q\_2)\)\_t\%4\)},
          {GridBox[{
                {
                  \(\((\(\[Alpha]1\ q\_1\%2\)\/4 + q\_1\%4\/6 + 
                          \(\[Alpha]1\ q\_2\%2\)\/4 + q\_1\%2\ q\_2\%2 + 
                          q\_2\%4\/6)\)\ \((q\_1)\)\_t + 
                    1\/2\ \((q\_1)\)\_t\%3 + 
                    \((\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\ q\_2 - 
                          1\/3\ q\_1\%3\ q\_2 - 1\/3\ q\_1\ q\_2\%3)\)\ 
                      \((q\_2)\)\_t\)},
                {
                  \(\((\(-\(1\/4\)\)\ \[Alpha]1\ q\_1\ q\_2 - 
                          1\/3\ q\_1\%3\ q\_2 - 1\/3\ q\_1\ q\_2\%3)\)\ 
                      \((q\_1)\)\_t + 
                    \((\(\[Alpha]1\ q\_1\%2\)\/4 + q\_1\%4\/6 + 
                          \(\[Alpha]1\ q\_2\%2\)\/4 + q\_1\%2\ q\_2\%2 + 
                          q\_2\%4\/6)\)\ \((q\_2)\)\_t + 
                    1\/2\ \((q\_2)\)\_t\%3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Alpha]1 \[Rule] \[Alpha]1\)},
                {\(\[Alpha]2 \[Rule] \[Alpha]1\)},
                {\(\[CapitalGamma]1 \[Rule] 1\/3\)},
                {\(\[CapitalGamma]2 \[Rule] 1\/3\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/32\)\)\ \[Alpha]1\^2\ q\_1\%4 - 
              \(\[Alpha]1\ q\_1\%6\)\/24 - q\_1\%8\/72 + 
              1\/72\ \((\(-3\)\ \[Alpha]1 - 4\ q\_1\%2)\)\ q\_2\%6 - 
              q\_2\%8\/72 - 
              1\/24\ q\_1\%2\ \((3\ \[Alpha]1 + 2\ q\_1\%2)\)\ 
                \((q\_1)\)\_t\%2 - 1\/8\ \((q\_1)\)\_t\%4 + 
              1\/288\ q\_2\%4\ 
                \((\(-9\)\ \[Alpha]1\^2 - 36\ \[Alpha]1\ q\_1\%2 - 
                    88\ q\_1\%4 - 24\ \((q\_1)\)\_t\%2)\) + 
              1\/72\ q\_2\%2\ 
                \((\(-9\)\ \[Alpha]1\ q\_1\%4 - 4\ q\_1\%6 - 
                    9\ \[Alpha]1\ \((q\_1)\)\_t\%2 - 
                    36\ q\_1\%2\ \((q\_1)\)\_t\%2)\) + 
              1\/12\ q\_1\ q\_2\ 
                \((3\ \[Alpha]1 + 4\ q\_1\%2 + 4\ q\_2\%2)\)\ \((q\_1)\)\_t\ 
                \((q\_2)\)\_t + 
              1\/24\ \((
                  \(-3\)\ \[Alpha]1\ q\_1\%2 - 2\ q\_1\%4 - 
                    3\ \[Alpha]1\ q\_2\%2 - 12\ q\_1\%2\ q\_2\%2 - 2\ q\_2\%4)
                  \)\ \((q\_2)\)\_t\%2 - 1\/8\ \((q\_2)\)\_t\%4\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 1, 6], \[CapitalGamma]2 -> Rational[ 
        8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> Rational[ 
        1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> Rational[ 
        8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 8, 3], \[CapitalGamma]2 -> Rational[ 
        1, 6]}, 
        Plus[ 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 8, 3], \[CapitalGamma]2 -> Rational[ 
        1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> Rational[ 1, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 16], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -16, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> Rational[ 1, 3], 
        \[CapitalGamma]2 -> Rational[ 8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 16], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -16, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> 1, 
        \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 16], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -16, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> Rational[ 8, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 6]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 16], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -16, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> Rational[ 8, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 16], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -16, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]1, \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> 
        Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]1, \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> 
        Rational[ 8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]1, \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]1, \[CapitalGamma]1 -> Rational[ 8, 3], \[CapitalGamma]2 -> 
        Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> Times[ 
        4, \[Alpha]1], \[CapitalGamma]1 -> Rational[ 1, 6], 
        \[CapitalGamma]2 -> Rational[ 8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> Times[ 
        4, \[Alpha]1], \[CapitalGamma]1 -> Rational[ 1, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> Times[ 
        4, \[Alpha]1], \[CapitalGamma]1 -> Rational[ 1, 3], 
        \[CapitalGamma]2 -> Rational[ 8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> Times[ 
        4, \[Alpha]1], \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> Times[ 
        4, \[Alpha]1], \[CapitalGamma]1 -> Rational[ 8, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Plus[ 
              Times[ -1, \[Alpha]1], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> Rational[ 1, 6], \[CapitalGamma]2 -> 
        \[CapitalGamma]2}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], \[CapitalGamma]2, 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> 
        Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> 
        Rational[ 8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> 
        \[CapitalGamma]2}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], \[CapitalGamma]2, 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 
        \[CapitalGamma]2}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], \[CapitalGamma]2, 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> Rational[ 8, 3], \[CapitalGamma]2 -> 
        Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 6], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> Rational[ 8, 3], \[CapitalGamma]2 -> 
        \[CapitalGamma]2}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -4, 3], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], \[CapitalGamma]2, 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> \[CapitalGamma]1, \[CapitalGamma]2 -> 
        Rational[ 1, 6]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], \[CapitalGamma]1, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 1], t], 
        Subscript[ 
          Subscript[ q, 2], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> \[CapitalGamma]1, \[CapitalGamma]2 -> 
        \[CapitalGamma]2}, 
        Plus[ 
          Times[ 
            Rational[ -1, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -1, 2], \[CapitalGamma]1, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]2], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 2], \[CapitalGamma]2, 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Subscript[ 
          Subscript[ q, 2], t], 
        Subscript[ 
          Subscript[ q, 1], t]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> Rational[ 
        1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -2, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -2, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ -1, 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Subscript[ 
          Subscript[ q, 2], t], 
        Subscript[ 
          Subscript[ q, 1], t]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]1, \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> 
        Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 6], 
            Subscript[ q, 1], 
            Plus[ 
              Times[ 3, \[Alpha]1], 
              Times[ 4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Subscript[ q, 2]], 
          Times[ 
            Rational[ -2, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ -1, 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Times[ 
          Subscript[ q, 2], 
          Subscript[ 
            Subscript[ q, 2], t]], 
        Plus[ 
          Times[ 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ -2, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 8, 3], \[CapitalGamma]2 -> Rational[ 
        1, 6]}, 
        Plus[ 
          Times[ 
            Rational[ -2, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ -1, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Times[ 
          Subscript[ q, 2], 
          Subscript[ 
            Subscript[ q, 2], t]], 
        Plus[ 
          Times[ 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ -2, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> Rational[ 8, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 6]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 24], 
            Subscript[ q, 1], 
            Plus[ 
              Times[ 3, \[Alpha]1], 
              Times[ 16, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 2]], 
          Times[ 
            Rational[ -1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ -1, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ -2, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Subscript[ q, 1], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 1, 6], \[CapitalGamma]2 -> Rational[ 
        8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -2, 3], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ 1, 3], 
            Subscript[ q, 2], 
            Plus[ 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 3, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ -2, 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Times[ 
          Subscript[ q, 1], 
          Subscript[ 
            Subscript[ q, 1], t]]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 4, \[Alpha]1], \[CapitalGamma]1 -> Rational[ 1, 6], 
        \[CapitalGamma]2 -> Rational[ 8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -2, 3], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 3]], 
          Times[ 
            Rational[ 1, 6], 
            Subscript[ q, 2], 
            Plus[ 
              Times[ -3, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -2, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 6, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {{
        Plus[ 
          Times[ -1, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ -1, 
            Power[ 
              Subscript[ q, 2], 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]1, \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ q, 2], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ -3, 2], \[Alpha]1], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 4, \[Alpha]1], \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ 3, 8], 
            Power[ \[Alpha]1, 2], 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ 3, 4], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 3, 4], \[Alpha]1, 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ 1, 4], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ 3, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 3, 8], \[Alpha]1], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> 1, 
        \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -3, 32], 
            Power[ \[Alpha]1, 2], 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ -3, 16], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -3, 16], \[Alpha]1, 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ 1, 16], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ -3, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 8, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 2], 
                Plus[ \[Alpha]1, 
                  Times[ -1, \[Alpha]2]]], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ -1, 
            Power[ 
              Subscript[ q, 1], 2], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        \[Alpha]2, \[CapitalGamma]1 -> 1, \[CapitalGamma]2 -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -1, 8], \[Alpha]1, 
            Plus[ \[Alpha]1, 
              Times[ -1, \[Alpha]2]], 
            Power[ 
              Subscript[ q, 1], 2]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]1], \[Alpha]2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ 1, 4], 
            Plus[ 
              Times[ -1, \[Alpha]1], \[Alpha]2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ 1, 4], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ -1, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ \[Alpha]2, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ -1, 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 3]], 
          Times[ 
            Rational[ -1, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Rational[ -1, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ 1, 6], 
            Power[ 
              Subscript[ q, 1], 4], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> Rational[ 
        8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 1], 8]], 
          Times[ 
            Rational[ -1, 18], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]], 
          Times[ 
            Rational[ -1, 18], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Power[ 
                Subscript[ q, 1], 4], 
              Times[ 9, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 4], \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 3]], 
          Times[ 
            Rational[ -1, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Rational[ -1, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ 1, 6], 
            Power[ 
              Subscript[ q, 1], 4], 
            Subscript[ 
              Subscript[ q, 2], t]]]}, {\[Alpha]1 -> \[Alpha]1, \[Alpha]2 -> 
        Times[ 4, \[Alpha]1], \[CapitalGamma]1 -> Rational[ 1, 3], 
        \[CapitalGamma]2 -> Rational[ 8, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 32], 
            Power[ \[Alpha]1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 24], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 6]], 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 1], 8]], 
          Times[ 
            Rational[ -1, 18], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ q, 2], 4]], 
          Times[ 
            Rational[ -1, 24], 
            Power[ 
              Subscript[ q, 1], 2], 
            Plus[ 
              Times[ 3, \[Alpha]1], 
              Times[ 2, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]], 
          Times[ 
            Rational[ -1, 36], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ 3, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 2, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 18, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 3], 
            Power[ 
              Subscript[ q, 1], 3], 
            Subscript[ q, 2], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]]]}, {{
        Plus[ 
          Times[ 
            Rational[ 1, 6], 
            Power[ 
              Subscript[ q, 2], 4], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ -1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Rational[ -1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Plus[ 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 3]]]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 8, 3], \[CapitalGamma]2 -> Rational[ 
        1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 18], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 2], 8]], 
          Times[ 
            Rational[ 1, 36], 
            Power[ 
              Subscript[ q, 2], 4], 
            Plus[ 
              Times[ -2, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -3, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ 6, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Power[ 
                Subscript[ q, 2], 2]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{
        Plus[ 
          Times[ 
            Rational[ 1, 6], 
            Power[ 
              Subscript[ q, 2], 4], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ -1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Rational[ -1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 16], \[Alpha]1, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 3]]]}, {\[Alpha]1 -> \[Alpha]1, 
        \[Alpha]2 -> Times[ 
          Rational[ 1, 4], \[Alpha]1], \[CapitalGamma]1 -> Rational[ 8, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ 1, 288], 
            Plus[ 
              Times[ -3, \[Alpha]1], 
              Times[ -16, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 2], 8]], 
          Times[ 
            Rational[ 1, 4608], 
            Power[ 
              Subscript[ q, 2], 4], 
            Plus[ 
              Times[ -9, 
                Power[ \[Alpha]1, 2]], 
              Times[ -96, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -256, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -384, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 3], 
            Subscript[ q, 1], 
            Power[ 
              Subscript[ q, 2], 3], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ -1, 96], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ 3, \[Alpha]1], 
              Times[ 48, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 8, 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 3]], 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ -1, 3], 
                Power[ 
                  Subscript[ q, 1], 3], 
                Subscript[ q, 2]], 
              Times[ 
                Rational[ -1, 3], 
                Subscript[ q, 1], 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ -1, 3], 
                Power[ 
                  Subscript[ q, 1], 3], 
                Subscript[ q, 2]], 
              Times[ 
                Rational[ -1, 3], 
                Subscript[ q, 1], 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 3]]]}, {\[Alpha]1 -> 0, \[Alpha]2 -> 0, 
        \[CapitalGamma]1 -> Rational[ 1, 3], \[CapitalGamma]2 -> Rational[ 
        1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 1], 8]], 
          Times[ 
            Rational[ -1, 18], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 2], 8]], 
          Times[ 
            Rational[ -1, 12], 
            Power[ 
              Subscript[ q, 1], 4], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]], 
          Times[ 
            Rational[ 1, 36], 
            Power[ 
              Subscript[ q, 2], 4], 
            Plus[ 
              Times[ -11, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -3, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ -1, 18], 
            Power[ 
              Subscript[ q, 1], 2], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Power[ 
                Subscript[ q, 1], 4], 
              Times[ 9, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 3], 
            Subscript[ q, 2], 
            Plus[ 
              Power[ 
                Subscript[ q, 1], 3], 
              Times[ 
                Subscript[ q, 1], 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 12], 
            Plus[ 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -6, 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ -1, 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}, {{
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 4], \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 
                Rational[ 1, 4], \[Alpha]1, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 3]], 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ -1, 4], \[Alpha]1, 
                Subscript[ q, 1], 
                Subscript[ q, 2]], 
              Times[ 
                Rational[ -1, 3], 
                Power[ 
                  Subscript[ q, 1], 3], 
                Subscript[ q, 2]], 
              Times[ 
                Rational[ -1, 3], 
                Subscript[ q, 1], 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 2], t]]], 
        Plus[ 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ -1, 4], \[Alpha]1, 
                Subscript[ q, 1], 
                Subscript[ q, 2]], 
              Times[ 
                Rational[ -1, 3], 
                Power[ 
                  Subscript[ q, 1], 3], 
                Subscript[ q, 2]], 
              Times[ 
                Rational[ -1, 3], 
                Subscript[ q, 1], 
                Power[ 
                  Subscript[ q, 2], 3]]], 
            Subscript[ 
              Subscript[ q, 1], t]], 
          Times[ 
            Plus[ 
              Times[ 
                Rational[ 1, 4], \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ 
                Rational[ 1, 4], \[Alpha]1, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ 
                Rational[ 1, 6], 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 3]]]}, {\[Alpha]1 -> \[Alpha]1, 
        \[Alpha]2 -> \[Alpha]1, \[CapitalGamma]1 -> Rational[ 1, 3], 
        \[CapitalGamma]2 -> Rational[ 1, 3]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 32], 
            Power[ \[Alpha]1, 2], 
            Power[ 
              Subscript[ q, 1], 4]], 
          Times[ 
            Rational[ -1, 24], \[Alpha]1, 
            Power[ 
              Subscript[ q, 1], 6]], 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 1], 8]], 
          Times[ 
            Rational[ 1, 72], 
            Plus[ 
              Times[ -3, \[Alpha]1], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ q, 2], 6]], 
          Times[ 
            Rational[ -1, 72], 
            Power[ 
              Subscript[ q, 2], 8]], 
          Times[ 
            Rational[ -1, 24], 
            Power[ 
              Subscript[ q, 1], 2], 
            Plus[ 
              Times[ 3, \[Alpha]1], 
              Times[ 2, 
                Power[ 
                  Subscript[ q, 1], 2]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 1], t], 4]], 
          Times[ 
            Rational[ 1, 288], 
            Power[ 
              Subscript[ q, 2], 4], 
            Plus[ 
              Times[ -9, 
                Power[ \[Alpha]1, 2]], 
              Times[ -36, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -88, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -24, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 72], 
            Power[ 
              Subscript[ q, 2], 2], 
            Plus[ 
              Times[ -9, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -4, 
                Power[ 
                  Subscript[ q, 1], 6]], 
              Times[ -9, \[Alpha]1, 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]], 
              Times[ -36, 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ 
                    Subscript[ q, 1], t], 2]]]], 
          Times[ 
            Rational[ 1, 12], 
            Subscript[ q, 1], 
            Subscript[ q, 2], 
            Plus[ 
              Times[ 3, \[Alpha]1], 
              Times[ 4, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ 4, 
                Power[ 
                  Subscript[ q, 2], 2]]], 
            Subscript[ 
              Subscript[ q, 1], t], 
            Subscript[ 
              Subscript[ q, 2], t]], 
          Times[ 
            Rational[ 1, 24], 
            Plus[ 
              Times[ -3, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 1], 2]], 
              Times[ -2, 
                Power[ 
                  Subscript[ q, 1], 4]], 
              Times[ -3, \[Alpha]1, 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ -12, 
                Power[ 
                  Subscript[ q, 1], 2], 
                Power[ 
                  Subscript[ q, 2], 2]], 
              Times[ -2, 
                Power[ 
                  Subscript[ q, 2], 4]]], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 2]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ 
              Subscript[ 
                Subscript[ q, 2], t], 4]]]}}]]], "Output",
  CellMargins->{{2, 2}, {Inherited, Inherited}},
  GridBoxOptions->{RowSpacings->2,
  ColumnWidths->{0.2, 0.2, 0.6},
  ColumnAlignments->{Left}}]
}, Open  ]],

Cell[TextData[{
  "The result is a list containing 47 possible cases for finding integrals of \
motion. Scanning through the sub-lists, we realize that not only is the \
coupled system considered by ",
  StyleBox["Baecklund[]", "MmaText"],
  " but also a decoupling of the equations is taken into account."
}], "Text",
  CellTags->"integrals of motion"]
}, Open  ]],

Cell[CellGroupData[{

Cell["9.7.3 Two Ions in a Trap", "Subsection",
  CellTags->"Two Ions in a Trap"],

Cell[TextData[{
  "Today, ion trapping is a fundamental experimental tool. Basic properties \
and elementary constants of physics are derivable from such experiments (cf.",
  
  ButtonBox[" Wineland et al. [1983]",
    ButtonData:>{"Literat.nb", "Wineland-1983"},
    ButtonStyle->"Hyperlink"],
  "). A standard trap for such experiments is, for example, a Paul trap (",
  ButtonBox["Paul and Steinwedel [1953]",
    ButtonData:>{"Literat.nb", "Paul-1953"},
    ButtonStyle->"Hyperlink"],
  ") in which ions are confined by a high-frequency ",
  StyleBox["rf",
    FontSlant->"Italic"],
  " field in connection with a static electric field. A Paul trap is \
completely free of any magnetic fields. To uncover the physical properties of \
a single ion, it is necessary to trap one or at most a small number of ions; \
otherwise, one gets a statistical mean of the observed property. In a typical \
trap experiment, two ions or a single ion are confined. Here, we shall \
consider the case in which two ions are stored in the trap. For two particles \
in the trap, we can describe the motion with Newton\[CloseCurlyQuote]s \
equation. A schematic illustration of a trap follows:"
}], "Text",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}},
  CellTags->{
  "ion trapping", "Paul trap", "high frequency rf field", "magnetic field", 
    "statistical mean", "Newton's equation"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .96933 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.05525 -0.018564 1.05525 [
[ 0 0 0 0 ]
[ 1 .96933 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .96933 L
0 .96933 L
closepath
clip
newpath
.52395 .42116 m .56518 .42608 L .52408 .42626 L .591 .181 .232 r
F
.52395 .42116 m .56649 .42096 L .56518 .42608 L F
.48146 .42088 m .52395 .42116 L .52408 .42626 L .617 .201 .231 r
F
.56649 .42096 m .6058 .42545 L .56518 .42608 L .562 .153 .224 r
F
.56649 .42096 m .60854 .4203 L .6058 .42545 L F
.48146 .42088 m .52408 .42626 L .48302 .426 L .617 .201 .231 r
F
.43955 .42014 m .48146 .42088 L .48302 .426 L .639 .215 .221 r
F
.52406 .62018 m .56663 .62629 L .52394 .6263 L .625 .765 .947 r
F
.48287 .62016 m .52394 .6263 L .48129 .62629 L .648 .784 .947 r
F
.48287 .62016 m .52406 .62018 L .52394 .6263 L F
.60854 .4203 m .6454 .42438 L .6058 .42545 L .526 .116 .206 r
F
.60854 .4203 m .64955 .41917 L .6454 .42438 L F
.52408 .42626 m .56393 .43129 L .52419 .43146 L .603 .205 .262 r
F
.52408 .42626 m .56518 .42608 L .56393 .43129 L F
.48302 .426 m .52408 .42626 L .52419 .43146 L .629 .226 .262 r
F
.56531 .62017 m .60883 .62626 L .56663 .62629 L .599 .747 .948 r
F
.52406 .62018 m .56531 .62017 L .56663 .62629 L .625 .765 .947 r
F
.43955 .42014 m .48302 .426 L .44253 .4253 L .639 .215 .221 r
F
.39877 .41893 m .43955 .42014 L .44253 .4253 L .657 .221 .202 r
F
.44224 .62011 m .48129 .62629 L .43923 .62626 L .668 .804 .948 r
F
.44224 .62011 m .48287 .62016 L .48129 .62629 L F
.56518 .42608 m .6032 .4307 L .56393 .43129 L .573 .177 .255 r
F
.56518 .42608 m .6058 .42545 L .6032 .4307 L F
.48302 .426 m .52419 .43146 L .48449 .43122 L .629 .226 .262 r
F
.44253 .4253 m .48302 .426 L .48449 .43122 L .651 .24 .252 r
F
.60606 .62012 m .64999 .62622 L .60883 .62626 L .57 .73 .95 r
F
.56531 .62017 m .60606 .62012 L .60883 .62626 L .599 .747 .948 r
F
.52418 .61401 m .56531 .62017 L .52406 .62018 L .632 .758 .938 r
F
.48435 .61399 m .52406 .62018 L .48287 .62016 L .655 .777 .938 r
F
.48435 .61399 m .52418 .61401 L .52406 .62018 L F
.6058 .42545 m .64146 .42969 L .6032 .4307 L .538 .141 .238 r
F
.6058 .42545 m .6454 .42438 L .64146 .42969 L F
.40273 .62003 m .43923 .62626 L .3983 .62621 L .685 .825 .95 r
F
.40273 .62003 m .44224 .62011 L .43923 .62626 L F
.52419 .43146 m .56276 .4366 L .5243 .43676 L .614 .23 .293 r
F
.52419 .43146 m .56393 .43129 L .56276 .4366 L F
.48449 .43122 m .52419 .43146 L .5243 .43676 L .64 .251 .292 r
F
.56405 .61399 m .60606 .62012 L .56531 .62017 L .606 .74 .939 r
F
.52418 .61401 m .56405 .61399 L .56531 .62017 L .632 .758 .938 r
F
.44253 .4253 m .48449 .43122 L .44536 .43055 L .651 .24 .252 r
F
.40316 .42416 m .44253 .4253 L .44536 .43055 L .67 .247 .234 r
F
.39877 .41893 m .44253 .4253 L .40316 .42416 L .657 .221 .202 r
F
.44509 .61392 m .48287 .62016 L .44224 .62011 L .676 .798 .94 r
F
.44509 .61392 m .48435 .61399 L .48287 .62016 L F
.64955 .41917 m .68344 .42288 L .6454 .42438 L .484 .07 .178 r
F
.64955 .41917 m .68897 .41758 L .68344 .42288 L F
.56393 .43129 m .60075 .43604 L .56276 .4366 L .584 .203 .286 r
F
.56393 .43129 m .6032 .4307 L .60075 .43604 L F
.48449 .43122 m .5243 .43676 L .48588 .43653 L .64 .251 .292 r
F
.44536 .43055 m .48449 .43122 L .48588 .43653 L .662 .266 .283 r
F
.35967 .41726 m .39877 .41893 L .40316 .42416 L .671 .219 .172 r
F
.60606 .62012 m .6458 .62004 L .64999 .62622 L .57 .73 .95 r
F
.60344 .61393 m .6458 .62004 L .60606 .62012 L .577 .722 .942 r
F
.56405 .61399 m .60344 .61393 L .60606 .62012 L .606 .74 .939 r
F
.52429 .6078 m .56405 .61399 L .52418 .61401 L .639 .751 .929 r
F
.48576 .60777 m .52418 .61401 L .48435 .61399 L .663 .77 .929 r
F
.48576 .60777 m .52429 .6078 L .52418 .61401 L F
.6032 .4307 m .63776 .43509 L .60075 .43604 L .549 .167 .269 r
F
.6032 .4307 m .64146 .42969 L .63776 .43509 L F
.40692 .61381 m .44224 .62011 L .40273 .62003 L .694 .819 .942 r
F
.40692 .61381 m .44509 .61392 L .44224 .62011 L F
.5243 .43676 m .56166 .442 L .5244 .44215 L .624 .255 .324 r
F
.5243 .43676 m .56276 .4366 L .56166 .442 L F
.48588 .43653 m .5243 .43676 L .5244 .44215 L .65 .276 .323 r
F
.56286 .60778 m .60344 .61393 L .56405 .61399 L .613 .732 .93 r
F
.52429 .6078 m .56286 .60778 L .56405 .61399 L .639 .751 .929 r
F
.6458 .62004 m .68957 .62615 L .64999 .62622 L .536 .712 .953 r
F
.44778 .60768 m .48435 .61399 L .44509 .61392 L .684 .791 .931 r
F
.44778 .60768 m .48576 .60777 L .48435 .61399 L F
.44536 .43055 m .48588 .43653 L .44802 .43591 L .662 .266 .283 r
F
.40731 .42948 m .44536 .43055 L .44802 .43591 L .682 .274 .266 r
F
.40316 .42416 m .44536 .43055 L .40731 .42948 L .67 .247 .234 r
F
.6454 .42438 m .6782 .42828 L .64146 .42969 L .497 .096 .21 r
F
.6454 .42438 m .68344 .42288 L .6782 .42828 L F
.56276 .4366 m .59845 .44147 L .56166 .442 L .594 .228 .317 r
F
.56276 .4366 m .60075 .43604 L .59845 .44147 L F
.48588 .43653 m .5244 .44215 L .48719 .44194 L .65 .276 .323 r
F
.44802 .43591 m .48588 .43653 L .48719 .44194 L .673 .291 .315 r
F
.36487 .61992 m .3983 .62621 L .35905 .62614 L .7 .848 .954 r
F
.36487 .61992 m .40273 .62003 L .3983 .62621 L F
.36543 .42259 m .40316 .42416 L .40731 .42948 L .685 .247 .205 r
F
.35967 .41726 m .40316 .42416 L .36543 .42259 L .671 .219 .172 r
F
.60344 .61393 m .64183 .61383 L .6458 .62004 L .577 .722 .942 r
F
.60097 .6077 m .64183 .61383 L .60344 .61393 L .584 .715 .933 r
F
.56286 .60778 m .60097 .6077 L .60344 .61393 L .613 .732 .93 r
F
.52439 .60155 m .56286 .60778 L .52429 .6078 L .646 .743 .919 r
F
.48708 .60152 m .52429 .6078 L .48576 .60777 L .67 .762 .92 r
F
.48708 .60152 m .52439 .60155 L .52429 .6078 L F
.60075 .43604 m .63428 .44058 L .59845 .44147 L .56 .193 .301 r
F
.60075 .43604 m .63776 .43509 L .63428 .44058 L F
.41088 .60755 m .44509 .61392 L .40692 .61381 L .703 .813 .933 r
F
.41088 .60755 m .44778 .60768 L .44509 .61392 L F
.5244 .44215 m .56063 .44749 L .5245 .44764 L .634 .28 .354 r
F
.5244 .44215 m .56166 .442 L .56063 .44749 L F
.48719 .44194 m .5244 .44215 L .5245 .44764 L .66 .301 .353 r
F
.56175 .60153 m .60097 .6077 L .56286 .60778 L .62 .724 .921 r
F
.52439 .60155 m .56175 .60153 L .56286 .60778 L .646 .743 .919 r
F
.68897 .41758 m .71937 .42097 L .68344 .42288 L .434 .012 .136 r
F
.68897 .41758 m .72625 .41554 L .71937 .42097 L F
.4503 .60141 m .48576 .60777 L .44778 .60768 L .691 .783 .921 r
F
.4503 .60141 m .48708 .60152 L .48576 .60777 L F
.6458 .62004 m .68398 .61994 L .68957 .62615 L .536 .712 .953 r
F
.64183 .61383 m .68398 .61994 L .6458 .62004 L .543 .705 .945 r
F
.44802 .43591 m .48719 .44194 L .45052 .44135 L .673 .291 .315 r
F
.41123 .43489 m .44802 .43591 L .45052 .44135 L .694 .301 .298 r
F
.40731 .42948 m .44802 .43591 L .41123 .43489 L .682 .274 .266 r
F
.56166 .442 m .59631 .447 L .56063 .44749 L .604 .253 .347 r
F
.56166 .442 m .59845 .44147 L .59631 .447 L F
.64146 .42969 m .67327 .43376 L .63776 .43509 L .508 .122 .243 r
F
.64146 .42969 m .6782 .42828 L .67327 .43376 L F
.48719 .44194 m .5245 .44764 L .48841 .44743 L .66 .301 .353 r
F
.45052 .44135 m .48719 .44194 L .48841 .44743 L .684 .317 .346 r
F
.37038 .61365 m .40273 .62003 L .36487 .61992 L .71 .843 .946 r
F
.37038 .61365 m .40692 .61381 L .40273 .62003 L F
.32281 .41515 m .35967 .41726 L .36543 .42259 L .679 .209 .128 r
F
.37089 .428 m .40731 .42948 L .41123 .43489 L .699 .275 .238 r
F
.36543 .42259 m .40731 .42948 L .37089 .428 L .685 .247 .205 r
F
.52449 .59527 m .56175 .60153 L .52439 .60155 L .653 .734 .909 r
F
.4883 .59523 m .52439 .60155 L .48708 .60152 L .677 .754 .909 r
F
.4883 .59523 m .52449 .59527 L .52439 .60155 L F
.60097 .6077 m .63809 .60757 L .64183 .61383 L .584 .715 .933 r
F
.59865 .60144 m .63809 .60757 L .60097 .6077 L .591 .706 .923 r
F
.56175 .60153 m .59865 .60144 L .60097 .6077 L .62 .724 .921 r
F
.5245 .44764 m .55968 .45307 L .52458 .45321 L .643 .305 .384 r
F
.5245 .44764 m .56063 .44749 L .55968 .45307 L F
.48841 .44743 m .5245 .44764 L .52458 .45321 L .669 .326 .384 r
F
.59845 .44147 m .63104 .44616 L .59631 .447 L .57 .218 .333 r
F
.59845 .44147 m .63428 .44058 L .63104 .44616 L F
.41458 .60125 m .44778 .60768 L .41088 .60755 L .711 .806 .924 r
F
.41458 .60125 m .4503 .60141 L .44778 .60768 L F
.56071 .59524 m .59865 .60144 L .56175 .60153 L .627 .715 .91 r
F
.52449 .59527 m .56071 .59524 L .56175 .60153 L .653 .734 .909 r
F
.68398 .61994 m .72698 .62607 L .68957 .62615 L .496 .694 .957 r
F
.45265 .59511 m .48708 .60152 L .4503 .60141 L .699 .775 .91 r
F
.45265 .59511 m .4883 .59523 L .48708 .60152 L F
.68344 .42288 m .71287 .42648 L .6782 .42828 L .447 .038 .171 r
F
.68344 .42288 m .71937 .42097 L .71287 .42648 L F
.45052 .44135 m .48841 .44743 L .45285 .44688 L .684 .317 .346 r
F
.4149 .4404 m .45052 .44135 L .45285 .44688 L .705 .327 .33 r
F
.41123 .43489 m .45052 .44135 L .4149 .4404 L .694 .301 .298 r
F
.64183 .61383 m .67869 .61368 L .68398 .61994 L .543 .705 .945 r
F
.63809 .60757 m .67869 .61368 L .64183 .61383 L .55 .697 .936 r
F
.56063 .44749 m .59433 .45261 L .55968 .45307 L .613 .278 .378 r
F
.56063 .44749 m .59631 .447 L .59433 .45261 L F
.48841 .44743 m .52458 .45321 L .48953 .45302 L .669 .326 .384 r
F
.45285 .44688 m .48841 .44743 L .48953 .45302 L .693 .342 .377 r
F
.63776 .43509 m .66864 .43933 L .63428 .44058 L .519 .149 .277 r
F
.63776 .43509 m .67327 .43376 L .66864 .43933 L F
.37556 .60735 m .40692 .61381 L .37038 .61365 L .719 .837 .937 r
F
.37556 .60735 m .41088 .60755 L .40692 .61381 L F
.32922 .61977 m .35905 .62614 L .32206 .62605 L .712 .873 .957 r
F
.32922 .61977 m .36487 .61992 L .35905 .62614 L F
.32991 .4206 m .36543 .42259 L .37089 .428 L .695 .238 .163 r
F
.32281 .41515 m .36543 .42259 L .32991 .4206 L .679 .209 .128 r
F
.37603 .4335 m .41123 .43489 L .4149 .4404 L .712 .303 .272 r
F
.37089 .428 m .41123 .43489 L .37603 .4335 L .699 .275 .238 r
F
.52458 .58896 m .56071 .59524 L .52449 .59527 L .659 .725 .897 r
F
.48944 .58891 m .52449 .59527 L .4883 .59523 L .683 .744 .898 r
F
.48944 .58891 m .52458 .58896 L .52449 .59527 L F
.59865 .60144 m .63458 .60128 L .63809 .60757 L .591 .706 .923 r
F
.59649 .59514 m .63458 .60128 L .59865 .60144 L .597 .697 .913 r
F
.56071 .59524 m .59649 .59514 L .59865 .60144 L .627 .715 .91 r
F
.52458 .45321 m .5588 .45874 L .52466 .45887 L .651 .329 .414 r
F
.52458 .45321 m .55968 .45307 L .5588 .45874 L F
.48953 .45302 m .52458 .45321 L .52466 .45887 L .678 .351 .414 r
F
.55975 .58893 m .59649 .59514 L .56071 .59524 L .633 .705 .899 r
F
.52458 .58896 m .55975 .58893 L .56071 .59524 L .659 .725 .897 r
F
.59631 .447 m .62805 .45182 L .59433 .45261 L .579 .244 .365 r
F
.59631 .447 m .63104 .44616 L .62805 .45182 L F
.41804 .59492 m .4503 .60141 L .41458 .60125 L .719 .798 .913 r
F
.41804 .59492 m .45265 .59511 L .4503 .60141 L F
.45483 .58878 m .4883 .59523 L .45265 .59511 L .706 .766 .899 r
F
.45483 .58878 m .48944 .58891 L .4883 .59523 L F
.55968 .45307 m .59251 .4583 L .5588 .45874 L .622 .303 .409 r
F
.55968 .45307 m .59433 .45261 L .59251 .4583 L F
.45285 .44688 m .48953 .45302 L .455 .4525 L .693 .342 .377 r
F
.41832 .44598 m .45285 .44688 L .455 .4525 L .715 .354 .362 r
F
.4149 .4404 m .45285 .44688 L .41832 .44598 L .705 .327 .33 r
F
.68398 .61994 m .72004 .6198 L .72698 .62607 L .496 .694 .957 r
F
.67869 .61368 m .72004 .6198 L .68398 .61994 L .503 .686 .949 r
F
.63809 .60757 m .67371 .60739 L .67869 .61368 L .55 .697 .936 r
F
.63458 .60128 m .67371 .60739 L .63809 .60757 L .557 .688 .927 r
F
.48953 .45302 m .52466 .45887 L .49057 .45868 L .678 .351 .414 r
F
.455 .4525 m .48953 .45302 L .49057 .45868 L .702 .368 .407 r
F
.6782 .42828 m .70675 .43206 L .67327 .43376 L .459 .066 .206 r
F
.6782 .42828 m .71287 .42648 L .70675 .43206 L F
.63428 .44058 m .66433 .44498 L .63104 .44616 L .53 .175 .31 r
F
.63428 .44058 m .66864 .43933 L .66433 .44498 L F
.38042 .60102 m .41088 .60755 L .37556 .60735 L .729 .83 .928 r
F
.38042 .60102 m .41458 .60125 L .41088 .60755 L F
.33599 .61346 m .36487 .61992 L .32922 .61977 L .723 .868 .95 r
F
.33599 .61346 m .37038 .61365 L .36487 .61992 L F
.38084 .43908 m .4149 .4404 L .41832 .44598 L .724 .331 .305 r
F
.37603 .4335 m .4149 .4404 L .38084 .43908 L .712 .303 .272 r
F
.52466 .58263 m .55975 .58893 L .52458 .58896 L .665 .714 .885 r
F
.49049 .58257 m .52458 .58896 L .48944 .58891 L .689 .735 .885 r
F
.49049 .58257 m .52466 .58263 L .52458 .58896 L F
.33662 .42613 m .37089 .428 L .37603 .4335 L .711 .268 .198 r
F
.32991 .4206 m .37089 .428 L .33662 .42613 L .695 .238 .163 r
F
.59649 .59514 m .63131 .59496 L .63458 .60128 L .597 .697 .913 r
F
.59449 .58881 m .63131 .59496 L .59649 .59514 L .603 .687 .901 r
F
.55975 .58893 m .59449 .58881 L .59649 .59514 L .633 .705 .899 r
F
.72625 .41554 m .75263 .41865 L .71937 .42097 L .371 0 .079 r
F
.72625 .41554 m .76079 .41308 L .75263 .41865 L F
.52466 .45887 m .55801 .46448 L .52474 .4646 L .659 .354 .444 r
F
.52466 .45887 m .5588 .45874 L .55801 .46448 L F
.49057 .45868 m .52466 .45887 L .52474 .4646 L .686 .375 .444 r
F
.55887 .58259 m .59449 .58881 L .55975 .58893 L .638 .695 .886 r
F
.52466 .58263 m .55887 .58259 L .55975 .58893 L .665 .714 .885 r
F
.59433 .45261 m .6253 .45755 L .59251 .4583 L .588 .269 .397 r
F
.59433 .45261 m .62805 .45182 L .6253 .45755 L F
.42123 .58857 m .45265 .59511 L .41804 .59492 L .727 .789 .902 r
F
.42123 .58857 m .45483 .58878 L .45265 .59511 L F
.45683 .58243 m .48944 .58891 L .45483 .58878 L .712 .756 .887 r
F
.45683 .58243 m .49049 .58257 L .48944 .58891 L F
.5588 .45874 m .59085 .46407 L .55801 .46448 L .629 .327 .439 r
F
.5588 .45874 m .59251 .4583 L .59085 .46407 L F
.455 .4525 m .49057 .45868 L .45698 .45819 L .702 .368 .407 r
F
.42149 .45165 m .455 .4525 L .45698 .45819 L .725 .38 .394 r
F
.41832 .44598 m .455 .4525 L .42149 .45165 L .715 .354 .362 r
F
.49057 .45868 m .52474 .4646 L .49151 .46443 L .686 .375 .444 r
F
.45698 .45819 m .49057 .45868 L .49151 .46443 L .711 .393 .438 r
F
.63458 .60128 m .66904 .60106 L .67371 .60739 L .557 .688 .927 r
F
.63131 .59496 m .66904 .60106 L .63458 .60128 L .563 .678 .916 r
F
.67869 .61368 m .71348 .61349 L .72004 .6198 L .503 .686 .949 r
F
.67371 .60739 m .71348 .61349 L .67869 .61368 L .51 .678 .941 r
F
.28879 .41262 m .32281 .41515 L .32991 .4206 L .68 .187 .068 r
F
.67327 .43376 m .70102 .43773 L .66864 .43933 L .471 .093 .241 r
F
.67327 .43376 m .70675 .43206 L .70102 .43773 L F
.63104 .44616 m .66035 .45071 L .62805 .45182 L .54 .202 .343 r
F
.63104 .44616 m .66433 .44498 L .66035 .45071 L F
.52473 .57628 m .55887 .58259 L .52466 .58263 L .67 .703 .872 r
F
.49144 .57622 m .52466 .58263 L .49049 .58257 L .695 .724 .872 r
F
.49144 .57622 m .52473 .57628 L .52466 .58263 L F
.38495 .59466 m .41458 .60125 L .38042 .60102 L .738 .823 .917 r
F
.38495 .59466 m .41804 .59492 L .41458 .60125 L F
.38533 .44475 m .41832 .44598 L .42149 .45165 L .736 .359 .339 r
F
.38084 .43908 m .41832 .44598 L .38533 .44475 L .724 .331 .305 r
F
.52474 .4646 m .55729 .4703 L .5248 .47041 L .666 .378 .474 r
F
.52474 .4646 m .55801 .46448 L .55729 .4703 L F
.49151 .46443 m .52474 .4646 L .5248 .47041 L .693 .399 .473 r
F
.34237 .60711 m .37038 .61365 L .33599 .61346 L .734 .863 .942 r
F
.34237 .60711 m .37556 .60735 L .37038 .61365 L F
.59449 .58881 m .62829 .58861 L .63131 .59496 L .603 .687 .901 r
F
.59265 .58246 m .62829 .58861 L .59449 .58881 L .609 .676 .889 r
F
.55887 .58259 m .59265 .58246 L .59449 .58881 L .638 .695 .886 r
F
.55807 .57623 m .59265 .58246 L .55887 .58259 L .644 .684 .873 r
F
.52473 .57628 m .55807 .57623 L .55887 .58259 L .67 .703 .872 r
F
.34294 .43174 m .37603 .4335 L .38084 .43908 L .726 .298 .233 r
F
.33662 .42613 m .37603 .4335 L .34294 .43174 L .711 .268 .198 r
F
.45865 .57606 m .49049 .58257 L .45683 .58243 L .718 .745 .873 r
F
.45865 .57606 m .49144 .57622 L .49049 .58257 L F
.59251 .4583 m .62279 .46336 L .59085 .46407 L .597 .295 .428 r
F
.59251 .4583 m .6253 .45755 L .62279 .46336 L F
.42417 .58219 m .45483 .58878 L .42123 .58857 L .734 .779 .889 r
F
.42417 .58219 m .45683 .58243 L .45483 .58878 L F
.55801 .46448 m .58936 .46991 L .55729 .4703 L .637 .351 .469 r
F
.55801 .46448 m .59085 .46407 L .58936 .46991 L F
.71937 .42097 m .74492 .42429 L .71287 .42648 L .385 0 .116 r
F
.71937 .42097 m .75263 .41865 L .74492 .42429 L F
.72004 .6198 m .76166 .62597 L .72698 .62607 L .447 .673 .96 r
F
.49151 .46443 m .5248 .47041 L .49235 .47025 L .693 .399 .473 r
F
.45878 .46397 m .49151 .46443 L .49235 .47025 L .718 .417 .468 r
F
.45698 .45819 m .49151 .46443 L .45878 .46397 L .711 .393 .438 r
F
.4244 .4574 m .45698 .45819 L .45878 .46397 L .734 .406 .425 r
F
.42149 .45165 m .45698 .45819 L .4244 .4574 L .725 .38 .394 r
F
.63131 .59496 m .66469 .59471 L .66904 .60106 L .563 .678 .916 r
F
.62829 .58861 m .66469 .59471 L .63131 .59496 L .57 .668 .905 r
F
.5248 .56991 m .55807 .57623 L .52473 .57628 L .675 .692 .858 r
F
.49229 .56985 m .52473 .57628 L .49144 .57622 L .7 .712 .858 r
F
.49229 .56985 m .5248 .56991 L .52473 .57628 L F
.67371 .60739 m .7073 .60715 L .71348 .61349 L .51 .678 .941 r
F
.66904 .60106 m .7073 .60715 L .67371 .60739 L .517 .669 .931 r
F
.62805 .45182 m .65669 .45651 L .6253 .45755 L .55 .229 .377 r
F
.62805 .45182 m .66035 .45071 L .65669 .45651 L F
.66864 .43933 m .69568 .44347 L .66433 .44498 L .482 .121 .276 r
F
.66864 .43933 m .70102 .43773 L .69568 .44347 L F
.5248 .47041 m .55666 .47619 L .52486 .4763 L .672 .401 .503 r
F
.5248 .47041 m .55729 .4703 L .55666 .47619 L F
.49235 .47025 m .5248 .47041 L .52486 .4763 L .699 .423 .502 r
F
.29716 .41821 m .32991 .4206 L .33662 .42613 L .699 .218 .105 r
F
.28879 .41262 m .32991 .4206 L .29716 .41821 L .68 .187 .068 r
F
.38914 .58827 m .41804 .59492 L .38495 .59466 L .746 .814 .906 r
F
.38914 .58827 m .42123 .58857 L .41804 .59492 L F
.29634 .6196 m .32206 .62605 L .28789 .62595 L .719 .899 .96 r
F
.29634 .6196 m .32922 .61977 L .32206 .62605 L F
.55807 .57623 m .59098 .57609 L .59265 .58246 L .644 .684 .873 r
F
.55735 .56986 m .59098 .57609 L .55807 .57623 L .649 .672 .859 r
F
.5248 .56991 m .55735 .56986 L .55807 .57623 L .675 .692 .858 r
F
.59265 .58246 m .62551 .58224 L .62829 .58861 L .609 .676 .889 r
F
.59098 .57609 m .62551 .58224 L .59265 .58246 L .614 .665 .875 r
F
.38947 .45049 m .42149 .45165 L .4244 .4574 L .747 .387 .372 r
F
.38533 .44475 m .42149 .45165 L .38947 .45049 L .736 .359 .339 r
F
.46028 .56967 m .49144 .57622 L .45865 .57606 L .724 .734 .859 r
F
.46028 .56967 m .49229 .56985 L .49144 .57622 L F
.55729 .4703 m .58805 .47582 L .55666 .47619 L .643 .375 .498 r
F
.55729 .4703 m .58936 .46991 L .58805 .47582 L F
.59085 .46407 m .62055 .46925 L .58936 .46991 L .604 .32 .459 r
F
.59085 .46407 m .62279 .46336 L .62055 .46925 L F
.34834 .60073 m .37556 .60735 L .34237 .60711 L .744 .857 .932 r
F
.34834 .60073 m .38042 .60102 L .37556 .60735 L F
.42684 .5758 m .45683 .58243 L .42417 .58219 L .741 .769 .876 r
F
.42684 .5758 m .45865 .57606 L .45683 .58243 L F
.49235 .47025 m .52486 .4763 L .4931 .47614 L .699 .423 .502 r
F
.4604 .46981 m .49235 .47025 L .4931 .47614 L .725 .441 .497 r
F
.45878 .46397 m .49235 .47025 L .4604 .46981 L .718 .417 .468 r
F
.34885 .43743 m .38084 .43908 L .38533 .44475 L .74 .329 .269 r
F
.34294 .43174 m .38084 .43908 L .34885 .43743 L .726 .298 .233 r
F
.42704 .46322 m .45878 .46397 L .4604 .46981 L .742 .432 .456 r
F
.4244 .4574 m .45878 .46397 L .42704 .46322 L .734 .406 .425 r
F
.71287 .42648 m .73767 .43001 L .70675 .43206 L .398 0 .153 r
F
.71287 .42648 m .74492 .42429 L .73767 .43001 L F
.52486 .56353 m .55735 .56986 L .5248 .56991 L .68 .679 .843 r
F
.49305 .56347 m .5248 .56991 L .49229 .56985 L .705 .7 .843 r
F
.49305 .56347 m .52486 .56353 L .5248 .56991 L F
.72004 .6198 m .75343 .61963 L .76166 .62597 L .447 .673 .96 r
F
.71348 .61349 m .75343 .61963 L .72004 .6198 L .455 .665 .953 r
F
.62829 .58861 m .66067 .58833 L .66469 .59471 L .57 .668 .905 r
F
.62551 .58224 m .66067 .58833 L .62829 .58861 L .575 .657 .892 r
F
.52486 .4763 m .55611 .48215 L .52491 .48225 L .678 .424 .531 r
F
.52486 .4763 m .55666 .47619 L .55611 .48215 L F
.4931 .47614 m .52486 .4763 L .52491 .48225 L .705 .446 .531 r
F
.6253 .45755 m .65337 .46238 L .62279 .46336 L .559 .255 .41 r
F
.6253 .45755 m .65669 .45651 L .65337 .46238 L F
.55735 .56986 m .58947 .56971 L .59098 .57609 L .649 .672 .859 r
F
.55671 .56349 m .58947 .56971 L .55735 .56986 L .653 .659 .843 r
F
.52486 .56353 m .55671 .56349 L .55735 .56986 L .68 .679 .843 r
F
.66904 .60106 m .70151 .60078 L .7073 .60715 L .517 .669 .931 r
F
.66469 .59471 m .70151 .60078 L .66904 .60106 L .524 .659 .921 r
F
.59098 .57609 m .62298 .57585 L .62551 .58224 L .614 .665 .875 r
F
.58947 .56971 m .62298 .57585 L .59098 .57609 L .619 .652 .861 r
F
.46173 .56328 m .49229 .56985 L .46028 .56967 L .729 .722 .844 r
F
.46173 .56328 m .49305 .56347 L .49229 .56985 L F
.66433 .44498 m .69074 .44929 L .66035 .45071 L .493 .149 .312 r
F
.66433 .44498 m .69568 .44347 L .69074 .44929 L F
.55666 .47619 m .5869 .4818 L .55611 .48215 L .649 .399 .527 r
F
.55666 .47619 m .58805 .47582 L .5869 .4818 L F
.39298 .58186 m .42123 .58857 L .38914 .58827 L .754 .805 .893 r
F
.39298 .58186 m .42417 .58219 L .42123 .58857 L F
.58936 .46991 m .61856 .47519 L .58805 .47582 L .611 .345 .489 r
F
.58936 .46991 m .62055 .46925 L .61856 .47519 L F
.4931 .47614 m .52491 .48225 L .49375 .4821 L .705 .446 .531 r
F
.46183 .47573 m .4931 .47614 L .49375 .4821 L .731 .465 .526 r
F
.4604 .46981 m .4931 .47614 L .46183 .47573 L .725 .441 .497 r
F
.39328 .4563 m .4244 .4574 L .42704 .46322 L .757 .415 .406 r
F
.38947 .45049 m .4244 .4574 L .39328 .4563 L .747 .387 .372 r
F
.42924 .56939 m .45865 .57606 L .42684 .5758 L .747 .758 .861 r
F
.42924 .56939 m .46028 .56967 L .45865 .57606 L F
.30506 .42388 m .33662 .42613 L .34294 .43174 L .717 .251 .142 r
F
.29716 .41821 m .33662 .42613 L .30506 .42388 L .699 .218 .105 r
F
.30432 .61323 m .32922 .61977 L .29634 .6196 L .732 .895 .953 r
F
.30432 .61323 m .33599 .61346 L .32922 .61977 L F
.42941 .46911 m .4604 .46981 L .46183 .47573 L .749 .457 .487 r
F
.42704 .46322 m .4604 .46981 L .42941 .46911 L .742 .432 .456 r
F
.52491 .55716 m .55671 .56349 L .52486 .56353 L .684 .666 .826 r
F
.49371 .55708 m .52486 .56353 L .49305 .56347 L .709 .687 .827 r
F
.49371 .55708 m .52491 .55716 L .52486 .56353 L F
.3539 .59433 m .38042 .60102 L .34834 .60073 L .755 .85 .922 r
F
.3539 .59433 m .38495 .59466 L .38042 .60102 L F
.35436 .44319 m .38533 .44475 L .38947 .45049 L .754 .359 .305 r
F
.34885 .43743 m .38533 .44475 L .35436 .44319 L .74 .329 .269 r
F
.52491 .48225 m .55565 .48816 L .52496 .48826 L .683 .447 .559 r
F
.52491 .48225 m .55611 .48215 L .55565 .48816 L F
.49375 .4821 m .52491 .48225 L .52496 .48826 L .71 .469 .558 r
F
.55671 .56349 m .58814 .56332 L .58947 .56971 L .653 .659 .843 r
F
.55615 .5571 m .58814 .56332 L .55671 .56349 L .657 .646 .827 r
F
.52491 .55716 m .55615 .5571 L .55671 .56349 L .684 .666 .826 r
F
.62551 .58224 m .65698 .58193 L .66067 .58833 L .575 .657 .892 r
F
.62298 .57585 m .65698 .58193 L .62551 .58224 L .581 .645 .879 r
F
.46299 .55688 m .49305 .56347 L .46173 .56328 L .734 .709 .827 r
F
.46299 .55688 m .49371 .55708 L .49305 .56347 L F
.55611 .48215 m .58593 .48784 L .55565 .48816 L .654 .422 .556 r
F
.55611 .48215 m .5869 .4818 L .58593 .48784 L F
.62279 .46336 m .65038 .46832 L .62055 .46925 L .567 .281 .442 r
F
.62279 .46336 m .65337 .46238 L .65038 .46832 L F
.58947 .56971 m .62071 .56945 L .62298 .57585 L .619 .652 .861 r
F
.58814 .56332 m .62071 .56945 L .58947 .56971 L .623 .639 .845 r
F
.70675 .43206 m .73088 .4358 L .70102 .43773 L .411 .023 .19 r
F
.70675 .43206 m .73767 .43001 L .73088 .4358 L F
.49375 .4821 m .52496 .48826 L .4943 .48813 L .71 .469 .558 r
F
.46308 .48171 m .49375 .4821 L .4943 .48813 L .736 .488 .555 r
F
.46183 .47573 m .49375 .4821 L .46308 .48171 L .731 .465 .526 r
F
.71348 .61349 m .74565 .61327 L .75343 .61963 L .455 .665 .953 r
F
.7073 .60715 m .74565 .61327 L .71348 .61349 L .462 .657 .945 r
F
.58805 .47582 m .61683 .48121 L .5869 .4818 L .617 .369 .519 r
F
.58805 .47582 m .61856 .47519 L .61683 .48121 L F
.52495 .55078 m .55615 .5571 L .52491 .55716 L .688 .652 .809 r
F
.49427 .5507 m .52491 .55716 L .49371 .55708 L .713 .673 .809 r
F
.49427 .5507 m .52495 .55078 L .52491 .55716 L F
.43136 .56298 m .46028 .56967 L .42924 .56939 L .753 .746 .846 r
F
.43136 .56298 m .46173 .56328 L .46028 .56967 L F
.39648 .57544 m .42417 .58219 L .39298 .58186 L .762 .795 .879 r
F
.39648 .57544 m .42684 .5758 L .42417 .58219 L F
.66469 .59471 m .69612 .59439 L .70151 .60078 L .524 .659 .921 r
F
.66067 .58833 m .69612 .59439 L .66469 .59471 L .53 .648 .91 r
F
.66035 .45071 m .68621 .45517 L .65669 .45651 L .504 .178 .347 r
F
.66035 .45071 m .69074 .44929 L .68621 .45517 L F
.52496 .48826 m .55526 .49424 L .52499 .49433 L .687 .469 .586 r
F
.52496 .48826 m .55565 .48816 L .55526 .49424 L F
.4943 .48813 m .52496 .48826 L .52499 .49433 L .714 .491 .586 r
F
.39674 .46218 m .42704 .46322 L .42941 .46911 L .766 .442 .439 r
F
.39328 .4563 m .42704 .46322 L .39674 .46218 L .757 .415 .406 r
F
.43151 .47506 m .46183 .47573 L .46308 .48171 L .756 .481 .517 r
F
.42941 .46911 m .46183 .47573 L .43151 .47506 L .749 .457 .487 r
F
.76079 .41308 m .78265 .41594 L .75263 .41865 L .293 0 .003 r
F
.76079 .41308 m .79201 .4102 L .78265 .41594 L F
.55615 .5571 m .58698 .55693 L .58814 .56332 L .657 .646 .827 r
F
.55568 .55072 m .58698 .55693 L .55615 .5571 L .66 .631 .81 r
F
.52495 .55078 m .55568 .55072 L .55615 .5571 L .688 .652 .809 r
F
.46406 .55049 m .49371 .55708 L .46299 .55688 L .738 .695 .81 r
F
.46406 .55049 m .49427 .5507 L .49371 .55708 L F
.55565 .48816 m .58513 .49393 L .55526 .49424 L .658 .445 .583 r
F
.55565 .48816 m .58593 .48784 L .58513 .49393 L F
.3125 .42963 m .34294 .43174 L .34885 .43743 L .735 .284 .18 r
F
.30506 .42388 m .34294 .43174 L .3125 .42963 L .717 .251 .142 r
F
.4943 .48813 m .52499 .49433 L .49476 .4942 L .714 .491 .586 r
F
.46413 .48776 m .4943 .48813 L .49476 .4942 L .74 .511 .582 r
F
.46308 .48171 m .4943 .48813 L .46413 .48776 L .736 .488 .555 r
F
.35904 .5879 m .38495 .59466 L .3539 .59433 L .764 .842 .91 r
F
.35904 .5879 m .38914 .58827 L .38495 .59466 L F
.31183 .60682 m .33599 .61346 L .30432 .61323 L .744 .891 .946 r
F
.31183 .60682 m .34237 .60711 L .33599 .61346 L F
.58814 .56332 m .6187 .56304 L .62071 .56945 L .623 .639 .845 r
F
.58698 .55693 m .6187 .56304 L .58814 .56332 L .627 .625 .829 r
F
.52499 .54441 m .55568 .55072 L .52495 .55078 L .69 .637 .791 r
F
.49473 .54433 m .52495 .55078 L .49427 .5507 L .716 .659 .791 r
F
.49473 .54433 m .52499 .54441 L .52495 .55078 L F
.35945 .44902 m .38947 .45049 L .39328 .4563 L .766 .389 .341 r
F
.35436 .44319 m .38947 .45049 L .35945 .44902 L .754 .359 .305 r
F
.62298 .57585 m .65362 .57551 L .65698 .58193 L .581 .645 .879 r
F
.62071 .56945 m .65362 .57551 L .62298 .57585 L .586 .632 .864 r
F
.5869 .4818 m .61536 .48728 L .58593 .48784 L .622 .393 .548 r
F
.5869 .4818 m .61683 .48121 L .61536 .48728 L F
.52499 .49433 m .55497 .50037 L .52502 .50046 L .69 .491 .612 r
F
.52499 .49433 m .55526 .49424 L .55497 .50037 L F
.49476 .4942 m .52499 .49433 L .52502 .50046 L .717 .513 .612 r
F
.62055 .46925 m .64774 .47432 L .61856 .47519 L .574 .307 .474 r
F
.62055 .46925 m .65038 .46832 L .64774 .47432 L F
.43322 .55656 m .46173 .56328 L .43136 .56298 L .758 .733 .829 r
F
.43322 .55656 m .46299 .55688 L .46173 .56328 L F
.55568 .55072 m .58599 .55053 L .58698 .55693 L .66 .631 .81 r
F
.55529 .54435 m .58599 .55053 L .55568 .55072 L .663 .616 .792 r
F
.52499 .54441 m .55529 .54435 L .55568 .55072 L .69 .637 .791 r
F
.43334 .48108 m .46308 .48171 L .46413 .48776 L .761 .506 .547 r
F
.43151 .47506 m .46308 .48171 L .43334 .48108 L .756 .481 .517 r
F
.39962 .56901 m .42684 .5758 L .39648 .57544 L .769 .783 .865 r
F
.39962 .56901 m .42924 .56939 L .42684 .5758 L F
.55526 .49424 m .58451 .50008 L .55497 .50037 L .662 .466 .61 r
F
.55526 .49424 m .58513 .49393 L .58451 .50008 L F
.46494 .5441 m .49427 .5507 L .46406 .55049 L .741 .68 .792 r
F
.46494 .5441 m .49473 .54433 L .49427 .5507 L F
.52502 .53805 m .55529 .54435 L .52499 .54441 L .693 .622 .772 r
F
.49509 .53796 m .52499 .54441 L .49473 .54433 L .719 .643 .772 r
F
.49509 .53796 m .52502 .53805 L .52499 .54441 L F
.70102 .43773 m .72457 .44166 L .69568 .44347 L .424 .053 .228 r
F
.70102 .43773 m .73088 .4358 L .72457 .44166 L F
.39985 .46813 m .42941 .46911 L .43151 .47506 L .774 .469 .471 r
F
.39674 .46218 m .42941 .46911 L .39985 .46813 L .766 .442 .439 r
F
.49476 .4942 m .52502 .50046 L .49511 .50034 L .717 .513 .612 r
F
.465 .49386 m .49476 .4942 L .49511 .50034 L .743 .533 .609 r
F
.46413 .48776 m .49476 .4942 L .465 .49386 L .74 .511 .582 r
F
.25819 .40967 m .28879 .41262 L .29716 .41821 L .67 .15 0 r
F
.7073 .60715 m .73832 .60687 L .74565 .61327 L .462 .657 .945 r
F
.70151 .60078 m .73832 .60687 L .7073 .60715 L .469 .648 .936 r
F
.66067 .58833 m .69114 .58797 L .69612 .59439 L .53 .648 .91 r
F
.65698 .58193 m .69114 .58797 L .66067 .58833 L .536 .637 .897 r
F
.52502 .50046 m .55475 .50655 L .52504 .50663 L .693 .512 .638 r
F
.52502 .50046 m .55497 .50037 L .55475 .50655 L F
.49511 .50034 m .52502 .50046 L .52504 .50663 L .72 .533 .638 r
F
.65669 .45651 m .6821 .46112 L .65337 .46238 L .513 .206 .382 r
F
.65669 .45651 m .68621 .45517 L .6821 .46112 L F
.58698 .55693 m .61694 .55662 L .6187 .56304 L .627 .625 .829 r
F
.58599 .55053 m .61694 .55662 L .58698 .55693 L .631 .61 .811 r
F
.55529 .54435 m .58518 .54415 L .58599 .55053 L .663 .616 .792 r
F
.55498 .53799 m .58518 .54415 L .55529 .54435 L .665 .6 .772 r
F
.52502 .53805 m .55498 .53799 L .55529 .54435 L .693 .622 .772 r
F
.58593 .48784 m .61416 .4934 L .58513 .49393 L .627 .416 .577 r
F
.58593 .48784 m .61536 .48728 L .61416 .4934 L F
.55497 .50037 m .58407 .50627 L .55475 .50655 L .664 .488 .636 r
F
.55497 .50037 m .58451 .50008 L .58407 .50627 L F
.52504 .53171 m .55498 .53799 L .52502 .53805 L .695 .605 .752 r
F
.49535 .53162 m .52502 .53805 L .49509 .53796 L .721 .627 .752 r
F
.49535 .53162 m .52504 .53171 L .52502 .53805 L F
.46563 .53773 m .49473 .54433 L .46494 .5441 L .744 .665 .772 r
F
.46563 .53773 m .49509 .53796 L .49473 .54433 L F
.62071 .56945 m .6506 .56908 L .65362 .57551 L .586 .632 .864 r
F
.6187 .56304 m .6506 .56908 L .62071 .56945 L .59 .618 .848 r
F
.43479 .55015 m .46299 .55688 L .43322 .55656 L .762 .719 .811 r
F
.43479 .55015 m .46406 .55049 L .46299 .55688 L F
.52504 .50663 m .55463 .51277 L .52505 .51285 L .695 .532 .662 r
F
.52504 .50663 m .55475 .50655 L .55463 .51277 L F
.49536 .50652 m .52504 .50663 L .52505 .51285 L .721 .554 .662 r
F
.49511 .50034 m .52504 .50663 L .49536 .50652 L .72 .533 .638 r
F
.46567 .50001 m .49511 .50034 L .49536 .50652 L .746 .554 .635 r
F
.465 .49386 m .49511 .50034 L .46567 .50001 L .743 .533 .609 r
F
.61856 .47519 m .64544 .48038 L .61683 .48121 L .581 .333 .506 r
F
.61856 .47519 m .64774 .47432 L .64544 .48038 L F
.43489 .48716 m .46413 .48776 L .465 .49386 L .766 .529 .576 r
F
.43334 .48108 m .46413 .48776 L .43489 .48716 L .761 .506 .547 r
F
.75263 .41865 m .7738 .42175 L .74492 .42429 L .308 0 .041 r
F
.75263 .41865 m .78265 .41594 L .7738 .42175 L F
.36376 .58145 m .38914 .58827 L .35904 .5879 L .774 .833 .898 r
F
.36376 .58145 m .39298 .58186 L .38914 .58827 L F
.52504 .53171 m .55477 .53164 L .55498 .53799 L .695 .605 .752 r
F
.52505 .52539 m .55477 .53164 L .52504 .53171 L .696 .588 .731 r
F
.4955 .5253 m .52504 .53171 L .49535 .53162 L .722 .61 .731 r
F
.4955 .5253 m .52505 .52539 L .52504 .53171 L F
.36412 .45492 m .39328 .4563 L .39674 .46218 L .778 .419 .377 r
F
.35945 .44902 m .39328 .4563 L .36412 .45492 L .766 .389 .341 r
F
.55498 .53799 m .58455 .53778 L .58518 .54415 L .665 .6 .772 r
F
.55477 .53164 m .58455 .53778 L .55498 .53799 L .667 .583 .752 r
F
.52505 .51285 m .55459 .51903 L .52505 .5191 L .696 .551 .686 r
F
.52505 .51285 m .55463 .51277 L .55459 .51903 L F
.49551 .51274 m .52505 .51285 L .52505 .5191 L .722 .573 .686 r
F
.49536 .50652 m .52505 .51285 L .49551 .51274 L .721 .554 .662 r
F
.31946 .43544 m .34885 .43743 L .35436 .44319 L .752 .317 .218 r
F
.3125 .42963 m .34885 .43743 L .31946 .43544 L .735 .284 .18 r
F
.55475 .50655 m .58381 .51251 L .55463 .51277 L .666 .508 .661 r
F
.55475 .50655 m .58407 .50627 L .58381 .51251 L F
.31886 .60038 m .34237 .60711 L .31183 .60682 L .757 .886 .937 r
F
.31886 .60038 m .34834 .60073 L .34237 .60711 L F
.52505 .52539 m .55463 .52532 L .55477 .53164 L .696 .588 .731 r
F
.52505 .5191 m .55463 .52532 L .52505 .52539 L .696 .57 .709 r
F
.49556 .519 m .52505 .52539 L .4955 .5253 L .723 .592 .709 r
F
.49556 .519 m .52505 .5191 L .52505 .52539 L F
.46613 .53137 m .49509 .53796 L .46563 .53773 L .746 .649 .752 r
F
.46613 .53137 m .49535 .53162 L .49509 .53796 L F
.75343 .61963 m .79301 .62585 L .76166 .62597 L .388 .649 .961 r
F
.52505 .5191 m .55459 .51903 L .55463 .52532 L .696 .57 .709 r
F
.49551 .51274 m .52505 .5191 L .49556 .519 L .722 .573 .686 r
F
.58599 .55053 m .61546 .55021 L .61694 .55662 L .631 .61 .811 r
F
.58518 .54415 m .61546 .55021 L .58599 .55053 L .633 .594 .792 r
F
.4024 .56256 m .42924 .56939 L .39962 .56901 L .776 .771 .849 r
F
.4024 .56256 m .43136 .56298 L .42924 .56939 L F
.46615 .5062 m .49536 .50652 L .49551 .51274 L .748 .575 .661 r
F
.46567 .50001 m .49536 .50652 L .46615 .5062 L .746 .554 .635 r
F
.58513 .49393 m .61322 .49958 L .58451 .50008 L .631 .439 .605 r
F
.58513 .49393 m .61416 .4934 L .61322 .49958 L F
.4026 .47415 m .43151 .47506 L .43334 .48108 L .781 .495 .503 r
F
.39985 .46813 m .43151 .47506 L .4026 .47415 L .774 .469 .471 r
F
.55477 .53164 m .5841 .53142 L .58455 .53778 L .667 .583 .752 r
F
.55463 .52532 m .5841 .53142 L .55477 .53164 L .668 .566 .731 r
F
.55463 .51277 m .58372 .51878 L .55459 .51903 L .668 .528 .685 r
F
.55463 .51277 m .58381 .51251 L .58372 .51878 L F
.43608 .54374 m .46406 .55049 L .43479 .55015 L .766 .704 .793 r
F
.43608 .54374 m .46494 .5441 L .46406 .55049 L F
.46642 .52503 m .49535 .53162 L .46613 .53137 L .748 .631 .731 r
F
.46642 .52503 m .4955 .5253 L .49535 .53162 L F
.55463 .52532 m .58382 .52509 L .5841 .53142 L .668 .566 .731 r
F
.55459 .51903 m .58382 .52509 L .55463 .52532 L .668 .547 .709 r
F
.55459 .51903 m .58372 .51878 L .58382 .52509 L F
.46644 .51244 m .49551 .51274 L .49556 .519 L .748 .594 .685 r
F
.46615 .5062 m .49551 .51274 L .46644 .51244 L .748 .575 .661 r
F
.65698 .58193 m .68657 .58153 L .69114 .58797 L .536 .637 .897 r
F
.65362 .57551 m .68657 .58153 L .65698 .58193 L .542 .624 .883 r
F
.43616 .49329 m .465 .49386 L .46567 .50001 L .769 .552 .604 r
F
.43489 .48716 m .465 .49386 L .43616 .49329 L .766 .529 .576 r
F
.46653 .51872 m .4955 .5253 L .46642 .52503 L .749 .613 .708 r
F
.46653 .51872 m .49556 .519 L .4955 .5253 L F
.65337 .46238 m .67841 .46713 L .65038 .46832 L .522 .234 .417 r
F
.65337 .46238 m .6821 .46112 L .67841 .46713 L F
.46644 .51244 m .49556 .519 L .46653 .51872 L .748 .594 .685 r
F
.6187 .56304 m .64793 .56264 L .6506 .56908 L .59 .618 .848 r
F
.61694 .55662 m .64793 .56264 L .6187 .56304 L .594 .604 .831 r
F
.69568 .44347 m .71873 .44758 L .69074 .44929 L .436 .083 .266 r
F
.69568 .44347 m .72457 .44166 L .71873 .44758 L F
.58518 .54415 m .61423 .54381 L .61546 .55021 L .633 .594 .792 r
F
.58455 .53778 m .61423 .54381 L .58518 .54415 L .635 .578 .773 r
F
.70151 .60078 m .73147 .60045 L .73832 .60687 L .469 .648 .936 r
F
.69612 .59439 m .73147 .60045 L .70151 .60078 L .476 .638 .926 r
F
.61683 .48121 m .6435 .4865 L .61536 .48728 L .586 .358 .537 r
F
.61683 .48121 m .64544 .48038 L .6435 .4865 L F
.58451 .50008 m .61256 .5058 L .58407 .50627 L .634 .461 .632 r
F
.58451 .50008 m .61322 .49958 L .61256 .5058 L F
.26775 .41545 m .29716 .41821 L .30506 .42388 L .692 .185 .026 r
F
.25819 .40967 m .29716 .41821 L .26775 .41545 L .67 .15 0 r
F
.43709 .53734 m .46494 .5441 L .43608 .54374 L .77 .688 .773 r
F
.43709 .53734 m .46563 .53773 L .46494 .5441 L F
.43715 .49947 m .46567 .50001 L .46615 .5062 L .772 .574 .631 r
F
.43616 .49329 m .46567 .50001 L .43715 .49947 L .769 .552 .604 r
F
.40483 .55612 m .43136 .56298 L .4024 .56256 L .782 .758 .832 r
F
.40483 .55612 m .43322 .55656 L .43136 .56298 L F
.36805 .57499 m .39298 .58186 L .36376 .58145 L .783 .823 .884 r
F
.36805 .57499 m .39648 .57544 L .39298 .58186 L F
.58455 .53778 m .61328 .53742 L .61423 .54381 L .635 .578 .773 r
F
.5841 .53142 m .61328 .53742 L .58455 .53778 L .637 .56 .752 r
F
.40499 .48022 m .43334 .48108 L .43489 .48716 L .787 .521 .534 r
F
.4026 .47415 m .43334 .48108 L .40499 .48022 L .781 .495 .503 r
F
.36837 .46088 m .39674 .46218 L .39985 .46813 L .788 .449 .412 r
F
.36412 .45492 m .39674 .46218 L .36837 .46088 L .778 .419 .377 r
F
.58407 .50627 m .61216 .51206 L .58381 .51251 L .636 .483 .658 r
F
.58407 .50627 m .61256 .5058 L .61216 .51206 L F
.26682 .61941 m .28789 .62595 L .25717 .62583 L .719 .924 .961 r
F
.26682 .61941 m .29634 .6196 L .28789 .62595 L F
.43781 .53096 m .46563 .53773 L .43709 .53734 L .772 .671 .752 r
F
.43781 .53096 m .46613 .53137 L .46563 .53773 L F
.5841 .53142 m .61259 .53104 L .61328 .53742 L .637 .56 .752 r
F
.58382 .52509 m .61259 .53104 L .5841 .53142 L .638 .542 .73 r
F
.74492 .42429 m .76549 .42762 L .73767 .43001 L .322 0 .08 r
F
.74492 .42429 m .7738 .42175 L .76549 .42762 L F
.61694 .55662 m .6456 .5562 L .64793 .56264 L .594 .604 .831 r
F
.61546 .55021 m .6456 .5562 L .61694 .55662 L .597 .588 .813 r
F
.32594 .44132 m .35436 .44319 L .35945 .44902 L .768 .35 .257 r
F
.31946 .43544 m .35436 .44319 L .32594 .44132 L .752 .317 .218 r
F
.58381 .51251 m .61203 .51836 L .58372 .51878 L .637 .503 .683 r
F
.58381 .51251 m .61216 .51206 L .61203 .51836 L F
.43785 .5057 m .46615 .5062 L .46644 .51244 L .774 .595 .657 r
F
.43715 .49947 m .46615 .5062 L .43785 .5057 L .772 .574 .631 r
F
.3254 .59393 m .34834 .60073 L .31886 .60038 L .769 .88 .927 r
F
.3254 .59393 m .3539 .59433 L .34834 .60073 L F
.61536 .48728 m .6419 .49266 L .61416 .4934 L .591 .383 .567 r
F
.61536 .48728 m .6435 .4865 L .6419 .49266 L F
.58382 .52509 m .61218 .52469 L .61259 .53104 L .638 .542 .73 r
F
.58372 .51878 m .61218 .52469 L .58382 .52509 L .638 .523 .707 r
F
.58372 .51878 m .61203 .51836 L .61218 .52469 L F
.65362 .57551 m .68241 .57507 L .68657 .58153 L .542 .624 .883 r
F
.6506 .56908 m .68241 .57507 L .65362 .57551 L .547 .61 .868 r
F
.43825 .5246 m .46613 .53137 L .43781 .53096 L .774 .654 .73 r
F
.43825 .5246 m .46642 .52503 L .46613 .53137 L F
.75343 .61963 m .78356 .61944 L .79301 .62585 L .388 .649 .961 r
F
.74565 .61327 m .78356 .61944 L .75343 .61963 L .396 .641 .955 r
F
.65038 .46832 m .67514 .4732 L .64774 .47432 L .531 .262 .452 r
F
.65038 .46832 m .67841 .46713 L .67514 .4732 L F
.43827 .51197 m .46644 .51244 L .46653 .51872 L .775 .615 .682 r
F
.43785 .5057 m .46644 .51244 L .43827 .51197 L .774 .595 .657 r
F
.4384 .51827 m .46642 .52503 L .43825 .5246 L .775 .635 .706 r
F
.4384 .51827 m .46653 .51872 L .46642 .52503 L F
.43827 .51197 m .46653 .51872 L .4384 .51827 L .775 .615 .682 r
F
.40688 .54968 m .43322 .55656 L .40483 .55612 L .787 .744 .813 r
F
.40688 .54968 m .43479 .55015 L .43322 .55656 L F
.40702 .48634 m .43489 .48716 L .43616 .49329 L .792 .546 .565 r
F
.40499 .48022 m .43489 .48716 L .40702 .48634 L .787 .521 .534 r
F
.69074 .44929 m .71338 .45356 L .68621 .45517 L .447 .113 .305 r
F
.69074 .44929 m .71873 .44758 L .71338 .45356 L F
.69612 .59439 m .72509 .594 L .73147 .60045 L .476 .638 .926 r
F
.69114 .58797 m .72509 .594 L .69612 .59439 L .483 .626 .915 r
F
.61546 .55021 m .64362 .54976 L .6456 .5562 L .597 .588 .813 r
F
.61423 .54381 m .64362 .54976 L .61546 .55021 L .6 .571 .794 r
F
.61416 .4934 m .64066 .49888 L .61322 .49958 L .596 .407 .596 r
F
.61416 .4934 m .6419 .49266 L .64066 .49888 L F
.3719 .56852 m .39648 .57544 L .36805 .57499 L .791 .812 .869 r
F
.3719 .56852 m .39962 .56901 L .39648 .57544 L F
.37218 .46691 m .39985 .46813 L .4026 .47415 L .798 .478 .447 r
F
.36837 .46088 m .39985 .46813 L .37218 .46691 L .788 .449 .412 r
F
.27678 .42128 m .30506 .42388 L .3125 .42963 L .714 .22 .066 r
F
.26775 .41545 m .30506 .42388 L .27678 .42128 L .692 .185 .026 r
F
.40857 .54324 m .43479 .55015 L .40688 .54968 L .792 .729 .794 r
F
.40857 .54324 m .43608 .54374 L .43479 .55015 L F
.40868 .49252 m .43616 .49329 L .43715 .49947 L .796 .57 .595 r
F
.40702 .48634 m .43616 .49329 L .40868 .49252 L .792 .546 .565 r
F
.6506 .56908 m .67868 .56861 L .68241 .57507 L .547 .61 .868 r
F
.64793 .56264 m .67868 .56861 L .6506 .56908 L .551 .596 .852 r
F
.61423 .54381 m .642 .54333 L .64362 .54976 L .6 .571 .794 r
F
.61328 .53742 m .642 .54333 L .61423 .54381 L .602 .554 .773 r
F
.64774 .47432 m .6723 .47932 L .64544 .48038 L .538 .289 .486 r
F
.64774 .47432 m .67514 .4732 L .6723 .47932 L F
.61322 .49958 m .63977 .50514 L .61256 .5058 L .599 .43 .625 r
F
.61322 .49958 m .64066 .49888 L .63977 .50514 L F
.27593 .61296 m .29634 .6196 L .26682 .61941 L .734 .923 .955 r
F
.27593 .61296 m .30432 .61323 L .29634 .6196 L F
.33192 .44726 m .35945 .44902 L .36412 .45492 L .783 .383 .296 r
F
.32594 .44132 m .35945 .44902 L .33192 .44726 L .768 .35 .257 r
F
.33144 .58745 m .3539 .59433 L .3254 .59393 L .78 .873 .916 r
F
.33144 .58745 m .35904 .5879 L .3539 .59433 L F
.73767 .43001 m .75772 .43355 L .73088 .4358 L .336 0 .12 r
F
.73767 .43001 m .76549 .42762 L .75772 .43355 L F
.40989 .53681 m .43608 .54374 L .40857 .54324 L .796 .713 .773 r
F
.40989 .53681 m .43709 .53734 L .43608 .54374 L F
.61328 .53742 m .64073 .53691 L .642 .54333 L .602 .554 .773 r
F
.61259 .53104 m .64073 .53691 L .61328 .53742 L .603 .536 .751 r
F
.61256 .5058 m .63925 .51143 L .61216 .51206 L .601 .453 .652 r
F
.61256 .5058 m .63977 .50514 L .63925 .51143 L F
.40997 .49874 m .43715 .49947 L .43785 .5057 L .799 .593 .623 r
F
.40868 .49252 m .43715 .49947 L .40997 .49874 L .796 .57 .595 r
F
.74565 .61327 m .77463 .613 L .78356 .61944 L .396 .641 .955 r
F
.73832 .60687 m .77463 .613 L .74565 .61327 L .403 .633 .948 r
F
.37531 .56204 m .39962 .56901 L .3719 .56852 L .799 .8 .852 r
F
.37531 .56204 m .4024 .56256 L .39962 .56901 L F
.37555 .47299 m .4026 .47415 L .40499 .48022 L .806 .506 .482 r
F
.37218 .46691 m .4026 .47415 L .37555 .47299 L .798 .478 .447 r
F
.68621 .45517 m .70852 .4596 L .6821 .46112 L .458 .143 .343 r
F
.68621 .45517 m .71338 .45356 L .70852 .4596 L F
.69114 .58797 m .7192 .58753 L .72509 .594 L .483 .626 .915 r
F
.68657 .58153 m .7192 .58753 L .69114 .58797 L .489 .614 .902 r
F
.61259 .53104 m .63982 .53051 L .64073 .53691 L .603 .536 .751 r
F
.61218 .52469 m .63982 .53051 L .61259 .53104 L .604 .516 .728 r
F
.61216 .51206 m .63908 .51776 L .61203 .51836 L .603 .475 .679 r
F
.61216 .51206 m .63925 .51143 L .63908 .51776 L F
.41084 .5304 m .43709 .53734 L .40989 .53681 L .798 .695 .751 r
F
.41084 .5304 m .43781 .53096 L .43709 .53734 L F
.61218 .52469 m .63927 .52412 L .63982 .53051 L .604 .516 .728 r
F
.61203 .51836 m .63927 .52412 L .61218 .52469 L .604 .496 .704 r
F
.61203 .51836 m .63908 .51776 L .63927 .52412 L F
.64793 .56264 m .67537 .56214 L .67868 .56861 L .551 .596 .852 r
F
.6456 .5562 m .67537 .56214 L .64793 .56264 L .555 .58 .834 r
F
.41089 .50501 m .43785 .5057 L .43827 .51197 L .801 .616 .651 r
F
.40997 .49874 m .43785 .5057 L .41089 .50501 L .799 .593 .623 r
F
.64544 .48038 m .66989 .4855 L .6435 .4865 L .544 .316 .519 r
F
.64544 .48038 m .6723 .47932 L .66989 .4855 L F
.41141 .52401 m .43781 .53096 L .41084 .5304 L .801 .677 .728 r
F
.41141 .52401 m .43825 .5246 L .43781 .53096 L F
.41144 .51131 m .43827 .51197 L .4384 .51827 L .802 .637 .678 r
F
.41089 .50501 m .43827 .51197 L .41144 .51131 L .801 .616 .651 r
F
.41161 .51765 m .43825 .5246 L .41141 .52401 L .802 .658 .703 r
F
.41161 .51765 m .4384 .51827 L .43825 .5246 L F
.41144 .51131 m .4384 .51827 L .41161 .51765 L .802 .637 .678 r
F
.28526 .42718 m .3125 .42963 L .31946 .43544 L .735 .256 .106 r
F
.27678 .42128 m .3125 .42963 L .28526 .42718 L .714 .22 .066 r
F
.33741 .45326 m .36412 .45492 L .36837 .46088 L .797 .416 .335 r
F
.33192 .44726 m .36412 .45492 L .33741 .45326 L .783 .383 .296 r
F
.33698 .58096 m .35904 .5879 L .33144 .58745 L .792 .865 .903 r
F
.33698 .58096 m .36376 .58145 L .35904 .5879 L F
.37828 .55556 m .4024 .56256 L .37531 .56204 L .806 .787 .835 r
F
.37828 .55556 m .40483 .55612 L .4024 .56256 L F
.37848 .47912 m .40499 .48022 L .40702 .48634 L .813 .534 .516 r
F
.37555 .47299 m .40499 .48022 L .37848 .47912 L .806 .506 .482 r
F
.2845 .60648 m .30432 .61323 L .27593 .61296 L .749 .92 .948 r
F
.2845 .60648 m .31183 .60682 L .30432 .61323 L F
.6456 .5562 m .67249 .55566 L .67537 .56214 L .555 .58 .834 r
F
.64362 .54976 m .67249 .55566 L .6456 .5562 L .559 .564 .815 r
F
.6435 .4865 m .66792 .49172 L .6419 .49266 L .55 .343 .552 r
F
.6435 .4865 m .66989 .4855 L .66792 .49172 L F
.73088 .4358 m .75049 .43954 L .72457 .44166 L .349 0 .161 r
F
.73088 .4358 m .75772 .43355 L .75049 .43954 L F
.6821 .46112 m .70416 .4657 L .67841 .46713 L .468 .173 .382 r
F
.6821 .46112 m .70852 .4596 L .70416 .4657 L F
.68657 .58153 m .71379 .58105 L .7192 .58753 L .489 .614 .902 r
F
.68241 .57507 m .71379 .58105 L .68657 .58153 L .495 .601 .888 r
F
.73832 .60687 m .76624 .60654 L .77463 .613 L .403 .633 .948 r
F
.73147 .60045 m .76624 .60654 L .73832 .60687 L .41 .623 .94 r
F
.38079 .54908 m .40483 .55612 L .37828 .55556 L .813 .772 .816 r
F
.38079 .54908 m .40688 .54968 L .40483 .55612 L F
.38096 .48531 m .40702 .48634 L .40868 .49252 L .819 .561 .549 r
F
.37848 .47912 m .40702 .48634 L .38096 .48531 L .813 .534 .516 r
F
.64362 .54976 m .67005 .54919 L .67249 .55566 L .559 .564 .815 r
F
.642 .54333 m .67005 .54919 L .64362 .54976 L .561 .546 .795 r
F
.79201 .4102 m .80883 .41288 L .78265 .41594 L .196 0 0 r
F
.79201 .4102 m .81931 .40694 L .80883 .41288 L F
.6419 .49266 m .66639 .49799 L .64066 .49888 L .555 .369 .584 r
F
.6419 .49266 m .66792 .49172 L .66639 .49799 L F
.34239 .45932 m .36837 .46088 L .37218 .46691 L .81 .449 .374 r
F
.33741 .45326 m .36837 .46088 L .34239 .45932 L .797 .416 .335 r
F
.34201 .57445 m .36376 .58145 L .33698 .58096 L .803 .855 .889 r
F
.34201 .57445 m .36805 .57499 L .36376 .58145 L F
.29319 .43314 m .31946 .43544 L .32594 .44132 L .756 .292 .147 r
F
.28526 .42718 m .31946 .43544 L .29319 .43314 L .735 .256 .106 r
F
.642 .54333 m .66805 .54273 L .67005 .54919 L .561 .546 .795 r
F
.64073 .53691 m .66805 .54273 L .642 .54333 L .563 .527 .773 r
F
.67841 .46713 m .7003 .47185 L .67514 .4732 L .477 .204 .42 r
F
.67841 .46713 m .70416 .4657 L .7003 .47185 L F
.64066 .49888 m .66529 .50429 L .63977 .50514 L .559 .394 .614 r
F
.64066 .49888 m .66639 .49799 L .66529 .50429 L F
.38286 .54261 m .40688 .54968 L .38079 .54908 L .818 .757 .795 r
F
.38286 .54261 m .40857 .54324 L .40688 .54968 L F
.68241 .57507 m .70888 .57455 L .71379 .58105 L .495 .601 .888 r
F
.67868 .56861 m .70888 .57455 L .68241 .57507 L .5 .586 .873 r
F
.38299 .49154 m .40868 .49252 L .40997 .49874 L .824 .587 .581 r
F
.38096 .48531 m .40868 .49252 L .38299 .49154 L .819 .561 .549 r
F
.2925 .59998 m .31183 .60682 L .2845 .60648 L .764 .917 .94 r
F
.2925 .59998 m .31886 .60038 L .31183 .60682 L F
.72457 .44166 m .74381 .44559 L .71873 .44758 L .362 0 .203 r
F
.72457 .44166 m .75049 .43954 L .74381 .44559 L F
.64073 .53691 m .66648 .53627 L .66805 .54273 L .563 .527 .773 r
F
.63982 .53051 m .66648 .53627 L .64073 .53691 L .565 .508 .75 r
F
.63977 .50514 m .66464 .51064 L .63925 .51143 L .562 .419 .644 r
F
.63977 .50514 m .66529 .50429 L .66464 .51064 L F
.73147 .60045 m .75839 .60006 L .76624 .60654 L .41 .623 .94 r
F
.72509 .594 m .75839 .60006 L .73147 .60045 L .417 .613 .93 r
F
.38448 .53615 m .40857 .54324 L .38286 .54261 L .823 .74 .773 r
F
.38448 .53615 m .40989 .53681 L .40857 .54324 L F
.38457 .49782 m .40997 .49874 L .41089 .50501 L .827 .613 .612 r
F
.38299 .49154 m .40997 .49874 L .38457 .49782 L .824 .587 .581 r
F
.63982 .53051 m .66536 .52983 L .66648 .53627 L .565 .508 .75 r
F
.63927 .52412 m .66536 .52983 L .63982 .53051 L .565 .487 .725 r
F
.63925 .51143 m .66444 .51701 L .63908 .51776 L .564 .442 .672 r
F
.63925 .51143 m .66464 .51064 L .66444 .51701 L F
.34686 .46544 m .37218 .46691 L .37555 .47299 L .821 .482 .413 r
F
.34239 .45932 m .37218 .46691 L .34686 .46544 L .81 .449 .374 r
F
.23162 .40635 m .25819 .40967 L .26775 .41545 L .644 .096 0 r
F
.63927 .52412 m .66468 .52341 L .66536 .52983 L .565 .487 .725 r
F
.63908 .51776 m .66468 .52341 L .63927 .52412 L .565 .465 .7 r
F
.63908 .51776 m .66444 .51701 L .66468 .52341 L F
.34653 .56794 m .36805 .57499 L .34201 .57445 L .813 .845 .874 r
F
.34653 .56794 m .3719 .56852 L .36805 .57499 L F
.38563 .5297 m .40989 .53681 L .38448 .53615 L .826 .722 .75 r
F
.38563 .5297 m .41084 .5304 L .40989 .53681 L F
.3857 .50413 m .41089 .50501 L .41144 .51131 L .829 .637 .642 r
F
.38457 .49782 m .41089 .50501 L .3857 .50413 L .827 .613 .612 r
F
.67514 .4732 m .69695 .47805 L .6723 .47932 L .486 .234 .457 r
F
.67514 .4732 m .7003 .47185 L .69695 .47805 L F
.67868 .56861 m .70447 .56804 L .70888 .57455 L .5 .586 .873 r
F
.67537 .56214 m .70447 .56804 L .67868 .56861 L .505 .571 .856 r
F
.78265 .41594 m .79895 .41887 L .7738 .42175 L .21 0 0 r
F
.78265 .41594 m .80883 .41288 L .79895 .41887 L F
.30057 .43916 m .32594 .44132 L .33192 .44726 L .776 .329 .19 r
F
.29319 .43314 m .32594 .44132 L .30057 .43916 L .756 .292 .147 r
F
.38634 .52327 m .41084 .5304 L .38563 .5297 L .829 .702 .725 r
F
.38634 .52327 m .41141 .52401 L .41084 .5304 L F
.38637 .51048 m .41144 .51131 L .41161 .51765 L .83 .66 .671 r
F
.3857 .50413 m .41144 .51131 L .38637 .51048 L .829 .637 .642 r
F
.38658 .51686 m .41141 .52401 L .38634 .52327 L .83 .682 .699 r
F
.38658 .51686 m .41161 .51765 L .41141 .52401 L F
.38637 .51048 m .41161 .51765 L .38658 .51686 L .83 .66 .671 r
F
.29995 .59347 m .31886 .60038 L .2925 .59998 L .779 .912 .931 r
F
.29995 .59347 m .3254 .59393 L .31886 .60038 L F
.71873 .44758 m .7377 .45169 L .71338 .45356 L .375 .029 .245 r
F
.71873 .44758 m .74381 .44559 L .7377 .45169 L F
.78356 .61944 m .82043 .62571 L .79301 .62585 L .314 .619 .957 r
F
.35081 .4716 m .37555 .47299 L .37848 .47912 L .832 .514 .451 r
F
.34686 .46544 m .37555 .47299 L .35081 .4716 L .821 .482 .413 r
F
.72509 .594 m .75109 .59355 L .75839 .60006 L .417 .613 .93 r
F
.7192 .58753 m .75109 .59355 L .72509 .594 L .424 .601 .919 r
F
.35053 .56142 m .3719 .56852 L .34653 .56794 L .822 .833 .857 r
F
.35053 .56142 m .37531 .56204 L .3719 .56852 L F
.6723 .47932 m .69411 .4843 L .66989 .4855 L .493 .264 .494 r
F
.6723 .47932 m .69695 .47805 L .69411 .4843 L F
.67537 .56214 m .70057 .56153 L .70447 .56804 L .505 .571 .856 r
F
.67249 .55566 m .70057 .56153 L .67537 .56214 L .509 .554 .837 r
F
.51841 .17848 m .54811 .16509 L .51816 .16527 L .695 .503 .623 r
F
.48954 .17773 m .51816 .16527 L .48846 .16448 L .733 .533 .622 r
F
.48954 .17773 m .51841 .17848 L .51816 .16527 L F
.24227 .41233 m .26775 .41545 L .27678 .42128 L .67 .132 0 r
F
.23162 .40635 m .26775 .41545 L .24227 .41233 L .644 .096 0 r
F
.54755 .17831 m .57749 .16394 L .54811 .16509 L .655 .468 .62 r
F
.51841 .17848 m .54755 .17831 L .54811 .16509 L .695 .503 .623 r
F
.30738 .44523 m .33192 .44726 L .33741 .45326 L .795 .367 .233 r
F
.30057 .43916 m .33192 .44726 L .30738 .44523 L .776 .329 .19 r
F
.7738 .42175 m .78967 .42492 L .76549 .42762 L .224 0 0 r
F
.7738 .42175 m .79895 .41887 L .78967 .42492 L F
.35425 .47782 m .37848 .47912 L .38096 .48531 L .84 .545 .489 r
F
.35081 .4716 m .37848 .47912 L .35425 .47782 L .832 .514 .451 r
F
.66989 .4855 m .69178 .49059 L .66792 .49172 L .5 .293 .53 r
F
.66989 .4855 m .69411 .4843 L .69178 .49059 L F
.67249 .55566 m .69718 .55501 L .70057 .56153 L .509 .554 .837 r
F
.67005 .54919 m .69718 .55501 L .67249 .55566 L .512 .536 .817 r
F
.35401 .55489 m .37531 .56204 L .35053 .56142 L .831 .819 .838 r
F
.35401 .55489 m .37828 .55556 L .37531 .56204 L F
.71338 .45356 m .73215 .45784 L .70852 .4596 L .387 .062 .287 r
F
.71338 .45356 m .7377 .45169 L .73215 .45784 L F
.30683 .58693 m .3254 .59393 L .29995 .59347 L .793 .906 .92 r
F
.30683 .58693 m .33144 .58745 L .3254 .59393 L F
.7192 .58753 m .74435 .58703 L .75109 .59355 L .424 .601 .919 r
F
.71379 .58105 m .74435 .58703 L .7192 .58753 L .43 .588 .907 r
F
.24123 .61918 m .25717 .62583 L .23048 .62569 L .71 .947 .956 r
F
.24123 .61918 m .26682 .61941 L .25717 .62583 L F
.78356 .61944 m .80985 .61922 L .82043 .62571 L .314 .619 .957 r
F
.77463 .613 m .80985 .61922 L .78356 .61944 L .322 .611 .952 r
F
.46174 .17609 m .48846 .16448 L .45987 .16274 L .77 .561 .615 r
F
.46174 .17609 m .48954 .17773 L .48846 .16448 L F
.66792 .49172 m .68997 .49692 L .66639 .49799 L .505 .321 .565 r
F
.66792 .49172 m .69178 .49059 L .68997 .49692 L F
.67005 .54919 m .69429 .5485 L .69718 .55501 L .512 .536 .817 r
F
.66805 .54273 m .69429 .5485 L .67005 .54919 L .515 .517 .796 r
F
.35716 .48408 m .38096 .48531 L .38299 .49154 L .848 .575 .525 r
F
.35425 .47782 m .38096 .48531 L .35716 .48408 L .84 .545 .489 r
F
.35696 .54837 m .37828 .55556 L .35401 .55489 L .839 .805 .818 r
F
.35696 .54837 m .38079 .54908 L .37828 .55556 L F
.51867 .19132 m .54755 .17831 L .51841 .17848 L .695 .501 .62 r
F
.49062 .19061 m .51841 .17848 L .48954 .17773 L .733 .531 .619 r
F
.49062 .19061 m .51867 .19132 L .51841 .17848 L F
.54755 .17831 m .57611 .17722 L .57749 .16394 L .655 .468 .62 r
F
.54698 .19116 m .57611 .17722 L .54755 .17831 L .654 .466 .617 r
F
.51867 .19132 m .54698 .19116 L .54755 .17831 L .695 .501 .62 r
F
.31361 .45135 m .33741 .45326 L .34239 .45932 L .812 .404 .276 r
F
.30738 .44523 m .33741 .45326 L .31361 .45135 L .795 .367 .233 r
F
.66639 .49799 m .68869 .50328 L .66529 .50429 L .51 .349 .599 r
F
.66639 .49799 m .68997 .49692 L .68869 .50328 L F
.66805 .54273 m .69193 .54199 L .69429 .5485 L .515 .517 .796 r
F
.66648 .53627 m .69193 .54199 L .66805 .54273 L .517 .496 .772 r
F
.25232 .41835 m .27678 .42128 L .28526 .42718 L .696 .17 0 r
F
.24227 .41233 m .27678 .42128 L .25232 .41835 L .67 .132 0 r
F
.70852 .4596 m .72717 .46405 L .70416 .4657 L .399 .095 .33 r
F
.70852 .4596 m .73215 .45784 L .72717 .46405 L F
.57611 .17722 m .60546 .16186 L .57749 .16394 L .608 .427 .612 r
F
.76549 .42762 m .781 .43101 L .75772 .43355 L .238 0 .025 r
F
.76549 .42762 m .78967 .42492 L .781 .43101 L F
.31313 .58039 m .33144 .58745 L .30683 .58693 L .807 .899 .908 r
F
.31313 .58039 m .33698 .58096 L .33144 .58745 L F
.35954 .49038 m .38299 .49154 L .38457 .49782 L .853 .604 .561 r
F
.35716 .48408 m .38299 .49154 L .35954 .49038 L .848 .575 .525 r
F
.35939 .54186 m .38079 .54908 L .35696 .54837 L .846 .788 .796 r
F
.35939 .54186 m .38286 .54261 L .38079 .54908 L F
.71379 .58105 m .73817 .58049 L .74435 .58703 L .43 .588 .907 r
F
.70888 .57455 m .73817 .58049 L .71379 .58105 L .436 .573 .893 r
F
.66529 .50429 m .68792 .50967 L .66464 .51064 L .514 .376 .632 r
F
.66529 .50429 m .68869 .50328 L .68792 .50967 L F
.66648 .53627 m .69008 .5355 L .69193 .54199 L .517 .496 .772 r
F
.66536 .52983 m .69008 .5355 L .66648 .53627 L .518 .475 .747 r
F
.46361 .18906 m .48954 .17773 L .46174 .17609 L .77 .559 .613 r
F
.46361 .18906 m .49062 .19061 L .48954 .17773 L F
.66464 .51064 m .68768 .5161 L .66444 .51701 L .516 .403 .663 r
F
.66464 .51064 m .68792 .50967 L .68768 .5161 L F
.66536 .52983 m .68876 .52901 L .69008 .5355 L .518 .475 .747 r
F
.66468 .52341 m .68876 .52901 L .66536 .52983 L .518 .452 .721 r
F
.25138 .61265 m .26682 .61941 L .24123 .61918 L .727 .948 .951 r
F
.25138 .61265 m .27593 .61296 L .26682 .61941 L F
.36139 .49672 m .38457 .49782 L .3857 .50413 L .858 .632 .596 r
F
.35954 .49038 m .38457 .49782 L .36139 .49672 L .853 .604 .561 r
F
.77463 .613 m .79987 .61271 L .80985 .61922 L .322 .611 .952 r
F
.76624 .60654 m .79987 .61271 L .77463 .613 L .329 .602 .947 r
F
.36128 .53535 m .38286 .54261 L .35939 .54186 L .851 .771 .772 r
F
.36128 .53535 m .38448 .53615 L .38286 .54261 L F
.66444 .51701 m .68796 .52254 L .66468 .52341 L .518 .428 .693 r
F
.66444 .51701 m .68768 .5161 L .68796 .52254 L F
.66468 .52341 m .68796 .52254 L .68876 .52901 L .518 .452 .721 r
F
.51893 .20379 m .54698 .19116 L .51867 .19132 L .695 .498 .618 r
F
.4917 .20313 m .51867 .19132 L .49062 .19061 L .733 .529 .616 r
F
.4917 .20313 m .51893 .20379 L .51867 .19132 L F
.31927 .45752 m .34239 .45932 L .34686 .46544 L .829 .442 .319 r
F
.31361 .45135 m .34239 .45932 L .31927 .45752 L .812 .404 .276 r
F
.54698 .19116 m .57474 .19013 L .57611 .17722 L .654 .466 .617 r
F
.54641 .20364 m .57474 .19013 L .54698 .19116 L .654 .464 .614 r
F
.51893 .20379 m .54641 .20364 L .54698 .19116 L .695 .498 .618 r
F
.36271 .50309 m .3857 .50413 L .38637 .51048 L .86 .659 .629 r
F
.36139 .49672 m .3857 .50413 L .36271 .50309 L .858 .632 .596 r
F
.36263 .52886 m .38448 .53615 L .36128 .53535 L .856 .751 .747 r
F
.36263 .52886 m .38563 .5297 L .38448 .53615 L F
.70416 .4657 m .72276 .47029 L .7003 .47185 L .409 .129 .373 r
F
.70416 .4657 m .72717 .46405 L .72276 .47029 L F
.57611 .17722 m .60331 .17525 L .60546 .16186 L .608 .427 .612 r
F
.57474 .19013 m .60331 .17525 L .57611 .17722 L .608 .425 .609 r
F
.31885 .57383 m .33698 .58096 L .31313 .58039 L .82 .891 .894 r
F
.31885 .57383 m .34201 .57445 L .33698 .58096 L F
.70888 .57455 m .73256 .57394 L .73817 .58049 L .436 .573 .893 r
F
.70447 .56804 m .73256 .57394 L .70888 .57455 L .442 .558 .877 r
F
.36349 .5095 m .38637 .51048 L .38658 .51686 L .861 .684 .661 r
F
.36271 .50309 m .38637 .51048 L .36349 .5095 L .86 .659 .629 r
F
.36346 .52238 m .38563 .5297 L .36263 .52886 L .859 .73 .72 r
F
.36346 .52238 m .38634 .52327 L .38563 .5297 L F
.26175 .42443 m .28526 .42718 L .29319 .43314 L .721 .21 .006 r
F
.25232 .41835 m .28526 .42718 L .26175 .42443 L .696 .17 0 r
F
.36374 .51593 m .38658 .51686 L .38634 .52327 L .861 .708 .691 r
F
.36349 .5095 m .38658 .51686 L .36374 .51593 L .861 .684 .661 r
F
.36374 .51593 m .38634 .52327 L .36346 .52238 L .861 .708 .691 r
F
.75772 .43355 m .77294 .43716 L .75049 .43954 L .253 0 .069 r
F
.75772 .43355 m .781 .43101 L .77294 .43716 L F
.43582 .17358 m .45987 .16274 L .4332 .16009 L .809 .588 .603 r
F
.43582 .17358 m .46174 .17609 L .45987 .16274 L F
.46549 .20166 m .49062 .19061 L .46361 .18906 L .77 .557 .61 r
F
.46549 .20166 m .4917 .20313 L .49062 .19061 L F
.2609 .6061 m .27593 .61296 L .25138 .61265 L .745 .948 .946 r
F
.2609 .6061 m .2845 .60648 L .27593 .61296 L F
.76624 .60654 m .7905 .60617 L .79987 .61271 L .329 .602 .947 r
F
.75839 .60006 m .7905 .60617 L .76624 .60654 L .336 .592 .94 r
F
.51919 .21589 m .54641 .20364 L .51893 .20379 L .695 .496 .615 r
F
.49279 .21526 m .51893 .20379 L .4917 .20313 L .732 .527 .613 r
F
.49279 .21526 m .51919 .21589 L .51893 .20379 L F
.7003 .47185 m .71894 .47658 L .69695 .47805 L .419 .162 .415 r
F
.7003 .47185 m .72276 .47029 L .71894 .47658 L F
.32435 .46374 m .34686 .46544 L .35081 .4716 L .843 .479 .363 r
F
.31927 .45752 m .34686 .46544 L .32435 .46374 L .829 .442 .319 r
F
.70447 .56804 m .72753 .56739 L .73256 .57394 L .442 .558 .877 r
F
.70057 .56153 m .72753 .56739 L .70447 .56804 L .446 .541 .86 r
F
.54641 .20364 m .57335 .20267 L .57474 .19013 L .654 .464 .614 r
F
.54584 .21574 m .57335 .20267 L .54641 .20364 L .654 .461 .611 r
F
.51919 .21589 m .54584 .21574 L .54641 .20364 L .695 .496 .615 r
F
.32398 .56727 m .34201 .57445 L .31885 .57383 L .833 .881 .878 r
F
.32398 .56727 m .34653 .56794 L .34201 .57445 L F
.57474 .19013 m .60115 .18827 L .60331 .17525 L .608 .425 .609 r
F
.57335 .20267 m .60115 .18827 L .57474 .19013 L .608 .423 .606 r
F
.60331 .17525 m .63121 .15888 L .60546 .16186 L .552 .376 .596 r
F
.27057 .43056 m .29319 .43314 L .30057 .43916 L .747 .251 .05 r
F
.26175 .42443 m .29319 .43314 L .27057 .43056 L .721 .21 .006 r
F
.43844 .1867 m .46174 .17609 L .43582 .17358 L .808 .585 .6 r
F
.43844 .1867 m .46361 .18906 L .46174 .17609 L F
.75049 .43954 m .7655 .44335 L .74381 .44559 L .267 0 .114 r
F
.75049 .43954 m .77294 .43716 L .7655 .44335 L F
.69695 .47805 m .7157 .48291 L .69411 .4843 L .428 .195 .457 r
F
.69695 .47805 m .71894 .47658 L .7157 .48291 L F
.46738 .21388 m .4917 .20313 L .46549 .20166 L .77 .554 .607 r
F
.46738 .21388 m .49279 .21526 L .4917 .20313 L F
.32884 .47001 m .35081 .4716 L .35425 .47782 L .857 .516 .406 r
F
.32435 .46374 m .35081 .4716 L .32884 .47001 L .843 .479 .363 r
F
.70057 .56153 m .72307 .56082 L .72753 .56739 L .446 .541 .86 r
F
.69718 .55501 m .72307 .56082 L .70057 .56153 L .451 .522 .84 r
F
.32853 .5607 m .34653 .56794 L .32398 .56727 L .845 .87 .86 r
F
.32853 .5607 m .35053 .56142 L .34653 .56794 L F
.51946 .22761 m .54584 .21574 L .51919 .21589 L .694 .494 .612 r
F
.49388 .22703 m .51919 .21589 L .49279 .21526 L .732 .524 .61 r
F
.49388 .22703 m .51946 .22761 L .51919 .21589 L F
.75839 .60006 m .78175 .59961 L .7905 .60617 L .336 .592 .94 r
F
.75109 .59355 m .78175 .59961 L .75839 .60006 L .343 .581 .931 r
F
.2698 .59953 m .2845 .60648 L .2609 .6061 L .763 .947 .939 r
F
.2698 .59953 m .2925 .59998 L .2845 .60648 L F
.54584 .21574 m .57196 .21484 L .57335 .20267 L .654 .461 .611 r
F
.54526 .22748 m .57196 .21484 L .54584 .21574 L .653 .459 .608 r
F
.51946 .22761 m .54526 .22748 L .54584 .21574 L .694 .494 .612 r
F
.69411 .4843 m .71305 .48928 L .69178 .49059 L .436 .228 .498 r
F
.69411 .4843 m .7157 .48291 L .71305 .48928 L F
.57335 .20267 m .59898 .20092 L .60115 .18827 L .608 .423 .606 r
F
.57196 .21484 m .59898 .20092 L .57335 .20267 L .607 .42 .603 r
F
.69718 .55501 m .7192 .55426 L .72307 .56082 L .451 .522 .84 r
F
.69429 .5485 m .7192 .55426 L .69718 .55501 L .454 .502 .819 r
F
.33274 .47631 m .35425 .47782 L .35716 .48408 L .868 .551 .449 r
F
.32884 .47001 m .35425 .47782 L .33274 .47631 L .857 .516 .406 r
F
.60331 .17525 m .62832 .17244 L .63121 .15888 L .552 .376 .596 r
F
.60115 .18827 m .62832 .17244 L .60331 .17525 L .552 .373 .593 r
F
.44108 .19943 m .46361 .18906 L .43844 .1867 L .808 .583 .597 r
F
.44108 .19943 m .46549 .20166 L .46361 .18906 L F
.33247 .55413 m .35053 .56142 L .32853 .5607 L .856 .856 .841 r
F
.33247 .55413 m .35401 .55489 L .35053 .56142 L F
.27875 .43673 m .30057 .43916 L .30738 .44523 L .772 .292 .096 r
F
.27057 .43056 m .30057 .43916 L .27875 .43673 L .747 .251 .05 r
F
.74381 .44559 m .7587 .44959 L .7377 .45169 L .281 0 .16 r
F
.74381 .44559 m .7655 .44335 L .7587 .44959 L F
.81931 .40694 m .8306 .40949 L .80883 .41288 L .074 0 0 r
F
.81931 .40694 m .84207 .40333 L .8306 .40949 L F
.46928 .22573 m .49279 .21526 L .46738 .21388 L .769 .552 .603 r
F
.46928 .22573 m .49388 .22703 L .49279 .21526 L F
.69178 .49059 m .71099 .49567 L .68997 .49692 L .443 .26 .537 r
F
.69178 .49059 m .71305 .48928 L .71099 .49567 L F
.69429 .5485 m .71592 .5477 L .7192 .55426 L .454 .502 .819 r
F
.69193 .54199 m .71592 .5477 L .69429 .5485 L .457 .481 .796 r
F
.75109 .59355 m .77361 .59304 L .78175 .59961 L .343 .581 .931 r
F
.74435 .58703 m .77361 .59304 L .75109 .59355 L .349 .569 .921 r
F
.33604 .48266 m .35716 .48408 L .35954 .49038 L .877 .586 .491 r
F
.33274 .47631 m .35716 .48408 L .33604 .48266 L .868 .551 .449 r
F
.51972 .23896 m .54526 .22748 L .51946 .22761 L .694 .491 .608 r
F
.49498 .23841 m .51946 .22761 L .49388 .22703 L .732 .521 .607 r
F
.49498 .23841 m .51972 .23896 L .51946 .22761 L F
.27807 .59295 m .2925 .59998 L .2698 .59953 L .781 .945 .93 r
F
.27807 .59295 m .29995 .59347 L .2925 .59998 L F
.33582 .54756 m .35401 .55489 L .33247 .55413 L .866 .841 .819 r
F
.33582 .54756 m .35696 .54837 L .35401 .55489 L F
.68997 .49692 m .70952 .5021 L .68869 .50328 L .448 .292 .576 r
F
.68997 .49692 m .71099 .49567 L .70952 .5021 L F
.54526 .22748 m .57056 .22662 L .57196 .21484 L .653 .459 .608 r
F
.54469 .23884 m .57056 .22662 L .54526 .22748 L .653 .456 .605 r
F
.51972 .23896 m .54469 .23884 L .54526 .22748 L .694 .491 .608 r
F
.69193 .54199 m .71322 .54115 L .71592 .5477 L .457 .481 .796 r
F
.69008 .5355 m .71322 .54115 L .69193 .54199 L .459 .458 .77 r
F
.57196 .21484 m .5968 .21318 L .59898 .20092 L .607 .42 .603 r
F
.57056 .22662 m .5968 .21318 L .57196 .21484 L .606 .417 .599 r
F
.60115 .18827 m .62543 .18562 L .62832 .17244 L .552 .373 .593 r
F
.59898 .20092 m .62543 .18562 L .60115 .18827 L .551 .37 .59 r
F
.41256 .17028 m .4332 .16009 L .40926 .15659 L .85 .614 .581 r
F
.41256 .17028 m .43582 .17358 L .4332 .16009 L F
.68869 .50328 m .70865 .50856 L .68792 .50967 L .453 .323 .613 r
F
.68869 .50328 m .70952 .5021 L .70865 .50856 L F
.44373 .21178 m .46549 .20166 L .44108 .19943 L .808 .58 .593 r
F
.44373 .21178 m .46738 .21388 L .46549 .20166 L F
.33874 .48904 m .35954 .49038 L .36139 .49672 L .885 .62 .531 r
F
.33604 .48266 m .35954 .49038 L .33874 .48904 L .877 .586 .491 r
F
.69008 .5355 m .71112 .5346 L .71322 .54115 L .459 .458 .77 r
F
.68876 .52901 m .71112 .5346 L .69008 .5355 L .46 .434 .743 r
F
.7377 .45169 m .75252 .45586 L .73215 .45784 L .294 0 .208 r
F
.7377 .45169 m .7587 .44959 L .75252 .45586 L F
.28631 .44295 m .30738 .44523 L .31361 .45135 L .796 .335 .143 r
F
.27875 .43673 m .30738 .44523 L .28631 .44295 L .772 .292 .096 r
F
.33857 .54099 m .35696 .54837 L .33582 .54756 L .875 .825 .795 r
F
.33857 .54099 m .35939 .54186 L .35696 .54837 L F
.68792 .50967 m .70837 .51504 L .68768 .5161 L .456 .352 .648 r
F
.68792 .50967 m .70865 .50856 L .70837 .51504 L F
.68876 .52901 m .70961 .52807 L .71112 .5346 L .46 .434 .743 r
F
.68796 .52254 m .70961 .52807 L .68876 .52901 L .46 .408 .713 r
F
.47119 .23719 m .49388 .22703 L .46928 .22573 L .769 .549 .6 r
F
.47119 .23719 m .49498 .23841 L .49388 .22703 L F
.68768 .5161 m .70869 .52154 L .68796 .52254 L .458 .381 .682 r
F
.68768 .5161 m .70837 .51504 L .70869 .52154 L F
.68796 .52254 m .70869 .52154 L .70961 .52807 L .46 .408 .713 r
F
.80883 .41288 m .8198 .41569 L .79895 .41887 L .087 0 0 r
F
.80883 .41288 m .8306 .40949 L .8198 .41569 L F
.74435 .58703 m .7661 .58646 L .77361 .59304 L .349 .569 .921 r
F
.73817 .58049 m .7661 .58646 L .74435 .58703 L .355 .555 .909 r
F
.34084 .49545 m .36139 .49672 L .36271 .50309 L .89 .652 .571 r
F
.33874 .48904 m .36139 .49672 L .34084 .49545 L .885 .62 .531 r
F
.34072 .53444 m .35939 .54186 L .33857 .54099 L .882 .806 .769 r
F
.34072 .53444 m .36128 .53535 L .35939 .54186 L F
.2857 .58635 m .29995 .59347 L .27807 .59295 L .798 .941 .92 r
F
.2857 .58635 m .30683 .58693 L .29995 .59347 L F
.20968 .40269 m .23162 .40635 L .24227 .41233 L .592 .019 0 r
F
.51998 .24993 m .54469 .23884 L .51972 .23896 L .693 .488 .605 r
F
.49608 .24941 m .51972 .23896 L .49498 .23841 L .731 .518 .603 r
F
.49608 .24941 m .51998 .24993 L .51972 .23896 L F
.34234 .50189 m .36271 .50309 L .36349 .5095 L .894 .682 .609 r
F
.34084 .49545 m .36271 .50309 L .34234 .50189 L .89 .652 .571 r
F
.5183 .85864 m .54837 .87269 L .51804 .8726 L .698 .617 .763 r
F
.48908 .85901 m .51804 .8726 L .48797 .873 L .734 .648 .763 r
F
.48908 .85901 m .5183 .85864 L .51804 .8726 L F
.54469 .23884 m .56916 .23803 L .57056 .22662 L .653 .456 .605 r
F
.54411 .24981 m .56916 .23803 L .54469 .23884 L .652 .453 .601 r
F
.51998 .24993 m .54411 .24981 L .54469 .23884 L .693 .488 .605 r
F
.34226 .52789 m .36128 .53535 L .34072 .53444 L .888 .785 .741 r
F
.34226 .52789 m .36263 .52886 L .36128 .53535 L F
.57056 .22662 m .59461 .22507 L .5968 .21318 L .606 .417 .599 r
F
.56916 .23803 m .59461 .22507 L .57056 .22662 L .606 .414 .596 r
F
.41588 .18358 m .43582 .17358 L .41256 .17028 L .85 .611 .578 r
F
.41588 .18358 m .43844 .1867 L .43582 .17358 L F
.59898 .20092 m .62253 .19842 L .62543 .18562 L .551 .37 .59 r
F
.5968 .21318 m .62253 .19842 L .59898 .20092 L .55 .367 .586 r
F
.73215 .45784 m .74699 .46218 L .72717 .46405 L .307 0 .256 r
F
.73215 .45784 m .75252 .45586 L .74699 .46218 L F
.54779 .85872 m .57811 .87328 L .54837 .87269 L .658 .586 .763 r
F
.5183 .85864 m .54779 .85872 L .54837 .87269 L .698 .617 .763 r
F
.34323 .50836 m .36349 .5095 L .36374 .51593 L .895 .711 .645 r
F
.34234 .50189 m .36349 .5095 L .34323 .50836 L .894 .682 .609 r
F
.44638 .22375 m .46738 .21388 L .44373 .21178 L .808 .578 .59 r
F
.44638 .22375 m .46928 .22573 L .46738 .21388 L F
.34319 .52136 m .36263 .52886 L .34226 .52789 L .892 .762 .711 r
F
.34319 .52136 m .36346 .52238 L .36263 .52886 L F
.29322 .44921 m .31361 .45135 L .31927 .45752 L .819 .378 .191 r
F
.28631 .44295 m .31361 .45135 L .29322 .44921 L .796 .335 .143 r
F
.34351 .51485 m .36374 .51593 L .36346 .52238 L .895 .737 .679 r
F
.34323 .50836 m .36374 .51593 L .34351 .51485 L .895 .711 .645 r
F
.34351 .51485 m .36346 .52238 L .34319 .52136 L .895 .737 .679 r
F
.80985 .61922 m .8433 .62557 L .82043 .62571 L .222 .579 .943 r
F
.73817 .58049 m .75923 .57986 L .7661 .58646 L .355 .555 .909 r
F
.73256 .57394 m .75923 .57986 L .73817 .58049 L .361 .539 .895 r
F
.62832 .17244 m .65393 .15508 L .63121 .15888 L .478 .307 .57 r
F
.4731 .24827 m .49498 .23841 L .47119 .23719 L .769 .546 .596 r
F
.4731 .24827 m .49608 .24941 L .49498 .23841 L F
.29268 .57975 m .30683 .58693 L .2857 .58635 L .816 .936 .909 r
F
.29268 .57975 m .31313 .58039 L .30683 .58693 L F
.79895 .41887 m .80966 .42194 L .78967 .42492 L .1 0 0 r
F
.79895 .41887 m .8198 .41569 L .80966 .42194 L F
.51857 .84506 m .54779 .85872 L .5183 .85864 L .698 .619 .765 r
F
.49019 .8454 m .5183 .85864 L .48908 .85901 L .734 .65 .765 r
F
.49019 .8454 m .51857 .84506 L .5183 .85864 L F
.46094 .85982 m .48797 .873 L .45902 .87389 L .771 .68 .763 r
F
.46094 .85982 m .48908 .85901 L .48797 .873 L F
.52025 .26052 m .54411 .24981 L .51998 .24993 L .693 .485 .601 r
F
.49719 .26003 m .51998 .24993 L .49608 .24941 L .731 .515 .599 r
F
.49719 .26003 m .52025 .26052 L .51998 .24993 L F
.2213 .40889 m .24227 .41233 L .25232 .41835 L .622 .057 0 r
F
.20968 .40269 m .24227 .41233 L .2213 .40889 L .592 .019 0 r
F
.72717 .46405 m .7421 .46854 L .72276 .47029 L .319 .029 .304 r
F
.72717 .46405 m .74699 .46218 L .7421 .46854 L F
.54779 .85872 m .5767 .85926 L .57811 .87328 L .658 .586 .763 r
F
.5472 .84514 m .5767 .85926 L .54779 .85872 L .658 .588 .765 r
F
.51857 .84506 m .5472 .84514 L .54779 .85872 L .698 .619 .765 r
F
.4192 .19649 m .43844 .1867 L .41588 .18358 L .849 .609 .574 r
F
.4192 .19649 m .44108 .19943 L .43844 .1867 L F
.54411 .24981 m .56775 .24906 L .56916 .23803 L .652 .453 .601 r
F
.54353 .26041 m .56775 .24906 L .54411 .24981 L .652 .449 .597 r
F
.52025 .26052 m .54353 .26041 L .54411 .24981 L .693 .485 .601 r
F
.56916 .23803 m .59242 .23657 L .59461 .22507 L .606 .414 .596 r
F
.56775 .24906 m .59242 .23657 L .56916 .23803 L .605 .411 .592 r
F
.5968 .21318 m .61962 .21083 L .62253 .19842 L .55 .367 .586 r
F
.59461 .22507 m .61962 .21083 L .5968 .21318 L .549 .364 .582 r
F
.29949 .45551 m .31927 .45752 L .32435 .46374 L .841 .422 .24 r
F
.29322 .44921 m .31927 .45752 L .29949 .45551 L .819 .378 .191 r
F
.44905 .23533 m .46928 .22573 L .44638 .22375 L .807 .575 .586 r
F
.44905 .23533 m .47119 .23719 L .46928 .22573 L F
.73256 .57394 m .75299 .57326 L .75923 .57986 L .361 .539 .895 r
F
.72753 .56739 m .75299 .57326 L .73256 .57394 L .366 .522 .879 r
F
.62832 .17244 m .65039 .16885 L .65393 .15508 L .478 .307 .57 r
F
.62543 .18562 m .65039 .16885 L .62832 .17244 L .477 .303 .566 r
F
.29902 .57313 m .31313 .58039 L .29268 .57975 L .833 .929 .895 r
F
.29902 .57313 m .31885 .57383 L .31313 .58039 L F
.5767 .85926 m .60644 .87435 L .57811 .87328 L .614 .553 .763 r
F
.80985 .61922 m .83172 .61898 L .8433 .62557 L .222 .579 .943 r
F
.79987 .61271 m .83172 .61898 L .80985 .61922 L .228 .571 .94 r
F
.47502 .25896 m .49608 .24941 L .4731 .24827 L .768 .543 .592 r
F
.47502 .25896 m .49719 .26003 L .49608 .24941 L F
.51884 .83187 m .5472 .84514 L .51857 .84506 L .697 .621 .767 r
F
.4913 .83218 m .51857 .84506 L .49019 .8454 L .734 .651 .767 r
F
.4913 .83218 m .51884 .83187 L .51857 .84506 L F
.46287 .84614 m .48908 .85901 L .46094 .85982 L .771 .682 .765 r
F
.46287 .84614 m .49019 .8454 L .48908 .85901 L F
.72276 .47029 m .73785 .47493 L .71894 .47658 L .331 .066 .353 r
F
.72276 .47029 m .7421 .46854 L .73785 .47493 L F
.78967 .42492 m .8002 .42822 L .781 .43101 L .113 0 0 r
F
.78967 .42492 m .80966 .42194 L .8002 .42822 L F
.5472 .84514 m .57528 .84563 L .5767 .85926 L .658 .588 .765 r
F
.54662 .83195 m .57528 .84563 L .5472 .84514 L .658 .59 .767 r
F
.51884 .83187 m .54662 .83195 L .5472 .84514 L .697 .621 .767 r
F
.22017 .61894 m .23048 .62569 L .20844 .62554 L .684 .963 .939 r
F
.22017 .61894 m .24123 .61918 L .23048 .62569 L F
.30511 .46185 m .32435 .46374 L .32884 .47001 L .86 .465 .29 r
F
.29949 .45551 m .32435 .46374 L .30511 .46185 L .841 .422 .24 r
F
.72753 .56739 m .74739 .56665 L .75299 .57326 L .366 .522 .879 r
F
.72307 .56082 m .74739 .56665 L .72753 .56739 L .371 .503 .861 r
F
.42254 .20901 m .44108 .19943 L .4192 .19649 L .849 .606 .57 r
F
.42254 .20901 m .44373 .21178 L .44108 .19943 L F
.52052 .27073 m .54353 .26041 L .52025 .26052 L .692 .481 .597 r
F
.4983 .27027 m .52025 .26052 L .49719 .26003 L .731 .512 .595 r
F
.4983 .27027 m .52052 .27073 L .52025 .26052 L F
.23225 .41513 m .25232 .41835 L .26175 .42443 L .652 .097 0 r
F
.2213 .40889 m .25232 .41835 L .23225 .41513 L .622 .057 0 r
F
.59461 .22507 m .61669 .22285 L .61962 .21083 L .549 .364 .582 r
F
.59242 .23657 m .61669 .22285 L .59461 .22507 L .549 .36 .578 r
F
.56775 .24906 m .59021 .24768 L .59242 .23657 L .605 .411 .592 r
F
.56634 .2597 m .59021 .24768 L .56775 .24906 L .604 .407 .587 r
F
.54353 .26041 m .56634 .2597 L .56775 .24906 L .652 .449 .597 r
F
.54294 .27062 m .56634 .2597 L .54353 .26041 L .651 .446 .593 r
F
.52052 .27073 m .54294 .27062 L .54353 .26041 L .692 .481 .597 r
F
.45172 .24652 m .47119 .23719 L .44905 .23533 L .807 .571 .582 r
F
.45172 .24652 m .4731 .24827 L .47119 .23719 L F
.3047 .56651 m .31885 .57383 L .29902 .57313 L .849 .921 .879 r
F
.3047 .56651 m .32398 .56727 L .31885 .57383 L F
.5767 .85926 m .60422 .86024 L .60644 .87435 L .614 .553 .763 r
F
.57528 .84563 m .60422 .86024 L .5767 .85926 L .613 .555 .765 r
F
.71894 .47658 m .73426 .48135 L .7157 .48291 L .341 .104 .401 r
F
.71894 .47658 m .73785 .47493 L .73426 .48135 L F
.62543 .18562 m .64684 .18224 L .65039 .16885 L .477 .303 .566 r
F
.62253 .19842 m .64684 .18224 L .62543 .18562 L .476 .3 .562 r
F
.5191 .81908 m .54662 .83195 L .51884 .83187 L .697 .622 .769 r
F
.49242 .81935 m .51884 .83187 L .4913 .83218 L .734 .653 .769 r
F
.49242 .81935 m .5191 .81908 L .51884 .83187 L F
.4648 .83286 m .49019 .8454 L .46287 .84614 L .77 .683 .767 r
F
.4648 .83286 m .4913 .83218 L .49019 .8454 L F
.72307 .56082 m .74244 .56003 L .74739 .56665 L .371 .503 .861 r
F
.7192 .55426 m .74244 .56003 L .72307 .56082 L .375 .482 .841 r
F
.79987 .61271 m .82081 .61238 L .83172 .61898 L .228 .571 .94 r
F
.7905 .60617 m .82081 .61238 L .79987 .61271 L .234 .562 .936 r
F
.31008 .46822 m .32884 .47001 L .33274 .47631 L .878 .508 .34 r
F
.30511 .46185 m .32884 .47001 L .31008 .46822 L .86 .465 .29 r
F
.47694 .26926 m .49719 .26003 L .47502 .25896 L .768 .539 .587 r
F
.47694 .26926 m .4983 .27027 L .49719 .26003 L F
.54662 .83195 m .57386 .83239 L .57528 .84563 L .658 .59 .767 r
F
.54603 .81914 m .57386 .83239 L .54662 .83195 L .658 .592 .769 r
F
.5191 .81908 m .54603 .81914 L .54662 .83195 L .697 .622 .769 r
F
.781 .43101 m .79142 .43453 L .77294 .43716 L .127 0 0 r
F
.781 .43101 m .8002 .42822 L .79142 .43453 L F
.7157 .48291 m .73132 .4878 L .71305 .48928 L .351 .141 .449 r
F
.7157 .48291 m .73426 .48135 L .73132 .4878 L F
.42589 .22115 m .44373 .21178 L .42254 .20901 L .849 .602 .566 r
F
.42589 .22115 m .44638 .22375 L .44373 .21178 L F
.4347 .86106 m .45902 .87389 L .43201 .87525 L .808 .715 .762 r
F
.4347 .86106 m .46094 .85982 L .45902 .87389 L F
.30973 .55989 m .32398 .56727 L .3047 .56651 L .865 .911 .861 r
F
.30973 .55989 m .32853 .5607 L .32398 .56727 L F
.23122 .61232 m .24123 .61918 L .22017 .61894 L .705 .967 .937 r
F
.23122 .61232 m .25138 .61265 L .24123 .61918 L F
.52078 .28054 m .54294 .27062 L .52052 .27073 L .692 .478 .592 r
F
.49941 .28012 m .52052 .27073 L .4983 .27027 L .73 .508 .59 r
F
.49941 .28012 m .52078 .28054 L .52052 .27073 L F
.59242 .23657 m .61376 .23448 L .61669 .22285 L .549 .36 .578 r
F
.59021 .24768 m .61376 .23448 L .59242 .23657 L .548 .357 .574 r
F
.7192 .55426 m .73814 .55342 L .74244 .56003 L .375 .482 .841 r
F
.71592 .5477 m .73814 .55342 L .7192 .55426 L .378 .46 .818 r
F
.24251 .42141 m .26175 .42443 L .27057 .43056 L .683 .14 0 r
F
.23225 .41513 m .26175 .42443 L .24251 .42141 L .652 .097 0 r
F
.57528 .84563 m .602 .84652 L .60422 .86024 L .613 .555 .765 r
F
.57386 .83239 m .602 .84652 L .57528 .84563 L .613 .556 .767 r
F
.39272 .16625 m .40926 .15659 L .38881 .15232 L .895 .639 .543 r
F
.39272 .16625 m .41256 .17028 L .40926 .15659 L F
.56634 .2597 m .588 .25841 L .59021 .24768 L .604 .407 .587 r
F
.56492 .26996 m .588 .25841 L .56634 .2597 L .604 .403 .583 r
F
.54294 .27062 m .56492 .26996 L .56634 .2597 L .651 .446 .593 r
F
.54236 .28044 m .56492 .26996 L .54294 .27062 L .65 .442 .588 r
F
.52078 .28054 m .54236 .28044 L .54294 .27062 L .692 .478 .592 r
F
.45441 .25732 m .4731 .24827 L .45172 .24652 L .807 .568 .577 r
F
.45441 .25732 m .47502 .25896 L .4731 .24827 L F
.62253 .19842 m .64328 .19523 L .64684 .18224 L .476 .3 .562 r
F
.61962 .21083 m .64328 .19523 L .62253 .19842 L .475 .296 .558 r
F
.31439 .47463 m .33274 .47631 L .33604 .48266 L .894 .551 .389 r
F
.31008 .46822 m .33274 .47631 L .31439 .47463 L .878 .508 .34 r
F
.46674 .81997 m .4913 .83218 L .4648 .83286 L .77 .685 .769 r
F
.46674 .81997 m .49242 .81935 L .4913 .83218 L F
.71305 .48928 m .72903 .49428 L .71099 .49567 L .359 .178 .495 r
F
.71305 .48928 m .73132 .4878 L .72903 .49428 L F
.51937 .80667 m .54603 .81914 L .5191 .81908 L .697 .624 .772 r
F
.49354 .80692 m .5191 .81908 L .49242 .81935 L .734 .655 .772 r
F
.49354 .80692 m .51937 .80667 L .5191 .81908 L F
.3141 .55327 m .32853 .5607 L .30973 .55989 L .879 .898 .84 r
F
.3141 .55327 m .33247 .55413 L .32853 .5607 L F
.71592 .5477 m .73449 .5468 L .73814 .55342 L .378 .46 .818 r
F
.71322 .54115 m .73449 .5468 L .71592 .5477 L .381 .435 .792 r
F
.54603 .81914 m .57243 .81954 L .57386 .83239 L .658 .592 .769 r
F
.54544 .80673 m .57243 .81954 L .54603 .81914 L .657 .593 .772 r
F
.51937 .80667 m .54544 .80673 L .54603 .81914 L .697 .624 .772 r
F
.7905 .60617 m .81057 .60576 L .82081 .61238 L .234 .562 .936 r
F
.78175 .59961 m .81057 .60576 L .7905 .60617 L .24 .551 .93 r
F
.4374 .84727 m .46094 .85982 L .4347 .86106 L .808 .717 .764 r
F
.4374 .84727 m .46287 .84614 L .46094 .85982 L F
.71099 .49567 m .7274 .50078 L .70952 .5021 L .366 .215 .54 r
F
.71099 .49567 m .72903 .49428 L .7274 .50078 L F
.47888 .27917 m .4983 .27027 L .47694 .26926 L .767 .535 .582 r
F
.47888 .27917 m .49941 .28012 L .4983 .27027 L F
.77294 .43716 m .78332 .44089 L .7655 .44335 L .14 0 0 r
F
.77294 .43716 m .79142 .43453 L .78332 .44089 L F
.31804 .48107 m .33604 .48266 L .33874 .48904 L .907 .592 .438 r
F
.31439 .47463 m .33604 .48266 L .31804 .48107 L .894 .551 .389 r
F
.42925 .23288 m .44638 .22375 L .42589 .22115 L .848 .599 .562 r
F
.42925 .23288 m .44905 .23533 L .44638 .22375 L F
.71322 .54115 m .7315 .5402 L .73449 .5468 L .381 .435 .792 r
F
.71112 .5346 m .7315 .5402 L .71322 .54115 L .382 .409 .764 r
F
.24159 .60568 m .25138 .61265 L .23122 .61232 L .726 .97 .933 r
F
.24159 .60568 m .2609 .6061 L .25138 .61265 L F
.57386 .83239 m .59977 .8332 L .602 .84652 L .613 .556 .767 r
F
.57243 .81954 m .59977 .8332 L .57386 .83239 L .613 .558 .769 r
F
.60422 .86024 m .63252 .87587 L .60644 .87435 L .56 .515 .762 r
F
.39664 .17978 m .41256 .17028 L .39272 .16625 L .894 .636 .539 r
F
.39664 .17978 m .41588 .18358 L .41256 .17028 L F
.3178 .54664 m .33247 .55413 L .3141 .55327 L .892 .883 .817 r
F
.3178 .54664 m .33582 .54756 L .33247 .55413 L F
.70952 .5021 m .72643 .50731 L .70865 .50856 L .372 .251 .583 r
F
.70952 .5021 m .7274 .50078 L .72643 .50731 L F
.59021 .24768 m .61082 .24573 L .61376 .23448 L .548 .357 .574 r
F
.588 .25841 m .61082 .24573 L .59021 .24768 L .547 .353 .569 r
F
.2521 .42772 m .27057 .43056 L .27875 .43673 L .715 .184 0 r
F
.24251 .42141 m .27057 .43056 L .2521 .42772 L .683 .14 0 r
F
.71112 .5346 m .72917 .53359 L .7315 .5402 L .382 .409 .764 r
F
.70961 .52807 m .72917 .53359 L .71112 .5346 L .382 .381 .733 r
F
.61962 .21083 m .6397 .20782 L .64328 .19523 L .475 .296 .558 r
F
.61669 .22285 m .6397 .20782 L .61962 .21083 L .474 .292 .553 r
F
.52105 .28997 m .54236 .28044 L .52078 .28054 L .691 .473 .587 r
F
.50053 .28957 m .52078 .28054 L .49941 .28012 L .729 .504 .585 r
F
.50053 .28957 m .52105 .28997 L .52078 .28054 L F
.46868 .80747 m .49242 .81935 L .46674 .81997 L .77 .687 .772 r
F
.46868 .80747 m .49354 .80692 L .49242 .81935 L F
.70865 .50856 m .72613 .51386 L .70837 .51504 L .376 .286 .624 r
F
.70865 .50856 m .72643 .50731 L .72613 .51386 L F
.56492 .26996 m .58578 .26875 L .588 .25841 L .604 .403 .583 r
F
.56349 .27982 m .58578 .26875 L .56492 .26996 L .603 .399 .578 r
F
.54236 .28044 m .56349 .27982 L .56492 .26996 L .65 .442 .588 r
F
.51964 .79466 m .54544 .80673 L .51937 .80667 L .697 .626 .774 r
F
.49466 .79488 m .51937 .80667 L .49354 .80692 L .733 .657 .774 r
F
.49466 .79488 m .51964 .79466 L .51937 .80667 L F
.4571 .26773 m .47502 .25896 L .45441 .25732 L .806 .564 .572 r
F
.4571 .26773 m .47694 .26926 L .47502 .25896 L F
.32103 .48753 m .33874 .48904 L .34084 .49545 L .917 .632 .486 r
F
.31804 .48107 m .33874 .48904 L .32103 .48753 L .907 .592 .438 r
F
.70961 .52807 m .72749 .527 L .72917 .53359 L .382 .381 .733 r
F
.70869 .52154 m .72749 .527 L .70961 .52807 L .382 .351 .7 r
F
.54177 .28988 m .56349 .27982 L .54236 .28044 L .649 .438 .583 r
F
.52105 .28997 m .54177 .28988 L .54236 .28044 L .691 .473 .587 r
F
.70837 .51504 m .72648 .52042 L .70869 .52154 L .38 .319 .663 r
F
.70837 .51504 m .72613 .51386 L .72648 .52042 L F
.70869 .52154 m .72648 .52042 L .72749 .527 L .382 .351 .7 r
F
.54544 .80673 m .571 .80709 L .57243 .81954 L .657 .593 .772 r
F
.54485 .79471 m .571 .80709 L .54544 .80673 L .657 .595 .774 r
F
.51964 .79466 m .54485 .79471 L .54544 .80673 L .697 .626 .774 r
F
.32084 .54003 m .33582 .54756 L .3178 .54664 L .904 .866 .791 r
F
.32084 .54003 m .33857 .54099 L .33582 .54756 L F
.44011 .83388 m .46287 .84614 L .4374 .84727 L .808 .719 .767 r
F
.44011 .83388 m .4648 .83286 L .46287 .84614 L F
.78175 .59961 m .80102 .59913 L .81057 .60576 L .24 .551 .93 r
F
.77361 .59304 m .80102 .59913 L .78175 .59961 L .246 .539 .923 r
F
.32335 .49403 m .34084 .49545 L .34234 .50189 L .925 .67 .532 r
F
.32103 .48753 m .34084 .49545 L .32335 .49403 L .917 .632 .486 r
F
.7655 .44335 m .77591 .44727 L .7587 .44959 L .154 0 .041 r
F
.7655 .44335 m .78332 .44089 L .77591 .44727 L F
.60422 .86024 m .62955 .86163 L .63252 .87587 L .56 .515 .762 r
F
.602 .84652 m .62955 .86163 L .60422 .86024 L .56 .516 .764 r
F
.32321 .53341 m .33857 .54099 L .32084 .54003 L .914 .846 .762 r
F
.32321 .53341 m .34072 .53444 L .33857 .54099 L F
.57243 .81954 m .59754 .82028 L .59977 .8332 L .613 .558 .769 r
F
.571 .80709 m .59754 .82028 L .57243 .81954 L .612 .56 .772 r
F
.43262 .24422 m .44905 .23533 L .42925 .23288 L .848 .595 .557 r
F
.43262 .24422 m .45172 .24652 L .44905 .23533 L F
.48082 .28869 m .49941 .28012 L .47888 .27917 L .767 .531 .577 r
F
.48082 .28869 m .50053 .28957 L .49941 .28012 L F
.40057 .19291 m .41588 .18358 L .39664 .17978 L .894 .632 .535 r
F
.40057 .19291 m .4192 .19649 L .41588 .18358 L F
.25127 .59904 m .2609 .6061 L .24159 .60568 L .747 .972 .927 r
F
.25127 .59904 m .2698 .59953 L .2609 .6061 L F
.65039 .16885 m .67289 .15056 L .65393 .15508 L .373 .206 .523 r
F
.325 .50055 m .34234 .50189 L .34323 .50836 L .93 .706 .577 r
F
.32335 .49403 m .34234 .50189 L .325 .50055 L .925 .67 .532 r
F
.26099 .43407 m .27875 .43673 L .28631 .44295 L .746 .23 0 r
F
.2521 .42772 m .27875 .43673 L .26099 .43407 L .715 .184 0 r
F
.32491 .52681 m .34072 .53444 L .32321 .53341 L .922 .823 .731 r
F
.32491 .52681 m .34226 .52789 L .34072 .53444 L F
.47063 .79538 m .49354 .80692 L .46868 .80747 L .77 .689 .774 r
F
.47063 .79538 m .49466 .79488 L .49354 .80692 L F
.61669 .22285 m .63612 .22003 L .6397 .20782 L .474 .292 .553 r
F
.61376 .23448 m .63612 .22003 L .61669 .22285 L .473 .288 .549 r
F
.588 .25841 m .60786 .25658 L .61082 .24573 L .547 .353 .569 r
F
.58578 .26875 m .60786 .25658 L .588 .25841 L .546 .348 .564 r
F
.32599 .50709 m .34323 .50836 L .34351 .51485 L .932 .739 .619 r
F
.325 .50055 m .34323 .50836 L .32599 .50709 L .93 .706 .577 r
F
.51991 .78304 m .54485 .79471 L .51964 .79466 L .696 .629 .777 r
F
.49578 .78324 m .51964 .79466 L .49466 .79488 L .733 .659 .777 r
F
.49578 .78324 m .51991 .78304 L .51964 .79466 L F
.32594 .52022 m .34226 .52789 L .32491 .52681 L .928 .798 .696 r
F
.32594 .52022 m .34319 .52136 L .34226 .52789 L F
.3263 .51365 m .34351 .51485 L .34319 .52136 L .931 .77 .659 r
F
.32599 .50709 m .34351 .51485 L .3263 .51365 L .932 .739 .619 r
F
.3263 .51365 m .34319 .52136 L .32594 .52022 L .931 .77 .659 r
F
.44282 .8209 m .4648 .83286 L .44011 .83388 L .807 .721 .769 r
F
.44282 .8209 m .46674 .81997 L .4648 .83286 L F
.52132 .29901 m .54177 .28988 L .52105 .28997 L .69 .469 .582 r
F
.50166 .29863 m .52105 .28997 L .50053 .28957 L .729 .499 .58 r
F
.50166 .29863 m .52132 .29901 L .52105 .28997 L F
.45981 .27774 m .47694 .26926 L .4571 .26773 L .805 .56 .567 r
F
.45981 .27774 m .47888 .27917 L .47694 .26926 L F
.56349 .27982 m .58355 .27869 L .58578 .26875 L .603 .399 .578 r
F
.56206 .2893 m .58355 .27869 L .56349 .27982 L .602 .394 .572 r
F
.54177 .28988 m .56206 .2893 L .56349 .27982 L .649 .438 .583 r
F
.54485 .79471 m .56957 .79504 L .571 .80709 L .657 .595 .774 r
F
.54426 .78308 m .56957 .79504 L .54485 .79471 L .657 .598 .777 r
F
.51991 .78304 m .54426 .78308 L .54485 .79471 L .696 .629 .777 r
F
.77361 .59304 m .79215 .59248 L .80102 .59913 L .246 .539 .923 r
F
.7661 .58646 m .79215 .59248 L .77361 .59304 L .251 .525 .914 r
F
.54118 .29892 m .56206 .2893 L .54177 .28988 L .649 .433 .577 r
F
.52132 .29901 m .54118 .29892 L .54177 .28988 L .69 .469 .582 r
F
.602 .84652 m .62658 .84779 L .62955 .86163 L .56 .516 .764 r
F
.59977 .8332 m .62658 .84779 L .602 .84652 L .559 .518 .766 r
F
.7587 .44959 m .7692 .45369 L .75252 .45586 L .168 0 .094 r
F
.7587 .44959 m .77591 .44727 L .7692 .45369 L F
.571 .80709 m .5953 .80775 L .59754 .82028 L .612 .56 .772 r
F
.56957 .79504 m .5953 .80775 L .571 .80709 L .612 .562 .774 r
F
.40451 .20564 m .4192 .19649 L .40057 .19291 L .894 .629 .53 r
F
.40451 .20564 m .42254 .20901 L .4192 .19649 L F
.65039 .16885 m .66878 .16458 L .67289 .15056 L .373 .206 .523 r
F
.64684 .18224 m .66878 .16458 L .65039 .16885 L .371 .202 .518 r
F
.26025 .59238 m .2698 .59953 L .25127 .59904 L .769 .973 .921 r
F
.26025 .59238 m .27807 .59295 L .2698 .59953 L F
.436 .25517 m .45172 .24652 L .43262 .24422 L .847 .591 .552 r
F
.436 .25517 m .45441 .25732 L .45172 .24652 L F
.26919 .44045 m .28631 .44295 L .29322 .44921 L .777 .279 .017 r
F
.26099 .43407 m .28631 .44295 L .26919 .44045 L .746 .23 0 r
F
.48277 .29781 m .50053 .28957 L .48082 .28869 L .766 .526 .571 r
F
.48277 .29781 m .50166 .29863 L .50053 .28957 L F
.47258 .78368 m .49466 .79488 L .47063 .79538 L .769 .692 .777 r
F
.47258 .78368 m .49578 .78324 L .49466 .79488 L F
.61376 .23448 m .63252 .23183 L .63612 .22003 L .473 .288 .549 r
F
.61082 .24573 m .63252 .23183 L .61376 .23448 L .472 .284 .544 r
F
.52018 .77181 m .54426 .78308 L .51991 .78304 L .696 .631 .78 r
F
.49691 .77199 m .51991 .78304 L .49578 .78324 L .733 .662 .78 r
F
.49691 .77199 m .52018 .77181 L .51991 .78304 L F
.44554 .80831 m .46674 .81997 L .44282 .8209 L .807 .723 .772 r
F
.44554 .80831 m .46868 .80747 L .46674 .81997 L F
.41115 .8627 m .43201 .87525 L .40775 .87704 L .848 .755 .76 r
F
.41115 .8627 m .4347 .86106 L .43201 .87525 L F
.58578 .26875 m .6049 .26703 L .60786 .25658 L .546 .348 .564 r
F
.58355 .27869 m .6049 .26703 L .58578 .26875 L .545 .343 .558 r
F
.7661 .58646 m .78397 .58583 L .79215 .59248 L .251 .525 .914 r
F
.75923 .57986 m .78397 .58583 L .7661 .58646 L .256 .51 .903 r
F
.54426 .78308 m .56813 .78338 L .56957 .79504 L .657 .598 .777 r
F
.54367 .77186 m .56813 .78338 L .54426 .78308 L .656 .6 .78 r
F
.52018 .77181 m .54367 .77186 L .54426 .78308 L .696 .631 .78 r
F
.59977 .8332 m .62359 .83435 L .62658 .84779 L .559 .518 .766 r
F
.59754 .82028 m .62359 .83435 L .59977 .8332 L .559 .52 .769 r
F
.75252 .45586 m .76319 .46013 L .74699 .46218 L .182 0 .147 r
F
.75252 .45586 m .7692 .45369 L .76319 .46013 L F
.46252 .28735 m .47888 .27917 L .45981 .27774 L .805 .555 .561 r
F
.46252 .28735 m .48082 .28869 L .47888 .27917 L F
.56206 .2893 m .58131 .28824 L .58355 .27869 L .602 .394 .572 r
F
.56062 .29838 m .58131 .28824 L .56206 .2893 L .601 .389 .566 r
F
.54118 .29892 m .56062 .29838 L .56206 .2893 L .649 .433 .577 r
F
.5216 .30765 m .54118 .29892 L .52132 .29901 L .689 .464 .576 r
F
.50279 .3073 m .52132 .29901 L .50166 .29863 L .728 .495 .574 r
F
.50279 .3073 m .5216 .30765 L .52132 .29901 L F
.56957 .79504 m .59306 .79563 L .5953 .80775 L .612 .562 .774 r
F
.56813 .78338 m .59306 .79563 L .56957 .79504 L .612 .565 .777 r
F
.64684 .18224 m .66466 .17821 L .66878 .16458 L .371 .202 .518 r
F
.64328 .19523 m .66466 .17821 L .64684 .18224 L .37 .198 .513 r
F
.40846 .21798 m .42254 .20901 L .40451 .20564 L .893 .625 .525 r
F
.40846 .21798 m .42589 .22115 L .42254 .20901 L F
.54058 .30757 m .56062 .29838 L .54118 .29892 L .648 .428 .571 r
F
.5216 .30765 m .54058 .30757 L .54118 .29892 L .689 .464 .576 r
F
.26853 .58572 m .27807 .59295 L .26025 .59238 L .791 .973 .912 r
F
.26853 .58572 m .2857 .58635 L .27807 .59295 L F
.27669 .44686 m .29322 .44921 L .29949 .45551 L .807 .328 .07 r
F
.26919 .44045 m .29322 .44921 L .27669 .44686 L .777 .279 .017 r
F
.43939 .26571 m .45441 .25732 L .436 .25517 L .847 .587 .546 r
F
.43939 .26571 m .4571 .26773 L .45441 .25732 L F
.41456 .84877 m .4347 .86106 L .41115 .8627 L .848 .757 .762 r
F
.41456 .84877 m .4374 .84727 L .4347 .86106 L F
.75923 .57986 m .77649 .57917 L .78397 .58583 L .256 .51 .903 r
F
.75299 .57326 m .77649 .57917 L .75923 .57986 L .261 .492 .89 r
F
.47454 .77239 m .49578 .78324 L .47258 .78368 L .769 .694 .78 r
F
.47454 .77239 m .49691 .77199 L .49578 .78324 L F
.44827 .79613 m .46868 .80747 L .44554 .80831 L .807 .725 .774 r
F
.44827 .79613 m .47063 .79538 L .46868 .80747 L F
.61082 .24573 m .62891 .24324 L .63252 .23183 L .472 .284 .544 r
F
.60786 .25658 m .62891 .24324 L .61082 .24573 L .471 .279 .538 r
F
.52046 .76099 m .54367 .77186 L .52018 .77181 L .696 .633 .783 r
F
.49804 .76115 m .52018 .77181 L .49691 .77199 L .732 .664 .783 r
F
.49804 .76115 m .52046 .76099 L .52018 .77181 L F
.74699 .46218 m .75787 .46661 L .7421 .46854 L .195 0 .203 r
F
.74699 .46218 m .76319 .46013 L .75787 .46661 L F
.59754 .82028 m .62061 .82132 L .62359 .83435 L .559 .52 .769 r
F
.5953 .80775 m .62061 .82132 L .59754 .82028 L .558 .522 .771 r
F
.84207 .40333 m .84739 .40583 L .8306 .40949 L 0 0 0 r
F
.84207 .40333 m .85969 .39942 L .84739 .40583 L F
.48473 .30653 m .50166 .29863 L .48277 .29781 L .765 .521 .565 r
F
.48473 .30653 m .50279 .3073 L .50166 .29863 L F
.58355 .27869 m .60192 .27708 L .6049 .26703 L .545 .343 .558 r
F
.58131 .28824 m .60192 .27708 L .58355 .27869 L .543 .338 .552 r
F
.54367 .77186 m .56669 .77212 L .56813 .78338 L .656 .6 .78 r
F
.54308 .76103 m .56669 .77212 L .54367 .77186 L .656 .602 .783 r
F
.52046 .76099 m .54308 .76103 L .54367 .77186 L .696 .633 .783 r
F
.2761 .57905 m .2857 .58635 L .26853 .58572 L .813 .971 .901 r
F
.2761 .57905 m .29268 .57975 L .2857 .58635 L F
.64328 .19523 m .66052 .19143 L .66466 .17821 L .37 .198 .513 r
F
.6397 .20782 m .66052 .19143 L .64328 .19523 L .368 .193 .508 r
F
.56813 .78338 m .5908 .78391 L .59306 .79563 L .612 .565 .777 r
F
.56669 .77212 m .5908 .78391 L .56813 .78338 L .611 .567 .78 r
F
.46524 .29656 m .48082 .28869 L .46252 .28735 L .804 .55 .555 r
F
.46524 .29656 m .48277 .29781 L .48082 .28869 L F
.41243 .22991 m .42589 .22115 L .40846 .21798 L .893 .621 .52 r
F
.41243 .22991 m .42925 .23288 L .42589 .22115 L F
.28348 .4533 m .29949 .45551 L .30511 .46185 L .836 .38 .125 r
F
.27669 .44686 m .29949 .45551 L .28348 .4533 L .807 .328 .07 r
F
.75299 .57326 m .76971 .5725 L .77649 .57917 L .261 .492 .89 r
F
.74739 .56665 m .76971 .5725 L .75299 .57326 L .265 .473 .875 r
F
.56062 .29838 m .57907 .29739 L .58131 .28824 L .601 .389 .566 r
F
.55918 .30706 m .57907 .29739 L .56062 .29838 L .599 .384 .56 r
F
.54058 .30757 m .55918 .30706 L .56062 .29838 L .648 .428 .571 r
F
.41798 .83524 m .4374 .84727 L .41456 .84877 L .848 .759 .765 r
F
.41798 .83524 m .44011 .83388 L .4374 .84727 L F
.52187 .31589 m .54058 .30757 L .5216 .30765 L .688 .459 .569 r
F
.50392 .31557 m .5216 .30765 L .50279 .3073 L .727 .489 .567 r
F
.50392 .31557 m .52187 .31589 L .5216 .30765 L F
.62955 .86163 m .65555 .87782 L .63252 .87587 L .49 .466 .758 r
F
.7421 .46854 m .75326 .47311 L .73785 .47493 L .208 0 .259 r
F
.7421 .46854 m .75787 .46661 L .75326 .47311 L F
.44279 .27585 m .4571 .26773 L .43939 .26571 L .846 .582 .54 r
F
.44279 .27585 m .45981 .27774 L .4571 .26773 L F
.53999 .31582 m .55918 .30706 L .54058 .30757 L .646 .422 .564 r
F
.52187 .31589 m .53999 .31582 L .54058 .30757 L .688 .459 .569 r
F
.451 .78436 m .47063 .79538 L .44827 .79613 L .806 .727 .777 r
F
.451 .78436 m .47258 .78368 L .47063 .79538 L F
.4765 .7615 m .49691 .77199 L .47454 .77239 L .769 .697 .783 r
F
.4765 .7615 m .49804 .76115 L .49691 .77199 L F
.5953 .80775 m .61761 .8087 L .62061 .82132 L .558 .522 .771 r
F
.59306 .79563 m .61761 .8087 L .5953 .80775 L .558 .525 .774 r
F
.60786 .25658 m .62529 .25424 L .62891 .24324 L .471 .279 .538 r
F
.6049 .26703 m .62529 .25424 L .60786 .25658 L .469 .274 .532 r
F
.52073 .75056 m .54308 .76103 L .52046 .76099 L .695 .636 .786 r
F
.49918 .7507 m .52046 .76099 L .49804 .76115 L .732 .667 .786 r
F
.49918 .7507 m .52073 .75056 L .52046 .76099 L F
.8306 .40949 m .83581 .41226 L .8198 .41569 L 0 0 0 r
F
.8306 .40949 m .84739 .40583 L .83581 .41226 L F
.28297 .57237 m .29268 .57975 L .2761 .57905 L .834 .968 .888 r
F
.28297 .57237 m .29902 .57313 L .29268 .57975 L F
.74739 .56665 m .76362 .56583 L .76971 .5725 L .265 .473 .875 r
F
.74244 .56003 m .76362 .56583 L .74739 .56665 L .269 .451 .856 r
F
.54308 .76103 m .56524 .76126 L .56669 .77212 L .656 .602 .783 r
F
.54248 .7506 m .56524 .76126 L .54308 .76103 L .655 .605 .786 r
F
.52073 .75056 m .54248 .7506 L .54308 .76103 L .695 .636 .786 r
F
.28957 .45977 m .30511 .46185 L .31008 .46822 L .864 .431 .181 r
F
.28348 .4533 m .30511 .46185 L .28957 .45977 L .836 .38 .125 r
F
.58131 .28824 m .59894 .28674 L .60192 .27708 L .543 .338 .552 r
F
.57907 .29739 m .59894 .28674 L .58131 .28824 L .542 .333 .546 r
F
.6397 .20782 m .65638 .20425 L .66052 .19143 L .368 .193 .508 r
F
.63612 .22003 m .65638 .20425 L .6397 .20782 L .366 .188 .502 r
F
.48669 .31486 m .50279 .3073 L .48473 .30653 L .764 .515 .558 r
F
.48669 .31486 m .50392 .31557 L .50279 .3073 L F
.37699 .1616 m .38881 .15232 L .37258 .1474 L .941 .658 .474 r
F
.37699 .1616 m .39272 .16625 L .38881 .15232 L F
.73785 .47493 m .74936 .47963 L .73426 .48135 L .22 0 .316 r
F
.73785 .47493 m .75326 .47311 L .74936 .47963 L F
.62955 .86163 m .6519 .86341 L .65555 .87782 L .49 .466 .758 r
F
.62658 .84779 m .6519 .86341 L .62955 .86163 L .49 .468 .761 r
F
.4214 .82213 m .44011 .83388 L .41798 .83524 L .847 .761 .767 r
F
.4214 .82213 m .44282 .8209 L .44011 .83388 L F
.56669 .77212 m .58855 .77259 L .5908 .78391 L .611 .567 .78 r
F
.56524 .76126 m .58855 .77259 L .56669 .77212 L .611 .57 .783 r
F
.4164 .24143 m .42925 .23288 L .41243 .22991 L .892 .617 .514 r
F
.4164 .24143 m .43262 .24422 L .42925 .23288 L F
.46798 .30537 m .48277 .29781 L .46524 .29656 L .803 .545 .548 r
F
.46798 .30537 m .48473 .30653 L .48277 .29781 L F
.74244 .56003 m .75825 .55916 L .76362 .56583 L .269 .451 .856 r
F
.73814 .55342 m .75825 .55916 L .74244 .56003 L .272 .427 .835 r
F
.45374 .77299 m .47258 .78368 L .451 .78436 L .806 .73 .78 r
F
.45374 .77299 m .47454 .77239 L .47258 .78368 L F
.55918 .30706 m .57681 .30615 L .57907 .29739 L .599 .384 .56 r
F
.55773 .31535 m .57681 .30615 L .55918 .30706 L .598 .377 .552 r
F
.53999 .31582 m .55773 .31535 L .55918 .30706 L .646 .422 .564 r
F
.28913 .56569 m .29902 .57313 L .28297 .57237 L .856 .962 .873 r
F
.28913 .56569 m .3047 .56651 L .29902 .57313 L F
.59306 .79563 m .61461 .79648 L .61761 .8087 L .558 .525 .774 r
F
.5908 .78391 m .61461 .79648 L .59306 .79563 L .557 .527 .777 r
F
.19298 .39873 m .20968 .40269 L .2213 .40889 L .507 0 0 r
F
.47847 .75101 m .49804 .76115 L .4765 .7615 L .768 .699 .787 r
F
.47847 .75101 m .49918 .7507 L .49804 .76115 L F
.4462 .28559 m .45981 .27774 L .44279 .27585 L .845 .577 .533 r
F
.4462 .28559 m .46252 .28735 L .45981 .27774 L F
.73426 .48135 m .74617 .48618 L .73132 .4878 L .231 .019 .372 r
F
.73426 .48135 m .74936 .47963 L .74617 .48618 L F
.52214 .32374 m .53999 .31582 L .52187 .31589 L .687 .452 .561 r
F
.50506 .32344 m .52187 .31589 L .50392 .31557 L .726 .483 .559 r
F
.50506 .32344 m .52214 .32374 L .52187 .31589 L F
.29495 .46627 m .31008 .46822 L .31439 .47463 L .889 .484 .239 r
F
.28957 .45977 m .31008 .46822 L .29495 .46627 L .864 .431 .181 r
F
.6049 .26703 m .62167 .26484 L .62529 .25424 L .469 .274 .532 r
F
.60192 .27708 m .62167 .26484 L .6049 .26703 L .468 .268 .525 r
F
.53939 .32367 m .55773 .31535 L .53999 .31582 L .645 .416 .557 r
F
.52214 .32374 m .53939 .32367 L .53999 .31582 L .687 .452 .561 r
F
.521 .74054 m .54248 .7506 L .52073 .75056 L .695 .639 .789 r
F
.50032 .74066 m .52073 .75056 L .49918 .7507 L .732 .67 .79 r
F
.50032 .74066 m .521 .74054 L .52073 .75056 L F
.62658 .84779 m .64824 .84941 L .6519 .86341 L .49 .468 .761 r
F
.62359 .83435 m .64824 .84941 L .62658 .84779 L .489 .47 .763 r
F
.38141 .1754 m .39272 .16625 L .37699 .1616 L .941 .654 .469 r
F
.38141 .1754 m .39664 .17978 L .39272 .16625 L F
.8198 .41569 m .82496 .41872 L .80966 .42194 L 0 0 0 r
F
.8198 .41569 m .83581 .41226 L .82496 .41872 L F
.42483 .80942 m .44282 .8209 L .4214 .82213 L .847 .764 .77 r
F
.42483 .80942 m .44554 .80831 L .44282 .8209 L F
.63612 .22003 m .65223 .21667 L .65638 .20425 L .366 .188 .502 r
F
.63252 .23183 m .65223 .21667 L .63612 .22003 L .365 .183 .496 r
F
.73814 .55342 m .75358 .55249 L .75825 .55916 L .272 .427 .835 r
F
.73449 .5468 m .75358 .55249 L .73814 .55342 L .274 .401 .81 r
F
.54248 .7506 m .56379 .7508 L .56524 .76126 L .655 .605 .786 r
F
.54188 .74057 m .56379 .7508 L .54248 .7506 L .655 .608 .79 r
F
.521 .74054 m .54188 .74057 L .54248 .7506 L .695 .639 .789 r
F
.73132 .4878 m .74369 .49275 L .72903 .49428 L .241 .063 .428 r
F
.73132 .4878 m .74617 .48618 L .74369 .49275 L F
.42039 .25255 m .43262 .24422 L .4164 .24143 L .891 .612 .507 r
F
.42039 .25255 m .436 .25517 L .43262 .24422 L F
.56524 .76126 m .58629 .76168 L .58855 .77259 L .611 .57 .783 r
F
.56379 .7508 m .58629 .76168 L .56524 .76126 L .61 .572 .787 r
F
.57907 .29739 m .59595 .29599 L .59894 .28674 L .542 .333 .546 r
F
.57681 .30615 m .59595 .29599 L .57907 .29739 L .54 .326 .538 r
F
.29457 .55901 m .3047 .56651 L .28913 .56569 L .877 .954 .854 r
F
.29457 .55901 m .30973 .55989 L .3047 .56651 L F
.29961 .47279 m .31439 .47463 L .31804 .48107 L .912 .536 .297 r
F
.29495 .46627 m .31439 .47463 L .29961 .47279 L .889 .484 .239 r
F
.48866 .32278 m .50392 .31557 L .48669 .31486 L .763 .509 .55 r
F
.48866 .32278 m .50506 .32344 L .50392 .31557 L F
.83172 .61898 m .86101 .6254 L .8433 .62557 L .107 .525 .911 r
F
.73449 .5468 m .74962 .54582 L .75358 .55249 L .274 .401 .81 r
F
.7315 .5402 m .74962 .54582 L .73449 .5468 L .275 .372 .782 r
F
.72903 .49428 m .74193 .49934 L .7274 .50078 L .25 .107 .483 r
F
.72903 .49428 m .74369 .49275 L .74193 .49934 L F
.45649 .76203 m .47454 .77239 L .45374 .77299 L .806 .733 .784 r
F
.45649 .76203 m .4765 .7615 L .47454 .77239 L F
.5908 .78391 m .61161 .78467 L .61461 .79648 L .557 .527 .777 r
F
.58855 .77259 m .61161 .78467 L .5908 .78391 L .557 .529 .78 r
F
.47072 .31377 m .48473 .30653 L .46798 .30537 L .802 .539 .54 r
F
.47072 .31377 m .48669 .31486 L .48473 .30653 L F
.20541 .40518 m .2213 .40889 L .23225 .41513 L .539 0 0 r
F
.19298 .39873 m .2213 .40889 L .20541 .40518 L .507 0 0 r
F
.48045 .74093 m .49918 .7507 L .47847 .75101 L .768 .702 .79 r
F
.48045 .74093 m .50032 .74066 L .49918 .7507 L F
.62359 .83435 m .64458 .83583 L .64824 .84941 L .489 .47 .763 r
F
.62061 .82132 m .64458 .83583 L .62359 .83435 L .489 .472 .766 r
F
.7315 .5402 m .74637 .53915 L .74962 .54582 L .275 .372 .782 r
F
.72917 .53359 m .74637 .53915 L .7315 .5402 L .276 .341 .75 r
F
.44962 .29492 m .46252 .28735 L .4462 .28559 L .844 .571 .526 r
F
.44962 .29492 m .46524 .29656 L .46252 .28735 L F
.38584 .18879 m .39664 .17978 L .38141 .1754 L .94 .65 .463 r
F
.38584 .18879 m .40057 .19291 L .39664 .17978 L F
.29929 .55232 m .30973 .55989 L .29457 .55901 L .896 .943 .832 r
F
.29929 .55232 m .3141 .55327 L .30973 .55989 L F
.7274 .50078 m .74088 .50594 L .72643 .50731 L .258 .15 .535 r
F
.7274 .50078 m .74193 .49934 L .74088 .50594 L F
.55773 .31535 m .57455 .31449 L .57681 .30615 L .598 .377 .552 r
F
.55628 .32323 m .57455 .31449 L .55773 .31535 L .597 .371 .544 r
F
.53939 .32367 m .55628 .32323 L .55773 .31535 L .645 .416 .557 r
F
.42827 .79713 m .44554 .80831 L .42483 .80942 L .847 .766 .773 r
F
.42827 .79713 m .44827 .79613 L .44554 .80831 L F
.60192 .27708 m .61803 .27504 L .62167 .26484 L .468 .268 .525 r
F
.59894 .28674 m .61803 .27504 L .60192 .27708 L .466 .262 .518 r
F
.30356 .47933 m .31804 .48107 L .32103 .48753 L .931 .586 .356 r
F
.29961 .47279 m .31804 .48107 L .30356 .47933 L .912 .536 .297 r
F
.80966 .42194 m .81484 .4252 L .8002 .42822 L 0 0 0 r
F
.80966 .42194 m .82496 .41872 L .81484 .4252 L F
.63252 .23183 m .64807 .22868 L .65223 .21667 L .365 .183 .496 r
F
.62891 .24324 m .64807 .22868 L .63252 .23183 L .363 .177 .49 r
F
.72917 .53359 m .74384 .53249 L .74637 .53915 L .276 .341 .75 r
F
.72749 .527 m .74384 .53249 L .72917 .53359 L .275 .307 .714 r
F
.52128 .73092 m .54188 .74057 L .521 .74054 L .694 .642 .793 r
F
.50146 .73102 m .521 .74054 L .50032 .74066 L .731 .673 .793 r
F
.50146 .73102 m .52128 .73092 L .521 .74054 L F
.52242 .33118 m .53939 .32367 L .52214 .32374 L .686 .446 .553 r
F
.5062 .3309 m .52214 .32374 L .50506 .32344 L .724 .476 .551 r
F
.5062 .3309 m .52242 .33118 L .52214 .32374 L F
.72643 .50731 m .74054 .51256 L .72613 .51386 L .264 .192 .584 r
F
.72643 .50731 m .74088 .50594 L .74054 .51256 L F
.72749 .527 m .74203 .52584 L .74384 .53249 L .275 .307 .714 r
F
.72648 .52042 m .74203 .52584 L .72749 .527 L .272 .27 .674 r
F
.72613 .51386 m .74093 .51919 L .72648 .52042 L .269 .232 .631 r
F
.72613 .51386 m .74054 .51256 L .74093 .51919 L F
.53879 .33112 m .55628 .32323 L .53939 .32367 L .644 .409 .548 r
F
.52242 .33118 m .53879 .33112 L .53939 .32367 L .686 .446 .553 r
F
.72648 .52042 m .74093 .51919 L .74203 .52584 L .272 .27 .674 r
F
.54188 .74057 m .56233 .74075 L .56379 .7508 L .655 .608 .79 r
F
.54128 .73094 m .56233 .74075 L .54188 .74057 L .654 .611 .794 r
F
.52128 .73092 m .54128 .73094 L .54188 .74057 L .694 .642 .793 r
F
.42438 .26326 m .436 .25517 L .42039 .25255 L .89 .607 .501 r
F
.42438 .26326 m .43939 .26571 L .436 .25517 L F
.56379 .7508 m .58402 .75117 L .58629 .76168 L .61 .572 .787 r
F
.56233 .74075 m .58402 .75117 L .56379 .7508 L .61 .576 .791 r
F
.3033 .54564 m .3141 .55327 L .29929 .55232 L .914 .929 .807 r
F
.3033 .54564 m .3178 .54664 L .3141 .55327 L F
.30679 .48589 m .32103 .48753 L .32335 .49403 L .947 .636 .413 r
F
.30356 .47933 m .32103 .48753 L .30679 .48589 L .931 .586 .356 r
F
.83172 .61898 m .84859 .61872 L .86101 .6254 L .107 .525 .911 r
F
.82081 .61238 m .84859 .61872 L .83172 .61898 L .111 .515 .91 r
F
.57681 .30615 m .59294 .30484 L .59595 .29599 L .54 .326 .538 r
F
.57455 .31449 m .59294 .30484 L .57681 .30615 L .539 .319 .53 r
F
.58855 .77259 m .60859 .77327 L .61161 .78467 L .557 .529 .78 r
F
.58629 .76168 m .60859 .77327 L .58855 .77259 L .556 .532 .784 r
F
.45924 .75148 m .4765 .7615 L .45649 .76203 L .805 .736 .787 r
F
.45924 .75148 m .47847 .75101 L .4765 .7615 L F
.62061 .82132 m .64092 .82266 L .64458 .83583 L .489 .472 .766 r
F
.61761 .8087 m .64092 .82266 L .62061 .82132 L .488 .475 .769 r
F
.66878 .16458 m .68737 .14542 L .67289 .15056 L .205 .047 .434 r
F
.39105 .8647 m .40775 .87704 L .38703 .87923 L .892 .803 .753 r
F
.39105 .8647 m .41115 .8627 L .40775 .87704 L F
.39028 .20177 m .40057 .19291 L .38584 .18879 L .939 .645 .457 r
F
.39028 .20177 m .40451 .20564 L .40057 .19291 L F
.30658 .53897 m .3178 .54664 L .3033 .54564 L .931 .912 .778 r
F
.30658 .53897 m .32084 .54003 L .3178 .54664 L F
.49064 .33029 m .50506 .32344 L .48866 .32278 L .762 .502 .541 r
F
.49064 .33029 m .5062 .3309 L .50506 .32344 L F
.21711 .41165 m .23225 .41513 L .24251 .42141 L .572 0 0 r
F
.20541 .40518 m .23225 .41513 L .21711 .41165 L .539 0 0 r
F
.3093 .49248 m .32335 .49403 L .325 .50055 L .959 .683 .47 r
F
.30679 .48589 m .32335 .49403 L .3093 .49248 L .947 .636 .413 r
F
.43171 .78525 m .44827 .79613 L .42827 .79713 L .846 .769 .776 r
F
.43171 .78525 m .451 .78436 L .44827 .79613 L F
.48243 .73126 m .50032 .74066 L .48045 .74093 L .767 .706 .794 r
F
.48243 .73126 m .50146 .73102 L .50032 .74066 L F
.47347 .32177 m .48669 .31486 L .47072 .31377 L .801 .532 .531 r
F
.47347 .32177 m .48866 .32278 L .48669 .31486 L F
.8002 .42822 m .80545 .4317 L .79142 .43453 L 0 0 0 r
F
.8002 .42822 m .81484 .4252 L .80545 .4317 L F
.45306 .30384 m .46524 .29656 L .44962 .29492 L .843 .565 .518 r
F
.45306 .30384 m .46798 .30537 L .46524 .29656 L F
.62891 .24324 m .6439 .24028 L .64807 .22868 L .363 .177 .49 r
F
.62529 .25424 m .6439 .24028 L .62891 .24324 L .361 .171 .483 r
F
.59894 .28674 m .61438 .28483 L .61803 .27504 L .466 .262 .518 r
F
.59595 .29599 m .61438 .28483 L .59894 .28674 L .464 .255 .51 r
F
.30914 .5323 m .32084 .54003 L .30658 .53897 L .945 .891 .746 r
F
.30914 .5323 m .32321 .53341 L .32084 .54003 L F
.31108 .49908 m .325 .50055 L .32599 .50709 L .966 .727 .524 r
F
.3093 .49248 m .325 .50055 L .31108 .49908 L .959 .683 .47 r
F
.55628 .32323 m .57228 .32244 L .57455 .31449 L .597 .371 .544 r
F
.55482 .33071 m .57228 .32244 L .55628 .32323 L .595 .363 .535 r
F
.53879 .33112 m .55482 .33071 L .55628 .32323 L .644 .409 .548 r
F
.52155 .7217 m .54128 .73094 L .52128 .73092 L .693 .645 .797 r
F
.50261 .72179 m .52128 .73092 L .50146 .73102 L .73 .676 .797 r
F
.50261 .72179 m .52155 .7217 L .52128 .73092 L F
.31098 .52563 m .32321 .53341 L .30914 .5323 L .956 .866 .709 r
F
.31098 .52563 m .32491 .52681 L .32321 .53341 L F
.42839 .27356 m .43939 .26571 L .42438 .26326 L .889 .601 .493 r
F
.42839 .27356 m .44279 .27585 L .43939 .26571 L F
.31214 .5057 m .32599 .50709 L .3263 .51365 L .97 .767 .575 r
F
.31108 .49908 m .32599 .50709 L .31214 .5057 L .966 .727 .524 r
F
.2042 .61867 m .20844 .62554 L .19165 .62538 L .634 .961 .903 r
F
.2042 .61867 m .22017 .61894 L .20844 .62554 L F
.82081 .61238 m .83689 .61202 L .84859 .61872 L .111 .515 .91 r
F
.81057 .60576 m .83689 .61202 L .82081 .61238 L .114 .505 .907 r
F
.54128 .73094 m .56087 .7311 L .56233 .74075 L .654 .611 .794 r
F
.54068 .72172 m .56087 .7311 L .54128 .73094 L .654 .615 .798 r
F
.52155 .7217 m .54068 .72172 L .54128 .73094 L .693 .645 .797 r
F
.31209 .51898 m .32491 .52681 L .31098 .52563 L .965 .837 .668 r
F
.31209 .51898 m .32594 .52022 L .32491 .52681 L F
.39509 .85059 m .41115 .8627 L .39105 .8647 L .892 .805 .756 r
F
.39509 .85059 m .41456 .84877 L .41115 .8627 L F
.31248 .51233 m .3263 .51365 L .32594 .52022 L .969 .804 .623 r
F
.31214 .5057 m .3263 .51365 L .31248 .51233 L .97 .767 .575 r
F
.56233 .74075 m .58174 .74107 L .58402 .75117 L .61 .576 .791 r
F
.56087 .7311 m .58174 .74107 L .56233 .74075 L .609 .579 .795 r
F
.66878 .16458 m .68281 .15974 L .68737 .14542 L .205 .047 .434 r
F
.66466 .17821 m .68281 .15974 L .66878 .16458 L .203 .042 .428 r
F
.61761 .8087 m .63725 .8099 L .64092 .82266 L .488 .475 .769 r
F
.61461 .79648 m .63725 .8099 L .61761 .8087 L .487 .477 .772 r
F
.52269 .33822 m .53879 .33112 L .52242 .33118 L .684 .438 .544 r
F
.50735 .33796 m .52242 .33118 L .5062 .3309 L .723 .469 .542 r
F
.50735 .33796 m .52269 .33822 L .52242 .33118 L F
.31248 .51233 m .32594 .52022 L .31209 .51898 L .969 .804 .623 r
F
.58629 .76168 m .60557 .76228 L .60859 .77327 L .556 .532 .784 r
F
.58402 .75117 m .60557 .76228 L .58629 .76168 L .556 .535 .787 r
F
.39472 .21433 m .40451 .20564 L .39028 .20177 L .938 .64 .45 r
F
.39472 .21433 m .40846 .21798 L .40451 .20564 L F
.53818 .33816 m .55482 .33071 L .53879 .33112 L .642 .401 .539 r
F
.52269 .33822 m .53818 .33816 L .53879 .33112 L .684 .438 .544 r
F
.462 .74135 m .47847 .75101 L .45924 .75148 L .804 .739 .791 r
F
.462 .74135 m .48045 .74093 L .47847 .75101 L F
.43516 .77379 m .451 .78436 L .43171 .78525 L .846 .772 .78 r
F
.43516 .77379 m .45374 .77299 L .451 .78436 L F
.22806 .41815 m .24251 .42141 L .2521 .42772 L .607 .039 0 r
F
.21711 .41165 m .24251 .42141 L .22806 .41815 L .572 0 0 r
F
.57455 .31449 m .58993 .31328 L .59294 .30484 L .539 .319 .53 r
F
.57228 .32244 m .58993 .31328 L .57455 .31449 L .537 .312 .521 r
F
.79142 .43453 m .79681 .43823 L .78332 .44089 L 0 0 0 r
F
.79142 .43453 m .80545 .4317 L .79681 .43823 L F
.62529 .25424 m .63971 .25147 L .6439 .24028 L .361 .171 .483 r
F
.62167 .26484 m .63971 .25147 L .62529 .25424 L .359 .165 .476 r
F
.48441 .722 m .50146 .73102 L .48243 .73126 L .766 .709 .798 r
F
.48441 .722 m .50261 .72179 L .50146 .73102 L F
.49263 .3374 m .5062 .3309 L .49064 .33029 L .76 .494 .531 r
F
.49263 .3374 m .50735 .33796 L .5062 .3309 L F
.39912 .8369 m .41456 .84877 L .39509 .85059 L .892 .807 .759 r
F
.39912 .8369 m .41798 .83524 L .41456 .84877 L F
.4565 .31235 m .46798 .30537 L .45306 .30384 L .841 .558 .509 r
F
.4565 .31235 m .47072 .31377 L .46798 .30537 L F
.59595 .29599 m .61071 .29421 L .61438 .28483 L .464 .255 .51 r
F
.59294 .30484 m .61071 .29421 L .59595 .29599 L .462 .248 .502 r
F
.47623 .32936 m .48866 .32278 L .47347 .32177 L .799 .524 .522 r
F
.47623 .32936 m .49064 .33029 L .48866 .32278 L F
.66466 .17821 m .67823 .17364 L .68281 .15974 L .203 .042 .428 r
F
.66052 .19143 m .67823 .17364 L .66466 .17821 L .2 .036 .421 r
F
.81057 .60576 m .82593 .60531 L .83689 .61202 L .114 .505 .907 r
F
.80102 .59913 m .82593 .60531 L .81057 .60576 L .116 .493 .903 r
F
.61461 .79648 m .63357 .79756 L .63725 .8099 L .487 .477 .772 r
F
.61161 .78467 m .63357 .79756 L .61461 .79648 L .487 .48 .775 r
F
.21601 .61196 m .22017 .61894 L .2042 .61867 L .657 .969 .902 r
F
.21601 .61196 m .23122 .61232 L .22017 .61894 L F
.43241 .28345 m .44279 .27585 L .42839 .27356 L .888 .595 .485 r
F
.43241 .28345 m .4462 .28559 L .44279 .27585 L F
.52183 .71289 m .54068 .72172 L .52155 .7217 L .693 .649 .802 r
F
.50375 .71297 m .52155 .7217 L .50261 .72179 L .73 .68 .802 r
F
.50375 .71297 m .52183 .71289 L .52155 .7217 L F
.39918 .22648 m .40846 .21798 L .39472 .21433 L .937 .635 .443 r
F
.39918 .22648 m .41243 .22991 L .40846 .21798 L F
.55482 .33071 m .57 .32998 L .57228 .32244 L .595 .363 .535 r
F
.55335 .33779 m .57 .32998 L .55482 .33071 L .593 .355 .525 r
F
.53818 .33816 m .55335 .33779 L .55482 .33071 L .642 .401 .539 r
F
.56087 .7311 m .57946 .73138 L .58174 .74107 L .609 .579 .795 r
F
.55941 .72186 m .57946 .73138 L .56087 .7311 L .608 .582 .799 r
F
.54068 .72172 m .55941 .72186 L .56087 .7311 L .654 .615 .798 r
F
.54007 .71291 m .55941 .72186 L .54068 .72172 L .653 .618 .802 r
F
.52183 .71289 m .54007 .71291 L .54068 .72172 L .693 .649 .802 r
F
.58402 .75117 m .60255 .7517 L .60557 .76228 L .556 .535 .787 r
F
.58174 .74107 m .60255 .7517 L .58402 .75117 L .555 .538 .791 r
F
.43861 .76274 m .45374 .77299 L .43516 .77379 L .845 .775 .783 r
F
.43861 .76274 m .45649 .76203 L .45374 .77299 L F
.23828 .42467 m .2521 .42772 L .26099 .43407 L .644 .085 0 r
F
.22806 .41815 m .2521 .42772 L .23828 .42467 L .607 .039 0 r
F
.46476 .73162 m .48045 .74093 L .462 .74135 L .804 .742 .795 r
F
.46476 .73162 m .48243 .73126 L .48045 .74093 L F
.78332 .44089 m .78891 .44478 L .77591 .44727 L 0 0 0 r
F
.78332 .44089 m .79681 .43823 L .78891 .44478 L F
.52297 .34485 m .53818 .33816 L .52269 .33822 L .682 .429 .533 r
F
.5085 .34461 m .52269 .33822 L .50735 .33796 L .721 .46 .531 r
F
.5085 .34461 m .52297 .34485 L .52269 .33822 L F
.40317 .82362 m .41798 .83524 L .39912 .8369 L .891 .81 .762 r
F
.40317 .82362 m .4214 .82213 L .41798 .83524 L F
.6519 .86341 m .67476 .88014 L .65555 .87782 L .392 .4 .749 r
F
.62167 .26484 m .63552 .26225 L .63971 .25147 L .359 .165 .476 r
F
.61803 .27504 m .63552 .26225 L .62167 .26484 L .356 .158 .467 r
F
.53758 .34479 m .55335 .33779 L .53818 .33816 L .64 .392 .528 r
F
.52297 .34485 m .53758 .34479 L .53818 .33816 L .682 .429 .533 r
F
.57228 .32244 m .5869 .32131 L .58993 .31328 L .537 .312 .521 r
F
.57 .32998 m .5869 .32131 L .57228 .32244 L .534 .303 .511 r
F
.66052 .19143 m .67365 .18713 L .67823 .17364 L .2 .036 .421 r
F
.65638 .20425 m .67365 .18713 L .66052 .19143 L .198 .03 .414 r
F
.80102 .59913 m .81571 .5986 L .82593 .60531 L .116 .493 .903 r
F
.79215 .59248 m .81571 .5986 L .80102 .59913 L .119 .479 .898 r
F
.48641 .71314 m .50261 .72179 L .48441 .722 L .765 .713 .803 r
F
.48641 .71314 m .50375 .71297 L .50261 .72179 L F
.61161 .78467 m .62988 .78564 L .63357 .79756 L .487 .48 .775 r
F
.60859 .77327 m .62988 .78564 L .61161 .78467 L .486 .483 .779 r
F
.22708 .60524 m .23122 .61232 L .21601 .61196 L .681 .976 .9 r
F
.22708 .60524 m .24159 .60568 L .23122 .61232 L F
.59294 .30484 m .60704 .30318 L .61071 .29421 L .462 .248 .502 r
F
.58993 .31328 m .60704 .30318 L .59294 .30484 L .46 .24 .492 r
F
.45996 .32045 m .47072 .31377 L .4565 .31235 L .84 .55 .499 r
F
.45996 .32045 m .47347 .32177 L .47072 .31377 L F
.40365 .23822 m .41243 .22991 L .39918 .22648 L .936 .629 .435 r
F
.40365 .23822 m .4164 .24143 L .41243 .22991 L F
.43643 .29292 m .4462 .28559 L .43241 .28345 L .886 .588 .476 r
F
.43643 .29292 m .44962 .29492 L .4462 .28559 L F
.49463 .34409 m .50735 .33796 L .49263 .3374 L .758 .485 .52 r
F
.49463 .34409 m .5085 .34461 L .50735 .33796 L F
.479 .33654 m .49064 .33029 L .47623 .32936 L .797 .515 .511 r
F
.479 .33654 m .49263 .3374 L .49064 .33029 L F
.24775 .43121 m .26099 .43407 L .26919 .44045 L .681 .134 0 r
F
.23828 .42467 m .26099 .43407 L .24775 .43121 L .644 .085 0 r
F
.77591 .44727 m .78175 .45134 L .7692 .45369 L 0 0 0 r
F
.77591 .44727 m .78891 .44478 L .78175 .45134 L F
.44208 .7521 m .45649 .76203 L .43861 .76274 L .844 .778 .787 r
F
.44208 .7521 m .45924 .75148 L .45649 .76203 L F
.5221 .70449 m .54007 .71291 L .52183 .71289 L .692 .653 .806 r
F
.50491 .70455 m .52183 .71289 L .50375 .71297 L .729 .684 .807 r
F
.50491 .70455 m .5221 .70449 L .52183 .71289 L F
.58174 .74107 m .59951 .74153 L .60255 .7517 L .555 .538 .791 r
F
.57946 .73138 m .59951 .74153 L .58174 .74107 L .554 .542 .796 r
F
.6519 .86341 m .67052 .86553 L .67476 .88014 L .392 .4 .749 r
F
.64824 .84941 m .67052 .86553 L .6519 .86341 L .391 .402 .751 r
F
.40722 .81077 m .4214 .82213 L .40317 .82362 L .891 .812 .765 r
F
.40722 .81077 m .42483 .80942 L .4214 .82213 L F
.55941 .72186 m .57717 .7221 L .57946 .73138 L .608 .582 .799 r
F
.55794 .71302 m .57717 .7221 L .55941 .72186 L .607 .586 .804 r
F
.54007 .71291 m .55794 .71302 L .55941 .72186 L .653 .618 .802 r
F
.46754 .72231 m .48243 .73126 L .46476 .73162 L .803 .746 .8 r
F
.46754 .72231 m .48441 .722 L .48243 .73126 L F
.53947 .7045 m .55794 .71302 L .54007 .71291 L .652 .622 .807 r
F
.5221 .70449 m .53947 .7045 L .54007 .71291 L .692 .653 .806 r
F
.79215 .59248 m .80624 .59188 L .81571 .5986 L .119 .479 .898 r
F
.78397 .58583 m .80624 .59188 L .79215 .59248 L .121 .464 .89 r
F
.55335 .33779 m .56771 .33711 L .57 .32998 L .593 .355 .525 r
F
.55188 .34445 m .56771 .33711 L .55335 .33779 L .59 .345 .513 r
F
.53758 .34479 m .55188 .34445 L .55335 .33779 L .64 .392 .528 r
F
.65638 .20425 m .66906 .20021 L .67365 .18713 L .198 .03 .414 r
F
.65223 .21667 m .66906 .20021 L .65638 .20425 L .195 .023 .407 r
F
.61803 .27504 m .63132 .27262 L .63552 .26225 L .356 .158 .467 r
F
.61438 .28483 m .63132 .27262 L .61803 .27504 L .354 .15 .459 r
F
.23739 .59851 m .24159 .60568 L .22708 .60524 L .706 .982 .896 r
F
.23739 .59851 m .25127 .59904 L .24159 .60568 L F
.60859 .77327 m .62619 .77413 L .62988 .78564 L .486 .483 .779 r
F
.60557 .76228 m .62619 .77413 L .60859 .77327 L .485 .486 .783 r
F
.40813 .24954 m .4164 .24143 L .40365 .23822 L .934 .623 .427 r
F
.40813 .24954 m .42039 .25255 L .4164 .24143 L F
.52325 .35107 m .53758 .34479 L .52297 .34485 L .68 .42 .521 r
F
.50966 .35085 m .52297 .34485 L .5085 .34461 L .719 .45 .519 r
F
.50966 .35085 m .52325 .35107 L .52297 .34485 L F
.57 .32998 m .58387 .32894 L .5869 .32131 L .534 .303 .511 r
F
.56771 .33711 m .58387 .32894 L .57 .32998 L .532 .294 .5 r
F
.7692 .45369 m .77534 .45793 L .76319 .46013 L .008 0 0 r
F
.7692 .45369 m .78175 .45134 L .77534 .45793 L F
.64824 .84941 m .66628 .85134 L .67052 .86553 L .391 .402 .751 r
F
.64458 .83583 m .66628 .85134 L .64824 .84941 L .39 .404 .754 r
F
.4884 .7047 m .50375 .71297 L .48641 .71314 L .764 .717 .808 r
F
.4884 .7047 m .50491 .70455 L .50375 .71297 L F
.25648 .43776 m .26919 .44045 L .27669 .44686 L .719 .187 0 r
F
.24775 .43121 m .26919 .44045 L .25648 .43776 L .681 .134 0 r
F
.53697 .35102 m .55188 .34445 L .53758 .34479 L .637 .382 .516 r
F
.52325 .35107 m .53697 .35102 L .53758 .34479 L .68 .42 .521 r
F
.41127 .79834 m .42483 .80942 L .40722 .81077 L .89 .815 .768 r
F
.41127 .79834 m .42827 .79713 L .42483 .80942 L F
.44047 .30199 m .44962 .29492 L .43643 .29292 L .885 .58 .466 r
F
.44047 .30199 m .45306 .30384 L .44962 .29492 L F
.58993 .31328 m .60336 .31174 L .60704 .30318 L .46 .24 .492 r
F
.5869 .32131 m .60336 .31174 L .58993 .31328 L .457 .231 .482 r
F
.44555 .74189 m .45924 .75148 L .44208 .7521 L .843 .781 .791 r
F
.44555 .74189 m .462 .74135 L .45924 .75148 L F
.46342 .32814 m .47347 .32177 L .45996 .32045 L .838 .541 .488 r
F
.46342 .32814 m .47623 .32936 L .47347 .32177 L F
.78397 .58583 m .7975 .58516 L .80624 .59188 L .121 .464 .89 r
F
.77649 .57917 m .7975 .58516 L .78397 .58583 L .123 .446 .88 r
F
.57946 .73138 m .59647 .73178 L .59951 .74153 L .554 .542 .796 r
F
.57717 .7221 m .59647 .73178 L .57946 .73138 L .553 .546 .8 r
F
.65223 .21667 m .66445 .21287 L .66906 .20021 L .195 .023 .407 r
F
.64807 .22868 m .66445 .21287 L .65223 .21667 L .192 .016 .399 r
F
.52238 .69649 m .53947 .7045 L .5221 .70449 L .691 .657 .812 r
F
.50606 .69655 m .5221 .70449 L .50491 .70455 L .728 .688 .812 r
F
.50606 .69655 m .52238 .69649 L .5221 .70449 L F
.24696 .59177 m .25127 .59904 L .23739 .59851 L .732 .987 .89 r
F
.24696 .59177 m .26025 .59238 L .25127 .59904 L F
.55794 .71302 m .57488 .71323 L .57717 .7221 L .607 .586 .804 r
F
.55647 .7046 m .57488 .71323 L .55794 .71302 L .607 .59 .809 r
F
.53947 .7045 m .55647 .7046 L .55794 .71302 L .652 .622 .807 r
F
.48178 .3433 m .49263 .3374 L .479 .33654 L .795 .505 .499 r
F
.48178 .3433 m .49463 .34409 L .49263 .3374 L F
.49663 .35037 m .5085 .34461 L .49463 .34409 L .756 .475 .507 r
F
.49663 .35037 m .50966 .35085 L .5085 .34461 L F
.47032 .71341 m .48441 .722 L .46754 .72231 L .802 .75 .805 r
F
.47032 .71341 m .48641 .71314 L .48441 .722 L F
.61438 .28483 m .6271 .28257 L .63132 .27262 L .354 .15 .459 r
F
.61071 .29421 m .6271 .28257 L .61438 .28483 L .351 .142 .449 r
F
.76319 .46013 m .76969 .46453 L .75787 .46661 L .02 0 .051 r
F
.76319 .46013 m .77534 .45793 L .76969 .46453 L F
.60557 .76228 m .62249 .76304 L .62619 .77413 L .485 .486 .783 r
F
.60255 .7517 m .62249 .76304 L .60557 .76228 L .484 .489 .787 r
F
.53886 .69651 m .55647 .7046 L .53947 .7045 L .651 .627 .812 r
F
.52238 .69649 m .53886 .69651 L .53947 .7045 L .691 .657 .812 r
F
.64458 .83583 m .66204 .83758 L .66628 .85134 L .39 .404 .754 r
F
.64092 .82266 m .66204 .83758 L .64458 .83583 L .389 .407 .757 r
F
.26445 .44434 m .27669 .44686 L .28348 .4533 L .758 .243 0 r
F
.25648 .43776 m .27669 .44686 L .26445 .44434 L .719 .187 0 r
F
.41261 .26045 m .42039 .25255 L .40813 .24954 L .932 .616 .418 r
F
.41261 .26045 m .42438 .26326 L .42039 .25255 L F
.41533 .78634 m .42827 .79713 L .41127 .79834 L .889 .818 .772 r
F
.41533 .78634 m .43171 .78525 L .42827 .79713 L F
.77649 .57917 m .78952 .57843 L .7975 .58516 L .123 .446 .88 r
F
.76971 .5725 m .78952 .57843 L .77649 .57917 L .125 .425 .868 r
F
.36599 .15647 m .37258 .1474 L .3612 .14196 L .969 .652 .336 r
F
.36599 .15647 m .37699 .1616 L .37258 .1474 L F
.55188 .34445 m .56542 .34383 L .56771 .33711 L .59 .345 .513 r
F
.5504 .3507 m .56542 .34383 L .55188 .34445 L .587 .334 .5 r
F
.53697 .35102 m .5504 .3507 L .55188 .34445 L .637 .382 .516 r
F
.44902 .73209 m .462 .74135 L .44555 .74189 L .842 .785 .796 r
F
.44902 .73209 m .46476 .73162 L .462 .74135 L F
.44452 .31063 m .45306 .30384 L .44047 .30199 L .882 .572 .456 r
F
.44452 .31063 m .4565 .31235 L .45306 .30384 L F
.49041 .69668 m .50491 .70455 L .4884 .7047 L .763 .721 .813 r
F
.49041 .69668 m .50606 .69655 L .50491 .70455 L F
.56771 .33711 m .58082 .33614 L .58387 .32894 L .532 .294 .5 r
F
.56542 .34383 m .58082 .33614 L .56771 .33711 L .529 .283 .487 r
F
.75787 .46661 m .76478 .47116 L .75326 .47311 L .032 0 .115 r
F
.75787 .46661 m .76969 .46453 L .76478 .47116 L F
.25577 .58504 m .26025 .59238 L .24696 .59177 L .758 .991 .883 r
F
.25577 .58504 m .26853 .58572 L .26025 .59238 L F
.64807 .22868 m .65984 .22511 L .66445 .21287 L .192 .016 .399 r
F
.6439 .24028 m .65984 .22511 L .64807 .22868 L .19 .009 .39 r
F
.5869 .32131 m .59967 .31989 L .60336 .31174 L .457 .231 .482 r
F
.58387 .32894 m .59967 .31989 L .5869 .32131 L .454 .221 .47 r
F
.52353 .35688 m .53697 .35102 L .52325 .35107 L .677 .408 .507 r
F
.51082 .35668 m .52325 .35107 L .50966 .35085 L .716 .439 .505 r
F
.51082 .35668 m .52353 .35688 L .52325 .35107 L F
.64092 .82266 m .65779 .82424 L .66204 .83758 L .389 .407 .757 r
F
.63725 .8099 m .65779 .82424 L .64092 .82266 L .388 .409 .761 r
F
.57717 .7221 m .59342 .72245 L .59647 .73178 L .553 .546 .8 r
F
.57488 .71323 m .59342 .72245 L .57717 .7221 L .552 .55 .805 r
F
.4669 .33541 m .47623 .32936 L .46342 .32814 L .835 .532 .475 r
F
.4669 .33541 m .479 .33654 L .47623 .32936 L F
.76971 .5725 m .78229 .57169 L .78952 .57843 L .125 .425 .868 r
F
.76362 .56583 m .78229 .57169 L .76971 .5725 L .126 .402 .853 r
F
.27167 .45093 m .28348 .4533 L .28957 .45977 L .797 .302 0 r
F
.26445 .44434 m .28348 .4533 L .27167 .45093 L .758 .243 0 r
F
.53636 .35683 m .5504 .3507 L .53697 .35102 L .634 .37 .501 r
F
.52353 .35688 m .53636 .35683 L .53697 .35102 L .677 .408 .507 r
F
.60255 .7517 m .61879 .75237 L .62249 .76304 L .484 .489 .787 r
F
.59951 .74153 m .61879 .75237 L .60255 .7517 L .484 .493 .791 r
F
.61071 .29421 m .62288 .2921 L .6271 .28257 L .351 .142 .449 r
F
.60704 .30318 m .62288 .2921 L .61071 .29421 L .348 .133 .438 r
F
.4731 .70493 m .48641 .71314 L .47032 .71341 L .801 .754 .81 r
F
.4731 .70493 m .4884 .7047 L .48641 .71314 L F
.37078 .17056 m .37699 .1616 L .36599 .15647 L .968 .646 .328 r
F
.37078 .17056 m .38141 .1754 L .37699 .1616 L F
.4194 .77475 m .43171 .78525 L .41533 .78634 L .888 .821 .776 r
F
.4194 .77475 m .43516 .77379 L .43171 .78525 L F
.55647 .7046 m .57258 .70478 L .57488 .71323 L .607 .59 .809 r
F
.55499 .69659 m .57258 .70478 L .55647 .7046 L .605 .595 .814 r
F
.53886 .69651 m .55499 .69659 L .55647 .7046 L .651 .627 .812 r
F
.41711 .27093 m .42438 .26326 L .41261 .26045 L .931 .609 .409 r
F
.41711 .27093 m .42839 .27356 L .42438 .26326 L F
.52266 .68892 m .53886 .69651 L .52238 .69649 L .69 .662 .818 r
F
.50722 .68896 m .52238 .69649 L .50606 .69655 L .726 .693 .818 r
F
.50722 .68896 m .52266 .68892 L .52238 .69649 L F
.75326 .47311 m .76063 .47779 L .74936 .47963 L .044 0 .182 r
F
.75326 .47311 m .76478 .47116 L .76063 .47779 L F
.48457 .34964 m .49463 .34409 L .48178 .3433 L .792 .494 .485 r
F
.48457 .34964 m .49663 .35037 L .49463 .34409 L F
.26383 .5783 m .26853 .58572 L .25577 .58504 L .785 .994 .873 r
F
.26383 .5783 m .2761 .57905 L .26853 .58572 L F
.53825 .68893 m .55499 .69659 L .53886 .69651 L .65 .631 .818 r
F
.52266 .68892 m .53825 .68893 L .53886 .69651 L .69 .662 .818 r
F
.49864 .35624 m .50966 .35085 L .49663 .35037 L .753 .463 .493 r
F
.49864 .35624 m .51082 .35668 L .50966 .35085 L F
.76362 .56583 m .77581 .56496 L .78229 .57169 L .126 .402 .853 r
F
.75825 .55916 m .77581 .56496 L .76362 .56583 L .126 .377 .834 r
F
.6439 .24028 m .65522 .23694 L .65984 .22511 L .19 .009 .39 r
F
.63971 .25147 m .65522 .23694 L .6439 .24028 L .187 .001 .381 r
F
.63725 .8099 m .65354 .81133 L .65779 .82424 L .388 .409 .761 r
F
.63357 .79756 m .65354 .81133 L .63725 .8099 L .388 .412 .764 r
F
.27813 .45754 m .28957 .45977 L .29495 .46627 L .834 .363 .02 r
F
.27167 .45093 m .28957 .45977 L .27813 .45754 L .797 .302 0 r
F
.45251 .72271 m .46476 .73162 L .44902 .73209 L .841 .789 .801 r
F
.45251 .72271 m .46754 .72231 L .46476 .73162 L F
.44858 .31885 m .4565 .31235 L .44452 .31063 L .88 .562 .444 r
F
.44858 .31885 m .45996 .32045 L .4565 .31235 L F
.74936 .47963 m .75724 .48444 L .74617 .48618 L .055 0 .249 r
F
.74936 .47963 m .76063 .47779 L .75724 .48444 L F
.5504 .3507 m .56311 .35013 L .56542 .34383 L .587 .334 .5 r
F
.54892 .35654 m .56311 .35013 L .5504 .3507 L .584 .322 .485 r
F
.53636 .35683 m .54892 .35654 L .5504 .3507 L .634 .37 .501 r
F
.37558 .18424 m .38141 .1754 L .37078 .17056 L .966 .64 .32 r
F
.37558 .18424 m .38584 .18879 L .38141 .1754 L F
.75825 .55916 m .77008 .55823 L .77581 .56496 L .126 .377 .834 r
F
.75358 .55249 m .77008 .55823 L .75825 .55916 L .126 .347 .811 r
F
.49241 .68907 m .50606 .69655 L .49041 .69668 L .762 .726 .819 r
F
.49241 .68907 m .50722 .68896 L .50606 .69655 L F
.58387 .32894 m .59596 .32761 L .59967 .31989 L .454 .221 .47 r
F
.58082 .33614 m .59596 .32761 L .58387 .32894 L .451 .21 .457 r
F
.59951 .74153 m .61508 .74212 L .61879 .75237 L .484 .493 .791 r
F
.59647 .73178 m .61508 .74212 L .59951 .74153 L .483 .496 .796 r
F
.42347 .76359 m .43516 .77379 L .4194 .77475 L .888 .825 .78 r
F
.42347 .76359 m .43861 .76274 L .43516 .77379 L F
.57488 .71323 m .59037 .71353 L .59342 .72245 L .552 .55 .805 r
F
.57258 .70478 m .59037 .71353 L .57488 .71323 L .551 .554 .811 r
F
.27113 .57155 m .2761 .57905 L .26383 .5783 L .813 .995 .861 r
F
.27113 .57155 m .28297 .57237 L .2761 .57905 L F
.56542 .34383 m .57777 .34294 L .58082 .33614 L .529 .283 .487 r
F
.56311 .35013 m .57777 .34294 L .56542 .34383 L .525 .271 .472 r
F
.42161 .281 m .42839 .27356 L .41711 .27093 L .928 .601 .398 r
F
.42161 .281 m .43241 .28345 L .42839 .27356 L F
.60704 .30318 m .61865 .30122 L .62288 .2921 L .348 .133 .438 r
F
.60336 .31174 m .61865 .30122 L .60704 .30318 L .345 .123 .426 r
F
.47039 .34226 m .479 .33654 L .4669 .33541 L .832 .52 .461 r
F
.47039 .34226 m .48178 .3433 L .479 .33654 L F
.74617 .48618 m .75461 .49111 L .74369 .49275 L .067 0 .317 r
F
.74617 .48618 m .75724 .48444 L .75461 .49111 L F
.28384 .46417 m .29495 .46627 L .29961 .47279 L .87 .426 .085 r
F
.27813 .45754 m .29495 .46627 L .28384 .46417 L .834 .363 .02 r
F
.4759 .69687 m .4884 .7047 L .4731 .70493 L .799 .759 .816 r
F
.4759 .69687 m .49041 .69668 L .4884 .7047 L F
.75358 .55249 m .76512 .55149 L .77008 .55823 L .126 .347 .811 r
F
.74962 .54582 m .76512 .55149 L .75358 .55249 L .125 .315 .784 r
F
.52381 .36227 m .53636 .35683 L .52353 .35688 L .674 .395 .491 r
F
.51198 .36209 m .52353 .35688 L .51082 .35668 L .712 .425 .488 r
F
.51198 .36209 m .52381 .36227 L .52353 .35688 L F
.63357 .79756 m .64928 .79884 L .65354 .81133 L .388 .412 .764 r
F
.62988 .78564 m .64928 .79884 L .63357 .79756 L .387 .415 .768 r
F
.37511 .867 m .38703 .87923 L .37057 .88175 L .939 .859 .735 r
F
.37511 .867 m .39105 .8647 L .38703 .87923 L F
.55499 .69659 m .57027 .69674 L .57258 .70478 L .605 .595 .814 r
F
.55351 .68899 m .57027 .69674 L .55499 .69659 L .604 .6 .82 r
F
.53825 .68893 m .55351 .68899 L .55499 .69659 L .65 .631 .818 r
F
.63971 .25147 m .6506 .24834 L .65522 .23694 L .187 .001 .381 r
F
.63552 .26225 m .6506 .24834 L .63971 .25147 L .183 0 .371 r
F
.53575 .36223 m .54892 .35654 L .53636 .35683 L .631 .357 .485 r
F
.52381 .36227 m .53575 .36223 L .53636 .35683 L .674 .395 .491 r
F
.74369 .49275 m .75273 .49778 L .74193 .49934 L .077 0 .385 r
F
.74369 .49275 m .75461 .49111 L .75273 .49778 L F
.52294 .68175 m .53825 .68893 L .52266 .68892 L .688 .667 .824 r
F
.50839 .68179 m .52266 .68892 L .50722 .68896 L .725 .698 .824 r
F
.50839 .68179 m .52294 .68175 L .52266 .68892 L F
.27766 .56481 m .28297 .57237 L .27113 .57155 L .84 .994 .846 r
F
.27766 .56481 m .28913 .56569 L .28297 .57237 L F
.38039 .19749 m .38584 .18879 L .37558 .18424 L .964 .634 .311 r
F
.38039 .19749 m .39028 .20177 L .38584 .18879 L F
.74962 .54582 m .76091 .54476 L .76512 .55149 L .125 .315 .784 r
F
.74637 .53915 m .76091 .54476 L .74962 .54582 L .123 .279 .752 r
F
.456 .71376 m .46754 .72231 L .45251 .72271 L .84 .793 .806 r
F
.456 .71376 m .47032 .71341 L .46754 .72231 L F
.53764 .68176 m .55351 .68899 L .53825 .68893 L .648 .637 .825 r
F
.52294 .68175 m .53764 .68176 L .53825 .68893 L .688 .667 .824 r
F
.48737 .35557 m .49663 .35037 L .48457 .34964 L .789 .481 .468 r
F
.48737 .35557 m .49864 .35624 L .49663 .35037 L F
.28879 .47081 m .29961 .47279 L .30356 .47933 L .904 .49 .152 r
F
.28384 .46417 m .29961 .47279 L .28879 .47081 L .87 .426 .085 r
F
.74193 .49934 m .75162 .50447 L .74088 .50594 L .087 0 .45 r
F
.74193 .49934 m .75273 .49778 L .75162 .50447 L F
.42755 .75286 m .43861 .76274 L .42347 .76359 L .887 .828 .784 r
F
.42755 .75286 m .44208 .7521 L .43861 .76274 L F
.45265 .32666 m .45996 .32045 L .44858 .31885 L .877 .551 .43 r
F
.45265 .32666 m .46342 .32814 L .45996 .32045 L F
.74637 .53915 m .75746 .53803 L .76091 .54476 L .123 .279 .752 r
F
.74384 .53249 m .75746 .53803 L .74637 .53915 L .12 .24 .715 r
F
.50066 .36169 m .51082 .35668 L .49864 .35624 L .749 .449 .475 r
F
.50066 .36169 m .51198 .36209 L .51082 .35668 L F
.59647 .73178 m .61136 .73229 L .61508 .74212 L .483 .496 .796 r
F
.59342 .72245 m .61136 .73229 L .59647 .73178 L .482 .501 .801 r
F
.37966 .85268 m .39105 .8647 L .37511 .867 L .938 .862 .738 r
F
.37966 .85268 m .39509 .85059 L .39105 .8647 L F
.74088 .50594 m .75126 .51117 L .74054 .51256 L .096 .051 .512 r
F
.74088 .50594 m .75162 .50447 L .75126 .51117 L F
.74384 .53249 m .75477 .53131 L .75746 .53803 L .12 .24 .715 r
F
.74203 .52584 m .75477 .53131 L .74384 .53249 L .116 .197 .672 r
F
.28344 .55806 m .28913 .56569 L .27766 .56481 L .868 .99 .827 r
F
.28344 .55806 m .29457 .55901 L .28913 .56569 L F
.42613 .29064 m .43241 .28345 L .42161 .281 L .926 .592 .387 r
F
.42613 .29064 m .43643 .29292 L .43241 .28345 L F
.62988 .78564 m .64502 .78678 L .64928 .79884 L .387 .415 .768 r
F
.62619 .77413 m .64502 .78678 L .62988 .78564 L .386 .418 .772 r
F
.74054 .51256 m .75167 .51787 L .74093 .51919 L .104 .102 .57 r
F
.74054 .51256 m .75126 .51117 L .75167 .51787 L F
.57258 .70478 m .5873 .70503 L .59037 .71353 L .551 .554 .811 r
F
.57027 .69674 m .5873 .70503 L .57258 .70478 L .55 .559 .817 r
F
.74203 .52584 m .75284 .52459 L .75477 .53131 L .116 .197 .672 r
F
.74093 .51919 m .75284 .52459 L .74203 .52584 L .11 .151 .624 r
F
.74093 .51919 m .75167 .51787 L .75284 .52459 L F
.58082 .33614 m .59225 .33492 L .59596 .32761 L .451 .21 .457 r
F
.57777 .34294 m .59225 .33492 L .58082 .33614 L .447 .198 .442 r
F
.60336 .31174 m .6144 .30992 L .61865 .30122 L .345 .123 .426 r
F
.59967 .31989 m .6144 .30992 L .60336 .31174 L .341 .112 .413 r
F
.49443 .68187 m .50722 .68896 L .49241 .68907 L .76 .731 .826 r
F
.49443 .68187 m .50839 .68179 L .50722 .68896 L F
.29297 .47747 m .30356 .47933 L .30679 .48589 L .933 .555 .222 r
F
.28879 .47081 m .30356 .47933 L .29297 .47747 L .904 .49 .152 r
F
.54892 .35654 m .5608 .35602 L .56311 .35013 L .584 .322 .485 r
F
.54743 .36197 m .5608 .35602 L .54892 .35654 L .58 .307 .468 r
F
.53575 .36223 m .54743 .36197 L .54892 .35654 L .631 .357 .485 r
F
.63552 .26225 m .64596 .25932 L .6506 .24834 L .183 0 .371 r
F
.63132 .27262 m .64596 .25932 L .63552 .26225 L .18 0 .36 r
F
.3852 .21031 m .39028 .20177 L .38039 .19749 L .961 .627 .302 r
F
.3852 .21031 m .39472 .21433 L .39028 .20177 L F
.56311 .35013 m .5747 .34931 L .57777 .34294 L .525 .271 .472 r
F
.5608 .35602 m .5747 .34931 L .56311 .35013 L .521 .257 .455 r
F
.47388 .34869 m .48178 .3433 L .47039 .34226 L .829 .507 .445 r
F
.47388 .34869 m .48457 .34964 L .48178 .3433 L F
.68281 .15974 m .69679 .13982 L .68737 .14542 L 0 0 .252 r
F
.4787 .68922 m .49041 .69668 L .4759 .69687 L .798 .764 .822 r
F
.4787 .68922 m .49241 .68907 L .49041 .69668 L F
.28845 .55132 m .29457 .55901 L .28344 .55806 L .894 .982 .804 r
F
.28845 .55132 m .29929 .55232 L .29457 .55901 L F
.38421 .8388 m .39509 .85059 L .37966 .85268 L .938 .865 .741 r
F
.38421 .8388 m .39912 .8369 L .39509 .85059 L F
.29639 .48414 m .30679 .48589 L .3093 .49248 L .958 .618 .292 r
F
.29297 .47747 m .30679 .48589 L .29639 .48414 L .933 .555 .222 r
F
.55351 .68899 m .56796 .68912 L .57027 .69674 L .604 .6 .82 r
F
.55202 .68181 m .56796 .68912 L .55351 .68899 L .603 .606 .827 r
F
.53764 .68176 m .55202 .68181 L .55351 .68899 L .648 .637 .825 r
F
.43164 .74255 m .44208 .7521 L .42755 .75286 L .885 .832 .789 r
F
.43164 .74255 m .44555 .74189 L .44208 .7521 L F
.4595 .70522 m .47032 .71341 L .456 .71376 L .839 .797 .812 r
F
.4595 .70522 m .4731 .70493 L .47032 .71341 L F
.52409 .36725 m .53575 .36223 L .52381 .36227 L .669 .38 .473 r
F
.51315 .36708 m .52381 .36227 L .51198 .36209 L .708 .41 .469 r
F
.51315 .36708 m .52409 .36725 L .52381 .36227 L F
.29269 .54458 m .29929 .55232 L .28845 .55132 L .92 .971 .776 r
F
.29269 .54458 m .3033 .54564 L .29929 .55232 L F
.52322 .675 m .53764 .68176 L .52294 .68175 L .687 .673 .831 r
F
.50955 .67503 m .52294 .68175 L .50839 .68179 L .723 .704 .831 r
F
.50955 .67503 m .52322 .675 L .52294 .68175 L F
.62619 .77413 m .64075 .77515 L .64502 .78678 L .386 .418 .772 r
F
.62249 .76304 m .64075 .77515 L .62619 .77413 L .385 .422 .776 r
F
.85969 .39942 m .85865 .40193 L .84739 .40583 L 0 0 0 r
F
.85969 .39942 m .87161 .39526 L .85865 .40193 L F
.59342 .72245 m .60763 .72289 L .61136 .73229 L .482 .501 .801 r
F
.59037 .71353 m .60763 .72289 L .59342 .72245 L .48 .505 .806 r
F
.45672 .33404 m .46342 .32814 L .45265 .32666 L .873 .539 .415 r
F
.45672 .33404 m .4669 .33541 L .46342 .32814 L F
.53513 .36721 m .54743 .36197 L .53575 .36223 L .626 .341 .466 r
F
.52409 .36725 m .53513 .36721 L .53575 .36223 L .669 .38 .473 r
F
.29905 .49082 m .3093 .49248 L .31108 .49908 L .977 .678 .362 r
F
.29639 .48414 m .3093 .49248 L .29905 .49082 L .958 .618 .292 r
F
.43065 .29986 m .43643 .29292 L .42613 .29064 L .923 .582 .374 r
F
.43065 .29986 m .44047 .30199 L .43643 .29292 L F
.53702 .67501 m .55202 .68181 L .53764 .68176 L .647 .643 .832 r
F
.52322 .675 m .53702 .67501 L .53764 .68176 L .687 .673 .831 r
F
.39002 .22271 m .39472 .21433 L .3852 .21031 L .959 .619 .292 r
F
.39002 .22271 m .39918 .22648 L .39472 .21433 L F
.49018 .36108 m .49864 .35624 L .48737 .35557 L .784 .466 .45 r
F
.49018 .36108 m .50066 .36169 L .49864 .35624 L F
.29617 .53784 m .3033 .54564 L .29269 .54458 L .943 .955 .743 r
F
.29617 .53784 m .30658 .53897 L .3033 .54564 L F
.63132 .27262 m .64132 .26988 L .64596 .25932 L .18 0 .36 r
F
.6271 .28257 m .64132 .26988 L .63132 .27262 L .176 0 .348 r
F
.68281 .15974 m .6919 .15446 L .69679 .13982 L 0 0 .252 r
F
.67823 .17364 m .6919 .15446 L .68281 .15974 L 0 0 .244 r
F
.38876 .82535 m .39912 .8369 L .38421 .8388 L .937 .867 .745 r
F
.38876 .82535 m .40317 .82362 L .39912 .8369 L F
.59967 .31989 m .61015 .3182 L .6144 .30992 L .341 .112 .413 r
F
.59596 .32761 m .61015 .3182 L .59967 .31989 L .337 .1 .399 r
F
.30094 .49751 m .31108 .49908 L .31214 .5057 L .99 .735 .43 r
F
.29905 .49082 m .31108 .49908 L .30094 .49751 L .977 .678 .362 r
F
.57027 .69674 m .58423 .69695 L .5873 .70503 L .55 .559 .817 r
F
.56796 .68912 m .58423 .69695 L .57027 .69674 L .549 .565 .823 r
F
.50268 .36672 m .51198 .36209 L .50066 .36169 L .744 .433 .455 r
F
.50268 .36672 m .51315 .36708 L .51198 .36209 L F
.29889 .5311 m .30658 .53897 L .29617 .53784 L .963 .933 .705 r
F
.29889 .5311 m .30914 .5323 L .30658 .53897 L F
.57777 .34294 m .58853 .34181 L .59225 .33492 L .447 .198 .442 r
F
.5747 .34931 m .58853 .34181 L .57777 .34294 L .442 .184 .425 r
F
.30206 .50421 m .31214 .5057 L .31248 .51233 L .997 .787 .495 r
F
.30094 .49751 m .31214 .5057 L .30206 .50421 L .99 .735 .43 r
F
.49645 .6751 m .50839 .68179 L .49443 .68187 L .758 .737 .833 r
F
.49645 .6751 m .50955 .67503 L .50839 .68179 L F
.30083 .52437 m .30914 .5323 L .29889 .5311 L .979 .906 .661 r
F
.30083 .52437 m .31098 .52563 L .30914 .5323 L F
.43573 .73266 m .44555 .74189 L .43164 .74255 L .884 .836 .794 r
F
.43573 .73266 m .44902 .73209 L .44555 .74189 L F
.30242 .51092 m .31248 .51233 L .31209 .51898 L .997 .833 .555 r
F
.30206 .50421 m .31248 .51233 L .30242 .51092 L .997 .787 .495 r
F
.30201 .51764 m .31098 .52563 L .30083 .52437 L .991 .873 .611 r
F
.30201 .51764 m .31209 .51898 L .31098 .52563 L F
.30242 .51092 m .31209 .51898 L .30201 .51764 L .997 .833 .555 r
F
.62249 .76304 m .63647 .76394 L .64075 .77515 L .385 .422 .776 r
F
.61879 .75237 m .63647 .76394 L .62249 .76304 L .384 .425 .781 r
F
.47739 .3547 m .48457 .34964 L .47388 .34869 L .824 .493 .427 r
F
.47739 .3547 m .48737 .35557 L .48457 .34964 L F
.48151 .682 m .49241 .68907 L .4787 .68922 L .796 .769 .829 r
F
.48151 .682 m .49443 .68187 L .49241 .68907 L F
.54743 .36197 m .55848 .36149 L .5608 .35602 L .58 .307 .468 r
F
.54593 .36697 m .55848 .36149 L .54743 .36197 L .575 .29 .447 r
F
.53513 .36721 m .54593 .36697 L .54743 .36197 L .626 .341 .466 r
F
.5608 .35602 m .57163 .35527 L .5747 .34931 L .521 .257 .455 r
F
.55848 .36149 m .57163 .35527 L .5608 .35602 L .516 .241 .436 r
F
.84739 .40583 m .84647 .40861 L .83581 .41226 L 0 0 0 r
F
.84739 .40583 m .85865 .40193 L .84647 .40861 L F
.46301 .69711 m .4731 .70493 L .4595 .70522 L .837 .802 .818 r
F
.46301 .69711 m .4759 .69687 L .4731 .70493 L F
.39332 .81232 m .40317 .82362 L .38876 .82535 L .936 .87 .748 r
F
.39332 .81232 m .40722 .81077 L .40317 .82362 L F
.67823 .17364 m .68701 .16867 L .6919 .15446 L 0 0 .244 r
F
.67365 .18713 m .68701 .16867 L .67823 .17364 L 0 0 .234 r
F
.39485 .23469 m .39918 .22648 L .39002 .22271 L .956 .611 .282 r
F
.39485 .23469 m .40365 .23822 L .39918 .22648 L F
.43518 .30866 m .44047 .30199 L .43065 .29986 L .919 .57 .36 r
F
.43518 .30866 m .44452 .31063 L .44047 .30199 L F
.59037 .71353 m .6039 .71391 L .60763 .72289 L .48 .505 .806 r
F
.5873 .70503 m .6039 .71391 L .59037 .71353 L .479 .51 .812 r
F
.55202 .68181 m .56564 .68192 L .56796 .68912 L .603 .606 .827 r
F
.55053 .67505 m .56564 .68192 L .55202 .68181 L .601 .612 .834 r
F
.53702 .67501 m .55053 .67505 L .55202 .68181 L .647 .643 .832 r
F
.6271 .28257 m .63666 .28002 L .64132 .26988 L .176 0 .348 r
F
.62288 .2921 m .63666 .28002 L .6271 .28257 L .172 0 .336 r
F
.46081 .341 m .4669 .33541 L .45672 .33404 L .869 .526 .398 r
F
.46081 .341 m .47039 .34226 L .4669 .33541 L F
.5235 .66867 m .53702 .67501 L .52322 .675 L .685 .679 .839 r
F
.51073 .66869 m .52322 .675 L .50955 .67503 L .721 .71 .839 r
F
.51073 .66869 m .5235 .66867 L .52322 .675 L F
.67052 .86553 m .68946 .88277 L .67476 .88014 L .238 .296 .721 r
F
.59596 .32761 m .60589 .32605 L .61015 .3182 L .337 .1 .399 r
F
.59225 .33492 m .60589 .32605 L .59596 .32761 L .333 .086 .383 r
F
.53641 .66868 m .55053 .67505 L .53702 .67501 L .645 .649 .84 r
F
.5235 .66867 m .53641 .66868 L .53702 .67501 L .685 .679 .839 r
F
.52437 .37181 m .53513 .36721 L .52409 .36725 L .664 .361 .45 r
F
.51433 .37166 m .52409 .36725 L .51315 .36708 L .703 .391 .447 r
F
.51433 .37166 m .52437 .37181 L .52409 .36725 L F
.43982 .72321 m .44902 .73209 L .43573 .73266 L .882 .84 .799 r
F
.43982 .72321 m .45251 .72271 L .44902 .73209 L F
.39788 .79974 m .40722 .81077 L .39332 .81232 L .935 .874 .752 r
F
.39788 .79974 m .41127 .79834 L .40722 .81077 L F
.61879 .75237 m .6322 .75317 L .63647 .76394 L .384 .425 .781 r
F
.61508 .74212 m .6322 .75317 L .61879 .75237 L .382 .429 .785 r
F
.56796 .68912 m .58115 .68929 L .58423 .69695 L .549 .565 .823 r
F
.56564 .68192 m .58115 .68929 L .56796 .68912 L .547 .571 .83 r
F
.53451 .37177 m .54593 .36697 L .53513 .36721 L .62 .322 .443 r
F
.52437 .37181 m .53451 .37177 L .53513 .36721 L .664 .361 .45 r
F
.67365 .18713 m .68211 .18246 L .68701 .16867 L 0 0 .234 r
F
.66906 .20021 m .68211 .18246 L .67365 .18713 L 0 0 .224 r
F
.493 .36617 m .50066 .36169 L .49018 .36108 L .779 .448 .428 r
F
.493 .36617 m .50268 .36672 L .50066 .36169 L F
.83581 .41226 m .83506 .4153 L .82496 .41872 L 0 0 0 r
F
.83581 .41226 m .84647 .40861 L .83506 .4153 L F
.39969 .24624 m .40365 .23822 L .39485 .23469 L .952 .602 .27 r
F
.39969 .24624 m .40813 .24954 L .40365 .23822 L F
.5747 .34931 m .58479 .34828 L .58853 .34181 L .442 .184 .425 r
F
.57163 .35527 m .58479 .34828 L .5747 .34931 L .437 .168 .405 r
F
.67052 .86553 m .68475 .86793 L .68946 .88277 L .238 .296 .721 r
F
.66628 .85134 m .68475 .86793 L .67052 .86553 L .237 .299 .725 r
F
.49848 .66875 m .50955 .67503 L .49645 .6751 L .756 .744 .841 r
F
.49848 .66875 m .51073 .66869 L .50955 .67503 L F
.50471 .37133 m .51315 .36708 L .50268 .36672 L .738 .413 .432 r
F
.50471 .37133 m .51433 .37166 L .51315 .36708 L F
.43972 .31703 m .44452 .31063 L .43518 .30866 L .915 .558 .345 r
F
.43972 .31703 m .44858 .31885 L .44452 .31063 L F
.62288 .2921 m .632 .28973 L .63666 .28002 L .172 0 .336 r
F
.61865 .30122 m .632 .28973 L .62288 .2921 L .168 0 .322 r
F
.46652 .68943 m .4759 .69687 L .46301 .69711 L .835 .808 .825 r
F
.46652 .68943 m .4787 .68922 L .4759 .69687 L F
.48433 .6752 m .49443 .68187 L .48151 .682 L .793 .775 .836 r
F
.48433 .6752 m .49645 .6751 L .49443 .68187 L F
.5873 .70503 m .60016 .70535 L .6039 .71391 L .479 .51 .812 r
F
.58423 .69695 m .60016 .70535 L .5873 .70503 L .478 .516 .818 r
F
.48091 .36029 m .48737 .35557 L .47739 .3547 L .819 .475 .406 r
F
.48091 .36029 m .49018 .36108 L .48737 .35557 L F
.40245 .78758 m .41127 .79834 L .39788 .79974 L .934 .877 .756 r
F
.40245 .78758 m .41533 .78634 L .41127 .79834 L F
.54593 .36697 m .55615 .36654 L .55848 .36149 L .575 .29 .447 r
F
.55848 .36149 m .56854 .36081 L .57163 .35527 L .516 .241 .436 r
F
.55615 .36654 m .56854 .36081 L .55848 .36149 L .511 .223 .413 r
F
.66906 .20021 m .6772 .19581 L .68211 .18246 L 0 0 .224 r
F
.66445 .21287 m .6772 .19581 L .66906 .20021 L 0 0 .214 r
F
.54443 .37155 m .55615 .36654 L .54593 .36697 L .569 .271 .422 r
F
.53451 .37177 m .54443 .37155 L .54593 .36697 L .62 .322 .443 r
F
.46491 .34754 m .47039 .34226 L .46081 .341 L .864 .51 .379 r
F
.46491 .34754 m .47388 .34869 L .47039 .34226 L F
.18208 .39454 m .19298 .39873 L .20541 .40518 L .385 0 0 r
F
.55053 .67505 m .56332 .67513 L .56564 .68192 L .601 .612 .834 r
F
.54903 .66871 m .56332 .67513 L .55053 .67505 L .599 .619 .842 r
F
.53641 .66868 m .54903 .66871 L .55053 .67505 L .645 .649 .84 r
F
.61508 .74212 m .62791 .74282 L .6322 .75317 L .382 .429 .785 r
F
.61136 .73229 m .62791 .74282 L .61508 .74212 L .381 .434 .791 r
F
.82496 .41872 m .82444 .422 L .81484 .4252 L 0 0 0 r
F
.82496 .41872 m .83506 .4153 L .82444 .422 L F
.66628 .85134 m .68004 .85353 L .68475 .86793 L .237 .299 .725 r
F
.66204 .83758 m .68004 .85353 L .66628 .85134 L .236 .301 .728 r
F
.44393 .71418 m .45251 .72271 L .43982 .72321 L .88 .844 .805 r
F
.44393 .71418 m .456 .71376 L .45251 .72271 L F
.40453 .25736 m .40813 .24954 L .39969 .24624 L .949 .592 .258 r
F
.40453 .25736 m .41261 .26045 L .40813 .24954 L F
.59225 .33492 m .60161 .33348 L .60589 .32605 L .333 .086 .383 r
F
.58853 .34181 m .60161 .33348 L .59225 .33492 L .328 .071 .364 r
F
.52379 .66276 m .53641 .66868 L .5235 .66867 L .682 .686 .847 r
F
.5119 .66278 m .5235 .66867 L .51073 .66869 L .718 .717 .848 r
F
.5119 .66278 m .52379 .66276 L .5235 .66867 L F
.56564 .68192 m .57807 .68206 L .58115 .68929 L .547 .571 .83 r
F
.56332 .67513 m .57807 .68206 L .56564 .68192 L .545 .577 .838 r
F
.40702 .77586 m .41533 .78634 L .40245 .78758 L .932 .88 .76 r
F
.40702 .77586 m .4194 .77475 L .41533 .78634 L F
.61865 .30122 m .62733 .29901 L .632 .28973 L .168 0 .322 r
F
.6144 .30992 m .62733 .29901 L .61865 .30122 L .163 0 .306 r
F
.53579 .66276 m .54903 .66871 L .53641 .66868 L .642 .656 .849 r
F
.52379 .66276 m .53579 .66276 L .53641 .66868 L .682 .686 .847 r
F
.44427 .32497 m .44858 .31885 L .43972 .31703 L .91 .544 .328 r
F
.44427 .32497 m .45265 .32666 L .44858 .31885 L F
.66445 .21287 m .67228 .20874 L .6772 .19581 L 0 0 .214 r
F
.65984 .22511 m .67228 .20874 L .66445 .21287 L 0 0 .203 r
F
.57163 .35527 m .58105 .35433 L .58479 .34828 L .437 .168 .405 r
F
.56854 .36081 m .58105 .35433 L .57163 .35527 L .431 .149 .383 r
F
.66204 .83758 m .67533 .83956 L .68004 .85353 L .236 .301 .728 r
F
.65779 .82424 m .67533 .83956 L .66204 .83758 L .234 .304 .731 r
F
.52465 .37594 m .53451 .37177 L .52437 .37181 L .657 .339 .423 r
F
.51551 .3758 m .52437 .37181 L .51433 .37166 L .696 .369 .419 r
F
.51551 .3758 m .52465 .37594 L .52437 .37181 L F
.49583 .37083 m .50268 .36672 L .493 .36617 L .772 .427 .402 r
F
.49583 .37083 m .50471 .37133 L .50268 .36672 L F
.19513 .40125 m .20541 .40518 L .21711 .41165 L .415 0 0 r
F
.19513 .40125 m .19769 .40247 L .2074 .40798 L F
.19769 .40247 m .21711 .41165 L .2074 .40798 L F
.2074 .40798 m .20989 .4092 L .21888 .41471 L .448 0 0 r
F
.20989 .4092 m .22806 .41815 L .21888 .41471 L F
.21888 .41471 m .22129 .41594 L .22957 .42144 L .482 0 0 r
F
.22129 .41594 m .23828 .42467 L .22957 .42144 L F
.22957 .42144 m .23189 .42269 L .23947 .42819 L .519 0 0 r
F
.23189 .42269 m .24775 .43121 L .23947 .42819 L F
.23947 .42819 m .24171 .42945 L .24858 .43493 L .558 .001 0 r
F
.24171 .42945 m .25648 .43776 L .24858 .43493 L F
.24858 .43493 m .25072 .4362 L .2569 .44169 L .6 .053 0 r
F
.25072 .4362 m .26445 .44434 L .2569 .44169 L F
.2569 .44169 m .25894 .44296 L .26443 .44844 L .643 .11 0 r
F
.25894 .44296 m .27167 .45093 L .26443 .44844 L F
.26443 .44844 m .26637 .44973 L .27117 .45521 L .689 .172 0 r
F
.26637 .44973 m .27813 .45754 L .27117 .45521 L F
.27598 .4607 m .27117 .45521 L .27711 .46197 L .535 .056 0 r
F
.26994 .45395 m .26443 .44844 L .27117 .45521 L 0 .006 .509 r
F
.26443 .44844 m .27167 .45093 L .27813 .45754 L .689 .172 0 r
F
.26209 .44587 m .26337 .44719 L .26898 .45279 L 0 .006 .509 r
F
.26337 .44719 m .27117 .45521 L .26898 .45279 L F
.27015 .45412 m .27117 .45521 L .27598 .4607 L .535 .056 0 r
F
.26898 .45279 m .26934 .45319 L .27015 .45412 L F
.26934 .45319 m .27117 .45521 L .27015 .45412 L F
.27711 .46197 m .28879 .47081 L .28225 .46874 L .782 .311 0 r
F
.27611 .46103 m .27711 .46197 L .28225 .46874 L .581 .125 0 r
F
.27505 .4597 m .27539 .46009 L .27611 .46103 L F
.27539 .46009 m .27711 .46197 L .27611 .46103 L F
.28124 .46794 m .28225 .46874 L .28661 .47552 L .628 .2 0 r
F
.2803 .46661 m .28064 .46698 L .28124 .46794 L F
.28064 .46698 m .28225 .46874 L .28124 .46794 L F
.28556 .47483 m .28661 .47552 L .29016 .4823 L .675 .283 0 r
F
.28475 .47351 m .28507 .47386 L .28556 .47483 L F
.28507 .47386 m .28661 .47552 L .28556 .47483 L F
.28838 .4804 m .28907 .48172 L .29119 .48729 L .719 .369 0 r
F
.28907 .48172 m .29292 .48908 L .29119 .48729 L F
.29119 .48729 m .29176 .48861 L .29319 .49417 L .758 .459 0 r
F
.29176 .48861 m .29489 .49587 L .29319 .49417 L F
.29319 .49417 m .29364 .49548 L .29439 .50105 L .79 .547 0 r
F
.29364 .49548 m .29606 .50266 L .29439 .50105 L F
.29439 .50105 m .2947 .50235 L .29476 .50793 L .812 .63 .076 r
F
.2947 .50235 m .29643 .50945 L .29476 .50793 L F
.29476 .50793 m .29495 .50921 L .29433 .51481 L .822 .705 .17 r
F
.29495 .50921 m .296 .51625 L .29433 .51481 L F
.29433 .51481 m .2944 .51607 L .29308 .52168 L .821 .769 .259 r
F
.2944 .51607 m .29478 .52304 L .29308 .52168 L F
.29308 .52168 m .29303 .52292 L .29102 .52855 L .809 .82 .341 r
F
.29303 .52292 m .29276 .52984 L .29102 .52855 L F
.29102 .52855 m .29086 .52977 L .28814 .53543 L .789 .859 .413 r
F
.29086 .52977 m .28994 .53665 L .28814 .53543 L F
.28814 .53543 m .28787 .53662 L .28445 .5423 L .762 .886 .475 r
F
.28787 .53662 m .28632 .54345 L .28445 .5423 L F
.28445 .5423 m .28408 .54347 L .27995 .54917 L .732 .904 .527 r
F
.28408 .54347 m .2819 .55026 L .27995 .54917 L F
.27995 .54917 m .27948 .55031 L .27462 .55605 L .7 .914 .57 r
F
.27948 .55031 m .27669 .55707 L .27462 .55605 L F
.27462 .55605 m .27406 .55715 L .26848 .56292 L .667 .918 .606 r
F
.27406 .55715 m .27068 .56388 L .26848 .56292 L F
.26848 .56292 m .26784 .564 L .26151 .5698 L .635 .918 .634 r
F
.26784 .564 m .26386 .57069 L .26151 .5698 L F
.26151 .5698 m .2608 .57084 L .25373 .57669 L .604 .914 .658 r
F
.2608 .57084 m .25626 .5775 L .25373 .57669 L F
.25373 .57669 m .25296 .57769 L .24512 .58357 L .574 .909 .676 r
F
.25296 .57769 m .24785 .58432 L .24512 .58357 L F
.24512 .58357 m .24429 .58454 L .23569 .59047 L .547 .902 .691 r
F
.24429 .58454 m .23865 .59113 L .23569 .59047 L F
.23569 .59047 m .23481 .59139 L .22542 .59736 L .52 .894 .703 r
F
.23481 .59139 m .22865 .59795 L .22542 .59736 L F
.22542 .59736 m .22451 .59825 L .21433 .60427 L .496 .885 .713 r
F
.22451 .59825 m .21785 .60476 L .21433 .60427 L F
.21433 .60427 m .21339 .60512 L .20241 .61118 L .473 .877 .721 r
F
.21339 .60512 m .20625 .61157 L .20241 .61118 L F
.20241 .61118 m .20144 .61199 L .18965 .6181 L .451 .868 .727 r
F
.20144 .61199 m .19386 .61839 L .18965 .6181 L F
.18965 .6181 m .18068 .6252 L .17605 .62502 L .431 .859 .731 r
F
.1778 .62423 m .18965 .6181 L .17605 .62502 L 0 0 0 r
F
.18965 .6181 m .19386 .61839 L .18068 .6252 L .431 .859 .731 r
F
.19197 .6178 m .18965 .6181 L .1778 .62423 L 0 0 0 r
F
.19137 .61727 m .20241 .61118 L .18965 .6181 L F
.20241 .61118 m .20625 .61157 L .19386 .61839 L .451 .868 .727 r
F
.20485 .61077 m .20241 .61118 L .19137 .61727 L 0 0 0 r
F
.2041 .61031 m .21433 .60427 L .20241 .61118 L F
.21433 .60427 m .21785 .60476 L .20625 .61157 L .473 .877 .721 r
F
.21688 .60377 m .21433 .60427 L .2041 .61031 L 0 0 0 r
F
.21599 .60336 m .22542 .59736 L .21433 .60427 L F
.22542 .59736 m .22865 .59795 L .21785 .60476 L .496 .885 .713 r
F
.22805 .59677 m .22542 .59736 L .21599 .60336 L 0 0 0 r
F
.22704 .59642 m .23569 .59047 L .22542 .59736 L F
.23569 .59047 m .23865 .59113 L .22865 .59795 L .52 .894 .703 r
F
.23838 .58979 m .23569 .59047 L .22704 .59642 L 0 0 0 r
F
.23725 .58949 m .24512 .58357 L .23569 .59047 L F
.24512 .58357 m .24785 .58432 L .23865 .59113 L .547 .902 .691 r
F
.24786 .58282 m .24512 .58357 L .23725 .58949 L 0 0 0 r
F
.24662 .58256 m .25373 .57669 L .24512 .58357 L F
.25373 .57669 m .25626 .5775 L .24785 .58432 L .574 .909 .676 r
F
.25651 .57586 m .25373 .57669 L .24662 .58256 L 0 0 0 r
F
.25516 .57563 m .26151 .5698 L .25373 .57669 L F
.26151 .5698 m .26386 .57069 L .25626 .5775 L .604 .914 .658 r
F
.26432 .5689 m .26151 .5698 L .25516 .57563 L 0 0 0 r
F
.26287 .56872 m .26848 .56292 L .26151 .5698 L F
.26848 .56292 m .27068 .56388 L .26386 .57069 L .635 .918 .634 r
F
.27131 .56195 m .26848 .56292 L .26287 .56872 L 0 0 0 r
F
.26974 .56181 m .27462 .55605 L .26848 .56292 L F
.27462 .55605 m .27669 .55707 L .27068 .56388 L .667 .918 .606 r
F
.27746 .55501 m .27462 .55605 L .26974 .56181 L 0 0 0 r
F
.27579 .5549 m .27995 .54917 L .27462 .55605 L F
.28445 .5423 m .28632 .54345 L .2819 .55026 L .732 .904 .527 r
F
.27995 .54917 m .2819 .55026 L .27669 .55707 L .7 .914 .57 r
F
.28279 .54807 m .27995 .54917 L .27579 .5549 L 0 0 0 r
F
.28102 .548 m .28445 .5423 L .27995 .54917 L F
.28814 .53543 m .28994 .53665 L .28632 .54345 L .762 .886 .475 r
F
.28731 .54113 m .28445 .5423 L .28102 .548 L 0 0 0 r
F
.28542 .5411 m .28814 .53543 L .28445 .5423 L F
.29276 .52984 m .29617 .53784 L .28994 .53665 L .935 .946 .61 r
F
.29102 .52855 m .29276 .52984 L .28994 .53665 L .789 .859 .413 r
F
.291 .53419 m .28814 .53543 L .28542 .5411 L 0 0 0 r
F
.289 .5342 m .29102 .52855 L .28814 .53543 L F
.29478 .52304 m .29889 .5311 L .29276 .52984 L .957 .915 .555 r
F
.29308 .52168 m .29478 .52304 L .29276 .52984 L .809 .82 .341 r
F
.29388 .52725 m .29102 .52855 L .289 .5342 L 0 0 0 r
F
.29176 .52731 m .29308 .52168 L .29102 .52855 L F
.296 .51625 m .30083 .52437 L .29478 .52304 L .972 .875 .491 r
F
.29433 .51481 m .296 .51625 L .29478 .52304 L .821 .769 .259 r
F
.29594 .5203 m .29308 .52168 L .29176 .52731 L 0 0 0 r
F
.2937 .52042 m .29433 .51481 L .29308 .52168 L 0 0 .055 r
F
.29643 .50945 m .30201 .51764 L .296 .51625 L .978 .825 .419 r
F
.29476 .50793 m .29643 .50945 L .296 .51625 L .822 .705 .17 r
F
.29718 .51336 m .29433 .51481 L .2937 .52042 L 0 0 .055 r
F
.29483 .51354 m .29476 .50793 L .29433 .51481 L 0 0 .148 r
F
.29606 .50266 m .30242 .51092 L .29643 .50945 L .975 .765 .341 r
F
.29439 .50105 m .29606 .50266 L .29643 .50945 L .812 .63 .076 r
F
.29762 .5064 m .29476 .50793 L .29483 .51354 L 0 0 .148 r
F
.29514 .50665 m .29439 .50105 L .29476 .50793 L 0 0 .241 r
F
.29606 .50266 m .30206 .50421 L .30242 .51092 L .975 .765 .341 r
F
.29489 .49587 m .30206 .50421 L .29606 .50266 L .962 .697 .259 r
F
.29319 .49417 m .29489 .49587 L .29606 .50266 L .79 .547 0 r
F
.29724 .49944 m .29439 .50105 L .29514 .50665 L 0 0 .241 r
F
.29464 .49976 m .29319 .49417 L .29439 .50105 L 0 0 .329 r
F
.29489 .49587 m .30094 .49751 L .30206 .50421 L .962 .697 .259 r
F
.29292 .48908 m .30094 .49751 L .29489 .49587 L .939 .623 .174 r
F
.29119 .48729 m .29292 .48908 L .29489 .49587 L .758 .459 0 r
F
.29605 .49246 m .29319 .49417 L .29464 .49976 L 0 0 .329 r
F
.29332 .49288 m .29119 .48729 L .29319 .49417 L 0 0 .409 r
F
.29016 .4823 m .29639 .48414 L .29905 .49082 L .908 .545 .09 r
F
.29292 .48908 m .29905 .49082 L .30094 .49751 L .939 .623 .174 r
F
.29016 .4823 m .29905 .49082 L .29292 .48908 L .908 .545 .09 r
F
.28838 .4804 m .29016 .4823 L .29292 .48908 L .719 .369 0 r
F
.29405 .48548 m .29119 .48729 L .29332 .49288 L 0 0 .409 r
F
.2912 .48599 m .28838 .4804 L .29119 .48729 L 0 0 .481 r
F
.28661 .47552 m .29297 .47747 L .29639 .48414 L .87 .465 .009 r
F
.28661 .47552 m .29639 .48414 L .29016 .4823 L F
.28475 .47351 m .29016 .4823 L .28838 .4804 L .675 .283 0 r
F
.29123 .47849 m .28838 .4804 L .2912 .48599 L 0 0 .481 r
F
.28826 .4791 m .28475 .47351 L .28838 .4804 L 0 0 .543 r
F
.28225 .46874 m .28879 .47081 L .29297 .47747 L .827 .387 0 r
F
.28225 .46874 m .29297 .47747 L .28661 .47552 L F
.2803 .46661 m .28661 .47552 L .28475 .47351 L .628 .2 0 r
F
.2876 .47148 m .28475 .47351 L .28826 .4791 L 0 0 .543 r
F
.28452 .47221 m .2803 .46661 L .28475 .47351 L 0 .028 .595 r
F
.27711 .46197 m .28384 .46417 L .28879 .47081 L .782 .311 0 r
F
.27505 .4597 m .28225 .46874 L .2803 .46661 L .581 .125 0 r
F
.28315 .46445 m .2803 .46661 L .28452 .47221 L 0 .028 .595 r
F
.27996 .46531 m .27505 .4597 L .2803 .46661 L 0 .089 .639 r
F
.27117 .45521 m .27813 .45754 L .28384 .46417 L .735 .239 0 r
F
.27117 .45521 m .28384 .46417 L .27711 .46197 L F
.26898 .45279 m .27711 .46197 L .27505 .4597 L .535 .056 0 r
F
.27789 .45741 m .27505 .4597 L .27996 .46531 L 0 .089 .639 r
F
.2746 .45841 m .26898 .45279 L .27505 .4597 L 0 .143 .675 r
F
.2569 .44169 m .26445 .44434 L .27167 .45093 L .643 .11 0 r
F
.27181 .45035 m .26898 .45279 L .2746 .45841 L 0 .143 .675 r
F
.26209 .44587 m .26443 .44844 L .26994 .45395 L 0 .006 .509 r
F
.26311 .44719 m .2569 .44169 L .26443 .44844 L 0 .062 .548 r
F
.25439 .43894 m .2569 .44169 L .26311 .44719 L F
.25549 .44045 m .24858 .43493 L .2569 .44169 L 0 .112 .582 r
F
.24858 .43493 m .25648 .43776 L .26445 .44434 L .6 .053 0 r
F
.24587 .43201 m .24858 .43493 L .25549 .44045 L 0 .112 .582 r
F
.24708 .4337 m .23947 .42819 L .24858 .43493 L 0 .156 .612 r
F
.22957 .42144 m .23828 .42467 L .24775 .43121 L .519 0 0 r
F
.23947 .42819 m .24775 .43121 L .25648 .43776 L .558 .001 0 r
F
.23653 .42506 m .23947 .42819 L .24708 .4337 L 0 .156 .612 r
F
.23789 .42697 m .22957 .42144 L .23947 .42819 L 0 .195 .637 r
F
.21888 .41471 m .22806 .41815 L .23828 .42467 L .482 0 0 r
F
.22637 .41811 m .22957 .42144 L .23789 .42697 L 0 .195 .637 r
F
.22791 .42024 m .21888 .41471 L .22957 .42144 L 0 .231 .659 r
F
.2074 .40798 m .21711 .41165 L .22806 .41815 L .448 0 0 r
F
.21539 .41114 m .21888 .41471 L .22791 .42024 L 0 .231 .659 r
F
.21715 .41351 m .2074 .40798 L .21888 .41471 L 0 .263 .678 r
F
.18471 .39574 m .20541 .40518 L .19513 .40125 L .385 0 0 r
F
.20359 .40416 m .2074 .40798 L .21715 .41351 L 0 .263 .678 r
F
.2056 .4068 m .19513 .40125 L .2074 .40798 L 0 .291 .695 r
F
.19096 .39717 m .19513 .40125 L .2056 .4068 L F
.18208 .39454 m .18471 .39574 L .19513 .40125 L .385 0 0 r
F
.81484 .4252 m .8146 .42871 L .80545 .4317 L 0 0 0 r
F
.81484 .4252 m .82444 .422 L .8146 .42871 L F
.47004 .68217 m .4787 .68922 L .46652 .68943 L .832 .813 .832 r
F
.47004 .68217 m .48151 .682 L .4787 .68922 L F
.58423 .69695 m .59641 .69722 L .60016 .70535 L .478 .516 .818 r
F
.58115 .68929 m .59641 .69722 L .58423 .69695 L .476 .522 .825 r
F
.53389 .37591 m .54443 .37155 L .53451 .37177 L .613 .3 .415 r
F
.52465 .37594 m .53389 .37591 L .53451 .37177 L .657 .339 .423 r
F
.84859 .61872 m .873 .62523 L .86101 .6254 L 0 .45 .85 r
F
.40938 .26805 m .41261 .26045 L .40453 .25736 L .944 .581 .245 r
F
.40938 .26805 m .41711 .27093 L .41261 .26045 L F
.61136 .73229 m .62362 .7329 L .62791 .74282 L .381 .434 .791 r
F
.60763 .72289 m .62362 .7329 L .61136 .73229 L .38 .439 .796 r
F
.48715 .66883 m .49645 .6751 L .48433 .6752 L .79 .782 .845 r
F
.48715 .66883 m .49848 .66875 L .49645 .6751 L F
.50051 .66282 m .51073 .66869 L .49848 .66875 L .753 .751 .85 r
F
.50051 .66282 m .5119 .66278 L .51073 .66869 L F
.44804 .70558 m .456 .71376 L .44393 .71418 L .878 .849 .811 r
F
.44804 .70558 m .4595 .70522 L .456 .71376 L F
.48443 .36545 m .49018 .36108 L .48091 .36029 L .812 .455 .381 r
F
.48443 .36545 m .493 .36617 L .49018 .36108 L F
.46902 .35364 m .47388 .34869 L .46491 .34754 L .858 .492 .357 r
F
.46902 .35364 m .47739 .3547 L .47388 .34869 L F
.50675 .37551 m .51433 .37166 L .50471 .37133 L .731 .39 .403 r
F
.50675 .37551 m .51551 .3758 L .51433 .37166 L F
.41159 .76457 m .4194 .77475 L .40702 .77586 L .931 .884 .765 r
F
.41159 .76457 m .42347 .76359 L .4194 .77475 L F
.65779 .82424 m .67062 .82604 L .67533 .83956 L .234 .304 .731 r
F
.65354 .81133 m .67062 .82604 L .65779 .82424 L .233 .307 .735 r
F
.58853 .34181 m .59733 .34049 L .60161 .33348 L .328 .071 .364 r
F
.58479 .34828 m .59733 .34049 L .58853 .34181 L .322 .055 .344 r
F
.54443 .37155 m .55381 .37116 L .55615 .36654 L .569 .271 .422 r
F
.55615 .36654 m .56545 .36592 L .56854 .36081 L .511 .223 .413 r
F
.55381 .37116 m .56545 .36592 L .55615 .36654 L .503 .201 .386 r
F
.65984 .22511 m .66736 .22124 L .67228 .20874 L 0 0 .203 r
F
.65522 .23694 m .66736 .22124 L .65984 .22511 L 0 0 .191 r
F
.54903 .66871 m .56098 .66877 L .56332 .67513 L .599 .619 .842 r
F
.54753 .66279 m .56098 .66877 L .54903 .66871 L .596 .626 .852 r
F
.53579 .66276 m .54753 .66279 L .54903 .66871 L .642 .656 .849 r
F
.6144 .30992 m .62265 .30787 L .62733 .29901 L .163 0 .306 r
F
.61015 .3182 m .62265 .30787 L .6144 .30992 L .158 0 .289 r
F
.80545 .4317 m .80554 .43542 L .79681 .43823 L 0 0 0 r
F
.80545 .4317 m .8146 .42871 L .80554 .43542 L F
.54293 .37571 m .55381 .37116 L .54443 .37155 L .561 .247 .393 r
F
.53389 .37591 m .54293 .37571 L .54443 .37155 L .613 .3 .415 r
F
.84859 .61872 m .85991 .61844 L .873 .62523 L 0 .45 .85 r
F
.83689 .61202 m .85991 .61844 L .84859 .61872 L 0 .439 .849 r
F
.44883 .33248 m .45265 .32666 L .44427 .32497 L .904 .529 .309 r
F
.44883 .33248 m .45672 .33404 L .45265 .32666 L F
.41424 .27831 m .41711 .27093 L .40938 .26805 L .94 .569 .231 r
F
.41424 .27831 m .42161 .281 L .41711 .27093 L F
.56332 .67513 m .57497 .67525 L .57807 .68206 L .545 .577 .838 r
F
.56098 .66877 m .57497 .67525 L .56332 .67513 L .543 .585 .846 r
F
.60763 .72289 m .61932 .72341 L .62362 .7329 L .38 .439 .796 r
F
.6039 .71391 m .61932 .72341 L .60763 .72289 L .378 .444 .802 r
F
.65354 .81133 m .6659 .81295 L .67062 .82604 L .233 .307 .735 r
F
.64928 .79884 m .6659 .81295 L .65354 .81133 L .232 .311 .739 r
F
.52407 .65727 m .53579 .66276 L .52379 .66276 L .679 .694 .857 r
F
.51308 .65728 m .52379 .66276 L .5119 .66278 L .715 .725 .858 r
F
.51308 .65728 m .52407 .65727 L .52379 .66276 L F
.58115 .68929 m .59265 .68952 L .59641 .69722 L .476 .522 .825 r
F
.57807 .68206 m .59265 .68952 L .58115 .68929 L .474 .528 .833 r
F
.41617 .75372 m .42347 .76359 L .41159 .76457 L .929 .888 .77 r
F
.41617 .75372 m .42755 .75286 L .42347 .76359 L F
.56854 .36081 m .57729 .35994 L .58105 .35433 L .431 .149 .383 r
F
.56545 .36592 m .57729 .35994 L .56854 .36081 L .424 .128 .356 r
F
.47357 .67534 m .48151 .682 L .47004 .68217 L .829 .819 .84 r
F
.47357 .67534 m .48433 .6752 L .48151 .682 L F
.53517 .65727 m .54753 .66279 L .53579 .66276 L .639 .665 .858 r
F
.52407 .65727 m .53517 .65727 L .53579 .66276 L .679 .694 .857 r
F
.45216 .69741 m .4595 .70522 L .44804 .70558 L .876 .854 .818 r
F
.45216 .69741 m .46301 .69711 L .4595 .70522 L F
.65522 .23694 m .66244 .23331 L .66736 .22124 L 0 0 .191 r
F
.6506 .24834 m .66244 .23331 L .65522 .23694 L 0 0 .178 r
F
.79681 .43823 m .79727 .44214 L .78891 .44478 L 0 0 0 r
F
.79681 .43823 m .80554 .43542 L .79727 .44214 L F
.83689 .61202 m .8476 .61164 L .85991 .61844 L 0 .439 .849 r
F
.82593 .60531 m .8476 .61164 L .83689 .61202 L 0 .426 .847 r
F
.49867 .37506 m .50471 .37133 L .49583 .37083 L .763 .401 .371 r
F
.49867 .37506 m .50675 .37551 L .50471 .37133 L F
.48998 .66288 m .49848 .66875 L .48715 .66883 L .787 .789 .854 r
F
.48998 .66288 m .50051 .66282 L .49848 .66875 L F
.52494 .37965 m .53389 .37591 L .52465 .37594 L .648 .312 .39 r
F
.51669 .37953 m .52465 .37594 L .51551 .3758 L .686 .342 .386 r
F
.51669 .37953 m .52494 .37965 L .52465 .37594 L F
.47314 .35932 m .47739 .3547 L .46902 .35364 L .85 .471 .332 r
F
.47314 .35932 m .48091 .36029 L .47739 .3547 L F
.61015 .3182 m .61797 .3163 L .62265 .30787 L .158 0 .289 r
F
.60589 .32605 m .61797 .3163 L .61015 .3182 L .153 0 .271 r
F
.58479 .34828 m .59304 .34706 L .59733 .34049 L .322 .055 .344 r
F
.58105 .35433 m .59304 .34706 L .58479 .34828 L .315 .036 .32 r
F
.64928 .79884 m .66119 .80029 L .6659 .81295 L .232 .311 .739 r
F
.64502 .78678 m .66119 .80029 L .64928 .79884 L .231 .314 .743 r
F
.4191 .28813 m .42161 .281 L .41424 .27831 L .934 .557 .216 r
F
.4191 .28813 m .42613 .29064 L .42161 .281 L F
.50255 .65731 m .5119 .66278 L .50051 .66282 L .749 .759 .86 r
F
.50255 .65731 m .51308 .65728 L .5119 .66278 L F
.53327 .37962 m .54293 .37571 L .53389 .37591 L .604 .272 .381 r
F
.52494 .37965 m .53327 .37962 L .53389 .37591 L .648 .312 .39 r
F
.48797 .37018 m .493 .36617 L .48443 .36545 L .803 .43 .352 r
F
.48797 .37018 m .49583 .37083 L .493 .36617 L F
.4534 .33957 m .45672 .33404 L .44883 .33248 L .897 .511 .288 r
F
.4534 .33957 m .46081 .341 L .45672 .33404 L F
.42075 .7433 m .42755 .75286 L .41617 .75372 L .927 .892 .775 r
F
.42075 .7433 m .43164 .74255 L .42755 .75286 L F
.6039 .71391 m .61502 .71436 L .61932 .72341 L .378 .444 .802 r
F
.60016 .70535 m .61502 .71436 L .6039 .71391 L .377 .45 .809 r
F
.6506 .24834 m .65751 .24494 L .66244 .23331 L 0 0 .178 r
F
.64596 .25932 m .65751 .24494 L .6506 .24834 L 0 0 .165 r
F
.78891 .44478 m .78979 .44887 L .78175 .45134 L 0 0 0 r
F
.78891 .44478 m .79727 .44214 L .78979 .44887 L F
.54293 .37571 m .55147 .37536 L .55381 .37116 L .561 .247 .393 r
F
.55381 .37116 m .56234 .3706 L .56545 .36592 L .503 .201 .386 r
F
.55147 .37536 m .56234 .3706 L .55381 .37116 L .494 .174 .354 r
F
.5088 .37927 m .51551 .3758 L .50675 .37551 L .72 .361 .368 r
F
.5088 .37927 m .51669 .37953 L .51551 .3758 L F
.82593 .60531 m .83609 .60484 L .8476 .61164 L 0 .426 .847 r
F
.81571 .5986 m .83609 .60484 L .82593 .60531 L 0 .411 .843 r
F
.54753 .66279 m .55864 .66284 L .56098 .66877 L .596 .626 .852 r
F
.54603 .65729 m .55864 .66284 L .54753 .66279 L .593 .635 .862 r
F
.53517 .65727 m .54603 .65729 L .54753 .66279 L .639 .665 .858 r
F
.36023 .151 m .3612 .14196 L .35522 .13615 L .887 .55 .056 r
F
.36023 .151 m .36599 .15647 L .3612 .14196 L F
.45628 .68968 m .46301 .69711 L .45216 .69741 L .873 .86 .825 r
F
.45628 .68968 m .46652 .68943 L .46301 .69711 L F
.56098 .66877 m .57187 .66887 L .57497 .67525 L .543 .585 .846 r
F
.55864 .66284 m .57187 .66887 L .56098 .66877 L .54 .593 .856 r
F
.64502 .78678 m .65647 .78808 L .66119 .80029 L .231 .314 .743 r
F
.64075 .77515 m .65647 .78808 L .64502 .78678 L .229 .318 .748 r
F
.57807 .68206 m .58889 .68224 L .59265 .68952 L .474 .528 .833 r
F
.57497 .67525 m .58889 .68224 L .57807 .68206 L .472 .535 .841 r
F
.54142 .37945 m .55147 .37536 L .54293 .37571 L .55 .217 .357 r
F
.53327 .37962 m .54142 .37945 L .54293 .37571 L .604 .272 .381 r
F
.47711 .66893 m .48433 .6752 L .47357 .67534 L .825 .826 .849 r
F
.47711 .66893 m .48715 .66883 L .48433 .6752 L F
.42397 .29753 m .42613 .29064 L .4191 .28813 L .928 .543 .199 r
F
.42397 .29753 m .43065 .29986 L .42613 .29064 L F
.56545 .36592 m .57352 .36514 L .57729 .35994 L .424 .128 .356 r
F
.56234 .3706 m .57352 .36514 L .56545 .36592 L .415 .103 .325 r
F
.60589 .32605 m .61328 .32429 L .61797 .3163 L .153 0 .271 r
F
.60161 .33348 m .61328 .32429 L .60589 .32605 L .147 0 .25 r
F
.78175 .45134 m .78309 .45561 L .77534 .45793 L 0 0 0 r
F
.78175 .45134 m .78979 .44887 L .78309 .45561 L F
.19386 .61839 m .19165 .62538 L .18068 .6252 L .551 .931 .837 r
F
.19386 .61839 m .2042 .61867 L .19165 .62538 L F
.81571 .5986 m .82536 .59804 L .83609 .60484 L 0 .411 .843 r
F
.80624 .59188 m .82536 .59804 L .81571 .5986 L 0 .394 .838 r
F
.52435 .65221 m .53517 .65727 L .52407 .65727 L .675 .703 .868 r
F
.51426 .65222 m .52407 .65727 L .51308 .65728 L .711 .734 .869 r
F
.51426 .65222 m .52435 .65221 L .52407 .65727 L F
.42534 .73332 m .43164 .74255 L .42075 .7433 L .925 .896 .781 r
F
.42534 .73332 m .43573 .73266 L .43164 .74255 L F
.64596 .25932 m .65257 .25615 L .65751 .24494 L 0 0 .165 r
F
.64132 .26988 m .65257 .25615 L .64596 .25932 L 0 0 .15 r
F
.58105 .35433 m .58874 .35321 L .59304 .34706 L .315 .036 .32 r
F
.57729 .35994 m .58874 .35321 L .58105 .35433 L .307 .014 .293 r
F
.53455 .65221 m .54603 .65729 L .53517 .65727 L .636 .674 .869 r
F
.52435 .65221 m .53455 .65221 L .53517 .65727 L .675 .703 .868 r
F
.36525 .16541 m .36599 .15647 L .36023 .151 L .883 .542 .046 r
F
.36525 .16541 m .37078 .17056 L .36599 .15647 L F
.47727 .36457 m .48091 .36029 L .47314 .35932 L .84 .446 .303 r
F
.47727 .36457 m .48443 .36545 L .48091 .36029 L F
.60016 .70535 m .61071 .70573 L .61502 .71436 L .377 .45 .809 r
F
.59641 .69722 m .61071 .70573 L .60016 .70535 L .375 .456 .816 r
F
.45797 .34622 m .46081 .341 L .4534 .33957 L .888 .491 .264 r
F
.45797 .34622 m .46491 .34754 L .46081 .341 L F
.64075 .77515 m .65174 .7763 L .65647 .78808 L .229 .318 .748 r
F
.63647 .76394 m .65174 .7763 L .64075 .77515 L .228 .322 .753 r
F
.49282 .65736 m .50051 .66282 L .48998 .66288 L .783 .797 .864 r
F
.49282 .65736 m .50255 .65731 L .50051 .66282 L F
.50151 .37887 m .50675 .37551 L .49867 .37506 L .751 .37 .333 r
F
.50151 .37887 m .5088 .37927 L .50675 .37551 L F
.77534 .45793 m .77718 .46235 L .76969 .46453 L 0 0 0 r
F
.77534 .45793 m .78309 .45561 L .77718 .46235 L F
.49152 .37448 m .49583 .37083 L .48797 .37018 L .791 .401 .316 r
F
.49152 .37448 m .49867 .37506 L .49583 .37083 L F
.80624 .59188 m .81542 .59124 L .82536 .59804 L 0 .394 .838 r
F
.7975 .58516 m .81542 .59124 L .80624 .59188 L 0 .374 .831 r
F
.5046 .65224 m .51308 .65728 L .50255 .65731 L .745 .767 .871 r
F
.5046 .65224 m .51426 .65222 L .51308 .65728 L F
.20625 .61157 m .2042 .61867 L .19386 .61839 L .575 .941 .835 r
F
.20625 .61157 m .21601 .61196 L .2042 .61867 L F
.42885 .30649 m .43065 .29986 L .42397 .29753 L .921 .527 .181 r
F
.42885 .30649 m .43518 .30866 L .43065 .29986 L F
.52522 .38293 m .53327 .37962 L .52494 .37965 L .636 .279 .349 r
F
.51788 .38282 m .52494 .37965 L .51669 .37953 L .673 .307 .344 r
F
.51788 .38282 m .52522 .38293 L .52494 .37965 L F
.46041 .68237 m .46652 .68943 L .45628 .68968 L .869 .866 .833 r
F
.46041 .68237 m .47004 .68217 L .46652 .68943 L F
.53264 .3829 m .54142 .37945 L .53327 .37962 L .591 .238 .339 r
F
.52522 .38293 m .53264 .3829 L .53327 .37962 L .636 .279 .349 r
F
.64132 .26988 m .64762 .26692 L .65257 .25615 L 0 0 .15 r
F
.63666 .28002 m .64762 .26692 L .64132 .26988 L 0 0 .134 r
F
.37027 .17939 m .37078 .17056 L .36525 .16541 L .878 .532 .035 r
F
.37027 .17939 m .37558 .18424 L .37078 .17056 L F
.42993 .72377 m .43573 .73266 L .42534 .73332 L .922 .9 .787 r
F
.42993 .72377 m .43982 .72321 L .43573 .73266 L F
.57497 .67525 m .58512 .6754 L .58889 .68224 L .472 .535 .841 r
F
.57187 .66887 m .58512 .6754 L .57497 .67525 L .469 .543 .85 r
F
.60161 .33348 m .60857 .33186 L .61328 .32429 L .147 0 .25 r
F
.59733 .34049 m .60857 .33186 L .60161 .33348 L .14 0 .226 r
F
.54142 .37945 m .54911 .37913 L .55147 .37536 L .55 .217 .357 r
F
.55147 .37536 m .55923 .37486 L .56234 .3706 L .494 .174 .354 r
F
.54911 .37913 m .55923 .37486 L .55147 .37536 L .482 .143 .314 r
F
.63647 .76394 m .64702 .76497 L .65174 .7763 L .228 .322 .753 r
F
.6322 .75317 m .64702 .76497 L .63647 .76394 L .227 .327 .758 r
F
.54603 .65729 m .5563 .65733 L .55864 .66284 L .593 .635 .862 r
F
.54452 .65222 m .5563 .65733 L .54603 .65729 L .589 .644 .873 r
F
.53455 .65221 m .54452 .65222 L .54603 .65729 L .636 .674 .869 r
F
.76969 .46453 m .77206 .4691 L .76478 .47116 L 0 0 0 r
F
.76969 .46453 m .77718 .46235 L .77206 .4691 L F
.7975 .58516 m .80627 .58444 L .81542 .59124 L 0 .374 .831 r
F
.78952 .57843 m .80627 .58444 L .7975 .58516 L 0 .352 .821 r
F
.55864 .66284 m .56876 .66291 L .57187 .66887 L .54 .593 .856 r
F
.5563 .65733 m .56876 .66291 L .55864 .66284 L .536 .602 .866 r
F
.48066 .66296 m .48715 .66883 L .47711 .66893 L .821 .834 .859 r
F
.48066 .66296 m .48998 .66288 L .48715 .66883 L F
.51085 .38259 m .51669 .37953 L .5088 .37927 L .706 .325 .324 r
F
.51085 .38259 m .51788 .38282 L .51669 .37953 L F
.59641 .69722 m .6064 .69754 L .61071 .70573 L .375 .456 .816 r
F
.59265 .68952 m .6064 .69754 L .59641 .69722 L .373 .463 .823 r
F
.21785 .60476 m .21601 .61196 L .20625 .61157 L .6 .95 .833 r
F
.21785 .60476 m .22708 .60524 L .21601 .61196 L F
.36395 .86955 m .37057 .88175 L .35902 .88454 L .973 .916 .681 r
F
.36395 .86955 m .37511 .867 L .37057 .88175 L F
.46256 .35244 m .46491 .34754 L .45797 .34622 L .878 .467 .237 r
F
.46256 .35244 m .46902 .35364 L .46491 .34754 L F
.56234 .3706 m .56975 .3699 L .57352 .36514 L .415 .103 .325 r
F
.55923 .37486 m .56975 .3699 L .56234 .3706 L .404 .073 .288 r
F
.57729 .35994 m .58442 .35893 L .58874 .35321 L .307 .014 .293 r
F
.57352 .36514 m .58442 .35893 L .57729 .35994 L .298 0 .261 r
F
.3753 .19294 m .37558 .18424 L .37027 .17939 L .873 .522 .023 r
F
.3753 .19294 m .38039 .19749 L .37558 .18424 L F
.5399 .38275 m .54911 .37913 L .54142 .37945 L .537 .181 .312 r
F
.53264 .3829 m .5399 .38275 L .54142 .37945 L .591 .238 .339 r
F
.76478 .47116 m .76773 .47585 L .76063 .47779 L 0 0 0 r
F
.76478 .47116 m .77206 .4691 L .76773 .47585 L F
.43373 .31502 m .43518 .30866 L .42885 .30649 L .913 .51 .161 r
F
.43373 .31502 m .43972 .31703 L .43518 .30866 L F
.78952 .57843 m .79791 .57764 L .80627 .58444 L 0 .352 .821 r
F
.78229 .57169 m .79791 .57764 L .78952 .57843 L 0 .326 .809 r
F
.4814 .36939 m .48443 .36545 L .47727 .36457 L .827 .417 .268 r
F
.4814 .36939 m .48797 .37018 L .48443 .36545 L F
.63666 .28002 m .64268 .27726 L .64762 .26692 L 0 0 .134 r
F
.632 .28973 m .64268 .27726 L .63666 .28002 L 0 0 .118 r
F
.43452 .71467 m .43982 .72321 L .42993 .72377 L .919 .905 .793 r
F
.43452 .71467 m .44393 .71418 L .43982 .72321 L F
.52464 .64757 m .53455 .65221 L .52435 .65221 L .67 .713 .88 r
F
.51545 .64758 m .52435 .65221 L .51426 .65222 L .706 .744 .881 r
F
.51545 .64758 m .52464 .64757 L .52435 .65221 L F
.6322 .75317 m .64229 .75407 L .64702 .76497 L .227 .327 .758 r
F
.62791 .74282 m .64229 .75407 L .6322 .75317 L .225 .331 .763 r
F
.36888 .855 m .37511 .867 L .36395 .86955 L .972 .919 .685 r
F
.36888 .855 m .37966 .85268 L .37511 .867 L F
.53392 .64757 m .54452 .65222 L .53455 .65221 L .631 .684 .882 r
F
.52464 .64757 m .53392 .64757 L .53455 .65221 L .67 .713 .88 r
F
.46455 .6755 m .47004 .68217 L .46041 .68237 L .865 .872 .842 r
F
.46455 .6755 m .47357 .67534 L .47004 .68217 L F
.22865 .59795 m .22708 .60524 L .21785 .60476 L .626 .96 .829 r
F
.22865 .59795 m .23739 .59851 L .22708 .60524 L F
.49567 .65227 m .50255 .65731 L .49282 .65736 L .777 .806 .876 r
F
.49567 .65227 m .5046 .65224 L .50255 .65731 L F
.76063 .47779 m .76419 .48261 L .75724 .48444 L 0 0 .051 r
F
.76063 .47779 m .76773 .47585 L .76419 .48261 L F
.59733 .34049 m .60387 .339 L .60857 .33186 L .14 0 .226 r
F
.59304 .34706 m .60387 .339 L .59733 .34049 L .133 0 .2 r
F
.78229 .57169 m .79035 .57084 L .79791 .57764 L 0 .326 .809 r
F
.77581 .56496 m .79035 .57084 L .78229 .57169 L 0 .297 .793 r
F
.38033 .20604 m .38039 .19749 L .3753 .19294 L .867 .511 .011 r
F
.38033 .20604 m .3852 .21031 L .38039 .19749 L F
.49508 .37835 m .49867 .37506 L .49152 .37448 L .776 .366 .274 r
F
.49508 .37835 m .50151 .37887 L .49867 .37506 L F
.50437 .38224 m .5088 .37927 L .50151 .37887 L .734 .331 .286 r
F
.50437 .38224 m .51085 .38259 L .5088 .37927 L F
.57187 .66887 m .58134 .66898 L .58512 .6754 L .469 .543 .85 r
F
.56876 .66291 m .58134 .66898 L .57187 .66887 L .466 .552 .86 r
F
.37382 .8409 m .37966 .85268 L .36888 .855 L .97 .922 .688 r
F
.37382 .8409 m .38421 .8388 L .37966 .85268 L F
.50665 .64759 m .51426 .65222 L .5046 .65224 L .739 .777 .884 r
F
.50665 .64759 m .51545 .64758 L .51426 .65222 L F
.75724 .48444 m .76145 .48938 L .75461 .49111 L 0 0 .131 r
F
.75724 .48444 m .76419 .48261 L .76145 .48938 L F
.59265 .68952 m .60208 .68978 L .6064 .69754 L .373 .463 .823 r
F
.58889 .68224 m .60208 .68978 L .59265 .68952 L .371 .47 .832 r
F
.77581 .56496 m .78358 .56404 L .79035 .57084 L 0 .297 .793 r
F
.77008 .55823 m .78358 .56404 L .77581 .56496 L 0 .264 .772 r
F
.632 .28973 m .63772 .28716 L .64268 .27726 L 0 0 .118 r
F
.62733 .29901 m .63772 .28716 L .632 .28973 L 0 0 .099 r
F
.43862 .32312 m .43972 .31703 L .43373 .31502 L .903 .491 .139 r
F
.43862 .32312 m .44427 .32497 L .43972 .31703 L F
.23865 .59113 m .23739 .59851 L .22865 .59795 L .654 .969 .823 r
F
.23865 .59113 m .24696 .59177 L .23739 .59851 L F
.62791 .74282 m .63755 .7436 L .64229 .75407 L .225 .331 .763 r
F
.62362 .7329 m .63755 .7436 L .62791 .74282 L .224 .337 .769 r
F
.46715 .35823 m .46902 .35364 L .46256 .35244 L .865 .441 .206 r
F
.46715 .35823 m .47314 .35932 L .46902 .35364 L F
.48421 .65742 m .48998 .66288 L .48066 .66296 L .815 .842 .869 r
F
.48421 .65742 m .49282 .65736 L .48998 .66288 L F
.43912 .70599 m .44393 .71418 L .43452 .71467 L .916 .91 .8 r
F
.43912 .70599 m .44804 .70558 L .44393 .71418 L F
.54452 .65222 m .55394 .65225 L .5563 .65733 L .589 .644 .873 r
F
.5563 .65733 m .56564 .65738 L .56876 .66291 L .536 .602 .866 r
F
.55394 .65225 m .56564 .65738 L .5563 .65733 L .532 .612 .878 r
F
.52551 .38578 m .53264 .3829 L .52522 .38293 L .618 .236 .296 r
F
.51907 .38569 m .52522 .38293 L .51788 .38282 L .655 .264 .291 r
F
.51907 .38569 m .52551 .38578 L .52522 .38293 L F
.75461 .49111 m .75949 .49615 L .75273 .49778 L 0 0 .213 r
F
.75461 .49111 m .76145 .48938 L .75949 .49615 L F
.77008 .55823 m .7776 .55724 L .78358 .56404 L 0 .264 .772 r
F
.76512 .55149 m .7776 .55724 L .77008 .55823 L 0 .226 .747 r
F
.543 .64758 m .55394 .65225 L .54452 .65222 L .584 .655 .885 r
F
.53392 .64757 m .543 .64758 L .54452 .65222 L .631 .684 .882 r
F
.5399 .38275 m .54675 .38248 L .54911 .37913 L .537 .181 .312 r
F
.54911 .37913 m .55611 .37869 L .55923 .37486 L .482 .143 .314 r
F
.54675 .38248 m .55611 .37869 L .54911 .37913 L .467 .104 .265 r
F
.57352 .36514 m .5801 .36422 L .58442 .35893 L .298 0 .261 r
F
.56975 .3699 m .5801 .36422 L .57352 .36514 L .287 0 .224 r
F
.53202 .38576 m .5399 .38275 L .53264 .3829 L .573 .194 .285 r
F
.52551 .38578 m .53202 .38576 L .53264 .3829 L .618 .236 .296 r
F
.37875 .82725 m .38421 .8388 L .37382 .8409 L .969 .925 .692 r
F
.37875 .82725 m .38876 .82535 L .38421 .8388 L F
.38537 .21871 m .3852 .21031 L .38033 .20604 L .861 .5 0 r
F
.38537 .21871 m .39002 .22271 L .3852 .21031 L F
.55923 .37486 m .56596 .37423 L .56975 .3699 L .404 .073 .288 r
F
.55611 .37869 m .56596 .37423 L .55923 .37486 L .39 .038 .243 r
F
.75273 .49778 m .75833 .50292 L .75162 .50447 L 0 0 .295 r
F
.75273 .49778 m .75949 .49615 L .75833 .50292 L F
.76512 .55149 m .77241 .55044 L .7776 .55724 L 0 .226 .747 r
F
.76091 .54476 m .77241 .55044 L .76512 .55149 L 0 .184 .716 r
F
.48555 .37378 m .48797 .37018 L .4814 .36939 L .811 .382 .227 r
F
.48555 .37378 m .49152 .37448 L .48797 .37018 L F
.24785 .58432 m .24696 .59177 L .23865 .59113 L .683 .977 .816 r
F
.24785 .58432 m .25577 .58504 L .24696 .59177 L F
.59304 .34706 m .59915 .3457 L .60387 .339 L .133 0 .2 r
F
.58874 .35321 m .59915 .3457 L .59304 .34706 L .124 0 .171 r
F
.51291 .38549 m .51788 .38282 L .51085 .38259 L .686 .279 .269 r
F
.51291 .38549 m .51907 .38569 L .51788 .38282 L F
.46869 .66906 m .47357 .67534 L .46455 .6755 L .86 .879 .851 r
F
.46869 .66906 m .47711 .66893 L .47357 .67534 L F
.75162 .50447 m .75796 .5097 L .75126 .51117 L 0 0 .374 r
F
.75162 .50447 m .75833 .50292 L .75796 .5097 L F
.76091 .54476 m .76802 .54365 L .77241 .55044 L 0 .184 .716 r
F
.75746 .53803 m .76802 .54365 L .76091 .54476 L 0 .136 .678 r
F
.62733 .29901 m .63276 .29662 L .63772 .28716 L 0 0 .099 r
F
.62265 .30787 m .63276 .29662 L .62733 .29901 L 0 0 .079 r
F
.38368 .81404 m .38876 .82535 L .37875 .82725 L .967 .928 .696 r
F
.38368 .81404 m .39332 .81232 L .38876 .82535 L F
.62362 .7329 m .63282 .73358 L .63755 .7436 L .224 .337 .769 r
F
.61932 .72341 m .63282 .73358 L .62362 .7329 L .222 .343 .776 r
F
.75126 .51117 m .75839 .51649 L .75167 .51787 L 0 0 .449 r
F
.75126 .51117 m .75796 .5097 L .75839 .51649 L F
.75746 .53803 m .76442 .53685 L .76802 .54365 L 0 .136 .678 r
F
.75477 .53131 m .76442 .53685 L .75746 .53803 L 0 .084 .632 r
F
.44351 .33078 m .44427 .32497 L .43862 .32312 L .893 .469 .115 r
F
.44351 .33078 m .44883 .33248 L .44427 .32497 L F
.53837 .38562 m .54675 .38248 L .5399 .38275 L .518 .136 .256 r
F
.53202 .38576 m .53837 .38562 L .5399 .38275 L .573 .194 .285 r
F
.75167 .51787 m .7596 .52327 L .75284 .52459 L 0 0 .518 r
F
.75167 .51787 m .75839 .51649 L .7596 .52327 L F
.75477 .53131 m .76161 .53006 L .76442 .53685 L 0 .084 .632 r
F
.75284 .52459 m .76161 .53006 L .75477 .53131 L 0 .027 .579 r
F
.75284 .52459 m .7596 .52327 L .76161 .53006 L F
.39041 .23094 m .39002 .22271 L .38537 .21871 L .854 .488 0 r
F
.39041 .23094 m .39485 .23469 L .39002 .22271 L F
.58889 .68224 m .59775 .68246 L .60208 .68978 L .371 .47 .832 r
F
.58512 .6754 m .59775 .68246 L .58889 .68224 L .368 .478 .841 r
F
.25626 .5775 m .25577 .58504 L .24785 .58432 L .713 .984 .806 r
F
.25626 .5775 m .26383 .5783 L .25577 .58504 L F
.44373 .69776 m .44804 .70558 L .43912 .70599 L .912 .915 .808 r
F
.44373 .69776 m .45216 .69741 L .44804 .70558 L F
.52493 .64336 m .53392 .64757 L .52464 .64757 L .664 .725 .894 r
F
.51664 .64336 m .52464 .64757 L .51545 .64758 L .699 .755 .895 r
F
.51664 .64336 m .52493 .64336 L .52464 .64757 L F
.49853 .64761 m .5046 .65224 L .49567 .65227 L .77 .815 .889 r
F
.49853 .64761 m .50665 .64759 L .5046 .65224 L F
.56876 .66291 m .57756 .663 L .58134 .66898 L .466 .552 .86 r
F
.56564 .65738 m .57756 .663 L .56876 .66291 L .462 .562 .871 r
F
.5333 .64336 m .543 .64758 L .53392 .64757 L .625 .696 .896 r
F
.52493 .64336 m .5333 .64336 L .53392 .64757 L .664 .725 .894 r
F
.47175 .36358 m .47314 .35932 L .46715 .35823 L .85 .409 .17 r
F
.47175 .36358 m .47727 .36457 L .47314 .35932 L F
.49865 .38179 m .50151 .37887 L .49508 .37835 L .755 .321 .222 r
F
.49865 .38179 m .50437 .38224 L .50151 .37887 L F
.38862 .80127 m .39332 .81232 L .38368 .81404 L .965 .932 .701 r
F
.38862 .80127 m .39788 .79974 L .39332 .81232 L F
.6919 .15446 m .70066 .13393 L .69679 .13982 L 0 0 0 r
F
.26386 .57069 m .26383 .5783 L .25626 .5775 L .745 .99 .793 r
F
.26386 .57069 m .27113 .57155 L .26383 .5783 L F
.50723 .38519 m .51085 .38259 L .50437 .38224 L .711 .281 .227 r
F
.50723 .38519 m .51291 .38549 L .51085 .38259 L F
.62265 .30787 m .62779 .30565 L .63276 .29662 L 0 0 .079 r
F
.61797 .3163 m .62779 .30565 L .62265 .30787 L 0 0 .058 r
F
.48777 .65231 m .49282 .65736 L .48421 .65742 L .808 .85 .881 r
F
.48777 .65231 m .49567 .65227 L .49282 .65736 L F
.39545 .24273 m .39485 .23469 L .39041 .23094 L .847 .475 0 r
F
.39545 .24273 m .39969 .24624 L .39485 .23469 L F
.61932 .72341 m .62808 .724 L .63282 .73358 L .222 .343 .776 r
F
.61502 .71436 m .62808 .724 L .61932 .72341 L .22 .349 .782 r
F
.56975 .3699 m .57577 .36907 L .5801 .36422 L .287 0 .224 r
F
.56596 .37423 m .57577 .36907 L .56975 .3699 L .274 0 .181 r
F
.50871 .64337 m .51545 .64758 L .50665 .64759 L .731 .788 .898 r
F
.50871 .64337 m .51664 .64336 L .51545 .64758 L F
.58874 .35321 m .59442 .35196 L .59915 .3457 L .124 0 .171 r
F
.58442 .35893 m .59442 .35196 L .58874 .35321 L .115 0 .137 r
F
.55394 .65225 m .56252 .65229 L .56564 .65738 L .532 .612 .878 r
F
.543 .64758 m .55158 .6476 L .55394 .65225 L .584 .655 .885 r
F
.55158 .6476 m .56252 .65229 L .55394 .65225 L .527 .624 .891 r
F
.44841 .338 m .44883 .33248 L .44351 .33078 L .88 .445 .088 r
F
.44841 .338 m .4534 .33957 L .44883 .33248 L F
.27068 .56388 m .27113 .57155 L .26386 .57069 L .778 .993 .777 r
F
.27068 .56388 m .27766 .56481 L .27113 .57155 L F
.39355 .78895 m .39788 .79974 L .38862 .80127 L .962 .935 .705 r
F
.39355 .78895 m .40245 .78758 L .39788 .79974 L F
.47285 .66306 m .47711 .66893 L .46869 .66906 L .853 .886 .861 r
F
.47285 .66306 m .48066 .66296 L .47711 .66893 L F
.6919 .15446 m .6956 .14891 L .70066 .13393 L 0 0 0 r
F
.68701 .16867 m .6956 .14891 L .6919 .15446 L F
.48971 .37773 m .49152 .37448 L .48555 .37378 L .79 .34 .178 r
F
.48971 .37773 m .49508 .37835 L .49152 .37448 L F
.44833 .68996 m .45216 .69741 L .44373 .69776 L .907 .921 .816 r
F
.44833 .68996 m .45628 .68968 L .45216 .69741 L F
.54148 .64337 m .55158 .6476 L .543 .64758 L .578 .667 .9 r
F
.5333 .64336 m .54148 .64337 L .543 .64758 L .625 .696 .896 r
F
.53837 .38562 m .54438 .38539 L .54675 .38248 L .518 .136 .256 r
F
.54675 .38248 m .55297 .38209 L .55611 .37869 L .467 .104 .265 r
F
.54438 .38539 m .55297 .38209 L .54675 .38248 L .446 .056 .204 r
F
.55611 .37869 m .56217 .37813 L .56596 .37423 L .39 .038 .243 r
F
.55297 .38209 m .56217 .37813 L .55611 .37869 L .372 0 .189 r
F
.58512 .6754 m .59342 .67557 L .59775 .68246 L .368 .478 .841 r
F
.58134 .66898 m .59342 .67557 L .58512 .6754 L .365 .488 .85 r
F
.27669 .55707 m .27766 .56481 L .27068 .56388 L .811 .994 .756 r
F
.27669 .55707 m .28344 .55806 L .27766 .56481 L F
.5258 .38819 m .53202 .38576 L .52551 .38578 L .593 .18 .228 r
F
.52027 .38812 m .52551 .38578 L .51907 .38569 L .63 .207 .222 r
F
.52027 .38812 m .5258 .38819 L .52551 .38578 L F
.4005 .25408 m .39969 .24624 L .39545 .24273 L .839 .461 0 r
F
.4005 .25408 m .40453 .25736 L .39969 .24624 L F
.53139 .38818 m .53837 .38562 L .53202 .38576 L .548 .138 .215 r
F
.5258 .38819 m .53139 .38818 L .53202 .38576 L .593 .18 .228 r
F
.61797 .3163 m .62282 .31425 L .62779 .30565 L 0 0 .058 r
F
.61328 .32429 m .62282 .31425 L .61797 .3163 L 0 0 .034 r
F
.61502 .71436 m .62334 .71486 L .62808 .724 L .22 .349 .782 r
F
.61071 .70573 m .62334 .71486 L .61502 .71436 L .218 .356 .79 r
F
.39849 .77708 m .40245 .78758 L .39355 .78895 L .96 .939 .71 r
F
.39849 .77708 m .40702 .77586 L .40245 .78758 L F
.47635 .3685 m .47727 .36457 L .47175 .36358 L .831 .373 .129 r
F
.47635 .3685 m .4814 .36939 L .47727 .36457 L F
.2819 .55026 m .28344 .55806 L .27669 .55707 L .845 .99 .729 r
F
.2819 .55026 m .28845 .55132 L .28344 .55806 L F
.68701 .16867 m .69054 .16345 L .6956 .14891 L 0 0 0 r
F
.68211 .18246 m .69054 .16345 L .68701 .16867 L F
.51498 .38795 m .51907 .38569 L .51291 .38549 L .658 .22 .198 r
F
.51498 .38795 m .52027 .38812 L .51907 .38569 L F
.56564 .65738 m .57376 .65745 L .57756 .663 L .462 .562 .871 r
F
.56252 .65229 m .57376 .65745 L .56564 .65738 L .457 .573 .883 r
F
.28632 .54345 m .28845 .55132 L .2819 .55026 L .877 .982 .697 r
F
.28632 .54345 m .29269 .54458 L .28845 .55132 L F
.45332 .34478 m .4534 .33957 L .44841 .338 L .865 .418 .058 r
F
.45332 .34478 m .45797 .34622 L .4534 .33957 L F
.58442 .35893 m .58969 .35779 L .59442 .35196 L .115 0 .137 r
F
.5801 .36422 m .58969 .35779 L .58442 .35893 L .104 0 .099 r
F
.53685 .38806 m .54438 .38539 L .53837 .38562 L .492 .078 .183 r
F
.53139 .38818 m .53685 .38806 L .53837 .38562 L .548 .138 .215 r
F
.28994 .53665 m .29269 .54458 L .28632 .54345 L .908 .968 .658 r
F
.28994 .53665 m .29617 .53784 L .29269 .54458 L F
.50139 .64339 m .50665 .64759 L .49853 .64761 L .761 .826 .903 r
F
.50139 .64339 m .50871 .64337 L .50665 .64759 L F
.29643 .50945 m .30242 .51092 L .30201 .51764 L .978 .825 .419 r
F
.40555 .26499 m .40453 .25736 L .4005 .25408 L .831 .446 0 r
F
.40555 .26499 m .40938 .26805 L .40453 .25736 L F
.45295 .6826 m .45628 .68968 L .44833 .68996 L .901 .927 .824 r
F
.45295 .6826 m .46041 .68237 L .45628 .68968 L F
.29276 .52984 m .29889 .5311 L .29617 .53784 L .935 .946 .61 r
F
.296 .51625 m .30201 .51764 L .30083 .52437 L .972 .875 .491 r
F
.40343 .76565 m .40702 .77586 L .39849 .77708 L .957 .942 .715 r
F
.40343 .76565 m .41159 .76457 L .40702 .77586 L F
.56596 .37423 m .57144 .37349 L .57577 .36907 L .274 0 .181 r
F
.56217 .37813 m .57144 .37349 L .56596 .37423 L .257 0 .129 r
F
.52521 .63958 m .5333 .64336 L .52493 .64336 L .656 .737 .91 r
F
.51784 .63959 m .52493 .64336 L .51664 .64336 L .69 .767 .911 r
F
.51784 .63959 m .52521 .63958 L .52493 .64336 L F
.50222 .38479 m .50437 .38224 L .49865 .38179 L .726 .266 .157 r
F
.50222 .38479 m .50723 .38519 L .50437 .38224 L F
.29478 .52304 m .30083 .52437 L .29889 .5311 L .957 .915 .555 r
F
.68475 .86793 m .69902 .88564 L .68946 .88277 L 0 .117 .641 r
F
.68211 .18246 m .68547 .17754 L .69054 .16345 L 0 0 0 r
F
.6772 .19581 m .68547 .17754 L .68211 .18246 L F
.53267 .63958 m .54148 .64337 L .5333 .64336 L .616 .709 .912 r
F
.52521 .63958 m .53267 .63958 L .5333 .64336 L .656 .737 .91 r
F
.49135 .64764 m .49567 .65227 L .48777 .65231 L .799 .86 .894 r
F
.49135 .64764 m .49853 .64761 L .49567 .65227 L F
.47701 .65749 m .48066 .66296 L .47285 .66306 L .845 .894 .873 r
F
.47701 .65749 m .48421 .65742 L .48066 .66296 L F
.61328 .32429 m .61785 .3224 L .62282 .31425 L 0 0 .034 r
F
.60857 .33186 m .61785 .3224 L .61328 .32429 L 0 0 .008 r
F
.61071 .70573 m .61859 .70616 L .62334 .71486 L .218 .356 .79 r
F
.6064 .69754 m .61859 .70616 L .61071 .70573 L .216 .363 .797 r
F
.58134 .66898 m .58908 .66912 L .59342 .67557 L .365 .488 .85 r
F
.57756 .663 m .58908 .66912 L .58134 .66898 L .362 .498 .861 r
F
.51011 .38769 m .51291 .38549 L .50723 .38519 L .678 .217 .151 r
F
.51011 .38769 m .51498 .38795 L .51291 .38549 L F
.68475 .86793 m .69398 .87055 L .69902 .88564 L 0 .117 .641 r
F
.68004 .85353 m .69398 .87055 L .68475 .86793 L 0 .12 .644 r
F
.49388 .38124 m .49508 .37835 L .48971 .37773 L .762 .288 .119 r
F
.49388 .38124 m .49865 .38179 L .49508 .37835 L F
.54148 .64337 m .54921 .64338 L .55158 .6476 L .578 .667 .9 r
F
.55158 .6476 m .55938 .64762 L .56252 .65229 L .527 .624 .891 r
F
.54921 .64338 m .55938 .64762 L .55158 .6476 L .52 .637 .905 r
F
.51078 .63959 m .51664 .64336 L .50871 .64337 L .721 .8 .914 r
F
.51078 .63959 m .51784 .63959 L .51664 .64336 L F
.4106 .27546 m .40938 .26805 L .40555 .26499 L .822 .429 0 r
F
.4106 .27546 m .41424 .27831 L .40938 .26805 L F
.40837 .75467 m .41159 .76457 L .40343 .76565 L .954 .946 .721 r
F
.40837 .75467 m .41617 .75372 L .41159 .76457 L F
.45823 .35113 m .45797 .34622 L .45332 .34478 L .848 .387 .025 r
F
.45823 .35113 m .46256 .35244 L .45797 .34622 L F
.6772 .19581 m .6804 .1912 L .68547 .17754 L 0 0 0 r
F
.67228 .20874 m .6804 .1912 L .6772 .19581 L F
.48097 .37298 m .4814 .36939 L .47635 .3685 L .806 .33 .081 r
F
.48097 .37298 m .48555 .37378 L .4814 .36939 L F
.55297 .38209 m .55836 .38159 L .56217 .37813 L .372 0 .189 r
F
.54983 .38505 m .55836 .38159 L .55297 .38209 L .349 0 .121 r
F
.54438 .38539 m .54983 .38505 L .55297 .38209 L .446 .056 .204 r
F
.68004 .85353 m .68894 .85591 L .69398 .87055 L 0 .12 .644 r
F
.67533 .83956 m .68894 .85591 L .68004 .85353 L 0 .123 .648 r
F
.53995 .63959 m .54921 .64338 L .54148 .64337 L .569 .681 .915 r
F
.53267 .63958 m .53995 .63959 L .54148 .64337 L .616 .709 .912 r
F
.5801 .36422 m .58495 .36319 L .58969 .35779 L .104 0 .099 r
F
.57577 .36907 m .58495 .36319 L .5801 .36422 L .091 0 .056 r
F
.53685 .38806 m .542 .38786 L .54438 .38539 L .492 .078 .183 r
F
.542 .38786 m .54983 .38505 L .54438 .38539 L .417 0 .126 r
F
.45757 .67569 m .46041 .68237 L .45295 .6826 L .895 .933 .834 r
F
.45757 .67569 m .46455 .6755 L .46041 .68237 L F
.60857 .33186 m .61287 .33011 L .61785 .3224 L 0 0 .008 r
F
.60387 .339 m .61287 .33011 L .60857 .33186 L 0 0 0 r
F
.56252 .65229 m .56996 .65233 L .57376 .65745 L .457 .573 .883 r
F
.55938 .64762 m .56996 .65233 L .56252 .65229 L .452 .586 .896 r
F
.6064 .69754 m .61384 .6979 L .61859 .70616 L .216 .363 .797 r
F
.60208 .68978 m .61384 .6979 L .6064 .69754 L .214 .371 .806 r
F
.41331 .74413 m .41617 .75372 L .40837 .75467 L .95 .95 .727 r
F
.41331 .74413 m .42075 .7433 L .41617 .75372 L F
.41566 .28548 m .41424 .27831 L .4106 .27546 L .811 .412 0 r
F
.41566 .28548 m .4191 .28813 L .41424 .27831 L F
.67228 .20874 m .67533 .20441 L .6804 .1912 L 0 0 0 r
F
.66736 .22124 m .67533 .20441 L .67228 .20874 L F
.67533 .83956 m .68391 .84172 L .68894 .85591 L 0 .123 .648 r
F
.67062 .82604 m .68391 .84172 L .67533 .83956 L 0 .127 .652 r
F
.52609 .39018 m .53139 .38818 L .5258 .38819 L .557 .106 .137 r
F
.52147 .39011 m .5258 .38819 L .52027 .38812 L .591 .132 .131 r
F
.52147 .39011 m .52609 .39018 L .5258 .38819 L F
.53075 .39016 m .53685 .38806 L .53139 .38818 L .512 .064 .123 r
F
.52609 .39018 m .53075 .39016 L .53139 .38818 L .557 .106 .137 r
F
.56217 .37813 m .56709 .37747 L .57144 .37349 L .257 0 .129 r
F
.55836 .38159 m .56709 .37747 L .56217 .37813 L .237 0 .067 r
F
.48117 .65236 m .48421 .65742 L .47701 .65749 L .836 .902 .885 r
F
.48117 .65236 m .48777 .65231 L .48421 .65742 L F
.57756 .663 m .58473 .6631 L .58908 .66912 L .362 .498 .861 r
F
.57376 .65745 m .58473 .6631 L .57756 .663 L .357 .509 .872 r
F
.46315 .35703 m .46256 .35244 L .45823 .35113 L .827 .352 0 r
F
.46315 .35703 m .46715 .35823 L .46256 .35244 L F
.51706 .38997 m .52027 .38812 L .51498 .38795 L .616 .141 .104 r
F
.51706 .38997 m .52147 .39011 L .52027 .38812 L F
.50426 .6396 m .50871 .64337 L .50139 .64339 L .749 .838 .919 r
F
.50426 .6396 m .51078 .63959 L .50871 .64337 L F
.67062 .82604 m .67887 .82799 L .68391 .84172 L 0 .127 .652 r
F
.6659 .81295 m .67887 .82799 L .67062 .82604 L 0 .13 .656 r
F
.49493 .6434 m .49853 .64761 L .49135 .64764 L .788 .869 .909 r
F
.49493 .6434 m .50139 .64339 L .49853 .64761 L F
.50581 .38736 m .50723 .38519 L .50222 .38479 L .686 .195 .075 r
F
.50581 .38736 m .51011 .38769 L .50723 .38519 L F
.66736 .22124 m .67026 .21718 L .67533 .20441 L 0 0 0 r
F
.66244 .23331 m .67026 .21718 L .66736 .22124 L F
.41825 .73404 m .42075 .7433 L .41331 .74413 L .946 .954 .733 r
F
.41825 .73404 m .42534 .73332 L .42075 .7433 L F
.60387 .339 m .60788 .33739 L .61287 .33011 L 0 0 0 r
F
.59915 .3457 m .60788 .33739 L .60387 .339 L F
.42072 .29507 m .4191 .28813 L .41566 .28548 L .8 .393 0 r
F
.42072 .29507 m .42397 .29753 L .4191 .28813 L F
.53531 .39007 m .542 .38786 L .53685 .38806 L .454 .002 .087 r
F
.53075 .39016 m .53531 .39007 L .53685 .38806 L .512 .064 .123 r
F
.48559 .37702 m .48555 .37378 L .48097 .37298 L .776 .278 .025 r
F
.48559 .37702 m .48971 .37773 L .48555 .37378 L F
.46219 .66921 m .46455 .6755 L .45757 .67569 L .887 .939 .844 r
F
.46219 .66921 m .46869 .66906 L .46455 .6755 L F
.49805 .38432 m .49865 .38179 L .49388 .38124 L .724 .224 .047 r
F
.49805 .38432 m .50222 .38479 L .49865 .38179 L F
.5255 .63624 m .53267 .63958 L .52521 .63958 L .644 .752 .927 r
F
.51904 .63624 m .52521 .63958 L .51784 .63959 L .678 .781 .928 r
F
.51904 .63624 m .5255 .63624 L .52521 .63958 L F
.57577 .36907 m .58021 .36814 L .58495 .36319 L .091 0 .056 r
F
.57144 .37349 m .58021 .36814 L .57577 .36907 L .077 0 .005 r
F
.60208 .68978 m .60909 .69008 L .61384 .6979 L .214 .371 .806 r
F
.59775 .68246 m .60909 .69008 L .60208 .68978 L .212 .38 .814 r
F
.53204 .63624 m .53995 .63959 L .53267 .63958 L .605 .724 .929 r
F
.5255 .63624 m .53204 .63624 L .53267 .63958 L .644 .752 .927 r
F
.6659 .81295 m .67383 .8147 L .67887 .82799 L 0 .13 .656 r
F
.66119 .80029 m .67383 .8147 L .6659 .81295 L 0 .135 .661 r
F
.53995 .63959 m .54684 .63959 L .54921 .64338 L .569 .681 .915 r
F
.54921 .64338 m .55624 .64339 L .55938 .64762 L .52 .637 .905 r
F
.54684 .63959 m .55624 .64339 L .54921 .64338 L .511 .651 .921 r
F
.66244 .23331 m .66519 .22951 L .67026 .21718 L 0 0 0 r
F
.65751 .24494 m .66519 .22951 L .66244 .23331 L F
.54983 .38505 m .55454 .38462 L .55836 .38159 L .349 0 .121 r
F
.54668 .38758 m .55454 .38462 L .54983 .38505 L .318 0 .037 r
F
.542 .38786 m .54668 .38758 L .54983 .38505 L .417 0 .126 r
F
.51299 .38976 m .51498 .38795 L .51011 .38769 L .63 .133 .052 r
F
.51299 .38976 m .51706 .38997 L .51498 .38795 L F
.42319 .7244 m .42534 .73332 L .41825 .73404 L .942 .959 .74 r
F
.42319 .7244 m .42993 .72377 L .42534 .73332 L F
.51285 .63624 m .51784 .63959 L .51078 .63959 L .707 .814 .931 r
F
.51285 .63624 m .51904 .63624 L .51784 .63959 L F
.42578 .30421 m .42397 .29753 L .42072 .29507 L .788 .372 0 r
F
.42578 .30421 m .42885 .30649 L .42397 .29753 L F
.46808 .3625 m .46715 .35823 L .46315 .35703 L .802 .313 0 r
F
.46808 .3625 m .47175 .36358 L .46715 .35823 L F
.66119 .80029 m .6688 .80187 L .67383 .8147 L 0 .135 .661 r
F
.65647 .78808 m .6688 .80187 L .66119 .80029 L 0 .139 .665 r
F
.55938 .64762 m .56615 .64765 L .56996 .65233 L .452 .586 .896 r
F
.55624 .64339 m .56615 .64765 L .55938 .64762 L .444 .6 .911 r
F
.59915 .3457 m .60289 .34422 L .60788 .33739 L 0 0 0 r
F
.59442 .35196 m .60289 .34422 L .59915 .3457 L F
.53531 .39007 m .53961 .3899 L .542 .38786 L .454 .002 .087 r
F
.53961 .3899 m .54668 .38758 L .542 .38786 L .377 0 .026 r
F
.53842 .63624 m .54684 .63959 L .53995 .63959 L .558 .697 .933 r
F
.53204 .63624 m .53842 .63624 L .53995 .63959 L .605 .724 .929 r
F
.57376 .65745 m .58038 .65752 L .58473 .6631 L .357 .509 .872 r
F
.56996 .65233 m .58038 .65752 L .57376 .65745 L .352 .521 .884 r
F
.55836 .38159 m .56273 .38102 L .56709 .37747 L .237 0 .067 r
F
.55454 .38462 m .56273 .38102 L .55836 .38159 L .212 0 0 r
F
.48535 .64767 m .48777 .65231 L .48117 .65236 L .824 .91 .898 r
F
.48535 .64767 m .49135 .64764 L .48777 .65231 L F
.65751 .24494 m .66011 .24139 L .66519 .22951 L 0 0 0 r
F
.65257 .25615 m .66011 .24139 L .65751 .24494 L F
.59775 .68246 m .60433 .6827 L .60909 .69008 L .212 .38 .814 r
F
.59342 .67557 m .60433 .6827 L .59775 .68246 L .209 .39 .824 r
F
.46682 .66317 m .46869 .66906 L .46219 .66921 L .877 .945 .854 r
F
.46682 .66317 m .47285 .66306 L .46869 .66906 L F
.65647 .78808 m .66376 .78949 L .6688 .80187 L 0 .139 .665 r
F
.65174 .7763 m .66376 .78949 L .65647 .78808 L 0 .144 .671 r
F
.42814 .7152 m .42993 .72377 L .42319 .7244 L .936 .963 .747 r
F
.42814 .7152 m .43452 .71467 L .42993 .72377 L F
.43085 .31291 m .42885 .30649 L .42578 .30421 L .774 .349 0 r
F
.43085 .31291 m .43373 .31502 L .42885 .30649 L F
.57144 .37349 m .57546 .37266 L .58021 .36814 L .077 0 .005 r
F
.56709 .37747 m .57546 .37266 L .57144 .37349 L .061 0 0 r
F
.49023 .38062 m .48971 .37773 L .48559 .37702 L .736 .217 0 r
F
.49023 .38062 m .49388 .38124 L .48971 .37773 L F
.49852 .6396 m .50139 .64339 L .49493 .6434 L .772 .88 .924 r
F
.49852 .6396 m .50426 .6396 L .50139 .64339 L F
.52638 .39172 m .53075 .39016 L .52609 .39018 L .5 .006 .014 r
F
.52268 .39167 m .52609 .39018 L .52147 .39011 L .532 .03 .008 r
F
.52268 .39167 m .52638 .39172 L .52609 .39018 L F
.65257 .25615 m .65503 .25283 L .66011 .24139 L 0 0 0 r
F
.64762 .26692 m .65503 .25283 L .65257 .25615 L F
.473 .36752 m .47175 .36358 L .46808 .3625 L .773 .267 0 r
F
.473 .36752 m .47635 .3685 L .47175 .36358 L F
.65174 .7763 m .65873 .77755 L .66376 .78949 L 0 .144 .671 r
F
.64702 .76497 m .65873 .77755 L .65174 .7763 L 0 .149 .676 r
F
.50714 .63624 m .51078 .63959 L .50426 .6396 L .732 .85 .936 r
F
.50714 .63624 m .51285 .63624 L .51078 .63959 L F
.53012 .39171 m .53531 .39007 L .53075 .39016 L .456 0 0 r
F
.52638 .39172 m .53012 .39171 L .53075 .39016 L .5 .006 .014 r
F
.59442 .35196 m .5979 .35062 L .60289 .34422 L 0 0 0 r
F
.58969 .35779 m .5979 .35062 L .59442 .35196 L F
.50224 .38695 m .50222 .38479 L .49805 .38432 L .673 .145 0 r
F
.50224 .38695 m .50581 .38736 L .50222 .38479 L F
.50941 .38948 m .51011 .38769 L .50581 .38736 L .629 .104 0 r
F
.50941 .38948 m .51299 .38976 L .51011 .38769 L F
.51914 .39156 m .52147 .39011 L .51706 .38997 L .552 .036 0 r
F
.51914 .39156 m .52268 .39167 L .52147 .39011 L F
.43308 .70644 m .43452 .71467 L .42814 .7152 L .93 .968 .755 r
F
.43308 .70644 m .43912 .70599 L .43452 .71467 L F
.43592 .32117 m .43373 .31502 L .43085 .31291 L .758 .325 0 r
F
.43592 .32117 m .43862 .32312 L .43373 .31502 L F
.59342 .67557 m .59956 .67576 L .60433 .6827 L .209 .39 .824 r
F
.58908 .66912 m .59956 .67576 L .59342 .67557 L .206 .401 .834 r
F
.53377 .39163 m .53961 .3899 L .53531 .39007 L .397 0 0 r
F
.53012 .39171 m .53377 .39163 L .53531 .39007 L .456 0 0 r
F
.64702 .76497 m .65369 .76607 L .65873 .77755 L 0 .149 .676 r
F
.64229 .75407 m .65369 .76607 L .64702 .76497 L 0 .155 .682 r
F
.64762 .26692 m .64994 .26382 L .65503 .25283 L 0 0 0 r
F
.64268 .27726 m .64994 .26382 L .64762 .26692 L F
.53842 .63624 m .54445 .63624 L .54684 .63959 L .558 .697 .933 r
F
.54684 .63959 m .55309 .6396 L .55624 .64339 L .511 .651 .921 r
F
.54445 .63624 m .55309 .6396 L .54684 .63959 L .499 .667 .938 r
F
.52579 .63333 m .53204 .63624 L .5255 .63624 L .628 .768 .947 r
F
.52024 .63333 m .5255 .63624 L .51904 .63624 L .66 .797 .948 r
F
.52024 .63333 m .52579 .63333 L .5255 .63624 L F
.56996 .65233 m .57601 .65239 L .58038 .65752 L .352 .521 .884 r
F
.56615 .64765 m .57601 .65239 L .56996 .65233 L .346 .535 .897 r
F
.47146 .65758 m .47285 .66306 L .46682 .66317 L .866 .951 .866 r
F
.47146 .65758 m .47701 .65749 L .47285 .66306 L F
.54668 .38758 m .55072 .38721 L .55454 .38462 L .318 0 .037 r
F
.54351 .38966 m .55072 .38721 L .54668 .38758 L .276 0 0 r
F
.53961 .3899 m .54351 .38966 L .54668 .38758 L .377 0 .026 r
F
.5314 .63333 m .53842 .63624 L .53204 .63624 L .589 .741 .948 r
F
.52579 .63333 m .5314 .63333 L .53204 .63624 L .628 .768 .947 r
F
.55624 .64339 m .56233 .64341 L .56615 .64765 L .444 .6 .911 r
F
.55309 .6396 m .56233 .64341 L .55624 .64339 L .435 .615 .926 r
F
.48953 .64342 m .49135 .64764 L .48535 .64767 L .808 .918 .912 r
F
.48953 .64342 m .49493 .6434 L .49135 .64764 L F
.56709 .37747 m .5707 .37673 L .57546 .37266 L .061 0 0 r
F
.56273 .38102 m .5707 .37673 L .56709 .37747 L .042 0 0 r
F
.55454 .38462 m .55836 .38412 L .56273 .38102 L .212 0 0 r
F
.55072 .38721 m .55836 .38412 L .55454 .38462 L .18 0 0 r
F
.58969 .35779 m .5929 .35657 L .5979 .35062 L 0 0 0 r
F
.58495 .36319 m .5929 .35657 L .58969 .35779 L F
.51589 .39139 m .51706 .38997 L .51299 .38976 L .559 .023 0 r
F
.51589 .39139 m .51914 .39156 L .51706 .38997 L F
.43803 .69814 m .43912 .70599 L .43308 .70644 L .923 .972 .763 r
F
.43803 .69814 m .44373 .69776 L .43912 .70599 L F
.44099 .32898 m .43862 .32312 L .43592 .32117 L .741 .298 0 r
F
.44099 .32898 m .44351 .33078 L .43862 .32312 L F
.49487 .38378 m .49388 .38124 L .49023 .38062 L .686 .144 0 r
F
.49487 .38378 m .49805 .38432 L .49388 .38124 L F
.47794 .3721 m .47635 .3685 L .473 .36752 L .737 .215 0 r
F
.47794 .3721 m .48097 .37298 L .47635 .3685 L F
.64229 .75407 m .64866 .75504 L .65369 .76607 L 0 .155 .682 r
F
.63755 .7436 m .64866 .75504 L .64229 .75407 L 0 .161 .688 r
F
.51493 .63333 m .51904 .63624 L .51285 .63624 L .688 .828 .95 r
F
.51493 .63333 m .52024 .63333 L .51904 .63624 L F
.64268 .27726 m .64486 .27437 L .64994 .26382 L 0 0 0 r
F
.63772 .28716 m .64486 .27437 L .64268 .27726 L F
.53377 .39163 m .53722 .3915 L .53961 .3899 L .397 0 0 r
F
.53722 .3915 m .54351 .38966 L .53961 .3899 L .32 0 0 r
F
.53689 .63333 m .54445 .63624 L .53842 .63624 L .542 .714 .952 r
F
.5314 .63333 m .53689 .63333 L .53842 .63624 L .589 .741 .948 r
F
.58908 .66912 m .5948 .66927 L .59956 .67576 L .206 .401 .834 r
F
.58473 .6631 m .5948 .66927 L .58908 .66912 L .203 .413 .845 r
F
.63755 .7436 m .64362 .74446 L .64866 .75504 L 0 .161 .688 r
F
.63282 .73358 m .64362 .74446 L .63755 .7436 L 0 .168 .695 r
F
.63772 .28716 m .63977 .28447 L .64486 .27437 L 0 0 0 r
F
.63276 .29662 m .63977 .28447 L .63772 .28716 L F
.44607 .33634 m .44351 .33078 L .44099 .32898 L .722 .268 0 r
F
.44607 .33634 m .44841 .338 L .44351 .33078 L F
.50211 .63624 m .50426 .6396 L .49852 .6396 L .752 .89 .941 r
F
.50211 .63624 m .50714 .63624 L .50426 .6396 L F
.44298 .69027 m .44373 .69776 L .43803 .69814 L .915 .977 .772 r
F
.44298 .69027 m .44833 .68996 L .44373 .69776 L F
.50644 .38915 m .50581 .38736 L .50224 .38695 L .604 .047 0 r
F
.50644 .38915 m .50941 .38948 L .50581 .38736 L F
.58495 .36319 m .5879 .36208 L .5929 .35657 L 0 0 0 r
F
.58021 .36814 m .5879 .36208 L .58495 .36319 L F
.4761 .65242 m .47701 .65749 L .47146 .65758 L .852 .958 .878 r
F
.4761 .65242 m .48117 .65236 L .47701 .65749 L F
.51302 .39117 m .51299 .38976 L .50941 .38948 L .547 0 0 r
F
.51302 .39117 m .51589 .39139 L .51299 .38976 L F
.48288 .37624 m .48097 .37298 L .47794 .3721 L .694 .156 0 r
F
.48288 .37624 m .48559 .37702 L .48097 .37298 L F
.56615 .64765 m .57165 .64769 L .57601 .65239 L .346 .535 .897 r
F
.56233 .64341 m .57165 .64769 L .56615 .64765 L .339 .551 .911 r
F
.51003 .63333 m .51285 .63624 L .50714 .63624 L .71 .862 .954 r
F
.51003 .63333 m .51493 .63333 L .51285 .63624 L F
.56273 .38102 m .56593 .38037 L .5707 .37673 L .042 0 0 r
F
.55836 .38412 m .56593 .38037 L .56273 .38102 L .02 0 0 r
F
.63282 .73358 m .63859 .73432 L .64362 .74446 L 0 .168 .695 r
F
.62808 .724 m .63859 .73432 L .63282 .73358 L 0 .176 .702 r
F
.63276 .29662 m .63468 .29413 L .63977 .28447 L 0 0 0 r
F
.62779 .30565 m .63468 .29413 L .63276 .29662 L F
.52667 .39282 m .53012 .39171 L .52638 .39172 L .413 0 0 r
F
.52389 .39278 m .52638 .39172 L .52268 .39167 L .441 0 0 r
F
.52389 .39278 m .52667 .39282 L .52638 .39172 L F
.45115 .34327 m .44841 .338 L .44607 .33634 L .7 .236 0 r
F
.45115 .34327 m .45332 .34478 L .44841 .338 L F
.52948 .39281 m .53377 .39163 L .53012 .39171 L .371 0 0 r
F
.52667 .39282 m .52948 .39281 L .53012 .39171 L .413 0 0 r
F
.49951 .3865 m .49805 .38432 L .49487 .38378 L .622 .057 0 r
F
.49951 .3865 m .50224 .38695 L .49805 .38432 L F
.49372 .63961 m .49493 .6434 L .48953 .64342 L .788 .926 .927 r
F
.49372 .63961 m .49852 .6396 L .49493 .6434 L F
.58473 .6631 m .59003 .66322 L .5948 .66927 L .203 .413 .845 r
F
.58038 .65752 m .59003 .66322 L .58473 .6631 L .199 .427 .856 r
F
.55072 .38721 m .55399 .38679 L .55836 .38412 L .18 0 0 r
F
.54688 .38936 m .55399 .38679 L .55072 .38721 L .14 0 0 r
F
.54351 .38966 m .54688 .38936 L .55072 .38721 L .276 0 0 r
F
.44793 .68286 m .44833 .68996 L .44298 .69027 L .906 .981 .781 r
F
.44793 .68286 m .45295 .6826 L .44833 .68996 L F
.55309 .6396 m .5585 .63961 L .56233 .64341 L .435 .615 .926 r
F
.54993 .63624 m .5585 .63961 L .55309 .6396 L .422 .632 .942 r
F
.54445 .63624 m .54993 .63624 L .55309 .6396 L .499 .667 .938 r
F
.87161 .39526 m .86389 .39787 L .85865 .40193 L .386 .826 .688 r
F
.87161 .39526 m .87729 .39092 L .86389 .39787 L F
.54034 .39131 m .54688 .38936 L .54351 .38966 L .22 0 0 r
F
.53722 .3915 m .54034 .39131 L .54351 .38966 L .32 0 0 r
F
.53689 .63333 m .54206 .63333 L .54445 .63624 L .542 .714 .952 r
F
.54206 .63333 m .54993 .63624 L .54445 .63624 L .483 .685 .956 r
F
.52123 .3927 m .52268 .39167 L .51914 .39156 L .455 0 0 r
F
.52123 .3927 m .52389 .39278 L .52268 .39167 L F
.58021 .36814 m .58289 .36714 L .5879 .36208 L 0 0 0 r
F
.57546 .37266 m .58289 .36714 L .58021 .36814 L F
.62808 .724 m .63355 .72464 L .63859 .73432 L 0 .176 .702 r
F
.62334 .71486 m .63355 .72464 L .62808 .724 L 0 .184 .709 r
F
.53222 .39276 m .53722 .3915 L .53377 .39163 L .314 0 0 r
F
.52948 .39281 m .53222 .39276 L .53377 .39163 L .371 0 0 r
F
.62779 .30565 m .62959 .30334 L .63468 .29413 L 0 0 0 r
F
.62282 .31425 m .62959 .30334 L .62779 .30565 L F
.52608 .63086 m .5314 .63333 L .52579 .63333 L .604 .785 .967 r
F
.52145 .63086 m .52579 .63333 L .52024 .63333 L .635 .812 .968 r
F
.52145 .63086 m .52608 .63086 L .52579 .63333 L F
.53077 .63086 m .53689 .63333 L .5314 .63333 L .566 .759 .969 r
F
.52608 .63086 m .53077 .63086 L .5314 .63333 L .604 .785 .967 r
F
.45623 .34974 m .45332 .34478 L .45115 .34327 L .676 .2 0 r
F
.45623 .34974 m .45823 .35113 L .45332 .34478 L F
.48074 .64771 m .48117 .65236 L .4761 .65242 L .834 .963 .891 r
F
.48074 .64771 m .48535 .64767 L .48117 .65236 L F
.85865 .40193 m .8513 .40481 L .84647 .40861 L .393 .826 .671 r
F
.85865 .40193 m .86389 .39787 L .8513 .40481 L F
.48782 .37994 m .48559 .37702 L .48288 .37624 L .643 .088 0 r
F
.48782 .37994 m .49023 .38062 L .48559 .37702 L F
.51879 .39257 m .51914 .39156 L .51589 .39139 L .453 0 0 r
F
.51879 .39257 m .52123 .3927 L .51914 .39156 L F
.45289 .67589 m .45295 .6826 L .44793 .68286 L .895 .986 .791 r
F
.45289 .67589 m .45757 .67569 L .45295 .6826 L F
.51701 .63086 m .52024 .63333 L .51493 .63333 L .66 .842 .97 r
F
.51701 .63086 m .52145 .63086 L .52024 .63333 L F
.62334 .71486 m .62852 .7154 L .63355 .72464 L 0 .184 .709 r
F
.61859 .70616 m .62852 .7154 L .62334 .71486 L 0 .193 .717 r
F
.62282 .31425 m .6245 .31211 L .62959 .30334 L 0 0 0 r
F
.61785 .3224 m .6245 .31211 L .62282 .31425 L F
.55836 .38412 m .56115 .38356 L .56593 .38037 L .02 0 0 r
F
.55399 .38679 m .56115 .38356 L .55836 .38412 L 0 0 0 r
F
.36009 .14537 m .35522 .13615 L .35502 .13017 L 0 0 .347 r
F
.36009 .14537 m .36023 .151 L .35522 .13615 L F
.53222 .39276 m .53481 .39266 L .53722 .3915 L .314 0 0 r
F
.53481 .39266 m .54034 .39131 L .53722 .3915 L .24 0 0 r
F
.51064 .3909 m .50941 .38948 L .50644 .38915 L .51 0 0 r
F
.51064 .3909 m .51302 .39117 L .50941 .38948 L F
.58038 .65752 m .58525 .65761 L .59003 .66322 L .199 .427 .856 r
F
.57601 .65239 m .58525 .65761 L .58038 .65752 L .195 .441 .868 r
F
.56233 .64341 m .56727 .64343 L .57165 .64769 L .339 .551 .911 r
F
.5585 .63961 m .56727 .64343 L .56233 .64341 L .329 .567 .925 r
F
.84647 .40861 m .83954 .41175 L .83506 .4153 L .402 .825 .652 r
F
.84647 .40861 m .8513 .40481 L .83954 .41175 L F
.53534 .63086 m .54206 .63333 L .53689 .63333 L .519 .732 .971 r
F
.53077 .63086 m .53534 .63086 L .53689 .63333 L .566 .759 .969 r
F
.57546 .37266 m .57788 .37177 L .58289 .36714 L 0 0 0 r
F
.5707 .37673 m .57788 .37177 L .57546 .37266 L F
.50572 .63332 m .50714 .63624 L .50211 .63624 L .725 .899 .958 r
F
.50572 .63332 m .51003 .63333 L .50714 .63624 L F
.46131 .35577 m .45823 .35113 L .45623 .34974 L .648 .161 0 r
F
.46131 .35577 m .46315 .35703 L .45823 .35113 L F
.50417 .38877 m .50224 .38695 L .49951 .3865 L .54 0 0 r
F
.50417 .38877 m .50644 .38915 L .50224 .38695 L F
.36517 .16012 m .36023 .151 L .36009 .14537 L 0 0 .356 r
F
.36517 .16012 m .36525 .16541 L .36023 .151 L F
.61785 .3224 m .6194 .32042 L .6245 .31211 L 0 0 0 r
F
.61287 .33011 m .6194 .32042 L .61785 .3224 L F
.61859 .70616 m .62348 .70662 L .62852 .7154 L 0 .193 .717 r
F
.61384 .6979 m .62348 .70662 L .61859 .70616 L 0 .203 .726 r
F
.83506 .4153 m .82859 .41868 L .82444 .422 L .411 .823 .631 r
F
.83506 .4153 m .83954 .41175 L .82859 .41868 L F
.49792 .63625 m .49852 .6396 L .49372 .63961 L .762 .933 .942 r
F
.49792 .63625 m .50211 .63624 L .49852 .6396 L F
.51664 .39241 m .51589 .39139 L .51302 .39117 L .431 0 0 r
F
.51664 .39241 m .51879 .39257 L .51589 .39139 L F
.45784 .66937 m .45757 .67569 L .45289 .67589 L .883 .99 .801 r
F
.45784 .66937 m .46219 .66921 L .45757 .67569 L F
.54688 .38936 m .5496 .38901 L .55399 .38679 L .14 0 0 r
F
.54303 .39107 m .5496 .38901 L .54688 .38936 L .09 0 0 r
F
.54034 .39131 m .54303 .39107 L .54688 .38936 L .22 0 0 r
F
.49277 .38319 m .49023 .38062 L .48782 .37994 L .581 .011 0 r
F
.49277 .38319 m .49487 .38378 L .49023 .38062 L F
.51293 .63085 m .51493 .63333 L .51003 .63333 L .678 .873 .972 r
F
.51293 .63085 m .51701 .63086 L .51493 .63333 L F
.37025 .17441 m .36525 .16541 L .36517 .16012 L 0 0 .366 r
F
.37025 .17441 m .37027 .17939 L .36525 .16541 L F
.4854 .64345 m .48535 .64767 L .48074 .64771 L .812 .968 .904 r
F
.4854 .64345 m .48953 .64342 L .48535 .64767 L F
.54993 .63624 m .55466 .63624 L .5585 .63961 L .422 .632 .942 r
F
.54676 .63333 m .55466 .63624 L .54993 .63624 L .406 .651 .958 r
F
.54206 .63333 m .54676 .63333 L .54993 .63624 L .483 .685 .956 r
F
.4664 .36136 m .46315 .35703 L .46131 .35577 L .616 .117 0 r
F
.4664 .36136 m .46808 .3625 L .46315 .35703 L F
.61287 .33011 m .6143 .32829 L .6194 .32042 L 0 0 0 r
F
.60788 .33739 m .6143 .32829 L .61287 .33011 L F
.82444 .422 m .81846 .4256 L .8146 .42871 L .422 .821 .607 r
F
.82444 .422 m .82859 .41868 L .81846 .4256 L F
.53716 .39252 m .54303 .39107 L .54034 .39131 L .145 0 0 r
F
.53481 .39266 m .53716 .39252 L .54034 .39131 L .24 0 0 r
F
.5707 .37673 m .57286 .37594 L .57788 .37177 L 0 0 0 r
F
.56593 .38037 m .57286 .37594 L .5707 .37673 L F
.61384 .6979 m .61845 .69828 L .62348 .70662 L 0 .203 .726 r
F
.60909 .69008 m .61845 .69828 L .61384 .6979 L 0 .214 .735 r
F
.57601 .65239 m .58047 .65245 L .58525 .65761 L .195 .441 .868 r
F
.57165 .64769 m .58047 .65245 L .57601 .65239 L .19 .458 .881 r
F
.53534 .63086 m .53966 .63086 L .54206 .63333 L .519 .732 .971 r
F
.53966 .63086 m .54676 .63333 L .54206 .63333 L .46 .704 .973 r
F
.37533 .18826 m .37027 .17939 L .37025 .17441 L 0 0 .377 r
F
.37533 .18826 m .3753 .19294 L .37027 .17939 L F
.55399 .38679 m .55637 .38631 L .56115 .38356 L 0 0 0 r
F
.5496 .38901 m .55637 .38631 L .55399 .38679 L F
.52696 .39348 m .52948 .39281 L .52667 .39282 L .28 0 0 r
F
.52511 .39346 m .52667 .39282 L .52389 .39278 L .302 0 0 r
F
.52511 .39346 m .52696 .39348 L .52667 .39282 L F
.52884 .39348 m .53222 .39276 L .52948 .39281 L .244 0 0 r
F
.52696 .39348 m .52884 .39348 L .52948 .39281 L .28 0 0 r
F
.8146 .42871 m .80915 .43251 L .80554 .43542 L .433 .817 .579 r
F
.8146 .42871 m .81846 .4256 L .80915 .43251 L F
.4628 .66329 m .46219 .66921 L .45784 .66937 L .868 .993 .812 r
F
.4628 .66329 m .46682 .66317 L .46219 .66921 L F
.52333 .3934 m .52389 .39278 L .52123 .3927 L .309 0 0 r
F
.52333 .3934 m .52511 .39346 L .52389 .39278 L F
.60788 .33739 m .60921 .33572 L .6143 .32829 L 0 0 0 r
F
.60289 .34422 m .60921 .33572 L .60788 .33739 L F
.5585 .63961 m .56289 .63962 L .56727 .64343 L .329 .567 .925 r
F
.55466 .63624 m .56289 .63962 L .5585 .63961 L .317 .586 .939 r
F
.47149 .3665 m .46808 .3625 L .4664 .36136 L .581 .07 0 r
F
.47149 .3665 m .473 .36752 L .46808 .3625 L F
.38041 .20165 m .3753 .19294 L .37533 .18826 L 0 0 .387 r
F
.38041 .20165 m .38033 .20604 L .3753 .19294 L F
.53067 .39344 m .53481 .39266 L .53222 .39276 L .194 0 0 r
F
.52884 .39348 m .53067 .39344 L .53222 .39276 L .244 0 0 r
F
.3581 .87226 m .35902 .88454 L .35293 .88752 L .92 .914 .523 r
F
.3581 .87226 m .36395 .86955 L .35902 .88454 L F
.60909 .69008 m .61341 .69039 L .61845 .69828 L 0 .214 .735 r
F
.60433 .6827 m .61341 .69039 L .60909 .69008 L 0 .226 .744 r
F
.49773 .386 m .49487 .38378 L .49277 .38319 L .508 0 0 r
F
.49773 .386 m .49951 .3865 L .49487 .38378 L F
.50883 .3906 m .50644 .38915 L .50417 .38877 L .437 0 0 r
F
.50883 .3906 m .51064 .3909 L .50644 .38915 L F
.51486 .39221 m .51302 .39117 L .51064 .3909 L .386 0 0 r
F
.51486 .39221 m .51664 .39241 L .51302 .39117 L F
.52637 .62883 m .53077 .63086 L .52608 .63086 L .569 .801 .987 r
F
.52266 .62883 m .52608 .63086 L .52145 .63086 L .597 .827 .987 r
F
.52266 .62883 m .52637 .62883 L .52608 .63086 L F
.80554 .43542 m .80065 .43941 L .79727 .44214 L 0 0 0 r
F
.80554 .43542 m .80915 .43251 L .80065 .43941 L F
.36326 .85747 m .36395 .86955 L .3581 .87226 L .917 .916 .527 r
F
.36326 .85747 m .36888 .855 L .36395 .86955 L F
.53013 .62883 m .53534 .63086 L .53077 .63086 L .532 .776 .987 r
F
.52637 .62883 m .53013 .62883 L .53077 .63086 L .569 .801 .987 r
F
.56593 .38037 m .56784 .37968 L .57286 .37594 L 0 0 0 r
F
.56115 .38356 m .56784 .37968 L .56593 .38037 L F
.5217 .39332 m .52123 .3927 L .51879 .39257 L .301 0 0 r
F
.5217 .39332 m .52333 .3934 L .52123 .3927 L F
.3855 .2146 m .38033 .20604 L .38041 .20165 L 0 0 .398 r
F
.3855 .2146 m .38537 .21871 L .38033 .20604 L F
.60289 .34422 m .60411 .34269 L .60921 .33572 L 0 0 0 r
F
.5979 .35062 m .60411 .34269 L .60289 .34422 L F
.36843 .84314 m .36888 .855 L .36326 .85747 L .914 .919 .531 r
F
.36843 .84314 m .37382 .8409 L .36888 .855 L F
.50933 .63085 m .51003 .63333 L .50572 .63332 L .686 .906 .973 r
F
.50933 .63085 m .51293 .63085 L .51003 .63333 L F
.49006 .63962 m .48953 .64342 L .4854 .64345 L .785 .971 .916 r
F
.49006 .63962 m .49372 .63961 L .48953 .64342 L F
.51911 .62883 m .52145 .63086 L .51701 .63086 L .618 .853 .988 r
F
.51911 .62883 m .52266 .62883 L .52145 .63086 L F
.50213 .63332 m .50211 .63624 L .49792 .63625 L .727 .937 .956 r
F
.50213 .63332 m .50572 .63332 L .50211 .63624 L F
.53067 .39344 m .5324 .39337 L .53481 .39266 L .194 0 0 r
F
.5324 .39337 m .53716 .39252 L .53481 .39266 L .13 0 0 r
F
.47657 .37119 m .473 .36752 L .47149 .3665 L .54 .018 0 r
F
.47657 .37119 m .47794 .3721 L .473 .36752 L F
.79727 .44214 m .79297 .44631 L .78979 .44887 L 0 0 0 r
F
.79727 .44214 m .80065 .43941 L .79297 .44631 L F
.57165 .64769 m .57569 .64773 L .58047 .65245 L .19 .458 .881 r
F
.56727 .64343 m .57569 .64773 L .57165 .64769 L .183 .475 .893 r
F
.46777 .65767 m .46682 .66317 L .4628 .66329 L .85 .996 .823 r
F
.46777 .65767 m .47146 .65758 L .46682 .66317 L F
.54303 .39107 m .54521 .39079 L .5496 .38901 L .09 0 0 r
F
.53918 .39234 m .54521 .39079 L .54303 .39107 L .031 0 0 r
F
.53716 .39252 m .53918 .39234 L .54303 .39107 L .145 0 0 r
F
.37359 .82927 m .37382 .8409 L .36843 .84314 L .911 .921 .535 r
F
.37359 .82927 m .37875 .82725 L .37382 .8409 L F
.60433 .6827 m .60837 .68296 L .61341 .69039 L 0 .226 .744 r
F
.59956 .67576 m .60837 .68296 L .60433 .6827 L 0 .239 .754 r
F
.39058 .22709 m .38537 .21871 L .3855 .2146 L 0 0 .41 r
F
.39058 .22709 m .39041 .23094 L .38537 .21871 L F
.5338 .62883 m .53966 .63086 L .53534 .63086 L .486 .75 .988 r
F
.53013 .62883 m .5338 .62883 L .53534 .63086 L .532 .776 .987 r
F
.5496 .38901 m .55159 .38862 L .55637 .38631 L 0 0 0 r
F
.54521 .39079 m .55159 .38862 L .5496 .38901 L F
.37874 .81585 m .37875 .82725 L .37359 .82927 L .907 .924 .539 r
F
.37874 .81585 m .38368 .81404 L .37875 .82725 L F
.5979 .35062 m .59901 .34922 L .60411 .34269 L 0 0 0 r
F
.5929 .35657 m .59901 .34922 L .5979 .35062 L .551 .821 .463 r
F
.78979 .44887 m .7861 .4532 L .78309 .45561 L 0 0 0 r
F
.78979 .44887 m .79297 .44631 L .7861 .4532 L F
.52027 .39321 m .51879 .39257 L .51664 .39241 L .276 0 0 r
F
.52027 .39321 m .5217 .39332 L .51879 .39257 L F
.54676 .63333 m .55082 .63332 L .55466 .63624 L .406 .651 .958 r
F
.54358 .63085 m .55082 .63332 L .54676 .63333 L .383 .67 .972 r
F
.53966 .63086 m .54358 .63085 L .54676 .63333 L .46 .704 .973 r
F
.39566 .23913 m .39041 .23094 L .39058 .22709 L 0 0 .422 r
F
.39566 .23913 m .39545 .24273 L .39041 .23094 L F
.50269 .38836 m .49951 .3865 L .49773 .386 L .422 0 0 r
F
.50269 .38836 m .50417 .38877 L .49951 .3865 L F
.3839 .8029 m .38368 .81404 L .37874 .81585 L .903 .926 .544 r
F
.3839 .8029 m .38862 .80127 L .38368 .81404 L F
.56115 .38356 m .56282 .38296 L .56784 .37968 L 0 0 0 r
F
.55637 .38631 m .56282 .38296 L .56115 .38356 L F
.48167 .37543 m .47794 .3721 L .47657 .37119 L .495 0 0 r
F
.48167 .37543 m .48288 .37624 L .47794 .3721 L F
.51584 .62882 m .51701 .63086 L .51293 .63085 L .631 .88 .987 r
F
.51584 .62882 m .51911 .62883 L .51701 .63086 L F
.78309 .45561 m .78005 .46009 L .77718 .46235 L 0 0 0 r
F
.78309 .45561 m .7861 .4532 L .78005 .46009 L F
.53397 .39328 m .53918 .39234 L .53716 .39252 L .052 0 0 r
F
.5324 .39337 m .53397 .39328 L .53716 .39252 L .13 0 0 r
F
.1775 .39017 m .18208 .39454 L .19513 .40125 L 0 .317 .711 r
F
.59956 .67576 m .60333 .67597 L .60837 .68296 L 0 .239 .754 r
F
.5948 .66927 m .60333 .67597 L .59956 .67576 L 0 .254 .765 r
F
.38905 .79041 m .38862 .80127 L .3839 .8029 L .898 .929 .549 r
F
.38905 .79041 m .39355 .78895 L .38862 .80127 L F
.55466 .63624 m .5585 .63625 L .56289 .63962 L .317 .586 .939 r
F
.55082 .63332 m .5585 .63625 L .55466 .63624 L .301 .605 .952 r
F
.40075 .25072 m .39545 .24273 L .39566 .23913 L 0 0 .435 r
F
.40075 .25072 m .4005 .25408 L .39545 .24273 L F
.5929 .35657 m .59391 .3553 L .59901 .34922 L .551 .821 .463 r
F
.5879 .36208 m .59391 .3553 L .5929 .35657 L .545 .832 .496 r
F
.47273 .65249 m .47146 .65758 L .46777 .65767 L .829 .998 .835 r
F
.47273 .65249 m .4761 .65242 L .47146 .65758 L F
.5135 .39199 m .51064 .3909 L .50883 .3906 L .313 0 0 r
F
.5135 .39199 m .51486 .39221 L .51064 .3909 L F
.3942 .77837 m .39355 .78895 L .38905 .79041 L .894 .932 .555 r
F
.3942 .77837 m .39849 .77708 L .39355 .78895 L F
.77718 .46235 m .7748 .46697 L .77206 .4691 L 0 0 0 r
F
.77718 .46235 m .78005 .46009 L .7748 .46697 L F
.5338 .62883 m .53726 .62882 L .53966 .63086 L .486 .75 .988 r
F
.53726 .62882 m .54358 .63085 L .53966 .63086 L .427 .722 .987 r
F
.1775 .39017 m .19513 .40125 L .19096 .39717 L 0 .317 .711 r
F
.49472 .63625 m .49372 .63961 L .49006 .63962 L .75 .971 .928 r
F
.49472 .63625 m .49792 .63625 L .49372 .63961 L F
.56727 .64343 m .5709 .64346 L .57569 .64773 L .183 .475 .893 r
F
.56289 .63962 m .5709 .64346 L .56727 .64343 L .176 .495 .905 r
F
.40583 .26186 m .4005 .25408 L .40075 .25072 L 0 0 .448 r
F
.40583 .26186 m .40555 .26499 L .4005 .25408 L F
.48676 .37923 m .48288 .37624 L .48167 .37543 L .443 0 0 r
F
.48676 .37923 m .48782 .37994 L .48288 .37624 L F
.39935 .76679 m .39849 .77708 L .3942 .77837 L .888 .935 .561 r
F
.39935 .76679 m .40343 .76565 L .39849 .77708 L F
.51908 .39308 m .51664 .39241 L .51486 .39221 L .232 0 0 r
F
.51908 .39308 m .52027 .39321 L .51664 .39241 L F
.77206 .4691 m .77037 .47385 L .76773 .47585 L 0 0 0 r
F
.77206 .4691 m .7748 .46697 L .77037 .47385 L F
.5879 .36208 m .5888 .36093 L .59391 .3553 L .545 .832 .496 r
F
.58289 .36714 m .5888 .36093 L .5879 .36208 L .537 .843 .529 r
F
.5948 .66927 m .59829 .66943 L .60333 .67597 L 0 .254 .765 r
F
.59003 .66322 m .59829 .66943 L .5948 .66927 L 0 .27 .776 r
F
.55637 .38631 m .55779 .38581 L .56282 .38296 L 0 0 0 r
F
.55159 .38862 m .55779 .38581 L .55637 .38631 L F
.19096 .39717 m .2074 .40798 L .20359 .40416 L 0 .291 .695 r
F
.41091 .27254 m .40555 .26499 L .40583 .26186 L 0 0 .462 r
F
.41091 .27254 m .4106 .27546 L .40555 .26499 L F
.54521 .39079 m .54679 .39048 L .55159 .38862 L 0 0 0 r
F
.54081 .39213 m .54679 .39048 L .54521 .39079 L F
.53918 .39234 m .54081 .39213 L .54521 .39079 L .031 0 0 r
F
.50765 .39028 m .50417 .38877 L .50269 .38836 L .323 0 0 r
F
.50765 .39028 m .50883 .3906 L .50417 .38877 L F
.40449 .75567 m .40343 .76565 L .39935 .76679 L .883 .938 .567 r
F
.40449 .75567 m .40837 .75467 L .40343 .76565 L F
.52726 .3937 m .52884 .39348 L .52696 .39348 L .097 0 0 r
F
.52633 .39368 m .52696 .39348 L .52511 .39346 L .111 0 0 r
F
.52633 .39368 m .52726 .3937 L .52696 .39348 L F
.5282 .39369 m .53067 .39344 L .52884 .39348 L .073 0 0 r
F
.52726 .3937 m .5282 .39369 L .52884 .39348 L .097 0 0 r
F
.76773 .47585 m .76675 .48072 L .76419 .48261 L 0 0 0 r
F
.76773 .47585 m .77037 .47385 L .76675 .48072 L F
.50635 .63084 m .50572 .63332 L .50213 .63332 L .68 .936 .967 r
F
.50635 .63084 m .50933 .63085 L .50572 .63332 L F
.53531 .39316 m .54081 .39213 L .53918 .39234 L 0 0 0 r
F
.53397 .39328 m .53531 .39316 L .53918 .39234 L .052 0 0 r
F
.52544 .39366 m .52511 .39346 L .52333 .3934 L .114 0 0 r
F
.52544 .39366 m .52633 .39368 L .52511 .39346 L F
.4777 .64776 m .4761 .65242 L .47273 .65249 L .804 .998 .847 r
F
.4777 .64776 m .48074 .64771 L .4761 .65242 L F
.52912 .39368 m .5324 .39337 L .53067 .39344 L .039 0 0 r
F
.5282 .39369 m .52912 .39368 L .53067 .39344 L .073 0 0 r
F
.51296 .62882 m .51293 .63085 L .50933 .63085 L .632 .905 .984 r
F
.51296 .62882 m .51584 .62882 L .51293 .63085 L F
.20359 .40416 m .21888 .41471 L .21539 .41114 L 0 .263 .678 r
F
.58289 .36714 m .5837 .36611 L .5888 .36093 L .537 .843 .529 r
F
.57788 .37177 m .5837 .36611 L .58289 .36714 L .527 .853 .565 r
F
.40963 .74501 m .40837 .75467 L .40449 .75567 L .876 .941 .574 r
F
.40963 .74501 m .41331 .74413 L .40837 .75467 L F
.416 .28277 m .4106 .27546 L .41091 .27254 L 0 0 .477 r
F
.416 .28277 m .41566 .28548 L .4106 .27546 L F
.76419 .48261 m .76394 .4876 L .76145 .48938 L 0 0 0 r
F
.76419 .48261 m .76675 .48072 L .76394 .4876 L F
.49185 .38258 m .48782 .37994 L .48676 .37923 L 0 .168 .594 r
F
.49185 .38258 m .49277 .38319 L .48782 .37994 L F
.52462 .39361 m .52333 .3934 L .5217 .39332 L .106 0 0 r
F
.52462 .39361 m .52544 .39366 L .52333 .3934 L F
.52667 .62724 m .53013 .62883 L .52637 .62883 L .514 .812 .999 r
F
.52388 .62724 m .52637 .62883 L .52266 .62883 L .539 .834 .999 r
F
.52388 .62724 m .52667 .62724 L .52637 .62883 L F
.85991 .61844 m .87873 .62505 L .873 .62523 L 0 .354 .752 r
F
.52949 .62724 m .5338 .62883 L .53013 .62883 L .479 .788 .999 r
F
.52667 .62724 m .52949 .62724 L .53013 .62883 L .514 .812 .999 r
F
.59003 .66322 m .59325 .66334 L .59829 .66943 L 0 .27 .776 r
F
.58525 .65761 m .59325 .66334 L .59003 .66322 L 0 .287 .787 r
F
.76145 .48938 m .76194 .49446 L .75949 .49615 L 0 0 0 r
F
.76145 .48938 m .76394 .4876 L .76194 .49446 L F
.41477 .7348 m .41331 .74413 L .40963 .74501 L .869 .944 .581 r
F
.41477 .7348 m .41825 .73404 L .41331 .74413 L F
.21539 .41114 m .22957 .42144 L .22637 .41811 L 0 .231 .659 r
F
.52912 .39368 m .52998 .39364 L .5324 .39337 L .039 0 0 r
F
.52998 .39364 m .53397 .39328 L .5324 .39337 L 0 0 0 r
F
.42108 .29255 m .41566 .28548 L .416 .28277 L 0 0 .492 r
F
.42108 .29255 m .42072 .29507 L .41566 .28548 L F
.85991 .61844 m .86519 .61815 L .87873 .62505 L 0 .354 .752 r
F
.8476 .61164 m .86519 .61815 L .85991 .61844 L 0 .338 .748 r
F
.52121 .62724 m .52266 .62883 L .51911 .62883 L .555 .856 .997 r
F
.52121 .62724 m .52388 .62724 L .52266 .62883 L F
.56289 .63962 m .5661 .63963 L .5709 .64346 L .176 .495 .905 r
F
.5585 .63625 m .5661 .63963 L .56289 .63962 L .167 .515 .915 r
F
.57788 .37177 m .5786 .37084 L .5837 .36611 L .527 .853 .565 r
F
.57286 .37594 m .5786 .37084 L .57788 .37177 L .515 .861 .602 r
F
.75949 .49615 m .76075 .50133 L .75833 .50292 L 0 0 .034 r
F
.75949 .49615 m .76194 .49446 L .76075 .50133 L F
.54358 .63085 m .54696 .63085 L .55082 .63332 L .383 .67 .972 r
F
.54039 .62882 m .54696 .63085 L .54358 .63085 L .351 .687 .981 r
F
.53726 .62882 m .54039 .62882 L .54358 .63085 L .427 .722 .987 r
F
.55159 .38862 m .55276 .3882 L .55779 .38581 L 0 0 0 r
F
.54679 .39048 m .55276 .3882 L .55159 .38862 L F
.51818 .39293 m .51486 .39221 L .5135 .39199 L .171 0 0 r
F
.51818 .39293 m .51908 .39308 L .51486 .39221 L F
.55082 .63332 m .5541 .63332 L .5585 .63625 L .301 .605 .952 r
F
.54696 .63085 m .5541 .63332 L .55082 .63332 L .28 .624 .961 r
F
.49939 .63332 m .49792 .63625 L .49472 .63625 L .706 .966 .938 r
F
.49939 .63332 m .50213 .63332 L .49792 .63625 L F
.41991 .72505 m .41825 .73404 L .41477 .7348 L .862 .947 .589 r
F
.41991 .72505 m .42319 .7244 L .41825 .73404 L F
.5239 .39356 m .5217 .39332 L .52027 .39321 L .087 0 0 r
F
.5239 .39356 m .52462 .39361 L .5217 .39332 L F
.53224 .62724 m .53726 .62882 L .5338 .62883 L .435 .763 .996 r
F
.52949 .62724 m .53224 .62724 L .5338 .62883 L .479 .788 .999 r
F
.8476 .61164 m .85248 .61125 L .86519 .61815 L 0 .338 .748 r
F
.83609 .60484 m .85248 .61125 L .8476 .61164 L 0 .32 .743 r
F
.42616 .30188 m .42072 .29507 L .42108 .29255 L 0 0 .508 r
F
.42616 .30188 m .42578 .30421 L .42072 .29507 L F
.22637 .41811 m .23947 .42819 L .23653 .42506 L 0 .195 .637 r
F
.75833 .50292 m .76037 .50819 L .75796 .5097 L 0 0 .128 r
F
.75833 .50292 m .76075 .50133 L .76037 .50819 L F
.49695 .38548 m .49277 .38319 L .49185 .38258 L 0 .239 .643 r
F
.49695 .38548 m .49773 .386 L .49277 .38319 L F
.51262 .39174 m .50883 .3906 L .50765 .39028 L .213 0 0 r
F
.51262 .39174 m .5135 .39199 L .50883 .3906 L F
.48267 .64347 m .48074 .64771 L .4777 .64776 L .774 .996 .858 r
F
.48267 .64347 m .4854 .64345 L .48074 .64771 L F
.83609 .60484 m .84059 .60435 L .85248 .61125 L 0 .32 .743 r
F
.82536 .59804 m .84059 .60435 L .83609 .60484 L 0 .3 .736 r
F
.53076 .3936 m .53531 .39316 L .53397 .39328 L 0 0 0 r
F
.52998 .39364 m .53076 .3936 L .53397 .39328 L F
.75796 .5097 m .76081 .51505 L .75839 .51649 L 0 0 .22 r
F
.75796 .5097 m .76037 .50819 L .76081 .51505 L F
.42505 .71576 m .42319 .7244 L .41991 .72505 L .853 .95 .597 r
F
.42505 .71576 m .42814 .7152 L .42319 .7244 L F
.43124 .31075 m .42578 .30421 L .42616 .30188 L 0 0 .525 r
F
.43124 .31075 m .43085 .31291 L .42578 .30421 L F
.57286 .37594 m .57349 .37512 L .5786 .37084 L .515 .861 .602 r
F
.56784 .37968 m .57349 .37512 L .57286 .37594 L .499 .867 .639 r
F
.58525 .65761 m .58821 .6577 L .59325 .66334 L 0 .287 .787 r
F
.58047 .65245 m .58821 .6577 L .58525 .65761 L 0 .306 .799 r
F
.23653 .42506 m .24858 .43493 L .24587 .43201 L 0 .156 .612 r
F
.82536 .59804 m .82954 .59746 L .84059 .60435 L 0 .3 .736 r
F
.81542 .59124 m .82954 .59746 L .82536 .59804 L 0 .277 .728 r
F
.54081 .39213 m .54199 .3919 L .54679 .39048 L 0 0 0 r
F
.5364 .39302 m .54199 .3919 L .54081 .39213 L F
.53531 .39316 m .5364 .39302 L .54081 .39213 L F
.75839 .51649 m .76205 .52191 L .7596 .52327 L 0 0 .307 r
F
.75839 .51649 m .76081 .51505 L .76205 .52191 L F
.51875 .62723 m .51911 .62883 L .51584 .62882 L .561 .876 .993 r
F
.51875 .62723 m .52121 .62724 L .51911 .62883 L F
.81542 .59124 m .81931 .59058 L .82954 .59746 L 0 .277 .728 r
F
.80627 .58444 m .81931 .59058 L .81542 .59124 L 0 .251 .717 r
F
.7596 .52327 m .76411 .52877 L .76161 .53006 L 0 0 .386 r
F
.7596 .52327 m .76205 .52191 L .76411 .52877 L F
.80627 .58444 m .8099 .5837 L .81931 .59058 L 0 .251 .717 r
F
.79791 .57764 m .8099 .5837 L .80627 .58444 L 0 .221 .703 r
F
.76161 .53006 m .76698 .53563 L .76442 .53685 L 0 0 .455 r
F
.76161 .53006 m .76411 .52877 L .76698 .53563 L F
.52331 .39349 m .52027 .39321 L .51908 .39308 L 0 .528 .719 r
F
.52331 .39349 m .5239 .39356 L .52027 .39321 L F
.43633 .31918 m .43085 .31291 L .43124 .31075 L 0 0 .542 r
F
.43633 .31918 m .43592 .32117 L .43085 .31291 L F
.24587 .43201 m .2569 .44169 L .25439 .43894 L 0 .112 .582 r
F
.43018 .70692 m .42814 .7152 L .42505 .71576 L .844 .953 .606 r
F
.43018 .70692 m .43308 .70644 L .42814 .7152 L F
.79791 .57764 m .80131 .57683 L .8099 .5837 L 0 .221 .703 r
F
.79035 .57084 m .80131 .57683 L .79791 .57764 L 0 .187 .686 r
F
.76442 .53685 m .77066 .54249 L .76802 .54365 L 0 0 .514 r
F
.76442 .53685 m .76698 .53563 L .77066 .54249 L F
.50205 .38793 m .49773 .386 L .49695 .38548 L 0 .314 .691 r
F
.50205 .38793 m .50269 .38836 L .49773 .386 L F
.79035 .57084 m .79355 .56995 L .80131 .57683 L 0 .187 .686 r
F
.78358 .56404 m .79355 .56995 L .79035 .57084 L 0 .147 .664 r
F
.76802 .54365 m .77516 .54936 L .77241 .55044 L 0 0 .563 r
F
.76802 .54365 m .77066 .54249 L .77516 .54936 L F
.53224 .62724 m .53484 .62724 L .53726 .62882 L .435 .763 .996 r
F
.53484 .62724 m .54039 .62882 L .53726 .62882 L .378 .734 .99 r
F
.54679 .39048 m .54772 .39015 L .55276 .3882 L 0 0 0 r
F
.54199 .3919 m .54772 .39015 L .54679 .39048 L .237 .746 .71 r
F
.78358 .56404 m .7866 .56309 L .79355 .56995 L 0 .147 .664 r
F
.7776 .55724 m .7866 .56309 L .78358 .56404 L 0 .103 .638 r
F
.77241 .55044 m .78047 .55622 L .7776 .55724 L 0 .051 .604 r
F
.77241 .55044 m .77516 .54936 L .78047 .55622 L F
.7776 .55724 m .78047 .55622 L .7866 .56309 L 0 .103 .638 r
F
.56784 .37968 m .56839 .37896 L .57349 .37512 L .499 .867 .639 r
F
.56282 .38296 m .56839 .37896 L .56784 .37968 L .48 .869 .677 r
F
.51057 .62881 m .50933 .63085 L .50635 .63084 L .616 .926 .971 r
F
.51057 .62881 m .51296 .62882 L .50933 .63085 L F
.53076 .3936 m .53144 .39354 L .53531 .39316 L 0 0 0 r
F
.53144 .39354 m .5364 .39302 L .53531 .39316 L .109 .662 .735 r
F
.44141 .32715 m .43592 .32117 L .43633 .31918 L 0 0 .561 r
F
.44141 .32715 m .44099 .32898 L .43592 .32117 L F
.25439 .43894 m .26443 .44844 L .26209 .44587 L 0 .062 .548 r
F
.43531 .69853 m .43308 .70644 L .43018 .70692 L .833 .956 .615 r
F
.43531 .69853 m .43803 .69814 L .43308 .70644 L F
.5585 .63625 m .5613 .63625 L .5661 .63963 L .167 .515 .915 r
F
.5541 .63332 m .5613 .63625 L .5585 .63625 L .156 .537 .923 r
F
.48764 .63964 m .4854 .64345 L .48267 .64347 L .738 .991 .868 r
F
.48764 .63964 m .49006 .63962 L .4854 .64345 L F
.58047 .65245 m .58317 .65251 L .58821 .6577 L 0 .306 .799 r
F
.57569 .64773 m .58317 .65251 L .58047 .65245 L 0 .328 .811 r
F
.6956 .14891 m .69863 .12793 L .70066 .13393 L .887 .893 .472 r
F
.51759 .39276 m .5135 .39199 L .51262 .39174 L 0 .487 .741 r
F
.51759 .39276 m .51818 .39293 L .5135 .39199 L F
.44649 .33466 m .44099 .32898 L .44141 .32715 L 0 .015 .58 r
F
.44649 .33466 m .44607 .33634 L .44099 .32898 L F
.56282 .38296 m .56328 .38234 L .56839 .37896 L .48 .869 .677 r
F
.55779 .38581 m .56328 .38234 L .56282 .38296 L .458 .868 .715 r
F
.50715 .38993 m .50269 .38836 L .50205 .38793 L 0 .391 .737 r
F
.50715 .38993 m .50765 .39028 L .50269 .38836 L F
.50407 .63084 m .50213 .63332 L .49939 .63332 L .649 .954 .943 r
F
.50407 .63084 m .50635 .63084 L .50213 .63332 L F
.6956 .14891 m .69358 .14326 L .69863 .12793 L .887 .893 .472 r
F
.69054 .16345 m .69358 .14326 L .6956 .14891 L .887 .898 .481 r
F
.52286 .39342 m .51908 .39308 L .51818 .39293 L 0 .556 .763 r
F
.52286 .39342 m .52331 .39349 L .51908 .39308 L F
.44044 .6906 m .43803 .69814 L .43531 .69853 L .821 .959 .625 r
F
.44044 .6906 m .44298 .69027 L .43803 .69814 L F
.51659 .62723 m .51584 .62882 L .51296 .62882 L .554 .892 .983 r
F
.51659 .62723 m .51875 .62723 L .51584 .62882 L F
.45157 .34173 m .44607 .33634 L .44649 .33466 L 0 .042 .6 r
F
.45157 .34173 m .45115 .34327 L .44607 .33634 L F
.54696 .63085 m .5497 .63084 L .5541 .63332 L .28 .624 .961 r
F
.5431 .62881 m .5497 .63084 L .54696 .63085 L .252 .642 .963 r
F
.54039 .62882 m .5431 .62881 L .54696 .63085 L .351 .687 .981 r
F
.69054 .16345 m .68852 .15814 L .69358 .14326 L .887 .898 .481 r
F
.68547 .17754 m .68852 .15814 L .69054 .16345 L .886 .902 .489 r
F
.54199 .3919 m .54268 .39165 L .54772 .39015 L .237 .746 .71 r
F
.5364 .39302 m .53718 .39287 L .54199 .3919 L 0 0 0 r
F
.53718 .39287 m .54268 .39165 L .54199 .3919 L .232 .75 .771 r
F
.53198 .39347 m .53718 .39287 L .5364 .39302 L .167 .705 .78 r
F
.53144 .39354 m .53198 .39347 L .5364 .39302 L .109 .662 .735 r
F
.52755 .39346 m .5282 .39369 L .52726 .3937 L .11 .66 .807 r
F
.52755 .39346 m .52726 .3937 L .52633 .39368 L .105 .656 .808 r
F
.52755 .39346 m .52912 .39368 L .5282 .39369 L .118 .666 .809 r
F
.45664 .34834 m .45115 .34327 L .45157 .34173 L 0 .071 .621 r
F
.45664 .34834 m .45623 .34974 L .45115 .34327 L F
.55779 .38581 m .55818 .38528 L .56328 .38234 L .458 .868 .715 r
F
.55276 .3882 m .55818 .38528 L .55779 .38581 L .43 .862 .752 r
F
.52755 .39346 m .52633 .39368 L .52544 .39366 L .104 .655 .812 r
F
.44557 .68313 m .44298 .69027 L .44044 .6906 L .808 .961 .636 r
F
.44557 .68313 m .44793 .68286 L .44298 .69027 L F
.52755 .39346 m .52998 .39364 L .52912 .39368 L .129 .675 .814 r
F
.57569 .64773 m .57812 .64777 L .58317 .65251 L 0 .328 .811 r
F
.5709 .64346 m .57812 .64777 L .57569 .64773 L 0 .351 .822 r
F
.5372 .62723 m .5431 .62881 L .54039 .62882 L .306 .7 .977 r
F
.53484 .62724 m .5372 .62723 L .54039 .62882 L .378 .734 .99 r
F
.68547 .17754 m .68346 .17255 L .68852 .15814 L .886 .902 .489 r
F
.6804 .1912 m .68346 .17255 L .68547 .17754 L .886 .906 .498 r
F
.52755 .39346 m .52544 .39366 L .52462 .39361 L .107 .656 .818 r
F
.51225 .39149 m .50765 .39028 L .50715 .38993 L 0 .47 .78 r
F
.51225 .39149 m .51262 .39174 L .50765 .39028 L F
.46172 .3545 m .45623 .34974 L .45664 .34834 L 0 .102 .644 r
F
.46172 .3545 m .46131 .35577 L .45623 .34974 L F
.52755 .39346 m .53076 .3936 L .52998 .39364 L .143 .685 .821 r
F
.49262 .63625 m .49006 .63962 L .48764 .63964 L .694 .981 .877 r
F
.49262 .63625 m .49472 .63625 L .49006 .63962 L F
.52696 .6261 m .52949 .62724 L .52667 .62724 L .428 .806 .992 r
F
.5251 .6261 m .52667 .62724 L .52388 .62724 L .448 .824 .991 r
F
.5251 .6261 m .52696 .6261 L .52667 .62724 L F
.6804 .1912 m .67841 .18651 L .68346 .17255 L .886 .906 .498 r
F
.67533 .20441 m .67841 .18651 L .6804 .1912 L .885 .911 .507 r
F
.52885 .6261 m .53224 .62724 L .52949 .62724 L .398 .785 .99 r
F
.52696 .6261 m .52885 .6261 L .52949 .62724 L .428 .806 .992 r
F
.52755 .39346 m .52462 .39361 L .5239 .39356 L .113 .659 .827 r
F
.4507 .6761 m .44793 .68286 L .44557 .68313 L .792 .963 .647 r
F
.4507 .6761 m .45289 .67589 L .44793 .68286 L F
.55276 .3882 m .55307 .38777 L .55818 .38528 L .43 .862 .752 r
F
.54772 .39015 m .55307 .38777 L .55276 .3882 L .399 .851 .786 r
F
.4668 .3602 m .46131 .35577 L .46172 .3545 L 0 .136 .667 r
F
.4668 .3602 m .4664 .36136 L .46131 .35577 L F
.52257 .39334 m .51818 .39293 L .51759 .39276 L .028 .588 .808 r
F
.52257 .39334 m .52286 .39342 L .51818 .39293 L F
.52755 .39346 m .53144 .39354 L .53076 .3936 L .159 .696 .831 r
F
.5541 .63332 m .5565 .63332 L .5613 .63625 L .156 .537 .923 r
F
.5497 .63084 m .5565 .63332 L .5541 .63332 L .143 .558 .926 r
F
.52332 .6261 m .52388 .62724 L .52121 .62724 L .458 .84 .986 r
F
.52332 .6261 m .5251 .6261 L .52388 .62724 L F
.67533 .20441 m .67335 .20002 L .67841 .18651 L .885 .911 .507 r
F
.67026 .21718 m .67335 .20002 L .67533 .20441 L .884 .915 .516 r
F
.47187 .36546 m .4664 .36136 L .4668 .3602 L 0 .172 .691 r
F
.47187 .36546 m .47149 .3665 L .4664 .36136 L F
.53069 .6261 m .53484 .62724 L .53224 .62724 L .358 .762 .983 r
F
.52885 .6261 m .53069 .6261 L .53224 .62724 L .398 .785 .99 r
F
.52755 .39346 m .5239 .39356 L .52331 .39349 L .122 .664 .837 r
F
.51735 .3926 m .51262 .39174 L .51225 .39149 L 0 .547 .818 r
F
.51735 .3926 m .51759 .39276 L .51262 .39174 L F
.53718 .39287 m .53764 .3927 L .54268 .39165 L .232 .75 .771 r
F
.53237 .39339 m .53764 .3927 L .53718 .39287 L .224 .745 .824 r
F
.53198 .39347 m .53237 .39339 L .53718 .39287 L .167 .705 .78 r
F
.45583 .66954 m .45289 .67589 L .4507 .6761 L .775 .964 .659 r
F
.45583 .66954 m .45784 .66937 L .45289 .67589 L F
.67026 .21718 m .6683 .21307 L .67335 .20002 L .884 .915 .516 r
F
.66519 .22951 m .6683 .21307 L .67026 .21718 L .882 .92 .526 r
F
.5709 .64346 m .57307 .64348 L .57812 .64777 L 0 .351 .822 r
F
.5661 .63963 m .57307 .64348 L .5709 .64346 L 0 .376 .832 r
F
.52755 .39346 m .53198 .39347 L .53144 .39354 L .176 .708 .842 r
F
.54772 .39015 m .54797 .38981 L .55307 .38777 L .399 .851 .786 r
F
.54268 .39165 m .54797 .38981 L .54772 .39015 L .363 .834 .817 r
F
.47694 .37026 m .47149 .3665 L .47187 .36546 L 0 .21 .715 r
F
.47694 .37026 m .47657 .37119 L .47149 .3665 L F
.5148 .62722 m .51296 .62882 L .51057 .62881 L .53 .9 .963 r
F
.5148 .62722 m .51659 .62723 L .51296 .62882 L F
.50875 .6288 m .50635 .63084 L .50407 .63084 L .576 .931 .941 r
F
.50875 .6288 m .51057 .62881 L .50635 .63084 L F
.66519 .22951 m .66324 .22566 L .6683 .21307 L .882 .92 .526 r
F
.66011 .24139 m .66324 .22566 L .66519 .22951 L .881 .925 .536 r
F
.52168 .62609 m .52121 .62724 L .51875 .62723 L .457 .851 .977 r
F
.52168 .62609 m .52332 .6261 L .52121 .62724 L F
.69398 .87055 m .70296 .88866 L .69902 .88564 L 0 0 .414 r
F
.52755 .39346 m .52331 .39349 L .52286 .39342 L .134 .671 .849 r
F
.48201 .37461 m .47657 .37119 L .47694 .37026 L 0 .252 .74 r
F
.48201 .37461 m .48167 .37543 L .47657 .37119 L F
.69398 .87055 m .69775 .8733 L .70296 .88866 L 0 0 .414 r
F
.68894 .85591 m .69775 .8733 L .69398 .87055 L 0 0 .417 r
F
.68894 .85591 m .69254 .85841 L .69775 .8733 L F
.68391 .84172 m .69254 .85841 L .68894 .85591 L 0 0 .421 r
F
.4976 .63331 m .49472 .63625 L .49262 .63625 L .64 .966 .883 r
F
.4976 .63331 m .49939 .63332 L .49472 .63625 L F
.68391 .84172 m .68733 .84399 L .69254 .85841 L 0 0 .421 r
F
.67887 .82799 m .68733 .84399 L .68391 .84172 L 0 0 .426 r
F
.66011 .24139 m .65819 .23779 L .66324 .22566 L .881 .925 .536 r
F
.65503 .25283 m .65819 .23779 L .66011 .24139 L .879 .93 .547 r
F
.46095 .66342 m .45784 .66937 L .45583 .66954 L .755 .964 .672 r
F
.46095 .66342 m .4628 .66329 L .45784 .66937 L F
.52755 .39346 m .53237 .39339 L .53198 .39347 L .195 .72 .854 r
F
.67887 .82799 m .68213 .83004 L .68733 .84399 L 0 0 .426 r
F
.67383 .8147 m .68213 .83004 L .67887 .82799 L 0 0 .431 r
F
.53069 .6261 m .53242 .62609 L .53484 .62724 L .358 .762 .983 r
F
.53242 .62609 m .5372 .62723 L .53484 .62724 L .307 .734 .972 r
F
.48708 .37851 m .48167 .37543 L .48201 .37461 L 0 .296 .765 r
F
.48708 .37851 m .48676 .37923 L .48167 .37543 L F
.54268 .39165 m .54286 .39139 L .54797 .38981 L .363 .834 .817 r
F
.53764 .3927 m .54286 .39139 L .54268 .39165 L .322 .81 .843 r
F
.67383 .8147 m .67693 .81655 L .68213 .83004 L 0 0 .431 r
F
.6688 .80187 m .67693 .81655 L .67383 .8147 L 0 0 .436 r
F
.52245 .39325 m .51759 .39276 L .51735 .3926 L .079 .62 .85 r
F
.52245 .39325 m .52257 .39334 L .51759 .39276 L F
.65503 .25283 m .65314 .24947 L .65819 .23779 L .879 .93 .547 r
F
.64994 .26382 m .65314 .24947 L .65503 .25283 L .876 .935 .558 r
F
.6688 .80187 m .67174 .80352 L .67693 .81655 L 0 0 .436 r
F
.66376 .78949 m .67174 .80352 L .6688 .80187 L 0 0 .441 r
F
.5431 .62881 m .54528 .62881 L .5497 .63084 L .252 .642 .963 r
F
.53923 .62723 m .54528 .62881 L .5431 .62881 L .216 .655 .952 r
F
.5372 .62723 m .53923 .62723 L .5431 .62881 L .306 .7 .977 r
F
.49215 .38196 m .48676 .37923 L .48708 .37851 L 0 .343 .789 r
F
.49215 .38196 m .49185 .38258 L .48676 .37923 L F
.66376 .78949 m .66655 .79096 L .67174 .80352 L 0 0 .441 r
F
.65873 .77755 m .66655 .79096 L .66376 .78949 L 0 0 .447 r
F
.52755 .39346 m .52286 .39342 L .52257 .39334 L .149 .68 .861 r
F
.64994 .26382 m .64809 .26069 L .65314 .24947 L .876 .935 .558 r
F
.64486 .27437 m .64809 .26069 L .64994 .26382 L .873 .94 .57 r
F
.5661 .63963 m .56802 .63964 L .57307 .64348 L 0 .376 .832 r
F
.5613 .63625 m .56802 .63964 L .5661 .63963 L 0 .402 .84 r
F
.65873 .77755 m .66136 .77887 L .66655 .79096 L 0 0 .447 r
F
.65369 .76607 m .66136 .77887 L .65873 .77755 L 0 0 .453 r
F
.46608 .65776 m .4628 .66329 L .46095 .66342 L .733 .962 .685 r
F
.46608 .65776 m .46777 .65767 L .4628 .66329 L F
.49721 .38495 m .49185 .38258 L .49215 .38196 L 0 .392 .813 r
F
.49721 .38495 m .49695 .38548 L .49185 .38258 L F
.53237 .39339 m .5326 .39331 L .53764 .3927 L .224 .745 .824 r
F
.52755 .39346 m .5326 .39331 L .53237 .39339 L .213 .731 .866 r
F
.65369 .76607 m .65618 .76723 L .66136 .77887 L 0 0 .453 r
F
.64866 .75504 m .65618 .76723 L .65369 .76607 L 0 0 .46 r
F
.53764 .3927 m .53776 .39253 L .54286 .39139 L .322 .81 .843 r
F
.5326 .39331 m .53776 .39253 L .53764 .3927 L .278 .779 .864 r
F
.64486 .27437 m .64304 .27146 L .64809 .26069 L .873 .94 .57 r
F
.63977 .28447 m .64304 .27146 L .64486 .27437 L .87 .945 .582 r
F
.52024 .62609 m .51875 .62723 L .51659 .62723 L .444 .856 .961 r
F
.52024 .62609 m .52168 .62609 L .51875 .62723 L F
.5497 .63084 m .55169 .63083 L .5565 .63332 L .143 .558 .926 r
F
.54528 .62881 m .55169 .63083 L .5497 .63084 L .126 .579 .922 r
F
.50228 .3875 m .49695 .38548 L .49721 .38495 L 0 .443 .835 r
F
.50228 .3875 m .50205 .38793 L .49695 .38548 L F
.64866 .75504 m .651 .75606 L .65618 .76723 L 0 0 .46 r
F
.64362 .74446 m .651 .75606 L .64866 .75504 L 0 0 .468 r
F
.63977 .28447 m .63799 .28177 L .64304 .27146 L .87 .945 .582 r
F
.63468 .29413 m .63799 .28177 L .63977 .28447 L .866 .95 .595 r
F
.50734 .38959 m .50205 .38793 L .50228 .3875 L 0 .496 .854 r
F
.50734 .38959 m .50715 .38993 L .50205 .38793 L F
.52755 .39346 m .52257 .39334 L .52245 .39325 L .165 .689 .874 r
F
.64362 .74446 m .64583 .74535 L .651 .75606 L 0 0 .468 r
F
.63859 .73432 m .64583 .74535 L .64362 .74446 L 0 0 .475 r
F
.63468 .29413 m .63295 .29162 L .63799 .28177 L .866 .95 .595 r
F
.62959 .30334 m .63295 .29162 L .63468 .29413 L .861 .955 .608 r
F
.53399 .62609 m .53923 .62723 L .5372 .62723 L .244 .7 .952 r
F
.53242 .62609 m .53399 .62609 L .5372 .62723 L .307 .734 .972 r
F
.4712 .65255 m .46777 .65767 L .46608 .65776 L .707 .96 .698 r
F
.4712 .65255 m .47273 .65249 L .46777 .65767 L F
.51239 .39123 m .50715 .38993 L .50734 .38959 L .034 .549 .87 r
F
.51239 .39123 m .51225 .39149 L .50715 .38993 L F
.63859 .73432 m .64066 .73509 L .64583 .74535 L 0 0 .475 r
F
.63355 .72464 m .64066 .73509 L .63859 .73432 L 0 0 .484 r
F
.5326 .39331 m .53266 .39322 L .53776 .39253 L .278 .779 .864 r
F
.52755 .39346 m .53266 .39322 L .5326 .39331 L .231 .742 .878 r
F
.50258 .63083 m .49939 .63332 L .4976 .63331 L .576 .942 .884 r
F
.50258 .63083 m .50407 .63084 L .49939 .63332 L F
.62959 .30334 m .6279 .30101 L .63295 .29162 L .861 .955 .608 r
F
.6245 .31211 m .6279 .30101 L .62959 .30334 L .856 .96 .622 r
F
.51745 .39243 m .51225 .39149 L .51239 .39123 L .083 .601 .881 r
F
.51745 .39243 m .51735 .3926 L .51225 .39149 L F
.63355 .72464 m .63549 .7253 L .64066 .73509 L 0 0 .484 r
F
.62852 .7154 m .63549 .7253 L .63355 .72464 L 0 0 .493 r
F
.6245 .31211 m .62286 .30995 L .6279 .30101 L .856 .96 .622 r
F
.6194 .32042 m .62286 .30995 L .6245 .31211 L .85 .965 .636 r
F
.5225 .39317 m .51735 .3926 L .51745 .39243 L .132 .652 .887 r
F
.5225 .39317 m .52245 .39325 L .51735 .3926 L F
.5613 .63625 m .56297 .63625 L .56802 .63964 L 0 .402 .84 r
F
.5565 .63332 m .56297 .63625 L .5613 .63625 L 0 .431 .846 r
F
.51344 .62721 m .51057 .62881 L .50875 .6288 L .484 .893 .926 r
F
.51344 .62721 m .5148 .62722 L .51057 .62881 L F
.6194 .32042 m .61782 .31844 L .62286 .30995 L .85 .965 .636 r
F
.6143 .32829 m .61782 .31844 L .6194 .32042 L .843 .969 .652 r
F
.52755 .39346 m .52245 .39325 L .5225 .39317 L .182 .699 .886 r
F
.62852 .7154 m .63033 .71597 L .63549 .7253 L 0 0 .493 r
F
.62348 .70662 m .63033 .71597 L .62852 .7154 L 0 0 .503 r
F
.6143 .32829 m .61278 .32647 L .61782 .31844 L .843 .969 .652 r
F
.60921 .33572 m .61278 .32647 L .6143 .32829 L .834 .974 .668 r
F
.47633 .6478 m .47273 .65249 L .4712 .65255 L .677 .955 .712 r
F
.47633 .6478 m .4777 .64776 L .47273 .65249 L F
.52755 .39346 m .5225 .39317 L .52273 .39309 L .2 .709 .897 r
F
.52755 .39346 m .52273 .39309 L .52312 .39301 L .217 .719 .907 r
F
.52755 .39346 m .52312 .39301 L .52366 .39294 L .234 .728 .916 r
F
.52755 .39346 m .52366 .39294 L .52433 .39288 L .25 .737 .923 r
F
.52755 .39346 m .52433 .39288 L .52512 .39283 L .264 .746 .929 r
F
.52755 .39346 m .52512 .39283 L .52598 .3928 L .276 .753 .933 r
F
.52755 .39346 m .52598 .3928 L .52691 .39278 L .286 .759 .936 r
F
.52755 .39346 m .52691 .39278 L .52785 .39278 L .293 .764 .937 r
F
.52755 .39346 m .52785 .39278 L .52878 .39279 L .297 .768 .936 r
F
.52755 .39346 m .52878 .39279 L .52967 .39282 L .299 .771 .934 r
F
.52755 .39346 m .52967 .39282 L .53049 .39286 L .297 .772 .931 r
F
.52755 .39346 m .53049 .39286 L .53121 .39292 L .293 .771 .926 r
F
.52755 .39346 m .53121 .39292 L .5318 .39298 L .286 .769 .919 r
F
.52755 .39346 m .5318 .39298 L .53225 .39306 L .275 .765 .911 r
F
.52755 .39346 m .53225 .39306 L .53254 .39314 L .263 .759 .901 r
F
.52755 .39346 m .53254 .39314 L .53266 .39322 L .248 .751 .89 r
F
.60921 .33572 m .60775 .33404 L .61278 .32647 L .834 .974 .668 r
F
.60411 .34269 m .60775 .33404 L .60921 .33572 L .825 .978 .684 r
F
.53266 .39322 m .53753 .39236 L .53776 .39253 L .326 .805 .899 r
F
.53266 .39322 m .53254 .39314 L .53753 .39236 L F
.62348 .70662 m .62517 .7071 L .63033 .71597 L 0 0 .503 r
F
.61845 .69828 m .62517 .7071 L .62348 .70662 L 0 0 .513 r
F
.60411 .34269 m .60271 .34116 L .60775 .33404 L .825 .978 .684 r
F
.59901 .34922 m .60271 .34116 L .60411 .34269 L .813 .982 .702 r
F
.51904 .62608 m .51659 .62723 L .5148 .62722 L .416 .852 .935 r
F
.51904 .62608 m .52024 .62609 L .51659 .62723 L F
.53776 .39253 m .54252 .39114 L .54286 .39139 L .399 .851 .9 r
F
.53776 .39253 m .53753 .39236 L .54252 .39114 L F
.59901 .34922 m .59768 .34782 L .60271 .34116 L .813 .982 .702 r
F
.59391 .3553 m .59768 .34782 L .59901 .34922 L .8 .985 .72 r
F
.54286 .39139 m .54752 .38946 L .54797 .38981 L .464 .888 .896 r
F
.54286 .39139 m .54252 .39114 L .54752 .38946 L F
.59391 .3553 m .59265 .35402 L .59768 .34782 L .8 .985 .72 r
F
.5888 .36093 m .59265 .35402 L .59391 .3553 L .784 .987 .739 r
F
.54797 .38981 m .55252 .38734 L .55307 .38777 L .523 .918 .886 r
F
.54797 .38981 m .54752 .38946 L .55252 .38734 L F
.61845 .69828 m .62001 .69868 L .62517 .7071 L 0 0 .513 r
F
.61341 .69039 m .62001 .69868 L .61845 .69828 L 0 0 .525 r
F
.5888 .36093 m .58762 .35978 L .59265 .35402 L .784 .987 .739 r
F
.5837 .36611 m .58762 .35978 L .5888 .36093 L .766 .988 .758 r
F
.55307 .38777 m .55753 .38476 L .55818 .38528 L .575 .942 .872 r
F
.55307 .38777 m .55252 .38734 L .55753 .38476 L F
.5837 .36611 m .5826 .36507 L .58762 .35978 L .766 .988 .758 r
F
.5786 .37084 m .5826 .36507 L .5837 .36611 L .745 .987 .778 r
F
.55818 .38528 m .56253 .38173 L .56328 .38234 L .62 .959 .856 r
F
.55818 .38528 m .55753 .38476 L .56253 .38173 L F
.5786 .37084 m .57758 .36992 L .5826 .36507 L .745 .987 .778 r
F
.57349 .37512 m .57758 .36992 L .5786 .37084 L .721 .985 .798 r
F
.56328 .38234 m .56755 .37824 L .56839 .37896 L .658 .971 .838 r
F
.56328 .38234 m .56253 .38173 L .56755 .37824 L F
.57349 .37512 m .57256 .37431 L .57758 .36992 L .721 .985 .798 r
F
.56839 .37896 m .57256 .37431 L .57349 .37512 L .692 .98 .818 r
F
.56839 .37896 m .56755 .37824 L .57256 .37431 L F
.52726 .6254 m .52885 .6261 L .52696 .6261 L .295 .765 .939 r
F
.52632 .6254 m .52696 .6261 L .5251 .6261 L .309 .776 .938 r
F
.52632 .6254 m .52726 .6254 L .52696 .6261 L F
.52273 .39309 m .5225 .39317 L .51745 .39243 L .185 .68 .917 r
F
.5282 .6254 m .53069 .6261 L .52885 .6261 L .274 .749 .936 r
F
.52726 .6254 m .5282 .6254 L .52885 .6261 L .295 .765 .939 r
F
.48145 .6435 m .4777 .64776 L .47633 .6478 L .642 .947 .725 r
F
.48145 .6435 m .48267 .64347 L .4777 .64776 L F
.54528 .62881 m .54687 .6288 L .55169 .63083 L .126 .579 .922 r
F
.54086 .62722 m .54687 .6288 L .54528 .62881 L .106 .595 .906 r
F
.53923 .62723 m .54086 .62722 L .54528 .62881 L .216 .655 .952 r
F
.61341 .69039 m .61486 .69073 L .62001 .69868 L 0 0 .525 r
F
.60837 .68296 m .61486 .69073 L .61341 .69039 L 0 0 .537 r
F
.52543 .6254 m .5251 .6261 L .52332 .6261 L .313 .784 .931 r
F
.52543 .6254 m .52632 .6254 L .5251 .6261 L F
.53534 .62609 m .54086 .62722 L .53923 .62723 L .169 .658 .922 r
F
.53399 .62609 m .53534 .62609 L .53923 .62723 L .244 .7 .952 r
F
.53254 .39314 m .53696 .3922 L .53753 .39236 L .367 .823 .927 r
F
.53254 .39314 m .53225 .39306 L .53696 .3922 L F
.50757 .62879 m .50407 .63084 L .50258 .63083 L .5 .908 .878 r
F
.50757 .62879 m .50875 .6288 L .50407 .63084 L F
.5565 .63332 m .55792 .63331 L .56297 .63625 L 0 .431 .846 r
F
.55169 .63083 m .55792 .63331 L .5565 .63332 L 0 .46 .848 r
F
.52912 .6254 m .53242 .62609 L .53069 .6261 L .244 .729 .928 r
F
.5282 .6254 m .52912 .6254 L .53069 .6261 L .274 .749 .936 r
F
.60837 .68296 m .60971 .68323 L .61486 .69073 L 0 0 .537 r
F
.60333 .67597 m .60971 .68323 L .60837 .68296 L 0 0 .55 r
F
.5179 .39226 m .51745 .39243 L .51239 .39123 L .168 .647 .928 r
F
.52273 .39309 m .51745 .39243 L .5179 .39226 L .185 .68 .917 r
F
.52461 .6254 m .52332 .6261 L .52168 .62609 L .309 .786 .919 r
F
.52461 .6254 m .52543 .6254 L .52332 .6261 L F
.52312 .39301 m .52273 .39309 L .5179 .39226 L .234 .706 .941 r
F
.48657 .63965 m .48267 .64347 L .48145 .6435 L .603 .936 .738 r
F
.48657 .63965 m .48764 .63964 L .48267 .64347 L F
.60333 .67597 m .60456 .67619 L .60971 .68323 L 0 0 .55 r
F
.59829 .66943 m .60456 .67619 L .60333 .67597 L 0 .013 .563 r
F
.52912 .6254 m .52999 .6254 L .53242 .62609 L .244 .729 .928 r
F
.52999 .6254 m .53399 .62609 L .53242 .62609 L .207 .706 .913 r
F
.53225 .39306 m .53606 .39205 L .53696 .3922 L .398 .834 .949 r
F
.53225 .39306 m .5318 .39298 L .53606 .39205 L F
.53753 .39236 m .54167 .39089 L .54252 .39114 L .458 .874 .941 r
F
.53753 .39236 m .53696 .3922 L .54167 .39089 L F
.51306 .39098 m .51239 .39123 L .50734 .38959 L .152 .612 .93 r
F
.5179 .39226 m .51239 .39123 L .51306 .39098 L .168 .647 .928 r
F
.59829 .66943 m .59941 .6696 L .60456 .67619 L 0 .013 .563 r
F
.59325 .66334 m .59941 .6696 L .59829 .66943 L 0 .036 .578 r
F
.51814 .62608 m .5148 .62722 L .51344 .62721 L .371 .835 .895 r
F
.51814 .62608 m .51904 .62608 L .5148 .62722 L F
.52312 .39301 m .5179 .39226 L .51867 .3921 L .234 .706 .941 r
F
.52366 .39294 m .52312 .39301 L .51867 .3921 L .28 .729 .959 r
F
.52389 .6254 m .52168 .62609 L .52024 .62609 L .295 .782 .901 r
F
.52389 .6254 m .52461 .6254 L .52168 .62609 L F
.49169 .63625 m .48764 .63964 L .48657 .63965 L .557 .92 .749 r
F
.49169 .63625 m .49262 .63625 L .48764 .63964 L F
.59325 .66334 m .59427 .66347 L .59941 .6696 L 0 .036 .578 r
F
.58821 .6577 m .59427 .66347 L .59325 .66334 L 0 .062 .593 r
F
.55169 .63083 m .55286 .63083 L .55792 .63331 L 0 .46 .848 r
F
.54687 .6288 m .55286 .63083 L .55169 .63083 L 0 .489 .843 r
F
.5318 .39298 m .53488 .39192 L .53606 .39205 L .421 .839 .965 r
F
.5318 .39298 m .53121 .39292 L .53488 .39192 L F
.50822 .38925 m .50734 .38959 L .50228 .3875 L .135 .575 .926 r
F
.51306 .39098 m .50734 .38959 L .50822 .38925 L .152 .612 .93 r
F
.53078 .6254 m .53534 .62609 L .53399 .62609 L .162 .678 .892 r
F
.52999 .6254 m .53078 .6254 L .53399 .62609 L .207 .706 .913 r
F
.51256 .62721 m .50875 .6288 L .50757 .62879 L .41 .861 .863 r
F
.51256 .62721 m .51344 .62721 L .50875 .6288 L F
.54252 .39114 m .54639 .38913 L .54752 .38946 L .537 .913 .945 r
F
.54252 .39114 m .54167 .39089 L .54639 .38913 L F
.58821 .6577 m .58912 .6578 L .59427 .66347 L 0 .062 .593 r
F
.58317 .65251 m .58912 .6578 L .58821 .6577 L 0 .091 .609 r
F
.52366 .39294 m .51867 .3921 L .51975 .39196 L .28 .729 .959 r
F
.52433 .39288 m .52366 .39294 L .51975 .39196 L .32 .748 .972 r
F
.51867 .3921 m .5179 .39226 L .51306 .39098 L .246 .685 .959 r
F
.54086 .62722 m .54205 .62721 L .54687 .6288 L .106 .595 .906 r
F
.53643 .62608 m .54205 .62721 L .54086 .62722 L .082 .606 .876 r
F
.53534 .62609 m .53643 .62608 L .54086 .62722 L .169 .658 .922 r
F
.53121 .39292 m .53344 .39181 L .53488 .39192 L .436 .839 .976 r
F
.53121 .39292 m .53049 .39286 L .53344 .39181 L F
.50337 .38707 m .50228 .3875 L .49721 .38495 L .12 .539 .917 r
F
.50822 .38925 m .50228 .3875 L .50337 .38707 L .135 .575 .926 r
F
.49682 .63331 m .49262 .63625 L .49169 .63625 L .505 .9 .759 r
F
.49682 .63331 m .4976 .63331 L .49262 .63625 L F
.58317 .65251 m .58398 .65258 L .58912 .6578 L 0 .091 .609 r
F
.57812 .64777 m .58398 .65258 L .58317 .65251 L 0 .123 .626 r
F
.52329 .6254 m .52024 .62609 L .51904 .62608 L .271 .772 .875 r
F
.52329 .6254 m .52389 .6254 L .52024 .62609 L F
.52433 .39288 m .51975 .39196 L .5211 .39184 L .32 .748 .972 r
F
.52512 .39283 m .52433 .39288 L .5211 .39184 L .355 .766 .981 r
F
.53696 .3922 m .54033 .39067 L .54167 .39089 L .5 .883 .967 r
F
.53696 .3922 m .53606 .39205 L .54033 .39067 L F
.53049 .39286 m .5318 .39172 L .53344 .39181 L .443 .834 .983 r
F
.53049 .39286 m .52967 .39282 L .5318 .39172 L F
.49851 .38444 m .49721 .38495 L .49215 .38196 L .104 .503 .905 r
F
.50337 .38707 m .49721 .38495 L .49851 .38444 L .12 .539 .917 r
F
.54752 .38946 m .55111 .38692 L .55252 .38734 L .604 .941 .942 r
F
.54752 .38946 m .54639 .38913 L .55111 .38692 L F
.57812 .64777 m .57885 .64782 L .58398 .65258 L 0 .123 .626 r
F
.57307 .64348 m .57885 .64782 L .57812 .64777 L 0 .157 .643 r
F
.53145 .6254 m .53643 .62608 L .53534 .62609 L .111 .644 .863 r
F
.53078 .6254 m .53145 .6254 L .53534 .62609 L .162 .678 .892 r
F
.54687 .6288 m .54781 .62879 L .55286 .63083 L 0 .489 .843 r
F
.54205 .62721 m .54781 .62879 L .54687 .6288 L 0 .517 .832 r
F
.52512 .39283 m .5211 .39184 L .52267 .39175 L .355 .766 .981 r
F
.52598 .3928 m .52512 .39283 L .52267 .39175 L .384 .781 .986 r
F
.50194 .63082 m .4976 .63331 L .49682 .63331 L .446 .873 .766 r
F
.50194 .63082 m .50258 .63083 L .4976 .63331 L F
.52967 .39282 m .53002 .39166 L .5318 .39172 L .443 .827 .988 r
F
.52967 .39282 m .52878 .39279 L .53002 .39166 L F
.49366 .38135 m .49215 .38196 L .48708 .37851 L .09 .47 .891 r
F
.49851 .38444 m .49215 .38196 L .49366 .38135 L .104 .503 .905 r
F
.52598 .3928 m .52267 .39175 L .52441 .39168 L .384 .781 .986 r
F
.52691 .39278 m .52598 .3928 L .52441 .39168 L .407 .795 .99 r
F
.57307 .64348 m .57371 .64351 L .57885 .64782 L 0 .157 .643 r
F
.56802 .63964 m .57371 .64351 L .57307 .64348 L 0 .195 .66 r
F
.51422 .39075 m .51306 .39098 L .50822 .38925 L .253 .659 .964 r
F
.51867 .3921 m .51306 .39098 L .51422 .39075 L .246 .685 .959 r
F
.52878 .39279 m .52815 .39164 L .53002 .39166 L .437 .818 .99 r
F
.52878 .39279 m .52785 .39278 L .52815 .39164 L F
.51755 .62607 m .51344 .62721 L .51256 .62721 L .307 .8 .837 r
F
.51755 .62607 m .51814 .62608 L .51344 .62721 L F
.51975 .39196 m .51867 .3921 L .51422 .39075 L .313 .715 .978 r
F
.52691 .39278 m .52441 .39168 L .52626 .39164 L .407 .795 .99 r
F
.52785 .39278 m .52691 .39278 L .52626 .39164 L .425 .807 .991 r
F
.52785 .39278 m .52626 .39164 L .52815 .39164 L F
.52284 .62539 m .51904 .62608 L .51814 .62608 L .237 .752 .841 r
F
.52284 .62539 m .52329 .6254 L .51904 .62608 L F
.55252 .38734 m .55585 .38425 L .55753 .38476 L .66 .96 .935 r
F
.55252 .38734 m .55111 .38692 L .55585 .38425 L F
.48879 .37781 m .48708 .37851 L .48201 .37461 L .077 .438 .876 r
F
.49366 .38135 m .48708 .37851 L .48879 .37781 L .09 .47 .891 r
F
.56802 .63964 m .56858 .63965 L .57371 .64351 L 0 .195 .66 r
F
.56297 .63625 m .56858 .63965 L .56802 .63964 L 0 .235 .676 r
F
.50706 .62878 m .50258 .63083 L .50194 .63082 L .38 .838 .77 r
F
.50706 .62878 m .50757 .62879 L .50258 .63083 L F
.53606 .39205 m .53855 .39047 L .54033 .39067 L .527 .881 .983 r
F
.53606 .39205 m .53488 .39192 L .53855 .39047 L F
.52755 .62516 m .5282 .6254 L .52726 .6254 L .112 .662 .811 r
F
.52755 .62516 m .52726 .6254 L .52632 .6254 L .117 .666 .811 r
F
.52755 .62516 m .52912 .6254 L .5282 .6254 L .104 .655 .809 r
F
.53643 .62608 m .53722 .62608 L .54205 .62721 L .082 .606 .876 r
F
.532 .62539 m .53722 .62608 L .53643 .62608 L .054 .606 .826 r
F
.53145 .6254 m .532 .62539 L .53643 .62608 L .111 .644 .863 r
F
.54167 .39089 m .54461 .38883 L .54639 .38913 L .582 .915 .972 r
F
.54167 .39089 m .54033 .39067 L .54461 .38883 L F
.52755 .62516 m .52632 .6254 L .52543 .6254 L .118 .667 .807 r
F
.54205 .62721 m .54275 .6272 L .54781 .62879 L 0 .517 .832 r
F
.53722 .62608 m .54275 .6272 L .54205 .62721 L 0 .543 .811 r
F
.48392 .37381 m .48201 .37461 L .47694 .37026 L .065 .409 .861 r
F
.48879 .37781 m .48201 .37461 L .48392 .37381 L .077 .438 .876 r
F
.52755 .62516 m .52999 .6254 L .52912 .6254 L .093 .647 .804 r
F
.56297 .63625 m .56344 .63626 L .56858 .63965 L 0 .235 .676 r
F
.55792 .63331 m .56344 .63626 L .56297 .63625 L 0 .279 .692 r
F
.52755 .62516 m .52543 .6254 L .52461 .6254 L .115 .666 .8 r
F
.55753 .38476 m .56058 .38113 L .56253 .38173 L .706 .974 .923 r
F
.55753 .38476 m .55585 .38425 L .56058 .38113 L F
.52755 .62516 m .53078 .6254 L .52999 .6254 L .079 .636 .797 r
F
.50976 .38894 m .50822 .38925 L .50337 .38707 L .258 .631 .961 r
F
.51422 .39075 m .50822 .38925 L .50976 .38894 L .253 .659 .964 r
F
.51975 .39196 m .51422 .39075 L .51584 .39054 L .313 .715 .978 r
F
.5211 .39184 m .51975 .39196 L .51584 .39054 L .37 .74 .99 r
F
.47905 .36935 m .47694 .37026 L .47187 .36546 L .053 .381 .845 r
F
.48392 .37381 m .47694 .37026 L .47905 .36935 L .065 .409 .861 r
F
.51218 .6272 m .50757 .62879 L .50706 .62878 L .306 .796 .769 r
F
.51218 .6272 m .51256 .62721 L .50757 .62879 L F
.55792 .63331 m .55831 .63331 L .56344 .63626 L 0 .279 .692 r
F
.55286 .63083 m .55831 .63331 L .55792 .63331 L 0 .325 .706 r
F
.52755 .62516 m .52461 .6254 L .52389 .6254 L .109 .662 .79 r
F
.52255 .62539 m .51814 .62608 L .51755 .62607 L .193 .724 .799 r
F
.52255 .62539 m .52284 .62539 L .51814 .62608 L F
.52755 .62516 m .53145 .6254 L .53078 .6254 L .062 .624 .786 r
F
.53488 .39192 m .5364 .3903 L .53855 .39047 L .541 .872 .992 r
F
.53488 .39192 m .53344 .39181 L .5364 .3903 L F
.47417 .36444 m .47187 .36546 L .4668 .3602 L .042 .356 .829 r
F
.47905 .36935 m .47187 .36546 L .47417 .36444 L .053 .381 .845 r
F
.56253 .38173 m .56533 .37755 L .56755 .37824 L .745 .982 .91 r
F
.56253 .38173 m .56058 .38113 L .56533 .37755 L F
.55286 .63083 m .55318 .63082 L .55831 .63331 L 0 .325 .706 r
F
.54781 .62879 m .55318 .63082 L .55286 .63083 L 0 .373 .717 r
F
.52755 .62516 m .52389 .6254 L .52329 .6254 L .099 .655 .778 r
F
.51584 .39054 m .51422 .39075 L .50976 .38894 L .337 .694 .982 r
F
.53722 .62608 m .53769 .62607 L .54275 .6272 L 0 .543 .811 r
F
.53239 .62539 m .53769 .62607 L .53722 .62608 L 0 .564 .781 r
F
.532 .62539 m .53239 .62539 L .53722 .62608 L .054 .606 .826 r
F
.52755 .62516 m .532 .62539 L .53145 .6254 L .044 .61 .773 r
F
.46928 .35907 m .4668 .3602 L .46172 .3545 L .033 .332 .814 r
F
.47417 .36444 m .4668 .3602 L .46928 .35907 L .042 .356 .829 r
F
.51731 .62607 m .51256 .62721 L .51218 .6272 L .226 .745 .762 r
F
.51731 .62607 m .51755 .62607 L .51256 .62721 L F
.54639 .38913 m .54889 .38653 L .55111 .38692 L .648 .934 .968 r
F
.54639 .38913 m .54461 .38883 L .54889 .38653 L F
.5211 .39184 m .51584 .39054 L .51786 .39036 L .37 .74 .99 r
F
.52267 .39175 m .5211 .39184 L .51786 .39036 L .417 .761 .995 r
F
.54781 .62879 m .54805 .62878 L .55318 .63082 L 0 .373 .717 r
F
.54275 .6272 m .54805 .62878 L .54781 .62879 L 0 .422 .725 r
F
.52755 .62516 m .52329 .6254 L .52284 .62539 L .087 .646 .763 r
F
.50529 .38667 m .50337 .38707 L .49851 .38444 L .26 .603 .953 r
F
.50976 .38894 m .50337 .38707 L .50529 .38667 L .258 .631 .961 r
F
.46439 .35324 m .46172 .3545 L .45664 .34834 L .023 .31 .8 r
F
.46928 .35907 m .46172 .3545 L .46439 .35324 L .033 .332 .814 r
F
.56755 .37824 m .57008 .37352 L .57256 .37431 L .778 .987 .896 r
F
.56755 .37824 m .56533 .37755 L .57008 .37352 L F
.53344 .39181 m .53394 .39017 L .5364 .3903 L .545 .86 .997 r
F
.53344 .39181 m .5318 .39172 L .53394 .39017 L F
.52755 .62516 m .53239 .62539 L .532 .62539 L .024 .595 .757 r
F
.54033 .39067 m .54224 .38856 L .54461 .38883 L .607 .904 .985 r
F
.54033 .39067 m .53855 .39047 L .54224 .38856 L F
.4595 .34696 m .45664 .34834 L .45157 .34173 L .015 .29 .786 r
F
.46439 .35324 m .45664 .34834 L .4595 .34696 L .023 .31 .8 r
F
.54275 .6272 m .54293 .6272 L .54805 .62878 L 0 .422 .725 r
F
.53769 .62607 m .54293 .6272 L .54275 .6272 L 0 .471 .729 r
F
.52243 .62539 m .51755 .62607 L .51731 .62607 L .141 .686 .748 r
F
.52243 .62539 m .52255 .62539 L .51755 .62607 L F
.52755 .62516 m .52284 .62539 L .52255 .62539 L .071 .634 .747 r
F
.52267 .39175 m .51786 .39036 L .52022 .39021 L .417 .761 .995 r
F
.52441 .39168 m .52267 .39175 L .52022 .39021 L .456 .779 .998 r
F
.4546 .34021 m .45157 .34173 L .44649 .33466 L .007 .271 .772 r
F
.4595 .34696 m .45157 .34173 L .4546 .34021 L .015 .29 .786 r
F
.57256 .37431 m .57484 .36902 L .57758 .36992 L .805 .989 .882 r
F
.57256 .37431 m .57008 .37352 L .57484 .36902 L F
.53239 .62539 m .53262 .62539 L .53769 .62607 L 0 .564 .781 r
F
.52755 .62516 m .53262 .62539 L .53239 .62539 L .004 .579 .74 r
F
.5318 .39172 m .53125 .39008 L .53394 .39017 L .541 .845 .999 r
F
.5318 .39172 m .53002 .39166 L .53125 .39008 L F
.53769 .62607 m .5378 .62606 L .54293 .6272 L 0 .471 .729 r
F
.53262 .62539 m .5378 .62606 L .53769 .62607 L 0 .518 .728 r
F
.4497 .33301 m .44649 .33466 L .44141 .32715 L 0 .253 .76 r
F
.4546 .34021 m .44649 .33466 L .4497 .33301 L .007 .271 .772 r
F
.52441 .39168 m .52022 .39021 L .52283 .39011 L .456 .779 .998 r
F
.52626 .39164 m .52441 .39168 L .52283 .39011 L .487 .796 .999 r
F
.50082 .38395 m .49851 .38444 L .49366 .38135 L .26 .576 .941 r
F
.50529 .38667 m .49851 .38444 L .50082 .38395 L .26 .603 .953 r
F
.55111 .38692 m .55319 .38378 L .55585 .38425 L .7 .945 .959 r
F
.55111 .38692 m .54889 .38653 L .55319 .38378 L F
.52755 .62516 m .52255 .62539 L .52243 .62539 L .053 .62 .728 r
F
.51584 .39054 m .50976 .38894 L .51192 .38865 L .337 .694 .982 r
F
.51786 .39036 m .51584 .39054 L .51192 .38865 L .405 .721 .988 r
F
.53002 .39166 m .52844 .39004 L .53125 .39008 L .53 .829 .999 r
F
.53002 .39166 m .52815 .39164 L .52844 .39004 L F
.44479 .32534 m .44141 .32715 L .43633 .31918 L 0 .237 .747 r
F
.4497 .33301 m .44141 .32715 L .44479 .32534 L 0 .253 .76 r
F
.51192 .38865 m .50976 .38894 L .50529 .38667 L .354 .67 .975 r
F
.57758 .36992 m .5796 .36407 L .5826 .36507 L .828 .99 .867 r
F
.57758 .36992 m .57484 .36902 L .5796 .36407 L F
.52626 .39164 m .52283 .39011 L .5256 .39005 L .487 .796 .999 r
F
.52815 .39164 m .52626 .39164 L .5256 .39005 L .512 .813 .999 r
F
.53262 .62539 m .53268 .62538 L .5378 .62606 L 0 .518 .728 r
F
.52755 .62516 m .53268 .62538 L .53262 .62539 L 0 .563 .721 r
F
.52815 .39164 m .5256 .39005 L .52844 .39004 L .512 .813 .999 r
F
.4869 .63966 m .48657 .63965 L .48145 .6435 L 0 0 0 r
F
.49199 .63626 m .48657 .63965 L .4869 .63966 L F
.49199 .63626 m .49169 .63625 L .48657 .63965 L F
.4818 .64353 m .48145 .6435 L .47633 .6478 L F
.4869 .63966 m .48145 .6435 L .4818 .64353 L F
.49708 .63331 m .49169 .63625 L .49199 .63626 L F
.49708 .63331 m .49682 .63331 L .49169 .63625 L F
.47669 .64784 m .47633 .6478 L .4712 .65255 L F
.4818 .64353 m .47633 .6478 L .47669 .64784 L F
.50217 .63081 m .49682 .63331 L .49708 .63331 L F
.50217 .63081 m .50194 .63082 L .49682 .63331 L F
.47159 .65262 m .4712 .65255 L .46608 .65776 L F
.47669 .64784 m .4712 .65255 L .47159 .65262 L F
.50725 .62877 m .50194 .63082 L .50217 .63081 L F
.50725 .62877 m .50706 .62878 L .50194 .63082 L F
.46648 .65786 m .46608 .65776 L .46095 .66342 L F
.47159 .65262 m .46608 .65776 L .46648 .65786 L F
.43988 .31722 m .43633 .31918 L .43124 .31075 L 0 .221 .736 r
F
.44479 .32534 m .43633 .31918 L .43988 .31722 L 0 .237 .747 r
F
.51233 .62719 m .50706 .62878 L .50725 .62877 L 0 0 0 r
F
.51233 .62719 m .51218 .6272 L .50706 .62878 L F
.46136 .66355 m .46095 .66342 L .45583 .66954 L F
.46648 .65786 m .46095 .66342 L .46136 .66355 L F
.51741 .62606 m .51218 .6272 L .51233 .62719 L F
.51741 .62606 m .51731 .62607 L .51218 .6272 L F
.45624 .66971 m .45583 .66954 L .4507 .6761 L F
.46136 .66355 m .45583 .66954 L .45624 .66971 L F
.52248 .62538 m .51731 .62607 L .51741 .62606 L F
.52248 .62538 m .52243 .62539 L .51731 .62607 L F
.53855 .39047 m .53936 .38833 L .54224 .38856 L .617 .886 .989 r
F
.53855 .39047 m .5364 .3903 L .53936 .38833 L F
.45112 .67632 m .4507 .6761 L .44557 .68313 L 0 0 0 r
F
.45624 .66971 m .4507 .6761 L .45112 .67632 L F
.43496 .30863 m .43124 .31075 L .42616 .30188 L 0 .207 .725 r
F
.43988 .31722 m .43124 .31075 L .43496 .30863 L 0 .221 .736 r
F
.52755 .62516 m .52243 .62539 L .52248 .62538 L .034 .605 .709 r
F
.44599 .6834 m .44557 .68313 L .44044 .6906 L 0 0 0 r
F
.45112 .67632 m .44557 .68313 L .44599 .6834 L F
.52755 .62516 m .52248 .62538 L .52271 .62538 L F
.52755 .62516 m .52271 .62538 L .5231 .62538 L .007 0 0 r
F
.52755 .62516 m .5231 .62538 L .52364 .62537 L .026 0 0 r
F
.52755 .62516 m .52364 .62537 L .52432 .62537 L .045 0 0 r
F
.52755 .62516 m .52432 .62537 L .52511 .62537 L .061 0 0 r
F
.52755 .62516 m .52511 .62537 L .52598 .62537 L .076 0 0 r
F
.52755 .62516 m .52598 .62537 L .5269 .62537 L .087 0 0 r
F
.52755 .62516 m .5269 .62537 L .52785 .62537 L .095 0 0 r
F
.52755 .62516 m .52785 .62537 L .52879 .62537 L .1 0 0 r
F
.52755 .62516 m .52879 .62537 L .52968 .62537 L .101 0 0 r
F
.52755 .62516 m .52968 .62537 L .5305 .62537 L .098 0 0 r
F
.52755 .62516 m .5305 .62537 L .53122 .62537 L .092 0 0 r
F
.52755 .62516 m .53122 .62537 L .53182 .62538 L .082 0 0 r
F
.52755 .62516 m .53182 .62538 L .53227 .62538 L .069 0 0 r
F
.52755 .62516 m .53227 .62538 L .53256 .62538 L .053 0 0 r
F
.52755 .62516 m .53256 .62538 L .53268 .62538 L .036 0 0 r
F
.5826 .36507 m .58437 .35866 L .58762 .35978 L .848 .989 .853 r
F
.5826 .36507 m .5796 .36407 L .58437 .35866 L F
.44085 .69094 m .44044 .6906 L .43531 .69853 L 0 0 0 r
F
.44599 .6834 m .44044 .6906 L .44085 .69094 L F
.43004 .29958 m .42616 .30188 L .42108 .29255 L 0 .194 .714 r
F
.43496 .30863 m .42616 .30188 L .43004 .29958 L 0 .207 .725 r
F
.53268 .62538 m .53757 .62606 L .5378 .62606 L .123 0 0 r
F
.53268 .62538 m .53256 .62538 L .53757 .62606 L F
.43572 .69894 m .43531 .69853 L .43018 .70692 L 0 0 0 r
F
.44085 .69094 m .43531 .69853 L .43572 .69894 L F
.54461 .38883 m .54594 .38619 L .54889 .38653 L .667 .913 .977 r
F
.54461 .38883 m .54224 .38856 L .54594 .38619 L F
.49633 .38078 m .49366 .38135 L .48879 .37781 L .259 .55 .928 r
F
.50082 .38395 m .49366 .38135 L .49633 .38078 L .26 .576 .941 r
F
.5378 .62606 m .54258 .62719 L .54293 .6272 L .207 0 0 r
F
.5378 .62606 m .53757 .62606 L .54258 .62719 L F
.43057 .7074 m .43018 .70692 L .42505 .71576 L 0 0 0 r
F
.43572 .69894 m .43018 .70692 L .43057 .7074 L F
.42512 .29007 m .42108 .29255 L .416 .28277 L 0 .181 .704 r
F
.43004 .29958 m .42108 .29255 L .42512 .29007 L 0 .194 .714 r
F
.54293 .6272 m .5476 .62877 L .54805 .62878 L .285 0 0 r
F
.54293 .6272 m .54258 .62719 L .5476 .62877 L F
.42542 .71633 m .42505 .71576 L .41991 .72505 L 0 0 0 r
F
.43057 .7074 m .42505 .71576 L .42542 .71633 L F
.55585 .38425 m .55749 .38058 L .56058 .38113 L .741 .95 .946 r
F
.55585 .38425 m .55319 .38378 L .55749 .38058 L F
.52271 .62538 m .52248 .62538 L .51741 .62606 L 0 0 0 r
F
.42019 .2801 m .416 .28277 L .41091 .27254 L 0 .169 .695 r
F
.42512 .29007 m .416 .28277 L .42019 .2801 L 0 .181 .704 r
F
.54805 .62878 m .55263 .63081 L .55318 .63082 L .356 0 0 r
F
.54805 .62878 m .5476 .62877 L .55263 .63081 L F
.58762 .35978 m .58915 .35279 L .59265 .35402 L .864 .987 .839 r
F
.58762 .35978 m .58437 .35866 L .58915 .35279 L F
.51786 .39036 m .51192 .38865 L .51461 .38841 L .405 .721 .988 r
F
.52022 .39021 m .51786 .39036 L .51461 .38841 L .459 .744 .99 r
F
.42027 .72572 m .41991 .72505 L .41477 .7348 L 0 0 0 r
F
.42542 .71633 m .41991 .72505 L .42027 .72572 L F
.41526 .26966 m .41091 .27254 L .40583 .26186 L 0 .158 .686 r
F
.42019 .2801 m .41091 .27254 L .41526 .26966 L 0 .169 .695 r
F
.53256 .62538 m .53699 .62605 L .53757 .62606 L .175 0 0 r
F
.53256 .62538 m .53227 .62538 L .53699 .62605 L F
.55318 .63082 m .55766 .63331 L .55831 .63331 L .421 0 0 r
F
.55318 .63082 m .55263 .63081 L .55766 .63331 L F
.41511 .73558 m .41477 .7348 L .40963 .74501 L 0 0 0 r
F
.42027 .72572 m .41477 .7348 L .41511 .73558 L F
.41033 .25876 m .40583 .26186 L .40075 .25072 L 0 .147 .677 r
F
.41526 .26966 m .40583 .26186 L .41033 .25876 L 0 .158 .686 r
F
.55831 .63331 m .56269 .63626 L .56344 .63626 L .477 0 0 r
F
.55831 .63331 m .55766 .63331 L .56269 .63626 L F
.50798 .38631 m .50529 .38667 L .50082 .38395 L .365 .646 .963 r
F
.51192 .38865 m .50529 .38667 L .50798 .38631 L .354 .67 .975 r
F
.5364 .3903 m .53608 .38816 L .53936 .38833 L .615 .865 .99 r
F
.5364 .3903 m .53394 .39017 L .53608 .38816 L F
.40994 .74591 m .40963 .74501 L .40449 .75567 L 0 0 0 r
F
.41511 .73558 m .40963 .74501 L .40994 .74591 L F
.51786 .62605 m .51741 .62606 L .51233 .62719 L F
.52271 .62538 m .51741 .62606 L .51786 .62605 L F
.40539 .2474 m .40075 .25072 L .39566 .23913 L 0 .137 .669 r
F
.41033 .25876 m .40075 .25072 L .40539 .2474 L 0 .147 .677 r
F
.5231 .62538 m .52271 .62538 L .51786 .62605 L .036 0 0 r
F
.56344 .63626 m .56773 .63967 L .56858 .63965 L .527 0 0 r
F
.56344 .63626 m .56269 .63626 L .56773 .63967 L F
.59265 .35402 m .59393 .34646 L .59768 .34782 L .878 .985 .826 r
F
.59265 .35402 m .58915 .35279 L .59393 .34646 L F
.40045 .23557 m .39566 .23913 L .39058 .22709 L 0 .128 .661 r
F
.40539 .2474 m .39566 .23913 L .40045 .23557 L 0 .137 .669 r
F
.49184 .37714 m .48879 .37781 L .48392 .37381 L .258 .526 .914 r
F
.49633 .38078 m .48879 .37781 L .49184 .37714 L .259 .55 .928 r
F
.40477 .7567 m .40449 .75567 L .39935 .76679 L 0 0 0 r
F
.40994 .74591 m .40449 .75567 L .40477 .7567 L F
.53227 .62538 m .5361 .62605 L .53699 .62605 L .219 0 0 r
F
.53227 .62538 m .53182 .62538 L .5361 .62605 L F
.3955 .22328 m .39058 .22709 L .3855 .2146 L 0 .119 .654 r
F
.40045 .23557 m .39058 .22709 L .3955 .22328 L 0 .128 .661 r
F
.56858 .63965 m .57277 .64354 L .57371 .64351 L .571 .015 0 r
F
.56858 .63965 m .56773 .63967 L .57277 .64354 L F
.51461 .38841 m .51192 .38865 L .50798 .38631 L .428 .699 .978 r
F
.39055 .21052 m .3855 .2146 L .38041 .20165 L 0 .11 .646 r
F
.3955 .22328 m .3855 .2146 L .39055 .21052 L 0 .119 .654 r
F
.39959 .76797 m .39935 .76679 L .3942 .77837 L 0 0 0 r
F
.40477 .7567 m .39935 .76679 L .39959 .76797 L F
.53757 .62606 m .54173 .62718 L .54258 .62719 L .288 0 0 r
F
.53757 .62606 m .53699 .62605 L .54173 .62718 L F
.3856 .1973 m .38041 .20165 L .37533 .18826 L 0 .102 .639 r
F
.39055 .21052 m .38041 .20165 L .3856 .1973 L 0 .11 .646 r
F
.513 .62718 m .51233 .62719 L .50725 .62877 L 0 0 0 r
F
.51786 .62605 m .51233 .62719 L .513 .62718 L F
.57371 .64351 m .57782 .64786 L .57885 .64782 L .608 .066 0 r
F
.57371 .64351 m .57277 .64354 L .57782 .64786 L F
.52022 .39021 m .51461 .38841 L .51776 .38822 L .459 .744 .99 r
F
.52283 .39011 m .52022 .39021 L .51776 .38822 L .503 .764 .989 r
F
.38065 .18362 m .37533 .18826 L .37025 .17441 L 0 .094 .633 r
F
.3856 .1973 m .37533 .18826 L .38065 .18362 L 0 .102 .639 r
F
.5231 .62538 m .51786 .62605 L .51864 .62605 L .036 0 0 r
F
.52364 .62537 m .5231 .62538 L .51864 .62605 L .093 0 0 r
F
.59768 .34782 m .59871 .33967 L .60271 .34116 L .89 .982 .813 r
F
.59768 .34782 m .59393 .34646 L .59871 .33967 L F
.3944 .7797 m .3942 .77837 L .38905 .79041 L 0 0 0 r
F
.39959 .76797 m .3942 .77837 L .3944 .7797 L F
.37569 .16946 m .37025 .17441 L .36517 .16012 L 0 .086 .626 r
F
.38065 .18362 m .37025 .17441 L .37569 .16946 L 0 .094 .633 r
F
.56058 .38113 m .5618 .37691 L .56533 .37755 L .773 .951 .932 r
F
.56058 .38113 m .55749 .38058 L .5618 .37691 L F
.37074 .15485 m .36517 .16012 L .36009 .14537 L 0 .079 .62 r
F
.37569 .16946 m .36517 .16012 L .37074 .15485 L 0 .086 .626 r
F
.36577 .13976 m .36009 .14537 L .35502 .13017 L 0 .072 .614 r
F
.37074 .15485 m .36009 .14537 L .36577 .13976 L 0 .079 .62 r
F
.57885 .64782 m .58288 .65265 L .58398 .65258 L .641 .112 0 r
F
.57885 .64782 m .57782 .64786 L .58288 .65265 L F
.53182 .62538 m .53491 .62604 L .5361 .62605 L .253 0 0 r
F
.53182 .62538 m .53122 .62537 L .53491 .62604 L F
.36577 .13976 m .35502 .13017 L .36081 .12421 L 0 .072 .614 r
F
.53394 .39017 m .5325 .38804 L .53608 .38816 L .606 .844 .989 r
F
.53394 .39017 m .53125 .39008 L .5325 .38804 L F
.38921 .7919 m .38905 .79041 L .3839 .8029 L 0 0 0 r
F
.3944 .7797 m .38905 .79041 L .38921 .7919 L F
.54889 .38653 m .54964 .38337 L .55319 .38378 L .712 .916 .964 r
F
.54889 .38653 m .54594 .38619 L .54964 .38337 L F
.54224 .38856 m .54234 .38591 L .54594 .38619 L .67 .887 .977 r
F
.54224 .38856 m .53936 .38833 L .54234 .38591 L F
.58398 .65258 m .58794 .65789 L .58912 .6578 L .669 .153 0 r
F
.58398 .65258 m .58288 .65265 L .58794 .65789 L F
.50813 .62877 m .50725 .62877 L .50217 .63081 L 0 0 0 r
F
.513 .62718 m .50725 .62877 L .50813 .62877 L F
.52364 .62537 m .51864 .62605 L .51972 .62604 L .093 0 0 r
F
.52432 .62537 m .52364 .62537 L .51972 .62604 L .145 0 0 r
F
.48734 .37305 m .48392 .37381 L .47905 .36935 L .256 .504 .9 r
F
.49184 .37714 m .48392 .37381 L .48734 .37305 L .258 .526 .914 r
F
.38402 .80458 m .3839 .8029 L .37874 .81585 L 0 0 0 r
F
.38921 .7919 m .3839 .8029 L .38402 .80458 L F
.60271 .34116 m .6035 .33241 L .60775 .33404 L .901 .978 .801 r
F
.60271 .34116 m .59871 .33967 L .6035 .33241 L F
.51864 .62605 m .51786 .62605 L .513 .62718 L .063 0 0 r
F
.54258 .62719 m .54647 .62876 L .5476 .62877 L .39 0 0 r
F
.54258 .62719 m .54173 .62718 L .54647 .62876 L F
.53122 .62537 m .53346 .62604 L .53491 .62604 L .277 0 0 r
F
.53122 .62537 m .5305 .62537 L .53346 .62604 L F
.52283 .39011 m .51776 .38822 L .52124 .38808 L .503 .764 .989 r
F
.5256 .39005 m .52283 .39011 L .52124 .38808 L .538 .784 .988 r
F
.58912 .6578 m .593 .6636 L .59427 .66347 L .693 .19 0 r
F
.58912 .6578 m .58794 .65789 L .593 .6636 L F
.37881 .81772 m .37874 .81585 L .37359 .82927 L 0 0 0 r
F
.38402 .80458 m .37874 .81585 L .37881 .81772 L F
.53125 .39008 m .52874 .38799 L .5325 .38804 L .589 .823 .988 r
F
.53125 .39008 m .52844 .39004 L .52874 .38799 L F
.50404 .38352 m .50082 .38395 L .49633 .38078 L .373 .623 .949 r
F
.50798 .38631 m .50082 .38395 L .50404 .38352 L .365 .646 .963 r
F
.52432 .62537 m .51972 .62604 L .52107 .62604 L .145 0 0 r
F
.52511 .62537 m .52432 .62537 L .52107 .62604 L .19 0 0 r
F
.53699 .62605 m .54038 .62717 L .54173 .62718 L .352 0 0 r
F
.53699 .62605 m .5361 .62605 L .54038 .62717 L F
.59427 .66347 m .59808 .66977 L .59941 .6696 L .714 .224 0 r
F
.59427 .66347 m .593 .6636 L .59808 .66977 L F
.50326 .63081 m .50217 .63081 L .49708 .63331 L 0 0 0 r
F
.50813 .62877 m .50217 .63081 L .50326 .63081 L F
.60775 .33404 m .6083 .32469 L .61278 .32647 L .91 .975 .79 r
F
.60775 .33404 m .6035 .33241 L .6083 .32469 L F
.5305 .62537 m .53182 .62603 L .53346 .62604 L .291 0 0 r
F
.5305 .62537 m .52968 .62537 L .53182 .62603 L F
.5256 .39005 m .52124 .38808 L .52495 .388 L .538 .784 .988 r
F
.52844 .39004 m .5256 .39005 L .52495 .388 L .567 .803 .988 r
F
.3736 .83134 m .37359 .82927 L .36843 .84314 L 0 0 0 r
F
.37881 .81772 m .37359 .82927 L .3736 .83134 L F
.52844 .39004 m .52495 .388 L .52874 .38799 L .567 .803 .988 r
F
.56533 .37755 m .56612 .37278 L .57008 .37352 L .8 .95 .918 r
F
.56533 .37755 m .5618 .37691 L .56612 .37278 L F
.52511 .62537 m .52107 .62604 L .52265 .62603 L .19 0 0 r
F
.52598 .62537 m .52511 .62537 L .52265 .62603 L .227 0 0 r
F
.59941 .6696 m .60315 .6764 L .60456 .67619 L .732 .254 0 r
F
.59941 .6696 m .59808 .66977 L .60315 .6764 L F
.5476 .62877 m .55121 .6308 L .55263 .63081 L .479 0 0 r
F
.5476 .62877 m .54647 .62876 L .55121 .6308 L F
.52968 .62537 m .53003 .62603 L .53182 .62603 L .296 0 0 r
F
.52968 .62537 m .52879 .62537 L .53003 .62603 L F
.36839 .84544 m .36843 .84314 L .36326 .85747 L 0 0 0 r
F
.3736 .83134 m .36843 .84314 L .36839 .84544 L F
.51461 .38841 m .50798 .38631 L .51136 .38601 L .428 .699 .978 r
F
.51776 .38822 m .51461 .38841 L .51136 .38601 L .487 .723 .976 r
F
.48283 .36849 m .47905 .36935 L .47417 .36444 L .253 .484 .886 r
F
.48734 .37305 m .47905 .36935 L .48283 .36849 L .256 .504 .9 r
F
.52598 .62537 m .52265 .62603 L .5244 .62603 L .227 0 0 r
F
.5269 .62537 m .52598 .62537 L .5244 .62603 L .257 0 0 r
F
.61278 .32647 m .6131 .31651 L .61782 .31844 L .918 .971 .779 r
F
.61278 .32647 m .6083 .32469 L .6131 .31651 L F
.52879 .62537 m .52815 .62603 L .53003 .62603 L .292 0 0 r
F
.52879 .62537 m .52785 .62537 L .52815 .62603 L F
.49839 .6333 m .49708 .63331 L .49199 .63626 L 0 0 0 r
F
.50326 .63081 m .49708 .63331 L .49839 .6333 L F
.60456 .67619 m .60824 .6835 L .60971 .68323 L .747 .281 0 r
F
.60456 .67619 m .60315 .6764 L .60824 .6835 L F
.5269 .62537 m .5244 .62603 L .52625 .62603 L .257 0 0 r
F
.52785 .62537 m .5269 .62537 L .52625 .62603 L .278 0 0 r
F
.52785 .62537 m .52625 .62603 L .52815 .62603 L F
.51864 .62605 m .513 .62718 L .51416 .62717 L .063 0 0 r
F
.51972 .62604 m .51864 .62605 L .51416 .62717 L .151 0 0 r
F
.51416 .62717 m .513 .62718 L .50813 .62877 L .086 0 0 r
F
.36316 .86001 m .36326 .85747 L .3581 .87226 L 0 0 0 r
F
.36839 .84544 m .36326 .85747 L .36316 .86001 L F
.51136 .38601 m .50798 .38631 L .50404 .38352 L .445 .677 .963 r
F
.60971 .68323 m .61333 .69106 L .61486 .69073 L .761 .306 0 r
F
.60971 .68323 m .60824 .6835 L .61333 .69106 L F
.53936 .38833 m .53823 .38569 L .54234 .38591 L .663 .86 .975 r
F
.53936 .38833 m .53608 .38816 L .53823 .38569 L F
.61782 .31844 m .61791 .30786 L .62286 .30995 L .925 .968 .769 r
F
.61782 .31844 m .6131 .31651 L .61791 .30786 L F
.5361 .62605 m .5386 .62716 L .54038 .62717 L .398 0 0 r
F
.5361 .62605 m .53491 .62604 L .5386 .62716 L F
.35793 .87506 m .3581 .87226 L .35293 .88752 L 0 0 0 r
F
.36316 .86001 m .3581 .87226 L .35793 .87506 L F
.55319 .38378 m .55336 .38009 L .55749 .38058 L .746 .914 .949 r
F
.55319 .38378 m .54964 .38337 L .55336 .38009 L F
.55263 .63081 m .55597 .6333 L .55766 .63331 L .555 0 0 r
F
.55263 .63081 m .55121 .6308 L .55597 .6333 L F
.4935 .63626 m .49199 .63626 L .4869 .63966 L 0 0 0 r
F
.49839 .6333 m .49199 .63626 L .4935 .63626 L F
.61486 .69073 m .61843 .69909 L .62001 .69868 L .773 .328 0 r
F
.61486 .69073 m .61333 .69106 L .61843 .69909 L F
.54173 .62718 m .54468 .62875 L .54647 .62876 L .465 0 0 r
F
.54173 .62718 m .54038 .62717 L .54468 .62875 L F
.35793 .87506 m .35293 .88752 L .35269 .89059 L 0 0 0 r
F
.47832 .36348 m .47417 .36444 L .46928 .35907 L .251 .466 .873 r
F
.48283 .36849 m .47417 .36444 L .47832 .36348 L .253 .484 .886 r
F
.57008 .37352 m .57045 .36819 L .57484 .36902 L .821 .947 .904 r
F
.57008 .37352 m .56612 .37278 L .57045 .36819 L F
.50009 .38026 m .49633 .38078 L .49184 .37714 L .378 .601 .935 r
F
.50404 .38352 m .49633 .38078 L .50009 .38026 L .373 .623 .949 r
F
.62286 .30995 m .62273 .29875 L .6279 .30101 L .931 .964 .759 r
F
.62286 .30995 m .61791 .30786 L .62273 .29875 L F
.62001 .69868 m .62353 .70758 L .62517 .7071 L .783 .348 0 r
F
.62001 .69868 m .61843 .69909 L .62353 .70758 L F
.51972 .62604 m .51416 .62717 L .51579 .62717 L .151 0 0 r
F
.52107 .62604 m .51972 .62604 L .51579 .62717 L .227 0 0 r
F
.54594 .38619 m .54533 .38302 L .54964 .38337 L .709 .883 .961 r
F
.54594 .38619 m .54234 .38591 L .54533 .38302 L F
.48861 .63968 m .4869 .63966 L .4818 .64353 L 0 0 0 r
F
.4935 .63626 m .4869 .63966 L .48861 .63968 L F
.50969 .62876 m .50813 .62877 L .50326 .63081 L .105 0 0 r
F
.51416 .62717 m .50813 .62877 L .50969 .62876 L .086 0 0 r
F
.51776 .38822 m .51136 .38601 L .51529 .38576 L .487 .723 .976 r
F
.52124 .38808 m .51776 .38822 L .51529 .38576 L .533 .745 .973 r
F
.55766 .63331 m .56073 .63626 L .56269 .63626 L .618 .051 0 r
F
.55766 .63331 m .55597 .6333 L .56073 .63626 L F
.6279 .30101 m .62754 .28917 L .63295 .29162 L .937 .961 .75 r
F
.6279 .30101 m .62273 .29875 L .62754 .28917 L F
.62517 .7071 m .62864 .71654 L .63033 .71597 L .792 .367 0 r
F
.62517 .7071 m .62353 .70758 L .62864 .71654 L F
.53491 .62604 m .53643 .62716 L .5386 .62716 L .427 0 0 r
F
.53491 .62604 m .53346 .62604 L .53643 .62716 L F
.53608 .38816 m .53375 .38554 L .53823 .38569 L .648 .834 .972 r
F
.53608 .38816 m .5325 .38804 L .53375 .38554 L F
.51579 .62717 m .51416 .62717 L .50969 .62876 L .197 0 0 r
F
.4738 .358 m .46928 .35907 L .46439 .35324 L .248 .449 .86 r
F
.47832 .36348 m .46928 .35907 L .4738 .358 L .251 .466 .873 r
F
.48371 .64355 m .4818 .64353 L .47669 .64784 L 0 0 0 r
F
.48861 .63968 m .4818 .64353 L .48371 .64355 L F
.63033 .71597 m .63375 .72597 L .63549 .7253 L .8 .383 0 r
F
.63033 .71597 m .62864 .71654 L .63375 .72597 L F
.63295 .29162 m .63237 .27913 L .63799 .28177 L .942 .958 .742 r
F
.63295 .29162 m .62754 .28917 L .63237 .27913 L F
.52107 .62604 m .51579 .62717 L .51782 .62716 L .227 0 0 r
F
.52265 .62603 m .52107 .62604 L .51782 .62716 L .29 0 0 r
F
.57484 .36902 m .57479 .36314 L .5796 .36407 L .839 .944 .891 r
F
.57484 .36902 m .57045 .36819 L .57479 .36314 L F
.54647 .62876 m .54899 .6308 L .55121 .6308 L .557 0 0 r
F
.54647 .62876 m .54468 .62875 L .54899 .6308 L F
.56269 .63626 m .5655 .63968 L .56773 .63967 L .672 .121 0 r
F
.56269 .63626 m .56073 .63626 L .5655 .63968 L F
.63549 .7253 m .63888 .73587 L .64066 .73509 L .806 .399 0 r
F
.63549 .7253 m .63375 .72597 L .63888 .73587 L F
.52124 .38808 m .51529 .38576 L .51965 .38559 L .533 .745 .973 r
F
.52495 .388 m .52124 .38808 L .51965 .38559 L .571 .766 .97 r
F
.53346 .62604 m .53396 .62716 L .53643 .62716 L .441 0 0 r
F
.53346 .62604 m .53182 .62603 L .53396 .62716 L F
.63799 .28177 m .63719 .26862 L .64304 .27146 L .946 .954 .733 r
F
.63799 .28177 m .63237 .27913 L .63719 .26862 L F
.55749 .38058 m .55708 .37634 L .5618 .37691 L .773 .909 .934 r
F
.55749 .38058 m .55336 .38009 L .55708 .37634 L F
.50809 .38314 m .50404 .38352 L .50009 .38026 L .456 .656 .947 r
F
.51136 .38601 m .50404 .38352 L .50809 .38314 L .445 .677 .963 r
F
.54038 .62717 m .5423 .62875 L .54468 .62875 L .513 0 0 r
F
.54038 .62717 m .5386 .62716 L .5423 .62875 L F
.5052 .6308 m .50326 .63081 L .49839 .6333 L .12 0 0 r
F
.50969 .62876 m .50326 .63081 L .5052 .6308 L .105 0 0 r
F
.51529 .38576 m .51136 .38601 L .50809 .38314 L .506 .703 .959 r
F
.47881 .64789 m .47669 .64784 L .47159 .65262 L 0 0 0 r
F
.48371 .64355 m .47669 .64784 L .47881 .64789 L F
.49613 .37654 m .49184 .37714 L .48734 .37305 L .382 .581 .92 r
F
.50009 .38026 m .49184 .37714 L .49613 .37654 L .378 .601 .935 r
F
.5325 .38804 m .52904 .38548 L .53375 .38554 L .628 .81 .97 r
F
.5325 .38804 m .52874 .38799 L .52904 .38548 L F
.64066 .73509 m .64401 .74624 L .64583 .74535 L .812 .413 0 r
F
.64066 .73509 m .63888 .73587 L .64401 .74624 L F
.52265 .62603 m .51782 .62716 L .52019 .62716 L .29 0 0 r
F
.5244 .62603 m .52265 .62603 L .52019 .62716 L .341 0 0 r
F
.64304 .27146 m .64203 .25764 L .64809 .26069 L .95 .951 .726 r
F
.64304 .27146 m .63719 .26862 L .64203 .25764 L F
.46927 .35206 m .46439 .35324 L .4595 .34696 L .246 .433 .849 r
F
.4738 .358 m .46439 .35324 L .46927 .35206 L .248 .449 .86 r
F
.52495 .388 m .51965 .38559 L .52429 .38549 L .571 .766 .97 r
F
.52874 .38799 m .52495 .388 L .52429 .38549 L .603 .787 .969 r
F
.52874 .38799 m .52429 .38549 L .52904 .38548 L F
.53182 .62603 m .53127 .62715 L .53396 .62716 L .442 0 0 r
F
.53182 .62603 m .53003 .62603 L .53127 .62715 L F
.56773 .63967 m .57028 .64356 L .57277 .64354 L .716 .182 0 r
F
.56773 .63967 m .5655 .63968 L .57028 .64356 L F
.64583 .74535 m .64914 .75709 L .651 .75606 L .818 .425 0 r
F
.64583 .74535 m .64401 .74624 L .64914 .75709 L F
.64809 .26069 m .64686 .24619 L .65314 .24947 L .954 .948 .718 r
F
.64809 .26069 m .64203 .25764 L .64686 .24619 L F
.4739 .65269 m .47159 .65262 L .46648 .65786 L 0 0 0 r
F
.47881 .64789 m .47159 .65262 L .4739 .65269 L F
.54234 .38591 m .54039 .38276 L .54533 .38302 L .696 .851 .957 r
F
.54234 .38591 m .53823 .38569 L .54039 .38276 L F
.5244 .62603 m .52019 .62716 L .52281 .62715 L .341 0 0 r
F
.52625 .62603 m .5244 .62603 L .52281 .62715 L .382 0 0 r
F
.5796 .36407 m .57913 .35762 L .58437 .35866 L .854 .939 .878 r
F
.5796 .36407 m .57479 .36314 L .57913 .35762 L F
.53003 .62603 m .52845 .62715 L .53127 .62715 L .432 0 0 r
F
.53003 .62603 m .52815 .62603 L .52845 .62715 L F
.51579 .62717 m .50969 .62876 L .51185 .62875 L .197 0 0 r
F
.51782 .62716 m .51579 .62717 L .51185 .62875 L .289 0 0 r
F
.54964 .38337 m .54832 .37968 L .55336 .38009 L .737 .876 .945 r
F
.54964 .38337 m .54533 .38302 L .54832 .37968 L F
.52625 .62603 m .52281 .62715 L .52559 .62715 L .382 0 0 r
F
.52815 .62603 m .52625 .62603 L .52559 .62715 L .412 0 0 r
F
.52815 .62603 m .52559 .62715 L .52845 .62715 L F
.65314 .24947 m .65171 .23428 L .65819 .23779 L .957 .945 .711 r
F
.65314 .24947 m .64686 .24619 L .65171 .23428 L F
.55121 .6308 m .5533 .6333 L .55597 .6333 L .631 .079 0 r
F
.55121 .6308 m .54899 .6308 L .5533 .6333 L F
.51185 .62875 m .50969 .62876 L .5052 .6308 L .233 0 0 r
F
.651 .75606 m .65429 .7684 L .65618 .76723 L .822 .437 0 r
F
.651 .75606 m .64914 .75709 L .65429 .7684 L F
.5007 .6333 m .49839 .6333 L .4935 .63626 L .132 0 0 r
F
.5052 .6308 m .49839 .6333 L .5007 .6333 L .12 0 0 r
F
.46473 .34565 m .4595 .34696 L .4546 .34021 L .243 .419 .837 r
F
.46927 .35206 m .4595 .34696 L .46473 .34565 L .246 .433 .849 r
F
.46897 .65795 m .46648 .65786 L .46136 .66355 L 0 0 0 r
F
.4739 .65269 m .46648 .65786 L .46897 .65795 L F
.5386 .62716 m .53941 .62874 L .5423 .62875 L .538 0 0 r
F
.5386 .62716 m .53643 .62716 L .53941 .62874 L F
.65819 .23779 m .65655 .2219 L .66324 .22566 L .96 .942 .704 r
F
.65819 .23779 m .65171 .23428 L .65655 .2219 L F
.57277 .64354 m .57507 .6479 L .57782 .64786 L .753 .235 0 r
F
.57277 .64354 m .57028 .64356 L .57507 .6479 L F
.65618 .76723 m .65944 .78019 L .66136 .77887 L .826 .448 0 r
F
.65618 .76723 m .65429 .7684 L .65944 .78019 L F
.49216 .37236 m .48734 .37305 L .48283 .36849 L .384 .563 .906 r
F
.49613 .37654 m .48734 .37305 L .49216 .37236 L .382 .581 .92 r
F
.5618 .37691 m .56081 .37213 L .56612 .37278 L .793 .903 .919 r
F
.5618 .37691 m .55708 .37634 L .56081 .37213 L F
.51529 .38576 m .50809 .38314 L .51281 .38285 L .506 .703 .959 r
F
.51965 .38559 m .51529 .38576 L .51281 .38285 L .554 .725 .954 r
F
.66324 .22566 m .6614 .20904 L .6683 .21307 L .962 .939 .698 r
F
.66324 .22566 m .65655 .2219 L .6614 .20904 L F
.54468 .62875 m .54602 .63079 L .54899 .6308 L .6 .056 0 r
F
.54468 .62875 m .5423 .62875 L .54602 .63079 L F
.58437 .35866 m .58348 .35164 L .58915 .35279 L .866 .935 .866 r
F
.58437 .35866 m .57913 .35762 L .58348 .35164 L F
.46405 .66368 m .46136 .66355 L .45624 .66971 L 0 0 0 r
F
.46897 .65795 m .46136 .66355 L .46405 .66368 L F
.66136 .77887 m .6646 .79246 L .66655 .79096 L .83 .458 0 r
F
.66136 .77887 m .65944 .78019 L .6646 .79246 L F
.50481 .37982 m .50009 .38026 L .49613 .37654 L .464 .637 .931 r
F
.50809 .38314 m .50009 .38026 L .50481 .37982 L .456 .656 .947 r
F
.6683 .21307 m .66626 .19572 L .67335 .20002 L .965 .936 .692 r
F
.6683 .21307 m .6614 .20904 L .66626 .19572 L F
.46018 .33878 m .4546 .34021 L .4497 .33301 L .241 .406 .827 r
F
.46473 .34565 m .4546 .34021 L .46018 .33878 L .243 .419 .837 r
F
.51782 .62716 m .51185 .62875 L .51456 .62874 L .289 0 0 r
F
.52019 .62716 m .51782 .62716 L .51456 .62874 L .362 0 0 r
F
.53823 .38569 m .535 .38258 L .54039 .38276 L .678 .822 .953 r
F
.53823 .38569 m .53375 .38554 L .535 .38258 L F
.57782 .64786 m .57986 .65271 L .58288 .65265 L .784 .281 0 r
F
.57782 .64786 m .57507 .6479 L .57986 .65271 L F
.49619 .63626 m .4935 .63626 L .48861 .63968 L .142 0 0 r
F
.5007 .6333 m .4935 .63626 L .49619 .63626 L .132 0 0 r
F
.67335 .20002 m .67111 .18193 L .67841 .18651 L .967 .934 .686 r
F
.67335 .20002 m .66626 .19572 L .67111 .18193 L F
.77037 .47385 m .76469 .47881 L .76675 .48072 L .791 .905 .505 r
F
.77037 .47385 m .76832 .47182 L .76469 .47881 L F
.7748 .46697 m .76832 .47182 L .77037 .47385 L .763 .925 .56 r
F
.55597 .6333 m .55763 .63626 L .56073 .63626 L .688 .159 0 r
F
.55597 .6333 m .5533 .6333 L .55763 .63626 L F
.76675 .48072 m .76187 .48579 L .76394 .4876 L .815 .876 .44 r
F
.76675 .48072 m .76469 .47881 L .76187 .48579 L F
.7748 .46697 m .77277 .46482 L .76832 .47182 L .763 .925 .56 r
F
.78005 .46009 m .77277 .46482 L .7748 .46697 L .735 .937 .607 r
F
.66655 .79096 m .66977 .8052 L .67174 .80352 L .833 .467 0 r
F
.66655 .79096 m .6646 .79246 L .66977 .8052 L F
.51281 .38285 m .50809 .38314 L .50481 .37982 L .519 .683 .941 r
F
.76394 .4876 m .75986 .49275 L .76194 .49446 L .833 .836 .365 r
F
.76394 .4876 m .76187 .48579 L .75986 .49275 L F
.78005 .46009 m .77804 .4578 L .77277 .46482 L .735 .937 .607 r
F
.7861 .4532 m .77804 .4578 L .78005 .46009 L .706 .943 .646 r
F
.53643 .62716 m .53612 .62874 L .53941 .62874 L .545 .016 0 r
F
.53643 .62716 m .53396 .62716 L .53612 .62874 L F
.76194 .49446 m .75867 .49971 L .76075 .50133 L .843 .783 .281 r
F
.76194 .49446 m .75986 .49275 L .75867 .49971 L F
.7861 .4532 m .78413 .45076 L .77804 .4578 L .706 .943 .646 r
F
.79297 .44631 m .78413 .45076 L .7861 .4532 L .678 .945 .678 r
F
.45911 .66988 m .45624 .66971 L .45112 .67632 L 0 0 0 r
F
.46405 .66368 m .45624 .66971 L .45911 .66988 L F
.67841 .18651 m .67598 .16766 L .68346 .17255 L .969 .931 .68 r
F
.67841 .18651 m .67111 .18193 L .67598 .16766 L F
.76075 .50133 m .75829 .50666 L .76037 .50819 L .844 .718 .191 r
F
.76075 .50133 m .75867 .49971 L .75829 .50666 L F
.79297 .44631 m .79104 .44371 L .78413 .45076 L .678 .945 .678 r
F
.80065 .43941 m .79104 .44371 L .79297 .44631 L .651 .945 .705 r
F
.5079 .63079 m .5052 .6308 L .5007 .6333 L .261 0 0 r
F
.51185 .62875 m .5052 .6308 L .5079 .63079 L .233 0 0 r
F
.51965 .38559 m .51281 .38285 L .51806 .38263 L .554 .725 .954 r
F
.52429 .38549 m .51965 .38559 L .51806 .38263 L .594 .748 .951 r
F
.76037 .50819 m .75873 .5136 L .76081 .51505 L .833 .643 .096 r
F
.76037 .50819 m .75829 .50666 L .75873 .5136 L F
.80065 .43941 m .79878 .43664 L .79104 .44371 L .651 .945 .705 r
F
.80915 .43251 m .79878 .43664 L .80065 .43941 L .626 .942 .728 r
F
.67174 .80352 m .67494 .81842 L .67693 .81655 L .835 .475 0 r
F
.67174 .80352 m .66977 .8052 L .67494 .81842 L F
.45563 .33144 m .4497 .33301 L .44479 .32534 L .238 .394 .817 r
F
.46018 .33878 m .4497 .33301 L .45563 .33144 L .241 .406 .827 r
F
.68346 .17255 m .68084 .15293 L .68852 .15814 L .971 .929 .675 r
F
.68346 .17255 m .67598 .16766 L .68084 .15293 L F
.51456 .62874 m .51185 .62875 L .5079 .63079 L .334 0 0 r
F
.58915 .35279 m .58784 .34519 L .59393 .34646 L .876 .931 .854 r
F
.58915 .35279 m .58348 .35164 L .58784 .34519 L F
.48818 .36772 m .48283 .36849 L .47832 .36348 L .386 .547 .892 r
F
.49216 .37236 m .48283 .36849 L .48818 .36772 L .384 .563 .906 r
F
.58288 .65265 m .58467 .65799 L .58794 .65789 L .809 .322 0 r
F
.58288 .65265 m .57986 .65271 L .58467 .65799 L F
.76081 .51505 m .75997 .52054 L .76205 .52191 L .812 .56 .002 r
F
.76081 .51505 m .75873 .5136 L .75997 .52054 L F
.52019 .62716 m .51456 .62874 L .51772 .62874 L .362 0 0 r
F
.52281 .62715 m .52019 .62716 L .51772 .62874 L .42 0 0 r
F
.55336 .38009 m .55132 .37586 L .55708 .37634 L .758 .868 .928 r
F
.55336 .38009 m .54832 .37968 L .55132 .37586 L F
.80915 .43251 m .80734 .42954 L .79878 .43664 L .626 .942 .728 r
F
.81846 .4256 m .80734 .42954 L .80915 .43251 L .603 .938 .747 r
F
.53375 .38554 m .52935 .3825 L .535 .38258 L .654 .795 .95 r
F
.53375 .38554 m .52904 .38548 L .52935 .3825 L F
.56612 .37278 m .56456 .36746 L .57045 .36819 L .81 .897 .905 r
F
.56612 .37278 m .56081 .37213 L .56456 .36746 L F
.54533 .38302 m .54255 .37936 L .54832 .37968 L .72 .841 .939 r
F
.54533 .38302 m .54039 .38276 L .54255 .37936 L F
.68852 .15814 m .68571 .13772 L .69358 .14326 L .972 .927 .67 r
F
.68852 .15814 m .68084 .15293 L .68571 .13772 L F
.45417 .67654 m .45112 .67632 L .44599 .6834 L 0 0 .007 r
F
.45911 .66988 m .45112 .67632 L .45417 .67654 L 0 0 0 r
F
.76205 .52191 m .76204 .52747 L .76411 .52877 L .782 .473 0 r
F
.76205 .52191 m .75997 .52054 L .76204 .52747 L F
.81846 .4256 m .81673 .42243 L .80734 .42954 L .603 .938 .747 r
F
.82859 .41868 m .81673 .42243 L .81846 .4256 L .582 .933 .763 r
F
.67693 .81655 m .68013 .83212 L .68213 .83004 L .837 .483 0 r
F
.67693 .81655 m .67494 .81842 L .68013 .83212 L F
.53396 .62716 m .53252 .62873 L .53612 .62874 L .54 .026 0 r
F
.53396 .62716 m .53127 .62715 L .53252 .62873 L F
.49167 .63969 m .48861 .63968 L .48371 .64355 L .15 0 .004 r
F
.49619 .63626 m .48861 .63968 L .49167 .63969 L .142 0 0 r
F
.52429 .38549 m .51806 .38263 L .52363 .38252 L .594 .748 .951 r
F
.52904 .38548 m .52429 .38549 L .52363 .38252 L .626 .771 .949 r
F
.69358 .14326 m .69059 .12204 L .69863 .12793 L .974 .924 .665 r
F
.69358 .14326 m .68571 .13772 L .69059 .12204 L F
.52904 .38548 m .52363 .38252 L .52935 .3825 L .626 .771 .949 r
F
.5423 .62875 m .5424 .63079 L .54602 .63079 L .617 .101 0 r
F
.5423 .62875 m .53941 .62874 L .5424 .63079 L F
.54899 .6308 m .54974 .6333 L .5533 .6333 L .665 .149 .002 r
F
.54899 .6308 m .54602 .63079 L .54974 .6333 L F
.76411 .52877 m .76492 .5344 L .76698 .53563 L .745 .386 0 r
F
.76411 .52877 m .76204 .52747 L .76492 .5344 L F
.82859 .41868 m .82696 .41529 L .81673 .42243 L .582 .933 .763 r
F
.83954 .41175 m .82696 .41529 L .82859 .41868 L .563 .928 .777 r
F
.56073 .63626 m .56196 .63969 L .5655 .63968 L .734 .226 .013 r
F
.56073 .63626 m .55763 .63626 L .56196 .63969 L F
.45107 .32363 m .44479 .32534 L .43988 .31722 L .236 .383 .808 r
F
.45563 .33144 m .44479 .32534 L .45107 .32363 L .238 .394 .817 r
F
.52281 .62715 m .51772 .62874 L .52122 .62874 L .42 0 0 r
F
.52559 .62715 m .52281 .62715 L .52122 .62874 L .465 0 0 r
F
.68213 .83004 m .68532 .8463 L .68733 .84399 L .839 .49 0 r
F
.68213 .83004 m .68013 .83212 L .68532 .8463 L F
.58794 .65789 m .58948 .66373 L .593 .6636 L .831 .358 .03 r
F
.58794 .65789 m .58467 .65799 L .58948 .66373 L F
.50152 .37603 m .49613 .37654 L .49216 .37236 L .47 .62 .915 r
F
.50481 .37982 m .49613 .37654 L .50152 .37603 L .464 .637 .931 r
F
.44922 .68367 m .44599 .6834 L .44085 .69094 L 0 0 .028 r
F
.45417 .67654 m .44599 .6834 L .44922 .68367 L 0 0 .007 r
F
.53127 .62715 m .52875 .62873 L .53252 .62873 L .524 .022 .004 r
F
.53127 .62715 m .52845 .62715 L .52875 .62873 L F
.76698 .53563 m .76862 .54133 L .77066 .54249 L .704 .302 0 r
F
.76698 .53563 m .76492 .5344 L .76862 .54133 L F
.83954 .41175 m .83802 .40812 L .82696 .41529 L .563 .928 .777 r
F
.8513 .40481 m .83802 .40812 L .83954 .41175 L .545 .923 .788 r
F
.59393 .34646 m .59221 .33828 L .59871 .33967 L .885 .926 .844 r
F
.59393 .34646 m .58784 .34519 L .59221 .33828 L F
.52559 .62715 m .52122 .62874 L .52494 .62873 L .465 0 0 r
F
.52845 .62715 m .52559 .62715 L .52494 .62873 L .499 .003 .009 r
F
.52845 .62715 m .52494 .62873 L .52875 .62873 L F
.50394 .6333 m .5007 .6333 L .49619 .63626 L .282 0 .036 r
F
.5079 .63079 m .5007 .6333 L .50394 .6333 L .261 0 0 r
F
.77066 .54249 m .77313 .54826 L .77516 .54936 L .662 .224 0 r
F
.77066 .54249 m .76862 .54133 L .77313 .54826 L F
.68733 .84399 m .69052 .86096 L .69254 .85841 L .841 .497 0 r
F
.68733 .84399 m .68532 .8463 L .69052 .86096 L F
.8513 .40481 m .84993 .40093 L .83802 .40812 L .545 .923 .788 r
F
.86389 .39787 m .84993 .40093 L .8513 .40481 L .529 .917 .799 r
F
.51281 .38285 m .50481 .37982 L .51033 .37947 L .519 .683 .941 r
F
.51806 .38263 m .51281 .38285 L .51033 .37947 L .568 .707 .935 r
F
.4842 .36261 m .47832 .36348 L .4738 .358 L .386 .532 .88 r
F
.48818 .36772 m .47832 .36348 L .4842 .36261 L .386 .547 .892 r
F
.44651 .31536 m .43988 .31722 L .43496 .30863 L .233 .372 .799 r
F
.45107 .32363 m .43988 .31722 L .44651 .31536 L .236 .383 .808 r
F
.48715 .64358 m .48371 .64355 L .47881 .64789 L .155 0 .052 r
F
.49167 .63969 m .48371 .64355 L .48715 .64358 L .15 0 .004 r
F
.51456 .62874 m .5079 .63079 L .51128 .63079 L .334 0 0 r
F
.51772 .62874 m .51456 .62874 L .51128 .63079 L .411 0 .041 r
F
.44426 .69127 m .44085 .69094 L .43572 .69894 L 0 0 .047 r
F
.44922 .68367 m .44085 .69094 L .44426 .69127 L 0 0 .028 r
F
.593 .6636 m .5943 .66994 L .59808 .66977 L .849 .389 .059 r
F
.593 .6636 m .58948 .66373 L .5943 .66994 L F
.77516 .54936 m .77847 .55519 L .78047 .55622 L .619 .153 0 r
F
.77516 .54936 m .77313 .54826 L .77847 .55519 L F
.86389 .39787 m .86268 .39371 L .84993 .40093 L .529 .917 .799 r
F
.87729 .39092 m .86268 .39371 L .86389 .39787 L .514 .912 .808 r
F
.51033 .37947 m .50481 .37982 L .50152 .37603 L .528 .666 .924 r
F
.57045 .36819 m .56831 .36231 L .57479 .36314 L .823 .891 .891 r
F
.57045 .36819 m .56456 .36746 L .56831 .36231 L F
.69254 .85841 m .69573 .8761 L .69775 .8733 L .843 .503 0 r
F
.69254 .85841 m .69052 .86096 L .69573 .8761 L F
.54039 .38276 m .53625 .37915 L .54255 .37936 L .698 .809 .934 r
F
.54039 .38276 m .535 .38258 L .53625 .37915 L F
.5655 .63968 m .56631 .64358 L .57028 .64356 L .77 .282 .069 r
F
.5655 .63968 m .56196 .63969 L .56631 .64358 L F
.51128 .63079 m .5079 .63079 L .50394 .6333 L .366 0 .064 r
F
.59871 .33967 m .59659 .33089 L .6035 .33241 L .892 .922 .834 r
F
.59871 .33967 m .59221 .33828 L .59659 .33089 L F
.53941 .62874 m .53827 .63078 L .5424 .63079 L .617 .125 .062 r
F
.53941 .62874 m .53612 .62874 L .53827 .63078 L F
.55708 .37634 m .55433 .37158 L .56081 .37213 L .775 .859 .913 r
F
.55708 .37634 m .55132 .37586 L .55433 .37158 L F
.78047 .55622 m .78464 .56212 L .7866 .56309 L .579 .088 0 r
F
.78047 .55622 m .77847 .55519 L .78464 .56212 L F
.87729 .39092 m .87628 .38646 L .86268 .39371 L .514 .912 .808 r
F
.44194 .30661 m .43496 .30863 L .43004 .29958 L .231 .363 .791 r
F
.44651 .31536 m .43496 .30863 L .44194 .30661 L .233 .372 .799 r
F
.43929 .69934 m .43572 .69894 L .43057 .7074 L 0 0 .064 r
F
.44426 .69127 m .43572 .69894 L .43929 .69934 L 0 0 .047 r
F
.69775 .8733 m .70094 .89173 L .70296 .88866 L .844 .509 0 r
F
.69775 .8733 m .69573 .8761 L .70094 .89173 L F
.5533 .6333 m .55347 .63627 L .55763 .63626 L .713 .223 .08 r
F
.5533 .6333 m .54974 .6333 L .55347 .63627 L F
.59808 .66977 m .59913 .67661 L .60315 .6764 L .865 .417 .084 r
F
.59808 .66977 m .5943 .66994 L .59913 .67661 L F
.7866 .56309 m .79162 .56905 L .79355 .56995 L .541 .031 0 r
F
.7866 .56309 m .78464 .56212 L .79162 .56905 L F
.54832 .37968 m .54472 .3755 L .55132 .37586 L .738 .83 .922 r
F
.54832 .37968 m .54255 .37936 L .54472 .3755 L F
.48261 .64793 m .47881 .64789 L .4739 .65269 L .16 0 .094 r
F
.48715 .64358 m .47881 .64789 L .48261 .64793 L .155 0 .052 r
F
.51806 .38263 m .51033 .37947 L .51645 .37922 L .568 .707 .935 r
F
.52363 .38252 m .51806 .38263 L .51645 .37922 L .609 .731 .932 r
F
.2876 .47148 m .28838 .4804 L .29123 .47849 L 0 0 .543 r
F
.49823 .37177 m .49216 .37236 L .48818 .36772 L .474 .604 .901 r
F
.50152 .37603 m .49216 .37236 L .49823 .37177 L .47 .62 .915 r
F
.4802 .35703 m .4738 .358 L .46927 .35206 L .387 .519 .868 r
F
.4842 .36261 m .4738 .358 L .4802 .35703 L .386 .532 .88 r
F
.29123 .47849 m .29119 .48729 L .29405 .48548 L 0 0 .481 r
F
.28315 .46445 m .28475 .47351 L .2876 .47148 L 0 .028 .595 r
F
.54602 .63079 m .5454 .63329 L .54974 .6333 L .672 .189 .094 r
F
.54602 .63079 m .5424 .63079 L .5454 .63329 L F
.51772 .62874 m .51128 .63079 L .51524 .63078 L .411 0 .041 r
F
.52122 .62874 m .51772 .62874 L .51524 .63078 L .471 .017 .091 r
F
.29405 .48548 m .29319 .49417 L .29605 .49246 L 0 0 .409 r
F
.27789 .45741 m .2803 .46661 L .28315 .46445 L 0 .089 .639 r
F
.49997 .63627 m .49619 .63626 L .49167 .63969 L .297 0 .102 r
F
.50394 .6333 m .49619 .63626 L .49997 .63627 L .282 0 .036 r
F
.29605 .49246 m .29439 .50105 L .29724 .49944 L 0 0 .329 r
F
.43431 .70788 m .43057 .7074 L .42542 .71633 L 0 0 .08 r
F
.43929 .69934 m .43057 .7074 L .43431 .70788 L 0 0 .064 r
F
.27181 .45035 m .27505 .4597 L .27789 .45741 L 0 .143 .675 r
F
.43736 .2974 m .43004 .29958 L .42512 .29007 L .229 .354 .783 r
F
.44194 .30661 m .43004 .29958 L .43736 .2974 L .231 .363 .791 r
F
.535 .38258 m .52965 .37905 L .53625 .37915 L .672 .781 .931 r
F
.535 .38258 m .52935 .3825 L .52965 .37905 L F
.6035 .33241 m .60097 .32303 L .6083 .32469 L .899 .917 .825 r
F
.6035 .33241 m .59659 .33089 L .60097 .32303 L F
.29724 .49944 m .29476 .50793 L .29762 .5064 L 0 0 .241 r
F
.79355 .56995 m .79944 .576 L .80131 .57683 L .505 0 0 r
F
.79355 .56995 m .79162 .56905 L .79944 .576 L F
.2649 .44327 m .26898 .45279 L .27181 .45035 L 0 .191 .706 r
F
.2649 .44327 m .26209 .44587 L .26898 .45279 L F
.53612 .62874 m .53377 .63078 L .53827 .63078 L .605 .132 .104 r
F
.53612 .62874 m .53252 .62873 L .53377 .63078 L F
.57028 .64356 m .57066 .64794 L .57507 .6479 L .799 .33 .116 r
F
.57028 .64356 m .56631 .64358 L .57066 .64794 L F
.29762 .5064 m .29433 .51481 L .29718 .51336 L 0 0 .148 r
F
.57479 .36314 m .57207 .3567 L .57913 .35762 L .833 .885 .879 r
F
.57479 .36314 m .56831 .36231 L .57207 .3567 L F
.60315 .6764 m .60397 .68376 L .60824 .6835 L .879 .442 .107 r
F
.60315 .6764 m .59913 .67661 L .60397 .68376 L F
.25718 .43617 m .26209 .44587 L .2649 .44327 L 0 .234 .731 r
F
.25718 .43617 m .25439 .43894 L .26209 .44587 L F
.52363 .38252 m .51645 .37922 L .52297 .37908 L .609 .731 .932 r
F
.52935 .3825 m .52363 .38252 L .52297 .37908 L .643 .755 .93 r
F
.52935 .3825 m .52297 .37908 L .52965 .37905 L F
.29718 .51336 m .29308 .52168 L .29594 .5203 L 0 0 .055 r
F
.42932 .71689 m .42542 .71633 L .42027 .72572 L 0 0 .094 r
F
.43431 .70788 m .42542 .71633 L .42932 .71689 L 0 0 .08 r
F
.24862 .42904 m .25439 .43894 L .25718 .43617 L 0 .271 .751 r
F
.24862 .42904 m .24587 .43201 L .25439 .43894 L F
.52122 .62874 m .51524 .63078 L .51962 .63078 L .471 .017 .091 r
F
.52494 .62873 m .52122 .62874 L .51962 .63078 L .519 .068 .12 r
F
.80131 .57683 m .8081 .58295 L .8099 .5837 L .473 0 0 r
F
.80131 .57683 m .79944 .576 L .8081 .58295 L F
.43277 .28771 m .42512 .29007 L .42019 .2801 L .226 .345 .776 r
F
.43736 .2974 m .42512 .29007 L .43277 .28771 L .229 .354 .783 r
F
.47807 .65275 m .4739 .65269 L .46897 .65795 L .164 0 .13 r
F
.48261 .64793 m .4739 .65269 L .47807 .65275 L .16 0 .094 r
F
.29594 .5203 m .29102 .52855 L .29388 .52725 L 0 0 0 r
F
.53252 .62873 m .52905 .63078 L .53377 .63078 L .584 .124 .126 r
F
.53252 .62873 m .52875 .62873 L .52905 .63078 L F
.51033 .37947 m .50152 .37603 L .50783 .37562 L .528 .666 .924 r
F
.51645 .37922 m .51033 .37947 L .50783 .37562 L .578 .691 .918 r
F
.51128 .63079 m .50394 .6333 L .508 .63329 L .366 0 .064 r
F
.51524 .63078 m .51128 .63079 L .508 .63329 L .445 .02 .137 r
F
.23923 .42189 m .24587 .43201 L .24862 .42904 L 0 .304 .769 r
F
.23923 .42189 m .23653 .42506 L .24587 .43201 L F
.50783 .37562 m .50152 .37603 L .49823 .37177 L .535 .65 .909 r
F
.6083 .32469 m .60536 .3147 L .6131 .31651 L .905 .913 .816 r
F
.6083 .32469 m .60097 .32303 L .60536 .3147 L F
.508 .63329 m .50394 .6333 L .49997 .63627 L .39 0 .141 r
F
.47619 .35098 m .46927 .35206 L .46473 .34565 L .387 .507 .858 r
F
.4802 .35703 m .46927 .35206 L .47619 .35098 L .387 .519 .868 r
F
.56081 .37213 m .55735 .36684 L .56456 .36746 L .787 .851 .899 r
F
.56081 .37213 m .55433 .37158 L .55735 .36684 L F
.55763 .63626 m .55722 .6397 L .56196 .63969 L .749 .284 .145 r
F
.55763 .63626 m .55347 .63627 L .55722 .6397 L F
.52494 .62873 m .51962 .63078 L .52428 .63078 L .519 .068 .12 r
F
.52875 .62873 m .52494 .62873 L .52428 .63078 L .556 .103 .132 r
F
.60824 .6835 m .60882 .69138 L .61333 .69106 L .89 .464 .128 r
F
.60824 .6835 m .60397 .68376 L .60882 .69138 L F
.52875 .62873 m .52428 .63078 L .52905 .63078 L .556 .103 .132 r
F
.29388 .52725 m .28814 .53543 L .291 .53419 L 0 0 0 r
F
.8099 .5837 m .81759 .5899 L .81931 .59058 L .444 0 0 r
F
.8099 .5837 m .8081 .58295 L .81759 .5899 L F
.42433 .72639 m .42027 .72572 L .41511 .73558 L 0 0 .107 r
F
.42932 .71689 m .42027 .72572 L .42433 .72639 L 0 0 .094 r
F
.22901 .41471 m .23653 .42506 L .23923 .42189 L 0 .334 .784 r
F
.22901 .41471 m .22637 .41811 L .23653 .42506 L F
.42818 .27755 m .42019 .2801 L .41526 .26966 L .224 .337 .769 r
F
.43277 .28771 m .42019 .2801 L .42818 .27755 L .226 .345 .776 r
F
.49599 .6397 m .49167 .63969 L .48715 .64358 L .309 0 .156 r
F
.49997 .63627 m .49167 .63969 L .49599 .6397 L .297 0 .102 r
F
.54255 .37936 m .53751 .37525 L .54472 .3755 L .713 .797 .917 r
F
.54255 .37936 m .53625 .37915 L .53751 .37525 L F
.49492 .36705 m .48818 .36772 L .4842 .36261 L .477 .59 .888 r
F
.49823 .37177 m .48818 .36772 L .49492 .36705 L .474 .604 .901 r
F
.57507 .6479 m .57503 .65277 L .57986 .65271 L .822 .37 .157 r
F
.57507 .6479 m .57066 .64794 L .57503 .65277 L F
.5424 .63079 m .54044 .63329 L .5454 .63329 L .665 .208 .157 r
F
.5424 .63079 m .53827 .63078 L .54044 .63329 L F
.291 .53419 m .28445 .5423 L .28731 .54113 L 0 0 0 r
F
.21795 .40751 m .22637 .41811 L .22901 .41471 L 0 .36 .796 r
F
.21795 .40751 m .21539 .41114 L .22637 .41811 L F
.57913 .35762 m .57584 .35062 L .58348 .35164 L .842 .879 .868 r
F
.57913 .35762 m .57207 .3567 L .57584 .35062 L F
.47351 .65804 m .46897 .65795 L .46405 .66368 L .166 0 .162 r
F
.47807 .65275 m .46897 .65795 L .47351 .65804 L .164 0 .13 r
F
.81931 .59058 m .82792 .59687 L .82954 .59746 L .417 0 0 r
F
.81931 .59058 m .81759 .5899 L .82792 .59687 L F
.54974 .6333 m .54841 .63627 L .55347 .63627 L .712 .258 .171 r
F
.54974 .6333 m .5454 .63329 L .54841 .63627 L F
.6131 .31651 m .60976 .3059 L .61791 .30786 L .91 .909 .808 r
F
.6131 .31651 m .60536 .3147 L .60976 .3059 L F
.55132 .37586 m .5469 .37116 L .55433 .37158 L .751 .82 .906 r
F
.55132 .37586 m .54472 .3755 L .5469 .37116 L F
.61333 .69106 m .61368 .69948 L .61843 .69909 L .9 .483 .147 r
F
.61333 .69106 m .60882 .69138 L .61368 .69948 L F
.41933 .73635 m .41511 .73558 L .40994 .74591 L 0 0 .119 r
F
.42433 .72639 m .41511 .73558 L .41933 .73635 L 0 0 .107 r
F
.28731 .54113 m .27995 .54917 L .28279 .54807 L 0 0 0 r
F
.42358 .26692 m .41526 .26966 L .41033 .25876 L .222 .33 .763 r
F
.42818 .27755 m .41526 .26966 L .42358 .26692 L .224 .337 .769 r
F
.20604 .40027 m .21539 .41114 L .21795 .40751 L 0 .384 .807 r
F
.20604 .40027 m .20359 .40416 L .21539 .41114 L F
.47218 .34447 m .46473 .34565 L .46018 .33878 L .387 .496 .848 r
F
.47619 .35098 m .46473 .34565 L .47218 .34447 L .387 .507 .858 r
F
.51645 .37922 m .50783 .37562 L .51484 .37533 L .578 .691 .918 r
F
.52297 .37908 m .51645 .37922 L .51484 .37533 L .619 .715 .914 r
F
.51524 .63078 m .508 .63329 L .51275 .63329 L .445 .02 .137 r
F
.51962 .63078 m .51524 .63078 L .51275 .63329 L .506 .09 .184 r
F
.82954 .59746 m .83909 .60385 L .84059 .60435 L .393 0 0 r
F
.82954 .59746 m .82792 .59687 L .83909 .60385 L F
.28279 .54807 m .27462 .55605 L .27746 .55501 L 0 0 0 r
F
.19329 .393 m .20359 .40416 L .20604 .40027 L 0 .405 .816 r
F
.19329 .393 m .19096 .39717 L .20359 .40416 L F
.41431 .7468 m .40994 .74591 L .40477 .7567 L 0 0 .129 r
F
.41933 .73635 m .40994 .74591 L .41431 .7468 L 0 0 .119 r
F
.53625 .37915 m .52995 .37514 L .53751 .37525 L .685 .767 .914 r
F
.53625 .37915 m .52965 .37905 L .52995 .37514 L F
.41898 .25581 m .41033 .25876 L .40539 .2474 L .22 .323 .757 r
F
.42358 .26692 m .41033 .25876 L .41898 .25581 L .222 .33 .763 r
F
.57986 .65271 m .5794 .65807 L .58467 .65799 L .84 .404 .192 r
F
.57986 .65271 m .57503 .65277 L .5794 .65807 L F
.56196 .63969 m .56097 .64361 L .56631 .64358 L .777 .334 .198 r
F
.56196 .63969 m .55722 .6397 L .56097 .64361 L F
.61843 .69909 m .61855 .70805 L .62353 .70758 L .909 .501 .164 r
F
.61843 .69909 m .61368 .69948 L .61855 .70805 L F
.61791 .30786 m .61417 .29663 L .62273 .29875 L .914 .906 .801 r
F
.61791 .30786 m .60976 .3059 L .61417 .29663 L F
.53827 .63078 m .53503 .63329 L .54044 .63329 L .648 .211 .197 r
F
.53827 .63078 m .53377 .63078 L .53503 .63329 L F
.46894 .6638 m .46405 .66368 L .45911 .66988 L .168 0 .19 r
F
.47351 .65804 m .46405 .66368 L .46894 .6638 L .166 0 .162 r
F
.50471 .63627 m .49997 .63627 L .49599 .6397 L .407 .028 .204 r
F
.508 .63329 m .49997 .63627 L .50471 .63627 L .39 0 .141 r
F
.49199 .6436 m .48715 .64358 L .48261 .64793 L .318 0 .202 r
F
.49599 .6397 m .48715 .64358 L .49199 .6436 L .309 0 .156 r
F
.56456 .36746 m .56038 .36162 L .56831 .36231 L .797 .843 .886 r
F
.56456 .36746 m .55735 .36684 L .56038 .36162 L F
.27746 .55501 m .26848 .56292 L .27131 .56195 L 0 0 0 r
F
.50533 .37131 m .49823 .37177 L .49492 .36705 L .539 .636 .894 r
F
.50783 .37562 m .49823 .37177 L .50533 .37131 L .535 .65 .909 r
F
.84059 .60435 m .85112 .61084 L .85248 .61125 L .372 0 0 r
F
.84059 .60435 m .83909 .60385 L .85112 .61084 L F
.52297 .37908 m .51484 .37533 L .5223 .37517 L .619 .715 .914 r
F
.52965 .37905 m .52297 .37908 L .5223 .37517 L .655 .74 .913 r
F
.17968 .3857 m .19096 .39717 L .19329 .393 L 0 .424 .824 r
F
.17968 .3857 m .1775 .39017 L .19096 .39717 L F
.51275 .63329 m .508 .63329 L .50471 .63627 L .469 .076 .211 r
F
.58348 .35164 m .57962 .34406 L .58784 .34519 L .85 .873 .857 r
F
.58348 .35164 m .57584 .35062 L .57962 .34406 L F
.49161 .36186 m .4842 .36261 L .4802 .35703 L .479 .578 .876 r
F
.49492 .36705 m .4842 .36261 L .49161 .36186 L .477 .59 .888 r
F
.52965 .37905 m .5223 .37517 L .52995 .37514 L .655 .74 .913 r
F
.51484 .37533 m .50783 .37562 L .50533 .37131 L .586 .676 .903 r
F
.40929 .75772 m .40477 .7567 L .39959 .76797 L 0 0 .139 r
F
.41431 .7468 m .40477 .7567 L .40929 .75772 L 0 0 .129 r
F
.41437 .24423 m .40539 .2474 L .40045 .23557 L .218 .316 .751 r
F
.41898 .25581 m .40539 .2474 L .41437 .24423 L .22 .323 .757 r
F
.51962 .63078 m .51275 .63329 L .51801 .63329 L .506 .09 .184 r
F
.52428 .63078 m .51962 .63078 L .51801 .63329 L .554 .14 .212 r
F
.46816 .33748 m .46018 .33878 L .45563 .33144 L .386 .486 .839 r
F
.47218 .34447 m .46018 .33878 L .46816 .33748 L .387 .496 .848 r
F
.27131 .56195 m .26151 .5698 L .26432 .5689 L 0 0 0 r
F
.62353 .70758 m .62343 .7171 L .62864 .71654 L .916 .517 .179 r
F
.62353 .70758 m .61855 .70805 L .62343 .7171 L F
.62273 .29875 m .61858 .28688 L .62754 .28917 L .918 .902 .794 r
F
.62273 .29875 m .61417 .29663 L .61858 .28688 L F
.53377 .63078 m .52935 .63329 L .53503 .63329 L .623 .2 .217 r
F
.53377 .63078 m .52905 .63078 L .52935 .63329 L F
.85248 .61125 m .864 .61785 L .86519 .61815 L .352 0 0 r
F
.85248 .61125 m .85112 .61084 L .864 .61785 L F
.5454 .63329 m .54262 .63627 L .54841 .63627 L .699 .272 .23 r
F
.5454 .63329 m .54044 .63329 L .54262 .63627 L F
.55347 .63627 m .55143 .63971 L .55722 .6397 L .741 .312 .232 r
F
.55347 .63627 m .54841 .63627 L .55143 .63971 L F
.46437 .67003 m .45911 .66988 L .45417 .67654 L .17 0 .214 r
F
.46894 .6638 m .45911 .66988 L .46437 .67003 L .168 0 .19 r
F
.52428 .63078 m .51801 .63329 L .52361 .63329 L .554 .14 .212 r
F
.52905 .63078 m .52428 .63078 L .52361 .63329 L .592 .176 .222 r
F
.54472 .3755 m .53878 .37089 L .5469 .37116 L .724 .786 .901 r
F
.54472 .3755 m .53751 .37525 L .53878 .37089 L F
.40975 .23218 m .40045 .23557 L .3955 .22328 L .216 .31 .746 r
F
.41437 .24423 m .40045 .23557 L .40975 .23218 L .218 .316 .751 r
F
.58467 .65799 m .58379 .66384 L .58948 .66373 L .856 .434 .223 r
F
.58467 .65799 m .5794 .65807 L .58379 .66384 L F
.40426 .76912 m .39959 .76797 L .3944 .7797 L 0 0 .148 r
F
.40929 .75772 m .39959 .76797 L .40426 .76912 L 0 0 .139 r
F
.52905 .63078 m .52361 .63329 L .52935 .63329 L .592 .176 .222 r
F
.55433 .37158 m .54909 .36636 L .55735 .36684 L .761 .81 .892 r
F
.55433 .37158 m .5469 .37116 L .54909 .36636 L F
.26432 .5689 m .25373 .57669 L .25651 .57586 L 0 0 0 r
F
.56631 .64358 m .56474 .64798 L .57066 .64794 L .798 .375 .242 r
F
.56631 .64358 m .56097 .64361 L .56474 .64798 L F
.48799 .64797 m .48261 .64793 L .47807 .65275 L .326 0 .24 r
F
.49199 .6436 m .48261 .64793 L .48799 .64797 L .318 0 .202 r
F
.62864 .71654 m .62831 .72663 L .63375 .72597 L .923 .532 .193 r
F
.62864 .71654 m .62343 .7171 L .62831 .72663 L F
.86519 .61815 m .87774 .62487 L .87873 .62505 L .335 0 0 r
F
.86519 .61815 m .864 .61785 L .87774 .62487 L F
.62754 .28917 m .623 .27666 L .63237 .27913 L .922 .899 .787 r
F
.62754 .28917 m .61858 .28688 L .623 .27666 L F
.40513 .21964 m .3955 .22328 L .39055 .21052 L .214 .304 .741 r
F
.40975 .23218 m .3955 .22328 L .40513 .21964 L .216 .31 .746 r
F
.58784 .34519 m .58341 .33704 L .59221 .33828 L .856 .868 .848 r
F
.58784 .34519 m .57962 .34406 L .58341 .33704 L F
.46413 .33002 m .45563 .33144 L .45107 .32363 L .386 .477 .83 r
F
.46816 .33748 m .45563 .33144 L .46413 .33002 L .386 .486 .839 r
F
.39922 .78101 m .3944 .7797 L .38921 .7919 L 0 0 .157 r
F
.40426 .76912 m .3944 .7797 L .39922 .78101 L 0 0 .148 r
F
.56831 .36231 m .56342 .35593 L .57207 .3567 L .805 .836 .874 r
F
.56831 .36231 m .56038 .36162 L .56342 .35593 L F
.5014 .63971 m .49599 .6397 L .49199 .6436 L .42 .065 .254 r
F
.50471 .63627 m .49599 .6397 L .5014 .63971 L .407 .028 .204 r
F
.25651 .57586 m .24512 .58357 L .24786 .58282 L 0 0 0 r
F
.48829 .3562 m .4802 .35703 L .47619 .35098 L .48 .566 .865 r
F
.49161 .36186 m .4802 .35703 L .48829 .3562 L .479 .578 .876 r
F
.51484 .37533 m .50533 .37131 L .51323 .37097 L .586 .676 .903 r
F
.5223 .37517 m .51484 .37533 L .51323 .37097 L .627 .702 .899 r
F
.51275 .63329 m .50471 .63627 L .51025 .63627 L .469 .076 .211 r
F
.51801 .63329 m .51275 .63329 L .51025 .63627 L .53 .145 .255 r
F
.45978 .67674 m .45417 .67654 L .44922 .68367 L .171 0 .236 r
F
.46437 .67003 m .45417 .67654 L .45978 .67674 L .17 0 .214 r
F
.50283 .36652 m .49492 .36705 L .49161 .36186 L .543 .623 .882 r
F
.50533 .37131 m .49492 .36705 L .50283 .36652 L .539 .636 .894 r
F
.4005 .20663 m .39055 .21052 L .3856 .1973 L .212 .298 .736 r
F
.40513 .21964 m .39055 .21052 L .4005 .20663 L .214 .304 .741 r
F
.58948 .66373 m .58819 .67009 L .5943 .66994 L .869 .46 .249 r
F
.58948 .66373 m .58379 .66384 L .58819 .67009 L F
.63375 .72597 m .63321 .73663 L .63888 .73587 L .929 .545 .205 r
F
.63375 .72597 m .62831 .72663 L .63321 .73663 L F
.53751 .37525 m .53026 .37076 L .53878 .37089 L .695 .755 .898 r
F
.53751 .37525 m .52995 .37514 L .53026 .37076 L F
.63237 .27913 m .62743 .26595 L .63719 .26862 L .925 .896 .781 r
F
.63237 .27913 m .623 .27666 L .62743 .26595 L F
.54044 .63329 m .53629 .63627 L .54262 .63627 L .677 .27 .267 r
F
.54044 .63329 m .53503 .63329 L .53629 .63627 L F
.51025 .63627 m .50471 .63627 L .5014 .63971 L .486 .12 .269 r
F
.39417 .79338 m .38921 .7919 L .38402 .80458 L 0 0 .165 r
F
.39922 .78101 m .38921 .7919 L .39417 .79338 L 0 0 .157 r
F
.24786 .58282 m .23569 .59047 L .23838 .58979 L 0 0 0 r
F
.51323 .37097 m .50533 .37131 L .50283 .36652 L .591 .663 .889 r
F
.39586 .19314 m .3856 .1973 L .38065 .18362 L .21 .293 .731 r
F
.4005 .20663 m .3856 .1973 L .39586 .19314 L .212 .298 .736 r
F
.5223 .37517 m .51323 .37097 L .52164 .37079 L .627 .702 .899 r
F
.52995 .37514 m .5223 .37517 L .52164 .37079 L .663 .728 .897 r
F
.46009 .32208 m .45107 .32363 L .44651 .31536 L .385 .468 .822 r
F
.46413 .33002 m .45107 .32363 L .46009 .32208 L .386 .477 .83 r
F
.48397 .65281 m .47807 .65275 L .47351 .65804 L .331 .017 .273 r
F
.48799 .64797 m .47807 .65275 L .48397 .65281 L .326 0 .24 r
F
.52995 .37514 m .52164 .37079 L .53026 .37076 L .663 .728 .897 r
F
.55722 .6397 m .55446 .64362 L .56097 .64361 L .763 .356 .281 r
F
.55722 .6397 m .55143 .63971 L .55446 .64362 L F
.59221 .33828 m .5872 .32953 L .59659 .33089 L .861 .863 .839 r
F
.59221 .33828 m .58341 .33704 L .5872 .32953 L F
.57066 .64794 m .56852 .65283 L .57503 .65277 L .815 .409 .279 r
F
.57066 .64794 m .56474 .64798 L .56852 .65283 L F
.51801 .63329 m .51025 .63627 L .5164 .63627 L .53 .145 .255 r
F
.52361 .63329 m .51801 .63329 L .5164 .63627 L .578 .196 .281 r
F
.63888 .73587 m .63812 .74712 L .64401 .74624 L .934 .557 .217 r
F
.63888 .73587 m .63321 .73663 L .63812 .74712 L F
.45519 .68392 m .44922 .68367 L .44426 .69127 L .172 0 .255 r
F
.45978 .67674 m .44922 .68367 L .45519 .68392 L .171 0 .236 r
F
.63719 .26862 m .63187 .25477 L .64203 .25764 L .928 .893 .775 r
F
.63719 .26862 m .62743 .26595 L .63187 .25477 L F
.38911 .80624 m .38402 .80458 L .37881 .81772 L 0 0 .172 r
F
.39417 .79338 m .38402 .80458 L .38911 .80624 L 0 0 .165 r
F
.54841 .63627 m .5448 .63972 L .55143 .63971 L .723 .321 .287 r
F
.54841 .63627 m .54262 .63627 L .5448 .63972 L F
.23838 .58979 m .22542 .59736 L .22805 .59677 L 0 0 0 r
F
.55735 .36684 m .55128 .36108 L .56038 .36162 L .769 .802 .88 r
F
.55735 .36684 m .54909 .36636 L .55128 .36108 L F
.39122 .17918 m .38065 .18362 L .37569 .16946 L .208 .288 .726 r
F
.39586 .19314 m .38065 .18362 L .39122 .17918 L .21 .293 .731 r
F
.5469 .37116 m .54005 .36604 L .54909 .36636 L .733 .775 .887 r
F
.5469 .37116 m .53878 .37089 L .54005 .36604 L F
.53503 .63329 m .52966 .63627 L .53629 .63627 L .65 .257 .286 r
F
.53503 .63329 m .52935 .63329 L .52966 .63627 L F
.5943 .66994 m .5926 .67681 L .59913 .67661 L .879 .482 .273 r
F
.5943 .66994 m .58819 .67009 L .5926 .67681 L F
.48496 .35006 m .47619 .35098 L .47218 .34447 L .481 .556 .855 r
F
.48829 .3562 m .47619 .35098 L .48496 .35006 L .48 .566 .865 r
F
.57207 .3567 m .56647 .34976 L .57584 .35062 L .812 .829 .863 r
F
.57207 .3567 m .56342 .35593 L .56647 .34976 L F
.49809 .64362 m .49199 .6436 L .48799 .64797 L .429 .095 .295 r
F
.5014 .63971 m .49199 .6436 L .49809 .64362 L .42 .065 .254 r
F
.52361 .63329 m .5164 .63627 L .52295 .63627 L .578 .196 .281 r
F
.52935 .63329 m .52361 .63329 L .52295 .63627 L .617 .232 .291 r
F
.52935 .63329 m .52295 .63627 L .52966 .63627 L F
.38658 .16473 m .37569 .16946 L .37074 .15485 L .206 .283 .722 r
F
.39122 .17918 m .37569 .16946 L .38658 .16473 L .208 .288 .726 r
F
.38404 .81958 m .37881 .81772 L .3736 .83134 L 0 0 .178 r
F
.38911 .80624 m .37881 .81772 L .38404 .81958 L 0 0 .172 r
F
.64401 .74624 m .64304 .75809 L .64914 .75709 L .939 .568 .227 r
F
.64401 .74624 m .63812 .74712 L .64304 .75809 L F
.64203 .25764 m .63631 .24312 L .64686 .24619 L .93 .89 .769 r
F
.64203 .25764 m .63187 .25477 L .63631 .24312 L F
.22805 .59677 m .21433 .60427 L .21688 .60377 L 0 0 0 r
F
.45604 .31367 m .44651 .31536 L .44194 .30661 L .385 .46 .815 r
F
.46009 .32208 m .44651 .31536 L .45604 .31367 L .385 .468 .822 r
F
.50031 .36126 m .49161 .36186 L .48829 .3562 L .546 .612 .87 r
F
.50283 .36652 m .49161 .36186 L .50031 .36126 L .543 .623 .882 r
F
.45058 .69158 m .44426 .69127 L .43929 .69934 L .173 0 .272 r
F
.45519 .68392 m .44426 .69127 L .45058 .69158 L .172 0 .255 r
F
.59659 .33089 m .59101 .32155 L .60097 .32303 L .866 .858 .831 r
F
.59659 .33089 m .5872 .32953 L .59101 .32155 L F
.51025 .63627 m .5014 .63971 L .50774 .63971 L .486 .12 .269 r
F
.5164 .63627 m .51025 .63627 L .50774 .63971 L .547 .188 .311 r
F
.47995 .65812 m .47351 .65804 L .46894 .6638 L .336 .037 .301 r
F
.48397 .65281 m .47351 .65804 L .47995 .65812 L .331 .017 .273 r
F
.51323 .37097 m .50283 .36652 L .51161 .36614 L .591 .663 .889 r
F
.52164 .37079 m .51323 .37097 L .51161 .36614 L .633 .69 .885 r
F
.38193 .1498 m .37074 .15485 L .36577 .13976 L .205 .278 .718 r
F
.38658 .16473 m .37074 .15485 L .38193 .1498 L .206 .283 .722 r
F
.50774 .63971 m .5014 .63971 L .49809 .64362 L .499 .156 .316 r
F
.57503 .65277 m .57231 .65815 L .5794 .65807 L .828 .437 .31 r
F
.57503 .65277 m .56852 .65283 L .57231 .65815 L F
.37896 .83341 m .3736 .83134 L .36839 .84544 L 0 0 .184 r
F
.38404 .81958 m .3736 .83134 L .37896 .83341 L 0 0 .178 r
F
.59913 .67661 m .59702 .68401 L .60397 .68376 L .889 .502 .293 r
F
.59913 .67661 m .5926 .67681 L .59702 .68401 L F
.64686 .24619 m .64076 .23098 L .65171 .23428 L .933 .887 .764 r
F
.64686 .24619 m .63631 .24312 L .64076 .23098 L F
.64914 .75709 m .64797 .76955 L .65429 .7684 L .943 .578 .237 r
F
.64914 .75709 m .64304 .75809 L .64797 .76955 L F
.21688 .60377 m .20241 .61118 L .20485 .61077 L 0 0 0 r
F
.53878 .37089 m .53056 .3659 L .54005 .36604 L .702 .744 .884 r
F
.53878 .37089 m .53026 .37076 L .53056 .3659 L F
.51161 .36614 m .50283 .36652 L .50031 .36126 L .595 .652 .876 r
F
.56097 .64361 m .5575 .64801 L .56474 .64798 L .779 .392 .321 r
F
.56097 .64361 m .55446 .64362 L .5575 .64801 L F
.37727 .13439 m .36577 .13976 L .36081 .12421 L .203 .273 .714 r
F
.38193 .1498 m .36577 .13976 L .37727 .13439 L .205 .278 .718 r
F
.54262 .63627 m .53756 .63972 L .5448 .63972 L .698 .316 .321 r
F
.54262 .63627 m .53629 .63627 L .53756 .63972 L F
.48161 .34345 m .47218 .34447 L .46816 .33748 L .482 .547 .846 r
F
.48496 .35006 m .47218 .34447 L .48161 .34345 L .481 .556 .855 r
F
.45198 .30478 m .44194 .30661 L .43736 .2974 L .384 .453 .808 r
F
.45604 .31367 m .44194 .30661 L .45198 .30478 L .385 .46 .815 r
F
.44596 .69971 m .43929 .69934 L .43431 .70788 L .173 0 .288 r
F
.45058 .69158 m .43929 .69934 L .44596 .69971 L .173 0 .272 r
F
.57584 .35062 m .56952 .34312 L .57962 .34406 L .818 .823 .854 r
F
.57584 .35062 m .56647 .34976 L .56952 .34312 L F
.56038 .36162 m .55348 .35533 L .56342 .35593 L .775 .794 .868 r
F
.56038 .36162 m .55128 .36108 L .55348 .35533 L F
.52164 .37079 m .51161 .36614 L .52097 .36593 L .633 .69 .885 r
F
.53026 .37076 m .52164 .37079 L .52097 .36593 L .67 .716 .884 r
F
.37387 .84773 m .36839 .84544 L .36316 .86001 L 0 0 .19 r
F
.37896 .83341 m .36839 .84544 L .37387 .84773 L 0 0 .184 r
F
.37727 .13439 m .36081 .12421 L .37261 .1185 L .203 .273 .714 r
F
.55143 .63971 m .54699 .64364 L .55446 .64362 L .74 .36 .333 r
F
.55143 .63971 m .5448 .63972 L .54699 .64364 L F
.53026 .37076 m .52097 .36593 L .53056 .3659 L .67 .716 .884 r
F
.49476 .648 m .48799 .64797 L .48397 .65281 L .437 .12 .33 r
F
.49809 .64362 m .48799 .64797 L .49476 .648 L .429 .095 .295 r
F
.65171 .23428 m .64522 .21836 L .65655 .2219 L .935 .885 .759 r
F
.65171 .23428 m .64076 .23098 L .64522 .21836 L F
.60097 .32303 m .59483 .31309 L .60536 .3147 L .87 .854 .824 r
F
.60097 .32303 m .59101 .32155 L .59483 .31309 L F
.65429 .7684 m .6529 .78149 L .65944 .78019 L .947 .587 .245 r
F
.65429 .7684 m .64797 .76955 L .6529 .78149 L F
.20485 .61077 m .18965 .6181 L .19197 .6178 L 0 0 0 r
F
.54909 .36636 m .54132 .36073 L .55128 .36108 L .739 .766 .875 r
F
.54909 .36636 m .54005 .36604 L .54132 .36073 L F
.5164 .63627 m .50774 .63971 L .51478 .63972 L .547 .188 .311 r
F
.52295 .63627 m .5164 .63627 L .51478 .63972 L .595 .238 .334 r
F
.47591 .66391 m .46894 .6638 L .46437 .67003 L .339 .054 .325 r
F
.47995 .65812 m .46894 .6638 L .47591 .66391 L .336 .037 .301 r
F
.60397 .68376 m .60145 .69169 L .60882 .69138 L .896 .519 .311 r
F
.60397 .68376 m .59702 .68401 L .60145 .69169 L F
.49778 .35553 m .48829 .3562 L .48496 .35006 L .548 .602 .86 r
F
.50031 .36126 m .48829 .3562 L .49778 .35553 L .546 .612 .87 r
F
.53629 .63627 m .52996 .63972 L .53756 .63972 L .669 .301 .339 r
F
.53629 .63627 m .52966 .63627 L .52996 .63972 L F
.36877 .86254 m .36316 .86001 L .35793 .87506 L 0 0 .195 r
F
.37387 .84773 m .36316 .86001 L .36877 .86254 L 0 0 .19 r
F
.5794 .65807 m .57611 .66395 L .58379 .66384 L .839 .462 .337 r
F
.5794 .65807 m .57231 .65815 L .57611 .66395 L F
.65655 .2219 m .64968 .20526 L .6614 .20904 L .937 .882 .754 r
F
.65655 .2219 m .64522 .21836 L .64968 .20526 L F
.44792 .29541 m .43736 .2974 L .43277 .28771 L .383 .446 .802 r
F
.45198 .30478 m .43736 .2974 L .44792 .29541 L .384 .453 .808 r
F
.44133 .70833 m .43431 .70788 L .42932 .71689 L .173 0 .302 r
F
.44596 .69971 m .43431 .70788 L .44133 .70833 L .173 0 .288 r
F
.52295 .63627 m .51478 .63972 L .52228 .63972 L .595 .238 .334 r
F
.52966 .63627 m .52295 .63627 L .52228 .63972 L .635 .275 .343 r
F
.65944 .78019 m .65785 .79392 L .6646 .79246 L .95 .596 .254 r
F
.65944 .78019 m .6529 .78149 L .65785 .79392 L F
.19197 .6178 m .17605 .62502 L .17822 .62484 L 0 0 0 r
F
.52966 .63627 m .52228 .63972 L .52996 .63972 L .635 .275 .343 r
F
.47826 .33636 m .46816 .33748 L .46413 .33002 L .483 .539 .838 r
F
.48161 .34345 m .46816 .33748 L .47826 .33636 L .482 .547 .846 r
F
.50523 .64363 m .49809 .64362 L .49476 .648 L .508 .185 .354 r
F
.50774 .63971 m .49809 .64362 L .50523 .64363 L .499 .156 .316 r
F
.51478 .63972 m .50774 .63971 L .50523 .64363 L .559 .222 .355 r
F
.51161 .36614 m .50031 .36126 L .50999 .36084 L .595 .652 .876 r
F
.52097 .36593 m .51161 .36614 L .50999 .36084 L .638 .679 .873 r
F
.60536 .3147 m .59865 .30416 L .60976 .3059 L .873 .849 .817 r
F
.60536 .3147 m .59483 .31309 L .59865 .30416 L F
.56474 .64798 m .56055 .65287 L .56852 .65283 L .792 .421 .354 r
F
.56474 .64798 m .5575 .64801 L .56055 .65287 L F
.36366 .87784 m .35793 .87506 L .35269 .89059 L 0 0 .2 r
F
.36877 .86254 m .35793 .87506 L .36366 .87784 L 0 0 .195 r
F
.57962 .34406 m .57259 .336 L .58341 .33704 L .822 .817 .845 r
F
.57962 .34406 m .56952 .34312 L .57259 .336 L F
.6614 .20904 m .65415 .19167 L .66626 .19572 L .939 .88 .75 r
F
.6614 .20904 m .64968 .20526 L .65415 .19167 L F
.60882 .69138 m .60589 .69985 L .61368 .69948 L .903 .535 .327 r
F
.60882 .69138 m .60145 .69169 L .60589 .69985 L F
.50999 .36084 m .50031 .36126 L .49778 .35553 L .598 .642 .865 r
F
.47186 .67018 m .46437 .67003 L .45978 .67674 L .342 .069 .347 r
F
.47591 .66391 m .46437 .67003 L .47186 .67018 L .339 .054 .325 r
F
.54005 .36604 m .53087 .36057 L .54132 .36073 L .708 .735 .872 r
F
.54005 .36604 m .53056 .3659 L .53087 .36057 L F
.49143 .65286 m .48397 .65281 L .47995 .65812 L .442 .142 .359 r
F
.49476 .648 m .48397 .65281 L .49143 .65286 L .437 .12 .33 r
F
.44384 .28556 m .43277 .28771 L .42818 .27755 L .382 .44 .796 r
F
.44792 .29541 m .43277 .28771 L .44384 .28556 L .383 .446 .802 r
F
.6646 .79246 m .66281 .80684 L .66977 .8052 L .953 .604 .261 r
F
.6646 .79246 m .65785 .79392 L .66281 .80684 L F
.56342 .35593 m .55569 .3491 L .56647 .34976 L .78 .787 .858 r
F
.56342 .35593 m .55348 .35533 L .55569 .3491 L F
.43669 .71743 m .42932 .71689 L .42433 .72639 L .173 0 .314 r
F
.44133 .70833 m .42932 .71689 L .43669 .71743 L .173 0 .302 r
F
.5448 .63972 m .53883 .64365 L .54699 .64364 L .713 .353 .364 r
F
.5448 .63972 m .53756 .63972 L .53883 .64365 L F
.36366 .87784 m .35269 .89059 L .35854 .89364 L 0 0 .2 r
F
.66626 .19572 m .65863 .17761 L .67111 .18193 L .94 .878 .746 r
F
.66626 .19572 m .65415 .19167 L .65863 .17761 L F
.55446 .64362 m .54919 .64803 L .5575 .64801 L .753 .392 .37 r
F
.55446 .64362 m .54699 .64364 L .54919 .64803 L F
.58379 .66384 m .57992 .67023 L .58819 .67009 L .848 .482 .36 r
F
.58379 .66384 m .57611 .66395 L .57992 .67023 L F
.52097 .36593 m .50999 .36084 L .5203 .3606 L .638 .679 .873 r
F
.53056 .3659 m .52097 .36593 L .5203 .3606 L .675 .706 .871 r
F
.49525 .34932 m .48496 .35006 L .48161 .34345 L .55 .593 .851 r
F
.49778 .35553 m .48496 .35006 L .49525 .34932 L .548 .602 .86 r
F
.55128 .36108 m .5426 .35493 L .55348 .35533 L .744 .758 .864 r
F
.55128 .36108 m .54132 .36073 L .5426 .35493 L F
.53056 .3659 m .5203 .3606 L .53087 .36057 L .675 .706 .871 r
F
.60976 .3059 m .60248 .29473 L .61417 .29663 L .876 .846 .81 r
F
.60976 .3059 m .59865 .30416 L .60248 .29473 L F
.47491 .32879 m .46413 .33002 L .46009 .32208 L .483 .531 .83 r
F
.47826 .33636 m .46413 .33002 L .47491 .32879 L .483 .539 .838 r
F
.66977 .8052 m .66779 .82025 L .67494 .81842 L .956 .611 .268 r
F
.66977 .8052 m .66281 .80684 L .66779 .82025 L F
.51478 .63972 m .50523 .64363 L .51316 .64364 L .559 .222 .355 r
F
.52228 .63972 m .51478 .63972 L .51316 .64364 L .607 .272 .376 r
F
.61368 .69948 m .61035 .70849 L .61855 .70805 L .909 .548 .342 r
F
.61368 .69948 m .60589 .69985 L .61035 .70849 L F
.43976 .27523 m .42818 .27755 L .42358 .26692 L .382 .434 .791 r
F
.44384 .28556 m .42818 .27755 L .43976 .27523 L .382 .44 .796 r
F
.67111 .18193 m .66311 .16305 L .67598 .16766 L .942 .876 .742 r
F
.67111 .18193 m .65863 .17761 L .66311 .16305 L F
.43204 .72701 m .42433 .72639 L .41933 .73635 L .173 0 .326 r
F
.43669 .71743 m .42433 .72639 L .43204 .72701 L .173 0 .314 r
F
.58341 .33704 m .57566 .32839 L .5872 .32953 L .826 .812 .837 r
F
.58341 .33704 m .57259 .336 L .57566 .32839 L F
.53756 .63972 m .53027 .64365 L .53883 .64365 L .682 .335 .381 r
F
.53756 .63972 m .52996 .63972 L .53027 .64365 L F
.4678 .67692 m .45978 .67674 L .45519 .68392 L .344 .082 .365 r
F
.47186 .67018 m .45978 .67674 L .4678 .67692 L .342 .069 .347 r
F
.56852 .65283 m .56361 .65821 L .57231 .65815 L .802 .445 .382 r
F
.56852 .65283 m .56055 .65287 L .56361 .65821 L F
.5027 .64803 m .49476 .648 L .49143 .65286 L .515 .209 .385 r
F
.50523 .64363 m .49476 .648 L .5027 .64803 L .508 .185 .354 r
F
.67494 .81842 m .67277 .83416 L .68013 .83212 L .959 .618 .274 r
F
.67494 .81842 m .66779 .82025 L .67277 .83416 L F
.67598 .16766 m .6676 .14802 L .68084 .15293 L .943 .874 .738 r
F
.67598 .16766 m .66311 .16305 L .6676 .14802 L F
.52228 .63972 m .51316 .64364 L .52161 .64365 L .607 .272 .376 r
F
.52996 .63972 m .52228 .63972 L .52161 .64365 L .647 .308 .385 r
F
.48808 .65819 m .47995 .65812 L .47591 .66391 L .447 .16 .383 r
F
.49143 .65286 m .47995 .65812 L .48808 .65819 L .442 .142 .359 r
F
.51316 .64364 m .50523 .64363 L .5027 .64803 L .568 .25 .39 r
F
.50999 .36084 m .49778 .35553 L .50835 .35506 L .598 .642 .865 r
F
.5203 .3606 m .50999 .36084 L .50835 .35506 L .641 .67 .862 r
F
.52996 .63972 m .52161 .64365 L .53027 .64365 L .647 .308 .385 r
F
.50835 .35506 m .49778 .35553 L .49525 .34932 L .6 .633 .855 r
F
.61417 .29663 m .60632 .28483 L .61858 .28688 L .879 .842 .804 r
F
.61417 .29663 m .60248 .29473 L .60632 .28483 L F
.56647 .34976 m .5579 .34239 L .56952 .34312 L .785 .78 .849 r
F
.56647 .34976 m .55569 .3491 L .5579 .34239 L F
.58819 .67009 m .58374 .67699 L .5926 .67681 L .855 .501 .38 r
F
.58819 .67009 m .57992 .67023 L .58374 .67699 L F
.43567 .26442 m .42358 .26692 L .41898 .25581 L .381 .429 .785 r
F
.43976 .27523 m .42358 .26692 L .43567 .26442 L .382 .434 .791 r
F
.61855 .70805 m .61481 .71762 L .62343 .7171 L .914 .561 .355 r
F
.61855 .70805 m .61035 .70849 L .61481 .71762 L F
.42738 .73708 m .41933 .73635 L .41431 .7468 L .173 0 .336 r
F
.43204 .72701 m .41933 .73635 L .42738 .73708 L .173 0 .326 r
F
.47154 .32074 m .46009 .32208 L .45604 .31367 L .483 .524 .823 r
F
.47491 .32879 m .46009 .32208 L .47154 .32074 L .483 .531 .83 r
F
.54132 .36073 m .53118 .35475 L .5426 .35493 L .712 .726 .861 r
F
.54132 .36073 m .53087 .36057 L .53118 .35475 L F
.68084 .15293 m .6721 .13249 L .68571 .13772 L .945 .872 .734 r
F
.68084 .15293 m .6676 .14802 L .6721 .13249 L F
.49271 .34263 m .48161 .34345 L .47826 .33636 L .551 .585 .842 r
F
.49525 .34932 m .48161 .34345 L .49271 .34263 L .55 .593 .851 r
F
.54699 .64364 m .54011 .64805 L .54919 .64803 L .724 .382 .399 r
F
.54699 .64364 m .53883 .64365 L .54011 .64805 L F
.5575 .64801 m .5514 .65291 L .56055 .65287 L .763 .418 .4 r
F
.5575 .64801 m .54919 .64803 L .5514 .65291 L F
.68013 .83212 m .67776 .84856 L .68532 .8463 L .961 .625 .28 r
F
.68013 .83212 m .67277 .83416 L .67776 .84856 L F
.46373 .68415 m .45519 .68392 L .45058 .69158 L .346 .094 .381 r
F
.4678 .67692 m .45519 .68392 L .46373 .68415 L .344 .082 .365 r
F
.55348 .35533 m .54389 .34866 L .55569 .3491 L .749 .751 .854 r
F
.55348 .35533 m .5426 .35493 L .54389 .34866 L F
.5872 .32953 m .57874 .32031 L .59101 .32155 L .829 .807 .829 r
F
.5872 .32953 m .57566 .32839 L .57874 .32031 L F
.5203 .3606 m .50835 .35506 L .51962 .35479 L .641 .67 .862 r
F
.53087 .36057 m .5203 .3606 L .51962 .35479 L .678 .697 .86 r
F
.68571 .13772 m .6766 .11648 L .69059 .12204 L .946 .87 .731 r
F
.68571 .13772 m .6721 .13249 L .6766 .11648 L F
.43157 .25312 m .41898 .25581 L .41437 .24423 L .38 .423 .781 r
F
.43567 .26442 m .41898 .25581 L .43157 .25312 L .381 .429 .785 r
F
.53087 .36057 m .51962 .35479 L .53118 .35475 L .678 .697 .86 r
F
.61858 .28688 m .61017 .27444 L .623 .27666 L .882 .839 .799 r
F
.61858 .28688 m .60632 .28483 L .61017 .27444 L F
.4227 .74764 m .41431 .7468 L .40929 .75772 L .173 0 .346 r
F
.42738 .73708 m .41431 .7468 L .4227 .74764 L .173 0 .336 r
F
.57231 .65815 m .56668 .66404 L .57611 .66395 L .81 .466 .405 r
F
.57231 .65815 m .56361 .65821 L .56668 .66404 L F
.62343 .7171 m .61929 .72724 L .62831 .72663 L .918 .572 .367 r
F
.62343 .7171 m .61481 .71762 L .61929 .72724 L F
.51316 .64364 m .5027 .64803 L .51153 .64804 L .568 .25 .39 r
F
.52161 .64365 m .51316 .64364 L .51153 .64804 L .616 .299 .41 r
F
.75986 .49275 m .75197 .4981 L .75867 .49971 L .979 .878 .509 r
F
.75986 .49275 m .75314 .49106 L .75197 .4981 L F
.76187 .48579 m .75314 .49106 L .75986 .49275 L .964 .918 .574 r
F
.68532 .8463 m .68277 .86346 L .69052 .86096 L .963 .631 .286 r
F
.68532 .8463 m .67776 .84856 L .68277 .86346 L F
.75867 .49971 m .75159 .50514 L .75829 .50666 L .985 .826 .436 r
F
.75867 .49971 m .75197 .4981 L .75159 .50514 L F
.76187 .48579 m .75511 .48399 L .75314 .49106 L .964 .918 .574 r
F
.76469 .47881 m .75511 .48399 L .76187 .48579 L .943 .949 .631 r
F
.48472 .66401 m .47591 .66391 L .47186 .67018 L .451 .176 .405 r
F
.48808 .65819 m .47591 .66391 L .48472 .66401 L .447 .16 .383 r
F
.75829 .50666 m .75202 .51216 L .75873 .5136 L .982 .766 .357 r
F
.75829 .50666 m .75159 .50514 L .75202 .51216 L F
.50017 .6529 m .49143 .65286 L .48808 .65819 L .521 .229 .411 r
F
.5027 .64803 m .49143 .65286 L .50017 .6529 L .515 .209 .385 r
F
.5926 .67681 m .58758 .68423 L .59702 .68401 L .861 .516 .397 r
F
.5926 .67681 m .58374 .67699 L .58758 .68423 L F
.76469 .47881 m .75788 .47691 L .75511 .48399 L .943 .949 .631 r
F
.76832 .47182 m .75788 .47691 L .76469 .47881 L .916 .971 .68 r
F
.46816 .31221 m .45604 .31367 L .45198 .30478 L .483 .518 .817 r
F
.47154 .32074 m .45604 .31367 L .46816 .31221 L .483 .524 .823 r
F
.75873 .5136 m .75325 .51917 L .75997 .52054 L .968 .697 .274 r
F
.75873 .5136 m .75202 .51216 L .75325 .51917 L F
.53883 .64365 m .53058 .64806 L .54011 .64805 L .692 .363 .414 r
F
.53883 .64365 m .53027 .64365 L .53058 .64806 L F
.76832 .47182 m .76146 .4698 L .75788 .47691 L .916 .971 .68 r
F
.77277 .46482 m .76146 .4698 L .76832 .47182 L .887 .986 .721 r
F
.56952 .34312 m .56013 .33519 L .57259 .336 L .788 .775 .84 r
F
.56952 .34312 m .5579 .34239 L .56013 .33519 L F
.50672 .3488 m .49525 .34932 L .49271 .34263 L .602 .625 .846 r
F
.50835 .35506 m .49525 .34932 L .50672 .3488 L .6 .633 .855 r
F
.75997 .52054 m .75528 .52617 L .76204 .52747 L .945 .623 .191 r
F
.75997 .52054 m .75325 .51917 L .75528 .52617 L F
.51962 .35479 m .50835 .35506 L .50672 .3488 L .644 .661 .852 r
F
.42747 .24134 m .41437 .24423 L .40975 .23218 L .379 .419 .776 r
F
.43157 .25312 m .41437 .24423 L .42747 .24134 L .38 .423 .781 r
F
.51153 .64804 m .5027 .64803 L .50017 .6529 L .575 .273 .419 r
F
.77277 .46482 m .76584 .46267 L .76146 .4698 L .887 .986 .721 r
F
.77804 .4578 m .76584 .46267 L .77277 .46482 L .856 .995 .755 r
F
.45965 .69186 m .45058 .69158 L .44596 .69971 L .348 .104 .396 r
F
.46373 .68415 m .45058 .69158 L .45965 .69186 L .346 .094 .381 r
F
.49016 .33546 m .47826 .33636 L .47491 .32879 L .552 .578 .834 r
F
.49271 .34263 m .47826 .33636 L .49016 .33546 L .551 .585 .842 r
F
.623 .27666 m .61403 .26357 L .62743 .26595 L .884 .836 .793 r
F
.623 .27666 m .61017 .27444 L .61403 .26357 L F
.69052 .86096 m .68778 .87885 L .69573 .8761 L .965 .636 .291 r
F
.69052 .86096 m .68277 .86346 L .68778 .87885 L F
.41802 .75869 m .40929 .75772 L .40426 .76912 L .172 0 .354 r
F
.4227 .74764 m .40929 .75772 L .41802 .75869 L .173 0 .346 r
F
.52161 .64365 m .51153 .64804 L .52094 .64805 L .616 .299 .41 r
F
.53027 .64365 m .52161 .64365 L .52094 .64805 L .656 .335 .418 r
F
.76204 .52747 m .75811 .53317 L .76492 .5344 L .915 .545 .109 r
F
.76204 .52747 m .75528 .52617 L .75811 .53317 L F
.59101 .32155 m .58183 .31174 L .59483 .31309 L .832 .803 .823 r
F
.59101 .32155 m .57874 .32031 L .58183 .31174 L F
.53027 .64365 m .52094 .64805 L .53058 .64806 L .656 .335 .418 r
F
.62831 .72663 m .62378 .73734 L .63321 .73663 L .922 .582 .377 r
F
.62831 .72663 m .61929 .72724 L .62378 .73734 L F
.77804 .4578 m .77102 .45552 L .76584 .46267 L .856 .995 .755 r
F
.78413 .45076 m .77102 .45552 L .77804 .4578 L .825 .998 .782 r
F
.5426 .35493 m .53149 .34846 L .54389 .34866 L .716 .719 .851 r
F
.5426 .35493 m .53118 .35475 L .53149 .34846 L F
.56055 .65287 m .55362 .65826 L .56361 .65821 L .771 .44 .425 r
F
.56055 .65287 m .5514 .65291 L .55362 .65826 L F
.54919 .64803 m .5414 .65293 L .5514 .65291 L .732 .406 .427 r
F
.54919 .64803 m .54011 .64805 L .5414 .65293 L F
.76492 .5344 m .76175 .54017 L .76862 .54133 L .878 .468 .031 r
F
.76492 .5344 m .75811 .53317 L .76175 .54017 L F
.55569 .3491 m .54518 .3419 L .5579 .34239 L .752 .744 .845 r
F
.55569 .3491 m .54389 .34866 L .54518 .3419 L F
.42335 .22907 m .40975 .23218 L .40513 .21964 L .378 .414 .772 r
F
.42747 .24134 m .40975 .23218 L .42335 .22907 L .379 .419 .776 r
F
.78413 .45076 m .77702 .44833 L .77102 .45552 L .825 .998 .782 r
F
.79104 .44371 m .77702 .44833 L .78413 .45076 L .795 .999 .805 r
F
.59702 .68401 m .59142 .69196 L .60145 .69169 L .867 .53 .413 r
F
.59702 .68401 m .58758 .68423 L .59142 .69196 L F
.46478 .3032 m .45198 .30478 L .44792 .29541 L .483 .512 .811 r
F
.46816 .31221 m .45198 .30478 L .46478 .3032 L .483 .518 .817 r
F
.57611 .66395 m .56976 .67034 L .57992 .67023 L .816 .483 .425 r
F
.57611 .66395 m .56668 .66404 L .56976 .67034 L F
.69573 .8761 m .69281 .89475 L .70094 .89173 L .967 .642 .296 r
F
.69573 .8761 m .68778 .87885 L .69281 .89475 L F
.51962 .35479 m .50672 .3488 L .51895 .3485 L .644 .661 .852 r
F
.53118 .35475 m .51962 .35479 L .51895 .3485 L .682 .689 .851 r
F
.48135 .6703 m .47186 .67018 L .4678 .67692 L .453 .19 .423 r
F
.48472 .66401 m .47186 .67018 L .48135 .6703 L .451 .176 .405 r
F
.41332 .77023 m .40426 .76912 L .39922 .78101 L .172 0 .362 r
F
.41802 .75869 m .40426 .76912 L .41332 .77023 L .172 0 .354 r
F
.76862 .54133 m .76619 .54716 L .77313 .54826 L .838 .392 0 r
F
.76862 .54133 m .76175 .54017 L .76619 .54716 L F
.62743 .26595 m .6179 .25221 L .63187 .25477 L .886 .833 .789 r
F
.62743 .26595 m .61403 .26357 L .6179 .25221 L F
.53118 .35475 m .51895 .3485 L .53149 .34846 L .682 .689 .851 r
F
.79104 .44371 m .78383 .44112 L .77702 .44833 L .795 .999 .805 r
F
.79878 .43664 m .78383 .44112 L .79104 .44371 L .765 .996 .824 r
F
.45555 .70006 m .44596 .69971 L .44133 .70833 L .349 .113 .409 r
F
.45965 .69186 m .44596 .69971 L .45555 .70006 L .348 .104 .396 r
F
.49762 .65825 m .48808 .65819 L .48472 .66401 L .525 .246 .433 r
F
.50017 .6529 m .48808 .65819 L .49762 .65825 L .521 .229 .411 r
F
.63321 .73663 m .62828 .74794 L .63812 .74712 L .926 .592 .387 r
F
.63321 .73663 m .62378 .73734 L .62828 .74794 L F
.57259 .336 m .56235 .32751 L .57566 .32839 L .791 .769 .833 r
F
.57259 .336 m .56013 .33519 L .56235 .32751 L F
.51153 .64804 m .50017 .6529 L .50989 .65292 L .575 .273 .419 r
F
.52094 .64805 m .51153 .64804 L .50989 .65292 L .623 .321 .438 r
F
.48761 .32781 m .47491 .32879 L .47154 .32074 L .552 .572 .827 r
F
.49016 .33546 m .47491 .32879 L .48761 .32781 L .552 .578 .834 r
F
.41923 .21632 m .40513 .21964 L .4005 .20663 L .377 .41 .768 r
F
.42335 .22907 m .40513 .21964 L .41923 .21632 L .378 .414 .772 r
F
.50508 .34205 m .49271 .34263 L .49016 .33546 L .604 .618 .838 r
F
.50672 .3488 m .49271 .34263 L .50508 .34205 L .602 .625 .846 r
F
.59483 .31309 m .58493 .30268 L .59865 .30416 L .835 .798 .816 r
F
.59483 .31309 m .58183 .31174 L .58493 .30268 L F
.30356 .49077 m .29605 .49246 L .29724 .49944 L 0 0 .535 r
F
.3016 .48369 m .29605 .49246 L .30356 .49077 L 0 .055 .597 r
F
.3016 .48369 m .29405 .48548 L .29605 .49246 L F
.77313 .54826 m .77144 .55416 L .77847 .55519 L .796 .32 0 r
F
.77313 .54826 m .76619 .54716 L .77144 .55416 L F
.30473 .49784 m .29724 .49944 L .29762 .5064 L 0 0 .465 r
F
.30356 .49077 m .29724 .49944 L .30473 .49784 L 0 0 .535 r
F
.29884 .47659 m .29405 .48548 L .3016 .48369 L 0 .115 .652 r
F
.29884 .47659 m .29123 .47849 L .29405 .48548 L F
.3051 .50488 m .29762 .5064 L .29718 .51336 L 0 0 .389 r
F
.30473 .49784 m .29762 .5064 L .3051 .50488 L 0 0 .465 r
F
.79878 .43664 m .79146 .43387 L .78383 .44112 L .765 .996 .824 r
F
.80734 .42954 m .79146 .43387 L .79878 .43664 L .737 .992 .839 r
F
.29529 .46946 m .29123 .47849 L .29884 .47659 L 0 .169 .699 r
F
.29529 .46946 m .2876 .47148 L .29123 .47849 L F
.51895 .3485 m .50672 .3488 L .50508 .34205 L .646 .654 .843 r
F
.30467 .51192 m .29718 .51336 L .29594 .5203 L 0 0 .309 r
F
.3051 .50488 m .29718 .51336 L .30467 .51192 L 0 0 .389 r
F
.54011 .64805 m .53089 .65294 L .5414 .65293 L .699 .385 .442 r
F
.54011 .64805 m .53058 .64806 L .53089 .65294 L F
.50989 .65292 m .50017 .6529 L .49762 .65825 L .58 .292 .443 r
F
.40861 .78226 m .39922 .78101 L .39417 .79338 L .171 0 .37 r
F
.41332 .77023 m .39922 .78101 L .40861 .78226 L .172 0 .362 r
F
.29093 .46231 m .2876 .47148 L .29529 .46946 L 0 .219 .738 r
F
.29093 .46231 m .28315 .46445 L .2876 .47148 L F
.46138 .29369 m .44792 .29541 L .44384 .28556 L .483 .506 .805 r
F
.46478 .3032 m .44792 .29541 L .46138 .29369 L .483 .512 .811 r
F
.63187 .25477 m .62177 .24036 L .63631 .24312 L .888 .83 .784 r
F
.63187 .25477 m .6179 .25221 L .62177 .24036 L F
.30345 .51894 m .29594 .5203 L .29388 .52725 L 0 0 .228 r
F
.30467 .51192 m .29594 .5203 L .30345 .51894 L 0 0 .309 r
F
.60145 .69169 m .59528 .70018 L .60589 .69985 L .871 .543 .426 r
F
.60145 .69169 m .59142 .69196 L .59528 .70018 L F
.77847 .55519 m .77751 .56115 L .78464 .56212 L .753 .253 0 r
F
.77847 .55519 m .77144 .55416 L .77751 .56115 L F
.56361 .65821 m .55584 .6641 L .56668 .66404 L .778 .458 .446 r
F
.56361 .65821 m .55362 .65826 L .55584 .6641 L F
.52094 .64805 m .50989 .65292 L .52026 .65294 L .623 .321 .438 r
F
.53058 .64806 m .52094 .64805 L .52026 .65294 L .663 .357 .445 r
F
.28577 .45514 m .28315 .46445 L .29093 .46231 L 0 .263 .77 r
F
.28577 .45514 m .27789 .45741 L .28315 .46445 L F
.54389 .34866 m .5318 .34168 L .54518 .3419 L .719 .712 .843 r
F
.54389 .34866 m .53149 .34846 L .5318 .34168 L F
.63812 .74712 m .6328 .75903 L .64304 .75809 L .929 .6 .396 r
F
.63812 .74712 m .62828 .74794 L .6328 .75903 L F
.4151 .20307 m .4005 .20663 L .39586 .19314 L .377 .406 .764 r
F
.41923 .21632 m .4005 .20663 L .4151 .20307 L .377 .41 .768 r
F
.80734 .42954 m .79991 .42658 L .79146 .43387 L .737 .992 .839 r
F
.81673 .42243 m .79991 .42658 L .80734 .42954 L .711 .987 .851 r
F
.47797 .67708 m .4678 .67692 L .46373 .68415 L .456 .202 .439 r
F
.48135 .6703 m .4678 .67692 L .47797 .67708 L .453 .19 .423 r
F
.30143 .52596 m .29388 .52725 L .291 .53419 L 0 0 .148 r
F
.30345 .51894 m .29388 .52725 L .30143 .52596 L 0 0 .228 r
F
.45144 .70874 m .44133 .70833 L .43669 .71743 L .35 .122 .421 r
F
.45555 .70006 m .44133 .70833 L .45144 .70874 L .349 .113 .409 r
F
.57992 .67023 m .57286 .67713 L .58374 .67699 L .822 .499 .443 r
F
.57992 .67023 m .56976 .67034 L .57286 .67713 L F
.53058 .64806 m .52026 .65294 L .53089 .65294 L .663 .357 .445 r
F
.5579 .34239 m .54647 .33466 L .56013 .33519 L .755 .738 .837 r
F
.5579 .34239 m .54518 .3419 L .54647 .33466 L F
.5514 .65291 m .54268 .6583 L .55362 .65826 L .739 .425 .451 r
F
.5514 .65291 m .5414 .65293 L .54268 .6583 L F
.2798 .44793 m .27789 .45741 L .28577 .45514 L 0 .303 .797 r
F
.2798 .44793 m .27181 .45035 L .27789 .45741 L F
.29862 .53297 m .291 .53419 L .28731 .54113 L 0 0 .071 r
F
.30143 .52596 m .291 .53419 L .29862 .53297 L 0 0 .148 r
F
.78464 .56212 m .7844 .56816 L .79162 .56905 L .712 .192 0 r
F
.78464 .56212 m .77751 .56115 L .7844 .56816 L F
.40388 .79479 m .39417 .79338 L .38911 .80624 L .171 0 .376 r
F
.40861 .78226 m .39417 .79338 L .40388 .79479 L .171 0 .37 r
F
.59865 .30416 m .58804 .29314 L .60248 .29473 L .837 .795 .811 r
F
.59865 .30416 m .58493 .30268 L .58804 .29314 L F
.51895 .3485 m .50508 .34205 L .51827 .34173 L .646 .654 .843 r
F
.53149 .34846 m .51895 .3485 L .51827 .34173 L .684 .682 .842 r
F
.57566 .32839 m .56459 .31935 L .57874 .32031 L .794 .764 .826 r
F
.57566 .32839 m .56235 .32751 L .56459 .31935 L F
.49507 .66408 m .48472 .66401 L .48135 .6703 L .529 .26 .452 r
F
.49762 .65825 m .48472 .66401 L .49507 .66408 L .525 .246 .433 r
F
.63631 .24312 m .62565 .22802 L .64076 .23098 L .889 .827 .78 r
F
.63631 .24312 m .62177 .24036 L .62565 .22802 L F
.48504 .31967 m .47154 .32074 L .46816 .31221 L .553 .566 .821 r
F
.48761 .32781 m .47154 .32074 L .48504 .31967 L .552 .572 .827 r
F
.53149 .34846 m .51827 .34173 L .5318 .34168 L .684 .682 .842 r
F
.81673 .42243 m .80919 .41926 L .79991 .42658 L .711 .987 .851 r
F
.82696 .41529 m .80919 .41926 L .81673 .42243 L .687 .98 .861 r
F
.41096 .18933 m .39586 .19314 L .39122 .17918 L .376 .402 .76 r
F
.4151 .20307 m .39586 .19314 L .41096 .18933 L .377 .406 .764 r
F
.27302 .44068 m .27181 .45035 L .2798 .44793 L 0 .338 .819 r
F
.27302 .44068 m .2649 .44327 L .27181 .45035 L F
.45798 .28371 m .44384 .28556 L .43976 .27523 L .483 .501 .8 r
F
.46138 .29369 m .44384 .28556 L .45798 .28371 L .483 .506 .805 r
F
.50343 .33482 m .49016 .33546 L .48761 .32781 L .605 .611 .831 r
F
.50508 .34205 m .49016 .33546 L .50343 .33482 L .604 .618 .838 r
F
.295 .53997 m .28731 .54113 L .28279 .54807 L 0 0 0 r
F
.29862 .53297 m .28731 .54113 L .295 .53997 L 0 0 .071 r
F
.64304 .75809 m .63732 .77062 L .64797 .76955 L .931 .608 .404 r
F
.64304 .75809 m .6328 .75903 L .63732 .77062 L F
.60589 .69985 m .59916 .70888 L .61035 .70849 L .875 .554 .439 r
F
.60589 .69985 m .59528 .70018 L .59916 .70888 L F
.50989 .65292 m .49762 .65825 L .50825 .65829 L .58 .292 .443 r
F
.52026 .65294 m .50989 .65292 L .50825 .65829 L .628 .339 .46 r
F
.79162 .56905 m .79211 .57517 L .79944 .576 L .672 .136 0 r
F
.79162 .56905 m .7844 .56816 L .79211 .57517 L F
.44732 .71792 m .43669 .71743 L .43204 .72701 L .351 .129 .431 r
F
.45144 .70874 m .43669 .71743 L .44732 .71792 L .35 .122 .421 r
F
.51827 .34173 m .50508 .34205 L .50343 .33482 L .648 .647 .836 r
F
.26543 .43341 m .2649 .44327 L .27302 .44068 L .007 .369 .837 r
F
.26543 .43341 m .25718 .43617 L .2649 .44327 L F
.39915 .80782 m .38911 .80624 L .38404 .81958 L .17 0 .383 r
F
.40388 .79479 m .38911 .80624 L .39915 .80782 L .171 0 .376 r
F
.50825 .65829 m .49762 .65825 L .49507 .66408 L .584 .308 .463 r
F
.82696 .41529 m .8193 .4119 L .80919 .41926 L .687 .98 .861 r
F
.83802 .40812 m .8193 .4119 L .82696 .41529 L .664 .974 .87 r
F
.29058 .54698 m .28279 .54807 L .27746 .55501 L 0 0 0 r
F
.295 .53997 m .28279 .54807 L .29058 .54698 L F
.47458 .68435 m .46373 .68415 L .45965 .69186 L .458 .212 .453 r
F
.47797 .67708 m .46373 .68415 L .47458 .68435 L .456 .202 .439 r
F
.40682 .17511 m .39122 .17918 L .38658 .16473 L .375 .398 .757 r
F
.41096 .18933 m .39122 .17918 L .40682 .17511 L .376 .402 .76 r
F
.64076 .23098 m .62954 .21518 L .64522 .21836 L .891 .825 .776 r
F
.64076 .23098 m .62565 .22802 L .62954 .21518 L F
.5414 .65293 m .5312 .65831 L .54268 .6583 L .705 .404 .464 r
F
.5414 .65293 m .53089 .65294 L .5312 .65831 L F
.58374 .67699 m .57596 .68441 L .58758 .68423 L .826 .512 .458 r
F
.58374 .67699 m .57286 .67713 L .57596 .68441 L F
.56668 .66404 m .55808 .67043 L .56976 .67034 L .783 .473 .465 r
F
.56668 .66404 m .55584 .6641 L .55808 .67043 L F
.60248 .29473 m .59115 .2831 L .60632 .28483 L .839 .791 .805 r
F
.60248 .29473 m .58804 .29314 L .59115 .2831 L F
.54518 .3419 m .53211 .33441 L .54647 .33466 L .721 .706 .835 r
F
.54518 .3419 m .5318 .34168 L .53211 .33441 L F
.56013 .33519 m .54776 .32693 L .56235 .32751 L .757 .733 .83 r
F
.56013 .33519 m .54647 .33466 L .54776 .32693 L F
.25701 .42609 m .25718 .43617 L .26543 .43341 L .017 .396 .851 r
F
.25701 .42609 m .24862 .42904 L .25718 .43617 L F
.45457 .27323 m .43976 .27523 L .43567 .26442 L .483 .497 .796 r
F
.45798 .28371 m .43976 .27523 L .45457 .27323 L .483 .501 .8 r
F
.64797 .76955 m .64186 .78271 L .6529 .78149 L .934 .615 .411 r
F
.64797 .76955 m .63732 .77062 L .64186 .78271 L F
.79944 .576 m .80065 .58219 L .8081 .58295 L .635 .085 0 r
F
.79944 .576 m .79211 .57517 L .80065 .58219 L F
.52026 .65294 m .50825 .65829 L .51958 .65831 L .628 .339 .46 r
F
.53089 .65294 m .52026 .65294 L .51958 .65831 L .669 .376 .467 r
F
.48247 .31104 m .46816 .31221 L .46478 .3032 L .553 .56 .815 r
F
.48504 .31967 m .46816 .31221 L .48247 .31104 L .553 .566 .821 r
F
.57874 .32031 m .56683 .31069 L .58183 .31174 L .796 .76 .82 r
F
.57874 .32031 m .56459 .31935 L .56683 .31069 L F
.28535 .55398 m .27746 .55501 L .27131 .56195 L 0 0 0 r
F
.29058 .54698 m .27746 .55501 L .28535 .55398 L F
.55362 .65826 m .54398 .66415 L .55584 .6641 L .744 .442 .471 r
F
.55362 .65826 m .54268 .6583 L .54398 .66415 L F
.53089 .65294 m .51958 .65831 L .5312 .65831 L .669 .376 .467 r
F
.83802 .40812 m .83025 .40449 L .8193 .4119 L .664 .974 .87 r
F
.84993 .40093 m .83025 .40449 L .83802 .40812 L .643 .967 .877 r
F
.40266 .16039 m .38658 .16473 L .38193 .1498 L .374 .395 .753 r
F
.40682 .17511 m .38658 .16473 L .40266 .16039 L .375 .398 .757 r
F
.49251 .6704 m .48135 .6703 L .47797 .67708 L .531 .273 .468 r
F
.49507 .66408 m .48135 .6703 L .49251 .6704 L .529 .26 .452 r
F
.3944 .82135 m .38404 .81958 L .37896 .83341 L .169 0 .389 r
F
.39915 .80782 m .38404 .81958 L .3944 .82135 L .17 0 .383 r
F
.61035 .70849 m .60304 .71809 L .61481 .71762 L .878 .563 .45 r
F
.61035 .70849 m .59916 .70888 L .60304 .71809 L F
.51827 .34173 m .50343 .33482 L .51759 .33447 L .648 .647 .836 r
F
.5318 .34168 m .51827 .34173 L .51759 .33447 L .686 .676 .834 r
F
.44319 .72759 m .43204 .72701 L .42738 .73708 L .351 .136 .441 r
F
.44732 .71792 m .43204 .72701 L .44319 .72759 L .351 .129 .431 r
F
.64522 .21836 m .63344 .20186 L .64968 .20526 L .892 .823 .772 r
F
.64522 .21836 m .62954 .21518 L .63344 .20186 L F
.50178 .32711 m .48761 .32781 L .48504 .31967 L .606 .605 .824 r
F
.50343 .33482 m .48761 .32781 L .50178 .32711 L .605 .611 .831 r
F
.24777 .41873 m .24862 .42904 L .25701 .42609 L .027 .421 .863 r
F
.24777 .41873 m .23923 .42189 L .24862 .42904 L F
.5318 .34168 m .51759 .33447 L .53211 .33441 L .686 .676 .834 r
F
.27931 .56099 m .27131 .56195 L .26432 .5689 L 0 0 0 r
F
.28535 .55398 m .27131 .56195 L .27931 .56099 L F
.8081 .58295 m .81003 .58923 L .81759 .5899 L .6 .039 0 r
F
.8081 .58295 m .80065 .58219 L .81003 .58923 L F
.47117 .69211 m .45965 .69186 L .45555 .70006 L .459 .222 .465 r
F
.47458 .68435 m .45965 .69186 L .47117 .69211 L .458 .212 .453 r
F
.6529 .78149 m .64642 .79529 L .65785 .79392 L .936 .622 .418 r
F
.6529 .78149 m .64186 .78271 L .64642 .79529 L F
.60632 .28483 m .59428 .27258 L .61017 .27444 L .841 .788 .8 r
F
.60632 .28483 m .59115 .2831 L .59428 .27258 L F
.3985 .14517 m .38193 .1498 L .37727 .13439 L .373 .391 .75 r
F
.40266 .16039 m .38193 .1498 L .3985 .14517 L .374 .395 .753 r
F
.45115 .26226 m .43567 .26442 L .43157 .25312 L .483 .492 .791 r
F
.45457 .27323 m .43567 .26442 L .45115 .26226 L .483 .497 .796 r
F
.51759 .33447 m .50343 .33482 L .50178 .32711 L .649 .641 .828 r
F
.84993 .40093 m .84205 .39704 L .83025 .40449 L .643 .967 .877 r
F
.86268 .39371 m .84205 .39704 L .84993 .40093 L .624 .96 .883 r
F
.58758 .68423 m .57908 .69219 L .59142 .69196 L .83 .524 .471 r
F
.58758 .68423 m .57596 .68441 L .57908 .69219 L F
.50825 .65829 m .49507 .66408 L .5066 .66413 L .584 .308 .463 r
F
.51958 .65831 m .50825 .65829 L .5066 .66413 L .632 .355 .48 r
F
.38964 .83538 m .37896 .83341 L .37387 .84773 L .168 0 .394 r
F
.3944 .82135 m .37896 .83341 L .38964 .83538 L .169 0 .389 r
F
.5066 .66413 m .49507 .66408 L .49251 .6704 L .588 .321 .481 r
F
.2377 .41133 m .23923 .42189 L .24777 .41873 L .037 .442 .873 r
F
.2377 .41133 m .22901 .41471 L .23923 .42189 L F
.64968 .20526 m .63735 .18803 L .65415 .19167 L .893 .82 .768 r
F
.64968 .20526 m .63344 .20186 L .63735 .18803 L F
.56976 .67034 m .56032 .67725 L .57286 .67713 L .787 .487 .48 r
F
.56976 .67034 m .55808 .67043 L .56032 .67725 L F
.47989 .30193 m .46478 .3032 L .46138 .29369 L .554 .555 .81 r
F
.48247 .31104 m .46478 .3032 L .47989 .30193 L .553 .56 .815 r
F
.56235 .32751 m .54907 .31871 L .56459 .31935 L .759 .728 .823 r
F
.56235 .32751 m .54776 .32693 L .54907 .31871 L F
.27245 .56801 m .26432 .5689 L .25651 .57586 L 0 0 0 r
F
.27931 .56099 m .26432 .5689 L .27245 .56801 L F
.58183 .31174 m .56908 .30154 L .58493 .30268 L .798 .756 .814 r
F
.58183 .31174 m .56683 .31069 L .56908 .30154 L F
.43904 .73775 m .42738 .73708 L .4227 .74764 L .352 .142 .449 r
F
.44319 .72759 m .42738 .73708 L .43904 .73775 L .351 .136 .441 r
F
.61481 .71762 m .60694 .72778 L .61929 .72724 L .881 .572 .459 r
F
.61481 .71762 m .60304 .71809 L .60694 .72778 L F
.54268 .6583 m .53151 .66417 L .54398 .66415 L .71 .42 .483 r
F
.54268 .6583 m .5312 .65831 L .53151 .66417 L F
.54647 .33466 m .53242 .32666 L .54776 .32693 L .723 .7 .828 r
F
.54647 .33466 m .53211 .33441 L .53242 .32666 L F
.39434 .12946 m .37727 .13439 L .37261 .1185 L .372 .388 .747 r
F
.3985 .14517 m .37727 .13439 L .39434 .12946 L .373 .391 .75 r
F
.81759 .5899 m .82025 .59628 L .82792 .59687 L .568 0 0 r
F
.81759 .5899 m .81003 .58923 L .82025 .59628 L F
.48994 .67721 m .47797 .67708 L .47458 .68435 L .534 .284 .482 r
F
.49251 .6704 m .47797 .67708 L .48994 .67721 L .531 .273 .468 r
F
.65785 .79392 m .65098 .80838 L .66281 .80684 L .938 .628 .425 r
F
.65785 .79392 m .64642 .79529 L .65098 .80838 L F
.86268 .39371 m .85471 .38954 L .84205 .39704 L .624 .96 .883 r
F
.87628 .38646 m .85471 .38954 L .86268 .39371 L .606 .953 .887 r
F
.55584 .6641 m .54528 .67049 L .55808 .67043 L .748 .456 .488 r
F
.55584 .6641 m .54398 .66415 L .54528 .67049 L F
.38487 .84992 m .37387 .84773 L .36877 .86254 L .168 .003 .399 r
F
.38964 .83538 m .37387 .84773 L .38487 .84992 L .168 0 .394 r
F
.22679 .40388 m .22901 .41471 L .2377 .41133 L .046 .462 .881 r
F
.22679 .40388 m .21795 .40751 L .22901 .41471 L F
.51958 .65831 m .5066 .66413 L .5189 .66416 L .632 .355 .48 r
F
.5312 .65831 m .51958 .65831 L .5189 .66416 L .673 .391 .486 r
F
.50012 .31891 m .48504 .31967 L .48247 .31104 L .607 .6 .818 r
F
.50178 .32711 m .48504 .31967 L .50012 .31891 L .606 .605 .824 r
F
.44772 .2508 m .43157 .25312 L .42747 .24134 L .482 .488 .787 r
F
.45115 .26226 m .43157 .25312 L .44772 .2508 L .483 .492 .791 r
F
.65415 .19167 m .64127 .17372 L .65863 .17761 L .895 .818 .765 r
F
.65415 .19167 m .63735 .18803 L .64127 .17372 L F
.61017 .27444 m .59741 .26156 L .61403 .26357 L .842 .785 .796 r
F
.61017 .27444 m .59428 .27258 L .59741 .26156 L F
.5312 .65831 m .5189 .66416 L .53151 .66417 L .673 .391 .486 r
F
.51759 .33447 m .50178 .32711 L .5169 .32672 L .649 .641 .828 r
F
.53211 .33441 m .51759 .33447 L .5169 .32672 L .688 .67 .827 r
F
.46776 .70036 m .45555 .70006 L .45144 .70874 L .461 .23 .476 r
F
.47117 .69211 m .45555 .70006 L .46776 .70036 L .459 .222 .465 r
F
.26477 .57503 m .25651 .57586 L .24786 .58282 L 0 0 0 r
F
.27245 .56801 m .25651 .57586 L .26477 .57503 L F
.39434 .12946 m .37261 .1185 L .39016 .11326 L .372 .388 .747 r
F
.53211 .33441 m .5169 .32672 L .53242 .32666 L .688 .67 .827 r
F
.59142 .69196 m .5822 .70045 L .59528 .70018 L .833 .534 .483 r
F
.59142 .69196 m .57908 .69219 L .5822 .70045 L F
.82792 .59687 m .83131 .60335 L .83909 .60385 L .538 0 0 r
F
.82792 .59687 m .82025 .59628 L .83131 .60335 L F
.43488 .74841 m .4227 .74764 L .41802 .75869 L .352 .148 .457 r
F
.43904 .73775 m .4227 .74764 L .43488 .74841 L .352 .142 .449 r
F
.5169 .32672 m .50178 .32711 L .50012 .31891 L .65 .636 .822 r
F
.4773 .29232 m .46138 .29369 L .45798 .28371 L .554 .55 .805 r
F
.47989 .30193 m .46138 .29369 L .4773 .29232 L .554 .555 .81 r
F
.61929 .72724 m .61085 .73798 L .62378 .73734 L .884 .58 .468 r
F
.61929 .72724 m .60694 .72778 L .61085 .73798 L F
.66281 .80684 m .65556 .82198 L .66779 .82025 L .94 .634 .431 r
F
.66281 .80684 m .65098 .80838 L .65556 .82198 L F
.21504 .39638 m .21795 .40751 L .22679 .40388 L .054 .479 .887 r
F
.21504 .39638 m .20604 .40027 L .21795 .40751 L F
.38008 .86496 m .36877 .86254 L .36366 .87784 L .167 .006 .404 r
F
.38487 .84992 m .36877 .86254 L .38008 .86496 L .168 .003 .399 r
F
.87628 .38646 m .86822 .38198 L .85471 .38954 L .606 .953 .887 r
F
.65863 .17761 m .64519 .1589 L .66311 .16305 L .896 .817 .762 r
F
.65863 .17761 m .64127 .17372 L .64519 .1589 L F
.58493 .30268 m .57134 .2919 L .58804 .29314 L .8 .752 .809 r
F
.58493 .30268 m .56908 .30154 L .57134 .2919 L F
.50495 .67047 m .49251 .6704 L .48994 .67721 L .59 .333 .495 r
F
.5066 .66413 m .49251 .6704 L .50495 .67047 L .588 .321 .481 r
F
.5189 .66416 m .5066 .66413 L .50495 .67047 L .635 .368 .496 r
F
.56459 .31935 m .55037 .30999 L .56683 .31069 L .761 .723 .817 r
F
.56459 .31935 m .54907 .31871 L .55037 .30999 L F
.57286 .67713 m .56257 .68456 L .57596 .68441 L .79 .498 .494 r
F
.57286 .67713 m .56032 .67725 L .56257 .68456 L F
.44428 .23884 m .42747 .24134 L .42335 .22907 L .482 .484 .783 r
F
.44772 .2508 m .42747 .24134 L .44428 .23884 L .482 .488 .787 r
F
.25627 .58207 m .24786 .58282 L .23838 .58979 L 0 0 0 r
F
.26477 .57503 m .24786 .58282 L .25627 .58207 L F
.61403 .26357 m .60055 .25004 L .6179 .25221 L .844 .782 .792 r
F
.61403 .26357 m .59741 .26156 L .60055 .25004 L F
.54776 .32693 m .53274 .31842 L .54907 .31871 L .725 .695 .822 r
F
.54776 .32693 m .53242 .32666 L .53274 .31842 L F
.48735 .68451 m .47458 .68435 L .47117 .69211 L .536 .293 .495 r
F
.48994 .67721 m .47458 .68435 L .48735 .68451 L .534 .284 .482 r
F
.54398 .66415 m .53182 .67052 L .54528 .67049 L .713 .433 .499 r
F
.54398 .66415 m .53151 .66417 L .53182 .67052 L F
.83909 .60385 m .84323 .61044 L .85112 .61084 L .511 0 0 r
F
.83909 .60385 m .83131 .60335 L .84323 .61044 L F
.49845 .31021 m .48247 .31104 L .47989 .30193 L .608 .595 .813 r
F
.50012 .31891 m .48247 .31104 L .49845 .31021 L .607 .6 .818 r
F
.46433 .7091 m .45144 .70874 L .44732 .71792 L .462 .237 .486 r
F
.46776 .70036 m .45144 .70874 L .46433 .7091 L .461 .23 .476 r
F
.66311 .16305 m .64912 .14359 L .6676 .14802 L .897 .815 .759 r
F
.66311 .16305 m .64519 .1589 L .64912 .14359 L F
.37529 .88051 m .36366 .87784 L .35854 .89364 L .166 .008 .408 r
F
.38008 .86496 m .36366 .87784 L .37529 .88051 L .167 .006 .404 r
F
.43071 .75958 m .41802 .75869 L .41332 .77023 L .352 .153 .464 r
F
.43488 .74841 m .41802 .75869 L .43071 .75958 L .352 .148 .457 r
F
.20243 .38884 m .20604 .40027 L .21504 .39638 L .062 .494 .893 r
F
.20243 .38884 m .19329 .393 L .20604 .40027 L F
.55808 .67043 m .54658 .67732 L .56032 .67725 L .752 .468 .502 r
F
.55808 .67043 m .54528 .67049 L .54658 .67732 L F
.66779 .82025 m .66015 .83608 L .67277 .83416 L .942 .639 .436 r
F
.66779 .82025 m .65556 .82198 L .66015 .83608 L F
.5169 .32672 m .50012 .31891 L .51622 .31848 L .65 .636 .822 r
F
.53242 .32666 m .5169 .32672 L .51622 .31848 L .689 .665 .821 r
F
.62378 .73734 m .61477 .74868 L .62828 .74794 L .886 .588 .476 r
F
.62378 .73734 m .61085 .73798 L .61477 .74868 L F
.5189 .66416 m .50495 .67047 L .51821 .67051 L .635 .368 .496 r
F
.53151 .66417 m .5189 .66416 L .51821 .67051 L .676 .404 .502 r
F
.59528 .70018 m .58534 .70921 L .59916 .70888 L .836 .543 .493 r
F
.59528 .70018 m .5822 .70045 L .58534 .70921 L F
.47471 .28222 m .45798 .28371 L .45457 .27323 L .554 .546 .8 r
F
.4773 .29232 m .45798 .28371 L .47471 .28222 L .554 .55 .805 r
F
.24694 .58912 m .23838 .58979 L .22805 .59677 L 0 0 0 r
F
.25627 .58207 m .23838 .58979 L .24694 .58912 L F
.44084 .22638 m .42335 .22907 L .41923 .21632 L .482 .481 .779 r
F
.44428 .23884 m .42335 .22907 L .44084 .22638 L .482 .484 .783 r
F
.53242 .32666 m .51622 .31848 L .53274 .31842 L .689 .665 .821 r
F
.53151 .66417 m .51821 .67051 L .53182 .67052 L .676 .404 .502 r
F
.58804 .29314 m .57361 .28177 L .59115 .2831 L .801 .748 .804 r
F
.58804 .29314 m .57134 .2919 L .57361 .28177 L F
.6179 .25221 m .6037 .23803 L .62177 .24036 L .845 .779 .788 r
F
.6179 .25221 m .60055 .25004 L .6037 .23803 L F
.51622 .31848 m .50012 .31891 L .49845 .31021 L .651 .631 .816 r
F
.6676 .14802 m .65306 .12778 L .6721 .13249 L .898 .813 .756 r
F
.6676 .14802 m .64912 .14359 L .65306 .12778 L F
.85112 .61084 m .85602 .61755 L .864 .61785 L .486 0 0 r
F
.85112 .61084 m .84323 .61044 L .85602 .61755 L F
.56683 .31069 m .55168 .30079 L .56908 .30154 L .763 .719 .812 r
F
.56683 .31069 m .55037 .30999 L .55168 .30079 L F
.37529 .88051 m .35854 .89364 L .37047 .89657 L .166 .008 .408 r
F
.57596 .68441 m .56483 .69236 L .57908 .69219 L .793 .508 .506 r
F
.57596 .68441 m .56257 .68456 L .56483 .69236 L F
.18895 .38123 m .19329 .393 L .20243 .38884 L .069 .508 .897 r
F
.18895 .38123 m .17968 .3857 L .19329 .393 L F
.50328 .6773 m .48994 .67721 L .48735 .68451 L .593 .343 .508 r
F
.50495 .67047 m .48994 .67721 L .50328 .6773 L .59 .333 .495 r
F
.67277 .83416 m .66476 .85069 L .67776 .84856 L .944 .644 .441 r
F
.67277 .83416 m .66015 .83608 L .66476 .85069 L F
.42653 .77124 m .41332 .77023 L .40861 .78226 L .352 .158 .471 r
F
.43071 .75958 m .41332 .77023 L .42653 .77124 L .352 .153 .464 r
F
.51821 .67051 m .50495 .67047 L .50328 .6773 L .638 .379 .51 r
F
.54907 .31871 m .53305 .30968 L .55037 .30999 L .726 .691 .816 r
F
.54907 .31871 m .53274 .31842 L .53305 .30968 L F
.46089 .71834 m .44732 .71792 L .44319 .72759 L .463 .244 .495 r
F
.46433 .7091 m .44732 .71792 L .46089 .71834 L .462 .237 .486 r
F
.48476 .6923 m .47117 .69211 L .46776 .70036 L .537 .302 .506 r
F
.48735 .68451 m .47117 .69211 L .48476 .6923 L .536 .293 .495 r
F
.49678 .30102 m .47989 .30193 L .4773 .29232 L .608 .59 .808 r
F
.49845 .31021 m .47989 .30193 L .49678 .30102 L .608 .595 .813 r
F
.23676 .59618 m .22805 .59677 L .21688 .60377 L 0 0 0 r
F
.24694 .58912 m .22805 .59677 L .23676 .59618 L F
.43738 .21343 m .41923 .21632 L .4151 .20307 L .481 .477 .776 r
F
.44084 .22638 m .41923 .21632 L .43738 .21343 L .482 .481 .779 r
F
.62828 .74794 m .6187 .75988 L .6328 .75903 L .888 .594 .484 r
F
.62828 .74794 m .61477 .74868 L .6187 .75988 L F
.6721 .13249 m .65701 .11146 L .6766 .11648 L .899 .811 .753 r
F
.6721 .13249 m .65306 .12778 L .65701 .11146 L F
.47211 .27162 m .45457 .27323 L .45115 .26226 L .554 .542 .796 r
F
.47471 .28222 m .45457 .27323 L .47211 .27162 L .554 .546 .8 r
F
.54528 .67049 m .53214 .67736 L .54658 .67732 L .716 .445 .513 r
F
.54528 .67049 m .53182 .67052 L .53214 .67736 L F
.59916 .70888 m .58849 .71848 L .60304 .71809 L .838 .551 .503 r
F
.59916 .70888 m .58534 .70921 L .58849 .71848 L F
.62177 .24036 m .60686 .22551 L .62565 .22802 L .846 .777 .784 r
F
.62177 .24036 m .6037 .23803 L .60686 .22551 L F
.56032 .67725 m .54789 .68465 L .56257 .68456 L .755 .479 .515 r
F
.56032 .67725 m .54658 .67732 L .54789 .68465 L F
.51622 .31848 m .49845 .31021 L .51553 .30975 L .651 .631 .816 r
F
.53274 .31842 m .51622 .31848 L .51553 .30975 L .69 .66 .815 r
F
.59115 .2831 m .57588 .27113 L .59428 .27258 L .802 .745 .799 r
F
.59115 .2831 m .57361 .28177 L .57588 .27113 L F
.864 .61785 m .86968 .62469 L .87774 .62487 L .463 0 0 r
F
.864 .61785 m .85602 .61755 L .86968 .62469 L F
.67776 .84856 m .66938 .86581 L .68277 .86346 L .945 .649 .446 r
F
.67776 .84856 m .66476 .85069 L .66938 .86581 L F
.53274 .31842 m .51553 .30975 L .53305 .30968 L .69 .66 .815 r
F
.51821 .67051 m .50328 .6773 L .51753 .67735 L .638 .379 .51 r
F
.53182 .67052 m .51821 .67051 L .51753 .67735 L .679 .415 .516 r
F
.42233 .78341 m .40861 .78226 L .40388 .79479 L .352 .162 .477 r
F
.42653 .77124 m .40861 .78226 L .42233 .78341 L .352 .158 .471 r
F
.51553 .30975 m .49845 .31021 L .49678 .30102 L .652 .626 .811 r
F
.43392 .19998 m .4151 .20307 L .41096 .18933 L .481 .474 .773 r
F
.43738 .21343 m .4151 .20307 L .43392 .19998 L .481 .477 .776 r
F
.53182 .67052 m .51753 .67735 L .53214 .67736 L .679 .415 .516 r
F
.22574 .60327 m .21688 .60377 L .20485 .61077 L 0 0 0 r
F
.23676 .59618 m .21688 .60377 L .22574 .60327 L F
.56908 .30154 m .553 .29108 L .57134 .2919 L .764 .715 .807 r
F
.56908 .30154 m .55168 .30079 L .553 .29108 L F
.57908 .69219 m .5671 .70066 L .5822 .70045 L .796 .517 .516 r
F
.57908 .69219 m .56483 .69236 L .5671 .70066 L F
.45743 .72808 m .44319 .72759 L .43904 .73775 L .464 .25 .503 r
F
.46089 .71834 m .44319 .72759 L .45743 .72808 L .463 .244 .495 r
F
.6328 .75903 m .62265 .77158 L .63732 .77062 L .89 .601 .491 r
F
.6328 .75903 m .6187 .75988 L .62265 .77158 L F
.50161 .68462 m .48735 .68451 L .48476 .6923 L .594 .352 .52 r
F
.50328 .6773 m .48735 .68451 L .50161 .68462 L .593 .343 .508 r
F
.49511 .29134 m .4773 .29232 L .47471 .28222 L .608 .586 .803 r
F
.49678 .30102 m .4773 .29232 L .49511 .29134 L .608 .59 .808 r
F
.62565 .22802 m .61002 .2125 L .62954 .21518 L .847 .774 .78 r
F
.62565 .22802 m .60686 .22551 L .61002 .2125 L F
.4695 .26052 m .45115 .26226 L .44772 .2508 L .554 .538 .792 r
F
.47211 .27162 m .45115 .26226 L .4695 .26052 L .554 .542 .796 r
F
.48216 .70059 m .46776 .70036 L .46433 .7091 L .539 .309 .516 r
F
.48476 .6923 m .46776 .70036 L .48216 .70059 L .537 .302 .506 r
F
.55037 .30999 m .53337 .30044 L .55168 .30079 L .727 .686 .81 r
F
.55037 .30999 m .53305 .30968 L .53337 .30044 L F
.68277 .86346 m .67401 .88145 L .68778 .87885 L .946 .653 .45 r
F
.68277 .86346 m .66938 .86581 L .67401 .88145 L F
.51753 .67735 m .50328 .6773 L .50161 .68462 L .64 .389 .523 r
F
.75197 .4981 m .74026 .50366 L .75159 .50514 L .994 .828 .567 r
F
.75197 .4981 m .74062 .49654 L .74026 .50366 L F
.75314 .49106 m .74062 .49654 L .75197 .4981 L .988 .869 .624 r
F
.75314 .49106 m .74174 .48941 L .74062 .49654 L F
.75511 .48399 m .74174 .48941 L .75314 .49106 L .976 .903 .676 r
F
.60304 .71809 m .59165 .72824 L .60694 .72778 L .84 .559 .511 r
F
.60304 .71809 m .58849 .71848 L .59165 .72824 L F
.75159 .50514 m .74067 .51076 L .75202 .51216 L .994 .78 .505 r
F
.75159 .50514 m .74026 .50366 L .74067 .51076 L F
.59428 .27258 m .57816 .26 L .59741 .26156 L .804 .742 .795 r
F
.59428 .27258 m .57588 .27113 L .57816 .26 L F
.75511 .48399 m .74364 .48225 L .74174 .48941 L .976 .903 .676 r
F
.75788 .47691 m .74364 .48225 L .75511 .48399 L .959 .93 .721 r
F
.75202 .51216 m .74185 .51784 L .75325 .51917 L .987 .727 .439 r
F
.75202 .51216 m .74067 .51076 L .74185 .51784 L F
.43045 .18603 m .41096 .18933 L .40682 .17511 L .481 .471 .77 r
F
.43392 .19998 m .41096 .18933 L .43045 .18603 L .481 .474 .773 r
F
.41812 .79609 m .40388 .79479 L .39915 .80782 L .352 .166 .483 r
F
.42233 .78341 m .40388 .79479 L .41812 .79609 L .352 .162 .477 r
F
.75788 .47691 m .7463 .47506 L .74364 .48225 L .959 .93 .721 r
F
.76146 .4698 m .7463 .47506 L .75788 .47691 L .939 .951 .76 r
F
.21386 .61037 m .20485 .61077 L .19197 .6178 L 0 0 0 r
F
.22574 .60327 m .20485 .61077 L .21386 .61037 L F
.54658 .67732 m .53245 .68469 L .54789 .68465 L .719 .455 .526 r
F
.54658 .67732 m .53214 .67736 L .53245 .68469 L F
.75325 .51917 m .7438 .52492 L .75528 .52617 L .973 .669 .371 r
F
.75325 .51917 m .74185 .51784 L .7438 .52492 L F
.51553 .30975 m .49678 .30102 L .51484 .30052 L .652 .626 .811 r
F
.53305 .30968 m .51553 .30975 L .51484 .30052 L .691 .656 .81 r
F
.56257 .68456 m .54921 .69248 L .56483 .69236 L .757 .488 .526 r
F
.56257 .68456 m .54789 .68465 L .54921 .69248 L F
.53305 .30968 m .51484 .30052 L .53337 .30044 L .691 .656 .81 r
F
.63732 .77062 m .62661 .7838 L .64186 .78271 L .892 .606 .497 r
F
.63732 .77062 m .62265 .77158 L .62661 .7838 L F
.76146 .4698 m .74974 .46784 L .7463 .47506 L .939 .951 .76 r
F
.76584 .46267 m .74974 .46784 L .76146 .4698 L .915 .966 .793 r
F
.51484 .30052 m .49678 .30102 L .49511 .29134 L .653 .622 .806 r
F
.62954 .21518 m .6132 .19898 L .63344 .20186 L .848 .772 .777 r
F
.62954 .21518 m .61002 .2125 L .6132 .19898 L F
.68778 .87885 m .67866 .89761 L .69281 .89475 L .948 .657 .454 r
F
.68778 .87885 m .67401 .88145 L .67866 .89761 L F
.57134 .2919 m .55432 .28088 L .57361 .28177 L .765 .712 .802 r
F
.57134 .2919 m .553 .29108 L .55432 .28088 L F
.75528 .52617 m .74652 .53198 L .75811 .53317 L .953 .607 .301 r
F
.75528 .52617 m .7438 .52492 L .74652 .53198 L F
.45397 .73833 m .43904 .73775 L .43488 .74841 L .464 .255 .511 r
F
.45743 .72808 m .43904 .73775 L .45397 .73833 L .464 .25 .503 r
F
.46688 .24892 m .44772 .2508 L .44428 .23884 L .554 .535 .788 r
F
.4695 .26052 m .44772 .2508 L .46688 .24892 L .554 .538 .792 r
F
.51753 .67735 m .50161 .68462 L .51683 .68468 L .64 .389 .523 r
F
.53214 .67736 m .51753 .67735 L .51683 .68468 L .681 .425 .528 r
F
.5822 .70045 m .56938 .70947 L .58534 .70921 L .798 .525 .526 r
F
.5822 .70045 m .5671 .70066 L .56938 .70947 L F
.49343 .28115 m .47471 .28222 L .47211 .27162 L .609 .582 .799 r
F
.49511 .29134 m .47471 .28222 L .49343 .28115 L .608 .586 .803 r
F
.76584 .46267 m .75395 .46059 L .74974 .46784 L .915 .966 .793 r
F
.77102 .45552 m .75395 .46059 L .76584 .46267 L .891 .977 .821 r
F
.42697 .17157 m .40682 .17511 L .40266 .16039 L .48 .468 .767 r
F
.43045 .18603 m .40682 .17511 L .42697 .17157 L .481 .471 .77 r
F
.53214 .67736 m .51683 .68468 L .53245 .68469 L .681 .425 .528 r
F
.75811 .53317 m .75001 .53904 L .76175 .54017 L .928 .544 .232 r
F
.75811 .53317 m .74652 .53198 L .75001 .53904 L F
.47955 .70938 m .46433 .7091 L .46089 .71834 L .54 .316 .524 r
F
.48216 .70059 m .46433 .7091 L .47955 .70938 L .539 .309 .516 r
F
.4139 .80927 m .39915 .80782 L .3944 .82135 L .352 .169 .488 r
F
.41812 .79609 m .39915 .80782 L .4139 .80927 L .352 .166 .483 r
F
.49994 .69244 m .48476 .6923 L .48216 .70059 L .596 .36 .53 r
F
.50161 .68462 m .48476 .6923 L .49994 .69244 L .594 .352 .52 r
F
.55168 .30079 m .53369 .29071 L .553 .29108 L .729 .683 .806 r
F
.55168 .30079 m .53337 .30044 L .53369 .29071 L F
.60694 .72778 m .59483 .73852 L .61085 .73798 L .842 .565 .519 r
F
.60694 .72778 m .59165 .72824 L .59483 .73852 L F
.59741 .26156 m .58044 .24836 L .60055 .25004 L .805 .739 .791 r
F
.59741 .26156 m .57816 .26 L .58044 .24836 L F
.20112 .6175 m .19197 .6178 L .17822 .62484 L 0 0 0 r
F
.21386 .61037 m .19197 .6178 L .20112 .6175 L F
.77102 .45552 m .75893 .4533 L .75395 .46059 L .891 .977 .821 r
F
.77702 .44833 m .75893 .4533 L .77102 .45552 L .865 .984 .845 r
F
.51683 .68468 m .50161 .68462 L .49994 .69244 L .642 .398 .533 r
F
.31686 .49629 m .30473 .49784 L .3051 .50488 L .137 .127 .582 r
F
.31574 .48914 m .30473 .49784 L .31686 .49629 L .144 .177 .637 r
F
.31574 .48914 m .30356 .49077 L .30473 .49784 L F
.31387 .48196 m .30356 .49077 L .31574 .48914 L .15 .225 .686 r
F
.31387 .48196 m .3016 .48369 L .30356 .49077 L F
.31721 .50342 m .3051 .50488 L .30467 .51192 L .129 .075 .522 r
F
.31686 .49629 m .3051 .50488 L .31721 .50342 L .137 .127 .582 r
F
.63344 .20186 m .61638 .18495 L .63735 .18803 L .849 .77 .774 r
F
.63344 .20186 m .6132 .19898 L .61638 .18495 L F
.76175 .54017 m .75429 .5461 L .76619 .54716 L .898 .481 .166 r
F
.76175 .54017 m .75001 .53904 L .75429 .5461 L F
.64186 .78271 m .63059 .79653 L .64642 .79529 L .893 .612 .502 r
F
.64186 .78271 m .62661 .7838 L .63059 .79653 L F
.31123 .47475 m .3016 .48369 L .31387 .48196 L .156 .269 .73 r
F
.31123 .47475 m .29884 .47659 L .3016 .48369 L F
.3168 .51053 m .30467 .51192 L .30345 .51894 L .121 .022 .458 r
F
.31721 .50342 m .30467 .51192 L .3168 .51053 L .129 .075 .522 r
F
.42348 .15661 m .40266 .16039 L .3985 .14517 L .48 .465 .764 r
F
.42697 .17157 m .40266 .16039 L .42348 .15661 L .48 .468 .767 r
F
.51484 .30052 m .49511 .29134 L .51414 .29079 L .653 .622 .806 r
F
.53337 .30044 m .51484 .30052 L .51414 .29079 L .692 .652 .805 r
F
.46425 .23683 m .44428 .23884 L .44084 .22638 L .554 .532 .784 r
F
.46688 .24892 m .44428 .23884 L .46425 .23683 L .554 .535 .788 r
F
.45049 .74908 m .43488 .74841 L .43071 .75958 L .465 .26 .517 r
F
.45397 .73833 m .43488 .74841 L .45049 .74908 L .464 .255 .511 r
F
.30782 .46752 m .29884 .47659 L .31123 .47475 L .161 .31 .768 r
F
.30782 .46752 m .29529 .46946 L .29884 .47659 L F
.31564 .51762 m .30345 .51894 L .30143 .52596 L .113 0 .392 r
F
.3168 .51053 m .30345 .51894 L .31564 .51762 L .121 .022 .458 r
F
.57361 .28177 m .55564 .27017 L .57588 .27113 L .766 .709 .798 r
F
.57361 .28177 m .55432 .28088 L .55564 .27017 L F
.54789 .68465 m .53277 .69253 L .54921 .69248 L .721 .464 .536 r
F
.54789 .68465 m .53245 .68469 L .53277 .69253 L F
.77702 .44833 m .76471 .44597 L .75893 .4533 L .865 .984 .845 r
F
.78383 .44112 m .76471 .44597 L .77702 .44833 L .839 .987 .864 r
F
.56483 .69236 m .55053 .70081 L .5671 .70066 L .759 .496 .536 r
F
.56483 .69236 m .54921 .69248 L .55053 .70081 L F
.51414 .29079 m .49511 .29134 L .49343 .28115 L .653 .618 .802 r
F
.53337 .30044 m .51414 .29079 L .53369 .29071 L .692 .652 .805 r
F
.40966 .82297 m .3944 .82135 L .38964 .83538 L .352 .173 .493 r
F
.4139 .80927 m .3944 .82135 L .40966 .82297 L .352 .169 .488 r
F
.76619 .54716 m .75934 .55315 L .77144 .55416 L .866 .419 .102 r
F
.76619 .54716 m .75429 .5461 L .75934 .55315 L F
.49174 .27047 m .47211 .27162 L .4695 .26052 L .609 .579 .795 r
F
.49343 .28115 m .47211 .27162 L .49174 .27047 L .609 .582 .799 r
F
.30365 .46024 m .29529 .46946 L .30782 .46752 L .166 .347 .8 r
F
.30365 .46024 m .29093 .46231 L .29529 .46946 L F
.31371 .52471 m .30143 .52596 L .29862 .53297 L .104 0 .325 r
F
.31564 .51762 m .30143 .52596 L .31371 .52471 L .113 0 .392 r
F
.58534 .70921 m .57167 .71878 L .58849 .71848 L .8 .533 .534 r
F
.58534 .70921 m .56938 .70947 L .57167 .71878 L F
.60055 .25004 m .58273 .23622 L .6037 .23803 L .806 .737 .788 r
F
.60055 .25004 m .58044 .24836 L .58273 .23622 L F
.20112 .6175 m .17822 .62484 L .1875 .62466 L 0 0 0 r
F
.47693 .71868 m .46089 .71834 L .45743 .72808 L .541 .322 .532 r
F
.47955 .70938 m .46089 .71834 L .47693 .71868 L .54 .316 .524 r
F
.61085 .73798 m .59801 .7493 L .61477 .74868 L .844 .571 .526 r
F
.61085 .73798 m .59483 .73852 L .59801 .7493 L F
.63735 .18803 m .61957 .17043 L .64127 .17372 L .85 .768 .771 r
F
.63735 .18803 m .61638 .18495 L .61957 .17043 L F
.51683 .68468 m .49994 .69244 L .51614 .69252 L .642 .398 .533 r
F
.53245 .68469 m .51683 .68468 L .51614 .69252 L .683 .434 .539 r
F
.553 .29108 m .534 .28047 L .55432 .28088 L .729 .679 .801 r
F
.553 .29108 m .53369 .29071 L .534 .28047 L F
.41999 .14115 m .3985 .14517 L .39434 .12946 L .479 .463 .761 r
F
.42348 .15661 m .3985 .14517 L .41999 .14115 L .48 .465 .764 r
F
.78383 .44112 m .77126 .43859 L .76471 .44597 L .839 .987 .864 r
F
.79146 .43387 m .77126 .43859 L .78383 .44112 L .813 .988 .88 r
F
.29871 .45293 m .29093 .46231 L .30365 .46024 L .169 .381 .828 r
F
.29871 .45293 m .28577 .45514 L .29093 .46231 L F
.49825 .70076 m .48216 .70059 L .47955 .70938 L .597 .367 .539 r
F
.49994 .69244 m .48216 .70059 L .49825 .70076 L .596 .36 .53 r
F
.53245 .68469 m .51614 .69252 L .53277 .69253 L .683 .434 .539 r
F
.64642 .79529 m .63458 .80977 L .65098 .80838 L .895 .616 .508 r
F
.64642 .79529 m .63059 .79653 L .63458 .80977 L F
.31101 .53178 m .29862 .53297 L .295 .53997 L .095 0 .258 r
F
.31371 .52471 m .29862 .53297 L .31101 .53178 L .104 0 .325 r
F
.77144 .55416 m .76518 .56022 L .77751 .56115 L .831 .359 .043 r
F
.77144 .55416 m .75934 .55315 L .76518 .56022 L F
.46162 .22422 m .44084 .22638 L .43738 .21343 L .554 .529 .781 r
F
.46425 .23683 m .44084 .22638 L .46162 .22422 L .554 .532 .784 r
F
.447 .76034 m .43071 .75958 L .42653 .77124 L .465 .265 .523 r
F
.45049 .74908 m .43071 .75958 L .447 .76034 L .465 .26 .517 r
F
.4054 .83719 m .38964 .83538 L .38487 .84992 L .352 .176 .497 r
F
.40966 .82297 m .38964 .83538 L .4054 .83719 L .352 .173 .493 r
F
.51614 .69252 m .49994 .69244 L .49825 .70076 L .644 .405 .543 r
F
.29299 .44557 m .28577 .45514 L .29871 .45293 L .173 .411 .851 r
F
.29299 .44557 m .2798 .44793 L .28577 .45514 L F
.30755 .53885 m .295 .53997 L .29058 .54698 L .087 0 .193 r
F
.31101 .53178 m .295 .53997 L .30755 .53885 L .095 0 .258 r
F
.51414 .29079 m .49343 .28115 L .51345 .28056 L .653 .618 .802 r
F
.53369 .29071 m .51414 .29079 L .51345 .28056 L .693 .648 .801 r
F
.57588 .27113 m .55697 .25896 L .57816 .26 L .767 .706 .794 r
F
.57588 .27113 m .55564 .27017 L .55697 .25896 L F
.79146 .43387 m .77862 .43117 L .77126 .43859 L .813 .988 .88 r
F
.79991 .42658 m .77862 .43117 L .79146 .43387 L .788 .987 .893 r
F
.51345 .28056 m .49343 .28115 L .49174 .27047 L .654 .614 .797 r
F
.64127 .17372 m .62277 .15539 L .64519 .1589 L .851 .766 .768 r
F
.64127 .17372 m .61957 .17043 L .62277 .15539 L F
.41649 .12518 m .39434 .12946 L .39016 .11326 L .479 .46 .759 r
F
.41999 .14115 m .39434 .12946 L .41649 .12518 L .479 .463 .761 r
F
.49005 .25928 m .4695 .26052 L .46688 .24892 L .609 .575 .791 r
F
.49174 .27047 m .4695 .26052 L .49005 .25928 L .609 .579 .795 r
F
.53369 .29071 m .51345 .28056 L .534 .28047 L .693 .648 .801 r
F
.6037 .23803 m .58503 .22357 L .60686 .22551 L .806 .734 .784 r
F
.6037 .23803 m .58273 .23622 L .58503 .22357 L F
.5671 .70066 m .55186 .70964 L .56938 .70947 L .761 .504 .544 r
F
.5671 .70066 m .55053 .70081 L .55186 .70964 L F
.77751 .56115 m .77182 .56728 L .7844 .56816 L .797 .302 0 r
F
.77751 .56115 m .76518 .56022 L .77182 .56728 L F
.54921 .69248 m .53309 .70087 L .55053 .70081 L .723 .471 .546 r
F
.54921 .69248 m .53277 .69253 L .53309 .70087 L F
.61477 .74868 m .60121 .76059 L .6187 .75988 L .845 .577 .532 r
F
.61477 .74868 m .59801 .7493 L .60121 .76059 L F
.28649 .43817 m .2798 .44793 L .29299 .44557 L .176 .438 .87 r
F
.28649 .43817 m .27302 .44068 L .2798 .44793 L F
.65098 .80838 m .63858 .82353 L .65556 .82198 L .896 .621 .513 r
F
.65098 .80838 m .63458 .80977 L .63858 .82353 L F
.58849 .71848 m .57397 .7286 L .59165 .72824 L .801 .539 .542 r
F
.58849 .71848 m .57167 .71878 L .57397 .7286 L F
.47429 .72848 m .45743 .72808 L .45397 .73833 L .541 .328 .539 r
F
.47693 .71868 m .45743 .72808 L .47429 .72848 L .541 .322 .532 r
F
.30331 .54592 m .29058 .54698 L .28535 .55398 L .079 0 .131 r
F
.30755 .53885 m .29058 .54698 L .30331 .54592 L .087 0 .193 r
F
.45898 .21111 m .43738 .21343 L .43392 .19998 L .554 .526 .778 r
F
.46162 .22422 m .43738 .21343 L .45898 .21111 L .554 .529 .781 r
F
.55432 .28088 m .53432 .26973 L .55564 .27017 L .73 .676 .797 r
F
.55432 .28088 m .534 .28047 L .53432 .26973 L F
.40114 .85192 m .38487 .84992 L .38008 .86496 L .352 .179 .502 r
F
.4054 .83719 m .38487 .84992 L .40114 .85192 L .352 .176 .497 r
F
.79991 .42658 m .78677 .4237 L .77862 .43117 L .788 .987 .893 r
F
.80919 .41926 m .78677 .4237 L .79991 .42658 L .764 .985 .904 r
F
.49656 .70959 m .47955 .70938 L .47693 .71868 L .598 .374 .547 r
F
.49825 .70076 m .47955 .70938 L .49656 .70959 L .597 .367 .539 r
F
.51614 .69252 m .49825 .70076 L .51544 .70086 L .644 .405 .543 r
F
.53277 .69253 m .51614 .69252 L .51544 .70086 L .685 .441 .548 r
F
.4435 .77211 m .42653 .77124 L .42233 .78341 L .465 .269 .529 r
F
.447 .76034 m .42653 .77124 L .4435 .77211 L .465 .265 .523 r
F
.41649 .12518 m .39016 .11326 L .41297 .10869 L .479 .46 .759 r
F
.64519 .1589 m .62598 .13984 L .64912 .14359 L .852 .765 .766 r
F
.64519 .1589 m .62277 .15539 L .62598 .13984 L F
.53277 .69253 m .51544 .70086 L .53309 .70087 L .685 .441 .548 r
F
.7844 .56816 m .77925 .57437 L .79211 .57517 L .762 .248 0 r
F
.7844 .56816 m .77182 .56728 L .77925 .57437 L F
.2792 .43072 m .27302 .44068 L .28649 .43817 L .178 .462 .885 r
F
.2792 .43072 m .26543 .43341 L .27302 .44068 L F
.2983 .55299 m .28535 .55398 L .27931 .56099 L .072 0 .072 r
F
.30331 .54592 m .28535 .55398 L .2983 .55299 L .079 0 .131 r
F
.57816 .26 m .5583 .24724 L .58044 .24836 L .768 .703 .79 r
F
.57816 .26 m .55697 .25896 L .5583 .24724 L F
.60686 .22551 m .58734 .21041 L .61002 .2125 L .807 .732 .781 r
F
.60686 .22551 m .58503 .22357 L .58734 .21041 L F
.48835 .24759 m .46688 .24892 L .46425 .23683 L .61 .572 .787 r
F
.49005 .25928 m .46688 .24892 L .48835 .24759 L .609 .575 .791 r
F
.51345 .28056 m .49174 .27047 L .51275 .26983 L .654 .614 .797 r
F
.534 .28047 m .51345 .28056 L .51275 .26983 L .694 .645 .797 r
F
.51275 .26983 m .49174 .27047 L .49005 .25928 L .654 .611 .794 r
F
.51544 .70086 m .49825 .70076 L .49656 .70959 L .645 .412 .551 r
F
.65556 .82198 m .6426 .83781 L .66015 .83608 L .897 .625 .517 r
F
.65556 .82198 m .63858 .82353 L .6426 .83781 L F
.534 .28047 m .51275 .26983 L .53432 .26973 L .694 .645 .797 r
F
.6187 .75988 m .60442 .7724 L .62265 .77158 L .847 .582 .538 r
F
.6187 .75988 m .60121 .76059 L .60442 .7724 L F
.45633 .1975 m .43392 .19998 L .43045 .18603 L .554 .523 .775 r
F
.45898 .21111 m .43392 .19998 L .45633 .1975 L .554 .526 .778 r
F
.80919 .41926 m .79572 .41617 L .78677 .4237 L .764 .985 .904 r
F
.8193 .4119 m .79572 .41617 L .80919 .41926 L .742 .981 .912 r
F
.39686 .86718 m .38008 .86496 L .37529 .88051 L .352 .181 .505 r
F
.40114 .85192 m .38008 .86496 L .39686 .86718 L .352 .179 .502 r
F
.56938 .70947 m .55319 .71898 L .57167 .71878 L .762 .51 .552 r
F
.56938 .70947 m .55186 .70964 L .55319 .71898 L F
.47165 .73879 m .45397 .73833 L .45049 .74908 L .542 .333 .546 r
F
.47429 .72848 m .45397 .73833 L .47165 .73879 L .541 .328 .539 r
F
.27112 .42322 m .26543 .43341 L .2792 .43072 L .181 .484 .898 r
F
.27112 .42322 m .25701 .42609 L .26543 .43341 L F
.59165 .72824 m .57628 .73893 L .59483 .73852 L .803 .545 .549 r
F
.59165 .72824 m .57397 .7286 L .57628 .73893 L F
.64912 .14359 m .62919 .12378 L .65306 .12778 L .852 .763 .763 r
F
.64912 .14359 m .62598 .13984 L .62919 .12378 L F
.55053 .70081 m .53341 .70972 L .55186 .70964 L .724 .478 .554 r
F
.55053 .70081 m .53309 .70087 L .53341 .70972 L F
.29252 .56006 m .27931 .56099 L .27245 .56801 L .065 0 .017 r
F
.2983 .55299 m .27931 .56099 L .29252 .56006 L .072 0 .072 r
F
.79211 .57517 m .78749 .58146 L .80065 .58219 L .728 .199 0 r
F
.79211 .57517 m .77925 .57437 L .78749 .58146 L F
.55564 .27017 m .53464 .25848 L .55697 .25896 L .731 .673 .793 r
F
.55564 .27017 m .53432 .26973 L .53464 .25848 L F
.43998 .7844 m .42233 .78341 L .41812 .79609 L .466 .273 .534 r
F
.4435 .77211 m .42233 .78341 L .43998 .7844 L .465 .269 .529 r
F
.49486 .71892 m .47693 .71868 L .47429 .72848 L .599 .379 .554 r
F
.49656 .70959 m .47693 .71868 L .49486 .71892 L .598 .374 .547 r
F
.61002 .2125 m .58965 .19674 L .6132 .19898 L .808 .73 .778 r
F
.61002 .2125 m .58734 .21041 L .58965 .19674 L F
.58044 .24836 m .55964 .23501 L .58273 .23622 L .768 .7 .787 r
F
.58044 .24836 m .5583 .24724 L .55964 .23501 L F
.51544 .70086 m .49656 .70959 L .51474 .7097 L .645 .412 .551 r
F
.53309 .70087 m .51544 .70086 L .51474 .7097 L .686 .448 .556 r
F
.66015 .83608 m .64663 .85261 L .66476 .85069 L .898 .629 .521 r
F
.66015 .83608 m .6426 .83781 L .64663 .85261 L F
.48665 .23539 m .46425 .23683 L .46162 .22422 L .61 .57 .784 r
F
.48835 .24759 m .46425 .23683 L .48665 .23539 L .61 .572 .787 r
F
.8193 .4119 m .8055 .40858 L .79572 .41617 L .742 .981 .912 r
F
.83025 .40449 m .8055 .40858 L .8193 .4119 L .72 .977 .919 r
F
.53309 .70087 m .51474 .7097 L .53341 .70972 L .686 .448 .556 r
F
.26224 .41566 m .25701 .42609 L .27112 .42322 L .183 .503 .909 r
F
.26224 .41566 m .24777 .41873 L .25701 .42609 L F
.45367 .18337 m .43045 .18603 L .42697 .17157 L .554 .52 .772 r
F
.45633 .1975 m .43045 .18603 L .45367 .18337 L .554 .523 .775 r
F
.39256 .88296 m .37529 .88051 L .37047 .89657 L .351 .184 .509 r
F
.39686 .86718 m .37529 .88051 L .39256 .88296 L .352 .181 .505 r
F
.51205 .25859 m .49005 .25928 L .48835 .24759 L .655 .608 .79 r
F
.51275 .26983 m .49005 .25928 L .51205 .25859 L .654 .611 .794 r
F
.65306 .12778 m .63241 .1072 L .65701 .11146 L .853 .762 .761 r
F
.65306 .12778 m .62919 .12378 L .63241 .1072 L F
.53432 .26973 m .51275 .26983 L .51205 .25859 L .694 .642 .793 r
F
.28594 .56714 m .27245 .56801 L .26477 .57503 L .059 0 0 r
F
.29252 .56006 m .27245 .56801 L .28594 .56714 L .065 0 .017 r
F
.62265 .77158 m .60764 .78472 L .62661 .7838 L .848 .587 .544 r
F
.62265 .77158 m .60442 .7724 L .60764 .78472 L F
.53432 .26973 m .51205 .25859 L .53464 .25848 L .694 .642 .793 r
F
.80065 .58219 m .79654 .58857 L .81003 .58923 L .695 .153 0 r
F
.80065 .58219 m .78749 .58146 L .79654 .58857 L F
.51474 .7097 m .49656 .70959 L .49486 .71892 L .646 .418 .559 r
F
.46899 .74962 m .45049 .74908 L .447 .76034 L .543 .337 .552 r
F
.47165 .73879 m .45049 .74908 L .46899 .74962 L .542 .333 .546 r
F
.43645 .79721 m .41812 .79609 L .4139 .80927 L .466 .277 .539 r
F
.43998 .7844 m .41812 .79609 L .43645 .79721 L .466 .273 .534 r
F
.59483 .73852 m .57859 .74978 L .59801 .7493 L .804 .55 .555 r
F
.59483 .73852 m .57628 .73893 L .57859 .74978 L F
.57167 .71878 m .55453 .72884 L .57397 .7286 L .764 .516 .559 r
F
.57167 .71878 m .55319 .71898 L .55453 .72884 L F
.55697 .25896 m .53497 .24673 L .5583 .24724 L .732 .67 .79 r
F
.55697 .25896 m .53464 .25848 L .53497 .24673 L F
.6132 .19898 m .59197 .18256 L .61638 .18495 L .809 .728 .775 r
F
.6132 .19898 m .58965 .19674 L .59197 .18256 L F
.55186 .70964 m .53373 .71908 L .55319 .71898 L .726 .484 .561 r
F
.55186 .70964 m .53341 .70972 L .53373 .71908 L F
.66476 .85069 m .65068 .86794 L .66938 .86581 L .899 .633 .525 r
F
.66476 .85069 m .64663 .85261 L .65068 .86794 L F
.25255 .40803 m .24777 .41873 L .26224 .41566 L .185 .519 .917 r
F
.25255 .40803 m .2377 .41133 L .24777 .41873 L F
.39256 .88296 m .37047 .89657 L .38825 .89926 L .351 .184 .509 r
F
.45101 .16873 m .42697 .17157 L .42348 .15661 L .554 .518 .77 r
F
.45367 .18337 m .42697 .17157 L .45101 .16873 L .554 .52 .772 r
F
.83025 .40449 m .81609 .40093 L .8055 .40858 L .72 .977 .919 r
F
.84205 .39704 m .81609 .40093 L .83025 .40449 L .7 .972 .925 r
F
.58273 .23622 m .56098 .22227 L .58503 .22357 L .769 .698 .784 r
F
.58273 .23622 m .55964 .23501 L .56098 .22227 L F
.48494 .22268 m .46162 .22422 L .45898 .21111 L .61 .567 .781 r
F
.48665 .23539 m .46162 .22422 L .48494 .22268 L .61 .57 .784 r
F
.27857 .57423 m .26477 .57503 L .25627 .58207 L .053 0 0 r
F
.28594 .56714 m .26477 .57503 L .27857 .57423 L .059 0 0 r
F
.49316 .72876 m .47429 .72848 L .47165 .73879 L .6 .385 .56 r
F
.49486 .71892 m .47429 .72848 L .49316 .72876 L .599 .379 .554 r
F
.51135 .24685 m .48835 .24759 L .48665 .23539 L .655 .605 .787 r
F
.51205 .25859 m .48835 .24759 L .51135 .24685 L .655 .608 .79 r
F
.81003 .58923 m .80641 .5957 L .82025 .59628 L .664 .11 0 r
F
.81003 .58923 m .79654 .58857 L .80641 .5957 L F
.62661 .7838 m .61088 .79757 L .63059 .79653 L .849 .591 .548 r
F
.62661 .7838 m .60764 .78472 L .61088 .79757 L F
.53464 .25848 m .51205 .25859 L .51135 .24685 L .695 .639 .79 r
F
.51474 .7097 m .49486 .71892 L .51404 .71905 L .646 .418 .559 r
F
.53341 .70972 m .51474 .7097 L .51404 .71905 L .688 .454 .564 r
F
.53341 .70972 m .51404 .71905 L .53373 .71908 L F
.53464 .25848 m .51135 .24685 L .53497 .24673 L .695 .639 .79 r
F
.43291 .81053 m .4139 .80927 L .40966 .82297 L .466 .28 .543 r
F
.43645 .79721 m .4139 .80927 L .43291 .81053 L .466 .277 .539 r
F
.46633 .76096 m .447 .76034 L .4435 .77211 L .543 .341 .557 r
F
.46899 .74962 m .447 .76034 L .46633 .76096 L .543 .337 .552 r
F
.61638 .18495 m .5943 .16787 L .61957 .17043 L .809 .726 .773 r
F
.61638 .18495 m .59197 .18256 L .5943 .16787 L F
.51404 .71905 m .49486 .71892 L .49316 .72876 L .647 .424 .566 r
F
.66938 .86581 m .65474 .88379 L .67401 .88145 L .9 .636 .529 r
F
.66938 .86581 m .65068 .86794 L .65474 .88379 L F
.59801 .7493 m .58092 .76114 L .60121 .76059 L .805 .555 .561 r
F
.59801 .7493 m .57859 .74978 L .58092 .76114 L F
.24204 .40035 m .2377 .41133 L .25255 .40803 L .187 .535 .924 r
F
.24204 .40035 m .22679 .40388 L .2377 .41133 L F
.44834 .15357 m .42348 .15661 L .41999 .14115 L .554 .516 .768 r
F
.45101 .16873 m .42348 .15661 L .44834 .15357 L .554 .518 .77 r
F
.5583 .24724 m .53529 .23446 L .55964 .23501 L .732 .667 .786 r
F
.5583 .24724 m .53497 .24673 L .53529 .23446 L F
.57397 .7286 m .55587 .73921 L .57628 .73893 L .765 .521 .566 r
F
.57397 .7286 m .55453 .72884 L .55587 .73921 L F
.27041 .58134 m .25627 .58207 L .24694 .58912 L .048 0 0 r
F
.27857 .57423 m .25627 .58207 L .27041 .58134 L .053 0 0 r
F
.84205 .39704 m .82752 .39322 L .81609 .40093 L .7 .972 .925 r
F
.85471 .38954 m .82752 .39322 L .84205 .39704 L .681 .967 .929 r
F
.48323 .20946 m .45898 .21111 L .45633 .1975 L .61 .564 .778 r
F
.48494 .22268 m .45898 .21111 L .48323 .20946 L .61 .567 .781 r
F
.58503 .22357 m .56232 .20902 L .58734 .21041 L .77 .696 .781 r
F
.58503 .22357 m .56098 .22227 L .56232 .20902 L F
.55319 .71898 m .53406 .72895 L .55453 .72884 L .727 .49 .568 r
F
.55319 .71898 m .53373 .71908 L .53406 .72895 L F
.82025 .59628 m .81712 .60286 L .83131 .60335 L .634 .071 0 r
F
.82025 .59628 m .80641 .5957 L .81712 .60286 L F
.49145 .73912 m .47165 .73879 L .46899 .74962 L .601 .389 .566 r
F
.49316 .72876 m .47165 .73879 L .49145 .73912 L .6 .385 .56 r
F
.51064 .23459 m .48665 .23539 L .48494 .22268 L .655 .603 .784 r
F
.51135 .24685 m .48665 .23539 L .51064 .23459 L .655 .605 .787 r
F
.63059 .79653 m .61412 .81094 L .63458 .80977 L .85 .595 .553 r
F
.63059 .79653 m .61088 .79757 L .61412 .81094 L F
.53497 .24673 m .51135 .24685 L .51064 .23459 L .695 .636 .786 r
F
.42935 .82438 m .40966 .82297 L .4054 .83719 L .466 .283 .548 r
F
.43291 .81053 m .40966 .82297 L .42935 .82438 L .466 .28 .543 r
F
.61957 .17043 m .59663 .15265 L .62277 .15539 L .81 .724 .77 r
F
.61957 .17043 m .5943 .16787 L .59663 .15265 L F
.67401 .88145 m .65881 .90018 L .67866 .89761 L .901 .639 .533 r
F
.67401 .88145 m .65474 .88379 L .65881 .90018 L F
.44566 .1379 m .41999 .14115 L .41649 .12518 L .554 .514 .765 r
F
.44834 .15357 m .41999 .14115 L .44566 .1379 L .554 .516 .768 r
F
.53497 .24673 m .51064 .23459 L .53529 .23446 L .695 .636 .786 r
F
.2307 .39259 m .22679 .40388 L .24204 .40035 L .189 .548 .93 r
F
.2307 .39259 m .21504 .39638 L .22679 .40388 L F
.51404 .71905 m .49316 .72876 L .51334 .72892 L .647 .424 .566 r
F
.53373 .71908 m .51404 .71905 L .51334 .72892 L .689 .46 .57 r
F
.46365 .77282 m .4435 .77211 L .43998 .7844 L .543 .345 .562 r
F
.46633 .76096 m .4435 .77211 L .46365 .77282 L .543 .341 .557 r
F
.26143 .58846 m .24694 .58912 L .23676 .59618 L .044 0 0 r
F
.27041 .58134 m .24694 .58912 L .26143 .58846 L .048 0 0 r
F
.53373 .71908 m .51334 .72892 L .53406 .72895 L .689 .46 .57 r
F
.60121 .76059 m .58325 .77303 L .60442 .7724 L .806 .56 .566 r
F
.60121 .76059 m .58092 .76114 L .58325 .77303 L F
.55964 .23501 m .53561 .22168 L .56098 .22227 L .733 .665 .783 r
F
.55964 .23501 m .53529 .23446 L .53561 .22168 L F
.85471 .38954 m .83979 .38544 L .82752 .39322 L .681 .967 .929 r
F
.86822 .38198 m .83979 .38544 L .85471 .38954 L .663 .962 .933 r
F
.48151 .19572 m .45633 .1975 L .45367 .18337 L .61 .562 .776 r
F
.48323 .20946 m .45633 .1975 L .48151 .19572 L .61 .564 .778 r
F
.51334 .72892 m .49316 .72876 L .49145 .73912 L .648 .429 .572 r
F
.58734 .21041 m .56367 .19525 L .58965 .19674 L .77 .694 .778 r
F
.58734 .21041 m .56232 .20902 L .56367 .19525 L F
.57628 .73893 m .55722 .7501 L .57859 .74978 L .766 .526 .571 r
F
.57628 .73893 m .55587 .73921 L .55722 .7501 L F
.83131 .60335 m .82866 .61004 L .84323 .61044 L .606 .036 0 r
F
.83131 .60335 m .81712 .60286 L .82866 .61004 L F
.63458 .80977 m .61738 .82484 L .63858 .82353 L .851 .599 .557 r
F
.63458 .80977 m .61412 .81094 L .61738 .82484 L F
.50993 .22182 m .48494 .22268 L .48323 .20946 L .656 .6 .781 r
F
.51064 .23459 m .48494 .22268 L .50993 .22182 L .655 .603 .784 r
F
.62277 .15539 m .59897 .13692 L .62598 .13984 L .81 .723 .768 r
F
.62277 .15539 m .59663 .15265 L .59897 .13692 L F
.44298 .12171 m .41649 .12518 L .41297 .10869 L .553 .512 .763 r
F
.44566 .1379 m .41649 .12518 L .44298 .12171 L .554 .514 .765 r
F
.55453 .72884 m .53438 .73934 L .55587 .73921 L .728 .495 .574 r
F
.55453 .72884 m .53406 .72895 L .53438 .73934 L F
.42578 .83876 m .4054 .83719 L .40114 .85192 L .466 .286 .551 r
F
.42935 .82438 m .4054 .83719 L .42578 .83876 L .466 .283 .548 r
F
.48973 .75 m .46899 .74962 L .46633 .76096 L .601 .394 .572 r
F
.49145 .73912 m .46899 .74962 L .48973 .75 L .601 .389 .566 r
F
.53529 .23446 m .51064 .23459 L .50993 .22182 L .695 .634 .783 r
F
.21852 .38476 m .21504 .39638 L .2307 .39259 L .19 .56 .935 r
F
.21852 .38476 m .20243 .38884 L .21504 .39638 L F
.33352 .49483 m .31686 .49629 L .31721 .50342 L .3 .256 .64 r
F
.33248 .48759 m .31686 .49629 L .33352 .49483 L .304 .296 .685 r
F
.33248 .48759 m .31574 .48914 L .31686 .49629 L F
.33385 .50203 m .31721 .50342 L .3168 .51053 L .295 .214 .591 r
F
.33352 .49483 m .31721 .50342 L .33385 .50203 L .3 .256 .64 r
F
.33073 .48032 m .31574 .48914 L .33248 .48759 L .307 .334 .726 r
F
.33073 .48032 m .31387 .48196 L .31574 .48914 L F
.53529 .23446 m .50993 .22182 L .53561 .22168 L .695 .634 .783 r
F
.25164 .59561 m .23676 .59618 L .22574 .60327 L .04 0 0 r
F
.26143 .58846 m .23676 .59618 L .25164 .59561 L .044 0 0 r
F
.33347 .50922 m .3168 .51053 L .31564 .51762 L .289 .171 .54 r
F
.33385 .50203 m .3168 .51053 L .33347 .50922 L .295 .214 .591 r
F
.46097 .7852 m .43998 .7844 L .43645 .79721 L .544 .349 .567 r
F
.46365 .77282 m .43998 .7844 L .46097 .7852 L .543 .345 .562 r
F
.32828 .47302 m .31387 .48196 L .33073 .48032 L .308 .369 .762 r
F
.32828 .47302 m .31123 .47475 L .31387 .48196 L F
.47979 .18146 m .45367 .18337 L .45101 .16873 L .61 .56 .773 r
F
.48151 .19572 m .45367 .18337 L .47979 .18146 L .61 .562 .776 r
F
.86822 .38198 m .85292 .37758 L .83979 .38544 L .663 .962 .933 r
F
.56098 .22227 m .53594 .20839 L .56232 .20902 L .733 .663 .781 r
F
.56098 .22227 m .53561 .22168 L .53594 .20839 L F
.58965 .19674 m .56502 .18097 L .59197 .18256 L .771 .692 .776 r
F
.58965 .19674 m .56367 .19525 L .56502 .18097 L F
.33238 .51638 m .31564 .51762 L .31371 .52471 L .282 .127 .486 r
F
.33347 .50922 m .31564 .51762 L .33238 .51638 L .289 .171 .54 r
F
.51334 .72892 m .49145 .73912 L .51263 .73931 L .648 .429 .572 r
F
.53406 .72895 m .51334 .72892 L .51263 .73931 L .689 .465 .576 r
F
.60442 .7724 m .5856 .78544 L .60764 .78472 L .807 .564 .57 r
F
.60442 .7724 m .58325 .77303 L .5856 .78544 L F
.32511 .46567 m .31123 .47475 L .32828 .47302 L .309 .402 .795 r
F
.32511 .46567 m .30782 .46752 L .31123 .47475 L F
.44298 .12171 m .41297 .10869 L .44029 .10501 L .553 .512 .763 r
F
.53406 .72895 m .51263 .73931 L .53438 .73934 L .689 .465 .576 r
F
.62598 .13984 m .60132 .12067 L .62919 .12378 L .811 .721 .766 r
F
.62598 .13984 m .59897 .13692 L .60132 .12067 L F
.84323 .61044 m .84106 .61726 L .85602 .61755 L .58 .004 0 r
F
.84323 .61044 m .82866 .61004 L .84106 .61726 L F
.51263 .73931 m .49145 .73912 L .48973 .75 L .649 .433 .577 r
F
.33058 .52353 m .31371 .52471 L .31101 .53178 L .274 .083 .43 r
F
.33238 .51638 m .31371 .52471 L .33058 .52353 L .282 .127 .486 r
F
.63858 .82353 m .62066 .83927 L .6426 .83781 L .852 .602 .561 r
F
.63858 .82353 m .61738 .82484 L .62066 .83927 L F
.57859 .74978 m .55858 .76151 L .58092 .76114 L .767 .531 .577 r
F
.57859 .74978 m .55722 .7501 L .55858 .76151 L F
.50922 .20853 m .48323 .20946 L .48151 .19572 L .656 .598 .778 r
F
.50993 .22182 m .48323 .20946 L .50922 .20853 L .656 .6 .781 r
F
.4222 .85367 m .40114 .85192 L .39686 .86718 L .466 .288 .555 r
F
.42578 .83876 m .40114 .85192 L .4222 .85367 L .466 .286 .551 r
F
.32122 .45828 m .30782 .46752 L .32511 .46567 L .309 .432 .824 r
F
.32122 .45828 m .30365 .46024 L .30782 .46752 L F
.53561 .22168 m .50993 .22182 L .50922 .20853 L .696 .631 .78 r
F
.20549 .37685 m .20243 .38884 L .21852 .38476 L .192 .571 .938 r
F
.20549 .37685 m .18895 .38123 L .20243 .38884 L F
.488 .7614 m .46633 .76096 L .46365 .77282 L .602 .397 .577 r
F
.48973 .75 m .46633 .76096 L .488 .7614 L .601 .394 .572 r
F
.32807 .53066 m .31101 .53178 L .30755 .53885 L .266 .041 .374 r
F
.33058 .52353 m .31101 .53178 L .32807 .53066 L .274 .083 .43 r
F
.55587 .73921 m .53471 .75024 L .55722 .7501 L .729 .499 .58 r
F
.55587 .73921 m .53438 .73934 L .53471 .75024 L F
.47806 .16669 m .45101 .16873 L .44834 .15357 L .61 .558 .771 r
F
.47979 .18146 m .45101 .16873 L .47806 .16669 L .61 .56 .773 r
F
.24102 .60278 m .22574 .60327 L .21386 .61037 L .037 0 0 r
F
.25164 .59561 m .22574 .60327 L .24102 .60278 L .04 0 0 r
F
.53561 .22168 m .50922 .20853 L .53594 .20839 L .696 .631 .78 r
F
.31661 .45084 m .30365 .46024 L .32122 .45828 L .309 .459 .848 r
F
.31661 .45084 m .29871 .45293 L .30365 .46024 L F
.45827 .79811 m .43645 .79721 L .43291 .81053 L .544 .352 .571 r
F
.46097 .7852 m .43645 .79721 L .45827 .79811 L .544 .349 .567 r
F
.59197 .18256 m .56638 .16616 L .5943 .16787 L .771 .69 .773 r
F
.59197 .18256 m .56502 .18097 L .56638 .16616 L F
.56232 .20902 m .53626 .19457 L .56367 .19525 L .733 .661 .778 r
F
.56232 .20902 m .53594 .20839 L .53626 .19457 L F
.62919 .12378 m .60367 .10389 L .63241 .1072 L .811 .72 .764 r
F
.62919 .12378 m .60132 .12067 L .60367 .10389 L F
.60764 .78472 m .58796 .79838 L .61088 .79757 L .808 .568 .575 r
F
.60764 .78472 m .5856 .78544 L .58796 .79838 L F
.32485 .53779 m .30755 .53885 L .30331 .54592 L .256 0 .318 r
F
.32807 .53066 m .30755 .53885 L .32485 .53779 L .266 .041 .374 r
F
.51263 .73931 m .48973 .75 L .51191 .75021 L .649 .433 .577 r
F
.53438 .73934 m .51263 .73931 L .51191 .75021 L .69 .469 .582 r
F
.6426 .83781 m .62394 .85423 L .64663 .85261 L .853 .606 .565 r
F
.6426 .83781 m .62066 .83927 L .62394 .85423 L F
.85602 .61755 m .85433 .6245 L .86968 .62469 L .556 0 0 r
F
.85602 .61755 m .84106 .61726 L .85433 .6245 L F
.4186 .86911 m .39686 .86718 L .39256 .88296 L .466 .291 .558 r
F
.4222 .85367 m .39686 .86718 L .4186 .86911 L .466 .288 .555 r
F
.50851 .19473 m .48151 .19572 L .47979 .18146 L .656 .596 .775 r
F
.50922 .20853 m .48151 .19572 L .50851 .19473 L .656 .598 .778 r
F
.31128 .44335 m .29871 .45293 L .31661 .45084 L .308 .484 .869 r
F
.31128 .44335 m .29299 .44557 L .29871 .45293 L F
.53438 .73934 m .51191 .75021 L .53471 .75024 L .69 .469 .582 r
F
.51191 .75021 m .48973 .75 L .488 .7614 L .649 .437 .583 r
F
.58092 .76114 m .55994 .77345 L .58325 .77303 L .768 .535 .582 r
F
.58092 .76114 m .55858 .76151 L .55994 .77345 L F
.47633 .1514 m .44834 .15357 L .44566 .1379 L .61 .556 .769 r
F
.47806 .16669 m .44834 .15357 L .47633 .1514 L .61 .558 .771 r
F
.53594 .20839 m .50922 .20853 L .50851 .19473 L .696 .629 .778 r
F
.32091 .54492 m .30331 .54592 L .2983 .55299 L .247 0 .263 r
F
.32485 .53779 m .30331 .54592 L .32091 .54492 L .256 0 .318 r
F
.48626 .77332 m .46365 .77282 L .46097 .7852 L .602 .401 .581 r
F
.488 .7614 m .46365 .77282 L .48626 .77332 L .602 .397 .577 r
F
.5943 .16787 m .56775 .15083 L .59663 .15265 L .772 .688 .771 r
F
.5943 .16787 m .56638 .16616 L .56775 .15083 L F
.53594 .20839 m .50851 .19473 L .53626 .19457 L .696 .629 .778 r
F
.22956 .60998 m .21386 .61037 L .20112 .6175 L .035 0 0 r
F
.24102 .60278 m .21386 .61037 L .22956 .60998 L .037 0 0 r
F
.45556 .81155 m .43291 .81053 L .42935 .82438 L .544 .355 .575 r
F
.45827 .79811 m .43291 .81053 L .45556 .81155 L .544 .352 .571 r
F
.56367 .19525 m .53659 .18024 L .56502 .18097 L .734 .659 .775 r
F
.56367 .19525 m .53626 .19457 L .53659 .18024 L F
.55722 .7501 m .53503 .76168 L .55858 .76151 L .729 .504 .585 r
F
.55722 .7501 m .53471 .75024 L .53503 .76168 L F
.30521 .4358 m .29299 .44557 L .31128 .44335 L .306 .506 .888 r
F
.30521 .4358 m .28649 .43817 L .29299 .44557 L F
.61088 .79757 m .59032 .81185 L .61412 .81094 L .809 .571 .579 r
F
.61088 .79757 m .58796 .79838 L .59032 .81185 L F
.41499 .88509 m .39256 .88296 L .38825 .89926 L .466 .293 .562 r
F
.4186 .86911 m .39256 .88296 L .41499 .88509 L .466 .291 .558 r
F
.64663 .85261 m .62724 .86974 L .65068 .86794 L .853 .609 .568 r
F
.64663 .85261 m .62394 .85423 L .62724 .86974 L F
.5078 .1804 m .47979 .18146 L .47806 .16669 L .656 .594 .773 r
F
.50851 .19473 m .47979 .18146 L .5078 .1804 L .656 .596 .775 r
F
.31624 .55205 m .2983 .55299 L .29252 .56006 L .237 0 .21 r
F
.32091 .54492 m .2983 .55299 L .31624 .55205 L .247 0 .263 r
F
.47459 .13558 m .44566 .1379 L .44298 .12171 L .61 .554 .766 r
F
.47633 .1514 m .44566 .1379 L .47459 .13558 L .61 .556 .769 r
F
.51191 .75021 m .488 .7614 L .5112 .76164 L .649 .437 .583 r
F
.53471 .75024 m .51191 .75021 L .5112 .76164 L .691 .473 .587 r
F
.53626 .19457 m .50851 .19473 L .5078 .1804 L .696 .627 .775 r
F
.5112 .76164 m .488 .7614 L .48626 .77332 L .65 .441 .587 r
F
.58325 .77303 m .56131 .78592 L .5856 .78544 L .768 .539 .586 r
F
.58325 .77303 m .55994 .77345 L .56131 .78592 L F
.29841 .42818 m .28649 .43817 L .30521 .4358 L .305 .526 .903 r
F
.29841 .42818 m .2792 .43072 L .28649 .43817 L F
.53471 .75024 m .5112 .76164 L .53503 .76168 L .691 .473 .587 r
F
.59663 .15265 m .56911 .13497 L .59897 .13692 L .772 .686 .769 r
F
.59663 .15265 m .56775 .15083 L .56911 .13497 L F
.53626 .19457 m .5078 .1804 L .53659 .18024 L .696 .627 .775 r
F
.48452 .78577 m .46097 .7852 L .45827 .79811 L .603 .404 .585 r
F
.48626 .77332 m .46097 .7852 L .48452 .78577 L .602 .401 .581 r
F
.45284 .82552 m .42935 .82438 L .42578 .83876 L .545 .358 .578 r
F
.45556 .81155 m .42935 .82438 L .45284 .82552 L .544 .355 .575 r
F
.56502 .18097 m .53692 .16538 L .56638 .16616 L .734 .657 .773 r
F
.56502 .18097 m .53659 .18024 L .53692 .16538 L F
.21726 .61721 m .20112 .6175 L .1875 .62466 L .033 0 0 r
F
.22956 .60998 m .20112 .6175 L .21726 .61721 L .035 0 0 r
F
.41499 .88509 m .38825 .89926 L .41137 .90161 L .466 .293 .562 r
F
.31084 .55918 m .29252 .56006 L .28594 .56714 L .227 0 .158 r
F
.31624 .55205 m .29252 .56006 L .31084 .55918 L .237 0 .21 r
F
.65068 .86794 m .63056 .88578 L .65474 .88379 L .854 .612 .571 r
F
.65068 .86794 m .62724 .86974 L .63056 .88578 L F
.55858 .76151 m .53536 .77364 L .55994 .77345 L .73 .507 .589 r
F
.55858 .76151 m .53503 .76168 L .53536 .77364 L F
.61412 .81094 m .5927 .82586 L .61738 .82484 L .809 .574 .583 r
F
.61412 .81094 m .59032 .81185 L .5927 .82586 L F
.50708 .16556 m .47806 .16669 L .47633 .1514 L .656 .592 .771 r
F
.5078 .1804 m .47806 .16669 L .50708 .16556 L .656 .594 .773 r
F
.47284 .11924 m .44298 .12171 L .44029 .10501 L .61 .552 .764 r
F
.47459 .13558 m .44298 .12171 L .47284 .11924 L .61 .554 .766 r
F
.29086 .4205 m .2792 .43072 L .29841 .42818 L .303 .543 .916 r
F
.29086 .4205 m .27112 .42322 L .2792 .43072 L F
.59897 .13692 m .57048 .11859 L .60132 .12067 L .772 .685 .767 r
F
.59897 .13692 m .56911 .13497 L .57048 .11859 L F
.53659 .18024 m .5078 .1804 L .50708 .16556 L .697 .625 .773 r
F
.5112 .76164 m .48626 .77332 L .51048 .7736 L .65 .441 .587 r
F
.53503 .76168 m .5112 .76164 L .51048 .7736 L .692 .477 .591 r
F
.5856 .78544 m .56268 .79892 L .58796 .79838 L .769 .542 .59 r
F
.5856 .78544 m .56131 .78592 L .56268 .79892 L F
.53659 .18024 m .50708 .16556 L .53692 .16538 L .697 .625 .773 r
F
.51048 .7736 m .48626 .77332 L .48452 .78577 L .65 .444 .592 r
F
.56638 .16616 m .53725 .14999 L .56775 .15083 L .735 .655 .771 r
F
.56638 .16616 m .53692 .16538 L .53725 .14999 L F
.53503 .76168 m .51048 .7736 L .53536 .77364 L .692 .477 .591 r
F
.4501 .84002 m .42578 .83876 L .4222 .85367 L .545 .36 .582 r
F
.45284 .82552 m .42578 .83876 L .4501 .84002 L .545 .358 .578 r
F
.3047 .56632 m .28594 .56714 L .27857 .57423 L .217 0 .11 r
F
.31084 .55918 m .28594 .56714 L .3047 .56632 L .227 0 .158 r
F
.48277 .79875 m .45827 .79811 L .45556 .81155 L .603 .407 .589 r
F
.48452 .78577 m .45827 .79811 L .48277 .79875 L .603 .404 .585 r
F
.21726 .61721 m .1875 .62466 L .20409 .62447 L .033 0 0 r
F
.65474 .88379 m .63389 .90237 L .65881 .90018 L .855 .614 .574 r
F
.65474 .88379 m .63056 .88578 L .63389 .90237 L F
.47284 .11924 m .44029 .10501 L .47109 .10237 L .61 .552 .764 r
F
.50636 .15019 m .47633 .1514 L .47459 .13558 L .656 .59 .769 r
F
.50708 .16556 m .47633 .1514 L .50636 .15019 L .656 .592 .771 r
F
.61738 .82484 m .59509 .84041 L .62066 .83927 L .81 .577 .586 r
F
.61738 .82484 m .5927 .82586 L .59509 .84041 L F
.28255 .41274 m .27112 .42322 L .29086 .4205 L .301 .559 .926 r
F
.28255 .41274 m .26224 .41566 L .27112 .42322 L F
.55994 .77345 m .53569 .78614 L .56131 .78592 L .731 .511 .594 r
F
.55994 .77345 m .53536 .77364 L .53569 .78614 L F
.60132 .12067 m .57186 .10168 L .60367 .10389 L .773 .683 .765 r
F
.60132 .12067 m .57048 .11859 L .57186 .10168 L F
.53692 .16538 m .50708 .16556 L .50636 .15019 L .697 .624 .771 r
F
.53692 .16538 m .50636 .15019 L .53725 .14999 L F
.56775 .15083 m .53758 .13408 L .56911 .13497 L .735 .653 .769 r
F
.56775 .15083 m .53725 .14999 L .53758 .13408 L F
.29782 .57347 m .27857 .57423 L .27041 .58134 L .208 0 .064 r
F
.3047 .56632 m .27857 .57423 L .29782 .57347 L .217 0 .11 r
F
.44736 .85507 m .4222 .85367 L .4186 .86911 L .545 .363 .585 r
F
.4501 .84002 m .4222 .85367 L .44736 .85507 L .545 .36 .582 r
F
.58796 .79838 m .56406 .81246 L .59032 .81185 L .77 .545 .594 r
F
.58796 .79838 m .56268 .79892 L .56406 .81246 L F
.51048 .7736 m .48452 .78577 L .50976 .78609 L .65 .444 .592 r
F
.53536 .77364 m .51048 .7736 L .50976 .78609 L .692 .48 .595 r
F
.50976 .78609 m .48452 .78577 L .48277 .79875 L .651 .448 .596 r
F
.50564 .13429 m .47459 .13558 L .47284 .11924 L .656 .588 .767 r
F
.50636 .15019 m .47459 .13558 L .50564 .13429 L .656 .59 .769 r
F
.48101 .81227 m .45556 .81155 L .45284 .82552 L .603 .41 .593 r
F
.48277 .79875 m .45556 .81155 L .48101 .81227 L .603 .407 .589 r
F
.53536 .77364 m .50976 .78609 L .53569 .78614 L .692 .48 .595 r
F
.27347 .4049 m .26224 .41566 L .28255 .41274 L .299 .573 .935 r
F
.27347 .4049 m .25255 .40803 L .26224 .41566 L F
.62066 .83927 m .59749 .8555 L .62394 .85423 L .81 .58 .59 r
F
.62066 .83927 m .59509 .84041 L .59749 .8555 L F
.53725 .14999 m .50636 .15019 L .50564 .13429 L .697 .622 .769 r
F
.56131 .78592 m .53602 .79917 L .56268 .79892 L .731 .514 .598 r
F
.56131 .78592 m .53569 .78614 L .53602 .79917 L F
.35448 .49349 m .33352 .49483 L .33385 .50203 L .41 .342 .67 r
F
.35355 .48617 m .33352 .49483 L .35448 .49349 L .412 .376 .708 r
F
.35355 .48617 m .33248 .48759 L .33352 .49483 L F
.35478 .50076 m .33385 .50203 L .33347 .50922 L .407 .307 .629 r
F
.35448 .49349 m .33385 .50203 L .35478 .50076 L .41 .342 .67 r
F
.35197 .47882 m .33248 .48759 L .35355 .48617 L .413 .407 .744 r
F
.35197 .47882 m .33073 .48032 L .33248 .48759 L F
.35444 .50801 m .33347 .50922 L .33238 .51638 L .402 .271 .586 r
F
.35478 .50076 m .33347 .50922 L .35444 .50801 L .407 .307 .629 r
F
.56911 .13497 m .53791 .11764 L .57048 .11859 L .735 .652 .767 r
F
.56911 .13497 m .53758 .13408 L .53791 .11764 L F
.53725 .14999 m .50564 .13429 L .53758 .13408 L .697 .622 .769 r
F
.29019 .58065 m .27041 .58134 L .26143 .58846 L .199 0 .021 r
F
.29782 .57347 m .27041 .58134 L .29019 .58065 L .208 0 .064 r
F
.34976 .47143 m .33073 .48032 L .35197 .47882 L .413 .437 .776 r
F
.34976 .47143 m .32828 .47302 L .33073 .48032 L F
.4446 .87067 m .4186 .86911 L .41499 .88509 L .545 .365 .588 r
F
.44736 .85507 m .4186 .86911 L .4446 .87067 L .545 .363 .585 r
F
.35346 .51524 m .33238 .51638 L .33058 .52353 L .397 .234 .54 r
F
.35444 .50801 m .33238 .51638 L .35346 .51524 L .402 .271 .586 r
F
.50491 .11786 m .47284 .11924 L .47109 .10237 L .656 .587 .765 r
F
.50564 .13429 m .47284 .11924 L .50491 .11786 L .656 .588 .767 r
F
.59032 .81185 m .56545 .82654 L .5927 .82586 L .77 .548 .597 r
F
.59032 .81185 m .56406 .81246 L .56545 .82654 L F
.34691 .46399 m .32828 .47302 L .34976 .47143 L .412 .464 .805 r
F
.34691 .46399 m .32511 .46567 L .32828 .47302 L F
.50976 .78609 m .48277 .79875 L .50903 .79911 L .651 .448 .596 r
F
.53569 .78614 m .50976 .78609 L .50903 .79911 L .693 .483 .599 r
F
.50903 .79911 m .48277 .79875 L .48101 .81227 L .651 .451 .599 r
F
.26363 .39698 m .25255 .40803 L .27347 .4049 L .297 .586 .943 r
F
.26363 .39698 m .24204 .40035 L .25255 .40803 L F
.47924 .82633 m .45284 .82552 L .4501 .84002 L .604 .413 .596 r
F
.48101 .81227 m .45284 .82552 L .47924 .82633 L .603 .41 .593 r
F
.35184 .52245 m .33058 .52353 L .32807 .53066 L .39 .196 .493 r
F
.35346 .51524 m .33058 .52353 L .35184 .52245 L .397 .234 .54 r
F
.53569 .78614 m .50903 .79911 L .53602 .79917 L .693 .483 .599 r
F
.62394 .85423 m .59989 .87114 L .62724 .86974 L .811 .583 .593 r
F
.62394 .85423 m .59749 .8555 L .59989 .87114 L F
.53758 .13408 m .50564 .13429 L .50491 .11786 L .697 .62 .767 r
F
.3434 .45649 m .32511 .46567 L .34691 .46399 L .41 .49 .831 r
F
.3434 .45649 m .32122 .45828 L .32511 .46567 L F
.57048 .11859 m .53824 .10066 L .57186 .10168 L .735 .65 .765 r
F
.57048 .11859 m .53791 .11764 L .53824 .10066 L F
.53758 .13408 m .50491 .11786 L .53791 .11764 L .697 .62 .767 r
F
.34958 .52964 m .32807 .53066 L .32485 .53779 L .382 .159 .446 r
F
.35184 .52245 m .32807 .53066 L .34958 .52964 L .39 .196 .493 r
F
.56268 .79892 m .53636 .81274 L .56406 .81246 L .732 .517 .601 r
F
.56268 .79892 m .53602 .79917 L .53636 .81274 L F
.28179 .58784 m .26143 .58846 L .25164 .59561 L .191 0 0 r
F
.29019 .58065 m .26143 .58846 L .28179 .58784 L .199 0 .021 r
F
.50491 .11786 m .47109 .10237 L .50419 .10089 L .656 .587 .765 r
F
.44183 .88681 m .41499 .88509 L .41137 .90161 L .545 .367 .591 r
F
.4446 .87067 m .41499 .88509 L .44183 .88681 L .545 .365 .588 r
F
.33925 .44893 m .32122 .45828 L .3434 .45649 L .408 .513 .853 r
F
.33925 .44893 m .31661 .45084 L .32122 .45828 L F
.5927 .82586 m .56684 .84117 L .59509 .84041 L .771 .551 .601 r
F
.5927 .82586 m .56545 .82654 L .56684 .84117 L F
.34667 .53682 m .32485 .53779 L .32091 .54492 L .374 .121 .397 r
F
.34958 .52964 m .32485 .53779 L .34667 .53682 L .382 .159 .446 r
F
.25299 .38897 m .24204 .40035 L .26363 .39698 L .295 .598 .949 r
F
.25299 .38897 m .2307 .39259 L .24204 .40035 L F
.47747 .84093 m .4501 .84002 L .44736 .85507 L .604 .415 .599 r
F
.47924 .82633 m .4501 .84002 L .47747 .84093 L .604 .413 .596 r
F
.5083 .81267 m .48101 .81227 L .47924 .82633 L .651 .453 .603 r
F
.50903 .79911 m .48101 .81227 L .5083 .81267 L .651 .451 .599 r
F
.53602 .79917 m .50903 .79911 L .5083 .81267 L .693 .486 .603 r
F
.62724 .86974 m .60231 .88733 L .63056 .88578 L .812 .585 .595 r
F
.62724 .86974 m .59989 .87114 L .60231 .88733 L F
.53791 .11764 m .50491 .11786 L .50419 .10089 L .697 .619 .765 r
F
.53602 .79917 m .5083 .81267 L .53636 .81274 L .693 .486 .603 r
F
.53791 .11764 m .50419 .10089 L .53824 .10066 L .697 .619 .765 r
F
.33443 .44131 m .31661 .45084 L .33925 .44893 L .405 .534 .874 r
F
.33443 .44131 m .31128 .44335 L .31661 .45084 L F
.34312 .544 m .32091 .54492 L .31624 .55205 L .365 .085 .349 r
F
.34667 .53682 m .32091 .54492 L .34312 .544 L .374 .121 .397 r
F
.56406 .81246 m .53669 .82685 L .56545 .82654 L .732 .52 .605 r
F
.56406 .81246 m .53636 .81274 L .53669 .82685 L F
.44183 .88681 m .41137 .90161 L .43905 .9035 L .545 .367 .591 r
F
.27262 .59506 m .25164 .59561 L .24102 .60278 L .182 0 0 r
F
.28179 .58784 m .25164 .59561 L .27262 .59506 L .191 0 0 r
F
.59509 .84041 m .56825 .85634 L .59749 .8555 L .771 .553 .604 r
F
.59509 .84041 m .56684 .84117 L .56825 .85634 L F
.32896 .43361 m .31128 .44335 L .33443 .44131 L .402 .553 .891 r
F
.32896 .43361 m .30521 .4358 L .31128 .44335 L F
.47569 .85608 m .44736 .85507 L .4446 .87067 L .604 .417 .602 r
F
.47747 .84093 m .44736 .85507 L .47569 .85608 L .604 .415 .599 r
F
.63056 .88578 m .60474 .90407 L .63389 .90237 L .812 .588 .598 r
F
.63056 .88578 m .60231 .88733 L .60474 .90407 L F
.24155 .38087 m .2307 .39259 L .25299 .38897 L .293 .608 .954 r
F
.24155 .38087 m .21852 .38476 L .2307 .39259 L F
.50757 .82678 m .47924 .82633 L .47747 .84093 L .652 .456 .606 r
F
.5083 .81267 m .47924 .82633 L .50757 .82678 L .651 .453 .603 r
F
.53636 .81274 m .5083 .81267 L .50757 .82678 L .693 .489 .606 r
F
.33891 .55118 m .31624 .55205 L .31084 .55918 L .355 .049 .302 r
F
.34312 .544 m .31624 .55205 L .33891 .55118 L .365 .085 .349 r
F
.53636 .81274 m .50757 .82678 L .53669 .82685 L .693 .489 .606 r
F
.56545 .82654 m .53703 .84152 L .56684 .84117 L .733 .523 .608 r
F
.56545 .82654 m .53669 .82685 L .53703 .84152 L F
.26267 .60231 m .24102 .60278 L .22956 .60998 L .175 0 0 r
F
.27262 .59506 m .24102 .60278 L .26267 .60231 L .182 0 0 r
F
.32281 .42584 m .30521 .4358 L .32896 .43361 L .398 .571 .906 r
F
.32281 .42584 m .29841 .42818 L .30521 .4358 L F
.59749 .8555 m .56965 .87207 L .59989 .87114 L .772 .556 .606 r
F
.59749 .8555 m .56825 .85634 L .56965 .87207 L F
.33404 .55837 m .31084 .55918 L .3047 .56632 L .345 .015 .256 r
F
.33891 .55118 m .31084 .55918 L .33404 .55837 L .355 .049 .302 r
F
.4739 .87178 m .4446 .87067 L .44183 .88681 L .604 .419 .605 r
F
.47569 .85608 m .4446 .87067 L .4739 .87178 L .604 .417 .602 r
F
.50683 .84144 m .47747 .84093 L .47569 .85608 L .652 .458 .609 r
F
.50757 .82678 m .47747 .84093 L .50683 .84144 L .652 .456 .606 r
F
.2293 .37267 m .21852 .38476 L .24155 .38087 L .292 .617 .958 r
F
.2293 .37267 m .20549 .37685 L .21852 .38476 L F
.53669 .82685 m .50757 .82678 L .50683 .84144 L .694 .492 .609 r
F
.53669 .82685 m .50683 .84144 L .53703 .84152 L F
.31598 .41799 m .29841 .42818 L .32281 .42584 L .394 .586 .919 r
F
.31598 .41799 m .29086 .4205 L .29841 .42818 L F
.56684 .84117 m .53737 .85673 L .56825 .85634 L .733 .525 .611 r
F
.56684 .84117 m .53703 .84152 L .53737 .85673 L F
.3285 .56556 m .3047 .56632 L .29782 .57347 L .334 0 .211 r
F
.33404 .55837 m .3047 .56632 L .3285 .56556 L .345 .015 .256 r
F
.25192 .6096 m .22956 .60998 L .21726 .61721 L .168 0 0 r
F
.26267 .60231 m .22956 .60998 L .25192 .6096 L .175 0 0 r
F
.59989 .87114 m .57107 .88836 L .60231 .88733 L .772 .558 .609 r
F
.59989 .87114 m .56965 .87207 L .57107 .88836 L F
.4721 .88804 m .44183 .88681 L .43905 .9035 L .604 .421 .607 r
F
.4739 .87178 m .44183 .88681 L .4721 .88804 L .604 .419 .605 r
F
.37939 .4923 m .35448 .49349 L .35478 .50076 L .488 .404 .687 r
F
.37859 .48492 m .35448 .49349 L .37939 .4923 L .489 .433 .721 r
F
.37859 .48492 m .35355 .48617 L .35448 .49349 L F
.37965 .49965 m .35478 .50076 L .35444 .50801 L .486 .374 .651 r
F
.37939 .4923 m .35478 .50076 L .37965 .49965 L .488 .404 .687 r
F
.37723 .4775 m .35355 .48617 L .37859 .48492 L .489 .461 .752 r
F
.37723 .4775 m .35197 .47882 L .35355 .48617 L F
.37935 .50695 m .35444 .50801 L .35346 .51524 L .483 .342 .613 r
F
.37965 .49965 m .35444 .50801 L .37935 .50695 L .486 .374 .651 r
F
.50609 .85664 m .47569 .85608 L .4739 .87178 L .652 .46 .611 r
F
.50683 .84144 m .47569 .85608 L .50609 .85664 L .652 .458 .609 r
F
.53703 .84152 m .50683 .84144 L .50609 .85664 L .694 .494 .612 r
F
.37532 .47002 m .35197 .47882 L .37723 .4775 L .489 .486 .781 r
F
.37532 .47002 m .34976 .47143 L .35197 .47882 L F
.37851 .51423 m .35346 .51524 L .35184 .52245 L .478 .31 .574 r
F
.37935 .50695 m .35346 .51524 L .37851 .51423 L .483 .342 .613 r
F
.30847 .41005 m .29086 .4205 L .31598 .41799 L .39 .6 .93 r
F
.30847 .41005 m .28255 .41274 L .29086 .4205 L F
.53703 .84152 m .50609 .85664 L .53737 .85673 L .694 .494 .612 r
F
.37285 .46249 m .34976 .47143 L .37532 .47002 L .487 .51 .807 r
F
.37285 .46249 m .34691 .46399 L .34976 .47143 L F
.37711 .52149 m .35184 .52245 L .34958 .52964 L .473 .277 .533 r
F
.37851 .51423 m .35184 .52245 L .37711 .52149 L .478 .31 .574 r
F
.56825 .85634 m .53771 .8725 L .56965 .87207 L .733 .527 .613 r
F
.56825 .85634 m .53737 .85673 L .53771 .8725 L F
.32228 .57278 m .29782 .57347 L .29019 .58065 L .324 0 .168 r
F
.3285 .56556 m .29782 .57347 L .32228 .57278 L .334 0 .211 r
F
.60231 .88733 m .57249 .90521 L .60474 .90407 L .772 .56 .612 r
F
.60231 .88733 m .57107 .88836 L .57249 .90521 L F
.4721 .88804 m .43905 .9035 L .47029 .90486 L .604 .421 .607 r
F
.24036 .61693 m .21726 .61721 L .20409 .62447 L .162 0 0 r
F
.25192 .6096 m .21726 .61721 L .24036 .61693 L .168 0 0 r
F
.36982 .4549 m .34691 .46399 L .37285 .46249 L .484 .533 .831 r
F
.36982 .4549 m .3434 .45649 L .34691 .46399 L F
.37516 .52873 m .34958 .52964 L .34667 .53682 L .466 .243 .491 r
F
.37711 .52149 m .34958 .52964 L .37516 .52873 L .473 .277 .533 r
F
.50535 .8724 m .4739 .87178 L .4721 .88804 L .652 .462 .614 r
F
.50609 .85664 m .4739 .87178 L .50535 .8724 L .652 .46 .611 r
F
.53737 .85673 m .50609 .85664 L .50535 .8724 L .694 .496 .615 r
F
.30025 .40202 m .28255 .41274 L .30847 .41005 L .386 .613 .94 r
F
.30025 .40202 m .27347 .4049 L .28255 .41274 L F
.53737 .85673 m .50535 .8724 L .53771 .8725 L .694 .496 .615 r
F
.36623 .44724 m .3434 .45649 L .36982 .4549 L .481 .553 .853 r
F
.36623 .44724 m .33925 .44893 L .3434 .45649 L F
.37265 .53596 m .34667 .53682 L .34312 .544 L .458 .21 .449 r
F
.37516 .52873 m .34667 .53682 L .37265 .53596 L .466 .243 .491 r
F
.31538 .58001 m .29019 .58065 L .28179 .58784 L .314 0 .127 r
F
.32228 .57278 m .29019 .58065 L .31538 .58001 L .324 0 .168 r
F
.56965 .87207 m .53805 .88883 L .57107 .88836 L .734 .529 .616 r
F
.56965 .87207 m .53771 .8725 L .53805 .88883 L F
.5046 .88873 m .4721 .88804 L .47029 .90486 L .653 .464 .616 r
F
.50535 .8724 m .4721 .88804 L .5046 .88873 L .652 .462 .614 r
F
.36207 .4395 m .33925 .44893 L .36623 .44724 L .477 .572 .872 r
F
.36207 .4395 m .33443 .44131 L .33925 .44893 L F
.36958 .54319 m .34312 .544 L .33891 .55118 L .45 .177 .406 r
F
.37265 .53596 m .34312 .544 L .36958 .54319 L .458 .21 .449 r
F
.24036 .61693 m .20409 .62447 L .22798 .6243 L .162 0 0 r
F
.53771 .8725 m .50535 .8724 L .5046 .88873 L .695 .498 .617 r
F
.29133 .39388 m .27347 .4049 L .30025 .40202 L .382 .624 .948 r
F
.29133 .39388 m .26363 .39698 L .27347 .4049 L F
.53771 .8725 m .5046 .88873 L .53805 .88883 L .695 .498 .617 r
F
.57107 .88836 m .53839 .90573 L .57249 .90521 L .734 .531 .618 r
F
.57107 .88836 m .53805 .88883 L .53839 .90573 L F
.30779 .58727 m .28179 .58784 L .27262 .59506 L .304 0 .088 r
F
.31538 .58001 m .28179 .58784 L .30779 .58727 L .314 0 .127 r
F
.35733 .43168 m .33443 .44131 L .36207 .4395 L .473 .589 .889 r
F
.35733 .43168 m .32896 .43361 L .33443 .44131 L F
.36594 .55042 m .33891 .55118 L .33404 .55837 L .441 .144 .364 r
F
.36958 .54319 m .33891 .55118 L .36594 .55042 L .45 .177 .406 r
F
.5046 .88873 m .47029 .90486 L .50385 .90561 L .653 .464 .616 r
F
.53805 .88883 m .5046 .88873 L .50385 .90561 L .695 .5 .62 r
F
.53805 .88883 m .50385 .90561 L .53839 .90573 L F
.28168 .38564 m .26363 .39698 L .29133 .39388 L .378 .634 .955 r
F
.28168 .38564 m .25299 .38897 L .26363 .39698 L F
.35201 .42377 m .32896 .43361 L .35733 .43168 L .469 .605 .904 r
F
.35201 .42377 m .32281 .42584 L .32896 .43361 L F
.40797 .4987 m .37965 .49965 L .37935 .50695 L .546 .424 .665 r
F
.40776 .49131 m .37965 .49965 L .40797 .4987 L .548 .451 .697 r
F
.40776 .49131 m .37939 .4923 L .37965 .49965 L F
.4071 .48387 m .37939 .4923 L .40776 .49131 L .548 .477 .728 r
F
.4071 .48387 m .37859 .48492 L .37939 .4923 L F
.36173 .55765 m .33404 .55837 L .3285 .56556 L .431 .112 .322 r
F
.36594 .55042 m .33404 .55837 L .36173 .55765 L .441 .144 .364 r
F
.40773 .50606 m .37935 .50695 L .37851 .51423 L .544 .396 .631 r
F
.40797 .4987 m .37935 .50695 L .40773 .50606 L .546 .424 .665 r
F
.406 .47639 m .37859 .48492 L .4071 .48387 L .548 .502 .756 r
F
.406 .47639 m .37723 .4775 L .37859 .48492 L F
.29948 .59456 m .27262 .59506 L .26267 .60231 L .294 0 .051 r
F
.30779 .58727 m .27262 .59506 L .29948 .59456 L .304 0 .088 r
F
.40704 .51339 m .37851 .51423 L .37711 .52149 L .54 .367 .595 r
F
.40773 .50606 m .37851 .51423 L .40704 .51339 L .544 .396 .631 r
F
.40444 .46884 m .37723 .4775 L .406 .47639 L .547 .525 .783 r
F
.40444 .46884 m .37532 .47002 L .37723 .4775 L F
.4059 .52069 m .37711 .52149 L .37516 .52873 L .535 .337 .558 r
F
.40704 .51339 m .37711 .52149 L .4059 .52069 L .54 .367 .595 r
F
.40243 .46124 m .37532 .47002 L .40444 .46884 L .544 .547 .807 r
F
.40243 .46124 m .37285 .46249 L .37532 .47002 L F
.3461 .41577 m .32281 .42584 L .35201 .42377 L .464 .619 .917 r
F
.3461 .41577 m .31598 .41799 L .32281 .42584 L F
.35693 .5649 m .3285 .56556 L .32228 .57278 L .421 .081 .281 r
F
.36173 .55765 m .3285 .56556 L .35693 .5649 L .431 .112 .322 r
F
.27129 .37728 m .25299 .38897 L .28168 .38564 L .375 .643 .96 r
F
.27129 .37728 m .24155 .38087 L .25299 .38897 L F
.40431 .52797 m .37516 .52873 L .37265 .53596 L .529 .307 .521 r
F
.4059 .52069 m .37516 .52873 L .40431 .52797 L .535 .337 .558 r
F
.39997 .45356 m .37285 .46249 L .40243 .46124 L .542 .567 .83 r
F
.39997 .45356 m .36982 .4549 L .37285 .46249 L F
.29046 .60189 m .26267 .60231 L .25192 .6096 L .284 0 .017 r
F
.29948 .59456 m .26267 .60231 L .29046 .60189 L .294 0 .051 r
F
.40227 .53524 m .37265 .53596 L .36958 .54319 L .523 .276 .483 r
F
.40431 .52797 m .37265 .53596 L .40227 .53524 L .529 .307 .521 r
F
.39704 .44581 m .36982 .4549 L .39997 .45356 L .538 .586 .85 r
F
.39704 .44581 m .36623 .44724 L .36982 .4549 L F
.33958 .40767 m .31598 .41799 L .3461 .41577 L .459 .631 .928 r
F
.33958 .40767 m .30847 .41005 L .31598 .41799 L F
.35155 .57216 m .32228 .57278 L .31538 .58001 L .411 .051 .241 r
F
.35693 .5649 m .32228 .57278 L .35155 .57216 L .421 .081 .281 r
F
.26015 .3688 m .24155 .38087 L .27129 .37728 L .371 .651 .965 r
F
.26015 .3688 m .2293 .37267 L .24155 .38087 L F
.39977 .54251 m .36958 .54319 L .36594 .55042 L .515 .245 .444 r
F
.40227 .53524 m .36958 .54319 L .39977 .54251 L .523 .276 .483 r
F
.39365 .43798 m .36623 .44724 L .39704 .44581 L .534 .603 .869 r
F
.39365 .43798 m .36207 .4395 L .36623 .44724 L F
.28071 .60925 m .25192 .6096 L .24036 .61693 L .275 0 0 r
F
.29046 .60189 m .25192 .6096 L .28071 .60925 L .284 0 .017 r
F
.33246 .39945 m .30847 .41005 L .33958 .40767 L .454 .643 .938 r
F
.33246 .39945 m .30025 .40202 L .30847 .41005 L F
.34558 .57944 m .31538 .58001 L .30779 .58727 L .401 .023 .202 r
F
.35155 .57216 m .31538 .58001 L .34558 .57944 L .411 .051 .241 r
F
.3968 .54977 m .36594 .55042 L .36173 .55765 L .507 .215 .405 r
F
.39977 .54251 m .36594 .55042 L .3968 .54977 L .515 .245 .444 r
F
.38978 .43005 m .36207 .4395 L .39365 .43798 L .529 .618 .885 r
F
.38978 .43005 m .35733 .43168 L .36207 .4395 L F
.27021 .61667 m .24036 .61693 L .22798 .6243 L .266 0 0 r
F
.28071 .60925 m .24036 .61693 L .27021 .61667 L .275 0 0 r
F
.39337 .55705 m .36173 .55765 L .35693 .5649 L .498 .185 .367 r
F
.3968 .54977 m .36173 .55765 L .39337 .55705 L .507 .215 .405 r
F
.38544 .42203 m .35733 .43168 L .38978 .43005 L .524 .633 .9 r
F
.38544 .42203 m .35201 .42377 L .35733 .43168 L F
.32471 .39112 m .30025 .40202 L .33246 .39945 L .449 .653 .947 r
F
.32471 .39112 m .29133 .39388 L .30025 .40202 L F
.33899 .58676 m .30779 .58727 L .29948 .59456 L .39 0 .165 r
F
.34558 .57944 m .30779 .58727 L .33899 .58676 L .401 .023 .202 r
F
.38946 .56433 m .35693 .5649 L .35155 .57216 L .488 .156 .329 r
F
.39337 .55705 m .35693 .5649 L .38946 .56433 L .498 .185 .367 r
F
.38061 .4139 m .35201 .42377 L .38544 .42203 L .519 .646 .913 r
F
.38061 .4139 m .3461 .41577 L .35201 .42377 L F
.31633 .38267 m .29133 .39388 L .32471 .39112 L .444 .663 .954 r
F
.31633 .38267 m .28168 .38564 L .29133 .39388 L F
.27021 .61667 m .22798 .6243 L .25895 .62414 L .266 0 0 r
F
.33179 .59411 m .29948 .59456 L .29046 .60189 L .38 0 .13 r
F
.33899 .58676 m .29948 .59456 L .33179 .59411 L .39 0 .165 r
F
.38507 .57164 m .35155 .57216 L .34558 .57944 L .478 .127 .292 r
F
.38946 .56433 m .35155 .57216 L .38507 .57164 L .488 .156 .329 r
F
.37529 .40565 m .3461 .41577 L .38061 .4139 L .514 .657 .925 r
F
.37529 .40565 m .33958 .40767 L .3461 .41577 L F
.30729 .37408 m .28168 .38564 L .31633 .38267 L .439 .671 .961 r
F
.30729 .37408 m .27129 .37728 L .28168 .38564 L F
.32396 .6015 m .29046 .60189 L .28071 .60925 L .37 0 .096 r
F
.33179 .59411 m .29046 .60189 L .32396 .6015 L .38 0 .13 r
F
.38018 .57897 m .34558 .57944 L .33899 .58676 L .468 .1 .256 r
F
.38507 .57164 m .34558 .57944 L .38018 .57897 L .478 .127 .292 r
F
.36946 .39729 m .33958 .40767 L .37529 .40565 L .508 .668 .935 r
F
.36946 .39729 m .33246 .39945 L .33958 .40767 L F
.29759 .36535 m .27129 .37728 L .30729 .37408 L .435 .678 .966 r
F
.29759 .36535 m .26015 .3688 L .27129 .37728 L F
.31548 .60895 m .28071 .60925 L .27021 .61667 L .36 0 .064 r
F
.32396 .6015 m .28071 .60925 L .31548 .60895 L .37 0 .096 r
F
.37481 .58633 m .33899 .58676 L .33179 .59411 L .458 .073 .221 r
F
.38018 .57897 m .33899 .58676 L .37481 .58633 L .468 .1 .256 r
F
.36313 .38879 m .33246 .39945 L .36946 .39729 L .503 .678 .944 r
F
.36313 .38879 m .32471 .39112 L .33246 .39945 L F
.30635 .61644 m .27021 .61667 L .25895 .62414 L .35 0 .034 r
F
.31548 .60895 m .27021 .61667 L .30635 .61644 L .36 0 .064 r
F
.36892 .59373 m .33179 .59411 L .32396 .6015 L .448 .048 .187 r
F
.37481 .58633 m .33179 .59411 L .36892 .59373 L .458 .073 .221 r
F
.35626 .38015 m .32471 .39112 L .36313 .38879 L .497 .686 .952 r
F
.35626 .38015 m .31633 .38267 L .32471 .39112 L F
.30635 .61644 m .25895 .62414 L .29654 .624 L .35 0 .034 r
F
.36251 .60118 m .32396 .6015 L .31548 .60895 L .437 .023 .154 r
F
.36892 .59373 m .32396 .6015 L .36251 .60118 L .448 .048 .187 r
F
.34886 .37137 m .31633 .38267 L .35626 .38015 L .492 .694 .958 r
F
.34886 .37137 m .30729 .37408 L .31633 .38267 L F
.35557 .60868 m .31548 .60895 L .30635 .61644 L .427 0 .123 r
F
.36251 .60118 m .31548 .60895 L .35557 .60868 L .437 .023 .154 r
F
.34091 .36242 m .30729 .37408 L .34886 .37137 L .486 .701 .964 r
F
.34091 .36242 m .29759 .36535 L .30729 .37408 L F
.34809 .61625 m .30635 .61644 L .29654 .624 L .417 0 .094 r
F
.35557 .60868 m .30635 .61644 L .34809 .61625 L .427 0 .123 r
F
.34809 .61625 m .29654 .624 L .34005 .62388 L .417 0 .094 r
F
% End of Graphics
MathPictureEnd
\
\>"], "NumberedFigure",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  ImageSize->{257, 209},
  ImageMargins->{{25, 0}, {0, 14.625}},
  ImageRegion->{{0.002675, 1.00024}, {-0.118386, 1.06966}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005100011A000`40O003h00Oogoo@Woo003oOom2
Ool00:5oo`0FEUMJN5IGFWQFEeYhEUMJN5IGFWQFEejHFWMNV5YgGYQJMejHFWMNV5YgGYR:Ool008eo
o`0:CSQ:5dhgBSM>>4XGCSM:=dhhBQL2DUL01E9HDUMBEe9GDUP00e9G00EFN5IgEWMFMeIh00=FM`0>
EWQFMeIgFYMNV5ZGGYMJUejHFYMNUeZGGYQJU`9R]`06H[QN]f:gH[MR^5jg0V:gP7oo0024Ool0ATHH
@OM6647gAQQ1mdHH@OM664XGCSQ:5dhhBQM>>4XGCSQ:5dhhCSMBF58gDUQ>=e9HDSMBF4hgDUQFEeYh
EUMJN5IGFWQFEeYhEUMJN5IGGYQJMejHFWMNV5YgGYQJMejHFWMNV5jGH[QNUf:hGYMR^5jGH[QNUf:h
I]MVf6;GI]QVefKHH]MVf6KGMgoo0022Ool2>ML01D7gAOM5mdHH@OL00TGg00e6647gCSM:=dhhBQM>
=dXgCSQ:5dhgBSMBF003DUL01E9HDUMBEe9GDUP00U9G00=FMeIhEWL00UIg019FN5IgEWMFMeIhFYMN
UeZGGYQJUejGFYMNV5ZGGYMJUf:hG[L2H[L01V:hG[MR]f:gH[QN]`9Ve`05I]QVefKGI]MVf002I]L0
0f[gJaMZm`02J_L00f/GJ_MZm`1_Ool007eoo`1G>KLmf3Vg?MPi]cgH>KM6647gAQQ1mdHH@OM6647g
AQQ1mdhhBQM>>4XGCSQ:5dhhBQM>>58gDUQ>=e9HDSMBF4hgDUQB=e9HCSMJN5IGFWQFEeYhEUMJN5IG
FWQFEejHFWMNV5YgGYQJMejHFWMNV5YgGYQNUf:hGYMR^5jGH[QNUf:hGYMVf6;GI]QVefKHH]MVf6KG
I]QReflHJ_M_66[gKaQZmflHJ_Mc=flg06eoo`00Mgoo0Reg00H]Ubeg;GL]McWG>KL3>ML01CVg>MLi
edHH@OL00TGg00i6647gAOM5mdHHBQM>=dXgCSQ:5dhgBSM>>4XG0U9G00EBF59GDUMBEe9H00=BE`05
DUQFMeIgEWMFN003EWL03UIhEWMFMeZGGYQJUejGFYMNV5ZGGYMJUejHFYL2H[L02F:hG[MR]f:gH[QN
]f:gI]MVf003I]L01FKHI]MVefKGJaL00f[g00E[5f[gJ_MZmf/G00Ic=fUoo`00MWoo06LI5RUf;IL]
MbfG:GH]UcVg?MPi]cgH>KLmf3Vg?MQ1mdHH@OM6647gAQQ1mdHH@OM>>4XGCSQ:5dhhBQM>>4XGCSQ>
=e9HDSMBF4hgDUQB=e9HCSMBF58gFWQFEeYhEUMJN5IGFWQFEeYhEUMNV5YgGYQJMejHFWMNV5YgGYQJ
MejHGYMR^5jgH[QNUf:hG[MR^5jGI]QVefKHH]MVf6KGI]QRefKHJ_M_66[gKaQZmflHJ_M_66lgLcM_
5g<gKcMc=flGNgMgEW]gMeIkM`1TOol007Aoo`045?HE5QDF6AH3;GL00bfG;GL]M`02>ML01CVg>MLi
ecWG>KL00TGg0496647gAOM5mdHH@OM5mdXgCSQ:5dhhBSM>>4XGCSQ:=e9HDUMBF59GDUQBEe9HDUMB
F59GDUQFMeIhEWMFN5IgEWQFMeIhEWMFN5ZGGYQJUejHFYMNV5ZGGYQJUejHFYMR^5jgH[QR]f:hG[MR
^6:gH[QVefKHI]MVf6KGI]QVefKHI]L2J_L01V/GJ_MZmf[gJaMZm`Mc=`=gMP03MgMgMW^d06=oo`00
Lgoo06`0<QTF5?DI5QCe;ILYMRfG;GL]UbUf?MPi]cgH>KLmf3Vg?MQ1mdHH@OM6647gAQQ1mdHH@OM>
>4XGCSQ:5dhhBQM>>4XGCSQ:5e9HCSMBF58gDUQ>=e9HDSMBF4hgFWQFEeYhEUMJN5IGFWQFEeYhEUMN
V5YgGYQJMejHFWMNV5YgGYQJMf:hG[MR^5jGH[QN]f:hGYMR^5jgI]QRefKHI]MVf6;GI]QVefKHJ_M_
66[gKaQZmflHJ_M_66lGLcM_=g<gKaMc=gMFNgMgEW]gMeIk]G^DOkEROol0079oo`050380<aDF6AHD
mP025AH01BfG;GL]Mbeg;IL023WG00E1mdGgAOM6647g0095m`0mAQQ1mdhhBSM>>4XGCSQ:=dhhBQM>
>59GDUQBEe9HDUMBF59GDUQBEe9HEWMFN5IgEWQFMeIhEWMFN5IgEWQJUejHFYMNV5ZGGYQJUejHFYMN
V5jgH[QR]f:hG[MR^6:gH[QN]f:hI]MVf6KGI]QVefKHI]MVf6KGJaP00f[g00I[66[gJ_MZmg<gKcL4
LcL2MgH01gMgMgIgMW^DNkAkU6n>065oo`00LWoo06h0D`0b05<DmATF5?DI5Reg;ILYMRfG;GLmf3Vg
?MPi]cgH>KLmf3VgAQQ1mdHH@OM6647gAQQ1mdHHBQM>>4XGCSQ:5dhhBQM>>4XGDUQB=e9HCSMBF58g
DUQ>=e9HDSMJN5IGFWQFEeYhEUMJN5IGFWQFEejHFWMNV5YgGYQJMejHFWMNV5YgH[QNUf:hG[MR^5jG
H[QN]f:hGYMVf6KGI]QRefKHI]MVf6;GKaQZmflHJ_M_66[gKaQZmflHKcMc=flgLcQ_=g<gMeIkMgMF
NgMkU7neNiAk]Fm^HGoo001bOol203<02`0b5AHE5QTF5AH]Ubeg;IL]MbfG;GL023WG00I6647gAOM5
mdHH@OL2AOL0>DhhBQM>>4XgCSQ:5dhhBSM>>59GDUQBEe9HDUMBF59GDUQBEe9HEWMFN5IgEWQFMeIh
EWMFN5IgEWQJUejHFYMNV5ZGGYQJUejHFYMNV6:gH[QN]f:hH[MR^5jgH[QR]f:hI]MVf6KGI]QVefKH
I]MVf003J_L01V/HJ_MZmf[gJaQ_=`=c=`04KcMc=g<gMgL3MgH01G^dNiAk]6m^Lhh0HGoo001bOol0
K@0:0380DaCe6AHE5QTF:GH]Ubeg;ILYMRfG>KLmf3Vg?MPi]cgH>KLmf47gAQQ1mdHH@OM6647gAQQ:
5dhhBQM>>4XGCSQ:5dhhBQMBF4hgDUQBEe9HCSMBF59GDUQ>=eYhEWMJN5IGFWQFMeYhEUMJN5IgGYQJ
MejHFYMNV5YgGYQJUejHFWMR^5jgH[QNUf:hG[MR^5jGH[QN]fKHH]MVn6KGI]QRefKhI]M_66[gKaQZ
mflHJ_M_66[gLcM_=g<hKcMc=flgLcQgMWMgMeIkMg^DNkEkU7>>069oo`00LWoo00h02P0c03<I5QDF
6AHE5QTF;GL]Ubeg;IL]MbfG1CWG04/if3WGAQQ5mdHH@OM664GgAQQ1mdhhBSM>>4XgCSQ:=dhhBSM>
>59GDUQBEe9HDUMBF59GDUQBEe9HEWMFN5IgEWQFMeIhEWMFN5IgEWQJUejHFYMNV5ZGGYQJUejHFYMN
V5jgH[QR]f:hG[MR^6:gH[QN]f:hI]MVf6KGI]QVefKHI]MVf6[gJaQZmf[hJ_M[66[gJ_P00W<g00A_
=g<gLcMc=`=gMP06MgMgMW^dNkAk]Fm^HWoo001cOol0J`0b05<0<QTF5?DI5QDF;ILYMRfG;GL]UbUf
?MPiecgH>KLmf3WG?MQ1mdHH@OM6647gAQQ1mdHH@OM>>4XGCSQ:5dhhBQM>>4XGCSQBEe9HCSMBF59G
DUQ>=e9HDUMJN5IGFWQFMeYhEUMJN5IgFWQFEejHFYMNV5YgGYQJUejHFWMNV5ZGH[QNUf:hG[MR^5jG
H[QN]f:hH]MVn6KGI]QRefKhI]MVf6;GKaQZmflHJ_M_66[gKaQZmg<hKcMc=flgLcQ_=gMgMeIkMgMf
NkEkU7^eNi@0Hgoo001cOol01`0;03<0DaDF6AHE5QTF008]U`04;GL]UbfG;IL3>ML0CSWH>MLiecWG
>MQ1mdHHAOM6647gAQQ5mdHHBSM>>4XgCSQ:=dhhBSM>>4XgDUQBEe9HDUMBF59GDUQBEe9HEWMFN5Ig
EWQFMeIhEWMFN5IgEWQJUejHFYMNV5ZGGYQJUejHFYMNV6:gH[QN]f:hH[MR^5jgH[QR]fKHI]MVf6KG
I]QVefKHI]M[66[gJ_QZmf/HJ_MZn6[gLcM_=`=c=`04KcMc=gMfMgL2MgH017^dNkEkU6n>Hgoo001c
Ool0J`0:05<0<P1C5AHI5QDF;IL]MbfG:GL]Ubeg?MPi]cgH>MLmf3Vg?MPiedHH@OM6647gAQQ1mdHH
@OM>>4XGCSQ:5dhhBQM>>4XGCSQ>=e9HDUMBF4hgDUQBEe9HCSMJN5IgFWQFEeYhEWMJN5IGFWQFMejH
FWMNV5ZGGYQJMejHFYMNV5YgH[QN]f:hGYMR^5jgH[QNUf:hI]MVf6;GI_QVefKHH]MVn6[gKaQZmflH
J_M_66[gKaQ_=g<hKcMc>6lgLcQ_=g]gMgIgMgMFNkEkU7^eKfh0Hgoo001dOol01`0:05<0<aTF5AHI
5QDF00<]U`04;GL]UbfG>MP3>ML05SWH>MLiedGhAQQ1mdHHAOQ6647gAQQ:>4hhBSM>>4XhCSQ:=dhh
BSQBF59G0e9H00EBEe9HDUQBF5Ig00=FN00AEWMFN5IhEWQFMeIhFYQNV5ZGGYQJV5jHFYMNV5ZHGYQN
]`03H[P01EjgH[QR^6:hG[L00fKH00eVefKHI]QVf6KGJ_QZmf/HJ_MZn6[gJaQ_=`03LcL036lgLcMc
=gMgMgIgMgMfMgMkU7^dKhicSf=oo`00M7oo06T02`0c05<E5QTF5AHI5RUg;IL]MbfG:GL]UcWG?MPi
]cgH>MLmf3VgAQQ1mdHH@OM6647gAQQ1mdhhBQM>>4XGCSQ:5dhhBQM>>59GDUQ>=e9HDUMBF4hgDUQB
EeYhEUMJN5IgFWQFEeYhEWMJN5IGGYQJUejHFWMNV5ZGGYQJMejHFYMR^5jgH[QN]f:hG[MR^5jgH[QR
efKhI]MVf6;GI_QVefKHJ_M_66[gJaQZmflHJ_Mc>6lgLcQ_=g<hKcMc>7MfMgMgEW]gNiAk]G^DLhl0
I7oo001eOol305<01ADF6AHE5QTF;GL00bfG01T]McWH>MLif3WG>MPiecWH@OM664GhAQQ1mdHHAOQ6
64XgCSQ:>4hhBSM>>4XhCSQ:=`03DUP01U9GDUQBF59HDUMBF09FN005EWMFN5IhEWQFM`03EWP02EZG
GYQJV5jHFYMNV5ZHGYQJU`03H[P01UjgH[QR^6:hG[MR^09Vf005I]MVf6KHI]QVe`02I]P02V/HJ_M[
66[gJaQZmf/HLcMc>6lg0W<g00Yc>7MfMgMgMWMgMgIk]G^dNkE_SVAoo`00MGoo06P02P1C03<I5QDF
6AHE5RfG:GL]V2eg;ILi]cgH>MLmf3Vg?MPiecgH@OM6647gAQQ1mdHH@OM>>4XGCSQ:5dhhBQM>>4XG
CSQ>=e9HDUMBF4hgDUQBEe9HCSMJN5IgFWQFEeYhEWMJN5IGFWQFMejHFWMNV5ZGGYQJMejHFYMNV5jg
H[QN]f:hG[MR^5jgH[QN]fKhI]MVf6;GI_QVefKHH]M_66[gJaQZmflHJ_M[66[gLeQ_=g<hKcMcF6lg
MgMgMW]gMgIk]G^DNkEkU7>?I7oo001eOol00`0;05<0D`026AH01ADF6AH]UbfG;GL00bfG01TiecWH
>MLif3WG>MPiedHH@OM664GhAQQ1mdHHBSQ>>4XgCSQ:>4hhBSM>>4XhDUQBE`03DUP01E9GDUQBF59H
EWL00eIh00UFMeIhEWQFN5IgEWQJV5jHFYL00UZH00INV5ZGFYQJV6:hG[L3H[P01EjgH[QR^6:hI]L0
0fKH00eVefKHI]QVf6[gJaQZmf/HJ_M[66[gLcQ_=`02LcL00g<hKcMc=`02MgL01GMfMgMk]7^eNi@0
0Vn?I7oo001fOol0IP0;03<I=aDF6AHE5RfH;GL]UbUg;IP]McgH>KLmf3WG?MPi]cgH@OM6647gAQQ1
mdHH@OM>>4XgCSQ:5dhhBSM>>4XGCSQBEe9HCUMBF59GDUQ>Ee9HDUMJN5IGFWQFMeYhEUMJN5IgFWQF
EejHFYMNV5ZGGYQJUejHFYMNV5jgH[QN]f:hG[MR^5jgH[QN]fKHH]MVn6KGI]QRefKhI]M[66[gKaQZ
mf/HJ_M_66lgLcQ_=g=HKcMc>7MfNgMgMWMgMgIk]G^DNkE_KVEoo`00MWoo00<02`1C05<00aTF00TE
5RfG;IL]Ubeg;ILif3gH>ML00SWH00<mf3WGAQP00THH00i1mdHHAQQ664XgCSQ:>4hhBSM>>4XhCSQ:
=dhh0U9H00EBEe9HDUQBF59G009BF003EWQFMeIh009FN005EWMFN5IhEWQJU`02FYP01UjHFYMJV5ZH
GYQJU`=R^006G[MR^6:hH[QN]f:h0VKH00eVefKHI]QVf6KGI]QZn6/HJ_M[66[hJaQZm`02LcL01W<h
KcMc=g<gMgMgMP=gM`=k]@03Khmoogoo06=oo`00Mgoo06@0D`1D5AHI=aDF6AHYMbfH;GL]V2eg?MPi
ecgH>MLmf3WG?MQ1mdHH@OM6647gAQQ1mdHHBQM>>4XgCSQ:5dhhBSM>>4XGDUQBEe9HCUMBF59GDUQ>
Ee9HEWMJN5IGFWQFMeYhEUMJN5IgGYQJUejHFYMNV5ZGGYQJUejHG[MR^5jgH[QN]f:hG[MR^6;GI_QV
efKHH]MVn6KGI]QReflHJ_M[66[gKaQZmf/HKcMcF6lgLcQ_=g=HMgIgMgMfNgMkU7^eNiAcSfIoo`00
Mgoo00@02`1C05<E5P8I5PH]U`8if006?MPiecWH>MPmf47g0dHH00e1mdHHAQQ>>4XgCSQ:>4hhBSM>
>4XhCSQBE`03DUP01E9GDUQBF59HDUL00eIh00UFMeIhEWQFN5IgEWQJV5jHFYL00UZH00INV5ZGFYQJ
V6:hG[L3H[P01EjgH[QR^6KHI]L00fKH00eVefKHI]Q[66[gJaQZn6/HJ_M[66[hLcQ_=`02LcL00g<h
KcMgM`03MgL3NkD00fn?Oomoo`1TOol007Moo`1T00/0E01C6CLE5QTg5AH]V2eg;IP]MbfH>MLmf3WG
?MPiecgH>MM6647gAQQ1mdHH@OM664XgCSQ:5dhhBSM>>4XGCSQ:=e9HCUMBF59GDUQ>Ee9HDUMBF5Ig
FWQFMeYhEWMJN5IgFWQFMejHFYMNV5ZGGYQJUejHFYMNV5jgH[QN]f;HG[MR^5jgH]QVefKHH]MVn6KG
I]QRefKhJ_M[66[gKaQZmf/HJ_McF6lgLcQ_=g=HKcMgMgMfMgMgMWMgMiAk]Fn?LhmVOol007Qoo`<0
D`036CLE5QTF00H]U`06>MLif3WH?MPiecWH0THH00i1n4HHAQQ6647hCSQ:>4hhBSQ>>4XhCSQ:>4hh
2E9H2EIh0eZH00INV5ZHFYQJV5jHFYP3H[P01EjhH[QR^6:hG[P026KH0f/H00EZn6/HJaQ[66lg009c
=`03LcQ_=g<g00AgM`=k]@03Khmoogoo06Eoo`00N7oo05h0M01C07@E5QTg5AHI=beg;IP]MbfH;GLm
f3WG?OPiecgH>MM6647gAQQ1mdHH@OM6647gCSQ:=dhhBQM>>4XgCSQ:5e9HDUMBF4iGDUQBEe9HCUMB
F5IgFWQFMeYhEWMJN5IgFWQFMejHFYMNV5ZGGYQJUejHFYMR^5jgH]QN]f:hG[MRf5jgH[QRefKhI]MV
n6;GI_QVefKhJ_M_66[gJaQZmflHJ_Mc>6lgLeQ_=g<hMgIgMgMfMgMgMP=k]@03Khmoogoo06Eoo`00
N7oo00L02`1D05<0DaTF6CLE5P02;IL01RfH;IL]UcWH?MPie`8if003?MPiedHH0096600<@OQ664HH
AQQ:>4hhBSQ>>4XhCSQ:>4hh2E9H2EIh00=JV5jHFYP00UZH00=NV5ZHFYP00V:h00EN^6:hH[QR^5jh
009R^0MVf09[600;J_Q[66/HJaQZn6/HKcMc>6lgLcQ_=`04MgL3NkD2KhmWOol007Uoo`1H05<0M01C
6CLE5QTg;GL]V2fG;IP]MbfH>MLmf3WG?OPiecgH@OM6647gAQQ1mdHH@OM>>4XGCSQ:=dhhBQM>>4Xg
DUQ>Ee9HDUMBF4iGDUQBEe9HEWMJV5IhFWQFMeZHEWQJN5IgG[QJV5jHFYMN^5ZHGYQJUf;HG[MR^5jg
H]QN]f:hG[MRf6KGI_QRefKhI]MVn6;GKaQZmf/HJ_M_66[gJaQ_=g=HKcMc>6lgLeP2MgL01WMfMiMk
]G^eMiAc/6Qoo`00NGoo00L02`1C07@I5QTg6AHI=`03;IL01RfH;ILif3WH?MPie`8if003AQQ264HH
0096600:@QQ664XhCSQ:>4hhBSQ>>4XhCSP9DUP9EWP3FYP01UjHFYQJV5ZHGYQN^0=R^005G[QR^6:h
H[QN^007I]P01F[hJaQ[66/HJ_P00V/H00Ic>6lgLcQ_=g<hKcL4MgL2NkD2KhmXOol007Yoo`0Q07@0
DaTg5AHI=aDF;IP]MbfH;IL]V3WG?OPiecgh>MLmn47hAQQ1mdHH@OQ6647gCSQ:>4hhBSM>>4XhCSQ:
=dhh009BF00fCUMBN59HDUQ>Ee9hEWQJN5IgFYQFN5YhEWMJV5IhGYQJUejhFYQNV5ZGG[QJV6:hG[MR
f5jhH[QN]f;HG[QR^6;GI_QRf6KhH]MVn6;HJaQZmflHJ_M[66[gKaQ_=g<hKcMcF6lgMgMgMWNG0WMg
00=gUG^fKhl0JGoo001jOol0300;07@0E1Tg6AHI=bfG;IP]UbfH;ILmf0<if003?MPif3WH0096600=
@QQ664HHAQQ264hhBSQ>>4XhCSQ:>4hhBSP0259H2EIh00=JV5jHFYP00UZH00=NV5ZHFYP00V:h00IN
^6:hH[QR^5jhH[P8I]P2JaP02V[hJaQ[66/HJ_Qc>6lhLcQ_=g<h17Mg0g^e00=_T7ooOol0Igoo001j
Ool08`0<05<0M1DF6CLE5QTg;IL]V2fG;IP]Ucgh>MLmn3WG?OPiedHH@OQ6647gAQQ1n4HHBSM>>4Xh
CSQ:=dhhBSQ>>4iGDWP00U9H039>Ee9hDUQBF5IgFYQFN5YhEWMJV5IhFWQFMejhFYQNV5ZGG[QJV5jH
FYMRf5jhH[QN]f;HG[QR^5jgI_QRf6KhH]MVn6;HI_QZmflHJ_M[66[gKaQZmg=HKcMcF6lgLeQ_=gNH
0WMg00EcMg^fNkEc/6n?06Uoo`00Ngoo00<0301C6CL00QTg00PI5RfH;IL]V2fG;IPif3gH0cWH00<m
f48HAQP00THH00]264HHAQQ>>4XhCSQ:>4hhBSQ>>4Xh00QBF0UFN0=JV006GYQJV5ZHFYQNV5jh0f:h
00AN^6:hH[QR^0MVf003JaQZn6/H009[6007J_Q[66lhLcQ_=g<hKcP01GMg0W^e00=_SgooOol0J7oo
001kOol0800;07@0DaTg5AHI=aDF;IP]UbfH;ILmn3WH?OPiecgh>MQ6647gAQQ264HH@OM664XhCSQ:
=diHBSQ>>4XgCUP2DUP0<TiGDWQBF59HCUMBN5IhFWQFMeZHEWQJN5IgFYQFN5jHFYMN^5ZHGYQJUejh
FYQRf5jgH]QN^6;HG[MRf5jhI_QRefKhH]QVn6;GI_QZn6/HJ_M[66[hJaQ_=g=HKcMcF6lgLeP2MgL0
1W=gMiQg]G^fMkEc/6Yoo`00Ngoo00@0301d07@I5P<I=`05;IL]V2fH;IP]U`02>MP00cgh>MPif002
AQP03D8HAQQ664HH@QQ664XhCSQ:>4hhBSQ>>4Xh00QBF0QFN09JV005GYQJV5ZHFYQNV002FYP2H[P0
25jhH[QR^6:hG[QR^6KHI_P3I]P00fKhI]Q[6005JaP01G=HKcQc>6lhLeP01GMg0W^e00=_/7ooOol0
JGoo001lOol08@0<05@0M1DF6CLI=RfH;IL]^2fG;IPiecgh>MPmn3WG?OQ264HH@OM6648HAQQ1mdiH
BSQ>>4XgCUQ:>4hhCUMBN002DUP0=diGDWQBF59HEWMJV5IhFWQFMeZHEWQJN5ZGG[QJV5jHFYMN^5ZH
GYQJUf;HG[QRf5jgH]QN^6;HH]MVn6;HI_QRefKhH]Q[66[gJaQZn6/HJ_M[66lgLeQ_=g=HKcMgV7=g
MiQgMg^fMkEk]Vn?06]oo`00O7oo00<0301d07@011Tg00<]V2fG;IP00RfH0cWH00<mn3WHAQP00THH
00]264HHAQQ664XhCSQ:>4hhBSQ>>4Xh00QBF0QFN005GYQJV5ZHFYQNV003FYP02EjHG[QR^5jhH[QN
^6:hG[QVn003I]P00fKhI]QVf006JaP01VlhLcQ_>7=HKcQc>0AgM`04NkEk]Vn@Ki1[Ool007eoo`0]
07@0MATf6CLE5QTg;IL]V2fG;KP]Ucgh>MLmn3WH?OQ264HH@QQ6648HAQQ264hhBSQ>F4XhCSQ:>4iH
BSQBN4iHDWQBF59hCUQBN5IhEYQFN5ZHEWQFV5Ih009JV00>G[QJV5jhFYQN^5ZHG[QJV6;HG[QRf5jh
H]QN^09Rf00II_QRf6KhH]QVn6;HJaQZn6/HJ_Q[66[hLeQ_=g=HKcMcF7=gMiQgMgNHMkEkeWNeKk00
K7oo001mOol00`0=07@0M0036CL2;IP01Bfh;IP]V3WH?OP00cWH00=6648HAQP00THH00Y264HHAQQ>
>4XhCSQ:>4hhBSQ>>0MBF0QFN09JV00>GYQJV5ZHFYQNV5ZHH[QN^6:hG[QR^5jhH[QN^09Vf005I_QV
f6KHI]QVn006JaP00flhLeQ_>002KcP4MgL017^fMkEk]Vn@K7oo001nOol207@0<QTg6CHI=aDg<KP]
Ubfh;ILa^3WH?OPif3gh>MQ6648HAQQ264HH@QQ664XhCSQ:>4iHBSQ>>4XhDWQBF59hCUQBN59HDWQF
N5ZHEWQFV5IhFYQFN5JHFYQN^5ZHG[QJV5jhFYP2G[P086;HG[QRf5jhH]QN^6KhH]QVn6;HI_QRf6Kh
J_Q[66[hJaQZn6/HJ_QcF6lhLeQ_=g=HLgMgV7=gNmIg]G^fKi1]Ool007ioo`0300`0M1Tg00<I=`<]
V005;KP]V3WH>MPmn002>MP2AQP0348HAQQ664HH@QQ>>4XhCSQ:>4hhBSQ>>0MBF0QFN005GYQJV5ZH
FYQNV003FYP02F;HG[QR^5jhH]QN^6:hI]QVn003I]P00fKhI]Q[6005JaP01W=HKcQ_>6lhLeQ_>09g
M`05MiQg]W^fMkI_/01]Ool007moo`0307@0UADg00<I=`0n;ILa^2fG;KPif3gh>MPmn3WHAQU264HH
@QQ66D8HAQQ:>4iIBSQ>F4XhCUU:>59hCUQBNE9HDWQ>F59iDUQFV5IhFYUFN5JHEWQJVEZHG[QJV5ji
FYQN^5ZHG[UN^6;HG[QRfEjhH]QN^6KiH]QVn6;HI_URf6KhJ_Q[6@9[600>J_Q[6FlhLeQ_=g=HKcQg
V7=gMiQcMg^fMkEkeVioo`00Ogoo0P1d11Tg00X]^2fH;KP]V3gh>MPin3WH?OQ260=6600:@QQ664HH
CSQ:>4hhBSQ>>4XhCSP8DUP7EWP2FYP055jHFYQJV5ZHGYQJV6:hG[QRf5jhH[QN^6;HI]QVn6KHI_QV
f6KhI]P6JaP036mHKcQcF6lhKeQgMgNHMgMk]WNfNkI_/6ioo`00Ogoo03<0302E07@IEaTg6EP]V2fh
;ILa^2fH?OPif3gi>MPmn48HAQU264HH@QQ66DXhCUQ:>4iIBSQ>F4XhDWUBF59hCUQBNE9HDWQ>F5ZI
EWQFV5IhFYUFN5JHFYQN^EZHG[QJV5jiFYP00Ujh00eRfEjhH]QN^6;IG[QVn6;HI_URf6KhH]Q[6@02
JaP046[hJaU[66/HKcQcF6lhLeQ_>7NHLgMgV7NeNmIg]FnaKWoo0020Ool00`1d09DI=`036CL02bfH
;KP]V2fh>MPmn3WH>OPif4HH@QP00dHH00A264XhBSQ>F0=:>005CUQBF59HDUQBN003DUP01E9hEWQF
N5IhEYP00eIh00EN^5ZHFYQJV5jh00=JV00=H]QN^6:hG[QRf5jhH[QVf6KhI]QVn6KHI_P01V/H00a_
>7=HKcQ_F6lhMiQgMgMhMgMk]WNfKk5_Ool0081oo`1B00h0M02E6CLIEaTg<KP]V2fh;ILmnCWH?OTi
f3gi@QQ66D8HASU264HIBSQ>FDXhCUU:>4iIBSQ>FDiHDWUBF59iCUQBNE9HEYUFN5ZIEWQFVEIhFYUJ
V5jiFYQN^EZHG[UJV5jiG[QRfEjhH]UN^6;IG[QVnF;HI_URf6KiH]Q[6F/HJaU[66/IJaQcF6lhLeQ_
>7=HLgMgV7=gNmIg]W_FKi1_Ool0085oo`0309D0M1Tg008I=`05;IP]^2fh;KP]V002>OP00cgh>MPi
n002AQP0148HAQQ664HH0dXh00E>F4XhBSQ:>59h00=BF005DWQBF59HEWQFV003EWP01EJHEWQJV5ZH
G[P00eZH0Ujh00QR^5jhH]QN^6:hG[QVn6KH0fKh00=Vf6KhJaP016/H00=_F6lhKeP00VmH00IgMgMh
MgMgV7NfNkH2Kk5_Ool0085oo`1@00d0UATg6EPI=aUH;IPa^2fH;KPif3gi>MPmnCWHASU264HI@QQ6
>D8HCUU:>4iIBSQ>FDXhCUUBF59iCUQBNE9HDWU>F5ZIEWQFVEIhFYUFN5JIFYQN^EZHG[UJV5jiFYQR
fEjhH]UN^6;IG[QRfF;HI_URf6KiH]QVnF/HJaU[66/IJaQ[6FlhLeQ_>7=IKcQgV7=gMiQg]W_FMkE_
/G1oo`00PWoo0P2E00DI=aUG6CL]^2fH00<]^005>MPin3Wh?OQ26003AQP09D8HAQQ:>4iIBSQ:F4Xh
CUU:>59hDUQBNE9HDWQBF59iEWQFV5IhEYUFN5JHEWQN^EZHF[QJV5jiFYQJ^5jhH]UN^6;HG[QRfEjh
009Vn004I_URf6KhI_P5JaP02FlhKeQ_F6mHKcQgV7MhMiQcN002MkH2Kk5`Ool0089oo`1>00h0UAUH
6CLIF1Tg;KP]V36h;IPmnCWH?OTin3gi@QQ6>D8HASU264iIBSQ>FDXhCUU:>4iICUQBNE9HDWU>F59i
DUQFVEIhFYUFN5JIEWQJVEZHG[UJV5jiFYQN^EZHH]UN^6;IG[QRfEjhH]URf6KiH]QVnF;HI_U[66/I
IaQ[6F/HLeU_>7=IKcQcFG=gMiQcMg_FMkIkefnaLGoo0023Ool209D00aUH6CLIE`04;KP00cWh?OTi
n002>OP0:THI@QQ664HHAQU264YHBSQ>FDXhBUQ:>59iDUQBN59HDWUBF59hEWQFVEIhEYQFN5JIEWQJ
^5ZHG[UJV5ZhFYQN^EjhH]QN^6;IG[QRf6KhI_URf09Vn005I_U[66/HJaQ[6@02JaP00fmHKeU_F002
KeP01gNHLgQgV7NfNmI_/@00075oo`00Pgoo04`03@2f09DIF1Tg<KT]^2fi;IPa^CWh?OTif3gi>OQ6
>D8HASU264HiBSQ>FDXhCUU:>4iIDUQBNDiHDWUBF59iCUQJVEIhEYUFN5ZIEWQFVEZHG[UJV5jiFYQN
^EZHH]UN^6;IG[QRfEjhI_URf6KiH]QVnF;HJaUW66/IJaQ[6FlhLeU_>7=IKcQgV7=hMiQg]W_GMkI_
/G9oo`00Q7oo0P2E00<IEaUH6EL012fh0SWh03DmnCWh>OQ664Hi@QQ66DHHCUU:>4YIBSQ>FDXhDWUB
N59iDUQBNE9hDWUFN5JIEYQFVEIhEYUFV5ZiFYQJ^EZhF[UJV5ZiG]QRfEjhH]UNf6;IH_QVnFKhI_UR
n6KiJaQ[6F/HJaU[66mI00=_F008KeUcN7NHLiQgegNfKk80079oo`00Q7oo04X03`2E0;HI=aUH;KPa
^Bfh;KTin3gi>OPmnCWhASU264Hi@QQ6>D8HCUU:>4iIBSQ>FDXhDWUBF59iCUQBNE9HEYUFN5ZIEWQF
VEIhFYUJV5jiFYQN^EZHG[UN^6;IG[QRfEjhH]UN^6KiH]QVnF;HI_URf6/iJaQ[6FLHJcU_>6mIKcQc
FG=hMiQcMg_GMkIkef^aLgoo0025Ool00`2e09DIF0026EP3;KP0@2fi>OPinCWh?OTin4HIAQQ6>D8H
AQU:>4iIBSQ:FDXhCUUBF59iDWQBNE9HDWUFV5JIEWQFVEJHEYUFN5ZiF[QJ^EZHF[UJ^6;IG[QRfEkH
H]UN^6;II_QVnF;hI_UVn6/IJaQ[6F/HJaU_F6mIKeQ_FFmHMiQcV7NHMkIgefnaM7oo0025Ool0B02E
0;HIEaeH6EL]^Bfh<KT]^3gi>OPmnCWh?OU264Hi@QQ6>D8HCUU:>4iIBSQ>FDXhDWU>F59iDUQBNDiH
FYUFN5JIEWQJVEIhEYUJV5jiFYQN^EZHG[UN^6;IG[QRfEjhH]UN^6KiH_QVnF;HI_U[66/IIaQ[>F/H
KeU_>7=IKcQgV7=hMiUcN7OGJk9_dWAoo`00QWoo00<0]@2f6EP00QUH00D]^Bfh;KTinCgi00<in@06
ASU26DHiAQU6>D8I0TYI00I>FDYHBUU:FE9iDWP3DWT01E9hEYUFVEJIEWP00UJI00=J^EZHF[T00UZi
00EJV5kIG]URfEkH009Nf@03H]URn6Ki009Vn@03H_Q[6F/I00=[6@9_F@05KeQ_FG>HMiQcV002MmL0
0foBOomoo`1cOol008Ioo`160;H0UAeh6EPMN2fh<MT]^37I>OPmnCWh?QTin4Hi@QQ6>D8HASU:>4iI
BSQ>FDXhCUUBF59iCUQBNE9HDWUFN5ZIEWQFVEIhFYUJV5jiFYQN^EZHG[UN^6;IG[QRfEjhH]URn6Ki
H]QVnF;hJcUW66/iIaQ[>FlhLeU_F6mILgQgVG=hMiUg]VoBJk9eOol008Moo`80]P<IF08]^@04;KPi
nCWi?OT2>OT01THIASU26DHiAQU>F@=:F@03CUU:FE9i00EBN@IFV@IJ^@06H]UNfEkIG]URfEkI0fKi
00=Rn6KiJaT016/I00E_FFmHKeU_FGNI009cV09ge`03Jk9oogoo07Aoo`00Qgoo03X03`3F6EPMN1UH
<MT]^37I>OPn6CWi?QTin4Hi@QU6>D8HASU:F4iIBSQ>FDYHCUU>F59iDWQBNDiHDWUFN5JIEWQJVEIh
EYUJV5jiFYQN^EZHG[UNf6;IG[QRfEkHH]URn6KiH_UVnF;hJcUW6F/iIaQ[>@9_F@08KeQgVG=hMiUc
N7OGJk8007Ioo`00R7oo0P2f00<IF1eh6EP00Rfi00H]fCWi>OTinChI>OT3AST0148iASU:FDiI0dYI
1U9i1UJI1UZi0UkI00URfEkIG]URnFKiH_UVnF;iJcT00f/I00=[>FmIKeT00VmI00=cV7>ILiT00WOG
00=_dWooOol0MGoo0028Ool07P0@0;HMNAUH7GT]^37I;KPn6CWh?QTinChI@QQ6>D8IASU264iIBUU>
FDYICUU>NE9iCWQBNDiiDWUFN0=FV@0QEWQFVEZiG[UJV5jiF[UN^EkHH]UNfF;IG]QVnF;iI_URn6Ki
IaU[>FLHJcUW6FmIKeQ_FG>HLiUcN7NILkM_d`0007Moo`00RGoo00D0eP2f6GPIF1eh00<]^@06?QTi
nCXI>OU6>D8i0dHi0dYI00=>FDYIBUT01E9i1UJI1EZi00=NfF;IG]T00UkI00YRfF;iI_URnFKiH_U[
>F/IJcUW6@A_F@=cV@9ge`03Jm=oogoo07Ioo`00RGoo01`03`3F6EPMNAUh<MT]^C7I;KTn6CWi?QXi
nDHi@QU6>D8iCUU:FDiIBUU>FDYIDWU>NE9iCWQBN@9FV@0JEWQFVEJIEYUJV5jiF[UN^EZHH]UNfF;I
G]QRfF;iI_URnFLIH_U[>FLIJcUW6F/iJeU_NP9_F@05LiQcVG>HMmQ[/P1iOol008Yoo`0<0=H0eaUh
6GTIN2gI;KT]fCWi?QTinCXI0THi00A2>DHiBUU>F@=:F@03CUUBNE9i00=BN@IFV@EJ^@ENf@09I_UR
nFKiH_UVnF/IJcUW6F/i00A_F@=cV@03MmQcef_C07Uoo`00Rgoo01X0eQei6EPMNBgI<MX]^ChJ>OTn
6SWiASY2>DHj@SU6>TYICUU:FDijBUUBNDiiDYU>NE9i1UJI0eZi01UN^EZiH]UNfF;jG]URfF;iIaYR
nFLIH_U[>VLIJcYW6FmjJeU_NV]ILiUcV7OHLkM_e01jOol008]oo`040100eQei6GT4;MT2>QT00chI
>QU6>@02AST0148iBUU:FDiI0TYI1E9i1UJI1EZi1EkI00QVnF;iH_URnF/iIaU[>FLi16mI0g>I00=c
f7OHJm<0NWoo002<Ool0=@3g0=LMVAUh<MX]fC7J>OTn6SWi?QY2>DIJ@SU6FTYICWY:FDijBUUBVTii
DYY>NE:JEYUF^UJIE[YFVEJjF[UNfUZiF[YJ^F;jG]URnUkIH_YRnFLJH_UW6VLIJcYW6F/jJeU_NV]I
LkT00W>I00=cegOHJm<0Ngoo002=Ool0303g6GTMNBgI;MX]fBgJ>QTj6SXI?QY2>@96>@06ASY:FDYI
BUU>FDYI159i1EJI1EZi1EkI0f;i00UW6V;iJcYW>F/jIcU_FVmIKgX00g>I00=gf7?HJm@0Ngoo002=
Ool0>03g0?PINAfI;MTanRgI?QXinChJ>QU6FT8iAUY2>DijBUU>NTYICWY>NE:JCWUBVUJIE[YFVEJj
EYUNfUZiF[YJ^EkJG]URnUkIH_YNfFLJH_UW6V;iJcYW6F/jIaU_NV]IKgY_VG>jKiUcnG?HJmAlOol0
08ioo`080?LMVAUi7IT]fBgJ;MTn6P8j6P03ASY6FT8i0096>P09BWY:FDYjBUUBVU9iDYUBNE:J00=F
V@0AE[YJ^EZiF[UJfUZiG]YNfEkjG]UNfV;jHaYRnF<JIcY[>P02IcX00fmIKgY[F@02LiT2LmP00f_D
Oomoo`1kOol008ioo`0f0380mafJ6ITMVRgI<OX]fChJ>QTn>T8iAUY2>DIJBUU>NTYICWY>NE:JCWUB
VTiiE[YFVEJjEYUJfUZiG]YJ^E[JG]URnUkIG_YRnFLJH_UW6VLIJcYW>F/jIaU_NV]ILkY_VG>jKmQ[
eFODOGoo002?Ool02P0b0?LMVAfI;OX]fRgj>QXn6SXJ0dIJ00=2>TYjBWX00TYj0e:J00m>NU:JE[YF
^UJIE[YJ^U[JF[UJfUZjG_YNfUkjG]X016<J00a[>VLjIcYW>VmjJeYc^VnJLkYcf7?IImEnOol0091o
o`0R0380mafj6ITanRgJ<O/j6Shj>QY6FT8jAUY2>DijBUU>NTYIDYY>NE:JCWUF^UJIE[YBVE[JF[UJ
fUZiH_YNfEkjG]T2H_X03V<JH_UW6VLjJcYW>VmkJeY_NVnJLkY_VW?iImAoOol0091oo`0;03<5604H
7IX]nS7j;OXj>SXJ?SY2>P03AUX4BWX014jJDYYBVU:J15Jj15[J1Ekj0f<J0fLj00=_NV]jJgX00Vnj
00=_VVoIImD0P7oo002AOol0<00b1CPIVAfj;OXanbgj?S/j6Shk@SY6Fd9JAUY:FTijBWYBVTiiDYY>
VUJjDYUF^UJJF]YJ^E[JF[YNnUkJG_YNfUkjH_YS6f<JIe]W>V]KJgY[Nf]JLkY_VW?iImEWmX1oo`00
TWoo00H5>0Di7KXM^Rgj<O/3>SX014IJ@UY6FT9J0dYj0U:J00=>VU:JE[X00eJj15[J15kj0f<J0fLj
0f]j00E[NfnjKkY_fFOf085oo`00Tgoo01P0D`Di6IXb6bgj<Q/j>Shk>SY6Nd9JAW]:NTZKBWY>VdjJ
DY]>VUJkD[YF^U:jF]/2F]X04UKJG_]NnUkkF_YS>f<JHa]S>VMKIcY[NfMjJi]_VVnkKmUWmX9oo`00
U7oo00/0M0EI7KX^6bgk<Q/j>SXk@UY6Fd9J00A:NP03DYY>VU:J00AF^PAJfP=NnP06Ha]S6V<JIcYW
FfLj0V]k00E_^f^jKk]_fV?g08=oo`00UGoo02P5>AgK6KXb72hK<Q/j>ciK@UY6Nd9JCY]:NTZKCYYB
^djJD[]B^UKKD[YJfeKJF_]JnUlKF_YO6elJHc]O6VMKHc]WFfMkJia[^fnkJmUSmhAoo`00UGoo00@0
]@EI7M/Mf`8^6`0:>U/j>d9k@U]6NdYjBY]:Ne:kCY/2C[/02EKKD[]Ffe[KF_]FfelKG_]O6`03Ha/3
Ie/2Jg/2Jk/00f_jHoMoo`24Ool005moo`0?>[dngSZm?]hj_CkN>[dngSZm?]hj_CkN>[dngSZm02Uo
o`0U1ETMo1gK<S`^6ciL>S]6O49kAW]:NdZKBW]B^djJD[]B^UKKD[YJneKKF_]JnUlKF_]S>elKIeaS
FfMLHc][W6MkJka[fV?h@e00QGoo001DOol2=[h01CJN=[hf_SJn=Yh00cJn014fWSJn>[hngSZn?[hj
_SkN>[hn_SZn?]hj_Sjn>[hngSZn02Qoo`05@205NQgk7M/^?003>U`00d9l@W]2O002BY/3C[/2D]/0
1EKKE_]FneKkGa`00U/K00=O>ellHe`00V=L00IWW6MkJkaWneoh@e66Ool004Yoo`0V;YhZOBjN:Wh^
WRYm;YhZORjN:Wd^WSJN=[hbWCJn=Yhf_S:M=[hfWSJn<Ydf_SJN?]hj_CkN>[dngSZm?]hj_CkN>[dn
gSZm?]hj_BUoo`0P1IXMo1gk<S`^?3Yl@W]6W49kBYa6Ve:lC[]B_5:kE]aBfe[lE]]O75[kGaaO6f<l
He]SG6=kIiaW_6_LHm]KnHQoo`00Agoo00@ROR9M8WhROP/^WP8f_P05=Yhf_SJn=[hfWP03=[h01CJN
=[hf_Sjn>[d00cjn00Dj_Cjn?[hn_SZm00<n_P03>[eoogoo02Moo`051IXN71hL;U`^?002>W`2@Y`0
1dZlBYa>_4jlD]aBfe;L009Fo09K709O?09SG006HiaWWF>LIkaWne_iRGoo0012Ool0;bIn8UdVOR9M
9WhRGBIn8UdVOR9M9WhZOBjN:Wh^WRYm;YhZORjN:Wd^WSJM=[hfWCJn=Ydf_SJM=[hfWCJn=Ydf_SJM
?[hj_CkN>[dn_SZm?]hj_Cjn>[dngSZm?[h0:Woo01a<828L;S`bGCIl>YdfO4:mA[a:_DZlC]eBg5;l
C]aG7EKlFceG75mMFcaSOEmLHieOWFOMGm/oM8Yoo`00?Goo1aHm0R9n00DRGB9n8WhROR9M00<ROP0<
;Wd^WRin;Yh^OBjN;Wh^WRim;YhfWSJn0cJN00Df_SJN=YhfWSJn00<fWP03?[hj_Cjn008n_P05>[dn
_Sjn?[hj_@03?[hZOol02P2B0EPN72iM>WdjWCjm@[e6_DKM0T[M00=>oELMDad00eLm00IKGEmmGgeS
WEnmGm`2>gEIOol7Dmd[Ool003Yoo`0i1Q`5n`XL1O/671Hm6UdF?AIM5SdJGAHm9WhRGBIn8UdVOR9M
9WhRGBIn:Wd^WRim;YhZOBjN;Wd^WRYm;Yh^OCJN=Ydj_SJM=YhfWCZn=YdfWSJM>[hfWCjn>Ydn_Sjm
?[hjWCjn?[dn_SZM?[hn_Cjn02]oo`0?0?@9nbin=YdjWSjMA_i2gD[nB]e?7U<MDciC?EMN009KG@05
FgeO_U^mCm/gE@1HOol02eOMDkaCgE>lEmeC_5?MDkaGgD^kCm`0:Woo000jOol00`6I1O`5n`031O`0
0`Gk5SdF?@045Sd08BIn8UdRGR9M9WhRGB9N8UdVOR9M;Wh^OBin;Wd^ORim;Wh^OBin;WdfWSJM=Yhf
WCJN=YdfWSJM=YhfWCJN=Ydn_P03?[d01Cjn?[dn_Cjm?[h00cjm00<n_WooOol0:Goo0P4e00TNORZN
=[hjgSkN@_i77T/NCch00e=N00ECOU]nDgiCWP0005Uoo`03EmeGg5OM00ECg@05Cma;^d^kBk]?g00Y
Ool003Uoo`090IT1^P6I0KX5n`XL1O/5o0GK00<F?@0`5Q`F?AHm5SdRGBIn8UdVOR9M9WhRGBIN8Ud^
WRim;Yh^OBjN;Wd^WRim;Yh^OCJN=Ydj_SJM=YhfWCZn=YdfWSJM>[hfWCjm?Ydn_SjM?[dnWCjn?Ydn
_CjM?[hnWCjm;Goo00lBOAjM7Yh^gS[o@ai7?dLnCem;GTnOAii;_T>M2000FGoo00iGgE?LEmeC_5OM
DmaGgD^kCma;^doLBk]3^CnH:Goo000kOol02@6i0IT1^@Gk1O`5n`Gl1O/5o0065Sd38Ud01BIM8UdR
GB9M9Ud00R9M00T^OBin;Wd^ORim;Wh^OBin;Wd033JM00<n_CjM?[d00Sjm00DnWCjm?[dn_CjM008n
_C1oo`04400J_B;N<al2=cl00c=M;cd0001KOol00eOMEmaGg@02Emd025OLCm]?fdoKCk]?fcnI@iT2
;cDYOol003]oo`0k;00`006I0IT1N@Gl1M/5o0GK1O`F71Hm5Q`F?AHL5SdF72In8UdVGR9M9WhRGBIN
8UdVORim;Wh^GC9n;Wd^ORiM<Wh^OCZN=WdjWSJM>YhfOCZN=YdjWSIm>YhfWCjm?Ydn_SjM?[dnWCjn
?Ydn_CjM?[hnW@2AOol045OLFmeGg5_MEmaKgDnkCma;^doLCk]3^CnH<eD_=C=E:Woo000mOol00b`0
0AD1V@020IT00`GK1M`5f`021M/03aHm5QdF?AHM5SdF7AHm8UdVGB9M9UdRGBIM8UdVG@09;Wd<=Yd0
1Cjm?YdnWCjM?[d00cjM00@n_CjM?YdnWHioo`0@EmeGg5_MEmaGgEOLDm]?fe?KCm]Cfd>H@iU3V3=E
;cD/Ool003moo`0h;001=@5h0IT1N0Gl1M/5o0GK1O`B71HM5Q`F7A8L5QdR?BIM8SdVGR8m9UdR?BIN
;Wd^ORiM<Wh^OBin;UdbORim>YdfOCZM=WdjWCIm>YdfOCZM=WdjWCIm@[dnW4:m?Ye2_CjL@[dnWD:m
?Ya2_Heoo`0?FoeKg5_mFmaKoDnkDm]?fe?KCk]Cfd>H@kT_=3=E02ioo`00@Goo00<15@5i0GT00P5i
10GK02@F71HM5Q`F7AHL5QdRGBIM8UdVGB9M9UdRGBIM;Ud^OBiM;Wd^GBim;Ud^OBiM>YdfOCZM=Wdj
WCIm>YdfOCZM=WdjWCIm?[d3?Yd01Cjm?YdnWCjM?[d00SjMRgoo0U_L00=KgE_LFm`00U?K00M?fe?K
Cm]7^4>H@kP_=00`Ool004=oo`0f0?@1V@5h0GT5^`GL1K/5fa8L5QdF71HM4Q`F7B8m9UdR?2IM8SdV
GB8l9Ud^GC9m;UdbOBiM<Wd^GC9m;UdbOCIl>YdfO3Ym=W`jWCIl>WdfO3ZM=Wa2WCjL@YdnW4:M?Ya2
WCjL@YdnW4:MQ7oo018D01P0500H01@0FoeKg5_mFmaKoE?JEo]CfU?KDmY7^D>H<e@bOol004Aoo`05
0?@1N05H0GT1F0031M/041Gl5Q`Eo1HL5O`F728m9SdR?BHm8SdV?B8m9SdR?C9M0biM00HbGBiM;Ud^
GC9M=W`3>Wd04SIl>WdjOCYm=W`jOCjL@YdnW3jM?Ya2WCjL?YdnW4:M?Y`nWGUoo`05900P0200800T
000380000b@0500D000250001U_LGmaOg5olFmaOg0ACf`97^003<cAoogoo039oo`00AWoo00D0m05H
0GT1F0GK0085^`0^1KXF7AGl5QdAo1HM5O`V?B8L9SdR?2Hm8Q`V?B8l<Ud^G39m;U`bGBiL<Wd^G3Ym
=W`jWCIl>WdfO3ZM=W`jOCIl>YdnO4:L?Wa2WCil@Y`nO4:M?Wa2W3il@Ye]Ool08b`2:04/0RP1;08X
0B`2:04/0RP1900P02@0800T0200900P01P0500H01@0GoeKg5olFmaOoE_LGoaCfUOkEmY7^4NGAkP0
=Woo0018Ool00`3D0EP1>0051K/55O`00bHm8S`V?@029Sd0128l9Sd^GC9M0biM00@bGBiM;Ud^G@/j
O00;?Ya2W3il@Y`nW4:L?Wa2W3jL@Y`nO01QOol00c@3=2<d0`02=0<043@S=0<d0c@3=2<d0b`2;04/
0R`1;08/0B`2;04/0R`122@1014H01@0600H06?lGmaOo5oLHoaOg5OKEmYGfeOJBkM7]c<c03Moo`00
BWoo0501F04h0EP1VPFk0IX5^a7l5O`Ao1Gl4O`Eo28L9SdR?2Hm8Q`V?Bhl<Ud^?39M;S`bGBhl<Ud^
?3Ym=U`jOCIL>WdfG3Ym=U`jOCIL@YdnO4:L?Wa2WCil@Y`nO4:M?Wa2W3ilE<E@a5C5D<ADaE35D<I@
aE36D<E@aU35D<I@aE36D<E@aU35D<I<YU36C<I@aTbVD<I<aU36C:I@aTc66goo0TB600I0ITB7A8I4
QT1VA8L2A8H0>T1VA8M4QTB6?4E0ISa5@6HlAD1V?4E0ISa5@6HlAD1V>2@lACPT?2Dh93a5>2@l9CPT
?4Dh93`U<0<d93@3=2@`0c@T=0<d9303=2@d0c03;08`0b`2<0</0S03;08`0b`2904P0B@1804T0B01
904H01`00aP000`L05oLHoaOff?lGmaKnUOJFo]7Ud^hAiLiOol004]oo`0:@0015`4h1IX5^`FJ1I/5
VQGl5M/25M`04AGl8Q`V72HL9S`R72HL;U`bGBiL<U`^G39M;U`bG2iL<Ud02CYl2d9l00EDiECVE>ED
iUCU009@a@05D<I@aE35D<E@aP03D<D01E36D<E@aDc6D<H00dc600E@aTc6C<I<aU3600=<aP06C<M8
YTbVC:I<adRV0TbV00E<adRVC:I<YTc700=8YP05B:M8YTRVB:I8Y`03B:H00dRWB:I4QP0<A8H0341U
@6I0AD1V@6E0IT15@6I0ID1V@4E0IP8lAP05?4DlASa6?4HlA@03?4H013a5?4Hd93@U0c@T00Hd9C@T
=2@d93@U;083;0<03R`2;0</0b`3;08/0b@1908T0B@2904T0R@19086600025oLGoaOg6?lFmYKnU_J
FoX2BkLkOol004aoo`1e0;@15`4h0AL5VP5j1I/1NQGl4M/Eo17K5O`R72Hm8Q`V?B8L9SdR739L;S/b
G2hl<U`^>c9L;S`jO3YK>W`jG3Yl>U/jO3YL>W`jFd:L?W]2W3ik@Y`nNd:L?W]2W3ik@Ya@aECVE>ED
iU35E>M@iUCWD<IDie3VE>M@aUCWD>IDie36E>M<ae3WC<M@idc7D>M<ae3WC<M@idc7D>M<adc8C<M@
j4c7C<Q<ae3XC<M<b4c7D>Q<adc8B:M<b4RWC<Q8Ydc8B:M<b4RWC<Q8Ydc8A8M8Z4B7B:M4QdRXA8M8
YdB7B:Q4QdRW0094Q`12@6I0Qd1VA8M0IT27@6I4Qd1V@8LhACa6?4DlASQ5?4HlACa6>4DlASa5?4Hd
9CPV=2Dh9S@U>2Hd9CPV=2Dh9R`4<0@/0c04;0@`12`3<0@/1304904X0R@1:08T0BP2904X0QP0704H
01`1600L0F?KHoaSffOlFmUOnU_ICkM;]dng?7oo001>Ool02D@00AL15`FJ0GX5VQGL5O`Ef`025M`0
0aGl9Q`V70059Q`00c8l;S`b?002<S`00bhl<S`b?00:>U`:@W`04UD7E@IE1eD6E@ME1UD8E@ME25D7
E@QE1eD8E@ME25D7E@QE1`=@i`05D<M@ie3WD>M@a`03D>L01537C<M<adc80dc700E<b4c7C<M<adc8
009<a`0<B:M8b4RWB<M8YdS8B:M8adRWB<Q8YdS70TBW00E4QdBWA:M4YdB700=4Y`0?A8M4YdBWA8Q0
QdB8@8M4R427A8Q0QdB8@8M4R42700/lI`0;>2Dh9S@U>2Hh9CPV=2Dh9SPU>2H/1003<0@01R`4<0@`
1304;0@`10PX0`0=604L0AP1704H0F?lHm]So6?KHoaKfUojFoX00Tnf?Woo001?Ool0X`1b0AL0m`FJ
0GX5Va6k5M`A^aGL4K/Eg27k9Q`Qo2HL8O/V727l<U`^>c9L;S`bG2hk<U`j>cYL>S/nG3Xk>U`j>ciL
>S/jG3iK@Wa2Fd9l?U]2O49K@W`nFd9l@U]I1eCVF@MDiUT7E>IE253WE@Q@ieD8D>ME253WE@Q@ieD8
D>QE253XD@Q@j5D8D>QA253XE@Q@j548D>Q@jDcXD>U<j53YC>Q@jDcXD>U<j53YC>Q<jDS8C>U8b4cY
B<Q<jDS8C>U8b4cYB<Q8bDBXB<Q4Z4S9A:Q8b4BXB<U4Z4S8A:Q8bD27A:Q0QdBX@8M4Z427A:Q0QdBX
@8M0IcaV@6LlAT1W?6I0Ica6@6LlIT1W>2HhAcQ6>4Lh9SQ7>4HhAcPV>4L`1C0U<0Dd9C05<2D`1C@U
<0DX0b@2:0<T0RP3908X0b@2008L0@0>708L0A`1705Wo6OKIo]WffOlFmUOnU_ICmM?]Smoo`00DGoo
00<0LP4G0GX00P5j0QGK00@AfaGK5M/Ef`<Un`0=9O`UnbGk9O/b?38K<S`b>c8l<Q/b?3YK>U`00cYK
00DjG3YK>U/jFcYL00Y2N`9I:00LF@MI:5TXFBQI1eDYEBQE:ED8EBUE:5DYE@QE:EDXEBUA2ED9D@UE
2E49E@UA2ED9D@UE2E49E@T3C>P01E3XC>Q<j4cXD>P00dcX00I@j4S8C<Q<b4c9B<P2C<P01Tc9B<Q<
b4c8C<U4Z098Z006B<Q4Z4RXB:Q8b4BX0TRX00=8b4BXA:T00TBY00E4Z4BYA:U4ZDBX00=4Z@0=?8Q0
R3b8@8PlR428?8Q0R3b8@8PlR3Q7>4H00cQ700dhASQ7>4LhAc0V=2H`9S@V<2Hd9S0V=2H`9P08:0@6
70401FOkIm]WnfOKIo/00eoi0Tnf@7oo001BOol0UP0a0=H1NP5I1GX1FAFk4KXE^a6j5K/QnbHL8O/U
o27k9Q`^6c8l;Q/b?2hK<S`^6c8l>S/jG3Xk?U`j>cYL>S/nG3Xk@W]2FT9k@UY2Nd9J@W]2FT9k@UYM
BETXFDUI:5e9FBQIBED8FBUE25DYE@QI:ED8EBUE25TYE@QE:E49EBUA2EDYD@UE:E49EBUA2EDYD@UA
2TcYD@Y<jE4:C>UA2TcYD@Y<jE4:C>U<jTSYC@Y<jDcZB>U=2TcYC>Y8jDd:C>U8jDS9B>Y8bDSYB<U8
jTS9B>U8bDSZA:Q4ZD2XA<U4Z4BY@:Q4bDBXA:U0Z4C9?6M0R3aW@8PlId28?6M0R3aW@8PlIcaX>4Ll
J3Q7?6PhAcaX>4LlJ3Q7=2L`9S@W<2Hd9c0V=2L`9P8X100F;0DX12P4:0@/1BP480<L0R03708P0a`2
Jo]WfV_kImY[neoIHoYOfE?FCkE1Ool005=oo`80eP@1F@055K/A^aFk5K/Uo0039O/00bGl9O/Un`08
<Q/9>S/:@U/04UU9FBUIBETYFDUI:EU9EBUI:UDYFDYE:ETZEBUIBUDYFBYE:@]E:P9A:P05D@YA:U4Z
DBYA2P03DBX00e4:DBY=2P0;C@X;B>X3A<X01DC9A<Y4bTC:A<T00dC:00a4bD2Y@8U0ZD29@:U0RD2Y
@8U0ZD29?6P3>6P08CaX>6PhJ3QX?6PhJ3A8=4LdB3@W=4PdAcA8=2L/1BP5;0HX1B`5:0D/1RP580<L
0b03708P0a`3405[fV_kJm][n`03HoT00e>fDkEoo`11Ool005Aoo`0A0;H0]@5I0CT1FP4i5K/A^QFk
4KXUnb7J9O/QfRGk8MXUn`02<Q/0:RhJ<Q/b6c8K;QXnFcXk?U/j>SiK>S/nFcXj?U]2FT9k@UY2Nd9J
@W]2FT9k@UY2NeU9GFYIBEeZFDUMJUU9FDYE:EU:EBUIBUDYFDYE:EU:EBUIBP9E:P06DBYEBUDZEBYA
:UE:0UDZ05EA:U4[D@YA:e4:DB]A2U4[D@YA:e4:DB]A2U4;C@YA2dcZD@]=2U4;C>YA2dd:D@]8jTcZ
B>Y<jTSZC>Y8jTcZB>Y<jTSZC>Y4ZDS:A<U4bTBYB<Y4bDC:A:U8bTC9A<Y0ZDC:@:Y4bT2YA<Y0ZTC:
@:TlRCQY?8ThJ3b9>6TlRCQX?8ThJCA8<2LdB3@W=4P`9cA8=2L/1RP5;0HX1B`6:0D/1RP580@L1003
80@02a`4405WfV_kImYWnF?hIoUSn5OEDk@0@goo001EOol02`2f0;D1>@4H0CT1>1FJ4IXEVQ6J9O/0
0bGK00<UnbGK9M/01c8K0SXj00Ln>SXJ>SXj>Shj>QXj>P0:@UX04UU:GDYIBUeZFDYMBUU:FD]IBUU;
FDYIBeU:FD]IBUU;FDYIB`]EB`9A:`05ED]A:e4[DB]EB`03DB/09EE;CB]A:dd[DB]=:e4[CB]A:dd[
DB]=:dd;B@]=2dT;C@]92dd;B@]=2dT;C@]92dS[A>Y8jdC[B>]4jTS[A>]8jdCZB>]0ZT3:00=0ZP04
@<Y0ZT2Z@:X:?8T023AY=4TdJCA9=6TdBCAY=4T8;2L680@01A@2JmY_fVoJKoX00fOh00=G]E>dOol0
@goo001FOol0?@2E07@1>@4H0CTAVQFJ4IXE^a6J9MXQ^RGK9KXUfR6j<Q/anS8K<OXb6c7j<Q/anShk
>QXn>cXJ?S/j6Shk>QY6Fd8j@UY2>TIK@SY2FT8jAU]2>Uf;FFYMRee[GH]IJUf;GF]IK5U[GHaIJeU/
FF]MS5U[FFaIJeU;009EB`06EB]IBeE;ED]E:eU;0UE;021A:eE<DB]EC54[EDaA:eE<DB]EC54[DBa=
2e4/C@]A;4d;DBa=2e4/C@]A;4T;C@]8jdd;B@]=2dS[C@]92dd;0TS[03e4bTS[A<Y8jdC:B>]4bTS[
A<Y8jd3;A>]0bdC[@<]4jd3;A>]0bdC[?8XlZSb:@:XlRSbZ?8Y0ZSb:>6TdB3QY=4PhJCA8>6TdB2`W
:0H/9b`V;2LX1R`W;2HT1R0590HP1B@680DD0V_JKoY[fVojIoQ[n6OhFm@00015Ool005Moo`0709D0
M04i0AP1>A5i5GX00a5i00<UfRFj9MX00RGJ00@U^S7j<OXb6P<anP06<QXj6SXj>SXn>SXJ0SXj00dn
>SXJ@SY2>D8j@SU2>T8i@SY2>D8jGF]MR`03GF/03Ef;GF]MJeU[FFaIJeU/FF]IK5U[FFaIJeU/00=E
K005FFaEK5E/EFaIK003EF`00eE<DDaEC002ED`04E5<EDaEC5E<DDaEC54/DDaA;55<DBaAC54/DDaA
;55<DB`00dd/00E=34d/CBa=;4d<00==;00EB>]934S/B@a8jdT<B>a934S[B@a0bdC;@<]4bd3;A<]0
bdC;@<]4bcb:00<lZP0@?8XlZSbZ?:XlRSR:>6XhRSAZ>8XhJSR:=6XhRR`X<2P3;2P01S0X80DP1R06
90HP1@8P1P0650A_fG?IKmUcfFoI0VOh00=K]7ooOol0AGoo001HOol0L@1D03<1603g0APANAEj4GTE
VRFj9MXQ^RGK9KXUfS7I<OXafC7j<MTanS7I<OXj6ChJ>QTn6SXI?QXj6ChJ@SU6FT8iASY2>DIJ@SU6
>T8iAUYMS5f/GH]Q[5f<GJaMRf6/FHaMSEU/GHeIS5f=FFaMSEV<FFaEC5U/EDaIK5E<FFaEC5U/EDaI
K55<EDaAC5E]DDaEC55<EFeAC5E<DDaACDd/DDa=;55=CBaAC4d/DDe=;55<B@a=;4d<CBa934d/C@a=
;4T<CBa=34T]B@a9;DT<BBe934T]B@a9;DT<A@`00TC/02m0k4D<A>a4k43/A@a4k43;?:]0c3b[@</l
Zd3<?:]0bcAY>8XdJSR:=6ThRSAZ>8X/BC1:;4T`BRa9<4X/BB@780LT220790LP1a@4KmUcnVoILoY_
fFogJmMO/`0004Moo`00FGoo00T0D`3h0AP0ma5I4EPAFA5H4ET01RFi01TafC7j<OTanS7I<OXanChJ
>QTj6SXI?QXj6CXJ>QU2>T8i@SY2>D8j@SU2>T8i@SY2>@08GH`055V=FHaMSEV<FHeIS5f=FHaISEV<
FHeIKEV=FFeISEU]FHeIKEV=FFd;EFd;DDd01De=CBe=;Dd]CDd00dd]00I=CDd]B@e93DT]B@`2B@d0
14T]B@a93DT=2TC/01Plbcb[@</lZcc;?:]0bcb[?</hRcR[>8/hZcR;>:/hRcR[<4T`BS19<4X`BC1:
<4T690L01Q@650Ecf7?HLmUcf09[m`03KoMK/Woo04Moo`00FWoo04D0E03F0=L0eQEI4EPEFA5H9KXU
VBFj8ITU^RFI<MTa^3GI<KPafC6h=MTin3hI>OPn6CWh?QTin3hI>OQ6>D8HASU264Hi@QQ6>D8HASU2
667=GJeQ[Ef]HLeM[F6]GJeM[UV=GJiISEf^FHeM[UV=GJiISUV^EHeI[UV>FJiESEV^FHiI[U5=EFh0
0UE]02IACEE^EFeEKE5=EFiEKE5]DDeAKU5=DFeACE5^DDeAKE5=DFi=CU5>CDiAKTe>DDi=CU5^CDiA
CTT]CDi9;Dd^BBe=CTT]CBi9;De>0TD=00I4kDT>A@e53DC]B@h2A@d04Sc<@>dlc43]?<a0kCc<@>dd
RcR/>8/hZcB;>:`hRcR[<6X`R`8`J`0C<6X`Rc1[92TT22PY92PT:B@860HD1GOILkQgfG?HLoI_eW?f
Fk80BGoo001JOol02DbP0380eP3G0=HAFA5H4ETAF0029IP012FI9IPUV2FH1c7I02<inCgi>OTmnCWi
?OTinCgi@QU6>D8I@SU26DHi@QU2>D8IASUM[F6]GJeQ[Ef]HJeM[F6]FJeM[Uf]GJiI[Ef^GJeM[UV]
00]ISPYESPYAKP==CP05DDi=CTe>CDiACP03CDh00dT^BBe9;P02BBh01DT]BBi9;TT^BBd02DD=00=0
kD4>@>d00T3]00a13T3]@>e0kCS=>:`hc3R/><dh[3S<>:`6<6/392T03B@X92TT:AP750LH1g?HLmUc
f6ofKmIcmVoF04Yoo`00Fgoo03X04P2f09D0]P2E5CPA=a4h4ALUVBEh9ITQN2FI<KPafC6h=MTa^37I
<KPmn3WH?OPiecgh>MPmn3WGAQQ1n4HH@OQ6647hAQQ1n4HH@OQQcUg>HLiMcV7>GLiQcUg>GLmI[Ug?
GJiMceV^GLmM[Ug?FJiM[`9I[`06FJiM[eV_FJmI[Uf_0UV_00QESeV_EHmI[eF?FJmESeV_0UF?00QA
KeF?DFmESe5_EHmAKeF?0U5_04A=CU5_CFmAKde>DFm=Ke5_CDiAKdU>CDm9CTe?BDi=CdU>CDm9CTe?
A@i9;dD>BBi53TT_A@i9;TD>@@i0kD4>?>e13T3]@@hlkCc=>:`lcCR/?<dh[3c=>:`d[C2<=8d`S3B]
<8`dSB@Z:2/T:RP[92XX:a@760PD1gOHMkMgf7?DMmEce6>aBWoo001KOol02ED00100U@2E0;DA=a4h
4CLA>0039GL00bEh9GLa^007<KP04Cgh?MPmn3WH?OPmf3gh>MQ6648HAQQ264HH@QQ6648HAQP0267>
00YM[Ug?GJiMcef^GLmM[Ug?GJiMc`YI[`0XEHmE[eF?EJmESeF_EHmE[eF?EJmASeF?DHmESe6?EHmA
SeF?DHmESde_DFm=Ke5_CFmAKde_DFm=Ke5_BDi=CdU?CDm9CTe?BDm=CdU>CDl9ABh04D4?@@i13d4>
@@m13T4?@@i13cS=?<hhcCc^><dlcSS=?>h00c2<00TdS32<<8`T:RPZ92XX:R@Z:2X00aP900=gegNg
MkL017?EBgoo001MOol0BP1C07@0Da4G3?HA5a3f4ALQEbEh8ELUN25G=KPa]c6h<ILe^36g<KPiecgh
>MPmn3WG?OPif3gh@OM5n47gAOM1mdGh@OM5md7gHNmQcf7_GLmQkf7?HNmMcf7_GLmMl5g?HO1Mceg`
GLmQl5g?GM1I[eg@FLmMd5V_GM1Iceg@FJmId5F`FM1E[eW@EK1Id5F_FM02EK00@e6?EK1AT5F`DHmE
/56@EK1ASe6@CFmAT4e_DI1=Ke6@CFmAT4e_CG19Cde`BDm=L4U?CG19Cde`BDm9D4D_BDm5;dU@ABm9
CdD_BE113T4?@@i5;d4>@@m13TD_><dlkSS=?>hhcCc^><dlkS2]=:h`[CC><:dd[S2]:6`XBbQ/94/X
K2Q;00<H2@07MiIk]WNFMmEce7OEHfl0Bgoo001MOol02@0?05@0M01d4AH@mQ4F4?HUN0039GL00bEh
<ILaU`05<IL00cgG>MLme`02?ML033WG?MLmedGg@OM5md7gAOM1mdGg@OM5m`UQk`0;GM1Mceg`GLmM
d5g?GO1Mceg@FM1Md003FM006Eg@FM1Id5W@GM1E/5V`EK1I/5F`FK1E/5V`EK1I/5F@EK1AT5F`EI1E
/56@EK1ET5F`00YAT00KCFm=L4U_CG1=Kde`BFm=L4e_BDm5;dU?ADm9CdD_BDm5CdU?@Bm1<44_AC11
;d4`@Bm5<44_008lk`0<?@llkcc_?>lm3cc_=:hd[CB^<:dd[SB]1RQ<00@H:aP;72]g]P=k]P=g/dao
o`00GGoo05@03P1d05<0M0cE4=D<e13e8CHUER4f9ELQ=REF<IHeUc6F<ILaUSFG>KLmecVg?MLi]cgG
>KLmed7gAOM1mdGh@OM5md7gAOQ1mf8@HO1V467`HQ1Ql6H@HO1R45g`HQ5Ml67aGO1R4Eg`HO5Ml68A
FM1MlEW@GO5Id5gaFM1MlEW@FM5Ed5WAEM1IdEG@FM5Ed5WAEM1EdE6aEM5A/5GADK5EdE6`EM42DK40
@Tf@DK5AT56aCI1A/E6@DK5=T4fACG1=TDU`CI5=L4fABG1=TDE@BG15D4UaAE19L4E@BG55D4D`@Bm5
<44_AC11;dD`@Blm3cS^?@lhkSd?>>hm3cS^=>l`cSC_=<ldkc3>=>lXKBR>:6d/SRQ]:8hH2Q`[60]k
UG]dOiEg/gOCMk=WKDaoo`00GGoo00@03P0b0380<P@@e@<UEP039CHUEREF00HaU`<m]P0A>KHm]Sff
?KHi]Sff@MI5eT7FAMI1eTGF@MI5eT7FHQ1Ql003HQ005V7`HQ1R45gaGO1MlEg`GO5Ml5gaGO1MlEg`
GO5IdEgaFM5MlEWAGO5IdEga0UWA00EEdEWAFM5IdEGA00=Id@YE/@0CDI5A/E6ADK5ATE6aDI5A/E6A
CI5=L4fACG1=TDe`CI5=L4fACG000TU@00E9L4U@BE19D4U`0099D00:@E55DD5@AE51DDEA@E15DCd@
?C03?A000cd`?A0m4006=<l02BQ]:8dXKBR=:6dXSAP;72/H2`03NiD017^DNi5kTG^aCGoo001NOol0
UP0<0380<PbC4;@<Ta2d8A@U=B4E9CDQ52De<GDaMS5e=GHaMC5f<GDm]SVF?KHiUSff>IHm]SVFAOM1
eTGg@MI5md7FAOM1eTGgHQ5V<F8AIS5R4FHaHQ5V<F8AHQ9MlF8BGQ5R4UgaHQ9N4F8BFO5N4UWaGQ9I
lEhBFO5N4UWaFO9EdEWbEM5IlUGAFO9EdEWbEM5EdU7AEM9EdEGBDM5EdUGAEM9AdE7BDK5A/U6aDM9A
/E6bDK5AdTfACK9=TDfbCI5=/TfACK9=TDfbAG59TTUaBI55LDVBBG59TDEaAE51D4EA@C15DD5@AE51
<3d`?A0m<3T??C0m43d`<<hdkcC?=>l`cSC_=<l/[bR>;:lXSRb_:8hL;AP/72ekM7nENiAkUGNANk9W
:Teoo`00GWoo00T0300@010040bC4;<</a2d8AD00RDE00<U=B4E<GH00S5f01DaMC5f<GHaMSVE?IDi
UCfE>IDmUCVE?IE1]DFe@KE5eD6eAKE1]DGE@KD00V8A00ER<F8AHQ5R4F8a009R4@0CGQ5R4UhAHQ5N
4F8BGQ5R4EhAGO9IlEgbGO5MlUWaGO9MlEgbFM800eWb00IIdUWbFO9IlUWBFO8:EM801E6aDK9A/U6b
DK400e6b00AA/DfACI5=TP==T@03CI9=TDfA00U9L@03AG95LDEb0095LP04AG55LTEbAG87?C47=?00
0bR_;:lXS`02::l021`]62`L;A`]Og=kLgmcNg<2Nfl00f];Oomoo`1;Ool005ioo`1V00X0400@010@
]0bC4;@<TbCd8?<U523c9?@a=35E<E@aEC4d<EDaE3fE>G@mUCVE?IDiM3fE>IE5eT6eAMI1]DGF@KE5
eT6eAMIR<VIBHS9V<V8bIU9R<VHbHS9R<ehBHS=N4V8cGQ9R<ehBHS=J4UhCFQ9N4eXBGQ=J4UhCFQ9N
4eGbFQ=IlUXCEO9J4eWbFQ=ElUGcEM9EleGBEO=EdUGcEM9EleGBDM=A/UGCDM9Ade6bEM=AdU7CCK9A
/dfbCK==/U6cCK9=/dfb2DVB02M1DDEb@E55LT5AAG91DDEb?C4mDCda@E4m<CeA?C51DCC`=A0dl3TA
=?0e42R`;=4Xd2cA:;0/dAa>76lHCQa_Ne=oLg]BOg1kKgm`I`L0CGoo001NOol03P0900h03P0>374@
LPaa378PlbCd8?<Tlb3c<ED3<E@05C5E<E@aE3VE?IDiUCfE>IDmUCVE?IE1]DGE@KE5]D6eAME1]DFe
@KEV<P03HS803FHbHS9R<V8bIS9N4V8bGS9R<UhBHS9N<V8b00=N4P05GQ=N4UhBGQ9N4`03GQ8075XC
FO9IleWbFQ=IlUWcFO9J4eGBEO=ElUGcEM9EleGbEO=EdUGcDM9Ade7BDM=AdU7CDM9Ade7B2Dfb2DVB
00Q5TdEcAI=5LTFCAG=5TdEb23eB0SDA00He4SDA=A4e4Bc@:=03;=001BS@74hLCQa_74h00Wla00Ao
DG/]Obek;Dioo`00GWoo02eVPP0>00h03A1b374@LPaa9A@PlbCd8?<U534C<C<a4c4d<A<a<c4C?G@i
Lced>E<mM3Uc?G@iDdFe@IA5]D6DAKE1U4Fe@IA5]FIBIU=R<VICHU=VDf8bIU<00V9C06IN<f9DGS=R
DehcHUAN<f9CFQ=N=5XCGSAJ4ehdFQ=N=5XCGSAJ4eXDFQ=J55XCFQAJ4eXDFQ=F55GcFQAEleHDEO=J
55GcEQAEleGdDM=Am57CEOAAde7dDM=Em4fcDM==/e7DCK=AddfcDMA=/dVcBI9=/dVCBK=9TTfcBI=9
/d5bAI=5LTFC@G95TdEbAI<mDT5c?E91DSeB@G<mDSTb=A4i<SDA>C8e4CTb;?4/lRSa;?8/lBcb770P
T1a`891k<GmBNc5oCG//Ode>Ool005moo`802`0500`<;```330<D0038=800bCB8=8a<`06<C<06SUd
?G@iM3ed>G@mM3Ud?GA1U46d@IA5]46D@KA1U4Fd@IAZM69CIU=RDfICHU=VDf9CIU<2HS<01EhcHS=R
<f8cGS<00V8c00=N<ehCGS<00Uhc00EN4ehcGS=N<ehC009J4`05FQAJ4eXCFQ=J5002FQ<00eGcEQAE
l`02EO<03UHDEO=EleGcEQAAde7cDM=Ale7CDO=Ade7cDM<9CM<9BK<02DFdAI=5U4FCAKA5TdFDAI=1
L`03?G<02T5c?G<mLcDb>C<e<SDc=C8i<cDb0bcb00</lBcb790011b@0gl?00=k;Gm=J/D0CWoo001O
Ool0BP0;00`02`a@32l@D0`_9=8P/BCB8;8TdRca<A8/lC4B;?4a4Rca?E<i<SeC>E8mDcTb?E<iDTFC
@G=5U45cAI=1LdFD@G=5TfIcIWARDfIdHU=VM69CIWARDf9DGUARE5iDHUANE69DGUARE5hdGUAJ=5iE
GSANE5XdGUEN=5iDFQAJ=EXDFSAJ55XeFQAJ=5XDFQD3EQ@01EXEEQAF55HDFQD00UHD011Am5HEDOAF
557dEQEAm5HDCMAAm4gDDOA=e57dCMAAm09=e00PBK=9e4VcCMA9/dWDBK==e4FCAKA1TdFdAI=5]46C
AK@mLd5c?G=1M3ec@G<mLcUC=C8iDcDb>E<e<SUC;A8]<`8]4`0=;A8PdQba8;8L/B3BN`mo3g[_O`]j
jWl;JX80CGoo001NOol0100400`02`0;0P`^00@<3@`^890P/0<PT003<A8`lS4B008a4P09<?8iDcUB
?E<iDSUC>E8mDcUB0091T`0:AI=1Ld6C@I=5Td5c@I=VU6ZEHU@3IW@0169DIWAVM6Id2F9D0Uhd00EN
E5hdGSAN=5iD00=N=003FSAJ55Xd009J=004FQAJ=5XdFS@9EQ@:DO@01DgdCMA=e4gDCO@00dgD00E=
m4VdBKA9]4WD00=9]00HBMA5]4FeAKA5]DFdAKE5]4FeAKA1U3fD@I@mU46D?IA1U3EC>E@eE3UD=E<i
E3ED1BdC00`L/Abb7;8P/QbaO/ejcGk=N^Yk2W[ZIR1=Ool005ioo`0h00402@0900P<;PP=32hPT2Ba
890P/B2@9;4/lC4B;?4a4Rca<A8i4Cdb>C4m<STA?C8i<Cdb@E95LT5BAG91DTEb@E95LT5BJYEVU6JE
HWAVUF9dIYERM6JEHWARMEiDHWENE69eGUARMEiDHWEJE0=NE@0>FUANEEiEGUEJE5iEFSEJEEXdFUEJ
=EYEFSAJE@9J=@0jEQAJ=EHEFSEF55XeEQEJ=E7dEQEB5EHEDOAF5E8EEQEAm5HECOAAmDgdDOE=m57e
COAAmDgdCME9e4geBMA=eDWDCOE9e4FeAKA5eDFdAKE5]4GEAKA5]Ced@IDmU46D?GA1UCfD>G@eDcUd
=E<iM3EC>G@3;C@03S5E;C@PlacC8?@Ldb3cN/enkG[=O^efYg[8IR1=Ool005ioo`0500402@0932h<
3@0232h01R1_86hPKb1^86lPKP8`d004<?0/d33@<=08>C400d5b@E91LP02@G802D5B@G91LT5bI[EZ
]FIeIYERM002IWD00fJEHWAVM@02HWD01F9EHWERMF9eHUD00V9e2UiE2EXe0UHe00EF5EHeESEF=EHE
009F=@05EQEB5E8EDQEF5@03DQD01EHEDQE=mDgeDOD00dge00=AmDgeCOD00TWE00Q9e4WEBME9eDWD
BME5eDGF0dGE00]5eTGEAME5eD6e?IE1]Cfe@KDmUD6e008iM@05=GDiMCUe>GDeM@05;C@02AcC8?<L
db3C7==ncG[=O/ejc@02NZP00fHPOomoo`1;Ool005ioo`2E00001P0720/<30P;30`PKR1_86hPKb1^
<?4/d33a;=0`lBc@<?4i<Cdb>A4m<STa?C8i4Cdb@E95LT5BAG91DTEb@E95LT5BJ[IVUFJFHYEVUV:E
IYIRUFJFHYERUUieHYINMF:FGWERUUieHYINEEifFUENMUiEGWIJEEifGUENMUXeGUIJEEYFFSENEUYE
FUIJ=EYFESEJ=UHeFUIF=EXfESEJEU8EESIB5EHfDQEF=U8EESIB5EHfCOEB5TgeDQI=mE8FCOEB5Tge
COI9eDgfBME=mTWECOI9eDgfAME5eTFeAMI5eDGFAKE5eSfE@KDmUD6f?IE1]CfE>IDeM3Ue=G@iUCEd
>GD]EC5f;ED]EReE8ADLm24E7?@Q5@QcNZ]jRWj[NXYfI@02HL1<Ool005ioo`<01P0430`82``<20/3
84d0120]84d/[c2_0bb_00<`[bb_>A001cT@2D5A00=V]V[FHYD00VJE01YVUV:EIYEVUFJFHWERMV9e
HWIRMF9fHWERMV9eGWINEUifGUENMUiFGWINEEifGUIJEUYE0eYF00EJEEYFFUIJEUHe00=F=P0>ESEF
=UHfESIF=E8fDQIF=U8EDSIB5UHfDQEB=P9B5P0QCOE>5ThEDQI=mDhFCQEB5TWeBOI9mDWfBOE9mTWe
BOI9mDGfAMI5mTGFAOI5eTGfAMI1]Sff@MHm]T6f?KI1eSFF00<iUP04=IHiUSVF;EH3;ED02BeF;EDQ
5B4D8ADLm0bCNX]jZ`02NX/2MVD00f70Oomoo`1:Ool005eoo`2H0000100300@82@`:20T<2Q`/84dL
;21=;:h`cbb^<<l/[S3?;:hi43S`?A0hl3T@>?0m43S`@E51<45A@C11DD4`@E51<45A@C1ZefJfI[MR
UVJgHYIV]f:FI[MRUV:GGWIRUejFHYMNMV:GGYIRUeYfGYMNMUigFWINUeifGWMJMUjGFUIJMeYFFWMJ
EUYgFUIJMeYFFUMF=UYGESIJEeHfFUMF=UYGESIF=e8fESMB=UHgDSIF=e8fESM>5U8gCQIB=dhFDSM>
5U8gCQI>5dWfCQM9mThGBOI>5dWfCQM5eTGgAMI5mTGFAOM5eTGf?KI1eSff@MHm]T7F?KHiUSFE>IHe
UCVF=IDiUReE;EH]EC5f;ED]EQdE8CHM5B4f7AD<eGI8NVUfB7HSLP9Q`4aoo`00GGoo00D0000300@8
2@P:00882@8PC@0382dPCB1=00L/S@8hk`06>>hhkcS_>>lhkSS_0T4`00E1;d4`@C11<44_00=1<09V
e`9V]P06HYIV]VJfI[IRUVJf2F:F00ENMeifGWINMUig00=NMP0=GWMNMUYfFUIJMeYFFWIJEUYgFUIJ
MUIFEUL00eIF00EFEeIFEUIFEUIG00=B=P06ESMB=U8fDSIF=e8f0ThF00EB5ThFCQI>5U8F009>5P09
BOI:5TWfBQI9mTXFBOI:5TWf00Q5m`0:@MLmed7G?MM1ecgG@MLmecVg=KL3>KL013Fg;GH]MReg0bef
1B4f00@8]7I9MTUjJ@=b0Taoo`00G7oo02l0000100800@P820L820P782/L:b0[72XP:bb=;8h/SC2>
;8d/SSC>>>lhcSS_=<hhkcS>>>lm3d4`@@m1<3d?@C113d4`?@m1<6KGJ]MVeVKGH[MV]f:gI]MR]fJg
009R]`0BGYMR]ejGH[MNUf:gGYMR]eYgGYMJMejGFWMNUeYgGYMJMejG2UYg00QFEeIgEUMJMeIGEWMF
EeYg0UIG049B=eIGDSMFEe8gEUMB=eIGCQMB=dhgDSM>5e8gCSMB=dhGCSM:5dhGBQM>=dXGCQM:5dhg
AOM65dGfAQM5mdHGAOI65cgG@MLmeT7g?MM1ecgF@OLe]SVg=IHi]cFf>KL]MS6G;GH]Mbef<ILMEb5G
7CHQEaeG8EL8eGHWLPIf8g82MR=<Ool005aoo`0300000@0100@81`0582/L:b0[72/P:`07;8d00cS=
=:dhc@02><d01CB]><dhcD4??@h00T4>00I13cd>@@i13T4??@h2I_P02VJgH[MV]f:gI[MR]fJgH[MV
]ejG0V:G00ER]ejGHYMRUf:g00YNU`YJM`YFE`9BE`05DSMBEe9GDUMB=`02DUL01E8gCSM>=dhgDSL0
0dhg00=B=dXGBQL01dXG0dHH00e65dHHAQQ664HG@OPmn47h?OM1n3gh@OPmm`03>MP013Fg>MPif3WH
0bfG00<]V2fG;IL01B5G00@<mW86MPIf1P=]`D]oo`00Fgoo00P0000200400P@520D41B0:0a`9090P
2Q`9;6`XBba/;4//K2Q;;6`d[CS>=:dhcSB]><hd[D4??>i13cc^@@llkT4??>i13cc^J_QVef[hH[MV
f6:gI]QR]fKHH[MVf6:gH[QN]f:hG[MR^5jgH[QN]f:hFYMN^5ZGG[QJUejhFYMN^5ZGFYQJMeZHFWMJ
V5YgFYQJMeZHFWMFN5IGFWQFMeIhEUMJN5IgEWQFEeIhDUMFF59GEWQBEeIHDUMFN4hgDUQ>=e9HCSMB
F4hgDUQ>=e9HBQM>>4XGCSQ:5dhhBQM>>4GgAQQ5mdHHAOM664GgAQQ5md7h?MM1n3gG@OPmed7h=KLi
f3Fg>MPe]cWH=KL]V2fG<IP]UbfH;ILQN1eh8GPMF25h3AMaiFg4LNE]a6g1KJ1;Ool005]oo`<000@8
1@DL2@</K005;6//K2a/;6`d[@03><d013B]><dhcCS=0cc]00E0kCc]?>dlkD3]008lk@9Vn005I]MR
f6;HI]QRe`02H]P00fKHH]MRf002H[P01EjgH[QR^6:hG[L00V:h00=NV5jGGYP00UjH00iNUejHGYQN
V5YgFYQJN5ZHFWMJV5YhFYQJMeZH0UIh00EFMeIhEWQFN5Ig00=FN005DUMBF59HDUQBE`03DUP01E9G
CSQ>>4iHCSL00Thh00I>F4hgCSQ>>4XhBQL3BSP01DXGBSQ:>4HHAQL00dHH01=65dHHAQQ663gh?QPm
n48I?OPn63gh@QTef3WH=MPinCGH>MPef006;KP58GP00`dGLNA]a002LL@00fV0JF1oo`19Ool005Yo
o`2MGi00000010D81@@520HL1a`860LL21`7;4XX:Ra;:2X/BRPZ;4/X:SR/=8/h[3B<>:`dRcR/=8a0
kCc=@>hlcD3]?<e0kSc=@>eVn6/II_QVnF;HI_URf6KiH]QVnF;HI_URf6;IG[QRfEjhH]UN^6;IG[QR
fEZHG[UJV5jiFYQN^EZHG[UJV5ZIEYQJVEZHFYUFV5ZIFYQJVEJHEYUFN5JIEWQFVEIhEYUFN5JIEWQB
NE9HEWUBF59iDUQFNE9HDWUBF59ICUQBFDiHDUU>F59ICUQBFDXhBUU:>4iIBSQ:FDXhCUU:>4Hi@QQ6
>DHHASU264HiAQQ26Cgh@QTmn48I?OQ26Cgh>OTef3Wi=MPinCGH>OT]^2fi;IPa^Bfh;KTMF25h7GPQ
N1eH3CQ]a77UKLAaiFEPJH00BWoo001JOol3000010P310<80`@30Q`700<L21`770L00Ra:00DX:Ra:
;4X/BRPZ008d[006>:`dS3B/=:`h[3B<0Sc]00E0kCc]?>dlkD3]00<lk@05I_UVn6KhH]QRf@03H]P0
3F;IH]QRf6;HH]UN^6;HG[QRfEjhH]QN^6;I00AN^006F[QN^5jhG[QJ^5jh2UZH0eIh00EFV5IhEWQF
N5JH009FN09BN005DUQBN59hDWQBF003DWP9CUP2BSP01DXiBSQ:>4XhBST00TXh00=664HiAQP00THH
00E6>DHHAQPn6D8I00<n6@0;@QTn6ChI?QTinCGi>OTenCWi=OTin@02;MT012fi;MT]fBgI1B6I00L=
>6f2KJ9YPVf2HB1U8019Ool005Uoo`<0000K20<40`P410<L21P770PL1a`8:2P/:BPX;2TX:2`Y:2Pd
RcAZ=8/dJSB;=6XdRcAZ=8/lZd3<008lc008?:]0c3c<?<`lZd3<I_UW6@9Vn@0TH]URnF;II_URfF;i
H]UVnEkIH]UNf6;IG]URfEkHH]UNfF;IF[QNfEZiG[UJ^5kIF[UN^EZhF[UFVEZiEYQJ^EJIF[UFV5Zi
0UJI00YFN5JIEWUFVEIhEYUFNEJIEWQBV@9BN@0JDWQBVE9iDWUBN5:IDWU>NDiHDWU>FDiiCUQBNDiI
CWU:>DYIBSU:FDXiBUU:>DYIBSU:F@96>@0X@SU6>DHiASU2>DHi?QU26ChI@SXn6D8I?QU2>SGi>OTe
nCWj=OTinCGi;MX]^BgI;KT]fRfi8ITMN26I7GTQV@eH3EUYPVfSJH9]Xf4PC818Ool005Qoo`<000@4
0@0870HH1Q`660DL1QP6:2TX:0<X:@0::2PX:CA[=8/dJSB;=6/dRcAZ=8/:?<`016KiIaUW6FLI2F;i
0UkI00ERfEkIG]UNfF;I009Nf@0DF[UN^EZiG[UJ^EjiF[UN^EZiG[UJVEZiFYUJ^EZIF[UJVEZiFYUJ
^@YFV@YBN@09CUU>NDiICWU>FDiiCUU>NDiI00Y:F@Q6>@<n>P05?QXn>Shj?SXn6P02=QX01SXJ=OXf
6SHJ>QXenP8]fP06;OX]fRgJ;MXQ^QfI0b6j0PeI00IU@FUQID5Y@EcPC817Ool005Moo`<0002Q2084
0@P2104L1QP570HH1A`660D/:BPX;2TX:2`Y:2P/:C19=6X`BCAZ<4TdJS19=6XhRSb[?:XlZcR:?:/l
ZSb[>8XlZcbZIaYS6FLjHaUS6V;iHaYRnF<JH_US6V;iHaYNfF;jG]URnUkIH_YNfF;jG]UNfUZiG]YJ
^EkJF[UNfUZiG]YJ^EZjEYUJ^UJiF[YFVEZjE[UJ^UJIE[YFVEJjDYUF^UJIE[YBVEJjEYUBVU9iDYYB
NE:JDWUBVU9iDYYBNDijCWU>NTiICWY>NDijCUU>NTiiBWY:FDYjBUU:NTYIBWY:FDYj@SU6FT8iAUY2
>DIJ@SU6FT8i@SXn6D8j?QU2>ShI@SXn6CXJ=OXj6SGi>QXenSXJ:MT]nRgJ;OXYfBgj7ITQ^QfI8KXM
V@eI3EP=FFE1JF5U@FUQG>18@016Ool005Ioo`<00004104400@1100660@01BPW:0LX1bP7:2L00RP7
00/dBCAY=4TdJCA9=6TdBCAY=4TlZcbZ00<lZ`05?:XlZcb[?:/lZP03IaX05FLIH_YRnF;jH_URnV;i
H_YRnF;jG]UNnUkIG]YNfEkjG]UNfUkIG_YJ^@02F]T02UkJF[UJfE[IG]YJ^E[IF[UJ^UJi0UZi00EJ
^UJiF[UJ^EZj00=FV@05EYYFVEJIEYUFVP02EYT00e:IDYYBN@02DYT08U:JDWUBVE:IDYY>NDijCWU>
NTiiCWY>NDijCWU>NTYIBUY:FDYJBUU:FTYIBUY:FDIJASU6FTHjAUY6>DIJASY6FShJ0chj020n6Shj
?SXn>SHJ=Q/f6SHK=QXf6cHJ=Q/]nRgk;OX]nbgj;O/M^R7K7KXQ^Qfj3GX=N@ejHB1U8640IB1HX4Q0
AGoo001EOol30000<@@110040@@070@H11`460@L11P4:2PX1bPW:0LX:2P7:2L`BCAZ<4TdJS19=6X`
BCAZ<4TlRSR9?8XhJCb:>8TlRSQY?8XhRFLkHaYW>f<JIc]NnV<KG_YS6UkjHa]NnV<J009NnP08G]YN
nUkJG_YNfUkjG]YNnP9NfP08F]YNfU[JG]YJfUkJF]YNfP9JfP08E[YJfUJiF]YF^U[JE[UJfP9F^P09
DYUF^U:JE[YBVEJjDYYF^U:I00=BVP05CYUBVU:JDYY>V@03DYX0@4YjCYY>NTjJBWY>VTijCYY:NTjJ
BUY:NTIJBW]:FTYjAUY:NdYJAU]2FTIK@UY6Fd9JAU]2FTIK?SY2Fchj?U/n>T9K?SXnFcHJ>S/f6SXk
=QXj>cHJ>S/YnRgk:OX]nbWj;O/M^R7K7KXQfafj3GX=N@ejH@1U8640F<1DX4@PA7oo001DOol30004
100021P3608H0aP260<H0RP690H3:0H06R@6:0H`:3A8<2P`B30X=4P`:318<2PdB3R9?8XhRCb:>8Tl
RSR9?8XhRCb:HaYW>V<JIcX2HaX01F;jHaYS6V<JH_X00V<J2Ukj2e[J00YF^UZjE[YJfUJjF[YF^U[J
E[YJ^P9F^P05EYYF^UJjE[YFVP03E[X;DYX01DjJCWY>NTijCYX00dij00=>VTijBWX024Yj0TIJ00E2
FTIJAUY6FT9J0096FP05?S/n>Shj?SXn>`03?SX8=S/00bhK:O/^6`02;Q/012Wk;Q/Mfb7K0agK0`fJ
00=Lh63PG>000URP00=087ooOol0@Goo001COol300041000YAP3508H0aP260<D0RP690DX1R@5:0HT
1BP6<2LdB30X=4P`9cA8<2PdB30W=4PhRCb:>6TlRSR9?8XhJCb:>8TlRV<JIc]S>VLkHaYS6elJHa]O
6V<KGaYS6elJHa]NnUlKF_YO6ekjGa]JnUlKG_YO6e[JG_]JfU[kF]YNne[JF_]JfUkkF]YJfeJjF]]F
^U[KE[YJfeJjF]]F^UKKD[YF^e:jE]]B^UJkD[YFfe:jE[]>VU:kCYYB^djJD[]>VU:kCYYB^dYjCY]:
NTjKBWY>VdYjCY]:NTjKAWY:VdIjBW]6NTZKAWY:NdIjBY]2FTIk@UY6Nd9JAW]2FTIk@UXnFcXj?U/n
>ciK>SXnFchk=S/f6cXk=Q/f>cHK>S/f6bhK:O/^72Wk;Q/YnbhL7M/QfagJ8O/Mf`fK3GYPh5cPH>1L
`5B0D60l0012Ool0055oo`@000@400<H0@04504H0AP190D390@00b@590@T1002<2L01C0V<2L`9c0W
<2H00c0W2cQX16<k01ES6elJHa]O6f<KGaYS6elKHa]O6UkkG_YNnekjG_]NnUkkG_YNnekjF_/00e[J
00IJne[JF]YJfU[kF]X2E]X01E[KE]YFfUKJF]/00eKJ029Jfe:jE[YB^UJkD[YF^U:jE[]B^UJjD[YB
^e:JD[YBVU:kDYYB^U:JD[]BVTjKCYY>VdjJCY]>VTjKCYY>VdjJBW]:NP=:N`0>BWY:NdYkBW]:NTIk
@U]6Nd9KAW]2FdIk@U]6N`TnF`Lf>`0;:Q`^72XK;Q`Z72hL:Q/^71gk7O`Mf`027O/02@fk3I]Lh5cP
H>1Lh5APD61DH011Ool0051oo`@000@40017604D0AP1504H0A@1:0DT12P590@X1B@4:0D`9S@W<2H`
9c0V=2L`9S0W<2Hd9cQX?6ThJ3aY>6PlJCQX?6ThJ3aY>6QSG6<kHeaS>f=LGa]S>elKHcaO6f<kGa]S
?5lKHc]JnelKF_]O6e[kGa]JnelKF_]O6e[KF_]FfU[kF]]JneKJF_]Jfe[kE]YJn`02E]/01UKJF_]F
feKKE]YJn`9Ff`0ND[YFfe:kE]]B^UKKD[]Ffe:jE]]>^e:kCYYB^djkD[]>VU:kC[]B^djJC[]:Vdjk
BYY>^dZKC[]:VTjk0TZK03Q6NdZLAW]:VdIkBYa6NdZKAW]6O49kAWa2FdIl@W]6O49KAW`jFciL>U/n
O3YK?U`jFcil>U/fG38k=U`f>cIL<S/fG2XK;Q`Z6bhl:Q/^72XK;S`Mfb7l7M/Qo1gK3K/9VUc0F:1L
`5RPD41<8510@7oo001?Ool30005100360400a@1604H0@0790<00c0U<2H`1@02<2D01C0V<0D`9C0U
<2H02cQ71F<k0elK00ES>elKGa]O6f<k009O6`0:G_]O6e[kGa]NnelKF_]O6ekkGa/;F_/;E]/00e:k
E]]B^`02D[/01EKKD[]B^e:kE]/00U:k00]>^e:kC[]B^djkD[]>^e:kC[]B^dZK00=>V`0@BY]>VdjK
CY]:VdjKAY]:VdIkBY]6VdZKAW]:VdJKBY/:@W/00ciK?U`nF`02?U/02ciL?U/nFcHk=S`f>cHl=S/f
?3Hk=S`022Xl1Agl0`fk15RP0Ta0?goo001>Ool3000510001QP1500H0A@0604D00PT0`0=<2H/1C0V
;0D`9R`5<2H/1C0V;0DhAcA7>6P00SQ708XdAcQX>4LhAcA7HeaO>f=LGc]SG5lkGcaO6f<lGa]O?5lK
HcaO6ellGa]O75/KGaaJnelLFa]O75[kGaaK6e[lE_]K75KkF_aFne/LE_]Jo5KkFaaFfeKlE]]Fo5KK
E_aFfeKlE]]Fo5KKE]aB^eKLD[]Fg5:kE]aB^eKLD[]Fg4jkD]a>^e:lC[]Bg4jkD[a>^e;LC[]>_4ZK
C[a:VdjlBY]>_4ZKC[a:VdjlAY]:W4JKBYa6VdZLAY]:W4JKBYa2NdJL@W]2W49kAYa2Nd:L@W]6W3YK
?W`jFcil>U/nO3YK?W`b?3IL<S`fG38l=U`b?3IL:Q`^?2XL;S`Z72hl:Q`R71gl7Q`Mnb8L7O`N70Vk
3M`2E80015APF81884PP?Woo001<Ool3000510001Q@0504D0A@1500D0@TT0`06<2H`1C0U<2D`9S05
0S0U00<`9S05>2H00SPV00Dd9SPV>2Hh9S@V008h9P03HeaS>f=L009SG00<Hc]O?5lkGcaO>ellGc]O
?5lkGcaO>elL0e/K00EO75/KFa]K6elL009K6`03F_]Jo5[k009Jn`0AF_aJne[kF_]Jo5[kE_]FfeKk
E]]FneKKE_]FfeKkE]]Fn`0;D]/01E:kC[]>^djkD[/00djk00IB^djkC[]:^djlBY/2B[/04TjlBY]:
^dZkC[a:VdJLAY]:W4JKAYa6VdZLAY]6W4JK@Ya2N`92O006@Ya2Nd9l@Wa2W49k0cil00HjG3il?W`n
O3YL?W`8=U`7:S`77Q`33M/4E8000dPPOomoo`0kOol004aoo`L000HD002]804T0R01908P0B@2804T
0R01<0D/1305;0@`1B`4<0D/1305;0@hAS@V>4Hd9SQ6=2HhAS@V>4Hd9SQ6GeaSG5llHeaOG5llFc]O
?5/lGcaK>ellFcaO?5/kGcaK6elLFa]O?5/KGaaK6ellFa]O75/KFaaFne/LE_]K75KkFaaFne/LE_]K
75;KE_aBfeKlD]]Fo5;KE_aBfeKlD]]Bg5;KD_aBfe;LD]]Bo5;KD]aBfe;lC[]Bg4jkD]a>^e;LC[]B
g4jkD]a>^e;LB[]>_4ZKC[a:^djlBY]>_4ZkC[a:VdZlAYa6_4JKB[a6W4JlAY]:_4JL@Y`nO4:L@Wa2
W3il@Ya2O4:L?W`nOCYl?WdjO3im>W`nOCYl?WdbG3IM<U`fOC9L=UdbG3Im:S`Z?BXl;UdZ?2Xm:S`N
7Agl7Q`Mo1hM7O`N70Vk3M`9^e1PD41DH510A00d000kOol004Yoo`L000LD008T0P08808T0R@2908P
0R@2;0@`10</1006<0@/12`4;0@`13@V0cPV00Dd9SPV>2Hh9S@V00<h9P=OG003HeaOG5ll00YO?0aK
700:E_aK75KlFaaFo5/LE_aK75KlFa`2E_`01EKkE_aFo5KlE_/00eKl00EFneKlD]aBg5;K00=Bg00A
D]]Bg5;LD]aBfdkLC[a>g4jlC]a>_4kLC[a>g4jlC]a>_00;B[`3AY`01DJlAYa6W4JLA[`00dJL00=2
W49l@Y`00T:L00E2O4:L@Ya2W49l008jO005?W`jO3Yl>W`nO002>W`02S9L=UdbG3IL<U`fGC9L=U`Z
?2Xm0bXl00XZ?BXl7QdN71hM7Q`N7AhL7Qd=f`<=g003D41@H510009403Yoo`00B7oo2000014D0100
500@01@0400D0201904P0B@1804T0B01904/0c0400</0`0Q<0@/0b`3;0<`13@U>2Dd93PU=2Dh9C@T
>2Dd9CPU=2@h9EmLGeeOG6=mGeaOGE/lGeeK?5mMFcaOGE/lGeeK?5mM009K?00PFaaK?E/LFcaK75/m
FaaK?5/LFceFo5/LE_aK75KlFaaFo5/LE_aK75KlEaaBo5KlD_aG75;lE_aBo5LLD_aFo09Bo00:D]aB
o4kLD_aBg5;lC]aBo5;LD_`4C]`01DjlC]a>g4kLC[`00dkL04M>_4[MB[a:g4ZlB]e:_4[LB[a:gDZl
B]a6W4JmAYa6_DJLA[e6W4JmAYa6_DJL@YdnW4:M?Ya2WCjL@YdnW4:M?Y`nWCYl>YdjO3jM>W`jWCYl
?YdbG3Im<U`fOC9L=WdbG3Im:S`ZGBHl:UdZ?2YM9S`N?AXL7QdJ71hm6Q`N7@WK3O`9f`glC21@@4`P
00940003B01oogoo03Ioo`00Agoo1`001a@00R0100HT0B01804P0B@1804;;0<<=2D045mLGeeOG5mM
GeaOGE/lGcaK?5llFcaO?5/lGcaK?5ll0U/l00YK75/lFaaK?5/LFcaK75/lFaaK?0aG7005D_aFo5Kl
E_aBo003E_`015;lE_aFo5Kl0e;L00EBo5;LD]aBg5;l00=Bg003D_a>g4kL00Y>g0]:_003A[a6W4Jl
0096_008AYa6_4JlA[a6W4Jl@Ya2W@=2W006@Ye2W4:L@Ya2WCYl0SYm01hjWCYl>WdjOCZM>W`jOC9M
<WdbGC9m<UdbOC9M<WdbGBYM:SdZGBXm:UdZ?BYM7Q`N7AhL7QdN71hM2O`33O`4C202@0000b`0Oomo
o`0dOol004Eoo`P0002N400D0100500@01@0400P0B00804P0201800P0B00;08X0R`2:08/0RP2;08X
0R`2:08/0S@4=2@`0c@T=0@d9303=2@d13@T<0<d95]LGgeKG5mmFeaOOE/lGeeK?5mMFcaOGE/lGeeK
?5mMFcaOGELLFceG75/mEaaK?ELLFceG75/mEaaG7ELLEaeG75LMEaaG7ELLEaeG75LMEaaG7E;lEaeB
o5LMD_aG7E;lEaeBo5LMD_aBoDkLD_e>g5;mC]aBoDkLD_e>g5;mC]a>gD[LC_e:g4kMB]a>oD[LC]e:
g4kmB]a:gDJlB]e:_4[MA[a:gDZlB]e6_4[MB[a6_D:lA[e2_4Jm@[a6_D:lA[e2_4Jm?Ya2_CjL@[dn
W4:m?Ya2_CjL@[djO3ZM>WdjWCYl>YdjOCZM>W`jW@8bO@05<UdbOC9m<WdbG@02<Wd06BYM9SdZGBIM
:UdV?BYM6Q`N?AXL7SdJ71hm2M/=o0WL3Oa<8510C21@@4`PA010030003Aoo`00@goo2@0000l@01@0
400D0100500@0201800P0B00804P020180002b`200Dd13@T=2@d93@400<d9005=0@d93@T=2@d1002
Ged06UmmGeeOGE/mFeeK?5]MFceKGE/lFeeK?E]MFcaKGE/lFceK?5/mFcaK?E/lFceK?5/mFc`2Ea`0
1ELMEaaG75LLEad00eLL00EG7ELLEaaBo5LM00=Bo005EaeBo5;lD_aG7@03D_`01U;mC_aBo5;lD_e>
o09Bo005D_e>o5;lC]a>g@03C]`01DkMC]a>g4kLC]d00TkL00a:_4[MB[a:gDZlB]e:_4[MB[a:gDZl
B]d2A[d01DJlA[e6_DJmA[`00dJm00e6_4:M?Ye2_CjM@YdnWD:m?Ye2WCjM@[djO@03>Yd01SYm>Ydj
WCZM>WdjW@TbO@PZG@037SdJ7Ahm008N?@056Qd=o0gl3O`9o002B2000d`PB2188002?0000b`0Oomo
o`0`Ool0045oo`T0000]500@01@0400D0100500P0201800P0B00804P0201800/0RP2;08X0R`2:08/
0RP2;08X0R`2=0@d9303=2@d13@T<0<d93@4=2@`0c@T=0AOOE]MGgiKGEmm009KG@2HFceKGE/lFeeK
?E]MFcaKGE/mFeeG?5/mEcaK?ELlFceG?5/mEcaK?ELlFceC75LmEaaG?E<LEceG75LmDaaG?ELLEceC
75LMD_aC7E;lEaeBo5<MD_aG7E;lDaeBo5;mC_aBoDklD_e>o5;mC_aBoDklD_e>o5;mB]a>oD[LC_e:
g4kmB]a>oD[LC_e:g4kmA]a:gDJlB]e6g4[MA[a:gDKLB]e6_4[M@[e6gD:lA]e2_DKM@[a6gD:mA]e2
_4:m?Ye2_CjM@[dnWD:m?Ye2_CjM@[dfWCZN=YdjWCJM>YhfWCZM=YdjWS9m<Yh^OC:N<WdbWRim<Yhb
OBYn9UdZORIM:WhVGBYn9UdN?AXL7SdJ?Ahm6Q`>70Wl3O`9o0hLB21<84PPC2188400?00/031oo`00
@7oo00<gMP0000001@000a0000@D0100400@00XP000<;04X0B`1:04/0BP1;04X0B`1:04/0C030c@3
00D`0c@3=0<d0c0300<d0`06<0=KOE]MGgeKGE]m35]M00=G?E/mEcd00ULm00EK?ELmEceG?E/m00=G
?@aG7@03DaeBo5<M009C7@05D_aC7E<MDaeBo003Dad01DklC_e>oE;mC_`00Tkm015BoDklC_e>oE;m
C_a>gD[MC_e:gDkMB]e>oD[MC]e:gDkm00A:g@05A]e:gD[MB]e6g@03B]d03DKMA[e2_DJm@[e6_D:m
A[e2_DJm@[e6_D:m00<n_@05?Ydn_Cjm?[dnW@03?[d:>Yd:<Wd022IM:UdVGBYM9UdZGBIM:Ud36Sd0
0ahm6SdJ?@023O`02PWl3O`=o4P0A01804@0B00h02P0;goo000nOol00c]g000000050000?A@0400D
0100500@01@0700P01`0800L0200700P01`0800X0B`1:04/0BP1;04X0B`1:04/0BP1=0<`0c@3<08d
0c03=0<`0S@3<0<d0c02=0<`0e]nFeeOOU]MFgiKGE]NEeeKGULmFeiGGE]NEceKGUMMFeiG?E]N00=G
?@05FeiG?ELmEceKGP03Ecd0QU]NDaeG?E<MEceC7ELmDaeG?E<MEceC7ELmD_eC7DkmDaeBoE<MC_eC
7E;mDae>oE<MD_e?7DkmDae>oDlMC_eC7DkmCae>oE<MC_e?7D[MC_e:gDkmB]e>oD[MC_e:gDkmB]e>
oD[MB]i6gD[MA]e:gTKMB]e6gD[NA]e:gDKMA]i2_DKM@[e6gT:mA]e2_DKN@[e6gD:m?[hn_Cjn?Ydn
_Sjm?[hnWCjn?[dn_SJM>[hfWCZn=Ydj_SJM>[hfWCZn;WdbWRim<Yh^OC:N;WdbWRim<YhVGBYn9UdZ
ORIM:WhVGBYn6SdNGAXm7UdJ?AiM6Sd>70Wl3Q`9o0hLA01884@0B01403`0:00]Ool003eoo`P000L@
000:700P01`0800L0200700P01`0800;:04><082Fgd01U]nFgeKOE]mFeeGG@=KG@05EeeKGE]MFeeG
G@02Fed=Ecd035<MEceG7ELmDaeG?ELMEceC7ELmEaeG?@iC7@i>o@05B]e:oD[mC_e:g@02B_d01Dkm
B]e:oD[mC_d00dKM00E:gDKMA]e6gD[M00=6g@0>B]e6gD;M@[e6gD:m@]e2_DKM@[e2gD:mA]e2_@/n
_@0M=YdjWCJM>YhfWCZM=YdjWSJM>YdfWC:N;WdbWS9m<Yh^OC:N<WdbWRim9WdVGBIn9UdVOBIM9WhV
G@076Sd010Wl3O`9o0hL1D@000<h02P0Ool0:goo000kOol800000a00500@000240003A@0400P01`0
800L0200700P01`0800L02`100<X0@05;04X0BP1:04/0@02:040^302=08`0S@2<08d0S02=08`0S@2
<08d0S02=09GOE]nEeeKOUMmFgiGGE]nEeeKGUMMFgiGGE]NEeeKOUMMFeiGGE]nEceGGU<mEeiG?EMN
DceGGULmEeiC?EMNEceG?U<MEciC7ELnDaeG?U<MEciC7ELnDaeG?TlMDai?7E<NCaeC7TlMDai?7E<N
CaeC7TlMCai>oDlNB_e?7TkmCai:oDlNC_e?7T[mCai:oD[nB]e>oT[mB_i:gDknB_e:oT[MC_i:oD[n
A]e:oTKMA_i6gD[nA]e6oTKMB_i6gDKnA]e6gT:m@]i2_DKN@[e2gT:mA]i2_D;N@[dngSZm?[hj_CkN
>[dn_SZm?]hj_Cjn=Ydj_SJM>[hfWCZn=Ydj_SJM>[hfWC:N;WdbWRim<Yh^OC:N;WdbWRim9WhVGBIn
9UdVORIM9WhVGAYN6SdJGAXm6UhJ?AYM6Sd>7@Wl3Q`9o4@0@0140400A00d02P0:Woo000iOol90007
40005200700P01`0800L0200700P01`0FkiKWU^nFiiK_U^NFkiKWU^nFid3Fih01E^MFiiKWU^NFid0
0U^N01UKOU]mFgiKOE]nFgeKOU]mFgiKOE]nFgeKGUMMEeiGGE]NEeeGGUMMFeiGGEMNEeeKGP03Ecd0
1EMNEceG?ELmEeh00eLm00IGGULmDceC?ELmDad2Dcd01eLmDaeC?E<mEceC7E<m009C7@05CaeC7E<M
Dae?7@03Dad014lMDadP02`00S000c@00Tkm00I?7DkmC_e>oDlMC_d>B_d01DKNA]e6gDKMA]h00dKM
00E6gTKMA]e6gDKN00=2g@05@]i2gD;M@]e2gP03@]d06D;N@]dn_Sjm?[hn_Cjn?[dn_Sjm?[hn_Cjn
=Ydf_SJN=[hfWCJn=Yhf_SJM=[hfWSJn00<^WP05<Yh^WRjN;YhbWP02;Yh04bIm9WhVOBIn9WdVORIm
9WhJ?AYM6SdJGAXm6UdJ?AYM2Q`>70XL00E400<h02Qoo`00XWoo00h001@0800X03@0>00l0C`0A210
04@P@00l03P0TGoo002OOol01@00700/0B`1=0<00Sa50TAV0TRV0TbV0U350U3400ADXU20C40`08eo
o`00WGoo00T000`0804`12`3>4HlId28A:P00TS800a<jDS8D>Q<j5D8D>MI1eCVF@ED`EB0B22=Ool0
09aoo`0;300T0R02908`9C0V>6M4ZD2YB>Y8bP03C@X0154ZEBYE:EDY0UTX00II9UdVG@AM15S0E62;
Ool009]oo`0L000@020390@`9C0V>4LlJ42YA:U8bDSZC>YA2TcYEBYA2ETZEBUMBETXGBMI1V56GBEQ
AUd1F:2:Ool009Yoo`05000@02@490@`9`03?8T2A<X00dT;C@]8j`03DB/025D[ED]IBeU;FDYMJUe:
HFP2GDP01655H@5HX4@0RGoo002IOol240402b@5=4T`B42[?8Y0ZdC[A>a4bdd/B@`00Td/015ACE4/
EFaEC5U]FF]IK5U[GH]MJV6:GFUQRV5VIFMQ8UcP08Qoo`00V7oo00T0010290LX1cAY=6Xlbd3;?:/0
0TD<00E93Dd]CBe=;E5]009AC@=EK@9IS@05GHeMS5f<GHaQZP02HHX2IHP00fETH@1oo`26Ool009Mo
o`0O000@0R@6:0LdBCAZ?:]0c3b[B@e4k4T=CBe=CDT]CDeACE5]DDeISUE]FHeIK5f=FHaQ[5f;HJaQ
RVF[HHX00VF800=YI6E4H@00QWoo002EOol01`0040<@0b@8:2PdJSB:0090c005?<a93DD=B@e53@03
CDh3DFh02eE^EHiISUF>FHiISEf]GHeQ[Ef/HJd00VF[00=QZfFYIJT00VV500=U8520Ool0Pgoo002E
Ool0800050@T:2PY=8/hS3B;@>dlc43]A@e9;TD=BBi=CU5_CDiESe5^EHmAKUV_EHiI[eF>GJiI[Ug>
FJiQcUf]HLh2IL`01f6[JLYUZFfVJHIYHEBP08=oo`00U7oo00@00104:2TX:@<dR`=0k@99;P03ABi9
;Te>00==CP08DFiESe5^EHmISUV_EHiISPAM[P9Qc@04HJeUc6G<IL`3JLX00ffVJJIY@@23Ool009=o
o`0P000D1A05:2XT:CR/=8/h[43]@@hlkDU?ABi9CdD^DFm=CU5_CDiESe6?EHmAKeV_EHmI[eF>FJmM
[Ug?FJiMc`9QcP0:HLeUkFG<INeYbVg[JLY]afVVKH62Ool0099oo`05000@1A05:2XX:@02=:`01CR/
@>e0kD3]@>h00dT^00=9;de_CFl00Te_00AASeF?EHmES`EI[`04GLmM[Ug?GJh3HLh01VG<ILeUc6G]
JLYYb`9]a`03JF5H`7oo081oo`00TGoo00@001@640DXBP8X:P0I=:`h[CB/@@hlkD4>@>i9CdD^BDm9
;U5`CFmAT4e_EK1ASeF`DHmI/5F_FM1I[eV`GJl00eg?00iQcVG_HLiQkfG=JNiUkFW]JN]]k6g7KNQY
PEd0P7oo002@Ool00`0040H@1P03:2X00cB/>:dd[003@@h01D3^BDm9CdU?BBl00Te_00UAKde_CFmE
SeF@DHmET5V_FK000eV_15g?00AQkV7>HNiQcPAUk@=Yj`03KLQ]j6V1081oo`00T7oo0380010650LX
:RQ;=:dhcCB]><e13T4?@@i13dD_BE19CdU@CFmAT4e_DI1=KeF`DHmE/56?FM1I[eV`EJmId5g?GO1M
cf7`HNiUkf7>INmUkFX>INeZ3VW[KPaYjg7YKNQ]XffROgoo002?Ool02`0040HD1bPZ:4/X:cS==:dh
[D4>@@l00T4>1DU?00iAT4e_CG1=L56@EI1E/5F@EK1I/5W@FK1Id5V`0Ug?00=Md5g?GLl0167_00MU
kVX>INeUkVW/KPaYj`02KNP00ffSKJ9oo`1mOol008ioo`80000D50L@1RQ;:2XhcCB]><dd[D4?@@i1
3d4>BE19CdU@ABm9D4e_DI1=K`9AT00NEK1ASeF`DI1Id5V_FM1I[eW@GLmQl5g?GO1McfG_HNiUkf7>
JPiUkFX>INe^36W[KPa]j77YKJ=a`ed0OGoo002>Ool00`0050L@1`03:4/013C=><dhcCS>0d4?00=1
;dU?BE000TU@00E9Ce6@CI1AT4e`00IE/0EId005GM1Ml5g@GO1Md002HNl01VG_HNmZ3VH>JPiV3P=^
3004KNUb2Fg3LL=mOol008eoo`03000D2107008XB`0B:4`d[CS>=:dhcT4>@Bm13TD_BDm9L4U?BG19
Ce6@CG1AT4e`0U6@01mE/E6`EK1AT5FaFK1Id5V`FM5I/5g`GLmQl5g?GO1QkfH@HNmV3fG^JPiUkVX>
JNa^3FX<LPU]j789KJ=Q801lOol008aoo`0400000A0750P2:4`01BQ;><hhcSS>=<h00d4_01513dU`
BE19L4U@BG1=T56ACI1AT4f@EK5E/5FaEK1E/EF`009Id003FM5Id5W@00EMl006IQ1Qkf8@HNmZ3fH>
0VX>00I^;Fh<KPe^3G8:LPT2LL@00f50Oomoo`1iOol008]oo`0k00000A0750PXBba/:4/hcSC=><hd
cT4_@@m5<44?BG19CdU`BE19L4U?DI5=T56ACG1ATEF`EK5A/5FaEK1E/EW@GM5Id5WAFM1QlEg@HO1M
d67aHNmV467_IQ1QkfX?IPiZ3fH>KReZ36h]LPUb2Vh9LNA]``1kOol008]oo`800@0550P@22Q<:4/X
C002><h063C>><i1;d4_@@m1;dU@BG19D4U`BE19L4f@DI1=T56ACI1E/EF`EK5E/5FaEK1Id@=Id003
FM5Ml5g`00=Ml00?HQ1QkfH@HNmR46X>JPmV3VX>KPe^;Fh<KPeb2G8:009ai003HD1oogoo07Qoo`00
RWoo03d0000150P@22a/:4`XK2Q<>>ldcSS^=<i5<44_@C113dUaBE19L4U@BG59D56ACI1A/Df@DI5A
/5GAEK1EdE6`EM5Id5WaFM1MlEW@HO5Ml68AGO1QlF7_IQ1QkfH@HNmZ;fH>JRmV3VX_KPe^;FX=KReb
2W8ZLNAai@1jOol008Yoo`07004D2108:6`XC2Q/:4`013S>00I1<44_@C11;d4`BE03BG001DU@DI5A
TE6ACI000U6A1UFa0eWA00AId5WAFM5Ml@=Ml006GO5R46H@HQ1V468@0VX?00=Z;fX?KRd00Vh]00I^
3G8ZLPYb:W7THD1iOol008Uoo`1000400Q0850TXK2Q]:4`/KCC>>>hdcSS_@Bm1<44?AC11;dU`BE19
LDU@BG1=T56aCI1ATDf@DK5E/5GADK1EdEF`EM5Id5gaFM1IlEW@GO5Ml67aGO1R4Eg`IQ1QkfH@HNmV
46H>JRmV3VX_IPi^;Vh]KRi^;GH[LRYf1G7TIF1hOol008Uoo`03008@2A@900<XK006:6dhcSS_><hh
kcS>1D4`00M9L4UaBG19LDU`DK5=T@02DI402E6aCI5EdEFaEM5E/EGAEK5Il@03FM403UWaFM5MlEga
HO5Ml5gaHQ1V468@IQ1R46X_JPl3JRl3KRd01Vh^LRYb:W8ZLPEQ@7Qoo`00R7oo04800P0150T@22Q]
:4`/KCC>>>ldcSS_=<i5<44_AC11;dD`BE1=LDU`BG59D56aCI5A/Df@DK5=TE6aEK5EdEFaEM5E/EGA
FM5IlEW@GO5IdEWaGO1R4Eg`HQ5Ml68AHQ1V468@IQ1R46X_IPmZ;fH?JRm^;Fh^KRe^;W8:MR]ai7H5
HD1gOol008Qoo`03008D2A0900@XK@Dhk`E1<006BG59L4UaBG19LDfA0U6A00YA/DfADI5ATEGAEK5E
dEFaEM5E/@9Id@06FO5IdEWAFM5QlEg`0Uga00MQlEg`IQ1R46H@HQ1V4002JRl01FX?JRmZ;fh^KRd0
0Vh^00Ef:g8ZLR]b1GH507Moo`00Qgoo0P02048@2A@9:6`/SBQ/:6ddcSS_=<hhkd4`AE11<4E@@C15
D4U`BG59L4fABG1A/DfADK5=TE6aCI5A/EFaEM5E/EGBEK5EdEWAGO9IdEgaFM5MlUgaHQ5Ml68AGO5R
4F8@IS5R46HAHQ1Z<6X_JS1V3fX`KRe^CVh]LTi^;GI;LRYf1W85IH1fOol008Moo`03008@2A@900@X
K@Dhk`E1<00=BG19LDUaBG59L4UaDI5A/DfADK5ATE6aEK400eGA00EE/EGAEM5IlEWA00=Il@09FM5N
4EgaHQ5MlEhAGO5R4F8@00=V4003HQ1Z;fX_00=Z;`9^;P07KRe^;W8[MR]b:WH5LPD0MWoo0026Ool0
AP0340TD2Q09;8dXKBR=:6dhkcC>>>ldcTE@@C15D44`AE11<4UaBG1=TDU`BG59L56aCI5A/DfADK5=
TEGAEK5EdUFaEM5E/EGBFM5MlEWAGO9IdEgaGO1R4EgaHQ5Ml68AGO5V4F8@IS5R46HAIPmZ<6X_JS1V
3g9>KRibCVh]LTib:gI;LR]f9V5PMGoo0026Ool0100250T@2A@:12Q]13S_0d4`00=1D44`@C001TUa
00Q=TE6aDK5A/DfADK5EdEGB0eGA00=EdUGAFO401EWa01]R4EgaGQ5N4F8AGO5N4FH@IS5R46HAIQ1Z
<6X_JS1Z;fX`KRi^CVh^KTi^;WI;LR]fBg85MPH0MGoo0025Ool05`0250X@2A@::6dXSBQ];8ddkcS_
=<lhkd4`AE11<4EA@C15D4U`CI59LDVABG000TfA02mA/TfADK9=TE6bCI5EdUGAEM9E/EGBEM5EdUWA
GO9IdEgbFM5MlUWAHQ5MlF8AGO5R4EgaIS5R46HaHQ1V<F8@JS1V;fX`JRmZ<6h]LTi^;W9>KRefBg8[
MT]b1FF007Aoo`00Q7oo0P0300<@2Q@:40X012Q]13S_0T4`00A1D44`@C11<0I9L@=A/@04CI5A/E6a
DK43EM4015GBEM5EdEGA1eWa00=N4F8AGO400UhA019R4F8@IQ5V46HaHQ1V4FX_JS1Z;fX`JRm^CVh^
KTi^;Vi>LT/2MT/2MRH00fF0Oomoo`1aOol008Aoo`1:00<00Q@:40T/SRQ];8hXKCS`=>li43C_>?11
<4EA@C15DD4`AE59LDVABG5=TDUaBI5=TE6bCI5A/TfADK9=TEGBEM5EdUGAEM9EdEGBFO5MlUWAGO9I
lEgbFM5R4UgaHQ9MlF8BGO5V<F8@IS5R46HaHQ1ZD6X_JU1Z;fY@JRmbCVh^LTm^;WI<LR]fC79;MRIQ
P7=oo`00Pgoo0P0300LD2Q0:50XXKBR=:6dXS@04>>l00d5@@E51<002@E001D5A@C19LDUaBI400dUa
00EA/U6aDK5A/E6b009A/@0KEM5EdUGAEM9EdEGBEM5IlUWaFO9IlEWbFO5IlUhAHQ5N4F8AGQ5R4EhA
IS5R4FHaIQ5V<F8A00EZ<0E^CP03MTabBgI;009f9P03IH1oogoo071oo`00Pgoo01T00`0440TD2RQ]
;8hXKBb>=>li43C_>?0dkdEA@C15DD4`AE51<4VABG5=TDUaBI59L@02CI40<E6bCI5A/TfADK9=TEGB
EM5EdUGAEM9EdEGBFM5MlUWaGO9IdEgbFO5R4UgaHQ9MlF8BGO5R4V8@IS5R46HaHQ1V<FX_JU1Z;fY@
JRmZD6h^LTi^;W9?LT]fC78[MTMf9WHW079oo`00Pgoo00h00a0:50X@2RR>:6dXSRR=>?0hkcS`>>lh
l45@0T5A00E5DD5@@E59LDVA00=9L@05BI59LE6aDK5A/P03DK405U6bEM5EdUGAEM9EdEGBEM5IlUWa
FO9IlEWbFO5IlUhAHQ5N4F8AGQ5R4EhA1VHa00IZD6X`JS1Z<6Y@JS02KTh00g9?KTifC002MT`0179;
MRIf9VFPLGoo0022Ool0CP0400<D2Q0:;8hXKBb>:6d/SSS_>A0dkcT@>>m5DD4`AE51<4EA@C1=TTUa
BI99LDfBBG59TTfADK9=/E6bCI5A/TfaEM9EdEGbEM5EdUGAEO9IlEgbFO5N4UWaGO9IlF8BGQ5R4Uga
HQ9N4F8BHQ1V<F8AIS5R46HaHQ5ZD6X`JU1Z<6Y@JS1bCfi>LTm^CWI/LT]fC7HVMTMf9W5oo`00PWoo
00d00a@:40XD2RQ]:8hXSBR>>>lhl3S_>?0hk`02@E402dEA@E11DD5ABI59LDVABG59TDUaBI400U6b
00IA/E6bDK9A/U6aDK87EM83FO8035WaFO9IlUWbFO5R4EhAHQ9N4F8AGQ5R4PIV<@03JS1ZD6X`009Z
<006JU1^CVi>KTibCg9;0gI<0WHV00<03WooOol0KWoo0021Ool0D00300@@2Q@;40X/SRQ];8hXSCT@
=>li43S_>A11<4EA@C15DD4`AE59LDVBBG5=TTUaBI99LE6bCK5A/TfADK9=/E6bCI5ElUGAEM9EdEGb
EM5EdUWaGQ9IlEgbFO5N4UWaGO9MlF8BGQ5R4UgaHQ9N4FHaHQ1V<F8AIS5R46Y@JS1ZD6X`JU1Z<79?
KTibCfi>MVabBgI/LTafAgHVJJ1`Ool0085oo`800`0350X@2RR>00@XSP03>?0i43S_008hl006AE51
DD5A@E55DD5A0TVA00E9TTUaBI59TDVB00QA/PMEdPQIlP07HQ9N4F8BGQ5R4UhAHQ801VHa00UZ<6Y@
JS1ZD6X`JU1^Cg9?KTh00Vi?00MfK7I<MTafC7I7MRH03P1_Ool0081oo`1B00@00a@;40XD2bQ];8hX
SBb>=>li43S_>A0dkcT@@E15DD4`AE51D4EABG5=TTUaCI99LDfBBG5A/TfaDK9=/E6bCK5A/TfaEO9E
dEWbEM9ElUGAFO9IlEgbFO5N4UWaGO9IlEhBGQ5R4UhAHQ9N4F8BGQ5R4V8aIS5R4FHaHS5V<FX`JU5Z
<6Y@JS1ZDFi>LTm^CW9_LTafK79;MVaf9WI7IH1_Ool0081oo`80100340XD2RR>00@XSP05>A0hkcS`
>?0i4003@E401TEA@E51DDVABI99L@99T@03BI99LDVA00MA/PQEdPQIlP08HQ9N4F8BGQ5R4UhAHQ9N
4@IV<@06JU1Z<6Y@JS1ZD6X`0Vi?00YbCfi>KTmfC7I/MTaf9gHVJJ1UX6ioo`00Ogoo05@00`0400<D
2a0:;8hXSRb>:8h/SSS`>A0dkcT@>?15DD4`AE51D4EA@C1=TTUaCI99LDfBBG5=TTUaDK9=/E6bCK5A
/TfaDK9EdEWbEM9ElUGAFO9EdUGbFO5N4UWaGO9IlEhBFO5MlUhAHQ9N4F8BGQ5R4UhAHQ9R4FHaHS5V
<F8AIS5Z<6Y@JS1ZDFX`JU1^CW9_KTmbKfi>MVefC7I/LTajAgHVJL1^Ool007moo`0500@00a@;40XD
2`04:8h023S`>A0hl3T@>?0i445AAE43@E402DEABI59TTVABI99TDVBBI59TP07DK88EM801EgbFO9I
lUWbGO800eWb00QR4UhBHQ9N4V8BGQ9R4UhB1VHa0VY@00YZDFY@JU1ZD79_KTmbCfi?LVm^C`=fK09f
A`03IJ1YX7oo06aoo`00OWoo02`0100300@@2Q@;:8h/SRR>;8hXSST@=>li43S`>A0dkdEA@E55DD5@
AE51DDfBBG5=TTUaCI99LDfBBG5A/TfaDM9=/U6bCK5AdUGBEO9EdUWbEM9ElUGB0UWb02QN4UWbGQ9I
lUhBFO9N4UWbHQ9N4F8bGQ5R4UhAHS9R<FHaHS5V<V8aIS5R<FiAJS1ZDFX`KU5Z<79_KTibKfi?LVmb
C7I]MTafK7HVNTMUX6eoo`00OWoo0P0400<@2Q@;40X012R>00Li43S`>A0hl3T@>?15D@03@E402TEA
@E51DDVABI99TDVBBI59TTVA256b25GB0UWb00EMlUWbFO9IlUgb009IlP07GQ9R4UhBHQ9N4V8BGQ80
1fHa0fY@00YZDFY@JU1^Cg9_KTmbCfi?MVafC09fK003NTMfAgI706eoo`00OWoo0P0405DD2a0:50/X
SRb_:8h/ScC`>A0hl3T@=?0i445AAE51D4EA@E55DD5@CI99LDfBBG5=TTUaCI9=/E7BCK9A/TfaDM9=
/U6bEM9IlUGBEO9EdUWbEM9ElUWbGQ9IlUhBFO9N4UWbGQ9IlV8bGQ5R4UhAHS9N4F8BHS5V<V8aIS5R
<FHbHS5ZDFX`KU5ZD6YAJS1bKfi?LVm^Cg9_KTmfKG9<MVefAgY7MTMY`01/Ool007eoo`80100350/@
2a0;00DXSP03>A0hl3T@008i4004>?11DD5AAE43@E400dEABI59TP02BI800dVABI99TP08DK801EGb
EM9EdUGBEO800eGB00EN4UWbFO9IlUhB00=IlP9N4P07HQ9N4V8BGQ9R4UhBIS800fHa015V<VHaIS5Z
D6YAJU1ZDFY@JU5ZD79_KTmbKfi?LVmfK7I]009fK003MTMjAgI706aoo`00OGoo0P0405H@2Q@;40X/
[bR>;8lXSST@>?0i43C`>A0hl3T@@E55LT5AAE51DDEb@E5=TTUaCI99TDfBBG5=TTfbDM9=/U7BCK9A
dTfbDM9EdUGbEM9IleGBEO9EdUWcEM9N4UWbGQ=IlUhBFO9N4eWbHS9N4F8bGQ9R<UhAHS9N4VHbHS5V
DV8aIS9R<FIBJU1ZDFX`KU5ZD6YAKTmbKfi?LVm^Cg9_MVafKG9<NTQfAgY7K7oo001mOol0100440/@
2a0;1BR>00Phl3T@>A0i43S`>A11DDEA0d5A00=5DD5ABI800TVB00E9TDVBBI99TTVA00QA/P9EdP05
EO9EdUGBEM9ElP02EM800eWbGQ9IlP02FO803EhBFO9IlUhBHQ9N4V8BGQ9R4UhBHQ9V<FHb00=V<@0>
IS9V<FYAJU1ZDFY@JU5ZD6YAKTmbKfi?LVm^C`9fK005MVefAgI7MTMY`01[Ool007aoo`1J00D011@;
40/D2bR>;:lXSRb_:8hi43C`>A4hl3T@=?15LT5AAE51DDEb@E55DDUaCI99TDfBBG5=TTVACI9=/U7B
CK9AdTfbDM9=/U7BEM9IleGBEO9EdUWcEM9ElUGBGQ=IlUhBFO9N4eWbGQ9IlV8bGQ9R<UhAHS9N4V8b
GQ5VDV8aIS9R<FIBHS5V<VX`KU5ZD6YAJS1^DFY@LW1^Cg9`KTmbL7I/MVefK7I]MTMjJ7I7Jgoo001l
Ool200@00a0;50/@2`02:8h00bR?:8hXSP06>A03@E4014EA@E51DD5A24VB00EAdU6bDK9A/U7B00=A
/P0@EO9EdUGbEM9ElUGBEO9EdUGbFO9J4UWbGQ9IlUXBFO82GQ82HQ803V8bGQ9R4V8BHS9V<FHbIS5V
<VHaIS9V<FYAJU03JU401FY@JU5bKg9_KTl00g9_00AfK7I]MVajA`9fA`03JL1oogoo06Qoo`00Ngoo
05`0100540/D2a0;;:lXSRb_:8h/[cC`>A4hl3T@=?0i4CS`AG91DDEb@E55LT5AAG99TDfBBI5=TTVA
CI99TDfBCK9AdTfbDM==/U7BCK9AdeGBEO=EdUWcEM9EleGBFO=EdUhBFO9N4eWbGQ9IlUhCFO9R<UhB
HS9N4V8bGQ9R<UhBHS9R<FIBIS5VDV8aIU9V<FYAJU1^DFY@JU5ZD6iAKTmbL6i?LW1^CgI]MVafKGI/
NVQfAfW0JWoo001kOol00`0500@D2`0240/00bR>:8lXSP02:8h6>A02@E401DEA@E51DD5AAE4024VB
0e6b01YAdU6bDK9A/U7BDK9ElUGBEO9EdUGbEM9ElUGBEO9IlUhBFO9J4UWbGQ9IlUXBFO9R<UhB0V8B
00]R<UhBHQ9R4VHbIS5V<VHaIS9V<FHb009ZD@05JU1ZDFYAJU5ZD003LVl02Vi?LVmfK7I]MVafKGI7
NVQU`6W0JGoo001jOol0GP0500@01A0;50`@2bb_:8h/[bR>;:lhl3T@=?0i4CS`>A11DDEb@E55LT5A
AG91DDfBBI5=TTVACI99TDfBBI5AdTfbDM==/U7BCK9AddfbDM9EdUWcEM9EleGBFO=EdUGcEM9N4eWb
GQ9IlUhCFO9N4UWbGQ=N4V8bGQ9R<UhBHS9N4V8bIS5VDV8aIU9V<FIBHS5^DFY@JU5ZD6iAJU1ZDFi?
LW1^Cg9`KTmfSGI/MXefK7J=MTMjJ6G0JGoo001jOol00`0400D@2`0240/01RR_:8hXSbR>::lXSP8i
4005>A4i43T@>A15DP03@E400dEB@E51D@08BI800e6bDM9A/P02DK807U7BDK9A/U6bEO9EdUGbEM9E
lUGBEO9EdUGbFO9J4UWbGQ9IlUXBFO9N4UWbHS9R4V8bGQ9R<V8BHS9N4P=V<P04IS5V<VHbIS87JU40
1W9`KVmbKg9_LW1^K`AfK@04NVQfAfW0IL1XOol007Uoo`1P00@01@0450`@2a@<:8h/[bR>;:lXSSTA
=?0i4CT@>A4dl3TA@E55LT5AAG91DDEb@E5=TTVBCI99TDfBBI9=TTVADM==/U7CCK9AddfbDM==/U7C
EM9EleGBFO=EdUGcEM9IleGBGQ=IlUhCFO9N4eWbGQ=IlUhCGQ9R<UhBHS9N4V8bGQ9R<V8aIU9V<FIB
HS5VDVHaIU9ZD6iaJU1ZDFY@KW5ZD79`KTmbL6i?LW1fK7J=MVafSGI/NVQfAfW0J7oo001iOol03@05
00@@2a0;50/XSRR?:8hX[bR>:8li43TA00<i4005>A51DD5A@E55DP03@E49BI83DK801U7BDK9A/U6b
DM9A/P9ElP0:EO=EdUGbEO9EleGBEO9J4UhBFO82FQ803UhBFO9J4UXBHS9N4V8bHQ9R<UhBHS9R4V8b
IS43IS800fHaIS9V<P07JU400g9_LW1^K`02LVl00g9`MVefK@02MVd00gI7NVQY`01XOol007Uoo`1Q
00@01A0;50`@2bb_:8h/[bR>;:ldl3TA>A0i4CC`>A4i44Eb@E55LT5AAG91DDEbBI9=TTVACI99TTfB
BI5=TTfbDM==/U7CCK9AddfbDM==/UGcEM9IleGBEO=EdUWcEM9EleGBGQ=IlUhCFO9N4eWbGQ=IlUhC
GQ9R<UhBHS9N4V8bGQ9R<UhBIU9R<FIBIS5VDV8aIU9V<FYAJU1^LFY@JU5ZD79`KTmbL6i?LW1^CgJ=
MVajSGI]NVQfAgYXIL00Igoo001hOol0100400D@2a@<0Q0;00hXSbR_:8lX[bR?>A4i43TA>A0i4CT@
>A51DDEb0d5A00=5LT5ABI801dVB0U6b00EAdU6bDK9A/U7B009A/P03EO9EleGB009ElP06EO=EdUGb
EO9EleWb0UXB00mN4UWbFQ9J4UhBFO9R<V8BHS9N4V8bHQ9R<UhBHS800VHb00IV<FHbIS9V<VHaIS86
JU4026i_LW1bKg9`KVmbL7I]MXd2MVd2NVP00gIXJL1oo`1VOol007Qoo`1R00D011@<40/D32R>;:lX
SRb_:8h/[cT@>A4e43TA>A0i4D5AAG91DDEb@E55LT5AAG99TTfbBI9=TTVBCK99TTfBCK9AddfbDM==
/U7CCK9AddfbFO=EdUGcEM9IleGBEO=EdUWcEM9N4eWbGQ=IlUhCFO9N4eWbGQ=N4V8cGQ9R<UhBHS=N
4V8bGQ9VDVHaIU9R<FIBIS5VDV8aKW5ZDFiaJU1^LFYAKW5^Cg9`KVmbL6i?LW1fKGJ=MVajSGI7NVQf
AfMoo`00N7oo00<01A@<40/00Q0;00dX[bR?::lXSbR_>A0i4CT@>A4i43TA>A15LP03@E4014Eb@E51
DD5A24VB00YAde6bDM9A/U7CDK9AdU6bDM=EdP9ElP0:EO=EdUGbEO9EleGBEO9J4UhCFO82FQ801UhC
FO9J4UXBHS9N4P=R<P04GQ9R<V8bHS83IS801VIBIS9V<VHbIU9V<PIZD@06LW1^Kg9`LVmbL6i_0WI]
00=fSGI]NVP00WYXIgoo001gOol08@0000D@2a@<40/D32R>;:lXSRb_:8hi4CD@>A4i43TA=A15LT5A
AG91DDEb@E55LT5ACK99TTfBBI9=/TVBCI99TP02CK80@E7CCK9AddfbDM==/U7CCK9EleGBFO=EdUGc
EM9IleGBEO=EdUhCFO9N4eWbGQ=IlUhCFO9N4ehBHS9N4V8cGQ9R<UhBHS=N4VIBHS5VDVHaIU9R<FIB
IS5VDVY@KW5ZDFiaJU1^LFYALW1^Cg9`KVmbL7I/NXefKGJ=MTMjJ7IXJN00IWoo001gOol200D0110<
40/D310;0bR_00PXSbR_>A0i4CT@>A4i43TA0d5A00E5LT5A@E51DDEb00U9TP0<DM9A/U7CDK9AdU6b
DM=A/U7BEO9EleGB0UGb00IEleGBEO9ElUGcFO82FQ801UhCFO9J4UXBGQ=IlP=R<P08GQ9R<V8bHS9N
4V8bIS9VDP=V<P04IU9V<VHbIS87JU42LW0026i_LW1bL7J=MVefSGI]MXd3NVQVOol007Ioo`0R0000
1A@<40/D310;;:lXSRb_:8l/[bR>>C4i43TA=A0i<CT@AG91DDEb@E55LT5AAG91DDfbBI9=/dVBCK99
TTfcBI82CK80@U7CCK9AddfbDM==/U7CCK9IleGBEO=EdUWcEM9EleGBFO=EdUhCFO9N4eWbGQ=IlUhC
FO9N4ehBHS=N4V8bGQ9R<ehBHS9N4VIBIS9VDV8aIU9V<VIBHS5VDVYAKW5ZDFiaJU5^LFYALY1^Kg9`
KVmbT6i_MXefKGZ=MVejJ7I7NVQU`6Eoo`00MWoo0P0500@@2a@<40/@308X[`05:8lX[bR_::li4003
>A402ST@>A51DDEb@E51LT5AAG91DD5b2DVB00IAde6bDM9AdU7CDK82DM805U7CEO9EleGbEO=ElUGc
EO9EleGbEO=J4UhCFQ9J4eXBGQ=J4UXCFQ9R<UhB0f8b00eN4V8bHS9R<VHbIU9V<VIBIS9VDVHbIU9V
<P02JU401VYaJU5ZDFYAJW5ZD@=bL007KVmbL7I]MXefKGJ=MVd00WYX00=Yh7ooOol0Hgoo001eOol0
J00000D01A@<40/D32R>;:lXSbb_:8h/[cT@>A4e43Ta>A0i4D5AAG91DDEb@E55LT5AAG99TTfcBI9=
/TVBCK=9TTfbBI9=/dfbDM==/U7CCK9AddfbDM==/UGcEM9IleGBEO=EdUWcEM9EleGBGQ=IlUhCFO9N
4eWbGQ=IlUhCGQ9R<ehBHS=N4V8cGQ9R<ehBHS=R<FIBIS9VDV8aIU9V<VIBHS5^LFYAKW5ZDFiaJU5^
LFi_LY1^Kg9`KVmbT7I]MXefKGZ=MVQjJ6G0JN1TOol007Eoo`<01@<@3003::lXSbR_008X[`05:8li
4CTA>A4i4002>A4024Eb@E51LT5AAG91DD5b@E49BI801E6bDM9AdU7CDK800U7B01MAde6bDM9ElUGc
EO9EleGbEO=ElUGcEO9EleXBFQ=J4UhCFQ9J4eXBGQ=J4UXC009R<P05GQ9R<V8bHS9N4P02HS802FIB
IS9VDVHbIU9V<VIBIS9VDP03JU401VYaJU5ZDFYALW1^K`=bL003KVmfSGJ=009fS@=jJ003JN1oogoo
069oo`00M7oo06X0000500D@2a@<40/D32R?;:lXSbb_:8l/[cD@>C4i43TA=A0i<D5AAG91DDEb@E55
LT5AAG99TTfbBI9=/dVBCK99TTfcBI9AddfbDM==/U7CCK9AddfbDM==/UWcEM9EleGBFO=EdUGcEM9I
leGBGQ=IlUhCFO9N4eWbGQ=IlUhCFO9R<ehBHS=N4V8cGQ9R<ehBHS=V<VIBHS5VDVHbIU9R<FIBIS9^
LFYAKW9ZDFiaJU5^LVi_LY1^Kg:@KVmbT7I]NXifKGJ>MVQjRGIXJN1U`6=oo`00M7oo0`050Q0<00<D
310<::l00RR_00<XSbR_>A401STA00Q1LT5BAG91DD5b@E95LT5A2DVB00=AdU7CDK800U7B01YAde6b
DM9AdU7CEO9EleGbEO=ElUGcEO9EleGbEO=J4UhCFQ9J4eXBGQ=J4UXCFQ9N4ehb0V8b00IR<ehbHS9R
<V8cGS83IU8026HbIU9VDVIBIS9VDVYAJW43JU400fYaJU5bL005LW05MXd3NVP00fWPOomoo`1QOol0
07Aoo`801@1X50`@2a@<40//[bR?;:lXSbb_:8li<CT@>A4e43Ta>A0i4D5AAG91DDEb@E55LT5AAG99
TTfcBI9=/dVBCK=9TTfcBI9AddfbDM==/U7CCK9AddfbDM==/UGcEM9IleGBEO=EdUWcEM9EleGBGQ=I
lUhCFO9N4eWbGQ=IlUhCFO9R<ehBHS=N4V8cGQ9R<ehBHS=R<FIBIS9VDV8aIU9V<VIBHS5^LVYAKW5Z
DFibJU5^LFYALY1^Kg:@KVmbT6i_MXifKGZ>MVejJ7IXNXUYh6=oo`00M7oo0P0500@@31@<40`@308X
[`03:8lX[bR_00Li4@08@E95LT5A@G91DTEb@E51LPY9TP0:DK9Ade7BDM=A/U7CDM9Ade6bDM<2EO<0
1EGbEO=EleGcEO800eGc00eJ4UXCFQ9N4eXBFQ=J4UhCFQ9J4f8bHS=N<P02HS801V8cGS9R<V8bHS=V
<P=VDP05IS9VDVIBIU9V<P02JU401FYaJU5ZDFYAJW401W9`17J=0gYX00=Yh7ooOol0HGoo001cOol0
K00000D01A@/40`D310;;;0XSbb_:8l//3T@>A4e43Ta>A0i4CD@AG91DDEb@E55LT5AAG91DDfcBI9=
/dVBCK=9TTfcBI9=/dVBDM==/U7CCK9AddfbDM==/U7CCK9IleGBEO=EdUWcEM9EleGBFO=EdUhCFO9N
4eWbGQ=IlUhCFO9N4eWbHS=N4V8cGQ9R<ehBHS=N4V8cGQ9VDV8aIU9V<VIBHS5VDVHbIU9ZDFibJU5^
LFYAKW9ZDG:@KVmbT6i_LY1^KgZ>MXejSWI]NXUjJ7Z9MVQYh69oo`00Lgoo0`050a0<1RR_1cTA00Q1
DD5b@E95LT5A@G91DTEb2TVB00]AdU7CDK9Ade7BDM=A/U7CDM9AdeGb00=El`0AEO9EleGcEO=ElUGc
FQ9N4eXBFQ=J4UhCFQ9J4eXBGQ=N<P02HS801f8cGS9R<V8bHS=N<V8b009VDP05IS9VDVIBIU9V<P02
IU801fYaJU5ZLFYAJW5ZDFYa00IbL0=fS@03MXifSGYX009jJ003JN1oogoo061oo`00Lgoo06`01@06
40`D310;52`XSbb_:8l//2R?;:le43Ta>A0i<CD@>C4i44Eb@E55LT5AAG91DDEb@E5=/dVBCK=9TTfc
BI9=/dVBCK=9TU7CCK9AddfbDM==/U7CCK9AddfbEO=EdUWcEM9EleGBFO=EdUGcEM9N4eWbGQ=IlUhC
FO9N4eWbGQ=IlV8cGQ9R<ehBHS=N4V8cGQ9R<ehBIU9V<VIBHS9VDVHbIU9R<VIBJU5^LVYAKW9ZDFib
JU5bT6i`LY1^Kg:@KW1bT7I]NXifSGZ>MVQjRGYXNXUROol007=oo`801@<@30HX[`Pi4@03@G95LT5B
0091LP05AG91DT5bBI99/P03BI801TVbBI99TTVBBK9AdP=Ad`06DM9Ade7CDM=AdU7C0UGc00EElUGc
EO=EleGb00=El`05FQ9J4eXCGQ=J4P02FQ<01UhCFQ9J4f8bHS=N<P9R<P06HS=N<V8bHS9R<fHb0fIB
00eV<VIBIU9VDVHbJW5ZDFYaJU5ZLFYAJW5ZD@06LW001GJ>MXefSGJ=MXh00gYXHWoo001bOol0KP00
00D01Q0<52`@32b_:8l//2R?;:lXScTa>A0i<CD@>C4i43Ta@E55LT5AAG91DDEb@E55LT5ACK=9TTfc
BI9=/dVBCK=9TTfcBI9AddfbDM==/U7CCK9AddfbDM==/UWcEO9EleGBFO=ElUGcEM9IleGbGQ=IlUhC
FQ9N4eWbGQ=J4UhCFO9R<ehBHS=N4V8cGQ9R<ehBHS=N4V8cHS9VDVHbIU9R<VIBIS9VDV8bKW9ZDFib
JU5^LVYAKW9^Kg:@KW1bT6i_LY1^L7Z>MVejSWJ=NXUfJ7Z9JN1QOol0079oo`801@@@30HX[`Li4@06
AG91DT5b@G95LT5B0T5b00E5LTVBBI99TTVb00=9TP03BK99TU7C009Ad`05DM9Ade7CDM=AdP03DM<0
1EGbEO=EleGcEO800eGc00EElUGcFQ=N4eXB009J4`06GQ=J4UXCFQ=N4eXB0V8b00IR<ehbHS9R<V8c
GS82HS800fIBIS9VDP02IU802fHbIU9VDVIBJU5ZLFYAJW5ZDFYaJU401g9`00QfSGJ>MXefSWYXNXUj
J6WPHGoo001aOol0L00000H01A@/40`D;10<;;0X[bR`:8l//2R_>C4e43Ta>A4i<CD@>C51DDEb@E55
LT5AAG91DDEb@E5=/dVBCK=9TTfcBI9=/dVBCK==/U7CCK9AddfbDM==/U7CCK9AddfbEO=EdUWcEO9E
leGBFO=ElUGcEM9N4eXBGQ=IlUhCFQ9N4eWbGQ=J4UhCGQ9R<ehBHS=N4V8cGQ9R<ehBHS=V<VIBHS9V
DVHbIU9R<VIBIS9^LVYAKW9ZDFibJU5^LVi`LY1^L7:@KW1bT6i`NXifSGZ>MXejSWYXNXUfJ6X0H7oo
001aOol200D0100640`@310<1RR_0STA00Hi<CTA>A4i4CTa>A42@G802DEb@E91LT5bAG91DT5bBI99
/`03BI801TVcBI99TTVBDM=AdP=Ad`06DM9Ade7CDM=AdU7C0UGc00EElUGcEO=EleGb00=El`05FQ9J
4eXCGQ=J4P02FQ<01UhCFQ9J4eXCHS=N<P9R<P06HS=N<V8bHS9R<ehb2FIB0VYa00QZDFYaJW5ZLFYA
JW5bL7:@0g9`00YbT7J=MXifSGJ>MXejR7YXNXUYh61oo`00LGoo06l01@0640`D;10<52`X[bR`:8l/
/2R_:;0e43Ta>A4i<CD@>C4i4CTa@E55LT5BAG91DDEb@E95LT5ACK=9TTfcBI9=/dVBCK=9TTfcDK9A
ddfbDM=A/U7CCK9Ade6bDM==/UWcEO9EleGBFO=ElUGcEM9IleGbGQ=IlUhCFQ9N4eWbGQ=J4UhCFO9N
4ehbHS=N4V8cGS9R<ehBHS=N<V8cHS9VDfHbIU9R<VICIS9VDV8bKW9ZDFibJU5^LVYAKW9ZDG:@KW1b
T6i`LY1^L7:@MXejSWJ=NXifSGZ9NVP0HGoo001cOol440`5::l00cTA>C4i4@02>A401STa>A4i4D5b
AG91DP91LP05AG91DT5b@G95LP03BI801TVcBI99TTVBBK=9TP=Ad`05DM9Ade7CDM=AdP03DM<:EO<0
0eXCGQ=J4`02FQ<045hCFQ=J4eXCGQ=J4f8cHS9R<ehbHS=R<V8cGS9R<f8b2VIB0fYa00AZDFYaJW5Z
L@=bL009LY1bL79`LW1fSWJ=MXifSGJ>06=oo`00O7oo05di<CTA>C4e43Ta>A4i<CD@AG91DTEb@E55
LT5BAG91DDEbBI9=/dVBCK=9TTfcBI9=/dVBCK==/U7CDK9AddfbDM=A/U7CCK9AdeGbEO=EdUWcEO9E
leGBFO=ElUGcEM9N4eXBGQ=IlUhCFQ9N4eWbGQ=J4UhCGQ9R<ehbHS=N4V8cGS9R<ehBHS=V<VIBHS9V
DfHbIU9R<VICIS9VDVYAKW9ZDFibJU5^LVYAKW9^L7:@KW1bT6i`LY00J7oo0024Ool01D5B@G91LTEb
@E800T5b00E5LT5BBI99TTVc00=9TP06BK=9TTVBBI9Ade7B0e7C00EAdU7CDM=Ade7B00]El`=J4`05
GQ=J4eXCFQ=N4`03FQ<02V8cGS9R<f8bHS=N<V8cHS9R<ehb2VIB00=ZLFYAJW400VYa00=ZDFYaJW40
KWoo002=Ool0=4VBCK=9TTfcBI9=/dVBCK=9TTfcDK9AddfbDM=A/U7CCK9Ade6bDM=EdUWcEO9EleGB
FO=ElUGcEM9IleGbGQ=IlUhCFQ9N4eWbGQ=J4UhCFO9N4ehbHS=N4V8cGS9R<ehBHS=N<V8cP7oo003o
Oom2Ool00?mood9oo`00\
\>"],
  ImageRangeCache->{{{0.8125, 320.313}, {291.125, -18.1875}} -> {-0.00301271, \
-0.0364253, 0.00371222, 0.00371222}}],

Cell[TextData[{
  "A Paul trap is designed by three hyperbolas of revolution, which are the \
electrodes. The inside diameter of the ring is ",
  Cell[BoxData[
      \(TraditionalForm\`2  r\_0\)]],
  " and the axial separation of the end caps is ",
  Cell[BoxData[
      \(TraditionalForm\`2  z\_0\)]],
  ". The electrostatic potential"
}], "Text",
  CellMargins->{{Inherited, Inherited}, {Inherited, 0}},
  CellTags->{"hyperbolas of revolution", "electrostatic potential"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Phi] = \ \(U\_0\/\(r\_0\%2 + 2  z\_0\%2\)\) \((r\^2 - 2  z\^2)\), 
    \)\)], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`r\^2 = x\^2 + y\^2\)]],
  " is created by the shape of the trap if the ring electrode is held at the \
dc potential ",
  Cell[BoxData[
      \(TraditionalForm\`U\_0\)]],
  " with respect to the two end caps. This static part of the total potential \
confines ions along the ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  "-axis. In the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " direction, the motion is unbounded. The confinement in both of these \
directions is achieved by superimposing the static potential (9.39) by an ",
  StyleBox["rf",
    FontSlant->"Italic"],
  " potential"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Phi]\^rf\), " ", "=", 
        RowBox[{
          FractionBox[
            RowBox[{\(V\_0\), 
              RowBox[{"cos", "(", 
                StyleBox[
                  RowBox[{"\[CapitalOmega]", 
                    StyleBox["t",
                      FontSlant->"Italic"]}]], ")"}]}], 
            \(r\_0\%2 + 2  z\_0\%2\)], \(\((r\^2 - 2  z\^2)\) . \)}]}], 
      TraditionalForm]], "NumberedEquation"],

Cell["\<\
In the case of two ions in the trap, an additional force influences \
the motion of the particles. This interacting force is due to the Coulomb \
repulsion of the ions. In the case of two identical particles, the Coulomb \
force is repulsive between particle 1 and particle 2. The force is given by\
\
\>", "Text",
  CellTags->{"Coulomb repulsion", "Coulomb force"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubsuperscriptBox[
            OverscriptBox["F", 
              AdjustmentBox["\[RightVector]",
                BoxMargins->{{0, 0}, {0.333333, -0.333333}},
                BoxBaselineShift->-0.333333]], "12", "C"], " ", "=", " ", 
          RowBox[{\(q\^2\/\(4  \[Pi]\[Epsilon]\_0\)\), 
            FractionBox[
              RowBox[{
                SubscriptBox[
                  OverscriptBox["x", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.333333, -0.333333}},
                      BoxBaselineShift->-0.333333]], "1"], "-", 
                SubscriptBox[
                  OverscriptBox["x", 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0, 0}, {0.333333, -0.333333}},
                      BoxBaselineShift->-0.333333]], "2"]}], 
              RowBox[{
                SubscriptBox[
                  OverscriptBox[\(| x\), 
                    AdjustmentBox["\[RightVector]",
                      BoxMargins->{{0.112676, -0.112676}, {-0.111111, 
                      0.111111}},
                      BoxBaselineShift->0.111111]], "1"], "-", 
                RowBox[{
                  SubscriptBox[
                    OverscriptBox["x", 
                      AdjustmentBox["\[RightVector]",
                        BoxMargins->{{0, 0}, {0.333333, -0.333333}},
                        BoxBaselineShift->-0.333333]], "2"], 
                  \(|\^3\)}]}]]}]}], ","}], TraditionalForm]], 
  "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`x\&\[RightVector]\_\(1, 2\)\)]],
  " denotes the position of particle 1 and 2, respectively, both carrying the \
charge ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". In addition to these main forces, there are two other kinds of forces \
coming from the emission of photons and from the cooling process of the ions. \
These two forces, compared with the other three forces, are of minor \
importance in connection with the classical motion of the ions. So we neglect \
them in our further considerations. The classical equations of motion for two \
ions in a Paul trap now read"
}], "Text",
  CellTags->{"photons", "classical equations of motion"}],

Cell[BoxData[
    FormBox[
      RowBox[{"m", " ", 
        FormBox[
          RowBox[{\(\(\(x\_i\)\&\[RightVector]\)\& .. \), " ", "=", "  ", 
            RowBox[{\(F\&\[RightVector]\_i\%T\), " ", "+", " ", 
              SubsuperscriptBox[\(F\&\[RightVector]\), 
                StyleBox["ij",
                  FontSlant->"Italic"], "C"]}]}],
          "TraditionalForm"], "   ", "with", " ", 
        FormBox[\(i, j = 1, 2\),
          "TraditionalForm"], " ", "and", " ", 
        FormBox[\(j \[NotEqual] \(i . \)\),
          "TraditionalForm"]}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "In equation (9.42), ",
  Cell[BoxData[
      \(TraditionalForm\`F\&\[RightVector]\_i\%T\)]],
  " denotes the linear trap force"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(F\&\[RightVector]\_i\%T\), "=", " ", 
          RowBox[{\(-2\), "q", " ", 
            FractionBox[
              RowBox[{\(U\_0\), "+", 
                RowBox[{\(V\_0\), 
                  RowBox[{"cos", "(", 
                    StyleBox[
                      RowBox[{"\[CapitalOmega]", 
                        StyleBox["t",
                          FontSlant->"Italic"]}]], ")"}]}]}], 
              \(r\_0\%2 + 2  z\_0\%2\)], 
            \((x\&\[RightVector]\_i - 3 \( z\_i\) e\&\[RightVector]\_z)
              \)}]}], " ", ",", "   ", 
        FormBox[\(i = 1, 2\),
          "TraditionalForm"], ","}], TraditionalForm]], "NumberedEquation"],

Cell[TextData[{
  "where \[CapitalOmega] is the external driving frequency. It is obvious \
that the equations of motion depend on time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". We can eliminate this time dependency by the averaging method of ",
  ButtonBox["Landau and Lifshitz [1981]",
    ButtonData:>{"Literat.nb", "Landau and Lifshitz-1981"},
    ButtonStyle->"Hyperlink"],
  ". Before we carry out this procedure, we introduce relative and \
center-of-mass coordinates by ",
  Cell[BoxData[
      \(TraditionalForm
      \`x\&\[RightVector] = x\&\[RightVector]\_1 - x\&\[RightVector]\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm
      \`X\&\[RightVector] = x\&\[RightVector]\_1 + x\&\[RightVector]\_2\)]],
  ", respectively. The introduction of cylindrical coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho], \[Zeta])\)\)]],
  " simplifies the equations of motion in the relative coordinates to"
}], "Text",
  CellTags->{
  "averaging method of Landau", "center-of-mass coordinates", 
    "cylindrical coordinates"}],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[Rho]\& .. \)\  + \ \[Omega]\_\[Rho]\%2\ \[Rho]\  = \ 
      \(\(\[Omega]\_\[Rho]\%2\) 
            \[Rho]\)\/\((\@\(\[Rho]\^2 + \[Zeta]\^2\))\)\^3 + \ 
        l\_z\%2\/\[Rho]\^3, \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[Zeta]\& .. \)\  + \ \(\[Omega]\_\[Zeta]\%2\) \[Zeta]\  = \ 
      \(\(\[Omega]\_\[Rho]\%2\) 
          \[Zeta]\)\/\((\@\(\[Rho]\^2 + \[Zeta]\^2\))\)\^3, \)\)], 
  "NumberedEquation"],

Cell[TextData[{
  "where the dots denote differentiation with respect to time ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". The constants ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_\[Rho]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_\[Zeta]\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`l\_z\)]],
  " denote the secular frequencies in radial and axial directions and the \
angular momentum directed along the ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  "-axis. The secular frequencies ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_\[Rho]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_\[Zeta]\)]],
  " are dimensionless quantities containing the ac and dc voltage, the mass ",
  
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " of the ions, the external driving frequency \[CapitalOmega], and the \
geometrical properties of the trap. For a detailed description of the \
derivation of these two equations, compare ",
  ButtonBox["Baumann and Nonnenmacher [1992]",
    ButtonData:>{"Literat.nb", "Baumann and Nonnenmacher-1992"},
    ButtonStyle->"Hyperlink"],
  ". A further scaling of the dimensionless time \[Tau] by one of the secular \
frequencies ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((\[Tau]\^\[Prime] = \(\[Omega]\_\[Rho]\) \[Tau])\)\)]],
  " and introducing the ratios ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu] = l\_z/\[Omega]\_\[Rho]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = \[Omega]\_\[Zeta]/\[Omega]\_\[Rho]\)]],
  "  gives us"
}], "Text",
  CellTags->"secular frequencies"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(\[Rho]\& .. \)\  + \ \ \[Rho]\  = \ 
      \[Rho]\/\((\@\(\[Rho]\^2 + \[Zeta]\^2\))\)\^3 + \ \[Nu]\^2\/\[Rho]\^3, 
    \)\)], "NumberedEquation"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\[Zeta]\& .. \)\  + \ \(\[Lambda]\^2\) \[Zeta]\  = \ 
      \[Zeta]\/\((\@\(\[Rho]\^2 + \[Zeta]\^2\))\)\^3 . \)], "NumberedEquation"],

Cell["\<\
These two equations describe the relative ion motion in a Paul trap \
in the secular approximation. The two equations are derivable from the \
Lagrangian\
\>", "Text",
  CellTags->{"relative ion motion", "Lagrangian"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LPaul\  = \ 
      \(1\/2\) \((
            \((\[PartialD]\_\[Tau]\ \[Rho][\[Tau]])\)\^2 + 
              \((\[PartialD]\_\[Tau]\ \[Zeta][\[Tau]])\)\^2)\) - 
        \((\(1\/2\) 
              \((\[Rho][\[Tau]]\^2 + \(\[Lambda]\^2\) \[Zeta][\[Tau]]\^2)\) + 
            1\/\@\(\[Rho][\[Tau]]\^2 + \[Zeta][\[Tau]]\^2\) + 
            \[Nu]\^2\/\(2  \[Rho][\[Tau]]\^2\))\); 
    LPaul // LieTraditionalForm\)], "Input"],

Cell[BoxData[
    \(\(-\(\[Nu]\^2\/\(2\ \[Rho]\^2\)\)\) + 
      1\/2\ \((\(-\[Zeta]\^2\)\ \[Lambda]\^2 - \[Rho]\^2)\) - 
      1\/\@\(\[Zeta]\^2 + \[Rho]\^2\) + 
      1\/2\ \((\[Zeta]\_\[Tau]\%2 + \[Rho]\_\[Tau]\%2)\)\)], "Output"]
}, Open  ]],

Cell["\<\
describing in classical terms a particle with two degrees of \
freedom in an anharmonic potential. The equations of motion follow by \
applying the Euler derivative to the Lagrangian:\
\>", "Text",
  CellTags->{"anharmonic potential", "Euler derivative", "Lagrangian"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PaulTrapEquations\  = \ 
      Thread[\[ScriptCapitalE]\_{\[Zeta], \[Rho]}\%\[Tau][LPaul] == {0, 0}]; 
    PaulTrapEquations // LTF\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            RowBox[{
              RowBox[{\(\(-\[Zeta]\)\ \[Lambda]\^2\), "+", 
                StyleBox[\(\[Zeta]\/\((\[Zeta]\^2 + \[Rho]\^2)\)\^\(3/2\)\),
                  ScriptLevel->0], "-", \(\[Zeta]\_\(\[Tau], \[Tau]\)\)}], 
              "==", "0"}]},
          {
            RowBox[{
              RowBox[{\(\[Nu]\^2\/\[Rho]\^3\), "-", "\[Rho]", "+", 
                StyleBox[\(\[Rho]\/\((\[Zeta]\^2 + \[Rho]\^2)\)\^\(3/2\)\),
                  ScriptLevel->0], 
                StyleBox["-",
                  ScriptLevel->0], 
                SubscriptBox[
                  StyleBox["\[Rho]",
                    ScriptLevel->0], \(\[Tau], \[Tau]\)]}], "==", "0"}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This system of equations is the starting point of our examination in \
connection with generalized symmetries. To detect the cases under which this \
second-order system of equation is analytically solvable, we have to reveal \
the parameter combinations \[Nu] and \[Lambda] for which Noether",
  "\[CloseCurlyQuote]s",
  " theorem is satisfied. We determine the integrals of motion by applying \
the above theory to the equations of motion. The function ",
  StyleBox["Baecklund[]", "MmaText"],
  " serves as the main tool to derive the integrals of motion:"
}], "Text",
  CellTags->{"generalized symmetries", "Noether's theorem", "Baecklund[]"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(PaulIntegrals\  = \ 
          Baecklund[
            PaulTrapEquations, {\[Zeta], \[Rho]}, {\[Tau]}, {
              \[PartialD]\_\(\[Tau], \[Tau]\)\[Rho][\[Tau]], 
              \[PartialD]\_\(\[Tau], \[Tau]\)\[Zeta][\[Tau]]}, 
            1, {\[Nu], \[Lambda]}, AnsatzPoly \[Rule] {2, 1}]; 
        PaulIntegrals // TableForm[LieTraditionalForm[#]], 
        TableHeadings -> {
            Automatic, {\*"\"\<\!\(Q\_\(1, 2\)\)\>\"", "\<Parameters\>", 
              "\<Integral\>"}}, TableSpacing -> {1, 1}]\)&\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"\"\>", "\<\"\\!\\(Q\\_\\(1, 2\\)\\)\"\>", 
            "\<\"Parameters\"\>", "\<\"Integral\"\>"},
          {"1", GridBox[{
                {\(\[Zeta]\_\[Tau]\)},
                {\(\[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] \(-2\)\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-2\)\ \[Zeta]\^2 - \[Nu]\^2\/\(2\ \[Rho]\^2\) - 
              \[Rho]\^2\/2 - 1\/\@\(\[Zeta]\^2 + \[Rho]\^2\) - 
              \[Zeta]\_\[Tau]\%2\/2 - \[Rho]\_\[Tau]\%2\/2\)},
          {"2", GridBox[{
                {\(\[Zeta]\_\[Tau]\)},
                {\(\[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] 0\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(\[Nu]\^2\/\(2\ \[Rho]\^2\)\)\) - \[Rho]\^2\/2 - 
              1\/\@\(\[Zeta]\^2 + \[Rho]\^2\) - \[Zeta]\_\[Tau]\%2\/2 - 
              \[Rho]\_\[Tau]\%2\/2\)},
          {"3", GridBox[{
                {\(\[Zeta]\_\[Tau]\)},
                {\(\[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(\[Zeta]\^2\/2\)\) - \[Nu]\^2\/\(2\ \[Rho]\^2\) - 
              \[Rho]\^2\/2 - 1\/\@\(\[Zeta]\^2 + \[Rho]\^2\) - 
              \[Zeta]\_\[Tau]\%2\/2 - \[Rho]\_\[Tau]\%2\/2\)},
          {"4", GridBox[{
                {\(\[Zeta]\_\[Tau]\)},
                {\(\[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] 2\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-2\)\ \[Zeta]\^2 - \[Nu]\^2\/\(2\ \[Rho]\^2\) - 
              \[Rho]\^2\/2 - 1\/\@\(\[Zeta]\^2 + \[Rho]\^2\) - 
              \[Zeta]\_\[Tau]\%2\/2 - \[Rho]\_\[Tau]\%2\/2\)},
          {"5", GridBox[{
                {\(\[Zeta]\_\[Tau]\)},
                {\(\[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] \[Lambda]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(-\(1\/2\)\)\ \[Zeta]\^2\ \[Lambda]\^2 - 
              \[Nu]\^2\/\(2\ \[Rho]\^2\) - \[Rho]\^2\/2 - 
              1\/\@\(\[Zeta]\^2 + \[Rho]\^2\) - \[Zeta]\_\[Tau]\%2\/2 - 
              \[Rho]\_\[Tau]\%2\/2\)},
          {"6", GridBox[{
                {\(\[Rho]\ \[Rho]\_\[Tau]\)},
                {\(\[Rho]\ \[Zeta]\_\[Tau] - 2\ \[Zeta]\ \[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] \(-2\)\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(\[Zeta]\ \[Nu]\^2\)\/\[Rho]\^2 - \[Zeta]\ \[Rho]\^2 + 
              \[Zeta]\/\@\(\[Zeta]\^2 + \[Rho]\^2\) - 
              \[Rho]\ \[Zeta]\_\[Tau]\ \[Rho]\_\[Tau] + 
              \[Zeta]\ \[Rho]\_\[Tau]\%2\)},
          {"7", GridBox[{
                {\(\[Rho]\ \[Rho]\_\[Tau]\)},
                {\(\[Rho]\ \[Zeta]\_\[Tau] - 2\ \[Zeta]\ \[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] 2\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(\[Zeta]\ \[Nu]\^2\)\/\[Rho]\^2 - \[Zeta]\ \[Rho]\^2 + 
              \[Zeta]\/\@\(\[Zeta]\^2 + \[Rho]\^2\) - 
              \[Rho]\ \[Zeta]\_\[Tau]\ \[Rho]\_\[Tau] + 
              \[Zeta]\ \[Rho]\_\[Tau]\%2\)},
          {"8", GridBox[{
                {
                  \(\(-\[Rho]\^2\)\ \[Zeta]\_\[Tau] + 
                    \[Zeta]\ \[Rho]\ \[Rho]\_\[Tau]\)},
                {
                  \(\[Zeta]\ \[Rho]\ \[Zeta]\_\[Tau] - 
                    \[Zeta]\^2\ \[Rho]\_\[Tau]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(\[Nu] \[Rule] \[Nu]\)},
                {\(\[Lambda] \[Rule] 1\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], 
            \(\(\[Zeta]\^2\ \[Nu]\^2\)\/\(2\ \[Rho]\^2\) + 
              1\/2\ \[Rho]\^2\ \[Zeta]\_\[Tau]\%2 - 
              \[Zeta]\ \[Rho]\ \[Zeta]\_\[Tau]\ \[Rho]\_\[Tau] + 
              1\/2\ \[Zeta]\^2\ \[Rho]\_\[Tau]\%2\)}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Center}],
      TableForm[ {{{
        Subscript[ \[Zeta], \[Tau]], 
        Subscript[ \[Rho], \[Tau]]}, {\[Nu] -> \[Nu], \[Lambda] -> -2}, 
        Plus[ 
          Times[ -2, 
            Power[ \[Zeta], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Rho], 2]], 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ \[Zeta], 2], 
                Power[ \[Rho], 2]], 
              Rational[ -1, 2]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Zeta], \[Tau]], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}, {{
        Subscript[ \[Zeta], \[Tau]], 
        Subscript[ \[Rho], \[Tau]]}, {\[Nu] -> \[Nu], \[Lambda] -> 0}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Rho], 2]], 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ \[Zeta], 2], 
                Power[ \[Rho], 2]], 
              Rational[ -1, 2]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Zeta], \[Tau]], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}, {{
        Subscript[ \[Zeta], \[Tau]], 
        Subscript[ \[Rho], \[Tau]]}, {\[Nu] -> \[Nu], \[Lambda] -> 1}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Zeta], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Rho], 2]], 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ \[Zeta], 2], 
                Power[ \[Rho], 2]], 
              Rational[ -1, 2]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Zeta], \[Tau]], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}, {{
        Subscript[ \[Zeta], \[Tau]], 
        Subscript[ \[Rho], \[Tau]]}, {\[Nu] -> \[Nu], \[Lambda] -> 2}, 
        Plus[ 
          Times[ -2, 
            Power[ \[Zeta], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Rho], 2]], 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ \[Zeta], 2], 
                Power[ \[Rho], 2]], 
              Rational[ -1, 2]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Zeta], \[Tau]], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}, {{
        Subscript[ \[Zeta], \[Tau]], 
        Subscript[ \[Rho], \[Tau]]}, {\[Nu] -> \[Nu], \[Lambda] -> 
        \[Lambda]}, 
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Zeta], 2], 
            Power[ \[Lambda], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Rho], 2]], 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ \[Zeta], 2], 
                Power[ \[Rho], 2]], 
              Rational[ -1, 2]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Zeta], \[Tau]], 2]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}, {{
        Times[ \[Rho], 
          Subscript[ \[Rho], \[Tau]]], 
        Plus[ 
          Times[ \[Rho], 
            Subscript[ \[Zeta], \[Tau]]], 
          Times[ -2, \[Zeta], 
            Subscript[ \[Rho], \[Tau]]]]}, {\[Nu] -> \[Nu], 
        \[Lambda] -> -2}, 
        Plus[ 
          Times[ \[Zeta], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ -1, \[Zeta], 
            Power[ \[Rho], 2]], 
          Times[ \[Zeta], 
            Power[ 
              Plus[ 
                Power[ \[Zeta], 2], 
                Power[ \[Rho], 2]], 
              Rational[ -1, 2]]], 
          Times[ -1, \[Rho], 
            Subscript[ \[Zeta], \[Tau]], 
            Subscript[ \[Rho], \[Tau]]], 
          Times[ \[Zeta], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}, {{
        Times[ \[Rho], 
          Subscript[ \[Rho], \[Tau]]], 
        Plus[ 
          Times[ \[Rho], 
            Subscript[ \[Zeta], \[Tau]]], 
          Times[ -2, \[Zeta], 
            Subscript[ \[Rho], \[Tau]]]]}, {\[Nu] -> \[Nu], \[Lambda] -> 2}, 
        Plus[ 
          Times[ \[Zeta], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ -1, \[Zeta], 
            Power[ \[Rho], 2]], 
          Times[ \[Zeta], 
            Power[ 
              Plus[ 
                Power[ \[Zeta], 2], 
                Power[ \[Rho], 2]], 
              Rational[ -1, 2]]], 
          Times[ -1, \[Rho], 
            Subscript[ \[Zeta], \[Tau]], 
            Subscript[ \[Rho], \[Tau]]], 
          Times[ \[Zeta], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}, {{
        Plus[ 
          Times[ -1, 
            Power[ \[Rho], 2], 
            Subscript[ \[Zeta], \[Tau]]], 
          Times[ \[Zeta], \[Rho], 
            Subscript[ \[Rho], \[Tau]]]], 
        Plus[ 
          Times[ \[Zeta], \[Rho], 
            Subscript[ \[Zeta], \[Tau]]], 
          Times[ -1, 
            Power[ \[Zeta], 2], 
            Subscript[ \[Rho], \[Tau]]]]}, {\[Nu] -> \[Nu], \[Lambda] -> 1}, 
        Plus[ 
          Times[ 
            Rational[ 1, 2], 
            Power[ \[Zeta], 2], 
            Power[ \[Nu], 2], 
            Power[ \[Rho], -2]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ \[Rho], 2], 
            Power[ 
              Subscript[ \[Zeta], \[Tau]], 2]], 
          Times[ -1, \[Zeta], \[Rho], 
            Subscript[ \[Zeta], \[Tau]], 
            Subscript[ \[Rho], \[Tau]]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ \[Zeta], 2], 
            Power[ 
              Subscript[ \[Rho], \[Tau]], 2]]]}}, TableHeadings -> {
        Automatic, {"\!\(Q\_\(1, 2\)\)", "Parameters", "Integral"}}, 
        TableSpacing -> {1, 1}]]], "Output",
  CellMargins->{{2, 2}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->0,
  GridBoxOptions->{ColumnWidths->Automatic}]
}, Open  ]],

Cell[TextData[{
  "The result contains eight cases for which ",
  StyleBox["Baecklund[]", "MmaText"],
  " found integrals. The assumption of the calculation was that the \
characteristics are polynomials in the dependent variables and their \
derivatives. "
}], "Text"],

Cell[TextData[{
  "Among the obtained integrals are the total energy of the Paul trap, the \
angular momentum and its generalization, and integrals which are related to \
the Runge-Lenz vector. In all cases for which generalized symmetries are \
known, we find that the two ions are confined to a two-dimensional surface in \
phase space. These two integrals are the total energy plus a second constant \
of motion. The existence of two integrals in a phase space with two \
dimensions of freedom is sufficient to determine a regular motion and are \
thus integrable (cf. ",
  ButtonBox["Tabor [1989]",
    ButtonData:>{"Literat.nb", "Tabor-1989"},
    ButtonStyle->"Hyperlink"],
  "). "
}], "Text",
  CellTags->{
  "Runge-Lenz vector", "Paul trap", "phase space", "regular motion"}],

Cell[TextData[{
  "The integrability of the equation of motion is, in fact, closely related \
to the ratios of the two secular frequencies ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_\[Rho]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]\_z\)]],
  ". We find that integrals exist for equal frequencies ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Lambda] = \(\[PlusMinus]1\))\)\)]],
  " and that the axial frequency is twice as large as the radial frequency ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Lambda] = \(\[PlusMinus]2\))\)\)]],
  ", independent of the value of \[Nu]. We note that the case with ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] = \(\[PlusMinus]2\)\)]],
  " is related to the Runge-Lenz vector known from Kepler\[CloseCurlyQuote]s \
problem in classical mechanics."
}], "Text",
  CellTags->"Kepler problem"],

Cell[TextData[{
  "So far, we illustrated the application of ",
  StyleBox["Baecklund[]", "MmaText"],
  " for different types of differential equations. We demonstrated that the \
function is capable of finding the generalized symmetries of PDEs. In the \
case of second-order ODEs the generalized symmetries are beneficial, in \
connection with Noether",
  "\[CloseCurlyQuote]s",
  " theorem, for constructing solutions at least in implicit form. The \
existence of a sufficient number of integrals of motion excludes the \
occurrence of chaotic motion."
}], "Text"],

Cell[TextData[ButtonBox["Next notebook",
  ButtonData:>{"symmet8.nb", None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellFrame->{{0, 0}, {0, 0.5}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
Evaluator->"Local",
WindowSize->{734, 668},
WindowMargins->{{10, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->424,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"], "     ", 
          StyleBox[ "Generalized Symmetries", FontSlant -> "Italic"]}], 
        "Header"], Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ 
            "Section", CounterFunction :> (
              Part[ {"Introduction", "Elements of Generalized Symmetries", 
                "Algorithm for Calculation of Generalized Symmetries", 
                "Examples", 
                "Second-Order ODEs and the Euler-Lagrange Equation", 
                "Algorithm for Conservation Laws of Second-Order ODEs", 
                "Examples for Second-Order ODEs"}, #]&)], FontSlant -> 
            "Italic"], "     ", 
          StyleBox[ 
            CounterBox[ "Page"], "PageNumber"]}], "Header"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True,
"FirstPageFace"->Right},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.25,
StyleDefinitions -> "BookStyles.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Generalized Symmetries of Partial Differential Equations"->{
    Cell[1739, 51, 373, 5, 117, "ChapterLine",
      CounterAssignments->{{"Title", 8}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Generalized Symmetries of Partial Differential Equations"]},
  "Introduction"->{
    Cell[2456, 66, 354, 10, 52, "Section",
      Evaluatable->False,
      CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {
          "SubSubTitle", 0}, {"Section", 0}, {"SubSection", 0}, {
          "SubSubSection", 0}, {"NumberedEquation", 0}, {
          "NumberedFigure", 0}, {"NumberedTable", 0}},
      CellTags->"Introduction"]},
  "classical method"->{
    Cell[2813, 78, 893, 15, 180, "Text",
      CellTags->{
      "classical method", "non-classical method", "point transformations", 
        "contact transformations"}]},
  "non-classical method"->{
    Cell[2813, 78, 893, 15, 180, "Text",
      CellTags->{
      "classical method", "non-classical method", "point transformations", 
        "contact transformations"}]},
  "point transformations"->{
    Cell[2813, 78, 893, 15, 180, "Text",
      CellTags->{
      "classical method", "non-classical method", "point transformations", 
        "contact transformations"}]},
  "contact transformations"->{
    Cell[2813, 78, 893, 15, 180, "Text",
      CellTags->{
      "classical method", "non-classical method", "point transformations", 
        "contact transformations"}],
    Cell[23516, 681, 1120, 21, 180, "Text",
      CellTags->{
      "characteristic", "Baecklund[]", 
        "generalized symmetries of first order", "contact transformations", 
        "second-order generalized symmetries"}]},
  "variational principle"->{
    Cell[3709, 95, 1319, 23, 222, "Text",
      CellTags->{
      "variational principle", "symmetry group method", "conservation laws", 
        "invariance properties", "variational integral", 
        "integrals of motion"}]},
  "symmetry group method"->{
    Cell[3709, 95, 1319, 23, 222, "Text",
      CellTags->{
      "variational principle", "symmetry group method", "conservation laws", 
        "invariance properties", "variational integral", 
        "integrals of motion"}]},
  "conservation laws"->{
    Cell[3709, 95, 1319, 23, 222, "Text",
      CellTags->{
      "variational principle", "symmetry group method", "conservation laws", 
        "invariance properties", "variational integral", 
        "integrals of motion"}],
    Cell[65416, 1874, 664, 15, 117, "Text",
      CellTags->{"Baecklund[]", "conservation laws", "invariant solution"}]},
  "invariance properties"->{
    Cell[3709, 95, 1319, 23, 222, "Text",
      CellTags->{
      "variational principle", "symmetry group method", "conservation laws", 
        "invariance properties", "variational integral", 
        "integrals of motion"}]},
  "variational integral"->{
    Cell[3709, 95, 1319, 23, 222, "Text",
      CellTags->{
      "variational principle", "symmetry group method", "conservation laws", 
        "invariance properties", "variational integral", 
        "integrals of motion"}]},
  "integrals of motion"->{
    Cell[3709, 95, 1319, 23, 222, "Text",
      CellTags->{
      "variational principle", "symmetry group method", "conservation laws", 
        "invariance properties", "variational integral", 
        "integrals of motion"}],
    Cell[69854, 1996, 1014, 21, 159, "Text",
      CellTags->{
      "divergence formula", "integrals of motion", "Euler-Lagrange system", 
        "variational symmetries", "Baecklund[]"}],
    Cell[78690, 2252, 1230, 33, 159, "Text",
      CellTags->{"chaotic evolution", "integrals of motion", "Baecklund[]"}],
    Cell[107782, 3147, 1035, 24, 138, "Text",
      CellTags->{
      "AnsatzPoly", "Baecklund[]", "polynomial ansatz", 
        "integrals of motion"}],
    Cell[326126, 9711, 353, 7, 75, "Text",
      CellTags->"integrals of motion"]},
  "nonlinear dynamics"->{
    Cell[5031, 120, 635, 12, 117, "Text",
      CellTags->{
      "nonlinear dynamics", "generalized method of Lie's classical theory"}],
    Cell[31965, 923, 552, 11, 96, "Text",
      CellTags->{
      "nonlinear dynamics", "potential Burgers equation", "prolongation"}]},
  "generalized method of Lie's classical theory"->{
    Cell[5031, 120, 635, 12, 117, "Text",
      CellTags->{
      "nonlinear dynamics", 
        "generalized method of Lie's classical theory"}]},
  "Elements of Generalized Symmetries"->{
    Cell[5703, 137, 160, 6, 52, "Section",
      CellTags->"Elements of Generalized Symmetries"]},
  "algorithm of generalized symmetries"->{
    Cell[5866, 145, 1285, 37, 138, "Text",
      CellTags->"algorithm of generalized symmetries"]},
  "point symmetries"->{
    Cell[7947, 217, 458, 8, 96, "Text",
      CellTags->{
      "point symmetries", "non-classical symmetries", 
        "potential symmetries"}]},
  "non-classical symmetries"->{
    Cell[7947, 217, 458, 8, 96, "Text",
      CellTags->{
      "point symmetries", "non-classical symmetries", 
        "potential symmetries"}]},
  "potential symmetries"->{
    Cell[7947, 217, 458, 8, 96, "Text",
      CellTags->{
      "point symmetries", "non-classical symmetries", 
        "potential symmetries"}]},
  "infinitesimal transformations"->{
    Cell[10610, 293, 155, 4, 33, "Text",
      CellTags->"infinitesimal transformations"]},
  "transformation of the dependent variables"->{
    Cell[12428, 343, 333, 8, 54, "Text",
      CellTags->"transformation of the dependent variables"]},
  "characteristic"->{
    Cell[12983, 359, 520, 16, 54, "Text",
      CellTags->{"characteristic", "infinitesimals"}],
    Cell[23516, 681, 1120, 21, 180, "Text",
      CellTags->{
      "characteristic", "Baecklund[]", 
        "generalized symmetries of first order", "contact transformations", 
        "second-order generalized symmetries"}]},
  "infinitesimals"->{
    Cell[12983, 359, 520, 16, 54, "Text",
      CellTags->{"characteristic", "infinitesimals"}]},
  "determination of the characteristics"->{
    Cell[13820, 386, 684, 16, 117, "Text",
      CellTags->"determination of the characteristics"]},
  "prolongation"->{
    Cell[14686, 410, 312, 9, 54, "Text",
      CellTags->"prolongation"],
    Cell[17131, 484, 242, 9, 26, "ListItem",
      Evaluatable->False,
      CellTags->"prolongation"],
    Cell[31965, 923, 552, 11, 96, "Text",
      CellTags->{
      "nonlinear dynamics", "potential Burgers equation", "prolongation"}],
    Cell[62092, 1796, 495, 8, 96, "Text",
      CellTags->{"evolutionary representation", "prolongation"}]},
  "solution manifold"->{
    Cell[15334, 431, 1313, 33, 159, "Text",
      CellTags->{
      "solution manifold", "linear coupled PDEs for the characteristics"}]},
  "linear coupled PDEs for the characteristics"->{
    Cell[15334, 431, 1313, 33, 159, "Text",
      CellTags->{
      "solution manifold", "linear coupled PDEs for the characteristics"}]},
  "Algorithm for the Calculation of Generalized Symmetries"->{
    Cell[16684, 469, 198, 6, 52, "Section",
      CellTags->"Algorithm for the Calculation of Generalized Symmetries"]},
  "algorithm of calculating generalized symmetries"->{
    Cell[16885, 477, 243, 5, 54, "Text",
      CellTags->"algorithm of calculating generalized symmetries"]},
  "characteristics"->{
    Cell[17522, 500, 194, 6, 26, "ListItem",
      CellTags->"characteristics"],
    Cell[18815, 547, 1640, 38, 243, "Text",
      CellTags->{"Baecklund[]", "characteristics"}],
    Cell[51765, 1499, 498, 11, 96, "Text",
      CellTags->{"characteristics", "PDESolve[]"}],
    Cell[61317, 1770, 612, 18, 54, "Text",
      CellTags->"characteristics"],
    Cell[72606, 2079, 408, 11, 45, "ListItem",
      CellTags->{"determining equations", "characteristics"}],
    Cell[104871, 3060, 1854, 51, 117, "Text",
      CellTags->{"characteristics", "total energy"}],
    Cell[202735, 6080, 265, 5, 54, "Text",
      CellTags->{"characteristics", "solution in implicit form"}]},
  "redundant information"->{
    Cell[17719, 508, 218, 6, 26, "ListItem",
      Evaluatable->False,
      CellTags->"redundant information"]},
  "determining equations"->{
    Cell[18131, 522, 566, 19, 45, "ListItem",
      Evaluatable->False,
      CellTags->"determining equations"],
    Cell[72606, 2079, 408, 11, 45, "ListItem",
      CellTags->{"determining equations", "characteristics"}]},
  "Baecklund[]"->{
    Cell[18815, 547, 1640, 38, 243, "Text",
      CellTags->{"Baecklund[]", "characteristics"}],
    Cell[20932, 610, 965, 17, 180, "Text",
      CellTags->{"diffusion equation", "Baecklund[]"}],
    Cell[23516, 681, 1120, 21, 180, "Text",
      CellTags->{
      "characteristic", "Baecklund[]", 
        "generalized symmetries of first order", "contact transformations", 
        "second-order generalized symmetries"}],
    Cell[34490, 998, 1060, 30, 117, "Text",
      CellTags->"Baecklund[]"],
    Cell[36324, 1052, 1272, 35, 138, "Text",
      CellTags->{
      "cylindrical geometry", "spherical geometry", "Burgers equation", 
        "KdV equation", "Baecklund[]"}],
    Cell[44826, 1304, 792, 20, 117, "Text",
      CellTags->{"wave equations", "Baecklund[]"}],
    Cell[65416, 1874, 664, 15, 117, "Text",
      CellTags->{"Baecklund[]", "conservation laws", "invariant solution"}],
    Cell[69854, 1996, 1014, 21, 159, "Text",
      CellTags->{
      "divergence formula", "integrals of motion", "Euler-Lagrange system", 
        "variational symmetries", "Baecklund[]"}],
    Cell[78690, 2252, 1230, 33, 159, "Text",
      CellTags->{"chaotic evolution", "integrals of motion", "Baecklund[]"}],
    Cell[107782, 3147, 1035, 24, 138, "Text",
      CellTags->{
      "AnsatzPoly", "Baecklund[]", "polynomial ansatz", 
        "integrals of motion"}],
    Cell[208166, 6221, 393, 8, 75, "Text",
      CellTags->{"similarity reduction", "Baecklund[]"}],
    Cell[833157, 23065, 666, 11, 117, "Text",
      CellTags->{
      "generalized symmetries", "Noether's theorem", "Baecklund[]"}]},
  "Examples"->{
    Cell[20492, 590, 108, 6, 52, "Section",
      CellTags->"Examples"]},
  "Diffusion equation"->{
    Cell[20849, 607, 80, 1, 49, "Subsection",
      CellTags->"Diffusion equation"]},
  "diffusion equation"->{
    Cell[20932, 610, 965, 17, 180, "Text",
      CellTags->{"diffusion equation", "Baecklund[]"}]},
  "generalized symmetries of first order"->{
    Cell[23516, 681, 1120, 21, 180, "Text",
      CellTags->{
      "characteristic", "Baecklund[]", 
        "generalized symmetries of first order", "contact transformations", 
        "second-order generalized symmetries"}]},
  "second-order generalized symmetries"->{
    Cell[23516, 681, 1120, 21, 180, "Text",
      CellTags->{
      "characteristic", "Baecklund[]", 
        "generalized symmetries of first order", "contact transformations", 
        "second-order generalized symmetries"}]},
  "CharExpression"->{
    Cell[27193, 782, 1263, 35, 159, "Text",
      CellTags->"CharExpression"]},
  "generalized symmetries"->{
    Cell[31010, 895, 819, 20, 138, "Text",
      CellTags->"generalized symmetries"],
    Cell[42311, 1230, 105, 1, 33, "Text",
      CellTags->"generalized symmetries"],
    Cell[56564, 1638, 1384, 34, 123, "Text",
      CellTags->{
      "variational derivative", "Euler derivative", 
        "generalized symmetries"}],
    Cell[63067, 1819, 648, 11, 138, "Text",
      CellTags->{
      "Lie point symmetries", "generalized symmetries", 
        "invariance condition"}],
    Cell[68287, 1950, 1209, 32, 139, "Text",
      CellTags->{
      "Noether's theorem", "Fr\[EAcute]chet derivative", 
        "evolutionary vector field", "variational symmetry", 
        "generalized symmetries", "conserved quantities"}],
    Cell[833157, 23065, 666, 11, 117, "Text",
      CellTags->{
      "generalized symmetries", "Noether's theorem", "Baecklund[]"}]},
  "Potential Burgers Equation"->{
    Cell[31866, 920, 96, 1, 49, "Subsection",
      CellTags->"Potential Burgers Equation"]},
  "potential Burgers equation"->{
    Cell[31965, 923, 552, 11, 96, "Text",
      CellTags->{
      "nonlinear dynamics", "potential Burgers equation", "prolongation"}]},
  "dispersion strength"->{
    Cell[32647, 941, 260, 4, 54, "Text",
      CellTags->"dispersion strength"]},
  "Korteweg de Vries Equations"->{
    Cell[35587, 1033, 158, 2, 49, "Subsection",
      CellTags->{
      "Korteweg de Vries Equations", 
        "Generalized Korteweg de Vries Equations"}]},
  "Generalized Korteweg de Vries Equations"->{
    Cell[35587, 1033, 158, 2, 49, "Subsection",
      CellTags->{
      "Korteweg de Vries Equations", 
        "Generalized Korteweg de Vries Equations"}]},
  "KdV-Burgers equation"->{
    Cell[35748, 1037, 377, 7, 96, "Text",
      CellTags->"KdV-Burgers equation"]},
  "cylindrical geometry"->{
    Cell[36324, 1052, 1272, 35, 138, "Text",
      CellTags->{
      "cylindrical geometry", "spherical geometry", "Burgers equation", 
        "KdV equation", "Baecklund[]"}]},
  "spherical geometry"->{
    Cell[36324, 1052, 1272, 35, 138, "Text",
      CellTags->{
      "cylindrical geometry", "spherical geometry", "Burgers equation", 
        "KdV equation", "Baecklund[]"}]},
  "Burgers equation"->{
    Cell[36324, 1052, 1272, 35, 138, "Text",
      CellTags->{
      "cylindrical geometry", "spherical geometry", "Burgers equation", 
        "KdV equation", "Baecklund[]"}]},
  "KdV equation"->{
    Cell[36324, 1052, 1272, 35, 138, "Text",
      CellTags->{
      "cylindrical geometry", "spherical geometry", "Burgers equation", 
        "KdV equation", "Baecklund[]"}]},
  "generalized symmetry"->{
    Cell[39037, 1134, 462, 9, 96, "Text",
      CellTags->{"generalized symmetry", "KdVB equation"}]},
  "KdVB equation"->{
    Cell[39037, 1134, 462, 9, 96, "Text",
      CellTags->{"generalized symmetry", "KdVB equation"}]},
  "Hirota and Satsuma equation"->{
    Cell[41125, 1196, 558, 12, 96, "Text",
      CellTags->"Hirota and Satsuma equation"]},
  "Coupled System of Wave Equations"->{
    Cell[44715, 1301, 108, 1, 49, "Subsection",
      CellTags->"Coupled System of Wave Equations"]},
  "wave equations"->{
    Cell[44826, 1304, 792, 20, 117, "Text",
      CellTags->{"wave equations", "Baecklund[]"}]},
  "PDESolve[]"->{
    Cell[51765, 1499, 498, 11, 96, "Text",
      CellTags->{"characteristics", "PDESolve[]"}]},
  "Second-Order ODEs and the Euler-Lagrange equation"->{
    Cell[52520, 1522, 190, 6, 52, "Section",
      CellTags->"Second-Order ODEs and the Euler-Lagrange equation"]},
  "second order ODEs"->{
    Cell[52713, 1530, 161, 4, 54, "Text",
      CellTags->"second order ODEs"]},
  "Newton's equations"->{
    Cell[53143, 1544, 674, 18, 75, "Text",
      CellTags->{"Newton's equations", "Lagrange's equations"}]},
  "Lagrange's equations"->{
    Cell[53143, 1544, 674, 18, 75, "Text",
      CellTags->{"Newton's equations", "Lagrange's equations"}]},
  "calculus of variations"->{
    Cell[53820, 1564, 682, 18, 75, "Text",
      CellTags->{
      "calculus of variations", "Hamilton's principle", 
        "variation of a path"}]},
  "Hamilton's principle"->{
    Cell[53820, 1564, 682, 18, 75, "Text",
      CellTags->{
      "calculus of variations", "Hamilton's principle", 
        "variation of a path"}]},
  "variation of a path"->{
    Cell[53820, 1564, 682, 18, 75, "Text",
      CellTags->{
      "calculus of variations", "Hamilton's principle", 
        "variation of a path"}]},
  "Euler derivative"->{
    Cell[54681, 1589, 583, 14, 75, "Text",
      CellTags->{"Euler derivative", "Euler-Lagrange equations"}],
    Cell[56564, 1638, 1384, 34, 123, "Text",
      CellTags->{
      "variational derivative", "Euler derivative", 
        "generalized symmetries"}],
    Cell[77692, 2221, 184, 4, 54, "Text",
      CellTags->"Euler derivative"],
    Cell[206319, 6168, 158, 4, 33, "Text",
      CellTags->{"Euler derivative", "Lagrangian"}],
    Cell[831776, 23025, 279, 5, 54, "Text",
      CellTags->{"anharmonic potential", "Euler derivative", "Lagrangian"}]},
  "Euler-Lagrange equations"->{
    Cell[54681, 1589, 583, 14, 75, "Text",
      CellTags->{"Euler derivative", "Euler-Lagrange equations"}],
    Cell[67113, 1922, 215, 5, 26, "ListItem",
      CellTags->{"variational symmetries", "Euler-Lagrange equations"}],
    Cell[67331, 1929, 633, 10, 138, "Text",
      CellTags->{"Euler-Lagrange equations", "variational symmetries"}]},
  "variational derivative"->{
    Cell[56564, 1638, 1384, 34, 123, "Text",
      CellTags->{
      "variational derivative", "Euler derivative", 
        "generalized symmetries"}]},
  "Calculation of Generalized Symmetries"->{
    Cell[57973, 1676, 125, 1, 49, "Subsection",
      CellTags->"Calculation of Generalized Symmetries"]},
  "hidden symmetries"->{
    Cell[58101, 1679, 2828, 76, 264, "Text",
      CellTags->{"hidden symmetries", "generalized point transformations"}]},
  "generalized point transformations"->{
    Cell[58101, 1679, 2828, 76, 264, "Text",
      CellTags->{"hidden symmetries", "generalized point transformations"}]},
  "generalized vector field"->{
    Cell[60932, 1757, 158, 4, 33, "Text",
      CellTags->"generalized vector field"]},
  "evolutionary representation"->{
    Cell[62092, 1796, 495, 8, 96, "Text",
      CellTags->{"evolutionary representation", "prolongation"}]},
  "Lie point symmetries"->{
    Cell[63067, 1819, 648, 11, 138, "Text",
      CellTags->{
      "Lie point symmetries", "generalized symmetries", 
        "invariance condition"}]},
  "invariance condition"->{
    Cell[63067, 1819, 648, 11, 138, "Text",
      CellTags->{
      "Lie point symmetries", "generalized symmetries", 
        "invariance condition"}]},
  "determining equations for the characteristics"->{
    Cell[64420, 1851, 993, 21, 159, "Text",
      CellTags->{
      "determining equations for the characteristics", 
        "overdetermined system of equations"}]},
  "overdetermined system of equations"->{
    Cell[64420, 1851, 993, 21, 159, "Text",
      CellTags->{
      "determining equations for the characteristics", 
        "overdetermined system of equations"}]},
  "invariant solution"->{
    Cell[65416, 1874, 664, 15, 117, "Text",
      CellTags->{"Baecklund[]", "conservation laws", "invariant solution"}]},
  "Conservation laws"->{
    Cell[66117, 1894, 100, 2, 49, "Subsection",
      Evaluatable->False,
      CellTags->"Conservation laws"]},
  "variational symmetries"->{
    Cell[67113, 1922, 215, 5, 26, "ListItem",
      CellTags->{"variational symmetries", "Euler-Lagrange equations"}],
    Cell[67331, 1929, 633, 10, 138, "Text",
      CellTags->{"Euler-Lagrange equations", "variational symmetries"}],
    Cell[69854, 1996, 1014, 21, 159, "Text",
      CellTags->{
      "divergence formula", "integrals of motion", "Euler-Lagrange system", 
        "variational symmetries", "Baecklund[]"}]},
  "Noether's theorem"->{
    Cell[68287, 1950, 1209, 32, 139, "Text",
      CellTags->{
      "Noether's theorem", "Fr\[EAcute]chet derivative", 
        "evolutionary vector field", "variational symmetry", 
        "generalized symmetries", "conserved quantities"}],
    Cell[833157, 23065, 666, 11, 117, "Text",
      CellTags->{
      "generalized symmetries", "Noether's theorem", "Baecklund[]"}]},
  "Fr\[EAcute]chet derivative"->{
    Cell[68287, 1950, 1209, 32, 139, "Text",
      CellTags->{
      "Noether's theorem", "Fr\[EAcute]chet derivative", 
        "evolutionary vector field", "variational symmetry", 
        "generalized symmetries", "conserved quantities"}]},
  "evolutionary vector field"->{
    Cell[68287, 1950, 1209, 32, 139, "Text",
      CellTags->{
      "Noether's theorem", "Fr\[EAcute]chet derivative", 
        "evolutionary vector field", "variational symmetry", 
        "generalized symmetries", "conserved quantities"}]},
  "variational symmetry"->{
    Cell[68287, 1950, 1209, 32, 139, "Text",
      CellTags->{
      "Noether's theorem", "Fr\[EAcute]chet derivative", 
        "evolutionary vector field", "variational symmetry", 
        "generalized symmetries", "conserved quantities"}]},
  "conserved quantities"->{
    Cell[68287, 1950, 1209, 32, 139, "Text",
      CellTags->{
      "Noether's theorem", "Fr\[EAcute]chet derivative", 
        "evolutionary vector field", "variational symmetry", 
        "generalized symmetries", "conserved quantities"}],
    Cell[107171, 3127, 608, 18, 75, "Text",
      CellTags->{"integral of motion", "conserved quantities"}]},
  "divergence formula"->{
    Cell[69854, 1996, 1014, 21, 159, "Text",
      CellTags->{
      "divergence formula", "integrals of motion", "Euler-Lagrange system", 
        "variational symmetries", "Baecklund[]"}]},
  "Euler-Lagrange system"->{
    Cell[69854, 1996, 1014, 21, 159, "Text",
      CellTags->{
      "divergence formula", "integrals of motion", "Euler-Lagrange system", 
        "variational symmetries", "Baecklund[]"}]},
  "Algorithm for conservation laws of second-order ODEs"->{
    Cell[70917, 2023, 196, 6, 52, "Section",
      CellTags->"Algorithm for conservation laws of second-order ODEs"]},
  "algorithm"->{
    Cell[71116, 2031, 338, 8, 54, "Text",
      CellTags->"algorithm"]},
  "prolongation operator"->{
    Cell[71457, 2041, 370, 10, 45, "ListItem",
      CellTags->"prolongation operator"]},
  "Solve[]"->{
    Cell[71830, 2053, 773, 24, 83, "ListItem",
      CellTags->"Solve[]"],
    Cell[73705, 2110, 855, 17, 159, "Text",
      CellTags->"Solve[]"]},
  "polynomial"->{
    Cell[73307, 2100, 395, 8, 64, "ListItem",
      CellTags->"polynomial"]},
  "Examples for second-order ODEs"->{
    Cell[74597, 2132, 152, 6, 52, "Section",
      CellTags->"Examples for second-order ODEs"]},
  "H\[EAcute]non-Heiles model"->{
    Cell[74752, 2140, 383, 8, 75, "Text",
      CellTags->{
      "H\[EAcute]non-Heiles model", "quartic anharmonic oscillator", 
        "two ions in a Paul trap", "Paul trap"}]},
  "quartic anharmonic oscillator"->{
    Cell[74752, 2140, 383, 8, 75, "Text",
      CellTags->{
      "H\[EAcute]non-Heiles model", "quartic anharmonic oscillator", 
        "two ions in a Paul trap", "Paul trap"}]},
  "two ions in a Paul trap"->{
    Cell[74752, 2140, 383, 8, 75, "Text",
      CellTags->{
      "H\[EAcute]non-Heiles model", "quartic anharmonic oscillator", 
        "two ions in a Paul trap", "Paul trap"}]},
  "Paul trap"->{
    Cell[74752, 2140, 383, 8, 75, "Text",
      CellTags->{
      "H\[EAcute]non-Heiles model", "quartic anharmonic oscillator", 
        "two ions in a Paul trap", "Paul trap"}],
    Cell[326599, 9726, 1383, 26, 195, "Text",
      CellTags->{
      "ion trapping", "Paul trap", "high frequency rf field", 
        "magnetic field", "statistical mean", "Newton's equation"}],
    Cell[848097, 23484, 783, 15, 138, "Text",
      CellTags->{
      "Runge-Lenz vector", "Paul trap", "phase space", "regular motion"}]},
  "The Henon-Heiles model"->{
    Cell[75160, 2152, 96, 1, 49, "Subsection",
      CellTags->"The Henon-Heiles model"]},
  "gravitating stars"->{
    Cell[75259, 2155, 684, 13, 117, "Text",
      CellTags->{
      "gravitating stars", "regular and chaotic motion", 
        "regular motion of the H\[EAcute]non-Heiles system"}]},
  "regular and chaotic motion"->{
    Cell[75259, 2155, 684, 13, 117, "Text",
      CellTags->{
      "gravitating stars", "regular and chaotic motion", 
        "regular motion of the H\[EAcute]non-Heiles system"}]},
  "regular motion of the H\[EAcute]non-Heiles system"->{
    Cell[75259, 2155, 684, 13, 117, "Text",
      CellTags->{
      "gravitating stars", "regular and chaotic motion", 
        "regular motion of the H\[EAcute]non-Heiles system"}]},
  "total energy"->{
    Cell[76208, 2179, 765, 21, 117, "Text",
      CellTags->{"total energy", "symbolic solution", "Lagrangian"}],
    Cell[104871, 3060, 1854, 51, 117, "Text",
      CellTags->{"characteristics", "total energy"}]},
  "symbolic solution"->{
    Cell[76208, 2179, 765, 21, 117, "Text",
      CellTags->{"total energy", "symbolic solution", "Lagrangian"}]},
  "Lagrangian"->{
    Cell[76208, 2179, 765, 21, 117, "Text",
      CellTags->{"total energy", "symbolic solution", "Lagrangian"}],
    Cell[205299, 6137, 567, 16, 54, "Text",
      CellTags->{"Lagrange's dynamic", "Lagrangian"}],
    Cell[206319, 6168, 158, 4, 33, "Text",
      CellTags->{"Euler derivative", "Lagrangian"}],
    Cell[830835, 22998, 228, 5, 54, "Text",
      CellTags->{"relative ion motion", "Lagrangian"}],
    Cell[831776, 23025, 279, 5, 54, "Text",
      CellTags->{"anharmonic potential", "Euler derivative", "Lagrangian"}]},
  "chaotic evolution"->{
    Cell[78690, 2252, 1230, 33, 159, "Text",
      CellTags->{
      "chaotic evolution", "integrals of motion", "Baecklund[]"}]},
  "parameter combinations"->{
    Cell[104120, 3039, 305, 5, 75, "Text",
      CellTags->{"parameter combinations", "integral of motion"}]},
  "integral of motion"->{
    Cell[104120, 3039, 305, 5, 75, "Text",
      CellTags->{"parameter combinations", "integral of motion"}],
    Cell[107171, 3127, 608, 18, 75, "Text",
      CellTags->{"integral of motion", "conserved quantities"}]},
  "AnsatzPoly"->{
    Cell[107782, 3147, 1035, 24, 138, "Text",
      CellTags->{
      "AnsatzPoly", "Baecklund[]", "polynomial ansatz", 
        "integrals of motion"}]},
  "polynomial ansatz"->{
    Cell[107782, 3147, 1035, 24, 138, "Text",
      CellTags->{
      "AnsatzPoly", "Baecklund[]", "polynomial ansatz", 
        "integrals of motion"}]},
  "solution in implicit form"->{
    Cell[202735, 6080, 265, 5, 54, "Text",
      CellTags->{"characteristics", "solution in implicit form"}]},
  "Two-Dimensional Quartic Oszillators"->{
    Cell[203037, 6090, 114, 1, 49, "Subsection",
      CellTags->"Two-Dimensional Quartic Oszillators"]},
  "optical waves"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "fiber"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "fiber nonlinearity"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "stimulated Raman scattering"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "Brillouin scattering"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "cross-phase modulation"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "self-phase modulation"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "effective refractive index"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "intensity of a wave"->{
    Cell[203154, 6093, 948, 16, 159, "Text",
      CellTags->{
      "optical waves", "fiber", "fiber nonlinearity", 
        "stimulated Raman scattering", "Brillouin scattering", 
        "cross-phase modulation", "self-phase modulation", 
        "effective refractive index", "intensity of a wave"}]},
  "polarized waves"->{
    Cell[204105, 6111, 918, 16, 159, "Text",
      CellTags->{
      "polarized waves", "polarization-preserving fiber", 
        "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
        "Hamiltonian system", "chaos", "Hamiltonian"}]},
  "polarization-preserving fiber"->{
    Cell[204105, 6111, 918, 16, 159, "Text",
      CellTags->{
      "polarized waves", "polarization-preserving fiber", 
        "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
        "Hamiltonian system", "chaos", "Hamiltonian"}]},
  "coupled nonlinear Schr\[ODoubleDot]dinger equations"->{
    Cell[204105, 6111, 918, 16, 159, "Text",
      CellTags->{
      "polarized waves", "polarization-preserving fiber", 
        "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
        "Hamiltonian system", "chaos", "Hamiltonian"}]},
  "Hamiltonian system"->{
    Cell[204105, 6111, 918, 16, 159, "Text",
      CellTags->{
      "polarized waves", "polarization-preserving fiber", 
        "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
        "Hamiltonian system", "chaos", "Hamiltonian"}]},
  "chaos"->{
    Cell[204105, 6111, 918, 16, 159, "Text",
      CellTags->{
      "polarized waves", "polarization-preserving fiber", 
        "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
        "Hamiltonian system", "chaos", "Hamiltonian"}]},
  "Hamiltonian"->{
    Cell[204105, 6111, 918, 16, 159, "Text",
      CellTags->{
      "polarized waves", "polarization-preserving fiber", 
        "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
        "Hamiltonian system", "chaos", "Hamiltonian"}]},
  "Lagrange's dynamic"->{
    Cell[205299, 6137, 567, 16, 54, "Text",
      CellTags->{"Lagrange's dynamic", "Lagrangian"}]},
  "similarity reduction"->{
    Cell[208166, 6221, 393, 8, 75, "Text",
      CellTags->{"similarity reduction", "Baecklund[]"}]},
  "Two Ions in a Trap"->{
    Cell[326516, 9723, 80, 1, 49, "Subsection",
      CellTags->"Two Ions in a Trap"]},
  "ion trapping"->{
    Cell[326599, 9726, 1383, 26, 195, "Text",
      CellTags->{
      "ion trapping", "Paul trap", "high frequency rf field", 
        "magnetic field", "statistical mean", "Newton's equation"}]},
  "high frequency rf field"->{
    Cell[326599, 9726, 1383, 26, 195, "Text",
      CellTags->{
      "ion trapping", "Paul trap", "high frequency rf field", 
        "magnetic field", "statistical mean", "Newton's equation"}]},
  "magnetic field"->{
    Cell[326599, 9726, 1383, 26, 195, "Text",
      CellTags->{
      "ion trapping", "Paul trap", "high frequency rf field", 
        "magnetic field", "statistical mean", "Newton's equation"}]},
  "statistical mean"->{
    Cell[326599, 9726, 1383, 26, 195, "Text",
      CellTags->{
      "ion trapping", "Paul trap", "high frequency rf field", 
        "magnetic field", "statistical mean", "Newton's equation"}]},
  "Newton's equation"->{
    Cell[326599, 9726, 1383, 26, 195, "Text",
      CellTags->{
      "ion trapping", "Paul trap", "high frequency rf field", 
        "magnetic field", "statistical mean", "Newton's equation"}]},
  "hyperbolas of revolution"->{
    Cell[821273, 22736, 474, 11, 48, "Text",
      CellTags->{"hyperbolas of revolution", "electrostatic potential"}]},
  "electrostatic potential"->{
    Cell[821273, 22736, 474, 11, 48, "Text",
      CellTags->{"hyperbolas of revolution", "electrostatic potential"}]},
  "Coulomb repulsion"->{
    Cell[823098, 22793, 376, 7, 75, "Text",
      CellTags->{"Coulomb repulsion", "Coulomb force"}]},
  "Coulomb force"->{
    Cell[823098, 22793, 376, 7, 75, "Text",
      CellTags->{"Coulomb repulsion", "Coulomb force"}]},
  "photons"->{
    Cell[825070, 22840, 727, 15, 138, "Text",
      CellTags->{"photons", "classical equations of motion"}]},
  "classical equations of motion"->{
    Cell[825070, 22840, 727, 15, 138, "Text",
      CellTags->{"photons", "classical equations of motion"}]},
  "averaging method of Landau"->{
    Cell[827271, 22898, 1065, 25, 118, "Text",
      CellTags->{
      "averaging method of Landau", "center-of-mass coordinates", 
        "cylindrical coordinates"}]},
  "center-of-mass coordinates"->{
    Cell[827271, 22898, 1065, 25, 118, "Text",
      CellTags->{
      "averaging method of Landau", "center-of-mass coordinates", 
        "cylindrical coordinates"}]},
  "cylindrical coordinates"->{
    Cell[827271, 22898, 1065, 25, 118, "Text",
      CellTags->{
      "averaging method of Landau", "center-of-mass coordinates", 
        "cylindrical coordinates"}]},
  "secular frequencies"->{
    Cell[828829, 22939, 1629, 46, 159, "Text",
      CellTags->"secular frequencies"]},
  "relative ion motion"->{
    Cell[830835, 22998, 228, 5, 54, "Text",
      CellTags->{"relative ion motion", "Lagrangian"}]},
  "anharmonic potential"->{
    Cell[831776, 23025, 279, 5, 54, "Text",
      CellTags->{"anharmonic potential", "Euler derivative", "Lagrangian"}]},
  "Runge-Lenz vector"->{
    Cell[848097, 23484, 783, 15, 138, "Text",
      CellTags->{
      "Runge-Lenz vector", "Paul trap", "phase space", "regular motion"}]},
  "phase space"->{
    Cell[848097, 23484, 783, 15, 138, "Text",
      CellTags->{
      "Runge-Lenz vector", "Paul trap", "phase space", "regular motion"}]},
  "regular motion"->{
    Cell[848097, 23484, 783, 15, 138, "Text",
      CellTags->{
      "Runge-Lenz vector", "Paul trap", "phase space", "regular motion"}]},
  "Kepler problem"->{
    Cell[848883, 23501, 874, 20, 117, "Text",
      CellTags->"Kepler problem"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Generalized Symmetries of Partial Differential Equations", 852569, \
23596},
  {"Introduction", 852953, 23603},
  {"classical method", 853319, 23611},
  {"non-classical method", 853520, 23616},
  {"point transformations", 853722, 23621},
  {"contact transformations", 853926, 23626},
  {"variational principle", 854356, 23636},
  {"symmetry group method", 854615, 23642},
  {"conservation laws", 854870, 23648},
  {"invariance properties", 855250, 23656},
  {"variational integral", 855508, 23662},
  {"integrals of motion", 855765, 23668},
  {"nonlinear dynamics", 856572, 23686},
  {"generalized method of Lie's classical theory", 856899, 23693},
  {"Elements of Generalized Symmetries", 857089, 23698},
  {"algorithm of generalized symmetries", 857231, 23701},
  {"point symmetries", 857355, 23704},
  {"non-classical symmetries", 857535, 23709},
  {"potential symmetries", 857711, 23714},
  {"infinitesimal transformations", 857896, 23719},
  {"transformation of the dependent variables", 858037, 23722},
  {"characteristic", 858163, 23725},
  {"infinitesimals", 858511, 23733},
  {"determination of the characteristics", 858653, 23736},
  {"prolongation", 858774, 23739},
  {"solution manifold", 859222, 23750},
  {"linear coupled PDEs for the characteristics", 859412, 23754},
  {"Algorithm for the Calculation of Generalized Symmetries", 859614, 23758},
  {"algorithm of calculating generalized symmetries", 859790, 23761},
  {"characteristics", 859923, 23764},
  {"redundant information", 860625, 23779},
  {"determining equations", 860768, 23783},
  {"Baecklund[]", 861012, 23789},
  {"Examples", 862626, 23824},
  {"Diffusion equation", 862726, 23827},
  {"diffusion equation", 862838, 23830},
  {"generalized symmetries of first order", 862983, 23833},
  {"second-order generalized symmetries", 863255, 23839},
  {"CharExpression", 863506, 23845},
  {"generalized symmetries", 863616, 23848},
  {"Potential Burgers Equation", 864504, 23869},
  {"potential Burgers equation", 864632, 23872},
  {"dispersion strength", 864796, 23876},
  {"Korteweg de Vries Equations", 864913, 23879},
  {"Generalized Korteweg de Vries Equations", 865118, 23884},
  {"KdV-Burgers equation", 865304, 23889},
  {"cylindrical geometry", 865416, 23892},
  {"spherical geometry", 865620, 23897},
  {"Burgers equation", 865822, 23902},
  {"KdV equation", 866020, 23907},
  {"generalized symmetry", 866226, 23912},
  {"KdVB equation", 866350, 23915},
  {"Hirota and Satsuma equation", 866488, 23918},
  {"Coupled System of Wave Equations", 866620, 23921},
  {"wave equations", 866744, 23924},
  {"PDESolve[]", 866859, 23927},
  {"Second-Order ODEs and the Euler-Lagrange equation", 867012, 23930},
  {"second order ODEs", 867153, 23933},
  {"Newton's equations", 867260, 23936},
  {"Lagrange's equations", 867397, 23939},
  {"calculus of variations", 867536, 23942},
  {"Hamilton's principle", 867716, 23947},
  {"variation of a path", 867895, 23952},
  {"Euler derivative", 868071, 23957},
  {"Euler-Lagrange equations", 868662, 23970},
  {"variational derivative", 869039, 23977},
  {"Calculation of Generalized Symmetries", 869237, 23982},
  {"hidden symmetries", 869369, 23985},
  {"generalized point transformations", 869533, 23988},
  {"generalized vector field", 869688, 23991},
  {"evolutionary representation", 869811, 23994},
  {"Lie point symmetries", 869948, 23997},
  {"invariance condition", 870130, 24002},
  {"determining equations for the characteristics", 870337, 24007},
  {"overdetermined system of equations", 870546, 24012},
  {"invariant solution", 870739, 24017},
  {"Conservation laws", 870886, 24020},
  {"variational symmetries", 871029, 24024},
  {"Noether's theorem", 871482, 24033},
  {"Fr\[EAcute]chet derivative", 871894, 24042},
  {"evolutionary vector field", 872171, 24048},
  {"variational symmetry", 872443, 24054},
  {"conserved quantities", 872715, 24060},
  {"divergence formula", 873094, 24068},
  {"Euler-Lagrange system", 873315, 24073},
  {"Algorithm for conservation laws of second-order ODEs", 873567, 24078},
  {"algorithm", 873703, 24081},
  {"prolongation operator", 873805, 24084},
  {"Solve[]", 873910, 24087},
  {"polynomial", 874076, 24092},
  {"Examples for second-order ODEs", 874192, 24095},
  {"H\[EAcute]non-Heiles model", 874323, 24098},
  {"quartic anharmonic oscillator", 874541, 24103},
  {"two ions in a Paul trap", 874753, 24108},
  {"Paul trap", 874951, 24113},
  {"The Henon-Heiles model", 875497, 24125},
  {"gravitating stars", 875613, 24128},
  {"regular and chaotic motion", 875831, 24133},
  {"regular motion of the H\[EAcute]non-Heiles system", 876072, 24138},
  {"total energy", 876276, 24143},
  {"symbolic solution", 876516, 24148},
  {"Lagrangian", 876649, 24151},
  {"chaotic evolution", 877205, 24162},
  {"parameter combinations", 877366, 24166},
  {"integral of motion", 877503, 24169},
  {"AnsatzPoly", 877741, 24174},
  {"polynomial ansatz", 877921, 24179},
  {"solution in implicit form", 878109, 24184},
  {"Two-Dimensional Quartic Oszillators", 878263, 24187},
  {"optical waves", 878390, 24190},
  {"fiber", 878709, 24197},
  {"fiber nonlinearity", 879041, 24204},
  {"stimulated Raman scattering", 879382, 24211},
  {"Brillouin scattering", 879716, 24218},
  {"cross-phase modulation", 880052, 24225},
  {"self-phase modulation", 880387, 24232},
  {"effective refractive index", 880727, 24239},
  {"intensity of a wave", 881060, 24246},
  {"polarized waves", 881389, 24253},
  {"polarization-preserving fiber", 881669, 24259},
  {"coupled nonlinear Schr\[ODoubleDot]dinger equations", 881971, 24265},
  {"Hamiltonian system", 882240, 24271},
  {"chaos", 882496, 24277},
  {"Hamiltonian", 882758, 24283},
  {"Lagrange's dynamic", 883027, 24289},
  {"similarity reduction", 883155, 24292},
  {"Two Ions in a Trap", 883283, 24295},
  {"ion trapping", 883391, 24298},
  {"high frequency rf field", 883619, 24303},
  {"magnetic field", 883838, 24308},
  {"statistical mean", 884059, 24313},
  {"Newton's equation", 884281, 24318},
  {"hyperbolas of revolution", 884510, 24323},
  {"electrostatic potential", 884661, 24326},
  {"Coulomb repulsion", 884806, 24329},
  {"Coulomb force", 884929, 24332},
  {"photons", 885046, 24335},
  {"classical equations of motion", 885193, 24338},
  {"averaging method of Landau", 885337, 24341},
  {"center-of-mass coordinates", 885541, 24346},
  {"cylindrical coordinates", 885742, 24351},
  {"secular frequencies", 885939, 24356},
  {"relative ion motion", 886054, 24359},
  {"anharmonic potential", 886183, 24362},
  {"Runge-Lenz vector", 886330, 24365},
  {"phase space", 886489, 24369},
  {"regular motion", 886651, 24373},
  {"Kepler problem", 886813, 24377}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 373, 5, 117, "ChapterLine",
  CounterAssignments->{{"Title", 8}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Generalized Symmetries of Partial Differential Equations"],
Cell[2115, 58, 316, 4, 193, "Title",
  CounterAssignments->{{"Title", 8}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}}],

Cell[CellGroupData[{
Cell[2456, 66, 354, 10, 52, "Section",
  Evaluatable->False,
  CounterAssignments->{{"Title", 9}, {"SubTitle", 0}, {"SubSubTitle", 0}, {
      "Section", 0}, {"SubSection", 0}, {"SubSubSection", 0}, {
      "NumberedEquation", 0}, {"NumberedFigure", 0}, {"NumberedTable", 0}},
  CellTags->"Introduction"],
Cell[2813, 78, 893, 15, 180, "Text",
  CellTags->{
  "classical method", "non-classical method", "point transformations", 
    "contact transformations"}],
Cell[3709, 95, 1319, 23, 222, "Text",
  CellTags->{
  "variational principle", "symmetry group method", "conservation laws", 
    "invariance properties", "variational integral", "integrals of motion"}],
Cell[5031, 120, 635, 12, 117, "Text",
  CellTags->{
  "nonlinear dynamics", "generalized method of Lie's classical theory"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5703, 137, 160, 6, 52, "Section",
  CellTags->"Elements of Generalized Symmetries"],
Cell[5866, 145, 1285, 37, 138, "Text",
  CellTags->"algorithm of generalized symmetries"],
Cell[7154, 184, 251, 6, 31, "NumberedEquation"],
Cell[7408, 192, 536, 23, 54, "Text"],
Cell[7947, 217, 458, 8, 96, "Text",
  CellTags->{
  "point symmetries", "non-classical symmetries", "potential symmetries"}],
Cell[8408, 227, 137, 3, 33, "Text"],
Cell[8548, 232, 129, 3, 30, "NumberedEquation"],
Cell[8680, 237, 124, 3, 30, "NumberedEquation"],
Cell[8807, 242, 543, 12, 96, "Text"],
Cell[9353, 256, 334, 6, 63, "NumberedEquation"],
Cell[9690, 264, 432, 13, 75, "Text"],
Cell[10125, 279, 238, 5, 46, "NumberedEquation"],
Cell[10366, 286, 241, 5, 46, "NumberedEquation"],
Cell[10610, 293, 155, 4, 33, "Text",
  CellTags->"infinitesimal transformations"],
Cell[10768, 299, 307, 7, 31, "NumberedEquation"],
Cell[11078, 308, 320, 7, 31, "NumberedEquation"],
Cell[11401, 317, 328, 5, 75, "Text"],
Cell[11732, 324, 207, 4, 29, "NumberedEquation"],
Cell[11942, 330, 483, 11, 55, "NumberedEquation"],
Cell[12428, 343, 333, 8, 54, "Text",
  CellTags->"transformation of the dependent variables"],
Cell[12764, 353, 216, 4, 55, "NumberedEquation"],
Cell[12983, 359, 520, 16, 54, "Text",
  CellTags->{"characteristic", "infinitesimals"}],
Cell[13506, 377, 311, 7, 55, "NumberedEquation"],
Cell[13820, 386, 684, 16, 117, "Text",
  CellTags->"determination of the characteristics"],
Cell[14507, 404, 176, 4, 30, "NumberedEquation"],
Cell[14686, 410, 312, 9, 54, "Text",
  CellTags->"prolongation"],
Cell[15001, 421, 330, 8, 55, "NumberedEquation"],
Cell[15334, 431, 1313, 33, 159, "Text",
  CellTags->{
  "solution manifold", "linear coupled PDEs for the characteristics"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16684, 469, 198, 6, 52, "Section",
  CellTags->"Algorithm for the Calculation of Generalized Symmetries"],
Cell[16885, 477, 243, 5, 54, "Text",
  CellTags->"algorithm of calculating generalized symmetries"],
Cell[17131, 484, 242, 9, 26, "ListItem",
  Evaluatable->False,
  CellTags->"prolongation"],
Cell[17376, 495, 143, 3, 30, "NumberedEquation",
  Evaluatable->False],
Cell[17522, 500, 194, 6, 26, "ListItem",
  CellTags->"characteristics"],
Cell[17719, 508, 218, 6, 26, "ListItem",
  Evaluatable->False,
  CellTags->"redundant information"],
Cell[17940, 516, 188, 4, 30, "NumberedEquation"],
Cell[18131, 522, 566, 19, 45, "ListItem",
  Evaluatable->False,
  CellTags->"determining equations"],
Cell[18700, 543, 112, 2, 26, "ListItem",
  Evaluatable->False],
Cell[18815, 547, 1640, 38, 243, "Text",
  CellTags->{"Baecklund[]", "characteristics"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20492, 590, 108, 6, 52, "Section",
  CellTags->"Examples"],
Cell[20603, 598, 221, 5, 54, "Text"],

Cell[CellGroupData[{
Cell[20849, 607, 80, 1, 49, "Subsection",
  CellTags->"Diffusion equation"],
Cell[20932, 610, 965, 17, 180, "Text",
  CellTags->{"diffusion equation", "Baecklund[]"}],

Cell[CellGroupData[{
Cell[21922, 631, 206, 4, 45, "Input"],
Cell[22131, 637, 1370, 41, 61, "Output"]
}, Open  ]],
Cell[23516, 681, 1120, 21, 180, "Text",
  CellTags->{
  "characteristic", "Baecklund[]", "generalized symmetries of first order", 
    "contact transformations", "second-order generalized symmetries"}],

Cell[CellGroupData[{
Cell[24661, 706, 209, 4, 45, "Input"],
Cell[24873, 712, 2305, 67, 115, "Output"]
}, Open  ]],
Cell[27193, 782, 1263, 35, 159, "Text",
  CellTags->"CharExpression"],

Cell[CellGroupData[{
Cell[28481, 821, 1337, 33, 63, "Input"],
Cell[29821, 856, 235, 4, 76, "Output"]
}, Open  ]],
Cell[30071, 863, 319, 8, 75, "Text"],

Cell[CellGroupData[{
Cell[30415, 875, 255, 5, 45, "Input"],
Cell[30673, 882, 322, 10, 30, "Output"]
}, Open  ]],
Cell[31010, 895, 819, 20, 138, "Text",
  CellTags->"generalized symmetries"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31866, 920, 96, 1, 49, "Subsection",
  CellTags->"Potential Burgers Equation"],
Cell[31965, 923, 552, 11, 96, "Text",
  CellTags->{
  "nonlinear dynamics", "potential Burgers equation", "prolongation"}],
Cell[32520, 936, 124, 3, 30, "NumberedEquation"],
Cell[32647, 941, 260, 4, 54, "Text",
  CellTags->"dispersion strength"],

Cell[CellGroupData[{
Cell[32932, 949, 297, 6, 45, "Input"],
Cell[33232, 957, 1243, 38, 63, "Output"]
}, Open  ]],
Cell[34490, 998, 1060, 30, 117, "Text",
  CellTags->"Baecklund[]"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35587, 1033, 158, 2, 49, "Subsection",
  CellTags->{
  "Korteweg de Vries Equations", "Generalized Korteweg de Vries Equations"}],
Cell[35748, 1037, 377, 7, 96, "Text",
  CellTags->"KdV-Burgers equation"],
Cell[36128, 1046, 193, 4, 43, "NumberedEquation"],
Cell[36324, 1052, 1272, 35, 138, "Text",
  CellTags->{
  "cylindrical geometry", "spherical geometry", "Burgers equation", 
    "KdV equation", "Baecklund[]"}],

Cell[CellGroupData[{
Cell[37621, 1091, 476, 9, 98, "Input"],
Cell[38100, 1102, 922, 29, 47, "Output"]
}, Open  ]],
Cell[39037, 1134, 462, 9, 96, "Text",
  CellTags->{"generalized symmetry", "KdVB equation"}],
Cell[39502, 1145, 221, 6, 29, "NumberedEquation"],
Cell[39726, 1153, 476, 12, 75, "Text"],

Cell[CellGroupData[{
Cell[40227, 1169, 450, 8, 80, "Input"],
Cell[40680, 1179, 430, 14, 30, "Output"]
}, Open  ]],
Cell[41125, 1196, 558, 12, 96, "Text",
  CellTags->"Hirota and Satsuma equation"],
Cell[41686, 1210, 473, 13, 29, "NumberedEquation"],
Cell[42162, 1225, 146, 3, 29, "NumberedEquation"],
Cell[42311, 1230, 105, 1, 33, "Text",
  CellTags->"generalized symmetries"],

Cell[CellGroupData[{
Cell[42441, 1235, 493, 9, 81, "Input"],
Cell[42937, 1246, 1494, 43, 93, "Output"]
}, Open  ]],
Cell[44446, 1292, 232, 4, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44715, 1301, 108, 1, 49, "Subsection",
  CellTags->"Coupled System of Wave Equations"],
Cell[44826, 1304, 792, 20, 117, "Text",
  CellTags->{"wave equations", "Baecklund[]"}],
Cell[45621, 1326, 91, 1, 28, "NumberedEquation"],
Cell[45715, 1329, 85, 1, 28, "NumberedEquation"],
Cell[45803, 1332, 25, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[45853, 1336, 341, 6, 63, "Input"],
Cell[46197, 1344, 5553, 152, 199, "Output"]
}, Open  ]],
Cell[51765, 1499, 498, 11, 96, "Text",
  CellTags->{"characteristics", "PDESolve[]"}],
Cell[52266, 1512, 205, 4, 54, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52520, 1522, 190, 6, 52, "Section",
  CellTags->"Second-Order ODEs and the Euler-Lagrange equation"],
Cell[52713, 1530, 161, 4, 54, "Text",
  CellTags->"second order ODEs"],
Cell[52877, 1536, 263, 6, 31, "NumberedEquation"],
Cell[53143, 1544, 674, 18, 75, "Text",
  CellTags->{"Newton's equations", "Lagrange's equations"}],
Cell[53820, 1564, 682, 18, 75, "Text",
  CellTags->{
  "calculus of variations", "Hamilton's principle", "variation of a path"}],
Cell[54505, 1584, 173, 3, 46, "NumberedEquation"],
Cell[54681, 1589, 583, 14, 75, "Text",
  CellTags->{"Euler derivative", "Euler-Lagrange equations"}],
Cell[55267, 1605, 1294, 31, 48, "NumberedEquation"],
Cell[56564, 1638, 1384, 34, 123, "Text",
  CellTags->{
  "variational derivative", "Euler derivative", "generalized symmetries"}],

Cell[CellGroupData[{
Cell[57973, 1676, 125, 1, 49, "Subsection",
  CellTags->"Calculation of Generalized Symmetries"],
Cell[58101, 1679, 2828, 76, 264, "Text",
  CellTags->{"hidden symmetries", "generalized point transformations"}],
Cell[60932, 1757, 158, 4, 33, "Text",
  CellTags->"generalized vector field"],
Cell[61093, 1763, 221, 5, 56, "NumberedEquation"],
Cell[61317, 1770, 612, 18, 54, "Text",
  CellTags->"characteristics"],
Cell[61932, 1790, 157, 4, 56, "NumberedEquation"],
Cell[62092, 1796, 495, 8, 96, "Text",
  CellTags->{"evolutionary representation", "prolongation"}],
Cell[62590, 1806, 474, 11, 65, "NumberedEquation"],
Cell[63067, 1819, 648, 11, 138, "Text",
  CellTags->{
  "Lie point symmetries", "generalized symmetries", "invariance condition"}],
Cell[63718, 1832, 699, 17, 37, "NumberedEquation"],
Cell[64420, 1851, 993, 21, 159, "Text",
  CellTags->{
  "determining equations for the characteristics", 
    "overdetermined system of equations"}],
Cell[65416, 1874, 664, 15, 117, "Text",
  CellTags->{"Baecklund[]", "conservation laws", "invariant solution"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[66117, 1894, 100, 2, 49, "Subsection",
  Evaluatable->False,
  CellTags->"Conservation laws"],
Cell[66220, 1898, 344, 7, 75, "Text"],
Cell[66567, 1907, 329, 6, 48, "NumberedEquation"],
Cell[66899, 1915, 50, 0, 33, "Text"],
Cell[66952, 1917, 158, 3, 26, "ListItem"],
Cell[67113, 1922, 215, 5, 26, "ListItem",
  CellTags->{"variational symmetries", "Euler-Lagrange equations"}],
Cell[67331, 1929, 633, 10, 138, "Text",
  CellTags->{"Euler-Lagrange equations", "variational symmetries"}],
Cell[67967, 1941, 317, 7, 31, "NumberedEquation"],
Cell[68287, 1950, 1209, 32, 139, "Text",
  CellTags->{
  "Noether's theorem", "Fr\[EAcute]chet derivative", 
    "evolutionary vector field", "variational symmetry", 
    "generalized symmetries", "conserved quantities"}],
Cell[69499, 1984, 352, 10, 56, "NumberedEquation"],
Cell[69854, 1996, 1014, 21, 159, "Text",
  CellTags->{
  "divergence formula", "integrals of motion", "Euler-Lagrange system", 
    "variational symmetries", "Baecklund[]"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[70917, 2023, 196, 6, 52, "Section",
  CellTags->"Algorithm for conservation laws of second-order ODEs"],
Cell[71116, 2031, 338, 8, 54, "Text",
  CellTags->"algorithm"],
Cell[71457, 2041, 370, 10, 45, "ListItem",
  CellTags->"prolongation operator"],
Cell[71830, 2053, 773, 24, 83, "ListItem",
  CellTags->"Solve[]"],
Cell[72606, 2079, 408, 11, 45, "ListItem",
  CellTags->{"determining equations", "characteristics"}],
Cell[73017, 2092, 287, 6, 64, "ListItem"],
Cell[73307, 2100, 395, 8, 64, "ListItem",
  CellTags->"polynomial"],
Cell[73705, 2110, 855, 17, 159, "Text",
  CellTags->"Solve[]"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74597, 2132, 152, 6, 52, "Section",
  CellTags->"Examples for second-order ODEs"],
Cell[74752, 2140, 383, 8, 75, "Text",
  CellTags->{
  "H\[EAcute]non-Heiles model", "quartic anharmonic oscillator", 
    "two ions in a Paul trap", "Paul trap"}],

Cell[CellGroupData[{
Cell[75160, 2152, 96, 1, 49, "Subsection",
  CellTags->"The Henon-Heiles model"],
Cell[75259, 2155, 684, 13, 117, "Text",
  CellTags->{
  "gravitating stars", "regular and chaotic motion", 
    "regular motion of the H\[EAcute]non-Heiles system"}],
Cell[75946, 2170, 123, 2, 29, "NumberedEquation"],
Cell[76072, 2174, 133, 3, 30, "NumberedEquation"],
Cell[76208, 2179, 765, 21, 117, "Text",
  CellTags->{"total energy", "symbolic solution", "Lagrangian"}],
Cell[76976, 2202, 713, 17, 44, "NumberedEquation"],
Cell[77692, 2221, 184, 4, 54, "Text",
  CellTags->"Euler derivative"],

Cell[CellGroupData[{
Cell[77901, 2229, 379, 7, 88, "Input"],
Cell[78283, 2238, 392, 11, 47, "Output"]
}, Open  ]],
Cell[78690, 2252, 1230, 33, 159, "Text",
  CellTags->{"chaotic evolution", "integrals of motion", "Baecklund[]"}],

Cell[CellGroupData[{
Cell[79945, 2289, 340, 7, 63, "Input"],
Cell[80288, 2298, 23817, 738, 815, "Output"]
}, Open  ]],
Cell[104120, 3039, 305, 5, 75, "Text",
  CellTags->{"parameter combinations", "integral of motion"}],

Cell[CellGroupData[{
Cell[104450, 3048, 115, 2, 27, "Input"],
Cell[104568, 3052, 288, 5, 68, "Output"]
}, Open  ]],
Cell[104871, 3060, 1854, 51, 117, "Text",
  CellTags->{"characteristics", "total energy"}],

Cell[CellGroupData[{
Cell[106750, 3115, 115, 2, 27, "Input"],
Cell[106868, 3119, 288, 5, 68, "Output"]
}, Open  ]],
Cell[107171, 3127, 608, 18, 75, "Text",
  CellTags->{"integral of motion", "conserved quantities"}],
Cell[107782, 3147, 1035, 24, 138, "Text",
  CellTags->{
  "AnsatzPoly", "Baecklund[]", "polynomial ansatz", "integrals of motion"}],

Cell[CellGroupData[{
Cell[108842, 3175, 340, 7, 63, "Input"],
Cell[109185, 3184, 93535, 2893, 3495, "Output"]
}, Open  ]],
Cell[202735, 6080, 265, 5, 54, "Text",
  CellTags->{"characteristics", "solution in implicit form"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[203037, 6090, 114, 1, 49, "Subsection",
  CellTags->"Two-Dimensional Quartic Oszillators"],
Cell[203154, 6093, 948, 16, 159, "Text",
  CellTags->{
  "optical waves", "fiber", "fiber nonlinearity", 
    "stimulated Raman scattering", "Brillouin scattering", 
    "cross-phase modulation", "self-phase modulation", 
    "effective refractive index", "intensity of a wave"}],
Cell[204105, 6111, 918, 16, 159, "Text",
  CellTags->{
  "polarized waves", "polarization-preserving fiber", 
    "coupled nonlinear Schr\[ODoubleDot]dinger equations", 
    "Hamiltonian system", "chaos", "Hamiltonian"}],
Cell[205026, 6129, 270, 6, 56, "NumberedEquation"],
Cell[205299, 6137, 567, 16, 54, "Text",
  CellTags->{"Lagrange's dynamic", "Lagrangian"}],
Cell[205869, 6155, 447, 11, 56, "NumberedEquation"],
Cell[206319, 6168, 158, 4, 33, "Text",
  CellTags->{"Euler derivative", "Lagrangian"}],

Cell[CellGroupData[{
Cell[206502, 6176, 793, 17, 83, "Input"],
Cell[207298, 6195, 853, 23, 77, "Output"]
}, Open  ]],
Cell[208166, 6221, 393, 8, 75, "Text",
  CellTags->{"similarity reduction", "Baecklund[]"}],

Cell[CellGroupData[{
Cell[208584, 6233, 402, 8, 45, "Input"],
Cell[208989, 6243, 117122, 3465, 3855, "Output"]
}, Open  ]],
Cell[326126, 9711, 353, 7, 75, "Text",
  CellTags->"integrals of motion"]
}, Open  ]],

Cell[CellGroupData[{
Cell[326516, 9723, 80, 1, 49, "Subsection",
  CellTags->"Two Ions in a Trap"],
Cell[326599, 9726, 1383, 26, 195, "Text",
  CellTags->{
  "ion trapping", "Paul trap", "high frequency rf field", "magnetic field", 
    "statistical mean", "Newton's equation"}],
Cell[327985, 9754, 493285, 12980, 303, 422939, 12107, "GraphicsData", \
"PostScript", "NumberedFigure"],
Cell[821273, 22736, 474, 11, 48, "Text",
  CellTags->{"hyperbolas of revolution", "electrostatic potential"}],
Cell[821750, 22749, 143, 3, 49, "NumberedEquation"],
Cell[821896, 22754, 742, 23, 96, "Text"],
Cell[822641, 22779, 454, 12, 49, "NumberedEquation"],
Cell[823098, 22793, 376, 7, 75, "Text",
  CellTags->{"Coulomb repulsion", "Coulomb force"}],
Cell[823477, 22802, 1590, 36, 53, "NumberedEquation"],
Cell[825070, 22840, 727, 15, 138, "Text",
  CellTags->{"photons", "classical equations of motion"}],
Cell[825800, 22857, 592, 13, 37, "NumberedEquation"],
Cell[826395, 22872, 158, 5, 37, "Text"],
Cell[826556, 22879, 712, 17, 49, "NumberedEquation"],
Cell[827271, 22898, 1065, 25, 118, "Text",
  CellTags->{
  "averaging method of Landau", "center-of-mass coordinates", 
    "cylindrical coordinates"}],
Cell[828339, 22925, 254, 5, 61, "NumberedEquation"],
Cell[828596, 22932, 230, 5, 61, "NumberedEquation"],
Cell[828829, 22939, 1629, 46, 159, "Text",
  CellTags->"secular frequencies"],
Cell[830461, 22987, 191, 4, 59, "NumberedEquation"],
Cell[830655, 22993, 177, 3, 56, "NumberedEquation"],
Cell[830835, 22998, 228, 5, 54, "Text",
  CellTags->{"relative ion motion", "Lagrangian"}],

Cell[CellGroupData[{
Cell[831088, 23007, 437, 9, 77, "Input"],
Cell[831528, 23018, 233, 4, 51, "Output"]
}, Open  ]],
Cell[831776, 23025, 279, 5, 54, "Text",
  CellTags->{"anharmonic potential", "Euler derivative", "Lagrangian"}],

Cell[CellGroupData[{
Cell[832080, 23034, 164, 3, 29, "Input"],
Cell[832247, 23039, 895, 23, 85, "Output"]
}, Open  ]],
Cell[833157, 23065, 666, 11, 117, "Text",
  CellTags->{"generalized symmetries", "Noether's theorem", "Baecklund[]"}],

Cell[CellGroupData[{
Cell[833848, 23080, 548, 10, 99, "Input"],
Cell[834399, 23092, 13411, 381, 305, "Output"]
}, Open  ]],
Cell[847825, 23476, 269, 6, 75, "Text"],
Cell[848097, 23484, 783, 15, 138, "Text",
  CellTags->{
  "Runge-Lenz vector", "Paul trap", "phase space", "regular motion"}],
Cell[848883, 23501, 874, 20, 117, "Text",
  CellTags->"Kepler problem"],
Cell[849760, 23523, 567, 11, 117, "Text"],
Cell[850330, 23536, 147, 3, 44, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

